﻿USE sofia;
DROP TABLE IF EXISTS sofia.nde_vpl;
CREATE TABLE nde_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nde_vpl WRITE;
INSERT INTO nde_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ekuqaleni uNkulunkulu wadala amazulu lomhlaba. ");
INSERT INTO nde_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Umhlaba wawungelasimo njalo ungelalutho, ubumnyama babengame phezulu kolwandle njalo uMoya kaNkulunkulu wayehambahamba phezu kwamanzi. ");
INSERT INTO nde_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ngakho uNkulunkulu wasesithi, “Akubekhona ukukhanya,” lakanye kwabakhona ukukhanya. ");
INSERT INTO nde_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","UNkulunkulu wabona ukuthi ukukhanya kwakukuhle, wasesehlukanisa ukukhanya lobumnyama. ");
INSERT INTO nde_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","UNkulunkulu wabiza ukukhanya ngokuthi “yimini,” ubumnyama wabubiza ngokuthi “yibusuku.” Ngakho kwabakhona ukuhlwa lokusa, kwaba lusuku lwakuqala. ");
INSERT INTO nde_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Njalo uNkulunkulu wathi, “Kakube lomkhandlu phakathi kwamanzi ukwehlukanisa amanzi kwamanye amanzi.” ");
INSERT INTO nde_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ngakho uNkulunkulu wehlukanisa amanzi angaphansi komkhandlu kulawo amanzi angaphezulu kwawo. Kwabanjalo. ");
INSERT INTO nde_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","UNkulunkulu wabiza umkhandlu lo ngokuthi “ngumkhathi.” Njalo kwabakhona ukuhlwa, kwabakhona njalo ukusa, usuku lwesibili. ");
INSERT INTO nde_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Njalo uNkulunkulu wathi, “Kakuthi amanzi angaphansi komkhathi abuthane ndawonye njalo kakuvele umhlabathi owomileyo.” Ngakho kwabanjalo. ");
INSERT INTO nde_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","UNkulunkulu wabiza umhlaba owomileyo ngokuthi “ngumhlabathi,” lamanzi abutheneyo wathi “lulwandle.” Njalo uNkulunkulu wabona ukuthi kwakukuhle. ");
INSERT INTO nde_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","UNkulunkulu wasesithi, “Umhlabathi kawuthele izimila: imlimela ethela intanga lezihlahla emhlabathini ezithela izithelo ezilentanga phakathi, kusiya ngemihlobo yazo ehlukeneyo.” Kwabanjalo. ");
INSERT INTO nde_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Umhlaba wathela izimila: izihlahla ezilentanga kusiya ngemihlobo yazo, lezihlahla ezithela izithelo ezilentanga phakathi kwazo kusiya ngemihlobo yazo. Njalo uNkulunkulu wabona ukuthi kwakukuhle. ");
INSERT INTO nde_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Kwabakhona njalo ukuhlwa lokusa, usuku lwesithathu. ");
INSERT INTO nde_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","UNkulunkulu wasesithi, “Akube lezibane emkhandlwini womkhathi ukwehlukanisa imini lobusuku, njalo zibe luphawu lokubonisa izigaba zomnyaka, lezinsuku leminyaka, ");
INSERT INTO nde_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","njalo zibe yizibane emkhandlwini womkhathi ukuletha ukukhanya emhlabeni.” Kwabanjalo. ");
INSERT INTO nde_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","UNkulunkulu wenza izibane ezimbili ezinkulu, isibane esikhulu ukubusa emini lesibane esincinyane ukubusa ebusuku. Wenza futhi lezinkanyezi. ");
INSERT INTO nde_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","UNkulunkulu wazibeka emkhandlwini womkhathi ukuletha ukukhanya emhlabeni, ");
INSERT INTO nde_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ukubusa imini lobusuku, kanye lokwahlukanisa ukukhanya lobumnyama. Njalo uNkulunkulu wabona ukuthi kwakukuhle. ");
INSERT INTO nde_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Njalo kwabakhona ukuhlwa lokusa, usuku lwesine. ");
INSERT INTO nde_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Njalo uNkulunkulu wathi, “Akube lezidalwa eziphilayo emanzini, njalo akuthi izinyoni ziphaphe ngaphezulu komhlaba zidabule emkhandlwini womkhathi.” ");
INSERT INTO nde_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Yikho uNkulunkulu wadala izidalwa ezinkulu zolwandle layo yonke into ephilayo lehambayo lenyakazelayo emanzini, kusiya ngemihlobo yazo, lezinyoni zonke ezilamaphiko, ngemihlobo yazo. Njalo uNkulunkulu wabona ukuthi kwakukuhle. ");
INSERT INTO nde_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","UNkulunkulu wazibusisa wathi, “Zalanani lande ngobunengi ligcwalise amanzi olwandle, njalo akuthi lezinyoni lazo zande emhlabeni.” ");
INSERT INTO nde_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Kwabakhona ukuhlwa, kwabakhona njalo lokusa, usuku lwesihlanu. ");
INSERT INTO nde_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","UNkulunkulu wabuya wathi, “Akuthi umhlaba uveze izidalwa eziphilayo kusiya ngemihlobo yazo: izinanakazana ezihuquzela emhlabathini, kanye lezinyamazana zeganga, yilezo kusiya ngemihlobo yazo.” Lakanye kwabanjalo. ");
INSERT INTO nde_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","UNkulunkulu wenza izinyamazana zeganga kusiya ngemihlobo yazo, izifuyo kusiya ngemihlobo yazo, njalo zonke izinanakazana ezihuquzela emhlabathini kusiya ngemihlobo yazo. Njalo uNkulunkulu wabona ukuthi kwakukuhle. ");
INSERT INTO nde_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","UNkulunkulu wasesithi, “Asenze umuntu ngesimo sethu langomfanekiso wethu ukuze abuse phezu kwenhlanzi zolwandle lezinyoni zemkhathini, phezu kwezifuyo, phezu kwawo wonke umhlaba laphezu kwazo zonke izinanakazana ezihuquzela emhlabathini.” ");
INSERT INTO nde_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ngakho uNkulunkulu wadala umuntu ngomfanekiso wakhe, ngomfanekiso kaNkulunkulu wabadala, owesilisa lowesifazane. ");
INSERT INTO nde_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","UNkulunkulu wababusisa wathi kubo, “Zalanani lande ngobunengi; liwugcwalise umhlaba, liwubuse. Busani phezu kwenhlanzi zolwandle lezinyoni zemkhathini laphezu kwezidalwa zonke ezihambayo emhlabathini.” ");
INSERT INTO nde_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","UNkulunkulu wasesithi, “Ngilinika zonke izihlahla ezithela intanga ezisemhlabeni wonke lazozonke izihlahla ezilezithelo ezilentanga phakathi. Zingezenu ukuba lizidle. ");
INSERT INTO nde_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Njalo nginika zonke izihlahla eziluhlaza kuzozonke izinyamazana zomhlaba lakuzo zonke izinyoni zemkhathini lakuzo zonke izidalwa ezihambayo emhlabathini, yonke into ephefumula impilo phakathi kwayo ukuba zibe yikudla kwazo.” Kwabanjalo. ");
INSERT INTO nde_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","UNkulunkulu wakubona konke lokho ayesekwenzile, njalo kwakukuhle kakhulu. Kwabakhona ukuhlwa lokusa, usuku lwesithupha. ");
INSERT INTO nde_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Kanjalo amazulu lomhlaba kwapheleliswa ngakho konke ukuhlotshiswa okukhulu. ");
INSERT INTO nde_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ngosuku lwesikhombisa uNkulunkulu wayesewuqedile umsebenzi ayewenza; ngakho wasephumula kuwo wonke umsebenzi wakhe. ");
INSERT INTO nde_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Njalo uNkulunkulu walubusisa usuku lwesikhombisa walwenza lwaba ngcwele ngoba waphumula kuwo wonke umsebenzi wokudala lokho ayesekwenzile. ");
INSERT INTO nde_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Lo ngumlando wamazulu lomhlaba ekudalweni kwakho, lapho uThixo uNkulunkulu enza khona umhlaba lamazulu. ");
INSERT INTO nde_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Kwakungakabi lesihlahlakazana seganga emhlabathini njalo kungakamili loba yini emila emhlabathini, ngoba uThixo uNkulunkulu wayengakanisi izulu emhlabeni, njalo kwakungelamuntu wokusebenza umhlabathi, ");
INSERT INTO nde_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","kodwa inkungu yayisenyuka emhlabathini, ithelele umhlabathi wonke. ");
INSERT INTO nde_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ngakho uThixo uNkulunkulu wasebumba umuntu ngothuli lomhlabathi, waphefumulela emakhaleni akhe umphefumulo wokuphila, umuntu wasesiba yisidalwa esiphilayo. ");
INSERT INTO nde_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ngalesosikhathi uThixo uNkulunkulu wayelungise isivande empumalanga, e-Edeni; wambeka khona umuntu ayembumbile. ");
INSERT INTO nde_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Njalo uThixo uNkulunkulu wenza yonke imihlobo yezihlahla ukuthi zikhule emhlabathini, izihlahla ezazibukeka emehlweni njalo zizinhle ekudleni. Phakathi laphakathi kwesivande kwakulesihlahla sokuphila lesihlahla sokwazi okuhle lokubi. ");
INSERT INTO nde_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Umfula owawuthelela isivande wawugeleza usuka e-Edeni; usuka lapho wehlukana waba yimifudlana emine. ");
INSERT INTO nde_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ibizo lowokuqala yiPhishoni; ozungeze lonke ilizwe laseHavila, lapho okulegolide khona. ");
INSERT INTO nde_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Igolide lalelolizwe lihle; amakha erezini le-onikisi lawo akhona.) ");
INSERT INTO nde_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ibizo lomfudlana wesibili yiGihoni; usekele kulolonke ilizwe laseKhushi. ");
INSERT INTO nde_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ibizo lomfudlana wesithathu yiThigrisi; ubhoda ngempumalanga kwe-Asiriya. Njalo umfudlana wesine yiYufrathe. ");
INSERT INTO nde_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Uthixo uNkulunkulu wamthatha umuntu wambeka eSivandeni se-Edeni ukuthi asisebenze njalo asinakekele. ");
INSERT INTO nde_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Njalo uThixo uNkulunkulu wamlaya umuntu wathi, “Ukhululekile ukudla loba yisiphi isihlahla esivandeni; ");
INSERT INTO nde_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","kodwa ungadli isihlahla sokwazi okuhle lokubi, ngoba ungaze usidle uzakufa ngempela.” ");
INSERT INTO nde_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","UThixo uNkulunkulu wathi, “Kakukuhle ukuba indoda ibe yodwa. Ngizayenzela umsizi oyifaneleyo.” ");
INSERT INTO nde_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","UThixo uNkulunkulu wayesezibumbile ngomhlabathi zonke izinyamazana zeganga lazozonke izinyoni zemoyeni. Waziletha emuntwini ukuthi aziphe amabizo; kwathi loba yiliphi ibizo asibiza ngalo isidalwa esiphilayo, kwaba yilo ibizo laso. ");
INSERT INTO nde_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ngakho umuntu wapha amabizo zonke izifuyo, lezinyoni zemkhathini lazozonke izinyamazana zeganga. Kodwa u-Adamu wayengelaye umsizi omfaneleyo. ");
INSERT INTO nde_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ngakho uThixo uNkulunkulu wenza indoda yalala ubuthongo bokufa; kwathi khonapho isalele wathatha olunye ubhambo lwendoda waseyivala leyondawo ngenyama. ");
INSERT INTO nde_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Emva kwalokho uThixo uNkulunkulu wasesenza umfazi ngobhambo ayeluthethe endodeni, wasemletha endodeni. ");
INSERT INTO nde_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Indoda yathi, “Lo manje uselithambo lamathambo ami lenyama yenyama yami; usezabizwa ngokuthi ‘mfazi,’ ngoba wakhitshwa endodeni.” ");
INSERT INTO nde_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ngalesisizatho indoda izatshiya uyise lonina imanyane lomkayo, babe nyamanye. ");
INSERT INTO nde_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Indoda lomkayo babehambaze, bengelazo inhloni. ");
INSERT INTO nde_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Inyoka yayiliqili ukwedlula zonke izinyamazana zeganga uThixo uNkulunkulu ayezenzile. Yathi kowesifazane, “Kambe uNkulunkulu watsho ngeqiniso ukuthi, ‘Lingadli noma yisiphi isihlahla esivandeni’?” ");
INSERT INTO nde_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Owesifazane wathi enyokeni, “Singadla izithelo zezihlahla esivandeni, ");
INSERT INTO nde_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","kodwa uNkulunkulu wathi, ‘Lingazidli izithelo zesihlahla esiphakathi laphakathi kwesivande, njalo lingasithinti, hlezi life.’ ” ");
INSERT INTO nde_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Inyoka yathi kowesifazane, “Kalisoze life ngempela. ");
INSERT INTO nde_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ngoba uNkulunkulu uyazi ukuthi lingasidla amehlo enu azavuleka, beselisiba njengoNkulunkulu, lazi okuhle lokubi.” ");
INSERT INTO nde_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Kwathi owesifazane ngokubona ukuthi izithelo zesihlahla leso zaziyikudla okuhle njalo zibukeka emehlweni, njalo kudingeka ukuzuza ukuhlakanipha, wakha ezinye wadla. Wapha njalo ezinye indoda yakhe ayelayo khonapho, layo yadla. ");
INSERT INTO nde_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Amehlo abo bobabili asevuleka, basebenanzelela ukuthi babenqunu; yikho basebethungela ndawonye amahlamvu omkhiwa bazenzela izembatho ngawo. ");
INSERT INTO nde_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Indoda lomkayo basebesizwa umsindo kaThixo uNkulunkulu ehamba esivandeni ilanga selithambeme, basebemcatshela uThixo uNkulunkulu phakathi kwezihlahla zesivande. ");
INSERT INTO nde_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Kodwa uThixo uNkulunkulu wayimemeza indoda wathi, “Ungaphi?” ");
INSERT INTO nde_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Yaphendula yathi, “Ngikuzwile esivandeni, ngesaba ngoba benginqunu; yikho ngasengicatsha.” ");
INSERT INTO nde_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Wasesithi, “Ngubani okutshelileyo ukuthi unqunu? Usudlile yini isihlahla engalilaya ukuthi lingasidli?” ");
INSERT INTO nde_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Indoda yathi, “Umfazi owangipha yena, ungiphile ezinye izithelo zesihlahla ngazidla.” ");
INSERT INTO nde_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ngakho uThixo uNkulunkulu wathi kowesifazane, “Kuyini lokhu osukwenzile na?” Owesifazane wathi, “Inyoka ingikhohlisile, ngadla.” ");
INSERT INTO nde_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ngakho uThixo uNkulunkulu wasesithi enyokeni, “Ngoba usukwenzile lokhu, Uqalekisiwe ngaphezu kwezifuyo zonke kanye lezinyamazana zonke zeganga! Uzahuba phansi ngesisu sakho njalo uzakudla uthuli zonke insuku zokuphila kwakho. ");
INSERT INTO nde_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Njalo ngizafaka ubutha phakathi kwakho lowesifazane, laphakathi kwenzalo yakho leyowesifazane; uzacobodisa ikhanda lakho, njalo wena uzagamula isithende sakhe.” ");
INSERT INTO nde_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Kowesifazane wathi, “Ngizakwandisa ngokuphindiweyo inhlungu zakho nxa ubeletha; ngobuhlungu uzazala abantwana. Inkanuko yakho izakuba sendodeni yakho, njalo yona izabusa phezu kwakho.” ");
INSERT INTO nde_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ku-Adamu wathi, “Ngoba ulalele umkakho wadla isihlahla engakulaya ngathi, ‘Ungasidli,’ Uqalekisiwe umhlabathi ngenxa yakho; ngokusebenza nzima uzakudla okuphuma kuwo zonke insuku zokuphila kwakho. ");
INSERT INTO nde_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Uzamila ameva lezihlahlakazana zameva azahlaba wena, njalo uzakudla izihlahla zeganga. ");
INSERT INTO nde_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ngezithukuthuku zebunzi lakho uzakudla ukudla kwakho uze ubuyele emhlabathini, njengoba wathathwa kuwo; ngoba uluthuli njalo uzabuyela othulini.” ");
INSERT INTO nde_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","U-Adamu wamutha umkakhe wathi ngu-Eva, ngoba wayezakuba ngunina wabo bonke abaphilayo. ");
INSERT INTO nde_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","UThixo uNkulunkulu wenza imvunulo yesikhumba, wenzela u-Adamu lomkakhe, wabagqokisa. ");
INSERT INTO nde_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Njalo uThixo uNkulunkulu wathi, “Umuntu manje usenjengomunye wethu, usekwazi okuhle lokubi. Kangavunyelwa ukuthi elule isandla sakhe akhe njalo isihlahla sokuphila adle, aphile laphakade.” ");
INSERT INTO nde_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ngakho uThixo uNkulunkulu wamxotsha eSivandeni se-Edeni ukuthi asebenze umhlabathi ayethethwe kuwo. ");
INSERT INTO nde_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Esemxotshile umuntu wamisa ngempumalanga kweSivande se-Edeni amakherubhi lenkemba ebhebhayo, iphazima isiyale lale ukulinda indlela eya esihlahleni sokuphila. ");
INSERT INTO nde_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","U-Adamu wembatha lomkakhe u-Eva, wasezithwala, wabeletha uKhayini. Wathi, “Ngosizo lukaThixo sengibelethe indoda.” ");
INSERT INTO nde_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Muva wabeletha umfowabo u-Abheli. U-Abheli waba ngumfuyi wemihlambi yezimvu, uKhayini yena wasebenza umhlabathi. ");
INSERT INTO nde_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ngokuya kwesikhathi uKhayini waletha ezinye izithelo zomhlabathi ukuba ngumnikelo kuThixo. ");
INSERT INTO nde_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Kodwa u-Abheli waletha izitho ezinonileyo zisuka kwamanye amazibulo omhlambi wakhe. UThixo wathokoza ngo-Abheli kanye lomnikelo wakhe, ");
INSERT INTO nde_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","kodwa kathokozanga ngoKhayini lomnikelo wakhe. Ngakho uKhayini wazonda kakhulu, lobuso bakhe bahloba. ");
INSERT INTO nde_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","UThixo wasesithi kuKhayini, “Uzondeleni na? Kungani ubuso bakho buhlobile? ");
INSERT INTO nde_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Nxa usenza okulungileyo, kawuyikwamukelwa yini? Kodwa nxa ungenzi okulungileyo, isono sikucathamele emnyango wakho; sinxwanele ukukuthumba, kodwa kumele usehlule.” ");
INSERT INTO nde_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","UKhayini wasesithi kumfowabo u-Abheli, “Ake sihambe siye egangeni.” Kwathi bekhonale egangeni uKhayini wamhlasela umfowabo u-Abheli wambulala. ");
INSERT INTO nde_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","UThixo wasesithi kuKhayini, “Ungaphi umfowenu u-Abheli na?” Waphendula wathi, “Angazi. Ngingumgcini womfowethu na?” ");
INSERT INTO nde_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","UThixo wathi, “Usuyenzeni? Lalela! Igazi lomfowenu liyakhala kimi lisuka emhlabathini. ");
INSERT INTO nde_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Manje usuqalekisiwe njalo usuxotshiwe kuwo umhlabathi ovule umlomo wawo ukwamukela igazi lomfowenu lisuka esandleni sakho. ");
INSERT INTO nde_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Lapho uwusebenza umhlabathi kawusayi kuthela amabele kuwe. Uzakuba luzulane emhlabeni.” ");
INSERT INTO nde_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","UKhayini wathi kuThixo, “Isijeziso sami singaphezu kwamandla ami. ");
INSERT INTO nde_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Lamuhla usungixotsha elizweni, ngakho sengizasithela ngingabi khona kuwe; ngizakuba luzulane olungela kuphumula emhlabeni, kuthi loba ngubani ongifumanayo angibulale.” ");
INSERT INTO nde_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Kodwa uThixo wathi kuye, “Akunjalo; lowo ozabulala uKhayini uzaphindiselwa ngokuphindwe kasikhombisa.” Ngakho uThixo wasebeka uphawu kuKhayini ukuze kuthi lowo omfumanayo angambulali. ");
INSERT INTO nde_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ngakho uKhayini wasesuka emehlweni kaThixo wayahlala elizweni laseNodi, empumalanga kwase-Edeni. ");
INSERT INTO nde_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","UKhayini wembatha lomkakhe, wathatha isisu wazala u-Enoki. Ngalesosikhathi uKhayini wayesakha idolobho alibiza ngendodana yakhe u-Enoki. ");
INSERT INTO nde_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ku-Enoki kwazalwa u-Iradi, yena u-Iradi waba nguyise kaMehujayeli, uMehujayeli waba nguyise kaMethushayeli, uMethushayeli waba nguyise kaLameki. ");
INSERT INTO nde_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","ULameki wathatha abafazi ababili, omunye ethiwa ngu-Ada, omunye ethiwa nguZila. ");
INSERT INTO nde_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","U-Ada wazala uJabhali; owayenguyise walabo abahlala emathenteni befuye izifuyo. ");
INSERT INTO nde_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ibizo lomfowabo lalinguJubhali; wayenguyise wabo bonke abatshaya umhubhe lechacho. ");
INSERT INTO nde_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","UZila laye waba lendodana, uThubhali-Khayini, owayekhanda zonke inhlobo zezinto ngethusi langensimbi. Udadewabo kaThubhali-Khayini wayenguNahama. ");
INSERT INTO nde_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","ULameki wathi kubomkakhe, “Ada loZila, ngilalelani; bafazi bakaLameki, zwanini amazwi ami. Sengibulele umuntu ngenxa yokungilimaza, ijaha ngoba lingihlasele. ");
INSERT INTO nde_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Nxa uKhayini ephindiselwa kasikhombisa ngakho uLameki amatshumi ayisikhombisa lesikhombisa.” ");
INSERT INTO nde_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","U-Adamu waphinda wembatha lomkakhe njalo, wazala indodana wayithi nguSethi, esithi, “UNkulunkulu usengiphile omunye umntwana endaweni ka-Abheli, njengoba uKhayini wambulala.” ");
INSERT INTO nde_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","USethi laye waba lendodana, wayibiza ngokuthi ngu-Enoshi. Ngalesosikhathi abantu baqala ukukhuleka bebiza ibizo likaThixo. ");
INSERT INTO nde_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Lo ngumlando olotshiweyo ngosendo luka-Adamu. Lapho uNkulunkulu edala umuntu, wamenza ngomfanekiso kaNkulunkulu. ");
INSERT INTO nde_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Wabadala, owesilisa lowesifazane wasebabusisa. Wababiza ngokuthi “Ngabantu” emva kokubadala. ");
INSERT INTO nde_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Kwathi u-Adamu esephile iminyaka elikhulu lamatshumi amathathu (130) wathola indodana eyafana laye xathu; wayibiza ngokuthi nguSethi. ");
INSERT INTO nde_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","USethi esezelwe, u-Adamu waphila iminyaka engamakhulu ayisificaminwembili (800) njalo wayelamanye amadodana lamadodakazi. ");
INSERT INTO nde_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Isiyonke iminyaka ka-Adamu yayingamakhulu ayisificamunwemunye lamatshumi amathathu (930), wasesifa. ");
INSERT INTO nde_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Kwathi uSethi esephile iminyaka elikhulu lanhlanu (105) waba nguyise ka-Enoshi. ");
INSERT INTO nde_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ngemva kokuzala u-Enoshi uSethi waphila iminyaka engamakhulu ayisificaminwembili lesikhombisa (807), njalo wayelamanye amadodana lamadodakazi. ");
INSERT INTO nde_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Isiyonke iminyaka eyaphilwa nguSethi yaba ngamakhulu ayisificamunwemunye letshumi lambili (912), wasesifa. ");
INSERT INTO nde_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Kwathi u-Enoshi esephile iminyaka engamatshumi ayisificamunwemunye (90) wazala uKhenani. ");
INSERT INTO nde_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ngemva kokuzala uKhenani, u-Enoshi waphila iminyaka engamakhulu ayisificaminwembili letshumi lanhlanu (815) njalo waba lamanye amadodana lamadodakazi. ");
INSERT INTO nde_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Isiyonke iminyaka, u-Enoshi waphila iminyaka engamakhulu ayisificamunwemunye lanhlanu (905), wasesifa. ");
INSERT INTO nde_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kwathi uKhenani esephile iminyaka engamatshumi ayisikhombisa (70) wazala uMahalaleli. ");
INSERT INTO nde_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ngemva kokuba esezele uMahalaleli, uKhenani waphila iminyaka engamakhulu ayisificaminwembili lamatshumi amane (840) njalo waba lamanye amadodana lamadodakazi. ");
INSERT INTO nde_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Isiyonke iminyaka eyaphilwa nguKhenani yaba ngamakhulu ayisificamunwemunye letshumi (910), wasesifa. ");
INSERT INTO nde_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Kwathi uMahalaleli esephile iminyaka engamatshumi ayisithupha lanhlanu (65), wazala uJaredi. ");
INSERT INTO nde_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ngemva kokuzala kwakhe uJaredi, uMahalaleli waphila iminyaka engamakhulu ayisificaminwembili lamatshumi amathathu (830) njalo waba lamanye amadodana lamadodakazi. ");
INSERT INTO nde_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Isiyonke iminyaka eyaphilwa nguMahalaleli yaba ngamakhulu ayisificaminwembili lamatshumi ayisificamunwemunye lanhlanu (895), wasesifa. ");
INSERT INTO nde_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","UJaredi esephile iminyaka elikhulu lamatshumi ayisithupha lambili (162), wazala u-Enoki. ");
INSERT INTO nde_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ngemva kokuzala kwakhe u-Enoki, uJaredi waphila okweminyaka engamakhulu ayisificaminwembili (800) njalo waba lamanye amadodana lamadodakazi. ");
INSERT INTO nde_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Isiyonke iminyaka eyaphilwa nguJaredi yaba ngamakhulu ayisificamunwemunye lamatshumi ayisithupha lambili (962), wasesifa. ");
INSERT INTO nde_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Kwathi u-Enoki esephile iminyaka engamatshumi ayisithupha lanhlanu (65), wazala uMethuzela. ");
INSERT INTO nde_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ngemva kokuzala uMethuzela, u-Enoki wahamba loNkulunkulu okweminyaka engamakhulu amathathu (300) njalo waba lamanye amadodana lamadodakazi. ");
INSERT INTO nde_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Isiyonke iminyaka eyaphilwa ngu-Enoki yaba ngamakhulu amathathu lamatshumi ayisithupha lanhlanu (365). ");
INSERT INTO nde_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","U-Enoki wahamba ngokuthembeka loNkulunkulu; wanyamalala, ngoba uNkulunkulu wamthatha. ");
INSERT INTO nde_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Kwathi uMethuzela esephile okweminyaka elikhulu lamatshumi ayisificaminwembili lesikhombisa (187) wazala uLameki. ");
INSERT INTO nde_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ngemva kokuzala uLameki, uMethuzela waphila iminyaka engamakhulu ayisikhombisa lamatshumi ayisificaminwembili lambili (782) njalo waba lamanye amadodana lamadodakazi. ");
INSERT INTO nde_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Isiyonke iminyaka eyaphilwa nguMethuzela yaba ngamakhulu ayisificamunwemunye lamatshumi ayisithupha layisificamunwemunye (969), wasesifa. ");
INSERT INTO nde_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","ULameki esephile iminyaka elikhulu lamatshumi ayisificaminwembili lambili (182) wazala indodana. ");
INSERT INTO nde_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Wayitha ibizo wathi nguNowa, wathi, “Izasiduduza emsebenzini lasekutshikatshikeni kwethu okubuhlungu ngezandla zethu okubangwa ngumhlabathi uThixo awuthukileyo.” ");
INSERT INTO nde_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ngemva kokuzalwa kukaNowa, uLameki waphila iminyaka engamakhulu amahlanu lamatshumi ayisificamunwemunye lanhlanu (595) njalo waba lamanye amadodana lamadodakazi. ");
INSERT INTO nde_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Isiyonke iminyaka eyaphilwa nguLameki yaba ngamakhulu ayisikhombisa lamatshumi ayisikhombisa lesikhombisa (777), wasesifa. ");
INSERT INTO nde_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ngemva kokuphila iminyaka engamakhulu amahlanu (500), uNowa wazala uShemu, loHamu loJafethi. ");
INSERT INTO nde_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Kwathi abantu sebesanda ngobunengi emhlabeni, bezala amadodakazi, ");
INSERT INTO nde_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","amadodana kaNkulunkulu abona ukuthi amadodakazi abantu ayemahle, bazikhethela abawafunayo bawathatha. ");
INSERT INTO nde_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","UThixo wasesithi, “UMoya wami kawuyikuphikisana lomuntu ngokungapheliyo, ngoba yena ngowenyama nje; insuku zakhe zizakuba likhulu elilamatshumi amabili kuphela.” ");
INSERT INTO nde_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","AmaNefilimi ayesemhlabeni ngalezonsuku. Njalo langemva kwazo amadodana kaNkulunkulu angenela amadodakazi abantu azala lawo abantwana. Ayengamaqhawe ekadeni, amadoda odumo. ");
INSERT INTO nde_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","UThixo wabona ukuthi ukuxhwala kwabantu kwasekukukhulu kakhulu emhlabeni, njalo lokuthi zonke izinkanuko zeminakano yezinhliziyo zabo zaziyibubi kuphela sonke isikhathi. ");
INSERT INTO nde_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","UThixo wadabuka ngokuthi wayemenzile umuntu emhlabeni, ngakho inhliziyo yakhe yagcwala ubuhlungu. ");
INSERT INTO nde_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ngakho uThixo wasesithi, “Umuntu engamdalayo ngizamkhucula emhlabeni, abantu lezinyamazana, lezinanakazana ezihuquzela emhlabathini, lezinyoni zemkhathini ngoba kuyangidabukisa ukuthi ngakwenza.” ");
INSERT INTO nde_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Kodwa uNowa wathola umusa emehlweni kaThixo. ");
INSERT INTO nde_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Lo ngumlando kaNowa. UNowa wayeyindoda elungileyo, engelasici phakathi kwabantu ngesikhathi aphila ngaso, njalo wabambelela kuNkulunkulu. ");
INSERT INTO nde_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","UNowa wayelamadodana amathathu: UShemu, uHamu loJafethi. ");
INSERT INTO nde_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Umhlaba wawuxhwalile phambi kukaNkulunkulu njalo ugcwele ubudlwangudlwangu. ");
INSERT INTO nde_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","UNkulunkulu wabona ukuthi umhlaba wawusuxhwale njani, ngoba bonke abantu emhlabeni basebehamba ngezindlela zabo ezixhwalileyo. ");
INSERT INTO nde_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ngakho uNkulunkulu wasesithi kuNowa, “Ngizabatshabalalisa bonke abantu, ngoba umhlaba ugcwele ubudlwangudlwangu ngenxa yabo. Ngeqiniso ngizababhubhisa bona kanye lomhlaba. ");
INSERT INTO nde_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ngakho zakhele umkhumbi ngezigodo zesihlahla sokubaza; wenze amakamelo kuwo, uwuhuqe ngenhlaka ngaphakathi langaphandle. ");
INSERT INTO nde_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Uzawakha kanje: Umkhumbi kawube ngamalunga ezingalo ezingamakhulu amathathu ubude, ububanzi bube zingalo ezingamatshumi amahlanu lezingalo ezingamatshumi amathathu ukuphakama kwawo. ");
INSERT INTO nde_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Uwenzele uphahla, utshiye ngaphansi kophahla intuba eyingxenye yelunga lengalo ukufika phezulu. Ufake umnyango eceleni komkhumbi njalo wenze isigcawu saphansi, esaphakathi laphakathi kanye lesaphezulu. ");
INSERT INTO nde_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ngizathumela uzamcolo emhlabeni ukubhubhisa konke okuphilayo ngaphansi kwezulu, zonke izidalwa eziphefumulayo. Yonke into emhlabeni izabhubha. ");
INSERT INTO nde_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Kodwa ngizakwenza isivumelwano lawe, njalo wena uzangena emkhunjini, wena lamadodana akho lomkakho kanye labomalukazana bakho. ");
INSERT INTO nde_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Kuzamele ulethe emkhunjini okubili kwezidalwa zonke eziphilayo, okuduna lokusikazi, uzigcine ziphila zilawe. ");
INSERT INTO nde_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Okubili kwemihlobo yonke yezinyoni, okwemihlobo yonke yezinyamazana lokwezinanakazana zonke ezihuquzela emhlabathini zizakuza kuwe zizogcinwa ziphila. ");
INSERT INTO nde_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Kumele uthathe yonke imihlobo yokudla okuzadliwa, ukulondolozele wena kanye lazo.” ");
INSERT INTO nde_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","UNowa wakwenza konke njengokulaywa kwakhe nguNkulunkulu. ");
INSERT INTO nde_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","UThixo wathi kuNowa, “Ngena emkhunjini, wena kanye lendlu yakho yonke, ngoba ngikufumane ulungile kulesi isizukulwane. ");
INSERT INTO nde_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ngena lezinyamazana eziyisikhombisa ezemihlobo yonke yezinyamazana ezihlanzekileyo, enduna lensikazi, lezimbili ezemihlobo yonke yezinyamazana ezingcolileyo, enduna lensikazi yayo, ");
INSERT INTO nde_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","njalo eziyisikhombisa zezinyoni zemihlobo yonke, ezinduna lezinsikazi, ukuze kugcinakale uhlobo lwazo zonke emhlabeni. ");
INSERT INTO nde_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ngemva kwensuku eziyisikhombisa kusukela manje ngizathumela izulu emhlabeni okwensuku ezingamatshumi amane lobusuku obungamatshumi amane, njalo ngizatshabalalisa sonke isidalwa esiphilayo engasenzayo emhlabeni.” ");
INSERT INTO nde_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","UNowa wakwenza konke lokho akulaywa nguThixo. ");
INSERT INTO nde_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","UNowa wayeleminyaka engamakhulu ayisithupha yobudala ekufikeni kukazamcolo emhlabeni. ");
INSERT INTO nde_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","UNowa lamadodana akhe, lomkakhe kanye labomalukazana bakhe bangena emkhunjini ukuze baphephe emanzini kazamcolo. ");
INSERT INTO nde_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ngazimbili izinyamazana ezihlanzekileyo lezingcolileyo, ezezinyoni lezezinanakazana zonke ezihuquzela emhlabathini, ");
INSERT INTO nde_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ezinduna lezinsikazi zeza kuNowa zangena emkhunjini, njengokulaywa kukaNowa nguNkulunkulu. ");
INSERT INTO nde_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Kwathi ngemva kwensuku eziyisikhombisa amanzi kazamcolo eza emhlabeni. ");
INSERT INTO nde_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ngomnyaka wamakhulu ayisithupha wokuphila kukaNowa, ngosuku lwetshumi lesikhombisa lwenyanga yesibili, ngalolosuku yonke imithombo yolwandle olukhulu yadabuka, lamasango amanzi amazulu avuleka. ");
INSERT INTO nde_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Izulu lana emhlabeni okwensuku ezingamatshumi amane lobusuku obungamatshumi amane. ");
INSERT INTO nde_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ngalolosuku uNowa lamadodana akhe, uShemu, uHamu loJafethi, kanye lomkakhe labomalukazana bakhe bamadodana akhe womathathu bangena emkhunjini. ");
INSERT INTO nde_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Babelazo zonke izinyamazana zeganga kusiya ngemihlobo yazo, zonke izifuyo kusiya ngemihlobo yazo, zonke izinanakazana ezihuquzela emhlabathini kusiya ngemihlobo yazo lazozonke izinyoni kusiya ngemihlobo yazo, yonke into elempiko. ");
INSERT INTO nde_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Zeza kuNowa ngazimbili zonke izidalwa ezilomphefumulo wokuphila zangena emkhunjini. ");
INSERT INTO nde_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Izinyamazana ezazingena zazingezinduna lezinsikazi ezezinto zonke eziphilayo, njengalokho uNkulunkulu ayekulaye uNowa. Emva kwalokho uThixo wasemvalela phakathi. ");
INSERT INTO nde_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Okwensuku ezingamatshumi amane impophoma zaphikelela zithululeka emhlabeni, kwathi ngokwanda kwamanzi awuphakamisa umkhumbi waba ngaphezulu komhlaba. ");
INSERT INTO nde_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Amanzi akhwela anda kakhulu emhlabeni, umkhumbi wandenda phezu kwamanzi. ");
INSERT INTO nde_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Akhwela kakhulu emhlabeni, kwathi zonke izintaba eziphakemeyo ngaphansi kwawo wonke amazulu zasibekelwa. ");
INSERT INTO nde_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Amanzi akhwela asibekela izintaba zatshona okudlula izingalo ezingamatshumi amabili. ");
INSERT INTO nde_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Zonke izinto eziphilayo ezihamba phezu komhlaba zafa, izinyoni, izifuyo, izinyamazana zeganga, zonke izidalwa ezazitshatshama phezu komhlaba, loluntu lonke. ");
INSERT INTO nde_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Yonke into ephefumula impilo ngamakhala ayo nxa isemhlabathini owomileyo yafa. ");
INSERT INTO nde_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Yonke into ephilayo phezu komhlaba yakhukhulwa; abantu lezinyamazana lezinanakazana ezihuquzela emhlabathini kanye lezinyoni zemkhathini kwakhuculwa emhlabeni. NguNowa kuphela owasalayo, lalabo ababelaye emkhunjini. ");
INSERT INTO nde_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Amanzi agcwala emhlabeni okwensuku ezilikhulu lamatshumi amahlanu. ");
INSERT INTO nde_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Kodwa uNkulunkulu wamkhumbula uNowa lazozonke izinyamazana zeganga lezifuyo ezazilaye emkhunjini, wasethumela umoya emhlabeni, amanzi asesentsha. ");
INSERT INTO nde_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Manje imithombo yolwandle lamasango amanzi asemazulwini kwasekuvaliwe, lezulu laselisile emkhathini. ");
INSERT INTO nde_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Amanzi entsha kancanekancane emhlabeni. Ekupheleni kwensuku ezilikhulu lamatshumi amahlanu amanzi ayesentshile, ");
INSERT INTO nde_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","kwathi ngosuku lwetshumi lesikhombisa lwenyanga yesikhombisa umkhumbi wayakuma phezu kwezintaba zase-Ararathi. ");
INSERT INTO nde_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Amanzi aqhubeka esentsha kwaze kwaba yinyanga yetshumi, kwathi ngosuku lokuqala lwenyanga yetshumi iziqongo zezintaba zaqala ukubonakala. ");
INSERT INTO nde_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ngemva kwensuku ezingamatshumi amane uNowa wavula iwindi ayelenzile emkhunjini ");
INSERT INTO nde_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","wathuma iwabayi, lazulazula emoyeni amanzi aze atsha emhlabeni. ");
INSERT INTO nde_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Wasethuma ijuba ukuthi abone ingabe amanzi ayesephelile emhlabathini. ");
INSERT INTO nde_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Kodwa ijuba laswela indawo yokubeka unyawo ngoba kwakulamanzi yonke indawo phezu komhlaba; ngakho labuyela kuNowa emkhunjini. Wakhupha isandla walamukela ijuba walibuyisa kuye emkhunjini. ");
INSERT INTO nde_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Walinda okwezinye insuku eziyisikhombisa waphinda walithuma ijuba lisuka emkhunjini. ");
INSERT INTO nde_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Kwathi ijuba selibuya kuye ntambama, laliphethe ngomlomo walo ihlamvu lesihlahla se-oliva elalisanda kukhiwa! UNowa wahle wazi ukuthi amanzi ayesehlile kakhulu emhlabeni. ");
INSERT INTO nde_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Walinda okwezinye insuku eziyisikhombisa walithuma ijuba njalo, kodwa ngalesi isikhathi kalisabuyanga kuye. ");
INSERT INTO nde_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ngosuku lokuqala lwenyanga yokuqala yomnyaka wamakhulu ayisithupha lanye wokuphila kukaNowa, amanzi ayesomile emhlabeni. Ngakho uNowa wasesusa uphahla lomkhumbi esebona ukuthi iphansi lomhlabathi laselomile. ");
INSERT INTO nde_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ngosuku lwamatshumi amabili lesikhombisa lwenyanga yesibili umhlabathi wawusuwome qha. ");
INSERT INTO nde_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","UNkulunkulu wasesithi kuNowa, ");
INSERT INTO nde_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Phuma emkhunjini, wena lomkakho, lamadodana akho labomkabo. ");
INSERT INTO nde_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Khupha yonke into ephilayo olayo, izinyoni, izinyamazana lazozonke izinanakazana ezihuquzela emhlabathini ukuze zande emhlabeni, zizale zande ngobunengi bazo.” ");
INSERT INTO nde_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ngakho uNowa wasephuma lamadodana akhe, lomkakhe kanye labomalukazana bakhe. ");
INSERT INTO nde_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Zonke izinyamazana kanye lezinanakazana ezihuquzela emhlabathini lazozonke izinyoni, yonke into enyakazayo emhlabeni, kwaphuma emkhunjini, ngemihlobo kulandelana. ");
INSERT INTO nde_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","UNowa wasesakhela uThixo i-alithari, wathatha ezinye izinyamazana lezinyoni ezihlanzekileyo wanikela iminikelo yokutshiswa phezu kwalo. ");
INSERT INTO nde_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","UThixo wahotsha iphunga elimnandi wathi enhliziyweni yakhe: “Kangisayikuphinda ngiwuqalekise njalo umhlaba ngenxa yabantu, ngoba imicabango yenhliziyo yomuntu mibi kusukela ebuntwaneni bakhe. Njalo kangisoze lanini ngiphinde ngibhubhise zonke izidalwa eziphilayo, njengalokhu engikwenzileyo. ");
INSERT INTO nde_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Nxa umhlaba ulokhu usekhona, isikhathi sokuhlanyela lesokuvuna, umqando lokutshisa, ihlobo lobusika, imini lobusuku kakusoze kwacina.” ");
INSERT INTO nde_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","UNkulunkulu wambusisa uNowa lamadodana akhe wathi kubo, “Zalanani lande ngobunengi ligcwalise umhlaba. ");
INSERT INTO nde_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Zizalesaba zibe lovalo ngani zonke izinyamazana zomhlaba, lazozonke izinyoni zemoyeni, lezinanakazana ezihuquzela emhlabathini, kanye lenhlanzi zonke zolwandle; ziphiwe ezandleni zakho. ");
INSERT INTO nde_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Yonke into ephilayo lenyakazayo izakuba yikudla kuwe. Njengalokhu ngalipha izihlahla eziluhlaza, manje sengilipha yonke into. ");
INSERT INTO nde_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Kodwa lingadli inyama ilegazi lokuphila phakathi kwayo. ");
INSERT INTO nde_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Njalo igazi lokuphila kwenu ngizafuna impendulo ngalo, ngizafuna impendulo kuyo yonke inyamazana. Njalo emuntwini wonke ngizafuna ukwazi ngempilo yomzalwane wakhe. ");
INSERT INTO nde_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Loba ngubani ochitha igazi lomuntu, igazi lakhe lizachithwa ngumuntu; ngoba ngomfanekiso kaNkulunkulu, uNkulunkulu umenzile umuntu. ");
INSERT INTO nde_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Mayelana lani, zalanani lande ngobunengi; yandani emhlabeni libe banengi.” ");
INSERT INTO nde_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","UNkulunkulu wasesithi kuNowa lakumadodana akhe ayelawo: ");
INSERT INTO nde_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Manje sengimisa isivumelwano sami lani lezizukulwane zenu ezilandelayo ");
INSERT INTO nde_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","lasosonke isidalwa esiphilayo esasilawe, izinyoni, izifuyo lezinyamazana zeganga, zonke lezo ezaphuma lani emkhunjini, sonke isidalwa esiphilayo emhlabeni. ");
INSERT INTO nde_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ngiyasimisa isivumelwano sami lani: Kakusoze njalo impilo yonke iqunywe ngamanzi kazamcolo; kakusoze njalo kube lozamcolo ozabhubhisa umhlaba.” ");
INSERT INTO nde_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","UNkulunkulu wathi, “Lesi yisiboniso sesivumelwano engisenzayo phakathi kwami lani lasosonke isidalwa esiphilayo elilaso, isivumelwano sezizukulwane zonke ezizayo: ");
INSERT INTO nde_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Sengibeke umchilowamakhosikazi wami emayezini, wona uzakuba yisiboniso sesivumelwano phakathi kwami lomhlaba. ");
INSERT INTO nde_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Kuzakuthi nxa ngiletha amayezi phezu komhlaba besekuvela umchilowamakhosikazi emayezini, ");
INSERT INTO nde_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ngizakhumbula isivumelwano sami phakathi kwami lani lazozonke izidalwa eziphilayo ezemihlobo yonke. Kakusoze njalo lanini amanzi abe yisikhukhula esizabhubhisa impilo. ");
INSERT INTO nde_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Kuzakuthi nxa kungavela umchilowamakhosikazi emayezini ngizawubona besengikhumbula isivumelwano saphakade phakathi kukaNkulunkulu lezidalwa zonke eziphilayo ezemihlobo yonke emhlabeni.” ");
INSERT INTO nde_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","UNkulunkulu wasesithi kuNowa, “Lesi yisiboniso sesivumelwano esengisimisile phakathi kwami lakho konke okuphilayo emhlabeni.” ");
INSERT INTO nde_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Amadodana kaNowa aphuma emkhunjini ayengoShemu, uHamu loJafethi. (UHamu wayenguyise kaKhenani.) ");
INSERT INTO nde_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","La ayeyiwo amadodana amathathu kaNowa, kuwo kwadabuka abantu abasabalala emhlabeni wonke. ");
INSERT INTO nde_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","UNowa, indoda yomhlabathi, wasuka wahlanyela isivini. ");
INSERT INTO nde_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Wathi esenathe iwayini lakhona, wadakwa walala enqunu phakathi kwethente lakhe. ");
INSERT INTO nde_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","UHamu, uyise kaKhenani, wabona ubunqunu bukayise wasetshela abafowabo phandle. ");
INSERT INTO nde_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Kodwa uShemu loJafethi bathatha isivunulo basiphosela emahlombe abo; bangena behamba nyovane bamboza ubunqunu bukayise. Ubuso babo babukhangele emuva ukuze bangaboni ubunqunu bukayise. ");
INSERT INTO nde_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Kwathi uNowa esevukile selehlile iwayini wezwa ngokwakwenziwe kuye yindodana yakhe encane kulamanye, ");
INSERT INTO nde_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","wathi, “Uqalekisiwe uKhenani! Isigqili esizakuba phansi kubafowabo.” ");
INSERT INTO nde_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Wabuya wathi njalo, “Udumo kalube kuThixo, uNkulunkulu kaShemu! Sengathi uKhenani angaba yisigqili sikaShemu. ");
INSERT INTO nde_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Sengathi uNkulunkulu angaqhelisa indawo kaJafethi; sengathi uJafethi angahlala emathenteni kaShemu, njalo sengathi uKhenani angaba yisichaka sakhe.” ");
INSERT INTO nde_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ngemva kukazamcolo uNowa waphila okweminyaka engamakhulu amathathu lamatshumi amahlanu (350). ");
INSERT INTO nde_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","UNowa waphila okweminyaka engamakhulu ayisificamunwemunye lamatshumi amahlanu (950) isiyonke, wasesifa. ");
INSERT INTO nde_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Lo ngumlando kaShemu, loHamu loJafethi, amadodana kaNowa, okwathi bona ngokwabo baba lamadodana ngemva kwesikhukhula. ");
INSERT INTO nde_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Amadodana kaJafethi ayeyila: uGomeri, uMagogi, uMadayi uJavani, uThubhali, uMesheki loThirasi. ");
INSERT INTO nde_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Amadodana kaGomeri ayeyila: u-Ashikhenazi, uRifathi kanye loThogarima. ");
INSERT INTO nde_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Amadodana kaJavani ayeyila: u-Elisha, uThashishi, uKhithimi loRodanimu. ");
INSERT INTO nde_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(Kusukela kulaba abahlala ngasolwandle behlukana ngezigodi zabo, yilabo ngosendo lwabo bephakathi kwezizwe zabo, kuyilabo lalabo bekhuluma ulimi lwabo.) ");
INSERT INTO nde_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Amadodana kaHamu ayeyila: uKhushi, uMizirayimi, uPhuthi loKhenani. ");
INSERT INTO nde_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Amadodana kaKhushi ayeyila: uSebha, uHavila, uSabhitha, uRahama loSabhitheka. Amadodana kaRahama ayeyila: uShebha loDedani. ");
INSERT INTO nde_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","UKhushi wayenguyise kaNimrodi, owakhula waba liqhawe elilamandla emhlabeni. ");
INSERT INTO nde_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Wayengumzingeli omkhulu phambi kukaThixo; kungakho lokho kwathiwa, “NjengoNimrodi, umzingeli omkhulu phambi kukaThixo.” ");
INSERT INTO nde_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Izindawo ezinkulu zembusweni wakhe kwakuyiBhabhiloni, i-Erekhi, i-Akhadi leKhaline eShinari. ");
INSERT INTO nde_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Esuka kulelolizwe waya e-Asiriya lapho akha khona iNiniva, iRehobhothi, i-Iri, iKhala ");
INSERT INTO nde_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","leReseni ephakathi kweNiniva leKhala; yilo idolobho elikhulukazi. ");
INSERT INTO nde_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","UMizirayimi wayenguyise wamaLudi, ama-Anami, amaLehabhi, amaNafithuhi, ");
INSERT INTO nde_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","amaPhathrosi lamaKhasiluhi (okwadabuka khona amaFilistiya) lamaKhafithori. ");
INSERT INTO nde_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","UKhenani wayenguyise kaSidoni izibulo lakhe, amaHithi, ");
INSERT INTO nde_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","amaJebusi, ama-Amori, amaGigashi, ");
INSERT INTO nde_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","amaHivi, ama-Arikhi, amaSini, ");
INSERT INTO nde_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ama-Avadi, amaZemari kanye lamaHamathi. (Muva izizwana zamaKhenani zasabalala ");
INSERT INTO nde_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","kwathi imingcele yeKhenani yasukela eSidoni isiya eGerari kufika eGaza, besekuqonda eSodoma, leGomora, le-Adima leZebhoyimi kuze kuyefika eLasha.) ");
INSERT INTO nde_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","La yiwo amadodana kaHamu ngokosendo lwawo langezindimi zawo, ezigodini zawo kanye langezizwe zawo. ");
INSERT INTO nde_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Amadodana azalwa njalo kuShemu, umnewabo owayenguJafethi; uShemu wayengukhokho wawo wonke amadodana ka-Ebha. ");
INSERT INTO nde_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Amadodana kaShemu ayeyila: u-Elamu, u-Ashuri, u-Afazadi, uLudi lo-Aramu. ");
INSERT INTO nde_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Amadodana ka-Aramu ayeyila: u-Uzi, uHuli, uGetha loMesheki. ");
INSERT INTO nde_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","U-Afazadi wayenguyise kaShela, uShela wazala u-Ebha. ");
INSERT INTO nde_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Amadodana amabili ayezalwa ngu-Ebha ayeyila: Omunye wayenguPhelegi, ngoba ngezinsuku zakhe umhlaba wawudabuke phakathi; umfowabo kwakuthiwa nguJokithani. ");
INSERT INTO nde_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","UJokithani wayenguyise ka-Alimodadi, uShelefi, uHazarimavethi, uJera, ");
INSERT INTO nde_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","uHadoramu, u-Uzali, uDikila, ");
INSERT INTO nde_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","u-Obhali, u-Abhimayeli, uShebha, ");
INSERT INTO nde_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","u-Ofiri, uHavila kanye loJobhabhi. Bonke laba babengamadodana kaJokithani. ");
INSERT INTO nde_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Isigodi ababehlala kuso sasisukela eMesha kusiya eSefari elizweni elilamaqaqa elisempumalanga. ");
INSERT INTO nde_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","La ngamadodana kaShemu ngokosendo lwawo langezindimi zawo, emazweni awo lezizweni zawo. ");
INSERT INTO nde_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Lezi zinsendo zamadodana kaNowa kusiya ngemindeni yazo, phakathi kwezizwe zawo. Kusukela kuzo, izizwe zahlakazeka zagcwala umhlaba wonke emva kukazamcolo. ");
INSERT INTO nde_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Umhlaba wonke wawulolimi lunye lokukhuluma okufananayo. ");
INSERT INTO nde_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Kwathi abantu belokhu beqhelela empumalanga, bafumana indawo evulekileyo eShinari basebesakha khona. ");
INSERT INTO nde_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Basebetshelana bathi, “Kasitshayeni izitina sizitshise kakhulu.” Babesebenzisa izitina endaweni yamatshe, lethara endaweni yodaka. ");
INSERT INTO nde_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Basebesithi, “Zwanini, kasizakheleni idolobho libe lomphongolo ofika emazulwini, ukuze sizenzele ibizo singaze sasabalala umhlaba wonke.” ");
INSERT INTO nde_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Kodwa uThixo wehla wazalibona idolobho kanye lomphongolo abantu ababewakha. ");
INSERT INTO nde_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","UThixo wathi, “Nxa bengabantu banye bekhuluma limi lunye sebeqalisile ukwenza lokhu, pho kakukho okungabehlula. ");
INSERT INTO nde_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Zwanini, kasehleni siye phansi sisanganise ulimi lwabo bangabe besazwana.” ");
INSERT INTO nde_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Kanjalo uThixo wabahlakaza emhlabeni wonke, bayekela ukwakha idolobho. ");
INSERT INTO nde_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Kungakho labizwa ngokuthi yiBhabheli, ngoba khonapho uThixo wasanganisa ulimi lomhlaba wonke. Kusukela lapho uThixo wabahlakazela emhlabeni wonke. ");
INSERT INTO nde_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Lo ngumlando wosendo lukaShemu. Eminyakeni emibili emva kukazamcolo, uShemu eseleminyaka elikhulu (100) wazala u-Afazadi. ");
INSERT INTO nde_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Esezele u-Afazadi, uShemu waphila okweminyaka engamakhulu amahlanu (500), njalo waba lamanye amadodana lamadodakazi. ");
INSERT INTO nde_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Kwathi u-Afazadi esephile iminyaka engamatshumi amathathu lanhlanu (35), wazala uShela. ");
INSERT INTO nde_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Esezele uShela, u-Afazadi waphila okweminyaka engamakhulu amane lantathu (403), njalo waba lamanye amadodana lamadodakazi. ");
INSERT INTO nde_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","UShela esephile iminyaka engamatshumi amathathu (30) wazala u-Ebha. ");
INSERT INTO nde_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Esezele u-Ebha, uShela waphila okweminyaka engamakhulu amane lantathu (403), njalo waba lamanye amadodana lamadodakazi. ");
INSERT INTO nde_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","U-Ebha esephile iminyaka engamatshumi amathathu lane (34) wazala uPhelegi. ");
INSERT INTO nde_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Esezele uPhelegi, u-Ebha waphila okweminyaka engamakhulu amane lamatshumi amathathu (430), njalo waba lamanye amadodana lamadodakazi. ");
INSERT INTO nde_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","UPhelegi esephile iminyaka engamatshumi amathathu (30), wazala uRewu. ");
INSERT INTO nde_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Esezele uRewu, uPhelegi waphila okweminyaka engamakhulu amabili lesificamunwemunye (209), njalo waba lamanye amadodana lamadodakazi. ");
INSERT INTO nde_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Kwathi uRewu esephile iminyaka engamatshumi amathathu lambili (32), wazala uSerugi. ");
INSERT INTO nde_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Esezele uSerugi, uRewu waphila okweminyaka engamakhulu amabili lesikhombisa (207), njalo waba lamanye amadodana lamadodakazi. ");
INSERT INTO nde_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Kwathi uSerugi esephile iminyaka engamatshumi amathathu (30), wazala uNahori. ");
INSERT INTO nde_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Esezele uNahori, uSerugi waphila okweminyaka engamakhulu amabili (200), njalo waba lamanye amadodana lamadodakazi. ");
INSERT INTO nde_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","UNahori esephile iminyaka engamatshumi amabili lesificamunwemunye (29) wazala uThera. ");
INSERT INTO nde_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Esezele uThera, uNahori waphila okweminyaka elikhulu letshumi lesificamunwemunye (119), njalo waba lamanye amadodana lamadodakazi. ");
INSERT INTO nde_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","UThera esephile iminyaka engamatshumi ayisikhombisa (70) wazala u-Abhrama, uNahori loHarani. ");
INSERT INTO nde_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Lo ngumlando wosendo lukaThera. UThera wazala u-Abhrama, uNahori loHarani. Kwathi uHarani wazala uLothi. ");
INSERT INTO nde_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Kwathi uyise uThera esaphila uHarani wafa bese-Uri idolobho lamaKhaladiya, elizweni lokuzalwa kwakhe. ");
INSERT INTO nde_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","U-Abhrama loNahori bathatha bobabili. Ibizo lomka-Abhrama lalinguSarayi, kwathi ibizo likamkaNahori linguMilikha; wayeyindodakazi kaHarani uyise kaMilikha kanye lo-Isikha. ");
INSERT INTO nde_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Kodwa uSarayi wayeyinyumba; wayengelabantwana. ");
INSERT INTO nde_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","UThera wathatha indodana yakhe u-Abhrama, lomzukulu wakhe uLothi indodana kaHarani, lomalokazana wakhe uSarayi umfazi wendodana yakhe u-Abhrama, basuka bonke e-Uri lamaKhaladiya baqonda eKhenani. Kodwa bafika eHarani basebesakha khona. ");
INSERT INTO nde_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","UThera waphila okweminyaka engamakhulu amabili lanhlanu (205), wafela eHarani. ");
INSERT INTO nde_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","UThixo wathi ku-Abhrama, “Suka elizweni lakini, lebantwini bakini lasendlini kayihlo uye elizweni engizakutshengisa lona. ");
INSERT INTO nde_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ngizakwenza ube yisizwe esikhulu njalo ngizakubusisa; ngizakwenza ibizo lakho libe likhulu, njalo uzakuba yisibusiso. ");
INSERT INTO nde_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ngizababusisa labo abakubusisayo, lalowo okuqalekisayo ngizamqalekisa; njalo bonke abantu emhlabeni bazakubusiswa ngawe.” ");
INSERT INTO nde_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ngakho u-Abhrama wasuka, njengokutshelwa kwakhe nguThixo; njalo uLothi wahamba laye. U-Abhrama wayeleminyaka engamatshumi ayisikhombisa lanhlanu ekusukeni kwakhe eHarani. ");
INSERT INTO nde_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Wathatha umkakhe uSarayi, lomntanomfowabo uLothi, lempahla yabo yonke ababeyizuzile kanye labantu ababebatholile eHarani, baqonda elizweni laseKhenani, bayafika khona. ");
INSERT INTO nde_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","U-Abhrama wahamba walidabula ilizwe waze wafika endaweni yesihlahla esikhulu saseMore eShekhemu. Ngalesosikhathi amaKhenani ayephakathi kwelizwe. ");
INSERT INTO nde_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","UThixo wabonakala ku-Abhrama wathi, “Lelilizwe ngizalinika inzalo yakho.” Ngakho wasesakha i-alithari khonapho elakhela uThixo owayebonakele kuye. ");
INSERT INTO nde_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Esuka lapho waqonda ezintabeni empumalanga kweBhetheli wamisa ithente lakhe, iBhetheli isentshonalanga le-Ayi isempumalanga. Khonapho wakhela uThixo i-alithari walidumisa ibizo likaThixo. ");
INSERT INTO nde_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","U-Abhrama wasuka waqhubeka eqonda eNegebi. ");
INSERT INTO nde_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Kwasekusiba lendlala elizweni, okwenza u-Abhrama waya eGibhithe ukuyahlala khona okwesikhathi esithile ngoba indlala yayinkulu kakhulu. ");
INSERT INTO nde_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Kwathi esebanga ukungena eGibhithe wathi kumkakhe uSarayi, “Ngiyazi ukuthi ungumfazi omuhle kakhulu. ");
INSERT INTO nde_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","AmaGibhithe azakuthi ekubona athi, ‘Lo ngumkakhe.’ Lapho-ke bazangibulala wena bakuyekele uphile. ");
INSERT INTO nde_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ubokuthi ungudadewethu, ukuze ngiphathwe kuhle ngenxa yakho njalo lempilo yami isinde ngenxa yakho.” ");
INSERT INTO nde_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Kwathi u-Abhrama efika eGibhithe, amaGibhithe abona umkakhe ukuthi wayengumfazi omuhle kakhulu. ");
INSERT INTO nde_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Izikhulu zikaFaro sezimbonile zamncoma kakhulu kuFaro, uSarayi wasengeniswa esigodlweni sakhe. ");
INSERT INTO nde_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Wamphatha kuhle u-Abhrama ngenxa kaSarayi, ngakho u-Abhrama wazuza izimvu lenkomo, obabhemi abaduna labasikazi, izinceku zesilisa lezesifazane lamakamela. ");
INSERT INTO nde_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Kodwa uThixo wehlisela uFaro lendlu yakhe izifo ezimbi ngenxa kaSarayi umka-Abhrama. ");
INSERT INTO nde_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Ngakho uFaro wabiza u-Abhrama wathi, “Wenzeni kimi? Kungani ungangitshelanga ukuthi ungumkakho na? ");
INSERT INTO nde_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Watsholoni ukuthi ungudadewenu, ngacina sengizithathele mina waba ngowami? Manje, nangu umkakho. Mthathe uhambe!” ");
INSERT INTO nde_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","UFaro waselaya ukuthi u-Abhrama lamadoda ayelawo basuswe elizweni, kanye lomkakhe lakho konke ayelakho. ");
INSERT INTO nde_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ngakho u-Abhrama wasuka eGibhithe waya eNegebi, kanye lomkakhe lakho konke ayelakho, loLothi ehamba laye. ");
INSERT INTO nde_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","U-Abhrama wayesenothile kakhulu ngezifuyo langesiliva legolide. ");
INSERT INTO nde_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Esuka eNegebi wazula lapha lalapha waze wafika eBhetheli, endaweni eyayiphakathi kweBhetheli le-Ayi lapho ayemise khona ithente lakhe kuqala ");
INSERT INTO nde_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","njalo lapho ayeqale khona ukwakha i-alithari. Khonapho u-Abhrama wadumisa ibizo likaThixo. ");
INSERT INTO nde_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","ULothi wayehamba lo-Abhrama, laye wayelemihlambi yezimvu lenkomo lamathente. ");
INSERT INTO nde_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Kodwa indawo yayingasoze ibenele bonke nxa babengahlala ndawonye, ngoba impahla yabo yayinengi kakhulu, isala ukuthi bahlale ndawonye. ");
INSERT INTO nde_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Kwaba lokuxabana phakathi kwabelusi baka-Abhrama labelusi bakaLothi. AmaKhenani lamaPherizi lawo ayehlala kulelolizwe ngalesosikhathi. ");
INSERT INTO nde_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","U-Abhrama wasesithi kuLothi, “Kasingalwi mina lawe, kumbe abelusi bakho labami ngoba siyizinini zegazi. ");
INSERT INTO nde_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Umhlaba wonke kawukho phambi kwakho na? Kasehlukane. Ungaya kwesokhohlo mina ngizakuya kwesokunene; ungaya kwesokunene mina ngizakuya kwesokhohlo.” ");
INSERT INTO nde_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","ULothi wakhangela wabona ukuthi lonke igceke laseJodani lalilamanzi amanengi, njengesivande sikaThixo, njengelizwe laseGibhithe kusiya eZowari. (Ngalesisikhathi uThixo wayengakabhubhisi iSodoma leGomora.) ");
INSERT INTO nde_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ngakho uLothi wazikhethela lonke igceke laseJodani, wasesuka waya empumalanga. Amadoda la womabili ehlukana: ");
INSERT INTO nde_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","U-Abhrama wahlala elizweni laseKhenani, kwathi uLothi wahlala phakathi kwamadolobho asemagcekeni wamisa amathente akhe eduze leSodoma. ");
INSERT INTO nde_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Abantu baseSodoma babexhwalile kakhulu, besenza izono ezinkulu kuThixo. ");
INSERT INTO nde_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","UThixo wathi ku-Abhrama ngemva kokuba uLothi esesukile kuye, “Phakamisa amehlo akho asuke lapho okhona, ukhangele enhla leningizimu, empumalanga lentshonalanga. ");
INSERT INTO nde_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Lonke ilizwe olibonayo ngizalinika wena kanye lesizukulwane sakho okulaphakade. ");
INSERT INTO nde_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ngizakwenza isizukulwane sakho sibe njengothuli lomhlabathi, okokuthi nxa ekhona ongabala uthuli, lesizukulwane sakho sibe lokubalwa. ");
INSERT INTO nde_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Hamba udabule ubude lobubanzi belizwe, ngoba ngiyakupha lona.” ");
INSERT INTO nde_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ngakho u-Abhrama wathutha amathente akhe wahamba wayakwakha eduze kwezihlahla ezinkulu zikaMamure eHebhroni, lapho akhela khona uThixo i-alithari. ");
INSERT INTO nde_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ngesikhathi u-Amrafeli inkosi yaseShinari, lo-Ariyoki inkosi yase-Elasari, loKhedolawoma inkosi yase-Elamu kanye loThidali inkosi yaseGoyimi ");
INSERT INTO nde_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","baya empini behlasela uBhera inkosi yaseSodoma, loBhirisha inkosi yaseGomora, loShinabhi inkosi yase-Adima, loShemebheri inkosi yaseZebhoyimi lenkosi yaseBhela (kutsho iZowari). ");
INSERT INTO nde_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Wonke amakhosi la abikwe muva ahlanganyela eSigodini saseSidimu (uLwandle lweTswayi). ");
INSERT INTO nde_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Okweminyaka elitshumi lambili ayebuswa nguKhedolawoma, kodwa ngomnyaka wetshumi lantathu amvukela. ");
INSERT INTO nde_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ngomnyaka wetshumi lane, uKhedolawoma lamakhosi ayemanyene laye baphuma bayanqoba amaRefayi e-Ashitherothi Khanayimi, lamaZuzi eHamu, lama-Emi eShave Khiriyathayimi ");
INSERT INTO nde_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","lamaHori elizweni lamaqaqa laseSeyiri, kwaze kwayafika e-Eli Pharani eduze lenkangala. ");
INSERT INTO nde_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Yikho basebephenduka baya e-Eni Mishiphathi (kutsho eKhadeshi), banqoba isigodi sonke sama-Amaleki kanye lama-Amori ayehlala eHazazoni Thamari. ");
INSERT INTO nde_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ngakho inkosi yaseSodoma, lenkosi yaseGomora, lenkosi yase-Adima, lenkosi yaseZebhoyimi kanye lenkosi yaseBhela (kutsho iZowari) baphuma bayahlela izimpi zabo eSigodini saseSidimi ");
INSERT INTO nde_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","baqondana loKhedolawoma inkosi yase-Elamu, loThidali inkosi yaseGoyimi, lo-Amrafeli inkosi yaseShinari kanye lo-Ariyoki inkosi yase-Elasari, amakhosi amane eqondene lamahlanu. ");
INSERT INTO nde_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ngalesosikhathi iSigodi saseSidimi sasigcwele imigodi yengcino, ngakho kwathi amakhosi aseSodoma leGomora, esebaleka, abanye abantu bawo bawela kuyo, abanengi babalekela ezintabeni. ");
INSERT INTO nde_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Amakhosi la amane athumba zonke impahla zaseSodoma leGomora lokudla kwabo konke; asehamba. ");
INSERT INTO nde_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Bathumba njalo loLothi umntanomfowabo ka-Abhrama lempahla zakhe, njengoba wayehlala eSodoma. ");
INSERT INTO nde_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Omunye owayephunyukile wafika wazabikela u-Abhrama umHebheru. U-Abhrama wayehlala phansi kwezihlahla ezinkulu zikaMamure umʼAmori, umfowabo ka-Eshikholi lo-Aneri, bonke labo babebambene lo-Abhrama. ");
INSERT INTO nde_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Kwathi u-Abhrama esizwa ukuthi isihlobo sakhe sasithunjiwe, wabutha amadoda ayengamakhulu amathathu letshumi layisificaminwembili (318) ababefundiswe ukulwa, bezalwa endlini yakhe, wangena emzileni baze bayafika eDani. ");
INSERT INTO nde_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ebusuku u-Abhrama wehlukanisa abantu bakhe ukuthi babahlasele, wabalandela, waxotshana labo waze wafika eHobha, enhla kweDamaseko. ");
INSERT INTO nde_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Wabemuka zonke impahla wathola lomhlobo wakhe uLothi kanye lemfuyo yakhe, ndawonye labesifazane labanye abantu. ");
INSERT INTO nde_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","U-Abhrama esebuyile ekunqobeni kwakhe uKhedolawoma lamakhosi ayebambene laye, inkosi yaseSodoma yaphuma yazahlangana laye eSigodini saseShave (okutsho iSigodi seNkosi). ");
INSERT INTO nde_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","UMelikhizedekhi inkosi yaseSalema, waseletha isinkwa lewayini. Wayengumphristi kaNkulunkulu oPhezukonke, ");
INSERT INTO nde_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","wabusisa u-Abhrama esithi, “Ubusisiwe u-Abhrama nguNkulunkulu oPhezukonke, uMdali wezulu lomhlaba. ");
INSERT INTO nde_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Njalo kadunyiswe uNkulunkulu oPhezukonke, owanikela izitha zakho esandleni sakho.” U-Abhrama wasemupha okwetshumi kwakho konke ayelakho. ");
INSERT INTO nde_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Inkosi yaseSodoma yathi ku-Abhrama, “Ngipha abantu wena uzigcinele impahla.” ");
INSERT INTO nde_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Kodwa u-Abhrama wathi enkosini yaseSodoma, “Sengiphakamisele isandla sami kuThixo, uNkulunkulu oPhezukonke, uMdali wezulu lomhlaba, ngenza isifungo ");
INSERT INTO nde_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ukuthi kangisoze ngamukele lutho olungolwakho, loba kungaze kube ngumuca wohali loba umchilo wamanyathela, ukuze lanini ungaze wathi, ‘U-Abhrama wanothiswa yimi.’ ");
INSERT INTO nde_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Angisoze ngamukele lutho ngaphandle kwalokho abantu bami asebekudlile lesabelo esingesalabobantu ababehamba lami, u-Aneri, lo-Eshikholi loMamure. Kabazuze isabelo sabo.” ");
INSERT INTO nde_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ngemva kwalokho ilizwi likaThixo leza ku-Abhrama ngombono: “Ungesabi, Abhrama. Ngiyisihlangu sakho, umvuzo wakho omkhulu kakhulu.” ");
INSERT INTO nde_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Kodwa u-Abhrama wathi, “Oh Thixo Wobukhosi, ungangiphani njengoba ngilokhu ngingelamntwana, ilifa lami lizadliwa ngu-Eliyezari waseDamaseko na?” ");
INSERT INTO nde_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","U-Abhrama wathi njalo, “Awungiphanga bantwana; ngakho inceku endlini yami izakuba yindlalifa yami.” ");
INSERT INTO nde_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ilizwi likaThixo lafika kuye lathi: “Umuntu lo kayikuba yindlalifa yakho, kodwa indodana ephuma kowakho umzimba izakuba yindlalifa yakho.” ");
INSERT INTO nde_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Wamkhuphela phandle wathi, “Khangela emkhathini ubale izinkanyezi, nxa usenelisa ukuzibala.” Wasesithi kuye, “Sizakuba njalo isizukulwane sakho.” ");
INSERT INTO nde_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","U-Abhrama wamkholwa uThixo, lokho kwabalwa kuye njengokulunga. ");
INSERT INTO nde_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Waphinda wathi kuye, “NginguThixo owakususa e-Uri lamaKhaladiya ukuzakupha lelilizwe ukuthi libe ngelakho.” ");
INSERT INTO nde_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Kodwa u-Abhrama wathi, “Oh Thixo Wobukhosi, ngingazi kanjani ukuthi lizakuba ngelami na?” ");
INSERT INTO nde_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","UThixo wathi kuye, “Ngilethela ithokazi, imbuzi, lenqama, konke kuleminyaka emithathu yokuzalwa, kanye lejuba lenkwilimba esesencinyane.” ");
INSERT INTO nde_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","U-Abhrama wakuletha konke lokhu kuye, yilokho wakudabula phakathi ngakunye wakuhlela izingxenye zakho zakhangelana; kodwa izinyoni kazidabulanga phakathi. ");
INSERT INTO nde_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Izinyoni ezidla inyama zehlela ezidunjini, kodwa u-Abhrama wazixotsha. ");
INSERT INTO nde_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Kwathi ilanga selitshona, u-Abhrama wathathwa yibuthongo obukhulu, wehlelwa yibumnyama obesabekayo. ");
INSERT INTO nde_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","UThixo wasesithi kuye, “Yazi ngempela ukuthi Izizukulwane zakho zizakuba ngabezizweni elizweni elingayisilo labo okweminyaka engamakhulu amane, njalo bazagqilazwa, bahlukuluzwe khonale. ");
INSERT INTO nde_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Kodwa ngizasijezisa lesosizwe esibagqilazayo, kuthi emva kwesikhathi baphume belemfuyo enengi kakhulu. ");
INSERT INTO nde_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Kodwa wena, uzakuya kubokhokho bakho ngokuthula, ungcwatshwe usukhulile kakhulu. ");
INSERT INTO nde_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Isizukulwane sakho sesine sizabuya lapha, ngoba isono sama-Amori kasikafiki ekucineni.” ");
INSERT INTO nde_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Kwathi ilanga selitshonile, ubumnyama sebufikile, kwavela imbawula yomlilo, ithunqa intuthu, ilelangabi elibhebhayo, yadabula phakathi kweziqa zenyama. ");
INSERT INTO nde_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ngalelolanga uThixo wenza isivumelwano lo-Abhrama wathi, “Ilizwe leli ngilipha izizukulwane zakho, kusukela emfuleni waseGibhithe kusiyafika emfuleni omkhulu, iYufrathe, ");
INSERT INTO nde_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ilizwe lamaKheni, lamaKhenizi, lamaKhadimoni, ");
INSERT INTO nde_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","lamaHithi, lamaPherizi, lamaRefayi, ");
INSERT INTO nde_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","lama-Amori, lamaKhenani, lamaGigashi kanye lamaJebusi.” ");
INSERT INTO nde_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","USarayi umka-Abhrama wayengamzalelanga bantwana. Kodwa wayelencekukazi yomGibhithe eyayithiwa nguHagari; ");
INSERT INTO nde_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","ngakho uSarayi wathi ku-Abhrama, “UThixo ungincitshile abantwana. Hamba, wembathe lencekukazi yami; mhlawumbe lami ngingaba lendlu ngaye.” U-Abhrama wavuma kulokho okwakutshiwo nguSarayi. ");
INSERT INTO nde_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ngakho kwathi u-Abhrama esehlale eKhenani okweminyaka elitshumi, uSarayi umkakhe wathatha incekukazi yakhe yomGibhithe uHagari wamupha indoda yakhe ukuba ngumkayo. ");
INSERT INTO nde_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","U-Abhrama wambatha loHagari, wazithwala. Wathi esezibona esezithwele, waseqalisa ukweyisa inkosikazi yakhe. ");
INSERT INTO nde_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","USarayi wasesithi ku-Abhrama, “Ngumlandu wakho ukuze ngihlupheke kangaka. Incekukazi yami ngayethula ezandleni zakho, kodwa ithi ngoba isisazi ukuthi isizithwele isingeyisa. Sengathi uThixo angahlulela phakathi kwami lawe.” ");
INSERT INTO nde_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","U-Abhrama wathi, “Incekukazi yakho isezandleni zakho. Yenza lokho obona kufanele ngayo.” USarayi wasemphatha kubi uHagari; wacina embalekela. ");
INSERT INTO nde_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ingilosi kaThixo yamfumana uHagari eduze komthombo enkangala; kwakungumthombo oseceleni kwendlela eya eShuri. ");
INSERT INTO nde_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Yathi, “Hagari, ncekukazi kaSarayi, uvela ngaphi njalo uya ngaphi?” Waphendula wathi, “Ngibalekela inkosikazi yami, uSarayi.” ");
INSERT INTO nde_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ngakho ingilosi kaThixo yamtshela yathi, “Buyela enkosikazini yakho ufike uyilalele.” ");
INSERT INTO nde_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ingilosi kaThixo yengeza yathi, “Ngizakwandisa izizukulwane zakho zibe zinengi okungelakubalwa.” ");
INSERT INTO nde_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ingilosi kaThixo yaphinda yathi kuye: “Khathesi usuzithwele njalo uzabusiswa ngendodana. Kumele uyethe uthi ngu-Ishumayeli, ngoba uThixo usekuzwile ukukhala kwakho. ");
INSERT INTO nde_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Uzakuba yindoda engubabhemi weganga; isandla sakhe sizaxabana labantu bonke lesandla somuntu wonke sixabane laye, njalo uzaphila ngenzondano labafowabo bonke.” ");
INSERT INTO nde_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","UThixo owakhuluma laye wamutha lelibizo elithi: “UnguNkulunkulu ongibonayo,” ngoba wathi, “Manje sengimbonile lowo ongibonayo.” ");
INSERT INTO nde_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Yikho-nje umthombo lowo wabizwa ngokuthi yiBheri-Lahayi-Royi; ulokhu usekhona, phakathi kweKhadeshi leBheredi. ");
INSERT INTO nde_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ngakho uHagari wazalela u-Abhrama indodana, u-Abhrama wamutha ibizo lokuthi ngu-Ishumayeli. ");
INSERT INTO nde_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","U-Abhrama wayeleminyaka yokuzalwa engamatshumi ayisificaminwembili lesithupha lapho uHagari emzalela u-Ishumayeli. ");
INSERT INTO nde_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","U-Abhrama eseleminyaka engamatshumi ayisificamunwemunye lasificamunwemunye yobudala, uThixo wabonakala kuye wathi, “NginguNkulunkulu uSomandla; hamba ngokwethembeka phambi kwami, ungasoleki. ");
INSERT INTO nde_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ngizasiqinisa isivumelwano phakathi kwami lawe, ngandise njalo ubunengi benu.” ");
INSERT INTO nde_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","U-Abhrama wawa wathi mbo phansi ngobuso, uNkulunkulu wathi kuye, ");
INSERT INTO nde_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Mina ngokwami ngithi lesi yisivumelwano sami lawe: uzakuba nguyise wezizwe ezinengi. ");
INSERT INTO nde_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Kawusayi kubizwa ngokuthi Abhrama; ibizo lakho selizakuba ngu-Abhrahama, ngoba sengikwenze uyise wezizwe ezinengi. ");
INSERT INTO nde_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ngizakwenza uzuze inzalo enengi; ngizakwenza izizwe ngawe, njalo amakhosi azaphuma kuwe. ");
INSERT INTO nde_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ngizaqinisa isivumelwano sami sibe yisivumelwano sanini lanini phakathi kwami lawe kanye lezizukulwane ezizayo ukuba nguNkulunkulu wakho, loNkulunkulu wezizukulwane zakho ngemva kwakho. ");
INSERT INTO nde_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ilizwe lonke laseKhenani, okwamanje ohlala njengowezizwe kulo, ngizakupha libe yilifa laphakade kuwe lezizukulwane zakho ngemva kwakho; njalo ngizakuba nguNkulunkulu wabo.” ");
INSERT INTO nde_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","UNkulunkulu wasesithi ku-Abhrahama, “Wena kumele ugcine isivumelwano sami, wena lezizukulwane zakho ezizayo. ");
INSERT INTO nde_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Lesi yisivumelwano sami lawe lezizukulwane ezizayo, isivumelwano okumele usigcine: Wonke umuntu wesilisa phakathi kwenu kuzamele asokwe. ");
INSERT INTO nde_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Wena kumele usokwe, lokho kuzakuba yisiboniso sesivumelwano phakathi kwami lawe. ");
INSERT INTO nde_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Kuzizukulwane ezizayo umuntu wonke wesilisa ophakathi kwenu oselezinsuku eziyisificaminwembili kumele asokwe, kusitsho lalabo abazalwa emzini wakho loba abathengwa ngemali emuntwini wezizwe, labo abangazalwa nguwe. ");
INSERT INTO nde_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Loba abazalwa emzini wakho kumbe abathengwa ngemali, kumele basokwe. Isivumelwano sami enyameni yakho sizakuba yisivumelwano esingapheliyo. ");
INSERT INTO nde_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Lowo owesilisa ongasokwanga, ongazange ake asokwe enyameni uzakhalalwa ngabantu bakibo; usephule isivumelwano sami.” ");
INSERT INTO nde_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","UNkulunkulu waphinda njalo wathi ku-Abhrahama, “Umkakho uSarayi, ungabe usambiza ngokuthi nguSarayi; ibizo lakhe selinguSara. ");
INSERT INTO nde_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ngizambusisa, njalo ngizakunika indodana ngaye. Ngizambusisa ukuze abe ngunina wezizwe; amakhosi ezizwe azavela kuye.” ");
INSERT INTO nde_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","U-Abhrahama wawa wathi mbo ngobuso phansi; wahleka wazitshela wathi, “Kambe indodana ingazalwa ngumuntu oseleminyaka elikhulu na? USara angamzala umntwana yena eseleminyaka engamatshumi ayisificamunwemunye na?” ");
INSERT INTO nde_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ngakho u-Abhrahama wasesithi kuNkulunkulu, “Nxa u-Ishumayeli engaphila ngaphansi kwesibusiso sakho kuphela!” ");
INSERT INTO nde_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","UNkulunkulu wasesithi, “Yebo, uSara uzakuzalela indodana, wena uyibize ngokuthi ngu-Isaka. Ngizaqinisa isivumelwano sami laye sibe yisivumelwano esingapheliyo lezizukulwane eziza ngemva kwakhe. ");
INSERT INTO nde_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Mayelana lo-Ishumayeli, ngizwile okutshiloyo: ngeqiniso ngizambusisa; ngizamnika inzalo enkulu, ngandise ubunengi bayo. Uzakuba nguyise wababusi abalitshumi lambili, ngimenze abe yisizwe esikhulu. ");
INSERT INTO nde_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Kodwa isivumelwano sami ngizasiqinisa lo-Isaka, ozamzalelwa nguSara ngalesisikhathi ngomnyaka ozayo.” ");
INSERT INTO nde_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Eseqedile ukukhuluma lo-Abhrahama, uNkulunkulu wenyuka wamtshiya. ");
INSERT INTO nde_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ngalelolanga u-Abhrahama wathatha indodana yakhe u-Ishumayeli labo bonke abazalelwa emzini wakhe loba abathengwayo ngemali yakhe wabasoka, njengoba uNkulunkulu wayemtshelile. ");
INSERT INTO nde_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","U-Abhrahama wayeleminyaka yokuzalwa engamatshumi ayisificamunwemunye lasificamunwemunye mhla esokwa, ");
INSERT INTO nde_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","indodana yakhe u-Ishumayeli yayileminyaka yokuzalwa elitshumi lantathu; ");
INSERT INTO nde_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","u-Abhrahama lendodana yakhe u-Ishumayeli bobabili basokwa mhlalokho ngalanga linye. ");
INSERT INTO nde_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Njalo bonke abesilisa ababesemzini ka-Abhrahama, kugoqela labo abazalelwa khonapho ekhaya labathengwa kwabezizwe, basokwa kanye laye. ");
INSERT INTO nde_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","UThixo wabonakala ku-Abhrahama eduzane lezihlahla ezinkulu zikaMamure, ehlezi emnyango wethente lakhe, ilanga litshisa kakhulu. ");
INSERT INTO nde_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","U-Abhrahama waphosa amehlo wabona amadoda amathathu emi eduze. Wonela ukuwabona wasuka ngokuphangisa emnyango wethente lakhe wawahlangabeza wafika wakhothama phansi. ");
INSERT INTO nde_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Wathi, “Nxa ngifumene umusa kuwe, nkosi yami, ungedluli eceleni kwenceku yakho. ");
INSERT INTO nde_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Akulethwe amanzi amalutshwana nje, ukuze lonke ligeze inyawo zenu, keliphumule ngaphansi kwesihlahla lesi. ");
INSERT INTO nde_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Wothini ngilidingele ukudla ukuze lizuze amandla andubana liqhubeke ngohambo lwenu njengoba nje selizile encekwini yenu.” Baphendula bathi, “Kulungile, yenza lokho okutshoyo.” ");
INSERT INTO nde_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ngakho u-Abhrahama waphanga waya ethenteni kuSara. Wathi, “Phangisa, thatha izilinganiso ezintathu zefulawa ecolekileyo, uvube inhlama wenze isinkwa.” ");
INSERT INTO nde_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Waphanga waya emhlambini wakhetha iguqana elihle, elibuthakathaka walipha isisebenzi ukuba silihlinze. ");
INSERT INTO nde_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Waseletha izankefu zamasi, lochago kanye leguqa elaselilungisiwe, konke wakubeka phambi kwabo. Bathi besidla yena wema eduzane labo ngaphansi kwesihlahla. ");
INSERT INTO nde_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Bambuza bathi, “Ungaphi umkakho uSara na?” Wathi, “Ulaphayana, ethenteni.” ");
INSERT INTO nde_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","UThixo wasesithi, “Ngizabuya ngempela kuwe ngalesisikhathi ngomnyaka ozayo, njalo umkakho uSara uzakuba lendodana.” USara wayelokhu elalele esemnyango wethente elalingemuva kwakhe. ");
INSERT INTO nde_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","U-Abhrahama loSara basebevele sebebadala kakhulu, uSara esedlule isikhathi sokuba labantwana. ");
INSERT INTO nde_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ngakho uSara wahleka yedwa, wakhumbula wathi, “Kambe sengigugile kanje lenkosi yami isindala, ngingakhona ngizuza intokozo le?” ");
INSERT INTO nde_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","UThixo wasesithi ku-Abhrahama, “Kungani uSara ehlekile njalo wathi, ‘Kambe sibili ngizakuba lomntwana mina sengiluphele?’ ");
INSERT INTO nde_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Kambe kulolutho olwehlula uThixo na? Ngizabuya kuwe ngesikhathi esimisiweyo ngomnyaka ozayo, njalo uSara uzakuba lendodana.” ");
INSERT INTO nde_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","USara wesaba, yikho waqamba amanga wathi, “Kangizange ngihleke mina.” Kodwa wathi, “Ye, uhlekile.” ");
INSERT INTO nde_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Amadoda asuka ahamba aqonda eSodoma, u-Abhrahama wawaphelekezela ukuwakhupha. ");
INSERT INTO nde_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","UThixo wasesithi, “Ngimfihlele yini u-Abhrahama lokho esengizakwenza na? ");
INSERT INTO nde_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ngempela u-Abhrahama uzakuba yisizwe esikhulu esilamandla, njalo zonke izizwe zomhlaba zizabusiswa ngaye. ");
INSERT INTO nde_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ngoba sengimkhethile, ukuze aqondise abantwabakhe lomuzi wakhe, yena esedlule, ukugcina indlela kaThixo ngokwenza okulungileyo lokuqondileyo, ukuze uThixo amenzele u-Abhrahama lokho amthembise khona.” ");
INSERT INTO nde_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","UThixo wasesithi kuye, “Insolo ngeSodoma leGomora inkulu kakhulu njalo isono sakhona siyesabeka ");
INSERT INTO nde_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","okokuthi sengizakuya khona ngiyebona ingabe lokho abakwenzileyo kubi okulingana lensolo le esifikile kimi. Nxa kungenjalo, ngizakwazi.” ");
INSERT INTO nde_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Amadoda akhangela phambili aqonda eSodoma, kodwa u-Abhrahama wasala emi phambi kukaThixo. ");
INSERT INTO nde_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ngakho u-Abhrahama waya kuye wathi: “Uzabhubhisa abalungileyo kanye lababi na? ");
INSERT INTO nde_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Pho nxa kukhona abangamatshumi amahlanu kulelodolobho ke? Ngempela uzalikhucula na ungalixoleli ngenxa yabangamatshumi amahlanu abalungileyo abakulo na? ");
INSERT INTO nde_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Akube khatshana lawe ukwenza into enjalo, ukubulala abalungileyo lababi. Kakube khatshana lawe lokho! Kambe uMahluleli womhlaba wonke kayikwenza okufaneleyo na?” ");
INSERT INTO nde_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","UThixo wathi, “Nxa ngifumana abangamatshumi amahlanu abalungileyo edolobheni laseSodoma, ngizalixolela lonke idolobho ngenxa yabo.” ");
INSERT INTO nde_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","U-Abhrahama waphinda wakhuluma njalo wathi: “Njengoba sengibe lesibindi esingaka sokukhuluma loThixo, loba ngingasulutho mina, ngiluthuli nje lomlotha, ");
INSERT INTO nde_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","pho nxa inani labalungileyo lingaphansi ngabahlanu ematshumini amahlanu? Uzalibhubhisa idolobho lonke ngenxa yabantu abahlanu na?” Wathi, “Ngingafumana abangamatshumi amane lanhlanu kangiyikulibhubhisa.” ");
INSERT INTO nde_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Waphinda njalo wakhuluma laye wathi, “Nxa kufunyanwa amatshumi amane kuphela-ke?” Yena wathi, “Ngenxa yabangamatshumi amane kangizukukwenza.” ");
INSERT INTO nde_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ngakho wasesithi, “UThixo makangathukutheli, kodwa ake ngikhulume. Kungafunyanwa khona amatshumi amathathu ke?” Waphendula wathi, “Kangizukukwenza ngingafumana khona amatshumi amathathu.” ");
INSERT INTO nde_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","U-Abhrahama wathi, “Kambe njengoba ngibe lesibindi esingaka ngaze ngakhuluma loThixo, pho nxa kufunyanwa abangamatshumi amabili khona kuphela-ke?” Wathi, “Ngenxa yabangamatshumi amabili kangiyikulibhubhisa.” ");
INSERT INTO nde_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Waphinda wathi, “UThixo angathukutheli, kodwa ake ngikhulume kanye kuphela njalo. Kambe nxa kungafunyanwa itshumi lodwa-ke?” Waphendula wathi, “Ngenxa yabalitshumi kangiyikulibhubhisa.” ");
INSERT INTO nde_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Kwathi uThixo eseqedile ukukhuluma lo-Abhrahama wasuka, lo-Abhrahama wabuyela ngekhaya. ");
INSERT INTO nde_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Izingilosi zombili zafika eSodoma kusihlwa, uLothi ehlezi esangweni ledolobho. Wathi ezibona wasukuma wazihlangabeza wathi mbo phansi ngobuso. ");
INSERT INTO nde_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Wathi, “Makhosi ami, ake liphambukele endlini yenceku yenu. Lingageza inyawo zenu, lilale khona andubana liqhubeke ngendlela yenu ekuseni.” Zaphendula zathi, “Hatshi, sizalala egcekeni phandle.” ");
INSERT INTO nde_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Kodwa waphikelela kakhulukazi zaze zahamba laye zangena endlini yakhe. Wazilungisela ukudla, wazenzela isinkwa esingelamvubelo, zadla. ");
INSERT INTO nde_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Zingakayilala, amadoda aqhamuka kuzozonke izindawo zedolobho laseSodoma, amajaha lamaxhegu, ayihanqa indlu. ");
INSERT INTO nde_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Amemeza uLothi athi, “Angaphi amadoda afike emzini wakho lamuhla kusihlwa? Akhuphe eze lapha ngoba sifuna ukulala lawo siwenze abafazi.” ");
INSERT INTO nde_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","ULothi waphuma wayakhuluma lawo wavala umnyango ngemva kwakhe, ");
INSERT INTO nde_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","wathi, “Hatshi, bazalwane. Lingenzi linto embi kangaka. ");
INSERT INTO nde_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Khangelani, ngilamadodakazi amabili angakaze alale lendoda. Wothini ngiwalethe lapha kini lenze elikuthandayo ngawo. Kodwa lingenzi lutho emadodeni ngoba angaphansi komthunzi wophahla lwami.” ");
INSERT INTO nde_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Aphendula athi, “Suka endleleni yethu.” Babuye bathi, “Umuntu lo weza lapha njengowezizwe, kodwa khathesi usefuna ukuba ngumahluleli! Wena-ke sizakuthwalisa nzima kulawo.” Babelokhu beminyezela uLothi, bafuqela phambili bezama ukwephula isivalo. ");
INSERT INTO nde_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Kodwa amadoda lawo ayephakathi avula adonsela uLothi endlini avala isivalo. ");
INSERT INTO nde_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Asewatshaya ngobuphofu amadoda ayesemnyango wendlu leyo, amajaha lamaxhegu, asesehluleka ukubona umnyango. ");
INSERT INTO nde_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Amadoda lawo amabili athi kuLothi, “Bakhona yini abanye olabo lapha abakhwenyana, amadodana kumbe amadodakazi, loba nje omunye edolobheni leli ongowakho? Bakhuphe lapha, ");
INSERT INTO nde_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ngoba sizayibhubhisa indawo le. Insolo efika kuThixo ngalababantu inkulu kabi okokuthi useze wasithuma ukuthi silibhubhise.” ");
INSERT INTO nde_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ngakho uLothi waphuma wayakhuluma labakhwenyana bakhe, labo abasebethembise ukulobola amadodakazi akhe. Wathi, “Phangisani, phumani kulindawo, ngoba uThixo usezalibhubhisa idolobho leli!” Kodwa abakhwenyana bakhe bacabanga ukuthi wenza amahlaya. ");
INSERT INTO nde_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Kwathi emathathakusa izingilosi zakhuthaza uLothi zathi, “Phangisa! Thatha umkakho lamadodakazi akho womabili akhona lapha, ngoba lizaqabuka likhukhulwa nxa idolobho selijeziswa.” ");
INSERT INTO nde_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Wathi esatomatoma, amadoda ambamba ngesandla kanye lesandla somkakhe lezamadodakazi akhe womabili abaholela ngaphandle kwedolobho bephephile, ngoba uThixo wayelomusa kubo. ");
INSERT INTO nde_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Bonela ukuthi bakhutshwe, omunye wazo wathi, “Balekani liqinise! Lingakhangeli emuva, njalo lingemi ndawo emagcekeni! Balekelani ezintabeni funa likhukhulwe!” ");
INSERT INTO nde_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Kodwa uLothi wathi kuzo, “Hatshi, makhosi ami, bakithi! ");
INSERT INTO nde_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Inceku yenu isizuze umusa emehlweni enu, njalo selitshengise umusa omkhulu kimi ngokuphephisa impilo yami. Kodwa ngingeke ngibalekele ezintabeni; ububi lobu buzangifica ngihle ngife. ");
INSERT INTO nde_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Khangelani, nanku umuzi oseduze engingabalekela kuwo, njalo mncinyane, wothini ngibalekele kuwo, mncinyane, kawunjalo? Lapho ngizasinda.” ");
INSERT INTO nde_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Yathi kuye, “Kulungile, ngiyasamukela njalo lalesisicelo; kangizukuwubhidliza umuzi okhuluma ngawo. ");
INSERT INTO nde_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Kodwa balekela khona masinyane, ngoba kangiyikwenza lutho uze ufike khona.” (Yikho umuzi lowo wabizwa ngokuthi yiZowari.) ");
INSERT INTO nde_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ngesikhathi uLothi efika eZowari ilanga laseliphumile elizweni. ");
INSERT INTO nde_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","UThixo wasenisa umlilo wesolufa etshisayo phezu kweSodoma leGomora, uvela kuThixo usehla emazulwini. ");
INSERT INTO nde_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Kanjalo wawabhidliza amadolobho lamagceke wonke, labo bonke ababehlala kuwo amadolobho kanye lokumila emhlabathini. ");
INSERT INTO nde_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Kodwa umkaLothi wakhangela emuva, waphenduka isiduli setswayi. ");
INSERT INTO nde_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ekuseni kakhulu ngosuku olulandelayo u-Abhrahama wasuka wabuyela endaweni lapho ayeme phambi kukaThixo khona. ");
INSERT INTO nde_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Wakhangela malungana leSodoma leGomora, malungana lalo lonke ilizwe lamagceke, wabona izikhatha zentuthu ziqonga zisuka phansi, njengomlilo usuka esithandweni somlilo. ");
INSERT INTO nde_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ngakho kwathi uNkulunkulu ebhubhisa amadolobho asemagcekeni wakhumbula u-Abhrahama, wamkhupha uLothi enkemenkemeni eyatshabalalisa amadolobho lapho uLothi ayekade ehlala khona. ");
INSERT INTO nde_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","ULothi lamadodakazi akhe womabili basuka eZowari bayahlala ezintabeni, ngoba wayesesaba ukuhlala eZowari. Yena lamadodakazi akhe womabili babehlala ebhalwini. ");
INSERT INTO nde_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ngolunye usuku indodakazi endala yathi kwencinyane, “Ubaba useluphele, njalo kakulandoda lapha engalala lathi, njengoba kungumkhuba emhlabeni wonke. ");
INSERT INTO nde_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Kasidakise ubaba ngewayini besesilala laye ukuze silombe usendo lwakwethu ngobaba.” ");
INSERT INTO nde_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ngalobobusuku uyise bamnathisa iwayini, indodakazi endala yangena yembatha laye. Yena kayibonanga izolala loba isivuka. ");
INSERT INTO nde_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ngosuku olulandelayo indodakazi endala yathi kwencinyane, “Izolo ebusuku ngembathe lobaba. Kasimdakise futhi ngewayini ngobusuku balamuhla lawe uhambe uyokwembatha laye ukuze silondoloze usendo lwakithi ngobaba.” ");
INSERT INTO nde_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Bamdakisa-ke uyise ngewayini ngalobobusuku njalo, indodakazi encinyane yahamba yayakwembatha laye. Njalo kazange ananzelele ukuthi walala nini lokuthi wavuka nini. ");
INSERT INTO nde_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Ngakho womabili amadodakazi kaLothi athatha izisu kuyise. ");
INSERT INTO nde_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Indodakazi endala yazala indodana yamutha ibizo yathi nguMowabi: nguye uyise wamaMowabi alamuhla nje. ");
INSERT INTO nde_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Indodakazi encinyane layo yazala indodana, yayitha yathi nguBheni-Ami; nguye uyise wama-Amoni alamuhla nje. ");
INSERT INTO nde_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","U-Abhrahama wathutha kuleyondawo waya emangweni waseNegebi wayahlala phakathi kweKhadeshi leShuri. Okwesikhatshana wake wahlala eGerari, ");
INSERT INTO nde_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","lapho u-Abhrahama athi khona ngomkakhe uSara, “Ngudadewethu.” Ngakho u-Abhimelekhi inkosi yaseGerari yathi uSara kalethwe, yazithathela. ");
INSERT INTO nde_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Kodwa uNkulunkulu wafika ku-Abhimelekhi ephutsheni ebusuku wathi kuye, “Usufile wena ngenxa yomfazi omthetheyo; ngumfazi womnikazi.” ");
INSERT INTO nde_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Kodwa u-Abhimelekhi wayelokhu engakamthinti, ngakho wathi, “Thixo, uzasibhubhisa isizwe esimsulwa na? ");
INSERT INTO nde_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Katshongo kimi yini wathi, ‘Ngudadewethu,’ laye katshongo na wathi, ‘Ungumnewethu?’ Lokhu ngikwenze ngenhliziyo emsulwa langezandla ezimhlophe.” ");
INSERT INTO nde_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ngalokho uNkulunkulu wasesithi kuye ephutsheni, “Yebo, ngiyakwazi ukuthi lokhu ukwenze ngenhliziyo emsulwa, yikho ngikuthintile ukuthi ungenzi isono kimi. Yikho ngingakuyekelanga wamthinta. ");
INSERT INTO nde_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Manje mbuyisele umfazi womuntu, ngoba umuntu lowo ungumphrofethi, uzakukhulekela ukuthi uphile. Kodwa nxa ungambuyiseli, yazi ukuthi wena lakho konke okungokwakho kuzakufa.” ");
INSERT INTO nde_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Kusisa ngelanga elilandelayo ekuseni kakhulu, u-Abhimelekhi wabiza zonke izikhulu zakhe, kwathi esezitshelile konke okwenzakeleyo, zesaba kakhulu. ");
INSERT INTO nde_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","U-Abhimelekhi wasebiza u-Abhrahama wathi, “Ukwenzeleni lokhu kithi na? Ngikone ngani uze ulethe ukona okunje phezu kwami lombuso wami na? Wenze kimi izinto okungafanelanga zenziwe.” ");
INSERT INTO nde_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","U-Abhimelekhi wabuza u-Abhrahama wathi, “Besiyini isizatho sakho sokwenza lokhu na?” ");
INSERT INTO nde_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","U-Abhrahama waphendula wathi, “Ngazitshela ngathi, ‘Ngempela kakukho ukumesaba uNkulunkulu kule indawo njalo bazangibulala ngenxa yomkami.’ ");
INSERT INTO nde_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ngaphandle kwalokho, uvele ungudadewethu, indodakazi kababa kodwa engasuye kamama; waba ngumkami. ");
INSERT INTO nde_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Kwathi uNkulunkulu esengisusile emzini kababa ngathi kuSara, ‘Nansi indlela ongatshengisa ngayo uthando lwakho kimi: Noma ngaphi lapho esiya khona, ubokuthi ngami, “Ungumnewethu.” ’ ” ");
INSERT INTO nde_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","U-Abhimelekhi waseletha izimvu lenkomo, lezisebenzi zesilisa lezesifazane wazipha u-Abhrahama, wabuyisela uSara umkakhe kuye. ");
INSERT INTO nde_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Njalo u-Abhimelekhi wathi, “Nanti ilizwe lami uyalibona; ungahlala lapho othanda khona.” ");
INSERT INTO nde_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Wathi kuSara, “Umnewenu ngimupha amashekeli esiliva ayinkulungwane. Le iyinhlawulo yehlazo elenziwe kuwe phambi kwabantu bonke bakini; usugeziwe.” ");
INSERT INTO nde_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","U-Abhrahama wasekhuleka kuNkulunkulu, uNkulunkulu wamsilisa u-Abhimelekhi, lomkakhe lezigqili zakhe zesifazane ukuthi babelabantwana njalo, ");
INSERT INTO nde_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","ngoba uThixo wayevale bonke abesifazane bendlu ka-Abhimelekhi inzalo ngenxa yomka-Abhrahama, uSara. ");
INSERT INTO nde_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Ngakho uThixo waba lomusa kuSara njengoba wayetshilo, uThixo wamenzela uSara lokho ayekuthembisile. ");
INSERT INTO nde_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","USara wazithwala wazalela u-Abhrahama ebudaleni bakhe indodana ngesikhathi sonaleso uNkulunkulu ayemthembise sona. ");
INSERT INTO nde_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","U-Abhrahama wayitha ibizo elithi Isaka leyondodana ayizalelwa nguSara. ");
INSERT INTO nde_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Kwathi indodana yakhe u-Isaka isilensuku eziyisificaminwembili izelwe, u-Abhrahama wayisoka, njengoba walaywa nguNkulunkulu. ");
INSERT INTO nde_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","U-Abhrahama wayeseleminyaka elikhulu ekuzalweni kwendodana yakhe u-Isaka. ");
INSERT INTO nde_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","USara wathi, “UNkulunkulu usengilethele intokozo, njalo bonke abazakuzwa lokhu bazathokoza lami.” ");
INSERT INTO nde_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Wabuye wengeza wathi, “Kambe ngubani obengatsho ku-Abhrahama ukuthi uSara angondla abantwana? Kodwa sengimzalele indodana ebudaleni bakhe.” ");
INSERT INTO nde_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Wakhula umntwana, walunyulwa, kwathi mhla u-Isaka elunyulwa u-Abhrahama wenza idili elikhulu. ");
INSERT INTO nde_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Kodwa uSara wabona ukuthi indodana kaHagari umGibhithe, ayeyizalele u-Abhrahama yayikloloda, ");
INSERT INTO nde_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","wasesithi ku-Abhrahama, “Mxotshe umfazi lo oyisigqili kanye lendodana yakhe, ngoba indodana yesigqilikazi lesi kayisoze yabelana ilifa lendodana yami u-Isaka.” ");
INSERT INTO nde_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Indaba le yamhlupha kakhulu u-Abhrahama ngoba yayithintana lendodana yakhe. ");
INSERT INTO nde_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Kodwa uNkulunkulu wathi kuye, “Ungakhathazeki kakhulu ngomfana kanye lesigqilikazi sakho. Lalela konke uSara akutshela khona ngoba isizukulwane sakho sizabalwa ngo-Isaka. ");
INSERT INTO nde_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Indodana le eyesigqilikazi layo ngizayenza ibe yisizwe ngoba iyinzalo yakho.” ");
INSERT INTO nde_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ngosuku olulandelayo ekuseni kakhulu u-Abhrahama wathatha ukudla lesigxingi samanzi wakunika uHagari. Wakwetshata emahlombe kaHagari, wasebakhupha lomfana. Owesifazane wasuka wayantula enkangala yaseBherishebha. ");
INSERT INTO nde_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Esephelile amanzi esigxingini, wabeka umntwana ngaphansi kwesixuku. ");
INSERT INTO nde_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Yena wasuka wayahlala bucwadlana, okungaba libanga lokuphosa umtshoko, ngoba wacabanga wathi, “Ngeke ngibukele umfana esifa.” Kwathi ehlezi khonapho bucwala wakhala ebubula. ");
INSERT INTO nde_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","UNkulunkulu wamuzwa umfanyana ekhala, ingilosi kaNkulunkulu yasibiza uHagari isezulwini yathi kuye, “Kwenzenjani, Hagari? Ungesabi; uNkulunkulu usekuzwile ukukhala komfana elele khonaphayana. ");
INSERT INTO nde_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Mphakamise umfana umbambe ngesandla, ngoba ngizamenza abe yisizwe esikhulu.” ");
INSERT INTO nde_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","UNkulunkulu wasemvula amehlo, wabona umthombo wamanzi. Ngakho wasesiyagcwalisa umgodla ngamanzi wapha umfana wanatha. ");
INSERT INTO nde_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","UNkulunkulu wayelaye umfana ekhula. Wahlala enkangala waba ngumcibi womtshoko. ");
INSERT INTO nde_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Wathi ehlala eNkangala yasePharani, unina wamdingela umfazi eGibhithe. ");
INSERT INTO nde_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ngalesosikhathi u-Abhimelekhi loFikholi, umlawuli wamabutho akhe bathi ku-Abhrahama, “UNkulunkulu ulawe kukho konke okwenzayo. ");
INSERT INTO nde_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Khathesi-ke funga kimi khonapha phambi kukaNkulunkulu ukuthi kawusoze wenze izinto zobuqili kimi, loba ebantwaneni bami loba kuzizukulwane zami. Tshengisa kimi lakulo ilizwe ohlezi kulo njengesizwe wona lowomusa engikwenzele wona.” ");
INSERT INTO nde_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","U-Abhrahama wathi, “Ngiyafunga.” ");
INSERT INTO nde_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","U-Abhrahama wasesola ku-Abhimelekhi ngomthombo izinceku zika-Abhimelekhi ezaziwuthumbile. ");
INSERT INTO nde_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Kodwa u-Abhimelekhi wathi, “Angikwazi ukuthi ngubani okwenzileyo lokho. Kawuzange ungitshele, sekuyikhona ngikuzwa nje lamhla.” ");
INSERT INTO nde_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ngakho u-Abhrahama waletha izimvu lenkomo wazipha u-Abhimelekhi, amadoda womabili enza isivumelwano. ");
INSERT INTO nde_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","U-Abhrahama wehlukanisa amazinyane amasikazi ayisikhombisa emhlambini, ");
INSERT INTO nde_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","u-Abhimelekhi wambuza u-Abhrahama wathi, “Atshoni amazinyane la amasikazi ayisikhombisa owehlukanise emhlambini wawabeka wodwa na?” ");
INSERT INTO nde_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Waphendula wathi, “Yamukela ezandleni zami amazinyane la ayisikhombisa njengobufakazi bokuthi yimi engemba umthombo lo.” ");
INSERT INTO nde_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ngakho indawo leyo yathiwa yiBherishebha ngoba amadoda la womabili enza isifungo khonapho. ");
INSERT INTO nde_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ngemva kokuba isivumelwano sesibotshiwe eBherishebha, u-Abhimelekhi loFikholi umlawuli wamabutho akhe babuyela elizweni lamaFilistiya. ");
INSERT INTO nde_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","U-Abhrahama wahlanyela isihlahla sethamarisiki eBherishebha, khonapho walibiza ibizo likaThixo, uNkulunkulu Waphakade. ");
INSERT INTO nde_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","U-Abhrahama wahlala elizweni lamaFilistiya okwesikhathi eside. ");
INSERT INTO nde_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Emva kwesikhathi esithile uNkulunkulu walinga u-Abhrahama. Wathi kuye, “Abhrahama!” Waphendula wathi, “Ngilapha.” ");
INSERT INTO nde_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","UNkulunkulu wasesithi, “Thatha indodana yakho, indodana yakho eyiyo yodwa, u-Isaka, omthandayo, uye emangweni waseMoriya. Khonapho menze umhlatshelo abe ngumnikelo wokutshiswa phezu kwenye yezintaba engizakutshengisa yona.” ");
INSERT INTO nde_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Kusisa ekuseni kakhulu u-Abhrahama wavuka wabopha ubabhemi wakhe. Wahamba lezinceku zakhe ezimbili kanye lendodana yakhe u-Isaka. Kwathi esegamule inkuni ezaneleyo zomnikelo wokutshiswa, waqhubeka waya kuleyondawo uNkulunkulu ayemtshele yona. ");
INSERT INTO nde_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ngelanga lesithathu u-Abhrahama wakhangela, wayibona leyondawo kude le. ");
INSERT INTO nde_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Wathi ezincekwini zakhe, “Hlalani lapha lobabhemi, mina lomfana sisake siye laphayana. Sizakuthi singakhonza sibuye kini.” ");
INSERT INTO nde_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","U-Abhrahama wathatha inkuni zomnikelo wokutshiswa wazithwalisa umntanakhe u-Isaka, yena ngokwakhe waphatha umlilo lengqamu. Kwathi belokhu beqhubeka bobabili, ");
INSERT INTO nde_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","u-Isaka wakhuluma wambuza uyise u-Abhrahama wathi, “Baba?” U-Abhrahama wasabela wathi, “Yebo, ndodana yami!” U-Isaka wathi, “Umlilo lenkuni nanku kukhona, kodwa iwundlu lomnikelo wokutshiswa lingaphi?” ");
INSERT INTO nde_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","U-Abhrahama waphendula wathi, “Ndodana yami, uNkulunkulu ngokwakhe uzasipha iwundlu lomnikelo wokutshiswa.” Baqhubeka bobabili bahamba. ");
INSERT INTO nde_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Sebefikile endaweni uNkulunkulu amtshela yona, u-Abhrahama wakha i-Alithari khonapho walungisa inkuni phezu kwalo. Wabopha indodana yakhe u-Isaka wayilalisa e-alithareni phezu kwenkuni. ");
INSERT INTO nde_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Waseselula isandla sakhe ethatha ingqamu ukuba abulale indodana yakhe. ");
INSERT INTO nde_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Kodwa ingilosi kaThixo yamemeza isezulwini yathi, “Abhrahama! Abhrahama!” Waphendula wathi, “Ngilapha.” ");
INSERT INTO nde_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Yathi, “Ungamthinti ngesandla sakho umfana. Ungenzi lutho kuye. Khathesi sengisazi ukuthi uyamesaba uNkulunkulu, ngoba kawuyigodlanga indodana yakho eyiyo yodwa.” ");
INSERT INTO nde_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","U-Abhrahama wathi uyakhangela wabona inqama esixukwini ibanjwe ngempondo zayo. Waya khona wayithatha inqama wenza umhlatshelo womnikelo wokutshiswa esikhundleni sendodana yakhe. ");
INSERT INTO nde_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Yikho u-Abhrahama wabiza indawo leyo ngokuthi uThixo Uzakupha. Kuze kube lamuhla kuthiwa, “Entabeni kaThixo kuzaphiwa.” ");
INSERT INTO nde_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ingilosi kaThixo yabiza u-Abhrahama isezulwini ngokwesibili ");
INSERT INTO nde_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","yathi, “Ngifunga ngami uqobo, kutsho uThixo, ukuthi ngenxa yokuthi ukwenzile lokhu, kawaze wayigodla indodana yakho eyiyo yodwa, ");
INSERT INTO nde_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ngempela ngizakubusisa ngenze izizukulwane zakho zibe zinengi njengezinkanyezi emkhathini lanjengetshebetshebe okhunjini lolwandle. Izizukulwane zakho zizawathatha amadolobho ezitha zazo, ");
INSERT INTO nde_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","kuthi ngenzalo yakho zonke izizwe zomhlaba zizabusiswa, ngoba ungilalele.” ");
INSERT INTO nde_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Emva kwalokho u-Abhrahama wabuyela ezincekwini zakhe, basebehamba bonke eBherishebha. U-Abhrahama wahlala eBherishebha. ");
INSERT INTO nde_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Emva kwesikhathi esithile u-Abhrahama watshelwa ukuthi, “UMilikha laye uselabantwana; sewazalela umfowenu uNahori amadodana: ");
INSERT INTO nde_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","u-Uzi izibulo, uBhuzi umfowabo, uKhemuweli (uyise ka-Aramu), ");
INSERT INTO nde_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","uKhesedi, uHazo, uPhilidashi, uJidilafu loBhethuweli.” ");
INSERT INTO nde_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","UBhethuweli wazala uRabheka. UMilikha wazala amadodana la ayisificaminwembili loNahori umfowabo ka-Abhrahama. ");
INSERT INTO nde_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Umfazi wakhe omncane owayethiwa nguRewuma laye wayelamadodana la: uThebha, uGahamu, uThahashi kanye loMahakha. ");
INSERT INTO nde_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","USara waphila waze waba leminyaka elikhulu lamatshumi amabili lesikhombisa obudala. ");
INSERT INTO nde_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Wafela eKhiriyathi Aribha (kutsho eHebhroni) elizweni laseKhenani, u-Abhrahama wahamba ukuyamzilela lokumlilela khona. ");
INSERT INTO nde_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","U-Abhrahama wasukuma eseceleni komkakhe ofileyo wakhuluma lamaHithi. Wathi, ");
INSERT INTO nde_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ngingowezizweni lesihambi phakathi kwenu. Ngithengiselani isiqinti sokuba yindawo yokungcwabela khona abakithi abafileyo.” ");
INSERT INTO nde_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","AmaHithi amphendula u-Abhrahama athi, ");
INSERT INTO nde_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Silalele, nkosi yami. Uyinkosana elamandla phakathi kwethu. Ngcwaba abafileyo bakini loba kukuwaphi amangcwaba ethu athandeka kakhulu. Kakho owakithi ozakwalela ingcwaba lakhe ukuthi ungcwabe kulo ofileyo wakini.” ");
INSERT INTO nde_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ngakho u-Abhrahama wasukuma wakhothamela phansi phambi kwamaHithi, abanikazi balelolizwe. ");
INSERT INTO nde_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Wathi kubo, “Nxa lithanda ukuthi ngimbele abafileyo bami, lalelani kimi, lingincengele ku-Efroni indodana kaZohari ");
INSERT INTO nde_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ukuthi angithengisele ubhalu Lwakhe lwaseMakhaphela olusekucineni kwesiqinti. Mceleni ukuthi angithengisele sona ngentengo egcweleyo sibe yindawo yamangcwaba phakathi kwenu.” ");
INSERT INTO nde_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","U-Efroni umHithi owayehlezi khonapho phakathi kwabantu bakibo wamphendula u-Abhrahama wonke amaHithi ayefikile esangweni ledolobho lakhe ezizwela. ");
INSERT INTO nde_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Wathi, “Hatshi, nkosi yami. Lalela kimi; ngiyakupha isiqinti, njalo ngiyakupha lobhalu oluphakathi kwaso. Ngikupha sona phambi kwabantu bakithi. Mbela abafileyo bakho.” ");
INSERT INTO nde_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","U-Abhrahama waphinda wakhothamela phansi phambi kwabantu balelolizwe ");
INSERT INTO nde_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","wathi ku-Efroni bona besizwa, “Ake ulalelisise engikutshoyo. Mina ngizayikhupha intengo yesiqinti. Ngicela uyamukele kimi ukuze ngimbele khona abafileyo bami.” ");
INSERT INTO nde_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","U-Efroni waphendula u-Abhrahama wathi, ");
INSERT INTO nde_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Lalela kimi, nkosi yami; isiqinti lesi sibiza amashekeli esiliva angamakhulu amane, kodwa kungena njani lokho phakathi kwami lawe? Wena mbela abafileyo bakho.” ");
INSERT INTO nde_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","U-Abhrahama wayivuma intengo ka-Efroni wasemlinganisela ubunzima bentengo ayeyibizile amaHithi esizwa: amashekeli esiliva angamakhulu amane, mayelana lesisindo esasisetshenziswa ngabathengisi. ");
INSERT INTO nde_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Ngakho isiqinti sika-Efroni eMakhaphela, eduze leMamure, isiqinti kanye lobhalu olwaluphakathi kwaso, lazozonke izihlahla ezaziphakathi kwaso, kwabhaliswa ");
INSERT INTO nde_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ngo-Abhrahama ukuthi sekuyimpahla yakhe, kusenziwa phambi kwamaHithi wonke ayefikile esangweni ledolobho. ");
INSERT INTO nde_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ngemva kwalokho u-Abhrahama wangcwaba umkakhe uSara ebhalwini olwalusesiqintini saseMakhaphela eduze leMamure (eseHebhroni) elizweni laseKhenani. ");
INSERT INTO nde_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Kanjalo isiqinti lobhalu olwaluphakathi kwaso kwabhaliswa ngo-Abhrahama ngama-Hithi ukuba yindawo yamangcwaba. ");
INSERT INTO nde_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","U-Abhrahama wayeseluphele kakhulu, njalo uThixo wayembusisile kukho konke. ");
INSERT INTO nde_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Wasesithi encekwini yakhe enkulu, leyo eyayilawula konke ayelakho, “Beka isandla sakho ngaphansi kwethangazi lami. ");
INSERT INTO nde_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Ngifuna ukuthi ufunge ngoThixo, uNkulunkulu wasezulwini loNkulunkulu wasemhlabeni, ukuthi kawuyikuzuzela indodana yami umfazi emadodakazini amaKhenani engihlala phakathi kwawo, ");
INSERT INTO nde_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","kodwa uzakuya elizweni lakithi lasezihlotsheni zami uzuzele indodana yami u-Isaka umfazi.” ");
INSERT INTO nde_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Inceku yambuza yathi, “Pho nxa lowo wesifazane engavumi ukuza lami kulelilizwe-ke? Ngizathatha indodana yakho ngiyise kulelolizwe lapho owavela khona na?” ");
INSERT INTO nde_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","U-Abhrahama wathi, “Ungaqali ukuhambisa indodana yami khonale. ");
INSERT INTO nde_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","UThixo, uNkulunkulu wasezulwini, owangikhupha emzini kababa laselizweni lakithi njalo owakhuluma kimi, wangithembisa ngesifungo wathi, ‘Ilizwe leli ngizalinika inzalo yakho,’ uzathuma ingilosi yakhe ihambe phambi kwakho ukuze ukwazi ukutholela indodana yami umfazi khonale. ");
INSERT INTO nde_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Nxa owesifazane lowo esala ukuza lapha lawe, uzabe usukhululwe kulesi isifungo sami. Kodwa ungaqali ukusa indodana yami khonale.” ");
INSERT INTO nde_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ngakho inceku yasifaka isandla sayo ngaphansi kwethangazi lenkosi yayo u-Abhrahama yafunga isifungo kuye ngodaba lolu. ");
INSERT INTO nde_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Inceku yasithatha amakamela enkosi yayo alitshumi yasuka, yathatha yonke imihlobo yezinto ezinhle zenkosi yayo. Yaqonda e-Aramu Naharayimu, yahamba yaze yayafika emzini waseNahori. ");
INSERT INTO nde_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Amakamela yawaguqisa phansi eduzane lomthombo ngaphandle komuzi; kwasekuntambama, sekuyisikhathi sabesifazane ukuyakukha amanzi. ");
INSERT INTO nde_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Yasikhuleka yathi, “Oh Thixo, Nkulunkulu wenkosi yami u-Abhrahama, yenza ngiphumelele lamuhla, utshengise umusa enkosini yami u-Abhrahama. ");
INSERT INTO nde_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Khangela-ke, nanku ngimi lapha eceleni komthombo lo, njalo amadodakazi abantu balelidolobho asesiza ukuzakukha amanzi. ");
INSERT INTO nde_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Kungasake kuthi ngingathi entombini, ‘Ake ungikhele amanzi ngenkezo yakho nginathe,’ yona ithi, ‘Natha, njalo ngizanathisa lamakamela akho,’ kube yiyo kanye oyikhethele inceku yakho u-Isaka. Ngalokho ngizakwazi ukuthi usutshengise umusa enkosini yami.” ");
INSERT INTO nde_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ingakaqedi ukukhuleka, uRabheka waphuma ethwele imbiza yakhe yamanzi ehlombe lakhe. Wayeyindodakazi kaBhethuweli indodana kaMilikha, owayengumfazi womfowabo ka-Abhrahama uNahori. ");
INSERT INTO nde_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Intombi le yayinhle kakhulu, igcwele; ingakaze ilale lendoda. Yehlela emthonjeni, yagcwalisa imbiza yayo yasiqansa. ");
INSERT INTO nde_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Inceku yaphanga yamhlangabeza yathi, “Ngicela amanzi embizeni yakho.” ");
INSERT INTO nde_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Wathi, “Natha nkosi yami,” watsho esehlisa imbiza eyibamba ngezandla emnathisa. ");
INSERT INTO nde_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Esemnathisile wathi, “Ngizakhelela lamakamela akho lawo ngiwanathise.” ");
INSERT INTO nde_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Wasethululela imbiza yakhe emkolweni, wagijimela emthonjeni njalo ukukha amanye, wawakhelela wonke amakamela akhe. ");
INSERT INTO nde_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Indoda yabukela ithule ilokhu inanzelela idinga ukubona ukuthi ngeqiniso uThixo wayeluphumelelisile yini uhambo lwayo. ");
INSERT INTO nde_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Amakamela eseqedile ukunatha, indoda leyo yakhupha isongo lamakhala elenziwe ngegolide elilobunzima obungaba yingxenye yeshekeli, lezigqizo zegolide ezimbili ezilobunzima bamashekeli alitshumi. ");
INSERT INTO nde_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Yasibuza yathi, “Uyindodakazi kabani na? Ake ungitshele, kambe singazuza indawo yini emzini kayihlo kesicatshise amakhanda ubusuku balamuhla nje?” ");
INSERT INTO nde_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","URabheka wamphendula wathi, “Ngiyindodakazi kaBhethuweli, indodana kaMilikha ayizalela uNahori.” ");
INSERT INTO nde_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Waphinda wengeza wathi, “Silotshani obunengi lamahlanga, kanye lendawo yokulala ikhona okwalamuhla ebusuku.” ");
INSERT INTO nde_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Indoda yakhothamela phansi yakhonza uThixo, ");
INSERT INTO nde_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","isithi, “Udumo kalube kuThixo, uNkulunkulu wenkosi yami u-Abhrahama, ongadelanga umusa wakhe lokuthembeka kwakhe enkosini yami. Mina ngokwami uThixo ungikhokhele ohanjweni lwami ngazafika endlini yezinini zenkosi yami.” ");
INSERT INTO nde_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Intombi yagijima yayabikela abendlu kanina ngalezizinto. ");
INSERT INTO nde_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","URabheka wayelomnewabo owayethiwa nguLabhani, yena waphanga waya kuleyondoda eyayisemthonjeni. ");
INSERT INTO nde_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Wonela ukubona isongo lamakhala kanye lezigqizo engalweni kadadewabo, njalo esezwile uRabheka elandisa ngokwakhulunywa yindoda leyo kuye, wasuka waya kuyo wayifica imi eceleni kwamakamela eduze komthombo. ");
INSERT INTO nde_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Wathi, “Woza, wena obusisiweyo nguThixo. Umeleni phandle lapha? Sengilungisile indlu lendawo yamakamela.” ");
INSERT INTO nde_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ngakho indoda yaya ngekhaya, lamakamela ethulwa imithwalo. Utshani lamahlanga kwalethwa emakameleni, yena lamadoda ayelawo balethelwa amanzi okugeza inyawo zabo. ");
INSERT INTO nde_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Kwasekulethwa ukudla kwabekwa phambi kwakhe, kodwa wathi, “Kangizukudla ngize ngiqale ngilitshele lokho okumele ngikutsho.” ULabhani wathi, “Sitshele phela.” ");
INSERT INTO nde_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ngakho wasesithi, “Ngiyinceku ka-Abhrahama. ");
INSERT INTO nde_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","UThixo uyibusisile inkosi yami kakhulu, isinothile kakhulu. Uyiphile izimvu lenkomo, isiliva legolide, lezinceku zesilisa lezesifazane kanye lamakamela labobabhemi. ");
INSERT INTO nde_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Inkosikazi yenkosi yami, uSara, imzalele indodana ebudaleni bayo, inkosi yami yasiyinika leyondodana konke elakho. ");
INSERT INTO nde_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Njalo inkosi yami yangifungisa isifungo yathi, ‘Ungazuzeli indodana yami umfazi emadodakazini amaKhenani, engihlala elizweni lawo, ");
INSERT INTO nde_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","kodwa yana ezininini zikababa, kwabosendo lwakithi, uzuzele indodana yami umfazi.’ ");
INSERT INTO nde_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ngasengiyibuza inkosi yami ngathi, ‘Pho nxa owesifazane lowo esala ukuza lapha-ke?’ ");
INSERT INTO nde_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Yaphendula yathi, ‘UThixo, engihamba phambi kwakhe, uzathumela ingilosi yakhe ihambe lawe, iphumelelise uhambo lwakho ukuze uzuzele indodana yami umfazi kwabosendo lwakithi, lasezininini zikababa. ");
INSERT INTO nde_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ngakho uzakuthi ungaya kwabosendo lwakithi, uzakhululwa esifungweni sami loba bangaze bale laye.’ ");
INSERT INTO nde_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Ngithe ukufika kwami emthonjeni lamuhla ngathi, ‘Oh Thixo, Nkulunkulu wenkosi yami u-Abhrahama, nxa uthanda, ngicela uphumelelise uhambo lolu engingalo lapha. ");
INSERT INTO nde_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Akubone, ngimi eceleni kwalo umthombo; nxa kufika intombi izokukha amanzi, ngithi kuyo, “Akunginathise amanzi amalutshwana enkonxeni yakho,” ");
INSERT INTO nde_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ingaze ithi kimi, “Natha, njalo ngizanathisa lamakamela akho lawo,” kabe nguye uThixo asemkhethele indodana yenkosi yami.’ ");
INSERT INTO nde_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ngingakaqedi ukukhuleka enhliziyweni yami, uRabheka waphuma, ethwele imbiza yakhe ehlombe. Wehlela emthonjeni wakha amanzi, ngathi kuye, ‘Akunginathise.’ ");
INSERT INTO nde_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Waphanga wethula imbiza yakhe ehlombe lakhe wathi, ‘Natha, ngizanathisa lamakamela akho njalo.’ Ngakho nganatha, waphinda wanathisa lamakamela njalo. ");
INSERT INTO nde_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ngambuza ngathi, ‘Uyindodakazi kabani wena?’ Wathi, ‘Indodakazi kaBhethuweli indodana kaNahori, amzala kuMilikha.’ Ngasengimgqizisa isongo emakhaleni lezigqizo ezingalweni zakhe, ");
INSERT INTO nde_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ngasengikhothamela phansi, ngamkhonza uThixo. Ngadumisa uThixo, uNkulunkulu wenkosi yami u-Abhrahama, ongikhokhele endleleni eqondileyo ngazathola intombi engumzukulu womfowabo wenkosi yami ngayizuzela indodana yayo inkosi yami. ");
INSERT INTO nde_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Manje-ke nxa lizatshengisa umusa lokwethembeka enkosini yami, ngitshelani; loba kungenjalo, ngitshelani ukuze ngazi ukuthi ngithini.” ");
INSERT INTO nde_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","ULabhani loBhethuweli baphendula bathi, “Lokhu kuvela kuThixo; kakukho esingakutsho kuwe, loba yini. ");
INSERT INTO nde_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Nangu uRabheka; mthathe uhambe laye ayekuba ngumfazi wendodana yenkosi yakho, njengalokhu okuqondiswe nguThixo.” ");
INSERT INTO nde_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Kwathi inceku ka-Abhrahama ikuzwa lokhu abakutshoyo yakhothama phansi emhlabathini phambi kukaThixo. ");
INSERT INTO nde_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ngakho inceku yasikhupha igolide lesiliva kanye lempahla zokugqoka yakupha uRabheka; yapha njalo umnewabo lonina izipho ezidulayo. ");
INSERT INTO nde_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Yena lamadoda ayehamba lawo basebesidla njalo banatha, balala khona. Bathi bevuka ekuseni wathi, “Sivumeleni sibuyele enkosini yami.” ");
INSERT INTO nde_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Kodwa umnewabo lonina baphendula bathi, “Ake ume kesihlale lentombazana okwensukwana ezingaba litshumi; lapho selingahamba-ke.” ");
INSERT INTO nde_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Kodwa wathi kubo, “Lingangibambeleli, njengoba uThixo eseluphumelelisile uhambo lwami. Wothini ngihambe ukuze ngiyefika enkosini yami.” ");
INSERT INTO nde_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Basebesithi, “Wothi sibize intombazana kesiyibuze ngakho.” ");
INSERT INTO nde_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ngakho bambiza uRabheka bambuza bathi, “Uyafuna ukuhamba layo indoda le na?” Wathi, “Ngizahamba layo.” ");
INSERT INTO nde_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ngakho basebemkhulula udadewabo uRabheka ukuba ahambe kanye lomlizane wakhe, bahamba lenceku ka-Abhrahama lamadoda ayelayo. ");
INSERT INTO nde_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Njalo bambusisa uRabheka bathi kuye, “Dadewethu, sengathi ungandisa izinkulungwane zezinkulungwane; sengathi inzalo yakho ingathumba amadolobho ezitha zayo.” ");
INSERT INTO nde_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","URabheka lamantombazana akhe bazilungiselela, basebekhwela amakamela abo bahamba lendoda leyo. Ngakho inceku yamthatha uRabheka yahamba. ");
INSERT INTO nde_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ngalesosikhathi u-Isaka wayesefikile evela eBheri-Lahayi-Royi, ngoba wayehlala eNegebi. ");
INSERT INTO nde_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ngenye intambama waya ensimini ehambahamba ukuthi ake ahluze ingqondo, wasesithi uyakhangela wabona amakamela esiza. ");
INSERT INTO nde_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","URabheka laye wakhangela wambona u-Isaka. Wehla ekameleni lakhe ");
INSERT INTO nde_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","wabuza inceku wathi, “Indoda leyana esensimini ngubani, leyana esihlangabezayo?” Inceku yaphendula yathi, “Uyinkosi yami.” Yikho uRabheka wasethatha ilembu elilula wazemboza ngalo. ");
INSERT INTO nde_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Inceku yasimtshela u-Isaka konke lokho eyayikwenzile. ");
INSERT INTO nde_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","U-Isaka wamngenisa ethenteni likanina uSara, wahle wamthatha uRabheka. Ngakho wasesiba ngumkakhe, wamthanda; u-Isaka waduduzeka ngemva kokufa kukanina. ");
INSERT INTO nde_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","U-Abhrahama wathatha omunye umfazi okwakuthiwa nguKhethura. ");
INSERT INTO nde_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Wamzalela uZimirani, uJokishani, uMedani, uMidiyani, u-Ishibhaki loShuwa. ");
INSERT INTO nde_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","UJokishani wazala uShebha loDedani; isizukulwane sikaDedani saba ngama-Ashuri, amaLethushi lamaLehumi. ");
INSERT INTO nde_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Amadodana kaMidiyani kwakungu-Efa, u-Eferi, uHanokhi, u-Abhida lo-Elida. Bonke laba babeyizizukulwane zikaKhethura. ");
INSERT INTO nde_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Konke u-Abhrahama ayelakho wakutshiyela u-Isaka. ");
INSERT INTO nde_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Kodwa esaphila wanika amadodana akhe awazala labafazi bakhe beceleni izipho, wabasusa eduze kwendodana yakhe u-Isaka baya elizweni lasempumalanga. ");
INSERT INTO nde_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","U-Abhrahama waphila okweminyaka elikhulu lamatshumi ayisikhombisa lanhlanu. ");
INSERT INTO nde_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Lapho u-Abhrahama waphefumula okokucina njalo wafa eseluphele, eselixhegu elileminyaka eminengi; wembelwa labakibo. ");
INSERT INTO nde_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Amadodana akhe u-Isaka lo-Ishumayeli bamngcwaba ebhalwini lwaseMakhaphela eduze leMamure, esiqintini sika-Efroni indodana kaZohari umHithi, ");
INSERT INTO nde_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","isiqinti leso u-Abhrahama asithenga kumaHithi. Khonapho u-Abhrahama wangcwatshwa lomkakhe uSara. ");
INSERT INTO nde_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ngemva kokuba esefile u-Abhrahama uNkulunkulu wayibusisa indodana yakhe u-Isaka, owayehlala eBheri-Lahayi-Royi. ");
INSERT INTO nde_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Lo ngumlando wendodana ka-Abhrahama u-Ishumayeli, incekukazi kaSara uHagari eyamzalela u-Abhrahama. ");
INSERT INTO nde_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","La ngamabizo abantwana baka-Ishumayeli behlelwe ngokwelamana kwabo: uNebhayothi izibulo lika-Ishumayeli, uKhedari, u-Adibheli, loMibhisamu, ");
INSERT INTO nde_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","uMishima, uDuma, uMasa, ");
INSERT INTO nde_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","uHadadi, uThema, uJethuri, uNafishi kanye loKhedema. ");
INSERT INTO nde_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","La ayengamadodana ka-Ishumayeli, njalo la ngamabizo ababusi bezizwana ezilitshumi lambili kulandela ukuhlaliswa kwazo lemizi yawo. ");
INSERT INTO nde_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","U-Ishumayeli waphila okweminyaka elikhulu lamatshumi amathathu lesikhombisa. Waphefumula okokucina wafa, wembelwa labakibo. ");
INSERT INTO nde_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Izizukulwane zakhe zakhela emangweni osuka eHavila kusiya eShuri, eduzane lomngcele waseGibhithe, nxa uqonda e-Asiriya. Njalo baphila belenzondo labafowabo bonke. ");
INSERT INTO nde_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Lo ngumlando wendodana ka-Abhrahama u-Isaka. U-Abhrahama wazala u-Isaka, ");
INSERT INTO nde_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","u-Isaka wathi eseleminyaka engamatshumi amane obudala wathatha uRabheka indodakazi kaBhethuweli umʼAramu wasePhadani Aramu njalo engudadewabo kaLabhani umʼAramu. ");
INSERT INTO nde_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","U-Isaka wakhuleka kuThixo ekhulekela umkakhe ngoba wayeyinyumba. UThixo wawuphendula umkhuleko wakhe, umkakhe uRabheka wazithwala. ");
INSERT INTO nde_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Abantwana bafuqana phakathi kwakhe, wathi, “Kungani lokhu kusenzakala kimi?” Ngakho wasehamba wayabuza kuThixo. ");
INSERT INTO nde_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","UThixo wathi kuye, “Izizwe ezimbili zisesiswini sakho, njalo abantu ababili phakathi kwakho bazakwehlukaniswa; omunye uzakuba lamandla kulomunye, kuthi omdala uzakhonza omncinyane.” ");
INSERT INTO nde_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Kwathi isikhathi sakhe sokubeletha sesifikile, kwakulamaphahla angabafana esiswini sakhe. ");
INSERT INTO nde_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Owabona ilanga kuqala wayebomvu, umzimba wakhe wonke ulihwanqa njengengubo yoboya; yikho bamutha bathi ngu-Esawu. ");
INSERT INTO nde_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ngemva kwalokhu, umfowabo walandela, isandla sakhe sibambe isithende sika-Esawu; ngakho wathiwa nguJakhobe. U-Isaka wayeleminyaka engamatshumi ayisithupha ngesikhathi uRabheka ebazala. ");
INSERT INTO nde_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Bakhula abafana, u-Esawu waba ngumzingeli omkhulu, indoda yegangeni, kodwa uJakhobe wayeyindoda ethuleyo, engasuki ngekhaya emathenteni. ");
INSERT INTO nde_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","U-Isaka owayethanda inyama yenyamazana wayethanda u-Esawu, kodwa uRabheka wayethanda uJakhobe. ");
INSERT INTO nde_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ngesinye isikhathi uJakhobe wayepheka inyama, u-Esawu wafika evela egangeni elambile. ");
INSERT INTO nde_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Wathi kuJakhobe, “Phangisa, akungiphe ukudla kwakho lokho osukukhanzinge kwaba bomvana! Sengifile ngendlala!” (Yikho wabizwa ngokuthi ngu-Edomi.) ");
INSERT INTO nde_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","UJakhobe waphendula wathi, “Qala ungithengisele ubuzibulo bakho.” ");
INSERT INTO nde_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","U-Esawu wathi, “Khangela, sengisifa. Bungisiza ngani ubuzibulo lobo?” ");
INSERT INTO nde_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Kodwa uJakhobe wathi, “Qala ufunge kimi.” Yikho wasefunga isifungo kuye, ethengisa ubuzibulo bakhe kuJakhobe. ");
INSERT INTO nde_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ngakho uJakhobe wasesipha u-Esawu isinkwa lokudla kwendumba eziphekwa ziluhlaza. Wadla, wanatha, wasukuma wahamba. Ngaleyondlela u-Esawu wabeyisa ubuzibulo bakhe. ");
INSERT INTO nde_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Kwasekusiba lendlala elizweni, ngaphandle kwendlala yakuqala eyayikhona ngesikhathi sika-Abhrahama, u-Isaka waya ku-Abhimelekhi inkosi yamaFilistiya eGerari. ");
INSERT INTO nde_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","UThixo wabonakala ku-Isaka wathi, “Ungehleli eGibhithe; hlala elizweni engithi hlala khona. ");
INSERT INTO nde_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ake uhlale kulelilizwe okwesikhatshana, mina ngizakuba lawe ngikubusise. Ngoba wena lezizukulwane zakho ngizalinika wonke amazwe la njalo ngiqinise isifungo engasifunga kuyihlo u-Abhrahama. ");
INSERT INTO nde_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ngizakwenza izizukulwane zakho zibe zinengi njengezinkanyezi emkhathini, ngizinike wonke lamazwe, njalo kuthi ngenzalo yakho zonke izizwe emhlabeni zizabusiswa, ");
INSERT INTO nde_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ngoba u-Abhrahama wangilalela, wagcina izimiso zami, lemilayo yami, kanye lemithetho yami.” ");
INSERT INTO nde_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ngakho u-Isaka wahlala eGerari. ");
INSERT INTO nde_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Kwathi lapho abantu baleyondawo bembuza ngomkakhe wathi, “Ngudadewethu,” ngoba wayesesaba ukuthi, “Ngumkami.” Wacabanga wathi, “Amadoda alapha angangibulala ngenxa kaRabheka, ngoba muhle kakhulu.” ");
INSERT INTO nde_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Kwathi u-Isaka esehlale khona okwesikhathi eside, u-Abhimelekhi inkosi yamaFilistiya wakhangela ngefasitela wabona u-Isaka egone umkakhe uRabheka. ");
INSERT INTO nde_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ngakho wasebiza u-Isaka wathi, “Kanti ngumkakho ngeqiniso! Kungani uthe ungudadewenu?” U-Isaka wamphendula wathi, “Ngoba ngakhumbula ukuthi ngingalahlekelwa yimpilo yami ngenxa yakhe.” ");
INSERT INTO nde_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","U-Abhimelekhi wasesithi, “Kuyini lokhu okwenzileyo kithi? Omunye wamadoda ubezaqabuka elala laye umkakho, ubususibangela icala.” ");
INSERT INTO nde_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ngakho u-Abhimelekhi wasekhupha umlayo ebantwini bonke wathi, “Lowo ozake ayithinte indoda le loba umkayo ngempela uzabulawa.” ");
INSERT INTO nde_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","U-Isaka walima amabele kulelolizwe, ngalowomnyaka wavuna okuphindwe ngekhulu, ngoba uThixo wambusisa. ");
INSERT INTO nde_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Umuntu lo wanotha kakhulu, lemfuyo yakhe yanda kakhulukazi. ");
INSERT INTO nde_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Waba lemihlambi yezimvu lenkomo emikhulu kakhulu, kanye lezisebenzi ezinengi, amaFilistiya aze aba lomona ngaye. ");
INSERT INTO nde_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Kwasekusithi yonke imithombo eyayigejwe yizisebenzi ngesikhathi sikayise u-Abhrahama, amaFilistiya ayivala ngokuyigqibela ngenhlabathi. ");
INSERT INTO nde_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","U-Abhimelekhi wasesithi ku-Isaka, “Suka kithi; ususuke waba lamandla kakhulu kulathi.” ");
INSERT INTO nde_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ngakho u-Isaka wasuka lapho wayakuma eSigodini saseGerari, wahle wakha khona. ");
INSERT INTO nde_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","U-Isaka wayiphanda imithombo eyayigejwe ngesikhathi sikayise u-Abhrahama, eyayigqitshelwe ngamaFilistiya ngemva kokuba u-Abhrahama esefile, wayibiza ngalawo mabizo uyise ayeyibiza ngawo. ");
INSERT INTO nde_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Izisebenzi zika-Isaka zagebha esigodini zafumana umthombo olamanzi amahle khonapho. ");
INSERT INTO nde_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Kodwa abelusi baseGerari baxabana labelusi baka-Isaka bathi, “Amanzi la ngawethu!” Ngakho umthombo lowo wawuthi yi-Eseki, ngoba bawubanga laye. ");
INSERT INTO nde_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ngakho basebesimba omunye umthombo, kodwa lawo bawubanga njalo; wasewubiza ngokuthi yiSithina. ");
INSERT INTO nde_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Wasuka lapho wayagebha omunye umthombo, akwabe kusaba khona owubangayo. Wawuthi yiRehobhothi, esithi, “Manje uThixo usesiphile indawo, sesizaphumelela kuleli ilizwe.” ");
INSERT INTO nde_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Esuka lapho waya eBherishebha. ");
INSERT INTO nde_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ngalobobusuku uThixo wabonakala kuye wathi, “NginguNkulunkulu kayihlo u-Abhrahama. Ungesabi, ngoba ngilawe; ngizakubusisa ngandise ubunengi bezizukulwane zakho ngenxa yenceku yami u-Abhrahama.” ");
INSERT INTO nde_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","U-Isaka wakha i-Alithari khonapho wamemeza ibizo likaThixo. Wamisa ithente lakhe khonapho, izisebenzi zakhe zemba umthombo khonapho. ");
INSERT INTO nde_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ngalesosikhathi u-Abhimelekhi weza kuye evela eGerari, elo-Ahuzathi umeluleki wakhe loFikholi umlawuli wamabutho akhe. ");
INSERT INTO nde_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","U-Isaka wababuza wathi, “Lilandeni kimi, njengoba lalingizonda laze langixotsha?” ");
INSERT INTO nde_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Bamphendula bathi, “Sabona kamhlophe ukuthi uThixo wayelawe; yikho sasesicabanga ukuthi kumele kube lesivumelwano esibotshiweyo phakathi kwethu lawe. Kasenze isibopho lawe ");
INSERT INTO nde_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","esokuthi kawusoze usihlukuluze, njengoba lathi singazange sikulimaze ngalutho kodwa sakuvalelisa ngokuthula. Khathesi usubusisiwe nguThixo.” ");
INSERT INTO nde_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","U-Isaka wasebenzela idili, badla banatha. ");
INSERT INTO nde_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ekuseni kakhulu ngelanga elilandelayo amadoda wonke enza isifungo omunye komunye. U-Isaka wasebavulela indlela bahamba ngokuthula. ");
INSERT INTO nde_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ngalolosuku izisebenzi zika-Isaka zabuya zamtshela ngomthombo ezaziwugebhile. Zathi, “Sesiwatholile amanzi!” ");
INSERT INTO nde_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Wawuthi yiShibha, osekuze kube namuhla idolobho kuthiwa yiBherishebha. ");
INSERT INTO nde_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Kwathi u-Esawu eseleminyaka yobudala engamatshumi amane, wathatha uJudithi indodakazi kaBheri umHithi njalo loBhasemathi indodakazi ka-Eloni umHithi. ");
INSERT INTO nde_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Baletha ukukhathazeka kakhulu ku-Isaka loRabheka. ");
INSERT INTO nde_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Kwathi u-Isaka eseluphele, amehlo akhe esethundubele okokuthi wayengasaboni, wabiza u-Esawu indodana yakhe endala wathi kuye, “Ndodana yami.” Waphendula wathi, “Ngilapha.” ");
INSERT INTO nde_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","U-Isaka wathi, “Manje sengilixhegu, njalo kangilazi ilanga lami lokufa. ");
INSERT INTO nde_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Thatha izikhali zakho, isikhwama semitshoko yakho ledandili lakho ungene iganga uyengizingelela inyamazana. ");
INSERT INTO nde_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ungilungisele ukudla okumnandi engikuthandayo ukulethe kimi lapha ngidle, ukuze ngikuphe isibusiso sami ngingakafi.” ");
INSERT INTO nde_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","URabheka wayelalele u-Isaka ekhuluma lendodana yakhe u-Esawu. Kwathi u-Esawu esephumile waya egangeni ukuyazingela inyamazana ukuze ayilethe, ");
INSERT INTO nde_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","uRabheka wathi endodaneni yakhe uJakhobe, “Khangela, ngizwe uyihlo esithi kumnewenu u-Esawu ");
INSERT INTO nde_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Ngilethela inyamazana ungilungisele ukudla okumnandi ngidle, ukuze ngikuphe isibusiso sami phambi kukaThixo ngingakafi.’ ");
INSERT INTO nde_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Manje-ke lalela kuhle, ndodana yami, wenze lokho engikutshela khona: ");
INSERT INTO nde_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Yana emhlambini ulethe lapha kimi amazinyane embuzi amabili anonileyo, ukuze ngilungisele uyihlo ukudla okumnandi ngendlela akuthanda ngayo. ");
INSERT INTO nde_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Wena ubusukusa kuyihlo adle, abesekunika isibusiso sakhe engakafi.” ");
INSERT INTO nde_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","UJakhobe wathi kuRabheka unina, “Kodwa umnewethu u-Esawu lihwanqa, mina ngilejwabu elitshelelayo. ");
INSERT INTO nde_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Pho ubaba angangibamba ke? Kuzabonakala ukuthi ngiyamqila ngibe sengizehlisele isiqalekiso phezu kwami esikhundleni sesibusiso.” ");
INSERT INTO nde_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Unina wathi kuye, “Ndodana yami, lesosiqalekiso kasehlele kimi. Wena yenza lokho engikutshela khona kuphela; hamba uyengithathela wona.” ");
INSERT INTO nde_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ngakho wahamba wayawathatha wawaletha kunina, yena walungisa ukudla okumnandi, ngaleyondlela eyayithandwa nguyise. ");
INSERT INTO nde_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","URabheka wasethatha izigqoko ezithandekayo zika-Esawu indodana yakhe endala, ezazikhona endlini, wazigqokisa indodana yakhe encane, uJakhobe. ");
INSERT INTO nde_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Wabuya wamgoqela izandla zakhe lentamo lapho okwakubutshelezi khona ngesikhumba sembuzi. ");
INSERT INTO nde_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Waseqhubela indodana yakhe uJakhobe ukudla lokho okumnandi kanye lesinkwa ayesenzile. ");
INSERT INTO nde_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Waya kuyise wafika wathi, “Baba.” Wasabela wathi, “Yebo, ndodana yami. Ngubani?” ");
INSERT INTO nde_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","UJakhobe wathi kuyise, “Ngingu-Esawu izibulo lakho. Sengenzile njengokungilayela kwakho. Vuka uhlale udle inyama yami yenyamazana ukuze ungiphe isibusiso sakho.” ");
INSERT INTO nde_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","U-Isaka wayibuza indodana yakhe wathi, “Uyizuze njani masinyane kangaka, ndodana yami?” Waphendula wathi, “uThixo uNkulunkulu wakho ungiphumelelisile.” ");
INSERT INTO nde_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","U-Isaka wasesithi kuJakhobe, “Sondela eduze ngikuthinte, ndodana yami, ukuze ngazi ngempela ukuthi uyiyo indodana yami u-Esawu noma hatshi.” ");
INSERT INTO nde_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","UJakhobe wasondela kuyise u-Isaka wamthinta wathi, “Ilizwi ngelikaJakhobe, kodwa izandla yizandla zika-Esawu.” ");
INSERT INTO nde_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Kazange amazi ngoba izandla zakhe zaziloboya njengezikamnewabo u-Esawu; ngakho wambusisa. ");
INSERT INTO nde_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Wabuza wathi, “Kambe unguye na u-Esawu indodana yami?” Waphendula wathi, “Nginguye.” ");
INSERT INTO nde_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Wasesithi, “Ndodana yami, ngipha inyama yakho yenyamazana ngidle, ukuze ngikuphe isibusiso sami.” UJakhobe wamupha wadla; waletha lewayini wanatha. ");
INSERT INTO nde_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Uyise u-Isaka wathi kuye, “Woza lapha, ndodana yami, ungange.” ");
INSERT INTO nde_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Wasesiya kuye wamanga. Kwathi u-Isaka esewuzwile umnuko wezigqoko zakhe, wambusisa wathi, “Yeka, umnuko wendodana yami unjengomnuko wensimu uThixo ayibusisileyo. ");
INSERT INTO nde_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Sengathi uNkulunkulu angakupha amazolo asezulwini lokuvunda komhlabathi, inala yamabele lewayini elitsha. ");
INSERT INTO nde_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Sengathi izizwe zingakukhonza labantu bakukhothamele. Ube yinkosi phezu kwabafowenu, njalo sengathi amadodana kanyoko angakukhothamela. Sengathi labo abakuqalekisayo labo baqalekiswe labakubusisayo babusiswe.” ");
INSERT INTO nde_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","U-Isaka eseqedile ukumbusisa njalo uJakhobe esathi uyasuka kuyise, umnewabo u-Esawu wabengena evela zingela. ");
INSERT INTO nde_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Laye njalo walungisa ukudla okumnandi wakuletha kuyise. Wasesithi kuye, “Baba, vuka udle inyama yami yenyamazana, ukuze ungiphe isibusiso sakho.” ");
INSERT INTO nde_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Uyise u-Isaka wambuza wathi, “Ungubani wena?” Waphendula wathi, “Ngiyindodana yakho, izibulo lakho u-Esawu.” ");
INSERT INTO nde_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","U-Isaka wathuthumela kakhulu wathi, “Kanti ubengubani ozingele inyamazana wayiletha kimi? Ngiyidlile khathesi nje usuzafika, ngambusisa njalo ngempela uzakubusiswa!” ");
INSERT INTO nde_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Kwathi u-Esawu ewezwa amazwi kayise, wakhala kakhulu okuzwisa ubuhlungu wathi kuyise, “Ngibusisa lami njalo, baba!” ");
INSERT INTO nde_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Kodwa wathi, “Umfowenu uze ngobuqili wathatha isibusiso sakho.” ");
INSERT INTO nde_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","U-Esawu wathi, “Kakumfanelanga na ukuthiwa nguJakhobe? Lokhu sokungokwesibili engiqila: Wathatha ubuzibulo bami, manje usethethe isibusiso sami?” Wasebuza wathi, “Kawungigcinelanga yini mina esinye isibusiso”? ");
INSERT INTO nde_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","U-Isaka wamphendula u-Esawu wathi, “Sengimenze waba yinkosi phezu kwakho, ngenza zonke izihlobo zakhe zaba yizisebenzi zakhe, njalo ngamsekela ngenala yamabele langewayini elitsha. Kambe ngingabe ngisakwenzelani, ndodana yami?” ");
INSERT INTO nde_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","U-Esawu wathi kuyise, “Kanti ulesibusiso esisodwa kuphela na baba? Ngibusisa lami, baba!” U-Esawu wasekhala kakhulu ephumisela. ");
INSERT INTO nde_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Uyise u-Isaka wamphendula wathi, “Umuzi wakho uzakuba khatshana lokuvunda komhlaba, khatshana lamazolo asezulwini eliphezulu. ");
INSERT INTO nde_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Uzaphila ngokusebenzisa inkemba njalo uzamkhonza umfowenu. Kodwa kuzakuthi lapho usudlubulunda, uzalilahla ijogwe lakhe lisuke entanyeni yakho.” ");
INSERT INTO nde_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","U-Esawu wabambela uJakhobe isikhwili ngenxa yesibusiso uyise ayemuphe sona. Wazitshela wathi, “Insuku zokulilela ubaba seziseduze; lapho-ke ngizambulala umfowethu uJakhobe.” ");
INSERT INTO nde_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Kwathi uRabheka esezwile okwakutshiwo yindodana yakhe endala u-Esawu, wabiza indodana yakhe encinyane uJakhobe wathi kuye, “Umnewenu u-Esawu uziduduza ngomcabango wokuthi akubulale. ");
INSERT INTO nde_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ngakho-ke wena ndodana yami, yenza lokho engikutshela khona: Baleka masinyane uye kumfowethu uLabhani eHarani. ");
INSERT INTO nde_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Uhlale khonale ulaka lomfowenu luze ludede. ");
INSERT INTO nde_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Kuzakuthi nxa umnewenu engasakuzondelanga esekhohliwe ukuthi kuyini owakwenza kuye, ngizathumela ilizwi ukuthi ubuye usuka khonale. Kambe kungaba yini ukuthi ngilahlekelwe yini lobabili ngasuku lunye na?” ");
INSERT INTO nde_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","URabheka wasesithi ku-Isaka, “Ukuphila sokunginenga ngenxa yabafazi bamaHithi laba. Nxa uJakhobe engathatha umfazi ebafazini balelilizwe, abafazi bamaHithi abanje, ukuphila kwami kuyabe kungasasizi.” ");
INSERT INTO nde_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ngakho u-Isaka wabiza uJakhobe wambusisa wamlaya wathi: “Ungathathi umfazi womKhenani. ");
INSERT INTO nde_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Hamba khathesi uye ePhadani Aramu, emzini kayihlomkhulu uBhethuweli. Thatha khona umfazi, emadodakazini kaLabhani, umnewabo kanyoko. ");
INSERT INTO nde_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Sengathi uNkulunkulu uSomandla angakubusisa akuphe inzalo, andise ubunengi bayo lize libe yizizwe ezinengi. ");
INSERT INTO nde_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Sengathi angakupha wena kanye lezizukulwane zakho isibusiso leso esaphiwa u-Abhrahama, ukuze lilithathe ilizwe leli ohlezi kulo manje njengowezizweni, ilizwe uNkulunkulu alipha u-Abhrahama.” ");
INSERT INTO nde_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ngakho u-Isaka wasemvalelisa uJakhobe, waya ePhadani Aramu, kuLabhani indodana kaBhethuweli umʼAramu, umnewabo kaRabheka, owayengunina kaJakhobe lo-Esawu. ");
INSERT INTO nde_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","U-Esawu wezwa ukuthi u-Isaka wayembusisile uJakhobe njalo wamthumela ePhadani Aramu ukuthi ayothatha umfazi khona, lokuthi wathi embusisa wamlaya wathi, “Ungathathi umfazi ongumKhenani,” ");
INSERT INTO nde_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","lokuthi uJakhobe wayebalalele uyise lonina wahamba waya ePhadani Aramu. ");
INSERT INTO nde_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","U-Esawu wakunanzelela ukuthi abafazi bamaKhenani babeyisinengiso kuyise u-Isaka; ");
INSERT INTO nde_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ngakho wasesiya ku-Ishumayeli wathatha uMahalathi, udadewabo kaNebhayothi, indodakazi ka-Ishumayeli indodana ka-Abhrahama, phezu kwabanye abafazi ayevele eselabo. ");
INSERT INTO nde_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","UJakhobe wasuka eBherishebha waqonda eHarani. ");
INSERT INTO nde_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Wafika kwenye indawo, wema lapho ukuthi alale khona ngoba ilanga laselitshonile. Wathatha ilitshe khona walenza umqamelo walala. ");
INSERT INTO nde_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Wehlelwa liphupho wabona ilele ligxile phansi emhlabeni, isiqongo salo sifinyelela ezulwini, kwathi izingilosi zikaNkulunkulu zabe ziqansa zisehla kulo. ");
INSERT INTO nde_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Laphaya ngaphezu kwalo kwakumi uThixo esithi: “nginguThixo, uNkulunkulu kayihlo u-Abhrahama loNkulunkulu ka-Isaka. Ngizakupha wena kanye lezizukulwane zakho ilizwe leli olele kulo. ");
INSERT INTO nde_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Izizukulwane zakho zizakuba njengothuli lomhlabathi, njalo lizaqhela liye entshonalanga lasempumalanga, enyakatho laseningizimu. Bonke abantu bomhlaba bazabusiswa ngenxa yakho lenzalo yakho. ");
INSERT INTO nde_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ngilawe njalo ngizakulinda loba ungaze uye ngaphi, njalo ngizakubuyisa kulelilizwe. Kangizukukudela ngize ngikwenze lokho engikuthembise khona.” ");
INSERT INTO nde_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","UJakhobe wathi evuka ebuthongweni bakhe wacabanga wathi, “Ngeqiniso uThixo ukhona kule indawo, kodwa bengingakunanzeleli.” ");
INSERT INTO nde_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Wesaba wathi, “Yeka ukwesabeka kwale indawo ehloniphekayo! Ngempela iyindlu kaNkulunkulu; leli lisango lasezulwini.” ");
INSERT INTO nde_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Kusisa ekuseni kakhulu uJakhobe walithatha ilitshe ayelele eliqamele walimisa laba yinsika wathela amafutha phezu kwalo. ");
INSERT INTO nde_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Indawo leyo wayibiza wathi yiBhetheli, ikanti idolobho lakhona lalithiwa yiLuzi. ");
INSERT INTO nde_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ngakho uJakhobe wenza isifungo wathi, “Nxa uNkulunkulu ezakuba lami angilondoloze kuloluhambo engikulo, angiphe ukudla lezigqoko, ");
INSERT INTO nde_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ngibuyele emzini kababa ngiphilile, lapho uThixo uzakuba nguNkulunkulu wami ");
INSERT INTO nde_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","njalo lelitshe leli engilenze insika lizakuba yindlu kaNkulunkulu, njalo kuzakuthi konke onginika khona ngizakunika wena okwetshumi.” ");
INSERT INTO nde_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","UJakhobe waseqhubeka ngohambo lwakhe wayafika elizweni labantu bempumalanga. ");
INSERT INTO nde_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Wabona khonale umthombo esiqintini, kulemihlambi yezimvu emithathu ilele eduzane kwawo ngoba imihlambi yayinatha khonapho emthonjeni lowo. Ilitshe elalivale umlomo womthombo lalilikhulu. ");
INSERT INTO nde_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Kwakusithi yonke imihlambi ingabuthana khona, abelusi baligiqe ilitshe balisuse emlonyeni womthombo banathise izimvu. Besebelibuyisela ilitshe endaweni yalo emlonyeni womthombo. ");
INSERT INTO nde_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","UJakhobe wabuza abelusi wathi, “Bafowethu, livela ngaphi?” Baphendula bathi, “Sivela eHarani.” ");
INSERT INTO nde_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Wathi, “Liyamazi yini uLabhani, umzukulu kaNahori?” Baphendula bathi, “Yebo, siyamazi.” ");
INSERT INTO nde_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","UJakhobe wasebabuza wathi, “Uyaphila yini?” Bathi, “Yebo, uyaphila; nansi indodakazi yakhe uRasheli esiza lezimvu.” ");
INSERT INTO nde_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Wathi, “Khangelani, ilanga lilokhu lisemini; akukabi yisikhathi sokuthi imihlambi ibuthwe. Zinathiseni izimvu lezi lizibuyisele emadlelweni.” ");
INSERT INTO nde_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Baphendula bathi, “Asingeke, ize iqale iqoqane yonke imihlambi, ilitshe beselisuswa emlonyeni womthombo. Besesizinathisa-ke izimvu.” ");
INSERT INTO nde_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Wathi elokhu esakhuluma labo uRasheli wafika lezimvu zikayise, kalokho wayengumelusi. ");
INSERT INTO nde_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","UJakhobe wathi ebona uRasheli indodakazi kaLabhani, umnewabo kanina esiza lezimvu zikaLabhani, wahamba wayagiqa ilitshe elalisemlonyeni womthombo wanathisa izimvu zikamalumakhe. ");
INSERT INTO nde_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","UJakhobe wasesanga uRasheli njalo wakhala kakhulu. ");
INSERT INTO nde_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Wayesemtshelile uRasheli ukuthi wayeyisihlobo sikayise lokuthi wayeyindodana kaRabheka. Ngakho intombi yagijima yayabikela uyise. ");
INSERT INTO nde_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","ULabhani wonela ukuwuzwa umbiko ngoJakhobe, indodana kadadewabo, wahle waphuthuma wayamhlangabeza. Wamgona, wamanga, wamletha ngekhaya, lapho uJakhobe amtshela khona izinto lezi. ");
INSERT INTO nde_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","ULabhani wasesithi kuye, “Uyinyama yami legazi lami.” UJakhobe esehlale laye okwenyanga yonke, ");
INSERT INTO nde_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","uLabhani wathi kuye, “Kambe sekungathi ngoba uyisihlobo sami ubusungisebenzela ungaholi lutho? Akungitshele ukuthi umholo wakho ungaba yini?” ");
INSERT INTO nde_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","ULabhani wayelamadodakazi amabili; ibizo lendala lalinguLeya, encinyane inguRasheli. ");
INSERT INTO nde_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","ULeya wayelamehlo abuthakathaka, kodwa uRasheli wayelesimo esibukekayo, emuhle. ");
INSERT INTO nde_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","UJakhobe wezwa emthanda uRasheli wasesithi, “Ngizakusebenzela okweminyaka eyisikhombisa ukuze ungiphe indodakazi yakho encane uRasheli.” ");
INSERT INTO nde_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","ULabhani wathi, “Kungcono ngimuphe wena kulokuba ngimuphe enye indoda. Hlala lapha lami.” ");
INSERT INTO nde_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","UJakhobe waseyisebenza iminyaka eyisikhombisa ukuze azuze uRasheli, kodwa yakhanya ingathi yizinsukwana ezimbalwa kuye ngenxa yothando kuye. ");
INSERT INTO nde_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","UJakhobe wasesithi kuLabhani, “Ngipha-ke umkami. Isikhathi sami sesigcwalisekile, sengifuna ukwembatha laye.” ");
INSERT INTO nde_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ngakho uLabhani wasenxusa bonke abantu bendawo wenza idili. ");
INSERT INTO nde_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Kodwa kwathi sekusihlwa, wathatha indodakazi yakhe uLeya wamupha uJakhobe, uJakhobe wembatha laye. ");
INSERT INTO nde_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","ULabhani waphinda wapha uLeya incekukazi yakhe uZilipha ukuba ibe yincekukazi yakhe. ");
INSERT INTO nde_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Kwathi sokusile, wabona kunguLeya! UJakhobe wathi kuLabhani, “Kuyini lokhu okwenzileyo kimi? Mina ngasebenzela uRasheli, kakunjalo na? Kungani ungikhohlisile?” ");
INSERT INTO nde_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","ULabhani waphendula wathi, “Kakusiwo mkhuba wethu lapha ukwendisa indodakazi encane endala ingakendi. ");
INSERT INTO nde_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Qeda iviki yokucola lo omdala; besesikupha lalo omncane njalo ngemva kokumsebenzela eminye iminyaka eyisikhombisa.” ");
INSERT INTO nde_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","UJakhobe wenza njalo. Waqeda iviki eloLeya, uLabhani wasemupha indodakazi yakhe uRasheli ukuba ibe ngumkakhe. ");
INSERT INTO nde_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","ULabhani wanika indodakazi yakhe uRasheli incekukazi yakhe uBhiliha ukuba abe yincekukazi yakhe. ");
INSERT INTO nde_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","UJakhobe waselala loRasheli, wamthanda ukwedlula uLeya. Wasesebenzela uLabhani okweminye iminyaka eyisikhombisa njalo. ");
INSERT INTO nde_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","UThixo wathi ngokubona ukuthi uLeya wayengathandwa, wavula inzalo yakhe, kodwa uRasheli wayeyinyumba. ");
INSERT INTO nde_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","ULeya wathatha isisu wazala indodana. Wamutha ibizo wathi nguRubheni, ngoba wathi, “Kungenxa yokuthi uThixo usebonile ukuhlupheka kwami. Ngempela umkami usezangithanda manje.” ");
INSERT INTO nde_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Wathatha isisu njalo, wathi esephinde umfana njalo wathi, “Ngoba uThixo wezwa ukuthi kangithandwa, wanginika lo njalo.” Ngakho wamutha wathi nguSimiyoni. ");
INSERT INTO nde_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Wasithatha njalo isisu, kwathi esezele omunye umfana wathi, “Khathesi-ke umkami usezabambelela kimi ngoba sengimzalele amadodana amathathu.” Yikho wathiwa nguLevi. ");
INSERT INTO nde_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Waphinda wasithatha isisu, wazuza umfana wathi, “Ngalesisikhathi ngizadumisa uThixo.” Wamutha wathi nguJuda. Wasesima ukuzuza abantwana. ");
INSERT INTO nde_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","URasheli wathi ebona ukuthi wayengazaleli uJakhobe abantwana, wasekhwelezela udadewabo. Wasesithi kuJakhobe, “Ngipha abantwana, kumbe ngife!” ");
INSERT INTO nde_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","UJakhobe wamzondela wathi, “Sengisesikhundleni sikaNkulunkulu yini mina, onguye okuvale ukuthi ungazali?” ");
INSERT INTO nde_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Yena wasesithi, “Nangu uBhiliha incekukazi yami. Lala laye ukuze angizalele abantwana, ukuze kuthi ngaye ngibe lemuli.” ");
INSERT INTO nde_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ngakho wasemupha incekukazi yakhe uBhiliha njengomfazi. UJakhobe wembatha laye, ");
INSERT INTO nde_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","wazithwala wamzalela indodana. ");
INSERT INTO nde_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ngakho uRasheli wathi, “UNkulunkulu usengigezile; ulalele ukuncenga kwami wasenginika indodana.” Ngenxa yalokhu wayitha wathi nguDani. ");
INSERT INTO nde_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Incekukazi kaRasheli, uBhiliha, yathatha isisu njalo yazalela uJakhobe indodana yesibili. ");
INSERT INTO nde_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","URasheli wasesithi, “Kade kuyimpi phakathi kwami lodadewethu, mina senginqobile.” Wasemuthi nguNafithali. ");
INSERT INTO nde_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","ULeya wathi ngokubona ukuthi kasazali wathatha incekukazi yakhe uZilipha wayipha uJakhobe njengomfazi. ");
INSERT INTO nde_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Incekukazi kaLeya uZilipha yazalela uJakhobe indodana. ");
INSERT INTO nde_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","ULeya wasesithi, “Inhlanhla engakanani!” Wamutha ibizo wathi nguGadi. ");
INSERT INTO nde_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Incekukazi kaLeya uZilipha yazalela uJakhobe indodana yesibili. ");
INSERT INTO nde_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","ULeya wathi, “Uthi ngiyathaba yini! Abafazi bazakuthi ngiyathaba.” Yikho wambiza ngokuthi ngu-Asheri. ");
INSERT INTO nde_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ngesikhathi sokuvuna ingqoloyi uRubheni waya emasimini wafumana izihlahlakazana zamamandraki waziletha kunina uLeya. URasheli wathi kuLeya, “Ngicela ezinye zezihlahlakazana zendodana yakho.” ");
INSERT INTO nde_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Kodwa wathi kuye, “Kakukwanelisanga na ukuthi wangemuka indoda? Usufuna ukuthatha lamamandraki endodana yami njalo?” URasheli wathi, “Kulungile, angazalala ngakwakho lamuhla ukuze ngizuze amamandraki endodana yakho.” ");
INSERT INTO nde_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ngakho kwathi uJakhobe efika evela emasimini ngaleyontambama, uLeya wamhlangabeza wathi, “Kumele ulale ngakwami lamuhla. Ngikuqhatshile ngamamandraki endodana yami.” Ngakho wembatha laye ngalobobusuku. ");
INSERT INTO nde_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","UNkulunkulu wamlalela uLeya, wathatha isisu wazalela uJakhobe indodana yesihlanu. ");
INSERT INTO nde_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","ULeya wathi, “UNkulunkulu usengiphe umvuzo ngenxa yokuthi nganika indoda yami incekukazi yami.” Ngakho wamutha wathi ngu-Isakhari. ");
INSERT INTO nde_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","ULeya waphinda wasithatha njalo isisu wazalela uJakhobe indodana yesithupha. ");
INSERT INTO nde_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ngakho uLeya wathi, “UNkulunkulu usengiphe isipho esiligugu. Khathesi umkami usezangiphatha ngenhlonipho, ngoba sengimzalele amadodana ayisithupha.” Wasemutha wathi nguZebhuluni. ");
INSERT INTO nde_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Emva kwesikhathi esithile wazala intombazana wayithi nguDina. ");
INSERT INTO nde_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","UNkulunkulu wamkhumbula uRasheli; wezwa ukukhala kwakhe wavula isibeletho sakhe. ");
INSERT INTO nde_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Wathatha isisu wazala indodana, wathi, “UNkulunkulu uselisusile ihlazo lami.” ");
INSERT INTO nde_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Wamutha wathi nguJosefa, wathi, “Sengathi uThixo angangipha enye indodana.” ");
INSERT INTO nde_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","URasheli esezele uJosefa uJakhobe wathi kuLabhani, “Ngivumela ukuthi ngibuyele elizweni lakithi. ");
INSERT INTO nde_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ngipha omkami labantwana engibasebenzeleyo kuwe, ngihle ngihambe. Uyawazi umsebenzi engiwusebenzileyo kuwe lapha.” ");
INSERT INTO nde_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Kodwa uLabhani wathi kuye, “Nxa ungithanda, hlala. Sengibonile ngokwambulelwa ukuthi uThixo ungibusisile ngenxa yakho.” ");
INSERT INTO nde_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Wengeza ngokuthi, “Qamba loba yiphi inhlawulo oyifunayo, ngizakupha.” ");
INSERT INTO nde_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","UJakhobe wathi kuye, “Uyakwazi ukuthi ngikusebenzele njani lokuthi izifuyo zakho zigcinakale njani ziphethwe yimi. ");
INSERT INTO nde_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Okuncinyane owawulakho ngingakafiki sekusele kwanda kakhulu, njalo uThixo ukubusisile langabe kungaphi lapho engike ngaba khona. Kodwa manje ngizaze ngiwenzele nini mina umuzi wami ulutho?” ");
INSERT INTO nde_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Wabuza wathi, “Ngikupheni na?” Waphendula uJakhobe wathi, “Ungangiphi lutho. Kodwa ake ungenzele lokhu kodwa, ukuze ngiqhubeke ngisondla imihlambi yakho: ");
INSERT INTO nde_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Wothi ngingene emihlambini yakho lamuhla ngikhuphe kuyo zonke izimvu ezilamachatha kumbe amabala, lamazinyane wonke amnyama lembuzi zonke ezilamabala kumbe amachatha. Yizo ezizakuba yinhlawulo yami. ");
INSERT INTO nde_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ngesikhathi esizayo ubuqotho bami buzavela nxa uhlola inhlawulo onginike yona. Ingqe yiphi imbuzi engizabe ngilayo engelamachatha kumbe amabala, loba lizinyane lemvu elingamnyama lizakubalwa njengelebiweyo.” ");
INSERT INTO nde_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","ULabhani wathi, “Kulungile, kakube njengokutsho kwakho.” ");
INSERT INTO nde_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Mhlalokho wazikhupha zonke impongo ezazingamaqamule kumbe ezilamabala, njalo lezinsikazi ezilamachatha kumbe ezilamabala (zonke ezazilokumhlophe kuzo) lamazinyane ezimvu wonke amnyama zonke wathi zikhangelwe ngamadodana akhe. ");
INSERT INTO nde_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Wasebeka umango wensuku ezintathu phakathi kwakhe loJakhobe, kodwa uJakhobe wayelokhu esondla yonke imihlambi eseleyo kaLabhani. ");
INSERT INTO nde_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Kwathi uJakhobe wagamula ingatsha zesihlahla sephopla, eze-alimondi lezepulane wahamba ezixoza amaxolo wenza imidwa kwavela kuzo isigodo esimhlophe. ");
INSERT INTO nde_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ingatsha lezi ezixoziweyo wazibeka kuyo yonke imikolo yokunathela imihlambi ukuthi zime ziqondane lezifuyo nxa zinatha. Kwakusithi lezozifuyo ezidabuleyo zizonatha ");
INSERT INTO nde_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","zifike zixakane phambi kwezingatsha. Zazizala amazinyane alamabala ayimidwa loba alamachatha kumbe amabala nje. ");
INSERT INTO nde_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","UJakhobe wawakhetha wawabeka wodwa amazinyane, kodwa lezo ezinye waziyekela zadunga lezo ezingamaqamule lezimnyama ezazingezikaLabhani. Ngaleyondlela, wenza imihlambi ehlukeneyo eyakhe kaze ayihlanganisa lekaLabhani. ");
INSERT INTO nde_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Kwakusithi kungadabula ezinsikazi eziqinileyo, uJakhobe wayefaka imiqwayi emikolweni phambi kwezifuyo ukuze zixakane eduze kwayo, ");
INSERT INTO nde_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","kodwa nxa ezinsikazi zingezibuthakathaka wayengayifaki imiqwayi. Ngakho izifuyo ezibuthakathaka zaba ngezikaLabhani, eziqinileyo zabuya ngoJakhobe. ");
INSERT INTO nde_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ngale indlela indoda le yanotha kakhulu yaba lemihlambi emikhulu, lezincekukazi, lezinceku kanye lamakamela labobabhemi. ");
INSERT INTO nde_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","UJakhobe wezwa ukuthi amadodana kaLabhani ayesithi, “UJakhobe usethethe konke ubaba ayelakho njalo usezuze yonke inotho ebingekababa.” ");
INSERT INTO nde_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Njalo uJakhobe wananzelela ukuthi uLabhani wayengasamphathi njengakuqala. ");
INSERT INTO nde_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","UThixo wasesithi kuJakhobe, “Buyela elizweni laboyihlo lasezihlotsheni zakho, mina ngizakuba lawe.” ");
INSERT INTO nde_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ngakho uJakhobe wasethumela ilizwi kuRasheli loLeya ukuthi beze egangeni lapho imihlambi yakhe eyayikhona. ");
INSERT INTO nde_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Wathi kubo, “Sengibona ukuthi uyihlo kasangiphathi njengakuqala, kodwa uNkulunkulu kababa ube lami. ");
INSERT INTO nde_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Liyakwazi ukuthi ngamsebenzela uyihlo ngamandla ami wonke, ");
INSERT INTO nde_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","kodwa uyihlo ungidlelezele ngokuguqula umholo wami okwezikhathi ezilitshumi. Kodwa uNkulunkulu kamvumelanga ukuthi angilimaze. ");
INSERT INTO nde_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Kwakusithi angathi, ‘Ezilamabalabala ngezakho, ezomholo,’ imihlambi yonke izale ezimabalabala; kuthi angathi, ‘Ezingamaqamule zizakuba ngumholo wakho,’ yonke imihlambi izale amazinyane angamaqamule. ");
INSERT INTO nde_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ngaleyondlela uNkulunkulu usethethe imihlambi kayihlo wayipha mina. ");
INSERT INTO nde_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ngesikhathi sokuxotshwa lokumitha kwemihlambi, ngaba lephupho lapho okwathi ngikhangela ngabona ukuthi impongo ezazixotsha umhlambi zazingamaqamule, kumbe zingamafahlafahla kumbe zilamabala. ");
INSERT INTO nde_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ingilosi kaNkulunkulu yathi kimi kulelophupho, ‘Jakhobe.’ Ngasabela ngathi, ‘Ngilapha.’ ");
INSERT INTO nde_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Yathi, ‘Khangela ukuthi zonke impongo ezixotsha umhlambi ngezingamaqamule, ngezingamafahlafahla kumbe ngezilamabala, ngoba ngikubonile konke lokho uLabhani abekwenza kuwe. ");
INSERT INTO nde_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","NginguNkulunkulu waseBhetheli, lapho owagcoba khona insika njalo lapho owenza khona isifungo kimi. Suka kulelilizwe khona manje ubuyele elizweni lakini.’ ” ");
INSERT INTO nde_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","URasheli loLeya baphendula bathi, “Sivele siseselesabelo selifa likababa na? ");
INSERT INTO nde_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Kasinjengabezizweni kuye na? Kakusikho kodwa ukuthi walobolisa ngathi, kodwa sowakusebenzisa konke esalotsholwa ngakho. ");
INSERT INTO nde_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ngempela yonke inotho uNkulunkulu ayemuka ubaba ngeyethu labantwabethu. Ngakho yenza loba yini uNkulunkulu akutshele yona.” ");
INSERT INTO nde_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","UJakhobe wasegadisa abantwabakhe labomkakhe emakameleni, ");
INSERT INTO nde_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","waziqhuba zonke izifuyo zakhe zahamba phambili, kanye lempahla zonke ayezizuzile ePhadani Aramu, esebuyela kuyise u-Isaka elizweni laseKhenani. ");
INSERT INTO nde_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Kwathi uLabhani ehambile eyogunda izimvu zakhe, uRasheli weba izithombe zikayise. ");
INSERT INTO nde_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Phezu kwalokho uJakhobe wakhohlisa uLabhani umʼAramu ngokungamtsheli ukuthi yena wayesebaleka. ");
INSERT INTO nde_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ngakho wabaleka lakho konke okwakungokwakhe, wachapha umfula iYufrathe, waqonda elizweni lamaqaqa eleGiliyadi. ");
INSERT INTO nde_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ngosuku lwesithathu uLabhani watshelwa ukuthi uJakhobe wayesebalekile. ");
INSERT INTO nde_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Wathatha izihlobo zakhe bangena emzileni kaJakhobe okwensuku eziyisikhombisa baze bayambamba elizweni lamaqaqa eleGiliyadi. ");
INSERT INTO nde_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","UNkulunkulu weza kuLabhani umʼAramu ephutsheni ebusuku wathi kuye, “Unanzelele ukuthi ungaze watsho lutho kuJakhobe, loba lungoluhle kumbe olubi.” ");
INSERT INTO nde_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","UJakhobe wayemise ithente lakhe elizweni lamaqaqa eGiliyadi eficwa khona nguLabhani, uLabhani laye lezihlobo zakhe bakha izihonqo khonapho. ");
INSERT INTO nde_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ngakho uLabhani wasesithi kuJakhobe, “Wenzeni manje? Ungikhohlisile, njalo uthumbe amadodakazi ami njengabathunjiweyo empini. ");
INSERT INTO nde_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Kungani ubalekele ngasese wangikhohlisa na? Kungani ungangazisanga ukuze ngikuvalelise ngentokozo langokutshaya izigubhu lamachacho? ");
INSERT INTO nde_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Kawuzange ume ukuthi ngange abazukulu bami lamadodakazi ami ngibavalelise. Wenze into eyibuthutha. ");
INSERT INTO nde_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ngilamandla okukulimaza; kodwa ngobusuku obudluleyo uNkulunkulu kayihlo uthe kimi, ‘Unanzelele ungaze watsho lutho kuJakhobe, loba ngoluhle kumbe ngolubi.’ ");
INSERT INTO nde_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Manje ususukile ngoba ubulangazelela ukubuyela emzini kayihlo. Kodwa kungani webe izithombe zami na?” ");
INSERT INTO nde_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","UJakhobe wamphendula uLabhani wathi, “Bengisesaba ukuthi uzangemuka amadodakazi akho ngamandla. ");
INSERT INTO nde_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Kodwa nxa ufumana loba ngubani olezithombe zakho, kayikuphila. Ake ubone, lezihlobo zakho zikhona, ingabe kulolutho lwakho yini lapha kimi; nxa lukhona, luthathe.” UJakhobe wayengazi ukuthi uRasheli wayezebile izithombe. ");
INSERT INTO nde_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ngakho uLabhani wangena ethenteni likaJakhobe lethenteni likaLeya lethenteni lezincekukazi zombili, kodwa kafumananga lutho. Ephuma ethenteni likaLeya, wangena ethenteni likaRasheli. ");
INSERT INTO nde_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","URasheli wayethethe izithombe lezo, wazifihla phakathi kwesihlalo sekamela lakhe, wasehlala phezu kwazo. ULabhani wabhudula kukho konke okwakusethenteni, katholanga lutho. ");
INSERT INTO nde_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","URasheli wathi kuyise, “Ungazondi nkosi yami ukuthi kungani ngingakusukumeli, kungenxa yokuba ngisesikhathini.” Ngakho wabhudula, kodwa akaze azifumana izithombe zangekhaya. ");
INSERT INTO nde_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","UJakhobe wazonda kubi wamthwalisa nzima uLabhani. Wambuza wathi, “Icala lami ngelani? Ngenze sono bani ukuze ungizingele kanje? ");
INSERT INTO nde_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Njengoba usuziguduzile zonke impahla zami, kuyini osukufumene okungokomuzi wakho na? Kubeke khonapha phambi kwezihlobo zakho lezami batsho okuyikho phakathi kwethu sobabili. ");
INSERT INTO nde_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Sengibe lawe okweminyaka engamatshumi amabili. Izimvu zakho lembuzi zakho kazizange ziphunze, njalo kangizange ngizihlabele inqama emihlambini yakho. ");
INSERT INTO nde_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Kangizange ngizokutshengisa izifuyo ezidatshulwe yizilo; yimi engathwala lokho kulahlekelwa ngazihlawula. Njalo wafuna inhlawulo yalezo ezazebiwe emini loba ebusuku. ");
INSERT INTO nde_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Impilo yami yayinje: ukutshisa kwakungibhaxabula emini, ebusuku umqando ungihaqaze, ubuthongo babaleka emehlweni ami. ");
INSERT INTO nde_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Kwakunjalo okweminyaka engamatshumi amabili ngisemzini wakho. Ngakusebenzela okweminyaka elitshumi lane ngisebenzela amadodakazi akho womabili njalo okweminyaka eyisithupha ngisebenzela imihlambi yakho, njalo wena waguqula inhlawulo yami okwezikhathi ezilitshumi. ");
INSERT INTO nde_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Aluba uNkulunkulu kababa, uNkulunkulu ka-Abhrahama langokwesaba kuka-Isaka, ubengelami, ubuzangixotsha nje ngingaphathanga lutho. Kodwa uNkulunkulu ububonile ubunzima bami lokusebenza nzima kwezandla zami, yikho ekukhuzile izolo ebusuku.” ");
INSERT INTO nde_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","ULabhani wamphendula uJakhobe wathi, “Abesifazane ngamadodakazi ami, abantwana ngabantwabami, lemihlambi yimihlambi yami. Kodwa kuyini engingakwenza lamuhla ngala amadodakazi ami, kumbe ngabantwana ababazeleyo na? ");
INSERT INTO nde_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Zwana-ke, kasenze isivumelwano, wena lami, sibe ngufakazi phakathi kwethu.” ");
INSERT INTO nde_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ngakho uJakhobe wasethatha ilitshe walimisa laba yinsika. ");
INSERT INTO nde_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Wasesithi ezihlotsheni zakhe, “Buthelelani amatshe.” Bawathatha amatshe aba yinqwaba, basebedlela khonapho eceleni kwenqwaba. ");
INSERT INTO nde_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ULabhani wayibiza ngokuthi yiJegari Sahadutha, uJakhobe yena wathi yiGaledi. ");
INSERT INTO nde_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","ULabhani wathi, “Inqwaba le ingufakazi phakathi kwami lawe lamuhla.” Yikho yabizwa ngokuthi yiGaledi. ");
INSERT INTO nde_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Yabizwa njalo ngokuthi yiMizipha, ngoba wathi, “Sengathi uThixo angalinda phakathi kwakho lami nxa sikhatshana omunye komunye. ");
INSERT INTO nde_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ungaze uphathe kubi amadodakazi ami, loba ungaze uthathe abanye abafazi ngaphandle kwamadodakazi ami, loba kungekho omunye umuntu olathi, khumbula ukuthi uNkulunkulu ungufakazi phakathi kwakho lami.” ");
INSERT INTO nde_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","ULabhani wathi njalo kuJakhobe, “Nansi inqwaba le, njalo nansi insika engiyimise phakathi kwakho lami. ");
INSERT INTO nde_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Inqwaba le ingufakazi, kanye lensika le ingufakazi wokuthi kangisoze ngiyidlule inqwaba le ngize kwelakho icele ngizekonela lokuthi lawe kawuyikudlula kule inqwaba lensika uze kwelami icele uzengonela. ");
INSERT INTO nde_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Sengathi uNkulunkulu ka-Abhrahama, loNkulunkulu kaNahori, uNkulunkulu kayise wabo angahlulela phakathi kwethu.” Ngakho uJakhobe wenza isifungo ebizweni likaMesatshwa kayise u-Isaka. ");
INSERT INTO nde_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Wenza umhlatshelo khonapho elizweni lamaqaqa wanxusa izihlobo zakhe ekudleni. Sebedlile, balala khonapho. ");
INSERT INTO nde_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ekuseni kakhulu ngosuku olulandelayo uLabhani wanga abazukulu bakhe lamadodakazi akhe wababusisa. Wasefulathela wabuyela ekhaya. ");
INSERT INTO nde_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","UJakhobe laye wahamba ngeyakhe indlela, wasehlangabezwa yizingilosi zikaNkulunkulu. ");
INSERT INTO nde_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Wathi ezibona uJakhobe wathi, “Leli libandla likaNkulunkulu!” Indawo leyo waseyibiza ngokuthi yiMahanayimi. ");
INSERT INTO nde_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","UJakhobe wathuma izithunywa ukuba zihambe phambili kwakhe kumnewabo u-Esawu elizweni laseSeyiri, ilizwe lika-Edomi. ");
INSERT INTO nde_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Wazilaya wathi, “Nanku okumele likutsho enkosini yami u-Esawu, ‘Inceku yakho uJakhobe uthi bengihlezi loLabhani njalo ngihlale khona kwaze kwaba khathesi. ");
INSERT INTO nde_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ngilenkomo labobabhemi, ngilezimvu, lembuzi, njalo ngilezinceku lezincekukazi. Khathesi-ke sengithumela lelilizwi enkosini yami, ukuze ngithole umusa emehlweni akho.’ ” ");
INSERT INTO nde_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Kwathi izithunywa sezibuya kuJakhobe zathi, “Sihambile kumfowenu u-Esawu, okwamanje uyeza ukuzokuhlangabeza, ulamadoda angamakhulu amane eza lawo.” ");
INSERT INTO nde_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","UJakhobe wafikelwa yikwesaba lokukhathazeka okukhulu wasesehlukanisa phakathi abantu ayelabo baba ngamaqembu amabili, wenzenjalo lemihlambini yezimvu leyenkomo lamakamela lawo. ");
INSERT INTO nde_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Wakhumbula wathi, “Nxa u-Esawu angafika ahlasele elinye iqembu, leloqembu eliseleyo lingahle libaleke.” ");
INSERT INTO nde_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","UJakhobe wasekhuleka wathi, “Oh Nkulunkulu kababa u-Abhrahama, Nkulunkulu kababa u-Isaka, Thixo, wena owathi kimi, ‘Buyela elizweni lakini lasezihlotsheni zakho, ngizakwenza uphumelele,’ ");
INSERT INTO nde_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","mina kangiwufanelanga wonke umusa lokuthembeka okutshengise inceku yakho. Ngangiphethe intonga yami zwi mhla ngichapha iJodani leli, kodwa khathesi sengingamaqembu amabili. ");
INSERT INTO nde_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ngiyakhuleka ngithi ngisindise esandleni somfowethu u-Esawu, ngoba ngiyesaba ukuthi uzakuza angihlasele, kanye labesifazane labantwababo. ");
INSERT INTO nde_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Kodwa wena uthe, ‘Ngempela ngizakwenza uphumelele ngenze lezizukulwane zakho zibe njengetshebetshebe lolwandle elingeke labalwa.’ ” ");
INSERT INTO nde_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Wahlala khonapho ngalobobusuku, kwathi kulokho ayelakho wakhetha isipho sikamnewabo u-Esawu: ");
INSERT INTO nde_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","imbuzikazi ezingamakhulu amabili lempongo ezingamatshumi amabili; izimvu ezinsikazi ezingamakhulu amabili lenqama ezingamatshumi amabili; ");
INSERT INTO nde_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","amakamela amasikazi angamatshumi amathathu lamathole awo; amankomokazi angamatshumi amane lenkunzi ezilitshumi; kanye labobabhemi abasikazi abangamatshumi amabili lemiduna yawo elitshumi. ");
INSERT INTO nde_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Wakugcinisa izisebenzi zakhe konke, umhlambi munye wema wodwa, wathi kuzo izisebenzi zakhe, “Hambani phambi kwami, njalo litshiye ibanga phakathi kwemihlambi.” ");
INSERT INTO nde_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Lowo owayephambili wamlaya wathi, “Nxa umnewethu u-Esawu ekuhlangabeza afike abuze athi, ‘Ungokabani wena, njalo uya ngaphi, njalo ngezikabani zonke lezizifuyo eziphambi kwakho?’ ");
INSERT INTO nde_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ubokuthi, ‘Ngezenceku yakho uJakhobe. Ziyisipho esithunyelwe inkosi yami u-Esawu, laye uyeza nje emuva kwethu.’ ” ");
INSERT INTO nde_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Walaya njalo isisebenzi sesibili, lesesithathu lazozonke ezinye ezaziqhuba imihlambi wathi: “Kumele likhulume into efanayo ku-Esawu nxa lihlangana laye. ");
INSERT INTO nde_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Njalo lingakhohlwa ukuthi, ‘Inceku yakho uJakhobe iyeza ngemva kwethu.’ ” Ngoba wacabanga wathi: “Ngizamthoba ngezipho lezi engizithumela phambili; nxa sengimbona muva mhlawumbe uzangamukela.” ");
INSERT INTO nde_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Ngakho izipho zikaJakhobe zahanjiswa, zamandulela, kodwa yena wasala ezihonqweni ubusuku bonke. ");
INSERT INTO nde_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ngalobobusuku uJakhobe waphakama wathatha omkakhe bobabili, lezincekukazi zakhe zombili kanye lamadodana akhe alitshumi lamunye wawela izibuko likaJabhoki. ");
INSERT INTO nde_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Esebachaphisile wabuye wachaphisa yonke imfuyo yakhe. ");
INSERT INTO nde_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ngakho uJakhobe wasala yedwa, indoda ethile yabindana laye kwaze kwaba semathathakusa. ");
INSERT INTO nde_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Leyondoda yathi ngokubona ukuthi kayimehluli uJakhobe, yambamba inyonga, inyonga yakhe yakhumuka elokhu ebindana laleyondoda. ");
INSERT INTO nde_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Indoda yasisithi, “Ngiyekela ngihambe ngoba sokusile.” Kodwa uJakhobe wamphendula wathi, “Kangisoze ngikwekele uhambe ngaphandle kokuthi ungibusise.” ");
INSERT INTO nde_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Indoda yambuza yathi, “Ungubani ibizo lakho na?” Wathi, “NginguJakhobe.” ");
INSERT INTO nde_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Indoda yasisithi, “Ibizo lakho kalisayikuba nguJakhobe, kodwa u-Israyeli, ngoba ulwe loNkulunkulu kanye labantu wanqoba.” ");
INSERT INTO nde_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","UJakhobe wathi, “Akungitshele ibizo lakho.” Kodwa waphendula wathi “Ulibuzelani ibizo lami na?” Wasembusisa khonapho. ");
INSERT INTO nde_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ngakho uJakhobe wabiza indawo leyo ngokuthi yiPheniyeli esithi, “Kungoba ngimbonile uNkulunkulu ubuso ngobuso, kodwa impilo yami kayilinyazwanga.” ");
INSERT INTO nde_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ilanga lamphumela esedlula ePheniweli, ehamba eqhugezela ngenxa yenyonga yakhe. ");
INSERT INTO nde_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ngakho-ke kuze kube lamuhla abako-Israyeli kabayidli inyama elomsipha osuka enyongeni, ngoba inyonga kaJakhobe yenyela eduze lomsipha. ");
INSERT INTO nde_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","UJakhobe wathi evusa amehlo wabona u-Esawu, eqhamuka lamadoda akhe angamakhulu amane; wasesehlukanisa abantwana phakathi kukaLeya, uRasheli lezincekukazi zombili. ");
INSERT INTO nde_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Waqhuba phambili izincekukazi labantwabazo, kwalandela uLeya labantwabakhe, kweza uRasheli loJosefa ngemuva. ");
INSERT INTO nde_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yena ngokwakhe wahamba phambili wakhothama phansi emhlabathini kasikhombisa esebanga kumnewabo. ");
INSERT INTO nde_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Kodwa u-Esawu wagijima wahlangabeza uJakhobe wamanga; wamgona ngezingalo entanyeni wamanga. Bakhala. ");
INSERT INTO nde_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","U-Esawu wasekhangela wabona abesifazane labantwana. Wabuza wathi, “Ngobani laba ohamba labo na?” UJakhobe waphendula wathi, “Ngabantwana uNkulunkulu abaphe ngesihle inceku yakho.” ");
INSERT INTO nde_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Kwathi izincekukazi labantwabazo, zasondela zakhothamela phansi. ");
INSERT INTO nde_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Kwalandela uLeya kanye labantwabakhe beza bakhothamela phansi. Abokucina kwaba nguJosefa loRasheli, labo bakhothamela phansi. ");
INSERT INTO nde_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","U-Esawu wabuza wathi, “Utshoni ngemihlambi yonke le engihlangane layo?” Wathi, “Ngeyokucela umusa kuwe, nkosi yami.” ");
INSERT INTO nde_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Kodwa u-Esawu wathi, “Lami sengilakho okunengi, mnawami. Zigcinele lawe lokho olakho.” ");
INSERT INTO nde_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","UJakhobe wathi, “Hatshi bo, bakithi. Nxa ngisamukeleka kuwe yamukela isipho sami lesi. Ngoba ukubona ubuso bakho kufana lokubona ubuso bukaNkulunkulu, ikakhulu njengoba usungamukele ngesihle. ");
INSERT INTO nde_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ngicela ukuthi wamukele isipho leso esilethwe kuwe, ngoba uNkulunkulu ube lomusa kimi, ngaba lakho konke engikudingayo.” Kwathi ngoba uJakhobe encenga, u-Esawu wasamukela. ");
INSERT INTO nde_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","U-Esawu wasesithi, “Kasihambeni. Ngizahamba lani.” ");
INSERT INTO nde_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Kodwa uJakhobe wathi kuye, “Inkosi yami iyazi ukuthi abantwana babuthakathaka lokuthi ngisamele nginakekele izimvukazi lamankomokazi konke okusanda kuzala. Zingahanjiswa ngamandla okwelanga elilodwa nje, izifuyo zizakufa. ");
INSERT INTO nde_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ngakho inkosi yami kayizihambele phambili kwenceku yayo, mina ngilandele kancane okwamandla emihlambi eqhutshwayo labantwana, ngize ngifike enkosini yami eSeyiri.” ");
INSERT INTO nde_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","U-Esawu wathi, “Nxa kunjalo ngizatshiya amanye amadoda ami lawe.” UJakhobe wabuza wathi, “Kambe ube ukwenzelani lokho? Inkosi yami kayingenzele umusa nje kube kuphela.” ");
INSERT INTO nde_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ngakho ngalolosuku u-Esawu wasuka esebuyela eSeyiri. ");
INSERT INTO nde_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Kodwa uJakhobe waya eSukhothi lapho azakhela khona umuzi wakha lezibaya zezifuyo zakhe. Kungakho leyondawo ithiwa yiSukhothi. ");
INSERT INTO nde_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","UJakhobe esebuyile ePhadani Aramu wafika kuhle edolobheni laseShekhemu eKhenani wamisa izihonqo eduzane kwedolobho. ");
INSERT INTO nde_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ngenhlamvu zesiliva ezilikhulu wathenga isiqinti somhlabathi emadodaneni kaHamori, uyise kaShekhemu, lapho amisa khona ithente lakhe. ");
INSERT INTO nde_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Khonapho amisa i-alithari walibiza ngokuthi yi-Eli Elohe Israyeli. ");
INSERT INTO nde_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","UDina, indodakazi kaLeya ayizalela uJakhobe wasuka wayakwethekelela abafazi balelolizwe. ");
INSERT INTO nde_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Kwathi uShekhemu, indodana kaHamori umHivi, umbusi walowomango, ebona uDina, wamthatha wamdlova. ");
INSERT INTO nde_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Inhliziyo yakhe yathatheka ngoDina indodakazi kaJakhobe, wayithanda intombi le, wakhuluma layo kamnandi. ");
INSERT INTO nde_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","UShekhemu wathi kuyise uHamori, “Ngithathela intombi le ibe ngumkami.” ");
INSERT INTO nde_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","UJakhobe wathi ekuzwa ukuthi indodakazi yakhe uDina yayingcolisiwe, amadodana akhe ayesegangeni lezifuyo; wathula nje aze abuya ekhaya. ");
INSERT INTO nde_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ngakho usekaShekhemu, uHamori wayakhuluma loJakhobe. ");
INSERT INTO nde_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ngalesosikhathi amadodana kaJakhobe ayesebuyile evela egangeni evele esezwile okwasekwenzakele. Babelosizi njalo begcwele ulaka ngoba uShekhemu wayenze into elihlazo ko-Israyeli ngokudlova indodakazi kaJakhobe, into okwakungamelanga yenziwe. ");
INSERT INTO nde_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Kodwa uHamori wathi kubo, “Indodana yami uShekhemu uyayithanda indodakazi yakho. Muphe yona ibe ngumkakhe. ");
INSERT INTO nde_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Kasendiselane; sipheni amadodakazi enu, lani lizithathele amadodakazi ethu. ");
INSERT INTO nde_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Lingazihlalela phakathi kwethu; ilizwe livulekile kini. Hlalani kulo, thengisani kulo njalo lifuye kulo.” ");
INSERT INTO nde_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","UShekhemu wasesithi kuyise kaDina lakubanewabo, “Ngicela ukuthi lingamukele, ngizalinika loba yini eliyifunayo. ");
INSERT INTO nde_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Khulumani amalobolo lokangaziwe, mina ngizakuletha ngobunengi bakho njengokufuna kwenu, njalo ngizakukhupha konke elikubizayo. Lina ngiphani intombi kuphela nje ibe ngumkami.” ");
INSERT INTO nde_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Kwathi ngoba udadewabo uDina wayesengcolisiwe, amadodana kaJakhobe aphendula ngobuqili ekhuluma loShekhemu loyise uHamori. ");
INSERT INTO nde_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Athi kubo, “Asingeke senze into enjalo; ngeke siphe udadewethu indoda engasokwanga. Lokho kungaba lihlazo kithi. ");
INSERT INTO nde_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Sizavuma kuphela nxa lenze lokhu: ukuthi libe njengathi ngokusoka bonke abesilisa benu. ");
INSERT INTO nde_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Lapho-ke sesingalendisela amadodakazi ethu lathi sithathe amadodakazi enu. Sizakwakha phakathi kwenu sibe ngabantu banye lani. ");
INSERT INTO nde_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Kodwa nxa lingavumi ukusokwa sizamthatha udadewethu sihambe.” ");
INSERT INTO nde_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Icebo labo lakhanya lilihle kuHamori loShekhemu. ");
INSERT INTO nde_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ijaha leli eliyilo elalihlonitshwa kakhulu emzini kayise, kalisachithanga isikhathi ukukwenza lokho ababekutshilo ngoba lalitshiseka ngendodakazi kaJakhobe. ");
INSERT INTO nde_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ngakho uHamori lendodana yakhe uShekhemu baya entubeni yedolobho bayabonisana lamadoda edolobho lakibo. ");
INSERT INTO nde_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Bathi, “Amadoda la alomusa kithi. Kabahlale elizweni lethu bathengiselane labantu; ilizwe leli lilendawo enkulu abangahlala kuyo. Singathatha amadodakazi abo labo bangathatha awethu. ");
INSERT INTO nde_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Kodwa bangavuma ukuhlala phakathi kwethu kuphela nxa abesilisa bethu bengasokwa njengabo. ");
INSERT INTO nde_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Kambe izifuyo zabo, lempahla yabo kanye layo yonke imfuyo yabo kakukuba ngokwethu na? Ngakho kasivumeni, khona bezakwakha phakathi kwethu.” ");
INSERT INTO nde_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Wonke amadoda ayekhona entubeni yedolobho avumelana loHamori lendodana yakhe uShekhemu, kwathi bonke abesilisa balelodolobho basokwa. ");
INSERT INTO nde_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ngemva kwensuku ezintathu, bonke belokhu besebuhlungwini, amadodana kaJakhobe amabili, uSimiyoni loLevi, abanewabo bakaDina, bathatha inkemba zabo balihlasela idolobho belibele, babulala bonke abesilisa. ");
INSERT INTO nde_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","OHamori lendodana yakhe uShekhemu babaquma ngenkemba bamkhupha uDina endlini kaShekhemu bahamba. ");
INSERT INTO nde_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Amadodana kaJakhobe afikela phezu kwezidumbu aliphanga idolobho lapho udadewabo ayengcoliselwe khona. ");
INSERT INTO nde_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Athumba imihlambi yabo yezimvu lenkomo, labobabhemi lakho konke okwakungokwabo phakathi edolobheni langaphandle egangeni. ");
INSERT INTO nde_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Bayiqukula yonke inotho yabo kanye labafazi labantwana, bathumba konke okwakusezindlini kwaba yimpango. ");
INSERT INTO nde_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","UJakhobe wasesithi kuSimiyoni loLevi, “Selingehlisele uhlupho langenza ngasoleka kakhulu kumaKhenani lamaPherizi, abantu abahlala elizweni leli. Thina sibalutshwana, bangahlangana bangihlasele, mina lomuzi wami sizabhujiswa.” ");
INSERT INTO nde_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Kodwa bona baphendula bathi, “Bekufanele yini ukuthi aphathe udadewethu njengesifebe na?” ");
INSERT INTO nde_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","UNkulunkulu wasesithi kuJakhobe, “Yana eBhetheli wakhe khona, njalo khonapho wakhele uNkulunkulu i-alithari, yena owabonakala kuwe lapho ubalekela umnewenu u-Esawu.” ");
INSERT INTO nde_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ngakho uJakhobe wasesithi kwabomuzi wakhe lakubo bonke ababelaye, “Lahlani onkulunkulu bezizweni elilabo, lizihlambulule, lintshintshe lezigqoko zenu. ");
INSERT INTO nde_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Beselisiza sihambe siye eBhetheli lapho engizakwakha khona i-alithari likaNkulunkulu yena owangisizayo ngosuku lokuhlupheka kwami njalo olokhu elami loba ngingaze ngiye ngaphi.” ");
INSERT INTO nde_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Basebemupha uJakhobe bonke onkulunkulu bezizweni ababelabo lamacici ayesendlebeni zabo, uJakhobe wakumbela ngaphansi kwesihlahla somʼOkhi eShekhemu. ");
INSERT INTO nde_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Emva kwalokho basebesuka, ukumesaba uNkulunkulu kwehlela imizi yonke ababakhelane layo, akwaze kwaba loyedwa owaxotshana labo. ");
INSERT INTO nde_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","UJakhobe wafika eLuzi (leyo yiBhetheli) kanye labo bonke ayelabo elizweni laseKhenani. ");
INSERT INTO nde_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Wakha khona i-alithari, indawo waseyibiza ngokuthi yi-Eli Bhetheli, ngoba kwakulapho uNkulunkulu aziveza khona ngesikhathi ebalekela umfowabo. ");
INSERT INTO nde_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","UDibhora, umlizane kaRabheka wafa, wembelwa ngaphansi komʼOkhi ngezansi kweBhetheli. Yikho yathiwa yi-Aloni Bhakhuthi. ");
INSERT INTO nde_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","UJakhobe esebuyile ePhadani Aramu uNkulunkulu wabonakala kuye njalo, wambusisa. ");
INSERT INTO nde_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","UNkulunkulu wathi kuye, “Ibizo lakho linguJakhobe, kodwa kawusayi kuthiwa unguJakhobe; ibizo lakho selizathiwa ungu-Israyeli.” Ngakho wamutha wathi ngu-Israyeli. ");
INSERT INTO nde_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","UNkulunkulu wathi kuye, “NginguNkulunkulu uSomandla; zalanani lande ngobunengi. Kuzaphuma kuwe isizwe lezinhlanga zezizwe, lamakhosi azavela emzimbeni wakho. ");
INSERT INTO nde_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ilizwe engalinika u-Abhrahama lo-Isaka ngilinika wena lawe, njalo ilizwe leli ngizalinika izizukulwane zakho eziza emva kwakho.” ");
INSERT INTO nde_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","UNkulunkulu wasephakama emtshiya endaweni lapho ayeke wakhuluma laye khona. ");
INSERT INTO nde_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","UJakhobe wamisa insika yelitshe endaweni leyo uNkulunkulu ayekhulume laye khona, wasethululela phezu kwayo umnikelo onathwayo; wathela njalo amafutha phezu kwayo. ");
INSERT INTO nde_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","UJakhobe wasebiza indawo leyo lapho uNkulunkulu akhuluma laye khona ngokuthi yiBhetheli. ");
INSERT INTO nde_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Basebehamba besuka eBhetheli. Kwathi belokhu besesebucwala kwe-Efrathi, uRasheli wahelelwa kwaba nzima ukubeletha. ");
INSERT INTO nde_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Kwathi ekulobobunzima bokubeletha umbelethisi wathi kuye, “Ungesabi. Ngoba uzazuza enye indodana.” ");
INSERT INTO nde_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Kwathi esephela ngoba wayesesifa wetha indodana yakhe wathi nguBheni-Oni. Kodwa uyise wayo wayithi nguBhenjamini. ");
INSERT INTO nde_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Wafa kanjalo uRasheli wembelwa endleleni kuyiwa e-Efrathi (kutshiwo iBhethilehema.) ");
INSERT INTO nde_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","UJakhobe wakha insika phezu kwethuna, kuze kube lamhla insika leyo itshengisa ithuna likaRasheli. ");
INSERT INTO nde_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","U-Israyeli wabuye wathutha wayamisa ithente lakhe ngale kweMigidali-Eda. ");
INSERT INTO nde_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","U-Israyeli esakhile kulowomango, uRubheni wasuka wayalala lomfazi weceleni kayise uBhiliha, njalo u-Israyeli wakuzwa. UJakhobe wayelamadodana alitshumi lambili: ");
INSERT INTO nde_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Amadodana kaLeya ayeyila: uRubheni izibulo likaJakhobe, uSimiyoni, uLevi, uJuda, u-Isakhari loZebhuluni. ");
INSERT INTO nde_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Amadodana kaRasheli ayeyila: uJosefa loBhenjamini. ");
INSERT INTO nde_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Amadodana encekukazi kaRasheli, uBhiliha ayeyila: uDani loNafithali. ");
INSERT INTO nde_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Amadodana encekukazi kaLeya uZilipha ayeyila: uGadi lo-Asheri. La ayengamadodana kaJakhobe awazalela ePhadani Aramu. ");
INSERT INTO nde_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","UJakhobe weza ekhaya kuyise u-Isaka eMamure, eduze leKhiriyathi Aribha (kutsho iHebhroni) lapho u-Abhrahama lo-Isaka ababehlala khona. ");
INSERT INTO nde_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","U-Isaka waphila okweminyaka elikhulu lamatshumi ayisificaminwembili. ");
INSERT INTO nde_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Wafika ekucineni wafa, wembelwa labantu bakibo eseluphele leminyaka yakhe isiminengi. Amadodana akhe u-Esawu loJakhobe bamngcwaba. ");
INSERT INTO nde_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Lo ngumlando ka-Esawu (okungu-Edomi). ");
INSERT INTO nde_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","U-Esawu wathatha ebafazini baseKhenani: u-Ada indodakazi ka-Eloni umHithi, lo-Oholibhama indodakazi ka-Ana, njalo eyindodakazi kaZibhiyoni umHivi, ");
INSERT INTO nde_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","njalo loBhasemathi indodakazi ka-Ishumayeli njalo engudadewabo kaNebhayothi. ");
INSERT INTO nde_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","U-Ada wazala u-Elifazi ku-Esawu, uBhasemathi wazala uRuweli, ");
INSERT INTO nde_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","u-Oholibhama wazala uJewushi, loJalamu loKhora. La ayengamadodana ka-Esawu, awazala eKhenani. ");
INSERT INTO nde_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","U-Esawu wathatha omkakhe lamadodana akhe kanye lamadodakazi akhe labo bonke ababesemzini wakhe kanye lezifuyo zakhe lezinye izinyamazana zakhe lempahla zonke ayezizuzile eKhenani, wasuka waya khatshana lomfowabo uJakhobe. ");
INSERT INTO nde_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Imfuyo yabo yayinengi kakhulu okokuthi babengeke bahlale ndawonye; lomhlaba ababehlala kuwo wawungasoze ubathwale bobabili ngenxa yezifuyo zabo. ");
INSERT INTO nde_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ngakho u-Esawu (kutshiwo u-Edomi) wayakwakha elizweni lamaqaqa elaseSeyiri. ");
INSERT INTO nde_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Lo ngumlando ka-Esawu uyise wama-Edomi elizweni lamaqaqa elaseSeyiri. ");
INSERT INTO nde_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","La ngamabizo amadodana ka-Esawu: U-Elifazi, indodana yomka-Esawu u-Ada, lo Ruweli indodana yomka-Esawu uBhasemathi. ");
INSERT INTO nde_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Amadodana ka-Elifazi ayeyila: uThemani, u-Omari, uZefo, uGathamu loKhenazi. ");
INSERT INTO nde_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Indodana ka-Esawu u-Elifazi wayelomfazi weceleni owayethiwa nguThimina, owamzalela u-Amaleki. Laba babengabazukulu baka-Ada umka-Esawu. ");
INSERT INTO nde_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Amadodana kaRuweli ayeyila: uNahathi, uZera, uShama loMiza. Laba bebengabazukulu bomka-Esawu uBhasemathi umka-Esawu. ");
INSERT INTO nde_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Amadodana kamka-Esawu u-Oholibhama, indodakazi ka-Ana, njalo engumzukulu kaZibhiyoni, awazalela u-Esawu ayeyila: uJewushi, uJalamu loKhora. ");
INSERT INTO nde_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Laba babezinduna kwabosendo luka-Esawu: Amadodana ka-Elifazi izibulo lika-Esawu: Induna uThemani, u-Omari, uZefo, uKhenazi, ");
INSERT INTO nde_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","uKhora, uGathamu, lo-Amaleki. Lezi kwakuzinduna ezidabuka ku-Elifazi, e-Edomi; zazingabazukulu baka-Ada. ");
INSERT INTO nde_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Amadodana kaRuweli indodana ka-Esawu: Izinduna uNahathi, uZera, uShama loMiza. Lezizinduna zazidabuka kuRewuli e-Edomi; zazingabazukulu bakaBhasemathi umka-Esawu. ");
INSERT INTO nde_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Amadodana ka-Oholibhama, umka-Esawu: Izinduna uJewushi, uJalamu loKhora. Lezi kwakuzinduna ezazidabuka kumka-Esawu, u-Oholibhama, indodakazi ka-Ana. ");
INSERT INTO nde_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","La ayengamadodana ka-Esawu (kutshiwo u-Edomi), njalo bona babezinduna zabo. ");
INSERT INTO nde_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","La ayengamadodana kaSeyiri umHori, ababehlala kulowomango: ULothani, uShobhali, uZibhiyoni, u-Ana, ");
INSERT INTO nde_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","uDishoni, u-Ezeri loDishani. La amadodana kaSeyiri e-Edomi ayeyizinduna zamaHori. ");
INSERT INTO nde_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Amadodana kaLothani ayeyila: uHori loHemani. UThimina wayengudadewabo kaLothani. ");
INSERT INTO nde_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Amadodana kaShobhali ayeyila: u-Alivani, uManahathi, u-Ebhali, uShefo lo-Onami. ");
INSERT INTO nde_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Amadodana kaZibhiyoni ayeyila: u-Ayiya lo-Ana. (Lo nguye u-Ana owafumana izintombo zamanzi atshisayo enkangala eselusa obabhemi bakayise uZibhiyoni.) ");
INSERT INTO nde_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Abantwana baka-Ana babeyilaba: uDishoni lo-Oholibhama indodakazi ka-Ana. ");
INSERT INTO nde_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Amadodana kaDishoni ayeyila: uHemidani, u-Eshibhani, u-Ithirani loKherani. ");
INSERT INTO nde_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Amadodana ka-Ezeri ayeyila: uBhilihani, uZavani lo-Akhani. ");
INSERT INTO nde_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Amadodana kaDishani ayeyila: u-Uzi lo-Arani. ");
INSERT INTO nde_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Laba babezinduna zamaHori: ULothani, uShobhali, uZibhiyoni, u-Ana, ");
INSERT INTO nde_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","uDishoni, u-Ezeri loDishani. Laba babezinduna zamaHori kusiya ngezigaba zabo elizweni laseSeyiri. ");
INSERT INTO nde_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","La ayengamakhosi abusa e-Edomi kungakabusi inkosi yako-Israyeli: ");
INSERT INTO nde_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","UBhela indodana kaBheyori waba yinkosi e-Edomi. Idolobho lakhe lalibizwa ngokuthi yiDinihabha. ");
INSERT INTO nde_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","UBhela esefile, uJobhabhi indodana kaZera waseBhozira wathatha umbuso waba yinkosi. ");
INSERT INTO nde_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","UJobhabhi esefile, uHushamu waselizweni lamaThemani wathatha umbuso waba yinkosi. ");
INSERT INTO nde_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","UHushamu esefile, uHadadi indodana kaBhedadi, owanqoba uMidiyani elizweni laseMowabi, wathatha umbuso waba yinkosi. Idolobho lakhe lalibizwa ngokuthi yi-Avithi. ");
INSERT INTO nde_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","UHadadi esefile, uSamila waseMasirekha wathatha umbuso waba yinkosi. ");
INSERT INTO nde_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","USamila esefile, uShawuli waseRehobhothi phezu komfula wathatha umbuso waba yinkosi. ");
INSERT INTO nde_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","UShawuli esefile, uBhali-Hanani indodana ka-Akhibhori wathatha umbuso waba yinkosi. ");
INSERT INTO nde_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","UBhali-Hanani indodana ka-Akhibhori esefile, uHadari wathatha umbuso waba yinkosi. Idolobho lakhe labizwa ngokuthi yiPawu; njalo ibizo lomkakhe lalinguMehethabheli indodakazi kaMathiredi, indodakazi kaMe-Zahabhi. ");
INSERT INTO nde_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Lezi kwakuzinduna ezadabuka ku-Esawu, ngamabizo azo, kusiya ngosendo lwazo lezigodi zazo: UThimina, u-Aliva, uJethethi, ");
INSERT INTO nde_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","u-Oholibhama, u-Ela, uPhinoni, ");
INSERT INTO nde_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","uKhenazi, uThemani, uMibhizari, ");
INSERT INTO nde_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","uMagidiyeli lo-Iramu. Lezi kwakuzinduna ze-Edomi, kusiya ngokuhlala kwabo elizweni ababakhe kulo. Lolu yilo-ke usendo luka-Esawu, uyise wama-Edomi. ");
INSERT INTO nde_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","UJakhobe wahlala elizweni lapho uyise laye ahlala kulo, ilizwe laseKhenani. ");
INSERT INTO nde_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Lo ngumlando wosendo lukaJakhobe. UJosefa ijaha elalileminyaka elitshumi lesikhombisa, wayeselusa imihlambi yezimvu labanewabo, amadodana kaBhiliha lamadodana kaZilipha, abafazi bakayise, wasebaceba kuyise. ");
INSERT INTO nde_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","U-Israyeli wasuka wamthanda uJosefa ukwedlula wonke amanye amadodana akhe, ngoba wamzala eseluphele; yikho wamenzela ijazi eliceciswe kakhulu. ");
INSERT INTO nde_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Kwathi abafowabo bebona ukuthi uyise wayemthanda ukwedlula bonke abanye bamzonda kabazange bamkhulumise ngothando. ");
INSERT INTO nde_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","UJosefa waphupha, wathi esebatshelile ngephupho lakhe bamzonda ngokwedlulisileyo. ");
INSERT INTO nde_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Wathi kubo, “Zwanini iphupho engibe lalo: ");
INSERT INTO nde_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","besibopha izithungo zamabele sisemasimini lapho okuthe masinyane esami isithungo saphakama sema saqonda, kwathi ezenu izithungo zasigombolozela esami, zasikhothamela phansi.” ");
INSERT INTO nde_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Abanewabo bathi kuye. “Ufisa ukubusa phezu kwethu na? Ungasibusa ngempela na?” Basebemzonda ngamandla ngenxa yephupho lakhe lalokho ayekutshilo. ");
INSERT INTO nde_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Waphinda waba lelinye iphupho, walitshela abanewabo. Wathi, “Lalelani, ngibe lalo elinye iphupho, kuleli, ilanga lenyanga kanye lezinkanyezi ezilitshumi lanye bezingikhothamela phansi.” ");
INSERT INTO nde_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Wathi eselitshele uyise njalo labanewabo uyise wamkhalimela wathi, “Liphupho bani leli oliphuphileyo? Utsho ukuthi unyoko lami labanewenu sizaguqa phansi emhlabathini sibili siguqela wena?” ");
INSERT INTO nde_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Abanewabo babalomona ngaye, kodwa uyise wayigcina engqondweni yakhe indaba le. ");
INSERT INTO nde_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Abanewabo basuka bahamba lemihlambi kayise emadlelweni eduze kweShekhemu. ");
INSERT INTO nde_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","U-Israyeli wathi kuJosefa, “Njengoba usazi abanewenu basemadlelweni lemihlambi eduze kweShekhemu. Lalela-ke, ngifuna ukukuthuma kubo.” Waphendula wathi, “Kulungile.” ");
INSERT INTO nde_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ngakho wasesithi kuye, “Hamba uyebona ingabe abafowenu bayaphila yini kanye lemihlambi, ukuze ubuye uzongazisa.” Lakanye wamvalelisa esuka esigodini saseHebhroni. UJosefa esefikile eShekhemu, ");
INSERT INTO nde_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","wafunyanwa yindoda ezula egangeni yambuza yathi, “Udingani?” ");
INSERT INTO nde_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Waphendula wathi, “Ngidinga abafowethu. Kambe ungangitshela ukuthi belusela ngaphi imihlambi yabo na?” ");
INSERT INTO nde_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Indoda yaphendula yathi, “Sebesukile lapha. Ngabezwa besithi, ‘Kasiyeni eDothani.’ ” Ngakho uJosefa wabalandela abafowabo wayabafumana eduze kweDothani. ");
INSERT INTO nde_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Kodwa bambona esesekude, wathi engakafiki kubo, bakhanda icebo lokumbulala. ");
INSERT INTO nde_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Batshelana bathi, “Nanguyana umphuphi lowana esiza. ");
INSERT INTO nde_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Zwanini, kasimbulaleni simphosele kwelinye lamagodi la besesisithi udliwe yisilo esesabekayo. Besesibona-ke ukuthi azaphelela ngaphi amaphupho akhe.” ");
INSERT INTO nde_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Kwathi uRubheni esekuzwile lokhu, wazama ukuthi amlamulele ezandleni zabo. Wathi, “Kasingacimi impilo yakhe. ");
INSERT INTO nde_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Lingachithi gazi. Mphoseleni emgodini lo lapha enkangala, kodwa lingambeki isandla.” URubheni watsho lokhu ukuze amlamulele kubo abesembuyisela kuyise. ");
INSERT INTO nde_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ngakho kwathi uJosefa efika kubafowabo, bamhlubula ijazi lakhe, elalibalazwe kakuhle ayeligqokile, ");
INSERT INTO nde_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","bamthatha bayamphosela emgodini. Umgodi lo wawungela lutho, kungelamanzi phakathi kwawo. ");
INSERT INTO nde_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Bathi sebehlezi phansi ukuthi badle, bathi baphosa amehlo babona udwendwe lwama-Ishumayeli luvelela eGiliyadi. Amakamela abo ayethwaliswe iziyoliso, ibhami lemure, konke lokhu bekusa eGibhithe. ");
INSERT INTO nde_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","UJuda wathi kubafowabo, “Sizazuzani nxa sibulala umfowethu sigqibele igazi lakhe na? ");
INSERT INTO nde_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Zwanini, kasimthengiseni kuma-Ishumayeli thina singambeki sandla; kambe yena evele engumfowethu, eyinyama yethu legazi lethu.” Abafowabo bavuma. ");
INSERT INTO nde_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ngakho kwathi abathengisi bamaMidiyani besedlula abafowabo bamkhupha uJosefa emgodini bamthengisa ngamashekeli esiliva angamatshumi amabili kuma-Ishumayeli, amthatha aya laye eGibhithe. ");
INSERT INTO nde_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","URubheni wathi esebuyela emgodini wafumana uJosefa engasekho, wasedabula izigqoko zakhe ngokudabuka. ");
INSERT INTO nde_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Wabuyela kubafowabo wathi, “Umfana kasekho! Sengizakwenzanjani manje?” ");
INSERT INTO nde_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Basebethatha ijazi likaJosefa, babulala imbuzi basebegxamuza ijazi lelo egazini. ");
INSERT INTO nde_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Balithatha ijazi lokuceciswa babuyela lalo kuyise bathi, “Silidobhile. Ake ulikhangele kuhle kumbe lijazi lendodana yakho.” ");
INSERT INTO nde_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Lakanye walibona liyilo wathi, “Lijazi lendodana yami. Udliwe yisilo esesabekayo. Ngempela uJosefa usedlithizwe waba yizicucu.” ");
INSERT INTO nde_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","UJakhobe wasedabula izigqoko zakhe, wagqoka ezamasaka walilela indodana yakhe okwensuku ezinengi. ");
INSERT INTO nde_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Wonke amadodana akhe lamadodakazi beza ukuzamduduza, kodwa kavumanga ukududuzeka. Wathi, “Hatshi, ngizakuya ethuneni ngilila nginje, ngiye endodaneni yami.” Uyise wamkhalela kanjalo. ");
INSERT INTO nde_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Kusenjalo, amaMidiyani amthengisa uJosefa eGibhithe kuPhothifa, omunye wezikhulu zikaFaro, owayengumlawuli wabalindi. ");
INSERT INTO nde_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ngalesosikhathi uJuda watshiya abafowabo wahamba wayahlala lendoda yase-Adulami eyayithiwa nguHira. ");
INSERT INTO nde_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Khonale uJuda wabonana lendodakazi yendoda engumKhenani eyayithiwa nguShuwa. Wayithatha wembatha layo; ");
INSERT INTO nde_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","yathatha isisu yazala indodana yathiwa ngu-Eri. ");
INSERT INTO nde_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Wazithwala njalo wazala indodana wayithi ngu-Onani. ");
INSERT INTO nde_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Wazala njalo enye indodana wayithi nguShela. Le wayizalela eKhezibhi. ");
INSERT INTO nde_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","UJuda wazuzela u-Eri izibulo lakhe umfazi, ibizo lakhe linguThamari. ");
INSERT INTO nde_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Kodwa u-Eri izibulo likaJuda, wayengcolile emehlweni kaThixo; uThixo wasembulala. ");
INSERT INTO nde_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","UJuda wasesithi ku-Onani, “Lala lomkamfowenu ugcwalise umlandu wakho njengomfowabo uzalele umfowenu abantwana.” ");
INSERT INTO nde_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Kodwa u-Onani wakwazi ukuthi inzalo leyo yayingezukuba ngeyakhe; ngakho kwakusithi sonke isikhathi angalala lomkamfowabo achithele inhlanyelo phansi emhlabathini ukuze angaze azalela umfowabo abantwana. ");
INSERT INTO nde_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Lokho ayekwenza kwakukubi emehlweni kaThixo; ngakho uThixo wambulala. ");
INSERT INTO nde_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","UJuda wasesithi kumalukazana wakhe uThamari, “Hamba uyehlala njengomfelokazi emzini kayihlo indodana yami uShela ize ikhule.” Ngoba wanakana wathi, “Laye angafa njengabanewabo.” Ngakho uThamari wahamba wayahlala emzini kayise. ");
INSERT INTO nde_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ngemva kwesikhathi eside umkaJuda, indodakazi kaShuwa wafa. Kwathi uJuda eseduduzekile waya eThimina, emadodeni ayegunda izimvu zakhe, ehamba lomngane wakhe uHira umʼAdulami. ");
INSERT INTO nde_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Kwathi uThamari esetsheliwe kwathiwa, “Uyihlozala uyeza eThimina ukuzagunda izimvu zakhe,” ");
INSERT INTO nde_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","wakhulula izigqoko zakhe zokuzila wazimboza ngesimbombozo ukuzifihla, wasehlala phansi eduzane lesango lase-Enayimi, elisendleleni yaseThimina. Ngoba wabona ukuthi loba uShela wayesekhulile, yena wayelokhu engakamphiwa ukuthi abe ngumkakhe. ");
INSERT INTO nde_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","UJuda wathi embona wacabanga ukuthi yisifebe, ngoba wayezivale ubuso. ");
INSERT INTO nde_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Kwathi ngoba engamboni ukuthi ngumalokazana wakhe waya kuye eceleni komgwaqo wathi, “Woza manje, ngifuna ukulala lawe.” Yena wabuza wathi, “Uzangiphani ngingalala lawe?” ");
INSERT INTO nde_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Wathi, “Ngizakuthumezela izinyane lembuzi emhlambini wami.” UThamari wabuza wathi, “Uzangipha na ulutho lube yisibambiso ungakalithumezi?” ");
INSERT INTO nde_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Wathi, “Ngikuphe sibambiso bani?” Waphendula wathi, “Isilengiso sophawu lwakho lentambo yaso, kanye lodondolo lwakho oluphetheyo.” Ngakho wamupha lezozinto waselala laye, wahle wazithwala. ");
INSERT INTO nde_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Esesuka lapho uThamari wakhupha isimbombozo sakhe wagqoka izigqoko zakhe zokuzila njalo. ");
INSERT INTO nde_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Kusenjalo uJuda wathumezela izinyane lembuzi ngomngane wakhe umʼAdulami ukuze abuyiselwe isibambiso sakhe esasikowesifazane lowo, kodwa wamswela. ");
INSERT INTO nde_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Wabuza amadoda ayehlala lapho wathi, “Singaphi isifebe ebesilapha eceleni komgwaqo e-Enayimi na?” Athi, “Kakuzange kube lesifebe lapha.” ");
INSERT INTO nde_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ngakho wasebuyela kuJuda wayakuthi, “Kangimfumananga. Futhi amadoda lawo ahlala khona athi kakuzange kube lesifebe esasihlala lapho.” ");
INSERT INTO nde_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","UJuda wasesithi, “Myekele ahle akugcine khonokho alakho funa sicine sesiyinhlekisa. Phezu kwalokho mina bengimthumezele izinyane lembuzi, kodwa kawusamfumananga.” ");
INSERT INTO nde_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ngemva kwezinyanga ezintathu uJuda watshelwa ukuthi umalukazana wakhe uThamari wayesefebile wasethatha isisu. UJuda wathi, “Mkhupheni, atshiswe aze afe.” ");
INSERT INTO nde_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Kwathi lapho ekhutshwa wathumela ilizwi kuyisezala wathi, “Ngoniwa yindoda engumnikazi walezizinto.” Wengeza ngokuthi, “Akubone ukuthi singaba ngesikabani isilengiso sophawu lesi lentambo kanye lodondolo lolu.” ");
INSERT INTO nde_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","UJuda wazazi izinto lezo wathi, “Ulungile kulami, ngoba kangisamphanga endodaneni yami uShela.” Kasaphindanga wembatha laye njalo. ");
INSERT INTO nde_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Kwathi isikhathi sakhe sokubeletha sesifikile, wayelamaphahla angabafana esiswini. ");
INSERT INTO nde_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Wathi khonapho ebeletha omunye wawo wakhupha isandla; umbelethisi wathatha intambo ebomvu wayibophela esihlakaleni sesandla salo wathi, “Leli yilo eliphume kuqala.” ");
INSERT INTO nde_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Kodwa labuyisela isandla, umfowabo waphuma kuqala, wasesithi, “Le yiyo indlela ofohle ngayo!” Laseliphiwa ibizo elithi nguPherezi. ");
INSERT INTO nde_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ngakho umfowabo, owayelentambo esihlakaleni, waphuma wethiwa ibizo wathiwa nguZera. ");
INSERT INTO nde_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","UJosefa wathathwa wasiwa eGibhithe. UPhothifa, owayengomunye wezikhulu zikaFaro, eyindunankulu yabalindi, wamthenga kuma-Ishumayeli abayibo abamletha khona. ");
INSERT INTO nde_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","UThixo wayelaye uJosefa, waphumelela, wahlala endlini yenkosi yakhe umGibhithe. ");
INSERT INTO nde_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Kwathi inkosi yakhe ikubona ukuthi uThixo wayelaye lokuthi uThixo wamphumelelisa kukho konke ayekwenza, ");
INSERT INTO nde_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","uJosefa wasethandeka kuye wasesiba yinceku yakhe. UPhothifa wasembeka ukuba ngumphathi womuzi wakhe, kwathi konke ayelakho wakubeka ezandleni zakhe. ");
INSERT INTO nde_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Kusukela ngesikhathi embeka ukuba ngumphathi womuzi wakhe lakho konke okwakungokwakhe, uThixo wawubusisa umuzi womGibhithe ngenxa kaJosefa. Isibusiso sikaThixo saba phezu kwakho konke uPhothifa ayelakho, loba kusendlini loba kusensimini. ");
INSERT INTO nde_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ngakho watshiya konke okwakhe ezandleni zikaJosefa; kwathi ngoba uJosefa enguye ophetheyo wakhohlwa ngakho konke ngaphandle kokudla ayekudla. UJosefa lo wayemi kuhle, ebukeka, ");
INSERT INTO nde_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","kwasekusithi ngemva kwesikhathi inkosikazi yenkosi yakhe yambuka, yamfisa uJosefa yathi, “Woza engutsheni lami!” ");
INSERT INTO nde_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Kodwa wala. Wamtshela wathi, “Njengoba kuyimi engiphetheyo, inkosi yami kayizihluphi ngalutho emzini wayo; yonke into elayo iyibeke ezandleni zami. ");
INSERT INTO nde_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Kakho omkhulu kulami kulumuzi. Inkosi yami kayingalisi lutho ngaphandle kwakho, ngoba wena ungumkayo. Pho ngingayenza kanjani into embi kanje, ngenze isono kuNkulunkulu na?” ");
INSERT INTO nde_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Kwathi loba emphikelela uJosefa insuku ngensuku, wala ukulala laye wala lokuthi ahlale laye. ");
INSERT INTO nde_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ngolunye usuku wangena endlini ukuqhuba umsebenzi wakhe, izisebenzi zasendlini zingekho phakathi endlini. ");
INSERT INTO nde_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","UmkaPhothifa wambamba ngesigqoko wathi, “Woza engutsheni ulale lami!” Kodwa waphunyuka wabaleka waphuma endlini, isigqoko sakhe sasala esandleni sowesifazane. ");
INSERT INTO nde_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Kwathi ebona ukuthi utshiye isigqoko sakhe esandleni sakhe njalo wabaleka endlini, ");
INSERT INTO nde_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","owesifazane wamemeza izisebenzi zendlini wathi kuzo, “Khangelani, umHebheru lo walethwa lapha ukuzadlala ngathi! Ungene lapha efuna ukulala lami, kodwa ngahlaba umkhosi. ");
INSERT INTO nde_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Uthe esizwa ngihlaba umkhosi ngidinga uncedo, wasetshiya isigqoko sakhe eceleni kwami wabaleka waphuma endlini.” ");
INSERT INTO nde_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Wasigcina isigqoko eceleni kwakhe inkosi kaJosefa yaze yabuya ngekhaya. ");
INSERT INTO nde_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Waseyitshela indaba le wathi: “Isigqili somHebheru lesiyana owasilethela sona sifikile kimi ukuzadlala ngami. ");
INSERT INTO nde_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Kodwa ngonele ukuthi ngihlabe umkhosi ngidinga uncedo, satshiya isigqoko saso eceleni kwami sabaleka saphuma endlini.” ");
INSERT INTO nde_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Kwathi inkosi yakhe isizwile indaba eyayitshelwa ngumfazi esithi, “Singenze njalo isigqili sakho,” yathukuthela kakhulu. ");
INSERT INTO nde_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Inkosi yakhe uJosefa yamthatha yamphosela entolongweni, indawo lapho okwakuvalelwa khona izibotshwa zenkosi. Kodwa kwathi uJosefa ekhonapho entolongweni, ");
INSERT INTO nde_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","uThixo waba laye; wamenzela umusa wamenza wathandeka emehlweni omphathijele. ");
INSERT INTO nde_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ngakho-ke umphathijele wamkhweza wamenza umphathi wabo bonke ababebotshiwe besentolongweni, njalo kwaba nguye okhangele konke okwakusenziwa khona. ");
INSERT INTO nde_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Umphathijele kazange azihluphe loba ngani eyayiphethwe nguJosefa ngoba uThixo wayelaye uJosefa, wamupha impumelelo kukho konke ayekwenza. ");
INSERT INTO nde_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Emva kwesikhathi esithile umphathinkezo lomphekizinkwa wenkosi yaseGibhithe bayikhuba inkosi yabo, inkosi yaseGibhithe. ");
INSERT INTO nde_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","UFaro wayezizondele izikhulu zakhe zombili, umphathinkezo omkhulu lomphekizinkwa omkhulu, ");
INSERT INTO nde_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","wabaphosela entolongweni eyayisendlini kandunankulu wabalindi, lapho uJosefa ayevalelwe khona. ");
INSERT INTO nde_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Indunankulu yabalindi yabanikela kuJosefa, wabalawula. Kwathi sebehlale entolongweni okwesikhathi esithile, ");
INSERT INTO nde_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ngulowo wamadoda la amabili, umphathinkezo lomphekizinkwa, abenkosi yaseGibhithe, ababevalelwe baphupha amaphupho ngabusuku bunye, kwathi yilelo iphupho laba lengcazelo yalo. ");
INSERT INTO nde_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Kwathi uJosefa efika kubo kusisa ekuseni, wabona bebunile. ");
INSERT INTO nde_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Wasezibuza izikhulu zikaFaro ezazisentolongweni kanye laye endlini yenkosi yakhe wathi, “Kungani ubuso benu bubunile kanje lamuhla na?” ");
INSERT INTO nde_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Baphendula bathi, “Sobabili siphuphile, kodwa kakho ongasichasisela amaphupho ethu.” Ngakho uJosefa wasesithi kubo, “Izingcazelo kakusizikaNkulunkulu na? Ngitshelani amaphupho enu.” ");
INSERT INTO nde_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Umphathinkezo omkhulu wamtshela uJosefa ngephupho lakhe. Wathi kuye, “Ephutsheni lami ngibone isihlahla sevini siphambi kwami, ");
INSERT INTO nde_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","lelovini lilengatsha ezintathu. Lonela ukuhluma lahle laqhakaza, amaxha alo ahle avuthwa aba yizithelo ezivuthiweyo. ");
INSERT INTO nde_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Inkezo kaFaro ibisesandleni sami, ngawathatha amagrebisi ngawakhamela enkezweni kaFaro ngamqhubela esandleni sakhe.” ");
INSERT INTO nde_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","UJosefa wathi kuye, “Nanku elikutshoyo. Amagatsha amathathu yizinsuku ezintathu. ");
INSERT INTO nde_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Phakathi kwensuku ezintathu uFaro uzaphakamisa ikhanda lakho akubisele esikhundleni sakho, njalo uzayibeka inkezo kaFaro esandleni sakhe njengalokhu owawuvele ukwenza usesengumphathinkezo yakhe. ");
INSERT INTO nde_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Kodwa nxa konke sekulungile ungikhumbule, ungenzele umusa; ungikhulumele kuFaro ukuze ngiphume kule intolongo. ");
INSERT INTO nde_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ngoba ngasuswa ngamandla elizweni lamaHebheru, futhi lapha kangenzanga lutho olufanele ukuthi ngifakwe entolongweni.” ");
INSERT INTO nde_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Kwathi umphekizinkwa omkhulu ebona ukuthi uJosefa wayenike ingcazelo emnandi, wathi kuJosefa, “Lami njalo ngiphuphile: Phezu kwekhanda lami bekulezitsha zesinkwa ezintathu. ");
INSERT INTO nde_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Esitsheni esiphezulu bekulemihlobo yonke yalokho okubhekhelwe uFaro, kodwa izinyoni zazilokhu zisidlala esitsheni sisekhanda lami.” ");
INSERT INTO nde_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","UJosefa wathi, “Nanku elikutshoyo. Izitsha ezintathu zinsuku ezintathu. ");
INSERT INTO nde_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Phakathi kwensuku ezintathu uFaro uzaliphakamisa ikhanda lakho akulengise esihlahleni. Izinyoni zizakudla inyama yakho.” ");
INSERT INTO nde_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ilanga lesithathu laliyisikhumbuzo sokuzalwa kukaFaro, ngakho wenzela izikhulu zakhe idili. Waphakamisa amakhanda amabili, elomphathinkezo omkhulu lelomphekizinkwa omkhulu phambi kwezikhulu zakhe: ");
INSERT INTO nde_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Wabuyisela umphathinkezo esikhundleni sakhe, waphinda njalo ukubeka inkezo esandleni sikaFaro, ");
INSERT INTO nde_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","kodwa walengisa umphekizinkwa omkhulu, kwaba njengoba uJosefa wayetshilo kubo ekubachasiseleni kwakhe. ");
INSERT INTO nde_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Kodwa umphathinkezo omkhulu kasamkhumbulanga uJosefa; wakhohlwa ngaye. ");
INSERT INTO nde_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Kwathi sekwedlule iminyaka emibili egcweleyo uFaro waba lephupho: Wazibona emi okhunjini lukaNayili, ");
INSERT INTO nde_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","kwasekuqhamuka emfuleni lowo amankomokazi ayisikhombisa, egcwele njalo enonile, esidla phakathi kwemihlanga. ");
INSERT INTO nde_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ngemva kwawo kwathutsha amanye ayisikhombisa, amabi njalo acakileyo, aphuma kuNayili afika ema eceleni kwalawo ayesokhunjini lomfula. ");
INSERT INTO nde_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Amankomokazi ayemabi, ecakile aginya lawo ayisikhombisa ayegcwele, enonile. UFaro wasephaphama. ");
INSERT INTO nde_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Wabuye walala waphupha okwesibili: Izikhwebu zamabele eziyisikhombisa, zigcwele zizinhle, zazikhula ehlangeni linye. ");
INSERT INTO nde_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ngemva kwazo kwakhula ezinye izikhwebu eziyisikhombisa, zicakile njalo zihangulwe ludwangu. ");
INSERT INTO nde_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Izikhwebu lezo ezazicakile zaginya lezo eziyisikhombisa ezaziphilile, zigcwele. UFaro wasephaphama, kwakuliphupho nje. ");
INSERT INTO nde_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ekuseni umoya wakhe wawukhathazekile, ngakho wasesithi kakubizwe bonke abemilingo lezazi zaseGibhithe. UFaro wabatshela amaphupho akhe, kodwa akakho loyedwa owakwaziyo ukuwachasisa. ");
INSERT INTO nde_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Umphathinkezo omkhulu wathi kuFaro, “Lamuhla sengikhumbula amaphutha ami. ");
INSERT INTO nde_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","UFaro wake wazondela izinceku zakhe, wangivalela mina kanye lomphekizinkwa omkhulu endlini yendunankulu yabalindi. ");
INSERT INTO nde_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ngamunye wethu waba lephupho ngobusuku bunye, iphupho linye ngalinye lalilengcazelo yalo lodwa. ");
INSERT INTO nde_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Kwakulejaha lomHebheru khonapho, lathi liyinceku yendunankulu yabalindi. Salitshela amaphupho ethu, lasichasisela wona, lisipha ngulowo ingcazelo yephupho lakhe. ");
INSERT INTO nde_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Izinto zaba njengokusichazela kwakhe: ngabuyiselwa esikhundleni sami, lomkhula wami walengiswa.” ");
INSERT INTO nde_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ngakho uFaro wabiza uJosefa, walethwa masinyane esuka entolongweni. Kwathi esephucile indevu, wantshintsha izigqoko weza phambi kukaFaro. ");
INSERT INTO nde_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","UFaro wathi kuJosefa, “Ngiphuphe iphupho, kodwa kakho ongangichasisela lona. Kodwa ngizwa kuthiwa wena, nxa ungalizwa iphupho uyalichasisa.” ");
INSERT INTO nde_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","UJosefa wamphendula uFaro wathi, “Ngeke ngikwenze, kodwa uNkulunkulu uzamnika uFaro impendulo ayidingayo.” ");
INSERT INTO nde_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","UFaro wasesithi kuJosefa, “Ephutsheni lami bengimi okhunjini lukaNayili, ");
INSERT INTO nde_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ngasengibona kuqhamuka amankomokazi ayisikhombisa, anonileyo, egcwele, esidla phakathi kwemihlanga. ");
INSERT INTO nde_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ngemva kwawo kwaqhamuka amanye amankomokazi ayisikhombisa, etshwabhene, emabi kakhulu futhi ecakile. Ngangingakaze ngibone amankomokazi amabi kangako kulolonke elaseGibhithe. ");
INSERT INTO nde_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Lawo mankomokazi acakileyo, amabi adla lawana amankomokazi ayisikhombisa ayenonile ayiwo aqhamuka kuqala. ");
INSERT INTO nde_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Kodwa loba esewadlile lawo kakho owayengatsho ukuthi atheni; ayelokhu emabi njengakuqala. Ngasengiphaphama. ");
INSERT INTO nde_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ephutsheni lami ngibone njalo izikhwebu zamabele eziyisikhombisa, zigcwele, njalo zizinhle zikhula ehlangeni linye. ");
INSERT INTO nde_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ngemva kwazo, kwahluma ezinye izikhwebu eziyisikhombisa, zibunile njalo zicakile, zihangulwe ludwangu. ");
INSERT INTO nde_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Lezozikhwebu zamabele ezicakileyo zaginya leziyana eziyisikhombisa ezinhle. Ngibatshelile abamasalamusi ngalokhu, kodwa kakho okwazileyo ukungichasisela.” ");
INSERT INTO nde_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","UJosefa wasesithi kuFaro, “Amaphupho kaFaro ayilutho lunye. UNkulunkulu usevezile kuFaro lokho asezakwenza. ");
INSERT INTO nde_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Amankomokazi ayisikhombisa amahle ayiminyaka eyisikhombisa, njalo lezikhwebu zamabele ezinhle ziyiminyaka eyisikhombisa; kuliphupho linye. ");
INSERT INTO nde_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Amankomokazi ayisikhombisa eza muva yiminyaka eyisikhombisa, kanjalo lezikhwebu eziyisikhombisa ezazingelamsebenzi, zitshaywe ludwangu: Yiminyaka eyisikhombisa yendlala. ");
INSERT INTO nde_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Kunjengokuba ngitshilo kuFaro. UNkulunkulu usevezile kuFaro lokho azakwenza. ");
INSERT INTO nde_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Sekusiza iminyaka eyisikhombisa eyenala enkulu kulolonke elaseGibhithe, ");
INSERT INTO nde_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","kodwa izalandelwa yiminyaka eyisikhombisa yendlala. Kuzakuthi yonke inala enkulu eGibhithe ikhohlakale, ngoba indlala izalibhubhisa ilizwe. ");
INSERT INTO nde_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Inala elizweni izabe ingasakhunjulwa, ngoba indlala eyilandelayo izabe inkulu kakhulu. ");
INSERT INTO nde_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Isizatho sokuthi iphupho liphiwe uFaro ngezindlela ezimbili yikuthi, indaba isimiswe yaqiniswa nguNkulunkulu, njalo uNkulunkulu uzakukwenza masinyane. ");
INSERT INTO nde_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Khathesi-ke uFaro kadinge indoda elombono njalo ehlakaniphileyo ayibeke phezu kwelizwe laseGibhithe. ");
INSERT INTO nde_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","UFaro abesekhetha abalisa elizweni abazathatha ingxenye eyodwa kwezinhlanu yesivuno saseGibhithe ngeminyaka yenala eyisikhombisa. ");
INSERT INTO nde_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Kumele baqoqe konke ukudla ngale iminyaka emihle ezayo bakugcine ukudla ngaphansi kukaFaro, kugcinwe emadolobheni ukuthi kube yikudla. ");
INSERT INTO nde_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ukudla lokhu kakugcinelwe ilizwe kulondolozelwe ukusetshenziswa ngeminyaka eyisikhombisa yendlala ezafika eGibhithe, ukwenzela ukuthi ilizwe lingabhujiswa yindlala.” ");
INSERT INTO nde_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Icebo leli lakhanya lilihle kuFaro lakuzo zonke izikhulu zakhe. ");
INSERT INTO nde_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","UFaro wasezibuza wathi, “Kambe singamfumana yini omunye onjengendoda le, umuntu olomoya kaNkulunkulu?” ");
INSERT INTO nde_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","UFaro wasesithi kuJosefa, “Njengoba uNkulunkulu esekwazisile konke lokhu, kakho olombono onje lohlakaniphileyo njengawe. ");
INSERT INTO nde_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Wena-ke usuzaphatha isigodlo sami, kuthi bonke abantu bami bazalalela iziqondiso zakho. Mina ngizakuba mkhulu kulawe ngesikhundla sesihlalo sobukhosi sami kuphela.” ");
INSERT INTO nde_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ngakho uFaro wasesithi kuJosefa, “Sengikubeka ukuthi wena uliphathe lonke ilizwe laseGibhithe.” ");
INSERT INTO nde_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","UFaro wasethatha indandatho yophawu lwakhe eyayisemunweni wakhe wayifaka emunweni kaJosefa. Wamgqokisa izembatho zelineni elihle wamgqizisa iketane yegolide entanyeni. ");
INSERT INTO nde_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Kwathiwa usezahamba ngenqola yempi njengoba esenguye umsekeli wakhe oseduze, kwathi edlula abantu bamemeza bathi, “Vulani indlela!” Wambeka-ke ukuthi aphathe ilizwe lonke laseGibhithe. ");
INSERT INTO nde_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","UFaro wasesithi kuJosefa, “Mina nginguFaro, kodwa ngaphandle kwelizwi lakho kakho ozasiphakamisa isandla loba unyawo kulolonke elaseGibhithe.” ");
INSERT INTO nde_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","UFaro wetha uJosefa ibizo elithi Zafenathi-Phaneya, wasemupha u-Asenathi indodakazi kaPhothifera, umphristi wase-Oni ukuba abe ngumkakhe. UJosefa walibhoda lonke ilizwe laseGibhithe. ");
INSERT INTO nde_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","UJosefa wayeleminyaka engamatshumi amathathu yokuzalwa eqalisa ukusebenzela uFaro inkosi yaseGibhithe. UJosefa wasuka phambi kukaFaro walibhoda lonke ilizwe laseGibhithe. ");
INSERT INTO nde_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ngeminyaka eyisikhombisa yenala umhlaba wathela ukudla okunengi kakhulu. ");
INSERT INTO nde_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","UJosefa wakuqoqa konke ukudla okwavunwa phakathi kwaleyominyaka eyisikhombisa yenala eGibhithe wakulondoloza emadolobheni. Kulelo lalelodolobho wabeka ukudla okwakulinywa emasimini akuleyondawo. ");
INSERT INTO nde_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","UJosefa waqoqa izinqwaba lezinqwaba zamabele, kwaba njengetshebetshebe lolwandle. Kwaba kunengi waze wayekela ukukubhala phansi ngoba kwasekungaphezu kokulinganiswa. ");
INSERT INTO nde_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ingakafiki iminyaka yendlala, u-Asenathi, indodakazi kaPhothifera, umphristi ka-Oni wazalela uJosefa amadodana amabili. ");
INSERT INTO nde_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","UJosefa wetha izibulo lakhe wathi nguManase, esithi, “Kungenxa yokuthi uNkulunkulu wenzile ukuthi ngilukhohlwe lonke uhlupho lwami kanye layo yonke indlu kababa.” ");
INSERT INTO nde_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Indodana yesibili wayibiza ngokuthi ngu-Efrayimi, wathi, “Kungenxa yokuthi uNkulunkulu ungenze ngaba lezithelo elizweni lokuhlupheka kwami.” ");
INSERT INTO nde_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Iminyaka yenala eyisikhombisa eGibhithe yaphela, ");
INSERT INTO nde_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","kwaqalisa iminyaka yendlala eyisikhombisa, njengoba uJosefa wayetshilo. Indlala yaba khona kuwo wonke amanye amazwe, kodwa kulolonke ilizwe laseGibhithe ukudla kwakukhona. ");
INSERT INTO nde_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Kwathi lapho iGibhithe lonke selingenelwa yindlala abantu bazibika kuFaro befuna ukudla. Ngakho uFaro wasebatshela bonke abaseGibhithe wathi, “Yanini kuJosefa lenze lokho alitshela khona.” ");
INSERT INTO nde_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Kwathi indlala isimemetheke kulolonke ilizwe uJosefa wavula iziphala wawathengisela amaGibhithe ukudla ngoba indlala yayisinkulu kakhulu kulolonke ilizwe laseGibhithe. ");
INSERT INTO nde_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Kwathi wonke amanye amazwe eza eGibhithe ezothenga amabele kuJosefa, ngoba indlala yayibhahile kuwo wonke umhlaba. ");
INSERT INTO nde_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Kwathi uJakhobe esezwile ukuthi amabele ayekhona eGibhithe wathi emadodaneni akhe, “Kungani likhangelana nje?” ");
INSERT INTO nde_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Waqhubeka wathi, “Sengizwile ukuthi amabele akhona eGibhithe. Yehlani liye khona liyesithengela wona ukuze siphile singafi.” ");
INSERT INTO nde_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ngakho abanewabo bakaJosefa behla bayathenga amabele eGibhithe. ");
INSERT INTO nde_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Kodwa uJakhobe kamthumanga labanye uBhenjamini, umnawakhe kaJosefa ngoba wesaba ukuthi angaqabuka ewelwa yingozi. ");
INSERT INTO nde_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kungakho amadodana ka-Israyeli ayeludwendwe lunye lalabo ababesiyathenga amabele njengoba indlala yayikhona laselizweni leKhenani. ");
INSERT INTO nde_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ngalesosikhathi uJosefa wayengumbusi welizwe, enguye othengisela abantu bonke amabele. Ngakho abafowabo bakaJosefa bathi befika khona bamkhothamela, bathi mbo ngobuso phansi. ");
INSERT INTO nde_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","UJosefa wonela ukubabona abafowabo, wabazi, kodwa wazitshaya owezizweni, wabakhulumisa ngokubakhahlameza. Wababuza wathi, “Livela ngaphi?” Baphendula bathi, “Sivela elizweni laseKhenani ukuzathenga ukudla.” ");
INSERT INTO nde_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Lanxa uJosefa wabazi abafowabo, bona kabamazanga. ");
INSERT INTO nde_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ngakho wasekhumbula amaphupho akhe ngabo wasesithi kubo, “Lizinhloli! Lilande ukuzabona lapho ilizwe lethu elingavikelekanga khona.” ");
INSERT INTO nde_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Baphendula bathi, “Hatshi, nkosi yethu. Izinceku zakho zize ukuzothenga ukudla. ");
INSERT INTO nde_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Singamadodana endoda yinye sonke. Izinceku zakho zingabantu abaqotho, kazisizo zinhloli.” ");
INSERT INTO nde_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Wathi kubo, “Hatshi! Lize ukuzabona lapho ilizwe lethu elingavikelekanga khona.” ");
INSERT INTO nde_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Kodwa baphendula bathi, “Izinceku zakho zaziyizelamani ezilitshumi lambili, engamadodana endoda yinye, ehlala elizweni laseKhenani. Icinathunjana lisele lobaba, ikanti eyodwa kayisekho.” ");
INSERT INTO nde_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","UJosefa wathi kubo, “Kunjengoba ngilitshelile: Lizinhloli! ");
INSERT INTO nde_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Manje-ke lizahlolwa kanje: Ngifunga uFaro, kaliyikusuka lapha ngaphandle kokuthi umfowenu omncinyane afike lapha. ");
INSERT INTO nde_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Thumani omunye wenu amlande umfowenu; lonke abanye lizagcinwa entolongweni, ukuze amazwi enu ahlolisiswe ukuthi lingabe likhuluma iqiniso yini. Nxa kungenjalo, ngifunga uFaro, lizinhloli!” ");
INSERT INTO nde_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Wasebafaka entolongweni bonke okwensuku ezintathu. ");
INSERT INTO nde_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ngosuku lwesithathu uJosefa wathi kubo, “Yenzani lokhu ukuze lisile, ngoba mina ngesaba uNkulunkulu: ");
INSERT INTO nde_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Nxa lingabantu abaqotho, omunye wenu kahlale lapha entolongweni, kuthi lina abanye libuyele lihambisele izimuli zenu amabele esezibulawa yindlala. ");
INSERT INTO nde_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Kodwa limlethe lapha kimi umnawenu omncane ukuze amazwi enu aqiniseke, njalo ukuze lingafi.” Bakwenza lokho. ");
INSERT INTO nde_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Basebekhulumisana bathi, “Ngempela sijeziselwa umfowethu. Sambona ukuthi wayekhathazeke kangakanani esincenga, ezincengela impilo yakhe, kodwa kasaze samlalela; kungakho sisehlelwa luhlupho lolu.” ");
INSERT INTO nde_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","URubheni waphendula wathi, “Kodwa kangilitshelanga yini ukuthi lingenzi isono emfaneni lina laqinisa amakhanda? Nanku-ke sesimele sifakaze ngegazi lakhe.” ");
INSERT INTO nde_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Babengakunanzeleli ukuthi uJosefa wayeluzwa ulimi lwabo njengoba wayelomtolikelayo. ");
INSERT INTO nde_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Wabafulathela wachiphiza izinyembezi, kodwa waphenduka wakhuluma labo. Wathi kuthathwe uSimiyoni kubo owahle wabotshwa phambi kwabo. ");
INSERT INTO nde_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","UJosefa waselaya ukuthi kugcwaliswe amabele emasakeni abo, kubuyiselwe imali yalowo lalowo ifakwe phakathi kwesaka lakhe njalo baphiwe umphako wendlela. Sebekwenzelwe konke lokho, ");
INSERT INTO nde_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","betshata amasaka abo kubobabhemi bahamba. ");
INSERT INTO nde_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Endaweni lapho abema khona ngalobubusuku omunye wabo wavula isaka lakhe ukuthathela ubabhemi wakhe ukudla, wasebona imali yakhe yesiliva emlonyeni wesaka. ");
INSERT INTO nde_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Wathi kubafowabo, “Isiliva sami sibuyiselwe. Nansi lapha phakathi kwesaka lami.” Zatshona inhliziyo zabo bakhangelana bethuthumela bathi, “Kuyini kambe lokhu uNkulunkulu asekwenzile kithi?” ");
INSERT INTO nde_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Bathi sebefike kuyise uJakhobe elizweni laseKhenani bamtshela konke lokho okwakwenzakele kubo. Bathi, ");
INSERT INTO nde_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Indoda eyinkosi yelizwe isikhulumise ngokusihalada, yasiphatha kwangathi sizinhloli elizweni. ");
INSERT INTO nde_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Kodwa sathi kuyo, ‘Singamadoda aqotho; kasisizonhloli thina. ");
INSERT INTO nde_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Sasiyizelamani ezilitshumi lambili, amadodana endoda yinye. Omunye sowedlula, kuthi icinathunjana lisele lobaba eKhenani.’ ");
INSERT INTO nde_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ngakho umuntu oyinkosi yalelolizwe wasesithi kithi, ‘Nanku okuzangenza ngazi ukuthi lingabantu abaqotho: Tshiyani omunye umfowenu lapha kimi, lithathe ukudla kwezimuli zenu ezilambayo lihambe. ");
INSERT INTO nde_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Kodwa umnawenu limlethe kimi khona ngizakwazi ukuthi kalisizinhloli, kodwa lingabantu abaqotho. Lapho-ke ngizambuyisela kini umfowenu, lani selingazithengisela phakathi kwelizwe.’ ” ");
INSERT INTO nde_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Bathi sebethulula amasaka abo, babona umxhaka wesiliva waleyo laleyo ndoda esakeni layo! Kwathi bona ngokwabo kanye loyise bebona imixhaka yemali besaba. ");
INSERT INTO nde_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Uyise uJakhobe wathi kubo, “Selingephuce abantwabami. UJosefa kasekho, loSimiyoni kasekho; manje selifuna ukuthatha uBhenjamini. Yonke into iyangihlamukela!” ");
INSERT INTO nde_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","URubheni wasesithi kuyise, “Ungawabulala womabili amadodana ami nxa ngingangambuyisi kuwe. Mnikele ezandleni zami, mina ngizambuyisa.” ");
INSERT INTO nde_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Kodwa uJakhobe wathi, “Indodana yami kayiyikuhamba lani khonale; umnewabo sewafa, usenguye yedwa oseleyo. Nxa evelelwa ngokubi kuloluhambo lwenu lizakwenza ukuthi ikhanda lami eliyimpunga liye engcwabeni lidabukile.” ");
INSERT INTO nde_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Indlala yayilokhu inkulu kakhulu elizweni. ");
INSERT INTO nde_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ngakho kwathi sebekuqedile konke ukudla ababekuthenge eGibhithe, uyise wathi kubo, “Buyelani liyesithengela njalo okunye ukudla okunenganyana.” ");
INSERT INTO nde_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Kodwa uJuda wathi kuye, “Indoda leyo yasiqonqosela yathi, ‘Ngeke liphinde libubone ubuso bami ngaphandle kokuba lilomnawenu.’ ");
INSERT INTO nde_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Nxa uzamvumela umnawethu ukuthi sihambe laye, sizahamba siyekuthengela ukudla. ");
INSERT INTO nde_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Kodwa nxa ungezukuvuma, ngeke sibuyele, ngoba phela indoda leyo yathi kithi, ‘Ngeke liphinde libubone ubuso bami nxa umnawenu lingelaye.’ ” ");
INSERT INTO nde_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","U-Israyeli wabuza wathi, “Likwenzeleni lina ukungehlisela uhlupho lolu ngokuyitshela indoda leyo ukuthi lilomnawenu na?” ");
INSERT INTO nde_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Baphendula bathi, “Leyondoda isibuzisisile ngathi langendlu yangakithi yathi, ‘Uyihlo usaphila na? Lilaye na omunye umfowenu?’ Thina besiphendula imibuzo yayo kuphela. Sasingazi kanjani ukuthi yayizakuthi, ‘Mletheni umnawenu lapha’?” ");
INSERT INTO nde_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","UJuda wasesithi ku-Israyeli uyise, “Wothi umfana ahambe lami, sizahle sisuke nje masinyane, ukwenzela ukuthi thina lawe kanye labantwabethu siphile, singafi. ");
INSERT INTO nde_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Mina ngokwami ngizazinikela ngokuphepha kwakhe; umlandu wonke ngaye awubekwe phezu kwami. Nxa ngingambuyisi kuwe ngimbeke phambi kwakho, ngizakuba lecala kuwe impilo yami yonke. ");
INSERT INTO nde_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Njengoba kunje nje, aluba asizilingananga ngabe sesihambe saphenduka kwaze kwaba kabili.” ");
INSERT INTO nde_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ngakho uyise u-Israyeli wasesithi kubo, “Nxa kumele kube njalo, yenzani lokhu: Fakani emasakeni enu ezinye izinto ezinhle kakhulu eziphuma kulelilizwe lihambe lazo kulowomuntu zibe yisipho, amagcobo okuthambisa loluju, iziyoliso ezithile lemure, izilimo ezicacadwayo zephistakhiyo le-alimondi. ");
INSERT INTO nde_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Thathani isiliva esiphindwe kabili, ngoba kufanele libuyisele lesosiliva esasibuyiselwe emasakeni enu. Mhlawumbe kwaba yisiphosiso. ");
INSERT INTO nde_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Mthatheni umnawenu laye libuyele kuleyondoda ngokuphangisa. ");
INSERT INTO nde_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Sengathi uNkulunkulu uSomandla angalenzela umusa kuleyondoda ukuze ivumele omunye umfowenu kanye loBhenjamini baphenduke lani. Mina ngokwami ngithi, kambe okungayisikufa yikuphi!” ");
INSERT INTO nde_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ngakho amadoda athatha izipho lesiliva esiphindwe kabili kanye loBhenjamini. Batshitsha baya eGibhithe bayazibika kuJosefa. ");
INSERT INTO nde_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Kwathi uJosefa ebona uBhenjamini ekanye labo, wathi encekwini yendlu yakhe, “Hamba lamadoda la endlini yami, uwahlabele isifuyo ulungise ukudla; bazakudla lami emini.” ");
INSERT INTO nde_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Indoda yenza njengokutshelwa kwayo nguJosefa, yawathatha amadoda yahamba lawo endlini kaJosefa. ");
INSERT INTO nde_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Amadoda ethuka ebona elethwa endlini kaJosefa. Bacabanga ukuthi, “Silethwe lapha ngenxa yesiliva esabuyiselwa emasakeni ethu ekufikeni kwethu kwakuqala. Ufuna ukusihlasela asehlule, abesesithumba sibe yizigqili athathe obabhemi bethu.” ");
INSERT INTO nde_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ngakho baya encekwini kaJosefa bayakhuluma laye entubeni eya endlini. ");
INSERT INTO nde_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Bathi, “Ake usizwe, nkosi yethu: Safika lapha kuqala sizothenga ukudla. ");
INSERT INTO nde_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Kodwa lapho esaphumula khona ebusuku savula amasaka ethu, kwaba ngulowo wethu wafumana isiliva sakhe, siphelele ubunzima baso, sisemlonyeni wesaka lakhe. Ngakho size laso. ");
INSERT INTO nde_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Size lesinye isiliva phezu kwaleso ukuthi sithenge ukudla. Kasikwazi ukuthi ngubani owabuyisela isiliva emasakeni ethu.” ");
INSERT INTO nde_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Wathi, “Kulungile. Lingesabi. UNkulunkulu wenu, uNkulunkulu kayihlo, uliphile inotho emasakeni enu; mina ngasiphiwa isiliva senu.” Emva kwalokho waseletha uSimiyoni kubo. ");
INSERT INTO nde_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Inceku yasiwangenisa amadoda endlini kaJosefa, yawapha amanzi okugeza inyawo zawo, yaletha lotshani babobabhemi bawo. ");
INSERT INTO nde_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Balungisa izipho zabo balindela ukufika kukaJosefa emini ngoba basebezwile ukuthi babezakudla khonapho. ");
INSERT INTO nde_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","UJosefa esefikile bethula izipho ababengene lazo endlini, njalo bakhothama kuye phansi. ");
INSERT INTO nde_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Wababuza ukuphila, wasesithi, “Linjani ixhegu elinguyihlo elangitshela ngalo? Lilokhu lisaphila na?” ");
INSERT INTO nde_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Baphendula bathi, “Inceku yakho, ubaba, ulokhu esaphila njalo usaqinile.” Bakhothama njalo betshengisa inhlonipho. ");
INSERT INTO nde_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Wathi elokhu ebakhangela wabona umnawakhe uBhenjamini, umntakanina sibili, wabuza wathi, “Nguye lo umnawenu olicinathunjana na, lowo elangitshela ngaye?” Wasesithi kuye, “UNkulunkulu kabe lomusa kuwe, ndodana yami.” ");
INSERT INTO nde_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Wathinteka kakhulu ngokubona umnawakhe, uJosefa waphangisa waphuma wayafuna indawo yokukhala. Waya ekamelweni lakhe wayakhalela khona. ");
INSERT INTO nde_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Wathi esegezile amehlo waphuma, wazibamba, wasesithi, “Phakululani ukudla.” ");
INSERT INTO nde_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Yena bamupha yedwa, abafowabo labo bodwa, kwathi lamaGibhithe ayesidla laye lawo aba wodwa, ngoba amaGibhithe ayengeke adla lamaHebheru, ngoba lokho kwakunengeka kumaGibhithe. ");
INSERT INTO nde_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Amadoda la ayehlezi ngobudala bawo kuqala ngezibulo kusiyacina ngecinathunjana; bakhangelana bemangele. ");
INSERT INTO nde_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Kwakusithi nxa bephakelwa kusuka etafuleni likaJosefa, isabelo sikaBhenjamini sasisedluliswa kahlanu kwesabanye. Ngakho bazitika banatha laye bekhululekile. ");
INSERT INTO nde_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","UJosefa waselaya inceku yendlu yakhe wathi: “Gcwalisa silikici amasaka amadoda la ngokudla konke abangakuthwala, ubusubuyisela isiliva salowo lalowo emlonyeni wesaka lakhe. ");
INSERT INTO nde_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ubusufaka inkomitsho yami, leyana eyesiliva, emlonyeni wesaka lalowo omncinyane wabo ndawonye lesiliva sakhe samabele.” Yenza njengalokho uJosefa ayekutshilo. ");
INSERT INTO nde_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kwathi emadabukakusa bawavalelisa amadoda asuka kanye labobabhemi bawo. ");
INSERT INTO nde_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ayengakahambi okuya ngaphi ukusuka edolobheni lapho uJosefa athi encekwini yakhe, “Axhume ngokuphangisa amadoda lawana, ungawafica uthi kuwo, ‘Lenzeleni ukuphindisela okuhle ngokubi na? ");
INSERT INTO nde_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Le kakusinkomitsho enatha ngenkosi yami njalo ehlahlula ngayo na? Le yinto embi kakhulu eseliyenzile!’ ” ");
INSERT INTO nde_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Wathi esebaficile wawatsho amazwi la kubo. ");
INSERT INTO nde_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Kodwa bathi kuye, “Kungani inkosi yethu isitsho izinto ezinjalo? Kakube kude lezinceku zakho ukwenza ulutho olunjalo! ");
INSERT INTO nde_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Phela siyibuyisile kuwe isiliva sisuka laso elizweni laseKhenani, lesiyana esasifumana phakathi emilonyeni yamasaka ethu. Pho besingakwenza njani ukweba isiliva loba igolide endlini yenkosi yakho na? ");
INSERT INTO nde_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Nxa omunye wezinceku zakho efunyanwa elayo, uzabulawa; kuthi thina abanye sibe yizigqili zenkosi yethu.” ");
INSERT INTO nde_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Wathi, “Kulungile, kakube njengokutsho kwenu. Lowo ozafunyanwa elayo uzakuba yisigqili sami, lina abanye lonke kalizukuba lecala.” ");
INSERT INTO nde_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ngulowo lalowo wabo wethula isaka lakhe walivula. ");
INSERT INTO nde_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Inceku yasihamba ihlola, yaqala ngomdala yayacina ngomcinyane. Inkomitsho yayafunyanwa esakeni likaBhenjamini. ");
INSERT INTO nde_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Bekubona lokhu badabula izigqoko zabo. Emva kwalokho bonke betshatisa obabhemi babo amasaka baphindela edolobheni. ");
INSERT INTO nde_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","UJosefa wayelokhu esendlini lapho uJuda labafowabo abafika khona bazilahla phansi phambi kwakhe. ");
INSERT INTO nde_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","UJosefa wathi kubo, “Kuyini lokhu elikwenzileyo? Kalazi na ukuthi umuntu onjengami ubona izinto ngokuhlahlula?” ");
INSERT INTO nde_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","UJuda waphendula wathi, “Kambe singabe sisathini? Singakuveza kanjani ukuba msulwa kwethu? UNkulunkulu usembule icala lezinceku zakho. Manje sesiyizichaka zenkosi yami, thina ngokwethu lalowo ofunyenwe elayo inkomitsho.” ");
INSERT INTO nde_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Kodwa uJosefa wathi. “Kakube kude lami ukwenza into enjalo! Yileyo indoda kuphela efunyanwe ilayo inkomitsho ezakuba yisichaka sami. Abanye lonke buyelani kuyihlo ngokuthula.” ");
INSERT INTO nde_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","UJuda wasesondela kuye wathi, “Oh, nkosi yami, akuvumele inceku yakho itsho ilizwi enkosini yami. Ungayizondeli inceku yakho, loba wena ulingana loFaro ngokwakhe. ");
INSERT INTO nde_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Inkosi yami yabuza izinceku zayo yathi, ‘Lilaye na uyihlo kumbe umfowenu?’ ");
INSERT INTO nde_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Thina saphendula sathi, ‘Silaye ubaba oseluphele, njalo ikhona indodana ayizala eseluphele. Umnewabo wafa, njalo yiyo yodwa eseleyo emadodaneni kanina, ngakho uyise uyayithanda.’ ");
INSERT INTO nde_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Wena wasusithi ezincekwini zakho, ‘Mletheni kimi ukuze ngimbone mina ngokwami.’ ");
INSERT INTO nde_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Thina sathi enkosini yami, ‘Umfana ngeke asuka kuyise; nxa esuka kuye, uyise uzakufa.’ ");
INSERT INTO nde_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Kodwa izinceku zakho wazitshela wathi, ‘Ngaphandle kokuba umnawenu omncane lize laye, ngeke liphinde libubone njalo ubuso bami.’ ");
INSERT INTO nde_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Sathi ukubuyela encekwini yakho ubaba, samtshela lokho okwakutshiwo yinkosi yami. ");
INSERT INTO nde_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ubaba wasesithi, ‘Buyelani liyethenga okunye njalo ukudla.’ ");
INSERT INTO nde_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Kodwa thina sathi, ‘Ngeke siye khona. Kuphela nxa umnawethu omncane elathi, singahamba. Ngeke sibubone ubuso bendoda leyo ngaphandle kokuba umnawethu omncane silaye.’ ");
INSERT INTO nde_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Inceku yakho ubaba yathi kithi, ‘Liyakwazi ukuthi umkami wangizalela amadodana amabili. ");
INSERT INTO nde_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Omunye wabo wasuka kimi, ngathi, “Ngempela udlithiziwe waba yizicucu.” Ngakho kangisaphindanga ngambona kusukela khonapho. ");
INSERT INTO nde_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Manje lingangithathela lalo futhi abesesehlelwa ngokubi, lizakwehlisela ikhanda lami eliyimpunga engcwabeni ngidabukile kakhulu.’ ");
INSERT INTO nde_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Ngakho-ke, nxa umfana singelaye lapho sengibuyela encekwini yakho ubaba, yena ompilo yakhe isondelelene kakhulu leyomfana lo, ");
INSERT INTO nde_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","uzakuthi angabona umfana engekho, ahle afe. Thina zinceku zakho sizakusa ikhanda likababa eliyimpunga engcwabeni lihlulukelwe. ");
INSERT INTO nde_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Inceku yakho yanikela ukuphila kwayo ngokuphepha komfana kubaba. Ngathi, ‘Nxa ngingambuyisi kuwe, ngizawuthwala lowomlandu kuwe, baba, impilo yami yonke!’ ");
INSERT INTO nde_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ngakho-ke ngiyacela ukuthi uvumele inceku yakho isale lapha njengesichaka senkosi yami esikhundleni somfana, yena umfana akhululwe ahambe labanewabo. ");
INSERT INTO nde_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ngingabuyela ngithini kubaba umfana ngingelaye? Hatshi! Ungangenzi ngibone usizi olungamehlela ubaba.” ");
INSERT INTO nde_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","UJosefa wehluleka ukuzibamba phambi kwazo zonke izinceku zakhe, wasememeza wathi, “Sukani lonke lapha kimi!” Ngakho kakho owayekhona loJosefa lapho eziveza kubafowabo. ");
INSERT INTO nde_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Wakhala kakhulu ephumisela amaGibhithe amuzwa, labendlu kaFaro bezwa ngalokho. ");
INSERT INTO nde_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","UJosefa wathi kubafowabo, “Mina nginguJosefa! Kambe ubaba usaphila na?” Kodwa abafowabo behluleka ukumphendula ngoba besaba kakhulu bephambi kwakhe. ");
INSERT INTO nde_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","UJosefa wasesithi kubafowabo, “Sondelani kimi.” Bathi sebekwenzile lokho wathi, “Ngingumfowenu uJosefa, yena lowo elamthengisela eGibhithe! ");
INSERT INTO nde_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Kodwa manje lingakhathazeki njalo lingaze lazisola ngenxa yokungithengisa lapha, ngoba kwakuyikusiza imiphefumulo ukuba uNkulunkulu angithume phambi kwenu. ");
INSERT INTO nde_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Sekube yiminyaka emibili manje indlala ikhona elizweni, njalo okweminyaka emihlanu ezayo kakuyikulinywa loba ukuvuna. ");
INSERT INTO nde_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Kodwa uNkulunkulu wangithuma phambi kwenu ukuba alilondolozele insalela emhlabeni njalo aphephise impilo zenu ngokukhulula okukhulu. ");
INSERT INTO nde_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ngakho-ke, kwakungayisini elangithuma lapha, kodwa nguNkulunkulu. Wangenza ngaba ngubaba kuFaro, lenkosi yomuzi wakhe wonke kanye lombusi weGibhithe lonke. ");
INSERT INTO nde_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Manje, phangisani liye kubaba lithi kuye, ‘Nanku indodana yakho uJosefa akutshoyo: UNkulunkulu usengenze ngaba yinkosi yalo lonke elaseGibhithe. Yehla uze kimi; ungaphuzi. ");
INSERT INTO nde_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Uzahlala esigodini saseGosheni ube seduze lami, wena labantwabakho, labazukulu bakho; lemihlambi yakho yezimvu leyenkomo lakho konke olakho. ");
INSERT INTO nde_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ngizakunakekela ukhonapho ngoba kuseza eminye iminyaka emihlanu yendlala. Kungenjalo wena lomuzi wakho, labo bonke abangabakho lizahawukelwa.’ ");
INSERT INTO nde_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Liyazibonela ngokwenu, njengoba lomnawami uBhenjamini ebona, ukuthi yimi mina ngeqiniso engikhuluma lani. ");
INSERT INTO nde_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Limtshele ubaba ngalo lonke udumo engiluphiwayo eGibhithe langakho konke elikubonileyo. Ubaba limlethe ngokuphangisa lapha.” ");
INSERT INTO nde_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Wasegona umnawakhe uBhenjamini, wakhala, loBhenjamini wamanga ekhala. ");
INSERT INTO nde_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Njalo wabanga bonke abafowabo ekhala kulowo lalowo. Ngemva kwalokho abafowabo baxoxa laye. ");
INSERT INTO nde_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Kwathi ukuba izindaba zifike esigodlweni sikaFaro ukuthi abafowabo bakaJosefa babefikile, uFaro lezikhulu zakhe bathokoza. ");
INSERT INTO nde_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","UFaro wathi, kuJosefa, “Tshela abafowenu uthi, ‘Yenzani lokhu: Thwalisani izinyamazana zenu libuyele elizweni laseKhenani, ");
INSERT INTO nde_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","beselibuya loyihlo kanye lemizi yenu kimi. Ngizalipha umhlaba omuhle kakhulu lapha eGibhithe, likholise amanono elizwe.’ ");
INSERT INTO nde_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Uyalaywa njalo ukuthi ubatshele uthi, ‘Yenzani lokhu: Thathani izinqola ezithile lapha eGibhithe lisenzela abantwabenu, labomkenu, lithathe uyihlo lize laye. ");
INSERT INTO nde_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Lingazihluphi ngempahla zenu ngoba okuhle konke kwaseGibhithe kuzakuba ngokwenu.’ ” ");
INSERT INTO nde_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ngakho amadodana ka-Israyeli akwenza lokhu. UJosefa wabapha izinqola, njengokulaya kukaFaro, wabuye wabapha umphako wendlela. ");
INSERT INTO nde_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ngulowo lalowo wamupha izigqoko ezintsha, kodwa uBhenjamini wamupha amashekeli esiliva angamakhulu amathathu kanye lezigqoko ezinhlanu. ");
INSERT INTO nde_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Njalo nanku akuphathisela uyise: obabhemi abalitshumi bethwele konke okuhle kwaseGibhithe, labobabhemi abasikazi abalitshumi bebhensiswa ngamabele lesinkwa lokunye okomphako wakhe wendlela. ");
INSERT INTO nde_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Wasevalelisa abafowabo, bathi sebesuka wathi kubo, “Lingaxabani endleleni!” ");
INSERT INTO nde_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ngakho basuka baphuma eGibhithe bayafika kuyise uJakhobe elizweni laseKhenani. ");
INSERT INTO nde_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Bamtshela bathi, “UJosefa ulokhu ephila! Isibili ungumbusi walo lonke elaseGibhithe.” UJakhobe waphela amandla; kazange abakholwe. ");
INSERT INTO nde_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Kodwa kwathi lapho sebemtshelile konke uJosefa ayekutshilo kubo, njalo esebone izinqola uJosefa ayethe zizomthwala zimlethe, umoya kayise, uJakhobe wavuseleleka. ");
INSERT INTO nde_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","U-Israyeli wathi, “Sengisuthisekile! Indodana yami uJosefa isaphila. Ngizahamba ngiyeyibona ngingakafi.” ");
INSERT INTO nde_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ngakho u-Israyeli wasesuka kanye lakho konke okwakungokwakhe, wathi ngokufika eBherishebha wenza umhlatshelo kuNkulunkulu kayise u-Isaka. ");
INSERT INTO nde_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","UNkulunkulu wakhuluma ku-Israyeli ngombono ebusuku wathi, “Jakhobe! Jakhobe!” Waphendula wathi, “Ngilapha.” ");
INSERT INTO nde_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Wathi, “NginguNkulunkulu, uNkulunkulu kayihlo. Ungesabi ukwehlela eGibhithe, ngoba ngizakwenza ube yisizwe esikhulu khonale. ");
INSERT INTO nde_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mina ngizahamba lawe khonale eGibhithe, njalo ngiqinisile, ngizaphinde ngikubuyise. Isandla sikaJosefa ngokwaso sizakugoqa.” ");
INSERT INTO nde_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","UJakhobe wasesuka eBherishebha, kwathi amadodana ka-Israyeli amthatha uyise uJakhobe, labantwababo kanye labomkabo babafaka ezinqoleni uFaro ayezithumele ukubathwala ngazo. ");
INSERT INTO nde_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Bathatha njalo lezifuyo zabo kanye layo yonke impahla yabo ababeyiqoqile eKhenani, uJakhobe losendo lwakhe lonke baya eGibhithe. ");
INSERT INTO nde_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Wathatha amadodana akhe, labazukulu bakhe, lamadodakazi akhe lamadodakazi awo, sonke isizukulwane sakhe, waya eGibhithe. ");
INSERT INTO nde_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","La ngamabizo amadodana ka-Israyeli (uJakhobe labazukulu bakhe) abahambayo eGibhithe: uRubheni izibulo likaJakhobe. ");
INSERT INTO nde_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Amadodana kaRubheni ayeyila: uHanokhi, uPhalu, uHezironi, kanye loKhami. ");
INSERT INTO nde_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Amadodana kaSimiyoni ayeyila: uJemuyeli, uJamini, u-Ohadi, uJakhini, uZohari kanye loShawuli indodana yomfazi ongumKhenani. ");
INSERT INTO nde_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Amadodana kaLevi ayeyila: uGeshoni, uKhohathi kanye loMerari. ");
INSERT INTO nde_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Amadodana kaJuda ayeyila: u-Eri, u-Onani, uShela, uPherezi kanye loZera (kodwa u-Eri lo-Onani babefele elizweni laseKhenani). Amadodana kaPherezi ayeyila: uHezironi loHamuli. ");
INSERT INTO nde_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Amadodana ka-Isakhari ayeyila: uThola, uPhuwa, uJashubi kanye loShimroni. ");
INSERT INTO nde_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Amadodana kaZebhuluni ayeyila: uSeredi, u-Eloni kanye loJahileli. ");
INSERT INTO nde_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","La ayengamadodana uLeya awazalela uJakhobe ePhadani Aramu, ngaphandle kwendodakazi yakhe uDina. Amadodana la lamadodakazi akhe babengamatshumi amathathu sebebonke. ");
INSERT INTO nde_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Amadodana kaGadi ayeyila: uZifiyoni, uHagi, uShuni, u-Ezibhoni, u-Eri, u-Arodi kanye lo-Areli. ");
INSERT INTO nde_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Amadodana ka-Asheri ayeyila: u-Imna, u-Ishiva, u-Ishivi loBheriya. Udadewabo wayenguSera. Amadodana kaBheriya ayeyila: uHebheri loMalikhiyeli. ");
INSERT INTO nde_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Laba ngabantwana abazalelwa uJakhobe nguZilipha, uLabhani ayemuphe indodakazi yakhe uLeya, belitshumi lesithupha sebebonke. ");
INSERT INTO nde_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Amadodana omkaJakhobe uRasheli ayeyila: uJosefa loBhenjamini. ");
INSERT INTO nde_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","EGibhithe uJosefa wazala uManase lo-Efrayimi ku-Asenathi indodakazi kaPhothifera, umphristi ka-Oni. ");
INSERT INTO nde_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Amadodana kaBhenjamini ayeyila: uBhela, uBhekheri, u-Ashibheli, uGera, uNamani, u-Ehi, uRoshi, uMuphimu, uHuphimu kanye lo-Adi. ");
INSERT INTO nde_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","La ayengamadodana kaRasheli awazalela uJakhobe, elitshumi lane esewonke. ");
INSERT INTO nde_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Indodana kaDani: yayinguHushimu. ");
INSERT INTO nde_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Amadodana kaNafithali ayeyila: uJaziyeli, uGuni, uJezeri kanye loShilemu. ");
INSERT INTO nde_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","La ayengamadodana kaJakhobe awazala loBhiliha, uLabhani ayemuphe indodakazi yakhe uRasheli, beyisikhombisa bebonke. ");
INSERT INTO nde_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Bonke labo abaya eGibhithe loJakhobe, ababeyinzalo yegazi lakhe, kungabalwa omalukazana bakhe, kwakungabantu abangamatshumi ayisithupha lesithupha. ");
INSERT INTO nde_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Sekubalwa lamadodana amabili azalwa nguJosefa eGibhithe, abendlu kaJakhobe abaya eGibhithe babengamatshumi ayisikhombisa sebebonke. ");
INSERT INTO nde_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","UJakhobe wasethuma uJuda phambi kwakhe kuJosefa ukuba amlayele indlela eya eGosheni. Bathi sebefikile emangweni waseGosheni, ");
INSERT INTO nde_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","uJosefa walungiselwa inqola yakhe waqonda eGosheni ukuyahlangana loyise u-Israyeli. UJosefa wonela ukumbona nje, wamgona uyise, wakhala okwesikhathi eside. ");
INSERT INTO nde_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","U-Israyeli wathi kuJosefa, “Manje sengikulungele ukufa, ngoba sengizibonele mina ngokwami ukuthi usaphila.” ");
INSERT INTO nde_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","UJosefa wasesithi kubafowabo lakubo bonke abomuzi kayise, “Ngizahamba ngiyekhuluma loFaro ngithi kuye, ‘Abafowethu kanye labendlu kababa ababehlala elizweni laseKhenani sebebuyile kimi. ");
INSERT INTO nde_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Amadoda la angabelusi; belusa izifuyo, ngakho beze lemihlambi yabo yezimvu leyenkomo lakho konke abalakho.’ ");
INSERT INTO nde_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Nxa uFaro angalibiza alibuze athi, ‘Umsebenzi wenu ngowani?’ ");
INSERT INTO nde_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","libophendula lithi, ‘Izinceku zakho zingabelusi bezifuyo kusukela ebutsheni bethu kuze kube khathesi, njengabokhokho bethu.’ Lapho-ke lizavunyelwa ukwakha emangweni waseGosheni, ngoba bonke abelusi bayeyiseka kumaGibhithe.” ");
INSERT INTO nde_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","UJosefa wahamba wayatshela uFaro wathi, “Ubaba labafowethu, kanye lemihlambi yabo yezimvu lenkomo, kanye lakho konke abalakho sebefikile bevela elizweni laseKhenani, okwamanje sebeseGosheni.” ");
INSERT INTO nde_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Wakhetha abafowabo abahlanu wabethula kuFaro. ");
INSERT INTO nde_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","UFaro wababuza abafowabo laba wathi, “Umsebenzi wenu ngowani na?” Baphendula uFaro bathi, “Izinceku zakho zingabelusi, njengalokho ababeyikho okhokho bethu.” ");
INSERT INTO nde_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Babuya bathi kuye, “Size ukuzohlala lapha okwesikhathi esithile, ngoba indlala inkulu kakhulu eKhenani, njalo lemihlambi yezinceku zakho kayilamadlelo. Manje-ke sicela ukuthi uvumele izinceku zakho zakhe eGosheni.” ");
INSERT INTO nde_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","UFaro wathi kuJosefa, “Uyihlo labafowenu beze kuwe, ");
INSERT INTO nde_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","lelizwe laseGibhithe uyalibona; hlalisa uyihlo labafowenu endaweni enhle kakhulu yelizwe. Wothi bahlale eGosheni. Njalo nxa bekhona abanye babo abalolwazi oluqakathekileyo, kabakhangele imihlambi yami.” ");
INSERT INTO nde_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ngakho uJosefa waseletha uyise uJakhobe wamethula kuFaro. UJakhobe esembusisile uFaro, ");
INSERT INTO nde_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","uFaro wambuza wathi, “Usumdala kangakanani na?” ");
INSERT INTO nde_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","UJakhobe wathi kuFaro, “Iminyaka yokuhamba kwami ilikhulu lamatshumi amathathu. Iminyaka yami ibimilutshwana njalo ibinzima, njalo kayifiki iminyaka yokuhamba kwabokhokho bami.” ");
INSERT INTO nde_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","UJakhobe wasembusisa uFaro, uFaro wasesuka kuye. ");
INSERT INTO nde_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ngakho uJosefa wasehlalisa uyise labafowabo eGibhithe, wabapha indawo enhle kulazo zonke elizweni, esiqintini saseRamesesi, njengokulaya kukaFaro. ");
INSERT INTO nde_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","UJosefa waphinda wapha uyise labafowabo kanye lendlu yonke kayise ukudla, kusiya ngobunengi babantwababo. ");
INSERT INTO nde_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Kwakungelakudla elizweni lonke ngoba indlala yayibhahile; iGibhithe leKhenani womabili amazwe esevuthuzekile ngenxa yendlala. ");
INSERT INTO nde_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","UJosefa wayiqoqa yonke imali eyayitholakala eGibhithe laseKhenani eyayingeyokuthenga amabele, wayiletha esigodlweni sikaFaro. ");
INSERT INTO nde_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Kwathi imali yabantu baseGibhithe labaseKhenani isiphelile, abaseGibhithe bonke beza kuJosefa bathi, “Siphe ukudla. Singafelani kambe phambi kwamehlo akho? Imali yethu isiphelile.” ");
INSERT INTO nde_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","UJosefa wathi, “Lethani izifuyo zenu. Ngizalithengisela ukudla libhadale ngezifuyo zenu, njengoba imali yenu isiphelile.” ");
INSERT INTO nde_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ngakho basebeletha izifuyo zabo kuJosefa, wabapha ukudla bebhadala ngamabhiza abo, lezimvu kanye lembuzi zabo, lenkomo kanye labobabhemi babo. Wabaphutshisa lowomnyaka ngokudla bekubhadala ngezifuyo zabo. ");
INSERT INTO nde_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Lowomnyaka usuphelile, beza kuye ngomnyaka olandelayo bathi, “Ngeke sayifihlela inkosi yethu ukuthi njengoba imali yethu isiphelile, ikanti lezifuyo zethu ngezakho, kakusekho okusayisalele inkosi yethu ngaphandle kwemizimba yethu leziqinti zethu kuphela. ");
INSERT INTO nde_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Kambe sesingaze sife nje usikhangele, thina kanye lelizwe lethu lalo? Sithenge kanye lelizwe lethu usiphe ukudla, kuzakuthi thina kanye lelizwe lethu sibe sebugqilini kuFaro. Siphe inhlanyelo ukuze siphile, singafi, njalo ukuze ilizwe lingabi yinkangala.” ");
INSERT INTO nde_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ngakho-ke uJosefa waselithengela uFaro lonke ilizwe laseGibhithe. AmaGibhithe wonke athengisa amasimu awo ngoba indlala yayisiwabhahele okubi. Ilizwe laselisiba ngelikaFaro, ");
INSERT INTO nde_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","uJosefa wasebagqilaza abantu, kusukela ngapha kwelizwe laseGibhithe kusiya ngale kwalo. ");
INSERT INTO nde_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Kodwa kayithenganga indawo yabaphristi, ngoba babephiwa isabelo nguFaro, yikho babelakho ukudla okwaneleyo kusuka kuFaro. Yikho bengawuthengisanga owabo umhlaba. ");
INSERT INTO nde_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","UJosefa wathi ebantwini, “Njengoba sengilithengile lina lomhlaba wenu lamuhla ukuba libe ngabakaFaro, nansi inhlanyelo ukuze lihlanyele emhlabathini. ");
INSERT INTO nde_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Kodwa nxa amabele eseqoqwa phanini okobuhlanu bawo kuFaro. Ezinye izingxenye ezine kwezinhlanu lizigcinele inhlanyelo yamasimu njalo kube yikudla kwenu, lemizi yenu kanye labantwabenu.” ");
INSERT INTO nde_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Bathi, “Uzisindisile impilo zethu. Sengathi singathola umusa enkosini yethu; sizakuba yizigqili kuFaro.” ");
INSERT INTO nde_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Kunjalo uJosefa wakumisa kwaba ngumthetho eGibhithe mayelana lomhlaba, okulokhu kulandelwa lalamuhla, ukuthi ingxenye eyodwa kokuhlanu ngekaFaro. Kwakungumhlaba wabaphristi kuphela ongazange ube ngokaFaro. ");
INSERT INTO nde_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ngalesosikhathi abako-Israyeli bazinza eGibhithe esigodini saseGosheni. Bazuza izifuyo ezinengi khona njalo bazalana kakhulu banda ngobunengi. ");
INSERT INTO nde_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","UJakhobe wahlala eGibhithe okweminyaka elitshumi lesikhombisa, iminyaka yokuphila kwakhe yaba likhulu lamatshumi amane lesikhombisa. ");
INSERT INTO nde_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Kwathi isikhathi sesisondele ukuba u-Israyeli afe, wabiza indodana yakhe uJosefa wathi kuyo, “Uba ngifumene umusa kuwe, beka isandla sakho ngaphansi kwethangazi lami uthembise ukuthi uzangenzela umusa lokuthembeka. Ungangingcwabi eGibhithe, ");
INSERT INTO nde_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","kodwa nxa sengiphumule labokhokho bami, ungithwale ngisuke eGibhithe uyongimbela lapho abalele khona.” Wathi, “Ngizakwenza njengoba usitsho.” ");
INSERT INTO nde_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Wathi, “Funga kimi.” Ngakho uJosefa wafunga kuye, u-Israyeli wasekhothamela emakhanda ombheda wakhe. ");
INSERT INTO nde_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Emva kwesikhatshana uJosefa wabikelwa ukuthi, “Uyihlo uyagula.” Ngakho wathatha amadodana akhe womabili, uManase lo-Efrayimi wahamba lawo. ");
INSERT INTO nde_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","UJakhobe esetsheliwe kwathiwa, “Indodana yakho uJosefa isifikile kuwe,” u-Israyeli wazibamba ngamandla wavuka embhedeni. ");
INSERT INTO nde_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","UJakhobe wathi kuJosefa, “UNkulunkulu uSomandla wabonakala kimi eLuzi elizweni laseKhenani, khonapho wangibusisa. ");
INSERT INTO nde_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Wathi kimi, ‘Ngizakwenza ube lenzalo enengi kakhulu. Ngizalenza libe yisizwe sabantu, njalo ngizakupha izizukulwane zakho lelilizwe libe yilifa lazo elingapheliyo ngemva kwakho.’ ");
INSERT INTO nde_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Zwana-ke, amadodana akho amabili owawazalela eGibhithe ngingakabuyi lapha kuwe azathathwa njengawami; u-Efrayimi loManase bazakuba ngabami, kanjengoba uRubheni loSimiyoni bengabami. ");
INSERT INTO nde_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Labobantwana abazelwe ngemva kwabo bazakuba ngabakho; kulesosigodi esizakuba yilifa labo bazabhaliswa ngaphansi kwamabizo abanewabo. ");
INSERT INTO nde_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ngathi ngibuya ngivela ePhadani, ngehlelwa lusizi ngafelwa nguRasheli elizweni laseKhenani silokhu sisendleleni, bucwadlana kwe-Efrathi. Ngamngcwaba khonapho eceleni kwendlela eya e-Efrathi” (kutsho eBhethilehema). ");
INSERT INTO nde_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","U-Israyeli wathi ngokubona amadodana kaJosefa wabuza wathi, “Ngobani laba?” ");
INSERT INTO nde_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","UJosefa wathi kuyise, “Ngamadodana uNkulunkulu anginike wona lapha.” U-Israyeli wasesithi, “Balethe kimi ukuze ngibabusise.” ");
INSERT INTO nde_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ngalesosikhathi amehlo ka-Israyeli ayesefiphala ngenxa yokuluphala, engasabonisisi. Ngakho uJosefa wasondeza amadodana akhe kuye, uyise wawanga wawagona. ");
INSERT INTO nde_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","U-Israyeli wathi kuJosefa, “Ngangingathembi ukuthi ngizaphinda ngibubone ubuso bakho njalo, ikanti manje uNkulunkulu usengivumele ukubona labantwabakho labo.” ");
INSERT INTO nde_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","UJosefa wasebasusa emadolweni ka-Israyeli wakhothamela phansi ngobuso. ");
INSERT INTO nde_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","UJosefa wasebathatha bobabili, u-Efrayimi kwesokunene sakhe eqondane lesokhohlo sika-Israyeli, kwathi uManase waba ngakwesokhohlo waqondana lesokunene sika-Israyeli, wabasondeza kuye. ");
INSERT INTO nde_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Kodwa u-Israyeli welula isandla sakhe sokunene wasibeka ekhanda lika-Efrayimi, loba nje yena wayengomncinyane, wasenqumisa izingalo zakhe zaphambana, wabeka isandla sakhe sokhohlo ekhanda likaManase, loba nje uManase wayelizibulo. ");
INSERT INTO nde_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ngakho wasebusisa uJosefa wathi, “Sengathi uNkulunkulu wabokhokho bami, u-Abhrahama lo-Isaka, abahamba phambi kwakhe, uNkulunkulu obengumelusi wami ukuphila kwami konke kuze kube namuhla, ");
INSERT INTO nde_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","iNgilosi engihlengileyo kuzozonke izingozi, sengathi angabusisa abafana laba. Sengathi bangabizwa ngebizo lami langamabizo abobabamkhulu u-Abhrahama lo-Isaka, njalo sengathi banganda kakhulu emhlabeni.” ");
INSERT INTO nde_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Kwathi uJosefa ebona uyise ebeka isandla sakhe sokunene ekhanda lika-Efrayimi akwaze kwamthokozisa; ngakho wasibamba isandla sikayise wasisusa ekhanda lika-Efrayimi ukuthi asibeke kwelikaManase. ");
INSERT INTO nde_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","UJosefa wathi kuye, “Hatshi, baba, lo nguye izibulo; beka isandla sakho sokunene kwelakhe ikhanda.” ");
INSERT INTO nde_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Kodwa uyise wala, wathi, “Ngiyazi, ndodana yami, ngiyazi. Laye njalo uzakuba ngabantu abanengi, njalo laye uzakuba mkhulu. Loba kunjalo, umnawakhe uzakuba mkhulu kulaye lezizukulwane zakhe zizakuba ngamaxuku ezizwe.” ");
INSERT INTO nde_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Wababusisa ngalolusuku wathi, “Ngebizo lakho u-Israyeli uzakutsho lesisibusiso: ‘Sengathi uNkulunkulu angakwenza ube njengo-Efrayimi loManase.’ ” Ngakho wabeka u-Efrayimi phambi kukaManase. ");
INSERT INTO nde_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","U-Israyeli wasesithi kuJosefa, “Sengizakufa, kodwa uNkulunkulu uzakuba lani, alibuyisele elizweni labokhokho benu. ");
INSERT INTO nde_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Wena, njengomuntu olawula abanewenu, ngikunika umqolo welizwe engawemuka ama-Amori ngenkemba yami lomtshoko wami.” ");
INSERT INTO nde_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","UJakhobe wabiza amadodana akhe wathi: “Sondelani eduze ngilitshele lokho okuzakwenzakala kini ensukwini ezizayo. ");
INSERT INTO nde_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Buthanani lilalele, madodana kaJakhobe, lalelani kuyihlo u-Israyeli. ");
INSERT INTO nde_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","URubheni, ulizibulo lami, amandla ami, isibonakaliso sokuqala samandla ami, ukuphelela ngodumo, ukuphelela ngamandla. ");
INSERT INTO nde_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Uhlokoma njengamanzi, kawusayikuba liciko, ngoba wakhwela embhedeni kayihlo, waya phezu kwesihlalo sami wasingcolisa. ");
INSERT INTO nde_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","USimiyoni loLevi bayizelamani inkemba zabo yizikhali zodlakela. ");
INSERT INTO nde_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Mangingangeni enkundleni yabo, mangingangeni emhlanganweni wabo, ngoba bababulala abantu ngokuthukuthela kwabo njalo inkabi baziquma imisipha santando. ");
INSERT INTO nde_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Luqalekisiwe ulaka lwabo, lwesabeka kubi, lentukuthelo yabo, ilesihluku esibi! Ngizakubachithiza kuJakhobe, njalo ngibahlakaze ko-Israyeli. ");
INSERT INTO nde_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Juda, abafowenu bazakudumisa; isandla sakho sizakuba sentanyeni yezitha zakho; amadodana kayihlo azakukhothamela. ");
INSERT INTO nde_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ungumdlwane wesilwane, Oh Juda; uvela ekuzingeleni, ndodana yami. Njengesilwane uyacathama alale phansi, njengesilwanekazi, ngubani olesibindi sokumhlokoza? ");
INSERT INTO nde_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Intonga yobukhosi kayiyikusuka kuJuda, loba umqwayi wombusi phakathi kwezinyawo zakhe, aze ayofika kumnini wayo lokulalela kwezizwe kukuye. ");
INSERT INTO nde_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Uzabophela ubabhemi wakhe evinini, inkonyane kababhemi wakhe ogatsheni oluhle; uzagezisa izembatho zakhe ngewayini, izigqoko zakhe egazini lamagrebisi. ");
INSERT INTO nde_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Amehlo akhe azathuba okudlula iwayini, amazinyo akhe abe mhlophe kulochago. ");
INSERT INTO nde_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","UZebhuluni uzahlala okhunjini lolwandle abe litheku lemikhumbi; umngcele wakhe uzaqhelela eSidoni. ");
INSERT INTO nde_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","U-Isakhari ulithambo likababhemi elilohlonzi olele ephahlwe ngamasaka amabili emithwalo. ");
INSERT INTO nde_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Uthi nxa ebona ubuhle bendawo yakhe yokuphumula lokubukeka kwelizwe lakhe, uzakwehlisa ihlombe lakhe ukuthwala umthwalo azimisele emsebenzini wesigqili. ");
INSERT INTO nde_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","UDani uzakwahlulela kahle abantu bakibo njengesinye sezizwe zako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","UDani uzakuba yinyoka esemgwaqweni, inhlangwana elele endleleni, eluma izithende zebhiza ukuze umgadi walo atshelele aye emuva. ");
INSERT INTO nde_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ngilindele ukuhlenga kwakho, Oh Thixo. ");
INSERT INTO nde_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","UGadi uzahlaselwa liqula lamanxusa, kodwa uzabahlasela bamuphe izithende zabo. ");
INSERT INTO nde_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ukudla kuka-Asheri kuzakuba ngokunonileyo, uzakupha okumnandi okufanele inkosi. ");
INSERT INTO nde_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","UNafithali yimpalakazi ekhululiweyo ezala amazinyane amahle. ");
INSERT INTO nde_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","UJosefa ulivini elithela kakhulu, ivini elithela kakhulu eduze komthombo, elimagatsha alo akhwela emdulini. ");
INSERT INTO nde_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Abahlaseli bemitshoko bamhlasela ngolaka; bamciba ngenzondo embi. ");
INSERT INTO nde_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Kodwa kawalazelanga ngedandili lakhe, ingalo zakhe eziqinileyo zala zilokhu ziqinile ngenxa yesandla soMninimandla kaJakhobe, ngenxa kaMalusi, iDwala lika-Israyeli, ");
INSERT INTO nde_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","ngenxa kaNkulunkulu kayihlo, okusizayo, ngenxa kaSomandla okubusisayo ngezibusiso zasezulwini ngaphezulu, izibusiso zolwandle olungaphansi, izibusiso zebele lenzalo. ");
INSERT INTO nde_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Izibusiso zikayihlo zinkulu kulezibusiso zezintaba zekadeni, kulezithelo zamaqaqa adabuka endulo. Zonke lezi kazehlele ekhanda likaJosefa, ebunzini lenkosana phakathi kwabafowabo. ");
INSERT INTO nde_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","UBhenjamini yimpisi ephangayo; ekuseni uyakudlithiza akujimbileyo, ntambama akwabe.” ");
INSERT INTO nde_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Zonke lezi yizizwana ezilitshumi lambili zako-Israyeli, njalo yikho lokho uyise akutsho kubo lapho wayebabusisa, esipha ilowo lalowo isibusiso esimfaneleyo. ");
INSERT INTO nde_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Emva kwalokho wasebanika imilayo le: “Sekusondele ukuba ngimbelwe ebantwini bakithi. Lingimbele labokhokho ebhalwini ensimini ka-Efroni umHithi, ");
INSERT INTO nde_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ubhalu olusensimini kaMakhaphela, eduze leMamure eKhenani, eyathengwa ngu-Abhrahama kanye lensimu leyo ku-Efroni umHithi, ukuba yindawo yokungcwaba. ");
INSERT INTO nde_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Khonapho kwangcwatshwa u-Abhrahama lomkakhe uSara, kwembelwa u-Isaka lomkakhe uRabheka, njalo khonapho ngambela uLeya. ");
INSERT INTO nde_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Insimu kanye lobhalu oluphakathi kwathengwa kumaHithi.” ");
INSERT INTO nde_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Kwathi uJakhobe eseqedile ukunika imilayezo emadodaneni akhe, wakhweza inyawo zakhe embhedeni, waphefumula okokucina, wasiwa kwabakibo. ");
INSERT INTO nde_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","UJosefa waziphosela phezu kukayise wamkhalela, wasemanga. ");
INSERT INTO nde_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","UJosefa waselaya izinyanga ezazingaphansi kwakhe ukuqhola umzimba kayise u-Israyeli. Ngakho izinyanga zamqhola, ");
INSERT INTO nde_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","zathatha insuku ezingamatshumi amane ezigcweleyo, ngoba kwakuthatha isikhathi esingako ukuqhola. AmaGibhithe amlilela insuku ezingamatshumi ayisikhombisa. ");
INSERT INTO nde_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Insuku zokulila sezedlule, uJosefa wathi kuziphathamandla zikaFaro, “Nxa ngifumane umusa kini, ngikhulumelani kuFaro. Mtsheleni lithi, ");
INSERT INTO nde_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Ubaba wangifungisa isifungo wathi, “Sengizakufa; lingimbele ethuneni engazigebhela lona mina ngokwami elizweni laseKhenani.” Manje-ke ake ungivumele ngihambe ngiyongcwaba ubaba; besengiphenduka.’ ” ");
INSERT INTO nde_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","UFaro wathi, “Hamba uyongcwaba uyihlo, njengoba wakufungisa ukuthi uzakwenza.” ");
INSERT INTO nde_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ngakho uJosefa wahamba wayangcwaba uyise. Zonke izikhulu zikaFaro zamphelekezela, izikhulu zakhe zomphakathi kanye lazozonke izikhulu zaseGibhithe, ");
INSERT INTO nde_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ngaphandle kwabo bonke abendlu kaJosefa labafowabo lalabo ababe ngabendlu kayise. EGosheni kwasala kuphela abantwana lemihlambi yabo yezimvu leyenkomo. ");
INSERT INTO nde_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Wahamba elezinqola zempi labakhweli bamabhiza. Kwakulixuku elikhulu. ");
INSERT INTO nde_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Bathi ngokufika esizeni sika-Athadi eduze kweJodani basiqhinqa isililo esikhulu esibuhlungu; kwathi khonapho uJosefa wazilela uyise okwensuku eziyisikhombisa. ");
INSERT INTO nde_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kwathi amaKhenani ayehlala eduzane ebona ukulila lokho esizeni sika-Athadi athi, “AmaGibhithe alenkonzo yawo yokulila.” Yikho-nje leyondawo eseduze kweJodani ithiwa yi-Abheli-Mizirayimi. ");
INSERT INTO nde_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ngalokho amadodana kaJakhobe enza lokho uyise abalaya khona: ");
INSERT INTO nde_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Bamthwalela elizweni laseKhenani bayamngcwaba ebhalwini olwalusensimini kaMakhaphela, eduze leMamure, u-Abhrahama aluthenga kanye lensimu ku-Efroni umHithi ukuthi kube yindawo yokungcwaba. ");
INSERT INTO nde_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Esemngcwabile uyise uJosefa wabuyela eGibhithe kanye labafowabo labo bonke ababehambe laye ukuyangcwaba uyise. ");
INSERT INTO nde_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Abafowabo bakaJosefa sebebonile ukuthi uyise sefile, bathi, “Kambe uJosefa kasibekelanga isikhwili yini abesefuna ukuphindisela ngakho konke esamona ngakho?” ");
INSERT INTO nde_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ngakho bathumela ilizwi kuJosefa besithi, “Uyihlo watshiya imilayo le engakafi: ");
INSERT INTO nde_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Nanku elimele likutsho kuJosefa: Ngiyakucela ukuthi uxolele abafowenu izono leziphambeko abazenzayo ngokukuphatha kubi kangaka.’ Manje siyacela ukuthi uthethelele izono zezinceku zikaNkulunkulu kayihlo.” Kwathi ilizwi labo selifikile kuye uJosefa wakhala. ");
INSERT INTO nde_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Abafowabo beza bafika bazilahla phansi phambi kwakhe. Bathi, “Siyizigqili zakho.” ");
INSERT INTO nde_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Kodwa uJosefa wathi kubo, “Lingesabi. Mina ngisesikhundleni sikaNkulunkulu na? ");
INSERT INTO nde_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Lalihlose ukungenza okubi, kodwa uNkulunkulu wayehlose ubuhle ngakho ukuze kugcwaliseke lokhu okwenzakalayo khathesi, ukuphephisa impilo ezinengi. ");
INSERT INTO nde_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ngakho-ke, lingesabi. Ngizalinakekela lina labantwabenu.” Wababeka isibindi wabakhulumisa ngomusa. ");
INSERT INTO nde_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","UJosefa wahlala eGibhithe kanye labo bonke abendlu kayise. Waphila okweminyaka elikhulu letshumi, ");
INSERT INTO nde_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","wabona isizukulwane sesithathu sabantwana baka-Efrayimi. Njalo labantwana bakaMakhiri indodana kaManase bathi bezalwa babekwa emadolweni kaJosefa. ");
INSERT INTO nde_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","UJosefa wasesithi kubafowabo, “Sengiseduze lokufa. Kodwa ngempela uNkulunkulu uzalisiza alikhuphe kulelilizwe alise elizweni alithembisa ngesifungo ku-Abhrahama, lo-Isaka loJakhobe.” ");
INSERT INTO nde_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","UJosefa wasefungisa amadodana ka-Israyeli isifungo wathi, “UNkulunkulu uzalisiza, yikho kumele lithwale amathambo ami lisuke lawo kule indawo.” ");
INSERT INTO nde_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","UJosefa wasesifa eseleminyaka yobudala elikhulu letshumi. Bathi sebemqholile, isidumbu sakhe basibeka ebhokisini eGibhithe.");
INSERT INTO nde_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","La ngamabizo amadodana ka-Israyeli aya eGibhithe loJakhobe, munye ngamunye lemuli yakhe: ");
INSERT INTO nde_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","uRubheni, uSimiyoni, uLevi loJuda; ");
INSERT INTO nde_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","u-Isakhari, uZebhuluni loBhenjamini, ");
INSERT INTO nde_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","uDani loNafithali; uGadi lo-Asheri. ");
INSERT INTO nde_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Inzalo yonke kaJakhobe yayingamatshumi ayisikhombisa. UJosefa wayevele eseseGibhithe. ");
INSERT INTO nde_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Kwathi uJosefa labo bonke abafowabo kanye lasosonke lesosizukulwane sebefile, ");
INSERT INTO nde_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","abako-Israyeli bazalana banda kakhulu, okokuthi ilizwe lonke lagcwala ngabo. ");
INSERT INTO nde_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Kwasekusiba lenye inkosi eyayingazi lutho ngoJosefa, yaba ngumbusi eGibhithe. ");
INSERT INTO nde_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Yathi ebantwini bayo, “Khangelani, abantu bako-Israyeli sebebanengi kakhulu kulathi. ");
INSERT INTO nde_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Asiboneni amacebo esingawenza ngabo funa bande kakhulu kuthi lapho kuqhamuka impi, babambane lezitha zethu, balwe lathi, besebesuka elizweni.” ");
INSERT INTO nde_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ngakho babeka izinduna zezigqili ukuthi zibasebenzise kanzima, bakha iPhithomi leRamesesi aba ngamadolobho eziphala zikaFaro. ");
INSERT INTO nde_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Kodwa kwathi ngokuhlutshwa kwabo ngamandla, labo banda kakhulu basabalala; okwenza amaGibhithe abesaba abako-Israyeli ");
INSERT INTO nde_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","asebasebenzisa ngochuku. ");
INSERT INTO nde_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Enza impilo yabo yaba nzima kakhulu betshaya izitina lokuvoxa udaka besenza leminye yonke imisebenzi yemasimini. Kuyo yonke imisebenzi enzima amaGibhithe abasebenzisa ngochuku. ");
INSERT INTO nde_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Inkosi yaseGibhithe yathi kubabelethisi bamaHebheru okwakuthiwa nguShifira loPhuwa, ");
INSERT INTO nde_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Nxa libelethisa abafazi bamaHebheru, lingabona kuzelwe umfana kufanele limbulale; kodwa nxa kuyinkazana, liyiyekele iphile.” ");
INSERT INTO nde_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Kodwa ababelethisi babemesaba uNkulunkulu, ngakho abakwenzanga lokho ababekutshelwe yinkosi yaseGibhithe. ");
INSERT INTO nde_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Sekube njalo, inkosi yaseGibhithe yababiza ababelethisi yathi kubo, “Kungani lenze lokhu? Kungani liyekele abafana baphila?” ");
INSERT INTO nde_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ababelethisi bamphendula uFaro bathi, “Abafazi bamaHebheru abafani labafazi bamaGibhithe; balamandla baphanga babelethe ababelethisi bengakafiki.” ");
INSERT INTO nde_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Ngakho uNkulunkulu waba lomusa kubo ababelethisi, abantu banda baba banengi kakhulu. ");
INSERT INTO nde_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Njalo njengoba ababelethisi bamesaba uNkulunkulu, wabapha ezabo izimuli. ");
INSERT INTO nde_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","UFaro wasesipha abantu bakhe bonke umlayo othi: “Wonke umfana womHebheru ozalwayo kufanele aphoselwe emfuleni uNayili, kodwa wonke amankazana liwayekele aphile.” ");
INSERT INTO nde_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Kwasekusithi eyinye indoda esizweni sakoLevi yathatha owesifazane ongumLevi, ");
INSERT INTO nde_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","wazithwala wabeletha indodana. Wabona ukuthi umntwana wayemuhle kakhulu, wasemfihla okwezinyanga ezintathu. ");
INSERT INTO nde_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Kodwa kwathi lapho sekusehlula ukuthi amfihle, wenza isitsha semizi, wasibhada ngodaka lengcino. Wafaka umntwana phakathi kwaso wayasibeka okhunjini lomfula uNayili phakathi kwemihlanga. ");
INSERT INTO nde_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Udadewabo wema bucwala ukuba abone okwenzakala kuye. ");
INSERT INTO nde_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Indodakazi kaFaro yehlela emfuleni ukuyageza, amantombazana ayikhangelayo ayehamba okhunjini lomfula. Yasisibona isitsha phakathi kwemihlanga yathuma incekukazi yayo ukuyasithatha. ");
INSERT INTO nde_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Yasivula yambona umntwana. Wayekhala, yasimzwela usizi yathi, “Lo ngomunye wabantwana bamaHebheru.” ");
INSERT INTO nde_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Udadewabo wasesithi endodakazini kaFaro, “Ngingayakudingela omunye wabesifazane bamaHebheru ukuthi akondlele umntwana na?” ");
INSERT INTO nde_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Yasisithi, “Yebo, hamba.” Intombazana yasuka yayabiza unina womntwana. ");
INSERT INTO nde_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Indodakazi kaFaro yathi kuye, “Mthathe lumntwana ungondlele yena, ngizakupha isondlo.” Ngakho owesifazane wamthatha umntwana wamondla. ");
INSERT INTO nde_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Esekhulile umntwana, wamthatha wamusa endodakazini kaFaro wasesiba ngumntanayo. Yasimutha ibizo yathi nguMosi ngoba yathi, “Ngamkhupha emanzini.” ");
INSERT INTO nde_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ngelinye ilanga, uMosi esekhulile, waya lapho okwakusebenzela khona abantu bakibo, wabona ukuthi babethwele nzima kanjani. Wabona umGibhithe etshaya umHebheru, omunye wabantu bakibo. ");
INSERT INTO nde_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Wathi thala ngapha langapha wabona kungelamuntu, wasebulala umGibhithe wamfihla etshebetshebeni. ");
INSERT INTO nde_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ngelanga elilandelayo waphuma njalo wabona amaHebheru amabili esilwa. Wasebuza lo owayephambanisile wathi, “Kungani utshaya owakini ongumHebheru na?” ");
INSERT INTO nde_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Indoda leyo yathi, “Ngubani okwenze waba ngumbusi lomahluleli wethu? Usucabanga ukungibulala na njengoba ubulele umGibhithe?” Ngalokho uMosi wesaba wacabanga ukuthi, “Engxenye engikwenzileyo sekusazakala.” ");
INSERT INTO nde_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Kwathi uFaro ekuzwa lokho, wazama ukubulala uMosi, kodwa uMosi wabalekela eMidiyani, lapho afika khona wahlala phansi eduze komthombo. ");
INSERT INTO nde_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Umphristi waseMidiyani wayelamadodakazi ayisikhombisa, afika ezokukha amanzi lokukhelela imikolo ukuze anathise izimvu zikayise. ");
INSERT INTO nde_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Kwafika abelusi abathile bawaxotsha, kodwa uMosi wasukuma wawalamulela wanathisa izimvu zawo. ");
INSERT INTO nde_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Kwathi izintombi sezibuyele kuyise eRuweli wazibuza esithi, “Kungani lamhla liphangisile ukuphenduka?” ");
INSERT INTO nde_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Zaphendula zathi, “KulomGibhithe osilamulele kubelusi. Uze wasikhelela amanzi wanathisa lezimvu zethu.” ");
INSERT INTO nde_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Wawabuza amadodakazi akhe wathi, “Ungaphi? Limtshiyeleni? Mbizeni ukuze azothola okokudla.” ");
INSERT INTO nde_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","UMosi wavuma ukuzehlala lale indoda, eyamnika indodakazi yayo uZiphora ukuthi abe ngumkakhe. ");
INSERT INTO nde_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","UZiphora wazala indodana, uMosi wayitha ibizo wathi nguGeshomu ngoba esithi, “Sengibe ngumuntu wezizweni endaweni yabezizweni.” ");
INSERT INTO nde_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Emva kwesikhathi eside, inkosi yaseGibhithe yafa. Abako-Israyeli bakhala babubula ebugqilini babo, kwasekusithi ukukhala kwabo becela usizo ngenxa yobugqili ababekubo kwafinyelela kuNkulunkulu. ");
INSERT INTO nde_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","UNkulunkulu wakuzwa ukububula kwabo wasekhumbula isivumelwano asenza lo-Abhrahama, lo-Isaka loJakhobe. ");
INSERT INTO nde_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Ngakho uNkulunkulu wakhangela abako-Israyeli, wakhathazeka ngabo. ");
INSERT INTO nde_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Kwathi uMosi eselusa izimvu zikayisezala uJethro, umphristi waseMidiyani, waseqhuba izimvu zaya kude ohlangothini lwenkangala wasefika eHorebhi, intaba kaNkulunkulu. ");
INSERT INTO nde_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Lapho-ke ingilosi kaThixo yabonakala kuye iphakathi kwamalangabi omlilo esixukwini. UMosi wabona ukuthi loba isixuku sasibhebha kasizange sitshe. ");
INSERT INTO nde_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ngakho uMosi wacabanga esithi, “Ngizasondela ngiyebona isimanga lesi ukuba kungani isixuku singatshi silothe.” ");
INSERT INTO nde_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Kwathi uThixo ebona ukuthi usesondele ukuba ayekhangela, uNkulunkulu wasememeza ngelizwi elaliphuma kulesosixuku wathi, “Mosi! Mosi!” UMosi wathi, “Ngilapha.” ");
INSERT INTO nde_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","UNkulunkulu wathi, “Ungasondeli. Khupha amanyathela akho, ngoba indawo omi kuyo ingumhlabathi ongcwele.” ");
INSERT INTO nde_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Wasesithi njalo, “NginguNkulunkulu kayihlo, uNkulunkulu ka-Abhrahama, uNkulunkulu ka-Isaka loNkulunkulu kaJakhobe.” Ngalokhu, uMosi wafihla ubuso bakhe ngoba wayesesaba ukukhangela uNkulunkulu. ");
INSERT INTO nde_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","UThixo wasesithi, “Impela ngilubonile usizi lwabantu bami eGibhithe. Ngibazwile bekhala ngenxa yezinduna zezigqili ezibancindezelayo, njalo ngiyakhathazeka ngokuhlupheka kwabo. ");
INSERT INTO nde_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ngakho ngehlile ukuzabakhulula ezandleni zamaGibhithe ngibakhuphe kulelolizwe ngibase elizweni elilendawo enengi, ilizwe eligeleza uchago loluju, endaweni yamaKhenani, amaHithi, ama-Amori, amaPherizi, amaHivi lamaJebusi. ");
INSERT INTO nde_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ukukhala kwabako-Israyeli sekufikile kimi, njalo sengibonile lendlela amaGibhithe ababahlukuluza ngayo. ");
INSERT INTO nde_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ngakho suka uhambe. Ngikuthuma kuFaro ukuthi uyekhupha abantu bami abako-Israyeli elizweni laseGibhithe.” ");
INSERT INTO nde_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Kodwa uMosi wathi kuNkulunkulu, “Kambe ngingubani ukuba ngiye kuFaro ukuyakhupha abako-Israyeli elizweni laseGibhithe na?” ");
INSERT INTO nde_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","UNkulunkulu wasesithi, “Ngizakuba lawe. Lesi sizakuba yisibonakaliso sokuthi yimi engikuthumileyo: Nxa usubakhuphile abantu eGibhithe, lizakhonza uNkulunkulu kuyonale intaba.” ");
INSERT INTO nde_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","UMosi wathi kuNkulunkulu, “Aluba ngifika kwabako-Israyeli ngithi kubo, ‘UNkulunkulu waboyihlo ungithumile kini,’ besebengibuza bathi, ‘Ungubani ibizo lakhe?’ Ngizakuthini kubo?” ");
INSERT INTO nde_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","UNkulunkulu wathi kuMosi, “Nginguye Onguye. Lokhu yikho ozakutsho kwabako-Israyeli ukuthi, ‘Unguye ungithumile kini.’ ” ");
INSERT INTO nde_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","UNkulunkulu wabuye wathi kuMosi, “Tshono kwabako-Israyeli uthi, ‘uThixo, uNkulunkulu waboyihlo, uNkulunkulu ka-Abhrahama, uNkulunkulu ka-Isaka, loNkulunkulu kaJakhobe ungithumile kini.’ Leli libizo lami laphakade, ibizo engizakhunjulwa ngalo kusukela kusizukulwane kusiya kwesinye isizukulwane. ");
INSERT INTO nde_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Hamba uyebuthanisa abadala bako-Israyeli uthi kubo, ‘uThixo, uNkulunkulu waboyihlo, uNkulunkulu ka-Abhrahama, ka-Isaka loJakhobe, ubonakele kimi wathi: Bengilikhangele njalo ngikubonile okwenziwe kini eGibhithe. ");
INSERT INTO nde_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Futhi ngithembisile ukulikhupha osizini lwenu elikulo eGibhithe ngilise elizweni lamaKhenani, amaHithi, ama-Amori, amaPherizi, amaHivi lamaJebusi, ilizwe eligeleza uchago loluju.’ ");
INSERT INTO nde_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Abadala bako-Israyeli bazakulalela. Kuzakuthi wena kanye labadala liye enkosini yaseGibhithe lithi kuyo, ‘uThixo, uNkulunkulu wamaHebheru uhlangane lathi. Sivumele sithathe uhambo lwezinsuku ezintathu siye enkangala ukuyanikela imihlatshelo kuThixo uNkulunkulu wethu.’ ");
INSERT INTO nde_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Kodwa ngiyakwazi ukuthi inkosi yaseGibhithe ayiyikulivumela ukuthi lihambe ngaphandle kokuba incindezelwe yisandla esilamandla. ");
INSERT INTO nde_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ngakho ngizakwelula isandla sami ngiwatshaye amaGibhithe ngazozonke izimanga engizazenza phakathi kwawo. Ngemva kwalokho, izalivumela lihambe. ");
INSERT INTO nde_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Njalo ngizakwenza amaGibhithe abe lomusa kulababantu, ukuze kuthi mhla lisuka lingahambi lingaphethe lutho. ");
INSERT INTO nde_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Wonke owesifazane kacele kumakhelwane wakhe lakuye wonke owesifazane ohlala endlini yakhe izinto eziligugu ezenziwe ngesiliva legolide kanye lezigqoko ezizagqokwa ngamadodana lamadodakazi enu. Ngaleyondlela lizawemuka impahla amaGibhithe.” ");
INSERT INTO nde_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","UMosi waphendula wathi, “Pho bangayekela ukungikholwa loba ukulalela engikutshoyo bathi, ‘uThixo kazange abonakale kuwe’?” ");
INSERT INTO nde_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","UThixo wathi kuye, “Kuyini lokho okusesandleni sakho?” Waphendula wathi, “Yintonga.” ");
INSERT INTO nde_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","UThixo wathi, “Iphosele phansi emhlabathini.” UMosi wayiphosa phansi yasiphenduka yaba yinyoka, wayibalekela. ");
INSERT INTO nde_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","UThixo wasesithi kuye, “Yelula isandla sakho uyibambe ngomsila.” UMosi welula isandla wayibamba inyoka yasiphenduka yaba yintonga esandleni sakhe. ");
INSERT INTO nde_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","UThixo wathi, “Lokhu yikwenzela ukuthi bakholwe ukuthi uThixo, uNkulunkulu waboyise, uNkulunkulu ka-Abhrahama, uNkulunkulu ka-Isaka loNkulunkulu kaJakhobe ubonakele kuwe.” ");
INSERT INTO nde_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","UThixo wabuye wathi, “Faka isandla sakho phakathi kwejazi lakho.” UMosi wasefaka isandla sakhe ejazini lakhe, kwathi lapho esesikhupha, sasesimhlophe njengongqwaqwane sesilobulephero. ");
INSERT INTO nde_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Wathi njalo, “Sibuyisele isandla sakho ejazini lakho.” UMosi wasifaka isandla sakhe ejazini lakhe, wathi esesikhupha sasesibuyele esimeni saso, sesifanana lejwabu lakhe. ");
INSERT INTO nde_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","UThixo wasesithi, “Nxa bengayikukholwa loba bengananzi izibonakaliso zokuqala, mhlawumbe bazakholwa ezesibili. ");
INSERT INTO nde_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Kodwa nxa bengakholwa izibonakaliso lezi ezimbili loba bengakulaleli, uzathatha amanzi emfuleni uNayili uwathele emhlabathini owomileyo. Amanzi ozawathatha emfuleni azaphenduka abe ligazi emhlabathini owomileyo.” ");
INSERT INTO nde_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","UMosi wasesithi kuThixo, “Oh Thixo, ngixolele, angizange ngibe yisikhulumi kusukela emuva kuze kube lakhathesi ukhuluma lenceku yakho. Ngiyagagasa njalo ngilamalimi.” ");
INSERT INTO nde_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","UThixo wathi kuye, “Ngubani owapha umuntu umlomo? Ngubani omenza abe yisacuthe loba abe yisimungulu? Ngubani omenza abone loba abe yisiphofu? Akusimi uThixo na? ");
INSERT INTO nde_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ngakho hamba, ngizakusiza ukuthi ukhulume njalo ngikufundise lokuthi uthini.” ");
INSERT INTO nde_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Kodwa uMosi wathi, “Oh Thixo, ngicela uthume omunye ukuthi ayekwenza lokhu.” ");
INSERT INTO nde_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","UThixo wathukuthela, ulaka lwakhe lwavutha kuMosi, wathi, “Umfowenu u-Aroni, ongumLevi ke? Ngiyazi ukuthi uyenelisa ukukhuluma kuhle. Uvele usendleleni ukuzahlangana lawe, njalo inhliziyo yakhe izathokoza ukukubona. ");
INSERT INTO nde_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Uzakhuluma laye ufake amazwi emlonyeni wakhe. Ngizaliphathisa lobabili ukuthi likhulume njalo ngizalifundisa ukuthi lenzeni. ");
INSERT INTO nde_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Yena uzakukhulumela ebantwini, njalo kuzakuba sengani nguye ongumlomo wakho njalo kube angani wena unguNkulunkulu kuye. ");
INSERT INTO nde_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Kodwa phatha intonga le esandleni sakho ukuze wenze izimangaliso ngayo.” ");
INSERT INTO nde_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","UMosi wasebuyela kuyisezala uJethro wathi kuye, “Bengicela ukubuyela ebantwini bakithi eGibhithe ukuthi ngiyebona kumbe balokhu besaphilile.” UJethro wathi kuye, “Hamba kuhle.” ");
INSERT INTO nde_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","UThixo wayethe kuMosi eMidiyani, “Buyela eGibhithe, ngoba bonke abantu ababefuna ukukubulala sebafa.” ");
INSERT INTO nde_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ngakho uMosi wathatha umkakhe kanye lamadodana akhe, wabakhweza kubabhemi waqala uhambo lokubuyela eGibhithe. Wathatha intonga kaNkulunkulu wayiphatha ngesandla. ");
INSERT INTO nde_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","UThixo wathi kuMosi, “Ekubuyeleni kwakho eGibhithe, bona ukuthi uyazenza zonke izimangaliso engikuphe amandla okuba uzenze phambi kukaFaro. Kodwa ngizakwenza inhliziyo yakhe ibe lukhuni ukuba angabavumeli abantu ukuthi basuke. ");
INSERT INTO nde_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Uzakuthi kuFaro, ‘uThixo uthi u-Israyeli yindodana yami elizibulo, ");
INSERT INTO nde_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","njalo ngakutshela ngathi, “Vumela indodana yami ihambe, ukuze iyengikhonza.” Kodwa wena wala ukuyivumela ukuba ihambe; ngakho ngizabulala indodana yakho elizibulo.’ ” ");
INSERT INTO nde_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Kwathi besesendleleni, endlini yezihambi, uThixo wahlangana loMosi wafuna ukumbulala. ");
INSERT INTO nde_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Kodwa uZiphora wayisoka indodana yakhe, wathatha isikhumba sakhona wasethinta inyawo zikaMosi ngaso. Wathi, “Impela wena ungumyeni wegazi.” ");
INSERT INTO nde_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Ngakho uThixo wamyekela. (Ngalesosikhathi uZiphora wathi “umyeni wegazi,” esitsho ukusoka.) ");
INSERT INTO nde_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","UThixo wathi ku-Aroni, “Hamba uye enkangala uhlangabezane loMosi.” Ngakho wasuka wayahlangana loMosi entabeni kaThixo wamanga. ");
INSERT INTO nde_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","UMosi wamtshela u-Aroni konke uThixo ayemthume ukuthi akutsho, njalo langazo zonke izibonakaliso ezimangalisayo ayemlaye ukuba azenze. ");
INSERT INTO nde_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","UMosi lo-Aroni bahamba bafika baqoqa bonke abadala bako-Israyeli, ");
INSERT INTO nde_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","u-Aroni wasebatshela konke uThixo ayekutshele uMosi. Wenza lezibonakaliso phambi kwabantu, ");
INSERT INTO nde_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","bakholwa. Kwathi besizwa ukuthi uThixo uyabakhathalela, njalo wayelubonile usizi lwabo, bakhothama phansi bamkhonza. ");
INSERT INTO nde_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Emva kwalokho uMosi lo-Aroni baya kuFaro. Bathi kuye, “Sikulethele ilizwi elivela kuThixo, uNkulunkulu wabantu bako-Israyeli. Uthi, ‘Vumela abantu bami bahambe, ukuze bangenzele umkhosi enkangala.’ ” ");
INSERT INTO nde_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","UFaro wathi, “Ungubani uThixo okufanele ngimlalele ngivumele abako-Israyeli ukuba bahambe na? Mina kangimazi uThixo, njalo kangiyikubavumela abako-Israyeli ukuba bahambe.” ");
INSERT INTO nde_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ngakho-ke bona bathi, “UNkulunkulu wamaHebheru ubonakele kithi. Kumele sithathe uhambo lwamalanga amathathu siye enkangala ukuze siyenikela iminikelo kuThixo uNkulunkulu wethu, funa asibulale ngemikhuhlane loba ngenkemba.” ");
INSERT INTO nde_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Kodwa inkosi yaseGibhithe yathi, “Mosi lo-Aroni, kungani lisusa abantu emsebenzini wabo? Buyelani emisebenzini yenu.” ");
INSERT INTO nde_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","UFaro wasesithi, “Khangelani abantu sebebanengi elizweni, kodwa lina liyabamisa ukusebenza.” ");
INSERT INTO nde_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ngalelolanga uFaro wathumela lelilizwi ezinduneni zezigqili ezazisebenzisa abantu wathi: ");
INSERT INTO nde_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Lingabe lisabapha abantu utshani bokwenza izitina. Yekelani bayezidingela utshani babo kodwa lingehlisi inani lezitina okumele bazenze. ");
INSERT INTO nde_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Kumele ukuthi batshaye inani abebelitshaya. Bangamavila, yikho besuka bakhale besithi, ‘Kasihambeni siyenikela kuNkulunkulu wethu.’ ");
INSERT INTO nde_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Yenzani umsebenzi ubenzima kwabesilisa ukuze baqhubekele phambili ngomsebenzi batshiyane lokulalela amanga.” ");
INSERT INTO nde_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Izinduna zezigqili kanye labaphathi baphuma bayatshela abantu bathi, “Nanku esikulaywe nguFaro, uthi, ‘Kangisoze ngilinike utshani futhi. ");
INSERT INTO nde_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Hambani liyesika utshani lapho elingabuthola khona. Kodwa umsebenzi wenu kawusoze uphungulwe lakancinyane.’ ” ");
INSERT INTO nde_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Ngakho abantu bahlakazeka kulolonke elaseGibhithe, besika imihlanga ukuze bayisebenzise esikhundleni sotshani. ");
INSERT INTO nde_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Izinduna zezigqili zaqhubeka zibakhahlameza zisithi, “Qedani imisebenzi yansuku zonke njengalokho elalikwenza lisazuza utshani.” ");
INSERT INTO nde_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Abaphathi bezisebenzi bako-Israyeli ababekhethwe yizinduna zezigqili zikaFaro batshaywa bebuzwa ukuthi, “Kungani inani lezolo lelanamuhla lingenelanga njengakuqala?” ");
INSERT INTO nde_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ngakho abaphathi bezisebenzi bako-Israyeli baya kuFaro bamncenga besithi, “Kungani uphatha izisebenzi zakho ngale indlela? ");
INSERT INTO nde_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Izisebenzi zakho kazinikwa utshani, kodwa sitshelwa ukuthi, ‘Tshayani izitina!’ Izisebenzi zakho ziyatshaywa, kodwa umlandu ngowabantu bakho.” ");
INSERT INTO nde_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","UFaro wathi, “Mavila, yikho eliyikho, mavila! Yikho lihlala lisithi, ‘Siyekele siyenikela kuThixo.’ ");
INSERT INTO nde_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Buyelani emsebenzini. Akulatshani elizabuphiwa. Kodwa kumele lenze izitina ezifika inani ebelivele lilenza.” ");
INSERT INTO nde_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Abaphathi bezisebenzi bako-Israyeli bananzelela ukuthi babesebunzimeni obukhulu baze batshelwe ukuthi, “Kakumelanga lehlise inani lezitina okumele lilenze nsuku zonke.” ");
INSERT INTO nde_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Sebesukile kuFaro, bafica uMosi lo-Aroni bebalindele. ");
INSERT INTO nde_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Basebesithi, “uThixo kalikhangele alahlulele. Selenze ukuthi senyanyeke kuFaro lakuziphathamandla zakhe, lafaka inkemba ezandleni zabo ukuba basibulale.” ");
INSERT INTO nde_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","UMosi wabuyela kuThixo wathi kuye, “Thixo, kungani ulethe uhlupho ebantwini laba? Yiso yini isizatho sokungithuma. ");
INSERT INTO nde_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Selokhu ngaya kuFaro ukuyakhuluma ngebizo lakho, uselethe uhlupho ebantwini laba, njalo kawubahlenganga abantu bakho lakancane.” ");
INSERT INTO nde_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","UThixo wasesithi kuMosi, “Uzabona esengizakwenza kuFaro khathesi. Ngenxa yamandla esandla sami uzabavumela bahambe, ngenxa yamandla esandla sami uzabaxotsha elizweni lakhe.” ");
INSERT INTO nde_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","UNkulunkulu waphinda wathi kuMosi, “NginguThixo. ");
INSERT INTO nde_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ngazibonakalisa ku-Abhrahama, ku-Isaka lakuJakhobe njengoNkulunkulu uSomandla, kodwa ngegama lami elithi Thixo kangizange ngizibonakalise kubo. ");
INSERT INTO nde_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ngaphinda ngenza isivumelwano labo ukuze ngibanike ilizwe leKhenani lapho ababehlala khona njengabezizweni. ");
INSERT INTO nde_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Phezu kwalokho, sengikuzwile ukububula kwabantu bako-Israyeli besebugqilini ngaphansi kwamaGibhithe, njalo sengikhumbule isivumelwano sami. ");
INSERT INTO nde_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Ngakho tshela abako-Israyeli ukuthi nginguThixo, njalo ngizalikhulula embusweni wamaGibhithe onzima, ngizalikhulula ukuze lingabi yizigqili zabo, njalo ngizalikhulula ngesandla eseluliweyo langezimangaliso. ");
INSERT INTO nde_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ngizalemukela njengabantu bami njalo ngizakuba nguNkulunkulu wenu. Ngalokho lizakwazi ukuthi nginguThixo uNkulunkulu wenu owalikhupha embusweni olukhuni wamaGibhithe. Ngizalikhulula ukuze lingabi yizigqili zabo. ");
INSERT INTO nde_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Njalo ngizaliletha elizweni engafunga ngesandla sami esiphakemeyo ukulinika u-Abhrahama, u-Isaka loJakhobe. Ngizalinika lona ukuze libe ngelenu. Mina nginguThixo.” ");
INSERT INTO nde_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","UMosi wabika lokhu kwabako-Israyeli, kodwa kabazange bamlalele ngenxa yokudangala kwabo ebugqilini obulochuku. ");
INSERT INTO nde_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","UThixo wasesithi kuMosi, ");
INSERT INTO nde_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Hamba uyetshela uFaro inkosi yaseGibhithe ukuthi avumele abako-Israyeli baphume elizweni lakhe.” ");
INSERT INTO nde_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Kodwa uMosi wathi kuThixo, “Nxa abako-Israyeli bengangilaleli, kuyini okungenza ukuthi uFaro angilalele, njengoba ngikhuluma ngigagasa?” ");
INSERT INTO nde_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","UThixo wakhuluma loMosi lo-Aroni mayelana labako-Israyeli loFaro inkosi yaseGibhithe wabalaya ukuthi bavumele abantu bako-Israyeli ukuthi baphume eGibhithe. ");
INSERT INTO nde_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Laba babezinhloko zezindlu zaboyise: Amadodana kaRubheni, izibulo lika-Israyeli ayeyila: uHanokhi, uPhalu, uHezironi, loKhami. Laba babengabosendo lukaRubheni. ");
INSERT INTO nde_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Amadodana kaSimiyoni ayeyila: uJemuyeli, uJamini, u-Ohadi, uJakhini, uZohari, loShawuli olonina oweyengumKhenani. Laba babengabosendo lukaSimiyoni. ");
INSERT INTO nde_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","La ngamabizo amadodana kaLevi ngokwemibhalo yabo: uGeshoni, uKhohathi loMerari. ULevi waphila iminyaka elikhulu elilamatshumi amathathu lesikhombisa (137). ");
INSERT INTO nde_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Amadodana kaGeshoni ngezizukulwana zawo ayeyila: uLibhini, uShimeyi, lemuli zabo. ");
INSERT INTO nde_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Amadodana kaKhohathi ayeyila: u-Amramu, u-Izihari, uHebhroni lo-Uziyeli. UKhohathi waphila iminyaka elikhulu elilamatshumi amathathu lantathu (133). ");
INSERT INTO nde_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Amadodana kaMerari ayeyila: uMahili loMushi. Laba babengabosendo lukaLevi, ngokwemibhalo yabo. ");
INSERT INTO nde_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","U-Amramu wathatha uJokhebhedi owayengudadewabo kayise. Wamzalela u-Aroni loMosi. U-Amramu waphila iminyaka elikhulu elilamatshumi amathathu lesikhombisa (137). ");
INSERT INTO nde_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Amadodana ka-Izihari ayeyila; uKhora, uNefegi loZikhiri. ");
INSERT INTO nde_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Amadodana ka-Uziyeli ayeyila: uMishayeli, u-Elizafani loSithiri. ");
INSERT INTO nde_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","U-Aroni wathatha u-Elishebha indodakazi ka-Aminadabi. U-Elishebha wayengudadewabo kaNahashoni. Wamzalela uNadabi, u-Abhihu, u-Eliyazari lo-Ithamari. ");
INSERT INTO nde_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Amadodana kaKhora ayeyila; u-Asiri, u-Elikhana lo-Abhiyasafi. Laba babengabosendo lukaKhora. ");
INSERT INTO nde_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","U-Eliyazari indodana ka-Aroni wathatha omunye wamadodakazi kaPhuthiyeli. Wamzalela uFinehasi. Laba-ke yibo ababengabakhokheli bezimuli zakoLevi, ngendlu yinye ngayinye. ");
INSERT INTO nde_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Yibo labo o-Aroni loMosi uThixo athi kubo, “Khokhelani abantu bami bako-Israyeli libakhuphe elizweni laseGibhithe ngamakhulu abo.” ");
INSERT INTO nde_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Yibo laba abaya kuFaro inkosi yaseGibhithe mayelana lokukhupha abantu bako-Israyeli eGibhithe. Kwakuyibo oMosi lo-Aroni. ");
INSERT INTO nde_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ngesikhathi uThixo ekhuluma loMosi eGibhithe, ");
INSERT INTO nde_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","wathi kuye, “NginguThixo. Tshela uFaro inkosi yaseGibhithe yonke into engikutshela yona.” ");
INSERT INTO nde_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Kodwa uMosi wathi kuThixo, “Njengoba ngikhuluma ngigagasa, kambe kuyini okungenza ukuthi uFaro azihluphe ngokungilalela?” ");
INSERT INTO nde_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","UThixo wasesithi kuMosi, “Khangela, sengikwenze wafana loNkulunkulu kuFaro, njalo umfowenu u-Aroni uzakuba ngumphrofethi wakho. ");
INSERT INTO nde_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Uzakhuluma konke engizakulaya khona njalo umfowenu u-Aroni uzatshela uFaro ukuthi avumele abako-Israyeli ukuba basuke elizweni lakhe. ");
INSERT INTO nde_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Kodwa ngizakwenza inhliziyo kaFaro ibe lukhuni, njalo lanxa ngizakwandisa izimangaliso zami elizweni laseGibhithe, ");
INSERT INTO nde_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","kasoze alilalele. Sekunjalo ngizakwelula isandla sami phezu kweGibhithe, njalo ngezenzo zami zokwahlulela ezilamandla, ngizakwahlukanisa abantu. ");
INSERT INTO nde_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Njalo abantu baseGibhithe bazakwazi ukuthi ngempela mina nginguThixo lapho sengiselula isandla sami phezu kweGibhithe, besengikhupha abako-Israyeli kulelolizwe.” ");
INSERT INTO nde_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","UMosi lo-Aroni benza njengokulaywa kwabo nguThixo. ");
INSERT INTO nde_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","UMosi wayeleminyaka engamatshumi ayisificaminwembili ubudala, u-Aroni wayeleminyaka engamatshumi ayisificaminwembili lantathu ngesikhathi bekhuluma loFaro. ");
INSERT INTO nde_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","UThixo wathi kuMosi lo-Aroni, ");
INSERT INTO nde_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Nxa uFaro angathi kini limenzele isimangaliso, wena uzakuthi ku-Aroni, ‘Thatha intonga yakho uyiphose phambi kukaFaro,’ izaphenduka ibe yinyoka.” ");
INSERT INTO nde_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ngakho uMosi lo-Aroni baya kuFaro. Bafika benza njengokulaywa kwabo nguThixo. U-Aroni waphosa intonga yakhe phansi phambi kukaFaro lezikhulu zakhe, yaphenduka yaba yinyoka. ");
INSERT INTO nde_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","UFaro wasebiza izanuse lezinyanga zaseGibhithe. Lazo zenza izimanga ngendlela efanayo. ");
INSERT INTO nde_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Bonke baphosela intonga zabo phansi zaphenduka zaba zinyoka. Kodwa inyoka ka-Aroni yaziginya zonke izinyoka. ");
INSERT INTO nde_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Kodwa-ke, lanxa kwabanjalo, inhliziyo kaFaro yala ilokhu ilukhuni; njengoba uThixo wayetshilo. ");
INSERT INTO nde_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","UThixo wasesithi kuMosi, “Inhliziyo kaFaro ilukhuni; uyala ukuthi abantu bahambe. ");
INSERT INTO nde_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Yana kuFaro ekuseni, ngesikhathi esehlela emfuleni. Ubokuma okhunjini lomfula uNayili, umhlangabeze uphethe intonga eyaphenduka yaba yinyoka. ");
INSERT INTO nde_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ubokuthi kuye, ‘uThixo, uNkulunkulu wamaHebheru ungithumile njalo kuwe ukuba ngizekutshela ukuthi: Vumela abantu bami ukuthi bahambe, ukuze bayengikhonza enkangala. Kodwa kuze kube khathesi kawukalaleli. ");
INSERT INTO nde_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","UThixo uthi, Ngalokhu uzakwazi ukuthi nginguThixo: Ngentonga esesandleni sami ngizatshaya amanzi kaNayili njalo azaphenduka abe ligazi. ");
INSERT INTO nde_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Inhlanzi kuNayili zizakufa, amanzi omfula azanuka athi phu, ngakho abantu baseGibhithe abangeke babe besawanatha.’ ” ");
INSERT INTO nde_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","UThixo wasesithi kuMosi, “Tshela u-Aroni uthi ‘thatha intonga yakho welulele isandla sakho phezu kwamanzi eGibhithe, lakuyo yonke imifula yakhona lemisele yamanzi, amaxhaphozi, lamachibi, wonke amanzi alapho azaphenduka abe ligazi.’ Igazi lizagcwala eGibhithe lasezinkonxeni zezigodo lasezitsheni zamatshe.” ");
INSERT INTO nde_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","UMosi lo-Aroni benza njengokulaywa kwabo nguThixo. Waphakamisa intonga yakhe phambi kukaFaro lezikhulu zakhe watshaya amanzi kaNayili aphenduka aba ligazi. ");
INSERT INTO nde_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Inhlanzi zikaNayili zafa. Umfula wanuka kubi okokuthi abaseGibhithe babengeke bawanathe amanzi akhona. Igazi laseligcwele indawo yonke. ");
INSERT INTO nde_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Kodwa izanuse zaseGibhithe lazo ngemilingo yazo zenza izimanga ezifananayo. Ngalokho inhliziyo kaFaro yala ilokhu ilukhuni. Kabalalelanga oMosi lo-Aroni njengoba uThixo wayevele etshilo. ");
INSERT INTO nde_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","UFaro wabuyela esigodlweni sakhe engakunaki lokho. ");
INSERT INTO nde_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Sekunjalo abaseGibhithe bemba imithombo okhunjini lomfula uNayili ukuba bathole amanzi okunatha, ngoba babengeke babe besawanatha awomfula. ");
INSERT INTO nde_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Kwedlula insuku eziyisikhombisa ngemva kokuba uThixo enze amanzi kaNayili aba ligazi. ");
INSERT INTO nde_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","UThixo wathi kuMosi, “Buyela njalo kuFaro uthi kuye, ‘UThixo uthi, Vumela abantu bami bahambe bayengikhonza. ");
INSERT INTO nde_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ungala ngizathumela uhlupho lwamaxoxo elizweni lakho. ");
INSERT INTO nde_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Umfula uNayili uzagcwala amaxoxo. Azangena esigodlweni sakho lasendlini yakho yokulala, lasembhedeni wakho; angene lezindlini zezikhulu zakho lezabantu bakho. Azagcwala ezindaweni zenu zokuphekela, lasemiganwini yenu yokuvubela izinkwa. ");
INSERT INTO nde_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Amaxoxo la azakuba phezu kwakho laphezu kwabantu bakho kanye lezikhulu zakho.’ ” ");
INSERT INTO nde_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","UThixo wasesithi kuMosi, “Tshela u-Aroni akhombele intonga emifuleni, lasezifudlaneni lasezizibeni zonke zaseGibhithe ukuze kube lamaxoxo ezindaweni zonke zelizwe.” ");
INSERT INTO nde_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","U-Aroni welulela isandla sakhe emanzini eGibhithe, amaxoxo agcwala ilizwe lonke. ");
INSERT INTO nde_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Kodwa-ke izanuse lazo zenzanjalo ngemilingo yazo yensitha, zenza kwaba lamaxoxo elizweni lonke leGibhithe. ");
INSERT INTO nde_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","UFaro wabiza uMosi lo-Aroni wathi kubo, “Ncengani uThixo asuse amaxoxo kimi lebantwini bami, lami ngizavumela abantu bakhe ukuba bahambe bayenikela imihlatshelo kuThixo.” ");
INSERT INTO nde_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","UMosi wathi, kuFaro “Ngikutshiya kuwe ukuba ubeke isikhathi sokuthi ngikukhulekele wena lezikhulu zakho labantu bakho ukuze lina lezindlu zenu lilanyulelwe emaxoxweni, ngaphandle kwalawo azasala kuNayili.” ");
INSERT INTO nde_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","UFaro wathi, “Kwenze kusasa.” UMosi wasesithi, “Kuzakuba njengokutsho kwakho ukuze ukwazi ukuthi kakho omunye onjengoThixo uNkulunkulu wethu. ");
INSERT INTO nde_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Amaxoxo azasuka kini lezindlini zenu lezezikhulu labantu benu abesesala emfuleni uNayili kuphela.” ");
INSERT INTO nde_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","UMosi lo-Aroni basuka kuFaro. UMosi wakhala kuThixo ukuba asuse amaxoxo ayewathumele kuFaro. ");
INSERT INTO nde_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","UThixo wenza lokho uMosi ayekucelile. Amaxoxo afa ezindlini lemagumeni lemasimini. ");
INSERT INTO nde_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Bawabuthelela aba zinqwabanqwaba; ilizwe lonke lanuka phu ngamaxoxo. ");
INSERT INTO nde_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Kodwa uFaro ebona ukuthi udubo soluphungukile womisa inhliziyo yakhe wala ukulalela uMosi lo-Aroni njengokwakuvele kukhulunywe nguThixo. ");
INSERT INTO nde_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","UThixo wasesithi kuMosi, “Tshela u-Aroni uthi, ‘Phakamisa intonga yakho utshaye uthuli lomhlabathi,’ uthuli luzaphenduka lube zintwala elizweni lonke laseGibhithe.” ");
INSERT INTO nde_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Benza njengokulaywa kwabo, kwathi u-Aroni eselule isandla sakhe ephethe intonga watshaya uthuli, intwala zahlasela abantu lezifuyo zabo. Uthuli lonke eGibhithe lwaphenduka lwaba zintwala. ");
INSERT INTO nde_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Izanuse lazo zazama ukwenza intwala ngemilingo yazo, kodwa zehluleka. Njengoba intwala zazisebantwini lezinyamazaneni, ");
INSERT INTO nde_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","izanuse zathi kuFaro, “Lokhu kungumunwe kaNkulunkulu.” Kodwa inhliziyo kaFaro yayilukhuni, kabalalelanga njengoba uThixo wayevele etshilo. ");
INSERT INTO nde_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","UThixo wasesithi kuMosi, “Kusasa ubovuka ekuseni kakhulu uhlangabeze uFaro lapho esiya emanzini. Ubokuthi kuye, ‘Vumela abantu bami bahambe bayengikhonza. ");
INSERT INTO nde_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ungala, ngizathumela umtshitshi wempukane kuwe, ebantwini bakho lezindlini zenu. Izindlu zabantu baseGibhithe zizagcwala impukane lomhlabathi ugcwale zona. ");
INSERT INTO nde_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Kodwa ngalolosuku akuyikuba njalo eGosheni lapho okuhlala khona abantu bami. Akuyikuba lemitshitshi yempukane khona. Ngakho uzakwazi ukuthi mina nginguThixo womhlaba wonke. ");
INSERT INTO nde_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ngizakwenza kube lomahluko phakathi kwabantu bami labantu bakho. Lesisimangaliso sizakwenzakala kusasa.’ ” ");
INSERT INTO nde_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","UThixo wenza njengoba wayetshilo. Umtshitshi wempukane ezinengi okwesabeka kakhulukazi zagcwala esigodlweni sikaFaro lasezindlini zezikhulu zakhe, lakulo lonke ilizwe laseGibhithe; zalitshabalalisa. ");
INSERT INTO nde_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","UFaro wabiza uMosi lo-Aroni. Wathi kubo, “Hambani liyehlabela uNkulunkulu wenu likhonapha kulelilizwe.” ");
INSERT INTO nde_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","UMosi waphendula wathi, “Lokho akulunganga. Imihlatshelo yethu esinikela ngayo kuThixo uNkulunkulu wethu iyanengeka ebantwini beGibhithe. Singanikela ngeminikelo abayizondayo kambe kabayikusitshaya ngamatshe na? ");
INSERT INTO nde_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Kumele sithathe uhambo lwezizinsuku ezintathu siye enkangala siyemhlabela khonale uThixo uNkulunkulu wethu njengokusilaya kwakhe.” ");
INSERT INTO nde_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","UFaro wathi, “Ngizalivumela lihambe liyenikela imihlatshelo kuThixo uNkulunkulu wenu enkangala, kodwa lingayi khatshana. Khathesi ngikhulekelani.” ");
INSERT INTO nde_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","UMosi waphendula wathi, “Ngizakuthi ngisanda kusuka ngikhuleke kuThixo, njalo kusasa umtshitshi wempukane uzasuka kuFaro, ezikhulwini zakhe lebantwini bakhe. Kodwa uFaro kangasikhohlisi futhi asuke angasavumeli abantu ukuba bahambe bayenikela imihlatshelo kuThixo.” ");
INSERT INTO nde_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Emva kwalokho uMosi wasuka kuFaro wasekhuleka kuThixo. ");
INSERT INTO nde_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","UThixo wenza lokho okwakucelwe nguMosi, umtshitshi wempukane wanyamalala kuFaro lezikhulu zakhe labantu bakhe, akwaze kwasala leyodwa. ");
INSERT INTO nde_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Kodwa langalesosikhathi uFaro wenza inhliziyo yakhe yaba lukhuni kazabavumela abako-Israyeli ukuba bahambe. ");
INSERT INTO nde_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","UThixo wasesithi kuMosi, “Yana kuFaro uthi kuye, ‘Nanku okutshiwo nguThixo, uNkulunkulu wamaHebheru, ukuthi, “Yekela abantu bami bahambe, ukuze bayengikhonza.” ");
INSERT INTO nde_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ungabalela ukuthi bahambe ube ulokhu ubabambile ");
INSERT INTO nde_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","uThixo uzakwehlisela isifo esibi ezifuyweni zakho emadlelweni, amabhiza enu, obabhemi, amakamela, inkomo, izimvu lembuzi. ");
INSERT INTO nde_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Kodwa uThixo uzakwenza umahluko phakathi kwezifuyo zabako-Israyeli lezamaGibhithe ukuze kungafi lasinye isifuyo sabako-Israyeli.’ ” ");
INSERT INTO nde_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","UThixo wamisa isikhathi esithile wathi, “uThixo uzakwenza lokhu kusasa elizweni leli.” ");
INSERT INTO nde_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Lakanye ngelanga elilandelayo uThixo wakwenza, zonke izifuyo zamaGibhithe zafa, kodwa akufanga ngitsho lasinye isifuyo sabako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","UFaro wathuma amadoda ukuyahlola umonakalo afumana ukuthi kwakungafanga sifuyo lasinye sabako-Israyeli. Kodwa inhliziyo yakhe yala ilokhu ilukhuni, wabalela abantu ukuthi bahambe. ");
INSERT INTO nde_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","UThixo wasesithi kuMosi lo-Aroni, “Thathani umlotha omlutshwana eziko lifike kuFaro uMosi awuhazele emoyeni phambi kwakhe. ");
INSERT INTO nde_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Uzakuba luthuli phezu kwelizwe lonke laseGibhithe, lapho-ke kuzaphihlika amathumba amabi ebantwini lasezinyamazaneni kulolonke ilizwe.” ");
INSERT INTO nde_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ngakho bathatha umlotha eziko baya kuFaro. UMosi wawuhazela emoyeni, abantu bonke lezinyamazana zonke kwamilwa ngamathumba aphihlikayo. ");
INSERT INTO nde_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Izangoma zehluleka ukumisana loMosi ngenxa yamathumba ayezibulala kanye lamaGibhithe wonke. ");
INSERT INTO nde_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Kodwa uThixo wenza yaba lukhuni inhliziyo kaFaro wala ukulalela uMosi lo-Aroni njengoba uThixo wayevele etshilo kuMosi. ");
INSERT INTO nde_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","UThixo wasesithi kuMosi, “Vuka ekuseni kakhulu uye kuFaro, uthi kuye, ‘Nanku okutshiwo nguThixo, uNkulunkulu wamaHebheru, uthi, yekela abantu bami bahambe ukuze bayengikhonza. ");
INSERT INTO nde_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Kungenjalo kulesisikhathi ngizakwehlisa ubunzima bezinhlupho zami obulesihluku phezu kwakho, phezu kwezinceku zakho labantu bakho ukuze lazi ukuthi kakho omunye onjengami emhlabeni wonke. ");
INSERT INTO nde_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Kunje nje ngabe sengiselulile isandla sami ngakutshaya kanye labantu bakho ngesifo ebesizakucitsha emhlabeni. ");
INSERT INTO nde_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Kodwa ngikuphephisile ngayonale injongo yokuthi ngikubonise amandla ami, lokuthi ibizo lami lifakazwe kuwo wonke umhlaba. ");
INSERT INTO nde_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ulokhu utshingela abantu bami ubalela ukuthi bahambe. ");
INSERT INTO nde_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ngalokho-ke ngalesisikhathi kusasa ngizakwehlisa isiqhotho esingakaze sehlele eGibhithe lilokhu lababala laba khona ilizwe leli. ");
INSERT INTO nde_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Wohle nje uthumezele ilizwi lokuthi izifuyo zakho lakho konke olakho emadlelweni kubuyiswe kuvalelwe esibayeni esivikelweyo ngoba isiqhotho leso sizatshaya umuntu wonke lesifuyo sonke esingabuthwanga nxa silokhu sisegangeni, konke kuzakufa.’ ” ");
INSERT INTO nde_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Lezozikhulu zikaFaro ezalesabayo ilizwi likaThixo zaphanga zangenisa izigqili zazo lezifuyo ngaphakathi. ");
INSERT INTO nde_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Labo abangalinanzanga ilizwi likaThixo izigqili zabo lezifuyo zabo bakuyekela kusegangeni. ");
INSERT INTO nde_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","UThixo wasesithi kuMosi, “Yelula isandla sakho siye phezulu ukuze kune isiqhotho kulolonke iGibhithe, phezu kwabantu lezinyamazana laphezu kwakho konke okukhulayo emasimini aseGibhithe.” ");
INSERT INTO nde_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","UMosi wonela ukukhomba ngentonga yakhe phezulu, uThixo wehlisa umdumo lesiqhotho, umbane wabaneka phansi emhlabathini. Ngakho uThixo wanisa isiqhotho elizweni laseGibhithe. ");
INSERT INTO nde_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Isiqhotho satshaya umbane wabaneka yonke indawo. Sasingakaze sibe khona isiphepho esinjalo sekulokhu isizwe saseGibhithe saba khona. ");
INSERT INTO nde_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Isiqhotho satshaya saqothula yonke into egangeni, abantu lezinyamazana; sabhuqa konke okukhulayo emasimini, saphundla izihlahla zonke eGibhithe. ");
INSERT INTO nde_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Indawo eyasilayo yiGosheni lapho okwakulabako-Israyeli khona. ");
INSERT INTO nde_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","UFaro wasebiza uMosi lo-Aroni. Wathi kubo, “Okwamanje ngenze isono. UThixo ulungile, kukanti mina labantu bami siyizoni. ");
INSERT INTO nde_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Khulekani kuThixo, ngoba ukukhwaza kwezulu lesiqhotho sekwanele. Ngizaliyekela lihambe; akusadingeki ukuthi lihlale.” ");
INSERT INTO nde_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","UMosi waphendula wathi. “Nxa sengiphumile edolobheni ngizavula izandla zami ngikhuleke kuThixo. Ukuduma kuzakhawula kungabe kusaba lesiqhotho, ukuze wazi ukuthi umhlaba ngokaThixo. ");
INSERT INTO nde_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Kodwa ngiyazi ukuthi wena lezikhulu zakho lilokhu lingamesabi uThixo uNkulunkulu.” ");
INSERT INTO nde_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Amabele lebhali kwabhuqwa nya ngoba amabele ayeselezikhwebu lophoko selumumethe. ");
INSERT INTO nde_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ingqoloyi lenyawuthi khona kakuthintwanga ngoba kuvuthwa muva.) ");
INSERT INTO nde_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","UMosi wasesuka kuFaro waphuma edolobheni. Welulela izandla zakhe kuThixo; ukuduma kwezulu lesiqhotho kwakhawula, izulu alabe lisana emhlabeni. ");
INSERT INTO nde_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Kwathi uFaro ebona ukuthi izulu lesiqhotho lokukhwaza kwezulu kwasekukhawule waphinda wenza isono: Yena lezikhulu zakhe benza inhliziyo zabo zaba lukhuni. ");
INSERT INTO nde_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ngakho inhliziyo kaFaro yaba lukhuni akaze avumela abako-Israyeli ukuthi bahambe njengoba uThixo wayetshilo ngoMosi. ");
INSERT INTO nde_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ngakho uThixo wasesithi kuMosi, “Hamba kuFaro, ngoba sengiyenze yaba lukhuni inhliziyo yakhe lezinhliziyo zezikhulu zakhe ukuze ngenze izimanga zami kubo ");
INSERT INTO nde_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ukuze lilandisele abantwabenu labazukulu benu ukuthi ngabahlukuluza njani abeGibhithe lokuthi ngabenzela izimanga, khona lizakwazi ukuthi mina nginguThixo.” ");
INSERT INTO nde_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ngakho oMosi lo-Aroni baya kuFaro bathi kuye, “Nanku okutshiwo nguThixo, uNkulunkulu wamaHebheru: ‘Uzakwala kuze kube nini ukuzithoba phambi kwami? Yekela abantu bami bahambe ukuze bayengikhonza. ");
INSERT INTO nde_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Nxa usala ukuthi bahambe ngizaletha intethe elizweni lakho kusasa. ");
INSERT INTO nde_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Zizakwembesa wonke umhlabathi usale ungasabonakali. Zizakudla ziphundle du lalokho okuncinyane okwatshiywa yisiqhotho kanye lezihlahla zonke ezikhula egangeni. ");
INSERT INTO nde_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Zizagcwala ezindlini zakho lezezikhulu zakho zonke lezamaGibhithe, into oyihlo labokhokho bakho abangazange bayibone selokhu bahlala kulelilizwe kuze kube manje.’ ” Khonapho uMosi wabe efulathela esuka kuFaro. ");
INSERT INTO nde_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Izikhulu zikaFaro zathi kuye, “Koze kube nini na indoda le ilokhu iyisifu kithi? Yekela abantu bahambe bayekhonza uThixo uNkulunkulu wabo. Ulokhu ungaboni yini ukuthi ilizwe leGibhithe selichithekile?” ");
INSERT INTO nde_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","UMosi lo-Aroni basebebuyiswa kuFaro. Wathi, “Hambani liyokhonza uThixo uNkulunkulu wenu. Kanti konje ngobani abahambayo?” ");
INSERT INTO nde_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","UMosi waphendula wathi, “Sizahamba labatsha labadala bethu; lamadodana lamadodakazi ethu, lemihlambi yethu ngoba kumele senzele uThixo umkhosi.” ");
INSERT INTO nde_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","UFaro wathi, “uThixo kabe lani, kumbe likhumbula ukuthi ngizaliyekela lihambe labesifazane labantwana! Kusobala ukuthi liqonde ukwenza okubi. ");
INSERT INTO nde_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Hatshi! Akuhambe amadoda kuphela; amkhonze uThixo ngoba phela yikho ebelivele likukhalela.” Ngakho uMosi lo-Aroni basebexotshwa phambi kukaFaro. ");
INSERT INTO nde_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","UThixo wasesithi kuMosi, “Yelula isandla sakho phezu kweGibhithe ukuze kwehle isikhongwane, izintethe, kulolonke ilizwe zidle zigugude konke okukhulayo emangweni, konke lokho okwatshiywa yisiqhotho.” ");
INSERT INTO nde_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","UMosi wayiphakamisa intonga yakhe phezu kweGibhithe, uThixo wasequbula umoya wempumalanga wavunguza elizweni lonke ngalelolanga lobusuku bakhona. Ekuseni umoya waletha izintethe. ");
INSERT INTO nde_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Zalihlasela lonke elaseGibhithe zagcwala silikici kuzozonke izindawo zelizwe ngobunengi bazo. Kwakungakaze kube lesikhongwane esingako njalo singeyikufa saba khona njalo lanini. ");
INSERT INTO nde_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Intethe lezo zavala umhlabathi waba mnyama bhuqe. Zatshaya zabhuqa konke okwakusele ngesikhathi sesiqhotho, konke okwakukhula emangweni kanye lezithelo zezihlahla. Akusalanga lutho oluluhlaza ezihlahleni loba isilimo bani kulolonke ilizwe laseGibhithe. ");
INSERT INTO nde_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","UFaro waphanga wabiza uMosi lo-Aroni wathi, “Ngonile kuThixo uNkulunkulu wenu lakini. ");
INSERT INTO nde_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Manje-ke ngixolelani njalo libuye likhuleke kuThixo uNkulunkulu wenu ukuthi asuse loluhlupho olubhubhisayo.” ");
INSERT INTO nde_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","UMosi wasesuka kuFaro wayakhuleka kuThixo. ");
INSERT INTO nde_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","UThixo wasewuguqula umoya waphephetha uvelela entshonalanga ulamandla. Wazidudula izintethe wazitshovela oLwandle Olubomvu. Akusalanga ntethe layinye loba ngaphi eGibhithe. ");
INSERT INTO nde_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Kodwa uThixo wayenza yaba lukhuni inhliziyo kaFaro, kaze abavumela abako-Israyeli ukuthi bahambe. ");
INSERT INTO nde_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","UThixo wasesithi kuMosi, “Yelulela isandla sakho emkhathini ukwenzela ukuthi umnyama wembese iGibhithe lonke, umnyama obambekayo.” ");
INSERT INTO nde_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ngakho uMosi waseselulela isandla sakhe phezulu, kwathi gubu umnyama okhasa phansi, walembesa lonke elaseGibhithe okwensuku ezintathu. ");
INSERT INTO nde_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Kakho owayesabona omunye njalo kakho owayengasuka endaweni yakhe okwalezonsuku ezintathu. Kodwa ama-Israyeli ayelakho ukukhanya ezindaweni ayehlala kuzo. ");
INSERT INTO nde_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","UFaro wasebiza uMosi wathi, “Hambani liyekhonza uThixo. Ngitsho labesifazane benu labantwana hambani labo; litshiye kuphela imihlambi yezifuyo zenu.” ");
INSERT INTO nde_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Kodwa uMosi wathi, “Kumele usivumele ukuthi siyokwenza imihlatshelo leminikelo yokutshiswa kuThixo uNkulunkulu wethu. ");
INSERT INTO nde_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Izifuyo zethu lazo zimele zihambe lathi kungasali lasinye. Kumele siyosebenzisa ezinye zazo ekukhonzeni uThixo uNkulunkulu wethu. Phela kasisoze sazi ukuthi sizasebenzisa siphi isifuyo ukukhonza uThixo size sifike khonale.” ");
INSERT INTO nde_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Kodwa uThixo wayenza yaba lukhuni inhliziyo kaFaro, kaze afuna ukubayekela bahambe. ");
INSERT INTO nde_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","UFaro wathi kuMosi, “Suka phambi kwami! Phinde ngikubone futhi. Mhla wangibona futhi ufile wena.” ");
INSERT INTO nde_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","UMosi waphendula wathi, “Akube njengokuba usitsho. Phinde ungibone njalo lapha.” ");
INSERT INTO nde_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ngalesosikhathi uThixo wathi kuMosi, “Sekusele ukuthi ngehlise uhlupho olulodwa kuFaro laphezu kweGibhithe. Ngemva kwalokho uzaliyekela lisuke lapha, njalo liphume eselixotsha lonke. ");
INSERT INTO nde_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Tshela abantu ukuthi amadoda labafazi ngokufananayo bacele kubomakhelwane babo izinto zesiliva legolide.” ");
INSERT INTO nde_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(UThixo wenza amaGibhithe aba lomusa ebantwini, loMosi uqobo wahlonitshwa kakhulu yizikhulu zikaFaro langabantu.) ");
INSERT INTO nde_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ngakho uMosi wasesithi, “Nanku okutshiwo nguThixo: ‘Phakathi kobusuku ngizahambahamba kulolonke elaseGibhithe. ");
INSERT INTO nde_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Wonke owesilisa olizibulo eGibhithe uzakufa, kusukela ezibulweni likaFaro ohlezi esihlalweni sobukhosi kuthathe kanye lezibulo lesigqili sentombazana esisebenza ukuchola, kanye lamazibulo enkomo uqobo. ");
INSERT INTO nde_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Kuzakuba lesililo esikhulu eGibhithe lonke, isililo esingakaze sibe khona njalo esingayikuba khona lanini. ");
INSERT INTO nde_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Kodwa kwabako-Israyeli akuyikuba lanja ezakhonkotha umuntu loba inyamazana.’ Lapho-ke lizakwazi ukuthi uThixo uyawehlukanisa amaGibhithe kwabako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Zonke izikhulu zakho lezi zizakuza kimi zikhothamisele ubuso phansi phambi kwami zisithi, ‘Hambani, wena labo bonke abakulandelayo!’ Ngemva kwalokho ngizasuka.” UMosi wasesuka kuFaro elokhu ezonde evutha umlilo. ");
INSERT INTO nde_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","UThixo wayesetshilo kuMosi wathi, “UFaro uzaqinisa intamo, ukuze zande izimangaliso zami eGibhithe.” ");
INSERT INTO nde_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","UMosi lo-Aroni bazenza zonke izimangaliso lezi emehlweni kaFaro, kodwa uThixo wayenza yaba lukhuni inhliziyo kaFaro kaze abavumela abako-Israyeli ukuthi baphume elizweni lakhe. ");
INSERT INTO nde_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","UThixo wathi kuMosi lo-Aroni beseGibhithe, ");
INSERT INTO nde_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Inyanga le kayibe yinyanga yakuqala kini, inyanga yokuqala emnyakeni wenu. ");
INSERT INTO nde_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Tshelani bonke abomndeni ka-Israyeli ukuthi ngelanga letshumi lale inyanga indoda ngayinye kayithathele abomuzi wayo izinyane libe linye indlu ngendlu. ");
INSERT INTO nde_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Nxa abendlu bebalutshwana kakhulu ukuthi abangeke baliqede lelozinyane kababelane labomakhelwane abaseduze kwabo kusiya ngenani labo ukuthi bangaki. Kumele uphawule ukuthi kungadingeka izinyane elingakanani kusiya ngokuthi umuntu emunye angadla inyama engakanani. ");
INSERT INTO nde_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Kumele ukhethe amazinyane amaduna alomnyaka owodwa angelasici, njalo ungakhetha ezimvini loba embuzini. ");
INSERT INTO nde_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Agcine amazinyane lawo kuze kube lusuku lwetshumi lane lwenyanga, lapho isizwe sonke sako-Israyeli esizawahlaba khona nxa kuhwalala. ");
INSERT INTO nde_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Lapho-ke kuzamele bathathe igazi baligcobe emaceleni laphezulu kwemigubazi yalezozindlu abazadlela khona amazinyane. ");
INSERT INTO nde_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ngalobobusuku kumele badle inyama eyoswe emlilweni, lesinkwa esingelamvubelo lemibhida ebabayo. ");
INSERT INTO nde_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Lingayidli inyama iluhlaza loba iphekwe ngamanzi, kodwa yoseni emlilweni konke lenhloko yakhona lamangqina kanye lezangaphakathi. ");
INSERT INTO nde_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Lingatshiyi lutho lwayo kuze kube sekuseni; kuthi nxa kukhona okuseleyo kwayo ekuseni kumele likutshise. ");
INSERT INTO nde_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Liboyidla inkalo zenu zibotshiwe, amanyathela egqokiwe lentonga zenu zisezandleni. Lidle ngokuphangisa; kuliPhasika likaThixo. ");
INSERT INTO nde_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Ngalobobusuku ngizadabula phakathi kweGibhithe ngibulala wonke amazibulo abantu lawezinyamazana njalo ngizakwahlulela bonke onkulunkulu bamaGibhithe. Mina nginguThixo. ");
INSERT INTO nde_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Igazi lizakuba yisibonakaliso sezindlu lapho elikhona lina; kuzakuthi ngingabona igazi ngedlule kini. Akulasijeziso esibhidlizayo esizalithinta lina nxa sengichitha iGibhithe. ");
INSERT INTO nde_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Leli akube lilanga lesikhumbuzo, kuthi zonke izizukulwane ezizayo ziligcine ngomkhosi omkhulu kuThixo, kube yisimiso sanini lanini. ");
INSERT INTO nde_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Okwensuku eziyisikhombisa kumele lidle isinkwa esingelamvubelo. Ngelanga lakuqala khuphani imvubelo ezindlini zenu, kuthi lowo odla loba yini elemvubelo ngelanga lakuqala kusiya kwelesikhombisa kumele akhutshwe ko-Israyeli. ");
INSERT INTO nde_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ngosuku lwakuqala lenze umbuthano ongcwele, liphinde omunye ngosuku lwesikhombisa. Lingenzi msebenzi ngamalanga lawa ngaphandle kokulungisa ukudla kwabantu, yikho kodwa elingakwenza. ");
INSERT INTO nde_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Gcinani uMkhosi weSinkwa esingelaMvubelo ngoba kwakulilanga engehlukanisa ngalo amaviyo enu eGibhithe. Gcinani lelilanga njengesimiso sanini lanini kuzizukulwane ezizayo. ");
INSERT INTO nde_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Ngenyanga yakuqala kumele lidle isinkwa esingelamvubelo, kusukela kusihlwa ngelanga letshumi lane kuze kube kusihlwa ngelanga lamatshumi amabili lanye. ");
INSERT INTO nde_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Okwensuku eziyisikhombisa akumelanga kutholakale imvubelo ezindlini zenu. Akuthi lowo odla loba yini elemvubelo asuswe phakathi kwabantu bako-Israyeli, loba engowezizweni kumbe owosendo lwenu. ");
INSERT INTO nde_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Lingadli lutho olufakwe imvubelo. Loba kungaphi elihlala khona libokudla isinkwa esingelamvubelo.” ");
INSERT INTO nde_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ngakho uMosi wasebiza bonke abadala bako-Israyeli wathi kubo, “Hambani khona manje liyokhetha amazinyane ezindlu zenu lihlabe izinyane lePhasika. ");
INSERT INTO nde_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Lithathe ilixha lehisophi liyigxamuze emganwini olegazi beselithatha elinye igazi liligcobe phezulu lakunxa zonke zomgubazi. Akungabikhona lamunye wenu ozaphuma emnyango wendlu yakhe kuze kuse. ");
INSERT INTO nde_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Lapho uThixo edabula phakathi kwelizwe ebulala amaGibhithe uzalibona igazi phezulu lemaceleni omgubazi, aceze awedlule lowomnyango angamvumeli umbhubhisi ukungena endlini alibulale. ");
INSERT INTO nde_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Lalelani imilayo le njengezimiso zaphakade kini lasezizukulwaneni zenu. ");
INSERT INTO nde_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Nxa lingangena elizweni uThixo azalinika lona njengokuthembisa kwakhe, liwugcine umkhosi lo. ");
INSERT INTO nde_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Nxa abantwabenu belibuza besithi, ‘Umkhosi lo ngowani?’ ");
INSERT INTO nde_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","libatshele lithi, ‘UliPhasika lomhlatshelo kaThixo owadlula eceza izindlu zabako-Israyeli eGibhithe, waphephisa imizi yethu mhla egadla amaGibhithe.’ ” Khonapho abantu bakhothama bakhonza. ");
INSERT INTO nde_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Abako-Israyeli bakwenza lokho uThixo akuyala uMosi lo-Aroni. ");
INSERT INTO nde_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Phakathi kobusuku uThixo wawagongoda wonke amazibulo eGibhithe, kusukela ezibulweni likaFaro owayesesihlalweni sobukhosi kusiya ezibulweni lesibotshwa esasisentolongweni, kanye lamazibulo ezifuyo. ");
INSERT INTO nde_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","UFaro lezikhulu zakhe zonke lawo wonke amaGibhithe bavuka ebusuku basiqhinqa isililo esikhulu eGibhithe ngoba kungekho ndlu layinye lapho okwakungafiwanga khona. ");
INSERT INTO nde_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ebusuku uFaro wabiza uMosi lo-Aroni wathi, “Hambani! Sukani ebantwini bami, lina labako-Israyeli. Hambani liyekhonza uThixo njengokucela kwenu. ");
INSERT INTO nde_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Thathani imihlambi yenu, njengokutsho kwenu lihambe. Njalo lingibusise.” ");
INSERT INTO nde_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","AmaGibhithe akhuthaza ukuthi baphangise baphume elizweni. Bathi, “Engxenye singafa sonke!” ");
INSERT INTO nde_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ngakho abantu bathatha inhlama yabo yesinkwa ingakafakwa mvubelo bayithwala emahlombe ngemiganu yokuvubela igoqelwe ngamalembu. ");
INSERT INTO nde_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Abako-Israyeli benza lokho uMosi abayala khona, bacela kumaGibhithe izinto ezenziwe ngesiliva langegolide kanye lezigqoko. ");
INSERT INTO nde_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","UThixo wenza amaGibhithe aba lomusa abapha konke abakucelayo. Ngakho bawemuka impahla ezinengi amaGibhithe. ");
INSERT INTO nde_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Uhambo lwabako-Israyeli lwasukela eRamesesi baqonda eSukhothi. Kwakulamadoda azinkulungwane ezingamakhulu ayisithupha ehamba ngenyawo ngaphandle kwabesifazane labantwana. ");
INSERT INTO nde_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Abanye abantu abanengi bahamba labo kanye lemihlambi eminengi yezifuyo, izimvu lenkomo. ");
INSERT INTO nde_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Inhlama abaphuma layo eGibhithe bapheka ngayo isinkwa esingelamvubelo. Inhlama leyo yayingelamvubelo ngoba basuka eGibhithe sebexotshwa abazabe besaba lesikhathi sokuzilungisela umphako. ");
INSERT INTO nde_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Abako-Israyeli babehlale eGibhithe okweminyaka engamakhulu amane lamatshumi amathathu (430). ");
INSERT INTO nde_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ekupheleni kwaleyominyaka engamakhulu amane lamatshumi amathathu (430) kungeqanga suku wonke amaviyo kaThixo asuka eGibhithe. ");
INSERT INTO nde_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Kwathi ngoba uThixo walinda ngalobobusuku esakhupha abako-Israyeli eGibhithe, yikho-ke labo abako-Israyeli bonke kumele bawugcine umlindo lo behlonipha uThixo kuzozonke izizukulwane ezizayo. ");
INSERT INTO nde_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","UThixo wathi kuMosi lo-Aroni, “Nansi imilayo yePhasika: Akungabi lamuntu wezizweni olidlayo. ");
INSERT INTO nde_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Isigqili esithengwe ngemali singalidla nxa sesisokile, ");
INSERT INTO nde_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","kodwa isihambi sezizweni lesisebenzi esiqhatshiweyo kabavunyelwa ukulidla. ");
INSERT INTO nde_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Kalidlelwe endlini eyodwa, kungabi lanyama ephumela phandle kwendlu. Akungabi lathambo elephulwayo. ");
INSERT INTO nde_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Isizwe sonke sako-Israyeli kumele siwugcine lumkhosi. ");
INSERT INTO nde_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Owezizweni ohlala phakathi kwenu nxa efuna ukulidla iPhasika likaThixo kasoke bonke abesilisa abahlala endlini yakhe. Lapho-ke usengahlanganyela adle njengomunye wenzalo yalelolizwe. Owesilisa ongasokwanga kangalidli. ");
INSERT INTO nde_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Umthetho lo ugoqela bonke abantu, abayinzalo yakini labezizweni abahlala phakathi kwenu.” ");
INSERT INTO nde_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Bonke abako-Israyeli benza khona lokhu uThixo ayekulaye uMosi lo-Aroni. ");
INSERT INTO nde_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Njalo ngalelolanga uThixo wakhupha abako-Israyeli eGibhithe ngamaviyo abo. ");
INSERT INTO nde_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Ngahlukanisela wonke amazibulo esilisa. Konke okuzalwa kuqala phakathi kwabako-Israyeli kungokwami, kungaba ngumuntu loba isifuyo.” ");
INSERT INTO nde_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Ngakho uMosi wasesithi ebantwini, “Lugcineni lube lusuku lwesikhumbuzo lolu, ilanga elaphuma ngalo eGibhithe, liphuma elizweni lobugqili, ngoba uThixo walikhupha khona ngamandla amakhulu. Lingadli lutho olulemvubelo. ");
INSERT INTO nde_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Lamuhla ngenyanga ka-Abhibhi, liyasuka. ");
INSERT INTO nde_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Kuzakuthi uThixo angalifikisa elizweni lamaKhenani, amaHithi, ama-Amori, amaHivi lamaJebusi, ilizwe afunga kubokhokho benu ukuthi uzalinika lona, ilizwe eligeleza uchago loluju, kufanele liwugcine lumkhosi ngayonale inyanga. ");
INSERT INTO nde_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Okwensuku eziyisikhombisa lidle isinkwa esingelamvubelo kuthi ngosuku lwesikhombisa lithakazelele umkhosi kaThixo; ");
INSERT INTO nde_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","kungabonwa lutho olulemvubelo phakathi kwenu, kuvele kungabonwa mvubelo elizweni lenu lonke. ");
INSERT INTO nde_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ngalelolanga ngulowo lalowo atshele indodana yakhe athi, ‘Lokhu ngikwenza ngenxa yalokho uThixo angenzela khona ekuphumeni kwami eGibhithe.’ ");
INSERT INTO nde_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Lesisikhumbuzo kuwe sizakuba luphawu esandleni sakho lesikhumbuzo ebunzini lakho ukuthi umlayo kaThixo ube sezindebeni zakho. Ngoba uThixo wakukhupha eGibhithe ngesandla sakhe esilamandla amakhulu. ");
INSERT INTO nde_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Kalibosigcina lesisimiso ngesikhathi esimisiweyo minyaka yonke. ");
INSERT INTO nde_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Nxa uThixo eselingenisile elizweni lamaKhenani walinika lona njengokuthembisa kwakhe kini lakubokhokho benu, ");
INSERT INTO nde_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","kumele lahlukanisele uThixo konke okuzalwa kuqala yizo zonke izibeletho. Wonke amazibulo esilisa ezifuyo zenu ngakaThixo. ");
INSERT INTO nde_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Lizahlenga izibulo likababhemi ngezinyane, kodwa nxa lingalihlenganga lephuleni intamo. Lihlenge njalo wonke amadodana enu angamazibulo. ");
INSERT INTO nde_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Nxa indodana yakho ikubuza ngesikhathi esizayo isithi, ‘Kutshoni lokhu?’ ubokuthi kuyo, ‘uThixo wasikhupha eGibhithe ngesandla sakhe esilamandla amakhulu, wasikhupha elizweni lobugqili. ");
INSERT INTO nde_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Kwathi uFaro eqholoza esala ukuthi sihambe, uThixo wabulala wonke amazibulo eGibhithe, awabantu lawezinyamazana. Yikho-nje nginikela kuThixo izibulo lesilisa lenzalo yonke ngiphinde ngihlenge wonke amadodana ami angamazibulo.’ ");
INSERT INTO nde_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Lokhu kuzakuba njengophawu esandleni sakho lesibonelo ebunzini lakho ukuthi uThixo wakukhupha eGibhithe ngesandla sakhe esilamandla amakhulu.” ");
INSERT INTO nde_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","UFaro esebavumele abantu ukuthi bahambe, uNkulunkulu kabakhokhelanga ngendlela edabula elizweni lamaFilistiya loba yona yayiquma. Ngoba uNkulunkulu wathi, “Nxa behlangana lempi mhlawumbe bangethuka babuyele eGibhithe.” ");
INSERT INTO nde_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Yikho uNkulunkulu wabahola ngendlela yenkangala eya oLwandle Olubomvu. Abako-Israyeli baphuma eGibhithe behlomele impi. ");
INSERT INTO nde_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","UMosi wawathwala amathambo kaJosefa ngoba uJosefa wayenze isifungo lamadodana ka-Israyeli wathi, “Ngempela uNkulunkulu uzalikhulula. Lapho-ke libowathwala amathambo ami lisuke lawo kule indawo.” ");
INSERT INTO nde_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Sebesukile eSukhothi bayamisa e-Ethamu indawo egudlene lenkangala. ");
INSERT INTO nde_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Emini uThixo wahamba phambi kwabo ngensika yeyezi ebahola endleleni yabo, kwathi ebusuku wabahola ngensika yomlilo ukubakhanyisela ukuze bahambe emini lebusuku. ");
INSERT INTO nde_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Insika yeyezi emini loba insika yomlilo ebusuku kakuzange kusuke endaweni yakho phambi kwabantu. ");
INSERT INTO nde_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Tshela abako-Israyeli ukuthi babuyele emuva bayomisa ePhi-Hahirothi phakathi laphakathi kweMigidoli lolwandle. Kabamise eceleni kolwandle malungana leBhali-Zefoni. ");
INSERT INTO nde_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","UFaro uzacabanga ukuthi abako-Israyeli bayantula nje elizweni besangene ngoba sebesithwe yinkangala. ");
INSERT INTO nde_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Njalo ngizayenza ibe lukhuni inhliziyo kaFaro abeselandela exotshana labo. Kodwa ngizazizuzela udumo ngoFaro kanye lempi yakhe yonke, lamaGibhithe azakwazi ukuthi mina nginguThixo.” Ngakho abako-Israyeli bakwenza lokhu. ");
INSERT INTO nde_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Kwathi inkosi yaseGibhithe isitsheliwe ukuthi abantu sebebalekile, uFaro lezikhulu zakhe baguqula ingqondo zabo ngabako-Israyeli bathi, “Sesenzeni manje? Sesiyekele abako-Israyeli bahamba salahlekelwa yikusetshenzelwa yibo!” ");
INSERT INTO nde_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","UFaro waselungisa inqola yakhe yamabhiza waphuma lempi yakhe. ");
INSERT INTO nde_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Wathatha izinqola ezikhethekileyo ezingamakhulu ayisithupha zahamba kanye lezinye izinqola zaseGibhithe, yinye ngayinye ilenduna yayo. ");
INSERT INTO nde_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","UThixo wayenza yaba lukhuni inhliziyo kaFaro inkosi yaseGibhithe, ngakho waxotshana labako-Israyeli ababehamba ngesibindi. ");
INSERT INTO nde_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","AmaGibhithe kugoqela wonke amabhiza kaFaro lezinqola, abagadi bamabhiza lamabutho, abaxhuma abako-Israyeli abedlula bemise ngasolwandle eduzane lePhi-Hahirothi malungana leBhali-Zefoni. ");
INSERT INTO nde_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Kwathi uFaro esondela abako-Israyeli bathi bevusa amehlo babona nanko amaGibhithe asebanxwanele. Besaba bathuthumela bakhala kuThixo. ");
INSERT INTO nde_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Bathi kuMosi, “Kambe yikuthi kwakungelamangcwaba yini eGibhithe uze usilethe lapha enkangala ukuba sizofela khona? Manje wenzeni ngokusikhupha eGibhithe? ");
INSERT INTO nde_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Asitshongo kuwe yini siseGibhithe ukuthi siyekele? Satsho sathi siyekele sikhonze amaGibhithe. Kwakuzaba ngcono kithi ukukhonza amaGibhithe kulokufela enkangala!” ");
INSERT INTO nde_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","UMosi wabaphendula abantu wathi, “Lingesabi. Manini isibindi, lizabona ukuthi uThixo uzalihlenga njani lamuhla. AmaGibhithe eliwabonayo lamuhla kalisoze liphinde liwabone futhi. ");
INSERT INTO nde_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","UThixo uzalilwela; lina manini lithule.” ");
INSERT INTO nde_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ngakho uThixo wasesithi kuMosi, “Kanti ukhalelani kimi na? Tshela abako-Israyeli baphume bahambe. ");
INSERT INTO nde_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Phakamisa intonga yakho welulele isandla sakho phezu kolwandle amanzi adabuke phakathi ukuze abako-Israyeli bahambe phakathi kolwandle emhlabathini owomileyo. ");
INSERT INTO nde_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ngizazenza zibe lukhuni inhliziyo zamaGibhithe ukuze angene abaxhume. Njalo ngizazuza udumo ngoFaro lempi yakhe yonke, langezinqola zakhe labagadi bakhe bamabhiza. ");
INSERT INTO nde_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","AmaGibhithe azakwazi ukuthi mina yimi uThixo nxa sengizuza udumo ngoFaro, langezinqola zakhe labagadi bakhe bamabhiza.” ");
INSERT INTO nde_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Kwathi khonapho ingilosi kaNkulunkulu eyayikade ihamba phambili kwempi yabako-Israyeli yasuka yabhoda ngemva kwabo. Insika yeyezi layo yasuka phambili yayakuma ngemva kwabo, ");
INSERT INTO nde_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","yehlukanisa impi yamaGibhithe leyabako-Israyeli. Ubusuku bonke iyezi laletha ubumnyama kwelinye icele labuye laletha ukukhanya ngakwelinye icele; ngakho kabakho abasondela kwabanye ubusuku bonke. ");
INSERT INTO nde_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ngakho uMosi waseselulela isandla sakhe phezu kolwandle, ngalobobusuku uThixo wafuqela ulwandle emuva ngomoya wempumalanga olamandla kwasala umhlabathi owomileyo. Amanzi adabukana phakathi, ");
INSERT INTO nde_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","abako-Israyeli bazihambela phakathi kolwandle emhlabathini owomileyo amanzi ezindonga ngapha langapha kwabo. ");
INSERT INTO nde_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","AmaGibhithe abalandela, amabhiza wonke kaFaro, izinqola labagadi bamabhiza bonke babalandela phakathi kolwandle. ");
INSERT INTO nde_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Kwathi ngomlindo wokucina wobusuku uThixo wakhangela phansi esensikeni yomlilo leyezi, wakhangela phansi empini yamaGibhithe wayidunga yasanganiseka. ");
INSERT INTO nde_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Wenza ukuthi amavili ezinqola zawo akhumuke okwenza kwaba nzima ukuthi aqhubeke lula. AmaGibhithe asesithi, “Kasehlukaneni labako-Israyeli! UThixo uyabalwela ukuba behlule amaGibhithe.” ");
INSERT INTO nde_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","UThixo wasesithi kuMosi, “Phakamisa isandla sakho phezu kolwandle ukuze amanzi abuyele ambokothe amaGibhithe lezinqola zawo labagadi bamabhiza.” ");
INSERT INTO nde_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","UMosi waseselula isandla sakhe phezu kolwandle, kwathi emadabukakusa amanzi abuyela endaweni yawo. AmaGibhithe ayebaleka eqonda emanzini, uThixo wawagubuzela ngamanzi olwandle. ");
INSERT INTO nde_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Amanzi aqubuka abuyela emuva ambokotha izinqola labagadi bamabhiza, layo yonke impi kaFaro eyalandela abako-Israyeli olwandle. Akusilanga loyedwa kubo. ");
INSERT INTO nde_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Kodwa abako-Israyeli badabula olwandle emhlabathini owomileyo kulezindonga zamanzi esandleni sokudla lakwesokhohlo. ");
INSERT INTO nde_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ngalolosuku uThixo wasindisa u-Israyeli ezandleni zamaGibhithe, njalo abako-Israyeli bawabona amaGibhithe ethe dandalazi okhunjini lolwandle esefile. ");
INSERT INTO nde_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Kwathi abako-Israyeli bebona amandla amakhulu uThixo awatshengisa kumaGibhithe, abantu bamesaba uThixo babeka ithemba labo kuye lakuMosi inceku yakhe. ");
INSERT INTO nde_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ngakho uMosi labako-Israyeli basebehlabelela lelihubo kuThixo: “Ngizamhlabelela uThixo ngoba uphakeme kakhulu. Ibhiza lomgadi walo ukuphosele ngamandla olwandle. ");
INSERT INTO nde_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","UThixo ungamandla ami lehubo lami; useyikusindiswa kwami. UnguNkulunkulu wami, ngizamdumisa; uNkulunkulu kababa ngizamphakamisa. ");
INSERT INTO nde_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","UThixo ulibutho; nguThixo ibizo lakhe. ");
INSERT INTO nde_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Izinqola zikaFaro lempi yakhe ukuphosele ngamandla olwandle. Izikhulu zikaFaro ezithenjiweyo, zigalule oLwandle oluBomvu. ");
INSERT INTO nde_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Inziki zamanzi zibagubuzele; batshona ekujuleni njengelitshe. ");
INSERT INTO nde_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Isandla sakho sokunene, Oh Thixo, saba lamandla obukhosi. Isandla sakho sokunene, Oh Thixo, sasihlikiza isitha. ");
INSERT INTO nde_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ebukhulwini bobukhosi bakho wabasakazela phansi abakuphikisayo. Wavulela ulaka lwakho oluvuthayo, lwabatshisa njengencwathi. ");
INSERT INTO nde_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ngokuphefumula kwamakhala akho amanzi aqoqana aba yinqwaba. Amanzi ageleza ngenhlokomo ema enza udonga; amanzi azikileyo ajiya enzikini yolwandle. ");
INSERT INTO nde_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Isitha sakloloda sathi, ‘Ngizabaxhuma, ngibedlule. Ngizakwaba impango; ngizazitika ngokungokwabo. Ngizakhokha inkemba yami, isandla sami sibabhubhise.’ ");
INSERT INTO nde_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Kodwa wena wavuthela ngomoya wokuphefumula kwakho, ulwandle lwabasibekela. Batshona njengomnuso emanzini esabekayo. ");
INSERT INTO nde_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Ngubani kubonkulunkulu bonke onjengawe, Thixo? Ngubani onjengawe, olobukhosi ebungcweleni bakhe, owesabekayo ngenkazimulo, owenza izimangaliso? ");
INSERT INTO nde_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Welula isandla sakho sokunene umhlabathi uziginye izitha zakho. ");
INSERT INTO nde_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ngothando lwakho olungapheliyo uzabahola abantu obahlengileyo. Ngamandla akho uzabaholela endaweni yakho engcwele. ");
INSERT INTO nde_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Izizwe zizakuzwa zithuthumele; umhedehede ubahlukuluze abantu baseFilistiya. ");
INSERT INTO nde_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Izinduna zase-Edomi zizatshaywa luvalo, abakhokheli baseMowabi bafikelwe yikwesaba, abantu baseKhenani banyamalale nya! ");
INSERT INTO nde_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ukwesaba lokuthuthumela kuzabehlela. Ngamandla engalo yakho, bazathula njengelitshe, abantu bakho baze bedlule, Oh Thixo, abantu owabadalayo baze bedlule. ");
INSERT INTO nde_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Uzabangenisa ubahlanyele entabeni yelifa lakho, indawo, Oh Thixo, owayenzela ukuthi uhlale kuyo, indawo engcwele, Oh Thixo, eyamiswa ngezandla zakho. ");
INSERT INTO nde_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","UThixo uzabusa kuze kube nini lanini.” ");
INSERT INTO nde_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Kwathi lapho amabhiza kaFaro, izinqola kanye labagadi bamabhiza sebengenile olwandle, uThixo wawabuyisa amanzi alo phezu kwabo, kodwa abako-Israyeli bona bazihambela badabula ulwandle phezu komhlabathi owomileyo. ");
INSERT INTO nde_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Khonapho uMiriyemu umphrofethikazi, udadewabo ka-Aroni, wathatha isigubhu sakhe ngesandla, bamlandela bonke abesifazane bephethe izigubhu begida. ");
INSERT INTO nde_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","UMiriyemu wabahlabelela wathi: “Mhlabeleleni uThixo ngoba uphakeme kakhulu. Ibhiza lomgadi walo ukuphosele ngamandla olwandle.” ");
INSERT INTO nde_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","UMosi wasebahola abako-Israyeli basuka oLwandle Olubomvu baya enkangala yeShuri bengatholi manzi. ");
INSERT INTO nde_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Kwathi befika eMara behluleka ukunatha amanzi akhona ngoba ayebaba. (Yikho indawo leyo kuthiwa yiMara.) ");
INSERT INTO nde_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Abantu basebekhonona kuMosi besithi, “Sinatheni-ke manje?” ");
INSERT INTO nde_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","UMosi wasekhala kuThixo, uThixo wasemtshengisa isigojwana. Wasiphosela emanzini, amanzi aphenduka aba mnandi. Khonapho uThixo wabenzela isimiso lomthetho, njalo khonapho wabalinga. ");
INSERT INTO nde_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Wathi, “Nxa lilalela kakuhle ilizwi likaThixo uNkulunkulu wenu, lenze okulungileyo kuye, lilandele imilayo yakhe njalo ligcine lezimiso zakhe, kangisoze ngilehlisele iziga lezo engazehlisela amaGibhithe; ngoba nginguThixo olisilisayo.” ");
INSERT INTO nde_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Basebefika e-Elimi lapho okwakulemithombo yamanzi elitshumi lambili khona, lezihlahla zelala ezingamatshumi ayisikhombisa. Basebemisa khona lapho eduze kwamanzi. ");
INSERT INTO nde_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Uzulu wonke wako-Israyeli wasuka e-Elimi, wafika enkangala yeSini ephakathi laphakathi kwe-Elimi leSinayi ngelanga letshumi lanhlanu enyangeni yesibili besuke eGibhithe. ");
INSERT INTO nde_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Enkangala uzulu wakhonona kuMosi lo-Aroni. ");
INSERT INTO nde_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Abako-Israyeli bathi kubo, “Ngabe sazifela ngesandla sikaThixo eGibhithe, lapho esasihlala sigombolozele imbiza zenyama lakho konke ukudla esasikufumana, kodwa lina selisilethe lapha enkangala ukuze ixuku lonke leli liyathe ngendlala.” ");
INSERT INTO nde_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","UThixo wasesithi kuMosi, “Ngizalehlisela isinkwa sivela ezulwini. Abantu kumele baphume nsuku zonke bayebutha okwanela lelolanga. Ngale indlela ngizabalinga ukuze ngibone ukuthi bayayilandela yini imilayo yami. ");
INSERT INTO nde_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ngelanga lesithupha kumele balungise lokho abayabe bekulethile, okumele kube ngokuphindwe kabili kulokho abakubutha kwezinye insuku.” ");
INSERT INTO nde_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Yikho-ke uMosi lo-Aroni bathi kubo bonke abako-Israyeli, “Kusihlwa lizakwazi ukuthi nguThixo olikhuphe kweleGibhithe, ");
INSERT INTO nde_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","njalo ekuseni lizabona inkazimulo kaThixo ngoba ukuzwile ukukhonona kwenu. Singobani thina ukuba lisisole?” ");
INSERT INTO nde_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","UMosi wathi, “Lizakwazi ukuthi bekunguThixo nxa eselipha inyama yokudla kusihlwa lesinkwa sonke elisifunayo ekuseni ngenxa yokuthi usekuzwile ukukhonona kwenu kuye. Singobani? Kalikhononi kithi kodwa kuThixo.” ");
INSERT INTO nde_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ngakho uMosi watshela u-Aroni wathi, “Khuluma lozulu wonke wako-Israyeli uthi, ‘Wozani kuThixo ngoba usekuzwile ukukhonona kwenu.’ ” ");
INSERT INTO nde_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ngesikhathi u-Aroni ekhuluma lozulu wonke wako-Israyeli, bakhangela enkangala basebebona inkazimulo kaThixo ibonakala eyezini. ");
INSERT INTO nde_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","UThixo wathi kuMosi: ");
INSERT INTO nde_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Sengizwile ukukhonona kwabako-Israyeli. Batshele ukuthi, ‘Kusihlwa lizakudla inyama njalo ekuseni lizasuthiswa ngesinkwa. Lapho-ke lizakwazi ukuthi nginguThixo uNkulunkulu wenu.’ ” ");
INSERT INTO nde_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ngalokhokuhlwa kweza izagwaca zagcwala indawo yonke ababehlala kuyo, njalo ekuseni kwaba lamazolo ngaphandle kwezihonqo. ");
INSERT INTO nde_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Kwathi amazolo esenyamalele kwabonakala izicecedwana ezifana longqwaqwane phezu kwenkangala. ");
INSERT INTO nde_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Kwathi abako-Israyeli bekubona lokhu bakhulumisana besithi, “Kuyini lokhu?” Ngoba babengakwazi ukuthi kwakuyini. UMosi wathi kubo, “Yisinkwa elisiphiwe nguThixo ukuthi lidle. ");
INSERT INTO nde_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Lokhu yikho okulaywe nguThixo ukuthi: ‘Umuntu emunye uzathatha okwaneleyo akuswelayo. Thathela umuntu ngamunye osethenteni lakho isilinganiso se-omeri.’ ” ");
INSERT INTO nde_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Abako-Israyeli benza njengokulaywa kwabo. Abanye babutha okunengi abanye okulutshwana. ");
INSERT INTO nde_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Bathi sebekulinganisa nge-omeri babona ukuthi lowo owabutha okunengi kabanga lokunengi kakhulu, lalowo owabutha okulutshwana kabanga lokulutshwana kakhulu. Umuntu wonke wabutha okwakumenela. ");
INSERT INTO nde_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ngakho-ke uMosi wathi kubo, “Akumelanga kubekhona ozagcina okunye kwalokho kuze kube sekuseni.” ");
INSERT INTO nde_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Lanxa kunjalo abanye kabazange bamlalele uMosi: bagcina eyinye ingxenye kwaze kwaba sekuseni. Kodwa kwakugcwele impethu njalo kwasekulephunga elibi. UMosi wabathukuthelela. ");
INSERT INTO nde_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Nsuku zonke ekuseni umuntu emunye wabutha isilinganiso ayesifuna, njalo ilanga lathi selitshisa kwancibilika. ");
INSERT INTO nde_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ngelanga lesithupha babutha isilinganiso esiphindwe kabili ama-omeri amabili umuntu emunye, njalo abakhokheli babantu beza ukuzobika kuMosi. ");
INSERT INTO nde_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Wathi kubo, “Lokhu yikho okwalaywa nguThixo: ‘Kusasa lilanga lokuphumula iSabatha elingcwele kuThixo. Ngakho bhekhani konke elifuna ukukubhekha, libilise konke elifuna ukukubilisa. Gcinani konke okuseleyo kuze kube sekuseni.’ ” ");
INSERT INTO nde_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ngakho bakugcina kwaze kwaba sekuseni njengokulaya kukaMosi njalo kakuzange kube lephunga kumbe impethu. ");
INSERT INTO nde_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","UMosi wathi, “Kudleni namuhla, ngoba namuhla liSabatha likaThixo, kalisoze lithole lutho phandle namuhla. ");
INSERT INTO nde_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Okwensuku eziyisithupha lizakubutha, kodwa ngelanga lesikhombisa eleSabatha akusoze kube lalutho.” ");
INSERT INTO nde_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Lanxa kunjalo abanye abantu ngelanga lesikhombisa bahamba ukuba bayobutha kodwa bafica kungelalutho. ");
INSERT INTO nde_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","UThixo wasesithi kuMosi, “Kuzaze kube nini lisala ukulandela imithetho lemilayo yami na? ");
INSERT INTO nde_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Kufakeni ezingqondweni zenu ukuthi uThixo ulinikile iSabatha, yikho ngelanga lesithupha elinika isinkwa esenela insuku ezimbili. Wonke umuntu kumele ahlale lapho ayabe ekhona ngelanga lesikhombisa. Akulamuntu okumele aphume phandle.” ");
INSERT INTO nde_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Yikho-ke abantu baphumula ngelanga lesikhombisa. ");
INSERT INTO nde_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Abantu bako-Israyeli babiza isinkwa leso bathi yimana. Sasimhlophe njengentanga zekhoriyanda, sihlabusa njengamakhekhe enziwe ngoluju. ");
INSERT INTO nde_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","UMosi wathi, “Lokhu yikho okutshiwo nguThixo ukuthi: ‘Thathani imana eyisilinganiso se-omeri ligcinele izizukulwane ezizayo ukuze zibone isinkwa engalinika sona ukuba lisidle enkangala ekulikhupheni kwami eGibhithe.’ ” ");
INSERT INTO nde_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","UMosi wasesithi ku-Aroni, “Thatha inkonxa ufake phakathi imana eyisilinganiso se-omeri. Ibeke phambi kukaThixo ukuze igcinelwe izizukulwane ezizayo.” ");
INSERT INTO nde_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Njengoba uThixo walaya uMosi, u-Aroni wabeka imana lezibhebhedu zobufakazi ukuze igcinakale. ");
INSERT INTO nde_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Abako-Israyeli badla imana okweminyaka engamatshumi amane baze bafika endaweni eyayihlala abantu, badla imana baze bafika emngceleni weKhenani. ");
INSERT INTO nde_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(I-omere iyisilinganiso sokulitshumi sehefa.) ");
INSERT INTO nde_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Uzulu wonke wako-Israyeli wasuka enkangala yeSini, wahamba njengokulaya kukaThixo. Bake bahlala okwesikhathi esifitshane eRefidimu kodwa kwakungelamanzi okuthi abantu banathe. ");
INSERT INTO nde_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Ngakho baxabana loMosi basebesithi, “Sinike amanzi okunatha.” UMosi waphendula wathi “Kungani lixabana lami? Kungani lilinga uThixo?” ");
INSERT INTO nde_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Kodwa abantu basebomele amanzi kuleyondawo, ngakho bakhonona kuMosi. Bathi kuye, “Wasikhupha eGibhithe ukwenzela ukuthi thina labantwabethu kanye lezifuyo sibulawe yikoma na?” ");
INSERT INTO nde_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Ngakho uMosi wakhala kuThixo, wathi, “Kambe ngithini ngalababantu? Sebezimisele ukuthi bangikhande ngamatshe.” ");
INSERT INTO nde_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","UThixo waphendula uMosi wathi “Khokhela abantu. Thatha abanye abadala bako-Israyeli ubusuthatha njalo intonga leyana owake watshaya ngayo amanzi emfuleni uNayili lihambe. ");
INSERT INTO nde_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ngizakuma lapho phambi kwenu eduzane ledwala eHorebhi. Utshaye idwala; kuzaphuma amanzi kulo ukuba abantu banathe.” Ngakho uMosi wenza lokho abadala bako-Israyeli bekhangele. ");
INSERT INTO nde_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Wabiza indawo leyo ngegama elithi Masa leMeribha ngenxa yokuthi abantu bako-Israyeli baxabana njalo balinga uThixo besithi “Kambe uThixo ulathi yini kumbe hatshi?” ");
INSERT INTO nde_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Ama-Amaleki eza ukuzohlasela abako-Israyeli eRefidimu. ");
INSERT INTO nde_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","UMosi wathi kuJoshuwa, “Khetha amanye amadoda phakathi kwethu uphume liyekulwa lama-Amaleki. Kusasa ngizakuma phezu koqaqa ngiphethe intonga kaNkulunkulu ezandleni zami.” ");
INSERT INTO nde_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Ngakho uJoshuwa walwa lama-Amaleki njengokulaya kukaMosi, njalo uMosi, u-Aroni loHuri bakhwela phezu koqaqa. ");
INSERT INTO nde_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Kwakusithi nxa uMosi ephakamise izandla zakhe abako-Israyeli babenqoba, kodwa wayesithi angehlisa izandla zakhe ama-Amaleki yiwo ayenqoba. ");
INSERT INTO nde_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Kwathi izandla zikaMosi sezidiniwe bathatha ilitshe balifaka ngaphansi kwakhe wasehlala phezu kwalo. U-Aroni loHuri baphakamisa izandla zakhe, omunye ekuleli icele omunye kwelinye ukuze izandla zakhe zale ziphakeme laze latshona ilanga. ");
INSERT INTO nde_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ngakho uJoshuwa wehlula ibutho lama-Amaleki ngenkemba. ");
INSERT INTO nde_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","UThixo wasesithi kuMosi, “Bhala lokhu ogwalweni njengento okumele ikhunjulwe njalo ubone ukuthi uJoshuwa uyakuzwa lokhu ngenxa yokuthi ngizatshabalalisa umkhumbulo wonke omayelana lama-Amaleki ngaphansi kwezulu.” ");
INSERT INTO nde_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","UMosi wakha i-alithari walibiza ngokuthi uThixo uLuphawu Lwami. ");
INSERT INTO nde_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Wathi, “Ngoba izandla zaphakanyiselwa esihlalweni sikaThixo. UThixo uzakulwa impi lezizukulwane zama-Amaleki.” ");
INSERT INTO nde_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","UJethro, umphristi waseMidiyani owayenguyisezala kaMosi, wezwa konke uNkulunkulu ayekwenzele uMosi labantu bakhe bako-Israyeli, lokuthi uThixo wayebakhuphe njani eGibhithe abako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Ngemva kokuba uMosi esethumele umkakhe uZiphora kibo, uyisezala uJethro wamemukela, ");
INSERT INTO nde_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","lamadodana akhe amabili. Eyinye indodana kwakuthiwa nguGeshomu, ngoba uMosi wathi, “Sengibe ngumuntu wezizweni elizweni elingayisilo lami.” ");
INSERT INTO nde_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Eyinye kwakuthiwa ngu-Eliyezari ngoba wathi, “UNkulunkulu kababa wayengumsizi wami: wangisindisa enkembeni kaFaro.” ");
INSERT INTO nde_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","UJethro, uyisezala kaMosi kanye lamadodana lenkosikazi kaMosi beza kuye enkangala lapho ayehlala khona eduzane lentaba kaNkulunkulu. ");
INSERT INTO nde_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","UJethro wayethumele ilizwi kuye wathi, “Mina uyihlozala uJethro ngiyeza kuwe lenkosikazi yakho lamadodana ayo amabili.” ");
INSERT INTO nde_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Ngakho uMosi waphuma wayahlangabeza uyisezala wasemkhothamela, wamanga. Babingelelana basebengena ethenteni. ");
INSERT INTO nde_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","UMosi watshela uyisezala ngakho konke uThixo ayekwenze kuFaro labantu baseGibhithe ngenxa yabantu bako-Israyeli langezinhlupho zonke ezabehlela endleleni lokuthi uThixo wayebasindise njani. ");
INSERT INTO nde_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","UJethro wathokoza ukuzwa ngezinto zonke ezinhle uThixo ayezenzele u-Israyeli ekubasindiseni esandleni samaGibhithe. ");
INSERT INTO nde_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Wathi, “Kadunyiswe uThixo owalisindisa esandleni samaGibhithe loFaro, njalo owasindisa abantu esandleni samaGibhithe. ");
INSERT INTO nde_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Khathesi sengikwazi ukuthi uThixo ulamandla ukwedlula abanye onkulunkulu ngenxa yokuthi wenza lokhu kubo bonke abaphatha u-Israyeli ngobuqholo.” ");
INSERT INTO nde_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Lapho-ke uJethro, uyisezala kaMosi, waletha umnikelo wokutshiswa leminye imihlatshelo kuNkulunkulu, njalo u-Aroni weza labadala bako-Israyeli ukuze bazokudla isinkwa loyisezala kaMosi phambi kukaNkulunkulu. ");
INSERT INTO nde_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ngelanga elilandelayo uMosi wathatha isihlalo sakhe sokuba ngumthonisi wabantu, njalo bema bemgombolozele kusukela ekuseni kwaze kwaba ntambama. ");
INSERT INTO nde_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Kwathi uyisezala esebone konke uMosi ayekwenzela abantu wathi, “Kuyini lokhu okwenzela abantu? Kungani uhlala unguwe wedwa ukuba ngumahluli, abantu bonke bemi bekuhanqile kusukela ekuseni kuze kube kusihlwa?” ");
INSERT INTO nde_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","UMosi wamphendula wathi, “Ngenxa yokuthi abantu beza kimi ukuzodinga intando kaNkulunkulu. ");
INSERT INTO nde_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Lapho kusiba lengxabano, ilethwa kimi, njalo ngiyahlulela emaceleni womabili besengibatshela ngemithetho lemilayo kaNkulunkulu.” ");
INSERT INTO nde_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Uyisezala kaMosi waphendula wathi, “Konke okwenzayo kakulunganga. ");
INSERT INTO nde_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Wena labantu laba abeza kuwe lizazidinisa. Umsebenzi lo unzima kuwe: ungeke wawenza wedwa. ");
INSERT INTO nde_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ngilalela ngikucebise, njalo uNkulunkulu makabe lawe. Kumele ube ngummeli wabantu kuNkulunkulu, ulethe ingxabano zabo kuye. ");
INSERT INTO nde_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Bafundise izimiso lemithetho yakhe, ubatshengise indlela yokuphila lokuthi baziphathe njani. ");
INSERT INTO nde_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Kodwa khetha amadoda alamandla phakathi kwabantu bonke, amadoda amesabayo uNkulunkulu, azonda inzuzo eza ngobuqili, ubusubabeka babe zinduna zezinkulungwane, zamakhulu, zamatshumi amahlanu, lezamatshumi. ");
INSERT INTO nde_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Benze babe ngabahluleli babantu ngezikhathi zonke, kodwa kabalethe wonke amacala anzima kuwe bona baqume amacala alula. Lokho kuzakwenza ukuthi umthwalo wakho ube lula ngoba bazabe besabelana lawe. ");
INSERT INTO nde_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Nxa ungakwenza lokhu njengokulaya kukaNkulunkulu, uzakwenelisa ukuphumuza ingqondo njalo abantu bonke laba bazabuyela emakhaya besuthisekile.” ");
INSERT INTO nde_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","UMosi wamlalela uyisezala wenza konke ayekutshilo. ");
INSERT INTO nde_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Wakhetha amadoda alamandla phakathi kwabako-Israyeli wonke wawenza abakhokheli babantu, izinduna zezinkulungwane, ezamakhulu, ezamatshumi amahlanu lezamatshumi. ");
INSERT INTO nde_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Baba ngabahluleli babantu ngazozonke izikhathi. Amacala anzima bawaletha kuMosi, kodwa alula bawathonisa bona ngokwabo. ");
INSERT INTO nde_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","UMosi wavalelisana loyisezala, uJethro wasebuyela elizweni lakhe. ");
INSERT INTO nde_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Ngosuku olufanayo, emva kwezinyanga ezintathu abantu bako-Israyeli besuke eGibhithe bafika enkangala yeSinayi. ");
INSERT INTO nde_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Sebesukile eRefidimu bangena enkangala yeSinayi bamisa amathente abo phansi kwentaba. ");
INSERT INTO nde_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Lapho-ke uMosi wakhuphukela kuNkulunkulu entabeni, uThixo esentabeni wabiza uMosi wathi kuye, “Tshela abantu bendlu kaJakhobe labantu bako-Israyeli, uthi ");
INSERT INTO nde_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Lina ngokwenu lizibonele engikwenze eGibhithe lokuthi ngilithwele ngamaphiko okhozi ngaliletha lapha kimi. ");
INSERT INTO nde_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ngakho-ke lingangilalela ligcine isivumelwano sami lani lizakuba ligugu kimi phakathi kwezizwe zonke. Lanxa umhlaba wonke ungowami, ");
INSERT INTO nde_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","lina kimi lizakuba ngumbuso wabaphristi lesizwe esingcwele.’ Yiwo amazwi okumele uwakhulume kwabako-Israyeli.” ");
INSERT INTO nde_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","UMosi wabuyela ebantwini, wafika wabuthanisa abakhokheli babantu wabatshela okwakutshiwo nguThixo. ");
INSERT INTO nde_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Bonke bavuma ngalizwi linye bathi, “Sizakwenza konke uThixo athe sikwenze.” UMosi wambikela uThixo okwakukhulunywe ngabantu. ");
INSERT INTO nde_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","UThixo wasesithi kuMosi, “Ngizakuza kini nginjengeyezi elimnyama ukuze abantu bangizwe ngikhuluma lawe. Ngakho ngezikhathi zonke bazakholwa kuwe.” UMosi watshela uThixo okwakutshiwo ngabantu. ");
INSERT INTO nde_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ngakho uThixo wathi kuMosi, “Buyela ebantwini ubangcwelise lamhla lakusasa. Batshele bagezise izigqoko zabo ");
INSERT INTO nde_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","kuthi ngelanga lesithathu libe selilungiselele ngoba ngalelolanga uThixo uzakwehlela entabeni yeSinayi abantu bonke bekhangele. ");
INSERT INTO nde_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Yenzela abantu imingcele malungana lentaba, ubatshele uthi, ‘Limukani! Lingakhweli entabeni, kumbe ukufika phansi kwayo. Lowo ozasondela entabeni uzabulawa.’ ");
INSERT INTO nde_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ngempela uzatshaywa ngamatshe kumbe acitshwe ngemitshoko kodwa angathintwa ngesandla. Akukhathalekile ukuthi ngumuntu loba yinyamazana akusoze kuvunyelwe ukuphila. Bazakhwela entabeni kuphela nxa uphondo lwenqama selukhale isikhathi eside.” ");
INSERT INTO nde_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Ngemva kokuba uMosi esehlile entabeni waya ebantwini wabangcwelisa basebegezisa lezigqoko zabo. ");
INSERT INTO nde_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Wathi ebantwini, “Lungiselelani ilanga lesithathu. Zilani omkenu.” ");
INSERT INTO nde_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ekuseni ngelanga lesithathu kwaba lomdumo lombane othuthumelisayo, leyezi elikhulukazi lehlela phezu kwentaba, kwezwakala lomsindo omkhulu wecilongo. Abantu bonke ezihonqweni besaba, baqhaqhazela. ");
INSERT INTO nde_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","UMosi wasebakhokhela ebasusa emathenteni ebasa kuNkulunkulu. Bafika bema ngaphansi kwentaba. ");
INSERT INTO nde_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Intaba yonke iSinayi yembeswa yintuthu ngoba uThixo wehlela phezu kwayo ngesimo somlilo. Intuthu yathunqa ngamandla isiya phezulu kungathi iphuma emphongolweni. ");
INSERT INTO nde_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Njalo umsindo wecilongo waya ulokhu ukhula. UMosi wakhuluma, kwathi ilizwi likaNkulunkulu lamphendula. ");
INSERT INTO nde_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","UThixo wehlela phezu kwentaba iSinayi, wabizela uMosi khona. Ngakho uMosi wakhwela, ");
INSERT INTO nde_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","UThixo wasesithi kuye, “Buyela phansi uyexwayisa abantu ukuba bangaqali ukweqa imingcele ukuba babone uThixo ngoba bangafa ngobunengi. ");
INSERT INTO nde_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Labaphristi abaya kuThixo kumele bazenze babengcwele, funa uThixo ababhubhise.” ");
INSERT INTO nde_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","UMosi wathi kuThixo, “Akulamuntu ongakhwela entabeni yeSinayi ngoba wena ngokwakho wathi bangakwenzi lokho. Uthe ngenze imingcele egombolozela intaba ngitshele abantu bangasondeli kuyo ngoba ingcwele.” ");
INSERT INTO nde_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Kodwa uThixo wathi, “Yehla uyebuya lo-Aroni. Kodwa abaphristi labantu akumelanga ukuba beqe imingcele besiza lapho ngoba ngingabaphendukela.” ");
INSERT INTO nde_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ngakho uMosi wehla waya ebantwini wabatshela. ");
INSERT INTO nde_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","UNkulunkulu wakhuluma amazwi wonke la wathi: ");
INSERT INTO nde_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“NginguThixo uNkulunkulu wakho owakukhupha eGibhithe, elizweni lobugqili. ");
INSERT INTO nde_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Ungabi labanye onkulunkulu ngaphandle kwami. ");
INSERT INTO nde_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Ungazenzeli isithombe ngesimo saloba yini esezulwini phezulu loba phansi emhlabeni kumbe ngaphansi kwamanzi. ");
INSERT INTO nde_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Ungazikhothameli loba ukuzikhonza; ngoba mina Thixo uNkulunkulu wakho nginguNkulunkulu olobukhwele, ojezisa abantwana ngenxa yezono zabazali babo kuze kube yisizukulwane sesithathu lesesine salabo abangizondayo, ");
INSERT INTO nde_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","kodwa ngitshengisela uthando kuzizukulwane eziyinkulungwane zalabo abangithandayo njalo begcina imilayo yami. ");
INSERT INTO nde_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Ungadlali ngebizo likaThixo uNkulunkulu wakho ngoba uThixo kayikumyekela olecala lokudlala ngebizo lakhe. ");
INSERT INTO nde_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Khumbula usuku lweSabatha ngokulwenza lubengcwele. ");
INSERT INTO nde_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Okwensuku eziyisithupha uzasebenza wenze yonke imisebenzi yakho, ");
INSERT INTO nde_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","kodwa usuku lwesikhombisa luyiSabatha kuThixo uNkulunkulu wakho. Ngalo awuyikwenza loba yiwuphi umsebenzi, wena, loba indodana yakho, loba indodakazi yakho, loba inceku kumbe incekukazi yakho, loba izifuyo zakho loba isihambi esikwethekeleleyo emzini wakho. ");
INSERT INTO nde_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ngoba ngensuku eziyisithupha uThixo wenza amazulu lomhlaba, ulwandle lakho konke okukukho, kodwa waphumula ngosuku lwesikhombisa. Ngakho-ke walubusisa usuku lweSabatha walwenza lwaba ngcwele. ");
INSERT INTO nde_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Hlonipha uyihlo lonyoko ukuze impilo yakho ibende elizweni akunika lona uThixo uNkulunkulu wakho. ");
INSERT INTO nde_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Ungabulali. ");
INSERT INTO nde_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Ungafebi. ");
INSERT INTO nde_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Ungantshontshi. ");
INSERT INTO nde_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Ungafakazi amanga ngomakhelwane wakho. ");
INSERT INTO nde_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Ungahawukeli indlu kamakhelwane wakho. Ungahawukeli umfazi kamakhelwane wakho, loba inceku kumbe incekukazi yakhe, inkabi yakhe loba ubabhemi wakhe loba yini ekamakhelwane wakho.” ");
INSERT INTO nde_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Kwathi abantu besizwa umdumo bebona lombane, besizwa icilongo njalo bebona intaba ithunqa intuthu, bathuthumela ngokwesaba. Bema khatshana, ");
INSERT INTO nde_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","bathi kuMosi, “Khuluma kithi wena sizakulalela. Kodwa uNkulunkulu kangakhulumi kithi yena ngokwakhe ngoba singafa.” ");
INSERT INTO nde_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","UMosi wathi, “Lingesabi, uNkulunkulu uzelihlola ukuze limesabe lokuze lingoni.” ");
INSERT INTO nde_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Abantu basala belokhu bemi bucwadlanyana, uMosi wangena phakathi komnyama waya lapho okwakuloNkulunkulu khona. ");
INSERT INTO nde_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","UThixo wathi kuMosi, “Tshela abantu bako-Israyeli uthi, ‘Lizibonele lina ngokwenu ukuthi ngikhulume lani ngisezulwini. ");
INSERT INTO nde_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Lingenzi onkulunkulu ukuba babekhona kanye lami; lingazenzeli onkulunkulu besiliva kumbe onkulunkulu begolide. ");
INSERT INTO nde_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Ngakhelani i-alithari ngomhlabathi lenzele kulo umhlatshelo womnikelo wokutshiswa, leminikelo yobudlelwano, izimvu lembuzi kanye lenkomo zenu. Loba kungaphi lapho engizakwenza ibizo lami lihlonitshwe khona, ngizakuza kini ngilibusise. ");
INSERT INTO nde_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Nxa lingakhela i-alithari ngamatshe, lingaze lawabaza lawomatshe ngoba lizalingcolisa nxa lingasebenzisa okokubaza kulo. ");
INSERT INTO nde_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Lingaze laya e-alithareni lami ngezikhwelo funa ubunqunu benu bembulwe khona lapho.’ ” ");
INSERT INTO nde_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Nansi imithetho ozayethula phambi kwabo.” ");
INSERT INTO nde_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Nxa ungathenga isisebenzi esingumHebheru kumele sikusebenzele okweminyaka eyisithupha. Kodwa emnyakeni wesikhombisa kuzamele usikhulule kungelanhlawulo. ");
INSERT INTO nde_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Nxa sifike sodwa, kumele sikhululwe sihambe sodwa kodwa nxa silomfazi ekufikeni kwasokumele sihambe laye. ");
INSERT INTO nde_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Nxa umqhatshi waso angasipha umfazi asizalele amadodana lamadodakazi, owesifazane labantwabakhe bazakuba ngabomqhatshi, njalo indoda izazihambela yodwa ikhululekile. ");
INSERT INTO nde_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Kodwa nxa isisebenzi singathi, ‘Ngiyayithanda inkosi yami lomkami labantwabami, njalo kangifuni kukhululwa,’ ");
INSERT INTO nde_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ngakho inkosi yaso kumele isihambise kubahluleli. Izasisa emnyango kumbe emgubazini abesesibhoboza indlebe yaso ngosungulo. Ngakho-ke sizakuba yisisebenzi sayo okwempilo yaso yonke. ");
INSERT INTO nde_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Nxa indoda ingathengisa indodakazi yayo njengesigqili, indodakazi kayingakhululeki njengalokho okwenza ezinye inceku. ");
INSERT INTO nde_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Nxa singathokozisi umnini waso oyabe esikhethile ukuze sibe ngesakhe kumele asiyekele sihlengwe. Akalamvumo yokusithengisa kwabezizwe, ngoba esikhohlisile. ");
INSERT INTO nde_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Angasikhethela indodana yakhe kumele asinike amalungelo alingana lawendodakazi yakhe. ");
INSERT INTO nde_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Angathatha omunye umfazi akumelanga asincitshe ukudla, izigqoko lamalungelo okwenda. ");
INSERT INTO nde_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Angayekela ukusipha izinto lezi ezintathu sikhululekile ukuthi sizihambele kungahlawulwanga mali.” ");
INSERT INTO nde_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Wonke umuntu otshaya omunye ambulale laye kumele abulawe. ");
INSERT INTO nde_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Kodwa nxa engakwenzanga ngabomo, uNkulunkulu evumele ukuba kwenzakale, kumele abalekele endaweni engizayiphawula. ");
INSERT INTO nde_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Kodwa umuntu angaceba ukubulala omunye ngabomo, msuseni e-alithareni lami liyembulala. ");
INSERT INTO nde_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Wonke umuntu ohlasela uyise kumbe unina kumele abulawe. ");
INSERT INTO nde_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Wonke umuntu othumba omunye abesemthengisa kumbe aficwe elaye kumele abulawe. ");
INSERT INTO nde_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Wonke umuntu othuka uyise kumbe unina kumele abulawe. ");
INSERT INTO nde_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Nxa amadoda angaxabana omunye abesetshaya omunye ngelitshe kumbe ngenqindi, angafi kodwa agule alale phansi, ");
INSERT INTO nde_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","lowo ophose inqindi kasoze anikwe umlandu nxa omunye angavuka abesehambahamba ephethe intonga yakhe; lanxa kunjalo kumele ahlawule indoda elimeleyo ngokulahlekelwa yisikhathi njalo ayelaphise. ");
INSERT INTO nde_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Nxa umuntu angatshaya isigqili sakhe sesilisa kumbe esesifazane ngomqwayi, isigqili besesisifa ngenxa yalesisenzo, kumele ajeziswe, ");
INSERT INTO nde_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","kodwa kasoze ajeziswe nxa isigqili singasila ngemva kwelanga elilodwa kumbe insuku ezimbili, ngoba isigqili siyimpahla yakhe. ");
INSERT INTO nde_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Nxa amadoda alwayo angatshaya umfazi ozithweleyo abesebeletha isikhathi sakhe singakafiki, kodwa engalimalanga kakubi, owonileyo kumele ahlawuliswe lokho okuyabe kubizelwe yindoda yomfazi kwasekuvunywa ngumthethwandaba. ");
INSERT INTO nde_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Kodwa kungangabi lokulimala okubi, kumele impilo ibhadalwe ngempilo, ");
INSERT INTO nde_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ilihlo ngelihlo, izinyo ngezinyo, isandla ngesandla, unyawo ngonyawo. ");
INSERT INTO nde_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Ukutshiswa ngokutshiswa, isilonda ngesilonda, ukulimala ngokulimala. ");
INSERT INTO nde_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Nxa umuntu angatshaya isigqili sakhe sesilisa kumbe esesifazane elihlweni alipatshaze, kumele asiyekele isisebenzi sizihambele kube yinhlawulo yelihlo. ");
INSERT INTO nde_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Angatshaya akhumule izinyo lesigqili sesilisa kumbe esesifazane, kumele asiyekele isisebenzi sizihambele kube yinhlawulo yezinyo. ");
INSERT INTO nde_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Nxa inkunzi ingahlaba indoda kumbe umfazi afe, leyonkunzi kumele itshaywe ngamatshe ize ife njalo inyama yayo kayingadliwa. Kodwa umnikazi wenkunzi akumelanga etheswe umlandu. ");
INSERT INTO nde_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Kodwa nxa inkunzi ivele ilomkhuba wokuhlaba abantu, njalo umnikazi eseke wakhuzwa kodwa wekela ukuyivalela ibisibulala indoda kumbe umfazi, inkunzi kumele ibulawe ngamatshe lomnikazi abulawe. ");
INSERT INTO nde_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Kodwa kungathiwa kahlawule, angahlenga impilo yakhe ngokuhlawula lokho okuyabe kubiziwe. ");
INSERT INTO nde_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Umthetho lo uyasebenza njalo nxa inkunzi ingahlaba indodana kumbe indodakazi. ");
INSERT INTO nde_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Nxa inkunzi ingahlaba isigqili sesilisa kumbe esesifazane, umnikazi kumele ahlawule amashekeli angamatshumi amathathu esiliva kumnini wesigqili, njalo inkunzi kumele ibulawe ngamatshe. ");
INSERT INTO nde_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Nxa umuntu etshiya umgodi ukhamisile, loba esimba umgodi angawusibekeli kuwele kuwo inkabi ingabe ubabhemi, ");
INSERT INTO nde_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","umninimgodi kahlawule; kahlawule umnikazi, isifuyo esifileyo besesisiba ngesakhe. ");
INSERT INTO nde_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Nxa inkunzi yomuntu ingalimaza eyomunye kuzamele ukuthi bathengise leyo ephilayo, babelane imali lesidumbu saleyo efileyo ngokulinganayo. ");
INSERT INTO nde_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Kodwa nxa kusaziwa ukuthi inkunzi ivele ilomkhuba wokuhlaba ezinye, kodwa umnikazi engayivaleli esibayeni, umnikazi kumele ahlawule isifuyo ngesinye isifuyo, njalo isifuyo esifileyo sizakuba ngesakhe.” ");
INSERT INTO nde_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Nxa umuntu angantshontsha inkabi kumbe imvu abeseyibulala kumbe ayithengise, kumele ahlawule ngenkomo ezinhlanu zokuhlawula inkabi, lezimvu ezine zokuhlawula imvu. ");
INSERT INTO nde_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Nxa isela lingafunyanwa ligqekeza ebusuku beselitshaywa life, lowo ozivikelayo kalacala lokuchitha igazi, ");
INSERT INTO nde_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","kodwa kungenzeka ilanga selikhwelile uyabe elomlandu wokuchitha igazi. Isela kumele lihlawule sibili, kodwa nxa lingelalutho, kumele lithengiswe ukwenzela ukuthi lokhu kube yinhlawulo yokuntshontsha kwalo. ");
INSERT INTO nde_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Nxa isifuyo esintshontshiweyo singatholakala siphila ezandleni zesela, kungaba yinkabi kumbe ubabhemi loba imvu, kumele lihlawule okuphindwe kabili. ");
INSERT INTO nde_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Nxa umuntu angayadlisa izifuyo zakhe ensimini kumbe esivinini abeseziyekela zizihambela besezisiya kudla ensimini yeyinye indoda, kumele ahlawule ngezithelo ezinhle zensimu yakhe loba isivini sakhe. ");
INSERT INTO nde_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Nxa kuthungelwa umlilo ulumatha emeveni kuze kutshe lamahlanga amabele loba amabele angakavunwa loba insimu, othungele umlilo kumele ahlawule konke. ");
INSERT INTO nde_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Nxa umuntu anganika umakhelwane wakhe isiliva kumbe impahla ukuba amgcinele izinto lezi besezintshontshwa endlini kamakhelwane, isela lingabanjwa kumele lihlawule okuphindwe kabili. ");
INSERT INTO nde_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Kodwa nxa isela lingabanjwanga, umnikazi wendlu kumele ame phambi kwabahluleli ukuze kubonakale ingabe uke wabeka izandla empahleni zalowo omgcinisileyo na. ");
INSERT INTO nde_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Kuzozonke izehlakalo eziqondene lokugcina ngaphandle komthetho inkabi, ubabhemi, imvu, isigqoko kumbe yonke impahla elahlekileyo omunye umuntu angathi ngayo, ‘Lokhu ngokwami,’ wonke amacele womabili kumele alethe izindaba zawo phambi kwabahluleli. Lowo abahluleli abazakuthi ulecala kumele ahlawule okuphindwe kabili kumakhelwane wakhe. ");
INSERT INTO nde_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Nxa umuntu angasisela umakhelwane wakhe ubabhemi, inkabi, imvu kumbe esinye isifuyo ukuze kugcinakale besekusifa kumbe kulimale kumbe kuthathwe kungelamuntu okhangeleyo, ");
INSERT INTO nde_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","udaba lwabantu laba luzaqedwa ngokufunga phambi kukaThixo ukuthi umakhelwane konanga impahla yomunye umuntu. Umnikazi kumele akwemukele lokhu njalo akulanhlawulo edingakalayo. ");
INSERT INTO nde_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Kodwa nxa isifuyo santshontshwa sikumasiselwa kumele ahlawule umnikazi. ");
INSERT INTO nde_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Nxa isifuyo sidatshudatshulwe yinyamazana yeganga saba yiziqa, uzaletha izicucu eziseleyo njengobufakazi njalo akusoze kudingakale ukuthi ahlawulele isifuyo esidatshudatshuliweyo. ");
INSERT INTO nde_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Nxa umuntu angaboleka isifuyo kumakhelwane wakhe, besesilimala kumbe sife ngesikhathi umniniso engekho, kumele ahlawule. ");
INSERT INTO nde_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Kodwa nxa umnikazi ekhona, lowo owasebolekayo akumelanga ahlawule. Nxa isifuyo siqhatshiwe, imali ehlawulwe ukusiqhatsha igoqela inhlawulo yokulahlekelwa.” ");
INSERT INTO nde_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Nxa indoda ingaqila intombi egcweleyo engakathenjiswa ilale layo, kumele ikhuphe amalobolo, leyontombi ibe ngumkayo. ");
INSERT INTO nde_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Nxa uyise esala kokuphela ukuthi ayendisele, kumele akhuphe inhlawulo ekhutshelwa amantombazana agcweleyo. ");
INSERT INTO nde_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Lingavumeli umthakathi ukuthi aphile. ");
INSERT INTO nde_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Wonke umuntu olala lenyamazana kumele abulawe. ");
INSERT INTO nde_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Loba ngubani onikela kwabanye onkulunkulu ngaphandle kukaThixo kumele abhujiswe. ");
INSERT INTO nde_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Lingahlukuluzi owezizweni ngoba lani lalingabezizweni eGibhithe. ");
INSERT INTO nde_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Lingaqilibezeli umfelokazi kumbe intandane, ");
INSERT INTO nde_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","ngoba lingakwenza, besebekhala kimi ngizakuzwa ukukhala kwabo; ");
INSERT INTO nde_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ulaka lwami luzavutha, ngibulale ngenkemba; abafazi benu babe ngabafelokazi labantwabenu babe zintandane. ");
INSERT INTO nde_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Nxa lingebolekisa imali omunye wabantu bami ohluphekayo phakathi kwenu, akumelanga lenze njengebhizimisi yokweboleka abanye imali, lingamhlawulisi inzuzo. ");
INSERT INTO nde_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Nxa ungathatha ijazi likamakhelwane wakho ulenze isibambiso, kumele ulibuyisele ilanga lingakatshoni, ");
INSERT INTO nde_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ngoba ijazi lelo yilo lodwa embesa ngalo ubunqunu bakhe. Kambe kuyini okunye abangalala kukho? Nxa bengakhala kimi, ngizabezwa ngoba ngilozwelo. ");
INSERT INTO nde_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Lingahlambazi uNkulunkulu kumbe lithuke umbusi wabantu bakini. ");
INSERT INTO nde_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Lingagodli iminikelo eziphaleni zenu loba ezimbizeni zewayini lenu. Kumele lilethe kimi amadodana enu angamazibulo. ");
INSERT INTO nde_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Yenzani njalo ngenkomo lezimvu zenu. Yekelani zihlale labonina okwensuku eziyisikhombisa kodwa linginike zona ngosuku lwesificaminwembili. ");
INSERT INTO nde_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Lizakuba ngabantu bami abangcwele. Ngakho lingaze ladla inyama yenyamazana eyabe idatshudatshulwe yizilo zeganga; iphoseleni izinja.” ");
INSERT INTO nde_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Ungahambi ukhuluma izindaba zamanga. Ungahlanganyeli lomuntu omubi ngoba ngufakazi olomona. ");
INSERT INTO nde_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Ungenzi okubi ulandela inengi labantu. Nxa ufakaza emthethwandaba, ungaphenduleli iqiniso ngokuvumelana labanengi, ");
INSERT INTO nde_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","njalo ungazweli umuntu ecaleni ngoba engumyanga. ");
INSERT INTO nde_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Ungahlangana lenkomo kumbe ubabhemi wesitha sakho elahlekile, mnqande umbuyisele kumnikazi. ");
INSERT INTO nde_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Nxa ufica ubabhemi womuntu okuzondayo ewiswe ngumthwalo, ungamtshiyi, umncedise umvuse. ");
INSERT INTO nde_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Ahlulela kuhle abayanga bakini emacaleni. ");
INSERT INTO nde_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ungabungeni ubufakazi bamanga, njalo ungabulali muntu ongelacala loba oqotho ngoba kangiyi kumyekela olecala. ");
INSERT INTO nde_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Lingavumi ukufunjathiswa ngoba ukufunjathiswa kufiphaza ababonayo besebeguqula amazwi omuntu omsulwa. ");
INSERT INTO nde_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Ungancindezeli owezizweni, lina ngokwenu liyakwazi ukuthi kunjani ukuba ngabezizweni, njengoba lalingabezizweni eGibhithe.” ");
INSERT INTO nde_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Okweminyaka eyisithupha lizalima amasimu enu livune amabele, ");
INSERT INTO nde_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","kodwa kuzakuthi ngomnyaka wesikhombisa liyekele amasimu enu alaluke engalinywanga. Ngakho abangabayanga phakathi kwenu bazazuza ukudla kuwo, kuthi lezinyamazana zeganga zidle okuseleyo. Lizakwenza njalo okufananayo ngezivini zenu kanye lezihlahla zenu zama-oliva. ");
INSERT INTO nde_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Uzakwenza imisebenzi yakho okwensuku eziyisithupha, kodwa ngosuku lwesikhombisa ungasebenzi, ukuze inkabi yakho lobabhemi wakho kuphumule, kuthi isigqili esazalelwa endlini yakho kanye lowezizweni baphumule. ");
INSERT INTO nde_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Qaphelisisani lenze konke engilitshela khona. Lingamemezi amabizo abanye onkulunkulu; kawangezwakali ephuma ezindebeni zenu.” ");
INSERT INTO nde_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Kathathu ngomnyaka kufanele lingithakazelele umkhosi. ");
INSERT INTO nde_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Lizathakazelela uMkhosi weSinkwa esingelaMvubelo; okwensuku eziyisikhombisa dlanini isinkwa esingelamvubelo, njengokulilaya kwami. Kwenzeni lokhu ngesikhathi esimisiweyo senyanga ka-Avivi, ngoba ngaleyonyanga yikho elaphuma khona eGibhithe. Kakungabi lamuntu ozakuma phambi kwami engaphathanga lutho. ");
INSERT INTO nde_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Lithakazelele uMkhosi wokuVuna lokolibo kwenu ezilimweni zenu zemasimini. Lithakazelele uMkhosi wokuButhelela nxa selibutha izilimo zenu emasimini. ");
INSERT INTO nde_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Kathathu ngomnyaka amadoda wonke kufanele ayebonakala phambi kukaThixo Wobukhosi. ");
INSERT INTO nde_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Linganikeli igazi lomhlatshelo kimi ndawonye laloba yini elemvubelo. Amahwahwa eminikelo yemikhosi yami akumelanga agcinwe kuze kuse. ");
INSERT INTO nde_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Lethani okolibo kwenu okuhle kakhulu endlini kaThixo uNkulunkulu wenu. Lingapheki izinyane lembuzi ngochago lukanina.” ");
INSERT INTO nde_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Khangelani, sengithumela ingilosi phambi kwenu ukuze ilivikele endleleni yenu njalo ize ilifikise endaweni engililungisele yona. ");
INSERT INTO nde_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Liyinanzelele ingilosi yami njalo lilalele ekutshoyo. Lingayihlamukeli ngoba kayizukulithethelela nxa lingayihlamukela, njengoba iBizo lami likuyo. ");
INSERT INTO nde_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Nxa lingalalelisisa ekutshoyo njalo lenze konke engikutshoyo, ngizakuba yisitha sezitha zenu njalo ngizamelana lalabo abamisana lani. ");
INSERT INTO nde_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ingilosi yami izahamba phambi kwenu ize ilingenise elizweni lama-Amori, lamaHithi, lamaPherizi, lamaKhenani lamaHivi kanye lamaJebusi njalo ngizababhubhisa. ");
INSERT INTO nde_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Lingabakhothameli onkulunkulu babo, lingabakhonzi njalo lingalandeli imikhuba yabo. Kufanele libhidlize onkulunkulu babo njalo lidilize amatshe abo abawakhonzayo. ");
INSERT INTO nde_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Mkhonzeni uThixo uNkulunkulu wenu, kuzakuthi isibusiso sakhe sibe phezu kokudla laphezu kwamanzi enu. Ngizasusa imikhuhlane phakathi kwenu, ");
INSERT INTO nde_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","njalo kakho ozaswela loba abe yinyumba ezweni lenu. Ngizaphelelisa insuku zenu. ");
INSERT INTO nde_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ngizathumela uchuku lwami phambi kwenu njalo ngisanganise zonke izizwe elizahlangana lazo. Ngizakwenza zonke izitha zenu zifulathele zilibalekele. ");
INSERT INTO nde_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ngizathumela olonyovu phambi kwenu ukuze basuse amaHivi, amaKhenani kanye lamaHithi endleleni yenu. ");
INSERT INTO nde_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Kodwa angiyikubasusa ngomnyaka munye, ngoba ilizwe lingasala lingasela muntu besekusithi izinyamazana zeganga zande zilikhulele. ");
INSERT INTO nde_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ngizabasusa kancanekancane phambi kwenu, lani lize lande lenelise ukuthatha ilizwe. ");
INSERT INTO nde_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Ngizabeka imingcele kusukela oLwandle oluBomvu kusiya oLwandle lwamaFilistiya, njalo kusuka enkangala kusiya emfuleni uYufrathe. Ngakho abantu abahlala kulelolizwe ngizabanikela ezandleni zenu ukuze libadudule. ");
INSERT INTO nde_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Lingenzi isivumelwano labo loba labonkulunkulu babo. ");
INSERT INTO nde_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Kabangahlali lani ezweni lenu, funa balenze lingonele, ngoba ukukhonza kwabo onkulunkulu babo kuzakuba yisifu kini.” ");
INSERT INTO nde_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Ngakho uThixo wasesithi kuMosi, “Woza kuThixo, wena lo-Aroni, uNadabi lo-Abhihu, kanye labadala bako-Israyeli abangamatshumi ayisikhombisa. Lizakhonza libucwala, ");
INSERT INTO nde_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","kodwa uMosi yedwa zwi uzasondela kuThixo; abanye kabafanelanga ukusondela eduze. Kanti-ke abantu kabafanelanga ukuza laye.” ");
INSERT INTO nde_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Kwathi uMosi esebuyele ebantwini wabatshela wonke amazwi kanye lemilayo kaThixo, abantu bakwamukela, bavungama ngalizwi linye bathi, “Konke okutshiwo nguThixo sizakwenza.” ");
INSERT INTO nde_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","UMosi waseloba konke uThixo ayekutshilo. Ngosuku olulandelayo uMosi wavuka kusesele wakha i-alithari ewatheni lwentaba wamisa khona izinsika zamatshe alitshumi lambili emele izizwe ezilitshumi lambili zako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Wasethuma amajaha ako-Israyeli ahamba ayanikela umnikelo wokutshiswa njalo benza imihlatshelo ngenkunzi ezincane njengomnikelo wobudlelwano kuThixo. ");
INSERT INTO nde_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","UMosi wasethatha ingxenye yegazi walithela emiganwini eyayizingubhe, elinye wachela ngalo phezu kwe-alithari. ");
INSERT INTO nde_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ngakho wathatha iNcwadi yeSivumelwano wayifundela abantu. Bona bavuma besithi, “Sizakwenza konke okutshiwo nguThixo; sizamlalela.” ");
INSERT INTO nde_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Ngemva kwalokho uMosi wathatha igazi wachela ngalo abantu esithi kubo, “Leli ligazi lesivumelwano sikaThixo asenze lani ngokuqondene lawo wonke lamazwi.” ");
INSERT INTO nde_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","UMosi lo-Aroni, uNadabi lo-Abhihu kanye labadala bako-Israyeli abangamatshumi ayisikhombisa bakhwela ");
INSERT INTO nde_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","bayabona uNkulunkulu ka-Israyeli. Ngaphansi kwezinyawo zakhe kwakungani ngumgwaqo owenziwe ngesafaya, kukhanya njengokukhanya komkhathi uqobo. ");
INSERT INTO nde_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Kodwa uNkulunkulu kazange abanine ngesandla sakhe laba bakhokheli bako-Israyeli; sebembonile uNkulunkulu badla banatha. ");
INSERT INTO nde_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","UThixo wathi kuMosi, “Khwela uze kimi entabeni njalo uhlale lapha, ngizakunika izibhebhedu zamatshe, engilobe kuzo imithetho lemilayo eyiziqondiso zabo.” ");
INSERT INTO nde_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ngakho uMosi wasuka loJoshuwa umsizi wakhe, uMosi wasekhwela entabeni kaNkulunkulu. ");
INSERT INTO nde_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Wathi ebadaleni, “Silindelani khonapha size siphenduke. U-Aroni loHuri bazasala lani, kuzakuthi abaxabanayo babonane labo.” ");
INSERT INTO nde_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Kwathi uMosi esekhwele intaba, yasibekelwa liyezi, ");
INSERT INTO nde_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","inkazimulo kaThixo yagcwala entabeni yaseSinayi. Iyezi lembesa intaba okwensuku eziyisithupha kwathi ngosuku lwesikhombisa uThixo wabiza uMosi eseyezini. ");
INSERT INTO nde_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ebantwini bako-Israyeli inkazimulo kaThixo yabonakala injengomlilo otshisa uqothule phezu kwentaba. ");
INSERT INTO nde_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Ngakho uMosi wangena eyezini ekhwela intaba. Wahlala khonale entabeni okwensuku ezingamatshumi amane lobusuku obungamatshumi amane. ");
INSERT INTO nde_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Tshela abako-Israyeli bangilethele umnikelo. Uzakwamukela umnikelo emuntwini munye ngamunye ofuqwa yinhliziyo yakhe ukuthi anikele. ");
INSERT INTO nde_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Le yiyo iminikelo ozayamukela nxa sebenikela: igolide, isiliva kanye lethusi, ");
INSERT INTO nde_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","okwelukiweyo lamalembu aluhlaza, ayibubende kanye labomvu, lelembu elicolekileyo, loboya bembuzi, ");
INSERT INTO nde_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","izikhumba zenqama eziphendulwe ngomphendulo obomvu, kanye lezikhumba zezinyamazana eziqinileyo, lezigodo zesihlahla somʼakhakhiya, ");
INSERT INTO nde_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","amafutha e-oliva awokukhanyisa isibane, amakha azasetshenziswa lamafutha okugcoba abakhethiweyo lephunga lempepha elimnandi, ");
INSERT INTO nde_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","amatshe e-onikisi, lamanye amatshe aligugu azathungelwa esembathweni semahlombe lesesifubeni. ");
INSERT INTO nde_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Bangakhele indlu engcwele, ngalokho ngizahlala phakathi kwabo. ");
INSERT INTO nde_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Yenza ithabanikeli leli kanye leziceciso zalo ngendlela engizakutshengisa yona.” ");
INSERT INTO nde_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Kabenze umtshokotsho ngezigodo zesihlahla somʼakhakhiya, ubude bawo kube zingalo ezimbili ezilengxenye, ububanzi kube yingalo elengxenye njalo ukuyaphezulu kwawo kube yingalo elengxenye. ");
INSERT INTO nde_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Lilihuqe ngegolide elicolekileyo, ngaphakathi langaphandle, ubuye ulizingelezele ngomqolo wegolide. ");
INSERT INTO nde_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Libumbele amasongo amane egolide liwanamathisele ezinyaweni zalo zozine, amabili kwelinye icele kuthi amabili kwelinye njalo. ");
INSERT INTO nde_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Beselisenza imijabo ngesihlahla somʼakhakhiya liyihuqe ngegolide. ");
INSERT INTO nde_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Hlomani imijabo kulawo masongo asemaceleni omtshokotsho kube yizibambo. ");
INSERT INTO nde_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Izigodo lezi zizahlala emasongweni alumtshokotsho, zingakhitshwa. ");
INSERT INTO nde_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Beselifaka ubufakazi emtshokotshweni engizakunika bona. ");
INSERT INTO nde_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Yenzani isihlalo somusa ngegolide elicolekileyo, ubude baso bube zingalo ezimbili ezilengxenye lengxenye eyodwa ububanzi. ");
INSERT INTO nde_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Lizakwenza amakherubhi amabili ngegolide elikhandiweyo, liwenze ekucineni kwesisibekelo esiyisihlalo somusa emaceleni womabili. ");
INSERT INTO nde_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Yenzani ikherubhi elilodwa nganxanye kuthi ngakwelinye icele lenze elinye, uzawenza amakherubhi abe yinto yinye lesisibekelo emaceleni womabili. ");
INSERT INTO nde_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Amakherubhi kumele elulele amaphiko awo phezulu embese isisibekelo ngawo. Kuzamele amakherubhi akhangelane, ubuso bawo bukhangele isisibekelo. ");
INSERT INTO nde_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Bekani isisibekelo phezu komtshokotsho, ubusufaka ubufakazi engizakunika bona ebhokisini lesivumelwano. ");
INSERT INTO nde_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Kulapho engizahlangana lawe khona ngikunika imithetho ka-Israyeli ngisesihlalweni somusa, phakathi laphakathi kwamakherubhi aphezu komtshokotsho wobufakazi.” ");
INSERT INTO nde_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Bazani itafula ngezigodo zesihlahla somʼakhakhiya, ubude bayo bube zingalo ezimbili, ububanzi bayo bube yingalo eyodwa, kuthi ukudepha kwayo kube yingalo elengxenye. ");
INSERT INTO nde_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Liyihuqe ngegolide elicolekileyo, beseliyizingelezela ngomthando wegolide. ");
INSERT INTO nde_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Lenze kuyo ibhanti eliyizingelezileyo, elilingana lobubanzi besandla, beselibumbela kuyo umthando wegolide phezu kwebhanti. ");
INSERT INTO nde_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Lenze amasongo amane egolide liwafake emagumbini womane enyaweni zetafula. ");
INSERT INTO nde_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Amasongo kumele asondelelane lebhanti ukuze abambe imijabo ezasetshenziswa ukuthwala itafula. ");
INSERT INTO nde_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Lungisani imijabo ngesihlahla somʼakhakhiya, liyihuqe ngegolide ukuze lithwale itafula ngayo. ");
INSERT INTO nde_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Njalo yenzani imiganu lezinditshi zayo ngegolide elicolekileyo kanye lenkezo, imiganu eyingubhe lezitsha zokuthululela iminikelo. ");
INSERT INTO nde_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Libeke etafuleni isinkwa esiNgcwele ukuze sibe phambi kwami ngezikhathi zonke.” ");
INSERT INTO nde_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Lizakwenza uluthi lwesibane ngegolide elicolekileyo. Likhande isidindi salo lomqwayi walo, imbizana zalo lamahlumela alo lamaluba alo likwenze kube yinto yinye. ");
INSERT INTO nde_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Ingatsha eziyisithupha zixhunywe emaceleni oluthi, ezintathu nganxanye kuthi ezintathu kwelinye icele. ");
INSERT INTO nde_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Inkezo ezintathu ezibunjwe okwamaluba e-alimondi, amahlumela lamaluba kumele abe sogatsheni lunye, ezintathu egatsheni olulandelayo, kube njalo kuzozonke ingatsha ezixhunywe emqwayini woluthi lwesibane. ");
INSERT INTO nde_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Kuzakuthi oluthini lwesibane kube lezimbizana ezine ezibunjwe okwamaluba e-alimondi, zilamahlumela lamaluba. ");
INSERT INTO nde_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Kumele kube lehlumela ngaphansi kwengatsha ezimbili ezixhunywe oluthini lwesibane, ihlumela lesibili ngaphansi kwezinye ezimbili, kuthi ihlumela lesithathu lalo libe ngaphansi kwezinye njalo ezimbili, zonke ingatsha zibe yisithupha. ");
INSERT INTO nde_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Amahlumela lezingatsha kuzakuba yinto yinye loluthi lwesibane, kukhandwe ngegolide elicolekileyo. ");
INSERT INTO nde_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Ngakho lizalwenzela izibane eziyisikhombisa lizimise phezu kwalo ukuze zikhanyise phambi kwalo. ");
INSERT INTO nde_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Incijana zentambo lembizana zalo zibe ngezegolide elicolekileyo. ");
INSERT INTO nde_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Uluthi lwesibane kanye lakho konke okuphathelene laso kuzenziwa ngegolide elicolekileyo eliyisisindo sethalenta elilodwa. ");
INSERT INTO nde_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Qaphela ukuba wenze konke njengalokhu owakutshengiswa entabeni.” ");
INSERT INTO nde_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Lenze ithabanikeli ngamakhetheni alitshumi elembu eliphothwe kuhle ngentambo eziluhlaza, eziyibubende kanye lezibomvu, aceciswe ngamakherubhi elukelwe kuhle ngumuntu oleminwe. ");
INSERT INTO nde_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Amakhetheni wonke kumele ukuthi alingane, abezingalo ezingamatshumi amabili lesificaminwembili ubude njalo ububanzi abezingalo ezine. ");
INSERT INTO nde_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Lizahlanganisa amakhetheni amahlanu ndawonye, liphinde lenzenjalo lakwamanye amahlanu. ");
INSERT INTO nde_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Lenze izihitshela ngelembu eliluhlaza emphethweni wekhetheni elisekucineni kwamakhetheni amahlanu elixheni lakuqala, lenze okufanayo elixheni lesibili. ");
INSERT INTO nde_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Lizakwenza izihitshela ezingamatshumi amahlanu ekhethenini elilodwa liphinde lenze ezinye izihitshela ezingamatshumi amahlanu ekhethenini lokucina elixheni lesibili, izihitshela zikhangelene. ");
INSERT INTO nde_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Emva kwalokho lizakwenza ingwegwe zegolide ezingamatshumi amahlanu, lizisebenzise ukuhlanganisa amakhetheni ukuze ithabanikeli libe yintonye. ");
INSERT INTO nde_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Yenzani amakhetheni ngoboya bembuzi abe ngawethente lokubekwa phezu kwethabanikeli, abelitshumi lanye esewonke. ");
INSERT INTO nde_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Amakhetheni wonke alitshumi lanye alingane, abezingalo ezingamatshumi amathathu ubude, ububanzi abezingalo ezine. ");
INSERT INTO nde_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Hlanganisani amakhetheni amahlanu abelilixha elilodwa kuthi ayisithupha abe kwelinye ilixha. Ligoqe ikhetheni lesithupha liphindwe kabili phambi kwethente. ");
INSERT INTO nde_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Yenzani izihitshela ezingamatshumi amahlanu zilandele umphetho wekhetheni elisekucineni kwelixha lakuqala, lenzenjalo lakwelinye ilixha. ");
INSERT INTO nde_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Beselilungisa ingwegwe zethusi ezingamatshumi amahlanu lizifake ezihitsheleni ukuze zibophe ithente kube yinto yinye. ");
INSERT INTO nde_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Kuzakuthi-ke isiqa esiseleyo sekhetheni lethente, ingxenye yekhetheni eseleyo, ilenge emuva kwethabanikeli. ");
INSERT INTO nde_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Amakhetheni ethente azakwedlula ngengalo eyodwa inxa zonke, kuthi okuseleyo kulenge emaceleni ethabanikeli ukuze alembese. ");
INSERT INTO nde_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Lenze isembeso sethente ngezikhumba zenqama eziphendulwe ngomphendulo obomvu, kuthi phezu kwalokho kube lesembeso sezikhumba eziqinileyo. ");
INSERT INTO nde_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Yenzani amathala ethabanikeli amiswayo ngezigodo zesihlahla somʼakhakhiya. ");
INSERT INTO nde_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ithala linye kumele libe lide okuzingalo ezilitshumi, kuthi ububanzi bube yingalo elengxenye, ");
INSERT INTO nde_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","kube lemisuka emibili ephutshayo ilinganisene. Wonke amathala ethabanikeli enziwe ngale indlela. ");
INSERT INTO nde_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Yenzani amathala ecele elisezansi kwethabanikeli angamatshumi amabili, ");
INSERT INTO nde_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","beselizenza izisekelo zesiliva ezingamatshumi amane ezizahamba ngaphansi kwawo, izisekelo ezimbili ethaleni linye, sibe sinye ngaphansi kwensika inye ngayinye. ");
INSERT INTO nde_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Kulelicele elisenyakatho kwethabanikeli, misani amathala angamatshumi amabili ");
INSERT INTO nde_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","kanye lezisekelo zesiliva ezingamatshumi amane, ezimbili ngaphansi kwepulanka linye. ");
INSERT INTO nde_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Yenzani amathala ayisithupha ecele elisekucineni ngentshonalanga kwethabanikeli, ");
INSERT INTO nde_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","lenze amathala amabili amagumbi asekucineni. ");
INSERT INTO nde_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Emagumbini womabili la kumele abe lohlonzi oluphindwe kabili kusukela phansi kusiya phezulu, abesehlanganiswa ngesongo elilodwa, wonke abe njalo. ");
INSERT INTO nde_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Ngakho kuzakuba lamathala ayisificaminwembili lezisekelo zesiliva ezilitshumi lesithupha, ezimbili ngaphansi kwethala linye. ");
INSERT INTO nde_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Yenzani njalo imithando enqumayo ngezigodo zesihlahla somʼakhakhiya: emihlanu ibe ngeyamathala kwelinye icele lethabanikeli, ");
INSERT INTO nde_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","emihlanu ibe njalo kwelinye icele, kuthi eminye njalo emihlanu ibe ngeyamathala asentshonalanga, ekucineni kwethabanikeli. ");
INSERT INTO nde_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Umthando waphakathi onqumayo uzakwedlula usuka kulelicele lokucina usiyacina kwelinye phakathi laphakathi kwamathala. ");
INSERT INTO nde_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Huqani amathala ngegolide lenze amasongo egolide abambe imithando enqumayo. Njalo lihuqe imithando enqumayo ngegolide. ");
INSERT INTO nde_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Limise ithabanikeli njengokutshengiswa kwakho entabeni. ");
INSERT INTO nde_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Yenzani ikhetheni ngelembu elicolekileyo, eliphethwe kuhle ngentambo eziluhlaza, eziyibubende kanye lezibomvu, abe lamakherubhi elukelwe kuwo ngumuntu oleminwe. ");
INSERT INTO nde_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Liwalengise ngezingwegwana zegolide ensikeni ezine zesihlahla somʼakhakhiya ezihuqwe ngegolide njalo zimiswe phezu kwezisekelo zesiliva. ");
INSERT INTO nde_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Lengisani-ke ikhetheni ngezingwegwana beselibeka umtshokotsho wobufakazi ngemva kwekhetheni. Ikhetheni lizakwehlukanisa Indawo Engcwele kweNgcwelengcwele. ");
INSERT INTO nde_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Bekani isisibekelo esiyisihlalo somusa phezu komtshokotsho wobufakazi osendaweni eNgcwelengcwele. ");
INSERT INTO nde_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Bekani itafula ngaphandle kwekhetheni elisenyakatho kwethabanikeli, beselifaka uluthi lwesibane lukhangelane layo eceleni eliseningizimu. ");
INSERT INTO nde_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Yenzani ikhetheni lesango lethente ngelembu eliphethwe kuhle ngentambo eziluhlaza, eziyibubende kanye lezibomvu kube ngumsebenzi wombalazi ngokuthunga. ");
INSERT INTO nde_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Yenzelani ikhetheni ingwegwana zegolide kanye lezinsika ezinhlanu ezenziwe ngezigodo zesihlahla somʼakhakhiya ezihuqwe ngegolide. Njalo beseliwafakela izisekelo ezinhlanu ezibunjwe ngethusi.” ");
INSERT INTO nde_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Lakhe i-alithari ngezigodo zesihlahla somʼakhakhiya libe zingalo ezintathu ukudepha, kumele lilingane inxa zonke, ubude balo bube zingalo ezinhlanu lobubanzi balo bube zingalo ezinhlanu. ");
INSERT INTO nde_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Egumbini linye ngalinye le-alithari uzakwenza uphondo, kuthi impondo le-alithari kube yinto yinye, ubusulihuqa ngethusi. ");
INSERT INTO nde_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Izinto zonke ezizasetshenziswa kulo uzazenza ngethusi, imbiza zalo zokubutha umlotha, amafotsholo alo, imiganu yokuchela, amafologwe enyama kanye lezindengezi zokubasela umlilo. ");
INSERT INTO nde_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Lenzele iminxibo yokosa ngethusi njalo wenze isongo lethusi emagumbini wonke womane. ");
INSERT INTO nde_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Libeke ngaphansi komphetho we-alithare okuyingxenye yokuya phezulu. ");
INSERT INTO nde_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Libaze imijabo ye-alithare ngezigodo zesihlahla somʼakhakhiya liyihuqe ngethusi. ");
INSERT INTO nde_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Lihlome imijabo le emasongweni asemaceleni womabili e-alithare ukuze ibe yizibambo nxa selithwalwa. ");
INSERT INTO nde_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Beselithatha amapulanka lenze ngawo i-alithari libe ngumhome. Lenze njengalokhu owakutshengiswayo entabeni.” ");
INSERT INTO nde_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Lilungise iguma lethabanikeli. Ubude becele lezansi bube zingalo ezilikhulu njalo libe lamakhetheni elembu eliphethwe kuhle, ");
INSERT INTO nde_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","lensika ezingamatshumi amabili lezisekelo ezingamatshumi amabili konke kwenziwe ngethusi kanye lengwegwe zesiliva lamabhanti ensikeni. ");
INSERT INTO nde_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Icele lenyakatho lalo lizakuba yizingalo ezilikhulu ubude njalo libe lamakhetheni, libe lensika ezingamatshumi amabili lezisekelo ezingamatshumi amabili ethusi futhi kube lengwegwana lezibopho zesiliva ensikeni. ");
INSERT INTO nde_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Icele lentshonalanga yeguma lizakuba zingalo ezingamatshumi amahlanu ububanzi, lilamakhetheni, lensika ezilitshumi kanye lezisekelo ezilitshumi. ");
INSERT INTO nde_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Eceleni elisempumalanga, kusiya okuphuma khona ilanga, iguma lizakuba banzi okuzingalo ezingamatshumi amahlanu. ");
INSERT INTO nde_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Amakhetheni azingalo ezilitshumi lanhlanu ubude azakuba nganxanye kwesango, elezinsika ezintathu kanye lezisekelo ezintathu. ");
INSERT INTO nde_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Ngakwelinye icele lakho kuzakuba lamakhetheni azingalo ezilitshumi lanhlanu ubude kanye lezinsika ezintathu lezisekelo ezintathu. ");
INSERT INTO nde_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Esangweni leguma, lifake ikhetheni elizingalo ezingamatshumi amabili ubude, elelukwe laphethwa kuhle ngentambo eluhlaza, eyibubende kanye lebomvu, kube ngumsebenzi wombalazi ngokuthunga, kube lezinsika ezine lezisekelo ezine. ");
INSERT INTO nde_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Zonke izinsika ezihonqolozele iguma zibe lamabhanti lengwegwe zesiliva kanye lezisekelo zethusi. ");
INSERT INTO nde_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ubude beguma buzakuba zingalo ezilikhulu lobubanzi obuzingalo ezingamatshumi amahlanu lamakhetheni elembu elelukwe kuhle libe lide okuzingalo ezinhlanu, lezisekelo zethusi. ");
INSERT INTO nde_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Zonke izinto ezizasetshenziswa emsebenzini wethabanikeli loba kuyini okwenziwayo kuhlanganisa lazozonke izikhonkwane zalo kanye lezeguma, kumele kube ngokwethusi.” ");
INSERT INTO nde_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Laya abantu bako-Israyeli bakulethele amafutha acengekileyo, ahluzwe ema-oliveni, abe ngawokukhanyisa ukuze izibane zihlale zikhanyisa kokuphela. ");
INSERT INTO nde_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Ethenteni lokuhlangana, ngaphandle kwekhetheni eligudle umtshokotsho wobufakazi, u-Aroni lamadodana akhe bazagcina izibane phambi kukaThixo zibhebha kusukela ntambama kuze kuse. Lokhu kuzakuba yisimiso saphakade phakathi kwabako-Israyeli lakuzizukulwane ezizayo.” ");
INSERT INTO nde_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Akulethwe kuwe phakathi kwabako-Israyeli umfowenu u-Aroni kanye lamadodana akhe uNadabi, u-Abhihu, u-Eliyazari lo-Ithamari, ubehlukanisele ukuba babe ngabaphristi bami. ");
INSERT INTO nde_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Wenzele u-Aroni umfowenu izembatho ezingcwele, ezizamenza abe lesithunzi njalo ahlonipheke. ");
INSERT INTO nde_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Atshele wonke amadoda azingcitshi lalenhlakanipho ngokuphathelane lalumsebenzi wokuthi benzele u-Aroni izembatho zokwahlukanisela umsebenzi wami wokuba ngumphristi. ");
INSERT INTO nde_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Yilezi izembatho abazazenza: isembatho sesifubeni, isembatho semahlombe, isigqoko, ibhatshi elelukiweyo, iqhiye kanye lebhanti. Kumele benzele umfowenu u-Aroni lamadodana akhe izembatho lezi ezingcwele ukuze babe ngabaphristi bami. ");
INSERT INTO nde_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Kabasebenzise intambo eziluhlaza, eziyibubende, ezibomvu kanye lelembu elicolekileyo.” ");
INSERT INTO nde_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Uzakwenza isembatho semahlombe ngelembu eliphethwe kuhle ngentambo eziligolide, eziluhlaza, eziyibubende kanye lezibomvu, kube ngumsebenzi womuntu oleminwe. ");
INSERT INTO nde_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Kumele sibe leziqa zemahlombe ezimbili zithungelwe emaceleni aso womabili ukuze sibotshwe. ");
INSERT INTO nde_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Kuzakuthi ibhanti laso lasekhalweni lelukwe ngobungcitshi lenziwe lifane laso, libe yinto yinye lesembatho semahlombe, lenziwe ngelembu eliphethwe kuhle ngentambo eligolide, eluhlaza, eyibubende kanye lebomvu. ");
INSERT INTO nde_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Thatha amatshe amabili ohlobo lwe-onikisi udwebele kuwo amabizo amadodana ka-Israyeli ");
INSERT INTO nde_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ngokulandelana kwawo, ayisithupha kwelinye ilitshe kuthi aseleyo uwadwebele kwelinye njalo. ");
INSERT INTO nde_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Dwebela amabizo amadodana ka-Israyeli ematsheni womabili njengombazi wamatshe aligugu edwebela uphawu. Ubusuwazingelezela ngeziceciso zegolide ");
INSERT INTO nde_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","ubusuwathungela eziqeni zemahlombe kube ngamatshe esikhumbuzo samadodana ka-Israyeli. U-Aroni kumele athwale amabizo emahlombe akhe kube yisikhumbuzo phambi kukaThixo. ");
INSERT INTO nde_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Yenza iziceciso zegolide ");
INSERT INTO nde_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","kanye lamaketane enziwe ngegolide elicolekileyo alukelwe ndawonye njengegoda uwabophele ezicecisweni zegolide.” ");
INSERT INTO nde_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Uzakwenza isembatho sesifuba sokwahlulela, senziwe ngumuntu oleminwe. Usenze njengesembatho semahlombe: ngelembu eliphothwe kuhle ngentambo eligolide, eluhlaza, eyibubende kanye lebomvu. ");
INSERT INTO nde_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Kufanele silingane inxa zonke, isandla ubude lesandla ububanzi, sigoqwe saphindwa kabili. ");
INSERT INTO nde_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Ubusuthungela kuso imizila emine yamatshe aligugu. Emzileni wakuqala kuzakuba lerubhi, ithophazi kanye lebheriyeli, ");
INSERT INTO nde_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","emzileni wesibili kube yi-emeralidi, isafaya, ledayimana, ");
INSERT INTO nde_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","emzileni wesithathu ijasinti, i-agathi kanye le-amethisi, ");
INSERT INTO nde_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","emzileni wesine ikhrisolathi, i-onikisi kanye lejaspa. Athungele ezicecisweni zegolide. ");
INSERT INTO nde_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Kumele kube lamatshe alitshumi lambili, lilinye limele ibizo lamadodana ka-Israyeli, linye ngalinye lilotshwe njengokudweba kombazi wamatshe, kungani luphawu, kulotshwe kulelo lalelo ibizo lezizwana zako-Israyeli ezilitshumi lambili. ");
INSERT INTO nde_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Isembatho sesifubeni selukelwe amaketane ngegolide elicolekileyo kube njengegoda. ");
INSERT INTO nde_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Yenza amasongo amabili ngegolide ubusuwabophela emagumbini amabili esembatho sesifubeni. ");
INSERT INTO nde_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Bophela amaketane amabili egolide emasongweni asemagumbini esembatho sesifubeni, ");
INSERT INTO nde_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","kuthi ngapha acina khona abotshelwe ezicecisweni ezimbili, liwahlanganise eziqeni zemahlombe phambili kwesembatho semahlombe. ");
INSERT INTO nde_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Yenza amasongo amabili egolide uwabophele kwamanye amagumbi amabili esembatho sesifubeni ngaphakathi komphetho phansi kwesembatho semahlombe. ");
INSERT INTO nde_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Yenza amanye amasongo egolide amabili ubusuwabophela ngaphansi kweziqa zemahlombe phambi kwesembatho semahlombe, eduze komphetho ngaphezudlwana kwebhanti lasekhalweni lwesembatho semahlombe. ");
INSERT INTO nde_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Amasongo esembatho sesifubeni kumele abotshaniswe lamasongo esembatho semahlombe ngentambo eluhlaza, kusihlanganisa lebhanti lasokhalweni, ukwenzela ukuthi isembatho sesifubeni singatsheleli sehlukane lesembatho semahlombe. ");
INSERT INTO nde_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Kuzakuthi lapho u-Aroni engena Endaweni Engcwele, agqize phezu kwenhliziyo yakhe isembatho sesifubeni sokwahlulela esilamabizo amadodana ka-Israyeli kube yisikhumbuzo esiqhubekayo phambi kukaThixo. ");
INSERT INTO nde_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Faka njalo i-Urimi kanye leThumimi esambathweni sesifubeni, ukuze ziqondane laphezu kwenhliziyo ka-Aroni loba kunini engena endaweni kaThixo. Ngalokho u-Aroni uzabe ethwele amandla okunquma izinqumo kwabako-Israyeli phezu kwenhliziyo yakhe phambi kukaThixo.” ");
INSERT INTO nde_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Yenza isigqoko sesembatho semahlombe ngelembu eliluhlaza kuphela, ");
INSERT INTO nde_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","kube lesikhala sokungenisa ikhanda phakathi laphakathi. Kuzakuba lomphetho onjengebheqe othungwe walandelisela isikhala lesi ukuze isembatho singadabuki. ");
INSERT INTO nde_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Wenze emphethweni wesembatho amaphomegranathi ngentambo eluhlaza, eyibubende kanye lebomvu, uwugabanise lamabhera egolide. ");
INSERT INTO nde_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Amabhera egolide kumele agabane lamaphomegranathi emphethweni wesembatho. ");
INSERT INTO nde_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","U-Aroni kufanele asembathe nxa esenza umsebenzi wokukhonza. Umsindo wamabhera uyabe uzwakala lapho engena eNdaweni eNgcwele phambi kukaThixo lalapho ephuma, ukuze angafi. ");
INSERT INTO nde_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Yenza icence legolide elicolekileyo udwebe, uloba kulo njengombazi wamatshe udwebela uphawu oluthi: Ubungcwele kabube kuThixo. ");
INSERT INTO nde_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Ulibophele eqhiyeni ngentambo eluhlaza libe phambi kweqhiye. ");
INSERT INTO nde_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Lizakuba sebunzini lika-Aroni ukuze athwale amacala aqondene lezipho ezingcwele ezinikelwa ngabako-Israyeli, kungakhathalekile ukuthi yisipho bani. Lizakuba sebunzini lika-Aroni kokuphela ukuze abako-Israyeli bemukeleke kuThixo. ");
INSERT INTO nde_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Thunga ibhatshi ngelembu elicolekileyo kanye leqhiye yelembu elicolekileyo, elihle. Ibhanti lokhalo kumele lenziwe ngumbalazi ngokuthunga. ");
INSERT INTO nde_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Wenzele amadodana ka-Aroni amabhatshi, lamabhanti kanye lamaqhiye ukuze abe lesithunzi, ahlonipheke. ");
INSERT INTO nde_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Emva kokugqokisa u-Aroni umfowenu kanye lamadodana akhe lezizembatho, bagcobe ubahlukanisele ukuba ngabaphristi bami. ");
INSERT INTO nde_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Thunga izembatho zangaphansi ngelembu, zisukele ekhalweni kusiya emathangazini, zibe yizembatho zomzimba. ");
INSERT INTO nde_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","U-Aroni kanye lamadodana akhe bazazigqoka izikhathi zonke nxa bengena ethenteni lokuhlangana lanxa besondela e-alithareni ukwenza umsebenzi wokukhonza eNdaweni eNgcwele, ukuze bangabi lecala bafe. Lokhu kuzakuba yisimiso esingapheliyo ku-Aroni lakuzizukulwane zakhe.” ");
INSERT INTO nde_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Lokhu yikho ozakwenza nxa ubagcoba ukuze bangisebenzele njengabaphristi: Thatha inkunzi esesencane lenqama ezimbili ezingelasici. ");
INSERT INTO nde_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Yenza izinkwa ezingelamvubelo ngefulawa ecolekileyo, izinkwa ezinkulu ezingelamvubelo, ezivutshwe ngamafutha e-oliva lezinkwa ezincane ezingelamvubelo, zigcotshwe ngamafutha e-oliva. ");
INSERT INTO nde_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Uzifake esitsheni ubusuziletha ndawonye lenkunzi kanye lenqama ezimbili. ");
INSERT INTO nde_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Emva kwalokho ulethe u-Aroni lamadodana akhe esangweni lethente lokuhlangana ubagezise ngamanzi. ");
INSERT INTO nde_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Thatha izembatho ugqokise u-Aroni ibhatshi, lesembatho samahlombe, isembatho samahlombe sona ngokwaso kanye lesigqoko sesifuba, umbophele isembatho samahlombe ngebhanti lokhalo elelukwe ngobungcwethi obukhulu. ");
INSERT INTO nde_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Mthwalise iqhiye yokuthandela ekhanda lakhe, unamathisele umqhele wamakhosi ongcwele eqhiyeni. ");
INSERT INTO nde_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Thatha amafutha okugcobela isikhundla umgcobe ngokuwathela phezu kwekhanda lakhe. ");
INSERT INTO nde_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Letha amadodana akhe uwagqokise amabhatshi ");
INSERT INTO nde_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ubabophe ngamabhanti emakhanda, u-Aroni lamadodana akhe, ube usubathwalisa izingowane. Ubuphristi ngobabo ngesimiso esingapheliyo. Ngale indlela uzagcoba u-Aroni lamadodana akhe. ");
INSERT INTO nde_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Letha inkunzi phambi kwethente lokuhlangana, u-Aroni lamadodana akhe babeke izandla zabo phezu kwekhanda layo, ");
INSERT INTO nde_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","uyihlabe phambi kukaThixo esangweni lethente lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Uthathe igazi lenkunzi ulininde empondweni ze-alithare ngomunwe wakho, uthele igazi eliseleyo phansi e-alithareni. ");
INSERT INTO nde_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Emva kwalokho uthathe lonke idanga eligoqela ezangaphakathi, amahwahwa aphezu kwesibindi, izinso zonke lamahwahwa akuzo, ukutshise konke lokhu e-alithareni. ");
INSERT INTO nde_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Kodwa-ke inyama yenkunzi, isikhumba sayo lamathumbu ayo, ukutshisele ngaphandle kwesihonqo; kungumnikelo wesono. ");
INSERT INTO nde_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Thatha enye yenqama, u-Aroni lamadodana akhe babeke izandla zabo phezu kwekhanda layo, ");
INSERT INTO nde_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","uyihlabe, uthathe igazi layo ulichele emaceleni wonke e-alithare. ");
INSERT INTO nde_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Emva kwalokho uhlahlele inqama ibe yiziqa ugezise ezangaphakathi lemilenze ukufake ndawonye lenhloko kanye lezinye iziqa, ");
INSERT INTO nde_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","ubusutshisa inqama yonke e-alithareni. Lokhu kungumnikelo wokutshiswa kuThixo, iphunga elimnandi, umnikelo onikelwa kuThixo ngomlilo. ");
INSERT INTO nde_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Thatha enye inqama, u-Aroni lamadodana akhe babeke izandla zabo phezu kwekhanda layo. ");
INSERT INTO nde_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Uyihlabe, uthathe igazi layo ulininde esiqwini sendlebe yakwesokunene sika-Aroni lakwezamadodana akhe, lasezithupheni zabo zezandla zabo zokunene, lasemazwaneni amakhulu ezinyawo zabo zesandla sokunene. Emva kwalokho uchele igazi emaceleni wonke e-alithare. ");
INSERT INTO nde_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Thatha igazi elise-alithareni lamafutha okugcoba uchele u-Aroni lezembatho zakhe kanye lamadodana akhe lezembatho zawo. Lapho-ke yena lamadodana akhe lezivunulo zabo kuzabe sekungcwelisiwe. ");
INSERT INTO nde_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Thatha amahwahwa kule inqama, lomsila ononileyo, ledanga eligoqela ezangaphakathi, lamahwahwa aphezu kwesibindi, lezinso zombili lamahwahwa akuzo kanye lomlenze wesandla sokunene. (Le yinqama yokugcotshwa komphristi.) ");
INSERT INTO nde_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Esitsheni esilesinkwa esingelamvubelo esiphambi kukaThixo, thatha isinkwa esisodwa, isinkwa esisodwa esikhulu esixutshaniswe lamafutha e-oliva kanye lesinkwanyana. ");
INSERT INTO nde_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Konke lokhu kufake ezandleni zika-Aroni lezamadodana akhe, bakuzunguze phambi kukaThixo kube ngumnikelo wokuzunguzwa. ");
INSERT INTO nde_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Emva kwalokho kuthathe ezandleni zabo ukutshise e-alithareni ndawonye lomnikelo wokutshiswa ukuze kube liphunga elimnandi kuThixo, umhlatshelo wokudla onikelwa kuThixo. ");
INSERT INTO nde_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Emva kwalokho thatha isifuba senqama yokugcotshwa kuka-Aroni uzunguze phambi kukaThixo njengomnikelo wokuzunguzwa njalo sizakuba yisabelo sakho. ");
INSERT INTO nde_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Zenze zibengcwele lezozitho zenqama yokugcotshwa komphristi ezingezika-Aroni lamadodana akhe, isifuba esizunguziweyo lomlenze onikelweyo. ");
INSERT INTO nde_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Lokhu kuzaqhubeka kokuphela kuyisabelo sika-Aroni lamadodana akhe esivela kwabako-Israyeli. Kungumnikelo abako-Israyeli abawenzayo kuThixo uvela eminikelweni yabo yokuhlanganyela. ");
INSERT INTO nde_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Izembatho zika-Aroni ezingcwele zizakuba ngezezizukulwana zakhe ukuze bagcotshwe babekwe ubuphristi begqoke zona. ");
INSERT INTO nde_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Indodana yakhe ezakuba ngumphristi esikhundleni sakhe izazigqoka insuku eziyisikhombisa lapho isiza ethenteni lokuhlangana ukuzakhonza eNdaweni eNgcwele. ");
INSERT INTO nde_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Thatha inqama yokugcotshwa komphristi uyiphekele endaweni engcwele. ");
INSERT INTO nde_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Ethenteni lokuhlangana, u-Aroni lamadodana akhe bazakudla inyama yenqama lesinkwa esisesitsheni. ");
INSERT INTO nde_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Kumele badle leyomnikelo okwenziwa ngayo inhlawulo yokubekwa lokugcotshwa kwabo. Kodwa omunye umuntu nje akayikukudla lokhu ngoba kungcwele. ");
INSERT INTO nde_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Njalo nxa eyinye yenyama yenqama yokugcotshwa komphristi kumbe isinkwa kusele kuze kube sekuseni, kutshise ngomlilo. Akumelanga kudliwe ngoba kungcwele. ");
INSERT INTO nde_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Menzele-ke u-Aroni lamadodana akhe konke engikulaye khona, ukugcotshwa kwabo kuthathe insuku eziyisikhombisa. ");
INSERT INTO nde_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Nikela inkunzi eyodwa usuku ngosuku njengomnikelo wesono wokwenza inhlawulo. Yenza i-alithari libengcwele ngokulenzela inhlawulo, uligcobe ukuba ulingcwelise. ");
INSERT INTO nde_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Yenza inhlawulelo ye-alithare okwensuku eziyisikhombisa ulingcwelise. Lapho-ke i-alithari lizakuba ngcwele kakhulu kuthi konke okulithintayo kube ngcwele. ");
INSERT INTO nde_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Lokhu yikho ozakunikela e-alithareni usuku lunye ngalunye: amazinyane ezimvu amabili alomnyaka owodwa ezelwe. ");
INSERT INTO nde_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Nikela elilodwa ekuseni, elinye unikele ngalo njalo kusihlwa. ");
INSERT INTO nde_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Kanye lezinyane lakuqala nikela okwetshumi kwehefa yefulawa ecolekileyo ehlanganiswe lokwesine kwehini yamafutha e-oliva ahluziweyo, lokwesine kwehini yewayini ukuba kube ngumnikelo onathwayo. ");
INSERT INTO nde_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Elinye izinyane linikele kusihlwa ngomnikelo ofanayo wamabele kanye lomnikelo wokunathwayo njengowekuseni ukuba kube liphunga elimnandi, umnikelo wokutshiswa onikelwa kuThixo. ");
INSERT INTO nde_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Kuzizukulwane ezizayo umnikelo wokutshiswa lo uzakwenziwa njalonjalo esangweni lethente lokuhlangana phambi kukaThixo, lapho engizahlangana lawe khona ngikhulume lawe. ");
INSERT INTO nde_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Lapho futhi yikho engizahlangana khona labako-Israyeli, indawo leyo ingcweliswe yinkazimulo yami. ");
INSERT INTO nde_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Ngokunjalo ngizakwenza ithente lokuhlangana kanye le-alithari kube ngcwele ukuba bangisebenzele bengabaphristi. ");
INSERT INTO nde_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Lapho-ke ngizahlala phakathi kwabantu bako-Israyeli ngibe nguNkulunkulu wabo. ");
INSERT INTO nde_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Bazakwazi ukuthi mina nginguThixo uNkulunkulu wabo, owabakhupha eGibhithe ukuze ngihlale phakathi kwabo. Mina nginguThixo uNkulunkulu wabo.” ");
INSERT INTO nde_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Yenza i-alithari lokutshisela impepha ngesihlahla somʼakhakhiya. ");
INSERT INTO nde_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Amacele womane kumele alingane, kube yingalo ubude lengalo ububanzi, kuthi ukudepha kube zingalo ezimbili, impondo zalo zibe yinto yinye lalo. ");
INSERT INTO nde_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Huqa phezulu lamacele wonke, lempondo zalo ngegolide elicolekileyo ubumbele umqolo wegolide inxa zonke. ");
INSERT INTO nde_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Yenza amasongo egolide amabili e-alithare abe ngaphansi komqolo emaceleni amabili ehlukeneyo ukuba abambe imijabo yokulithwala. ");
INSERT INTO nde_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Imijabo yenze ngesihlahla somʼakhakhiya uyihuqe ngegolide. ");
INSERT INTO nde_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Beka i-alithari phambi kwekhetheni elisithe umtshokotsho wobufakazi, nganeno kwesihlalo somusa esiphezu kwezibhebhedu zesivumelwano somthetho lapho engizahlangana lawe khona. ");
INSERT INTO nde_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","U-Aroni kumele atshise impepha enuka mnandi e-alithareni nsuku zonke ekuseni elungisa izibane. ");
INSERT INTO nde_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Kumele impepha ayitshise futhi kusihlwa lapho eselumathisa izibane ukuze impepha itshe kokuphela phambi kukaThixo kuze kube kuzizukulwane ezizayo. ");
INSERT INTO nde_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Linganikeli kuleli-alithare olunye uhlobo lwempepha kumbe umnikelo wokutshiswa loba umnikelo wamabele, njalo lingatheli umnikelo wokunathwa phezu kwalo. ");
INSERT INTO nde_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Kanye ngomnyaka u-Aroni uzakwenza inhlawulelo empondweni zalo. Inhlawulo yeminyaka yonke le kumele yenziwe ngegazi lomnikelo wokuhlawulela izono zezizukulwane ezizayo. Ingcwele kakhulu kuThixo.” ");
INSERT INTO nde_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","UThixo wasesithi kuMosi, ");
INSERT INTO nde_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Lapho usubala abantu bako-Israyeli omunye lomunye kumele anike uThixo inhlawulo yokuphila kwakhe. Ngalokho akuyikuba lesifo esizabehlela lapho ubabala. ");
INSERT INTO nde_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Akuthi lowo lalowo odlulela ngakulabo asebebaliwe anike ingxenye yeshekeli, ngokweshekeli lendawo engcwele, okuyisisindo esingamagera angamatshumi amabili. Ingxenye yeshekeli le ingumnikelo kuThixo. ");
INSERT INTO nde_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Wonke umuntu obaliweyo, kusukela koleminyaka engamatshumi amabili kusiya phezulu, uzanikela umnikelo kuThixo. ");
INSERT INTO nde_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Abanothileyo akumelanga banikele ngokwedlula ingxenye yeshekeli, labayanga kabanganikeli ngokungaphansi lapho selinikela kuThixo ukuba lenze inhlawulelo yokuphila kwenu. ");
INSERT INTO nde_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Wamukele imali yenhlawulo kwabako-Israyeli uyisebenzise enkonzweni yethente lokuhlangana. Izakuba yisikhumbuzo kwabako-Israyeli phambi kukaThixo ukwenzela inhlawulelo yokuphila kwenu.” ");
INSERT INTO nde_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","UThixo wasesithi kuMosi, ");
INSERT INTO nde_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Yenza inkonxa yethusi ibe lensika yethusi, izakuba ngeyokugezela. Uyibeke phakathi laphakathi kwethente lokuhlangana le-alithari, uthele amanzi phakathi kwayo. ");
INSERT INTO nde_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","U-Aroni lamadodana akhe bazageza izandla lezinyawo zabo ngamanzi akuyo. ");
INSERT INTO nde_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Nxa bengena ethenteni lokuhlangana bazageza ngamanzi ukuze bangafi. Phezu kwalokho, lapho besondela e-alithareni ukuba bakhonze ngokwethula umnikelo wokutshiswa onikelwa kuThixo, ");
INSERT INTO nde_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","bazageza izandla zabo lezinyawo ukuze bangafi. Lokhu kuzakuba yisimiso esingapheliyo ku-Aroni lenzalo yakhe lakuzizukulwane ezizayo.” ");
INSERT INTO nde_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","UThixo wasesithi kuMosi, ");
INSERT INTO nde_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Thatha lezinhlobo zamakha amahle: Amashekeli angamakhulu amahlanu (500) emure elingamanzi, isinamoni enuka mnandi eyingxenye yalokho (okuyikuthi amakhulu amabili lamatshumi amahlanu (250) amashekeli), amashekeli angamakhulu amabili lamatshumi amahlanu (250) ekhalamu elilephunga elimnandi, ");
INSERT INTO nde_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","amashekeli angamakhulu amahlanu (500) ekhasiya, konke kumayelana lamashekeli endawo engcwele, kanye lehini lamafutha ama-oliva. ");
INSERT INTO nde_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Lokhu kwenze kube ngamafutha angcwele okugcoba abakhethiweyo alungiswe ngumenzi wamakha, azakuba ngamafutha angcwele okugcoba abakhethiweyo. ");
INSERT INTO nde_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Ngawo-ke uzagcoba ithente lokuhlangana, umtshokotsho wobufakazi, ");
INSERT INTO nde_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","itafula kanye lezitsha zawo zonke, uluthi lwesibane lezitsha zawo, i-alithari lempepha, ");
INSERT INTO nde_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","i-alithari lomnikelo wokutshiswa lezitsha zawo lomganu wokugezela kanye lezinyawo zawo. ");
INSERT INTO nde_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Uzakungcwelisa konke ukuba kube ngcwele kakhulu, njalo loba yini ekuthintayo izakuba ngcwele. ");
INSERT INTO nde_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Mgcobe u-Aroni lamadodana akhe ubehlukanisele ukuba bangisebenzele bengabaphristi. ");
INSERT INTO nde_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Batshele abako-Israyeli uthi, ‘Lokhu kuzakuba ngamafutha ami angcwele okugcoba abakhethiweyo lakuzizukulwane zenu ezizayo. ");
INSERT INTO nde_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Lingawatheli emizimbeni yabantu, njalo lingenzi amanye amafutha ngale indlela yokuwenza. Ingcwele, izakuba ngcwele lakini. ");
INSERT INTO nde_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Lowo ozakwenza amakha afana lawo kumbe agcobe ngawo umuntu ongasuye mphristi, uzasuswa ebantwini bakibo.’ ” ");
INSERT INTO nde_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","UThixo wabuye wathi kuMosi, “Thatha amakha anuka mnandi, isitakete, i-onika legalibhanumi kanye lenhlaka enhle, konke kungesilinganiso esifanayo, ");
INSERT INTO nde_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","wenze ingxube yempepha elephunga elimnandi njengomxubi wamakha, ifakwe itswayi ibenhle njalo ibe ngcwele. ");
INSERT INTO nde_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Chola enye yayo ibe yimpuphu uyifake phambi komtshokotsho wobufakazi phakathi kwethente lokuhlangana lapho engizahlangana lawe khona. Izakuba ngcwele kakhulu kini. ");
INSERT INTO nde_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Lingazenzeli eyenu impepha ngale indlela, iboneni njengento engcwele kuThixo. ");
INSERT INTO nde_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Lowo ozakwenza enye efana layo ukuba akholise ukunukelela kwayo kamnandi, kumele asuswe ebantwini bakibo.” ");
INSERT INTO nde_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Khangela, sengikhethe uBhezaleli indodana ka-Uri oyindodana kaHuri owesizwe sikaJuda ");
INSERT INTO nde_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ngamgcwalisa ngomoya kaNkulunkulu, ukuhlakanipha, ukuqedisisa lolwazi ekwenzeni yonke imisebenzi yobungcitshi ");
INSERT INTO nde_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ukuze adwebe imisebenzi yobungcitshi ngesimo sezinto ezenziwa ngegolide, isiliva kanye lethusi, ");
INSERT INTO nde_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","abaze amatshe awabeke kuhle, abaze izigodo kanye lokwenza yonke imisebenzi yomuntu oleminwe lobungcwethi. ");
INSERT INTO nde_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Phezu kwalokho, ngikhethe lo-Oholiyabhi indodana ka-Ahisamakhi, owesizwe sikaDani ukuba amncedise. Nginike ulwazi kuzozonke izingcitshi ukuba zenze konke engikulaye ukuba kwenziwe: ");
INSERT INTO nde_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","ithente lokuhlangana, umtshokotsho wobufakazi, isihlalo somusa esikuwo, lakho konke okunye okokuhlobisa ithente: ");
INSERT INTO nde_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","itafula lezitsha zalo, uluthi lwesibane lwegolide elicolekileyo lezitsha zalo zonke, i-alithari lempepha, ");
INSERT INTO nde_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","i-alithari lomnikelo wokutshiswa kanye lezitsha zalo zonke, lomkolo kanye lezinyawo zawo ");
INSERT INTO nde_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","lezembatho ezelukiweyo, lezembatho ezingcwele zika-Aroni umphristi kanye lezembatho zamadodana akhe ezomsebenzi wabo wobuphristi, ");
INSERT INTO nde_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","lamafutha okugcobela isikhundla, lempepha enuka mnandi eyeNdawo eNgcwele. Kumele bakwenze njengoba ngikulayile.” ");
INSERT INTO nde_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","UThixo wasesithi kuMosi, ");
INSERT INTO nde_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Batshele abako-Israyeli uthi, ‘Kumele ligcine amaSabatha ami. Lokhu kuzakuba luphawu phakathi kwami lani kuzizukulwane zenu ezizayo, ukuze lazi ukuthi mina nginguThixo olenza libengcwele. ");
INSERT INTO nde_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Gcinani iSabatha ngoba lingcwele kini. Lowo olonayo kumele abulawe, lalowo osebenzayo ngalolosuku uzasuswa ebantwini bakibo. ");
INSERT INTO nde_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Umsebenzi kawenziwe okwensuku eziyisithupha, kodwa usuku lwesikhombisa luliSabatha lokuphumula, lungcwele kuThixo. Lowo osebenzayo ngosuku lweSabatha kumele abulawe. ");
INSERT INTO nde_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Abako-Israyeli kumele bagcine iSabatha, baligcine kuzizukulwane zabo ezizayo njengesivumelwano esingapheliyo. ");
INSERT INTO nde_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Lizakuba luphawu phakathi kwami labako-Israyeli nini lanini. Ngoba ngezinsuku eziyisithupha uThixo wenza amazulu lomhlaba, kwathi ngosuku lwesikhombisa waphumula.’ ” ");
INSERT INTO nde_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Kwathi lapho uThixo eseqedile ukukhuluma loMosi entabeni yaseSinayi wamnika izibhebhedu ezimbili zamatshe obufakazi, izibhebhedu zamatshe alotshwe ngomunwe kaNkulunkulu. ");
INSERT INTO nde_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Kwathi lapho abantu bebona uMosi esephuzile ukwehla entabeni, babuthana ku-Aroni bathi kuye, “Lalela, senzele onkulunkulu abazahamba phambi kwethu, ngoba umuntu lo, uMosi owasikhupha elizweni laseGibhithe, asikwazi osekwenzakale kuye.” ");
INSERT INTO nde_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","U-Aroni wabaphendula wathi, “Khuphani amacici egolide asendlebeni zamakhosikazi enu, amadodana enu lamadodakazi enu, liwalethe kimi.” ");
INSERT INTO nde_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ngakho abantu bonke bawakhupha amacici abo bawasa ku-Aroni. ");
INSERT INTO nde_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Wathatha lokho abamnikeza khona wakwenza kwaba yisithombe esibunjwe ngesimo sethole esebenzisa insimbi yokukhanda. Basebesithi, “Laba yibo onkulunkulu benu, Oh Israyeli, abalikhupha elizweni laseGibhithe.” ");
INSERT INTO nde_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Kwathi u-Aroni ebona lokhu wakha i-alithari phambi kwethole wamemezela wathi, “Kusasa kuzakuba lomkhosi kaThixo.” ");
INSERT INTO nde_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Ngakho ngosuku olwalandelayo abantu bavuka ekuseni kakhulu banikela umnikelo wokutshiswa, baletha lomnikelo wobudlelwano. Emva kwalokho bahlala phansi badla, banatha; basukuma bagida. ");
INSERT INTO nde_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Lapho-ke uThixo wathi kuMosi, “Yehla uye phansi ngoba abantu bakho owabakhupha elizweni laseGibhithe sebegcwele ububi. ");
INSERT INTO nde_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Baphangisile badela konke engabalaya khona bazenzela isithombe esibunjwe safana lethole. Basikhothamele banikela iminikelo kiso bathi, ‘Laba yibo onkulunkulu benu, bako-Israyeli, abalikhupha eGibhithe.’ ” ");
INSERT INTO nde_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","UThixo wasebuya wathi kuMosi, “Sengibabonile abantu laba; ngabantu abantamo zilukhuni. ");
INSERT INTO nde_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Khathesi-ke ngiyekela ngingedwa ukuze ulaka lwami luvuthe phezu kwabo, ngibatshabalalise. Besengizakwenza isizwe esikhulu.” ");
INSERT INTO nde_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Kodwa uMosi wacela umusa kuThixo uNkulunkulu wakhe, wathi, “Awu Thixo, kungani ulaka lwakho kumele luvuthele abantu bakho owabakhupha eGibhithe ngamandla amakhulu langesandla esiqinileyo na? ");
INSERT INTO nde_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Kungani amaGibhithe kumele athi, ‘Wabakhupha elizweni ngenxa yenhloso embi ukuba ababulalele ezintabeni, ababhubhise baphele ebusweni bomhlaba’? Phenduka olakeni lwakho olwesabekayo, uthambise umoya wakho, ungaletheli abantu bakho ukubhujiswa. ");
INSERT INTO nde_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Khumbula izinceku zakho u-Abhrahama, u-Isaka lo-Israyeli owafunga kubo wena ngokwakho wathi, ‘Ngizakwandisa inzalo yenu ibe ngangezinkanyezi zasemkhathini, ngiyinike lonke ilizwe engalithembisa lona ukuba libe yilifa layo kuze kube nini lanini.’ ” ");
INSERT INTO nde_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Lapho-ke uThixo waguquka ebubini ayesemise ukubehlisela ebantwini bakhe. ");
INSERT INTO nde_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","UMosi waphenduka wehla entabeni ephethe izibhebhedu ezimbili zamatshe obufakazi ezandleni zakhe. Zazilotshwe inxa zombili, phambili langemuva. ");
INSERT INTO nde_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Izibhebhedu zamatshe zazingumsebenzi kaNkulunkulu; umbhalo ungumbhalo kaNkulunkulu owawulotshwe ezibhebhedwini zamatshe. ");
INSERT INTO nde_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Kwathi lapho uJoshuwa esizwa umsindo wabantu beklabalala, wathi kuMosi, “Kulokuhlokoma kwempi ezihonqweni.” ");
INSERT INTO nde_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","UMosi waphendula wathi: “Akusiyo nhlokomo yokunqoba, akusiyo nhlokomo yokunqotshwa; yinhlokomo yokuhlabela mina engiyizwayo.” ");
INSERT INTO nde_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Kwathi uMosi esebanga ezihonqweni ebona ithole kanye lokugida okwakusenziwa, ulaka lwakhe lwavutha, walahla izibhebhedu ezazisezandleni zakhe, zahlephuka zaba yizicucu ewatheni lwentaba. ");
INSERT INTO nde_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Wathatha ithole abebelenzile walitshisa emlilweni; walichola laba yimpuphu, wayiphosela emanzini, wathi bawanathe abako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Wasesithi ku-Aroni, “Abantu laba benzeni kuwe uze ubakhokhelele esonweni esikhulu kangaka na?” ");
INSERT INTO nde_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","U-Aroni waphendula wathi, “Ungathukutheli nkosi yami. Uyakwazi ukuthi abantu laba bathanda ububi. ");
INSERT INTO nde_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Bathe kimi, ‘Senzele onkulunkulu abazahamba phambi kwethu. Umuntu lo, uMosi owasikhupha elizweni laseGibhithe, asikwazi osokwenzakale kuye.’ ");
INSERT INTO nde_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ngakho mina ngathi kubo, ‘Loba ngubani olomceciso wegolide kawukhuphe.’ Basebengipha-ke igolide ngaliphosa emlilweni, kwasekuphuma ithole leli.” ");
INSERT INTO nde_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","UMosi wabona ukuthi abantu babengasabambeki kanye lokuthi u-Aroni wayesebaxhwalisile baze baba yinhlekisa ezitheni zabo. ");
INSERT INTO nde_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Ngakho wema esangweni lezihonqo wathi, “Wonke ongokaThixo, keze kimi.” Wonke amadodana kaLevi ayabuthana kuye. ");
INSERT INTO nde_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Wasesithi kuwo, “Lokhu yikho okutshiwo nguThixo, uNkulunkulu ka-Israyeli, ukuthi, ‘Indoda ngayinye kayibophele inkemba yayo ngebhanti eceleni kwayo, lihambahambe phakathi kwezihonqo lisuka kwelinye icele lazo lisiya kwelinye, indoda ngayinye ibulale umfowabo, umzalwane lomakhelwane wayo.’ ” ");
INSERT INTO nde_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Amadodana kaLevi enza njengokulaywa kwawo nguMosi. Ngakho ngalolosuku kwafa abantu ababengaba zinkulungwane ezintathu. ");
INSERT INTO nde_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","UMosi wasesithi kubo, “Lamuhla lina selahlukaniselwe uThixo ngoba limelane lamadodana enu labafowenu, ngalokho uselibusisile lamhla.” ");
INSERT INTO nde_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ngelanga elalandelayo uMosi wathi ebantwini, “Lenze isono esikhulu kakhulu. Kodwa khathesi ngizaqansa ngiye phezulu kuThixo, mhlawumbe ngingenza inhlawulelo yesono senu.” ");
INSERT INTO nde_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ngakho uMosi wabuyela kuThixo wathi kuye, “Awu, abantu laba sebenze isono esikhulu kakhulu. Bazenzele onkulunkulu ngegolide. ");
INSERT INTO nde_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ake ubathethelele izono zabo kodwa nxa kungenjalo, ngesula ogwalweni olulobileyo.” ");
INSERT INTO nde_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","UThixo wamphendula uMosi wathi, “Lowo owenze isono kimi ngizamesula ogwalweni lwami. ");
INSERT INTO nde_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Khathesi hamba, ukhokhelele abantu endaweni engakhuluma ngayo kuwe. Ingilosi yami izahamba phambi kwakho. Kodwa-ke nxa isikhathi sami sokujezisa sesifikile, ngizabajezisa ngenxa yesono sabo.” ");
INSERT INTO nde_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","UThixo wabajezisa abantu ngesifo ngenxa yalokho abakwenza ngethole elalenziwe ngu-Aroni. ");
INSERT INTO nde_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","UThixo wasesithi kuMosi, “Suka kule indawo wena labantu owabakhupha elizweni laseGibhithe, uye elizweni engalithembisa u-Abhrahama lo-Isaka loJakhobe ngifunga ngisithi, ‘Ngizalinika inzalo yakho.’ ");
INSERT INTO nde_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ngizathuma ingilosi ihambe phambi kwakho ixotshe amaKhenani, ama-Amori, amaHithi, amaPherizi, amaHivi lamaJebusi. ");
INSERT INTO nde_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Yana elizweni eligeleza uchago loluju. Kodwa mina angiyikuhamba lani ngoba lingabantu abantamo zilukhuni, hlezi ngilibhubhise endleleni.” ");
INSERT INTO nde_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Kwathi lapho abantu sebezwe amazwi la adabukisayo baqalisa ukukhala, akwaze kwaba loyedwa owagqiza izigqizo zakhe. ");
INSERT INTO nde_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Phela uThixo wayethe kuMosi, “Tshela abako-Israyeli uthi, ‘Lina lingabantu abantamo zilukhuni. Nxa ngingahamba lani loba okomzuzwana nje, ngingalibhubhisa. Khathesi khululani izigqizo zenu; ngizakwenza isinqumo ukuthi ngenzeni ngani.’ ” ");
INSERT INTO nde_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Ngakho-ke abako-Israyeli bazikhipha izigqizo zabo entabeni yeHorebhi. ");
INSERT INTO nde_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","UMosi wayejwayele ukuthatha ithente ayelimisa ngaphandle bucwadlana lezihonqo. Walibiza ngokuthi “lithente lokuhlangana.” Ubani lobani owayedinga uThixo wayesiya ethenteni lokuhlangana ngaphandle kwezihonqo. ");
INSERT INTO nde_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Kwakusithi-ke lapho uMosi ephuma esiya kulelothente abantu bonke babesukuma bame eminyango yamathente abo bakhangele uMosi aze angene ethenteni. ");
INSERT INTO nde_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Kwakusithi uMosi esengena ethenteni insika yeyezi yehlele phansi ime emnyango wethente lapho uThixo ekhuluma loMosi. ");
INSERT INTO nde_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Kwakusithi abantu bangabona insika yeyezi isimi emnyango wethente basukume bonke bakhonze; lowo lalowo emnyango wethente lakhe. ");
INSERT INTO nde_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","UThixo wayekhuluma loMosi ubuso ngobuso njengomuntu ekhuluma lomngane wakhe. Ngemva kwalokho uMosi wayebuyela ezihonqweni, kodwa umncedisi wakhe owayesesemncane, uJoshuwa indodana kaNuni, wayengasuki ethenteni. ");
INSERT INTO nde_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","UMosi wathi kuThixo, “Ubulokhu ungitshela usithi, ‘Khokhela abantu laba,’ kodwa kawungazisanga ukuthi ngubani ozamthuma ukuba ahambe lami. Utshilo wathi, ‘Ngiyakwazi ngebizo, njalo ufumene umusa kimi.’ ");
INSERT INTO nde_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Nxa uthokoza ngami, ngifundisa izindlela zakho ukuze ngikwazi, ngiqhubeke ngithola umusa kuwe. Khumbula futhi lokuthi isizwe lesi singabantu bakho.” ");
INSERT INTO nde_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","UThixo waphendula wathi, “NgoBukhona bami ngizahamba lawe ngikuphumuze.” ");
INSERT INTO nde_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","UMosi wathi kuye, “Nxa uBukhona bakho bungahambi lathi, ungasisusi lapha. ");
INSERT INTO nde_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Umuntu angakwazi njani ukuthi mina labantu bakho sifumene umusa kuwe ngaphandle kokuba uhamba lathi na? Kuyini okunye okungasiphawula, mina labantu bakho, kwabanye abantu bonke emhlabeni na?” ");
INSERT INTO nde_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","UThixo wathi kuMosi, “Ngizakwenza khona kanye lokhu okucelileyo ngoba ngiyathokoza ngawe, njalo ngikwazi ngebizo.” ");
INSERT INTO nde_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","UMosi wasesithi, “Ngicela ukuba ungitshengise inkazimulo yakho.” ");
INSERT INTO nde_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","UThixo wasesithi, “Ngizakwenza ukulunga kwami kudlule phambi kwakho, njalo ngizamemezela ibizo lami, uThixo, phambi kwakho. Ngizakuba lesihawu kulowo engizakuba lesihawu kuye njalo ngibe lesisa kulowo engizakuba lesisa kuye.” ");
INSERT INTO nde_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","UThixo waqhubeka wathi, “Kodwa, ubuso bami awungeke ububone, ngoba kakho ongangibona aphile.” ");
INSERT INTO nde_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","UThixo wabuya wathi, “Kulendawo phansi kwami lapho ongema khona phezu kwedwala. ");
INSERT INTO nde_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Kuzakuthi lapho inkazimulo yami isedlula eduze, ngizakufaka emnkenkeni wedwala ngikusithe ngesandla sami ngize ngidlule. ");
INSERT INTO nde_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Emva kwalokho ngizasusa isandla sami ubone umhlane wami; kodwa ubuso bami akumelanga ububone.” ");
INSERT INTO nde_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","UThixo wathi kuMosi, “Baza ezinye izibhebhedu zamatshe ezimbili zifanane lezakuqala. Ngizabhala kuzo amazwi ayesezibhebhedwini zakuqala owaziphahlazayo. ");
INSERT INTO nde_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ube usulungile ekuseni, ubuye phezulu entabeni iSinayi, uziveze kimi engqongweni yentaba. ");
INSERT INTO nde_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Akungabi lamuntu oza lawe kumbe oke abonakale loba kungaphi entabeni; ngitsho lezimvu lenkomo kazingadli phambi kwaleyontaba.” ");
INSERT INTO nde_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ngakho uMosi wabaza izibhebhedu zamatshe ezimbili zaba njengezakuqala, wakhwela entabeni iSinayi ekuseni kakhulu njengokulaywa kwakhe nguThixo ephethe izibhebhedu ezimbili zamatshe ezandleni zakhe. ");
INSERT INTO nde_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","UThixo wehla ngeyezi wema khonapho laye wamemezela ibizo lakhe esithi, “UThixo.” ");
INSERT INTO nde_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Wedlula phambi kukaMosi ememezela esithi, “UThixo, uThixo; uNkulunkulu olesihawu lomusa, ophuzayo ukuthukuthela, ogcwele uthando lobuqotho, ");
INSERT INTO nde_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","olothando olungapheliyo kuzinkulungwane ethethelela ububi, iziphosiso lezono. Ikanti abalamacala kabayekeli bengajeziswanga; wehlisela ububi baboyise phezu kwabantwana, laphezu kwabantwana babantwana kusiya kusizukulwane sesithathu lesesine.” ");
INSERT INTO nde_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","UMosi waphanga wakhothamisela ikhanda lakhe phansi, wakhonza. ");
INSERT INTO nde_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Wathi, “Awu Thixo, nxa ngithole umusa kuwe, ngiyacela, uThixo kahambe lathi. Lanxa abantu laba bentamo zilukhuni, sithethelele ububi bethu lezono zethu, usithathe njengelifa lakho.” ");
INSERT INTO nde_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","UThixo wasesithi, “Sengisenza isivumelwano lawe. Phambi kwabantu bakho bonke ngizakwenza izimangaliso ezingakaze zenziwe lanini lakusiphi isizwe emhlabeni wonke. Abantu ohlala phakathi kwabo bazabona ukuthi umangalisa njani umsebenzi, mina Thixo, engizakwenzela wona. ");
INSERT INTO nde_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Lalela lokhu engikulaya khona lamhla. Ngizawaxotsha phambi kwakho ama-Amori, amaKhenani, amaHithi, amaPherizi, amaHivi lamaJebusi. ");
INSERT INTO nde_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Qaphela ukuba kungabi lesivumelwano osenza lalabo abahlala elizweni oya kulo ngoba bangaba yisifu kini. ");
INSERT INTO nde_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Adilizeni ama-alithare abo, libhidlize lezithombe zabo, liqume lezinsika zika-Ashera wabo abamkhonzayo. ");
INSERT INTO nde_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Lingakhonzi omunye unkulunkulu, ngoba uThixo, obizo lakhe linguBukhwele, nguNkulunkulu olobukhwele. ");
INSERT INTO nde_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Qaphelani lingenzi isivumelwano lalabo abahlala elizweni lelo ngoba nxa bephinga labonkulunkulu babo benikela iminikelo kubo, bazalinxusa beselisidla imihlatshelo yabo. ");
INSERT INTO nde_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Njalo lapho likhetha amanye amadodakazi abo ukuba abe ngabafazi bamadodana enu kuzakuthi lapho amadodakazi lawo esezibhixa kubonkulunkulu bawo, ahugele amadodana enu ekwenzeni okunjalo. ");
INSERT INTO nde_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Lingazenzeli onkulunkulu ababunjiweyo. ");
INSERT INTO nde_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Gcinani uMkhosi weSinkwa esingelaMvubelo. Okwensuku eziyisikhombisa dlanini isinkwa esenziwe kungekho mvubelo, njengokulaya kwami. Lokho kwenzeni ngesikhathi esimisiweyo enyangeni ka-Abhibhi, ngoba ngaleyonyanga laphuma eGibhithe. ");
INSERT INTO nde_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Inzalo yakuqala yonke ezelweyo ngeyami, kanye lamazibulo wonke amaduna ezifuyo zenu, loba engawenkomo kumbe awezimvu. ");
INSERT INTO nde_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Izibulo likababhemi lihlengeni ngezinyane. Kodwa nxa lingangalihlengi lephuleni intamo yalo. Ahlengeni wonke amadodana enu angamazibulo. Kakho ozakuza phambi kwami engaphethe lutho. ");
INSERT INTO nde_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Lizasebenza insuku eziyisithupha, kodwa ngosuku lwesikhombisa lizaphumula; langesikhathi sokulima lesokuvuna kuzamele liphumule. ");
INSERT INTO nde_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Thakazelelani uMkhosi wamaViki lokolibo kokuvuna kwenu ingqoloyi loMkhosi wokuButhelela ekupheleni komnyaka. ");
INSERT INTO nde_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Kathathu ngomnyaka bonke abesilisa bakho kumele babonakale phambi kukaThixo Wobukhosi, uNkulunkulu ka-Israyeli. ");
INSERT INTO nde_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Ngizaxotsha izizwe eziphambi kwenu njalo ngiqhelise ilizwe lenu, kakho ozahawukela ilizwe lenu ngesikhathi lisiyabonakala kathathu ngomnyaka phambi kukaThixo uNkulunkulu wenu. ");
INSERT INTO nde_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Linganikeli igazi lomhlatshelo kimi ndawonye laloba yini elemvubelo, njalo akungabi lomhlatshelo woMkhosi wePhasika ogcinwa kuze kuse. ");
INSERT INTO nde_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Lethani okolibo kwenu okuhle kakhulu endlini kaThixo uNkulunkulu wenu. Lingapheki izinyane lembuzi ngochago lukanina.” ");
INSERT INTO nde_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","UThixo wasesithi kuMosi, “Loba amazwi la, ngoba ngamazwi la sengenze isivumelwano lawe kanye lo-Israyeli.” ");
INSERT INTO nde_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","UMosi wayekhonale loThixo insuku ezingamatshumi amane lobusuku obungamatshumi amane engadli sinkwa kumbe ukunatha amanzi. Amazwi esivumelwano ayimiThetho eliTshumi, wawaloba ezibhebhedwini zamatshe. ");
INSERT INTO nde_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Kwathi lapho uMosi esehla entabeni yeSinayi ephethe izibhebhedu ezimbili zamatshe obufakazi, wayengazi ukuthi ubuso bakhe babukhazimula ngenxa yokuthi wayekhulume loThixo. ");
INSERT INTO nde_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Kwathi u-Aroni labo bonke abako-Israyeli bebona uMosi, ubuso bakhe bukhazimula, besaba ukusondela kuye. ");
INSERT INTO nde_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Kodwa uMosi wababiza; ngakho u-Aroni lezinduna zonke zabantu beza kuye, wakhuluma labo. ");
INSERT INTO nde_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Emva kwalokho bonke abako-Israyeli basondela kuye wabanika yonke imilayo kaThixo ayemuphe yona entabeni yeSinayi. ");
INSERT INTO nde_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","UMosi eseqedile ukukhuluma labo, wamboza ubuso bakhe ngeveli. ");
INSERT INTO nde_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Kodwa kwakusithi lapho esengena ukuba abe phambi kukaThixo ukuze akhulume laye, wayelisusa iveli aze aphume. Wayesithi angaphuma, njalo esebatshelile abako-Israyeli lokho ayekulayiwe, ");
INSERT INTO nde_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","babebona ukuthi ubuso bakhe babukhazimula. Lapho-ke uMosi wayebumboza njalo ubuso bakhe ngeveli aze angene esiyakhuluma loThixo. ");
INSERT INTO nde_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","UMosi wabuthanisa isizwe sonke sako-Israyeli wathi kuso, “Lokhu yikho uThixo alilaye ukuba likwenze: ");
INSERT INTO nde_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Okwensuku eziyisithupha lizaqhuba imisebenzi, kodwa usuku lwesikhombisa luzakuba lusuku lwenu olungcwele, iSabatha lokuphumula kuThixo. Loba ngubani ozakwenza umsebenzi ngalolosuku kuzamele abulawe. ");
INSERT INTO nde_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Lingabasi umlilo loba kungaphi elihlala khona ngosuku lweSabatha.” ");
INSERT INTO nde_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Ekhuluma lesizwe sonke sako-Israyeli uMosi wathi, “Lokhu yikho uThixo athe kwenziwe: ");
INSERT INTO nde_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Kulokho elilakho khiphani umnikelo kaThixo. Wonke ozimiseleyo ukuletha kuThixo umnikelo: wegolide, isiliva kanye lethusi, ");
INSERT INTO nde_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","intambo eziluhlaza, eziyibubende kanye lezibomvu; lelembu elicolekileyo, uboya bembuzi, ");
INSERT INTO nde_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","izikhumba zenqama eziphendulwe ngomphendulo obomvu kanye lezikhumba zezinyamazana eziqinileyo; lezigodo zesihlahla somʼakhakhiya; ");
INSERT INTO nde_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","amafutha e-oliva awokukhanyisa isibane, amakha azasetshenziswa lamafutha okugcoba abakhethiweyo lephunga lempepha elimnandi, ");
INSERT INTO nde_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","amatshe e-onikisi lamanye amatshe aligugu azathungelwa esembathweni semahlombe lesesifubeni. ");
INSERT INTO nde_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Bonke abazingcitshi phakathi kwenu kumele beze bazokwenza konke lokho uThixo alaye ukuthi kwenziwe: ");
INSERT INTO nde_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ithabanikeli lethente lalo kanye lesisibekelo, ingwegwe, amathala, imithando enqumayo, izinsika lezisekelo; ");
INSERT INTO nde_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","umtshokotsho wobufakazi lemijabo yawo kanye lesisibekelo esiyisihlalo somusa lekhetheni lokulisitha; ");
INSERT INTO nde_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","itafula lemijabo yalo lezitsha zonke kanye lesinkwa esiNgcwele, ");
INSERT INTO nde_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","uluthi lwesibane sokukhanyisa kanye lezitsha zalo, izibane lamafutha okukhanyisa, ");
INSERT INTO nde_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","i-alithari lempepha lemijabo yalo, amafutha okugcoba abakhethiweyo kanye lempepha elephunga elimnandi, ikhetheni lomnyango esangweni lokuya ethabanikeleni, ");
INSERT INTO nde_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","i-alithari leminikelo yokutshiswa leminxibo yokosa eyenziwe ngethusi, imijabo kanye lezitsha zalo zonke, inditshi yethusi kanye lesisekelo sayo, ");
INSERT INTO nde_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","amakhetheni eguma kanye lezinsika zalo lezisekelo, njalo lekhetheni lesango leguma, ");
INSERT INTO nde_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","izikhonkwane zethente, ezethabanikeli kanye lezeguma, lamagoda azo, ");
INSERT INTO nde_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","izembatho ezelukiweyo ezisetshenziswa ekuphatheni umsebenzi endaweni engcwele, zonke izembatho ezingcwele zika-Aroni umphristi kanye lezembatho zamadodana akhe abazisebenzisayo emsebenzini wobuphristi.” ");
INSERT INTO nde_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Ngemva kwalokho isizwe sonke sako-Israyeli sasuka phambi kukaMosi, ");
INSERT INTO nde_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","kwathi wonke umuntu owayezimisele lowayefuqwa yinhliziyo waletha umnikelo kuThixo ukuze usetshenziswe ethenteni lokuhlangana lakuzo zonke inkonzo zalo, kanye lakuzembatho ezingcwele. ");
INSERT INTO nde_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Bonke ababezimisele, abesilisa labesifazane ngokufanayo, baletha izinto zokucecisa ezemihlobo ngemihlobo ezenziwe ngegolide: izipenede, amacici, indandatho kanye lazozonke izinto zokucecisa. Bonke baletha igolide labo kwaba ngumnikelo wokuzunguzwa phambi kukaThixo. ");
INSERT INTO nde_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Wonke umuntu owayelentambo eziluhlaza, eziyibubende, ezibomvu kumbe ilembu elicolekileyo, kumbe uboya bembuzi, izikhumba zenqama eziphendulwe ngomphendulo obomvu loba izikhumba zenyamazana zolwandle wakuletha. ");
INSERT INTO nde_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Labo ababeleminikelo yesiliva kumbe eyethusi bayiletha njengomnikelo kuThixo, kanti laye wonke umuntu owayelezigodo zesihlahla somʼakhakhiya ezazingasetshenziswa kuloba yiwuphi umsebenzi, waziletha. ");
INSERT INTO nde_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Wonke owesifazane olobuciko bokweluka waletha ayekweluke ngezandla zakhe, intambo eziluhlaza, eziyibubende lezibomvu kumbe ilembu elicolekileyo. ");
INSERT INTO nde_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Kanjalo bonke abesifazane ababezimisele futhi belobuciko beluka ngoboya bembuzi. ");
INSERT INTO nde_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Abakhokheli baletha amatshe aligugu e-onikisi kanye lamanye njalo amatshe aligugu ukuthi athungelwe emahlombe lasesifubeni sesembatho. ");
INSERT INTO nde_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Baletha njalo leziyoliso kanye lamafutha e-oliva awokukhanyisa lawokugcoba abakhethiweyo kanye lempepha elephunga elimnandi. ");
INSERT INTO nde_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Bonke abako-Israyeli abesilisa labesifazane ababezimisele baletha iminikelo ngokukhululeka kuThixo ukuze kwenziwe yonke imisebenzi uThixo ayelaye uMosi ukuthi bayenze. ");
INSERT INTO nde_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Ngalokho uMosi wathi kwabako-Israyeli, “Khangelani, uThixo usekhethe uBhezaleli indodana ka-Uri, indodana kaHuri, owesizwe sikaJuda, ");
INSERT INTO nde_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","njalo usemgcwalise ngoMoya kaNkulunkulu, ukuhlakanipha, ukuqedisisa kanye lolwazi ekwenzeni yonke imisebenzi yobungcitshi ");
INSERT INTO nde_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ukuba adwebe ngobungcitshi isimo sezinto ezizabazwa ngegolide, isiliva kanye lethusi, ");
INSERT INTO nde_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ukubaza amatshe lokuwamisa, ukubaza izigodo njalo enze yonke imisebenzi yomuntu oleminwe lobungcitshi. ");
INSERT INTO nde_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Njalo usenike uBhezaleli kanye lo-Oholiyabhi indodana ka-Ahisamakhi, owesizwe sikaDani ulwazi ekufundiseni abanye. ");
INSERT INTO nde_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","UThixo usebagcwalise ngobuciko bokwenza yonke imihlobo yemisebenzi njengezingcitshi, abadwebi kumbe ababumbi bezinto ezingathungwa kumbe ezingabazwa, abathungi beziceciso zentambo eziluhlaza, eziyibubende lezibomvu kanye lamalembu acolekileyo, labeluki, bonke bezingcitshi ezilolwazi olukhulu lababumbi bezinto ezingathungwa kumbe ezingabazwa. ");
INSERT INTO nde_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Ngakho uBhezaleli, u-Oholiyabhi lomuntu wonke uThixo amuphe ubungcwethi lamandla okwazi ukwenza wonke lumsebenzi wokwakha indlu engcwele, kumele benze umsebenzi njengokulaywa kwabo nguThixo.” ");
INSERT INTO nde_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","UMosi wasebiza uBhezaleli, u-Oholiyabhi labo bonke abalobungcwethi, uThixo ayebaphe amandla lowayezimisele ukuzokwenza lowomsebenzi. ");
INSERT INTO nde_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Bemukela abakuphiwa nguMosi okwakuyiminikelo yabako-Israyeli benikelela ukwakhiwa kwendlu engcwele. Abantu baqhubeka beletha iminikelo ngokukhululeka kwabo ukusa kwamalanga wonke. ");
INSERT INTO nde_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Ngakho zonke izingcitshi ezazisenza umsebenzi wonke wokwakha indlu engcwele zatshiya yonke imisebenzi yazo ");
INSERT INTO nde_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","zathi kuMosi, “Abantu baletha okunengi kakhulu kulalokho uThixo alaya ukuba kwenziwe.” ");
INSERT INTO nde_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Ngakho uMosi wakhupha isiqondiso basebethumela ilizwi ezihonqweni elithi, “Kakho owesilisa loba owesifazane okusamele enze olunye ulutho ukuthi lube ngumnikelo wendlu engcwele.” Ngalokho abantu bavinjelwa ukuletha okunye futhi, ");
INSERT INTO nde_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","ngoba abasebelakho kwasekukunengi okwedlula lokho okwakuzaphetha umsebenzi. ");
INSERT INTO nde_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Wonke amadoda alobungcwethi phakathi kwabasebenzayo akha ithabanikeli ngamakhetheni alitshumi enziwe ngelembu eliphothwe kuhle ngentambo eziluhlaza, eziyibubende kanye lezibomvu, laceciswe ngamakherubhi elukelwa kuhle yingcitshi. ");
INSERT INTO nde_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Wonke amakhetheni ayelingana ubude bawo buzingalo ezingamatshumi amabili lesificaminwembili njalo ububanzi ezingalo ezine. ");
INSERT INTO nde_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Babambanisa amakhetheni amahlanu ndawonye, benza njalo lakwamanye amahlanu. ");
INSERT INTO nde_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Basebesenza izihitshela ngelembu eliluhlaza belandela umphetho wekhetheni elisekucineni kwelixha lakuqala, kwenziwa okufananayo elixheni lesibili. ");
INSERT INTO nde_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Benza njalo ezinye izihitshela ezingamatshumi amahlanu ekhethenini elilodwa, benza futhi ezinye izihitshela ezingamatshumi amahlanu ekhethenini lokucina lelixha lesibili, izihitshela zazikhangelene. ");
INSERT INTO nde_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Basebesenza ingwegwe zegolide ezingamatshumi amahlanu, bazisebenzisa ukuhlanganisa izixha zombili zamakhetheni ukuze ithabanikeli libe yintonye. ");
INSERT INTO nde_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Benza amakhetheni ngoboya bembuzi aba ngawethente lokubekwa phezu kwethabanikeli, wonke abalitshumi lanye. ");
INSERT INTO nde_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Wonke amakhetheni alitshumi lanye ayelingana, ezingalo ezingamatshumi amathathu ubude, ububanzi ezingalo ezine. ");
INSERT INTO nde_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Bahlanganisa amakhetheni amahlanu aba lilixha layisithupha kwelinye ilixha. ");
INSERT INTO nde_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Benza izihitshela ezingamatshumi amahlanu zilandela umphetho wekhetheni elisekucineni kwelixha lakuqala, benza okufananayo ekhethenini lelixha lesibili. ");
INSERT INTO nde_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Balungisa ingwegwe zethusi ezingamatshumi amahlanu ukuze babophe ngazo ithente libe yinto yinye. ");
INSERT INTO nde_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Benza isembeso sethente ngezikhumba zenqama eziphendulwe ngomphendulo obomvu, kwathi ngaphezu kwalokho benza isembeso ngezikhumba eziqinileyo. ");
INSERT INTO nde_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Benza amathala ethabanikeli okumiswa ngezigodo zesihlahla somʼakhakhiya. ");
INSERT INTO nde_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ithala linye lalilide okuzingalo ezilitshumi, kwathi ububanzi laba yingalo elengxenye, ");
INSERT INTO nde_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","kulemisuka emibili ephutsha ilinganisene. Wonke amathala ethabanikeli enziwa ngale indlela. ");
INSERT INTO nde_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Benza amathala ecele elisezansi kwethabanikeli angamatshumi amabili, ");
INSERT INTO nde_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","benza izisekelo zesiliva ezingamatshumi amane ezazihamba ngaphansi kwawo, izisekelo ezimbili ethaleni linye, isisekelo sinye ngaphansi kwensika inye ngayinye. ");
INSERT INTO nde_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Kuleli elinye icele, icele elisenyakatho kwethabanikeli, bamisa amathala angamatshumi amabili ");
INSERT INTO nde_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","kanye lezisekelo zesiliva ezingamatshumi amane, ezimbili ngaphansi kwethala lilinye. ");
INSERT INTO nde_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Benza amathala ayisithupha ecele elisekucineni ngentshonalanga kwethabanikeli, ");
INSERT INTO nde_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","benza amathala amabili emagumbini asekucineni. ");
INSERT INTO nde_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Emagumbini womabili amathala ayelohlonzi oluphindwe kabili kusuka phansi kusiya phezulu, ehlanganiswe ngesongo elilodwa njalo womabili enziwa ngokufananayo. ");
INSERT INTO nde_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Ngakho kwenziwa amathala ayisificaminwembili lezisekelo zesiliva ezilitshumi lesithupha, zimbili ngaphansi kwethala linye. ");
INSERT INTO nde_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Benza njalo imithando enqumayo ngezigodo zesihlahla somʼakhakhiya: emihlanu ingeyamathala akwelinye icele lethabanikeli, ");
INSERT INTO nde_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","emihlanu yayingeyakwelinye icele, kwathi njalo eminye emihlanu yaba ngeyamathala asentshonalanga ekucineni kwethabanikeli. ");
INSERT INTO nde_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Umthando onquma phakathi bawenza wedlula usuka kwelinye icele usiya kwelinye phakathi laphakathi kwamathala. ");
INSERT INTO nde_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Bahuqa amathala ngegolide benza amasongo ngegolide abamba imithando. Njalo bahuqa imithando ngegolide. ");
INSERT INTO nde_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Benza ikhetheni ngelembu elicolekileyo, eliphethwe kuhle ngentambo eziluhlaza, eziyibubende lezibomvu, aba lamakherubhi elukelwe kuwo ngumuntu oleminwe. ");
INSERT INTO nde_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Bawenzela izinsika ezine ngezigodo zesihlahla somʼakhakhiya bazihuqa ngegolide. Izinsika bazenzela ingwegwe zegolide njalo bawamisela lezisekelo ezine zesiliva. ");
INSERT INTO nde_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Benza ikhetheni lesango lethente ngelembu elicolekileyo elilentambo eziphothiweyo eziluhlaza, eziyibubende lezibomvu, kwaba ngumsebenzi wombalazi ngokuthunga; ");
INSERT INTO nde_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","njalo benza izinsika ezinhlanu zilengwegwe zazo. Bahuqa izihloko zensika kanye lamabhanti azo ngegolide njalo benza lezisekelo ezinhlanu ngethusi. ");
INSERT INTO nde_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","UBhezaleli wabaza umtshokotsho ngezigodo zesihlahla somʼakhakhiya ubude bawo kuzingalo ezimbili ezilengxenye, ububanzi kuyingalo elengxenye njalo ukuyaphezulu kwawo kuyingalo elengxenye. ");
INSERT INTO nde_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Walihuqa ngegolide elicolekileyo, ngaphakathi langaphandle, wabuye walizingelezela ngomqolo wegolide. ");
INSERT INTO nde_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Wawubumbela amasongo amane egolide wawanamathisela ezinyaweni zalo zozine, kwathi amasongo amabili kwelinye icele lamabili kwelinye njalo. ");
INSERT INTO nde_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Wasebaza imijabo ngesihlahla somʼakhakhiya wayihuqa ngegolide. ");
INSERT INTO nde_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Wasehloma imijabo leyo emasongweni ayesemaceleni komtshokotsho wesivumelwano ukuze uthwalwe ngayo. ");
INSERT INTO nde_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Wenza isihlalo somusa ngegolide elicolekileyo, ubude baso buzingalo ezimbili ezilengxenye lengxenye, ububanzi saba yingalo elengxenye. ");
INSERT INTO nde_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Njalo wenza amakherubhi amabili ngegolide elikhandiweyo ekucineni kwesihlalo somusa emaceleni womabili. ");
INSERT INTO nde_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Wenza ikherubhi elilodwa nganxanye kwathi kwelinye icele wenza elinye aba yinto yinye lesisibekelo. ");
INSERT INTO nde_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Amakherubhi ayelulele amaphiko awo phezulu, embese isisibekelo ngawo. Amakherubhi ayekhangelene, ubuso bawo bukhangele isisibekelo. ");
INSERT INTO nde_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Babaza itafula ngezigodo zesihlahla somʼakhakhiya, ubude bayo babuzingalo ezimbili, ububanzi buyingalo eyodwa, ukuphakama kwayo kuyingalo elengxenye. ");
INSERT INTO nde_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Basebelihuqa ngegolide elicolekileyo njalo balizingelezela ngomthando wegolide. ");
INSERT INTO nde_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Babuya benza ibhanti eliyizingelezileyo, elalingangesandla somuntu ububanzi, basebefaka umthando wegolide phezu kwebhanti. ");
INSERT INTO nde_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Benza amasongo amane egolide bawafaka emagumbini womane enyaweni zetafula. ");
INSERT INTO nde_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Amasongo afakwa eduze lebhanti ukuze abambe imijabo eyayisetshenziswa ukuthwala itafula. ");
INSERT INTO nde_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Imijabo yokuthwalisa itafula yayenziwe ngezigodo zesihlahla somʼakhakhiya njalo ihuqwe ngegolide. ");
INSERT INTO nde_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Njalo benza ngegolide elicolekileyo izitsha zetafula ezibalisa imiganu, izinditshi, imiganu eyingubhe kanye lezitsha zokuthululela iminikelo enathwayo. ");
INSERT INTO nde_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Benza uluthi lwesibane ngegolide elicolekileyo, bakhanda isidindi salo lomqwayi walo kwaba ngumsebenzi okhandiweyo, imbizana zalo, amahlumela alo kanye lamaluba alo kwenziwa kwaba yinto yinye. ");
INSERT INTO nde_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Ingatsha eziyisithupha zaxhunywa emaceleni oluthi lwesibane, ingatsha ezintathu nganxanye kwathi ezintathu kwelinye icele. ");
INSERT INTO nde_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Inkezo ezintathu ezibunjwe okwamaluba e-alimondi, amahlumela lamaluba kwakusogatsheni lunye, ezinye ezintathu ogatsheni olulandelayo, kwabanjalo kuwo wonke ayisithupha exhunywe oluthini lwesibane. ");
INSERT INTO nde_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Njalo oluthini lwesibane kwakulembizana ezine ezibunjwe okwamaluba e-alimondi elamahlumela kanye lamaluba. ");
INSERT INTO nde_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Ihlumela elilodwa lalingaphansi kwengatsha ezimbili, ihlumela lesibili lingaphansi kwezinye ezimbili lehlumela lesithathu lalingaphansi kwengatsha ezimbili, ingatsha zonke zaziyisithupha. ");
INSERT INTO nde_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Amahlumela lezingatsha kwakuyinto yinye loluthi lwesibane, kukhandwe ngegolide elicolekileyo. ");
INSERT INTO nde_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Balwenzela izibane eziyisikhombisa, incijana lembizana zalo ezenziwe ngegolide elicolekileyo. ");
INSERT INTO nde_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Uluthi lwesibane kanye lakho konke okuphathelene lalo kwenziwa ngegolide elicolekileyo eliyisisindo sethalenta elilodwa. ");
INSERT INTO nde_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Benza i-alithari lempepha ngezigodo zesihlahla somʼakhakhiya. Lenziwa lalingana inxa zonke, ubude balo buyingalo eyodwa, lobubanzi buyingalo eyodwa, kanti ukudepha kuzingalo ezimbili, impondo zalo zenziwa zaba yinto yinye kanye lalo. ");
INSERT INTO nde_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Balihuqa ngegolide elicolekileyo phezulu, lemaceleni kanye lempondo zalo ngegolide elicolekileyo njalo balibumbela umqolo wegolide inxa zonke. ");
INSERT INTO nde_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Benza amasongo amabili kuleli icele lamanye amabili kwelinye njalo ukubambanisa imijabo yokuthwalisa i-alithari lempepha. ");
INSERT INTO nde_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Benza imijabo ngesihlahla somʼakhakhiya bayihuqa ngegolide. ");
INSERT INTO nde_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Benza njalo lamafutha angcwele okugcoba abakhethiweyo, lempepha elephunga elimnandi, kungumsebenzi womenzi wamakha. ");
INSERT INTO nde_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Bakha i-alithari lomnikelo wokutshiswa ngezigodo zesihlahla somʼakhakhiya laba zingalo ezintathu ukudepha, ubude balo laba zingalo ezinhlanu, ububanzi laba zingalo ezinhlanu, lilingana inxa zonke. ");
INSERT INTO nde_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Benza uphondo kumagumbi womane e-alithare, kwathi impondo le-alithari kwaba yinto yinye, basebelihuqa ngethusi. ");
INSERT INTO nde_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Benza zonke izinto ezisetshenziswa kulo ngethusi, imbiza zalo, amafotsholo, imiganu yokuchela, amafologwe enyama kanye lezindengezi zokubasela umlilo. ");
INSERT INTO nde_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Benza iminxibo ye-alithare, bayenza ngethusi yaba ngaphansi kwesengamo se-alithare okuyingxenye yokuya phezulu. ");
INSERT INTO nde_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Benza amasongo ethusi okubambisa imijabo yemagumbini womane yeminxibo yethusi. ");
INSERT INTO nde_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Imijabo bayenza ngezigodo zesihlahla somʼakhakhiya bazihuqa ngethusi. ");
INSERT INTO nde_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Basebehloma imijabo leyo emasongweni yaba semaceleni kwe-alithari ukuze lithwalwe ngayo. Balenza ngamapulanka lafana lomkolo. ");
INSERT INTO nde_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Benza umkolo wethusi lensika yawo yethusi yenziwa ngezibuko zethusi ezazingezabesifazane ababesebenza esangweni lethente lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Ngemva kwalokho balungisa iguma lethabanikeli. Ubude becele lezansi babuzingalo ezilikhulu njalo lilamakhetheni elembu elelukwe kuhle, ");
INSERT INTO nde_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","lilensika ezingamatshumi amabili lezisekelo zethusi ezingamatshumi amabili, njalo lilezingwegwe zesiliva kanye lamabhanti ensikeni. ");
INSERT INTO nde_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Icele lenyakatho lalo lalizingalo ezilikhulu ubude njalo lilensika ezingamatshumi amabili, lezisekelo zethusi ezingamatshumi amabili, kanye lengwegwe zesiliva lamabhanti ensikeni. ");
INSERT INTO nde_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Icele lentshonalanga yeguma lalizingalo ezingamatshumi amahlanu ububanzi, lilamakhetheni, lilensika ezilitshumi, ingwegwe zesiliva kanye lamabhanti ensikeni. ");
INSERT INTO nde_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Eceleni lempumalanga kusiya okuphuma khona ilanga, lakhona iguma lalibanzi okwezingalo ezingamatshumi amahlanu. ");
INSERT INTO nde_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Amakhetheni azingalo ezilitshumi lanhlanu ubude ayenganxanye kwesango, kulezinsika ezintathu kanye lezisekelo ezintathu, ");
INSERT INTO nde_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","ngakwelinye icele lakho kwakulamakhetheni azingalo ezilitshumi lanhlanu ubude, kulezinsika ezintathu kanye lezisekelo ezintathu. ");
INSERT INTO nde_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Wonke amakhetheni ayehonqolozele iguma lethabanikeli ayenziwe ngelembu eliphethwe kuhle. ");
INSERT INTO nde_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Izisekelo zensika zazingezethusi. Ingwegwe kanye lamabhanti ensikeni kwakuyisiliva, njalo izihloko zazo zihuqwe ngesiliva, ngokunjalo zonke izinsika zeguma zazilamabhanti esiliva, njalo izihloko zazo zihuqwe ngesiliva, ngakho zonke izinsika zeguma zazilamabhanti esiliva. ");
INSERT INTO nde_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Ikhetheni lesango leguma lalenziwe ngelembu eliphethwe kuhle ngentambo eluhlaza, eyibubende kanye lebomvu, kwaba ngumsebenzi wombalazi ngokuthunga. Ikhetheni lakhona lalizingalo ezingamatshumi amabili ubude, kanti njengekhetheni leguma ukudepha kwalo kwakuzingalo ezinhlanu, ");
INSERT INTO nde_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","lilensika ezine lezisekelo zethusi ezine. Ingwegwe zalo kanye lamabhanti kuyisiliva, njalo izihloko zalo zihuqwe ngesiliva. ");
INSERT INTO nde_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Izikhonkwane zonke zethente lethabanikeli kanye lezizingelezele iguma zazenziwe ngethusi. ");
INSERT INTO nde_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Lokhu yikho ngobunengi bakho, okwasetshenziswa ukwakha ithabanikeli, ithabanikeli lobufakazi, yikho okwalotshwa ngabaLevi ngokulawula kukaMosi ngaphansi kwesiqondiso sika-Ithamari indodana ka-Aroni, umphristi. ");
INSERT INTO nde_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","(UBhezaleli indodana ka-Uri, indodana kaHuri, owesizwe sakoJuda, wenza konke uMosi ayekulaywe nguThixo, ");
INSERT INTO nde_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","wayelo-Oholiyabhi indodana ka-Ahisamakhi owesizwe sikaDani owayeyingcitshi yomsebenzi njalo engumdwebi, njalo engumbalazi ngokuthunga ngentambo eluhlaza, eyibubende lebomvu, kanye lelembu elicolekileyo.) ");
INSERT INTO nde_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Isilinganiso segolide lonke lomnikelo wokuzunguzwa elasetshenziswa emsebenzini wonke wendawo engcwele lalingamathalenta ayisisindo esingamatshumi amabili lasificamunwemunye (29) kanye lamashekeli angamakhulu ayisikhombisa lamatshumi amathathu (730) kusiya ngamashekeli endawo engcwele. ");
INSERT INTO nde_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Isiliva esavela kulabo abahlala khona ababebaliwe ngesikhathi sokubalwa kwabantu sasilesisindo esingamathalenta alikhulu (100) lamashekeli ayinkulungwane lamakhulu ayisikhombisa alamatshumi ayisikhombisa lanhlanu (1,775), kusiya ngamashekeli endawo engcwele, ");
INSERT INTO nde_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","ibhekha linye ngomuntu, okuyikuthi, ingxenye yeshekeli ngesilinganiso seshekeli endaweni engcwele, kubo bonke labo ababechaphele kwabasebebaliwe, abaleminyaka engamatshumi amabili okuzalwa loba ukwedlula lapho, kwaba ngamadoda azinkulungwane ezingamakhulu ayisithupha lantathu lamakhulu amahlanu lamatshumi amahlanu (603,550) esehlangene wonke. ");
INSERT INTO nde_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Isiliva esiyisisindo samathalenta alikhulu (100) sasetshenziswa ekwenzeni izisekelo zendawo engcwele kanye lekhetheni, izisekelo ezilikhulu (100) zenziwa ngesiliva esingamathalenta alikhulu (100), isilinganiso sethalenta linye ukwenza isisekelo esisodwa. ");
INSERT INTO nde_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Basebenzisa isiliva esilesisindo esingamashekeli ayinkulungwane elamakhulu ayisikhombisa lamatshumi ayisikhombisa lanhlanu (1,775) ukwenza ingwegwe zensika, ukuhuqa izihloko zensika, kanye lokwenza amabhanti ensika. ");
INSERT INTO nde_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Isilinganiso sethusi lonke lomnikelo wokuzunguzwa sasingamathalenta angamatshumi ayisikhombisa (70) lamashekeli azinkulungwane ezimbili ezilamakhulu amane (2,400). ");
INSERT INTO nde_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Balisebenzisa ukwenza izisekelo zesango lethente lokuhlangana, i-alithari lethusi, iminxibo yalo yethusi kanye lazozonke izitsha zalo, ");
INSERT INTO nde_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","izisekelo ezihonqolozele iguma lalezo ezisesangweni kanye lezikhonkwane zethabanikeli lazozonke ezihonqolozele iguma. ");
INSERT INTO nde_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Benza izembatho zokwenza umsebenzi endaweni engcwele ngokuzeluka ngentambo eluhlaza, eyibubende lebomvu. Basebesenza isembatho sika-Aroni esingcwele, njengalokhu uThixo wayelaye uMosi. ");
INSERT INTO nde_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Benza isembatho semahlombe ngegolide, kanye lentambo eluhlaza, eyibubende lebomvu langelembu elicolekileyo. ");
INSERT INTO nde_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Bakhanda izicecedu zegolide bazisika zaba zincingo bazeluka ngentambo eluhlaza, eyibubende lebomvu, kanye lelembu elicolekileyo, kwaba ngumsebenzi womuntu oleminwe. ");
INSERT INTO nde_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Benza iziqa zemahlombe esambathweni leso, ezathungelwa emaceleni womabili ukuze sibotshwe. ");
INSERT INTO nde_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ukhalo lwaso olwelukwa ngobuciko lwalufanana laso, luyinto yinye lesembatho semahlombe, lwenziwe ngentambo eligolide, eluhlaza, eyibubende lebomvu, kanye lelembu eliphothwe kuhle, njengalokhu uThixo walaya uMosi. ");
INSERT INTO nde_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Bathungela amatshe aligugu ohlobo lwe-onikisi ezicecisweni zegolide bawadwebela njengophawu elamabizo amadodana ka-Israyeli. ");
INSERT INTO nde_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Basebewathungela eziqeni zemahlombe esembatho semahlombe njengamatshe esikhumbuzo samadodana ka-Israyeli, njengalokhu uThixo walaya uMosi. ");
INSERT INTO nde_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Benza isembatho sesifubeni, kwaba ngumsebenzi wezingcwethi. Basenza njengesembatho semahlombe: ngegolide, ngentambo eluhlaza, eyibubende lebomvu, kanye lelembu eliphothwe kuhle. ");
INSERT INTO nde_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Sasilingana inxa zonke, singumunwe ubude lomunwe ububanzi, sigoqwe saphindwa kabili. ");
INSERT INTO nde_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Basebethungela imizila emine yamatshe aligugu. Emzileni wakuqala kwakulerubhi, ithophazi kanye lebheriyeli; ");
INSERT INTO nde_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","emzileni wesibili kwakule-emeralidi, isafaya kanye ledayimana; ");
INSERT INTO nde_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","emzileni wesithathu kwakulejasinti, i-agathi kanye le-amethisi; ");
INSERT INTO nde_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","emzileni wesine kwakulekhrisolathi, i-onikisi kanye lejaspa. Athungelwa esezicecisweni zegolide. ");
INSERT INTO nde_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Kwakulamatshe alitshumi lambili, lilinye limele ibizo ngalinye lamadodana ka-Israyeli, linye ngalinye lilotshwe njengokudweba kombazi wamatshe, kungani luphawu, ngalinye lilotshwe ibizo lezizwana zako-Israyeli ezilitshumi lambili. ");
INSERT INTO nde_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Isembatho sesifubeni selukelwa amaketane ngegolide elicolekileyo kungani ligoda. ");
INSERT INTO nde_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Benza iziceciso zegolide ezimbili, kanye lamasongo amabili egolide, basebebophela amasongo amabili emagumbini esembatho sesifubeni. ");
INSERT INTO nde_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Babophela amaketane amabili egolide emasongweni amabili asemagumbini esembatho sesifubeni, ");
INSERT INTO nde_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","kwathi ngapha acina khona bawabophela ezicecisweni ezimbili, bawahlanganisa eziqeni zemahlombe phambi kwesembatho semahlombe. ");
INSERT INTO nde_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Benza amasongo amabili egolide bawabophela kwamanye amagumbi amabili esembatho sesifubeni ngaphakathi komphetho phansi kwesembatho semahlombe. ");
INSERT INTO nde_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Baphinda benza njalo amanye amasongo egolide amabili bawabophela ngaphansi kweziqa zemahlombe, eduze komphetho ngaphezudlwana kwebhanti lasokhalweni lwesembatho semahlombe ");
INSERT INTO nde_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Babophela amasongo esembatho sesifubeni emasongweni esembatho semahlombe ngentambo eziluhlaza, kuhlanganiselwa okhalweni ukuze isembatho sesifubeni singazunguzeki sehlukane lesembatho semahlombe njengalokhu uThixo walaya uMosi. ");
INSERT INTO nde_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Benza isigqoko sesembatho semahlombe ngelembu eliluhlaza kuphela kungumsebenzi womeluki, ");
INSERT INTO nde_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","kulesikhala phakathi laphakathi kwesigqoko njengokuvuleka kwamabheqe; kulomphetho olandeliselwe isikhala lesi ukuze isembatho singadabuki. ");
INSERT INTO nde_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Benza emphethweni wesigqoko amaphomegranathi ngentambo eluhlaza, eyibubende lebomvu, kanye lelembu eliphothwe kuhle. ");
INSERT INTO nde_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Benza amabhera ngegolide elicolekileyo bawathungela emphethweni wesigqoko phakathi laphakathi kwamaphomegranathi. ");
INSERT INTO nde_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Amabhera kanye lamaphomegranathi athungelwa agatshaniswa emphethweni wesembatho esasizagqokwa ekwenzeni umsebenzi wenkonzo, njengalokhu uThixo walaya uMosi. ");
INSERT INTO nde_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","U-Aroni kanye lamadodana akhe bathungelwa amabhatshi ngelembu elicolekileyo, kungumsebenzi womeluki uqobo lwakhe, ");
INSERT INTO nde_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","kanye lamaqhiye elembu elicolekileyo, kanye lezembatho zangaphakathi zelembu elicolekileyo. ");
INSERT INTO nde_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Ibhanti lekhalweni lathungwa ngelembu elicolekileyo kanye lentambo eluhlaza, eyibubende lebomvu, kwaba ngumsebenzi wombalazi ngokuthunga, njengalokhu uThixo walaya uMosi. ");
INSERT INTO nde_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Benza icence lomqhele ongcwele ngegolide elicolekileyo bawudwebela khona njengombhalo wophawu othi: Ubungcwele kabube kuThixo. ");
INSERT INTO nde_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Basebebophela intambo eluhlaza ukuze bakuhlanganise leqhiye, njengalokhu uThixo walaya uMosi. ");
INSERT INTO nde_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Ngakho-ke wonke umsebenzi wethabanikeli lethente lokuhlangana wapheleliswa. Abako-Israyeli benza konke njengalokhu uThixo walaya uMosi. ");
INSERT INTO nde_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Basebeletha ithabanikeli kuMosi: ithente kanye lazozonke impahla zalo, ingwegwe, amathala, imithando, izinsika lezisekelo; ");
INSERT INTO nde_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","isembeso esenziwe ngezikhumba zenqama eziphendulwe ngomphendulo obomvu, isembeso sezikhumba eziqinileyo kanye lekhetheni eliphothiweyo; ");
INSERT INTO nde_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","umtshokotsho wobufakazi lemijabo yawo eyizibambo zawo kanye lesihlalo somusa; ");
INSERT INTO nde_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","itafula lezitsha zalo zonke kanye lesinkwa esiNgcwele; ");
INSERT INTO nde_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","uluthi lwesibane lwegolide elicolekileyo lodwendwe lwezibane lazozonke izinto ezisetshenziswa kulo, kanye lamafutha e-oliva okukhanyisa; ");
INSERT INTO nde_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","i-alithari legolide, amafutha okugcoba abakhethiweyo, impepha elephunga elimnandi, kanye lekhetheni lesango lethente; ");
INSERT INTO nde_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","i-alithari lethusi leminxibo yalo yethusi, izigodo zalo eziyizibambo lezitsha zalo zonke; umkolo lezinyawo zawo; amakhetheni eguma lezinsika zawo kanye lezisekelo, ");
INSERT INTO nde_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","lekhetheni lesango leguma; amagoda lezikhonkwane zethente leguma; zonke impahla zethabanikeli, ithente lokuhlangana; ");
INSERT INTO nde_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","izembatho ezelukiweyo zokusetshenziswa emsebenzini wokukhonza endaweni engcwele, kuhlanganisa izembatho ezingcwele zika-Aroni lezamadodana akhe ababezazigqoka nxa besenza umsebenzi wobuphristi. ");
INSERT INTO nde_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Abako-Israyeli basebenza wonke umsebenzi njengokulaywa kukaMosi nguThixo. ");
INSERT INTO nde_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","UMosi wawuhlola umsebenzi wabona ukuthi wawenziwe njengokulaya kukaThixo. Ngakho uMosi wababusisa. ");
INSERT INTO nde_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","UThixo wasesithi kuMosi: ");
INSERT INTO nde_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Misa ithabanikeli, ithente lokuhlangana, ngosuku lokuqala lwenyanga yakuqala. ");
INSERT INTO nde_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Beka umtshokotsho wesivumelwano kulo ube ususitha umtshokotsho wobufakazi ngekhetheni. ");
INSERT INTO nde_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ngenisa itafula ube usufaka izinto ezibekwa phezu kwayo. Letha-ke uluthi lwesibane ube usuxhuma izibane zalo. ");
INSERT INTO nde_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Beka i-alithari lempepha elenziwe ngegolide phambi komtshokotsho wobufakazi njalo ufake ikhetheni esangweni lethabanikeli. ");
INSERT INTO nde_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Beka i-alithari lomnikelo wokutshiswa phambi kwesango lethabanikeli, ithente lokuhlangana; ");
INSERT INTO nde_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","beka umkolo phakathi laphakathi kwethente lokuhlangana le-alithari ube usuthela amanzi kuwo. ");
INSERT INTO nde_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Lungisa iguma eliwugombolozeleyo ubusufaka ikhetheni esangweni leguma. ");
INSERT INTO nde_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Thatha amafutha okugcoba abantu abakhethiweyo ezikhundleni, ugcobe ngawo ithabanikeli lakho konke okukulo, ulibusise kanye lempahla zalo, ngalokho lizakuba ngcwele. ");
INSERT INTO nde_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Gcoba-ke i-alithari lomnikelo wokutshiswa lazozonke izitsha zalo; ubusise i-alithari ukuze libe ngcwelengcwele. ");
INSERT INTO nde_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Gcoba umkolo lenyawo zawo ubusuwubusisa. ");
INSERT INTO nde_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Letha u-Aroni lamadodana akhe ethenteni lokuhlangana ubusubagezisa ngamanzi. ");
INSERT INTO nde_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ubusugqokisa u-Aroni izembatho ezingcwele umgcobe ngamafutha umbusise ukuze angenzele umsebenzi wobuphristi. ");
INSERT INTO nde_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Letha amadodana akhe uwagqokise amabhatshi. ");
INSERT INTO nde_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Bagcobe labo njengokugcotshwa kukayise ukuze bangenzele umsebenzi wobuphristi. Ukugcotshwa kwabo kubapha umsebenzi wobuphristi kuzozonke izizukulwane ezizayo.” ");
INSERT INTO nde_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","UMosi wenza konke njengokulaywa kwakhe nguThixo. ");
INSERT INTO nde_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Lamiswa-ke ithabanikeli ngosuku lwakuqala ngenyanga yakuqala emnyakeni wesibili. ");
INSERT INTO nde_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Kwathi uMosi emisa ithabanikeli, wafaka izisekelo endaweni yazo, wamisa amathala, wafaka imithando wasemisa izinsika. ");
INSERT INTO nde_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Wasesendlala ithente phezu kwethabanikeli wafaka isembeso phezu kwethente njengokulaywa kwakhe nguThixo. ");
INSERT INTO nde_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Wathatha izibhebhedu zobufakazi wazibeka emtshokotshweni wesivumelwano, wahloma imijabo kuwo wasefaka isihlalo somusa phezu kwawo. ");
INSERT INTO nde_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Wasengenisa umtshokotsho wobufakazi ethabanikeleni, waphanyeka ikhetheni lokusitha wawugubuzela, njengalokho okwakulaywe nguThixo. ");
INSERT INTO nde_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","UMosi wasebeka itafula ethenteni lokuhlangana eceleni langenyakatho lethabanikeli ngaphandle kwekhetheni, ");
INSERT INTO nde_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","wasebeka isinkwa phezu kwalo phambi kukaThixo njengokulaywa kwakhe nguThixo. ");
INSERT INTO nde_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Wabeka uluthi lwesibane ethenteni lokuhlangana lukhangele itafula eningizimu kwethabanikeli, ");
INSERT INTO nde_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","wasemisa izibane phambi kukaThixo, njengokulaywa kwakhe nguThixo. ");
INSERT INTO nde_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","UMosi wabeka i-alithari legolide ethenteni lokuhlangana phambi kwekhetheni, ");
INSERT INTO nde_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","wasetshisela impepha phezu kwalo njengokulaywa kwakhe nguThixo. ");
INSERT INTO nde_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Waselengisa ikhetheni esangweni lethabanikeli. ");
INSERT INTO nde_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Wamisa i-alithari lomnikelo wokutshiswa phansi kwesango lethabanikeli lethente lokuhlangana, wanikela phezu kwalo iminikelo yokutshiswa leminikelo yezilimo njengokulaywa kwakhe nguThixo. ");
INSERT INTO nde_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Wasebeka umkolo phakathi laphakathi kwethente lokuhlangana le-alithari wasethela amanzi okugeza phakathi kwawo, ");
INSERT INTO nde_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","ngakho uMosi lo-Aroni kanye lamadodana akhe bawusebenzisa ukugeza izandla zabo kanye lezinyawo. ");
INSERT INTO nde_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Babegeza ngasosonke isikhathi nxa bengena ethenteni lokuhlangana loba nxa besiya e-alithareni njengokulaywa kukaMosi nguThixo. ");
INSERT INTO nde_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Ngakho uMosi walungisa iguma elihonqolozele ithabanikeli le-alithari waselengisa ikhetheni esangweni leguma kwaba yikho ukuqeda kukaMosi umsebenzi. ");
INSERT INTO nde_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Emva kwalokho iyezi lasibekela ithente lokuhlangana, kwathi inkazimulo kaThixo yagcwala ithabanikeli. ");
INSERT INTO nde_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","UMosi kenelisanga ukungena ethenteni lokuhlangana ngenxa yeyezi elalimi phezu kwalo, inkazimulo kaThixo yagcwala ethabanikeleni. ");
INSERT INTO nde_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Kulolonke uhambo lwabako-Israyeli, kwakusithi iyezi lingaphakama lisuka phezu kwethabanikeli, labo baqhubeke; ");
INSERT INTO nde_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","kodwa kuthi nxa iyezi lingaphakamanga, labo babengaqhubekeli phambili, kuze kube mhla liphakama. ");
INSERT INTO nde_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ngokunjalo iyezi likaThixo lalisiba phezu kwethabanikeli emini, kuthi ebusuku kube lomlilo eyezini, bekubona bonke abako-Israyeli ekuhambeni kwabo konke.");
INSERT INTO nde_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","UThixo wabiza uMosi, wakhuluma laye esethenteni lokuhlangana. Wathi kuye, ");
INSERT INTO nde_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Khuluma labantu bako-Israyeli uthi kubo, ‘Nxa omunye wenu eletha umnikelo kuThixo, kalethe umnikelo wesifuyo esivela emhlambini wenkomo kumbe owezimvu. ");
INSERT INTO nde_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Nxa umnikelo ungowokutshiswa uvela emhlambini wenkomo, kumele anikele ngesifuyo esiduna esingelasici. Kumele asilethe esangweni lethente lokuhlangana ukwenzela ukuthi samukeleke kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Kuzamele abeke isandla sakhe ekhanda lomnikelo wokutshiswa, ngalokho uzakwamukelwa esikhundleni sakhe, uphendle indlela yokubuyisana. ");
INSERT INTO nde_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Kuzamele ahlabe inkunzi encinyane phambi kukaThixo, ngemva kwalokho, amadodana ka-Aroni, abangabaphristi, bazaletha igazi alichele emaceleni wonke e-alithare esangweni lethente lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Kuzamele ahlinze umnikelo wokutshiswa, abesewuhlahlela ube ngamaqatha. ");
INSERT INTO nde_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Kumele amadodana ka-Aroni umphristi abase umlilo e-alithareni, abesebeka inkuni emlilweni. ");
INSERT INTO nde_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Amadodana ka-Aroni abesehlanganisa inhloko lamahwahwa enkunini ezibhebha e-alithareni. ");
INSERT INTO nde_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Kuzamele agezise ezangaphakathi lemilenze ngamanzi, njalo umphristi kumele akutshise konke e-alithareni. Lowo ngumnikelo wokutshiswa, umnikelo owenziwa ngomlilo, olephunga elimnandi kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Nxa umnikelo ungowokutshiswa, uvela emhlambini wezimvu kumbe imbuzi, kuzamele anikele ngesifuyo esiduna esingelasici. ");
INSERT INTO nde_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Kuzamele asihlabele enyakatho ye-alithare phambi kukaThixo, njalo amadodana ka-Aroni angabaphristi azachela igazi laso emaceleni wonke e-alithare. ");
INSERT INTO nde_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Kuzamele isifuyo asihlahlele sibe ngamaqatha, kugoqela inhloko lamahwahwa, njalo umphristi uzawabeka kahle phezu kwenkuni eziyabe zibhebha e-alithareni. ");
INSERT INTO nde_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Kuzamele agezise ezangaphakathi lemilenze ngamanzi, njalo umphristi uzaletha inyama yonke, abeseyitshisela e-alithareni. Lowo ngumnikelo wokutshiswa, umnikelo owenziwa ngomlilo, olephunga elimnandi kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Nxa umnikelo kaThixo ungumnikelo wokutshiswa, ungowenyoni, kumele anikele ngejuba kumbe iphuphu lenkwilimba. ");
INSERT INTO nde_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Umphristi uzakuletha e-alithareni, akutshile intamo, abesekutshisela e-alithareni, igazi lakho livuzele eceleni. ");
INSERT INTO nde_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Kuzamele akhuphe isidlelo lalokho okuphakathi kwaso, asilahlele empumalanga ye-alithare, lapho okulomlotha khona. ");
INSERT INTO nde_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Kayidabule ivuleke ngempiko zayo kodwa angayehlukanisi, emva kwalokho, umphristi uzayitshisela enkunini ezisemlilweni ose-alithareni. Ngumnikelo wokutshiswa, umnikelo owenziwa ngomlilo, olephunga elimnandi kuThixo.’ ” ");
INSERT INTO nde_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘Nxa umuntu angaletha umnikelo wamabele kuThixo; umnikelo wakhe uzakuba ngowefulawa ecolekileyo. Uzayithela amafutha ayihlanganise lempepha ");
INSERT INTO nde_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","abeseyisa emadodaneni ka-Aroni, abaphristi. Umphristi uzacupha ifulawa ecolekileyo egcwala isandla, ayihlanganise lamafutha lempepha ndawonye, abesekutshisa njengesikhumbuzo e-alithareni, umnikelo owenziwa ngomlilo, olephunga elimnandi kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Okuseleyo emnikelweni wamabele ngokuka-Aroni lamadodana akhe, yingxenye engcwele kakhulu yomhlatshelo wokudla onikelwa kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Nxa ungaletha umnikelo wamabele obhekhwe eziko, kumele wenziwe ngefulawa ecolekileyo: amakhekhe abhekhwe kungela mvubelo, ahlanganiswa lamafutha, kumbe amakhekhe ayizicecedu enziwe kungela mvubelo, asegcotshwa ngamafutha. ");
INSERT INTO nde_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Nxa umnikelo wakho wamabele uhlanganiselwe emganwini wensimbi, kumele ulungiswe ngefulawa ecolekileyo, ehlanganiswe lamafutha njalo ingela mvubelo. ");
INSERT INTO nde_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Uvuthuze ubusuthela amafutha kuwo; ngumnikelo wamabele. ");
INSERT INTO nde_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Nxa umnikelo wakho wamabele ubhekhelwe epaneni, kuzamele wenziwe ngefulawa ecolekileyo lamafutha. ");
INSERT INTO nde_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Letha umnikelo wamabele olungiswe ngezinto lezi kuThixo: uziqhubele umphristi ozazisa e-alithareni. ");
INSERT INTO nde_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Uzakhupha ingxenye eyisikhumbuzo emnikelweni wamabele, abeseyitshisela e-alithareni njengomhlatshelo wokudla, olephunga elimnandi kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Okuseleyo emnikelweni wamabele ngokuka-Aroni lamadodana akhe, yingxenye engcwele kakhulu yomhlatshelo wokudla onikelwa kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Wonke umnikelo wamabele owuletha kuThixo kumele ulungiswe ungelamvubelo, ngoba kakumelanga utshise imvubelo kumbe uluju emhlatshelweni wokudla onikelwa kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Ungakuletha kuThixo njengomnikelo wokuchinsa izithelo zakuqala, kodwa kakumelanga ukuthi zinikelwe e-alithareni njengephunga elimnandi. ");
INSERT INTO nde_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Tswayani yonke iminikelo yenu yamabele. Lingakhohlwa itswayi lesivumelwano sikaNkulunkulu wenu eminikelweni yenu yamabele: fakani itswayi eminikelweni yenu yonke. ");
INSERT INTO nde_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Nxa lingaletha umnikelo wamabele ezithelo zakuqala kuThixo, nikelani ngezikhwebu zamabele amatsha agigwe ekhanzingwe emlilweni. ");
INSERT INTO nde_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Thelani amafutha lihlanganise lempepha: ngumnikelo wamabele. ");
INSERT INTO nde_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Umphristi uzatshisa ingxenye eyisikhumbuzo emabeleni agigiweyo, kanye lamafutha ndawonye lempepha yonke njengomhlatshelo wokudla owenzelwa onikelwa kuThixo.’ ” ");
INSERT INTO nde_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘Nxa umnikelo womuntu ungumnikelo wobudlelwano, enikela ngesifuyo esiduna kumbe esisikazi, esisuka emhlambini, kumele alethe kuThixo isifuyo esingalasici. ");
INSERT INTO nde_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Kumele abeke isandla sakhe ekhanda lesifuyo somnikelo, abesesihlabela esangweni lethente lokuhlangana. Ngemva kwalokho, amadodana ka-Aroni angabaphristi, azachela igazi emaceleni wonke e-alithare. ");
INSERT INTO nde_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Emnikelweni wobudlelwano uzaletha umhlatshelo onikelwa kuThixo ngomlilo: idanga lonke elembese ezangaphakathi, ");
INSERT INTO nde_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","izinso zombili lamahwahwa azo aseduzane lesinqe, lamahwahwa aphezu kwesibindi, okufanele kukhutshwe lezinso. ");
INSERT INTO nde_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Ngakho amadodana ka-Aroni azakutshisela e-alithareni, phezu komnikelo wokutshiswa ophezu kwenkuni ezibhebhayo njengomnikelo owenziwa ngomlilo, uqhatshi olumnandi kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Nxa anganikela ngesifuyo esisuka emhlambini wezimvu njengomnikelo wobudlelwano kuThixo, kuzamele anikele ngesiduna kumbe esisikazi esingelasici. ");
INSERT INTO nde_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Nxa anganikela ngezinyane, kumele alilethe phambi kukaThixo. ");
INSERT INTO nde_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Kumele abeke isandla sakhe phezu kwekhanda lomnikelo wakhe, asihlabe lesosifuyo phambi kwesango lethente lokuhlangana. Amadodana ka-Aroni azachela igazi laso emaceleni wonke e-alithare. ");
INSERT INTO nde_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Emnikelweni wobudlelwano kuzamele alethe umhlatshelo owenziwa kuThixo ngomlilo; amahwahwa awo, lomsila ononileyo aqunywe eduzane lomgogodla, idanga lonke, lawo wonke amahwahwa embese ezangaphakathi, ");
INSERT INTO nde_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","izinso zombili lamahwahwa aseduzane lesinqe lamahwahwa aphezu kwesibindi, okuzakhutshwa ndawonye lezinso. ");
INSERT INTO nde_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Umphristi uzakutshisela e-alithareni njengomhlatshelo wokudla, onikelwa kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Nxa umnikelo wakhe kuyimbuzi, uzayethula phambi kukaThixo. ");
INSERT INTO nde_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Uzabeka isandla sakhe ekhanda layo, abeseyihlabela phambi kwesango lethente lokuhlangana. Amadodana ka-Aroni azachela igazi layo emaceleni wonke e-alithare. ");
INSERT INTO nde_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Kulokho akunikelayo, kuzamele anikele umhlatshelo wokudla kuThixo, idanga lonke lawo wonke amahwahwa embese ezangaphakathi, ");
INSERT INTO nde_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","izinso zombili, lamahwahwa aseduzane lesinqe, lamahwahwa aphezu kwesibindi okuzakhutshwa ndawonye lezinso. ");
INSERT INTO nde_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Umphristi uzakutshisela e-alithareni njengomhlatshelo wokudla, iphunga elimnandi. Wonke amahwahwa ngakaThixo. ");
INSERT INTO nde_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Lokhu kuzakuba yisimiso esingapheliyo ezizukulwaneni zenu zonke, kuzozonke izindawo elihlala kuzo. Akumelanga lidle yiloba ngumhlobo bani wamahwahwa kumbe igazi.’ ” ");
INSERT INTO nde_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Tshela abantu bako-Israyeli ukuthi: ‘Nxa umuntu esona kodwa engoni ngabomo, njalo esenza konke okwalelwa yimilayo kaThixo, ");
INSERT INTO nde_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Nxa umphristi ogcotshiweyo angona, besekuletha icala ebantwini, kumele alethe kuThixo ijongosi elingelasici njengomnikelo wesono ngenxa yesono ayabe esenzile. ");
INSERT INTO nde_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Kalethe inkunzi esangweni lethente lokuhlangana, phambi kukaThixo. Uzabeka isandla sakhe ekhanda layo, abeseyihlaba phambi kukaThixo. ");
INSERT INTO nde_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Umphristi ogcotshiweyo uzathatha elinye igazi lenkunzi alise ethenteni lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Kagxamuze umunwe wakhe egazini, abesechela elinye lakhona kasikhombisa phambi kukaThixo, phambi kwekhetheni lendlu engcwele. ");
INSERT INTO nde_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Umphristi uzafaka elinye igazi empondweni ze-alithare lempepha elephunga elimnandi eliphambi kukaThixo ethenteni lokuhlangana. Igazi lenkunzi eliseleyo uzalithela phansi kwe-alithari lomnikelo wokutshiswa, esangweni lethente lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Kumele akhuphe wonke amahwahwa enkunzi yomnikelo wesono, idanga lonke lawo wonke amahwahwa embese ezangaphakathi. ");
INSERT INTO nde_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","Izinso zombili, lamahwahwa azo aseduzane lesinqe, lamahwahwa aphezu kwesibindi kuzakhutshwa ndawonye lezinso, ");
INSERT INTO nde_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","njengalokho okwenziwa nxa ihwahwa likhutshwa enkabini eyabe ingumnikelo wobudlelwano. Umphristi uzakutshisela e-alithareni lomnikelo wokutshiswa. ");
INSERT INTO nde_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Kodwa isikhumba senkunzi kanye lenyama yayo yonke, inhloko, amangqina, ezangaphakathi lamathumbu, ");
INSERT INTO nde_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","okutsho ingxenye yonke yenkunzi, kumele akukhuphele phandle kwezihonqo endaweni ehlanzekileyo ngokomkhuba, lapho okuchithelwa khona umlotha, abesekutshisela emlilweni wenkuni oyabe usenqumbini yomlotha. ");
INSERT INTO nde_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Nxa uzulu wonke wako-Israyeli angona, engoni ngabomo, abesesenza konke okwalelwa yimilayo kaThixo, lanxa uzulu lowo engazilutho ngodaba lolu, ulecala. ");
INSERT INTO nde_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Nxa bangavele bazi ngesono abasenzileyo, ibandla kumele lilethe inkunzi eliguqa njengomnikelo wesono, liyethule phambi kwethente lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Abadala bakuleyondawo bazabeka izandla zabo ekhanda lenkunzi phambi kukaThixo, njalo inkunzi izahlatshelwa phambi kukaThixo. ");
INSERT INTO nde_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Umphristi ogcotshiweyo uzathatha elinye igazi lenkunzi angene lalo ethenteni lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Uzacwilisa umunwe wakhe egazini, abeselichela phambi kukaThixo kasikhombisa phambi kwekhetheni. ");
INSERT INTO nde_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Kaninde elinye igazi empondweni ze-alithare eliphambi kukaThixo ethenteni lokuhlangana. Igazi eliseleyo uzalithela phansi kwe-alithari lomnikelo wokutshiswa, esangweni lethente lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Kakhuphe wonke amahwahwa abesewatshisela e-alithareni, ");
INSERT INTO nde_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","abesesenza enkunzini le lokho akwenza enkunzini yomnikelo wesono. Ngalokho umphristi uzabenzela indlela yokubuyisana phakathi kwabo, njalo bazathethelelwa. ");
INSERT INTO nde_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Kakhuphele inkunzi phandle kwezihonqo, abeseyitshisa njengalokho akwenza inkunzi yakuqala. Lo ngumnikelo wesono okazulu wonke. ");
INSERT INTO nde_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Nxa umkhokheli angona engakunxwanelanga enze okwaliwa yimilayo kaThixo uNkulunkulu, ulecala. ");
INSERT INTO nde_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Nxa angatshelwa ngesono asenzileyo kumele alethe umnikelo wempongo engelasici. ");
INSERT INTO nde_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Kabeke isandla sakhe ekhanda lembuzi abeseyihlabela lapho okuhlatshelwa khona umnikelo wokutshiswa phambi kukaThixo. Kungumnikelo wesono. ");
INSERT INTO nde_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Umphristi uzathatha elinye igazi lomnikelo wesono abeselininda empondweni ze-alithari lomnikelo wokutshiswa abesethela elinye lonke igazi phansi kwe-alithari. ");
INSERT INTO nde_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Uzatshisela wonke amahwahwa e-alithareni njengalokhu akwenza amahwahwa omnikelo wobudlelwano. Ngale indlela umphristi uzakwenza indlela yokubuyisana ngesono somuntu abesethethelelwa. ");
INSERT INTO nde_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Nxa omunye umuntu phakathi kwendawo angona engakunxwanelanga ukona, enze okwaliwa yimilayo kaThixo, uyabe elecala. ");
INSERT INTO nde_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Nxa angatshelwa ngesono ayabe esenzile, kumele alethe umnikelo wesono sakhe, umnikelo wembuzi ensikazi engelasici. ");
INSERT INTO nde_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Kabeke isandla sakhe ekhanda lomnikelo wesono, abesewuhlabela endaweni yomnikelo wokutshiswa. ");
INSERT INTO nde_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Umphristi kumele athathe elinye igazi ngomunwe wakhe, abeselininda empondweni ze-alithare lomnikelo wokutshiswa, abesethela elinye eliseleyo phansi kwe-alithari. ");
INSERT INTO nde_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Uzakhupha amahwahwa wonke njengalokhu okwenziwa emnikelweni wobudlelwano, njalo umphristi uzawutshisela e-alithareni njengoqhatshi olulephunga elimnandi kuThixo. Ngaleyondlela, umphristi uzamenzela indlela yokubuyisana, abesethethelelwa. ");
INSERT INTO nde_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Nxa angaletha imvu njengomnikelo wesono, kumele alethe ensikazi engelasici. ");
INSERT INTO nde_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Kumele abeke isandla sakhe ekhanda layo, abeseyihlaba njengomnikelo wesono endaweni lapho okuhlatshelwa khona umnikelo wokutshiswa. ");
INSERT INTO nde_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Emva kwalokho, umphristi uzathatha elinye igazi lomnikelo wesono ngomunwe, alininde empondweni ze-alithare lomnikelo wokutshiswa, abesethela elinye igazi eliseleyo ngaphansi kwe-alithari. ");
INSERT INTO nde_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Bazakhupha wonke amahwahwa, njengalokhu okwenziwa emvini yomnikelo wobudlelwano, njalo umphristi uzayitshisela e-alithareni phezu kwemihlatshelo yokudla enikelwa kuThixo. Ngalokho umphristi uzamenzela indlela yokubuyisana ngesono asenzileyo abesethethelelwa.’ ” ");
INSERT INTO nde_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘Nxa umuntu angona ngenxa yokuthi kakhulumanga ebika udaba oluthile emphakathini ngayabe ekubonile kumbe ekuzwile, uyabe elomlandu. ");
INSERT INTO nde_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Loba nxa umuntu angathinta ulutho olungabe lungcolile ngokomkhuba (kungaba yizidumbu zezinyamazana zeganga ezingcolileyo kumbe ezezifuyo ezingcolileyo kumbe ezezidalwa ezingcolileyo ezihamba emhlabathini) lanxa engananzelele ngalokho, uyabe esengcolile njalo eselecala. ");
INSERT INTO nde_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Loba engathinta ukungcola komuntu (konke okungenza ukuthi abe ngongcolileyo) lanxa engananzelele ngalokho nxa angavele akwazi uyabe eselecala, ");
INSERT INTO nde_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","kumbe umuntu angafunga enganakananga kuhle ukuthi ufuna ukwenza olunye ulutho, ingabe ngoluhle kumbe ngolubi (entweni yonke umuntu angafunga ngayo butshapha) lanxa engananzelele ngalokho, angavele akwazi uzakuba lecala, ");
INSERT INTO nde_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","nxa umuntu angazi ukuthi ulecala ngezinto lezi, kumele aveze ukuthi wone ngandlela bani. ");
INSERT INTO nde_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Njengenhlawulo yesono ayabe esenzile, kumele alethe kuThixo imvana ensikazi kumbe imbuzi evela emhlambini njengomnikelo wesono, njalo umphristi uzamenzela indlela yokubuyisana ngenxa yesono sakhe. ");
INSERT INTO nde_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Nxa engenelisi ukuthola imvana uzaletha amajuba amabili kumbe amaphuphu enkwilimba amabili kuThixo njengenhlawulo yesono sakhe, okunye kungumnikelo wesono, okunye kungumnikelo wokutshiswa. ");
INSERT INTO nde_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Uzakuletha kumphristi, ozaqala ngokunikela okomnikelo wesono. Kumele akutshile intamo yakho kodwa angatshuphuni ikhanda, ");
INSERT INTO nde_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","njalo uzachela elinye igazi lomnikelo wesono eceleni kwe-alithari; igazi eliseleyo kumele likhanyelwe phansi kwe-alithari. Ngumnikelo wesono. ");
INSERT INTO nde_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Umphristi usezanikela okunye njengomnikelo wokutshiswa ngendlela eyamiswayo, umphristi aphinde amenzele indlela yokubuyisana ngesono sakhe, abesethethelelwa. ");
INSERT INTO nde_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Kodwa nxa esehluleka ukuthola amajuba amabili kumbe amaphuphu enkwilimba amabili, kalethe umnikelo wesono sakhe, alethe ingxenye yetshumi yehefa yefulawa ecolekileyo ukwenzela umnikelo wesono. Akumelanga athele amafutha kumbe afake impepha ngoba kungumnikelo wesono. ");
INSERT INTO nde_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Kakulethe phambi komphristi ozacupha isilinganiso esigcwala isandla njengengxenye yesikhumbuzo, abeseyitshisela e-alithareni phezu kwemihlatshelo yokudla enikelwa kuThixo. Kungumnikelo wesono. ");
INSERT INTO nde_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Ngalokhu umphristi uzamenzela indlela yokubuyisana ngesono ingabe yisiphi ayabe esenzile, uzathethelelwa, okuseleyo kuzakuba ngokomphristi, njengalokho okwenziwa emnikelweni wamabele.’ ” ");
INSERT INTO nde_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","UThixo wathi kuMosi: ");
INSERT INTO nde_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Nxa umuntu angephula umthetho abesesona, engoni ngabomo ezintweni zonke zikaThixo ezingcwele, kalethe kuThixo njengenhlawulo inqama esuka emhlambini, engelasici njalo ebiza isiliva esamukelekayo ngesilinganiso seshekeli lasendlini engcwele. Ngumnikelo wecala. ");
INSERT INTO nde_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Kumele ahlawule ngesiphambeko sakhe kulokho ayabe ehluleke ukukwenza, okuphathelane lezinto ezingcwele, abesesengezelela ingxenye yokuhlanu yentengo yakho akunike umphristi konke, ozamenzela indlela yokubuyisana ngenqama njengomnikelo wecala, abesethethelelwa. ");
INSERT INTO nde_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Nxa umuntu angona ngokwenza lokho okungavunyelwayo emlayweni kaThixo, lanxa engakwazi, uyabe elecala njalo uzakwetheswa umlandu. ");
INSERT INTO nde_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Uzaletha kumphristi njengomnikelo wecala inqama engelasici ezavela emhlambini, njalo elesilinganiso esamukelekayo. Ngalokhu umphristi uzamenzela indlela yokubuyisana ngesiphambeko sakhe angasenzanga ngabomo, njalo uzathethelelwa. ");
INSERT INTO nde_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Kungumnikelo wecala: ulecala lokona phambi kukaThixo.” ");
INSERT INTO nde_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","UThixo wathi kuMosi: ");
INSERT INTO nde_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Nxa umuntu esona njalo engathembeki kuThixo ngokukhohlisa umakhelwane wakhe ngalokho ayabe ekuphathisiwe loba ayabe ekugcinisiwe loba okuyabe kuntshontshiwe, loba nxa edlelezela omunye, ");
INSERT INTO nde_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","loba nxa ethola obekulahlekile kodwa aqambe amanga ngakho, loba nxa efunga ngokungamanga, loba nxa esenza loba yisiphi isono esingenziwa ngabantu, ");
INSERT INTO nde_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","nxa esona kanjalo abe ngolecala, kumele abuyisele lokho ayabe ekuntshontshile loba ayabe ekuthethe ngodlakela, loba ayabe abe ekuphathisiwe, loba obekulahlekile wasekuthola, ");
INSERT INTO nde_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","loba yingabe yini ayabe efunge ngayo ngokwamanga kumele ahlawule ngokugcweleyo, engeze ngokukodwa kokuhlanu kukho njalo akuphe umnikazi konke mhla evuma icala lakhe. ");
INSERT INTO nde_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Ukuhlawula icala kumele alethe kumphristi ozakusa kuThixo, umnikelo wakhe wecala, inqama esuka emhlambini, ingelasici njalo elingeneyo ngemfanelo. ");
INSERT INTO nde_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Ngalokho umphristi uzamenzela indlela yokubuyisana phambi kukaThixo, njalo uzathethelelwa ngalezi izinto azenzileyo ezimenze waba lecala.” ");
INSERT INTO nde_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","UThixo wathi kuMosi: ");
INSERT INTO nde_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Phana u-Aroni kanye lamadodana akhe umlayo lo: ‘Le yimithetho yomnikelo wokutshiswa: Umnikelo wokutshiswa kufanele usale eziko le-alithari ubusuku bonke kuze kuse, lomlilo kufanele uhlale ubhebha e-alithareni. ");
INSERT INTO nde_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Umphristi uzagqoka-ke izigqoko zakhe zelembu, lezangaphansi kube ngezelembu, abesekhupha umlotha womnikelo wokutshiswa oyabe usutshiswe ngumlilo e-alithareni, awufake eceleni kwe-alithari. ");
INSERT INTO nde_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Abesekhulula izigqoko lezi agqoke ezinye, athwale umlotha awukhuphele phandle kwezihonqo endaweni ehlanzekileyo ngokomkhuba. ");
INSERT INTO nde_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Umlilo ose-alithareni kufanele uhlale ubhebha; akumelanga ucitshe. Insuku zonke ekuseni umphristi kumele engeze inkuni akhwezele, alungise kuhle umnikelo wokutshiswa emlilweni e-alithareni, atshise amahwahwa omnikelo wobudlelwano kulo i-alithari. ");
INSERT INTO nde_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Umlilo kumele uhlale ubhebha e-alithareni; akumelanga ucitshe.’ ” ");
INSERT INTO nde_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘Le yimithetho ephathelene lomnikelo wamabele okufanele amadodana ka-Aroni awulethe kuThixo, phambi kwe-alithari. ");
INSERT INTO nde_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Umphristi kufanele acuphe ifulawa elicolekileyo kanye lamafutha, lempepha yonke yomnikelo wamabele, besekutshiswa ingxenye yesikhumbuzo e-alithareni, ibe liphunga elimnandi kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","U-Aroni kanye lamadodana akhe bazakudla okuseleyo, kodwa kumele kudliwe kungela mvubelo endaweni engcwele; bakudlele egumeni lethente lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Akumelanga kubhekhwe kulemvubelo. Ngibanika khona njengesabelo sabo seminikelo eyenziwa kimi ngomlilo. Kungcwele njengomnikelo wesono lomnikelo wecala. ");
INSERT INTO nde_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Bonke abesilisa enzalweni ka-Aroni bangakudla. Kuzoba yisabelo sabo kokuphela esivela eminikelweni eyenziwe ngomlilo kuThixo ezizukulwaneni ezizayo. Okubathintayo kuphela kuzakuba ngcwele.’ ” ");
INSERT INTO nde_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","UThixo wakhuluma njalo kuMosi wathi, ");
INSERT INTO nde_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Lo ngumnikelo ozanikelwa kuThixo ngu-Aroni kanye lamadodana akhe ngelanga azagcotshwa ngalo. Kuzakuba ngokwetshumi kwehefa yefulawa ecolekileyo, kube ngumnikelo wamabele owansuku zonke, ingxenye yawo ibe sekuseni kuthi enye ingxenye ibe kusihlwa. ");
INSERT INTO nde_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Kulungise ngamafutha emganwini wensimbi oyingubhe; kulethe kuhlanganiswe kuhle, ubususethula umnikelo wamabele wenziwe incezwana ube liphunga elimnandi kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Indodana egcotshelwe ukuthatha isikhundla sika-Aroni njengomphristi yiyo ezalungisa lokho. Kuyisabelo sikaThixo sansukuzonke, njalo kufanele kutshiswe ngokupheleleyo. ");
INSERT INTO nde_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Yonke iminikelo yamabele yomphristi izatshiswa iphele; akumelanga idliwe.” ");
INSERT INTO nde_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Tshono lokhu ku-Aroni lamadodana akhe: ‘Le yimithetho yomnikelo wesono: Umnikelo wesono kufanele uhlatshwe phambi kukaThixo endaweni lapho umnikelo wokutshiswa ohlatshelwa khona. Ungcwele kakhulu. ");
INSERT INTO nde_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Umphristi owunikelayo uzawudla; kumele udlelwe endaweni engcwele egumeni lethente lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Konke okuthinta inyama leyo kuyakuba ngcwele. ");
INSERT INTO nde_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Imbiza yebumba okuphekwe ngayo inyama kumele ibulawe; kodwa nxa iphekwe ngembiza yethusi, imbiza kufanele iphalwe ihlanjululwe ngamanzi. ");
INSERT INTO nde_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Wonke owesilisa emulini yomphristi uzawudla, ungcwele kakhulu. ");
INSERT INTO nde_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Kodwa loba yiwuphi umnikelo wesono okulethwa igazi lawo ethenteni lokuhlangana ukwenza ukubuyisana eNdaweni eNgcwele kawungadliwa kumele utshiswe.’ ” ");
INSERT INTO nde_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘Le yimithetho ephathelene lomnikelo wecala, oyiwo ongcwele kakhulu. ");
INSERT INTO nde_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Umnikelo wecala kufanele uhlatshelwe endaweni lapho umnikelo wokutshiswa ohlatshelwa khona, njalo igazi lawo kufanele lichelwe emaceleni wonke e-alithare. ");
INSERT INTO nde_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Wonke amahwahwa awo azanikelwa: umsila ononileyo kanye ledanga elembesa ezangaphakathi, ");
INSERT INTO nde_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","izinso zombili lamahwahwa azo aseduzane lesinqe, lamahwahwa aphezu kwesibindi, okufanele kukhutshwe lezinso. ");
INSERT INTO nde_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Umphristi uzakukutshisela e-alithareni njengomhlatshelo wokudla onikelwa kuThixo. Kungumnikelo wecala. ");
INSERT INTO nde_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Wonke owesilisa emulini yomphristi angakudla, kodwa kufanele kudlelwe endaweni engcwele; ngoba kungcwele kakhulu. ");
INSERT INTO nde_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Umthetho munye uyasetshenziswa emnikelweni wesono kanye lemnikelweni wecala. Ungowomphristi owenza kube lendlela yokubuyisana labo. ");
INSERT INTO nde_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Umphristi onikela umnikelo wokutshiswa kabani lobani angazigcinela isigogo. ");
INSERT INTO nde_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Wonke umnikelo wamabele ophekelwa eziko, loba ophekelwa embizeni, loba embizeni yensimbi ungowomphristi owunikelayo, ");
INSERT INTO nde_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","njalo wonke umnikelo wamabele oyabe uhlanganiswe lamafutha loba womile, wonke ungowamadodana ka-Aroni ngokulinganayo.’ ” ");
INSERT INTO nde_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘Le yimithetho ephathelene lomnikelo wobudlelwano umuntu angawunikela kuThixo: ");
INSERT INTO nde_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Nxa unganikelwa njengendlela yokubonga, kumele lumnikelo wokubonga unikelwe ndawonye lesinkwa esenziwe singelamvubelo sahlanganise lamafutha, amakhekhe ayizicecedu enziwe engelamvubelo njalo egcotshwe ngamafutha, kanye lamakhekhe efulawa ecolekileyo avutshwe kuhle ahlanganiswa lamafutha. ");
INSERT INTO nde_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Umnikelo wakhe wobudlelwano ongowokubonga kumele unikelwe ndawonye lomnikelo wezinkwa ezenziwe ngemvubelo. ");
INSERT INTO nde_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Kufanele alethe okukodwa komhlobo munye ngamunye njengomnikelo onikelwa kuThixo. Ungowomphristi ochela igazi lomnikelo wobudlelwano. ");
INSERT INTO nde_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Inyama yomnikelo wakhe wobudlelwano ingeyokubonga, kumele idliwe ngalelolanga inikelwa. Akumelanga eyinye isalele elakusasa. ");
INSERT INTO nde_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Kodwa nxa umnikelo wakhe ungenxa yokugcwalisa isifungo loba ungumnikelo wesihle, umhlatshelo lowo uzadliwa ngalelolanga lokuwunikela, kodwa okuyabe kusele kungadliwa ngelanga elilandelayo. ");
INSERT INTO nde_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Yonke inyama yomhlatshelo esalayo kuze kwedlule insuku ezintathu kufanele itshiswe. ");
INSERT INTO nde_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Nxa kulenyama yomnikelo wobudlelwano engadliwa ngelanga lesithathu, lowo oyinikeleyo kasoze amukeleke. Ayisoze ibalelwe kulowo oyinikeleyo, ngoba ingahlambulukanga. Umuntu odla enye yayo uzakuba lomlandu ngayo. ");
INSERT INTO nde_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Inyama ethinta loba yini engcolileyo ngokomkhuba akumelanga idliwe; kumele itshiswe. Kodwa eyinye inyama ingadliwa yiloba ngubani ohlambulukileyo ngokomkhuba. ");
INSERT INTO nde_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Kodwa nxa kulomuntu ongcolileyo angadla inyama yomnikelo wobudlelwano engekaThixo, lowomuntu kumele axotshwe ebantwini bakibo. ");
INSERT INTO nde_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Nxa kulomuntu othinta okuthile okungcolileyo, akukhathalekile kumbe kuyikungcola komuntu loba okwenyamazana loba okunye nje okungcolileyo, okwenyanyekayo, abesesidla inyama yomnikelo wobudlelwano engekaThixo, lowomuntu kumele axotshwe ebantwini bakibo.’ ” ");
INSERT INTO nde_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Tshela abako-Israyeli uthi: ‘Lingaze ladla amahwahwa enkomo, awezimvu loba awembuzi. ");
INSERT INTO nde_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Amahwahwa enyamazana ezifeleyo loba edatshulwe yizilo zeganga angasetshenziswa kokunye, kodwa akumelanga liwadle. ");
INSERT INTO nde_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Umuntu odla amahwahwa enyamazana okungenziwa ngayo umnikelo wokutshiswa kuThixo kumele axotshwe ebantwini bakibo. ");
INSERT INTO nde_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Njalo lingadli igazi lenyoni loba inyamazana yiphi kuzozonke izindawo elihlala kuzo. ");
INSERT INTO nde_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Nxa umuntu esidla igazi, lowomuntu kumele axotshwe ebantwini bakibo.’ ” ");
INSERT INTO nde_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Tshela abako-Israyeli uthi: ‘Umuntu oletha umnikelo wobudlelwano kuThixo kumele alethe ingxenye yawo njengomhlatshelo wakhe kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Kumele anikele ngezandla zakhe umhlatshelo wokudla kuThixo. Kumele alethe amahwahwa, ndawonye lesifuba, abesezunguza isifuba phambi kukaThixo njengomnikelo wokuzunguza. ");
INSERT INTO nde_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Umphristi uzatshisa amahwahwa e-alithareni, kodwa isifuba ngesika-Aroni kanye lamadodana akhe. ");
INSERT INTO nde_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Kumele uphe umphristi umlenze wesokunene eminikelweni yakho yobudlelwano ube ngumnikelo wakho. ");
INSERT INTO nde_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Indodana ka-Aroni enikela igazi lamahwahwa omnikelo wobudlelwano izathola umlenze wesokunene njengesabelo sayo. ");
INSERT INTO nde_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Ngithethe isifuba esizunguzwayo kanye lomlenze onikelwayo emnikelweni wobudlelwano wabako-Israyeli ngapha u-Aroni umphristi kanye lamadodana akhe njengesabelo sabo sezikhathi zonke esivela kwabako-Israyeli.’ ” ");
INSERT INTO nde_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Le yingxenye yemihlatshelo yokudla enikelwa kuThixo eyabelwa u-Aroni kanye lamadodana akhe ngelanga abethulwa ngalo ukuba basebenzele uThixo njengabaphristi. ");
INSERT INTO nde_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Ngelanga abagcotshwa ngalo, uThixo walaya abako-Israyeli ukuthi banikele lokho njengasabelo sabo sezikhathi zonke kuzizukulwane ezizayo. ");
INSERT INTO nde_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Le-ke yiyo imithetho emayelana lomnikelo wokutshiswa, umnikelo wamabele, umnikelo wesono, umnikelo wecala, umnikelo wokugcotshwa lomnikelo wobudlelwano, ");
INSERT INTO nde_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","uThixo awupha uMosi entabeni yeSinayi ngelanga alaya ngalo abako-Israyeli ukuthi balethe iminikelo yabo kuThixo, enkangala yaseSinayi. ");
INSERT INTO nde_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Letha u-Aroni lamadodana akhe, izembatho zabo, amafutha okugcoba ogcotshelwa isikhundla, inkunzi yomnikelo wesono, inqama ezimbili lesitsha sokuthwalela isinkwa esibhekhwe singelamvubelo, ");
INSERT INTO nde_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ubusubuthanisa ibandla lonke esangweni lethente lokuhlangana.” ");
INSERT INTO nde_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","UMosi wenza njengokulaya kukaThixo, ibandla lonke laselibuthana esangweni lethente lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","UMosi wakhuluma ebandleni wathi, “Lokhu yikho uThixo alaye ukuthi kwenziwe.” ");
INSERT INTO nde_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","UMosi waseletha u-Aroni lamadodana akhe phambili, wabagezisa ngamanzi. ");
INSERT INTO nde_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Wagqokisa u-Aroni ibhatshi, wasemgaxa ibhanti, wamgqokisa isembatho semahlombe, waphinda wabopha isembatho semahlombe ngozwezwe lwaso olwelukwe ngobungcitshi; walibophela kuye. ");
INSERT INTO nde_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Wamgqokisa isembatho sesifuba wasebeka i-Urimi leThumimi esambathweni leso. ");
INSERT INTO nde_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Wamthwalisa iqhiye ekhanda lakhe, phambi kwayo wabeka icence legolide, umqhele ongcwele, njengalokhu uThixo ayelaye uMosi ukuthi akwenze. ");
INSERT INTO nde_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","UMosi wathatha amafutha okugcoba ogcotshelwa isikhundla wagcoba ithabanikeli lakho konke okwakukulo, wakwahlukanisela uThixo. ");
INSERT INTO nde_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Wachela amanye amafutha e-alithareni kasikhombisa, wagcoba i-alithari lezitsha zalo zonke, lomkolo walo, lalapho obekwa khona ukuze akwahlukanisele uThixo. ");
INSERT INTO nde_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Wathela amanye amafutha ekhanda lika-Aroni wamgcoba ukuba amahlukanisele uThixo. ");
INSERT INTO nde_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Wasesondeza amadodana ka-Aroni phambili, wawagqokisa amabhatshi, wawabopha ngamabhanti njalo wawabophela izingwane emakhanda awo njengalokho uThixo akulaya uMosi. ");
INSERT INTO nde_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Waseletha inkunzi yomnikelo wesono, u-Aroni lamadodana akhe babeka izandla zabo phezu kwekhanda layo. ");
INSERT INTO nde_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","UMosi wahlaba inkunzi, wasethatha elinye igazi, waselininda empondweni ze-alithare ngomunwe ukuze lihlambuluke. Wathululela igazi elalisele phansi kwe-alithari walahlukanisela uThixo, ukwenza ukubuyisana ngalo. ");
INSERT INTO nde_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","UMosi wasethatha idanga eligoqela ezangaphakathi, amahwahwa aphezu kwesibindi, lezinso zombili lamahwahwa azo, wasekutshisela e-alithareni. ");
INSERT INTO nde_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Kodwa inkunzi lesikhumba sayo, lenyama yayo, lamathumbu ayo wakutshisela phandle kwezihonqo njengalokho uThixo amlaya khona. ");
INSERT INTO nde_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Waseletha inqama ukuze ibe ngumnikelo wokutshiswa, u-Aroni lamadodana akhe babeka izandla zabo phezu kwekhanda layo. ");
INSERT INTO nde_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","UMosi wayihlaba inqama, wasechela igazi layo emaceleni wonke e-alithare. ");
INSERT INTO nde_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Wahlahlela inqama yaba ngamaqatha, wasetshisa inhloko, amaqatha lamahwahwa. ");
INSERT INTO nde_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Wagezisa ezangaphakathi lemilenze ngamanzi, wasetshisa isidumbu sonke senqama e-alithareni njengomnikelo wokutshiswa, iphunga elimnandi, umnikelo owenziwa kuThixo ngomlilo njengoba uThixo walaya uMosi. ");
INSERT INTO nde_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Waseletha eyinye inqama, eyayizasetshenziswa begcotshelwa izikhundla, u-Aroni lamadodana akhe babeka izandla zabo phezu kwekhanda layo. ");
INSERT INTO nde_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","UMosi wahlaba inqama, wathatha elinye igazi layo walininda esiqwini sendlebe yokunene ka-Aroni, esithupheni sesandla sakhe sokunene lasozwaneni olukhulu lonyawo lwakhe lwesokunene. ");
INSERT INTO nde_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","UMosi waletha amadodana ka-Aroni phambili, waseninda elinye igazi eziqwini zendlebe zawo zakwesokudla lasezithupheni zezandla zabo zakwesokudla. Emva kwalokho wasechela igazi emaceleni wonke e-alithare. ");
INSERT INTO nde_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Wathatha amahwahwa, umsila ononileyo ledanga eligoqela ezangaphakathi, amahwahwa aphezu kwesibindi, izinso zombili lamahwahwa azo kanye lomlenze wakwesokudla. ");
INSERT INTO nde_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Esitsheni sesinkwa esibhekhwa singelamvubelo, esasiphambi kukaThixo, wathatha isinkwa esikhulu, esasixutshaniswe lamafutha e-oliva kanye lesinkwa esincinyane, wasekufaka emahwahweni lasemlenzeni wesokunene. ");
INSERT INTO nde_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Wabeka konke lokhu ezandleni zika-Aroni lezamadodana akhe, bakuzunguza phambi kukaThixo, kwaba ngumnikelo wokuzunguza. ");
INSERT INTO nde_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","UMosi wakuthatha ezandleni zabo wasekutshisela e-alithareni phezu komnikelo wokutshiswa, kwaba ngumnikelo wokugcotshwa olephunga elimnandi, umhlatshelo wokudla onikelwa kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","UMosi wasethatha isifuba, esesiyisabelo sakhe enqameni yokugcotshwa, wasizunguza phambi kukaThixo njengomnikelo wokuzunguzwa njengokulaywa kukaMosi nguThixo. ");
INSERT INTO nde_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","UMosi wasethatha amanye amafutha okugcobela isikhundla lelinye igazi elisuka e-alithareni, wasechela u-Aroni lezembatho zakhe kanye lamadodana akhe lezembatho zawo. Ngalokho wangcwelisa u-Aroni lezembatho zakhe, lamadodana akhe lezembatho zawo. ");
INSERT INTO nde_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","UMosi wasesithi ku-Aroni lamadodana akhe, “Phekelani inyama esangweni lethente lokuhlangana, liyidlele khona lesinkwa esivela esitsheni seminikelo yokugcotshwa njengokulaywa kwami ukuthi ‘u-Aroni lamadodana akhe yibo abazakudla.’ ");
INSERT INTO nde_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Beselitshisa yonke inyama lesinkwa okuzasala. ");
INSERT INTO nde_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Lingasuki esangweni lethente lokuhlangana okwensuku eziyisikhombisa, kuze kuphele amalanga okugcotshwa kwenu, ngoba ukugcotshwa kwenu kuzathatha insuku eziyisikhombisa. ");
INSERT INTO nde_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Lokho okwenziwa namuhla kwalaywa nguThixo ukwenzela ukuthi lilungiselwe indlela yokubuyisana. ");
INSERT INTO nde_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Kumele lihlale esangweni lethente lokuhlangana ubusuku lemini, okwensuku eziyisikhombisa lisenza lokho okuyabe kufunwa nguThixo ukuze lingafi, ngoba yikho engakulaywayo.” ");
INSERT INTO nde_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Ngakho u-Aroni lamadodana akhe benza konke uThixo ayebalaye khona ngoMosi. ");
INSERT INTO nde_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Ngosuku lwesificaminwembili uMosi wabiza u-Aroni lamadodana akhe kanye labadala bako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Wathi ku-Aroni, “Thatha iguqa lenkunzi engelasici ibe ngumnikelo wesono, lenqama engelasici ibe ngumnikelo wokutshiswa, ukwethule phambi kukaThixo. ");
INSERT INTO nde_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Ubusutshela abako-Israyeli uthi: ‘Thathani impongo ibe ngumnikelo wesono, ithole lezinyane, konke kungokulomnyaka owodwa njalo kungelasici, kube ngumnikelo wokutshiswa, ");
INSERT INTO nde_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","uthathe inkabi kanye lenqama kube ngumnikelo wobudlelwano oba ngumhlatshelo phambi kukaThixo, ndawonye lomnikelo wamabele ohlanganiswe lamafutha, ngoba uThixo uzabonakala kuwe lamhlanje.’ ” ");
INSERT INTO nde_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Bathatha izinto lezo uMosi ayebalaye ngazo bazisa phambi kwethente lokuhlangana, ibandla lonke lasondela eduze lema phambi kukaThixo. ");
INSERT INTO nde_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","UMosi wasesithi, “Lokhu yikho uThixo alaye ukuthi likwenze, ukuze inkazimulo kaThixo ibonakale kini.” ");
INSERT INTO nde_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","UMosi wathi ku-Aroni, “Woza e-alithareni uzonikela umhlatshelo wesono sakho kanye lomnikelo wakho wokutshiswa, wenzele wena kanye labantu indlela yokubuyisana. Unikele umhlatshelo wabantu ubenzele uxolo njengalokhu okulaywe nguThixo.” ");
INSERT INTO nde_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Ngakho u-Aroni weza e-alithareni, wahlaba ithole laba ngumnikelo wakhe wesono. ");
INSERT INTO nde_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Amadodana akhe aletha igazi kuye, wasegxumuza umunwe wakhe egazini waninda ngalo impondo ze-alithare. ");
INSERT INTO nde_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","E-alithareni watshisa amahwahwa, izinso kanye lamahwahwa aphezu kwesibindi kungokomnikelo wesono, njengalokhu uThixo ayekulaye uMosi. ");
INSERT INTO nde_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Inyama kanye lesikhumba wakutshisela ngaphandle kwezihonqo. ");
INSERT INTO nde_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Wasehlaba umnikelo wokutshiswa. Amadodana akhe amnika igazi, walichela inxa zonke ze-alithare. ");
INSERT INTO nde_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Bamupha umnikelo wokutshiswa, isitho ngesitho kugoqela inhloko, wakutshisela e-alithareni. ");
INSERT INTO nde_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Wagezisa ezangaphakathi kanye lemilenze wakutshisela phezu komnikelo wokutshiswa e-alithareni. ");
INSERT INTO nde_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","U-Aroni waseletha umnikelo owawungowabantu, wathatha imbuzi eyayingeyomnikelo wesono wayihlaba, waseyinikela yaba ngumnikelo wesono njengalokhu ayekwenze ngeyakuqala. ");
INSERT INTO nde_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Waletha umnikelo wokutshiswa wawunikela ngendlela emisiweyo. ");
INSERT INTO nde_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Waletha njalo umnikelo wamabele, wacupha ngesandla, wasewutshisela e-alithareni phezu kwalowo owokutshiswa ayewunikele ekuseni. ");
INSERT INTO nde_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Wahlaba inkabi kanye lenqama kwaba ngumnikelo wobudlelwano ebantwini. Amadodana akhe amnika igazi, walichela inxa zonke ze-alithare. ");
INSERT INTO nde_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Kodwa amahwahwa enkabi lawenqama, lomsila ononileyo, idanga, izinso, lamahwahwa aphezu kwesibindi ");
INSERT INTO nde_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","bakwendlala phezu kwesifuba, u-Aroni wasetshisela amahwahwa e-alithareni. ");
INSERT INTO nde_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","U-Aroni wazunguza izifuba kanye lomlenze wokwesokunene phambi kukaThixo njengomnikelo wokuzunguza, njengokulaya kukaMosi. ");
INSERT INTO nde_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","U-Aroni wasephakamisela izandla zakhe ebantwini wababusisa. Kwathi esenikele umnikelo wesono, umnikelo wokutshiswa kanye lowobudlelwano, wahlala phansi. ");
INSERT INTO nde_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","UMosi lo-Aroni basebesiyangena ethenteni lokuhlangana. Bathi bephuma, babusisa abantu; inkazimulo kaThixo yabonakala kubo bonke abantu. ");
INSERT INTO nde_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Kwavela umlilo lapho ngoba uThixo wayekhona, kwatsha umnikelo wokutshiswa kanye lamahwahwa e-alithareni. Abantu bonke bathi bebona lokho, bamemeza ngentokozo bathi mbo ngobuso phansi. ");
INSERT INTO nde_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Amadodana ka-Aroni uNadabi lo-Abhihu bathatha izitsha zempepha, bafaka umlilo kuzo, bafaka impepha; basebenikela ngomlilo phambi kukaThixo ngokungekho emandleni abo, njalo kuphambene lomlayo wakhe. ");
INSERT INTO nde_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Kwavela umlilo lapho uThixo ayekhona, wabatshisa bafa phambi kukaThixo. ");
INSERT INTO nde_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","UMosi wasesithi ku-Aroni, “Lokhu yikho okwakhulunywa nguThixo aze athi: ‘Kulabo abasondela kimi Ubungcwele bami buzabonakala, phambi kwabo bonke abantu Ngizadunyiswa.’ ” U-Aroni wala ethule. ");
INSERT INTO nde_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","UMosi wabiza uMishayeli lo-Elizafani amadodana kamalumakhe ka-Aroni u-Uziyeli, wathi kubo, “Wozani lapha lizothwala abafowenu libakhuphele phandle kwezihonqo, khatshana laphambi kwendlu engcwele.” ");
INSERT INTO nde_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ngakho beza babathwala belokhu begqoke amabhatshi abo, babakhuphela ngaphandle kwezihonqo njengokulaya kukaMosi. ");
INSERT INTO nde_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","UMosi wasesithi ku-Aroni lamadodana akhe u-Eliyazari lo-Ithamari, “Lingayekeli inwele zenu zingembozwanga njalo lingadabuli izigqoko zenu ngokuhlulukelwa, funa life, loThixo athukuthelele abantu bonke. Kodwa zonke izihlobo zenu lendlu yonke ka-Israyeli bangabakhalela labo ababhujiswe nguThixo ngomlilo. ");
INSERT INTO nde_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Lingaze lasuka esangweni lethente lokuhlangana funa life, ngoba amafutha kaThixo okugcoba ogcotshelwa isikhundla aphezu kwenu.” Ngakho benza njengokulaya kukaMosi. ");
INSERT INTO nde_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","UThixo wasesithi ku-Aroni, ");
INSERT INTO nde_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Wena lamadodana akho akumelanga linathe iwayini loba okunye okunathwayo okubilileyo nxa lisiyangena ethenteni lokuhlangana, funa life. Lo ngumlayo omi kuze kube nininini kuzizukulwane ezizayo. ");
INSERT INTO nde_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Kumele lahlukanise okungcwele kokungangcwele, okuhlanzekileyo kokungahlanzekanga, ");
INSERT INTO nde_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","njalo kumele lifundise abako-Israyeli zonke izimiso uThixo abaphe zona ngoMosi.” ");
INSERT INTO nde_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","UMosi wathi ku-Aroni kanye lamadodana akhe aseleyo, u-Eliyazari lo-Ithamari, “Thathani umnikelo wamabele oseleyo emihlatshelweni yokudla enikelwe kuThixo, liwudle ungelamvubelo eceleni kwe-alithari ngoba ungcwele kakhulu. ");
INSERT INTO nde_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Udleleni endaweni engcwele, ngoba uyisabelo senu kanye lamadodana enu, njengoba ngilaywe ngokunjalo. ");
INSERT INTO nde_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Kodwa wena lamadodana akho kanye lamadodakazi akho lingadla isifuba esazunguzwayo kanye lomlenze onikelweyo. Kudleleni endaweni ehlanzekileyo ngokomkhuba; kuphiwe wena kanye labantwabakho njengesabelo somnikelo wobudlelwano kwabako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Umlenze owanikelwayo kanye lesifuba esazunguzwayo kumele kulethwe kanye lamahwahwa anikelwa ngomlilo, azozunguzwa phambi kukaThixo njengomnikelo wokuzunguzwa. Lokho kuzakuba yisabelo sansukuzonke esakho kanye labantwabakho, njengokulaya kukaThixo.” ");
INSERT INTO nde_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","UMosi wathi ebuza ngembuzi yomnikelo wesono wathola ukuthi yayisitshisiwe, wathukuthelela u-Eliyazari lo-Ithamari, amadodana ka-Aroni ayesesele, wawabuza wathi, ");
INSERT INTO nde_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Kungani lingadlelanga umnikelo wesono endlini engcwele na? Ungcwele kakhulu; lawuphiwa ukuze ususe icala labantu ngokwenza ukuthi babuyiswe phambi kukaThixo. ");
INSERT INTO nde_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Njengoba igazi lawo lingangeniswanga eNdaweni eNgcwele, bekumele imbuzi liyidlele endlini engcwele njengokulaya kwami.” ");
INSERT INTO nde_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","U-Aroni waphendula uMosi wathi, “Lamuhla benze umhlatshelo womnikelo wesono kanye lomnikelo wokutshiswa phambi kukaThixo, kodwa izinto ezinjengalezi sezenzakele kimi. Nxa bengidle umnikelo wesono lamuhla, kambe uThixo ubengachelesa ngalokho na?” ");
INSERT INTO nde_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","UMosi wasuthiseka ekuzwa lokho. ");
INSERT INTO nde_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","UThixo wathi kuMosi lo-Aroni, ");
INSERT INTO nde_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Alibokuthi kwabako-Israyeli: ‘Kuzozonke izinyamazana ezisemhlabeni, yilezi elingazidla; ");
INSERT INTO nde_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","lingadla zonke izinyamazana ezilenklagu ezivulekileyo lezentshisayo. ");
INSERT INTO nde_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Zikhona ezinye ezentshisayo kuphela, zibe khona ezinye ezilenklagu ezivulekileyo kuphela kodwa lingabozidla. Ikamela loba lisentshisa kalilanklagu ezivulekileyo; ngomkhuba kalihlanzekanga kini. ");
INSERT INTO nde_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Imbila loba isentshisa kayilanklagu ezivulekileyo; ingcolile kini. ");
INSERT INTO nde_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Umvundla, loba usentshisa, kawulanklagu ezivulekileyo; ungcolile kini. ");
INSERT INTO nde_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Lengulube, loba ilenklagu ezivulekileyo ngokupheleleyo, ayentshisi; ingcolile kini. ");
INSERT INTO nde_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Akufanelanga lidle inyama yazo njalo akufanelanga lithinte loba izidumbu zazo; ngoba zingcolile kini. ");
INSERT INTO nde_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Kuzozonke izidalwa ezihlala emanzini asolwandle lasezifuleni, lingadla zonke ezilempiko lamaxolo. ");
INSERT INTO nde_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Kodwa zonke izidalwa ezisolwandle lasezifuleni ezingelampiko lamaxolo, kungelani lokuthi ngezihamba ngamaxuku kumbe phakathi kwazo zonke eziphila emanzini kumele lizenyanye. ");
INSERT INTO nde_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Njalo njengoba lizazenyanya, lingabokudla inyama yazo, njalo kumele lizenyanye lezidumbu zazo. ");
INSERT INTO nde_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Yonke inyamazana ehlala emanzini engalampiko lamaxolo kumele yenyanyeke kini. ");
INSERT INTO nde_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Lezi yizinyoni okumele lizenyanye njalo lingazidli ngoba zingcolile: ukhozi, ilinqe, ");
INSERT INTO nde_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","uhelwane olubomvu, loba wuphi umhlobo wohelwane, ");
INSERT INTO nde_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","imihlobo yonke yamawabayi, ");
INSERT INTO nde_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","isikhova esilesicholo, isikhova esitshaya udweba, ingabuzane, loba wuphi umhlobo wokhozi, ");
INSERT INTO nde_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","umandukulo, itshayamanzi, isikhova esikhulu, ");
INSERT INTO nde_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","isikhova esimhlophe, isikhova senkangala, ukhozi oludla inhlanzi, ");
INSERT INTO nde_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ingabuzane, lawuphi umhlobo welanda, imvenduna lomalulwane. ");
INSERT INTO nde_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Zonke izibungu ezilamaphiko ezihamba ngenyawo zazo ezine kumele zibe ngezingcolileyo kini. ");
INSERT INTO nde_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Kodwa kulezinye izibungu ezilamaphiko, ezihamba ngezinyawo zazo ezine, lingadla lezo ezilamangqondo, ezeqa ngawo emhlabathini. ");
INSERT INTO nde_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Kuzo lingadla intethe ngemihlobo yazo, lamadiye ngemihlobo yawo. ");
INSERT INTO nde_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Kodwa zonke ezinye izibungu ezilamaphiko lenyawo ezine lizenyanye. ");
INSERT INTO nde_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Liyabe liyazingcolisa ngalezi; ngakho loba ngubani othinta izidumbu zazo uzatshona engongcolileyo kuze kuhlwe. ");
INSERT INTO nde_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Ozaphakamisa izidumbu zezinyamazana lezi kumele ahlambulule izigqoko zakhe, kanti-ke yena uzaba ngongcolileyo kuze kuhlwe. ");
INSERT INTO nde_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Yonke inyamazana elengqina elingehlukananga ngokupheleleyo loba engentshisiyo ingcolile kini, wonke othinta isidumbu sezinyamazana lezi uzabe esengongcolile. ");
INSERT INTO nde_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Kuzozonke izinyamazana ezihamba ngenyawo ezine, lezo ezihamba ngezidladla zingcolile kini; kuzakuthi wonke othinta izidumbu zazo abe ngongcolileyo kuze kuhlwe. ");
INSERT INTO nde_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Loba ngubani ozaphakamisa izidumbu zezinyamazana lezi kumele ahlambulule izigqoko zakhe, njalo uzatshona engongcolileyo kuze kuhlwe. Zingcolile kini. ");
INSERT INTO nde_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Ezinyamazaneni zonke ezihambahambayo emhlabathini, lezi zingcolile kini: indlegu, igundwane, lemihlobo yonke yemibankwa emikhulu, ");
INSERT INTO nde_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","untulo, imbulumakhasane, umbankwa, isiqhuza lonwabu. ");
INSERT INTO nde_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Kuzozonke ezihuquzelayo emhlabathini, lezi zingcolile kini. Loba ngubani ozithinta sezifile uzatshona engongcolileyo kuze kuhlwe. ");
INSERT INTO nde_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Nxa kungafa eyinye yazo iwele phezu kolutho, lololutho, loba lusetshenziswani luzabe selungolungcolileyo, loba lwenziwe ngesigodo, ngelembu, ngesikhumba loba ngesaka. Lufakeni emanzini; luzabe lungcolile kuze kuhlwe, lapho-ke luzabe seluhlambulukile. ");
INSERT INTO nde_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Nxa esinye sazo singawela embizeni yomdaka, konke okusembizeni kuyabe sekungcolile, sekumele ubulale imbiza. ");
INSERT INTO nde_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Konke ukudla obekungadliwa okuchaphakelwe ngamanzi aleyo mbiza kungcolile, njalo lobekunganathwa kuvela kuleyo mbiza kungcolile. ");
INSERT INTO nde_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Loba yini ewelwe yizidumbu zezinanakazana lezi iba ngengcolileyo; iziko loba imbiza yokupheka sekumele kubhidlizwe. Kuyabe sekungcolile, njalo kumele likuthathe njengokungcolileyo. ");
INSERT INTO nde_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Kanti-ke, umthombo loba umgqomo wokukha amanzi uhlala uhlambulukile, kodwa loba ngubani othinta izidumbu lezi ungcolile. ");
INSERT INTO nde_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Nxa isidumbu sezinyamazana lezi singawela loba kuyiphi inhlanyelo esilungele ukuhlanyelwa, izahlala ihlambulukile. ");
INSERT INTO nde_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Kodwa nxa amanzi esethelwe enhlanyelweni, isidumbu sakhona besesiwela phezu kwayo, isingcolile kini. ");
INSERT INTO nde_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Nxa inyamazana elivunyelwe ukuyidla ingazifela, lowo othinta isidumbu sayo uzakuba ngongcolileyo kuze kuhlwe. ");
INSERT INTO nde_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Loba ngubani ozakudla inyama yalesisidumbu kumele ahlambulule izigqoko zakhe, uzakuba ngongcolileyo kuze kuhlwe. Loba ngubani ozaphakamisa lesisidumbu, kumele ahlambulule izigqoko zakhe, uzakuba ngongcolileyo kuze kuhlwe. ");
INSERT INTO nde_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Loba yisiphi isinanakazana esihuquzelayo emhlabathini siyenyanyeka, kasingadliwa. ");
INSERT INTO nde_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Akufanelanga lidle izinanakazana zonke ezihambahambayo emhlabathini, loba ngezihuquzela ngezisu loba ngezihamba ngazozonke zone loba ngezilenyawo ezinengi; ziyenyanyeka. ");
INSERT INTO nde_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Lingazingcolisi ngezinanakazana lezi, lingazingcolisi ngenxa yazo njalo lingayekeli zilingcolisa. ");
INSERT INTO nde_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","NginguThixo uNkulunkulu wenu, zihlambululeni libengcwele, ngoba mina ngingcwele. Lingazingcolisi ngezinanakazana ezihuquzelayo emhlabathini. ");
INSERT INTO nde_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","NginguThixo owalikhupha eGibhithe ukuze ngibe nguNkulunkulu wenu; kungakho wobani ngcwele, ngoba mina ngingcwele. ");
INSERT INTO nde_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Le yiyo imithetho emayelana lezinyamazana, izinyoni, yonke into ephilayo entsheza emanzini lezinanakazana ezihuquzela emhlabathini. ");
INSERT INTO nde_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Kumele lehlukanise phakathi kwezingcolileyo lezihlambulukileyo, lehlukanise phakathi kwezidalwa eziphilayo ezingadliwa kanye lokungamelanga zidliwe.’ ” ");
INSERT INTO nde_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","UThixo wathi kuMosi: ");
INSERT INTO nde_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Tshela abako-Israyeli ukuthi: ‘Umfazi ozithweleyo obelethe indodana uzakuba ngongcolileyo ngokomkhuba okwensuku eziyisikhombisa njengoba engcolile ngesikhathi esemfuleni. ");
INSERT INTO nde_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Ngosuku lwesificaminwembili indodana le kuzamele isokwe. ");
INSERT INTO nde_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Owesifazane kufanele ame okwensuku ezingamatshumi amathathu lantathu ukuze ahlanjululwe ukopha kwakhe. Ngalesisikhathi, akumelanga abambe ulutho olungcwele njalo akumelanga aye endlini engcwele kuze kwedlule insuku zakhe zokuhlanjululwa. ");
INSERT INTO nde_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Nxa angabeletha indodakazi, owesifazane uzaba ngongcolileyo okwamaviki amabili, njenganxa esemfuleni. Kufanele ahlale okwensuku ezingamatshumi ayisithupha lezinsuku eziyisithupha ukuze ahlanjululwe ukopha kwakhe. ");
INSERT INTO nde_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Nxa insuku zokuhlanjululwa ngokwendodana loba indodakazi seziphelile, kumele owesifazane alethe izinyane lemvu elilomnyaka owodwa kumphristi esangweni lethente lokuhlangana ukuze libe ngumnikelo wokutshiswa kanye lephuphu lenkwilimba loba ijuba kube ngumnikelo wesono. ");
INSERT INTO nde_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Umphristi nguye ozanikela umnikelo phambi kukaThixo ukumenzela ukubuyisana, ngalokho uzabe esehlambulukile ngokomkhuba ekopheni kwakhe. Le yiyo imithetho elandelwa ngowesifazane ekubeletheni umfana loba inkazana. ");
INSERT INTO nde_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Nxa engenelisi ukunikela ngezinyane lemvu, kumele alethe amajuba amabili loba inkwilimba ezisesencane ezimbili, okunye kungumnikelo wokutshiswa okunye kungumnikelo wesono. Ngalindlela umphristi uzamenzela ukubuyisana, owesifazane uzahlambuluka.’ ” ");
INSERT INTO nde_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","UThixo wathi kuMosi lo-Aroni, ");
INSERT INTO nde_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Loba ngubani ozabe evuvukile, loba equbukile, loba elechatha elicazimulayo ejwabini lakhe okungasuka kube ngumkhuhlane wobulephero, kumele alethwe ku-Aroni umphristi loba komunye wamadodana akhe ongumphristi. ");
INSERT INTO nde_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Umphristi kahlole lesisilonda esisejwabini lakhe, kuthi kungabonakala ukuthi uboya obusesilondeni sebumhlophe, lokuthi lesilonda laso sizikile enyameni, kuyabe kungumkhuhlane wobulephero. Nxa umphristi emhlola, uzamtshela ukuthi ungcolile ngokomlayo. ");
INSERT INTO nde_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Kanti-ke lanxa ibala elisejwabini limhlophe kodwa libonakala ukuthi alijulanga enyameni njalo loboya obukhonapho bungakabimhlophe, umphristi kamsuse ebantwini, ahlale yedwa okwensuku eziyisikhombisa. ");
INSERT INTO nde_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Ngosuku lwesikhombisa umphristi kumele amhlole, kuthi-ke nxa ebona ukuthi isilonda lokhu sinjalo njalo kasiqhelanga ejwabini, kumele amehlukanise kwabanye okwezinye njalo insuku eziyisikhombisa. ");
INSERT INTO nde_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Ngosuku lwesikhombisa umphristi uzamhlola njalo, kuthi-ke nxa isilonda sesifiphele singaqhelanga ejwabini, umphristi uzamtshela lowomuntu ukuthi usehlambulukile, bekukade kuyikuqubuka kodwa nje. Leyondoda izagezisa izigqoko zayo njalo iyabe isihlambulukile. ");
INSERT INTO nde_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Kodwa ukuqubuka kungaqhela ejwabini lakhe ngemva kokuba eseke waziveza kumphristi ukuba kuthiwe usehlambulukile, kumele aziveze njalo kumphristi. ");
INSERT INTO nde_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Umphristi uzamhlola, kuthi-ke nxa ukuqubuka kuqhelile ejwabini, umphristi kumele amtshele ukuthi kakahlambuluki; yibulephero. ");
INSERT INTO nde_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Nxa kulomuntu olobulephero, kumele alethwe kumphristi. ");
INSERT INTO nde_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Umphristi kamhlole, kuthi nxa kuleqhubu elimhlophe eseliphendule uboya babamhlophe njalo lilomlomo, ");
INSERT INTO nde_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","yibulephero, ngakho umphristi uzakuthi ungcolile. Kangamehlukanisi labanye, ngoba uvele esengongcolileyo. ");
INSERT INTO nde_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Nxa ubulephero sobumemetheka umzimba wonke okubonwa ngumphristi ukuthi sobugcwele kusukela ekhanda kuze kube sezinyaweni, ");
INSERT INTO nde_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","umphristi uzamhlola, kuthi nxa bugcwele umzimba wonke, atsho athi lowomuntu uhlambulukile. Njengoba ijwabu seliphenduke labamhlophe lonke, uyabe ehlambulukile. ");
INSERT INTO nde_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Kodwa nxa kubonakala sekupetuka inyama esilondeni uzabe engongcolileyo. ");
INSERT INTO nde_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Umphristi nxa ebona inyama isipetuka uzakuthi ungcolile. Inyama epetukileyo ingcolile; ulobulephero. ");
INSERT INTO nde_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Kodwa leyonyama epetukileyo ingaguquka ibemhlophe kufanele onjalo aye kumphristi. ");
INSERT INTO nde_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Umphristi amhlole, kuthi nxa izilonda sezisuke zaba mhlophe, umphristi uzakuthi lowo olazo uhlambulukile; ngakho uzabe esehlambulukile. ");
INSERT INTO nde_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Nxa kulomuntu olethumba ejwabini lakhe libe seliphola, ");
INSERT INTO nde_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","kuthi lapho obekulethumba khona kubonakale kumhlotshana kuvuvukile loba iqhubu elibomvana, kumele azilethe kumphristi. ");
INSERT INTO nde_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Umphristi alihlole, kuthi nxa kubonakala lijulile loboya obuphezu kwalo sebumhlophe, umphristi uzakuthi ungcolile. Yibulephero obuvela lapho obekulethumba khona. ");
INSERT INTO nde_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Kodwa nxa khona laphayana ekuhlolweni kwalo ngumphristi kungelaboya obumhlophe phezu kwalo, njalo lingajulanga selifiphele, kulapho umphristi azamehlukanisa khona labanye okwensuku eziyisikhombisa. ");
INSERT INTO nde_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Nxa liqhela ejwabini, umphristi uzakuthi ungcolile, lona liyisifo esithelelwanayo. ");
INSERT INTO nde_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Kodwa nxa umbala walo ulokhu unjalo, njalo lingaqhelanga, kuyabe kulitshisa elatshiywa lithumba, ngakho umphristi uzakuthi uhlambulukile. ");
INSERT INTO nde_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Nxa umuntu elethuthuva ejwabini lakhe besekuvela itshatha elibomvana loba elimhlophe enyameni epetukileyo yetshisa, ");
INSERT INTO nde_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","umphristi kalihlole, kuzakuthi nxa uboya obuphezu kwalo sebumhlophe, kubonakale kungani kujulile, yibulephero obuvela ngethuthuva. Umphristi uzakutsho ukuthi ungcolile, yibulephero. ");
INSERT INTO nde_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Kodwa umphristi angalihlola kubonakale kungelaboya obumhlophe, kungajulanga njalo sekufiphele, yikho lapho umphristi azamehlukanisa labanye okwensuku eziyisikhombisa. ");
INSERT INTO nde_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Ngosuku lwesikhombisa umphristi uzamhlola, kuthi nxa liqhela ejwabini, umphristi athi ungcolile, yibulephero. ");
INSERT INTO nde_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Kodwa nxa itshatha lilokhu linjalo futhi lingaqhelanga ejwabini kodwa selifiphele, kuyabe kulithuthuva elivuvukileyo, umphristi uzakuthi uhlambulukile, bekulitshisa nje kuphela. ");
INSERT INTO nde_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Nxa owesilisa loba owesifazane elesilonda ekhanda loba esilevini, ");
INSERT INTO nde_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","umphristi kasihlole, kuthi nxa kubonakala sijulile enyameni, inwele phezu kwaso sezimpofana njalo zingakhuli, umphristi uzakuthi lowomuntu ungcolile, yibulephero bekhanda loba obesilevu. ");
INSERT INTO nde_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Kodwa nxa umphristi angasihlola isilonda leso abone singajulanga, kungelanwele ezimnyama kuso, umphristi uzamsusa lowomuntu ebantwini okwensuku eziyisikhombisa. ");
INSERT INTO nde_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Ngosuku lwesikhombisa, umphristi kumele asihlole leso silonda, kuthi nxa singaqhelanga ejwabini, njalo kungelaboya obulithanga phezu kwaso, khona kubonakala ukuthi asijulanga enyameni, ");
INSERT INTO nde_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","kufanele aphucwe kutshiywe indawo elesifo, umphristi aphinde amehlukanise kwabanye okwensuku eziyisikhombisa. ");
INSERT INTO nde_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Ngosuku lwesikhombisa umphristi kumele asihlole, kuthi nxa singaqhelanga njalo kukhanya singajulanga enyameni, umphristi kathi uhlambulukile. Kufanele agezise izigqoko zakhe, abesesiba ngohlambulukileyo. ");
INSERT INTO nde_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Kodwa nxa isilonda siqhela ejwabini emva kokuba sekuthiwe usehlambulukile, ");
INSERT INTO nde_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","umphristi uzamhlola, kanti-ke nxa isilonda sisuke saqhela ejwabini, akudingakali ukuthi umphristi adinge ukubona uboya obulithanga; lowomuntu ungcolile. ");
INSERT INTO nde_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Kodwa nxa ngokubona kwakhe isilonda leso silokhu singaguqukanga sekulenwele ezimnyama kuso, siyabe sesipholile. Uyabe esehlambulukile, umphristi uzakuthi uhlambulukile. ");
INSERT INTO nde_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Nxa indoda loba owesifazane elamabala amhlotshana ejwabini, ");
INSERT INTO nde_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","umphristi kumele awahlole, kuthi nxa amabala lawo emhlotshana okungani kufiphele, kuyabe kuyikuqubuka okumveleleyo ejwabini; ngakho lowomuntu uhlambulukile. ");
INSERT INTO nde_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Nxa indoda ingaselanwele isilempabanga, ihlambulukile. ");
INSERT INTO nde_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Nxa ingaselanwele phezu kwebunzi, isilempabanga ihlambulukile. ");
INSERT INTO nde_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Kodwa nxa ilesilonda esibomvana-okumhlotshana ekhanda elilempabanga loba ebunzini, yibulephero obuyabe buqalisa ekhanda loba ebunzini. ");
INSERT INTO nde_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Umphristi kayihlole leyondoda, kuthi nxa isilonda esivuvukayo ekhanda layo loba ebunzini sibomvana-okumhlotshana njengobulephero, ");
INSERT INTO nde_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","leyondoda isilabo njalo isingcolile. Umphristi uzakuthi leyondoda ingcolile ngenxa yaleso silonda esisekhanda layo. ");
INSERT INTO nde_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Umuntu olobulephero kumele agqoke izigqoko ezidabukileyo, ayekele inwele zakhe zingakanywanga, embese ingxenye yangaphansi kobuso bakhe amemeze athi: ‘Ngingcolile! Ngingcolile!’ ");
INSERT INTO nde_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Kuzakuthi nxa elokhu elaleso sifo, ahlale engongcolileyo. Kumele ahlale yedwa, ahlale ngaphandle kwesihonqo.” ");
INSERT INTO nde_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Nxa isigqoko sagqokwa ngumuntu olobulephero, isembatho sewulu loba eselembu, ");
INSERT INTO nde_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","eselukiweyo loba esiphothiweyo kuyiwulu loba ilembu, isikhumba loba yini eyenziwe ngesikhumba, ");
INSERT INTO nde_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","nxa lokhu kungcola kusesembathweni selembu, isikhumba, loba yini eyelukiweyo, loba ephothiweyo loba kuyini okwesikhumba, kubonakala kuluhlazana loba kubomvana, yibulephero; kufanele kutshengiswe umphristi. ");
INSERT INTO nde_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Umphristi kahlole ukungcola lokhu abesesehlukanisa leyonto esingcolile, ibekwe yodwa okwensuku eziyisikhombisa. ");
INSERT INTO nde_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Ngosuku lwesikhombisa kuzamele akuhlole, kuthi nxa ukungcola sekuqhelile esembathweni, eselukiweyo loba esithungiweyo, loba isikhumba, loba sisetshenziswani, lokho kuyibulephero, isembatho leso singcolile. ");
INSERT INTO nde_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Kumele asitshise isembatho leso, loba eselukiweyo lesithungiweyo, kuyiwulu loba ilembu, loba kuyinto yesikhumba elesifo sokungcola, njengoba kuyibulephero; leyonto kumele itshiswe. ");
INSERT INTO nde_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Kodwa, nxa kuyikuthi ekuhlolweni kwaso ngumphristi, kubonakale ukuthi isifo asiqhelanga ezigqokweni, loba eselukiweyo loba esithungiweyo, loba esesikhumba, ");
INSERT INTO nde_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","uzalaya ukuthi lololutho olungcolileyo lugeziswe. Kulapho-ke azakwehlukanisa khona kwezinye okwensuku eziyisikhombisa. ");
INSERT INTO nde_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Ngemva kokuba lesosembatho esingcolileyo sesigezisiwe, umphristi uzasihlola, kuthi nxa isifo sokungcola esisesigqokweni singaguqukanga umbala waso lanxa siyabe singaqhelanga, singcolile. Kasitshiswe ngomlilo, loba isifo sokungcola sihlasele nganxanye. ");
INSERT INTO nde_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Nxa, lapho umphristi esihlola, kubonakale isilonda sesifiphele ngemva kokugeziswa kwesigqoko, umphristi kadabule ingxenye ebilesifo esigqokweni loba yisikhumba loba ngeselukiweyo loba esiphothiweyo. ");
INSERT INTO nde_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Kodwa nxa isifo sibonakala futhi esigqokweni, ingabe eselukiweyo loba esiphothiweyo, loba kungesesikhumba, siyabe siyaqhela, akuthi konke okulesifo kutshiswe ngomlilo. ");
INSERT INTO nde_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Isigqoko siphi lasiphi, kungaba ngesokwelukwa, esokuphothwa loba esesikhumba esesike sageziswa sahlanzwa lesosifo kumele sigeziswe futhi, kube yikho ukuhlanzeka kwaso.” ");
INSERT INTO nde_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Le yiyo imilayo emayelana lokungcoliswa yibulephero ezigqokweni loba ngezewulu kumbe ezelembu, kungaba ngezelukiweyo loba eziphothiweyo, loba isikhumba; ukuze kuthiwe zihlambulukile loba zingcolile. ");
INSERT INTO nde_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Le yimithetho eqondana lalowo olobulephero ngesikhathi sokuhlanjululwa kwakhe ngokomkhuba, nxa elethwa phambi komphristi. ");
INSERT INTO nde_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Umphristi kaphume ezihonqweni ayemhlola. Nxa umuntu lowo esesilile ebulepherweni, ");
INSERT INTO nde_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","umphristi uzalaya ukuthi kulethelwe inyoni ezimbili eziphilayo, ezihlambulukileyo, kanye lenkuni zesihlahla somsedari, intambo ebomvu lehisophi ukuze lowo muntu ahlanjululwe. ");
INSERT INTO nde_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Lapho-ke umphristi uzalaya ukuthi eyinye yalezo nyoni ibulawelwe phezu kwamanzi acengekileyo, asembizeni yomdaka. ");
INSERT INTO nde_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Usezathatha inyoni ephilayo ayigxamuze ndawonye lokhuni lomsedari, lentambo ebomvu lehisophi egazini laleyo nyoni ebulawelwe phezu kwamanzi ahlambulukileyo. ");
INSERT INTO nde_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Uzachela lowo ohlanjululwa ubulephero ngalelogazi kasikhombisa, abesesithi usehlambulukile. Abesekhulula inyoni esaphila izihambele egangeni. ");
INSERT INTO nde_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Umuntu okufanele ukuthi ahlanjululwe kumele agezise izigqoko zakhe, aphuce zonke inwele zakhe, abesegeza umzimba ngamanzi, ngalokho uzabe esehlambulukile ngokomkhuba. Ngemva kwalokho usengangena ezihonqweni, kodwa kumele ahlale ngaphandle kwethente lakhe okwensuku eziyisikhombisa. ");
INSERT INTO nde_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Ngosuku lwesikhombisa kumele aphuce zonke inwele zakhe, intshiya zakhe kanye lazozonke inwele zakhe. Kufanele agezise izigqoko zakhe, ageze umzimba ngamanzi; ngalokho uzakuba ngohlambulukileyo. ");
INSERT INTO nde_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Ngosuku lwesificaminwembili kumele alethe amazinyane amabili amaduna lelilodwa elisikazi, wonke elomnyaka owodwa, wonke engelasici, ndawonye lezilinganiso zehefa ezintathu etshumini zefulawa ecolekileyo, evutshwe ngamafutha, kungumnikelo wamabele, kanye lehetshezana lwamafutha. ");
INSERT INTO nde_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Umphristi obikayo ukuthi usehlambulukile lowomuntu nguye omethulayo kanye leminikelo yakhe kuThixo esangweni lethente lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Ngemva kwalokho, umphristi kathathe elinye izinyane eliduna anikele ngalo kube ngumnikelo wecala, kanye lehetshezana lwamafutha; uzakuzunguza phambi kukaThixo, kungumnikelo wokuzunguzwa. ");
INSERT INTO nde_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Uzahlaba lelozinyane endaweni engcwele lapho okuhlatshelwa khona iminikelo yesono kanye leminikelo yokutshiswa. Umnikelo wecala ungowomphristi, njengomnikelo wesono; ungcwele kakhulu. ");
INSERT INTO nde_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Umphristi uzathatha elinye igazi lomnikelo wecala alininde oqwangeni lwendlebe yokunene yalowo ozahlanjululwa, esithupheni sesandla sokunene sakhe. ");
INSERT INTO nde_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Umphristi uzathatha amanye amafutha, awathele esandleni sakhe sokhohlo, ");
INSERT INTO nde_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","agxamuze umunwe wakhe wenkomba emafutheni lawo, abesewafafaza phambi kukaThixo kasikhombisa. ");
INSERT INTO nde_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Umphristi kaninde amafutha aseleyo esandleni oqwangeni lwendlebe yokunene yalowo ozahlanjululwa, esithupheni sesandla sokunene lasozwaneni olukhulu lonyawo lolwesokunene, phezu kwegazi lomnikelo wecala. ");
INSERT INTO nde_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Amafutha lawo aseleyo esandleni somphristi kawagcobe ekhanda lalowo ohlanjululwayo, abesemenzela indlela yokubuyisana phambi kukaThixo. ");
INSERT INTO nde_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Ngemva kwalokho, kalethe umnikelo wesono ecelela ozahlanjululwa indlela yokubuyisana kulokhu kungcola kwakhe. Ngemva kwalokho, umphristi uzenza umnikelo wokutshiswa, ");
INSERT INTO nde_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","anikele ngawo e-alithareni, kanye lowamabele, amenzele indlela yokubuyisana, ngalokho uzahlanjululwa. ");
INSERT INTO nde_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Kodwa-ke, nxa engumyanga, engazenelisi lezizinto, kumele athathe izinyane lemvu eliduna libe ngumnikelo wecala ozazunguzwa ukumenzela indlela yokubuyisana, lengxenye eyodwa etshumini yefulawa ecolekileyo ehlanganiswe lamafutha, kungumnikelo wamabele, lehetshezana lwamafutha, ");
INSERT INTO nde_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","lamajuba amabili kumbe amaphuphu enkwilimba amabili, lokho angakwanelisa, okunye kungumnikelo wesono kuthi okunye kube ngumnikelo wokutshiswa. ");
INSERT INTO nde_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Ngosuku lwesificaminwembili kumele akulethe kumphristi ukuba ahlanjululwe esangweni lethente lokuhlangana phambi kukaThixo. ");
INSERT INTO nde_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Umphristi kathathe izinyane lemvu libe ngumnikelo wecala, ndawonye lehetshezana lwamafutha, akuzunguze phambi kukaThixo, kube ngumnikelo wokuzunguzwa. ");
INSERT INTO nde_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Uzahlaba izinyane lemvu kube ngumnikelo wecala abesethatha elinye alininde oqwangeni lwendlebe yokwesokudla yalowo ozahlanjululwa, esithupheni sesandla sokunene kanye lasozwaneni olukhulu lonyawo lwesandla sokunene. ");
INSERT INTO nde_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Umphristi uzachathekela amanye amafutha esandleni sakhe senxele, ");
INSERT INTO nde_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","besekusithi ngomunwe wakhe wenkomba, owesandla sokunene achele amanye amafutha kasikhombisa phambi kukaThixo. ");
INSERT INTO nde_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Kuthi amanye amafutha asesandleni sakhe awaninde endaweni lezo aninde khona igazi lomnikelo wecala, oqwangeni lwendlebe yokwesokudla yalowo ozahlanjululwa, esithupheni sesandla sokunene kanye lasozwaneni olukhulu lonyawo lwesandla sokunene. ");
INSERT INTO nde_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Umphristi uzagcoba ikhanda lalowo ohlanjululwayo ngamafutha aseleyo esandleni sakhe, emenzela indlela yokubuyisana phambi kukaThixo. ");
INSERT INTO nde_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Ngakho uzanikela ngamajuba lawayana loba amaphuphu enkwilimba lezo, lokho ayabe ekwenelisile, ");
INSERT INTO nde_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","okunye kungumnikelo wesono, kuthi okunye kube ngumnikelo wokutshiswa, ndawonye lomnikelo wamabele. Ngale indlela, umphristi uzakwenzela ozahlanjululwa indlela yokubuyisana phambi kukaThixo.” ");
INSERT INTO nde_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Le yiyo imithetho yokuphathwa kwalabo abalomkhuhlane wobulephero abangenelisi iminikelo yokuhlanjululwa ejayelekileyo. ");
INSERT INTO nde_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","UThixo wathi kuMosi lo-Aroni, ");
INSERT INTO nde_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Nxa lingena ezweni laseKhenani, lelo engilinika lona ukuba libe yisabelo senu, besengifaka isikhwekhwe esithelelwanayo endlini kulelolizwe, ");
INSERT INTO nde_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","umnini waleyondlu kufanele ayetshela umphristi athi ‘ngibona okufanana lesikhwekhwe endlini yami?’ ");
INSERT INTO nde_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Umphristi engakayi kuleyondlu ukuyahlola isikhwekhwe kumele akhiphe isiqondiso sokuthi kutshiswe konke okukuleyondlu ukuze kungabi lalutho kuleyondlu oluzathiwa lungcolile. Ngemva kwalokho, umphristi uzangena ahlole leyondlu. ");
INSERT INTO nde_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Uzahlola isikhwekhwe emidulini, kuthi nxa ebona ukuthi kulamabala aluhlaza loba abomvana emdulini njalo ebonakala ejulile emdulini, ");
INSERT INTO nde_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","umphristi uzaphuma ngomnyango wendlu, awuvale okwensuku eziyisikhombisa. ");
INSERT INTO nde_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Ngosuku lwesikhombisa, umphristi uzabuyela ayehlola leyondlu. Nxa isikhwekhwe sesigcwele emidulini, ");
INSERT INTO nde_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","uzakhupha isiqondiso sokuthi amatshe alaleso sikhwekhwe adilizwe, ayephoselwa endaweni engcolileyo ngaphandle kwedolobho. ");
INSERT INTO nde_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Kalaye ukuthi imiduli yonke eyangaphakathi iphalwe, kuthi lokho okuphaliweyo kuyelahlelwa endaweni engcolileyo ngaphandle kwedolobho. ");
INSERT INTO nde_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Besebefaka amatshe amatsha esikhundleni salawo, bagudule indlu ngodaka olutsha. ");
INSERT INTO nde_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Nxa isikhwekhwe sibonakala kutsha kuleyondlu ngemva kokudilizwa kwamatshe lokuphalwa kwemiduli njalo isigudulwe, ");
INSERT INTO nde_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","umphristi kahambe ayeyihlola, nxa efumana isikhwekhwe sesiqhelile kuleyondlu, kuyabe kuyisikhwekhwe esibulalayo; leyondlu ingcolile. ");
INSERT INTO nde_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Kufanele idilizwe, amatshe ayo, izigodo, lodaka lwayo kumele kuyephoselwa endaweni engcolileyo ngaphandle kwedolobho. ");
INSERT INTO nde_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Loba ngubani ongena kuleyondlu ngesikhathi isavaliwe uzakuba ngongcolileyo kuze kube kusihlwa. ");
INSERT INTO nde_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Loba ngubani ozalala loba adlele kuleyondlu kufanele agezise izigqoko zakhe. ");
INSERT INTO nde_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Kodwa umphristi angabuya ezoyihlola afumane ukuthi isikhwekhwe asiqhelanga ngemva kokugudulwa, uzakuthi indlu ihlambulukile, ngoba isikhwekhwe singasekho. ");
INSERT INTO nde_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Ukuze indlu ibe ngehlanzekileyo, uzathatha inyoni ezimbili kanye lenkuni zesihlahla somsedari, lentambo ezelukiweyo ezibomvu lehisophi. ");
INSERT INTO nde_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Uzahlaba enye yalezi zinyoni emanzini acengekileyo embizeni yomdaka. ");
INSERT INTO nde_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Abesethatha inkuni zesihlahla somsedari, ihisophi, intambo ebomvu elukiweyo lenyoni ephilayo, akugxamuze egazini lenye ebuleweyo lamanzi acengekileyo, abesechela leyondlu kasikhombisa. ");
INSERT INTO nde_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Uzayihlanza leyondlu ngegazi lenyoni, amanzi acengekileyo, inyoni ephilayo, inkuni zesihlahla somsedari, ihisophi lentambo ephothiweyo ebomvu. ");
INSERT INTO nde_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Ngemva kwalokho kakhulule inyoni ephilayo emangweni ngaphandle kwedolobho. Ngalindlela uzabe esenze indlela yokubuyisana kuleyondlu, izabe singehlambulukileyo.” ");
INSERT INTO nde_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Le yiyo imithetho eqondane lobulephero, ukuluma komzimba, ");
INSERT INTO nde_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","isikhwekhwe ezigqokweni kumbe endlini, ");
INSERT INTO nde_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ukuvuvuka, ukuqubuka kumbe itshatha elikhanyayo, ");
INSERT INTO nde_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ukuze kubonakale ukuthi ulutho luhlambulukile loba lungcolile. Le yiyo imithetho yobulephero kanye lesikhwekhwe. ");
INSERT INTO nde_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","UThixo wathi kuMosi lo-Aroni, ");
INSERT INTO nde_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Khulumani labako-Israyeli lithi kubo: ‘Nxa indoda iphuma ubovu, ubovu obuphumayo bungcolile. ");
INSERT INTO nde_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Lanxa buthonta emzimbeni wakhe loba buvalekile, bumenza abe ngongcolileyo. Lokhu yikho okwenza ubovu obuphuma emzimbeni wakhe bumenze abe ngongcolileyo: ");
INSERT INTO nde_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Loba yiwuphi umbheda indoda le ephuma ubovu ezalala kuwo, uzakuba ngongcolileyo, njalo loba kuyini okuzahlala phezu kwawo, kuzakuba ngokungcolileyo. ");
INSERT INTO nde_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Loba ngubani othinta umbheda wakhe kufanele agezise izigqoko zakhe, abesegeza ngamanzi, uzakuba ngongcolileyo kuze kube kusihlwa. ");
INSERT INTO nde_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Loba ngubani ozahlala loba kuphezu kwani lapho okuke kwahlala khona indoda ethonta ubovu, kufanele agezise izigqoko zakhe abesegeza ngamanzi, uzakuba ngongcolileyo kuze kube kusihlwa. ");
INSERT INTO nde_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Loba ngubani ozathinta lindoda kufanele agezise izigqoko zakhe abesegeza ngamanzi, ngalokho uzakuba ngongcolileyo kuze kube kusihlwa. ");
INSERT INTO nde_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Nxa indoda ephuma ubovu ingakhafulela omunye ongelabo, lowomuntu kagezise izigqoko zakhe abesegeza ngamanzi, yena uzakuba ngongcolileyo kuze kube kusihlwa. ");
INSERT INTO nde_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Konke indoda le ehlala kukho igadile kuzakuba ngokungcolileyo, ");
INSERT INTO nde_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","njalo loba ngubani ozathinta loba yini yezinto ebezingaphansi kwakhe uzakuba ngongcolileyo kuze kube kusihlwa, loba ngubani ozadobha lezozinto, kufanele agezise izigqoko zakhe, abesegeza ngamanzi, njalo uzabe engongcolileyo kuze kube kusihlwa. ");
INSERT INTO nde_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Loba ngubani ozathintwa yindoda le ephuma ubovu engagezanga izandla zakhe ngamanzi kufanele agezise izigqoko zakhe abesegeza ngamanzi, kodwa uzakuba ngongcolileyo kuze kube kusihlwa. ");
INSERT INTO nde_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Imbiza yomdaka ezathintwa yile indoda kufanele ibulawe, kuthi konke okwenziwe ngesigodo kumele kuhlanjululwe ngamanzi. ");
INSERT INTO nde_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Nxa indoda isihlanjululwe ekuphumeni kwayo ubovu, kayibale insuku eziyisikhombisa kube yikuhlanjululwa kwayo ngokomkhuba; kufanele igezise izigqoko zayo, ibisigeza ngamanzi amahle andubana ihlambuluke. ");
INSERT INTO nde_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Ngosuku lwesificaminwembili kufanele ithathe amajuba amabili, loba amaphuphu enkwilimba amabili ize phambi kukaThixo esangweni lethente lokuhlangana, iwaqhubele umphristi. ");
INSERT INTO nde_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Umphristi uzanikela ngakho; okunye ngokomnikelo wesono, okunye ngokomnikelo wokutshiswa. Ngalokho, uzakwenza ukubuyisana phambi kukaThixo kwaleyondoda ngenxa yomkhuhlane wayo. ");
INSERT INTO nde_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Nxa indoda ivuza ubudoda, kumele igeze umzimba wayo wonke ngamanzi, njalo izakuba ngengcolileyo kuze kube kusihlwa. ");
INSERT INTO nde_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Loba yisiphi isigqoko kumbe isikhumba esilobudoda, kufanele sigeziswe ngamanzi, njalo kuzakuba ngokungcolileyo kuze kube kusihlwa. ");
INSERT INTO nde_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Nxa indoda ingalala lowesifazane ichithe, kufanele ukuthi bobabili bageze ngamanzi, ngakho bazakuba ngabangcolileyo kuze kube kusihlwa. ");
INSERT INTO nde_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Nxa owesifazane esemfuleni njengenjayelo, ukungcola kwakhe okubangelwa yikuba semfuleni kwakhe, kuzathatha insuku eziyisikhombisa, ngakho wonke omthintayo uzakuba ngongcolileyo kuze kube kusihlwa. ");
INSERT INTO nde_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Yonke into owesifazane lo azalala phezu kwayo ngesikhathi esemfuleni izakuba ngengcolileyo, njalo loba kuyini azahlala phezu kwakho, sekungcolile. ");
INSERT INTO nde_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Ozathinta umbheda wakhe kufanele agezise izigqoko zakhe abesegeza umzimba ngamanzi, njalo uzakuba ngongcolileyo kuze kube kusihlwa. ");
INSERT INTO nde_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Loba ngubani ozathinta loba kuyini owesifazane lo abehlezi phezu kwakho kufanele agezise izigqoko zakhe, ageze umzimba ngamanzi, njalo uzakuba ngongcolileyo kuze kube kusihlwa. ");
INSERT INTO nde_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Akukhathalekile ukuba kungaba ngumbheda loba enye into nje owesifazane lo abehlezi kukho, umuntu loba engubani angakuthinta, uzakuba ngongcolileyo kuze kube kusihlwa. ");
INSERT INTO nde_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Nxa indoda ingalala lowesifazane osemfuleni ibe isithinta igazi lomopho wakhe, indoda izakuba ngengcolileyo okwensuku eziyisikhombisa, loba yiwuphi umbheda ezalala kuwo, uzakuba ngongcolileyo. ");
INSERT INTO nde_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Nxa owesifazane angopha okwensuku ezithile zilandelana kodwa engekho emfuleni, loba esopha okwensuku ezedlula insuku zokopha nxa esemfuleni, uzakuba ngongcolileyo nxa ukopha kungakemi, njengasezinsukwini zakhe esemfuleni. ");
INSERT INTO nde_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Loba yiwuphi umbheda azalala kuwo nxa umopho uqhubeka, uzakuba ngongcolileyo, njengokungcola kombheda wakhe ngesikhathi esemfuleni, njalo konke ahlala phezu kwakho kuzakuba ngokungcolileyo, njengokungcola kwakhe nxa esemfuleni. ");
INSERT INTO nde_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Loba ngubani ozathinta lezizinto uzakuba ngongcolileyo; kufanele agezise izigqoko zakhe abesegeza ngamanzi, ngalokho uzakuba ngongcolileyo kuze kube kusihlwa. ");
INSERT INTO nde_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Nxa esehlanzekile ekopheni kwakhe, kufanele ahlale insuku eziyisikhombisa andubana ahlambuluke ngokomkhuba. ");
INSERT INTO nde_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Ngosuku lwesificaminwembili uzathatha amajuba amabili loba amaphuphu enkwilimba amabili akulethe kumphristi esangweni lethente lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Umphristi uzanikela okunye kube ngumnikelo wesono, kuthi okunye kube ngumnikelo wokutshiswa. Ngale indlela uzakwenza ukubuyisana kwakhe phambi kukaThixo ngenxa yokungcola kwakhe esopha. ");
INSERT INTO nde_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Kufanele wahlukanise abako-Israyeli ezintweni ezibangcolisayo, ukuze bangafeli ekungcoleni kwabo, bangcolise indawo engihlala kuyo, ephakathi kwabo.’ ” ");
INSERT INTO nde_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Le yiyo imithetho eqondene lendoda ephuma ubovu, loba ngubani ongcoliswe yikuphuma ubudoda, ");
INSERT INTO nde_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","lowesifazane nxa esemfuleni, lendoda loba owesifazane okuphuma kuye okungcolileyo, njalo lendoda elala lowesifazane ongcolileyo ngokomkhuba. ");
INSERT INTO nde_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","UThixo wakhuluma loMosi ngemva kokufa kwamadodana ka-Aroni azama ukuqondana loThixo. ");
INSERT INTO nde_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","UThixo wathi kuMosi, “Tshela umfowenu u-Aroni ukuthi angamani abuye nje ngokuthanda kwakhe endaweni eNgcwelengcwele, ngemva kwekhetheni, phambi kwesihlalo somusa phezu komtshokotsho funa afe, ngoba ngiyabonakala ngiseyezini phezu kwesihlalo somusa. ");
INSERT INTO nde_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","U-Aroni kuzamele angene endaweni engcwele ngale indlela: Keze lejongosi, kube ngumnikelo wesono, kuthi okomnikelo wokutshiswa, kube yinqama. ");
INSERT INTO nde_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Uzagqoka ibhatshi elingcwele elenziwe ngelembu elicolekileyo, lezigqoko zelineni ezangaphansi; kazibophe ngebhanti elenziwe ngelineni njalo athwale iqhiye yelineni. Lezi yizembatho ezingcwele; ngakho kufanele ageze umzimba ngamanzi andubana agqoke izembatho lezi. ");
INSERT INTO nde_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Kathathe imbuzi ezinduna ezimbili esizweni sako-Israyeli zibe ngumnikelo wesono, lenqama ibe ngumnikelo wokutshiswa. ");
INSERT INTO nde_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","U-Aroni uzanikela ngenkunzi, ibe ngumnikelo wesono sakhe, ukwenzela ukubuyisana kwakhe lokwabendlu yakhe. ");
INSERT INTO nde_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Abesethatha imbuzi zombili azilethe phambi kukaThixo, esangweni lethente lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Uzaphosa inkatho yokubona ngembuzi zombili, eyinye izakuba ngekaThixo, enye ibe ngeyesesulelo. ");
INSERT INTO nde_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","U-Aroni uzaletha imbuzi yenkatho kaThixo ibe ngumnikelo wesono. ");
INSERT INTO nde_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Kodwa imbuzi edliwe yinkatho yesesulelo izalethwa kuThixo iphila ukuze isetshenziswe ukwenza ukubuyisana ngokuyixotshela enkangala, njengembuzi yesesulelo. ");
INSERT INTO nde_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","U-Aroni uzaletha inkunzi ibe ngumnikelo wesono sakhe ukwenzela ukubuyisana kwakhe lokwendlu yakhe, njalo uzayihlaba leyonkunzi ibe ngumnikelo wesono sakhe. ");
INSERT INTO nde_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Uzathatha isiphathelo sokutshisela impepha sigcwele amalahle avuthayo ase-alithareni phambi kukaThixo kanye lempepha ecolekileyo enuka kamnandi egcwala izandla ezimbili, ayelakho ngemva kwekhetheni. ");
INSERT INTO nde_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Uzathela impepha emlilweni phambi kukaThixo, kuthi intuthu yempepha isibekele isihlalo somusa esiphezu kwezibhebhedu zobufakazi ukuze angafi. ");
INSERT INTO nde_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Uzathatha elinye igazi lenkunzi, achele ngalo phambi kwebhokisi lesihlalo somusa esebenzisa umunwe wakhe; ngomunwe wakhe njalo achele kasikhombisa phambi kwesihlalo somusa. ");
INSERT INTO nde_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Ngemva kwalokho, uzabulala imbuzi ibe ngumnikelo wesono sabantu, abesethatha igazi layo aye ngemva kwekhetheni, ayekwenza njengalokhu akwenze ngegazi lenkunzi: Uzachela phezu kwesihlalo somusa laphambili kwaso. ");
INSERT INTO nde_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Ngalokho uzakwenza indlela yokubuyisana, endaweni eNgcwelengcwele ngenxa yokungcola lokuhlamuka kwabako-Israyeli, kungakhathalekile ukuthi benze sono bani. Uzakwenza njalo into efanayo ethenteni lokuhlangana eliphakathi kwabo ngokungcola okuphakathi kwabo. ");
INSERT INTO nde_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Kakho ozangena ethenteni lokuhlangana, kusukela ekungeneni kuka-Aroni esiyakwenza indlela yokubuyisana endaweni eNgcwelengcwele aze aphume, esezenzele indlela yokubuyisana, leyabendlu yakhe kanye lesizwe sonke sako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Ngakho uzakuza e-alithareni eliphambi kukaThixo, alenzele indlela yokubuyisana. Uzathatha elinye igazi lenkunzi lelinye elembuzi, aninde ngalo impondo zonke ze-alithare. ");
INSERT INTO nde_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Uzachela elinye igazi ngomunwe wakhe kasikhombisa ukulihlanza lokulingcwelisa kulokhu kungcola kwabako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Nxa u-Aroni eseqedile ukwenzela indlela yokubuyisana indawo eNgcwelengcwele, ithente lokuhlangana kanye le-alithari, uzaletha imbuzi ephilayo. ");
INSERT INTO nde_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Uzabeka izandla zakhe zombili ekhanda lembuzi ephilayo, avumele phezu kwayo ukona lokuhlamuka kwabako-Israyeli, izono zabo zonke azifake ekhanda lembuzi. Imbuzi le izaxotshelwa enkangala iqhutshwa yindoda ekhethelwe lowomsebenzi. ");
INSERT INTO nde_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Imbuzi izathwala zonke izono zabo, ithubele lazo; indoda izayixotshela enkangala. ");
INSERT INTO nde_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Ngakho u-Aroni uzangena ethenteni lokuhlangana, akhulule izigqoko zelineni abezigqoke engakangeni endaweni eNgcwelengcwele, azitshiye khonapho. ");
INSERT INTO nde_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Uzageza umzimba ngamanzi endaweni engcwele, abesegqoka izigqoko zakhe. Ngemva kwalokho uzaphuma lapho ayezinikelela umnikelo wokutshiswa kanye lokunikelela abantu umnikelo wokutshiswa, esenzela ukubuyisana kwakhe lokwabantu. ");
INSERT INTO nde_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Njalo uzatshisa amahwahwa omnikelo wesono e-alithareni. ");
INSERT INTO nde_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Indoda ezaxotshela imbuzi eyisesulelo kumele ihlambe izigqoko zayo lomzimba ngamanzi; ngemva kwalokho isingangena ezihonqweni. ");
INSERT INTO nde_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Inkunzi kanye lembuzi yomnikelo wesono, okulegazi elilethwe endaweni eNgcwelengcwele ukwenzela ukubuyisana, kakukhitshelwe ngaphandle kwezihonqo; kutshiswe izikhumba zakho, inyama kanye lezangaphakathi. ");
INSERT INTO nde_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Indoda ezatshisa lokhu kayigezise izigqoko zayo njalo igeze lomzimba wayo ngamanzi; ngemva kwalokho isingangena ezihonqweni. ");
INSERT INTO nde_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Lokhu kakube yisimiso kini esingapheliyo: Ngosuku lwetshumi ngenyanga yesikhombisa, lizidele, lingabambi umsebenzi, loba lingabanikazi bendawo loba kungabezizwe phakathi kwenu, ");
INSERT INTO nde_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","ngenxa yokuthi ngalolusuku lizakwenzelwa ukubuyisana, ukulihlambulula. Ngakho, phambi kukaThixo, lizabe selihlanzekile ezonweni zenu zonke. ");
INSERT INTO nde_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","KuliSabatha lokuphumula, ngakho kumele lizidele, kuyisimiso esingapheliyo. ");
INSERT INTO nde_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Umphristi ogcotshiweyo, wabekwa ukuthatha isikhundla sikayise ukuba ngumphristi omkhulu uzakwenza indlela yokubuyisana. Uzagqoka izigqoko ezingcwele zelineni, ");
INSERT INTO nde_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","enze ukubuyisana kwendawo eNgcwelengcwele, lokwethente lokuhlangana lokwe-alithari, lokwabaphristi kanye labantu bonke bakuleyondawo. ");
INSERT INTO nde_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Lokhu kuzakuba yisimiso esingapheliyo kini: Ukubuyisana kakwenziwe kanye ngomnyaka, kusenzelwa zonke izono zabako-Israyeli.” Lokhu kwenziwa, njengokulaywa kukaMosi nguThixo. ");
INSERT INTO nde_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Tshela u-Aroni lamadodana akhe, labo bonke abako-Israyeli ukuthi: ‘Nanku okutshiwo nguThixo: ");
INSERT INTO nde_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Loba ngubani owako-Israyeli ozakwenza umhlatshelo ngenkabi, izinyane lemvu loba imbuzi ezihonqweni loba ngaphandle kwazo, ");
INSERT INTO nde_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","esikhundleni sokuyiletha esangweni lethente lokuhlangana, ukuyinikela ukuthi ibe ngumnikelo kuThixo phambi kwethabanikeli likaThixo, lowomuntu uzakuba lecala lokuchitha igazi; usechithe igazi ngakho kumele axotshwe ebantwini bakibo. ");
INSERT INTO nde_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Lokhu kuzakwenza abako-Israyeli balethe kuThixo imihlatshelo le abayenzela egangeni. Kabayilethe kumphristi, lokhu kuyikuthi, kuThixo, esangweni lethente lokuhlangana njalo banikele njengeminikelo yobudlelwano. ");
INSERT INTO nde_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Umphristi kachele i-alithari likaThixo ngegazi esangweni lethente lokuhlangana, atshise amahwahwa njengephunga elimnandi kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Bangabe besanikela loba yiwuphi umnikelo kubonkulunkulu babo bembuzi labo ababaxhwalisayo. Lesi kumele kube yisimiso sabo esingapheliyo lakuzizukulwane ezizayo.’ ");
INSERT INTO nde_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Wothi kubo: ‘Loba nguphi owako-Israyeli loba owezizwe ohlezi labo onikela umnikelo wokutshiswa loba umhlatshelo, ");
INSERT INTO nde_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","kodwa engawulethi esangweni lethente lokuhlangana ukuba akuhlabele uThixo, lowomuntu kaxotshwe ebantwini bakibo. ");
INSERT INTO nde_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Loba ngubani owako-Israyeli loba owezizwe ohlala phakathi kwabo ozakudla loba yiliphi igazi, ngizamelana laye odla igazi, ngimxotshe phakathi kwabantu bakibo. ");
INSERT INTO nde_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Ngoba impilo yesidalwa isegazini, njalo ngiliphile ukuthi lenze ukubuyisana kwenu e-alithareni ngalo; kuligazi elenze ukubuyisana empilweni yomuntu. ");
INSERT INTO nde_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Ngakho ngithi kwabako-Israyeli, “Kakho phakathi kwenu ozakudla igazi, loba owezizwe ohlala phakathi kwenu ozakudla igazi.” ");
INSERT INTO nde_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Loba ngubani owako-Israyeli loba owezizwe ohlala phakathi kwenu ozingela loba yiphi inyamazana loba inyoni edliwayo, kavuzise igazi aligqibele ngenhlabathi, ");
INSERT INTO nde_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","ngoba impilo yesidalwa isegazini laso. Yikho ngithe kwabako-Israyeli, “Lingabokudla igazi laloba yisiphi isidalwa, ngoba impilo yesidalwa sonke ligazi laso; loba ngubani olidlayo kaxotshwe.” ");
INSERT INTO nde_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Loba ngubani, kungaba ngumnikazi wendawo loba owezizwe, ozakudla loba kuyini okufunyanwe kufile, loba okubulewe yizinyamazana zeganga, kahlambe izigqoko zakhe kanye lomzimba wakhe ngamanzi, uzakuba ngongcolileyo ngokomkhuba kuze kuhlwe; uzakuba esehlambulukile. ");
INSERT INTO nde_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Kodwa nxa engahlambi izigqoko zakhe lokugeza umzimba wakhe, uzakuba lecala.’ ” ");
INSERT INTO nde_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Tshela abako-Israyeli ukuthi: ‘NginguThixo uNkulunkulu wenu. ");
INSERT INTO nde_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Lingabokwenza lokhu okwenziwa eGibhithe, lapho elalikhona, njalo lingabokwenza abakwenzayo ezweni laseKhenani, lapho engilisa khona. Lingalandeli abakwenzayo. ");
INSERT INTO nde_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Lalelani imithetho yami njalo linanzelele, lilandele izimiso zami. Mina nginguThixo uNkulunkulu wenu. ");
INSERT INTO nde_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Gcinani izimiso zami lemithetho yami, ngoba umuntu oyilalelayo uzaphila ngayo. Mina nginguThixo. ");
INSERT INTO nde_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Akungabi lamuntu osondela esihlotsheni sakhe esiseduze ukuthi alale laso. Mina nginguThixo. ");
INSERT INTO nde_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Ungatheleli uyihlo ihlazo ngokulala lonyoko. Ngunyoko; ungalali laye. ");
INSERT INTO nde_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Ungalali lomfazi kayihlo; lokho kuthelela uyihlo ihlazo. ");
INSERT INTO nde_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Ungalali lodadewenu, loba indodakazi kayihlo loba indodakazi kanyoko, kungakhathalekile ukuthi wazalelwa ekhaya loba kwenye indawo. ");
INSERT INTO nde_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Ungalali lendodakazi yendodana yakho loba indodakazi yendodakazi yakho; lokhu kuzakuthelela ihlazo. ");
INSERT INTO nde_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Ungalali lendodakazi yomfazi kayihlo, eyazalwa nguyihlo, ingudadewenu. ");
INSERT INTO nde_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Ungalali lodadewabo kayihlo; uyisihlobo sikayihlo esiseduze kakhulu. ");
INSERT INTO nde_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Ungalali lodadewabo kanyoko, uyisihlobo sikanyoko esiseduzane kakhulu. ");
INSERT INTO nde_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Ungatheleli umfowabo kayihlo ihlazo ngokusondela kumkakhe ukuthi ulale laye, ngoba ungunyoko. ");
INSERT INTO nde_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Ungalali lomalokazana wakho, ngumfazi wendodana yakho; ungalali laye. ");
INSERT INTO nde_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Ungalali lomfazi womfowenu; kuzathelela umfowenu ihlazo. ");
INSERT INTO nde_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Ungalali lowesifazane kanye lendodakazi yakhe. Ungalali lendodakazi yendodana yakhe loba indodakazi yendodakazi yakhe; bayizihlobo zakho eziseduzane. Lokhu kuyikuxhwala. ");
INSERT INTO nde_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Ungathathi udadewabo womkakho ukuthi ulale laye nxa umkakho esaphila. ");
INSERT INTO nde_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Ungasondeli kowesifazane ukuthi ulale laye ngesikhathi esemfuleni ngoba ungcolile. ");
INSERT INTO nde_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Ungalali lomfazi kamakhelwane wakho ngoba uyazingcolisa ngaye. ");
INSERT INTO nde_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Unganikeli loba nguphi wabantwabakho ukuthi abe ngumhlatshelo kunkulunkulu uMoleki, ngoba akufanelanga ukuthi ungcolise ibizo likaNkulunkulu wakho. Mina nginguThixo. ");
INSERT INTO nde_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Ungalali lendoda njengendoda ilala lomfazi; lokhu kuyisinengiso. ");
INSERT INTO nde_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Ungafebi lenyamazana, ngoba uyazingcolisa ngalokho. Owesifazane angafebi lenyamazana, lokhu kuyisinengiso. ");
INSERT INTO nde_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Lingazingcolisi noma kungayiphi yalezizindlela, ngoba yizo izindlela izizwe engizazidudula phambi kwenu ezazingcolisa ngazo. ");
INSERT INTO nde_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Kwaze kwangcola lelizwe; kungakho ngalijezisa ngesono salo, ilizwe ababehlala kulo labakhafula. ");
INSERT INTO nde_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Kodwa kumele ligcine izimiso zami lemilayo yami. Lina banikazi belizwe labezizwe abaphakathi kwenu, akufanelanga benze lezizinto ezenyanyekayo, ");
INSERT INTO nde_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","ngoba zonke lezizinto zenziwa ngabantu ababehlala kulelilizwe lina lingakafiki, ngakho ilizwe langcola. ");
INSERT INTO nde_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Nxa lingenza amanyala kulelilizwe, lizalikhafula njengendlela elakhafula ngayo izizwe ezalandulelayo. ");
INSERT INTO nde_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Loba ngubani owenza lezizinto ezenyanyekayo, kumele axotshwe ebantwini bakibo. ");
INSERT INTO nde_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Gcinani iziqondiso zami, lingalandeli izindlela zamanyala lemikhuba eyayilandelwa ngabantu abalandulelayo, njalo lingazingcolisi ngayo. Mina nginguThixo uNkulunkulu wenu.’ ” ");
INSERT INTO nde_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Tshela lonke ibandla lako-Israyeli uthi kulo: ‘Wobani ngcwele ngoba mina Thixo uNkulunkulu wenu ngingcwele. ");
INSERT INTO nde_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Ngulowo lalowo kini kahloniphe unina loyise, njalo kumele ligcine amaSabatha ami. Mina nginguThixo uNkulunkulu wenu. ");
INSERT INTO nde_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Lingaphendukeli ezithombeni loba lizibumbele onkulunkulu benu. NginguThixo uNkulunkulu wenu. ");
INSERT INTO nde_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Nxa lisenza umhlatshelo womnikelo wobudlelwano kuThixo, wenzeni ngendlela ezakwenza wamukeleke ukusiza lina. ");
INSERT INTO nde_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Kumele udliwe ngalo ilanga lomhlatshelo loba ngelanga lakusasa; lokho okuseleyo kuze kube lilanga lesithathu kumele kutshiswe. ");
INSERT INTO nde_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Lokho okudliwa ngelanga lesithathu kuzabe sekungcolile, kungabe kusemukeleka. ");
INSERT INTO nde_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Lowo okudlayo uzakuba lomlandu, ngoba uzabe esengcolise lokho okungcwele kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Lapho libutha isivuno samasimu enu, lingabuthi konke kuze kube semaphethelweni ensimu kumbe lize liqede konke. ");
INSERT INTO nde_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Lingakhi izithelo ezivinini zenu kabili kumbe lidobhe ezikhithikileyo. Zitshiyeleni abayanga lezihambi. Mina nginguThixo uNkulunkulu wenu. ");
INSERT INTO nde_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Lingebi. Lingaqambi amanga. Lingakhohlisani. ");
INSERT INTO nde_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Lingafungi amanga ngebizo lami, beselingcolisa ibizo likaNkulunkulu wenu. NginguThixo. ");
INSERT INTO nde_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Lingaqilibezeli umakhelwane wenu, lingamkhuthuzi. Umuntu oqhatshiweyo lingambambeli iholo lakhe kuze kube kusasa. ");
INSERT INTO nde_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Lingathuki isacuthe loba liphosele isikhubekiso phambi kwesiphofu, kodwa yesabani uNkulunkulu wenu. NginguThixo. ");
INSERT INTO nde_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Lingawutshili umthetho; lingabandlululi umyanga kumbe litshengise ukukhetha abakhulu, kodwa mahluleleni ngokulunga umakhelwane wenu. ");
INSERT INTO nde_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Lingahambi linyeya kwabakini. Ungenzi lutho olulimaza umakhelwane wakho. NginguThixo. ");
INSERT INTO nde_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Lingamzondi umfowenu ngezinhliziyo zenu. Khuzani umakhelwane likhululekile ukuze lingabi lomlandu njengaye. ");
INSERT INTO nde_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Lingaphindiseli loba libambe isikhwili komunye wabantu bakini, kodwa thandani omakhelwane benu njengalokhu lizithanda lina. NginguThixo. ");
INSERT INTO nde_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Gcinani izimemezelo zami. Lingenzi izifuyo zenu zikhwele ezolunye uhlobo. Lingahlanyeli insimu yinye ngemihlobo emibili yenhlanyelo etshiyeneyo. Lingavunuli izigqoko ezenziwe ngemihlobo yamalembu amabili atshiyeneyo. ");
INSERT INTO nde_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Nxa indoda ingalala lowesifazane oyisigqili osethembise enye indoda kodwa ongakahlengwa loba waphiwa inkululeko, kayijeziswe leyondoda. Kodwa akumelanga babulawe ngoba owesifazane lowo kakakhululwa. ");
INSERT INTO nde_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Kodwa indoda kumele ilethe inqama esangweni lethente lokuhlangana, ibe ngumnikelo wecala kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Ngaleyonqama yomnikelo wecala, umphristi kamenzele indlela yokubuyisana kuThixo ngenxa yesono esenzileyo. Isono sayo sizathethelelwa. ");
INSERT INTO nde_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Nxa selingenile elizweni, lahlanyela zonke izihlahla ezidliwayo, lingadli izithelo zazo ngoba kuyazila. Ziyazila okweminyaka emithathu; kazingadliwa. ");
INSERT INTO nde_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Ngomnyaka wesine, zonke izithelo zazo zizabangcwele, zibe ngumnikelo wokudumisa uThixo. ");
INSERT INTO nde_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Kodwa ngomnyaka wesihlanu lidle izithelo zazo. Ngaleyondlela, isivuno senu sizakwandiswa. Mina yimi uThixo uNkulunkulu wenu. ");
INSERT INTO nde_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Lingadli inyama elegazi. Lingenzi izinto zokuvumisa loba ubungoma. ");
INSERT INTO nde_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Lingagundi inwele emaceleni amakhanda enu njalo lingageli indevu zenu. ");
INSERT INTO nde_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Lingazisiki imizimba yenu ngenxa yabafileyo kumbe lizicabe. Mina yimi uThixo. ");
INSERT INTO nde_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Lingalulazisi amadodakazi enu ngokuwafebisa funa ilizwe lehlelwe yibubi bokuphinga. ");
INSERT INTO nde_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Gcinani amaSabatha ami, lihloniphe indlu yami engcwele. Mina nginguThixo. ");
INSERT INTO nde_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Lingayi kwabayizangoma loba lidinge izanuse ngoba zizalingcolisa. Mina yimi uThixo uNkulunkulu wenu. ");
INSERT INTO nde_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Sukumelani asebeluphele, lihloniphe abantu abadala, limesabe uNkulunkulu wenu. Mina yimi uThixo. ");
INSERT INTO nde_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Nxa owezizweni ehlala lani elizweni lenu, lingamhlukuluzi. ");
INSERT INTO nde_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Owezizweni ohlala phakathi kwenu kumele laye aphathwe njengowakini. Limthande njengoba lizithanda lina, ngoba lalingabezizweni eGibhithe. Mina yimi uThixo uNkulunkulu wenu. ");
INSERT INTO nde_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Lingasebenzisi izilinganiso zokuqilibezela nxa lilinganisa ubude, isisindo loba umthamo. ");
INSERT INTO nde_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Sebenzisani izilinganiso eziqotho, ihefa eliqondileyo lehini eliqotho. Mina yimi uThixo uNkulunkulu wenu owalikhupha eGibhithe. ");
INSERT INTO nde_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Gcinani zonke izimemezelo zami, layo yonke imithetho yami, liyilandele. Mina yimi uThixo.’ ” ");
INSERT INTO nde_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Tshela abako-Israyeli uthi: ‘Loba ngubani kwabako-Israyeli kumbe owezizweni ohlala kini onikela abantwana bakhe kunkulunkulu uMoleki, kumele abulawe. Izakhamizi kazimkhande ngamatshe. ");
INSERT INTO nde_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Mina ngizamdela lowomuntu, ngimkhuphe ebantwini bakibo; ngoba nxa enikele ngabantwabakhe kuMoleki, usengcolise indlu yami engcwele, wahlambaza lebizo lami elingcwele. ");
INSERT INTO nde_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Nxa izakhamizi zendawo zingangamnanzi lowomuntu enikela umntanakhe kuMoleki zingambulali, ");
INSERT INTO nde_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","mina ngizamhlamukela lowomuntu labomuzi wakhe, ngibakhuphe ebantwini bakibo, yena kanye labo bonke abahlanganyela laye njengeziphingi kuMoleki. ");
INSERT INTO nde_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Ngizamhlamukela lowo oya ezangomeni lezanuseni njengesiphingi sazo, ngokulandelana lazo. Ngizamkhupha kwabakibo. ");
INSERT INTO nde_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Zingcweliseni libengcwele ngoba mina nginguThixo uNkulunkulu wenu. ");
INSERT INTO nde_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Gcinani izimiso zami lizilandele. Mina nginguThixo olenza libengcwele. ");
INSERT INTO nde_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Lowo othuka uyise loba unina kabulawe. Usethuke uyise loba unina ngakho usefanele ukufa. ");
INSERT INTO nde_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Nxa indoda ifeba lomfazi womunye, umfazi kamakhelwane, kababulawe bobabili isiphingi lesiphingikazi leso. ");
INSERT INTO nde_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Nxa indoda ilala lomfazi kayise, isiyembule ubunqunu bukayise. Leyondoda lonina lowo kababulawe. Bafanele ukufa. ");
INSERT INTO nde_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Nxa indoda ilala lomalokazana wayo, kababulawe bobabili. Lokho asebekwenzile kulihlazo. Bafanele ukufa. ");
INSERT INTO nde_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Nxa indoda ilala lenye indoda ingathi ilala lomfazi, bobabili benze amanyala. Kababulawe. Bafanele ukufa. ");
INSERT INTO nde_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Nxa indoda ithatha umfazi, ithathe lonina, kubi lokho. Yona indoda labesifazane labo kabatshiswe ngomlilo ukuze kungabi lokuxhwala phakathi kwenu. ");
INSERT INTO nde_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Nxa indoda iphinga lesifuyo, kayibulawe, lesifuyo leso sibulawe. ");
INSERT INTO nde_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Nxa owesifazane ehahabela isifuyo aphinge laso, mbulaleni owesifazane lowo kanye lesifuyo leso sibulawe. Kumele kubulawe kokubili ngoba konke kulomlandu. ");
INSERT INTO nde_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Nxa indoda ithatha udadewabo, indodakazi kayise loba ekanina balale bonke, kulihlazo. Kabaxotshwe kwabakibo. Isinqunule udadewabo ngakho isibelomlandu. ");
INSERT INTO nde_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Nxa indoda ilala lowesifazane esemfuleni, isinqunule umthombo walowomfula, lowesifazane lowo usewembulile. Bobabili kabaxotshwe ebantwini bakibo. ");
INSERT INTO nde_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Ungalali lodadewabo kanyoko loba okayihlo, ngoba kuyikunqunula isihlobo segazi. Lobabili lizakuba lomlandu. ");
INSERT INTO nde_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Nxa umuntu elala lomkamfowabo kayise, usenqunule umfowabo kayise. Balomlandu. Bazakufa bengelamntwana. ");
INSERT INTO nde_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Nxa indoda ithatha umfazi womfowabo, lokho kuyisenzo sokungcola; usembule ubunqunu bomfowabo. Bazakufa bengelamntwana. ");
INSERT INTO nde_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Gcinani zonke izimiso zami lemithetho yami, liyilandele ukuze lelolizwe engililethe ukuba lihlale khona lingalikhafuli. ");
INSERT INTO nde_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Lingabolandela amasiko ezizwe engizazixotsha phambi kwenu. Ngoba bazenza zonke lezizinto ngabenyanya. ");
INSERT INTO nde_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Kodwa ngathi kini, “Lizalithumba ilizwe labo; ngizalipha lona libe yilifa lenu, ilizwe eligeleza uchago loluju.” Mina yimi uThixo uNkulunkulu wenu olenze lehluka kwabezizwe. ");
INSERT INTO nde_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Ngakho-ke kumele lazi umahluko phakathi kwezinyamazana ezihlanzekileyo lezingahlanzekanga; kanjalo lezinyoni. Lingazingcolisi ngezinyamazana loba ngezinyoni loba ngani ehuquzela phansi, lezo engiziphawule ngathi zingcolile kini. ");
INSERT INTO nde_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Kumele libengcwele kimi ngoba mina Thixo ngingcwele njalo ngilahlukanisile kwabezizwe ukuthi libe ngabami. ");
INSERT INTO nde_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Indoda loba umfazi ovumisayo loba oyisanuse phakathi kwenu, kabulawe. Bakhandeni ngamatshe. Yindaba yabo.’ ” ");
INSERT INTO nde_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","UThixo wathi kuMosi, “Khuluma labaphristi, amadodana ka-Aroni, ubatshele ukuthi: ‘Umphristi kakumelanga azingcolise ngokomlayo, ngokungcwaba loba ngubani wakibo ofileyo, ");
INSERT INTO nde_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","ngaphandle kwesihlobo esiseduze njengonina, uyise, indodana loba indodakazi yakhe, umfowabo ");
INSERT INTO nde_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","loba udadewabo osegumeni ngoba engelandoda, labo angabangcwaba. ");
INSERT INTO nde_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Kangazingcolisi ngenxa yezihlobo zomkakhe, azibhixe ngokungcwabana lazo. ");
INSERT INTO nde_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Abaphristi kabangaphuci amakhanda abo, loba bagunde amacele endevu zabo, loba bazicabe emzimbeni. ");
INSERT INTO nde_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Kumele babengcwele kuNkulunkulu wabo, njalo kakumelanga bangcolise ibizo likaNkulunkulu wabo. Kababe ngcwele ngoba yibo abanikela imihlatshelo yokudla kuThixo, ukudla kukaNkulunkulu wabo, kumele babengcwele. ");
INSERT INTO nde_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Kabangathathi abafazi abangcolileyo ngenxa yobufebe, loba abehlukana lamadoda abo ngoba abaphristi bangcwele kuNkulunkulu. ");
INSERT INTO nde_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Bathatheni njengabantu abangcwele ngoba banikela ngokudla kukaNkulunkulu wenu. Bathatheni njengabantu abangcwele ngoba mina Thixo olingcwelisayo ngingcwele. ");
INSERT INTO nde_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Nxa indodakazi yomphristi izingcolisa ngokuba yisifebe, iyangisa uyise; kayitshiswe ngomlilo. ");
INSERT INTO nde_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Umphristi omkhulu kubafowabo, onguye othelwe amafutha okugcoba umphristi ekhanda, abekiweyo ukuthi agqoke izivunulo zobuphristi, kakumelanga ekele inwele zakhe zingakanywanga loba adabule izigqoko zakhe ngenxa yosizi. ");
INSERT INTO nde_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Kakumelanga angene lapho okulesidumbu khona. Kangazingcolisi ngaleyondlela loba kufe uyise kumbe unina, ");
INSERT INTO nde_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","njalo kangasuki endlini kaNkulunkulu kumbe ayingcolise, ngoba usekhethiwe ngokugcotshwa ngamafutha kaNkulunkulu wakhe. Mina nginguThixo. ");
INSERT INTO nde_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Umfazi amthathayo kabe yintombi egcweleyo. ");
INSERT INTO nde_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Kangathathi umfelokazi, owehlukene lomkakhe loba umfazi ongcoliswe yibufebe, kodwa athathe kuphela intombi egcweleyo ebantwini bakibo, ");
INSERT INTO nde_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","angangcolisi inzalo yakhe phakathi kwabantu bakibo. Mina nginguThixo engimenza abengcwele.’ ” ");
INSERT INTO nde_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Tshela u-Aroni uthi: ‘kakho owenzalo yakhe kuzozonke izizukulwane ezizayo nxa elesici esithile ongasondela anikele ukudla kukaNkulunkulu wakhe. ");
INSERT INTO nde_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Akulamuntu olobulima obuthile ongasondela: umuntu oyisiphofu, longumqhuge, logogekileyo loba olezitho ezingaphelelanga; ");
INSERT INTO nde_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","akulamuntu olobulima enyaweni loba esandleni, ");
INSERT INTO nde_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","kumbe odundubele emahlombe, loba ongumuthwa, kumbe elobulima bamehlo, loba olentembuzane, kumbe izilonda eziphihlikayo, loba olimele emaphambilini. ");
INSERT INTO nde_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Akungabikhona owenzalo ka-Aroni umphristi othi nxa elobulima asondele ukuzanikela umnikelo wokudla kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Angadla ukudla okungcwelengcwele kukaNkulunkulu wakhe loba yikudla bani okungcwele; ");
INSERT INTO nde_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","kodwa ngenxa yobulima bakhe kakumelanga asondele eduze kwekhetheni, kumbe aye e-alithareni, ngoba ngaleyondlela angangcolisa indlu yami engcwele. Mina nginguThixo obenza babengcwele.’ ” ");
INSERT INTO nde_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Konke lokhu uMosi wakutshela u-Aroni lamadodana akhe, labo bonke abako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Tshela u-Aroni lamadodana akhe bahloniphe iminikelo abako-Israyeli abayinikela kimi ukuze bangadumazi ibizo lami elingcwele. Mina nginguThixo. ");
INSERT INTO nde_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Batshele ukuthi, ‘Kuzozonke izizukulwane ezizayo, nxa ekhona ozabe engahlanzekanga ngokomkhuba kodwa ajinge asondele eminikelweni engcwele, abako-Israyeli abayihlukanisela uThixo, lowomuntu kasuswe ebusweni bami. Mina nginguThixo. ");
INSERT INTO nde_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Nxa owenzalo ka-Aroni elobulephero kumbe ephihlika ubovu emzimbeni, kangadli iminikelo engcwele aze aqale ahlambuluke. Uzabe esengcolile njalo angabamba okungcoliswe yisidumbu loba athintane lomuntu ovuza ubudoda, ");
INSERT INTO nde_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","loba athinte iloba yini enwabuzelayo emenza angcole, loba kungumuntu omenza angcole, kungakhathalekile ukuthi yikungcola bani. ");
INSERT INTO nde_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Lowo othinta loba yikuphi kwalezi izinto uzabe esengcolile kuze kube kusihlwa. Kangadli loba yini eyeminikelo engcwele, ngaphandle kokuba eseqale wageza ngamanzi. ");
INSERT INTO nde_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Ilanga lingatshona uzabe esehlanzekile, lapho-ke usengadla iminikelo engcwele ngoba iyikudla kwakhe. ");
INSERT INTO nde_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Kangadli lutho oluzifeleyo, loba olubulewe ngezinye izinyamazana zeganga, ngoba lokho kungamngcolisa. Mina nginguThixo. ");
INSERT INTO nde_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Abaphristi kabagcine izimiso zami ukuze bangabi lecala bafe ngenxa yokuzeyisa. Mina nginguThixo obenza babengcwele. ");
INSERT INTO nde_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Akulamuntu ongasuwendlu yomphristi ovunyelwa ukudla umnikelo ongcwele, loba isethekeli somphristi kumbe isisebenzi esiqhatshiweyo; bonke bangawudli. ");
INSERT INTO nde_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Kodwa nxa umphristi ethenga isigqili ngemali, loba isigqili singesizelwe emzini wakhe, lesosigqili singakudla ukudla kwakhe. ");
INSERT INTO nde_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Nxa indodakazi yomphristi ithathwa yindoda engasumphristi, kayingadli loba yisiphi isipho esingcwele. ");
INSERT INTO nde_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Kodwa nxa indodakazi yomphristi isiba ngumfelokazi loba ixotshwe ekwendeni ingelamntwana, ibisibuya izohlala ngakibo njengasebutsheni bayo, ingakudla ukudla kukayise; kodwa ongafanelanga kangakudli. ");
INSERT INTO nde_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Nxa umuntu engadla umnikelo ongcwele ngokungazi kumele ahlawule kumphristi, abuye engeze ingxenye yesihlanu yalokho kudla. ");
INSERT INTO nde_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Umphristi kangangcolisi iminikelo engcwele elethwa ngabako-Israyeli kuThixo ");
INSERT INTO nde_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ngokubavumela ukuthi bayidle iminikelo leyo, besebesiba lecala okumele balihlawule. Mina nginguThixo obenza babengcwele.’ ” ");
INSERT INTO nde_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Tshela u-Aroni lamadodana akhe labo bonke abako-Israyeli uthi loba ngubani kubo, owako-Israyeli loba owezizweni ohlala ko-Israyeli, oletha isipho somhlatshelo kuThixo egcwalisa isifungo loba umnikelo wokuzithandela, ");
INSERT INTO nde_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","kalethe isifuyo esiduna esingelasici, esingaba yinkomo, imvu kumbe imbuzi ukuze yamukeleke ukumela. ");
INSERT INTO nde_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Lingalethi lutho olulesici ngoba kaluyikwamukelwa ukulimela. ");
INSERT INTO nde_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Nxa omunye ekhetha emhlambini wakhe umnikelo wobudlelwano ewuletha kuThixo ukugcwalisa isifungo esithile kumbe umnikelo wokuzithandela, lesosifuyo asingabi lasici, loba indawo esolekayo kuso ukwenzela ukuthi samukeleke. ");
INSERT INTO nde_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Linganikeli ngezifuyo eziyiziphofu, ezilimeleyo, leziyizilima, loba ezilensumpa kumbe izilonda eziphihlikayo. Lezi lingazibeki phezu kwe-alithari ukuba ngumnikelo wokutshiswa kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Kodwa umnikelo wokuzithandela ungaba yinkomo kumbe imvu eyisilima loba engakhulanga yaphelela, kodwa ingeke yamukeleke ukugcwalisa isifungo. ");
INSERT INTO nde_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Linganikeli kuThixo isifuyo esathenwa ngokuxhokolwa, ngokugxotshwa loba ngokudatshulwa amaphambili. Lingakwenzi lokho elizweni lakini, ");
INSERT INTO nde_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","njalo lingazemukeli izifuyo ezinjalo kwabezizweni, beselinikela ngazo zibe yikudla kukaNkulunkulu wenu. Aziyi kwamukeleka ukulimela ngoba zigogekile, zilezici.” ");
INSERT INTO nde_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Ithole elizelweyo loba izinyane lemvu, kumbe elembuzi kalihlale kunina insuku eziyisikhombisa. Kusukela osukwini lwesificaminwembili selisamukeleka ukuba ngumnikelo wokutshiswa kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Inkomokazi loba imvukazi ayingahlatshwa langa linye lomntanayo. ");
INSERT INTO nde_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Nxa linikela umhlatshelo wokubonga kuThixo, wunikeleni ngendlela eyamukelekayo ukulimela. ");
INSERT INTO nde_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Kayidliwe mhlalokho, lingatshiyi lutho lwayo kuze kuse kusasa. Mina nginguThixo. ");
INSERT INTO nde_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Gcinani imilayo yami liyilandele. Mina nginguThixo. ");
INSERT INTO nde_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Lingangcolisi ibizo lami elingcwele. Abako-Israyeli kabangazi ngokuthi ngingcwele. Mina nginguThixo olenza libengcwele, ");
INSERT INTO nde_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","yena owalikhupha eGibhithe ukuba abe nguNkulunkulu wenu. Mina nginguThixo.” ");
INSERT INTO nde_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Khuluma labako-Israyeli uthi kubo: ‘Le yimikhosi yami emisiweyo, imikhosi emisiweyo kaThixo okumele liyimemezele ukuba yimihlangano engcwele.’ ” ");
INSERT INTO nde_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘Kulensuku eziyisithupha elingasebenza ngazo, kodwa usuku lwesikhombisa liSabatha lokuphumula, usuku lomhlangano ongcwele. Lingenzi loba yiwuphi umsebenzi; kuzozonke izindawo elihlala kuzo, luliSabatha likaThixo.’ ” ");
INSERT INTO nde_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘Le yiyo imikhosi kaThixo emisiweyo, imihlangano engcwele elizayimemezela ngezikhathi zayo ezimisiweyo: ");
INSERT INTO nde_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","IPhasika likaThixo liqalisa kusihlwa ngosuku lwetshumi lane lwenyanga yakuqala. ");
INSERT INTO nde_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Ngosuku lwetshumi lanhlanu lwaleyonyanga kuqaliswa uMkhosi kaThixo weSinkwa esingelaMvubelo; okwensuku eziyisikhombisa kumele lidle isinkwa esingelamvubelo. ");
INSERT INTO nde_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Ngosuku lwakuqala lenze umbuthano ongcwele njalo lingenzi imisebenzi yenu yansuku zonke. ");
INSERT INTO nde_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Okwensuku eziyisikhombisa nikelani umnikelo wokutshiswa kuThixo. Kuthi ngosuku lwesikhombisa libe lenkonzo engcwele, lingenzi imisebenzi yenu yansuku zonke.’ ” ");
INSERT INTO nde_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Tshela abako-Israyeli uthi, ‘Nxa selingene elizweni engizalinika lona kalibokuthi lingavuna lilethe kumphristi ilixha lesivuno samabele akuqala. ");
INSERT INTO nde_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Kumele azunguze ilixha lelo kuThixo ukuze lamukeleke. Umphristi kufanele alizunguze ngelanga elilandela iSabatha. ");
INSERT INTO nde_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Ngelanga lokuzunguza ilixha kumele enze umhlatshelo ube ngumnikelo wokutshiswa kuThixo, kube lizinyane lemvu eliduna eselilomnyaka, libe ngelingelasici, ");
INSERT INTO nde_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","awunikele ndawonye lomnikelo wamabele oyingxenye yehefa ngokubili etshumini, kube yifulawa ecolekileyo evutshwe ngamafutha. Lo ngumhlatshelo wokudla onikelwa kuThixo olephunga elimnandi. Kawenziwe njalo lomnikelo wokunatha oba yingxenye yehini eyodwa kokune kuliwayini. ");
INSERT INTO nde_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Lingadli sinkwa loba inhlamvu zamabele ezikhanzingiweyo kumbe ezintsha kuze kube yilelolanga eliletha ngalo umnikelo lo kuNkulunkulu wenu. Lokhu kakube yisimiso esingapheliyo kuzozonke izizukulwane ezizayo kungelani lokuthi lihlala ngaphi.’ ” ");
INSERT INTO nde_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘Kusukela ngelanga elilandela iSabatha, ilanga elaletha ngalo ilixha lomnikelo wokuzunguza, balani amaviki ayisikhombisa agcweleyo. ");
INSERT INTO nde_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Balani insuku ezingamatshumi amahlanu kusiyafika ilanga elingemva kweSabatha lesikhombisa, beseliletha umnikelo wamabele amatsha kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Kungelani lokuthi lihlala ngaphi, lethani izinkwa ezimbili ezenziwe ngefulawa ecolekileyo, eyingxenye yehefa ngokubili etshumini, siphekwe ngemvubelo, kube ngumnikelo wokuzunguzwa, owezithelo zakuqala kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Lethani isinkwa lesi ndawonye lamawundlu amaduna ayisikhombisa, linye ngalinye lilomnyaka owodwa ubudala njalo lingelasici, ijongosi lenqama ezimbili. Kuzakuba ngumnikelo wokutshiswa kuThixo kanye lomnikelo wamabele lowokunathwayo, umnikelo otshisiweyo ngomlilo oletha iphunga elimnandi kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Beselinikela ngempongo umnikelo wesono, langamawundlu amabili alomnyaka owodwa abe ngumnikelo wobudlelwano. ");
INSERT INTO nde_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Umphristi kumele azunguze amawundlu lawo womabili kuThixo njengomnikelo wokuzunguzwa kanye lesinkwa sezithelo zakuqala. Zingumnikelo womphristi ongcwele kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Ngosuku olufanayo kumele limemezele inkonzo engcwele, lingenzi msebenzi yansuku zonke. Lokhu kuzakuba yisimiso esingapheliyo ezizukulwaneni zenu ezizayo, lalapho elizabe lihlala khona. ");
INSERT INTO nde_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Lapho livuna isivuno selizwe lakini, lingavuni lasemaphethelweni amasimu enu, futhi lingabuthi okukhithikayo lapho livuna. Lokhu kutshiyeleni abayanga lezihambi. Mina nginguThixo uNkulunkulu wenu.’ ” ");
INSERT INTO nde_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Tshela abako-Israyeli ukuthi, ‘Ilanga lakuqala lenyanga yesikhombisa lusuku lwesabatha lokuphumula, umbuthano ongcwele wokukhonza ngokutshaya icilongo. ");
INSERT INTO nde_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Lingenzi msebenzi, kodwa nikelani umnikelo wokutshiswa kuThixo.’ ” ");
INSERT INTO nde_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Usuku lwetshumi lwenyanga yesikhombisa lilanga lokubuyisana. Wobani lenkonzo engcwele lizile ukudla, lilethe umnikelo wokutshiswa ngomlilo kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Lingasebenzi ngalelolanga, ngoba lilanga lokuBuyisana, lapho lihlawulelwa kuThixo uNkulunkulu wenu. ");
INSERT INTO nde_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Lowo ongaziliyo ngalelolanga makasuswe ebantwini bakibo. ");
INSERT INTO nde_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Lowo osebenzayo ngalelolanga ngizambhubhisa phakathi kwabakibo. ");
INSERT INTO nde_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Lulisabatha lenu lokuphumula njalo kumele lizile. ");
INSERT INTO nde_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Kusukela kusihlwa ngelanga lesificamunwemunye lwenyanga kuze kube kusihlwa ngelanga elilandelayo ligcine isabatha lenu.” ");
INSERT INTO nde_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Tshela abako-Israyeli ukuthi ngelanga letshumi lanhlanu ngenyanga yesikhombisa uMkhosi kaThixo weziHonqo kawuqalise njalo uqhubeke okwensuku eziyisikhombisa. ");
INSERT INTO nde_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Ilanga lokuqala ngelenkonzo engcwele; lingenzi msebenzi wansuku zonke. ");
INSERT INTO nde_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Okwensuku eziyisikhombisa lethani iminikelo yokutshiswa kuThixo, kuthi ngosuku lwesificaminwembili libe lenkonzo engcwele lilethe umnikelo wokutshiswa kuThixo. Yinkonzo yokuvala; lingenzi msebenzi wansuku zonke. ");
INSERT INTO nde_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","(Le yimikhosi kaThixo emisiweyo elizayimemezela njengezinkonzo ezingcwele, ezokuletha iminikelo yokutshiswa kuThixo, iminikelo yokutshiswa, leminikelo yamabele, imihlatshelo leminikelo enathwayo efunekayo insuku ngensuku. ");
INSERT INTO nde_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Iminikelo le ngengaphezu kwaleyo eyamaSabatha kaThixo njalo ngaphezu kwezipho zenu lalokho eliyabe lifungele ukukupha langaphezulu kweminikelo yonke yokuzithandela eliyinika uThixo.) ");
INSERT INTO nde_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Ngakho-ke, kusukela ngosuku lwetshumi lanhlanu enyangeni yesikhombisa, ngemva kokuba selivunile amabele akulelolizwe, wobani lomkhosi wokuthokoza kuThixo okwensuku eziyisikhombisa. Elokuqala lilanga lokuphumula, kanye lelesificaminwembili lalo lilanga lokuphumula. ");
INSERT INTO nde_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Ngelanga lokuqala libokukha izithelo ezinhle zezihlahla, ingatsha zamalala, ingatsha zezihlahla ezilamahlamvu amanengi, lemidubu, lijabule phambi kukaThixo uNkulunkulu wenu lonke okwensuku eziyisikhombisa. ");
INSERT INTO nde_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Thakazelelani umkhosi kaThixo lo minyaka yonke okwensuku eziyisikhombisa. Lesi kasibe yisimiso esingapheliyo ezizukulwaneni ezizayo; umkhosi liwenze ngenyanga yesikhombisa. ");
INSERT INTO nde_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Libohlala ezihonqweni okwensuku eziyisikhombisa. ");
INSERT INTO nde_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Bonke abako-Israyeli ngokuzalwa kumele bahlale ezihonqweni, ukuze izizukulwane zenu zazi ukuthi ngahlalisa abako-Israyeli emadumbeni mhla ngibakhipha eGibhithe. Mina nginguThixo uNkulunkulu wenu.” ");
INSERT INTO nde_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Ngakho uMosi wasebabikela abako-Israyeli ngemikhosi emisiweyo kaThixo. ");
INSERT INTO nde_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Laya abantu bako-Israyeli bakulethele amafutha acengekileyo, ahluzwe ema-oliveni, abe ngawokukhanyisa ukuze izibane zihlale zikhanyisa kokuphela. ");
INSERT INTO nde_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Ngaphandle kwekhetheni eligudle umtshokotsho wobufakazi, phakathi kwethente lokuhlangana u-Aroni kumele alinde izibane phambi kukaThixo izikhathi zonke nxa kusihlwa kuze kube sekuseni. Lokhu kuzakuba yisimiso saphakade lakuzizukulwane ezizayo. ");
INSERT INTO nde_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Izibane ezisoluthini lwegolide elicolekileyo phambi kukaThixo kumele zilindwe izikhathi zonke. ");
INSERT INTO nde_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Thatha ifulawa ecolekileyo wenze izinkwa ezilitshumi lambili usebenzisa okubili kwetshumi kwehefa isinkwa ngasinye. ");
INSERT INTO nde_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Zibeke emizileni emibili, ziyisithupha emzileni munye, phezu kwetafula yegolide elicolekileyo phambi kukaThixo. ");
INSERT INTO nde_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Emzileni ngamunye faka impepha enhle njengengxenye yesikhumbuzo esimela isinkwa njalo kube ngumhlatshelo wokudla onikelwa kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Isinkwa lesi kumele sibekwe phambi kukaThixo izikhathi zonke, amaSabatha wonke, kusenzelwa abako-Israyeli, kube yisivumelwano esingayikuphela. ");
INSERT INTO nde_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Sizakuba ngesika-Aroni lamadodana akhe, abazasidlela endaweni engcwele ngoba siyingxenye engcwele kakhulu yesabelo sabo esifaneleyo somhlatshelo onikelwa kuThixo.” ");
INSERT INTO nde_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Kwasekusiba lendodana yomfazi wako-Israyeli, uyise wayengumGibhithe, yasuka yaya ebantwini bako-Israyeli, yasixabana lomuntu wako-Israyeli ezihonqweni. ");
INSERT INTO nde_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Indodana yomfazi wako-Israyeli leyo yahlambaza ibizo likaThixo ngesithuko. Ngakho bayiletha kuMosi. (Ibizo likanina lalinguShelomithi, indodakazi kaDibhiri, owesizwe sikaDani.) ");
INSERT INTO nde_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Bayifaka entolongweni ukuba intando kaThixo ize yazakale kuhle kubo. ");
INSERT INTO nde_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","UThixo wasesithi kuMosi, ");
INSERT INTO nde_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Umuntu lowo owathukayo mkhupheleni ngaphandle kwezihonqo. Bonke labo abamuzwayo babeke izandla zabo phezu kwekhanda lakhe, ibandla lonke limgongode ngamatshe. ");
INSERT INTO nde_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Tshela abako-Israyeli uthi, ‘Loba ngubani othuka uNkulunkulu wakhe, uzakuba lecala. ");
INSERT INTO nde_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Loba ngubani othuka ibizo likaThixo uzabulawa. Ibandla lonke kumele limgongode ngamatshe. Loba kungowezizweni kumbe oyinzalo yelizwe lakini angahlambaza ibizo likaThixo kumele abulawe. ");
INSERT INTO nde_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Obulala umuntu kumele abulawe. ");
INSERT INTO nde_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Obulala isifuyo somunye kumele ahlawule, kube okuphilayo ngokuphilayo. ");
INSERT INTO nde_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Olimaza umakhelwane wakhe, loba ngayiphi indlela, kumele kwenziwe lakuye, ");
INSERT INTO nde_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","kube yikwephuka ngokwephuka, ilihlo ngelihlo, izinyo ngezinyo. Njengoba elimaze omunye, ngokunjalo laye kumele alinyazwe. ");
INSERT INTO nde_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Obulala inyamazana kumele ayihlawule, kodwa obulala umuntu kumele abulawe. ");
INSERT INTO nde_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Lizakuba lomlayo munye kowezizweni lowakini. Mina nginguThixo uNkulunkulu wenu.’ ” ");
INSERT INTO nde_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Emva kwalokho uMosi wakhuluma kwabako-Israyeli, basebethatha umuntu lowo owayehlambaze uThixo, bamusa ngaphandle kwezihonqo, bamgongoda ngamatshe. Abako-Israyeli benza njengokulaywa kwabo nguThixo. ");
INSERT INTO nde_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","UThixo wathi kuMosi entabeni iSinayi, ");
INSERT INTO nde_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Khuluma ebantwini bako-Israyeli uthi kubo: ‘Lapho lingena elizweni engizalinika lona, ilizwe lona ngokwalo kumele ligcinele uThixo iSabatha. ");
INSERT INTO nde_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Hlanyelani amasimu enu okweminyaka eyisithupha, kuthi kweminye iminyaka eyisithupha lithene amavini enu. ");
INSERT INTO nde_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Kodwa ngomnyaka wesikhombisa ilizwe kalibe leSabatha lokuphumula, iSabatha likaThixo. Lingahlanyeli amasimu enu loba lithene izihlahla ezivinini zenu. ");
INSERT INTO nde_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Lingavuni imkhukhuzela kumbe likhe izithelo zamavini angalungiselwanga, ilizwe libe lomnyaka wokuphumula. ");
INSERT INTO nde_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Lokho okuzathelwa yilizwe ngomnyaka wesabatha kuzakuba yikudla kwenu, lokwezinceku lezincekukazi zenu, lokwezisebenzi eziqhatshiweyo kanye labemzini abahlala lani, ");
INSERT INTO nde_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","kanye lokwezifuyo zenu lezinyamazana zeganga elizweni lenu. Konke okuthelwa yilizwe kakudliwe.’ ” ");
INSERT INTO nde_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘Balani amasabatha ayisikhombisa eminyaka, iminyaka eyisikhombisa iphindwe kasikhombisa ukuze amasabatha eminyaka eyisikhombisa abe yisibanga seminyaka engamatshumi amane lesificamunwemunye. ");
INSERT INTO nde_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Lapho-ke akutshaywe uphondo ezindaweni zonke ngosuku lwetshumi lwenyanga yesikhombisa; kuthi ngosuku lokuBuyisana kutshaywe uphondo kulolonke ilizwe lenu. ");
INSERT INTO nde_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Umnyaka wamatshumi amahlanu wenzeni ube ngcwele, limemezele inkululeko elizweni lonke kubo bonke abahlezi kulo. Uzakuba lijubhili kini. Lowo lalowo wenu kuzamele abuyele emzini wakwabo, esizweni sakibo. ");
INSERT INTO nde_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Umnyaka wamatshumi amahlanu uzakuba lijubhili kini. Lingahlanyeli lutho, njalo lingavuni imikhukhuzela kumbe likhe izithelo zamavini angalungiselwanga. ");
INSERT INTO nde_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Ngoba uliJubhili, uzakuba ngcwele kini; dlanini kuphela lokho elikuthethe emasimini. ");
INSERT INTO nde_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Ngalo umnyaka weJubhili, umuntu wonke kuzamele abuyele emzini wakwabo. ");
INSERT INTO nde_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Nxa uthengisela umuntu welizwe lakini isiqinti, kumbe usithenga kuye, lingaqilibezelani. ");
INSERT INTO nde_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Nxa uthenga emuntwini welizwe lakini kuzakuya ngokuthi mingaki iminyaka eseyadlulayo emva kweJubhili. Yena uzakuthengisela ngokuthi mingaki iminyaka eseleyo ukuthi kuvunwe amabele. ");
INSERT INTO nde_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Nxa iminyaka iminengi uzakhweza intengo, kuthi nxa iminyaka imilutshwana wehlise intengo, ngoba okuyikho akuthengisela khona linani lezivuno zamabele. ");
INSERT INTO nde_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Lingaqilibezelani; kodwa mesabeni uNkulunkulu wenu. NginguThixo uNkulunkulu wenu. ");
INSERT INTO nde_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Gcinani izimiso zami, lilalele imithetho yami ngokunanzelela ukuze lihlale livikelekile elizweni. ");
INSERT INTO nde_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Ilizwe lizathela izithelo zalo, lina lidle lisuthe, lihlale kulo livikelekile. ");
INSERT INTO nde_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Lingabuza lithi, “Pho sizakudlani ngomnyaka wesikhombisa nxa singahlanyeli kumbe sivune amabele ethu na?” ");
INSERT INTO nde_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Mina ngizalilethela isibusiso ngomnyaka wesithupha, ilizwe lithele izithelo zeminyaka emithathu. ");
INSERT INTO nde_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Lapho selilima ngomnyaka wesificaminwembili lizakube lisidla amabele amadala, liqhubeke lisidla wona kuze kufike isivuno somnyaka wesificamunwemunye. ");
INSERT INTO nde_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Ilizwe akumelanga lithengiswe kuze kube nininini, ngoba ilizwe ngelami njalo lihlala elizweni lami njengabezizweni. ");
INSERT INTO nde_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Kulolonke ilizwe elingelenu, lungiselani ukuthi wonke umhlaba owathengwayo uhlengwe. ");
INSERT INTO nde_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Nxa omunye wakini esebe ngumyanga eseze ethengisa okunye kwempahla yakhe, isihlobo sakhe kasisize sihlenge lokho osekuthengiswe ngumuntu wakibo. ");
INSERT INTO nde_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Kodwa-ke nxa umuntu engelaye ongamhlengela khona, abesebuya enotha yena ngokwakhe azuze okwanele ukuthi azihlengele, ");
INSERT INTO nde_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","kabale imali elingana leminyaka leyo kusukela impahla leyo ithengisiwe, abuyisele imali esalayo kulowomuntu ayemthengisele, abesethatha impahla yakhe. ");
INSERT INTO nde_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Kodwa-ke nxa engelamali eyaneleyo yokuyibuyisa leyompahla ayithengisayo, kayihlale kulowo owayithengayo kuze kufike umnyaka weJubhili. Izabuyiselwa kuye ngeJubhili, kulapho-ke azayithatha khona impahla yakhe. ");
INSERT INTO nde_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Nxa umuntu ethengisa indlu edolobheni elihonqolozelwe ngomthangala ulelungelo lokuyihlenga emva komnyaka ithengisiwe. Phakathi kwalesosikhathi angayihlenga. ");
INSERT INTO nde_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Nxa ingahlengwanga kuze kuphele umnyaka ogcweleyo, indlu esedolobheni elihonqolozelwe ngomthangala izakuba ngeyalowo owayithengayo, ibe ngeyakhe kokuphela lowo owayithengayo kanye lezizukulwane zakhe. Kayiyikubuyiselwa kowayengumniniyo ngeJubhili. ");
INSERT INTO nde_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Kodwa izindlu ezisemizini engahonqolozelwanga zizabalwa njengeganga elingelalutho. Kazihlengwe, njalo kumele zibuyiselwe kubanikazi ngeJubhili. ");
INSERT INTO nde_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","AmaLevi ahlezi elelungelo lokuhlenga izindlu zawo emadolobheni angawamaLevi. ");
INSERT INTO nde_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Ngakho-ke, impahla yamaLevi iyahlengeka, lokhu kutsho indlu ethengiswe loba kukuliphi idolobho elingelabo, kumele ibuyiselwe ngeJubhili, ngoba izindlu ezisemadolobheni amaLevi zililifa lawo ebantwini labako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Kodwa amadlelo angaphandle kwamadolobho awo akumelanga athengiswe ngoba ayilifa lawo kuze kube nininini. ");
INSERT INTO nde_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Nxa omunye wabantu bakini esiba ngumyanga owehluleka ukuziphilisa phakathi kwenu, msizeni njengelingakwenza kowezizweni kumbe ohlezi lani okwesikhatshana, ukuze aqhubeke ehlala lani. ");
INSERT INTO nde_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Akungabi lanzuzo eliyithatha kuye, kodwa mesabeni uNkulunkulu wenu, ukuze umuntu wakini aqhubeke ehlala lani. ");
INSERT INTO nde_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Lingameboleki imali ezalayo kumbe limthengisele ukudla kulenzuzo. ");
INSERT INTO nde_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Mina nginguThixo uNkulunkulu wenu owalikhupha elizweni laseGibhithe, ukuba ngilinike ilizwe laseKhenani, ngibe nguNkulunkulu wenu. ");
INSERT INTO nde_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Nxa omunye wakini ko-Israyeli esiba ngumyanga phakathi kwenu aze azithengise kuwe, ungamsebenzisi njengesigqili. ");
INSERT INTO nde_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Kumele umphathe njengesisebenzi esiqhatshiweyo kumbe umuntu ohlezi okwesikhatshana phakathi kwenu. Kakusebenzele kuze kufike umnyaka weJubhili. ");
INSERT INTO nde_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Lapho-ke yena labantwabakhe bazakhululwa, babuyele kwabosendo lwakibo lemfuyweni yabokhokho babo. ");
INSERT INTO nde_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Ngenxa yokuthi abako-Israyeli bazinceku zami engazikhupha elizweni laseGibhithe, akumelanga bathengiswe njengezigqili. ");
INSERT INTO nde_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Ungababusi ngochuku, kodwa mesabe uNkulunkulu wakho. ");
INSERT INTO nde_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Iziqgili zenu zesilisa lezesifazane zizavela ezizweni ezilihonqolezeleyo; kuzo yikho lapho elingathenga khona izigqili. ");
INSERT INTO nde_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Lingathenga lezakhamizi ezihlezi phakathi kwenu okwesikhatshana, labomndeni wazo abazalelwa elizweni lenu. ");
INSERT INTO nde_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Lingabenza babe yilifa labantwabenu, libenze babe yizigqili zabo okwanininini, kodwa akumelanga libuse abako-Israyeli benu ngochuku. ");
INSERT INTO nde_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Nxa owezizweni, kumbe umuntu ohlezi phakathi kwenu okwesikhatshana enotha, kuthi owakini abe ngumyanga azithengise kowezizweni ohlala phakathi kwenu loba kolilunga lomndeni wezizweni, ");
INSERT INTO nde_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ulokhu elalo ilungelo lokuhlengwa emva kokuzithengisa kwakhe. Omunye wezihlobo zakhe angamhlenga. ");
INSERT INTO nde_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Umalumakhe kumbe umzawakhe, loba esinye isihlobo somdeni wakhe singamhlenga. Loba nxa enotha, angazihlenga yena ngokwakhe. ");
INSERT INTO nde_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Yena lomthengi wakhe kababale isikhathi kusukela ngomnyaka azithengisa ngawo kusiyafika emnyakeni weJubhili. Intengo yokukhululwa kwakhe izakuhambelana lenani elinikwa umuntu oqhatshiweyo okwalesosikhathi seminyaka. ");
INSERT INTO nde_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Nxa kusele iminyaka eminengi, kumele ahlawulele ukuhlengwa kwakhe ngentengo eyingxenye enengi yentengo ayethengwe ngawo. ");
INSERT INTO nde_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Nxa sekusele iminyaka emilutshwana ukuba kufike umnyaka weJubhili, uzabala lokho, akhuphe intengo yokuhlengwa kwakhe okulingana leyominyaka. ");
INSERT INTO nde_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Uzabalwa njengomuntu oqhatshiweyo kusukela komunye umnyaka kusiya komunye. Kumele libone ukuthi lowo owamthengayo kambusi ngochuku. ");
INSERT INTO nde_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Nxa engahlengwanga ngenye yalezizindlela, yena labantwabakhe bazakhululwa ngomnyaka weJubhili, ");
INSERT INTO nde_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","ngoba abako-Israyeli ngabami, bazinceku zami. Bazinceku zami engazikhupha elizweni laseGibhithe. Mina nginguThixo uNkulunkulu wenu.’ ” ");
INSERT INTO nde_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘Lingazenzeli izithombe loba imifanekiso kumbe amatshe akhonzwayo, njalo lingafaki matshe elizweni lenu ukuba liwakhothamele. Mina nginguThixo uNkulunkulu wenu. ");
INSERT INTO nde_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Gcinani amaSabatha ami, lihloniphe indlu yami engcwele. Mina nginguThixo. ");
INSERT INTO nde_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Lingalalela izimiso zami, ligcine imilayo yami, ");
INSERT INTO nde_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ngizalehlisela izulu ngesikhathi salo, umhlabathi uthele amabele, lezihlahla zeganga zithele izithelo zazo. ");
INSERT INTO nde_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Ukubhula kwenu kuzaqhubeka kuze kufike isikhathi sokuvunwa kwamavini, kuthi ukuvunwa kwamavini kuqhubeke kuze kufike isikhathi sokuhlanyela, njalo lizakudla konke ukudla elikufunayo lihlale ngokuvikeleka elizweni lenu. ");
INSERT INTO nde_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Ngizaletha ukuthula elizweni lenu, kungekho muntu ozalethusa. Ngizasusa izinyamazana eziyingozi elizweni; inkemba ayiyikwedlula phakathi kwelizwe lenu. ");
INSERT INTO nde_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Lizazixotsha izitha zenu, ziwe ngenkemba phambi kwenu. ");
INSERT INTO nde_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Abahlanu benu bazaxotsha abalikhulu, kuthi abalikhulu benu baxotshe abayinkulungwane, njalo izitha zenu zizakuwa ngenkemba phambi kwenu. ");
INSERT INTO nde_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Ngizakuba lomusa kini ngilinike inzalo lande; njalo ngizagcina isivumelwano sami lani. ");
INSERT INTO nde_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Lizakudla okwesivuno sanyakenye lapho okuzamele lisisuse ukuze kube lendawo yesivuno esitsha. ");
INSERT INTO nde_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ngizabeka indawo yami yokuhlala phakathi kwenu, njalo kaliyikunginenga. ");
INSERT INTO nde_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ngizahamba phakathi kwenu, ngibe nguNkulunkulu wenu lina libe ngabantu bami. ");
INSERT INTO nde_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Mina nginguThixo uNkulunkulu wenu owalikhupha elizweni laseGibhithe ukuze lingabi yizigqili zamaGibhithe futhi. Ngizaphule izikeyi zejogwe lenu njalo ngenza ukuba lenelise ukuhamba amakhanda enu ephakeme.’ ” ");
INSERT INTO nde_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘Kodwa nxa lingayikungilalela, lingayigcini lemilayo yonke le, ");
INSERT INTO nde_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","njalo nxa lizakwala izimiso zami, linengwe yimithetho yami, lingenzi okwemilayo yami yonke, ngalokho lephule isivumelwano sami, ");
INSERT INTO nde_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ngizakwenza lokhu kini: Ngizalilethela ukwesaba okukhulu, izifo ezicikizayo, loqhuqho oluzafiphaza amehlo enu, lunciphise impilo yenu. Lizahlanyela inhlanyelo ingasizi ngalutho, ngoba izitha zenu zizayidla. ");
INSERT INTO nde_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Ngizaliphendukela lehlulwe yizitha zenu, abalizondayo bazalibusa; lizabaleka lanxa kungekho olixotshayo. ");
INSERT INTO nde_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Nxa emva kwakho konke lokhu lingayikungilalela, ngizalijezisa ngokuphindwe kasikhombisa ngenxa yezono zenu. ");
INSERT INTO nde_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Ngizabudiliza ubuqholo bokuzazisa kwenu, ngenze umkhathi phezu kwenu ube njengensimbi, kuthi umhlabathi ngaphansi kwenu ube njengethusi. ");
INSERT INTO nde_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Amandla enu azachithelwa ize, ngoba umhlabathi wenu awuyikulinika amabele, lezihlahla zelizwe aziyikuthela izithelo zazo. ");
INSERT INTO nde_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Lingaqhubeka liyizitha kimi, lale ukungilalela, ngizalithumela inhlupheko zenu kasikhombisa njengokufanele izono zenu. ");
INSERT INTO nde_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Ngizalithumela izilo zeganga, ezizalemuka abantwabenu, zibulale inkomo zenu, zilenze libe balutshwana, imigwaqo yenu ize isale ingaselamuntu. ");
INSERT INTO nde_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Nxa phezu kwalezizinto lingemukeli iziqondiso zami, liqhubeke liyizitha kimi, ");
INSERT INTO nde_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","mina ngokwami ngizakuba yisitha kini, ngilitshaye okuphindwe kasikhombisa ngenxa yezono zenu. ");
INSERT INTO nde_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Njalo ngizaletha lenkemba phezu kwenu ukuba kuphindiselwe ukwephulwa kwesivumelwano. Lingahlehlela emadolobheni enu, ngizathumela isifo phakathi kwenu, linikelwe lezandleni zezitha. ");
INSERT INTO nde_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Lapho sengimise ukulethwa kwezinkwa zenu, abesifazane abalitshumi bazapheka izinkwa zenu eziko elilodwa, babele izinkwa zenu ngobunzima bazo; lizakudla kodwa lingasuthi. ");
INSERT INTO nde_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Nxa lingaqhubeka lingangilaleli, liqhubeka liyizitha kimi, ");
INSERT INTO nde_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","lami ngolaka lwami ngizakuba yisitha kini, njalo mina ngokwami ngizalijezisa okuphindwe kasikhombisa ngenxa yezono zenu. ");
INSERT INTO nde_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Lizakudla inyama yemizimba yamadodana enu, lidle lenyama yemizimba yamadodakazi enu. ");
INSERT INTO nde_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Ngizabhidliza izindawo zenu eziphakemeyo, ngidilize lama-alithare enu empepha, besengibuthelela izidumbu zenu phezu kwezithombe zenu ezingaphiliyo, nginengeke ngani. ");
INSERT INTO nde_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Ngizakwenza amadolobho enu abe ngamanxiwa, ngidilize izindlu zenu ezingcwele, njalo angiyikuthokoziswa yikunuka mnandi kwephunga leminikelo yenu. ");
INSERT INTO nde_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ilizwe ngizalitshabalalisa kuze kumangale izitha zenu ezihlala kulo. ");
INSERT INTO nde_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Ngizalihlakazela phakathi kwezizwe, ngikhokhe inkemba yami, ngilixotshe. Ilizwe lenu lizatshabalaliswa, amadolobho enu abe ngamanxiwa. ");
INSERT INTO nde_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Lapho-ke ilizwe lizathokoziswa ngamasabatha alo ngesikhathi sonke lichithekile, lina liselizweni lezitha zenu. Emva kwalokho, ilizwe lizaphumula lithokoze ngamasabatha alo. ");
INSERT INTO nde_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Ngasosonke lesosikhathi ilizwe lichithekile lizakuba lokuphumula elingazange libe lakho ngamasabatha esikhathi lina lisahlala kulo. ");
INSERT INTO nde_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Mayelana lalabo abasele bephila, ngizakwenza inhliziyo zabo zibe lokwesaba okukhulu bekhonale emazweni ezitha zabo baze babalekele lomsindo wehlamvu liphetshulwa ngumoya. Bazagijima angathi babalekela inkemba; bazakuwa lanxa kungekho muntu obaxotshayo. ");
INSERT INTO nde_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Bazagwenxana angathi babalekela inkemba, lanxa kungekho muntu obaxotshayo. Ngakho aliyikuba lamandla okumelana lezitha zenu. ");
INSERT INTO nde_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Lizabhubha phakathi kwezizwe, lidliwe yilizwe lezitha zenu. ");
INSERT INTO nde_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Abenu labo abasalayo bazahlala behlulukelwe emazweni ezitha zabo ngenxa yezono zabo, njalo bazahlulukelwa ngenxa yezono zaboyise. ");
INSERT INTO nde_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Kodwa bangavuma izono zabo lezono zaboyise, inkohliso abayenza kimi, lokumelana kwabo lami, ");
INSERT INTO nde_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","okwenza lami ngaba yisitha kubo ngaze ngabasa elizweni lezitha zabo, kuthi lapho inhliziyo zabo ezingasokwanga sezithobekile, behlawulela lezono zabo futhi, ");
INSERT INTO nde_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ngizasikhumbula isivumelwano sami loJakhobe, lesivumelwano sami lo-Isaka, lesivumelwano sami lo-Abhrahama, besengilikhumbula ilizwe. ");
INSERT INTO nde_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Ngoba ilizwe bazalitshiya lithokoze ngamasabatha alo lapho lichithekile, bengekho kulo. Bazahlawulela izono zabo ngoba imithetho yami bayala, benengeka ngezimiso zami. ");
INSERT INTO nde_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Ikanti lanxa kunjalo, nxa sebeselizweni lezitha zabo angiyikubalahla loba nginengeke ngabo, besengibatshabalalisa ngephule lesivumelwano sami labo. Mina nginguThixo uNkulunkulu wabo. ");
INSERT INTO nde_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Kodwa ngenxa yabo ngizasikhumbula isivumelwano sami labokhokho babo engabakhupha elizweni laseGibhithe, izizwe zikhangele ukuba ngibe nguNkulunkulu wabo. Mina nginguThixo.’ ” ");
INSERT INTO nde_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Lezi yizimiso, imithetho lemilayo eyabekwa nguThixo ngoMosi entabeni iSinayi phakathi kwakhe labako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Khuluma kwabako-Israyeli uthi kubo: ‘Nxa umuntu esenza isithembiso esingavamanga, ukuba anikele umuntu kuThixo ngokuqamba intengo engalingana lomuntu, ");
INSERT INTO nde_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","owesilisa oleminyaka ephakathi kwamatshumi amabili lamatshumi ayisithupha kabe ngamashekeli angamatshumi amahlanu esiliva kulinganiswa ngeshekeli lendlu engcwele. ");
INSERT INTO nde_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Nxa engowesifazane, kakube ngamashekeli angamatshumi amathathu. ");
INSERT INTO nde_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Nxa kungumuntu wesilisa oleminyaka ephakathi kwemihlanu lengamatshumi amabili, isilinganiso akube ngamashekeli angamatshumi amabili, kuthi owesifazane kube ngamashekeli alitshumi. ");
INSERT INTO nde_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Nxa kungumuntu wesilisa ophakathi kwenyanga eyodwa leminyaka emihlanu, isilinganiso akube ngamashekeli amahlanu esiliva kuthi owesifazane kube ngamashekeli esiliva amathathu. ");
INSERT INTO nde_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Nxa kungumuntu wesilisa oleminyaka engamatshumi ayisithupha kumbe edlula lapho, isilinganiso akube ngamashekeli alitshumi lanhlanu, kuthi owesifazane kube ngamashekeli alitshumi. ");
INSERT INTO nde_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Nxa umuntu owenza isifungo engumyanga, esehluleka ukukhupha isilinganiso esitshiwoyo, uzakusa umuntu lowo kumphristi onguye ozamisa isilinganiso esinganeliswa ngulowomuntu owenza isifungo. ");
INSERT INTO nde_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Nxa lokho akufungelayo kuyisifuyo esamukelekayo njengomnikelo kuThixo, isifuyo esinikelwe kanjalo kuThixo siba ngcwele. ");
INSERT INTO nde_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Akumelanga asintshintshe kumbe enanisele esihle ngesibi, loba esibi ngesihle. ");
INSERT INTO nde_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Nxa lokho akufungelayo kuyinyamazana engcolileyo, njalo ingamukeleki njengomnikelo kuThixo, kumele sinikwe umphristi, ");
INSERT INTO nde_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","abone ukuthi sihle kumbe sibi. Lokho okuzatshiwo ngumphristi yikho okuzakwamukelwa. ");
INSERT INTO nde_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Nxa umnikazi waso efuna ukuzihlenga, kuzamele engezelele okwesihlanu phezu kwesilinganiso saso. ");
INSERT INTO nde_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Nxa umuntu enikela indlu yakhe kuThixo njengolutho olungcwele, umphristi uzakwahlulela ukuthi inhle loba imbi. Loba yisiphi isilinganiso esizaqanjwa ngumphristi, yiso esizakwamukeleka. ");
INSERT INTO nde_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Nxa umuntu onikele indlu yakhe eseyihlenga, kuzamele engezelele okwesihlanu phezu kwesilinganiso sayo, indlu ibe ngeyakhe futhi. ");
INSERT INTO nde_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Nxa umuntu esahlukanisela uThixo ingxenye yensimu eyilifa lakhe, isilinganiso sayo sizalingana lenhlanyelo engahlanyelwa kuyo, amashekeli esiliva angamatshumi amahlanu kuhomeri lenhlanyelo yebhali. ");
INSERT INTO nde_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Nxa enikela insimu yakhe ngomnyaka weJubhili, isilinganiso esimisiweyo sizahlala sinjalo. ");
INSERT INTO nde_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Kodwa nxa enikela insimu yakhe emva kweJubhili, umphristi uzamisa isilinganiso sayo kusiya ngeminyaka eseleyo kusiyafika umnyaka weJubhili olandelayo, njalo isilinganiso sayo esimisiweyo sizakwehliswa. ");
INSERT INTO nde_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Nxa umuntu onikela insimu yakhe efuna ukuhlenga, kumele engezelele okwesihlanu phezu kwesilinganiso sayo, insimu izakuba ngeyakhe futhi. ");
INSERT INTO nde_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Kodwa-ke nxa insimu leyo engayihlengi, loba nxa eseyithengise komunye, ayingeke ihlengwe futhi. ");
INSERT INTO nde_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Lapho insimu iyekelwa ngeJubhili, iba ngcwele njengensimu enikelwe kuThixo, izakuba yilifa lomphristi. ");
INSERT INTO nde_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Nxa umuntu enikela kuThixo insimu ayithengayo, engasingxenye yensimu yelifa lakwabo, ");
INSERT INTO nde_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","umphristi uzaqamba isilinganiso sayo kusiyafika emnyakeni weJubhili, kuthi umuntu lowo akhuphe isilinganiso sayo mhlalokho njengolutho olungcwele kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Ngomnyaka weJubhili, insimu leyo izabuyela kulowomuntu eyathengwa kuye, onguye owayengumniniyo. ");
INSERT INTO nde_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Izilinganiso zonke kumele zenziwe ngokumayelana leshekeli lendlu engcwele, amagera angamatshumi amabili kushekeli elilodwa. ");
INSERT INTO nde_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Akekho umuntu ongehlukanisela iNkosi izibulo lenyamazana, ngoba izibulo livele ngelikaThixo; loba lingelenkomo, loba imvu, ngelikaThixo. ");
INSERT INTO nde_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Nxa ingenye yezinyamazana ezingcolileyo, umuntu angaphinda ayithenge ngesilinganiso esimisiweyo, esengezelela okwesihlanu phezu kwesilinganiso. Nxa engayihlengi, kuzamele ithengiswe ngesilinganiso esimisiweyo. ");
INSERT INTO nde_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Kodwa akulalutho umuntu alalo aselunikele kuThixo loba kungumuntu kumbe isifuyo, loba insimu eyilifa lakwabo, olungathengiswa kumbe luhlengwe; konke okunikelwe kanjalo kungcwele kakhulu kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Akulamuntu onikelwe ekubhujisweni ongahlengwa; kumele abulawe. ");
INSERT INTO nde_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Okwetshumi kwakho konke okwelizwe, ingabe ngamabele avela emhlabathini kumbe izithelo ezivela ezihlahleni, ngokukaThixo; kungcwele kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Nxa umuntu ehlenga okunye kokwetshumi kwakhe, kumele engezelele kukho okwesihlanu kwesilinganiso sakho. ");
INSERT INTO nde_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Konke okwetshumi kwenkomo lezimvu, zonke izifuyo zetshumi ezidlla ngaphansi kwentonga yomelusi zizakuba ngcwele kuThixo. ");
INSERT INTO nde_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Akumelanga akhethe enhle kwembi kumbe ananisele ngenye. Nxa esenanisela zombili, izifuyo ziba ngcwele; azingeke zihlengwe.’ ” ");
INSERT INTO nde_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Le yimilayo uThixo ayinika uMosi entabeni yaseSinayi ukuba ayinike abako-Israyeli.");
INSERT INTO nde_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","UThixo wakhuluma kuMosi ethenteni lokuhlangana enkangala yaseSinayi ngosuku lwakuqala lwenyanga yesibili emnyakeni wesibili ngemva kokuphuma kwabako-Israyeli eGibhithe. UThixo wathi, ");
INSERT INTO nde_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Balani abantu bonke bako-Israyeli ngensendo langezindlu zabo, lenze uluhlu lwamabizo amadoda, inye ngayinye. ");
INSERT INTO nde_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Wena lo-Aroni lizaqoqa ngezigaba wonke amadoda ako-Israyeli kusukela kwabaleminyaka engamatshumi amabili kusiya phezulu abangaba libutho. ");
INSERT INTO nde_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Kuzozonke izizwe lithathe indoda eyodwa, eyinhloko yendlu yakibo, ukuze balincedise. ");
INSERT INTO nde_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","La yiwo amabizo amadoda azaliphathisa: esizweni sikaRubheni, u-Elizuri indodana kaShedewuri: ");
INSERT INTO nde_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","esizweni sikaSimiyoni, uShelumiyeli indodana kaZurishadayi; ");
INSERT INTO nde_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","esizweni sikaJuda, uNahashoni indodana ka-Aminadabi; ");
INSERT INTO nde_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","esizweni sika-Isakhari, uNethaneli indodana kaZuwari; ");
INSERT INTO nde_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","esizweni sikaZebhuluni, u-Eliyabi indodana kaHeloni; ");
INSERT INTO nde_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","emadodaneni kaJosefa kwakuyila: esizweni sika-Efrayimi, u-Elishama indodana ka-Amihudi; esizweni sikaManase, uGamaliyeli indodana kaPhedazuri; ");
INSERT INTO nde_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","esizweni sikaBhenjamini, u-Abhidani indodana kaGidiyoni; ");
INSERT INTO nde_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","esizweni sikaDani, u-Ahiyezeri indodana ka-Amishadayi; ");
INSERT INTO nde_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","esizweni sika-Asheri, uPhagiyeli indodana ka-Okhirani; ");
INSERT INTO nde_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","esizweni sikaGadi, u-Eliyasafi indodana kaDuweli; ");
INSERT INTO nde_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","esizweni sikaNafithali; u-Ahira indodana ka-Enani.” ");
INSERT INTO nde_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","La yiwo amadoda akhethwa ebantwini bakuleyondawo, bengabakhokheli bezizwe zabokhokho babo. Babezinhloko zezizwana zako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","UMosi lo-Aroni bathatha amadoda la alamabizo ayeqanjiwe ");
INSERT INTO nde_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","basebebizela ndawonye bonke abantu ngosuku lwakuqala lwenyanga yesibili. Baziveza umdabuko wabo ngensendo langezindlu zabo, ngakho kusukela emadodeni aleminyaka engamatshumi amabili kusiya phezulu kwabhalwa amabizo awo, inye ngayinye, ");
INSERT INTO nde_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","njengokulaywa kukaMosi nguThixo. Ngakho wababala enkangala yaseSinayi: ");
INSERT INTO nde_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Ezizukulwaneni zikaRubheni indodana ka-Israyeli elizibulo: Wonke amadoda aleminyaka efika kumatshumi amabili kusiya phezulu ayengaba libutho abhalwa amabizo awo, inye ngayinye, kulandelwa imbali yosendo langezindlu zokuzalwa kwawo. ");
INSERT INTO nde_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Inani labesizwana sikaRubheni lalizinkulungwane ezingamatshumi amane lesithupha, lamakhulu amahlanu (46,500). ");
INSERT INTO nde_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Ezizukulwaneni zikaSimiyoni: Wonke amadoda aleminyaka efika kwengamatshumi amabili kusiya phezulu ayengaba libutho abalwa kwabhalwa amabizo awo, inye ngayinye, kulandelwa imbali yosendo langezindlu zokuzalwa kwawo. ");
INSERT INTO nde_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Inani labesizwana sikaSimiyoni lalizinkulungwane ezingamatshumi amahlanu lasificamunwemunye, lamakhulu amathathu (59,300). ");
INSERT INTO nde_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Ezizukulwaneni zikaGadi: Wonke amadoda aleminyaka efika kwengamatshumi amabili kusiya phezulu ayengaba libutho kwabhalwa amabizo awo, inye ngayinye, kulandelwa imbali yosendo langezindlu zokuzalwa kwawo. ");
INSERT INTO nde_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Inani labesizwana sikaGadi lalizinkulungwane ezingamatshumi amane lanhlanu, lamakhulu ayisithupha lamatshumi amahlanu (45,650). ");
INSERT INTO nde_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Ezizukulwaneni zikaJuda: Wonke amadoda aleminyaka engamatshumi amabili kusiya phezulu ayengaba libutho abhalwa amabizo awo, inye ngayinye, kulandelwa imbali yosendo langezindlu zokuzalwa kwawo. ");
INSERT INTO nde_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Inani labesizwana sikaJuda lalizinkulungwane ezingamatshumi ayisikhombisa lane lamakhulu ayisithupha (74,600). ");
INSERT INTO nde_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Ezizukulwaneni zika-Isakhari: Wonke amadoda aleminyaka engamatshumi amabili kusiya phezulu ayengaba libutho abhalwa amabizo awo, inye ngayinye, kulandelwa imbali yosendo langezindlu zokuzalwa kwawo. ");
INSERT INTO nde_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Inani labesizwana sika-Isakhari lalizinkulungwane ezingamatshumi amahlanu lane, lamakhulu amane (54,400). ");
INSERT INTO nde_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Ezizukulwaneni zikaZebhuluni: Wonke amadoda aleminyaka engamatshumi amabili kusiya phezulu ayengaba libutho abhalwa amabizo awo, inye ngayinye, kulandelwa imbali yosendo langezindlu zokuzalwa kwawo. ");
INSERT INTO nde_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Inani lesizwe sikaZebhuluni lalizinkulungwane ezingamatshumi amahlanu lasikhombisa, lamakhulu amane (57,400). ");
INSERT INTO nde_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Emadodaneni kaJosefa: Ezizukulwaneni zika-Efrayimi: Wonke amadoda aleminyaka engamatshumi amabili kusiya phezulu ayengaba libutho abhalwa amabizo awo, inye ngayinye, kulandelwa imbali yosendo langezindlu zokuzalwa kwawo. ");
INSERT INTO nde_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Inani labesizwe sika-Efrayimi lalizinkulungwane ezingamatshumi amane lamakhulu amahlanu (40,500). ");
INSERT INTO nde_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Ezizukulwaneni zikaManase: Wonke amadoda aleminyaka engamatshumi amabili kusiya phezulu ayengaba libutho abhalwa amabizo awo, inye ngayinye, kulandelwa imbali yosendo langezindlu zokuzalwa kwawo. ");
INSERT INTO nde_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Inani labesizwe sikaManase lalizinkulungwane ezintathu lambili, lamakhulu amabili (32,200). ");
INSERT INTO nde_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Ezizukulwaneni zikaBhenjamini: Wonke amadoda aleminyaka engamatshumi amabili kusiya phezulu ayengaba libutho abhalwa amabizo awo, inye ngayinye, kulandelwa imbali yosendo langezindlu zokuzalwa kwawo. ");
INSERT INTO nde_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Inani labesizwe sikaBhenjamini lalizinkulungwane ezingamatshumi amathathu lanhlanu, lamakhulu amane (35,400). ");
INSERT INTO nde_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Ezizukulwaneni zikaDani: Wonke amadoda aleminyaka engamatshumi amabili kusiya phezulu ayengaba libutho abhalwa amabizo awo, inye ngayinye, kulandelwa imbali yosendo langezindlu zokuzalwa kwawo. ");
INSERT INTO nde_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Inani labesizwe sikaDani lalizinkulungwane ezingamatshumi ayisithupha lambili, lamakhulu ayisikhombisa (62,700). ");
INSERT INTO nde_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Ezizukulwaneni zika-Asheri: Wonke amadoda aleminyaka angamatshumi amabili kusiya phezulu ayengaba libutho abhalwa amabizo awo, inye ngayinye, kulandelwa imbali yosendo langezindlu zokuzalwa kwawo. ");
INSERT INTO nde_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Inani labesizwe sika-Asheri lalizinkulungwane ezingamatshumi amane lanye, lamakhulu amahlanu (41,500). ");
INSERT INTO nde_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Ezizukulwaneni zikaNafithali: Wonke amadoda aleminyaka engamatshumi amabili kusiya phezulu ayengaba libutho abhalwa amabizo awo, inye ngayinye, kulandelwa imbali yosendo langezindlu zokuzalwa kwawo. ");
INSERT INTO nde_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Inani labesizwe sikaNafithali lalizinkulungwane ezingamatshumi amahlanu lantathu, lamakhulu amane (53,400). ");
INSERT INTO nde_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","La yiwo amadoda abalwa nguMosi lo-Aroni kanye labakhokheli bako-Israyeli abalitshumi lambili, munye ngamunye emele abendlu yakhe. ");
INSERT INTO nde_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Wonke ama-Israyeli aleminyaka esukela kwengamatshumi amabili kusiya phezulu ayengaba libutho abalwa ngezindlu zawo. ");
INSERT INTO nde_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Inani lawo esehlangene wonke lalizinkulungwane ezingamakhulu ayisithupha lantathu, lamakhulu amahlanu, lamatshumi amahlanu (603,550). ");
INSERT INTO nde_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Abendlu yesizwe sikaLevi, bona-ke, ababalwanga kanyekanye labanye. ");
INSERT INTO nde_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","UThixo wayethe kuMosi: ");
INSERT INTO nde_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Ungabali abesizwe sikaLevi njalo ungabahlanganisi kulokhu kubalwa kwabanye laba abako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Kodwa, beka abaLevi ukuthi baphathe ithabanikeli lobufakazi, impahla zalo zonke kanye lazozonke izinto ezisetshenziswa kulo. Yibo abazathwala ithabanikeli lempahla zalo; bazalinakekela njalo bazalihonqolozela. ");
INSERT INTO nde_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Ngezikhathi zonke nxa ithabanikeli lisuswa abaLevi yibo abazalethula, kuthi-ke nxa selimiswa njalo, abaLevi yibo abazalimisa. Loba ngubani osondela phansi kwalo uzabulawa. ");
INSERT INTO nde_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Abako-Israyeli bazakwakha amathente abo ngezigaba zabo, indoda ngayinye esihonqweni sayo ngaphansi kophawu lwayo. ");
INSERT INTO nde_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Kodwa abaLevi bazamisa amathente abo ehonqolozele ithabanikeli loBufakazi ukuze isizwe sabako-Israyeli singayikwehlelwa lulaka. AbaLevi bazasebenza ukulinda iThabanikeli loBufakazi.” ");
INSERT INTO nde_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Abako-Israyeli benza konke njengokulaywa kukaMosi nguThixo. ");
INSERT INTO nde_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","UThixo wathi kuMosi lo-Aroni: ");
INSERT INTO nde_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Abako-Israyeli bazahlala ezihonqweni begombolozele ithente lokuhlangana bucwadlana lalo, indoda ngayinye ngaphansi kophawu lwayo kanye lezibonakaliso zendlu yayo.” ");
INSERT INTO nde_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Empumalanga, isigaba sezihonqo zakoJuda sizakuba ngaphansi kophawu lwazo. Umkhokheli wabantu bakoJuda nguNahashoni indodana ka-Aminadabi. ");
INSERT INTO nde_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Iviyo lakhe lizinkulungwane ezingamatshumi ayisikhombisa lane, lamakhulu ayisithupha (74,600). ");
INSERT INTO nde_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Izihonqo zesizwana sika-Isakhari zibe seduze khonapho. Umkhokheli wabantu besizwana sika-Isakhari nguNethaneli indodana kaZuwari. ");
INSERT INTO nde_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Iviyo lakhe lizinkulungwane ezingamatshumi amahlanu lane, lamakhulu amane (54,400). ");
INSERT INTO nde_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Kulandele isizwana sikaZebhuluni. Umkhokheli wabantu besizwana sikaZebhuluni ngu-Eliyabi indodana kaHeloni. ");
INSERT INTO nde_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Iviyo lakhe lizinkulungwane ezingamatshumi amahlanu lasikhombisa, lamakhulu amane (57,400). ");
INSERT INTO nde_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Wonke amadoda akhethelwe izihonqo zakoJuda, ngamaviyo awo, azinkulungwane ezilikhulu lamatshumi ayisificamunwemunye lesithupha, lamakhulu amane (186,400). Yibo abazaqala ukusuka. ");
INSERT INTO nde_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Eningizimu kuzakuba ngamaviyo ezihonqo zikaRubheni ngaphansi kophawu lwazo. Umkhokheli wabantu bakoRubheni ngu-Elizuri indodana kaShedewuri. ");
INSERT INTO nde_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Iviyo lakhe lizinkulungwane ezingamatshumi amane lesithupha, lamakhulu amahlanu (46,500). ");
INSERT INTO nde_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Izihonqo zesizwana sikaSimiyoni zibe seduzane khonapho. Umkhokheli wabantu bakoSimiyoni nguShelumiyeli indodana kaZurishadayi. ");
INSERT INTO nde_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Iviyo lakhe lizinkulungwane ezingamatshumi amahlanu lasificamunwemunye, lamakhulu amathathu (59,300). ");
INSERT INTO nde_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Kulandele isizwana sikaGadi. Umkhokheli wabantu bakoGadi ngu-Eliyasafi indodana kaRuweli. ");
INSERT INTO nde_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Iviyo lakhe lizinkulungwane ezingamatshumi amane lanhlanu, lamakhulu ayisithupha alamatshumi amahlanu (45,650). ");
INSERT INTO nde_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Wonke amadoda akhethelwe izihonqo zakoRubheni ngamaviyo awo azinkulungwane ezilikhulu lamatshumi amahlanu lanye, lamakhulu amane alamatshumi amahlanu (151,450). Bazakuba ngabesibili ukusuka. ");
INSERT INTO nde_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Emva kwalokho kuzasuka ithente lokuhlangana labezihonqo zabaLevi konke kube phakathi kwamaviyo ezihonqo. Bonke abantu bazalandelana ekuhambeni kwabo njengokuma kwezihonqo zabo kube yilowo lalowo endaweni yakhe ngaphansi kophawu lwakhe. ");
INSERT INTO nde_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Entshonalanga kuzakuba: ngamaviyo ezihonqo zika-Efrayimi ngaphansi kophawu lwawo. Umkhokheli wabantu bako-Efrayimi ngu-Elishama indodana ka-Amihudi. ");
INSERT INTO nde_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Iviyo lakhe lizinkulungwane ezingamatshumi amane lamakhulu amahlanu (40,500). ");
INSERT INTO nde_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Isizwana sikaManase sibe seduzane khonapho. Umkhokheli wabantu bakoManase nguGamaliyeli indodana kaPhedazuri. ");
INSERT INTO nde_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Iviyo lakhe lizinkulungwane ezingamatshumi amathathu lambili, lamakhulu amabili (32,200). ");
INSERT INTO nde_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Kulandele isizwana sikaBhenjamini. Umkhokheli wabantu bakoBhenjamini ngu-Abhidani indodana kaGidiyoni. ");
INSERT INTO nde_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Iviyo lakhe lizinkulungwane ezingamatshumi amathathu lanhlanu, lamakhulu amane (35,400). ");
INSERT INTO nde_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Wonke amadoda ayekhethelwe izihonqo zako-Efrayimi, ngokwamaviyo awo, ayezinkulungwane ezilikhulu lasificaminwembili lekhulu (108,100). Bazakuba ngabesithathu ekusukeni. ");
INSERT INTO nde_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Enyakatho kuzakuba ngamaviyo ezihonqo zikaDani, ngaphansi kophawu lwawo. Umkhokheli wabantu bakoDani ngu-Ahiyezeri indodana ka-Amishadayi. ");
INSERT INTO nde_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Iviyo lakhe lizinkulungwane ezingamatshumi ayisithupha lambili, lamakhulu ayisikhombisa (62,700). ");
INSERT INTO nde_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Izihonqo zesizwana sika-Asheri zibe seduzane khonapho. Umkhokheli wabantu bako-Asheri nguPhagiyeli indodana ka-Okhirani. ");
INSERT INTO nde_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Iviyo lakhe lizinkulungwane ezingamatshumi amane lanye, lamakhulu amahlanu (41,500). ");
INSERT INTO nde_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Kulandele isizwana sikaNafithali. Umkhokheli wabantu bakoNafithali ngu-Ahira indodana ka-Enani. ");
INSERT INTO nde_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Iviyo lakhe lizinkulungwane ezingamatshumi amahlanu lantathu, lamakhulu amane (53,400). ");
INSERT INTO nde_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Wonke amadoda ezihonqo zakoDani azinkulungwane ezilikhulu lamatshumi amahlanu lesikhombisa, lamakhulu ayisithupha (157,600). Bazasuka ekucineni, ngaphansi kophawu lwabo. ");
INSERT INTO nde_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Laba yibo abako-Israyeli, ababalwa ngezindlu zabo. Bonke labo ababesezihonqweni, ngamaviyo abo, inani labo kuzinkulungwane ezingamakhulu ayisithupha lantathu, lamakhulu amahlanu alamatshumi amahlanu (603,550). ");
INSERT INTO nde_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","AbaLevi bona kababalwanga ndawonye labanye bonke abako-Israyeli njengokulaywa kukaMosi nguThixo. ");
INSERT INTO nde_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Ngakho abako-Israyeli benza konke uThixo ayelaye ngakho uMosi; kwaba yiyo indlela abahlala ngayo ezihonqweni ngaphansi kwempawu zabo, njalo yiyo indlela ababesuka ngayo nxa sekuhanjwa, munye ngamunye ngesizwana sakibo langendlu yakhe. ");
INSERT INTO nde_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Lezi yizizukulwane zika-Aroni lezikaMosi ngesikhathi sokukhuluma kukaThixo kuMosi entabeni yaseSinayi. ");
INSERT INTO nde_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Amabizo amadodana ka-Aroni kwakunguNadabi izibulo lo-Abhihu, u-Eliyazari kanye lo-Ithamari. ");
INSERT INTO nde_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","La ngamabizo amadodana ka-Aroni, agcotshwayo abekwa ukuba ngabaphristi. ");
INSERT INTO nde_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Kodwa, uNadabi lo-Abhihu bafa phambi kukaThixo ngenxa yokunikela ngomlilo ongemukelekiyo kuThixo enkangala yaseSinayi. Babengelamadodana; kungakho u-Eliyazari lo-Ithamari babangabaphristi ngesikhathi uyise u-Aroni esaphila. ");
INSERT INTO nde_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Letha abesizwe sikaLevi ubethule ku-Aroni umphristi ukuze bamncedise. ");
INSERT INTO nde_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Bazamsebenzela yena kanye lesizwana sonke ethenteni lokuhlangana beqhuba umsebenzi wethabanikeli. ");
INSERT INTO nde_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Bazalondoloza yonke impahla yethente lokuhlangana, benzele abako-Israyeli imisebenzi nxa besenza inkonzo ethabanikeleni. ");
INSERT INTO nde_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Yethula abaLevi ku-Aroni lakumadodana akhe; bangabako-Israyeli okumele bethulwe ngokugcweleyo kuye. ");
INSERT INTO nde_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Khetha u-Aroni lamadodana akhe ukuthi babe ngabaphristi; loba ngubani omunye ozasondela endaweni engcwele kumele abulawe.” ");
INSERT INTO nde_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","UThixo waphinda wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“AbaLevi sengibakhetha phakathi kwabako-Israyeli esikhundleni samazibulo angabafana esizweni sonke sako-Israyeli. AbaLevi ngabami, ");
INSERT INTO nde_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","njengoba wonke amazibulo engawami. Ekubulaleni kwami wonke amazibulo aseGibhithe, ngazehlukanisela wonke amazibulo ako-Israyeli, awabantu loba awezinyamazana. Kumele abe ngawami. Mina nginguThixo.” ");
INSERT INTO nde_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","UThixo wathi kuMosi eNkangala yaseSinayi, ");
INSERT INTO nde_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Bala abaLevi ngezindlu zabo langosendo lwabo. Bala bonke abesilisa kusukela kwabalenyanga eyodwa bezelwe kusiya phezulu.” ");
INSERT INTO nde_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Ngakho uMosi wababala, njengokulaywa kwakhe yilizwi likaThixo. ");
INSERT INTO nde_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","La ngamabizo amadodana kaLevi: uGeshoni, uKhohathi kanye loMerari. ");
INSERT INTO nde_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","La ngamabizo abosendo lukaGeshoni: uLibhini loShimeyi. ");
INSERT INTO nde_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Abosendo lukaKhohathi babeyilaba: u-Amramu, u-Izihari, uHebhroni kanye lo-Uziyeli. ");
INSERT INTO nde_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Abosendo lukaMerari babeyilaba: uMahili loMushi. Laba kwakungabosendo lwabaLevi, kusiya ngezindlu zabo. ");
INSERT INTO nde_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","KuGeshoni kwavela usendo lwamaLibhini lolwamaShimeyi; laba yibo abosendo lwamaGeshoni. ");
INSERT INTO nde_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Inani lamadoda wonke kusukela kwabalenyanga eyodwa bezelwe kusiya phezulu ababalwayo babezinkulungwane eziyisikhombisa lamakhulu amahlanu (7,500). ");
INSERT INTO nde_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Abosendo lwamaGeshoni babezahlala ezihonqweni zabo entshonalanga, ngemuva kwethabanikeli. ");
INSERT INTO nde_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Umkhokheli wabezindlu zabakoGeshoni kwakungu-Eliyasafi indodana kaLayeli. ");
INSERT INTO nde_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Umsebenzi wamadodana kaGeshoni ethenteni lokuhlangana wawungowokulondoloza ithabanikeli, ithente, isembeso salo, ikhetheni lesango lethente lokuhlangana, ");
INSERT INTO nde_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","amakhetheni eguma, ikhetheni lesango leguma elihonqolozele ithabanikeli kanye le-alithari, lamagoda, lakho konke okuphathelane lalowo msebenzi. ");
INSERT INTO nde_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Abosendo lukaKhohathi kwakungama-Amramu, ama-Izihari, amaHebhroni kanye lama-Uziyeli. Laba yibo abosendo lwamaKhohathi. ");
INSERT INTO nde_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Inani lamadoda wonke kusukela kwabalenyanga eyodwa bezelwe kusiya phezulu babezinkulungwane eziyisificaminwembili lamakhulu ayisithupha (8,600). AmaKhohathi yiwo ayelomlandu wokugcina indawo engcwele. ");
INSERT INTO nde_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Abosendo lwamaKhohathi bahlala ezihonqweni zabo eningizimu yethabanikeli. ");
INSERT INTO nde_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Umkhokheli wabezindlu zabosendo lwamaKhohathi kwakungu-Elizafani indodana ka-Uziyeli. ");
INSERT INTO nde_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Babelomlandu wokugcina umtshokotsho wesivumelwano, itafula, uluthi lwezibane, ama-alithare, impahla zendawo engcwele ezazisetshenziswa emsebenzini wokukhonza. ");
INSERT INTO nde_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","U-Eliyazari indodana ka-Aroni, umphristi, wayengumkhokheli omkhulu wabaLevi. Wabekwa phezu kwalabo ababelomlandu wokugcina indawo engcwele. ");
INSERT INTO nde_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Abosendo lukaMerari kwakungamaMahili lamaMushi; laba babengabosendo lwamaMerari. ");
INSERT INTO nde_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Inani lamadoda asukela kwabalenyanga eyodwa bezelwe kusiya phezulu ababalwayo babezinkulungwane eziyisithupha lamakhulu amabili (6,200). ");
INSERT INTO nde_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Umkhokheli wezindlu zosendo lwamaMerari kwakunguZuriyeli indodana ka-Abhihayili; babezahlala ezihonqweni zabo enyakatho yethabanikeli. ");
INSERT INTO nde_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Abosendo lwamaMerari babelomlandu wokugcina amathala ethabanikeli, imithando, izinsika, izisekelo, izitsha zalo zonke lakho konke okuphathelane lemisebenzi yakho, ");
INSERT INTO nde_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","kanye lezinsika lezisekelo zazo ezihonqolozele iguma, izikhonkwane zethente kanye lamagoda. ");
INSERT INTO nde_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","UMosi kanye lo-Aroni lamadodana akhe babezahlala ezihonqweni zabo empumalanga yethabanikeli, phambi kwethente lokuhlangana. Babelomlandu wokugcinela abako-Israyeli indawo engcwele. Loba ngubani omunye owayezasondela endaweni engcwele kwakumele abulawe. ");
INSERT INTO nde_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Inani labaLevi bonke ababalwayo njengokulaywa kukaMosi lo-Aroni nguThixo kulandelwa insendo zawo, kusukela kwabesilisa ababelenyanga eyodwa yokuzalwa kusiya phezulu, babezinkulungwane ezingamatshumi amabili lambili (22,000). ");
INSERT INTO nde_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","UThixo wathi kuMosi, “Bala wonke amazibulo esilisa ako-Israyeli kusukela kwabalenyanga eyodwa bezelwe kusiya phezulu wenze uluhlu lwamabizo abo. ");
INSERT INTO nde_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Esikhundleni samabizo ako-Israyeli nginika abaLevi, njalo lezifuyo zabaLevi esikhundleni samazibulo ezifuyo zabako-Israyeli. Mina nginguThixo.” ");
INSERT INTO nde_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Ngalokho-ke uMosi wabala wonke amazibulo abako-Israyeli, njengokulaywa kwakhe nguThixo. ");
INSERT INTO nde_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Inani lawo wonke amazibulo esilisa kusukela kwalenyanga eyodwa yokuzalwa kusiya phezulu, ebhalwe ngoluhlu lwamabizo, ayezinkulungwane ezingamatshumi amabili lambili, lamakhulu amabili alamatshumi ayisikhombisa lantathu (22,273). ");
INSERT INTO nde_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","UThixo wabuya wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Esikhundleni samazibulo ako-Israyeli thatha abaLevi, lezifuyo zabaLevi esikhundleni sezifuyo zabo. AbaLevi kumele babengabami. Mina nginguThixo. ");
INSERT INTO nde_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Ukuhlenga amazibulo ako-Israyeli angamakhulu amabili alamatshumi ayisikhombisa lantathu (273) abangaphezu kwenani labaLevi, ");
INSERT INTO nde_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","thatha amashekeli amahlanu omunye ngamunye wabo, kusiya ngeshekeli lendawo engcwele, elilesisindo samagera angamatshumi amabili. ");
INSERT INTO nde_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Imali yokuhlenga abako-Israyeli abangaphezu kwenani uyiphe u-Aroni lamadodana akhe.” ");
INSERT INTO nde_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Lakanye uMosi wayibutha imali yokuhlenga labo ababelinani eledlula kwabahlengwa ngabaLevi. ");
INSERT INTO nde_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Wamukela kuvela emazibulweni abako-Israyeli isiliva esingamashekeli ayinkulungwane elamakhulu amathathu lamatshumi ayisithupha lanhlanu (1,365) ngesilinganiso seshekeli lendawo engcwele. ");
INSERT INTO nde_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","UMosi waqhubela u-Aroni lamadodana akhe imali yokuhlenga, njengokulaywa kwakhe nguThixo. ");
INSERT INTO nde_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","UThixo wathi kuMosi lo-Aroni: ");
INSERT INTO nde_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Balani ingxenye yabaLevi abangamaKhohathi libabale ngosendo langezindlu zabo. ");
INSERT INTO nde_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Balani wonke amadoda kusukela kwabaleminyaka engamatshumi amathathu kusiya kwabaleminyaka engamatshumi amahlanu yokuzalwa abeza bezosebenza emsebenzini wethente lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Lo yiwo umsebenzi ozakwenziwa ngamaKhohathi ethenteni lokuhlangana, ukulondoloza yonke into engcwelengcwele. ");
INSERT INTO nde_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Nxa kuthuthwa kusukwa ezihonqweni, u-Aroni lamadodana akhe kabangene bayekwethula ikhetheni elisithileyo basibekele ibhokisi lobufakazi ngalo. ");
INSERT INTO nde_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Lokhu bazakugubuzela ngezikhumba zezinyamazana, bendlale ilembu eliluhlaza okwesibhakabhaka phezu kwalokho besebefaka izibambo endaweni yazo. ");
INSERT INTO nde_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Phezu kwetafula yoBukhona bukaThixo kumele bendlale ilembu eliluhlaza okwesibhakabhaka bafake phezu kwalo imiganu, izinditshi lengubhe, lenkezo zeminikelo enathwayo; kuthi lesosinkwa esihlala sikhonapho sisale phezu kwayo. ");
INSERT INTO nde_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Phezu kwalokhu bazakwendlala ilembu elibomvu, bembese lokho ngezikhumba zezinyamazana besebefaka izibambo ezindaweni zazo. ");
INSERT INTO nde_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Kumele bathathe ilembu eliluhlaza okwesibhakabhaka bembese ngalo uluthi lwesibane sokukhanyisa, kanye lezibane zalo, izintambo zesibane kanye lezibambiso zakhona, lemiganu, lezitsha zamafutha zokuthelisa kuso. ");
INSERT INTO nde_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Besebelugoqela kanye lezinto zalo zonke ngezikhumba zezinyamazana balufakele izibambo zokuthwala. ");
INSERT INTO nde_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Phezu kwe-alithari legolide kabendlale ilembu eliluhlaza okwesibhakabhaka bakugoqele ngezikhumba zezinyamazana besebefaka izibambo zokuthwalisa endaweni yazo. ");
INSERT INTO nde_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Bazathatha zonke izinto zokusebenzisa endaweni engcwelengcwele, bazigoqele ngelembu eliluhlaza okwesibhakabhaka, bembese lokho ngezikhumba zezinyamazana bafake phezu kwethala lokuthwalisa. ");
INSERT INTO nde_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Kumele babuthe umlotha bawususe phezu kwe-alithari elilithusi besebesendlala ilembu eliyibubende phezu kwalo. ");
INSERT INTO nde_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Besebefaka phezu kwalo zonke izitsha ezisetshenziswa emsebenzini we-alithari, kuhlanganisa lezindengezi zeziko, izitsha zokosa inyama, amafotsholo lemiganu yokuchelisa. Phezu kwalo kumele bendlale isembeso sezikhumba zezinyamazana babe sebefaka izibambo zokuthwalisa endaweni yazo. ");
INSERT INTO nde_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Ngemva kokuba u-Aroni lamadodana akhe sebeqedile ukwembesa impahla zonke ezendawo engcwele lazozonke izinto ezingcwele, kanye lokuthi sebelungele ukusuka, amaKhohathi yiwo okumele eze azothwala. Kodwa akumelanga bathinte izinto ezingcwele ngoba bazakufa. AmaKhohathi azathwala lezozinto ezisethenteni lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","U-Eliyazari indodana ka-Aroni, umphristi, uzakhangela amafutha esibane, impepha, umnikelo ojayelekileyo wamabele lamafutha okugcoba abakhethiweyo. Uzagcina ithabanikeli ngonanzelelo layo yonke into ephakathi kwalo, kanye lempahla ezingcwele lezitsha zalo.” ");
INSERT INTO nde_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","UThixo watshela uMosi lo-Aroni wathi, ");
INSERT INTO nde_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Nanzelelani ukuthi izizwe zosendo lwamaKhohathi azehlukaniswa labaLevi. ");
INSERT INTO nde_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Lokhu kuyikuthi baphile bengafi nxa bethe basondela phansi kwezinto ezingcwelengcwele, balungiseleni lokhu: U-Aroni lamadodana akhe bazakuya endaweni engcwele bayekwabela indoda yinye ngayinye umsebenzi wayo kanye lalokho okumele bakuthwale. ");
INSERT INTO nde_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Kodwa amaKhohathi akumelanga angene ukuthi ayebona izinto ezingcwele, loba okomzuzwana nje kuphela, ngoba bazakufa.” ");
INSERT INTO nde_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Bala njalo amaGeshoni ngezindlu langosendo lwawo. ");
INSERT INTO nde_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Bala wonke amadoda kusukela kwabaleminyaka engamatshumi amathathu kusiya kwabaleminyaka engamatshumi amahlanu yokuzalwa labo abezayo ukuzosebenza ethenteni lokuHlangana. ");
INSERT INTO nde_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Lo ngumsebenzi okumele wenziwe ngabosendo lwamaGeshoni ekusebenzeni kwabo lekuthwaleni kwabo imithwalo: ");
INSERT INTO nde_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Bazathwala amakhetheni ethabanikeli, ithente lokuhlangana, isembeso salo kanye lesangaphandle esezikhumba zezinyamazana, amakhetheni entuba yethente lokuhlangana, ");
INSERT INTO nde_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","amakhetheni eguma elihonqolozele ithabanikeli le-alithari, ikhetheni lesango, izintambo lakho konke okusetshenziswa kulo umsebenzi. AmaGeshoni azakwenza konke okumele kwenziwe ngalezizinto. ");
INSERT INTO nde_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Imisebenzi yabo yonke abayenzayo, kumbe yikuthwala kumbe ngumsebenzi othile, bazayenza ngokuqondisa kuka-Aroni lamadodana akhe. Uzabapha kube ngumlandu wabo ukuthwala lokho ozabe uthe bakuthwale. ");
INSERT INTO nde_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Lokhu kuzakuba ngumsebenzi wabosendo lwamaGeshoni ethenteni lokuhlangana. Umsebenzi wabo bazawenza ngokuqondisa kuka-Ithamari indodana ka-Aroni, umphristi.” ");
INSERT INTO nde_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Bala amaMerari ngosendo langezindlu zawo. ");
INSERT INTO nde_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Bala wonke amadoda kusukela kwabaleminyaka engamatshumi amathathu kusiya kwabaleminyaka engamatshumi amahlanu yokuzalwa abezayo ukusebenza ethenteni lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Lo yiwo ozakuba ngumsebenzi wabo ethenteni lokuhlangana: ukuthwala amathala ethabanikeli, imithando yalo, izinsika lezisekelo, ");
INSERT INTO nde_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","kanye lezinsika ezihonqolozele iguma kanye lezisekelo zazo, izikhonkwane zethente, amagoda, izitsha zakhona lakho konke okuhambelana lokusetshenziswa kwazo. Batshengise bonke munye ngamunye lezozinto abafanele bazithwale. ");
INSERT INTO nde_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Lo yiwo umsebenzi ozakwenziwa ngabosendo lwamaMerari ekusebenzeni kwabo ethenteni lokuhlangana beqondiswa ngu-Ithamari indodana ka-Aroni, umphristi.” ");
INSERT INTO nde_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","UMosi, u-Aroni labakhokheli babantu babala amaKhohathi ngosendo langezindlu zawo. ");
INSERT INTO nde_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Wonke amadoda aleminyaka esukela kwabaleminyaka engamatshumi amathathu kusiya kwabaleminyaka engamatshumi amahlanu abezayo ukusebenza ethenteni lokuhlangana, ");
INSERT INTO nde_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","bebalwa ngensendo, babazinkulungwane ezimbili lamakhulu ayisikhombisa alamatshumi amahlanu (2,750). ");
INSERT INTO nde_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Leli linani eligcweleyo lalabo abosendo lwamaKhohathi abasebenza ethenteni lokuhlangana. UMosi lo-Aroni babala njengokulaywa kwabo nguThixo etshela uMosi. ");
INSERT INTO nde_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","AmaGeshoni abalwa ngensendo langezindlu zawo. ");
INSERT INTO nde_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Wonke amadoda aleminyaka yokuzalwa engamatshumi amathathu kusiya kwabaleminyaka engamatshumi amahlanu ababesebenza ethenteni lokuhlangana, ");
INSERT INTO nde_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","bebalwa ngensendo langezindlu zabo, babazinkulungwane ezimbili lamakhulu ayisithupha alamatshumi amathathu (2,630). ");
INSERT INTO nde_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Leli linani eligcweleyo lwensendo zamaGeshoni abasebenza ethenteni lokuhlangana. UMosi lo-Aroni babala njengokulaywa kwabo nguThixo. ");
INSERT INTO nde_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","AmaMerari abalwa ngensendo langezindlu zawo. ");
INSERT INTO nde_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Wonke amadoda ayeleminyaka yokuzalwa esukela kwabalamatshumi amathathu kusiya kwabaleminyaka engamatshumi amahlanu ababezosebenza ethenteni lokuhlangana, ");
INSERT INTO nde_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","sebebaliwe ngensendo zabo, babazinkulungwane ezintathu lamakhulu amabili (3,200). ");
INSERT INTO nde_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Leli kwaba linani eligcweleyo kwabosendo lwamaMerari. UMosi lo-Aroni babala njengokulaya kukaThixo elaya uMosi. ");
INSERT INTO nde_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Ngalokho uMosi, u-Aroni labakhokheli bako-Israyeli babala bonke abaLevi ngensendo langezindlu zabo. ");
INSERT INTO nde_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Wonke amadoda asukela kwabaleminyaka engamatshumi amathathu kusiya kwabaleminyaka engamatshumi amahlanu yokuzalwa abeza ukulungisa kanye lokuthwala ithente lokuhlangana ");
INSERT INTO nde_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","babezinkulungwane eziyisificaminwembili lamakhulu amahlanu alamatshumi ayisificaminwembili (8,580). ");
INSERT INTO nde_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Ngokulaya kukaThixo elaya uMosi, ngulowo lalowo wabelwa umsebenzi wakhe ayezawenza lokwakumele akuthwale. Yiyo le indlela ababalwa ngayo, njengokulaywa kukaMosi nguThixo. ");
INSERT INTO nde_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Tshela abako-Israyeli ukuthi basuse ezihonqweni wonke olobulephero loba ophuma ubovu loba bungobunjani, loba engongcolileyo ngokomkhuba ngenxa yesidumbu sofileyo. ");
INSERT INTO nde_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Susani ngokufananayo loba ngowesilisa loba ngowesifazane; kumele limsuse ukuze angangcolisi isihonqo sakwabo; ngoba ngihlala khona phakathi kwabo.” ");
INSERT INTO nde_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Abako-Israyeli bakwenza lokho; babakhuphela ngaphandle kwezihonqo. Bakwenza njengokulaywa kukaMosi nguThixo. ");
INSERT INTO nde_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Tshono kwabako-Israyeli uthi: ‘Nxa indoda loba umfazi onele omunye loba ngayiphi indlela etshengisele ukungathembeki kuThixo, lowomuntu ulomlandu ");
INSERT INTO nde_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","njalo kumele avume isono sakhe. Kahlawule ngokugcweleyo icala lakhe, engezelele ingxenye yesihlanu ekuhlawuleni lowo amoneleyo. ");
INSERT INTO nde_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Kodwa uba lowo engelasihlobo okungahlawulwa kuso icala, inhlawulo ngekaThixo, kodwa lizaphiwa umphristi, kanye lenqama azamenzela ngayo indlela yokubuyisana. ");
INSERT INTO nde_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Izipho zonke ezingcwele ezilethwa ngabako-Israyeli kumphristi zizakuba ngezakhe. ");
INSERT INTO nde_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Izipho zendoda inye ngayinye ezingcwele ngezayo, kodwa lokho indoda ezakupha umphristi ngokomphristi.’ ” ");
INSERT INTO nde_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Khuluma labako-Israyeli ubatshele ukuthi: ‘Nxa umfazi wendoda ephambuka engathembeki endodeni ");
INSERT INTO nde_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ngokulala lamanye amadoda kodwa lokhu kungesobala endodeni yakhe lehlazo lelo lingabonakali (njengoba kungelamfakazi njalo engabanjwanga ekwenza), ");
INSERT INTO nde_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","kodwa indoda ikhulelwe yibukhwele ibisimnakanela umfazi wayo ukuthi ungcolile, loba ilobukhwele imnakanela kodwa yena engangcolanga, ");
INSERT INTO nde_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","kumele ithathe umfazi wayo iye laye kumphristi. Phezu kwalokho kumele imphathele ifulawa yebhali eyingxenye yetshumi yehefa. Akumelanga ithele amafutha e-oliva phezu kwayo loba afake impepha phezu kwayo ngoba kungumnikelo wobukhwele wamabele, umnikelo wokubonisa ukuthi kulecala. ");
INSERT INTO nde_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Umphristi uzamletha owesifazane amise phambi kukaThixo. ");
INSERT INTO nde_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Abesethatha amanzi angcwele ngembiza yomdaka athele emanzini uthuli olubuthwe phansi ethabanikeleni. ");
INSERT INTO nde_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Ngemva kokuba umphristi eseke wamisa owesifazane phambi kukaThixo kumele atshombulule inwele zakhe abesefaka ezandleni zakhe umnikelo wokukhumbuza, umnikelo wobukhwele wamabele, umphristi yena uzabe ephethe amanzi ababayo aletha isithuko. ");
INSERT INTO nde_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Ngalokho-ke umphristi uzafungisa owesifazane athi kuye, “Nxa kungelandoda eke yalala lawe loba ungazange uphambuke ungcole wena wendile, akuthi lamanzi ababayo aletha isithuko angakulimazi. ");
INSERT INTO nde_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Kodwa nxa uphambukile wena wendile wazingcolisa ngokulala lenye indoda engasumkakho,” ");
INSERT INTO nde_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","lapho umphristi kufanele afungise owesifazane ngesithuko lesi athi, “sengathi uThixo angenza abakini bakuthuke, bakuhlamukele lapho ekwenza ukuba uswele kuthi isisu sakho sikhukhumale. ");
INSERT INTO nde_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Akuthi amanzi la aletha isithuko angene emzimbeni wakho ukuze isisu sakho sikhukhumale kumbe uswele.” Ngakho owesifazane uzakuthi, “Ameni. Akube njalo.” ");
INSERT INTO nde_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Umphristi uzaloba lezi zithuko ogwalweni azigezisele emanzini ababayo. ");
INSERT INTO nde_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Uzanathisa owesifazane amanzi ababayo aletha isithuko, wona amanzi azamzwisa ubuhlungu nxa esewanathile. ");
INSERT INTO nde_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Umphristi uzasusa ezandleni zowesifazane umnikelo wamabele obukhwele, awuzunguze phambi kukaThixo abesewuletha e-alithareni. ");
INSERT INTO nde_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Umphristi abesechupha-ke ngesandla umnikelo wamabele njengomnikelo wesikhumbuzo awutshisele e-alithareni; ngemva kwalokho kumele anathise owesifazane amanzi la. ");
INSERT INTO nde_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Nxa ezingcolisile ngokungathembeki kumkakhe, kuzakuthi lapho enatha amanzi aletha isithuko, angene emzimbeni abangele ubuhlungu; isisu sakhe sizakhukhumala njalo aswele, abe ngoqalekisiweyo ebantwini bakibo. ");
INSERT INTO nde_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Kodwa-ke nxa lo owesifazane engazingcolisanga, emsulwa, uzakhululwa kulelo cala abelakho ukuthola inzalo. ");
INSERT INTO nde_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Ngakho-ke, lo yiwo umlayo wobukhwele nxa owesifazane ephambukile wazingcolisa yena endile, ");
INSERT INTO nde_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","loba nxa indoda ifikelwa yibukhwele ngoba ilesazela ngomkayo. Umphristi uzamisa owesifazane phambi kukaThixo asebenzise lumlayo ngokugcweleyo kowesifazane. ");
INSERT INTO nde_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Indoda izabe imsulwa ekoneni konke, kodwa owesifazane uzathwala izehlakalo zonke zesono sakhe.’ ” ");
INSERT INTO nde_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Khuluma labako-Israyeli ubatshele lokhu: ‘Nxa owesilisa loba owesifazane efuna ukwenza isifungo esibalulekileyo, isifungo sokuzahlukanisela kuThixo ukuba abe ngumNaziri, ");
INSERT INTO nde_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","kumele angabe esanatha iwayini loba yikuphi okunathwayo okulemvubelo njalo akumelanga ukuthi anathe iviniga eyenziwe ngewayini loba okunathwayo okulemvubelo. Kanganathi umhluzi wezithelo zevini, njalo angadli izithelo zevini ezimanzi loba ezomileyo. ");
INSERT INTO nde_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Nxa elokhu engumNaziri kangadli lutho oluvela esivinini kungakhathalekile ukuthi zintanga loba ngamakhasi esithelo. ");
INSERT INTO nde_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Ngasosonke isikhathi esemi esifungweni sokuzahlukanisela akumelanga kube lempuco ekhanda lakhe. Kumele abengcwele size sedlule isikhathi sakhe sokuzahlukanisela uThixo; kayekele inwele zakhe zikhule zibende. ");
INSERT INTO nde_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Kusosonke isikhathi sakhe sokuzahlukanisela uThixo kangasondeli esidunjini. ");
INSERT INTO nde_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Loba kungaze kube kufe uyise loba unina loba umfowabo loba udadewabo, akumelanga azingcolise ngokomkhuba ngenxa yabo, ngoba uphawu lokuzahlukanisela uNkulunkulu lusekhanda lakhe. ");
INSERT INTO nde_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Ngasosonke isikhathi sokuzahlukanisela kwakhe ungokhethiweyo kuThixo. ");
INSERT INTO nde_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Nxa kungafa umuntu emehlweni akhe, ngakho besekungcolisa inwele zakhe asezinikele, kumele aphuce ikhanda ngosuku lokuhlanjululwa kwakhe, usuku lwesikhombisa. ");
INSERT INTO nde_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Ngakho ngosuku lwesificaminwembili kalethe kumphristi esangweni lethente lokuhlangana amajuba amabili loba inkwilimba ezincane ezimbili. ");
INSERT INTO nde_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Umphristi uzanikela umnikelo wesono ngenye inyoni kuthi enye ibe ngumnikelo wokutshiswa ukumenzela indlela yokubuyisana ngoba enze isono ngoba lapho okulesidumbu khona. Ngalo lolosuku kumele angcwelise ikhanda lakhe. ");
INSERT INTO nde_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Kazinikele kuThixo okwesikhathi leso azahlukanisele sona njalo alethe izinyane lemvu elilomnyaka owodwa eliduna libe njengomnikelo wecala. Insuku ezadlulayo kazibalwa, ngoba ube ngongcolileyo ngesikhathi sokuzahlukanisela kwakhe. ");
INSERT INTO nde_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Lo ngumlayo womNaziri nxa isikhathi sakhe sokuzahlukanisela sesiphelile. Kumele alethwe esangweni lethente lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Kethule lapho umnikelo wakhe kuThixo: izinyane lemvu elilomnyaka owodwa eliduna elingelasici libe ngumnikelo wokutshiswa, izinyane lemvu elisikazi elilomnyaka owodwa elingelasici libe ngumnikelo wesono, inqama engelasici ibe ngumnikelo wobudlelwano, ");
INSERT INTO nde_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ndawonye leminikelo yamabele leyokunathwayo, kanye lesitsha sesinkwa esingelamvubelo, amakhekhe enziwe ngefulawa ecolekileyo ixutshwe ngamafutha, njalo lamaqebelengwane agcotshwe ngamafutha. ");
INSERT INTO nde_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Umphristi uzakwethula lokhu phambi kukaThixo enze umnikelo wesono lowokutshiswa. ");
INSERT INTO nde_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Umphristi uzakwethula isitsha esilesinkwa esingelamvubelo njalo enze umhlatshelo ngenqama kube ngumnikelo wobudlelwano kuThixo, ndawonye lomnikelo wakho wamabele lowokunathwayo. ");
INSERT INTO nde_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Ngakho umNaziri uzaphucela inwele zakhe zokwahlukanisela esangweni lethente lokuhlangana. Uzaphosela inwele lezo emlilweni ongaphansi komnikelo wobudlelwano. ");
INSERT INTO nde_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Nxa umNaziri esephuce inwele zokuzahlukanisela kwakhe, umphristi uzabeka ezandleni zakhe umkhono wenqama ephekiweyo, kanye lekhekhe leqebelengwane esitsheni, kokubili kungela mvubelo. ");
INSERT INTO nde_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Umphristi uzakuzunguza phambi kukaThixo njengomnikelo wokuzunguzwa; kungcwele njalo kungokomphristi, kuhlanganisela lesifuba esizunguziweyo kanye lomlenze owethuliweyo. Ngemva kwalokho, umNaziri usenganatha iwayini. ");
INSERT INTO nde_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Lo ngumlayo womNaziri ofunga ngokunikela kuThixo kusiya ngokuzahlukanisela, kuyikwengeza kulokho ayabe ekwenelisile. Kagcwalise isifungo asenzileyo, ngokomlayo womNaziri.’ ” ");
INSERT INTO nde_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Tshela u-Aroni lamadodana akhe uthi, ‘Le yiyo indlela elizabusisa ngayo abako-Israyeli. Khulumani lithi kubo: ");
INSERT INTO nde_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“UThixo alibusise njalo aligcine; ");
INSERT INTO nde_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","UThixo kakhazimulise ubuso bakhe phezu kwenu njalo abe lomusa kini; ");
INSERT INTO nde_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","UThixo kakhangelise ubuso bakhe kini njalo aliphe ukuthula.” ’ ");
INSERT INTO nde_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Ngokunjalo bazabiza ibizo lami phezu kwabako-Israyeli, mina ngizababusisa.” ");
INSERT INTO nde_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Kwathi uMosi eseqedile ukumisa ithabanikeli, waligcoba njalo walibusisa kanye lempahla yalo yonke. Wabuye wagcoba njalo wabusisa i-alithari kanye lezitsha zalo zonke. ");
INSERT INTO nde_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Kwasekusithi abakhokheli bako-Israyeli, inhloko zezimuli ezazingabakhokheli zensendo ziphethe labo ababebalwa, zanikela. ");
INSERT INTO nde_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Zaletha izipho zazo kuThixo, izinqola eziyisithupha ezembesiweyo lenkabi ezilitshumi lambili, kuyikuthi umkhokheli munye anikele ngenkabi eyodwa kuthi ababili bahlanganyele inqola eyodwa. Lokhu bakuletha ethabanikeleni. ");
INSERT INTO nde_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Yamukela izipho ezivela kubo ukuze zisetshenziswe ethenteni lokuhlangana. Yabela abaLevi kusiya ngomsebenzi wendoda yinye ngayinye.” ");
INSERT INTO nde_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Ngakho uMosi wathatha izinqola kanye lenkabi wazinika abaLevi. ");
INSERT INTO nde_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Wanika abakoGeshoni izinqola ezimbili kanye lenkabi ezine, kusiya ngomsebenzi wabo, ");
INSERT INTO nde_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","abakoMerari bona wabapha izinqola ezine kanye lenkabi eziyisificaminwembili, kusiya ngomsebenzi wabo. Bonke babelawulwa ngu-Ithamari indodana ka-Aroni, umphristi. ");
INSERT INTO nde_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Kodwa uMosi kazange aphe lokukodwa kumaKhohathi, ngenxa yokuthi kwakungumlandu wabo wokuthwala ngamahlombe abo zonke izinto ezingcwele. ");
INSERT INTO nde_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Ekugcotshweni kwe-alithari, abakhokheli baletha phambi kwalo iminikelo yabo yokulahlukanisela. ");
INSERT INTO nde_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Ngoba uThixo wayethe kuMosi, “Umkhokheli oyedwa ngelanga uzaletha umnikelo wakhe wokwahlukaniselwa kwe-alithari.” ");
INSERT INTO nde_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Owaletha umnikelo wakhe ngosuku lwakuqala nguNahashoni indodana ka-Aminadabi owesizwana sakoJuda. ");
INSERT INTO nde_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Umnikelo wakhe: wawungumganu wesiliva isisindo sawo singamashekeli alikhulu lamatshumi amathathu, lomganu oyingubhe wokuchela wesiliva, isisindo sawo ungamashekeli angamatshumi ayisikhombisa, yomibili kulinganiswa ngeshekeli lendlu engcwele, ngamunye ugcwele ifulawa ecolekileyo ixutshaniswe lamafutha njengomnikelo wamabele; ");
INSERT INTO nde_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","inditshi yegolide eyodwa elesisindo esingamashekeli alitshumi, igcwele impepha; ");
INSERT INTO nde_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","inkunzi eliguqa, inqama eyodwa lezinyane lemvu eliduna elilomnyaka owodwa, kungumnikelo wokutshiswa; ");
INSERT INTO nde_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","impongo eyodwa kungumnikelo wesono; ");
INSERT INTO nde_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","kanye lenkabi ezimbili, inqama ezinhlanu, impongo ezinhlanu kanye lamazinyane amaduna ezimvu alomnyaka owodwa, ukuze kube ngumhlatshelo womnikelo wobudlelwano. Lo kwaba ngumnikelo kaNahashoni indodana ka-Aminadabi. ");
INSERT INTO nde_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Ngosuku lwesibili uNethaneli indodana kaZuwari umkhokheli wabendlu ka-Isakhari, waletha umnikelo wakhe. ");
INSERT INTO nde_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Umnikelo awulethayo: kwakungumganu wesiliva isisindo sawo ungamashekeli alikhulu elilamatshumi amathathu, lomganu owodwa wesiliva oyingubhe owokuchela olesisindo samashekeli angamatshumi ayisikhombisa, yomibili kulinganiswa ngeshekeli lendlu engcwele, ngamunye ugcwele ifulawa ecolekileyo ixutshaniswe lamafutha njengomnikelo wamabele; ");
INSERT INTO nde_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","inditshi yegolide eyodwa elesisindo esingamashekeli alitshumi, igcwele impepha; ");
INSERT INTO nde_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","inkunzi eliguqa, inqama eyodwa kanye lezinyane lemvu eliduna elilomnyaka owodwa, kungumnikelo wokutshiswa; ");
INSERT INTO nde_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","impongo eyodwa kungumnikelo wesono; ");
INSERT INTO nde_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","lenkabi ezimbili, inqama ezinhlanu, impongo ezinhlanu kanye lamazinyane ezimvu amahlanu alomnyaka owodwa, kube ngumhlatshelo womnikelo wobudlelwano. Lo kwaba ngumnikelo kaNethaneli indodana kaZuwari. ");
INSERT INTO nde_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Ngosuku lwesithathu, u-Eliyabi indodana kaHeloni, umkhokheli wabantu bakaZebhuluni, waletha umnikelo wakhe. ");
INSERT INTO nde_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Umnikelo wakhe: wawungumganu wesiliva olesisindo esingamashekeli alikhulu lamatshumi amathathu, lomganu wesiliva oyingubhe wokuchela olesisindo esingamashekeli angamatshumi ayisikhombisa, yomibili ibe lesilinganiso samashekeli endlu engcwele, ngamunye ugcwele ifulawa ecolekileyo, exutshaniswe lamafutha njengomnikelo wamabele; ");
INSERT INTO nde_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","inditshi yegolide eyodwa elesisindo esingamashekeli alitshumi, igcwele impepha; ");
INSERT INTO nde_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","inkunzi eliguqa, inqama kanye lezinyane eliduna lemvu elilomnyaka owodwa, kungumnikelo wokutshiswa; ");
INSERT INTO nde_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","impongo eyodwa kungumnikelo wesono; ");
INSERT INTO nde_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","kanye lenkabi ezimbili, inqama ezinhlanu, impongo ezinhlanu kanye lamazinyane ezimvu amaduna alomnyaka owodwa, kube ngumhlatshelo womnikelo wobudlelwano. Lo kwakungumnikelo ka-Eliyabi indodana kaHeloni. ");
INSERT INTO nde_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Ngosuku lwesine u-Elizuri indodana kaShedewuri, umkhokheli wabantu bakaRubheni, waletha umnikelo wakhe. ");
INSERT INTO nde_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Umnikelo wakhe: wawungumganu wesiliva olesisindo esingamashekeli alikhulu lamatshumi amathathu, lomganu wesiliva oyingubhe wokuchela olesisindo esingamashekeli angamatshumi ayisikhombisa, yomibili ibe lesilinganiso samashekeli endlu engcwele, ngamunye ugcwele ifulawa ecolekileyo exutshaniswe lamafutha njengomnikelo wamabele; ");
INSERT INTO nde_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","inditshi yegolide eyodwa elesisindo esingamashekeli alitshumi, igcwele impepha; ");
INSERT INTO nde_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","inkunzi eliguqa, inqama eyodwa kanye lezinyane eliduna lemvu elilomnyaka owodwa, kungumnikelo wokutshiswa; ");
INSERT INTO nde_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","impongo eyodwa kungumnikelo wesono; ");
INSERT INTO nde_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","kanye lenkabi ezimbili, inqama ezinhlanu, impongo ezinhlanu kanye lamazinyane ezimvu amaduna amahlanu alomnyaka owodwa kube ngumhlatshelo womnikelo wobudlelwano. Lo kwakungumnikelo ka-Elizuri indodana kaShedewuri. ");
INSERT INTO nde_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Ngosuku lwesihlanu uShelumiyeli indodana kaZurishadayi, umkhokheli wabantu bakaSimiyoni waletha umnikelo wakhe. ");
INSERT INTO nde_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Umnikelo wakhe: wawungumganu wesiliva olesisindo esingamashekeli alikhulu lamatshumi amathathu, lomganu wesiliva oyingubhe wokuchela olesisindo esingamashekeli angamatshumi ayisikhombisa, yomibili ibe lesilinganiso samashekeli endlu engcwele, ngamunye ugcwele ifulawa ecolekileyo exutshaniswe lamafutha njengomnikelo wamabele; ");
INSERT INTO nde_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","inditshi yegolide eyodwa elesisindo esingamashekeli alitshumi, igcwele impepha; ");
INSERT INTO nde_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","inkunzi eliguqa, inqama eyodwa kanye lezinyane eliduna lemvu elilomnyaka owodwa, kungumnikelo wokutshiswa; ");
INSERT INTO nde_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","impongo eyodwa kungumnikelo wesono; ");
INSERT INTO nde_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","kanye lenkabi ezimbili, lenqama ezinhlanu, impongo ezinhlanu kanye lamazinyane ezimvu amaduna amahlanu alomnyaka owodwa kube ngumhlatshelo womnikelo wobudlelwano. Lo kwakungumnikelo kaShelumiyeli indodana kaZurishadayi. ");
INSERT INTO nde_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Ngosuku lwesithupha u-Eliyasafi indodana kaDuweli, umkhokheli wabantu bakaGadi, waletha umnikelo wakhe. ");
INSERT INTO nde_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Umnikelo wakhe: wawungumganu wesiliva olesisindo esingamashekeli alikhulu lamatshumi amathathu, lomganu wesiliva oyingubhe wokuchela olesisindo esingamashekeli angamatshumi ayisikhombisa, yomibili ibe lesilinganiso samashekeli endlu engcwele, ngamunye ugcwele ifulawa ecolekileyo exutshaniswe lamafutha njengomnikelo wamabele; ");
INSERT INTO nde_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","inditshi yegolide eyodwa elesisindo esingamashekeli alitshumi, igcwele impepha; ");
INSERT INTO nde_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","inkunzi eliguqa, inqama eyodwa kanye lezinyane eliduna lemvu elilomnyaka owodwa, kungumnikelo wokutshiswa; ");
INSERT INTO nde_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","impongo eyodwa kungumnikelo wesono; ");
INSERT INTO nde_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","kanye lenkabi ezimbili, inqama ezinhlanu, impongo ezinhlanu kanye lamazinyane ezimvu amaduna amahlanu alomnyaka owodwa kube ngumhlatshelo womnikelo wobudlelwano. Lo kwakungumnikelo ka-Eliyasafi indodana kaDuweli. ");
INSERT INTO nde_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Ngosuku lwesikhombisa u-Elishama indodana ka-Amihudi, umkhokheli wabantu baka-Efrayimi, waletha umnikelo wakhe. ");
INSERT INTO nde_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Umnikelo wakhe: wawungumganu wesiliva olesisindo esingamashekeli alikhulu lamatshumi amathathu, lomganu wesiliva oyingubhe wokuchela olesisindo esingamashekeli angamatshumi ayisikhombisa, yomibili ibe lesilinganiso samashekeli endlu engcwele, ngamunye ugcwele ifulawa ecolekileyo exutshaniswe lamafutha njengomnikelo wamabele; ");
INSERT INTO nde_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","inditshi yegolide eyodwa elesisindo esingamashekeli alitshumi igcwele impepha; ");
INSERT INTO nde_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","inkunzi eliguqa, inqama eyodwa kanye lezinyane eliduna lemvu elilomnyaka owodwa, kungumnikelo wokutshiswa; ");
INSERT INTO nde_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","impongo eyodwa kungumnikelo wesono; ");
INSERT INTO nde_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","kanye lenkabi ezimbili, inqama ezinhlanu, impongo ezinhlanu kanye lamazinyane ezimvu amaduna amahlanu alomnyaka owodwa ukuba kube ngumhlatshelo womnikelo wobudlelwano. Lo kwakungumnikelo ka-Elishama indodana ka-Amihudi. ");
INSERT INTO nde_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Ngosuku lwesificaminwembili uGamaliyeli indodana kaPhedazuri, umkhokheli wabantu bakaManase, waletha umnikelo wakhe. ");
INSERT INTO nde_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Umnikelo wakhe: wawungumganu wesiliva olesisindo esingamashekeli alikhulu lamatshumi amathathu, lomganu wesiliva oyingubhe wokuchela olesisindo esingamashekeli angamatshumi ayisikhombisa, yomibili ibe lesilinganiso samashekeli endlu engcwele, ngamunye ugcwele ifulawa ecolekileyo exutshaniswe lamafutha njengomnikelo wamabele; ");
INSERT INTO nde_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","inditshi yegolide eyodwa elesisindo esingamashekeli alitshumi, igcwele impepha; ");
INSERT INTO nde_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","inkunzi eliguqa, inqama eyodwa kanye lezinyane eliduna lemvu elilomnyaka owodwa, kungumnikelo wokutshiswa; ");
INSERT INTO nde_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","impongo eyodwa kungumnikelo wesono; ");
INSERT INTO nde_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","kanye lenkabi ezimbili, inqama ezinhlanu, impongo ezinhlanu kanye lamazinyane ezimvu amaduna amahlanu alomnyaka owodwa kube ngumhlatshelo womnikelo wobudlelwano. Lo kwakungumnikelo kaGamaliyeli indodana kaPhedazuri. ");
INSERT INTO nde_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Ngosuku lwesificamunwemunye u-Abhidani indodana kaGidiyoni, umkhokheli wabantu bakaBhenjamini, waletha umnikelo wakhe. ");
INSERT INTO nde_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Umnikelo wakhe: wawungumganu wesiliva olesisindo esingamashekeli alikhulu lamatshumi amathathu, lomganu wesiliva oyingubhe wokuchela olesisindo esingamashekeli angamatshumi ayisikhombisa, yomibili ibe lesilinganiso samashekeli endlu engcwele, ngamunye ugcwele ifulawa ecolekileyo exutshaniswe lamafutha njengomnikelo wamabele; ");
INSERT INTO nde_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","inditshi yegolide eyodwa elesisindo esingamashekeli alitshumi, igcwele impepha; ");
INSERT INTO nde_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","inkunzi eliguqa, inqama eyodwa kanye lezinyane eliduna lemvu elilomnyaka owodwa, kungumnikelo wokutshiswa; ");
INSERT INTO nde_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","impongo eyodwa kungumnikelo wesono; ");
INSERT INTO nde_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","kanye lenkabi ezimbili, inqama ezinhlanu, impongo ezinhlanu kanye lamazinyane ezimvu amaduna amahlanu alomnyaka owodwa, kube ngumhlatshelo womnikelo wobudlelwano. Lo kwakungumnikelo ka-Abhidani indodana kaGidiyoni. ");
INSERT INTO nde_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Ngosuku lwetshumi u-Ahiyezeri indodana ka-Amishadayi, umkhokheli wabantu bakaDani, waletha umnikelo wakhe. ");
INSERT INTO nde_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Umnikelo wakhe: wawungumganu wesiliva olesisindo esingamashekeli alikhulu lamatshumi amathathu, lomganu wesiliva oyingubhe wokuchela olesisindo esingamashekeli angamatshumi ayisikhombisa, yomibili ibe lesilinganiso samashekeli endlu engcwele, ngamunye ugcwele ifulawa ecolekileyo exutshaniswe lamafutha njengomnikelo wamabele; ");
INSERT INTO nde_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","inditshi yegolide eyodwa elesisindo esingamashekeli alitshumi, igcwele impepha; ");
INSERT INTO nde_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","inkunzi eliguqa, inqama eyodwa kanye lezinyane eliduna lemvu elilomnyaka owodwa, kungumnikelo wokutshiswa; ");
INSERT INTO nde_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","impongo eyodwa kungumnikelo wesono; ");
INSERT INTO nde_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","kanye lenkabi ezimbili, inqama ezinhlanu, impongo ezinhlanu kanye lamazinyane ezimvu amaduna amahlanu alomnyaka owodwa, kube ngumhlatshelo womnikelo wobudlelwano. Lo kwakungumnikelo ka-Ahiyezeri indodana ka-Amishadayi. ");
INSERT INTO nde_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Ngosuku lwetshumi lanye uPhagiyeli indodana ka-Okhirani, umkhokheli wabantu baka-Asheri, waletha umnikelo wakhe. ");
INSERT INTO nde_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Umnikelo wakhe: wawungumganu wesiliva olesisindo esingamashekeli alikhulu lamatshumi amathathu, lomganu wesiliva oyingubhe wokuchela olesisindo esingamashekeli angamatshumi ayisikhombisa, yomibili ibe lesilinganiso samashekeli endlu engcwele, ngamunye ugcwele ifulawa ecolekileyo exutshaniswe lamafutha njengomnikelo wamabele; ");
INSERT INTO nde_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","inditshi yegolide eyodwa elesisindo esingamashekeli alitshumi, igcwele impepha; ");
INSERT INTO nde_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","inkunzi eliguqa, inqama eyodwa kanye lezinyane eliduna lemvu elilomnyaka owodwa, kungumnikelo wokutshiswa; ");
INSERT INTO nde_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","impongo eyodwa kungumnikelo wesono; ");
INSERT INTO nde_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","kanye lenkabi ezimbili, inqama ezinhlanu, impongo ezinhlanu kanye lamazinyane ezimvu amaduna amahlanu alomnyaka owodwa, kube ngumhlatshelo womnikelo wobudlelwano. Lo kwakungumnikelo kaPhagiyeli indodana ka-Okhirani. ");
INSERT INTO nde_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Ngosuku lwetshumi lambili u-Ahira indodana ka-Enani, umkhokheli wabantu bakaNafithali, waletha umnikelo wakhe. ");
INSERT INTO nde_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Umnikelo wakhe: wawungumganu wesiliva olesisindo esingamashekeli alikhulu lamatshumi amathathu, lomganu wesiliva oyingubhe wokuchela olesisindo esingamashekeli angamatshumi ayisikhombisa, yomibili ibe lesilinganiso samashekeli endlu engcwele, ngamunye ugcwele ifulawa ecolekileyo exutshaniswe lamafutha njengomnikelo wamabele; ");
INSERT INTO nde_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","inditshi yegolide eyodwa elesisindo esingamashekeli alitshumi, igcwele impepha; ");
INSERT INTO nde_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","inkunzi eliguqa, inqama eyodwa kanye lezinyane eliduna lemvu elilomnyaka owodwa, kungumnikelo wokutshiswa; ");
INSERT INTO nde_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","impongo eyodwa kungumnikelo wesono; ");
INSERT INTO nde_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","kanye lenkabi ezimbili, inqama ezinhlanu, impongo ezinhlanu kanye lamazinyane ezimvu amaduna amahlanu alomnyaka owodwa, kube ngumhlatshelo womnikelo wobudlelwano. Lo kwakungumnikelo ka-Ahira indodana ka-Enani. ");
INSERT INTO nde_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Le yayiyiminikelo yabakhokheli bako-Israyeli yokwahlukaniselwa kwe-alithari mhla ligcotshwa: imiganu elitshumi lambili yesiliva, imiganu yokuchela yesiliva eyingubhe elitshumi lambili kanye lenkezo zegolide ezilitshumi lambili. ");
INSERT INTO nde_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Umganu munye wesiliva ulesisindo samashekeli alikhulu lamatshumi amathathu, njalo umganu oyingubhe wokuchela ngamunye ulesisindo samashekeli angamatshumi ayisikhombisa. Sezihlangene, izitsha zesiliva zazilesisindo esingamashekeli azinkulungwane ezimbili lamakhulu amane, kulinganiswa ngesisindo seshekeli lendlu engcwele. ");
INSERT INTO nde_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Izinditshi ezilitshumi lambili zegolide zigcwele impepha zilesisindo samashekeli alitshumi inye, kulinganiswa ngesisindo seshekeli lendlu engcwele. Sezindawonye, inkezo zegolide zilesisindo samashekeli alikhulu elilamatshumi amabili. ");
INSERT INTO nde_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Inani lezinyamazana zonke ezomnikelo wokutshiswa zazibalisa itshumi lambili lenkunzi ezingamaguqa, itshumi lambili lenqama kanye letshumi lambili lamazinyane ezimvu amaduna alomnyaka owodwa, kanye lomnikelo wazo wamabele. Impongo ezilitshumi lambili zaba ngezomnikelo wesono. ");
INSERT INTO nde_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Sezihlangene zonke izinyamazana zomhlatshelo womnikelo wobudlelwano kwaba zinkabi ezingamatshumi amabili lane, inqama ezingamatshumi ayisithupha, impongo ezingamatshumi ayisithupha kanye lamazinyane amaduna ezimvu alomnyaka owodwa angamatshumi ayisithupha. Le kwakuyiminikelo yokwahlukaniselwa kwe-alithari emva kokugcotshwa kwalo. ");
INSERT INTO nde_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Kwathi uMosi engena ethenteni lokuhlangana ukuba ayekhuluma loThixo, wezwa ilizwi likhuluma laye liphuma sengathi liphahlwe ngamakherubhi amabili ngaphezu kwesisibekelo sesihlalo somusa, phezu kwebhokisi lobuFakazi. Wasekhuluma laye. ");
INSERT INTO nde_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Tshono ku-Aroni uthi, ‘Nxa usumisa izibane eziyisikhombisa, kufanele zikhanyise indawo ephambi koluthi lwezibane.’ ” ");
INSERT INTO nde_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","U-Aroni wenza njalo; wamisa izibane oluthini zikhangele phambili, njengokulaywa kukaMosi nguThixo. ");
INSERT INTO nde_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Uluthi lwesibane lwalwenziwe ngale indlela: Lwalwenziwe ngegolide elikhandiweyo kusukela esidindini salo kusiya embaxeni zamaluba alo. Uluthi lwesibane lwenziwa lwafana xathu lalokho uThixo ayekutshengise uMosi. ");
INSERT INTO nde_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","UThixo wathi kuMosi: ");
INSERT INTO nde_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Yahlukanisa abaLevi kwabanye bonke abako-Israyeli ubahlambulule ngokomkhuba. ");
INSERT INTO nde_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Nanku ozakwenza nxa usubahlambulula: Bachele ngamanzi okuhlambulula, uthi baphuce imizimba yabo yonke njalo bagezise izigqoko zabo, bazihlambulule. ");
INSERT INTO nde_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Kabathathe inkunzi eliguqa ndawonye lomnikelo wayo wamabele ayifulawa ecolekileyo exutshaniswe lamafutha; ubusuthatha inkunzi yesibili ibe ngumnikelo wesono. ");
INSERT INTO nde_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Letha abaLevi phambi kwethente lokuhlangana ubusubuthanisa isizwe sonke sako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Letha abaLevi phambi kukaThixo, abako-Israyeli babeke izandla zabo phezu kwabaLevi. ");
INSERT INTO nde_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","U-Aroni kethule abaLevi phambi kukaThixo njengomnikelo wabako-Israyeli wokuzunguzwa, ukuze balungele ukwenza umsebenzi kaThixo. ");
INSERT INTO nde_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Nxa abaLevi sebebeke izandla zabo phezu kwamakhanda enkunzi, uzakwenza umnikelo wesono kuThixo ngenye yazo kanye lomnikelo wokutshiswa, ukwenzela abaLevi indlela yokubuyisana. ");
INSERT INTO nde_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Misa abaLevi phambi kuka-Aroni kanye lamadodana akhe ubethule njengomnikelo wokuzunguzwa phambi kukaThixo. ");
INSERT INTO nde_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Ngalokhu uzabe usubahlukanisile abaLevi kwabanye bonke abako-Israyeli, ngakho abaLevi bazakuba ngabami. ");
INSERT INTO nde_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Ngemva kokuba usuhlambulule wethula abaLevi njengomnikelo wokuzunguzwa, kabeze benze umsebenzi wabo ethenteni lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Bangabako-Israyeli abaphiwe mina ngokugcweleyo. Sengibathethe baba ngabami esikhundleni samazibulo, wonke umntwana ongumfana wokuqala ozelwe ngowesifazane wako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Wonke amazibulo ako-Israyeli, awabantu kumbe awezinyamazana, angawami. Ngazehlukanisela wona mhla ngibulala amazibulo wonke eGibhithe. ");
INSERT INTO nde_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Ngakho-ke sengithethe abaLevi esikhundleni samazibulo wonke angabafana bako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Kubo bonke abako-Israyeli, senginike abaLevi ku-Aroni kanye lamadodana akhe ukuba babe yizipho ukuze benzele abako-Israyeli umsebenzi kanye lendlela yokubuyisana ethenteni lokuhlangana ukuze abako-Israyeli bangahlaselwa yisifo nxa besondela endlini engcwele.” ");
INSERT INTO nde_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","UMosi lo-Aroni kanye labo bonke abako-Israyeli benza njalo kubaLevi njengalokhu uThixo walaya uMosi. ");
INSERT INTO nde_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","AbaLevi bazihlambulula njalo bagezisa izigqoko zabo. Ngakho u-Aroni wabethula phambi kukaThixo njengomnikelo wokuzunguzwa njalo wabenzela indlela yokubuyisana ebahlambulula. ");
INSERT INTO nde_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Ngemva kwalokho, abaLevi beza ethenteni lokuhlangana ukuzokwenza umsebenzi wabo ngaphansi kuka-Aroni kanye lamadodana akhe. Benza njalo kubaLevi njengokulaywa kukaMosi nguThixo. ");
INSERT INTO nde_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Lokhu kuqondane labaLevi: Abesilisa abaleminyaka engamatshumi amabili lanhlanu kusiya phezulu bazakwenza umsebenzi ethenteni lokuhlangana, ");
INSERT INTO nde_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","kodwa asebeleminyaka engamatshumi amahlanu okuzalwa bazamiswa ukuphatha imisebenzi yabo yensuku ngensuku bangabe besasebenza futhi. ");
INSERT INTO nde_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Bangasiza nje abafowabo nxa besenza imisebenzi yabo ethenteni lokuhlangana, kodwa bona ngokwabo bangasebenzi. Le yiyo-ke indlela ozakupha ngayo abaLevi imisebenzi.” ");
INSERT INTO nde_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Ngenyanga yakuqala ngomnyaka wesibili ngemva kokuphuma kwabo eGibhithe uThixo wakhuluma loMosi enkangala yaseSinayi, wathi, ");
INSERT INTO nde_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Yenza abako-Israyeli bagcine iPhasika ngesikhathi esimisiweyo. ");
INSERT INTO nde_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Gcinani umkhosi walo ngesikhathi esimisiweyo, kusihlwa ngosuku lwetshumi lane lwayonale inyanga, ngokwezimiso kanye lemithetho yawo.” ");
INSERT INTO nde_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Ngakho uMosi watshela abako-Israyeli ukuthi bagcine iPhasika, ");
INSERT INTO nde_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","benza njalo kusihlwa ngosuku lwetshumi lane lwenyanga yakuqala enkangala yaseSinayi. Abako-Israyeli benza konke njengokulaywa kukaMosi nguThixo. ");
INSERT INTO nde_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Kodwa abanye babo abazange bagcine iPhasika ngalolosuku ngoba babengcolile ngokomkhuba ngenxa yesidumbu. Ngakho beza kuMosi lo-Aroni ngalolosuku ");
INSERT INTO nde_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","bathi kuMosi, “Sesingcolile ngenxa yesidumbu, kambe kungani sinqatshelwa ukwethula umnikelo kaThixo kanye labanye bako-Israyeli ngesikhathi esimisiweyo na?” ");
INSERT INTO nde_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","UMosi wabaphendula wathi, “Manini, ukuze ngizwe ukuthi uThixo uzakuthini ngani.” ");
INSERT INTO nde_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Ngakho uThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Tshono kwabako-Israyeli uthi: ‘Nxa omunye wenu loba ubani wakini kumbe izizukulwane zenu ezingcoliswe yisidumbu kumbe ethethe uhambo, angagcina iPhasika likaThixo. ");
INSERT INTO nde_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Bangagcina lumkhosi kusihlwa ngosuku lwetshumi lane lwenyanga yesibili. Kabadle iwundlu, kanye lesinkwa esingelamvubelo lemibhida ebabayo. ");
INSERT INTO nde_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Bangatshiyi lutho lwakho kuze kuse kumbe ukwephula loba yiliphi lamathambo alo. Nxa begcina iPhasika, kabalandele yonke imithetho yalo. ");
INSERT INTO nde_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Kodwa nxa umuntu ehlambulukile ngokomkhuba njalo engekho ohanjweni ehluleke ukugcina iPhasika, lowomuntu kasuswe ebantwini bakibo ngoba engethulanga umnikelo kaThixo ngesikhathi esimisiweyo. Lowomuntu uzathwala umlandu wesono sakhe. ");
INSERT INTO nde_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Owezizweni ohlala phakathi kwenu ofuna ukugcina iPhasika likaThixo kakwenze ngokwezimiso kanye lemithetho yalo. Wobani lezimiso zinye kowezizweni kanye lowakini.’ ” ");
INSERT INTO nde_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Ngosuku okwamiswa ngalo ithabanikeli, ithente lobuFakazi lamiswa, iyezi lalisibekela. Kusukela kusihlwa kwaze kwasa iyezi elaliphezu kwethabanikeli lalinjengomlilo. ");
INSERT INTO nde_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Laqhubeka linjalo; lembeswe liyezi, ebusuku lalinjengomlilo. ");
INSERT INTO nde_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Kwakusithi iyezi lingaphakama lisuka phezu kwethente, abako-Israyeli labo babesuka bahambe kuthi lapho elima khona, abako-Israyeli bamise izihonqo zabo khona. ");
INSERT INTO nde_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Abako-Israyeli babesuka bahambe ngokulaya kukaThixo, kuthi njalo ngokulaya kwakhe bamise izihonqo zabo. Ngesikhathi sonke iyezi limi phezu kwethabanikeli, abako-Israyeli bahlala ezihonqweni zabo. ");
INSERT INTO nde_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Lapho iyezi lihlala isikhathi eside phezu kwethabanikeli, abako-Israyeli bamlalela uThixo abaze bahamba. ");
INSERT INTO nde_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Kwesinye isikhathi iyezi lalisima phezu kwethabanikeli okwezinsukwana nje kuphela; ngokulaya kukaThixo babehlala ezihonqweni khonapho, kuthi njalo ngokulaya kwakhe basuke bahambe. ");
INSERT INTO nde_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Kwesinye isikhathi iyezi lalisima kusukela kusihlwa kuze kuse, kuthi nxa lisuka ekuseni, labo bahambe. Kungakhathalekile ukuthi kusemini loba kusebusuku, sonke isikhathi lapho iyezi lisuka babesuka bahambe. ");
INSERT INTO nde_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Loba iyezi lalisima phezu kwethabanikeli okwensuku ezimbili, kumbe okwenyanga eyodwa loba okomnyaka, abako-Israyeli babehlala khonapho ezihonqweni bangasuki; kodwa nxa lingasuka, labo babesuka. ");
INSERT INTO nde_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Ngokulaya kukaThixo babehlala ezihonqweni, langokulaya kwakhe njalo babesuka bahambe. Balalela okwakutshiwo nguThixo ngokulaya kwakhe ngoMosi. ");
INSERT INTO nde_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","UThixo wathi kuMosi: ");
INSERT INTO nde_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Yenza amacilongo amabili ngesiliva esikhandiweyo, ukuze uwasebenzise nxa ubizela abako-Israyeli ndawonye lanxa izihonqo sezifanele ukususwa ukuba kuhanjwe. ");
INSERT INTO nde_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Kuzakuthi nxa amacilongo womabili angakhala sikhathi sinye, isizwe sonke sako-Israyeli sibuthane phambi kwakho esangweni lethente lokuHlangana. ");
INSERT INTO nde_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Kungakhala elilodwa nje, abakhokheli, inhloko zezizwana zako-Israyeli, kumele babuthane phambi kwakho. ");
INSERT INTO nde_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Nxa icilongo lingakhala kakhulu, izizwana ezihlala ezihonqweni ezisempumalanga zizasuka. ");
INSERT INTO nde_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Lingakhala kakhulu okwesibili izihonqo ezingeningizimu zizasuka. Ukukhala kakhulu kwecilongo kutsho ukuthi kakusukwe. ");
INSERT INTO nde_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Ekubuthanisweni kwabantu ndawonye, lizakhalisa amacilongo, kodwa kube lomahluko ukukhala kwawo. ");
INSERT INTO nde_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Amadodana ka-Aroni, abaphristi, yibo abazatshaya amacilongo. Lesi siyisimiso esizakuma njalo kini lakuzizukulwane ezizayo. ");
INSERT INTO nde_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Nxa lisilwa impi lesitha esilincindezelayo elizweni lakini, lizakhalisa kakhulu amacilongo. Ngalokho uThixo uNkulunkulu wenu uzalikhumbula njalo lisindiswe ezitheni zenu. ");
INSERT INTO nde_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Njalo lasezikhathini zenu zentokozo, emikhosini emisiweyo kanye lemadilini okuThwasa kwenyanga, lizakhalisa amacilongo phezu kweminikelo yokutshiswa kanye leminikelo yobudlelwano, ngakho izakuba yisikhumbuzo senu phambi kukaNkulunkulu wenu. Mina nginguThixo uNkulunkulu wenu.” ");
INSERT INTO nde_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Ngosuku lwamatshumi amabili ngenyanga yesibili ngomnyaka wesibili, iyezi lasuka phezu kweThabanikeli lobuFakazi. ");
INSERT INTO nde_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Ngalokho abako-Israyeli basuka enkangala yaseSinayi bazula indawo ngendawo iyezi laze layakuma enkangala yasePharani. ");
INSERT INTO nde_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Basuka, okwehlandla lakuqala ngokulaya kukaThixo ngoMosi. ");
INSERT INTO nde_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Izigaba zezihonqo zakoJuda zasuka kuqala, ngophawu lwazo. Zazilawulwa nguNahashoni indodana ka-Aminadabi. ");
INSERT INTO nde_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","UNethaneli indodana kaZuwari ekhokhele izigaba zesizwana sika-Isakhari, ");
INSERT INTO nde_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","kuthi u-Eliyabi indodana kaHeloni ekhokhele izigaba zesizwana sikaZebhuluni. ");
INSERT INTO nde_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Ngakho basebechitha ithabanikeli, kwathi amaGeshoni lamaMerari ayelithwala, lawo asuka. ");
INSERT INTO nde_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Kwalandela izigaba zezihonqo zikaRubheni, lazo zingaphansi kophawu lwazo. U-Elizuri indodana kaShedewuri wayekhokhele. ");
INSERT INTO nde_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","UShelumiyeli indodana kaZurishadayi ekhokhele isigaba sesizwana sikaSimiyoni, ");
INSERT INTO nde_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","kanti u-Eliyasafi indodana kaDuweli wayekhokhele isigaba sesizwana sikaGadi. ");
INSERT INTO nde_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Kwasekusuka amaKhohathi, wona asuka ethwele izinto ezingcwele. Ithabanikeli kwakumele limiswe abako-Israyeli bengakafiki. ");
INSERT INTO nde_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Izigaba zezihonqo zika-Efrayimi zalandela, ngaphansi kophawu lwazo. Owayekhokhele ngu-Elishama indodana ka-Amihudi. ");
INSERT INTO nde_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","UGamaliyeli indodana kaPhedazuri wayekhokhele isigaba sesizwana sikaManase, ");
INSERT INTO nde_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","kanti u-Abhidani indodana kaGidiyoni wakhokhela isigaba sezihonqo zesizwana sikaBhenjamini. ");
INSERT INTO nde_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ekucineni, beliviyo elalivimbe emuva kwazo zonke izigaba, kwaba ngabezihonqo zesizwana sikaDani, abasuka ekucineni labo bengaphansi kophawu lwabo. Owayekhokhele kwakungu-Ahiyezeri indodana ka-Amishadayi. ");
INSERT INTO nde_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","UPhagiyeli indodana ka-Okhirani wayekhokhele isigaba sesizwana sika-Asheri, ");
INSERT INTO nde_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","kanti u-Ahira indodana ka-Enani wayekhokhele isigaba sesizwana sikaNafithali. ");
INSERT INTO nde_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Lokhu kwakuyindlela yokulandelana kokuhamba kwezigaba zabako-Israyeli ekusukeni kwabo. ");
INSERT INTO nde_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","UMosi wathi kuHobhabhi indodana kaRuweli onguMidiyani uyisezala kaMosi, “Sesisuka sisiya elizweni lelo elatshiwo nguThixo ukuthi ‘Ngizalipha lona.’ Woza sihambe lawe thina sizakuphatha kuhle, uThixo uthembise abako-Israyeli izinto ezinhle.” ");
INSERT INTO nde_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Waphendula wathi, “Hatshi, angiyikuhamba, ngizabuyela kwelakithi ebantwini bakithi.” ");
INSERT INTO nde_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Kodwa uMosi wathi, “Ngiyakuncenga ungasuki phakathi kwethu. Nguwe owazi lapha okufanele sihlale khona enkangala, njalo ongaba ngamehlo ethu. ");
INSERT INTO nde_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Nxa ungahamba lathi, sizakwabelana lawe izinto ezinhle esiyabe siziphiwe nguThixo.” ");
INSERT INTO nde_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Ngakho basuka entabeni kaThixo bahamba okwensuku ezintathu. Umtshokotsho wesivumelwano sikaThixo wahamba phambi kwabo okwalezonsuku ezintathu ukubafunela indawo yokuphumula. ");
INSERT INTO nde_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Iyezi likaThixo lalisiba phezu kwabo emini lapho sebesuka ezihonqweni. ");
INSERT INTO nde_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Kwakusithi lapho umtshokotsho wesivumelwano usuka, uMosi athi, “Phakama, Thixo! Sengathi izitha zingahlakazeka; sengathi izitha zakho zingabaleka phambi kwakho.” ");
INSERT INTO nde_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Kwakusithi lingema, athi, “Buya, Thixo, kuzinkulungwane zako-Israyeli ezingebalwe.” ");
INSERT INTO nde_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Abantu basola ngobunzima ababelabo uThixo esizwa, kwathi ekuzwa lokho wathukuthela kakhulu. Kwasekusithi umlilo ovela kuThixo wavutha phakathi kwabo waze waqothula lezinye izindawo ezisemaphethelweni ezihonqo. ");
INSERT INTO nde_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Kwathi lapho abantu sebekhale kuMosi, yena wakhuleka kuThixo ngakho umlilo wadeda. ");
INSERT INTO nde_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Indawo leyo yasibizwa ngokuthi yiThabhera, ngoba umlilo kaThixo wavutha phakathi kwabo. ");
INSERT INTO nde_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Uquqaba lwabantu olwaluphakathi kwabo lwaqala ukufisa okunye ukudla, ngakho labako-Israyeli baqala ukulila bathi, “Aluba besingazuza inyama yokudla nje kodwa lokhu! ");
INSERT INTO nde_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Sesikhumbula inhlanzi esasizidla eGibhithe kungelambadalo lamakhomane, amakhabe, amalikhi lemihlobo yonke yehanyanisi kanye legalikhi. ");
INSERT INTO nde_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Pho khathesi lapha sesize singasakhwabithi lokudla; kasiboni lutho ngaphandle kwemana yonale zwi!” ");
INSERT INTO nde_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Imana yayiphose ilingane lentanga yekhoriyanda ilombala ofana lowenhlaka. ");
INSERT INTO nde_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Abantu babephuma bayeyibutha, bayichole kumbe bayigige. Babeyipheka embizeni kumbe benze amaqebelengwana ngayo. Yayinambitheka njengento ephekwe ngamafutha e-oliva. ");
INSERT INTO nde_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Kwakusithi nxa kusiba lamazolo ezihonqweni ebusuku, imana layo ikhithika. ");
INSERT INTO nde_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","UMosi wezwa abantu bendlu inye ngayinye bekhala, ngulowo esemnyango wethente lakhe. UThixo wathukuthela kakhulu, njalo uMosi wakhathazeka. ");
INSERT INTO nde_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","UMosi wathi kuThixo, “Kungani wehlisele ubunzima encekwini yakho na? Kuyini engikwenzileyo okungakuthokozisanga ukuze ungeleke ngobunzima babantu bonke laba na? ");
INSERT INTO nde_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Ngingunina wabo na? Yimi engabazalayo yini? Kungani usithi ngibaphathe ngezandla zami njengomongikazi ephethe usane, ngibase elizweni lesithembiso owafunga ngalo kubokhokho babo na? ");
INSERT INTO nde_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ngingayithatha ngaphi inyama yokupha abantu bonke laba? Lokhu bengikhalela besithi, ‘Sinike inyama sidle!’ ");
INSERT INTO nde_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ngeke ngibathwale abantu bonke laba ngingedwa; umthwalo lo unzima kakhulu kimi. ");
INSERT INTO nde_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Nxa kuyiyo indlela ozangiphatha ngayo, ngibulala khathesi, nxa ngifumane umusa kuwe, ukuze ngingaboni ukuhlupheka kwami.” ");
INSERT INTO nde_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","UThixo wathi kuMosi: “Ngilethela ebadaleni bako-Israyeli abangamatshumi ayisikhombisa obaziyo ukuthi bangabakhokheli futhi yizikhulu zabantu. Balethe ethenteni lokuhlangana ukuze bame lawe khonapho. ");
INSERT INTO nde_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Ngizakwehla ngizekhuluma lawe khonapho, ngizathatha ingxenye yoMoya okuwe ngiwufake phezu kwabo. Bazakuncedisa ukuthwala umthwalo wabantu bako-Israyeli ukuze ungawuthwali wedwa. ");
INSERT INTO nde_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Tshela abantu uthi: Zingcweliseni lilungiselela usuku lwakusasa, lapho elizakudla khona inyama. UThixo ulizwile likhala kuye lisithi, ‘Ngubani ozasipha inyama ukuba sidle? Kwakungcono kithi siseGibhithe!’ Khathesi uThixo uzalinika inyama, njalo lizayidla. ");
INSERT INTO nde_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Aliyikuyidla okosuku olulodwa loba ezimbili, loba ezinhlanu, ezilitshumi loba ezingamatshumi amabili, ");
INSERT INTO nde_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","kodwa lizayidla okwenyanga yonke, ize iphume ngamakhala enu, ilitshiphele, ngoba limhlamukele uThixo ephakathi kwenu, njalo likhalile phambi kwakhe, lisithi, ‘Kanti sivele sasukelani eGibhithe.’ ” ");
INSERT INTO nde_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Kodwa uMosi wathi, “Mina ngilapha phakathi kwamadoda azinkulungwane ezingamakhulu ayisithupha (600,000) ahamba ngezinyawo, kodwa wena uthi, ‘Ngizabanika inyama abazayidla okwenyanga yonke!’ ");
INSERT INTO nde_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Bebengeneliswa na aluba bebehlatshelwe imihlambi yezimvu leyezifuyo? Babezakweneliswa na aluba begolelwe inhlanzi zonke zasolwandle?” ");
INSERT INTO nde_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","UThixo wamphendula uMosi wathi, “Kambe ingalo kaThixo imfitshane na? Uzabona-ke khathesi longabe yebo loba hayi ukuthi engikutshoyo kuzagcwaliseka kuwe.” ");
INSERT INTO nde_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Ngakho uMosi waphuma wayatshela abantu lokho okwakutshiwo nguThixo. Wahlanganisa abadala abangamatshumi ayisikhombisa wabamisa bahonqolozela ithente. ");
INSERT INTO nde_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Ngalokho uThixo wehla ngeyezi wakhuluma laye, yena wasethatha uMoya owawuphezu kwakhe wawethulela phezu kwabadala bebandla abangamatshumi ayisikhombisa. Kwathi uMoya usuphezu kwabo, baphrofitha, kodwa kabazange baphinde bakwenze emva kwalokho. ");
INSERT INTO nde_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Kodwa-ke, kwakukhona amadoda amabili, kungu-Elidadi loMedadi ababesele esihonqweni. Lanxa babebalelwa ebadaleni, kodwa kabazange baphume ukuya eThenteni. Kanti-ke uMoya wawehlele phezu kwabo labo, njalo babephrofitha besesihonqweni. ");
INSERT INTO nde_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Ijahana elincinyane lagijima layabikela uMosi lathi, “U-Elidadi loMedadi bayaphrofitha besesihonqweni.” ");
INSERT INTO nde_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","UJoshuwa indodana kaNuni, owayekade engumsekeli kaMosi kusukela ebutsheni bakhe, waphakamisa ilizwi wathi, “Mosi, nkosi yami, bathulise!” ");
INSERT INTO nde_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Kodwa uMosi waphendula wathi, “Uyangikhwelezela na? Ngiyafisa ukuthi ngabe bonke abantu bakaThixo bangabaphrofethi njalo lokuthi UThixo wehlisele uMoya wakhe phezu kwabo!” ");
INSERT INTO nde_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Ngakho uMosi labadala bako-Israyeli babuyela ezihonqweni. ");
INSERT INTO nde_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Kwasekuphephetha umoya uvela kuThixo wathinta izagwaca zivela olwandle. Zakhithika zelekana ukusuka phansi okwezingalo ezimbili ezihonqweni, zendlaleka okomango ongahanjwa okosuku lonke inxa zonke. ");
INSERT INTO nde_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Mhlalokho emini lebusuku njalo langosuku olulandelayo abantu baphuma bayabutha izagwaca. Akekho owabutha izagwaca ezinganeno kwamahomeri alitshumi. Ngakho basebezichaya indawana zonke ezihonqweni. ");
INSERT INTO nde_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Kodwa kwathi belokhu besayihlafuna inyama bengakayiginyi, ulaka lukaThixo lwavutha phezu kwabantu, njalo wabatshaya ngokubehlisela umkhuhlane. ");
INSERT INTO nde_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Ngakho indawo leyo yabizwa ngokuthi yiKhibhrothi Hathava, ngoba kulapho okwangcwatshwa khona abantu ababebukhali kokunye ukudla. ");
INSERT INTO nde_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Ekusukeni kwabo eKhibhrothi Hathava abantu bahamba baze bayafika eHazerothi bahlala khona. ");
INSERT INTO nde_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","UMiriyemu lo-Aroni basuka basebeqalisa ukusola uMosi ngenxa yomkakhe ongumKhushi, njengoba wayethethe umKhushi. ");
INSERT INTO nde_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Babuzana bathi: “Kambe uMosi nguye yedwa ongumlomo kaThixo na? Kanti lathi kazange asenze izikhulumeli zakhe na?” UThixo wakuzwa lokhu. ");
INSERT INTO nde_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(UMosi wayeyindoda ethobeke kakhulu, ethobeke ukwedlula wonke amadoda asemhlabeni.) ");
INSERT INTO nde_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Khonokho nje uThixo wathi kuMosi, u-Aroni loMiriyemu, “Phumani lize ethenteni lokuhlangana, lonke lobathathu.” Lakanye beza bobathathu. ");
INSERT INTO nde_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","UThixo wehla ngensika yeyezi; wema esangweni lethente wasebiza u-Aroni loMiriyemu. Kwathi lapho sebesondele bobabili, ");
INSERT INTO nde_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","uThixo wasesithi, “Lalelani amazwi ami: Nxa kulomphrofethi kaThixo phakathi kwenu, ngiziveza kuye ngemibono, ngikhuluma laye emaphutsheni. ");
INSERT INTO nde_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Kodwa akunjalo ngenceku yami uMosi; uthembekile endlini yami yonke. ");
INSERT INTO nde_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Nxa ngikhuluma laye siqondana ubuso ngobuso, ngokucacileyo kungesikuphicana; uyasibona isimo sikaThixo. Kungani pho belingesabi ukusola inceku yami uMosi na?” ");
INSERT INTO nde_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Ulaka lukaThixo lwavutha phezu kwabo, uThixo wasesuka kubo. ");
INSERT INTO nde_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Ekusukeni kweyezi phezu kwethente, kwabonakala uMiriyemu esemi lapho eselobulephero obunjengongqwaqwane. U-Aroni uthe emkhangela wambona eselobulephero; ");
INSERT INTO nde_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","wasesithi kuMosi, “Awu, nkosi yami, ungasibeki icala ngenxa yesono esisenze ngobuwula. ");
INSERT INTO nde_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Ungamyekeli enjengomntwana ozelwe efile, inyama yakhe idliwe nganxanye.” ");
INSERT INTO nde_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Ngakho uMosi wakhala kuThixo wathi, “Nkulunkulu, ngiyakucela, msilise.” ");
INSERT INTO nde_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","UThixo waphendula uMosi wathi, “Kambe ngabe uyise ubemkhafulele ebusweni, ubengayikuthwala ihlazo okwensuku eziyisikhombisa na? Mkhupheni ahlale ngaphandle kwezihonqo okwensuku eziyisikhombisa; ngemva kwalokho selingambuyisa.” ");
INSERT INTO nde_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Ngakho uMiriyemu wahlaliswa ngaphandle kwezihonqo okwensuku eziyisikhombisa, ngakho abantu kabaqhubekanga ngohambo waze waphenduka. ");
INSERT INTO nde_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Ngemva kwalokho, abantu basuka eHazerothi bayamisa izihonqo enkangala yasePharani. ");
INSERT INTO nde_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Thuma amadoda athile ukuba ayehlola ilizwe laseKhenani, engilinika abako-Israyeli. Kusendo ngalunye lwesizwe thuma umkhokheli oyedwa.” ");
INSERT INTO nde_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Ngakho ngokulaya kukaThixo uMosi wabakhupha labo enkangala yePharani. Bonke babengabakhokheli bako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Nanka amabizo abo: esizweni sikaRubheni, kwakunguShamuwa indodana kaZakhuri; ");
INSERT INTO nde_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","esizweni sikaSimiyoni, kwakunguShafathi indodana kaHori; ");
INSERT INTO nde_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","esizweni sikaJuda, kwakunguKhalebi indodana kaJefune; ");
INSERT INTO nde_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","esizweni sika-Isakhari, kwakungu-Igali indodana kaJosefa; ");
INSERT INTO nde_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","esizweni sika-Efrayimi, kwakunguHosheya indodana kaNuni; ");
INSERT INTO nde_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","esizweni sikaBhenjamini, kwakunguPhalithi indodana kaRafu; ");
INSERT INTO nde_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","esizweni sikaZebhuluni, kwakunguGadiyeli indodana kaSodi; ");
INSERT INTO nde_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","esizweni sikaManase (owesizwe sikaJosefa), kwakunguGadi indodana kaSusi; ");
INSERT INTO nde_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","esizweni sikaDani, kwakungu-Amiyeli indodana kaGemali; ");
INSERT INTO nde_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","esizweni sika-Asheri, kwakunguSethuri indodana kaMikhayeli; ");
INSERT INTO nde_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","esizweni sikaNafithali, kwakunguNabhi indodana kaVofisi; ");
INSERT INTO nde_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","esizweni sikaGadi, kwakunguGewuweli indodana kaMakhi. ");
INSERT INTO nde_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","La ngamabizo alawomadoda athunywa nguMosi ukuyahlola ilizwe. (UMosi wetha uHosheya indodana kaNuni ibizo elithi Joshuwa.) ");
INSERT INTO nde_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Ekubathumeni kwakhe ukuyahlola ilizwe laseKhenani, uMosi wathi kubo, “Hambani liye eNegebi likhuphukele elizweni lezintaba. ");
INSERT INTO nde_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Likhangele ukuthi ilizwe lakhona linjani njalo lokuthi abantu bakhona balamandla kumbe babuthakathaka, balutshwana kumbe banengi. ");
INSERT INTO nde_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Ilizwe abahlala kulo linjani? Lihle na loba libi? Amadolobho abahlala kuwo anjani? Agonjolozelwe ngemiduli loba asegcekeni nje? ");
INSERT INTO nde_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Umhlabathi wakhona unjani? Uvundile na loba ulugwadule? Langabe lilezihlahla loba hayi? Yenzani ubungcono benu libuye lezinye zezithelo zakulelolizwe.” (Kwakuyisikhathi sokuvuthwa kwezithelo zakuqala zevini.) ");
INSERT INTO nde_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ngakho bahamba ukuyahlola ilizwe besukela eNkangala yaseZini kuze kuyefika eRehobhi, ngokuya eLebho Hamathi. ");
INSERT INTO nde_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Bahamba-ke badabula eNegebi baze bayafika eHebhroni, lapho okwakuhlala khona u-Ahimani, loSheshayi kanye loThalimayi, izizukulwane zika-Anakhi. (IHebhroni yakhiwa iminyaka eyisikhombisa kungakakhiwa idolobho laseZowani eGibhithe.) ");
INSERT INTO nde_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Bathi befika esihotsheni sase-Eshikholi baquma ugatsha olwalulesixha sezithelo zevini. Ababili babo basithwala besigaxe egodweni ndawonye lamaphomegranathi kanye lomkhiwa. ");
INSERT INTO nde_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Lindawo yabizwa ngokuthi yisihotsha sase-Eshikholi ngenxa yesixha sezithelo zevini esaqunywa khona ngabako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Ngemva kwensuku ezingamatshumi amane zokuhlola ilizwe inhloli zabuyela emuva. ");
INSERT INTO nde_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Babuyela kuMosi lo-Aroni lakuso sonke isizwe sako-Israyeli eKhadeshi, enkangala yasePharani. Babikela uMosi lo-Aroni kanye labo bonke abako-Israyeli njalo batshengisa lezithelo zakulelolizwe. ");
INSERT INTO nde_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Balandisela uMosi bathi: “Sihambile elizweni lelo obukade usithume kulo, ngempela ligeleza uchago loluju! Nanzi izithelo zalo. ");
INSERT INTO nde_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Kodwa abantu abahlala khona balamandla kanti lamadolobho akhona makhulu njalo avikelwe. Size sabona lezizukulwane zika-Anakhi khonale. ");
INSERT INTO nde_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Ama-Amaleki ahlala eNegebi; amaHithi, lamaJebusi lama-Amori bahlala elizweni lezintaba, amaKhenani wona ahlala eduzane lolwandle esekele umfula uJodani.” ");
INSERT INTO nde_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Emva kwalokho uKhalebi wathulisa abantu phambi kukaMosi wasesithi, “Kufanele ukuthi sihambe siyethatha ilizwe leli libe ngelethu, ngoba singakwenza sibili.” ");
INSERT INTO nde_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Kodwa amadoda lawo ayehambe laye athi, “Asingeke sibahlasele abantu labo; balamandla kulathi.” ");
INSERT INTO nde_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Basebetshela abantu bako-Israyeli umbiko omubi ngelizwe ababelihlolile. Bathi, “Ilizwe esilihlolileyo liyabagabhela labantu abahlala kulo. Bonke abantu esibabone khonale yiziqhwaga. ");
INSERT INTO nde_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Sibone khona amaNefilimi (isizukulwane sika-Anakhi sivela kumaNefilimi.) Emehlweni ethu besingangentethe phambi kwabo, lasemehlweni abo besinjalo.” ");
INSERT INTO nde_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Ngalobobusuku abantu bonke emphakathini baphakamisa amazwi abo bakhala kakhulu. ");
INSERT INTO nde_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Bonke abako-Israyeli bakhonona besola uMosi lo-Aroni, lonke ibandla lathi kubo, “Ngabe sahle sazifela eGibhithe, kumbe khonapha enkangala! ");
INSERT INTO nde_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Kungani uThixo esilethe kulelilizwe ukuthi sife sibulawa ngenkemba na? Amakhosikazi ethu kanye labantwabethu bazakuba yimpango. Kambe kakungcono yini ukuthi sibuyele eGibhithe na?” ");
INSERT INTO nde_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Bakhulumisana besithi, “Asikhetheni omunye umkhokheli asibuyisele eGibhithe.” ");
INSERT INTO nde_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Ngakho uMosi lo-Aroni bathi mbo ngobuso phansi phambi kwabantu bako-Israyeli bonke ababebuthene lapho. ");
INSERT INTO nde_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Kwathi uJoshuwa indodana kaNuni kanye loKhalebi indodana kaJefune, ababengabanye balabo ababeyehlola ilizwe, badabula izigqoko zabo ");
INSERT INTO nde_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","bathi kubo bonke abako-Israyeli ababebuthene, “Ilizwe esadabula kulo salihlola lihle kakhulu. ");
INSERT INTO nde_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Nxa uThixo ethokoza ngathi, uzasikhokhelela kulo, ilizwe eligeleza uchago loluju, njalo uzakusinika lona. ");
INSERT INTO nde_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Kuphela nje lingamhlamukeli uThixo. Futhi lingabesabi abantu bakulelolizwe, ngoba sizabadla sibaqede. Kabaselaso isivikelo, kodwa uThixo ulathi. Lingabesabi.” ");
INSERT INTO nde_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Kodwa ibandla wonke wathi kabakhandwe ngamatshe. Inkazimulo kaThixo yasibonakala kubo bonke abako-Israyeli ethenteni lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","UThixo wasesithi kuMosi, “Koze kube nini abantu laba bengeyisa na? Kuzaze kube nini bengangikholwa, loba sengenze izinto ezimangalisayo phakathi kwabo na? ");
INSERT INTO nde_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ngizabatshaya ngomkhuhlane ngibabhubhise, kodwa wena ngizakwenza ube yisizwe esikhulu njalo esilamandla kulabo.” ");
INSERT INTO nde_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","UMosi wasesithi kuThixo, “AmaGibhithe azakuzwa lokhu! Abantu laba bakhutshwa nguwe phakathi kwabo ngamandla akho. ");
INSERT INTO nde_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Ngakho bazatshela abakhileyo kulelilizwe ngalesisehlakalo. Bavele sebezwile ukuthi wena, Oh Thixo, ulabo lababantu njalo lokuthi wena, Thixo, ubonakale uqondene labo ubuso ngobuso, lokuthi iyezi lakho lihlala liphezu kwabo, njalo lokuthi uhamba phambi kwabo ngensika yeyezi lakho emini kuthi ebusuku ngensika yomlilo. ");
INSERT INTO nde_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Pho ungababhubhisa abantu bonke laba ngasikhathi sinye, izizwe esezizwile ngalezizindaba ngawe zizakuthi, ");
INSERT INTO nde_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘UThixo wehlulekile ukungenisa abantu laba elizweni abathembisa lona ngesifungo; ngakho usebabhubhisele enkangala.’ ");
INSERT INTO nde_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Amandla kaThixo kabonakaliswe khathesi, njengokutsho kwakho ukuthi: ");
INSERT INTO nde_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘UThixo uyaphuza ukuthukuthela, ugcwele ngothando njalo uyathethelela isono lokuhlamuka. Kodwa kayikubayekela abalecala bengajeziswanga; ujezisa abantwana ngenxa yezono zaboyise kuze kube kusizukulwane sesithathu lesesine.’ ");
INSERT INTO nde_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Thethelela isono salababantu, ngenxa yothando lwakho olukhulu, ubaxolele njengokubaxolela kwakho kusukela ngesikhathi abasuka ngaso eGibhithe kuze kube khathesi.” ");
INSERT INTO nde_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","UThixo waphendula wathi, “Sengibathethelele njengesicelo sakho. ");
INSERT INTO nde_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Impela njengoba ngiphila, lanjengoba inkazimulo kaThixo igcwalise umhlaba wonke, ");
INSERT INTO nde_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","akulamuntu loyedwa owabona inkazimulo yami kanye lezibonakaliso zezimanga engazenza eGibhithe lasenkangala kodwa kaze angilalela njalo wangilinga okungaba ngamahlandla alitshumi, ");
INSERT INTO nde_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","akukho loyedwa wabo ozalibona ilizwe engalithembisa okhokho babo ngesifungo. Futhi kakho loyedwa ongidelelayo ozalibona. ");
INSERT INTO nde_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Kodwa ngenxa yokuthi inceku yami uKhalebi ulomoya owehlukileyo njalo ungilandela ngenhliziyo yakhe yonke, ngizamngenisa elizweni afika kulo, lizakuba yilifa lezizukulwane zakhe. ");
INSERT INTO nde_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Njengoba ama-Amaleki lamaKhenani ehlala ezigodini, lina phendukani kusasa liqonde enkangala ngendlela yasoLwandle oLubomvu.” ");
INSERT INTO nde_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","UThixo wathi kuMosi lo-Aroni: ");
INSERT INTO nde_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Koze kube nini lababantu abangalunganga bekhonona bengisola na? Sengizwile ukusola lokukhonona kwabako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ngakho batshele uthi, ‘Njengoba ngiphila impela, kutsho uThixo, ngizakwenza kini zona lezozinto engilizwe lizikhuluma. ");
INSERT INTO nde_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Izidumbu zenu zizagcwala enkangala yonale, lina lonke elabalwayo ngesikhathi sokubalwa kwabantu elileminyaka yokuzalwa engamatshumi amabili kusiya phezulu labo bonke abakade bekhonona bengisola. ");
INSERT INTO nde_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Kakho loyedwa wenu ozangena elizweni engafunga ngokuphakamisa isandla ukuthi libe likhaya lenu, ngaphandle kukaKhalebi indodana kaJefune loJoshuwa indodana kaNuni. ");
INSERT INTO nde_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Mayelana labantwana benu labo elathi bazakuba yimpango, ngizabangenisa elizweni lelo elilalileyo ukuze bathokoze kulo. ");
INSERT INTO nde_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Kodwa lina, izidumbu zenu zizawohlokela kule inkangala. ");
INSERT INTO nde_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Abantwabenu bazakuba ngabelusi lapha okweminyaka engamatshumi amane, behlupheka ngenxa yokungathembeki kwenu, kuze kungcwatshwe isidumbu sokucina enkangala. ");
INSERT INTO nde_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Okweminyaka engamatshumi amane, umnyaka munye umele usuku lunye elahlola ngalo ilizwe, lizahlupheka ngenxa yezono zenu lize lazi ukuthi kuyinto enjani nxa mina ngimelana lani.’ ");
INSERT INTO nde_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Mina Thixo, sengikhulumile, njalo ngempela ngizazenza lezizinto ebantwini laba bonke, abamanyeneyo bemelana lami. Bazabhubha kuyonale inkangala; bazafela khonapha.” ");
INSERT INTO nde_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Ngakho amadoda ayethunywe nguMosi ukuthi ayehlola ilizwe, lawo athi ekuphendukeni kwawo amemethekisa umbiko omubi owabangela ukuthi abantu bakhonone besola uMosi, ");
INSERT INTO nde_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","lawomadoda amemethekisa umbiko ongalunganga mayelana lelizwe atshaywa ngomkhuhlane afa phambi kukaThixo. ");
INSERT INTO nde_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Emadodeni ayeyehlola ilizwe, kwasila kuphela uJoshuwa indodana kaNuni kanye loKhalebi indodana kaJefune. ");
INSERT INTO nde_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Kwathi lapho uMosi esebikele bonke abako-Israyeli, bakhala kabuhlungu. ");
INSERT INTO nde_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Ngosuku olulandelayo ekuseni kakhulu baqonda elizweni lamaqaqa. Bathi, “Sonile, sizakuya kuleyondawo esayithenjiswa nguThixo.” ");
INSERT INTO nde_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Kodwa uMosi wathi kubo, “Kungani lingalaleli umlayo kaThixo na? Lokhu elikwenzayo akusoze kuphumelele! ");
INSERT INTO nde_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Lingakhuphuki, ngoba uThixo kalisekeli. Lizakwehlulwa yizitha zenu, ");
INSERT INTO nde_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","ngoba lizaqondana lama-Amaleki kanye lamaKhenani khonale. Ngenxa yokuthi limhlamukele uThixo, yena kayikuba lani ngakho lizabhujiswa ngenkemba.” ");
INSERT INTO nde_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Loba kunjalo, baqhubeka beqonde elizweni lamaqaqa benganakile, loba uMosi kumbe umtshokotsho wesivumelwano sikaThixo kungasukanga ezihonqweni. ");
INSERT INTO nde_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Ngakho ama-Amaleki lamaKhenani ayehlala kulelolizwe lamaqaqa ehla abahlasela, ababhuqa ebaxotsha baze bayafika eHoma. ");
INSERT INTO nde_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Tshela abako-Israyeli uthi kubo: ‘Ngemva kokungena kwenu elizweni engilinika lona ukuba libe likhaya lenu, ");
INSERT INTO nde_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","kumele lethule iminikelo yenu eyenziwa ngomlilo kuThixo, kusukela emihlambini yenkomo leyezimvu, kube liphunga elimnandi kuThixo, kungakhathalekile ukuthi ngumnikelo wokutshiswa kumbe ngumhlatshelo, kungokwezifungo eziqakathekileyo loba iminikelo yokuzithandela loba eyemikhosi emisiweyo, ");
INSERT INTO nde_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","ngakho lowo oletha umnikelo wakhe uzakwethula kuThixo umnikelo wamabele oyingxenye eyodwa etshumini lehefa lefulawa ecolekileyo exutshaniswe lamafutha ayingxenye eyodwa kokune kwehini. ");
INSERT INTO nde_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Lungisa lewundlu ngalinye elomnikelo wokutshiswa loba umhlatshelo ingxenye eyodwa kokune yehini yewayini njengomnikelo wokunathwayo. ");
INSERT INTO nde_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Kuthi ngenqama ulungise umnikelo wamabele ube yisilinganiso sokubili kokulitshumi kwehefa lefulawa ecolekileyo exutshaniswe lamafutha ayisilinganiso esisodwa kokuthathu kwehini, ");
INSERT INTO nde_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","lewayini eliyisilinganiso sehini esisodwa kokuthathu kube ngumnikelo wokunathwayo. Kunikele kube liphunga elimnandi kuThixo. ");
INSERT INTO nde_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Nxa ulungisa inkunzi eliguqa njengomnikelo wokutshiswa loba umhlatshelo, kusenzelwa isifungo esiqakathekileyo loba umnikelo wobudlelwano kuThixo, ");
INSERT INTO nde_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","letha ndawonye lenkunzi umnikelo wamabele acholiweyo aba yifulawa ecolekileyo eyisilinganiso sehefa sokuthathu etshumini exutshaniswe lamafutha ayingxenye yehini. ");
INSERT INTO nde_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Letha njalo lewayini eliyizilinganiso zengxenye yehini kube ngumnikelo wokunathwayo. Lokhu kuzakuba ngumhlatshelo wokudla, iphunga elimnandi kuThixo. ");
INSERT INTO nde_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Ngakho inkunzi inye ngayinye loba inqama, iwundlu linye ngalinye loba izinyane lembuzi, akulungiswe ngale indlela. ");
INSERT INTO nde_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Lokhu kwenze emnikelweni ngamunye loba ulungise emingaki. ");
INSERT INTO nde_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Wonke ozalwa lapha kumele enze lezizinto ngale indlela lapho eletha umnikelo wakhe owenziwe ngomlilo njengephunga elimnandi kuThixo. ");
INSERT INTO nde_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Ezizukulwaneni ezilandelayo, owezizweni loba ngubani ohlezi lani nxa esethula umnikelo owenziwa ngomlilo njengoqhatshi olumnandi kuThixo, kumele enze khona lokho elikwenzayo. ");
INSERT INTO nde_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Imithetho le kumele uyilandele wena labantu bonke kanye labezizweni abahlala phakathi kwenu; lesi yisimiso esimi njalo lakuzizukulwane ezilandelayo. Lina kanye labezizweni lizafanana phambi kukaThixo: ");
INSERT INTO nde_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Lizabuswa ngemithetho lemilayo efananayo lina kanye labezizwe abahlala phakathi kwenu.’ ” ");
INSERT INTO nde_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Tshela abako-Israyeli uthi: ‘Ekungeneni kwenu elizweni engilisa kulo ");
INSERT INTO nde_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","lingadla ukudla kwalelolizwe, yethulani ingxenye yakho ibe ngumnikelo kuThixo. ");
INSERT INTO nde_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Lethani isinkwa esenziwe ngempuphu yakuqala lisethule njengomnikelo ovela esizeni. ");
INSERT INTO nde_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Kuzozonke izizukulwane ezilandelayo lizakwethula umnikelo kuThixo uthethwe emputshini yenu yakuqala.’ ” ");
INSERT INTO nde_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘Kungakho nxa wehlulekile ukugcina loba yiphi imilayo uThixo ayinika uMosi ungananzelelanga, ");
INSERT INTO nde_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","loba yiphi imilayo kaThixo alitshele yona ngoMosi, kusukela ngosuku uThixo amupha yona kuqhubekela ezizukulwaneni ezilandelayo, ");
INSERT INTO nde_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","kanti njalo lokhu kwenzakele ngephutha abantu bengakunanzelele, kutsho ukuthi abantu bonke bakuleyondawo bazanikela ngenkunzi eliguqa kube ngumnikelo wokutshiswa olephunga elimnandi kuThixo, ndawonye lomnikelo wamabele lowokunathwayo, kanye lempongo yomnikelo wesono njengokumisiweyo. ");
INSERT INTO nde_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Umphristi uzakwenzela isizwe sonke sako-Israyeli indlela yokubuyisana, ngakho bazathethelelwa, ngoba bekungayisingabomo njalo banikele kuThixo ngokona kwabo umhlatshelo wokudla kanye lomnikelo wesono. ");
INSERT INTO nde_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Abantu bonke bako-Israyeli kanye labezizwe abahlala labo bazathethelelwa, ngoba bonke lababantu babengonanga ngabomo. ");
INSERT INTO nde_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Kodwa nxa kungumuntu oyedwa owonayo kungesikho ngabomo, kumele alethe imbuzi ensikazi elomnyaka owodwa ibe ngumnikelo wesono. ");
INSERT INTO nde_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Umphristi uzamenzela lowo owone ngokwenza isono kungesikho ngabomo indlela yokubuyisana phambi kukaThixo, kuthi ngemva kokuba indlela yokubuyisana isiyenziwe, uzathethelelwa. ");
INSERT INTO nde_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Wonalo umthetho ngowomuntu wonke owonayo kungesikho ngabomo, kungakhathalekile ukuthi ungowako-Israyeli ozalelwe khonapha kumbe ngowezizweni. ");
INSERT INTO nde_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Kodwa loba ngubani owenza isono ngabomo, kungaba ngowakini loba owezizweni, athuke uThixo, lowomuntu uzaxotshwa ebantwini bakibo. ");
INSERT INTO nde_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Ngenxa yokweyisa ilizwi likaThixo lokwephula imilayo yakhe, lowomuntu ngempela kaxotshwe kwabakibo; uhlala elokhu elalo icala.’ ” ");
INSERT INTO nde_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Ngesikhathi abako-Israyeli besenkangala, indoda ethile yatholakala itheza inkuni ngosuku lweSabatha. ");
INSERT INTO nde_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Kwathi labo abamficayo etheza bamusa kuMosi lo-Aroni kanye lakubo bonke abantu, ");
INSERT INTO nde_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ngoba kungakazakali ukuthi kumele enziweni; wavalelwa entolongweni. ");
INSERT INTO nde_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","UThixo wasesithi kuMosi, “Indoda leyo kumele ife. Abantu bonke kumele bamkhande ngamatshe ngaphandle kwezihonqo.” ");
INSERT INTO nde_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Ngakho abantu bamusa ngaphandle kwezihonqo bamkhanda ngamatshe waze wafa, njengokulaywa kukaMosi nguThixo. ");
INSERT INTO nde_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Tshela abako-Israyeli uthi kubo: ‘Kuzozonke izizukulwane ezizayo, kumele lithungele izixha zentshaka emiphethweni yezembatho zenu, isixha ngasinye sibe lentambo eluhlaza. ");
INSERT INTO nde_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Lizakhumbula imilayo yonke kaThixo njalo liyilalele izikhathi zonke nxa likhangela intshaka lezi ukuze lingazibhixi ngokulandela izinkanuko zezinhliziyo zenu kanye lamehlo enu liduhe. ");
INSERT INTO nde_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Ngakho lizakhumbula ukuyilandela yonke imilayo yami ukuze lehlukaniselwe uNkulunkulu wenu. ");
INSERT INTO nde_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Mina nginguThixo uNkulunkulu wenu, owalikhupha eGibhithe ukuze ngibe nguNkulunkulu wenu. NginguThixo uNkulunkulu wenu.’ ” ");
INSERT INTO nde_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","UKhora indodana ka-Izihari, indodana kaKhohathi, indodana kaLevi, labathile abakoRubheni, uDathani kanye lo-Abhiramu, amadodana ka-Eliyabi, kanye lo-Oni indodana kaPhelethi baqala ukuba yiziqholo ");
INSERT INTO nde_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","bavukela uMosi. Bakwenza lokhu bendawonye lamanye amadoda angamakhulu amabili alamatshumi amahlanu (250) ako-Israyeli, abakhokheli abadumileyo babantu bakuleyondawo ababekhethelwe ukuthi babe ngamalunga enkundla. ");
INSERT INTO nde_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Beza beliqembu ukuzomelana loMosi lo-Aroni bathi kubo, “Seledlulise amalawulo! Abantu bonke bako-Israyeli bangcwele, bonke ngamunye wabo, njalo uThixo uyabasekela. Pho kungani liziphakamisa ngaphezu kwabantu bakaThixo na?” ");
INSERT INTO nde_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","UMosi wathi ekuzwa lokhu, wawela phansi ngobuso. ");
INSERT INTO nde_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Wasesithi kuKhora lakubalandeli bakhe: “Kusasa ekuseni uThixo uzaveza obala ukuthi ngubani ongowakhe lokuthi ngubani ongcwele, njalo uzamvumela lowomuntu ukuthi asondele kuye. Indoda azayikhetha uzayivumela ukuthi isondele phansi kwakhe. ");
INSERT INTO nde_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Wena, Khora, kanye labalandeli bakho yenzani lokhu: Thathani indengezi ");
INSERT INTO nde_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","kuthi kusasa libasele umlilo njalo litshisele impepha kuzo phambi kukaThixo. Indoda ezakhethwa nguThixo yiyo engcwele. Lina baLevi seledlulise amalawulo!” ");
INSERT INTO nde_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","UMosi wabuye wathi kuKhora, “Khathesi lalelani-ke, lina baLevi! ");
INSERT INTO nde_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Kanti akulanelisanga yini ukuthi uNkulunkulu ka-Israyeli ulikhethile phakathi kwabo bonke abako-Israyeli njalo walisondeza phansi kwakhe ukuze lenze umsebenzi ethabanikeleni likaThixo lokuthi lizakuma phambi kwesizwe lisenzele inkonzo na? ");
INSERT INTO nde_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Ukusondezile wena kanye labanye bakho abangabaLevi phansi kwakhe, kodwa-ke khathesi selifuna lobuphristi. ");
INSERT INTO nde_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Ukubambana kwakho kanye labalandeli bakho kuyikumelana loThixo limphikisa. Kambe ungubani u-Aroni elingakhonona ngaye?” ");
INSERT INTO nde_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Ngakho uMosi wabiza uDathani lo-Abhiramu amadodana ka-Eliyabi. Kodwa bona bathi, “Vele kasibuyi! ");
INSERT INTO nde_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Kambe bekungenelanga yini ukuthi wasikhipha elizweni eligeleza uchago loluju ukuzasibulalela enkangala na? Khathesi usufuna lokuba yinkosi phezu kwethu? ");
INSERT INTO nde_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Kunjalo-nje, awukasingenisi elizweni eligeleza uchago loluju kumbe ukusipha ilifa lamasimu kanye lezivini. Ufuna ukukopola amehlo amadoda la na? Hatshi, kasibuyi!” ");
INSERT INTO nde_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Ngalokho uMosi wathukuthela kakhulu wasesithi kuThixo, “Ungawemukeli umnikelo wabo. Angithathanga lutho kubo ngitsho lobabhemi kodwa lokhu, njalo kakho loyedwa engimoneleyo.” ");
INSERT INTO nde_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","UMosi wathi kuKhora, “Wena kanye labo bonke abalandeli bakho kumele lime phambi kukaThixo kusasa, wena, bona kanye lo-Aroni. ");
INSERT INTO nde_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Indoda inye nganye kumele ithathe udengezi ifake impepha kulo, indengezi ezingamakhulu amabili alamatshumi amahlanu, (250) njalo iwethule phambi kukaThixo. Wena kanye lo-Aroni lani kufanele liveze ezenu indengezi.” ");
INSERT INTO nde_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Ngakho indoda inye ngayinye yathatha udengezi lwayo, yafaka umlilo kanye lempepha kulo, njalo yema loMosi lo-Aroni esangweni lethente lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kwathi uKhora esebaqoqile abalandeli bakhe bephikisana labo esangweni lethente lokuhlangana, inkazimulo kaThixo yabonakala kubo bonke abantu ababebuthene kuleyondawo. ");
INSERT INTO nde_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","UThixo wathi kuMosi lo-Aroni, ");
INSERT INTO nde_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Sukani phakathi kwalaba ababutheneyo ukuze ngibabhubhise khathesi.” ");
INSERT INTO nde_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Kodwa uMosi lo-Aroni bawa phansi ngobuso bakhala bathi, “Oh Nkulunkulu, Nkulunkulu wemiphefumulo yabantu bonke, uzathukuthelela abantu bonke jikelele ngenxa yomuntu oyedwa owonileyo na?” ");
INSERT INTO nde_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Ngakho uThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Tshela ibandla uthi, ‘Sukani eduze kwamathente aboKhora, loDathani lo-Abhiramu.’ ” ");
INSERT INTO nde_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","UMosi wasukuma waya kuDathani lo-Abhiramu, kwathi labadala bako-Israyeli bamlandela. ");
INSERT INTO nde_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Waqonqosela ibandla wathi, “Buyelani emuva lisuke emathenteni abantu laba ababi! Lingathinti lutho olungolwabo ngoba lingenzenjalo lizakhuculwa ngenxa yezono zabo.” ");
INSERT INTO nde_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Ngakho basuka emathenteni kaKhora, uDathani lo-Abhiramu. UDathani lo-Abhiramu basebephume phandle bemi labomkabo, labantwababo kanye labancane emasangweni amathente abo. ");
INSERT INTO nde_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","UMosi wasesithi, “Nansi indlela elizabona ngayo ukuthi uThixo ungithumile ukuzokwenza konke lokhu engikwenzayo kanye lokuthi akusingqondo yami. ");
INSERT INTO nde_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Nxa amadoda la ezazifela ngendlela abantu abazifela ngayo, kumbe nxa bengethekelelwa emva kokwethekelela kwabantu bonke kuzabe kusitsho ukuthi uThixo kangithumanga. ");
INSERT INTO nde_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Kodwa nxa uThixo ezakwenza esingakaze sikubone okunye okutsha kwenzakale ukuthi umhlaba uvuleke ubaginye kanye lakho konke okungokwabo, bangene bephila engcwabeni, kulapho elizakwazi khona ukuthi amadoda la ameyisile uThixo.” ");
INSERT INTO nde_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Kwathi eqeda ukutsho lokhu, umhlaba wavuleka ngaphansi kwabo, ");
INSERT INTO nde_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","wavuleka wabaginya bona, kanye labantwababo lamadoda wonke ayekhokhelwa nguKhora kanye lempahla zawo. ");
INSERT INTO nde_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Batshona engcwabeni bephila, lakho konke okwakungokwabo; umhlabathi wabambokotha, kwaba yikutshabalala kwabo, basuswa kwabakibo. ");
INSERT INTO nde_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Besizwa ukukhala kwabo, bonke abako-Israyeli ababelapho babaleka, beklabalala besithi, “Umhlaba uzasiginya lathi!” ");
INSERT INTO nde_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Kwavela umlilo kuThixo watshaya waqothula amadoda angamakhulu amabili alamatshumi amahlanu (250) ayenikela ngempepha. ");
INSERT INTO nde_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Tshela u-Eliyazari indodana ka-Aroni, umphristi, ukuthi athathe indengezi azikhiphe emlotheni achithele amalahle endaweni ekhatshana, ngoba indengezi lezi zingcwele, ");
INSERT INTO nde_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","indengezi zamadoda onileyo aze alahlekelwa yimpilo yawo. Khanda lezondengezi ukuze zendlaleke e-alithareni, ngoba zethulwa phambi kukaThixo zaba ngezingcwele. Azibe yisibonakaliso kwabako-Israyeli.” ");
INSERT INTO nde_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Ngakho u-Eliyazari umphristi wabutha indengezi zethusi ezazilethwe yilabo abatshayo, walungisa ukuba zikhandwe zendlalwe e-alithareni, ");
INSERT INTO nde_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","njengokulaywa kukaMosi nguThixo. Lokhu kwakuzakhumbuza abako-Israyeli ukuthi kakho ovunyelwayo ukutshisa impepha phambi kukaThixo ngaphandle kuka-Aroni lesizukulwane sakhe, funa abe njengoKhora labalandeli bakhe. ");
INSERT INTO nde_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Ngosuku olulandelayo abako-Israyeli bonke bakhonona basola uMosi lo-Aroni. Bathi, “Selibulele abantu bakaThixo.” ");
INSERT INTO nde_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Kodwa kwathi ibandla selibuthene bephikisa uMosi lo-Aroni njalo sebekhangele ethenteni lokuhlangana, masinyane iyezi lalisibekela kwavela inkazimulo kaThixo. ");
INSERT INTO nde_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Ngakho uMosi lo-Aroni baya phambi kwethente lokuhlangana, ");
INSERT INTO nde_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","uThixo wasesithi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Suka kulelibandla ukuze ngibatshabalalise.” Ngakho bawa phansi ngobuso. ");
INSERT INTO nde_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Kusenjalo uMosi wathi ku-Aroni, “Thatha udengezi lwakho uthele impepha kulo, ndawonye lomlilo ovela e-alithareni, uphange uye ebandleni ukuze ubenzele indlela yokubuyisana. Ulaka lukaThixo lubonakele; isifo sesiqalisile.” ");
INSERT INTO nde_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","U-Aroni wenza okwakutshiwo nguMosi, waphanga wangena phakathi kwebandla. Isifo sesivele sesiqalisile ebantwini, kodwa u-Aroni wanikela impepha wabenzela indlela yokubuyisana. ");
INSERT INTO nde_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Wema phakathi kwabaphilayo lasebefile, isifo saphela. ");
INSERT INTO nde_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Kodwa kwasekufe abantu abazinkulungwane ezilitshumi lane lamakhulu ayisikhombisa (14,700) bebulawa yisifo, phezu kwalabo ababefe ngenxa kaKhora. ");
INSERT INTO nde_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Ngemva kwalokho u-Aroni wabuyela kuMosi esangweni lethente lokuhlangana, njengoba isifo sasesiphelile. ");
INSERT INTO nde_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Tshela abako-Israyeli ukuthi bakuphe intonga ezilitshumi lambili, kuphume ibenye kumkhokheli munye ngamunye wesizwana sabokhokho bakhe. Bhala ibizo lendoda ngayinye entongeni yayo. ");
INSERT INTO nde_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Entongeni kaLevi uzabhala ibizo lika-Aroni, ngoba kumele kube lentonga eyodwa emele inhloko inye ngayinye yesizwana sabokhokho bayo. ");
INSERT INTO nde_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Zifake ethenteni lokuhlangana phambi komtshokotsho wobufakazi, lapho engihlangana lawe khona. ");
INSERT INTO nde_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Intonga yendoda engizayikhetha izahluma, njalo mina ngizahle ngikuqede lokhu kukhonona okulokhu kuqhubeka kusolwa wena ngabako-Israyeli.” ");
INSERT INTO nde_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Ngakho uMosi wakhuluma kwabako-Israyeli, abakhokheli babo bamnika intonga ezilitshumi lambili, ngayinye ingeyomkhokheli wesizwana sabokhokho bakhe, kwathi leka-Aroni yayibalelwa kuzo. ");
INSERT INTO nde_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","UMosi wabeka intonga lezo phambi kukaThixo ethenteni lobufakazi. ");
INSERT INTO nde_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Ngosuku olulandelayo uMosi wangena ethenteni lobufakazi wabona ukuthi intonga ka-Aroni eyayimele indlu kaLevi, yayisihlumile yaqhakaza, isilamaluba njalo isithele izithelo ze-alimondi. ");
INSERT INTO nde_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Ngakho uMosi wazisusa zonke intonga phambi kukaThixo waziletha phambi kwabo bonke abako-Israyeli. Bazikhangela, ngulowo wathatha eyakhe intonga. ");
INSERT INTO nde_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","UThixo wathi kuMosi, “Buyisela intonga ka-Aroni phambi komtshokotsho wobufakazi, igcinwe khonapho ibe yisibonakaliso kulabo abahlamukayo. Lokhu kuzaqeda ukukhonona kwabo ngami, ukuze bangafi.” ");
INSERT INTO nde_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","UMosi wenza khona lokho kanye uThixo ayemlaye ngakho. ");
INSERT INTO nde_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Abako-Israyeli bathi kuMosi, “Sizakufa! Sifile, sonke sesifile! ");
INSERT INTO nde_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Loba ngubani ozasondela phansi kwethabanikeli likaThixo uzakufa. Sizakufa sonke na?” ");
INSERT INTO nde_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","UThixo wathi ku-Aroni, “Wena, lamadodana akho labemuli kayihlo lizakuba lomlandu wokukhangela ukwephulwa kwemithetho yendawo yokukhonzela, njalo wena kanye lamadodana akho yini lodwa elizakuba lomlandu walabo abonela abaphristi. ");
INSERT INTO nde_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Letha abaLevi bakini bevela ezizwaneni zabokhokho benu bazohlanganyela kunye lani bakuphathise wena lamadodana akho lapho lisenza inkonzo phambi kwethente lobufakazi. ");
INSERT INTO nde_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Bazakuba ngaphansi kwakho njalo benze yonke imisebenzi yasethenteni, kodwa akumelanga basondele phansi kwezimpahla zendlu engcwele kumbe e-alithareni, funa lonke, wena kanye labo life. ");
INSERT INTO nde_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Kumele bahlanganele lawe babelomlandu wokunakekela ithente lokuhlangana, wonke umsebenzi wethenteni, njalo akungabibikho loyedwa ozasondela lapho wena okhona. ");
INSERT INTO nde_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Wena uzakuba lomlandu wokugcina indlu engcwele le-alithari, ukuze abako-Israyeli bangehlelwa lulaka njalo. ");
INSERT INTO nde_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Mina ngokwami ngibakhethile abafowenu abaLevi phakathi kwabako-Israyeli ukuba babe yisipho kuwe, behlukanisele uThixo ukuba benze umsebenzi ethenteni lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Kodwa wena kanye lamadodana akho yini lodwa elivunyelwayo ukwenza umsebenzi wobuphristi kukho konke okuse-alithareni langaphakathi kwekhetheni. Ngikunika umsebenzi wobuphristi kukho konke okuse-alithareni langaphakathi kwekhetheni. Ngikunika umsebenzi wobuphristi njengesipho. Loba ngubani omunye ozasondela endaweni engcwele kumele abulawe.” ");
INSERT INTO nde_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","UThixo wasesithi ku-Aroni, “Mina ngokwami yimi engikunike umlandu wokukhangela iminikelo eyethulelwa mina, yonke iminikelo engcwele engiyiphiwa ngabako-Israyeli ngiyinika wena lamadodana akho ukuba kube yingxenye yesabelo sakho esimi njalo. ");
INSERT INTO nde_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Kumele uzuze leyongxenye yomnikelo ongcwelengcwele ongatshiswanga. Kuzozonke izipho abaziletha kimi zingumnikelo ongcwelengcwele, loba ngowamabele loba ngowesono kumbe owecala, leyongxenye yomnikelo ngeyakho lamadodana akho. ");
INSERT INTO nde_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Idle njengento engcwelengcwele; wonke owesilisa kumele ayidle. Kumele akuphathe njengento engcwele. ");
INSERT INTO nde_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Lokhu lakho ngokwakho: konke okubekwa eceleni kwalezizipho zonke zomnikelo wokuzunguzwa zako-Israyeli. Lokhu ngikunika wena lamadodana akho lamadodakazi akho ukuba kube yisabelo esimi njalo. Kuzakuthi wonke owendlu yakho ohlambulukileyo ngokomkhuba avunyelwe ukudla. ");
INSERT INTO nde_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Ngikunika wonke amafutha acengekileyo e-oliva lewayini lonke elitsha elicengekileyo kanye lamabele abawanika uThixo kuyizithelo zakuqala zesivuno sabo. ");
INSERT INTO nde_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Zonke izithelo zakuqala zomlimela abaziletha kuThixo ngezakho. Kuzakuthi wonke owendlu yakho ohlambulukileyo ngokomkhuba avunyelwe ukudla. ");
INSERT INTO nde_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Yonke into yako-Israyeli emiselwe uThixo ngeyakho. ");
INSERT INTO nde_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Amazibulo wonke azelweyo, kuhlanganisela awabantu kanye lawezinyamazana, anikelwe kuThixo ngawakho. Kodwa uzahlenga wonke amadodana angamazibulo kanye lawo wonke amazibulo amaduna ezinyamazana ezingcolileyo. ");
INSERT INTO nde_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Kuzakuthi zingafikisa inyanga eyodwa zizelwe uzihlenge ngentengo yokuhlenga ayisilinganiso samashekeli amahlanu esiliva, kusiya ngesilinganiso seshekeli lendlu engcwele, eyisisindo esingamagera angamatshumi amabili. ");
INSERT INTO nde_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Kodwa ungahlengi amazibulo enkomo, loba awemvu loba awembuzi; ngoba angcwele. Chela igazi lawo e-alithareni ubusutshisa amahwahwa awo kube ngumhlatshelo wokudla, iphunga elimnandi elithokozisa uThixo. ");
INSERT INTO nde_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Inyama yawo izakuba ngeyakho njengoba isifuba somnikelo wokuzunguzwa kanye lomlenze kungokwakho. ");
INSERT INTO nde_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Loba kuyini okubekwe eceleni eminikelweni engcwele eyethulwe ngabako-Israyeli kuThixo ngikunika wena kanye lamadodana njalo lamadodakazi akho ukuba kube yisabelo senu senjayelo. Lesi yisivumelwano setswayi esingapheliyo phambi kukaThixo, esakho kanye lenzalo yakho.” ");
INSERT INTO nde_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","UThixo wathi ku-Aroni, “Wena kawuyikuba lelifa elizweni labo, njalo awuyikuba lesabelo phakathi kwabo; mina ngiyisabelo sakho kanye lelifa lakho phakathi kwabako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","AbaLevi ngibanika konke okwetshumi kwelako-Israyeli kube yilifa labo ngenxa yomsebenzi abawenza ethenteni lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Kusukela khathesi abako-Israyeli akumelanga basondele ethenteni lokuhlangana, funa babelomlandu wesono sabo bafe. ");
INSERT INTO nde_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","NgabaLevi okufanele benze umsebenzi ethenteni lokuhlangana njalo baphathe umsebenzi wokukhangela abonayo ethenteni. Lesi yisimiso esingapheliyo lakuzizukulwane ezizayo. Kabayikuzuza ilifa phakathi kwabako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Kodwa-ke abaLevi ngibanika okwetshumi okwethulwa ngabako-Israyeli njengomnikelo kuThixo kube yilifa labo. Kokuqondene labo yikho ngathi: ‘Kabayikuba lelifa phakathi kwabako-Israyeli.’ ” ");
INSERT INTO nde_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Tshela abaLevi utsho lokhu kubo: ‘Lapho lisamukela okwetshumi engilinika khona kuvela kwabako-Israyeli njengelifa lenu, kumele likhuphe ingxenye yetshumi kokwetshumi kube ngumnikelo kuThixo. ");
INSERT INTO nde_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Umnikelo wenu uzabalelwa kini njengamabele avela esizeni loba umhluzi ovela esihluzweni sewayini. ");
INSERT INTO nde_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Ngale indlela lani lizakwethula eyenu iminikelo kuThixo kukho konke okwetshumi elizakwamukela kuvela kwabako-Israyeli. Kulokho okwetshumi kumele liphe okuyisabelo sikaThixo ku-Aroni umphristi. ");
INSERT INTO nde_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Kumele lethule njengesabelo sikaThixo okuhle ukwedlula konke njalo kungokungcwelengcwele kwakho konke elikuphiweyo.’ ");
INSERT INTO nde_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Tshela abaLevi uthi: ‘Nxa lisethula okuhle kakhulu, kuzaphathwa kini njengesithelo esivela esizeni loba esihluzweni sewayini. ");
INSERT INTO nde_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Lina kanye labezindlu zenu lingadla konke okunye ngaphi langaphi, ngoba kuyinkokhelo yenu yomsebenzi ethenteni lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Ngokwethula okuhle kulakho konke aliyikuba lecala kulokho; ngakho kaliyikungcolisa iminikelo engcwele yako-Israyeli, njalo kaliyikufa.’ ” ");
INSERT INTO nde_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","UThixo wathi kuMosi lo-Aroni: ");
INSERT INTO nde_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Lokhu yikho okukhangelelwe ngomthetho njengokulaya kukaThixo: Tshela abako-Israyeli bakuphe ithokazi elibomvu elipheleleyo njalo lingelasici kanti njalo kumele kube ngelingakaze lifakwe ejogeni. ");
INSERT INTO nde_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Liqhubeleni u-Eliyazari umphristi; kumele likhitshelwe ngaphandle kwesihonqo njalo lihlatshelwe khona. ");
INSERT INTO nde_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Ngakho u-Eliyazari umphristi uzathatha elinye igazi lalo ngomunwe alichele kasikhombisa eqondise phambi kwethente lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Ithokazi lizatshiswa ekhangele, isikhumba salo, inyama, igazi lomswane. ");
INSERT INTO nde_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Umphristi uzathatha ezinye inkuni zesihlahla somsedari, ihisophi kanye lewulu ebomvu akuphosele phezu kwethokazi elitshayo. ");
INSERT INTO nde_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Ngemva kwalokho umphristi kumele agezise izigqoko zakhe abesegeza yena ngamanzi. Ngemva kwalokhu usengangena-ke ezihonqweni, kodwa uzakuba ngongcolileyo kuze kube kusihlwa. ");
INSERT INTO nde_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Indoda ezatshisa ithokazi kumele layo igezise izigqoko zayo njalo layo igeze ngamanzi, izakuba ngengcolileyo kuze kube kusihlwa. ");
INSERT INTO nde_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Indoda ehlambulukileyo izabutha umlotha wethokazi iwufake endaweni ehlambulukileyo ngokomlayo ngaphandle kwesihonqo. Umlotha lo uzagcinwa ngabantu bako-Israyeli ukuze bawusebenzise emanzini okuhlambulula; ungowokuhlanza izono. ");
INSERT INTO nde_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Indoda ebutha umlotha wethokazi kumele layo igezise izigqoko zayo, kanti njalo layo izabe ingengcolileyo kuze kube kusihlwa. Lo ngumlayo omi njalo kwabako-Israyeli labezizwe abahlala phakathi kwabo. ");
INSERT INTO nde_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Lowo ozathintwa yisidumbu sofileyo uzabe engongcolileyo okwensuku eziyisikhombisa. ");
INSERT INTO nde_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Kumele azihlambulule ngamanzi ngosuku lwesithathu langosuku lwesikhombisa; kodwa nxa engazihlambululi ngosuku lwesithathu langolwesikhombisa uzabe engahlambulukanga. ");
INSERT INTO nde_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Lowo othinta isidumbu sofileyo abesesehluleka ukuzihlambulula ungcolisa ithabanikeli likaThixo. Lowomuntu kumele axotshwe kwabako-Israyeli. Ngenxa yokuthi kachelwanga ngamanzi okuhlambulula, ungongcolileyo; uzahlala engcolile. ");
INSERT INTO nde_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Lo ngumthetho osebenza nxa umuntu efele ethenteni: Loba ngubani ongena ethenteni njalo loba ngubani ophakathi kwalo uzakuba ngongcolileyo okwensuku eziyisikhombisa, ");
INSERT INTO nde_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","njalo siphi lasiphi isitsha esingasibekelwanga sizabe singcolile. ");
INSERT INTO nde_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Loba ngubani ofice isidumbu somuntu obulewe ngenkemba egangeni loba esomuntu ozifeleyo asithinte, kumbe loba ngubani othinta ithambo lomuntu ofileyo loba ingcwaba, uzakuba ngongcolileyo okwensuku eziyisikhombisa. ");
INSERT INTO nde_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Umuntu ongcolileyo, mfakele embizeni umlotha womnikelo otshisiweyo wokuhlambulula ube usuthela amanzi ahlambulukileyo phezu kwawo. ");
INSERT INTO nde_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Kuzakuthi-ke indoda ehlambulukileyo ngokomlayo ithathe ihisophi, iligxamuze emanzini ibe isichela ithente kanye lezitsha zonke labantu abakade belapho. Kumele ichele wonke umuntu oke wathinta ithambo lofileyo loba ingcwaba loba umuntu obuleweyo loba umuntu ozifeleyo. ");
INSERT INTO nde_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Indoda ehlambulukileyo izachela lowo ongcolileyo ngosuku lwesithathu langosuku lwesikhombisa, kuthi-ke ngosuku lwesikhombisa ibisimhlambulula. Umuntu ohlanjululwayo kumele agezise izigqoko zakhe abesegeza umzimba wakhe ngamanzi, Ngalokhokuhlwa uzabe esehlambululukile. ");
INSERT INTO nde_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Kodwa umuntu ongcolileyo nxa engazihlambululanga, kumele axotshwe ebantwini, ngoba uzabe eletha ihlazo endlini engcwele kaThixo. Njengoba engachelwanga ngamanzi angcwele, kutsho ukuthi ungcolile. ");
INSERT INTO nde_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Lesi yisimiso esimi njalo kubo. Indoda echela ngamanzi okuhlambulula layo kumele igezise izigqoko zayo, kanti njalo laye wonke ozathinta amanzi okuhlambulula uzakuba ngongcolileyo kuze kube kusihlwa. ");
INSERT INTO nde_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Konke okuthintwe ngumuntu ongcolileyo kuzakuba ngokungcolileyo, kuthi loba ngubani okuthintayo abe ngongcolileyo kuze kuhlwe.” ");
INSERT INTO nde_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Ngenyanga yakuqala abantu bonke bako-Israyeli bafika enkangala yaseZini, basebehlala eKhadeshi. UMiriyemu wafela lapho njalo wangcwatshelwa khona. ");
INSERT INTO nde_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Abantu baswela amanzi, ngakho babambana ekuphikiseni uMosi lo-Aroni. ");
INSERT INTO nde_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Baxabana loMosi kanye lo-Aroni bathi, “Ngabe lathi sahle sazifela mhla abafowethu besifa phambi kukaThixo! ");
INSERT INTO nde_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Labalethelani abantu bakaThixo kule inkangala na? Ukuze thina kanye lezifuyo zethu sizefela lapha na? ");
INSERT INTO nde_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Lasikhuphelani eGibhithe lisiletha endaweni le embi kangaka na? Ayilamabele kumbe imikhiwa, amavini loba amaphomegranathi. Njalo akulamanzi okunatha!” ");
INSERT INTO nde_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","UMosi lo-Aroni basuka embuthanweni wabantu baya esangweni lethente lokuhlangana bawa phansi ngobuso, inkazimulo kaThixo yasibonakala kubo. ");
INSERT INTO nde_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Thatha intonga kuthi wena lomfowenu u-Aroni libizele abantu ndawonye. Khulumani elitsheni phambi kwabo ngakho lona lizakhupha amanzi alo. Lizathatha amanzi aphuma edwaleni liphe abantu ukuze banathe bona kanye lezifuyo zabo.” ");
INSERT INTO nde_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Ngakho uMosi wathatha intonga phambi kukaThixo, njengokulaywa kwakhe nguThixo. ");
INSERT INTO nde_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","UMosi lo-Aroni basebebizela abantu ndawonye phambi kwedwala, uMosi wasesithi kubo, “Lalelani, lina bahlamuki. Silikhuphele amanzi kulelidwala na?” ");
INSERT INTO nde_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Ngakho uMosi waphakamisa ingalo yakhe watshaya idwala kabili ngentonga yakhe. Amanzi antshantshaza ephuma edwaleni, Kwathi abantu kanye lezifuyo zabo banatha. ");
INSERT INTO nde_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Kodwa uThixo wathi kuMosi lo-Aroni, “Ngenxa yokuthi kalingethembanga okokungipha udumo njengongcwele phambi kwabako-Israyeli, kaliyikukhokhelela lababantu ekungeneni elizweni engibapha lona.” ");
INSERT INTO nde_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","La ngamanzi aseMeribha, lapho abako-Israyeli abaphikisana khona loThixo njalo kulapho uThixo abonakalisa ubungcwele bakhe phakathi kwabo. ");
INSERT INTO nde_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","UMosi wathumela izithunywa enkosini yase-Edomi zisuka eKhadeshi, esithi: “Nanku okutshiwo ngumfowenu u-Israyeli: Uyabazi bonke ubunzima obusehleleyo. ");
INSERT INTO nde_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Okhokho bethu basuka baya eGibhithe, sahlala khona okweminyaka eminengi. AmaGibhithe asiphatha ngochuku kanye labobaba, ");
INSERT INTO nde_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","kodwa sakhala kuThixo wezwa ukukhala kwethu wasithumela ingilosi yasikhipha eGibhithe. Khathesi silapha eKhadeshi idolobho elisemngceleni welizwe lakho. ");
INSERT INTO nde_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Ake usivumele sidlule elizweni lakho. Kasiyikudabula phakathi lakuwaphi amasimu loba isivini sakho, kumbe ukunatha amanzi loba kuwuphi umthombo. Sizahamba silandela umgwaqo wenkosi njalo kasiyikuphambukela kwesokudla kumbe kwesokunxele size sedlule elizweni lakho.” ");
INSERT INTO nde_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Kodwa u-Edomi waphendula wathi: “Ngeke lidlule lapha, lingake lilinge, sizaphuma silihlasele ngenkemba.” ");
INSERT INTO nde_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Abako-Israyeli baphendula bathi: “Sizahamba ngomgwaqo omkhulu, njalo thina loba izifuyo zethu singanatha amanzi enu, sizawabhadala. Sifuna ukuzedlulela ngenyawo kuphela nje.” ");
INSERT INTO nde_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Abase-Edomi baphendula njalo bathi: “Lingadluli lapha.” Ngakho u-Edomi waphuma kanye lebutho elikhulu elilamandla ukuyahlasela abako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Njengoba u-Edomi wala ukuthi badabule elizweni labo, abako-Israyeli baphenduka bahamba ngenye indlela. ");
INSERT INTO nde_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Isizwe sonke sako-Israyeli sasuka eKhadeshi sahamba saze sayafika entabeni yaseHori. ");
INSERT INTO nde_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Sebesentabeni yaseHori, eduze lomngcele wase-Edomi, uThixo wathi kuMosi lo-Aroni, ");
INSERT INTO nde_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“U-Aroni usezakufa angcwatshwe. Akayikungena elizweni engilinika abako-Israyeli, ngoba lina lobabili langihlamukela emanzini aseMeribha. ");
INSERT INTO nde_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Biza u-Aroni kanye lendodana yakhe u-Eliyazari ukhwele labo entabeni yaseHori. ");
INSERT INTO nde_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Uhlubule u-Aroni izembatho zakhe uzigqokise indodana yakhe u-Eliyazari, ngoba u-Aroni uzalandela abakibo; uzafela khona.” ");
INSERT INTO nde_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","UMosi wenza njengokulaywa kwakhe kuThixo: Bakhwela entabeni yaseHori isizwe sonke sibakhangele. ");
INSERT INTO nde_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","UMosi wamhlubula u-Aroni izembatho zakhe wazigqokisa indodana yakhe u-Eliyazari. Ngakho u-Aroni wafela khonapho phezu kwentaba. Ngemva kwalokhu uMosi lo-Eliyazari behla entabeni, ");
INSERT INTO nde_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Kwathi abantu bonke sebezwile ukuthi u-Aroni wayesefile, yonke indlu ka-Israyeli yamlilela okwensuku ezingamatshumi amathathu. ");
INSERT INTO nde_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Kwathi inkosi yase-Aradi engumKhenani eyayihlala eNegebi isizwa ukuthi abako-Israyeli babesiza behamba ngomgwaqo beqonde e-Atharimi, yabahlasela abako-Israyeli yaze yathumba abanye babo. ");
INSERT INTO nde_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Ngakho u-Israyeli wenza lesisifungo kuThixo wathi: “Nxa unganikela lababantu ezandleni zethu, sizachithiza amadolobho abo nya.” ");
INSERT INTO nde_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","UThixo walalela ukuncenga kwabako-Israyeli wasenikela amaKhenani kubo. Abako-Israyeli bawaqothula amaKhenani bachithiza kanye lamadolobho awo; ngakho indawo leyo yabizwa ngokuthi yiHoma. ");
INSERT INTO nde_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Bahamba besuka entabeni yaseHori ngendlela eqonda oLwandle oluBomvu, ukuze baceze ilizwe lase-Edomi. Kodwa besendleleni abantu basebenengekile sebephelelwe yikubekezela; ");
INSERT INTO nde_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","bakhuluma kubi besola uNkulunkulu kanye loMosi, bathi, “Lasikhuphelani na eGibhithe ukuze sizefela enkangala? Akulasinkwa! Akulamanzi! Futhi lalokhu ukudla kwenu okubi siyakuzonda.” ");
INSERT INTO nde_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Ngakho uThixo wasebathumela izinyoka ezazilobuhlungu obesabekayo kakhulu, zabaluma abantu bako-Israyeli abanengi bafa. ");
INSERT INTO nde_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Abantu baya kuMosi bathi, “Sonile ngokukhuluma kwethu kubi ngoThixo langokukhuluma kwethu ngawe. Akukhuleke ukuthi uThixo asuse izinyoka lezi phakathi kwethu.” Ngakho wabakhulekela abantu. ");
INSERT INTO nde_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","UThixo wathi kuMosi, “Yenza inyoka yethusi uyiphanyeke esigodweni; loba ngubani olunyiweyo angakhangela kuyo uzaphila.” ");
INSERT INTO nde_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Ngakho uMosi wenza inyoka yethusi wayiphanyeka esigodweni. Kwakusithi lowo olunywe yinyoka angakhangela inyoka yethusi aphile. ");
INSERT INTO nde_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Abako-Israyeli basuka baqhubeka baze bayamisa izihonqo zabo e-Obhothi. ");
INSERT INTO nde_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Basuka njalo e-Obhothi bayamisa izihonqo zabo e-Iye-Abharimi, enkangala eyayimalungana leMowabi ngokuya ngempumalanga. ");
INSERT INTO nde_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Besuka lapho baqhubeka ngohambo baze bayamisa izihonqo zabo esigodini saseZeredi. ");
INSERT INTO nde_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Basuka lapho bayamisa izihonqo zabo eduze le-Arinoni esenkangala eqhelela elizweni lama-Amori. I-Arinoni isemngceleni welaseMowabi, phakathi laphakathi kweMowabi kanye lama-Amori. ");
INSERT INTO nde_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Kungakho uGwalo lweziMpi zikaThixo lusithi: “Lokho akwenza oLwandle oLubomvu lakwenza emifuleni yeWahebhi eseSufa lemifuleni yase-Arinoni ");
INSERT INTO nde_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","lamawa ezindonga ehlela endaweni yase-Ari lasekela umngcele weMowabi.” ");
INSERT INTO nde_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Besuka lapho baqhubeka baze bayafika eBheri, emthonjeni lapho uThixo athi kuMosi, “Buthanisa abantu ngibanike amanzi.” ");
INSERT INTO nde_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Ngakho abako-Israyeli bahlabela ingoma le ethi: “Mpompoza, wemthombo! Hlabelelani ngawo, ");
INSERT INTO nde_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","ngomthombo owenjiwa ngamakhosana, owenjiwa yizikhulu zabantu, izikhulu ezilentonga zobukhosi kanye lezinduku.” Basuka-ke enkangala bayafika eMathana, ");
INSERT INTO nde_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","besuka eMathana baya eNahaliyeli, besuka eNahaliyeli, baya eBhamothi, ");
INSERT INTO nde_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","kwathi besuka eBhamothi baqonda esigodini eMowabi, lapho isiqongo sentaba yasePhisiga esikhangele elizweni elilugwadule. ");
INSERT INTO nde_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","U-Israyeli wathumela izithunywa kuSihoni inkosi yama-Amori wathi: ");
INSERT INTO nde_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Sivumele sidabule elizweni lakho. Kasiyikuphambukela loba lakuliphi icele ukuze singene loba kuwaphi amasimu akho kumbe isivini, loba ukunatha amanzi emthonjeni loba yiwuphi. Sizazihambela nje ngomgwaqo omkhulu weNkosi size sedlule elizweni lakho.” ");
INSERT INTO nde_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Kodwa uSihoni kavumanga ukuthi u-Israyeli adabule elizweni lakhe. USihoni waqoqa ibutho lakhe waphuma waqonda enkangala ukuyahlasela u-Israyeli. Wathi esefikile eJahazi walwa lo-Israyeli. ");
INSERT INTO nde_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Kodwa u-Israyeli wamnqoba ngenkemba, wambhubhisa njalo wamthathela ilizwe lakhe kusukela e-Arinoni kusiya eJabhoki, kusiyafika elizweni lama-Amoni kuphela, ngoba umngcele walo wawuvikelwe ngemithangala. ");
INSERT INTO nde_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","U-Israyeli wathatha wonke amadolobho ama-Amori wahlala kuwo, kwakugoqela iHeshibhoni kanye leziqinti ezaziyigombolozele. ");
INSERT INTO nde_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","IHeshibhoni kwakulidolobho likaSihoni inkosi yama-Amori, owayelwe lenkosi yamaMowabi eyayikade ibusa khona wayinqoba wayithathela ilizwe layo lonke kuze kuyefika e-Arinoni. ");
INSERT INTO nde_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Yingakho izimbongi zisithi: “Wozani eHeshibhoni; kayivuselelwe yakhiwe njalo; akuthi idolobho likaSihoni livuselelwe. ");
INSERT INTO nde_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Umlilo wavutha eHeshibhoni ilangabi lavela edolobheni likaSihoni. Laqothula i-Ari laseMowabi, abantu basemiqolweni yase-Arinoni. ");
INSERT INTO nde_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Maye kuwe, Mowabi! Selibhujisiwe lina, Oh bantu baseKhemoshi! Usedele amadodana akhe njengeziphepheli lamadodakazi njengabathunjiweyo bethunjwa nguSihoni inkosi yama-Amori. ");
INSERT INTO nde_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Kodwa thina sibehlule; iHeshibhoni siyitshabalalisile kuze kuyefika eDibhoni. Sibachithile kwaze kwaba seNofa, eqhelela eMedebha.” ");
INSERT INTO nde_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Ngakho u-Israyeli wahlala elizweni lama-Amori. ");
INSERT INTO nde_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Ngemva kokuba uMosi esethumele inhloli eJazeri, abako-Israyeli bathumba iziqinti eziseduze njalo baxotsha ama-Amori ayehlala khona. ");
INSERT INTO nde_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Basebephenduka bahamba ngomgwaqo oya eBhashani. U-Ogi inkosi yaseBhashani kanye lebutho lakhe lonke baphuma ukuyahlangana labako-Israyeli ukubahlasela e-Edreyi. ");
INSERT INTO nde_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","UThixo wathi kuMosi, “Ungamesabi, ngoba sengimnikele kuwe lamabutho akhe wonke kanye lelizwe lakhe. Menze konke owakwenza kuSihoni inkosi yama-Amori, owayebusa eHeshibhoni.” ");
INSERT INTO nde_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Ngakho bambulala ndawonye lamadodana akhe kanye lebutho lakhe lonke, kakho loyedwa owaphephayo. Basebethatha ilizwe lakhe. ");
INSERT INTO nde_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Abako-Israyeli basuka lapho baya emagcekeni aseMowabi bamisa izihonqo zabo zisekele umfula iJodani ngaphetsheya kweJerikho. ");
INSERT INTO nde_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","UBhalaki indodana kaZiphori wabona konke okwenziwa ngu-Israyeli kuma-Amori, ");
INSERT INTO nde_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ngakho uMowabi wesaba ngoba abantu bako-Israyeli babebanengi kakhulu. Ngempela uMowabi watshaywa luvalo ngenxa yokwesaba abako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","AmaMowabi athi ebadaleni bamaMidiyani, “Ixuku leli lizahuquluza konke esilakho, njengenkabi isidla utshani emadlelweni. ” Ngakho uBhalaki indodana kaZiphori, owayeyinkosi yamaMowabi ngalesosikhathi, ");
INSERT INTO nde_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","wathumela izithunywa ukuyabiza uBhalamu indodana kaBheyori, owayehlala ePhethori eduzane lomfula iYufrathe elizweni lakibo lomdabuko. UBhalaki wathi, “Kulabantu abanengi kakhulu abavela eGibhithe; bagcwele ilizwe lonke njalo bahlezi eduze kwami. ");
INSERT INTO nde_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Woza khathesi uzeletha isithuko phezu kwabo, ngoba balamandla kulami. Mhlawumbe ngalokho ngingabehlula ngibaxotshe elizweni. Ngoba ngiyazi ukuthi labo obabusisayo bayabusiseka, njalo labo obaqalekisayo bayaqalekiswa.” ");
INSERT INTO nde_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Abadala bamaMowabi labamaMidiyani basuka, bathatha imbadalo yokuhlahlula. Bathe befika kuBhalamu, bamtshela lokho okwatshiwo nguBhalaki. ");
INSERT INTO nde_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","“Lalani lapha okwalamuhla,” watsho uBhalamu kubo, “Ngizalilethela impendulo engizayiphiwa nguThixo.” Ngakho amakhosana amaMowabi ahlala laye. ");
INSERT INTO nde_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","UNkulunkulu weza kuBhalamu wambuza wathi, “Amadoda la olawo ngobani?” ");
INSERT INTO nde_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","UBhalamu wathi kuNkulunkulu, “UBhalaki indodana kaZiphori inkosi yamaMowabi ungithumele lelizwi elithi: ");
INSERT INTO nde_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Kulabantu abavele eGibhithe abagcwele elizweni lonke. Woza masinyane uzongiqalekisela lababantu. Mhlawumbe ngingaba lakho ukubalwisa ngibaxotshe lapha.’ ” ");
INSERT INTO nde_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Kodwa uNkulunkulu wathi kuBhalamu, “Ungahambi labo. Ungabaqalekisi lababantu, ngoba babusisiwe.” ");
INSERT INTO nde_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Ekuseni ngosuku olulandelayo uBhalamu wavuka esithi kumakhosana kaBhalaki, “Buyelani ezweni lenu, ngoba uThixo walile ukuthi ngihambe lani.” ");
INSERT INTO nde_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Ngakho amakhosana amaMowabi abuyela kuBhalaki athi, “UBhalamu walile ukubuya lathi.” ");
INSERT INTO nde_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Ngakho uBhalaki wathumela amanye amakhosana amanengi njalo adumileyo kulawakuqala. ");
INSERT INTO nde_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Eza kuBhalamu afika athi: “Nanku okutshiwo nguBhalaki indodana kaZiphori: Akungabi lalutho olungakuvimbela ukuza kimi, ");
INSERT INTO nde_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","ngoba ngizakunika umvuzo omuhle njalo ngenze konke okutshoyo. Woza uzongiqalekisela lababantu.” ");
INSERT INTO nde_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Kodwa uBhalamu wabaphendula wathi, “Loba uBhalaki enganginika isigodlo sakhe sigcwele isiliva legolide, angingeke ngenze ulutho olukhulu loba oluncane oluphambene lelizwi likaThixo uNkulunkulu wami. ");
INSERT INTO nde_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Khathesi hlalani lapha okwalobubusuku njengalokhu okwenziwe ngabanye, mina ngizadingisisa ukuthi kuyini okunye uThixo azangitshela khona.” ");
INSERT INTO nde_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Ngalobobusuku uNkulunkulu weza kuBhalamu wathi, “Njengoba ethunywe ukuzakubiza, hamba lawo, kodwa wenze lokho kuphela engizakutshela khona.” ");
INSERT INTO nde_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","UBhalamu wavuka ekuseni, wagada ubabhemi wakhe wahle wahamba lamakhosana amaMowabi. ");
INSERT INTO nde_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Kodwa uNkulunkulu wathukuthela kakhulu ngokuhamba kwakhe, ngakho ingilosi kaThixo yajama phambi kwakhe yamvimbela. UBhalamu wayegade ubabhemi wakhe elezinceku zakhe ezimbili. ");
INSERT INTO nde_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Kwathi ubabhemi ebona ingilosi kaThixo imi endleleni iphethe inkemba esandleni sayo, waphambuka endleleni waqonda iganga. UBhalamu wamtshaya ubabhemi embuyisela endleleni. ");
INSERT INTO nde_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Ngakho ingilosi kaThixo yayakuma emkhandlwini phakathi kwezivini ezimbili, kulemiduli inxa zonke. ");
INSERT INTO nde_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Kwathi ubabhemi ebona ingilosi kaThixo, ubabhemi wasondela emdulini, ehluzulela unyawo lukaBhalamu emdulini. Ngalokho wamtshaya njalo ubabhemi. ");
INSERT INTO nde_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Ngakho ingilosi kaThixo yaya phambili yema emkhandlwini onciphileyo lapho okwakungelandlela yokuphendukela kwesokudla loba esenxele. ");
INSERT INTO nde_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Kwathi ubabhemi ebona ingilosi kaThixo, ubabhemi walala phansi, uBhalamu wathukuthela kakhulu wamtshaya ubabhemi ngentonga yakhe. ");
INSERT INTO nde_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Ngalokho uThixo wavula umlomo kababhemi, wathi kuBhalamu, “Kanti ngenzeni na kuwe uze ungitshaye okwamahlandla amathathu?” ");
INSERT INTO nde_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","UBhalamu waphendula ubabhemi wathi, “Ungenze isiwula! Ngabe bengilenkemba esandleni sami bengizakubulala khathesi.” ");
INSERT INTO nde_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Ubabhemi wathi kuBhalamu, “Kanti kangisubabhemi wakho na ovele uhlezi umgada insuku zonke kuze kube namhlanje? Kambe ngiyake ngikwenze lokhu kuwe na?” UBhalamu waphendula wathi, “Hatshi.” ");
INSERT INTO nde_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Ngakho uThixo wavula amehlo kaBhalamu, wabona ingilosi kaThixo imi endleleni iqaphise inkemba. Ngakho wakhothama wawa phansi ngobuso. ");
INSERT INTO nde_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Ingilosi kaThixo yambuza yathi, “Kungani utshaye ubabhemi wakho okwamahlandla amathathu na? Ngize lapha ukukuvimbela ngoba indlela yakho iyibutshapha phambi kwami. ");
INSERT INTO nde_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Ubabhemi ungibonile waphambuka okwamahlandla amathathu. Alubana kaphambukanga, ngabe khathesi sengikubulele wena, ngayekela ubabhemi.” ");
INSERT INTO nde_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","UBhalamu wathi engilosini kaThixo, “Ngonile. Angizange nginanzelele ukuthi umi endleleni ukungivimbela. Nxa kungakuthokozisi khathesi, ngizabuyela emuva.” ");
INSERT INTO nde_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Ingilosi kaThixo yathi kuBhalamu, “Hamba lawo lamadoda, kodwa ukhulume lokho engikutshela khona kuphela.” Ngakho uBhalamu wahamba lamakhosana kaBhalaki. ");
INSERT INTO nde_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Kwathi uBhalaki esizwa ukuthi uBhalamu uyeza, waphuma ukumhlangabeza edolobheni lamaMowabi emngceleni wase-Arinoni emaphethelweni elizwe lakhe. ");
INSERT INTO nde_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","UBhalaki wathi kuBhalamu, “Angikuthumelanga ilizwi lokuphangisa na? Kungani ungezanga kimi? Kambe kangenelisi ukukupha umvuzo na?” ");
INSERT INTO nde_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","UBhalamu waphendula wathi, “Yebo, sengifikile kuwe khathesi. Kodwa angiyikukhuluma loba yini engiyifunayo. Ngizakhuluma lokho uNkulunkulu azakubeka emlonyeni wami kuphela.” ");
INSERT INTO nde_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Ngakho uBhalamu wahamba loBhalaki eKhiriyathi-Huzothi. ");
INSERT INTO nde_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","UBhalaki wenza umhlatshelo wenkomo lezimvu, njalo ezinye wazipha uBhalamu ezinye wazipha amakhosana ayehamba lawo. ");
INSERT INTO nde_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Ekuseni ngosuku olulandelayo uBhalaki wathatha uBhalamu waya eBhamothi-Bhali, kulapho abona khona izihonqo zabako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","UBhalamu wathi, “Ngakhela ama-alithare ayisikhombisa lapha, ube usungilungisela inkunzi eziyisikhombisa kanye lenqama eziyisikhombisa.” ");
INSERT INTO nde_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","UBhalaki wenza njengokutshiwo nguBhalamu, kwathi bobabili babo banikela ngenkunzi langenqama eyodwa e-alithareni linye ngalinye. ");
INSERT INTO nde_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Ngakho uBhalamu wasesithi kuBhalaki, “Hlala lapha eceleni lomnikelo wakho mina ngisaya eceleni. Mhlawumbe uThixo uzabuya azohlangana lami. Lokho azakuveza kimi ngizakutshela.” Wasesuka waya endaweni ephakemeyo eligceke. ");
INSERT INTO nde_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","UNkulunkulu wahlangana laye, njalo uBhalamu wathi, “Sengakhe ama-alithare ayisikhombisa njalo e-alithareni linye ngalinye nginikele ngenkunzi langenqama eyodwa.” ");
INSERT INTO nde_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Ngakho uThixo watshela uBhalamu wathi, “Buyela kuBhalaki uyemupha umbiko lo.” ");
INSERT INTO nde_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Ngakho wabuyela kuBhalaki wamfica emi eceleni komnikelo wakhe, kanye lawo wonke amakhosana amaMowabi. ");
INSERT INTO nde_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Ngakho uBhalamu wasesitsho umbiko wakhe: “UBhalaki ungilethe ngivela e-Aramu, inkosi yamaMowabi evela ezintabeni zasempumalanga. ‘Woza,’ watsho njalo, ‘ngiqalekisela uJakhobe; woza, mchothoze u-Israyeli.’ ");
INSERT INTO nde_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Ngingabaqalekisa njani labo abangaqalekiswanga nguNkulunkulu? Ngingachothoza njani labo abangazange bachothozwe nguThixo? ");
INSERT INTO nde_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Eziqongweni zamatshe ngiyababona, khonale phezulu bayangikhanyela. Ngibona abantu abahlezi ngokwehluka, njalo kabaziboni bengabalezizizwe. ");
INSERT INTO nde_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Ngubani ongabala uthuli lukaJakhobe loba ingxenye yesine yabako-Israyeli na? Yekela ngife ukufa kwabalungileyo, njalo sengathi isiphetho sami singafana lesabo!” ");
INSERT INTO nde_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","UBhalaki wathi kuBhalamu, “Kuyini osungenzele khona na? Ngize lawe ukuze uqalekise izitha zami, kodwa akulalutho olwenzileyo ngaphandle kokuzibusisa!” ");
INSERT INTO nde_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","UBhalamu, waphendula wathi, “Ngingakukhulumi na engikutshelwe nguThixo?” ");
INSERT INTO nde_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Ngakho uBhalaki wathi kuBhalamu, “Woza asiye kwenye indawo lapha ozababona khona; uzabona ingxenye kuphela kungeyisibo bonke. Khonapho-ke ungiqalekisele bona.” ");
INSERT INTO nde_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Wasesuka laye waya emangweni waseZofimu phezu kwentaba iPhisiga, kulapho akha khona ama-alithare ayisikhombisa wanikela ngenkunzi langenqama e-alithareni linye ngalinye. ");
INSERT INTO nde_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","UBhalamu wathi kuBhalaki, “Hlala lapha eceleni komnikelo wakho mina ngisayahlangana laye ngale.” ");
INSERT INTO nde_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","UThixo wahlangana loBhalamu wamtshela wathi, “Buyela kuBhalaki uyemnika umbiko lo.” ");
INSERT INTO nde_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Wasebuyela kuBhalaki wamfica emi eceleni komnikelo wakhe, kanye lamakhosana amaMowabi. UBhalaki wambuza wathi, “Utheni uThixo?” ");
INSERT INTO nde_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Wasesitsho umbiko wakhe: “Vuka, Bhalaki, njalo ulalele; zwana mina, ndodana kaZiphori. ");
INSERT INTO nde_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","UNkulunkulu kasumuntu, ukuthi angaqamba amanga, loba indodana yomuntu, yona eguquguqula ingqondo yayo. Kambe ukhuluma angenzi na? Uyathembisa angagcwalisi isithembiso na? ");
INSERT INTO nde_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Ngamukele umlayo wokubusisa; usebusisile, njalo ngingeke ngikuguqule lokho. ");
INSERT INTO nde_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Akulamabhadi ehlela kuJakhobe, akulasizi olubonakala ku-Israyeli. UThixo uNkulunkulu wabo ukanye labo; umkhosi weNkosi uphakathi kwabo. ");
INSERT INTO nde_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","UNkulunkulu wabakhipha eGibhithe; balamandla enyathi. ");
INSERT INTO nde_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Akulamilingo engalinga uJakhobe, akulamasalamusi angamelana lo-Israyeli. Khathesi sekuzathiwa ngoJakhobe kanye lo-lsrayeli, ‘Khangela okwenziwe nguNkulunkulu!’ ");
INSERT INTO nde_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Abantu bayavuka njengesilwanekazi; badlwanguluka njengesilwane sona esingaphumuliyo size sitshwabadele inyamazana yaso njalo sinathe igazi layo.” ");
INSERT INTO nde_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Ngakho uBhalaki wasesithi kuBhalamu, “Ungabaqalekisi, njalo ungababusisi!” ");
INSERT INTO nde_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","UBhalamu waphendula wathi, “Angikutshelanga na ukuthi ngenza engikutshelwe nguThixo?” ");
INSERT INTO nde_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Ngakho uBhalaki wathi kuBhalamu, “Woza, kahle ngikuse kwenye indawo. Mhlawumbe kuzamthokozisa uNkulunkulu akuvumele ukuthi ungiqalekisele bona ukhonale.” ");
INSERT INTO nde_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Ngakho uBhalaki wahamba loBhalamu baya phezu kwePheyori ekhangele enkangala. ");
INSERT INTO nde_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","UBhalamu wathi, “Ngakhela ama-alithare ayisikhombisa khonapha, ungilungisele inkunzi eziyisikhombisa lenqama eziyisikhombisa.” ");
INSERT INTO nde_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","UBhalaki wenza lokho ayekutshelwe nguBhalamu, wanikela inkunzi eyodwa lenqama e-alithareni linye ngalinye. ");
INSERT INTO nde_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Kwathi uBhalamu esebonile ukuthi kuyamthokozisa uThixo ukubusisa u-Israyeli, kasadinganga njalo imilingo njengakuqala, kodwa waphenduka wakhangela enkangala. ");
INSERT INTO nde_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Kwathi uBhalamu ekhangela wabona u-Israyeli emise izihonqo zakhe ngokwezizwe zakhe, uMoya kaNkulunkulu wehlela phezu kwakhe ");
INSERT INTO nde_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","wasesitsho isambulelo sakhe: “Isambulelo sikaBhalamu indodana kaBheyori, isambulelo salowo omehlo akhe abonisisa kuhle, ");
INSERT INTO nde_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","isambulelo salowo ozwa amazwi kaNkulunkulu, lowo obona umbono ovela kuSomandla, lowo owela phansi ngokuzehlisa, njalo omehlo akhe avulekile: ");
INSERT INTO nde_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Aze aba mahle amathente akho, Oh Jakhobe, izindawo zakho zokuhlala, Oh Israyeli! ");
INSERT INTO nde_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Njengezigodi zisabalele, njengezivande zisekele umfula, sanhlaba ehlanyelwe nguThixo, njengezihlahla zomsedari ezingasemanzini. ");
INSERT INTO nde_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Amanzi azageleza emigqonyeni yabo; inhlanyelo yabo ibe semanzini amanengi. Inkosi yabo izakuba nkulu kulo-Agagi; umbuso wabo uzakuba ngophakemeyo. ");
INSERT INTO nde_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","UNkulunkulu wabakhupha eGibhithe; balamandla anjengawenyathi. Bayazitshwabadela izizwe eziyizitha njalo bephule amathambo azo abe yizicucu; ngemitshoko yabo babacibe. ");
INSERT INTO nde_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Njengesilwane bayaqutha bacathame phansi, njengesilwanekazi, ngubani olesibindi sokubavusa na? Akuthi labo abakubusisayo babusiswe njalo lalabo abakuqalekisayo baqalekiswe!” ");
INSERT INTO nde_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Ngakho uBhalaki wamthukuthelela kakhulu uBhalamu. Watshaya izandla zakhe wathi, “Ngikubizele ukuthi uzengiqalekisela izitha zami, kodwa wena usubabusise okwamahlandla la amathathu. ");
INSERT INTO nde_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Wohle usuke nje khathesi ubuyele kini! Ngithe ngizakupha umvuzo omuhle kakhulu, pho-ke uThixo usekuvimbele ukwamukeliswa umvuzo.” ");
INSERT INTO nde_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","UBhalamu wamphendula uBhalaki wathi, “Kanti kangizitshelanga yini izithunywa zakho owazithuma kimi ukuthi, ");
INSERT INTO nde_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘Loba uBhalaki enganginika isigodlo sakhe sigcwele isiliva legolide, akulalutho lolulodwa ebengizalwenza ngokwentando yami, okuhle kumbe okubi, okuphambene lomlayo kaThixo, kufanele ngitsho lokho kuphela uThixo akutshoyo na’? ");
INSERT INTO nde_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Khathesi sengibuyela ebantwini bakithi, kodwa woza, ngikuxwayise ukuthi kuyini okuzakwenziwa ngabantu laba ebantwini bakho ensukwini ezilandelayo.” ");
INSERT INTO nde_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Ngakho uBhalamu wasesitsho isambulelo sakhe: “Isambulelo sikaBhalamu indodana kaBheyori, isambulelo salowo omehlo akhe abonisisa kuhle, ");
INSERT INTO nde_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","isambulelo salowo olalela ezwe amazwi kaNkulunkulu, ololwazi oluvela koPhezukonke, obona umbono ovela kuSomandla, owela phansi ngokuzehlisa, njalo omehlo akhe avulekile: ");
INSERT INTO nde_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Ngiyambona, kodwa hatshi khathesi; ngiyambona, kodwa kungesikho eduze. Inkanyezi izaphuma ivela kuJakhobe; intonga yobukhosi izaphakama ivela ku-Israyeli. Uzacobodisa amabunzi kaMowabi, inkakhayi zamadodana wonke kaSethi. ");
INSERT INTO nde_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","I-Edomi izanqotshwa; uSeyiri, oyisitha sakhe, uzanqotshwa, kodwa u-Israyeli uzakhula abe lamandla. ");
INSERT INTO nde_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Umbusi uzavela kuJakhobe njalo uzabhubhisa abaseleyo balelodolobho.” ");
INSERT INTO nde_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Ngakho uBhalamu wabona u-Amaleki wasesitsho isambulelo sakhe: “U-Amaleki wayengowokuqala ezizweni, kodwa ekucineni uzakuba lunxiwa.” ");
INSERT INTO nde_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Ngakho wasebona amaKheni wasesitsho isambulelo sakhe njalo: “Indawo yakho yokuhlala ivikelekile, isidleke sakho sakhelwe edwaleni; ");
INSERT INTO nde_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","kanti-ke lina maKheni lizabhujiswa ekuthunjweni kwenu yi-Asiriya.” ");
INSERT INTO nde_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Ngakho wasitsho isambulelo sakhe: “Kambe ngubani ongaphila nxa uNkulunkulu esenza lokhu na? ");
INSERT INTO nde_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Imikhumbi izakuza ivela okhunjini lwaseKhithimi; bazayehlula u-Asiriya kanye le-Ebha, kodwa laba bazachithwa babe ngamanxiwa.” ");
INSERT INTO nde_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Ngakho uBhalamu wasukuma wasebuyela kibo loBhalaki wahamba ngeyakhe indlela. ");
INSERT INTO nde_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Ngesikhathi u-Israyeli esehlala eShithima, amadoda aqala ukuhlobonga labafazi bamaMowabi, ");
INSERT INTO nde_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","bona abamema amadoda ako-Israyeli ukuba eze emihlatshelweni yabonkulunkulu babo. Abantu laba babesidla ukudla kwabonkulunkulu labo njalo bebakhothamele. ");
INSERT INTO nde_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Ngakho u-Israyeli wahlanganyela ekukhonzeni uBhali wasePheyori. Yikho uThixo wabathukuthelela kakhulu. ");
INSERT INTO nde_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","UThixo wathi kuMosi, “Thatha bonke abakhokheli balababantu, ubabulale njalo ubeke izidumbu zabo egcekeni emini libalele phambi kukaThixo, ukuze intukuthelo eyesabekayo kaThixo isuke ku-Israyeli.” ");
INSERT INTO nde_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Ngakho uMosi wathi kubahluleli bako-Israyeli, “Kumele ukuthi munye ngamunye wenu abulale amadoda akini lawo asehlanganyela ekukhonzeni uBhali wasePheyori.” ");
INSERT INTO nde_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Kwathi indoda ethile yako-Israyeli yaletha umfazi woMidiyani emulini yayo khonapho phambi kukaMosi laphambi kwabako-Israyeli bonke ababebuthene bekhala esangweni lethente lokuhlangana. ");
INSERT INTO nde_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Kwathi uFinehasi indodana ka-Eliyazari indodana ka-Aroni, umphristi, ekubona lokho, watshiya ababebuthene, ");
INSERT INTO nde_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","wathatha umkhonto wayilandela indoda leyo ethenteni. Wagadla ngomkhonto wabagwaza bobabili wayathutsha ngale komʼIsrayeli wangena wayathutshela esiswini sowesifazane. Ngakho sasesiphela isifo esasesihlasele abako-Israyeli; ");
INSERT INTO nde_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","kodwa labo abasebefile ngenxa yesifo babezinkulungwane ezingamatshumi amabili lane (24,000). ");
INSERT INTO nde_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“UFinehasi indodana ka-Eliyazari indodana ka-Aroni umphristi, uqedile ukuthukuthelela kwami abantu bako-Israyeli, ngoba wayetshisekela udumo lwami phakathi kwabo njengami, ukuze ngesihawu sami ngingabaqedi. ");
INSERT INTO nde_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Ngalokho umtshele ukuthi sengisenza isivumelwano sokuthula laye. ");
INSERT INTO nde_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Yena kanye lezizukulwane zakhe bazakuba lesivumelwano sobuphristi esimi kokuphela, ngoba utshisekelele udumo lukaNkulunkulu wakhe njalo wenzele abako-Israyeli indlela yokubuyisana.” ");
INSERT INTO nde_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Ibizo lendoda yako-Israyeli eyabulawa kanye lowesifazane weMidiyani kwakunguZimri indodana kaSalu, umkhokheli wabemuli yamaSimiyoni. ");
INSERT INTO nde_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Njalo ibizo lowesifazane woMidiyani owabulawayo lalinguKhozibhi indodakazi kaZuri, induna yesizwana semuli yamaMidiyani. ");
INSERT INTO nde_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Kumele liphathe amaMidiyani njengezitha njalo liwabulale, ");
INSERT INTO nde_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","ngoba aliphathe njengezitha alikhohlisa ngendaba kaPheyori kanye lodadewabo uKhozibhi indodakazi yomkhokheli wamaMidiyani, owesifazane owabulawa ngesikhathi sokuhlasela kwesifo esabakhona ngenxa kaPheyori.” ");
INSERT INTO nde_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Ngemva kwesifo uThixo wathi kuMosi lo-Eliyazari indodana ka-Aroni, umphristi, ");
INSERT INTO nde_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Balani abantu bonke abako-Israyeli ngezimuli zabo bonke abaleminyaka esukela kwengamatshumi amabili yokuzalwa kusiya phezulu abangaba libutho lako-Israyeli.” ");
INSERT INTO nde_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Ngakho uMosi lo-Eliyazari umphristi batshela abantu basemagcekeni aseMowabi eduze lomfula uJodani ngaphetsheya kweJerikho bathi kubo, ");
INSERT INTO nde_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Balani amadoda aleminyaka yokuzalwa esukela kwengamatshumi amabili kusiya phezulu, njengokulaywa kukaMosi nguThixo.” Laba ngabako-Israyeli abaphuma eGibhithe: ");
INSERT INTO nde_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Izizukulwane zikaRubheni izibulo lika-Israyeli, kwakuyilezi: uHanokhi, wadabula abosendo lwamaHanokhi; uPhalu, wadabula abosendo lwamaPhalu; ");
INSERT INTO nde_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","uHezironi wadabula abosendo lwamaHezironi; uKhami wadabula abosendo lwamaKhami. ");
INSERT INTO nde_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Laba babengabezinsendo zikaRubheni; inani labo lalizinkulungwane ezingamatshumi amane lantathu, lamakhulu ayisikhombisa alamatshumi amathathu (43,730). ");
INSERT INTO nde_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Indodana kaPhalu kwakungu-Eliyabi, ");
INSERT INTO nde_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","njalo amadodana ka-Eliyabi kwakunguNemuweli, uDathani kanye lo-Abhiramu. Bona laba uDathani lo-Abhiramu yibo ababeyizikhulu zabantu abahlamukela uMosi lo-Aroni njalo babengabanye babalandeli bakaKhora ngesikhathi behlamukela uThixo. ");
INSERT INTO nde_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Umhlaba wavuleka wabaginya kanye loKhora, kanye labalandeli babo abafa beqothulwa ngumlilo bengamadoda angamakhulu amabili alamatshumi amahlanu (250). Njalo baba yisixwayiso. ");
INSERT INTO nde_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Loba kunjalo, inzalo kaKhora kayibhubhanga yonke, yaphela. ");
INSERT INTO nde_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Izizukulwane zikaSimiyoni ngokwensendo zazo kwakuyilezi: uNemuweli wadabula abosendo lwamaNemuweli; uJamini wadabula abosendo lwamaJamini; uJakhini wadabula abosendo lwamaJakhini; ");
INSERT INTO nde_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","uZera wadabula abosendo lwamaZera; uShawuli wadabula abosendo lwamaShawuli. ");
INSERT INTO nde_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Laba babengabezinsendo zikaSimiyoni; inani labo lalingamadoda azinkulungwane ezingamatshumi amabili lambili, lamakhulu amabili (22,200). ");
INSERT INTO nde_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Izizukulwane zikaGadi ngokwensendo zazo kwakuyilezi: uZifoni wadabula abosendo lwamaZifoni; uHagi wadabula abosendo lwamaHagi; uShuni wadabula abosendo lwamaShuni; ");
INSERT INTO nde_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","u-Ozini wadabula abosendo lwama-Ozini; u-Eri wadabula abosendo lwama-Eri; ");
INSERT INTO nde_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","u-Arodi wadabula abosendo lwama-Arodi; u-Areli wadabula abosendo lwama-Areli. ");
INSERT INTO nde_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Laba bengabensendo zikaGadi; inani labo lalizinkulungwane ezingamatshumi amane lamakhulu amahlanu (40,500). ");
INSERT INTO nde_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","U-Eri lo-Onani babengamadodana kaJuda, kodwa bafela eKhenani. ");
INSERT INTO nde_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Izizukulwane zikaJuda ngokwensendo zazo kwakuyilezi: uShela wadabula abosendo lwakoShela; uPherezi wadabula abosendo lwamaPherezi; uZera wadabula abosendo lwamaZera. ");
INSERT INTO nde_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Izizukulwane zikaPherezi kwakuyilezi: uHezironi wadabula abosendo lwamaHezironi; uHamuli wadabula abosendo lwamaHamuli. ");
INSERT INTO nde_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Laba babezinsendo zikaJuda; inani labo lalizinkulungwane ezingamatshumi ayisikhombisa lesithupha, lamakhulu amahlanu (76,500). ");
INSERT INTO nde_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Izizukulwane zika-Isakhari ngokwensendo zazo kwakuyilezi: uThola wadabula abosendo lwamaThola; uPhuwa wadabula abosendo lwamaPhuwa; ");
INSERT INTO nde_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","uJashubi wadabula abosendo lwamaJashubi; uShimroni wadabula abosendo lwamaShimroni. ");
INSERT INTO nde_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Laba ngabensendo zika-Isakhari; inani labo lalizinkulungwane ezingamatshumi ayisithupha lane, lamakhulu amathathu (64,300). ");
INSERT INTO nde_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Izizukulwane zikaZebhuluni ngokwensendo zazo kwakuyilezi: uSeredi wadabula abosendo lwamaSeredi; u-Eloni wadabula abosendo lwama-Eloni; uJaliyeli wadabula abosendo lwamaJahileli. ");
INSERT INTO nde_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Laba ngabensendo zikaZebhuluni, inani labo lalizinkulungwane ezingamatshumi ayisithupha lamakhulu amahlanu (60,500). ");
INSERT INTO nde_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Izizukulwane zikaJosefa ngokwensendo zabo bezalwa nguManase lo-Efrayimi kwakuyilezi: ");
INSERT INTO nde_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Izizukulwane zikaManase ngokwensendo zazo kwakuyilezi: uMakhiri wadabula abosendo lwamaMakhiri (uMakhiri wayenguyise kaGiliyadi); uGiliyadi wadabula abosendo lwamaGiliyadi. ");
INSERT INTO nde_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Laba yizizukulwane zikaGiliyadi: u-Iyezeri wadabula abosendo lwama-Iyezeri; uHelekhi wadabula abosendo lwamaHeleki; ");
INSERT INTO nde_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","u-Asiriyeli wadabula abosendo lwama-Asiriyeli; uShekhemu wadabula abosendo lwamaShekhemu; ");
INSERT INTO nde_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","uShemida wadabula abosendo lwamaShemida; uHeferi wadabula abosendo lwamaHeferi. ");
INSERT INTO nde_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","(UZelofehadi indodana kaHeferi wayengelamadodana; wayelamadodakazi wodwa, amabizo awo ayenguMahila, uNowa, uHogila, uMilikha kanye loThiza.) ");
INSERT INTO nde_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Laba kwakungabensendo zikaManase; inani labo lalizinkulungwane ezingamatshumi amahlanu lambili, lamakhulu ayisikhombisa (52,700). ");
INSERT INTO nde_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Laba kwakuyizizukulwane zika-Efrayimi ngokwensendo zazo: uShuthela wadabula abosendo lwamaShuthela; uBhekheri wadabula abosendo lwamaBhekheri; uThahani wadabula abosendo lwamaThahani. ");
INSERT INTO nde_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Laba kwakuyizizukulwane zikaShuthela: u-Erani wadabula abosendo lwama-Erani. ");
INSERT INTO nde_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Laba kwakungabensendo zika-Efrayimi; inani labo lalizinkulungwane ezingamatshumi amathathu lambili, lamakhulu amahlanu (32,500). Laba kwakuyizizukulwane zikaJosefa ngokwensendo zazo. ");
INSERT INTO nde_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Izizukulwane zikaBhenjamini ngokwensendo zazo kwakuyilezi: uBhela wadabula abosendo lwamaBhela; u-Ashibheli wadabula abosendo lwama-Ashibheli; u-Ahirami wadabula abosendo lwama-Ahirami; ");
INSERT INTO nde_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","uShufamu wadabula abosendo lwamaShufamu; uHufamu wadabula usendo lwamaHufamu ");
INSERT INTO nde_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Izizukulwane zikaBhela ezazalwa ngu-Adi kanye loNamani yilezi: u-Adi wadabula abosendo lwama-Adithe; uNamani wadabula abosendo lwamaNamani. ");
INSERT INTO nde_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Laba kwakungabensendo zikaBhenjamini; inani labo lalizinkulungwane ezingamatshumi amane lanhlanu, lamakhulu ayisithupha (45,600). ");
INSERT INTO nde_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Laba babeyizizukulwane zikaDani ngokwensendo zazo: uShuhamu wadabula abosendo lwamaShuhamu. Laba babengabezinsendo zikaDani: ");
INSERT INTO nde_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Bonke babengabosendo lwamaShuhamu; njalo inani labo lalizinkulungwane ezingamatshumi ayisithupha lane, lamakhulu amane (64,400). ");
INSERT INTO nde_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Izizukulwane zika-Asheri ngokwensendo zazo kwakuyilezi: u-Imna wadabula abosendo lwama-Imna; u-Ishivi wadabula abosendo lwama-Ishivi; uBheriya wadabula abosendo lwamaBheriya; ");
INSERT INTO nde_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","njalo izizukulwane ezadatshulwa nguBheriya yilezi: uHebheri wadabula abosendo lwamaHebheri; uMalikhiyeli wadabula abosendo lwamaMalikhiyeli. ");
INSERT INTO nde_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","(U-Asheri wayelendodakazi okwakuthiwa nguSera.) ");
INSERT INTO nde_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Laba babengabezinsendo zika-Asheri; inani labo lalizinkulungwane ezingamatshumi amahlanu lantathu, lamakhulu amane (53,400). ");
INSERT INTO nde_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Izizukulwane zikaNafithali ngokwensendo zazo kwakuyilezi: uJaziyeli wadabula abosendo lwamaJaziyeli; uGuni wadabula abosendo lwamaGuni; ");
INSERT INTO nde_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","uJezeri wadabula abosendo lwamaJezeri; uShilemu wadabula abosendo lwamaShilemu. ");
INSERT INTO nde_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Laba babengabezinsendo zikaNafithali; inani labo lalizinkulungwane ezingamatshumi amane lanhlanu, lamakhulu amane (45,400). ");
INSERT INTO nde_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Inani lamadoda wonke ako-Israyeli lalizinkulungwane ezingamakhulu ayisithupha lanye, lamakhulu ayisikhombisa alamatshumi amathathu (601,730). ");
INSERT INTO nde_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Ilizwe lizakwahlukaniselwa abantu njengelifa labo kusiya ngenani lamabizo abo. ");
INSERT INTO nde_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Isizwe esikhulu uzasinika isabelo esikhulu, kuthi isizwana esincinyane usiphe isabelo esincane; isizwana ngasinye sizakwabelwa ilifa laso ngokuya ngenani lamabizo alabo ababhaliweyo. ");
INSERT INTO nde_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Iba leqiniso lokuthi ilizwe labiwa ngenkatho. Isabelo seqembu ngalinye sizakuya ngamabizo esizwana sabokhokho baso. ");
INSERT INTO nde_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Isabelo ngasinye selizwe sizakwehlukaniswa ngokwenza inkatho phakathi kwezizwana ezinkulu lezincinyane.” ");
INSERT INTO nde_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Laba ngabaLevi ababalwa kulandelwa insendo zabo: uGeshoni wadabula abosendo lwamaGeshoni; uKhohathi wadabula abosendo lwamaKhohathi; uMerari wadabula abosendo lwamaMerari. ");
INSERT INTO nde_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Laba labo babengabezinsendo zabaLevi: usendo lwamaLibhini, usendo lwamaHebhroni, usendo lwamaMahili, usendo lwamaMushi, usendo lwamaKhora. (UKhohathi wayengukhokho ka-Amramu; ");
INSERT INTO nde_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","inkosikazi ka-Amramu kwakunguJokhebhedi, oyisizukulwane sikaLevi, owayezalelwe eGibhithe ngabaLevi. Wazala lo-Amramu u-Aroni, loMosi kanye lodadewabo uMiriyemu. ");
INSERT INTO nde_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","U-Aroni wayenguyise kaNadabi, u-Abhihu, u-Eliyazari kanye lo-Ithamari. ");
INSERT INTO nde_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Kodwa uNadabi lo-Abhihu bafa baze banikele kuThixo ngomlilo ongavunyelwayo.) ");
INSERT INTO nde_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Bonke abaLevi abesilisa ababalwayo kusukela kwabalenyanga eyodwa yokuzalwa kusiya phezulu babezinkulungwane ezingamatshumi amabili lantathu (23,000). Kababalwanga ndawonye labanye abako-Israyeli ngoba kabanikwanga isabelo esiyilifa phakathi kwabo. ");
INSERT INTO nde_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Laba yibo ababalwa nguMosi lo-Eliyazari umphristi mhla bebala abako-Israyeli emagcekeni aseMowabi nganeno komfula iJodani malungana leJerikho. ");
INSERT INTO nde_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Kwakungekho loyedwa phakathi kwabo owayekhona mhla uMosi lo-Aroni bebala abako-Israyeli enkangala yaseSinayi. ");
INSERT INTO nde_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Ngoba uThixo wayetshilo kwabako-Israyeli labo ukuthi ngempela babezakufa enkangala, njalo kakho loyedwa wabo owasalayo ngaphandle kukaKhalebi indodana kaJefune loJoshuwa indodana kaNuni. ");
INSERT INTO nde_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Amadodakazi kaZelofehadi indodana kaHeferi, indodana kaGiliyadi, indodana kaMakhiri, indodana kaManase babengabezinsendo zikaManase indodana kaJosefa. Amabizo alawomadodakazi ayenguMahila, uNowa, uHogila, uMilikha, loThiza. Aya ");
INSERT INTO nde_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","esangweni leThente lokuHlangana ema phambi kukaMosi lo-Eliyazari umphristi, abakhokheli kanye lebandla lonke, athi, ");
INSERT INTO nde_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Ubaba wafela enkangala. Wayengekho phakathi kwabalandeli bakaKhora, bona ababambana ekuphikiseni kwabo uThixo, kodwa wafela isono sakhe njalo katshiyanga madodana. ");
INSERT INTO nde_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Kungani ibizo likababa licitsha kwabosendo lwakhe ngokungabi lendodana na? Sipheni ilifa lethu lathi ezihlotsheni zikababa.” ");
INSERT INTO nde_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Ngakho uMosi wethula indaba yawo phambi kukaThixo, ");
INSERT INTO nde_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","uThixo wathi kuye, ");
INSERT INTO nde_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Lokho okutshiwo ngamadodakazi kaZelofehadi kuqondile. Kufanele ubaphe isabelo sabo selifa ezihlotsheni zikayise njalo ubaphe ilifa likayise. ");
INSERT INTO nde_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Tshono uthi kwabako-Israyeli, ‘Nxa indoda ife ingelandodana, ilifa layo kaliphiwe indodakazi yayo. ");
INSERT INTO nde_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Nxa ingelandodakazi, ilifa layo kaliphiwe abafowabo. ");
INSERT INTO nde_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Nxa ingelabafowabo ilifa layo kaliphiwe abafowabo bakayise. ");
INSERT INTO nde_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Nxa uyise engelabafowabo, ilifa layo kaliphiwe oyisihlobo esiseduze kwabosendo lwayo, ukuze libe ngelakhe. Lokho kumele kube ngumthetho oyisimiso kwabako-Israyeli, njengokulaywa kukaMosi nguThixo.’ ” ");
INSERT INTO nde_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","UThixo wasesithi kuMosi, “Khwela entabeni le yase-Abharimi ukuze ubone ilizwe engilinike abako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Ngemva kokuba usulibonile, lawe uzalandela abakini, ufe njengomfowenu u-Aroni, ");
INSERT INTO nde_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","ngoba ekuhlamukeni kwabantu emanzini asenkangala yaseZini, lina lobabili kalilandelanga ukulaya kwami, ukungidumisa ngobungcwele bami emehlweni abo.” (La ayengamanzi aseMeribha Khadeshi, enkangala yaseZini.) ");
INSERT INTO nde_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","UMosi wathi kuThixo, ");
INSERT INTO nde_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Akuthi uThixo, uNkulunkulu wemimoya yabantu bonke akhethe indoda ezakhokhela abantu laba ");
INSERT INTO nde_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ekuphumeni lasekungeneni, lowo ozabakhokhela ekuphumeni lekungeneni kwabo, ukuze abantu bakaThixo bangafanani lezimvu ezingelamelusi.” ");
INSERT INTO nde_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Ngakho uThixo wathi kuMosi, “Thatha uJoshuwa indodana kaNuni, indoda elomoya wobukhokheli, ubeke isandla sakho phezu kwayo. ");
INSERT INTO nde_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Umise phambi kuka-Eliyazari umphristi laphambi kwebandla lonke ubusumbeka esikhundleni phambi kwabo. ");
INSERT INTO nde_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Umnike ingxenye yamandla akho ukuze isizwe sonke sako-Israyeli simlalele. ");
INSERT INTO nde_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Kumele ame phambi kuka-Eliyazari umphristi, yena ozamtholela izinqumo ngokubuza i-Urimi phambi kukaThixo. Ngokulawula kwakhe yena kanye labantu bonke bako-Israyeli bazaphuma, kuthi njalo ngokulawula kwakhe bangene.” ");
INSERT INTO nde_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","UMosi wenza njengokulaywa kwakhe nguThixo. Wathatha uJoshuwa wamisa phambi kuka-Eliyazari umphristi kanye laphambi kwebandla lonke. ");
INSERT INTO nde_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Wasebeka izandla zakhe phezu kwakhe embeka esikhundleni, njengokulaya kukaThixo ngoMosi. ");
INSERT INTO nde_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Phana abako-Israyeli umlayo lo uthi kubo, ‘Nanzelelani ukuthi lingilethele ngesikhathi esimisiweyo imihlatshelo yokudla, njengephunga elimnandi kimi.’ ");
INSERT INTO nde_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Tshono uthi kubo: ‘Lo ngumnikelo owenziwe ngomlilo okumele liwuse kuThixo: amazinyane emvu amabili angelasici njalo alomnyaka owodwa ezelwe, kube ngumnikelo wokutshiswa wansuku zonke. ");
INSERT INTO nde_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Linikele izinyane lemvu elilodwa ekuseni beselinikela elinye kusihlwa, ");
INSERT INTO nde_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","ndawonye lomnikelo wamabele ayisilinganiso sokwetshumi kwehefa yefulawa ecolekileyo exutshaniswe lengxenye yesine yehini yamafutha ahluzwe ema-oliveni. ");
INSERT INTO nde_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Lo ngumnikelo wokutshiswa wezikhathi zonke owamiswa entabeni yaseSinayi njengephunga elimnandi, umnikelo owenzelwa uThixo ngomlilo. ");
INSERT INTO nde_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Umnikelo wokunathwayo ozakwenziwa ndawonye lengxenye yesine yehini yokunathwayo okulemvubelo ndawonye lezinyane lemvu. Thela umnikelo wokunathwayo phambi kukaThixo endlini engcwele. ");
INSERT INTO nde_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Unikele izinyane lesibili kusihlwa ndawonye lomnikelo wamabele ofanayo lomnikelo wokunathwayo ofana lalowo owunikele ekuseni. Lo ngumhlatshelo wokudla, iphunga elimnandi kuThixo.’ ” ");
INSERT INTO nde_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ ‘Ngosuku lweSabatha, ulungise umnikelo wamazinyane emvu amabili alomnyaka owodwa ezelwe engelasici, ndawonye lomnikelo wokunathwayo kanye lomnikelo wamabele ozingxenye ezimbili zehefa etshumini zefulawa ecolekileyo exutshaniswe lamafutha. ");
INSERT INTO nde_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Lo ngumnikelo wokutshiswa kuwo wonke amasabatha, phezu komnikelo wokutshiswa lowokunathwayo ojayelekileyo.’ ” ");
INSERT INTO nde_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ ‘Ngosuku lwakuqala inyanga zonke, letha kuThixo umnikelo wokutshiswa wenkunzi ezingamaguqa ezimbili, inqama eyodwa lamazinyane ezimvu amaduna alomnyaka ezelwe, angelasici. ");
INSERT INTO nde_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Inkunzi eyodwa izahamba lomnikelo wamabele ozingxenye ezintathu etshumini zehefa yefulawa ecolekileyo exutshaniswe lamafutha; inqama izahamba lomnikelo wamabele ayingxenye ezimbili etshumini zehefa yefulawa ecolekileyo exutshaniswe lamafutha; ");
INSERT INTO nde_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","izinyane lemvu ngalinye lizahamba lomnikelo wamabele oyingxenye eyodwa etshumini lehefa yefulawa ecolekileyo exutshaniswe lamafutha. Lokhu ngokomnikelo wokutshiswa, iphunga elimnandi, umnikelo owenzelwa uThixo ngomlilo. ");
INSERT INTO nde_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Inkunzi nganye izahamba lomnikelo wokunathwayo okuyingxenye yehini yewayini; lenqama, ingxenye yesithathu yehini; kuthi izinyane lemvu ngalinye lihambe lengxenye yesine yehini. Lo ngumnikelo wokutshiswa owenyanga zonke okumele wenziwe ekuthwaseni kwezinyanga zonke ngomnyaka. ");
INSERT INTO nde_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Ngaphandle komnikelo wokutshiswa ojayelekileyo kanye lomnikelo wakhona wokunathwayo, impongo eyodwa kumele iphiwe uThixo njengomnikelo wesono.’ ” ");
INSERT INTO nde_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ ‘Ngosuku lwetshumi lane ngenyanga yakuqala kuzakuba lePhasika likaThixo. ");
INSERT INTO nde_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Ngosuku lwetshumi lanhlanu lwaleyonyanga kuzakuba lomkhosi; okwensuku eziyisikhombisa lizakudla isinkwa esingelamvubelo. ");
INSERT INTO nde_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Ngosuku lwakuqala lenze umbuthano ongcwele njalo lingenzi imisebenzi yenu yansuku zonke. ");
INSERT INTO nde_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Kodwa linikele kuThixo umnikelo owenziwe ngomlilo, umnikelo wokutshiswa owenkunzi ezingamaguqa ezimbili, inqama eyodwa kanye lamazinyane ezimvu amaduna ayisikhombisa alomnyaka owodwa ezelwe, konke kungelasici. ");
INSERT INTO nde_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Kuzakuthi inkunzi nganye liyinikele kanye lomnikelo wamabele ayingxenye yokuthathu etshumini lehefa yefulawa ecolekileyo exutshaniswe lamafutha; kuthi inqama ihambe lokubili etshumini; ");
INSERT INTO nde_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","kuthi-ke linye ngalinye izinyane lemvu kwayisikhombisa, lihambe lokukodwa etshumini. ");
INSERT INTO nde_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Akubekhona lempongo eyodwa ukuba ibe ngumnikelo wesono ukuzenzela indlela yokubuyisana. ");
INSERT INTO nde_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Phezu kwalokho lungisani umnikelo wokutshiswa wekuseni ojayelekileyo. ");
INSERT INTO nde_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Ngaleyondlela nikelani umhlatshelo wokudla okwensuku eziyisikhombisa kube liphunga elimnandi kuThixo; lokhu kumele kulungiswe kusengezelela umnikelo ojayelekileyo wokutshiswa kanye lomnikelo wakho wokunathwayo. ");
INSERT INTO nde_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Ngosuku lwesikhombisa lizakuba lombuthano ongcwele njalo lingenzi imisebenzi yenu yansuku zonke.’ ” ");
INSERT INTO nde_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ ‘Ngosuku lwezithelo zakuqala, nxa lisethula kuThixo umnikelo wamabele amatsha ngesikhathi soMkhosi wamaViki, wobani lombuthano ongcwele njalo lingenzi imisebenzi yensukwini. ");
INSERT INTO nde_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Nikelani umnikelo wokutshiswa ngenkunzi ezingamaguqa ezimbili, inqama eyodwa kanye lamazinyane amaduna ayisikhombisa awezimvu alomnyaka owodwa ezelwe kube liphunga elimnandi kuThixo. ");
INSERT INTO nde_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Kuzakuthi inkunzi nganye liyilungise kanye lomnikelo wamabele ayingxenye yokuthathu etshumini lehefa yefulawa ecolekileyo exutshaniswe lamafutha; kuthi inqama ihambe lokubili etshumini; ");
INSERT INTO nde_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","kuthi-ke linye ngalinye izinyane lemvu ngalinye kwayisikhombisa, lihambe lokukodwa etshumini. ");
INSERT INTO nde_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Akubekhona lempongo eyodwa ukuba ibe ngumnikelo wesono ukuzenzela indlela yokubuyisana. ");
INSERT INTO nde_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Lungisani lokho ndawonye leminikelo yokunathwayo, ukwengezelela eminikelweni ejayelekileyo yokutshiswa kanye lomnikelo wawo wamabele. Nanzelelani ukuthi lezozifuyo azilasici.’ ” ");
INSERT INTO nde_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ ‘Ngosuku lwakuqala ngenyanga yesikhombisa yenzani umbuthano ongcwele njalo lingenzi imisebenzi yansuku zonke. Lusuku lwenu lokutshaya amacilongo. ");
INSERT INTO nde_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Lungisani umnikelo wokutshiswa, kube liphunga elimnandi kuThixo, inkunzi eliguqa eyodwa, inqama eyodwa lamazinyane ezimvu amaduna ayisikhombisa alomnyaka owodwa wokuzalwa, konke kungelasici. ");
INSERT INTO nde_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Kuzakuthi inkunzi leyo liyilungise kanye lomnikelo wamabele azingxenye ezintathu kokulitshumi kwehefa yefulawa ecolekileyo exutshaniswe lamafutha; kuthi inqama ibe lokubili etshumini; ");
INSERT INTO nde_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","kuthi-ke linye ngalinye izinyane lemvu kwayisikhombisa, lihambe lokukodwa etshumini. ");
INSERT INTO nde_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Akubekhona lempongo eyodwa ukuba ibe ngumnikelo wesono ukuzenzela indlela yokubuyisana. ");
INSERT INTO nde_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Lokhu kuzabe kusengezelela iminikelo yokutshiswa yenyanga zonke kanye leyezinsuku zonke ndawonye leminikelo yamabele leyokunathwayo njengokumisiweyo. Le yimihlatshelo yokudla eyenzelwa uThixo, iphunga elimnandi.’ ” ");
INSERT INTO nde_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ ‘Ngosuku lwetshumi lwaleyonyanga yesikhombisa yenzani umbuthano ongcwele. Kumele lizidele njalo lingasebenzi. ");
INSERT INTO nde_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Nikelani umnikelo wokutshiswa, kube liphunga elimnandi kuThixo, inkunzi eliguqa eyodwa, inqama eyodwa lamazinyane ezimvu amaduna ayisikhombisa alomnyaka owodwa wokuzalwa, konke kungelasici. ");
INSERT INTO nde_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Kuzakuthi inkunzi leyo uyilungise kanye lomnikelo wamabele azingxenye ezintathu kokulitshumi zehefa zingezefulawa ecolekileyo exutshaniswe ngamafutha; kuthi inqama ihambe lokubili etshumini; ");
INSERT INTO nde_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","kuthi-ke linye ngalinye izinyane lemvu kwayisikhombisa, lihambe lokukodwa etshumini. ");
INSERT INTO nde_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Akubekhona lempongo eyodwa ukuba ibe ngumnikelo wesono, phezu komnikelo wesono, owokubuyisana kanye lomnikelo wokutshiswa wansuku zonke lomnikelo wawo wamabele, kanye leminikelo yayo yokunathwayo.’ ” ");
INSERT INTO nde_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ ‘Ngosuku lwetshumi lanhlanu ngenyanga yesikhombisa, yenzani umbuthano ongcwele njalo lingenzi imisebenzi yensukwini. Thakazelelani lumkhosi kuThixo okwensuku eziyisikhombisa. ");
INSERT INTO nde_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Nikelani umnikelo wokutshiswa, kube liphunga elimnandi kuThixo, umnikelo wokutshiswa wenkunzi ezingamaguqa ezilitshumi lantathu, inqama ezimbili lamazinyane ezimvu amaduna alitshumi lane alomnyaka ezelwe, konke kungelasici. ");
INSERT INTO nde_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Kuthi inkunzi inye ngayinye kwezilitshumi lantathu liyilungise kanye lomnikelo wamabele azingxenye ezintathu kokulitshumi kwehefa lefulawa ecolekileyo exutshaniswe lamafutha; kuthi inqama nganye kwezimbili, ihambe lokubili etshumini; ");
INSERT INTO nde_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","kuthi-ke linye ngalinye izinyane lemvu kwalitshumi lane, lihambe lokukodwa etshumini. ");
INSERT INTO nde_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Akube lempongo eyodwa ezakuba ngumnikelo wesono, phezu komnikelo wokutshiswa wansuku zonke ndawonye lomnikelo wawo wamabele kanye lowokunathwayo. ");
INSERT INTO nde_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Ngosuku lwesibili lungisani inkunzi ezingamaguqa ezilitshumi lambili, inqama ezimbili lamazinyane ezimvu amaduna alitshumi lane alomnyaka owodwa wokuzalwa, konke kungelasici. ");
INSERT INTO nde_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Ndawonye lenkunzi, inqama kanye lamawundlu, linikele iminikelo yakho yamabele kanye leyokunathwayo kusiya ngenani elimisiweyo. ");
INSERT INTO nde_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Akube lempongo eyodwa ukuba ibe ngumnikelo wesono, phezu komnikelo wokutshiswa wansuku zonke ndawonye lomnikelo wawo wamabele, kanye leminikelo yayo yokunathwayo. ");
INSERT INTO nde_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Ngosuku lwesithathu nikelani inkunzi ezilitshumi lanye, inqama ezimbili kanye lamazinyane ezimvu alitshumi lane alomnyaka owodwa wokuzalwa, konke kungelasici. ");
INSERT INTO nde_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Ndawonye lenkunzi, inqama, kanye lamawundlu, linikele iminikelo yakho yamabele kanye leyokunathwayo kusiya ngenani elimisiweyo. ");
INSERT INTO nde_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Akube lempongo eyodwa ukuba ibe ngumnikelo wesono, phezu komnikelo wokutshiswa wansuku zonke ndawonye lomnikelo wakho wamabele kanye lomnikelo wokunathwayo. ");
INSERT INTO nde_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Ngosuku lwesine nikelani inkunzi ezilitshumi, inqama ezimbili kanye lamazinyane ezimvu alitshumi lane amaduna alomnyaka owodwa wokuzalwa, konke kungelasici. ");
INSERT INTO nde_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Ndawonye lenkunzi, inqama kanye lamawundlu, linikele iminikelo yakho yamabele kanye leyokunathwayo kusiya ngenani elimisiweyo. ");
INSERT INTO nde_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Akube lempongo eyodwa ezakuba ngumnikelo wesono, phezu komnikelo wokutshiswa wansuku zonke ndawonye lomnikelo wawo wamabele kanye lowokunathwayo. ");
INSERT INTO nde_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Ngosuku lwesihlanu nikelani inkunzi eziyisificamunwemunye, inqama ezimbili kanye lamazinyane ezimvu alitshumi lane amaduna alomnyaka owodwa wokuzalwa, konke kungelasici. ");
INSERT INTO nde_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Ndawonye lenkunzi, inqama kanye lamawundlu, linikele iminikelo yakho yamabele kanye leyokunathwayo kusiya ngenani elimisiweyo. ");
INSERT INTO nde_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Akube lempongo eyodwa ukuba ibe ngumnikelo wesono, phezu komnikelo wokutshiswa wansuku zonke ndawonye lomnikelo wakho wamabele kanye lomnikelo wakho wokunathwayo. ");
INSERT INTO nde_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Ngosuku lwesithupha nikelani inkunzi eziyisificaminwembili, inqama ezimbili lamazinyane ezimvu amaduna alitshumi lane alomnyaka owodwa wokuzalwa, konke kungelasici. ");
INSERT INTO nde_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Ndawonye lenkunzi, inqama kanye lamawundlu, linikele iminikelo yakho yamabele kanye leyokunathwayo kusiya ngenani elimisiweyo. ");
INSERT INTO nde_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Akube lempongo eyodwa ukuba ibe ngumnikelo wesono, phezu komnikelo wokutshiswa wansuku zonke ndawonye lomnikelo wakho wamabele kanye lomnikelo wakho wokunathwayo. ");
INSERT INTO nde_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Ngosuku lwesikhombisa nikelani inkunzi eziyikhombisa, inqama ezimbili lamazinyane ezimvu amaduna alitshumi lane alomnyaka owodwa wokuzalwa, konke kungelasici. ");
INSERT INTO nde_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Ndawonye lenkunzi, inqama lamawundlu, linikele iminikelo yakho yamabele kanye leyokunathwayo kusiya ngenani elimisiweyo. ");
INSERT INTO nde_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Akube lempongo eyodwa ukuba ibe ngumnikelo wesono, phezu komnikelo wokutshiswa wansuku zonke ndawonye lomnikelo wakho wokunathwayo. ");
INSERT INTO nde_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Ngosuku lwesificaminwembili buthanani njalo lingenzi imisebenzi yensukwini. ");
INSERT INTO nde_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Nikelani umnikelo owenziwe ngomlilo kube liphunga elimnandi kuThixo, umnikelo wokutshiswa owenkunzi eyodwa, inqama eyodwa kanye lamazinyane ezimvu amaduna ayisikhombisa alomnyaka owodwa wokuzalwa, konke kungelasici. ");
INSERT INTO nde_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Ndawonye lenkunzi, inqama kanye lamazinyane ezimvu, linikele iminikelo yakho yamabele kanye leminikelo yakho yokunathwayo kusiya ngenani elimisiweyo. ");
INSERT INTO nde_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Akube lempongo eyodwa ukuba ibe ngumnikelo wesono, phezu komnikelo wokutshiswa wansuku zonke ndawonye lomnikelo wakho wamabele kanye lomnikelo wakho wokunathwayo. ");
INSERT INTO nde_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Ukwengezelela kulokho elinikela ngakho ngesifungo loba iminikelo yenu yokuzithandela, nikelani lokhu kuThixo emikhosini yenu emisiweyo: iminikelo yenu yokutshiswa, iminikelo yamabele, iminikelo yokunathwayo kanye leminikelo yobudlelwano.’ ” ");
INSERT INTO nde_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","UMosi watshela abako-Israyeli konke lokho uThixo ayemlaye ngakho. ");
INSERT INTO nde_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","UMosi wathi kwabazinhloko zezizwana zabako-Israyeli: “Nanku ukulaya kukaThixo: ");
INSERT INTO nde_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Nxa indoda isenza isifungo kuThixo loba isenza isifungo iziphe icala ngokuthembisa, akumelanga yephule isithembiso sayo kodwa kumele igcwalise ngokwenza konke ekutshiloyo. ");
INSERT INTO nde_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Nxa intombazana elokhu isezandleni zabazali bayo isenza isifungo kuThixo loba iziphe icala ngokuthembisa ");
INSERT INTO nde_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","kuthi uyise abesesizwa ngesifungo loba isithembiso sayo kodwa uyise angaze atsho lutho ngalokho kuyo, kutsho ukuthi izinqumo kanye lezithembiso zayo njengokuzethesa kwayo lowomlandu kuzakuma kunjalo. ");
INSERT INTO nde_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Kodwa uyise angakuzwa lokho ayalise asikho isifungo lesithembiso sayo esizasebenza; uThixo uzayikhulula leyontombazana ngoba yalelwe nguyise. ");
INSERT INTO nde_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Nxa ingenda ngemva kokwenza isifungo loba kube ngemva kokuba indebe zayo zike zatsho isithembiso ngokucunuka izethesa icala ");
INSERT INTO nde_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","kuthi indoda yayo ikuzwe lokho kodwa ingatsho lutho kuyo, lokho-ke kutsho ukuthi izifungo zayo loba izithembiso eyazethesa icala ngazo zizakuma zinjalo. ");
INSERT INTO nde_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Kodwa nxa umkayo eyalela ekukuzweni kwakhe, kutsho ukuthi umkayo usesuse icala lesifungo loba isithembiso ngokujaha kwayo, ngakho uThixo uzayikhulula. ");
INSERT INTO nde_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Loba yisiphi isifungo loba isithembiso esenziwe ngumfelokazi loba umfazi owehlukana lendoda yakhe kuyisibopho kuye. ");
INSERT INTO nde_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Nxa owesifazane ohlala lomkakhe esenza isinqumo loba ezethesa icala lesithembiso ngesifungo ");
INSERT INTO nde_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","kuthi indoda yakhe ikuzwe kodwa ingaze yatsho lutho kuye ingamaleli, kutsho ukuthi izifungo zakhe zonke lezithembiso zokuzethesa icala zizakuma zinjalo. ");
INSERT INTO nde_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Kodwa indoda yakhe ingakuzwa lokho imalise, kutsho ukuthi akukho isifungo loba isithembiso esivela endebeni zakhe esizakuma njalo. Indoda yakhe isikwalile lokho, ngakho uThixo uzamkhulula. ");
INSERT INTO nde_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Indoda yakhe ilakho ukuqinisa loba ukwala loba yisiphi isifungo azasenza loba yisiphi isifungo sesithembiso sokuzidela kwakhe. ");
INSERT INTO nde_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Kodwa nxa indoda yakhe ingatshongo lutho kuye ngakho okwensuku, kuzakutsho ukuthi iyaziqinisa zonke izifungo loba izithembiso eziyisibopho kowesifazane. Indoda yakhe iyakuqinisa lokho ngokungatsho lutho kuye ekukuzweni kwakhe lokho. ");
INSERT INTO nde_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Kodwa-ke, nxa angakwenqabela ngemva kwesikhathi ezwile ngakho, kutsho ukuthi usethwele icala lakhe.” ");
INSERT INTO nde_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Le yiyo imithetho eyaphiwa uMosi nguThixo emayelana lokuhlalisana kwendoda lomkayo, njalo phakathi kukayise lendodakazi yakhe esakhulayo elokhu isesezandleni zakhe. ");
INSERT INTO nde_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Phindisela kumaMidiyani usenzela abako-Israyeli. Ngemva kwalokho, uzalandela okhokho bakho.” ");
INSERT INTO nde_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Ngakho uMosi wathi ebantwini, “Hlomisani amanye amadoda aye empini ayekulwa lamaMidiyani kanye lokuphindisela kukaThixo kuwo. ");
INSERT INTO nde_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Thumelani amadoda ayinkulungwane avela esizwaneni ngasinye sako-Israyeli ukuyahlasela.” ");
INSERT INTO nde_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Ngakho amadoda azinkulungwane ezilitshumi lambili ahlomela ukuyahlasela, kuyinkulungwane yamadoda avela esizwaneni ngasinye, ebuthwe ngosendo lunye ngalunye kwabako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","UMosi wabathumela ukuyahlasela, kuyinkulungwane evela esizwaneni ngasinye, kanye loFinehasi indodana ka-Eliyazari, umphristi, owathatha izitsha endlini engcwele kanye lamacilongo okubikelana. ");
INSERT INTO nde_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Balwa lamaMidiyani, njengokulaywa kukaMosi nguThixo, babulala amadoda wonke. ");
INSERT INTO nde_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Phakathi kwababulawayo kwakulamakhosi amahlanu amaMidiyani abalisa u-Evi, uRekhemu, uZuri, uHuri kanye loRebha. Babulala loBhalamu indodana kaBheyori ngenkemba. ");
INSERT INTO nde_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Abako-Israyeli bathumba abesifazane bamaMidiyani labantwana, basebethumba lemihlambi yenkomo zamaMidiyani, leyezimvu kanye lokubutha impahla njengempango. ");
INSERT INTO nde_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Batshisa wonke amadolobho lapha okwakuhlala khona amaMidiyani, kanye lezihonqo zawo zonke. ");
INSERT INTO nde_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Bathatha konke ababekubuthile lababekuthumbile, kuhlanganisa abantu lezifuyo, ");
INSERT INTO nde_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","njalo basebeletha abathunjwa, okuthunjiweyo lokubuthiweyo kuMosi lo-Eliyazari umphristi kanye lebandleni lonke lako-Israyeli ezihonqweni zabo zasemagcekeni aseMowabi, ngaseJodani ngaphetsheya ukuvelela eJerikho. ");
INSERT INTO nde_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","UMosi, u-Eliyazari umphristi kanye labo bonke abakhokheli babantu baphuma ukuyabahlangabeza ngaphandle kwezihonqo. ");
INSERT INTO nde_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","UMosi wathukuthelela abalawuli bamabutho, ababelawula amaxuku ezinkulungwane lababelawula amaxuku angamakhulu, ababevela ekuhlaseleni. ");
INSERT INTO nde_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","UMosi wababuza wathi, “Selivumele abesifazane ukuthi baphile na? ");
INSERT INTO nde_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Yibo ababelandela ukucebisa kukaBhalamu njalo bahugela abako-Israyeli ekungathembekini kuThixo kulokhu okwenzakala ePheyori, kwaze kwathi abantu bakaThixo behlelwa yisifo. ");
INSERT INTO nde_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Khona khathesi bulalani abafana bonke. Njalo libulale wonke owesifazane oseke walala lendoda, ");
INSERT INTO nde_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","kodwa lizigcinele loba yiphi intombazana engakaze ilale lendoda. ");
INSERT INTO nde_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Lina lonke elibulele loba ngubani loba lina elike lathinta loba ngubani obuleweyo lizahlala ngaphandle kwezihonqo okwensuku eziyisikhombisa. Ngosuku lwesithathu langosuku lwesikhombisa lizihlambulule lina kanye labathunjwa benu. ");
INSERT INTO nde_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Lihlambulule zonke izembatho kanye lakho konke okwenziwe ngesikhumba, uboya bembuzi loba okwezigodo.” ");
INSERT INTO nde_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Ngakho u-Eliyazari umphristi wathi kwabebutho ababeye empini, “Nanku okufaneleyo ngokomthetho owaphiwa uMosi nguThixo: ");
INSERT INTO nde_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Igolide, isiliva, ithusi, insimbi, izenge lomnuso, ");
INSERT INTO nde_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","kanye lakho konke okunye okungatshi kutshabalale emlilweni kumele kudlule emlilweni, ngalokho kuzabe sekuhlambulukile. Kodwa kumele njalo kube sekuhlanjululiwe ngamanzi okuhlambulula. Kanti njalo kuthi lakuphi okungeke kwamelana lomlilo kumele kudluliswe kulawomanzi. ");
INSERT INTO nde_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Ngosuku lwesikhombisa gezisani izigqoko zenu ukuze lihlambuluke. Ngemva kwalokho selingangena ezihonqweni.” ");
INSERT INTO nde_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Wena kanye lo-Eliyazari umphristi kanye labazinhloko zezimuli zabantu lizabala abantu bonke lezinyamazana, konke okwathunjwayo. ");
INSERT INTO nde_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Yabelani amabutho ayesempini kanye labantu bonke impango ngokulinganayo. ");
INSERT INTO nde_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Emabuthweni alwayo empini, thathani okukodwa emakhulwini amahlanu kube yisabelo sikaThixo, kumbe ngabantu, inkomo, obabhemi, izimvu loba imbuzi. ");
INSERT INTO nde_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Thathani lesisabelo engxenyeni yesabo liyiphe u-Eliyazari umphristi ibe yingxenye kaThixo. ");
INSERT INTO nde_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Kungxenye yabako-Israyeli, khethani okukodwa ematshumini amahlanu, phakathi kwabantu, inkomo, obabhemi, izimvu, imbuzi loba ezinye izifuyo. Zipheni abaLevi, bona abalomlandu wokunakekela ithabanikeli likaThixo.” ");
INSERT INTO nde_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Ngakho uMosi lo-Eliyazari umphristi benza njengokulaywa kukaMosi nguThixo. ");
INSERT INTO nde_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Impango eyayisele kulokho okwathathwa ngamabutho kwakuyizimvu eziyizinkulungwane ezingamakhulu ayisithupha lamatshumi ayisikhombisa lanhlanu (675,000), ");
INSERT INTO nde_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","inkomo eziyizinkulungwane ezingamatshumi ayisikhombisa lambili (72,000), ");
INSERT INTO nde_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","obabhemi abazinkulungwane ezingamatshumi ayisithupha lanye (61,000) ");
INSERT INTO nde_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","kanye labesifazane abazinkulungwane ezingamatshumi amathathu lambili (32,000) ababengakaze balale lamadoda. ");
INSERT INTO nde_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Ingxenye yesabelo salabo abalwayo empini: sasingesezimvu eziyizinkulungwane ezingamakhulu amathathu lamatshumi amathathu alesikhombisa, lamakhulu amahlanu (337,500), ");
INSERT INTO nde_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","lapho abakhipha khona umnikelo kaThixo oyizimvu ezingamakhulu ayisithupha lamatshumi ayisikhombisa lanhlanu (675); ");
INSERT INTO nde_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","lenkomo eziyizinkulungwane ezingamatshumi amathathu lesithupha (36,000), okwakhitshwa kizo ezomnikelo kaThixo ezingamatshumi ayisikhombisa lambili; ");
INSERT INTO nde_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","obabhemi abazinkulungwane ezingamatshumi amathathu lamakhulu amahlanu (30,500), kwathi umnikelo kaThixo waba ngamatshumi ayisithupha lanye; ");
INSERT INTO nde_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","abantu abazinkulungwane ezilitshumi lasithupha (16,000), kwanikelwa kuThixo ngabangamatshumi amathathu lambili. ");
INSERT INTO nde_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","UMosi wanika u-Eliyazari umphristi isabelo sikaThixo, njengokulaywa kukaMosi nguThixo. ");
INSERT INTO nde_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Ingxenye yesabelo sabako-Israyeli uMosi wayeseyehlukanise leyamabutho, ");
INSERT INTO nde_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","ingxenye eyayingeyabantu yaba yizimvu eziyizinkulungwane ezingamakhulu amathathu lamatshumi amathathu lesikhombisa, lamakhulu amahlanu (337,500), ");
INSERT INTO nde_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","inkomo eziyizinkulungwane ezingamatshumi amathathu lasithupha (36,000), ");
INSERT INTO nde_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","obabhemi abazinkulungwane ezingamatshumi amathathu lamakhulu amahlanu (30, 500) ");
INSERT INTO nde_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","kanye labantu abazinkulungwane ezilitshumi lasithupha (16,000). ");
INSERT INTO nde_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Engxenyeni yesabelo sabako-Israyeli, uMosi waqambula okukodwa ematshumini amahlanu abantu lasezifuyweni, njengokulaywa kwakhe nguThixo, njalo wakuqhubela abaLevi, bona ababelomlandu wokunakekela ithabanikeli likaThixo. ");
INSERT INTO nde_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Ngakho izikhulu ezaziphethe izigaba zebutho, abalawuli bamaxuku azinkulungwane kanye labalawuli bamaxuku angamakhulu baya kuMosi ");
INSERT INTO nde_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","bafika bathi kuye, “Izinceku zakho seziwabalile amabutho eziwalawulayo, akukho lelilodwa ibutho elingekho. ");
INSERT INTO nde_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Ngakho sesilethe njengomnikelo kuThixo izinto zegolide esizitholileyo munye ngamunye, izigqizo, amasongo, izindandatho, amacici kanye lezigqizo zentanyeni, ukuzenzela indlela yokubuyisana phambi kukaThixo.” ");
INSERT INTO nde_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","UMosi lo-Eliyazari umphristi bemukela igolide elalivela kubo, konke lokho kungokubaziweyo. ");
INSERT INTO nde_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Lonke igolide elalethwa ngabalawuli emunye elawula amaxuku azinkulungwane labalawuli emunye elawula ikhulu lelo uMosi lo-Eliyazari abalethula njengesipho kuThixo lalilesisindo samashekeli azinkulungwane ezilitshumi lesithupha, lamakhulu ayisikhombisa alamatshumi amahlanu (16,750). ");
INSERT INTO nde_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Ibutho ngalinye lazithumbela okwalo lalo. ");
INSERT INTO nde_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","UMosi lo-Eliyazari umphristi bemukela igolide elalivela kubalawuli emunye elawula amaxuku azinkulungwane lakubalawuli emunye elawula amaxuku angamakhulu, balisa ethenteni lokuhlangana ukuze kube yisikhumbuzo kwabako-Israyeli phambi kukaThixo. ");
INSERT INTO nde_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","AbakoRubheni labakoGadi ababelemihlambi emikhulu yenkomo leyezimvu babona ukuthi amadlelo emangweni weJazeri leGiliyadi ayemahle ezifuyweni. ");
INSERT INTO nde_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Ngakho baya kuMosi laku-Eliyazari umphristi lakubakhokheli babantu, bathi, ");
INSERT INTO nde_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Umhlaba we-Atharothi, leDibhoni, leJazeri, leNimra, leHeshibhoni, le-Eliyale, leSebhami, leNebho kanye leBheyoni, ");
INSERT INTO nde_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","uThixo awunqoba phambi kwabako-Israyeli, ngumhlaba olungele izifuyo, njalo thina nceku zenu silezifuyo.” ");
INSERT INTO nde_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Basebesithi, “Nxa sifumene umusa emehlweni enu, lelilizwe aliphiwe izinceku zenu libe yisabelo sethu. Lingenzi ukuba sichaphe uJodani.” ");
INSERT INTO nde_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","UMosi wabuza abakoGadi labakoRubheni wathi, “Kambe lingahlala lapha amanye amadoda akini esiya empini na? ");
INSERT INTO nde_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Kungani lithelela abako-Israyeli ukwesaba ukuchaphela elizweni abaliphiwa nguThixo na? ");
INSERT INTO nde_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Yikho lokhu okwenziwa ngoyihlo ekubathumeni kwami besuka eKhadeshi Bhaneya ukuyahlola ilizwe. ");
INSERT INTO nde_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Bathi sebehambe baze bayafika eSigodini sase-Eshikholi balibona ilizwe, bathelela abako-Israyeli ukwesaba ukungena elizweni abaliphiwa nguThixo. ");
INSERT INTO nde_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Ulaka lukaThixo lwaqubuka ngalolosuku waze wenza lesisifungo. ");
INSERT INTO nde_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Ngenxa yokuthi abangilandelanga ngezinhliziyo zabo ezipheleleyo, kakho loyedwa emadodeni wonke aleminyaka engamatshumi amabili kusiya phezulu okuzalwa kwabavela eGibhithe ozabona ilizwe engalithembisa u-Abhrahama, u-Isaka loJakhobe ngesifungo, ");
INSERT INTO nde_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","kakho loyedwa ngaphandle kukaKhalebi indodana kaJefune umKhenizi kanye loJoshuwa indodana kaNuni, ngoba laba balandela uThixo ngezinhliziyo ezipheleleyo.’ ");
INSERT INTO nde_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Ulaka lukaThixo lwavutha wabazondela abako-Israyeli njalo wabenza bantula enkangala okweminyaka engamatshumi amane, kwaze kwaphela bonke abentanga yalabo ababonile phambi kukaThixo. ");
INSERT INTO nde_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Khathesi nanku-ke lina, nzalo yezoni, selimi endaweni yaboyihlo libangela ukuthi uThixo athukuthelele abako-Israyeli ngamandla. ");
INSERT INTO nde_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Nxa lingala ukumlandela, uThixo uzaphinde atshiye bonke lababantu bakhe enkangala, njalo kuzabe kuyini elibangele incithakalo yabo.” ");
INSERT INTO nde_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Ngakho beza kuye bathi, “Sifuna ukwakha izibaya zezifuyo zethu njalo sakhele omkethu labantwabethu amadolobho. ");
INSERT INTO nde_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Kodwa thina sesilungele ukuzihlomisa ukuze sikhokhele abako-Israyeli size siyebafikisa endaweni yabo. Kunjalo-nje omkethu labantwabethu bazasala emadolobheni avikelekileyo, ukuze bangahlaselwa ngabanikazi balelolizwe. ");
INSERT INTO nde_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Kasiyikubuyela kweyethu imizi wonke owako-Israyeli aze azuze isabelo sakhe. ");
INSERT INTO nde_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Thina kasiyikuzuza isabelo kanye labo ngale kweJodani, ngoba esethu isabelo sisithole ngapha ngempumalanga kweJodani.” ");
INSERT INTO nde_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Ngakho uMosi wathi kubo, “Nxa lizakwenza lokhu, lizihlomisele ukuhlasela phambi kukaThixo, ");
INSERT INTO nde_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","njalo nxa lonke lizahamba lihlomile ngale kweJodani phambi kukaThixo aze adudule izitha phambi kwakhe, ");
INSERT INTO nde_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","kuthi nxa ilizwe selinqotshiwe phambi kukaThixo selingaphenduka njalo liyabe selikhululekile emlandwini wenu kuThixo laku-Israyeli. Ngalokho-ke lelilizwe lizakuba yisabelo senu phambi kukaThixo. ");
INSERT INTO nde_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Kodwa lingehluleka ukwenza lokhu, lizabe lonile phambi kukaThixo; njalo yazini ukuthi isono senu sizalifumana. ");
INSERT INTO nde_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Yakhelani abesifazane benu labantwabenu amadolobho, njalo lakhele izifuyo zenu izibaya, kodwa yenzani lokho elikuthembisileyo.” ");
INSERT INTO nde_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","AbakoGadi labakoRubheni bathi kuMosi, “Thina izinceku zakho sizakwenza njengokulaya kwenkosi yethu. ");
INSERT INTO nde_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Abantwabethu labomkethu, imihlambi yezimvu zethu leyenkomo zethu kuzasala lapha emadolobheni aseGiliyadi. ");
INSERT INTO nde_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Kodwa thina zinceku zakho, yonke indoda ehlomele ukuhlasela, izachapha iyekulwa phambi kukaThixo, njengokutsho kwenkosi yethu.” ");
INSERT INTO nde_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","UMosi wasekhupha ilizwi lesiqondiso ngabo ku-Eliyazari umphristi lakuJoshuwa indodana kaNuni kanye lakulabo abazinhloko zezimuli zezizwana zako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Wathi kubo, “Nxa abakoGadi labakoRubheni, wonke amadoda ayabe ehlomele ukuhlasela, angachaphela ngale kweJodani kunye lani phambi kukaThixo, kube sekusithi nxa ilizwe selinqotshiwe phambi kwenu banikeni ilizwe laseGiliyadi libe yisabelo sabo. ");
INSERT INTO nde_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Kodwa nxa bengachaphanga lani behlomile, kumele bemukele isabelo sabo kunye lani eKhenani.” ");
INSERT INTO nde_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","AbakoGadi labakoRubheni baphendula bathi, “Izinceku zakho zizakwenza okutshiwo nguThixo. ");
INSERT INTO nde_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Sizachaphela ngale phambi kukaThixo singene eKhenani sihlomile, kodwa ilifa eliyisabelo sethu lizakuba nganeno kweJodani.” ");
INSERT INTO nde_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Ngakho uMosi wasenika abakoGadi, labakoRubheni kanye lengxenye yesizwana sakoManase indodana kaJosefa umbuso kaSihoni inkosi yama-Amori kanye lombuso ka-Ogi inkosi yaseBhashani, ilizwe lonke kanye lamadolobho alo kanye lamazwe ayebagqagqele. ");
INSERT INTO nde_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","AbakoGadi bakha iDibhoni, i-Atharothi, i-Aroweri, ");
INSERT INTO nde_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","i-Athirothi-Shofani, iJazeri, iJogibheha, ");
INSERT INTO nde_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","iBhethi-Nimra kanye leBhethi-Harani aba ngamadolobho ahonqolozelwe ngemithangala, njalo bakha lezibaya zemihlambi yezifuyo zabo. ");
INSERT INTO nde_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Kanti-ke abakoRubheni bakha kakutsha iHeshibhoni, i-Eliyale kanye leKhiriyathayimi, ");
INSERT INTO nde_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","kanye lokwakha iNebho kanye leBhali-Meyoni (la amabizo aguqulwa) leSibhima. Betha amadolobho abawakha kutsha amabizo. ");
INSERT INTO nde_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Izizukulwane zikaMakhiri indodana kaManase zaya eGiliyadi, zalithumba njalo zaxotsha ama-Amori ayekulelolizwe. ");
INSERT INTO nde_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Ngakho uMosi wapha elaseGiliyadi kumaMakhiri, izizukulwane zikaManase, basebehlala khona. ");
INSERT INTO nde_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","UJayiri, umzukulu kaManase, wathumba imizi yabo wayibiza ngokuthi yiHarothi Jayiri. ");
INSERT INTO nde_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Kanti uNobha wathumba iKhenathi kanye lemizi eyigqagqeleyo njalo wayetha ibizo lakhe wathi yiNobha. ");
INSERT INTO nde_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Nanka amalombolombo ohambo lwabako-Israyeli ekuphumeni kwabo eGibhithe ngamaviyo abo bekhokhelwa nguMosi lo-Aroni. ");
INSERT INTO nde_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Ngokulaya kukaThixo waloba walonda izigaba zamalombolombo ohambo lwabo. Nantu uhambo lwabo ngezigaba zakhona: ");
INSERT INTO nde_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Abako-Israyeli basuka eRamesesi ngosuku lwetshumi lanhlanu lwenyanga yakuqala, ngosuku kwedlule iPhasika. Baphuma ngesibindi bekhangelwe ngamaGibhithe wonke, ");
INSERT INTO nde_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","wona eyephathekile engcwaba wonke amazibulo awo, lawo ayebulewe nguThixo phakathi kwawo; ngoba uThixo wayehlulele ngokujezisa onkulunkulu bawo. ");
INSERT INTO nde_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Abako-Israyeli basuka eRamesesi bayamisa izihonqo zabo eSukhothi. ");
INSERT INTO nde_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Basuka eSukhothi bayamisa izihonqo zabo e-Ethamu, emaphethelweni enkangala. ");
INSERT INTO nde_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Basuka e-Ethamu, baphenduka baya ePhi-Hahirothi; beqonda empumalanga yaseBhali-Zefoni, babuye njalo bamisa izihonqo zabo eMigidoli. ");
INSERT INTO nde_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Basuka ePhi-Hahirothi badabula olwandle bangena enkangala, bathi sebehambe okwensuku ezintathu enkangala ye-Ethamu, bamisa izihonqo zabo eMara. ");
INSERT INTO nde_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Basuka eMara baya e-Elimi, lapho okwakulezintombo zamanzi ezilitshumi lambili kanye lezihlahla zohlobo lwelala ezingamatshumi ayisikhombisa, bafika bamisa izihonqo khonapho. ");
INSERT INTO nde_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Basuka e-Elimi bayamisa izihonqo zabo besekele uLwandle oluBomvu. ");
INSERT INTO nde_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Basuka oLwandle oluBomvu bayamisa enkangala yaseSini. ");
INSERT INTO nde_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Basuka enkangala yeSini bayamisa eDofuka. ");
INSERT INTO nde_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Basuka eDofuka bayamisa e-Alusha. ");
INSERT INTO nde_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Basuka e-Alusha bayamisa eRefidimu, lapho okwakungelamanzi okunathwa ngabantu. ");
INSERT INTO nde_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Basuka eRefidimu bayamisa enkangala yeSinayi. ");
INSERT INTO nde_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Basuka enkangala yeSinayi bayamisa eKhibhrothi Hathava. ");
INSERT INTO nde_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Basuka eKhibhrothi Hathava bayamisa eHazerothi. ");
INSERT INTO nde_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Basuka eHazerothi bayamisa eRithima. ");
INSERT INTO nde_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Basuka eRithima bayamisa eRimoni-Pherezi. ");
INSERT INTO nde_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Basuka eRimoni-Pherezi bayamisa eLibhina. ");
INSERT INTO nde_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Basuka eLibhina bayamisa eRisa. ");
INSERT INTO nde_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Basuka eRisa bayamisa eKhehelatha. ");
INSERT INTO nde_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Basuka eKhehelatha bayamisa eNtabeni yaseShefa. ");
INSERT INTO nde_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Basuka eNtabeni yaseShefa bayamisa eHarada. ");
INSERT INTO nde_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Basuka eHarada bayamisa eMakhelothi. ");
INSERT INTO nde_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Basuka eMakhelothi bayamisa eThahathi. ");
INSERT INTO nde_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Basuka eThahathi bayamisa eThera. ");
INSERT INTO nde_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Basuka eThera bayamisa eMithika. ");
INSERT INTO nde_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Basuka eMithika bayamisa eHashimona. ");
INSERT INTO nde_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Basuka eHashimona bayamisa eMosera. ");
INSERT INTO nde_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Basuka eMosera bayamisa eBhene Jayakhani. ");
INSERT INTO nde_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Basuka eBhene Jayakhani bayamisa eHori-Hagidigadi. ");
INSERT INTO nde_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Basuka eHori-Hagidigadi bayamisa eJothibhatha. ");
INSERT INTO nde_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Basuka eJothibhatha bayamisa e-Abhurona. ");
INSERT INTO nde_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Basuka e-Abhurona bayamisa e-Eziyoni-Gebheri. ");
INSERT INTO nde_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Basuka e-Eziyoni-Gebheri bayamisa eKhadeshi, eNkangala yaseZini. ");
INSERT INTO nde_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Basuka eKhadeshi bayamisa eNtabeni yaseHori, emngceleni wase-Edomi. ");
INSERT INTO nde_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Ngokulaya kukaThixo, u-Aroni umphristi wakhwela eNtabeni yaseHori, lapho afela khona ngosuku lwakuqala lwenyanga yesihlanu yomnyaka wamatshumi amane emva kokuphuma kwabako-Israyeli eGibhithe. ");
INSERT INTO nde_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","U-Aroni wayeseleminyaka elikhulu elileminyaka engamatshumi amabili lemithathu yokuphila ekufeni kwakhe eNtabeni yaseHori. ");
INSERT INTO nde_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Inkosi yase-Aradi engumKhenani eyayihlala eNegebi yaseKhenani, yezwa ukuthi abako-Israyeli babesiza. ");
INSERT INTO nde_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Basuka eNtabeni yaseHori bayamisa eZalimona. ");
INSERT INTO nde_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Basuka eZalimona bayamisa ePhunoni. ");
INSERT INTO nde_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Basuka ePhunoni bayamisa e-Obhothi. ");
INSERT INTO nde_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Basuka e-Obhothi bayamisa e-Iye-Abharimi, emngceleni waseMowabi. ");
INSERT INTO nde_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Basuka e-Iye-Abharimu bayamisa eDibhoni Gadi. ");
INSERT INTO nde_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Basuka eDibhoni Gadi bayamisa e-Alimoni-Dibhilathayimi. ");
INSERT INTO nde_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Basuka e-Alimoni-Dibhilathayimi bayamisa ezintabeni zase-Abharimi, phansi kweNebho. ");
INSERT INTO nde_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Basuka ezintabeni zase-Abharimi bayamisa emagcekeni aseMowabi besekele uJodani ngaphetsheya malungana leJerikho. ");
INSERT INTO nde_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Khonapho emagcekeni aseMowabi bamisa izihonqo zabo belandela umfula uJodani kusukela eBhethi-Jeshimothi kusiya e-Abheli-Shithima. ");
INSERT INTO nde_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Emagcekeni aseMowabi ngasemfuleni uJodani ngaphetsheya uvelela ngaseJerikho uThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Khuluma kwabako-Israyeli ubatshele lokhu uthi: ‘Nxa lichapha uJodani lingena eKhenani, ");
INSERT INTO nde_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","xotshani phambi kwenu bonke abahlala kulelolizwe. Dilizani zonke izithombe zabo ezibaziweyo kanye lezibunjiweyo, njalo libhidlize zonke izindawo eziphakemeyo zokukhonzela. ");
INSERT INTO nde_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Thumbani ilizwe lelo lihlale kulo, ngoba ngilinike ukuthi libe ngelenu. ");
INSERT INTO nde_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Yabelanani ilizwe ngenkatho, kusiya ngokwensendo zenu. Ixuku elikhulu kaliphiwe isabelo esikhulu, kuthi ixuku elincinyane liphiwe isabelo esincinyane. Okuzakuya kubo ngenkatho akube ngokwabo. Kwabelananeni kusiya ngezizwana zabokhokho benu. ");
INSERT INTO nde_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Kodwa nxa lingaxotshanga abahlala kulelolizwe, abaseleyo babo bazakuba lukhophe emehlweni enu njalo babe ngameva enyameni yenu. Bazakuba luhlupho ezweni elizahlala kulo. ");
INSERT INTO nde_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Ngakho-ke ngizakwenza kini lokho engizimisele ukukwenza kubo.’ ” ");
INSERT INTO nde_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Laya abako-Israyeli uthi kubo: ‘Nxa lingena eKhenani, ilizwe elizaliphiwa ukuba libe yisabelo senu lizakuba lale imingcele: ");
INSERT INTO nde_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Icele leningizimu yenu lizahlanganisa isigaba esithile seNkangala yaseZini kulandela umngcele we-Edomi. Empumalanga, umngcele wenu weningizimu uzasukela ekucineni koLwandle lweTswayi, ");
INSERT INTO nde_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","udabula eningizimu yoMkhandlu weNkume, kusiya ngaseZini njalo kuye eningizimu yeKhadeshi Bhaneya. Usuka lapho uzaqonda eHazari Adari njalo wedlulele e-Azimoni, ");
INSERT INTO nde_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","lapho ozajika khona, kuhlangane lesiHotsha saseGibhithe njalo uyephelela oLwandle lwaseMedithereniyeni. ");
INSERT INTO nde_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Umngcele wenu wentshonalanga uzakuba ligumbi loLwandle oLukhulu. Lo uzakuba ngumngcele wenu entshonalanga. ");
INSERT INTO nde_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Okomngcele wenu wenyakatho, usekela uLwandle oLukhulu usiya eNtabeni yaseHori ");
INSERT INTO nde_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","njalo usuka eNtabeni yaseHori uye eLebho Hamathi. Umngcele uzasuka lapho uqonde eZedadi, ");
INSERT INTO nde_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","ubusuqhubeka usiya eZifironi uze uyekuma eHazari-Enani. Lo yiwo umngcele wenu enyakatho. ");
INSERT INTO nde_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Okomngcele wenu wempumalanga, sukelani eHazari-Enani kusiya eShefamu. ");
INSERT INTO nde_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Umngcele uzakwehla usuka eShefamu usiya eRibhila engempumalanga kwe-Ayini njalo uqhubeke ulandela umthezuko empumalanga koLwandle lwaseKhinerethi. ");
INSERT INTO nde_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Kusuka lapho umngcele uzakwehla ulandela umfula uJodani uze uyecina oLwandle lweTswayi. Leli lizakuba yilizwe lenu, ngemingcele yalo inxa zonke.’ ” ");
INSERT INTO nde_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","UMosi walaya abako-Israyeli wathi: “Yabelanani lelilizwe ngenkatho njengelifa lenu. UThixo usekhuphe isiqondiso sokuthi aliphiwe izizwana eziyisificamunwemunye kanye lesizwana esiyingxenye, ");
INSERT INTO nde_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","ngenxa yokuthi abezimuli zesizwana sikaRubheni, abesizwana sikaGadi kanye lengxenye yesizwana sikaManase sebethole isabelo sabo. ");
INSERT INTO nde_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Izizwana lezi ezimbili kanye lalesi esiyingxenye sezithole isabelo sazo empumalanga komfula uJodani malungana leJerikho, ngokuya ngempumalanga.” ");
INSERT INTO nde_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","UThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“La ngamabizo amadoda azalabela ilizwe njengelifa lenu: u-Eliyazari umphristi kanye loJoshuwa indodana kaNuni. ");
INSERT INTO nde_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Beselikhetha umkhokheli oyedwa esizwaneni ngasinye ukuncedisa ukwaba ilizwe: ");
INSERT INTO nde_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","La yiwo amabizo abo: uKhalebi indodana kaJefune, owesizwana sakoJuda; ");
INSERT INTO nde_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","uShemuyeli indodana ka-Amihudi, owesizwana sakoSimiyoni; ");
INSERT INTO nde_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","u-Elidadi indodana kaKhisiloni, owesizwana sakoBhenjamini; ");
INSERT INTO nde_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","uBhukhi indodana kaJogili, umkhokheli ovela esizwaneni sakoDani; ");
INSERT INTO nde_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","uHaniyeli indodana ka-Efodi, ongumkhokheli ovela esizwaneni sikaManase indodana kaJosefa; ");
INSERT INTO nde_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","uKhemuweli indodana kaShifuthani, engumkhokheli ovela esizwaneni sako-Efrayimi indodana kaJosefa; ");
INSERT INTO nde_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","u-Elizafani indodana kaPhanaki, umkhokheli ovela esizwaneni sikaZebhuluni; ");
INSERT INTO nde_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","uPhalithiyeli indodana ka-Azani, umkhokheli ovela esizwaneni sika-Isakhari, ");
INSERT INTO nde_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","u-Ahihudi indodana kaShelomi, umkhokheli ovela esizwaneni sika-Asheri; ");
INSERT INTO nde_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","uPhedaheli indodana ka-Amihudi, umkhokheli ovela esizwaneni sikaNafithali.” ");
INSERT INTO nde_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","La yiwo amadoda uThixo alaya ukuthi ahlukanisele abako-Israyeli isabelo sabo selizwe laseKhenani. ");
INSERT INTO nde_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Ngasemagcekeni aseMowabi kusekele umfula uJodani nganeno malungana leJerikho, uThixo wathi kuMosi, ");
INSERT INTO nde_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Laya abako-Israyeli ukuthi bakhethe elifeni labo amadolobho bawanike abaLevi ukuze bahlale kuwo. Njalo babanike lamadlelo eduze lamadolobho lawo. ");
INSERT INTO nde_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Ngalokho bazakuba lamadolobho okuhlala kanye lamadlelo enkomo zabo, imihlambi yezimvu kanye leyezinye izifuyo zabo zonke. ");
INSERT INTO nde_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Amadlelo azingelezele amadolobho elizawanika abaLevi, azakuba zingalo eziyinkulungwane ukuqhela kwawo kusukela emidulini yamadolobho. ");
INSERT INTO nde_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Ngempumalanga, ngaphandle kwedolobho, kuzakuba zingalo eziyizinkulungwane ezimbili kube njalo laseningizimu izingalo eziyizinkulungwane ezimbili, entshonalanga izingalo eziyizinkulungwane ezimbili, kufane laseceleni lenyakatho izingalo eziyizinkulungwane ezimbili, idolobho liphakathi laphakathi. Le kuzakuba yindawo yabo yamadlelo emadolobheni.” ");
INSERT INTO nde_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“Phakathi kwamadolobho elizawanika abaLevi, ayisithupha azakuba ngawokuphephela, yikho lapho okuzakuthi umuntu angabulala omunye abalekele khona. Phezu kwalawo, bapheni amanye amadolobho angamatshumi amane lamabili. ");
INSERT INTO nde_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Wonke esehlangene abaLevi bapheni amadolobho angamatshumi amane lasificaminwembili, kuhlanganisa lamadlelo abo. ");
INSERT INTO nde_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Amadolobho eliwanika abaLevi elizweni labako-Israyeli kawabiwe ngokuya ngelifa lesizwana ngasinye: Thathani amadolobho amanengi esizwaneni esilamadolobho amanengi, kodwa lithathe amalutshwana kwesilamalutshwana.” ");
INSERT INTO nde_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Ngakho uThixo wasesithi kuMosi: ");
INSERT INTO nde_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Khuluma labako-Israyeli njalo ubatshele uthi: ‘Ekuchapheni kwenu uJodani lingena eKhenani, ");
INSERT INTO nde_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","khethani amanye amadolobho abe ngawokuphephela, lapho okuzakuthi nxa umuntu ebulele omunye ngengozi abalekele khona. ");
INSERT INTO nde_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Azakuba zindawo zokuphephela ukuzivikela kwabaphindiselayo, ukuze kuthi lowo owetheswa icala lokubulala angafi engakathonisiswa phambi kwebandla. ");
INSERT INTO nde_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Amadolobho ayisithupha la elibapha wona azakuba ngamadolobho enu okuphephela. ");
INSERT INTO nde_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Bapheni amathathu ngakulelicele lomfula uJodani kuthi amathathu abe ngamadolobho okuphephela eKhenani. ");
INSERT INTO nde_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Amadolobho la ayisithupha azakuba yindawo yokuphephela kwabako-Israyeli, labezizweni kanye labo bonke abantu abahlezi phakathi kwabo, ukuze kuthi loba ngubani obulele omunye ngengozi abalekele khona. ");
INSERT INTO nde_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Nxa indoda itshaya umuntu ngento eyinsimbi afe, ingumbulali; umbulali kumele abulawe. ");
INSERT INTO nde_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Kumbe nxa omunye ephethe ilitshe abesetshaya omunye afe, ungumbulali; umbulali kumele abulawe. ");
INSERT INTO nde_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Njalo nxa omunye ephethe ulutho oluyisigodo abesetshaya omunye afe, ungumbulali; umbulali kumele abulawe. ");
INSERT INTO nde_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Umphindiseli wegazi kumele ambulale umbulali; nxa ehlangana laye, kumele ambulale. ");
INSERT INTO nde_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Loba ngubani olomona ohlezi eqophile engafuqa omunye loba amjikijele ngolutho oluthile ngabomo kubangele ukufa kwakhe ");
INSERT INTO nde_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","loba kuthi ngolaka amtshaye ngenqindi afe, lowomuntu kumele abulawe; ungumbulali. Umphindiseli wegazi kumele abulale umbulali nxa ehlangana laye. ");
INSERT INTO nde_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Kodwa nxa kungayisikho ngolaka, umuntu aqabuke esefuqe omunye loba amjikijele ngolutho engaqondile ");
INSERT INTO nde_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","loba engamboni, amgxobe ngelitshe elingambulala, afe, ngakho njengoba engasisositha sakhe njalo engaqondanga ukumlimaza, ");
INSERT INTO nde_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","ibandla kumele lahlulele phakathi kwakhe lomphindiseli wegazi kulandelwa lezi zimiso. ");
INSERT INTO nde_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Ibandla kumele livikele owetheswa icala lokubulala kumphindiseli wegazi njalo abuyiselwe edolobheni lokuphephela azabe ebalekele kulo. Kumele ahlale khonale kuze kufe umphristi omkhulu, owagcotshwa ngamafutha angcwele. ");
INSERT INTO nde_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Kodwa lowo owetheswa icala angaba ngaphandle kwedolobho lokuphephela lelo ayabe ebalekele kulo ");
INSERT INTO nde_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","kuthi umphindiseli wegazi amfumane ngaphandle kwalelodolobho, umphindiseli wegazi angambulala lowo owetheswe icala kodwa angabi lacala lokubulala. ");
INSERT INTO nde_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Owetheswe icala kumele ahlale edolobheni lakhe lokuphephela kuze kufe umphristi omkhulu; uzaze abuyele emzini wakhe kuphela nxa umphristi omkhulu esefile. ");
INSERT INTO nde_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Le kumele kube yimithetho yesimiso kini lakuzizukulwane ezizayo, loba kungaphi lapho elizahlala khona. ");
INSERT INTO nde_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Loba ngubani obulala umuntu kumele abulawe njengombulali ngobufakazi balabo abayabe bebonile kuphela. Kodwa akungabikho loyedwa ozabulawa ngobufakazi bofakazi oyedwa. ");
INSERT INTO nde_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Lingemukeli inhlawulo yokuhlenga impilo yombulali, yena kumele afe, loba kutheni kabulawe. ");
INSERT INTO nde_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Lingemukeli inhlawulo yokuhlenga loba ngubani obalekele edolobheni lokuphephela libe selimvumela ukuba abuyele ukuyahlala emzini wakhe umphristi omkhulu engakafi. ");
INSERT INTO nde_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Lingalingcolisi ilizwe lelo elihlala kulo. Ukuchitha igazi kungcolisa ilizwe, njalo indlela yokubuyisana ingeke yenzelwe lapho okuchithwe khona igazi, ngaphandle kwegazi lalowo olichithileyo. ");
INSERT INTO nde_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Lingalingcolisi ilizwe elihlezi kilo kanye lalapho engihlala khona, ngoba Mina, Thixo, ngihlala phakathi kwabako-Israyeli.’ ” ");
INSERT INTO nde_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Inhloko zezindlu zosendo lukaGiliyadi indodana kaMakhiri, indodana kaManase, ababengabensendo zezizukulwane zikaJosefa, beza bakhuluma loMosi kanye labakhokheli, abazinhloko zezimuli zako-Israyeli. ");
INSERT INTO nde_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Bathi kubo, “Lapho uThixo walaya inkosi yami ukuba iphe ilizwe njengelifa ngenkatho kwabako-Israyeli, yakhupha isiqondiso sokuthi uphe ilifa lomfowethu uZelofehadi kumadodakazi akhe. ");
INSERT INTO nde_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Khathesi akesithi thina nxa bendele emadodeni ezinye izizwana zako-Israyeli; kuzakutsho ukuthi ilifa lizasuswa kwelabokhokho bethu liyekwengezelela elalesosizwana abazakwendela kuso. Ngakho kutsho ukuthi ingxenye yelifa esaliphiwayo sizayithathelwa. ");
INSERT INTO nde_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Kuzakuthi ngomnyaka weJubhili kwabako-Israyeli, ilifa labo lizakwengezelela elalesosizwana abendele kuso, njalo impahla yabo izasuswa elifeni lesizwana sabokhokho bethu.” ");
INSERT INTO nde_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Ngakho ngokulaya kukaThixo uMosi wakhipha lesisiqondiso kwabako-Israyeli: “Lokho okutshiwo yisizukulwane sesizwana sikaJosefa kuqondile. ");
INSERT INTO nde_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Lokhu yikho ukulaya kukaThixo ngamadodakazi kaZelofehadi: Bakhululekile ukwendela loba kukubani obathathayo kodwa akube ngabosendo lwesizwana sikayise. ");
INSERT INTO nde_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Kalikho ilifa ko-Israyeli elizasuka esizwaneni lisiya kwesinye isizwana, ngoba wonke owako-Israyeli kumele agcine ilizwe lesizwana eliyilifa labokhokho bakhe. ");
INSERT INTO nde_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Yonke indodakazi ezakuba yindlalifa yelizwe esizwaneni sako-Israyeli kumele yendele emuntwini wesizwana sosendo lukayise, ukuze wonke owako-Israyeli abe lelifa laboyise. ");
INSERT INTO nde_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Kalikho ilifa elizasuka esizwaneni lisiya kwesinye isizwana, ngoba loba yisiphi isizwana sako-Israyeli kumele sigcine ilizwe eliyilifa laso.” ");
INSERT INTO nde_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Ngakho amadodakazi kaZelofehadi enza njengokulaywa kukaMosi nguThixo. ");
INSERT INTO nde_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Amadodakazi kaZelofehadi uMahila, loThiza, loHogila, loMilikha kanye loNowa, bendela emadodaneni abafowabo bakayise. ");
INSERT INTO nde_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Bendela kwabezinsendo zezizukulwane zikaManase indodana kaJosefa, njalo ilifa labo lasala kwabosendo lukayise lesizwaneni sakhe. ");
INSERT INTO nde_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Le yiyo imilayo lemithetho eyaphiwa abako-Israyeli nguThixo ngoMosi emagcekeni aseMowabi ngasemfuleni waseJodani ngakuleli iphetsheya malungana leJerikho.");
INSERT INTO nde_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","La ngamazwi akhulunywa nguMosi kubo bonke abako-Israyeli enkangala, empumalanga yeJodani, lokhu kuyikuthi, e-Arabha, maqondana leSufi, phakathi kwePharani leThofeli, eLabhani, eHazerothi kanye laseDizahabi. ");
INSERT INTO nde_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(Loluhambo luthatha insuku ezilitshumi lanye ukusuka eHorebhi kusiya eKhadeshi Bhaneya ngomgwaqo odlula eNtabeni yaseSeyiri.) ");
INSERT INTO nde_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Ngomnyaka wamatshumi amane, ngosuku lwakuqala lwenyanga yetshumi lanye, uMosi wamemezela kwabako-Israyeli konke lokho uThixo ayemlaye ngakho ngabo. ");
INSERT INTO nde_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Lokhu kwakungemva kokuba esenqobe uSihoni inkosi yama-Amori, owayebusa eHeshibhoni, njalo wayesenqobe e-Edreyi u-Ogi inkosi yaseBhashani, owayebusa e-Ashitharothi. ");
INSERT INTO nde_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Empumalanga kweJodani elizweni laseMowabi, uMosi waqalisa ukufundisa ngalo umthetho, esithi: ");
INSERT INTO nde_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“UThixo uNkulunkulu wethu wakhuluma lathi siseHorebhi wathi, ‘Selihlale isikhathi eseneleyo kule intaba. ");
INSERT INTO nde_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Dilizani izihonqo zenu ledlulele elizweni lamaqaqa lama-Amori; yanini kubo bonke abangomakhelwane e-Arabha, ezintabeni, emawatheni angentshonalanga, eNegebi lilandelele ukhumbi, liye ezweni lamaKhenani kanye laseLebhanoni, lidabule lize liyefika emfuleni omkhulu, iYufrathe. ");
INSERT INTO nde_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Khangelani, sengiliphile lelilizwe. Ngenani lilithumbe lelilizwe uThixo afunga wathi uzalipha okhokho benu, u-Abhrahama, u-Isaka, uJakhobe kanye lezizukulwane zabo emva kwabo.’ ” ");
INSERT INTO nde_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","“Ngalesosikhathi ngathi kini, ‘Lina lingumthwalo omkhulu kakhulu onzima ukuthi ngiwuthwale ngingedwa. ");
INSERT INTO nde_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","UThixo uNkulunkulu wenu usengezelele amanani enu okokuthi lamuhla selilingana lezinkanyezi zemkhathini. ");
INSERT INTO nde_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Sengathi uThixo, uNkulunkulu wabokhokho benu, angalibusisa njalo alandise ngokuphindwe kankulungwane njengokuthembisa kwakhe! ");
INSERT INTO nde_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Kodwa ngingazithwala njani inhlupho zenu lemithwalo yenu kanye lezingxabano zenu ngingedwa na? ");
INSERT INTO nde_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Khethani amadoda akhaliphileyo, azwisisayo lahloniphekayo phakathi kwezizwana zakini zonke, mina ngizawabeka alikhokhele.’ ");
INSERT INTO nde_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Langiphendula lathi, ‘Lokho ofisa ukukwenza kulungile.’ ");
INSERT INTO nde_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Ngakho ngathatha abakhokheli bezizwana zenu, amadoda akhaliphileyo njalo ahloniphekayo, ngabanika amandla phezu kwenu ukuze babe ngabalawuli bezinkulungwane, bamakhulu, bamatshumi amahlanu, betshumi kanye lokuba yizikhulu zezizwana zenu. ");
INSERT INTO nde_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Njalo ngapha isiqondiso kubahluleli ngalesosikhathi ngathi: ‘Hluzani ingxabano phakathi kwabafowenu njalo lahlulele ngokufaneleyo, kungakhathalekile ukuthi yingxabano phakathi kwabako-Israyeli bodwa loba kungowako-Israyeli oxabana lowezizweni. ");
INSERT INTO nde_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Lingathathi hlangothi ekwahluleleni; hluzani amacala abancinyane labakhulu ngokufananayo. Lingesabi loba ngubani, ngoba ukwahlulela ngokukaNkulunkulu. Kuthi icala elinzima lililethe kimi, ngizalihluza ngilahlulele.’ ");
INSERT INTO nde_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Njalo ngalesosikhathi ngalitshela konke okwakumele likwenze.” ");
INSERT INTO nde_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","“Kwathi-ke, njengoba uThixo wethu wayesilayile, sasuka eHorebhi saqonda ezweni lama-Amori elilamaqaqa sadabula inkangala enkulu eyesabekayo eseliyibonile, saze sayafika eKhadeshi Bhaneya. ");
INSERT INTO nde_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Ngakho ngathi kini, ‘Selifikile elizweni lama-Amori elamaqaqa, ilizwe uThixo uNkulunkulu wethu asinika lona. ");
INSERT INTO nde_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Khangelani, uThixo uNkulunkulu wenu uselinike lelilizwe. Hambani lilithumbe njengoba uThixo, uNkulunkulu wabokhokho benu alitshela. Lingesabi; lingadangali.’ ");
INSERT INTO nde_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Kusenjalo lina lonke leza kimi lathi, ‘Asithumeni amadoda ahambe phambili ayehlola lelolizwe abuye azositshengisa indlela esizangena ngayo kanye leyokuthumba amadolobho esizafikela kuwo.’ ");
INSERT INTO nde_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Lokho kwakhanya kungumbono omuhle kimi; lakanye ngakhetha abalitshumi lababili phakathi kwenu, indoda eyodwa esizwaneni ngasinye. ");
INSERT INTO nde_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Basuka baya ezweni lamaqaqa njalo bafika bahlola isihotsha sase-Eshikholi. ");
INSERT INTO nde_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Bathatha ezinye izithelo zelizwe babuya lazo kithi, njalo bethula umbiko othi, ‘Yilizwe elihle uThixo uNkulunkulu wethu asipha lona.’ ” ");
INSERT INTO nde_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","“Kodwa lina lalingazimiselanga ukuhamba; lahlamukela uThixo uNkulunkulu wenu ngokungalaleli umlayo wakhe. ");
INSERT INTO nde_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Lina lakhonona lisemathenteni enu lathi, ‘UThixo uyasizonda; kutsho ukuthi wasikhipha eGibhithe ukuze asinikele ezandleni zama-Amori ukuthi asibhubhise. ");
INSERT INTO nde_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Singaya ngaphi na? Abafowethu sebesithelele ubuthakathaka. Bathi bona, “Abantu bakhona balamandla njalo bade kulathi; amadolobho akhona makhulu, alemiduli etshaya emkhathini. Size sabona lama-Anakhi khonale.” ’ ");
INSERT INTO nde_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Mina ngasengisithi kini, ‘Lingethuki; lingabesabi. ");
INSERT INTO nde_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","UThixo uNkulunkulu wenu ohamba phambi kwenu uzalilwela, njengalokho alenzela khona eGibhithe lizibonela ngamehlo enu, ");
INSERT INTO nde_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","njalo lasenkangala. Khonale lazibonela ukuthi uThixo uNkulunkulu wenu walithwala, njengobaba ethwala indodana yakhe, uhambo lwenu lonke laze lafika lapha.’ ");
INSERT INTO nde_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Lanxa kunjalo, kalizange limethembe uThixo uNkulunkulu wenu, ");
INSERT INTO nde_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","yena owahamba phambi kwenu kuloluhambo, elikhokhela ngomlilo ebusuku kanti kusiba leyezi emini, elidingela izindawo zokumisa izihonqo zenu lokulitshengisa lapho okumele liye khona. ");
INSERT INTO nde_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Kwathi uThixo esezwile elalikutsho, wathukuthela, wafunga wathi: ");
INSERT INTO nde_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‘Kakho loyedwa kulesisizukulwane esingalunganga ozalibona lelolizwe engafungela ukulipha okhokho benu, ");
INSERT INTO nde_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","ngaphandle kukaKhalebi indodana kaJefune. Yena uzalibona, njalo ngizamupha yena lesizukulwane sakhe lelolizwe azafikela kilo, ngoba walalela uThixo ngenhliziyo yakhe yonke.’ ");
INSERT INTO nde_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Ngenxa yenu uThixo wangithukuthelela lami njalo wathi, ‘Wena lawe awuyikungena khona. ");
INSERT INTO nde_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Kodwa umsekeli wakho, uJoshuwa indodana kaNuni, uzangena kulelolizwe. Umkhuthaze yena, ngoba uzakhokhela abako-Israyeli kulo ukuba libe yilifa labo. ");
INSERT INTO nde_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Kanti njalo lalabo abancane elalisithi bazathunjwa, abantwabenu abangakehlukanisi phakathi kokubi lokuhle, bazangena kulelolizwe. Ngizabapha lona njalo bazalithatha libe ngelabo. ");
INSERT INTO nde_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Kodwa lina, phendukani njalo lisuke liqonde enkangala lilandele indlela eya oLwandle oluBomvu.’ ");
INSERT INTO nde_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Lina laphendula lathi, ‘Sonile kuThixo. Sizahamba siyekulwa, njengokulaywa kwethu nguThixo uNkulunkulu wethu.’ Ngalokho lonke lahloma ngezikhali linakana ukuthi kulula ukungena elizweni lamaqaqa. ");
INSERT INTO nde_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Kodwa uThixo wathi kimi, ‘Wothi kubo, “Lingayi ukuyakulwa, ngoba kangiyikuba lani. Lizakwehlulwa yizitha zenu.” ’ ");
INSERT INTO nde_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Ngakho ngalitshela, kodwa kalizange lilalele. Lahlamukela umlayo kaThixo kwathi ngobuqholo benu layangena elizweni lamaqaqa. ");
INSERT INTO nde_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Kwathi ama-Amori ayehlala kulawomaqaqa alihlangabeza alihlasela; alixotsha njengomtshitshi wenyosi, alibhuqa kusukela eSeyiri indlela yonke kusiya eHoma. ");
INSERT INTO nde_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Laphenduka lafika lakhala phambi kukaThixo kodwa kazange alalele ukukhala kwenu walifulathela. ");
INSERT INTO nde_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Ngakho lahlala eKhadeshi okwensuku ezinengi, okwesikhathi sonke elasichitha likhonale.” ");
INSERT INTO nde_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","“Sasesiphenduka siqonda enkangala ngendlela yoLwandle oluBomvu njengokulaywa kwami nguThixo. Okwesikhathi eside sasilokhu sibhoda ezweni lamaqaqa aseSeyiri. ");
INSERT INTO nde_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","UThixo wasesithi kimi, ");
INSERT INTO nde_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","‘Selibhod