﻿USE sofia;
DROP TABLE IF EXISTS sofia.ncuNT_vpl;
CREATE TABLE ncuNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ncuNT_vpl WRITE;
INSERT INTO ncuNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ke̱e̱ Yeesuu Kristoo mò̱ nana‑ana anyare̱, na ane̱ŋ ne̱ ɔɔ le̱e̱ Deefid a ke̱nana‑ɔ‑rɔ‑ɔ, na ane̱ŋ ne̱ Deefid mɔ a le̱e̱ Abraham a ke̱nana‑ɔ‑rɔ‑ɔ. Abraham mɔ gye̱ Isireelii awuye bamo̱ nana. ");
INSERT INTO ncuNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","To, Abraham mò̱ gyi e̱ gye̱ Isak, ne̱ Isak mɔ mò̱ gyi e̱ gye̱ Yakubu, ne̱ Yakubu mɔ mò̱ gyi‑ana e̱ gye̱ Yudaa na mò̱ daa‑ana na mò̱ tire‑ana. ");
INSERT INTO ncuNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ne̱ Yudaa na ɔkye̱e̱ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Tamaa‑ɔ a ko̱we̱ Pɛrɛs na Sɛra, ne̱ Pɛrɛs mɔ mò̱ gyi e̱ gye̱ Hisirɔŋ, ne̱ Hisirɔŋ mɔ mò̱ gyi e̱ gye̱ Aram. ");
INSERT INTO ncuNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ne̱ Aram mɔ mò̱ gyi e̱ gye̱ Aminadabi, ne̱ Aminadabi mɔ mò̱ gyi e̱ gye̱ Naasɔŋ, ne̱ Naasɔŋ mɔ mò̱ gyi e̱ gye̱ Salamɔŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ne̱ Salamɔŋ mɔ na mò̱ ka Rahab a ko̱we̱ Bowas, ne̱ Bowas mɔ na mò̱ ka Rut a ko̱we̱ Obid, ne̱ Obid mɔ mò̱ gyi e̱ gye̱ Yɛse̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ne̱ Yɛse̱e̱ mɔ mò̱ gyi e̱ gye̱ Owure Deefid. Ne̱ Owure Deefid na ɔkye̱e̱ ko̱ ne̱ ɔ dɛɛ ɔ gye̱ ɔnyare̱ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Oriya mò̱ ka‑ɔ a ko̱we̱ Solomɔŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ne̱ Solomɔŋ mɔ mò̱ gyi e̱ gye̱ Rɛkabo̱wam, ne̱ Rɛkabo̱wam mɔ mò̱ gyi e̱ gye̱ Abiya, ne̱ Abiya mɔ mò̱ gyi e̱ gye̱ Asa. ");
INSERT INTO ncuNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ne̱ Asa mɔ mò̱ gyi e̱ gye̱ Yɛhɔsafat, ne̱ Yɛhɔsafat mɔ mò̱ gyi e̱ gye̱ Yɛhɔram, ne̱ Yɛhɔram mɔ mò̱ gyi e̱ gye̱ Osiya. ");
INSERT INTO ncuNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ne̱ Osiya mɔ mò̱ gyi e̱ gye̱ Yotam, ne̱ Yotam mɔ mò̱ gyi e̱ gye̱ Ahas, ne̱ Ahas mɔ mò̱ gyi e̱ gye̱ Hisikiya. ");
INSERT INTO ncuNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ne̱ Hisikiya mɔ mò̱ gyi e̱ gye̱ Manasee, ne̱ Manasee mɔ mò̱ gyi e̱ gye̱ Amɔŋ ne̱ Amɔŋ mɔ mò̱ gyi e̱ gye̱ Yosiya. ");
INSERT INTO ncuNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ne̱ Yosiya mɔ mò̱ gyi‑ana e̱ gye̱ Yikoniya na mò̱ tire‑ana. Saŋ amo̱‑rɔ ne̱ Isireelii awuye ado̱ŋ a yaa bamo̱ anya kusuŋ‑no Babilɔŋ swe̱e̱re̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bamo̱ ado̱ŋ a yaa bamo̱ Babilɔŋ‑ɔ, amo̱ kamɛɛ ne̱ Yikoniya a ko̱we̱ Salatiyɛl, ne̱ Salatiyɛl mɔ a ko̱we̱ Sirubabɛl. ");
INSERT INTO ncuNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ne̱ Sirubabɛl mɔ a ko̱we̱ Abiyud, ne̱ Abiyud mɔ a ko̱we̱ Iliyakim, ne̱ Iliyakim mɔ a ko̱we̱ Asɔɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ne̱ Asɔɔ mɔ a ko̱we̱ Sadukii, ne̱ Sadukii mɔ a ko̱we̱ Akim, ne̱ Akim mɔ a ko̱we̱ Iliyud. ");
INSERT INTO ncuNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ne̱ Iliyud mɔ a ko̱we̱ Iliyasa, ne̱ Iliyasa mɔ a ko̱we̱ Mataŋ, ne̱ Mataŋ mɔ a ko̱we̱ Yakubu. ");
INSERT INTO ncuNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ne̱ Yakubu mɔ a ko̱we̱ Yo̱sɛf, ne̱ Yo̱sɛf mɔ a waare̱e̱ Mariya. Mariya ya ko̱we̱ Yeesuu ne̱ ba te̱e̱ mò̱ ɛ Kristoo ne̱ Wuribware̱ yɛ o suŋ a ɔ bo̱ kyo̱ŋwe̱ kaye̱ mɔ‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ŋko̱we̱kyase̱ ne̱ ŋ ya le̱e̱ Abraham se̱ ya bo̱ fo̱ Deefid si‑o gye̱ kudu nna, ne̱ le̱e̱ Deefid si ya bo̱ fo̱ saŋ ne̱ bamo̱ ado̱ŋ a yaa bamo̱ anya kusuŋ‑no Babilɔŋ swe̱e̱re̱ se̱‑ɔ mɔ gye̱ kudu nna. Bo̱ le̱e̱ saŋ amo̱ ya bo̱ fo̱ Kristoo‑o kako̱we̱ se̱ mɔ gye̱ ŋko̱we̱kyase̱ ane̱ŋ kudu nna. ");
INSERT INTO ncuNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Mfaanɛɛ ne̱ baa ko̱we̱ Yeesuu Kristoo. Kabregyii ko̱ ya kye̱na ne̱ ba te̱e̱ mò̱ ɛ Mariya. Ne̱ baa ke̱re̱ mò̱ sa Yo̱sɛf. Yo̱sɛf na Mariya mo̱ŋ tɛɛ di, amaa Mariya a ŋu fe̱yɛ Wuribware̱ a kufwiiŋe timaa‑o a sa ne̱ ɔɔ nya kame. ");
INSERT INTO ncuNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ɔ Yo̱sɛf fe̱raa, ɔɔ fa fe̱yɛ mò̱ ke̱re̱kye̱e̱ Mariya mo̱ŋ de kase̱ŋtiŋ. Ne̱ ɔɔ kpa a o kine mò̱. Amaa mò̱ a gye̱ se̱sɛ timaa‑o si‑o, ɔ mo̱ŋ kpa fe̱yɛ ɔ nye̱ra Mariya ke̱nyare̱, ne̱ ɔɔ waa mò̱ mfɛɛre̱ fe̱yɛ o kine mò̱ na ɔko̱ mo̱ŋ nu. ");
INSERT INTO ncuNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ane̱ŋ a ase̱ŋ‑ɔ a saŋ a bo̱ mò̱ mfɛɛre̱‑rɔ‑ɔ, ne̱ kanye ko̱ Wuribware̱ kabɔɔ ko̱ a le̱e̱ mò̱ se̱ dee‑ro, ne̱ ɔ yɛ, “Yo̱sɛf, Deefid mò̱ ke̱nanagyi, fo̱ ma sa a Mariya ke̱taa baa fo̱ aye̱ waa fo̱ kufu, a le̱e̱ fe̱yɛ Wuribware̱ a kufwiiŋe timaa‑o ya sa mò̱ kame‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ɔ ko̱we̱ ɔnyare̱, na fo̱ sa mò̱ ke̱nyare̱ fe̱yɛ Yeesuu, kaase̱ e̱ kaapo̱ fe̱yɛ Wuribware̱-e̱‑mo̱rɔwe̱, a le̱e̱ fe̱yɛ mò̱ e̱ gye̱ ne̱ o lee mò̱ ase̱sɛ na ɔ bo̱ le̱e̱ bamo̱ e̱bɔye̱‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Amo̱‑ɔ pɛɛɛ a waa ne̱e̱ na ke̱tɔ ne̱ Wuribware̱ a sa ne̱ mò̱ akyaamɛɛ‑ɔ ɔko̱ a kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ nya waa kase̱ŋtiŋ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Kabregyii ne̱ ɔ mo̱ŋ nyi anyare̱‑ɔ e̱ nya kame, na ɔ ko̱we̱ ɔnyare̱, na bo̱ te̱e̱ mò̱ ɛ Imanuwɛl, kaase̱ e̱ kaapo̱ fe̱yɛ Wuribware̱-bo̱-ane̱‑ase̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Amo̱se̱ se̱‑ɔ Yo̱sɛf a ko̱so̱‑ɔ, ne̱ ɔɔ gya Wuribware̱ kabɔɔ a kanɔ‑ɔ se̱, ne̱ ɔɔ waare̱e̱ Mariya taa mò̱ yaa mò̱ aye̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Amaa mò̱ aa mò̱ mo̱ŋ di ne̱ ɔɔ bo̱ ko̱we̱. Ne̱ ɔɔ ko̱we̱ ɔnyare̱, ne̱ Yo̱sɛf a sa kayaagyi‑o ke̱nyare̱ ɛ Yeesuu. ");
INSERT INTO ncuNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maŋ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Bɛte̱lahɛm ne̱ ɔ bo̱ Yude̱ya† swe̱e̱re̱ se̱‑ɔ‑rɔ ne̱ Mariya a ko̱we̱ Yeesuu. Saŋ amo̱‑ɔ Hɛrɔd e̱ gye̱ owure.† A mo̱ŋ kyee ne̱ afɔ ko̱ a le̱e̱ kyɔwe̱ le̱e̱kpa a ke̱be̱gya‑ɔ ba Yɛro̱salɛm. Afɔ mɔ gye̱ anyiase̱ŋpo̱ ko̱ ne̱ ba de̱e̱re̱ akye̱e̱‑e̱‑kpa‑agyi ba pini amo̱ ase̱ŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ne̱ baa bise Owure Hɛrɔd fe̱yɛ, “Ŋke̱e̱ kayaagyi ne̱ baa ko̱we̱ mò̱ na ɔ bo̱ gyi Yudaa awuye kuwure‑o. Bo̱ le̱e̱ fe̱yɛ ane̱ a ŋu ke̱kye̱e̱‑e̱‑kpa‑agyi ko̱ a le̱e̱ kyɔwe̱ le̱e̱kpa, ne̱ ke̱ e̱ kaapo̱ ane̱ fe̱yɛ baa ko̱we̱ owure. Ne̱ ane̱ a ba a ane̱ bo̱ suŋ mò̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Owure Hɛrɔd a nu amo̱‑ɔ, ne̱ mò̱ aa Yɛro̱salɛm awuye pɛɛɛ iduŋ a te̱ŋ bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ne̱ ɔɔ te̱e̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ na Wuribware̱ mbraa akaapo̱po̱ pɛɛɛ bo̱ gyaŋŋe̱. Bamo̱ a gyaŋŋe̱‑ɔ, ne̱ oo bise bamo̱ fe̱yɛ mfe̱ne̱ ne̱ ba ba a bo̱ bo̱ ko̱we̱ ɔko̱ ne̱ ba te̱e̱ mò̱ ɛ Kristoo ne̱ Wuribware̱ yɛ o suŋ a ɔ bo̱ kyo̱ŋwe̱ Yudaa awuye‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","6","Ne̱ baa lee kanɔ fe̱yɛ, “Bɛte̱lahɛm ne̱ ɔ bo̱ Yudaa swe̱e̱re̱ mɔ se̱‑ɔ‑rɔ ne̱ ba ko̱we̱ mò̱. A le̱e̱ fe̱yɛ Wuribware̱ kyaamɛɛ ko̱ a kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ, ‘Wuribware̱ yɛ, Bɛte̱lahɛm maŋ, hare̱e̱ fo̱ a gye̱ Yudaa swe̱e̱re̱ se̱ a e̱maŋ‑ɔ‑rɔ kagyingyii‑o gbaa ooo, Wuribware̱ i lee mo̱ne̱ ase̱sɛ‑ɔ‑rɔ ɔko̱ na o kii mò̱ ase̱sɛ Isireelii awuye pɛɛɛ ɔyaale̱ŋpo̱ na ɔde̱e̱re̱se̱po̱‑ɔ.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Owure‑o a nu amo̱‑ɔ, ne̱ ɔɔ te̱e̱ anyiase̱ŋpo̱‑ɔ lee keri si, ne̱ oo bise bamo̱ saŋ ko̱ŋko̱ ne̱ ke̱kye̱e̱‑e̱‑kpa‑agyi amo̱ a le̱e̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ne̱ baa tɔwe̱ saŋ‑ɔ gywii mò̱. Mò̱ a nu bo̱ le̱e̱ bamo̱ ase̱‑ɔ, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱nꞌ ya buwi kpa kayaagyi‑o Bɛte̱lahɛm maŋ‑nɔ. Mo̱ne̱ ya de̱ŋ ŋu mò̱, na mo̱nꞌ sa a n nu, na mo̱‑ɔ mɔ ŋ nya ya suŋ mò̱.” Ne̱ ɔɔ sa bamo̱ kpa a bo̱ yɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Bamo̱ a me̱raa se̱ ba yɔ‑ɔ, puri‑ro ne̱ baa be̱e̱ ŋu ke̱kye̱e̱‑e̱‑kpa‑agyi ne̱ baa dɛɛ ŋu kyɔwe̱ le̱e̱kpa a ke̱be̱gya‑ɔ, ne̱ bamo̱ akatɔ a gyi bwe̱e̱tɔ. Ne̱ ke̱kye̱e̱‑e̱‑kpa‑agyi‑o a gye̱ bamo̱ ŋkpɛɛ ane̱ŋ‑aaa ya fo̱ lɔŋ ne̱ kayaagyi‑o bo̱ mò̱‑rɔ‑ɔ, ne̱ kaa sii ye̱re̱ awo̱re̱‑rɔ lɔŋ amo̱ so̱so̱ kyɛɛkyɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bamo̱ a lwee lɔŋ‑ɔ‑rɔ‑ɔ, ne̱ baa ŋu kayaagyi‑o na mò̱ nyi Mariya. Ne̱ baa kpuni aŋurii suŋ kayaagyi‑o, ne̱ baa buŋŋi bamo̱ adakaa se̱, ne̱ baa lee atɔ dame̱naŋsɛ ne̱ amo̱ yawo̱ bo̱ le̱ŋ‑ɔ bo̱ ke mò̱. Amo̱ e̱ gye̱ atanne̱ pipee, na nyoŋku, na kakyanne̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ne̱ Wuribware̱ a tɔwe̱ gywii bamo̱ dee‑ro fe̱yɛ bo̱ ma lɛɛ kiŋŋi yɔ Owure Hɛrɔd ase̱ ya tɔwe̱ ke̱tɔ ne̱ baa ŋu‑o gywii mò̱. Amo̱se̱ se̱‑ɔ, ne̱ baa kiŋŋi bo̱rɔ kpa baŋbaŋ se̱ yɔ bamo̱ aye̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Anyiase̱ŋpo̱‑ɔ a yii‑o, kamɛɛ‑rɔ ne̱ Wuribware̱ kabɔɔ ko̱ a le̱e̱ Yo̱sɛf se̱ dee‑ro, ne̱ ɔ yɛ, “Ko̱so̱, taa kayaagyi‑o na mò̱ nyi na fo̱ se̱re̱ yɔ Igyipiti swe̱e̱re̱ se̱. Mo̱nꞌ kye̱na mfe̱ŋ ane̱ŋ‑aaa bo̱ fo̱ saŋ ne̱ m be̱e̱ mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ mo̱nꞌ le̱e̱ mfe̱ŋ‑ɔ, a le̱e̱ fe̱yɛ Owure Hɛrɔd e̱ ba a ɔ bo̱ buwi kpa kayaagyi‑o na ɔ mɔɔ mò̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Amo̱se̱‑ɔ, Yo̱sɛf a ko̱so̱ kanye amo̱, ne̱ mò̱ aa kayaagyi‑o na mò̱ nyi a yɔ Igyipiti swe̱e̱re̱ se̱ ya kye̱na. ");
INSERT INTO ncuNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ne̱ baa kye̱na mfe̱ŋ ne̱ Hɛrɔd a bo̱ wu, na ane̱ŋ ne̱ Wuribware̱ a bo̱rɔ mò̱ akyaamɛɛ‑ɔ ɔko̱ se̱ tɔwe̱‑ɔ nya waa kase̱ŋtiŋ fe̱yɛ, “Igyipiti swe̱e̱re̱ se̱ ne̱ mo̱ a te̱e̱ mo̱ gyi‑o le̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Amɔ Yo̱sɛf na kayaagyi‑o na mò̱ nyi a yɔ Igyipiti pwɛɛ ne̱ Owure Hɛrɔd a dɛɛ ŋu fe̱yɛ anyiase̱ŋpo̱‑ɔ a pe̱nna mò̱. Amo̱se̱‑ɔ ne̱ mò̱ duŋ a fwii bwe̱e̱tɔ, ne̱ ɔɔ sa kanɔ fe̱yɛ mò̱ asoogyaa awuye mɔɔ ŋnyaŋsɛɛ pɛɛɛ ne̱ bo̱ bo̱ Bɛte̱lahɛm maŋ‑nɔ na e̱maŋ ne̱ e̱ maa mfe̱ŋ‑ɔ, ne̱ bo̱ mo̱ŋ tɛɛ kyo̱ŋ nsu ŋnyɔ‑ɔ, nsu ne̱ ɔ fa fe̱yɛ kayaagyi‑o a gyi‑o, le̱e̱ saŋ ne̱ anyiase̱ŋpo̱ amo̱ a bo̱ tɔwe̱ gywii mò̱ fe̱yɛ baa ŋu ke̱kye̱e̱‑e̱‑kpa‑agyi‑o a le̱e̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ne̱ ke̱tɔ ne̱ Wuribware̱ kyaamɛɛ Yɛrɛme̱ya a kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ a waa kase̱ŋtiŋ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Baa nu bo̱re̱ ko̱ a le̱e̱ Rama maŋ‑nɔ, bo̱re̱‑ɔ de e̱lawo̱ bwe̱e̱tɔ. Rakyɛl i su ɔ sa mò̱ gyi‑ana. O kine ke̱po̱pɔre̱, a le̱e̱ fe̱yɛ bo̱ mo̱ŋ lɛɛ bo̱ bo̱‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ne̱ Owure Hɛrɔd a wu. Mò̱ a wu‑o, ne̱ Wuribware̱ kabɔɔ ko̱ a be̱e̱ le̱e̱ Yo̱sɛf se̱ dee‑ro Igyipiti swe̱e̱re̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ne̱ ɔɔ tɔwe̱ fe̱yɛ, “Ko̱so̱, taa kayaagyi‑o na mò̱ nyi, na mo̱nꞌ kiŋŋi yɔ mo̱ne̱ aye̱ Isireelii swe̱e̱re̱ se̱, a le̱e̱ fe̱yɛ mò̱ ne̱ ɔɔ kpa kayaagyi‑o ke̱mɔɔ‑ɔ a wu.” ");
INSERT INTO ncuNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ne̱ Yo̱sɛf a ko̱so̱ taa kayaagyi‑o na mò̱ nyi, ne̱ baa kiŋŋi yɔ Isireelii swe̱e̱re̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Bamo̱ a fo̱ mfe̱ŋ‑ɔ, ne̱ Yo̱sɛf a ŋu fe̱yɛ Aakilayus a gyi mò̱ se̱ Hɛrɔd a kuwure‑o mfe̱ŋ. Amo̱se̱ se̱‑ɔ kufu a nya mò̱ mfe̱ŋ ke̱kye̱na. Ne̱ Wuribware̱ a yii mò̱ se̱ dee‑ro fe̱yɛ bo̱ ma kye̱na Yude̱ya mfe̱ŋ. Amo̱se̱‑ɔ ne̱ baa kiŋŋi ya bo̱rɔ to̱ŋ ko̱ ya fo̱ Galile̱ya swe̱e̱re̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ne̱ baa ya kye̱na maŋ ko̱ ne̱ ba te̱e̱ ɛ Nasarɛt‑ɔ‑rɔ, na ane̱ŋ ne̱ Wuribware̱ kyaamɛɛ ko̱ a tɔwe̱‑ɔ nya waa kase̱ŋtiŋ fe̱yɛ, “Ba ba a bo̱ te̱e̱ mò̱ ɛ Nasarɛte̱nyi.” ");
INSERT INTO ncuNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ne̱ ɔnyare̱ ko̱ bo̱‑rɔ. Ba te̱e̱ mò̱ ɛ Yohanee, ne̱ bo̱ be̱e̱ ba te̱e̱ mò̱ ɛ Osuubɔpo̱‑ɔ. Ne̱ ɔɔ yɔ Yude̱ya kimukee‑ro, ne̱ ɔɔ le̱e̱ ɔ tɔwe̱ Wuribware̱ ase̱ŋ o gywii ɔke̱maa ne̱ ɔ bo̱rɔ mfe̱ŋ‑ɔ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Mo̱nꞌ nu mo̱ne̱ e̱ye̱e̱ na mo̱nꞌ kiŋŋi le̱e̱ mo̱ne̱ e̱bɔye̱‑rɔ, a le̱e̱ fe̱yɛ Wuribware̱ se̱ a kuwure‑o a tɔ‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohanee e̱ gye̱ ɔko̱ ne̱ Wuribware̱ kyaamɛɛ Isaya a tɔwe̱ mò̱ ase̱ŋ‑ɔ fe̱yɛ, “Ɔko̱ e̱ fɛɛ‑rɔ kimukee‑ro fe̱yɛ, ‘Mo̱nꞌ lɔŋŋɔ kpa nɛɛnɛɛ bo̱ be̱ya Wuribware̱. Mo̱nꞌ waa kpa kye̱rarasɛ sa mò̱ a ɔ bo̱rɔ se̱.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nyɔma ifwii ne̱ baa bo̱ waa Yohanee atɔ buŋsɛ, ne̱ kabo̱ wo̱re̱ ke̱re̱se̱sɛ da mò̱ laare̱‑rɔ. Mò̱ ateese e̱ gye̱ akyaŋkyaŋka na gyabwe̱e̱kyu. ");
INSERT INTO ncuNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ne̱ ase̱sɛ bwe̱e̱tɔ a ba mò̱ ase̱. Bo̱ko̱ a le̱e̱ Yɛro̱salɛm maŋ‑nɔ, bo̱ko̱ mɔ a le̱e̱ Yude̱ya swe̱e̱re̱ abe̱gya ke̱maa se̱, ne̱ bo̱ko̱ mɔ a le̱e̱ e̱maŋ pɛɛɛ ne̱ e̱ maa Yo̱o̱daŋ bo̱ŋ‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ne̱ baa tɔwe̱ bamo̱ e̱bɔye̱ gywii mò̱, ne̱ ɔɔ bɔ bamo̱ asuu Yo̱o̱daŋ bo̱ŋ‑nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ne̱ oo ŋu ase̱sɛ ne̱ ba te̱e̱ bamo̱ ɛ Farisii awuye na Sadukii awuye‑o e̱ ba a bo̱ bo̱ de̱e̱re̱ ane̱ŋ ne̱ ɔ bɔ asuu‑o. Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ne̱ awɔ mɔ, e̱me̱ne̱ se̱ ne̱ mo̱ne̱ mɔ mo̱ne̱ a ba mfe̱e̱? Ɔko̱ a kaapo̱ mo̱ne̱ fe̱yɛ a tiri fe̱yɛ mo̱ne̱ gbaa mo̱ŋ lee mo̱ne̱ e̱ye̱e̱ bo̱ le̱e̱ e̱bɔye̱ a kakɔka ne̱ Wuribware̱ e̱ kpa a ɔ ba bo̱ sa abɔye̱waapo̱‑ɔ‑rɔ aaa? ");
INSERT INTO ncuNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ma kɔɔre̱ a n gyi. Amaa mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ, mo̱ne̱ akatɔ ya pee amo̱ se̱ fe̱raa, amɔ mo̱nꞌ waa atɔ ke̱maa ne̱ a kaapo̱ fe̱yɛ mo̱ne̱ a nu mo̱ne̱ e̱ye̱e̱, ne̱ mo̱ne̱ a kiŋŋi le̱e̱ mo̱ne̱ e̱bɔye̱‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mo̱ne̱ ma fa fe̱yɛ mo̱ne̱ a gye̱ ne̱ nana Abraham mò̱ ananagyi‑o si‑o, mo̱ne̱ mo̱ŋ tii kakɔka ne̱ Wuribware̱ e̱ kpa a ɔ ba bo̱ sa abɔye̱waapo̱‑ɔ se̱. A le̱e̱ fe̱yɛ Wuribware̱ e̱ taare̱ a ɔ ba mfe̱e̱ a afo̱re̱ mɔ bo̱ buruwi ase̱sɛ na bo̱ kii Abraham mò̱ ananagyi. ");
INSERT INTO ncuNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mo̱nꞌ sa se̱, a le̱e̱ fe̱yɛ Wuribware̱ a waa kakwii‑atɔ siraa, na ɔ ba bo̱ ŋe kiyii ke̱maa ne̱ ke̱ maa swɛɛ agyi timaa‑o ileŋ kaase̱, na ɔ bo̱ da na ɔ twe̱e̱ waa de̱e̱kpa‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ne̱ ɔɔ tɔwe̱ gywii ase̱sɛ pɛɛɛ ne̱ ba nu mò̱ ase̱‑ɔ fe̱yɛ, “Nkyu ne̱ n de mo̱ e̱ bɔ mo̱ne̱ asuu, na a kaapo̱ fe̱yɛ mo̱ne̱ a nu mo̱ne̱ e̱ye̱e̱ kiŋŋi le̱e̱ mo̱ne̱ e̱bɔye̱‑rɔ. Amaa ɔko̱ saŋ ɔ ba mo̱ kamɛɛ na ɔ kyɔ mo̱, ne̱ mo̱ŋ fo̱ fe̱yɛ n so̱rɔ mò̱ ase̱be̱ta gbaa. Mò̱ fe̱raa, ɔ sa a Wuribware̱ a kufwiiŋe timaa‑o ywe̱e̱ mo̱ne̱ se̱ ne̱e̱, na mo̱nꞌ nya ke̱yaale̱ŋ fe̱yɛ de̱e̱kpa‑ɔ. Na ɔ ba Wuribware̱ a kufwiiŋe timaa‑o bo̱ gyee mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","O de mò̱ kawo̱raa ne̱ ɔ ba a ɔ bo̱ kyaare̱ ayu na o swii waa mò̱ ke̱po̱re̱kye̱e̱‑rɔ. Na ŋkee ɔ kpane̱ afeŋfeŋtee‑o pɛɛɛ na ɔ kywɛɛ amo̱ de̱e̱kpa ne̱ ɔ maa duŋ‑o‑ro. Ane̱ŋ ne̱ o gyi ase̱sɛ pɛɛɛ ase̱ŋ‑ɔ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Saŋ amo̱‑ɔ, Yeesuu a le̱e̱ Galile̱ya swe̱e̱re̱ se̱ ba Yo̱o̱daŋ bo̱ŋ‑nɔ na Yohanee bɔ mò̱ asuu. ");
INSERT INTO ncuNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Amaa Yohanee a le̱ŋ e̱ye̱e̱ fe̱yɛ o kyurowi Yeesuu mfɛɛre̱. Ɔ yɛ, “Weetee a bware fe̱yɛ fo̱ e̱ gye̱ ne̱ fo̱ bɔ mo̱ asuu, amaa fo̱ ya ko̱ŋ ba mo̱ ase̱ fe̱yɛ m bɔ fo̱ asuu.” ");
INSERT INTO ncuNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Mbe̱yɔmɔ fe̱raa, sa a a waa ane̱ŋ, a le̱e̱ fe̱yɛ a bware fe̱yɛ ane̱ waa ane̱ŋ ne̱ Wuribware̱ e̱ kpa‑ɔ.” Amo̱se̱ se̱‑ɔ ne̱ Yohanee a sure si, ne̱ ɔɔ bɔ Yeesuu asuu. ");
INSERT INTO ncuNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yohanee a de̱ŋ bɔ mò̱ asuu, ne̱ Yeesuu a le̱e̱ nkyu‑ro‑o, puri amo̱‑rɔ ne̱ awo̱re̱‑rɔ a buŋŋi‑ro, ne̱ oo ŋu Wuribware̱ a kufwiiŋe‑o a bo̱ ywe̱e̱ mò̱ se̱ fe̱yɛ kuwurele̱pɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ne̱ bo̱re̱ ko̱ a le̱e̱ so̱so̱ tɔwe̱ fe̱yɛ, “Ke̱e̱ mo̱ gyi timaa ne̱ mo̱ e̱ kpa mò̱ ase̱ŋ bwe̱e̱tɔ‑ɔ, ne̱ mo̱ akatɔ a gyi mò̱ se̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Amo̱ kamɛɛ‑rɔ ne̱ Wuribware̱ a kufwiiŋe timaa‑o a sa ne̱ Yeesuu a yɔ ɔ naa o muruwi kimukee‑ro, na Ɔbɔnsam kyɔ mò̱‑rɔ ke̱e̱ fe̱yɛ ɔ nya mò̱ a ɔ bo̱ waa e̱bɔye̱‑rɔ aaa. ");
INSERT INTO ncuNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ne̱ Yeesuu a gyi ŋke aduna mpase̱ na kanye kimukee‑ro mfe̱ŋ, na ɔ maa gyi ateese. Amo̱se̱‑ɔ saŋ ne̱ ŋke amo̱ a kyo̱ŋ‑ɔ, ako̱ŋ de mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ne̱ Ɔbɔnsam ne̱ bo̱ be̱e̱ ba te̱e̱ mò̱ ɛ Ɔkyɔrɔpo̱‑ɔ a ba mò̱ ase̱. Ne̱ ɔ yɛ, “Fo̱ i nyi fe̱yɛ Wuribware̱ mò̱ gyi‑o e̱ gye̱ fo̱ kase̱ŋtiŋ, amo̱ fe̱raa sa a abu mɔ buruwi bodobodoo sa fo̱ a fo̱ gyi.” ");
INSERT INTO ncuNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ne̱ Yeesuu a be̱ŋŋaa fe̱yɛ, “Baa kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ, ‘Ateese wo̱re̱ maa sa se̱sɛ ŋkpa, amaa Wuribware̱ ase̱ŋ tɔwe̱sɛ ke̱maa mɔ mɔ be̱e̱ a tiri sa mò̱ ŋkpa.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ne̱ Ɔbɔnsam a be̱e̱ yaa Yeesuu Yɛro̱salɛm ne̱ bo̱ be̱e̱ ba te̱e̱ mfe̱ŋ ɛ maŋ kpe̱yaa‑ɔ, ne̱ ɔɔ taa mò̱ yaa bo̱ ye̱ra Wuribware̱ suŋkpa‑ɔ katwe̱e̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ne̱ ɔɔ tɔwe̱ gywii Yeesuu fe̱yɛ, “Fo̱ i nyi fe̱yɛ Wuribware̱ mò̱ gyi e̱ gye̱ fo̱ kase̱ŋtiŋ, amo̱ fe̱raa fuwi ywe̱e̱‑rɔ a ŋ ke̱e̱. A le̱e̱ fe̱yɛ baa be̱e̱ kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ, ‘Wuribware̱ e̱ sa a mò̱ mbɔɔ‑ɔ bo̱ kuŋ fo̱, na bo̱ so̱rɔ fo̱ bamo̱ asare̱e̱ se̱, na fo̱ ma nya da ke̱yaa kibu si.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ne̱ Yeesuu a be̱e̱ be̱ŋŋaa mò̱ fe̱yɛ, “Ne̱e̱ amo̱ mɔ a be̱e̱ a bo̱ abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ, ‘Mo̱ne̱ ma kaŋ kyɔ mo̱ne̱ nyaŋpe̱ Wuribware̱‑rɔ ke̱e̱’ ɛ?” ");
INSERT INTO ncuNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ne̱ ŋkee Ɔbɔnsam a taa Yeesuu yaa ke̱be̱e̱ so̱swe̱e̱ ko̱ se̱, ne̱ ɔɔ ba kaye̱‑rɔ e̱maŋ pɛɛɛ na e̱mo̱ ke̱dabe̱ bo̱ kaapo̱ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ne̱ ɔɔ tɔwe̱ gywii mò̱ fe̱yɛ, “Fo̱ ya kpuni aŋurii suŋ mo̱, n de e̱mo̱ pɛɛɛ mo̱ e̱ sa fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ne̱ Yeesuu a tɔwe̱ fe̱yɛ, “Ɔbɔnsam, nare̱ le̱e̱‑rɔ, a le̱e̱ fe̱yɛ baa be̱e̱ kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ, ‘Mo̱nꞌ suŋ mo̱ne̱ nyaŋpe̱ Wuribware̱ wo̱re̱ kpeŋ.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ne̱ Ɔbɔnsam a le̱e̱ Yeesuu ase̱. Mò̱ a de̱ŋ o yii‑o, puri amo̱‑rɔ ne̱ Wuribware̱ mbɔɔ ko̱ a bo̱ kya Yeesuu‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","13","Saŋ ne̱ Yeesuu bo̱ mfe̱ŋ‑ɔ, Hɛrɔd† ne̱ ɔ gye̱ Galile̱ya swe̱e̱re̱ se̱ owure‑o a tii Yohanee Osuubɔpo̱‑ɔ. Yeesuu a nu amo̱‑ɔ, ne̱ oo kiŋŋi yɔ mò̱ aye̱ Nasarɛt ne̱ ɔ bo̱ Galile̱ya‑ɔ, ne̱ oo tu ya kye̱na Kapaaniyum ne̱ ɔ maa Galile̱ya ke̱pare̱ dabe̱ kɛɛ‑ɔ, ne̱ a gye̱ Saburɔŋ na Nafatalii ifuri si‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ɔɔ waa ane̱ŋ ne̱e̱ na Wuribware̱ kyaamɛɛ Isaya ke̱tɔ ne̱ ɔɔ tɔwe̱‑ɔ nya waa kase̱ŋtiŋ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Saburɔŋ ifuri si na Nafatalii ifuri si, mfe̱ŋ ne̱ kpa dabe̱ bo̱‑rɔ ne̱ ba te̱e̱ mò̱ ɛ Ɔpo̱o̱ a kpa‑ɔ, ne̱ ɔɔ le̱e̱ Yo̱o̱daŋ bo̱ŋ kyɔwe̱ le̱e̱kpa a ke̱be̱gya‑ɔ se̱, bo̱rɔ mfe̱ŋ taa yɔ kaase̱‑rɔ a ke̱bare̱‑ɔ, na Galile̱ya ifuri ne̱ bamo̱ ne̱ bo̱ mo̱ŋ gye̱ Yudaa awuye‑o te si‑o, ");
INSERT INTO ncuNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","mfe̱ŋ a ase̱sɛ mɔ ne̱ baa dɛɛ nare̱ kibugyii‑ro‑o a ŋu ke̱laŋŋe̱rɔ dabe̱. Bamo̱ ne̱ bo̱ se̱re̱ lowi‑o, ke̱laŋŋe̱rɔ a we̱e̱ bamo̱ se̱ mbe̱yɔmɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Le̱e̱ saŋ amo̱‑ɔ Yeesuu a le̱e̱ ɔ tɔwe̱ mò̱ ase̱ŋ fe̱yɛ, “Mo̱nꞌ nu mo̱ne̱ e̱ye̱e̱ na mo̱nꞌ kiŋŋi le̱e̱ mo̱ne̱ e̱bɔye̱‑rɔ, a le̱e̱ fe̱yɛ Wuribware̱ se̱ a kuwure‑o e̱ kpa a ke̱ ba.” ");
INSERT INTO ncuNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ne̱ Yeesuu a bo̱rɔ Galile̱ya ke̱pare̱ dabe̱ a ke̱be̱gya‑ɔ. Mò̱ a naa nkyu‑o e̱kɛɛkɛɛ se̱‑ɔ, ne̱ oo ŋu ŋkiŋgyi akrapo̱ anyɔ ko̱ ne̱ ba te̱e̱ bamo̱ ɛ Simɔŋ ne̱ mò̱ ke̱ŋasɛnyare̱ e̱ gye̱ Peetroo‑o na mò̱ tire Andruu, na ba twe̱e̱ kisawu ba kra ŋkiŋgyi. ");
INSERT INTO ncuNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱nꞌ ba a ane̱ yɔ. Mo̱ne̱ ma lɛɛ kra ŋkiŋgyi. Amaa mo̱ e̱ kaapo̱ mo̱ne̱ ane̱ŋ ne̱ mo̱ne̱ i buwi ase̱sɛ na mo̱nꞌ baa bamo̱ mo̱ ase̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ne̱ baa yɔwe̱ bamo̱ asawu bo̱ be̱ya puri amo̱‑rɔ, ne̱ baa gya Yeesuu si bo̱ yii. ");
INSERT INTO ncuNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ne̱ ɔɔ me̱raa se̱ yɔ ya to̱ anyare̱ anyɔ ko̱ be̱e̱, Yakubu na mò̱ tire Yohanee. Bamo̱ aa bamo̱ se̱ Sibidii e̱ bo̱ ko̱re̱e̱‑rɔ ba waa bamo̱ asawu siraa. Ne̱ Yeesuu a te̱e̱ bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Puri amo̱‑rɔ ne̱ baa yɔwe̱ bamo̱ se̱ na ko̱re̱e̱‑ɔ, ne̱ baa gya Yeesuu si bo̱ yii. ");
INSERT INTO ncuNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Amo̱ pɛɛɛ kamɛɛ‑ɔ, ne̱ Yeesuu a muruwi Galile̱ya swe̱e̱re̱ se̱ to̱ŋ ke̱maa ɔ kaapo̱ ase̱sɛ atɔ ke̱bware̱ko̱re̱ akyaŋ‑nɔ, na ɔ tɔwe̱ ase̱ŋ timaa bo̱ le̱e̱ Wuribware̱ se̱ a kuwure‑o si, na ɔ kya alɔpo̱. Ne̱ ɔɔ taare̱ kya ase̱sɛ ne̱ baa baa mò̱ ase̱‑ɔ alɔgyi ke̱maa. ");
INSERT INTO ncuNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Mò̱ ase̱ŋ a saŋŋe̱‑rɔ bo̱rɔ Siriya e̱maŋ pɛɛɛ‑rɔ, ane̱ŋ se̱‑ɔ ase̱sɛ amo̱ a taa alɔpo̱ ne̱ ba lɔ alɔgyi ke̱maa‑ɔ baa mò̱ ase̱, ne̱ ɔɔ kya bamo̱ pɛɛɛ. Ase̱sɛ‑ɔ bo̱ko̱, ibrisi te bamo̱ se̱, ne̱ bo̱ko̱ gye̱ kigbuŋgbuŋ alɔpo̱, ne̱ bo̱ko̱ mɔ gye̱ agyabɔɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ne̱ ase̱sɛ bwe̱e̱tɔ ne̱ baa le̱e̱ Galile̱ya swe̱e̱re̱ se̱ na Dekapolis (kaase̱ e̱ kaapo̱ fe̱yɛ E̱maŋ-Kudu) ifuri si na Yɛro̱salɛm maŋ‑nɔ na Yude̱ya swe̱e̱re̱ se̱ na Yo̱o̱daŋ nno̱ŋ a bo̱ŋbe̱‑ɔ a gya mò̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yeesuu a ŋu ase̱sɛ bwe̱e̱tɔ ne̱ baa ba mò̱ ase̱‑ɔ, ne̱ ɔɔ de̱e̱ ke̱be̱e̱ ko̱ se̱ kafwe̱e̱ ya kye̱na na ɔ kaapo̱ atɔ, ne̱ mò̱ agyase̱po̱‑ɔ a kyaa muruwaa mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ne̱ ɔɔ le̱e̱ ɔ kaapo̱ bamo̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Bamo̱ ne̱ bo̱ nyi fe̱yɛ Wuribware̱ ase̱ bo̱ mo̱ŋ de sɛye̱ a bo̱ sa mò̱‑ɔ de ŋyure, a le̱e̱ fe̱yɛ bo̱ tii Wuribware̱ se̱ a kuwure‑o si. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Bamo̱ ne̱ bamo̱ e̱bo̱re̱‑rɔ i duŋwi bamo̱‑ɔ de ŋyure, a le̱e̱ fe̱yɛ Wuribware̱ i yuri bamo̱ ŋkpo̱nɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Bamo̱ ne̱ ba yuri bamo̱ e̱ye̱e̱‑ɔ de ŋyure, a le̱e̱ fe̱yɛ saŋ e̱ fo̱ fe̱yɛ kaye̱ pɛɛɛ i kii bamo̱ lee. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Bamo̱ ne̱ wɔre̱ de bamo̱ itimaa ko̱waa‑ɔ de ŋyure, a le̱e̱ fe̱yɛ Wuribware̱ e̱ sa a itimaa ko̱waa‑ɔ waa bamo̱ kɔne̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bamo̱ ne̱ ba ŋu bo̱ko̱ e̱wɛɛ‑ɔ de ŋyure, a le̱e̱ fe̱yɛ Wuribware̱ i ŋu bamo̱ e̱wɛɛ ane̱ŋ dɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Bamo̱ ne̱ bamo̱ ŋkpo̱nɔ‑rɔ a fwiiri‑o de ŋyure, a le̱e̱ fe̱yɛ ba ŋu Wuribware̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Bamo̱ ne̱ ba suŋ ba kpa kaye̱e̱yuri ba sa bamo̱ abɛɛko̱‑ɔ de ŋyure, a le̱e̱ fe̱yɛ Wuribware̱ e̱ te̱e̱ bamo̱ fe̱yɛ mò̱ gyi‑ana. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Bamo̱ ne̱ bo̱ko̱ e̱ sa ne̱ ba gyi awo̱re̱fɔɔ bo̱ le̱e̱ ane̱ŋ ne̱ ba waa ke̱tɔ ne̱ Wuribware̱ e̱ kpa‑ɔ de ŋyure, a le̱e̱ fe̱yɛ bo̱ tii Wuribware̱ se̱ a kuwure‑o si. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Mo̱ne̱ ne̱ ase̱sɛ e̱ saare̱ mo̱ne̱ bo̱ le̱e̱ fe̱yɛ mo̱ne̱ gye̱ mo̱ agyase̱po̱‑ɔ se̱‑ɔ, ne̱ ba sa ne̱ mo̱ne̱ i gyi awo̱re̱fɔɔ‑ɔ, ne̱ ba ba aye̱ba ke̱maa ba dɔŋŋɔ mo̱ne̱ se̱‑ɔ, mo̱ne̱ de ŋyure, a le̱e̱ fe̱yɛ bamo̱ ko̱waa mo̱ne̱ ane̱ŋ‑ɔ e̱ kaapo̱ ne̱e̱ fe̱yɛ mo̱ne̱ gye̱ mo̱ agyase̱po̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Amo̱se̱‑ɔ mo̱nꞌ sa a mo̱ne̱ akatɔ gyi bwe̱e̱tɔ, a le̱e̱ fe̱yɛ kakɔka dabe̱ timaa ko̱ gywii mo̱ne̱ Wuribware̱ se̱. Bo̱ le̱e̱ fe̱yɛ ane̱ŋ ne̱ ba waa mo̱ne̱‑ɔ dɛɛ ne̱ baa waa Wuribware̱ a akyaamɛɛ ne̱ baa gye̱ mo̱ne̱ ŋkpɛɛ ba‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Mo̱ne̱ du ne̱e̱ fe̱yɛ mfɔre̱‑ɔ bo̱ sa se̱sɛ dimaadi. Amaa mfɔre̱ kɔne̱ ya le̱e̱ fe̱raa, ɔko̱ maa lɛɛ taare̱ a ɔ bo̱rɔ kpa ke̱maa se̱ bo̱ sa a m be̱e̱ kii mfɔre̱ daa. M mo̱ŋ lɛɛ n de ke̱tɔ waasɛ, amo̱se̱‑ɔ ba taa a bo̱ bo̱ twe̱e̱ ne̱e̱ a ase̱sɛ kyikye mmo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Mo̱ne̱ be̱e̱ mo̱ne̱ du ne̱e̱ fe̱yɛ ke̱laŋŋe̱rɔ bo̱ sa kaye̱ pɛɛɛ. Maŋ ne̱ ɔ ye̱re̱ ke̱be̱e̱ se̱‑ɔ maa kwe̱e̱rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ane̱ŋ dɛɛ ne̱ ɔko̱ maa kyaŋŋe̱ mò̱ fetiri si na ɔ ko̱ŋ be̱ra kike bo̱ buŋ si. N gye̱ kabuno ne̱ ɔ taa a ɔ bo̱ ye̱ra aaa, na ɔ laŋŋe̱ lɔŋ‑ɔ‑rɔ pɛɛɛ? ");
INSERT INTO ncuNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mfaanɛɛ dɛɛ ne̱ mo̱nꞌ laŋŋe̱‑rɔ ase̱sɛ akatɔ‑rɔ, na bo̱ nya ŋu atɔ timaa ne̱ mo̱ne̱ e̱ waa‑ɔ, na bo̱ kyo̱rɔ Wuribware̱, mo̱ne̱ se̱ ne̱ ɔ bo̱ so̱so̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ne̱ Yeesuu a kya mò̱ atɔ ke̱kaapo̱‑ɔ se̱ fe̱yɛ, “Mo̱ne̱ e̱ fa fe̱yɛ mo̱ a ba a m bo̱ gya ane̱ ɔde̱daapo̱ Mosis a mbraa‑ɔ na Wuribware̱ a akyaamɛɛ a abware̱se̱ŋ ke̱kaapo̱‑ɔ bo̱ twe̱e̱ ne̱e̱ e̱e̱e̱? Daabii. Mo̱ŋ ba a m bo̱ gya mmo̱ bo̱ twe̱e̱ ne̱e̱, amaa mo̱ a ba a m bo̱ waa ke̱tɔ ke̱maa ne̱ baa kaapo̱‑ɔ kyɛɛkyɛɛ lo̱we̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ bo̱ fo̱ saŋ ne̱ so̱so̱ na swe̱e̱re̱ e̱ kyo̱ŋ‑ɔ, mbraa‑ɔ kabe̱gyɛɛ bɛɛɛ mmo̱ ase̱ŋ kagyingyii maa le̱e̱ se̱ daa, amɔ ke̱tɔ se̱ ne̱ Wuribware̱ a sa ne̱ ane̱ mbraa‑ɔ a ba‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Amo̱se̱‑ɔ ɔke̱maa ne̱ mò̱ ya fo̱ mbraa‑ɔ pɛɛɛ katɔgyingyii ke̱maa, ne̱ ɔɔ kaapo̱ bo̱ko̱ na bo̱ fo̱ mbraa‑ɔ ane̱ŋ dɛɛ‑ɔ, amo̱ fe̱raa, o kii kagyingyii Wuribware̱ se̱ a kuwure‑o‑ro. Amaa ɔke̱maa ne̱ mò̱ ya gya mbraa‑ɔ se̱, ne̱ ɔɔ kaapo̱ bo̱ko̱ a bo̱ gya mmo̱ se̱‑ɔ fe̱raa, ba te̱e̱ mò̱ ɛ se̱sɛ dabe̱ Wuribware̱ se̱ a kuwure‑o‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ mo̱ne̱ itimaa na ke̱dame̱naŋsɛ e̱ mo̱ŋ kyɔ Wuribware̱ mbraa akaapo̱po̱ na Farisii awuye lee‑o, amo̱ fe̱raa mo̱ne̱ maa tii Wuribware̱ se̱ a kuwure‑o si pɛɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Mo̱ne̱ a nu fe̱yɛ de̱daa‑ɔ baa tɔwe̱ gywii ane̱ nana‑ana fe̱yɛ ɔko̱ ma kaŋ mɔɔ se̱sɛ. Ɔke̱maa ne̱ ɔɔ mɔɔ se̱sɛ‑ɔ, ba bu mò̱ ke̱pɔ na bo̱ mɔɔ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Amaa mbe̱yɔmɔ, mo̱‑ɔ mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ ɔke̱maa ne̱ mò̱ duŋ ya fwii mò̱ bɛɛko̱ se̱‑ɔ, bo̱ bu mò̱ ke̱pɔ na bo̱ mɔɔ mò̱, ne̱ ɔke̱maa ne̱ ɔ te̱e̱ mò̱ bɛɛko̱ fe̱yɛ mfɛɛre̱ ke̱‑mo̱ŋ‑de wuye‑o, bo̱ bu mò̱ ke̱pɔ abre̱sɛ akatɔ‑rɔ na bo̱ mɔɔ mò̱, ne̱ ɔke̱maa ne̱ ɔ te̱e̱ mò̱ bɛɛko̱ fe̱yɛ ɔmaŋbweepo̱‑ɔ, a bware fe̱yɛ ɔ yɔ awo̱re̱fɔɔ de̱e̱kpa‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Amo̱se̱‑ɔ fo̱ ko̱ ya yɔ lɔŋŋɔkpa a fo̱ ya lɔŋŋɔ Wuribware̱, ne̱ fo̱ ya nyiŋŋi si fe̱yɛ ase̱ŋ ko̱ bo̱ fo̱ aa fo̱ bɛɛko̱ mbo̱ŋtɔ‑rɔ, yɔwe̱ atɔ ne̱ fo̱ e̱ yaa bo̱ lɔŋŋɔ mò̱‑ɔ bo̱ be̱ya lɔŋŋɔkpa akatɔ‑rɔ, na fo̱ kiŋŋi yɔ fo̱ bɛɛko̱‑ɔ ase̱ a mo̱nꞌ lɔŋŋɔ mo̱ne̱ mbo̱ŋtɔ‑rɔ, pwɛɛ na fo̱ dɛɛ kiŋŋi ba bo̱ lɔŋŋɔ Wuribware̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ne̱ Yeesuu yɛ, “Ane̱ŋ dɛɛ ne̱ fo̱ aa ɔko̱ i de ase̱ŋ, ne̱ mò̱ e̱ kpa a ɔ yaa fo̱ se̱ŋgyikpa, fo̱ ne̱ fo̱ a waa ase̱ŋ‑ɔ na ase̱ŋ wuye‑o lɔŋŋɔ amo̱ pwɛɛ na mo̱nꞌ dɛɛ fo̱ se̱ŋgyikpa‑ɔ mfe̱ŋ. N gye̱ ane̱ŋ, o gyiiri fo̱ a ɔ yaa ɔse̱ŋgyipo̱‑ɔ ase̱, na mò̱ mɔ baa fo̱ bo̱ waa apurisii ke̱sare̱e̱‑rɔ na bo̱ tii fo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kase̱ŋtiŋ si mo̱ e̱ tɔwe̱ mo̱ i gywii fo̱ fe̱yɛ fo̱ i di tiikpa mfe̱ŋ ane̱ŋ‑aaa bo̱ fo̱ saŋ ne̱ fo̱ e̱ ka fo̱ ko̱kɔ a fo̱ lo̱we̱ na paso̱wa gbaa mo̱ŋ saŋ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Mo̱ne̱ a nu fe̱yɛ de̱daa‑ɔ baa tɔwe̱ fe̱yɛ ɔko̱ ma waa kakye̱e̱kpa na kanyare̱kpa. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Amaa mbe̱yɔmɔ mo̱‑ɔ mɔ mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ ɔke̱maa ne̱ ɔ de̱e̱re̱ ɔkye̱e̱, ne̱ ɔ yo̱rɔwe̱ fe̱yɛ o kii mò̱ lee‑o a kyɔ kpa mò̱ mò̱ kakpo̱nɔ‑rɔ kyee. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Amo̱se̱ se̱‑ɔ fo̱ kigyisekatɔ e̱ sa ne̱ fo̱ e̱ waa e̱bɔye̱, lee ke̱mo̱ bo̱ twe̱e̱. Fo̱ ya te̱ŋ fo̱ kayo̱wɔre̱ to̱ŋ ko̱ bo̱ twe̱e̱, ne̱ fo̱ ya nya ŋkpa, a bɔ fe̱yɛ bamo̱ a twe̱e̱ fo̱ kayo̱wɔre̱ pɛɛɛ bo̱ waa awo̱re̱fɔɔ de̱e̱kpa‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ane̱ŋ dɛɛ ne̱ fo̱ kigyisesare̱e̱ e̱ gye̱ ne̱ ke̱ e̱ sa ne̱ fo̱ e̱ waa e̱bɔye̱, te̱ŋ ke̱mo̱ bo̱ twe̱e̱. Fo̱ ya te̱ŋ fo̱ kayo̱wɔre̱ ke̱be̱gya, a bɔ fe̱yɛ fo̱ kayo̱wɔre̱ pɛɛɛ a lwee awo̱re̱fɔɔ de̱e̱kpa‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ne̱ Yeesuu yɛ, “Mo̱ne̱ a be̱e̱ nu fe̱yɛ de̱daa‑ɔ baa tɔwe̱ fe̱yɛ ɔnyare̱ ya kine mò̱ ka, ɔ kyo̱rɛɛ kikine wo̱re̱ sa mò̱ fe̱yɛ oo kine mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Amaa mbe̱yɔmɔ, mo̱‑ɔ mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ ɔnyare̱ ya kine mò̱ ka, ne̱ ɔkye̱e̱‑ɔ ya waare̱e̱ ɔnyare̱ baŋbaŋ, mò̱ ne̱ oo kine mò̱ ka‑ɔ a sa ne̱ ɔkye̱e̱‑ɔ a waa kanyare̱kpa, amɔ ɔkye̱e̱‑ɔ a kyɔ le̱e̱ mò̱ kuri‑o kamɛɛ fe̱raa. Ne̱ ɔnyare̱ ne̱ mò̱‑ɔ mɔ a be̱e̱ waare̱e̱ ane̱ŋ a ɔkye̱e̱‑ɔ mɔ a waa kakye̱e̱kpa.” ");
INSERT INTO ncuNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ne̱ Yeesuu a kya mò̱ atɔ ke̱kaapo̱‑ɔ se̱ fe̱yɛ, “Mo̱ne̱ a be̱e̱ nu fe̱yɛ de̱daa‑ɔ baa tɔwe̱ fe̱yɛ ɔko̱ ma waa e̱taŋ na ɔ laŋŋe̱ mò̱ kanɔ. Ke̱tɔ ne̱ ɔko̱ e̱ waa e̱taŋ fe̱yɛ ɔ waa‑ɔ, ɔ waa. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Amaa mbe̱yɔmɔ, mo̱‑ɔ mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ mo̱ne̱ e̱ kpa a mo̱nꞌ tɔwe̱ bo̱ be̱ya fe̱yɛ mo̱ne̱ e̱ waa ko̱tɔko̱, mo̱ne̱ ma waa e̱taŋ bo̱ tɔwe̱. Mo̱ne̱ ma kaŋ ba Wuribware̱ se̱ bo̱ waa e̱taŋ, a le̱e̱ fe̱yɛ mfe̱ŋ ne̱ Wuribware̱ a kuwuregya‑ɔ bo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ane̱ŋ dɛɛ ne̱ mo̱ne̱ ma ba swe̱e̱re̱ bo̱ waa e̱taŋ, a le̱e̱ fe̱yɛ swe̱e̱re̱ se̱ ne̱ Wuribware̱ ayaapapaa ye̱re̱ a kyure. Mo̱ne̱ ma ba Yɛro̱salɛm bo̱ waa e̱taŋ, a le̱e̱ fe̱yɛ mfe̱ŋ gye̱ Owure‑bo̱‑e̱le̱ŋ-Bware̱ maŋ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mo̱ne̱ ma kaŋ ba mo̱ne̱ aŋu gbaa bo̱ waa e̱taŋ, a le̱e̱ fe̱yɛ mo̱ne̱ maa taare̱ a mo̱nꞌ waa kipwiigyi ko̱ŋko̱ kufufuri bɛɛɛ kigyigyii. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Amaa ke̱tɔ ne̱ mo̱nꞌ bo̱ tɔwe̱ ase̱ŋ bo̱ be̱ya bɛɛɛ mo̱nꞌ bo̱ be̱ŋŋaa ase̱ŋ‑ɔ e̱ gye̱ fe̱yɛ, ‘Ɔɔŋ, ane̱ e̱ waa’, bɛɛɛ ‘Daabii, ane̱ maa waa.’ Ke̱tɔ ke̱maa ne̱ ŋkee mo̱ne̱ e̱ tɔwe̱ a mo̱nꞌ bo̱ tii ɔɔŋ bɛɛɛ daabii si‑o a le̱e̱ Ɔbɔnsam ase̱ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ne̱ Yeesuu a kya se̱ fe̱yɛ, “Mo̱ne̱ a be̱e̱ nu fe̱yɛ baa tɔwe̱ fe̱yɛ, ‘Ɔko̱ ya bwee mò̱ bɛɛko̱ ke̱katɔ, ane̱ŋ dɛɛ ne̱ bo̱ bwee mò̱ lee bo̱ teere. Ne̱ ɔko̱ ya kyuwi mò̱ bɛɛko̱ ke̱bwanɔ, bo̱ kyuwi mò̱ lee.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Amaa mbe̱yɔmɔ mo̱‑ɔ mɔ mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ ɔko̱ ya waa mo̱ne̱ bɔye̱, mo̱ne̱ ma ba bɔye̱ bo̱ ka mò̱ ko̱kɔ. Ɔko̱ ya da fo̱ kigyisese̱bɔ‑rɔ ke̱baa, be̱e̱ buruwaa ke̱be̱nase̱bɔ‑rɔ sa mò̱ a ɔ da. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ne̱ ɔko̱ ya yaa fo̱ iwurekpa a ɔ ya gyi ase̱ŋ bo̱ da fo̱ na ɔ bɔ fo̱ ko̱kɔ, ne̱ mò̱ e̱ kpa fo̱ kaare̱ a ɔ kɔɔre̱, taa fo̱ waagya bo̱ tii mò̱ se̱ na ɔ taa nare̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ne̱ ɔko̱ ya ye̱re̱ fo̱ fe̱yɛ fo̱ so̱rɔ mò̱ atɔ maye̱re̱ ko̱ŋko̱, so̱rɔ yaa mò̱ e̱maye̱re̱ e̱nyɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ɔke̱maa ne̱ ɔ ko̱re̱ fo̱ ko̱tɔko̱‑ɔ, fo̱ i de, sa mò̱ ke̱tɔ‑ɔ. Ɔko̱ e̱ kpa a ɔ para ko̱tɔko̱, bo̱ para mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Mo̱ne̱ a be̱e̱ nu fe̱yɛ baa tɔwe̱ fe̱yɛ, ‘Ɔke̱maa kpa mò̱ bɛɛko̱ ase̱ŋ, na o kisi mò̱ do̱ŋ.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Amaa mbe̱yɔmɔ, mo̱‑ɔ mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ mo̱nꞌ kpa mo̱ne̱ ado̱ŋ ase̱ŋ, na mo̱nꞌ ko̱re̱ ke̱bware̱ko̱re̱ sa bamo̱ ne̱ ba waa mo̱ne̱ bo̱rɔkraa‑ɔ, ");
INSERT INTO ncuNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","na bo̱ ŋu fe̱yɛ kase̱ŋtiŋ si mo̱ne̱ gye̱ Wuribware̱, mo̱ne̱ se̱ ne̱ ɔ bo̱ so̱so̱‑ɔ, mò̱ gyi‑ana. Bo̱ le̱e̱ fe̱yɛ ɔ sa ne̱ mò̱ kyɔwe̱ e̱ we̱e̱ ase̱sɛ bɔye̱ na atimaa si kyɛɛkyɛɛ. Ane̱ŋ dɛɛ ne̱ bware̱ e̱ ba ɔ we̱e̱ bamo̱ ne̱ ba waa itimaa‑o na bamo̱ ne̱ ba waa e̱bɔye̱‑ɔ atɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mo̱ne̱ e̱ kpa bamo̱ ne̱ ba kpa mo̱ne̱‑ɔ wo̱re̱ ase̱ŋ, Wuribware̱ maa sa mo̱ne̱ amo̱ kakɔka. Bo̱ le̱e̱ fe̱yɛ ane̱ŋ dɛɛ ne̱ leŋpoo akɔɔre̱po̱ gbaa e̱ kpa bamo̱ bɛɛko̱‑ana leŋpoo akɔɔre̱po̱ ase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ne̱ mo̱ne̱ e̱ ka mo̱ne̱ anyare̱ kanɔ, nte̱tɔ itimaa ne̱ mo̱ne̱ a waa kyo̱ŋ ɔko̱? Bo̱ le̱e̱ fe̱yɛ ane̱ŋ dɛɛ ne̱ bamo̱ ne̱ bo̱ maa suŋ Wuribware̱‑ɔ gbaa e̱ waa. ");
INSERT INTO ncuNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Amo̱se̱ se̱‑ɔ bɔye̱ ko̱ ma kye̱na mo̱ne̱ se̱, fe̱yɛ ane̱ŋ ne̱ bɔye̱ ko̱ mo̱ŋ te Wuribware̱, mo̱ne̱ se̱ ne̱ ɔ bo̱ so̱so̱‑ɔ, se̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ne̱ Yeesuu a kya mò̱ atɔ ke̱kaapo̱‑ɔ se̱ fe̱yɛ, “Mo̱nꞌ sa se̱, mfe̱ŋ ne̱ mo̱ne̱ e̱ waa itimaa‑o. Mo̱ne̱ e̱ kpa fe̱yɛ mo̱nꞌ ke atiripo̱ atanne̱, bɛɛɛ mo̱nꞌ ko̱re̱ ke̱bware̱ko̱re̱, bɛɛɛ mo̱nꞌ kra ako̱ŋ, mo̱ne̱ ma waa amo̱ lamaŋ akatɔ‑rɔ a bo̱ nya ŋu mo̱ne̱. Mo̱ne̱ ya waa amo̱ lamaŋ‑nɔ, mo̱ne̱ maa nya kakɔka a mo̱nꞌ le̱e̱ Wuribware̱, mo̱ne̱ se̱ ne̱ ɔ bo̱ so̱so̱‑ɔ, ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Amo̱se̱ se̱‑ɔ mo̱ne̱ ɔke̱maa ya ke atiripo̱ atɔ, fo̱ ma sa a ɔke̱maa nu amo̱ se̱, fe̱yɛ ane̱ŋ ne̱ nnɔ ŋnyɔ ŋnyɔ awuye e̱ waa ke̱bware̱ko̱re̱ akyaŋ‑nɔ na mbo̱re̱ se̱‑ɔ. Saŋ ke̱maa ne̱ ba waa itimaa‑o ba fo̱re̱ mbe̱re̱ lamaŋ‑nɔ. Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ dimaadi nkyo̱rɔ e̱ gye̱ bamo̱ kakɔka. Bo̱ maa lɛɛ nya nkyo̱rɔ ko̱ a bo̱ bo̱ le̱e̱ Wuribware̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Mo̱ne̱ fe̱raa, mo̱ne̱ ko̱ ya ke otiripo̱ atɔ, ɔ waa bo̱ kwe̱e̱rɔ, na mò̱ ke̱be̱nasare̱e̱ gbaa ma nya pini ke̱tɔ ne̱ mò̱ kigyisesare̱e̱ e̱ waa‑ɔ. Fo̱ ko̱ ya ke otiripo̱‑ɔ ke̱tɔ na ɔko̱ mo̱ŋ ŋu, amo̱ fe̱raa fo̱ se̱ Wuribware̱ ne̱ o ŋu ke̱tɔ ke̱maa ne̱ se̱sɛ e̱ waa ɔ kwe̱e̱rɔ‑ɔ e̱ gye̱ ne̱ ɔ ka fo̱ ko̱kɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ane̱ŋ dɛɛ ne̱ mo̱ne̱ e̱ ko̱re̱ ke̱bware̱ko̱re̱, mo̱ne̱ ma waa fe̱yɛ nnɔ ŋnyɔ ŋnyɔ awuye‑o. Ba kpa ke̱ye̱re̱ ke̱bware̱ko̱re̱ akyaŋ‑nɔ na e̱kpa gyaŋŋe̱kpa ba ko̱re̱ ke̱bware̱ko̱re̱ na ɔke̱maa nya ŋu bamo̱. M be̱e̱ mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ dimaadi nkyo̱rɔ dooo e̱ gye̱ bamo̱ kakɔka. ");
INSERT INTO ncuNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Amaa fo̱ ko̱ e̱ ko̱re̱ ke̱bware̱ko̱re̱, fo̱ yɔ fo̱ ke̱kyaŋ‑nɔ na fo̱ tii po̱ne̱, na fo̱ ko̱re̱ Wuribware̱ fo̱ se̱ ne̱ fo̱ mo̱ŋ ke̱e̱‑ɔ. Na mò̱‑ɔ mò̱ ne̱ o ŋu ke̱tɔ ke̱maa ne̱ ɔke̱maa e̱ waa ɔ bo̱ kwe̱e̱rɔ‑ɔ sa fo̱ amo̱ kakɔka. ");
INSERT INTO ncuNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ke̱tɔ ne̱ ko̱ kyɔ ne̱ ki tii si‑o e̱ gye̱ fe̱yɛ mo̱ne̱ e̱ ko̱re̱ Wuribware̱, mo̱ne̱ ma ko̱re̱ ke̱bware̱ko̱re̱ so̱swe̱e̱ so̱swe̱e̱ so̱swe̱e̱, fe̱yɛ ane̱ŋ ne̱ bamo̱ ne̱ ba suŋ ikisi‑o e̱ da laa‑ɔ, ne̱ ba fa fe̱yɛ bamo̱ nlaada so̱swe̱e̱ se̱‑ɔ, bamo̱ ikisi i nu a e̱ sa bamo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mo̱ne̱ ma waa fe̱yɛ bamo̱‑ɔ, a le̱e̱ fe̱yɛ mo̱ne̱ se̱ Wuribware̱ kyɔ o nyi ke̱tɔ ne̱ mo̱ne̱ e̱ kpa‑ɔ pwɛɛ ne̱ mo̱ne̱ a dɛɛ ko̱re̱ mò̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ne̱ Yeesuu yɛ, “Mfaanɛɛ ne̱ mo̱nꞌ ko̱re̱ ke̱bware̱ko̱re̱. Ane̱ se̱ Wuribware̱ ne̱ fo̱ bo̱ so̱so̱‑ɔ, sa a bo̱ kyo̱rɔ fo̱ ke̱nyare̱ timaa. ");
INSERT INTO ncuNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Na fo̱ baa fo̱ kuwure‑o bo̱ gyi mfe̱e̱. Na fo̱ sa a fo̱ ke̱pre̱ waa swe̱e̱re̱ se̱ mfe̱e̱, fe̱yɛ ane̱ŋ ne̱ ke̱ e̱ waa so̱so̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Sa ane̱ ateese ne̱ a tiri ane̱ ndɔɔ na kake ke̱maa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Na fo̱ taa ane̱ e̱bɔye̱ bo̱ ke ane̱, fe̱yɛ ane̱ŋ ne̱ bo̱ko̱ a waa e̱bɔye̱ bo̱ kye ane̱, ne̱ ane̱ a taa bo̱ ke bamo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Na fo̱ ma sa kpa a Ɔbɔnsam kyɔ ane̱‑rɔ ke̱e̱ fe̱yɛ ane̱ e̱ waa e̱bɔye̱ aaa. Na fo̱ lee ane̱ le̱e̱ ɔkyɔrɔpo̱ a ke̱sare̱e̱‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Mo̱ne̱ ya ba bo̱ko̱ a e̱bɔye̱ ne̱ baa waa mo̱ne̱‑ɔ bo̱ ke bamo̱, Wuribware̱, mo̱ne̱ se̱ ne̱ ɔ bo̱ so̱so̱‑ɔ, mɔ e̱ ba mo̱ne̱ lee a ɔ bo̱ ke mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Amaa mo̱ne̱ e̱ mo̱ŋ taa mo̱ne̱ bɛɛko̱‑ana e̱bɔye̱ bo̱ ke bamo̱, amo̱ fe̱raa mo̱ne̱ se̱ ne̱ ɔ bo̱ so̱so̱‑ɔ gbaa maa taa mo̱ne̱ lee a ɔ bo̱ ke mo̱ne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ne̱ Yeesuu a kya mò̱ atɔ ke̱kaapo̱‑ɔ se̱ fe̱yɛ, “To, mo̱ne̱ ya kra ako̱ŋ, mo̱ne̱ ma kaŋ ba nsɔ bo̱ bure mo̱ne̱ akatɔ‑rɔ, fe̱yɛ ane̱ŋ ne̱ nnɔ ŋnyɔ ŋnyɔ awuye e̱ waa‑ɔ. Ba waa ane̱ŋ ne̱e̱ a ase̱sɛ nya ŋu fe̱yɛ ba kra ako̱ŋ. Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ dimaadi nkyo̱rɔ e̱ gye̱ bamo̱ kakɔka. ");
INSERT INTO ncuNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Mo̱ne̱ fe̱raa, mo̱ne̱ ko̱ e̱ kra ako̱ŋ, ɔ fwe̱e̱ mò̱ akatɔ‑rɔ na ɔ sɛɛ mò̱ kuŋu‑ro, na ɔko̱ ma nya ŋu fe̱yɛ ɔ kra ako̱ŋ ne̱e̱. Amɔ Wuribware̱, fo̱ se̱ ne̱ fo̱ mo̱ŋ ke̱e̱ mò̱‑ɔ, wo̱re̱ e̱ gye̱ ne̱ o ŋu. Na fo̱ se̱ ne̱ o ŋu ke̱tɔ ne̱ ɔke̱maa e̱ waa ɔ bo̱ kwe̱e̱rɔ‑ɔ e̱ gye̱ ne̱ ɔ ka fo̱ ko̱kɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ne̱ Yeesuu yɛ, “Mo̱ne̱ ma kpa kapo̱tɛɛ bo̱ ye̱ra swe̱e̱re̱ se̱ mfe̱e̱ sa mo̱ne̱ e̱ye̱e̱. A le̱e̱ fe̱yɛ mfe̱e̱ a kapo̱tɛɛ‑ɔ fe̱raa igyeeri na nsekreeke na ŋkaŋte̱ne̱ e̱ nye̱ra kamo̱, ne̱ ayu e̱ gyaa fo̱ lɔŋ a bo̱ lweero ya ywii kamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Gya e̱kpa ne̱ e̱e̱ sa a Wuribware̱ kpa kapo̱tɛɛ bo̱ ye̱ra so̱so̱ sa fo̱‑ɔ se̱. A le̱e̱ fe̱yɛ so̱so̱ mfe̱ŋ fe̱raa igyeeri na nsekreeke na ŋkaŋte̱ne̱ maa nye̱ra kamo̱, ne̱ ayu maa taare̱ a bo̱ gyaa fo̱ lɔŋ lweero ya ywii kamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","A le̱e̱ fe̱yɛ to̱ŋ ke̱maa ne̱ fo̱ kapo̱tɛɛ da‑ɔ, fo̱ mfɛɛre̱ e̱ ya dɔŋŋɔ kamo̱ se̱ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","N taa fe̱yɛ fo̱ fetiri e̱ bo̱ daŋ. Ɔ laŋŋe̱‑rɔ lɔŋ‑nɔ pɛɛɛ. Ne̱ mò̱ ya nye̱ra fe̱raa, kibugyii e̱ da fo̱ lɔŋ‑nɔ. Ane̱ŋ dɛɛ ne̱ fo̱ akatɔ e̱ bo̱ daŋ, fo̱ ke̱e̱ nɛɛnɛɛ. Amaa amo̱ e̱ mo̱ŋ ke̱e̱ fe̱raa, a du ne̱e̱ fe̱yɛ fo̱ a te kibugyii‑ro‑o. Ke̱laŋŋe̱rɔ maa taare̱ a ki yii fo̱ akatɔ‑rɔ. Amo̱se̱ se̱‑ɔ fo̱ ayo̱rɔwe̱tɔ e̱ mo̱ŋ bo̱ daŋ, fo̱ kakpo̱nɔ‑rɔ maa fwiiri. Ne̱ kibugyii ne̱ fo̱ te‑ro‑o kyɔ bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ane̱ŋ dɛɛ ne̱ se̱sɛ maa taare̱ a o suŋ anyaŋpe̱ anyɔ. Amo̱ ya ba ane̱ŋ, o kisi ɔko̱ na ɔ kpa ɔko̱ ase̱ŋ, na o suŋ ɔko̱ kyo̱ŋ ɔko̱. Amo̱se̱‑ɔ mo̱ne̱ maa taare̱ a mo̱nꞌ kpa Wuribware̱ na mo̱nꞌ be̱e̱ kpa atanne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ne̱ Yeesuu a kya se̱ fe̱yɛ, “Ane̱ŋ se̱‑ɔ, mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ mo̱ne̱ ma sa a ateese ne̱ mo̱ne̱ i gyi‑o bɛɛɛ atɔ ne̱ mo̱ne̱ i buŋ‑o ase̱ŋ tɔɔraa mo̱ne̱. Ŋkpa ase̱ŋ tiri a kyɔ ateese bɛɛɛ? Ne̱ kayo̱wɔre̱ mɔ tiri ka kyɔ atɔ buŋsɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mo̱nꞌ ke̱e̱ mbo̱gyii. Bo̱ maa taare̱ a bo̱ dɔɔ nya ateese, hare̱e̱ ba swii amo̱ ako̱ a bo̱ bo̱ waa akyeŋkyeŋku‑ro. Amaa Wuribware̱, mo̱ne̱ se̱ ne̱ ɔ bo̱ so̱so̱‑ɔ, e̱ gye̱ ne̱ ɔ be̱ra bamo̱ saŋ ke̱maa. Mo̱ne̱ mɔ mo̱ne̱ kyɔ mbo̱gyii bɛɛɛ? ");
INSERT INTO ncuNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kanɔ ŋke̱maa ne̱ mo̱ne̱ e̱ fa mo̱ne̱ ŋkpa ase̱ŋ bwe̱e̱tɔ‑ɔ, mo̱ne̱ ɔko̱ maa taare̱ a ɔ sa kake ko̱ŋko̱ kpeŋ gbaa bo̱ tii mò̱ ŋke ne̱ Wuribware̱ a sa mò̱ fe̱yɛ ɔ bo̱ gyi kaye̱ mɔ‑rɔ‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Nte̱tɔ se̱ ne̱ atɔ buŋsɛ ase̱ŋ e̱ tɔɔraa mo̱ne̱? Mo̱nꞌ ke̱e̱ ane̱ŋ ne̱ afe̱raagyi e̱ daŋ‑ɔ. A maa suŋ, ne̱ a maa lo̱ atɔ buŋsɛ a sa amo̱ e̱ye̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Amaa mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ Owure Solomɔŋ gbaa a dɛɛ kye̱na‑ɔ, na mò̱ aa mò̱ atɔ buŋsɛ dame̱naŋsɛ gbaa ooo, ɔ mo̱ŋ nya waagya timaa na ɔ bo̱ daŋ fe̱yɛ afe̱raagyi amo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mo̱ne̱ Wuribware̱ ko̱kɔɔre̱gyi mo̱ŋ kyɔ. Mo̱nꞌ ke̱e̱ ane̱ŋ ne̱ e̱fa gbaa ne̱ e̱ ye̱re̱ ndɔɔ, ne̱ bo̱ fo̱ nyaŋe̱‑ɔ na ase̱sɛ te̱ŋŋe̱ e̱mo̱ bo̱ kure de̱e̱kpa, ne̱ e̱mo̱ ase̱ŋ tiri‑o. Amɔ mo̱ne̱ fe̱raa ne̱ mo̱ne̱ gye̱ ase̱sɛ‑ɔ, Wuribware̱ ne̱ ɔ sa e̱mo̱ atɔ buŋsɛ‑ɔ maa pee akatɔ a ɔ sa mo̱ne̱ atɔ buŋsɛ aaa? ");
INSERT INTO ncuNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Amo̱se̱‑ɔ mo̱ne̱ ma sa a ke̱tɔ ne̱ mo̱ne̱ i gyi‑o na ke̱tɔ ne̱ mo̱ne̱ i nuu‑o na ke̱tɔ ne̱ mo̱ne̱ i buŋ‑o ase̱ŋ tɔɔraa mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","A le̱e̱ fe̱yɛ bamo̱ ne̱ bo̱ maa suŋ Wuribware̱‑ɔ e̱ gye̱ ne̱ ba tɔɔraa bamo̱ e̱ye̱e̱ mfaanɛɛ a atɔ‑ɔ se̱. Wuribware̱, mo̱ne̱ se̱ ne̱ ɔ bo̱ so̱so̱‑ɔ, nyi fe̱yɛ atɔ mɔ pɛɛɛ tiri mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Amaa mo̱nꞌ sa a mo̱ne̱ mfɛɛre̱ yɔ Wuribware̱ a kuwure‑o‑ro atɔ se̱, na ke̱tɔ ne̱ ɔ kpa fe̱yɛ mo̱ne̱ waa‑ɔ se̱. Mo̱ne̱ i buwi mo̱ne̱ e̱ kpa Wuribware̱ a kuwure‑o‑ro atɔ fe̱raa, Wuribware̱ e̱ taa amo̱ a ɔ bo̱ sa mo̱ne̱, na ɔ be̱e̱ sa mo̱ne̱ ke̱tɔ ke̱maa ne̱ ki tiri mo̱ne̱‑ɔ bo̱ tii si. ");
INSERT INTO ncuNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Amo̱se̱‑ɔ mo̱ne̱ ma sa a nyaŋe̱ ase̱ŋ tɔɔraa mo̱ne̱. Nyaŋe̱ ase̱ŋ gye̱ nyaŋe̱ lee ne̱e̱. Amo̱se̱‑ɔ a mo̱ŋ lɛɛ a tiri fe̱yɛ mo̱nꞌ tɔɔraa mo̱ne̱ e̱ye̱e̱ bo̱ le̱e̱ kake ke̱maa a ke̱tɔ ne̱ ke̱ e̱ ba‑ɔ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Mo̱ne̱ ya po̱rɔ mo̱ne̱ bɛɛko̱‑ana, Wuribware̱ mɔ e̱ po̱rɔ mo̱ne̱. Amo̱se̱‑ɔ mo̱ne̱ ma po̱rɔ mo̱ne̱ bɛɛko̱‑ana. ");
INSERT INTO ncuNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","A le̱e̱ fe̱yɛ ane̱ŋ ne̱ mo̱ne̱ e̱ waa mo̱ne̱ bɛɛko̱‑ana‑ɔ dɛɛ ne̱ Wuribware̱ mɔ e̱ ba a ɔ bo̱ waa mo̱ne̱. Ɔ ba mo̱ne̱ fɔŋfɔŋ ase̱ŋ tɔwe̱sɛ a ɔ bo̱ po̱rɔ mo̱ne̱ bu mo̱ne̱ ke̱pɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ne̱ Yeesuu a tɔwe̱ ke̱kpare̱ mɔ gywii bamo̱ fe̱yɛ, “E̱me̱ne̱ se̱ ne̱ kakpafɛɛ ne̱ ka dɔŋ fo̱ bɛɛko̱ ke̱katɔ se̱‑ɔ ne̱ fo̱ ke̱e̱, ne̱ fo̱ mo̱ŋ ke̱e̱ ke̱be̱ŋtiŋ dabe̱ ne̱ ke̱ dɔŋ fo̱ lee si‑o? ");
INSERT INTO ncuNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Bɛɛɛ e̱me̱ne̱ ne̱ fo̱ e̱ waa na fo̱ tɔwe̱ gywii fo̱ ko̱so̱bɛɛ‑ɔ fe̱yɛ, ‘Mo̱ ko̱so̱bɛɛ, sa a n lee kakpafɛɛ ne̱ ka dɔŋ fo̱ ke̱katɔ se̱‑ɔ’, na fo̱ fe̱raa fo̱ de ke̱be̱ŋtiŋ dabe̱ na ke̱ dɔŋ fo̱ fɔŋfɔŋ ke̱katɔ se̱? ");
INSERT INTO ncuNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Fo̱ nnɔ ŋnyɔ ŋnyɔ wuye mɔ, lee ke̱be̱ŋtiŋ dabe̱ ne̱ ke̱ dɔŋ fo̱ fɔŋfɔŋ ke̱katɔ se̱‑ɔ pwɛɛ na fo̱ dɛɛ taare̱ ŋu dame̱naŋsɛ lee kakpafɛɛ ne̱ ka dɔŋ fo̱ bɛɛko̱ lee si‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Amo̱se̱‑ɔ fo̱ ma taa fo̱ kabo̱ ne̱ fo̱ a bo̱ lɔŋŋɔ Wuribware̱‑ɔ kiyee bo̱ sa igyono, bo̱ le̱e̱ fe̱yɛ bamo̱ ya nya fo̱, ba duŋwi. Ane̱ŋ dɛɛ ne̱ fo̱ ma taa fo̱ atɔ timaa bo̱ sa prako na o gyi, a le̱e̱ fe̱yɛ o kyikye amo̱ se̱ a ɔ bo̱ waa e̱se̱‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ne̱ Yeesuu yɛ, “Mo̱ne̱ ya ko̱re̱ Wuribware̱ atɔ, mo̱ne̱ e̱ nya ke̱tɔ ne̱ mo̱ne̱ e̱ kpa‑ɔ. Mo̱ne̱ ya buwi kpa Wuribware̱ a e̱kpa‑ɔ, mo̱ne̱ i ŋu ke̱tɔ ne̱ mo̱ne̱ e̱ kpa‑ɔ. Mo̱ne̱ ya ye̱re̱ kawu te̱e̱ mò̱, ɔ taye̱ po̱ne̱‑ɔ, na mo̱nꞌ nya lweero. ");
INSERT INTO ncuNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","A le̱e̱ fe̱yɛ ɔke̱maa ne̱ ɔ ko̱re̱ atɔ‑ɔ e̱ nya, ne̱ ɔke̱maa ne̱ o buwi a ɔ kpa Wuribware̱ a e̱kpa‑ɔ i ŋu, na po̱ne̱ buŋŋi bo̱ sa ɔke̱maa ne̱ ɔ ye̱re̱ kawu ɔ te̱e̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","M be̱e̱ taa fe̱yɛ mo̱ne̱ nsɛ ne̱ mò̱ gyi e̱ tɔwe̱ fe̱yɛ ɔ kpa bodobodoo a ɔ wo̱, ne̱ ɔ taa kibu a ɔ bo̱ sa mò̱? ");
INSERT INTO ncuNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Bɛɛɛ mò̱ ya ko̱re̱ kakiŋgyi a ɔ wo̱, fo̱ e̱ taa ko̱wɔ a fo̱ bo̱ sa mò̱ aaa? ");
INSERT INTO ncuNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mo̱ne̱ ne̱ mo̱ne̱ gye̱ ase̱sɛ bɔye̱‑ɔ gbaa nyi e̱sa mo̱ne̱ gyi‑ana atɔ timaa, saŋbo̱to̱ Wuribware̱, mo̱ne̱ se̱ ne̱ ɔ bo̱ so̱so̱‑ɔ, e̱ gye̱ ne̱ mo̱ne̱ ya ko̱re̱ mò̱ atɔ timaa, ne̱ ɔ maa taare̱ a ɔ sa mo̱ne̱ aaa? ");
INSERT INTO ncuNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Amo̱se̱ se̱‑ɔ, katiŋ‑o e̱ gye̱ fe̱yɛ ane̱ŋ ne̱ mo̱ne̱ e̱ kpa fe̱yɛ mo̱ne̱ abɛɛko̱ waa mo̱ne̱‑ɔ, mo̱ne̱ mɔ mo̱nꞌ waa ane̱ŋ dɛɛ sa bamo̱. A le̱e̱ fe̱yɛ ke̱tɔ ne̱ mbraa ne̱ Mosis a sa ane̱‑ɔ na ke̱tɔ ne̱ Wuribware̱ akyaamɛɛ a kaapo̱‑ɔ kaase̱ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ne̱ Yeesuu yɛ, “Mo̱nꞌ bo̱rɔ kabunogyii bɔŋbɔŋsɛ‑ɔ‑rɔ lweero, a le̱e̱ fe̱yɛ mfe̱ŋ ne̱ ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ bo̱. Amo̱se̱‑ɔ mo̱nꞌ le̱ŋ e̱ye̱e̱ bo̱rɔ mfe̱ŋ lweero. Bo̱ le̱e̱ fe̱yɛ mo̱ne̱ ya bo̱rɔ kabunogyii kpaŋŋe̱sɛ‑ɔ‑rɔ lweero, mo̱ne̱ i ŋu awo̱re̱fɔɔ ne̱ a mo̱ŋ de kɛɛ‑ɔ. Kpa ne̱ ɔ da bo̱ yɔ awo̱re̱fɔɔ ne̱ a mo̱ŋ de kɛɛ‑ɔ‑rɔ‑ɔ a kpaŋŋe̱, ne̱ ase̱sɛ bwe̱e̱tɔ bɔ mò̱ se̱ ba yɔ ba lwee kabunogyii kpaŋŋe̱sɛ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Amaa mfe̱ŋ ne̱ ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ bo̱‑ɔ kabunogyii‑o du bɔŋbɔŋ. Ne̱ kpa ne̱ ɔ da bo̱ yɔ mfe̱ŋ‑ɔ bo̱rɔ se̱ bo̱ le̱ŋ. Amo̱se̱‑ɔ ase̱sɛ kafwe̱e̱ e̱ gye̱ ne̱ ba ŋu kpa amo̱ bo̱ bɔ se̱ ba yɔ ba lwee kabunogyii bɔŋbɔŋsɛ‑ɔ‑rɔ ba yɔ mfe̱ŋ ne̱ ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ bo̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ne̱ Yeesuu yɛ, “Mo̱nꞌ sa mo̱ne̱ e̱ye̱e̱ se̱ bo̱ le̱e̱ aye̱bapo̱ ne̱ bo̱ yɛ bo̱ gye̱ Wuribware̱ akyaamɛɛ‑ɔ se̱. Ba lwee mo̱ne̱‑rɔ, na akatɔ se̱ bo̱ du fe̱yɛ e̱sanne̱ ne̱ bo̱ maa waa ɔko̱ bɔye̱‑ɔ. Amaa bamo̱ mme‑ro bo̱ du ne̱e̱ fe̱yɛ ŋgboogboo‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Bamo̱ awaasɛ se̱ ne̱ mo̱ne̱ e̱ ba a mo̱nꞌ bo̱ pini bamo̱. Mo̱ne̱ a tɛɛ ŋu fe̱yɛ le̱ŋkre̱ŋ a swɛɛ kimaŋgoo agyi aaa, ne̱ kuruŋbree mɔ a swɛɛ kukuti agyi aaa? Daabii. ");
INSERT INTO ncuNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Amo̱se̱‑ɔ kiyii timaa ke̱maa e̱ swɛɛ agyi timaa ne̱e̱. Ne̱ kiyii ne̱ ke̱ mo̱ŋ de alaŋfiya‑o mɔ e̱ swɛɛ agyi bɔye̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kiyii timaa‑o maa swɛɛ agyi bɔye̱. Ne̱ kiyii ne̱ ke̱ mo̱ŋ de alaŋfiya‑o mɔ maa swɛɛ agyi timaa. ");
INSERT INTO ncuNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kiyii ke̱maa ne̱ ke̱ maa swɛɛ agyi timaa‑o, ba ŋe ke̱mo̱ a bo̱ bo̱ da, na bo̱ twe̱e̱ ke̱mo̱ waa de̱e̱kpa‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Amo̱se̱‑ɔ, bamo̱ ne̱ ba ba aye̱ba fe̱yɛ bo̱ gye̱ Wuribware̱ akyaamɛɛ‑ɔ awaasɛ ne̱ mo̱ne̱ e̱ ba a mo̱nꞌ bo̱ pini bamo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ne̱ Yeesuu a kya mò̱ ke̱kaapo̱‑ɔ se̱ fe̱yɛ, “N gye̱ ɔke̱maa ne̱ ɔ te̱e̱ mo̱ ɛ mò̱ nyaŋpe̱‑ɔ e̱ gye̱ ne̱ o tii Wuribware̱ se̱ a kuwure‑o si, amɔ bamo̱ ne̱ ba waa ke̱tɔ ne̱ n se̱ ne̱ ɔ bo̱ so̱so̱‑ɔ e̱ kpa fe̱yɛ bo̱ waa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kake nsi ne̱ mo̱ e̱ ba a m bo̱ gyi kaye̱‑rɔ ase̱sɛ pɛɛɛ ase̱ŋ‑ɔ, ase̱sɛ bwe̱e̱tɔ e̱ ye̱re̱ mo̱ akatɔ‑rɔ, na bo̱ tɔwe̱ fe̱yɛ, ‘O ane̱ nyaŋpe̱, n gye̱ fo̱ ke̱nyare̱‑rɔ ne̱ ane̱ a tɔwe̱ ke̱tɔ ne̱ fo̱ a lee bo̱ kaapo̱‑ɔ gywii ase̱sɛ aaa? N gye̱ fo̱ ke̱nyare̱ ne̱ ane̱ a ba bo̱ gya ibrisi bo̱ ko̱so̱ bo̱ko̱ se̱ aaa? Bɛɛɛ n gye̱ fo̱ ke̱nyare̱ ne̱ ane̱ a bo̱ waa akpe̱ŋe̱ye̱e̱tɔ bwe̱e̱tɔ aaa?’ ");
INSERT INTO ncuNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Na mo̱‑ɔ m be̱e̱ be̱ŋŋaa bamo̱ lamaŋ‑nɔ mfe̱ŋ fe̱yɛ, ‘M fe̱raa n kyɔ mo̱ŋ nyi mo̱ne̱, a le̱e̱ fe̱yɛ mo̱ne̱ gye̱ e̱bɔye̱ awaapo̱ ne̱e̱. Amo̱se̱‑ɔ mo̱nꞌ le̱e̱ mo̱ ase̱.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ne̱ Yeesuu a tɔwe̱ bo̱ gye̱ kɛɛ fe̱yɛ, “Amo̱se̱‑ɔ, mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ ane̱ŋ ne̱ ɔke̱maa ne̱ o nu mo̱ ase̱ŋ‑ɔ, ne̱ ɔ gya amo̱ se̱‑ɔ du‑o. O du fe̱yɛ onyiase̱ŋpo̱ ko̱ ne̱ ɔɔ kye̱na‑ɔ. Ne̱ ɔ kpa a ɔ pwɛɛ mò̱ lɔŋ. Ne̱ ɔɔ ba afo̱re̱ bo̱ da talii pwɛɛ ne̱ ɔɔ dɛɛ pwɛɛ mò̱ lɔŋ‑ɔ bo̱ ye̱ra se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mò̱ a pwɛɛ mò̱ lɔŋ‑ɔ bo̱ ye̱ra lo̱we̱‑ɔ, bware̱ a ba bwe̱e̱tɔ. Ne̱ bo̱ŋ ko̱ a twe̱e̱ kufwiiri, ne̱ mò̱ nkyu a gyaa bo̱ to̱waa lɔŋ‑ɔ. Ne̱ afwii de̱maŋte̱ ko̱ a da bo̱ we̱e̱ lɔŋ‑ɔ se̱. Amo̱ pɛɛɛ gbaa ooo lɔŋ‑ɔ mo̱ŋ bwee, a le̱e̱ fe̱yɛ onyiase̱ŋpo̱ amo̱ a pwɛɛ mò̱ lɔŋ‑ɔ bo̱ ye̱ra afo̱re̱ se̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Amaa ɔke̱maa ne̱ o nu mo̱ ase̱ŋ ne̱ mo̱ e̱ tɔwe̱‑ɔ ne̱ mò̱‑ɔ mo̱ŋ gya amo̱ se̱‑ɔ mɔ du ne̱e̱ fe̱yɛ mfɛɛre̱ ke̱‑mo̱ŋ‑de wuye ko̱ ne̱ ɔ dɛɛ ɔ bo̱‑rɔ‑ɔ. Ne̱ ɔ kpa a ɔ pwɛɛ mò̱ lɔŋ. Ne̱ mò̱ fe̱raa ɔɔ pwɛɛ mò̱ lɔŋ‑ɔ bo̱ ye̱ra ke̱se̱pu si. ");
INSERT INTO ncuNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ne̱ bware̱ a ba bwe̱e̱tɔ. Ne̱ bo̱ŋ ko̱ a twe̱e̱ kufwiiri, ne̱ mò̱ nkyu a gyaa bo̱ to̱waa lɔŋ‑ɔ. Ne̱ afwii de̱maŋte̱ a da bo̱ we̱e̱ lɔŋ‑ɔ se̱. Ne̱ lɔŋ amo̱ a bwee le̱e̱ da wuuruum. Amo̱ e̱ gye̱ saase̱bɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yeesuu a sa se̱ŋsa lo̱we̱‑ɔ, ne̱ e̱ye̱e̱ a kpe̱ŋ lamaŋ ne̱ baa nu mò̱ ase̱ŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ne̱ bo̱ yɛ, “Ɔ maa kaapo̱ abware̱se̱ŋ fe̱yɛ ane̱ŋ ne̱ ane̱ Wuribware̱ mbraa akaapo̱po̱ e̱ kaapo̱‑ɔ. Ɔ kaapo̱ ne̱e̱ fe̱yɛ mò̱ a gye̱ mbraa‑ɔ ɔsapo̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ne̱ Yeesuu a kpo̱ro̱we̱ le̱e̱ ke̱be̱e̱‑ɔ se̱ mfe̱ŋ ne̱ ɔɔ de̱ŋ kaapo̱ abware̱se̱ŋ lo̱we̱‑ɔ. Ne̱ ase̱sɛ bwe̱e̱tɔ gya mò̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ne̱ bwatɔpo̱ ko̱ a bo̱ kpuni aŋurii Yeesuu ayaa‑rɔ. Ne̱ ɔ yɛ, “Mo̱ nyaŋpe̱, fo̱ e̱ kpa, fo̱ e̱ taare̱ a fo̱ kya mo̱ ko̱lɔ mɔ na ŋ nya lwee ase̱sɛ‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ne̱ Yeesuu a teyi ke̱sare̱e̱ bo̱ dabo̱rɔ mò̱ tɔwe̱ fe̱yɛ, “Mo̱ e̱ kpa. Mbe̱yɔmɔ fo̱ e̱ taare̱ a fo̱ lwee ase̱sɛ‑rɔ, a le̱e̱ fe̱yɛ fo̱ a kpaare̱.” Mfe̱ŋ dɛɛ ne̱ ɔnyare̱ amo̱ a ke̱bwatɔ‑ɔ a lo̱we̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kamɛɛ‑rɔ ne̱ Yeesuu a yii mò̱ se̱ fe̱yɛ, “De̱ŋ bo̱rɔ kpa kyɛye̱ se̱ yɔ Wuribware̱ alɔŋŋɔpo̱‑ɔ ɔko̱ ase̱ na ɔ de̱e̱re̱ fo̱, na a bo̱ kaapo̱ ɔke̱maa fe̱yɛ fo̱ a kpaare̱. Na fo̱ bɔ alɔŋŋɔtɔ ne̱ ane̱ ɔde̱daapo̱ Mosis a tɔwe̱ ɛ mò̱ ne̱ ɔɔ lɔ ko̱lɔ mɔ, ne̱ ɔɔ kpaare̱‑ɔ bɔ, na ɔke̱maa ŋu fe̱yɛ ane̱ŋ a ko̱lɔ‑ɔ mo̱ŋ lɛɛ ki te mò̱ se̱‑ɔ. Fo̱ a maa se̱ fo̱ e̱ yɔ fo̱ bo̱ kpa‑rɔ‑ɔ, fo̱ ma kaŋ ye̱re̱ tɔwe̱ ke̱tɔ ne̱ mo̱ a waa sa fo̱‑ɔ gywii ɔko̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ne̱ Yeesuu a yɔ Kapaaniyum maŋ‑nɔ. Mfe̱ŋ ne̱ asoogyaa abre̱sɛ‑ɔ ɔko̱ a ba mò̱ ase̱ bo̱ ko̱re̱ mò̱ fe̱yɛ ɔ kya mò̱‑rɔ. Ɔ mo̱ŋ gye̱ Isireeliinyi fe̱yɛ Yeesuu‑o. Ɔ gye̱ Romanyi ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ne̱ ɔ yɛ, “Mo̱ nyaŋpe̱, mo̱ ke̱yaafɔre̱ e̱ lɔ ɔ da lɔŋ‑nɔ, e̱ye̱e̱ bo̱ mò̱ gya bwe̱e̱tɔ, hare̱e̱ ɔ maa lɛɛ taare̱ a ɔ dabo̱rɔ e̱ye̱e̱ gbaa.” ");
INSERT INTO ncuNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ne̱ Yeesuu yɛ, “Yooo, mo̱ a nu. Mo̱ e̱ ba a m bo̱ kya mò̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ne̱ soogyaa‑o a lee kanɔ fe̱yɛ, “Mo̱ nyaŋpe̱, mo̱ŋ bware fe̱yɛ fo̱ ba mo̱ lɔŋ‑nɔ‑ɔ. Amo̱se̱‑ɔ fo̱ ya de̱ŋ sa kanɔ bo̱ kyo̱ŋwe̱ gbaa, mo̱ ke̱yaafɔre̱‑ɔ e̱ kpaare̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ŋ gbaa mo̱ ne̱ n gye̱ se̱sɛ laŋgyaŋ‑ɔ. N de abre̱sɛ ne̱ bo̱ kyɔ mo̱‑ɔ. N de asoogyaa awuye mo̱ kaase̱, ne̱ mo̱ ya tɔwe̱ gywii bamo̱‑rɔ ɔko̱‑ɔ fe̱yɛ ‘Nare̱,’ ɔ yɔ ne̱e̱. Ne̱ mo̱ ya tɔwe̱ gywii bamo̱‑rɔ ɔko̱ mɔ fe̱yɛ ‘Ba,’ puri amo̱‑rɔ amɔ ɔ ba. Ne̱ mo̱ ya tɔwe̱ gywii mo̱ ke̱yaafɔre̱ fe̱yɛ, ‘Waa ke̱mo̱‑ɔ,’ amɔ ɔ waa.” ");
INSERT INTO ncuNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yeesuu a nu ase̱ŋ ne̱ ɔnyare̱ amo̱ a tɔwe̱‑ɔ, ne̱ e̱ye̱e̱ a kpe̱ŋ mò̱. Ne̱ oo buruwaa tɔwe̱ gywii ase̱sɛ ne̱ bo̱ gya mò̱ se̱‑ɔ fe̱yɛ, “Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ mo̱ŋ tɛɛ ŋu se̱sɛ ne̱ ɔ kɔɔre̱ mo̱ a o gyi mfaanɛɛ‑ɔ. Ane̱ Isireelii awuye‑ro gbaa, mo̱ŋ tɛɛ ŋu ɔko̱ ane̱ŋ. Ne̱ ɔnyare̱ mɔ mo̱ŋ gye̱ Isireeliinyi. ");
INSERT INTO ncuNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ ase̱sɛ bwe̱e̱tɔ e̱ le̱e̱ swe̱e̱re̱ ke̱be̱gya ke̱maa se̱, na bamo̱ aa ane̱ nana‑ana Abraham na Isak na Yakubu kye̱na a bo̱ gyi ateese mfe̱ŋ ne̱ Wuribware̱ i gyi kuwure‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Amaa bamo̱ ne̱ weetee Wuribware̱ a kyɔ nyiŋŋi bamo̱ fe̱yɛ bo̱ ba a bo̱ gyi ateese‑o fe̱raa (ane̱ Isireelii awuye ne̱ mo̱ e̱ kaapo̱‑ɔ), ɔ gya bamo̱ a ɔ le̱e̱ mò̱ ase̱ bo̱ kyo̱ŋwe̱ kibugyii‑ro. Mfe̱ŋ‑ɔ ba su, na ba duŋ nnɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ne̱ Yeesuu a tɔwe̱ gywii soogyaa amo̱ fe̱yɛ, “Nare̱ pe̱, na ke̱tɔ ne̱ fo̱ a kɔɔre̱ gyi‑o e̱ waa a ke̱ sa fo̱.” Saŋ ko̱ŋko̱ amo̱‑rɔ dɛɛ ne̱ soogyaa amo̱ a ke̱yaafɔre̱‑ɔ a kpaare̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ne̱ Yeesuu a lwee Peetroo a lɔŋ‑ɔ‑rɔ ya to̱ fe̱yɛ Peetroo mò̱ saa kye̱e̱sɛ e̱ lɔ fekyu ɔ da. ");
INSERT INTO ncuNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ne̱ Yeesuu a dabo̱rɔ ɔkye̱e̱‑ɔ ke̱sare̱e̱. Mfe̱ŋ ne̱ fekyu‑o a yɔwe̱ mò̱, ne̱ ɔɔ ko̱so̱ puri amo̱‑rɔ waa ateese sa Yeesuu. ");
INSERT INTO ncuNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Saŋ ne̱ kyɔwe̱ a twɛɛ‑ɔ, ne̱ ase̱sɛ a baa bamo̱ anyipo̱ ne̱ ibrisi te bamo̱ se̱‑ɔ Yeesuu ase̱. Ne̱ ɔɔ sa ibrisi‑o kanɔ, ne̱ e̱ ya ko̱so̱ bamo̱ se̱. Ne̱ ɔɔ kya alɔpo̱ pɛɛɛ ne̱ baa baa bamo̱ mò̱ ase̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Amo̱se̱‑ɔ ke̱tɔ ne̱ Yeesuu a waa‑ɔ a sa ne̱ ke̱tɔ ne̱ Wuribware̱ kyaamɛɛ Isaya a kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ nya waa kase̱ŋtiŋ fe̱yɛ, “Kase̱ŋtiŋ si, mò̱ ya kɔɔre̱ ane̱ kaye̱e̱gya bo̱ waa mò̱ lee, ne̱ ɔɔ kya ane̱ alɔgyi.” ");
INSERT INTO ncuNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ne̱ ase̱sɛ bwe̱e̱tɔ e̱ ba bo̱ kpɔwe̱ buŋ Yeesuu si saŋ ke̱maa. Ane̱ŋ se̱‑ɔ, ne̱ ɔɔ tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ bo̱ waa ko̱re̱e̱ siraa na mò̱ aa bamo̱ nya te̱ŋ ke̱pare̱ dabe̱‑ɔ‑rɔ yɔ nno̱ŋ a bo̱ŋbe̱‑ɔ se̱, na bo̱ nya kyure kafwe̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Saŋ ne̱ ba yɔ‑ɔ, ne̱ Wuribware̱ mbraa ɔkaapo̱po̱ ko̱ a te̱ŋ bamo̱ kpa ya tɔwe̱ gywii Yeesuu fe̱yɛ, “Ɔkaapo̱po̱, to̱ŋ ke̱maa ne̱ fo̱ e̱ yɔ‑ɔ, mo̱ e̱ gya fo̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Sabraŋ‑nɔ igyono de idikpa, ne̱ mbo̱gyii de asaa bo̱ da‑rɔ. Amaa mo̱, dimaadi mò̱ gyi‑o, fe̱raa mo̱ŋ de mfe̱ŋ ne̱ mo̱ i di a n kyure‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ne̱ ɔko̱ ne̱ o tii bamo̱ ne̱ bo̱ gya Yeesuu si bo̱ naa to̱ŋ ke̱maa ne̱ ɔ yɔ‑ɔ a bo̱ ko̱re̱ mò̱ fe̱yɛ, “Mo̱ nyaŋpe̱, sa a ŋ kiŋŋi yɔ pe̱ na ŋ ya pure n se̱ pwɛɛ na n dɛɛ be̱e̱ bo̱ gya fo̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ne̱ Yeesuu a be̱ŋŋaa mò̱ fe̱yɛ, “Bamo̱ ne̱ bo̱ mo̱ŋ te kakye̱na po̱pwɛɛ‑rɔ‑ɔ, bamo̱ e̱ gye̱ ne̱ bo̱ pure bamo̱ ako̱we̱bɛɛ ne̱ ba ba a bo̱ bo̱ wu‑o. Na fo̱ fe̱raa fo̱ gya mo̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ a lwee ko̱re̱e̱‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bamo̱ a me̱raa se̱ ba yɔ‑ɔ, bo̱ bo̱ sa se̱‑ɔ, afwii dabe̱ ko̱ a kya nkyu si mfe̱ŋ, ne̱ alaŋkpare̱ a da nkyu bo̱ waa bamo̱ ko̱re̱e̱‑ɔ‑rɔ. Ade̱maŋte̱ mɔ ne̱ a su‑o pɛɛɛ na Yeesuu da ko̱re̱e̱‑ɔ‑rɔ o di idi. ");
INSERT INTO ncuNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ne̱ mò̱ agyase̱po̱‑ɔ a yɔ mò̱ ase̱ ya kyiŋŋi mò̱ tɔwe̱ fe̱yɛ, “Ane̱ nyaŋpe̱, ane̱ e̱ kpa a ane̱ wu. Mo̱rɔwe̱ ane̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ne̱ Yeesuu a be̱ŋŋaa fe̱yɛ, “Nte̱tɔ se̱ ne̱ mo̱ne̱ maa kɔɔre̱ mo̱ mo̱ne̱ i gyi‑o ne̱e̱? Ntɔ se̱ ne̱ kufu de mo̱ne̱?” Ne̱ Yeesuu a ko̱so̱ sa kanɔ fe̱yɛ afwii‑o na alaŋkpare̱‑ɔ yɔwe̱, ne̱ ke̱tɔ a waa surumm. ");
INSERT INTO ncuNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ne̱ e̱ye̱e̱ a kpe̱ŋ mò̱ agyase̱po̱‑ɔ, ne̱ ŋkee ba ŋwiini ba gywii abɛɛ ɛ, “Nte̱tɔ se̱sɛ e̱ gye̱ ɔnyare̱ mɔ? Ne̱ mò̱ ya sa kanɔ, ne̱ afwii na alaŋkpare̱ gya kamo̱ se̱‑ɔ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Amo̱ kamɛɛ‑rɔ ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ a kya se̱ pare̱ bamo̱ ko̱re̱e̱‑ɔ bo̱ te̱ŋ‑nɔ ya bo̱ daŋ Galile̱ya ke̱pare̱ dabe̱ a nno̱ŋ a bo̱ŋbe̱‑ɔ. Gadara ifuri si ne̱ baa fo̱‑ɔ. Bamo̱ a fo̱ mfe̱ŋ‑ɔ, ne̱ anyare̱ anyɔ ko̱ a le̱e̱ mfe̱ŋ ne̱ ba pure ase̱sɛ‑ɔ bo̱ gyaŋŋaa bamo̱. Bo̱ du ne̱e̱ fe̱yɛ mbo̱ kpe̱ŋsɛ‑ɔ, a le̱e̱ fe̱yɛ ibrisi te bamo̱ se̱. Amo̱se̱‑ɔ ɔko̱ maa taare̱ a ɔ bo̱rɔ kpa amo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ne̱ baa faa Yeesuu si fe̱yɛ, “Wuribware̱ mò̱ gyi‑o, nte̱tɔ ne̱ fo̱ e̱ kpa ane̱ ase̱? Fo̱ a ba ne̱e̱ a fo̱ bo̱ gyiiri ane̱ ke̱se̱bɔ, na ke̱se̱bɔgyiiri saŋ mo̱ŋ tɛɛ fo̱ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Amɔ aprako biribiri ko̱ mɔ ye̱re̱ kabe̱e̱gyi ko̱ se̱ me̱raa mfe̱ŋ ba gyi. ");
INSERT INTO ncuNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ne̱ ibrisi amo̱ a ko̱re̱ Yeesuu fe̱yɛ, “To, amo̱ e̱ gye̱ fe̱yɛ fo̱ e̱ kaa a fo̱ gya ane̱ le̱e̱ ase̱sɛ mɔ se̱, amo̱ fe̱raa sa a ane̱ ya kye̱na aprako mɔ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ne̱ ɔ yɛ, “Kpa da fe̱yɛ mo̱nꞌ ya kye̱na bamo̱ se̱.” Amo̱se̱‑ɔ ne̱ baa ko̱so̱ le̱e̱ anyare̱‑ɔ se̱ ya kye̱na aprako amo̱ se̱. Ne̱ aprako amo̱ pɛɛɛ a ŋwɛɛnaŋ kpo̱ro̱we̱ kabe̱e̱gyi‑o‑ro ya le̱e̱ da nkyu‑ro wu wu. ");
INSERT INTO ncuNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mfe̱ŋ ne̱ bamo̱ ne̱ ba de̱e̱re̱ aprako amo̱ se̱‑ɔ a ŋwɛɛnaŋ yɔ maŋ‑nɔ ya da ke̱tɔ ne̱ kaa waa anyare̱ amo̱‑ɔ kiboŋboŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mfe̱ŋ ne̱ ɔke̱maa ne̱ o te maŋ‑ɔ‑rɔ‑ɔ a le̱e̱ ya gyaŋŋaa Yeesuu. Bamo̱ a ŋu mò̱‑ɔ, ne̱ baa ko̱re̱ mò̱ fe̱yɛ ɔ le̱e̱ bamo̱ ifuri si kiŋŋi yɔ mfe̱ŋ ne̱ ɔɔ le̱e̱ ba‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ a lwee ko̱re̱e̱‑ɔ‑rɔ kiŋŋi te̱ŋ ke̱pare̱ dabe̱‑ɔ‑rɔ yɔ nno̱ŋ a bo̱ŋbe̱‑ɔ se̱ yɔ mò̱ fɔŋfɔŋ aye̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ne̱ ase̱sɛ ko̱ a baa ke̱gyabɔɔ ko̱ na ɔ da kraŋ se̱ ɔ maa taare̱ a ɔ dabo̱rɔ e̱ye̱e̱ Yeesuu ase̱. Ane̱ŋ ne̱ baa pee akatɔ baa ke̱gyabɔɔ‑ɔ se̱‑ɔ, Yeesuu a ŋu fe̱yɛ baa kɔɔre̱ mò̱ gyi bwe̱e̱tɔ. Amo̱se̱‑ɔ ne̱ ɔɔ tɔwe̱ gywii ke̱gyabɔɔ‑ɔ fe̱yɛ, “Sa a fo̱ akatɔ gyi, mo̱ nyare̱. Mo̱ a taa fo̱ e̱bɔye̱‑ɔ bo̱ ke fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Wuribware̱ mbraa akaapo̱po̱ ne̱ ba nu Yeesuu ase̱ŋ‑ɔ a nu ane̱ŋ ne̱ Yeesuu a tɔwe̱‑ɔ ne̱ ba ŋwiini ba gywii abɛɛ fe̱yɛ, “Ɔnyare̱ mɔ a tɔwe̱ abuse̱ŋse̱ŋ. E̱me̱ne̱ se̱ ne̱ ɔ sa se̱ŋsa ane̱ŋ fe̱yɛ mò̱ a gye̱ Wuribware̱‑ɔ?” ");
INSERT INTO ncuNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Amo̱ fe̱raa, Yeesuu a kyɔ ŋu mbraa akaapo̱po̱ amo̱ mfɛɛre̱, ne̱ oo bise bamo̱ fe̱yɛ, “E̱me̱ne̱ se̱ ne̱ mo̱ne̱ e̱ fa mfɛɛre̱ bɔye̱ mɔ? ");
INSERT INTO ncuNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ke̱mo̱‑ɔ ke̱mo̱ e̱ bo̱ tɔwe̱ lɔ, fe̱yɛ mo̱ a tɔwe̱ fe̱yɛ, ‘Mo̱ a taa fo̱ e̱bɔye̱ bo̱ ke fo̱’, bɛɛɛ ‘Ko̱so̱ nare̱’? ");
INSERT INTO ncuNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","To, mo̱ e̱ kaapo̱ mo̱ne̱ fe̱yɛ mo̱, dimaadi mò̱ gyi‑o, de ke̱yaale̱ŋ kaye̱ mɔ‑rɔ, na n taare̱ taa ɔke̱maa e̱bɔye̱ bo̱ ke mò̱.” Ne̱ ɔɔ tɔwe̱ gywii ke̱gyabɔɔ‑ɔ fe̱yɛ, “Ke̱e̱ ɛ, ko̱so̱, taa fo̱ kraŋ a fo̱ nare̱ pe̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mfe̱ŋ ne̱ ke̱gyabɔɔ‑ɔ a ko̱so̱ taa mò̱ kraŋ nare̱ mò̱ ayaa se̱ o yii pe̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Lamaŋ ne̱ bo̱ ye̱re̱ mfe̱ŋ‑ɔ a ŋu amo̱‑ɔ, ne̱ kufu a nya bamo̱, ne̱ baa kyo̱rɔ Wuribware̱ fe̱yɛ mò̱ a sa se̱sɛ dimaadi ane̱ŋ a ke̱yaale̱ŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Amo̱ kamɛɛ‑rɔ, ne̱ Yeesuu a le̱e̱ ya ŋu leŋpoo ɔkɔɔre̱po̱ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Matiyo‑o (ne̱ bo̱ be̱e̱ ba te̱e̱ mò̱ ɛ Lewii‑o) na o te mò̱ leŋpoo kɔɔre̱kpa. Ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Ko̱so̱, gya mo̱ se̱.” Mfe̱ŋ ne̱ Matiyo a ko̱so̱ gya Yeesuu si. ");
INSERT INTO ncuNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ne̱ Matiyo a ya waa ateese mò̱ aye̱ sa Yeesuu a o gyi. Leŋpoo akɔɔre̱po̱ bwe̱e̱tɔ na ase̱sɛ ne̱ Farisii awuye e̱ te̱e̱ bamo̱ ɛ e̱bɔye̱ awaapo̱‑ɔ a bo̱ gyi mò̱ aa mò̱ agyase̱po̱‑ɔ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farisii awuye ko̱ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ a ŋu ane̱ŋ a ase̱sɛ amo̱ na ba gyi mfe̱ŋ‑ɔ, ne̱ baa bise Yeesuu agyase̱po̱‑ɔ fe̱yɛ, “Nte̱tɔ se̱ ne̱ mo̱ne̱ ɔkaapo̱po̱ na leŋpoo akɔɔre̱po̱ na e̱bɔye̱ awaapo̱ i gyi abɛɛ ase̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yeesuu a nu ase̱ŋ ne̱ baa bise‑o, ne̱ ɔ yɛ, “Ɔko̱ ne̱ ɔ lɔ‑ɔ ne̱ ba sa kadwii. N gye̱ ɔko̱ ne̱ ɔ bo̱ alaŋfiya‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mo̱ne̱ fe̱raa, mo̱nꞌ be̱e̱ yɔ ya kare̱ ane̱ŋ ne̱ baa kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ, na mo̱nꞌ nu amo̱ kaase̱. Baa kyo̱rɛɛ mfe̱ŋ ne̱e̱ fe̱yɛ, ‘Wuribware̱ yɛ, N gye̱ mbo̱ ne̱ mo̱ e̱ kpa a mo̱nꞌ mɔɔ sa mo̱. Amaa ke̱dame̱naŋsɛ ne̱ mo̱ e̱ kpa a mo̱nꞌ waa mo̱ne̱ bɛɛko̱‑ana.’ M fe̱raa n gye̱ bamo̱ ne̱ bo̱ mo̱ŋ gye̱ e̱bɔye̱ awaapo̱‑ɔ se̱ ne̱ mo̱ a ba, amaa bamo̱ ne̱ bo̱ gye̱ e̱bɔye̱ awaapo̱‑ɔ se̱ ne̱ mo̱ a ba, na m bo̱ tɔwe̱ gywii bamo̱ fe̱yɛ bo̱ nu bamo̱ e̱ye̱e̱ kiŋŋi le̱e̱ bamo̱ e̱bɔye̱‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ne̱ Yohanee Osuubɔpo̱ a agyase̱po̱‑ɔ bo̱ko̱ a ba Yeesuu ase̱ bo̱ bise mò̱ fe̱yɛ, “Ntɔ se̱ ne̱ ane̱ aa Farisii awuye e̱ kra ako̱ŋ, ne̱ fo̱ fe̱raa fo̱ agyase̱po̱‑ɔ mɔ maa kra ako̱ŋ?” ");
INSERT INTO ncuNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “Mo̱ne̱ e̱ fa fe̱yɛ saŋ ne̱ ɔko̱ e̱ kpa a ɔ waare̱e̱‑ɔ, ɔko̱fɔ mò̱ kuri mò̱ nyare̱‑ana e̱ kye̱na ako̱ŋ na ɔ bo̱‑rɔ aaa? Mo̱ŋ kɔɔre̱ gyi. N du fe̱yɛ ɔko̱fɔ mò̱ kuri‑o ne̱ mo̱ agyase̱po̱‑ɔ mɔ du ne̱e̱ fe̱yɛ ɔko̱fɔ mò̱ kuri mò̱ nyare̱‑ana‑ɔ. Ŋke ŋko̱ e̱ ba ne̱ ba lee mo̱ a bo̱ le̱e̱ bamo̱ ase̱, na ŋkee bo̱ kra ako̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ne̱ Yeesuu a be̱e̱ tɔwe̱ ke̱kpare̱ mɔ gywii bamo̱ fe̱yɛ, “Ane̱ŋ dɛɛ ne̱ ɔko̱ maa kyaŋ waagya po̱pwɛɛ na ɔ bo̱ taa waagya de̱daa‑rɔ. A le̱e̱ fe̱yɛ ke̱tɔ maa kyee, na o ŋu fe̱yɛ mfe̱ŋ ne̱ ɔɔ taa‑rɔ‑ɔ e̱kɛɛkɛɛ‑ɔ se̱ i wu, na a tuwi‑ro lee waagya po̱pwɛɛ‑ɔ, na a be̱e̱ waa bɔ dabe̱ na ɔ kyɔ ɔgye̱ŋkpɛɛsɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ane̱ŋ dɛɛ ne̱ mo̱ne̱ nyi fe̱yɛ bo̱ de nta ba waa praŋto̱wa ne̱ baa ba kabo̱ wo̱re̱ bo̱ waa‑ɔ‑rɔ. Nta po̱pwɛɛ ya lwee praŋto̱wa de̱daa‑rɔ, nta‑ɔ i fwii na praŋto̱wa‑ɔ bwee nye̱ra, na nta‑ɔ twiiri we̱e̱. Amo̱se̱‑ɔ bo̱ de nta po̱pwɛɛ ba waa praŋto̱wa po̱pwɛɛ‑rɔ, na nta‑ɔ na praŋto̱wa‑ɔ mpe̱pe̱yɔ nya waa dame̱naŋsɛ. Amo̱se̱‑ɔ mo̱ agyase̱po̱‑ɔ maa kra ako̱ŋ na mo̱ aa bamo̱ naa.” ");
INSERT INTO ncuNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Saŋ ne̱ Yeesuu maa se̱ ɔ tɔwe̱ amo̱‑ɔ o gywii bamo̱‑ɔ, ne̱ ke̱bware̱ko̱re̱kyaŋ abre̱sɛ‑ɔ ɔko̱ a ba Yeesuu ase̱ mfe̱ŋ bo̱ kpuni aŋurii mò̱ ayaa‑rɔ. Ne̱ ɔ yɛ, “Mo̱ gyi kye̱e̱sɛ e̱ lɔ, hare̱e̱ ɔ kpa a ɔ wu. Amo̱se̱‑ɔ mo̱ e̱ ko̱re̱ fo̱ ne̱e̱ fe̱yɛ fo̱ bo̱ ba fo̱ asare̱e̱ bo̱ dɔŋŋɔ mò̱ se̱ a ɔ nya ŋkpa.” ");
INSERT INTO ncuNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ne̱ Yeesuu a ko̱so̱, ne̱ mò̱ aa ɔnyare̱‑ɔ na Yeesuu agyase̱po̱‑ɔ a le̱e̱ ba yɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Bamo̱ a maa se̱ ba yɔ‑ɔ, ne̱ ɔkye̱e̱ ko̱ a gya Yeesuu si. Ɔkye̱e̱ mɔ e̱ lɔ ke̱kye̱e̱tɔ, a le̱e̱ fe̱yɛ kiferi ke̱maa‑rɔ ɔ taare̱ bwiino waa iluwi kanɔ ŋko̱. Waa nsu kudu ŋnyɔ ne̱e̱ fe̱yɛ mò̱ a lɔ ane̱ŋ a ko̱lɔ‑ɔ. Ne̱ ŋkee ɔ fa fe̱yɛ, “Mo̱ ya dabo̱rɔ mò̱ atɔ buŋsɛ gbaa, mo̱ e̱ kpaare̱.” Ne̱ ɔɔ yɔ Yeesuu kamɛɛ ya dabo̱rɔ mò̱ waagya kanɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Mò̱ a de̱ŋ dabo̱rɔ Yeesuu a waagya‑ɔ, ne̱ ɔɔ kpaare̱. Ne̱ Yeesuu a buruwaa ŋu mò̱ mfe̱ŋ. Ne̱ ɔ yɛ, “Ɔpe̱kye̱e̱, sa a fo̱ akatɔ gyi. Bo̱ le̱e̱ ane̱ŋ ne̱ fo̱ a kɔɔre̱ mo̱ gyi‑o si‑o, fo̱ a kpaare̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ne̱ ŋkee Yeesuu a lwee ke̱bware̱ko̱re̱kyaŋ ɔbre̱sɛ amo̱ a lɔŋ‑ɔ‑rɔ. Ne̱ oo ŋu ba waa kakye̱e̱sɛɛ‑ɔ kale. Bo̱ko̱ e̱ fo̱re̱ mbe̱re̱, na bamo̱ bwe̱e̱tɔ mɔ i su keŋkeŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱nꞌ le̱e̱ mfe̱ŋ. Kakye̱e̱sɛɛ‑ɔ mo̱ŋ wu, o di idi ne̱e̱.” Mò̱ a tɔwe̱ ane̱ŋ‑ɔ, ne̱ baa mɔse̱ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mò̱ a sa ne̱ ase̱sɛ‑ɔ pɛɛɛ a le̱e̱ lɔŋ‑ɔ‑rɔ‑ɔ, ne̱ oo lweero. Ne̱ ɔɔ ya kra kakye̱e̱sɛɛ‑ɔ ke̱sare̱e̱‑rɔ, ne̱ kakye̱e̱sɛɛ‑ɔ a ko̱so̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ne̱ ase̱ŋ amo̱ pɛɛɛ a saŋŋe̱‑rɔ lwee ifuri amo̱ se̱ a e̱maŋ‑ɔ pɛɛɛ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yeesuu a le̱e̱ mfe̱ŋ ɔ naa ɔ yɔ‑ɔ, ne̱ ate̱napo̱ anyɔ ko̱ a le̱e̱ bo̱ gya mò̱ se̱, na ba te̱e̱ ba kyo̱ŋwe̱ mò̱ fe̱yɛ, “Deefid mò̱ nana, ŋu ane̱ e̱wɛɛ, na fo̱ kya ane̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ne̱ Yeesuu a lwee lɔŋ ko̱‑rɔ. Ne̱ ate̱napo̱ amo̱ a yɔ ya ŋu mò̱ mfe̱ŋ. Ne̱ oo bise bamo̱ fe̱yɛ, “Mo̱ne̱ e̱ kɔɔre̱ mo̱ne̱ i gyi fe̱yɛ mo̱ e̱ taare̱ a n kya mo̱ne̱ aaa?” Ne̱ baa be̱ŋŋaa fe̱yɛ, “Ɔɔŋ, ane̱ nyaŋpe̱, fo̱ e̱ taare̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Amo̱se̱‑ɔ ne̱ ɔɔ dabo̱rɔ bamo̱ akatɔ tɔwe̱ fe̱yɛ, “Ke̱tɔ ne̱ mo̱ne̱ a kɔɔre̱ gyi‑o e̱ waa a ke̱ sa mo̱ne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mfe̱ŋ ne̱ bamo̱ akatɔ a buŋŋi. Ne̱ Yeesuu a yii bamo̱ se̱ fe̱yɛ bo̱ ma kaŋ boŋboŋ mò̱ ke̱nyare̱ to̱ŋ ko̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Amaa bamo̱ a le̱e̱ mfe̱ŋ‑ɔ, ne̱ baa yaa Yeesuu ke̱nyare̱ timaa ifuri amo̱ a ke̱be̱gya‑ɔ pɛɛɛ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ate̱napo̱ ne̱ Yeesuu a kya‑ɔ a le̱e̱ mfe̱ŋ ba yɔ‑ɔ, ne̱ ase̱sɛ ko̱ a taa ɔnyare̱ ko̱ baa mò̱ ase̱. Ibrisi a te ɔnyare̱‑ɔ se̱‑ɔ se̱‑ɔ, ɔ maa taare̱ a ɔ sa se̱ŋsa. ");
INSERT INTO ncuNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yeesuu a de̱ŋ gya ibrisi‑o ko̱so̱ kamunyare̱ amo̱ se̱‑ɔ, ne̱ kamu‑o a le̱e̱ ɔ sa se̱ŋsa. Ne̱ e̱ye̱e̱ a kpe̱ŋ lamaŋ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ, ne̱ bo̱ yɛ, “Ane̱ mo̱ŋ tɛɛ ŋu ane̱ŋ a akpe̱ŋe̱ye̱e̱tɔ mɔ ane̱ Isireelii swe̱e̱re̱ mɔ se̱ mfe̱e̱, amɔ ndɔɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Amaa Farisii awuye ko̱ yɛ, “Ɔbɔnsam ne̱ o de ibrisi ke̱yaale̱ŋ‑ɔ ya sa Yeesuu e̱le̱ŋ mɔ ne̱ o de ɔ gya ibrisi ɔ ko̱so̱ ase̱sɛ se̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ne̱ ŋkee Yeesuu a muruwi ifuri amo̱ mfe̱ŋ a e̱maŋ na mmaŋgyii‑o‑ro pɛɛɛ se̱, ɔ naa ɔ kaapo̱ abware̱se̱ŋ mfe̱ŋ a ke̱bware̱ko̱re̱ akyaŋ‑ɔ‑rɔ ɔ tɔwe̱ ase̱ŋ timaa bo̱ le̱e̱ Wuribware̱ se̱ a kuwure‑o si, na ɔ kya ase̱sɛ ko̱lɔgyi ke̱maa. ");
INSERT INTO ncuNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mò̱ a ŋu ase̱sɛ de̱maŋte̱ ne̱ ba ba mò̱ ase̱ saŋ ke̱maa‑ɔ, ne̱ bamo̱ ase̱ŋ a waa mò̱ e̱wɛɛ, a le̱e̱ fe̱yɛ bo̱ du ne̱e̱ fe̱yɛ e̱sanne̱ ne̱ bo̱ mo̱ŋ de ɔde̱e̱re̱se̱po̱‑ɔ. Bo̱ naa ba laye̱ ba lɔ ne̱e̱, ne̱ bo̱ mo̱ŋ lɛɛ bo̱ de ke̱yaale̱ŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ne̱ Yeesuu a da ke̱kpare̱ mɔ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Mo̱ne̱ a ŋu ase̱sɛ de̱maŋte̱ mɔ aaa? Bo̱ du fe̱yɛ yaabraa‑ɔ. Yaabraa‑ɔ kyɔ bwe̱e̱tɔ, amaa mo̱ne̱ ne̱ mo̱ne̱ gye̱ ate̱ŋŋe̱po̱‑ɔ mɔ mo̱ŋ kyɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Amo̱se̱‑ɔ mo̱nꞌ ko̱re̱ ko̱dɔɔ wuye ne̱ ɔ bo̱ so̱so̱‑ɔ na ɔ kyo̱ŋwe̱ mo̱ne̱ ate̱ŋŋe̱po̱ bwe̱e̱tɔ, na mo̱ne̱ aa bamo̱ te̱ŋŋe̱ yaabraa mɔ kpɔwe̱ baa mò̱ lɔŋ‑nɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ne̱ Yeesuu a te̱e̱ mò̱ agyase̱po̱ kudu anyɔ‑ɔ bo̱ gyaŋŋe̱, ne̱ ɔɔ sa bamo̱ ke̱yaale̱ŋ fe̱yɛ bo̱ bo̱ gya ibrisi bo̱ ko̱so̱ ase̱sɛ se̱, na bo̱ kya ase̱sɛ ko̱lɔgyi ke̱maa ne̱ ba lɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ne̱ ɔɔ te̱e̱ bamo̱ fe̱yɛ mò̱ ayaa‑rɔ aye̱re̱po̱. Bamo̱‑rɔ, mò̱ ne̱ ɔ gye̱ ŋkpɛɛ‑ɔ ke̱nyare̱ e̱ gye̱ Simɔŋ. (Ɔɔ be̱e̱ sa mò̱ ke̱ŋasɛnyare̱ fe̱yɛ Peetroo.) Bamo̱ ne̱ bo̱ gya se̱‑ɔ anyare̱ e̱ gye̱ Simɔŋ mò̱ tire Andruu, na Sibidii mò̱ gyi‑ana Yakubu na Yohanee, ");
INSERT INTO ncuNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","na Filipo na Bar‑Tolomiyu na Tomas na Matiyo leŋpoo ɔkɔɔre̱po̱‑ɔ, na Alafiyus mò̱ gyi Yakubu, na Tadiyus, ");
INSERT INTO ncuNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","na Simɔŋ ne̱ ba te̱e̱ mò̱ ɛ Kanane̱e̱‑ɔ, na ŋkee Yudas Kariyotinyi ne̱ ɔ ba a ɔ bo̱ gyi Yeesuu kidiburo‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ne̱ Yeesuu a suŋ mò̱ agyase̱po̱ kudu anyɔ ne̱ oo lee bamo̱‑ɔ bo̱ kyo̱ŋwe̱ e̱maŋ se̱ fe̱yɛ bo̱ nare̱ tɔwe̱ abware̱se̱ŋ. Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ne̱ ma kaŋ bo̱rɔ kpa ke̱maa ne̱ ɔ yɔ bamo̱ ne̱ bo̱ maa suŋ Wuribware̱‑ɔ swe̱e̱re̱‑ɔ se̱. Mo̱ne̱ ma kaŋ be̱e̱ lwee Samariya awuye maŋ ke̱maa‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Amaa mo̱nꞌ yɔ ane̱ Isireelii awuye‑o ase̱, a le̱e̱ fe̱yɛ bo̱ du ne̱e̱ fe̱yɛ e̱sanne̱ ne̱ baa fo̱ e̱fa‑rɔ‑ɔ. Bamo̱ aa Wuribware̱ ase̱ bo̱ e̱fɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mo̱ne̱ a yɔ‑ɔ, na mo̱nꞌ tɔwe̱ gywii bamo̱ fe̱yɛ Wuribware̱ se̱ a kuwure‑o a tɔ‑rɔ e̱ba. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mo̱nꞌ kya alɔpo̱, na mo̱nꞌ kyiŋŋi alowipo̱ bo̱ le̱e̱ lowi‑ro, na mo̱nꞌ kya abwatɔpo̱ na bo̱ nya be̱e̱ lwee ase̱sɛ‑rɔ, na mo̱nꞌ gya ibrisi bo̱ ko̱so̱ ase̱sɛ se̱. Mo̱ne̱ a nya ke̱yaale̱ŋ mɔ pɛɛɛ, na mo̱ne̱ mo̱ŋ ka sɛye̱, amo̱se̱‑ɔ mo̱nꞌ kya ase̱sɛ‑rɔ, na mo̱ne̱ ma kɔɔre̱ atanne̱ bamo̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mo̱ne̱ ma kaŋ taa atanne̱ pipee bɛɛɛ afufuri bɛɛɛ kɔɔbɔɔ gbaa bo̱ waa mo̱ne̱ igyife‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mo̱ne̱ a yɔ‑ɔ, mo̱ne̱ ɔko̱ ma taa ko̱re̱e̱ na atɔ bo̱ tii mò̱ kaare̱ ne̱ oo buŋ‑o na ase̱be̱ta ne̱ ɔɔ naa se̱‑ɔ na kayii nare̱se̱sɛ ne̱ o de‑o si. A le̱e̱ fe̱yɛ bamo̱ ne̱ ba suŋ kusuŋ ba sa Wuribware̱‑ɔ e̱ nya bamo̱ ateese gyisɛ a bo̱ le̱e̱ kusuŋ amo̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Mo̱ne̱ ya yɔ maŋ ko̱ se̱ bɛɛɛ kamaŋgyii ko̱ se̱, mo̱nꞌ lweero na mo̱nꞌ buwi kpa ɔko̱ ne̱ o sure a mo̱nꞌ so̱we̱ mò̱ lɔŋ‑nɔ‑ɔ. Na mo̱nꞌ kye̱na mfe̱ŋ bo̱ fo̱ ŋke nsi ne̱ mo̱ne̱ e̱ le̱e̱ maŋ amo̱‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pwɛɛ ne̱ mo̱ne̱ i lwee lɔŋ ke̱maa‑rɔ, mo̱nꞌ gye̱ ŋkpɛɛ ka kanɔ, na mo̱nꞌ tɔwe̱ fe̱yɛ, ‘Wuribware̱ yure lɔŋ mɔ‑rɔ ase̱sɛ!’ ");
INSERT INTO ncuNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ne̱ ase̱sɛ timaa e̱ bo̱ lɔŋ‑ɔ‑rɔ, ne̱ bamo̱ ya kɔɔre̱ mo̱ne̱ kanɔka fe̱raa, Wuribware̱ i yure lɔŋ amo̱ ase̱sɛ. Mfe̱ŋ ne̱ bamo̱ e̱ mo̱ŋ kɔɔre̱ mo̱ne̱ kanɔka‑ɔ fe̱raa, Wuribware̱ maa yure lɔŋ amo̱‑rɔ ase̱sɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Lɔŋ‑nɔ awuye bɛɛɛ maŋ awuye e̱ mo̱ŋ kra mo̱ne̱ nɛɛnɛɛ, ne̱ bamo̱ e̱ mo̱ŋ nu mo̱ne̱ ase̱ŋ, amo̱ fe̱raa, mo̱ne̱ e̱ le̱e̱ mfe̱ŋ, bamo̱ maŋ‑nɔ e̱se̱ ne̱ e̱ ya sii mo̱ne̱ ase̱be̱ta kaase̱‑ɔ gbaa, mo̱nꞌ kpo̱ŋkpaŋ e̱mo̱ bo̱ sii bamo̱ aye̱ bo̱ yii bamo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ kake nsi ne̱ Wuribware̱ e̱ ba a ɔ bo̱ gyi kaye̱‑rɔ ase̱sɛ pɛɛɛ ase̱ŋ‑ɔ, o gyiiri maŋ amo̱ ase̱sɛ ke̱se̱bɔ a ɔ kyo̱ŋ ane̱ŋ ne̱ o gyiiri Sɔdɔm na Gomora awuye ke̱se̱bɔ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ne̱ Yeesuu a kya se̱ tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Mo̱nꞌ laatɔ a mo̱nꞌ nu mo̱ ase̱! Mo̱ i suŋ mo̱ne̱ mo̱ e̱ kyo̱ŋwe̱ ne̱e̱ fe̱yɛ nsanne̱gyii ne̱ ba ya lwee ngyaŋkɔre̱sɛ‑rɔ‑ɔ. Amo̱se̱ se̱‑ɔ, mo̱nꞌ buŋŋi mo̱ne̱ akatɔ fe̱yɛ awɔ, na mo̱nꞌ yuri mo̱ne̱ e̱ye̱e̱ fe̱yɛ awurele̱pɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mo̱nꞌ sa mo̱ne̱ e̱ye̱e̱ se̱, bo̱ le̱e̱ fe̱yɛ ase̱sɛ ko̱ bo̱‑rɔ ne̱ ba kra mo̱ne̱ a bo̱ yaa Yudaa awuye maŋ abre̱sɛ akatɔ‑rɔ, na bo̱ be̱e̱ daye̱ mo̱ne̱ ane̱ ke̱bware̱ko̱re̱ akyaŋ abre̱sɛ akatɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Na bo̱ be̱e̱ kperi ane̱ŋ ne̱ mo̱ne̱ gye̱ mo̱ agyase̱po̱‑ɔ se̱, na bo̱ kra mo̱ne̱ yaa agominaa na awure akatɔ‑rɔ. Na mo̱nꞌ tɔwe̱ abware̱se̱ŋ gywii bamo̱ aa bamo̱ ne̱ baa saŋ ne̱ bo̱ maa suŋ Wuribware̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Saŋ ne̱ ba kra mo̱ne̱ a bo̱ yaa ane̱ŋ a e̱se̱ŋgyikpa‑ɔ, mo̱ne̱ ma kaŋ sa a ase̱ŋ ne̱ mo̱ne̱ e̱ ya tɔwe̱ mfe̱ŋ‑ɔ na ane̱ŋ ne̱ mo̱ne̱ e̱ kya kanɔ‑ɔ mfɛɛre̱ tɔɔraa mo̱ne̱. Bo̱ le̱e̱ fe̱yɛ saŋ‑ɔ ya fo̱, mo̱nꞌ tɔwe̱ ke̱tɔ ne̱ ke̱ bo̱ mo̱ne̱ mfɛɛre̱‑rɔ‑ɔ, a le̱e̱ fe̱yɛ ke̱tɔ ne̱ mo̱ne̱ e̱ tɔwe̱ mfe̱ŋ‑ɔ maa le̱e̱ mo̱ne̱ fɔŋfɔŋ ase̱, ke̱ e̱ le̱e̱ mo̱ne̱ se̱ ne̱ ɔ bo̱ so̱so̱‑ɔ a kufwiiŋe‑o ase̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Saŋ amo̱ dɛɛ na se̱sɛ yaa mò̱ daa bɛɛɛ mò̱ tire maŋ ayaale̱ŋpo̱ akatɔ‑rɔ a bo̱ mɔɔ mò̱. Na se̱ mɔ yaa mò̱ gyi maŋ ayaale̱ŋpo̱ akatɔ‑rɔ na bo̱ mɔɔ mò̱. Na ŋyaagyi mɔ ye̱re̱ bo̱ kye bamo̱ ase̱ na anyi yaa bamo̱ maŋ ayaale̱ŋpo̱ akatɔ‑rɔ a bo̱ mɔɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ɔke̱maa i kperi mo̱ se̱, na o kisi mo̱ne̱. Amaa mo̱ e̱ mo̱rɔwe̱ ɔke̱maa ne̱ ɔɔ taare̱ ye̱re̱ keŋkeŋ bo̱ fo̱ ase̱ŋ amo̱ kɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bamo̱ ya waa mo̱ne̱ awo̱re̱fɔɔ maŋ ko̱ se̱, na mo̱nꞌ be̱e̱ se̱re̱ yɔ ɔko̱ se̱. Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ mo̱ne̱ maa lwee ane̱ Isireelii swe̱e̱re̱ se̱ e̱maŋ pɛɛɛ‑rɔ pwɛɛ na mo̱, dimaadi mò̱ gyi‑o, dɛɛ ba. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","N gye̱ mo̱ e̱ gye̱ mo̱ne̱ ɔkaapo̱po̱ aaa? Sukuu kigyi ko̱ mo̱ŋ bo̱‑rɔ na ɔ kyɔ mò̱ ɔkaapo̱po̱, ne̱ ke̱nya ko̱ mo̱ŋ bo̱‑rɔ na ɔ kyɔ mò̱ nyaŋpe̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Amo̱se̱‑ɔ sukuu kigyi ma tɛɛ fe̱yɛ o ŋu ase̱ŋ ane̱ŋ ne̱ mò̱ ɔkaapo̱po̱ i ŋu‑o dɛɛ. Ane̱ŋ dɛɛ ne̱ ke̱nya i ŋu mò̱ nyaŋpe̱ lee‑o. M be̱e̱ taa fe̱yɛ mo̱ a gye̱ lɔŋ wuye‑o. Ba te̱e̱ lɔŋ wuye‑o ɛ Ɔbɔnsam, saŋbo̱to̱ mo̱ne̱ ne̱ mo̱ne̱ gye̱ mo̱ lɔŋ‑nɔ awuye‑o ne̱ bo̱ maa te̱e̱ ane̱ŋ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ne̱ Yeesuu a kya se̱ kaapo̱ mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Amo̱se̱ se̱‑ɔ mo̱ne̱ ma se̱re̱ ase̱sɛ, a le̱e̱ fe̱yɛ ke̱tɔ ke̱maa ne̱ baa buŋ si‑o i buŋŋi si, na ke̱tɔ ke̱maa ne̱ baa taa bo̱ kwe̱e̱rɔ‑ɔ le̱e̱ ifuri. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mo̱ne̱ fe̱raa, ase̱ŋ ke̱maa ne̱ mo̱ a tɔwe̱ keri si gywii mo̱ne̱‑ɔ, mo̱nꞌ ya tɔwe̱ lamaŋ‑nɔ. Ke̱tɔ ke̱maa ne̱ mo̱ a kuri waa mo̱ne̱ e̱se̱bɔ‑rɔ‑ɔ, na mo̱nꞌ ya tɔwe̱ alɔŋde̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ mo̱ne̱ ma kaŋ se̱re̱ bamo̱ ne̱ ba kpa a bo̱ mɔɔ mo̱ne̱‑ɔ, a le̱e̱ fe̱yɛ bamo̱ ya mɔɔ mo̱ne̱, bo̱ maa lɛɛ taare̱ a bo̱ waa mo̱ne̱ sɛye̱. Amaa mo̱nꞌ se̱re̱ Wuribware̱ ne̱ mò̱ ya mɔɔ mo̱ne̱, ne̱ ke̱mo̱ kamɛɛ‑rɔ o de e̱le̱ŋ fe̱yɛ ɔ be̱e̱ kywɛɛ mo̱ne̱ ŋyo̱wɔre̱ na mo̱ne̱ e̱kra de̱e̱kpa ne̱ oo kure bo̱ be̱ya sa e̱bɔye̱ awaapo̱‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","N gye̱ e̱paso̱wa adunyɔ ne̱ bo̱ de ba sɔɔ nte̱ye̱te̱ye̱ ŋnyɔ‑ɔ ɔɔɔ? Amaa mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ kako̱ŋko̱ gbaa maa wu na mo̱ne̱ se̱ Wuribware̱ mo̱ŋ sure. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Mo̱nꞌ nu fe̱yɛ mo̱ne̱ se̱ Wuribware̱ a kare̱ ipwii ne̱ i te mo̱ne̱ aŋu si‑o, ne̱ oo ŋu e̱mo̱ kanɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Amo̱se̱‑ɔ mo̱ne̱ ma sa a kufu nya mo̱ne̱, a le̱e̱ fe̱yɛ nte̱ye̱te̱ye̱ ŋkpe̱ŋ ŋkpe̱ŋ mo̱ŋ fo̱ mo̱ne̱ ɔko̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ne̱ Yeesuu a kya se̱ tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Ɔke̱maa ne̱ ɔ nya kakpo̱nɔ na ɔ tɔwe̱ lamaŋ‑nɔ fe̱yɛ o tii mo̱ se̱‑ɔ, ŋ gbaa mo̱ e̱ waa mò̱ ane̱ŋ dɛɛ Wuribware̱, n se̱ ne̱ ɔ bo̱ so̱so̱‑ɔ, akatɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ne̱ ɔko̱ ne̱ mò̱ ya kine mo̱ lamaŋ‑nɔ‑ɔ, ŋ gbaa mo̱ i kine mò̱ n se̱ Wuribware̱ akatɔ‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ne̱ Yeesuu a kya se̱ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ne̱ nyi fe̱yɛ mo̱ a ba a m bo̱ baa kaye̱e̱yuri kaye̱ mɔ‑rɔ ne̱e̱ e̱e̱e̱? Daabii! Mo̱ a baa kaye̱ be̱be̱re̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Fe̱yɛ ane̱ŋ ne̱ baa kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ, mo̱ a ba a m bo̱ brawe̱ ase̱sɛ‑rɔ na ‘Ɔnyare̱ na mò̱ se̱ mbo̱ŋtɔ‑rɔ e̱ te̱ŋ‑nɔ. Ɔkye̱e̱ na mò̱ nyi e̱ kɔ. Ɔkye̱e̱ na mò̱ saa kye̱e̱sɛ e̱ kɔ. Na se̱sɛ ako̱we̱bɛɛ fɔŋfɔŋ kii mò̱ ado̱ŋ.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ɔke̱maa ne̱ ɔ kpa mò̱ se̱ bɛɛɛ mò̱ nyi ase̱ŋ a ɔ kyo̱ŋ mo̱‑ɔ mo̱ŋ fo̱ fe̱yɛ o kii mo̱ agyase̱po̱‑ɔ ɔko̱. Ɔke̱maa ne̱ ɔ be̱e̱ ɔ kpa mò̱ gyi‑ana ase̱ŋ a ɔ kyo̱ŋ mo̱‑ɔ, ane̱ŋ dɛɛ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ɔke̱maa mɔ ne̱ ɔ maa taare̱ a ɔ so̱rɔ mò̱ fɔŋfɔŋ kiyii kpare̱-abɛɛ‑rɔ gya mo̱ se̱‑ɔ mo̱ŋ fo̱ fe̱yɛ o kii mo̱ agyase̱po̱‑ɔ ɔko̱. Ɔke̱maa ne̱ ɔ gya mo̱ se̱‑ɔ i gyi awo̱re̱fɔɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","A le̱e̱ fe̱yɛ ɔko̱ ne̱ ɔ maa kpa a ɔ yɔwe̱ mò̱ kakye̱na de̱daa‑ɔ maa nya ŋkpa. Amaa ɔko̱ ne̱ o kperi mo̱ se̱ na ɔ yɔwe̱ mò̱ kakye̱na de̱daa‑ɔ e̱ nya ŋkpa.” ");
INSERT INTO ncuNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ne̱ Yeesuu a tɔwe̱ bo̱ gye̱ kɛɛ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Ɔke̱maa ne̱ ɔ kra mo̱ne̱ nɛɛnɛɛ‑ɔ a kra mo̱‑ɔ mo̱ nɛɛnɛɛ ne̱e̱. Ne̱ mò̱ ne̱ ɔɔ kra mo̱ nɛɛnɛɛ‑ɔ mɔ a kra mò̱ ne̱ oo suŋ mo̱ bo̱ kyo̱ŋwe̱‑ɔ dɛɛ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ɔke̱maa ne̱ ɔ kra Wuribware̱ a akyaamɛɛ‑ɔ ɔko̱ fe̱yɛ mò̱ a gye̱ Wuribware̱ a kyaamɛɛ‑ɔ se̱‑ɔ, kakɔka ne̱ ɔ nya‑ɔ na Wuribware̱ a kyaamɛɛ‑ɔ lee‑o ta. Ne̱ ɔke̱maa ne̱ ɔ kra se̱sɛ timaa nɛɛnɛɛ fe̱yɛ mò̱ a gye̱ se̱sɛ timaa‑o si‑o, Wuribware̱ e̱ ka mò̱ ko̱kɔ ko̱ŋko̱ dɛɛ ne̱ ɔ ka se̱sɛ timaa‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ ɔko̱ ne̱ ɔ sa mo̱ agyase̱po̱ mɔ‑rɔ kagyingyii gbaa akyuyuri na o nuu, fe̱yɛ ane̱ŋ ne̱ ɔ gye̱ mo̱ agyase̱po̱‑ɔ se̱‑ɔ, a da fe̱yɛ se̱sɛ amo̱ e̱ nya mò̱ kakɔka.” ");
INSERT INTO ncuNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yeesuu a sa se̱ŋsa gywii mò̱ agyase̱po̱ kudu anyɔ‑ɔ lo̱we̱‑ɔ, ne̱ ɔɔ le̱e̱ mfe̱ŋ yɔ e̱maŋ ne̱ e̱ maa mfe̱ŋ‑ɔ‑rɔ na ɔ ya kaapo̱ bamo̱ atɔ, na ɔ tɔwe̱ abware̱se̱ŋ gywii bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Saŋ amo̱ Yohanee Osuubɔpo̱ da tiikpa. Owure Hɛrɔd ya tii mò̱. Ne̱ baa tɔwe̱ atɔ ne̱ Yeesuu Kristoo a waa‑ɔ pɛɛɛ gywii Yohanee. Mfe̱ŋ ne̱ ɔɔ te̱e̱ mò̱ fɔŋfɔŋ agyase̱po̱‑ɔ bo̱ko̱ suŋ bamo̱ Yeesuu ase̱ bise mò̱ fe̱yɛ, “Yohanee Osuubɔpo̱‑ɔ yɛ, fo̱ e̱ gye̱ Kristoo ne̱ Yohanee yɛ ɔ ba a ɔ bo̱ le̱e̱ Wuribware̱ ase̱‑ɔ ɔɔɔ, bɛɛɛ se̱sɛ baŋbaŋ ko̱ be̱e̱ ɔ bo̱‑rɔ ne̱ ane̱ ke̱e̱ mò̱ kpa?” ");
INSERT INTO ncuNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","5","Ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “Mo̱nꞌ kiŋŋi nare̱ ya tɔwe̱ ke̱tɔ ne̱ mo̱ne̱ i nu mo̱ e̱ tɔwe̱‑ɔ, na ke̱tɔ ne̱ mo̱ne̱ i ŋu mo̱ e̱ waa‑ɔ gywii Yohanee. Fe̱yɛ ane̱ŋ ne̱ Wuribware̱ kyaamɛɛ ko̱ a kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ bo̱ le̱e̱ mò̱ ne̱ ɔ ba a ɔ bo̱ ba‑ɔ kuŋu si ase̱ŋ‑ɔ, amo̱ e̱ gye̱ fe̱yɛ mbe̱yɔmɔ ate̱napo̱ ke̱e̱, ne̱ agyabɔɔ naa, ne̱ abwatɔpo̱ ke̱bwatɔ a lo̱we̱, ne̱ akpawu i nu ase̱ŋ, ne̱ bamo̱ ne̱ baa wu‑o a kyiŋŋi, ne̱ atiripo̱ i nu ase̱ŋ timaa‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ɔko̱ ne̱ ɔ maa yɔwe̱ ko̱kɔɔre̱ mo̱ gyi‑o e̱ nya ŋyure.” ");
INSERT INTO ncuNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Saŋ ne̱ Yohanee Osuubɔpo̱ a mbɔɔ‑ɔ a kiŋŋi bo̱ yii‑o, ne̱ Yeesuu a le̱e̱ ɔ tɔwe̱ Yohanee ase̱ŋ o gywii lamaŋ‑ɔ. Ɔ yɛ, “Saŋ ne̱ mo̱ne̱ a yɔ Yohanee ase̱ kimukee‑ro‑o, nte̱tɔ ne̱ mo̱ne̱ a yɔ a mo̱nꞌ ya de̱e̱re̱? Ɔko̱ ne̱ o kyurowi mò̱ mfɛɛre̱ fe̱yɛ ane̱ŋ ne̱ e̱fa i kpeere e̱e̱ yɔ mfe̱e̱ na mfe̱e̱ saŋ ne̱ afwii e̱ da e̱mo̱‑ɔ ne̱ mo̱ne̱ a ya de̱e̱re̱ aaa? ");
INSERT INTO ncuNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nte̱tɔ ne̱ mo̱ne̱ a le̱e̱ ya de̱e̱re̱? Se̱sɛ ne̱ o buŋ waagya timaa‑o ne̱ mo̱ne̱ a yɔ ya de̱e̱re̱ aaa? Ase̱sɛ ne̱ bo̱ buŋ ane̱ŋ a atɔ‑ɔ, ne̱ bamo̱ kakye̱na‑rɔ bo̱ kɔne̱ ane̱ŋ‑ɔ e̱ gye̱ atɔ awuye ne̱ bo̱ te e̱lɔŋ dame̱naŋsɛ dabe̱ dabe̱‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mo̱nꞌ tɔwe̱ gywii mo̱, nsɛ ne̱ mo̱ne̱ a yɔ a mo̱nꞌ ya de̱e̱re̱? Wuribware̱ kyaamɛɛ aaa? Kase̱ŋtiŋ ne̱e̱, amaa n gye̱ Wuribware̱ kyaamɛɛ‑ɔ wo̱re̱ ne̱ mo̱ne̱ a ŋu. Mo̱ne̱ a ŋu ɔko̱ na ɔ kyɔ bo̱ tii si. ");
INSERT INTO ncuNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","A le̱e̱ fe̱yɛ Yohanee Osuubɔpo̱‑ɔ ase̱ŋ ne̱ baa kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ Wuribware̱ e̱ tɔwe̱ o gywii Kristoo fe̱yɛ, ‘Mo̱ i suŋ mo̱ kabɔɔ a m bo̱ gye̱ fo̱ ŋkpɛɛ, na ɔ ya lɔŋŋɔ kpa bo̱ ye̱ra fo̱.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ne̱ Yeesuu a tɔwe̱ bo̱ tii si fe̱yɛ, “Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ se̱sɛ ko̱ mo̱ŋ kye̱na swe̱e̱re̱ mɔ se̱ na ɔ kyɔ Yohanee Osuubɔpo̱‑ɔ, amaa mò̱ ne̱ ɔ gye̱ kagyingyii Wuribware̱ se̱ a kuwure‑o‑ro‑o kyɔ Yohanee. ");
INSERT INTO ncuNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Le̱e̱ saŋ ne̱ Yohanee a tɔwe̱ abware̱se̱ŋ lo̱we̱‑ɔ bo̱ fo̱ ndɔɔ, Wuribware̱ se̱ a kuwure‑o‑ro a ba ne̱ kaa daŋ waa ko̱kyɔ, ne̱ ɔke̱maa i neŋ mò̱ bɛɛko̱ ɔ le̱e̱‑rɔ, na ɔ nya nya kpa a ɔ bo̱ tii si. ");
INSERT INTO ncuNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mbraa ne̱ Wuribware̱ a bo̱rɔ Mosis si bo̱ sa ase̱sɛ‑ɔ na ke̱tɔ ne̱ Wuribware̱ a akyaamɛɛ‑ɔ a kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ pɛɛɛ a tɔwe̱ Wuribware̱ se̱ a kuwure‑o‑ro ase̱ŋ na ke̱mo̱ ke̱bo̱ ba. Yohanee mɔ bo̱ ba‑ɔ, ne̱ mò̱ gbaa a tɔwe̱ ke̱mo̱ ase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ne̱ mo̱ne̱ ya kɔɔre̱ ase̱ŋ ne̱ Mosis na akyaamɛɛ amo̱ a kyo̱rɛɛ bo̱ kaapo̱ mo̱ne̱‑ɔ gyi, mo̱ e̱ kpa a m be̱e̱ bo̱ kaapo̱ mo̱ne̱ ase̱ŋ ko̱ ne̱ a kyɔ‑ɔ. Amo̱ e̱ gye̱ fe̱yɛ Wuribware̱ kyaamɛɛ ko̱ a kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ Wuribware̱ kyaamɛɛ Iliya be̱e̱ ɔ ba. Ne̱ mo̱ e̱ kaapo̱ mo̱ne̱ fe̱yɛ Yohanee e̱ gye̱ Wuribware̱ kyaamɛɛ amo̱ ne̱ ɔɔ be̱e̱ ba‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Amo̱se̱‑ɔ ɔke̱maa ne̱ o de e̱se̱bɔ‑ɔ, o nu. ");
INSERT INTO ncuNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Mbe̱yɔmɔ, nte̱tɔ ne̱ mo̱ e̱ nya a m bo̱ biri ndɔɔ a ase̱sɛ‑ɔ ne̱e̱? E̱me̱ne̱ ne̱ bo̱ du? Bo̱ du ne̱e̱ fe̱yɛ ŋyaagyi a te ba soori alɔŋde̱ se̱‑ɔ, ne̱ bamo̱ katuŋ ko̱ e̱ fɛɛ‑rɔ ba kyo̱ŋwe̱ katuŋ ko̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ane̱ a da ko̱ko̱fɔ‑rɔ akɔye̱ sa mo̱ne̱, amaa mo̱ne̱ mo̱ŋ kyaa ooo. Ne̱ ane̱ a be̱e̱ waa kale, amaa mo̱ne̱ mo̱ŋ su ooo.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Bo̱ maa kɔɔre̱ ɔko̱ abware̱se̱ŋ ko̱tɔwe̱ ba gyi. Yohanee a ke̱mo̱‑ɔ ooo, mo̱ lee ooo ne̱ bo̱ maa kpa. A le̱e̱ fe̱yɛ Yohanee Osuubɔpo̱‑ɔ a ba‑ɔ, ne̱ ɔɔ kra ako̱ŋ, ne̱ oo kisi nta kunuu, ne̱ bo̱ yɛ, ‘Ɔbɔnsam te mò̱ se̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Amaa saŋ ne̱ mo̱, dimaadi mò̱ gyi‑o, a ba‑ɔ, mo̱ a gyi, ne̱ mo̱ a nuu, ne̱ bo̱ be̱e̱ bo̱ yɛ, ‘Mo̱nꞌ ke̱e̱ ɔnyare̱ amo̱, ɔ gye̱ oteesekpapo̱, na ɔtanuupo̱, na leŋpoo akɔɔre̱po̱ bamo̱ nyare̱, na e̱bɔye̱ awaapo̱ bamo̱ nyare̱ ne̱e̱.’ Amaa fo̱ ya ŋu ɔko̱ ne̱ mò̱ e̱ gya Wuribware̱ a kanyiase̱ŋ a e̱kpa‑ɔ se̱, fo̱ i ŋu fe̱yɛ mò̱ kanyiase̱ŋ‑ɔ gye̱ kase̱ŋtiŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ne̱ Yeesuu akatɔ mo̱ŋ gyi mò̱ fɔŋfɔŋ Isireelii awuye bo̱ko̱ se̱, a le̱e̱ fe̱yɛ ɔɔ waa akpe̱ŋe̱ye̱e̱tɔ bwe̱e̱tɔ bamo̱ e̱maŋ‑nɔ, ne̱ bo̱ mo̱ŋ tɛɛ nu bamo̱ e̱ye̱e̱ kiŋŋi le̱e̱ bamo̱ e̱bɔye̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ɔ yɛ, “Mo̱ne̱ ne̱ mo̱ne̱ te Korasiŋ na Bɛtɛsaye̱da e̱maŋ‑nɔ i ŋu ase̱ŋ ne̱e̱ fɛɛ. Atɔ dabe̱ ne̱ mo̱ a waa mo̱ne̱ aye̱‑ɔ ne̱ mo̱ a dɛɛ waa amo̱ Tiro na Sidɔŋ e̱maŋ ne̱ e̱ mo̱ŋ bo̱ Isireelii‑ro‑o ne̱e̱, weetee mfe̱ŋ a awuye‑o a kyɔ waa ke̱mo̱ ne̱ ke̱ e̱ kaapo̱ fe̱yɛ baa nu bamo̱ e̱ye̱e̱ kiŋŋi le̱e̱ bamo̱ e̱bɔye̱‑rɔ‑ɔ kyee. ");
INSERT INTO ncuNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ kake ne̱ Wuribware̱ i gyi ase̱sɛ pɛɛɛ ase̱ŋ‑ɔ, o gyiiri mo̱ne̱ ke̱se̱bɔ a ɔ kyo̱ŋ Tiro na Sidɔŋ awuye. ");
INSERT INTO ncuNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mo̱ne̱ Isireelii awuye ne̱ mo̱ne̱ te Kapaaniyum maŋ‑nɔ‑ɔ mɔ, mo̱ne̱ e̱ kpa fe̱yɛ mo̱nꞌ yase̱ mo̱ne̱ e̱ye̱e̱ yaa Wuribware̱ se̱ ne̱e̱ e̱e̱e̱? Wuribware̱ e̱ twe̱e̱ mo̱ne̱ a ɔ bo̱ kyo̱ŋwe̱ mfe̱ŋ ne̱ o gyiiri e̱bɔye̱ awaapo̱ ke̱se̱bɔ‑ɔ. Mo̱ne̱ a kare̱ abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ ane̱ŋ ne̱ Sɔdɔm† maŋ awuye ne̱ bo̱ mo̱ŋ gye̱ Isireelii awuye‑o a waa e̱bɔye̱ bwe̱e̱tɔ, ne̱ ane̱ŋ se̱‑ɔ Wuribware̱ a sa ne̱ bamo̱ maŋ a kpuri‑o ooo? Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ atɔ dabe̱ ne̱ mo̱ a waa mo̱ne̱ aye̱‑ɔ ne̱ mo̱ a dɛɛ waa amo̱ Sɔdɔm ne̱e̱, weetee mfe̱ŋ a awuye‑o a kyɔ nu bamo̱ e̱ye̱e̱ kiŋŋi le̱e̱ bamo̱ e̱bɔye̱‑ɔ‑rɔ, ne̱ ane̱ŋ se̱‑ɔ bamo̱ maŋ amo̱ mo̱ŋ kpuri. ");
INSERT INTO ncuNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mo̱ i yii mo̱ne̱ se̱ fe̱yɛ kake ne̱ Wuribware̱ i gyi ase̱sɛ pɛɛɛ ase̱ŋ‑ɔ, o gyiiri mo̱ne̱ Kapaaniyum awuye ke̱se̱bɔ a ɔ kyo̱ŋ Sɔdɔm awuye‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Saŋ amo̱‑ɔ, Yeesuu yɛ, “N se̱, Wuribware̱, so̱so̱ na swe̱e̱re̱ Owure, mo̱ e̱ sa fo̱ aŋsɛ fe̱yɛ fo̱ a taa fo̱ kase̱ŋtiŋ‑o bo̱ kwe̱e̱rɔ anyiase̱ŋpo̱ se̱, ne̱ fo̱ a taa bo̱ kaapo̱ bamo̱ ne̱ bo̱ mo̱ŋ nyi ase̱ŋ bwe̱e̱tɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","N se̱, mo̱ a ŋu kase̱ŋtiŋ si ane̱ŋ ne̱ fo̱ a kpa fe̱yɛ fo̱ waa‑ɔ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ne̱ ɔɔ tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “N se̱ a taa ke̱tɔ ke̱maa bo̱ waa mo̱ ke̱sare̱e̱‑rɔ. Ɔke̱maa mɔ mo̱ŋ nyi ane̱ŋ ne̱ n du‑o, amɔ n se̱ ne̱ ɔ bo̱ so̱so̱‑ɔ wo̱re̱, ne̱ ɔke̱maa mɔ mo̱ŋ nyi ane̱ŋ ne̱ n se̱ du‑o, amɔ mo̱ aa bamo̱ ne̱ bo̱ du fe̱yɛ mo̱ne̱‑ɔ, ne̱ mo̱ a lee fe̱yɛ bo̱ gyii mò̱‑ɔ wo̱re̱ kpeŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ne̱ Yeesuu a tɔwe̱ bo̱ gye̱ kɛɛ fe̱yɛ, “E̱kpa ne̱ mo̱ne̱ gya se̱ mbe̱yɔmɔ‑ɔ bo̱ le̱ŋ aaa? E̱kpa ne̱ mo̱ e̱ kaapo̱‑ɔ fe̱raa mo̱ŋ bo̱ le̱ŋ. Amo̱se̱‑ɔ ne̱ ŋ yɛ mo̱ne̱ ɔke̱maa ne̱ ɔɔ kpo̱ne̱ ɔ so̱ tɔso̱rɔ dwiidwiisɛ‑ɔ ba mo̱ ase̱, na ɔ nya bo̱ so̱we̱ kyure. ");
INSERT INTO ncuNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Na ŋkee ŋ kaapo̱ mò̱ ane̱ŋ ne̱ ɔ so̱rɔ tɔso̱rɔ ne̱ mo̱ e̱ so̱rɔ mò̱‑ɔ. Ɔ mo̱ŋ bo̱ le̱ŋ, a le̱e̱ fe̱yɛ ke̱kɛɛ ne̱ mo̱ e̱ sa mò̱‑ɔ bo̱ daŋ, ne̱ tɔso̱rɔ‑ɔ mɔ maa waa dwii. Na o ŋu fe̱yɛ nyaŋpe̱ wo̱rɔba na nyaŋpe̱ timaa e̱ gye̱ mo̱, na n sa a mò̱ kakpo̱nɔ‑rɔ yuri mò̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kukyure kake ko̱, ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ naa ba kyo̱ŋ abwaye adɔɔ ko̱‑rɔ. Ne̱ mò̱ agyase̱po̱‑ɔ a le̱e̱ ba gyɛɛ abwaye ne̱ ba kyo̱ŋ amo̱‑rɔ‑ɔ, ne̱ baa fee ba wo̱, a le̱e̱ fe̱yɛ ako̱ŋ de bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farisii awuye ko̱ a ŋu amo̱‑ɔ, ne̱ baa tɔwe̱ gywii Yeesuu fe̱yɛ, “Ke̱e̱ ɛ, fo̱ agyase̱po̱ a ke̱gyɛɛ abwaye fee‑o gye̱ kusuŋ. Ne̱ a kye ane̱ mbraa fe̱yɛ ɔko̱ a waa kusuŋ ko̱ kukyure kake.” ");
INSERT INTO ncuNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “Mo̱ne̱ mo̱ŋ tɛɛ kare̱ abware̱se̱ŋ wo̱re̱‑ɔ ŋu ke̱tɔ ne̱ ane̱ ɔde̱daapo̱ Deefid a waa saŋ ne̱ ako̱ŋ de mò̱ aa mò̱ anare̱bɛɛpo̱‑ɔ ɔɔɔ? ");
INSERT INTO ncuNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ke̱tɔ bo̱ abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ oo lwee Wuribware̱ suŋkpa, ne̱ baa sa mò̱ aa mò̱ anare̱bɛɛpo̱‑ɔ bodobodoo akuri ne̱ baa bo̱ lɔŋŋɔ Wuribware̱‑ɔ. Na a mo̱ŋ gye̱ mbraa kikye aaa? A le̱e̱ fe̱yɛ ane̱ mbraa‑ɔ yɛ Wuribware̱ alɔŋŋɔpo̱ wo̱re̱ e̱ gye̱ ne̱ bo̱ de kpa fe̱yɛ bo̱ gyi ane̱ŋ a bodobodoo‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Bɛɛɛ mo̱ne̱ mo̱ŋ kare̱ ane̱ mbraa a wo̱re̱‑ɔ fe̱yɛ kukyure kake ke̱maa Wuribware̱ alɔŋŋɔpo̱ fɔŋfɔŋ i suŋ bamo̱ ke̱bware̱suŋ Wuribware̱ suŋkpa aaa? Ane̱ŋ se̱‑ɔ ba kye mbraa ne̱ ŋ yɛ ane̱ kyure kukyure kake‑o, bɛɛɛ? Na ɔko̱ ma taare̱ taa ke̱mo̱ fe̱yɛ ba waa bɔye̱, bɛɛɛ? ");
INSERT INTO ncuNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ ɔko̱ bo̱ mfe̱e̱ ne̱ mò̱ ke̱dabe̱ kyɔ Wuribware̱ suŋkpa lee‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mo̱nꞌ nyiŋŋi si ane̱ŋ ne̱ baa kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ, ‘Wuribware̱ yɛ, N gye̱ mbo̱ ne̱ mo̱ e̱ kpa a mo̱nꞌ mɔɔ sa mo̱. Amaa ke̱dame̱naŋsɛ ne̱ mo̱ e̱ kpa a mo̱nꞌ waa mo̱ne̱ bɛɛko̱‑ana.’ Mo̱ne̱ dɛɛ mo̱ne̱ i nu amo̱‑ɔ kaase̱ kyɛɛkyɛɛ ne̱e̱‑ɔ, weetee mo̱ne̱ maa po̱rɔ bamo̱ ne̱ bo̱ mo̱ŋ waa e̱bɔye̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","A le̱e̱ fe̱yɛ mo̱, dimaadi mò̱ gyi‑o, de kukyure kake‑o gbaa e̱le̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ne̱ Yeesuu a le̱e̱ mfe̱ŋ ya lwee ke̱bware̱ko̱re̱kyaŋ ko̱ ne̱ ke̱ maa mfe̱ŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ne̱ ɔɔ ya to̱ ke̱sare̱e̱ wusɛ wuye ko̱. Na Farisii awuye‑o be̱e̱ bo̱ bo̱ mfe̱ŋ. Bamo̱ a kpa a bo̱ po̱rɔ Yeesuu fe̱yɛ ɔ waa e̱bɔye̱‑ɔ se̱‑ɔ, ne̱ baa pee ke̱katɔ a bo̱ de̱e̱re̱ ke̱e̱ fe̱yɛ ɔ kya ke̱sare̱e̱ wusɛ wuye amo̱ kukyure kake amo̱ aaa, a le̱e̱ fe̱yɛ bo̱ maa waa kusuŋ ke̱maa kake amo̱. Amo̱se̱ ne̱ baa bise mò̱ fe̱yɛ, “A mo̱ŋ kye ane̱ Wuribware̱ mbraa fe̱yɛ ɔko̱ kya ɔlɔpo̱ kukyure kake aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “N taa fe̱yɛ mo̱ne̱ ɔko̱ de mò̱ sanne̱. Ne̱ sanne̱‑ɔ a le̱e̱ da ke̱maŋtaŋ keŋkeŋsɛ‑rɔ ɔ da, ne̱ ɔ maa taare̱ a ɔ le̱e̱. Ne̱ amo̱ e̱ gye̱ kukyure kake gbaa ooo, fo̱ e̱ ya a fo̱ ya lee mò̱, na fo̱ mo̱rɔwe̱ mò̱ bɛɛɛ fo̱ maa yɔ aaa? ");
INSERT INTO ncuNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Amaa sanne̱ mo̱ŋ fo̱ se̱sɛ. Dimaadi kyɔ kabo̱. Amo̱se̱ se̱‑ɔ ane̱ mbraa‑ɔ a sa kpa fe̱yɛ ane̱ waa ke̱dame̱naŋsɛ kukyure kake.” ");
INSERT INTO ncuNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ne̱ ŋkee ɔɔ tɔwe̱ gywii ke̱sare̱e̱ wusɛ wuye‑o fe̱yɛ, “Teyi fo̱ ke̱sare̱e̱‑ɔ‑rɔ.” Mò̱ a teyi‑ro‑o, ne̱ kaa kpaare̱ nya ke̱yaale̱ŋ fe̱yɛ ane̱ŋ ne̱ ko̱ko̱‑ɔ du‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mfe̱ŋ ne̱ Farisii awuye amo̱ a le̱e̱ kawu ya da Yeesuu kuŋu si kikpuni a bo̱ nya mɔɔ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yeesuu a nu kikpuni ne̱ baa kpa a bo̱ da mò̱ kuŋu si‑o ase̱ŋ‑ɔ, ne̱ ɔɔ le̱e̱ mfe̱ŋ, ne̱ ɔɔ yɔ ɔ naa ifuri baŋbaŋ se̱. Ne̱ ase̱sɛ biribiri a gya mò̱ se̱, ne̱ ɔɔ kya bamo̱ alɔpo̱ pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Mò̱ a kya bamo̱‑ɔ, ne̱ oo yii bamo̱ se̱ fe̱yɛ bo̱ ma tɔwe̱ ke̱tɔ ne̱ ɔɔ waa sa bamo̱‑ɔ gywii ɔko̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ɔɔ waa amo̱‑ɔ ne̱e̱ na ke̱tɔ ne̱ Wuribware̱ a tɔwe̱ bo̱ bo̱‑rɔ mò̱ kyaamɛɛ Isaya si‑o nya ba kase̱ŋtiŋ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Wuribware̱ yɛ, Mo̱nꞌ ke̱e̱ mo̱ ke̱yaafɔre̱ ne̱ mo̱ a lee‑o, mò̱ ne̱ mo̱ e̱ kpa mò̱ ase̱ŋ ne̱ mo̱ akatɔ a gyi mò̱ se̱‑ɔ. N de mo̱ kufwiiŋe‑o mo̱ e̱ waa mò̱‑rɔ. Mò̱ e̱ gye̱ ne̱ ɔ baa kase̱ŋtiŋ kigyi nde̱ se̱ awuye pɛɛɛ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mò̱ aa bo̱ko̱ maa gyiiri ikii bɛɛɛ bo̱ fɛɛ abɛɛ se̱, ane̱ŋ dɛɛ ne̱ ɔ maa ye̱re̱ mbo̱re̱ se̱ na ɔ fɛɛ sa mò̱ e̱se̱ŋsa. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","O yuri mò̱ e̱ye̱e̱ a ɔ sa bamo̱ ne̱ bo̱ mo̱ŋ bo̱ le̱ŋ‑ɔ, na ɔ ma duŋ bamo̱ ne̱ bamo̱ ko̱kɔɔre̱gyi mo̱ŋ kyɔ‑ɔ nnɔ, amɔ saŋ ne̱ mò̱ kase̱ŋtiŋ kigyi a gyi si to̱ŋ ke̱maa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mò̱ ne̱ nde̱ se̱ awuye pɛɛɛ e̱ kɔɔre̱ a bo̱ gyi.” ");
INSERT INTO ncuNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ne̱ ase̱sɛ ko̱ a baa ɔnyare̱ ko̱ Yeesuu ase̱. Ɔnyare̱ amo̱ mɔ mo̱ŋ ke̱e̱, na ɔ be̱e̱ ɔ maa taare̱ a ɔ sa se̱ŋsa, a le̱e̱ fe̱yɛ ibrisi ko̱ te mò̱ se̱. Ne̱ Yeesuu a kya ɔnyare̱‑ɔ, ne̱ mò̱ akatɔ a buŋŋi, ne̱ mò̱ kanɔ a buŋŋi, ne̱ ɔ taare̱ a ɔ sa se̱ŋsa. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Lamaŋ‑ɔ a ŋu Yeesuu a waa ane̱ŋ a atɔ‑ɔ, ne̱ e̱ye̱e̱ a kpe̱ŋ bamo̱, ne̱ baa bise abɛɛ fe̱yɛ, “N gye̱ ane̱ ɔde̱daapo̱ Deefid mò̱ ke̱nanagyi ne̱ baa tɔwe̱ fe̱yɛ Wuribware̱ i suŋ a ɔ bo̱ kyo̱ŋwe̱ ane̱‑ɔ ne̱e̱ e̱e̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Amaa Farisii awuye ko̱ a nu ane̱ŋ ne̱ ba tɔwe̱‑ɔ, ne̱ bo̱ yɛ, “Daabii, ɔnyare̱ mɔ gye̱ se̱sɛ bɔye̱ ne̱e̱. Ɔbɔnsam, ne̱ bo̱ be̱e̱ ba te̱e̱ mò̱ ɛ Biil-sibul‑o e̱ gye̱ ne̱ o de ibrisi si ke̱yaale̱ŋ, ne̱ ɔ sa ɔnyare̱ mɔ e̱le̱ŋ fe̱yɛ ɔ gya ibrisi bo̱ ko̱so̱ ase̱sɛ se̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Amɔ Yeesuu a kyɔ ŋu ke̱tɔ ne̱ ba fa‑ɔ. Ne̱ ɔɔ da bamo̱ ke̱kpare̱ mɔ fe̱yɛ, “E̱kɔ ya lwee maŋ‑nɔ, ne̱ maŋ‑ɔ ya ke‑ro, amɔ maŋ amo̱ i bwee ne̱e̱, ane̱ŋ dɛɛ ne̱ kasuro bɛɛɛ kabuno ya ke‑ro, ne̱ ka bwee. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Amo̱se̱‑ɔ amo̱ e̱ gye̱ kase̱ŋtiŋ fe̱yɛ Ɔbɔnsam e̱ gya ibrisi a ɔ bo̱ ko̱so̱ ase̱sɛ se̱, a kaapo̱ ne̱e̱ fe̱yɛ Ɔbɔnsam na mò̱ kamɛɛ‑rɔ awuye a ke‑ro. Na ke̱tɔ ma kyee, na mò̱ kuwure gye̱ kɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mo̱ne̱ yɛ n de Biil-sibul ne̱ ɔ gye̱ Ɔbɔnsam‑ɔ e̱le̱ŋ mo̱ e̱ gya ibrisi. Amaa ŋ nyi fe̱yɛ mo̱ne̱ agyase̱po̱‑ɔ bo̱ko̱ e̱ gya ibrisi ba ko̱so̱ ase̱sɛ se̱. Nte̱tɔ e̱le̱ŋ ne̱ bo̱ de? Ɔbɔnsam a e̱le̱ŋ‑ɔ bɛɛɛ Wuribware̱ lee‑o? A gye̱ Wuribware̱ a e̱le̱ŋ‑ɔ ne̱ bo̱ de, bɛɛɛ? To, mo̱ne̱ agyase̱po̱ amo̱ fɔŋfɔŋ gbaa a kaapo̱ ne̱e̱ fe̱yɛ mo̱ne̱ a fo̱ kpa. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Amaa amo̱ a gye̱ Wuribware̱ a kufwiiŋe‑o ke̱yaale̱ŋ ne̱ n de mo̱ e̱ gya ibrisi‑o si‑o, a kaapo̱ mo̱ne̱ ne̱e̱ fe̱yɛ Wuribware̱ a kuwure‑o a kyɔ ba mo̱ne̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","M be̱e̱ taa fe̱yɛ Ɔbɔnsam du ne̱e̱ fe̱yɛ ɔyaale̱ŋpo̱ ne̱ o de mò̱ lɔŋ‑ɔ. Ɔke̱maa maa lwee ɔyaale̱ŋpo̱ amo̱ lɔŋ‑nɔ, na ɔ ya be̱ra mò̱ kapo̱tɛɛ taa, amɔ o ŋure ɔyaale̱ŋpo̱‑ɔ pwɛɛ na ɔ dɛɛ taare̱ lweero ya be̱ra mò̱ kapo̱tɛɛ‑ɔ bo̱ yɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Amo̱se̱‑ɔ mo̱ i yii mo̱ne̱ se̱ fe̱yɛ mo̱ne̱ ɔke̱maa ne̱ ɔ mo̱ŋ ye̱re̱ mo̱ kamɛɛ‑ɔ gye̱ mo̱ do̱ŋ ne̱e̱. Ne̱ ɔke̱maa mɔ ne̱ ɔ maa kya mo̱‑rɔ na ŋ kpɔwe̱ ase̱sɛ bwe̱e̱tɔ bo̱ tii mo̱ e̱ye̱e̱ se̱‑ɔ mɔ e̱ brawe̱ bamo̱‑rɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mo̱ne̱ a tɔwe̱ fe̱yɛ e̱le̱ŋ ne̱ Wuribware̱ a kufwiiŋe timaa‑o a sa mo̱‑ɔ a le̱e̱ Ɔbɔnsam ase̱ aaa? To, mo̱nꞌ nyiŋŋi si fe̱yɛ Wuribware̱ e̱ taare̱ a ɔ taa se̱sɛ e̱bɔye̱ ke̱maa ne̱ ɔɔ waa‑ɔ na ase̱ŋ bɔye̱ ke̱maa ne̱ ɔɔ tɔwe̱‑ɔ na ɔ bo̱ ke mò̱, amɔ ase̱ŋ bɔye̱ ne̱ ɔɔ tɔwe̱ bo̱ kye Wuribware̱ a kufwiiŋe timaa‑o fe̱raa, Wuribware̱ maa taa bɔye̱ amo̱ a ɔ bo̱ ke mò̱ pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ɔke̱maa ne̱ ɔ tɔwe̱ ase̱ŋ bɔye̱ ke̱maa a ɔ bo̱ kye mo̱, dimaadi mò̱ gyi‑o, Wuribware̱ e̱ taare̱ a ɔ taa se̱sɛ‑ɔ bɔye̱ amo̱ bo̱ ke mò̱. Amaa ɔke̱maa mɔ ne̱ ɔ tɔwe̱ ase̱ŋ bɔye̱ ke̱maa a ɔ bo̱ kye Wuribware̱ a kufwiiŋe timaa‑o, Wuribware̱ maa taa se̱sɛ‑ɔ bɔye̱ amo̱ a ɔ bo̱ ke mò̱, mbe̱yɔmɔ a kaye̱ mɔ‑rɔ bɛɛɛ kaye̱ ne̱ ka ba a ka bo̱ ba‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ŋ yɛ, fo̱ ya ŋu kiyii ko̱ a swɛɛ agyi timaa, a kaapo̱ ne̱e̱ fe̱yɛ kiyii‑o bo̱ daŋ. Ne̱ fo̱ ya ŋu kiyii suyo ko̱ mɔ a swɛɛ agyi preepreesɛ, a kaapo̱ ne̱e̱ fe̱yɛ kiyii amo̱ mo̱ŋ bo̱ daŋ. Kiyii agyi ne̱ bo̱ de ba pini kiyii suyo ne̱ ke̱ gye̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ane̱ŋ se̱‑ɔ, mo̱ne̱ mo̱ŋ nyi ase̱ŋ kpe̱yaa e̱tɔwe̱. Mo̱ne̱ awɔ mɔ, e̱me̱ne̱ ne̱ mo̱ne̱ e̱ waa a mo̱nꞌ tɔwe̱ ase̱ŋ kpe̱yaa na ke̱bwɛɛ bo̱ mo̱ne̱ nnɔ‑rɔ? A le̱e̱ fe̱yɛ ke̱tɔ ne̱ ke̱ bo̱ kakpo̱nɔ‑rɔ‑ɔ ne̱ kanɔ e̱ tɔwe̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Atɔ timaa a le̱e̱ kakpo̱nɔ timaa‑ro, ne̱ ase̱ŋ bɔye̱ a le̱e̱ kakpo̱nɔ bɔye̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mo̱nꞌ nyiŋŋi si fe̱yɛ kake nsi ne̱ Wuribware̱ i gyi ase̱sɛ pɛɛɛ ase̱ŋ‑ɔ, o bise ɔke̱maa ke̱se̱ŋkpare̱gyi ke̱maa ne̱ ɔɔ tɔwe̱, ne̱ ke̱ mo̱ŋ bo̱ daŋ‑ɔ ase̱ŋ, na ɔke̱maa lee mò̱ e̱ye̱e̱ kanɔ gywii Wuribware̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","A le̱e̱ fe̱yɛ fo̱ ase̱ŋkpare̱gyi ne̱ Wuribware̱ e̱ de̱e̱re̱‑rɔ a ɔ bo̱ gyi fo̱ ase̱ŋ na o bu fo̱ ke̱be̱ŋ bɛɛɛ ke̱pɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mfe̱ŋ ne̱ Farisii awuye ko̱ na Wuribware̱ mbraa akaapo̱po̱ ko̱ a tɔwe̱ gywii Yeesuu fe̱yɛ, “Ɔkaapo̱po̱, ane̱ e̱ kpa fe̱yɛ fo̱ waa akpe̱ŋe̱ye̱e̱tɔ ko̱ na fo̱ bo̱ kaapo̱ fe̱yɛ Wuribware̱ bo̱ fo̱ ase̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “Mo̱ne̱ ndɔɔ a kaye̱ mɔ‑rɔ ase̱sɛ‑ɔ gye̱ ase̱sɛ bɔye̱ ne̱ mo̱ne̱ maa kɔɔre̱ Wuribware̱ mo̱ne̱ i gyi‑o. Mo̱ne̱ yɛ ŋ waa akpe̱ŋe̱ye̱e̱tɔ bo̱ kaapo̱ mo̱ne̱. Amaa ma waa, amɔ Wuribware̱ kyaamɛɛ Yonaa a akpe̱ŋe̱ye̱e̱tɔ‑ɔ wo̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","A bo̱ abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ baa taa mò̱ bo̱ twe̱e̱ ɔpo̱o̱‑rɔ, ne̱ kakiŋgyi dabe̱ ko̱ a kra mò̱ mee, ne̱ oo sii kamo̱ kame‑ro ŋke nsa pwɛɛ ne̱ kakiŋgyi‑o a dɛɛ kpuu mò̱ bo̱ be̱ya nkyu kɛɛ na ɔ ke̱e̱. Ane̱ŋ dɛɛ ne̱ mo̱, dimaadi mò̱ gyi‑o, i gyi ŋke nsa e̱se̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ke̱tɔ ne̱ ki tii si‑o e̱ gye̱ fe̱yɛ kake nsi ne̱ Wuribware̱ i gyi ɔke̱maa ase̱ŋ‑ɔ, Niniwee awuye e̱ ko̱so̱ a bo̱ ye̱re̱ po̱rɔ mo̱ne̱ ndɔɔ a kaye̱ mɔ‑rɔ ase̱sɛ‑ɔ, na bo̱ bu mo̱ne̱ ke̱pɔ, a le̱e̱ fe̱yɛ Yonaa a yɔ bamo̱ ase̱ ya tɔwe̱ abware̱se̱ŋ‑ɔ, ne̱ baa nu bamo̱ e̱ye̱e̱, ne̱ baa kiŋŋi le̱e̱ bamo̱ e̱bɔye̱‑rɔ. Ne̱ mbe̱yɔmɔ, n gye̱ ɔko̱ ne̱ ɔ kyɔ Yonaa‑o ya ba ɔ ye̱re̱ mo̱ne̱ akatɔ‑rɔ‑ɔ ɔɔɔ? Ne̱ mo̱ne̱ a kine mò̱ abware̱se̱ŋ ko̱tɔwe̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ŋke nsi amo̱ dɛɛ ne̱ owurekye̱e̱ ko̱ ne̱ ɔɔ le̱e̱ kyɔwe̱ le̱e̱kpa kigyise si a swe̱e̱re̱ ko̱ se̱‑ɔ e̱ ko̱so̱ a ɔ ye̱re̱ na ɔ po̱rɔ mo̱ne̱ ndɔɔ a kaye̱ mɔ‑rɔ ase̱sɛ‑ɔ, na o bu mo̱ne̱ ke̱pɔ, a le̱e̱ fe̱yɛ oo tu kpa le̱e̱ hare̱e̱ mò̱ aye̱ ba ane̱ ɔde̱daapo̱ Owure Solomɔŋ ase̱ mfe̱e̱ bo̱ nu owure amo̱ a kanyiase̱ŋ ase̱ŋ‑ɔ. Ne̱ mbe̱yɔmɔ, mo̱ne̱ a ŋu ɔko̱ ne̱ ɔ kyɔ Owure Solomɔŋ‑ɔ a ba ɔ ye̱re̱ mo̱ne̱ akatɔ‑rɔ. Ne̱ mo̱ne̱ a kine kunu mò̱ kanyiase̱ŋse̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44","Ne̱ Yeesuu yɛ, “Ibrisi ya ko̱so̱ se̱sɛ se̱, amɔ e̱ naa e̱ kaa e̱fa‑rɔ e̱e̱ kpa to̱ŋ ko̱ a e̱ kye̱na kyure. E̱mo̱ e̱ mo̱ŋ nya to̱ŋ ko̱, amɔ e̱e̱ ya fa e̱mo̱ mfɛɛre̱ fe̱yɛ ii kiŋŋi a e̱ yɔ lɔŋ ne̱ baa gya e̱mo̱ le̱e̱ mò̱‑rɔ‑ɔ‑rɔ. Na i kiŋŋi ya to̱ fe̱yɛ lɔŋ amo̱‑rɔ bo̱ daŋ ɔ mo̱ŋ de iyisi, ne̱ ɔko̱ mo̱ŋ te mò̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Na e̱ le̱e̱ ya kpa ibrisi isunoo ne̱ e̱ bo̱ le̱ŋ e̱ kyɔ e̱mo̱ fɔŋfɔŋ‑ɔ, na e̱ bo̱ kye̱na mfe̱ŋ. Ibrisi lɔŋ e̱ gye̱ se̱sɛ. To, amɔ e̱mo̱ a waa isunoo i te se̱sɛ amo̱ se̱ se̱‑ɔ, amɔ se̱sɛ a ko̱lɔ‑ɔ a waa ko̱kyɔ ko̱ kyo̱ŋ saŋ ne̱ ibrisi ko̱ŋko̱ e̱ gye̱ ne̱ ki te mò̱ se̱‑ɔ. Mfaanɛɛ a ase̱ŋ‑ɔ e̱ gye̱ ne̱ a ba ndɔɔ a kaye̱ mɔ‑rɔ a ase̱sɛ‑ɔ se̱ bo̱ le̱e̱ bamo̱ e̱bɔye̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yeesuu saŋ ɔ sa se̱ŋsa o gywii lamaŋ amo̱, ne̱ mò̱ nyi na mò̱ tire‑ana a ba. Ne̱ baa ye̱re̱ kawu suŋ bo̱ kyo̱ŋwe̱ mò̱ fe̱yɛ ba kpa fe̱yɛ ɔ ba a mò̱ aa bamo̱ a sa se̱ŋsa. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ne̱ ɔko̱ a tɔwe̱ gywii mò̱ fe̱yɛ, “Ke̱e̱ fo̱ nyi na fo̱ tire‑ana ye̱re̱ kawu ba te̱e̱ fo̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Nsɛ e̱ gye̱ n na? Ne̱ nsɛ‑ana mɔ e̱ gye̱ mo̱ tire‑ana?” ");
INSERT INTO ncuNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ne̱ oo teyi mò̱ ke̱sare̱e̱ bo̱ kyɔ mò̱ agyase̱po̱, ne̱ ɔ yɛ, “Mo̱nꞌ ke̱e̱, n na na mo̱ tire‑ana i te mo̱ ase̱ mfe̱e̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Amo̱se̱‑ɔ ɔke̱maa ne̱ ɔ waa ke̱tɔ ne̱ Wuribware̱, n se̱ ne̱ ɔ bo̱ so̱so̱‑ɔ e̱ kpa‑ɔ, ne̱ mo̱ e̱ te̱e̱ mò̱ ɛ mo̱ tire na mo̱ pe̱kye̱e̱ na n na.” ");
INSERT INTO ncuNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kake amo̱ dɛɛ ne̱ Yeesuu a le̱e̱ lɔŋ‑nɔ yɔ ke̱pare̱ dabe̱‑ɔ kɛɛ, mfe̱ŋ ne̱ ɔɔ kye̱na kaapo̱ lamaŋ atɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Amaa ase̱sɛ ne̱ baa bo̱ gyaŋŋe̱ muruwaa mò̱ mfe̱ŋ‑ɔ a kyɔ bwe̱e̱tɔ se̱‑ɔ, ne̱ oo buwi kpa ko̱re̱e̱. Mò̱ a nya‑ɔ, ne̱ oo neŋ ko̱re̱e̱‑ɔ bo̱ dɔŋŋɔ nkyu‑o si kafwe̱e̱. Ne̱ ɔɔ kye̱na‑rɔ ɔ kaapo̱ ase̱sɛ‑ɔ, na bamo̱ mɔ bo̱ ye̱re̱ nkyu kɛɛ ba nu mò̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ne̱ ɔɔ ba itee na akpare̱ bo̱ kaapo̱ bamo̱ ase̱ŋ bwe̱e̱tɔ. Ane̱ŋ a itee mɔ ko̱ko̱ŋko̱ e̱ gye̱ fe̱yɛ, “N gye̱ ɔdɔɔpo̱ ko̱ e̱ bo̱‑rɔ aaa? Ne̱ ɔɔ yɔ a ɔ ya ŋo̱nyaŋ mò̱ yaabraa. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mò̱ a yɔ ɔ ŋo̱nyaŋ‑ɔ, ne̱ ayaabraagyi amo̱ ako̱ a le̱e̱ da kpa‑rɔ, ne̱ mbo̱gyii a bo̱ tesi gyi. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ne̱ amo̱ ako̱ a le̱e̱ da kagyaase̱ mfe̱ŋ ne̱ swe̱e̱re̱‑ɔ mo̱ŋ bo̱ daŋ kyɛɛkyɛɛ‑ɔ. Swe̱e̱re̱‑ɔ a mo̱ŋ bo̱ keŋ‑o si‑o, ne̱ aa kwɛɛ me̱naŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Amaa amo̱ a kwɛɛ‑ɔ, ne̱ kyɔwe̱ a bo̱ da yaabraa‑ɔ mɔɔ, a le̱e̱ fe̱yɛ swe̱e̱re̱‑ɔ mo̱ŋ bo̱ keŋ a amo̱ ileŋ yɔ kaase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ayaabraagyi‑o ako̱ ne̱ aa le̱e̱ da e̱fa‑rɔ‑ɔ mɔ a ko̱so̱ daŋ. Amaa e̱fa a daŋ mwiire amo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ne̱ ŋkee ayaabraagyi amo̱ ako̱ a le̱e̱ da swe̱e̱re̱ timaa si. Ne̱ aa kwɛɛ nɛɛnɛɛ, ne̱ aa daŋ bo̱ ko̱we̱. Hare̱e̱ amo̱ ako̱ a waa aŋu adabe̱ adabe̱, ne̱ amo̱ ako̱ a waa aŋu nyiiresɛ, ne̱ amo̱ ako̱ mɔ a waa aŋu ngyingyii. Amo̱ e̱ gye̱ saase̱bɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Amo̱se̱‑ɔ, ɔke̱maa ne̱ o de e̱se̱bɔ‑ɔ, o nu.” ");
INSERT INTO ncuNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ne̱ Yeesuu agyase̱po̱‑ɔ a bo̱ bise mò̱ fe̱yɛ, “E̱me̱ne̱ se̱ ne̱ fo̱ de itee na akpare̱ fo̱ e̱ tɔwe̱ ase̱ŋ fo̱ i gywii lamaŋ‑ɔ?” ");
INSERT INTO ncuNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ne̱ ɔɔ be̱ŋŋaa bamo̱ fe̱yɛ, “Mo̱ne̱ wo̱re̱ ne̱ mo̱ e̱ tɔwe̱ ane̱ŋ ne̱ Wuribware̱ se̱ a kuwure‑o du‑o mo̱ i gywii, amaa ma kaapo̱ lamaŋ‑ɔ ane̱ŋ a atɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","A le̱e̱ fe̱yɛ ɔke̱maa ne̱ o nu mo̱ ase̱ŋ timaa‑o, ne̱ ɔ kɔɔre̱ a o gyi‑o, Wuribware̱ e̱ sa mò̱ kanyiase̱ŋ bwe̱e̱tɔ na ɔ bo̱ tii kamo̱ ne̱ o de‑o si. Ne̱ mò̱‑ɔ mò̱ ne̱ o kine amo̱‑ɔ e̱ paŋ mò̱ kanyiase̱ŋ kafwe̱e̱ ne̱ ɔ kyɔ o de‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ke̱tɔ se̱ ne̱ n de itee na akpare̱ mo̱ e̱ tɔwe̱ ase̱ŋ mo̱ i gywii lamaŋ‑ɔ e̱ gye̱ fe̱yɛ bo̱ de akatɔ, amaa bo̱ mo̱ŋ ke̱e̱, ne̱ bo̱ de e̱se̱bɔ, amaa bo̱ maa nu ase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ane̱ŋ a ase̱sɛ‑ɔ se̱‑ɔ, ke̱tɔ ne̱ Wuribware̱ kyaamɛɛ Isaya a tɔwe̱‑ɔ a waa kase̱ŋtiŋ fe̱yɛ, ‘Mo̱ne̱ ya nu mo̱ ase̱ŋ kpo̱ra‑rɔ iluwi bwe̱e̱tɔ gbaa, mo̱ne̱ maa nu amo̱ kaase̱. Mo̱ne̱ be̱e̱ mo̱ne̱ e̱ de̱e̱re̱ ase̱ŋ‑ɔ‑rɔ na mo̱nꞌ fa amo̱ mfɛɛre̱ kpo̱ne̱, mo̱ne̱ maa nu kaase̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ne̱ Isaya a kya se̱ tɔwe̱ fe̱yɛ Wuribware̱ yɛ amo̱ a waa ane̱ŋ, ‘A le̱e̱ fe̱yɛ bamo̱ aŋu‑ro a waa le̱ŋ, ne̱ baa tii bamo̱ e̱se̱bɔ, ne̱ baa buŋ bamo̱ akatɔ se̱. N gye̱ ane̱ŋ, bamo̱ akatɔ i buŋŋi a bo̱ ŋu atɔ, na bamo̱ e̱se̱bɔ mɔ taye̱ a bo̱ nu ase̱ŋ, na bo̱ nu ase̱ŋ kaase̱ na bo̱ nu bamo̱ e̱ye̱e̱, na ŋkee mo̱, Wuribware̱, ŋ nya taa bamo̱ e̱bɔye̱ bo̱ ke bamo̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Mo̱ agyase̱po̱‑ɔ, mo̱ne̱ fe̱raa, de ŋyure. Wuribware̱ akatɔ a gyi mo̱ne̱ se̱, amo̱se̱‑ɔ ɔɔ sa ne̱ mo̱ne̱ e̱ de̱e̱re̱ ase̱ŋ mɔ‑rɔ, ne̱ mo̱ne̱ i nu ase̱ŋ amo̱ kaase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ Wuribware̱ akyaamɛɛ na mò̱ ase̱sɛ ne̱ baa saŋ‑ɔ ne̱ baa dɛɛ kye̱na‑ɔ bwe̱e̱tɔ a yo̱rɔwe̱ fe̱yɛ bo̱ ŋu atɔ ne̱ mo̱ne̱ i ŋu ndɔɔ a kake mɔ‑ɔ, na bo̱ nu ase̱ŋ ne̱ mo̱ne̱ i nu mbe̱yɔmɔ‑ɔ. Amaa ɔ mo̱ŋ sa bamo̱ kpa.” ");
INSERT INTO ncuNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ne̱ Yeesuu a kya se̱ tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “To, mbe̱yɔmɔ mo̱nꞌ sa a ŋ kaapo̱ mo̱ne̱ a mo̱nꞌ nu ɔdɔɔpo̱ a kitee‑o kaase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ayaabraagyi ne̱ aa le̱e̱ da kpa‑rɔ‑ɔ ye̱re̱ bo̱ sa se̱sɛ ne̱ o nu Wuribware̱ se̱ a kuwure‑o ase̱ŋ‑ɔ, ne̱ mò̱‑ɔ mɔ maa nu amo̱ kaase̱‑ɔ. Mfe̱ŋ ne̱ Ɔbɔnsam e̱ ba a ɔ bo̱ lee amo̱ le̱e̱ mò̱ mfɛɛre̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ayaabraagyi ne̱ aa le̱e̱ da kagyaase̱‑ɔ mɔ ye̱re̱ bo̱ sa se̱sɛ ne̱ o nu abware̱se̱ŋ‑ɔ, ne̱ mò̱ fe̱raa, mò̱ ya nu amo̱, amo̱‑ɔ a waa mò̱ kɔne̱, na ɔ kɔɔre̱ waa mò̱ kakpo̱nɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Amaa mò̱ akatɔ a mo̱ŋ pee si‑o si‑o, mò̱ ko̱kɔɔre̱gyi maa kyee. Ase̱ŋ kuŋu bɛɛɛ awo̱re̱fɔɔ ya to̱ mò̱ bo̱ le̱e̱ abware̱se̱ŋ ne̱ ɔɔ kɔɔre̱ gyi‑o si, amɔ ɔ yɔwe̱ amo̱ se̱ ke̱gya. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ayaabraagyi amo̱ ne̱ aa le̱e̱ da e̱fa‑rɔ‑ɔ mɔ ye̱re̱ bo̱ sa se̱sɛ ne̱ o nu abware̱se̱ŋ‑ɔ, ne̱ kaye̱ mɔ‑rɔ atɔ tɔɔraasɛ, na katanne̱kpa ne̱ ka taare̱ a ka pe̱nna se̱sɛ‑ɔ, ya lwee mò̱ mfɛɛre̱‑rɔ, amɔ aa waa ko̱kyɔ kyo̱ŋ abware̱se̱ŋ ne̱ a bo̱ mò̱ kakpo̱nɔ‑rɔ‑ɔ. Amɔ mò̱ ko̱kɔɔre̱gyi‑o maa waa mò̱ sɛye̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Lalalo̱we̱‑ɔ e̱ gye̱ ayaabraagyi ne̱ aa le̱e̱ da swe̱e̱re̱ timaa‑o si‑o. Amo̱ mɔ e̱ ye̱re̱ bo̱ sa ase̱sɛ ne̱ baa nu amo̱ kaase̱, ne̱ aa waa ko̱kyɔ bamo̱ ŋkpo̱nɔ‑ɔ‑rɔ. Ne̱ ŋkee ane̱ŋ a ase̱sɛ‑ɔ bo̱ko̱ a waa itimaa na ke̱dame̱naŋsɛ bwe̱e̱tɔ, ne̱ bamo̱ bo̱ko̱ mɔ a waa na a kyɔ, ne̱ bamo̱ bo̱ko̱ mɔ a waa nyiire.” ");
INSERT INTO ncuNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ne̱ Yeesuu a be̱e̱ tɔwe̱ kitee ko̱ gywii bamo̱. Ne̱ ɔ yɛ, “Mo̱nꞌ nu ane̱ŋ ne̱ Wuribware̱ se̱ a kuwure‑o du‑o. N gye̱ ɔdɔɔpo̱ ko̱ e̱ bo̱‑rɔ aaa? Ne̱ ɔɔ ŋo̱nyaŋ ayaabraagyi timaa ko̱ mò̱ ko̱dɔɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kanye ko̱ saŋ ne̱ ɔke̱maa a di idi‑o, ne̱ mò̱ do̱ŋ a ywii ya ŋo̱nyaŋ afagyi bɔye̱ ko̱ bo̱ waa mò̱ yaabraa ko̱dɔɔ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ne̱ ayaabraagyi amo̱ a kwɛɛ, ne̱ aa bo̱ daŋ ko̱we̱, ne̱ ŋkee afagyi bɔye̱ amo̱ mɔ a bo̱ kwɛɛ lee amo̱ e̱ye̱e̱ ifuri. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Mfe̱ŋ‑ɔ ne̱ ɔdɔɔpo̱‑ɔ ayaafɔre̱ a bo̱ tɔwe̱ gywii mò̱ fe̱yɛ, ‘Ane̱ nyaŋpe̱, ne̱e̱ fo̱ a ŋo̱nyaŋ ayaabraagyi timaa ne̱e̱ ɛ? Ne̱ mfe̱ne̱ ne̱ e̱fa bɔye̱ mɔ a le̱e̱?’ ");
INSERT INTO ncuNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ne̱ oo lee kanɔ fe̱yɛ, ‘Ɔdo̱ŋ ko̱ ya waa amo̱‑ɔ.’ Ne̱ baa be̱e̱ bise mò̱ fe̱yɛ, ‘Amɔ fo̱ e̱ kpa fe̱yɛ ane̱ ya kyuwi e̱fa‑ɔ le̱e̱ yaabraa amo̱‑rɔ aaa?’ ");
INSERT INTO ncuNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ne̱ oo lee kanɔ fe̱yɛ, ‘Mo̱nꞌ yɔwe̱, a le̱e̱ fe̱yɛ mo̱ne̱ i kyuwi e̱fa‑ɔ, mo̱ne̱ i kyuwi yaabraa‑ɔ a mo̱nꞌ bo̱ tii si. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Amo̱se̱‑ɔ mo̱nꞌ sa a yaabraa‑ɔ na e̱fa‑ɔ pɛɛɛ daŋ bo̱ fo̱ ke̱te̱ŋŋe̱be̱e̱. Saŋ amo̱ ne̱ mo̱ e̱ tɔwe̱ a n gywii bamo̱ ne̱ ba te̱ŋŋe̱‑ɔ a bo̱ kyuwi e̱fa‑ɔ pwɛɛ. Na bo̱ ŋure e̱mo̱ bo̱ be̱ya apireŋ si apireŋ si na bo̱ kywɛɛ. Na bo̱ dɛɛ te̱ŋŋe̱ yaabraa‑ɔ bo̱ waa mo̱ akyeŋkyeŋku‑ro.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Ne̱ Yeesuu a da bamo̱ ke̱kpare̱ ko̱. Ɔ yɛ, “Wuribware̱ se̱ a kuwure‑o du ne̱e̱ fe̱yɛ kupurutugyi‑o. Kigyi mɔ du kagyingyii, amaa se̱sɛ ya dwii ke̱mo̱, amɔ ke̱ e̱ kwɛɛ a ke̱ daŋ kii kikiree, ne̱ ke̱ bo̱ e̱swe̱e̱ ko̱ kyo̱ŋ ayii pɛɛɛ. Na mbo̱gyii bo̱ kye̱na ke̱mo̱ se̱ waa bamo̱ asaa.” ");
INSERT INTO ncuNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ne̱ Yeesuu a be̱e̱ da bamo̱ ke̱kpare̱ mɔ fe̱yɛ, “Wuribware̱ se̱ a kuwure‑o du ne̱e̱ fe̱yɛ ɔkye̱e̱ a kpa a ɔ waa bodobodoo, ne̱ ɔɔ ba yiisi bo̱ waa e̱sam kyaŋse̱ bo̱rɔ‑rɔ, ne̱ oo nwiini, ne̱ e̱sam‑ɔ a tiŋ waa bwe̱e̱tɔ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Akpare̱ na itee ne̱ Yeesuu a bo̱ tɔwe̱ abware̱se̱ŋ gywii lamaŋ‑ɔ. Ɔ mo̱ŋ tɔwe̱ ke̱se̱ŋ ko̱ gywii bamo̱ na a mo̱ŋ gye̱ ke̱kpare̱ bɛɛɛ kitee. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ɔɔ waa ane̱ŋ ne̱e̱ na ke̱tɔ ne̱ Wuribware̱ kyaamɛɛ ko̱ a kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ waa kase̱ŋtiŋ fe̱yɛ, “Akpare̱ ne̱ mo̱ e̱ da a m bo̱ sa se̱ŋsa gywii bamo̱, na m bo̱ kaapo̱ bamo̱ ase̱ŋ ne̱ aa kwe̱e̱rɔ pwɛɛ ne̱ Wuribware̱ a dɛɛ twe̱e̱ kaye̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ne̱ ŋkee Yeesuu a le̱e̱ lamaŋ‑ɔ‑rɔ lwee lɔŋ‑nɔ. Mfe̱ŋ ne̱ mò̱ agyase̱po̱‑ɔ a ba mò̱ ase̱ tɔwe̱ gywii mò̱ fe̱yɛ, “Kaapo̱ ane̱ e̱fa kitee‑o kaase̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ne̱ ɔ yɛ, “Yooo. Ɔdɔɔpo̱ ne̱ ɔɔ ŋo̱nyaŋ ayaabraagyi timaa amo̱‑ɔ e̱ gye̱ mo̱, dimaadi mò̱ gyi‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mò̱ ko̱dɔɔ‑ɔ mɔ e̱ gye̱ kaye̱ mɔ. Ne̱ ayaabraagyi‑o mɔ e̱ gye̱ bamo̱ ne̱ bo̱ tii Wuribware̱ se̱ a kuwure‑o si‑o. E̱fa‑ɔ mɔ e̱ gye̱ bamo̱ ne̱ bo̱ gya Ɔbɔnsam a e̱kpa‑ɔ se̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ne̱ ɔdo̱ŋ ne̱ ɔɔ ŋo̱nyaŋ afagyi amo̱‑ɔ e̱ gye̱ Ɔbɔnsam fɔŋfɔŋ. Yaabraa ke̱te̱ŋŋe̱be̱e̱‑ɔ mɔ e̱ gye̱ saŋ ne̱ kaye̱ mɔ e̱ gye̱ kɛɛ‑ɔ, ne̱ bamo̱ ne̱ ba te̱ŋŋe̱ yaabraa‑ɔ mɔ e̱ gye̱ Wuribware̱ a mbɔɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Fe̱yɛ ane̱ŋ ne̱ ɔdɔɔpo̱‑ɔ a sa ne̱ baa kyuwi e̱fa‑ɔ swii bo̱ be̱ya kywɛɛ‑ɔ, ane̱ŋ dɛɛ ne̱ mo̱, dimaadi mò̱ gyi‑o, e̱ waa abɔye̱waapo̱ saŋ ne̱ kaye̱ mɔ e̱ gye̱ kɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mo̱ i suŋ mo̱ mbɔɔ a m bo̱ kyo̱ŋwe̱ kaye̱ mɔ‑rɔ na bo̱ ba bo̱ kpɔwe̱ ke̱tɔ ke̱maa ne̱ ke̱ gye̱ bɔye̱‑ɔ na abɔye̱waapo̱ pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Na mo̱ mbɔɔ‑ɔ lee bamo̱ le̱e̱ mo̱ kuwure‑o‑ro, na bo̱ twe̱e̱ bamo̱ waa ke̱de̱e̱kpɛɛtekii‑ro. Mfe̱ŋ‑ɔ ne̱ ba su, na ba duŋ nnɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Na ŋkee a saŋ ase̱sɛ timaa‑o, na bamo̱ itimaa‑o sa a bo̱ laŋŋe̱‑rɔ fe̱yɛ kyɔwe̱‑ɔ bamo̱ se̱ Wuribware̱ a kuwure‑o‑ro. Amo̱ e̱ gye̱ saase̱bɛɛ. Amo̱se̱‑ɔ ɔke̱maa ne̱ o de e̱se̱bɔ‑ɔ, o nu ase̱ŋ mɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ne̱ Yeesuu a tɔwe̱ kitee mɔ fe̱yɛ, “Wuribware̱ se̱ a kuwure‑o be̱e̱ ku du ne̱e̱ fe̱yɛ kalɔgyii na atanne̱ ne̱ baa kwii bo̱ kwe̱e̱rɔ ko̱dɔɔ ko̱‑rɔ‑ɔ. Ne̱ ke̱paafo̱wɔ ko̱ a dɔɔ ya puruwi si. Ne̱ ɔɔ be̱e̱ lɔŋŋɔ e̱se̱ bo̱ buŋ si nɛɛnɛɛ. Ne̱ mò̱ akatɔ a gyi fɛɛ. Mò̱ a kpa atanne̱ amo̱ kyo̱ŋ ke̱tɔ ke̱maa‑ɔ se̱‑ɔ, ne̱ oo kiŋŋi yɔ pe̱ ya fe mò̱ kapo̱tɛɛ pɛɛɛ, ne̱ ɔɔ yɔ ko̱dɔɔ‑ɔ wuye ase̱ ya sɔɔ ko̱dɔɔ amo̱ ne̱ atanne̱‑ɔ pure‑ro‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ne̱ Yeesuu a be̱e̱ ba kitee ko̱ bo̱ kaapo̱ bamo̱ ase̱ŋ. Ɔ yɛ, “Mo̱nꞌ be̱e̱ nu ane̱ŋ ne̱ Wuribware̱ se̱ a kuwure‑o du‑o. N gye̱ yawo̱gyipo̱ ko̱ e̱ bo̱‑rɔ aaa? Mò̱ kusuŋ e̱ gye̱ ataŋgyi dame̱naŋsɛ ko̱ ne̱ a bo̱ akukye‑ro‑o ko̱sɔɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ne̱ kake ŋko̱ ɔɔ ya ŋu ɔko̱ de ane̱ŋ a ataŋgyi‑o ke̱dame̱naŋsɛ ko̱. Amaa ke̱mo̱ yawo̱ bo̱ le̱ŋ fɛɛ. Amo̱se̱‑ɔ ne̱ oo kperi ke̱mo̱ se̱ yɔ pe̱ ya fe mò̱ kapo̱tɛɛ pɛɛɛ ya sɔɔ ke̱taŋgyi amo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ne̱ Yeesuu a be̱e̱ ba kitee ko̱ bo̱ kaapo̱ ane̱ŋ ne̱ Wuribware̱ se̱ a kuwure‑o du‑o. Ne̱ ɔ yɛ, “Ŋ gye̱ ŋkiŋgyi akrapo̱ ko̱ e̱ bo̱‑rɔ aaa? Ne̱ baa yɔ kisawu‑ro, ne̱ baa ya twe̱e̱ kra ŋkiŋgyi bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Bamo̱ a nya ŋkiŋgyi bwe̱e̱tɔ‑ɔ, ne̱ baa de̱e̱ kideŋbe ya kye̱na tesi ŋkiŋgyi‑o‑ro. Ne̱ baa swii ntimaa‑o waa bamo̱ atwe̱e̱twe̱e̱‑rɔ. Ne̱ baa swii mmo̱ ne̱ ba kisi kigyi‑o bo̱ twe̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Amo̱se̱‑ɔ kaye̱ bo̱ gye̱ kɛɛ‑ɔ, ane̱ŋ dɛɛ ne̱ ke̱tɔ e̱ ba. Wuribware̱ a mbɔɔ‑ɔ e̱ ba a bo̱ bo̱ lee ase̱sɛ bɔye̱‑ɔ le̱e̱ atimaa‑o‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Na bo̱ taa abɔye̱‑ɔ twe̱e̱ waa ke̱de̱e̱kpɛɛtekii‑o‑ro. Mfe̱ŋ‑ɔ ne̱ ba di‑ro, na ba su, na ba duŋwi nnɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yeesuu a tɔwe̱ itee na akpare̱ amo̱ lo̱we̱‑ɔ, ne̱ oo bise mò̱ agyase̱po̱ fe̱yɛ, “Ne̱e̱ mo̱ne̱ a nu itee mɔ kaase̱ ɛ?” Ne̱ bo̱ yɛ, “Ɔɔŋ, ane̱ a nu kaase̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Wuribware̱ mbraa akaapo̱po̱ kyɔ bo̱ nyi Wuribware̱ a atɔ‑ɔ ke̱kaapo̱. Amo̱se̱‑ɔ bamo̱ ɔko̱ ya be̱e̱ kii fe̱yɛ sukuu kigyi ne̱ oo suye Wuribware̱ se̱ a kuwure‑o e̱kpa‑ɔ ke̱gya se̱‑ɔ le̱e̱ mo̱ ase̱, ɔ waa ne̱e̱ fe̱yɛ atɔ wuye ko̱ ne̱ o de atɔ dame̱naŋsɛ po̱pwɛɛ na ade̱daa mò̱ ke̱kyaŋ‑nɔ‑ɔ, ne̱ oo lee amo̱ pɛɛɛ bo̱ kaapo̱ ase̱sɛ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yeesuu a tɔwe̱ itee na akpare̱ amo̱ lo̱we̱‑ɔ, ne̱ ɔɔ le̱e̱ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ne̱ ɔɔ yɔ mò̱ aye̱ Nasarɛt. Mò̱ a bo̱ mfe̱ŋ‑ɔ, ne̱ ɔɔ kaapo̱ ase̱sɛ abware̱se̱ŋ maŋ amo̱ a ke̱bware̱ko̱re̱kyaŋ‑ɔ‑rɔ. Bamo̱ a nu mò̱ ase̱ŋ‑ɔ, ne̱ aa kpe̱ŋ bamo̱ e̱ye̱e̱. Ne̱ baa tɔwe̱ bamo̱ wo̱re̱ wo̱re̱ fe̱yɛ, “Mfe̱ne̱ ne̱ ɔnyare̱ mɔ a nya mfɛɛre̱ mɔ le̱e̱? Ne̱ nsɛ ya sa mò̱ kpa fe̱yɛ ɔ waa akpe̱ŋe̱ye̱e̱tɔ mɔ ne̱ ane̱ a nu amo̱ ase̱ŋ‑ɔ? ");
INSERT INTO ncuNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ane̱ aye̱po̱ fɔŋfɔŋ e̱ gye̱ mò̱. N gye̱ kaape̱ŋtaa‑ɔ mò̱ gyi‑o ne̱e̱ e̱e̱e̱? N gye̱ mò̱ nyi e̱ gye̱ Mariya aaa? N gye̱ mò̱ tire‑ana e̱ gye̱ Yakubu na Yo̱sɛf na Simɔŋ na Yudas aaa? ");
INSERT INTO ncuNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Mò̱ pe̱kye̱e̱‑ana mo̱ŋ te mfe̱e̱ aaa? Ne̱ ŋkee mfe̱ne̱ ne̱ ɔɔ nya amo̱‑ɔ pɛɛɛ le̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ne̱ baa kine mò̱. Mfe̱ŋ ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Ba bu Wuribware̱ kyaamɛɛ to̱ŋ ke̱maa, amaa mò̱ fɔŋfɔŋ aye̱ awuye na mò̱ lɔŋ‑nɔ awuye fe̱raa mɔ mo̱ŋ de mò̱ bo̱ te̱e̱ sɛye̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Bamo̱ a mo̱ŋ kɔɔre̱ mò̱ gyi‑o si‑o, ɔ mo̱ŋ waa akpe̱ŋe̱ye̱e̱tɔ bwe̱e̱tɔ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Saŋ amo̱‑ɔ, ne̱ Hɛrɔd ne̱ ɔ gye̱ Galile̱ya swe̱e̱re̱ se̱ owure‑o a nu Yeesuu ase̱ŋ na ane̱ŋ ne̱ ɔɔ waa akpe̱ŋe̱ye̱e̱tɔ bwe̱e̱tɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ne̱ ɔɔ tɔwe̱ gywii mò̱ ayaafɔre̱‑ɔ fe̱yɛ, “Mo̱ e̱ kɔɔre̱ a n gyi fe̱yɛ ɔnyare̱ mɔ e̱ gye̱ Yohanee Osuubɔpo̱ ne̱ mo̱ a mɔɔ mò̱‑ɔ, ne̱ ɔɔ be̱e̱ kyiŋŋi le̱e̱ lowi‑ro. Amo̱ e̱ mo̱ŋ gye̱ ane̱ŋ fe̱raa, ɔ maa taare̱ a ɔ waa ane̱ŋ a akpe̱ŋe̱ye̱e̱tɔ mɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Mfaanɛɛ ne̱ Yohanee Osuubɔpo̱‑ɔ a wu. Saŋ ko̱, ne̱ Owure Hɛrɔd a kɔɔre̱ mò̱ tire Filipo mò̱ ka Hɛrɔde̱ya waare̱e̱. Ne̱ Yohanee Osuubɔpo̱‑ɔ mɔ a yii owure‑o si iluwi bwe̱e̱tɔ fe̱yɛ, “A mo̱ŋ bware fe̱yɛ fo̱ a kɔɔre̱ fo̱ tire mò̱ ka waare̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Mfaanɛɛ se̱‑ɔ, ne̱ Hɛrɔd a yo̱rɔwe̱ fe̱yɛ ɔ mɔɔ Yohanee. Amaa ɔ se̱re̱ lamaŋ ne̱ bo̱ yɛ Wuribware̱ a akyaamɛɛ‑ɔ ɔko̱ e̱ gye̱ Yohanee‑o. Amo̱ fe̱raa ke̱tɔ ne̱ owure‑o a waa‑ɔ e̱ gye̱ fe̱yɛ ɔɔ sa ne̱ baa kra Yohanee, ne̱ baa ba agbarabi bo̱ ŋure mò̱, ne̱ baa tii mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Owure‑o ko̱ko̱we̱ kasu kanɔ kigyi a fo̱‑ɔ, ne̱ ɔɔ te̱e̱ ase̱sɛ dabe̱ ko̱ bo̱ gyaŋŋe̱ fe̱yɛ bo̱ bo̱ gyi ateese mò̱ aye̱, na bo̱ gyi akatɔ. Ngyaŋŋe̱ amo̱‑rɔ, ne̱ owure‑o mò̱ ka Hɛrɔde̱ya mò̱ gyi kabregyii a lwee bo̱ŋ‑nɔ ɔ kyaa. Mò̱ a kyaa‑ɔ, ne̱ aa gyi owure‑o akatɔ bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Amo̱se̱‑ɔ ne̱ ɔɔ waa e̱taŋ fe̱yɛ ɔ sa kabregyii‑o ke̱tɔ ke̱maa ne̱ ɔ tɔwe̱ a o gywii mò̱ ɛ ɔ kpa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ne̱ kabregyii‑o a ya bise mò̱ nyi Hɛrɔde̱ya ke̱tɔ ne̱ ɔ tɔwe̱ gywii mò̱ fe̱yɛ ɔ kpa‑ɔ. Ne̱ ɔɔ be̱ŋŋaa ɛ, “Tɔwe̱ gywii mò̱ ɛ Yohanee Osuubɔpo̱‑ɔ kuŋu ne̱ fo̱ e̱ kpa kyaŋse̱‑rɔ mbe̱yɔmɔ.” Ne̱ kabregyii‑o a ya tɔwe̱ ane̱ŋ dɛɛ gywii owure‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","11","Owure‑o a nu ke̱tɔ ne̱ ɔ yɛ ɔ kpa‑ɔ, a mo̱ŋ waa mò̱ kɔne̱ pɛɛɛ. Amaa ane̱ŋ ne̱ ɔɔ kyɔ waa e̱taŋ lamaŋ‑nɔ se̱‑ɔ, ɔɔ sa kanɔ fe̱yɛ soogyaa ko̱ yɔ mfe̱ŋ ne̱ baa tii Yohanee‑o ya tuwi mò̱ kuŋu baa. Ne̱ ɔɔ ya tuwi Yohanee kuŋu‑o bo̱ waa kyaŋse̱‑rɔ taa yaa bo̱ sa kabregyii‑o, ne̱ mò̱‑ɔ mò̱ a taa yaa bo̱ sa mò̱ nyi. ");
INSERT INTO ncuNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ne̱ Yohanee a agyase̱po̱‑ɔ bo̱ko̱ a bo̱ so̱rɔ mò̱ kifuniŋ‑o yaa pure. Mfe̱ŋ ne̱ baa ya tɔwe̱ ke̱tɔ ne̱ kaa waa Yohanee‑o gywii Yeesuu. ");
INSERT INTO ncuNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yeesuu a nu ane̱ŋ ne̱ baa mɔɔ Yohanee‑o, ne̱ ɔɔ fa mfɛɛre̱ fe̱yɛ mò̱ aa mò̱ agyase̱po̱‑ɔ yɔ mfe̱ŋ ne̱ ase̱sɛ mo̱ŋ bo̱‑rɔ‑ɔ ya kyure kafwe̱e̱. Ne̱ mò̱ aa bamo̱ a lwee ko̱re̱e̱‑rɔ ba kpa a bo̱ pare̱ yɔ mfe̱ŋ ne̱ a du diŋŋ‑o. Amaa bo̱ko̱ a kyɔ ŋu mfe̱ŋ ne̱ ɔ kpa a ɔ yɔ‑ɔ, ne̱ ane̱ŋ se̱‑ɔ ase̱sɛ biribiri a le̱e̱ mfe̱ŋ a e̱maŋ‑ɔ‑rɔ me̱raa se̱ bo̱ bo̱rɔ nkyu e̱kɛɛkɛɛ se̱ bo̱ gya mò̱ se̱. Ne̱ baa se̱re̱ gye̱ mò̱ ŋkpɛɛ ya fo̱ mfe̱ŋ ne̱ ɔ kpa a ɔ yɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ko̱re̱e̱‑ɔ a bo̱ daŋ, ne̱ Yeesuu a le̱e̱‑ɔ, ne̱ oo ŋu ase̱sɛ biribiri amo̱, na bo̱ gywii mò̱. Ɔ mo̱ŋ lɛɛ kpa a ɔ kwaye̱ bamo̱, a le̱e̱ fe̱yɛ oo ŋu ane̱ŋ ne̱ baa pee akatɔ ba kpa a bo̱ ŋu mò̱‑ɔ. Ne̱ bamo̱ ase̱ŋ a waa mò̱ e̱wɛɛ. Ane̱ŋ se̱‑ɔ, alɔpo̱ ke̱maa ne̱ baa baa mò̱ ase̱‑ɔ, ɔɔ kya bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Amɔ kyɔwe̱ a kpa a ɔ twɛɛ‑ɔ, ne̱ mò̱ agyase̱po̱‑ɔ a bo̱ tɔwe̱ gywii mò̱ fe̱yɛ, “Kyɔwe̱ a lo̱we̱. Amo̱ a gye̱ e̱fa‑rɔ se̱‑ɔ, sa a ase̱sɛ‑ɔ yɔ e̱maŋ ne̱ e̱ maa mfe̱e̱‑ɔ‑rɔ, na bo̱ nya ya sɔɔ ko̱tɔko̱ gyi.” ");
INSERT INTO ncuNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “A mo̱ŋ bware fe̱yɛ bo̱ yɔ. Mo̱ne̱ fɔŋfɔŋ, mo̱nꞌ sa bamo̱ ko̱tɔko̱ a bo̱ gyi.” ");
INSERT INTO ncuNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ne̱ baa lee kanɔ fe̱yɛ, “Bodobodoo akuri anuu na ŋkiŋgyi ŋnyɔ wo̱re̱ kpeŋ ne̱ ane̱ de mfe̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ bo̱ taa baa mò̱ a ɔ ke̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ne̱ ɔ yɛ ase̱sɛ‑ɔ kye̱na e̱fa se̱ swe̱e̱re̱ mfe̱ŋ. Ne̱ ɔɔ taa bodobodoo akuri anuu‑o na ŋkiŋgyi ŋnyɔ‑ɔ waa mò̱ asare̱e̱‑rɔ, ne̱ ɔɔ de̱e̱re̱ so̱so̱, ne̱ ɔɔ sa Wuribware̱ aŋsɛ. Ne̱ ŋkee ɔɔ te̱ŋŋe̱‑rɔ bo̱ sa mò̱ agyase̱po̱‑ɔ, ne̱ baa ke‑ro sa ase̱sɛ‑ɔ pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bamo̱ pɛɛɛ a gyi bodobodoo‑o kpo̱ne̱, ne̱ baa wo̱ ŋkiŋgyi‑o kpo̱ne̱. Ne̱ ŋkee mò̱ agyase̱po̱‑ɔ a taa ake kudu anyɔ swii bodobodoo na ŋkiŋgyi mpupuriase̱e̱ ne̱ ŋ ya saŋ‑ɔ bo̱ bo̱rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Akye̱e̱ na ŋyaagyi ne̱ baa gyi ateese‑o e̱ mo̱ŋ tii si, anyare̱‑ɔ wo̱re̱ bo̱ ŋkpe̱ŋ nnuu. ");
INSERT INTO ncuNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Amo̱‑ɔ kamɛɛ‑rɔ, ne̱ Yeesuu a sa ne̱ mò̱ agyase̱po̱‑ɔ a lwee ko̱re̱e̱‑ɔ‑rɔ gye̱ mò̱ ŋkpɛɛ yɔ nkyu‑o nno̱ŋ a bo̱ŋbe̱‑ɔ se̱, ne̱ mò̱‑ɔ mò̱ a sii a ɔ sa lamaŋ‑ɔ kpa a bo̱ yɔ pe̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Mò̱ a brawe̱ bamo̱‑rɔ pɛɛɛ bo̱ kyo̱ŋwe̱ bamo̱ e̱pe̱‑ɔ, ne̱ ɔɔ yɔ ke̱be̱e̱ ko̱ se̱ ya ko̱re̱ ke̱bware̱ko̱re̱ mò̱ wo̱re̱ kpeŋ. Bo̱ fo̱ kanye‑o, Yeesuu wo̱re̱ bo̱ ke̱be̱e̱‑ɔ se̱ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Na mò̱ agyase̱po̱ a ko̱re̱e̱‑ɔ a fo̱ ke̱fɔ. Amɔ bo̱ mo̱ŋ lɛɛ ba taare̱ bo̱ pare̱ yɔ akatɔ‑rɔ, a le̱e̱ fe̱yɛ bamo̱ a pare̱ ba gyaŋŋaa afwii‑o si‑o, alaŋkpare̱ e̱ da bamo̱ a kiŋŋi. ");
INSERT INTO ncuNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Bo̱ fo̱ gye̱gyaye̱ kese‑ro, ne̱ Yeesuu a nare̱ nkyu‑o si fe̱yɛ mò̱ a naa swe̱e̱re̱‑ɔ ya to̱ bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Mò̱ agyase̱po̱‑ɔ a ŋu mò̱ a naa nkyu‑o si‑o, bo̱ mo̱ŋ pini mò̱, amo̱se̱‑ɔ kufu a nya bamo̱ pɛɛɛ, ne̱ baa fɛɛ‑rɔ fe̱yɛ, “Kye̱ŋaŋpo̱ ne̱e̱!” ");
INSERT INTO ncuNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Mfe̱ŋ ne̱ Yeesuu a tɔwe̱ fe̱yɛ, “Mo̱ ne̱e̱. Mo̱nꞌ nya kakpo̱nɔ. Mo̱ne̱ ma sa a kufu nya mo̱ne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ne̱ Peetroo yɛ, “Mo̱ nyaŋpe̱, amo̱ e̱ gye̱ fo̱ kase̱ŋtiŋ si, amo̱ fe̱raa sa kanɔ na n nare̱ nkyu‑o si ba fo̱ ase̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ne̱ Yeesuu a be̱ŋŋaa mò̱ fe̱yɛ, “Ba!” Amo̱se̱‑ɔ ne̱ Peetroo a le̱e̱ ko̱re̱e̱‑ɔ‑rɔ le̱e̱ ɔ naa nkyu‑o si ɔ yɔ Yeesuu ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Amaa afwii‑o a da mò̱ nkyu si mfe̱ŋ‑ɔ se̱‑ɔ, kufu a nya mò̱, ne̱ ɔɔ le̱e̱ o kirewi. Ne̱ ɔɔ faa‑rɔ tɔwe̱ ɛ, “Mo̱ nyaŋpe̱, mo̱rɔwe̱ mo̱!” ");
INSERT INTO ncuNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Puri amo̱‑rɔ, ne̱ Yeesuu a fo̱ mò̱ ase̱, ne̱ ɔɔ twe̱e̱ kra mò̱‑rɔ tɔwe̱ fe̱yɛ, “Fo̱ ko̱kɔɔre̱gyi ne̱ fo̱ de‑o mo̱ŋ kyɔ pɛɛɛ! E̱me̱ne̱ se̱ ne̱ fo̱ mo̱ŋ kɔɔre̱ gyi?” ");
INSERT INTO ncuNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Saŋ ne̱ Yeesuu na Peetroo a lwee ko̱re̱e̱‑ɔ‑rɔ‑ɔ, ne̱ afwii‑o a yɔwe̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ne̱ Yeesuu agyase̱po̱‑ɔ a gyɔŋŋɔ suŋ mò̱ ko̱re̱e̱‑ɔ‑rɔ mfe̱ŋ. Ne̱ bo̱ yɛ, “Kase̱ŋtiŋ si, Wuribware̱ mò̱ gyi‑o e̱ gye̱ fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ne̱ baa me̱raa se̱ ba yɔ nkyu‑o si. Ne̱ ŋkee bamo̱ ko̱re̱e̱‑ɔ a bo̱ daŋ Ginɛsarɛt ifuri si. ");
INSERT INTO ncuNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Mfe̱ŋ a ase̱sɛ‑ɔ a de̱ŋ ŋu Yeesuu‑o, ne̱ baa da kiboŋboŋ mmaŋgyii na e̱maŋ ne̱ e̱ maa mfe̱ŋ‑ɔ‑rɔ. Ne̱ ifuri‑o si a ase̱sɛ‑ɔ a taa bamo̱ alɔpo̱ pɛɛɛ baa Yeesuu ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ne̱ baa ko̱re̱ mò̱ fe̱yɛ ɔ dabo̱rɔ bamo̱ na bo̱ kpaare̱, bɛɛɛ ɔ sa alɔpo̱‑ɔ kpa na bo̱ dabo̱rɔ mò̱ waagya kanɔ gbaa. Bamo̱ ne̱ baa dabo̱rɔ mò̱ waagya‑ɔ pɛɛɛ a kpaare̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Saŋ ko̱ ne̱ Wuribware̱ mbraa akaapo̱po̱ na Farisii awuye ko̱ ne̱ baa le̱e̱ Yɛro̱salɛm maŋ‑nɔ‑ɔ a ba Yeesuu ase̱ bo̱ bise mò̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nte̱tɔ se̱ ne̱ fo̱ agyase̱po̱‑ɔ maa gya e̱kpa ne̱ ane̱ ade̱daapo̱ a kaapo̱ ane̱‑ɔ se̱? Ke̱tɔ se̱ ne̱ ane̱ a bise amo̱‑ɔ e̱ gye̱ fe̱yɛ bo̱ maa fwe̱e̱ asare̱e̱, pwɛɛ dɛɛ gyi ateese.” ");
INSERT INTO ncuNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “To, nte̱tɔ se̱ ne̱ mo̱ne̱ gbaa mo̱ne̱ maa gya Wuribware̱ fɔŋfɔŋ a mbraa‑ɔ se̱, ne̱ mo̱ne̱ gya mo̱ne̱ ase̱sɛ a e̱kpa‑ɔ se̱? ");
INSERT INTO ncuNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mo̱ne̱ nyi fe̱yɛ Wuribware̱ yɛ, ‘Bu fo̱ se̱ na fo̱ nyi’, na ‘Ɔke̱maa ne̱ ɔɔ lo̱ŋ mò̱ se̱ bɛɛɛ mò̱ nyi‑o, bo̱ mɔɔ mò̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Amaa mo̱ne̱ fe̱raa, mo̱ne̱ e̱ kaapo̱ ne̱e̱ fe̱yɛ atanne̱ bɛɛɛ ke̱tɔ timaa ko̱ ne̱ ɔko̱ de a ɔ bo̱ kya mò̱ se̱ na mò̱ nyi‑ro‑o, mò̱ ya taa yaa bo̱ sa Wuribware̱ na mò̱ kusuŋ, amo̱ fe̱raa Wuribware̱ e̱ bo̱, a kaapo̱ fe̱yɛ se̱sɛ‑ɔ a nya mò̱ e̱ye̱e̱, ne̱ mo̱ne̱ be̱e̱ mo̱ne̱ yɛ mò̱ se̱ na mò̱ nyi kitiri ne̱ ba wu‑o mo̱ŋ lɛɛ a gye̱ mò̱ ase̱ŋ ne̱e̱. Mò̱ ako̱we̱po̱ atanne̱ ke̱sa maa kaapo̱ ne̱e̱ fe̱yɛ o bu bamo̱ ne̱e̱ e̱e̱e̱? Mo̱ne̱ fɔŋfɔŋ a e̱kpa mɔ ne̱ mo̱ne̱ e̱ kaapo̱. A mo̱ŋ lɛɛ a gye̱ Wuribware̱ ase̱ŋ ne̱ mo̱ne̱ gya se̱. Ne̱ ŋkee mɔ Wuribware̱ ase̱ŋ mo̱ŋ lɛɛ a gye̱ ko̱tɔko̱ mo̱ne̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mo̱ne̱ nnɔ ŋnyɔ ŋnyɔ awuye mɔ, saŋ ne̱ Wuribware̱ kyaamɛɛ Isaya a kyo̱rɛɛ ase̱ŋ ko̱ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ, mo̱ne̱ ase̱ŋ ne̱ ɔɔ tɔwe̱, ɔ mo̱ŋ ba aye̱ba. Ɔɔ kyo̱rɛɛ ne̱e̱ fe̱yɛ Wuribware̱ yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ase̱sɛ mɔ de bamo̱ nnɔ kpaŋkpaŋ ne̱e̱ ba bo̱nyaa mo̱, amaa bamo̱ ŋkpo̱nɔ mo̱ŋ bo̱ mo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bamo̱ kusuŋ mɔ ne̱ ba suŋ mo̱‑ɔ gye̱ kwaa, ke̱ e̱ gye̱ ke̱gya mbraa na amaŋbe̱re̱ ne̱ dimaadi a kaapo̱‑ɔ se̱ dooo.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","11","Yeesuu a tɔwe̱ ase̱ŋ gywii Farisii awuye‑o na Wuribware̱ mbraa akaapo̱po̱‑ɔ lo̱we̱‑ɔ, ne̱ ɔɔ be̱e̱ te̱e̱ lamaŋ‑ɔ bo̱ gyaŋŋe̱ mò̱ ase̱, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱nꞌ lɔŋ e̱se̱bɔ, na mo̱nꞌ nu mo̱ ase̱, na mo̱nꞌ nu kaase̱ fe̱yɛ n gye̱ ke̱tɔ ne̱ se̱sɛ i gyi ɔ waa kame‑ro‑o e̱ gye̱ ne̱ ke̱ e̱ sa a ɔ waa iyisi. Amaa ke̱tɔ ne̱ ke̱ e̱ le̱e̱ mò̱ kanɔ‑rɔ‑ɔ e̱ gye̱ ne̱ ke̱ e̱ sa a ɔ waa iyisi.” ");
INSERT INTO ncuNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ne̱ Yeesuu agyase̱po̱‑ɔ a ba mò̱ ase̱ bo̱ tɔwe̱ gywii mò̱ fe̱yɛ, “Fo̱ mo̱ŋ nyi fe̱yɛ ase̱ŋ ne̱ fo̱ a tɔwe̱‑ɔ se̱‑ɔ, Farisii awuye‑o iduŋ a fwii fo̱ se̱ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ne̱ Yeesuu a da ke̱kpare̱ mɔ bo̱ lee kanɔ fe̱yɛ, “Ke̱tɔdwii ke̱maa ne̱ Wuribware̱, n se̱ ne̱ ɔ bo̱ so̱so̱‑ɔ, mo̱ŋ dwii‑o o kyuwi. ");
INSERT INTO ncuNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Farisii awuye‑o fe̱raa, mo̱ne̱ ma kaŋ be̱ŋŋaa bamo̱. Bo̱ yɛ bo̱ gye̱ te̱napo̱ kayii‑ro akrapo̱ ne̱e̱. Amaa bamo̱ fɔŋfɔŋ mo̱ŋ ke̱e̱. Te̱napo̱ ya kra te̱napo̱ kiyii‑ro a ɔ gye̱ mò̱ ŋkpɛɛ, bamo̱ pɛɛɛ e̱ le̱e̱ a bo̱ le̱e̱ da ke̱maŋtaŋ‑nɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ne̱ Peetroo yɛ, “Fo̱ yɛ n gye̱ ke̱tɔ ne̱ se̱sɛ i gyi ɔ waa kame‑ro‑o e̱ gye̱ ne̱ ke̱ e̱ sa a ɔ waa iyisi, kaapo̱ ane̱ ke̱mo̱ kaase̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ne̱ Yeesuu yɛ, “Ntɔ se̱ ne̱ mo̱ne̱ du fe̱yɛ ase̱sɛ amo̱‑ɔ ne̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ntɔ se̱ ne̱ mo̱ne̱ mo̱ŋ nu ase̱ŋ amo̱ kaase̱‑ɔ ne̱e̱? Mo̱nꞌ nu fe̱yɛ ke̱tɔ ne̱ se̱sɛ i gyi‑o i lwee mò̱ kanɔ‑rɔ ne̱e̱ na ko̱ yɔ mò̱ kame‑ro na ŋkee ɔ kɔɔ bo̱ twe̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Amaa ke̱tɔ ne̱ ke̱ e̱ le̱e̱ mò̱ kanɔ‑rɔ‑ɔ fe̱raa a le̱e̱ mò̱ kakpo̱nɔ‑rɔ ne̱e̱. Ke̱mo̱ e̱ gye̱ ne̱ ke̱ e̱ sa ne̱ ɔ waa iyisi. ");
INSERT INTO ncuNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","A le̱e̱ fe̱yɛ se̱sɛ kakpo̱nɔ‑rɔ ne̱ mfɛɛre̱ bɔye̱ e̱ le̱e̱, ne̱ ka sa ne̱ ɔ mɔɔ mò̱ bɛɛko̱, ne̱ ɔ waa kakye̱e̱kpa bɛɛɛ kanyare̱kpa, ne̱ o ywii, ne̱ ɔ te̱ŋ mò̱ bɛɛko̱ kanɔ, ne̱ ɔ tɔwe̱ ase̱ŋ bɔye̱ o kye mò̱ bɛɛko̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ane̱ŋ a atɔ mɔ e̱ gye̱ ne̱ a sa ne̱ se̱sɛ e̱ waa iyisi. Amaa mò̱ ya gyi ateese na ɔ mo̱ŋ fwe̱e̱ asare̱e̱, a maa taare̱ a a sa a ɔ waa iyisi.” ");
INSERT INTO ncuNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yeesuu a le̱e̱ mfe̱ŋ‑ɔ, ne̱ oo ywii le̱e̱ bamo̱ fɔŋfɔŋ Isireelii awuye swe̱e̱re̱ se̱ yɔ ifuri ko̱ ne̱ ɔ da ɔ maa Tiro na Sidɔŋ e̱maŋ‑ɔ se̱, na ɔ ya kyure kafwe̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Amaa ɔkye̱e̱ ko̱ a ŋu mò̱ a ba‑ɔ, ne̱ ɔɔ ba mò̱ ase̱. Ɔkye̱e̱ mɔ mo̱ŋ gye̱ Yudaanyi, ɔ gye̱ Kanaŋnyi, ne̱ o te ifuri amo̱ se̱‑ɔ. Ne̱ ɔɔ ko̱re̱ Yeesuu fe̱yɛ, “Mo̱ nyaŋpe̱, Deefid mò̱ nana, ŋu mo̱ e̱wɛɛ na fo̱ kya mo̱‑rɔ. Ibrisi ko̱ te mo̱ kayaagyi kye̱e̱sɛ se̱, ne̱ e̱e̱ tɔɔraa mò̱ bwe̱e̱tɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Amaa Yeesuu mo̱ŋ be̱ŋŋaa mò̱. Amo̱se̱‑ɔ ne̱ oo su ɔ ko̱re̱ mò̱ ane̱ŋ‑aaa. Ne̱ ŋkee Yeesuu agyase̱po̱‑ɔ a bo̱ ko̱re̱ mò̱ fe̱yɛ, “Ane̱ nyaŋpe̱, gya ɔkye̱e̱ amo̱ bo̱ kyo̱ŋwe̱, a le̱e̱ fe̱yɛ ɔ gya ane̱ se̱ ane̱ŋ‑aaa, na ɔ maa yɔwe̱ e̱lawo̱ mɔ ko̱waa.” ");
INSERT INTO ncuNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ne̱ ŋkee Yeesuu a tɔwe̱ gywii ɔkye̱e̱‑ɔ fe̱yɛ, “Fo̱ mo̱ŋ nyi fe̱yɛ mo̱ kusuŋ ne̱ Wuribware̱ a suŋ mo̱ a m bo̱ waa‑ɔ e̱ gye̱ fe̱yɛ ŋ yɔ mo̱ fɔŋfɔŋ Isireelii awuye ne̱ baa fo̱‑ɔ ase̱, na m bo̱ buwi bamo̱ kiŋŋaa baa Wuribware̱ ase̱ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mfe̱ŋ ne̱ ɔkye̱e̱‑ɔ a bo̱ kpuni aŋurii Yeesuu ayaa‑rɔ tɔwe̱ fe̱yɛ, “Mo̱ nyaŋpe̱, mo̱ e̱ ko̱re̱ fo̱ ne̱e̱ fe̱yɛ fo̱ bo̱ kya mo̱‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ne̱ Yeesuu yɛ, “N de ateese mo̱ e̱ sa Wuribware̱ mò̱ gyi‑ana. Ne̱ mo̱ ya taa ako̱ sa bamo̱ ne̱ ane̱ ase̱sɛ e̱ te̱e̱ fe̱yɛ igyono‑o, a bware aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ne̱ ɔkye̱e̱‑ɔ yɛ, “To, mo̱ a nu, mo̱ nyaŋpe̱, amaa igyono maa kisi bamo̱ anyaŋpe̱ a anɔwo̱re̱ ne̱ a le̱e̱ a da swe̱e̱re̱‑ɔ kigyi.” ");
INSERT INTO ncuNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mò̱ a tɔwe̱ ane̱ŋ‑ɔ, ne̱ Yeesuu mɔ a be̱e̱ tɔwe̱ gywii mò̱ fe̱yɛ, “Ɔpe̱kye̱e̱, fo̱ a kɔɔre̱ mo̱ gyi bwe̱e̱tɔ‑ɔ se̱‑ɔ, ke̱tɔ ne̱ fo̱ a ko̱re̱ mo̱‑ɔ, fo̱ e̱ nya.” Puri amo̱‑rɔ ne̱ ɔkye̱e̱‑ɔ mò̱ gyi kye̱e̱sɛ‑ɔ a kpaare̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ne̱ Yeesuu a le̱e̱ mfe̱ŋ kiŋŋi yɔ Galile̱ya swe̱e̱re̱ se̱ ɔ naa mfe̱ŋ a ke̱pare̱ dabe̱‑ɔ e̱kɛɛkɛɛ se̱. Ne̱ ɔɔ de̱e̱ ke̱be̱e̱ ko̱ kafwe̱e̱ ya kye̱na. ");
INSERT INTO ncuNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mfe̱ŋ‑ɔ ne̱ ase̱sɛ biribiri a ba mò̱ ase̱. Bamo̱ bo̱ko̱ a baa agyabɔɔ na ate̱napo̱ na asare̱e̱ wusɛ awuye na mmu na bamo̱ ne̱ ba lɔ alɔgyi e̱wo̱re̱se̱ e̱wo̱re̱se̱‑ɔ mò̱ akatɔ‑rɔ. Ne̱ ɔɔ kya bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Lamaŋ ne̱ baa ba Yeesuu ase̱‑ɔ a ŋu ane̱ŋ ne̱ puri amo̱‑rɔ mmu a sa se̱ŋsa, ne̱ asare̱e̱ wusɛ awuye a asare̱e̱‑ɔ a kpaare̱, ne̱ agyabɔɔ a ko̱so̱ nare̱ bamo̱ ayaa se̱, ne̱ ate̱napo̱ akatɔ a buŋŋi‑o, ne̱ e̱ye̱e̱ a kpe̱ŋ bamo̱, ne̱ baa kyo̱rɔ Wuribware̱, ne̱ bo̱ yɛ, “Ane̱ Isireelii awuye a nyaŋpe̱‑ɔ ke̱yaale̱ŋ kyɔ bwe̱e̱tɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ne̱ ŋkee Yeesuu a te̱e̱ mò̱ agyase̱po̱‑ɔ baa mò̱ ase̱, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Ase̱sɛ mɔ ase̱ŋ bo̱ mo̱ e̱wɛɛ, a le̱e̱ fe̱yɛ bamo̱ a ba mo̱ ase̱ mfe̱e̱‑ɔ ŋke nsa ne̱e̱. Amo̱se̱‑ɔ bamo̱ ateese pɛɛɛ a lo̱we̱. Ne̱ mo̱‑ɔ mo̱ ya sa ne̱ baa yɔ e̱pe̱ na mo̱ŋ sa bamo̱ ateese, ako̱ŋ e̱ mɔɔ bo̱ko̱ kpa‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ne̱ mò̱ agyase̱po̱‑ɔ a be̱ŋŋaa mò̱ fe̱yɛ, “Kimukee mɔ‑rɔ mfe̱ne̱ ne̱ ɔko̱ e̱ nya ase̱sɛ de̱maŋte̱ mɔ kanɔ se̱ ateese?” ");
INSERT INTO ncuNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","To, ne̱ Yeesuu a bise bamo̱ fe̱yɛ, “Bodobodoo akuri afe̱ne̱ ne̱ mo̱ne̱ de?” Ne̱ bo̱ yɛ, “Ane̱ de bodobodoo akuri asunoo na ŋkiŋgyi ngyingyii kafwe̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ne̱ Yeesuu a sa ne̱ lamaŋ‑ɔ a kye̱na swe̱e̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ne̱ ɔɔ taa bodobodoo akuri asunoo amo̱ na ŋkiŋgyi amo̱, ne̱ ɔɔ sa Wuribware̱ aŋsɛ we̱e̱ se̱. Ne̱ ɔɔ te̱ŋŋe̱‑rɔ, ne̱ ɔɔ taa sa mò̱ agyase̱po̱‑ɔ fe̱yɛ bo̱ ke‑ro sa bamo̱. Ne̱ baa ke‑ro sa ase̱sɛ‑ɔ pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ne̱ bamo̱ pɛɛɛ a gyi ateese amo̱ kpo̱ne̱. Ne̱ ŋkee mò̱ agyase̱po̱‑ɔ a ya swii ateese mpupuriase̱e̱‑ɔ bo̱ bo̱rɔ ake adabe̱ asunoo. ");
INSERT INTO ncuNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Akye̱e̱ na ŋyaagyi e̱ mo̱ŋ tii si, anyare̱ ne̱ baa gyi ateese amo̱‑ɔ wo̱re̱ bo̱ ŋkpe̱ŋ nna. ");
INSERT INTO ncuNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yeesuu a sa ne̱ ase̱sɛ‑ɔ pɛɛɛ mɔ a brawe̱‑rɔ‑ɔ, ne̱ oo lwee ko̱re̱e̱‑rɔ ya daŋ nkyu‑o nno̱ŋ a bo̱ŋbe̱‑ɔ se̱ me̱raa maŋ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Magadaŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ne̱ Farisii awuye‑o na Sadukii awuye‑o bo̱ko̱ a ba Yeesuu ase̱ na bo̱ bo̱ ŋu fe̱yɛ mò̱ ke̱yaale̱ŋ ne̱ o de ɔ waa akpe̱ŋe̱ye̱e̱tɔ‑ɔ a le̱e̱ Wuribware̱ ase̱ kase̱ŋtiŋ ne̱e̱ e̱e̱e̱. Ane̱ŋ se̱‑ɔ, baa tɔwe̱ gywii mò̱ ne̱e̱ fe̱yɛ, “Sa a ko̱tɔko̱ le̱e̱ Wuribware̱ se̱ na ane̱ nya ŋu fe̱yɛ Wuribware̱ bo̱ fo̱ ase̱ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Kyɔwe̱ e̱ twɛɛ‑rɔ, ne̱ ke̱tɔ ya pee‑ro‑o, mo̱ne̱ e̱ tɔwe̱ ne̱e̱ fe̱yɛ nyaŋe̱ ane̱ e̱ nya kaye̱‑rɔ kaye̱e̱yuri. ");
INSERT INTO ncuNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Gye̱gyaye̱ tututu mɔ awo̱re̱ ya biri, mo̱ne̱ e̱ tɔwe̱ ne̱e̱ fe̱yɛ bware̱ e̱ kpa a ɔ ba. Mo̱ne̱ a taare̱ mo̱ne̱ e̱ de̱e̱re̱ so̱so̱ mo̱ne̱ i pini ke̱tɔ ne̱ ke̱ e̱ ba kaye̱‑rɔ‑ɔ, e̱me̱ne̱ se̱ ne̱ mo̱ne̱ maa taare̱ a mo̱nꞌ kaapo̱ ke̱tɔ ne̱ ke̱ e̱ waa kaye̱ mɔ‑rɔ mbe̱yɔmɔ‑ɔ kaase̱ fe̱raa? ");
INSERT INTO ncuNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ndɔɔ a kaye̱ mɔ‑rɔ a ase̱sɛ‑ɔ gye̱ ase̱sɛ bɔye̱ ne̱ bo̱ maa kɔɔre̱ Wuribware̱ ba gyi‑o. Mo̱ne̱ yɛ ŋ waa akpe̱ŋe̱ye̱e̱tɔ bo̱ kaapo̱ mo̱ne̱. Amaa ma waa amo̱ a n sa mo̱ne̱, amɔ akpe̱ŋe̱ye̱e̱tɔ ko̱ ne̱ aa waa Yonaa de̱daa‑ɔ se̱ wo̱re̱ ne̱ mo̱ e̱ waa a m bo̱ kaapo̱ mo̱ne̱.” Ne̱ ɔɔ le̱e̱ bamo̱ ase̱ o yii. ");
INSERT INTO ncuNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ a be̱e̱ pare̱ nkyu si yɔ nno̱ŋ a bo̱ŋbe̱‑ɔ se̱. Amaa mò̱ agyase̱po̱‑ɔ a taŋ se̱ fe̱yɛ bo̱ sɔɔ bodobodoo pwɛɛ ne̱ baa dɛɛ ba. ");
INSERT INTO ncuNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Mfe̱ŋ ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱nꞌ sa Farisii awuye na Sadukii awuye amo̱ se̱, a le̱e̱ fe̱yɛ bo̱ de yiisi ko̱ ba waa bodobodoo ne̱ o tiŋ‑o na ɔ mo̱ŋ bo̱ kɔne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","To, ne̱ mò̱ agyase̱po̱‑ɔ a le̱e̱ ba tɔwe̱ ba gywii abɛɛ fe̱yɛ, “Ane̱ŋ ne̱ ane̱ mo̱ŋ de bodobodoo‑o si ne̱ ɔɔ tɔwe̱ ane̱ŋ‑ɔ, bɛɛɛ?” ");
INSERT INTO ncuNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yeesuu mɔ a nyi ke̱tɔ ne̱ ba tɔwe̱‑ɔ se̱‑ɔ, ne̱ oo bise bamo̱ fe̱yɛ, “Nte̱tɔ ne̱e̱ ne̱ mo̱ne̱ e̱ tɔwe̱ mo̱ne̱ ke̱‑mo̱ŋ‑de bodobodoo ase̱ŋ? E̱me̱ne̱ se̱ ne̱ mo̱ne̱ ko̱kɔɔre̱gyi mo̱ŋ tɛɛ waa ko̱kyɔ? ");
INSERT INTO ncuNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mo̱ne̱ mo̱ŋ tɛɛ nu mo̱ ke̱kaapo̱‑ɔ kaase̱ ne̱e̱ bɛɛɛ? Mo̱ne̱ a taŋ se̱ fe̱yɛ mo̱ a te̱ŋŋe̱ bodobodoo akuri anuu‑o‑ro sa ase̱sɛ ŋkpe̱ŋ nnuu‑o, ne̱ baa gyi kpo̱ne̱ aaa? Mo̱ne̱ a taŋ ake ne̱ mo̱ne̱ a swii mpupuriase̱e̱‑ɔ waa‑rɔ‑ɔ kanɔ se̱ aaa? ");
INSERT INTO ncuNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Mo̱ a be̱e̱ te̱ŋŋe̱ bodobodoo akuri asunoo‑o‑ro sa ase̱sɛ ŋkpe̱ŋ nna‑ɔ, ne̱ baa gyi kpo̱ne̱‑ɔ, mo̱ne̱ mo̱ŋ nyiŋŋi ake ne̱ mo̱ne̱ a be̱e̱ swii mpupuriase̱e̱‑ɔ waa‑rɔ‑ɔ kanɔ ne̱e̱ bɛɛɛ? ");
INSERT INTO ncuNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ne̱ e̱me̱ne̱ se̱ ne̱ mo̱ e̱ tɔwe̱ gywii mo̱ne̱ fe̱yɛ mo̱nꞌ sa Farisii awuye na Sadukii awuye a yiisi‑o si, ne̱ mo̱ne̱ maa nu kaase̱ fe̱yɛ n gye̱ bodobodoo ase̱ŋ ne̱ mo̱ e̱ tɔwe̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ne̱ ŋkee mò̱ agyase̱po̱‑ɔ a nu kaase̱ fe̱yɛ n gye̱ yiisi ne̱ bo̱ de ba waa bodobodoo‑ro‑o ase̱ŋ ne̱ ɔ tɔwe̱. Amaa oo yii bamo̱ se̱ bo̱ le̱e̱ ane̱ŋ ne̱ Farisii awuye‑o na Sadukii awuye‑o maa kaapo̱ ke̱bware̱suŋ kpa se̱‑ɔ se̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Saŋ ko̱ ne̱ Yeesuu a yɔ ifuri ko̱ ne̱ e̱ maa Kaye̱sare̱ya Filipii maŋ‑ɔ se̱‑ɔ. Bamo̱ a naa ba yɔ‑ɔ, ne̱ oo bise mò̱ agyase̱po̱‑ɔ fe̱yɛ, “E̱me̱ne̱ ne̱ ase̱sɛ e̱ te̱e̱ mo̱, dimaadi mò̱ gyi‑o?” ");
INSERT INTO ncuNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ne̱ baa lee kanɔ fe̱yɛ, “Bo̱ko̱ yɛ fo̱ gye̱ Wuribware̱ a akyaamɛɛ ne̱ baa dɛɛ kye̱na‑ɔ ɔko̱ ne̱ oo kyiŋŋi le̱e̱ lowi‑ro, fe̱yɛ Yohanee Osuubɔpo̱‑ɔ, bɛɛɛ Iliya, bɛɛɛ Yɛrɛme̱ya, bɛɛɛ bamo̱‑rɔ ɔko̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ne̱ oo bise mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Ne̱ mo̱ne̱ mɔ mo̱ne̱ yɛ nsɛ e̱ gye̱ mo̱‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ne̱ Simɔŋ Peetroo a be̱ŋŋaa fe̱yɛ, “Fo̱ e̱ gye̱ Kristoo, Wuribware̱ ne̱ mò̱ wo̱re̱ dooo i de ŋkpa‑ɔ mò̱ gyi ne̱ Wuribware̱ yɛ o suŋ ane̱ ase̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Yohanee mò̱ gyi Simɔŋ mɔ, fo̱ de ŋyure, a le̱e̱ fe̱yɛ n gye̱ nyiŋkpasɛ ya tɔwe̱ kase̱ŋtiŋ mɔ gywii fo̱, amaa n se̱ Wuribware̱ ne̱ ɔ bo̱ so̱so̱‑ɔ ya tɔwe̱ gywii fo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Fo̱ ke̱ŋasɛnyare̱ e̱ gye̱ Peetroo, ne̱ ke̱mo̱ kaase̱ e̱ gye̱ ke̱fo̱re̱‑ɔ bɛɛɛ? Fo̱ du ne̱e̱ fe̱yɛ ke̱fo̱re̱‑ɔ. Mo̱ e̱ tɔwe̱ mo̱ i gywii fo̱ fe̱yɛ ke̱fo̱re̱ mɔ se̱ ne̱ mo̱ e̱ pwɛɛ mo̱ asɔre̱e̱ ke̱kyaŋ a m bo̱ ye̱ra, na Ɔbɔnsam na mò̱ kamɛɛ‑rɔ awuye ma taare̱ a bo̱ nye̱ra ke̱mo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Fo̱ ne̱ mo̱ e̱ taa Wuribware̱ se̱ a e̱safo̱wa‑ɔ a n sa. Po̱ne̱ ke̱maa ne̱ fo̱ e̱ taye̱ swe̱e̱re̱ se̱ mfe̱e̱‑ɔ, Wuribware̱ ne̱ ɔ bo̱ so̱so̱‑ɔ a taye̱. Ne̱ po̱ne̱ ke̱maa ne̱ fo̱ e̱ twe̱e̱‑rɔ swe̱e̱re̱ se̱ mfe̱e̱‑ɔ, Wuribware̱ ne̱ ɔ bo̱ so̱so̱‑ɔ a twe̱e̱‑rɔ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Mfe̱ŋ ne̱ oo yii mò̱ agyase̱po̱‑ɔ se̱ fe̱yɛ bo̱ ma kaŋ tɔwe̱ gywii ɔko̱ fe̱yɛ mò̱ e̱ gye̱ Kristoo ne̱ Wuribware̱ yɛ o suŋ a ɔ bo̱ kyo̱ŋwe̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Le̱e̱ kake amo̱ bo̱ yɔ, ne̱ Yeesuu a le̱e̱ ɔ kaapo̱‑rɔ ɔ tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “A tiri fe̱yɛ ŋ yɔ Yɛro̱salɛm maŋ‑nɔ. Na mfe̱ŋ a maŋ abre̱sɛ na Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ na Wuribware̱ mbraa akaapo̱po̱‑ɔ sa a n gyi awo̱re̱fɔɔ bwe̱e̱tɔ. Na bo̱ mɔɔ mo̱. Amaa ke̱mo̱ ŋke nsa, Wuribware̱ i kyiŋŋi mo̱ a ɔ le̱e̱ lowi‑ro.” ");
INSERT INTO ncuNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ne̱ Peetroo a lee mò̱ keri si, ne̱ ɔɔ tɔwe̱ gywii mò̱ fe̱yɛ, “Wuribware̱ sa a a ma ba ane̱ŋ. Amo̱‑ɔ ma ba fo̱ se̱ daa.” ");
INSERT INTO ncuNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ne̱ Yeesuu a buruwaa tɔwe̱ gywii Peetroo fe̱yɛ, “Ɔbɔnsam, nare̱ le̱e̱ mo̱ ase̱. Peetroo, fo̱ du ne̱e̱ fe̱yɛ ke̱fo̱re̱ ne̱ ki i tii mo̱ e̱kpa‑ɔ. Fo̱ mfɛɛre̱ mo̱ŋ le̱e̱ Wuribware̱ ase̱, Se̱sɛ mfɛɛre̱ ne̱ fo̱ de.” ");
INSERT INTO ncuNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Mfe̱ŋ ne̱ Yeesuu a tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Ɔko̱ ne̱ ɔ kpa a ɔ gya mo̱ se̱‑ɔ yɔwe̱ ko̱waa ke̱tɔ ne̱ ke̱ e̱ pre̱ mò̱‑ɔ, na ɔ so̱rɔ mò̱ fɔŋfɔŋ kiyii kpare̱-abɛɛ‑rɔ gya mo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","A le̱e̱ fe̱yɛ ɔko̱ ne̱ ɔ kpa a ɔ nya mò̱ e̱ye̱e̱ le̱e̱ lowi ase̱‑ɔ, lowi e̱ nya mò̱ nsu pɛɛɛ. Ɔko̱ mɔ ne̱ o kperi mo̱ se̱ na o wu‑o e̱ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","To̱nɔ mo̱ ne̱ se̱sɛ e̱ nya fe̱yɛ mò̱ a nya kaye̱‑rɔ atɔ pɛɛɛ, na bo̱ le̱e̱ ane̱ŋ se̱ na ɔ paŋ kye̱nakpa Wuribware̱ ase̱? A mo̱ŋ de to̱nɔ. Sɛye̱ mo̱ŋ bo̱‑rɔ ne̱ ɔ taare̱ a ɔ bo̱ sɔɔ kye̱nakpa amo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mo̱nꞌ nu mo̱ ase̱. Saŋ ko̱ e̱ ba a ɔ bo̱ ba ne̱ n se̱ Wuribware̱ a ke̱laŋŋe̱rɔ‑ɔ e̱ le̱e̱ so̱so̱ a ko̱ we̱e̱ swe̱e̱re̱ se̱, na mo̱, dimaadi mò̱ gyi‑o, na n se̱ a mbɔɔ‑ɔ le̱e̱ ba. Na mo̱‑ɔ n gyi ase̱sɛ pɛɛɛ ase̱ŋ Wuribware̱ ayaa‑rɔ, na ŋ ka ɔke̱maa e̱bɔye̱ bɛɛɛ itimaa ne̱ ɔɔ waa‑ɔ ko̱kɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ bo̱ko̱ bo̱ mfe̱e̱ na bo̱ ma wu, amɔ baa ŋu mo̱, dimaadi mò̱ gyi‑o, a ba fe̱yɛ owure‑o pwɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ŋke nsiye a kyo̱ŋ fe̱yɛ Yeesuu a tɔwe̱ ase̱ŋ mɔ‑ɔ, ne̱ oo lee Peetroo na Yakubu na Yakubu mò̱ tire Yohanee, ne̱ mò̱ aa bamo̱ wo̱re̱ a yɔ ke̱be̱e̱ so̱swe̱e̱ ko̱ so̱so̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Bamo̱ a bo̱ mfe̱ŋ‑ɔ, ne̱ baa ŋu fe̱yɛ Yeesuu a kyurowi. Mò̱ akatɔ‑rɔ a to̱re̱ se̱ fe̱yɛ kyɔwe̱, ne̱ mò̱ atɔ buŋsɛ a fwiiri pare̱pare̱pare̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Puri amo̱‑rɔ ne̱ baa ŋu fe̱yɛ anyare̱ anyɔ ko̱ na Yeesuu ye̱re̱, na ba sa se̱ŋsa. Ne̱ baa pini fe̱yɛ Wuribware̱ mbraa ɔsapo̱ Mosis na Wuribware̱ akyaamɛɛ Iliya ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ne̱ Peetroo a tɔwe̱ gywii Yeesuu fe̱yɛ, “Mo̱ nyaŋpe̱, a bware fɛɛ fe̱yɛ ane̱ a bo̱ mfe̱e̱. Fo̱ e̱ kpa fe̱raa, mo̱ e̱ waa abwii asa, fo̱ ko̱ŋko̱, na Mosis ko̱ŋko̱, na Iliya ko̱ŋko̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Peetroo a saŋ ɔ sa se̱ŋsa‑ɔ, ne̱ ko̱wo̱re̱ to̱re̱se̱sɛ kuyayu a le̱e̱ so̱so̱ bo̱ dɔŋŋɔ bamo̱ se̱. Ne̱ bo̱re̱ ko̱ a le̱e̱ ko̱wo̱re̱‑ɔ‑rɔ tɔwe̱ fe̱yɛ, “Mo̱nꞌ ke̱e̱ mo̱ gyi timaa ne̱ mo̱ e̱ kpa mò̱ ase̱ŋ bwe̱e̱tɔ, ne̱ mo̱ akatɔ a gyi mò̱ se̱‑ɔ. Mo̱nꞌ nu mò̱ ase̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Agyase̱po̱ asa amo̱ a nu bo̱re̱ amo̱‑ɔ, kufu a nya bamo̱ fɛɛ. Amo̱se̱‑ɔ ne̱ baa le̱e̱ da bamo̱ mme si, ne̱ baa be̱ra akatɔ bo̱ buŋ swe̱e̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ne̱ Yeesuu a bo̱ dabo̱rɔ bamo̱ tɔwe̱ fe̱yɛ, “Mo̱nꞌ ko̱so̱, mo̱ne̱ ma sa a kufu nya mo̱ne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Bamo̱ a yase̱ akatɔ de̱e̱re̱‑ɔ, bo̱ mo̱ŋ lɛɛ ŋu ɔko̱ bo̱ mfe̱ŋ, amɔ Yeesuu wo̱re̱ kpeŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Bamo̱ a kpo̱ro̱we̱ ke̱be̱e̱‑ɔ se̱ ba ba kaase̱‑ɔ, ne̱ Yeesuu a da bamo̱ nnɔ se̱ fe̱yɛ, “Mo̱ne̱ ma kaŋ tɔwe̱ atɔ mɔ ne̱ mo̱ne̱ a ŋu‑o gywii ɔko̱, amɔ bo̱ fo̱ saŋ ne̱ Wuribware̱ i kyiŋŋi mo̱, dimaadi mò̱ gyi‑o, a ɔ le̱e̱ lowi‑ro‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ne̱ mò̱ agyase̱po̱ asa‑ɔ a bise mò̱ fe̱yɛ, “Nte̱tɔ se̱ ne̱ Wuribware̱ mbraa akaapo̱po̱‑ɔ e̱ tɔwe̱ fe̱yɛ Iliya amo̱ ne̱ ane̱ a ŋu‑o e̱ gye̱ ne̱ ɔ gye̱ Kristoo ŋkpɛɛ a ɔ ba‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Kase̱ŋtiŋ si Iliya e̱ gye̱ ne̱ ɔ gye̱ ŋkpɛɛ a ɔ ba na ɔ nya bo̱ lɔŋŋɔ e̱kpa‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Amaa mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ Iliya a kyɔ ba, ne̱ ase̱sɛ mo̱ŋ pini mò̱. Ne̱ baa waa mò̱ ane̱ŋ ne̱ ba kpa‑ɔ. Ane̱ŋ dɛɛ ne̱ ba waa mo̱, dimaadi mò̱ gyi‑o, bo̱rɔkraa.” ");
INSERT INTO ncuNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ne̱ ŋkee mò̱ agyase̱po̱‑ɔ a pini fe̱yɛ Yohanee Osuubɔpo̱‑ɔ ase̱ŋ ne̱ ɔ tɔwe̱ o gywii bamo̱‑ɔ, a le̱e̱ fe̱yɛ Wuribware̱ kyaamɛɛ kusuŋ ne̱ Yohanee a waa‑ɔ du ne̱e̱ fe̱yɛ kyaamɛɛ kusuŋ ne̱ saŋ‑ɔ Iliya a waa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱ asa‑ɔ a be̱e̱ kiŋŋi bo̱ to̱ mò̱ agyase̱po̱ ne̱ baa saŋ‑ɔ na lamaŋ‑ɔ. Mfe̱ŋ ne̱ ɔnyare̱ ko̱ a bo̱ kpuni aŋurii Yeesuu ayaa‑rɔ tɔwe̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Mo̱ nyaŋpe̱, mo̱ e̱ ko̱re̱ fo̱ ne̱e̱ fe̱yɛ fo̱ ŋu mo̱ gyi nyaŋsɛ mɔ e̱wɛɛ na fo̱ kya mò̱. Ɔ lɔ kigbuŋgbuŋ ne̱e̱, ne̱ ke̱ e̱ tɔɔraa mò̱ bwe̱e̱tɔ. Saŋ ke̱maa, ke̱ e̱ twe̱e̱ mò̱ ke̱ e̱ da de̱e̱kpa‑rɔ bɛɛɛ nkyu‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mbe̱yɔmɔ ne̱ mo̱ a taa mò̱ baa fo̱ agyase̱po̱‑ɔ ase̱ mfe̱e̱, amaa bo̱ mo̱ŋ taare̱ kya mò̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ne̱ Yeesuu a tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Ke̱se̱bɔrɔle̱ŋ awuye, mo̱ne̱ maa kɔɔre̱ mo̱ mo̱ne̱ i gyi. Nsu mfe̱ne̱ ne̱ mo̱ne̱ e̱ kpa fe̱yɛ mo̱ aa mo̱ne̱ a kye̱na? Bɛɛɛ nsu mfe̱ne̱ ne̱ mo̱ne̱ e̱ kpa fe̱yɛ ŋ nyite mo̱ne̱ pwɛɛ na mo̱nꞌ dɛɛ kɔɔre̱ mo̱ gyi‑o ne̱e̱? Mo̱nꞌ taa kayaagyi‑o baa mo̱ ase̱ mfe̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Bamo̱ a taa mò̱ baa‑ɔ, ne̱ Yeesuu a sa ibrisi ne̱ i te kayaagyi‑o si‑o kanɔ, ne̱ e̱ ya ko̱so̱ le̱e̱ mò̱ se̱. Puri amo̱‑rɔ ne̱ kanyaŋsɛɛ‑ɔ a kpaare̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Amo̱ kamɛɛ‑rɔ‑ɔ, ne̱ Yeesuu agyase̱po̱‑ɔ a ba mò̱ ase̱ keri si to̱ŋ ko̱ bo̱ bise mò̱ fe̱yɛ, “Nte̱tɔ se̱ ne̱ ane̱ mo̱ŋ taare̱ gya ibrisi amo̱‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ne̱ ɔɔ be̱ŋŋaa bamo̱ fe̱yɛ, “Ke̱tɔ se̱ ne̱ mo̱ne̱ mo̱ŋ taare̱ gya ibrisi amo̱ bo̱ ko̱so̱ kayaagyi amo̱ se̱‑ɔ e̱ gye̱ fe̱yɛ mo̱ne̱ ko̱kɔɔre̱gyi mo̱ŋ kyɔ. Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ mo̱ne̱ dɛɛ mo̱ne̱ de ko̱kɔɔre̱gyi na ke̱ ta fe̱yɛ kiyii kigyi kagyingyingyii gbaa ne̱e̱‑ɔ, weetee mo̱ne̱ e̱ taare̱ a mo̱nꞌ tɔwe̱ gywii ke̱be̱e̱ so̱swe̱e̱ mɔ mfe̱e̱ fe̱yɛ ‘Le̱e̱ mfe̱e̱ yɔ mfe̱ŋ,’ na ki bu mo̱ne̱. Na weetee mo̱nꞌ taare̱ waa ke̱tɔ ke̱maa.  ");
INSERT INTO ncuNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Amaa ane̱ŋ a ibrisi amo̱, mo̱ne̱ maa taare̱ a mo̱nꞌ gya bo̱ ko̱so̱ se̱sɛ se̱, amɔ mo̱ne̱ a ko̱re̱ ke̱bware̱ko̱re̱ na mo̱ne̱ a kra ako̱ŋ pwɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ pɛɛɛ a naa ba muruwi Galile̱ya swe̱e̱re̱ se̱ ba yɔ‑ɔ, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱nꞌ lɔŋ e̱se̱bɔ na mo̱nꞌ nu mo̱ ase̱. Ba taa mo̱, dimaadi mò̱ gyi‑o, a bo̱ waa swe̱e̱re̱ mɔ se̱ ayaale̱ŋpo̱ ke̱sare̱e̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ba mɔɔ mo̱, amaa ke̱mo̱ ŋke nsa, Wuribware̱ i kyiŋŋi mo̱ a ɔ le̱e̱ lowi‑ro.” Mò̱ agyase̱po̱‑ɔ a nu amo̱‑ɔ, ne̱ bo̱re̱‑rɔ a duŋwi bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ne̱ saŋ ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ a fo̱ Kapaaniyum maŋ‑nɔ‑ɔ, ne̱ twe̱e̱twe̱e̱ akɔɔre̱po̱ ko̱ a ba Peetroo ase̱ bo̱ bise mò̱ fe̱yɛ, “Ane̱ a ba a ane̱ bo̱ kɔɔre̱ atanne̱ le̱e̱ ane̱ Isireelii awuye ase̱ ne̱e̱, na bo̱ bo̱ taare̱ lɔŋŋɔ Wuribware̱ suŋkpa akyaŋ‑ɔ. Fo̱ nyaŋpe̱ e̱ ka ane̱ŋ a twe̱e̱twe̱e̱ amo̱ aaa bɛɛɛ o kine?” ");
INSERT INTO ncuNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ne̱ Peetroo yɛ, “Ɔ ka.” Peetroo a lwee lɔŋ‑nɔ‑ɔ, ne̱ Yeesuu a gye̱ ŋkpɛɛ bise mò̱ fe̱yɛ, “Simɔŋ, e̱me̱ne̱ ne̱ fo̱ e̱ fa amo̱‑ɔ mfɛɛre̱? Kaye̱ mɔ‑rɔ awure ya sa kanɔ fe̱yɛ bo̱ ka twe̱e̱twe̱e̱ sa bamo̱, bamo̱ fɔŋfɔŋ ase̱sɛ ase̱ ne̱ ba kɔɔre̱ pwɛɛ, bɛɛɛ bamo̱ ado̱ŋ ne̱ baa kɔ ke̱naa gyi si‑o ase̱ ne̱ ba kɔɔre̱ a bo̱ le̱e̱ pwɛɛ?” ");
INSERT INTO ncuNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ne̱ Peetroo a lee kanɔ fe̱yɛ, “Bamo̱ ado̱ŋ ase̱ ne̱ ba kɔɔre̱ a bo̱ le̱e̱ pwɛɛ.” Ne̱ Yeesuu yɛ, “Kase̱ŋtiŋ ne̱e̱. Amo̱se̱‑ɔ ane̱ a gye̱ Wuribware̱ se̱ a kuwure‑o‑ro agyi‑o si‑o, ane̱ maa ka Wuribware̱ suŋkpa ko̱lɔŋŋɔ a twe̱e̱twe̱e̱ amo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Amaa ma kpa fe̱yɛ twe̱e̱twe̱e̱ akɔɔre̱po̱ mɔ se̱, ase̱sɛ iduŋ fwii ane̱ se̱. Amo̱se̱‑ɔ, yɔ nkyu‑ro, ya twe̱e̱ drɔwa waa‑rɔ. Fo̱ ya yɔ, kakiŋgyi ne̱ fo̱ e̱ gye̱ ŋkpɛɛ a fo̱ kra‑ɔ kanɔ‑rɔ fo̱ i ŋu atanne̱ kigyi ne̱ kaa fo̱ siidii aduna‑ɔ, ne̱ ke̱ e̱ taare̱ a ke̱ ka mo̱ aa fo̱ kuŋu si twe̱e̱twe̱e̱ ne̱ ba kpa‑ɔ. Na fo̱ taa yaa bo̱ ka mo̱ aa fo̱ a Wuribware̱ suŋkpa a twe̱e̱twe̱e̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Saŋ amo̱‑ɔ, ne̱ Yeesuu agyase̱po̱‑ɔ a ba mò̱ ase̱. Ne̱ baa bise mò̱ fe̱yɛ, “Nsɛ e̱ gye̱ bre̱sɛ Wuribware̱ se̱ a kuwure‑o‑ro?” ");
INSERT INTO ncuNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ne̱ Yeesuu a te̱e̱ kayaagyi ko̱ baa bo̱ ye̱ra bamo̱ akatɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ mo̱ne̱ ɔke̱maa kakpo̱nɔ‑rɔ e̱ mo̱ŋ waa fe̱yɛ kayaagyi lee‑o, mo̱ne̱ maa nya kpa a mo̱nꞌ tii Wuribware̱ se̱ a kuwure‑o si. ");
INSERT INTO ncuNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Amo̱se̱‑ɔ ɔke̱maa ne̱ o yuri mò̱ e̱ye̱e̱, ne̱ ɔ waa fe̱yɛ kayaagyi mɔ ne̱ ɔ ye̱re̱ mfe̱e̱‑ɔ i kii bre̱sɛ Wuribware̱ se̱ a kuwure‑o‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Amo̱se̱‑ɔ, ɔko̱ ne̱ mò̱ ya kra ane̱ŋ a kayaagyi mɔ nɛɛnɛɛ mo̱ ke̱nyare̱‑rɔ‑ɔ, ɔɔ kra mo̱ nɛɛnɛɛ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Ɔko̱ ne̱ mò̱ ya sa ne̱ ŋyaagyi ngyingyii mɔ ne̱ ba kɔɔre̱ mo̱ ba gyi‑o ɔko̱ ya waa e̱bɔye̱, amo̱ fe̱raa bamo̱ ya ba kibu dabe̱ bo̱ da se̱sɛ‑ɔ ke̱bɔ‑rɔ, ne̱ baa twe̱e̱ mò̱ waa ɔpo̱o̱‑rɔ, a bɔ fe̱yɛ mò̱ a nya ke̱se̱bɔgyiiri ne̱ Wuribware̱ i gyiiri ane̱ŋ a e̱bɔye̱ awaapo̱ ke̱se̱bɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","A gye̱ afutɔ sa kaye̱‑rɔ ase̱sɛ fe̱yɛ bo̱ko̱ a bo̱‑rɔ ne̱ ba sa ne̱ bamo̱ bɛɛko̱‑ana e̱ waa e̱bɔye̱. Ane̱ŋ a ase̱ŋ‑ɔ e̱ de̱e̱ ba fe̱raa. Amaa bamo̱ ne̱ baa sa ne̱ bo̱ko̱ e̱ waa e̱bɔye̱ amo̱‑ɔ a ke̱se̱bɔgyiiri‑o e̱ waa ko̱kyɔ fɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Amo̱se̱‑ɔ fo̱ ko̱ ne̱ fo̱ ke̱sare̱e̱ bɛɛɛ fo̱ ke̱yaa e̱ gye̱ ne̱ ke̱ e̱ sa ne̱ fo̱ e̱ waa e̱bɔye̱, te̱ŋ ke̱mo̱ bo̱ twe̱e̱. A le̱e̱ fe̱yɛ fo̱ ya kii ke̱sare̱e̱ ko̱ŋko̱ wuye bɛɛɛ ke̱yaa ko̱ŋko̱ wuye, ne̱ fo̱ a nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ, a bɔ fe̱yɛ fo̱ kumumwii a lwee awo̱re̱fɔɔ de̱e̱kpa ne̱ ɔ maa duŋ, ne̱ Wuribware̱ a kure bo̱ be̱ya na ɔ bo̱ gyiiri e̱bɔye̱ awaapo̱ ke̱se̱bɔ‑rɔ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ne̱ fo̱ ne̱ fo̱ ke̱katɔ ko̱ e̱ sa ne̱ fo̱ e̱ waa e̱bɔye̱‑ɔ, fo̱ lee ke̱mo̱ bo̱ twe̱e̱. A le̱e̱ fe̱yɛ fo̱ ya lee ke̱mo̱ bo̱ twe̱e̱, ne̱ fo̱ ya kii ke̱katɔ ko̱ŋko̱ wuye, ne̱ fo̱ a nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ, a bɔ fe̱yɛ fo̱ akatɔ anyɔ a te fo̱ se̱, ne̱ fo̱ a bo̱ lwee awo̱re̱fɔɔ de̱e̱kpa‑ɔ‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ne̱ Yeesuu a kya se̱ kaapo̱ mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Mo̱ne̱ ma kaŋ fa fe̱yɛ ŋyaagyi ngyingyii mɔ mo̱ŋ gye̱ sɛye̱. A le̱e̱ fe̱yɛ mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ Wuribware̱ a mbɔɔ ne̱ ba de̱e̱re̱ bamo̱ ɔke̱maa se̱‑ɔ ye̱re̱ Wuribware̱ ase̱ saŋ ke̱maa.  ");
INSERT INTO ncuNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Mo̱nꞌ lɔŋ e̱se̱bɔ. Mo̱, dimaadi mò̱ gyi‑o, a ba a m bo̱ de̱e̱re̱ kpa e̱bɔye̱ awaapo̱ ne̱e̱ na m mo̱rɔwe̱ bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","N taa fe̱yɛ ɔko̱ de e̱sanne̱ ke̱lafa, ne̱ ɔ de̱e̱re̱ bamo̱ se̱ e̱fa‑rɔ, ne̱ bamo̱ ɔko̱ ya fo̱, e̱me̱ne̱ ne̱ se̱sɛ‑ɔ e̱ waa? Mo̱ e̱ kɔɔre̱ a n gyi fe̱yɛ ɔ yɔwe̱ e̱sanne̱ adukpanɔɔ na e̱kpanɔɔ ne̱ baa saŋ‑ɔ a bo̱ bo̱ sii bamo̱ gyirokpa ne̱e̱, na ɔ ya buwi kpa ɔko̱ŋko̱‑ɔ bo̱ fo̱ saŋ ne̱ o ŋu mò̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kase̱ŋtiŋ si mò̱ ya ŋu mò̱, mò̱ akatɔ i gyi sanne̱ ko̱ŋko̱ amo̱ se̱, a kyo̱ŋ adukpanɔɔ na e̱kpanɔɔ ne̱ bo̱ mo̱ŋ fo̱‑ɔ. Bɛɛɛ mo̱ e̱ ba aye̱ba ne̱e̱ e̱e̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ane̱ŋ dɛɛ ne̱ Wuribware̱, mo̱ne̱ se̱ ne̱ ɔ bo̱ so̱so̱‑ɔ, maa kpa fe̱yɛ ŋyaagyi ngyingyii mɔ ɔko̱ fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ne̱ Yeesuu a kya se̱ ɔ kaapo̱ ke̱tɔ ne̱ Wuribware̱ yɛ ane̱ waa e̱bɔye̱ awaapo̱‑ɔ. Ɔ yɛ, “Fo̱ ko̱so̱bɛɛ ɔkɔɔre̱gyipo̱ ya waa fo̱ bɔye̱, e̱me̱ne̱ ne̱ fo̱ waa? Ke̱tɔ ne̱ fo̱ waa‑ɔ e̱ gye̱ fe̱yɛ fo̱ yɔ mò̱ ase̱, na fo̱ te̱e̱ mò̱ keri si. Na fo̱ aa mò̱ abɛɛ anyɔ wo̱re̱, fo̱ tɔwe̱ bɔye̱ ne̱ ɔɔ waa fo̱‑ɔ gywii mò̱. Ne̱ mò̱ ya nu fo̱ kaase̱, ne̱ mò̱ ya ye̱re̱ gywii fo̱, amo̱ fe̱raa fo̱ a lɔŋŋɔ fo̱ aa mò̱ mbo̱ŋtɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Amaa mò̱ e̱ mo̱ŋ nu fo̱ ase̱ŋ fe̱raa, te̱e̱ se̱sɛ ko̱ŋko̱ bɛɛɛ abɛɛ anyɔ bo̱ tii fo̱ e̱ye̱e̱ se̱ yaa mò̱ ase̱. A le̱e̱ fe̱yɛ baa kyo̱rɛɛ abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ, ‘Abɛɛ anyɔ bɛɛɛ ŋkɔ asa ya ye̱re̱‑rɔ tɔwe̱ fe̱yɛ baa ŋu kase̱ŋtiŋ si fe̱yɛ se̱sɛ amo̱ a waa bɔye̱ ko̱ fe̱raa, abre̱sɛ e̱ taare̱ a bo̱ bu mò̱ ke̱pɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ne̱ mò̱ ya saŋ kine kunu bamo̱ kaase̱ fe̱raa, mo̱nꞌ taa ase̱ŋ‑ɔ pɛɛɛ yaa asɔre̱e̱ agyi akatɔ‑rɔ. Ne̱ mò̱ e̱ ma nu asɔre̱e̱ agyi gbaa a nnɔ‑ɔ, amo̱ fe̱raa taa mò̱ fe̱yɛ ɔ mo̱ŋ tii asɔre̱e̱‑ɔ se̱, a le̱e̱ fe̱yɛ o du ne̱e̱ fe̱yɛ bamo̱ ne̱ bo̱ maa suŋ Wuribware̱‑ɔ ɔko̱ bɛɛɛ fe̱yɛ apoo leŋpoo ɔkɔɔre̱po̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ ɔko̱ bɔye̱ ke̱maa ne̱ mo̱ne̱ e̱ taa a mo̱nꞌ bo̱ ke mò̱ swe̱e̱re̱ mɔ se̱‑ɔ, Wuribware̱ ne̱ ɔ bo̱ so̱so̱‑ɔ a taa bo̱ ke mò̱. Ne̱ mo̱ne̱ e̱ mo̱ŋ taa e̱mo̱ bo̱ ke mò̱ fe̱raa, Wuribware̱ mo̱ŋ taa bo̱ ke mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","M be̱e̱ mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ mo̱ne̱ abɛɛ anyɔ ya waa kanɔ swe̱e̱re̱ mɔ se̱ mfe̱e̱ ko̱re̱ Wuribware̱, n se̱ ne̱ ɔ bo̱ so̱so̱‑ɔ, ko̱tɔko̱, ɔ sa mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","A le̱e̱ fe̱yɛ mfe̱ŋ ne̱ abɛɛ anyɔ bɛɛɛ asa e̱ gyaŋŋe̱ mo̱ ke̱nyare̱‑rɔ‑ɔ, m bo̱ bamo̱ ase̱ mfe̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ne̱ Peetroo a bo̱ bise Yeesuu fe̱yɛ, “To, mo̱ nyaŋpe̱. N taa fe̱yɛ mo̱ ko̱so̱bɛɛ e̱ waa mo̱ bɔye̱ saŋ ke̱maa, waa iluwi e̱fe̱ne̱ ne̱ n taa mò̱ e̱bɔye̱‑ɔ bo̱ ke mò̱ na ŋ yɔwe̱? Iluwi isunoo bɛɛɛ e̱fe̱ne̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Daabii. N gye̱ iluwi isunoo. Amaa ŋ yɛ iluwi adusunoo ane̱ŋ a ntuŋkare̱ nsunoo‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Mo̱nꞌ nu ane̱ŋ ne̱ a du Wuribware̱ se̱ a kuwure‑o‑ro‑o. N gye̱ owure ko̱ ya dɛɛ kye̱na aaa? Ne̱ mò̱ ayaafɔre̱‑ɔ bo̱ko̱ de mò̱ ko̱kɔ. Ne̱ ɔɔ waa mò̱ mfɛɛre̱ fe̱yɛ ɔ te̱e̱ bamo̱ pɛɛɛ a ɔ bo̱ gyaŋŋe̱ na ɔ nya ŋu mò̱ aa bamo̱ mbo̱ŋtɔ‑rɔ atanne̱ ne̱ a bo̱‑rɔ‑ɔ na ɔ kɔɔre̱ le̱e̱ bamo̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mò̱ a le̱e̱ kaase̱ ɔ waa amo̱‑ɔ, ne̱ baa baa mò̱ ayaafɔre̱‑ɔ ɔko̱ ne̱ o de mò̱ ko̱kɔ siidii ŋkpe̱ŋkɛɛ kakpe̱ŋ (GHC 1,000,000,000). ");
INSERT INTO ncuNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Owure a kpa a ɔ kɔɔre̱ atanne̱‑ɔ le̱e̱ mò̱ ase̱‑ɔ, ne̱ ɔ yɛ ɔ maa taare̱ a ɔ ka. Amo̱se̱‑ɔ ne̱ owure‑o yɛ bo̱ taa mò̱ kapo̱tɛɛ pɛɛɛ na mò̱ ka na bamo̱ ŋyaagyi fe sa ɔko̱ na bo̱ kii se̱sɛ‑ɔ anya. Na bo̱ taa atanne̱ ne̱ baa nya‑ɔ baa bo̱ ka ko̱kɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Mfe̱ŋ ne̱ ke̱yaafɔre̱ amo̱ a kpuni aŋurii owure‑o ayaa‑rɔ‑ɔ tɔwe̱ fe̱yɛ, ‘Mo̱ e̱ ko̱re̱ fo̱ ne̱e̱ fe̱yɛ fo̱ nyite mo̱, na mo̱ e̱ ka fo̱ ko̱kɔ‑ɔ pɛɛɛ.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ne̱ ŋkee owure‑o a ŋu fe̱yɛ mò̱ ke̱yaafɔre̱ amo̱ ase̱ŋ a waa e̱wɛɛ, ne̱ ɔɔ taa ko̱kɔ‑ɔ pɛɛɛ bo̱ ke mò̱, ne̱ ɔɔ sa mò̱ kpa fe̱yɛ ɔ nare̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ke̱yaafɔre̱‑ɔ a le̱e̱ kawu ɔ yɔ‑ɔ, ne̱ ɔɔ ya gyaŋŋaa mò̱ ko̱so̱bɛɛ ke̱yaafɔre̱ ko̱ ne̱ o de mò̱ ko̱kɔ siidii kakpe̱ŋ. Ne̱ ɔɔ ya kra mò̱ bo̱re̱‑rɔ, ne̱ ɔ yɛ, ‘Ka mo̱ atanne̱ ne̱ mo̱ a bo̱ para fo̱‑ɔ sa mo̱ mbe̱mbe̱yɔmɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ne̱ mò̱ ko̱so̱bɛɛ‑ɔ a kpuni aŋurii mò̱ ayaa‑rɔ, ne̱ ɔ yɛ, ‘Mo̱ e̱ ko̱re̱ fo̱ ne̱e̱ fe̱yɛ fo̱ nyite mo̱, na mo̱ e̱ ka fo̱ ko̱kɔ‑ɔ pɛɛɛ.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Amaa ne̱ ɔ mo̱ŋ nu ko̱ko̱re̱ ne̱ mò̱ ko̱so̱bɛɛ‑ɔ a ko̱re̱ mò̱‑ɔ. Ne̱ ɔ yɛ bo̱ kra mò̱ tii tiikpa bo̱ fo̱ saŋ ne̱ ɔ ka atanne̱‑ɔ pɛɛɛ a ɔ bo̱ sa mò̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mò̱ ko̱so̱bɛɛ‑ana ayaafɔre̱ ne̱ baa saŋ‑ɔ a ŋu ke̱tɔ ne̱ ɔɔ waa‑ɔ, ne̱ bamo̱ iduŋ a fwii bwe̱e̱tɔ, ne̱ baa ya tɔwe̱ gywii owure‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Amo̱se̱ ne̱ owure‑o a te̱e̱ ane̱ŋ a ke̱yaafɔre̱ amo̱. Ne̱ ɔɔ tɔwe̱ gywii mò̱ fe̱yɛ, ‘Kuŋurole̱ŋ wuye ke̱yaafɔre̱ e̱ gye̱ fo̱. Ko̱kɔ ne̱ fo̱ de mo̱‑ɔ kyɔ bwe̱e̱tɔ bɛɛɛ? Amaa fo̱ a ko̱re̱ mo̱ fe̱yɛ ŋ nyite fo̱‑ɔ se̱‑ɔ, mo̱ a taa fo̱ ko̱kɔ amo̱ bo̱ ke fo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ne̱ e̱me̱ne̱ se̱ ne̱ fo̱ ko̱so̱bɛɛ ke̱yaafɔre̱‑ɔ a ko̱re̱ fo̱ fe̱yɛ fo̱ nyite mò̱‑ɔ, ne̱ fo̱ mo̱ŋ ŋu mò̱ e̱wɛɛ fe̱yɛ ane̱ŋ ne̱ mo̱‑ɔ mo̱ a ŋu fo̱ e̱wɛɛ‑ɔ dɛɛ? Amo̱‑ɔ bware aaa?’ ");
INSERT INTO ncuNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ne̱ owure‑o duŋ a fwii mò̱ ke̱yaafɔre̱ amo̱ se̱ bwe̱e̱tɔ, ne̱ ɔɔ sa kanɔ fe̱yɛ bo̱ ya tii mò̱ tiikpa waa mò̱ bo̱rɔkraa bo̱ fo̱ saŋ ne̱ ɔ taare̱ a ɔ ka atanne̱‑ɔ pɛɛɛ‑ɔ. Amo̱ e̱ gye̱ saase̱bɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ane̱ŋ ne̱ Wuribware̱, n se̱ ne̱ ɔ bo̱ so̱so̱‑ɔ, e̱ waa mo̱ne̱ ɔke̱maa‑ɔ ne̱e̱, amɔ fo̱ a lee fo̱ kame‑ro taa fo̱ bɛɛko̱ e̱bɔye̱ bo̱ ke mò̱ fe̱raa.” ");
INSERT INTO ncuNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Saŋ ne̱ Yeesuu a tɔwe̱ amo̱‑ɔ pɛɛɛ lo̱we̱‑ɔ, ne̱ ɔɔ le̱e̱ Galile̱ya swe̱e̱re̱ se̱ yɔ Yude̱ya swe̱e̱re̱ se̱ a ke̱be̱gya ne̱ ke̱ bo̱ Yo̱o̱daŋ bo̱ŋ nno̱ŋ a bo̱ŋbe̱‑ɔ se̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ne̱ ase̱sɛ biribiri a gya mò̱ se̱. Ne̱ ɔɔ kya bamo̱ alɔpo̱‑ɔ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mfe̱ŋ‑ɔ, Farisii awuye ko̱ a ba mò̱ ase̱ a bo̱ lɔɔre̱ mò̱ kanɔ‑rɔ. Ne̱ bo̱ yɛ, “Ane̱ mbraa‑ɔ e̱ sa kpa fe̱yɛ ɔko̱ kine mò̱ ka bo̱ le̱e̱ ke̱tɔ ke̱maa ne̱ ɔnyare̱‑ɔ e̱ fa fe̱yɛ ɔkye̱e̱‑ɔ a waa‑ɔ se̱ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “Mo̱ne̱ mo̱ŋ tɛɛ kare̱ abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ saŋ ne̱ Wuribware̱ a twe̱e̱ kaye̱‑rɔ atɔ pɛɛɛ‑ɔ, ɔɔ twe̱e̱ ɔnyare̱ na ɔkye̱e̱ ne̱e̱ e̱e̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ne̱ a be̱e̱ tɔwe̱ fe̱yɛ, ‘Amo̱se̱ ne̱ ɔnyare̱ e̱ le̱e̱ mò̱ se̱ na mò̱ nyi lɔŋ‑nɔ na ɔ waare̱e̱, na mò̱ aa mò̱ ka a waa kanɔ kye̱na kii ko̱ko̱ŋko̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Amo̱ e̱ kaapo̱ ne̱e̱ fe̱yɛ bo̱ mo̱ŋ lɛɛ bo̱ gye̱ abɛɛ anyɔ. Amaa Wuribware̱ a sa ne̱ baa kii se̱sɛ ko̱ŋko̱ ne̱e̱. Amo̱se̱ se̱‑ɔ se̱sɛ mo̱ŋ de kpa fe̱yɛ mò̱ a brawe̱ ke̱tɔ ne̱ Wuribware̱ a bo̱ waa abɛɛ‑rɔ‑ɔ‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ne̱ Farisii awuye‑o yɛ, “Ne̱ nte̱tɔ ne̱e̱ ne̱ ane̱ ɔde̱daapo̱ Mosis a sa mbraa fe̱yɛ ɔnyare̱ e̱ kpa a o kine mò̱ ka, ɔ kyo̱rɛɛ wo̱re̱ na ɔke̱maa nya ŋu fe̱yɛ oo yure mò̱ se̱, pwɛɛ na ɔ dɛɛ gya mò̱ le̱e̱ mò̱ aye̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “Mosis a sa mo̱ne̱ kpa fe̱yɛ mo̱nꞌ kine mo̱ne̱ aka, a le̱e̱ fe̱yɛ mo̱ne̱ aŋu‑ro bo̱ le̱ŋ ne̱e̱ fɛɛ. Amaa mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ hare̱e̱ le̱e̱ saŋ ne̱ Wuribware̱ a twe̱e̱ ke̱tɔ ke̱maa‑ɔ, a mo̱ŋ waa mò̱ kɔne̱ fe̱yɛ ɔnyare̱ a kine mò̱ ka. ");
INSERT INTO ncuNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Amo̱se̱‑ɔ, ke̱tɔ ne̱ mo̱ e̱ kaapo̱ mo̱ne̱‑ɔ e̱ gye̱ fe̱yɛ ɔnyare̱ ma kine mò̱ ka ke̱tɔ ke̱maa se̱, amɔ ɔkye̱e̱‑ɔ a kyɔ le̱e̱ mò̱ kamɛɛ fe̱raa. Ne̱ n gye̱ ane̱ŋ, ɔnyare̱‑ɔ ya waare̱e̱ ɔkye̱e̱ baŋbaŋ, ɔ waa bɔye̱. Mò̱ ke̱be̱e̱ waare̱e̱ ɔkye̱e̱ baŋbaŋ‑ɔ du ne̱e̱ fe̱yɛ mò̱ a waa kakye̱e̱kpa‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ne̱ Yeesuu agyase̱po̱‑ɔ a tɔwe̱ gywii mò̱ fe̱yɛ, “Ɔnyare̱ na mò̱ ka mbo̱ŋtɔ‑rɔ e̱ gye̱ ane̱ŋ, amo̱ fe̱raa, a bware fe̱yɛ ɔko̱ ma waare̱e̱ daa aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “N gye̱ ase̱sɛ pɛɛɛ e̱ gye̱ ne̱ ba taare̱ a bo̱ sure ke̱tɔ ne̱ mo̱ne̱ a tɔwe̱‑ɔ se̱, amɔ bamo̱ ne̱ Wuribware̱ a sa bamo̱ ane̱ŋ a e̱ye̱e̱ ke̱kra‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ke̱tɔ ne̱ mo̱ e̱ kaapo̱‑ɔ e̱ gye̱ fe̱yɛ anyare̱ bo̱ko̱ bo̱‑rɔ ne̱ baa ko̱we̱ bamo̱ na bo̱ maa taare̱ a bo̱ ko̱we̱ ŋyaagyi sa bamo̱ e̱ye̱e̱. Bo̱ko̱ mɔ bo̱‑rɔ ne̱ baa lee bamo̱ awɛɛ. Ne̱ bo̱ko̱ mɔ be̱e̱ bo̱ bo̱‑rɔ ne̱ bamo̱ a pee akatɔ Wuribware̱ se̱ a kuwure‑o e̱kpa se̱ ke̱gya‑ɔ se̱‑ɔ, bo̱ yɛ bo̱ maa waare̱e̱. Amo̱se̱ se̱‑ɔ ɔko̱ e̱ bo̱‑rɔ ne̱ mò̱ e̱ taare̱ a ɔ waa ane̱ŋ, mo̱nꞌ sa a ɔ waa.” ");
INSERT INTO ncuNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ne̱ ase̱sɛ ko̱ a baa bamo̱ ŋyaagyi Yeesuu ase̱, na ɔ ba mò̱ asare̱e̱ bo̱ dɔŋŋɔ bamo̱ se̱, na ɔ ko̱re̱ ke̱bware̱ko̱re̱ sa bamo̱. Amaa mò̱ agyase̱po̱‑ɔ yɛ bo̱ nare̱, na bo̱ ma lɛɛ tɔɔraa mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Amo̱se̱‑ɔ ne̱ Yeesuu fe̱raa yɛ, “Mo̱ne̱ ma kaŋ gya ŋyaagyi mɔ le̱e̱ mo̱ ase̱. Mo̱nꞌ sa a bo̱ ba mo̱ ase̱, a le̱e̱ fe̱yɛ ane̱ŋ a ŋyaagyi mɔ na bamo̱ ne̱ bo̱ du fe̱yɛ ŋyaagyi mɔ‑ɔ e̱ gye̱ ne̱ bo̱ tii Wuribware̱ se̱ a kuwure‑o si.” ");
INSERT INTO ncuNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Mò̱ a ba mò̱ asare̱e̱ bo̱ dɔŋŋɔ bamo̱ se̱‑ɔ, ne̱ ɔɔ le̱e̱ mfe̱ŋ me̱raa mò̱ kpa se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ne̱ ɔnyare̱ ko̱ a ba Yeesuu ase̱, ne̱ ɔ yɛ, “Ɔkaapo̱po̱, nte̱tɔ ke̱tɔ timaa ne̱ ŋ waa na ŋ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ?” ");
INSERT INTO ncuNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Nte̱tɔ se̱ ne̱ fo̱ i bise mo̱ atɔ timaa si? Ɔko̱ mo̱ŋ bo̱‑rɔ ne̱ ɔ gye̱ otimaa be̱e̱ bo̱ tii Wuribware̱ se̱. To, fo̱ e̱ kpa a fo̱ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ, gya Wuribware̱ a mbraa‑ɔ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ne̱ ɔnyare̱‑ɔ a bise mò̱ fe̱yɛ, “Nte̱tɔ mbraa?” Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Mbraa ne̱ ŋ yɛ, ‘Ɔko̱ ma mɔɔ mò̱ bɛɛko̱, ɔko̱ ma waa kakye̱e̱kpa, ɔko̱ ma kaŋ ywii, ɔko̱ ma kaŋ te̱ŋ mò̱ bɛɛko̱ kanɔ, ");
INSERT INTO ncuNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","na ɔke̱maa bu mò̱ se̱ na mò̱ nyi,’ na ‘Ɔke̱maa kpa mò̱ bɛɛko̱ fe̱yɛ ane̱ŋ ne̱ ɔ kpa mò̱ e̱ye̱e̱‑ɔ.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ne̱ ɔnyare̱ amo̱ a be̱ŋŋaa mò̱ fe̱yɛ, “Mo̱ a gya mbraa mɔ pɛɛɛ se̱. Nte̱tɔ ya saŋ ne̱ a bware fe̱yɛ m be̱e̱ waa?” ");
INSERT INTO ncuNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Fo̱ e̱ kpa fe̱yɛ fo̱ kii se̱sɛ timaa lo̱we̱, amo̱ fe̱raa, nare̱ ya fe ke̱tɔ ke̱maa ne̱ fo̱ de‑o, na fo̱ taa atanne̱‑ɔ pɛɛɛ bo̱ sa atiripo̱. Fo̱ ya waa ane̱ŋ fe̱raa, Wuribware̱ e̱ kpa kapo̱tɛɛ a ɔ bo̱ ye̱ra so̱so̱ sa fo̱. Na fo̱ bo̱ gya mo̱ se̱ mbe̱yɔmɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ɔnyare̱ amo̱ a nu mfaanɛɛ‑ɔ, a mo̱ŋ waa mò̱ kɔne̱, a le̱e̱ fe̱yɛ o de kapo̱tɛɛ bwe̱e̱tɔ. Ne̱ ɔɔ bo̱re̱ le̱e̱ mfe̱ŋ yɔ mò̱ lɔŋ‑nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Mfe̱ŋ ne̱ Yeesuu a tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “A waa le̱ŋ fe̱yɛ atɔ wuye a sure si fe̱yɛ Wuribware̱ gye̱ mò̱ owure. ");
INSERT INTO ncuNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nyɔma e̱ taare̱ a o lwee basa bɔ‑rɔ dare̱e̱ aaa? Amaa mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ atɔ wuye kusure si fe̱yɛ Wuribware̱ gye̱ mò̱ owure bo̱ le̱ŋ a kyɔ nyɔma kulwee basa bɔ‑rɔ dare̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yeesuu agyase̱po̱‑ɔ a nu amo̱‑ɔ, ne̱ aa waa bamo̱ ase̱ŋ dabe̱. Ne̱ baa bise mò̱ fe̱yɛ, “Ne̱ ŋkee nsɛ gbaa e̱ gye̱ ne̱ o de kpa fe̱yɛ ɔ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ne̱ Yeesuu a de̱e̱re̱ bamo̱ diŋŋ, ne̱ ɔɔ be̱ŋŋaa bamo̱ fe̱yɛ, “Se̱sɛ e̱ gye̱ ne̱ ɔ maa taare̱ a ɔ nya ane̱ŋ a ŋkpa‑ɔ, amɔ Wuribware̱ a sa mò̱ kpa fe̱raa. Ko̱tɔko̱ mo̱ŋ bo̱‑rɔ ne̱ Wuribware̱ maa taare̱ a ɔ waa ke̱mo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ne̱ Peetroo yɛ, “Ke̱e̱ ɛ, ane̱ a yɔwe̱ ke̱tɔ ke̱maa ane̱ gya fo̱ se̱‑ɔ, nte̱tɔ ne̱ ane̱ e̱ nya?” ");
INSERT INTO ncuNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ saŋ ko̱ e̱ ba a ɔ bo̱ ba, na kaye̱ mɔ gye̱ kɛɛ, na kaye̱ po̱pwɛɛ ba. Na saŋ amo̱‑ɔ, mo̱, dimaadi mò̱ gyi‑o, nya ke̱dabe̱ na wuraa na n kye̱na mo̱ kuwuregya se̱ gyi mo̱ kuwure. Na mo̱ne̱ fɔŋfɔŋ ne̱ mo̱ne̱ a gya mo̱ se̱‑ɔ kye̱na ŋwuregya kudu ŋnyɔ se̱, na mo̱nꞌ gyi ane̱ Isireelii awuye a nsuro kudu ŋnyɔ‑ɔ kuwure. ");
INSERT INTO ncuNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na ɔke̱maa ne̱ oo kperi mo̱ se̱, ne̱ ɔɔ yɔwe̱ mò̱ lɔŋ bɛɛɛ mò̱ daa‑ana bɛɛɛ mò̱ tire‑ana bɛɛɛ mò̱ pe̱kye̱e̱‑ana bɛɛɛ mò̱ se̱ bɛɛɛ mò̱ nyi bɛɛɛ mò̱ gyi‑ana bɛɛɛ mò̱ adɔɔ gya mo̱ se̱‑ɔ nya atɔ ke̱maa na ako̱we̱bɛɛ ke̱maa ne̱ ɔɔ yɔwe̱‑ɔ iluwi ke̱lafa a ɔ bo̱ teere swe̱e̱re̱ mɔ se̱ mfe̱e̱, na ŋkee ɔ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Amaa ase̱sɛ bwe̱e̱tɔ ne̱ bo̱ gye̱ agye̱ŋkpɛɛpo̱ mbe̱yɔmɔ‑ɔ i kii nsii-amɛɛ, na bamo̱ ne̱ bo̱ gye̱ nsii-amɛɛ mbe̱yɔmɔ‑ɔ mɔ kii agye̱ŋkpɛɛpo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ne̱ Yeesuu a kya se̱ tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Mo̱nꞌ be̱e̱ nu kitee mɔ ne̱ ke̱ e̱ kaapo̱ ane̱ŋ ne̱ Wuribware̱ se̱ a kuwure‑o du‑o. N gye̱ ko̱dɔɔ wuye ko̱ ya kye̱na aaa? Ne̱ adɔɔteese ke̱kpabe̱e̱ a fo̱, ne̱ ɔ kpa apafo̱wɔ na bo̱ yɔ mò̱ ko̱dɔɔ‑ɔ‑rɔ ya kya mò̱‑rɔ. To, ne̱ gye̱gyaye̱ tututu ɔɔ yɔ kawu ya to̱ anyare̱ ko̱ ye̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ne̱ ɔ yɛ ɔ sa bamo̱ siidii kudu na bo̱ yɔ ya suŋ sa mò̱ kake amo̱ pɛɛɛ. Ne̱ baa sure si, ne̱ baa yɔ mò̱ ko̱dɔɔ‑ɔ‑rɔ ya suŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kyɔwe̱ a daŋ kafwe̱e̱‑ɔ, ne̱ ɔɔ be̱e̱ yɔ kawu be̱e̱ ya to̱ anyare̱ ko̱ na bo̱ ye̱re̱ ko̱lɔŋde̱ se̱ bo̱ maa waa sɛye̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, ‘Mo̱ne̱ gbaa mo̱ne̱ ya suŋ mo̱ ko̱dɔɔ‑ɔ‑rɔ, mo̱ e̱ ka mo̱ne̱ ko̱kɔ ane̱ŋ ne̱ a bware‑o.’ Ne̱ baa sure si, ne̱ baa yɔ mò̱ ko̱dɔɔ‑ɔ‑rɔ ya suŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Mpase̱ a fo̱‑ɔ, ne̱ ɔɔ be̱e̱ yɔ kawu ya ŋu bo̱ko̱, ne̱ ɔɔ be̱e̱ tɔwe̱ ane̱ŋ dɛɛ gywii bamo̱, ne̱ baa sure si. Kyɔwe̱ kikpeerebe̱e̱ a fo̱‑ɔ, ne̱ ɔɔ be̱e̱ ya ŋu bo̱ko̱, ne̱ ɔɔ be̱e̱ tɔwe̱ ane̱ŋ dɛɛ gywii bamo̱, ne̱ baa sure si. ");
INSERT INTO ncuNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ke̱de̱e̱pwɛta a fo̱ ne̱ kyɔwe̱ e̱ kpa a ɔ lo̱we̱‑ɔ, ne̱ ɔɔ be̱e̱ yɔ kawu be̱e̱ ya to̱ anyare̱ ko̱ ye̱re̱ na bo̱ maa waa sɛye̱. Ne̱ oo bise bamo̱ fe̱yɛ, ‘E̱me̱ne̱ se̱ ne̱ mo̱ne̱ a ye̱re̱ mfe̱e̱ le̱e̱ gye̱gyaye̱ bo̱ fo̱ ke̱de̱e̱pwɛta na mo̱ne̱ mo̱ŋ waa sɛye̱?’ ");
INSERT INTO ncuNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ne̱ baa be̱ŋŋaa mò̱ fe̱yɛ, ‘Ɔko̱ mo̱ŋ taa ane̱ a ane̱ suŋ sa mò̱.’ Ne̱ ɔ yɛ, ‘To, mo̱ne̱ gbaa, mo̱nꞌ nare̱ mo̱ ko̱dɔɔ‑ɔ‑rɔ ya suŋ sa mo̱.’ Ne̱ baa yɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Kyɔwe̱ a lo̱we̱‑ɔ, ne̱ ko̱dɔɔ‑ɔ wuye‑o a tɔwe̱ gywii mò̱ ke̱paafo̱wɔ bre̱sɛ fe̱yɛ, ‘Te̱e̱ mo̱ apafo̱wɔ‑ɔ pɛɛɛ bo̱ gyaŋŋe̱ na fo̱ ka bamo̱ ko̱kɔ. Na fo̱ ka bamo̱ ne̱ baa sii kamɛɛ yɔ mo̱ ko̱dɔɔ‑ɔ‑rɔ ko̱kɔ pwɛɛ na fo̱ dɛɛ ka bamo̱ ne̱ baa gye̱ ŋkpɛɛ yɔ‑ɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ne̱ apafo̱wɔ ne̱ ko̱dɔɔ‑ɔ wuye‑o a taa bamo̱ lalalo̱we̱ bo̱ suŋ mò̱ ko̱dɔɔ‑ɔ‑rɔ‑ɔ a ba akatɔ‑rɔ, ne̱ ɔɔ ka bamo̱ ɔke̱maa siidii kudu. ");
INSERT INTO ncuNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ne̱ ɔɔ kya se̱ ka mò̱ apafo̱wɔ‑ɔ ke̱gyase̱ ke̱gyase̱ le̱e̱ nsii-amɛɛ‑ɔ ase̱ bo̱ yɔ agye̱ŋkpɛɛpo̱‑ɔ ase̱. Bamo̱ ne̱ baa suŋ le̱e̱ gye̱gyaye̱ tututu‑o bo̱ fo̱ ke̱de̱e̱pwɛta‑ɔ a ba akatɔ‑rɔ‑ɔ, ne̱ ba fa bamo̱ mfɛɛre̱ fe̱yɛ ba nya atanne̱ bwe̱e̱tɔ a bo̱ kyo̱ŋ nsii-amɛɛ‑ɔ. Amaa ɔɔ ka bamo̱ ɔke̱maa siidii kudu dɛɛ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Bamo̱ a ŋu atanne̱ ne̱ baa nya‑ɔ, ne̱ baa tɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ne̱ bo̱ yɛ, ‘Anyare̱ mɔ ne̱ baa ba fo̱ ko̱dɔɔ‑ɔ‑rɔ mfe̱e̱ saŋ ne̱ kyɔwe̱ e̱ kpa a ɔ lo̱we̱‑ɔ a suŋ kusuŋ dɔŋhwe̱re̱e̱ ko̱ŋko̱ ne̱e̱. Ne̱ ane̱ mɔ ane̱ a kpo̱ne̱ suŋ kusuŋ ibiri mɔ pɛɛɛ na kyɔwe̱ a da ane̱. Amo̱‑ɔ pɛɛɛ gbaa fo̱ a ka ane̱ aa bamo̱ atanne̱ ko̱ŋko̱ dɛɛ ne̱e̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ne̱ ko̱dɔɔ‑ɔ wuye‑o a be̱ŋŋaa bamo̱ ɔko̱ fe̱yɛ, ‘Mo̱ nyare̱, nu mo̱ ase̱. Mo̱ŋ gyi fo̱ ne̱e̱. Fo̱ a kyɔ sure si fe̱yɛ fo̱ i suŋ kusuŋ kake mumwii‑o ne̱e̱ a fo̱ sa mo̱, na ŋ ka fo̱ siidii kudu. Mo̱ e̱ ba aye̱ba ne̱e̱ e̱e̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","To, taa fo̱ kakɔka a fo̱ nare̱ pe̱. Mo̱ ya ka fo̱ aa ɔnyare̱ mɔ ne̱ oo sii kamɛɛ bo̱ dɔɔ mo̱‑ɔ atanne̱ ko̱ŋko̱ gbaa ooo, a mo̱ŋ gye̱ fo̱ ase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mo̱ fɔŋfɔŋ atanne̱ ne̱e̱. Amo̱se̱‑ɔ n de kpa fe̱yɛ m ba amo̱ bo̱ waa ane̱ŋ ne̱ mo̱ e̱ kpa‑ɔ. Bɛɛɛ a bo̱ fo̱ gya fe̱yɛ mo̱ a waa ke̱dame̱naŋsɛ ne̱e̱ e̱e̱e̱?’ ” ");
INSERT INTO ncuNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ne̱ Yeesuu yɛ, “Amo̱ e̱ gye̱ saase̱bɛɛ. Amo̱se̱ se̱‑ɔ nsii-amɛɛ i kii agye̱ŋkpɛɛpo̱, na agye̱ŋkpɛɛpo̱ mɔ kii nsii-amɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yeesuu a me̱raa se̱ ɔ yɔ Yɛro̱salɛm‑ɔ, ne̱ oo lee mò̱ agyase̱po̱ kudu anyɔ‑ɔ keri si, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Mo̱nꞌ nu mo̱ ase̱. Yɛro̱salɛm ne̱ ane̱ e̱ yɔ mɔ‑ɔ, ne̱ ba ba mo̱, dimaadi mò̱ gyi‑o, a bo̱ bo̱ waa Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ na Wuribware̱ mbraa akaapo̱po̱ ke̱sare̱e̱‑rɔ. Bamo̱ e̱ gye̱ ne̱ ba gyi mo̱ ase̱ŋ na bo̱ bu mo̱ ke̱pɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Na ŋkee bo̱ taa mo̱ sa Roma awuye ne̱ baa kɔɔre̱ ane̱ maŋ‑ɔ na bo̱ mɔɔ mo̱. Roma awuye mɔ e̱ waa mo̱ ŋwaagyise̱ŋŋe̱, na bo̱ da mo̱ paara, na bo̱ da mo̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱. Amaa ke̱mo̱ ŋke nsa Wuribware̱ i kyiŋŋi mo̱ a ɔ le̱e̱ lowi‑ro.” ");
INSERT INTO ncuNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","To, ne̱ Yeesuu a agyase̱po̱‑ɔ anyɔ ko̱ a lee mò̱ keri si na bo̱ ko̱re̱ mò̱ ko̱tɔko̱. Bamo̱ e̱ gye̱ Sibidii mò̱ agyi nyaŋsɛ anyɔ‑ɔ Yakubu na Yohanee. Ne̱ baa yaa bamo̱ nyi Yeesuu ase̱ na ɔ tɔwe̱ bamo̱ kanɔ se̱ ase̱ŋ. Ne̱ ɔkye̱e̱‑ɔ a kpuni aŋurii Yeesuu ayaa‑rɔ, ne̱ ɔɔ ko̱re̱ mò̱ ko̱tɔko̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Tɔwe̱ ke̱tɔ ne̱ fo̱ e̱ kpa‑ɔ gywii mo̱.” Ne̱ ɔkye̱e̱‑ɔ yɛ, “Mo̱ e̱ kpa fe̱yɛ fo̱ ya kye̱na fo̱ kuwure‑o si, na fo̱ sa a mo̱ agyi nyaŋsɛ anyɔ mɔ kye̱na fo̱ ase̱, ɔko̱ŋko̱ kye̱na fo̱ kigyise si, na ɔko̱ŋko̱‑ɔ mɔ kye̱na fo̱ ke̱be̱na se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “Mo̱ne̱ mo̱ŋ nyi ane̱ŋ ne̱ ke̱tɔ ne̱ mo̱ne̱ i bise mo̱ne̱ e̱ kpa‑ɔ du‑o. Mo̱ne̱ e̱ taare̱ a mo̱nꞌ gyi awo̱re̱fɔɔ ko̱ŋko̱ ne̱ mo̱ e̱ ba a m bo̱ gyi‑o ooo? Ne̱ mo̱ne̱ e̱ taare̱ a mo̱nꞌ nyite ase̱ŋ dɛɛ ne̱ ase̱sɛ e̱ taa a bo̱ bo̱ laye̱ mo̱‑ɔ ɔɔɔ?” Ne̱ baa be̱ŋŋaa fe̱yɛ, “Ane̱ e̱ taare̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ ane̱ŋ ne̱ mo̱ i gyi awo̱re̱fɔɔ‑ɔ, ane̱ŋ dɛɛ ne̱ mo̱ne̱ i gyi. Amaa n gye̱ mo̱ e̱ gye̱ ne̱ mo̱ i lee mò̱ ne̱ ɔ kye̱na mo̱ kigyise si‑o na mò̱‑ɔ mò̱ ne̱ ɔ kye̱na mo̱ ke̱be̱na se̱‑ɔ. N se̱ Wuribware̱ e̱ gye̱ ne̱ o lee e̱kye̱nakpa amo̱ a ɔ bo̱ sa bamo̱ ne̱ ɔɔ lɔŋŋɔ mfe̱ŋ bo̱ ye̱ra bamo̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Saŋ ne̱ Yeesuu agyase̱po̱ kudu ne̱ baa saŋ‑ɔ a nu ane̱ŋ ne̱ Yakubu na Yohanee e̱ kpa fe̱yɛ Yeesuu sa bamo̱ ke̱dabe̱ kyo̱ŋ bamo̱ pɛɛɛ‑ɔ, ne̱ bamo̱ iduŋ a fwii Yakubu na Yohanee si. ");
INSERT INTO ncuNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mfe̱ŋ ne̱ Yeesuu a te̱e̱ bamo̱ pɛɛɛ bo̱ gyaŋŋe̱, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Ne̱e̱ mo̱ne̱ nyi fe̱yɛ kaye̱ mɔ‑rɔ ase̱sɛ‑rɔ fe̱raa, bamo̱ ne̱ bo̱ de maŋ‑ɔ na agye̱ŋkpɛɛpo̱‑ɔ e̱ gye̱ ne̱ bo̱ de ke̱yaale̱ŋ ba gyi ɔke̱maa se̱ ɛ? ");
INSERT INTO ncuNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Amaa mo̱ne̱‑rɔ fe̱raa n gye̱ ane̱ŋ ne̱ a du‑o ne̱e̱. Ɔko̱ ne̱ ɔ kpa fe̱yɛ ɔ waa mo̱ne̱‑rɔ ɔbre̱sɛ bɛɛɛ se̱sɛ dabe̱‑ɔ suŋ sa mo̱ne̱ ne̱ mo̱ne̱ a saŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ne̱ ɔko̱ ne̱ mò̱ e̱ kpa fe̱yɛ o kii mo̱ne̱‑rɔ ɔgye̱ŋkpɛɛpo̱‑ɔ, amo̱ fe̱raa se̱sɛ‑ɔ taa mò̱ e̱ye̱e̱ bo̱ waa mo̱ne̱ ke̱nya, ");
INSERT INTO ncuNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","fe̱yɛ ane̱ŋ ne̱ mo̱, dimaadi mò̱ gyi‑o, mo̱ŋ ba fe̱yɛ ɔko̱ suŋ sa mo̱‑ɔ. Mo̱ a ba ne̱e̱ fe̱yɛ m bo̱ waa asuŋ bo̱ sa ase̱sɛ ne̱e̱, na ŋ wu bo̱ sa ase̱sɛ bwe̱e̱tɔ, na ŋ ka ko̱kɔ sa bamo̱ a bo̱ be̱e̱ nya nya bamo̱ e̱ye̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ a bo̱rɔ Yɛrikoo maŋ‑nɔ. Bamo̱ a le̱e̱ mfe̱ŋ ba yɔ‑ɔ, ne̱ ase̱sɛ biribiri a gya bamo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Amɔ ate̱napo̱ anyɔ ko̱ i te kpa‑ɔ kɛɛ. Bamo̱ a nu fe̱yɛ Yeesuu e̱ gye̱ ne̱ ɔ kyo̱ŋ kpa amo̱ se̱‑ɔ, ne̱ baa le̱e̱ ba fɛɛ‑rɔ ba te̱e̱ mò̱ fe̱yɛ, “Ane̱ nyaŋpe̱, Deefid mò̱ nana, ŋu ane̱ e̱wɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ne̱ ase̱sɛ‑ɔ a fɛɛ bamo̱ se̱ fe̱yɛ bo̱ laatɔ. Amaa ŋkee gbaa ne̱ baa me̱raa se̱ ba fɛɛ‑rɔ keŋkeŋ‑o ne̱e̱ fe̱yɛ, “Ane̱ nyaŋpe̱, Deefid mò̱ nana, ŋu ane̱ e̱wɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ne̱ Yeesuu a ye̱re̱. Ne̱ ɔɔ te̱e̱ bamo̱ baa mò̱ ase̱. Bamo̱ a ba‑ɔ, ne̱ oo bise bamo̱ fe̱yɛ, “Nte̱tɔ ne̱ mo̱ne̱ e̱ kpa fe̱yɛ ŋ waa sa mo̱ne̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ne̱ bo̱ yɛ, “Ane̱ nyaŋpe̱, ane̱ e̱ kpa fe̱yɛ fo̱ sa a ane̱ akatɔ buŋŋi ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ne̱ Yeesuu a ŋu bamo̱ e̱wɛɛ, ne̱ ɔɔ dabo̱rɔ bamo̱ akatɔ. Puri amo̱‑rɔ mfe̱ŋ ne̱ bamo̱ akatɔ a buŋŋi. Ne̱ baa gya mò̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Bamo̱ a kpa a bo̱ fo̱ Yɛro̱salɛm‑ɔ, ne̱ baa lwee kamaŋgyii ko̱ ne̱ ba te̱e̱ ɛ Bɛtɛfage̱, ne̱ ka maa Mfɔ-Ayii ke̱be̱e̱‑ɔ‑rɔ. Mfe̱ŋ‑ɔ ne̱ Yeesuu a suŋ mò̱ agyase̱po̱‑ɔ anyɔ bo̱ gye̱ ŋkpɛɛ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱nꞌ yɔ kamaŋgyii ne̱ ka bo̱ akatɔ‑rɔ‑ɔ‑rɔ. Mo̱ne̱ ya de̱ŋ fo̱ mfe̱ŋ, mo̱ne̱ i ŋu bamo̱ a ŋure kukurumanyi ko̱ bo̱ ye̱ra na mò̱ gyi ye̱re̱ mò̱ ase̱. Na mo̱nꞌ saŋŋe̱ bamo̱ baa mo̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ɔko̱ ya bise mo̱ne̱ ke̱tɔ se̱ ne̱ mo̱ne̱ e̱ saŋŋe̱ bamo̱‑ɔ, na mo̱nꞌ tɔwe̱ gywii se̱sɛ‑ɔ fe̱yɛ mo̱ne̱ nyaŋpe̱ e̱ gye̱ ne̱ ɔ kpa. Mo̱ne̱ ya tɔwe̱ ane̱ŋ, na ɔ sa mo̱ne̱ kpa fe̱yɛ mo̱nꞌ taa bamo̱ baa.” ");
INSERT INTO ncuNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Amo̱‑ɔ a ba ne̱e̱ a ke̱tɔ ne̱ Wuribware̱ kyaamɛɛ ko̱ a kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ nya waa kase̱ŋtiŋ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mo̱nꞌ tɔwe̱ gywii Yɛro̱salɛm maŋ awuye, fe̱yɛ, ‘Mo̱nꞌ ke̱e̱, mo̱ne̱ owure e̱ ba mo̱ne̱ ase̱‑ɔ. Ɔ gye̱ ɔwo̱rɔba, ne̱ ɔɔ de̱e̱ kakurumagyii ɔ ba.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ne̱ agyase̱po̱ anyɔ amo̱ a ya waa ane̱ŋ ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ bo̱ waa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ne̱ baa baa kukurumanyi‑o na mò̱ gyi‑o. Ne̱ baa ba bamo̱ awaagya bo̱ dɔŋŋɔ mbo̱‑ɔ mmɛɛ. Ne̱ Yeesuu a de̱e̱ kye̱na kakurumagyii‑o si. ");
INSERT INTO ncuNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ne̱ ase̱sɛ bwe̱e̱tɔ a brawe̱ bamo̱ awaagya‑rɔ bo̱ be̱ya kpa‑ɔ se̱ sa mò̱, ne̱ ɔɔ nare̱ se̱ kyo̱ŋ. Bo̱ko̱ mɔ a ŋeri afe̱raa le̱e̱ ayii ne̱ a maa kpa kɛɛ‑ɔ bo̱ dɔŋŋɔ kpa‑ɔ se̱ sa mò̱, ne̱ ɔɔ nare̱ se̱ kyo̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ŋkee bamo̱ ne̱ bo̱ gye̱ mò̱ ŋkpɛɛ na bamo̱ ne̱ bo̱ gya mò̱ se̱‑ɔ a le̱e̱ ba fɛɛ‑rɔ ne̱e̱ fe̱yɛ, “Mo̱nꞌ sa a ane̱ da Deefid mò̱ nana kakyirele. Wuribware̱ yure mò̱ ne̱ ɔ ba mò̱ ke̱nyare̱‑rɔ‑ɔ. Mo̱nꞌ sa a ane̱ da Wuribware̱ ne̱ ɔ bo̱ so̱so̱‑ɔ kakyirele.” ");
INSERT INTO ncuNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yeesuu a lwee Yɛro̱salɛm maŋ‑nɔ‑ɔ, ne̱ e̱lawo̱ a de̱e̱ maŋ‑ɔ‑rɔ to̱ŋ ke̱maa, ne̱ bo̱ yɛ, “Ne̱ nsɛ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ne̱ ase̱sɛ ne̱ bamo̱ aa Yeesuu a yɔ‑ɔ a lee kanɔ fe̱yɛ, “Wuribware̱ kyaamɛɛ Yeesuu‑o ne̱e̱. Ɔɔ le̱e̱ Nasarɛt maŋ ne̱ ɔ bo̱ Galile̱ya swe̱e̱re̱ se̱‑ɔ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Amo̱ kamɛɛ‑rɔ‑ɔ, ne̱ Yeesuu a ya lwee Wuribware̱ suŋkpa‑ɔ kabuno. Ne̱ oo ŋu ayawo̱gyipo̱ te mfe̱ŋ ba fe atɔ na bo̱ko̱ e̱ sɔɔ. Bo̱ko̱ mɔ te bamo̱ iteeburi ase̱ mfe̱ŋ ba kyeeri Roma swe̱e̱re̱ se̱ atanne̱ ba yaa Yude̱ya swe̱e̱re̱ se̱ atanne̱‑rɔ. Ase̱sɛ mɔ‑rɔ bo̱ko̱ mɔ te bamo̱ ngya se̱ ba fe awurele̱pɔ ne̱e̱. To, Yeesuu a ya to̱ bamo̱ ane̱ŋ‑ɔ, ne̱ ɔɔ gye̱ra gye̱ra bamo̱ iteeburi‑o na bamo̱ ngya‑ɔ bo̱ da, ne̱ ɔɔ gya bamo̱ bo̱ kyo̱ŋwe̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Ne̱e̱ baa kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ Wuribware̱ yɛ, ‘Mo̱ lɔŋ‑ɔ i kii ke̱kyaŋ ne̱ kaye̱ mɔ‑rɔ ase̱sɛ pɛɛɛ e̱ ba a bo̱ bo̱ nya ko̱re̱ ke̱bware̱ko̱re̱‑ɔ.’ Amaa mo̱ne̱ a taa mfe̱ŋ bo̱ kii ‘ayu lɔŋ ne̱e̱’ bɛɛɛ?” ");
INSERT INTO ncuNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Wuribware̱ suŋkpa a kabuno‑o mfe̱ŋ ne̱ ate̱napo̱ na agyabɔɔ a ba mò̱ ase̱, ne̱ ɔɔ kya bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ne̱ ŋyaagyi a fɛɛ‑rɔ ane̱ŋ‑aaa fe̱yɛ, “Mo̱nꞌ sa a ane̱ da Deefid mò̱ nana kakyirele.” Ne̱ Wuribware̱ alɔŋŋɔpo̱ na Wuribware̱ mbraa akaapo̱po̱ a ŋu akpe̱ŋe̱ye̱e̱tɔ ne̱ Yeesuu a waa‑ɔ, ne̱ baa nu ane̱ŋ ne̱ ŋyaagyi‑o e̱ fɛɛ‑rɔ‑ɔ, ne̱ bamo̱ iduŋ a fwii Yeesuu si. ");
INSERT INTO ncuNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ne̱ baa bise mò̱ fe̱yɛ, “Fo̱ a nu ane̱ŋ ne̱ ŋyaagyi mɔ e̱ tɔwe̱‑ɔ ɔɔɔ? Ke̱tɔ bware aaa?” Ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “A bware. Ne̱e̱ mo̱ne̱ mo̱ŋ tɛɛ kare̱ ke̱tɔ ne̱ baa kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ fe̱yɛ, ‘Ane̱ nyaŋpe̱ Wuribware̱, fo̱ a sa ne̱ e̱lawo̱ ne̱ ŋyaagyi ngyingyii e̱ waa mfe̱e̱‑ɔ a sa ne̱ fo̱ a nya ke̱dabe̱.’ ɛ?” ");
INSERT INTO ncuNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ne̱ Yeesuu a le̱e̱ bamo̱ ase̱ maŋ‑ɔ‑rɔ yɔ kamaŋgyii ko̱ ne̱ ba te̱e̱ ɛ Bɛtaniya, ne̱ oo di mfe̱ŋ kraye̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kaye̱ ŋke gye̱gyaye̱ tututu‑o, ne̱ Yeesuu a kiŋŋi ɔ yɔ maŋ‑ɔ‑rɔ. Ne̱ ako̱ŋ de mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Mfe̱ŋ ne̱ oo ŋu figi kiyii ko̱ ye̱re̱ kpa kɛɛ. Ne̱ ɔɔ yɔ a ɔ ya de̱e̱re̱ ke̱mo̱ se̱ fe̱yɛ ɔ nya ke̱mo̱ agyi a o gyi aaa. Amaa mò̱ a yɔ ke̱mo̱ kaase̱‑ɔ, sɛye̱ mo̱ŋ te ke̱mo̱ se̱, amɔ afe̱raa wo̱re̱. Amo̱se̱‑ɔ ne̱ ɔɔ tɔwe̱ gywii kiyii‑o fe̱yɛ, “Fo̱ mo̱ŋ lɛɛ fo̱ bo̱‑rɔ a fo̱ swɛɛ agyi daa.” Puri amo̱‑rɔ mfe̱ŋ ne̱ kiyii amo̱ a wu. ");
INSERT INTO ncuNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yeesuu agyase̱po̱‑ɔ a ŋu fe̱yɛ kiyii amo̱ a wu‑o, ne̱ aa kpe̱ŋ bamo̱ e̱ye̱e̱. Ne̱ bo̱ yɛ, “E̱me̱ne̱ ne̱ figi kiyii mɔ a waa wu puri mɔ‑rɔ ane̱ŋ?” ");
INSERT INTO ncuNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ, mo̱ne̱ ya kɔɔre̱ Wuribware̱ gyi, ne̱ mo̱ne̱ e̱ mo̱ŋ lwii kamɛɛ, amo̱ fe̱raa mo̱ne̱ e̱ taare̱ a mo̱nꞌ waa ane̱ŋ ne̱ mo̱ a waa kiyii mɔ mfe̱e̱‑ɔ. N gye̱ amo̱ wo̱re̱ gbaa, amaa mo̱ne̱ e̱ taare̱ a mo̱nꞌ tɔwe̱ gywii ke̱be̱e̱ mɔ fe̱yɛ, ‘Ko̱so̱ nare̱ ya twe̱e̱ fo̱ e̱ye̱e̱ waa ɔpo̱o̱‑rɔ.’ Na Wuribware̱ sa a ke̱tɔ waa ane̱ŋ sa mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Amo̱se̱‑ɔ, mo̱ne̱ ya ko̱re̱ Wuribware̱ ko̱tɔko̱, ne̱ mo̱ne̱ a kɔɔre̱ gyi fe̱yɛ ɔ sa mo̱ne̱ ke̱tɔ amo̱, mo̱ne̱ e̱ nya.” ");
INSERT INTO ncuNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ne̱ Yeesuu a kiŋŋi ba Wuribware̱ suŋkpa a kabuno‑o. Ne̱ ɔɔ kaapo̱ lamaŋ abware̱se̱ŋ mfe̱ŋ. Mò̱ a maa se̱ ɔ kaapo̱‑ɔ, ne̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ na maŋ‑ɔ abre̱sɛ a ba mò̱ ase̱. Ne̱ baa bise mò̱ fe̱yɛ, “Nsɛ ya sa fo̱ kpa fe̱yɛ fo̱ bo̱ gya ase̱sɛ bo̱ le̱e̱ Wuribware̱ suŋkpa a kabuno‑o mfe̱e̱? Ne̱ nsɛ ya sa fo̱ kpa fe̱yɛ fo̱ kaapo̱ atɔ mfe̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Mfe̱ŋ ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “To, mo̱‑ɔ mo̱ i bise mo̱ne̱ ase̱ŋ ko̱ŋko̱ kpeŋ, ne̱ mo̱ne̱ ya taare̱ be̱ŋŋaa mo̱ nɛɛnɛɛ fe̱raa, mo̱‑ɔ mo̱ e̱ kaapo̱ mo̱ne̱ kpa ne̱ n de fe̱yɛ m bo̱ waa ane̱ŋ a atɔ mɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Mo̱nꞌ kaapo̱ mo̱ mò̱ ne̱ ɔɔ sa Yohanee Osuubɔpo̱‑ɔ kpa fe̱yɛ ɔ bɔ asuu‑o? Wuribware̱ ya sa mò̱ bɛɛɛ dimaadi aaa?” Mfe̱ŋ ne̱ bamo̱ wo̱re̱ wo̱re̱ a le̱e̱ ba gyiiri ikii fe̱yɛ, “E̱me̱ne̱ ne̱ ane̱ tɔwe̱‑ɔ ne̱e̱? Bo̱ le̱e̱ fe̱yɛ ane̱ ya tɔwe̱ fe̱yɛ Wuribware̱ ya sa Yohanee kpa fe̱yɛ ɔ bɔ asuu, o bise ane̱ fe̱yɛ, ‘Nte̱tɔ se̱ ne̱e̱ ne̱ mo̱ne̱ mo̱ŋ kɔɔre̱ Yohanee gyi?’ ");
INSERT INTO ncuNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ne̱ ane̱ mɔ ane̱ ya tɔwe̱ fe̱yɛ dimaadi ya sa mò̱ kpa, e̱me̱ne̱ ne̱ lamaŋ mɔ e̱ waa ane̱? Ane̱ se̱re̱ bamo̱, a le̱e̱ fe̱yɛ bamo̱ ɔke̱maa a kɔɔre̱ gyi fe̱yɛ Yohanee gye̱ Wuribware̱ a akyaamɛɛ‑ɔ ɔko̱ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Amo̱se̱ se̱‑ɔ ne̱ baa be̱ŋŋaa Yeesuu fe̱yɛ, “Ane̱ mo̱ŋ nyi ɔko̱ ne̱ ɔɔ sa Yohanee kpa fe̱yɛ ɔ bɔ asuu‑o.” Ne̱ Yeesuu mɔ a tɔwe̱ gywii bamo̱ fe̱yɛ, “Ane̱ŋ fe̱raa, ŋ gbaa ma tɔwe̱ ɔko̱ ne̱ ɔɔ sa mo̱ kpa fe̱yɛ ŋ waa ke̱tɔ ne̱ mo̱ e̱ waa‑ɔ a n gywii mo̱ne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “E̱me̱ne̱ ne̱ mo̱ne̱ e̱ fa fe̱yɛ kitee mɔ e̱ kaapo̱? N gye̱ ɔnyare̱ ko̱ e̱ bo̱‑rɔ aaa? Ne̱ o de mò̱ agyi nyaŋsɛ anyɔ. Kake ŋko̱ ne̱ ɔɔ ya ko̱re̱ mò̱ gyi bre̱sɛ‑ɔ to̱rɔɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ne̱ ɔɔ tɔwe̱ gywii mò̱ se̱ fe̱yɛ, ‘Ma yɔ.’ Amaa ke̱tɔ a waa kafwe̱e̱‑ɔ, ne̱ oo nu mò̱ e̱ye̱e̱, ne̱ ɔɔ yɔ mò̱ se̱ a ko̱dɔɔ‑ɔ‑rɔ ya dɔɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Saŋ amo̱ mò̱ se̱ kyɔ o yii mò̱ gyi nyɔse̱po̱‑ɔ ase̱ a ɔ ya ko̱re̱ mò̱ to̱rɔɔ ane̱ŋ dɛɛ. Ne̱ ɔɔ be̱ŋŋaa mò̱ se̱ fe̱yɛ, ‘Yooo, n se̱, mo̱ a nu. Mo̱ e̱ yɔ.’ Amaa mò̱‑ɔ mɔ mo̱ŋ yɔ.” Ne̱ Yeesuu a bise bo̱ gye̱ kɛɛ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Ŋnyaŋsɛɛ ŋnyɔ mɔ‑rɔ‑ɔ, bamo̱ mmo̱ ya waa mò̱ se̱ ke̱pre̱? Mo̱nꞌ lee kanɔ a n nu.” Ne̱ baa lee kanɔ fe̱yɛ, “Gyi bre̱sɛ‑ɔ.” Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Kase̱ŋtiŋ ne̱e̱. Ke̱tɔ ne̱ mo̱ e̱ kaapo̱ mo̱ne̱‑ɔ e̱ gye̱ fe̱yɛ apoo leŋpoo akɔɔre̱po̱ na apurimakye̱e̱ e̱ gye̱ ne̱ ba gye̱ ŋkpɛɛ a bo̱ tii Wuribware̱ se̱ a kuwure‑o si na mo̱ne̱ te. ");
INSERT INTO ncuNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Bo̱ le̱e̱ fe̱yɛ Yohanee Osuubɔpo̱‑ɔ a ba mo̱ne̱ ase̱ ne̱e̱ a ɔ bo̱ kaapo̱ mo̱ne̱ e̱kpa timaa na mo̱nꞌ bo̱rɔ se̱. Ne̱ mo̱ne̱ mɔ mo̱ne̱ mo̱ŋ kɔɔre̱ mò̱ gyi. Amaa leŋpoo akɔɔre̱po̱‑ɔ na apurimakye̱e̱‑ɔ fe̱raa a kɔɔre̱ mò̱ gyi. Mo̱ne̱ a ŋu amo̱‑ɔ gbaa ooo, mo̱ne̱ mo̱ŋ kyurowi mo̱ne̱ mfɛɛre̱ na mo̱nꞌ kɔɔre̱ mò̱ gyi.” ");
INSERT INTO ncuNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ne̱ Yeesuu yɛ, “Mo̱nꞌ nu mo̱ ase̱, na m be̱e̱ tɔwe̱ kitee ko̱. N gye̱ ko̱dɔɔ wuye ko̱ ya dɛɛ kye̱na aaa? Ne̱ oo dwii bobe ayii ko̱, ne̱ amo̱ ya swɛɛ agyi ne̱ bo̱ de ba waa nta‑ɔ. Ne̱ oo gyi bane̱ dabe̱ bo̱ muruwaa, ne̱ oo kwii ke̱maŋtaŋ ko̱dɔɔ‑ɔ‑rɔ, na ɔ taa ayii‑o agyi bo̱ waa‑rɔ a bo̱ kyikye si lee amo̱ nkyu‑o. Ne̱ ɔɔ be̱e̱ waa ko̱tɔko̱ ne̱ ba de̱e̱ ye̱re̱ ke̱mo̱ se̱ a bo̱ de̱e̱re̱ ko̱dɔɔ‑ɔ se̱‑ɔ bo̱ ye̱ra ko̱dɔɔ‑ɔ‑rɔ. Ne̱ ɔɔ taa sa apafo̱wɔ ko̱ fe̱yɛ bo̱ de̱e̱re̱ se̱ sa mò̱, ne̱ ɔɔ le̱e̱ pe̱ tu kpa yɔ ke̱fɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Saŋ ne̱ ayii a agyi‑o a be̱re̱, ne̱ amo̱ kiteebe̱e̱ a fo̱‑ɔ, ne̱ ko̱dɔɔ‑ɔ wuye‑o a suŋ mò̱ ayaafɔre̱ ko̱ bo̱ kyo̱ŋwe̱ apafo̱wɔ amo̱ ase̱ fe̱yɛ bo̱ yɔ na apafo̱wɔ‑ɔ ke ke̱tɔ ne̱ baa nya le̱e̱ mò̱ ko̱dɔɔ‑ɔ‑rɔ‑ɔ‑rɔ, na bo̱ taa mò̱ lee bo̱ kyo̱ŋwe̱ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ayaafɔre̱ amo̱ a yɔ apafo̱wɔ‑ɔ ase̱‑ɔ, ne̱ apafo̱wɔ‑ɔ a kra bamo̱ ɔko̱ ne̱ baa da mò̱, ɔko̱ mɔ ne̱ baa mɔɔ, ne̱ ɔko̱ mɔ be̱e̱ baa twe̱e̱ abu bo̱ da mò̱ mɔɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Amo̱se̱‑ɔ ne̱ ko̱dɔɔ‑ɔ wuye‑o a be̱e̱ suŋ ayaafɔre̱ ko̱ na bo̱ kyɔ ke̱gye̱ŋkpɛɛ a bo̱mo̱‑ɔ. Amaa ane̱ŋ dɛɛ ne̱ apafo̱wɔ amo̱ a be̱e̱ waa bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Lalalo̱we̱‑ɔ ne̱ oo suŋ mò̱ gyi bo̱ kyo̱ŋwe̱ apafo̱wɔ amo̱ ase̱. Ne̱ ɔɔ fa mò̱ mfɛɛre̱ fe̱yɛ, ‘Mo̱ e̱ kɔɔre̱ a n gyi fe̱yɛ ba bu mo̱ gyi‑o.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Saŋ ne̱ apafo̱wɔ amo̱ a ŋu kayaagyi‑o e̱ ba‑ɔ, ne̱ ŋkee ba tɔwe̱ ba gywii abɛɛ fe̱yɛ, ‘Ke̱e̱ ko̱dɔɔ‑ɔ wuye‑o mò̱ gyi‑o ne̱ mò̱ se̱ ya wu o gyi mò̱ kapo̱tɛɛ‑ɔ e̱ ba‑ɔ. Mo̱nꞌ sa a ane̱ mɔɔ mò̱, na mò̱ se̱ a ko̱dɔɔ mɔ kii ane̱ lee.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Amo̱se̱‑ɔ ne̱ baa kra mò̱ kayaagyi amo̱, ne̱ baa gyiiri mò̱ le̱e̱ ko̱dɔɔ‑ɔ‑rɔ, ne̱ baa mɔɔ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","To, mo̱ne̱ e̱ kɔɔre̱ mo̱ne̱ i gyi fe̱yɛ bobe ko̱dɔɔ‑ɔ wuye‑o fɔŋfɔŋ ya ba apafo̱wɔ amo̱ ase̱, e̱me̱ne̱ ne̱ ɔ waa bamo̱‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ne̱ baa lee kanɔ fe̱yɛ, “A waa kanɔ ŋke̱maa ɔ mɔɔ ase̱sɛ bɔye̱ amo̱. Na ɔ bo̱ taa ko̱dɔɔ‑ɔ sa ase̱sɛ baŋbaŋ na bo̱ de̱e̱re̱ se̱ sa mò̱. Na kiteebe̱e̱ ya fo̱, bo̱ ke ayii‑o agyi‑ro na bo̱ taa mò̱ lee bo̱ kyo̱ŋwe̱ mò̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ne̱ Yeesuu yɛ, “Kase̱ŋtiŋ ne̱e̱. Mo̱ a kɔɔre̱ gyi fe̱yɛ mo̱ne̱ a kare̱ abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ, ‘Ke̱fo̱re̱ serisɛ ko̱ ne̱ apwɛɛpo̱ de bo̱ pwɛɛ ne̱ baa kine ke̱mo̱ bo̱ twe̱e̱‑ɔ, ya ko̱ŋ bo̱ kii ke̱mo̱ ne̱ kaa le̱ŋ lɔŋ‑ɔ pɛɛɛ bo̱ ye̱ra‑ɔ. Wuribware̱ ya sa ne̱ aa ba ane̱ŋ, ne̱ aa kpe̱ŋ ane̱ e̱ye̱e̱ ke̱baŋse̱.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ne̱ Yeesuu a tɔwe̱ bo̱ gye̱ kɛɛ fe̱yɛ, “Amo̱se̱ se̱‑ɔ mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ Wuribware̱ i lee mo̱ne̱ Isireelii awuye a ɔ bo̱ le̱e̱ mò̱ kuwure‑o‑ro, na ɔ be̱e̱ te̱e̱ ase̱sɛ baŋbaŋ baa bo̱ tii ke̱mo̱ se̱. Ane̱ŋ a ase̱sɛ mɔ e̱ gye̱ bamo̱ ne̱ bamo̱ awaasɛ e̱ kaapo̱ fe̱yɛ baa fo̱ fe̱yɛ bo̱ tii kuwure‑o si‑o.  ");
INSERT INTO ncuNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ɔke̱maa ne̱ mò̱ ya le̱e̱ da ke̱fo̱re̱ amo̱ se̱, ke̱ e̱ te̱ŋŋe̱ se̱sɛ‑ɔ‑rɔ kyikpuri kyikpuri. Ne̱ ke̱mo̱ ya le̱e̱ da ɔko̱ se̱, na ko̱ kwɛɛ mò̱ waa fe̱yɛ e̱se̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na Farisii awuye‑o a nu itee amo̱ ne̱ Yeesuu a tɔwe̱‑ɔ, ne̱ baa pini fe̱yɛ ɔ kaapo̱ fe̱yɛ bo̱ du fe̱yɛ apafo̱wɔ bɔye̱ amo̱ na apwɛɛpo̱ ne̱ baa kine ke̱fo̱re̱ serisɛ‑ɔ ke̱bo̱ pwɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Amo̱se̱‑ɔ ba kpa mò̱ a bo̱ kra. Amaa bamo̱ a se̱re̱ lamaŋ‑ɔ se̱‑ɔ, bo̱ mo̱ŋ taare̱, a le̱e̱ fe̱yɛ lamaŋ‑ɔ fe̱raa yɛ ɔ gye̱ Wuribware̱ a akyaamɛɛ‑ɔ ɔko̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ne̱ Yeesuu a be̱e̱ ba kitee ko̱ bo̱ sa se̱ŋsa gywii ase̱sɛ ne̱ ba nu mò̱ ase̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Ne̱ ɔ yɛ, “Mo̱nꞌ nu ane̱ŋ ne̱ Wuribware̱ se̱ a kuwure‑o du‑o. N gye̱ owure ko̱ e̱ dɛɛ ɔ bo̱‑rɔ aaa? Ne̱ mò̱ gyi nyaŋsɛ‑ɔ e̱ kpa a ɔ waare̱e̱ ɔkye̱e̱. Ne̱ owure‑o a waa ko̱ko̱fɔ‑rɔ ateese siraa sa mò̱ gyi‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ne̱ oo suŋ mò̱ ayaafɔre̱ bo̱ kyo̱ŋwe̱ ase̱sɛ ne̱ oo nyiŋŋi bamo̱‑ɔ ase̱, fe̱yɛ saŋ a fo̱ fe̱yɛ bo̱ ba na bo̱ gyi ateese bo̱ gyi akatɔ. Amaa bamo̱ ɔke̱maa a kine ke̱ba. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ne̱ ɔɔ be̱e̱ suŋ ayaafɔre̱ ko̱ bamo̱ ase̱ bo̱ tɔwe̱ gywii bamo̱ fe̱yɛ, ‘Mo̱ a waa ko̱ko̱fɔ‑rɔ a ateese‑o lo̱we̱. Mo̱ a mɔɔ mo̱ e̱naate̱‑rɔ e̱dabe̱dabe̱‑ɔ, ne̱ mo̱ a waa ke̱tɔ ke̱maa siraa lo̱we̱. Amo̱se̱‑ɔ mo̱nꞌ bo̱ gyi.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Amaa afɔ‑ɔ ɔke̱maa mo̱ŋ be̱ŋŋaa owure a ayaafɔre̱‑ɔ. Bamo̱‑rɔ ɔko̱ŋko̱ a yɔ mò̱ ndɔɔ‑rɔ, ne̱ ɔko̱ŋko̱ mɔ a yɔ mò̱ yawo̱gyikpa. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Bamo̱ ne̱ baa saŋ‑ɔ mɔ a kra owure a ayaafɔre̱‑ɔ ne̱ baa da bamo̱ mɔɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ke̱mo̱ ne̱ owure‑o de? Mò̱ duŋ a fwii bwe̱e̱tɔ, ne̱ oo suŋ mò̱ asoogyaa awuye, ne̱ baa ya mɔɔ ane̱ŋ a ase̱sɛ bɔye̱‑ɔ kywɛɛ bamo̱ maŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ne̱ ɔɔ be̱e̱ te̱e̱ mò̱ ayaafɔre̱‑ɔ bo̱ gyaŋŋe̱, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, ‘Mo̱ a waa ko̱ko̱fɔ‑rɔ a ateese‑o siraa lo̱we̱, amaa bamo̱ ne̱ mo̱ a nyiŋŋi fe̱yɛ bo̱ ba‑ɔ a kine ke̱ba. Ane̱ŋ a ase̱sɛ‑ɔ mo̱ŋ fo̱ fe̱yɛ bo̱ bo̱ gyi mo̱ ateese‑o ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Amo̱se̱‑ɔ mo̱ e̱ kpa a n te̱e̱ ase̱sɛ baŋbaŋ na bo̱ ba. Mo̱nꞌ nare̱ yɔ maŋ‑nɔ mbo̱re̱ se̱ ya te̱e̱ se̱sɛ ke̱maa ne̱ mo̱ne̱ i ŋu‑o na ɔ ba mfe̱e̱ bo̱ gyi mo̱ ateese‑o.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ne̱ mò̱ ayaafɔre̱‑ɔ a yɔ maŋ‑nɔ a mbo̱re̱‑ɔ se̱ ya te̱e̱ ase̱sɛ timaa na abɔye̱ pɛɛɛ ne̱ baa ŋu mfe̱ŋ‑ɔ. Ne̱ baa ba ateese‑o gyikpa‑ɔ. Bamo̱ a ba‑ɔ, baa bo̱rɔ owure a gyikpa a ke̱kyaŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ne̱ owure‑o a lwee gyikpa a ke̱kyaŋ‑ɔ‑rɔ ya sa mò̱ afɔ amo̱ aŋsɛ na ke̱ba. Mò̱ a bo̱ mfe̱ŋ‑ɔ, ne̱ oo ŋu se̱sɛ ko̱ na ɔ mo̱ŋ buŋ ko̱ko̱fɔ‑rɔ‑ɔ waagya. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ne̱ oo bise mò̱ fe̱yɛ, ‘Mo̱ nyare̱, e̱me̱ne̱ ne̱ fo̱ a waa ba mfe̱e̱ na fo̱ mo̱ŋ buŋ ko̱ko̱fɔ‑rɔ waagya‑ɔ ne̱e̱?’ Amaa se̱sɛ‑ɔ mo̱ŋ taare̱ lee kanɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ne̱ owure‑o a sa mò̱ ayaafɔre̱ ne̱ bo̱ ye̱re̱ mfe̱ŋ‑ɔ kanɔ fe̱yɛ, ‘Mo̱nꞌ ŋure se̱sɛ‑ɔ asare̱e̱ na ayaa, na mo̱nꞌ taa mò̱ twe̱e̱ bo̱ kyo̱ŋwe̱ kawu kibugyii‑ro. Mfe̱ŋ ne̱ ase̱sɛ da ba su na ba duŋwi nnɔ, a le̱e̱ fe̱yɛ bo̱ maa taare̱ a bo̱ lweero ba gyikpa‑ɔ mfe̱e̱.’ Amo̱ e̱ gye̱ saase̱bɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Amo̱se̱ se̱‑ɔ Wuribware̱ a te̱e̱ ase̱sɛ bwe̱e̱tɔ fe̱yɛ bo̱ bo̱ tii mò̱ kuwure‑o si. Amaa ase̱sɛ kafwe̱e̱ ne̱ Wuribware̱ i lee a bo̱ bo̱ kii mò̱ fɔŋfɔŋ ase̱sɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farisii awuye‑o a nu itee ne̱ Yeesuu a waa‑ɔ, ne̱ baa ya buwi e̱kpa na bo̱ bo̱rɔ se̱ bise mò̱ ase̱ŋ lɔɔre̱ mò̱ kanɔ‑rɔ. Na mò̱ ya tɔwe̱ ke̱bɔye̱ ko̱ a bo̱ nya kra mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Amo̱se̱‑ɔ ne̱ baa suŋ bamo̱ fɔŋfɔŋ agyase̱po̱ ko̱ na Owure Hɛrɔd aye̱re̱rɔpo̱ ko̱ bo̱ kyo̱ŋwe̱ Yeesuu ase̱, ne̱ baa ba bo̱ tɔwe̱ kɔne̱ kɔne̱ gywii mò̱ fe̱yɛ, “Ɔkaapo̱po̱, ane̱ nyi fe̱yɛ kase̱ŋtiŋ wuye e̱ gye̱ fo̱, ne̱ fo̱ maa pe̱nna ɔko̱. Na kufu mo̱ŋ de fo̱ fe̱yɛ ase̱sɛ tɔwe̱ fo̱ ase̱ŋ. Fo̱ mo̱ŋ nyi fe̱yɛ se̱sɛ mɔ gye̱ se̱sɛ dabe̱ bɛɛɛ ɔ gye̱ se̱sɛ kagyingyii. Fo̱ fe̱raa fo̱ e̱ kaapo̱ atɔ kase̱ŋtiŋ ne̱ Wuribware̱ e̱ kpa fe̱yɛ se̱sɛ dimaadi ke̱maa waa‑ɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Amo̱se̱‑ɔ ane̱ i bise fo̱ fe̱yɛ, Roma awuye a kɔ ke̱naa gyi ane̱ se̱ kɔɔre̱ ane̱ maŋ‑ɔ se̱‑ɔ, ane̱ ya ka leŋpoo sa bamo̱ owure dabe̱ ne̱ ba te̱e̱ mò̱ ɛ Kaye̱saa‑ɔ, a kye ane̱ Wuribware̱ mbraa‑ɔ bɛɛɛ a maa kye? Tɔwe̱ na ane̱ nu.” ");
INSERT INTO ncuNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Amaa Yeesuu a kyɔ pini bamo̱ mfɛɛre̱ bɔye̱‑ɔ. Ne̱ ɔɔ be̱ŋŋaa bamo̱ fe̱yɛ, “Mo̱ne̱ nnɔ ŋnyɔ ŋnyɔ awuye mɔ. Nte̱tɔ ne̱e̱ ne̱ mo̱ne̱ e̱ kyɔ mo̱‑rɔ mo̱ne̱ e̱ ke̱e̱‑ɔ ne̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","20","Mo̱nꞌ taa atanne̱ fufuri kigyi ne̱ kaa fo̱ siidii kudu‑o, ne̱ mo̱ne̱ de mo̱ne̱ e̱ ka leŋpoo‑o baa mo̱ a ŋ ke̱e̱.” Bamo̱ a taa baa‑ɔ, ne̱ oo bise bamo̱ fe̱yɛ, “Nsɛ fotoo na ke̱nyare̱ e̱ dɔŋ atanne̱ mɔ se̱‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ne̱ baa be̱ŋŋaa fe̱yɛ, “Owure Kaye̱saa lee ne̱e̱.” Ne̱ Yeesuu yɛ, “To, amo̱ fe̱raa, mo̱nꞌ ka ke̱tɔ ne̱ ke̱ gye̱ Kaye̱saa lee‑o sa Kaye̱saa, na mo̱nꞌ ka ke̱mo̱ ne̱ ke̱ gye̱ Wuribware̱ lee‑o sa Wuribware̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ne̱ ane̱ŋ ne̱ Yeesuu a be̱ŋŋaa‑ɔ a kpe̱ŋ bamo̱ e̱ye̱e̱. Amo̱se̱‑ɔ ne̱ baa yɔwe̱ mò̱ bo̱ yii. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kake amo̱ dɛɛ ne̱ Sadukii awuye ko̱ a ba Yeesuu ase̱ ane̱ŋ dɛɛ na bo̱ bo̱ bise mò̱ ase̱ŋ. Amɔ Sadukii awuye mɔ gye̱ Yudaa awuye ko̱ ne̱ ba kɔɔre̱ ba gyi fe̱yɛ se̱sɛ ya wu, mò̱ kayo̱wɔre̱ na mò̱ kra pɛɛɛ a wu, ne̱ ane̱ŋ se̱‑ɔ ɔ maa taare̱ a o kyiŋŋi le̱e̱ lowi‑ro pɛɛɛ‑ɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","To, ne̱ baa bise Yeesuu fe̱yɛ, “Ɔkaapo̱po̱, ane̱ ɔde̱daapo̱ Mosis ya kyo̱rɛɛ mbraa mɔ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ sa ane̱ fe̱yɛ, ɔko̱ ya wu yɔwe̱ mò̱ ka na bo̱ mo̱ŋ ko̱we̱ agyi, se̱sɛ‑ɔ mò̱ tire taa kpenlekye̱e̱‑ɔ waare̱e̱ na bo̱ nya ko̱we̱ kayaagyi. Na bo̱ taa kamo̱ fe̱yɛ mò̱ daa ne̱ oo wu‑o mò̱ gyi ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","To, ɔnyare̱ ko̱ agyi nyaŋsɛ asunoo e̱ dɛɛ bo̱ bo̱ ane̱‑rɔ mfe̱e̱. Ne̱ bamo̱‑rɔ ɔbre̱sɛ‑ɔ a waare̱e̱ ɔkye̱e̱, ne̱ ɔnyare̱‑ɔ a bo̱ wu na mò̱ ka mo̱ŋ ko̱we̱ agyi. Ne̱ ɔɔ yɔwe̱ mò̱ ka sa mò̱ tire ne̱ ɔ gya mò̱ se̱‑ɔ na ɔ waare̱e̱ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ne̱ mò̱ tire amo̱ a taa kpenlekye̱e̱‑ɔ waare̱e̱. Ane̱ŋ dɛɛ ne̱ mò̱ aa mò̱ mo̱ŋ ko̱we̱, ne̱ ɔnyare̱‑ɔ a bo̱ wu. Ɔnyare̱ amo̱ mò̱ tire ne̱ ɔ gya mò̱ se̱‑ɔ ane̱ŋ dɛɛ. Bamo̱ pɛɛɛ a waare̱e̱ bamo̱ daa a kpenlekye̱e̱ amo̱ gyaŋŋe̱ se̱, ne̱ baa wu yɔwe̱ mò̱ na mò̱ aa bamo̱ ɔko̱ mo̱ŋ ko̱we̱ gyi ko̱ŋko̱ gbaa. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","A bo̱‑rɔ ne̱ ɔkye̱e̱‑ɔ mɔ a bo̱ wu gya bamo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ne̱ mbe̱yɔmɔ, bo̱ yɛ ɔke̱maa i kyiŋŋi a ɔ le̱e̱ lowi‑ro. Kake nsi amo̱, bamo̱‑rɔ nsɛ e̱ gye̱ ɔkye̱e̱‑ɔ mò̱ kuri? Bo̱ le̱e̱ fe̱yɛ bamo̱ asunoo‑o pɛɛɛ mɔ a waare̱e̱ mò̱ bo̱ gyaŋŋe̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Mfe̱ŋ ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “Mo̱ne̱ a fo̱ kpa, a le̱e̱ fe̱yɛ mo̱ne̱ mo̱ŋ nyi abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ ase̱ŋ, ne̱ mo̱ne̱ mo̱ŋ nyi ane̱ŋ ne̱ Wuribware̱ ke̱yaale̱ŋ‑ɔ du‑o, ane̱ŋ dɛɛ ne̱ mo̱ne̱ maa nu ke̱mo̱ kaase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","A le̱e̱ fe̱yɛ ase̱sɛ ya kyiŋŋi le̱e̱ lowi‑ro, bamo̱ kakye̱na‑rɔ du ne̱e̱ fe̱yɛ Wuribware̱ a mbɔɔ ne̱ bo̱ bo̱ so̱so̱‑ɔ lee‑o. Amo̱se̱‑ɔ awaare̱yɛ mo̱ŋ lɛɛ a bo̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","To, mo̱ne̱ fe̱raa mo̱ne̱ yɛ alowipo̱‑ɔ maa lɛɛ kyiŋŋi a bo̱ le̱e̱ lowi‑ro. Amaa mo̱ i bise mo̱ne̱ fe̱yɛ mo̱ne̱ mo̱ŋ kare̱ ke̱tɔ ne̱ Wuribware̱ a kaapo̱ mo̱ne̱, ne̱ baa kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ ɔɔɔ? Mfe̱ŋ‑ɔ ɔ yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Mo̱ e̱ gye̱ Wuribware̱, nyaŋpe̱ ne̱ fo̱ nana‑ana Abraham na Isak na Yakubu i suŋ‑o.’ Amo̱ e̱ gye̱ fe̱yɛ ane̱ ade̱daapo̱ amo̱ ne̱ baa wu‑o a saŋ ba suŋ Wuribware̱‑ɔ se̱‑ɔ, a kaapo̱ ne̱e̱ fe̱yɛ bamo̱ a wu gbaa ooo, bamo̱ e̱kra saŋ i te.” ");
INSERT INTO ncuNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Lamaŋ ne̱ ba nu Yeesuu ase̱ mfe̱ŋ‑ɔ a nu mò̱ ke̱kaapo̱ amo̱‑ɔ, ne̱ aa kpe̱ŋ bamo̱ e̱ye̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ne̱ Farisii awuye ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ a nu ane̱ŋ ne̱ Yeesuu a sa ne̱ Sadukii awuye‑o a waa diŋŋ‑o. Ne̱ baa gyaŋŋe̱ a bo̱ kpa ase̱ŋ ko̱ na bo̱ ya bise mò̱ lɔɔre̱ mò̱ kanɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Amo̱se̱‑ɔ ne̱ bamo̱‑rɔ ɔko̱ ne̱ ɔ gye̱ Wuribware̱ mbraa ɔkaapo̱po̱‑ɔ a bo̱ bise mò̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ɔkaapo̱po̱, mbraa‑ɔ pɛɛɛ‑rɔ mmo̱ e̱ gye̱ ne̱ n tiri‑o ne̱e̱? Tɔwe̱ na ane̱ nu.” ");
INSERT INTO ncuNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ne̱ Yeesuu a be̱ŋŋaa mò̱ fe̱yɛ, “Mmo̱ ne̱ n tiri‑o e̱ gye̱ fe̱yɛ, ‘Lee fo̱ kame‑ro ba fo̱ kakpo̱nɔ na fo̱ mfɛɛre̱ pɛɛɛ bo̱ kpa fo̱ nyaŋpe̱ Wuribware̱ ase̱ŋ.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mmo̱‑ɔ e̱ gye̱ mbraa ne̱ n kyɔ mbraa‑ɔ pɛɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mbraa ne̱ n tiri, ne̱ n gya se̱ nyɔse̱po̱, ne̱ ŋ ya le̱e̱ ngye̱ŋkpɛɛsɛ‑ɔ e̱ gye̱ fe̱yɛ, ‘Kpa fo̱ bɛɛko̱ ase̱ŋ fe̱yɛ ane̱ŋ ne̱ fo̱ e̱ kpa fo̱ e̱ye̱e̱‑ɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Wuribware̱ a mbraa ne̱ Mosis a kyo̱rɛɛ bo̱ be̱ya‑ɔ pɛɛɛ na Wuribware̱ akyaamɛɛ a ke̱kaapo̱‑ɔ pɛɛɛ ye̱re̱ ane̱ŋ a mbraa ŋnyɔ amo̱ se̱ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisii awuye‑o a saŋ bo̱ ye̱re̱ ba nu Yeesuu ase̱‑ɔ, ne̱ oo bise bamo̱ se̱ŋbise ko̱ bo̱ teere mò̱ ne̱ baa bise mò̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ne̱ ɔ yɛ, “E̱me̱ne̱ ne̱ mo̱ne̱ e̱ fa Kristoo ne̱ Wuribware̱ yɛ o suŋ a ɔ bo̱ kyo̱ŋwe̱ ane̱‑ɔ ase̱ŋ? Nsɛ ke̱nana‑rɔ ne̱ ɔ le̱e̱?” Ne̱ baa lee kanɔ fe̱yɛ, “Ɔ le̱e̱ Owure Deefid a ke̱nana‑ɔ‑rɔ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Ne̱ e̱me̱ne̱ se̱ ne̱ Wuribware̱ a kufwiiŋe timaa‑o mɔ a sa ne̱ Deefid fɔŋfɔŋ gbaa a te̱e̱ mò̱ mò̱ nyaŋpe̱? Bo̱ le̱e̱ fe̱yɛ Deefid a kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Wuribware̱ a tɔwe̱ gywii mo̱ nyaŋpe̱ ne̱e̱ ɛ, Kye̱na mo̱ kigyise si mfe̱e̱ na n sa a fo̱ ado̱ŋ pɛɛɛ mɔ ba fo̱ kaase̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","To, Deefid a kyo̱rɛɛ ase̱ŋ amo̱ ne̱ Wuribware̱ a tɔwe̱ gywii ɔko̱ ne̱ o te mò̱ ase̱‑ɔ, Kristoo ne̱ ɔɔ tɔwe̱ gywii. Amo̱ a gye̱ ane̱ŋ‑ɔ se̱‑ɔ, ne̱ Deefid fɔŋfɔŋ gbaa a te̱e̱ Kristoo fe̱yɛ mò̱ nyaŋpe̱, bamo̱ ya ko̱we̱ Kristoo ne̱ ɔɔ waa se̱sɛ dimaadi, e̱me̱ne̱ ne̱ ɔ waa a ɔ le̱e̱ Deefid a ke̱nana‑ɔ‑rɔ, na Deefid a kyɔ te̱e̱ Kristoo fe̱yɛ mò̱ nyaŋpe̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Bamo̱ ɔko̱ mo̱ŋ taare̱ sa Yeesuu kanɔlee ke̱maa. Amo̱se̱‑ɔ le̱e̱ kake amo̱ bo̱ yɔ‑ɔ kufu de bamo̱ pɛɛɛ fe̱yɛ bo̱ be̱e̱ bise mò̱ ase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ne̱ Yeesuu a sa se̱ŋsa gywii lamaŋ ne̱ ba nu mò̱ ase̱‑ɔ na mò̱ agyase̱po̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ne̱ ɔ yɛ, “Wuribware̱ mbraa akaapo̱po̱‑ɔ na Farisii awuye‑o e̱ gye̱ ne̱ bo̱ de kpa fe̱yɛ bo̱ kaapo̱ mo̱ne̱ Wuribware̱ mbraa ne̱ ane̱ ɔde̱daapo̱ Mosis a kyo̱rɛɛ bo̱ be̱ya sa ane̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Amo̱se̱‑ɔ mo̱nꞌ bu bamo̱, na mo̱nꞌ gya ke̱tɔ ke̱maa ne̱ ba kaapo̱ mo̱ne̱ fe̱yɛ mo̱nꞌ waa‑ɔ se̱. Amaa fe̱raa mo̱ne̱ ma kaŋ gya bamo̱ ase̱ŋ waasɛ se̱, a le̱e̱ fe̱yɛ ke̱tɔ ne̱ ba tɔwe̱ ba gywii mo̱ne̱‑ɔ, bamo̱ fɔŋfɔŋ mo̱ŋ gya se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ne̱ bo̱ de bamo̱ fɔŋfɔŋ ananatɔ ba tii Mosis a mbraa‑ɔ se̱, na bo̱ nya sa a mmo̱ ke̱gyase̱ waa le̱ŋ sa mo̱ne̱. Amaa bamo̱ fɔŋfɔŋ fe̱raa maa kya mo̱ne̱‑rɔ na mo̱nꞌ gya mmo̱ se̱. A du ne̱e̱ fe̱yɛ ɔko̱ a taa tɔso̱rɔ dwiidwiisɛ bo̱ so̱rɔ fo̱, ne̱ mò̱‑ɔ maa so̱rɔ a ɔ kya fo̱‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ba waa ke̱tɔ ke̱maa akatɔ se̱ ne̱e̱ a ase̱sɛ nya ŋu. N taa fe̱yɛ ane̱ŋ ne̱ ane̱ de ndakaagyii ane̱ da ane̱ nsɛkpe̱e̱nɔ na asare̱e̱‑rɔ‑ɔ. Wuribware̱ mbraa akaapo̱po̱‑ɔ na Farisii awuye‑o fe̱raa e̱ waa amo̱ adabe̱. M be̱e̱ taa fe̱yɛ ane̱ŋ ne̱ ane̱ be̱e̱ ane̱ de awaagya ane̱ i buŋ aŋu si ane̱ e̱ ko̱re̱ ke̱bware̱ko̱re̱‑ɔ, ne̱ ane̱ i ŋure ife apɔɔ ane̱ kya kya amo̱ nnɔ nna‑ɔ se̱. Wuribware̱ mbraa akaapo̱po̱‑ɔ na Farisii awuye‑o fe̱raa e̱ waa amo̱ aso̱swe̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ne̱ ɔko̱ ya nyiŋŋi bamo̱ fe̱yɛ bo̱ ya gyi ateese, amɔ ba kpa gyikpa‑rɔ a ngya dabe̱‑ɔ se̱ ne̱e̱ a bo̱ kye̱na. Ne̱ ba kpa ke̱bware̱ko̱re̱ akyaŋ‑nɔ ngya dabe̱‑ɔ se̱ ke̱kye̱na. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ne̱ bamo̱ a naa lamaŋ‑nɔ‑ɔ mɔ, ne̱ ba kpa fe̱yɛ ase̱sɛ gyɔŋŋɔ ka bamo̱ kanɔ te̱e̱ bamo̱ ɛ Akaapo̱po̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Amaa mo̱ne̱ fe̱raa, a mo̱ŋ bware fe̱yɛ bo̱ te̱e̱ mo̱ne̱ ɔko̱ ɛ Ɔkaapo̱po̱, a le̱e̱ fe̱yɛ mo̱ne̱ pɛɛɛ gye̱ ko̱ko̱we̱bɛɛ ko̱ŋko̱ ne̱e̱, ne̱ mo̱ wo̱re̱ kpeŋ e̱ gye̱ mo̱ne̱ ɔkaapo̱po̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ane̱ŋ dɛɛ ne̱ mo̱ne̱ ma kaŋ te̱e̱ ɔko̱ swe̱e̱re̱ mɔ se̱ fe̱yɛ mo̱ne̱ se̱, a le̱e̱ fe̱yɛ se̱ ko̱ŋko̱ wo̱re̱ kpeŋ ne̱ mo̱ne̱ de. Mò̱ e̱ gye̱ Wuribware̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ane̱ŋ dɛɛ ne̱ mo̱ne̱ ɔke̱maa ma sa a ɔko̱ te̱e̱ mò̱ fe̱yɛ ɔgye̱ŋkpɛɛpo̱, a le̱e̱ fe̱yɛ mò̱ ne̱ ɔ gye̱ mo̱ne̱ ɔgye̱ŋkpɛɛpo̱ ko̱ŋko̱ kpeŋ‑o e̱ gye̱ Kristoo ne̱ Wuribware̱ a suŋ bo̱ kyo̱ŋwe̱ kaye̱ mɔ‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mo̱ne̱‑rɔ ɔbre̱sɛ waa asuŋ bo̱ suŋ mo̱ne̱ ne̱ mo̱ne̱ a saŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Bo̱ le̱e̱ fe̱yɛ ɔke̱maa ne̱ o bu mò̱ e̱ye̱e̱ ke̱dabe̱‑ɔ, mò̱ ne̱ Wuribware̱ e̱ baa kaase̱. Ne̱ ɔke̱maa mɔ ne̱ ɔ baa mò̱ e̱ye̱e̱ kaase̱‑ɔ, Wuribware̱ e̱ sa mò̱ ke̱dabe̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Mo̱ne̱ ne̱ mo̱ne̱ gye̱ Wuribware̱ mbraa akaapo̱po̱ na Farisii awuye‑o, mo̱ne̱ i ŋu ase̱ŋ ŋke ŋko̱ fɛɛ. Nnɔ ŋnyɔ ŋnyɔ awuye mɔ. Bamo̱ ne̱ ba kpa a bo̱ tii Wuribware̱ se̱ a kuwure‑o si‑o ne̱ mo̱ne̱ i tii bamo̱ kpa. Ne̱ mo̱ne̱ fɔŋfɔŋ mɔ maa kpa a mo̱nꞌ tii kuwure‑o si.  ");
INSERT INTO ncuNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mo̱ne̱ ne̱ mo̱ne̱ gye̱ Wuribware̱ mbraa akaapo̱po̱ na Farisii awuye‑o mɔ, ŋ yɛ ɛɛɛ, mo̱ne̱ i ŋu ase̱ŋ ŋke ŋko̱ fɛɛ. Nnɔ ŋnyɔ ŋnyɔ awuye e̱ gye̱ mo̱ne̱. Mo̱ne̱ e̱ gye̱ ne̱ mo̱ne̱ i puni akpenlekye̱e̱ mo̱ne̱ e̱ kɔɔre̱ bamo̱ e̱lɔŋ, na mo̱ne̱ e̱ ko̱re̱ ke̱bware̱ko̱re̱ ane̱ŋ‑aaa, na ase̱sɛ nya ŋu saŋ amo̱ fe̱yɛ mo̱ne̱ tɛɛ mo̱ne̱ gya Wuribware̱ se̱ nɛɛnɛɛ. Mfaanɛɛ se̱‑ɔ, Wuribware̱ i gyiiri mo̱ne̱ ke̱se̱bɔ bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Mo̱ne̱ ne̱ mo̱ne̱ gye̱ Wuribware̱ mbraa akaapo̱po̱ na Farisii awuye‑o mɔ, ŋ yɛ ɛɛɛ, mo̱ne̱ i ŋu ase̱ŋ ŋke ŋko̱ fɛɛ. Nnɔ ŋnyɔ ŋnyɔ awuye e̱ gye̱ mo̱ne̱. Bo̱ le̱e̱ fe̱yɛ mo̱ne̱ e̱ nare̱ ke̱fɔ ke̱fɔ a mo̱nꞌ ya fo̱ e̱maŋ se̱, na mo̱nꞌ be̱e̱ kye̱na ko̱re̱e̱‑rɔ te̱ŋ ɔpo̱o̱‑rɔ yɔ ke̱fɔ ke̱fɔ ya fo̱ e̱swe̱e̱re̱ ko̱ gbaa se̱, na mo̱nꞌ nya ɔko̱ ne̱ ɔ kɔɔre̱ mo̱ne̱ ke̱kaapo̱ a o gyi‑o. Na ŋkee mò̱ ya kii mo̱ne̱ ɔgyase̱po̱‑ɔ, na mo̱nꞌ sa a ɔ waa e̱bɔye̱ kyo̱ŋ mo̱ne̱ fɔŋfɔŋ gbaa. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ŋ yɛ ɛɛɛ, mo̱ne̱ e̱ ba a mo̱nꞌ bo̱ ŋu ase̱ŋ fɛɛ. Mo̱ne̱ ne̱ mo̱ne̱ e̱ te̱e̱ mo̱ne̱ e̱ye̱e̱ fe̱yɛ ate̱napo̱ ŋyii‑ro akrapo̱ mɔ‑ɔ, mo̱ne̱ fɔŋfɔŋ gbaa mo̱ŋ ke̱e̱. Ane̱ŋ dɛɛ ne̱ mo̱ne̱ ke̱kaapo̱ mo̱ŋ gye̱ kase̱ŋtiŋ. Mo̱ne̱ e̱ kaapo̱ fe̱yɛ ɔko̱ ya waa e̱taŋ tɔwe̱ bo̱ be̱ya fe̱yɛ ɔ waa ko̱tɔko̱, ne̱ mò̱ ya ko̱ŋ be̱e̱ ba Wuribware̱ suŋkpa bo̱ waa e̱taŋ, o de kpa fe̱yɛ ɔ laŋŋe̱ mò̱ kanɔ. Ne̱ mo̱ne̱ be̱e̱ mo̱ne̱ e̱ kaapo̱ ne̱e̱ fe̱yɛ, mò̱ ya ba atanne̱ pipee ne̱ baa bo̱ waa Wuribware̱ suŋkpa‑ɔ daŋ‑ɔ bo̱ waa e̱taŋ, amo̱ fe̱raa ɔ mo̱ŋ de kpa fe̱yɛ ɔ laŋŋe̱ mò̱ kanɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Abaa! Mo̱ne̱ mfɛɛre̱ ke̱‑mo̱ŋ‑de awuye‑o mɔ, mo̱ne̱ mo̱ŋ ke̱e̱ ne̱e̱ e̱e̱e̱? Wuribware̱ suŋkpa bɛɛɛ atanne̱ pipee ne̱ baa bo̱ waa suŋkpa amo̱ daŋ‑ɔ, ke̱mo̱ i tiri? N gye̱ suŋkpa‑ɔ ya sa ne̱ atanne̱ pipee‑o a kii atimaa aaa? ");
INSERT INTO ncuNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ke̱tɔ ne̱ ki tii amo̱ se̱‑ɔ e̱ gye̱ fe̱yɛ mo̱ne̱ yɛ, ɔko̱ ya ba lɔŋŋɔkpa ne̱ ɔ bo̱ suŋkpa‑ɔ mfe̱ŋ‑ɔ bo̱ waa e̱taŋ, ɔ taare̱ a ɔ laŋŋe̱ mò̱ kanɔ. Amaa mò̱ ya ba kabo̱ ne̱ baa taa bo̱ dɔŋŋɔ lɔŋŋɔkpa‑ɔ se̱‑ɔ bo̱ waa e̱taŋ, amo̱ fe̱raa mo̱ne̱ e̱ tɔwe̱ ne̱e̱ fe̱yɛ ɔ mo̱ŋ de kpa fe̱yɛ ɔ laŋŋe̱ mò̱ kanɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mo̱ne̱ mo̱ŋ ke̱e̱ ne̱e̱ bɛɛɛ? Lɔŋŋɔkpa‑ɔ na kabo̱ ne̱ ka dɔŋ mò̱ se̱‑ɔ, amo̱‑rɔ ke̱mo̱ i tiri? N gye̱ lɔŋŋɔkpa‑ɔ ya sa ne̱ kabo̱‑ɔ a kii katimaa aaa? ");
INSERT INTO ncuNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Amo̱se̱ se̱‑ɔ ŋ yɛ ɔko̱ ne̱ ɔ ba lɔŋŋɔkpa‑ɔ a ɔ bo̱ waa e̱taŋ‑ɔ a ba lɔŋŋɔkpa‑ɔ na kabo̱ ne̱ baa bo̱ lɔŋŋɔ Wuribware̱ mfe̱ŋ‑ɔ ape̱pe̱yɔ bo̱ waa e̱taŋ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ne̱ ɔko̱ ne̱ ɔ ba Wuribware̱ suŋkpa‑ɔ a bo̱ waa e̱taŋ‑ɔ e̱ ba suŋkpa‑ɔ na Wuribware̱ fɔŋfɔŋ a ɔ bo̱ waa e̱taŋ ne̱e̱, a le̱e̱ fe̱yɛ Wuribware̱ te suŋkpa‑ɔ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ne̱ ɔko̱ ne̱ ɔ ba Wuribware̱ se̱ a ɔ bo̱ waa e̱taŋ‑ɔ e̱ ba Wuribware̱ kuwuregya‑ɔ a ɔ bo̱ waa e̱taŋ ne̱e̱, ne̱ a kaapo̱ fe̱yɛ ɔ be̱e̱ ba Wuribware̱ ne̱ o te ke̱mo̱ se̱‑ɔ a ɔ bo̱ waa e̱taŋ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Mo̱ne̱ ne̱ mo̱ne̱ gye̱ Wuribware̱ mbraa akaapo̱po̱ na Farisii awuye‑o mɔ, m be̱e̱ mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ mo̱ne̱ i ŋu ase̱ŋ ooo. Nnɔ ŋnyɔ ŋnyɔ awuye e̱ gye̱ mo̱ne̱. Bo̱ le̱e̱ fe̱yɛ mo̱ne̱ gya Wuribware̱ mbraa ne̱ ŋ yɛ mo̱nꞌ taa mo̱ne̱ adɔɔteese ke̱maa ntuŋkare̱ kudu ke̱maa‑rɔ katuŋ ko̱ŋko̱ na mo̱nꞌ bo̱ lɔŋŋɔ Wuribware̱ saŋ ke̱maa‑ɔ se̱. Ne̱ mo̱ne̱ de hare̱e̱ ko̱raa na akare̱ na alɛɛfo̱ ako̱ gbaa mo̱ne̱ e̱ sa Wuribware̱. Amaa mo̱ne̱ mo̱ŋ gya mbraa ne̱ n tiri n kyɔ mbraa amo̱‑ɔ se̱. Ke̱tɔ ne̱ mo̱ e̱ kaapo̱‑ɔ e̱ gye̱ fe̱yɛ mo̱ne̱ maa waa itimaa, mo̱ne̱ maa waa ke̱dame̱naŋsɛ, ne̱ mo̱ne̱ mo̱ŋ de kase̱ŋtiŋ. Ane̱ŋ a atɔ mɔ e̱ gye̱ ne̱ a bware fe̱yɛ mo̱nꞌ waa, na mo̱ne̱ ma yɔwe̱ adɔɔteese a ntuŋkare̱ kudu ke̱maa‑rɔ katuŋ ko̱ŋko̱‑ɔ ke̱taa sa Wuribware̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mo̱ne̱ mo̱ŋ ke̱e̱ ne̱e̱ bɛɛɛ? A le̱e̱ fe̱yɛ ke̱tɔ ne̱ mo̱ne̱ e̱ waa‑ɔ du ne̱e̱ fe̱yɛ ɔko̱ a ŋu kyɔse̱ŋ a le̱e̱ da mò̱ ko̱to̱wa na nkyu si, ne̱ oo lee mò̱ bo̱ twe̱e̱, ne̱ oo mee nyɔma dabe̱ ne̱ ɔ da ko̱to̱wa na nkyu‑o kaase̱ na ɔ mo̱ŋ ŋu‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Mo̱ne̱ Wuribware̱ mbraa akaapo̱po̱ na Farisii awuye mɔ, mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ nnɔ ŋnyɔ ŋnyɔ awuye e̱ gye̱ mo̱ne̱. Mo̱ne̱ du ne̱e̱ fe̱yɛ se̱sɛ a fwe̱e̱ mò̱ ato̱re̱nkyu na mò̱ e̱gyare̱ mmɛɛ, na ɔ maa fwe̱e̱ amo̱ mme‑ro‑o. Mo̱ne̱ e̱ lɔŋŋɔ mo̱ne̱ ŋyo̱wɔre̱, amaa apoo na gyikɔre̱ na gyimɔre̱ ya bo̱rɔ mo̱ne̱ ŋkpo̱nɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mo̱ne̱ Farisii awuye mɔ, mo̱ne̱ mo̱ŋ nyi fe̱yɛ mo̱ne̱ ya lee e̱bɔye̱ le̱e̱ mo̱ne̱ ŋkpo̱nɔ‑rɔ, amɔ mo̱ne̱ ŋyo̱wɔre̱ mo̱ŋ lɛɛ n de iyisi aaa? ");
INSERT INTO ncuNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Mo̱ne̱ Wuribware̱ mbraa akaapo̱po̱ na Farisii awuye mɔ, m be̱e̱ mo̱ e̱ tɔwe̱ fe̱yɛ mo̱ne̱ gye̱ nnɔ ŋnyɔ ŋnyɔ awuye ne̱e̱. Mo̱ne̱ du ne̱e̱ fe̱yɛ ke̱gye̱raŋta‑ɔ. Ke̱mo̱ so̱so̱ ne̱ ba ba siimeetii bo̱ laa, ne̱ kaa waa daŋ. Amaa swe̱e̱re̱‑ɔ kaase̱ kifuniŋ da ki i gyo. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ane̱ŋ dɛɛ ne̱ mo̱ne̱ bware akatɔ se̱, amaa mo̱ne̱ bo̱ aye̱ba na bo̱ro̱kɔɔne̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Mo̱ne̱ Wuribware̱ mbraa akaapo̱po̱ na Farisii awuye mɔ bo̱ ase̱ŋ dabe̱‑rɔ. Nnɔ ŋnyɔ ŋnyɔ awuye e̱ gye̱ mo̱ne̱. Bo̱ le̱e̱ fe̱yɛ mo̱ne̱ e̱ de̱e̱re̱ Wuribware̱ akyaamɛɛ na ase̱sɛ timaa ko̱ ne̱ baa dɛɛ kye̱na‑ɔ ne̱ mo̱ne̱ nana‑ana a mɔɔ bamo̱‑ɔ agye̱raŋta se̱, ne̱ mo̱ne̱ mɔ mo̱ne̱ de siimeetii mo̱ne̱ laa amo̱ nɛɛnɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ne̱ mo̱ne̱ e̱ tɔwe̱ fe̱yɛ, ‘Ane̱ dɛɛ ane̱ te ane̱ ade̱daapo̱ a mbe̱e̱‑ɔ se̱ ne̱e̱, weetee ane̱ mo̱ŋ sure na bo̱ mɔɔ Wuribware̱ a akyaamɛɛ amo̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Amaa mo̱ne̱ maa taare̱ a mo̱nꞌ gyiiri ikii fe̱yɛ bamo̱ ne̱ baa mɔɔ Wuribware̱ a akyaamɛɛ‑ɔ mo̱ŋ gye̱ mo̱ne̱ fɔŋfɔŋ ade̱daapo̱ ne̱e̱ bɛɛɛ? Mo̱ne̱ gye̱ bamo̱ ananagyi kase̱ŋtiŋ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","To, mo̱ne̱ mo̱ŋ tɛɛ waa mo̱ne̱ awaagyi bɔye̱‑ɔ lo̱we̱. Ŋ yɛ mo̱nꞌ kya se̱ mɔɔ ase̱sɛ fe̱yɛ ane̱ŋ ne̱ mo̱ne̱ ade̱daapo̱ a waa‑ɔ, bo̱ fo̱ saŋ ne̱ mo̱ne̱ e̱ mɔɔ Wuribware̱ akyaamɛɛ‑ɔ pɛɛɛ‑ɔ na mo̱nꞌ ŋu. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mo̱ne̱ awɔ mɔ, mo̱ne̱ e̱ fa fe̱yɛ mo̱ne̱ e̱ taare̱ a mo̱nꞌ kwaye̱ awo̱re̱fɔɔ de̱e̱kpa ne̱ Wuribware̱ a kure bo̱ be̱ya na ɔ bo̱ gyiiri e̱bɔye̱ awaapo̱ ke̱se̱bɔ‑ɔ‑rɔ aaa? Mo̱ne̱ maa taare̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Amo̱se̱‑ɔ, mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ mo̱ i suŋ akyaamɛɛ na anyiase̱ŋpo̱ na akaapo̱po̱ a m bo̱ kyo̱ŋwe̱ mo̱ne̱ ase̱. Bamo̱ bo̱ko̱ ne̱ mo̱ne̱ e̱ mɔɔ, bo̱ko̱ mɔ ne̱ mo̱ne̱ e̱ da a mo̱nꞌ bo̱ me̱ra ayii kpare̱-abɛɛ‑rɔ se̱. Bamo̱ bo̱ko̱ mɔ mo̱ne̱ be̱e̱ mo̱ne̱ e̱ da bamo̱ akyo̱kywe̱e̱ mo̱ne̱ ke̱bware̱ko̱re̱ akyaŋ‑nɔ, na mo̱nꞌ gya bo̱ko̱ mɔ le̱e̱ maŋ‑nɔ yaa maŋ ko̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ke̱tɔ ne̱ ke̱ bo̱‑rɔ‑ɔ e̱ gye̱ fe̱yɛ Wuribware̱ e̱ ba bamo̱ ne̱ baa mɔɔ ase̱sɛ timaa ke̱maa swe̱e̱re̱ mɔ se̱ a ke̱se̱bɔgyiiri ne̱ ɔ kaa a ɔ bo̱ gyiiri bamo̱‑ɔ bo̱ gyiiri mo̱ne̱ ke̱se̱bɔ. Kase̱ŋtiŋ si, le̱e̱ saŋ ne̱ baa mɔɔ se̱sɛ timaa Abɛl‑ɔ bo̱ fo̱ saŋ ne̱ mo̱ne̱ a mɔɔ Barakiya mò̱ gyi Sakariya‑o Wuribware̱ suŋkpa kanɔ na lɔŋŋɔkpa mbo̱ŋtɔ‑rɔ‑ɔ pɛɛɛ ke̱se̱bɔgyiiri dɔŋ mo̱ne̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ Wuribware̱ i kperi bamo̱ ilowi mɔ pɛɛɛ se̱ na o gyiiri ndɔɔ a se̱sɛ‑ɔ pɛɛɛ ke̱se̱bɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Mo̱ne̱ Yɛro̱salɛm awuye, saŋ ke̱maa ne̱ Wuribware̱ a suŋ mò̱ akyaamɛɛ‑ɔ ɔko̱ mo̱ne̱ ase̱‑ɔ, mo̱ne̱ a daye̱ mò̱ abu mɔɔ. Saŋ ke̱maa ne̱ mo̱ a kpa fe̱yɛ ŋ kpɔwe̱ mo̱ne̱ bo̱ gyaŋŋe̱, na ŋ kuŋ mo̱ne̱ fe̱yɛ ane̱ŋ ne̱ kyaase̱ i buŋ mò̱ agyi si‑o, mo̱ne̱ mɔ mo̱ne̱ a kine. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","To, Wuribware̱ e̱ kpa a ɔ yɔwe̱ mo̱ne̱ ase̱ŋ sa mo̱ne̱, na mo̱ne̱ maŋ mɔ kii ke̱taakpaŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ mo̱ne̱ maa lɛɛ ŋu mo̱ mfaanɛɛ, amɔ saŋ a fo̱ fe̱yɛ m ba, ne̱ mo̱ne̱ e̱ tɔwe̱ fe̱yɛ, ‘Wuribware̱ yure mò̱ ne̱ ɔ ba mò̱ ke̱nyare̱‑rɔ‑ɔ.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yeesuu a kaapo̱ lamaŋ abware̱se̱ŋ Wuribware̱ suŋkpa‑ɔ lo̱we̱‑ɔ, ne̱ ɔɔ le̱e̱ mfe̱ŋ. Mò̱ a le̱e̱ mfe̱ŋ ɔ yɔ‑ɔ, ne̱ mò̱ agyase̱po̱‑ɔ a ba mò̱ ase̱ fe̱yɛ bo̱ kaapo̱ mò̱ ane̱ŋ ne̱ suŋkpa a akyaŋ‑ɔ bo̱ daŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ne̱ ɔ yɛ, “Yooo. Mo̱ne̱ a ŋu ane̱ŋ ne̱ akyaŋ amo̱ du‑o ooo? Saŋ ko̱ e̱ ba a ɔ bo̱ ba na afo̱re̱ amo̱ ne̱ baa bo̱ pwɛɛ akyaŋ amo̱‑ɔ ko̱ko̱ŋko̱ gbaa maa sii mfe̱ŋ ne̱ ke̱ ye̱re̱ mbe̱yɔmɔ‑ɔ. Ba gye̱ra amo̱ pɛɛɛ a bo̱ bo̱ da.” ");
INSERT INTO ncuNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ke̱tɔ a waa kafwe̱e̱‑ɔ, ne̱ Yeesuu a yɔ o te Mfɔ-Ayii ke̱be̱e̱‑ɔ se̱. Ne̱ mò̱ agyase̱po̱‑ɔ a ba mò̱ ase̱ bamo̱ wo̱re̱, na ɔko̱ mo̱ŋ bo̱‑rɔ, ne̱ baa bise mò̱ fe̱yɛ, “Tɔwe̱ gywii ane̱. Saŋ mo̱ ne̱ ase̱ŋ mɔ pɛɛɛ ne̱ fo̱ a tɔwe̱ bo̱ le̱e̱ Wuribware̱ suŋkpa amo̱ se̱‑ɔ e̱ ba? Ne̱ fo̱ ya yɔ Wuribware̱ ase̱, nte̱tɔ atɔ e̱ gye̱ ne̱ a waa na ane̱ dɛɛ ŋu fe̱yɛ fo̱ kikiŋŋi ba kaye̱ mɔ‑rɔ a tɔ‑rɔ na kaye̱ gye̱ kɛɛ?” ");
INSERT INTO ncuNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Mo̱nꞌ sa se̱ na ɔko̱ ma pe̱nna mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bo̱ le̱e̱ fe̱yɛ ase̱sɛ bwe̱e̱tɔ e̱ ba na bo̱ bo̱ pe̱nna mo̱ne̱ ɛ, ‘Mo̱ e̱ gye̱ Kristoo ne̱ Wuribware̱ a suŋ bo̱ kyo̱ŋwe̱‑ɔ.’ Na bo̱ de mo̱ ke̱nyare̱ ba tɔwe̱ ase̱ŋ na bo̱ pe̱nna ase̱sɛ bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Saŋ amo̱ mo̱ne̱ ya nu e̱kɔ na anaa se̱ me̱raa mo̱ne̱ bɛɛɛ ke̱fɔ ooo, mo̱ne̱ ma sa a amo̱ ase̱ŋ tiri mo̱ne̱, a le̱e̱ fe̱yɛ a waa kanɔ ŋke̱maa a ba ane̱ŋ pwɛɛ. Amaa n gye̱ amo̱‑ɔ e̱ gye̱ ne̱ a kaapo̱ fe̱yɛ kaye̱ e̱ ba a ka gye̱ kɛɛ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ e̱maŋ e̱ kɔ abɛɛ, na swe̱e̱re̱ ko̱ se̱ ase̱sɛ kɔ swe̱e̱re̱ ko̱ mɔ se̱ ase̱sɛ. Na ako̱ŋ ba, na swe̱e̱re̱ le̱e̱ ɔ le̱ŋkpaŋ e̱swe̱e̱re̱ bwe̱e̱tɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Amo̱‑ɔ pɛɛɛ du ne̱e̱ fe̱yɛ ɔkye̱e̱ a duŋwi pwɛɛ ne̱ ɔɔ dɛɛ bo̱ ko̱we̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Saŋ amo̱‑ɔ ba kperi ane̱ŋ ne̱ mo̱ne̱ gye̱ mo̱ agyase̱po̱‑ɔ se̱ na bo̱ kra mo̱ne̱, na bo̱ sa a bo̱ko̱ waa mo̱ne̱ bo̱rɔkraa mɔɔ. Kaye̱‑rɔ ase̱sɛ pɛɛɛ i kperi mo̱ se̱ na bo̱ kisi mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Saŋ amo̱‑ɔ ase̱sɛ bwe̱e̱tɔ be̱e̱ ba kiŋŋi kamɛɛ, na bo̱ ma lɛɛ gya mo̱ e̱kpa‑ɔ se̱. Na bo̱ gyi abɛɛ kidiburo, na bo̱ kisi abɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Na aye̱bapo̱ bwe̱e̱tɔ ba na bo̱ pe̱nna bo̱ko̱ tɔwe̱ fe̱yɛ bo̱ gye̱ Wuribware̱ akyaamɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ane̱ŋ a atɔ‑ɔ e̱ gye̱ ne̱ a sa a e̱bɔye̱ saŋŋe̱‑rɔ bo̱rɔ kaye̱, na bo̱ le̱e̱ ane̱ŋ se̱‑ɔ ase̱sɛ bwe̱e̱tɔ bwe̱e̱tɔ yɔwe̱ bamo̱ bɛɛko̱‑ana ase̱ŋ ke̱kpa. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Amaa mo̱ e̱ mo̱rɔwe̱ ɔke̱maa ne̱ ɔ taare̱ a o nyite, na ɔ ye̱re̱ keŋkeŋ bo̱ fo̱ ase̱ŋ amo̱ kɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Amaa pwɛɛ na kaye̱ dɛɛ gye̱ kɛɛɛ, ase̱sɛ pɛɛɛ i nu ase̱ŋ timaa bo̱ le̱e̱ Wuribware̱ se̱ a kuwure‑o si. Abware̱se̱ŋ ko̱tɔwe̱ mɔ e̱ kaapo̱ bamo̱ fe̱yɛ kaye̱ e̱ kpa a ka fo̱ kamo̱ kɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Atɔ mɔ ne̱ mo̱ a de̱ŋ tɔwe̱ gywii mo̱ne̱‑ɔ pɛɛɛ se̱‑ɔ, mo̱nꞌ nu mo̱ ase̱ nɛɛnɛɛ. Wuribware̱ kyaamɛɛ Daniyɛl a kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ, ‘Saŋ ko̱ e̱ ba a ɔ bo̱ ba ne̱ mo̱ne̱ ado̱ŋ e̱ ba iyisi atɔ ko̱ a bo̱ bo̱ ye̱ra Wuribware̱ suŋkpa‑rɔ na bo̱ bo̱ sa a suŋkpa‑ɔ nye̱ra.’ ” (Fo̱ ne̱ fo̱ e̱ kare̱ amo̱‑ɔ, fo̱ a nu kaase̱ aaa?) ");
INSERT INTO ncuNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Saŋ amo̱‑ɔ bamo̱ ne̱ bo̱ bo̱ Yude̱ya swe̱e̱re̱ se̱‑ɔ, a tiri fe̱yɛ bo̱ se̱re̱ yɔ abe̱e̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Na bamo̱ ne̱ bo̱ bo̱ kawu‑o ma kpo̱ne̱ bamo̱ e̱ye̱e̱ kiŋŋi yɔ lɔŋ‑nɔ fe̱yɛ ba ya taa ko̱tɔko̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Na bamo̱ ne̱ bo̱ bo̱ ndɔɔ‑rɔ‑ɔ ma kiŋŋi ba pe̱ fe̱yɛ ba ba a bo̱ bo̱ taa bamo̱ awaagya. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ŋke nsi amo̱ adaŋpo̱kye̱e̱ na atrapo̱ i ŋu ase̱ŋ ne̱e̱ fɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mo̱nꞌ ko̱re̱ Wuribware̱ fe̱yɛ saŋ ya fo̱ fe̱yɛ mo̱nꞌ se̱re̱, amɔ a maa waa kukyure kake, bɛɛɛ saŋ ne̱ kpa kutu bo̱ le̱ŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Bo̱ le̱e̱ fe̱yɛ saŋ amo̱ a ase̱ŋ‑ɔ e̱ waa le̱ŋ bwe̱e̱tɔ a kyo̱ŋ ase̱ŋ ke̱maa ne̱ aa kyɔ waa le̱e̱ hare̱e̱ saŋ ne̱ Wuribware̱ a twe̱e̱ kaye̱‑ɔ bo̱ fo̱ ndɔɔ‑ɔ. Ase̱ŋ ko̱ mɔ maa lɛɛ ba na a du fe̱yɛ amo̱ daa. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Amaa Wuribware̱ a te̱ŋ ŋke ne̱ weetee ase̱ŋ amo̱ e̱ waa‑ɔ se̱. Ɔ dɛɛ ɔ mo̱ŋ te̱ŋ‑ɔ se̱ fe̱raa ne̱e̱, weetee ɔko̱ maa saŋ kaye̱ mɔ‑rɔ. Bo̱ le̱e̱ bamo̱ ne̱ Wuribware̱ a lee sa mò̱ e̱ye̱e̱‑ɔ se̱ ne̱ ɔɔ te̱ŋ ŋke‑o si. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Saŋ amo̱ ɔko̱ ya tɔwe̱ gywii mo̱ne̱ fe̱yɛ, ‘Ke̱e̱ Kristoo ne̱ Wuribware̱ a suŋ‑o e̱ ye̱re̱ mfe̱e̱‑ɔ,’ bɛɛɛ ‘Mò̱ e̱ ye̱re̱ nno̱ŋ‑ɔ,’ mo̱ne̱ ma kɔɔre̱ mò̱ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Bo̱ le̱e̱ fe̱yɛ bo̱ko̱ e̱ ba a bo̱ bo̱ pe̱nna mo̱ne̱ fe̱yɛ bamo̱ e̱ gye̱ Kristoo‑o, na bo̱ko̱ mɔ pe̱nna fe̱yɛ bamo̱ e̱ gye̱ Wuribware̱ a akyaamɛɛ‑ɔ bo̱ko̱. Ba ba a bo̱ bo̱ waa akpe̱ŋe̱ye̱e̱tɔ dabe̱ dabe̱ bo̱ kaapo̱ fe̱yɛ bamo̱ e̱le̱ŋ‑ɔ a le̱e̱ Wuribware̱ ase̱‑ɔ, na bo̱ nya pe̱nna bamo̱ ne̱ Wuribware̱ a lee sa mò̱ e̱ye̱e̱‑ɔ gbaa. Bamo̱ e̱ taare̱ fe̱raa de. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","To, mo̱ a tɔwe̱ ke̱tɔ ke̱maa gywii mo̱ne̱ pwɛɛ a saŋ amo̱ dɛɛ fo̱. Ne̱e̱ mo̱ne̱ a nu ɛ? ");
INSERT INTO ncuNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Amo̱se̱ se̱‑ɔ, ɔko̱ ya tɔwe̱ gywii mo̱ne̱ fe̱yɛ, ‘Ke̱e̱, Kristoo bo̱ kimukee‑ro nno̱ŋ,’ mo̱ne̱ ma kaŋ yɔ mfe̱ŋ ya de̱e̱re̱. Bɛɛɛ ɔko̱ ya tɔwe̱ fe̱yɛ, ‘Ɔɔ kwe̱e̱rɔ ke̱kyaŋ mɔ‑rɔ mfe̱e̱,’ mo̱ne̱ ma kaŋ kɔɔre̱ mò̱ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mo̱ e̱ tɔwe̱ a n gywii mo̱ne̱ fe̱yɛ, ane̱ŋ ne̱ e̱lɛɛlɛɛ i gyi awo̱re̱‑rɔ le̱e̱ kyɔwe̱ le̱e̱kpa ya bo̱ fo̱ kyɔwe̱ twɛɛkpa‑ɔ, ane̱ŋ dɛɛ ne̱ mo̱, dimaadi mò̱ gyi‑o, e̱ ba na ɔke̱maa ŋu mo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ŋ yɛ, mfe̱ŋ ne̱ fo̱ ya ŋu apate̱yɛ i fuwi ba muruwi‑ro, a kaapo̱ fe̱yɛ kifuniŋ da mfe̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Ŋke amo̱‑rɔ saŋ ne̱ ase̱ŋ dabe̱ amo̱ a kyo̱ŋ‑ɔ, ‘Kyɔwe̱ ya le̱e̱, ke̱tɔ e̱ gyase̱, na oferi mɔ ma lɛɛ laŋŋe̱‑rɔ.’ ‘Na akye̱e̱‑e̱‑kpa‑agyi kyuwi le̱e̱ daye̱ bwee‑ro pupuri, na ke̱tɔ ke̱maa ne̱ ke̱ bo̱ awo̱re̱‑rɔ‑ɔ pɛɛɛ ma lɛɛ waa kyɛɛkyɛɛ.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Saŋ‑ɔ ba ŋu so̱so̱ afutɔ ko̱ ne̱ a kaapo̱ fe̱yɛ mo̱, dimaadi mò̱ gyi‑o, e̱ kpa a m ba swe̱e̱re̱ se̱. Na kaye̱‑rɔ ase̱sɛ pɛɛɛ yo̱ŋ, na bo̱ su keŋkeŋ. Ŋkee ba ŋu mo̱ a le̱e̱ so̱so̱ m bo̱ awo̱re̱‑rɔ mo̱ e̱ ba ke̱yaale̱ŋ‑nɔ na ke̱laŋŋe̱rɔ dabe̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Na kabe̱re̱ dabe̱ su keŋkeŋ so̱so̱, na n suŋ mo̱ mbɔɔ le̱e̱ so̱so̱ ba swe̱e̱re̱ mɔ se̱ mfe̱e̱, na bo̱ yɔ ke̱bare̱ ke̱maa ya kpɔwe̱ ase̱sɛ ne̱ Wuribware̱ a lee sa mò̱ e̱ye̱e̱‑ɔ pɛɛɛ le̱e̱ swe̱e̱re̱ ke̱maa se̱ bo̱ gyaŋŋe̱ to̱ŋ ko̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Mo̱nꞌ sa a figi kiyii kaapo̱ mo̱ne̱ kanyiase̱ŋ. Mo̱ne̱ nyi fe̱yɛ ke̱mo̱ ya ba ke̱ e̱ kpa a ke̱ pɔwe̱, amɔ ke̱kyaare̱ e̱ kpa a ke̱ fo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","To, ane̱ŋ dɛɛ ne̱ mo̱ne̱ ya ŋu fe̱yɛ ase̱ŋ mɔ pɛɛɛ e̱ waa, amɔ mo̱nꞌ pini fe̱yɛ saŋ e̱ kpa a ɔ fo̱ fe̱yɛ m be̱e̱ kiŋŋi ba. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ ndɔɔ a kaye̱ mɔ‑rɔ a ase̱sɛ‑ɔ bo̱ko̱ i ŋu saŋ ne̱ atɔ mɔ e̱ ba‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","So̱so̱ na swe̱e̱re̱ pɛɛɛ ase̱ŋ e̱ kyo̱ŋ, amaa mo̱ ase̱ŋ fe̱raa maa kyo̱ŋ daa.” ");
INSERT INTO ncuNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ne̱ Yeesuu a kya se̱ kaapo̱ mò̱ kikiŋŋi ba‑ɔ ase̱ŋ. Ne̱ ɔ yɛ, “Amaa ɔko̱ mo̱ŋ nyi kake nsi ne̱ mo̱ i kiŋŋi a m ba‑ɔ. Wuribware̱ mbɔɔ‑ɔ, bɛɛɛ mo̱, dimaadi mò̱ gyi‑o, gbaa mo̱ŋ nyi kake suyo‑o. Amɔ ane̱ se̱ Wuribware̱ wo̱re̱ kpeŋ i nyi. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ane̱ŋ ne̱ aa dɛɛ waa ane̱ ɔde̱daapo̱ Nowaa mbe̱e̱ se̱‑ɔ, ane̱ŋ dɛɛ ne̱ mo̱, dimaadi mò̱ gyi‑o, kikiŋŋi ba‑ɔ e̱ waa. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","39","Nowaa mbe̱e̱ amo̱ se̱‑ɔ, ɔke̱maa maa se̱ o gyi ateese na o nuu nta, na anyare̱ na akye̱e̱ e̱ waare̱e̱ ane̱ŋ‑aaa, na bo̱ mo̱ŋ nyi fe̱yɛ ase̱ŋ e̱ to̱ bamo̱ ya bo̱ fo̱ kake ne̱ Nowaa a lwee mò̱ ko̱re̱e̱ dabe̱ dabe̱‑ɔ‑rɔ‑ɔ, ne̱ kufwiiri a bo̱ twe̱e̱ mɔɔ bamo̱ pɛɛɛ. Ane̱ŋ dɛɛ ne̱ mo̱, dimaadi mò̱ gyi‑o, i fu‑ro a m ba. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kake nsi ne̱ mo̱ i kiŋŋi a m ba‑ɔ, mo̱ e̱ ba a m bo̱ to̱ anyare̱ anyɔ na ba dɔɔ ko̱dɔɔ‑rɔ. Na n lee ɔko̱ŋko̱ yaa mo̱ ase̱ yɔwe̱ ɔko̱ŋko̱ mɔ bo̱ sii. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Na akye̱e̱ anyɔ ko̱ mɔ bo̱ to̱ŋ ko̱ŋko̱ ba kwɛɛ abwaye, na m bo̱ lee ɔko̱ŋko̱ yɔwe̱ mò̱ bɛɛko̱‑ɔ bo̱ sii. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Amo̱se̱ se̱‑ɔ mo̱ne̱ ɔke̱maa sa mò̱ e̱ye̱e̱ se̱. Mo̱nꞌ waa siraa, a le̱e̱ fe̱yɛ mo̱ne̱ mo̱ŋ nyi saŋ ne̱ mo̱ne̱ nyaŋpe̱ e̱ ba‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mo̱nꞌ nyiŋŋi si fe̱yɛ lɔŋ wuye dɛɛ o nyi saŋ ne̱ oyu de ɔ ba‑ɔ ne̱e̱, weetee ɔ maa di idi na ɔ yɔwe̱ mò̱ lɔŋ‑ɔ sa oyu‑o na ɔ bo̱ lweero ya ywii mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Amo̱se̱ se̱‑ɔ mo̱ne̱ gbaa, mo̱nꞌ waa siraa, a le̱e̱ fe̱yɛ mo̱, dimaadi mò̱ gyi‑o, bo̱ ba‑ɔ, mo̱ i fu‑ro a m ba ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ne̱ Yeesuu a kya se̱ tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Mo̱ a fu‑ro a m ba se̱‑ɔ, mo̱ e̱ kaapo̱ mo̱ne̱ ke̱yaafɔre̱ ne̱ mo̱ ase̱ o nyi ase̱ŋ, ne̱ o bware‑o. Mo̱nꞌ sa a ane̱ taa fe̱yɛ nyaŋpe̱ ko̱ e̱ kpa a o tu kpa, ne̱ ɔɔ taa ke̱yaafɔre̱ ko̱ fe̱yɛ ɔ bo̱ de̱e̱re̱ mò̱ lɔŋ na mò̱ ayaafɔre̱ ne̱ baa saŋ‑ɔ se̱, na bo̱ nya nya ateese gyi saŋ ne̱ a bware fe̱yɛ bo̱ gyi‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mò̱ nyaŋpe̱ ya kiŋŋi ba pe̱ bo̱ to̱ fe̱yɛ ke̱yaafɔre̱ amo̱ e̱ waa ke̱tɔ ne̱ ɔɔ tɔwe̱ gywii mò̱ fe̱yɛ ɔ waa‑ɔ, ane̱ŋ a ke̱yaafɔre̱‑ɔ akatɔ i gyi. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ a waa kanɔ ŋke̱maa mò̱ nyaŋpe̱ e̱ taa mò̱ kapo̱tɛɛ pɛɛɛ na ɔ bo̱ sa mò̱ ke̱yaafɔre̱ amo̱ a ɔ de̱e̱re̱ se̱ sa mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Amaa n taa fe̱yɛ mò̱ e̱ gye̱ ke̱yaafɔre̱ bɔye̱, amo̱ fe̱raa ɔ tɔwe̱ ne̱e̱ fe̱yɛ mò̱ nyaŋpe̱‑ɔ a kyee na kikiŋŋi ba‑ɔ se̱‑ɔ, ɔ le̱e̱ kaase̱ a ɔ daye̱ mò̱ ko̱so̱bɛɛ‑ana ayaafɔre̱ ne̱ bo̱ bo̱ lɔŋ‑ɔ‑rɔ‑ɔ, na o gyi ateese ne̱ ɔ kpa‑ɔ, na mò̱ aa atabwe̱e̱po̱ kye̱na nuu nta ba bwe̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Nte̱tɔ ne̱ mò̱ nyaŋpe̱‑ɔ e̱ waa? Mò̱ nyaŋpe̱‑ɔ i kiŋŋi a ɔ ba kake ne̱ ke̱yaafɔre̱‑ɔ maa de̱e̱re̱ mò̱ kpa‑ɔ na saŋ ne̱ ɔ mo̱ŋ nyi‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Na mò̱ nyaŋpe̱ bo̱ da mò̱ bwe̱e̱tɔ gyiiri mò̱ ke̱se̱bɔ, na ɔ gya mò̱ yaa mfe̱ŋ ne̱ nnɔ ŋnyɔ ŋnyɔ awuye i ŋu ase̱ŋ‑ɔ. Mfe̱ŋ‑ɔ o su bwe̱e̱tɔ, na o duŋwi mò̱ kanɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ne̱ Yeesuu a be̱e̱ tɔwe̱ kitee ko̱ ne̱ ke̱ e̱ kaapo̱ ane̱ŋ ne̱ Wuribware̱ se̱ a kuwure‑o du saŋ ne̱ ɔ be̱e̱ o kiŋŋi a ɔ ba‑ɔ. Ɔ yɛ, “N gye̱ ɔnyare̱ ko̱ ya dɛɛ kye̱na aaa? Ne̱ ɔ kpa a ɔ waare̱e̱ ɔkye̱e̱. Ne̱ baa waa ko̱ko̱fɔ‑rɔ ateese siraa na bo̱ gyi. Ne̱ ɔko̱fɔ mò̱ kuri a kyee ateese‑o ke̱bo̱ gyi. Amɔ kibugyii a da na ɔ mo̱ŋ tɛɛ ba. Ne̱ mbregyii kudu ko̱ mɔ bo̱‑rɔ. Ne̱ bo̱ te kawu bo̱ gywii mò̱ ke̱ba. ");
INSERT INTO ncuNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Bamo̱‑rɔ anuu ko̱ mo̱ŋ bo̱ mfɛɛre̱, a le̱e̱ fe̱yɛ bo̱ de ifetiri, ne̱ bo̱ mo̱ŋ sɔɔ mfɔ bo̱ tii mmo̱ ne̱ m bo̱ ifetiri‑o‑ro si baa. Bamo̱ anuu ne̱ baa saŋ‑ɔ mɔ gye̱ anyiase̱ŋpo̱, a le̱e̱ fe̱yɛ baa kyɔ taa mfɔ bo̱ tii mmo̱ ne̱ m bo̱ bamo̱ ifetiri‑o‑ro si baa. ");
INSERT INTO ncuNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ɔko̱fɔ mò̱ kuri a kyee na ke̱ba‑ɔ se̱‑ɔ, mbregyii‑o pɛɛɛ mo̱ŋ taare̱ kra idi. Ne̱ baa di idi. ");
INSERT INTO ncuNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ye̱nse̱na a fo̱‑ɔ, ne̱ ɔko̱ a faa‑rɔ tɔwe̱ fe̱yɛ, ‘Ɔko̱fɔ mò̱ kuri e̱ ba ooo. Mo̱nꞌ sa a ane̱ ya gyaŋŋaa mò̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ne̱ mbregyii‑o pɛɛɛ a te̱ŋ‑nɔ kyiŋŋi ko̱so̱ kye̱na. Ne̱ baa yo̱ŋyo̱ŋ bamo̱ ifetiri‑o‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ne̱ mbregyii ne̱ bo̱ mo̱ŋ bo̱ mfɛɛre̱‑ɔ a tɔwe̱ fe̱yɛ, ‘Oo! Oo! Oo! Ane̱ ifetiri i duŋ ooo.’ Ne̱ baa ko̱re̱ mbregyii anyiase̱ŋpo̱‑ɔ fe̱yɛ bo̱ sa bamo̱ mfɔ‑ɔ ŋko̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ne̱ baa be̱ŋŋaa bamo̱ fe̱yɛ, ‘Daabii. Ane̱ ya sa mo̱ne̱ ŋko̱, mfɔ ne̱ ane̱ aa mo̱ne̱ i ke‑ro‑o maa ke ane̱ aa mo̱ne̱ kaye̱. Amo̱se̱‑ɔ mo̱nꞌ nare̱ mfɔ ofepo̱ a lɔŋ‑ɔ‑rɔ ya sɔɔ mo̱ne̱ lee.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mbregyii ne̱ bo̱ mo̱ŋ bo̱ mfɛɛre̱‑ɔ a yii a bo̱ ya sɔɔ mfɔ‑ɔ, ne̱ ŋkee ɔko̱fɔ mò̱ kuri‑o a ba. Ne̱ mbregyii anyiase̱ŋpo̱‑ɔ, bamo̱ a kra siraa‑o si‑o, a ya gyaŋŋaa ɔko̱fɔ mò̱ kuri‑o. Ne̱ bamo̱ aa mò̱ a lwee lɔŋ‑nɔ na bo̱ ya gyi ko̱ko̱fɔ‑rɔ a ateese‑o. Bamo̱ a lweero‑o, ne̱ baa tii po̱ne̱‑ɔ twe̱e̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ke̱tɔ bo̱ waa kafwe̱e̱‑ɔ, ne̱ mbregyii ne̱ bo̱ mo̱ŋ bo̱ mfɛɛre̱‑ɔ a kiŋŋi ba. Ne̱ baa bo̱ ye̱re̱ kawu po̱ne̱‑ɔ ase̱ te̱e̱ fe̱yɛ, ‘Ane̱ nyaŋpe̱, ane̱ nyaŋpe̱, taye̱ ane̱ a ane̱ lweero.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ne̱ ɔko̱fɔ mò̱ kuri a be̱ŋŋaa bamo̱ fe̱yɛ, ‘Daabii. Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ mo̱ŋ nyi mo̱ne̱.’ Amo̱ e̱ gye̱ saase̱bɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ne̱ Yeesuu a baa amo̱ bo̱ gye̱ kɛɛ fe̱yɛ, “Mo̱ne̱ ɔke̱maa sa mò̱ e̱ye̱e̱ se̱, a le̱e̱ fe̱yɛ mo̱ne̱ mo̱ŋ nyi kake bɛɛɛ saŋ ne̱ mo̱, dimaadi mò̱ gyi‑o, e̱ ba‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ne̱ Yeesuu a be̱e̱ ba kitee ko̱ bo̱ kaapo̱ ke̱tɔ ne̱ ke̱ e̱ waa mò̱ ke̱ba be̱e̱‑ɔ. Ɔ yɛ, “N gye̱ atɔ wuye ko̱ ya dɛɛ kye̱na aaa? Ne̱ ɔ kpa a o tu kpa yɔ ke̱fɔ ya kye̱na kafwe̱e̱. Ne̱ ɔɔ te̱e̱ mò̱ ayaafɔre̱ bo̱ gyaŋŋe̱. Ne̱ ɔɔ taa mò̱ kapo̱tɛɛ waa bamo̱ ke̱sare̱e̱‑rɔ na bo̱ de̱e̱re̱ se̱ gywii mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ɔɔ sa bamo̱ ɔke̱maa ane̱ŋ ne̱ ɔ fa fe̱yɛ ɔ taare̱ a ɔ de̱e̱re̱ se̱‑ɔ. Ɔɔ sa ɔko̱ŋko̱ siidii ŋkpe̱ŋ alafa anuu (GHC 500,000). Ɔko̱ŋko̱ mɔ ne̱ ɔɔ sa siidii ŋkpe̱ŋ alafa anyɔ (GHC 200,000). Ne̱ ɔko̱ŋko̱ mɔ be̱e̱ ɔɔ sa siidii ŋkpe̱ŋ ke̱lafa (GHC 100,000). Ne̱ ŋkee oo tu mò̱ kpa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mfe̱ŋ ne̱ ke̱yaafɔre̱ gye̱ŋkpɛɛsɛ‑ɔ a yɔ ya taa mò̱ siidii ŋkpe̱ŋ alafa anuu bo̱ kyurowi‑ro nya siidii ŋkpe̱ŋ alafa anuu bo̱ tii si. ");
INSERT INTO ncuNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ane̱ŋ dɛɛ ne̱ ke̱yaafɔre̱ nyɔse̱po̱‑ɔ a ya taa mò̱ siidii ŋkpe̱ŋ alafa anyɔ bo̱ kyurowi‑ro nya siidii ŋkpe̱ŋ alafa anyɔ bo̱ tii si. ");
INSERT INTO ncuNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Amaa ke̱yaafɔre̱ sase̱po̱‑ɔ a taa mò̱ siidii ŋkpe̱ŋ ke̱lafa‑ɔ yaa kawu ya kwii bɔ, ne̱ ɔɔ taa mò̱ nyaŋpe̱ a atanne̱‑ɔ bo̱ waa‑rɔ pure. ");
INSERT INTO ncuNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Amo̱ a kyee‑o, ne̱ ayaafɔre̱‑ɔ bamo̱ nyaŋpe̱‑ɔ a kiŋŋi ba pe̱. Ne̱ ɔɔ te̱e̱ mò̱ ayaafɔre̱‑ɔ bo̱ gyaŋŋe̱ na ɔ nya ŋu mò̱ aa bamo̱ mbo̱ŋtɔ‑rɔ atanne̱ ne̱ a bo̱‑rɔ‑ɔ na ɔ kɔɔre̱ le̱e̱ bamo̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ke̱yaafɔre̱ gye̱ŋkpɛɛsɛ a ba mò̱ akatɔ‑rɔ, ne̱ ɔɔ tɔwe̱ gywii mò̱ fe̱yɛ, ‘Mo̱ nyaŋpe̱, ke̱e̱ siidii ŋkpe̱ŋ alafa anuu ne̱ fo̱ a taa bo̱ sa mo̱‑ɔ. Ŋkee be̱e̱ ke̱e̱ siidii ŋkpe̱ŋ alafa anuu ne̱ mo̱ a nya bo̱ tii si‑o.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ne̱ mò̱ nyaŋpe̱‑ɔ yɛ, ‘Fo̱ a waa atɔ. Ke̱yaafɔre̱ timaa na kase̱ŋtiŋ wuye e̱ gye̱ fo̱. Mbe̱yɔmɔ mo̱ a kɔɔre̱ fo̱ gyi atanne̱ ngyingyii‑ro ŋu fo̱ kase̱ŋtiŋ. Amo̱se̱‑ɔ mo̱ e̱ taa mo̱ atanne̱ dabe̱ na m bo̱ sa fo̱ a fo̱ de̱e̱re̱ se̱. Lweero ba mfe̱e̱ na mo̱ aa fo̱ gyi akatɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ne̱ ke̱yaafɔre̱ nyɔse̱po̱‑ɔ a ba mò̱ nyaŋpe̱‑ɔ akatɔ‑rɔ, ne̱ ɔɔ tɔwe̱ gywii mò̱ fe̱yɛ, ‘Mo̱ nyaŋpe̱, ke̱e̱ siidii ŋkpe̱ŋ alafa anyɔ ne̱ fo̱ a taa bo̱ sa mo̱‑ɔ. Ŋkee be̱e̱ ke̱e̱ siidii ŋkpe̱ŋ alafa anyɔ ne̱ mo̱ a nya bo̱ tii si‑o.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ne̱ mò̱ nyaŋpe̱‑ɔ yɛ, ‘Fo̱ gbaa, fo̱ a waa atɔ fe̱yɛ fo̱ bɛɛko̱ ke̱yaafɔre̱ ko̱‑ɔ. Mo̱ a kɔɔre̱ fo̱ gyi atanne̱ ngyingyii‑ro ŋu fo̱ kase̱ŋtiŋ‑o si‑o, mo̱ e̱ taa atanne̱ dabe̱ na n sa fo̱ a fo̱ de̱e̱re̱ se̱. Lweero ba mfe̱e̱ na mo̱ aa fo̱ gyi akatɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","25","Ne̱ ŋkee ke̱yaafɔre̱ sase̱po̱‑ɔ a bo̱ tɔwe̱ fe̱yɛ, ‘Mo̱ nyaŋpe̱, n se̱re̱ fo̱, ne̱ ŋ nyi fe̱yɛ fo̱ ase̱ŋ bo̱ le̱ŋ, ne̱ fo̱ e̱ taa ke̱tɔ ne̱ ke̱ mo̱ŋ gye̱ fo̱ lee‑o, ne̱ fo̱ e̱ kɔɔre̱ adɔɔteese ne̱ fo̱ mo̱ŋ dwii‑o fo̱ i kii fo̱ lee‑o, amo̱ se̱‑ɔ ne̱ mo̱ a taa fo̱ siidii ŋkpe̱ŋ ke̱lafa‑ɔ yaa kawu. Ne̱ mo̱ a ya kwii bɔ taa bo̱ waa‑rɔ pure. Amo̱se̱‑ɔ mbe̱yɔmɔ ke̱e̱ fo̱ atanne̱‑ɔ pɛɛɛ. Fo̱ lee ne̱e̱, amo̱se̱‑ɔ kɔɔre̱ fo̱ atɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ne̱ mò̱ nyaŋpe̱‑ɔ yɛ, ‘Ke̱yaafɔre̱ bɔye̱ na wo̱rɔgyapo̱ kase̱ŋtiŋ e̱ gye̱ fo̱. Fo̱ yɛ fo̱ nyi fe̱yɛ mo̱ e̱ taa ke̱tɔ ne̱ ke̱ mo̱ŋ gye̱ mo̱ lee‑o, ne̱ mo̱ e̱ kɔɔre̱ adɔɔteese ne̱ mo̱ŋ dwii‑o mo̱ i kii mo̱ lee. ");
INSERT INTO ncuNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ne̱ e̱me̱ne̱ ya waa se̱ ne̱ fo̱ mo̱ŋ taa mo̱ atanne̱‑ɔ yaa bo̱ be̱ya baŋke̱‑rɔ, na mo̱ a kiŋŋi ba‑ɔ na ŋ nya atanne̱ be̱e̱ bo̱ dɔŋŋɔ se̱?’ ");
INSERT INTO ncuNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ne̱ ɔɔ be̱e̱ tɔwe̱ gywii bamo̱ ne̱ bo̱ ye̱re̱ mfe̱ŋ‑ɔ fe̱yɛ, ‘Mo̱nꞌ kɔɔre̱ siidii ŋkpe̱ŋ ke̱lafa ne̱ e̱ bo̱ ɔnyare̱ mɔ ase̱‑ɔ taa sa mò̱ ne̱ o de siidii kakpe̱ŋkɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Bo̱ le̱e̱ fe̱yɛ ɔko̱ ne̱ o de ke̱tɔ‑ɔ, ba taa bwe̱e̱tɔ na bo̱ bo̱ tii mò̱ se̱. Na mò̱ lee nya waa ko̱kyɔ. Amaa ɔko̱ ne̱ ɔ mo̱ŋ de‑o fe̱raa, ba kɔɔre̱ kafwe̱e̱ ne̱ o de‑o a bo̱ le̱e̱ mò̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na mo̱nꞌ taa ke̱yaafɔre̱ mɔ ne̱ ɔ maa lɔŋŋɔ sɛye̱‑ɔ twe̱e̱ mò̱ bo̱ kyo̱ŋwe̱ kawu kibugyii‑ro. Mfe̱ŋ ne̱ ba su, ne̱ ba duŋwi nnɔ‑ɔ.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ne̱ Yeesuu a kaapo̱ mò̱ agyase̱po̱‑ɔ atɔ bo̱ gye̱ kɛɛ fe̱yɛ, “Kake nsi ne̱ mo̱, dimaadi mò̱ gyi‑o, e̱ le̱e̱ so̱so̱ na m bo̱ gyi kuwure‑o, mo̱ aa Wuribware̱ a mbɔɔ‑ɔ e̱ ba na n kye̱na mo̱ kuwuregya‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Na kaye̱‑rɔ ase̱sɛ pɛɛɛ gyaŋŋe̱ mo̱ akatɔ‑rɔ. Mfe̱ŋ ne̱ mo̱ i ke bamo̱‑rɔ ntuŋ ŋnyɔ, fe̱yɛ ane̱ŋ ne̱ mbo̱ ɔde̱e̱re̱se̱po̱ i lee e̱sanne̱ ko̱kwe̱e̱, ne̱ o lee e̱te̱e̱re̱ mɔ ko̱kwe̱e̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Bamo̱ ne̱ bo̱ gye̱ ase̱sɛ timaa‑o du ne̱e̱ fe̱yɛ e̱sanne̱‑ɔ. Bamo̱ ne̱ mo̱ e̱ sa a bo̱ ye̱re̱ mo̱ kigyisesare̱e̱ se̱. Bamo̱ ne̱ baa saŋ‑ɔ du ne̱e̱ fe̱yɛ e̱te̱e̱re̱‑ɔ. Bamo̱ mɔ ne̱ mo̱ e̱ sa a bo̱ ye̱re̱ mo̱ ke̱be̱nasare̱e̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Na n kye̱na mo̱ kuwure si. Na n tɔwe̱ gywii bamo̱ ne̱ bo̱ ye̱re̱ mo̱ kigyise si‑o fe̱yɛ, ‘Mo̱nꞌ sa a mo̱ne̱ akatɔ gyi, a le̱e̱ fe̱yɛ n se̱ Wuribware̱ a yure mo̱ne̱. Amo̱se̱‑ɔ mo̱nꞌ bo̱ gyi kuwure ne̱ ɔɔ bo̱ be̱ya sa mo̱ne̱ le̱e̱ hare̱e̱ saŋ ne̱ ɔɔ twe̱e̱ kaye̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Bo̱ le̱e̱ fe̱yɛ saŋ ne̱ ako̱ŋ a nya mo̱‑ɔ, ne̱ mo̱ne̱ a sa mo̱ ateese, ne̱ mo̱ a gyi. Saŋ ne̱ burufo a nya mo̱‑ɔ, ne̱ mo̱ne̱ a sa mo̱ nkyu, ne̱ mo̱ a nuu. Saŋ ne̱ mo̱ a kii ɔfɔ‑ɔ, ne̱ mo̱ne̱ a kra mo̱ nɛɛnɛɛ mo̱ne̱ aye̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Saŋ ne̱ mo̱ne̱ a ŋu fe̱yɛ m buŋ aprakɛɛ‑ɔ, ne̱ mo̱ne̱ a sa mo̱ atɔ, ne̱ mo̱ a buŋ. Saŋ ne̱ mo̱ne̱ a ŋu mo̱ na mo̱ e̱ lɔ‑ɔ, ne̱ mo̱ne̱ a kya mo̱‑rɔ. Saŋ ne̱ baa tii mo̱ tiikpa‑ɔ ne̱ mo̱ne̱ a bo̱ laa mo̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Na ase̱sɛ timaa amo̱ bise mo̱ fe̱yɛ, ‘Ane̱ nyaŋpe̱, nsaŋ mo̱ ne̱ ako̱ŋ a nya fo̱, ne̱ ane̱ a sa fo̱ ateese, ne̱ fo̱ a gyi? Tɔwe̱ gywii ane̱. Bɛɛɛ nsaŋ mo̱ ne̱ burufo a nya fo̱, ne̱ ane̱ a sa fo̱ nkyu, ne̱ fo̱ a nuu? ");
INSERT INTO ncuNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nsaŋ mo̱ ne̱ ane̱ a be̱e̱ ŋu fo̱ na fo̱ gye̱ ɔfɔ, ne̱ ane̱ a kra fo̱ nɛɛnɛɛ ane̱ aye̱? Ne̱ nsaŋ mo̱ ne̱ ane̱ a ŋu fo̱, na fo̱ buŋ aprakɛɛ, ne̱ ane̱ a sa fo̱ atɔ, ne̱ fo̱ a buŋ? ");
INSERT INTO ncuNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nsaŋ mo̱ ne̱ ane̱ a ŋu fe̱yɛ fo̱ e̱ lɔ, bɛɛɛ baa tii fo̱ tiikpa ne̱ ane̱ a bo̱ laa fo̱ kya fo̱‑rɔ?’ ");
INSERT INTO ncuNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Na m be̱ŋŋaa bamo̱ fe̱yɛ, ‘Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ, saŋ ke̱maa ne̱ mo̱ne̱ a waa mo̱ ko̱we̱bɛɛ‑ana ngyingyii mɔ ɔko̱ ke̱dame̱naŋsɛ‑ɔ, mo̱ne̱ a waa mo̱, Yeesuu, ke̱dame̱naŋsɛ ne̱e̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Na n tɔwe̱ gywii bamo̱ ne̱ bo̱ ye̱re̱ mo̱ ke̱be̱na se̱‑ɔ fe̱yɛ, ‘Mo̱ne̱ fe̱raa, mo̱nꞌ le̱e̱ mo̱ ase̱. Wuribware̱ a lo̱ŋ mo̱ne̱. Mo̱nꞌ nare̱ ya lwee de̱e̱kpa ne̱ Wuribware̱ a kure bo̱ be̱ya Ɔbɔnsam na mò̱ kamɛɛ‑rɔ awuye‑o‑ro. Ane̱ŋ a de̱e̱kpa‑ɔ maa duŋ pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Bo̱ le̱e̱ fe̱yɛ saŋ ne̱ ako̱ŋ a nya mo̱‑ɔ, mo̱ne̱ mo̱ŋ sa mo̱ ateese a n gyi. Saŋ ne̱ burufo a nya mo̱‑ɔ, mo̱ne̱ mo̱ŋ sa mo̱ nkyu a n nuu. ");
INSERT INTO ncuNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Saŋ ne̱ mo̱ a kii ɔfɔ‑ɔ, mo̱ne̱ mo̱ŋ kra mo̱ nɛɛnɛɛ. Saŋ ne̱ mo̱ne̱ a ŋu fe̱yɛ m buŋ aprakɛɛ‑ɔ, mo̱ne̱ be̱e̱ mo̱ne̱ mo̱ŋ sa mo̱ atɔ buŋsɛ. Saŋ ne̱ mo̱ne̱ a ŋu fe̱yɛ mo̱ e̱ lɔ, ne̱ n da tiikpa‑ɔ‑rɔ‑ɔ, mo̱ne̱ mo̱ŋ bo̱ laa mo̱ na mo̱nꞌ kya mo̱‑rɔ!’ ");
INSERT INTO ncuNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Na ase̱sɛ bɔye̱ amo̱ be̱ŋŋaa mo̱ fe̱yɛ, ‘Ane̱ nyaŋpe̱, nsaŋ mo̱ ne̱ ane̱ a ŋu fo̱ na ako̱ŋ de fo̱, ne̱ ane̱ a kine ke̱sa fo̱ ateese? Tɔwe̱ gywii ane̱. Ne̱ nsaŋ mo̱ ne̱ ane̱ a ŋu fo̱ na burufo de fo̱, ne̱ ane̱ a kine ke̱sa fo̱ nkyu? Nsaŋ mo̱ ne̱ ane̱ a ŋu fo̱ fe̱yɛ ɔfɔ, ne̱ ane̱ a kine ke̱kra fo̱ nɛɛnɛɛ, bɛɛɛ ane̱ a ŋu fo̱ na fo̱ buŋ aprakɛɛ, ne̱ ane̱ a kine ke̱sa fo̱ atɔ buŋsɛ? Bɛɛɛ nsaŋ mo̱ ne̱ ane̱ a ŋu fo̱ na fo̱ e̱ lɔ bɛɛɛ fo̱ da tiikpa, ne̱ ane̱ a kine ke̱bo̱ kya fo̱‑rɔ?’ ");
INSERT INTO ncuNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Na m be̱ŋŋaa bamo̱ fe̱yɛ, ‘Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ saŋ ke̱maa ne̱ mo̱ne̱ a ŋu mo̱ ko̱we̱bɛɛ‑ana ngyingyii‑o mɔ ɔko̱ na o gyi awo̱re̱fɔɔ, ne̱ mo̱ne̱ a kine ko̱waa mò̱ ke̱dame̱naŋsɛ, saŋ amo̱‑ɔ mo̱, Yeesuu, ne̱ mo̱ne̱ a kine ko̱waa ke̱dame̱naŋsɛ.’ ");
INSERT INTO ncuNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ane̱ŋ a ase̱sɛ bɔye̱‑ɔ ne̱ mo̱ e̱ gya a m bo̱ kyo̱ŋwe̱ mfe̱ŋ ne̱ bamo̱ ke̱se̱bɔgyiiri maa lo̱we̱ pɛɛɛ‑ɔ. Ase̱sɛ timaa‑o fe̱raa e̱ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yeesuu a kaapo̱ mò̱ agyase̱po̱‑ɔ amo̱‑ɔ pɛɛɛ lo̱we̱‑ɔ, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mo̱ne̱ nyi fe̱yɛ ŋke ŋnyɔ bo̱ fo̱‑ɔ, Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese‑o kigyibe̱e̱ e̱ fo̱. Saŋ‑ɔ na bo̱ taa mo̱, dimaadi mò̱ gyi‑o, waa bo̱ko̱ ke̱sare̱e̱‑rɔ na bo̱ da mo̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱ mɔɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ne̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ na maŋ abre̱sɛ a gyaŋŋe̱ ɔlɔŋŋɔpo̱ bre̱sɛ ne̱ ba te̱e̱ mò̱ ɛ Kayafas‑ɔ lɔŋ‑nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ne̱ baa le̱e̱ ba kpa e̱kpa ne̱ ba bo̱rɔ se̱ a bo̱ kra Yeesuu, na ɔko̱ mo̱ŋ ŋu‑o, na bo̱ mɔɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Amaa bo̱ yɛ, “Ane̱ ma kra mò̱ Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese kigyi a ŋke‑o‑ro, a le̱e̱ fe̱yɛ ane̱ ya kra mò̱ ŋke amo̱‑rɔ, lamaŋ maa sure, na bamo̱ iduŋ fwii, na bo̱ baa e̱kɔ maŋ‑nɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Saŋ amo̱ ŋke ŋko̱ Yeesuu bo̱ Bɛtaniya kamaŋgyii‑ro. Ne̱ ɔnyare̱ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Simɔŋ, ne̱ ɔ be̱e̱ ɔ dɛɛ ɔ gye̱ bwatɔpo̱‑ɔ a nyiŋŋi mò̱ fe̱yɛ ɔ bo̱ gyi ateese mò̱ lɔŋ‑nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yeesuu a te o gyi ateese‑o, ne̱ ɔkye̱e̱ ko̱ a lweero ba mò̱ ase̱. Na o de mò̱ laŋpe̱ŋtaa yawo̱ le̱ŋsɛ ko̱. Laŋpe̱ŋtaa amo̱ bo̱ kalɔgyii dame̱naŋsɛ ko̱ ne̱ baa taa kibu ne̱ ba te̱e̱ ke̱mo̱ ɛ alabase̱taa‑ɔ bo̱ waa‑ɔ‑rɔ ne̱e̱. Ne̱ oo twiiri laŋpe̱ŋtaa‑ɔ we̱e̱ Yeesuu kuŋu si. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yeesuu agyase̱po̱‑ɔ a ŋu amo̱‑ɔ, ne̱ bamo̱ iduŋ a fwii. Ne̱ bo̱ yɛ, “Nte̱tɔ e̱ gye̱ laŋpe̱ŋtaa amo̱ ke̱nye̱ra ane̱ŋ? ");
INSERT INTO ncuNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ɔkye̱e̱ mɔ a fe laŋpe̱ŋtaa mɔ ne̱e̱, weetee ɔ nya atanne̱ bwe̱e̱tɔ, na ɔ nya taa atanne̱‑ɔ bo̱ sa atiripo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yeesuu a nyi ke̱tɔ ne̱ ba tɔwe̱ ke̱mo̱ a ase̱ŋ‑ɔ se̱‑ɔ, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Nte̱tɔ se̱ ne̱ mo̱ne̱ e̱ waa mò̱ ane̱ŋ? M fe̱raa mo̱ ase̱, atɔ timaa na ke̱dame̱naŋsɛ ne̱ ɔɔ waa. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mo̱ne̱ de atiripo̱ mo̱ne̱ ase̱ saŋ ke̱maa, amaa m fe̱raa mo̱ aa mo̱ne̱ maa kye̱na a ane̱ bo̱ yɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ke̱tɔ ne̱ ɔɔ waa‑ɔ e̱ gye̱ fe̱yɛ mò̱ a twiiri laŋpe̱ŋtaa‑ɔ we̱e̱ mo̱ se̱‑ɔ, ɔɔ ba a ɔ bo̱ lɔŋŋɔ mo̱ kayo̱wɔre̱ bo̱ sa mo̱ kipure‑o ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mbe̱yɔmɔ mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ kaye̱ mɔ pɛɛɛ‑rɔ to̱ŋ ke̱maa ne̱ ba tɔwe̱ abware̱se̱ŋ‑ɔ, bo̱ le̱e̱ ke̱tɔ ne̱ ɔkye̱e̱ mɔ a waa‑ɔ se̱‑ɔ, mò̱ ke̱nyare̱ maa muri amo̱‑rɔ daa.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mfe̱ŋ ne̱ Yeesuu agyase̱po̱ kudu anyɔ‑ɔ ɔko̱ ne̱ ba te̱e̱ mò̱ ɛ Yudas Kariyotinyi‑o a yɔ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ ya taa Yeesuu bo̱ waa mo̱ne̱ ke̱sare̱e̱‑rɔ, atanne̱ afe̱ne̱ ne̱ mo̱ne̱ e̱ sa mo̱?” Ne̱ baa kare̱ atanne̱gyi fufuri adusa ne̱ ke̱ke̱maa a fo̱ siidii aduna‑ɔ sa mò̱ (GHC 1,200). ");
INSERT INTO ncuNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Le̱e̱ kake amo̱ bo̱ yɔ ne̱ Yudas a le̱e̱ ɔ kpa kpa ne̱ ɔ bo̱ lee Yeesuu bo̱ sa bamo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kadawɔkywe̱e̱ a kake ne̱ ka gye̱ ŋkpɛɛ ne̱ ba gyi bodobodoo ne̱ yiisi mo̱ŋ te‑ro‑o, ne̱ Yeesuu a agyase̱po̱‑ɔ bo̱ko̱ a ba mò̱ ase̱ bo̱ bise mò̱ fe̱yɛ, “Mfe̱ne̱ ne̱ fo̱ e̱ kpa fe̱yɛ ane̱ ya lɔŋŋɔ sa fo̱ a fo̱ ya gyi Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese‑o?” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ bo̱ yɔ ɔnyare̱ ko̱ ase̱ maŋ‑nɔ na bo̱ tɔwe̱ gywii mò̱ fe̱yɛ, “Ɔkaapo̱po̱‑ɔ yɛ mò̱ saŋ‑ɔ a ba. Amo̱se̱‑ɔ ɔ kpa fe̱yɛ mò̱ aa mò̱ agyase̱po̱‑ɔ gyi Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese‑o fo̱ lɔŋ‑nɔ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ne̱ agyase̱po̱ amo̱ a waa ane̱ŋ ne̱ Yeesuu a tɔwe̱ gywii bamo̱‑ɔ, ne̱ baa waa Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese‑o siraa mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kyɔwe̱ a lo̱we̱‑ɔ, ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱ kudu anyɔ‑ɔ a kye̱na a bo̱ gyi Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bamo̱ a te ba gyi‑o, ne̱ Yeesuu yɛ, “Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ mo̱ne̱‑rɔ ɔko̱ i gyi mo̱ kidiburo.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mò̱ a tɔwe̱ ane̱ŋ‑ɔ, ne̱ aa waa bamo̱ mfɛɛre̱ bwe̱e̱tɔ. Ne̱ baa le̱e̱ ba bise mò̱ ke̱gyase̱ ke̱gyase̱ fe̱yɛ, “Kase̱ŋtiŋ ne̱e̱, mo̱ ne̱ fo̱ de, bɛɛɛ?” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Ɔko̱ ne̱ mo̱ aa mò̱ ke̱sare̱e̱ i di gyare̱ ko̱ŋko̱‑rɔ ane̱ i gyi‑o e̱ gye̱ ne̱ o gyi mo̱ kidiburo. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mo̱, dimaadi mò̱ gyi‑o, i wu fe̱yɛ ane̱ŋ ne̱ baa kyo̱rɛɛ mo̱ ase̱ŋ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ. Amaa ɔko̱ ne̱ o gyi mo̱ kidiburo‑o i ŋu ase̱ŋ ne̱e̱ fɛɛ. Bo̱ dɛɛ bo̱ mo̱ŋ ko̱we̱ ane̱ŋ a se̱sɛ‑ɔ ne̱e̱, weetee a bɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ne̱ Yudas odiburopo̱‑ɔ yɛ, “Ɔkaapo̱po̱, mo̱ ne̱ fo̱ de, bɛɛɛ?” Ne̱ Yeesuu a be̱ŋŋaa mò̱ fe̱yɛ, “Fo̱ nyi gbaa.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Saŋ ne̱ bo̱ maa se̱ ba gyi‑o, ne̱ Yeesuu a taa bodobodoo, ne̱ ɔɔ sa Wuribware̱ aŋsɛ we̱e̱ se̱, ne̱ ɔɔ te̱ŋŋe̱‑rɔ sa mò̱ agyase̱po̱‑ɔ. Ne̱ ɔ yɛ, “Mo̱nꞌ kɔɔre̱, na mo̱nꞌ gyi. Mo̱ ko̱yo̱wɔre̱gyi ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ne̱ ɔɔ taa nta ko̱to̱re̱nkyu bo̱rɔ, ne̱ ɔɔ sa Wuribware̱ aŋsɛ we̱e̱ se̱, ne̱ ɔɔ taa sa bamo̱. Ne̱ ɔ yɛ, “Mo̱ne̱ pɛɛɛ, mo̱nꞌ kɔɔre̱ nuu. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Mo̱ mbo̱gya ne̱ n twiiri a ŋ we̱e̱, na Wuribware̱ nya taa ase̱sɛ bwe̱e̱tɔ e̱bɔye̱ bo̱ ke bamo̱‑ɔ ne̱e̱. Mo̱ mbo̱gya ne̱ n tii Wuribware̱ na ase̱sɛ mbo̱ŋtɔ‑rɔ a e̱taŋ po̱pwɛɛ‑ɔ kanɔ‑ɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ le̱e̱ mbe̱yɔmɔ bo̱ yɔ, ma lɛɛ nuu nta mɔ pɛɛɛ, amɔ ŋke nsi ne̱ mo̱ aa mo̱ne̱ i nuu nta po̱pwɛɛ saŋ ne̱ n se̱ Wuribware̱ e̱ ba a ɔ bo̱ gyi mò̱ kuwure‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ne̱ baa waa kiliŋ bo̱ kyo̱rɔ Wuribware̱ mfe̱ŋ, ne̱ baa le̱e̱ kawu yɔ Mfɔ-Ayii ke̱be̱e̱‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ne̱ Yeesuu a be̱e̱ kya se̱ tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Mo̱ne̱ pɛɛɛ mɔ e̱ se̱re̱ a mo̱nꞌ yɔwe̱ mo̱ kanye mɔ, fe̱yɛ ane̱ŋ ne̱ abware̱se̱ŋ wo̱re̱‑ɔ a tɔwe̱ ɛ, ‘Wuribware̱ e̱ mɔɔ e̱sanne̱ ɔde̱e̱re̱se̱po̱‑ɔ, na e̱sanne̱‑ɔ pɛɛɛ mɔ brawe̱‑rɔ’‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Amaa mo̱ ya bo̱ kyiŋŋi le̱e̱ lowi‑ro, mo̱ e̱ gye̱ mo̱ne̱ ŋkpɛɛ a ŋ yɔ Galile̱ya swe̱e̱re̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Mfe̱ŋ ne̱ Peetroo a tɔwe̱ gywii Yeesuu fe̱yɛ, “Hare̱e̱ mo̱ bɛɛko̱‑ana mɔ ya se̱re̱, m fe̱raa ma se̱re̱ a ŋ yɔwe̱ fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ne̱ Yeesuu mɔ a be̱ŋŋaa mò̱ fe̱yɛ, “Mo̱ e̱ tɔwe̱ mo̱ i gywii fo̱ fe̱yɛ, fo̱ e̱ swe̱e̱ iluwi e̱sa kanye mɔ fe̱yɛ fo̱ mo̱ŋ nyi mo̱ pwɛɛ na kyaŋare̱ dɛɛ fo̱re̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ne̱ Peetroo a be̱e̱ be̱ŋŋaa mò̱ fe̱yɛ, “Hare̱e̱ amo̱ e̱ gye̱ mo̱ aa fo̱ lowi gbaa, ma tɔwe̱ fe̱yɛ mo̱ŋ nyi fo̱.” Ne̱ agyase̱po̱ ne̱ baa saŋ‑ɔ pɛɛɛ mɔ a tɔwe̱ ane̱ŋ dɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Amo̱‑ɔ kamɛɛ‑rɔ, ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ a ba bane̱ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Gɛte̱sɛmane̱e̱‑ɔ‑rɔ. Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱nꞌ kye̱na mfe̱e̱, na ŋ yɔ nno̱ŋ ya ko̱re̱ ke̱bware̱ko̱re̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ne̱ ɔɔ te̱e̱ Peetroo na Sibidii mò̱ gyi‑ana anyɔ‑ɔ, bamo̱ e̱ gye̱ Yakubu na Yohanee, bo̱ tii mò̱ e̱ye̱e̱ se̱, ne̱ baa yɔ. Mfe̱ŋ ne̱ mò̱ abaa‑rɔ a yɔre̱, ne̱ mò̱ kayo̱wɔre̱‑rɔ a waa mò̱ yɔre̱yɔre̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ bo̱re̱‑rɔ i duŋwi mo̱ bwe̱e̱tɔ, hare̱e̱ mo̱ e̱ kpa a ŋ wu. To, mo̱nꞌ kyiŋŋi kye̱na mo̱ ase̱ mfe̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ne̱ ɔɔ nare̱ yɔ akatɔ‑rɔ kafwe̱e̱, ne̱ ɔɔ ya kyo̱ŋ di kame si swe̱e̱re̱. Ne̱ ɔɔ ko̱re̱ Wuribware̱ fe̱yɛ, “N se̱ Wuribware̱, mo̱ e̱ ko̱re̱ fo̱ ne̱e̱ fe̱yɛ, amo̱ e̱ kaa a baare, fo̱ sa a mo̱ awo̱re̱fɔɔ ne̱ mo̱ i gyi‑o mɔ gye̱ kɛɛ, na m ma wu. Amaa kanɔ ŋke̱maa ne̱ fo̱ e̱ kpa‑ɔ bware sa mo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ne̱ oo kiŋŋi ya to̱ fe̱yɛ mò̱ agyase̱po̱ asa amo̱ pɛɛɛ a di idi. Ne̱ oo bise Peetroo fe̱yɛ, “E̱me̱ne̱ se̱ ne̱ mo̱ne̱ abɛɛ asa mo̱ŋ taare̱ kye̱na mo̱ ase̱ dɔŋhwe̱re̱e̱ ko̱ŋko̱, na mo̱ne̱ mo̱ŋ di idi? ");
INSERT INTO ncuNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","To, mo̱nꞌ kyiŋŋi kye̱na, na mo̱nꞌ ko̱re̱ ke̱bware̱ko̱re̱ fe̱yɛ Ɔbɔnsam ma kaŋ kyɔ mo̱ne̱‑rɔ ke̱e̱ fe̱yɛ mo̱ne̱ i kiŋŋi kamɛɛ aaa. Mo̱ne̱ ŋkpo̱nɔ e̱ kpa kikyiŋŋi kye̱na, amaa mo̱ne̱ ŋyo̱wɔre̱‑rɔ mɔ a waa yɔre̱yɔre̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ne̱ ɔɔ be̱e̱ yɔ ya ko̱re̱ ke̱bware̱ko̱re̱. Ne̱ ɔ yɛ, “N se̱, mo̱ awo̱re̱fɔɔ ne̱ mo̱ i gyi‑o e̱ ma gye̱ kɛɛ, na mo̱ŋ gyi amo̱ lo̱we̱ wu fe̱raa, ane̱ŋ ne̱ fo̱ e̱ kpa‑ɔ e̱ gye̱ ne̱ a waa.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ne̱ ɔɔ be̱e̱ kiŋŋi ya to̱ fe̱yɛ mò̱ agyase̱po̱‑ɔ a be̱e̱ di idi. Bo̱ mo̱ŋ taare̱ kra idi. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ne̱ Yeesuu a be̱e̱ yɔwe̱ bamo̱ ya ko̱re̱ ke̱bware̱ko̱re̱ sase̱po̱ fe̱yɛ ane̱ŋ ne̱ ɔɔ ko̱re̱ nyɔse̱po̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ne̱ ɔɔ be̱e̱ kiŋŋi yɔ agyase̱po̱ amo̱ ase̱ ya tɔwe̱ fe̱yɛ, “Mo̱ne̱ saŋ mo̱ne̱ i di idi mo̱ne̱ i kyure ne̱e̱ e̱e̱e̱? To, saŋ a fo̱ mbe̱yɔmɔ. Mo̱nꞌ de̱e̱re̱, ba lee mo̱, dimaadi mò̱ gyi‑o, ba sa e̱bɔye̱ awaapo̱, na bo̱ nya mo̱ se̱ ke̱yaale̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mo̱nꞌ ke̱e̱, ɔko̱ ne̱ o gyi mò̱ kidiburo‑o e̱ ba‑ɔ. Mo̱nꞌ ko̱so̱ a ane̱ yɔ na ane̱ ya gyaŋŋaa mò̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yeesuu saŋ ɔ sa se̱ŋsa o gywii mò̱ agyase̱po̱‑ɔ, ne̱ Yudas ne̱ ɔ gye̱ agyase̱po̱ kudu anyɔ‑ɔ ɔko̱‑ɔ a fo̱. Mò̱ aa ase̱sɛ kukwii dabe̱ ko̱ na bamo̱ apaŋ na akyokuŋ ya ba. Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na maŋ abre̱sɛ‑ɔ ya suŋ bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Amɔ odiburopo̱‑ɔ a kyɔ kaapo̱ ase̱sɛ amo̱ ne̱ bo̱ gya mò̱ se̱ ba ba‑ɔ kpa ne̱ ba bo̱rɔ se̱ a bo̱ kra Yeesuu‑o. Ɔɔ tɔwe̱ gywii bamo̱ ne̱e̱ fe̱yɛ, “Ɔko̱ ne̱ mo̱ e̱ yɔ a ŋ ya ka mò̱ kanɔ‑ɔ e̱ gye̱ mò̱ ne̱ mo̱ne̱ e̱ kpa‑ɔ. Mo̱nꞌ kra mò̱, na mo̱nꞌ taa mò̱ nare̱!” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Amo̱se̱‑ɔ Yudas a de̱ŋ fo̱‑ɔ, ne̱ ɔɔ yɔ Yeesuu ase̱ ya te̱e̱ mò̱ fe̱yɛ, “Ɔkaapo̱po̱.” Ne̱ ɔɔ kyo̱kywe̱e̱ mò̱ ke̱daabɔŋ dame̱naŋsɛ ka mò̱ kanɔ, fe̱yɛ ane̱ŋ ne̱ Yudaa awuye e̱ ka abɛɛ kanɔ saŋ ke̱maa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Mo̱ nyare̱, waa ke̱tɔ ne̱ fo̱ a ba a fo̱ bo̱ waa‑ɔ lo̱we̱.” Ne̱ baa ba bo̱ kra Yeesuu. Ne̱ baa kra mò̱‑rɔ keŋkeŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mfe̱ŋ ne̱ Yeesuu a agyase̱po̱‑ɔ ɔko̱ a gyiiri mò̱ ke̱paŋ le̱e̱ ke̱mo̱ ke̱gyafo̱‑rɔ bo̱ ŋe Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ a anya‑ɔ ɔko̱ ke̱se̱bɔ te̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Amaa ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Yɔwe̱, na fo̱ taa fo̱ ke̱paŋ‑ɔ bo̱ waa ke̱mo̱ ke̱gyafo̱‑rɔ. Ɔke̱maa ne̱ ɔ taa ke̱paŋ a ɔ bo̱ kɔ‑ɔ, ba ba ke̱paŋ a bo̱ bo̱ mɔɔ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Fo̱ mo̱ŋ nyi fe̱yɛ mo̱ e̱ taare̱ a n te̱e̱ n se̱ Wuribware̱ a ɔ bo̱ kya mo̱‑rɔ aaa? Na puri‑ro ɔ ba mò̱ mbɔɔ anaapo̱‑ɔ ŋkpe̱ŋ ŋkpe̱ŋ bo̱ kyo̱ŋwe̱ aaa? ");
INSERT INTO ncuNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mò̱ ya sa ne̱ baa mo̱rɔwe̱ mo̱ le̱e̱ anyare̱ mɔ ke̱sare̱e̱‑rɔ fe̱raa, e̱me̱ne̱ ne̱ mo̱ i wu mo̱ lowi ne̱ baa kyo̱rɛɛ mo̱ ase̱ŋ abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Mfe̱ŋ ne̱ Yeesuu a tɔwe̱ gywii bamo̱ ne̱ baa kra mò̱ bo̱ de‑ro‑o fe̱yɛ, “Amɔ mo̱ne̱ a ba apaŋ na akyokuŋ ne̱e̱ a mo̱nꞌ ba bo̱ kra mo̱ fe̱yɛ oyu‑o ooo? Ŋke mfe̱ne̱ mɔ‑rɔ mo̱ aa mo̱ne̱ ne̱e̱ na n te Wuribware̱ suŋkpa kabuno‑o mo̱ e̱ kaapo̱ abware̱se̱ŋ, na mo̱ne̱ mɔ mo̱ne̱ mo̱ŋ kra mo̱? ");
INSERT INTO ncuNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Amaa amo̱‑ɔ a ba ane̱ŋ ne̱e̱ na ke̱tɔ ne̱ Wuribware̱ a akyaamɛɛ‑ɔ bo̱ko̱ a kyo̱rɛɛ mo̱ ase̱ŋ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ nya waa kase̱ŋtiŋ.” Mfe̱ŋ ne̱ Yeesuu a agyase̱po̱‑ɔ pɛɛɛ a se̱re̱ yɔwe̱ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","To, ne̱ bamo̱ ne̱ baa kra Yeesuu‑o a taa mò̱ yaa Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ Kayafas a lɔŋ‑ɔ‑rɔ, mfe̱ŋ ne̱ Wuribware̱ mbraa akaapo̱po̱ na maŋ abre̱sɛ e̱ gyaŋŋe̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ne̱ Peetroo a sii kamɛɛ ɔ gya bamo̱ se̱. Ɔɔ gya bamo̱ se̱ ane̱ŋ‑aaa ya bo̱ fo̱ ɔlɔŋŋɔpo̱ bre̱sɛ a lɔŋ amo̱ kanɔ, ne̱ oo lwee lɔŋ‑ɔ kabuno‑o‑ro. Mfe̱ŋ ne̱ ɔɔ kye̱na ade̱e̱re̱se̱po̱ ko̱ ase̱ na ɔ nya ŋu ke̱tɔ ne̱ ke̱ e̱ yɔ se̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ne̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na agyaŋŋe̱po̱‑ɔ pɛɛɛ a buwi kpa kanɔte̱ŋ ne̱ ba ye̱re̱ se̱ na Yeesuu gyi ke̱pɔ a bo̱ nya mɔɔ mò̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ne̱ baa buwi kpa kpo̱ne̱. Ase̱sɛ bwe̱e̱tɔ a bo̱ ba bamo̱ aye̱ba bo̱ kye mò̱ gbaa ooo, ɔ mo̱ŋ gyi ke̱pɔ, a le̱e̱ fe̱yɛ bamo̱ aye̱ba‑ɔ mo̱ŋ ye̱re̱ abɛɛ se̱. Ne̱ ŋkee abɛɛ anyɔ a ko̱so̱ ba aye̱ba bo̱ po̱rɔ Yeesuu fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Ɔnyare̱ mɔ yɛ, ‘Mo̱ e̱ taare̱ a m bwee Wuribware̱ suŋkpa‑ɔ, na ŋke nsa kamɛɛ‑rɔ na m pwɛɛ mò̱ bo̱ ye̱ra.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ne̱ Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ‑ɔ a kyuwi‑ro. Ne̱ oo bise Yeesuu fe̱yɛ, “Amɔ fo̱ mo̱ŋ de ase̱ŋ mɔ pɛɛɛ ne̱ ba tɔwe̱ ba kye fo̱‑ɔ kanɔlee aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ne̱ Yeesuu a laatɔ. Ne̱ ɔlɔŋŋɔpo̱ bre̱sɛ‑ɔ a tɔwe̱ gywii mò̱ fe̱yɛ, “Ka Wuribware̱ ne̱ mò̱ wo̱re̱ dooo i de ŋkpa‑ɔ ke̱yaa, tɔwe̱ gywii ane̱ fe̱yɛ fo̱ e̱ gye̱ Kristoo, Wuribware̱ mò̱ gyi ne̱ oo suŋ mò̱ bo̱ kyo̱ŋwe̱‑ɔ, bɛɛɛ n gye̱ fo̱ e̱ gye̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ŋkee fe̱raa ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Ane̱ŋ ne̱ a du‑o dɛɛ ne̱ fo̱ a tɔwe̱‑ɔ. Ke̱tɔ ne̱ ki tii si‑o e̱ gye̱ fe̱yɛ mo̱ne̱ saŋ mo̱ne̱ i ŋu mo̱, dimaadi mò̱ gyi‑o, a te Bo̱-e̱le̱ŋ‑ɔ‑kyo̱ŋ‑ɔke̱maa-Bware̱ kigyise si, na mo̱ aa mò̱ a gyi mò̱ kuwure dabe̱‑ɔ, na mo̱ a le̱e̱ awo̱re̱‑rɔ mo̱ e̱ ba.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Amo̱ fe̱raa ne̱ ɔlɔŋŋɔpo̱ bre̱sɛ‑ɔ a ba kaduŋfwii bo̱ kyaŋ mò̱ fɔŋfɔŋ waagya‑rɔ. Ne̱ ɔ yɛ, “Ɔnyare̱ mɔ a tɔwe̱ abuse̱ŋse̱ŋ. Ane̱ maa lɛɛ kpa a ɔko̱ tɔwe̱ ko̱tɔko̱ pwɛɛ a ane̱ dɛɛ ŋu fe̱yɛ o gyi ke̱pɔ. Mo̱ne̱ a nu ase̱ŋ ne̱ ɔɔ tɔwe̱ bo̱ kye Wuribware̱‑ɔ, ɔ yɛ mò̱ aa Wuribware̱ ta. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Amo̱se̱‑ɔ e̱me̱ne̱ ne̱ mo̱ne̱ e̱ fa fe̱yɛ ane̱ waa mò̱?” Ne̱ bamo̱ pɛɛɛ a sure si fe̱yɛ o gyi ke̱pɔ, amo̱se̱‑ɔ bo̱ mɔɔ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Mfe̱ŋ dɛɛ ne̱ bo̱ko̱ a le̱e̱ ba twe̱e̱ akyɔne̱ ba waa Yeesuu akatɔ‑rɔ, na ba da mò̱ akuŋtiŋ. Ne̱ bo̱ko̱ mɔ a da mò̱ abaa. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ne̱ bo̱ yɛ, “Fo̱ i nyi fe̱yɛ fo̱ gye̱ Kristoo ne̱ Wuribware̱ a suŋ‑o, tɔwe̱ mò̱ ne̱ ɔɔ da fo̱‑ɔ gywii ane̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Bamo̱ a gyi Yeesuu ase̱ŋ ke̱kyaŋ‑nɔ‑ɔ na Peetroo saŋ o te kabuno mfe̱ŋ. Ne̱ kabre ko̱ a ba mò̱ ase̱ bo̱ tɔwe̱ fe̱yɛ, “Fo̱ gbaa fo̱ aa Yeesuu Galile̱yanyi mɔ e̱ dɛɛ mo̱ne̱ naa.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ne̱ Peetroo a swe̱e̱ bamo̱ pɛɛɛ akatɔ‑rɔ fe̱yɛ, “Mo̱ŋ nu ase̱ŋ ne̱ fo̱ e̱ tɔwe̱ amo̱‑ɔ kaase̱.” Ne̱ ɔɔ nare̱ ya ye̱re̱ lɔŋ‑ɔ kibunogyi‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Mfe̱ŋ‑ɔ ne̱ kabre ko̱ mɔ a be̱e̱ ŋu mò̱. Ne̱ ɔɔ tɔwe̱ gywii bamo̱ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ fe̱yɛ, “Ɔnyare̱ mɔ na Yeesuu Nasarɛte̱nyi‑o e̱ gye̱ ne̱ bo̱ naa.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Amaa Peetroo a be̱e̱ swe̱e̱ fe̱yɛ, “Kase̱ŋtiŋ ne̱ mo̱ e̱ tɔwe̱, ma ba aye̱ba ne̱e̱. Mo̱ e̱ ka Wuribware̱ se̱ ke̱yaa fe̱yɛ mo̱ŋ nyi ɔnyare̱ amo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ke̱tɔ a be̱e̱ waa kafwe̱e̱‑ɔ, ne̱ bamo̱ ne̱ bo̱ ye̱re̱ mfe̱ŋ‑ɔ a tɔwe̱ gywii Peetroo fe̱yɛ, “Fo̱ maa taare̱ a fo̱ gyiiri ikii fe̱yɛ fo̱ mo̱ŋ gye̱ Yeesuu a ase̱sɛ‑ɔ ɔko̱, a le̱e̱ fe̱yɛ kpa ke̱maa se̱ fo̱ se̱ŋsa i lee fo̱ kawu.” ");
INSERT INTO ncuNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ne̱ Peetroo a be̱e̱ be̱ŋŋaa fe̱yɛ, “Mo̱ e̱ ka ke̱yaa fe̱yɛ n kyɔ mo̱ŋ nyi ɔnyare̱ mɔ ne̱ mo̱ne̱ e̱ tɔwe̱ mò̱ ase̱ŋ‑ɔ. Ne̱ ase̱ŋ mɔ ne̱ mo̱ e̱ tɔwe̱‑ɔ e̱ mo̱ŋ gye̱ kase̱ŋtiŋ, amo̱ fe̱raa Wuribware̱ lo̱ŋ mo̱.” Ne̱ ɔɔ be̱e̱ ka ane̱ŋ a ke̱yaa‑ɔ iluwi bwe̱e̱tɔ. Mò̱ ke̱de̱ŋ tɔwe̱ ane̱ŋ lo̱we̱‑ɔ, ne̱ kyaŋare̱ a fo̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ne̱ oo nyiŋŋi ane̱ŋ ne̱ Yeesuu a tɔwe̱ gywii mò̱‑ɔ se̱ fe̱yɛ, “Fo̱ e̱ swe̱e̱ iluwi e̱sa fe̱yɛ fo̱ mo̱ŋ nyi mo̱ pwɛɛ na kyaŋare̱ dɛɛ fo̱re̱”‑ɔ. Ne̱ ɔɔ yɔ kawu ya su bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kaye̱ ŋke gye̱gyaye̱ tututu‑o, ne̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ na maŋ abre̱sɛ pɛɛɛ a gyaŋŋe̱ da kikpuni fe̱yɛ bo̱ mɔɔ Yeesuu. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ne̱ baa ba agbarabi bo̱ da mò̱ asare̱e̱‑rɔ, ne̱ baa yaa mò̱ Romanyi gominaa ne̱ ba te̱e̱ mò̱ ɛ Pilat‑o akatɔ‑rɔ, na ɔ sa bamo̱ kpa fe̱yɛ bo̱ mɔɔ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Amɔ Yudas odiburopo̱‑ɔ a ŋu fe̱yɛ baa bu Yeesuu ke̱pɔ tɔwe̱ fe̱yɛ ba mɔɔ mò̱‑ɔ, ne̱ oo nu mò̱ e̱ye̱e̱, ne̱ ɔɔ yɔ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na maŋ abre̱sɛ‑ɔ ase̱ ya kiŋŋaa atanne̱ fufuri agyi adusa ne̱ baa sa mò̱‑ɔ sa bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ a waa bɔye̱ fe̱yɛ mo̱ a gyi ɔnyare̱ timaa amo̱ kidiburo.” Ne̱ baa be̱ŋŋaa mò̱ fe̱yɛ, “Amo̱‑ɔ tiri ane̱ aaa? Fo̱ wo̱re̱ fo̱ ase̱ŋ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ne̱ Yudas a ya twe̱e̱ atanne̱‑ɔ bo̱ be̱ya swe̱e̱re̱ Wuribware̱ suŋkpa. Ne̱ ɔɔ le̱e̱ mfe̱ŋ ya kya mò̱ e̱ye̱e̱ fe, ne̱ oo wu. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ a ŋu atanne̱‑ɔ da swe̱e̱re̱ mfe̱ŋ‑ɔ, ne̱ bo̱ yɛ, “Atanne̱ ne̱ ane̱ a bo̱ ka ɔnyare̱ ko̱ lowi ko̱kɔ‑ɔ ne̱e̱. Mbo̱gya atanne̱ ne̱e̱, ane̱ŋ se̱‑ɔ a de iyisi. Amo̱se̱‑ɔ a kye ane̱ mbraa fe̱yɛ ane̱ taa waa Wuribware̱ suŋkpa a atanne̱ ne̱ a da‑ɔ‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Bamo̱ a fa atanne̱ amo̱ ase̱ŋ lo̱we̱‑ɔ, ne̱ baa waa kanɔ ba atanne̱‑ɔ bo̱ sɔɔ swe̱e̱re̱ ko̱ ne̱ ba te̱e̱ ɛ Ɔpwɛɛpo̱ a swe̱e̱re̱‑ɔ, na bo̱ nya pure afɔ ne̱ bo̱ bo̱ mfe̱ŋ, ne̱ ba wu‑o swe̱e̱re̱ amo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Amo̱se̱ se̱‑ɔ ne̱ ba te̱e̱ swe̱e̱re̱ amo̱ fe̱yɛ, “Mbo̱gya a swe̱e̱re̱‑ɔ” bo̱ fo̱ ndɔɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Ane̱ŋ se̱‑ɔ, ane̱ŋ ne̱ Wuribware̱ kyaamɛɛ Yɛrɛme̱ya a kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ a ba kase̱ŋtiŋ. Ɔɔ kyo̱rɛɛ fe̱yɛ, “Ne̱ Isireelii awuye a sure si fe̱yɛ ba ka atanne̱ fufuri agyi‑ro adusa a bo̱ sa mò̱. Ne̱ baa ba atanne̱ mɔ bo̱ sɔɔ swe̱e̱re̱ ne̱ ba te̱e̱ ɛ Ɔpwɛɛpo̱ a swe̱e̱re̱‑ɔ, fe̱yɛ ane̱ŋ ne̱ mo̱ nyaŋpe̱ Wuribware̱ a tɔwe̱ gywii mo̱ fe̱yɛ ŋ waa‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Bamo̱ a yaa Yeesuu Romanyi gominaa‑o akatɔ‑rɔ‑ɔ, ne̱ gominaa‑o a bise mò̱ fe̱yɛ, “Baa po̱rɔ fo̱ fe̱yɛ fo̱ a tɔwe̱ fe̱yɛ fo̱ e̱ gye̱ Yudaa awuye owure‑o. E̱me̱ne̱ ne̱ fo̱ i lee kanɔ?” Ne̱ Yeesuu a be̱ŋŋaa mò̱ fe̱yɛ, “Se̱ŋbise mɔ a le̱e̱ fo̱ ase̱ ne̱e̱ e̱e̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Amaa Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na maŋ abre̱sɛ a mpo̱rɔ‑ɔ, Yeesuu mo̱ŋ lee mmo̱ kanɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mfe̱ŋ ne̱ gominaa‑o a bise mò̱ fe̱yɛ, “Fo̱ maa nu ase̱ŋ mɔ ne̱ baa po̱rɔ fo̱ amo̱ se̱‑ɔ ɔɔɔ?” ");
INSERT INTO ncuNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Amaa Yeesuu mo̱ŋ be̱ŋŋaa mò̱. Ɔ mo̱ŋ lee mpo̱rɔ ne̱ baa po̱rɔ mò̱‑ɔ ŋko̱ŋko̱ gbaa kanɔ. Ane̱ŋ se̱‑ɔ ne̱ gominaa‑o e̱ye̱e̱ a kpe̱ŋ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Amɔ saŋ ke̱maa mɔ, Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese kigyi‑o‑ro, Romanyi gominaa i lee bamo̱ ne̱ oo tii bamo̱ tiikpa‑ɔ ɔko̱ ne̱ lamaŋ e̱ kpa‑ɔ na ɔ nare̱ ya kyure. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Saŋ amo̱‑ɔ ne̱ oo tii ɔnyare̱ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Bar‑Abas‑ɔ ne̱ ɔke̱maa nyi mò̱ asuŋ bɔye̱ ne̱ ɔɔ waa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Amo̱se̱‑ɔ lamaŋ‑ɔ a gyaŋŋe̱ gominaa‑o akatɔ‑rɔ bo̱ ko̱re̱ mò̱ fe̱yɛ o lee bamo̱ ne̱ oo tii‑o ɔko̱ sa bamo̱‑ɔ, ne̱ ɔɔ be̱ŋŋaa bamo̱ fe̱yɛ, “To, mmo̱ ne̱ mo̱ne̱ e̱ kpa fe̱yɛ n lee mò̱ le̱e̱ tiikpa sa mo̱ne̱, Bar‑Abas bɛɛɛ Yeesuu ne̱ bo̱ko̱ e̱ te̱e̱ mò̱ ɛ Kristoo ne̱ Wuribware̱ a suŋ‑o ooo?” ");
INSERT INTO ncuNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Amɔ gominaa‑o nyi dame̱naŋsɛ fe̱yɛ ko̱kwe̱e̱ se̱ ne̱ baa kra Yeesuu baa mò̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Gominaa‑o a te mò̱ se̱ŋgyikpa a kagya‑ɔ se̱ mfe̱ŋ‑ɔ, ne̱ mò̱ ka a kra bo̱ kyo̱ŋwe̱ mò̱ fe̱yɛ, “Mo̱ e̱ ko̱re̱ fo̱ ne̱e̱ fe̱yɛ fo̱ ma waa ɔnyare̱ timaa amo̱ sɛye̱. Bo̱ le̱e̱ fe̱yɛ ndee kanye mo̱ a ku mò̱ dee, ne̱ aa waa mo̱ gya bwe̱e̱tɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ne̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na maŋ abre̱sɛ‑ɔ a da lamaŋ‑ɔ kanɔ se̱ fe̱yɛ bo̱ tɔwe̱ gywii gominaa‑o fe̱yɛ ɔ yɔwe̱ Bar‑Abas bo̱ sa bamo̱, na ɔ mɔɔ Yeesuu. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Amo̱se̱‑ɔ gominaa‑o a be̱e̱ bise bamo̱ fe̱yɛ, “Abɛɛ anyɔ mɔ‑rɔ, mmo̱ ne̱ mo̱ne̱ e̱ kpa fe̱yɛ ŋ yɔwe̱ mò̱ a m bo̱ sa mo̱ne̱?” Ne̱ baa lee kanɔ fe̱yɛ, “Bar‑Abas.” ");
INSERT INTO ncuNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ne̱ gominaa‑o yɛ, “Ne̱ nte̱tɔ ne̱ mo̱ne̱ yɛ ŋ waa Yeesuu ne̱ ba te̱e̱ mò̱ ɛ Kristoo‑o?” Amo̱ fe̱raa ne̱ bamo̱ pɛɛɛ a fɛɛ‑rɔ be̱ŋŋaa mò̱ fe̱yɛ, “Da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱!” ");
INSERT INTO ncuNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ne̱ gominaa‑o yɛ, “Nte̱tɔ bɔye̱ gbaa ne̱ ɔɔ waa?” Ne̱ baa be̱e̱ fɛɛ‑rɔ keŋkeŋ fe̱yɛ, “Da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱!” ");
INSERT INTO ncuNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ne̱ lamaŋ‑ɔ a le̱e̱ ba fɛɛ‑rɔ, ne̱ baa fɛɛ‑rɔ ane̱ŋ‑aaa. Gominaa‑o a ŋu fe̱yɛ ɔ maa lɛɛ taare̱ a ɔ waa sɛye̱ bo̱ kɔɔre̱ Yeesuu‑o, ne̱ ŋkee ase̱ŋ e̱ kpa a a be̱e̱ ba maŋ‑ɔ‑rɔ‑ɔ, ne̱ ɔɔ sa kanɔ, ne̱ baa baa mò̱ kyaŋse̱ na nkyu. Ne̱ ɔɔ fwe̱e̱ mò̱ asare̱e̱ lamaŋ‑ɔ akatɔ‑rɔ. Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ŋ gye̱ mo̱ne̱ ɔgye̱ŋkpɛɛpo̱ ɔnyare̱ mɔ lowi‑ro. Mo̱ne̱ fɔŋfɔŋ awaasɛ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ne̱ lamaŋ‑ɔ pɛɛɛ yɛ, “Sa a ɔnyare̱ mɔ ke̱se̱bɔgyiiri ne̱ ane̱ e̱ sa mò̱‑ɔ kiŋŋi gya ane̱ aa ane̱ agyi si.” ");
INSERT INTO ncuNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Mfe̱ŋ ne̱ gominaa‑o a yɔwe̱ Bar‑Abas bo̱ sa bamo̱. Ne̱ ɔɔ sa ne̱ mò̱ asoogyaa awuye‑o ɔko̱ a da Yeesuu paara, ne̱ ɔɔ taa mò̱ sa bamo̱ fe̱yɛ asoogyaa awuye‑o ya da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ne̱ gominaa a asoogyaa awuye‑o a taa Yeesuu yaa gominaa a lɔŋ‑ɔ‑rɔ, ne̱ baa te̱e̱ bamo̱ bɛɛko̱‑ana bo̱ gyaŋŋe̱ ye̱re̱ muruwaa mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ne̱ baa buŋŋi mò̱ atɔ buŋsɛ, ne̱ baa taa waagya pipee bo̱ buŋ mò̱ fe̱yɛ mò̱ a gye̱ owure‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ne̱ baa ba iwu bo̱ lo̱ kuwurepa bo̱ buŋ mò̱. Ne̱ baa taa kayii nare̱se̱sɛ bo̱ waa mò̱ kigyisesare̱e̱‑rɔ. Ne̱ baa le̱e̱ ba gyɔŋŋɔ mò̱ ayaa‑rɔ ba waa mò̱ ŋwaagyise̱ŋŋe̱ fe̱yɛ, “Aŋsuma, nana, Yudaa awuye owure.” ");
INSERT INTO ncuNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ne̱ baa twe̱e̱ akyɔne̱ we̱e̱ mò̱ se̱, ne̱ baa ba kayii‑o bo̱ daye̱ mò̱ kuŋu‑ro ane̱ŋ‑aaa. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Saŋ ne̱ baa waa mò̱ ŋwaagyise̱ŋŋe̱ lo̱we̱‑ɔ, ne̱ baa lee waagya‑ɔ, ne̱ baa ba mò̱ fɔŋfɔŋ atɔ bo̱ buŋ mò̱. Ne̱ baa taa mò̱ ba yɔ a bo̱ ya da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Saŋ ne̱ asoogyaa awuye‑o de Yeesuu ba yɔ‑ɔ, ne̱ baa gyaŋŋaa ɔnyare̱ ko̱ ne̱ ɔɔ le̱e̱ Kireenee maŋ‑nɔ, ne̱ ba te̱e̱ mò̱ ɛ Simɔŋ‑ɔ. Ne̱ asoogyaa awuye‑o a ye̱re̱ mò̱ waa‑rɔ fe̱yɛ ɔ so̱rɔ Yeesuu a kiyii kpare̱-abɛɛ‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ne̱ baa yaa Yeesuu mfe̱ŋ ne̱ ba te̱e̱ ɛ Gologotaa‑o (kaase̱ e̱ kaapo̱ fe̱yɛ Ko̱lɔŋko̱rɔŋgyi-Swe̱e̱re̱). ");
INSERT INTO ncuNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ne̱ baa bo̱ sa Yeesuu nta ne̱ baa ba kadwii bo̱ waa‑rɔ‑ɔ na mò̱ kayo̱wɔre̱‑rɔ ma lɛɛ duŋwi mò̱. Mò̱ a da ke̱e̱‑ɔ, ne̱ oo kine kunuu. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ne̱ asoogyaa awuye‑o a ba ndangyii bo̱ da mò̱ bo̱ me̱ra mò̱ kiyii kpare̱-abɛɛ‑rɔ‑ɔ se̱. Mfe̱ŋ ne̱ baa waa mpini mpini bo̱ ke mò̱ atɔ buŋsɛ‑rɔ taa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Amo̱ kamɛɛ‑rɔ ne̱ baa kye̱na mfe̱ŋ de̱e̱re̱ mò̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ne̱ baa taa kawo̱re̱taa ko̱ bo̱ me̱ra Yeesuu aŋu si. Gominaa‑o a kyo̱rɛɛ kamo̱ se̱ fe̱yɛ, “Mo̱nꞌ ke̱e̱ Yeesuu, Yudaa awuye owure‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ne̱ baa be̱e̱ da ayu ko̱, ɔko̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ ko̱ se̱ Yeesuu kigyise si, ne̱ baa be̱e̱ da ɔko̱‑ɔ bo̱ me̱ra ko̱ko̱ se̱ mò̱ ke̱be̱na se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ase̱sɛ ne̱ ba kyo̱ŋ mfe̱ŋ‑ɔ e̱ da abaa‑rɔ ne̱e̱, ");
INSERT INTO ncuNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","na ba saare̱ Yeesuu fe̱yɛ, “Mboo. Ne̱e̱ fo̱ yɛ fo̱ i bwee Wuribware̱ suŋkpa‑ɔ na ŋke nsa kamɛɛ fo̱ be̱e̱ pwɛɛ mo̱ bo̱ ye̱ra ɛ? Mbe̱yɔmɔ, fo̱ i nyi fe̱yɛ fo̱ gye̱ Wuribware̱ mò̱ gyi‑o, kpo̱ro̱we̱ le̱e̱ kiyii kpare̱-abɛɛ‑rɔ mɔ se̱ ba swe̱e̱re̱ bo̱ mo̱rɔwe̱ fo̱ e̱ye̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ane̱ŋ dɛɛ ne̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na Wuribware̱ mbraa akaapo̱po̱‑ɔ na maŋ abre̱sɛ‑ɔ a mii nnɔ kyɔ mò̱, na ba mɔse̱ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Na ba tɔwe̱ ba gywii abɛɛ fe̱yɛ, “Ɔɔ mo̱rɔwe̱ bo̱ko̱, amaa ɔ maa taare̱ a ɔ mo̱rɔwe̱ mò̱ e̱ye̱e̱. Mo̱nꞌ sa a ane̱ ke̱e̱ fe̱yɛ, mò̱ a tɔwe̱ fe̱yɛ ɔ gye̱ ane̱ Isireelii awuye a owure‑o ne̱e̱‑ɔ, ɔ taare̱ a ɔ le̱e̱ kiyii kpare̱-abɛɛ‑rɔ mɔ se̱ ba swe̱e̱re̱ aaa. Ne̱ mò̱ ya taare̱ fe̱raa, ane̱ e̱ kɔɔre̱ mò̱ a ane̱ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ɔ yɛ ɔɔ kɔɔre̱ Wuribware̱ gyi, ne̱ ɔ be̱e̱ ɔ yɛ ɔ gye̱ Wuribware̱ mò̱ gyi‑o ne̱e̱. Amo̱se̱‑ɔ mo̱nꞌ sa a ane̱ ke̱e̱ fe̱yɛ Wuribware̱ e̱ kpa a ɔ mo̱rɔwe̱ mò̱ mbe̱yɔmɔ ne̱e̱ e̱e̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ane̱ŋ dɛɛ ne̱ ayu ne̱ baa da bamo̱ ayii kpare̱-abɛɛ‑rɔ se̱ mò̱ ase̱ mfe̱ŋ‑ɔ a saare̱ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Saŋ ne̱ mpase̱ a fo̱‑ɔ, ne̱ kyɔwe̱ a yɔwe̱ ke̱da, ne̱ kibugyii a da swe̱e̱re̱ amo̱ se̱ pɛɛɛ. Ne̱ kaa gyi e̱dɔŋhwe̱re̱e̱ e̱sa. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Saŋ amo̱ a kpa a ɔ gye̱ kɛɛ‑ɔ, ne̱ Yeesuu a faa‑rɔ keŋkeŋ mò̱ aye̱‑rɔ Heebrii fe̱yɛ, “Ili, Ili, lama sabakatani,” kaase̱ e̱ kaapo̱ fe̱yɛ, “O Wuribware̱, O Wuribware̱, nte̱tɔ se̱ ne̱ fo̱ a kine mo̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ne̱ bamo̱ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ mo̱ŋ nu mò̱ ase̱ŋ‑ɔ kaase̱, ne̱ bo̱ko̱ yɛ, “Mo̱nꞌ nu, Wuribware̱ kyaamɛɛ Iliya, ne̱ ɔ te̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ne̱ bamo̱‑rɔ ɔko̱ a ŋwɛɛnaŋ ya ba ikyikyee bo̱ da nta‑rɔ, ne̱ ɔɔ taa bo̱ kye̱na kayii si. Ne̱ oo teyi bo̱ waa Yeesuu kanɔ‑rɔ na ɔ nya kyo̱kywe̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bamo̱ ne̱ baa saŋ‑ɔ yɛ, “Yɔwe̱. Mo̱nꞌ sa a ane̱ ye̱re̱ na ane̱ ke̱e̱ fe̱yɛ Iliya e̱ ba a ɔ bo̱ mo̱rɔwe̱ mò̱ aaa.” ");
INSERT INTO ncuNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Mfe̱ŋ ne̱ Yeesuu a faa‑rɔ keŋkeŋ, ne̱ oo kii E̱bware̱ lee. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Puri amo̱‑rɔ ne̱ waagya ne̱ baa bo̱ kuŋ Wuribware̱ suŋkpa a do̱dɔ‑rɔ a ke̱kyaŋ‑ɔ a kyaŋ‑nɔ le̱e̱ so̱so̱ ya bo̱ da kaase̱. Ne̱ swe̱e̱re̱ a le̱ŋkpaŋ, ne̱ afo̱re̱ a bweebwee‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ne̱ agye̱raŋta ko̱ a gyɛɛ buŋŋi si, ne̱ Wuribware̱ ase̱sɛ timaa ne̱ baa wu‑o bwe̱e̱tɔ a kyiŋŋi le̱e̱ lowi‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yeesuu a kyiŋŋi le̱e̱ lowi‑ro‑o amo̱ kamɛɛ‑rɔ‑ɔ, ne̱ ase̱sɛ amo̱ a le̱e̱ bamo̱ agye̱raŋta‑ɔ‑rɔ lwee Yɛro̱salɛm maŋ‑nɔ, mfe̱ŋ ne̱ ase̱sɛ bwe̱e̱tɔ a ŋu bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Saŋ ne̱ soogyaa ɔbre̱sɛ na mò̱ asoogyaa awuye ne̱ ba de̱e̱re̱ Yeesuu si‑o a ŋu swe̱e̱re̱ ke̱le̱ŋkpaŋ‑ɔ na ke̱tɔ ke̱maa ne̱ kaa ba‑ɔ, ne̱ kufu a nya bamo̱ bwe̱e̱tɔ. Ne̱ bo̱ yɛ, “Ɔnyare̱ mɔ gye̱ Wuribware̱ mò̱ gyi ne̱e̱ kase̱ŋtiŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Amɔ saŋ amo̱ akye̱e̱ bwe̱e̱tɔ mɔ ye̱re̱ ke̱fɔ ba de̱e̱re̱ ba kyo̱ŋwe̱. Bamo̱ ne̱ baa gya Yeesuu si le̱e̱ Galile̱ya swe̱e̱re̱ se̱ yɔ Yɛro̱salɛm mfe̱ŋ‑ɔ gye̱ bamo̱ ne̱ bo̱ dɛɛ ba de̱e̱re̱ mò̱ se̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Akye̱e̱ amo̱ bo̱ko̱ e̱ gye̱ Mariya Magadalanyi, na Mariya ne̱ ɔ gye̱ Yakubu na Yo̱sɛf bamo̱ nyi‑o, na Sibidii agyi nyaŋsɛ anyɔ‑ɔ bamo̱ nyi. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Amɔ atɔ wuye ko̱ bo̱‑rɔ ne̱ ba te̱e̱ mò̱ ɛ Yo̱sɛf, ne̱ ɔɔ le̱e̱ Arimate̱ya maŋ‑nɔ‑ɔ. Mò̱‑ɔ mò̱ a bo̱ kii Yeesuu agyase̱po̱‑ɔ ɔko̱ saŋ ko̱. Ke̱de̱e̱pwɛta a fo̱‑ɔ, ne̱ ɔɔ yɔ Gominaa Pilat ase̱ ya ko̱re̱ mò̱ fe̱yɛ ɔ taa Yeesuu kifuniŋ sa mò̱ a ɔ yaa pure. Ne̱ gominaa‑o a sa mò̱ kpa. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ne̱ Yo̱sɛf a ya maye̱ Yeesuu kifuniŋ‑o le̱e̱ kiyii kpare̱-abɛɛ‑rɔ‑ɔ se̱. Ne̱ ɔɔ ba kyefuri po̱pwɛɛ bo̱ miri mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ne̱ ɔɔ taa mò̱ waa ke̱gye̱raŋta‑rɔ. Ke̱gye̱raŋta amo̱ ɔɔ kyɔ ŋeri ke̱fo̱re̱ ko̱ lee bɔ fe̱yɛ ke̱kyaŋ‑ɔ sa mò̱ e̱ye̱e̱, na mò̱ ya wu na bo̱ pure mò̱ mfe̱ŋ. Mò̱ a taa kifuniŋ‑o bo̱ waa‑rɔ‑ɔ, ne̱ oo kuroŋ ke̱fo̱re̱ dabe̱ ko̱ bo̱ kpuse tii ke̱gye̱raŋta‑ɔ kanɔ fe̱yɛ po̱ne̱‑ɔ. Ne̱ ɔɔ nare̱ o yii. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mò̱ a waa amo̱‑ɔ pɛɛɛ‑ɔ, na Mariya Magadalanyi na Mariya ko̱‑ɔ te na bamo̱ akatɔ ko̱re̱ ke̱gye̱raŋta‑ɔ se̱ ba de̱e̱re̱ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Amo̱ pɛɛɛ a waa Ifiyara, kake ne̱ baa waa Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese‑o siraa‑o. Ke̱mo̱ kaye̱ ŋke‑o, ne̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na Farisii awuye‑o bo̱ko̱ a yɔ gominaa‑o ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ne̱ bo̱ yɛ, “Ɔbre̱sɛ, ane̱ a nyiŋŋi si fe̱yɛ, saŋ ne̱ ɔpe̱nnapo̱ Yeesuu te‑o, ɔɔ tɔwe̱ fe̱yɛ, mò̱ lowi kamɛɛ, amo̱ ya fo̱ ŋke nsa‑ɔ, o kyiŋŋi a ɔ ba ŋkpa‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Amo̱se̱‑ɔ ane̱ e̱ ko̱re̱ fo̱ ne̱e̱ fe̱yɛ fo̱ sa kanɔ na bo̱ de̱e̱re̱ mò̱ ke̱gye̱raŋta‑ɔ se̱ bo̱ fo̱ ŋke nsa. N gye̱ ane̱ŋ, ane̱ se̱re̱ kufu, ne̱ mò̱ agyase̱po̱‑ɔ e̱ yɔ a bo̱ ya ywii mò̱ kifuniŋ‑o taa yaa bo̱ kwe̱e̱rɔ, na ŋkee bo̱ tɔwe̱ gywii lamaŋ fe̱yɛ Wuribware̱ a kyiŋŋi mò̱ le̱e̱ lowi‑ro. Amo̱ ya ba ane̱ŋ, kaye̱ba lalalo̱we̱ mɔ e̱ kyo̱ŋ ke̱gye̱ŋkpɛɛ lee‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ne̱ gominaa‑o a be̱ŋŋaa bamo̱ fe̱yɛ, “Mo̱ne̱ de kpa fe̱yɛ mo̱nꞌ lee asoogyaa awuye na mo̱nꞌ sa a bo̱ ya de̱e̱re̱ ke̱gye̱raŋta‑ɔ se̱ nɛɛnɛɛ ane̱ŋ ne̱ mo̱ne̱ e̱ taare̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ne̱ baa taa asoogyaa awuye ko̱ yaa ke̱gye̱raŋta‑ɔ ase̱. Ne̱ baa kye̱ra ke̱fo̱re̱ dabe̱ ne̱ ki i tii ke̱gye̱raŋta‑ɔ kanɔ e̱kɛɛkɛɛ se̱, na ɔko̱ ma nya kuroŋ ke̱fo̱re̱‑ɔ le̱e̱ ke̱gye̱raŋta‑ɔ kanɔ se̱. Ne̱ baa yɔwe̱ asoogyaa awuye‑o wo̱re̱ fe̱yɛ bo̱ de̱e̱re̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Me̱me̱ne̱da, kake ne̱ Yudaa awuye‑o i kyure, ne̱ bo̱ maa waa kusuŋ ke̱maa‑ɔ a kyo̱ŋ‑ɔ, ne̱ Kosiyara gye̱gyaye̱ kese‑ro Mariya Magadalanyi na Mariya ko̱‑ɔ a yɔ a bo̱ ya de̱e̱re̱ ke̱gye̱raŋta‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Bamo̱ a yɔ ba tɔ‑rɔ‑ɔ, kaluwa ko̱ŋko̱ ne̱ swe̱e̱re̱ a le̱ŋkpaŋ bwe̱e̱tɔ. Ne̱ Wuribware̱ kabɔɔ ko̱ a le̱e̱ so̱so̱ ba swe̱e̱re̱ ke̱gye̱raŋta‑ɔ ase̱. Ne̱ oo kuroŋ ke̱fo̱re̱ dabe̱‑ɔ le̱e̱ ke̱mo̱ kanɔ se̱, ne̱ ɔɔ kye̱na se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ɔ to̱re̱ se̱ ne̱e̱ fe̱yɛ e̱lɛɛlɛɛ‑ɔ, ne̱ mò̱ atɔ buŋsɛ a fwiiri pare̱pare̱pare̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ne̱ asoogyaa awuye ne̱ ba de̱e̱re̱ ke̱gye̱raŋta‑ɔ se̱‑ɔ, kufu a nya bamo̱ bwe̱e̱tɔ. Ne̱ baa yo̱ŋ, ne̱ baa le̱e̱ le̱e̱ daye̱ bo̱ da fe̱yɛ bamo̱ a wu‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ne̱ Wuribware̱ kabɔɔ‑ɔ a sa se̱ŋsa gywii akye̱e̱‑ɔ. Ɔ yɛ, “Mo̱ne̱ ma sa a kufu nya mo̱ne̱. Ŋ nyi fe̱yɛ mo̱ne̱ i buwi mo̱ne̱ e̱ kpa Yeesuu ne̱ baa da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ‑ɔ se̱‑ɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ɔ mo̱ŋ bo̱ mfe̱e̱, ɔɔ dare̱e̱, a le̱e̱ fe̱yɛ Wuribware̱ a kyiŋŋi mò̱ le̱e̱ lowi‑ro, fe̱yɛ ane̱ŋ ne̱ ɔɔ kyɔ tɔwe̱ fe̱yɛ Wuribware̱ e̱ waa‑ɔ. Mo̱nꞌ bo̱ ke̱e̱ mfe̱ŋ ne̱ oo di‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Amo̱se̱‑ɔ, mbe̱yɔmɔ, mo̱nꞌ nare̱ me̱naŋ me̱naŋ ya tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ Wuribware̱ a kyiŋŋi mò̱ le̱e̱ lowi‑ro, ne̱ mbe̱yɔmɔ ɔ gye̱ bamo̱ ŋkpɛɛ o yii Galile̱ya swe̱e̱re̱ se̱. Mfe̱ŋ‑ɔ ba ŋu mò̱. Mo̱ ase̱ŋ a lo̱we̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Bamo̱ a nu mò̱ ase̱ŋ‑ɔ, ne̱ aa waa bamo̱ kɔne̱ bwe̱e̱tɔ. Ne̱ baa le̱e̱ mfe̱ŋ na kufu saŋ ki de bamo̱, ne̱ baa le̱e̱ ba ŋwɛɛnaŋ na bo̱ ya tɔwe̱ amo̱ ase̱ŋ gywii Yeesuu agyase̱po̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Bo̱ bo̱ sa se̱‑ɔ Yeesuu fɔŋfɔŋ a te̱ŋ bamo̱ kpa, ne̱ ɔɔ ka bamo̱ kanɔ. Bamo̱ a de̱ŋ pini mò̱ mfe̱ŋ‑ɔ, ne̱ baa yɔ ya kpuni aŋurii kra mò̱ ayaapapaa‑rɔ, ne̱ baa suŋ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ne̱ ma sa a kufu nya mo̱ne̱. Mo̱nꞌ kya mo̱ne̱ kpa se̱ yɔ mo̱ ko̱we̱bɛɛ‑ana amo̱ ase̱ ya tɔwe̱ gywii bamo̱ fe̱yɛ bo̱ yɔ Galile̱ya swe̱e̱re̱ se̱. Mfe̱ŋ ne̱ ba ŋu mo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Akye̱e̱ amo̱ a kiŋŋi ba yɔ maŋ‑nɔ‑ɔ, ne̱ asoogyaa awuye ne̱ ba de̱e̱re̱ ke̱gye̱raŋta‑ɔ se̱‑ɔ bo̱ko̱ a yɔ maŋ‑nɔ ya tɔwe̱ ke̱tɔ ke̱maa ne̱ kaa ba‑ɔ gywii Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Alɔŋŋɔpo̱ abre̱sɛ amo̱ a nu bamo̱ ase̱ŋ‑ɔ, ne̱ bamo̱ aa maŋ abre̱sɛ‑ɔ a gyaŋŋe̱, ne̱ baa fa amo̱ mfɛɛre̱. Aŋurose̱ŋ ne̱ ŋkee baa kra‑ɔ e̱ gye̱ fe̱yɛ ba ba atanne̱ bwe̱e̱tɔ a bo̱ bo̱ sa asoogyaa awuye amo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ne̱ baa tɔwe̱ gywii bamo̱ fe̱yɛ, “Ke̱tɔ ne̱ mo̱nꞌ tɔwe̱‑ɔ e̱ gye̱ fe̱yɛ Yeesuu agyase̱po̱‑ɔ ya bo̱ ywii mò̱ kifuniŋ taa nare̱ kanye na mo̱ne̱ a di idi. ");
INSERT INTO ncuNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ne̱ gominaa‑o ya nu amo̱‑ɔ se̱, ane̱ fɔŋfɔŋ ane̱ e̱ po̱pɔre̱ mò̱ na ɔ ma taa mo̱ne̱ ke̱bɔye̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ne̱ asoogyaa awuye‑o a kɔɔre̱ atanne̱‑ɔ, ne̱ baa waa ane̱ŋ ne̱ baa tɔwe̱ gywii bamo̱‑ɔ. Amo̱se̱ se̱‑ɔ, ane̱ŋ a kaye̱ba mɔ a saŋŋe̱‑rɔ Yudaa awuye‑ro ya bo̱ fo̱ ndɔɔ a kake mɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ke̱tɔ a waa kafwe̱e̱‑ɔ, ne̱ Yeesuu agyase̱po̱ kudu kako̱‑ɔ a yɔ Galile̱ya swe̱e̱re̱ se̱. Ne̱ baa yɔ ke̱be̱e̱ ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ bo̱ yɔ‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ne̱ baa ŋu mò̱ mfe̱ŋ, ne̱ baa kpuni aŋurii suŋ mò̱. Amo̱‑ɔ pɛɛɛ gbaa bamo̱‑rɔ bo̱ko̱ mo̱ŋ taare̱ kɔɔre̱ gyi fe̱yɛ mò̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ne̱ Yeesuu a sɔŋ tɔ bamo̱‑rɔ, ne̱ ɔ yɛ, “Mo̱nꞌ lɔŋ e̱se̱bɔ na mo̱nꞌ nu mo̱ ase̱. Ke̱yaale̱ŋ ne̱ ke̱ bo̱ so̱so̱ na swe̱e̱re̱‑ɔ pɛɛɛ ne̱ Wuribware̱ a taa waa mo̱ ke̱sare̱e̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Amo̱se̱‑ɔ mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ, mo̱nꞌ yɔ kaye̱ mɔ‑rɔ ase̱sɛ pɛɛɛ ase̱ to̱ŋ ke̱maa, na mo̱nꞌ sa a bo̱ waa mo̱ agyase̱po̱, na mo̱nꞌ bɔ bamo̱ asuu, Wuribware̱, n se̱, na mo̱, Wuribware̱ mò̱ gyi‑o, na Wuribware̱ a kufwiiŋe timaa‑o ke̱nyare̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Na mo̱nꞌ kaapo̱ bamo̱ a bo̱ gya ase̱ŋ ke̱maa ne̱ mo̱ a tɔwe̱ gywii mo̱ne̱ fe̱yɛ mo̱nꞌ gya se̱‑ɔ se̱. Na mo̱nꞌ nyiŋŋi si fe̱yɛ mo̱ e̱ kye̱na mo̱ne̱ ase̱ saŋ ke̱maa bo̱ fo̱ kaye̱ kɛɛ.”");
INSERT INTO ncuNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Mfaanɛɛ ne̱ ase̱ŋ timaa ne̱ a le̱e̱ Yeesuu Kristoo, Wuribware̱ mò̱ gyi‑o, kuŋu si‑o du. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","De̱daa‑ɔ Wuribware̱ kyaamɛɛ Isaya a kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ ne̱e̱ fe̱yɛ, “Wuribware̱ yɛ, ‘Mo̱ i suŋ mo̱ kabɔɔ ko̱ a ɔ gye̱ fo̱ ŋkpɛɛ ya lɔŋŋɔ kpa bo̱ ye̱ra fo̱.’ ” Ne̱ Isaya a be̱e̱ tɔwe̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Ɔko̱ e̱ fɛɛ‑rɔ kimukee‑ro fe̱yɛ, ‘Mo̱nꞌ lɔŋŋɔ kpa nɛɛnɛɛ bo̱ be̱ya Wuribware̱. Mo̱nꞌ waa kpa kye̱rarasɛ sa mò̱ a ɔ bo̱rɔ se̱.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","To, ane̱ŋ a ɔnyare̱‑ɔ dɛɛ ɔ bo̱‑rɔ ne̱ ba te̱e̱ mò̱ ɛ Yohanee ne̱ ɔɔ yɔ kimukee‑ro ɔ tɔwe̱ Wuribware̱ ase̱ŋ o gywii ase̱sɛ ne̱ ba bo̱rɔ mfe̱ŋ‑ɔ, na ɔ bɔ bamo̱ asuu. Ase̱ŋ ne̱ ɔɔ tɔwe̱‑ɔ e̱ gye̱ fe̱yɛ, “Mo̱nꞌ nu mo̱ne̱ e̱ye̱e̱, na mo̱nꞌ kiŋŋi le̱e̱ mo̱ne̱ e̱bɔye̱‑rɔ, na Wuribware̱ nya taa mo̱ne̱ e̱bɔye̱ bo̱ ke mo̱ne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ne̱ ase̱sɛ biribiri a le̱e̱ Yude̱ya swe̱e̱re̱ pɛɛɛ se̱ na Yɛro̱salɛm maŋ‑nɔ pɛɛɛ bo̱ nu Yohanee ase̱ŋ. Bamo̱ a nu mò̱ ase̱ŋ‑ɔ, ne̱ baa nu bamo̱ e̱ye̱e̱, ne̱ baa tɔwe̱ bamo̱ e̱bɔye̱ gywii mò̱, ne̱ ɔɔ bɔ bamo̱ asuu Yo̱o̱daŋ bo̱ŋ‑nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nyɔma ifwii ne̱ baa bo̱ waa Yohanee atɔ buŋsɛ, ne̱ kabo̱ wo̱re̱ ke̱re̱se̱sɛ da mò̱ laare̱‑rɔ. Mò̱ ateese e̱ gye̱ akyaŋkyaŋka na gyabwe̱e̱kyu. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yohanee ase̱ŋ ne̱ ɔɔ tɔwe̱ gywii ase̱sɛ‑ɔ e̱ gye̱ fe̱yɛ, “Ɔko̱ saŋ ɔ ba na ɔ kyɔ mo̱, ne̱ mo̱ŋ fo̱ fe̱yɛ m buŋŋe lee mò̱ ase̱be̱ta gbaa na m fwe̱e̱ mò̱ ayaapapaa se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nkyu ne̱ n de mo̱ e̱ bɔ mo̱ne̱ asuu, amaa mò̱ fe̱raa, ɔ sa a Wuribware̱ a kufwiiŋe timaa‑o ywe̱e̱ mo̱ne̱ se̱. Na mo̱nꞌ nya ke̱yaale̱ŋ fe̱yɛ de̱e̱kpa‑ɔ. Na ɔ ba Wuribware̱ a kufwiiŋe timaa‑o bo̱ gyee mo̱ne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ke̱tɔ mo̱ŋ kyee, ne̱ Yeesuu a le̱e̱ Nasarɛt maŋ ko̱ ne̱ ɔ bo̱ Galile̱ya swe̱e̱re̱ se̱‑ɔ‑rɔ ba Yohanee ase̱. Ne̱ Yohanee a bɔ mò̱ asuu Yo̱o̱daŋ bo̱ŋ‑nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yeesuu a de̱ŋ le̱e̱ nkyu‑o‑ro‑o, ne̱ oo ŋu awo̱re̱‑rɔ a buŋŋi‑ro. Ne̱ oo ŋu Wuribware̱ a kufwiiŋe timaa‑o a le̱e̱ so̱so̱ mfe̱ŋ bo̱ ywe̱e̱ mò̱ se̱ fe̱yɛ kuwurele̱pɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ne̱ bo̱re̱ ko̱ a le̱e̱ Wuribware̱ se̱ tɔwe̱ fe̱yɛ, “Fo̱ e̱ gye̱ mo̱ gyi timaa ne̱ mo̱ e̱ kpa fo̱ ase̱ŋ bwe̱e̱tɔ‑ɔ, ne̱ mo̱ akatɔ a gyi fo̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Amo̱‑ɔ kamɛɛ‑rɔ, ne̱ Wuribware̱ a kufwiiŋe timaa‑o a yaa Yeesuu kimukee‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ne̱ Yeesuu a gyi ŋke aduna kimukee‑o‑ro. Amɔ e̱fa‑rɔ mbo̱ bo̱ kimukee‑o‑ro mfe̱ŋ. Ɔ bo̱ mfe̱ŋ, ne̱ Ɔbɔnsam a bo̱ kyɔ mò̱‑rɔ ke̱e̱ fe̱yɛ ɔ nya mò̱ bo̱ waa e̱bɔye̱‑rɔ aaa. Ne̱ Wuribware̱ a suŋ mò̱ mbɔɔ ko̱, ne̱ baa bo̱ kya Yeesuu‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","A mo̱ŋ kyee, ne̱ Hɛrɔd ne̱ ɔ gye̱ Galile̱ya swe̱e̱re̱ se̱ a owure‑o a tii Yohanee. Amo̱se̱ se̱‑ɔ ne̱ Yeesuu a yɔ Galile̱ya ɔ tɔwe̱ ase̱ŋ timaa fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Saŋ a fo̱. Wuribware̱ a kuwure‑o e̱ kpa a ke̱ ba. Amo̱se̱ se̱‑ɔ ɔke̱maa nu mò̱ e̱ye̱e̱, na o kiŋŋi le̱e̱ mò̱ e̱bɔye̱‑rɔ, na ɔ kɔɔre̱ Wuribware̱ ase̱ŋ timaa‑o gyi.” ");
INSERT INTO ncuNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ne̱ Yeesuu a bo̱rɔ Galile̱ya ke̱pare̱ dabe̱ a ke̱be̱gya‑ɔ. Mò̱ a naa nkyu‑o e̱kɛɛkɛɛ se̱‑ɔ, ne̱ oo ŋu ŋkiŋgyi akrapo̱ anyɔ ko̱ ne̱ ba te̱e̱ bamo̱ ɛ Simɔŋ na mò̱ tire Andruu‑o, na ba twe̱e̱ kisawu ba kra ŋkiŋgyi. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱nꞌ ba a ane̱ yɔ. Mo̱ne̱ maa lɛɛ kra ŋkiŋgyi. Amaa mo̱ e̱ kaapo̱ mo̱ne̱ ase̱sɛ kibuwi kpa, na mo̱nꞌ baa bamo̱ mo̱ ase̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Mò̱ a de̱ŋ tɔwe̱ ane̱ŋ‑ɔ, ne̱ baa yɔwe̱ bamo̱ asawu‑o bo̱ be̱ya, ne̱ baa gya Yeesuu si bo̱ yii. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yeesuu a yɔ akatɔ se̱ kafwe̱e̱‑ɔ, ne̱ ɔɔ be̱e̱ ŋu Sibidii mò̱ gyi‑ana ne̱ ba te̱e̱ bamo̱ ɛ Yakubu na Yohanee‑o, na bo̱ te bamo̱ ko̱re̱e̱‑rɔ ba waa bamo̱ asawu siraa. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yeesuu a de̱ŋ ŋu bamo̱‑ɔ, ne̱ ɔɔ te̱e̱ bamo̱. Ne̱ baa yɔwe̱ bamo̱ se̱ na bamo̱ ne̱ baa suŋ ko̱re̱e̱‑ɔ‑rɔ‑ɔ, ne̱ baa gya Yeesuu si bo̱ yii. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ a ba Kapaaniyum maŋ‑nɔ. Kukyure kake a fo̱‑ɔ, ne̱ ɔɔ yɔ ke̱bware̱ko̱re̱kyaŋ‑nɔ mfe̱ŋ ya kaapo̱ abware̱se̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ne̱ ase̱sɛ ne̱ baa nu ane̱ŋ ne̱ ɔɔ kaapo̱‑ɔ e̱ye̱e̱ a kpe̱ŋ bamo̱, a le̱e̱ fe̱yɛ mò̱ ke̱kaapo̱‑ɔ kwe̱e̱ Wuribware̱ mbraa a akaapo̱po̱‑ɔ lee‑ro. Ɔɔ kaapo̱ ne̱e̱ fe̱yɛ mò̱ a gye̱ mbraa ɔsapo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Yeesuu a maa se̱ ɔ kaapo̱ ke̱bware̱ko̱re̱kyaŋ‑ɔ‑rɔ‑ɔ, ne̱ ɔnyare̱ ko̱ ne̱ ibrisi ko̱ te mò̱ se̱‑ɔ a ba bo̱ faa‑rɔ keŋkeŋ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Aa! Yeesuu Nasarɛte̱nyi, nte̱tɔ ne̱ fo̱ e̱ kpa ane̱ ase̱ mfe̱e̱? Fo̱ a ba a fo̱ bo̱ mɔɔ ane̱ ne̱e̱ e̱e̱e̱? Ŋ nyi fe̱yɛ fo̱ e̱ gye̱ ke̱yaafɔre̱ timaa ne̱ Wuribware̱ a lee suŋ bo̱ kyo̱ŋwe̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Mfe̱ŋ ne̱ Yeesuu a faa ibrisi amo̱ se̱ ɛ, “Laatɔ, na fo̱ ko̱so̱ ɔnyare̱ amo̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Yeesuu a faa ibrisi amo̱ se̱‑ɔ, ne̱ ibrisi‑o a le̱ŋkpaŋ ɔnyare̱‑ɔ‑rɔ keŋkeŋ, ne̱ ɔɔ faa‑rɔ. Ne̱ ibrisi amo̱ a ko̱so̱ mò̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ne̱ e̱ye̱e̱ a kpe̱ŋ bamo̱ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ pɛɛɛ, ne̱ baa bise abɛɛ fe̱yɛ, “Nte̱tɔ ase̱ŋ ne̱e̱? N gye̱ se̱ŋpwɛɛ ne̱ ɔ kaapo̱‑ɔ ɔɔɔ? O de ibrisi pɛɛɛ mɔ se̱ ke̱yaale̱ŋ, hare̱e̱ mò̱ ya tɔwe̱ ase̱ŋ, ii bu mò̱ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mfaanɛɛ se̱‑ɔ Yeesuu ase̱ŋ a saŋŋe̱‑rɔ me̱naŋ Galile̱ya swe̱e̱re̱ pɛɛɛ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ne̱ Yeesuu na Yakubu na Yohanee na mò̱ agyase̱po̱ ne̱ bo̱ tii si‑o pɛɛɛ a le̱e̱ ke̱bware̱ko̱re̱kyaŋ‑ɔ‑rɔ, ne̱ baa lwee Simɔŋ na Andruu lɔŋ‑nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saŋ amo̱‑ɔ, Simɔŋ mò̱ saa kye̱e̱sɛ mɔ e̱ lɔ fekyu ɔ da lɔŋ‑ɔ‑rɔ mfe̱ŋ. Amo̱se̱ se̱‑ɔ Yeesuu a fo̱ lɔŋ‑ɔ‑rɔ‑ɔ, ne̱ baa tɔwe̱ ɔkye̱e̱ amo̱ a ko̱lɔ‑ɔ ase̱ŋ gywii mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ne̱ ɔɔ yɔ ɔkye̱e̱ amo̱ ase̱ ya kra mò̱ ke̱sare̱e̱‑rɔ bo̱ kyuwi‑ro, ne̱ puri amo̱‑rɔ ɔkye̱e̱‑ɔ a kpaare̱. Ne̱ ɔɔ ko̱so̱ waa ateese sa bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Saŋ ne̱ kyɔwe̱ a twɛɛ‑ɔ, ne̱ baa taa maŋ‑ɔ‑rɔ alɔpo̱ pɛɛɛ na bamo̱ ne̱ ibrisi te bamo̱ se̱‑ɔ baa Yeesuu ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ne̱ maŋ‑ɔ‑rɔ ase̱sɛ pɛɛɛ mɔ a bo̱ gyaŋŋe̱ Simɔŋ na Andruu a lɔŋ‑ɔ akatɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ne̱ Yeesuu a kya alɔpo̱ ne̱ ba lɔ alɔgyi bwe̱e̱tɔ‑ɔ. Ne̱ ɔɔ gya ibrisi bo̱ ko̱so̱ bamo̱ ne̱ i te te bamo̱ se̱‑ɔ se̱. Amaa ɔ mo̱ŋ sa a ibrisi‑o sa se̱ŋsa, a le̱e̱ fe̱yɛ i nyi se̱sɛ ne̱ Yeesuu gye̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ke̱mo̱ kaye̱ ŋke gye̱gyaye̱ kese‑ro‑o, ne̱ Yeesuu a ko̱so̱ le̱e̱ lɔŋ‑ɔ‑rɔ le̱e̱ maŋ‑ɔ‑rɔ yɔ mfe̱ŋ ne̱ ɔko̱ mo̱ŋ bo̱‑rɔ ne̱ a du diŋŋ‑o, ne̱ ɔɔ ya ko̱re̱ ke̱bware̱ko̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Yeesuu bo̱ mfe̱ŋ na Simɔŋ mò̱ aa mò̱ anare̱bɛɛpo̱ naa ba buwi ba kpa mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Saŋ ne̱ baa buwi ŋu mò̱‑ɔ, ne̱ baa tɔwe̱ gywii mò̱ fe̱yɛ, “Ɔke̱maa gye̱ ne̱ o buwi ɔ kpa fo̱ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Amaa Yeesuu a be̱ŋŋaa bamo̱ ne̱e̱ ɛ, “A tiri fe̱yɛ ane̱ yɔ e̱maŋ ne̱ e̱ bo̱ mfe̱e̱‑ɔ pɛɛɛ‑rɔ, na ŋ ya tɔwe̱ abware̱se̱ŋ gywii bamo̱ gbaa bamo̱, a le̱e̱ fe̱yɛ amo̱ se̱ ne̱ mo̱ a ba.” ");
INSERT INTO ncuNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Amo̱se̱ se̱‑ɔ Yeesuu a nare̱ Galile̱ya swe̱e̱re̱‑ɔ pɛɛɛ se̱ ɔ tɔwe̱ abware̱se̱ŋ ke̱bware̱ko̱re̱ akyaŋ‑nɔ, na ɔ gya ibrisi ɔ ko̱so̱ ase̱sɛ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Saŋ ko̱, ne̱ bwatɔpo̱ ko̱ a bo̱ kpuni aŋurii ko̱re̱ Yeesuu fe̱yɛ ɔ kya mò̱‑rɔ. Ke̱tɔ ne̱ bwatɔpo̱ amo̱ a tɔwe̱ gywii Yeesuu‑o e̱ gye̱ fe̱yɛ, “Fo̱ e̱ kpa, fo̱ e̱ taare̱ a fo̱ kya mo̱ ko̱lɔ mɔ na ŋ nya lwee ase̱sɛ‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ne̱ Yeesuu a ŋu mò̱ e̱wɛɛ, ne̱ ɔɔ be̱ŋŋaa mò̱ fe̱yɛ, “Mo̱ e̱ kpa.” Ne̱ ɔɔ ba ke̱sare̱e̱ bo̱ dɔŋŋɔ ɔlɔpo̱‑ɔ se̱, ne̱ ɔ yɛ, “Mbe̱yɔmɔ fo̱ e̱ taare̱ a fo̱ lwee ase̱sɛ‑rɔ, a le̱e̱ fe̱yɛ fo̱ a kpaare̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mfe̱ŋ dɛɛ ne̱ ɔnyare̱ amo̱ a ke̱bwatɔ‑ɔ a lo̱we̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Kamɛɛ‑rɔ ne̱ Yeesuu a yii ɔnyare̱‑ɔ se̱ fe̱yɛ, “De̱ŋ bo̱rɔ kpa kyɛye̱ se̱ yɔ Wuribware̱ alɔŋŋɔpo̱‑ɔ ɔko̱ ase̱, na ɔ de̱e̱re̱ fo̱ na a kaapo̱ ɔke̱maa fe̱yɛ fo̱ a kpaare̱, na fo̱ bɔ alɔŋŋɔtɔ ne̱ ane̱ ɔde̱daapo̱ Mosis a tɔwe̱ ɛ mò̱ ne̱ ɔɔ lɔ ko̱lɔ mɔ ne̱ ɔɔ kpaare̱‑ɔ bɔ, na ɔke̱maa ŋu fe̱yɛ ane̱ŋ a ko̱lɔ‑ɔ mo̱ŋ lɛɛ ki te mò̱ se̱‑ɔ. Fo̱ a maa se̱ fo̱ e̱ yɔ fo̱ bo̱ kpa‑rɔ‑ɔ, fo̱ ma kaŋ ye̱re̱ tɔwe̱ ke̱tɔ ne̱ mo̱ a waa sa fo̱‑ɔ gywii ɔko̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Amaa ɔnyare̱ amo̱ a le̱e̱ mfe̱ŋ‑ɔ, ɔ naa ɔ tɔwe̱ ane̱ŋ ne̱ Yeesuu a kya mò̱‑ɔ ɔ kaa ne̱e̱. Ɔɔ tɔwe̱ amo̱ ase̱ŋ bwe̱e̱tɔ, hare̱e̱ gbaa Yeesuu mo̱ŋ lɛɛ taare̱ le̱e̱ gye̱maŋ‑nɔ. Ane̱ŋ se̱‑ɔ ne̱ ɔ naa o te mfe̱ŋ ne̱ a du diŋŋ‑o, ne̱ ŋkee ase̱sɛ e̱ le̱e̱ to̱ŋ ke̱maa bo̱ naa ba de̱e̱re̱ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Amo̱ a waa ŋke ŋnyɔ ko̱‑ɔ, Yeesuu a kiŋŋi yɔ Kapaaniyum maŋ‑nɔ mfe̱ŋ ne̱ o te‑o, ne̱ ɔke̱maa a kyɔ nu mò̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Amo̱se̱‑ɔ ase̱sɛ a bo̱ bo̱rɔ mò̱ lɔŋ‑ɔ gya, hare̱e̱ kpa mo̱ŋ lɛɛ ɔ bo̱ kibunogyi‑ro gbaa pɛɛɛ. Ase̱sɛ‑ɔ bwe̱e̱tɔ a ba na bo̱ bo̱ nu ane̱ŋ ne̱ Yeesuu e̱ tɔwe̱ abware̱se̱ŋ‑ɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Saŋ amo̱ abɛɛ ana ko̱ mɔ a so̱rɔ ke̱gyabɔɔ ko̱ baa Yeesuu ase̱ a ɔ kya mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ase̱sɛ a bo̱rɔ lɔŋ‑ɔ se̱‑ɔ, bo̱ mo̱ŋ nya kpa baa ke̱gyabɔɔ‑ɔ bo̱ bo̱rɔ kibunogyi‑o‑ro yɔ mfe̱ŋ ne̱ Yeesuu bo̱‑ɔ. Bamo̱ a tɛɛ ke̱kyaŋ ne̱ Yeesuu bo̱ ke̱mo̱‑rɔ so̱so̱‑ɔ se̱‑ɔ, ke̱tɔ ne̱ baa waa‑ɔ e̱ gye̱ fe̱yɛ baa de̱e̱ ne̱e̱, tuwi bɔ ke̱mo̱ so̱so̱. Ne̱ baa taa ke̱gyabɔɔ‑ɔ bo̱ dɔŋŋɔ mò̱ kraŋ se̱ ba ife bo̱ da‑rɔ, ne̱ baa kra ife‑o‑ro yɔwe̱ mò̱‑rɔ kafwe̱e̱ kafwe̱e̱ bo̱ kyo̱ŋwe̱ ke̱kyaŋ‑ɔ‑rɔ yaa bo̱ be̱ya Yeesuu akatɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ane̱ŋ ne̱ baa pee akatɔ baa ke̱gyabɔɔ‑ɔ se̱‑ɔ, Yeesuu a ŋu fe̱yɛ baa kɔɔre̱ mò̱ gyi bwe̱e̱tɔ. Amo̱se̱‑ɔ ne̱ ɔɔ tɔwe̱ gywii ke̱gyabɔɔ‑ɔ fe̱yɛ, “Mo̱ nyare̱, mo̱ a taa fo̱ e̱bɔye̱‑ɔ bo̱ ke fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Yeesuu a tɔwe̱ ane̱ŋ‑ɔ, ne̱ Wuribware̱ mbraa akaapo̱po̱ ne̱ bo̱ te mfe̱ŋ‑ɔ i ŋwiini ba gywii abɛɛ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ne̱e̱ Wuribware̱ wo̱re̱ e̱ gye̱ ne̱ ɔ taare̱ a ɔ taa e̱bɔye̱ bo̱ ke ase̱sɛ ɛ? Ne̱ e̱me̱ne̱ se̱ ne̱ ɔ sa se̱ŋsa ane̱ŋ fe̱yɛ mò̱ a gye̱ Wuribware̱‑ɔ ne̱e̱? Ɔnyare̱ mɔ a tɔwe̱ abuse̱ŋse̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","9","Amo̱ fe̱raa, Yeesuu a kyɔ pini ke̱tɔ ne̱ Wuribware̱ mbraa akaapo̱po̱ amo̱ e̱ tɔwe̱‑ɔ, ne̱ oo bise bamo̱ fe̱yɛ, “Nte̱tɔ i de mo̱ne̱? Ke̱mo̱‑ɔ ke̱mo̱ e̱ bo̱ tɔwe̱ lɔ, fe̱yɛ mo̱ a tɔwe̱ gywii ke̱gyabɔɔ mɔ fe̱yɛ, ‘Mo̱ a taa fo̱ e̱bɔye̱ bo̱ ke fo̱,’ bɛɛɛ fe̱yɛ mo̱ a tɔwe̱ gywii mò̱ ɛ, ‘Ko̱so̱, taa fo̱ kraŋ a fo̱ nare̱’? ");
INSERT INTO ncuNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","To, mo̱ e̱ kaapo̱ mo̱ne̱ fe̱yɛ mo̱, dimaadi mò̱ gyi‑o, de ke̱yaale̱ŋ swe̱e̱re̱ mɔ se̱ a n taare̱ taa ɔke̱maa e̱bɔye̱ bo̱ ke mò̱.” Ne̱ ɔɔ tɔwe̱ gywii ke̱gyabɔɔ‑ɔ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ke̱e̱ ɛ, ko̱so̱, taa fo̱ kraŋ a fo̱ nare̱ yɔ pe̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Mfe̱ŋ, na ase̱sɛ‑ɔ pɛɛɛ ye̱re̱ ba de̱e̱re̱, ne̱ ke̱gyabɔɔ‑ɔ a ko̱so̱ taa mò̱ kraŋ nare̱ mò̱ ayaa anyɔ se̱ o yii pe̱. Ne̱ ɔke̱maa ne̱ ɔ bo̱ mfe̱ŋ‑ɔ e̱ye̱e̱ a kpe̱ŋ mò̱, ne̱ bo̱ yɛ, “Ane̱ mo̱ŋ tɛɛ ŋu faanɛɛ a atɔ‑ɔ ako̱ daa.” Ne̱ bamo̱ pɛɛɛ a kyo̱rɔ Wuribware̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ne̱ Yeesuu a kiŋŋi yɔ Galile̱ya ke̱pare̱ dabe̱‑ɔ kɛɛ. Ɔ bo̱ mfe̱ŋ, ne̱ ase̱sɛ biribiri a ba mò̱ ase̱, ne̱ ɔɔ kaapo̱ bamo̱ abware̱se̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Mò̱ a kyo̱ŋ ɔ yɔ‑ɔ, ne̱ oo ŋu Alafiyus mò̱ gyi leŋpoo ɔkɔɔre̱po̱ ne̱ ba tee mò̱ ɛ Lewii‑o (ne̱ bo̱ be̱e̱ ba te̱e̱ mò̱ ɛ Matiyo‑o), na o te mò̱ leŋpoo kɔɔre̱kpa. Ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Ko̱so̱ gya mo̱ se̱.” Mfe̱ŋ ne̱ Lewii a ko̱so̱ me̱raa se̱ gya Yeesuu si. ");
INSERT INTO ncuNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kamɛɛ‑rɔ ne̱ Yeesuu a yɔ Lewii aye̱ a ɔ ya gyi ateese, ne̱ leŋpoo akɔɔre̱po̱ bwe̱e̱tɔ na ase̱sɛ ne̱ Farisii awuye e̱ te̱e̱ bamo̱ ɛ e̱bɔye̱ awaapo̱‑ɔ naa bo̱ gya Yeesuu si. Ne̱ bamo̱ bwe̱e̱tɔ a ba bo̱ gyi mò̱ aa mò̱ agyase̱po̱‑ɔ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wuribware̱ mbraa akaapo̱po̱ ne̱ bo̱ gye̱ Farisii awuye‑o a ŋu fe̱yɛ Yeesuu na leŋpoo akɔɔre̱po̱ na bamo̱ ne̱ ba te̱e̱ ɛ e̱bɔye̱ awaapo̱‑ɔ i gyi‑o, ne̱ baa bise Yeesuu agyase̱po̱‑ɔ fe̱yɛ, “Nte̱tɔ se̱ ne̱ Yeesuu a sa ne̱ mò̱ aa ane̱ŋ a ase̱sɛ amo̱ i gyi abɛɛ ase̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yeesuu a nu ase̱ŋ ne̱ baa bise‑o, ne̱ ɔɔ be̱ŋŋaa bamo̱ fe̱yɛ, “Ɔko̱ ne̱ ɔ lɔ‑ɔ ne̱ ba sa kadwii. N gye̱ ɔko̱ ne̱ ɔ bo̱ alaŋfiya‑o. Amo̱se̱‑ɔ, n gye̱ bamo̱ ne̱ bo̱ mo̱ŋ gye̱ e̱bɔye̱ awaapo̱‑ɔ se̱ ne̱ mo̱ a ba, amaa bamo̱ ne̱ bo̱ gye̱ e̱bɔye̱ awaapo̱‑ɔ se̱ ne̱ mo̱ a ba, na m bo̱ tɔwe̱ gywii bamo̱ fe̱yɛ bo̱ nu bamo̱ e̱ye̱e̱ kiŋŋi le̱e̱ bamo̱ e̱bɔye̱‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Saŋ ko̱ ne̱ Yohanee Osuubɔpo̱ a agyase̱po̱‑ɔ na Farisii awuye ko̱ e̱ kra ako̱ŋ, ne̱ ase̱sɛ ko̱ a bo̱ bise Yeesuu fe̱yɛ, “Ntɔ se̱ ne̱ Yohanee Osuubɔpo̱ a agyase̱po̱‑ɔ na Farisii awuye a agyase̱po̱‑ɔ e̱ kra ako̱ŋ, ne̱ fo̱ fe̱raa fo̱ bo̱mo̱‑ɔ maa kra ako̱ŋ?” ");
INSERT INTO ncuNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “Mo̱ne̱ e̱ fa fe̱yɛ saŋ ne̱ ɔko̱ e̱ waare̱e̱‑ɔ, ɔko̱fɔ mò̱ kuri mò̱ nyare̱‑ana e̱ kye̱na ako̱ŋ na ɔ bo̱‑rɔ aaa? Mo̱ŋ kɔɔre̱ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","N du ne̱e̱ fe̱yɛ ɔko̱fɔ mò̱ kuri‑o, ne̱ mo̱ agyase̱po̱‑ɔ mɔ du ne̱e̱ fe̱yɛ ɔko̱fɔ mò̱ kuri mò̱ nyare̱‑ana‑ɔ. Ŋke ŋko̱ e̱ ba ne̱ ba lee mo̱ a bo̱ le̱e̱ bamo̱ ase̱, na ŋkee bo̱ kra ako̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ane̱ŋ dɛɛ ne̱ ɔko̱ maa kyaŋ waagya po̱pwɛɛ na ɔ bo̱ taa waagya de̱daa‑rɔ, a le̱e̱ fe̱yɛ ke̱tɔ maa kyee, na o ŋu fe̱yɛ mfe̱ŋ ne̱ ɔɔ taa‑rɔ‑ɔ e̱kɛɛkɛɛ‑ɔ se̱ i wu, na a tuwi‑ro lee waagya po̱pwɛɛ‑ɔ be̱e̱ waa bɔ dabe̱ na ɔ kyɔ ɔgye̱ŋkpɛɛsɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ane̱ŋ dɛɛ ne̱ mo̱ne̱ nyi fe̱yɛ bo̱ de nta ne̱e̱ ba waa praŋto̱wa ne̱ ba ba kabo̱ wo̱re̱ bo̱ waa‑ɔ‑rɔ. Bo̱ de nta po̱pwɛɛ ba waa praŋto̱wa po̱pwɛɛ‑rɔ. Nta po̱pwɛɛ ya lwee praŋto̱wa de̱daa‑rɔ, nta‑ɔ i fwii, na praŋto̱wa‑ɔ bwee nye̱ra, na nta‑ɔ twiiri we̱e̱. Amo̱se̱ se̱‑ɔ bo̱ de nta po̱pwɛɛ ba waa praŋto̱wa po̱pwɛɛ‑rɔ. Amo̱se̱ se̱‑ɔ mo̱ agyase̱po̱‑ɔ maa kra ako̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kukyure kake ko̱, ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ naa ba kyo̱ŋ abwaye adɔɔ ko̱‑rɔ. Bamo̱ a kyo̱ŋ‑ɔ, ne̱ mò̱ agyase̱po̱‑ɔ a le̱e̱ kaase̱ ba gyɛɛ abwaye ako̱, a le̱e̱ fe̱yɛ ako̱ŋ de bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ne̱ Farisii awuye ko̱ a bise Yeesuu fe̱yɛ, “Ke̱e̱ ɛ, nte̱tɔ se̱ ne̱ ba gyɛɛ abwaye‑o? Bo̱ mo̱ŋ nyi fe̱yɛ ke̱tɔ ne̱ ba waa‑ɔ gye̱ kusuŋ ne̱e̱ e̱e̱e̱? Ne̱ a kye ane̱ Wuribware̱ mbraa fe̱yɛ ɔko̱ a waa kusuŋ ko̱ kukyure kake.” ");
INSERT INTO ncuNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ne̱ Yeesuu mɔ a be̱ŋŋaa bamo̱ fe̱yɛ, “Mo̱ne̱ mo̱ŋ tɛɛ kare̱ abware̱se̱ŋ wo̱re̱‑ɔ ŋu ke̱tɔ ne̱ ane̱ ɔde̱daapo̱ Deefid a waa saŋ ne̱ Abiyatare̱ gye̱ Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ‑ɔ ɔɔɔ? ");
INSERT INTO ncuNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Mo̱ne̱ mo̱ŋ tɛɛ kare̱ fe̱yɛ ako̱ŋ a de Deefid mò̱ aa mò̱ anare̱bɛɛpo̱‑ɔ, oo lwee Wuribware̱ suŋkpa, ne̱ baa sa mò̱ bodobodoo akuri ne̱ baa bo̱ lɔŋŋɔ Wuribware̱‑ɔ, hare̱e̱ ɔɔ saŋ e̱ko̱ sa mò̱ anare̱bɛɛpo̱‑ɔ, na a mo̱ŋ gye̱ mbraa kikye aaa? A le̱e̱ fe̱yɛ ane̱ mbraa yɛ Wuribware̱ alɔŋŋɔpo̱ wo̱re̱ e̱ gye̱ ne̱ bo̱ de kpa fe̱yɛ bo̱ gyi ane̱ŋ a bodobodoo‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ne̱ Yeesuu a tɔwe̱ bo̱ gye̱ kɛɛ fe̱yɛ, “Nyiŋkpasɛ se̱ ne̱ Wuribware̱ a waa kukyure kake‑o, amaa n gye̱ kukyure kake‑o si ne̱ Wuribware̱ a twe̱e̱ nyiŋkpasɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Amo̱se̱‑ɔ mo̱, dimaadi mò̱ gyi‑o, de kukyure kake‑o gbaa e̱le̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Saŋ ko̱ Yeesuu a be̱e̱ yɔ ya lwee ke̱bware̱ko̱re̱kyaŋ ko̱‑rɔ, ne̱ ɔɔ ya to̱ ke̱sare̱e̱ wusɛ wuye ko̱, na Farisii awuye ko̱ bo̱ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Farisii awuye‑o a kpa a bo̱ po̱rɔ Yeesuu si‑o, baa pee akatɔ a bo̱ de̱e̱re̱ ke̱e̱ fe̱yɛ ɔ kya ke̱sare̱e̱ wusɛ wuye‑o kukyure kake amo̱ aaa, a le̱e̱ fe̱yɛ bo̱ maa waa kusuŋ ke̱maa kake amo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ne̱ Yeesuu a tɔwe̱ gywii ke̱sare̱e̱ wusɛ wuye‑o fe̱yɛ, “Ko̱so̱, ba akatɔ‑rɔ mfe̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ne̱ Yeesuu a bise ase̱sɛ ne̱ baa gyaŋŋe̱ mfe̱ŋ‑ɔ fe̱yɛ, “E̱me̱ne̱ ne̱ ane̱ mbraa ne̱ Wuribware̱ a sa ane̱‑ɔ a sa kpa fe̱yɛ ane̱ waa kukyure kake‑o ne̱e̱? Mbraa‑ɔ yɛ ane̱ waa itimaa ne̱e̱ bɛɛɛ e̱bɔye̱ aaa? Ŋ yɛ ane̱ mo̱rɔwe̱ se̱sɛ ne̱e̱ e̱e̱e̱, bɛɛɛ ane̱ mɔɔ se̱sɛ ne̱e̱ e̱e̱e̱? Mo̱nꞌ tɔwe̱ gywii mo̱.” Amaa ɔko̱ mo̱ŋ be̱ŋŋaa mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Amo̱se̱‑ɔ, Yeesuu a de̱e̱re̱ bamo̱ pɛɛɛ‑ɔ, ne̱ mò̱ duŋ a fwii, ne̱ bamo̱ ase̱ŋ a ko̱ŋ be̱e̱ waa mò̱ e̱wɛɛ, a le̱e̱ fe̱yɛ bo̱ mo̱ŋ kpa kunu ane̱ŋ ne̱ ɔ tɔwe̱‑ɔ kaase̱. Ne̱ ŋkee Yeesuu a tɔwe̱ gywii ke̱sare̱e̱ wusɛ wuye‑o fe̱yɛ, “Teyi fo̱ ke̱sare̱e̱‑ɔ‑rɔ.” Mò̱ a teyi‑ro‑o, ne̱ kaa kpaare̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mfaanɛɛ se̱‑ɔ, ne̱ Farisii awuye‑o a le̱e̱ ke̱bware̱ko̱re̱kyaŋ‑nɔ mfe̱ŋ. Ne̱ bamo̱ aa Owure Hɛrɔd aye̱re̱rɔpo̱ ko̱ a gyaŋŋe̱ da Yeesuu kuŋu si kikpuni a bo̱ nya mɔɔ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Amo̱ kamɛɛ‑rɔ, ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ a yɔ Galile̱ya ke̱pare̱ dabe̱‑ɔ kɛɛ, ne̱ ase̱sɛ biribiri a gya mò̱ se̱ yɔ mfe̱ŋ. Bo̱ko̱ a le̱e̱ Galile̱ya swe̱e̱re̱ se̱ na Yude̱ya swe̱e̱re̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Bo̱ko̱ mɔ a le̱e̱ Yɛro̱salɛm maŋ‑nɔ na Idume̱ya swe̱e̱re̱ se̱ na Yo̱o̱daŋ bo̱ŋ kyɔwe̱ le̱e̱kpa a keri‑o si na Tiro na Sidɔŋ ifuri si. Bamo̱ pɛɛɛ a nu ke̱tɔ ne̱ Yeesuu e̱ waa‑ɔ se̱ ne̱e̱, ne̱ baa ba mò̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ane̱ŋ ne̱ ase̱sɛ‑ɔ kyɔ bwe̱e̱tɔ‑ɔ se̱‑ɔ, ne̱ Yeesuu a tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ bo̱ kpa ko̱re̱e̱ waa siraa sa mò̱ a ɔ nya bo̱ kye̱na‑rɔ nkyu kɛɛ tɔwe̱ abware̱se̱ŋ gywii ase̱sɛ‑ɔ. N gye̱ ane̱ŋ, ane̱ŋ ne̱ bo̱ kyɔ‑ɔ se̱‑ɔ, ba buŋ mò̱ se̱ bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ke̱tɔ se̱ ne̱ Yeesuu a waa ane̱ŋ‑ɔ e̱ gye̱ fe̱yɛ ɔɔ kya alɔpo̱ bwe̱e̱tɔ mfe̱ŋ saŋ ko̱. Ŋkee bamo̱ ne̱ ba lɔ‑ɔ pɛɛɛ i neŋŋi ba yɔ akatɔ‑rɔ a bo̱ nya dabo̱rɔ Yeesuu. ");
INSERT INTO ncuNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Saŋ ke̱maa ne̱ ase̱sɛ ne̱ ibrisi te bamo̱ se̱‑ɔ i ŋu mò̱‑ɔ, amɔ ba kpuni aŋurii mò̱ ayaa‑rɔ na bo̱ faa‑rɔ fe̱yɛ, “Wuribware̱ mò̱ gyi‑o e̱ gye̱ fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ne̱ Yeesuu a yii ibrisi ne̱ i te bamo̱ se̱‑ɔ se̱ fe̱yɛ bo̱ ma kaŋ tɔwe̱ gywii ɔko̱ se̱sɛ ne̱ ɔ gye̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Saŋ ko̱, ne̱ Yeesuu a yɔ ke̱be̱e̱ ko̱ se̱, ne̱ ɔɔ te̱e̱ anyare̱ ko̱. Mò̱ a te̱e̱ bamo̱‑ɔ, ne̱ baa ba. ");
INSERT INTO ncuNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Mò̱ a de̱e̱re̱ bamo̱‑rɔ‑ɔ, ne̱ oo lee bamo̱ ne̱ baa pre̱ mò̱‑ɔ kudu anyɔ fe̱yɛ bo̱ waa mò̱ ayaa‑rɔ aye̱re̱po̱. Mfe̱ŋ ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ a lee mo̱ne̱ ne̱e̱ fe̱yɛ mo̱nꞌ ba a ane̱ kye̱na. Amaa m be̱e̱ mo̱ i suŋ mo̱ne̱ a m bo̱ kyo̱ŋwe̱ a mo̱nꞌ nare̱ tɔwe̱ abware̱se̱ŋ, ");
INSERT INTO ncuNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na mo̱nꞌ nya e̱le̱ŋ bo̱ gya ibrisi bo̱ ko̱so̱ ase̱sɛ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Anyare̱ kudu anyɔ ko̱ ne̱ Yeesuu a lee‑o e̱ gye̱ Simɔŋ (ne̱ Yeesuu a be̱e̱ sa mò̱ ke̱ŋasɛnyare̱ fe̱yɛ Peetroo‑o), ");
INSERT INTO ncuNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","na Sibidii mò̱ gyi‑ana ne̱ ba te̱e̱ bamo̱ ɛ Yakubu na Yohanee (ne̱ Yeesuu a sa bamo̱ ke̱ŋasɛnyare̱ ɛ Bineregis, kaase̱ e̱ kaapo̱ fe̱yɛ Ikii‑awuye‑o), ");
INSERT INTO ncuNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","na Andruu na Filipo na Bar‑Tolomiyu na Matiyo na Tomas na Alafiyus mò̱ gyi Yakubu, na Tadiyus na Simɔŋ ne̱ ba te̱e̱ mò̱ ɛ Sɛlɔt (kaase̱ e̱ kaapo̱ fe̱yɛ Ɔmaŋkpapo̱) ");
INSERT INTO ncuNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Yudas ne̱ ba te̱e̱ mò̱ ɛ Kariyotinyi ne̱ ɔ ba a ɔ bo̱ gyi Yeesuu kidiburo‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ne̱ Yeesuu a le̱e̱ ke̱be̱e̱‑ɔ se̱ lwee lɔŋ ko̱‑rɔ. Mò̱ a lweero‑o, ase̱sɛ biribiri a be̱e̱ bo̱ gyaŋŋe̱. Amo̱se̱ se̱‑ɔ, mò̱ aa mò̱ agyase̱po̱‑ɔ mo̱ŋ nya bamo̱ e̱ye̱e̱, hare̱e̱ gbaa ba gyi ateese. ");
INSERT INTO ncuNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yeesuu mò̱ ko̱we̱bɛɛ‑ana a nu ane̱ŋ‑ɔ, ne̱ baa yɔ a bo̱ ya kra mò̱ yaa ɔpe̱, a le̱e̱ fe̱yɛ baa nu bo̱ko̱ a tɔwe̱ fe̱yɛ, “Ɔ lɔ e̱bo̱ŋ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ŋkee Wuribware̱ mbraa akaapo̱po̱ ko̱ ne̱ baa le̱e̱ Yɛro̱salɛm maŋ‑nɔ ba‑ɔ e̱ tɔwe̱ ne̱e̱ fe̱yɛ, “Ɔnyare̱ mɔ gye̱ se̱sɛ bɔye̱ ne̱e̱. Ɔbɔnsam ne̱ bo̱ be̱e̱ ba te̱e̱ mò̱ ɛ Biil-sibul‑o i te mò̱ se̱, ne̱ mò̱ e̱ gye̱ ne̱ o de ibrisi si ke̱yaale̱ŋ, ne̱ ɔ sa ɔnyare̱ mɔ e̱le̱ŋ fe̱yɛ ɔ gya ibrisi bo̱ ko̱so̱ ase̱sɛ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Mfe̱ŋ ne̱ Yeesuu a te̱e̱ bamo̱, ne̱ ɔɔ da ke̱kpare̱ ko̱ gywii bamo̱ fe̱yɛ, “E̱me̱ne̱ ne̱ Ɔbɔnsam e̱ waa a o kine mò̱ e̱ye̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","E̱kɔ ya lwee maŋ‑nɔ, ne̱ maŋ‑ɔ ya ke‑ro, amɔ maŋ amo̱ i bwee. ");
INSERT INTO ncuNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ane̱ŋ dɛɛ ne̱ kabuno ya ke‑ro, ka bwee‑o ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Amo̱se̱‑ɔ, Ɔbɔnsam na mò̱ kamɛɛ‑rɔ awuye ya kɔ abɛɛ, mò̱ ke̱yaale̱ŋ ne̱ o de‑o maa kyee na ke̱ lo̱we̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","M be̱e̱ taa fe̱yɛ Ɔbɔnsam du ne̱e̱ fe̱yɛ ɔyaale̱ŋpo̱‑ɔ. Ɔke̱maa maa lwee ɔyaale̱ŋpo̱ amo̱ lɔŋ‑nɔ a ɔ ya be̱ra mò̱ kapo̱tɛɛ nare̱, amɔ o ŋure ɔyaale̱ŋpo̱‑ɔ pwɛɛ, na ɔ dɛɛ taare̱ lweero ya be̱ra mò̱ kapo̱tɛɛ‑ɔ bo̱ yɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Mo̱ne̱ a tɔwe̱ fe̱yɛ e̱le̱ŋ ne̱ Wuribware̱ a kufwiiŋe timaa‑o a sa mo̱‑ɔ a le̱e̱ Ɔbɔnsam ase̱ ne̱e̱ e̱e̱e̱? To, mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ Wuribware̱ e̱ taare̱ a ɔ ba ase̱ŋ bɔye̱ ke̱maa ne̱ se̱sɛ e̱ tɔwe̱‑ɔ na atɔ bɔye̱ ne̱ ɔ waa‑ɔ a ɔ bo̱ ke mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Amaa ɔke̱maa ne̱ mò̱ ya tɔwe̱ ase̱ŋ bɔye̱ bo̱ kye Wuribware̱ a kufwiiŋe timaa‑o fe̱raa, Wuribware̱ maa taa bɔye̱ amo̱ a ɔ bo̱ ke mò̱ pɛɛɛ, a kaapo̱ ne̱e̱ fe̱yɛ se̱sɛ a bɔye̱ amo̱ a sii mò̱ se̱ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ke̱tɔ se̱ ne̱ Yeesuu a tɔwe̱ faanɛɛ‑ɔ e̱ gye̱ fe̱yɛ bo̱ko̱ yɛ, “Ɔbɔnsam e̱ gye̱ ne̱ o te mò̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mfe̱ŋ ne̱ Yeesuu mò̱ nyi na mò̱ tire‑ana a ba bo̱ ye̱re̱ lɔŋ ne̱ Yeesuu bo̱‑rɔ‑ɔ kawu si. Ne̱ baa suŋ ɔko̱ bo̱ kyo̱ŋwe̱ fe̱yɛ ba kpa a bo̱ ŋu mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Saŋ‑ɔ ase̱sɛ mɔ a de̱ŋ kye̱na muruwaa Yeesuu, ne̱ baa tɔwe̱ gywii mò̱ fe̱yɛ, “Ke̱e̱ ɛ, fo̱ nyi na fo̱ tire‑ana e̱ ye̱re̱ kawu ba te̱e̱ fo̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ne̱ Yeesuu a ko̱ŋ be̱ŋŋaa ase̱sɛ‑ɔ ɛ, “Nsɛ e̱ gye̱ n na? Ne̱ nsɛ‑ana mɔ e̱ gye̱ mo̱ tire‑ana?” ");
INSERT INTO ncuNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ne̱ ɔɔ de̱e̱re̱ ase̱sɛ ne̱ bo̱ te muruwaa mò̱‑ɔ, ne̱ ɔ yɛ, “Mo̱nꞌ ke̱e̱, n na na mo̱ tire‑ana i te mo̱ ase̱ mfe̱e̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Amo̱se̱‑ɔ, ɔke̱maa ne̱ ɔ waa ke̱tɔ ne̱ Wuribware̱ e̱ kpa‑ɔ ne̱ mo̱ e̱ te̱e̱ mò̱ ɛ mo̱ tire na mo̱ pe̱kye̱e̱ na n na.” ");
INSERT INTO ncuNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Saŋ ko̱ ne̱ Yeesuu a be̱e̱ le̱e̱ ɔ kaapo̱ abware̱se̱ŋ Galile̱ya ke̱pare̱ dabe̱‑ɔ kɛɛ. Amaa ase̱sɛ ne̱ baa bo̱ gyaŋŋe̱ muruwaa mò̱ mfe̱ŋ‑ɔ a kyɔ bwe̱e̱tɔ‑ɔ se̱‑ɔ, ne̱ oo buwi kpa ko̱re̱e̱, ne̱ oo neŋ ko̱re̱e̱‑ɔ bo̱ dɔŋŋɔ nkyu‑o si kafwe̱e̱. Ne̱ ɔɔ kye̱na‑rɔ kaapo̱ ase̱sɛ‑ɔ abware̱se̱ŋ. Na ase̱sɛ‑ɔ mɔ ye̱re̱ kyukɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mfe̱ŋ ne̱ ɔɔ ba itee na akpare̱ bo̱ kaapo̱ bamo̱ ase̱ŋ bwe̱e̱tɔ. Ane̱ŋ a itee mɔ ko̱ko̱ŋko̱ e̱ gye̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“N gye̱ ɔdɔɔpo̱ ko̱ e̱ bo̱‑rɔ aaa? Ne̱ ɔɔ yɔ a ɔ ya ŋo̱nyaŋ mò̱ yaabraa. ");
INSERT INTO ncuNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mò̱ a yɔ ɔ ŋo̱nyaŋ‑ɔ, ne̱ ayaabraagyi amo̱ ako̱ a le̱e̱ da kpa kɛɛ, ne̱ mbo̱gyii a bo̱ tesi gyi. ");
INSERT INTO ncuNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ne̱ amo̱ ako̱ a le̱e̱ da kagyaase̱, mfe̱ŋ ne̱ swe̱e̱re̱‑ɔ mo̱ŋ bo̱ daŋ kyɛɛkyɛɛ‑ɔ. Swe̱e̱re̱‑ɔ a mo̱ŋ bo̱ keŋ‑o si‑o, aa kwɛɛ me̱naŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Amo̱ a kwɛɛ‑ɔ, ne̱ kyɔwe̱ a bo̱ da amo̱‑ɔ, ne̱ amo̱ pɛɛɛ a wu, a le̱e̱ fe̱yɛ swe̱e̱re̱‑ɔ mo̱ŋ bo̱ keŋ a amo̱ ileŋ yɔ kaase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ayaabraagyi‑o ako̱ ne̱ aa le̱e̱ da e̱fa‑rɔ‑ɔ mɔ a ko̱so̱ daŋ. Amaa e̱fa a daŋ mwiire amo̱ se̱‑ɔ, a mo̱ŋ taare̱ waa. ");
INSERT INTO ncuNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ne̱ ŋkee ayaabraagyi‑o ako̱ a le̱e̱ da swe̱e̱re̱ timaa si, ne̱ aa kwɛɛ nɛɛnɛɛ, ne̱ aa daŋ bo̱ ko̱we̱. Hare̱e̱ amo̱ ako̱ a waa aŋu ngyingyii na anyiiresɛ na adabe̱. Amo̱ e̱ gye̱ saase̱bɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Amo̱se̱‑ɔ, ɔke̱maa ne̱ o de e̱se̱bɔ‑ɔ, o nu.” ");
INSERT INTO ncuNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Saŋ ne̱ Yeesuu a tɔwe̱ kitee‑o lo̱we̱, ne̱ ase̱sɛ‑ɔ a brawe̱‑rɔ‑ɔ, ne̱ mò̱ agyase̱po̱ kudu anyɔ‑ɔ na bamo̱ ne̱ bo̱ gya mò̱ se̱, ne̱ baa saŋ‑ɔ a ba mò̱ ase̱ fe̱yɛ ɔ kaapo̱ bamo̱ kitee‑o kaase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ne̱ ɔɔ kaapo̱ bamo̱‑rɔ fe̱yɛ, “Mo̱ne̱ wo̱re̱ ne̱ mo̱ e̱ tɔwe̱ ane̱ŋ ne̱ Wuribware̱ a kuwure‑o‑ro du‑o mo̱ i gywii, amaa itee‑ro na akpare̱‑rɔ ne̱ bamo̱ ne̱ bo̱ mo̱ŋ tii mo̱ne̱ se̱‑ɔ i nu mo̱ ase̱ŋ. Fe̱yɛ ane̱ŋ ne̱ baa kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ, ");
INSERT INTO ncuNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Na bo̱ de̱e̱re̱ ase̱ŋ‑ɔ‑rɔ, na bo̱ fa amo̱ mfɛɛre̱ kpo̱ne̱, na bo̱ ma nu kaase̱. Na bo̱ be̱e̱ nu ase̱ŋ kpo̱ra‑rɔ iluwi bwe̱e̱tɔ, na bamo̱ mɔ bo̱ ma nu kaase̱, a le̱e̱ fe̱yɛ bamo̱ ya nu kaase̱, ba nu bamo̱ e̱ye̱e̱, na bo̱ kyurowi bamo̱ mfɛɛre̱ bo̱ ba Wuribware̱ ase̱, na ɔ taa bamo̱ e̱bɔye̱ bo̱ ke bamo̱.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ne̱ Yeesuu a bise bamo̱ fe̱yɛ, “Mo̱ne̱ mo̱ŋ nu kitee‑o kaase̱ ne̱e̱ e̱e̱e̱? Ne̱ e̱me̱ne̱ gbaa ne̱ mo̱ne̱ e̱ waa a mo̱nꞌ nu ke̱ke̱maa kaase̱‑ɔ ne̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","To, mo̱nꞌ nu. Ɔdɔɔpo̱‑ɔ e̱ gye̱ mò̱ ne̱ ɔ tɔwe̱ abware̱se̱ŋ o gywii ase̱sɛ‑ɔ, ne̱ ase̱sɛ ne̱ ba nu abware̱se̱ŋ‑ɔ mɔ du fe̱yɛ ayaabraagyi‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ase̱sɛ‑ɔ bo̱ko̱ ase̱ŋ du ne̱e̱ fe̱yɛ ayaabraagyi ne̱ aa le̱e̱ da kpa kɛɛ‑ɔ. Bamo̱ ya nu abware̱se̱ŋ‑ɔ, ne̱ ke̱tɔ ya waa kafwe̱e̱, amɔ Ɔbɔnsam e̱ ba a ɔ bo̱ lee amo̱ le̱e̱ bamo̱ mfɛɛre̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bo̱ko̱ mɔ ase̱ŋ du ne̱e̱ fe̱yɛ ayaabraagyi ne̱ aa le̱e̱ da kagyaase̱. Bamo̱ fe̱raa bamo̱ ya nu abware̱se̱ŋ‑ɔ, amo̱‑ɔ a waa bamo̱ kɔne̱ na bo̱ kɔɔre̱ waa bamo̱ ŋkpo̱nɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Amaa bamo̱ akatɔ a mo̱ŋ pee si‑o si‑o, ase̱ŋ kuŋu bɛɛɛ awo̱re̱fɔɔ ya to̱ bamo̱ bo̱ le̱e̱ abware̱se̱ŋ ne̱ baa kɔɔre̱ gyi‑o si, amɔ ba yɔwe̱ amo̱ se̱ ke̱gya. ");
INSERT INTO ncuNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ase̱sɛ‑ɔ bo̱ko̱ ase̱ŋ du ne̱e̱ fe̱yɛ ayaabraagyi ne̱ aa le̱e̱ da e̱fa‑rɔ, ne̱ aa kwɛɛ, ne̱ e̱fa a daŋ mwiire si‑o. Mfaanɛɛ a ase̱sɛ‑ɔ i nu abware̱se̱ŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Amaa kaye̱ mɔ‑rɔ atɔ tɔɔraasɛ, na katanne̱kpa ne̱ ka taare̱ a ka pe̱nna se̱sɛ‑ɔ, na atɔ biribiri ke̱kpa ya lwee bamo̱ mfɛɛre̱‑rɔ, amɔ aa waa ko̱kyɔ kyo̱ŋ abware̱se̱ŋ ne̱ a bo̱ bamo̱ ŋkpo̱nɔ‑rɔ‑ɔ. Amɔ bamo̱ ko̱kɔɔre̱gyi‑o maa waa bamo̱ sɛye̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Amaa bo̱ko̱ mɔ ase̱ŋ du ne̱e̱ fe̱yɛ ayaabraagyi ne̱ aa le̱e̱ da swe̱e̱re̱ timaa‑o si‑o. Ane̱ŋ a ase̱sɛ‑ɔ i nu abware̱se̱ŋ nɛɛnɛɛ, na bo̱ kɔɔre̱ amo̱ waa bamo̱ ŋkpo̱nɔ‑rɔ. Fe̱yɛ ane̱ŋ ne̱ ayaabraagyi ne̱ aa le̱e̱ da swe̱e̱re̱ timaa‑o si‑o a waa aŋu ngyingyii na anyiiresɛ na adabe̱‑ɔ, mfaanɛɛ a ase̱sɛ‑ɔ e̱ waa ke̱dame̱naŋsɛ. Bo̱ko̱ e̱ waa ke̱dame̱naŋsɛ bwe̱e̱tɔ, ne̱ bo̱ko̱ mɔ e̱ waa ke̱dame̱naŋsɛ bwe̱e̱tɔ bwe̱e̱tɔ, ne̱ bo̱ko̱ mɔ be̱e̱ ba waa ke̱dame̱naŋsɛ bwe̱e̱tɔ bwe̱e̱tɔ bwe̱e̱tɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kamɛɛ‑rɔ, ne̱ Yeesuu a bise fe̱yɛ, “Mo̱ne̱ nsɛ e̱ gye̱ ne̱ ɔ kyaŋŋe̱ mò̱ fetiri si na ɔ ko̱ŋ be̱ra kike bo̱ buŋ si, bɛɛɛ ɔ taa fetiri‑o bo̱ kwe̱e̱rɔ mpaa kaase̱? N gye̱ kabuno ne̱ ɔ ba a ɔ bo̱ ye̱ra a ɔ laŋŋe̱ lɔŋ‑ɔ‑rɔ pɛɛɛ aaa? ");
INSERT INTO ncuNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","23","Mo̱ne̱ i de e̱se̱bɔ, mo̱nꞌ nu. Sɛye̱ maa lɛɛ kwe̱e̱rɔ. Ke̱tɔ ke̱maa na ase̱ŋ ke̱maa e̱ le̱e̱ ifuri na ɔke̱maa ŋu.” ");
INSERT INTO ncuNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Ɔke̱maa fa ase̱ŋ ne̱ o nu‑o mfɛɛre̱ nɛɛnɛɛ. Amo̱se̱‑ɔ ɔke̱maa ne̱ o nu mo̱ ase̱ŋ timaa‑o ne̱ ɔ kɔɔre̱ a o gyi‑o, Wuribware̱ e̱ sa mò̱ kanyiase̱ŋ bwe̱e̱tɔ na ɔ bo̱ tii kamo̱ ne̱ o de‑o si. ");
INSERT INTO ncuNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","A le̱e̱ fe̱yɛ ɔke̱maa ne̱ o nu mo̱ ase̱ŋ timaa‑o ne̱ ɔ kɔɔre̱ a o gyi‑o e̱ nya kanyiase̱ŋ bwe̱e̱tɔ, ne̱ mò̱‑ɔ mò̱ ne̱ o kine amo̱‑ɔ e̱ paŋ mò̱ kanyiase̱ŋ kafwe̱e̱ ne̱ ɔ kyɔ o de‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Mfe̱ŋ ne̱ Yeesuu a be̱e̱ tɔwe̱ fe̱yɛ, “To, ne̱ e̱me̱ne̱ ne̱ Wuribware̱ a kuwure‑o‑ro du‑o ne̱e̱? Ku du ne̱e̱ fe̱yɛ ɔdɔɔpo̱ a dwii abwaye‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kake ke̱maa ne̱ o di ɔ ko̱so̱‑ɔ, a daŋ, na mò̱‑ɔ mò̱ mo̱ŋ nyi ane̱ŋ ne̱ a waa a daŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","A kaapo̱ fe̱yɛ swe̱e̱re̱‑ɔ e̱ gye̱ ne̱ ɔ be̱ra abwaye‑o, na a kwɛɛ, na a bo̱ daŋ, na a powi, na a be̱re̱ waa ateese. ");
INSERT INTO ncuNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Amo̱ ya wo̱re̱ lo̱we̱‑ɔ, na ɔdɔɔpo̱‑ɔ ya gyɛɛ baa pe̱. Mfaanɛɛ dɛɛ ne̱ Wuribware̱ a kuwure‑o‑ro du.” ");
INSERT INTO ncuNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Saŋ amo̱ ne̱ Yeesuu a be̱e̱ da ke̱kpare̱ ko̱. Ne̱ oo bise ɛ, “Ntɔ gbaa ne̱ mo̱ e̱ ba a m bo̱ kaapo̱ mo̱ne̱ ane̱ŋ ne̱ Wuribware̱ a kuwure‑o‑ro du‑o ne̱e̱? Ke̱kpare̱ mo̱ ne̱ mo̱ e̱ ba a m bo̱ kaapo̱ mo̱ne̱ Wuribware̱ a kuwure‑o kaase̱‑ɔ ne̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","To, mfaanɛɛ ne̱ ku du. Wuribware̱ a kuwure‑o‑ro du ne̱e̱ fe̱yɛ kupurutugyi‑o. Kigyi mɔ du kagyingyii. ");
INSERT INTO ncuNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Amaa se̱sɛ ya dwii ke̱mo̱, amɔ ke̱ e̱ kwɛɛ a ke̱ daŋ kii kikiree, ne̱ ke̱ bo̱ e̱swe̱e̱ ko̱ kyo̱ŋ ayii pɛɛɛ. Na mbo̱gyii bo̱ kye̱na ke̱mo̱ se̱ waa bamo̱ asaa.” ");
INSERT INTO ncuNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Mfaanɛɛ ne̱ Yeesuu a tɔwe̱ abware̱se̱ŋ bwe̱e̱tɔ akpare̱‑rɔ na itee‑ro gywii ase̱sɛ. Ɔɔ tɔwe̱ ase̱ŋ bwe̱e̱tɔ gywii bamo̱ ane̱ŋ ne̱ baa nya a bo̱ nu kaase̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ɔ maa tɔwe̱ ase̱ŋ a o gywii ase̱sɛ na a mo̱ŋ gye̱ kitee bɛɛɛ ke̱kpare̱. Amaa amo̱ ya saŋ mò̱ aa mò̱ agyase̱po̱‑ɔ wo̱re̱, ne̱ ase̱sɛ mo̱ŋ lɛɛ bo̱ bo̱‑rɔ‑ɔ, amɔ ɔ kaapo̱ bamo̱ itee na akpare̱‑ɔ kaase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ŋke nsi amo̱ ke̱de̱e̱pwɛta, ne̱ Yeesuu a tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Mo̱nꞌ sa a ane̱ te̱ŋ Galile̱ya ke̱pare̱ dabe̱‑ɔ‑rɔ yɔ nno̱ŋ a bo̱ŋbe̱‑ɔ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ne̱ mò̱ agyase̱po̱‑ɔ a lwee ko̱re̱e̱ ne̱ Yeesuu te mò̱‑rɔ nkyu‑o kɛɛ ɔ tɔwe̱ abware̱se̱ŋ‑ɔ‑rɔ‑ɔ, ne̱ baa me̱raa se̱ ba pare̱. Ne̱ baa yɔwe̱ ase̱sɛ ne̱ Yeesuu a kaapo̱ bamo̱‑ɔ bo̱ sii nkyu‑o kɛɛ. E̱ko̱re̱e̱ ko̱ gbaa tii Yeesuu‑ana mmo̱‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nkyu si mfe̱ŋ ne̱ afwii dabe̱ ko̱ a kya, ne̱ alaŋkpare̱ a da nkyu bo̱ waa Yeesuu‑ana ko̱re̱e̱‑ɔ‑rɔ, ne̱ ɔ kpa a ɔ bo̱rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ade̱maŋte̱ mɔ ne̱ a su‑o pɛɛɛ na Yeesuu kuŋu dɔŋ kaputu si ɔ da ko̱re̱e̱‑ɔ kuŋu o di idi. Amo̱ fe̱raa ne̱ mò̱ agyase̱po̱‑ɔ a kyiŋŋi mò̱, ne̱ baa bise mò̱ fe̱yɛ, “Ɔkaapo̱po̱, amɔ ane̱ ko̱re̱e̱‑ɔ a kpa a o buŋ ane̱‑ɔ, a mo̱ŋ tiri fo̱ ne̱e̱ e̱e̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Mò̱ a ko̱so̱‑ɔ, ne̱ ɔɔ tɔwe̱ yɛ, “Afwii, yɔwe̱.” Ne̱ ɔɔ tɔwe̱ fe̱yɛ, “Alaŋkpare̱, yɔwe̱.” Mfe̱ŋ ne̱ afwii‑o na alaŋkpare̱‑ɔ pɛɛɛ a waa surumm. ");
INSERT INTO ncuNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ne̱ Yeesuu a bise mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Ntɔ se̱ ne̱ kufu de mo̱ne̱? Nte̱tɔ se̱ ne̱ mo̱ne̱ maa kɔɔre̱ mo̱ mo̱ne̱ i gyi‑o ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kufu a nya mò̱ agyase̱po̱‑ɔ bwe̱e̱tɔ, ne̱ ŋkee ba ŋwiini ba gywii abɛɛ ɛ, “Nte̱tɔ se̱sɛ e̱ gye̱ ɔnyare̱ mɔ? Mò̱ ya sa kanɔ, afwii na alaŋkpare̱ gya kamo̱ se̱‑ɔ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Amo̱ kamɛɛ‑rɔ, ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ a kya se̱ pare̱ bamo̱ ko̱re̱e̱‑ɔ bo̱ te̱ŋ‑nɔ ya bo̱ daŋ Galile̱ya ke̱pare̱ dabe̱ a nno̱ŋ a bo̱ŋbe̱‑ɔ. Gadara ifuri si ne̱ baa fo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yeesuu a de̱ŋ le̱e̱ ko̱re̱e̱‑ɔ‑rɔ, ne̱ ɔɔ me̱raa se̱ ɔ yɔ‑ɔ, ne̱ ɔnyare̱ ko̱ ne̱ ibrisi te mò̱ se̱‑ɔ a le̱e̱ mfe̱ŋ ne̱ ba pure afuniŋ‑o gyaŋŋaa mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Oo tu le̱e̱ maŋ‑nɔ yɔ o te mfe̱ŋ ne̱ ba pure ase̱sɛ‑ɔ. Ɔko̱ mo̱ŋ bo̱‑rɔ ne̱ ɔ taare̱ a o ŋure mò̱ bo̱ kye̱na to̱ŋ ko̱ŋko̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Saŋ ke̱maa ne̱ ba ba agbarabi a bo̱ bo̱ ŋure mò̱ ayaa‑rɔ na asare̱e̱‑rɔ‑ɔ, ɔ te̱ŋŋe̱ amo̱ pɛɛɛ‑rɔ. Amo̱se̱‑ɔ, ɔke̱maa mo̱ŋ de mò̱ e̱le̱ŋ ɔ kra mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ɔnyare̱ amo̱ a waa ne̱e̱ fe̱yɛ ɔbo̱ŋlɔpo̱‑ɔ, ne̱ kanye na mpase̱ ɔ naa purekpa na abe̱e̱‑rɔ ɔ kaa, na ɔ fɛɛ‑rɔ, na o de afo̱re̱ ɔ te̱ŋŋe̱ mò̱ e̱ye̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","8","Ɔnyare̱ mɔ a bo̱ ke̱fɔ ne̱ oo ŋu Yeesuu‑o, ne̱ ɔɔ ŋwɛɛnaŋ bo̱ kpuni aŋurii Yeesuu akatɔ‑rɔ. Ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Ibrisi, ko̱so̱ ɔnyare̱ amo̱ se̱.” Mfe̱ŋ ne̱ ɔɔ faa‑rɔ keŋkeŋ tɔwe̱ fe̱yɛ, “Yeesuu, Nyiŋkpe̱ŋ-kyo̱ŋ-atɔ‑pɛɛɛ-Bware̱ mò̱ gyi‑o. Nte̱tɔ ne̱ fo̱ e̱ kpa mo̱ ase̱ mfe̱e̱? Mo̱ e̱ ko̱re̱ fo̱ ne̱e̱ na fo̱ de̱e̱re̱ Wuribware̱ se̱ na fo̱ ma tɔɔraa mo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Amo̱se̱‑ɔ, ne̱ Yeesuu a bise mò̱ fe̱yɛ, “Fo̱ ke̱nyare̱ e̱ gye̱ e̱me̱ne̱?” Ne̱ ɔ yɛ, “Mo̱ ke̱nyare̱ e̱ gye̱ ‘Ane̱-kyɔ-mfe̱e̱,’ a le̱e̱ fe̱yɛ ibrisi bwe̱e̱tɔ te mfe̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ne̱ ɔɔ me̱raa se̱ ɔ ko̱re̱ Yeesuu fe̱yɛ ɔ ma gya ibrisi amo̱ le̱e̱ ifuri amo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Amɔ aprako biribiri ko̱ mɔ ye̱re̱ kabe̱e̱gyi ko̱ se̱ mfe̱ŋ ba gyi. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Amo̱se̱‑ɔ, ne̱ ibrisi amo̱ a ko̱re̱ Yeesuu fe̱yɛ, “Sa a ane̱ ya kye̱na aprako mɔ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yeesuu a sa e̱mo̱ kpa‑ɔ, ne̱ e̱ ya ko̱so̱ ɔnyare̱ amo̱ se̱ ya kye̱na aprako‑o si. Aprako‑o e̱ fo̱ ŋkpe̱ŋ ŋnyɔ. Ibrisi amo̱ a de̱ŋ kye̱na bamo̱ se̱‑ɔ, ne̱ bamo̱ pɛɛɛ a ŋwɛɛnaŋ kpo̱ro̱we̱ kabe̱e̱gyi‑o si ya le̱e̱ da nkyu‑ro wu wu. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mfe̱ŋ ne̱ bamo̱ ne̱ ba de̱e̱re̱ aprako amo̱ se̱‑ɔ a ŋwɛɛnaŋ yɔ maŋ‑nɔ na mmaŋgyii‑ro na adɔɔ‑rɔ ya da ase̱ŋ ne̱ aa ba‑ɔ kiboŋboŋ. Kafwe̱e̱‑ɔ, ne̱ ɔke̱maa a le̱e̱ ba a ɔ bo̱ ke̱e̱ ke̱tɔ ne̱ kaa waa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bamo̱ a ba Yeesuu ase̱‑ɔ, ne̱ baa ŋu ɔnyare̱ ne̱ ibrisi dɛɛ i te mò̱ se̱, ne̱ Yeesuu a kya mò̱‑ɔ te mfe̱ŋ o buŋ atɔ, ne̱ ŋkee fe̱raa mò̱ mfɛɛre̱ du mò̱ kyɛɛkyɛɛ. Ne̱ kufu a nya bamo̱ pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ne̱ bamo̱ ne̱ amo̱‑ɔ pɛɛɛ a waa na bo̱ bo̱ mfe̱ŋ‑ɔ a tɔwe̱ ane̱ŋ ne̱ ɔnyare̱ amo̱ a kpaare̱‑ɔ, na ane̱ŋ ne̱ aprako amo̱ a wu‑o pɛɛɛ gywii bamo̱ ne̱ baa sii kamɛɛ ba‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Amo̱se̱‑ɔ, ne̱ baa ko̱re̱ Yeesuu fe̱yɛ ɔ le̱e̱ bamo̱ ifuri si nare̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Amo̱ fe̱raa Yeesuu a lwee ko̱re̱e̱‑ɔ‑rɔ ɔ kpa a ɔ yɔ‑ɔ, ne̱ ɔnyare̱ ne̱ Yeesuu a gya ibrisi bo̱ ko̱so̱ mò̱ se̱‑ɔ yɛ, “Mo̱ nyaŋpe̱, sa a mo̱ aa fo̱ a yɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Amaa Yeesuu mo̱ŋ sure si. Ne̱ ɔɔ be̱ŋŋaa mò̱ fe̱yɛ, “Kiŋŋi nare̱ pe̱ ya tɔwe̱ ane̱ŋ ne̱ mo̱, fo̱ nyaŋpe̱‑ɔ, a ŋu fo̱ e̱wɛɛ‑ɔ, na atɔ dabe̱ ne̱ mo̱ a waa sa fo̱‑ɔ, gywii fo̱ ko̱we̱bɛɛ‑ana.” ");
INSERT INTO ncuNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Amo̱se̱‑ɔ, ne̱ ɔnyare̱ amo̱ a me̱raa se̱ ya tɔwe̱ ase̱ŋ‑ɔ gywii ɔke̱maa ne̱ ɔ bo̱ ifuri ne̱ ba te̱e̱ ɛ Dekapolis‑o (kaase̱ e̱ kaapo̱ fe̱yɛ E̱maŋ-Kudu‑o) si. Ne̱ e̱ye̱e̱ a kpe̱ŋ bamo̱ pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","A mo̱ŋ kyee, ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ a be̱e̱ kiŋŋi ba Galile̱ya ke̱pare̱ dabe̱ a bo̱ŋbe̱ ne̱ baa le̱e̱ mò̱ se̱‑ɔ. Mfe̱ŋ ne̱ ase̱sɛ biribiri a kyɔ bo̱ muruwaa mò̱ nkyu amo̱ kɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ne̱ ke̱bware̱ko̱re̱kyaŋ abre̱sɛ‑ɔ ɔko̱ ne̱ ba te̱e̱ mò̱ ɛ Yayerus‑o a fo̱ nkyu kɛɛ mfe̱ŋ ne̱ oo ŋu Yeesuu‑o, ne̱ oo kpuni aŋurii mò̱ ayaa‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ne̱ ɔɔ ko̱re̱ Yeesuu fe̱yɛ, “Mo̱ kayaagyi kye̱e̱sɛ e̱ lɔ, hare̱e̱ ɔ kpa a o wu. Amo̱se̱‑ɔ, mo̱ e̱ ko̱re̱ fo̱ ne̱e̱ fe̱yɛ fo̱ bo̱ ba fo̱ asare̱e̱ bo̱ dabo̱rɔ mò̱ a ɔ nya kpaare̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Mfe̱ŋ ne̱ Yeesuu mò̱ aa ɔnyare̱‑ɔ a me̱raa se̱ ba yɔ. Bamo̱ a yɔ‑ɔ, ase̱sɛ bwe̱e̱tɔ a muruwaa Yeesuu ne̱e̱ bo̱ gya se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Amɔ ɔkye̱e̱ ko̱ mɔ bo̱‑rɔ, ne̱ ɔ lɔ ke̱kye̱e̱tɔ, a le̱e̱ fe̱yɛ kiferi ke̱maa‑rɔ ɔ taare̱ bwiino waa iluwi kanɔ ŋko̱. Waa nsu kudu ŋnyɔ ne̱e̱ fe̱yɛ mò̱ a lɔ ane̱ŋ a ko̱lɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ɔkye̱e̱ mɔ a ba mò̱ kapo̱tɛɛ pɛɛɛ ne̱ o de‑o bo̱ sa dɔkɔtaa awuye na bo̱ kya mò̱, bamo̱‑ɔ bo̱ mo̱ŋ taare̱, na ŋkee gbaa ne̱ baa sa ne̱ mò̱ ko̱lɔ amo̱ i tii si. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Mbe̱yɔmɔ ɔkye̱e̱ mɔ a nu ane̱ŋ ne̱ Yeesuu a kya alɔpo̱‑ɔ se̱‑ɔ se̱‑ɔ, ne̱ oo lwee ase̱sɛ ne̱ bo̱ gya Yeesuu si‑o‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ne̱ ɔɔ fa fe̱yɛ, “Mo̱ ya dabo̱rɔ mò̱ atɔ buŋsɛ gbaa, mo̱ e̱ kpaare̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kase̱ŋtiŋ, mò̱ a de̱ŋ dabo̱rɔ Yeesuu a atɔ buŋsɛ‑ɔ, ne̱ ɔɔ kpaare̱, a le̱e̱ fe̱yɛ aa waa mò̱ kayo̱wɔre̱‑rɔ fe̱yɛ ko̱lɔ amo̱ a lo̱we̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mfe̱ŋ ne̱ aa kyɔ waa Yeesuu fe̱yɛ e̱le̱ŋ a le̱e̱ mò̱‑rɔ kya ɔko̱. Amo̱se̱‑ɔ, oo buruwaa de̱e̱re̱ ase̱sɛ ne̱ mò̱ aa bamo̱ naa‑ɔ‑rɔ, ne̱ oo bise fe̱yɛ, “Nsɛ ya dabo̱rɔ mo̱ atɔ buŋsɛ‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ne̱ Yeesuu agyase̱po̱‑ɔ a be̱ŋŋaa mò̱ fe̱yɛ, “E̱me̱ne̱ ne̱e̱ ne̱ fo̱ i bise ane̱ŋ, na ase̱sɛ de̱maŋte̱ mɔ a muruwaa fo̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Na Yeesuu mɔ saŋ ɔ de̱e̱re̱ ɔ kpa mò̱ ne̱ ɔɔ dabo̱rɔ mò̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ne̱ kufu a nya ɔkye̱e̱‑ɔ, amaa bo̱ le̱e̱ fe̱yɛ mò̱ a kpaare̱‑ɔ se̱‑ɔ, ne̱ ɔɔ ba Yeesuu ase̱, ne̱ oo kpuni aŋurii tɔwe̱ mò̱ ko̱lɔ‑rɔ kase̱ŋtiŋ pɛɛɛ gywii mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Ɔpe̱kye̱e̱, bo̱ le̱e̱ ane̱ŋ ne̱ fo̱ a kɔɔre̱ mo̱ gyi‑o si, fo̱ a kpaare̱. Amo̱se̱‑ɔ, fo̱ ko̱lɔ‑ɔ maa lɛɛ ba pɛɛɛ. To, nare̱ dame̱naŋsɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Saŋ ne̱ Yeesuu e̱ tɔwe̱ amo̱‑ɔ, ne̱ mbɔɔ ko̱ a le̱e̱ Yayerus ne̱ mò̱ kayaagyi kye̱e̱sɛ e̱ lɔ‑ɔ aye̱ bo̱ tɔwe̱ gywii mò̱ fe̱yɛ, “Fo̱ gyi‑o a wu, amo̱se̱‑ɔ, fo̱ ma lɛɛ sa a ɔkaapo̱po̱‑ɔ kpo̱ne̱ mò̱ e̱ye̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yeesuu a nu bamo̱ a tɔwe̱ ba gywii ɔnyare̱ amo̱ fe̱yɛ mò̱ gyi‑o a wu‑o, ɔ mo̱ŋ be̱ŋŋaa bamo̱. Ne̱ ɔɔ tɔwe̱ gywii Yayerus fe̱yɛ, “Fo̱ ma sa a fo̱ duŋ te̱ŋ fo̱, fo̱ fe̱raa, kɔɔre̱ mo̱ gyi.” ");
INSERT INTO ncuNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Amo̱ fe̱raa Yeesuu mo̱ŋ lɛɛ sa a ɔko̱ gya mò̱ se̱, amɔ Peetroo na Yakubu na Yakubu mò̱ tire Yohanee. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bamo̱ a fo̱ Yayerus aye̱‑ɔ, ne̱ Yeesuu a ŋu ane̱ŋ ne̱ ase̱sɛ i su keŋkeŋ‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ne̱ oo bise bamo̱ fe̱yɛ, “Nte̱tɔ kusu wo̱re̱ ne̱e̱? Kakye̱e̱sɛɛ‑ɔ mo̱ŋ wu, o di idi ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mò̱ a tɔwe̱ ane̱ŋ‑ɔ, ne̱ baa mɔse̱ mò̱. Ne̱ ɔɔ sa ne̱ ɔke̱maa a le̱e̱ lɔŋ‑ɔ‑rɔ. Ne̱ ŋkee mò̱ aa kakye̱e̱sɛɛ‑ɔ mò̱ se̱ na mò̱ nyi na mò̱ agyase̱po̱ asa‑ɔ a yɔ ke̱kyaŋ ne̱ kifuniŋ‑o da ke̱mo̱‑rɔ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Mfe̱ŋ ne̱ ɔɔ kra kakye̱e̱sɛɛ‑ɔ ke̱sare̱e̱‑rɔ, ne̱ ɔɔ tɔwe̱ gywii mò̱ fe̱yɛ, “Taliita kum.” Bamo̱ Heebrii se̱ŋsa‑rɔ ne̱ ɔɔ tɔwe̱, ke̱mo̱ kaase̱ e̱ gye̱ fe̱yɛ, “Kakye̱e̱sɛɛ, kyiŋŋi ko̱so̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Mfe̱ŋ ne̱ kakye̱e̱sɛɛ‑ɔ a kyiŋŋi ko̱so̱ ɔ naa. Kakye̱e̱sɛɛ amo̱ a gyi nsu kudu ŋnyɔ. Mò̱ a kyiŋŋi ko̱so̱‑ɔ, aa kpe̱ŋ ɔke̱maa e̱ye̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Amaa Yeesuu a tɔwe̱ gywii bamo̱ ne̱e̱ fe̱yɛ ɔke̱maa ma kaŋ tɔwe̱ ke̱tɔ ne̱ ɔɔ waa‑ɔ gywii ɔko̱. Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ bo̱ sa kakye̱e̱sɛɛ‑ɔ ateese a o gyi. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Saŋ ne̱ Yeesuu a le̱e̱ Kapaaniyum maŋ‑nɔ‑ɔ, ne̱ mò̱ aa mò̱ agyase̱po̱‑ɔ a yɔ mò̱ aye̱ Nasarɛt. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kukyure kake a fo̱‑ɔ, ne̱ ɔɔ yɔ ke̱bware̱ko̱re̱kyaŋ‑nɔ ya kaapo̱ abware̱se̱ŋ. Ase̱sɛ bwe̱e̱tɔ bo̱ ke̱kyaŋ‑ɔ‑rɔ mfe̱ŋ. Bamo̱ a nu mò̱ ase̱ŋ‑ɔ, ne̱ aa kpe̱ŋ bamo̱ e̱ye̱e̱. Amo̱se̱‑ɔ, ne̱ baa tɔwe̱ fe̱yɛ, “Mfe̱ne̱ ne̱ ɔnyare̱ mɔ a nya mfɛɛre̱ mɔ le̱e̱? Nsɛ ya sa mò̱ kpa fe̱yɛ ɔ waa akpe̱ŋe̱ye̱e̱tɔ mɔ ne̱ ane̱ a nu amo̱ ase̱ŋ‑ɔ? ");
INSERT INTO ncuNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","N gye̱ Mariya mò̱ gyi na Yakubu na Yo̱sɛf na Yudas na Simɔŋ bamo̱ daa kaape̱ŋtaa‑ɔ ne̱e̱ e̱e̱e̱? Mò̱ pe̱kye̱e̱‑ana mo̱ŋ te mfe̱e̱ aaa?” Ne̱ baa kine mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Mfe̱ŋ ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “Ba bu Wuribware̱ kyaamɛɛ to̱ŋ ke̱maa, amaa mò̱ fɔŋfɔŋ aye̱ awuye na mò̱ ako̱we̱bɛɛ fe̱raa mɔ mo̱ŋ de mò̱ bo̱ te̱e̱ sɛye̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Amo̱se̱‑ɔ, ɔ mo̱ŋ nya kya alɔpo̱ mò̱ maŋ‑ɔ‑rɔ, a le̱e̱ fe̱yɛ bo̱ mo̱ŋ kɔɔre̱ mò̱ gyi. Amaa oo teyi mò̱ ke̱sare̱e̱ bo̱ dɔŋŋɔ alɔpo̱ kafwe̱e̱ ko̱ se̱ mfe̱ŋ, ne̱ baa kpaare̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ne̱ e̱ye̱e̱ a kpe̱ŋ Yeesuu fe̱yɛ mò̱ fɔŋfɔŋ ase̱sɛ a mo̱ŋ kɔɔre̱ mò̱ gyi. Ne̱ Yeesuu a le̱e̱ mfe̱ŋ yɔ e̱maŋ ne̱ e̱ bo̱ mfe̱ŋ‑ɔ‑rɔ ya kaapo̱ abware̱se̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nsaŋ amo̱, ne̱ ɔɔ sa ne̱ mò̱ agyase̱po̱ kudu anyɔ‑ɔ a gyaŋŋe̱, ne̱ oo suŋ bamo̱ anyɔ anyɔ bo̱ kyo̱ŋwe̱ e̱maŋ se̱ fe̱yɛ bo̱ nare̱ tɔwe̱ abware̱se̱ŋ. Ne̱ ɔɔ sa bamo̱ e̱le̱ŋ a bo̱ taare̱ kya alɔpo̱ ne̱ ibrisi te bamo̱ se̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ne̱ a yɔ‑ɔ, ɔko̱ ma kaŋ taa bodobodoo bɛɛɛ ko̱re̱e̱ bɛɛɛ atanne̱ waa mò̱ gyife‑ro, bɛɛɛ e̱kaare̱ ko̱ bo̱ tii ɔko̱ ne̱ mo̱ne̱ ɔke̱maa mɔ buŋ‑o si, amɔ kayii nare̱se̱sɛ na ase̱be̱ta kpeŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ne̱ Yeesuu a be̱e̱ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ne̱ a yɔ‑ɔ, mo̱nꞌ kye̱na lɔŋ ne̱ mo̱ne̱ e̱ so̱we̱ mò̱‑rɔ‑ɔ ne̱ ba kra mo̱ne̱ nɛɛnɛɛ‑ɔ‑rɔ‑ɔ bo̱ fo̱ ŋke nsi ne̱ mo̱ne̱ e̱ le̱e̱ maŋ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Amaa mo̱ne̱ ne̱ mo̱ne̱ ya yɔ to̱ŋ ko̱, ne̱ bamo̱ e̱ mo̱ŋ kra mo̱ne̱ dame̱naŋsɛ, bɛɛɛ bamo̱ e̱ ma kpa a bo̱ nu mo̱ne̱ ase̱ŋ timaa‑o fe̱raa, na mo̱nꞌ le̱e̱ maŋ‑ɔ‑rɔ gbaa pɛɛɛ, na mo̱nꞌ kpo̱ŋkpaŋ mo̱ne̱ ase̱be̱ta‑rɔ e̱se̱ bo̱ sii bamo̱ aye̱, bo̱ yii bamo̱ se̱ fe̱yɛ bamo̱ e̱bɔye̱ a sii bamo̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yeesuu a tɔwe̱ lo̱we̱‑ɔ, ne̱ baa me̱raa se̱ anyɔ anyɔ yɔ ba tɔwe̱ abware̱se̱ŋ fe̱yɛ ɔke̱maa nu mò̱ e̱ye̱e̱ na ɔ le̱e̱ mò̱ e̱bɔye̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ne̱ baa gya ibrisi bo̱ ko̱so̱ ase̱sɛ bwe̱e̱tɔ se̱, ne̱ baa twiiri mfɔ bo̱ we̱e̱ alɔpo̱ bwe̱e̱tɔ aŋu‑ro, ne̱ baa kpaare̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mbe̱yɔmɔ, Yeesuu ke̱nyare̱ a yɔ nde̱ pɛɛɛ se̱‑ɔ se̱‑ɔ, Hɛrɔd ne̱ ɔ gye̱ Galile̱ya swe̱e̱re̱ se̱ a owure‑o a nu Yeesuu ase̱ŋ. Ŋkee bo̱ko̱ e̱ tɔwe̱ ne̱e̱ fe̱yɛ, “Ane̱ e̱ kɔɔre̱ a ane̱ gyi fe̱yɛ ɔnyare̱ amo̱ e̱ gye̱ Yohanee Osuubɔpo̱ ne̱ fo̱ a mɔɔ mò̱‑ɔ, ne̱ ɔɔ be̱e̱ kyiŋŋi le̱e̱ lowi‑ro‑o. Amo̱ e̱ mo̱ŋ gye̱ ane̱ŋ fe̱raa, ɔ maa taare̱ a ɔ waa ane̱ŋ a akpe̱ŋe̱ye̱e̱tɔ mɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bo̱ko̱ mɔ yɛ, “Iliya ne̱e̱.” Ne̱ bo̱ko̱ mɔ yɛ, “Ɔ gye̱ Wuribware̱ kyaamɛɛ ne̱e̱ fe̱yɛ bamo̱ ne̱ baa dɛɛ ba de̱daa‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Owure Hɛrɔd a nu Yeesuu ase̱ŋ‑ɔ, mò̱ fe̱raa yɛ, “Yohanee Osuubɔpo̱ ne̱ mo̱ a sa ne̱ baa tuwi mò̱ kuŋu‑o ya be̱e̱ kyiŋŋi le̱e̱ lowi‑ro.” ");
INSERT INTO ncuNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Mfaanɛɛ mɔ ne̱ Yohanee Osuubɔpo̱‑ɔ a wu. Saŋ ko̱ Owure Hɛrɔd a kɔɔre̱ mò̱ tire Filipo mò̱ ka ne̱ ba te̱e̱ mò̱ ɛ Hɛrɔde̱ya‑ɔ waare̱e̱. Ne̱ Yohanee Osuubɔpo̱‑ɔ mɔ a yii owure‑o si iluwi bwe̱e̱tɔ fe̱yɛ, “A mo̱ŋ bware fe̱yɛ fo̱ a kɔɔre̱ fo̱ tire mò̱ ka waare̱e̱.” Mfaanɛɛ se̱‑ɔ, ne̱ ɔkye̱e̱ Hɛrɔde̱ya a taa Yohanee kikisi, hare̱e̱ ɔ kpa mò̱ a ɔ mɔɔ, amaa aa waa mò̱ lɔ, a le̱e̱ fe̱yɛ Owure Hɛrɔd i bu Yohanee ne̱ o nyi fe̱yɛ ɔ gye̱ se̱sɛ timaa, ne̱ mò̱ kakpo̱nɔ‑rɔ mo̱ŋ de iyisi‑o. Amo̱ fe̱raa ke̱tɔ ne̱ Hɛrɔd a waa‑ɔ e̱ gye̱ fe̱yɛ ɔɔ sa ne̱ baa kra Yohanee, ne̱ baa ba agbarabi bo̱ ŋure mò̱, ne̱ baa tii mò̱. Mfaanɛɛ ne̱ ɔɔ bo̱ kuŋ Yohanee na mò̱ ka ma nya mɔɔ mò̱. Saŋ ko̱ na o lee Yohanee le̱e̱ mò̱ tiikpa‑ɔ na ɔ bo̱ tɔwe̱ abware̱se̱ŋ gywii mò̱, a le̱e̱ fe̱yɛ ɔ kpa mò̱ se̱ŋsa sasɛ na o nu, amaa saŋ ke̱maa ne̱ oo nu ase̱ŋ amo̱‑ɔ, amɔ mò̱ kakpo̱nɔ‑rɔ a nye̱ra. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Owure Hɛrɔd ko̱ko̱we̱ kasu kanɔ a fo̱‑ɔ, ne̱ ɔɔ te̱e̱ mò̱ maŋ abre̱sɛ na asoogyaa abre̱sɛ na Galile̱ya swe̱e̱re̱ se̱ abre̱sɛ bo̱ gyaŋŋe̱ fe̱yɛ bo̱ bo̱ gyi ateese na bo̱ gyi akatɔ. Saŋ amo̱ ne̱ Hɛrɔde̱ya a nya Yohanee Osuubɔpo̱‑ɔ ke̱mɔɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ngyaŋŋe̱ amo̱‑rɔ, ne̱ Hɛrɔde̱ya mò̱ gyi kabregyii a lwee bo̱ŋ‑nɔ kyaa. Mò̱ a kyaa‑ɔ, ne̱ aa gyi Owure Hɛrɔd na ɔke̱maa ne̱ ɔɔ gyaŋŋe̱ mfe̱ŋ‑ɔ akatɔ bwe̱e̱tɔ. Amo̱se̱‑ɔ, ne̱ owure a bise mò̱ fe̱yɛ, “Mo̱ gyi, nte̱tɔ ne̱ fo̱ e̱ kpa a ŋ ke fo̱‑ɔ ne̱e̱? Ke̱tɔ ke̱maa ne̱ fo̱ e̱ kpa‑ɔ, tɔwe̱ a n sa fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ne̱ ɔɔ be̱e̱ waa e̱taŋ fe̱yɛ, “Mo̱ e̱ waa e̱taŋ fe̱yɛ mo̱ e̱ sa fo̱ ke̱tɔ ke̱maa ne̱ fo̱ e̱ tɔwe̱ a fo̱ gywii mo̱ ɛ fo̱ e̱ kpa‑ɔ. Amo̱ e̱ gye̱ mo̱ swe̱e̱re̱‑ɔ ke̱be̱gya gbaa, mo̱ e̱ te̱ŋ a n sa fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","To, ne̱ kabregyii amo̱ a le̱e̱ mfe̱ŋ ya bise mò̱ nyi Hɛrɔde̱ya fe̱yɛ, “Nte̱tɔ ne̱ n tɔwe̱ ɛ mo̱ e̱ kpa‑ɔ ne̱e̱?” Ne̱ mò̱ nyi yɛ ɔ tɔwe̱ fe̱yɛ, “Yohanee Osuubɔpo̱‑ɔ kuŋu.” ");
INSERT INTO ncuNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mfe̱ŋ ne̱ kabregyii‑o a waa me̱naŋ ya tɔwe̱ gywii owure‑o fe̱yɛ, “Yohanee Osuubɔpo̱‑ɔ kuŋu ne̱ mo̱ e̱ kpa kyaŋse̱‑rɔ mbe̱yɔmɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","A mo̱ŋ gyi owure‑o akatɔ pɛɛɛ, amaa ane̱ŋ ne̱ ɔɔ kyɔ waa e̱taŋ gye̱maŋ‑ɔ‑rɔ se̱‑ɔ, ɔ mo̱ŋ taare̱ kine. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mfe̱ŋ ne̱ oo suŋ asoogyaa ne̱ ba kuŋ mò̱‑ɔ ɔko̱ fe̱yɛ ɔ yɔ mfe̱ŋ ne̱ baa tii Yohanee‑o ya tuwi mò̱ kuŋu baa. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ne̱ ɔɔ ya tuwi Yohanee Osuubɔpo̱ kuŋu bo̱ waa kyaŋse̱‑rɔ taa bo̱ sa kabregyii‑o, ne̱ mò̱‑ɔ mò̱ a taa yaa bo̱ sa mò̱ nyi. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yohanee a agyase̱po̱‑ɔ bo̱ko̱ a nu mò̱ lowi amo̱‑ɔ, ne̱ baa ya taa mò̱ kifuniŋ yaa pure. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","A mo̱ŋ kyee, ne̱ Yeesuu agyase̱po̱ ne̱ oo suŋ bamo̱ bo̱ kyo̱ŋwe̱ e̱maŋ se̱ fe̱yɛ bo̱ ya tɔwe̱ abware̱se̱ŋ‑ɔ a kiŋŋi bo̱ to̱ mò̱, ne̱ baa tɔwe̱ ke̱tɔ ke̱maa ne̱ baa waa‑ɔ, na atɔ ne̱ baa kaapo̱‑ɔ pɛɛɛ gywii mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ane̱ŋ ne̱ ase̱sɛ bwe̱e̱tɔ e̱ ba Yeesuu ase̱‑ɔ se̱‑ɔ, mò̱ aa mò̱ agyase̱po̱‑ɔ maa nya bamo̱ e̱ye̱e̱ a bo̱ gyi ateese. Amo̱se̱‑ɔ, ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱nꞌ sa a ane̱ yɔ mfe̱ŋ ne̱ a du diŋŋ‑o na mo̱nꞌ nya kyure kafwe̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ne̱ mò̱ aa bamo̱ wo̱re̱ a lwee ko̱re̱e̱‑ɔ‑rɔ ba kpa a bo̱ pare̱ yɔ mfe̱ŋ ne̱ a du diŋŋ‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ase̱sɛ bwe̱e̱tɔ mɔ a ŋu saŋ ne̱ baa yɔ‑ɔ, ne̱ baa kyɔ pini fe̱yɛ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ ne̱e̱. Mfe̱ŋ ne̱ ase̱sɛ biribiri a le̱e̱ mfe̱ŋ a e̱maŋ‑ɔ pɛɛɛ‑rɔ me̱raa se̱ bo̱ bɔ nkyu‑o e̱kɛɛkɛɛ se̱ bo̱ gya mò̱ se̱. Ne̱ baa se̱re̱ gye̱ mò̱ ŋkpɛɛ ya fo̱ mfe̱ŋ ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ e̱ kpa a bo̱ yɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ko̱re̱e̱‑ɔ a bo̱ daŋ, ne̱ Yeesuu a le̱e̱‑ɔ, ne̱ oo ŋu ase̱sɛ biribiri kyɔ bo̱ ye̱re̱ nkyu‑o kɛɛ bo̱ gywii mò̱. Ɔ mo̱ŋ lɛɛ kpa a ɔ kwaye̱ bamo̱, a le̱e̱ fe̱yɛ oo ŋu ane̱ŋ ne̱ bo̱ ye̱re̱ bo̱ du fe̱yɛ e̱sanne̱ ne̱ bo̱ mo̱ŋ de ɔde̱e̱re̱se̱po̱‑ɔ. Amo̱se̱‑ɔ, bamo̱ ase̱ŋ a waa mò̱ e̱wɛɛ. Amo̱se̱‑ɔ, ne̱ ɔɔ le̱e̱ ɔ kaapo̱ bamo̱ abware̱se̱ŋ bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Saŋ ne̱ kyɔwe̱ e̱ kpa a ɔ twɛɛ‑ɔ, ne̱ mò̱ agyase̱po̱‑ɔ a bo̱ tɔwe̱ gywii mò̱ fe̱yɛ, “Kyɔwe̱ a lo̱we̱. Amo̱ a gye̱ e̱fa‑rɔ‑ɔ se̱‑ɔ, sa a ase̱sɛ‑ɔ yɔ mmaŋgyii na e̱maŋ ne̱ e̱ maa mfe̱e̱‑ɔ‑rɔ na bo̱ nya ya sɔɔ ko̱tɔko̱ gyi.” ");
INSERT INTO ncuNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ne̱ Yeesuu a be̱ŋŋaa mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Mo̱ne̱ fɔŋfɔŋ sa bamo̱ ko̱tɔko̱ a bo̱ gyi.” Ne̱ baa be̱e̱ tɔwe̱ gywii Yeesuu fe̱yɛ, “Fo̱ e̱ kpa fe̱yɛ ane̱ nye̱ra siidii ŋkpe̱ŋ ŋnyɔ (GHC 2,000) bo̱ sɔɔ bodobodoo sa bamo̱ a bo̱ gyi ne̱e̱ e̱e̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","To, ne̱ Yeesuu a bise mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Bodobodoo akuri afe̱ne̱ ne̱ mo̱ne̱ de? Mo̱nꞌ ya ke̱e̱.” Bamo̱ a ya de̱e̱re̱‑ɔ, ne̱ baa bo̱ tɔwe̱ gywii mò̱ yɛ, “Ane̱ de bodobodoo akuri anuu na ŋkiŋgyi ŋnyɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Mfe̱ŋ ne̱ Yeesuu yɛ bo̱ ke ase̱sɛ‑ɔ‑rɔ bo̱ kye̱na e̱fa bo̱bwɛɛ ko̱ ne̱ e̱ bo̱ mfe̱ŋ‑ɔ se̱ ntuŋ si ntuŋ si. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ne̱ ase̱sɛ‑ɔ a kye̱na ntuŋ si kya abɛɛ se̱. Ntuŋ‑o ŋko̱‑rɔ ase̱sɛ bo̱ ke̱lafa, ne̱ ŋko̱‑rɔ mɔ ase̱sɛ bo̱ adunuu. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ne̱ Yeesuu a taa bodobodoo akuri anuu‑o na ŋkiŋgyi ŋnyɔ‑ɔ waa mò̱ asare̱e̱‑rɔ, ne̱ ɔɔ de̱e̱re̱ Wuribware̱ se̱, ne̱ ɔɔ sa Wuribware̱ aŋsɛ we̱e̱ se̱. Ne̱ ŋkee ɔɔ te̱ŋŋe̱‑rɔ pɛɛɛ bo̱ sa mò̱ agyase̱po̱‑ɔ, ne̱ baa ke‑ro sa ase̱sɛ‑ɔ pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bamo̱ pɛɛɛ a gyi bodobodoo‑o kpo̱ne̱, ne̱ baa wo̱ ŋkiŋgyi‑o kpo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ne̱ ŋkee mò̱ agyase̱po̱‑ɔ a taa ake kudu anyɔ swii bodobodoo na ŋkiŋgyi mpupuriase̱e̱ ne̱ ŋ ya saŋ‑ɔ bo̱ bo̱rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Bamo̱ ne̱ baa gyi ateese‑o, bamo̱ anyare̱‑ɔ wo̱re̱ bo̱ ŋkpe̱ŋ nnuu. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Amo̱‑ɔ kamɛɛ‑rɔ‑ɔ, ne̱ Yeesuu a sa ne̱ mò̱ agyase̱po̱‑ɔ a lwee ko̱re̱e̱‑ɔ‑rɔ gye̱ mò̱ ŋkpɛɛ yɔ Bɛtɛsaye̱da maŋ ko̱ ne̱ ɔ bo̱ Galile̱ya ke̱pare̱ dabe̱ a nno̱ŋ a bo̱ŋbe̱‑ɔ se̱‑ɔ. Ne̱ mò̱‑ɔ mò̱ a sii a ɔ sa lamaŋ kpa a bo̱ yɔ pe̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Mò̱ a brawe̱ ase̱sɛ‑ɔ‑rɔ pɛɛɛ bo̱ kyo̱ŋwe̱ bamo̱ e̱pe̱‑ɔ, ne̱ ɔɔ yɔ ke̱be̱e̱ ko̱ se̱ ya ko̱re̱ ke̱bware̱ko̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Bo̱ fo̱ kanye‑o, Yeesuu agyase̱po̱ a ko̱re̱e̱‑ɔ a fo̱ nkyu nse̱na, na Yeesuu mɔ wo̱re̱ bo̱ bo̱ŋbe̱ ne̱ baa le̱e̱‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ɔ ye̱re̱ mfe̱ŋ na ɔ ke̱e̱ ane̱ŋ ne̱ mò̱ agyase̱po̱‑ɔ a pare̱ ko̱re̱e̱‑ɔ kpo̱ne̱‑ɔ, a le̱e̱ fe̱yɛ ba pare̱ ba gyaŋŋaa afwii ne̱e̱. Amo̱se̱‑ɔ, bo̱ fo̱ gye̱gyaye̱ kese‑ro, ne̱ Yeesuu a nare̱ nkyu‑o si fe̱yɛ mò̱ a naa swe̱e̱re̱‑ɔ ya to̱ bamo̱, ɔ kpa a ɔ kyo̱ŋ bamo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Bamo̱ a ŋu mò̱ a naa nkyu‑o si‑o, bo̱ mo̱ŋ pini mò̱, amo̱se̱‑ɔ kufu a nya bamo̱ pɛɛɛ, ne̱ baa fɛɛ‑rɔ fe̱yɛ, “Kye̱ŋaŋpo̱ ne̱e̱!” ");
INSERT INTO ncuNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Mfe̱ŋ ne̱ Yeesuu a sa se̱ŋsa fe̱yɛ, “Mo̱ ne̱e̱! Mo̱nꞌ nya kakpo̱nɔ. Mo̱ne̱ ma sa a kufu nya mo̱ne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ne̱ oo lwee bamo̱ ko̱re̱e̱‑ɔ‑rɔ, ne̱ afwii‑o a yɔwe̱. Ne̱ mò̱ agyase̱po̱‑ɔ e̱ye̱e̱ a kpe̱ŋ bamo̱, ");
INSERT INTO ncuNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","a le̱e̱ fe̱yɛ bo̱ mo̱ŋ tɛɛ nu ane̱ŋ ne̱ Yeesuu a waa sa ne̱ ase̱sɛ ŋkpe̱ŋ nnuu‑o a gyi ateese‑o kpo̱ne̱‑ɔ kaase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ne̱ ŋkee baa me̱raa se̱ yɔ nkyu‑o si ya fo̱ Ginɛsarɛt ifuri si. Bamo̱ ko̱re̱e̱‑ɔ a bo̱ daŋ‑ɔ, ne̱ baa ŋure mò̱ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bamo̱ a le̱e̱ ko̱re̱e̱‑ɔ‑rɔ‑ɔ, ne̱ ase̱sɛ a kyɔ pini Yeesuu. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Amo̱se̱‑ɔ, ŋkee ase̱sɛ na bo̱ se̱re̱ ba kaa Ginɛsarɛt ifuri si ba kpa a bo̱ taa bamo̱ alɔpo̱ baa Yeesuu ase̱ ne̱e̱. Mfe̱ŋ ne̱ bamo̱ ya nu fe̱yɛ ɔ bo̱‑ɔ, amɔ baa taa bamo̱ ne̱ ba lɔ bo̱ da bamo̱ e̱kraŋ se̱‑ɔ yaa mò̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yeesuu a yɔ mmaŋgyii‑ro na e̱maŋ se̱ to̱ŋ ke̱maa‑ɔ, ne̱ ase̱sɛ a baa alɔpo̱ mò̱ ase̱ ke̱gya‑rɔ na alɔŋde̱ se̱ bo̱ ko̱re̱ mò̱ fe̱yɛ ɔ sa alɔpo̱‑ɔ de̱ŋ dabo̱rɔ mò̱ atɔ buŋsɛ. Ɔke̱maa ne̱ ɔɔ dabo̱rɔ amo̱‑ɔ mɔ a kpaare̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Saŋ ko̱, ne̱ Farisii awuye na Wuribware̱ mbraa akaapo̱po̱ ko̱ ne̱ baa le̱e̱ Yɛro̱salɛm maŋ‑nɔ‑ɔ a bo̱ ye̱re̱ muruwaa Yeesuu. ");
INSERT INTO ncuNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ne̱ baa ŋu fe̱yɛ mò̱ agyase̱po̱‑ɔ de asare̱e̱ ne̱ Yudaa awuye ase̱ a waa iyisi‑o ba gyi, a kaapo̱ ne̱e̱ fe̱yɛ bo̱ mo̱ŋ fwe̱e̱ asare̱e̱ ane̱ŋ ne̱ Farisii awuye‑o yɛ ase̱sɛ fwe̱e̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","4","Farisii awuye e̱ gye̱ ne̱ bo̱ gye̱ Yudaa awuye ŋkpɛɛ na bamo̱ ade̱daapo̱ a e̱kpa‑ɔ ke̱gyase̱ se̱. Ne̱ bamo̱ e̱ mo̱ŋ fwe̱e̱ asare̱e̱ fe̱yɛ ane̱ŋ ne̱ bamo̱ ade̱daapo̱‑ɔ a kaapo̱ bamo̱‑ɔ, bo̱ maa gyi. Bo̱ maa gyi ke̱gya‑rɔ atɔ na bo̱ mo̱ŋ fwe̱e̱ se̱ pwɛɛ. Bo̱ be̱e̱ bo̱ gya bamo̱ ade̱daapo̱ a e̱kpa‑ɔ bwe̱e̱tɔ se̱. Mmo̱ ŋko̱ e̱ gye̱ fe̱yɛ bo̱ de ane̱ŋ ne̱ ba fwe̱e̱ bamo̱ ato̱re̱nkyu‑ro na e̱gyare̱‑rɔ na nde̱ŋɛɛ‑rɔ na e̱dade̱sɛye̱‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Amo̱se̱‑ɔ ne̱ Farisii awuye‑o na Wuribware̱ mbraa akaapo̱po̱‑ɔ a bise Yeesuu fe̱yɛ, “Nte̱tɔ se̱ ne̱ fo̱ agyase̱po̱‑ɔ maa gya e̱kpa ne̱ ane̱ ade̱daapo̱‑ɔ a kaapo̱ ane̱‑ɔ se̱, ne̱ bo̱ de iyisi asare̱e̱ ba gyi ateese?” ");
INSERT INTO ncuNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “Mo̱ne̱ nnɔ ŋnyɔ ŋnyɔ awuye mɔ, saŋ ne̱ Wuribware̱ kyaamɛɛ Isaya a kyo̱rɛɛ ase̱ŋ ko̱ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ, mo̱ne̱ ase̱ŋ ne̱ ɔɔ tɔwe̱‑ɔ, ɔ mo̱ŋ ba aye̱ba. Ɔɔ kyo̱rɛɛ ne̱e̱ fe̱yɛ Wuribware̱ yɛ, ‘Ase̱sɛ mɔ de bamo̱ nnɔ kpaŋkpaŋ ne̱e̱ ba bo̱nyaa mo̱, amaa bamo̱ ŋkpo̱nɔ mo̱ŋ bo̱ mo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bamo̱ kusuŋ mɔ ne̱ ba suŋ mo̱‑ɔ gye̱ kwaa, ke̱ e̱ gye̱ ke̱gya mbraa na amaŋbe̱re̱ ne̱ dimaadi a kaapo̱‑ɔ se̱ dooo.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ne̱ Yeesuu yɛ, “Mo̱ne̱ fɔŋfɔŋ e̱kpa ne̱ mo̱ne̱ e̱ kaapo̱. A mo̱ŋ lɛɛ a gye̱ Wuribware̱ ase̱ŋ ne̱ mo̱ne̱ gya se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Mo̱ne̱ e̱ fa fe̱yɛ mo̱ne̱ de kanyiase̱ŋ mo̱ne̱ i kine Wuribware̱ a mbraa‑ɔ na mo̱nꞌ nya gya mo̱ne̱ ase̱sɛ a e̱kpa‑ɔ se̱‑ɔ, mo̱ne̱ e̱ waa nɛɛnɛɛ ne̱e̱ e̱e̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mo̱ne̱ nyi fe̱yɛ ane̱ mbraa‑ɔ ɔsapo̱ Mosis a sa mbraa ne̱e̱ fe̱yɛ, ‘Bu fo̱ se̱ na fo̱ nyi,’ na ‘Ɔke̱maa ne̱ ɔɔ lo̱ŋ mò̱ se̱ bɛɛɛ mò̱ nyi‑o, bo̱ mɔɔ mò̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Amaa mo̱ne̱ fe̱raa, mo̱ne̱ e̱ kaapo̱ ne̱e̱ fe̱yɛ ɔko̱ i de atanne̱ bɛɛɛ ke̱tɔ timaa ko̱ a ɔ bo̱ kya mò̱ se̱ na mò̱ nyi‑ro, ne̱ mò̱ ya tɛɛ tɔwe̱ fe̱yɛ, ‘Ke̱ gye̱ Ko̱re̱baŋ ne̱e̱’ (kaase̱ e̱ kaapo̱ fe̱yɛ ɔɔ kyɔ taa amo̱ sa Wuribware̱ na mò̱ kusuŋ, mbe̱yɔmɔ fe̱raa Wuribware̱ e̱ bo̱), mo̱ne̱ e̱ kaapo̱ ne̱e̱ fe̱yɛ se̱sɛ‑ɔ a nya mò̱ e̱ye̱e̱. Ne̱ mo̱ne̱ be̱e̱ mo̱ne̱ yɛ mò̱ se̱ na mò̱ nyi kitiri ne̱ ba wu‑o mo̱ŋ lɛɛ ke̱ gye̱ mò̱ ase̱ŋ ne̱e̱. Mò̱ ako̱we̱po̱‑ɔ atanne̱ ke̱sa maa kaapo̱ ne̱e̱ fe̱yɛ o bu bamo̱ ne̱e̱ e̱e̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mo̱ne̱ fɔŋfɔŋ a e̱kpa mɔ ne̱ mo̱ne̱ a kaapo̱‑ɔ se̱‑ɔ, Wuribware̱ a ase̱ŋ‑ɔ mo̱ŋ lɛɛ a gye̱ ko̱tɔko̱ mo̱ne̱ ase̱. Mfaanɛɛ dɛɛ ne̱ mo̱ne̱ e̱ waa atɔ bwe̱e̱tɔ ne̱ a mo̱ŋ bo̱ daŋ‑ɔ mo̱ne̱ i tii si.” ");
INSERT INTO ncuNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yeesuu a tɔwe̱ ase̱ŋ gywii Farisii awuye‑o na Wuribware̱ mbraa akaapo̱po̱‑ɔ lo̱we̱‑ɔ, ne̱ ɔɔ be̱e̱ te̱e̱ lamaŋ‑ɔ bo̱ gyaŋŋe̱ mò̱ ase̱, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ne̱ pɛɛɛ nu mo̱ ase̱ na mo̱nꞌ nu kaase̱ fe̱yɛ ");
INSERT INTO ncuNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","n gye̱ ke̱tɔ ne̱ se̱sɛ i gyi ɔ waa kame‑ro‑o e̱ gye̱ ne̱ ke̱ e̱ sa a ɔ waa iyisi. Amaa ke̱tɔ ne̱ ke̱ e̱ le̱e̱ mò̱ kanɔ‑rɔ‑ɔ e̱ gye̱ ne̱ ke̱ e̱ sa a ɔ waa iyisi.”  ");
INSERT INTO ncuNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Amo̱se̱‑ɔ ɔke̱maa ne̱ o de e̱se̱bɔ‑ɔ, o nu. ");
INSERT INTO ncuNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Mò̱ a tɔwe̱ ane̱ŋ lo̱we̱‑ɔ, ne̱ ɔɔ le̱e̱ ase̱sɛ amo̱ ase̱, ne̱ oo lwee lɔŋ‑nɔ. Ne̱ mò̱ agyase̱po̱‑ɔ yɛ ɔ kaapo̱ bamo̱ ke̱kpare̱ ne̱ ɔɔ da bamo̱‑ɔ kaase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ne̱ Yeesuu yɛ, “Ntɔ se̱ ne̱ mo̱ne̱ du fe̱yɛ ase̱sɛ amo̱‑ɔ ne̱e̱? Ntɔ se̱ ne̱ mo̱ne̱ mo̱ŋ nu ase̱ŋ amo̱ kaase̱‑ɔ ne̱e̱? Mo̱nꞌ nu fe̱yɛ n gye̱ se̱sɛ a ke̱tɔ ne̱ o gyi‑o e̱ gye̱ ne̱ ke̱ e̱ sa a ɔ waa iyisi, ");
INSERT INTO ncuNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","a le̱e̱ fe̱yɛ n gye̱ kakpo̱nɔ‑rɔ ne̱ atɔ gyisɛ e̱ yɔ. Amaa a yɔ kame‑ro ne̱e̱, na ɔ kɔ bo̱ twe̱e̱.” Yeesuu a tɔwe̱ amo̱‑ɔ, a kaapo̱ ne̱e̱ fe̱yɛ ɔ sa se̱sɛ kpa ne̱e̱ fe̱yɛ o gyi ke̱tɔ ke̱maa. ");
INSERT INTO ncuNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Mfe̱ŋ ne̱ Yeesuu a kya se̱ fe̱yɛ, “Se̱sɛ kakpo̱nɔ‑rɔ e̱ gye̱ ne̱ ka sa ne̱ ɔ waa iyisi. ");
INSERT INTO ncuNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","A le̱e̱ fe̱yɛ se̱sɛ kakpo̱nɔ‑rɔ ne̱ mfɛɛre̱ bɔye̱ e̱ le̱e̱, ne̱ ka sa ne̱ ɔ waa kakye̱e̱kpa bɛɛɛ kanyare̱kpa, ne̱ o ywii, ne̱ ɔ mɔɔ mò̱ bɛɛko̱, ");
INSERT INTO ncuNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ne̱ o pee akatɔ ɔ kpa atɔ, ne̱ o kisi mò̱ bɛɛko̱, ne̱ ɔ pe̱nna mò̱ bɛɛko̱, ne̱ ɔ ka ko̱kwe̱e̱, ne̱ ɔ te̱ŋ mò̱ bɛɛko̱ kanɔ, ne̱ ɔ kaapo̱ mò̱ e̱ye̱e̱, ne̱ ɔ waa nsape̱nnase̱ŋ, ne̱ ɔ waa ase̱ŋ bɔye̱ ke̱maa. ");
INSERT INTO ncuNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Asuŋ bɔye̱ na ase̱ŋ bɔye̱ mɔ pɛɛɛ a le̱e̱ nyiŋkpasɛ kakpo̱nɔ‑rɔ ne̱e̱, ne̱ a sa ne̱ ɔ waa iyisi.” ");
INSERT INTO ncuNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yeesuu a le̱e̱ mfe̱ŋ‑ɔ, ne̱ oo ywii le̱e̱ bamo̱ fɔŋfɔŋ Isireelii swe̱e̱re̱ se̱ yɔ ifuri ko̱ ne̱ ɔ da ɔ maa Tiro maŋ‑ɔ se̱, ya kyure kafwe̱e̱. Mò̱ a fo̱ maŋ ko̱ se̱ mfe̱ŋ‑ɔ, ne̱ oo lwee lɔŋ ko̱‑rɔ na ase̱sɛ ma nya ŋu fe̱yɛ ɔ bo̱ mfe̱ŋ. Amaa ɔ mo̱ŋ taare̱ kwe̱e̱rɔ mò̱ e̱ye̱e̱ bo̱ le̱e̱ ase̱sɛ kuŋu mò̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ɔkye̱e̱ ko̱ a de̱ŋ ŋu mò̱ a ba‑ɔ, ne̱ ɔɔ ba mò̱ ase̱. Ɔkye̱e̱ mɔ mo̱ŋ gye̱ Yudaanyi, ɔ gye̱ Siriya-Fonikiyanyi. Ɔ sa Griiki‑ro ne̱e̱. Ibrisi ko̱ te ɔkye̱e̱‑ɔ mò̱ kayaagyi kye̱e̱sɛ se̱. Ne̱ ɔɔ ba Yeesuu ase̱ mfe̱ŋ bo̱ kpuni aŋurii, ne̱ ɔɔ ko̱re̱ Yeesuu fe̱yɛ ɔ gya ibrisi ne̱ i te mò̱ gyi‑o si‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Amaa Yeesuu a be̱ŋŋaa mò̱ fe̱yɛ, “N de ateese mo̱ e̱ sa Wuribware̱ mò̱ gyi‑ana. Ne̱ mo̱ ya taa ako̱ sa bamo̱ ne̱ ane̱ ase̱sɛ e̱ te̱e̱ fe̱yɛ igyono‑o, a bware aaa? Wuribware̱ mò̱ gyi‑ana i gyi pwɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ne̱ ɔkye̱e̱ amo̱ yɛ, “To, mo̱ a nu, mo̱ nyaŋpe̱, amaa igyono maa kisi ŋyaagyi a nnɔwo̱re̱ ne̱ ŋ ya le̱e̱ da swe̱e̱re̱‑ɔ kigyi.” ");
INSERT INTO ncuNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Mò̱ a tɔwe̱ ane̱ŋ‑ɔ, ne̱ Yeesuu mɔ a be̱e̱ tɔwe̱ gywii mò̱ fe̱yɛ, “Ane̱ŋ ne̱ fo̱ a be̱ŋŋaa mo̱ nɛɛnɛɛ‑ɔ se̱‑ɔ, kiŋŋi nare̱ pe̱. Fo̱ e̱ ya to̱ fe̱yɛ ibrisi‑o a ko̱so̱ fo̱ gyi‑o si.” ");
INSERT INTO ncuNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kase̱ŋtiŋ, ɔɔ ya to̱ fe̱yɛ mò̱ gyi‑o da mpaa se̱ na ibrisi‑o a ko̱so̱ mò̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Amo̱‑ɔ kamɛɛ‑ɔ, ne̱ Yeesuu a le̱e̱ Tiro a ifuri‑o si bo̱rɔ Sidɔŋ maŋ ya kyo̱ŋ Galile̱ya ke̱pare̱ dabe̱‑ɔ se̱ ya yɔ Dekapolis ifuri si. ");
INSERT INTO ncuNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mfe̱ŋ ne̱ ase̱sɛ ko̱ a baa ɔnyare̱ ko̱ ne̱ ɔ gye̱ kpawu na kamu‑o bo̱ ko̱re̱ Yeesuu fe̱yɛ ɔ ba mò̱ ke̱sare̱e̱ bo̱ dabo̱rɔ mò̱ na ɔ kpaare̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ne̱ Yeesuu a taa ɔlɔpo̱‑ɔ le̱e̱ lamaŋ‑ɔ‑rɔ yɔ keri si. Ne̱ ɔɔ ba mò̱ asare̱e̱gyi waa mò̱ e̱se̱bɔ‑rɔ, ne̱ ɔɔ twe̱e̱ ko̱kyɔne̱ we̱e̱ mò̱ fɔŋfɔŋ ke̱sare̱e̱gyi si, ne̱ ɔ bo̱ dabo̱rɔ ɔnyare̱‑ɔ gyeepu si. ");
INSERT INTO ncuNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ne̱ Yeesuu a de̱e̱re̱ so̱so̱, ne̱ oo keŋŋi‑ro, ne̱ ɔɔ tɔwe̱ gywii ɔnyare̱‑ɔ Heebrii se̱ŋsa‑rɔ fe̱yɛ, “Ifata.” Kaase̱ e̱ kaapo̱ fe̱yɛ, “Taye̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mfe̱ŋ ne̱ ɔnyare̱‑ɔ e̱se̱bɔ a taye̱, ne̱ oo nu ase̱ŋ, ne̱ ɔɔ be̱e̱ le̱e̱ ɔ sa se̱ŋsa nɛɛnɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ne̱ Yeesuu a tɔwe̱ gywii ase̱sɛ ne̱ baa taa ɔlɔpo̱‑ɔ baa‑ɔ fe̱yɛ bo̱ ma kaŋ tɔwe̱ ase̱ŋ‑ɔ gywii ɔko̱. Amaa mò̱ a tɔwe̱ ane̱ŋ‑ɔ gbaa, ne̱ baa le̱e̱ ba tɔwe̱ ba gywii ase̱sɛ bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ne̱ e̱ye̱e̱ a kpe̱ŋ bamo̱ ne̱ baa tɔwe̱ ase̱ŋ‑ɔ gywii bamo̱‑ɔ. Ne̱ bo̱ yɛ, “Ke̱e̱ ane̱ŋ ne̱ ɔ waa mò̱ ke̱tɔ ke̱maa nɛɛnɛɛ‑ɔ. Ɔ taye̱ akpawu e̱se̱bɔ, ne̱ ɔ kya mmu, ne̱ ba sa se̱ŋsa nɛɛnɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ke̱tɔ mo̱ŋ kyee, ne̱ ase̱sɛ bwe̱e̱tɔ a be̱e̱ bo̱ gyaŋŋe̱ Yeesuu ase̱. Ase̱sɛ amo̱ a mo̱ŋ lɛɛ bo̱ de ateese gyisɛ‑ɔ, ne̱ Yeesuu a te̱e̱ mò̱ agyase̱po̱‑ɔ, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Mo̱ne̱ ke̱e̱ ase̱sɛ de̱maŋte̱ mɔ aaa? Bamo̱ ase̱ŋ bo̱ mo̱ e̱wɛɛ, a le̱e̱ fe̱yɛ bamo̱ a ba mo̱ ase̱ mfe̱e̱ bo̱ nu mo̱ atɔ ke̱kaapo̱‑ɔ, ŋke nsa ne̱e̱. Amo̱se̱‑ɔ, bamo̱ ateese pɛɛɛ a lo̱we̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ne̱ mo̱‑ɔ mo̱ ya sa ne̱ baa yɔ e̱pe̱ na mo̱ŋ sa bamo̱ ateese, ako̱ŋ e̱ mɔɔ bo̱ko̱ kpa‑rɔ, a le̱e̱ fe̱yɛ bamo̱ bwe̱e̱tɔ a le̱e̱ ke̱fɔ ke̱fɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ne̱ mò̱ agyase̱po̱‑ɔ a bise mò̱ fe̱yɛ, “Kimukee mɔ‑rɔ mfe̱ne̱ ne̱ ɔko̱ e̱ waa a ɔ nya ase̱sɛ de̱maŋte̱ mɔ kanɔ se̱ ateese?” ");
INSERT INTO ncuNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","To, ne̱ Yeesuu a bise bamo̱ fe̱yɛ, “Bodobodoo akuri afe̱ne̱ ne̱ mo̱ne̱ de?” Ne̱ agyase̱po̱‑ɔ a be̱ŋŋaa fe̱yɛ, “Bodobodoo akuri asunoo.” ");
INSERT INTO ncuNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Amo̱ fe̱raa ne̱ ɔɔ sa ne̱ ase̱sɛ‑ɔ pɛɛɛ mɔ a kye̱na swe̱e̱re̱. Ne̱ ɔɔ sa Wuribware̱ aŋsɛ we̱e̱ bodobodoo akuri asunoo‑o si, ne̱ ɔɔ te̱ŋŋe̱‑rɔ, ne̱ ɔɔ taa sa mò̱ agyase̱po̱‑ɔ fe̱yɛ bo̱ ke‑ro sa bamo̱. Ne̱ baa ke‑ro sa ase̱sɛ‑ɔ pɛɛɛ mɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bo̱ de ŋkiŋgyi ngyingyii kafwe̱e̱ ko̱, ne̱ ɔɔ sa Wuribware̱ aŋsɛ we̱e̱ mmo̱ se̱, ne̱ ɔɔ sa ne̱ mò̱ agyase̱po̱‑ɔ a be̱e̱ ke‑ro sa ase̱sɛ‑ɔ pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Ne̱ ɔke̱maa a gyi kpo̱ne̱. Ase̱sɛ‑ɔ bo̱ ŋkpe̱ŋ nna. Ne̱ mò̱ agyase̱po̱‑ɔ a swii ateese mpupuriase̱e̱‑ɔ bo̱ bo̱rɔ ake asunoo. Ne̱ ɔɔ sa ne̱ ase̱sɛ‑ɔ pɛɛɛ mɔ a brawe̱‑rɔ yɔ e̱pe̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ne̱ mò̱ aa mò̱ agyase̱po̱‑ɔ a lwee ko̱re̱e̱‑rɔ yɔ mfe̱ŋ ne̱ ba te̱e̱ ɛ Dalamanuta‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bamo̱ a fo̱ mfe̱ŋ‑ɔ, ne̱ Farisii awuye ko̱ a ba Yeesuu ase̱ na bo̱ ŋu fe̱yɛ mò̱ ke̱yaale̱ŋ ne̱ o de ɔ waa akpe̱ŋe̱ye̱e̱tɔ‑ɔ a le̱e̱ Wuribware̱ ase̱ kase̱ŋtiŋ ne̱e̱ bɛɛɛ. Ne̱ bo̱ yɛ, “Sa a ko̱tɔko̱ le̱e̱ Wuribware̱ se̱ na ane̱ nya ŋu fe̱yɛ Wuribware̱ bo̱ fo̱ ase̱ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ne̱ Yeesuu yɛ, “Abaa! Nte̱tɔ se̱ ne̱ mo̱ne̱ ndɔɔ a kaye̱ a ase̱sɛ‑ɔ e̱ kpa fe̱yɛ ŋ waa ko̱tɔko̱ pwɛɛ na mo̱nꞌ dɛɛ ŋu fe̱yɛ mo̱ e̱le̱ŋ‑ɔ a le̱e̱ Wuribware̱ ase̱ ne̱e̱? Daabii! Mo̱ e̱ tɔwe̱ a n gywii mo̱ne̱ fe̱yɛ ma waa ko̱tɔko̱ a m bo̱ kaapo̱ mo̱ne̱ fe̱yɛ mo̱ e̱le̱ŋ‑ɔ a le̱e̱ Wuribware̱ ase̱ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ne̱ ɔɔ le̱e̱ bamo̱ ase̱ mfe̱ŋ ya lwee ko̱re̱e̱‑ɔ‑rɔ yɔ ke̱pare̱ dabe̱‑ɔ nno̱ŋ a bo̱ŋbe̱‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yeesuu agyase̱po̱‑ɔ mɔ a taŋ se̱ bo̱ mo̱ŋ baa bodobodoo ane̱ŋ ne̱ ɔ fo̱ bamo̱‑ɔ. Amo̱se̱‑ɔ, bodobodoo kukuri ko̱ŋko̱ wo̱re̱ e̱ bo̱ bamo̱ ase̱ ko̱re̱e̱‑ɔ‑rɔ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Mfe̱ŋ ne̱ Yeesuu a yii bamo̱ se̱ fe̱yɛ, “Mo̱nꞌ sa Farisii awuye na Owure Hɛrɔd se̱, a le̱e̱ fe̱yɛ bo̱ de yiisi ko̱ ba waa bodobodoo ne̱ o tiŋ‑o na ɔ mo̱ŋ bo̱ kɔne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","To, ne̱ mò̱ agyase̱po̱‑ɔ a le̱e̱ ba tɔwe̱ ba gywii abɛɛ fe̱yɛ, “Ane̱ŋ ne̱ ane̱ mo̱ŋ de bodobodoo‑o si ne̱ ɔɔ tɔwe̱ ane̱ŋ‑ɔ, bɛɛɛ?” ");
INSERT INTO ncuNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yeesuu mɔ a nyi ke̱tɔ ne̱ ba tɔwe̱‑ɔ se̱‑ɔ, ne̱ oo bise bamo̱ fe̱yɛ, “Ntɔ ne̱e̱ ne̱ mo̱ne̱ e̱ tɔwe̱ mo̱ne̱ ke̱‑mo̱ŋ‑de bodobodoo ase̱ŋ? Mo̱ne̱ mo̱ŋ tɛɛ nu mo̱ ke̱kaapo̱‑ɔ kaase̱ ne̱e̱ bɛɛɛ? Mo̱ne̱ mfɛɛre̱ maa waa kusuŋ ne̱e̱ e̱e̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Mo̱ne̱ de akatɔ, bɛɛɛ mo̱ne̱ mo̱ŋ ke̱e̱ ne̱e̱ e̱e̱e̱? Mo̱ne̱ de e̱se̱bɔ, bɛɛɛ mo̱ne̱ maa nu ase̱ŋ ne̱e̱ e̱e̱e̱? Mo̱ne̱ mo̱ŋ nyiŋŋi saŋ ne̱ mo̱ a te̱ŋŋe̱ bodobodoo akuri anuu‑o‑ro sa ase̱sɛ ŋkpe̱ŋ nnuu‑o si ne̱e̱ e̱e̱e̱? Ake afe̱ne̱ ne̱ mo̱ne̱ a swii mpupuriase̱e̱‑ɔ waa‑rɔ?” Ne̱ bo̱ yɛ, “Kudu anyɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ne̱ Yeesuu yɛ, “Ne̱ mo̱ a be̱e̱ te̱ŋŋe̱ bodobodoo akuri asunoo‑o‑ro sa ase̱sɛ ŋkpe̱ŋ nna‑ɔ, ake afe̱ne̱ ne̱ mo̱ne̱ a be̱e̱ swii mpupuriase̱e̱‑ɔ waa‑rɔ?” Ne̱ bo̱ yɛ, “Asunoo.” ");
INSERT INTO ncuNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ne̱ Yeesuu a bise bamo̱ fe̱yɛ, “Ne̱ mo̱ne̱ saŋ mo̱ne̱ maa nu mo̱ kaase̱ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ a yɔ maŋ ko̱ ne̱ ba te̱e̱ ɛ Bɛtɛsaye̱da‑ɔ‑rɔ. Mfe̱ŋ ne̱ ase̱sɛ ko̱ a taa te̱napo̱ nyare̱ ko̱ baa Yeesuu ase̱ fe̱yɛ ɔ dabo̱rɔ mò̱ na ɔ kpaare̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ne̱ Yeesuu a kra te̱napo̱‑ɔ ke̱sare̱e̱‑rɔ, ne̱ ɔɔ gye̱ mò̱ ŋkpɛɛ, ne̱ mò̱ aa mò̱ a le̱e̱ maŋ‑ɔ‑rɔ yɔ keri si. Mfe̱ŋ ne̱ Yeesuu a twe̱e̱ ko̱kyɔne̱ waa te̱napo̱‑ɔ akatɔgyi‑ro. Ne̱ Yeesuu a be̱e̱ ba asare̱e̱ bo̱ dɔŋŋɔ amo̱ se̱, ne̱ oo bise mò̱ fe̱yɛ, “Fo̱ ke̱e̱ ko̱tɔko̱ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Amɔ te̱napo̱‑ɔ a yase̱ akatɔ, ne̱ ɔ yɛ, “Ɔɔŋ, ŋ ke̱e̱ ase̱sɛ, amaa bo̱ du ne̱e̱ fe̱yɛ ayii‑o bo̱ naa.” ");
INSERT INTO ncuNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","To, ne̱ Yeesuu a be̱e̱ ba asare̱e̱ bo̱ dɔŋŋɔ mò̱ akatɔgyi‑o si. Ŋkee fe̱raa ɔnyare̱‑ɔ a nyeyi akatɔ‑ɔ, ɔ ke̱e̱ ke̱tɔ ke̱maa dame̱naŋsɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ne̱ Yeesuu yɛ ɔ nare̱ pe̱, amaa ɔ ma kaŋ kiŋŋi yɔ maŋ‑ɔ‑rɔ ya tɔwe̱ ke̱tɔ ne̱ kaa waa mò̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Amo̱‑ɔ a kyo̱ŋ‑ɔ, ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ a yɔ mmaŋgyii ko̱ ne̱ m maa maŋ ne̱ ba te̱e̱ ɛ Kaye̱sare̱ya Filipii‑o‑ro. Bamo̱ a naa ba yɔ‑ɔ, ne̱ oo bise bamo̱ fe̱yɛ, “Mo̱nꞌ tɔwe̱ ane̱ŋ ne̱ ase̱sɛ e̱ te̱e̱ mo̱‑ɔ gywii mo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ne̱ baa be̱ŋŋaa mò̱ fe̱yɛ, “Bo̱ko̱ yɛ fo̱ gye̱ Wuribware̱ a akyaamɛɛ ne̱ baa dɛɛ kye̱na‑ɔ ɔko̱ ne̱ oo kyiŋŋi le̱e̱ lowi‑ro, fe̱yɛ Yohanee Osuubɔpo̱‑ɔ, bɛɛɛ Iliya‑o ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ne̱ oo bise mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Ne̱ mo̱ne̱ mɔ mo̱ne̱ yɛ nsɛ e̱ gye̱ mo̱‑ɔ ne̱e̱?” Ne̱ Peetroo a be̱ŋŋaa fe̱yɛ, “Fo̱ e̱ gye̱ Kristoo ne̱ Wuribware̱ a suŋ ane̱ ase̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ne̱ Yeesuu a yii bamo̱ se̱ fe̱yɛ, “Mo̱ne̱ ma kaŋ tɔwe̱ amo̱‑ɔ gywii ɔke̱maa.” ");
INSERT INTO ncuNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Amo̱ kamɛɛ‑rɔ, ne̱ Yeesuu a le̱e̱ ɔ kaapo̱ mò̱ agyase̱po̱‑ɔ. Ɔ yɛ, “A tiri fe̱yɛ mo̱, dimaadi mò̱ gyi‑o, ŋu ase̱ŋ bwe̱e̱tɔ, na maŋ abre̱sɛ‑ɔ na Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na Wuribware̱ mbraa akaapo̱po̱‑ɔ pɛɛɛ kine mo̱, na bo̱ mɔɔ mo̱, amaa ke̱mo̱ ŋke nsa na n kyiŋŋi le̱e̱ lowi‑ro.” ");
INSERT INTO ncuNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ɔɔ kaapo̱ bamo̱ amo̱‑ɔ‑rɔ nɛɛnɛɛ. Amo̱se̱‑ɔ, ne̱ Peetroo a lee mò̱ keri si, ne̱ ɔɔ tɔwe̱ gywii mò̱ fe̱yɛ ɔ ma lɛɛ tɔwe̱ ane̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Amaa Yeesuu a buruwaa ne̱e̱ de̱e̱re̱ mò̱ agyase̱po̱‑ɔ, ne̱ ɔɔ tɔwe̱ gywii Peetroo fe̱yɛ, “Ɔbɔnsam, le̱e̱ mo̱ ase̱. Fo̱ mfɛɛre̱ mo̱ŋ le̱e̱ Wuribware̱ ase̱, se̱sɛ mfɛɛre̱ ne̱ fo̱ de.” ");
INSERT INTO ncuNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Mfe̱ŋ ne̱ Yeesuu a te̱e̱ mò̱ agyase̱po̱‑ɔ na lamaŋ ne̱ bo̱ gya mò̱ se̱‑ɔ baa mò̱ ase̱, ne̱ ɔɔ tɔwe̱ gywii bamo̱ ɛ, “Ɔko̱ ne̱ ɔ kpa a ɔ gya mo̱ se̱‑ɔ, yɔwe̱ ko̱waa ke̱tɔ ne̱ ke̱ e̱ pre̱ mò̱‑ɔ, na ɔ so̱rɔ mò̱ fɔŋfɔŋ kiyii kpare̱-abɛɛ‑rɔ gya mo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","A le̱e̱ fe̱yɛ ɔko̱ ne̱ ɔ kpa a ɔ nya mò̱ e̱ye̱e̱ le̱e̱ lowi ase̱‑ɔ, lowi e̱ nya mò̱ nsu pɛɛɛ. Ɔko̱ mɔ ne̱ o kperi mo̱ aa ase̱ŋ timaa ko̱tɔwe̱ se̱ na o wu‑o e̱ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","To̱nɔ mo̱ ne̱ se̱sɛ e̱ nya fe̱yɛ mò̱ a nya kaye̱‑rɔ atɔ pɛɛɛ, na bo̱ le̱e̱ ane̱ŋ se̱‑ɔ na ɔ paŋ kye̱nakpa Wuribware̱ ase̱? A mo̱ŋ de to̱nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Se̱sɛ ya paŋ kye̱nakpa Wuribware̱ ase̱, sɛye̱ mo̱ŋ bo̱‑rɔ ne̱ ɔ taare̱ a ɔ bo̱ sɔɔ kye̱nakpa amo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ɔko̱ ne̱ ɔ maa kpa fe̱yɛ ase̱sɛ pini fe̱yɛ ɔ gye̱ mo̱ ɔgyase̱po̱‑ɔ, ne̱ ɔ maa kpa a ɔ gya mo̱ ke̱kaapo̱ se̱ ndɔɔ a kaye̱ bɔye̱ mɔ‑rɔ‑ɔ, amo̱ fe̱raa mo̱, dimaadi mò̱ gyi‑o, gbaa mo̱ i kine mò̱ kipini saŋ ne̱ Wuribware̱ a ke̱laŋŋe̱rɔ‑ɔ e̱ le̱e̱ so̱so̱ a ko̱ we̱e̱ swe̱e̱re̱ se̱, na ase̱sɛ pɛɛɛ ŋu n se̱ Wuribware̱ a ke̱dabe̱ na wuraa‑o saŋ ne̱ mo̱ aa Wuribware̱ mbɔɔ‑ɔ e̱ ba‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Mo̱ e̱ tɔwe̱ a n gywii mo̱ne̱ fe̱yɛ bo̱ko̱ bo̱ mfe̱e̱ na bo̱ ma wu, amɔ baa ŋu Wuribware̱ a kuwure‑o na ke̱mo̱ e̱le̱ŋ‑ɔ pwɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ŋke nsiye a kyo̱ŋ‑ɔ, ne̱ Yeesuu a lee Peetroo na Yakubu na Yohanee bo̱ tii mò̱ e̱ye̱e̱ se̱, ne̱ baa yɔ ke̱be̱e̱ ko̱ so̱so̱ bamo̱ wo̱re̱. Bamo̱ akatɔ‑rɔ mfe̱ŋ, ne̱ baa ŋu fe̱yɛ Yeesuu a kyurowi. ");
INSERT INTO ncuNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ne̱ mò̱ atɔ buŋsɛ a kii afufuri pare̱pare̱pare̱ a to̱re̱ se̱. Ɔko̱ maa taare̱ a ɔ fwe̱e̱ atɔ kaye̱ mɔ‑rɔ na a waa pare̱pare̱ ane̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Puri amo̱‑rɔ ne̱ baa ŋu fe̱yɛ anyare̱ anyɔ na Yeesuu ye̱re̱ na ba sa se̱ŋsa. Ne̱ baa pini fe̱yɛ Wuribware̱ mbraa ɔsapo̱ Mosis na Wuribware̱ kyaamɛɛ Iliya ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Kufu a nya agyase̱po̱ asa‑ɔ, ne̱ bo̱ mo̱ŋ lɛɛ bo̱ nyi ane̱ŋ ne̱ ba tɔwe̱‑ɔ. Ne̱ Peetroo a tɔwe̱ gywii Yeesuu fe̱yɛ, “Ɔkaapo̱po̱, a bware fe̱yɛ ane̱ a bo̱ mfe̱e̱. Ane̱ e̱ waa abwii asa, fo̱ ko̱ŋko̱, na Mosis ko̱ŋko̱, na Iliya ko̱ŋko̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mfe̱ŋ ne̱ ko̱wo̱re̱ a le̱e̱ bo̱ ba ke̱mo̱ kuyayu bo̱ dɔŋŋɔ bamo̱ se̱. Ne̱ bo̱re̱ ko̱ a le̱e̱ ko̱wo̱re̱‑ɔ‑rɔ tɔwe̱ fe̱yɛ, “Mo̱nꞌ ke̱e̱ mo̱ gyi timaa ne̱ mo̱ e̱ kpa mò̱ ase̱ŋ bwe̱e̱tɔ‑ɔ. Mo̱nꞌ nu mò̱ ase̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","To, ne̱ mò̱ agyase̱po̱ asa‑ɔ a kii de̱e̱re̱ muruwaa bo̱ mo̱ŋ ŋu sɛye̱, amɔ Yeesuu wo̱re̱, ne̱ baa ŋu na ɔ ye̱re̱ bamo̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bamo̱ a kpo̱ro̱we̱ ke̱be̱e̱‑ɔ se̱ ba ba kaase̱‑ɔ, ne̱ Yeesuu a yii bamo̱ se̱ fe̱yɛ, “Mo̱ne̱ ma kaŋ tɔwe̱ ke̱tɔ ne̱ mo̱ne̱ a ŋu‑o gywii ɔko̱, amɔ bo̱ fo̱ saŋ ne̱ mo̱, dimaadi mò̱ gyi‑o, a kyiŋŋi le̱e̱ lowi‑ro.” ");
INSERT INTO ncuNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Baa nu mò̱ kanɔ‑ɔ, amaa bamo̱ wo̱re̱ wo̱re̱ a le̱e̱ ba tɔwe̱ amo̱ ase̱ŋ fe̱yɛ, “Nte̱tɔ ne̱ ‘kikyiŋŋi le̱e̱ lowi‑ro’ mɔ e̱ kaapo̱‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ne̱ baa bise Yeesuu fe̱yɛ, “Nte̱tɔ se̱ ne̱ Wuribware̱ mbraa akaapo̱po̱‑ɔ e̱ tɔwe̱ fe̱yɛ Iliya amo̱ ne̱ ane̱ a ŋu‑o e̱ gye̱ ne̱ ɔ gye̱ Kristoo ŋkpɛɛ a ɔ ba‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Mò̱ kanɔlee e̱ gye̱ fe̱yɛ, “Iliya e̱ gye̱ ne̱ ɔ gye̱ ŋkpɛɛ a ɔ ba na ɔ nya bo̱ lɔŋŋɔ e̱kpa‑ɔ‑rɔ. To, ne̱ ntɔ se̱ ne̱ abware̱se̱ŋ wo̱re̱‑ɔ yɛ mo̱, dimaadi mò̱ gyi‑o, i ŋu ase̱ŋ bwe̱e̱tɔ na bo̱ kine mo̱‑ɔ ne̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Amaa mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ Iliya a kyɔ ba, ne̱ ase̱sɛ a waa mò̱ ane̱ŋ ne̱ baa kpa‑ɔ, fe̱yɛ ane̱ŋ ne̱ baa kyo̱rɛɛ mò̱ ase̱ŋ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Saŋ ne̱ Yeesuu na Peetroo na Yakubu na Yohanee a kiŋŋi ya tii agyase̱po̱ ne̱ baa saŋ‑ɔ se̱‑ɔ, ne̱ baa ya to̱ fe̱yɛ Wuribware̱ mbraa akaapo̱po̱ ko̱ na bamo̱ i gyiiri ikii, ne̱ ase̱sɛ bwe̱e̱tɔ ye̱re̱ muruwaa bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Aa kpe̱ŋ ase̱sɛ e̱ye̱e̱ fe̱yɛ bamo̱ a ŋu Yeesuu saŋ amo̱, amo̱se̱‑ɔ ne̱ baa ŋwɛɛnaŋ ya ka mò̱ kanɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ne̱ Yeesuu a bise mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Nte̱tɔ se̱ ne̱ mo̱ne̱ aa bamo̱ i gyiiri ikii‑o ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ne̱ ase̱sɛ‑ɔ‑rɔ ɔko̱ a be̱ŋŋaa fe̱yɛ, “Ɔkaapo̱po̱, mo̱ a baa mo̱ kagyinyaŋsɛɛ fo̱ ase̱ ne̱e̱. Ibrisi ko̱ te mò̱ se̱‑ɔ se̱‑ɔ, ɔ maa taare̱ a ɔ sa se̱ŋsa. ");
INSERT INTO ncuNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Saŋ ke̱maa ne̱ ibrisi amo̱ ya ba mò̱ se̱, e̱e̱ twe̱e̱ mò̱ ne̱e̱ a e̱ bo̱ da swe̱e̱re̱ ne̱e̱ fe̱yɛ mò̱ a lɔ kigbuŋgbuŋ‑o na ɔ twe̱e̱ mò̱ asare̱e̱ na ayaa, na mò̱ kanɔ‑rɔ e̱ le̱e̱ afwii na o duŋ abwanɔ, amɔ mò̱ kayo̱wɔre̱ a wo̱re̱. Ŋ yɛ fo̱ agyase̱po̱‑ɔ gya ibrisi‑o bo̱ ko̱so̱ mò̱ se̱, bamo̱‑ɔ bo̱ mo̱ŋ taare̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ne̱ Yeesuu a tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Ke̱se̱bɔrɔle̱ŋ awuye mɔ, mo̱ne̱ maa kɔɔre̱ mo̱ mo̱ne̱ i gyi. Nsu mfe̱ne̱ ne̱ mo̱ne̱ e̱ kpa fe̱yɛ mo̱ aa mo̱ne̱ a kye̱na? Bɛɛɛ nsu mfe̱ne̱ ne̱ mo̱ne̱ e̱ kpa fe̱yɛ ŋ nyite mo̱ne̱ pwɛɛ na mo̱nꞌ dɛɛ kɔɔre̱ mo̱ gyi‑o ne̱e̱? Mo̱nꞌ taa kanyaŋsɛɛ‑ɔ baa mo̱ ase̱ mfe̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ne̱ baa taa mò̱ baa Yeesuu ase̱. Ibrisi amo̱ a de̱ŋ ŋu Yeesuu‑o, ne̱ e̱ ya twe̱e̱ kanyaŋsɛɛ‑ɔ bo̱ da swe̱e̱re̱ fe̱yɛ mò̱ a lɔ kigbuŋgbuŋ‑o ɔ twe̱e̱ mò̱ asare̱e̱ na ayaa na ɔ da o kuroŋ, na mò̱ kanɔ‑rɔ e̱ le̱e̱ afwii. ");
INSERT INTO ncuNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ne̱ Yeesuu a bise kanyaŋsɛɛ‑ɔ mò̱ se̱ fe̱yɛ, “Nsu mfe̱ne̱ ne̱e̱ fe̱yɛ mò̱ a nya ko̱lɔ mɔ?” Ne̱ mò̱ se̱ yɛ, “Le̱e̱ saŋ ne̱ ɔ gye̱ kagyingyii‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Iluwi bwe̱e̱tɔ ibrisi amo̱ a twe̱e̱ mò̱ waa de̱e̱kpa‑rɔ na nkyu‑ro e̱e̱ kpa a e̱ mɔɔ mò̱. Amo̱se̱‑ɔ ŋu ane̱ e̱wɛɛ na fo̱ e̱ taare̱ na fo̱ kya ane̱‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ne̱ Yeesuu yɛ, “Nte̱tɔ ne̱ ‘ke̱taare̱ kya ane̱‑rɔ’ mɔ e̱ kaapo̱‑ɔ ne̱e̱? Fo̱ ya kɔɔre̱ gyi fe̱yɛ mo̱ e̱ taare̱ a n kya mò̱ fe̱raa, mo̱ e̱ kya mò̱. A le̱e̱ fe̱yɛ ke̱tɔ ke̱maa e̱ taare̱ a ko̱ waa sa bamo̱ ne̱ ba kɔɔre̱ ba gyi‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Amo̱ fe̱raa ne̱ mò̱ se̱ a faa‑rɔ fe̱yɛ, “Mo̱ e̱ kɔɔre̱ fo̱ mo̱ i gyi kafwe̱e̱. Kya mo̱‑rɔ na ŋ nya kɔɔre̱ fo̱ gyi bwe̱e̱tɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yeesuu a ŋu fe̱yɛ ase̱sɛ e̱ kpɔwe̱ ba buŋ mò̱ se̱‑ɔ, ne̱ ɔɔ tɔwe̱ gywii ibrisi ne̱ i te kanyaŋsɛɛ‑ɔ se̱‑ɔ fe̱yɛ, “Ibrisi, fo̱ ne̱ fo̱ a waa mò̱ kpawu na kamu‑o, ko̱so̱ kanyaŋsɛɛ amo̱ se̱ na fo̱ ma lɛɛ kye̱na mò̱ se̱ daa.” ");
INSERT INTO ncuNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Mfe̱ŋ ne̱ ibrisi ne̱ i te kanyaŋsɛɛ‑ɔ se̱‑ɔ a faa‑rɔ, ne̱ e̱ ya be̱e̱ sa ne̱ ɔɔ twe̱e̱ mò̱ asare̱e̱ na ayaa, ne̱ e̱ ya ko̱so̱ mò̱ se̱. Kanyaŋsɛɛ‑ɔ da swe̱e̱re̱ ne̱e̱ fe̱yɛ kifuniŋ‑o, ne̱ ŋkee ɔke̱maa yɛ, “Oo wu.” ");
INSERT INTO ncuNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Amaa Yeesuu a kra mò̱ ke̱sare̱e̱‑rɔ ne̱e̱ bo̱ ko̱so̱, ne̱ ɔɔ ye̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Amo̱ kamɛɛ‑rɔ Yeesuu a yɔ ɔ bo̱ lɔŋ‑nɔ‑ɔ, ne̱ mò̱ agyase̱po̱‑ɔ a bise mò̱ fe̱yɛ, “Nte̱tɔ se̱ ne̱ ane̱ mo̱ŋ taare̱ gya ibrisi amo̱‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ne̱ ɔɔ be̱ŋŋaa bamo̱ fe̱yɛ, “Sɛye̱ maa taare̱ a a gya ane̱ŋ a ibrisi‑o, amɔ mo̱ne̱ a ko̱re̱ ke̱bware̱ko̱re̱ ne̱ mo̱ne̱ a kra ako̱ŋ pwɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ a le̱e̱ mfe̱ŋ‑ɔ, ne̱ baa bo̱rɔ Galile̱ya swe̱e̱re̱ se̱. Ɔ mo̱ŋ kpa fe̱yɛ ɔko̱ ŋu mfe̱ŋ ne̱ ɔ yɔ‑ɔ, a le̱e̱ fe̱yɛ ɔ kaapo̱ mò̱ agyase̱po̱‑ɔ ne̱e̱ fe̱yɛ, “Ba taa mo̱, dimaadi mò̱ gyi‑o, a bo̱ bo̱ waa swe̱e̱re̱ mɔ se̱ ayaale̱ŋpo̱ ke̱sare̱e̱‑rɔ, na bo̱ mɔɔ mo̱. Amaa amo̱ ya fo̱ ŋke nsa‑ɔ, mo̱ i kyiŋŋi a n le̱e̱ lowi‑ro.” ");
INSERT INTO ncuNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Amaa mò̱ agyase̱po̱‑ɔ mo̱ŋ nu ane̱ŋ ne̱ ɔɔ kaapo̱‑ɔ kaase̱, bamo̱ mɔ kufu de bamo̱ a bo̱ bise mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ne̱ baa ba Kapaaniyum maŋ‑nɔ. Bamo̱ a lwee Yeesuu lɔŋ‑nɔ‑ɔ, ne̱ oo bise mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Ntɔ ke̱tɔ se̱ ne̱ mo̱ne̱ i gyiiri ikii kpa‑rɔ‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Amaa bo̱ mo̱ŋ be̱ŋŋaa Yeesuu, a le̱e̱ fe̱yɛ baa gyiiri ikii kpa‑ɔ‑rɔ ne̱e̱, baa kpa bamo̱‑rɔ mò̱ ne̱ ɔ gye̱ bre̱sɛ‑ɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ne̱ Yeesuu a kye̱na, ne̱ ɔɔ te̱e̱ mò̱ agyase̱po̱ kudu anyɔ‑ɔ baa mò̱ ase̱, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Ɔko̱ ne̱ ɔ kpa fe̱yɛ o kii mo̱ne̱‑rɔ ɔbre̱sɛ‑ɔ waa mò̱ e̱ye̱e̱ mo̱ne̱ pɛɛɛ‑rɔ kayaagyi na o suŋ mo̱ne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Mfe̱ŋ ne̱ ɔɔ baa kayaagyi ko̱ baa bo̱ ye̱ra bamo̱ akatɔ‑rɔ, ne̱ oo powi mò̱, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ɔke̱maa ne̱ mo̱ ke̱nyare̱‑rɔ ɔ kra ŋyaagyi mɔ ɔko̱ nɛɛnɛɛ‑ɔ a kra mo̱ nɛɛnɛɛ ne̱e̱, ne̱ mò̱ ne̱ ɔ kra mo̱ nɛɛnɛɛ‑ɔ mɔ a kra mò̱ ne̱ oo suŋ mo̱ bo̱ kyo̱ŋwe̱‑ɔ nɛɛnɛɛ dɛɛ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ne̱ Yohanee ne̱ ɔ gye̱ Yeesuu agyase̱po̱‑ɔ ɔko̱‑ɔ a tɔwe̱ gywii Yeesuu fe̱yɛ, “Ɔkaapo̱po̱, ane̱ a ŋu ɔko̱ de fo̱ ke̱nyare̱ ɔ gya ibrisi ɔ ko̱so̱ ase̱sɛ se̱. Ne̱ ane̱ a tɔwe̱ gywii mò̱ fe̱yɛ ɔ yɔwe̱ ane̱ŋ ko̱waa, bo̱ le̱e̱ fe̱yɛ ɔ mo̱ŋ tii ane̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ne̱ Yeesuu yɛ, “Mo̱ne̱ ma lɛɛ gya mò̱, a le̱e̱ fe̱yɛ mò̱ ne̱ o de mo̱ ke̱nyare̱ ɔ waa atɔ dabe̱‑ɔ maa lɛɛ taare̱ a ɔ tɔwe̱ ase̱ŋ bɔye̱ bo̱ kye mo̱ puri amo̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Bo̱ le̱e̱ fe̱yɛ ɔke̱maa ne̱ ɔ mo̱ŋ gye̱ ane̱ ɔdo̱ŋ‑ɔ bo̱ ane̱ ke̱be̱gya ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ ɔko̱ ne̱ ɔ sa mo̱ne̱ nkyu a mo̱nꞌ nuu bo̱ le̱e̱ fe̱yɛ mo̱ne̱ a gye̱ Kristoo agyase̱po̱‑ɔ se̱‑ɔ e̱ nya ke̱dame̱naŋsɛ kakɔka.” ");
INSERT INTO ncuNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Ɔko̱ ne̱ mò̱ ya sa ne̱ ŋyaagyi ngyingyii mɔ ne̱ ba kɔɔre̱ mo̱ ba gyi‑o ɔko̱ ya waa e̱bɔye̱, amo̱ fe̱raa bamo̱ ya ba kibu dabe̱ bo̱ da se̱sɛ‑ɔ ke̱bɔ‑rɔ, ne̱ baa twe̱e̱ mò̱ waa ɔpo̱o̱‑rɔ, a bɔ fe̱yɛ mò̱ a ŋu ke̱se̱bɔgyiiri ne̱ Wuribware̱ e̱ taa a ɔ bo̱ laye̱ ane̱ŋ a e̱bɔye̱ awaapo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Amo̱se̱‑ɔ, fo̱ ko̱ ne̱ fo̱ ke̱sare̱e̱ e̱ gye̱ ne̱ ke̱ e̱ sa ne̱ fo̱ e̱ waa bɔye̱, te̱ŋ ke̱mo̱ bo̱ twe̱e̱, a le̱e̱ fe̱yɛ fo̱ ya kii ke̱sare̱e̱ ko̱ŋko̱ wuye, ne̱ fo̱ a nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ, a bɔ fe̱yɛ fo̱ a ba fo̱ asare̱e̱ anyɔ bo̱ waa asuŋ, na lalalo̱we̱‑ɔ fo̱ lwee awo̱re̱fɔɔ de̱e̱kpa ne̱ ɔ maa duŋ, ne̱ Wuribware̱ a kure bo̱ be̱ya na ɔ bo̱ gyiiri e̱bɔye̱ awaapo̱ e̱se̱bɔ‑rɔ‑ɔ‑rɔ‑ɔ.  ");
INSERT INTO ncuNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Bo̱ le̱e̱ fe̱yɛ, ‘Aso̱ŋsɔɔ ne̱ a wo̱ mfe̱ŋ a awuye‑o maa wu daa, ane̱ŋ dɛɛ mɔ ne̱ de̱e̱kpa ne̱ ɔ kywɛɛ bamo̱‑ɔ maa duŋ.’ ");
INSERT INTO ncuNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ne̱ fo̱ ko̱ mɔ ne̱ fo̱ ke̱yaa e̱ sa ne̱ fo̱ e̱ waa bɔye̱‑ɔ, te̱ŋ fo̱ ke̱yaa amo̱ bo̱ twe̱e̱, a le̱e̱ fe̱yɛ fo̱ ya kii ke̱yaa ko̱ŋko̱ wuye, ne̱ fo̱ a nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ, a bɔ fe̱yɛ fo̱ ke̱yaa a mo̱ŋ te̱ŋ, ne̱ fo̱ a lwee awo̱re̱fɔɔ de̱e̱kpa‑ɔ‑rɔ.  ");
INSERT INTO ncuNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Bo̱ le̱e̱ fe̱yɛ, ‘Aso̱ŋsɔɔ ne̱ a wo̱ mfe̱ŋ a awuye‑o maa wu daa, ane̱ŋ dɛɛ mɔ ne̱ de̱e̱kpa ne̱ ɔ kywɛɛ bamo̱‑ɔ maa duŋ.’ ");
INSERT INTO ncuNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ne̱ fo̱ ko̱ mɔ ne̱ fo̱ ke̱katɔ ko̱ e̱ sa ne̱ fo̱ e̱ waa bɔye̱‑ɔ, lee ke̱mo̱ bo̱ twe̱e̱, a le̱e̱ fe̱yɛ fo̱ ya kii ke̱katɔ ko̱ŋko̱ wuye, ne̱ fo̱ a nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ, a bɔ fe̱yɛ fo̱ akatɔ anyɔ a te fo̱ se̱, ne̱ fo̱ a bo̱ lwee awo̱re̱fɔɔ de̱e̱kpa‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Bo̱ le̱e̱ fe̱yɛ, ‘Aso̱ŋsɔɔ ne̱ a wo̱ mfe̱ŋ a awuye‑o maa wu daa, ane̱ŋ dɛɛ mɔ ne̱ de̱e̱kpa ne̱ ɔ kywɛɛ bamo̱‑ɔ maa duŋ.’ ");
INSERT INTO ncuNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Wuribware̱ e̱ ba awo̱re̱fɔɔ ne̱ a du fe̱yɛ de̱e̱kpa‑ɔ kaye̱ mɔ‑rɔ ne̱e̱ a ɔ bo̱ lɔŋŋɔ ɔke̱maa kakpo̱nɔ‑rɔ, fe̱yɛ ane̱ŋ ne̱ Wuribware̱ alɔŋŋɔpo̱ de mfɔre̱ ba waa ayu mpu‑ro na a nya waa kɔne̱ pwɛɛ a bo̱ dɛɛ taa bo̱ lɔŋŋɔ Wuribware̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mfɔre̱ bo̱ kɔne̱, amaa mmo̱ kɔne̱‑ɔ ya le̱e̱ mmo̱‑rɔ, mmo̱ mo̱ŋ lɛɛ n gye̱ mfɔre̱. Kɔne̱ amo̱ a le̱e̱‑ɔ, ɔko̱ maa taare̱ a ɔ bo̱rɔ kpa ko̱ se̱ be̱e̱ sa a ŋ kii mfɔre̱. Amo̱se̱‑ɔ, mo̱nꞌ kye̱na kaye̱e̱yuri‑ro, a le̱e̱ fe̱yɛ kaye̱e̱yuri du ne̱e̱ fe̱yɛ mfɔre̱, ne̱ ŋ waa ateese kɔne̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Saŋ ne̱ Yeesuu a le̱e̱ mfe̱ŋ‑ɔ, ne̱ ɔɔ yɔ Yude̱ya swe̱e̱re̱ se̱. Mfe̱ŋ ne̱ ɔɔ te̱ŋ Yo̱o̱daŋ bo̱ŋ‑ɔ‑rɔ yɔ nno̱ŋ a bo̱ŋbe̱‑ɔ se̱. Mfe̱ŋ ne̱ ase̱sɛ a le̱e̱ ba ba mò̱ ase̱. Ne̱ ɔɔ kaapo̱ abware̱se̱ŋ fe̱yɛ ane̱ŋ ne̱ ɔɔ kyɔ ɔ naa ɔ kaapo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ne̱ Farisii awuye ko̱ a ba mò̱ ase̱ mfe̱ŋ a bo̱ lɔɔre̱ mò̱ kanɔ‑rɔ. Ne̱ baa bise mò̱ fe̱yɛ, “To, tɔwe̱ gywii ane̱. Ane̱ mbraa‑ɔ e̱ sa kpa fe̱yɛ ɔko̱ kine mò̱ ka aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ne̱ Yeesuu a ba se̱ŋbise bo̱ be̱ŋŋaa bamo̱ fe̱yɛ, “Mbraa mo̱ ne̱ Mosis a sa mo̱ne̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ne̱ bamo̱‑ɔ baa be̱ŋŋaa mò̱ fe̱yɛ, “Mosis a sa mbraa fe̱yɛ, ɔnyare̱ ya kine mò̱ ka, ɔ kyo̱rɛɛ wo̱re̱ na ɔke̱maa nya ŋu fe̱yɛ oo yure mò̱ se̱ pwɛɛ a ɔ dɛɛ gya mò̱ le̱e̱ mò̱ lɔŋ‑nɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Mfe̱ŋ ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Ke̱tɔ se̱ ne̱ Mosis a kyo̱rɛɛ mfaanɛɛ a mbraa mɔ sa mo̱ne̱‑ɔ e̱ gye̱ fe̱yɛ mo̱ne̱ aŋu‑ro bo̱ le̱ŋ ne̱e̱ fɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Amaa saŋ ne̱ Wuribware̱ a twe̱e̱ ke̱tɔ ke̱maa‑ɔ, ɔɔ twe̱e̱ ɔnyare̱ na ɔkye̱e̱ ne̱e̱, fe̱yɛ ane̱ŋ ne̱ abware̱se̱ŋ wo̱re̱‑ɔ a tɔwe̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Ne̱ a be̱e̱ a tɔwe̱ fe̱yɛ, ‘Amo̱se̱ ne̱ ɔnyare̱ e̱ le̱e̱ mò̱ se̱ na mò̱ nyi lɔŋ‑nɔ na ɔ waare̱e̱, na mò̱ aa mò̱ ka a waa kanɔ kye̱na kii ko̱ko̱ŋko̱.’ Amo̱‑ɔ e̱ kaapo̱ ne̱e̱ fe̱yɛ bo̱ mo̱ŋ lɛɛ bo̱ gye̱ abɛɛ anyɔ, amaa Wuribware̱ a sa ne̱ baa kii se̱sɛ ko̱ŋko̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Amo̱se̱ se̱‑ɔ, se̱sɛ mo̱ŋ de kpa fe̱yɛ mò̱ a brawe̱ ke̱tɔ ne̱ Wuribware̱ a bo̱ waa abɛɛ‑rɔ‑ɔ‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Saŋ ne̱ baa kiŋŋi yɔ lɔŋ‑nɔ‑ɔ, ne̱ Yeesuu agyase̱po̱‑ɔ a bise Yeesuu ase̱ŋ bo̱ le̱e̱ ke̱tɔ ne̱ ɔɔ tɔwe̱‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ne̱ ɔɔ be̱ŋŋaa bamo̱ fe̱yɛ, “Ɔnyare̱ ya kine mò̱ ka, ne̱ ɔɔ ya waare̱e̱ ɔkye̱e̱ baŋbaŋ, ɔɔ waa bɔye̱. Mò̱ ke̱be̱e̱ waare̱e̱ ɔkye̱e̱ baŋbaŋ‑ɔ a sa ne̱ ɔɔ waa kakye̱e̱kpa. ");
INSERT INTO ncuNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ane̱ŋ dɛɛ ne̱ ɔkye̱e̱ ya kine mò̱ kuri ya waare̱e̱ ɔnyare̱ baŋbaŋ, ne̱ ɔɔ waa kanyare̱kpa.” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ne̱ ase̱sɛ ko̱ a baa bamo̱ ŋyaagyi Yeesuu ase̱ na ɔ ba mò̱ asare̱e̱ bo̱ dɔŋŋɔ bamo̱ se̱ yure bamo̱. Amɔ mò̱ agyase̱po̱‑ɔ e̱ kpa a bo̱ gya bamo̱ bo̱ kiŋŋi. ");
INSERT INTO ncuNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Saŋ ne̱ Yeesuu a ŋu na ba waa ane̱ŋ‑ɔ, a mo̱ŋ waa mò̱ kɔne̱. Ne̱ ɔɔ tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Mo̱ne̱ ma gya ŋyaagyi‑o. Mo̱nꞌ sa a bo̱ ba mo̱ ase̱, bo̱ le̱e̱ fe̱yɛ ane̱ŋ a ŋyaagyi mɔ na bamo̱ ne̱ bo̱ du fe̱yɛ bamo̱ mɔ‑ɔ e̱ gye̱ ne̱ bo̱ tii Wuribware̱ a kuwure‑o si. ");
INSERT INTO ncuNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Na mo̱nꞌ nyiŋŋi si fe̱yɛ ɔke̱maa ne̱ ɔ maa sure si fe̱yɛ Wuribware̱ gyi kuwure fe̱yɛ ane̱ŋ ne̱ ŋyaagyi mɔ a sure si‑o, maa tii Wuribware̱ a kuwure‑o si.” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ne̱ Yeesuu a powi ŋyaagyi amo̱ ako̱ ako̱, ne̱ ɔɔ ba mò̱ asare̱e̱ bo̱ dɔŋŋɔ bamo̱ ɔke̱maa kuŋu si, ne̱ oo yure bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yeesuu a me̱raa kpa se̱ ɔ be̱e̱ ɔ yɔ‑ɔ, ne̱ ɔnyare̱ ko̱ a ŋwɛɛnaŋ bo̱ kpuni aŋurii Yeesuu akatɔ‑rɔ, ne̱ ɔ yɛ, “Ɔkaapo̱po̱ timaa, e̱me̱ne̱ ne̱ mo̱ e̱ waa na ŋ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ne̱ Yeesuu a bise ɔnyare̱‑ɔ fe̱yɛ, “Nte̱tɔ se̱ ne̱ fo̱ e̱ te̱e̱ mo̱ fe̱yɛ otimaa‑o ne̱e̱? Ɔko̱ mo̱ŋ bo̱‑rɔ ne̱ ɔ gye̱ otimaa be̱e̱ bo̱ tii Wuribware̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","To, fo̱ nyi Wuribware̱ a mbraa‑ɔ pɛɛɛ mɔ fe̱yɛ, ‘Ɔko̱ ma mɔɔ mò̱ bɛɛko̱, ɔko̱ ma waa kakye̱e̱kpa, ɔko̱ ma kaŋ ywii, ɔko̱ ma te̱ŋ mò̱ bɛɛko̱ kanɔ, ɔko̱ ma gyi mò̱ bɛɛko̱, na ɔke̱maa bu mò̱ se̱ na mò̱ nyi.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ne̱ ɔnyare̱‑ɔ yɛ, “Ɔkaapo̱po̱, de̱ŋ le̱e̱ mo̱ ŋyaagyi‑ro ne̱ mo̱ a le̱e̱ gya Wuribware̱ a mbraa mɔ pɛɛɛ se̱ ba bo̱ fo̱ ndɔɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Mfe̱ŋ ne̱ Yeesuu a de̱e̱re̱ ɔnyare̱ amo̱, ne̱ mò̱ ase̱ŋ a waa mò̱ kɔne̱, ne̱ ɔ yɛ, “Ke̱tɔ ko̱ŋko̱ ya saŋ fo̱ a fo̱ waa na fo̱ ya wu na fo̱ kii atɔ wuye Wuribware̱ se̱. Amo̱ e̱ gye̱ fe̱yɛ fo̱ ya fe fo̱ kapo̱tɛɛ pɛɛɛ, na fo̱ taa atanne̱‑ɔ sa atiripo̱, na fo̱ bo̱ gya mo̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ɔnyare̱ amo̱ a nu ane̱ŋ ne̱ Yeesuu a tɔwe̱‑ɔ, a mo̱ŋ waa mò̱ kɔne̱, bo̱ le̱e̱ fe̱yɛ o de kapo̱tɛɛ bwe̱e̱tɔ. Ne̱ ɔɔ bo̱re̱ o yii mò̱ lɔŋ‑nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ne̱ Yeesuu a kii de̱e̱re̱ mò̱ agyase̱po̱‑ɔ, ne̱ ɔ yɛ, “A waa le̱ŋ fe̱yɛ atɔ wuye a sure si fe̱yɛ Wuribware̱ gye̱ mò̱ owure.” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Yeesuu a tɔwe̱ ane̱ŋ‑ɔ, aa waa mò̱ agyase̱po̱‑ɔ ase̱ŋ dabe̱. Ne̱ Yeesuu a be̱e̱ kya se̱ fe̱yɛ, “Mo̱ gyi‑ana, a waa le̱ŋ fɛɛ fe̱yɛ ɔko̱ a sure si fe̱yɛ Wuribware̱ gye̱ mò̱ owure. ");
INSERT INTO ncuNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nyɔma e̱ taare̱ a o lwee basa bɔ‑rɔ dare̱e̱ aaa? Amaa atɔ wuye kusure si fe̱yɛ Wuribware̱ gye̱ mò̱ owure bo̱ le̱ŋ ko̱ kyɔ nyɔma kulwee basa bɔ‑rɔ dare̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yeesuu a be̱e̱ tɔwe̱ faanɛɛ‑ɔ, aa be̱e̱ waa mò̱ agyase̱po̱‑ɔ kanɔ ŋko̱, ne̱ baa bise abɛɛ fe̱yɛ, “Ne̱ ŋkee nsɛ gbaa e̱ gye̱ ne̱ o de kpa fe̱yɛ ɔ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ne̱ Yeesuu a de̱e̱re̱ mò̱ agyase̱po̱‑ɔ, ne̱ ɔɔ be̱ŋŋaa bamo̱ fe̱yɛ, “Se̱sɛ fe̱raa maa taare̱ a ɔ nya ane̱ŋ a ŋkpa‑ɔ, amɔ Wuribware̱ a sa mò̱ kpa. Ko̱tɔko̱ mo̱ŋ bo̱‑rɔ na Wuribware̱ maa taare̱ a ɔ waa ke̱mo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ne̱ Peetroo a tɔwe̱ fe̱yɛ, “Ke̱e̱ ɛ, ane̱ a yɔwe̱ ke̱tɔ ke̱maa ne̱e̱ gya fo̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Ne̱ Yeesuu a kpo̱ne̱ se̱ fe̱yɛ, “Ɔɔŋ, na mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ ɔke̱maa ne̱ oo kperi mo̱ se̱ na ase̱ŋ timaa‑o si, ne̱ ɔɔ yɔwe̱ mò̱ pe̱ bɛɛɛ mò̱ daa‑ana bɛɛɛ mò̱ tire‑ana bɛɛɛ mò̱ pe̱kye̱e̱‑ana bɛɛɛ mò̱ nyi bɛɛɛ mò̱ se̱ bɛɛɛ mò̱ gyi‑ana bɛɛɛ mò̱ adɔɔ gya mo̱ se̱‑ɔ e̱ nya e̱lɔŋ na adaa na atire na ape̱kye̱e̱ na anyi na agyi na adɔɔ ne̱ ɔɔ yɔwe̱‑ɔ iluwi ke̱lafa a ɔ bo̱ teere kaye̱ mɔ‑rɔ, na ase̱sɛ kperi mo̱ se̱ waa mò̱ awo̱re̱fɔɔ na bo̱ tɔwe̱ ase̱ŋ bɔye̱ bo̱ kye mò̱, na ŋkee ɔ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ kaye̱ ne̱ ka ba a ka bo̱ ba‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Amaa ase̱sɛ bwe̱e̱tɔ ne̱ bo̱ gye̱ agye̱ŋkpɛɛpo̱ mbe̱yɔmɔ‑ɔ i kii nsii-amɛɛ, na bamo̱ ne̱ bo̱ gye̱ nsii-amɛɛ mbe̱yɔmɔ‑ɔ mɔ kii agye̱ŋkpɛɛpo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kamɛɛ‑rɔ ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ a me̱raa se̱ ba yɔ Yɛro̱salɛm maŋ‑nɔ, na Yeesuu gye̱ ŋkpɛɛ. Bamo̱ a yɔ‑ɔ, ne̱ mò̱ agyase̱po̱‑ɔ iduŋ saŋ e̱ te̱ŋŋe̱ bamo̱. Kufu gbaa a nya ase̱sɛ ne̱ bamo̱‑ɔ gbaa bo̱ gya bamo̱ se̱‑ɔ. Mfe̱ŋ ne̱ Yeesuu a be̱e̱ lee mò̱ agyase̱po̱ kudu anyɔ‑ɔ keri si, ne̱ ɔɔ le̱e̱ ɔ tɔwe̱ ase̱ŋ ne̱ a ba a a bo̱ to̱ mò̱‑ɔ o gywii bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ɔɔ tɔwe̱ ne̱e̱ fe̱yɛ, “Mo̱nꞌ nu mo̱ ase̱. Ane̱ e̱ yɔ Yɛro̱salɛm maŋ‑nɔ mfe̱ŋ ne̱ ba ba mo̱, dimaadi mò̱ gyi‑o, a bo̱ bo̱ waa Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ na Wuribware̱ mbraa akaapo̱po̱ ke̱sare̱e̱‑rɔ‑ɔ. Bamo̱ e̱ gye̱ ne̱ ba gyi mo̱ ase̱ŋ na bo̱ bu mo̱ ke̱pɔ, na ŋkee bo̱ taa mo̱ sa Roma awuye ne̱ baa kɔɔre̱ ane̱ maŋ‑ɔ, a bo̱ mɔɔ mo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Roma awuye mɔ e̱ saare̱ mo̱, na bo̱ twe̱e̱ akyɔne̱ we̱e̱ mo̱ se̱, na bo̱ da mo̱ paara, na bo̱ mɔɔ mo̱. Amaa ke̱mo̱ ŋke nsa mo̱ i kyiŋŋi a n le̱e̱ lowi‑ro.” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","To, ne̱ Yeesuu a agyase̱po̱‑ɔ anyɔ ko̱ a lee mò̱ keri si na bo̱ ko̱re̱ mò̱ ko̱tɔko̱. Bamo̱ e̱ gye̱ Sibidii mò̱ agyi nyaŋsɛ anyɔ‑ɔ, Yakubu na Yohanee. Ne̱ baa tɔwe̱ gywii mò̱ fe̱yɛ, “Ɔkaapo̱po̱, ane̱ e̱ kpa fe̱yɛ fo̱ waa ko̱tɔko̱ sa ane̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ne̱ Yeesuu yɛ, “Nte̱tɔ ne̱ mo̱ne̱ e̱ kpa a ŋ waa sa mo̱ne̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ne̱ bo̱ yɛ, “Fo̱ ya kye̱na fo̱ kuwure dabe̱‑ɔ se̱, na fo̱ sa a ane̱ kye̱na fo̱ ase̱, ɔko̱ kye̱na fo̱ kigyise si na ɔko̱ mɔ kye̱na fo̱ ke̱be̱na se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ne̱ mo̱ŋ nyi ane̱ŋ ne̱ ke̱tɔ ne̱ mo̱ne̱ i bise mo̱ne̱ e̱ kpa‑ɔ du‑o. Mo̱ne̱ e̱ taare̱ a mo̱nꞌ gyi awo̱re̱fɔɔ ne̱ mo̱ e̱ ba a m bo̱ gyi‑o ooo, ne̱ mo̱ne̱ e̱ taare̱ a mo̱nꞌ nyite ase̱ŋ ne̱ ase̱sɛ e̱ taa a bo̱ bo̱ laye̱ mo̱‑ɔ ɔɔɔ?” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ne̱ baa be̱ŋŋaa fe̱yɛ, “Ane̱ e̱ taare̱.” Ne̱ Yeesuu yɛ, “Ane̱ŋ ne̱ mo̱ i gyi awo̱re̱fɔɔ na ase̱sɛ taa ase̱ŋ bo̱ laye̱ mo̱‑ɔ, ane̱ŋ dɛɛ ne̱ a waa mo̱ne̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Amaa n gye̱ mo̱ e̱ gye̱ ne̱ mo̱ i lee mò̱ ne̱ ɔ kye̱na mo̱ kigyise si‑o na mò̱‑ɔ mò̱ ne̱ ɔ kye̱na mo̱ ke̱be̱na se̱‑ɔ. Wuribware̱ e̱ gye̱ ne̱ o lee e̱kye̱nakpa amo̱ a ɔ bo̱ sa bamo̱ ne̱ ɔɔ lɔŋŋɔ mfe̱ŋ bo̱ ye̱ra bamo̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Saŋ ne̱ Yeesuu agyase̱po̱ kudu ne̱ baa saŋ‑ɔ a nu ane̱ŋ ne̱ Yakubu na Yohanee e̱ kpa fe̱yɛ Yeesuu sa bamo̱ ke̱dabe̱ kyo̱ŋ bamo̱ pɛɛɛ‑ɔ, ne̱ bamo̱ iduŋ a fwii bamo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yeesuu a ŋu fe̱yɛ bamo̱ iduŋ a fwii‑o, ne̱ ɔɔ te̱e̱ bamo̱ pɛɛɛ bo̱ gyaŋŋe̱, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Ne̱e̱ mo̱ne̱ nyi fe̱yɛ kaye̱ mɔ‑rɔ ase̱sɛ‑rɔ fe̱raa, bamo̱ ne̱ bo̱ de maŋ‑ɔ na agye̱ŋkpɛɛpo̱‑ɔ e̱ gye̱ ne̱ bo̱ de ke̱yaale̱ŋ ba gyi ɔke̱maa se̱ ɛ? ");
INSERT INTO ncuNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Amaa mo̱ne̱‑rɔ fe̱raa n gye̱ ane̱ŋ ne̱ a du. Mò̱ ne̱ ɔ kpa a ɔ waa mo̱ne̱‑rɔ ɔbre̱sɛ‑ɔ bɛɛɛ se̱sɛ dabe̱‑ɔ waa asuŋ bo̱ suŋ mo̱ne̱ ne̱ mo̱ne̱ a saŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ne̱ mò̱‑ɔ mò̱ ne̱ ɔ kpa fe̱yɛ o kii mo̱ne̱‑rɔ ɔgye̱ŋkpɛɛpo̱‑ɔ waa mò̱ e̱ye̱e̱ mo̱ne̱ pɛɛɛ‑rɔ ke̱nya. ");
INSERT INTO ncuNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","A le̱e̱ fe̱yɛ mo̱, dimaadi mò̱ gyi‑o, gbaa mo̱ŋ ba fe̱yɛ ɔko̱ waa asuŋ sa mo̱ ne̱e̱. Mo̱ a ba a m bo̱ waa asuŋ sa ase̱sɛ ne̱e̱, na ŋ wu bo̱ sa ase̱sɛ bwe̱e̱tɔ, na ŋ ka ko̱kɔ sa bamo̱, na bo̱ nya nya bamo̱ e̱ye̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ a bo̱rɔ Yɛrikoo maŋ‑nɔ. Bamo̱ a le̱e̱ mfe̱ŋ‑ɔ, ne̱ ase̱sɛ bwe̱e̱tɔ a gya bamo̱ se̱. Timiyus mò̱ gyi te̱napo̱ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Bar‑Timiyus‑o mɔ bo̱ maŋ‑ɔ‑rɔ, ne̱ o te kabo̱re̱ kɛɛ saŋ ke̱maa ɔ ko̱re̱ atɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Te̱napo̱ amo̱ a te kabo̱re̱ kɛɛ mfe̱ŋ ne̱ oo nu fe̱yɛ Yeesuu Nasarɛte̱nyi e̱ kyo̱ŋ kabo̱re̱‑ɔ se̱‑ɔ, ne̱ ɔɔ le̱e̱ ɔ fɛɛ‑rɔ keŋkeŋ fe̱yɛ, “Yeesuu, Deefid mò̱ nana, ŋu mo̱ e̱wɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ne̱ ase̱sɛ‑ɔ a fɛɛ mò̱ se̱ fe̱yɛ ɔ laatɔ. Amaa ŋkee gbaa ne̱ ɔɔ me̱raa se̱ ɔ fɛɛ‑rɔ keŋkeŋ‑o ne̱e̱ fe̱yɛ, “Deefid mò̱ nana, ŋu mo̱ e̱wɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Amo̱ fe̱raa ne̱ Yeesuu a ye̱re̱, ne̱ ɔ yɛ, “Mo̱nꞌ te̱e̱ mò̱.” Ne̱ baa te̱e̱ te̱napo̱ amo̱, ne̱ baa tɔwe̱ gywii mò̱ fe̱yɛ, “Ko̱so̱ na fo̱ sa a fo̱ akatɔ gyi, a le̱e̱ fe̱yɛ ɔ yɛ fo̱ ba.” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ne̱ oo buŋŋi mò̱ waagya, ne̱ oo fuwi ywe̱e̱, ne̱ ɔɔ yɔ Yeesuu ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ne̱ Yeesuu a bise mò̱ fe̱yɛ, “Nte̱tɔ ne̱ fo̱ e̱ kpa fe̱yɛ ŋ waa sa fo̱?” Ne̱ te̱napo̱‑ɔ yɛ, “Ɔkaapo̱po̱, mo̱ e̱ kpa fe̱yɛ fo̱ buŋŋi mo̱ akatɔ ne̱e̱, na n de̱e̱ nya ŋu atɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ne̱ Yeesuu yɛ, “Fo̱ a kɔɔre̱ mo̱ gyi‑o si‑o, fo̱ a kpaare̱, amo̱se̱‑ɔ nare̱.” Puri amo̱‑rɔ ne̱ te̱napo̱ amo̱ akatɔ a buŋŋi, ne̱ ɔɔ gya Yeesuu si kabo̱re̱ amo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Bamo̱ a kpa a bo̱ fo̱ Yɛro̱salɛm maŋ‑nɔ, ne̱ baa kyo̱ŋ kamaŋgyii ko̱ ne̱ ba te̱e̱ ɛ Bɛtaniya‑o, ne̱ ba kpa a bo̱ fo̱ kamaŋgyii ko̱ ne̱ ba te̱e̱ ɛ Bɛtɛfage̱, ne̱ ka maa Mfɔ-Ayii ke̱be̱e̱‑ɔ. Mfe̱ŋ ne̱ Yeesuu a suŋ mò̱ agyase̱po̱‑ɔ anyɔ bo̱ gye̱ ŋkpɛɛ tɔwe̱ gywii bamo̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Mo̱nꞌ yɔ kamaŋgyii ne̱ ka bo̱ akatɔ‑rɔ‑ɔ‑rɔ. Mo̱ne̱ ya fo̱ mfe̱ŋ, mo̱ne̱ i ŋu bamo̱ a ŋure kuruma ko̱ ne̱ ɔ mo̱ŋ tɛɛ daŋ lo̱we̱‑ɔ, ne̱ ɔko̱ mo̱ŋ tɛɛ de̱e̱‑ɔ ye̱re̱, na mo̱nꞌ saŋŋe̱ mò̱ baa mfe̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ne̱ ɔko̱ ya bise mo̱ne̱ ke̱tɔ se̱ ne̱ mo̱ne̱ e̱ saŋŋe̱ kuruma‑o, mo̱nꞌ tɔwe̱ gywii se̱sɛ‑ɔ fe̱yɛ, ‘Ane̱ nyaŋpe̱ e̱ gye̱ ne̱ ɔ kpa. Amaa ke̱tɔ maa kyee na ɔ be̱e̱ kiŋŋaa mò̱ baa.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Amo̱se̱‑ɔ, ne̱ baa yɔ mfe̱ŋ ya ŋu fe̱yɛ ɔko̱ a ŋure mò̱ kuruma kibunogyi ase̱ kabo̱re̱ se̱. Ne̱ baa me̱raa se̱ ba saŋŋe̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Saŋ ne̱ ba saŋŋe̱ kuruma‑o, ne̱ bamo̱ ne̱ bo̱ ye̱re̱ mfe̱ŋ‑ɔ a bise Yeesuu agyase̱po̱ anyɔ amo̱ fe̱yɛ, “Nte̱tɔ ne̱ mo̱ne̱ e̱ waa‑ɔ ne̱e̱, mo̱ne̱ e̱ saŋŋe̱ kuruma amo̱ ne̱e̱ e̱e̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ne̱ baa be̱ŋŋaa ane̱ŋ ne̱ Yeesuu yɛ bamo̱ ya bise a bo̱ be̱ŋŋaa‑ɔ. Ne̱ bamo̱ ne̱ bo̱ ye̱re̱ mfe̱ŋ‑ɔ a yɔwe̱ bamo̱ fe̱yɛ bo̱ nare̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ne̱ baa taa kuruma‑o baa Yeesuu ase̱. Ne̱ baa buŋŋi bamo̱ awaagya bo̱ buŋ kuruma‑o si, ne̱ Yeesuu a de̱e̱ kye̱na se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ne̱ baa me̱raa se̱ ba lweero Yɛro̱salɛm maŋ. Ne̱ ase̱sɛ bwe̱e̱tɔ a brawe̱ bamo̱ awaagya‑rɔ bo̱ be̱ya kpa‑ɔ se̱ sa mò̱, ne̱ ɔɔ nare̱ se̱ kyo̱ŋ. Bo̱ko̱ mɔ a ŋeri afe̱raa le̱e̱ adɔɔ ne̱ a maa kpa‑ɔ, ne̱ baa bo̱ dɔŋŋɔ kpa‑ɔ se̱ sa mò̱, ne̱ ɔɔ nare̱ se̱ kyo̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","10","Ŋkee bamo̱ ne̱ bo̱ gye̱ mò̱ ŋkpɛɛ na bamo̱ ne̱ bo̱ gya mò̱ se̱‑ɔ a le̱e̱ ba fɛɛ‑rɔ ne̱e̱ fe̱yɛ, “Mo̱nꞌ sa a ane̱ da Wuribware̱ kakyirele. Wuribware̱ yure mò̱ ne̱ ɔ ba mò̱ ke̱nyare̱‑rɔ‑ɔ. Wuribware̱ yure kuwure ne̱ ɔ ba a ɔ bo̱ gyi fe̱yɛ ane̱ŋ ne̱ ane̱ nana Owure Deefid a dɛɛ gyi‑o. Mo̱nꞌ sa a ane̱ da Wuribware̱ ne̱ ɔ bo̱ so̱so̱‑ɔ kakyirele.” ");
INSERT INTO ncuNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yeesuu a kye̱na mò̱ kuruma‑o si ya ye̱re̱ kpo̱ro̱we̱ maŋ‑ɔ‑rɔ‑ɔ, ne̱ oo lwee Wuribware̱ suŋkpa mfe̱ŋ de̱e̱re̱ ane̱ŋ ne̱ baa waa kamo̱‑rɔ‑ɔ. Amaa kyɔwe̱ a kyɔ lo̱we̱‑ɔ se̱‑ɔ, ne̱ mò̱ aa mò̱ agyase̱po̱ kudu anyɔ‑ɔ a kiŋŋi yɔ Bɛtaniya. ");
INSERT INTO ncuNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kake nyɔse̱po̱‑ɔ, bamo̱ a le̱e̱ Bɛtaniya ba ba‑ɔ, ne̱ ako̱ŋ de Yeesuu. ");
INSERT INTO ncuNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Mfe̱ŋ ne̱ oo ŋu fe̱yɛ figi kiyii ko̱ ne̱ ke̱ ye̱re̱ akatɔ se̱‑ɔ a pɔwe̱, ne̱ ɔɔ yɔ a ɔ ya ke̱e̱ ke̱mo̱ se̱ fe̱yɛ ɔ nya ke̱mo̱ agyi a o gyi aaa. Amaa mò̱ a yɔ ke̱mo̱ kaase̱‑ɔ, sɛye̱ mo̱ŋ te ke̱mo̱ se̱, amɔ afe̱raa wo̱re̱, a le̱e̱ fe̱yɛ saŋ amo̱ figi ayii maa swɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ne̱ Yeesuu a tɔwe̱ gywii kiyii‑o fe̱yɛ, “Ɔko̱ ma lɛɛ gyi fo̱ agyi ŋke ŋko̱ se̱ daa.” Ne̱ Yeesuu agyase̱po̱‑ɔ a nu ane̱ŋ ne̱ Yeesuu a tɔwe̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bamo̱ a be̱e̱ fo̱ Yɛro̱salɛm maŋ‑nɔ‑ɔ, ne̱ Yeesuu a ya lwee Wuribware̱ suŋkpa kabuno. Mò̱ a fo̱ mfe̱ŋ‑ɔ, ne̱ oo ŋu fe̱yɛ ase̱sɛ te mfe̱ŋ ba fe atɔ, na bo̱ko̱ mɔ e̱ sɔɔ. Bo̱ko̱ mɔ te bamo̱ iteeburi ase̱ mfe̱ŋ ba kyeeri Roma swe̱e̱re̱ se̱ atanne̱ ba yaa Yude̱ya swe̱e̱re̱ se̱ atanne̱‑rɔ. Ase̱sɛ‑ɔ mɔ bo̱ko̱ te kabuno‑o mfe̱ŋ ba fe awurele̱pɔ ne̱e̱. To, Yeesuu a ya to̱ bamo̱ ane̱ŋ‑ɔ, ne̱ ɔɔ gya bamo̱ pɛɛɛ le̱e̱ mfe̱ŋ. Ne̱ ɔɔ gye̱ra gye̱ra bamo̱ ne̱ ba kyeeri atanne̱‑ɔ iteeburi na bamo̱ ne̱ ba fe awurele̱pɔ a ngya‑ɔ bo̱ da. ");
INSERT INTO ncuNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ne̱ ŋkee ɔ yɛ ɔke̱maa ma lɛɛ so̱rɔ tɔso̱rɔ bo̱ kyo̱ŋ kabuno‑o mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ne̱ ŋkee ɔɔ kaapo̱ ase̱sɛ ne̱ bo̱ bo̱ suŋkpa a kabuno‑o mfe̱ŋ. Ne̱ ɔ yɛ, “Ne̱e̱ baa kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ Wuribware̱ yɛ, ‘Mo̱ lɔŋ‑ɔ i kii ke̱kyaŋ ne̱ kaye̱ mɔ‑rɔ ase̱sɛ pɛɛɛ e̱ ba a bo̱ bo̱ nya ko̱re̱ ke̱bware̱ko̱re̱‑ɔ.’ Amaa mo̱ne̱ a taa mfe̱ŋ bo̱ kii ‘ayu lɔŋ ne̱e̱,’ bɛɛɛ?” ");
INSERT INTO ncuNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Amɔ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na Wuribware̱ mbraa akaapo̱po̱‑ɔ a nu ke̱tɔ ne̱ Yeesuu a tɔwe̱‑ɔ, ne̱ baa le̱e̱ ba buwi ba kpa e̱kpa ne̱ ba ye̱re̱ se̱ a bo̱ bo̱ mɔɔ mò̱‑ɔ. Amaa kufu de bamo̱, a le̱e̱ fe̱yɛ mò̱ ke̱kaapo̱‑ɔ a kpe̱ŋ lamaŋ ne̱ baa gyaŋŋe̱ mfe̱ŋ‑ɔ e̱ye̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Bo̱ fo̱ ke̱de̱e̱pwɛta‑ɔ, ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ a le̱e̱ maŋ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kaye̱ ŋke gye̱gyaye̱ saŋ ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ naa kpa se̱‑ɔ, ne̱ baa ŋu figi kiyii ne̱ Yeesuu a daa yii‑o, na ke̱mo̱ pɛɛɛ a wu. ");
INSERT INTO ncuNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Mfe̱ŋ ne̱ Peetroo a nyiŋŋi ke̱tɔ ne̱ kaa waa ke̱mo̱‑ɔ se̱. Ne̱ ɔɔ tɔwe̱ gywii Yeesuu fe̱yɛ, “Ɔkaapo̱po̱, ke̱e̱ kiyii ne̱ fo̱ a daa yii‑o a wu.” ");
INSERT INTO ncuNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ne̱ Yeesuu a be̱ŋŋaa fe̱yɛ, “Mo̱nꞌ kɔɔre̱ Wuribware̱ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ ɔke̱maa ne̱ mò̱ ya kɔɔre̱ Wuribware̱ gyi kyɛɛkyɛɛ, ne̱ mò̱ ya kɔɔre̱ gyi fe̱yɛ ke̱tɔ ne̱ ɔɔ tɔwe̱‑ɔ e̱ waa, ne̱ mò̱ ya tɔwe̱ gywii ke̱be̱e̱ mɔ fe̱yɛ ko̱ ko̱so̱ ya twe̱e̱ ke̱mo̱ e̱ye̱e̱ waa ɔpo̱o̱‑rɔ, Wuribware̱ e̱ waa ane̱ŋ a ɔ sa mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Amo̱se̱ se̱‑ɔ, mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ ɔke̱maa ne̱ mò̱ e̱ ko̱re̱ Wuribware̱ ɔ kpa ko̱tɔko̱, ne̱ mò̱ ya kɔɔre̱ Wuribware̱ gyi mò̱ kakpo̱nɔ‑rɔ fe̱yɛ ɔɔ kyɔ nya ke̱tɔ‑ɔ, Wuribware̱ mɔ e̱ sa mò̱ ke̱mo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Amaa mò̱ a ko̱re̱ Wuribware̱ ke̱tɔ‑ɔ, a tiri fe̱yɛ ɔ taa mò̱ bɛɛko̱ e̱bɔye̱ bo̱ ke mò̱ pwɛɛ na Wuribware̱ ne̱ ɔ bo̱ so̱so̱‑ɔ dɛɛ kɔɔre̱ mò̱ se̱ na ɔ nya taa mò̱ lee bo̱ ke mò̱.  ");
INSERT INTO ncuNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Amaa fo̱ e̱ mo̱ŋ taa fo̱ bɛɛko̱ e̱bɔye̱ bo̱ ke mò̱, Wuribware̱ gbaa maa taa fo̱ lee a ɔ bo̱ ke fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ne̱ baa be̱e̱ kiŋŋi ya lwee Yɛro̱salɛm maŋ‑nɔ. Yeesuu a yɔ ɔ naa Wuribware̱ suŋkpa a kabuno‑o, ne̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na Wuribware̱ mbraa akaapo̱po̱‑ɔ na maŋ‑ɔ abre̱sɛ‑ɔ a yɔ mò̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ne̱ baa bise mò̱ fe̱yɛ, “Nsɛ ya sa fo̱ kpa fe̱yɛ fo̱ gya ase̱sɛ le̱e̱ Wuribware̱ suŋkpa a kabuno‑o mfe̱e̱? Nsɛ ya sa fo̱ kpa fe̱yɛ fo̱ kaapo̱ atɔ mfe̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Mfe̱ŋ ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “To, mo̱ i bise mo̱ne̱ ase̱ŋ ko̱ŋko̱ kpe̱ŋ, ne̱ mo̱ne̱ ya taare̱ be̱ŋŋaa mo̱ nɛɛnɛɛ fe̱raa, mo̱‑ɔ mo̱ e̱ kaapo̱ mo̱ne̱ kpa ne̱ n de fe̱yɛ m bo̱ waa ane̱ŋ a atɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Mo̱nꞌ kaapo̱ mo̱ mò̱ ne̱ ɔɔ sa Yohanee Osuubɔpo̱‑ɔ kpa fe̱yɛ ɔ bɔ asuu‑o. Wuribware̱ ya sa mò̱ bɛɛɛ dimaadi?” ");
INSERT INTO ncuNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Mfe̱ŋ ne̱ bamo̱ wo̱re̱ wo̱re̱ a le̱e̱ ba gyiiri ikii fe̱yɛ, “E̱me̱ne̱ ne̱ ane̱ tɔwe̱‑ɔ ne̱e̱? Bo̱ le̱e̱ fe̱yɛ ane̱ ya tɔwe̱ fe̱yɛ Wuribware̱ ya sa Yohanee kpa fe̱yɛ ɔ bɔ asuu, o bise ane̱ fe̱yɛ, ‘Nte̱tɔ se̱ ne̱e̱ ne̱ mo̱ne̱ mo̱ŋ kɔɔre̱ Yohanee gyi?’ ");
INSERT INTO ncuNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ne̱ ane̱ mɔ ane̱ ya tɔwe̱ fe̱yɛ dimaadi ya sa mò̱ kpa, e̱me̱ne̱ ne̱ ase̱sɛ mɔ e̱ waa ane̱?” Bo̱ se̱re̱ ase̱sɛ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ a le̱e̱ fe̱yɛ bamo̱ ɔke̱maa a kɔɔre̱ gyi fe̱yɛ Yohanee gye̱ Wuribware̱ a akyaamɛɛ‑ɔ ɔko̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Amo̱se̱ se̱‑ɔ, baa be̱ŋŋaa Yeesuu ne̱e̱ fe̱yɛ, “Ane̱ mo̱ŋ nyi ɔko̱ ne̱ ɔɔ sa Yohanee kpa fe̱yɛ ɔ bɔ asuu‑o.” Ne̱ Yeesuu mɔ a tɔwe̱ gywii bamo̱ fe̱yɛ, “Ane̱ŋ fe̱raa, ŋ gbaa ma tɔwe̱ ɔko̱ ne̱ ɔɔ sa mo̱ kpa fe̱yɛ ŋ waa ke̱tɔ ne̱ mo̱ e̱ waa‑ɔ a n gywii mo̱ne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ne̱ Yeesuu a tɔwe̱ kitee mɔ gywii bamo̱ fe̱yɛ, “N gye̱ ɔnyare̱ ko̱ e̱ bo̱‑rɔ aaa? Ne̱ oo dwii mò̱ bobe ayii ko̱, ne̱ amo̱ ya swɛɛ agyi ne̱ bo̱ de ba waa nta‑ɔ. Ne̱ oo gyi bane̱ dabe̱ bo̱ muruwaa, ne̱ oo kwii ke̱maŋtaŋ ko̱dɔɔ‑ɔ‑rɔ mfe̱ŋ na bo̱ taa ayii‑o agyi bo̱ waa‑rɔ a bo̱ kyikye si lee amo̱ nkyu. Ne̱ ɔɔ be̱e̱ waa ko̱tɔko̱ ne̱ ba ye̱re̱ ke̱mo̱ se̱ a bo̱ bo̱ de̱e̱re̱ ko̱dɔɔ‑ɔ se̱‑ɔ bo̱ ye̱ra ko̱dɔɔ‑ɔ‑rɔ. Ne̱ ɔɔ taa sa apafo̱wɔ ko̱ fe̱yɛ bo̱ de̱e̱re̱ se̱ sa mò̱, ne̱ ɔɔ le̱e̱ pe̱ tu kpa yɔ ke̱fɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Saŋ ne̱ ayii agyi amo̱ a be̱re̱, ne̱ amo̱ kiteebe̱e̱ a fo̱‑ɔ, ne̱ ko̱dɔɔ‑ɔ wuye‑o a suŋ mò̱ ke̱yaafɔre̱ ko̱ bo̱ kyo̱ŋwe̱ apafo̱wɔ amo̱ ase̱ fe̱yɛ ɔ yɔ a bo̱ ke ke̱tɔ ne̱ baa nya le̱e̱ mò̱ ko̱dɔɔ‑ɔ‑rɔ, na bo̱ taa mò̱ lee bo̱ kyo̱ŋwe̱ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ke̱yaafɔre̱ amo̱ a yɔ bamo̱ ase̱‑ɔ, ne̱ apafo̱wɔ amo̱ a kra mò̱ da, ne̱ baa yɔwe̱ mò̱ bo̱ kyo̱ŋwe̱ mò̱ nyaŋpe̱ ase̱ asare̱e̱ kpaŋkpaŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ne̱ ko̱dɔɔ‑ɔ wuye‑o a be̱e̱ suŋ mò̱ ke̱yaafɔre̱ nyɔse̱po̱, ne̱ baa daye̱ mò̱ kuŋu‑ro, ne̱ baa saare̱ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ne̱ ɔɔ be̱e̱ suŋ mò̱ ke̱yaafɔre̱ sase̱po̱, ne̱ apafo̱wɔ amo̱ a mɔɔ mò̱. Ane̱ŋ dɛɛ ne̱ ase̱sɛ amo̱ a bii bo̱ko̱, ne̱ baa mɔɔ bo̱ko̱ ne̱ ko̱dɔɔ‑ɔ wuye amo̱ a be̱e̱ suŋ bamo̱ ase̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ŋkee mò̱ ne̱ mò̱ wo̱re̱ ya saŋ a ko̱dɔɔ‑ɔ wuye amo̱ suŋ‑o e̱ gye̱ mò̱ fɔŋfɔŋ mò̱ gyi ko̱ŋko̱ kpeŋ ne̱ o de, ne̱ ɔ kpa mò̱ ase̱ŋ bwe̱e̱tɔ‑ɔ. Amo̱ fe̱raa lalalo̱we̱‑ɔ ne̱ oo suŋ mò̱ gyi amo̱ bo̱ kyo̱ŋwe̱ apafo̱wɔ amo̱ ase̱. Ne̱ ɔɔ fa mò̱ mfɛɛre̱ fe̱yɛ, ‘Mo̱ e̱ kɔɔre̱ a n gyi fe̱yɛ ba bu mo̱ gyi‑o.’ ");
INSERT INTO ncuNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Saŋ ne̱ apafo̱wɔ amo̱ a ŋu kayaagyi‑o e̱ ba‑ɔ, ne̱ ŋkee ba tɔwe̱ ba gywii abɛɛ ne̱e̱ fe̱yɛ, ‘Ke̱e̱ ko̱dɔɔ‑ɔ wuye‑o mò̱ gyi‑o ne̱ mò̱ se̱ ya wu o gyi mò̱ kapo̱tɛɛ‑ɔ e̱ ba‑ɔ. Mo̱nꞌ sa a ane̱ mɔɔ mò̱, na mò̱ se̱ a ko̱dɔɔ mɔ kii ane̱ lee.’ ");
INSERT INTO ncuNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Amo̱se̱‑ɔ ne̱ baa kra mò̱ gyi amo̱ mɔɔ, ne̱ baa lee mò̱ kifuniŋ le̱e̱ ko̱dɔɔ‑ɔ‑rɔ twe̱e̱ ke̱mo̱ bo̱ kyo̱ŋwe̱ bobe ko̱dɔɔ amo̱ kamɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ne̱ Yeesuu a bise bamo̱ fe̱yɛ, “To, mo̱ne̱ e̱ kɔɔre̱ mo̱ne̱ i gyi fe̱yɛ e̱me̱ne̱ ne̱ bobe ko̱dɔɔ‑ɔ wuye‑o e̱ waa apafo̱wɔ amo̱‑ɔ ne̱e̱? Mo̱ e̱ fa fe̱yɛ mò̱ fɔŋfɔŋ e̱ yɔ ne̱e̱ na ɔ ya mɔɔ ase̱sɛ‑ɔ pɛɛɛ na ɔ be̱e̱ taa ko̱dɔɔ‑ɔ sa ase̱sɛ baŋbaŋ na bo̱ de̱e̱re̱ se̱ sa mò̱. Amo̱ e̱ gye̱ saase̱bɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Mo̱ a kɔɔre̱ gyi fe̱yɛ mo̱ne̱ a kare̱ abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ, ‘Ke̱fo̱re̱ serisɛ ko̱ ne̱ apwɛɛpo̱ de bo̱ pwɛɛ ne̱ baa kine ke̱mo̱ bo̱ twe̱e̱‑ɔ, ya ko̱ŋ bo̱ kii ke̱mo̱ ne̱ kaa le̱ŋ lɔŋ‑ɔ pɛɛɛ bo̱ ye̱ra‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Wuribware̱ ya sa ne̱ aa ba ane̱ŋ, ne̱ aa kpe̱ŋ ane̱ e̱ye̱e̱ ke̱baŋse̱.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yeesuu a sa se̱ŋsa lo̱we̱‑ɔ, ne̱ Yudaa awuye agye̱ŋkpɛɛpo̱‑ɔ e̱ kpa a bo̱ kra mò̱, a le̱e̱ fe̱yɛ baa ŋu fe̱yɛ mò̱ apafo̱wɔ bɔye̱ ko̱ kitee‑o a kye bamo̱. Amaa bamo̱ a se̱re̱ lamaŋ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ se̱‑ɔ, ne̱ baa nare̱ yɔwe̱ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Amo̱ kamɛɛ‑rɔ, ne̱ baa suŋ Farisii awuye na Owure Hɛrɔd aye̱re̱rɔpo̱ fe̱yɛ bo̱ ya bise Yeesuu ase̱ŋ lɔɔre̱ mò̱ kanɔ‑rɔ, na ɔ tɔwe̱ ke̱bɔye̱ ko̱, na bo̱ nya kra mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bamo̱ a yɔ Yeesuu ase̱‑ɔ, ne̱ baa bo̱ tɔwe̱ kɔne̱ kɔne̱ gywii mò̱ fe̱yɛ, “Ɔkaapo̱po̱, ane̱ nyi fe̱yɛ kase̱ŋtiŋ wuye e̱ gye̱ fo̱, na fo̱ maa pe̱nna ɔko̱, na kufu mo̱ŋ de fo̱ ase̱sɛ ko̱tɔwe̱ fo̱ ase̱ŋ se̱. Fo̱ mo̱ŋ nyi fe̱yɛ se̱sɛ mɔ gye̱ se̱sɛ dabe̱ bɛɛɛ ɔ gye̱ kagyingyii, fo̱ fe̱raa fo̱ e̱ kaapo̱ atɔ kase̱ŋtiŋ ne̱ Wuribware̱ e̱ kpa fe̱yɛ se̱sɛ dimaadi ke̱maa waa‑ɔ. Roma awuye a kɔ ke̱naa gyi ane̱ se̱ kɔɔre̱ ane̱ maŋ‑ɔ se̱‑ɔ, ane̱ ya ka leŋpoo sa bamo̱ owure dabe̱ ne̱ ba te̱e̱ mò̱ ɛ Kaye̱saa‑ɔ, a kye ane̱ Wuribware̱ mbraa‑ɔ, bɛɛɛ a maa kye? Tɔwe̱ na ane̱ nu.” ");
INSERT INTO ncuNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Amaa Yeesuu mɔ a kyɔ ŋu fe̱yɛ bo̱ de se̱ŋbise mɔ ba kyɔ mò̱‑rɔ ke̱e̱ ne̱e̱. Amo̱se̱‑ɔ, ne̱ ɔɔ be̱ŋŋaa bamo̱ fe̱yɛ, “Nte̱tɔ ne̱e̱ ne̱ mo̱ne̱ e̱ kyɔ mo̱‑rɔ mo̱ne̱ e̱ ke̱e̱‑ɔ ne̱e̱? Mo̱nꞌ taa atanne̱ fufuri kigyi ne̱ kaa fo̱ siidii kudu‑o, ne̱ mo̱ne̱ de mo̱ne̱ e̱ ka leŋpoo‑o baa mo̱ a ŋ ke̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bamo̱ a taa baa‑ɔ, ne̱ oo bise bamo̱ fe̱yɛ, “Nsɛ fotoo na ke̱nyare̱ e̱ dɔŋ atanne̱ mɔ se̱‑ɔ ne̱e̱?” Ne̱ baa be̱ŋŋaa mò̱ fe̱yɛ, “Owure Kaye̱saa lee ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ne̱ Yeesuu yɛ, “To, amo̱ fe̱raa, mo̱nꞌ ka ke̱tɔ ne̱ ke̱ gye̱ Kaye̱saa lee‑o sa Kaye̱saa, na mo̱nꞌ ka ke̱mo̱ ne̱ ke̱ gye̱ Wuribware̱ lee‑o sa Wuribware̱.” Ne̱ ane̱ŋ ne̱ Yeesuu a be̱ŋŋaa‑ɔ a kpe̱ŋ bamo̱ e̱ye̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Amo̱ kamɛɛ‑rɔ, ne̱ Sadukii awuye ko̱ a ba Yeesuu ase̱ ane̱ŋ dɛɛ, na bo̱ bo̱ bise mò̱ ase̱ŋ. Amɔ Sadukii awuye mɔ mɔ gye̱ Yudaa awuye ko̱ ne̱ ba kɔɔre̱ ba gyi fe̱yɛ se̱sɛ ya wu, mò̱ kayo̱wɔre̱ na mò̱ kra pɛɛɛ a wu, ne̱ ane̱ŋ se̱‑ɔ ɔ maa lɛɛ taare̱ a o kyiŋŋi le̱e̱ lowi‑ro pɛɛɛ‑ɔ ne̱e̱. To, ne̱ baa bise Yeesuu fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ɔkaapo̱po̱, ane̱ ɔde̱daapo̱ Mosis ya kyo̱rɛɛ mbraa mɔ sa ane̱ Yudaa awuye fe̱yɛ, ɔko̱ ya wu yɔwe̱ mò̱ ka na bo̱ mo̱ŋ ko̱we̱ agyi, se̱sɛ‑ɔ mò̱ tire taa kpenlekye̱e̱‑ɔ waare̱e̱, na bo̱ nya ko̱we̱ kayaagyi. Na bo̱ taa kamo̱ fe̱yɛ mò̱ daa ne̱ oo wu‑o mò̱ gyi ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","To, ɔnyare̱ ko̱ agyi nyaŋsɛ asunoo e̱ dɛɛ bo̱ bo̱‑rɔ. Ne̱ bamo̱‑rɔ ɔbre̱sɛ‑ɔ a waare̱e̱, ne̱ ɔɔ bo̱ wu yɔwe̱ ɔkye̱e̱‑ɔ na mò̱ aa mò̱ ka‑ɔ mo̱ŋ ko̱we̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ne̱ ɔnyɔse̱po̱‑ɔ a bo̱ taa mò̱ be̱e̱ waare̱e̱. Amaa mò̱ aa mò̱ be̱e̱ bo̱ mo̱ŋ ko̱we̱, ne̱ ɔnyare̱‑ɔ a wu. Ɔsase̱po̱‑ɔ gbaa ane̱ŋ dɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bamo̱ asunoo pɛɛɛ a waare̱e̱ bamo̱ daa a kpenlekye̱e̱ amo̱ gyaŋŋe̱ se̱, ne̱ baa wu yɔwe̱ mò̱, na mò̱ aa bamo̱ ɔko̱ mo̱ŋ ko̱we̱ gyi ko̱ŋko̱ gbaa. A bo̱‑rɔ ne̱ ɔkye̱e̱‑ɔ mɔ a bo̱ wu gya bamo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ne̱ mbe̱yɔmɔ bo̱ yɛ ɔke̱maa i kyiŋŋi a ɔ le̱e̱ lowi‑ro‑o. Kake nsi amo̱ bamo̱‑rɔ nsɛ e̱ gye̱ ɔkye̱e̱‑ɔ mò̱ kuri? Bo̱ le̱e̱ fe̱yɛ bamo̱ pɛɛɛ mɔ a waare̱e̱ mò̱ bo̱ gyaŋŋe̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Mfe̱ŋ ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “Mo̱ne̱ a fo̱ kpa, a le̱e̱ fe̱yɛ mo̱ne̱ mo̱ŋ nyi abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ ase̱ŋ, ne̱ mo̱ne̱ mo̱ŋ nyi ane̱ŋ ne̱ Wuribware̱ ke̱yaale̱ŋ du‑o, ane̱ŋ dɛɛ mo̱ne̱ maa nu ke̱mo̱ kaase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","A le̱e̱ fe̱yɛ se̱sɛ ya kyiŋŋi le̱e̱ lowi‑ro, mò̱ kakye̱na‑rɔ du ne̱e̱ fe̱yɛ Wuribware̱ a mbɔɔ ne̱ bo̱ bo̱ so̱so̱‑ɔ lee‑o, amo̱se̱‑ɔ awaare̱yɛ mo̱ŋ lɛɛ a bo̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","To, mo̱ne̱ fe̱raa, mo̱ne̱ yɛ alowipo̱‑ɔ maa lɛɛ kyiŋŋi a bo̱ le̱e̱ lowi‑ro. Amaa mo̱ i bise mo̱ne̱ fe̱yɛ mo̱ne̱ mo̱ŋ kare̱ kiyii ko̱ ne̱ ke̱ e̱ kywɛɛ‑ɔ ase̱ŋ Mosis a wo̱re̱‑ɔ‑rɔ aaa? Mfe̱ŋ‑ɔ ɔɔ kyo̱rɛɛ ne̱e̱ fe̱yɛ, Wuribware̱ a tɔwe̱ gywii mò̱ fe̱yɛ, ‘Mo̱ e̱ gye̱ Wuribware̱, nyaŋpe̱ ne̱ fo̱ nana‑ana Abraham na Isak na Yakubu i suŋ‑o.’ ");
INSERT INTO ncuNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Amo̱ e̱ gye̱ fe̱yɛ ane̱ ade̱daapo̱ amo̱ ne̱ baa wu‑o a saŋ ba suŋ Wuribware̱‑ɔ se̱‑ɔ, a kaapo̱ ne̱e̱ fe̱yɛ bamo̱ a wu gbaa ooo, bamo̱ e̱kra saŋ i te. Amo̱se̱ se̱‑ɔ, mo̱ne̱ e̱ fo̱ kpa ase̱ŋ mɔ ke̱kaapo̱‑rɔ‑ɔ‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Amɔ Wuribware̱ mbraa ɔkaapo̱po̱ ko̱ mɔ bo̱ mfe̱ŋ, ne̱ oo nu ke̱tɔ ne̱ Yeesuu na Sadukii awuye e̱ tɔwe̱ ke̱mo̱ ase̱ŋ‑ɔ. Amo̱se̱‑ɔ, mò̱ a ŋu fe̱yɛ Yeesuu a be̱ŋŋaa Sadukii awuye‑o nɛɛnɛɛ‑ɔ se̱‑ɔ, ne̱ ɔɔ ba Yeesuu ase̱ bo̱ bise mò̱ fe̱yɛ, “Mbraa‑ɔ pɛɛɛ‑rɔ mmo̱ e̱ gye̱ ne̱ n tiri‑o ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ne̱ Yeesuu a be̱ŋŋaa mò̱ fe̱yɛ, “Mmo̱ ne̱ n tiri‑o e̱ gye̱ fe̱yɛ, ‘Isireelii awuye, mo̱nꞌ lɔŋ e̱se̱bɔ na mo̱nꞌ nu fe̱yɛ ane̱ mo̱ŋ de nyaŋpe̱ ko̱ bo̱ tii Wuribware̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Lee fo̱ kame‑ro ba fo̱ kakpo̱nɔ na fo̱ mfɛɛre̱ na fo̱ ke̱yaale̱ŋ pɛɛɛ bo̱ kpa fo̱ nyaŋpe̱ Wuribware̱ ase̱ŋ.’ ");
INSERT INTO ncuNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mbraa ne̱ n tiri ne̱ n gya se̱ nyɔse̱po̱‑ɔ e̱ gye̱ fe̱yɛ, ‘Kpa fo̱ bɛɛko̱ ase̱ŋ fe̱yɛ ane̱ŋ ne̱ fo̱ e̱ kpa fo̱ e̱ye̱e̱‑ɔ.’ Amo̱se̱‑ɔ, mbraa ko̱ mo̱ŋ lɛɛ m bo̱‑rɔ ne̱ n tiri fe̱yɛ ŋnyɔ mɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mfe̱ŋ ne̱ Wuribware̱ mbraa ɔkaapo̱po̱‑ɔ a tɔwe̱ gywii Yeesuu fe̱yɛ, “Fo̱ a waa atɔ, ɔkaapo̱po̱. Na a gye̱ kase̱ŋtiŋ ne̱e̱ fe̱yɛ fo̱ a tɔwe̱ ɛ ane̱ mo̱ŋ de nyaŋpe̱ ko̱ bo̱ tii Wuribware̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Na ane̱ lee ane̱ mme‑ro ba ane̱ ŋkpo̱nɔ na ane̱ mfɛɛre̱ na ane̱ ke̱yaale̱ŋ pɛɛɛ bo̱ kpa ane̱ nyaŋpe̱ Wuribware̱ ase̱ŋ, na ane̱ be̱e̱ kpa ane̱ abɛɛko̱ ase̱ŋ fe̱yɛ ane̱ŋ ne̱ ane̱ e̱ kpa ane̱ e̱ye̱e̱‑ɔ. A tiri fe̱yɛ ane̱ bu mbraa ŋnyɔ mɔ kyo̱ŋ ane̱ baa alɔŋŋɔtɔ bɛɛɛ ane̱ mɔɔ mbo̱ bo̱ kywɛɛ bo̱ lɔŋŋɔ Wuribware̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Amo̱ fe̱raa Yeesuu a ŋu fe̱yɛ ɔɔ be̱ŋŋaa mò̱ nɛɛnɛɛ‑ɔ, ne̱ ɔɔ tɔwe̱ gywii mò̱ fe̱yɛ, “A saŋ kafwe̱e̱ ne̱e̱ na fo̱ waa siraa lo̱we̱ na fo̱ tii Wuribware̱ a kuwure‑o si.” Amo̱ kamɛɛ‑rɔ ɔko̱ mo̱ŋ lɛɛ taare̱ bise Yeesuu ke̱se̱ŋ ko̱ mfe̱ŋ daa. ");
INSERT INTO ncuNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yeesuu a saŋ ɔ bo̱ Wuribware̱ suŋkpa a kabuno‑o ɔ kaapo̱ lamaŋ‑ɔ, ne̱ oo bise ase̱ŋ ko̱ bo̱ teere ase̱ŋ ne̱ baa bise mò̱‑ɔ fe̱yɛ, “E̱me̱ne̱ se̱ ne̱ Wuribware̱ mbraa akaapo̱po̱‑ɔ e̱ tɔwe̱ fe̱yɛ mò̱ ne̱ Wuribware̱ i suŋ a ɔ bo̱ kyo̱ŋwe̱‑ɔ ne̱ ba te̱e̱ ɛ Kristoo‑o e̱ le̱e̱ Owure Deefid a ke̱nana‑ɔ‑rɔ‑ɔ ne̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Na Wuribware̱ a kufwiiŋe timaa‑o mɔ a sa ne̱ Deefid fɔŋfɔŋ gbaa a tɔwe̱ fe̱yɛ, ‘Wuribware̱ a tɔwe̱ gywii mo̱ nyaŋpe̱ ne̱e̱ ɛ, Kye̱na mo̱ kigyise si mfe̱e̱ na n sa a fo̱ ado̱ŋ pɛɛɛ mɔ ba fo̱ kaase̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","To, Deefid a kyo̱rɛɛ ase̱ŋ amo̱ ne̱ Wuribware̱ a tɔwe̱ gywii ɔko̱ ne̱ o te mò̱ ase̱‑ɔ, Kristoo ne̱ ɔɔ tɔwe̱ gywii. Amo̱ a gye̱ ane̱ŋ‑ɔ se̱‑ɔ, ne̱ Deefid fɔŋfɔŋ a kyo̱rɛɛ te̱e̱ Kristoo fe̱yɛ mò̱ nyaŋpe̱, bamo̱ ya ko̱we̱ Kristoo ne̱ ɔɔ waa se̱sɛ dimaadi, e̱me̱ne̱ ne̱ ɔ waa a ɔ le̱e̱ Deefid a ke̱nana‑ɔ‑rɔ, na Deefid a kyɔ te̱e̱ Kristoo fe̱yɛ mò̱ nyaŋpe̱‑ɔ?” Ne̱ lamaŋ ne̱ bo̱ bo̱ mfe̱ŋ ba nu ase̱ŋ ne̱ Yeesuu e̱ tɔwe̱‑ɔ akatɔ a gyi amo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mò̱ a kaapo̱ bamo̱‑ɔ, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱nꞌ sa Wuribware̱ mbraa akaapo̱po̱‑ɔ se̱. Bamo̱ e̱ gye̱ ne̱ bo̱ naa bo̱ buŋ akaare̱ so̱swe̱e̱ lamaŋ‑nɔ, ba kpa fe̱yɛ ase̱sɛ de̱e̱ nya gyɔŋŋɔ ka bamo̱ nnɔ, ");
INSERT INTO ncuNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ne̱ bo̱ te ngya dabe̱ se̱ ke̱bware̱ko̱re̱ akyaŋ‑nɔ na ateese gyikpa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bamo̱ e̱ gye̱ ne̱ ba puni akpenlekye̱e̱ ba kɔɔre̱ bamo̱ e̱lɔŋ, na ba ko̱re̱ ke̱bware̱ko̱re̱ ane̱ŋ‑aaa, na ase̱sɛ nya ŋu saŋ amo̱ fe̱yɛ bo̱ tɛɛ bo̱ gya Wuribware̱ se̱ nɛɛnɛɛ. Mfaanɛɛ se̱‑ɔ, Wuribware̱ i gyiiri bamo̱ ke̱se̱bɔ bwe̱e̱tɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Amɔ Yeesuu te Wuribware̱ suŋkpa a kabuno‑o me̱ra mfe̱ŋ ne̱ bo̱ de bamo̱ atanne̱ ba waa ke̱dakaa‑rɔ‑ɔ, na ɔ de̱e̱re̱ ase̱sɛ ne̱ bo̱ de bamo̱ atanne̱ ba waa‑rɔ‑ɔ. Atɔ awuye bwe̱e̱tɔ e̱ waa‑rɔ atanne̱ dabe̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ne̱ kpenlekye̱e̱ otiripo̱ ko̱ mɔ a bo̱ taa e̱paso̱wa adunyɔ kpeŋ waa‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Mfe̱ŋ ne̱ Yeesuu a te̱e̱ mò̱ agyase̱po̱‑ɔ bo̱ gyaŋŋe̱, ne̱ ɔ yɛ, “Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ kpenlekye̱e̱ otiripo̱ mɔ a afɔre̱yɛ‑ɔ kyɔ ɔke̱maa lee‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bo̱ le̱e̱ fe̱yɛ atɔ awuye‑o a lee bamo̱ atanne̱ ne̱ bo̱ de‑o si‑o kafwe̱e̱ ne̱e̱ baa bo̱ bɔ afɔre̱yɛ, amaa kpenlekye̱e̱ otiripo̱ mɔ fe̱raa, ke̱tɔ ne̱ o de‑o pɛɛɛ ne̱ ɔɔ taa bo̱ bɔ afɔre̱yɛ‑ɔ. Mò̱ kapo̱tɛɛ pɛɛɛ ne̱ o de‑o ne̱ ɔɔ taa baa‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Saŋ ne̱ Yeesuu e̱ le̱e̱ Wuribware̱ suŋkpa‑ɔ, ne̱ mò̱ agyase̱po̱‑ɔ ɔko̱ a tɔwe̱ ɛ, “Ɔkaapo̱po̱, ke̱e̱ ane̱ŋ ne̱ afo̱re̱ mɔ ne̱ baa bo̱ pwɛɛ Wuribware̱ suŋkpa mɔ‑ɔ a waa suŋkpa‑ɔ daŋ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Fo̱ a ŋu ane̱ŋ ne̱ akyaŋ dabe̱ amo̱ du‑o ooo? Saŋ ko̱ e̱ ba a ɔ bo̱ ba na afo̱re̱ amo̱ ne̱ baa bo̱ pwɛɛ akyaŋ amo̱‑ɔ ko̱ko̱ŋko̱ gbaa maa sii mfe̱ŋ ne̱ ke̱ ye̱re̱ mbe̱yɔmɔ‑ɔ. Ba gye̱ra amo̱ pɛɛɛ a bo̱ bo̱ da.” ");
INSERT INTO ncuNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ke̱tɔ a waa kafwe̱e̱‑ɔ, ne̱ Yeesuu a yɔ o te Mfɔ-Ayii ke̱be̱e̱‑ɔ se̱, ne̱ mò̱ akatɔ ko̱re̱ Wuribware̱ suŋkpa‑ɔ se̱. Ne̱ Peetroo na Yakubu na Yohanee na Andruu abɛɛ ana wo̱re̱ a yɔ mò̱ ase̱ ya tɔwe̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tɔwe̱ gywii ane̱, saŋ mo̱ ne̱ ase̱ŋ mɔ pɛɛɛ ne̱ fo̱ a tɔwe̱ bo̱ le̱e̱ Wuribware̱ suŋkpa mɔ se̱‑ɔ e̱ ba? Ne̱ nte̱tɔ atɔ e̱ gye̱ ne̱ a waa pwɛɛ na ane̱ dɛɛ ŋu fe̱yɛ saŋ amo̱ a fo̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱nꞌ sa se̱ na ɔko̱ ma pe̱nna mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bo̱ le̱e̱ fe̱yɛ ase̱sɛ bwe̱e̱tɔ e̱ ba na bo̱ bo̱ pe̱nna mo̱ne̱ ɛ, ‘Mo̱ e̱ gye̱ Kristoo ne̱ Wuribware̱ a suŋ bo̱ kyo̱ŋwe̱‑ɔ’, na bo̱ de mo̱ ke̱nyare̱ ba tɔwe̱ ase̱ŋ na bo̱ pe̱nna ase̱sɛ bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Saŋ amo̱ mo̱ne̱ ya nu e̱kɔ na anaa se̱ me̱ra mo̱ne̱ bɛɛɛ ke̱fɔ ke̱fɔ ooo, mo̱ne̱ ma sa amo̱ ase̱ŋ tiri mo̱ne̱, a le̱e̱ fe̱yɛ a waa kanɔ ŋke̱maa a ba ane̱ŋ pwɛɛ. Amaa n gye̱ amo̱ e̱ gye̱ ne̱ a kaapo̱ fe̱yɛ kaye̱ e̱ kpa a ka gye̱ kɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ e̱maŋ e̱ kɔ abɛɛ, na swe̱e̱re̱ ko̱ se̱ ase̱sɛ kɔ swe̱e̱re̱ ko̱ mɔ se̱ ase̱sɛ. Na swe̱e̱re̱ le̱e̱ ɔ le̱ŋkpaŋ, na ako̱ŋ ba e̱swe̱e̱re̱ bwe̱e̱tɔ se̱. Amo̱‑ɔ pɛɛɛ du ne̱e̱ fe̱yɛ ɔkye̱e̱ a duŋwi pwɛɛ ne̱ ɔ dɛɛ bo̱ ko̱we̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Mo̱nꞌ sa se̱, a le̱e̱ fe̱yɛ ba kperi ane̱ŋ ne̱ mo̱ne̱ gye̱ mo̱ agyase̱po̱‑ɔ se̱ na bo̱ kra mo̱ne̱ yaa ane̱ Yudaa awuye maŋ abre̱sɛ ase̱. Na bo̱ be̱e̱ daye̱ mo̱ne̱ ane̱ ke̱bware̱ko̱re̱ akyaŋ abre̱sɛ akatɔ‑rɔ. Na mo̱nꞌ ye̱re̱ agominaa na awure akatɔ‑rɔ, na mo̱nꞌ tɔwe̱ abware̱se̱ŋ gywii bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Amaa a tiri fe̱yɛ ase̱sɛ pɛɛɛ nu ase̱ŋ timaa pwɛɛ na kaye̱ dɛɛ gye̱ kɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Saŋ ne̱ ba kra mo̱ne̱ a bo̱ yaa ane̱ŋ a e̱se̱ŋgyikpa‑ɔ, mo̱ne̱ ma kaŋ sa a ase̱ŋ ne̱ mo̱ne̱ e̱ ya tɔwe̱ mfe̱ŋ‑ɔ mfɛɛre̱ tɔɔraa mo̱ne̱. Saŋ‑ɔ ya fo̱, mo̱nꞌ tɔwe̱ ke̱tɔ ne̱ ke̱ bo̱ mo̱ne̱ mfɛɛre̱‑rɔ‑ɔ, a le̱e̱ fe̱yɛ ke̱tɔ ne̱ mo̱ne̱ e̱ tɔwe̱ mfe̱ŋ‑ɔ maa le̱e̱ mo̱ne̱ fɔŋfɔŋ ase̱, ke̱ e̱ le̱e̱ Wuribware̱ a kufwiiŋe timaa‑o ase̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Saŋ amo̱ dɛɛ na se̱sɛ yaa mò̱ daa bɛɛɛ mò̱ tire na bo̱ mɔɔ mò̱. Na ase̱ mɔ yaa bamo̱ gyi‑ana a bo̱ mɔɔ bamo̱. Na ŋyaagyi mɔ ye̱re̱ bo̱ kye bamo̱ ase̱ na anyi ba kpa bamo̱ a bo̱ mɔɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ɔke̱maa i kperi mo̱ se̱, na o kisi mo̱ne̱. Amaa mo̱ e̱ mo̱rɔwe̱ ɔke̱maa ne̱ ɔ taare̱ a ɔ ye̱re̱ keŋkeŋ bo̱ fo̱ ase̱ŋ amo̱ kɛɛ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Wuribware̱ kyaamɛɛ Daniyɛl a kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ ‘Saŋ ko̱ e̱ ba a ɔ bo̱ ba ne̱ mo̱ne̱ ado̱ŋ e̱ ba iyisi atɔ ko̱ a bo̱ bo̱ ye̱ra mfe̱ŋ ne̱ a mo̱ŋ bware fe̱yɛ a ye̱re̱‑ɔ, na bo̱ bo̱ sa a Wuribware̱ suŋkpa‑ɔ nye̱ra.’ ” (Fo̱ ne̱ fo̱ e̱ kare̱ amo̱‑ɔ, fo̱ a nu kaase̱ aaa?) “Saŋ amo̱, bamo̱ ne̱ bo̱ bo̱ Yude̱ya swe̱e̱re̱ se̱‑ɔ, se̱re̱ yɔ abe̱e̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Na bamo̱ ne̱ bo̱ bo̱ kawu‑o ma kpo̱ne̱ bamo̱ e̱ye̱e̱ kiŋŋi yɔ lɔŋ‑nɔ fe̱yɛ ba ya taa ko̱tɔko̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Na bamo̱ ne̱ bo̱ bo̱ ndɔɔ‑rɔ‑ɔ mɔ ma kiŋŋi ba pe̱ fe̱yɛ ba ba a bo̱ bo̱ taa bamo̱ awaagya. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ŋke nsi amo̱ adaŋpo̱kye̱e̱ na atrapo̱ i ŋu ase̱ŋ ne̱e̱ fɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mo̱nꞌ ko̱re̱ Wuribware̱ fe̱yɛ amo̱‑ɔ ma waa saŋ ne̱ kpa kutu bo̱ le̱ŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","A le̱e̱ fe̱yɛ saŋ amo̱ a ase̱ŋ‑ɔ e̱ waa le̱ŋ bwe̱e̱tɔ a kyo̱ŋ ase̱ŋ ke̱maa ne̱ a kyɔ waa le̱e̱ hare̱e̱ saŋ ne̱ Wuribware̱ a twe̱e̱ kaye̱‑ɔ bo̱ fo̱ ndɔɔ‑ɔ. Ase̱ŋ ko̱ mɔ maa lɛɛ ba na a du fe̱yɛ amo̱ daa. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Amaa Wuribware̱ a te̱ŋ ŋke ne̱ weetee ase̱ŋ amo̱ e̱ waa‑ɔ se̱. Ɔ dɛɛ ɔ mo̱ŋ te̱ŋ se̱ fe̱raa ne̱e̱, weetee ɔko̱ maa saŋ kaye̱ mɔ‑rɔ. Bo̱ le̱e̱ bamo̱ ne̱ Wuribware̱ a lee sa mò̱ e̱ye̱e̱‑ɔ se̱ ne̱ ɔɔ te̱ŋ ŋke‑o si. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Saŋ amo̱ ɔko̱ ya tɔwe̱ gywii mo̱ne̱ fe̱yɛ, ‘Ke̱e̱ Kristoo ne̱ Wuribware̱ a suŋ‑o e̱ ye̱re̱ mfe̱e̱‑ɔ,’ bɛɛɛ ‘Mò̱ e̱ ye̱re̱ nno̱ŋ‑ɔ,’ mo̱ne̱ ma kɔɔre̱ mò̱ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","A le̱e̱ fe̱yɛ bo̱ko̱ e̱ ba a bo̱ bo̱ pe̱nna mo̱ne̱ fe̱yɛ bamo̱ e̱ gye̱ Kristoo‑o, na bo̱ko̱ mɔ pe̱nna fe̱yɛ bamo̱ e̱ gye̱ Wuribware̱ a akyaamɛɛ‑ɔ bo̱ko̱. Ba ba a bo̱ bo̱ waa akpe̱ŋe̱ye̱e̱tɔ dabe̱ bo̱ kaapo̱ fe̱yɛ bamo̱ e̱le̱ŋ‑ɔ a le̱e̱ Wuribware̱ ase̱‑ɔ, na bo̱ nya pe̱nna bamo̱ gbaa ne̱ Wuribware̱ a lee sa mò̱ e̱ye̱e̱‑ɔ. Bamo̱ e̱ taare̱ fe̱raa de. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Amo̱se̱‑ɔ, mo̱nꞌ sa se̱. Mo̱ a tɔwe̱ ke̱tɔ ke̱maa gywii mo̱ne̱ pwɛɛ a saŋ amo̱ dɛɛ fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Ŋke amo̱‑rɔ saŋ ne̱ ase̱ŋ dabe̱ amo̱ a kyo̱ŋ‑ɔ, ‘Kyɔwe̱ ya le̱e̱, ke̱tɔ e̱ gyase̱, na oferi mɔ ma lɛɛ laŋŋe̱‑rɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","‘Na akye̱e̱‑e̱‑kpa‑agyi kyuwi le̱e̱ daye̱ bwee‑ro pupuri, na ke̱tɔ ke̱maa ne̱ ke̱ bo̱ awo̱re̱‑rɔ‑ɔ pɛɛɛ ma lɛɛ waa kyɛɛkyɛɛ.’ ");
INSERT INTO ncuNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ŋkee na mo̱, dimaadi mò̱ gyi‑o, le̱e̱ so̱so̱ n te awo̱re̱‑rɔ mo̱ e̱ ba ke̱yaale̱ŋ dabe̱‑rɔ na ke̱laŋŋe̱rɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Na n suŋ mo̱ mbɔɔ le̱e̱ so̱so̱ ba swe̱e̱re̱ mɔ se̱ mfe̱e̱, na bo̱ yɔ ke̱bare̱ ke̱maa ya kpɔwe̱ ase̱sɛ ne̱ Wuribware̱ a lee sa mò̱ e̱ye̱e̱‑ɔ pɛɛɛ le̱e̱ swe̱e̱re̱ ke̱maa se̱ bo̱ gyaŋŋe̱ to̱ŋ ko̱ŋko̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Mo̱nꞌ sa a figi kiyii kaapo̱ mo̱ne̱ kanyiase̱ŋ. Mo̱ne̱ nyi fe̱yɛ ke̱mo̱ ya ba ke̱ e̱ kpa a ke̱ pɔwe̱, amɔ ke̱kyaare̱ e̱ kpa a ke̱ fo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","To, ane̱ŋ dɛɛ ne̱ mo̱ne̱ ya ŋu fe̱yɛ ase̱ŋ mɔ pɛɛɛ e̱ waa, amɔ mo̱nꞌ pini fe̱yɛ saŋ e̱ kpa a ɔ fo̱ fe̱yɛ m be̱e̱ kiŋŋi ba. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ ndɔɔ a kaye̱ mɔ‑rɔ a ase̱sɛ‑ɔ bo̱ko̱ i ŋu saŋ ne̱ atɔ mɔ e̱ ba‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","So̱so̱ na swe̱e̱re̱ pɛɛɛ ase̱ŋ e̱ kyo̱ŋ, amaa mo̱ ase̱ŋ‑ɔ fe̱raa maa kyo̱ŋ daa.” ");
INSERT INTO ncuNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ne̱ Yeesuu a tɔwe̱ bo̱ gye̱ kɛɛ fe̱yɛ, “Amaa ɔko̱ mo̱ŋ nyi kake nsi ne̱ mo̱ e̱ ba a m bo̱ kiŋŋi ba‑ɔ. Wuribware̱ mbɔɔ‑ɔ, bɛɛɛ mo̱, dimaadi mò̱ gyi‑o, gbaa, mo̱ŋ nyi kake suyo‑o. Amɔ ane̱ se̱ Wuribware̱ wo̱re̱ kpeŋ i nyi. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Amo̱se̱‑ɔ, ɔke̱maa sa se̱ na ɔ waa siraa, a le̱e̱ fe̱yɛ ɔko̱ mo̱ŋ nyi saŋ amo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","A du ne̱e̱ fe̱yɛ kawurenyare̱ ko̱ a kpa a o tu kpa, ne̱ oo ke kusuŋ‑no sa mò̱ ayaafɔre̱ fe̱yɛ bo̱ waa, ne̱ ɔɔ tɔwe̱ gywii mò̱ lɔŋ ɔde̱e̱re̱se̱po̱ fe̱yɛ ɔ de̱e̱re̱ mò̱ lɔŋ se̱ bo̱ fo̱ saŋ ne̱ ɔ ba‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Amo̱se̱‑ɔ, mo̱nꞌ sa se̱, a le̱e̱ fe̱yɛ ɔko̱ mo̱ŋ nyi saŋ ne̱ lɔŋ wuye‑o de ɔ ba‑ɔ, nsaŋse̱ kade̱e̱pwɛta bɛɛɛ kanye bɛɛɛ kaye̱ nse̱na bɛɛɛ gye̱gyaye̱ kese‑ro ne̱ ɔ ba. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mò̱ ya fu‑ro ba, mo̱ne̱ ma sa a ɔ bo̱ to̱ fe̱yɛ mo̱ne̱ a di idi. ");
INSERT INTO ncuNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ke̱tɔ ne̱ mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱‑ɔ, ne̱ mo̱ e̱ tɔwe̱ a n gywii ase̱sɛ pɛɛɛ‑ɔ e̱ gye̱ fe̱yɛ mo̱nꞌ sa se̱ na mo̱nꞌ kyiŋŋi kye̱na.” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Amo̱ a saŋ ŋke ŋnyɔ a Bodododoo ne̱ yiisi mo̱ŋ te‑ro‑o na Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese‑o agyibe̱e̱ dɛɛ fo̱‑ɔ, ne̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na Wuribware̱ mbraa akaapo̱po̱‑ɔ a le̱e̱ ba kpa e̱kpa ne̱ ba bo̱rɔ se̱ a bo̱ kra Yeesuu na ɔko̱ mo̱ŋ ŋu‑o, na bo̱ mɔɔ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Amaa bo̱ yɛ, “Ane̱ ma kra mò̱ Wuribware̱-a‑kya-ane̱-yɔwe̱ a kigyi a ŋke‑o‑ro, a le̱e̱ fe̱yɛ ane̱ ya kra mò̱ ŋke amo̱‑rɔ, lamaŋ maa sure, na bamo̱ iduŋ fwii, na bo̱ baa e̱kɔ maŋ‑nɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Amo̱ kamɛɛ‑rɔ Yeesuu a yɔ ɔ bo̱ Bɛtaniya kamaŋgyii‑ro‑o, ne̱ ɔɔ yɔ o te Simɔŋ ne̱ ɔ dɛɛ ɔ gye̱ bwatɔpo̱‑ɔ aye̱ o gyi. Ne̱ ɔkye̱e̱ ko̱ a kra mò̱ laŋpe̱ŋtaa yawo̱ le̱ŋsɛ ko̱ lweero. Laŋpe̱ŋtaa mɔ bo̱ kalɔgyii dame̱naŋsɛ ko̱ ne̱ baa taa kibu ne̱ ba te̱e̱ ke̱mo̱ ɛ alabase̱taa‑ɔ bo̱ waa‑ɔ‑rɔ ne̱e̱. Ne̱ ɔɔ da kalɔgyii ne̱ laŋpe̱ŋtaa‑ɔ bo̱‑rɔ‑ɔ kanɔ bwee taye̱ se̱, ne̱ oo twiiri we̱e̱ Yeesuu kuŋu si. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ne̱ bamo̱ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ bo̱ko̱ iduŋ a fwii, ne̱ bo̱ yɛ, “Nte̱tɔ e̱ gye̱ laŋpe̱ŋtaa amo̱ ke̱nye̱ra ane̱ŋ? ");
INSERT INTO ncuNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Oo fe laŋpe̱ŋtaa mɔ ne̱e̱, weetee ɔ nya a ɔ kyo̱ŋ siidii ŋkpe̱ŋ nna, na ɔ taa atanne̱‑ɔ bo̱ sa atiripo̱.” Ne̱ baa po̱rɔ ɔkye̱e̱ amo̱ bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Amaa Yeesuu a tɔwe̱ gywii bamo̱ ne̱e̱ fe̱yɛ, “Mo̱nꞌ yɔwe̱ ɔkye̱e̱‑ɔ. Nte̱tɔ se̱ ne̱ mo̱ne̱ e̱ waa mò̱ ane̱ŋ? M fe̱raa mo̱ ase̱, atɔ timaa na adame̱naŋsɛ ne̱ ɔɔ waa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mo̱ne̱ de atiripo̱ mo̱ne̱ ase̱ saŋ ke̱maa, amo̱se̱‑ɔ saŋ ke̱maa ne̱ mo̱ne̱ e̱ kpa‑ɔ, mo̱ne̱ e̱ taare̱ a mo̱nꞌ kya bamo̱‑rɔ. Amaa m fe̱raa, mo̱ aa mo̱ne̱ maa kye̱na a ane̱ bo̱ yɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ke̱tɔ ne̱ ɔ taare̱‑ɔ ne̱ ɔɔ waa. Mò̱ a twiiri laŋpe̱ŋtaa‑ɔ we̱e̱ mo̱ se̱‑ɔ, a kaapo̱ ne̱e̱ fe̱yɛ ɔ lɔŋŋɔ mo̱ kayo̱wɔre̱ o gywii saŋ ne̱ mo̱ i wu na bo̱ pure mo̱‑ɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mbe̱yɔmɔ mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ kaye̱ mɔ pɛɛɛ‑rɔ to̱ŋ ke̱maa ne̱ ba tɔwe̱ abware̱se̱ŋ‑ɔ, bo̱ le̱e̱ ke̱tɔ ne̱ ɔkye̱e̱ mɔ a waa‑ɔ se̱‑ɔ, mò̱ ke̱nyare̱ maa muri amo̱‑rɔ daa.” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ne̱ Yudas Kariyotinyi ne̱ ɔ gye̱ Yeesuu agyase̱po̱ kudu anyɔ‑ɔ ɔko̱‑ɔ a yɔ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ ase̱ na ɔ ya gyi Yeesuu kidiburo gywii bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mò̱ a yɔ‑ɔ, bamo̱ akatɔ a gyi ke̱tɔ ne̱ o de ɔ tɔwe̱‑ɔ se̱, ne̱ bo̱ yɛ ba ba atanne̱ na bo̱ ka mò̱ ko̱kɔ. Amo̱se̱‑ɔ, ne̱ Yudas a le̱e̱ ɔ kpa e̱kpa ne̱ ɔ bo̱rɔ se̱ a ɔ nya ba Yeesuu bo̱ waa bamo̱ ke̱sare̱e̱‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kadawɔkywe̱e̱ a kake ne̱ ka gye̱ ŋkpɛɛ ne̱ ba gyi Bodobodoo-ne̱-yiisi-mo̱ŋ‑te‑ro‑o, na bo̱ mɔɔ nsanne̱gyii bo̱ gyi Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese‑o, ne̱ Yeesuu agyase̱po̱‑ɔ a bise mò̱ fe̱yɛ, “Mfe̱ne̱ ne̱ fo̱ e̱ kpa fe̱yɛ ane̱ ya lɔŋŋɔ sa fo̱ a fo̱ ya gyi Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese‑o ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ne̱ Yeesuu a suŋ bamo̱ abɛɛ anyɔ, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱nꞌ yɔ maŋ‑nɔ. Mo̱ne̱ ya yɔ, mo̱ne̱ e̱ gyaŋŋaa ɔnyare̱ ko̱ na ɔ so̱ kalɔ na nkyu. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Na mo̱nꞌ gya mò̱ se̱ ya lwee lɔŋ ne̱ o lweero‑o, na mo̱nꞌ tɔwe̱ gywii lɔŋ wuye‑o fe̱yɛ, ‘Ɔkaapo̱po̱‑ɔ yɛ, Ŋke̱e̱ ke̱kyaŋ ne̱ mo̱ aa mo̱ agyase̱po̱‑ɔ i gyi Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese‑o ke̱mo̱‑rɔ‑ɔ?’ ");
INSERT INTO ncuNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mfe̱ŋ‑ɔ, na ɔ kaapo̱ mo̱ne̱ abaŋso̱ro̱o̱ ke̱kyaŋ dabe̱ ko̱ ne̱ ke̱ bo̱ so̱so̱‑ɔ‑rɔ na baa kyɔ lɔŋŋɔ ke̱mo̱‑rɔ waa ngya na iteeburi bo̱ ye̱ra‑rɔ. Na mo̱nꞌ waa ke̱tɔ ke̱maa siraa bo̱ ye̱ra ane̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ne̱ mò̱ agyase̱po̱ anyɔ amo̱ a me̱raa se̱ yɔ maŋ‑ɔ‑rɔ. Bamo̱ a yɔ‑ɔ, ane̱ŋ ne̱ Yeesuu a tɔwe̱‑ɔ dɛɛ ne̱ baa ŋu. Ne̱ baa waa Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese‑o siraa mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kyɔwe̱ a lo̱we̱‑ɔ, ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱ kudu anyɔ‑ɔ a ba lɔŋ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Bamo̱ a te ba gyi‑o, ne̱ Yeesuu yɛ, “Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ ɔko̱ ne̱ mo̱ aa mò̱ i gyi gyare̱ ko̱ŋko̱‑rɔ‑ɔ i gyi mo̱ kidiburo.” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mò̱ a tɔwe̱ ane̱ŋ‑ɔ, ne̱ aa waa bamo̱ mfɛɛre̱ bwe̱e̱tɔ, ne̱ baa le̱e̱ ba bise mò̱ ke̱gyase̱ ke̱gyase̱ fe̱yɛ, “Kase̱ŋtiŋ ne̱e̱, mo̱ ne̱ fo̱ de, bɛɛɛ?” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “Mo̱ne̱ kudu anyɔ‑ɔ‑rɔ ɔko̱ ne̱e̱, ɔko̱ ne̱ mo̱ aa mò̱ ke̱sare̱e̱ di gyare̱ ko̱ŋko̱‑rɔ ane̱ i gyi‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mo̱, dimaadi mò̱ gyi‑o, i wu fe̱yɛ ane̱ŋ ne̱ baa kyo̱rɛɛ mo̱ ase̱ŋ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ. Amaa ɔko̱ ne̱ o gyi mo̱ kidiburo‑o i ŋu ase̱ŋ ne̱e̱ fɛɛ. Bo̱ dɛɛ bo̱ mo̱ŋ ko̱we̱ ane̱ŋ a se̱sɛ‑ɔ ne̱e̱, weetee a bɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Saŋ ne̱ bo̱ maa se̱ ba gyi‑o, ne̱ Yeesuu a taa bodobodoo, ne̱ ɔɔ sa Wuribware̱ aŋsɛ we̱e̱ se̱, ne̱ ɔɔ te̱ŋŋe̱‑rɔ sa mò̱ agyase̱po̱‑ɔ. Ne̱ ɔ yɛ, “Mo̱nꞌ kɔɔre̱ na mo̱nꞌ gyi. Mo̱ ko̱yo̱wɔre̱gyi ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ne̱ ɔɔ taa nta ko̱to̱re̱nkyu bo̱rɔ, ne̱ ɔɔ sa Wuribware̱ aŋsɛ we̱e̱ se̱, ne̱ ɔɔ taa sa bamo̱, ne̱ bamo̱ pɛɛɛ a nuu ke̱mo̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ne̱ Yeesuu yɛ, “Mo̱ mbo̱gya ne̱ n twiiri a ŋ we̱e̱, na Wuribware̱ nya taa ase̱sɛ bwe̱e̱tɔ e̱bɔye̱ bo̱ ke bamo̱‑ɔ ne̱e̱. Mo̱ mbo̱gya ne̱ n tii Wuribware̱ na ase̱sɛ mbo̱ŋtɔ‑rɔ a e̱taŋ po̱pwɛɛ a kanɔ‑ɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ, le̱e̱ mbe̱yɔmɔ bo̱ yɔ, ma lɛɛ nuu nta mɔ pɛɛɛ, amɔ ŋke nsi ne̱ mo̱ i nuu nta po̱pwɛɛ saŋ ne̱ Wuribware̱ e̱ ba a ɔ bo̱ gyi mò̱ kuwure‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ne̱ baa waa kiliŋ bo̱ kyo̱rɔ Wuribware̱ mfe̱ŋ, ne̱ baa le̱e̱ kawu yɔ Mfɔ-Ayii ke̱be̱e̱‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ne̱ Yeesuu a be̱e̱ kya se̱ tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Mo̱ne̱ pɛɛɛ mɔ e̱ se̱re̱ a mo̱nꞌ yɔwe̱ mo̱, fe̱yɛ ane̱ŋ ne̱ abware̱se̱ŋ wo̱re̱‑ɔ a tɔwe̱ ɛ, ‘Wuribware̱ e̱ mɔɔ e̱sanne̱ ɔde̱e̱re̱se̱po̱‑ɔ, na e̱sanne̱‑ɔ pɛɛɛ mɔ brawe̱‑rɔ’‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Amaa mo̱ ya bo̱ kyiŋŋi le̱e̱ lowi‑ro‑o, mo̱ e̱ gye̱ mo̱ne̱ ŋkpɛɛ a ŋ yɔ Galile̱ya swe̱e̱re̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Mfe̱ŋ ne̱ Peetroo a be̱ŋŋaa Yeesuu fe̱yɛ, “Hare̱e̱ mo̱ bɛɛko̱‑ana ya se̱re̱, m fe̱raa ma se̱re̱ a ŋ yɔwe̱ fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ne̱ Yeesuu a be̱ŋŋaa Peetroo fe̱yɛ, “Mo̱ e̱ tɔwe̱ mo̱ i gywii fo̱ fe̱yɛ ndɔɔ a kanye mɔ fo̱ e̱ swe̱e̱ iluwi e̱sa fe̱yɛ fo̱ mo̱ŋ nyi mo̱ pwɛɛ na kyaŋare̱ dɛɛ fo̱re̱ iluwi e̱nyɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ne̱ Peetroo a be̱e̱ be̱ŋŋaa fe̱yɛ, “Hare̱e̱ amo̱ e̱ gye̱ mo̱ aa fo̱ kuwu gbaa, ma tɔwe̱ fe̱yɛ mo̱ŋ nyi fo̱.” Ne̱ agyase̱po̱ ne̱ baa saŋ‑ɔ pɛɛɛ mɔ a tɔwe̱ ane̱ŋ dɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Amo̱‑ɔ kamɛɛ‑rɔ, ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ a ba bane̱ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Gɛte̱sɛmane̱e̱‑ɔ, ne̱ ɔɔ tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Mo̱nꞌ kye̱na mfe̱e̱ na ŋ ya ko̱re̱ ke̱bware̱ko̱re̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ne̱ ɔɔ te̱e̱ Peetroo na Yakubu na Yohanee bo̱ tii mò̱ e̱ye̱e̱ se̱, ne̱ baa yɔ. Mfe̱ŋ ne̱ mò̱ abaa‑rɔ a yɔre̱ mò̱, ne̱ mò̱ kayo̱wɔre̱‑rɔ a waa mò̱ yɔre̱yɔre̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ bo̱re̱‑rɔ i duŋwi mo̱ bwe̱e̱tɔ, hare̱e̱ mo̱ e̱ kpa a ŋ wu. To, mo̱nꞌ kyiŋŋi kye̱na mfe̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ne̱ ɔɔ nare̱ yɔ akatɔ‑rɔ kafwe̱e̱, ne̱ ɔɔ ya kyo̱ŋ di kame si swe̱e̱re̱, ne̱ ɔɔ ko̱re̱ Wuribware̱ fe̱yɛ ɔ ma kaŋ sa a o gyi awo̱re̱fɔɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ne̱ ɔɔ kya se̱ ko̱re̱ ke̱bware̱ko̱re̱ fe̱yɛ, “N se̱, n se̱, ŋ nyi fe̱yɛ fo̱ e̱ taare̱ a fo̱ waa ke̱tɔ ke̱maa. Mbe̱yɔmɔ mo̱ e̱ ko̱re̱ fo̱ ne̱e̱ fe̱yɛ fo̱ sa a mo̱ awo̱re̱fɔɔ ne̱ mo̱ i gyi mɔ‑ɔ gye̱ kɛɛ na m ma wu. Amaa kanɔ ŋke̱maa ne̱ fo̱ e̱ kpa‑ɔ bware sa mo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ne̱ oo kiŋŋi ya to̱ fe̱yɛ mò̱ agyase̱po̱ asa‑ɔ pɛɛɛ a di idi. Ne̱ ɔɔ te̱e̱ Peetroo ɛ, “Simɔŋ, fo̱ a di idi ne̱e̱ e̱e̱e̱? Amɔ fo̱ mo̱ŋ taare̱ kye̱na dɔŋhwe̱re̱e̱ ko̱ŋko̱ na fo̱ mo̱ŋ di idi aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “To, mo̱nꞌ kyiŋŋi kye̱na, na mo̱nꞌ ko̱re̱ ke̱bware̱ko̱re̱ fe̱yɛ Ɔbɔnsam ma kaŋ kyɔ mo̱ne̱‑rɔ ke̱e̱ fe̱yɛ mo̱ne̱ i kiŋŋi kamɛɛ aaa. Mo̱ne̱ ŋkpo̱nɔ‑rɔ mo̱ne̱ e̱ kpa kikyiŋŋi kye̱na, amaa mo̱ne̱ ŋyo̱wɔre̱‑rɔ mɔ a waa yɔre̱yɔre̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ne̱ ɔɔ be̱e̱ kiŋŋi ya ko̱re̱ ke̱bware̱ko̱re̱ fe̱yɛ ane̱ŋ ne̱ ɔɔ ko̱re̱ ke̱gye̱ŋkpɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Mò̱ a ko̱re̱ ke̱bware̱ko̱re̱ lo̱we̱‑ɔ, ne̱ ɔɔ be̱e̱ kiŋŋi bo̱ to̱ fe̱yɛ mò̱ agyase̱po̱‑ɔ a be̱e̱ di idi. Bo̱ mo̱ŋ taare̱ kra idi. Ŋkee bo̱ mo̱ŋ nyi ane̱ŋ ne̱ ba tɔwe̱ a bo̱ gywii Yeesuu‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ne̱ ɔɔ ya ko̱re̱ ke̱bware̱ko̱re̱ sase̱po̱. Saŋ ne̱ oo kiŋŋi ba‑ɔ, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ne̱ saŋ mo̱ne̱ i di idi mo̱ne̱ i kyure ne̱e̱ e̱e̱e̱? To, aa baare ane̱ŋ. Saŋ a fo̱ mbe̱yɔmɔ. Mo̱nꞌ de̱e̱re̱, ba lee mo̱, dimaadi mò̱ gyi‑o, ba sa e̱bɔye̱ awaapo̱ na bo̱ nya mo̱ se̱ ke̱yaale̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mo̱nꞌ ke̱e̱, ɔko̱ ne̱ o gyi mo̱ kidiburo‑o e̱ ba‑ɔ. To, mo̱nꞌ ko̱so̱ na ane̱ yɔ ya gyaŋŋaa mò̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yeesuu saŋ ɔ sa se̱ŋsa, ne̱ Yudas ne̱ ɔ gye̱ Yeesuu agyase̱po̱ kudu anyɔ‑ɔ ɔko̱‑ɔ a fo̱. Mò̱ aa ase̱sɛ kukwii ko̱ na bamo̱ apaŋ na akyokuŋ ya ba. Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na Wuribware̱ mbraa akaapo̱po̱‑ɔ na maŋ abre̱sɛ‑ɔ ya suŋ bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Amɔ odiburopo̱‑ɔ a kyɔ kaapo̱ bamo̱ ne̱ ba gya mò̱ se̱ ba‑ɔ fe̱yɛ, “Ɔko̱ ne̱ mo̱ e̱ yɔ a ŋ ya ka mò̱ kanɔ‑ɔ e̱ gye̱ mò̱ ne̱ mo̱ne̱ e̱ kpa‑ɔ. Na mo̱nꞌ kra mò̱, na mo̱nꞌ taa mò̱ nare̱!” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Amo̱se̱‑ɔ, Yudas a de̱ŋ fo̱‑ɔ, ne̱ ɔɔ yɔ Yeesuu ase̱. Ne̱ ɔɔ te̱e̱ Yeesuu fe̱yɛ, “Ɔkaapo̱po̱,” ne̱ ɔɔ kyo̱kywe̱e̱ mò̱ ke̱daabɔŋ dame̱naŋsɛ ka mò̱ kanɔ, fe̱yɛ ane̱ŋ ne̱ Yudaa awuye e̱ ka abɛɛ kanɔ saŋ ke̱maa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ne̱ baa kra Yeesuu, ne̱ baa kra mò̱‑rɔ keŋkeŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mfe̱ŋ ne̱ Yeesuu agyase̱po̱‑ɔ ɔko̱ a gyiiri ke̱paŋ lee, ne̱ oo ŋe Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ a anya‑ɔ ɔko̱ ke̱se̱bɔ te̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ne̱ Yeesuu a bise ase̱sɛ‑ɔ fe̱yɛ, “Amɔ mo̱ne̱ a ba apaŋ na akyokuŋ a mo̱nꞌ bo̱ kra mo̱ ne̱e̱ fe̱yɛ oyu‑o ooo? ");
INSERT INTO ncuNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ŋke mfe̱ne̱ mɔ‑rɔ mo̱ aa mo̱ne̱ ne̱e̱ na mo̱ e̱ kaapo̱ abware̱se̱ŋ Wuribware̱ suŋkpa kabuno, na mo̱ne̱ mɔ mo̱ne̱ mo̱ŋ kra mo̱? Amaa amo̱‑ɔ a ba ane̱ŋ ne̱e̱ na mo̱ awo̱re̱fɔɔ na lowi ne̱ mo̱ i wu‑o, ne̱ baa kyo̱rɛɛ amo̱ ase̱ŋ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ, nya waa kase̱ŋtiŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Mfe̱ŋ ne̱ Yeesuu a agyase̱po̱‑ɔ pɛɛɛ a se̱re̱ yɔwe̱ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Amaa ke̱yaafɔre̱ ko̱ mɔ a kpuriti waagya laare̱‑rɔ ɔ gya bamo̱ se̱. Ne̱ ba kpa a bo̱ kra mò̱ gbaa mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ne̱ ɔɔ ŋwɛɛnaŋ, ne̱ mò̱ waagya‑ɔ a saŋŋe̱ le̱e̱ da, ne̱ ɔɔ se̱re̱ ke̱te̱bɔŋburoŋ yɔwe̱ mò̱ waagya‑ɔ bo̱ sii. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","To, ne̱ baa taa Yeesuu yaa Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ lɔŋ‑nɔ, mfe̱ŋ ne̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na maŋ abre̱sɛ‑ɔ na Wuribware̱ mbraa akaapo̱po̱‑ɔ e̱ gyaŋŋe̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ne̱ Peetroo a sii kamɛɛ ɔ gya bamo̱ se̱. Ɔɔ gya bamo̱ se̱ ane̱ŋ‑aaa ya bo̱ fo̱ ɔlɔŋŋɔpo̱ bre̱sɛ a lɔŋ amo̱‑rɔ. Ne̱ mò̱ aa ade̱e̱re̱se̱po̱ ko̱ te lɔŋ‑ɔ kabuno ase̱ ba wo̱re̱ de̱e̱kpa. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ne̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na agyaŋŋe̱po̱‑ɔ pɛɛɛ a buwi kpa kanɔte̱ŋ ne̱ ba ba a bo̱ bo̱ ye̱re̱ se̱ a Yeesuu gyi ke̱pɔ a bo̱ nya mɔɔ mò̱‑ɔ kpo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ne̱ ase̱sɛ bwe̱e̱tɔ a bo̱ ba bamo̱ aye̱ba bo̱ kye mò̱ a ɔ nya gyi ke̱pɔ. Amaa bamo̱ aye̱ba‑ɔ mo̱ŋ ye̱re̱ abɛɛ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ne̱ ŋkee bo̱ko̱ a ko̱so̱ ba aye̱ba bo̱ po̱rɔ Yeesuu fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ane̱ a nu fe̱yɛ mò̱ a tɔwe̱ ɛ, ‘Mo̱ i bwee Wuribware̱ suŋkpa ne̱ ase̱sɛ a ba asare̱e̱ bo̱ pwɛɛ‑ɔ, na ŋke nsa kamɛɛ‑rɔ na m pwɛɛ ke̱mo̱ ne̱ se̱sɛ mo̱ŋ ba asare̱e̱ bo̱ pwɛɛ‑ɔ.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Amaa bamo̱ gbaa bamo̱ aye̱ba‑ɔ mo̱ŋ taare̱ ye̱re̱ abɛɛ se̱ ane̱ŋ ne̱ Yeesuu i gyi ke̱pɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ne̱ Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ‑ɔ a ko̱so̱ ye̱re̱ bamo̱ pɛɛɛ akatɔ‑rɔ, ne̱ oo bise Yeesuu fe̱yɛ, “Amɔ fo̱ mo̱ŋ de ase̱ŋ mɔ pɛɛɛ ne̱ ba tɔwe̱ ba kye fo̱‑ɔ kanɔlee aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ne̱ Yeesuu a laatɔ, kanɔ ɔ mo̱ŋ buŋŋi. Ne̱ ɔɔ be̱e̱ bise mò̱ fe̱yɛ, “Fo̱ e̱ gye̱ mò̱ ne̱ ɔ bo̱ so̱so̱‑ɔ mò̱ gyi Kristoo ne̱ oo suŋ bo̱ kyo̱ŋwe̱‑ɔ, bɛɛɛ fo̱ mo̱ŋ gye̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ŋkee fe̱raa ne̱ Yeesuu a be̱ŋŋaa fe̱yɛ, “Ɔɔŋ, mo̱ ne̱e̱, na mo̱ne̱ saŋ mo̱ne̱ i ŋu mo̱, dimaadi mò̱ gyi‑o, a te Bo̱-e̱le̱ŋ‑ɔ‑kyo̱ŋ‑ɔke̱maa-Bware̱ kigyise si, na mo̱ aa mò̱ gyi mò̱ kuwure dabe̱‑ɔ, na mo̱ a le̱e̱ awo̱re̱‑rɔ mo̱ e̱ ba.” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Amo̱ fe̱raa ne̱ ɔlɔŋŋɔpo̱ bre̱sɛ‑ɔ a ba kaduŋfwii bo̱ kyaŋ mò̱ fɔŋfɔŋ waagya‑rɔ, ne̱ ɔ yɛ, “Ane̱ maa lɛɛ kpa a ɔko̱ tɔwe̱ ko̱tɔko̱ pwɛɛ na ane̱ dɛɛ ŋu fe̱yɛ oo gyi ke̱pɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mo̱ne̱ a nu ase̱ŋ ne̱ ɔɔ tɔwe̱ bo̱ kye Wuribware̱‑ɔ, ɔ yɛ mò̱ aa Wuribware̱ ta. Amo̱se̱‑ɔ, e̱me̱ne̱ ne̱ mo̱ne̱ e̱ fa fe̱yɛ ane̱ waa mò̱?” Ne̱ bamo̱ pɛɛɛ a sure si fe̱yɛ oo gyi ke̱pɔ, amo̱se̱‑ɔ bo̱ mɔɔ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mfe̱ŋ dɛɛ ne̱ bo̱ko̱ a le̱e̱ ba twe̱e̱ akyɔne̱ ba we̱e̱ Yeesuu si. Ne̱ baa ba kaprakɛɛ bo̱ buŋ mò̱ akatɔ se̱, na ba da mò̱ akuŋtiŋ. Ŋkee bamo̱ ya da mò̱, na bo̱ tɔwe̱ fe̱yɛ, “Nsɛ ya da fo̱‑ɔ ne̱e̱?” Ne̱ ade̱e̱re̱se̱po̱‑ɔ a taa mò̱ yaa daye̱ mò̱ e̱se̱bɔ‑rɔ abaa. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Bamo̱ a gyi Yeesuu ase̱ŋ ke̱kyaŋ‑nɔ‑ɔ, na Peetroo saŋ o te kabuno mfe̱ŋ. Ne̱ Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ‑ɔ mò̱ kabre ko̱ a ba ɔ kyo̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Saŋ ne̱ oo ŋu Peetroo na ɔ wo̱re̱ de̱e̱kpa‑ɔ, ne̱ ɔɔ de̱e̱re̱ Peetroo akatɔ‑rɔ, ne̱ ɔ yɛ, “Fo̱ gbaa fo̱ aa Yeesuu Nasarɛte̱nyi mɔ e̱ gye̱ ne̱ mo̱ne̱ naa.” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ne̱ Peetroo a swe̱e̱ fe̱yɛ, “Mo̱ŋ nyi ase̱ŋ ne̱ fo̱ e̱ tɔwe̱ amo̱‑ɔ kaase̱.” Ne̱ ɔɔ nare̱ ya ye̱re̱ lɔŋ‑ɔ kibunogyi‑ro. Puri amo̱‑rɔ ne̱ kyaŋare̱ a fo̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kibunogyi amo̱‑rɔ mfe̱ŋ ne̱ kabre amo̱ a be̱e̱ ŋu Peetroo, ne̱ ɔɔ be̱e̱ le̱e̱ ɔ tɔwe̱ ane̱ŋ ne̱ ɔɔ dɛɛ tɔwe̱‑ɔ o gywii ase̱sɛ ne̱ bo̱ ye̱re̱ mfe̱ŋ‑ɔ. Kabre‑o a tɔwe̱ gywii bamo̱ ne̱e̱ fe̱yɛ, “Mò̱ gbaa gye̱ Yeesuu a ase̱sɛ‑ɔ ɔko̱ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Amaa Peetroo a be̱e̱ swe̱e̱. Ke̱tɔ a be̱e̱ waa kafwe̱e̱‑ɔ, ne̱ bamo̱ ne̱ bo̱ ye̱re̱ mfe̱ŋ‑ɔ a be̱e̱ tɔwe̱ gywii Peetroo fe̱yɛ, “Fo̱ maa taare̱ a fo̱ gyiiri ikii fe̱yɛ fo̱ mo̱ŋ gye̱ Yeesuu a ase̱sɛ‑ɔ ɔko̱, a le̱e̱ fe̱yɛ ane̱ a ŋu fe̱yɛ fo̱ gbaa fo̱ gye̱ Galile̱yanyi ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ne̱ Peetroo a be̱ŋŋaa fe̱yɛ, “Mo̱ e̱ ka ke̱yaa fe̱yɛ mo̱ŋ nyi ɔnyare̱ mɔ ne̱ mo̱ne̱ e̱ tɔwe̱ mò̱ ase̱ŋ‑ɔ. Ne̱ ase̱ŋ mɔ ne̱ mo̱ e̱ tɔwe̱‑ɔ e̱ mo̱ŋ gye̱ kase̱ŋtiŋ, amo̱ fe̱raa Wuribware̱ lo̱ŋ mo̱.” Ne̱ ɔɔ be̱e̱ ka ane̱ŋ a ke̱yaa‑ɔ iluwi bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Mò̱ ke̱de̱ŋ tɔwe̱ ane̱ŋ lo̱we̱‑ɔ, ne̱ kyaŋare̱ a fo̱re̱ nyɔse̱po̱. Ne̱ oo nyiŋŋi ane̱ŋ ne̱ Yeesuu a tɔwe̱ gywii mò̱‑ɔ se̱ fe̱yɛ, “Fo̱ e̱ swe̱e̱ iluwi e̱sa fe̱yɛ fo̱ mo̱ŋ nyi mo̱ pwɛɛ na kyaŋare̱ dɛɛ fo̱re̱ iluwi e̱nyɔ.” Ne̱ ɔɔ ya su bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kaye̱ ŋke gye̱gyaye̱ tututu‑o, ne̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na maŋ abre̱sɛ‑ɔ na Wuribware̱ mbraa akaapo̱po̱‑ɔ pɛɛɛ a gyaŋŋe̱ kra ane̱ŋ ne̱ ba waa Yeesuu‑o. Ne̱ baa ba agbarabi bo̱ da mò̱ asare̱e̱‑rɔ, ne̱ baa yaa mò̱ Romanyi gominaa ne̱ ba te̱e̱ mò̱ ɛ Pilat‑o akatɔ‑rɔ, na ɔ sa bamo̱ kpa fe̱yɛ bo̱ mɔɔ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ne̱ gominaa‑o a bise Yeesuu fe̱yɛ, “Baa po̱rɔ fo̱ fe̱yɛ fo̱ a tɔwe̱ fe̱yɛ fo̱ e̱ gye̱ Yudaa awuye owure‑o. E̱me̱ne̱ ne̱ fo̱ i lee kanɔ?” Ne̱ ɔɔ be̱ŋŋaa mò̱ fe̱yɛ, “Se̱ŋbise mɔ a le̱e̱ fo̱ ase̱ ne̱e̱ e̱e̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","4","Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ a po̱rɔ Yeesuu bwe̱e̱tɔ‑ɔ se̱‑ɔ, ne̱ gominaa‑o a bise Yeesuu fe̱yɛ, “Fo̱ maa be̱ŋŋaa ne̱e̱ e̱e̱e̱? Nu ane̱ŋ ne̱ ba po̱rɔ fo̱‑ɔ wo̱re̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Amaa kanɔ Yeesuu be̱e̱ ɔ mo̱ŋ buŋŋi. Ne̱ gominaa‑o e̱ye̱e̱ a kpe̱ŋ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Amɔ saŋ ke̱maa mɔ, Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese kigyi‑o‑ro, Romanyi gominaa i lee bamo̱ ne̱ oo tii bamo̱ tiikpa‑ɔ ɔko̱ ne̱ lamaŋ e̱ kpa‑ɔ na ɔ nare̱ ya kyure. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Saŋ amo̱ oo tii ɔnyare̱ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Bar‑Abas‑ɔ na ase̱sɛ ko̱ tiikpa, a le̱e̱ fe̱yɛ baa ko̱so̱ kɔ bo̱ kye Roma abane̱ maŋ mɔ‑rɔ, ne̱ baa mɔɔ ase̱sɛ bwe̱e̱tɔ e̱kɔ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ne̱ lamaŋ a gyaŋŋe̱ gominaa‑o akatɔ‑rɔ, ne̱ baa le̱e̱ ba bise mò̱ fe̱yɛ o lee ase̱sɛ ne̱ oo tii‑o ɔko̱, fe̱yɛ ane̱ŋ ne̱ ɔɔ kyɔ waa nsu ne̱ ŋ ya kyo̱ŋ‑ɔ‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Amo̱se̱‑ɔ, ne̱ gominaa‑o a bise bamo̱ fe̱yɛ, “Mo̱ne̱ e̱ kpa fe̱yɛ n lee ɔnyare̱ ne̱ mo̱ne̱ e̱ te̱e̱ mò̱ ɛ mo̱ne̱ Yudaa awuye owure‑o ne̱e̱ bɛɛɛ?” ");
INSERT INTO ncuNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Gominaa‑o de̱ŋ o nyi fe̱yɛ ko̱kwe̱e̱ se̱ ne̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ a kra Yeesuu ba bo̱ sa mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Amo̱ fe̱raa ne̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ a da lamaŋ‑ɔ kanɔ se̱ fe̱yɛ bo̱ tɔwe̱ ɛ o lee Bar‑Abas. Ne̱ bo̱ yɛ, “Lee Bar‑Abas.” ");
INSERT INTO ncuNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ne̱ gominaa‑o a be̱e̱ bise fe̱yɛ, “To, ne̱ nte̱tɔ ne̱ mo̱ne̱ e̱ kpa fe̱yɛ ŋ waa mò̱ ne̱ mo̱ne̱ e̱ te̱e̱ ɛ Yudaa awuye owure‑o ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Amo̱ fe̱raa ne̱ baa fɛɛ‑rɔ fe̱yɛ, “Da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱!” ");
INSERT INTO ncuNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ne̱ gominaa‑o yɛ, “Nte̱tɔ bɔye̱ gbaa ne̱ ɔɔ waa?” Ne̱ baa be̱e̱ fɛɛ‑rɔ fe̱yɛ, “Da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱!” ");
INSERT INTO ncuNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Gominaa‑o a kpa a ɔ waa bamo̱ ke̱pre̱‑ɔ se̱‑ɔ, ne̱ oo lee Bar‑Abas bo̱ sa bamo̱. Ne̱ ɔɔ sa ne̱ mò̱ asoogyaa awuye‑o ɔko̱ a da Yeesuu paara, ne̱ ɔɔ taa mò̱ sa bamo̱ fe̱yɛ asoogyaa awuye ya da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ne̱ asoogyaa awuye‑o a taa Yeesuu yaa Gominaa Pilat a lɔŋ‑ɔ‑rɔ, ne̱ baa te̱e̱ bamo̱ bɛɛko̱‑ana bo̱ gyaŋŋe̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ne̱ baa ba waagya pipee bo̱ buŋ mò̱ fe̱yɛ mò̱ a gye̱ owure‑o, ne̱ baa ba iwu bo̱ lo̱ kuwurepa bo̱ buŋ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ne̱ baa le̱e̱ ba waa mò̱ ŋwaagyise̱ŋŋe̱ fe̱yɛ, “Aŋsuma, nana, Yudaa awuye owure.” ");
INSERT INTO ncuNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ne̱ baa ba kayii bo̱ daye̱ Yeesuu kuŋu‑ro ane̱ŋ‑aaa, ne̱ baa twe̱e̱ akyɔne̱ we̱e̱ mò̱ se̱, ne̱ baa tɛɛ gyɔŋŋɔ mò̱ ayaa‑rɔ fe̱yɛ bamo̱ a bu mò̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Saŋ ne̱ baa waa mò̱ ŋwaagyise̱ŋŋe̱ lo̱we̱‑ɔ, ne̱ baa lee waagya pipee‑o, ne̱ baa ba mò̱ fɔŋfɔŋ atɔ bo̱ buŋ mò̱. Ne̱ baa taa mò̱ ba yɔ a bo̱ ya da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Saŋ ne̱ asoogyaa awuye‑o de Yeesuu ba yɔ‑ɔ, ne̱ baa gyaŋŋaa ɔnyare̱ ko̱ na ɔ kyo̱ŋ o lwee maŋ‑ɔ‑rɔ. Ɔɔ le̱e̱ Kireenee maŋ‑nɔ, ne̱ ba te̱e̱ mò̱ ɛ Simɔŋ, ne̱ ɔ gye̱ Alɛsanda na Rufus bamo̱ se̱‑ɔ. Simɔŋ mɔ ne̱ asoogyaa awuye‑o a ye̱re̱ mò̱ fe̱yɛ ɔ so̱rɔ Yeesuu a kiyii kpare̱-abɛɛ‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ne̱ baa yaa Yeesuu mfe̱ŋ ne̱ ba te̱e̱ ɛ Gologotaa‑o (kaase̱ e̱ kaapo̱ fe̱yɛ Ko̱lɔŋko̱rɔŋgyi-Swe̱e̱re̱.) ");
INSERT INTO ncuNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ne̱ baa bo̱ sa Yeesuu nta ne̱ baa ba kadwii bo̱ waa‑rɔ‑ɔ, na mò̱ kayo̱wɔre̱‑rɔ ma lɛɛ duŋwi mò̱. Amaa Yeesuu a kine kunuu. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ne̱ baa da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ‑ɔ se̱. Mfe̱ŋ ne̱ baa waa mpini mpini bo̱ ke mò̱ atɔ buŋsɛ‑rɔ taa. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Saŋ ne̱ baa da Yeesuu bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ‑ɔ se̱‑ɔ, saŋ‑ɔ na kyɔwe̱ a yase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ne̱ baa taa kawo̱re̱taa ko̱ bo̱ me̱ra Yeesuu aŋu si. Ne̱ gominaa‑o a kyo̱rɛɛ kamo̱ se̱ fe̱yɛ, “Yudaa awuye owure‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ne̱ baa be̱e̱ da ayu anyɔ ko̱ bo̱ me̱ra ayii kpare̱-abɛɛ‑rɔ se̱. Baa da ɔko̱ŋko̱ bo̱ me̱ra ko̱ko̱ se̱ Yeesuu kigyise si, ɔko̱ŋko̱ mɔ bo̱ me̱ra ko̱ko̱ se̱ mò̱ ke̱be̱na se̱.  ");
INSERT INTO ncuNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Mfaanɛɛ‑ɔ, ke̱tɔ ne̱ baa kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ a waa kase̱ŋtiŋ fe̱yɛ, “Baa waa mò̱ ke̱tɔ ne̱ ba waa abɔye̱waapo̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ase̱sɛ ne̱ ba kyo̱ŋ mfe̱ŋ‑ɔ e̱ da abaa‑rɔ ne̱e̱, na ba saare̱ Yeesuu fe̱yɛ, “Mboo. Ne̱e̱ fo̱ yɛ fo̱ i bwee Wuribware̱ suŋkpa‑ɔ, na ŋke nsa kamɛɛ fo̱ be̱e̱ pwɛɛ ke̱mo̱ bo̱ ye̱ra ɛ? ");
INSERT INTO ncuNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Mbe̱yɔmɔ kpo̱ro̱we̱ le̱e̱ kiyii kpare̱-abɛɛ‑rɔ mɔ se̱ ba swe̱e̱re̱, na fo̱ mo̱rɔwe̱ fo̱ e̱ye̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ane̱ŋ dɛɛ ne̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na Wuribware̱ mbraa akaapo̱po̱‑ɔ a mii nnɔ kyɔ mo̱, na ba mɔse̱ mò̱, na ba tɔwe̱ ba gywii abɛɛ fe̱yɛ, “Ɔɔ mo̱rɔwe̱ bo̱ko̱, amaa ɔ maa taare̱ a ɔ mo̱rɔwe̱ mò̱ e̱ye̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mo̱nꞌ sa a ane̱ ke̱e̱ fe̱yɛ mò̱ a tɔwe̱ ɛ ɔ gye̱ Kristoo ne̱ Wuribware̱ yɛ o suŋ a ɔ bo̱ kyo̱ŋwe̱ ane̱‑ɔ, na ɔ gye̱ ane̱ Isireelii awuye owure‑o ne̱e̱‑ɔ, ɔ taare̱ a ɔ le̱e̱ kiyii kpare̱-abɛɛ‑rɔ mɔ se̱ ba swe̱e̱re̱ aaa. Ne̱ mò̱ ya taare̱ fe̱raa, ane̱ e̱ kɔɔre̱ mò̱ a ane̱ gyi.” Ane̱ŋ dɛɛ ne̱ ayu anyɔ ne̱ baa da bamo̱ gbaa bamo̱ bo̱ me̱ra ayii kpare̱-abɛɛ‑rɔ se̱ Yeesuu ase̱‑ɔ a saare̱ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Saŋ ne̱ mpase̱ a fo̱‑ɔ, ne̱ kyɔwe̱ a yɔwe̱ ke̱da, ne̱ kibugyii a da swe̱e̱re̱ amo̱ se̱ pɛɛɛ. Ne̱ kaa gyi e̱dɔŋhwe̱re̱e̱ e̱sa. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Saŋ amo̱ a kpa a ɔ gye̱ kɛɛ‑ɔ, ne̱ Yeesuu a faa‑rɔ keŋkeŋ bamo̱ aye̱‑rɔ Heebrii‑ro fe̱yɛ, “Ili, Ili, lama sabakatani.” Kaase̱ e̱ kaapo̱ fe̱yɛ, “O Wuribware̱, O Wuribware̱, nte̱tɔ se̱ ne̱ fo̱ a kine mo̱?” ");
INSERT INTO ncuNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ne̱ bamo̱ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ mo̱ŋ nu mò̱ ase̱ŋ‑ɔ kaase̱, ne̱ bo̱ko̱ yɛ, “Mo̱nꞌ nu, Wuribware̱ kyaamɛɛ Iliya ne̱ ɔ te̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ne̱ bamo̱‑rɔ ɔko̱ a ŋwɛɛnaŋ ya ba ikyikyee bo̱ da nta‑rɔ, ne̱ ɔɔ taa bo̱ kye̱na kayii si. Ne̱ oo teyi bo̱ waa Yeesuu kanɔ‑rɔ na ɔ nya kyo̱kywe̱e̱, ne̱ ɔ yɛ, “To, mo̱nꞌ sa a ane̱ ye̱re̱ na ane̱ ke̱e̱ fe̱yɛ Iliya e̱ ba a ɔ bo̱ maye̱ mò̱ le̱e̱ kiyii kpare̱-abɛɛ‑rɔ‑ɔ se̱ baa swe̱e̱re̱ aaa.” ");
INSERT INTO ncuNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mfe̱ŋ ne̱ Yeesuu a faa‑rɔ keŋkeŋ, ne̱ oo kii E̱bware̱ lee. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ne̱ waagya ne̱ baa bo̱ kuŋ Wuribware̱ suŋkpa a do̱dɔ‑rɔ a ke̱kyaŋ‑ɔ a kyaŋ‑nɔ ntuŋ ŋnyɔ le̱e̱ so̱so̱ ya bo̱ da kaase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Soogyaa ɔbre̱sɛ ne̱ ɔ ye̱re̱ kiyii kpare̱-abɛɛ‑rɔ‑ɔ akatɔ‑rɔ ɔ de̱e̱re̱ Yeesuu si‑o a ŋu ane̱ŋ ne̱ Yeesuu a wu‑o, ne̱ ɔ yɛ, “Ɔnyare̱ mɔ gye̱ Wuribware̱ mò̱ gyi ne̱e̱ kase̱ŋtiŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Amɔ saŋ amo̱ akye̱e̱ ko̱ mɔ ye̱re̱ ke̱fɔ ba de̱e̱re̱ ba kyo̱ŋwe̱. Akye̱e̱ amo̱ bo̱ko̱ e̱ gye̱ Mariya Magadalanyi, na Mariya ne̱ ɔ gye̱ Yakubu Kagyingyii na Yo̱sɛf bamo̱ nyi‑o, na Salomee. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Akye̱e̱ amo̱ a gya Yeesuu si hare̱e̱ le̱e̱ saŋ ne̱ ɔ bo̱ Galile̱ya swe̱e̱re̱ se̱‑ɔ ne̱e̱, bamo̱ ne̱ bo̱ dɛɛ ba de̱e̱re̱ mò̱ se̱‑ɔ. Akye̱e̱ bwe̱e̱tɔ ne̱ baa gya mò̱ se̱ lwee Yɛro̱salɛm maŋ‑nɔ‑ɔ gbaa tii bamo̱ se̱ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Amɔ maŋ abre̱sɛ‑ɔ ɔko̱ bo̱‑rɔ ne̱ ba te̱e̱ mò̱ ɛ Yo̱sɛf. Ne̱ ɔɔ le̱e̱ maŋ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Arimate̱ya‑ɔ. Ɔ gye̱ se̱sɛ timaa. Ne̱ o gywii saŋ ne̱ Wuribware̱ i gyi mò̱ kuwure swe̱e̱re̱ mɔ se̱‑ɔ. Ne̱ ase̱sɛ bwe̱e̱tɔ i bu mò̱. Ke̱de̱e̱pwɛta a fo̱‑ɔ, ne̱ ɔɔ waa kakpo̱nɔ, ne̱ ɔɔ yɔ Gominaa Pilat ase̱ ya ko̱re̱ mò̱ fe̱yɛ ɔ taa Yeesuu kifuniŋ sa mò̱ a ɔ yaa pure. Ɔɔ yɔ me̱naŋ, a le̱e̱ fe̱yɛ kake amo̱ gye̱ Ifiyara ne̱e̱. Amo̱se̱‑ɔ, kyɔwe̱ ya lo̱we̱, amɔ kukyure kake a fo̱, na ɔke̱maa ma nya waa kusuŋ ke̱maa. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ne̱ gominaa‑o e̱ye̱e̱ a kpe̱ŋ mò̱ fe̱yɛ Yeesuu a kyɔ wu. Ne̱ oo lee mò̱ soogyaa bre̱sɛ‑ɔ bise mò̱ fe̱yɛ Yeesuu a wu kyee aaa. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mò̱ a nu Yeesuu a lowi‑o bo̱ le̱e̱ soogyaa bre̱sɛ amo̱ ase̱‑ɔ, ne̱ ɔɔ sa Yo̱sɛf kpa fe̱yɛ ɔ ya taa kifuniŋ‑o yaa pure. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ne̱ Yo̱sɛf a ya sɔɔ kyefuri po̱pwɛɛ. Ne̱ ɔɔ maye̱ Yeesuu kifuniŋ‑o le̱e̱ kiyii kpare̱-abɛɛ‑rɔ‑ɔ se̱, taa kyefuri‑o bo̱ miri kifuniŋ‑o. Ne̱ ɔɔ taa kifuniŋ‑o waa ke̱gye̱raŋta ko̱ bɔ‑rɔ. (A le̱e̱ fe̱yɛ Yudaa awuye fe̱raa ke̱fo̱re̱ ne̱ ba ŋeri ba lee bɔ fe̱yɛ ke̱kyaŋ‑ɔ. Amɔ amo̱‑rɔ e̱ gye̱ bamo̱ agye̱raŋta.) Ne̱ oo kuroŋ ke̱fo̱re̱ ko̱ bo̱ kpuse ke̱gye̱raŋta‑ɔ kanɔ fe̱yɛ po̱ne̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Saŋ ne̱ Yo̱sɛf e̱ waa amo̱‑ɔ pɛɛɛ‑ɔ, na Mariya Magadalanyi na Yo̱sɛf mò̱ nyi Mariya mɔ ye̱re̱ to̱ŋ ko̱ ba de̱e̱re̱. Ne̱ baa ŋu mfe̱ŋ ne̱ oo pure Yeesuu‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Me̱me̱ne̱da, kake ne̱ Yudaa awuye‑o i kyure, ne̱ bo̱ maa waa kusuŋ ke̱maa‑ɔ a kyo̱ŋ‑ɔ, ne̱ Mariya Magadalanyi na Salomee na Yakubu mò̱ nyi Mariya a ya sɔɔ kadwii na kakyanne̱ na bo̱ yaa bo̱ kyiine Yeesuu kifuniŋ‑o. ");
INSERT INTO ncuNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Amo̱se̱‑ɔ, kaye̱ ŋke Kosiyara gye̱gyaye̱ kyɔwe̱ ke̱le̱e̱be̱e̱‑ɔ, ne̱ baa yɔ ke̱gye̱raŋta‑ɔ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Saŋ ne̱ ba yɔ‑ɔ, ne̱ baa bise abɛɛ fe̱yɛ, “Nsɛ e̱ gye̱ ne̱ o kuroŋ ke̱fo̱re̱‑ɔ a ɔ le̱e̱ ke̱gye̱raŋta‑ɔ kanɔ se̱ a ɔ sa ane̱?” A le̱e̱ fe̱yɛ ke̱fo̱re̱‑ɔ bo̱ dwii. Amaa bamo̱ a de̱ŋ yase̱ akatɔ de̱e̱re̱ bo̱ kyo̱ŋwe̱‑ɔ, ne̱ baa ŋu fe̱yɛ ke̱fo̱re̱‑ɔ a kyɔ kuroŋ le̱e̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ne̱ baa lwee ke̱gye̱raŋta‑ɔ‑rɔ, ne̱ baa ŋu ke̱yaafɔre̱ ko̱ na o te ke̱gye̱raŋta‑ɔ‑rɔ kigyise si o buŋ kaare̱ so̱swe̱e̱ fufuri pare̱pare̱. Ne̱ kufu a nya bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ne̱ ɔ yɛ, “Mo̱ne̱ ma sa a kufu nya mo̱ne̱, na ŋ nyi fe̱yɛ Yeesuu Nasarɛte̱nyi ne̱ baa da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ‑ɔ se̱‑ɔ ne̱ mo̱ne̱ e̱ kpa. Amaa ɔ mo̱ŋ bo̱ mfe̱e̱. Wuribware̱ a kyiŋŋi mò̱ le̱e̱ lowi‑ro. Mo̱nꞌ ke̱e̱ mfe̱ŋ ne̱ baa baa mò̱ bo̱ be̱ya‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","To, mbe̱yɔmɔ, mo̱nꞌ ya tɔwe̱ gywii Peetroo na Yeesuu agyase̱po̱ ne̱ baa saŋ‑ɔ fe̱yɛ, ‘Ɔ gye̱ mo̱ne̱ ŋkpɛɛ o yii Galile̱ya swe̱e̱re̱ se̱. Mfe̱ŋ‑ɔ ne̱ mo̱ne̱ i ŋu mò̱ fe̱yɛ ane̱ŋ ne̱ ɔɔ kyɔ tɔwe̱ gywii mo̱ne̱‑ɔ.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Amo̱se̱‑ɔ, ne̱ baa ba kufu na kaye̱e̱yo̱ŋ bo̱ ŋwɛɛnaŋ le̱e̱ ke̱gye̱raŋta‑ɔ‑rɔ ba yɔ. Amaa bo̱ mo̱ŋ sa se̱ŋsa gywii ɔko̱, a le̱e̱ fe̱yɛ kufu de bamo̱.  ");
INSERT INTO ncuNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Saŋ ne̱ Yeesuu a kyiŋŋi le̱e̱ lowi‑ro Kosiyara gye̱gyaye̱‑ɔ, Mariya Magadalanyi ne̱ Yeesuu a dɛɛ gya ibrisi isunoo bo̱ ko̱so̱ mò̱ se̱‑ɔ, ne̱ ɔɔ daa se̱ ilee mò̱ e̱ye̱e̱ bo̱ kaapo̱. ");
INSERT INTO ncuNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ne̱ Mariya a ya tɔwe̱ gywii Yeesuu mò̱ nyare̱‑ana, na bo̱ waa mò̱ kale. ");
INSERT INTO ncuNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Amaa mò̱ a tɔwe̱ gywii bamo̱ fe̱yɛ Yeesuu a kyiŋŋi le̱e̱ lowi‑ro hare̱e̱ oo ŋu mò̱‑ɔ, bo̱ mo̱ŋ kɔɔre̱ mò̱ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Amo̱ kamɛɛ‑rɔ‑ɔ, ne̱ Yeesuu a be̱e̱ lee mò̱ e̱ye̱e̱ kpa po̱pwɛɛ ko̱‑rɔ bo̱ kaapo̱ mò̱ nyare̱‑ana anyɔ ko̱ na bo̱ naa bamo̱ kpa se̱ ba le̱e̱ maŋ‑nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ne̱ baa kiŋŋi yɔ ya tɔwe̱ gywii Yeesuu mò̱ nyare̱‑ana ne̱ baa saŋ‑ɔ. Amaa bo̱ mo̱ŋ kɔɔre̱ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Lalalo̱we̱‑ɔ, ne̱ Yeesuu a lee mò̱ e̱ye̱e̱ bo̱ kaapo̱ mò̱ agyase̱po̱ kudu kako̱‑ɔ na bo̱ te ba gyi ateese. Ne̱ ɔɔ po̱rɔ bamo̱, a le̱e̱ fe̱yɛ baa kine ko̱kɔɔre̱ bamo̱ ne̱ baa ŋu fe̱yɛ oo kyiŋŋi le̱e̱ lowi‑ro‑o, ne̱ baa bo̱ tɔwe̱ gywii bamo̱‑ɔ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱nꞌ nare̱ kaye̱‑rɔ pɛɛɛ ya tɔwe̱ ase̱ŋ timaa‑o gywii se̱sɛ dimaadi pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ɔke̱maa ne̱ ɔɔ kɔɔre̱ mo̱ne̱ gyi, ne̱ ɔɔ bɔ asuu‑o, Wuribware̱ e̱ mo̱rɔwe̱ mò̱. Amaa mò̱ ne̱ ɔ mo̱ŋ kɔɔre̱ mo̱ne̱ gyi‑o fe̱raa, Wuribware̱ i bu mò̱ ke̱pɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Mo̱ e̱ sa ɔke̱maa ne̱ ɔ kɔɔre̱ ase̱ŋ timaa‑o a o gyi‑o e̱le̱ŋ na ɔ ba mo̱ ke̱nyare̱ bo̱ gya ibrisi bo̱ ko̱so̱ ase̱sɛ se̱, na ɔ sa e̱se̱ŋsa ne̱ ɔko̱ maa nu e̱mo̱‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Na ɔ kra awɔ‑rɔ bɛɛɛ o nuu kadwii mɔɔsɛ na ke̱tɔ ma waa mò̱ sɛye̱, na ɔ ba ke̱sare̱e̱ bo̱ dɔŋŋɔ alɔpo̱ se̱ na bo̱ kpaare̱.” ");
INSERT INTO ncuNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Saŋ ne̱ Yeesuu a sa se̱ŋsa mò̱ agyase̱po̱‑ɔ ase̱ lo̱we̱‑ɔ, ne̱ Wuribware̱ a yaa Yeesuu so̱so̱ yaa ba mò̱ bo̱ kye̱na mò̱ Wuribware̱ kigyise si, na mò̱ aa mò̱ gyi kuwure. ");
INSERT INTO ncuNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ne̱ mò̱ agyase̱po̱‑ɔ mɔ a yɔ to̱ŋ ke̱maa ya tɔwe̱ abware̱se̱ŋ. Ne̱ Wuribware̱ a gya bamo̱ kamɛɛ, ne̱ ɔɔ sa bamo̱ ke̱yaale̱ŋ ne̱ baa bo̱ waa akpe̱ŋe̱ye̱e̱tɔ bo̱ kaapo̱ fe̱yɛ abware̱se̱ŋ ne̱ baa tɔwe̱‑ɔ gye̱ kase̱ŋtiŋ‑o.");
INSERT INTO ncuNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Bre̱sɛ Tiyufilus, mo̱ e̱ ka fo̱ kanɔ. Ke̱tɔ se̱ ne̱ mo̱ e̱ kyo̱rɛɛ wo̱re̱ mɔ mo̱ e̱ sa fo̱‑ɔ e̱ gye̱ fe̱yɛ mo̱ e̱ kpa a fo̱ nya ŋu fe̱yɛ ke̱tɔ ne̱ baa kaapo̱ fo̱ bo̱ le̱e̱ atɔ biribiri ne̱ aa waa ane̱ ase̱‑ɔ gye̱ kase̱ŋtiŋ. Ase̱sɛ bwe̱e̱tɔ a kyo̱rɛɛ amo̱ pɛɛɛ ase̱ŋ bo̱ be̱ya fe̱yɛ ane̱ŋ ne̱ baa nu amo̱ pɛɛɛ le̱e̱ bamo̱ ne̱ baa gye̱ ŋkpɛɛ nu ne̱ baa ŋu amo̱‑ɔ ne̱ baa tɔwe̱ abware̱se̱ŋ‑ɔ ase̱‑ɔ. M fe̱raa mo̱ a de̱e̱re̱, ne̱ mo̱ a kare̱ ase̱ŋ‑ɔ pɛɛɛ‑rɔ dame̱naŋsɛ le̱e̱ amo̱ ke̱gye̱ŋkpɛɛ‑rɔ, ne̱ mo̱ a waa mfɛɛre̱ fe̱yɛ a bware fe̱yɛ ŋ gbaa n kyo̱rɛɛ amo̱ pɛɛɛ mɔ ke̱gyase̱ ke̱gyase̱ bo̱ sa fo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","To, saŋ ne̱ Hɛrɔd gye̱ Yude̱ya swe̱e̱re̱ se̱ owure‑o, Wuribware̱ ɔlɔŋŋɔpo̱ ko̱ mɔ bo̱‑rɔ ne̱ ba te̱e̱ mò̱ ɛ Sakariya. Ɔɔ le̱e̱ Isireelii awuye bo̱ko̱ ne̱ bo̱ gye̱ Wuribware̱ alɔŋŋɔpo̱ pɛɛɛ a kasuro‑o‑ro. Kasuro mɔ ne̱ baa ke‑ro mbuno si mbuno si‑o. Sakariya mɔ gye̱ mbuno‑o‑ro kako̱ ne̱ ba te̱e̱ kamo̱ ɛ Abiya‑o kigyi. Mò̱ ka ne̱ ba te̱e̱ ɛ Ilisabɛt ne̱ mò̱ gbaa a le̱e̱ kasuro‑o‑ro dɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Abɛɛ anyɔ mɔ kakye̱na‑rɔ a waa Wuribware̱ daŋ, a le̱e̱ fe̱yɛ baa gya mò̱ mbraa‑ɔ pɛɛɛ se̱ kyɛɛkyɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Amaa bo̱ mo̱ŋ de gyi, a le̱e̱ fe̱yɛ Ilisabɛt maa ko̱we̱. Amɔ bamo̱ anyɔ‑ɔ pɛɛɛ a kyɔ be̱re̱ lo̱we̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Saŋ a fo̱ fe̱yɛ Abiya kabuno‑o suŋ Wuribware̱ mò̱ suŋkpa. Fe̱yɛ ane̱ŋ ne̱ bamo̱ ade̱daase̱ŋ bo̱ le̱e̱ Wuribware̱ alɔŋŋɔpo̱ se̱ e̱ kaapo̱‑ɔ, ne̱ baa twe̱e̱ abu bo̱ lee Sakariya fe̱yɛ mò̱ e̱ gye̱ ne̱ o lwee Wuribware̱ suŋkpa‑ɔ ya kywɛɛ nyoŋku sa Wuribware̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Saŋ a fo̱, ne̱ oo lwee mfe̱ŋ ɔ ye̱re̱ ɔ kywɛɛ nyoŋku ɔ sa Wuribware̱‑ɔ, na lamaŋ‑ɔ mɔ ye̱re̱ kawu ba ko̱re̱ ke̱bware̱ko̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nyoŋku mɔ bo̱ kakyaŋse̱gyii ne̱ ka ye̱re̱ lɔŋŋɔkpa se̱‑ɔ‑rɔ ɔ kywɛɛ. Ne̱ Sakariya ye̱re̱ lɔŋŋɔkpa‑ɔ akatɔ‑rɔ. Puri amo̱‑rɔ ne̱ Wuribware̱ kabɔɔ ko̱ a le̱e̱ mò̱ se̱, na ɔ ye̱re̱ mò̱ kigyisesare̱e̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Amɔ Sakariya a ŋu Wuribware̱ kabɔɔ amo̱ ane̱ŋ‑ɔ, ne̱ mò̱ duŋ a te̱ŋ mò̱, ne̱ kufu a nya mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ne̱ Wuribware̱ kabɔɔ‑ɔ yɛ, “Sakariya, fo̱ ma sa a kufu nya fo̱. Wuribware̱ a nu fo̱ a ko̱re̱ mò̱ fe̱yɛ ɔ sa fo̱ kayaagyi. Amo̱se̱‑ɔ fo̱ aa fo̱ ka Ilisabɛt e̱ ko̱we̱ ɔnyare̱. Na fo̱ sa mò̱ ke̱nyare̱ fe̱yɛ Yohanee. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mò̱ ya ko̱we̱ mò̱, a sa a fo̱ akatɔ gyi bwe̱e̱tɔ na a sa a ase̱sɛ bwe̱e̱tɔ gbaa akatɔ gyi, ");
INSERT INTO ncuNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","a le̱e̱ fe̱yɛ o kii se̱sɛ dabe̱ a ɔ bo̱ sa Wuribware̱. O kisi nta ke̱maa. Na Wuribware̱ a kufwiiŋe timaa‑o sa mò̱ mò̱ ke̱yaale̱ŋ pwɛɛ gbaa na mo̱ne̱ dɛɛ ko̱we̱ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Na ɔ kpɔwe̱ ane̱ Isireelii awuye ne̱ baa te̱ŋŋe̱ bamo̱ aa ane̱ nyaŋpe̱ Wuribware̱ mbo̱ŋtɔ‑rɔ‑ɔ bwe̱e̱tɔ baa Wuribware̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Na ɔ nya ke̱yaale̱ŋ le̱e̱ Wuribware̱ a kufwiiŋe timaa‑o ase̱, fe̱yɛ ane̱ŋ ne̱ Wuribware̱ a akyaamɛɛ‑ɔ Iliya a nya‑ɔ dɛɛ. Na ɔ gye̱ ane̱ nyaŋpe̱ ŋkpɛɛ, na ɔ nya waa Wuribware̱ a ase̱sɛ‑ɔ siraa gywii mò̱. Na ɔ sa a ŋyaagyi na bamo̱ ase̱ a be̱e̱ kpa abɛɛ, na bo̱ waa kanɔ ko̱ŋko̱. Na ɔ sa a katɔmaabu awuye kyurowi bamo̱ mfɛɛre̱ bo̱ gya ase̱sɛ timaa e̱kpa se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ne̱ Sakariya a bise Wuribware̱ kabɔɔ‑ɔ fe̱yɛ, “Mo̱ aa mo̱ ka pɛɛɛ mɔ a be̱re̱. Ne̱ e̱me̱ne̱ ne̱ mo̱ e̱ waa a m bo̱ ŋu fe̱yɛ amo̱‑ɔ gye̱ kase̱ŋtiŋ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ne̱ ɔɔ be̱ŋŋaa fe̱yɛ, “Mo̱ e̱ gye̱ Gabriyɛl ne̱ ŋ ye̱re̱ Wuribware̱ fɔŋfɔŋ ase̱‑ɔ, ne̱ oo suŋ mo̱ fe̱yɛ m bo̱ tɔwe̱ ase̱ŋ kɔne̱kɔne̱sɛ mɔ gywii fo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Amaa fo̱ a mo̱ŋ kɔɔre̱ mo̱ kase̱ŋtiŋ ase̱ŋ mɔ ne̱ amo̱ ke̱be̱e̱ maa paŋ‑ɔ se̱‑ɔ, fo̱ i kii kpawu na kamu ya bo̱ fo̱ ŋke nsi ne̱ mo̱ne̱ e̱ ko̱we̱ kayaagyi‑o, ne̱ fo̱ i ŋu fe̱yɛ ase̱ŋ ne̱ mo̱ a tɔwe̱ gywii fo̱‑ɔ e̱ ba kase̱ŋtiŋ‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Saŋ mɔ pɛɛɛ na ase̱sɛ‑ɔ ye̱re̱ bo̱ gywii Sakariya, na ba fa ke̱tɔ se̱ ne̱ ɔɔ ko̱ŋ kyee Wuribware̱ suŋkpa‑ɔ bwe̱e̱tɔ ane̱ŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Saŋ ne̱ ɔɔ bo̱ le̱e̱‑ɔ, ne̱ ɔɔ ye̱re̱ ba asare̱e̱ bo̱ sa se̱ŋsa. Ne̱ baa pini fe̱yɛ Wuribware̱ a lee mò̱ e̱ye̱e̱ bo̱ kaapo̱ mò̱ mò̱ suŋkpa‑ɔ mfe̱ŋ, a le̱e̱ fe̱yɛ ɔ mo̱ŋ lɛɛ taare̱ yaye̱ kanɔ sa se̱ŋsa gywii bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ŋke ne̱ Sakariya e̱ waa mò̱ kusuŋ Wuribware̱ suŋkpa‑ɔ a kyo̱ŋ‑ɔ, ne̱ ŋkee ɔɔ yɔ mò̱ aye̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Bo̱ fo̱ saŋ ko̱‑ɔ ne̱ mò̱ ka a nya kame, ne̱ ŋkee ɔɔ kwe̱e̱rɔ ke̱kyaŋ‑nɔ aferi anuu, na ɔ maa le̱e̱ kawu. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ne̱ ɔɔ tɔwe̱ gywii mò̱ e̱ye̱e̱ fe̱yɛ, “Ŋkee fe̱raa Wuribware̱ a kya mo̱‑rɔ, ne̱ ɔɔ be̱e̱ lee mo̱ le̱e̱ ipeere‑ro ase̱sɛ ase̱!” ");
INSERT INTO ncuNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Amɔ Ilisabɛt a kame‑o aferi asiye‑o‑ro‑o, ne̱ Wuribware̱ a be̱e̱ suŋ mò̱ kabɔɔ Gabriyɛl fe̱yɛ ɔ yɔ Galile̱ya swe̱e̱re̱ se̱ a maŋ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Nasarɛt‑ɔ‑rɔ, ");
INSERT INTO ncuNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","na ɔ yɔ kabregyii ko̱ ne̱ ba te̱e̱ mò̱ ɛ Mariya‑o ase̱. Kabregyii mɔ ne̱ baa ke̱re̱ mò̱ sa ɔnyare̱ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Yo̱sɛf ne̱ ɔɔ le̱e̱ Yudaa awuye ɔde̱daapo̱ Deefid a kabuno‑o. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Amo̱ fe̱raa kabɔɔ‑ɔ a yɔ kabregyii amo̱ ase̱ mfe̱ŋ ne̱ ɔ bo̱‑ɔ, ne̱ ɔɔ ka mò̱ kanɔ tɔwe̱ gywii mò̱ fe̱yɛ, “Wuribware̱ a gya fo̱ kamɛɛ, ne̱ oo yure fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ne̱ Mariya duŋ a te̱ŋ mò̱ bo̱ le̱e̱ ke̱tɔ ne̱ Wuribware̱ a kabɔɔ‑ɔ a tɔwe̱‑ɔ se̱, ne̱ ɔɔ fa mfɛɛre̱ kpo̱ne̱ fe̱yɛ o nu ke̱mo̱ ne̱ kabɔɔ amo̱ a tɔwe̱‑ɔ kaase̱ aaa. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ne̱ kabɔɔ amo̱ a tɔwe̱ gywii mò̱ fe̱yɛ, “Mariya, fo̱ ma sa a kufu nya fo̱. Wuribware̱ a waa fo̱ atɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Fo̱ e̱ nya kame na fo̱ ko̱we̱ ɔnyare̱, na fo̱ sa mò̱ ke̱nyare̱ fe̱yɛ Yeesuu. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Na o kii se̱sɛ dabe̱, na bo̱ te̱e̱ mò̱ ɛ Nyiŋkpe̱ŋ-kyo̱ŋ-atɔ‑pɛɛɛ-Bware̱ mò̱ gyi‑o. Na Nyaŋpe̱ Wuribware̱ sa a ɔ kye̱na mò̱ nana Deefid a kuwure‑o si. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Na o kii mo̱ne̱ ɔde̱daapo̱ Yakubu a ananagyi‑o owure nsu pɛɛɛ. Mò̱ kuwure‑o maa gye̱ kɛɛ daa!” ");
INSERT INTO ncuNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ne̱ Mariya yɛ, “Mo̱ŋ nyi anyare̱, ne̱ e̱me̱ne̱ ne̱ a waa na a ba ane̱ŋ?” ");
INSERT INTO ncuNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ne̱ Wuribware̱ kabɔɔ‑ɔ mɔ yɛ, “Wuribware̱ a kufwiiŋe timaa‑o e̱ ywe̱e̱ fo̱ se̱, na Nyiŋkpe̱ŋ-kyo̱ŋ-atɔ‑pɛɛɛ-Bware̱ a ke̱yaale̱ŋ‑ɔ sii fo̱ se̱. Amo̱se̱‑ɔ fo̱ kayaagyi‑o, ba te̱e̱ mò̱ ɛ ke̱yaafɔre̱ timaa, Wuribware̱ mò̱ gyi‑o. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nu, fo̱ ko̱we̱bɛɛ Ilisabɛt ne̱ ɔɔ be̱re̱, ne̱ bo̱ yɛ ɔ maa ko̱we̱‑ɔ, de ɔnyare̱ kame. Kamo̱ aferi asiye ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Na sɛye̱ mo̱ŋ bo̱‑rɔ ne̱ Wuribware̱ maa taare̱ a ɔ waa!” ");
INSERT INTO ncuNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ne̱ Mariya yɛ, “Wuribware̱ kabre e̱ gye̱ mo̱, amo̱se̱‑ɔ a waa sa mo̱ fe̱yɛ ane̱ŋ ne̱ fo̱ a tɔwe̱‑ɔ mɔ dɛɛ.” Ne̱ Wuribware̱ kabɔɔ amo̱ a le̱e̱ mò̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ke̱tɔ mo̱ŋ kyee ne̱ Mariya a waa siraa, ne̱ ɔɔ da e̱ye̱e̱ se̱ yɔ Yude̱ya maŋ ko̱ ne̱ ɔ bo̱ abe̱e̱‑ɔ‑rɔ‑ɔ, mfe̱ŋ ne̱ Sakariya na mò̱ ka Ilisabɛt te‑o. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ne̱ ɔɔ yɔ Sakariya lɔŋ‑nɔ ya ka Ilisabɛt kanɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ilisabɛt ke̱de̱ŋ nu Mariya kanɔka‑ɔ, ne̱ kayaagyi ne̱ o de mò̱ kame‑o a dabo̱rɔ mò̱ e̱ye̱e̱ mò̱ nyi kame‑ro. Ne̱ Wuribware̱ a sa ne̱ mò̱ kufwiiŋe timaa‑o a le̱e̱ so̱so̱ bo̱ kye̱na Ilisabɛt se̱ puri amo̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ne̱ Ilisabɛt a tɔwe̱ keŋkeŋ gywii Mariya fe̱yɛ, “Akye̱e̱‑rɔ pɛɛɛ fo̱ ne̱ Wuribware̱ a yure bwe̱e̱tɔ, Wuribware̱ a yure kayaagyi ne̱ fo̱ e̱ ba a fo̱ bo̱ ko̱we̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mo̱ a nya kuŋu timaa fe̱yɛ mo̱ nyaŋpe̱ Kristoo mò̱ nyi a ba na ɔ bo̱ ka mo̱ kanɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mo̱ a de̱ŋ nu fo̱ kanɔka‑ɔ, ne̱ kayaagyi ne̱ ɔ bo̱ mo̱ kame‑ro‑o a dabo̱rɔ e̱ye̱e̱ bo̱ le̱e̱ fe̱yɛ aa waa mò̱ kɔne̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Fo̱ a kɔɔre̱ gyi fe̱yɛ ke̱tɔ ne̱ Wuribware̱ a suŋ bo̱ tɔwe̱ gywii fo̱‑ɔ e̱ ba‑rɔ kase̱ŋtiŋ‑o si‑o, o yure fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","48","Ne̱ Mariya yɛ, “Mo̱ e̱ kyo̱rɔ Wuribware̱ mo̱ kakpo̱nɔ‑rɔ. Mo̱ akatɔ a gyi mo̱ ɔmo̱rɔwe̱po̱ Wuribware̱ se̱. A le̱e̱ fe̱yɛ, hare̱e̱ mo̱ a gye̱ mò̱ kabre wo̱rɔba‑ɔ gbaa ooo, oo nyiŋŋi mo̱ se̱. Le̱e̱ ndɔɔ bo̱ yɔ, ase̱sɛ ne̱ bo̱ te mbe̱yɔmɔ‑ɔ na bamo̱ ne̱ ba ba a bo̱ bo̱ ko̱we̱‑ɔ, e̱ te̱e̱ mo̱ ɛ N‑de‑ŋyure. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Bo̱ le̱e̱ atɔ dabe̱ ne̱ Ɔyaale̱ŋpo̱-Bware̱ a waa sa mo̱‑ɔ se̱, mo̱ e̱ kyo̱rɔ mò̱ ke̱nyare̱ kpe̱yaa. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Le̱e̱ de̱daa‑ɔ bo̱ fo̱ mbe̱yɔmɔ ɔ kpa ke̱nana ke̱maa‑rɔ ase̱sɛ ne̱ ba bu mò̱‑ɔ ase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ne̱ o teyi mò̱ ke̱sare̱e̱ dabe̱‑ɔ bo̱ waa atɔ dabe̱, ne̱ ɔɔ brawe̱ bamo̱ ne̱ ba kaapo̱ bamo̱ e̱ye̱e̱‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ɔɔ baa awure kaase̱, ne̱ ɔɔ yase̱ ase̱sɛ laŋgyaŋ so̱so̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ɔɔ sa atiripo̱ atɔ timaa, ne̱ ɔɔ gya atɔ awuye bo̱ kyo̱ŋwe̱ asare̱e̱ kpaŋkpaŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Oo nyiŋŋi ke̱tɔ ne̱ ɔɔ tɔwe̱ gywii ane̱ nana Abraham mò̱ aa mò̱ ananagyi‑o si, fe̱yɛ o yure bamo̱ nsu pɛɛɛ‑ɔ. Ne̱ ŋkee ɔɔ ba na ɔ bo̱ kya ane̱ Isireelii awuye, Wuribware̱ mò̱ gyi‑ana‑ɔ‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ne̱ Mariya a kye̱na mfe̱ŋ ka Ilisabɛt kanɔ waa aferi asa pwɛɛ ne̱ ɔɔ dɛɛ kiŋŋi yɔ pe̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ilisabɛt ko̱ko̱we̱ saŋ a fo̱‑ɔ, ne̱ ɔɔ ko̱we̱ ɔnyare̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mò̱ akye̱nabɛɛpo̱ na mò̱ ako̱we̱bɛɛ a nu fe̱yɛ Wuribware̱ a waa atɔ timaa sa mò̱‑ɔ, ne̱ aa waa bamo̱ aa mò̱ kakatɔgyi. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Bamo̱ a ko̱we̱ kayaagyi‑o, ke̱mo̱ kake buruwase̱po̱‑ɔ, ne̱ baa te̱ŋ mò̱ ko̱twe̱e̱tu, ne̱ bo̱ yɛ bo̱ ba mò̱ se̱ Sakariya ke̱nyare̱ bo̱ sa mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ne̱ mò̱ nyi yɛ, “Daabii. Weetee mò̱ ke̱nyare̱ e̱ gye̱ Yohanee.” ");
INSERT INTO ncuNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ne̱ baa be̱ŋŋaa mò̱ fe̱yɛ, “Ne̱e̱ bo̱ maa te̱e̱ mo̱ne̱ ako̱we̱bɛɛ‑ɔ ɔko̱ mɔ ane̱ŋ ɛ?” ");
INSERT INTO ncuNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Mò̱ se̱ a mo̱ŋ tɛɛ taare̱ sa se̱ŋsa‑ɔ se̱‑ɔ, ne̱ baa ba asare̱e̱ bo̱ bise mò̱ ke̱nyare̱ ne̱ ɔ kpa fe̱yɛ bo̱ bo̱ sa mò̱ gyi amo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ne̱ ɔɔ ba asare̱e̱ bo̱ tɔwe̱ fe̱yɛ bo̱ sa mò̱ kataabo̱o̱ ne̱ ba kyo̱rɛɛ se̱‑ɔ, ne̱ ɔɔ kyo̱rɛɛ fe̱yɛ, “Mò̱ ke̱nyare̱ e̱ gye̱ Yohanee.” Ne̱ e̱ye̱e̱ a kpe̱ŋ bamo̱ pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mò̱ a de̱ŋ kyo̱rɛɛ amo̱ puri amo̱‑rɔ lo̱we̱‑ɔ, ne̱ mò̱ kanɔ a buŋŋi, ne̱ ɔɔ be̱e̱ le̱e̱ ɔ sa se̱ŋsa, ne̱ ɔɔ me̱raa se̱ ɔ kyo̱rɔ Wuribware̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ne̱ aa waa mò̱ akye̱nabɛɛpo̱‑ɔ pɛɛɛ kufu, ne̱ ase̱ŋ amo̱ a lweero fo̱ Yude̱ya abe̱e̱‑ɔ‑rɔ a e̱maŋ‑ɔ ɔke̱maa se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ɔke̱maa ne̱ oo nu ase̱ŋ amo̱‑ɔ a fa amo̱ mfɛɛre̱, ne̱ bo̱ yɛ, “Ntɔ se̱sɛ ne̱ kayaagyi mɔ e̱ ba a ɔ bo̱ kii‑o ne̱e̱?” A le̱e̱ fe̱yɛ ɔke̱maa a ŋu fe̱yɛ Wuribware̱ ke̱yaale̱ŋ bo̱ mò̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ne̱ Wuribware̱ a kufwiiŋe timaa‑o a bo̱ ywe̱e̱ Sakariya si, ne̱ ɔɔ le̱e̱ ɔ tɔwe̱ ke̱tɔ ne̱ Wuribware̱ e̱ tɔwe̱ o gywii mò̱‑ɔ. Ne̱ ɔ yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Mo̱nꞌ sa a ane̱ Isireelii awuye kyo̱rɔ ane̱ nyaŋpe̱ Wuribware̱, a le̱e̱ fe̱yɛ ɔɔ bo̱ lee mò̱ ase̱sɛ le̱e̱ ase̱ŋ‑nɔ, ne̱ baa nya bamo̱ e̱ye̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ɔɔ sa ane̱ ɔmo̱rɔwe̱po̱ dabe̱ bo̱ le̱e̱ mò̱ ke̱yaafɔre̱, ane̱ ɔde̱daapo̱ Deefid, a ke̱nana‑ɔ‑rɔ, ");
INSERT INTO ncuNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","fe̱yɛ ane̱ŋ ne̱ ɔɔ bo̱rɔ mò̱ akyaamɛɛ timaa si tɔwe̱ kyee bo̱ be̱ya ane̱‑ɔ, fe̱yɛ o lee ane̱ a ɔ bo̱ le̱e̱ ane̱ ado̱ŋ na bamo̱ ne̱ ba kisi ane̱‑ɔ ke̱sare̱e̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","75","Wuribware̱ yɛ ɔ waa ane̱ ade̱daapo̱ ke̱dame̱naŋsɛ, na ɔ ma taŋ e̱taŋ dabe̱ ne̱ ɔɔ waa bo̱ be̱ya mò̱ aa ane̱ nana Abraham mbo̱ŋtɔ‑rɔ‑ɔ se̱, fe̱yɛ ɔ kɔɔre̱ ane̱ a ɔ bo̱ le̱e̱ ane̱ ado̱ŋ ase̱, na ɔ sa a ane̱ suŋ mò̱ bo̱ fo̱ ane̱ ŋkpake kɛɛ, na kufu mo̱ŋ de ane̱, na ane̱ nya ŋkpo̱nɔfwiiri mò̱ ase̱ na ane̱ de̱e̱ kii itimaa awaapo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ne̱ Sakariya a sa se̱ŋsa gywii mò̱ gyi‑o fe̱yɛ, “Mo̱ gyi, fo̱ fe̱raa ba te̱e̱ fo̱ fe̱yɛ Nyiŋkpe̱ŋ-kyo̱ŋ-atɔ‑pɛɛɛ-Bware̱ a kyaamɛɛ‑ɔ, a le̱e̱ fe̱yɛ fo̱ e̱ gye̱ Wuribware̱ ŋkpɛɛ, na fo̱ ya lɔŋŋɔ mò̱ kpa bo̱ be̱ya mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Na fo̱ ya tɔwe̱ gywii ane̱ ne̱ ane̱ gye̱ mò̱ ase̱sɛ‑ɔ fe̱yɛ, ɔ kpa fe̱yɛ ane̱ nu ane̱ e̱ye̱e̱, na ɔ nya taa ane̱ e̱bɔye̱ bo̱ ke ane̱ na ɔ mo̱rɔwe̱ ane̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Mò̱ a ŋu ane̱ e̱wɛɛ‑ɔ se̱‑ɔ, ane̱ŋ a ɔmo̱rɔwe̱po̱ ne̱ o suŋ a ɔ bo̱ kyo̱ŋwe̱ ane̱‑ɔ, ba te̱e̱ mò̱ ɛ Gye̱gyaye̱-kyɔwe̱-a‑ke̱laŋŋe̱rɔ‑ɔ, a le̱e̱ fe̱yɛ mò̱ ke̱laŋŋe̱rɔ e̱ we̱e̱ ane̱ ne̱ ane̱ te kibugyii‑ro, ne̱ ane̱ se̱re̱ lowi‑o si, na ɔ laŋŋe̱ ane̱ e̱kpa‑rɔ na ane̱ nya kye̱na ŋkpa na alaŋfiya‑ro.” ");
INSERT INTO ncuNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kayaagyi‑o a daŋ‑ɔ, ɔɔ nya kanyiase̱ŋ na daa timaa. Ne̱ ŋkee ɔɔ yɔ ya kye̱na kimukee‑ro ane̱ŋ‑aaa, bo̱ fo̱ saŋ ne̱ o lee mò̱ e̱ye̱e̱ ifuri bo̱ kaapo̱ Isireelii awuye‑o. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ŋke amo̱‑rɔ‑ɔ ne̱ Roma awuye owure dabe̱ Kaye̱saa Agustus a sa mbraa fe̱yɛ bo̱ kyo̱rɛɛ na bo̱ kare̱ ase̱sɛ ne̱ bo̱ bo̱ mò̱ e̱se̱‑ɔ se̱‑ɔ pɛɛɛ. Amo̱ e̱ gye̱ ke̱gye̱ŋkpɛɛ fe̱yɛ bamo̱ a sa ane̱ŋ a mbraa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Swe̱e̱re̱ amo̱ se̱ to̱ŋ ko̱ e̱ gye̱ Siriya. Saŋ amo̱‑ɔ gominaa ne̱ ɔ ye̱re̱ owure dabe̱‑ɔ ayaa‑rɔ mfe̱ŋ‑ɔ e̱ gye̱ Kwiriniyus. Ne̱ gominaa amo̱ de Yudaa awuye e̱swe̱e̱re̱ ne̱ ba te̱e̱ e̱mo̱ Galile̱ya na Samariya na Yude̱ya‑ɔ se̱ ke̱yaale̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ne̱ baa sa mbraa fe̱yɛ ɔke̱maa yɔ mò̱ aye̱, na ɔ kyo̱rɛɛ mò̱ ke̱nyare̱ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Amo̱se̱‑ɔ Yo̱sɛf na mò̱ ke̱re̱kye̱e̱ Mariya gbaa a ko̱so̱ le̱e̱ Nasarɛt maŋ ne̱ bo̱ te mò̱‑rɔ ne̱ ɔ bo̱ Galile̱ya swe̱e̱re̱ se̱‑ɔ. Ne̱ baa yɔ Bɛte̱lahɛm maŋ ne̱ ɔ bo̱ Yude̱ya swe̱e̱re̱ se̱‑ɔ ne̱ ɔ gye̱ bamo̱ nana Owure Deefid aye̱‑ɔ. Ne̱ baa yɔ ya kyo̱rɛɛ bamo̱ anyare̱. Saŋ amo̱ na Mariya de kame. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bamo̱ a bo̱ Bɛte̱lahɛm mfe̱ŋ‑ɔ, ne̱ Mariya ko̱ko̱we̱ a fo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ne̱ baa buwi kpa afɔ a so̱we̱kpa a lɔŋ‑ɔ na bo̱ so̱we̱ mfe̱ŋ. Amaa bo̱ mo̱ŋ nya so̱we̱kpa lɔŋ amo̱‑rɔ, a le̱e̱ fe̱yɛ ase̱sɛ bwe̱e̱tɔ a ba maŋ amo̱‑rɔ kyɔ bo̱ so̱we̱ mfe̱ŋ. Ane̱ŋ se̱‑ɔ baa so̱we̱ ke̱kyaŋ ne̱ mbo̱ da‑rɔ‑ɔ‑rɔ ne̱e̱. Ne̱ Mariya a ko̱we̱ mò̱ bregyi nyaŋsɛ‑ɔ. Ne̱ ɔɔ ba waagya bo̱ miri mò̱, ne̱ ɔɔ taa mò̱ bo̱ be̱ya ke̱dakaa ko̱ ne̱ bo̱ de mbo̱ ateese ba waa‑rɔ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ke̱mo̱ kanye amo̱ e̱sanne̱ ade̱e̱re̱se̱po̱ ko̱ mɔ bo̱ swe̱e̱re̱ amo̱ se̱, ne̱ bo̱ da e̱fa‑rɔ ba de̱e̱re̱ bamo̱ mbo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mfe̱ŋ ne̱ Wuribware̱ kabɔɔ ko̱ a lee mò̱ e̱ye̱e̱ bo̱ kaapo̱ bamo̱. Ne̱ Wuribware̱ se̱ a ke̱laŋŋe̱rɔ‑ɔ a we̱e̱ bamo̱ se̱, ne̱ kufu a nya bamo̱ bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ne̱ Wuribware̱ kabɔɔ‑ɔ yɛ, “Mo̱ne̱ ma sa a kufu nya mo̱ne̱, a le̱e̱ fe̱yɛ ase̱ŋ kɔne̱kɔne̱sɛ ko̱ ne̱ a baa ɔke̱maa mɔ kakatɔgyi‑o ne̱ mo̱ a baa mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Amo̱ e̱ gye̱ fe̱yɛ ndɔɔ a kake mɔ baa ko̱we̱ ɔko̱ ne̱ ɔ mo̱rɔwe̱ mo̱ne̱‑ɔ. Mò̱ e̱ gye̱ Kristoo, mo̱ne̱ nyaŋpe̱ ne̱ Wuribware̱ a tɔwe̱ fe̱yɛ o suŋ a ɔ bo̱ kyo̱ŋwe̱ mo̱ne̱‑ɔ. Baa ko̱we̱ mò̱ mo̱ne̱ ɔde̱daapo̱ Deefid a maŋ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na ke̱tɔ ne̱ ke̱ e̱ kaapo̱ mo̱ne̱‑ɔ e̱ gye̱ fe̱yɛ, mo̱ne̱ ya yɔ, mo̱ne̱ i ŋu fe̱yɛ baa ba waagya bo̱ miri mò̱ bo̱ be̱ya ke̱dakaa ne̱ bo̱ de mbo̱ ateese ba waa‑rɔ‑ɔ‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Puri amo̱‑rɔ, ne̱ Wuribware̱ mbɔɔ bwe̱e̱tɔ a le̱e̱ so̱so̱ bo̱ tii ɔgye̱ŋkpɛɛsɛ‑ɔ se̱ e̱sanne̱ ade̱e̱re̱se̱po̱ amo̱ ase̱ mfe̱ŋ, na ba waa iliŋ ba kyo̱rɔ Wuribware̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Wuribware̱ ne̱ ɔ bo̱ so̱so̱‑ɔ a nya ke̱dabe̱ na wuraa ooo, ne̱ bamo̱ ne̱ bo̱ bo̱ swe̱e̱re̱ se̱ ne̱ ɔ kpa bamo̱ ase̱ŋ‑ɔ a nya kaye̱e̱yuri ooo.” ");
INSERT INTO ncuNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Amɔ Wuribware̱ mbɔɔ amo̱ a kiŋŋi bo̱ yii so̱so̱‑ɔ, ne̱ ŋkee e̱sanne̱ ade̱e̱re̱se̱po̱ amo̱ yɛ, “Mo̱nꞌ sa a ane̱ yɔ maŋ amo̱‑rɔ ya ke̱e̱ ke̱tɔ ne̱ kaa waa mfe̱ŋ ne̱ Wuribware̱ a suŋ bo̱ tɔwe̱ gywii ane̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Amo̱se̱‑ɔ ne̱ baa waa me̱naŋ yɔ Bɛte̱lahɛm ya ŋu Mariya na Yo̱sɛf na kayaagyi‑o, na ɔ da ke̱dakaa ne̱ bo̱ de mbo̱ ateese ba waa‑rɔ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ne̱ baa tɔwe̱ ane̱ŋ ne̱ Wuribware̱ kabɔɔ‑ɔ a tɔwe̱ kayaagyi amo̱ ase̱ŋ‑ɔ gywii bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ne̱ e̱ye̱e̱ a kpe̱ŋ ɔke̱maa ne̱ oo nu ane̱ŋ ne̱ e̱sanne̱ ade̱e̱re̱se̱po̱ amo̱ a tɔwe̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariya mɔ a taa ase̱ŋ mɔ pɛɛɛ bo̱ be̱ya mò̱ kuŋu‑ro, ne̱ ɔɔ fa amo̱ mfɛɛre̱ bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ne̱ e̱sanne̱ ade̱e̱re̱se̱po̱‑ɔ a kiŋŋi ba yɔ, na ba waa iliŋ ba kyo̱rɔ Wuribware̱ bo̱ le̱e̱ ke̱tɔ ne̱ baa nu ne̱ baa ŋu‑o si. Ane̱ŋ ne̱ Wuribware̱ kabɔɔ‑ɔ a de̱ŋ tɔwe̱ gywii bamo̱‑ɔ dɛɛ ya waa. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kayaagyi‑o a gyi ŋke mburuwa‑o, ne̱ saŋ a fo̱ fe̱yɛ bo̱ te̱ŋ mò̱ ko̱twe̱e̱tu‑o. Ne̱ baa te̱ŋ mò̱ ko̱twe̱e̱tu. Ne̱ baa sa mò̱ ke̱nyare̱ ɛ Yeesuu, ne̱ ke̱ gye̱ ke̱nyare̱ ne̱ Wuribware̱ kabɔɔ‑ɔ a sa mò̱ pwɛɛ ne̱ Mariya a dɛɛ nya mò̱ kame‑o. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Amɔ Yudaa awuye de bamo̱ mbraa ko̱ ne̱ Wuribware̱ a sa bamo̱ ɔde̱daapo̱ Mosis fe̱yɛ ɔkye̱e̱ ya ko̱we̱ kayaagyi po̱pwɛɛ o de iyisi bo̱ fo̱ ŋke aduna. Ŋke amo̱ ya kyo̱ŋ, na bo̱ taa ɔkye̱e̱‑ɔ na mò̱ kayaagyi‑o yaa Wuribware̱ suŋkpa‑ɔ Yɛro̱salɛm maŋ‑nɔ, na bo̱ kperi kayaagyi‑o si mɔɔ kabo̱ bo̱ lɔŋŋɔ Wuribware̱, a le̱e̱ fe̱yɛ Wuribware̱ a tɔwe̱ mò̱ mbraa wo̱re̱‑ɔ‑rɔ fe̱yɛ, “Ɔke̱maa bregyi nyaŋsɛ ne̱ ɔ ko̱we̱ mò̱‑ɔ gye̱ Wuribware̱ lee.” Na bo̱ be̱e̱ kpɛɛ ɔkye̱e̱‑ɔ se̱. Ne̱ ɔkye̱e̱‑ɔ e̱ gye̱ otiripo̱ fe̱raa, ke̱tɔ ne̱ ɔ mɔɔ bo̱ sa Wuribware̱‑ɔ e̱ gye̱ awurele̱pɔ anyɔ. Ne̱ Yo̱sɛf a taa Mariya na mò̱ kayaagyi yaa Wuribware̱ suŋkpa‑ɔ Yɛro̱salɛm mfe̱ŋ na bo̱ lɔŋŋɔ Wuribware̱, fe̱yɛ ane̱ŋ ne̱ bamo̱ mbraa‑ɔ a tɔwe̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Saŋ amo̱ mɔ ɔnyare̱ ko̱ bo̱ Yɛro̱salɛm mfe̱ŋ ne̱ ba te̱e̱ mò̱ ɛ Simeyɔŋ. Ɔnyare̱ amo̱ gye̱ se̱sɛ timaa, ne̱ o suŋ Wuribware̱ nɛɛnɛɛ. Ne̱ ŋkee o te o gywii saŋ ne̱ Wuribware̱ i suŋ ɔmo̱rɔwe̱po̱ a ɔ bo̱ kyo̱ŋwe̱ Isireelii awuye‑o. Ne̱ Wuribware̱ a kufwiiŋe timaa‑o te mò̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ne̱ Wuribware̱ a kufwiiŋe timaa‑o a kyɔ tɔwe̱ gywii mò̱ fe̱yɛ o ŋu Kristoo ne̱ Wuribware̱ a tɔwe̱ bo̱ be̱ya fe̱yɛ o suŋ a ɔ bo̱ kyo̱ŋwe̱‑ɔ pwɛɛ na ɔ dɛɛ wu. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ne̱ Wuribware̱ a kufwiiŋe timaa‑o a sa ne̱ ɔɔ yɔ Wuribware̱ suŋkpa‑ɔ kabuno kake nsi ne̱ Yo̱sɛf na Mariya a baa Yeesuu mfe̱ŋ na bo̱ bo̱ waa ke̱tɔ ne̱ Wuribware̱ a mbraa‑ɔ e̱ kaapo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ne̱ Simeyɔŋ a kɔɔre̱ keegyi‑o o de mò̱ asare̱e̱‑rɔ, ne̱ ɔɔ sa Wuribware̱ aŋsɛ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O, Nyaŋpe̱ Wuribware̱, mo̱ mfɛɛre̱ a di mo̱, ŋkee fe̱raa sa a ŋ wu, ");
INSERT INTO ncuNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","a le̱e̱ fe̱yɛ ŋkee fe̱raa mo̱ a ŋu ɔko̱ ne̱ fo̱ a tɔwe̱ bo̱ be̱ya fe̱yɛ mo̱ i ŋu pwɛɛ na n dɛɛ wu‑o. Mò̱ e̱ gye̱ ɔmo̱rɔwe̱po̱ ne̱ fo̱ a lee bo̱ kaapo̱ ase̱sɛ pɛɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","O kii fe̱yɛ fetiri a ɔ bo̱ sa nde̱ se̱ awuye, na bo̱ nya gyii fo̱ e̱kpa‑ɔ. Na fo̱ ase̱sɛ Isireelii awuye kaapo̱ bamo̱ e̱ye̱e̱ mò̱ ke̱dabe̱ na mò̱ wuraa‑o si.” ");
INSERT INTO ncuNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ne̱ ane̱ŋ ne̱ Simeyɔŋ a tɔwe̱ bo̱ le̱e̱ kayaagyi‑o si‑o a kpe̱ŋ kayaagyi‑o mò̱ se̱ na mò̱ nyi e̱ye̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Ne̱ Simeyɔŋ a yure bamo̱, ne̱ ɔɔ tɔwe̱ gywii Mariya fe̱yɛ, “Wuribware̱ a lee kayaagyi mɔ ne̱e̱ fe̱yɛ o kii ɔko̱ ne̱ ane̱ Isireelii awuye bwe̱e̱tɔ i kine, na bo̱ kpuri, ne̱ bamo̱ bwe̱e̱tɔ mɔ e̱ kɔɔre̱ mò̱ a bo̱ gyi, na bo̱ nya ke̱mo̱rɔwe̱‑ɔ. Ɔ kaapo̱ Wuribware̱ a e̱kpa‑ɔ, amaa ase̱sɛ bwe̱e̱tɔ e̱ tɔwe̱ ase̱ŋ a bo̱ bo̱ kye mò̱. Na bo̱ le̱e̱ ane̱ŋ se̱‑ɔ bo̱ lee bamo̱ mfɛɛre̱ bɔye̱ ifuri. Na fo̱, mò̱ nyi‑o mɔ, a waa fo̱ gya bwe̱e̱tɔ, na fo̱ bo̱re̱‑rɔ duŋwi fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Saŋ amo̱ dɛɛ ke̱kye̱e̱bre̱sɛ ko̱ mɔ bo̱‑rɔ ne̱ ba te̱e̱ mò̱ ɛ Anaa. Ɔ gye̱ Wuribware̱ kyaamɛɛ ko̱ ne̱e̱. Ɔɔ le̱e̱ Isireelii awuye kasuro ne̱ ba te̱e̱ kamo̱ ɛ Ase̱re̱‑ɔ‑rɔ. Mò̱ se̱ ke̱nyare̱ e̱ gye̱ Fanuwɛl. Ɔɔ waare̱e̱ na ɔ gye̱ kabregyii, ne̱ mò̱ aa mò̱ kuri a kye̱na nsu nsunoo, ne̱ mò̱ kuri a wu. Ne̱ oo kii kpenlekye̱e̱ ane̱ŋ‑aaa bo̱ fo̱ mbe̱yɔmɔ, ne̱ oo gyi nsu aduburuwa na nna. Ne̱ ŋkee ɔ bo̱ Wuribware̱ suŋkpa‑ɔ kabuno saŋ ke̱maa, o suŋ Wuribware̱ mpase̱ na kanye, na ɔ kra ako̱ŋ, na ɔ ko̱re̱ ke̱bware̱ko̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kayaagyi‑o na mò̱ se̱ na mò̱ nyi a bo̱ mfe̱ŋ‑ɔ, ne̱ Anaa a ya ŋu bamo̱. Mò̱ ke̱ya ŋu bamo̱‑ɔ, ne̱ ɔɔ sa Wuribware̱ aŋsɛ na ko̱waa fe̱yɛ mò̱ a sa bamo̱ kayaagyi amo̱. Ne̱ ɔɔ tɔwe̱ kayaagyi amo̱ ase̱ŋ gywii Yɛro̱salɛm awuye ne̱ bo̱ gywii fe̱yɛ Wuribware̱ e̱ ba a ɔ bo̱ mo̱rɔwe̱ bamo̱ maŋ‑ɔ le̱e̱ bamo̱ ado̱ŋ ke̱sare̱e̱‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Saŋ ne̱ Yo̱sɛf na mò̱ ka Mariya a waa ke̱tɔ ne̱ Wuribware̱ a mbraa‑ɔ e̱ kaapo̱‑ɔ lo̱we̱‑ɔ, ne̱ baa kiŋŋi yɔ bamo̱ kye̱nakpa Nasarɛt maŋ ne̱ ɔ bo̱ Galile̱ya swe̱e̱re̱ se̱‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mfe̱ŋ ne̱ bamo̱ gyi amo̱ a ya daŋ nya e̱le̱ŋ. Ne̱ Wuribware̱ a sa mò̱ kanyiase̱ŋ bwe̱e̱tɔ, ne̱ ɔɔ sa mò̱ ŋyure. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","To, kasu ke̱maa mɔ Yeesuu mò̱ ako̱we̱po̱ naa Yɛro̱salɛm maŋ‑nɔ ba gyi Yudaa awuye a kasu kanɔ a ateese ko̱ ne̱ ba te̱e̱ amo̱ ɛ Wuribware̱-a‑kya-ane̱-yɔwe̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Amɔ Yudaa awuye ase̱ kanyaŋsɛɛ ya gyi nsu kudu ŋnyɔ, o de kpa fe̱yɛ ɔ waa ke̱tɔ ke̱maa ne̱ ɔko̱ ne̱ ɔɔ daŋ lo̱we̱‑ɔ e̱ waa‑ɔ. Amo̱se̱ se̱‑ɔ Yeesuu a gyi nsu kudu ŋnyɔ‑ɔ, ne̱ mò̱ aa mò̱ ako̱we̱po̱ a ya gyi ateese amo̱, fe̱yɛ ane̱ŋ ne̱ nsu ke̱maa mò̱ ako̱we̱po̱‑ɔ e̱ waa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Bamo̱ a lo̱we̱‑ɔ, ne̱ ŋkee ba kiŋŋi ba yɔ pe̱‑ɔ, ne̱ Yeesuu wo̱re̱ a sii Yɛro̱salɛm, na mò̱ ako̱we̱po̱ mo̱ŋ nyi. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ba fa fe̱yɛ ɔ bo̱ ase̱sɛ ne̱ bamo̱ aa bamo̱ a yɔ‑ɔ‑rɔ ne̱e̱. Amo̱se̱‑ɔ baa nare̱ ane̱ŋ‑aaa kake ko̱ŋko̱ ya fo̱ kpa‑rɔ pwɛɛ ne̱ baa dɛɛ le̱e̱ ba buwi ba kpa mò̱ bamo̱ ako̱we̱bɛɛ ne̱ bamo̱ aa bamo̱ a yɔ‑ɔ na bamo̱ nyare̱‑ana ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Amaa baa de̱e̱re̱ kpo̱ne̱, bo̱ mo̱ŋ ŋu mò̱. Ane̱ŋ se̱‑ɔ, ne̱ baa kiŋŋi be̱e̱ yɔ Yɛro̱salɛm ba buwi ba kpa mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Bamo̱ a le̱e̱ ba yɔ pe̱‑ɔ ŋke nsa‑rɔ pwɛɛ ne̱ baa dɛɛ ŋu mò̱, na mò̱ aa abware̱se̱ŋ akaapo̱po̱‑ɔ bo̱ko̱ te Wuribware̱ suŋkpa‑ɔ kabuno, na o nu ke̱tɔ ne̱ ba kaapo̱‑ɔ, na o bise bamo̱ amo̱ ase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ne̱ bamo̱ ne̱ baa ŋu ane̱ŋ ne̱ Yeesuu a nu ase̱ŋ‑ɔ kaase̱ na mò̱ gbaa e̱ be̱ŋŋaa bamo̱‑ɔ, e̱ye̱e̱ a kpe̱ŋ bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mò̱ se̱ na mò̱ nyi a ya ŋu mò̱‑ɔ, ne̱ e̱ye̱e̱ a kpe̱ŋ bamo̱, ne̱ mò̱ nyi yɛ, “Mo̱ gyi, nte̱tɔ ne̱e̱ ne̱ fo̱ a waa ane̱ mfaanɛɛ‑ɔ ne̱e̱? Fo̱ a sa ne̱ mo̱ aa fo̱ se̱ akatɔ a pee ane̱ i buwi ane̱ e̱ kpa fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ne̱ ɔɔ be̱ŋŋaa mò̱ nyi na mò̱ se̱ fe̱yɛ, “Nte̱tɔ se̱ ne̱ mo̱ne̱ naa mo̱ne̱ i buwi mo̱ne̱ e̱ kpa mo̱ to̱ŋ ko̱‑ɔ ne̱e̱? Mo̱ne̱ mo̱ŋ nyi fe̱yɛ a tiri fe̱yɛ n kye̱na n se̱ a lɔŋ‑ɔ‑rɔ ne̱e̱ e̱e̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Amaa bo̱ mo̱ŋ nu mò̱ ase̱ŋ‑ɔ kaase̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ne̱ bamo̱ aa Yeesuu a kiŋŋi yɔ Nasarɛt maŋ‑nɔ, ne̱ oo bu bamo̱ nɛɛnɛɛ. Ne̱ mò̱ nyi a taa ase̱ŋ mɔ pɛɛɛ bo̱ be̱ya mò̱ kuŋu‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ne̱ Yeesuu a daŋ, ne̱ mò̱ kanyiase̱ŋ a waa ko̱kyɔ. Ne̱ Wuribware̱ na ase̱sɛ pɛɛɛ a kpa mò̱ ase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Saŋ ne̱ Wuribware̱ a sa ne̱ Sakariya mò̱ gyi Yohanee a tɔwe̱ abware̱se̱ŋ na ɔ bo̱ kimukee‑ro‑o, na saŋ amo̱ nsu kudu nnuu ne̱e̱ fe̱yɛ Roma awuye owure dabe̱ ne̱ ba te̱e̱ mò̱ ɛ Tibeeriyus‑o a gyi kuwure‑o. Saŋ amo̱ dɛɛ na Romanyi ko̱ ne̱ ba te̱e̱ mò̱ ɛ Pontiyus Pilat ye̱re̱ owure dabe̱ amo̱ ayaa‑rɔ o gyi Yude̱ya swe̱e̱re̱ se̱ kigominaa. Ɔnyare̱ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Hɛrɔd‑ɔ gye̱ Galile̱ya swe̱e̱re̱ se̱ owure. Mò̱ tire Filipo e̱ gye̱ Iture̱ya na Trakoniitis e̱swe̱e̱re̱ se̱ owure. Na ɔnyare̱ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Lisaniyas‑o gye̱ Abileenee swe̱e̱re̱ se̱ owure. Ne̱ Hanaa na Kayafas mɔ i gyi Wuribware̱ alɔŋŋɔpo̱ ke̱bre̱sɛ saŋ amo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","To, ne̱ Yohanee a yɔ Yo̱o̱daŋ bo̱ŋ a keri‑o pɛɛɛ ɔ tɔwe̱ abware̱se̱ŋ ne̱ Wuribware̱ yɛ ɔ tɔwe̱‑ɔ gywii ɔke̱maa ne̱ ɔ bo̱rɔ mfe̱ŋ ɔ kyo̱ŋ‑ɔ fe̱yɛ, “Mo̱nꞌ nu mo̱ne̱ e̱ye̱e̱, na mo̱nꞌ kiŋŋi le̱e̱ mo̱ne̱ e̱bɔye̱‑rɔ, na mo̱nꞌ bɔ asuu, na Wuribware̱ nya taa mo̱ne̱ e̱bɔye̱ bo̱ ke mo̱ne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yohanee mɔ ase̱ŋ ne̱ Wuribware̱ kyaamɛɛ Isaya a kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ, “Ɔko̱ e̱ fɛɛ‑rɔ kimukee‑ro fe̱yɛ, ‘Mo̱nꞌ lɔŋŋɔ kpa nɛɛnɛɛ bo̱ be̱ya Wuribware̱, na mo̱nꞌ waa kpa kye̱rarasɛ sa mò̱ a ɔ bo̱ bo̱rɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ke̱maŋtaŋ ke̱maa mɔ e̱ bo̱rɔ a ki tii, na ke̱be̱e̱ na ke̱be̱e̱gyi ke̱maa mɔ buburi ba kaase̱. E̱kpa kɔre̱sɛ e̱ waa kyɛye̱, na swe̱e̱re̱ ne̱ o du sake̱sake̱‑ɔ pɛɛɛ mɔ gyiiri si. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na kaye̱ mɔ‑rɔ ase̱sɛ pɛɛɛ ŋu ɔmo̱rɔwe̱po̱ ne̱ Wuribware̱ i suŋ a ɔ bo̱ kyo̱ŋwe̱‑ɔ.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ne̱ ase̱sɛ biribiri a ba Yohanee ase̱ na ɔ bɔ bamo̱ asuu. Ne̱ ɔ yɛ, “Mo̱ne̱ awɔ mɔ, e̱me̱ne̱ se̱ ne̱ mo̱ne̱ a ba mfe̱e̱? Ɔko̱ a kaapo̱ mo̱ne̱ fe̱yɛ a tiri fe̱yɛ mo̱ne̱ gbaa mo̱nꞌ lee mo̱ne̱ e̱ye̱e̱ bo̱ le̱e̱ e̱bɔye̱ a kakɔka ne̱ Wuribware̱ e̱ kpa a ɔ ba bo̱ sa abɔye̱waapo̱‑ɔ‑rɔ aaa? Ma kɔɔre̱ a n gyi. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mo̱ne̱ ma fa fe̱yɛ mo̱ne̱ a gye̱ ane̱ nana Abraham mò̱ ananagyi‑o si, mo̱ne̱ mo̱ŋ tii kakɔka ne̱ Wuribware̱ e̱ kpa a ɔ ba bo̱ sa abɔye̱waapo̱‑ɔ se̱. A le̱e̱ fe̱yɛ Wuribware̱ e̱ taare̱ a ɔ ba mfe̱e̱ a afo̱re̱ mɔ bo̱ buruwi ase̱sɛ na bo̱ kii Abraham mò̱ ananagyi. Amo̱se̱‑ɔ mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ, mo̱ne̱ akatɔ ya pee amo̱‑ɔ se̱, ke̱tɔ ne̱ ki tiri‑o e̱ gye̱ fe̱yɛ mo̱nꞌ waa atɔ ke̱maa ne̱ weetee a kaapo̱ fe̱yɛ mo̱ne̱ a nu mo̱ne̱ e̱ye̱e̱ ne̱ mo̱ne̱ a kiŋŋi le̱e̱ mo̱ne̱ e̱bɔye̱‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mo̱ne̱ pɛɛɛ ne̱ mo̱ne̱ i nu mo̱ ase̱‑ɔ du ne̱e̱ fe̱yɛ ayii‑o. Mo̱nꞌ sa se̱, a le̱e̱ fe̱yɛ Wuribware̱ a waa kakwii‑atɔ siraa, na ɔ ba bo̱ ŋe kiyii ke̱maa ne̱ ke̱ maa swɛɛ agyi timaa‑o ileŋ kaase̱ a ɔ bo̱ da na ɔ twe̱e̱ waa de̱e̱kpa‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ne̱ ase̱sɛ‑ɔ a bise Yohanee fe̱yɛ, “Ne̱ nte̱tɔ ne̱ Wuribware̱ e̱ kpa a ane̱ waa?” ");
INSERT INTO ncuNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ne̱ ɔɔ be̱ŋŋaa bamo̱ fe̱yɛ, “Ɔke̱maa ne̱ o de awaagya anyɔ‑ɔ taa ɔko̱ŋko̱ sa mò̱ ne̱ ɔ mo̱ŋ de‑o, na ɔke̱maa ne̱ o de ateese‑o sa mò̱ ne̱ ɔ mo̱ŋ de‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ne̱ leŋpoo akɔɔre̱po̱ ko̱ a ba a bo̱ bo̱ bɔ asuu, ne̱ baa bise Yohanee fe̱yɛ, “Ɔkaapo̱po̱, nte̱tɔ ne̱ ane̱ waa?” ");
INSERT INTO ncuNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ne̱ ɔ yɛ, “Mo̱ne̱ ma kɔɔre̱ leŋpoo kyo̱ŋ ane̱ŋ ne̱ bo̱ yɛ mo̱nꞌ kɔɔre̱‑ɔ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ne̱ asoogyaa ko̱ mɔ a bise mò̱ fe̱yɛ, “Ne̱ ane̱ mɔ ane̱ ɛɛɛ? Nte̱tɔ ne̱ ane̱ waa?” Ne̱ ɔ yɛ, “Mo̱ne̱ ma le̱ŋ ɔko̱ kɔɔre̱ atanne̱, na mo̱ne̱ ma po̱rɔ ɔko̱ na ɔ mo̱ŋ waa bɔye̱ kɔɔre̱ mò̱ atanne̱. Mo̱ne̱ atanne̱ ne̱ mo̱ne̱ i suŋ ne̱ ba ka mo̱ne̱‑ɔ a baare. Mo̱ne̱ ma tɛɛ fe̱yɛ a mo̱ŋ kyɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mfe̱ŋ ne̱ ase̱sɛ‑ɔ a ŋu fe̱yɛ ke̱tɔ timaa ko̱ e̱ ba a ke̱ bo̱ ba, ne̱ baa le̱e̱ ba fa fe̱yɛ nsaŋse̱ Yohanee e̱ gye̱ Kristoo ne̱ Wuribware̱ yɛ o suŋ a ɔ bo̱ kyo̱ŋwe̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ne̱ Yohanee a tɔwe̱ gywii bamo̱ pɛɛɛ fe̱yɛ, “Nkyu ne̱ n de mo̱ e̱ bɔ mo̱ne̱ asuu, amaa ɔko̱ saŋ ɔ ba na ɔ kyɔ mo̱, na mo̱ŋ fo̱ fe̱yɛ n lee mò̱ ase̱be̱ta gbaa na m fwe̱e̱ mò̱ ayaapapaa se̱. Mò̱ fe̱raa ɔ sa a Wuribware̱ a kufwiiŋe timaa‑o ywe̱e̱ mo̱ne̱ se̱ ne̱e̱ na mo̱nꞌ nya ke̱yaale̱ŋ fe̱yɛ de̱e̱kpa‑ɔ. Na ɔ ba kufwiiŋe timaa‑o bo̱ gyee mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","O de mò̱ kawo̱raa ne̱ ɔ ba a ɔ bo̱ kyaare̱ ayu na o swii waa mò̱ ke̱po̱re̱kye̱e̱‑rɔ‑ɔ. Na ŋkee ɔ kpane̱ afeŋfeŋtee‑o pɛɛɛ na ɔ kywɛɛ amo̱ de̱e̱kpa ne̱ ɔ maa duŋ‑o‑ro. Ane̱ŋ ne̱ o gyi ase̱sɛ pɛɛɛ ase̱ŋ‑ɔ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mfaanɛɛ ne̱ Yohanee a bo̱rɔ e̱kpa bwe̱e̱tɔ se̱ bo̱ tɔwe̱ ase̱ŋ timaa‑o gywii ase̱sɛ, ne̱ ɔɔ be̱e̱ tɔwe̱ fe̱yɛ ɔke̱maa nu mò̱ e̱ye̱e̱ na o kyurowi le̱e̱ e̱kpa bɔye̱ ne̱ ɔ gya se̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Ne̱ Yohanee e̱ tɔwe̱ o gywii Owure Hɛrɔd fe̱yɛ ɔɔ waa bɔye̱ fe̱yɛ mò̱ a kɔɔre̱ mò̱ tire mò̱ ka ne̱ ba te̱e̱ mò̱ ɛ Hɛrɔde̱ya‑ɔ waare̱e̱. Ne̱ ɔɔ po̱rɔ mò̱ e̱bɔye̱ bwe̱e̱tɔ ko̱ ne̱ ɔɔ be̱e̱ waa bo̱ tii si‑o si. Ne̱ owure a be̱e̱ waa bɔye̱ bo̱ tii si fe̱yɛ mò̱ a kra Yohanee tii. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Saŋ ne̱ Yohanee a bɔ ase̱sɛ bwe̱e̱tɔ asuu‑o, ne̱ ɔɔ bɔ Yeesuu asuu. Mò̱ a bɔ mò̱ asuu lo̱we̱, ne̱ Yeesuu e̱ ko̱re̱ ke̱bware̱ko̱re̱‑ɔ, ne̱ awo̱re̱‑rɔ a buŋŋi‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ne̱ Wuribware̱ a kufwiiŋe timaa‑o a ba bo̱ ywe̱e̱ Yeesuu si fe̱yɛ kuwurele̱pɔ‑ɔ. Ne̱ bo̱re̱ ko̱ a le̱e̱ so̱so̱ tɔwe̱ fe̱yɛ, “Fo̱ e̱ gye̱ mo̱ gyi timaa, ne̱ mo̱ e̱ kpa fo̱ ase̱ŋ bwe̱e̱tɔ, ne̱ mo̱ akatɔ a gyi fo̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Saŋ ne̱ Yeesuu a le̱e̱ mò̱ kusuŋ kaase̱‑ɔ na oo gyi nsu waa adusa. Ɔko̱ ne̱ ase̱sɛ e̱ fa fe̱yɛ ɔ gye̱ Yeesuu mò̱ se̱ ne̱e̱‑ɔ e̱ gye̱ Yo̱sɛf. Ne̱ Yo̱sɛf mɔ mò̱ se̱ e̱ gye̱ Heelii. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ne̱ Heelii mɔ mò̱ se̱ e̱ gye̱ Matat, ne̱ Matat mɔ mò̱ se̱ e̱ gye̱ Lewii, ne̱ Lewii mɔ mò̱ se̱ e̱ gye̱ Marikii, ne̱ Marikii mɔ mò̱ se̱ e̱ gye̱ Yanayi, ne̱ Yanayi mɔ mò̱ se̱ e̱ gye̱ Yo̱sɛf, ne̱ Yo̱sɛf mɔ mò̱ se̱ e̱ gye̱ Matatiyas. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ne̱ Matatiyas mɔ mò̱ se̱ e̱ gye̱ Amos, ne̱ Amos mɔ mò̱ se̱ e̱ gye̱ Nahum, ne̱ Nahum mɔ mò̱ se̱ e̱ gye̱ Isilii, ne̱ Isilii mɔ mò̱ se̱ e̱ gye̱ Nagayi. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ne̱ Nagayi mɔ mò̱ se̱ e̱ gye̱ Maat, ne̱ Maat mɔ mò̱ se̱ e̱ gye̱ Matatiyas, ne̱ Matatiyas mɔ mò̱ se̱ e̱ gye̱ Simiye, ne̱ Simiye mɔ mò̱ se̱ e̱ gye̱ Yo̱sɛk, ne̱ Yo̱sɛk mɔ mò̱ se̱ e̱ gye̱ Yodaa, ne̱ Yodaa mɔ mò̱ se̱ e̱ gye̱ Yohanaŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ne̱ Yohanaŋ mɔ mò̱ se̱ e̱ gye̱ Risa, ne̱ Risa mɔ mò̱ se̱ e̱ gye̱ Sirubabɛl, ne̱ Sirubabɛl mɔ mò̱ se̱ e̱ gye̱ Salatiyɛl, ne̱ Salatiyɛl mɔ mò̱ se̱ e̱ gye̱ Nirii. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ne̱ Nirii mɔ mò̱ se̱ e̱ gye̱ Marikii, ne̱ Marikii mɔ mò̱ se̱ e̱ gye̱ Adii, ne̱ Adii mɔ mò̱ se̱ e̱ gye̱ Kosam, ne̱ Kosam mɔ mò̱ se̱ e̱ gye̱ Ilimadam, ne̱ Ilimadam mɔ mò̱ se̱ e̱ gye̱ Iri. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ne̱ Iri mɔ mò̱ se̱ e̱ gye̱ Yosuwa, ne̱ Yosuwa mɔ mò̱ se̱ e̱ gye̱ Ileyesa, ne̱ Ileyesa mɔ mò̱ se̱ e̱ gye̱ Yorim, ne̱ Yorim mɔ mò̱ se̱ e̱ gye̱ Matat, ne̱ Matat mɔ mò̱ se̱ e̱ gye̱ Lewii. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ne̱ Lewii mɔ mò̱ se̱ e̱ gye̱ Simeyɔŋ, ne̱ Simeyɔŋ mɔ mò̱ se̱ e̱ gye̱ Yudaa, ne̱ Yudaa mɔ mò̱ se̱ e̱ gye̱ Yo̱sɛf, ne̱ Yo̱sɛf mɔ mò̱ se̱ e̱ gye̱ Yonam, ne̱ Yonam mɔ mò̱ se̱ e̱ gye̱ Iliyakim. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ne̱ Iliyakim mɔ mò̱ se̱ e̱ gye̱ Miliya, ne̱ Miliya mɔ mò̱ se̱ e̱ gye̱ Mɛna, ne̱ Mɛna mɔ mò̱ se̱ e̱ gye̱ Matata, ne̱ Matata mɔ mò̱ se̱ e̱ gye̱ Nataŋ, ne̱ Nataŋ mɔ mò̱ se̱ e̱ gye̱ Deefid. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ne̱ Deefid mɔ mò̱ se̱ e̱ gye̱ Yɛse̱e̱, ne̱ Yɛse̱e̱ mɔ mò̱ se̱ e̱ gye̱ Obid, ne̱ Obid mɔ mò̱ se̱ e̱ gye̱ Bowas, ne̱ Bowas mɔ mò̱ se̱ e̱ gye̱ Salamɔŋ, ne̱ Salamɔŋ mɔ mò̱ se̱ e̱ gye̱ Naasɔŋ, ne̱ Naasɔŋ mɔ mò̱ se̱ e̱ gye̱ Aminadabi. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ne̱ Aminadabi mɔ mò̱ se̱ e̱ gye̱ Adimiŋ, ne̱ Adimiŋ mɔ mò̱ se̱ e̱ gye̱ Aram, ne̱ Aram mɔ mò̱ se̱ e̱ gye̱ Hisirɔŋ, ne̱ Hisirɔŋ mɔ mò̱ se̱ e̱ gye̱ Pɛrɛs, ne̱ Pɛrɛs mɔ mò̱ se̱ e̱ gye̱ Yudaa, ne̱ Yudaa mɔ mò̱ se̱ e̱ gye̱ Yakubu. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ne̱ Yakubu mɔ mò̱ se̱ e̱ gye̱ Isak, ne̱ Isak mɔ mò̱ se̱ e̱ gye̱ Abraham, ne̱ Abraham mɔ mò̱ se̱ e̱ gye̱ Teeraa, ne̱ Teeraa mɔ mò̱ se̱ e̱ gye̱ Nahɔɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ne̱ Nahɔɔ mɔ mò̱ se̱ e̱ gye̱ Serug, ne̱ Serug mɔ mò̱ se̱ e̱ gye̱ Rewu, ne̱ Rewu mɔ mò̱ se̱ e̱ gye̱ Pɛlɛg, ne̱ Pɛlɛg mɔ mò̱ se̱ e̱ gye̱ Heebrii, ne̱ Heebrii mɔ mò̱ se̱ e̱ gye̱ Salaa, ne̱ Salaa mɔ mò̱ se̱ e̱ gye̱ Keenaŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ne̱ Keenaŋ mɔ mò̱ se̱ e̱ gye̱ Aafake̱sad, ne̱ Aafake̱sad mɔ mò̱ se̱ e̱ gye̱ Sɛm, ne̱ Sɛm mɔ mò̱ se̱ e̱ gye̱ Nowaa, ne̱ Nowaa mɔ mò̱ se̱ e̱ gye̱ Lamɛk, ne̱ Lamɛk mɔ mò̱ se̱ e̱ gye̱ Mɛtusala. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ne̱ Mɛtusala mɔ mò̱ se̱ e̱ gye̱ Inɔk, ne̱ Inɔk mɔ mò̱ se̱ e̱ gye̱ Yarid, ne̱ Yarid mɔ mò̱ se̱ e̱ gye̱ Mahalalɛl, ne̱ Mahalalɛl mɔ mò̱ se̱ e̱ gye̱ Keenaŋ, ne̱ Keenaŋ mɔ mò̱ se̱ e̱ gye̱ Inɔs. ");
INSERT INTO ncuNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ne̱ Inɔs mɔ mò̱ se̱ e̱ gye̱ Sɛt, ne̱ Sɛt mɔ mò̱ se̱ e̱ gye̱ Adam, ne̱ ŋkee Adam mɔ mò̱ se̱ e̱ gye̱ Wuribware̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Le̱e̱ saŋ ne̱ baa bɔ Yeesuu asuu‑o, Wuribware̱ a sa mò̱ kufwiiŋe timaa‑o bwe̱e̱tɔ. Mò̱ a kiŋŋi le̱e̱ Yo̱o̱daŋ bo̱ŋ‑nɔ‑ɔ, ne̱ Wuribware̱ a kufwiiŋe timaa‑o a sa ne̱ ɔɔ yɔ ɔ naa o muruwi‑ro kimukee‑ro ŋke aduna. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Mfe̱ŋ ne̱ Ɔbɔnsam a kyɔ mò̱‑rɔ ke̱e̱ fe̱yɛ ɔ nya mò̱ bo̱ waa e̱bɔye̱‑rɔ aaa. Ŋke de̱maŋte̱ mɔ pɛɛɛ Yeesuu mo̱ŋ gyi sɛye̱, amo̱se̱‑ɔ saŋ ne̱ ŋke amo̱ a kyo̱ŋ‑ɔ ako̱ŋ de mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ne̱ Ɔbɔnsam a tɔwe̱ gywii Yeesuu fe̱yɛ, “Fo̱ i nyi fe̱yɛ Wuribware̱ mò̱ gyi‑o e̱ gye̱ fo̱ kase̱ŋtiŋ, amo̱ fe̱raa sa a kibu mɔ buruwi bodobodoo sa fo̱ a fo̱ gyi.” ");
INSERT INTO ncuNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ne̱ Yeesuu a be̱ŋŋaa mò̱ fe̱yɛ, “Baa kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ, ‘Ateese wo̱re̱ maa sa se̱sɛ ŋkpa.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ne̱ Ɔbɔnsam a yaa mò̱ so̱so̱ to̱ŋ ko̱, puri amo̱‑rɔ ne̱ ɔɔ ba kaye̱‑rɔ e̱maŋ pɛɛɛ bo̱ kaapo̱ Yeesuu. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ne̱ ɔɔ tɔwe̱ gywii mò̱ fe̱yɛ, “Mo̱ e̱ taa kaye̱ mɔ‑rɔ e̱maŋ pɛɛɛ ke̱yaale̱ŋ na e̱mo̱ ke̱dabe̱ a n sa fo̱. Amo̱‑ɔ pɛɛɛ bo̱ mo̱ ke̱sare̱e̱‑rɔ ne̱e̱, amo̱se̱‑ɔ mo̱ e̱ taare̱ a n taa e̱mo̱ sa ɔke̱maa ne̱ mo̱ e̱ kpa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Amo̱se̱‑ɔ fo̱ ya kpuni aŋurii suŋ mo̱, e̱mo̱ pɛɛɛ mɔ i kii fo̱ lee.” ");
INSERT INTO ncuNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ne̱ Yeesuu a be̱ŋŋaa Ɔbɔnsam fe̱yɛ, “Baa be̱e̱ kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ, ‘Mo̱nꞌ suŋ mo̱ne̱ nyaŋpe̱ Wuribware̱ wo̱re̱ kpeŋ.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ne̱ Ɔbɔnsam a be̱e̱ yaa mò̱ Yɛro̱salɛm maŋ‑nɔ, ne̱ ɔɔ taa mò̱ yaa bo̱ ye̱ra Wuribware̱ suŋkpa‑ɔ katwe̱e̱‑rɔ, ne̱ ɔɔ tɔwe̱ gywii Yeesuu fe̱yɛ, “Fo̱ i nyi fe̱yɛ Wuribware̱ mò̱ gyi‑o e̱ gye̱ fo̱ kase̱ŋtiŋ, amo̱ fe̱raa fuwi ywe̱e̱‑rɔ a ŋ ke̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","A le̱e̱ fe̱yɛ baa be̱e̱ kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ, ‘Wuribware̱ e̱ sa a mò̱ mbɔɔ‑ɔ bo̱ kuŋ fo̱ nɛɛnɛɛ, na bo̱ so̱rɔ fo̱ bamo̱ asare̱e̱ se̱, na fo̱ ma nya da ke̱yaa kibu si.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ne̱ Yeesuu a be̱e̱ be̱ŋŋaa mò̱ fe̱yɛ, “Ne̱e̱ a bo̱ abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ, ‘Mo̱ne̱ ma kyɔ mo̱ne̱ nyaŋpe̱ Wuribware̱‑rɔ ke̱e̱,’ ɛ?” ");
INSERT INTO ncuNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Saŋ ne̱ Ɔbɔnsam‑ɔ a kyɔ mò̱‑rɔ ke̱e̱ e̱kpa amo̱ se̱ lo̱we̱‑ɔ, ne̱ ɔɔ yɔwe̱ mò̱ o gywii saŋ ko̱ be̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ne̱ Yeesuu a kiŋŋi yɔ Galile̱ya swe̱e̱re̱ se̱, na Wuribware̱ a kufwiiŋe timaa‑o ke̱yaale̱ŋ bo̱ mò̱ ase̱. Ne̱ ɔke̱maa ne̱ ɔ bo̱ ifuri amo̱ se̱‑ɔ a nu mò̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ne̱ ɔɔ kaapo̱ ase̱sɛ abware̱se̱ŋ mfe̱ŋ a ke̱bware̱ko̱re̱ akyaŋ‑ɔ‑rɔ, ne̱ ɔke̱maa a kyo̱rɔ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ne̱ Yeesuu a yɔ Nasarɛt maŋ‑nɔ mfe̱ŋ ne̱ baa be̱ra mò̱‑ɔ. Fe̱yɛ ane̱ŋ ne̱ ɔ kyɔ ɔ waa‑ɔ, kukyure kake a fo̱‑ɔ, ne̱ ɔɔ yɔ mfe̱ŋ a ke̱bware̱ko̱re̱kyaŋ‑ɔ‑rɔ. Ne̱ baa ko̱re̱ mò̱ fe̱yɛ ɔ kare̱ abware̱se̱ŋ wo̱re̱‑ɔ gywii bamo̱. Ne̱ ɔɔ ko̱so̱ a ɔ kare̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ne̱ abre̱sɛ‑ɔ ɔko̱ a taa abware̱se̱ŋ wo̱re̱‑ɔ ke̱be̱gya ko̱ ne̱ Wuribware̱ kyaamɛɛ Isaya a kyo̱rɛɛ‑ɔ sa Yeesuu. Ne̱ ɔɔ saŋŋe̱ wo̱re̱‑ɔ‑rɔ. Ne̱ oo ŋu to̱ŋ ko̱ ne̱ kyaamɛɛ‑ɔ a kyo̱rɛɛ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Wuribware̱ a kufwiiŋe‑o te mo̱ se̱, a le̱e̱ fe̱yɛ oo lee mo̱ suŋ ne̱e̱ fe̱yɛ ŋ ya tɔwe̱ mò̱ ase̱ŋ timaa gywii atiripo̱. Oo suŋ mo̱ fe̱yɛ m bo̱ tɔwe̱ gywii bamo̱ ne̱ baa tii bamo̱‑ɔ fe̱yɛ ba nya bamo̱ e̱ye̱e̱, na n tɔwe̱ gywii ate̱napo̱ fe̱yɛ bamo̱ akatɔ i buŋŋi. Oo suŋ mo̱ fe̱yɛ m bo̱ kya bamo̱ ne̱ baa waa bamo̱ bo̱rɔkraa‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Na n tɔwe̱ gywii ɔke̱maa fe̱yɛ saŋ a fo̱ fe̱yɛ Wuribware̱ e̱ ba a ɔ bo̱ mo̱rɔwe̱ mò̱ ase̱sɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yeesuu a kare̱ gywii bamo̱ lo̱we̱‑ɔ, ne̱ ɔɔ bɔɔ wo̱re̱‑ɔ, ne̱ ɔɔ laŋŋaa sa ɔbre̱sɛ ne̱ ɔɔ taa sa mò̱‑ɔ. Ne̱ ŋkee ɔɔ kye̱na ko̱re̱ bamo̱ se̱, ne̱ ɔɔ le̱e̱ ɔ kaapo̱ abware̱se̱ŋ‑ɔ. Ne̱ ɔke̱maa ne̱ ɔ bo̱ ke̱bware̱ko̱re̱kyaŋ‑ɔ‑rɔ‑ɔ e̱ de̱e̱re̱ mò̱ diŋŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “N gye̱ fe̱yɛ Isaya a tɔwe̱ mò̱ fɔŋfɔŋ kuŋu si ase̱ŋ ne̱e̱. Ɔ tɔwe̱ ne̱e̱ fe̱yɛ ɔko̱ e̱ ba a ɔ bo̱ ba na ɔ waa atɔ mɔ pɛɛɛ ne̱ mo̱ne̱ a nu mo̱ a kare̱‑ɔ. Ne̱ mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ ndɔɔ a kake mɔ ɔko̱ e̱ waa ane̱ŋ a atɔ mɔ mo̱ne̱ akatɔ‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ne̱ bamo̱ pɛɛɛ akatɔ a gyi mò̱ se̱, ne̱ e̱ye̱e̱ a kpe̱ŋ bamo̱ bo̱ le̱e̱ ane̱ŋ ne̱ o nyi se̱ŋsa e̱sa‑ɔ se̱. Ne̱ baa kuri gywii abɛɛ, “N gye̱ ane̱ aye̱po̱ Yo̱sɛf mò̱ gyi‑o ne̱e̱ e̱e̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ e̱ kɔɔre̱ a n gyi fe̱yɛ mo̱ne̱ e̱ da ke̱kpare̱ mɔ a mo̱nꞌ bo̱ kye mo̱ fe̱yɛ, ‘Ɔkyapo̱, kya fo̱ e̱ye̱e̱,’ na mo̱nꞌ tɔwe̱ gywii mo̱ fe̱yɛ ŋ waa atɔ ne̱ mo̱ne̱ a nu fe̱yɛ mo̱ a waa Kapaaniyum maŋ‑nɔ‑ɔ mo̱ fɔŋfɔŋ aye̱ mfe̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ ba bu Wuribware̱ kyaamɛɛ to̱ŋ ke̱maa, amɔ mò̱ fɔŋfɔŋ aye̱ wo̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Bɛɛɛ mo̱ e̱ ba aye̱ba aaa? Mo̱nꞌ nyiŋŋi Wuribware̱ kyaamɛɛ Iliya ke̱be̱e̱‑ɔ se̱, saŋ‑ɔ bware̱ a ye̱re̱ e̱wo̱re̱ nsu nsa na ke̱be̱gya, ne̱ ako̱ŋ a ba bwe̱e̱tɔ swe̱e̱re̱‑ɔ pɛɛɛ se̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Saŋ amo̱‑ɔ akpenlekye̱e̱ kyɔ bwe̱e̱tɔ Isireelii swe̱e̱re̱ se̱. Amaa Wuribware̱ mo̱ŋ suŋ Iliya fe̱yɛ ɔ kya bamo̱‑rɔ. Kpenlekye̱e̱ ko̱ŋko̱ ne̱ ɔ mo̱ŋ gye̱ Isireeliinyi ne̱ o te Sarafat maŋ‑nɔ‑ɔ ase̱ wo̱re̱ ne̱ Wuribware̱ a suŋ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ne̱ saŋ ne̱ Wuribware̱ kyaamɛɛ Ilisa be̱e̱ ɔ bo̱‑rɔ‑ɔ, ne̱ ase̱sɛ bwe̱e̱tɔ e̱ lɔ ke̱bwatɔ ane̱ Isireelii swe̱e̱re̱ se̱‑ɔ, Ilisa mo̱ŋ sa a ɔko̱ kpaare̱, amɔ ɔnyare̱ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Naamaŋ ne̱ ɔɔ le̱e̱ Siriya swe̱e̱re̱ se̱‑ɔ wo̱re̱ kpeŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Amo̱ fe̱raa bamo̱ ne̱ bo̱ bo̱ ke̱bware̱ko̱re̱kyaŋ‑ɔ‑rɔ‑ɔ a nu ane̱ŋ ne̱ ɔ tɔwe̱‑ɔ, ne̱ bamo̱ iduŋ a fwii. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ne̱ baa ko̱so̱ gyiiri mò̱ le̱e̱ bamo̱ maŋ‑ɔ‑rɔ. Maŋ‑ɔ mɔ dɔŋ ke̱be̱e̱ ko̱ se̱. Amɔ bo̱ yɛ ba twe̱e̱ mò̱ a bo̱ bo̱ waa ke̱be̱e̱‑ɔ kaase̱ a ke̱maŋtaŋ‑ɔ‑rɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Amaa Yeesuu a bo̱rɔ bamo̱ pɛɛɛ mbo̱ŋtɔ‑rɔ kyo̱ŋ ne̱e̱, me̱raa mò̱ kpa se̱ o yii yɔwe̱ bamo̱ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ne̱ Yeesuu a yɔ Kapaaniyum maŋ‑nɔ Galile̱ya swe̱e̱re̱ se̱. Kukyure kake‑o, ne̱ ɔɔ ya kaapo̱ abware̱se̱ŋ mfe̱ŋ a ke̱bware̱ko̱re̱kyaŋ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ne̱ ase̱sɛ ne̱ baa nu ane̱ŋ ne̱ ɔɔ kaapo̱‑ɔ e̱ye̱e̱ a kpe̱ŋ bamo̱, a le̱e̱ fe̱yɛ ɔɔ kaapo̱ ne̱e̱ fe̱yɛ mò̱ a gye̱ Wuribware̱ mbraa ɔsapo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Amɔ saŋ amo̱ ɔnyare̱ ko̱ bo̱ ke̱bware̱ko̱re̱kyaŋ‑ɔ‑rɔ mfe̱ŋ, ne̱ ibrisi te mò̱ se̱. Ne̱ ɔnyare̱‑ɔ a faa‑rɔ keŋkeŋ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Aa! Yeesuu Nasarɛte̱nyi, nte̱tɔ ne̱ fo̱ e̱ kpa ane̱ ase̱ mfe̱e̱? Fo̱ a ba a fo̱ bo̱ mɔɔ ane̱ ne̱e̱ e̱e̱e̱? Ŋ nyi se̱sɛ ne̱ fo̱ gye̱‑ɔ. Fo̱ e̱ gye̱ ke̱yaafɔre̱ timaa ne̱ Wuribware̱ a lee suŋ bo̱ kyo̱ŋwe̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ne̱ Yeesuu a faa ibrisi‑o si fe̱yɛ, “Laatɔ na fo̱ ko̱so̱ ɔnyare̱ amo̱ se̱.” Ne̱ ibrisi amo̱ a twe̱e̱ ɔnyare̱‑ɔ bo̱ da bamo̱ akatɔ‑rɔ mfe̱ŋ, ne̱ e̱ ya ko̱so̱ mò̱ se̱, na e̱ mo̱ŋ waa mò̱ sɛye̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ne̱ ase̱sɛ‑ɔ pɛɛɛ e̱ye̱e̱ a kpe̱ŋ bamo̱, ne̱ bo̱ yɛ, “Nte̱tɔ ase̱ŋ ne̱e̱, ne̱ ɔ sa se̱ŋsa ane̱ŋ‑ɔ ne̱e̱? Ɔnyare̱ amo̱ de ibrisi pɛɛɛ mɔ se̱ ke̱yaale̱ŋ, hare̱e̱ mò̱ ya tɔwe̱ ase̱ŋ, na e̱ ko̱so̱ se̱sɛ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ne̱ Yeesuu ke̱nyare̱ a yɔ mfe̱ŋ a ifuri‑o pɛɛɛ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ne̱ Yeesuu a le̱e̱ ke̱bware̱ko̱re̱kyaŋ‑ɔ‑rɔ yɔ Simɔŋ lɔŋ‑nɔ. Simɔŋ mɔ gye̱ bamo̱ ne̱ bo̱ gya Yeesuu si‑o ɔko̱ ne̱e̱. Saŋ amo̱ na Simɔŋ mò̱ saa kye̱e̱sɛ e̱ lɔ fekyu, ne̱ mò̱ kayo̱wɔre̱ a be̱re̱ gya bwe̱e̱tɔ. Ne̱ baa ko̱re̱ Yeesuu fe̱yɛ ɔ kya mò̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ne̱ Yeesuu a ya ye̱re̱ mfe̱ŋ ne̱ ɔkye̱e̱ amo̱ da ɔ lɔ‑ɔ. Ne̱ ɔɔ sa kanɔ fe̱yɛ fekyu‑o yɔwe̱ ɔkye̱e̱‑ɔ. Ne̱ ɔɔ kpaare̱, ne̱ ɔɔ ko̱so̱ puri amo̱‑rɔ waa ateese sa bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Saŋ ne̱ kyɔwe̱ e̱ twɛɛ‑ɔ, ne̱ ase̱sɛ a baa bamo̱ anyipo̱ ne̱ ba lɔ alɔgyi alɔgyi‑o Yeesuu ase̱, ne̱ ɔɔ ba mò̱ asare̱e̱ bo̱ dɔŋŋɔ bamo̱ se̱ ako̱ ako̱, ne̱ bamo̱ ɔke̱maa a kpaare̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ne̱ Yeesuu a be̱e̱ gya ibrisi bo̱ ko̱so̱ ase̱sɛ bwe̱e̱tɔ se̱, na ibrisi‑o e̱ fɛɛ‑rɔ e̱e̱ tɔwe̱ fe̱yɛ, “Wuribware̱ mò̱ gyi‑o e̱ gye̱ fo̱.” Amaa ɔ mo̱ŋ sa a e̱ be̱e̱ sa se̱ŋsa ko̱, bo̱ le̱e̱ fe̱yɛ i nyi dame̱naŋsɛ fe̱yɛ Kristoo ne̱ Wuribware̱ a suŋ bo̱ kyo̱ŋwe̱‑ɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ke̱mo̱ kaye̱ ŋke gye̱gyaye̱ kese‑ro, ne̱ Yeesuu a le̱e̱ maŋ‑ɔ‑rɔ yɔ kɛɛ se̱ mfe̱ŋ ne̱ ɔko̱ mo̱ŋ bo̱, ne̱ a du diŋŋ‑o. Amo̱ fe̱raa ne̱ ase̱sɛ a le̱e̱ ba buwi ba kpa mò̱. Bamo̱ a ya ŋu mò̱‑ɔ, ŋkee bo̱ ma lɛɛ kpa fe̱yɛ ɔ le̱e̱ bamo̱ ase̱ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Amaa ɔɔ tɔwe̱ gywii bamo̱ ne̱e̱ fe̱yɛ, “A tiri fe̱yɛ n tɔwe̱ Wuribware̱ a kuwure‑o‑ro a ase̱ŋ timaa‑o gywii e̱maŋ ko̱ gbaa se̱ awuye, bo̱ le̱e̱ fe̱yɛ ke̱tɔ ne̱ Wuribware̱ a suŋ mo̱ a m bo̱ waa‑ɔ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Amo̱se̱‑ɔ ne̱ ɔɔ me̱raa se̱ ɔ naa ɔ tɔwe̱ abware̱se̱ŋ Yudaa awuye e̱maŋ se̱ ke̱bware̱ko̱re̱ akyaŋ‑nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ŋke ŋko̱ Yeesuu a ye̱re̱ ke̱pare̱ dabe̱ ko̱ ne̱ ba te̱e̱ ke̱mo̱ ɛ Ginɛsarɛt (bɛɛɛ Galile̱ya)‑ɔ kɛɛ, ne̱ ŋkee ase̱sɛ i neŋŋi ba yɔ akatɔ‑rɔ na bo̱ nya ya nu mò̱ abware̱se̱ŋ ko̱tɔwe̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ne̱ Yeesuu a ŋu baa gyiiri e̱ko̱re̱e̱ e̱nyɔ bo̱ daŋ ke̱pare̱‑ɔ kɛɛ. Ne̱ ŋkiŋgyi akrapo̱‑ɔ a yɔ a bo̱ ya fwe̱e̱ bamo̱ asawu si. ");
INSERT INTO ncuNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ne̱ oo lwee e̱ko̱re̱e̱‑ɔ ɔko̱‑rɔ. Simɔŋ ne̱ Yeesuu a kya mò̱ saa kye̱e̱sɛ fekyu‑o lee ne̱e̱. Ne̱ ɔɔ ko̱re̱ Simɔŋ fe̱yɛ o neŋ ko̱re̱e̱‑ɔ bo̱ dɔŋŋɔ nkyu si kafwe̱e̱, ne̱ Yeesuu a kye̱na ko̱re̱e̱‑ɔ‑rɔ kaapo̱ ase̱sɛ abware̱se̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yeesuu a tɔwe̱ abware̱se̱ŋ lo̱we̱‑ɔ, ne̱ ɔɔ tɔwe̱ gywii Simɔŋ fe̱yɛ, “Mo̱nꞌ neŋ bo̱ dɔŋŋɔ nkyu si yaa ke̱bo̱keŋ‑no, na mo̱nꞌ twe̱e̱ asawu‑o waa‑rɔ kra ŋkiŋgyi.” ");
INSERT INTO ncuNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ne̱ Simɔŋ yɛ, “Mo̱ nyaŋpe̱, ane̱ a waa kusuŋ kanye‑o pɛɛɛ, ane̱ mɔ ane̱ mo̱ŋ kra sɛye̱. Amaa fo̱ e̱ yɛ ane̱ŋ fe̱raa, mo̱ e̱ twe̱e̱ asawu a ŋ waa‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ne̱ baa twe̱e̱ asawu‑o waa‑rɔ. Ne̱ baa kra ŋkiŋgyi bwe̱e̱tɔ, hare̱e̱ asawu‑o e̱ kpa a a kyaye̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Amo̱se̱‑ɔ ne̱ baa ya bamo̱ ke̱sare̱e̱ fe̱yɛ bamo̱ ko̱so̱bɛɛ‑ana ne̱ bamo̱ gbaa bo̱ bo̱ bamo̱ ko̱re̱e̱‑rɔ‑ɔ bo̱ kya bamo̱‑rɔ. Ne̱ baa bo̱ kya bamo̱‑rɔ, ne̱ baa lee ŋkiŋgyi‑o bo̱ bo̱rɔ e̱ko̱re̱e̱ e̱nyɔ‑ɔ, hare̱e̱ e̱ko̱re̱e̱‑ɔ a tɔwe̱ se̱ e̱ kpa a e̱ gya nkyu. ");
INSERT INTO ncuNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Ne̱ e̱ye̱e̱ a kpe̱ŋ Simɔŋ na bamo̱ ne̱ mò̱ aa bamo̱ bo̱ mò̱ ko̱re̱e̱‑ɔ‑rɔ bo̱ le̱e̱ ane̱ŋ ne̱ baa kra ŋkiŋgyi bwe̱e̱tɔ‑ɔ se̱. Ane̱ŋ dɛɛ ne̱ Sibidii mò̱ gyi‑ana, Yakubu na Yohanee ne̱ bo̱ gye̱ Simɔŋ mò̱ ko̱so̱bɛɛ‑ana amo̱‑ɔ e̱ye̱e̱ a kpe̱ŋ bamo̱. Simɔŋ (ne̱ Yeesuu e̱ ba a ɔ bo̱ te̱e̱ mò̱ ɛ Peetroo‑o) a ŋu mfaanɛɛ‑ɔ, ne̱ oo kpuni aŋurii Yeesuu akatɔ‑rɔ, ne̱ ɔɔ tɔwe̱ fe̱yɛ, “Mo̱ nyaŋpe̱, nare̱ le̱e̱ mo̱ ase̱, bo̱ le̱e̱ fe̱yɛ n gye̱ e̱bɔye̱ ɔwaapo̱ ne̱e̱.” Ne̱ Yeesuu a tɔwe̱ gywii Simɔŋ fe̱yɛ, “Fo̱ ma sa a fo̱ duŋ te̱ŋ fo̱. Le̱e̱ ndɔɔ bo̱ yɔ fo̱ maa lɛɛ kra ŋkiŋgyi. Amaa ase̱sɛ ne̱ fo̱ e̱ de̱e̱ buwi kpa na fo̱ baa bamo̱ mo̱ ase̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Mfe̱ŋ ne̱ baa gyiiri bamo̱ e̱ko̱re̱e̱‑ɔ bo̱ be̱ya ke̱pare̱‑ɔ kideŋbe si, ne̱ baa yɔwe̱ ke̱tɔ ke̱maa, ne̱ baa gya Yeesuu si. ");
INSERT INTO ncuNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Saŋ ko̱ Yeesuu a yɔ ɔ bo̱ maŋ ko̱‑rɔ, na bwatɔpo̱ nyare̱ ko̱ mɔ bo̱ mfe̱ŋ. Mò̱ ke̱de̱ŋ ŋu Yeesuu‑o, ne̱ ɔɔ yɔ mò̱ ase̱, ne̱ oo kpuni aŋurii ko̱re̱ Yeesuu tɔwe̱ fe̱yɛ, “Mo̱ nyaŋpe̱, fo̱ e̱ kpa, fo̱ e̱ taare̱ a fo̱ kya mo̱ ko̱lɔ mɔ na ŋ nya lwee ase̱sɛ‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ne̱ Yeesuu a be̱ŋŋaa mò̱ fe̱yɛ, “Mo̱ e̱ kpa.” Ne̱ Yeesuu a ba ke̱sare̱e̱ bo̱ dɔŋŋɔ ɔlɔpo̱‑ɔ se̱, ne̱ ɔ yɛ, “Mbe̱yɔmɔ fe̱raa fo̱ e̱ taare̱ a fo̱ lwee ase̱sɛ‑rɔ, a le̱e̱ fe̱yɛ fo̱ a kpaare̱.” Mfe̱ŋ dɛɛ ne̱ ɔnyare̱ amo̱ a ke̱bwatɔ‑ɔ a lo̱we̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ne̱ Yeesuu a yii mò̱ se̱ fe̱yɛ, “De̱ŋ bo̱rɔ kpa kyɛye̱ se̱ yɔ Wuribware̱ alɔŋŋɔpo̱‑ɔ ɔko̱ ase̱ na ɔ de̱e̱re̱ fo̱, na fo̱ bɔ alɔŋŋɔtɔ ne̱ Mosis a tɔwe̱ ɛ mò̱ ne̱ ɔɔ lɔ ko̱lɔ mɔ, ne̱ ɔɔ kpaare̱‑ɔ bɔ, na ɔke̱maa ŋu fe̱yɛ ane̱ŋ a ko̱lɔ‑ɔ mo̱ŋ lɛɛ ki te mò̱ se̱‑ɔ. Fo̱ a maa se̱ fo̱ e̱ yɔ, fo̱ ma kaŋ ye̱re̱ kpa‑rɔ tɔwe̱ ke̱tɔ ne̱ mo̱ a waa sa fo̱‑ɔ gywii ɔko̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Amo̱ gbaa ne̱ Yeesuu ke̱nyare̱ a yɔ e̱maŋ se̱‑ɔ ne̱e̱. Ne̱ ase̱sɛ biribiri a ba a bo̱ bo̱ nu ase̱ŋ ne̱ ɔ tɔwe̱‑ɔ, na ɔ kya bamo̱ alɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Amaa mò̱ ya nya kpa ane̱ŋ ne̱ ɔ taare̱‑ɔ, ɔ yɔ ɔ naa mò̱ wo̱re̱ mfe̱ŋ ne̱ a du diŋŋ‑o na ɔ nya ko̱re̱ ke̱bware̱ko̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kake ŋko̱, ne̱ Yeesuu e̱ kaapo̱ abware̱se̱ŋ lɔŋ ko̱‑rɔ, ne̱ Farisii awuye ko̱ na Wuribware̱ mbraa akaapo̱po̱ ko̱ a ba bo̱ te Yeesuu ase̱ mfe̱ŋ. Bamo̱ bo̱ko̱ a le̱e̱ maŋ ke̱maa ne̱ ɔ bo̱ Galile̱ya swe̱e̱re̱ se̱‑ɔ. Ne̱ bo̱ko̱ mɔ a le̱e̱ Yude̱ya swe̱e̱re̱ se̱ na Yɛro̱salɛm maŋ‑nɔ. Saŋ amo̱‑ɔ na ɔ be̱e̱ o de Wuribware̱ a ke̱yaale̱ŋ‑ɔ ɔ kya alɔpo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ne̱ anyare̱ ko̱ a so̱rɔ ke̱gyabɔɔ ko̱ kraŋ se̱ baa, ne̱ baa le̱ŋ bamo̱ e̱ye̱e̱ na bo̱ taa mò̱ lwee lɔŋ‑ɔ‑rɔ yaa bo̱ be̱ya Yeesuu akatɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Amaa bo̱ le̱e̱ ane̱ŋ ne̱ ase̱sɛ kyɔ bwe̱e̱tɔ‑ɔ se̱‑ɔ, bo̱ mo̱ŋ taare̱ nya kpa na bo̱ taa mò̱ lweero. Amo̱se̱‑ɔ ne̱ baa so̱rɔ mò̱ bo̱ de̱e̱ yɔ ke̱kyaŋ ne̱ Yeesuu bo̱ ke̱mo̱‑rɔ‑ɔ so̱so̱. Bamo̱ a tɛɛ ke̱mo̱ so̱so̱‑ɔ se̱‑ɔ, ne̱ baa tuwi bɔ so̱so̱. Mfe̱ŋ ne̱ baa taa mò̱ bo̱ dɔŋŋɔ kraŋ se̱, ba ife bo̱ da‑rɔ, ne̱ baa kra ife‑o‑ro yɔwe̱ mò̱‑rɔ kafwe̱e̱ kafwe̱e̱ bo̱ kyo̱ŋwe̱ ke̱kyaŋ‑ɔ‑rɔ yaa bo̱ be̱ya Yeesuu akatɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ane̱ŋ ne̱ baa pee akatɔ baa ke̱gyabɔɔ amo̱‑ɔ se̱‑ɔ, Yeesuu a ŋu fe̱yɛ baa kɔɔre̱ mò̱ gyi bwe̱e̱tɔ. Amo̱se̱‑ɔ ne̱ ɔɔ tɔwe̱ gywii ke̱gyabɔɔ‑ɔ fe̱yɛ, “Mo̱ nyare̱, mo̱ a taa fo̱ e̱bɔye̱‑ɔ bo̱ ke fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Amo̱ fe̱raa, ne̱ Wuribware̱ mbraa akaapo̱po̱‑ɔ na Farisii awuye‑o a le̱e̱ ba ŋwiini ba gywii abɛɛ fe̱yɛ, “Nsɛ e̱ gye̱ ɔnyare̱ mɔ ne̱ mò̱‑ɔ mò̱ e̱ sa se̱ŋsa ane̱ŋ fe̱yɛ mò̱ a gye̱ Wuribware̱‑ɔ? Ɔnyare̱ mɔ a tɔwe̱ abuse̱ŋse̱ŋ. Ne̱e̱ Wuribware̱ wo̱re̱ e̱ gye̱ ne̱ ɔ taare̱ a ɔ taa e̱bɔye̱ bo̱ ke ase̱sɛ ɛ?” ");
INSERT INTO ncuNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mfe̱ŋ ne̱ Yeesuu a kyɔ ŋu bamo̱ mfɛɛre̱, ne̱ oo bise bamo̱ fe̱yɛ, “Nte̱tɔ i de mo̱ne̱? ");
INSERT INTO ncuNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ke̱mo̱‑ɔ ke̱mo̱ e̱ bo̱ tɔwe̱ lɔ, ‘Mo̱ a taa fo̱ e̱bɔye̱ bo̱ ke fo̱’ bɛɛɛ ‘Ko̱so̱ nare̱’? ");
INSERT INTO ncuNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","To, mo̱ e̱ kaapo̱ mo̱ne̱ fe̱yɛ mo̱, dimaadi mò̱ gyi‑o, de ke̱yaale̱ŋ swe̱e̱re̱ mɔ se̱ na n taare̱ taa ɔke̱maa e̱bɔye̱ bo̱ ke mò̱.” Ne̱ ɔɔ tɔwe̱ gywii ke̱gyabɔɔ‑ɔ fe̱yɛ, “Ke̱e̱ ɛ, ko̱so̱ taa fo̱ kraŋ a fo̱ nare̱ yɔ pe̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Puri amo̱‑rɔ ne̱ ke̱gyabɔɔ amo̱ a ko̱so̱ lamaŋ amo̱ akatɔ‑rɔ mfe̱ŋ bɔɔ mò̱ kraŋ, ne̱ ɔɔ nare̱ mò̱ ayaa anyɔ se̱ o yii pe̱, na ɔ kyo̱rɔ Wuribware̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ne̱ bamo̱ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ pɛɛɛ mɔ e̱ye̱e̱ a kpe̱ŋ bamo̱. Ne̱ kufu a nya bamo̱, ne̱ baa kyo̱rɔ Wuribware̱ na ba tɔwe̱ fe̱yɛ, “Ase̱ŋ dabe̱ ko̱ ne̱ ane̱ a ŋu ndɔɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Amo̱ kamɛɛ‑rɔ, ne̱ Yeesuu a le̱e̱ ya ŋu leŋpoo ɔkɔɔre̱po̱ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Lewii‑o (ne̱ bo̱ be̱e̱ ba te̱e̱ mò̱ ɛ Matiyo‑o) na o te mò̱ leŋpoo kɔɔre̱kpa. Ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Ko̱so̱ gya mo̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Mfe̱ŋ ne̱ Lewii a ko̱so̱ yɔwe̱ ke̱tɔ ke̱maa, ne̱ ɔɔ gya Yeesuu si. ");
INSERT INTO ncuNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ne̱ Lewii a ya waa ateese mò̱ aye̱ sa Yeesuu a o gyi. Ne̱ ɔɔ be̱e̱ nyiŋŋi leŋpoo akɔɔre̱po̱ bwe̱e̱tɔ na ase̱sɛ ko̱ fe̱yɛ bo̱ ba na bo̱ gyi ateese amo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Amo̱ fe̱raa ne̱ Farisii awuye‑o na Wuribware̱ mbraa akaapo̱po̱ ko̱ ne̱ bo̱ tii bamo̱ se̱ bo̱ gya bamo̱ ananatɔ se̱‑ɔ a le̱e̱ ba tɛɛ ba gywii Yeesuu agyase̱po̱‑ɔ, ne̱ bo̱ yɛ, “Nte̱tɔ se̱ ne̱ mo̱ne̱ aa leŋpoo akɔɔre̱po̱ na e̱bɔye̱ awaapo̱ i gyi abɛɛ ase̱?” ");
INSERT INTO ncuNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ne̱ Yeesuu a nya me̱naŋ be̱ŋŋaa bamo̱ fe̱yɛ, “Ɔko̱ ne̱ ɔ lɔ‑ɔ ne̱ ba sa kadwii. N gye̱ ɔko̱ ne̱ o de alaŋfiya‑o. ");
INSERT INTO ncuNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Amo̱se̱‑ɔ n gye̱ bamo̱ ne̱ bo̱ mo̱ŋ gye̱ e̱bɔye̱ awaapo̱‑ɔ se̱ ne̱ mo̱ a ba, amaa bamo̱ ne̱ bo̱ gye̱ e̱bɔye̱ awaapo̱‑ɔ se̱ ne̱ mo̱ a ba, na m bo̱ tɔwe̱ gywii bamo̱ fe̱yɛ bo̱ nu bamo̱ e̱ye̱e̱ kiŋŋi le̱e̱ bamo̱ e̱bɔye̱‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ne̱ ase̱sɛ ko̱ a bo̱ tɔwe̱ gywii Yeesuu fe̱yɛ, “Yohanee a agyase̱po̱‑ɔ na Farisii awuye a bo̱mo̱‑ɔ e̱ kra ako̱ŋ iluwi bwe̱e̱tɔ na ba ko̱re̱ ke̱bware̱ko̱re̱, amaa fo̱ fe̱raa fo̱ bo̱mo̱‑ɔ i gyi ba nuu saŋ ke̱maa.” ");
INSERT INTO ncuNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “Mo̱ne̱ e̱ fa fe̱yɛ saŋ ne̱ ɔko̱ e̱ kpa a ɔ waare̱e̱‑ɔ, ɔko̱fɔ mò̱ kuri mò̱ nyare̱‑ana e̱ kye̱na ako̱ŋ na ɔ bo̱‑rɔ aaa? Mo̱ŋ kɔɔre̱ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","N du ne̱e̱ fe̱yɛ ɔko̱fɔ mò̱ kuri‑o, ne̱ mo̱ agyase̱po̱‑ɔ mɔ du ne̱e̱ fe̱yɛ ɔko̱fɔ mò̱ kuri mò̱ nyare̱‑ana‑ɔ. Ŋke ŋko̱ e̱ ba ne̱ ba kra ɔko̱fɔ mò̱ kuri a bo̱ le̱e̱ bamo̱ ase̱, na ŋkee bo̱ kra ako̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ne̱ Yeesuu a be̱e̱ tɔwe̱ ke̱kpare̱ mɔ gywii bamo̱ fe̱yɛ, “Ɔko̱ maa kyaŋ waagya po̱pwɛɛ na ɔ bo̱ taa waagya de̱daa‑rɔ. Ɔko̱ ne̱ mò̱ ya waa ane̱ŋ, ɔ nye̱ra waagya po̱pwɛɛ‑ɔ, na mfe̱ŋ ne̱ ɔɔ ba waagya‑ɔ bo̱ taa‑rɔ‑ɔ na waagya de̱daa‑ɔ maa waa ko̱ŋko̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ane̱ŋ dɛɛ ne̱ mo̱ne̱ nyi fe̱yɛ bo̱ de nta ba waa praŋto̱wa ne̱ ba ba kabo̱ wo̱re̱ bo̱ waa‑ɔ‑rɔ. Bo̱ de nta po̱pwɛɛ ba waa praŋto̱wa po̱pwɛɛ‑rɔ. Nta po̱pwɛɛ ya lwee praŋto̱wa de̱daa‑rɔ, nta‑ɔ i fwii na praŋto̱wa‑ɔ bwee nye̱ra na nta‑ɔ twiiri we̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Amo̱se̱‑ɔ, bo̱ de nta po̱pwɛɛ ba waa praŋto̱wa po̱pwɛɛ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ne̱ ɔko̱ mɔ ya nuu nta de̱daa, ɔ maa lɛɛ kpa mpo̱pwɛɛ kunuu. Ɔ yɛ nde̱daa‑ɔ bɔ mpo̱pwɛɛ‑ɔ. Amo̱se̱ se̱‑ɔ mo̱ agyase̱po̱‑ɔ maa kra ako̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kukyure kake ko̱, Yeesuu mò̱ aa mò̱ agyase̱po̱ a naa ba kyo̱ŋ abwaye adɔɔ ko̱‑rɔ‑ɔ, ne̱ mò̱ agyase̱po̱‑ɔ a le̱e̱ ba gyɛɛ abwaye ne̱ ba kyo̱ŋ amo̱‑rɔ‑ɔ, ne̱ baa fee ba wo̱, a le̱e̱ fe̱yɛ ako̱ŋ de bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ne̱ Farisii awuye ko̱ a ŋu ane̱ŋ ne̱ ba waa‑ɔ, ne̱ baa bise bamo̱ fe̱yɛ, “Nte̱tɔ se̱ ne̱ mo̱ne̱ e̱ gyɛɛ abwaye‑o? Mo̱ne̱ mo̱ŋ nyi fe̱yɛ ke̱tɔ ne̱ mo̱ne̱ e̱ waa‑ɔ gye̱ kusuŋ ne̱e̱ e̱e̱e̱? Ne̱ a kye Wuribware̱ mbraa fe̱yɛ ɔko̱ a waa kusuŋ ko̱ kukyure kake.” ");
INSERT INTO ncuNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “Mo̱ne̱ mo̱ŋ tɛɛ kare̱ abware̱se̱ŋ wo̱re̱‑ɔ ŋu ke̱tɔ ne̱ ane̱ ɔde̱daapo̱ Deefid a waa saŋ ne̱ ako̱ŋ de mò̱ aa mò̱ anare̱bɛɛpo̱‑ɔ ɔɔɔ? ");
INSERT INTO ncuNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ke̱tɔ bo̱ abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ Deefid a lwee Wuribware̱ suŋkpa, ne̱ baa sa mò̱ bodobodoo akuri ne̱ baa bo̱ lɔŋŋɔ Wuribware̱‑ɔ, ne̱ ɔɔ saŋ e̱ko̱ sa mò̱ anare̱bɛɛpo̱‑ɔ. Na a mo̱ŋ gye̱ mbraa kikye aaa? Bo̱ le̱e̱ fe̱yɛ ane̱ mbraa‑ɔ yɛ Wuribware̱ alɔŋŋɔpo̱ wo̱re̱ e̱ gye̱ ne̱ bo̱ de kpa fe̱yɛ bo̱ gyi ane̱ŋ a bodobodoo‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ne̱ Yeesuu a tɔwe̱ bo̱ gye̱ kɛɛ fe̱yɛ, “Amo̱se̱‑ɔ mo̱, dimaadi mò̱ gyi‑o, de kukyure kake‑o gbaa e̱le̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kukyure kake ko̱ be̱e̱ ne̱ Yeesuu a be̱e̱ yɔ ke̱bware̱ko̱re̱kyaŋ‑nɔ ya kaapo̱ abware̱se̱ŋ. Saŋ amo̱‑ɔ ɔnyare̱ ko̱ mɔ bo̱ mfe̱ŋ na mò̱ kigyisesare̱e̱ a wu. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Amɔ Farisii awuye na Wuribware̱ mbraa akaapo̱po̱ ko̱ mɔ bo̱ mfe̱ŋ, ne̱ ba kpa a bo̱ nya po̱rɔ Yeesuu fe̱yɛ ɔ waa bɔye̱. Amo̱se̱‑ɔ bamo̱ akatɔ a pee ba de̱e̱re̱ a bo̱ ke̱e̱ fe̱yɛ Yeesuu e̱ kya ke̱sare̱e̱ wusɛ wuye amo̱ kukyure kake amo̱ aaa, a le̱e̱ fe̱yɛ bo̱ maa waa kusuŋ ke̱maa kake amo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Amaa Yeesuu a kyɔ ŋu bamo̱ mfɛɛre̱‑ɔ, ne̱ ɔɔ tɔwe̱ gywii ke̱sare̱e̱ wusɛ wuye amo̱ ɛ, “Ko̱so̱ ba akatɔ‑rɔ mfe̱e̱.” Ne̱ ɔnyare̱‑ɔ a ko̱so̱ ye̱re̱ ba akatɔ‑rɔ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ne̱ Yeesuu a bise bamo̱ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ fe̱yɛ, “E̱me̱ne̱ ne̱ Wuribware̱ mbraa‑ɔ a sa kpa fe̱yɛ ane̱ waa kukyure kake? Mbraa‑ɔ yɛ ane̱ waa kitimaa ne̱e̱ e̱e̱e̱, bɛɛɛ ke̱bɔye̱ aaa? Ŋ yɛ, ane̱ mo̱rɔwe̱ se̱sɛ ne̱e̱, bɛɛɛ ane̱ mɔɔ se̱sɛ ne̱e̱ e̱e̱e̱? Mo̱nꞌ tɔwe̱ gywii mo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ne̱ ɔɔ de̱e̱re̱ bamo̱ pɛɛɛ kpo̱ne̱. Ne̱ ŋkee ɔɔ tɔwe̱ gywii ɔnyare̱‑ɔ fe̱yɛ, “Teyi fo̱ ke̱sare̱e̱‑ɔ‑rɔ.” Ne̱ ɔnyare̱ amo̱ a teyi‑ro, ne̱ mò̱ ke̱sare̱e̱ amo̱ a kpaare̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Bo̱ le̱e̱ mfaanɛɛ se̱‑ɔ ne̱ Farisii awuye‑o na Wuribware̱ mbraa akaapo̱po̱‑ɔ iduŋ a fwii bwe̱e̱tɔ Yeesuu si, ne̱ baa le̱e̱ ba fa ke̱tɔ ne̱ ba waa mò̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ke̱tɔ mo̱ŋ kyee ne̱ Yeesuu a yɔ ke̱be̱e̱ ko̱ se̱ ya ko̱re̱ ke̱bware̱ko̱re̱. Ne̱ oo sii mfe̱ŋ kanye amo̱ pɛɛɛ ɔ ko̱re̱ ke̱bware̱ko̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kaye̱ a ke‑o, ne̱ ɔɔ te̱e̱ mò̱ agyase̱po̱‑ɔ baa mò̱ ase̱, ne̱ oo lee bamo̱‑rɔ kudu anyɔ fe̱yɛ bo̱ waa mò̱ ayaa‑rɔ aye̱re̱po̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Bamo̱ e̱ gye̱ Simɔŋ (Ɔɔ be̱e̱ sa mò̱ ke̱ŋasɛnyare̱ ne̱e̱ fe̱yɛ Peetroo) na mò̱ tire Andruu, na Yakubu na Yohanee na Filipo na Bar‑Tolomiyu, ");
INSERT INTO ncuNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","na ŋkee Matiyo na Tomas na Alafiyus mò̱ gyi Yakubu, na Simɔŋ ne̱ ba te̱e̱ mò̱ ɛ Sɛlɔt (kaase̱ e̱ kaapo̱ ne̱e̱ fe̱yɛ ɔmaŋkpapo̱‑ɔ), ");
INSERT INTO ncuNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","na Yakubu mò̱ gyi Yudas, na Yudas ko̱ ne̱ ba te̱e̱ mò̱ ɛ Kariyotinyi, ne̱ ɔ ba a ɔ bo̱ gyi Yeesuu kidiburo‑o. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ne̱ Yeesuu na mò̱ ayaa‑rɔ aye̱re̱po̱‑ɔ a kpo̱ro̱we̱ ke̱be̱e̱‑ɔ si. Bamo̱ a kpo̱ro̱we̱‑ɔ, ne̱ mò̱ aa mò̱ agyase̱po̱ bwe̱e̱tɔ a bo̱ ye̱re̱ mfe̱ŋ ne̱ swe̱e̱re̱‑ɔ du kyɛɛkyɛɛ‑ɔ. Ase̱sɛ biribiri mɔ a gyaŋŋe̱ mfe̱ŋ. Bamo̱ bo̱ko̱ a le̱e̱ Yude̱ya swe̱e̱re̱ se̱, na Yɛro̱salɛm maŋ‑nɔ, ne̱ bo̱ko̱ mɔ a le̱e̱ e̱maŋ ko̱ se̱ ne̱ ba te̱e̱ e̱mo̱ ɛ Tiro na Sidɔŋ, ne̱ e̱ bo̱ ɔpo̱o̱ kɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Baa ba ne̱e̱ fe̱yɛ bo̱ bo̱ nu abware̱se̱ŋ ne̱ Yeesuu e̱ tɔwe̱‑ɔ na ɔ be̱e̱ kya bamo̱ alɔ. Bamo̱ ne̱ ibrisi te bamo̱ se̱ e̱e̱ tɔɔraa bamo̱‑ɔ pɛɛɛ mɔ a ba mfe̱ŋ. Ne̱ ɔɔ gya e̱mo̱ bo̱ ko̱so̱ bamo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ne̱ ase̱sɛ‑ɔ pɛɛɛ a le̱ŋ e̱ye̱e̱ ba kpa fe̱yɛ bo̱ dabo̱rɔ mò̱, a le̱e̱ fe̱yɛ ke̱yaale̱ŋ ne̱ o de‑o ɔ taare̱ a ɔ bo̱ kya bamo̱ pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ne̱ Yeesuu a le̱e̱ ɔ sa se̱ŋsa o gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Mo̱ne̱ ne̱ mo̱ne̱ i wu kitiri‑o, mo̱ne̱ de ŋyure, a le̱e̱ fe̱yɛ mo̱ne̱ e̱ gye̱ ne̱ mo̱ne̱ tii Wuribware̱ a kuwure‑o si. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mo̱ne̱ ne̱ ako̱ŋ e̱ mɔɔ mo̱ne̱ mbe̱yɔmɔ‑ɔ, mo̱ne̱ de ŋyure, a le̱e̱ fe̱yɛ mo̱ne̱ saŋ mo̱ne̱ e̱ ke̱e̱paa. Mo̱ne̱ ne̱ mo̱ne̱ e̱bo̱re̱‑rɔ i duŋwi mo̱ne̱ mbe̱yɔmɔ‑ɔ, mo̱ne̱ de ŋyure, a le̱e̱ fe̱yɛ mo̱ne̱ saŋ mo̱ne̱ e̱ mɔse̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","Ase̱sɛ ya kisi mo̱ne̱, ne̱ baa gya mo̱ne̱ le̱e̱ bamo̱ ke̱bware̱ko̱re̱ akyaŋ‑nɔ, ne̱ baa saare̱ mo̱ne̱, ne̱ baa nye̱ra mo̱ne̱ ke̱nyare̱ bo̱ le̱e̱ ane̱ŋ ne̱ mo̱ne̱ gya mo̱, dimaadi mò̱ gyi‑o, si‑o si, mo̱ne̱ de ŋyure, Ase̱ŋ ya to̱ mo̱ne̱ ane̱ŋ, mo̱nꞌ sa a a waa mo̱ne̱ kɔne̱ na mo̱nꞌ ba kɔne̱ bo̱ kyaa, a le̱e̱ fe̱yɛ kakɔka dabe̱ timaa ko̱ da ka gywii mo̱ne̱ Wuribware̱ se̱. Bo̱ le̱e̱ fe̱yɛ ane̱ŋ ne̱ ba waa mo̱ne̱‑ɔ dɛɛ ne̱ bamo̱ ade̱daapo̱‑ɔ a bo̱ waa Wuribware̱ a akyaamɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Amaa ase̱ŋ dabe̱ e̱ to̱ mo̱ne̱ ne̱ mo̱ne̱ gye̱ atɔ awuye mbe̱yɔmɔ‑ɔ, a le̱e̱ fe̱yɛ mo̱ne̱ a kyɔ gyi mo̱ne̱ kɔne̱ swe̱e̱re̱ se̱ mfe̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ase̱ŋ dabe̱ e̱ to̱ mo̱ne̱ ne̱ mo̱ne̱ a gyi ke̱e̱paa mbe̱yɔmɔ‑ɔ, a le̱e̱ fe̱yɛ ako̱ŋ saŋ a ba a bo̱ nya mo̱ne̱. Ase̱ŋ dabe̱ e̱ to̱ mo̱ne̱ ne̱ mo̱ne̱ e̱ mɔse̱ mbe̱yɔmɔ‑ɔ, a le̱e̱ fe̱yɛ bo̱re̱‑rɔ saŋ ɔ ba a ɔ bo̱ duŋwi mo̱ne̱ na mo̱nꞌ su. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ase̱ŋ dabe̱ e̱ to̱ mo̱ne̱ ne̱ ase̱sɛ e̱ sa mo̱ne̱ ke̱nyare̱ timaa mbe̱yɔmɔ‑ɔ. Ane̱ŋ dɛɛ ne̱ bamo̱ ade̱daapo̱ a sa bamo̱ ne̱ baa bo̱ pe̱nna fe̱yɛ bo̱ gye̱ Wuribware̱ akyaamɛɛ‑ɔ ke̱nyare̱ timaa.” ");
INSERT INTO ncuNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Mbe̱yɔmɔ mo̱ne̱ ne̱ mo̱ne̱ i nu mo̱ ase̱ŋ‑ɔ, mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ, mo̱nꞌ kpa mo̱ne̱ ado̱ŋ ase̱ŋ, na mo̱nꞌ waa bamo̱ ne̱ ba kisi mo̱ne̱‑ɔ ke̱dame̱naŋsɛ. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Na mo̱nꞌ yure bamo̱ ne̱ bamo̱ fe̱raa ba da mo̱ne̱ yii‑o, na mo̱nꞌ ko̱re̱ ke̱bware̱ko̱re̱ sa bamo̱ ne̱ ba waa mo̱ne̱ bo̱rɔkraa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Fe̱yɛ ɔko̱ ya da fo̱ ko̱ ke̱se̱bɔ‑rɔ ke̱baa, na fo̱ be̱e̱ buruwaa ke̱nyɔse̱po̱‑ɔ sa mò̱ a ɔ da. Ɔko̱ ya taa fo̱ waagya, na fo̱ taa fo̱ kaare̱ bo̱ tii mò̱ si na ɔ taa nare̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ɔke̱maa ne̱ ɔ ko̱re̱ fo̱ ko̱tɔko̱‑ɔ, fo̱ i de, sa mò̱ ke̱tɔ‑ɔ, ne̱ ɔko̱ ya taa fo̱ ke̱tɔ, fo̱ ma tɔɔraa mò̱ fe̱yɛ o kiŋŋaa ke̱mo̱ baa fo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Amo̱ katiŋ e̱ gye̱ fe̱yɛ ane̱ŋ ne̱ mo̱ne̱ e̱ kpa fe̱yɛ mo̱ne̱ abɛɛko̱ waa mo̱ne̱‑ɔ, mo̱ne̱ mɔ mo̱nꞌ waa ane̱ŋ dɛɛ sa bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Mo̱ne̱ e̱ kpa bamo̱ ne̱ ba kpa mo̱ne̱‑ɔ wo̱re̱ ase̱ŋ, e̱me̱ne̱ ne̱ mo̱ne̱ e̱ waa a mo̱nꞌ nya ŋyure le̱e̱ Wuribware̱ ase̱? A le̱e̱ fe̱yɛ bamo̱ gbaa, bamo̱ ne̱ bo̱ gye̱ e̱bɔye̱ awaapo̱‑ɔ, e̱ kpa bamo̱ ne̱ ba kpa bamo̱‑ɔ ase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mo̱ne̱ e̱ waa bamo̱ ne̱ ba waa mo̱ne̱ ke̱dame̱naŋsɛ‑ɔ ke̱dame̱naŋsɛ, ntɔ se̱ ne̱ mo̱nꞌ nya ŋyure? A le̱e̱ fe̱yɛ ane̱ŋ dɛɛ ne̱ e̱bɔye̱ awaapo̱ gbaa e̱ waa. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ne̱ mo̱ne̱ ya ba mo̱ne̱ atɔ bo̱ para bamo̱ ne̱ mo̱ne̱ nyi fe̱yɛ ba ka mo̱ne̱ ko̱kɔ‑ɔ wo̱re̱, e̱me̱ne̱ ne̱ mo̱ne̱ e̱ waa a mo̱nꞌ nya ŋyure le̱e̱ Wuribware̱ ase̱? A le̱e̱ fe̱yɛ e̱bɔye̱ awaapo̱ gbaa de ba para abɛɛ ane̱ŋ dɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Amaa amo̱ katiŋ‑o e̱ gye̱ fe̱yɛ mo̱nꞌ kpa mo̱ne̱ ado̱ŋ ase̱ŋ, na mo̱nꞌ waa bamo̱ ke̱dame̱naŋsɛ. Mo̱nꞌ ba mo̱ne̱ atɔ bo̱ para, na mo̱ne̱ ma fa fe̱yɛ bo̱ ka mo̱ne̱ amo̱ ko̱kɔ. Mo̱ne̱ ya waa ane̱ŋ sa bamo̱, mo̱ne̱ e̱ nya amo̱ kakɔka dabe̱ saŋ ko̱, na bo̱ ŋu fe̱yɛ mo̱ne̱ gye̱ Nyiŋkpe̱ŋ-kyo̱ŋ-atɔ‑pɛɛɛ-Bware̱ mò̱ gyi‑ana. Bo̱ le̱e̱ fe̱yɛ Wuribware̱ bware bo̱ sa bamo̱ ne̱ bo̱ gye̱ abo̱ro̱kɔɔne̱po̱ gbaa na bamo̱ ne̱ bo̱ maa sa mò̱ aŋsɛ ke̱tɔ ke̱maa‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Amo̱se̱‑ɔ mo̱nꞌ ŋu ase̱sɛ e̱wɛɛ fe̱yɛ ane̱ŋ ne̱ mo̱ne̱ se̱ Wuribware̱ i ŋu ase̱sɛ e̱wɛɛ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Mo̱ne̱ ya po̱rɔ mo̱ne̱ bɛɛko̱‑ana, Wuribware̱ mɔ e̱ po̱rɔ mo̱ne̱. Amo̱se̱‑ɔ mo̱ne̱ ma po̱rɔ mo̱ne̱ bɛɛko̱‑ana. Mo̱ne̱ ya bu mo̱ne̱ bɛɛko̱‑ana ke̱pɔ, Wuribware̱ mɔ i bu mo̱ne̱ ke̱pɔ. Amo̱se̱‑ɔ mo̱ne̱ ma bu mo̱ne̱ bɛɛko̱‑ana ke̱pɔ. Amaa mo̱ne̱ ya taa mo̱ne̱ bɛɛko̱‑ana e̱bɔye̱ bo̱ ke bamo̱, Wuribware̱ mɔ e̱ taa mo̱ne̱ lee a ɔ bo̱ ke mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mo̱ne̱ ya sa mo̱ne̱ bɛɛko̱‑ana atɔ, Wuribware̱ mɔ e̱ sa mo̱ne̱ mo̱ne̱ lee. Kase̱ŋtiŋ Wuribware̱ e̱ ba atɔ a ɔ bo̱ bo̱rɔ mò̱ kyuŋputiŋ‑o, na o yee si, na ɔ be̱e̱ nya bo̱ bo̱rɔ se̱, na a bo̱rɔwe̱, na ɔ taa sa mo̱ne̱. Ane̱ŋ ne̱ mo̱ne̱ e̱ sa mo̱ne̱ bɛɛko̱‑ana‑ɔ dɛɛ ne̱ Wuribware̱ mɔ i kiŋŋaa a ɔ bo̱ sa mo̱ne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ne̱ Yeesuu a da ke̱kpare̱ mɔ gywii bamo̱ fe̱yɛ, “Fo̱ e̱ gye̱ te̱napo̱, fo̱ e̱ taare̱ a fo̱ kaapo̱ fo̱ ko̱so̱bɛɛ te̱napo̱ kpa aaa? Mo̱ŋ kɔɔre̱ gyi. Fo̱ ya waa ane̱ŋ, mo̱ne̱ anyɔ‑ɔ e̱ le̱e̱ a mo̱nꞌ le̱e̱ da ke̱maŋtaŋ‑nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ane̱ŋ dɛɛ ne̱ sukuu kigyi mo̱ŋ de kpa fe̱yɛ ɔ kaapo̱ atɔ, a le̱e̱ fe̱yɛ ɔ mo̱ŋ ta fe̱yɛ mò̱ ɔkaapo̱po̱, amɔ ɔɔ lo̱we̱ mò̱ sukuu. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Bɛɛɛ e̱me̱ne̱ se̱ ne̱ fo̱ e̱ de̱e̱re̱ kakpafɛɛ ne̱ ka dɔŋ fo̱ bɛɛko̱ ke̱katɔ se̱‑ɔ, ne̱ fo̱ mo̱ŋ ke̱e̱ ke̱be̱ŋtiŋ ne̱ ke̱ dɔŋ fo̱ lee si‑o? ");
INSERT INTO ncuNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Bɛɛɛ e̱me̱ne̱ ne̱ fo̱ e̱ waa na fo̱ tɔwe̱ fe̱yɛ, ‘Mo̱ ko̱so̱bɛɛ, sa a n lee kakpafɛɛ ne̱ ka dɔŋ fo̱ ke̱katɔ se̱‑ɔ,’ na fo̱ fe̱raa fo̱ mo̱ŋ ke̱e̱ ke̱be̱ŋtiŋ ne̱ ke̱ dɔŋ fo̱ lee si‑o? Nnɔ ŋnyɔ ŋnyɔ wuye, lee ke̱be̱ŋtiŋ ne̱ ke̱ dɔŋ fo̱ fɔŋfɔŋ ke̱katɔ se̱‑ɔ pwɛɛ na fo̱ dɛɛ taare̱ ŋu dame̱naŋsɛ lee kakpafɛɛ ne̱ ka dɔŋ fo̱ bɛɛko̱ lee si‑o. Amo̱se̱ se̱‑ɔ mo̱ne̱ ma po̱rɔ mo̱ne̱ bɛɛko̱‑ana. Amaa mo̱nꞌ lee e̱bɔye̱ le̱e̱ mo̱ne̱ fɔŋfɔŋ ŋkpo̱nɔ‑rɔ pwɛɛ na mo̱nꞌ dɛɛ taare̱ kya mo̱ne̱ bɛɛko̱‑ana‑rɔ na bo̱ lee bamo̱ lee.” ");
INSERT INTO ncuNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ne̱ Yeesuu be̱e̱ ɔ yɛ, “Kiyii timaa maa swɛɛ agyi bɔye̱, ne̱ kiyii ne̱ ke̱ mo̱ŋ de alaŋfiya‑o mɔ maa swɛɛ agyi timaa. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kiyii agyi ne̱ bo̱ de ba pini kiyii suyo ne̱ ke̱ gye̱‑ɔ. A le̱e̱ fe̱yɛ le̱ŋkre̱ŋ maa swɛɛ kimaŋgoo agyi, ne̱ kuruŋbree mɔ maa swɛɛ kukuti agyi. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Se̱sɛ timaa kakpo̱nɔ‑rɔ ne̱ atɔ timaa e̱ le̱e̱, ne̱ atɔ bɔye̱ e̱ le̱e̱ se̱sɛ bɔye̱ kakpo̱nɔ‑rɔ, a le̱e̱ fe̱yɛ ke̱tɔ ne̱ ke̱ bo̱ se̱sɛ kakpo̱nɔ‑rɔ‑ɔ e̱ gye̱ ne̱ a le̱e̱ mò̱ kanɔ‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ne̱ Yeesuu a kya se̱ bise fe̱yɛ, “Nte̱tɔ se̱ ne̱ mo̱ne̱ e̱ te̱e̱ mo̱ ɛ ‘Mo̱ nyaŋpe̱, mo̱ nyaŋpe̱,’ na mo̱ne̱ mɔ mo̱ne̱ maa waa ke̱tɔ ne̱ mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱‑ɔ ne̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mo̱ e̱ kaapo̱ mo̱ne̱ ane̱ŋ ne̱ ɔko̱ ne̱ ɔ ba mo̱ ase̱ a o nu mo̱ ase̱ŋ, ne̱ o bu amo̱‑ɔ du‑o. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Se̱sɛ‑ɔ du ne̱e̱ fe̱yɛ ɔnyare̱ ko̱ ne̱ ɔ kpa a ɔ pwɛɛ lɔŋ, ne̱ ɔɔ da talii, ne̱ oo kwii talii‑o‑ro waa keŋ ya to̱ afo̱re̱ pwɛɛ ne̱ ɔɔ dɛɛ pwɛɛ mò̱ lɔŋ bo̱ ye̱ra se̱. Mò̱ a pwɛɛ mò̱ lɔŋ‑ɔ bo̱ ye̱ra lo̱we̱‑ɔ, ne̱ bo̱ŋ ko̱ a twe̱e̱ kufwiiri, ne̱ mò̱ nkyu a gyaa bo̱ to̱waa lɔŋ‑ɔ, na ɔ mo̱ŋ le̱ŋkpaŋ gbaa, bo̱ le̱e̱ ane̱ŋ ne̱ baa pwɛɛ mò̱ dame̱naŋsɛ‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Amaa ɔko̱ ne̱ o nu mo̱ ase̱ŋ ne̱ mo̱ e̱ tɔwe̱‑ɔ, ne̱ mò̱‑ɔ mò̱ maa gya amo̱ se̱‑ɔ du ne̱e̱ fe̱yɛ ɔnyare̱ ko̱ ne̱ ɔɔ pwɛɛ mò̱ lɔŋ ne̱ ɔ mo̱ŋ kwii talii‑o na ɔ waa keŋ‑o. Ne̱ nkyu a twe̱e̱ kufwiiri gyaa bo̱ to̱waa lɔŋ amo̱. Ne̱ lɔŋ amo̱ a bwee le̱e̱ da wuuruum. Amo̱ e̱ gye̱ saase̱bɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Saŋ ne̱ Yeesuu a tɔwe̱ ke̱tɔ ne̱ o de o gywii ase̱sɛ‑ɔ lo̱we̱‑ɔ, ne̱ ɔɔ yɔ Kapaaniyum maŋ‑nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Amɔ saŋ amo̱‑ɔ asoogyaa abre̱sɛ‑ɔ ɔko̱ bo̱ mfe̱ŋ. Ɔ mo̱ŋ gye̱ Isireeliinyi fe̱yɛ Yeesuu‑o. Ɔ gye̱ Romanyi ne̱e̱. Ne̱ o de mò̱ ke̱yaafɔre̱ timaa ko̱ ne̱ ɔ lɔ ɔ da ɔ kpa a o wu. ");
INSERT INTO ncuNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Soogyaa amo̱ a nu Yeesuu si maŋ‑ɔ‑rɔ‑ɔ, ne̱ oo suŋ Yudaa awuye abre̱sɛ ko̱ fe̱yɛ bo̱ ya ko̱re̱ Yeesuu na ɔ bo̱ kya mò̱ ke̱yaafɔre̱‑ɔ sa mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ne̱ baa ba Yeesuu ase̱ bo̱ ko̱re̱ mò̱ fe̱yɛ ɔ ba. Ne̱ bo̱ yɛ, “Hare̱e̱ ɔnyare̱ amo̱ a mo̱ŋ gye̱ Isireeliinyi‑o gbaa ooo, a bware fe̱yɛ fo̱ bo̱ kya mò̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Bo̱ le̱e̱ fe̱yɛ ɔ kpa ane̱ ase̱sɛ ase̱ŋ, ne̱ mò̱ fɔŋfɔŋ a be̱e̱ pwɛɛ ke̱bware̱ko̱re̱kyaŋ sa ane̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Amo̱se̱‑ɔ ne̱ bamo̱ aa Yeesuu a taa bo̱ yɔ. Bamo̱ a kpa a bo̱ fo̱ lɔŋ‑ɔ‑rɔ‑ɔ, ne̱ soogyaa‑o a suŋ mò̱ nyare̱‑ana fe̱yɛ bo̱ ya gyaŋŋaa Yeesuu. Ne̱ baa ya tɔwe̱ gywii mò̱ fe̱yɛ, “Mo̱ nyaŋpe̱, fo̱ ma kpo̱ne̱ fo̱ e̱ye̱e̱ ba mo̱ ase̱. A le̱e̱ fe̱yɛ mo̱ŋ gye̱ se̱sɛ timaa ne̱ m bware fe̱yɛ fo̱ ba mo̱ lɔŋ‑nɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ne̱ mo̱‑ɔ m be̱e̱ mo̱ŋ fo̱ fe̱yɛ m ba fo̱ ase̱ mo̱ fɔŋfɔŋ. Amo̱se̱‑ɔ fo̱ ya de̱ŋ sa kanɔ bo̱ kyo̱ŋwe̱ gbaa, mo̱ ke̱yaafɔre̱‑ɔ e̱ kpaare̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ŋ gbaa mo̱ ne̱ n gye̱ se̱sɛ laŋgyaŋ, ne̱ n de abre̱sɛ ne̱ bo̱ kyɔ mo̱‑ɔ, de asoogyaa awuye mo̱ kaase̱, ne̱ mo̱ ya tɔwe̱ gywii bamo̱ ɔko̱ fe̱yɛ, ‘Nare̱,’ ɔ yɔ ne̱e̱, ne̱ mo̱ ya tɔwe̱ gywii ɔko̱ mɔ fe̱yɛ, ‘Ba,’ puri amo̱‑rɔ amɔ ɔ ba. Ne̱ mo̱ ya tɔwe̱ gywii mo̱ ke̱yaafɔre̱ fe̱yɛ, ‘Waa ke̱mo̱‑ɔ,’ amɔ ɔ waa.” ");
INSERT INTO ncuNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yeesuu a nu ane̱ŋ ne̱ ɔnyare̱ amo̱ a suŋ bo̱ tɔwe̱‑ɔ, ne̱ e̱ye̱e̱ a kpe̱ŋ mò̱, ne̱ oo buruwaa tɔwe̱ gywii lamaŋ ne̱ ɔ gya mò̱ se̱‑ɔ fe̱yɛ, “Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ mo̱ŋ tɛɛ ŋu se̱sɛ ne̱ ɔ kɔɔre̱ mo̱ o gyi mfaanɛɛ‑ɔ, ane̱ Isireelii awuye‑ro gbaa mo̱ŋ tɛɛ ŋu ɔko̱ ane̱ŋ. Ne̱ ɔnyare̱ mɔ mo̱ŋ gye̱ Isireeliinyi.” ");
INSERT INTO ncuNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ne̱ mbɔɔ amo̱ a kiŋŋi yɔ soogyaa amo̱ aye̱ ya to̱ fe̱yɛ mò̱ ke̱yaafɔre̱ amo̱ a kpaare̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ŋke mfe̱ne̱ ko̱ kamɛɛ‑ɔ, ne̱ Yeesuu a yɔ maŋ ko̱ ne̱ ba te̱e̱ ɛ Nayiŋ‑o‑ro. Amɔ saŋ amo̱‑ɔ mò̱ agyase̱po̱‑ɔ na ase̱sɛ biribiri gya mò̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Saŋ ne̱ ba kpa a bo̱ lwee maŋ‑ɔ‑rɔ‑ɔ na ase̱sɛ ko̱ so̱ kifuniŋ, na ase̱sɛ bwe̱e̱tɔ gya se̱ ba le̱e̱ maŋ‑ɔ‑rɔ ba yɔ purekpa. Asaa kpenlekye̱e̱ ko̱ mɔ kagyinyaŋsɛɛ wo̱re̱ kpeŋ ne̱ o de‑o ya wu, ne̱ bo̱ de mò̱ a bo̱ ya pure, ne̱ maŋ‑ɔ‑rɔ ase̱sɛ gya se̱ ane̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Amɔ Yeesuu ke̱de̱ŋ ŋu ɔkye̱e̱ amo̱‑ɔ, ne̱ mò̱ ase̱ŋ a waa mò̱ e̱wɛɛ, ne̱ ɔɔ tɔwe̱ gywii ɔkye̱e̱‑ɔ fe̱yɛ, “Fo̱ ma lɛɛ su.” ");
INSERT INTO ncuNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ne̱ Yeesuu a nare̱ ya dabo̱rɔ kifuniŋ‑o, ne̱ bamo̱ ne̱ bo̱ so̱‑ɔ a sii ye̱re̱. Ne̱ Yeesuu yɛ, “Ke̱yaafɔre̱, ko̱so̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ne̱ ke̱yaafɔre̱ ne̱ oo wu‑o a ko̱so̱ kye̱na, ne̱ ɔɔ le̱e̱ ɔ sa se̱ŋsa. Ne̱ Yeesuu a taa mò̱ sa mò̱ nyi. ");
INSERT INTO ncuNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ne̱ kufu a nya bamo̱ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ pɛɛɛ, ne̱ baa kyo̱rɔ Wuribware̱. Ne̱ bo̱ yɛ, “Wuribware̱ kyaamɛɛ dabe̱ ko̱ a ba ane̱ ase̱. Wuribware̱ a ba a ɔ bo̱ mo̱rɔwe̱ mò̱ ase̱sɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ne̱ Yeesuu ase̱ŋ a yɔ e̱maŋ ne̱ e̱ maa mfe̱ŋ‑ɔ‑rɔ na ifuri amo̱ pɛɛɛ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Ne̱ Yohanee Osuubɔpo̱ a agyase̱po̱‑ɔ a tɔwe̱ atɔ ne̱ Yeesuu a waa‑ɔ pɛɛɛ ase̱ŋ gywii Yohanee. Ne̱ ɔɔ te̱e̱ bamo̱ abɛɛ anyɔ suŋ bamo̱ Yeesuu ase̱ na bo̱ ya bise mò̱ fe̱yɛ, “Fo̱ e̱ gye̱ Kristoo ne̱ Yohanee yɛ ɔ ba a ɔ bo̱ le̱e̱ Wuribware̱ ase̱‑ɔ ɔɔɔ, bɛɛɛ se̱sɛ baŋbaŋ ko̱ be̱e̱ ɔ bo̱‑rɔ ne̱ ane̱ ke̱e̱ mò̱ kpa aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Amo̱ fe̱raa bamo̱ a yɔ Yeesuu ase̱‑ɔ, ne̱ baa bise mò̱ fe̱yɛ, “Yohanee Osuubɔpo̱‑ɔ ya suŋ ane̱ na ane̱ bo̱ bise fo̱ fe̱yɛ fo̱ e̱ gye̱ Kristoo ne̱ ɔ yɛ ɔ ba a ɔ bo̱ le̱e̱ Wuribware̱ ase̱‑ɔ ɔɔɔ, bɛɛɛ se̱sɛ baŋbaŋ ko̱ be̱e̱ ɔ bo̱‑rɔ ne̱ ane̱ ke̱e̱ mò̱ kpa aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Saŋ amo̱ mɔ‑ɔ, Yeesuu a kyɔ kya alɔpo̱ bwe̱e̱tɔ na bamo̱ ne̱ ibrisi te bamo̱ se̱‑ɔ. Ate̱napo̱ pɛɛɛ, oo buŋŋi bamo̱ akatɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","To, ne̱ ɔɔ be̱ŋŋaa Yohanee Osuubɔpo̱ a mbɔɔ‑ɔ fe̱yɛ, “Mo̱nꞌ kiŋŋi nare̱ ya tɔwe̱ ke̱tɔ ne̱ mo̱ne̱ a nu mo̱ e̱ tɔwe̱, na ke̱tɔ ne̱ mo̱ne̱ a ŋu mo̱ e̱ waa‑ɔ gywii Yohanee. Fe̱yɛ ane̱ŋ ne̱ Wuribware̱ kyaamɛɛ ko̱ a kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ bo̱ le̱e̱ mò̱ ne̱ ɔ ba a ɔ bo̱ ba‑ɔ kuŋu si ase̱ŋ‑ɔ, amo̱ e̱ gye̱ fe̱yɛ, mbe̱yɔmɔ ate̱napo̱ ke̱e̱, ne̱ agyabɔɔ naa, ne̱ abwatɔpo̱ ke̱bwatɔ a lo̱we̱, ne̱ akpawu i nu ase̱ŋ, ne̱ bamo̱ ne̱ baa wu‑o a kyiŋŋi, ne̱ atiripo̱ i nu ase̱ŋ timaa‑o. ");
INSERT INTO ncuNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ɔko̱ ne̱ ɔ maa yɔwe̱ ko̱kɔɔre̱ mo̱ gyi‑o e̱ nya ŋyure.” ");
INSERT INTO ncuNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Saŋ ne̱ Yohanee Osuubɔpo̱ a mbɔɔ‑ɔ a kiŋŋi bo̱ yii‑o, ne̱ Yeesuu a le̱e̱ ɔ tɔwe̱ Yohanee ase̱ŋ o gywii ase̱sɛ bwe̱e̱tɔ ne̱ bo̱ gya mò̱ se̱‑ɔ. Ɔ yɛ, “Saŋ ne̱ mo̱ne̱ a yɔ Yohanee ase̱ kimukee‑ro‑o, nte̱tɔ ne̱ mo̱ne̱ a yɔ a mo̱nꞌ ya de̱e̱re̱? Ɔko̱ ne̱ o kyurowi mò̱ mfɛɛre̱ fe̱yɛ ane̱ŋ ne̱ e̱fa i kpeere ŋ yɔ mfe̱e̱ na mfe̱e̱ saŋ ne̱ afwii e̱ da mmo̱‑ɔ ne̱ mo̱ne̱ a ya de̱e̱re̱ aaa? ");
INSERT INTO ncuNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nte̱tɔ ne̱ mo̱ne̱ a le̱e̱ a mo̱nꞌ ya de̱e̱re̱? Se̱sɛ ne̱ o buŋ waagya timaa‑o ne̱ mo̱ne̱ a yɔ a mo̱nꞌ ya de̱e̱re̱ aaa? Ase̱sɛ ne̱ bo̱ buŋ ane̱ŋ a atɔ ne̱ bamo̱ kakye̱na‑rɔ bo̱ kɔne̱‑ɔ gye̱ atɔ awuye ne̱ bo̱ te e̱lɔŋ dame̱naŋsɛ dabe̱ dabe̱‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mo̱nꞌ tɔwe̱ gywii mo̱, nsɛ ne̱ mo̱ne̱ a yɔ a mo̱nꞌ ya de̱e̱re̱? Wuribware̱ kyaamɛɛ aaa? Kase̱ŋtiŋ ne̱e̱, amaa n gye̱ Wuribware̱ kyaamɛɛ‑ɔ wo̱re̱ ne̱ mo̱ne̱ a ya ŋu. Mo̱ne̱ a ŋu ɔko̱ na ɔ kyɔ bo̱ tii si. ");
INSERT INTO ncuNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","A le̱e̱ fe̱yɛ Yohanee Osuubɔpo̱‑ɔ ase̱ŋ ne̱ baa kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ Wuribware̱ e̱ tɔwe̱ o gywii Kristoo fe̱yɛ, ‘Mo̱ i suŋ mo̱ kabɔɔ a m bo̱ gye̱ fo̱ ŋkpɛɛ, na ɔ ya lɔŋŋɔ kpa bo̱ ye̱ra fo̱.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ne̱ Yeesuu a tɔwe̱ bo̱ tii si fe̱yɛ, “Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ se̱sɛ ko̱ mo̱ŋ kye̱na swe̱e̱re̱ mɔ se̱ ne̱ ɔ kyɔ Yohanee Osuubɔpo̱‑ɔ, amaa mò̱ ne̱ ɔ gye̱ kagyingyii Wuribware̱ se̱ a kuwure‑o‑ro kyɔ Yohanee.” ");
INSERT INTO ncuNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ase̱sɛ‑ɔ pɛɛɛ, fɔŋfɔŋ leŋpoo akɔɔre̱po̱‑ɔ, a nu ane̱ŋ ne̱ Yeesuu a tɔwe̱ Yohanee Osuubɔpo̱‑ɔ ase̱ŋ‑ɔ, ne̱ bamo̱ akatɔ a gyi, ne̱ bo̱ yɛ Wuribware̱ bware. Ase̱sɛ mɔ ne̱ baa tɔwe̱ ane̱ŋ‑ɔ gye̱ bamo̱ ne̱ Yohanee a bɔ asuu‑o ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Amaa Farisii awuye‑o na Wuribware̱ mbraa akaapo̱po̱‑ɔ e̱ gye̱ bamo̱ ne̱ bamo̱ fe̱raa baa kine kpa ne̱ Wuribware̱ e̱ bo̱rɔ se̱ a ɔ bo̱ mo̱rɔwe̱ ase̱sɛ‑ɔ, ne̱ baa kine fe̱yɛ Yohanee bɔ bamo̱ asuu‑o. ");
INSERT INTO ncuNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ne̱ Yeesuu a kya se̱ ɛ, “Mbe̱yɔmɔ, nte̱tɔ ne̱ mo̱ e̱ nya a m bo̱ biri ndɔɔ a ase̱sɛ‑ɔ ne̱e̱? E̱me̱ne̱ ne̱ bo̱ du? ");
INSERT INTO ncuNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bo̱ du ne̱e̱ fe̱yɛ ŋyaagyi a te ba soori ko̱lɔŋde̱ se̱, ne̱ bamo̱ katuŋ ko̱ e̱ fɛɛ‑rɔ ba kyo̱ŋwe̱ katuŋ ko̱ fe̱yɛ, ‘Ane̱ a da ko̱ko̱fɔ‑rɔ akɔye̱ sa mo̱ne̱, amaa mo̱ne̱ mo̱ŋ kyaa ooo. Ne̱ ane̱ a be̱e̱ waa kale, amaa mo̱ne̱ mo̱ŋ su ooo.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","To, Yohanee Osuubɔpo̱‑ɔ a ba‑ɔ, ɔɔ kra ako̱ŋ, ne̱ oo kisi nta kunuu, ne̱ mo̱ne̱ yɛ, ‘Ɔbɔnsam te mò̱ se̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Amaa mo̱, dimaadi mò̱ gyi‑o, a ba, ne̱ mo̱ a gyi nuu fe̱raa, ne̱ mo̱ne̱ be̱e̱ mo̱ne̱ yɛ, ‘Mo̱nꞌ ke̱e̱ ɔnyare̱ amo̱, ɔ gye̱ oteesekpapo̱, na ɔtanuupo̱, na leŋpoo akɔɔre̱po̱ bamo̱ nyare̱, na e̱bɔye̱ awaapo̱ bamo̱ nyare̱ ne̱e̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Amaa fo̱ ya ŋu ɔko̱ ne̱ mò̱ e̱ gya Wuribware̱ a kanyiase̱ŋ a e̱kpa‑ɔ se̱‑ɔ, fo̱ i ŋu fe̱yɛ mò̱ kanyiase̱ŋ‑ɔ gye̱ kase̱ŋtiŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ne̱ Farisii awuye‑o ɔko̱ ne̱ ba te̱e̱ mò̱ ɛ Simɔŋ‑ɔ a nyiŋŋi Yeesuu fe̱yɛ ɔ ba mò̱ aye̱ bo̱ gyi ateese. Ne̱ ɔɔ yɔ mfe̱ŋ ya kye̱na a o gyi. ");
INSERT INTO ncuNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Amɔ saŋ amo̱ ɔkye̱e̱ ko̱ mɔ bo̱ maŋ‑ɔ‑rɔ mfe̱ŋ, ne̱ ɔ gye̱ e̱bɔye̱ ɔwaapo̱. Ne̱ oo nu fe̱yɛ Yeesuu a ba Farisiinyi amo̱ aye̱ o gyi. Amo̱se̱‑ɔ ne̱ ɔɔ kpa mò̱ laŋpe̱ŋtaa bo̱ bo̱rɔ kalɔgyii ko̱ ne̱ baa baa kibu ko̱ ne̱ ba te̱e̱ ke̱mo̱ ɛ alabase̱taa‑ɔ bo̱ waa‑ɔ baa mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Amo̱ a gye̱ Yudaa awuye mbraa‑ɔ se̱, ne̱ bo̱ da ba gyi. Ne̱ ɔkye̱e̱‑ɔ a bo̱ ye̱re̱ Yeesuu ayaa ase̱. Ne̱ o su o de mò̱ akyukyu ɔ pɔ mò̱ ayaapapaa. Ne̱ ŋkee ɔɔ ba mò̱ ipwii bo̱ kpɛɛ akyukyu‑o Yeesuu ayaapapaa‑ɔ se̱, ne̱ ŋkee ɔɔ kyo̱kywe̱e̱ amo̱ se̱, ne̱ oo twiiri laŋpe̱ŋtaa‑ɔ bo̱ we̱e̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ne̱ Farisiinyi ne̱ Yeesuu te mò̱ lɔŋ‑nɔ‑ɔ a ŋu ane̱ŋ‑ɔ, ne̱ ɔɔ fa mò̱ mfɛɛre̱‑rɔ fe̱yɛ, “Ɔnyare̱ mɔ dɛɛ ɔ gye̱ Wuribware̱ kyaamɛɛ kase̱ŋtiŋ ne̱e̱, weetee o ŋu ke̱tɔ ne̱ ɔkye̱e̱ mɔ ne̱ ɔ dabo̱rɔ mò̱‑ɔ gye̱‑ɔ. Na o ŋu ane̱ŋ ne̱ ɔkye̱e̱ mɔ te ɔ waa e̱bɔye̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Amo̱ fe̱raa ne̱ Yeesuu a tɔwe̱ fe̱yɛ, “Simɔŋ, n de ko̱tɔko̱ a n tɔwe̱ gywii fo̱.” Ne̱ Simɔŋ yɛ, “Yooo, ɔkaapo̱po̱, tɔwe̱ gywii mo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ne̱ Yeesuu a tɔwe̱ fe̱yɛ, “Anyare̱ anyɔ ko̱ e̱ bo̱‑rɔ. Ne̱ bo̱ de atɔ wuye ko̱, ne̱ o de mò̱ atanne̱ ɔ para ase̱sɛ‑ɔ ko̱kɔ. Bamo̱ ɔko̱ de mò̱ ko̱kɔ siidii ŋkpe̱ŋ nnuu, ne̱ ɔko̱‑ɔ mɔ de siidii alafa anuu. ");
INSERT INTO ncuNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bamo̱ anyɔ‑ɔ mɔ pɛɛɛ mo̱ŋ taare̱ ko̱kɔ‑ɔ ka, amo̱se̱ se̱‑ɔ ne̱ ɔɔ taa bo̱ ke bamo̱. To, bamo̱ abɛɛ anyɔ mɔ‑rɔ, nsɛ e̱ gye̱ ne̱ mò̱ akatɔ i gyi atɔ wuye amo̱ se̱ bwe̱e̱tɔ‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ne̱ Simɔŋ Farisiinyi‑o a be̱ŋŋaa fe̱yɛ, “Mo̱ e̱ kɔɔre̱ a n gyi fe̱yɛ mò̱ ne̱ mò̱ ko̱kɔ kyɔ bwe̱e̱tɔ, ne̱ ɔɔ taa bo̱ ke mò̱‑ɔ.” Ne̱ Yeesuu yɛ, “A gye̱ kase̱ŋtiŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Amo̱ fe̱raa ne̱ oo buruwaa de̱e̱re̱ ɔkye̱e̱ amo̱ a keri‑o, ne̱ ɔɔ tɔwe̱ gywii Simɔŋ fe̱yɛ, “Fo̱ a ŋu ɔkye̱e̱ mɔ aaa? Mo̱ a ba fo̱ aye̱‑ɔ, fo̱ mo̱ŋ kra mo̱ nɛɛnɛɛ, fe̱yɛ fo̱ mo̱ŋ sa mo̱ nkyu na m bo̱ fwe̱e̱ ayaapapaa se̱, amaa ɔkye̱e̱‑ɔ fe̱raa a ba mo̱ akyukyu bo̱ fwe̱e̱ mo̱ ayaapapaa se̱, ne̱ ɔɔ ba mò̱ ipwii bo̱ kpɛɛ amo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Fo̱ mo̱ŋ kyo̱kywe̱e̱ mo̱ ke̱daabɔŋ bo̱ sa mo̱ aŋsɛ na ke̱ba, amaa ɔkye̱e̱‑ɔ fe̱raa mo̱ŋ yɔwe̱ mo̱ ayaapapaa se̱ ko̱kyo̱kywe̱e̱ le̱e̱ hare̱e̱ saŋ ne̱ mo̱ a ba mfe̱e̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Fo̱ mo̱ŋ kyiine mo̱ kuŋu‑ro mfɔ, amaa mò̱ fe̱raa a twiiri laŋpe̱ŋtaa we̱e̱ mo̱ ayaapapaa se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Amo̱se̱‑ɔ mo̱ e̱ tɔwe̱ mo̱ i gywii fo̱ fe̱yɛ, hare̱e̱ ɔkye̱e̱ mɔ e̱bɔye̱ a kyɔ gbaa ooo, Wuribware̱ a taa e̱mo̱ pɛɛɛ bo̱ ke mò̱. Ke̱kpa de̱maŋte̱ ne̱ ɔ kpa mo̱‑ɔ e̱ gye̱ ne̱ ke̱ e̱ kaapo̱ fe̱yɛ Wuribware̱ a taa mò̱ e̱bɔye̱‑ɔ bo̱ ke mò̱. Amaa ɔko̱ ne̱ ɔɔ waa e̱bɔye̱ kafwe̱e̱ ne̱ Wuribware̱ a taa bo̱ ke mò̱‑ɔ e̱ kpa Wuribware̱ kafwe̱e̱ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ne̱ Yeesuu a tɔwe̱ gywii ɔkye̱e̱‑ɔ fe̱yɛ, “Mo̱ a taa fo̱ e̱bɔye̱ bo̱ ke fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ne̱ bamo̱ ne̱ bamo̱ aa Yeesuu i gyi‑o wo̱re̱ wo̱re̱ e̱ tɔwe̱ ba gywii abɛɛ fe̱yɛ, “Ɔnyare̱ mɔ e̱ fa fe̱yɛ ɔ gye̱ nsɛ, ne̱ hare̱e̱ o de ase̱sɛ e̱bɔye̱ o ke bamo̱?” ");
INSERT INTO ncuNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Amaa Yeesuu a be̱e̱ tɔwe̱ gywii ɔkye̱e̱‑ɔ ne̱e̱ fe̱yɛ, “Fo̱ a kɔɔre̱ mo̱ gyi‑o si‑o, Wuribware̱ a mo̱rɔwe̱ fo̱. To, nare̱ dame̱naŋsɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","2","Bo̱ fo̱ saŋ ko̱‑ɔ ne̱ Yeesuu a nare̱ e̱maŋ dabe̱ na ngyingyii si ɔ tɔwe̱ ase̱ŋ timaa bo̱ le̱e̱ Wuribware̱ kuwure‑o si o gywii ase̱sɛ. Mò̱ aa mò̱ agyase̱po̱ kudu anyɔ‑ɔ na akye̱e̱pe̱ ko̱ ne̱ ɔɔ gya ibrisi bo̱ ko̱so̱ bamo̱ se̱, ne̱ ɔɔ kya bamo̱ alɔgyi‑o ya nare̱ kaa e̱maŋ‑ɔ se̱. Akye̱e̱ amo̱ e̱ gye̱ Mariya ne̱ ba te̱e̱ mò̱ ɛ Magadalanyi, ne̱ Yeesuu a gya ibrisi isunoo bo̱ ko̱so̱ mò̱ se̱‑ɔ, ");
INSERT INTO ncuNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","na Yohana ne̱ ba te̱e̱ mò̱ kuri ɛ Kusa ne̱ ɔ dɛɛ ɔ gye̱ Owure Hɛrɔd a ayaafɔre̱‑ɔ pɛɛɛ ɔbre̱sɛ‑ɔ, na Susana, na akye̱e̱ bwe̱e̱tɔ bo̱ tii si. Baa ba bamo̱ mpo̱tɛɛ ne̱ bo̱ de‑o ŋko̱ bo̱ kya Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ne̱ ase̱sɛ a le̱e̱ e̱maŋ se̱ e̱maŋ se̱ ba Yeesuu ase̱. Saŋ ne̱ ase̱sɛ biribiri a bo̱ gyaŋŋe̱‑ɔ, ne̱ Yeesuu a tɔwe̱ kitee mɔ gywii bamo̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“N gye̱ ɔdɔɔpo̱ ko̱ e̱ bo̱‑rɔ aaa? Ne̱ ɔɔ yɔ a ɔ ya ŋo̱nyaŋ mò̱ yaabraa. Mò̱ a yɔ ɔ ŋo̱nyaŋ‑ɔ, ne̱ ayaabraagyi amo̱ ako̱ a le̱e̱ da kpa kɛɛ, ne̱ ase̱sɛ a kyikye si, ne̱ mbo̱gyii a bo̱ tesi gyi. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ne̱ yaabraa amo̱ ako̱ a le̱e̱ da kagyaase̱. A bo̱ kwɛɛ‑ɔ, ne̱ aa wu, a le̱e̱ fe̱yɛ swe̱e̱re̱ amo̱ mfe̱ŋ mo̱ŋ de yuri. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ne̱ ako̱ mɔ a le̱e̱ da e̱fa‑rɔ, ne̱ amo̱ aa e̱fa‑ɔ a ko̱so̱, ne̱ e̱fa‑ɔ a daŋ mwiire amo̱ se̱, amo̱se̱‑ɔ ɔ mo̱ŋ taare̱ waa. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ne̱ ŋkee ayaabraagyi amo̱ ako̱ a le̱e̱ da swe̱e̱re̱ timaa si, ne̱ yaabraa‑ɔ a ko̱so̱ daŋ bo̱ ko̱we̱ waa aŋu adabe̱ adabe̱. Amo̱ e̱ gye̱ saase̱bɛɛ. Amo̱se̱‑ɔ ɔke̱maa ne̱ o de e̱se̱bɔ‑ɔ, o nu.” ");
INSERT INTO ncuNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ne̱ Yeesuu agyase̱po̱‑ɔ a bise mò̱ kitee‑o kaase̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ne̱ ɔɔ be̱ŋŋaa bamo̱ fe̱yɛ, “Mo̱ne̱ wo̱re̱ ne̱ mo̱ e̱ tɔwe̱ ane̱ŋ ne̱ Wuribware̱ a kuwure‑o‑ro du‑o mo̱ i gywii, amaa bamo̱ ne̱ ba saŋ‑ɔ fe̱raa itee‑ro na akpare̱‑rɔ ne̱ mo̱ e̱ tɔwe̱ ke̱mo̱ ase̱ŋ a m bo̱ gywii bamo̱, ‘na bo̱ de̱e̱re̱ ase̱ŋ‑ɔ‑rɔ, na bo̱ fa amo̱ mfɛɛre̱ kpo̱ne̱, na bo̱ nu ke̱mo̱ ase̱ŋ kpo̱ra‑rɔ, na bo̱ ma nu kaase̱.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ne̱ Yeesuu yɛ, “To, ŋkee mo̱nꞌ nu kitee‑o kaase̱. Ayaabraagyi‑o ko̱ŋo̱nyaŋ ye̱re̱ bo̱ sa abware̱se̱ŋ ne̱ mo̱ e̱ tɔwe̱ mo̱ i gywii ase̱sɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ayaabraagyi ne̱ aa le̱e̱ da kpa kɛɛ‑ɔ ye̱re̱ bo̱ sa ase̱sɛ ne̱ ba nu abware̱se̱ŋ, ne̱ amo̱ ya waa kafwe̱e̱‑ɔ, amɔ Ɔbɔnsam e̱ ba a ɔ bo̱ lee amo̱ le̱e̱ bamo̱ mfɛɛre̱‑rɔ, na bo̱ ma nya kɔɔre̱ gyi na Wuribware̱ mo̱rɔwe̱ bamo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ayaabraagyi ne̱ aa le̱e̱ da kagyaase̱‑ɔ mɔ ye̱re̱ bo̱ sa ase̱sɛ ne̱ ba nu abware̱se̱ŋ‑ɔ, ne̱ a waa bamo̱ ŋkpo̱nɔ‑rɔ kɔne̱‑ɔ. Amaa bamo̱ akatɔ mo̱ŋ pee si‑o si‑o, Ɔbɔnsam ya kyɔ bamo̱‑rɔ ke̱e̱ kafwe̱e̱, amɔ baa kyɔ yɔwe̱ abware̱se̱ŋ‑ɔ se̱ ke̱gya. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Amo̱ ne̱ aa le̱e̱ da e̱fa‑rɔ‑ɔ mɔ ye̱re̱ bo̱ sa bamo̱ ne̱ ba nu abware̱se̱ŋ‑ɔ, ne̱ kaye̱ mɔ‑rɔ atɔ tɔɔraasɛ na katanne̱kpa na atɔ biribiri ke̱kpa ya lwee bamo̱ mfɛɛre̱‑rɔ, amɔ aa waa ko̱kyɔ kyo̱ŋ abware̱se̱ŋ ne̱ a bo̱ bamo̱ ŋkpo̱nɔ‑rɔ‑ɔ. Amɔ bamo̱ ko̱kɔɔre̱gyi‑o maa waa bamo̱ sɛye̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ŋkee ayaabraagyi ne̱ aa le̱e̱ da swe̱e̱re̱ timaa si, ne̱ aa ko̱so̱ daŋ bo̱ ko̱we̱ waa aŋu adabe̱ adabe̱‑ɔ mɔ ye̱re̱ bo̱ sa ase̱sɛ timaa ne̱ ba nu ase̱ŋ timaa‑o, ne̱ ba kɔɔre̱ ba gyi, ne̱ ba le̱ŋ e̱ye̱e̱ bo̱ gya amo̱ se̱ nɛɛnɛɛ, ne̱ ba waa itimaa saŋ ke̱maa‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Ɔko̱ maa kyaŋŋe̱ mò̱ fetiri si na ɔ ko̱ŋ be̱ra kike bo̱ buŋ si, bɛɛɛ ɔ taa bo̱ kwe̱e̱rɔ mpaa kaase̱. Kabuno ne̱ ɔ taa a ɔ bo̱ ye̱ra, na ɔ laŋŋe̱‑rɔ ane̱ŋ ne̱ ase̱sɛ i lwee lɔŋ‑nɔ ne̱ ba nya bo̱ ŋu‑ro‑o. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Amo̱se̱‑ɔ sɛye̱ maa kwe̱e̱rɔ. Ke̱tɔ ke̱maa na ase̱ŋ ke̱maa e̱ le̱e̱ ifuri na ɔke̱maa ŋu. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Mo̱nꞌ nu ase̱ŋ ne̱ mo̱ e̱ tɔwe̱‑ɔ dame̱naŋsɛ, a le̱e̱ fe̱yɛ ɔke̱maa ne̱ o nu mo̱ ase̱ŋ timaa‑o, ne̱ ɔ kɔɔre̱ amo̱ o gyi‑o, Wuribware̱ e̱ sa mò̱ kanyiase̱ŋ bwe̱e̱tɔ na ɔ bo̱ tii kamo̱ ne̱ o de‑o si. Amaa mò̱ ne̱ o kine mo̱ ase̱ŋ amo̱‑ɔ fe̱raa, Wuribware̱ e̱ sa a ɔ paŋ mò̱ kanyiase̱ŋ kafwe̱e̱ ne̱ ɔ fa fe̱yɛ ɔ kyɔ o de‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ne̱ Yeesuu mò̱ nyi na mò̱ tire‑ana a ba mò̱ ase̱ a bo̱ bo̱ ŋu mò̱. Amaa bo̱ le̱e̱ ase̱sɛ ko̱kyɔ‑ɔ se̱‑ɔ bo̱ mo̱ŋ nya kpa yɔ mò̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","To, ne̱ ɔko̱ a tɔwe̱ gywii Yeesuu fe̱yɛ, “Ke̱e̱, fo̱ nyi na fo̱ tire‑ana ye̱re̱ kawu ba te̱e̱ fo̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ne̱ Yeesuu a tɔwe̱ gywii ase̱sɛ‑ɔ pɛɛɛ fe̱yɛ, “Bamo̱ ne̱ ba nu abware̱se̱ŋ‑ɔ, ne̱ bo̱ gya amo̱ se̱‑ɔ, ne̱ mo̱ e̱ te̱e̱ bamo̱ ɛ n na na mo̱ tire‑ana.” ");
INSERT INTO ncuNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kake ŋko̱ ne̱ Yeesuu a tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Mo̱nꞌ sa a ane̱ te̱ŋ ke̱pare̱ dabe̱‑ɔ‑rɔ yɔ nno̱ŋ a bo̱ŋbe̱‑ɔ se̱.” Ne̱ baa lwee ko̱re̱e̱‑rɔ me̱raa se̱ ba yɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bamo̱ a pare̱ ba yɔ‑ɔ, ne̱ Yeesuu a di idi ko̱re̱e̱‑ɔ‑rɔ mfe̱ŋ. Ne̱ afwii dabe̱ ko̱ a ko̱so̱ a kya nkyu‑o si mfe̱ŋ, ne̱ alaŋkpare̱ a le̱e̱ a da nkyu bo̱ waa bamo̱ ko̱re̱e̱‑ɔ‑rɔ, ne̱ ɔ kpa a ɔ bo̱rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Amo̱ fe̱raa ne̱ Yeesuu agyase̱po̱‑ɔ a ya kyiŋŋi mò̱, ne̱ baa tɔwe̱ gywii mò̱ fe̱yɛ, “Ane̱ nyaŋpe̱, ane̱ nyaŋpe̱, ane̱ e̱ kpa a ane̱ wu.” Ne̱ Yeesuu a ko̱so̱ sa kanɔ fe̱yɛ afwii‑o na alaŋkpare̱‑ɔ yɔwe̱, ne̱ aa yɔwe̱, ne̱ ke̱tɔ a waa surumm. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ŋkee ne̱ oo bise mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Nte̱tɔ se̱ ne̱ mo̱ne̱ maa kɔɔre̱ mo̱ mo̱ne̱ i gyi‑o ne̱e̱?” Ne̱ kufu a nya bamo̱, ne̱ e̱ye̱e̱ a kpe̱ŋ bamo̱, ne̱ ba ŋwiini ba gywii abɛɛ fe̱yɛ, “Nte̱tɔ se̱sɛ e̱ gye̱ ɔnyare̱ mɔ? Mò̱ ya sa kanɔ, afwii na alaŋkpare̱ gya kamo̱ se̱ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ a kya se̱ te̱ŋ‑nɔ yɔ Gadara ifuri ne̱ e̱ bo̱ Galile̱ya a ke̱pare̱ dabe̱ a nno̱ŋ a bo̱ŋbe̱‑ɔ se̱‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Yeesuu ke̱le̱e̱ ko̱re̱e̱‑ɔ‑rɔ‑ɔ, ne̱ ɔnyare̱ ko̱ ne̱ ibrisi bwe̱e̱tɔ te mò̱ se̱‑ɔ a bo̱ gyaŋŋaa mò̱. Ibrisi amo̱ a kye̱na mò̱ se̱, na ɔ naa na ɔ mo̱ŋ de̱re̱ atɔ kyee, ne̱ oo tu le̱e̱ maŋ‑nɔ ba ɔ bo̱ mfe̱ŋ ne̱ ba pure ase̱sɛ‑ɔ. Saŋ ke̱maa ne̱ ibrisi mɔ e̱ ywe̱e̱ mò̱ se̱, ne̱ ba ba agbarabi a bo̱ bo̱ ŋure mò̱ asare̱e̱‑rɔ na ayaa‑rɔ bo̱ kye̱na‑ɔ, na bo̱ ke̱e̱ mò̱ se̱‑ɔ, amɔ ɔ te̱ŋŋe̱ agbarabi‑o, na ibrisi amo̱ yaa mò̱ kimukee‑ro. To, ne̱ Yeesuu a sa kanɔ fe̱yɛ ibrisi‑o ko̱so̱ mò̱ se̱. Ne̱ ɔnyare̱ amo̱ a faa‑rɔ, ne̱ oo kpuni aŋurii Yeesuu ayaa‑rɔ, ne̱ ɔɔ faa keŋkeŋ fe̱yɛ, “Yeesuu, Nyiŋkpe̱ŋ-kyo̱ŋ-atɔ‑pɛɛɛ-Bware̱ mò̱ gyi‑o, nte̱tɔ ne̱ fo̱ e̱ kpa mo̱ ase̱? Mo̱ e̱ ko̱re̱ fo̱, fo̱ ma tɔɔraa mo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","To, ne̱ Yeesuu a bise mò̱ fe̱yɛ, “Fo̱ ke̱nyare̱ e̱ gye̱ e̱me̱ne̱?” Ne̱ ɔ yɛ, “Mo̱ e̱ gye̱ Ane̱-kyɔ-mfe̱e̱”, a kaapo̱ fe̱yɛ ibrisi bwe̱e̱tɔ te mò̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ne̱ ibrisi amo̱ a ko̱re̱ Yeesuu fe̱yɛ ɔ ma taa e̱mo̱ bo̱ waa ke̱maŋtaŋ ko̱ ne̱ ke̱ bo̱ keŋ, ne̱ ke̱ mo̱ŋ de kɛɛ, ne̱ Wuribware̱ e̱ ba a ɔ bo̱ twe̱e̱ ibrisi pɛɛɛ mɔ waa‑rɔ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Saŋ amo̱ mɔ aprako bwe̱e̱tɔ ko̱ ye̱re̱ kabe̱e̱gyi ko̱ se̱ mfe̱ŋ ba gyi. Ne̱ ibrisi‑o a ko̱re̱ Yeesuu fe̱yɛ ɔ sa a bo̱ le̱e̱ ɔnyare̱ amo̱ se̱ ya kye̱na aprako amo̱ se̱. Ne̱ ɔɔ sa e̱mo̱ kpa. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ne̱ e̱ ya ko̱so̱ ɔnyare̱ amo̱ se̱ ya kye̱na aprako‑o si, ne̱ aprako de̱maŋte̱ amo̱ a ŋwɛɛnaŋ kpo̱ro̱we̱ kabe̱e̱gyi‑o si ya le̱e̱ da nkyu‑ro wu wu. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bamo̱ ne̱ ba de̱e̱re̱ aprako amo̱ se̱‑ɔ a ŋu ke̱tɔ ne̱ kaa waa‑ɔ, ne̱ baa ŋwɛɛnaŋ yɔ maŋ‑nɔ na mmaŋgyii‑ro na adɔɔ‑rɔ ya da ase̱ŋ ne̱ aa ba‑ɔ kiboŋboŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ne̱ ase̱sɛ a le̱e̱ a bo̱ bo̱ ke̱e̱ ke̱tɔ ne̱ kaa ba‑ɔ. Ne̱ baa ba Yeesuu ase̱ bo̱ to̱ fe̱yɛ ɔnyare̱ ne̱ ibrisi dɛɛ i te mò̱ se̱‑ɔ te Yeesuu ayaa‑rɔ o buŋ atɔ, ne̱ ŋkee fe̱raa mò̱ mfɛɛre̱ du mò̱ kyɛɛkyɛɛ. Ne̱ kufu a nya bamo̱ pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ne̱ bamo̱ ne̱ baa ŋu ane̱ŋ ne̱ ɔnyare̱ amo̱ a kpaare̱‑ɔ a tɔwe̱ amo̱ ase̱ŋ gywii bamo̱ ne̱ baa sii kamɛɛ ba‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ne̱ ase̱sɛ ne̱ bo̱ bo̱ swe̱e̱re̱ amo̱ se̱‑ɔ pɛɛɛ a tɔwe̱ gywii Yeesuu fe̱yɛ ɔ le̱e̱ bamo̱ ifuri si, a le̱e̱ fe̱yɛ kufu de bamo̱. Amo̱se̱‑ɔ ne̱ Yeesuu a be̱e̱ lwee ko̱re̱e̱‑ɔ‑rɔ ɔ kpa a o kiŋŋi yɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ne̱ ɔnyare̱ ne̱ Yeesuu a gya ibrisi bo̱ ko̱so̱ mò̱ se̱‑ɔ a ko̱re̱ Yeesuu fe̱yɛ ɔ sa a mò̱ aa mò̱ a yɔ. Amaa Yeesuu a kiŋŋaa mò̱ ne̱e̱, tɔwe̱ gywii mò̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Kiŋŋi nare̱ pe̱ ya tɔwe̱ atɔ dabe̱ dabe̱ ne̱ Wuribware̱ a waa sa fo̱‑ɔ gywii fo̱ aye̱ awuye.” Ne̱ ɔnyare̱ amo̱ a kiŋŋi yɔ maŋ‑ɔ‑rɔ ya tɔwe̱ atɔ dabe̱ dabe̱ ne̱ Yeesuu a waa sa mò̱‑ɔ ase̱ŋ gywii mfe̱ŋ a ase̱sɛ‑ɔ pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Saŋ ne̱ Yeesuu a kiŋŋi ba bo̱ŋbe̱ ne̱ ɔɔ le̱e̱ mò̱ se̱ yɔ‑ɔ, ne̱ ase̱sɛ ne̱ bo̱ ye̱re̱ bo̱ gywii mò̱‑ɔ a sa mò̱ aŋsɛ na ke̱ba. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ne̱ ke̱bware̱ko̱re̱kyaŋ abre̱sɛ‑ɔ ɔko̱ ne̱ ba te̱e̱ mò̱ ɛ Yayerus‑o a ba Yeesuu ase̱ mfe̱ŋ bo̱ kpuni aŋurii Yeesuu ayaa‑rɔ ko̱re̱ mò̱ fe̱yɛ ɔ sa a bo̱ yɔ mò̱ aye̱, ");
INSERT INTO ncuNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","a le̱e̱ fe̱yɛ mò̱ kagyikye̱e̱sɛɛ ko̱ ne̱ oo gyi nsu kudu ŋnyɔ‑ɔ e̱ lɔ ɔ kpa a o wu. Kakye̱e̱sɛɛ‑ɔ wo̱re̱ kpeŋ e̱ gye̱ mò̱ gyi. Yeesuu a yɔ‑ɔ, ne̱ ase̱sɛ a kpɔwe̱ miri bo̱ gya mò̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Amɔ ɔkye̱e̱ ko̱ mɔ bo̱ bamo̱‑rɔ, ne̱ ɔ lɔ ke̱kye̱e̱tɔ bo̱ le̱e̱ fe̱yɛ kiferi ke̱maa‑rɔ ɔ taare̱ bwiino waa iluwi kanɔ ŋko̱. Waa nsu kudu ŋnyɔ ne̱e̱ fe̱yɛ mò̱ a lɔ ane̱ŋ a ko̱lɔ‑ɔ. Ɔko̱ mɔ mo̱ŋ taare̱ kya mò̱ ke̱mo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Amo̱se̱‑ɔ ne̱ oo lwee ase̱sɛ amo̱‑rɔ yɔ Yeesuu kamɛɛ ya dabo̱rɔ mò̱ waagya kanɔ, ne̱ ɔɔ kpaare̱ puri amo̱‑rɔ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ne̱ Yeesuu a bise fe̱yɛ, “Nsɛ ya dabo̱rɔ mo̱‑ɔ ne̱e̱?” Ɔke̱maa a tɔwe̱ fe̱yɛ n gye̱ mò̱ ne̱e̱‑ɔ, ne̱ Peetroo yɛ, “Mo̱ nyaŋpe̱, e̱me̱ne̱ ne̱ fo̱ i bise ane̱ŋ, na ase̱sɛ de̱maŋte̱ mɔ a muruwaa fo̱?” ");
INSERT INTO ncuNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ne̱ Yeesuu yɛ, “Amaa mo̱ a pini fe̱yɛ ɔko̱ a dabo̱rɔ mo̱, a le̱e̱ fe̱yɛ mo̱ a ŋu fe̱yɛ e̱le̱ŋ a le̱e̱ mo̱‑rɔ kya ɔko̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ɔkye̱e̱ amo̱ a ŋu fe̱yɛ ɔ maa taare̱ a ɔ taa ke̱tɔ ne̱ ɔɔ waa‑ɔ a ɔ bo̱ kwe̱e̱rɔ‑ɔ se̱‑ɔ, ne̱ ɔɔ ba Yeesuu ase̱ na ɔ yo̱ŋ, ne̱ ɔɔ bo̱ kpuni aŋurii mò̱ ayaa‑rɔ. Ase̱sɛ amo̱‑rɔ mfe̱ŋ ne̱ ɔɔ tɔwe̱ gywii Yeesuu ke̱tɔ se̱ ne̱ ɔɔ dabo̱rɔ mò̱‑ɔ na ane̱ŋ ne̱ ɔɔ kpaare̱ puri amo̱‑rɔ mfe̱ŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ne̱ Yeesuu yɛ, “Ɔpe̱kye̱e̱, bo̱ le̱e̱ ane̱ŋ ne̱ fo̱ a kɔɔre̱ mo̱ gyi‑o si‑o, fo̱ a kpaare̱. To, nare̱ dame̱naŋsɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Saŋ ne̱ Yeesuu e̱ tɔwe̱ amo̱‑ɔ, ne̱ kabɔɔ ko̱ a le̱e̱ Yayerus a lɔŋ‑ɔ‑rɔ bo̱ tɔwe̱ gywii Yayerus fe̱yɛ, “Fo̱ kakye̱e̱sɛɛ‑ɔ a wu, amo̱se̱‑ɔ fo̱ ma lɛɛ sa a ɔkaapo̱po̱‑ɔ kpo̱ne̱ mò̱ e̱ye̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Amaa Yeesuu a nu ane̱ŋ ne̱ ɔɔ tɔwe̱‑ɔ, ne̱ ɔɔ tɔwe̱ gywii Yayerus fe̱yɛ, “Fo̱ ma sa a fo̱ duŋ te̱ŋ fo̱, fo̱ fe̱raa, fo̱ ya kɔɔre̱ mo̱ gyi, ɔ kpaare̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Saŋ ne̱ baa fo̱ Yayerus a lɔŋ‑ɔ‑rɔ‑ɔ, Yeesuu mo̱ŋ sa a ɔko̱ lwee mfe̱ŋ ne̱ kakye̱e̱sɛɛ‑ɔ a wu ɔ da‑ɔ bo̱ tii mò̱ se̱, amɔ Peetroo na Yohanee na Yakubu na kakye̱e̱sɛɛ‑ɔ mò̱ se̱ na mò̱ nyi. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Bamo̱ ne̱ baa saŋ bo̱ bo̱ lɔŋ‑ɔ‑rɔ‑ɔ de̱ŋ ba su kale ba sa kakye̱e̱sɛɛ‑ɔ ne̱e̱. Ne̱ Yeesuu yɛ, “Mo̱ne̱ ma su, a le̱e̱ fe̱yɛ kakye̱e̱sɛɛ‑ɔ mo̱ŋ wu, oo di idi ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Mò̱ a tɔwe̱ ane̱ŋ‑ɔ, baa mɔse̱ mò̱ ne̱e̱, a le̱e̱ fe̱yɛ bo̱ nyi kase̱ŋtiŋ fe̱yɛ kakye̱e̱sɛɛ‑ɔ a wu. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","To, ne̱ Yeesuu a kra kakye̱e̱sɛɛ ne̱ oo wu ɔ da‑ɔ ke̱sare̱e̱‑rɔ, ne̱ ɔɔ te̱e̱ mò̱ fe̱yɛ, “Mo̱ gyi, kyiŋŋi ko̱so̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Puri amo̱‑rɔ mfe̱ŋ ne̱ oo kyiŋŋi ko̱so̱ ŋkpa na alaŋfiya‑ro. Ne̱ Yeesuu a sa kanɔ fe̱yɛ bo̱ sa kakye̱e̱sɛɛ‑ɔ ko̱tɔko̱ a o gyi. ");
INSERT INTO ncuNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ne̱ kakye̱e̱sɛɛ‑ɔ mò̱ se̱ na mò̱ nyi e̱ye̱e̱ a kpe̱ŋ bamo̱. Amaa Yeesuu yɛ bo̱ ma kaŋ tɔwe̱ ke̱tɔ ne̱ ɔɔ waa‑ɔ gywii ɔko̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ne̱ Yeesuu a te̱e̱ mò̱ agyase̱po̱ kudu anyɔ‑ɔ bo̱ gyaŋŋe̱, ne̱ ɔɔ sa bamo̱ e̱le̱ŋ a bo̱ taare̱ bo̱ gya ibrisi bo̱ ko̱so̱ ase̱sɛ se̱, na bo̱ kya alɔpo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ne̱ ŋkee oo suŋ bamo̱ bo̱ kyo̱ŋwe̱ e̱maŋ se̱ fe̱yɛ bo̱ ya tɔwe̱ Wuribware̱ a kuwure‑o‑ro ase̱ŋ, na bo̱ kya alɔpo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ne̱ a yɔ‑ɔ, ɔko̱ ma kaŋ taa ko̱tɔko̱. Mo̱ne̱ ma taa kayii nare̱se̱sɛ bɛɛɛ ko̱re̱e̱ bɛɛɛ ateese bɛɛɛ atanne̱ bɛɛɛ e̱kaare̱ ko̱ bo̱ tii e̱ko̱ ne̱ mo̱ne̱ ɔke̱maa mɔ buŋ‑o si. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mo̱ne̱ a yɔ‑ɔ, mo̱nꞌ kye̱na lɔŋ ne̱ mo̱ne̱ e̱ so̱we̱ mò̱‑rɔ ne̱ ba kra mo̱ne̱ nɛɛnɛɛ‑ɔ‑rɔ‑ɔ bo̱ fo̱ ŋke nsi ne̱ mo̱ne̱ e̱ le̱e̱ maŋ amo̱‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Amaa mo̱ne̱ ya yɔ to̱ŋ ko̱, ne̱ bamo̱ e̱ ma kpa mo̱ne̱ mfe̱ŋ, mo̱ne̱ e̱ le̱e̱ mfe̱ŋ, bamo̱ maŋ‑nɔ e̱se̱ ne̱ e̱ ya sii mo̱ne̱ ase̱be̱ta kaase̱‑ɔ gbaa, mo̱nꞌ kpo̱ŋkpaŋ e̱mo̱ bo̱ sii bamo̱ aye̱, bo̱ yii bamo̱ se̱ fe̱yɛ bamo̱ e̱bɔye̱ a sii bamo̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ne̱ agyase̱po̱‑ɔ a nare̱ e̱maŋ se̱ tɔwe̱ ase̱ŋ timaa‑o, na ba kya alɔpo̱ to̱ŋ ke̱maa ne̱ baa nare̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Saŋ ne̱ Galile̱ya swe̱e̱re̱ se̱ Owure Hɛrɔd a nu atɔ mɔ pɛɛɛ ne̱ Yeesuu a waa‑ɔ ase̱ŋ‑ɔ, ne̱ oo turi, bo̱ le̱e̱ fe̱yɛ bo̱ko̱ yɛ Yohanee Osuubɔpo̱‑ɔ ya be̱e̱ kyiŋŋi le̱e̱ lowi‑ro ba. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bo̱ko̱ mɔ yɛ Wuribware̱ a akyaamɛɛ‑ɔ ɔko̱, fe̱yɛ Iliya bɛɛɛ ɔko̱‑ɔ, a be̱e̱ kyiŋŋi ba ŋkpa‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ne̱ Hɛrɔd yɛ, “Mo̱‑ɔ mo̱ a tuwi Yohanee Osuubɔpo̱‑ɔ kuŋu, ne̱ ŋkee nsɛ gbaa ase̱ŋ ne̱ mo̱ i nu bwe̱e̱tɔ mɔ‑ɔ ne̱e̱?” Ne̱ mò̱ ke̱katɔ a pee o buwi ɔ kpa Yeesuu. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","To, ne̱ Yeesuu a agyase̱po̱ ne̱ oo suŋ bamo̱ bo̱ kyo̱ŋwe̱ e̱maŋ se̱ fe̱yɛ bo̱ ya tɔwe̱ Wuribware̱ a kuwure‑o‑ro ase̱ŋ‑ɔ a kiŋŋi ba bo̱ tɔwe̱ ke̱tɔ ke̱maa ne̱ baa waa‑ɔ gywii Yeesuu. Ne̱ ɔɔ sa ne̱ mò̱ aa bamo̱ wo̱re̱ a yɔ maŋ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Bɛtɛsaye̱da‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ase̱sɛ bwe̱e̱tɔ a nu mò̱ se̱ mfe̱ŋ‑ɔ, ne̱ baa gya mò̱ se̱. Ne̱ Yeesuu a sa bamo̱ aŋsɛ na ke̱ba, ne̱ ɔɔ tɔwe̱ Wuribware̱ a kuwure‑o‑ro ase̱ŋ gywii bamo̱, ne̱ ɔɔ be̱e̱ kya alɔpo̱ ne̱ baa ba mò̱ ase̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Amɔ kyɔwe̱ a kpa a ɔ twɛɛ‑ɔ, ne̱ mò̱ agyase̱po̱ kudu anyɔ‑ɔ a bo̱ tɔwe̱ gywii mò̱ fe̱yɛ, “Mfe̱e̱ a gye̱ e̱fa‑rɔ‑ɔ se̱‑ɔ, sa a ase̱sɛ‑ɔ yɔ mmaŋgyii na e̱maŋ ne̱ e̱ maa mfe̱e̱‑ɔ‑rɔ, na bo̱ ya kpa ateese gyi, na bo̱ buwi kpa bamo̱ e̱so̱we̱kpa.” ");
INSERT INTO ncuNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ne̱ fɔŋfɔŋ sa bamo̱ ko̱tɔko̱ a bo̱ gyi.” Ne̱ baa be̱ŋŋaa fe̱yɛ, “Bodobodoo akuri anuu na ŋkiŋgyi ŋnyɔ wo̱re̱ kpeŋ ne̱ ane̱ de mfe̱e̱, bɛɛɛ fo̱ e̱ kpa fe̱yɛ ane̱ ya sɔɔ ateese sa ase̱sɛ de̱maŋte̱ mɔ ne̱e̱ e̱e̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Bamo̱‑rɔ anyare̱‑ɔ wo̱re̱ e̱ waa ŋkpe̱ŋ nnuu. Ne̱ Yeesuu a tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Mo̱nꞌ ke ase̱sɛ‑ɔ‑rɔ bo̱ kye̱na ntuŋ si ntuŋ si, katuŋ ke̱maa ase̱sɛ e̱ waa fe̱yɛ ase̱sɛ adunuu.” ");
INSERT INTO ncuNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","16","Yeesuu agyase̱po̱‑ɔ a ke bamo̱‑rɔ bo̱ kye̱na lo̱we̱‑ɔ, ne̱ Yeesuu a taa bodobodoo akuri anuu‑o na ŋkiŋgyi ŋnyɔ‑ɔ waa mò̱ asare̱e̱‑rɔ, ne̱ ɔɔ de̱e̱re̱ so̱so̱. Ne̱ ɔɔ sa Wuribware̱ aŋsɛ we̱e̱ se̱, ne̱ ŋkee ɔɔ te̱ŋŋe̱‑rɔ bo̱ sa mò̱ agyase̱po̱‑ɔ, ne̱ baa ke‑ro sa ase̱sɛ‑ɔ pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ne̱ bamo̱ pɛɛɛ mɔ a gyi bodobodoo‑o kpo̱ne̱, ne̱ baa wo̱ ŋkiŋgyi‑o kpo̱ne̱. Ne̱ ŋkee mò̱ agyase̱po̱‑ɔ a swii bodobodoo na ŋkiŋgyi mpupuriase̱e̱ ne̱ ŋ ya saŋ‑ɔ bo̱ bo̱rɔ ake kudu anyɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kake ŋko̱ saŋ ne̱ Yeesuu a yɔ to̱ŋ ko̱ mò̱ wo̱re̱ ɔ ko̱re̱ ke̱bware̱ko̱re̱‑ɔ, ne̱ mò̱ agyase̱po̱‑ɔ a ba mò̱ ase̱ mfe̱ŋ. Ne̱ oo bise bamo̱ fe̱yɛ, “Mo̱nꞌ tɔwe̱ ane̱ŋ ne̱ ase̱sɛ e̱ te̱e̱ mo̱‑ɔ gywii mo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ne̱ baa be̱ŋŋaa mò̱ fe̱yɛ, “Wuribware̱ a akyaamɛɛ‑ɔ ɔko̱ ne̱ oo kyiŋŋi le̱e̱ lowi‑ro, fe̱yɛ Yohanee Osuubɔpo̱‑ɔ, bɛɛɛ Iliya, bɛɛɛ bamo̱‑rɔ ɔko̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ne̱ oo bise bamo̱ fe̱yɛ, “Ne̱ mo̱ne̱ mɔ mo̱ne̱ yɛ nsɛ ne̱ n gye̱‑ɔ ne̱e̱?” Ne̱ Peetroo a be̱ŋŋaa fe̱yɛ, “Fo̱ e̱ gye̱ Kristoo ne̱ Wuribware̱ a suŋ ane̱ ase̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ne̱ Yeesuu a yii bamo̱ se̱ fe̱yɛ bo̱ ma kaŋ tɔwe̱ amo̱‑ɔ gywii ɔko̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ne̱ ɔɔ kya se̱ tɔwe̱ fe̱yɛ, “A tiri fe̱yɛ mo̱, dimaadi mò̱ gyi‑o, ŋu ase̱ŋ bwe̱e̱tɔ, na maŋ abre̱sɛ na Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ na Wuribware̱ mbraa akaapo̱po̱‑ɔ pɛɛɛ mɔ kine mo̱. Ba mɔɔ mo̱, amaa ke̱mo̱ ŋke nsa, Wuribware̱ i kyiŋŋi mo̱ a ɔ le̱e̱ lowi‑ro.” ");
INSERT INTO ncuNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ne̱ ɔɔ be̱e̱ tɔwe̱ gywii lamaŋ‑ɔ fe̱yɛ, “Ɔko̱ ne̱ ɔ kpa a ɔ gya mo̱ se̱‑ɔ yɔwe̱ ko̱waa ke̱tɔ ne̱ ke̱ e̱ pre̱ mò̱‑ɔ, na ɔ so̱rɔ mò̱ fɔŋfɔŋ kiyii kpare̱-abɛɛ‑rɔ kake ke̱maa gya mo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","A le̱e̱ fe̱yɛ ɔko̱ ne̱ ɔ kpa a ɔ nya mò̱ e̱ye̱e̱ le̱e̱ lowi ase̱‑ɔ, lowi e̱ nya mò̱ nsu pɛɛɛ. Ɔko̱ mɔ ne̱ o kperi mo̱ se̱ na o wu‑o e̱ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","To̱nɔ mo̱ ne̱ se̱sɛ e̱ nya fe̱yɛ mò̱ a nya kaye̱ mɔ‑rɔ atɔ pɛɛɛ, na bo̱ le̱e̱ ane̱ŋ se̱ na ɔ paŋ kye̱nakpa Wuribware̱ ase̱? A mo̱ŋ de to̱nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ɔko̱ ne̱ ɔ maa kpa fe̱yɛ ase̱sɛ pini fe̱yɛ ɔ gye̱ mo̱ ɔgyase̱po̱‑ɔ, na ɔ maa kpa a ɔ gya mo̱ ke̱kaapo̱ se̱‑ɔ, amo̱ fe̱raa mo̱, dimaadi mò̱ gyi‑o, gbaa mo̱ i kine mò̱ kipini saŋ ne̱ Wuribware̱ a ke̱laŋŋe̱rɔ‑ɔ e̱ le̱e̱ so̱so̱ a ko̱ we̱e̱ swe̱e̱re̱ se̱, na ase̱sɛ pɛɛɛ ŋu n se̱ Wuribware̱ na mò̱ mbɔɔ a ke̱dabe̱ na wuraa‑o na mo̱, dimaadi mò̱ gyi‑o, lee‑o saŋ ne̱ mo̱ aa Wuribware̱ a mbɔɔ‑ɔ e̱ ba‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ bo̱ko̱ bo̱ mfe̱e̱ ne̱ bo̱ maa wu, amɔ ba ŋu ane̱ŋ ne̱ Wuribware̱ a kuwure‑o du‑o pwɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Waa ŋke mburuwa a kyo̱ŋ fe̱yɛ Yeesuu a tɔwe̱ ase̱ŋ mɔ‑ɔ, ne̱ oo lee Peetroo na Yohanee na Yakubu, ne̱ mò̱ aa bamo̱ a yɔ ke̱be̱e̱ ko̱ se̱ na bo̱ ya ko̱re̱ ke̱bware̱ko̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Saŋ ne̱ Yeesuu e̱ ko̱re̱ ke̱bware̱ko̱re̱ mfe̱ŋ‑ɔ, ne̱ mò̱ akatɔ‑rɔ a kyurowi, ne̱ mò̱ atɔ buŋsɛ a buruwi pare̱pare̱pare̱ a to̱re̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Puri amo̱‑rɔ ne̱ baa ŋu fe̱yɛ anyare̱ anyɔ ko̱ ye̱re̱ na bamo̱ aa Yeesuu e̱ sa se̱ŋsa. Abɛɛ anyɔ amo̱ e̱ gye̱ Wuribware̱ mbraa ɔsapo̱ Mosis na Wuribware̱ kyaamɛɛ Iliya. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Wuribware̱ so̱so̱ a ke̱laŋŋe̱rɔ‑ɔ e̱ laŋŋe̱ bamo̱ se̱, na bamo̱ aa Yeesuu e̱ tɔwe̱ ane̱ŋ ne̱ a ya saŋ kafwe̱e̱ fe̱yɛ o wu Yɛro̱salɛm maŋ‑nɔ ane̱ŋ ne̱ Wuribware̱ a kra fe̱yɛ o wu‑o. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pwɛɛ ne̱ amo̱ pɛɛɛ a ba‑ɔ, Peetroo na mò̱ ko̱so̱bɛɛ‑ana anyɔ‑ɔ a di idi. Amaa bamo̱ a kyiŋŋi‑o, ne̱ baa ŋu Yeesuu a ke̱dabe̱ na wuraa‑o na anyare̱ anyɔ amo̱ ne̱ bamo̱ aa mò̱ ye̱re̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Saŋ ne̱ anyare̱ amo̱ e̱ yɔ ba yɔwe̱ Yeesuu‑o, ne̱ Peetroo yɛ, “Mo̱ nyaŋpe̱, a bware fɛɛ fe̱yɛ ane̱ a bo̱ mfe̱e̱. Ane̱ e̱ waa abwii asa, fo̱ ko̱ko̱ŋko̱, Mosis ko̱ko̱ŋko̱ na Iliya mɔ ko̱ko̱ŋko̱.” Ke̱tɔ ne̱ ɔɔ tɔwe̱‑ɔ mo̱ŋ de kaase̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Na Peetroo saŋ ɔ sa se̱ŋsa‑ɔ, ne̱ ko̱wo̱re̱ ko̱ kuyayu a le̱e̱ so̱so̱ bo̱ dɔŋŋɔ bamo̱ se̱. Ne̱ kufu a nya Yeesuu agyase̱po̱‑ɔ saŋ ne̱ ko̱wo̱re̱ amo̱ i buŋ bamo̱ se̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ne̱ bo̱re̱ ko̱ a le̱e̱ ko̱wo̱re̱‑ɔ‑rɔ tɔwe̱ fe̱yɛ, “Mo̱nꞌ ke̱e̱ mo̱ gyi ne̱ mo̱ a lee‑o. Mo̱nꞌ nu mò̱ ase̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Saŋ ne̱ bo̱re̱ amo̱ a laatɔ‑ɔ, ne̱ aa saŋ Yeesuu wo̱re̱. Yeesuu agyase̱po̱‑ɔ a laa amo̱‑ɔ pɛɛɛ tɔ. Ke̱tɔ ne̱ baa ŋu saŋ amo̱‑ɔ, bo̱ mo̱ŋ tɔwe̱ gywii ɔko̱, amɔ ke̱tɔ a bo̱ kyee‑o. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ke̱mo̱ kaye̱ ŋke‑o ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱ asa‑ɔ a le̱e̱ ke̱be̱e̱‑ɔ se̱, ne̱ ase̱sɛ de̱maŋte̱ ko̱ a ba bo̱ gyaŋŋaa Yeesuu. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ne̱ ɔnyare̱ ko̱ a tɔwe̱ keŋkeŋ le̱e̱ ase̱sɛ‑ɔ‑rɔ fe̱yɛ, “Ɔkaapo̱po̱, mo̱ e̱ ko̱re̱ fo̱ ne̱e̱, de̱e̱re̱ mo̱ gyi nyaŋsɛ kpeŋ ne̱ n de‑o sa mo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ibrisi ko̱ te mò̱ se̱, ne̱ e̱mo̱ ya ba mò̱ se̱, amɔ ɔ fɛɛ‑rɔ, na e̱ twe̱e̱ mò̱ bo̱ da swe̱e̱re̱ fe̱yɛ mò̱ a lɔ kigbuŋgbuŋ‑o, na ɔ twe̱e̱ mò̱ asare̱e̱ na ayaa, na mò̱ kanɔ‑rɔ e̱ le̱e̱ afwii. Saŋ ke̱maa mò̱ e̱ye̱e̱ se̱ e̱ swaa swaa pwɛɛ na e̱ dɛɛ yuri mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mo̱ a ko̱re̱ fo̱ agyase̱po̱‑ɔ fe̱yɛ bo̱ gya ibrisi amo̱ bo̱ ko̱so̱ mò̱ se̱ pɛɛɛ, bamo̱ mɔ bo̱ mo̱ŋ taare̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ne̱ Yeesuu a tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Ke̱se̱bɔrɔle̱ŋ awuye, mo̱ne̱ maa kɔɔre̱ mo̱ mo̱ne̱ i gyi. Nsu mfe̱ne̱ ne̱ mo̱ne̱ e̱ kpa fe̱yɛ mo̱ aa mo̱ne̱ a kye̱na? Bɛɛɛ nsu mfe̱ne̱ ne̱ mo̱ne̱ e̱ kpa fe̱yɛ ŋ nyite mo̱ne̱ pwɛɛ na mo̱nꞌ dɛɛ kɔɔre̱ mo̱ gyi?” Ne̱ ɔɔ tɔwe̱ gywii ɔnyare̱‑ɔ fe̱yɛ, “Taa fo̱ gyi nyaŋsɛ‑ɔ baa mfe̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kanyaŋsɛɛ amo̱ a yɔ Yeesuu ase̱‑ɔ, ne̱ ibrisi amo̱ ne̱ i te mò̱ se̱‑ɔ a twe̱e̱ mò̱ bo̱ da swe̱e̱re̱ fe̱yɛ mò̱ a lɔ kigbuŋgbuŋ‑o, ne̱ ɔɔ twe̱e̱ mò̱ asare̱e̱ na ayaa. Ne̱ Yeesuu a sa kanɔ fe̱yɛ ibrisi‑o ko̱so̱ kanyaŋsɛɛ‑ɔ se̱. Ne̱ Yeesuu a kya mò̱, ne̱ ɔɔ kpaare̱, ne̱ Yeesuu a kiŋŋaa mò̱ sa mò̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ne̱ ke̱tɔ ne̱ Yeesuu a waa‑ɔ a kpe̱ŋ ase̱sɛ‑ɔ e̱ye̱e̱. Ne̱ baa ŋu ane̱ŋ ne̱ Wuribware̱ a ke̱yaale̱ŋ‑ɔ kyɔ‑ɔ. Bamo̱ a saŋ ba fa ke̱tɔ ke̱maa ne̱ ɔɔ waa‑ɔ mfɛɛre̱‑ɔ, ne̱ Yeesuu a tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mo̱ne̱ ma kaŋ taŋ ke̱tɔ ne̱ mo̱ e̱ kpa a n tɔwe̱ gywii mo̱ne̱‑ɔ se̱. Ba taa mo̱, dimaadi mò̱ gyi‑o, a bo̱ waa swe̱e̱re̱ mɔ se̱ ayaale̱ŋpo̱ ke̱sare̱e̱‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Amaa mò̱ agyase̱po̱‑ɔ mo̱ŋ nu ke̱tɔ ne̱ ɔɔ tɔwe̱‑ɔ kaase̱. Ne̱ kufu mɔ de bamo̱ na bo̱ bise mò̱ ase̱ŋ‑ɔ kaase̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ne̱ Yeesuu agyase̱po̱‑ɔ wo̱re̱ wo̱re̱ i gyiiri bamo̱ ke̱bre̱sɛ se̱ ikii. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yeesuu mɔ nyi bamo̱ mfɛɛre̱‑ɔ se̱‑ɔ, ne̱ ɔɔ kra kayaagyi ko̱ baa bo̱ ye̱ra mò̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Ɔke̱maa ne̱ mo̱ ke̱nyare̱‑rɔ ɔ kra ane̱ŋ a kayaagyi mɔ nɛɛnɛɛ‑ɔ e̱ kra mo̱ nɛɛnɛɛ ne̱e̱, ne̱ mò̱‑ɔ mò̱ ne̱ ɔ kra mo̱ nɛɛnɛɛ‑ɔ a kaapo̱ ne̱e̱ fe̱yɛ ɔɔ kra mò̱ ne̱ oo suŋ mo̱ bo̱ kyo̱ŋwe̱‑ɔ nɛɛnɛɛ dɛɛ ne̱e̱. Amo̱se̱‑ɔ, ɔko̱ ne̱ ɔ gye̱ kagyingyii mo̱ne̱ pɛɛɛ‑rɔ e̱ gye̱ ɔbre̱sɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ne̱ Yohanee, ne̱ ɔ gye̱ Yeesuu agyase̱po̱‑ɔ ɔko̱‑ɔ, yɛ, “Ane̱ nyaŋpe̱, ane̱ a ŋu ɔko̱ de fo̱ ke̱nyare̱ ɔ gya ibrisi ɔ ko̱so̱ ase̱sɛ se̱. Ne̱ ane̱ a gya mò̱ fe̱yɛ ɔ yɔwe̱ ane̱ŋ ko̱waa bo̱ le̱e̱ fe̱yɛ ɔ mo̱ŋ tii ane̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ne̱ Yeesuu a tɔwe̱ gywii mò̱ aa mò̱ bɛɛko̱‑ana agyase̱po̱‑ɔ fe̱yɛ, “Mo̱ne̱ ma lɛɛ gya mò̱, a le̱e̱ fe̱yɛ ɔke̱maa ne̱ ɔ mo̱ŋ gye̱ mo̱ne̱ ɔdo̱ŋ‑ɔ bo̱ mo̱ne̱ ke̱be̱gya ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ne̱ Yeesuu nyi dame̱naŋsɛ fe̱yɛ amo̱ ya waa kafwe̱e̱‑ɔ, saŋ e̱ fo̱ fe̱yɛ ɔ yɔ Yɛro̱salɛm maŋ‑nɔ, na o wu, na o kyiŋŋi le̱e̱ lowi‑ro, na ɔ yɔ Wuribware̱ se̱. Amo̱se̱ ne̱ ɔɔ waa mò̱ mfɛɛre̱ ne̱ ɔɔ de̱e̱ kpa se̱ ɔ yɔ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ne̱ oo suŋ mbɔɔ bo̱ gye̱ ŋkpɛɛ, ne̱ baa yɔ Samariya kamaŋgyii ko̱‑rɔ na bo̱ ya kpa to̱ŋ ko̱ lɔŋŋɔ bo̱ ye̱ra mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Amaa kamaŋgyii amo̱‑rɔ a ase̱sɛ‑ɔ maa kra mò̱ nɛɛnɛɛ, bo̱ le̱e̱ fe̱yɛ baa de̱ŋ ŋu fe̱yɛ ɔ kpa a ɔ bo̱rɔ yɔ Yɛro̱salɛm maŋ‑nɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Amɔ mò̱ agyase̱po̱‑ɔ Yakubu na Yohanee a ŋu ane̱ŋ ne̱ ase̱sɛ amo̱ a waa‑ɔ, ne̱ bo̱ yɛ, “Ane̱ nyaŋpe̱, ane̱ ya sa ne̱ de̱e̱kpa a le̱e̱ so̱so̱ bo̱ kywɛɛ bamo̱ kpuri, a pre̱ fo̱ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ne̱ Yeesuu a buruwaa tɔwe̱ gywii bamo̱ fe̱yɛ ane̱ŋ a mfɛɛre̱‑ɔ mo̱ŋ bo̱ daŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ne̱ mò̱ aa mò̱ agyase̱po̱ amo̱ a kyo̱ŋ be̱e̱ yɔ kamaŋgyii ko̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Saŋ ne̱ bo̱ naa ba yɔ‑ɔ, ne̱ ɔnyare̱ ko̱ a tɔwe̱ gywii Yeesuu fe̱yɛ, “To̱ŋ ke̱maa ne̱ fo̱ e̱ yɔ‑ɔ, mo̱ e̱ gya fo̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ne̱ Yeesuu a tɔwe̱ gywii ɔnyare̱‑ɔ fe̱yɛ, “Sabraŋ‑nɔ igyono de idikpa, ne̱ mbo̱gyii de asaa bo̱ da‑rɔ, amaa mo̱, dimaadi mò̱ gyi‑o, fe̱raa mo̱ŋ de mfe̱ŋ ne̱ mo̱ i di a n kyure‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ne̱ Yeesuu a be̱e̱ tɔwe̱ gywii ɔnyare̱ ko̱ fe̱yɛ, “Gya mo̱ se̱.” Ne̱ ɔnyare̱‑ɔ yɛ, “Mo̱ nyaŋpe̱, sa a ŋ kiŋŋi yɔ pe̱ na ŋ ya pure n se̱ pwɛɛ na n dɛɛ be̱e̱ bo̱ gya fo̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ne̱ Yeesuu a ba ke̱kpare̱ bo̱ be̱ŋŋaa mò̱ fe̱yɛ, “Bamo̱ ne̱ bo̱ mo̱ŋ te kakye̱na po̱pwɛɛ‑ɔ, bamo̱ e̱ de̱ŋ bo̱ pure bamo̱ ako̱we̱bɛɛ ne̱ ba ba a bo̱ bo̱ wu‑o. Na fo̱ fe̱raa fo̱ nare̱ ya tɔwe̱ Wuribware̱ a kuwure‑o‑ro ase̱ŋ gywii ase̱sɛ pɛɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ne̱ ɔnyare̱ ko̱ mɔ a be̱e̱ tɔwe̱ gywii Yeesuu fe̱yɛ, “Mo̱ nyaŋpe̱, mo̱ e̱ gya fo̱ se̱, amaa sa a ŋ ya kra mo̱ ko̱we̱bɛɛ‑ana pwɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ne̱ Yeesuu a be̱ŋŋaa mò̱ fe̱yɛ, “Ɔke̱maa ne̱ ɔ naa na ɔ de̱e̱re̱ kamɛɛ‑rɔ‑ɔ maa taare̱ a ɔ waa Wuribware̱ a kuwure‑o kusuŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Amo̱‑ɔ kamɛɛ‑rɔ‑ɔ ne̱ Yeesuu a be̱e̱ lee ase̱sɛ adusunoo na anyɔ, na o suŋ bamo̱ anyɔ anyɔ fe̱yɛ bo̱ gye̱ ŋkpɛɛ yɔ e̱maŋ se̱ na to̱ŋ ke̱maa ne̱ mò̱ fɔŋfɔŋ e̱ kpa a ɔ bo̱ yɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Yaabraa ke̱te̱ŋŋe̱ kyɔ bwe̱e̱tɔ, ate̱ŋŋe̱po̱ mɔ mo̱ŋ kyɔ. Amo̱se̱‑ɔ mo̱nꞌ ko̱re̱ ko̱dɔɔ wuye‑o na o buwi ate̱ŋŋe̱po̱ bwe̱e̱tɔ bo̱ kyo̱ŋwe̱ mo̱ne̱ na bo̱ kya mo̱ne̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","To, mo̱nꞌ nare̱ mfe̱ŋ ne̱ mo̱ a kaapo̱ mo̱ne̱‑ɔ. Amaa mo̱nꞌ nyiŋŋi si fe̱yɛ mo̱ i suŋ mo̱ne̱ mo̱ e̱ kyo̱ŋwe̱ ne̱e̱ fe̱yɛ nsanne̱gyii ne̱ ba ya lwee akwaare̱‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mo̱ne̱ ma kaŋ taa atanne̱ kabɔɔte̱e̱, na ko̱re̱e̱, na ase̱be̱ta bo̱ gya mo̱ne̱ e̱ye̱e̱ se̱. Na mo̱ne̱ ma be̱e̱ ye̱re̱ kpa‑rɔ ka ɔko̱ kanɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Pwɛɛ ne̱ mo̱ne̱ i lwee lɔŋ ke̱maa‑rɔ‑ɔ, mo̱nꞌ gye̱ ŋkpɛɛ ka kanɔ. Na mo̱nꞌ tɔwe̱ fe̱yɛ, ‘Wuribware̱ yure lɔŋ mɔ‑rɔ ase̱sɛ.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ne̱ se̱sɛ timaa e̱ bo̱ lɔŋ‑ɔ‑rɔ, ne̱ mò̱ ya kɔɔre̱ mo̱ne̱ kanɔka fe̱raa, na mo̱nꞌ so̱we̱ lɔŋ‑ɔ‑rɔ mfe̱ŋ. Na Wuribware̱ yure lɔŋ wuye amo̱. Ne̱ mfe̱ŋ ne̱ bamo̱ e̱ mo̱ŋ kɔɔre̱ mo̱ne̱ kanɔka fe̱raa, na mo̱nꞌ kyo̱ŋ lɔŋ amo̱ se̱. Wuribware̱ maa yure lɔŋ wuye amo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mo̱nꞌ so̱we̱ lɔŋ ne̱ ba kɔɔre̱ mo̱ne̱ kanɔka nɛɛnɛɛ‑rɔ‑ɔ, na mo̱nꞌ gyi ateese ke̱maa ne̱ ba nya a bo̱ sa mo̱ne̱‑ɔ, a le̱e̱ fe̱yɛ ɔke̱maa ne̱ o suŋ kusuŋ‑o de kakɔka. Na mo̱nꞌ so̱we̱ lɔŋ ko̱ŋko̱‑rɔ, mo̱ne̱ ma nare̱ so̱we̱ e̱lɔŋ‑nɔ kaa. ");
INSERT INTO ncuNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ne̱ maŋ ne̱ mo̱ne̱ ya yɔ mò̱ se̱, ne̱ baa sure si kra mo̱ne̱ nɛɛnɛɛ‑ɔ, na mo̱nꞌ gyi ateese ke̱maa ne̱ ba nya a bo̱ sa mo̱ne̱ mfe̱ŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Na mo̱nꞌ kya alɔpo̱ mfe̱ŋ, na mo̱nꞌ tɔwe̱ gywii ase̱sɛ‑ɔ fe̱yɛ, ‘Wuribware̱ a kuwure‑o e̱ kpa a ko̱ tɔ‑rɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Amaa mo̱ne̱ ya yɔ maŋ ko̱ se̱ ne̱ bamo̱ e̱ mo̱ŋ kra mo̱ne̱ nɛɛnɛɛ fe̱raa, mo̱nꞌ le̱e̱ mfe̱ŋ yɔ kabo̱re̱ se̱, na mo̱nꞌ tɔwe̱ gywii bamo̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Mo̱ne̱ maŋ‑nɔ a e̱se̱ ne̱ e̱ ya sii ane̱ ayaapapaa kaase̱‑ɔ gbaa, ane̱ e̱ kpɛɛ e̱mo̱ a ane̱ bo̱ sii mo̱ne̱ aye̱ bo̱ yii mo̱ne̱ se̱, amaa mo̱nꞌ nyiŋŋi si fe̱yɛ Wuribware̱ a kuwure‑o a tɔ‑rɔ ne̱ ke̱ e̱ kpa a ko̱ kyo̱ŋ gbaa.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ saŋ ne̱ Wuribware̱ e̱ ba a ɔ bo̱ gyi ase̱sɛ ase̱ŋ‑ɔ, o gyiiri maŋ amo̱ ase̱sɛ ke̱se̱bɔ a ɔ kyo̱ŋ ane̱ŋ ne̱ o gyiiri Sɔdɔm awuye ke̱se̱bɔ‑ɔ, ase̱sɛ ne̱ bo̱ le̱e̱ bamo̱ e̱bɔye̱ se̱, Wuribware̱ a kpuri bamo̱ maŋ de̱daa‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Mo̱ne̱ Isireelii awuye ne̱ mo̱ne̱ te Korasiŋ na Bɛtɛsaye̱da e̱maŋ‑nɔ‑ɔ, mo̱ne̱ a kine kikiŋŋi le̱e̱ mo̱ne̱ e̱bɔye̱‑rɔ. Ane̱ŋ se̱‑ɔ, ŋke nsi ne̱ Wuribware̱ i gyi ase̱sɛ pɛɛɛ ase̱ŋ‑ɔ, mo̱ne̱ i ŋu ase̱ŋ ne̱e̱ fɛɛ. A le̱e̱ fe̱yɛ atɔ dabe̱ ne̱ mo̱ a waa mo̱ne̱ aye̱‑ɔ ne̱ mo̱ a dɛɛ waa amo̱ Tiro na Sidɔŋ e̱maŋ ne̱ e̱ mo̱ŋ bo̱ Isireelii swe̱e̱re̱ se̱‑ɔ‑rɔ ne̱e̱, weetee mfe̱ŋ a awuye‑o a kyɔ waa ke̱mo̱ ne̱ ke̱ e̱ kaapo̱ fe̱yɛ baa nu bamo̱ e̱ye̱e̱ kiŋŋi le̱e̱ bamo̱ e̱bɔye̱‑ɔ‑rɔ‑ɔ kyee. ");
INSERT INTO ncuNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kake ne̱ Wuribware̱ i gyi ase̱sɛ pɛɛɛ ase̱ŋ‑ɔ, o gyiiri mo̱ne̱ ke̱se̱bɔ a ɔ kyo̱ŋ Tiro na Sidɔŋ e̱maŋ awuye. ");
INSERT INTO ncuNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mo̱ne̱ Isireelii awuye ne̱ mo̱ne̱ te Kapaaniyum maŋ‑nɔ‑ɔ mɔ, mo̱ne̱ e̱ kpa fe̱yɛ mo̱nꞌ yase̱ mo̱ne̱ e̱ye̱e̱ yaa Wuribware̱ se̱ ne̱e̱ e̱e̱e̱? Wuribware̱ e̱ twe̱e̱ mo̱ne̱ a ɔ bo̱ kyo̱ŋwe̱ mfe̱ŋ ne̱ o gyiiri e̱bɔye̱ awaapo̱ ke̱se̱bɔ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ne̱ Yeesuu a tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Mo̱ne̱ e̱ yɔ, mo̱nꞌ nyiŋŋi si fe̱yɛ ɔke̱maa ne̱ oo nu mo̱ne̱ ase̱ŋ ne̱ ɔ kɔɔre̱ a o gyi‑o a kɔɔre̱ mo̱ gyi ne̱e̱, ne̱ ɔke̱maa ne̱ oo kine mo̱ne̱‑ɔ a kine mo̱ ne̱e̱, ne̱ ɔke̱maa ne̱ mò̱‑ɔ mò̱ a kine mo̱‑ɔ a kine mò̱ ne̱ oo suŋ mo̱‑ɔ ne̱e̱.” Mò̱ a sa se̱ŋsa gywii bamo̱ lo̱we̱‑ɔ, ne̱ ɔɔ sa bamo̱ kpa a bo̱ nare̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ne̱ ase̱sɛ adusunoo na anyɔ‑ɔ a kiŋŋi ba Yeesuu ase̱, na bamo̱ akatɔ a gyi. Ne̱ baa bo̱ tɔwe̱ gywii mò̱ fe̱yɛ, “Ane̱ nyaŋpe̱, ane̱ a ya ba fo̱ ke̱nyare̱ bo̱ tɔwe̱ ase̱ŋ‑ɔ, ibrisi gbaa a bu ane̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “Mo̱ne̱ a ŋu aaa? Mo̱ne̱ a yɔ na mo̱ne̱ e̱ gya ibrisi mo̱ne̱ e̱ ko̱so̱ ase̱sɛ se̱‑ɔ, mo̱ a ŋu Ɔbɔnsam ne̱ ɔ gye̱ e̱mo̱ ɔgye̱ŋkpɛɛpo̱‑ɔ a le̱e̱ da kirim, fe̱yɛ ane̱ŋ ne̱ e̱lɛɛlɛɛ e̱ le̱e̱ so̱so̱ e̱e̱ ba swe̱e̱re̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","To, mo̱nꞌ nu mfe̱e̱. Mo̱ a sa mo̱ne̱ Ɔbɔnsam se̱ ke̱yaale̱ŋ na mo̱nꞌ kɔ mò̱ gyi si, na mo̱nꞌ ya kyikye awɔ na agyapureepu si saŋ ke̱maa, na sɛye̱ ma waa mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mo̱ne̱ ma sa a mo̱ne̱ akatɔ gyi fe̱yɛ ibrisi a bu mo̱ne̱, amaa mo̱nꞌ sa a mo̱ne̱ akatɔ gyi bwe̱e̱tɔ fe̱yɛ Wuribware̱ a kyo̱rɛɛ mo̱ne̱ anyare̱ bo̱ be̱ya so̱so̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Saŋ amo̱‑ɔ, amɔ Wuribware̱ a kufwiiŋe timaa‑o a sa ne̱ Yeesuu akatɔ a gyi, ne̱ ɔ yɛ, “N se̱, so̱so̱ na swe̱e̱re̱ owure, mo̱ e̱ sa fo̱ aŋsɛ fe̱yɛ fo̱ a taa ke̱tɔ ne̱ fo̱ a bo̱ kwe̱e̱rɔ anyiase̱ŋpo̱ se̱‑ɔ bo̱ kaapo̱ bamo̱ ne̱ bo̱ mo̱ŋ nyi ase̱ŋ bwe̱e̱tɔ‑ɔ. N se̱, mo̱ a ŋu kase̱ŋtiŋ si, ane̱ŋ ne̱ fo̱ a kpa fe̱yɛ fo̱ waa‑ɔ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ne̱ ɔɔ tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “N se̱ a taa ke̱tɔ ke̱maa bo̱ waa mo̱ ke̱sare̱e̱‑rɔ. Ɔke̱maa mɔ mo̱ŋ nyi ane̱ŋ ne̱ n du‑o, amɔ n se̱ ne̱ ɔ bo̱ so̱so̱‑ɔ wo̱re̱, ne̱ ɔke̱maa mɔ mo̱ŋ nyi ane̱ŋ ne̱ n se̱ du‑o, amɔ mo̱ aa bamo̱ ne̱ bo̱ du fe̱yɛ mo̱ne̱‑ɔ, ne̱ mo̱ a lee fe̱yɛ bo̱ gyii mò̱‑ɔ wo̱re̱ kpeŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ne̱ Yeesuu a lee mò̱ agyase̱po̱‑ɔ keri si, na ɔko̱ ma nya nu. Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ne̱ de ŋyure fe̱yɛ mo̱ne̱ a bo̱ mfe̱e̱ mo̱ne̱ i ŋu atɔ mɔ ne̱ mo̱ne̱ i ŋu‑o. ");
INSERT INTO ncuNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ Wuribware̱ akyaamɛɛ na awure ko̱ gbaa a kpa fe̱yɛ bo̱ ŋu ke̱tɔ ne̱ mo̱ne̱ i ŋu‑o, bamo̱‑ɔ bo̱ mo̱ŋ nya ke̱mo̱ ŋu. Ne̱ baa kpa fe̱yɛ bo̱ nu ase̱ŋ ne̱ mo̱ne̱ i nu‑o, bamo̱‑ɔ bo̱ mo̱ŋ nya amo̱ mɔ nu.” ");
INSERT INTO ncuNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Saŋ ko̱ ne̱ Wuribware̱ mbraa ɔkaapo̱po̱ ko̱ a ba Yeesuu ase̱ na ɔ bo̱ kyɔ mò̱‑rɔ ke̱e̱ fe̱yɛ mò̱ abware̱se̱ŋ ke̱kaapo̱ bo̱ daŋ aaa. Ne̱ ɔnyare̱ amo̱ a bise fe̱yɛ, “Ɔkaapo̱po̱, e̱me̱ne̱ ne̱ mo̱ e̱ waa na ŋ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ne̱ Yeesuu a be̱ŋŋaa mò̱ fe̱yɛ, “E̱me̱ne̱ ne̱ abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ baa tɔwe̱? Mo̱nꞌ tɔwe̱ gywii mo̱ ane̱ŋ ne̱ baa kyo̱rɛɛ amo̱ mfe̱ŋ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ne̱ Wuribware̱ mbraa ɔkaapo̱po̱‑ɔ yɛ, “Baa kyo̱rɛɛ fe̱yɛ, ‘Lee fo̱ kame‑ro ba fo̱ kakpo̱nɔ na fo̱ ke̱yaale̱ŋ na fo̱ mfɛɛre̱ pɛɛɛ bo̱ kpa fo̱ nyaŋpe̱ Wuribware̱ ase̱ŋ.’ ‘na fo̱ ke̱maa kpa fo̱ bɛɛko̱ ase̱ŋ, fe̱yɛ ane̱ŋ ne̱ fo̱ e̱ kpa fo̱ e̱ye̱e̱‑ɔ.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ne̱ Yeesuu yɛ, “Kase̱ŋtiŋ ne̱ fo̱ a tɔwe̱‑ɔ. Fo̱ ya waa ane̱ŋ, fo̱ e̱ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Wuribware̱ mbraa ɔkaapo̱po̱ amo̱ a kpa a ɔ kaapo̱ fe̱yɛ mò̱ se̱ŋbise‑o a baare‑o si‑o, ne̱ ɔɔ be̱e̱ bise Yeesuu fe̱yɛ, “Ne̱ nsɛ e̱ gye̱ mo̱ bɛɛko̱‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ne̱ Yeesuu mɔ a ba kitee mɔ bo̱ be̱ŋŋaa mò̱. Ɔ yɛ, “N gye̱ ɔnyare̱ ko̱ ya dɛɛ kye̱na aaa? Ne̱ kake ko̱ ɔɔ ko̱so̱ le̱e̱ Yɛro̱salɛm maŋ‑nɔ ɔ yɔ Yɛrikoo maŋ‑nɔ. Ne̱ ayu ko̱ a kra mò̱ kpa‑rɔ mfe̱ŋ, ne̱ baa gye̱ra mò̱ bo̱ da, ne̱ baa ywii mò̱ atɔ pɛɛɛ, na mò̱ atɔ buŋsɛ gbaa, ne̱ baa da mò̱ waa yɔre̱yɔre̱, ne̱ baa yɔwe̱ mò̱ bo̱ be̱ya mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kafwe̱e̱‑ɔ ne̱ Wuribware̱ ɔlɔŋŋɔpo̱ ko̱ a ba ɔ kyo̱ŋ kpa amo̱ se̱ mfe̱ŋ dɛɛ. Mò̱ a ŋu ɔnyare̱ amo̱ da kpa‑rɔ mfe̱ŋ‑ɔ, ne̱ ɔɔ kwaye̱ mò̱ kyo̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ane̱ŋ dɛɛ ne̱ Lewii awuye ne̱ ba kya Wuribware̱ alɔŋŋɔpo̱ bamo̱ kusuŋ‑no‑o ɔko̱ a bo̱ to̱ ɔnyare̱ amo̱ mfe̱ŋ, ne̱ ɔɔ ya de̱e̱re̱ mò̱ kwaye̱ kyo̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Amaa Samariyanyi ko̱ fe̱raa naa kpa amo̱ se̱, ne̱ ɔɔ bo̱ to̱ ɔnyare̱‑ɔ na ɔ da. Mo̱ne̱ nyi fe̱yɛ Samariya awuye mɔ na ane̱ Isireelii awuye i kisi abɛɛ. Amaa Samariyanyi mɔ fe̱raa, mò̱ a ŋu ɔnyare̱ amo̱ da kpa‑rɔ ɔ kpa a o wu‑o, ne̱ mò̱ ase̱ŋ a waa mò̱ e̱wɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ne̱ ɔɔ yɔ mfe̱ŋ ne̱ ɔ da‑ɔ, ne̱ ɔɔ ba nta na mfɔ bo̱ waa kadwii bo̱ me̱ra mò̱ e̱lɔ‑ɔ se̱, ne̱ oo ŋure e̱mo̱ se̱, ne̱ ɔɔ yase̱ ɔnyare̱‑ɔ bo̱ kye̱na mò̱ fɔŋfɔŋ a kuruma ne̱ ɔ de̱e̱‑ɔ se̱, ne̱ ɔɔ taa mò̱ yaa afɔ a so̱we̱kpa‑ɔ ya ke̱e̱ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ke̱mo̱ kaye̱ ŋke‑o ne̱ oo lee siidii adunyɔ bo̱ sa afɔ lɔŋ ɔde̱e̱re̱se̱po̱‑ɔ, ne̱ ɔɔ tɔwe̱ gywii mò̱ fe̱yɛ ɔ bo̱ de̱e̱re̱ ɔlɔpo̱ amo̱ se̱ sa mò̱. Ne̱ ɔ yɛ, ‘Mo̱ ke̱bo̱ kiŋŋi ba‑rɔ‑ɔ, ne̱ fo̱ ya be̱e̱ nye̱ra atanne̱ kanɔ ŋke̱maa mò̱ kuŋu si bo̱ tii si, mo̱ e̱ ka fo̱.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ne̱ Yeesuu a tɔwe̱ bo̱ gye̱ kɛɛ fe̱yɛ, “To, abɛɛ asa mɔ‑rɔ, bamo̱ nsɛ ya kaapo̱ fe̱yɛ ɔnyare̱ ne̱ ayu‑o a da mò̱‑ɔ gye̱ mò̱ bɛɛko̱‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ne̱ Wuribware̱ mbraa ɔkaapo̱po̱‑ɔ yɛ, “Mò̱ ne̱ ɔɔ waa ɔnyare̱ amo̱ ke̱dame̱naŋsɛ‑ɔ.” Ne̱ Yeesuu yɛ, “Amo̱ fe̱raa, nare̱ na fo̱ ya waa ane̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Saŋ ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ a kya bamo̱ kpa‑ɔ se̱ ba yɔ‑ɔ, ne̱ baa ya fo̱ maŋ ko̱ ne̱ ɔkye̱e̱ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Maataa‑ɔ te mò̱‑rɔ‑ɔ se̱. Ne̱ Yeesuu a so̱we̱ ɔkye̱e̱ amo̱ aye̱, ne̱ ɔɔ kra mò̱ nɛɛnɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Maataa‑ɔ mɔ de mò̱ tire ko̱ ne̱ ba te̱e̱ mò̱ ɛ Mariya, ne̱ o te Yeesuu ayaa‑rɔ mfe̱ŋ o nu ase̱ŋ ne̱ Yeesuu e̱ tɔwe̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ane̱ŋ ne̱ mò̱ afɔ kyɔ‑ɔ se̱‑ɔ, ne̱ ateese ke̱de̱ŋa a tɔɔraa Maataa. Ne̱ ɔɔ yɔ Yeesuu ase̱ ya tɔwe̱ gywii mò̱ fe̱yɛ, “Mo̱ nyaŋpe̱, amɔ fo̱ ase̱ a bware fe̱yɛ mo̱ tire a yɔwe̱ kusuŋ mɔ pɛɛɛ bo̱ dɔŋŋɔ mo̱ se̱ aaa? Tɔwe̱ gywii mò̱ fe̱yɛ ɔ ko̱so̱ bo̱ kya mo̱‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ne̱ Yeesuu yɛ, “Oo! Oo! Maataa, fo̱ e̱ tɔɔraa fo̱ e̱ye̱e̱ atɔ bwe̱e̱tɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ke̱tɔ ko̱ŋko̱ e̱ bo̱‑rɔ ne̱ ki tiri, ne̱ fo̱ taa fo̱ mfɛɛre̱ bo̱ dɔŋŋɔ se̱. Ke̱mo̱ ne̱ Mariya e̱ waa mbe̱yɔmɔ. Ke̱tɔ ne̱ oo lee a ɔ waa‑ɔ ne̱e̱. Ane̱ŋ se̱‑ɔ ma tɔwe̱ a n gywii mò̱ fe̱yɛ ɔ yɔwe̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kake ŋko̱ ne̱ Yeesuu a yɔ to̱ŋ ko̱ ɔ ko̱re̱ ke̱bware̱ko̱re̱. Mò̱ a ko̱re̱ ke̱bware̱ko̱re̱‑ɔ lo̱we̱‑ɔ, ne̱ mò̱ agyase̱po̱‑ɔ ɔko̱ a tɔwe̱ gywii mò̱ fe̱yɛ, “Ane̱ nyaŋpe̱, kaapo̱ ane̱ ane̱ŋ ne̱ ane̱ ko̱re̱ ke̱bware̱ko̱re̱, fe̱yɛ ane̱ŋ ne̱ Yohanee a kaapo̱ mò̱ agyase̱po̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ne̱ Yeesuu a be̱ŋŋaa mò̱ fe̱yɛ, “Mo̱ne̱ e̱ ko̱re̱ ke̱bware̱ko̱re̱, mo̱nꞌ tɔwe̱ fe̱yɛ, ‘Ane̱ se̱ Wuribware̱, sa a bo̱ kyo̱rɔ fo̱ ke̱nyare̱ timaa. Na fo̱ baa fo̱ kuwure‑o bo̱ gyi mfe̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Sa ane̱ ateese ne̱ a tiri ane̱ ndɔɔ na kake ke̱maa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Na fo̱ taa ane̱ e̱bɔye̱ bo̱ ke ane̱, bo̱ le̱e̱ fe̱yɛ ane̱ de ɔke̱maa ne̱ ɔ waa ane̱ e̱bɔye̱‑ɔ lee ane̱ i ke mò̱. Na fo̱ ma sa kpa a Ɔbɔnsam kyɔ ane̱‑rɔ ke̱e̱ fe̱yɛ ane̱ e̱ waa e̱bɔye̱ aaa.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Ne̱ Yeesuu a kya se̱ tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Mo̱nꞌ taa fe̱yɛ fo̱ ko̱ a yɔ fo̱ nyare̱ ko̱ aye̱ kaye̱ nse̱na ya tɔwe̱ gywii mò̱ fe̱yɛ, ‘Mo̱ nyare̱, mo̱ nyare̱ ko̱ i tu kpa, ne̱ ɔɔ bo̱ so̱we̱ mo̱ aye̱ kanye mɔ, mo̱‑ɔ mo̱ŋ de ateese ko̱ na m bo̱ sa mò̱ a o gyi. Amo̱se̱‑ɔ mo̱ e̱ ko̱re̱ fo̱ ne̱e̱ fe̱yɛ fo̱ para mo̱ bodobodoo akuri asa kpeŋ.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","To, mo̱nꞌ be̱e̱ taa ke̱mo̱ fe̱yɛ fo̱ nyare̱ ne̱ fo̱ a ko̱re̱ mò̱‑ɔ a tɔwe̱ fe̱yɛ, ‘Fo̱ ma tɔɔraa mo̱. Mo̱ a kyɔ twe̱e̱ mo̱ ke̱kyaŋ‑nɔ, ne̱ mo̱ aa mo̱ gyi‑ana pɛɛɛ a di. Amo̱se̱‑ɔ ma taare̱ a ŋ ko̱so̱ sa fo̱ ko̱tɔko̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mò̱ a gye̱ fo̱ nyare̱‑ɔ gbaa ooo, oo kine ke̱kya fo̱‑rɔ. Amo̱se̱ se̱‑ɔ fo̱ e̱ le̱e̱ mfe̱ŋ a fo̱ yɔwe̱ ko̱tɔɔraa mò̱ aaa? Daabii. Mo̱ e̱ tɔwe̱ mo̱ i gywii fo̱ fe̱yɛ, ipeere e̱ mo̱ŋ de fo̱ fe̱yɛ fo̱ me̱raa se̱ ko̱re̱ mò̱, lalalo̱we̱‑ɔ ɔ ko̱so̱ na ɔ sa fo̱ ke̱tɔ ke̱maa ne̱ fo̱ a tɔwe̱ fe̱yɛ fo̱ e̱ kpa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ane̱ŋ se̱‑ɔ mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ, mo̱ne̱ ya ko̱re̱ Wuribware̱ atɔ, mo̱ne̱ e̱ nya ke̱tɔ ne̱ mo̱ne̱ e̱ kpa‑ɔ. Mo̱ne̱ ya buwi, mo̱ne̱ i ŋu ke̱tɔ ne̱ mo̱ne̱ e̱ kpa‑ɔ. Mo̱ne̱ ya ye̱re̱ kawu te̱e̱ mò̱, ɔ taye̱ po̱ne̱‑ɔ na mo̱nꞌ lweero. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","A le̱e̱ fe̱yɛ ɔke̱maa ne̱ ɔ ko̱re̱‑ɔ e̱ nya, ne̱ ɔke̱maa ne̱ o buwi‑o mɔ i ŋu, na po̱ne̱ taye̱ sa ɔke̱maa ne̱ ɔ ye̱re̱ kawu ɔ te̱e̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","M be̱e̱ taa fe̱yɛ mo̱ne̱ nsɛ mò̱ gyi e̱ gye̱ ne̱ ɔ tɔwe̱ fe̱yɛ ɔ kpa kakiŋgyi a ɔ wo̱, ne̱ ɔ taa ko̱wɔ a ɔ bo̱ sa mò̱? ");
INSERT INTO ncuNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Bɛɛɛ nsɛ mò̱ gyi e̱ gye̱ ne̱ ɔ tɔwe̱ a o gywii mò̱ se̱ fe̱yɛ ɔ kpa ko̱kɔɔte̱e̱ a ɔ wo̱, ne̱ ɔ sa mò̱ gyapureepu? ");
INSERT INTO ncuNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mo̱ne̱ ne̱ mo̱ne̱ gye̱ ase̱sɛ bɔye̱-ɔ gbaa nyi e̱sa mo̱ne̱ gyi-ana atɔ timaa, saŋbo̱to̱ Wuribware̱, mo̱ne̱ se̱ ne̱ ɔ bo̱ so̱so̱-ɔ, e̱ gye̱ ne̱, mo̱ne̱ ya ko̱re̱ mò̱ fe̱yɛ ɔ sa mo̱ne̱ mò̱ kufwiiŋe timaa-o, ne̱ ɔ maa taare̱ a ɔ sa mo̱ne̱ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Saŋ ko̱ Yeesuu a gya ibrisi ko̱ ne̱ e̱ maa taare̱ a e̱ sa se̱ŋsa, ne̱ i te ɔnyare̱ ko̱ se̱‑ɔ le̱e̱ mò̱ se̱. Ibrisi amo̱ a le̱e̱ mò̱ se̱‑ɔ, ne̱ ɔnyare̱‑ɔ a le̱e̱ ɔ sa se̱ŋsa. Ne̱ ase̱sɛ pɛɛɛ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ e̱ye̱e̱ a kpe̱ŋ bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Amaa ase̱sɛ‑ɔ bo̱ko̱ yɛ, “Yeesuu mɔ gye̱ se̱sɛ bɔye̱ ne̱e̱. Ɔbɔnsam ne̱ bo̱ be̱e̱ ba te̱e̱ mò̱ ɛ Biil-sibul‑o e̱ gye̱ ne̱ o de ibrisi si ke̱yaale̱ŋ, ne̱ ɔ sa Yeesuu e̱le̱ŋ fe̱yɛ ɔ gya ibrisi bo̱ ko̱so̱ ase̱sɛ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bo̱ko̱ mɔ a kpa a bo̱ kyɔ Yeesuu‑ro ke̱e̱‑ɔ se̱‑ɔ, ne̱ baa tɔwe̱ gywii mò̱ fe̱yɛ ɔ waa akpe̱ŋe̱ye̱e̱tɔ ko̱ bo̱ kaapo̱ bamo̱ fe̱yɛ Wuribware̱ ya sa mò̱ ke̱yaale̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Amaa Yeesuu a ŋu ke̱tɔ ne̱ ba fa‑ɔ se̱‑ɔ, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “E̱kɔ ya lwee maŋ‑nɔ, ne̱ maŋ‑ɔ ya ke‑ro, amɔ maŋ amo̱ i bwee ne̱e̱, ane̱ŋ dɛɛ ne̱ kabuno ya ke‑ro, ne̱ ka bwee. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Amo̱se̱‑ɔ amo̱ e̱ gye̱ kase̱ŋtiŋ fe̱yɛ Ɔbɔnsam na mò̱ kamɛɛ‑rɔ awuye a ke‑ro, ke̱ maa kyee na mò̱ kuwure‑o kpuri. Mo̱ne̱ yɛ n de Biil-sibul ne̱ ɔ gye̱ Ɔbɔnsam‑ɔ e̱le̱ŋ mo̱ e̱ gya ibrisi. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Amaa ŋ nyi fe̱yɛ mo̱ne̱ agyase̱po̱‑ɔ bo̱ko̱ e̱ gya ibrisi ba ko̱so̱ ase̱sɛ se̱. Nte̱tɔ e̱le̱ŋ ne̱ bo̱ de? Ɔbɔnsam a e̱le̱ŋ‑ɔ bɛɛɛ Wuribware̱ lee‑o? A gye̱ Wuribware̱ a e̱le̱ŋ‑ɔ ne̱ bo̱ de, bɛɛɛ? To, mo̱ne̱ agyase̱po̱ amo̱ fɔŋfɔŋ gbaa a kaapo̱ fe̱yɛ mo̱ne̱ a fo̱ kpa. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Amo̱ e̱ gye̱ fe̱yɛ Wuribware̱ ke̱yaale̱ŋ ne̱ n de mo̱ e̱ gya ibrisi‑o si‑o, a kaapo̱ ne̱e̱ fe̱yɛ Wuribware̱ a kuwure‑o a kyɔ ba mo̱ne̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","M be̱e̱ taa fe̱yɛ Ɔbɔnsam du fe̱yɛ ɔyaale̱ŋpo̱ ne̱ o de mò̱ ado̱ŋtɔ ne̱ o de ɔ de̱e̱re̱ mò̱ fɔŋfɔŋ lɔŋ se̱‑ɔ. O nyi fe̱yɛ mò̱ kapo̱tɛɛ a nya ye̱re̱ kpa timaa. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Amaa m fe̱raa n du ne̱e̱ fe̱yɛ ɔko̱ ne̱ ɔ kyɔ ɔyaale̱ŋpo̱ amo̱ e̱le̱ŋ, ne̱ ɔɔ da mò̱ kɔɔre̱ mò̱ ado̱ŋtɔ ne̱ mò̱ e̱le̱ŋ dɔŋ se̱‑ɔ nare̱, na mò̱ aa mò̱ nyare̱‑ana a ke atɔ ne̱ oo swii nare̱‑ɔ‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Amo̱se̱‑ɔ mo̱ i yii mo̱ne̱ se̱ fe̱yɛ mo̱ne̱ ɔke̱maa ne̱ ɔ mo̱ŋ ye̱re̱ mo̱ kamɛɛ‑ɔ gye̱ mo̱ do̱ŋ ne̱e̱. Ne̱ ɔke̱maa mɔ ne̱ ɔ maa kya mo̱‑rɔ na ŋ kpɔwe̱ ase̱sɛ bwe̱e̱tɔ bo̱ tii mo̱ e̱ye̱e̱ se̱‑ɔ mɔ e̱ brawe̱ bamo̱‑rɔ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ne̱ Yeesuu yɛ, “Ibrisi ya ko̱so̱ se̱sɛ se̱, amɔ e̱ naa e̱ kaa e̱fa‑rɔ e̱e̱ kpa to̱ŋ ko̱ a e̱ kye̱na kyure. E̱mo̱ e̱ mo̱ŋ nya to̱ŋ ko̱, amɔ e̱e̱ fa e̱mo̱ mfɛɛre̱ fe̱yɛ ii kiŋŋi a e̱ yɔ lɔŋ ne̱ baa gya e̱mo̱ le̱e̱ mò̱‑rɔ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Na i kiŋŋi ya to̱ fe̱yɛ lɔŋ amo̱‑rɔ bo̱ daŋ ɔ mo̱ŋ de iyisi. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Na e̱ le̱e̱ ya kpa ibrisi isunoo ne̱ e̱ bo̱ le̱ŋ e̱ kyɔ e̱mo̱ fɔŋfɔŋ‑ɔ, na e̱ bo̱ kye̱na mfe̱ŋ. Ibrisi lɔŋ e̱ gye̱ se̱sɛ. To, amɔ e̱mo̱ a waa isunoo i te se̱sɛ amo̱ se̱ se̱‑ɔ, amɔ se̱sɛ a ko̱lɔ‑ɔ a waa ko̱kyɔ kyo̱ŋ saŋ ne̱ ibrisi ko̱ŋko̱ e̱ gye̱ ne̱ ki te mò̱ se̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Saŋ ne̱ Yeesuu a tɔwe̱ amo̱‑ɔ, ne̱ ase̱sɛ ne̱ bo̱ ye̱re̱ ba nu Yeesuu ase̱‑ɔ amo̱‑rɔ ɔkye̱e̱ ko̱ a tɔwe̱ fe̱yɛ, “Ɔkye̱e̱ ne̱ ɔɔ nya kame ko̱we̱ fo̱, ne̱ ɔɔ nyapo̱ fo̱‑ɔ de ŋyure.” ");
INSERT INTO ncuNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ne̱ Yeesuu a be̱ŋŋaa mò̱ fe̱yɛ, “Kase̱ŋtiŋ ne̱e̱. Amaa bamo̱ ne̱ ba nu abware̱se̱ŋ ne̱ ba bu amo̱, ne̱ bo̱ gya se̱‑ɔ de Wuribware̱ ŋyure bo̱ kyo̱ŋ ɔkye̱e̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Saŋ amo̱, ase̱sɛ a tii si ne̱ bo̱ ye̱re̱ muruwaa Yeesuu‑o, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Ndɔɔ a kaye̱ mɔ‑rɔ ase̱sɛ gye̱ ase̱sɛ bɔye̱. Bo̱ yɛ ŋ waa akpe̱ŋe̱ye̱e̱tɔ ko̱ bo̱ kaapo̱ bamo̱. Amaa ma waa, amɔ Yonaa akpe̱ŋe̱ye̱e̱tɔ wo̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ane̱ŋ ne̱ ke̱tɔ ne̱ kaa waa Yonaa‑o a lee Wuribware̱ ke̱yaale̱ŋ bo̱ kaapo̱ Niniwee awuye ne̱ baa kye̱na Yonaa mbe̱e̱ se̱‑ɔ, ane̱ŋ dɛɛ ne̱ ke̱tɔ ne̱ ke̱ e̱ waa mo̱, dimaadi mò̱ gyi‑o, i lee Wuribware̱ ke̱yaale̱ŋ a m bo̱ kaapo̱ ndɔɔ a kaye̱ mɔ‑rɔ a ase̱sɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ŋke nsi ne̱ Wuribware̱ i gyi ase̱sɛ pɛɛɛ ase̱ŋ‑ɔ, owurekye̱e̱ ko̱ ne̱ ɔɔ le̱e̱ kyɔwe̱ le̱e̱kpa kigyise si a swe̱e̱re̱ ko̱ se̱‑ɔ e̱ ko̱so̱ a ɔ ye̱re̱, na ɔ po̱rɔ mo̱ne̱ ndɔɔ a kaye̱ mɔ‑rɔ a ase̱sɛ‑ɔ, na o bu mo̱ne̱ ke̱pɔ. A le̱e̱ fe̱yɛ oo tu kpa le̱e̱ hare̱e̱ mò̱ aye̱ ba ane̱ ɔde̱daapo̱ Owure Solomɔŋ ase̱ mfe̱e̱ bo̱ nu owure amo̱ a kanyiase̱ŋ ase̱ŋ‑ɔ. Amaa mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ ɔko̱ a ba, ne̱ ɔ ye̱re̱ mo̱ne̱ akatɔ‑rɔ, ne̱ ɔ kyɔ Solomɔŋ. Ne̱ mo̱ne̱ a kine kunu mò̱ kanyiase̱ŋse̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Kake nsi ne̱ Wuribware̱ i gyi ɔke̱maa ase̱ŋ‑ɔ, Niniwee awuye e̱ ko̱so̱ a bo̱ ye̱re̱ po̱rɔ mo̱ne̱ ndɔɔ a kaye̱ mɔ‑rɔ ase̱sɛ‑ɔ, na bo̱ bu mo̱ne̱ ke̱pɔ, a le̱e̱ fe̱yɛ bamo̱ a nu Yonaa a abware̱se̱ŋ ne̱ ɔɔ tɔwe̱‑ɔ, baa nu bamo̱ e̱ye̱e̱, ne̱ baa kiŋŋi le̱e̱ bamo̱ e̱bɔye̱‑rɔ. Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ ɔko̱ a ba, ne̱ ɔ ye̱re̱ mo̱ne̱ akatɔ‑rɔ, ne̱ ɔ kyɔ Yonaa. Ne̱ mo̱ne̱ a kine kunu mò̱ abware̱se̱ŋ ko̱tɔwe̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ne̱ Yeesuu a be̱e̱ tɔwe̱ fe̱yɛ, “Ɔko̱ maa kyaŋŋe̱ mò̱ fetiri si na ɔ taa bo̱ kwe̱e̱rɔ, bɛɛɛ ɔ be̱ra kike bo̱ buŋ si. Kabuno ne̱ ɔ taa a ɔ bo̱ ye̱ra, na ɔ laŋŋe̱‑rɔ ane̱ŋ ne̱ ase̱sɛ i lwee lɔŋ‑nɔ ne̱ ba nya bo̱ ŋu‑ro‑o. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Fo̱ fetiri e̱ bo̱ daŋ, ɔ laŋŋe̱ lɔŋ‑ɔ‑rɔ pɛɛɛ. Ne̱ mò̱ ya nye̱ra fe̱raa, kibugyii e̱ da fo̱ lɔŋ‑ɔ‑rɔ. Ane̱ŋ dɛɛ ne̱ fo̱ akatɔ e̱ bo̱ daŋ, fo̱ ke̱e̱ nɛɛnɛɛ. Amaa amo̱ e̱ mo̱ŋ ke̱e̱ fe̱raa, a du ne̱e̱ fe̱yɛ fo̱ a te kibugyii‑ro‑o. Ke̱laŋŋe̱rɔ maa taare̱ a ki yii fo̱ akatɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Amo̱se̱ se̱‑ɔ mo̱ne̱ ne̱ mo̱ne̱ yɛ mo̱ne̱ ŋkpo̱nɔ‑rɔ a fwiiri‑o, mo̱nꞌ sa se̱. Nsaŋse̱ mo̱ne̱ e̱ pe̱nna mo̱ne̱ e̱ye̱e̱ ne̱e̱, mo̱ne̱ ŋkpo̱nɔ‑rɔ mo̱ŋ bo̱ daŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Amaa mo̱ne̱ i de ŋkpo̱nɔfwiiri lo̱we̱ fe̱raa, a du ne̱e̱ fe̱yɛ fetiri a laŋŋe̱ mo̱ne̱ ŋyo̱wɔre̱ pɛɛɛ se̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Saŋ ne̱ Yeesuu a sa se̱ŋsa lo̱we̱‑ɔ, ne̱ Farisiinyi ko̱ a te̱e̱ mò̱ fe̱yɛ ɔ ba mò̱ aye̱ na ɔ bo̱ gyi ateese. Amo̱se̱‑ɔ ne̱ ɔɔ yɔ mfe̱ŋ o te o gyi. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ne̱ Farisiinyi‑o e̱ye̱e̱ a kpe̱ŋ mò̱ fe̱yɛ Yeesuu a mo̱ŋ fwe̱e̱ asare̱e̱ bamo̱ mbraa‑ɔ kpa se̱ pwɛɛ ne̱ ɔ dɛɛ o gyi‑o. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Amo̱ fe̱raa ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Mo̱ne̱ Farisii awuye fe̱raa, mo̱ne̱ du ne̱e̱ fe̱yɛ ase̱sɛ ne̱ ba fwe̱e̱ bamo̱ ato̱re̱nkyu na e̱gyare̱ mmɛɛ, amaa mo̱ne̱ maa fwe̱e̱ amo̱ mme‑ro. Mo̱ne̱ e̱ lɔŋŋɔ mo̱ne̱ ŋyo̱wɔre̱, amaa apoo na bo̱ro̱kɔɔne̱ ya bo̱rɔ mo̱ne̱ ŋkpo̱nɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mfɛɛre̱ ke̱‑mo̱ŋ‑de awuye. N gye̱ Wuribware̱ ne̱ ɔɔ waa se̱sɛ kayo̱wɔre̱ se̱‑ɔ dɛɛ ya waa mò̱ kayo̱wɔre̱‑rɔ aaa? ");
INSERT INTO ncuNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mo̱nꞌ ke atiripo̱ ke̱tɔ ne̱ mo̱ne̱ de‑o na a mo̱ŋ bo̱ mo̱ne̱ gya. Mo̱ne̱ ya waa ane̱ŋ fe̱raa, mo̱ne̱ ŋkpo̱nɔ‑rɔ mo̱ŋ lɛɛ n de iyisi. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Mo̱ne̱ Farisii awuye, mo̱ne̱ i ŋu ase̱ŋ ŋke ŋko̱ fɛɛ. Bo̱ le̱e̱ fe̱yɛ mo̱ne̱ gya Wuribware̱ mbraa ne̱ ŋ yɛ mo̱nꞌ taa mo̱ne̱ adɔɔteese ke̱maa hare̱e̱ alɛɛfo̱ gbaa ntuŋkare̱ kudu ke̱maa‑rɔ katuŋ ko̱ŋko̱ na mo̱nꞌ bo̱ lɔŋŋɔ Wuribware̱ saŋ ke̱maa, amaa mo̱ne̱ mo̱ŋ de kase̱ŋtiŋ, ne̱ mo̱ne̱ be̱e̱ mo̱ne̱ maa kpa Wuribware̱ ase̱ŋ pɛɛɛ‑ɔ. Ane̱ŋ a atɔ mɔ e̱ gye̱ ne̱ a bware fe̱yɛ mo̱nꞌ waa, na mo̱ne̱ ma yɔwe̱ adɔɔteese a ntuŋkare̱ kudu‑ro kako̱ŋko̱‑ɔ ke̱taa sa Wuribware̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Mo̱ne̱ Farisii awuye, mo̱ne̱ i ŋu ase̱ŋ ŋke ŋko̱ fɛɛ, bo̱ le̱e̱ fe̱yɛ ngya dabe̱ dabe̱ se̱ ne̱ mo̱ne̱ e̱ kpa ke̱kye̱na mo̱ne̱ ke̱bware̱ko̱re̱ akyaŋ‑nɔ, ne̱ mo̱ne̱ be̱e̱ mo̱ne̱ e̱ kpa fe̱yɛ ase̱sɛ gyɔŋŋɔ ka mo̱ne̱ nnɔ lamaŋ‑nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mo̱ne̱ i ŋu ase̱ŋ ŋke ŋko̱ fɛɛ. Mo̱ne̱ du ne̱e̱ fe̱yɛ ke̱gye̱raŋta ne̱ ase̱sɛ mo̱ŋ lɛɛ bo̱ nyi ke̱mo̱ ase̱ŋ‑ɔ. Ɔko̱ ya kyikye ke̱gye̱raŋta se̱, ne̱ mò̱ gbaa mo̱ŋ nyi fe̱yɛ ke̱gye̱raŋta ne̱e̱, ɔ waa mò̱ e̱ye̱e̱ iyisi.” ");
INSERT INTO ncuNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ne̱ Wuribware̱ mbraa akaapo̱po̱‑ɔ ɔko̱ yɛ, “Ɔkaapo̱po̱, fo̱ e̱ tɔwe̱ amo̱ ane̱ŋ fe̱raa, fo̱ e̱ saare̱ ane̱ fo̱ i tii si ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ne̱ Yeesuu a be̱ŋŋaa fe̱yɛ, “Ane̱ŋ dɛɛ ne̱ mo̱ne̱ Wuribware̱ mbraa akaapo̱po̱ gbaa i ŋu ase̱ŋ ŋke ŋko̱ fɛɛ. A le̱e̱ fe̱yɛ mo̱ne̱ de mo̱ne̱ fɔŋfɔŋ ananatɔ mo̱ne̱ i tii Wuribware̱ a mbraa‑ɔ se̱, na mo̱nꞌ nya sa a mmo̱ ke̱gyase̱ waa le̱ŋ sa ase̱sɛ. Amaa mo̱ne̱ fɔŋfɔŋ fe̱raa maa kya bamo̱‑rɔ na bo̱ gya mmo̱ se̱. A du ne̱e̱ fe̱yɛ mo̱ne̱ a taa e̱tɔso̱rɔ dwiidwiisɛ bo̱ so̱rɔ bamo̱, ne̱ mo̱ne̱ mɔ mo̱ne̱ maa so̱rɔ a mo̱nꞌ kya bamo̱‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mo̱ne̱ i ŋu ase̱ŋ ŋke ŋko̱ fɛɛ. Bo̱ le̱e̱ fe̱yɛ Wuribware̱ akyaamɛɛ ne̱ mo̱ne̱ ade̱daapo̱ a mɔɔ‑ɔ agye̱raŋta ne̱ mo̱ne̱ mɔ mo̱ne̱ de siimeetii mo̱ne̱ e̱ laa amo̱ nɛɛnɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Amo̱se̱‑ɔ mo̱ne̱ gbaa mo̱ne̱ a sure ke̱tɔ ne̱ mo̱ne̱ ade̱daapo̱ a waa‑ɔ se̱, bo̱ le̱e̱ fe̱yɛ bamo̱ ya mɔɔ Wuribware̱ a akyaamɛɛ‑ɔ, ne̱ mo̱ne̱ mɔ mo̱ne̱ a waa bamo̱ agye̱raŋta. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Fe̱yɛ Wuribware̱ mò̱ kanyiase̱ŋ se̱ a tɔwe̱ fe̱yɛ, ‘Mo̱ i suŋ mo̱ akyaamɛɛ na mo̱ ayaa‑rɔ aye̱re̱po̱ a m bo̱ kyo̱ŋwe̱ bamo̱ ase̱, amaa ba mɔɔ bamo̱ bo̱ko̱, na bo̱ waa bo̱ko̱ mɔ awo̱re̱fɔɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Ke̱tɔ ne̱ ke̱ bo̱‑rɔ‑ɔ e̱ gye̱ fe̱yɛ Wuribware̱ e̱ ba bamo̱ ne̱ baa mɔɔ mò̱ akyaamɛɛ‑ɔ pɛɛɛ a ke̱se̱bɔgyiiri ne̱ ɔ kaa a ɔ bo̱ gyiiri bamo̱‑ɔ bo̱ gyiiri mo̱ne̱ ndɔɔ a kaye̱ mɔ‑rɔ a ase̱sɛ‑ɔ ke̱se̱bɔ. Kase̱ŋtiŋ si, le̱e̱ saŋ ne̱ baa mɔɔ Abɛl ne̱ ɔ gye̱ se̱sɛ ne̱ baa gye̱ ŋkpɛɛ e̱mɔɔ‑ɔ, bo̱ fo̱ saŋ ne̱ baa mɔɔ Sakariya Wuribware̱ suŋkpa‑ɔ kanɔ na lɔŋŋɔkpa‑ɔ mbo̱ŋtɔ‑rɔ‑ɔ, Wuribware̱ akyaamɛɛ mɔ pɛɛɛ ke̱mɔɔ‑ɔ ke̱se̱bɔgyiiri dɔŋ mo̱ne̱ se̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mo̱ne̱, Wuribware̱ mbraa akaapo̱po̱ mɔ, mo̱ne̱ i ŋu ase̱ŋ ŋke ŋko̱ fɛɛ. A le̱e̱ fe̱yɛ mo̱ne̱ a twe̱e̱ ke̱kyaŋ ne̱ kanyiase̱ŋ bo̱ ke̱mo̱‑rɔ‑ɔ‑rɔ, ne̱ mo̱ne̱ a kɔɔre̱ safo̱wa‑ɔ bo̱ be̱ya. Mo̱ne̱ maa lweero, mo̱ne̱ mɔ mo̱ne̱ a waa ane̱ŋ se̱‑ɔ, mo̱ne̱ a tii bamo̱ bwe̱e̱tɔ ne̱ ba kpa a bo̱ taare̱ lweero mfe̱ŋ‑ɔ kpa.” ");
INSERT INTO ncuNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Saŋ ne̱ Yeesuu a le̱e̱ mfe̱ŋ ne̱ ɔ ye̱re̱ ɔ sa se̱ŋsa mɔ‑ɔ, ne̱ Wuribware̱ mbraa akaapo̱po̱‑ɔ na Farisii awuye‑o e̱ po̱rɔ mò̱, ne̱ ba bise mò̱ atɔ bwe̱e̱tɔ ase̱ŋ ba kpa ane̱ŋ ne̱ ɔ waa a ɔ tɔwe̱ ase̱ŋ bɔye̱ ko̱ na ɔ nya lwee bamo̱ ase̱ŋ‑nɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Saŋ ne̱ ase̱sɛ ŋkpe̱ŋ ŋkpe̱ŋ a bo̱ gyaara abɛɛ se̱ Yeesuu ase̱‑ɔ, ne̱ ɔɔ gye̱ ŋkpɛɛ tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Mo̱nꞌ sa Farisii awuye si, a le̱e̱ fe̱yɛ yiisi ne̱ bo̱ de ba waa bodobodoo‑ro‑o mo̱ŋ bo̱ kɔne̱. Amo̱‑ɔ e̱ kaapo̱ ne̱e̱ fe̱yɛ bo̱ de mfɛɛre̱ bɔye̱ ba kwe̱e̱rɔ. Mo̱ne̱ ma kaŋ kii nnɔ ŋnyɔ ŋnyɔ awuye‑o fe̱yɛ bamo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","A le̱e̱ fe̱yɛ ke̱tɔ ke̱maa ne̱ mo̱ne̱ a buŋ si‑o i buŋŋi si, na ke̱tɔ ke̱maa ne̱ mo̱ne̱ a taa bo̱ kwe̱e̱rɔ‑ɔ le̱e̱ ifuri. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Amo̱se̱ ke̱tɔ ke̱maa ne̱ mo̱ne̱ a tɔwe̱ bo̱ kwe̱e̱rɔ kanye kibugyii‑ro‑o e̱ le̱e̱ ifuri mpase̱. Na ke̱se̱ŋ ke̱maa ne̱ mo̱ne̱ a ŋwiini mo̱ne̱ akyaŋ‑nɔ‑ɔ le̱e̱ kawu yɔ lamaŋ‑nɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ne̱ Yeesuu yɛ, “Mo̱ nyare̱‑ana, mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ mo̱ne̱ ma kaŋ se̱re̱ bamo̱ ne̱ ba kpa a bo̱ mɔɔ mo̱ne̱‑ɔ, a le̱e̱ fe̱yɛ bamo̱ ya mɔɔ mo̱ne̱, bo̱ maa lɛɛ taare̱ a bo̱ waa mo̱ne̱ sɛye̱. To, mo̱ e̱ kaapo̱ mo̱ne̱ ɔko̱ ne̱ mo̱nꞌ se̱re̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mo̱nꞌ se̱re̱ Wuribware̱. Ne̱ mò̱ ya mɔɔ mo̱ne̱, ne̱ ke̱mo̱ kamɛɛ‑rɔ o de e̱le̱ŋ fe̱yɛ ɔ be̱e̱ kywɛɛ mo̱ne̱ de̱e̱kpa ne̱ oo kure bo̱ be̱ya e̱bɔye̱ awaapo̱‑ɔ‑rɔ. Kase̱ŋtiŋ, Wuribware̱ wo̱re̱ ne̱ a tiri fe̱yɛ mo̱nꞌ se̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","N gye̱ e̱paso̱wa aduna ne̱ bo̱ de ba sɔɔ nte̱ye̱te̱ye̱ nnuu aaa? Wuribware̱ mɔ maa taŋ mmo̱ kako̱ŋko̱ gbaa se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Mo̱nꞌ nu fe̱yɛ Wuribware̱ a kare̱ ipwii ne̱ i te mo̱ne̱ aŋu si‑o, ne̱ oo ŋu e̱mo̱ kanɔ. Amo̱se̱‑ɔ mo̱ne̱ ma sa a kufu nya mo̱ne̱, a le̱e̱ fe̱yɛ nte̱ye̱te̱ye̱ ŋkpe̱ŋ ŋkpe̱ŋ mo̱ŋ fo̱ mo̱ne̱ ɔko̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ, ɔke̱maa ne̱ ɔ nya kakpo̱nɔ na ɔ tɔwe̱ lamaŋ‑nɔ fe̱yɛ o tii mo̱ se̱‑ɔ, mo̱, dimaadi mò̱ gyi‑o, gbaa e̱ waa mò̱ ane̱ŋ Wuribware̱ a mbɔɔ‑ɔ akatɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ne̱ ɔko̱ ne̱ mò̱ ya kine mo̱ lamaŋ‑nɔ‑ɔ, mo̱, dimaadi mò̱ gyi‑o, gbaa i kine mò̱ Wuribware̱ a mbɔɔ‑ɔ akatɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ɔke̱maa ne̱ ɔ tɔwe̱ ke̱se̱ŋ bɔye̱ ko̱ bo̱ kye mo̱, dimaadi mò̱ gyi‑o, Wuribware̱ e̱ taare̱ taa bo̱ ke mò̱. Amaa ɔke̱maa mɔ ne̱ ɔ tɔwe̱ ase̱ŋ bɔye̱ bo̱ kye Wuribware̱ a kufwiiŋe timaa‑o fe̱raa, Wuribware̱ maa taa bɔye̱ amo̱ a ɔ bo̱ ke se̱sɛ‑ɔ daa. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ne̱ bamo̱ ya yaa mo̱ne̱ se̱ŋgyikpa, hare̱e̱ ke̱bware̱ko̱re̱kyaŋ abre̱sɛ ase̱ bɛɛɛ awure ase̱ bɛɛɛ maŋ agye̱ŋkpɛɛpo̱ ase̱ ooo, mo̱ne̱ ma kaŋ sa a ane̱ŋ ne̱ mo̱ne̱ e̱ ya kya kanɔ‑ɔ na ane̱ŋ ne̱ mo̱ne̱ e̱ ya tɔwe̱ ase̱ŋ mfe̱ŋ‑ɔ tɔɔraa mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","A le̱e̱ fe̱yɛ Wuribware̱ a kufwiiŋe timaa‑o e̱ kaapo̱ ke̱tɔ bɛɛɛ ase̱ŋ ne̱ mo̱nꞌ tɔwe̱ mfe̱ŋ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ne̱ ase̱sɛ ne̱ ba nu Yeesuu ase̱‑ɔ amo̱‑rɔ ɔnyare̱ ko̱ a tɔwe̱ gywii Yeesuu fe̱yɛ, “Ɔkaapo̱po̱, tɔwe̱ gywii mo̱ daa fe̱yɛ ɔ sa a mo̱ aa mò̱ ke kapo̱tɛɛ ne̱ ane̱ se̱ a wu yɔwe̱ sa ane̱‑ɔ‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ne̱ Yeesuu a be̱ŋŋaa fe̱yɛ, “Mo̱ nyare̱, nsɛ ya sa mo̱ kpa fe̱yɛ n gyi amo̱‑ɔ ase̱ŋ bɛɛɛ ŋ ke mo̱ne̱ kapo̱tɛɛ‑rɔ sa mo̱ne̱?” ");
INSERT INTO ncuNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ŋkee ne̱ Yeesuu a tɔwe̱ gywii ase̱sɛ‑ɔ pɛɛɛ fe̱yɛ, “Mo̱nꞌ sa se̱ na mo̱ne̱ ma sa a atɔ ke̱kpa kɔɔre̱ mo̱ne̱ aŋu, a le̱e̱ fe̱yɛ fo̱ i de atɔ kanɔ ŋke̱maa, n gye̱ atɔ‑ɔ e̱ gye̱ ne̱ a sa fo̱ ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Amo̱ fe̱raa ne̱ Yeesuu a tɔwe̱ kitee mɔ fe̱yɛ, “Atɔ wuye ko̱ ya dɛɛ kye̱na, ne̱ o de swe̱e̱re̱ timaa ko̱, ne̱ ɔ dɔɔ mò̱ o lee adɔɔteese timaa. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kake ŋko̱ ne̱ ɔɔ fa mò̱ mfɛɛre̱ fe̱yɛ, ‘Mo̱ akyeŋkyeŋku mo̱ŋ kyɔ a m ba mo̱ adɔɔteese bo̱ waa‑rɔ. E̱me̱ne̱ ne̱ mo̱ e̱ waa?’ ");
INSERT INTO ncuNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Mò̱ fɔŋfɔŋ dɛɛ ne̱ ɔ be̱e̱ ɔ yɛ, ‘Ke̱tɔ ne̱ mo̱ e̱ waa‑ɔ e̱ gye̱ fe̱yɛ mo̱ i kyuwi mo̱ akyeŋkyeŋku de̱daa‑ɔ na ŋ yii adabe̱ na n taa mo̱ adɔɔteese pɛɛɛ waa‑rɔ, na m pwɛɛ akyaŋ dabe̱ na n taa mo̱ ate̱tɔmo̱ŋta waa‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Na ŋkee n tɔwe̱ gywii mo̱ e̱ye̱e̱ fe̱yɛ, Kuŋu-daŋ wuye, n de atɔ timaa pɛɛɛ ne̱ mo̱ e̱ kpa‑ɔ na a fo̱ mo̱ nsu bwe̱e̱tɔ. Amo̱se̱‑ɔ sɛye̱ mo̱ŋ tiri mo̱, mo̱ i gyi mo̱ e̱ye̱e̱ ne̱e̱. Na n gyi ateese na n nuu na n gyi mo̱ akatɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Atɔ wuye amo̱ a fa mfaanɛɛ lo̱we̱‑ɔ, ne̱ Wuribware̱ a tɔwe̱ gywii mò̱ fe̱yɛ, ‘Mfɛɛre̱ ke̱‑mo̱ŋ‑de wuye. Kanye mɔ dɛɛ mo̱ e̱ kɔɔre̱ fo̱ ŋkpa fo̱ ase̱. Na ŋkee atɔ de̱maŋte̱ timaa mɔ ne̱ fo̱ a kpa bo̱ dɔŋŋɔ abɛɛ se̱ sa fo̱ e̱ye̱e̱‑ɔ, fo̱ maa lɛɛ gyi. A kii ɔko̱ lee.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ne̱ Yeesuu a tɔwe̱ bo̱ gye̱ kɛɛ fe̱yɛ, “To, ɔke̱maa ne̱ ɔɔ kpa atɔ timaa bo̱ dɔŋŋɔ abɛɛ se̱‑ɔ, ne̱ Wuribware̱ ase̱ fe̱raa ɔ gye̱ otiripo̱ ne̱e̱‑ɔ, o du ne̱e̱ fe̱yɛ atɔ wuye amo̱ ne̱ ɔ mo̱ŋ de mfɛɛre̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","To, ne̱ Yeesuu a tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Ane̱ŋ se̱‑ɔ, mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ, mo̱ne̱ ma sa a ateese ne̱ mo̱ne̱ i gyi‑o bɛɛɛ atɔ ne̱ mo̱ne̱ i buŋ‑o ase̱ŋ tɔɔraa mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ŋkpa ase̱ŋ tiri a kyɔ ateese, ne̱ kayo̱wɔre̱ mɔ tiri ka kyɔ atɔ buŋsɛ. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mo̱nꞌ ke̱e̱ mbo̱gyii, bo̱ maa taare̱ a bo̱ dɔɔ nya ateese, hare̱e̱ ba swii amo̱ a bo̱ bo̱ waa akyeŋkyeŋku‑ro bo̱ ye̱ra, Wuribware̱ e̱ gye̱ ne̱ ɔ be̱ra bamo̱ saŋ ke̱maa. Mo̱ne̱ mɔ mo̱ne̱ kyɔ mbo̱gyii. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kanɔ ŋke̱maa ne̱ mo̱ne̱ e̱ fa mo̱ne̱ ŋkpa ase̱ŋ bwe̱e̱tɔ‑ɔ, mo̱ne̱ ɔko̱ maa taare̱ a ɔ sa kake ko̱ŋko̱ kpeŋ gbaa bo̱ tii mò̱ ŋke ne̱ Wuribware̱ a sa mò̱ fe̱yɛ ɔ bo̱ gyi kaye̱ mɔ‑rɔ‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ne̱ mo̱ne̱ e̱ ma taare̱ a mo̱nꞌ waa atɔ kafwe̱e̱ fe̱yɛ amo̱‑ɔ, ne̱ ŋkee e̱me̱ne̱ se̱ ne̱ mo̱ne̱ e̱ tɔɔraa mo̱ne̱ e̱ye̱e̱ atɔ ne̱ a be̱e̱ saŋ‑ɔ se̱? ");
INSERT INTO ncuNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","To, mo̱nꞌ be̱e̱ ke̱e̱ ane̱ŋ ne̱ afe̱raagyi a daŋ‑ɔ, a maa suŋ, ne̱ a maa lo̱ atɔ buŋsɛ a sa amo̱ e̱ye̱e̱. Amaa mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ Owure Solomɔŋ a dɛɛ kye̱na‑ɔ, mò̱ aa mò̱ atɔ gbaa, ɔ mo̱ŋ nya waagya timaa na ɔ bo̱ daŋ fe̱yɛ afe̱raagyi amo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Wuribware̱ e̱ gye̱ ne̱ ɔ lo̱ waagya o buŋ e̱fa ne̱ e̱ ye̱re̱ ndɔɔ, ne̱ nyaŋe̱ bo̱ fo̱‑ɔ e̱ ya wu‑o, ne̱ bo̱ de e̱mo̱ ba kure de̱e̱kpa na ba tɔ bodobodoo‑o. Amɔ mo̱ne̱ fe̱raa mo̱ne̱ ne̱ Wuribware̱ maa pee ke̱katɔ a ɔ sa mo̱ne̱ atɔ buŋsɛ aaa? Mo̱ne̱ ko̱kɔɔre̱gyi‑o mo̱ŋ kyɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Amo̱se̱‑ɔ mo̱ne̱ ma sa a ke̱tɔ ne̱ mo̱ne̱ i gyi‑o, na ke̱tɔ ne̱ mo̱ne̱ i nuu‑o, ase̱ŋ tɔɔraa mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","A le̱e̱ fe̱yɛ kaye̱ mɔ‑rɔ ase̱sɛ pɛɛɛ e̱ gye̱ ne̱ ba tɔɔraa bamo̱ e̱ye̱e̱ mfaanɛɛ a atɔ‑ɔ se̱. Mo̱ne̱ se̱ ne̱ ɔ bo̱ so̱so̱‑ɔ nyi fe̱yɛ atɔ pɛɛɛ tiri mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mo̱nꞌ sa a mo̱ne̱ mfɛɛre̱ yɔ Wuribware̱ a kuwure‑o‑ro atɔ se̱. Mo̱ne̱ i buwi mo̱ne̱ e̱ kpa atɔ amo̱, Wuribware̱ e̱ taa amo̱ a ɔ bo̱ sa mo̱ne̱, na ɔ be̱e̱ sa mo̱ne̱ ke̱tɔ ke̱maa ne̱ ki tiri mo̱ne̱‑ɔ bo̱ tii si.” ");
INSERT INTO ncuNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ne̱ Yeesuu a be̱e̱ tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Ŋ nyi fe̱yɛ mo̱ne̱ mo̱ŋ kyɔ fe̱raa, amaa mo̱ne̱ ma sa a kufu nya mo̱ne̱, a le̱e̱ fe̱yɛ mo̱ne̱ se̱ ne̱ ɔ bo̱ so̱so̱‑ɔ kɔne̱ se̱ ne̱e̱ fe̱yɛ ɔ sa mo̱ne̱ ke̱yaale̱ŋ mò̱ kuwure‑o‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mo̱nꞌ fe mo̱ne̱ kaye̱‑rɔ mfe̱e̱ a mpo̱tɛɛ ne̱ mo̱ne̱ de‑o, na mo̱nꞌ taa atanne̱‑ɔ sa atiripo̱, na mo̱nꞌ buwi kpa Wuribware̱ se̱ atanne̱ mbɔɔte̱e̱ ne̱ m maa nye̱ra‑ɔ na mo̱nꞌ buwi kpa mpo̱tɛɛ ne̱ m bo̱ so̱so̱‑ɔ, a le̱e̱ fe̱yɛ mfe̱ŋ fe̱raa sɛye̱ maa lee mmo̱ se̱, ne̱ oyu maa taare̱ a o ywii, ne̱ nsekreeke na igyeeri mɔ maa taare̱ a ŋ nye̱ra mpo̱tɛɛ amo̱ Wuribware̱ se̱ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Amo̱se̱‑ɔ to̱ŋ ke̱maa ne̱ fo̱ kapo̱tɛɛ da‑ɔ, fo̱ mfɛɛre̱ e̱ ya dɔŋŋɔ kamo̱ se̱ mfe̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ne̱ Yeesuu a be̱e̱ tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Mo̱nꞌ waa siraa gywii mo̱ ko̱yɔ na kaye̱ ke̱gye̱kɛɛ na mo̱ kikiŋŋi ba‑ɔ. Mo̱nꞌ buŋ mo̱ne̱ kusuŋ‑no atɔ na mo̱nꞌ kyaŋŋe̱ mo̱ne̱ ifetiri si, ");
INSERT INTO ncuNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","fe̱yɛ ayaafɔre̱ ne̱ bo̱ gywii bamo̱ nyaŋpe̱ na o kiŋŋi le̱e̱ ko̱ko̱fɔ taakpa‑rɔ ba, na mò̱ ya ye̱re̱ kawu ɔ te̱e̱ a bo̱ nya taye̱ mò̱ a o lwee lɔŋ‑nɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ mò̱ ayaafɔre̱‑ɔ e̱ ke̱e̱, ne̱ bamo̱ nyaŋpe̱ ya ba, bamo̱ akatɔ i gyi bwe̱e̱tɔ, a le̱e̱ fe̱yɛ o buŋŋi mò̱ atɔ buŋsɛ, na o buŋ amo̱ ne̱ bo̱ buŋ ba waa ateese‑o, na ɔ sa a bo̱ kye̱na kyure, na mò̱ fɔŋfɔŋ de̱ŋa, na mò̱ aa bamo̱ kye̱na gyi. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Hare̱e̱ bamo̱ nyaŋpe̱‑ɔ ya ba kaye̱ nse̱na bɛɛɛ kamɛɛ‑rɔ bo̱ to̱ fe̱yɛ baa waa siraa bo̱ gywii mò̱ gbaa, bamo̱ akatɔ i gyi. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mo̱ne̱ gbaa mo̱ne̱ nyi fe̱yɛ lɔŋ wuye dɛɛ o nyi saŋ ne̱ oyu de ɔ ba‑ɔ ne̱e̱, weetee ɔ maa yɔwe̱ mò̱ lɔŋ a ɔ sa oyu‑o na ɔ bo̱ lweero ya ywii mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Amo̱se̱‑ɔ mo̱ne̱ gbaa mo̱nꞌ waa siraa, a le̱e̱ fe̱yɛ mo̱, dimaadi mò̱ gyi‑o, bo̱ kiŋŋi ba‑ɔ, mo̱ i fu‑ro a m ba ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Mfe̱ŋ ne̱ Peetroo yɛ, “Ane̱ nyaŋpe̱, ane̱ wo̱re̱ ne̱ fo̱ a da ke̱kpare̱ mɔ bo̱ sa bɛɛɛ ɔke̱maa mɔ?” ");
INSERT INTO ncuNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ne̱ Yeesuu yɛ, “Mo̱ a fu‑ro a m be̱e̱ ba‑ɔ se̱‑ɔ, mo̱ e̱ kaapo̱ mo̱ne̱ ke̱yaafɔre̱ ne̱ mo̱ ase̱ o nyi ase̱ŋ ne̱ o bware. Mo̱nꞌ sa a ane̱ taa fe̱yɛ nyaŋpe̱ ko̱ e̱ kpa a ɔ yɔ kpa, ne̱ ɔ taa ke̱yaafɔre̱ ko̱ a ɔ bo̱ de̱e̱re̱ mò̱ lɔŋ na ayaafɔre̱ na mbre ne̱ baa saŋ‑ɔ se̱, na bo̱ nya nya ateese gyi saŋ ne̱ a bware fe̱yɛ bo̱ gyi‑o. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mò̱ nyaŋpe̱ ya kiŋŋi ba pe̱ bo̱ to̱ fe̱yɛ ke̱yaafɔre̱ amo̱ a waa ke̱tɔ ne̱ ɔɔ tɔwe̱ gywii mò̱ fe̱yɛ ɔ waa‑ɔ, ane̱ŋ a ke̱yaafɔre̱‑ɔ akatɔ i gyi. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ, a waa kanɔ ŋke̱maa, mò̱ nyaŋpe̱ e̱ taa mò̱ kapo̱tɛɛ pɛɛɛ na ɔ bo̱ sa mò̱ ke̱yaafɔre̱ amo̱ a ɔ de̱e̱ de̱e̱re̱ se̱ sa mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","46","Amaa ke̱yaafɔre̱‑ɔ ya tɔwe̱ fe̱yɛ mò̱ nyaŋpe̱ a kyee na kikiŋŋi ba‑ɔ se̱, ne̱ ɔɔ le̱e̱ ɔ daye̱ mò̱ bɛɛko̱‑ana ayaafɔre̱ na mbre ne̱ bo̱ bo̱ lɔŋ‑ɔ‑rɔ‑ɔ, na o gyi ateese ne̱ ɔ kpa‑ɔ, ne̱ o nuu nta ɔ bwe̱e̱ fe̱raa, mò̱ nyaŋpe̱‑ɔ i kiŋŋi a ɔ ba kake ne̱ ke̱yaafɔre̱‑ɔ maa de̱e̱re̱ mò̱ kpa‑ɔ na saŋ ne̱ ɔ mo̱ŋ nyi‑o. Na mò̱ nyaŋpe̱‑ɔ bo̱ da mò̱ bwe̱e̱tɔ gyiiri mò̱ ke̱se̱bɔ, na o ŋu ase̱ŋ ne̱ bamo̱ ne̱ bo̱ maa kɔɔre̱ Wuribware̱ ba gyi‑o i ŋu‑o. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ke̱tɔ ne̱ mo̱ e̱ kaapo̱‑ɔ e̱ gye̱ fe̱yɛ saŋ ne̱ mo̱ i kiŋŋi a m ba‑ɔ, mo̱ i gyi ase̱sɛ pɛɛɛ ase̱ŋ. Ke̱yaafɔre̱ ne̱ o nyi ke̱tɔ ne̱ mò̱ nyaŋpe̱ e̱ kpa‑ɔ, ne̱ ɔ mo̱ŋ waa siraa fe̱yɛ ɔ waa ke̱mo̱‑ɔ, ba ba ko̱kyo̱kywe̱e̱ a bo̱ bo̱ gyiiri mò̱ ke̱se̱bɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Amaa ke̱yaafɔre̱ ne̱ ɔ mo̱ŋ nyi ke̱tɔ ne̱ mò̱ nyaŋpe̱ e̱ kpa‑ɔ, ne̱ mò̱‑ɔ mò̱ a waa adase̱ŋ‑ɔ, ba ba ko̱kyo̱kywe̱e̱ ke̱da kafwe̱e̱ a bo̱ bo̱ gyiiri mò̱ ke̱se̱bɔ. Amo̱se̱ se̱‑ɔ ɔko̱ ne̱ mo̱ a sa mò̱ atɔ bwe̱e̱tɔ fe̱yɛ ɔ de̱e̱re̱ se̱‑ɔ, amo̱ ya fo̱, mò̱ ne̱ mo̱ i bise ase̱ŋ bwe̱e̱tɔ. Ne̱ ɔko̱ ne̱ mo̱ e̱ sa mò̱ atɔ bwe̱e̱tɔ bwe̱e̱tɔ fe̱yɛ ɔ de̱e̱re̱ se̱‑ɔ, amo̱ ya fo̱, mò̱ ne̱ mo̱ i bise ase̱ŋ bwe̱e̱tɔ bwe̱e̱tɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Mo̱nꞌ lɔŋ e̱se̱bɔ. Mo̱ a ba a m bo̱ kywɛɛ de̱e̱kpa kaye̱ mɔ‑rɔ ne̱e̱. Weetee mbe̱yɔmɔ ane̱ŋ ne̱ mo̱ a kpa fe̱yɛ ɔ maa se̱ ɔ kywɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Awo̱re̱fɔɔ bwe̱e̱tɔ dɔŋ mo̱ se̱ ne̱e̱, amo̱ e̱ mo̱ŋ kyo̱ŋ, mo̱ kakpo̱nɔ maa di mo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mo̱ne̱ nyi fe̱yɛ mo̱ a ba a m bo̱ baa kaye̱e̱yuri kaye̱‑rɔ ne̱e̱ e̱e̱e̱? Daabii, mo̱ a ba a m bo̱ nye̱ra ase̱sɛ mbo̱ŋtɔ‑rɔ ne̱e̱, n gye̱ kaye̱e̱yuri. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Le̱e̱ mbe̱yɔmɔ bo̱ yɔ mbuno ke̱maa i ke‑ro, na abɛɛ asa na abɛɛ anyɔ kɔ abɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Na ase̱ na bamo̱ gyi‑ana kɔ na bamo̱ mbo̱ŋtɔ‑rɔ te̱ŋ‑nɔ, na agyi na bamo̱ anyi kɔ na bamo̱ mbo̱ŋtɔ‑rɔ te̱ŋ‑nɔ, na ase̱sɛ anyi na bamo̱ gyi‑ana aka kɔ na bamo̱ mbo̱ŋtɔ‑rɔ te̱ŋ‑nɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ne̱ Yeesuu a buruwaa tɔwe̱ gywii lamaŋ ne̱ ba nu mò̱ ase̱ŋ‑ɔ fe̱yɛ, “Mo̱ne̱ ya ŋu awo̱re̱ a le̱e̱ kyɔwe̱ twɛɛkpa, amɔ mo̱ne̱ yɛ bware̱ e̱ kpa a ɔ ba, na kase̱ŋtiŋ ɔ ba. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ne̱ mo̱ne̱ ya be̱e̱ ŋu afwii e̱ da kyɔwe̱ le̱e̱kpa kigyise si, amɔ mo̱ne̱ yɛ kipuripuri e̱ kpa a ke̱ ba, na kase̱ŋtiŋ ke̱ ba. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nnɔ ŋnyɔ ŋnyɔ awuye. Mo̱ne̱ e̱ taare̱ a mo̱nꞌ de̱e̱re̱ swe̱e̱re̱ na awo̱re̱‑rɔ na mo̱nꞌ tɔwe̱ ke̱tɔ ne̱ ke̱ e̱ waa‑ɔ. Ne̱ nte̱tɔ se̱ ne̱ mo̱ne̱ ya nu mo̱ atɔ ke̱kaapo̱, ne̱ mo̱ne̱ ya ŋu atɔ dabe̱ ne̱ mo̱ e̱ waa‑ɔ, ne̱ mo̱ne̱ maa taare̱ a mo̱nꞌ kaapo̱ ke̱se̱bɔgyiiri ne̱ ke̱ e̱ kpa a ke̱ ba kaye̱ mɔ‑rɔ a ase̱sɛ‑ɔ ase̱‑ɔ fe̱raa?” ");
INSERT INTO ncuNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Mfe̱ŋ ne̱ Yeesuu be̱e̱ ɔ yɛ, “Mo̱ne̱ ke̱se̱bɔgyiiri saŋ e̱ kpa a ɔ fo̱. Ne̱ nte̱tɔ se̱ ne̱ mo̱ne̱ maa taare̱ a mo̱nꞌ ŋu ke̱tɔ ne̱ mo̱nꞌ waa na ki lee mo̱ne̱‑ɔ, na mo̱nꞌ wuree waa? ");
INSERT INTO ncuNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ane̱ taa fe̱yɛ fo̱ i de ɔko̱ ko̱kɔ bɛɛɛ fo̱ aa fo̱ bɛɛko̱ i de ase̱ŋ ne̱ ɔ yaa fo̱ se̱ŋgyikpa, fo̱ ko̱ ne̱ fo̱ a baa ase̱ŋ‑ɔ wuree de̱e̱re̱ se̱ na fo̱ aa ase̱ŋ wuye‑o lɔŋŋɔ amo̱ pwɛɛ na mo̱nꞌ dɛɛ fo̱ se̱ŋgyikpa‑ɔ mfe̱ŋ. N gye̱ ane̱ŋ, o gyiiri fo̱ a ɔ yaa ɔse̱ŋgyipo̱‑ɔ ase̱ na mò̱ mɔ taa fo̱ sa apurisii awuye na bo̱ tii fo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ fo̱ i di tiikpa mfe̱ŋ ane̱ŋ‑aaa bo̱ fo̱ saŋ ne̱ fo̱ e̱ ka fo̱ ko̱kɔ a fo̱ lo̱we̱‑ɔ, na paso̱wa gbaa mo̱ŋ saŋ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Saŋ amo̱‑ɔ Yeesuu a maa se̱ ɔ kaapo̱ bamo̱ abɔye̱waapo̱ ke̱se̱bɔgyiiri ase̱ŋ‑ɔ, ne̱ ase̱sɛ ko̱ a tɔwe̱ gywii mò̱ ane̱ŋ ne̱ saŋ ko̱ Romanyi gominaa Pilat a ba bo̱ to̱ Galile̱ya swe̱e̱re̱ se̱ awuye ko̱ e̱ mɔɔ mbo̱ ba lɔŋŋɔ Wuribware̱, ne̱ ɔɔ mɔɔ bamo̱, ne̱ ɔɔ sa ne̱ bamo̱ mbo̱gya a we̱e̱ mbo̱ ne̱ baa bo̱ lɔŋŋɔ‑ɔ se̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ne̱ baa bise Yeesuu fe̱yɛ lowi suyo ne̱ baa wu‑o e̱ kaapo̱ ne̱e̱ fe̱yɛ bo̱ gye̱ abɔye̱waapo̱ bo̱ kyɔ bamo̱ bɛɛko̱‑ana Galile̱ya awuye aaa? ");
INSERT INTO ncuNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “Daabii. A mo̱ŋ gye̱ kase̱ŋtiŋ. Ke̱tɔ ne̱ ko̱ kyɔ‑ɔ e̱ gye̱ fe̱yɛ mo̱ i yii mo̱ne̱ se̱ fe̱yɛ mo̱ne̱ e̱ mo̱ŋ nu mo̱ne̱ e̱ye̱e̱, na mo̱nꞌ kiŋŋi le̱e̱ mo̱ne̱ e̱bɔye̱‑rɔ, Wuribware̱ i gyiiri mo̱ne̱ gbaa mo̱ne̱ ke̱se̱bɔ, na mo̱nꞌ wu. ");
INSERT INTO ncuNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","To, ne̱ mo̱ne̱ a be̱e̱ nu ane̱ŋ ne̱ ke̱kyaŋ so̱swe̱e̱ le̱ŋle̱ŋsɛ ko̱ ne̱ baa te̱e̱ ɛ Silowam ne̱ baa pwɛɛ Yɛro̱salɛm maŋ‑nɔ‑ɔ a le̱e̱ da ase̱sɛ kudu aburuwa ko̱ se̱ mɔɔ‑ɔ ase̱ŋ bɛɛɛ? Mo̱ne̱ e̱ fa fe̱yɛ bamo̱ gbaa, a kaapo̱ fe̱yɛ bo̱ gye̱ abɔye̱waapo̱ bo̱ kyɔ ase̱sɛ ne̱ baa saŋ bo̱ bo̱ maŋ amo̱‑rɔ‑ɔ ɔɔɔ? ");
INSERT INTO ncuNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","A mo̱ŋ gye̱ kase̱ŋtiŋ. Na m be̱e̱ mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ mo̱ne̱ e̱ mo̱ŋ nu mo̱ne̱ e̱ye̱e̱ na mo̱nꞌ kiŋŋi le̱e̱ mo̱ne̱ e̱bɔye̱‑rɔ, mo̱ne̱ i wu fe̱yɛ bamo̱‑ɔ dɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ne̱ Yeesuu a tɔwe̱ kitee mɔ gywii bamo̱. Ɔ yɛ, “N gye̱ ɔnyare̱ ko̱ e̱ bo̱‑rɔ aaa? Ne̱ oo dwii figi kiyii ko̱ mò̱ ko̱dɔɔ‑rɔ. Ne̱ kake ŋko̱ ɔɔ yɔ a ɔ ya kpa agyi kiyii‑o si, mò̱‑ɔ mò̱ mo̱ŋ nya. ");
INSERT INTO ncuNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ane̱ŋ se̱‑ɔ ne̱ ɔɔ tɔwe̱ gywii mò̱ ko̱dɔɔ a ɔde̱e̱re̱se̱po̱‑ɔ fe̱yɛ, ‘Ke̱e̱ ɛ. Nsu nsa ne̱e̱ fe̱yɛ mo̱ a nare̱ kpa figi mɔ agyi kpo̱ne̱, ma nya, amo̱se̱‑ɔ ŋe ke̱mo̱ bo̱ twe̱e̱. Ntɔ se̱ ne̱ ke̱ ye̱re̱ ke̱ e̱ nye̱ra swe̱e̱re̱‑ɔ ateese‑o ne̱e̱?’ ");
INSERT INTO ncuNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ne̱ mò̱ ko̱dɔɔ a ɔde̱e̱re̱se̱po̱‑ɔ a be̱ŋŋaa mò̱ fe̱yɛ, ‘Mo̱ nyaŋpe̱, yɔwe̱ ke̱mo̱. Sa ke̱mo̱ kasu ko̱ŋko̱ kpeŋ. Mo̱ i kwii a m bo̱ muruwaa ke̱mo̱ na n swii e̱naate̱ igyini bo̱ waa‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ne̱ mo̱ ya waa ane̱ŋ, ne̱ su-a-ba ke̱mo̱ ya swɛɛ fe̱raa, a bware. Ne̱ ke̱mo̱ e̱ mo̱ŋ swɛɛ, amo̱ fe̱raa na fo̱ ŋe bo̱ twe̱e̱.’ Amo̱ e̱ gye̱ saase̱bɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kukyure kake ko̱ ne̱ Yeesuu e̱ kaapo̱ abware̱se̱ŋ ke̱bware̱ko̱re̱kyaŋ ko̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ɔkye̱e̱ ko̱ mɔ bo̱ mfe̱ŋ, ne̱ Ɔbɔnsam a waa mò̱ ko̱lɔ nsu kudu mburuwa. Ko̱lɔ amo̱ se̱, ɔ mo̱ŋ lɛɛ ɔ naa kyɛɛkyɛɛ, oo buŋ‑no ne̱e̱ ɔ naa. ");
INSERT INTO ncuNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Saŋ ne̱ Yeesuu a ŋu mò̱‑ɔ, ne̱ ɔɔ te̱e̱ mò̱ tɔwe̱ gywii mò̱ fe̱yɛ, “Ɔpe̱kye̱e̱, ŋkee fe̱raa fo̱ a nya fo̱ e̱ye̱e̱ le̱e̱ fo̱ ko̱lɔ‑ɔ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ne̱ ŋkee Yeesuu a ba asare̱e̱ bo̱ dɔŋŋɔ ɔkye̱e̱‑ɔ se̱. Puri amo̱‑rɔ ne̱ ɔkye̱e̱ amo̱ a teyi‑ro ɔ naa. Ne̱ ɔɔ kyo̱rɔ Wuribware̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mfe̱ŋ, ne̱ ke̱bware̱ko̱re̱kyaŋ‑ɔ bre̱sɛ duŋ a fwii fe̱yɛ Yeesuu a kya ɔko̱ ko̱lɔ kukyure kake. Amo̱se̱‑ɔ ne̱ ɔbre̱sɛ amo̱ a tɔwe̱ gywii ase̱sɛ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ fe̱yɛ, “Ane̱ de ŋke nsiye ne̱ ane̱ e̱ waa asuŋ, amo̱se̱‑ɔ mo̱ne̱ ma lɛɛ ba kukyure kake bo̱ kya mo̱ne̱ alɔ. Mo̱nꞌ de̱e̱ ba ŋke nsiye amo̱‑rɔ bo̱ kya.” ");
INSERT INTO ncuNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ne̱ Yeesuu a be̱ŋŋaa mò̱ fe̱yɛ, “Nnɔ ŋnyɔ ŋnyɔ awuye mɔ. Mo̱ne̱ ke̱maa e̱ saŋŋe̱ mò̱ e̱naate̱ bɛɛɛ ikuruma ɔ yaa nkyu nuukpa kake ke̱maa, hare̱e̱ kukyure kake gbaa. Amo̱‑ɔ fe̱raa mo̱ŋ gye̱ kusuŋ ko̱waa ne̱e̱ e̱e̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mbe̱yɔmɔ, ke̱e̱ se̱sɛ dimaadi mɔ, mo̱ne̱ fɔŋfɔŋ se̱sɛ ne̱e̱. Ɔ gye̱ ane̱ nana Abraham a ananagyi‑o ɔko̱, bɛɛɛ? Ne̱ Ɔbɔnsam a sa mò̱ ko̱lɔ nsu kudu mburuwa‑o. A du ne̱e̱ fe̱yɛ Ɔbɔnsam a ŋure mò̱ bo̱ kye̱na, ne̱ mbe̱yɔmɔ mo̱ a saŋŋe̱ mò̱‑ɔ. Amɔ mfaanɛɛ a se̱sɛ‑ɔ a mo̱ŋ bware fe̱yɛ n kya mò̱ kukyure kake, na ɔ nya mò̱ e̱ye̱e̱ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ne̱ ane̱ŋ ne̱ Yeesuu a be̱ŋŋaa‑ɔ a sa ne̱ ipeere a nya mò̱ ado̱ŋ. Ne̱ bamo̱ ne̱ baa saŋ‑ɔ akatɔ a gyi bo̱ le̱e̱ akpe̱ŋe̱ye̱e̱tɔ ne̱ Yeesuu a waa‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ne̱ Yeesuu a bise fe̱yɛ, “Nte̱tɔ gbaa ne̱ mo̱ e̱ ba a m bo̱ kaapo̱ mo̱ne̱ ane̱ŋ ne̱ Wuribware̱ a kuwure‑o du‑o ne̱e̱? Ke̱kpare̱ mo̱ ne̱ mo̱ e̱ ba a m bo̱ kaapo̱ mo̱ne̱ ke̱mo̱ kaase̱‑ɔ ne̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","To, mfaanɛɛ ne̱ Wuribware̱ a kuwure‑o‑ro du. Ku du ne̱e̱ fe̱yɛ kupurutugyi‑o. Kigyi mɔ du kagyingyii, amaa se̱sɛ ya dwii ke̱mo̱, amɔ ke̱ e̱ kwɛɛ a ke̱ daŋ kii kikiree, ne̱ ke̱ bo̱ e̱swe̱e̱ ko̱ kyo̱ŋ ayii pɛɛɛ. Ne̱ mbo̱gyii a bo̱ kye̱na ke̱mo̱ se̱ waa bamo̱ asaa.” ");
INSERT INTO ncuNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ne̱ Yeesuu a be̱e̱ bise fe̱yɛ, “Ke̱kpare̱ mo̱ ne̱ mo̱ e̱ ba a m bo̱ kaapo̱ mo̱ne̱ ane̱ŋ ne̱ Wuribware̱ a kuwure‑o du‑o ne̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","To, ku du ne̱e̱ fe̱yɛ ɔkye̱e̱ a kpa a ɔ waa bodobodoo, ne̱ ɔɔ ba yiisi na nkyu bo̱ waa e̱sam kyaŋse̱ bo̱rɔ‑rɔ, ne̱ oo nwiini, ne̱ e̱sam‑ɔ a tiŋ waa bwe̱e̱tɔ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ne̱ ŋkee Yeesuu naa e̱maŋ se̱ na mmaŋgyii‑ro ɔ tɔwe̱ abware̱se̱ŋ o gywii ase̱sɛ na ɔ yɔ Yɛro̱salɛm a keri‑o. ");
INSERT INTO ncuNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ne̱ ɔko̱ a bise mò̱ fe̱yɛ, “Mo̱ nyaŋpe̱, a gye̱ kase̱ŋtiŋ fe̱yɛ bamo̱ ne̱ Wuribware̱ e̱ mo̱rɔwe̱ na bo̱ tii mò̱ kuwure‑o si‑o mo̱ŋ kyɔ aaa?” Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Wuribware̱ a kuwure‑o du ne̱e̱ fe̱yɛ ke̱kyaŋ ne̱ ke̱mo̱ kabunogyii du bɔŋbɔŋ‑ɔ. Amo̱se̱‑ɔ mo̱nꞌ le̱ŋ e̱ye̱e̱, na mo̱nꞌ taare̱ nya lwee ke̱kyaŋ‑ɔ‑rɔ. A le̱e̱ fe̱yɛ ase̱sɛ bwe̱e̱tɔ akatɔ i pee ke̱mo̱ kulweero si, amaa n gye̱ bamo̱ pɛɛɛ e̱ gye̱ ne̱ ba nya kpa a bo̱ lweero. ");
INSERT INTO ncuNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Saŋ ko̱ e̱ ba ne̱ lɔŋ wuye‑o e̱ twe̱e̱ po̱ne̱‑ɔ‑rɔ, na mo̱ne̱ te mo̱ne̱ mo̱ŋ tɛɛ lweero. Na mo̱nꞌ sii kawu mo̱ne̱ ye̱re̱ mo̱ne̱ e̱ daye̱ po̱ne̱‑ɔ se̱, na mo̱ne̱ e̱ te̱e̱ fe̱yɛ, ‘Ane̱ nyaŋpe̱, taye̱ ane̱,’ na ɔ be̱ŋŋaa mo̱ne̱ fe̱yɛ, ‘Mo̱ŋ nyi mo̱ne̱, ne̱ mo̱ŋ nyi mfe̱ŋ ne̱ mo̱ne̱ a le̱e̱‑ɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Na mo̱nꞌ tɔwe̱ gywii mò̱ fe̱yɛ, ‘Ane̱ aa fo̱ ya dɛɛ gyi na ane̱ i nuu, ne̱ fo̱ a nare̱ tɔwe̱ abware̱se̱ŋ ane̱ aye̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Na mò̱‑ɔ mò̱ be̱e̱ be̱ŋŋaa mo̱ne̱ fe̱yɛ, ‘Mo̱ŋ nyi mo̱ne̱, ne̱ mo̱ŋ nyi mfe̱ŋ ne̱ mo̱ne̱ a le̱e̱‑ɔ. Ase̱ŋ bɔye̱ awuye mɔ, mo̱nꞌ le̱e̱ mo̱ ase̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Wuribware̱ ya kine mo̱ne̱, ne̱ ɔɔ gya mo̱ne̱ le̱e̱ mò̱ kuwure‑o‑ro, ne̱ mo̱ne̱ ya ŋu mo̱ne̱ nana‑ana Abraham na Isak na Yakubu na Wuribware̱ akyaamɛɛ‑ɔ pɛɛɛ Wuribware̱ ase̱ fe̱raa, n gye̱ e̱wo̱gya ne̱ mo̱ne̱ i su na mo̱nꞌ duŋ nnɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ase̱sɛ e̱ le̱e̱ kaye̱ mɔ‑rɔ to̱ŋ ke̱maa, na bamo̱ ɔke̱maa kye̱na Wuribware̱ a lɔŋ‑ɔ‑rɔ, na bamo̱ aa mò̱ gyi ateese, na bamo̱ akatɔ gyi bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Na bamo̱ ne̱ bo̱ gye̱ nsii-amɛɛ mbe̱yɔmɔ‑ɔ kii agye̱ŋkpɛɛpo̱ mfe̱ŋ, na bo̱ko̱ ne̱ bo̱ gye̱ agye̱ŋkpɛɛpo̱ mbe̱yɔmɔ‑ɔ mɔ kii nsii-amɛɛ mfe̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Saŋ amo̱ dɛɛ ne̱ Farisii awuye ko̱ a bo̱ tɔwe̱ gywii Yeesuu fe̱yɛ, “A tiri fe̱yɛ fo̱ a le̱e̱ mfe̱e̱ yɔ to̱ŋ ko̱, a le̱e̱ fe̱yɛ Owure Hɛrɔd e̱ kpa fo̱ a ɔ mɔɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “Mo̱nꞌ nare̱ ya tɔwe̱ gywii naŋsɛ amo̱ fe̱yɛ, ‘Ndɔɔ mo̱ e̱ gya ibrisi mo̱ e̱ ko̱so̱ ase̱sɛ se̱ ne̱e̱, na mo̱ e̱ kya alɔpo̱, na bo̱ fo̱ nyaŋe̱ na kraye̱‑ana‑ɔ mo̱ e̱ lo̱we̱ mo̱ kusuŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","A saŋ a tiri fe̱yɛ ŋ yɔ mo̱ kpa‑ɔ ndɔɔ na nyaŋe̱ na kraye̱, a le̱e̱ fe̱yɛ bamo̱ e̱ kpa a bo̱ mɔɔ Wuribware̱ a akyaamɛɛ‑ɔ, Yɛro̱salɛm maŋ‑nɔ ne̱ ba mɔɔ bamo̱. Ne̱ mo̱ saŋ‑ɔ mo̱ŋ tɛɛ fo̱ fe̱yɛ ŋ yɔ mfe̱ŋ.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ne̱ Yeesuu be̱e̱ ɔ yɛ, “Yɛro̱salɛm awuye, Yɛro̱salɛm awuye. Saŋ ke̱maa ne̱ Wuribware̱ a suŋ mò̱ akyaamɛɛ‑ɔ ɔko̱ mo̱ne̱ ase̱‑ɔ, mo̱ne̱ a daye̱ mò̱ abu mɔɔ. Saŋ ke̱maa mo̱ a kpa fe̱yɛ ŋ kpɔwe̱ mo̱ne̱ bo̱ gyaŋŋe̱, na ŋ kuŋ mo̱ne̱, fe̱yɛ ane̱ŋ ne̱ kyaase̱ i buŋ mò̱ agyi si‑o, ne̱ mo̱ne̱ mɔ mo̱ne̱ a kine. ");
INSERT INTO ncuNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ane̱ŋ se̱‑ɔ, Wuribware̱ e̱ yɔwe̱ mo̱ne̱ ase̱ŋ a ɔ sa mo̱ne̱, na mo̱ne̱ maŋ mɔ kii ke̱taakpaŋ. Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ mo̱ne̱ maa lɛɛ ŋu mo̱, amɔ saŋ a fo̱ fe̱yɛ m ba, ne̱ mo̱ne̱ e̱ tɔwe̱ fe̱yɛ, ‘Wuribware̱ yure mò̱ ne̱ ɔ ba mò̱ ke̱nyare̱‑rɔ‑ɔ.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Kukyure kake ko̱ ne̱ Yeesuu a yɔ a ɔ ya gyi ateese Farisiinyi bre̱sɛ ko̱ aye̱, ne̱ ase̱sɛ e̱ de̱e̱re̱ mò̱ a bo̱ ke̱e̱ ane̱ŋ ne̱ ɔ waa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ne̱ Yeesuu a ŋu ɔnyare̱ ko̱ ne̱ mò̱ ayaa na asare̱e̱ a puŋŋe‑o ye̱re̱ mò̱ akatɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","To, ne̱ Yeesuu a bise Wuribware̱ mbraa akaapo̱po̱‑ɔ na Farisii awuye‑o fe̱yɛ, “Mbraa ne̱ Wuribware̱ a sa ane̱‑ɔ e̱ sa kpa fe̱yɛ ane̱ kya alɔpo̱ kukyure kake aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Amaa bo̱ mo̱ŋ be̱ŋŋaa mò̱. Ne̱ ɔɔ dabo̱rɔ ɔnyare̱ amo̱ kya mò̱ ko̱lɔ, ne̱ ɔɔ tɔwe̱ gywii mò̱ fe̱yɛ ɔ nare̱ pe̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ne̱ ŋkee Yeesuu a bise bamo̱ fe̱yɛ, “Mo̱ne̱ ɔko̱ i de gyi bɛɛɛ naate̱ gbaa, ne̱ mò̱ ya le̱e̱ da kitiribu‑ro kukyure kake, amɔ mo̱ne̱ maa waa me̱naŋ a mo̱nꞌ ya gyiiri mò̱ le̱e̱ mfe̱ŋ aaa? Bɛɛɛ mo̱ne̱ i gywii a mo̱nꞌ bo̱ fo̱ saŋ ne̱ kukyure kake amo̱ a kyo̱ŋ‑ɔ ɔɔɔ?” ");
INSERT INTO ncuNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Amaa bo̱ be̱e̱ bo̱ mo̱ŋ taare̱ lee mò̱ ase̱ŋ‑ɔ kanɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Saŋ ne̱ Yeesuu a ŋu ane̱ŋ ne̱ ase̱sɛ ne̱ baa te̱e̱ bamo̱ a bo̱ bo̱ gyi‑o i lee e̱kye̱nakpa timaa‑o, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","“Ɔko̱ ya te̱e̱ fo̱ ko̱ko̱fɔ‑rɔ gyikpa, ne̱ fo̱ ya yɔ, fo̱ ma kye̱na kye̱nakpa timaa‑o. N gye̱ ane̱ŋ, mò̱ ya te̱e̱ ɔko̱ mɔ na ɔ kyɔ fo̱, mò̱ ne̱ ɔɔ te̱e̱ mo̱ne̱ anyɔ‑ɔ e̱ ba fo̱ ase̱, na ɔ bo̱ tɔwe̱ gywii fo̱ fe̱yɛ, ‘Ko̱so̱ na fo̱ sa a mmo̱‑ɔ kye̱na mfe̱ŋ.’ Na ipeere nya fo̱, na fo̱ ya kye̱na kye̱nakpa ne̱ ɔ mo̱ŋ bɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Amo̱se̱‑ɔ, ɔko̱ ya te̱e̱ fo̱ gyikpa, ne̱ fo̱ ya yɔ, kye̱na kye̱nakpa ne̱ ɔ mo̱ŋ gye̱ otimaa‑o, na mò̱ ne̱ ɔɔ te̱e̱ fo̱ gyikpa amo̱‑ɔ ba bo̱ tɔwe̱ gywii fo̱ fe̱yɛ, ‘Mo̱ nyare̱, ko̱so̱ bo̱ kye̱na kye̱nakpa timaa mɔ.’ Mfe̱ŋ‑ɔ fo̱ i ŋu fe̱yɛ fo̱ e̱ nya ke̱nyare̱ na ke̱dabe̱ fo̱ ko̱so̱bɛɛ‑ana ase̱ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","A le̱e̱ fe̱yɛ ɔke̱maa ne̱ o bu mò̱ e̱ye̱e̱ ke̱dabe̱‑ɔ, Wuribware̱ e̱ baa mò̱ kaase̱, ne̱ ɔke̱maa ne̱ ɔ baa mò̱ e̱ye̱e̱ kaase̱‑ɔ mɔ, Wuribware̱ e̱ sa mò̱ ke̱dabe̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ne̱ Yeesuu a tɔwe̱ gywii lɔŋ wuye‑o fe̱yɛ, “Amo̱se̱‑ɔ fo̱ ya te̱e̱ ase̱sɛ ateesegyikpa, fo̱ ma te̱e̱ fo̱ nyare̱‑ana bɛɛɛ fo̱ adaa na fo̱ atire bɛɛɛ fo̱ ko̱we̱bɛɛ‑ana bɛɛɛ atɔ awuye ne̱ bo̱ gye̱ fo̱ akye̱nabɛɛpo̱‑ɔ, a le̱e̱ fe̱yɛ ŋke ŋko̱ ba waa ane̱ŋ dɛɛ a bo̱ bo̱ teere, saŋ‑ɔ a waa ne̱e̱ fe̱yɛ baa waa bo̱ ka ke̱tɔ ne̱ fo̱ a waa sa bamo̱‑ɔ ko̱kɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Fo̱ e̱ te̱e̱ ase̱sɛ ateesegyikpa, te̱e̱ atiripo̱, na agyabɔɔ, na bamo̱ ne̱ bamo̱ asare̱e̱ bɛɛɛ ayaa a wu‑o, na ate̱napo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Bamo̱‑ana‑ɔ ne̱ mo̱ne̱ ya te̱e̱, ne̱ mo̱ne̱ e̱ nya ŋyure, a le̱e̱ fe̱yɛ bo̱ maa taare̱ a bo̱ waa mo̱ne̱ ane̱ŋ bo̱ teere. Wuribware̱ e̱ gye̱ ne̱ kake nsi ne̱ ase̱sɛ timaa i kyiŋŋi a bo̱ le̱e̱ lowi‑ro‑o, ɔ ka mo̱ne̱ amo̱ ko̱kɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Amo̱ fe̱raa ɔnyare̱ ko̱ ne̱ mò̱ gbaa te gyikpa amo̱ mfe̱ŋ‑ɔ a nu ke̱tɔ ne̱ Yeesuu a tɔwe̱‑ɔ, ne̱ ɔɔ tɔwe̱ gywii Yeesuu fe̱yɛ, “Bamo̱ ne̱ ba kye̱na Wuribware̱ a kuwure‑o‑ro a gyikpa‑ɔ de ŋyure.” ");
INSERT INTO ncuNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ne̱ Yeesuu a tɔwe̱ kitee mɔ gywii bamo̱ fe̱yɛ, “N gye̱ ɔnyare̱ ko̱ e̱ dɛɛ ɔ bo̱‑rɔ aaa? Ne̱ kake ŋko̱ ɔɔ te̱e̱ ase̱sɛ bwe̱e̱tɔ fe̱yɛ bo̱ ba gyikpa mò̱ aye̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Saŋ a fo̱ fe̱yɛ bo̱ bo̱ gyi‑o, ne̱ oo suŋ mò̱ ayaafɔre̱‑ɔ ɔko̱ fe̱yɛ ɔ ya tɔwe̱ gywii ɔke̱maa ne̱ ɔɔ te̱e̱ mò̱‑ɔ fe̱yɛ, ‘Mo̱ nyaŋpe̱ yɛ mo̱nꞌ ba, na ɔɔ waa siraa.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Amaa bamo̱ ɔke̱maa yɛ ɔ maa taare̱ a ɔ yɔ. Mò̱ ne̱ ke̱yaafɔre̱ amo̱ a gye̱ ŋkpɛɛ yɔ mò̱ ase̱‑ɔ yɛ, ‘Mo̱ a de̱ŋ sɔɔ swe̱e̱re̱ ko̱, ne̱ a tiri fe̱yɛ ŋ ya de̱e̱re̱, amo̱se̱‑ɔ mo̱ e̱ ko̱re̱ fo̱, ma taare̱ a m ba.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ne̱ ɔko̱ mɔ yɛ, ‘Mo̱ a de̱ŋ sɔɔ mo̱ e̱naate̱ kudu ko̱, amo̱se̱‑ɔ mo̱ e̱ ya ke̱e̱ bamo̱. Ma taare̱ a m ba.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ne̱ ɔko̱ mɔ be̱e̱ ɔ yɛ, ‘Kake mfe̱e̱ ne̱ mo̱ a taa ɔko̱fɔ, amo̱se̱‑ɔ ma taare̱ a m ba.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","To, ne̱ ke̱yaafɔre̱‑ɔ a kiŋŋi ya tɔwe̱ amo̱ pɛɛɛ gywii mò̱ nyaŋpe̱. Ne̱ mò̱ nyaŋpe̱‑ɔ duŋ a fwii, ne̱ ɔɔ be̱e̱ tɔwe̱ gywii ke̱yaafɔre̱‑ɔ fe̱yɛ, ‘Waa me̱naŋ nare̱ yɔ maŋ‑nɔ mbo̱re̱ se̱ na alɔŋde̱ se̱ ya te̱e̱ atiripo̱ na agyabɔɔ na ate̱napo̱ baa.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ke̱tɔ bo̱ waa kafwe̱e̱‑ɔ, mò̱ ke̱yaafɔre̱‑ɔ a kiŋŋi bo̱ tɔwe̱ gywii mò̱ fe̱yɛ, ‘Mo̱ nyaŋpe̱, mo̱ a waa ane̱ŋ ne̱ fo̱ a tɔwe̱‑ɔ, amaa kye̱nakpa saŋ ɔ bo̱‑rɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ne̱ mò̱ nyaŋpe̱‑ɔ be̱e̱ ɔ yɛ, ‘Nare̱ mbo̱re̱ se̱, na maŋ‑nɔ e̱kpa se̱, na e̱fa‑rɔ be̱e̱ ya ko̱re̱ ase̱sɛ ne̱ fo̱ i ŋu‑o baa, na mo̱ lɔŋ‑ɔ nya bo̱rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Amaa agye̱ŋkpɛɛsɛ ne̱ mo̱ a te̱e̱, ne̱ baa kine‑o, ɔko̱ maa lɛɛ nya mo̱ ateese a o gyi daa.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Saŋ ko̱, ne̱ ase̱sɛ de̱maŋte̱ ko̱ gya Yeesuu si ba yɔ to̱ŋ ke̱maa ne̱ ɔ kpa a ɔ yɔ‑ɔ. Ne̱ oo buruwaa tɔwe̱ gywii bamo̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ɔke̱maa ne̱ ɔ kpa fe̱yɛ ɔ ba mo̱ ase̱‑ɔ e̱ mo̱ŋ kpa mo̱ ase̱ŋ kyo̱ŋ mò̱ se̱ na mò̱ nyi, na mò̱ ka na agyi, na mò̱ daa‑ana na mò̱ tire‑ana na mò̱ pe̱kye̱e̱‑ana na mò̱ e̱ye̱e̱, amo̱ fe̱raa ɔ maa taare̱ a ɔ bo̱ kii mo̱ agyase̱po̱‑ɔ ɔko̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ɔke̱maa ne̱ ɔ maa taare̱ a o kperi mo̱ se̱ so̱rɔ mò̱ fɔŋfɔŋ kiyii kpare̱-abɛɛ‑rɔ gyi awo̱re̱fɔɔ gya mo̱ se̱‑ɔ maa taare̱ a o kii mo̱ ɔgyase̱po̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ne̱ Yeesuu be̱e̱ ɔ yɛ, “Mo̱ne̱ e̱ kpa a mo̱nꞌ gya mo̱ se̱ aaa? Ŋ yɛ, Ɔko̱ e̱ kpa a ɔ le̱e̱ waa ko̱tɔko̱, se̱sɛ‑ɔ kye̱na na ɔ fa mfɛɛre̱ fe̱yɛ ke̱tɔ ne̱ ɔ kpa a ɔ waa‑ɔ, ɔ taare̱ a ɔ waa ke̱mo̱ lo̱we̱ bɛɛɛ ɔ maa taare̱. Mo̱nꞌ sa a ane̱ taa fe̱yɛ mo̱ne̱ ɔko̱ e̱ kpa a ɔ pwɛɛ lɔŋ, ne̱ ɔ kye̱na ne̱e̱, na ɔ fa mfɛɛre̱ ŋu atanne̱ ne̱ lɔŋ‑ɔ i gyi‑o, na ɔ ke̱e̱ fe̱yɛ mò̱ atanne̱ e̱ taare̱ a a pwɛɛ lɔŋ‑ɔ lo̱we̱ aaa. ");
INSERT INTO ncuNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mò̱ e̱ mo̱ŋ fa lɔŋ‑ɔ mfɛɛre̱ pwɛɛ, ne̱ ɔ mo̱ŋ taare̱ pwɛɛ lo̱we̱, ase̱sɛ ne̱ ba ŋu‑o e̱ mɔse̱ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Na bo̱ tɔwe̱ fe̱yɛ, ‘Ke̱e̱, ɔnyare̱ mɔ a le̱e̱ ɔ pwɛɛ lɔŋ, ne̱ ɔ mo̱ŋ taare̱ lo̱we̱.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ne̱ Yeesuu yɛ, “Bɛɛɛ n taa fe̱yɛ owure ko̱ e̱ kpa a ɔ ya kɔ mò̱ bɛɛko̱ ko̱ ne̱ ɔ kpa a ɔ bo̱ kɔ mò̱‑ɔ. Ne̱ mò̱ i de ase̱sɛ ke̱kpe̱ŋdu, ne̱ mò̱ bɛɛko̱‑ɔ mɔ de ase̱sɛ akpe̱ŋdu anyɔ. Amɔ owure ne̱ mò̱ ase̱sɛ mo̱ŋ kyɔ‑ɔ maa kye̱na, na ɔ fa mfɛɛre̱ ke̱e̱ fe̱yɛ ɔ kɔ, na o gyi si bɛɛɛ ɔ maa gyi si aaa? ");
INSERT INTO ncuNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mò̱ ya ŋu fe̱yɛ ɔ maa taare̱ a ɔ kɔ gyi si, o suŋ mbɔɔ a ɔ bo̱ kyo̱ŋwe̱ owure ko̱‑ɔ ne̱e̱, na ɔ saŋ ɔ bo̱ ke̱fɔ ɔ ba, na bo̱ ya ko̱re̱ mò̱ tɔwe̱ gywii mò̱ fe̱yɛ ɔ kpa a bo̱ kii anyare̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ne̱ Yeesuu a tɔwe̱ bo̱ gye̱ kɛɛ fe̱yɛ, “Ase̱ŋ mɔ katiŋ e̱ gye̱ fe̱yɛ ɔko̱ ne̱ ɔ maa yɔwe̱ ke̱tɔ ke̱maa ne̱ o de‑o na ɔ gya mo̱ se̱‑ɔ maa taare̱ a o kii mo̱ ɔgyase̱po̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Amaa ɔko̱ ne̱ mò̱ ya gya mo̱ se̱, ne̱ a bo̱ waa kafwe̱e̱‑ɔ ne̱ mo̱ ke̱gya se̱ e̱ ma lɛɛ waa mò̱ kɔne̱‑ɔ, se̱sɛ‑ɔ sa se̱ pwɛɛ na ɔ dɛɛ bo̱ gya mo̱ se̱. Ane̱ŋ a se̱sɛ‑ɔ du ne̱e̱ fe̱yɛ mfɔre̱‑ɔ. Mfɔre̱ bo̱ kɔne̱. Amaa mmo̱ kɔne̱‑ɔ ya le̱e̱ fe̱raa, ɔko̱ maa taare̱ a ɔ bo̱rɔ kpa ke̱maa se̱ bo̱ sa a m be̱e̱ kii mfɔre̱ daa. ");
INSERT INTO ncuNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","M mo̱ŋ lɛɛ m bware bo̱ sa swe̱e̱re̱ gbaa. Ba taa a bo̱ bo̱ twe̱e̱ ne̱e̱. Amo̱se̱‑ɔ mo̱ne̱ ne̱ mo̱ne̱ de e̱se̱bɔ‑ɔ mo̱nꞌ nu ase̱ŋ ne̱ mo̱ a tɔwe̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kake ŋko̱ ne̱ leŋpoo akɔɔre̱po̱ bwe̱e̱tɔ na bamo̱ ne̱ bo̱ tii si ne̱ Yudaa awuye e̱ te̱e̱ bamo̱ ɛ e̱bɔye̱ awaapo̱‑ɔ a ba a bo̱ bo̱ nu Yeesuu ase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ne̱ Farisii awuye na Wuribware̱ mbraa akaapo̱po̱ ko̱ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ a ko̱so̱ ba tɛɛ fe̱yɛ, “Ke̱e̱, ɔnyare̱ mɔ e̱ sa ne̱ abɔye̱waapo̱ e̱ ba mò̱ ase̱, hare̱e̱ mò̱ aa bamo̱ i gyi ateese.” ");
INSERT INTO ncuNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mfe̱ŋ ne̱ Yeesuu a tɔwe̱ kitee mɔ gywii bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Mo̱nꞌ taa fe̱yɛ mo̱ne̱ ɔko̱ de e̱sanne̱ ke̱lafa, ne̱ ɔ de̱e̱re̱ bamo̱ se̱ e̱fa‑rɔ, ne̱ bamo̱ ɔko̱ ya fo̱, e̱me̱ne̱ ne̱ se̱sɛ‑ɔ e̱ waa? To, ɔ yɔwe̱ adukpanɔɔ na akpanɔɔ ne̱ baa saŋ‑ɔ a ɔ bo̱ sii bamo̱ gyirokpa ne̱e̱, na ɔ ya buwi kpa ɔko̱ŋko̱‑ɔ bo̱ fo̱ saŋ ne̱ o ŋu mò̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mò̱ ya ŋu mò̱, amɔ mò̱ akatɔ a gyi, na ɔ taa mò̱ bo̱ da abaakpa‑rɔ, ");
INSERT INTO ncuNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","na ɔ so̱rɔ yaa pe̱. Na ɔ te̱e̱ mò̱ nyare̱‑ana na mò̱ akye̱nabɛɛpo̱ bo̱ gyaŋŋe̱, na ɔ tɔwe̱ gywii bamo̱ fe̱yɛ, ‘Mo̱ a ŋu mo̱ sanne̱ ne̱ ɔɔ fo̱‑ɔ, ne̱ mo̱ akatɔ a gyi, amo̱se̱‑ɔ mo̱nꞌ sa a ane̱ gyi akatɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ ane̱ŋ dɛɛ ne̱ Wuribware̱ na mò̱ mbɔɔ akatɔ i gyi ɔbɔye̱waapo̱ ko̱ŋko̱ ne̱ o nu mò̱ e̱ye̱e̱, na o kiŋŋi le̱e̱ mò̱ e̱bɔye̱‑rɔ‑ɔ se̱, a bo̱ kyo̱ŋ ase̱sɛ adukpanɔɔ na kamɛɛ ne̱ bo̱ yɛ bo̱ kyɔ ba bu Wuribware̱, ne̱ a mo̱ŋ tiri fe̱yɛ bo̱ be̱e̱ nu bamo̱ e̱ye̱e̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ne̱ Yeesuu yɛ, “To, mo̱nꞌ be̱e̱ taa fe̱yɛ ɔkye̱e̱ ko̱ de asare̱e̱‑rɔ mpini kudu, ne̱ mmo̱‑rɔ kako̱ŋko̱ ya fo̱, e̱me̱ne̱ ne̱ ɔ waa? To, ɔ kyaŋŋe̱ fetiri ne̱e̱, na ɔ kpa pesi na ɔ kpane̱ mò̱ lɔŋ‑nɔ pɛɛɛ ɔ de̱e̱re̱ dame̱naŋsɛ ɔ kpa kamo̱ ane̱ŋ‑aaa, amɔ ɔ bo̱ ŋu. ");
INSERT INTO ncuNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Saŋ ne̱ oo ŋu‑o, na ɔ te̱e̱ mò̱ nyare̱‑ana na mò̱ akye̱nabɛɛpo̱ pɛɛɛ bo̱ gyaŋŋe̱, na ɔ tɔwe̱ gywii bamo̱ fe̱yɛ, ‘Mo̱ a ŋu mo̱ kapini ne̱ kaa fo̱‑ɔ, ne̱ mo̱ akatɔ a gyi, amo̱se̱‑ɔ mo̱nꞌ sa a ane̱ gyi akatɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ane̱ŋ se̱‑ɔ, mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ ane̱ŋ dɛɛ ne̱ ɔbɔye̱waapo̱ ko̱ŋko̱ kpeŋ gbaa ya nu mò̱ e̱ye̱e̱, ne̱ ɔɔ le̱e̱ mò̱ e̱bɔye̱‑rɔ, ne̱ Wuribware̱ a mbɔɔ‑ɔ akatɔ i gyi mò̱ se̱‑ɔ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Mfe̱ŋ ne̱ Yeesuu a kya se̱ tɔwe̱ e̱bɔye̱ awaapo̱ e̱ye̱e̱ kunu ase̱ŋ. Ne̱ ɔɔ tɔwe̱ kitee mɔ gywii bamo̱ fe̱yɛ, “N gye̱ ɔnyare̱ ko̱ ya dɛɛ kye̱na aaa? Ne̱ ɔɔ ko̱we̱ ŋnyaŋsɛɛ ŋnyɔ. Ne̱ baa bo̱ waa ayaafɔre̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kake ŋko̱ ne̱ mò̱ gyi kagyingyii‑o a tɔwe̱ gywii mò̱ se̱ fe̱yɛ, ‘N se̱, ke fo̱ kapo̱tɛɛ‑rɔ, na fo̱ taa mo̱ lee sa mo̱ mbe̱yɔmɔ.’ Ne̱ mò̱ se̱ a ke‑ro sa bamo̱ abɛɛ anyɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ke̱tɔ mo̱ŋ kyee, ne̱ kagyingyii‑o a fe mò̱ kapo̱tɛɛ ne̱ ɔɔ nya‑ɔ pɛɛɛ, ne̱ ɔɔ taa atanne̱‑ɔ. Amo̱ fe̱raa, ɔ mo̱ŋ lɛɛ kye̱na pe̱, ne̱ oo tu kpa yɔ to̱ŋ ko̱ ke̱fɔ ke̱fɔ. Ne̱ ɔɔ ya gyi atanne̱‑ɔ kanɔ‑rɔ lo̱we̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Saŋ ne̱ oo gyi amo̱ pɛɛɛ lo̱we̱, ne̱ ɔ mo̱ŋ lɛɛ o de sɛye̱‑ɔ, ne̱ ako̱ŋ dabe̱ ko̱ a ba swe̱e̱re̱ amo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Sɛye̱ ke̱‑mo̱ŋ‑lɛɛ kide se̱‑ɔ, ne̱ ɔɔ yɔ mfe̱ŋ a maŋ‑ɔ kigyi ko̱ ase̱ ya kpa kusuŋ. Ne̱ ɔnyare̱ amo̱ a taa mò̱ fe̱yɛ ɔ de̱e̱re̱ mò̱ aprako si. ");
INSERT INTO ncuNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mfe̱ŋ ne̱ ɔɔ yo̱rɔwe̱ fe̱yɛ ɔ de̱e̱ nya ateese ne̱ aprako‑o i gyi‑o gyi. Amaa aprako ateese amo̱ gbaa, ɔ mo̱ŋ nya ako̱ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Amo̱ fe̱raa bo̱ fo̱ saŋ ko̱‑ɔ, ne̱ mfɛɛre̱ timaa a ba mò̱ kuŋu‑ro, ne̱ ɔ yɛ, ‘N se̱ a ayaafɔre̱ ne̱ ba suŋ mò̱‑ɔ pɛɛɛ e̱ nya ateese ba gyi ba kpo̱ne̱, na m bo̱ mfe̱e̱ mo̱ i wu ako̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mo̱ i kiŋŋi a ŋ yɔ n se̱ ase̱, na ŋ ya tɔwe̱ gywii mò̱ fe̱yɛ, N se̱, mo̱ a waa bɔye̱ bo̱ kye fo̱ aa Wuribware̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Fo̱ ma lɛɛ te̱e̱ mo̱ ɛ fo̱ gyi, taa mo̱ bo̱ waa fo̱ ayaafɔre̱‑ɔ ɔko̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ne̱ ɔɔ ko̱so̱ me̱raa se̱ kiŋŋi ɔ yɔ mò̱ se̱ ase̱. Saŋ ne̱ ɔɔ fo̱ pe̱, ne̱ ɔ tɔ lɔŋ‑nɔ‑ɔ, ne̱ mò̱ se̱ a ŋu mò̱ le̱e̱ ke̱fɔ. Ne̱ mò̱ gyi‑o ase̱ŋ a waa mò̱ e̱wɛɛ, ne̱ ɔɔ ŋwɛɛnaŋ ya biri mò̱‑rɔ, ne̱ ɔɔ kyo̱kywe̱e̱ mò̱ ke̱daabɔŋ se̱ sa mò̱ aŋsɛ na ke̱ba pwɛɛ ne̱ mò̱ gyi‑o a dɛɛ ka mò̱ kanɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ne̱ mò̱ gyi‑o yɛ, ‘N se̱, mo̱ a waa bɔye̱ bo̱ kye fo̱ aa Wuribware̱. Fo̱ ma lɛɛ te̱e̱ mo̱ ɛ fo̱ gyi.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ne̱ mò̱ se̱ a sa ne̱ ɔɔ yɔwe̱ se̱ŋsa, ne̱ ɔɔ te̱e̱ mò̱ ayaafɔre̱. Ne̱ ɔ yɛ, ‘Mo̱nꞌ waa me̱naŋ taa awaagya timaa ne̱ n de‑o baa bo̱ buŋ mò̱, na mo̱nꞌ ba kapini bo̱ waa mò̱ ke̱sare̱e̱gyi‑ro, na mo̱nꞌ waa mò̱‑rɔ ase̱be̱ta. ");
INSERT INTO ncuNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Na ŋkee mo̱nꞌ kra kakpe̱ŋnyare̱e̱ ne̱ ka de mfɔ‑ɔ bo̱ mɔɔ, na ane̱ gyi ateese bo̱ gyi akatɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","A le̱e̱ fe̱yɛ a du ne̱e̱ fe̱yɛ mo̱ gyi mɔ a wu, ne̱ ɔɔ be̱e̱ kyiŋŋi le̱e̱ lowi‑ro‑o. Ɔɔ dɛɛ fo̱, amaa mbe̱yɔmɔ, mo̱ a ŋu mò̱.’ Ne̱ baa le̱e̱ ba gyi akatɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Amo̱‑ɔ ne̱ a yɔ se̱‑ɔ pɛɛɛ na mò̱ daa ne̱ mò̱ fe̱raa a sii mò̱ se̱ ase̱ pe̱‑ɔ bo̱ ndɔɔ‑rɔ. Ɔɔ le̱e̱ ndɔɔ‑rɔ mfe̱ŋ ɔ ba ɔ tɔ‑rɔ‑ɔ, ne̱ oo nu iliŋ na isoori si bamo̱ lɔŋ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ne̱ ɔɔ te̱e̱ ayaafɔre̱‑ɔ ɔko̱, ne̱ oo bise mò̱ fe̱yɛ, ‘Nte̱tɔ ase̱ŋ ya ba lɔŋ‑nɔ?’ ");
INSERT INTO ncuNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ne̱ ke̱yaafɔre̱‑ɔ yɛ, ‘Fo̱ tire ya kiŋŋi ba pe̱ ŋkpa na alaŋfiya‑ro, ne̱ fo̱ se̱ a mɔɔ kakpe̱ŋnyare̱e̱ ne̱ ka de mfɔ‑ɔ sa mò̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ne̱ mò̱ daa‑ɔ duŋ a fwii, ne̱ oo sii ke̱laŋbɛɛ. Ɔ yɛ ɔ maa lwee lɔŋ‑nɔ. Bamo̱ a tɔwe̱ ke̱tɔ ne̱ ɔɔ tɔwe̱‑ɔ gywii mò̱ se̱‑ɔ, ne̱ mò̱ se̱ a le̱e̱ kawu ya ko̱re̱ mò̱ na o lwee lɔŋ‑nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Amaa ɔɔ be̱ŋŋaa mò̱ se̱ ne̱e̱ fe̱yɛ, ‘Ke̱e̱ nsu de̱maŋte̱ mɔ ne̱ mo̱ a suŋ sa fo̱ fe̱yɛ mo̱ a gye̱ ke̱nya‑ɔ, ne̱ mo̱ a waa ke̱tɔ ke̱maa ne̱ fo̱ a tɔwe̱‑ɔ. Nte̱tɔ gbaa ne̱ fo̱ a sa mo̱? Fo̱ mo̱ŋ mɔɔ kate̱e̱re̱gyii gbaa sa mo̱, na mo̱ aa mo̱ nyare̱‑ana a wo̱ bo̱ gyi akatɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Amaa fo̱ gyi mɔ ne̱ ɔɔ ya nye̱ra fo̱ kapo̱tɛɛ akye̱e̱ se̱, ne̱ oo kiŋŋi ba pe̱‑ɔ fe̱raa, fo̱ a mɔɔ kakpe̱ŋnyare̱e̱ ne̱ ka de mfɔ‑ɔ sa mò̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ne̱ mò̱ se̱ a be̱ŋŋaa mò̱ fe̱yɛ, ‘Mo̱ gyi, fo̱ fe̱raa, fo̱ bo̱ mfe̱e̱ saŋ ke̱maa, ne̱ mo̱ ke̱tɔ ke̱maa gye̱ fo̱ lee. ");
INSERT INTO ncuNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Amaa a bware fe̱yɛ ane̱ gyi akatɔ, bo̱ le̱e̱ fe̱yɛ a du ne̱e̱ fe̱yɛ fo̱ tire mɔ a wu ne̱e̱, ne̱ mbe̱yɔmɔ ɔɔ be̱e̱ kyiŋŋi le̱e̱ lowi‑ro. Ɔɔ fo̱ ne̱e̱, amaa mbe̱yɔmɔ mo̱ a ŋu mò̱.’ ” Ne̱ Yeesuu yɛ, “Amo̱ e̱ gye̱ saase̱bɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ne̱ Yeesuu a tɔwe̱ kitee mɔ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “N gye̱ atɔ wuye ko̱ e̱ gye̱ ne̱ ɔ bo̱‑rɔ aaa? Ne̱ o de mò̱ ke̱yaafɔre̱ ko̱ ne̱ ɔ de̱e̱re̱ mò̱ kapo̱tɛɛ pɛɛɛ se̱‑ɔ. Ne̱ kake ŋko̱ baa tɔwe̱ gywii atɔ wuye‑o fe̱yɛ mò̱ ke̱yaafɔre̱ amo̱ e̱ nye̱ra mò̱ atanne̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Amo̱ fe̱raa, ne̱ ɔɔ te̱e̱ ke̱yaafɔre̱‑ɔ, ne̱ ɔɔ tɔwe̱ gywii mò̱ fe̱yɛ, ‘Mo̱ i nu ba tɔwe̱ fe̱yɛ fo̱ e̱ nye̱ra mo̱ atanne̱. Ane̱ŋ se̱‑ɔ taa mo̱ kapo̱tɛɛ pɛɛɛ bo̱ waa mo̱ ke̱sare̱e̱‑rɔ, a le̱e̱ fe̱yɛ ma lɛɛ sa a fo̱ de̱e̱re̱ mo̱ kapo̱tɛɛ‑ɔ se̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ne̱ ke̱yaafɔre̱‑ɔ a fa mò̱ mfɛɛre̱‑rɔ fe̱yɛ, ‘Mo̱ nyaŋpe̱ e̱ kpa a o lee mo̱ kusuŋ‑no. Ne̱ e̱me̱ne̱ ne̱ mo̱ e̱ waa? Mo̱ŋ bo̱ le̱ŋ a n taare̱ dɔɔ, ne̱ ipeere de mo̱ ke̱nare̱ ko̱re̱ atɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","To, ŋ nyi ane̱ŋ ne̱ mo̱ e̱ waa, na, mo̱ ya paŋ kusuŋ, na ŋ nya anyare̱ ne̱ mo̱ ya yɔ bamo̱ e̱lɔŋ‑nɔ na bo̱ kra mo̱ nɛɛnɛɛ‑ɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ne̱ ɔɔ te̱e̱ bamo̱ ne̱ bo̱ de mò̱ nyaŋpe̱ ko̱kɔ‑ɔ pɛɛɛ bo̱ gyaŋŋe̱. Ne̱ oo bise ɔgye̱ŋkpɛɛsɛ‑ɔ fe̱yɛ, ‘Afe̱ne̱ ne̱ fo̱ de mo̱ nyaŋpe̱ ko̱kɔ?’ ");
INSERT INTO ncuNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ne̱ ɔ yɛ, ‘Mfɔ aŋko̱re̱ ke̱lafa bo̱rɔ bo̱‑rɔ.’ Ne̱ ke̱yaafɔre̱‑ɔ yɛ, ‘Ke̱e̱, ko̱kɔ a wo̱re̱ ne̱ fo̱ a kyo̱rɛɛ sa mo̱ nyaŋpe̱‑ɔ. Taa na fo̱ kye̱na na fo̱ kyurowi ke̱lafa‑ɔ kyo̱rɛɛ fe̱yɛ amo̱ kanɔ bo̱ adunuu.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ne̱ ɔɔ be̱e̱ bise ɔko̱ ɛ, ‘Ne̱ fo̱, afe̱ne̱ ne̱ fo̱ de mo̱ nyaŋpe̱ ko̱kɔ?’ Ne̱ ɔ yɛ, ‘Yaabraa e̱bɔɔte̱ kakpe̱ŋ.’ Ne̱ ke̱yaafɔre̱‑ɔ yɛ, ‘Ke̱e̱ ko̱kɔ a wo̱re̱ ne̱ fo̱ a kyo̱rɛɛ sa mo̱ nyaŋpe̱‑ɔ mɔ. Taa na fo̱ kyurowi kakpe̱ŋ‑ɔ kyo̱rɛɛ fe̱yɛ amo̱ kanɔ gye̱ alafa aburuwa.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ane̱ŋ se̱‑ɔ saŋ ne̱ apoo wuye mɔ mò̱ nyaŋpe̱ a nu ke̱tɔ ne̱ ɔɔ waa‑ɔ, ne̱ ɔɔ kyo̱rɔ mò̱, a le̱e̱ fe̱yɛ o nyi ase̱ŋ. Ne̱ ɔ yɛ, ‘Kaye̱ mɔ‑rɔ ase̱sɛ de kanyiase̱ŋ bo̱ de bamo̱ bɛɛko̱‑ana bo̱ kyɔ ane̱ŋ ne̱ Wuribware̱ ase̱sɛ de bamo̱ bɛɛko̱‑ana Wuribware̱ ase̱sɛ‑ɔ.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ne̱ Yeesuu a kya se̱ fe̱yɛ, “Amo̱se̱‑ɔ, mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ, mo̱nꞌ ba mo̱ne̱ kaye̱‑rɔ a kapo̱tɛɛ‑ɔ bo̱ buwi kpa anyare̱ swe̱e̱re̱ mɔ mfe̱e̱, na mo̱ne̱ ya wu, ne̱ mo̱ne̱ kapo̱tɛɛ a kyo̱ŋ, Wuribware̱ e̱ kɔɔre̱ mo̱ne̱ kakatɔgyi‑ro, na ɔ sa mo̱ne̱ akyaŋ so̱so̱ mfe̱ŋ, na mo̱nꞌ kye̱na nsu pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ɔke̱maa ne̱ o gyi kase̱ŋtiŋ nse̱ŋ ngyingyii‑ro‑o i gyi kase̱ŋtiŋ ase̱ŋ dabe̱‑rɔ, ne̱ ɔko̱ ne̱ mò̱‑ɔ mò̱ e̱ ba aye̱ba nse̱ŋ ngyingyii‑ro‑o mɔ e̱ ba aye̱ba ase̱ŋ dabe̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mo̱ne̱ a mo̱ŋ taare̱ ba kase̱ŋtiŋ bo̱ kra kaye̱‑rɔ atɔ timaa‑o, e̱me̱ne̱ ne̱ Wuribware̱ e̱ waa na ɔ taa so̱so̱ a atɔ timaa kase̱ŋtiŋ‑o bo̱ sa mo̱ne̱ a mo̱nꞌ kra? ");
INSERT INTO ncuNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ne̱ mo̱ne̱ a mo̱ŋ taare̱ ba kase̱ŋtiŋ bo̱ kra ɔko̱ atɔ, nte̱tɔ se̱ ne̱ Wuribware̱ e̱ sa mo̱ne̱ atɔ ne̱ ɔɔ taa bo̱ be̱ya so̱so̱ keri si sa mo̱ne̱‑ɔ? ");
INSERT INTO ncuNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ke̱nya maa taare̱ a o suŋ anyaŋpe̱ anyɔ. Amo̱ ya ba ane̱ŋ, o kisi ɔko̱, na ɔ kpa ɔko̱ ase̱ŋ, na o suŋ ɔko̱ kyo̱ŋ ɔko̱. Amo̱se̱‑ɔ mo̱ne̱ maa taare̱ a mo̱nꞌ kpa Wuribware̱ na mo̱nꞌ be̱e̱ kpa atanne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Amɔ Farisii awuye‑o a nu ase̱ŋ ne̱ Yeesuu a tɔwe̱‑ɔ, ne̱ baa mɔse̱ mò̱, a le̱e̱ fe̱yɛ ba kpa atanne̱ bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ne̱ e̱ waa atɔ ne̱ a kaapo̱ fe̱yɛ mo̱ne̱ e̱ waa nɛɛnɛɛ‑ɔ ase̱sɛ ase̱, amaa Wuribware̱ e̱ gye̱ ne̱ o nyi ke̱tɔ ne̱ ke̱ bo̱ mo̱ne̱ ŋkpo̱nɔ‑rɔ‑ɔ, bo̱ le̱e̱ fe̱yɛ ke̱tɔ ne̱ se̱sɛ i bu fe̱yɛ ke̱ gye̱ kitimaa‑o, Wuribware̱ fe̱raa mo̱ŋ de ke̱mo̱ ɔ te̱e̱ sɛye̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mbraa ne̱ Wuribware̱ a bo̱rɔ Mosis si bo̱ sa mò̱ ase̱sɛ‑ɔ na ke̱tɔ ne̱ Wuribware̱ akyaamɛɛ‑ɔ a kyo̱rɛɛ‑ɔ a fo̱ Yohanee Osuubɔpo̱‑ɔ mbe̱e̱ se̱ ne̱e̱. Le̱e̱ mfe̱ŋ ne̱ ase̱sɛ a le̱e̱ ba nu Wuribware̱ a kuwure a ase̱ŋ timaa‑o. Ne̱ ɔke̱maa e̱ le̱ŋ e̱ye̱e̱ ɔ kpa a o tii kuwure‑o si. ");
INSERT INTO ncuNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Hare̱e̱ amo̱‑ɔ pɛɛɛ gbaa ooo, so̱so̱ na swe̱e̱re̱ kikpuri mo̱ŋ bo̱ le̱ŋ fe̱yɛ ane̱ŋ ne̱ Wuribware̱ a mbraa ne̱ ɔɔ bo̱rɔ Mosis si sa ane̱‑ɔ kase̱ŋkpare̱gyii ko̱ŋko̱ ke̱le̱e̱ mmo̱‑rɔ ase̱ŋ bo̱ le̱ŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","N taa fe̱yɛ ɔke̱maa ne̱ oo kine mò̱ ka ya waare̱e̱ ɔkye̱e̱ baŋbaŋ‑ɔ a waa kakye̱e̱kpa, ne̱ ɔko̱ ne̱ ɔɔ waare̱e̱ ɔkye̱e̱ ne̱ mò̱ kuri a kine mò̱‑ɔ mɔ a waa kakye̱e̱kpa‑ɔ dɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ne̱ Yeesuu a tɔwe̱ kitee mɔ fe̱yɛ, “N gye̱ atɔ wuye ko̱ ya dɛɛ kye̱na aaa? Ne̱ ɔɔ dɛɛ buŋ awaagya dame̱naŋsɛ timaa, ne̱ oo gyi kɔne̱ saŋ ke̱maa. ");
INSERT INTO ncuNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Ne̱ otiripo̱ ko̱ mɔ bo̱‑rɔ ne̱ ba te̱e̱ mò̱ ɛ Lasarus, ne̱ e̱lɔ te mò̱ kayo̱wɔre̱ se̱ to̱ŋ ke̱maa, hare̱e̱ igyono gbaa naa ba nyanne̱ e̱mo̱ se̱. Saŋ ke̱maa ba baa mò̱ atɔ wuye amo̱ lɔŋ kanɔ o de te̱maa fe̱yɛ ɔ nya ateese ne̱ atɔ wuye amo̱ i gyi, ne̱ a le̱e̱ a da swe̱e̱re̱‑ɔ a o gyi. ");
INSERT INTO ncuNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ne̱ otiripo̱ amo̱ a bo̱ wu, ne̱ Wuribware̱ a mbɔɔ‑ɔ a bo̱ so̱rɔ mò̱ yaa so̱so̱ yaa bo̱ kye̱na Abraham keri‑ro kakatɔgyi‑ro. Ne̱ atɔ wuye‑o mɔ a bo̱ wu, ne̱ baa pure mò̱, ne̱ baa waa mò̱ kale. ");
INSERT INTO ncuNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ne̱ ɔɔ yɔ mfe̱ŋ ne̱ abɔye̱waapo̱ ya wu, ne̱ baa yɔ ya gyi awo̱re̱fɔɔ‑ɔ. Ne̱ o gyi awo̱re̱fɔɔ mfe̱ŋ, ne̱ ɔɔ de̱e̱re̱ bo̱ kyo̱ŋwe̱ ŋu Abraham te ke̱fɔ, na Lasarus te mò̱ keri‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ne̱ ɔɔ te̱e̱ keŋkeŋ fe̱yɛ, ‘N nana Abraham, ŋu mo̱ e̱wɛɛ, na fo̱ sa a Lasarus ba ke̱sare̱e̱gyi bo̱ waa nkyu ko̱‑rɔ, na ɔ ba bo̱ dwe̱e̱ mo̱ gyeepu si, na e̱ye̱e̱ yuri mo̱, a le̱e̱ fe̱yɛ mo̱ e̱ye̱e̱ bo̱ mo̱ gya de̱e̱kpa mɔ‑rɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ne̱ Abraham a tɔwe̱ gywii mò̱ fe̱yɛ, ‘N nana, nyiŋŋi si fe̱yɛ fo̱ a kyɔ gyi fo̱ kɔne̱ saŋ ne̱ fo̱ te kaye̱‑rɔ‑ɔ, ne̱ Lasarus mɔ a gyi preepree. Amaa mbe̱yɔmɔ o gyi kɔne̱ mfe̱e̱ ne̱e̱, na fo̱ gyi awo̱re̱fɔɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Amo̱ kamɛɛ ke̱maŋtaŋ loorisɛ ko̱ da ane̱ aa fo̱ mbo̱ŋtɔ‑rɔ, ne̱ bamo̱ ne̱ bo̱ bo̱ mfe̱e̱ a keri‑o mɔ maa taare̱ a bo̱ kyo̱ŋ yɔ nno̱ŋ a keri‑o, ne̱ bamo̱ ne̱ bo̱ bo̱ mo̱ne̱ keri‑o mɔ maa taare̱ a bo̱ kyo̱ŋ ba mfe̱e̱ a keri‑o.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ne̱ atɔ wuye‑o yɛ, ‘Amo̱ fe̱raa, n nana Abraham, mo̱ e̱ ko̱re̱ fo̱ ne̱e̱, suŋ Lasarus bo̱ kyo̱ŋwe̱ swe̱e̱re̱ se̱ n se̱ a lɔŋ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","N de atire na adaa anuu mfe̱ŋ. Sa a ɔ yɔ na ɔ ya yii bamo̱ se̱, na bamo̱ mɔ bo̱ ma be̱e̱ ba kaye̱e̱gya awo̱re̱fɔɔ mɔ‑rɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ne̱ Abraham yɛ, ‘Bo̱ kyɔ bo̱ de abware̱se̱ŋ wo̱re̱‑ɔ. Amo̱se̱‑ɔ, sa a bo̱ bu ke̱tɔ ne̱ Mosis na Wuribware̱ a akyaamɛɛ‑ɔ a kyo̱rɛɛ bo̱ waa mò̱‑rɔ‑ɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ne̱ atɔ wuye‑o yɛ, ‘N nana Abraham, a mo̱ŋ kyɔ. Amaa ɔko̱ a kyiŋŋi le̱e̱ lowi‑ro yɔ bamo̱ ase̱ ne̱e̱, weetee ba nu bamo̱ e̱ye̱e̱, na bo̱ kiŋŋi le̱e̱ bamo̱ e̱bɔye̱‑rɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ne̱ Abraham be̱e̱ ɔ yɛ, ‘Bamo̱ e̱ mo̱ŋ gya Mosis a kanɔ‑ɔ se̱ na Wuribware̱ a akyaamɛɛ‑ɔ ase̱ŋ tɔwe̱sɛ se̱, ɔko̱ ya kyiŋŋi le̱e̱ lowi‑ro yɔ gbaa, bo̱ maa kyurowi bamo̱ mfɛɛre̱.’ ” Ne̱ Yeesuu yɛ, “To, ane̱ŋ ne̱ a du‑o ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ne̱ Yeesuu a tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “A waa dɛɛ atɔ ne̱ a sa a se̱sɛ waa bɔye̱‑ɔ e̱ ba, amaa ɔko̱ ne̱ ɔ sa ne̱ a ba‑ɔ i ŋu ase̱ŋ fɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Se̱sɛ amo̱ fe̱raa, bamo̱ ya ba kibu dabe̱ bo̱ da mò̱ ke̱bɔ‑rɔ, ne̱ baa twe̱e̱ mò̱ waa ɔpo̱o̱‑rɔ, a bɔ fe̱yɛ mò̱ a sa ne̱ ŋyaagyi mɔ ɔko̱ a waa bɔye̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Amo̱se̱‑ɔ mo̱nꞌ sa ke̱tɔ ne̱ mo̱ne̱ e̱ waa‑ɔ se̱. Fo̱ ko̱so̱bɛɛ ya waa fo̱ bɔye̱, tɔwe̱ gywii mò̱ fe̱yɛ ɔɔ waa bɔye̱, ne̱ mò̱ ya nu mò̱ e̱ye̱e̱, na fo̱ taa bo̱ ke mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ne̱ ɔko̱ ya waa fo̱ e̱bɔye̱, hare̱e̱ iluwi isunoo kake ko̱ŋko̱‑rɔ gbaa, ne̱ ke̱mo̱ ke̱ke̱maa mɔ ɔɔ ba fo̱ ase̱ bo̱ tɔwe̱ gywii fo̱ fe̱yɛ ɔɔ waa bɔye̱, a tiri fe̱yɛ fo̱ taa bo̱ ke mò̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ne̱ bamo̱ ne̱ Yeesuu a te̱e̱ bamo̱ mò̱ ayaa‑rɔ aye̱re̱po̱‑ɔ a tɔwe̱ gywii mò̱ fe̱yɛ, “Ane̱ e̱ kpa fe̱yɛ fo̱ sa a ane̱ ko̱kɔɔre̱gyi waa ko̱kyɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “Mo̱ne̱ dɛɛ mo̱ne̱ de ko̱kɔɔre̱gyi kafwe̱e̱ gbaa fe̱yɛ kiyii kigyi kagyingyii ne̱e̱, weetee mo̱ne̱ ya tɔwe̱ gywii nno̱ŋ a kiyii amo̱ fe̱yɛ, ‘Ko̱so̱ kyuwi fo̱ e̱ye̱e̱ ya bo̱ ye̱ra ɔpo̱o̱‑rɔ,’ ke̱ e̱ waa ke̱tɔ ne̱ mo̱ne̱ a tɔwe̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ne̱ Yeesuu yɛ, “Mo̱nꞌ sa a ane̱ taa fe̱yɛ fo̱ gye̱ nyaŋpe̱, ne̱ fo̱ de ke̱yaafɔre̱, ne̱ ɔ dɔɔ fo̱, bɛɛɛ ɔ de̱e̱re̱ fo̱ e̱sanne̱ se̱. Mò̱ ya le̱e̱ ndɔɔ‑rɔ ke̱de̱e̱pwɛta ba, fo̱ e̱ tɔwe̱ a fo̱ gywii mò̱ fe̱yɛ, ‘Aŋsɛ na ndɔɔ‑rɔ, bo̱ gyi ateese’ aaa? ");
INSERT INTO ncuNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Daabii, fo̱ e̱ tɔwe̱ a fo̱ gywii mò̱ ne̱e̱ fe̱yɛ, ‘Kyo̱ŋ ya de̱ŋa mo̱ ateese, na fo̱ taa baa mo̱ pwɛɛ, ne̱ mo̱ ya gyi lo̱we̱, na ŋkee fo̱ dɛɛ nya kpa ya waa fo̱ fɔŋfɔŋ ateese.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ke̱yaafɔre̱ ya waa ke̱tɔ ne̱ mò̱ nyaŋpe̱ e̱ tɔwe̱‑ɔ, ɔ mo̱ŋ de aŋsɛ na kusuŋ, bɛɛɛ mo̱ e̱ pe̱nna aaa? ");
INSERT INTO ncuNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ane̱ŋ dɛɛ ne̱ mo̱ne̱ gbaa mo̱ne̱ mo̱ŋ de. Ane̱ŋ se̱‑ɔ mo̱ne̱ ya waa ke̱tɔ ke̱maa ne̱ mo̱ne̱ nyaŋpe̱ Wuribware̱ yɛ mo̱nꞌ waa‑ɔ, mo̱nꞌ tɔwe̱ fe̱yɛ, ‘A mo̱ŋ tiri fe̱yɛ ane̱ nyaŋpe̱ sa ane̱ aŋsɛ na kusuŋ, a le̱e̱ fe̱yɛ ke̱tɔ ne̱ ɔɔ tɔwe̱ gywii ane̱‑ɔ dooo ne̱ ane̱ a waa.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","To, saŋ ne̱ Yeesuu maa se̱ ɔ yɔ Yɛro̱salɛm maŋ‑nɔ‑ɔ, ne̱ ɔɔ bo̱rɔ mfe̱ŋ ne̱ Samariya na Galile̱ya e̱swe̱e̱re̱ e̱ gyaŋŋe̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Saŋ ne̱ ɔ kpa a o lwee kamaŋgyii ko̱‑rɔ‑ɔ, ne̱ abwatɔpo̱ kudu ko̱ a tɔ mò̱‑rɔ, ne̱ baa ye̱re̱ ke̱fɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ne̱ baa tɔwe̱ keŋkeŋ fe̱yɛ, “Ane̱ nyaŋpe̱ Yeesuu, ŋu ane̱ e̱wɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yeesuu a ŋu bamo̱‑ɔ, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱nꞌ nare̱ a Wuribware̱ alɔŋŋɔpo̱ de̱e̱re̱ mo̱ne̱ ko̱lɔ ke̱e̱ fe̱yɛ mo̱ne̱ a kpaare̱ bɛɛɛ.” Bamo̱ a nare̱ ba yɔ‑ɔ, ne̱ bamo̱ ɔke̱maa ko̱lɔ‑ɔ a lo̱we̱ kpa‑rɔ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Amɔ bamo̱ ɔko̱ a ŋu fe̱yɛ ɔɔ kpaare̱‑ɔ, ne̱ oo kiŋŋi ɔ ba, na ɔ kyo̱rɔ Wuribware̱ keŋkeŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ne̱ ɔɔ bo̱ kpuni aŋurii Yeesuu ayaa‑rɔ sa mò̱ aŋsɛ na ko̱waa. Samariyanyi e̱ gye̱ ɔnyare̱ amo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ne̱ Yeesuu yɛ, “Ase̱sɛ kudu ko̱lɔ ne̱ mo̱ a kya, ne̱ ŋke̱e̱ akpanɔɔ ne̱ baa saŋ‑ɔ? ");
INSERT INTO ncuNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nte̱tɔ ne̱e̱, ne̱ mò̱ ne̱ ɔ mo̱ŋ gye̱ Isireeliinyi‑o fe̱raa wo̱re̱ ya kiŋŋi bo̱ sa Wuribware̱ aŋsɛ?” ");
INSERT INTO ncuNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Amo̱ fe̱raa ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Ko̱so̱, nare̱ dame̱naŋsɛ. Ane̱ŋ ne̱ fo̱ a kɔɔre̱ mo̱ gyi‑o si ne̱ fo̱ a kpaare̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ne̱ Farisii awuye ko̱ a bise Yeesuu saŋ ne̱ Wuribware̱ e̱ ba na ɔ bo̱ gyi mò̱ kuwure‑o. Ne̱ ɔɔ be̱ŋŋaa bamo̱ fe̱yɛ, “Wuribware̱ maa ba na ɔ bo̱ gyi mò̱ kuwure‑o ane̱ŋ ne̱ mo̱ne̱ i ŋu mò̱‑ɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","A mo̱ŋ gye̱ atɔ ne̱ ɔko̱ e̱ tɔwe̱ fe̱yɛ, ‘Ke̱e̱ mò̱ e̱ bo̱ mfe̱e̱‑ɔ ne̱e̱,’ bɛɛɛ ‘Ke̱e̱ mò̱ e̱ bo̱ nno̱ŋ‑ɔ ne̱e̱.’ Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ mbe̱yɔmɔ gbaa Wuribware̱ maa se̱ o gyi mò̱ kuwure‑o mo̱ne̱ ase̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ne̱ oo buruwaa tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Saŋ ko̱ e̱ ba ne̱ mo̱ne̱ e̱ kpa fe̱yɛ mo̱nꞌ ŋu kake ko̱ŋko̱ gbaa ne̱ mo̱, dimaadi mò̱ gyi‑o, i gyi kuwure‑o. Amaa mo̱ne̱ maa ŋu kake amo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bo̱ko̱ e̱ tɔwe̱ a bo̱ gywii mo̱ne̱ fe̱yɛ, ‘Mo̱nꞌ de̱e̱re̱ nno̱ŋ’ bɛɛɛ ‘Mo̱nꞌ de̱e̱re̱ mfe̱e̱,’ mo̱ne̱ ma se̱re̱ gya bamo̱ se̱ mo̱ne̱ e̱ de̱e̱re̱ mo̱ne̱ e̱ kpa. ");
INSERT INTO ncuNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Fe̱yɛ ane̱ŋ ne̱ e̱lɛɛlɛɛ i gyi awo̱re̱‑rɔ le̱e̱ so̱so̱ kuŋu ya bo̱ fo̱ kuŋu mɔ, ane̱ŋ dɛɛ ne̱ mo̱, dimaadi mò̱ gyi‑o, i fu‑ro na m ba me̱naŋ. Na ɔke̱maa ŋu mo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Amaa pwɛɛ na saŋ‑ɔ dɛɛ fo̱‑ɔ, mo̱ i ŋu ase̱ŋ, na ndɔɔ a kaye̱ mɔ‑rɔ ase̱sɛ kine mo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ane̱ŋ ne̱ aa dɛɛ waa ane̱ ɔde̱daapo̱ Nowaa mbe̱e̱ se̱‑ɔ, ne̱ saŋ ne̱ mo̱, dimaadi mò̱ gyi‑o, e̱ ba‑ɔ e̱ waa. ");
INSERT INTO ncuNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Saŋ amo̱‑ɔ ɔke̱maa maa se̱ o gyi ateese na o nuu nta, na anyare̱ na akye̱e̱ e̱ waare̱e̱ abɛɛ ane̱ŋ‑aaa, na ba fa fe̱yɛ sɛye̱ maa waa bamo̱, ya bo̱ fo̱ kake ne̱ Nowaa a lwee mò̱ ko̱re̱e̱ dabe̱ dabe̱ ne̱ ɔɔ waa‑ɔ, ne̱ kufwiiri‑o a bo̱ mɔɔ bamo̱ pɛɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Saŋ amo̱ e̱ ba a ɔ bo̱ waa ne̱e̱ fe̱yɛ ke̱tɔ ne̱ kaa waa Lɔt mbe̱e̱ se̱‑ɔ. Saŋ amo̱‑ɔ ɔke̱maa ne̱ o te Sɔdɔm maŋ‑nɔ‑ɔ be̱e̱ ɔ maa se̱ o gyi ateese na o nuu nta, na o gyi yawo̱, na ɔ dɔɔ, na ɔ pwɛɛ e̱lɔŋ, na ba fa fe̱yɛ sɛye̱ maa waa bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ke̱mo̱ kake ne̱ Lɔt a de̱ŋ le̱e̱ bamo̱ maŋ amo̱‑rɔ‑ɔ ne̱ de̱e̱kpa na kafirewuta a le̱e̱ so̱so̱ fe̱yɛ bware̱‑ɔ bo̱ mɔɔ maŋ amo̱ a ase̱sɛ‑ɔ pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Kake ne̱ mo̱, dimaadi mò̱ gyi‑o, e̱ ba‑ɔ, ane̱ŋ dɛɛ ne̱ ke̱tɔ e̱ waa‑ɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kake amo̱ ɔke̱maa ne̱ ɔ bo̱ kawu‑o ma kpo̱ne̱ mò̱ e̱ye̱e̱ kiŋŋi ba lɔŋ‑nɔ fe̱yɛ ɔ ba a ɔ bo̱ swii mò̱ atɔ. Ane̱ŋ dɛɛ ne̱ ɔko̱ ne̱ ɔ bo̱ ndɔɔ‑rɔ‑ɔ ma kpo̱ne̱ mò̱ e̱ye̱e̱ kiŋŋi yɔ pe̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mo̱nꞌ nyiŋŋi Lɔt mò̱ ka na lowi suyo ne̱ oo wu‑o si. ");
INSERT INTO ncuNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ɔke̱maa ne̱ ɔ kpa a ɔ me̱raa se̱ kye̱na mò̱ kakye̱na ne̱ o te mbe̱yɔmɔ‑ɔ maa nya ŋkpa. Amaa ɔke̱maa ne̱ o kperi mo̱ se̱ na o wu‑o e̱ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ kake amo̱ ne̱ mo̱ i kiŋŋi a m ba‑ɔ kanye ase̱sɛ anyɔ da ke̱kyaŋ ko̱ŋko̱‑rɔ ba di idi, na m bo̱ lee ɔko̱ŋko̱ yaa mo̱ ase̱ yɔwe̱ ɔko̱ŋko̱ mɔ bo̱ sii. ");
INSERT INTO ncuNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Na akye̱e̱ anyɔ ko̱ mɔ bo̱ to̱ŋ ko̱ŋko̱ ba kwɛɛ abwaye, na m bo̱ lee ɔko̱ŋko̱ yɔwe̱ mò̱ bɛɛko̱‑ɔ bo̱ sii.  ");
INSERT INTO ncuNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Na anyare̱ anyɔ bo̱ ndɔɔ‑rɔ ba dɔɔ, na m bo̱ lee ɔko̱ŋko̱ yɔwe̱ mò̱ bɛɛko̱‑ɔ bo̱ sii.” ");
INSERT INTO ncuNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ne̱ Yeesuu agyase̱po̱‑ɔ a bise mò̱ fe̱yɛ, “Ane̱ nyaŋpe̱, mfe̱ne̱ ne̱ amo̱‑ɔ pɛɛɛ e̱ waa?” Ne̱ ɔɔ be̱ŋŋaa fe̱yɛ, “Ɔko̱ ya buwi kpa bamo̱ ne̱ baa mɔɔ bamo̱‑ɔ afuniŋ, o ŋu apate̱yɛ pwɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ne̱ Yeesuu a tɔwe̱ kitee mɔ gywii mò̱ agyase̱po̱‑ɔ bo̱ kaapo̱ bamo̱ fe̱yɛ bo̱ de̱e̱ ko̱re̱ ke̱bware̱ko̱re̱ saŋ ke̱maa, na bo̱ ma yɔwe̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ne̱ ɔ yɛ, “N gye̱ ɔse̱ŋgyipo̱ ko̱ ya dɛɛ kye̱na maŋ ko̱ se̱ aaa? Ne̱ ɔ mo̱ŋ se̱re̱ Wuribware̱, ne̱ mò̱‑ɔ mò̱ maa bu se̱sɛ ke̱maa. ");
INSERT INTO ncuNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Amɔ kpenlekye̱e̱ ko̱ mɔ bo̱ maŋ amo̱‑rɔ dɛɛ, ne̱ ɔ naa ɔse̱ŋgyipo̱ amo̱ ase̱ saŋ ke̱maa ɔ ko̱re̱ mò̱ fe̱yɛ, ‘Mo̱ bɛɛko̱ ko̱ a waa mo̱ bɔye̱. Amo̱se̱‑ɔ mo̱ e̱ kpa fe̱yɛ fo̱ te̱e̱ mo̱ aa mò̱ na ane̱ tɔwe̱ amo̱ ase̱ŋ.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Ɔkye̱e̱ amo̱ a ye̱re̱ ɔse̱ŋgyipo̱ amo̱ se̱ ko̱ko̱re̱ ane̱ŋ‑aaa kyee, na ɔ maa be̱ŋŋaa mò̱, pwɛɛ ne̱ saŋ ko̱ ɔse̱ŋgyipo̱‑ɔ yɛ, ‘Hare̱e̱ mo̱ a mo̱ŋ se̱re̱ Wuribware̱, ne̱ mo̱‑ɔ mɔ maa bu se̱sɛ ke̱maa‑ɔ gbaa, bo̱ le̱e̱ ane̱ŋ ne̱ ɔkye̱e̱ mɔ naa ɔ tɔɔraa mo̱‑ɔ se̱‑ɔ, mo̱ e̱ te̱e̱ bamo̱, na ane̱ tɔwe̱ bamo̱ ase̱ŋ. Mo̱ e̱ mo̱ŋ waa ane̱ŋ sa mò̱, ɔ de̱e̱ nare̱ mo̱ se̱ ane̱ŋ‑aaa, na mò̱ ase̱ŋ bo̱ kpe mo̱.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Mo̱nꞌ nu ase̱ŋ ne̱ apoo ɔse̱ŋgyipo̱ amo̱ a tɔwe̱ gywii mò̱ e̱ye̱e̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Mbe̱yɔmɔ ne̱ apoo ɔse̱ŋgyipo̱‑ɔ ya kya kpenlekye̱e̱ amo̱‑rɔ fe̱raa, amo̱ fe̱raa a waa dɛɛ fe̱yɛ Wuribware̱ e̱ kya ase̱sɛ ne̱ oo lee sa mò̱ e̱ye̱e̱, ne̱ ba su ba te̱e̱ mò̱ kanye na mpase̱‑ɔ‑rɔ. Ɔ mo̱ŋ gye̱ ɔko̱ ne̱ ɔ tɔwe̱ fe̱yɛ, ‘Yɔ a fo̱ ba nyaŋe̱’‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ ɔ ba me̱naŋ, na ɔ bo̱ kya mò̱ ase̱sɛ‑rɔ, na bo̱ nya bamo̱ e̱ye̱e̱ le̱e̱ bamo̱ ado̱ŋ ke̱sare̱e̱‑rɔ. Amaa mo̱, dimaadi mò̱ gyi‑o, ya ba swe̱e̱re̱ mɔ se̱ nyɔse̱po̱, mo̱ i ŋu fe̱yɛ ase̱sɛ saŋ ba gyi Wuribware̱ ba gyi aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ne̱ Yeesuu a be̱e̱ tɔwe̱ kitee mɔ gywii bamo̱ ne̱ ba fa fe̱yɛ bamo̱ wo̱re̱ e̱ gye̱ ase̱sɛ timaa, ne̱ bo̱ mo̱ŋ lɛɛ bo̱ de ɔko̱ ba te̱e̱ sɛye̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ne̱ ɔ yɛ, “N gye̱ ase̱sɛ anyɔ ko̱ e̱ bo̱‑rɔ aaa? Bamo̱ ɔko̱ gye̱ Farisiinyi. Ne̱ ɔko̱ mɔ gye̱ leŋpoo ɔkɔɔre̱po̱. Ne̱ baa yɔ Wuribware̱ suŋkpa‑ɔ kabuno, na bo̱ ya ko̱re̱ ke̱bware̱ko̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ne̱ Farisiinyi‑o a ye̱re̱ mò̱ ko̱kwe̱e̱, ne̱ ɔɔ ko̱re̱ ke̱bware̱ko̱re̱ fe̱yɛ, ‘Wuribware̱, mo̱ e̱ sa fo̱ aŋsɛ na kusuŋ fe̱yɛ mo̱ a mo̱ŋ gye̱ ogyimɔre̱po̱ na apoonyi na ɔkye̱e̱kpapo̱ fe̱yɛ ɔke̱maa‑ɔ. Mo̱ e̱ sa fo̱ aŋsɛ fe̱yɛ mo̱ a mo̱ŋ du fe̱yɛ leŋpoo ɔkɔɔre̱po̱ mɔ ne̱ ɔ ye̱re̱ nno̱ŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ŋke nsunoo ke̱maa‑rɔ mo̱ e̱ kra ako̱ŋ ŋke ŋnyɔ, mo̱ i lee ke̱tɔ ke̱maa ne̱ mo̱ a nya‑ɔ‑rɔ ntuŋkare̱ kudu‑ro katuŋkare̱ ko̱ŋko̱ bo̱ lɔŋŋɔ fo̱, Wuribware̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Amaa leŋpoo ɔkɔɔre̱po̱‑ɔ fe̱raa, ɔɔ ye̱re̱ kamɛɛ ne̱e̱. Ɔ mo̱ŋ taare̱ yase̱ mò̱ kuŋu so̱so̱ gbaa, ne̱ ɔɔ ba asare̱e̱ bo̱ yee kakpo̱nɔ‑rɔ, ne̱ ɔ yɛ, ‘Wuribware̱, ɔbɔye̱waapo̱ e̱ gye̱ mo̱, amo̱se̱‑ɔ ŋu mo̱ e̱wɛɛ.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ne̱ Yeesuu a tɔwe̱ bo̱ gye̱ kɛɛ fe̱yɛ, “Leŋpoo ɔkɔɔre̱po̱‑ɔ ke̱bware̱ko̱re̱ ya gyi Wuribware̱ akatɔ, bo̱ le̱e̱ fe̱yɛ ɔke̱maa ne̱ o bu mò̱ e̱ye̱e̱ ke̱dabe̱‑ɔ, Wuribware̱ e̱ baa mò̱ kaase̱, ne̱ ɔke̱maa ne̱ ɔ baa mò̱ e̱ye̱e̱ kaase̱‑ɔ mɔ, Wuribware̱ e̱ sa mò̱ ke̱dabe̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ne̱ ase̱sɛ ko̱ a baa bamo̱ ŋyaagyi Yeesuu ase̱ fe̱yɛ ɔ ba mò̱ asare̱e̱ bo̱ dɔŋŋɔ bamo̱ se̱ yure bamo̱. Amɔ mò̱ agyase̱po̱‑ɔ a ŋu ane̱ŋ‑ɔ, ne̱ baa kpa fe̱yɛ bo̱ gya bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Amaa Yeesuu a te̱e̱ ŋyaagyi‑o baa mò̱ ase̱, ne̱ ɔ yɛ, “Mo̱ne̱ ma gya ŋyaagyi‑o, mo̱nꞌ sa a bo̱ ba mo̱ ase̱, bo̱ le̱e̱ fe̱yɛ ane̱ŋ a ŋyaagyi mɔ na bamo̱ ne̱ bo̱ du fe̱yɛ bamo̱‑ɔ e̱ gye̱ ne̱ bo̱ tii Wuribware̱ a kuwure‑o si. ");
INSERT INTO ncuNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Na mo̱nꞌ nyiŋŋi si fe̱yɛ ɔke̱maa ne̱ ɔ maa sure si fe̱yɛ Wuribware̱ gyi kuwure fe̱yɛ ane̱ŋ ne̱ ŋyaagyi mɔ a sure si‑o maa tii Wuribware̱ a kuwure‑o si.” ");
INSERT INTO ncuNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ne̱ Yudaa awuye ɔgye̱ŋkpɛɛpo̱ ko̱ a bise Yeesuu fe̱yɛ, “Ɔkaapo̱po̱ timaa, e̱me̱ne̱ ne̱ mo̱ e̱ waa, na ŋ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ne̱ Yeesuu yɛ, “Nte̱tɔ se̱ ne̱ fo̱ e̱ te̱e̱ mo̱ ɛ otimaa? Ɔko̱ mo̱ŋ gye̱ otimaa be̱e̱ bo̱ tii Wuribware̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","To, fo̱ nyi Wuribware̱ a mbraa‑ɔ pɛɛɛ fe̱yɛ, ɔko̱ ma waa kakye̱e̱kpa, ɔko̱ ma mɔɔ mò̱ bɛɛko̱, ɔko̱ ma ywii, ɔko̱ ma te̱ŋ mò̱ bɛɛko̱ kanɔ, na ɔke̱maa bu mò̱ se̱ na mò̱ nyi.” ");
INSERT INTO ncuNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ne̱ ɔnyare̱ amo̱ a be̱ŋŋaa mò̱ fe̱yɛ, “Le̱e̱ mo̱ ŋyaagyi‑ro ne̱ mo̱ a le̱e̱ gya Wuribware̱ a mbraa mɔ pɛɛɛ se̱ bo̱ fo̱ ndɔɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yeesuu a nu ane̱ŋ‑ɔ, ne̱ ɔ yɛ, “Ke̱tɔ ko̱ŋko̱ ya saŋ fo̱ a fo̱ waa, na fo̱ ya wu na fo̱ kii atɔ wuye Wuribware̱ se̱. Amo̱ e̱ gye̱ fe̱yɛ fo̱ ya fe fo̱ kapo̱tɛɛ pɛɛɛ, na fo̱ taa atanne̱‑ɔ sa atiripo̱, na fo̱ bo̱ gya mo̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Amaa ɔnyare̱ amo̱ a nu mfaanɛɛ‑ɔ, a mo̱ŋ waa mò̱ kɔne̱, a le̱e̱ fe̱yɛ o de kapo̱tɛɛ bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yeesuu a ŋu fe̱yɛ a mo̱ŋ waa ɔnyare̱ amo̱ kɔne̱, ne̱ ɔ yɛ, “A waa le̱ŋ bwe̱e̱tɔ fe̱yɛ atɔ wuye a sure si fe̱yɛ Wuribware̱ gye̱ mò̱ owure. ");
INSERT INTO ncuNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nyɔma e̱ taare̱ a o lwee basa bɔ‑rɔ dare̱e̱ aaa? Ma kɔɔre̱ a n gyi. Amaa atɔ wuye kusure si fe̱yɛ Wuribware̱ gye̱ mò̱ owure bo̱ le̱ŋ ko̱ kyɔ nyɔma kulwee basa bɔ‑rɔ dare̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ne̱ bamo̱ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ a bise fe̱yɛ, “Ne̱ ŋkee nsɛ gbaa e̱ gye̱ ne̱ o de kpa fe̱yɛ ɔ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ne̱ Yeesuu a be̱ŋŋaa fe̱yɛ, “Se̱sɛ fe̱raa maa taare̱ a ɔ nya ane̱ŋ a ŋkpa‑ɔ, amɔ Wuribware̱ a sa mò̱ kpa.” ");
INSERT INTO ncuNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ne̱ Peetroo yɛ, “Ke̱e̱ ɛ, ane̱ a yɔwe̱ ke̱tɔ ke̱maa ane̱ gya fo̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Ne̱ Yeesuu mɔ yɛ, “Ɔɔŋ, mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ ɔke̱maa ne̱ oo kperi Wuribware̱ a kuwure‑o si, ne̱ ɔɔ yɔwe̱ mò̱ pe̱, bɛɛɛ mò̱ ka, bɛɛɛ mò̱ daa‑ana, bɛɛɛ mò̱ tire‑ana, bɛɛɛ mò̱ ako̱we̱po̱, bɛɛɛ mò̱ gyi‑ana‑ɔ e̱ nya ke̱tɔ ke̱maa ne̱ ɔɔ yɔwe̱‑ɔ bwe̱e̱tɔ a ɔ bo̱ tii si kaye̱ mɔ‑rɔ, na amo̱ kamɛɛ‑rɔ‑ɔ ɔ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ kaye̱ ne̱ ka ba a ka bo̱ ba‑ɔ‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ne̱ Yeesuu a lee mò̱ agyase̱po̱ kudu anyɔ‑ɔ keri si, ne̱ ɔ yɛ, “Mo̱nꞌ nu mo̱ ase̱. Ane̱ e̱ yɔ Yɛro̱salɛm maŋ‑nɔ ne̱e̱, mfe̱ŋ ne̱ mo̱, dimaadi mò̱ gyi‑o, ase̱ŋ ne̱ Wuribware̱ a akyaamɛɛ‑ɔ a kyo̱rɛɛ‑ɔ pɛɛɛ e̱ ba‑rɔ kase̱ŋtiŋ‑o. ");
INSERT INTO ncuNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ba taa mo̱ a bo̱ bo̱ sa Roma awuye ne̱ baa kɔɔre̱ ane̱ maŋ‑ɔ, na bo̱ mɔse̱ mo̱, na bo̱ saare̱ mo̱, na bo̱ twe̱e̱ akyɔne̱ we̱e̱ mo̱ se̱, ");
INSERT INTO ncuNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","na bo̱ da mo̱ paara, na bo̱ mɔɔ mo̱. Amaa ke̱mo̱ ŋke nsa, mo̱ i kyiŋŋi a n le̱e̱ lowi‑ro.” ");
INSERT INTO ncuNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Amaa mò̱ agyase̱po̱ mo̱ŋ pini ke̱tɔ ne̱ ɔɔ tɔwe̱‑ɔ. Amo̱se̱‑ɔ bo̱ mo̱ŋ nu amo̱‑ɔ pɛɛɛ kaase̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Saŋ ne̱ Yeesuu e̱ kpa a ɔ fo̱ Yɛrikoo maŋ, na te̱napo̱ nyare̱ ko̱ te kpa kɛɛ ɔ ko̱re̱ atɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mò̱ a nu ase̱sɛ biribiri ko̱ e̱ kyo̱ŋ‑ɔ, ne̱ oo bise fe̱yɛ, “Ntɔse̱ŋ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ne̱ bo̱ yɛ, “Yeesuu Nasarɛte̱nyi‑o e̱ gye̱ ne̱ ɔ kyo̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ne̱ ɔɔ faa‑rɔ fe̱yɛ, “Yeesuu, Deefid mò̱ nana, ŋu mo̱ e̱wɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ne̱ bamo̱ ne̱ bo̱ gye̱ ŋkpɛɛ‑ɔ e̱ fɛɛ mò̱ se̱ fe̱yɛ ɔ laatɔ. Ŋkee gbaa ne̱ ɔ maa se̱ ɔ faa‑rɔ keŋkeŋ fe̱yɛ, “Deefid mò̱ nana, ŋu mo̱ e̱wɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Amo̱ fe̱raa ne̱ Yeesuu a sii ye̱re̱, ne̱ ɔ yɛ bo̱ baa ɔnyare̱‑ɔ mò̱ ase̱. Mò̱ a ba‑ɔ, ne̱ Yeesuu a bise mò̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nte̱tɔ ne̱ fo̱ e̱ kpa fe̱yɛ ŋ waa sa fo̱?” Ne̱ ɔ yɛ, “Mo̱ nyaŋpe̱, mo̱ e̱ kpa fe̱yɛ fo̱ buŋŋi mo̱ akatɔ, na n de̱e̱ nya ŋu atɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Fo̱ akatɔ a buŋŋi. Fo̱ a kɔɔre̱ mo̱ gyi‑o si‑o, fo̱ a kpaare̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Puri amo̱‑rɔ mfe̱ŋ ne̱ ɔnyare̱ amo̱ akatɔ a buŋŋi nɛɛnɛɛ, ne̱ ɔɔ gya Yeesuu si, ne̱ ɔɔ sa Wuribware̱ aŋsɛ. Ase̱sɛ pɛɛɛ ne̱ bo̱ gya Yeesuu si‑o a ŋu amo̱‑ɔ, ne̱ baa kyo̱rɔ Wuribware̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ne̱ Yeesuu a lwee Yɛrikoo maŋ‑nɔ ɔ nare̱‑rɔ ɔ kyo̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Amɔ leŋpoo ɔkɔɔre̱po̱ bre̱sɛ ko̱ ne̱ o de atanne̱, ne̱ ba te̱e̱ mò̱ ɛ Sakiiyus‑o bo̱ maŋ‑ɔ‑rɔ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ɔnyare̱ mɔ e̱ kpa fe̱yɛ o ŋu Yeesuu, mò̱‑ɔ mò̱ a gye̱ se̱sɛ katiŋtiŋ‑o si‑o, ɔ maa nya a o ŋu mò̱ bo̱ le̱e̱ ase̱sɛ de̱maŋte̱ ne̱ baa muruwaa Yeesuu na ɔ naa‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ane̱ŋ se̱‑ɔ ne̱ ɔɔ ŋwɛɛnaŋ yɔ ase̱sɛ akatɔ‑rɔ, ne̱ ɔɔ ya de̱e̱ kuroŋku kiyii ne̱ ke̱ ye̱re̱ kpa kɛɛ mfe̱ŋ ne̱ Yeesuu e̱ ba a ɔ bo̱ kyo̱ŋ‑ɔ, na ɔ nya ŋu Yeesuu. ");
INSERT INTO ncuNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Saŋ ne̱ Yeesuu a bo̱ fo̱ mfe̱ŋ‑ɔ, ne̱ ɔɔ de̱e̱re̱ so̱so̱, ne̱ oo ŋu Sakiiyus, ne̱ ɔɔ tɔwe̱ gywii mò̱ fe̱yɛ, “Sakiiyus, waa me̱naŋ kpo̱ro̱we̱, bo̱ le̱e̱ fe̱yɛ fo̱ aye̱ ne̱ mo̱ e̱ so̱we̱ ndɔɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ne̱ Sakiiyus akatɔ a gyi, ne̱ ɔɔ waa me̱naŋ kpo̱ro̱we̱ bo̱ yaa Yeesuu mò̱ lɔŋ‑nɔ ya kra mò̱ dame̱naŋsɛ. ");
INSERT INTO ncuNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ne̱ ɔke̱maa ne̱ oo ŋu‑o a le̱e̱ ɔ tɛɛ fe̱yɛ, “Ɔnyare̱ mɔ a ya so̱we̱ nyiŋkpasɛ bɔye̱ mɔ aye̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ne̱ Sakiiyus a ko̱so̱ ye̱re̱ bamo̱ pɛɛɛ akatɔ‑rɔ, ne̱ ɔɔ tɔwe̱ gywii Yeesuu fe̱yɛ, “Mo̱ nyaŋpe̱, nu mfe̱e̱. Mo̱ e̱ taa mo̱ kapo̱tɛɛ‑ɔ ke̱be̱gya na m bo̱ ke atiripo̱. Ne̱ mo̱ ya gyi ɔko̱ kɔɔre̱ atanne̱ kyo̱ŋ amo̱ ne̱ a bware‑o, mo̱ i kiŋŋaa ke̱tɔ ne̱ mo̱ a gyi mò̱ ke̱mo̱‑rɔ‑ɔ iluwi e̱na na m bo̱ sa se̱sɛ amo̱, ne̱ a kyo̱ŋ amo̱ ne̱ ane̱ mbraa yɛ oyu e̱ ka a ɔ bo̱ teere‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ne̱ Yeesuu yɛ, “Lɔŋ wuye mɔ a kaapo̱ ne̱e̱ fe̱yɛ oo nu mò̱ e̱ye̱e̱. Ane̱ŋ se̱‑ɔ, Wuribware̱ a mo̱rɔwe̱ mò̱ ndɔɔ. Nte̱tɔ se̱ gbaa ne̱ leŋpoo ɔkɔɔre̱po̱ mɔ ma nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ? Mò̱ gbaa gye̱ ane̱ nana Abraham a ananagyi‑o ɔko̱ fe̱yɛ mo̱ne̱‑ɔ, bɛɛɛ? ");
INSERT INTO ncuNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","A le̱e̱ fe̱yɛ mo̱, dimaadi mò̱ gyi‑o, a ba a m bo̱ de̱e̱re̱ kpa abɔye̱waapo̱ ne̱e̱ na m mo̱rɔwe̱ bamo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Na ase̱sɛ amo̱ saŋ ba nu Yeesuu ase̱, ne̱ ɔɔ tɔwe̱ kitee mɔ gywii bamo̱. Amɔ saŋ amo̱‑ɔ na ɔ kpa a ɔ fo̱ Yɛro̱salɛm maŋ‑nɔ, ne̱ ba fa fe̱yɛ Wuribware̱ e̱ kpa a ɔ bo̱ gyi mò̱ kuwure‑o swe̱e̱re̱ se̱ mfe̱e̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ane̱ŋ se̱‑ɔ ne̱ Yeesuu yɛ, “N gye̱ se̱sɛ dabe̱ ko̱ ya dɛɛ kye̱na aaa? Ne̱ kake ŋko̱ ɔɔ ko̱so̱ ɔ yɔ maŋ ko̱ se̱ ke̱fɔ ke̱fɔ, na bo̱ ya ba mò̱ bo̱ gyi kuwure, na ke̱mo̱ kamɛɛ na o kiŋŋi ba pe̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pwɛɛ ne̱ ɔɔ dɛɛ yɔ‑ɔ, ɔɔ te̱e̱ mò̱ ayaafɔre̱ kudu, ne̱ ɔɔ sa bamo̱ ɔke̱maa siidii kakpe̱ŋ, ne̱ ɔ yɛ, ‘Mo̱nꞌ taa atanne̱‑ɔ bo̱ kyurowi‑ro bo̱ fo̱ saŋ ne̱ mo̱ e̱ ba‑ɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Amɔ ɔnyare̱ amo̱ aye̱ awuye‑o mɔ i kisi mò̱‑ɔ se̱‑ɔ, saŋ ne̱ ɔɔ yɔ‑ɔ, ne̱ baa suŋ mbɔɔ bo̱ gya mò̱ se̱, na bo̱ tɔwe̱ gywii bamo̱ ne̱ ba ba mò̱ a bo̱ bo̱ gyi kuwure‑o fe̱yɛ, ‘Ane̱ maa kpa a ɔnyare̱ mɔ waa ane̱ owure.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ɔnyare̱‑ɔ mɔ, baa ba mò̱ bo̱ gyi kuwure‑o, ne̱ oo kiŋŋi ba pe̱. Puri amo̱‑rɔ, ne̱ ɔɔ sa kanɔ fe̱yɛ mò̱ ayaafɔre̱‑ɔ ba mò̱ akatɔ‑rɔ na o ŋu atanne̱ ne̱ baa nya‑ɔ kanɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ne̱ ɔgye̱ŋkpɛɛsɛ‑ɔ a bo̱ ye̱re̱, ne̱ ɔ yɛ, ‘Mo̱ nyaŋpe̱, mo̱ a ba siidii kakpe̱ŋ ne̱ fo̱ a sa mo̱‑ɔ bo̱ nya siidii ŋkpe̱ŋ kudu bo̱ tii si.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ne̱ mò̱ nyaŋpe̱‑ɔ yɛ, ‘Fo̱ a waa atɔ, ke̱yaafɔre̱ timaa e̱ gye̱ fo̱. Mbe̱yɔmɔ mo̱ a kɔɔre̱ fo̱ gyi nse̱ŋ ngyingyii‑ro ŋu fo̱ kase̱ŋtiŋ. Amo̱se̱‑ɔ mo̱ e̱ taa mo̱ e̱maŋ‑ɔ kudu na n sa fo̱ a fo̱ de̱e̱re̱ se̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ne̱ ke̱yaafɔre̱ nyɔse̱po̱‑ɔ mɔ a ba bo̱ tɔwe̱ fe̱yɛ, ‘Mo̱ nyaŋpe̱, mo̱ a ba siidii kakpe̱ŋ ne̱ fo̱ a sa mo̱‑ɔ bo̱ nya siidii ŋkpe̱ŋ nnuu bo̱ tii si.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ne̱ ɔnyare̱ mɔ a tɔwe̱ gywii mò̱‑ɔ mò̱ fe̱yɛ, ‘Mo̱ e̱ taa mo̱ e̱maŋ‑ɔ inuu a n sa fo̱ a fo̱ de̱e̱re̱ se̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Ne̱ ɔsase̱po̱‑ɔ a bo̱ tɔwe̱ gywii mò̱ nyaŋpe̱ fe̱yɛ, ‘Mo̱ nyaŋpe̱, mo̱ a se̱re̱ fo̱, ne̱ ŋ nyi fe̱yɛ fo̱ ase̱ŋ bo̱ le̱ŋ, ne̱ fo̱ e̱ taa ke̱tɔ ne̱ ke̱ mo̱ŋ gye̱ fo̱ lee‑o, ne̱ fo̱ e̱ kɔɔre̱ adɔɔteese ne̱ fo̱ mo̱ŋ dwii‑o fo̱ i kii fo̱ lee‑o si‑o, ne̱ kufu a nya mo̱, ne̱ mo̱ a taa bo̱ kwe̱e̱rɔ kaprakɛɛ‑rɔ. Ke̱e̱ fo̱ siidii kakpe̱ŋ‑ɔ. Fo̱ lee ne̱e̱, amo̱se̱‑ɔ kɔɔre̱ fo̱ atɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ne̱ mò̱ nyaŋpe̱‑ɔ yɛ, ‘Ke̱yaafɔre̱ bɔye̱ na wo̱rɔgyapo̱ mɔ! Mo̱ e̱ ba ke̱tɔ ne̱ fo̱ fɔŋfɔŋ a tɔwe̱‑ɔ na m bo̱ bu fo̱ ke̱pɔ. Fo̱ nyi fe̱yɛ mo̱ ase̱ŋ bo̱ le̱ŋ, ne̱ mo̱ e̱ taa ke̱tɔ ne̱ ke̱ mo̱ŋ gye̱ mo̱ lee‑o, ne̱ mo̱ e̱ kɔɔre̱ adɔɔteese ne̱ mo̱ŋ dwii‑o mo̱ i kii mo̱ lee. ");
INSERT INTO ncuNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ne̱ e̱me̱ne̱ ya waa se̱ ne̱ fo̱ mo̱ŋ taa mo̱ atanne̱‑ɔ yaa bo̱ be̱ya baŋke̱‑rɔ, na mo̱ a kiŋŋi ba‑ɔ, na ŋ nya atanne̱ be̱e̱ bo̱ dɔŋŋɔ se̱?’ ");
INSERT INTO ncuNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ne̱ ŋkee ɔɔ tɔwe̱ gywii bamo̱ ne̱ bo̱ ye̱re̱ mfe̱ŋ‑ɔ fe̱yɛ, ‘Mo̱nꞌ kɔɔre̱ siidii kakpe̱ŋ ne̱ e̱ bo̱ mò̱ ase̱‑ɔ sa mò̱ ne̱ ɔɔ nya siidii ŋkpe̱ŋ kudu‑o.’  ");
INSERT INTO ncuNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Amaa baa be̱ŋŋaa ne̱e̱ fe̱yɛ, ‘Ane̱ nyaŋpe̱, ɔ kyɔ o de siidii ŋkpe̱ŋ kudu!’ ");
INSERT INTO ncuNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, ‘Ɔko̱ ne̱ o de ke̱tɔ‑ɔ, ba taa bwe̱e̱tɔ na bo̱ bo̱ tii mò̱ se̱, amaa ɔko̱ ne̱ ɔ mo̱ŋ de‑o fe̱raa, ba kɔɔre̱ kafwe̱e̱ ne̱ o de‑o na bo̱ bo̱ le̱e̱ mò̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Amaa mo̱ ado̱ŋ‑ɔ fe̱raa ne̱ bo̱ mo̱ŋ kpa fe̱yɛ n gyi kuwure‑o, mo̱nꞌ baa bamo̱ mfe̱e̱, na mo̱nꞌ bo̱ mɔɔ bamo̱ mo̱ akatɔ‑rɔ.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Saŋ ne̱ Yeesuu a tɔwe̱ amo̱‑ɔ lo̱we̱‑ɔ, ne̱ ɔɔ kya se̱ ɔ yɔ. Ne̱ ɔɔ gye̱ ase̱sɛ ŋkpɛɛ ɔ yɔ Yɛro̱salɛm maŋ‑nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","Bamo̱ a kyo̱ŋ kamaŋgyii ko̱ ne̱ ba te̱e̱ ɛ Bɛtaniya‑o, ne̱ ba kpa a bo̱ fo̱ kamaŋgyii ko̱ ne̱ ba te̱e̱ ɛ Bɛtɛfage̱‑ɔ ne̱ ka bo̱ Mfɔ-Ayii ke̱be̱e̱‑ɔ kaase̱‑ɔ, ne̱ oo suŋ mò̱ agyase̱po̱‑ɔ anyɔ bo̱ gye̱ ŋkpɛɛ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱nꞌ nare̱ kamaŋgyii ne̱ ka bo̱ akatɔ se̱‑ɔ‑rɔ. Mo̱ne̱ a de̱ŋ mo̱ne̱ i lweero‑o, mo̱ne̱ i ŋu bamo̱ a ŋure kuruma ko̱ ne̱ ɔ mo̱ŋ tɛɛ daŋ lo̱we̱, ne̱ ɔko̱ mo̱ŋ tɛɛ de̱e̱‑ɔ ye̱re̱, na mo̱nꞌ saŋŋe̱ baa mfe̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ɔko̱ ya bise mo̱ne̱ ke̱tɔ se̱ ne̱ mo̱ne̱ e̱ saŋŋe̱ kuruma‑o, na mo̱nꞌ tɔwe̱ gywii mò̱ fe̱yɛ, ‘Ane̱ nyaŋpe̱ e̱ gye̱ ne̱ ɔ kpa.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bamo̱ a yɔ‑ɔ, ane̱ŋ ne̱ Yeesuu a de̱ŋ kaapo̱ bamo̱‑ɔ, ne̱ baa ya ŋu. ");
INSERT INTO ncuNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Saŋ ne̱ bo̱ maa se̱ ba saŋŋe̱ kuruma‑o, ne̱ mò̱ wuye‑ana a bise fe̱yɛ, “Nte̱tɔ se̱ ne̱ mo̱ne̱ e̱ saŋŋe̱ kuruma‑o?” ");
INSERT INTO ncuNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ne̱ baa be̱ŋŋaa fe̱yɛ, “Ane̱ nyaŋpe̱ e̱ gye̱ ne̱ ɔ kpa.” ");
INSERT INTO ncuNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ne̱ baa taa mò̱ yaa Yeesuu. Ne̱ baa buŋŋi bamo̱ awaagya bo̱ buŋ kuruma‑o si, ne̱ baa kra Yeesuu‑ro, ne̱ ɔɔ de̱e̱ kye̱na se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yeesuu a de̱e̱ kuruma‑o ɔ yɔ‑ɔ, na ase̱sɛ e̱ brawe̱ bamo̱ awaagya‑rɔ ba be̱ya kabo̱re̱‑ɔ se̱ na ɔ nare̱ se̱ kyo̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Saŋ ne̱ Yeesuu a fo̱ mfe̱ŋ ne̱ kpa‑ɔ bɔ Mfɔ-Ayii ke̱be̱e̱‑ɔ kaase̱, ne̱ ɔ kpo̱ro̱we̱‑rɔ ɔ yɔ Yɛro̱salɛm maŋ‑nɔ‑ɔ, ne̱ ase̱sɛ de̱maŋte̱ ne̱ bo̱ gya mò̱ se̱‑ɔ a le̱e̱ ba sa Wuribware̱ aŋsɛ, na ba kyo̱rɔ mò̱ keŋkeŋ bo̱ le̱e̱ akpe̱ŋe̱ye̱e̱tɔ ne̱ ɔɔ sa ne̱ baa ŋu‑o pɛɛɛ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ba fɛɛ‑rɔ keŋkeŋ ba tɔwe̱ ne̱e̱ fe̱yɛ, “ ‘Wuribware̱ yure owure ne̱ ɔ ba mò̱ ke̱nyare̱‑rɔ‑ɔ.’ Ke̱tɔ ke̱maa a yuri Wuribware̱ se̱. Mò̱ ne̱ ɔ bo̱ so̱so̱‑ɔ nya ke̱dabe̱ na wuraa ooo!” ");
INSERT INTO ncuNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ne̱ Farisii awuye ne̱ bo̱ tii ase̱sɛ de̱maŋte̱ ne̱ bo̱ gya Yeesuu si‑o bo̱ko̱ a tɔwe̱ gywii Yeesuu fe̱yɛ, “Ɔkaapo̱po̱, ke̱tɔ ne̱ fo̱ agyase̱po̱‑ɔ e̱ tɔwe̱‑ɔ mo̱ŋ bo̱ daŋ. Tɔwe̱ gywii bamo̱ fe̱yɛ bo̱ laatɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ne̱ Yeesuu yɛ, “Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ bamo̱ ya laatɔ, afo̱re̱ na agyare̱kɔ fɔŋfɔŋ e̱ fɛɛ‑rɔ ane̱ŋ dɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Saŋ ne̱ Yeesuu a tɔ‑rɔ Yɛro̱salɛm, ne̱ oo ŋu ane̱ŋ ne̱ maŋ‑ɔ du‑o, ne̱ oo su sa maŋ‑ɔ ase̱sɛ. ");
INSERT INTO ncuNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Na ɔ tɔwe̱ fe̱yɛ, “Yɛro̱salɛm awuye, mo̱ne̱ dɛɛ mo̱ne̱ nyi kpa ne̱ Wuribware̱ e̱ kpa fe̱yɛ mo̱nꞌ bo̱rɔ se̱ na mo̱nꞌ nya kaye̱e̱yuri kase̱ŋtiŋ ne̱e̱ ooo, weetee ase̱ŋ maa to̱ mo̱ne̱. Amaa mo̱ne̱ mo̱ŋ nyi kpa amo̱ mbe̱yɔmɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Saŋ ko̱ e̱ ba ne̱ mo̱ne̱ ado̱ŋ e̱ ba, na bo̱ bo̱ tii mo̱ne̱ e̱kpa, na bo̱ kyaa muruwaa mo̱ne̱ bo̱ sii nse̱na. ");
INSERT INTO ncuNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Na bo̱ bo̱ kpuri mo̱ne̱ pɛɛɛ mɔ. Bo̱ maa yɔwe̱ mo̱ne̱ agyi gbaa. Na bo̱ bwee mo̱ne̱ akyaŋ pɛɛɛ. Ke̱fo̱re̱ serisɛ ko̱ŋko̱ gbaa maa saŋ na ke̱ ye̱re̱ ke̱mo̱ mbe̱yɔmɔ a ye̱re̱kpa‑ɔ, bo̱ le̱e̱ fe̱yɛ mo̱ne̱ mo̱ŋ pini fe̱yɛ ndɔɔ Wuribware̱ a ba, na ɔ bo̱ mo̱rɔwe̱ mo̱ne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kaye̱ ŋke‑o, ne̱ Yeesuu a be̱e̱ yɔ Yɛro̱salɛm maŋ‑nɔ ya lwee Wuribware̱ suŋkpa‑ɔ kabuno. Ne̱ oo ŋu ayawo̱gyipo̱ te mfe̱ŋ ba fe atɔ. Mò̱ a ŋu bamo̱ ane̱ŋ‑ɔ, ne̱ ɔɔ le̱e̱ ɔ gya bamo̱ ɔ le̱e̱ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Baa kyo̱rɛɛ abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ Wuribware̱ yɛ, ‘Mo̱ lɔŋ‑ɔ i kii ke̱kyaŋ ne̱ kaye̱ mɔ‑rɔ ase̱sɛ pɛɛɛ e̱ ba a bo̱ bo̱ nya ko̱re̱ ke̱bware̱ko̱re̱‑ɔ.’ Amaa mo̱ne̱ a taa mfe̱ŋ bo̱ kii ‘ayu lɔŋ ne̱e̱’ bɛɛɛ?” ");
INSERT INTO ncuNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","To, kake ke̱maa na Yeesuu naa Wuribware̱ suŋkpa a kabuno‑o ɔ kaapo̱ abware̱se̱ŋ. Ne̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na Wuribware̱ mbraa akaapo̱po̱‑ɔ na maŋ agye̱ŋkpɛɛpo̱‑ɔ e̱ kpa a bo̱ mɔɔ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Amaa bo̱ mo̱ŋ nya kpa, bo̱ le̱e̱ fe̱yɛ ase̱sɛ‑ɔ pɛɛɛ mɔ bo̱ mfe̱ŋ ba nu ase̱ŋ ne̱ ɔ tɔwe̱‑ɔ ne̱e̱, na bo̱ maa kpa fe̱yɛ ase̱ŋ‑ɔ ko̱ko̱ŋko̱ gbaa e̱ kyo̱ŋ bamo̱ se̱ na bo̱ mo̱ŋ nu. ");
INSERT INTO ncuNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kake ŋko̱ saŋ ne̱ Yeesuu bo̱ Wuribware̱ suŋkpa a kabuno‑o ɔ tɔwe̱ ase̱ŋ timaa‑o o gywii ase̱sɛ‑ɔ, ne̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na Wuribware̱ mbraa akaapo̱po̱‑ɔ na ŋkee maŋ agye̱ŋkpɛɛpo̱‑ɔ a ba Yeesuu ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ne̱ baa bo̱ bise mò̱ fe̱yɛ, “Nsɛ ya sa fo̱ kpa fe̱yɛ fo̱ gya ase̱sɛ bo̱ le̱e̱ Wuribware̱ suŋkpa a kabuno‑o mfe̱ŋ? Ne̱ nsɛ ya sa fo̱ kpa fe̱yɛ fo̱ kaapo̱ atɔ mfe̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Amo̱ fe̱raa ne̱ Yeesuu mɔ yɛ, “To, mo̱ i bise mo̱ne̱ ase̱ŋ ko̱ŋko̱ kpeŋ, ne̱ mo̱ne̱ ya taare̱ be̱ŋŋaa mo̱ nɛɛnɛɛ fe̱raa, mo̱‑ɔ mo̱ i lee mo̱ne̱ kanɔ. Mo̱nꞌ kaapo̱ mo̱ mò̱ ne̱ ɔɔ sa Yohanee Osuubɔpo̱‑ɔ kpa fe̱yɛ ɔ bɔ ase̱sɛ asuu‑o. Wuribware̱ ya sa mò̱ kpa bɛɛɛ dimaadi?” ");
INSERT INTO ncuNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ne̱ bamo̱ wo̱re̱ wo̱re̱ a le̱e̱ ba gyiiri ikii. Bo̱ yɛ, “E̱me̱ne̱ ne̱ ane̱ tɔwe̱‑ɔ ne̱e̱? Bo̱ le̱e̱ fe̱yɛ ane̱ ya tɔwe̱ ɛ Wuribware̱ ya sa Yohanee kpa a ɔ bɔ asuu, o bise ane̱ fe̱yɛ, ‘Nte̱tɔ se̱ ne̱e̱ ne̱ mo̱ne̱ mo̱ŋ kɔɔre̱ Yohanee gyi?’ ");
INSERT INTO ncuNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ne̱ ane̱ mɔ ane̱ ya tɔwe̱ fe̱yɛ dimaadi ya sa mò̱ kpa, ase̱sɛ mɔ e̱ twe̱e̱ ane̱ abu, a le̱e̱ fe̱yɛ baa kɔɔre̱ gyi fe̱yɛ Yohanee Osuubɔpo̱‑ɔ gye̱ Wuribware̱ a akyaamɛɛ‑ɔ ɔko̱ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ane̱ŋ se̱‑ɔ ne̱ baa be̱ŋŋaa Yeesuu fe̱yɛ, “Ane̱ mo̱ŋ nyi ɔko̱ ne̱ ɔɔ sa Yohanee kpa fe̱yɛ ɔ bɔ asuu‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ne̱ Yeesuu mɔ yɛ, “Ane̱ŋ fe̱raa ŋ gbaa ma tɔwe̱ ɔko̱ ne̱ ɔɔ sa mo̱ kpa fe̱yɛ ŋ waa ke̱tɔ ne̱ mo̱ e̱ waa‑ɔ a n gywii mo̱ne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ne̱ Yeesuu a tɔwe̱ kitee mɔ gywii ase̱sɛ‑ɔ. Ɔ yɛ, “N gye̱ ɔnyare̱ ko̱ ya dɛɛ kye̱na aaa? Ne̱ ɔɔ dɔɔ mò̱ bobe ayii ko̱, ne̱ a swɛɛ agyi ko̱ ne̱ bo̱ de ba waa nta‑ɔ. Ne̱ ɔɔ taa sa apafo̱wɔ ko̱ fe̱yɛ bo̱ de̱e̱re̱ se̱ sa mò̱, ne̱ ɔɔ le̱e̱ pe̱ yɔ to̱ŋ ko̱ ya kyee‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Saŋ ne̱ bobe agyi amo̱ a be̱re̱, ne̱ amo̱ kiteebe̱e̱ a fo̱‑ɔ, ne̱ ko̱dɔɔ‑ɔ wuye‑o a suŋ mò̱ ke̱yaafɔre̱ ko̱ bo̱ kyo̱ŋwe̱ apafo̱wɔ amo̱ ase̱, na ɔ yɔ na bo̱ ke ke̱tɔ ne̱ baa nya le̱e̱ ko̱dɔɔ‑ɔ‑rɔ, na bo̱ taa mò̱ lee‑o sa ke̱yaafɔre̱‑ɔ, na ɔ taa baa mò̱. Ke̱yaafɔre̱ amo̱ a yɔ‑ɔ, ne̱ apafo̱wɔ amo̱ a kra mò̱ da, ne̱ baa yɔwe̱ mò̱ bo̱ kyo̱ŋwe̱ mò̱ nyaŋpe̱ ase̱ asare̱e̱ kpaŋkpaŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ane̱ŋ se̱‑ɔ ne̱ ko̱dɔɔ‑ɔ wuye‑o a be̱e̱ suŋ mò̱ ayaafɔre̱‑ɔ ɔko̱ bamo̱ ase̱. Ne̱ baa be̱e̱ da mò̱ gbaa mò̱, ne̱ baa saare̱ mò̱ waa mò̱ ipeere, ne̱ oo kiŋŋi yɔ mò̱ nyaŋpe̱ ase̱ asare̱e̱ kpaŋkpaŋ dɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ne̱ ko̱dɔɔ‑ɔ wuye‑o a be̱e̱ suŋ ke̱yaafɔre̱ sase̱po̱, ne̱ apafo̱wɔ amo̱ a be̱e̱ da mò̱ maye̱ maye̱ se̱, ne̱ baa neŋ mò̱ le̱e̱ ko̱dɔɔ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ko̱dɔɔ‑ɔ wuye‑o a kiŋŋi ba‑ɔ, ne̱ ɔ yɛ, ‘Ne̱ ŋkee e̱me̱ne̱ ne̱ mo̱ e̱ waa? To, mo̱ i suŋ mo̱ fɔŋfɔŋ mo̱ gyi ko̱ŋko̱ ne̱ mo̱ e̱ kpa mò̱ ase̱ŋ‑ɔ ne̱e̱. Ŋ nyi fe̱yɛ a waa kanɔ ŋke̱maa mò̱ fe̱raa ba bu mò̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Saŋ ne̱ apafo̱wɔ amo̱ a ŋu kayaagyi‑o e̱ ba‑ɔ, ne̱ ŋkee ba tɔwe̱ ba gywii abɛɛ fe̱yɛ, ‘Ke̱e̱ ko̱dɔɔ‑ɔ wuye‑o mò̱ gyi‑o ne̱ mò̱ se̱ ya wu o gyi mò̱ kapo̱tɛɛ‑ɔ e̱ ba‑ɔ. Mo̱nꞌ sa a ane̱ mɔɔ mò̱, na mò̱ se̱ a ko̱dɔɔ mɔ kii ane̱ lee.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ne̱ baa gyiiri mò̱ le̱e̱ ko̱dɔɔ‑ɔ‑rɔ, ne̱ baa mɔɔ mò̱.” Ne̱ Yeesuu a tɔwe̱ bo̱ gye̱ kɛɛ fe̱yɛ, “To, mo̱ne̱ e̱ kɔɔre̱ mo̱ne̱ i gyi fe̱yɛ e̱me̱ne̱ ne̱ bobe ko̱dɔɔ‑ɔ wuye‑o e̱ waa apafo̱wɔ amo̱‑ɔ ne̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Mo̱ e̱ fa fe̱yɛ mò̱ fɔŋfɔŋ e̱ yɔ ne̱e̱ na ɔ ya mɔɔ ase̱sɛ‑ɔ pɛɛɛ, na ɔ be̱e̱ taa ko̱dɔɔ‑ɔ sa ase̱sɛ baŋbaŋ, na bo̱ de̱e̱re̱ se̱ sa mò̱.” Amɔ ase̱sɛ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ a nu ane̱ŋ ne̱ Yeesuu a tɔwe̱‑ɔ, ne̱ bo̱ yɛ, “Daabii. A mo̱ŋ bo̱ daŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Amo̱ fe̱raa ne̱ Yeesuu a de̱e̱re̱ bamo̱, ne̱ oo bise fe̱yɛ, “Ne̱ baa kyo̱rɛɛ abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ, ‘Ke̱fo̱re̱ serisɛ ko̱ ne̱ apwɛɛpo̱ de bo̱ pwɛɛ ne̱ baa kine ke̱mo̱ bo̱ twe̱e̱‑ɔ, ya ko̱ŋ bo̱ kii ke̱mo̱ ne̱ kaa le̱ŋ lɔŋ‑ɔ pɛɛɛ bo̱ ye̱ra‑ɔ.’ Mo̱ne̱ i nyi fe̱yɛ amo̱‑ɔ kaase̱ e̱ gye̱ e̱me̱ne̱? ");
INSERT INTO ncuNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Amaa mo̱ i yii mo̱ne̱ se̱ fe̱yɛ ɔke̱maa ne̱ mò̱ ya le̱e̱ da ke̱fo̱re̱ amo̱ se̱, ke̱ e̱ te̱ŋŋe̱ se̱sɛ‑ɔ‑rɔ kyikpuri kyikpuri. Ne̱ ke̱mo̱ ya le̱e̱ da ɔko̱ se̱, na ko̱ kwɛɛ mò̱ waa fe̱yɛ e̱se̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ne̱ Wuribware̱ mbraa akaapo̱po̱‑ɔ na Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ e̱ kpa a bo̱ kra Yeesuu mfe̱ŋ ne̱ ɔɔ tɔwe̱ kitee‑o, a le̱e̱ fe̱yɛ baa ŋu fe̱yɛ ɔɔ ba kitee‑o bo̱ kaapo̱ fe̱yɛ bo̱ du fe̱yɛ apafo̱wɔ bɔye̱ amo̱‑ɔ. Amaa bamo̱ a se̱re̱ ase̱sɛ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ se̱‑ɔ, bo̱ mo̱ŋ taare̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ane̱ŋ se̱‑ɔ ne̱ ba buwi ba kpa Yeesuu e̱kpa. Ne̱ baa suŋ ase̱sɛ ko̱, na bo̱ waa fe̱yɛ bo̱ gye̱ ase̱sɛ timaa‑o, na bo̱ yɔ Yeesuu ase̱, na bo̱ ya bise mò̱ ase̱ŋ lɔɔre̱ mò̱ kanɔ‑rɔ, na ɔ tɔwe̱ ke̱bɔye̱ ko̱, na bo̱ nya kra mò̱ yaa bo̱ sa gominaa‑o. ");
INSERT INTO ncuNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ne̱ akyɔŋŋɔpo̱ amo̱ a yɔ Yeesuu ase̱. Ne̱ baa bo̱ tɔwe̱ kɔne̱ kɔne̱ gywii mò̱ fe̱yɛ, “Ɔkaapo̱po̱, ane̱ nyi fe̱yɛ ase̱ŋ ne̱ fo̱ e̱ tɔwe̱ na fo̱ e̱ kaapo̱‑ɔ gye̱ kase̱ŋtiŋ. Fo̱ mo̱ŋ nyi fe̱yɛ se̱sɛ mɔ gye̱ se̱sɛ dabe̱ bɛɛɛ ɔ gye̱ se̱sɛ kagyingyii, fo̱ fe̱raa fo̱ e̱ kaapo̱ atɔ kase̱ŋtiŋ ne̱ Wuribware̱ e̱ kpa fe̱yɛ se̱sɛ dimaadi ke̱maa waa‑ɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Amo̱se̱‑ɔ ane̱ i bise fo̱ fe̱yɛ, Roma awuye a kɔ ke̱naa gyi ane̱ se̱ kɔɔre̱ ane̱ maŋ‑ɔ se̱‑ɔ, ane̱ ya ka leŋpoo sa bamo̱ owure dabe̱ ne̱ ba te̱e̱ mò̱ ɛ Kaye̱saa‑ɔ, ne̱ a kye ane̱ Wuribware̱ mbraa‑ɔ, bɛɛɛ a maa kye? Tɔwe̱ na ane̱ nu.” ");
INSERT INTO ncuNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Amaa Yeesuu a kyɔ pini fe̱yɛ ba kyɔ mò̱‑rɔ ba ke̱e̱ ne̱e̱‑ɔ se̱‑ɔ, ");
INSERT INTO ncuNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ne̱ ɔ yɛ, “Mo̱nꞌ taa atanne̱ fufuri kigyi ne̱ kaa fo̱ siidii kudu‑o, ne̱ mo̱ne̱ de mo̱ne̱ e̱ ka leŋpoo‑o baa a ŋ ke̱e̱.” Bamo̱ a taa baa‑ɔ, ne̱ oo bise bamo̱ fe̱yɛ, “Nsɛ fotoo na ke̱nyare̱ e̱ dɔŋ atanne̱‑ɔ se̱‑ɔ ne̱e̱?” Ne̱ bo̱ yɛ, “Owure Kaye̱saa lee ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ne̱ Yeesuu yɛ, “To, amo̱ fe̱raa mo̱nꞌ ka ke̱tɔ ne̱ ke̱ gye̱ Kaye̱saa lee‑o sa Kaye̱saa, na mo̱nꞌ ka ke̱mo̱ ne̱ ke̱ gye̱ Wuribware̱ lee‑o sa Wuribware̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ane̱ŋ ne̱ Yeesuu a lee bamo̱ ase̱ŋ‑ɔ kanɔ bo̱rɔ‑ɔ a sa ne̱ e̱ye̱e̱ a kpe̱ŋ bamo̱. Bo̱ mo̱ŋ taare̱ waa mò̱ ko̱tɔko̱ na ɔ nya tɔwe̱ ke̱bɔye̱ ko̱ lamaŋ‑ɔ‑rɔ, na bo̱ nya ye̱re̱ ke̱mo̱ se̱ bo̱ po̱rɔ mò̱. Ne̱ baa laatɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Amo̱ kamɛɛ‑rɔ ne̱ Sadukii awuye ko̱ a ba Yeesuu ase̱ ane̱ŋ dɛɛ na bo̱ bo̱ bise mò̱ ase̱ŋ. Sadukii awuye mɔ mɔ gye̱ Yudaa awuye ko̱ ne̱ ba kɔɔre̱ ba gyi fe̱yɛ se̱sɛ ya wu, mò̱ kayo̱wɔre̱ na mò̱ kra pɛɛɛ a wu, ne̱ ane̱ŋ se̱‑ɔ, ɔ maa taare̱ a o kyiŋŋi le̱e̱ lowi‑ro pɛɛɛ‑ɔ ne̱e̱. To, ne̱ baa bise Yeesuu fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ɔkaapo̱po̱, ane̱ ɔde̱daapo̱ Mosis ya kyo̱rɛɛ mbraa mɔ sa ane̱ fe̱yɛ, ɔko̱ ya wu yɔwe̱ mò̱ ka na bo̱ mo̱ŋ ko̱we̱ agyi, se̱sɛ‑ɔ mò̱ tire taa kpenlekye̱e̱‑ɔ waare̱e̱, na bo̱ nya ko̱we̱ kayaagyi, na bo̱ taa kamo̱ fe̱yɛ mò̱ daa ne̱ oo wu‑o mò̱ gyi ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","To, ɔnyare̱ ko̱ agyi nyaŋsɛ asunoo e̱ dɛɛ bo̱ bo̱‑rɔ. Ne̱ bamo̱‑rɔ ɔbre̱sɛ‑ɔ a waare̱e̱, ne̱ ɔɔ bo̱ wu yɔwe̱ ɔkye̱e̱‑ɔ, na mò̱ aa mò̱ mo̱ŋ ko̱we̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ne̱ ɔnyɔse̱po̱‑ɔ a bo̱ taa mò̱ be̱e̱ waare̱e̱, na mò̱ aa mò̱ be̱e̱ bo̱ mo̱ŋ ko̱we̱, ne̱ ɔnyare̱‑ɔ a bo̱ wu. ");
INSERT INTO ncuNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ɔsase̱po̱‑ɔ gbaa ane̱ŋ dɛɛ. Bamo̱ asunoo‑o pɛɛɛ a waare̱e̱ bamo̱ daa a kpenlekye̱e̱ amo̱ gyaŋŋe̱ se̱, ne̱ baa wu yɔwe̱ mò̱, na mò̱ aa bamo̱ ɔko̱ mo̱ŋ ko̱we̱ gyi ko̱ŋko̱ gbaa. ");
INSERT INTO ncuNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","A bo̱‑rɔ, ne̱ ɔkye̱e̱‑ɔ mɔ a bo̱ wu gya bamo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ne̱ mbe̱yɔmɔ bo̱ yɛ ɔke̱maa i kyiŋŋi a ɔ le̱e̱ lowi‑ro‑o. Kake nsi amo̱, bamo̱‑rɔ nsɛ e̱ gye̱ ne̱ o kii ɔkye̱e̱‑ɔ mò̱ kuri? Bo̱ le̱e̱ fe̱yɛ bamo̱ asunoo‑o pɛɛɛ mɔ a waare̱e̱ mò̱ bo̱ gyaŋŋe̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “Ndɔɔ a kaye̱‑ɔ anyare̱ na akye̱e̱ e̱ gye̱ ne̱ ba waare̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Saŋ ko̱ e̱ ba ne̱ bamo̱ ne̱ baa wu‑o i kyiŋŋi a bo̱ le̱e̱ lowi‑ro. Na bamo̱ ne̱ Wuribware̱ ase̱ bo̱ gye̱ ase̱sɛ timaa‑o bo̱ kye̱na mò̱ ase̱, na bo̱ ma lɛɛ wu. Bo̱ le̱e̱ ane̱ŋ ne̱ bo̱ maa lɛɛ wu‑o si‑o, bo̱ maa waare̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bo̱ le̱e̱ mfaanɛɛ se̱‑ɔ, bamo̱ kakye̱na‑rɔ e̱ waa ne̱e̱ fe̱yɛ Wuribware̱ a mbɔɔ‑ɔ lee‑o. Na ane̱ŋ ne̱ baa kyiŋŋi le̱e̱ lowi‑ro‑o si‑o, a kaapo̱ fe̱yɛ bo̱ gye̱ Wuribware̱ mò̱ gyi‑ana. ");
INSERT INTO ncuNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mo̱ne̱ fe̱raa mo̱ne̱ yɛ alowipo̱‑ɔ maa lɛɛ kyiŋŋi a bo̱ le̱e̱ lowi‑ro. Amaa mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ ane̱ ɔde̱daapo̱ Mosis gbaa a kaapo̱ fe̱yɛ alowipo̱‑ɔ saŋ ba kyiŋŋi a bo̱ le̱e̱ lowi‑ro ba. Mfe̱ŋ ne̱ ɔɔ kyo̱rɛɛ ane̱ŋ ne̱ ɔɔ kyo̱ŋ de̱e̱re̱ kiyii ne̱ ke̱ e̱ kywɛɛ‑ɔ ase̱ŋ‑ɔ, ɔ yɛ Wuribware̱ a tɔwe̱ gywii mò̱ fe̱yɛ, ‘Mo̱ e̱ gye̱ Wuribware̱ ne̱ fo̱ nana‑ana Abraham na Isak na Yakubu i suŋ‑o.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Amo̱ a gye̱ fe̱yɛ ane̱ ade̱daapo̱ amo̱ ne̱ baa wu‑o a saŋ ba suŋ Wuribware̱‑ɔ se̱‑ɔ, a kaapo̱ ne̱e̱ fe̱yɛ bamo̱ a wu gbaa ooo, bamo̱ e̱kra saŋ i te. Wuribware̱ ase̱ fe̱raa, bamo̱ ne̱ baa wu‑o na bamo̱ ne̱ bo̱ ke̱e̱‑ɔ pɛɛɛ te.” ");
INSERT INTO ncuNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yeesuu a tɔwe̱ ane̱ŋ lo̱we̱‑ɔ, ne̱ Wuribware̱ mbraa akaapo̱po̱‑ɔ bo̱ko̱ yɛ, “Ɔkaapo̱po̱, fo̱ a lee kanɔ nɛɛnɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Le̱e̱ saŋ amo̱ bo̱ yɔ, bamo̱ ɔko̱ mo̱ŋ lɛɛ taare̱ bise mò̱ ase̱ŋ daa. ");
INSERT INTO ncuNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ne̱ Yeesuu a bise bamo̱ se̱ŋbise ko̱ bo̱ be̱ŋŋaa mò̱ ne̱ baa bise mò̱‑ɔ. Ɔ yɛ, “E̱me̱ne̱ se̱ ne̱ bo̱ yɛ mò̱ ne̱ Wuribware̱ i suŋ a ɔ bo̱ kyo̱ŋwe̱ ne̱ ba te̱e̱ mò̱ ɛ Kristoo‑o e̱ le̱e̱ Owure Deefid a ke̱nana‑ɔ‑rɔ‑ɔ ne̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","A le̱e̱ fe̱yɛ Deefid fɔŋfɔŋ a tɔwe̱ mò̱ iliŋ a wo̱re̱‑ɔ‑rɔ ne̱e̱ fe̱yɛ, ‘Wuribware̱ a tɔwe̱ gywii mo̱ nyaŋpe̱ ne̱e̱ ɛ, Kye̱na mo̱ kigyise si mfe̱e̱, na n sa a fo̱ ado̱ŋ pɛɛɛ mɔ ba fo̱ kaase̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","To, Deefid a kyo̱rɛɛ ase̱ŋ amo̱ ne̱ Wuribware̱ a tɔwe̱ gywii ɔko̱ ne̱ o te mò̱ ase̱‑ɔ, Kristoo ne̱ ɔɔ tɔwe̱ gywii. Amo̱ a gye̱ ane̱ŋ se̱‑ɔ, ne̱ Deefid fɔŋfɔŋ a kyo̱rɛɛ te̱e̱ Kristoo fe̱yɛ mò̱ nyaŋpe̱, bamo̱ ya ko̱we̱ Kristoo ne̱ ɔɔ waa se̱sɛ dimaadi, e̱me̱ne̱ ne̱ ɔ waa a ɔ le̱e̱ Deefid a ke̱nana‑ɔ‑rɔ, na Deefid a kyɔ te̱e̱ Kristoo fe̱yɛ mò̱ nyaŋpe̱?” ");
INSERT INTO ncuNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Na ase̱sɛ‑ɔ pɛɛɛ saŋ ba nu ke̱tɔ ne̱ Yeesuu e̱ tɔwe̱‑ɔ, ne̱ ɔɔ tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mo̱nꞌ sa Wuribware̱ mbraa akaapo̱po̱‑ɔ se̱. Bamo̱ e̱ gye̱ ne̱ bo̱ naa bo̱ buŋ e̱kaare̱ so̱swe̱e̱ lamaŋ‑nɔ, ne̱ ba kpa fe̱yɛ ase̱sɛ de̱e̱ nya gyɔŋŋɔ ka bamo̱ nnɔ, ne̱ bo̱ te ngya dabe̱ se̱ ke̱bware̱ko̱re̱ akyaŋ‑nɔ na ateese gyikpa. ");
INSERT INTO ncuNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bamo̱ e̱ gye̱ ne̱ ba puni akpenlekye̱e̱ ba kɔɔre̱ bamo̱ e̱lɔŋ, na ba ko̱re̱ ke̱bware̱ko̱re̱ ane̱ŋ‑aaa na ase̱sɛ nya ŋu saŋ amo̱ fe̱yɛ bo̱ tɛɛ bo̱ gya Wuribware̱ se̱ nɛɛnɛɛ. Mfaanɛɛ a ase̱sɛ se̱‑ɔ ne̱ Wuribware̱ i gyiiri ke̱se̱bɔ bwe̱e̱tɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ne̱ Yeesuu a de̱e̱re̱ ŋu fe̱yɛ atɔ awuye de atanne̱ dabe̱ ba waa Wuribware̱ suŋkpa a atanne̱ a ke̱dakaa‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ne̱ ɔɔ be̱e̱ ŋu kpenlekye̱e̱ otiripo̱ ko̱ mɔ a taa e̱paso̱wa adunyɔ kpeŋ waa‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Mfe̱ŋ ne̱ Yeesuu a tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ pɛɛɛ fe̱yɛ kpenlekye̱e̱ otiripo̱ mɔ a afɔre̱yɛ‑ɔ kyɔ ɔke̱maa lee‑o. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Bo̱ le̱e̱ fe̱yɛ atɔ awuye‑o a lee bamo̱ atanne̱ ne̱ bo̱ de‑o si kafwe̱e̱ ne̱e̱ baa bo̱ bɔ afɔre̱yɛ‑ɔ, amaa kpenlekye̱e̱ otiripo̱ mɔ fe̱raa, ke̱tɔ ne̱ o de‑o pɛɛɛ ne̱ ɔɔ taa baa bo̱ bɔ afɔre̱yɛ‑ɔ. Mò̱ kapo̱tɛɛ pɛɛɛ ne̱ o de‑o ne̱ ɔɔ taa baa‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ a maa se̱ bo̱ bo̱ Wuribware̱ suŋkpa a kabuno‑o, ne̱ mò̱ agyase̱po̱‑ɔ bo̱ko̱ a tɔwe̱ ane̱ŋ ne̱ suŋkpa‑ɔ bo̱ daŋ‑ɔ ase̱ŋ, a le̱e̱ fe̱yɛ ase̱sɛ ko̱ a taa afo̱re̱ dame̱naŋsɛ bo̱ sa Wuribware̱, na apwɛɛpo̱‑ɔ bo̱ pwɛɛ mò̱ suŋkpa‑ɔ na ɔ nya waa daŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “Amo̱‑ɔ pɛɛɛ mɔ ne̱ mo̱ne̱ a ŋu‑o, saŋ ko̱ e̱ ba a ɔ bo̱ ba, na afo̱re̱ amo̱ ne̱ baa bo̱ pwɛɛ akyaŋ amo̱‑ɔ ko̱ŋko̱ gbaa maa sii mfe̱ŋ ne̱ ke̱ ye̱re̱ mbe̱yɔmɔ‑ɔ. Ba gye̱ra amo̱ pɛɛɛ a bo̱ bo̱ da.” ");
INSERT INTO ncuNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ke̱tɔ a waa kafwe̱e̱‑ɔ, ne̱ mò̱ agyase̱po̱‑ɔ a bise mò̱ fe̱yɛ, “Ɔkaapo̱po̱, saŋ mo̱ ne̱ ase̱ŋ mɔ pɛɛɛ ne̱ fo̱ a tɔwe̱ bo̱ le̱e̱ Wuribware̱ suŋkpa amo̱ se̱‑ɔ e̱ ba? Ne̱ nte̱tɔ atɔ e̱ gye̱ ne̱ a waa pwɛɛ na ane̱ dɛɛ ŋu fe̱yɛ saŋ amo̱ a fo̱?” ");
INSERT INTO ncuNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ne̱ Yeesuu yɛ, “Mo̱nꞌ sa se̱ na ɔko̱ ma pe̱nna mo̱ne̱, bo̱ le̱e̱ fe̱yɛ ase̱sɛ bwe̱e̱tɔ e̱ ba na bo̱ bo̱ pe̱nna mo̱ne̱ fe̱yɛ, ‘Mo̱ e̱ gye̱ Kristoo ne̱ Wuribware̱ a suŋ bo̱ kyo̱ŋwe̱‑ɔ,’ na bo̱ de mo̱ ke̱nyare̱ ba tɔwe̱ ase̱ŋ na bo̱ pe̱nna ase̱sɛ, na bo̱ be̱e̱ pe̱nna fe̱yɛ, ‘Kaye̱ e̱ kpa a ka gye̱ kɛɛ.’ Amaa mo̱ne̱ ma gya bamo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Saŋ amo̱ mo̱ne̱ ya nu e̱kɔ na anaa se̱, mo̱ne̱ ma sa a kufu nya mo̱ne̱, a le̱e̱ fe̱yɛ a waa kanɔ ŋke̱maa a ba ane̱ŋ pwɛɛ, amaa n gye̱ amo̱ e̱ gye̱ ne̱ a kaapo̱ fe̱yɛ kaye̱ e̱ kpa a ka gye̱ kɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ e̱maŋ e̱ kɔ abɛɛ na swe̱e̱re̱ ko̱ se̱ ase̱sɛ kɔ swe̱e̱re̱ ko̱ se̱ mɔ ase̱sɛ. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Swe̱e̱re̱ e̱ le̱e̱ a ɔ le̱ŋkpaŋ, na ako̱ŋ ba, na alɔgyi e̱wo̱re̱se̱ e̱wo̱re̱se̱ ba e̱swe̱e̱re̱ bwe̱e̱tɔ se̱, na mo̱nꞌ ŋu afuse̱ŋ na afutɔ a le̱e̱ awo̱re̱‑rɔ a ba. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Amaa pwɛɛ na atɔ mɔ pɛɛɛ dɛɛ waa‑ɔ, ba kperi ane̱ŋ ne̱ mo̱ne̱ gye̱ mo̱ agyase̱po̱‑ɔ se̱, na bo̱ daye̱ mo̱ne̱, na bo̱ waa mo̱ne̱ awo̱re̱fɔɔ. Na bo̱ kra mo̱ne̱ yaa ane̱ Yudaa awuye ke̱bware̱ko̱re̱ akyaŋ abre̱sɛ ase̱, na bo̱ tii mo̱ne̱. Na bo̱ po̱rɔ mo̱ne̱ awure na agominaa akatɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Amaa amo̱ e̱ gye̱ ne̱ a sa mo̱ne̱ kpa na mo̱nꞌ nya tɔwe̱ ase̱ŋ timaa‑o gywii bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mo̱ne̱ ma sa a ke̱tɔ tɔɔraa mo̱ne̱. Mo̱ne̱ ma sa a ase̱ŋ ne̱ mo̱ne̱ e̱ ya tɔwe̱ mfe̱ŋ‑ɔ mfɛɛre̱ tɔɔraa mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Bo̱ le̱e̱ fe̱yɛ mo̱ e̱ kaapo̱ mo̱ne̱ ase̱ŋ ne̱ mo̱ne̱ e̱ ya tɔwe̱ mfe̱ŋ‑ɔ, na n sa mo̱ne̱ kanyiase̱ŋ na ŋ kaapo̱ mo̱ne̱ ane̱ŋ ne̱ mo̱ne̱ e̱ ya tɔwe̱ ase̱ŋ ne̱ mo̱ne̱ do̱ŋ ke̱maa maa taare̱ a o gyiiri mo̱ne̱ ikii‑o. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ mo̱ne̱ ako̱we̱po̱ na adaa na atire na ako̱we̱bɛɛ na anyare̱ e̱ taa mo̱ne̱ a bo̱ sa a bo̱ mɔɔ mo̱ne̱ bo̱ko̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ase̱sɛ i kperi mo̱ se̱, na bo̱ kisi mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Amaa mo̱ne̱ ya ye̱re̱ keŋkeŋ fe̱raa, mo̱ne̱ e̱ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ, na mo̱ne̱ kuŋu si kipwiigyi ko̱ŋko̱ gbaa ma fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ne̱ Yeesuu yɛ, “Saŋ ne̱ mo̱ne̱ ya ŋu asoogyaa awuye a muruwaa Yɛro̱salɛm maŋ, amo̱ fe̱raa mo̱nꞌ pini fe̱yɛ a saŋ kafwe̱e̱ na maŋ‑ɔ kpuri. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Saŋ amo̱ bamo̱ ne̱ bo̱ bo̱ Yude̱ya swe̱e̱re̱ se̱‑ɔ, a tiri fe̱yɛ bo̱ se̱re̱ yɔ abe̱e̱‑rɔ, na bamo̱ ne̱ bo̱ bo̱ maŋ‑ɔ‑rɔ se̱re̱ le̱e̱, na bamo̱ ne̱ bo̱ mo̱ŋ bo̱ maŋ‑ɔ‑rɔ mɔ ma lɛɛ kiŋŋi yɔ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","A le̱e̱ fe̱yɛ saŋ amo̱ e̱ gye̱ ke̱se̱bɔgyiiri ŋke ne̱ baa kyo̱rɛɛ mmo̱ ase̱ŋ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Saŋ amo̱ adaŋpo̱kye̱e̱ na atrapo̱ i ŋu ase̱ŋ ne̱e̱ fɛɛ. Swe̱e̱re̱ amo̱ se̱ ase̱sɛ ase̱ŋ e̱ waa e̱wɛɛ bwe̱e̱tɔ, na Wuribware̱ be̱e̱ gyiiri ase̱sɛ‑ɔ ke̱se̱bɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Na bo̱ mɔɔ ase̱sɛ‑ɔ bo̱ko̱ apaŋ‑nɔ, na bo̱ kra bamo̱ bo̱ko̱ mɔ yaa tii nde̱ se̱ awuye e̱maŋ ke̱maa se̱, na bamo̱ ne̱ bo̱ maa kɔɔre̱ Wuribware̱ ba gyi‑o kpuri Yɛro̱salɛm maŋ amo̱ pɛɛɛ bo̱ fo̱ bamo̱ saŋ ne̱ ba gyi‑o kɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ne̱ Yeesuu a kya se̱ fe̱yɛ, “Saŋ amo̱‑ɔ ane̱ŋ ne̱ kyɔwe̱ na akye̱e̱‑e̱‑kpa‑agyi i kyurowi‑o i puruwe mo̱ne̱. Na swe̱e̱re̱ se̱ mɔ e̱maŋ ke̱maa se̱ ase̱sɛ ase̱ŋ waa e̱wɛɛ, na ɔpo̱o̱ kusu na mò̱ alaŋkpare̱ dabe̱ dabe̱‑ɔ sa a kufu nya ɔke̱maa. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ŋkee fe̱raa ase̱sɛ ya ŋu fe̱yɛ awo̱re̱‑rɔ ke̱tɔ ke̱maa a kyurowi ke̱mo̱ kye̱nakpa na nare̱kpa‑ɔ, ba ye̱re̱ a bo̱ gywii kaye̱ a ka gye̱ kɛɛ, na amo̱ kufu sa a bo̱ kiriŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","To, na mo̱, dimaadi mò̱ gyi‑o, le̱e̱ so̱so̱ n te awo̱re̱‑rɔ mo̱ e̱ ba ke̱yaale̱ŋ‑nɔ na ke̱laŋŋe̱rɔ dabe̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Amo̱‑ɔ pɛɛɛ ya le̱e̱ a waa‑ɔ, na mo̱nꞌ ko̱so̱ ye̱re̱ na mo̱nꞌ yase̱ mo̱ne̱ aŋu de̱e̱re̱ so̱so̱, a le̱e̱ fe̱yɛ saŋ amo̱ mo̱ne̱ ɔmo̱rɔwe̱po̱‑ɔ a tɔ‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ne̱ Yeesuu yɛ, “Mo̱nꞌ sa a figi kiyii‑o kaapo̱ mo̱ne̱ kanyiase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Mo̱ne̱ nyi fe̱yɛ ke̱mo̱ ya ba ke̱ e̱ kpa a ke̱ pɔwe̱, amɔ ke̱kyaare̱ e̱ kpa a ke̱ fo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","To, ane̱ŋ dɛɛ ne̱ mo̱ne̱ ya ŋu fe̱yɛ atɔ mɔ e̱ waa, na mo̱nꞌ pini fe̱yɛ Wuribware̱ a kuwure‑o saŋ e̱ kpa a ke̱ fo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ ndɔɔ a kaye̱ mɔ‑rɔ a ase̱sɛ‑ɔ bo̱ko̱ i ŋu saŋ ne̱ atɔ mɔ e̱ ba‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","So̱so̱ na swe̱e̱re̱ pɛɛɛ ase̱ŋ e̱ kyo̱ŋ, amaa mo̱ ase̱ŋ fe̱raa maa kyo̱ŋ daa.” ");
INSERT INTO ncuNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Ne̱ Yeesuu a tɔwe̱ bo̱ gye̱ kɛɛ fe̱yɛ, “Mo̱nꞌ sa mo̱ne̱ e̱ye̱e̱ se̱, na mo̱ne̱ ma sa a ateese na katanuu na kaye̱ mɔ‑rɔ ase̱ŋ kɔɔre̱ mo̱ne̱ mfɛɛre̱, na mo̱nꞌ nya ŋu ke̱tɔ ne̱ ke̱ e̱ ba‑ɔ. N gye̱ ane̱ŋ, kake ne̱ mo̱ i kiŋŋi a m ba swe̱e̱re̱ mɔ se̱‑ɔ i puruwe mo̱ne̱, na ka kra mo̱ne̱ katɛɛ‑rɔ fe̱yɛ ane̱ŋ ne̱ katɛɛ e̱ kra kabo̱‑ɔ. Kake amo̱ i puruwe ase̱sɛ pɛɛɛ ne̱ saŋ amo̱ bo̱ saŋ bo̱ te swe̱e̱re̱ se̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Amo̱se̱‑ɔ mo̱nꞌ waa siraa, na mo̱nꞌ de̱e̱ ko̱re̱ ke̱bware̱ko̱re̱ saŋ ke̱maa fe̱yɛ mo̱nꞌ lwee ase̱ŋ mɔ‑rɔ le̱e̱, na sɛye̱ ma waa mo̱ne̱, na mo̱nꞌ be̱e̱ nya taare̱ ye̱re̱ mo̱, dimaadi mò̱ gyi‑o, akatɔ‑rɔ kake amo̱ na kufu mo̱ŋ de mo̱ne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ŋke amo̱ saŋ ke̱maa Yeesuu naa Wuribware̱ suŋkpa a kabuno‑o ɔ kaapo̱ abware̱se̱ŋ, na amo̱ ya fo̱ ke̱de̱e̱pwɛta‑ɔ na ɔ ya di Mfɔ-Ayii ke̱be̱e̱‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Na gye̱gyaye̱ tututu ke̱maa ase̱sɛ‑ɔ e̱ gyaŋŋaa mò̱ Wuribware̱ suŋkpa a kabuno‑o ba nu ase̱ŋ ne̱ ɔ kaapo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ne̱ saŋ e̱ kpa a ɔ fo̱ fe̱yɛ bo̱ gyi Bodobodoo-ne̱-yiisi-mo̱ŋ‑te‑ro‑o na Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese‑o agyibe̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Saŋ amo̱‑ɔ amɔ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na Wuribware̱ mbraa akaapo̱po̱‑ɔ i buwi ba kpa e̱kpa ne̱ ba ye̱re̱ se̱ na bo̱ bo̱ kra Yeesuu mɔɔ‑ɔ. Ba kpa ane̱ŋ ne̱ ba waa na bo̱ mɔɔ mò̱, na ɔko̱ mo̱ŋ ŋu‑o ne̱e̱. A le̱e̱ fe̱yɛ bo̱ se̱re̱ ase̱sɛ bwe̱e̱tɔ ne̱ bo̱ naa Yeesuu ase̱ ba nu mò̱ ase̱ŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Amɔ Yeesuu agyase̱po̱ kudu anyɔ‑ɔ ɔko̱ bo̱‑rɔ ne̱ ba te̱e̱ mò̱ ɛ Yudas Kariyotinyi. Saŋ amo̱‑ɔ ne̱ Ɔbɔnsam a lwee Yudas mfɛɛre̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ane̱ŋ se̱‑ɔ, ne̱ ɔɔ yɔ ya tɔwe̱ gywii Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na Wuribware̱ suŋkpa a ade̱e̱re̱se̱po̱ abre̱sɛ‑ɔ ane̱ŋ ne̱ ɔ taare̱ a o gyi Yeesuu kidiburo gywii bamo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Amo̱ a waa bamo̱ kɔne̱‑ɔ se̱‑ɔ, ne̱ bo̱ yɛ ba ba atanne̱ a bo̱ ka mò̱ ko̱kɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ne̱ Yudas a sure si, ne̱ ɔɔ le̱e̱ ɔ kpa e̱kpa ne̱ ɔ ye̱re̱ se̱ na ɔ bo̱ nya Yeesuu sa bamo̱, na ɔko̱ mo̱ŋ pini‑ro‑o. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","8","Kake nsi ne̱ ba gyi Bodobodoo-ne̱-yiisi-mo̱ŋ‑te‑ro‑o, na bo̱ mɔɔ nsanne̱gyii a bo̱ bo̱ gyi Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese‑o, ne̱ Yeesuu a suŋ Peetroo na Yohanee bo̱ kyo̱ŋwe̱ fe̱yɛ, “Mo̱nꞌ nare̱ ya lɔŋŋɔ ke̱tɔ ke̱maa, na ane̱ bo̱ gyi Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ne̱ baa bise Yeesuu fe̱yɛ, “Mfe̱ne̱ ne̱ fo̱ e̱ kpa fe̱yɛ ane̱ ya lɔŋŋɔ sa fo̱‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ne̱ Yeesuu a be̱ŋŋaa fe̱yɛ, “Mo̱ne̱ ya yɔ mo̱ne̱ i lwee maŋ‑ɔ‑rɔ, mo̱ne̱ e̱ gyaŋŋaa ɔnyare̱ ko̱ na ɔ so̱ kalɔ na nkyu, na mo̱nꞌ gya mò̱ se̱ yɔ lɔŋ ne̱ o lwee mò̱‑rɔ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Na mo̱nꞌ tɔwe̱ gywii lɔŋ wuye‑o fe̱yɛ, ‘Ɔkaapo̱po̱‑ɔ yɛ, Ŋke̱e̱ ke̱kyaŋ ne̱ mo̱ aa mo̱ agyase̱po̱‑ɔ i gyi Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese‑o ke̱mo̱‑rɔ‑ɔ?’ ");
INSERT INTO ncuNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Mfe̱ŋ‑ɔ na ɔ kaapo̱ mo̱ne̱ abaŋso̱ro̱o̱ ke̱kyaŋ dabe̱ ko̱ ne̱ ke̱ bo̱ so̱so̱‑ɔ‑rɔ, na baa kyɔ lɔŋŋɔ ke̱mo̱‑rɔ waa ngya na iteeburi bo̱ ye̱ra‑rɔ. Na mo̱nꞌ waa ke̱tɔ ke̱maa siraa bo̱ ye̱ra ane̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bamo̱ a yɔ maŋ‑ɔ‑rɔ‑ɔ, ane̱ŋ ne̱ Yeesuu a tɔwe̱‑ɔ dɛɛ ne̱ baa ŋu, ne̱ baa waa Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese‑o siraa mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ateese‑o kigyibe̱e̱ a fo̱‑ɔ, ne̱ Yeesuu mò̱ aa mò̱ ayaa‑rɔ aye̱re̱po̱‑ɔ a kye̱na kye̱na na bo̱ gyi ateese. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “A waa mo̱ kɔne̱ bwe̱e̱tɔ fe̱yɛ mo̱ aa mo̱ne̱ a gyi Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese mɔ pwɛɛ na n dɛɛ gyi awo̱re̱fɔɔ na ŋ wu. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","A le̱e̱ fe̱yɛ mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ, ma lɛɛ gyi ateese mɔ daa, amɔ bo̱ fo̱ saŋ ne̱ Wuribware̱ e̱ ba na ɔ bo̱ gyi mò̱ kuwure, ne̱ ke̱tɔ ke̱maa ne̱ ateese mɔ ye̱re̱ bo̱ sa‑ɔ a waa‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ne̱ Yeesuu a taa nta ko̱to̱re̱nkyu bo̱rɔ, ne̱ ɔɔ sa Wuribware̱ aŋsɛ we̱e̱ se̱, ne̱ ɔ yɛ, “Mo̱ne̱ pɛɛɛ mo̱nꞌ kɔɔre̱ nuu. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ le̱e̱ mbe̱yɔmɔ bo̱ yɔ, ma lɛɛ nuu nta mɔ, amɔ saŋ ne̱ Wuribware̱ i gyi kuwure‑o a fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ne̱ ɔɔ taa bodobodoo, ne̱ ɔɔ sa Wuribware̱ aŋsɛ we̱e̱ se̱, ne̱ ɔɔ te̱ŋŋe̱‑rɔ sa bamo̱, ne̱ ɔ yɛ, “Mo̱ ko̱yo̱wɔre̱gyi ne̱ mo̱ e̱ ba a m bo̱ sa mo̱ne̱‑ɔ ne̱e̱. Mo̱nꞌ gyi bo̱ nyiŋŋi mo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ane̱ŋ dɛɛ, ne̱ bamo̱ a gyi lo̱we̱‑ɔ, ne̱ ɔɔ taa nta na ko̱to̱re̱nkyu bo̱rɔ sa bamo̱, ne̱ ɔ yɛ, “Mo̱ mbo̱gya ne̱ n tii Wuribware̱ na ase̱sɛ mbo̱ŋtɔ‑rɔ a e̱taŋ po̱pwɛɛ a kanɔ‑ɔ ne̱e̱. N twiiri a ŋ we̱e̱ sa mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Amaa mo̱nꞌ nu fe̱yɛ ɔko̱ ne̱ o gyi mo̱ kidiburo‑o te mo̱ ase̱ gyikpa mfe̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mo̱, dimaadi mò̱ gyi‑o, i wu fe̱yɛ ane̱ŋ ne̱ Wuribware̱ a tɔwe̱ bo̱ ye̱ra‑ɔ, amaa ɔko̱ ne̱ o gyi mo̱ kidiburo‑o i ŋu ase̱ŋ ne̱e̱ fɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ne̱ baa le̱e̱ ba bise abɛɛ ba kpa bamo̱‑rɔ ɔko̱ ne̱ ɔ ba a ɔ bo̱ gyi mò̱ kidiburo amo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ne̱ ikii a lwee Yeesuu agyase̱po̱‑ɔ‑rɔ ba kpa mò̱ ne̱ ɔ gye̱ bamo̱‑rɔ ɔbre̱sɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Nde̱ se̱ awuye awure de bamo̱ e̱le̱ŋ, ne̱ ba kpa fe̱yɛ ɔke̱maa te̱e̱ bamo̱ ke̱nyare̱ dabe̱ fe̱yɛ ‘ase̱sɛ bamo̱ nyare̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Amaa mo̱ne̱ lee kwe̱e̱. Ɔko̱ ne̱ ɔ gye̱ mo̱ne̱‑rɔ ɔbre̱sɛ‑ɔ kii mo̱ne̱ kayaagyi, na mo̱ne̱‑rɔ ɔgye̱ŋkpɛɛpo̱‑ɔ mɔ kii mo̱ne̱ ke̱nya. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ɔko̱ ne̱ o te na ɔko̱ waa ateese baa mò̱‑ɔ e̱ gye̱ bre̱sɛ, bɛɛɛ ɔko̱ ne̱ ɔ waa ateese‑o e̱ gye̱ bre̱sɛ? Ɔke̱maa nyi fe̱yɛ ɔko̱ ne̱ o te na bo̱ waa ateese baa na o gyi‑o e̱ gye̱ bre̱sɛ. Amaa m fe̱raa m bo̱ mo̱ne̱‑rɔ ne̱e̱ mo̱ i suŋ mo̱ e̱ sa mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Mo̱ aa mo̱ne̱ ya gyi awo̱re̱fɔɔ ne̱ mo̱ a gyi‑o pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ane̱ŋ se̱‑ɔ, fe̱yɛ ane̱ŋ ne̱ n se̱ a sa mo̱ kuwure‑o, ŋ gbaa mo̱ e̱ sa mo̱ne̱ ko̱ko̱ ane̱ŋ dɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mo̱ aa mo̱ne̱ e̱ kye̱na mo̱ kuwure‑o si, na ane̱ gyi a ane̱ nuu, na mo̱nꞌ gyi ane̱ Isireelii awuye a nsuro kudu ŋnyɔ‑ɔ kuwure.” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Mfe̱ŋ ne̱ Yeesuu a te̱e̱ fe̱yɛ, “Simɔŋ, Simɔŋ, Ɔbɔnsam a ko̱re̱ mo̱ kpa na ɔ kyɔ mo̱ne̱‑rɔ ke̱e̱ mo̱ne̱‑rɔ bamo̱ ne̱ ɔ taare̱ a ɔ nya na bo̱ kii mò̱ lee‑o, fe̱yɛ ane̱ŋ ne̱ bamo̱ ya kyaare̱ yaabraa, ne̱ baa lee agyi‑o, ba taa afeŋfeŋtee‑o bo̱ twe̱e̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Simɔŋ, mo̱ e̱ tɔwe̱ a n gywii fo̱ fe̱yɛ fo̱ e̱ se̱re̱ a fo̱ yɔwe̱ mo̱. Amaa mo̱ a ko̱re̱ ke̱bware̱ko̱re̱ sa fo̱ fe̱yɛ saŋ amo̱, fo̱ ma yɔwe̱ mo̱ ko̱kɔɔre̱gyi. Na saŋ ne̱ fo̱ a kiŋŋi fo̱ e̱ ba‑ɔ, fo̱ waa fo̱ bɛɛko̱‑ana agyase̱po̱‑ɔ mfe̱e̱ wɔre̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ne̱ Peetroo a be̱ŋŋaa mò̱ fe̱yɛ, “Mo̱ nyaŋpe̱, mo̱ e̱ gya fo̱ se̱, ne̱ amo̱ e̱ gye̱ kitii na bo̱ tii mo̱ aa fo̱, ne̱ amo̱ e̱ gye̱ lowi na mo̱ aa fo̱ a wu.” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Mfe̱ŋ ne̱ Yeesuu yɛ, “Peetroo, mo̱ e̱ tɔwe̱ mo̱ i gywii fo̱ fe̱yɛ, ndɔɔ kanye mɔ fo̱ e̱ swe̱e̱ iluwi e̱sa fe̱yɛ fo̱ mo̱ŋ nyi mo̱ pwɛɛ na kyaŋare̱ dɛɛ fo̱re̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ne̱ Yeesuu a bise mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Saŋ ne̱ mo̱ a dɛɛ suŋ mo̱ne̱ fe̱yɛ mo̱nꞌ ya tɔwe̱ ase̱ŋ timaa‑o, ne̱ ŋ yɛ mo̱ne̱ e̱ yɔ mo̱ne̱ ma taa atanne̱ mbɔɔte̱e̱ na e̱ko̱re̱e̱ na ase̱be̱ta‑ɔ, mo̱ne̱ a yɔ‑ɔ, mo̱ne̱ a nu mo̱ne̱ e̱ye̱e̱ fe̱yɛ mo̱ne̱ a mo̱ŋ yaa ate̱tɔmo̱ŋta amo̱ aaa?” Ne̱ bo̱ yɛ, “Daabii.” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ne̱ Yeesuu yɛ, “Amaa mbe̱yɔmɔ fe̱raa ɔke̱maa ne̱ o de atanne̱ kabɔɔte̱e̱‑ɔ na ko̱re̱e̱‑ɔ, a tiri fe̱yɛ ɔ taa kra. Ne̱ ɔke̱maa ne̱ mò̱ e̱ mo̱ŋ de ke̱paŋ, a tiri fe̱yɛ o fe mò̱ kaare̱ bo̱ sɔɔ ko̱ko̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Bo̱ le̱e̱ fe̱yɛ mo̱nꞌ nu le̱e̱ mo̱ ase̱ fe̱yɛ ane̱ŋ dɛɛ ne̱ baa kyo̱rɛɛ mo̱ ase̱ŋ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ, ‘Baa waa mò̱ ke̱tɔ ne̱ ba waa abɔye̱waapo̱‑ɔ’, a tiri fe̱yɛ a ba kase̱ŋtiŋ. A le̱e̱ fe̱yɛ ane̱ŋ ne̱ baa kyo̱rɛɛ mo̱ kuŋu si ase̱ŋ‑ɔ, saŋ e̱ kpa a ɔ fo̱ fe̱yɛ a waa kase̱ŋtiŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ne̱ mò̱ agyase̱po̱‑ɔ a be̱ŋŋaa mò̱ fe̱yɛ, “Ane̱ nyaŋpe̱, ke̱e̱, apaŋ anyɔ bo̱ mfe̱e̱.” Ne̱ Yeesuu yɛ, “Daabii, aa baare.” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Fe̱yɛ ane̱ŋ ne̱ ɔ kyɔ ɔ waa saŋ ke̱maa‑ɔ, ne̱ ɔɔ yɔ Mfɔ-Ayii ke̱be̱e̱‑ɔ se̱, ne̱ mò̱ agyase̱po̱‑ɔ a gya mò̱ se̱ yɔ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bamo̱ a fo̱ mfe̱ŋ‑ɔ, ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱nꞌ ko̱re̱ Wuribware̱ fe̱yɛ Ɔbɔnsam ma kaŋ kyɔ mo̱ne̱‑rɔ ke̱e̱ fe̱yɛ mo̱ne̱ i kiŋŋi kamɛɛ aaa.” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ne̱ ɔɔ kyo̱ŋ yɔ akatɔ se̱ kafwe̱e̱ ya kpuni aŋurii ko̱re̱ ke̱bware̱ko̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ɔ yɛ, “N se̱, mbe̱yɔmɔ fe̱raa mo̱ e̱ ko̱re̱ fo̱ ne̱e̱ fe̱yɛ, fo̱ e̱ kpa, fo̱ sa a mo̱ awo̱re̱fɔɔ ne̱ mo̱ i gyi mɔ‑ɔ gye̱ kɛɛ, na m ma wu. Amaa kanɔ ŋke̱maa ne̱ fo̱ e̱ kpa‑ɔ bware sa mo̱.”  ");
INSERT INTO ncuNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ne̱ Wuribware̱ kabɔɔ ko̱ a le̱e̱ mò̱ se̱ bo̱ sa ne̱ mò̱ e̱ye̱e̱ a se̱ŋ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ne̱ aa tɔɔraa mò̱ gbaa, ne̱ ŋkee oo pee akatɔ ko̱re̱ ke̱bware̱ko̱re̱, na ɔ swaare̱ mbo̱gya, ne̱ n le̱e̱ mò̱ kayo̱wɔre̱ se̱ n dwe̱e̱ swe̱e̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ne̱ ɔɔ ko̱so̱ le̱e̱ ke̱bware̱ko̱re̱kpa‑ɔ mfe̱ŋ ya to̱ mò̱ agyase̱po̱‑ɔ da bo̱ di idi, a le̱e̱ fe̱yɛ bamo̱ gbaa aa tɔɔraa bamo̱, ne̱ tɔɔraa amo̱ a sa ne̱ baa kpo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ne̱ oo bise bamo̱ fe̱yɛ, “Nte̱tɔ se̱ ne̱ mo̱ne̱ da mo̱ne̱ di idi‑o ne̱e̱? Mo̱nꞌ ko̱so̱ ko̱re̱ ke̱bware̱ko̱re̱ fe̱yɛ Ɔbɔnsam ma kaŋ kyɔ mo̱ne̱‑rɔ ke̱e̱ fe̱yɛ mo̱ne̱ i kiŋŋi kamɛɛ aaa.” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Na Yeesuu saŋ ɔ sa se̱ŋsa, ne̱ Yudas ne̱ ɔ gye̱ Yeesuu agyase̱po̱ kudu anyɔ‑ɔ ɔko̱‑ɔ a gye̱ ase̱sɛ kukwii ko̱ ŋkpɛɛ ba. Ne̱ ɔɔ bo̱ kyo̱kywe̱e̱ Yeesuu ke̱daabɔŋ se̱ bo̱ ka mò̱ kanɔ, fe̱yɛ ane̱ŋ ne̱ Yudaa awuye e̱ ka abɛɛ kanɔ saŋ ke̱maa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ne̱ Yeesuu yɛ, “Yudas, amɔ fo̱ de ke̱daabɔŋ se̱ ko̱kyo̱kywe̱e̱ ne̱e̱ fo̱ de mo̱, dimaadi mò̱ gyi‑o, fo̱ e̱ sa mo̱ ado̱ŋ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Amo̱ fe̱raa Yeesuu agyase̱po̱‑ɔ a ŋu ke̱tɔ ne̱ ke̱ e̱ ba‑ɔ, ne̱ bo̱ yɛ, “Ane̱ nyaŋpe̱, ane̱ ba ane̱ apaŋ‑ɔ bo̱ kɔ bamo̱ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ne̱ bamo̱ ɔko̱ a baa ke̱paŋ bo̱ ŋe Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ‑ɔ anya‑ɔ ɔko̱ kigyisese̱bɔ te̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ne̱ Yeesuu yɛ, “Yɔwe̱, amo̱‑ɔ a baare.” Ne̱ Yeesuu a dabo̱rɔ ɔnyare̱ amo̱ a ke̱se̱bɔ‑ɔ, ne̱ ɔɔ kya ke̱mo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ne̱ Yeesuu a bise Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ na Wuribware̱ suŋkpa a ade̱e̱re̱se̱po̱ abre̱sɛ na maŋ abre̱sɛ ne̱ baa ba a bo̱ bo̱ kra mò̱‑ɔ pɛɛɛ fe̱yɛ, “Amɔ mo̱ne̱ a baa apaŋ na akyokuŋ ne̱e̱ na mo̱nꞌ bo̱ kra mo̱ fe̱yɛ oyu‑o ooo? ");
INSERT INTO ncuNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ŋke mfe̱ne̱ mɔ‑rɔ mo̱ aa mo̱ne̱ ne̱e̱ na mo̱ e̱ kaapo̱ abware̱se̱ŋ Wuribware̱ suŋkpa‑ɔ kabuno, na mo̱ne̱ mɔ mo̱ne̱ mo̱ŋ kra mo̱. Amaa mbe̱yɔmɔ ne̱ Wuribware̱ a sa Ɔbɔnsam kpa fe̱yɛ ɔ sa a mo̱nꞌ waa ane̱ŋ‑ɔ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Mfe̱ŋ ne̱ baa kra Yeesuu taa mò̱ yaa Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ a lɔŋ‑ɔ‑rɔ. Bamo̱ a yɔ‑ɔ, ne̱ Peetroo a sii kamɛɛ ɔ gya bamo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Baa kure de̱e̱kpa ko̱ mɔ lɔŋ‑ɔ kabuno nse̱na, ne̱ Peetroo a sii gyɔŋŋɔ bamo̱ ne̱ bo̱ te ba wo̱re̱ de̱e̱kpa amo̱‑ɔ ase̱‑ɔ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Amɔ kabre ko̱ a ŋu Peetroo na o te de̱e̱kpa amo̱ ase̱‑ɔ, ne̱ ɔɔ de̱e̱re̱ mò̱ akatɔ‑rɔ, ne̱ ɔ yɛ, “Ɔnyare̱ mɔ gbaa na Yeesuu e̱ gye̱ ne̱ bo̱ naa.” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ne̱ Peetroo a swe̱e̱ fe̱yɛ, “Ɔkye̱e̱, mo̱ŋ nyi mò̱ gbaa.” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Bo̱ waa kafwe̱e̱‑ɔ, ne̱ ɔnyare̱ ko̱ a be̱e̱ ŋu Peetroo, ne̱ ɔ yɛ, “Ne̱e̱ fo̱ gbaa fo̱ gye̱ Yeesuu a ase̱sɛ‑ɔ ɔko̱ ɛ?” Ne̱ Peetroo be̱e̱ ɔ yɛ, “Ɔnyare̱, mo̱ŋ tii bamo̱ se̱ ooo.” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Be̱e̱ bo̱ fo̱ dɔŋhwe̱re̱e̱ ko̱ŋko̱‑ɔ, ne̱ ɔnyare̱ ko̱ mɔ a be̱e̱ ba bo̱ pee akatɔ tɔwe̱ fe̱yɛ, “Amo̱‑ɔ fe̱raa mo̱ŋ de ikii, ɔnyare̱ mɔ na Yeesuu e̱ gye̱ ne̱ bo̱ naa, a le̱e̱ fe̱yɛ mò̱ se̱ŋsa gbaa a le̱e̱ Galile̱yanyi lee‑o ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ne̱ Peetroo a be̱e̱ be̱ŋŋaa fe̱yɛ, “Ɔnyare̱, mo̱ŋ nyi ke̱tɔ ne̱ fo̱ e̱ tɔwe̱ ke̱mo̱ ase̱ŋ‑ɔ.” Puri amo̱‑rɔ mfe̱ŋ na ɔ saŋ ɔ sa se̱ŋsa, ne̱ kyaŋare̱ a fo̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mfe̱ŋ ne̱ Yeesuu a buruwaa de̱e̱re̱ Peetroo akatɔ‑rɔ, ne̱ Peetroo a nyiŋŋi si fe̱yɛ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Ndɔɔ kanye mɔ, fo̱ e̱ swe̱e̱ iluwi e̱sa fe̱yɛ fo̱ mo̱ŋ nyi mo̱, pwɛɛ na kyaŋare̱ dɛɛ fo̱re̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Amo̱ fe̱raa ne̱ Peetroo a le̱e̱ yɔ kawu ya su bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ne̱ bamo̱ ne̱ ba de̱e̱re̱ Yeesuu si‑o a saare̱ mò̱, ne̱ baa daye̱ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ne̱ baa ba kaprakɛɛ bo̱ ŋure mò̱ akatɔ se̱. Amɔ ɔko̱ ya da mò̱ na bo̱ tɔwe̱ gywii mò̱ fe̱yɛ, “Fo̱ i nyi fe̱yɛ fo̱ gye̱ Wuribware̱ a akyaamɛɛ‑ɔ ɔko̱, tɔwe̱ mò̱ ne̱ ɔɔ da fo̱‑ɔ gywii ane̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ne̱ baa tɔwe̱ ase̱ŋ bwe̱e̱tɔ bo̱ saare̱ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kaye̱ ŋke‑o, ne̱ maŋ abre̱sɛ‑ɔ na Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na Wuribware̱ mbraa akaapo̱po̱‑ɔ a bo̱ gyaŋŋe̱, ne̱ baa baa Yeesuu bamo̱ akatɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ne̱ bo̱ yɛ, “Tɔwe̱ a ane̱ nu, fo̱ e̱ gye̱ Kristoo ne̱ Wuribware̱ a suŋ bo̱ kyo̱ŋwe̱ kaye̱ mɔ‑rɔ‑ɔ ɔɔɔ?” Ne̱ ɔɔ be̱ŋŋaa bamo̱ fe̱yɛ, “Mo̱ ya tɔwe̱ gywii mo̱ne̱ gbaa, mo̱ne̱ maa kɔɔre̱ a mo̱nꞌ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ane̱ŋ dɛɛ ne̱ mo̱ ya bise mo̱ne̱ ase̱ŋ, ne̱ mo̱ne̱ maa lee kanɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Amaa mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ le̱e̱ mbe̱yɔmɔ bo̱ yɔ, mo̱, dimaadi mò̱ gyi‑o, e̱ kye̱na Wuribware̱ owure dabe̱‑ɔ kigyise si, na mo̱ aa mò̱ a gyi mò̱ kuwure‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ne̱ bamo̱ pɛɛɛ yɛ, “Amo̱ fe̱raa, amɔ fo̱ gye̱ Wuribware̱ mò̱ gyi‑o ne̱e̱ e̱e̱e̱?” Ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “Ane̱ŋ ne̱ mo̱ne̱ a tɔwe̱‑ɔ gye̱ kase̱ŋtiŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ne̱ bo̱ yɛ, “Ane̱ maa lɛɛ kpa ɔko̱ a ɔ bo̱ tɔwe̱ ko̱tɔko̱ pwɛɛ na ane̱ dɛɛ ŋu fe̱yɛ oo gyi ke̱pɔ. Ane̱ fɔŋfɔŋ gbaa a nu mò̱ a tɔwe̱ fe̱yɛ mò̱ aa Wuribware̱ ta.” ");
INSERT INTO ncuNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ne̱ ase̱sɛ‑ɔ pɛɛɛ mɔ a ko̱so̱, ne̱ baa taa Yeesuu yaa Romanyi gominaa ne̱ ba te̱e̱ mò̱ ɛ Pilat‑o akatɔ‑rɔ, na ɔ sa bamo̱ kpa fe̱yɛ bo̱ mɔɔ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ne̱ baa le̱e̱ ba po̱rɔ mò̱ mfe̱ŋ fe̱yɛ, “Ane̱ a kra ɔnyare̱ mɔ na ɔ naa ɔ pe̱nna ase̱sɛ fe̱yɛ bo̱ ma ka leŋpoo sa Kaye̱saa, mo̱ne̱ Roma awuye owure dabe̱‑ɔ. Na mò̱ gbaa gye̱ owure ne̱e̱. Ne̱ ɔ be̱e̱ ɔ yɛ mò̱ e̱ gye̱ Kristoo ne̱ Wuribware̱ a tɔwe̱ bo̱ be̱ya fe̱yɛ o suŋ a ɔ bo̱ kyo̱ŋwe̱ kaye̱ mɔ‑rɔ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ne̱ Pilat a bise Yeesuu fe̱yɛ, “Baa po̱rɔ fo̱ fe̱yɛ fo̱ a tɔwe̱ fe̱yɛ fo̱ e̱ gye̱ Yudaa awuye owure‑o. E̱me̱ne̱ ne̱ fo̱ i lee kanɔ?” Ne̱ Yeesuu mɔ yɛ, “Se̱ŋbise mɔ a le̱e̱ fo̱ ase̱ ne̱e̱ e̱e̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ne̱ gominaa‑o a tɔwe̱ gywii Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na ase̱sɛ biribiri ne̱ baa ba iwurekpa bo̱ ye̱re̱ mfe̱ŋ‑ɔ fe̱yɛ, “M fe̱raa mo̱ŋ ŋu ɔnyare̱ mɔ ke̱bɔye̱ ne̱ ki i bu mò̱ ke̱pɔ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Amaa ŋkee gbaa ne̱ ase̱sɛ‑ɔ a pee akatɔ ba po̱rɔ mò̱. Bo̱ yɛ “Mò̱ ase̱ŋ ne̱ ɔ kaapo̱‑ɔ e̱ kpa a a baa ase̱ŋ Yude̱ya swe̱e̱re̱ se̱. Galile̱ya swe̱e̱re̱ se̱ ne̱ ɔɔ le̱e̱ ɔ kaapo̱ amo̱, ne̱ mbe̱yɔmɔ ɔɔ taa baa bo̱ fo̱ mfe̱e̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Saŋ ne̱ gominaa‑o a nu amo̱‑ɔ, ne̱ oo bise fe̱yɛ, “Ɔnyare̱ amo̱ gye̱ Galile̱yanyi ne̱e̱ e̱e̱e̱?” Ne̱ baa be̱ŋŋaa fe̱yɛ, “Ɔ gye̱.” Amɔ Galile̱ya swe̱e̱re̱ se̱ owure gye̱ Hɛrɔd ne̱ ɔ bo̱ Yɛro̱salɛm maŋ‑nɔ saŋ amo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Gominaa‑o a nu amo̱‑ɔ, ne̱ ɔɔ sa ne̱ baa yaa Yeesuu Hɛrɔd ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Owure Hɛrɔd a ŋu Yeesuu‑o, ne̱ aa waa mò̱ kɔne̱ bwe̱e̱tɔ, bo̱ le̱e̱ fe̱yɛ oo nu mò̱ ase̱ŋ, ne̱ ɔ kyɔ ɔ kpa mò̱ kuŋu ke̱de̱daa. Ɔ kpa a o ŋu akpe̱ŋe̱ye̱e̱tɔ ne̱ ɔ waa‑ɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ane̱ŋ se̱‑ɔ, ne̱ Hɛrɔd a bise Yeesuu ase̱ŋ bwe̱e̱tɔ. Amaa Yeesuu mo̱ŋ be̱ŋŋaa mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ne̱ Wuribware̱ alɔŋŋɔpo̱‑ɔ na Wuribware̱ mbraa akaapo̱po̱‑ɔ a le̱e̱ yɔ akatɔ‑rɔ ya po̱rɔ Yeesuu bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ŋkee Owure Hɛrɔd na mò̱ asoogyaa awuye a saare̱ Yeesuu, ne̱ baa waa mò̱ kanɔ ŋke̱maa mɔ ne̱ ba kpa‑ɔ, ne̱ baa ba waagya dame̱naŋsɛ ko̱ bo̱ buŋ mò̱, ne̱ baa kiŋŋaa mò̱ yaa Gominaa Pilat ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Gominaa Pilat a sa ne̱ baa yaa Yeesuu Owure Hɛrɔd ase̱‑ɔ, le̱e̱ ŋke nsi amo̱ ne̱ owure‑o a taa gominaa‑o ke̱nyare̱. Pwɛɛ ne̱ saŋ mɔ a dɛɛ fo̱‑ɔ, bo̱ gye̱ ado̱ŋ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ne̱ Gominaa Pilat a te̱e̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na maŋ agye̱ŋkpɛɛpo̱‑ɔ na ase̱sɛ‑ɔ pɛɛɛ bo̱ gyaŋŋe̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ne̱ a baa ɔnyare̱ mɔ mo̱ ase̱ ne̱e̱ fe̱yɛ ɔ naa ɔ pe̱nna ase̱sɛ ne̱e̱. Mbe̱yɔmɔ, mo̱ a bise mò̱ de̱e̱re̱ ase̱ŋ‑ɔ‑rɔ mo̱ne̱ akatɔ‑rɔ mfe̱e̱, ne̱ mo̱ a ŋu fe̱yɛ ɔ mo̱ŋ gyi ase̱ŋ pɛɛɛ ne̱ mo̱ne̱ e̱ po̱rɔ mò̱ amo̱ se̱‑ɔ ke̱pɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ane̱ŋ dɛɛ ne̱ Owure Hɛrɔd gbaa mo̱ŋ ŋu ke̱pɔ ne̱ oo gyi‑o, bo̱ le̱e̱ fe̱yɛ oo kiŋŋaa mò̱ bo̱ kyo̱ŋwe̱ ane̱. Ɔnyare̱ mɔ mo̱ŋ waa sɛye̱ ne̱ ane̱ i kperi amo̱ se̱ a ane̱ mɔɔ mò̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Amo̱se̱‑ɔ mo̱ e̱ sa ne̱e̱ a bo̱ da mò̱ paara, na bo̱ yɔwe̱ mò̱ a ɔ nare̱ ya kyure.”  ");
INSERT INTO ncuNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ɔɔ tɔwe̱ ane̱ŋ, a le̱e̱ fe̱yɛ saŋ ke̱maa mɔ Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese kigyibe̱e̱‑ɔ, Romanyi gominaa i lee bamo̱ ne̱ oo tii bamo̱ tiikpa‑ɔ ɔko̱ a ɔ sa bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ne̱ ase̱sɛ pɛɛɛ a faa‑rɔ keŋkeŋ fe̱yɛ, “Mɔɔ mò̱! Na fo̱ lee Bar‑Abas le̱e̱ tiikpa‑ɔ sa ane̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Bar‑Abas e̱ gye̱ ɔnyare̱ ko̱ ne̱ ɔɔ sa ne̱ ase̱sɛ a ko̱so̱ kɔ bo̱ kye Roma abane̱ maŋ mɔ‑rɔ, ne̱ ɔɔ mɔɔ ase̱sɛ, ne̱ baa kra mò̱ tii‑o ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Amɔ gominaa‑o saŋ ɔ kpa fe̱yɛ ɔ yɔwe̱ Yeesuu bo̱ kyo̱ŋwe̱. Ane̱ŋ se̱‑ɔ ne̱ ɔɔ be̱e̱ bise ase̱sɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ne̱ ase̱sɛ‑ɔ a be̱e̱ faa‑rɔ keŋkeŋ fe̱yɛ, “Da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱! Da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱!” ");
INSERT INTO ncuNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ne̱ gominaa‑o a be̱e̱ tɔwe̱ gywii bamo̱ sase̱po̱ fe̱yɛ, “Nte̱tɔ bɔye̱ gbaa ne̱ ɔɔ waa? M fe̱raa mo̱ŋ ke̱e̱ ke̱tɔ ne̱ ɔɔ waa ne̱ o kperi ke̱mo̱ se̱ a o wu‑o. Mo̱ e̱ sa a bo̱ da mò̱ paara ne̱e̱ a bo̱ yɔwe̱ mò̱ a ɔ nare̱ ya kyure.” ");
INSERT INTO ncuNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","24","Ne̱ ase̱sɛ‑ɔ a fɛɛ‑rɔ ane̱ŋ‑aaa, ne̱ ŋkee gominaa‑o a bo̱ kpo̱ne̱ sure si fe̱yɛ ɔ waa ke̱tɔ ne̱ bo̱ yɛ ɔ waa‑ɔ. Ane̱ŋ se̱‑ɔ ne̱ oo bu Yeesuu ke̱pɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ne̱ gominaa‑o a lee Bar‑Abas ne̱ ɔɔ baa ase̱ŋ maŋ‑nɔ, ne̱ ɔɔ mɔɔ ase̱sɛ‑ɔ le̱e̱ tiikpa bo̱ kyo̱ŋwe̱, ne̱ ɔɔ taa Yeesuu sa mò̱ asoogyaa awuye fe̱yɛ bo̱ ya waa mò̱ ane̱ŋ ne̱ ase̱sɛ‑ɔ e̱ kpa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Saŋ ne̱ asoogyaa awuye‑o de Yeesuu ba yɔ‑ɔ, ne̱ baa gyaŋŋaa ɔnyare̱ ko̱ ne̱ ɔɔ le̱e̱ Kireenee maŋ‑nɔ‑ɔ ne̱ ba te̱e̱ mò̱ ɛ Simɔŋ na ɔ kyo̱ŋ o lwee maŋ‑ɔ‑rɔ. Ne̱ baa ye̱re̱ mò̱ taa kiyii kpare̱-abɛɛ‑rɔ‑ɔ bo̱ so̱rɔ mò̱, na ɔ gya Yeesuu si. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Na ase̱sɛ de̱maŋte̱‑ɔ gya mò̱ se̱. Akye̱e̱ ko̱ gbaa bo̱ bamo̱‑rɔ bo̱ gya se̱, na ba su ba sa Yeesuu. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ne̱ Yeesuu a buruwaa tɔwe̱ gywii bamo̱ fe̱yɛ, “Yɛro̱salɛm akye̱e̱, mo̱ne̱ ma kperi mo̱ se̱ su. Mo̱nꞌ su sa mo̱ne̱ e̱ye̱e̱ na mo̱ne̱ gyi‑ana. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Bo̱ le̱e̱ fe̱yɛ saŋ ko̱ e̱ ba na ase̱sɛ tɔwe̱ fe̱yɛ, ‘Akye̱e̱ ne̱ bo̱ mo̱ŋ ko̱we̱‑ɔ na bamo̱ ne̱ bo̱ mo̱ŋ de ŋyaagyi po̱pwɛɛ ne̱ ba nyapo̱ bamo̱‑ɔ aŋu bo̱ daŋ.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Saŋ amo̱ ne̱ ase̱sɛ e̱ tɔwe̱ a bo̱ gywii abe̱e̱ fe̱yɛ, ‘Mo̱nꞌ le̱e̱ da ane̱ se̱’ na bo̱ ko̱re̱ abe̱e̱gyi fe̱yɛ, ‘Mo̱nꞌ taa ane̱ bo̱ kwe̱e̱rɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kayii bo̱bwɛɛ ne̱ baa kywɛɛ‑ɔ, saŋbo̱to̱ kamo̱ ne̱ kaa wo̱re̱‑ɔ. Bamo̱ a waa mo̱ amo̱‑ɔ mbe̱yɔmɔ‑ɔ, ne̱ e̱me̱ne̱ ne̱ ba ba a bo̱ bo̱ waa mo̱ne̱ kamɛɛ‑rɔ?” ");
INSERT INTO ncuNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Amɔ anyare̱ anyɔ ko̱ ne̱ bo̱ gye̱ abɔye̱waapo̱‑ɔ mɔ tii si, ne̱ ba yaa bamo̱ aa Yeesuu a bo̱ mɔɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Saŋ ne̱ baa fo̱ mfe̱ŋ ne̱ ba te̱e̱ ɛ “Ko̱lɔŋko̱rɔŋgyi swe̱e̱re̱”‑ɔ, ne̱ baa da Yeesuu bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ‑ɔ se̱ mfe̱ŋ. Ne̱ baa da abɔye̱waapo̱ anyɔ‑ɔ mɔ ɔko̱ bo̱ me̱ra ko̱ko̱ se̱ mò̱ kigyise si, ne̱ baa da ɔko̱‑ɔ mɔ ko̱ko̱ se̱ Yeesuu ke̱be̱na se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ne̱ Yeesuu a tɔwe̱ ɛ, “N se̱, taa asoogyaa awuye mɔ e̱bɔye̱ bo̱ ke bamo̱, a le̱e̱ fe̱yɛ bo̱ mo̱ŋ nyi ke̱tɔ ne̱ ba waa‑ɔ.” Ne̱ asoogyaa awuye‑o a waa mpini mpini bo̱ ke Yeesuu atɔ buŋsɛ‑rɔ taa. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ne̱ ŋkee ase̱sɛ‑ɔ ye̱re̱ ba de̱e̱re̱, na Yudaa awuye agye̱ŋkpɛɛpo̱‑ɔ e̱ mɔse̱ mò̱ ba tɔwe̱ ba kyo̱ŋwe̱ Yeesuu fe̱yɛ, “Ɔɔ mo̱rɔwe̱ bo̱ko̱, amaa mo̱nꞌ sa a ane̱ ke̱e̱ fe̱yɛ mò̱ a tɔwe̱ ɛ mò̱ e̱ gye̱ Kristoo ne̱ Wuribware̱ a suŋ bo̱ kyo̱ŋwe̱ kaye̱ mɔ‑rɔ‑ɔ, ɔ taare̱ a ɔ mo̱rɔwe̱ mò̱ e̱ye̱e̱ aaa.” ");
INSERT INTO ncuNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ne̱ asoogyaa awuye‑o gbaa a saare̱ mò̱, ne̱ baa yɔ Yeesuu ase̱ ya sa mò̱ nta. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ne̱ bo̱ yɛ, “Fo̱ e̱ gye̱ Yudaa awuye owure kase̱ŋtiŋ, amo̱ fe̱raa mo̱rɔwe̱ fo̱ e̱ye̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ne̱ baa taa kawo̱re̱taa ko̱ ne̱ gominaa‑o a kyo̱rɛɛ se̱ fe̱yɛ, “Ke̱e̱ Yudaa awuye owure‑o” bo̱ me̱ra Yeesuu aŋu si. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ne̱ abɔye̱waapo̱ ne̱ baa da bamo̱ aa Yeesuu bo̱ me̱ra ayii kpare̱-abɛɛ‑rɔ se̱ kake ko̱ŋko̱‑ɔ ɔko̱ a tu asaagyi we̱e̱ Yeesuu si fe̱yɛ, “N gye̱ fo̱ e̱ gye̱ Kristoo‑o ooo? Mo̱rɔwe̱ fo̱ e̱ye̱e̱, na fo̱ mo̱rɔwe̱ ane̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ne̱ abɔye̱waapo̱ amo̱ ɔnyɔse̱po̱‑ɔ a faa mò̱ ko̱so̱bɛɛ‑ɔ se̱ fe̱yɛ, “Fo̱ mo̱ŋ se̱re̱ Wuribware̱ ne̱e̱ e̱e̱e̱? Ke̱pɔ ko̱ŋko̱ ne̱ baa bu ane̱ aa mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ane̱ fe̱raa gbaa, baa bu ane̱ ke̱pɔ kpa se̱, bo̱ le̱e̱ fe̱yɛ bɔye̱ ne̱ ane̱ a waa‑ɔ ko̱kɔ ne̱ baa ka ane̱‑ɔ, amaa mò̱ fe̱raa, ɔ mo̱ŋ waa bɔye̱ ko̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ne̱ mò̱ fe̱raa a tɔwe̱ gywii Yeesuu fe̱yɛ, “Yeesuu, saŋ ne̱ fo̱ e̱ ba a fo̱ bo̱ gyi kuwure‑o, fo̱ ma kaŋ taŋ mo̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Mo̱ i gyi fo̱ kase̱ŋtiŋ fe̱yɛ ndɔɔ mo̱ aa fo̱ e̱ yɔ Wuribware̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Aa bo̱ fo̱ mpase̱‑ɔ, ne̱ kyɔwe̱ a yɔwe̱ ke̱da, ne̱ kibugyii a da swe̱e̱re̱ amo̱ se̱ pɛɛɛ. Ne̱ kaa gyi e̱dɔŋhwe̱re̱e̱ e̱sa. Ne̱ ŋkee waagya ne̱ baa bo̱ kuŋ Wuribware̱ suŋkpa a do̱dɔ‑rɔ a ke̱kyaŋ‑nɔ‑ɔ a kyaŋ‑nɔ ntuŋ ŋnyɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ne̱ Yeesuu a faa‑rɔ keŋkeŋ fe̱yɛ, “N se̱ eee, mo̱ a taa mo̱ kra bo̱ waa fo̱ ke̱sare̱e̱‑rɔ.” Mò̱ a tɔwe̱ amo̱‑ɔ lo̱we̱‑ɔ, ne̱ oo kii E̱bware̱ lee. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Amɔ asoogyaa ɔbre̱sɛ‑ɔ a ŋu atɔ ne̱ aa waa mfe̱ŋ‑ɔ, ne̱ ɔɔ kyo̱rɔ Wuribware̱, ne̱ ɔ yɛ, “Kase̱ŋtiŋ, weetee ɔ gye̱ se̱sɛ timaa.” ");
INSERT INTO ncuNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Amo̱ fe̱raa ase̱sɛ ne̱ baa gyaŋŋe̱ mfe̱ŋ ba de̱e̱re̱ atɔ‑ɔ a ŋu ke̱tɔ ne̱ kaa waa‑ɔ, ne̱ baa kiŋŋi yɔ pe̱, na bamo̱ asare̱e̱ gya bamo̱ aŋu ba su. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ne̱ bamo̱ ne̱ bo̱ nyi Yeesuu nɛɛnɛɛ‑ɔ na akye̱e̱ ne̱ baa gya mò̱ se̱ le̱e̱ Galile̱ya swe̱e̱re̱ se̱‑ɔ ye̱re̱ ke̱fɔ ba de̱e̱re̱ ba kyo̱ŋwe̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Amɔ ɔnyare̱ ko̱ mɔ bo̱‑rɔ ne̱ ba te̱e̱ mò̱ ɛ Yo̱sɛf ne̱ ɔɔ le̱e̱ Arimate̱ya maŋ ne̱ ɔ bo̱ Yude̱ya swe̱e̱re̱ se̱‑ɔ. Ɔ gye̱ se̱sɛ timaa, ne̱ ase̱sɛ mɔ be̱e̱ ba bu mò̱ bwe̱e̱tɔ. Mò̱ fe̱raa gywii saŋ ne̱ Wuribware̱ i gyi kuwure swe̱e̱re̱ mɔ se̱‑ɔ ne̱e̱. O tii iwurekpa ase̱ŋgyipo̱‑ɔ se̱, amaa n gye̱ mò̱ aa bamo̱ kanɔ fe̱yɛ bo̱ bu Yeesuu ke̱pɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ane̱ŋ se̱‑ɔ ne̱ ɔnyare̱ mɔ a yɔ Gominaa Pilat ase̱ ya ko̱re̱ kpa fe̱yɛ mò̱ fe̱raa e̱ ya taa Yeesuu kifuniŋ a ɔ yaa pure. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Amɔ ke̱gye̱raŋta ko̱ mɔ ne̱ baa ŋeri ke̱fo̱re̱ lee bɔ fe̱yɛ ke̱kyaŋ‑ɔ maa mfe̱ŋ. Amaa bo̱ mo̱ŋ tɛɛ pure ɔko̱ ke̱mo̱‑rɔ. Ane̱ŋ se̱‑ɔ ne̱ Yo̱sɛf a ya maye̱ kifuniŋ‑o, ne̱ ɔɔ ba kyefuri bo̱ miri mò̱, ne̱ ɔɔ waa me̱naŋ taa mò̱ waa ke̱gye̱raŋta‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","A le̱e̱ fe̱yɛ kake amo̱ gye̱ Ifiyara ne̱e̱. Amo̱se̱‑ɔ kyɔwe̱ ya lo̱we̱, amɔ kukyure kake a lweero, ne̱ ɔko̱ mo̱ŋ de kpa fe̱yɛ o suŋ kusuŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ne̱ akye̱e̱ ne̱ baa gya Yeesuu si le̱e̱ Galile̱ya swe̱e̱re̱ se̱‑ɔ a gya Yo̱sɛf se̱ ya ŋu ke̱gye̱raŋta‑ɔ na ane̱ŋ ne̱ ɔɔ ba Yeesuu kifuniŋ‑o bo̱ be̱ya‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ne̱ baa kiŋŋi yɔ pe̱ ya kpa kadwii na kakyanne̱ na bo̱ ba bo̱ kyiine Yeesuu kifuniŋ‑o. Ne̱ baa kyure kukyure kake‑o fe̱yɛ ane̱ŋ ne̱ Wuribware̱ a mbraa‑ɔ e̱ kaapo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Me̱me̱ne̱da, kake ne̱ Yudaa awuye‑o i kyure, ne̱ bo̱ maa waa kusuŋ ke̱maa‑ɔ a kyo̱ŋ‑ɔ, Kosiyara gye̱gyaye̱ tututu, ne̱ akye̱e̱‑ɔ a yɔ Yeesuu ke̱gye̱raŋta‑ɔ ase̱, na bo̱ de kadwii na kakyanne̱‑ɔ bamo̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Amaa bamo̱ a fo̱ ke̱gye̱raŋta‑ɔ ase̱‑ɔ, baa ŋu fe̱yɛ ke̱fo̱re̱ dabe̱ ne̱ baa kuroŋ bo̱ kpuse ke̱mo̱ kanɔ‑ɔ se̱ fe̱yɛ po̱ne̱‑ɔ a kuroŋ le̱e̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Amo̱se̱‑ɔ ne̱ baa lweero. Amaa bo̱ mo̱ŋ ŋu ane̱ nyaŋpe̱ Yeesuu kifuniŋ‑o da‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ane̱ŋ se̱‑ɔ ne̱ e̱ye̱e̱ a kpe̱ŋ bamo̱. Puri amo̱‑rɔ mfe̱ŋ ne̱ baa ŋu anyare̱ anyɔ ko̱, na bo̱ buŋ e̱kaare̱ ne̱ e̱ to̱re̱ se̱ pare̱pare̱pare̱‑ɔ bo̱ ye̱re̱ bamo̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kufu a nya akye̱e̱ amo̱‑ɔ se̱, ne̱ baa buŋŋe anyare̱ anyɔ amo̱ akatɔ‑rɔ. Ne̱ anyare̱ anyɔ‑ɔ a bise bamo̱ fe̱yɛ, “Nte̱tɔ se̱ ne̱ mo̱ne̱ i buwi alowipo̱‑rɔ mo̱ne̱ e̱ kpa ɔko̱ ne̱ o te‑o? ");
INSERT INTO ncuNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yeesuu mo̱ŋ bo̱ mfe̱e̱, ɔɔ kyɔ kyiŋŋi le̱e̱ lowi‑ro, ɔɔ dare̱e̱. Mo̱nꞌ nyiŋŋi si fe̱yɛ ɔɔ tɔwe̱ gywii mo̱ne̱ saŋ ne̱ ɔ bo̱ Galile̱ya‑ɔ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘A tiri fe̱yɛ bo̱ taa mo̱, dimaadi mò̱ gyi‑o, bo̱ waa abɔye̱waapo̱ ke̱sare̱e̱‑rɔ, na bo̱ da mo̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱, na ke̱mo̱ kake sase̱po̱‑ɔ na n kyiŋŋi le̱e̱ lowi‑ro.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ne̱ akye̱e̱‑ɔ a nyiŋŋi ase̱ŋ‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ne̱ baa kiŋŋi le̱e̱ ke̱gye̱raŋta‑ɔ‑rɔ, ne̱ baa ya tɔwe̱ ke̱tɔ ne̱ baa ŋu‑o pɛɛɛ gywii mò̱ agyase̱po̱ kudu kako̱‑ɔ, na bamo̱ ne̱ bo̱ bo̱ bamo̱ ase̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Amɔ akye̱e̱ amo̱ anyare̱ e̱ gye̱ Mariya Magadalanyi na Yohana na Yakubu mò̱ nyi Mariya. Akye̱e̱ mɔ na bo̱ko̱ ne̱ bo̱ tii bamo̱ se̱‑ɔ ya yɔ ya tɔwe̱ ase̱ŋ‑ɔ pɛɛɛ gywii Yeesuu ayaa‑rɔ aye̱re̱po̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Amaa baa fa ne̱e̱ fe̱yɛ ke̱tɔ ne̱ akye̱e̱ amo̱ a tɔwe̱ gywii bamo̱‑ɔ mo̱ŋ de kaase̱. Amo̱se̱‑ɔ bo̱ mo̱ŋ kɔɔre̱ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ne̱ Peetroo fe̱raa a ko̱so̱ ŋwɛɛnaŋ yɔ Yeesuu a ke̱gye̱raŋta‑ɔ ase̱. Mò̱ a fo̱‑ɔ, ne̱ oo buŋŋe de̱e̱re̱‑rɔ ŋu kyefuri ne̱ baa bo̱ miri Yeesuu kifuniŋ‑o. Ɔ mo̱ŋ lɛɛ ŋu sɛye̱ bo̱ tii si. Ne̱ ke̱tɔ ne̱ kaa waa‑ɔ a kpe̱ŋ mò̱ e̱ye̱e̱, ne̱ oo kiŋŋi yɔ pe̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kake amo̱ dɛɛ, ne̱ Yeesuu agyase̱po̱ anyɔ ko̱ a ko̱so̱ le̱e̱ Yɛro̱salɛm maŋ‑nɔ bo̱ naa ba yɔ kamaŋgyii ko̱ ne̱ ba te̱e̱ ɛ Imayus‑o. Mfe̱ŋ na Yɛro̱salɛm e̱ waa fe̱yɛ e̱maye̱re̱ isunoo. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bo̱ naa ba yɔ na ba tɔwe̱ ke̱tɔ ne̱ kaa waa Yeesuu Yɛro̱salɛm‑ɔ ase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bamo̱ a naa na ba tɔwe̱ amo̱ ase̱ŋ‑ɔ, ne̱ Yeesuu fɔŋfɔŋ a le̱e̱ to̱ŋ ko̱ nare̱ ya tɔ bamo̱‑rɔ, ne̱ ŋkee mò̱ aa bamo̱ naa. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Baa ŋu mò̱, amaa bo̱ mo̱ŋ pini mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ne̱ Yeesuu a bise bamo̱ fe̱yɛ, “Nte̱tɔ ase̱ŋ ne̱ mo̱ne̱ naa mo̱ne̱ e̱ tɔwe̱ mo̱ne̱ i gywii abɛɛ‑ɔ ne̱e̱?” Ne̱ baa sii ye̱re̱, ne̱ oo ŋu fe̱yɛ bamo̱ akatɔ a pee. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ne̱ bamo̱ ɔko̱ ne̱ ba te̱e̱ mò̱ ɛ Kilopas‑ɔ a bise Yeesuu fe̱yɛ, “Amɔ fo̱ fe̱raa fo̱ wo̱re̱ e̱ gye̱ ɔfɔ Yɛro̱salɛm mfe̱e̱, ne̱ fo̱ mo̱ŋ nyi ŋke mfe̱ne̱ mɔ‑rɔ a ke̱tɔ ne̱ kaa ba‑ɔ?” ");
INSERT INTO ncuNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ne̱ Yeesuu yɛ, “Nte̱tɔ ase̱ŋ ya ba?” Ne̱ baa be̱ŋŋaa mò̱ fe̱yɛ, “Ke̱tɔ ne̱ kaa waa Yeesuu Nasarɛte̱nyi‑o. Weetee ɔ gye̱ Wuribware̱ a akyaamɛɛ‑ɔ ɔko̱ ne̱e̱, ne̱ ase̱sɛ‑ɔ a ŋu fe̱yɛ Wuribware̱ a sa mò̱ ke̱yaale̱ŋ bwe̱e̱tɔ fe̱yɛ ɔ waa akpe̱ŋe̱ye̱e̱tɔ, na ɔ kaapo̱ abware̱se̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ne̱ Wuribware̱ alɔŋŋɔpo̱‑ɔ na maŋ agye̱ŋkpɛɛpo̱‑ɔ a gyi mò̱ ase̱ŋ, ne̱ baa bu mò̱ ke̱pɔ, ne̱ bo̱ yɛ a bware fe̱yɛ o wu. Ne̱ baa taa mò̱ sa Roma awuye, ne̱ baa da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Na weetee ane̱ mɔ ane̱ de mò̱ te̱maa fe̱yɛ mò̱ e̱ gye̱ ne̱ ɔ ba na ɔ bo̱ mo̱rɔwe̱ Isireelii awuye. Amɔ ŋke nsa e̱ gye̱ ndɔɔ fe̱yɛ bamo̱ a waa mò̱ ane̱ŋ ne̱ ane̱ a tɔwe̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Amaa ane̱ akye̱e̱ ne̱ bo̱ tii ane̱ se̱‑ɔ a sa ne̱ e̱ye̱e̱ a kpe̱ŋ ane̱, bo̱ le̱e̱ fe̱yɛ baa ya de̱e̱re̱ ke̱gye̱raŋta‑ɔ‑rɔ gye̱gyaye̱ kese‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ne̱ bo̱ mo̱ŋ ŋu kifuniŋ‑o, ne̱ baa kiŋŋi bo̱ tɔwe̱ gywii ane̱ fe̱yɛ Wuribware̱ mbɔɔ ko̱ a lee bamo̱ e̱ye̱e̱ bo̱ kaapo̱ bamo̱. Mfe̱ŋ ne̱ baa tɔwe̱ gywii bamo̱ fe̱yɛ Yeesuu a kyiŋŋi le̱e̱ lowi‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ne̱ ane̱‑rɔ bo̱ko̱ a ya de̱e̱re̱ ke̱gye̱raŋta‑ɔ‑rɔ, bo̱ mo̱ŋ ŋu Yeesuu‑o fe̱yɛ ane̱ŋ dɛɛ ne̱ akye̱e̱ amo̱ a tɔwe̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ne̱ mo̱ŋ de mfɛɛre̱. Mo̱ne̱ saŋ mo̱ne̱ mo̱ŋ kɔɔre̱ ke̱tɔ ne̱ Wuribware̱ akyaamɛɛ a kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ gyi mo̱ne̱ ŋkpo̱nɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mo̱ne̱ mo̱ŋ tɛɛ nu kaase̱ fe̱yɛ a tiri fe̱yɛ Kristoo ne̱ Wuribware̱ yɛ o suŋ‑o i ŋu awo̱re̱fɔɔ na o wu, pwɛɛ na ɔ dɛɛ nya wuraa na ke̱dabe̱ Wuribware̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Bamo̱ aa Yeesuu a kya kpa se̱ bo̱ naa‑ɔ, ne̱ Yeesuu a le̱e̱ o lee ke̱tɔ ne̱ Mosis na Wuribware̱ akyaamɛɛ‑ɔ a kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ bo̱ kaapo̱ mò̱ kuŋu si ase̱ŋ‑nɔ pɛɛɛ gywii bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bamo̱ a kpa a bo̱ tɔ kamaŋgyii ne̱ ba yɔ kamo̱ se̱‑ɔ‑rɔ‑ɔ, ne̱ Yeesuu a waa fe̱yɛ mò̱ fe̱raa e̱ kyo̱ŋ se̱ mfe̱ŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Amaa bo̱ mo̱ŋ sure si fe̱yɛ ɔ kyo̱ŋ yɔ‑ɔ se̱‑ɔ, ne̱ bo̱ yɛ ɔ bo̱ so̱we̱ bamo̱ ase̱ mfe̱e̱, a le̱e̱ fe̱yɛ kyɔwe̱ a lo̱we̱. Amo̱se̱‑ɔ ne̱ Yeesuu a ya so̱we̱ bamo̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ne̱ mò̱ aa bamo̱ a kye̱na na bo̱ gyi ateese, ne̱ ɔɔ taa bodobodoo‑o, ne̱ ɔɔ sa Wuribware̱ aŋsɛ we̱e̱ se̱, ne̱ ɔɔ te̱ŋŋe̱‑rɔ sa bamo̱ a bo̱ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ŋkee ne̱ bamo̱ akatɔ a buŋŋi nɛɛnɛɛ‑ɔ ne̱e̱, ne̱ baa pini mò̱ mfe̱ŋ, amaa bo̱ mo̱ŋ lɛɛ ŋu mò̱, ɔɔ ŋaa. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ne̱ baa tɔwe̱ gywii abɛɛ fe̱yɛ, “Saŋ ne̱ ɔɔ kaapo̱ ane̱ abware̱se̱ŋ‑ɔ‑rɔ‑ɔ, aa waa ane̱ kɔne̱, ne̱ ane̱ ŋkpo̱nɔ‑rɔ a yuri ane̱, bɛɛɛ?” ");
INSERT INTO ncuNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Mfe̱ŋ ne̱ baa ko̱so̱ puri amo̱‑rɔ kiŋŋi yɔ Yɛro̱salɛm maŋ‑nɔ ya to̱ fe̱yɛ Yeesuu agyase̱po̱ kudu kako̱‑ɔ na bamo̱ ne̱ bo̱ tii si‑o a gyaŋŋe̱. Ne̱ abɛɛ anyɔ‑ɔ a tɔwe̱ gywii bamo̱ fe̱yɛ baa ŋu Yeesuu na ɔ ke̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ne̱ baa be̱ŋŋaa bamo̱ fe̱yɛ, “Kase̱ŋtiŋ, ane̱ nyaŋpe̱ a kyiŋŋi le̱e̱ lowi‑ro. Oo lee mò̱ e̱ye̱e̱ bo̱ kaapo̱ Simɔŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ne̱ anyare̱ anyɔ‑ɔ a tɔwe̱ ke̱tɔ ne̱ kaa ba kpa‑ɔ‑rɔ‑ɔ na ane̱ŋ ne̱ baa pini Yeesuu saŋ ne̱ ɔɔ te̱ŋŋe̱ bodobodoo‑o‑ro sa bamo̱‑ɔ gywii bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Na anyare̱ anyɔ‑ɔ saŋ ba tɔwe̱ ase̱ŋ‑ɔ ba gywii Yeesuu agyase̱po̱‑ɔ, ne̱ Yeesuu fɔŋfɔŋ a le̱e̱ bamo̱ se̱ ɔ ye̱re̱ bamo̱‑rɔ mfe̱ŋ, ne̱ ɔɔ ka bamo̱ kanɔ fe̱yɛ, “E̱ye̱e̱ yure mo̱ne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ne̱ kufu a nya bamo̱, ba fa fe̱yɛ ba ŋu kye̱ŋaŋpo̱ ko̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ne̱ oo bise bamo̱ fe̱yɛ, “Ntɔ i de mo̱ne̱ kufu? Nte̱tɔ se̱ ne̱ mo̱ne̱ maa kɔɔre̱ mo̱ne̱ i gyi? ");
INSERT INTO ncuNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mo̱nꞌ de̱e̱re̱ mo̱ asare̱e̱ na mo̱ ayaapapaa, na mo̱nꞌ ŋu fe̱yɛ mo̱ ne̱e̱. Na mo̱nꞌ kra mo̱‑rɔ a mo̱nꞌ ke̱e̱. Kye̱ŋaŋpo̱ de ayeegyi na abowii fe̱yɛ ane̱ŋ ne̱ mo̱ne̱ a ŋu n de‑o ooo?” ");
INSERT INTO ncuNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Mò̱ a tɔwe̱ ane̱ŋ‑ɔ, ne̱ ɔɔ taa mò̱ asare̱e̱ na ayaapapaa bo̱ kaapo̱ bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Bo̱ saŋ bo̱ mo̱ŋ kɔɔre̱ Yeesuu a ase̱ŋ‑ɔ gyi kyɛɛkyɛɛ. Amaa bamo̱ akatɔ a gyi, ne̱ e̱ye̱e̱ a kpe̱ŋ bamo̱. To, ne̱ Yeesuu a bise bamo̱ fe̱yɛ, “Mo̱ne̱ de ateese ko̱ mfe̱e̱ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ne̱ baa taa kakiŋgyi de̱ŋasɛ katiŋ ko̱ sa mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ne̱ ɔɔ taa wo̱ bamo̱ akatɔ‑rɔ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Saŋ ne̱ n te na mo̱ aa mo̱ne̱ e̱ sa se̱ŋsa‑ɔ, mo̱ a tɔwe̱ ase̱ŋ ko̱ gywii mo̱ne̱, ne̱ m be̱e̱ mo̱ e̱ tɔwe̱ amo̱‑rɔ. Amo̱ e̱ gye̱ fe̱yɛ ke̱tɔ ke̱maa ne̱ Mosis a kyo̱rɛɛ waa mò̱ mbraa wo̱re̱‑ɔ‑rɔ‑ɔ, ne̱ Wuribware̱ akyaamɛɛ a kyo̱rɛɛ‑ɔ, ne̱ Deefid a kyo̱rɛɛ waa mò̱ iliŋ wo̱re̱‑ɔ‑rɔ bo̱ le̱e̱ mo̱ kuŋu si‑o e̱ ba kase̱ŋtiŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ne̱ ɔɔ kya se̱ kaapo̱ ke̱tɔ ne̱ ke̱ bo̱ abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ, ne̱ a gye̱ mò̱ kuŋu si ase̱ŋ‑ɔ kaase̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ne̱ ŋkee ɔɔ tɔwe̱ ne̱e̱ fe̱yɛ, “Baa kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ ne̱e̱ fe̱yɛ Kristoo ne̱ Wuribware̱ yɛ o suŋ a ɔ bo̱ kyo̱ŋwe̱ kaye̱ mɔ‑rɔ‑ɔ i gyi awo̱re̱fɔɔ, na o wu, na ke̱mo̱ ŋke nsa o kyiŋŋi le̱e̱ lowi‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Na mo̱nꞌ yɔ mfe̱e̱ a Yɛro̱salɛm awuye‑o na kaye̱‑rɔ ase̱sɛ pɛɛɛ ase̱ ya ba mo̱ ke̱nyare̱ bo̱ tɔwe̱ ase̱ŋ timaa‑o gywii bamo̱. Na mo̱nꞌ tɔwe̱ gywii bamo̱ fe̱yɛ ɔke̱maa nu mò̱ e̱ye̱e̱, na o kiŋŋi le̱e̱ mò̱ e̱bɔye̱‑rɔ, na Wuribware̱ nya taa mò̱ e̱bɔye̱‑ɔ bo̱ ke mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mo̱ne̱ fɔŋfɔŋ e̱ gye̱ amo̱ aye̱re̱rɔpo̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Na mo̱ fɔŋfɔŋ sa a Wuribware̱ a kufwiiŋe timaa‑o ywe̱e̱ mo̱ne̱ se̱, fe̱yɛ ane̱ŋ ne̱ n se̱ Wuribware̱ a tɔwe̱ bo̱ be̱ya fe̱yɛ ɔ waa‑ɔ. Amaa mo̱nꞌ gywii maŋ‑nɔ mfe̱e̱ bo̱ fo̱ saŋ ne̱ mo̱ne̱ e̱ nya mfaanɛɛ a ke̱yaale̱ŋ ne̱ ke̱ e̱ le̱e̱ so̱so̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ne̱ ŋkee Yeesuu a sa ne̱ mò̱ aa mò̱ agyase̱po̱‑ɔ a yɔ hare̱e̱ Bɛtaniya kamaŋgyii, ne̱ ɔɔ yase̱ mò̱ asare̱e̱ so̱so̱, ne̱ oo yure bamo̱ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mò̱ a maa se̱ o yure bamo̱‑ɔ, ne̱ Wuribware̱ a bo̱ yaa mò̱ so̱so̱. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ne̱ mò̱ agyase̱po̱‑ɔ a sii mfe̱ŋ suŋ mò̱, ne̱ baa kiŋŋi yɔ Yɛro̱salɛm maŋ‑nɔ, na bamo̱ akatɔ a gyi bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ne̱ baa yɔ bo̱ bo̱ Wuribware̱ suŋkpa‑ɔ kabuno ba kyo̱rɔ Wuribware̱ kake ke̱maa.");
INSERT INTO ncuNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Atɔ ke̱maa ke̱le̱e̱kaase̱‑ɔ, Abware̱se̱ŋ kyɔ ɔ bo̱‑rɔ. Abware̱se̱ŋ‑ɔ na Wuribware̱ i te. Abware̱se̱ŋ‑ɔ na Wuribware̱ gye̱ ko̱ko̱ŋko̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Saŋ ne̱ Wuribware̱ a twe̱e̱ kaye̱‑ɔ, Abware̱se̱ŋ‑ɔ na Wuribware̱ kyɔ bo̱ bo̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Mò̱ se̱ ne̱ Wuribware̱ a waa ke̱tɔ ke̱maa bo̱ bo̱rɔ. Ke̱tɔ ke̱maa ne̱ Wuribware̱ a twe̱e̱‑ɔ, ɔ mo̱ŋ kwaye̱ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Abware̱se̱ŋ‑ɔ se̱ ne̱ ke̱tɔ ke̱maa ye̱re̱ ke̱ e̱ nya ŋkpa. Ŋkpa pɛɛɛ a le̱e̱ mò̱ ase̱ ne̱e̱. Ŋkpa mɔ a taa ke̱laŋŋe̱rɔ baa ase̱sɛ. ");
INSERT INTO ncuNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ke̱laŋŋe̱rɔ mɔ e̱ gye̱ ne̱ ke̱ e̱ laŋŋe̱ kibugyii‑ro, ne̱ kibugyii‑o maa taare̱ a ko̱ kyo̱ŋ ke̱laŋŋe̱rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ɔnyare̱ ko̱ e̱ dɛɛ ɔ bo̱‑rɔ ne̱ baa te̱e̱ mò̱ ɛ Yohanee. Ne̱ Wuribware̱ a suŋ mò̱ bo̱ kyo̱ŋwe̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Mò̱ e̱ gye̱ ne̱ ɔɔ ba bo̱ tɔwe̱ ke̱laŋŋe̱rɔ‑ɔ ase̱ŋ gywii ase̱sɛ, na bamo̱ pɛɛɛ nu ase̱ŋ‑ɔ, na bo̱ kɔɔre̱ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","N gye̱ Yohanee fɔŋfɔŋ e̱ gye̱ ne̱ ɔɔ sa ke̱laŋŋe̱rɔ‑ɔ, mò̱ fe̱raa, Wuribware̱ a suŋ mò̱ ne̱e̱ fe̱yɛ ɔ bo̱ tɔwe̱ ke̱laŋŋe̱rɔ‑ɔ ase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Abware̱se̱ŋ‑ɔ e̱ gye̱ ke̱laŋŋe̱rɔ kase̱ŋtiŋ amo̱ ne̱ ke̱ e̱ sa ase̱sɛ pɛɛɛ ke̱laŋŋe̱rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ne̱ ɔɔ baa ke̱laŋŋe̱rɔ kaye̱‑rɔ. Amaa saŋ ne̱ ɔɔ bo̱ kye̱na kaye̱‑rɔ‑ɔ, kaye̱‑rɔ ase̱sɛ mo̱ŋ pini mò̱, amaa mò̱ se̱ ne̱ Wuribware̱ a twe̱e̱ kaye̱‑ɔ bo̱ bo̱rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ne̱ ɔɔ ba kaye̱ ne̱ ɔɔ twe̱e̱‑ɔ‑rɔ, amaa mò̱ ase̱sɛ ne̱ ɔɔ twe̱e̱‑ɔ mɔ a kine mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Amaa bamo̱ bo̱ko̱ fe̱raa a kra mò̱ nɛɛnɛɛ, ne̱ baa kɔɔre̱ mò̱ gyi, amo̱se̱ se̱‑ɔ ne̱ ɔɔ sa bamo̱ pɛɛɛ kpa fe̱yɛ bo̱ kii Wuribware̱ mò̱ gyi‑ana. ");
INSERT INTO ncuNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Amaa se̱sɛ ya kii Wuribware̱ mò̱ gyi‑ana‑ɔ ɔko̱, n gye̱ se̱sɛ dimaadi e̱ gye̱ ne̱ ɔɔ kpa ne̱ ɔɔ ko̱we̱ gyi, Wuribware̱ fɔŋfɔŋ e̱ gye̱ ne̱ ɔɔ ko̱we̱ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","To, ne̱ Abware̱se̱ŋ‑ɔ a bo̱ kii nyiŋkpasɛ, ne̱ ɔɔ kye̱na ane̱ ase̱ kafo̱ŋfwe̱e̱. Ɔ bo̱ ane̱ ase̱, ne̱ oo ŋu ane̱ e̱wɛɛ bwe̱e̱tɔ, ne̱ o de kase̱ŋtiŋ ɔ kyɔ ke̱tɔ ke̱maa. Ne̱ ane̱ a ŋu mò̱ wuraa na mò̱ ke̱dabe̱ ne̱ a kaapo̱ ane̱ fe̱yɛ mò̱ e̱ gye̱ Wuribware̱ mò̱ gyi ko̱ŋko̱ kpeŋ‑o. ");
INSERT INTO ncuNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ne̱ Yohanee gbaa a le̱e̱ ɔ tɔwe̱ mò̱ ase̱ŋ fe̱yɛ, “Mo̱nꞌ ke̱e̱ mò̱. Mo̱ a kyɔ tɔwe̱ mò̱ ase̱ŋ gywii mo̱ne̱. Mò̱ e̱ gye̱ ne̱ ɔ ba mo̱ kamɛɛ‑rɔ. Ɔ kyɔ mo̱ ke̱dabe̱, a le̱e̱ fe̱yɛ ɔ kyɔ o te kyee pwɛɛ ne̱ baa dɛɛ ko̱we̱ mo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","To, mò̱ a ŋu ane̱ e̱wɛɛ bwe̱e̱tɔ‑ɔ se̱, ne̱ ɔɔ sa ane̱ ŋyure bwe̱e̱tɔ bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mosis si ne̱ Wuribware̱ a ba mbraa‑ɔ bo̱ bo̱rɔ, amaa Yeesuu Kristoo si ne̱ Wuribware̱ a ba ŋyure na kase̱ŋtiŋ bo̱ bo̱rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Amaa fe̱raa ɔko̱ mo̱ŋ tɛɛ ŋu Wuribware̱, mò̱ gyi ko̱ŋko̱ amo̱ ne̱ o te me̱raa mò̱ se̱ Wuribware̱‑ɔ, mò̱ e̱ gye̱ ne̱ ɔɔ kaapo̱ ane̱ŋ ne̱ Wuribware̱ du‑o. ");
INSERT INTO ncuNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ne̱ Yudaa awuye agye̱ŋkpɛɛpo̱ ne̱ bo̱ bo̱ Yɛro̱salɛm maŋ‑nɔ‑ɔ a suŋ Wuribware̱ alɔŋŋɔpo̱ na Lewii awuye ko̱ bo̱ kyo̱ŋwe̱ Yohanee Osuubɔpo̱‑ɔ ase̱ fe̱yɛ bo̱ yɔ ya bise mò̱ fe̱yɛ, “Nsɛ e̱ gye̱ fo̱? Fo̱ e̱ gye̱ Kristoo ne̱ Wuribware̱ a tɔwe̱ fe̱yɛ o suŋ‑o ooo?” ");
INSERT INTO ncuNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohanee mo̱ŋ kine bamo̱ ke̱be̱ŋŋaa, ne̱ ɔɔ kaapo̱ bamo̱‑rɔ nɛɛnɛɛ fe̱yɛ, “Daabii. N gye̱ mo̱ e̱ gye̱ Kristoo amo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ne̱ baa bise mò̱ fe̱yɛ, “To, ne̱ weetee nsɛ e̱ gye̱ fo̱? Fo̱ e̱ gye̱ Wuribware̱ kyaamɛɛ Iliya ne̱ baa kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ ɔ be̱e̱ ba a ɔ bo̱ gye̱ Kristoo ŋkpɛɛ‑ɔ ɔɔɔ?” Ne̱ ɔ yɛ, “N gye̱ Iliya e̱ gye̱ mo̱.” Ne̱ baa be̱e̱ bise mò̱ fe̱yɛ, “Fo̱ e̱ gye̱ Wuribware̱ kyaamɛɛ ne̱ ane̱ ɔde̱daapo̱ Mosis a kyɔ tɔwe̱ gywii ane̱ fe̱yɛ ɔ ba‑ɔ ɔɔɔ?” Ne̱ ɔ yɛ, “Daabii, n gye̱ mò̱ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","To, ne̱ bo̱ be̱e̱ bo̱ yɛ, “Amo̱ fe̱raa, tɔwe̱ gywii ane̱ mò̱ ne̱ fo̱ gye̱‑ɔ, a le̱e̱ fe̱yɛ ane̱ e̱ ya lee kanɔ bamo̱ ne̱ baa suŋ ane̱‑ɔ ase̱. E̱me̱ne̱ ne̱ fo̱ e̱ tɔwe̱ fo̱ e̱ye̱e̱ ase̱ŋ?” ");
INSERT INTO ncuNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ne̱ Yohanee a lee kanɔ fe̱yɛ, “Mo̱ e̱ gye̱ ɔko̱ ne̱ Wuribware̱ kyaamɛɛ Isaya a kyo̱rɛɛ mò̱ ase̱ŋ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ fe̱yɛ, ‘Ɔko̱ e̱ fɛɛ‑rɔ kimukee‑ro ɔ tɔwe̱ fe̱yɛ, Mo̱nꞌ lɔŋŋɔ kpa kye̱rarasɛ nɛɛnɛɛ bo̱ be̱ya ane̱ nyaŋpe̱ a ɔ bo̱rɔ se̱!’ ” ");
INSERT INTO ncuNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Ne̱ mbɔɔ ne̱ baa suŋ bo̱ kyo̱ŋwe̱ Yohanee ase̱‑ɔ bo̱ko̱ gye̱ Farisii awuye. Ne̱ baa bise mò̱ fe̱yɛ, “Fo̱ e̱ mo̱ŋ gye̱ Kristoo bɛɛɛ Iliya bɛɛɛ Wuribware̱ kyaamɛɛ amo̱, ne̱ e̱me̱ne̱ se̱ ne̱ fo̱ e̱ bɔ ase̱sɛ asuu?” ");
INSERT INTO ncuNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ne̱ Yohanee a lee kanɔ fe̱yɛ, “M fe̱raa, nkyu ne̱ n de mo̱ e̱ bɔ asuu, amaa ɔko̱ bo̱ mo̱ne̱‑rɔ, ne̱ mo̱ne̱ mo̱ŋ nyi mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Mo̱ a gye̱ mò̱ ŋkpɛɛ ba, amaa mo̱ŋ fo̱ fe̱yɛ ŋ kra mò̱ ase̱be̱ta‑rɔ lee gbaa, na m fwe̱e̱ mò̱ ayaapapaa se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Amo̱‑ɔ pɛɛɛ a waa Bɛtaniya kamaŋgyii ne̱ ɔ bo̱ Yo̱o̱daŋ bo̱ŋ kyɔwe̱ le̱e̱kpa a ke̱be̱gya‑ɔ‑rɔ, mfe̱ŋ ne̱ Yohanee e̱ bɔ asuu‑o ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kaye̱ ŋke‑o ne̱ Yohanee a ŋu Yeesuu na ɔ ba mò̱ ase̱, ne̱ ɔɔ tɔwe̱ fe̱yɛ, “Mo̱nꞌ ke̱e̱ ɔko̱ ne̱ o lee kaye̱‑rɔ e̱bɔye̱, fe̱yɛ ane̱ŋ ne̱ ba mɔɔ kasanne̱gyii ko̱ bo̱ de ba lee e̱bɔye̱‑ɔ. Mò̱ e̱ gye̱ Wuribware̱ a kasanne̱gyii‑o. ");
INSERT INTO ncuNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Se̱sɛ mɔ ase̱ŋ ne̱ mo̱ a tɔwe̱ fe̱yɛ, ‘Mò̱ e̱ gye̱ ne̱ ɔ ba mo̱ kamɛɛ‑ɔ. Ɔ kyɔ mo̱ ke̱dabe̱, a le̱e̱ fe̱yɛ ɔ kyɔ o te kyee pwɛɛ ne̱ baa dɛɛ ko̱we̱ mo̱.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","34","Ne̱ Yohanee a tɔwe̱ ane̱ŋ ne̱ ɔɔ waa pini fe̱yɛ Yeesuu e̱ gye̱ mò̱ ne̱ Wuribware̱ a suŋ mò̱ fɔŋfɔŋ bo̱ gye̱ ŋkpɛɛ tɔwe̱ mò̱ ase̱ŋ gywii ase̱sɛ‑ɔ. Ɔ yɛ, “Pwɛɛ ne̱ Yeesuu a ba mo̱ ase̱‑ɔ, mo̱ŋ nyi fe̱yɛ Wuribware̱ mò̱ gyi‑o ne̱e̱. Nsaŋ‑ɔ ne̱ Wuribware̱ a tɔwe̱ gywii mo̱ fe̱yɛ, ‘Fo̱ e̱ bɔ asuu, mo̱ e̱ sa a Wuribware̱ a kufwiiŋe timaa‑o le̱e̱ so̱so̱ ba kaase̱ fe̱yɛ kuwurele̱pɔ‑ɔ. Se̱sɛ ne̱ ke̱ e̱ kye̱na mò̱ se̱‑ɔ, mò̱ e̱ gye̱ Wuribware̱ mò̱ gyi‑o. Ne̱ mò̱ e̱ gye̱ mò̱ ne̱ ɔ ba kufwiiŋe timaa amo̱ a ɔ bo̱ gyee ase̱sɛ‑ɔ.’ To, ke̱tɔ se̱ ne̱ mo̱, Yohanee, e̱ bɔ mo̱ne̱ Isireelii awuye asuu‑o e̱ gye̱ fe̱yɛ mo̱nꞌ nya gyii mò̱. Ne̱ mbe̱yɔmɔ mo̱ fɔŋfɔŋ a ŋu mò̱‑ɔ se̱‑ɔ, mo̱ e̱ taare̱ a n tɔwe̱ gywii mo̱ne̱ fe̱yɛ Yeesuu mɔ gye̱ Wuribware̱ mò̱ gyi‑o kase̱ŋtiŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","36","Ke̱mo̱ kaye̱ ŋke‑o, ne̱ Yohanee mò̱ aa mò̱ agyase̱po̱ anyɔ ko̱ be̱e̱ bo̱ ye̱re̱ mfe̱ŋ, ne̱ oo ŋu Yeesuu naa ɔ kyo̱ŋ. Ne̱ ɔ yɛ, “Mo̱nꞌ ke̱e̱ mò̱ ne̱ mo̱ a kaapo̱ mo̱ne̱ fe̱yɛ ba mɔɔ mò̱ fe̱yɛ kasanne̱gyii‑o na bo̱ bo̱ lɔŋŋɔ Wuribware̱‑ɔ!” ");
INSERT INTO ncuNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Mò̱ agyase̱po̱ anyɔ‑ɔ a nu fe̱yɛ ɔ tɔwe̱ amo̱‑ɔ, ne̱ baa yɔ Yeesuu ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yeesuu a nyɔŋ ke̱e̱, ne̱ oo ŋu fe̱yɛ bo̱ gya mò̱ se̱‑ɔ, ne̱ oo bise bamo̱ fe̱yɛ, “Nte̱tɔ ne̱ mo̱ne̱ i buwi mo̱ne̱ e̱ kpa?” Ne̱ baa bise Yeesuu fe̱yɛ, “Ɔkaapo̱po̱, mfe̱ne̱ ne̱ fo̱ te?” ");
INSERT INTO ncuNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ne̱ oo lee kanɔ fe̱yɛ, “Mo̱nꞌ bo̱ ke̱e̱.” Saŋ amo̱‑ɔ kyɔwe̱ a kyɔ kpeere, ne̱ mò̱ aa bamo̱ a yɔ, ne̱ baa ya ŋu mfe̱ŋ ne̱ o te‑o, ne̱ baa nya se̱ sii mò̱ ase̱ kake amo̱ pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Agyase̱po̱ ne̱ baa gya Yeesuu si‑o ɔko̱ ke̱nyare̱ e̱ gye̱ Andruu, ne̱ o de daa ne̱ ba te̱e̱ mò̱ ɛ Simɔŋ. ");
INSERT INTO ncuNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Mfe̱ŋ ne̱ oo buwi kpa mò̱ daa, ne̱ ɔɔ tɔwe̱ gywii mò̱ fe̱yɛ, “Ane̱ a ŋu Masiya‑o.” (Masiya kaase̱ e̱ kaapo̱ fe̱yɛ Kristoo ne̱ Wuribware̱ yɛ o suŋ a ɔ bo̱ kyo̱ŋwe̱ kaye̱‑rɔ‑ɔ.) ");
INSERT INTO ncuNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ne̱ Andruu a yaa Simɔŋ Yeesuu ase̱. Ne̱ Yeesuu a de̱e̱re̱ mò̱ diŋŋ, ne̱ ɔɔ tɔwe̱ gywii mò̱ fe̱yɛ, “Fo̱ ke̱nyare̱ e̱ gye̱ Yohanee mò̱ gyi Simɔŋ, amaa le̱e̱ ndɔɔ bo̱ yɔ fo̱ ke̱ŋasɛnyare̱ e̱ gye̱ Ke̱e̱fas.” (Griiki se̱ŋsa‑rɔ ke̱mo̱ e̱ gye̱ Peetroo, ne̱ Peetroo kaase̱ mɔ e̱ kaapo̱ fe̱yɛ Ke̱fo̱re̱.) ");
INSERT INTO ncuNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Kaye̱ a be̱e̱ ke‑o, ne̱ Yeesuu a kra fe̱yɛ ɔ yɔ Galile̱ya swe̱e̱re̱ se̱. Ne̱ oo ŋu ɔnyare̱ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Filipo, ne̱ ɔɔ le̱e̱ Bɛtɛsaye̱da maŋ‑nɔ, Andruu na Peetroo‑ana aye̱‑ɔ. Ne̱ ɔɔ tɔwe̱ gywii mò̱ fe̱yɛ, “Ba a mo̱ aa fo̱ a yɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ne̱ Filipo a ŋu ɔnyare̱ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Nataniyɛl‑ɔ, ne̱ ɔɔ tɔwe̱ gywii mò̱ fe̱yɛ, “Ane̱ a ŋu mò̱ ne̱ ane̱ ɔde̱daapo̱ Mosis a kyo̱rɛɛ mò̱ ase̱ŋ bo̱ waa Wuribware̱ mbraa a wo̱re̱‑ɔ‑rɔ‑ɔ, ne̱ Wuribware̱ akyaamɛɛ gbaa a be̱e̱ kyo̱rɛɛ mò̱ ase̱ŋ‑ɔ. Mò̱ e̱ gye̱ Yeesuu, Yo̱sɛf mò̱ gyi, ne̱ ɔɔ le̱e̱ Nasarɛt maŋ‑nɔ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ne̱ Nataniyɛl a bise Filipo fe̱yɛ, “Nasarɛt! A taare̱ a a waa fe̱yɛ kamaŋgyii mɔ‑rɔ ne̱ atɔ dame̱naŋsɛ a le̱e̱ aaa?” Ne̱ Filipo yɛ, “Bo̱ ke̱e̱ ɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yeesuu a ŋu Nataniyɛl e̱ ba mò̱ ase̱‑ɔ, ne̱ ɔɔ tɔwe̱ fe̱yɛ, “Mo̱nꞌ ke̱e̱ Isireeliinyi kase̱ŋtiŋ, ne̱ ɔ mo̱ŋ de kaye̱ba‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ne̱ Nataniyɛl a bise mò̱ fe̱yɛ, “E̱me̱ne̱ ne̱ fo̱ a waa fo̱ nyi mo̱?” Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Mo̱ a taare̱ ŋu fo̱, na m bo̱ mfe̱e̱, pwɛɛ ne̱ Filipo a dɛɛ te̱e̱ fo̱ baa mo̱ ase̱. N gye̱ figi kiyii kaase̱ ne̱ fo̱ bo̱ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ne̱ Nataniyɛl yɛ, “Ɔkaapo̱po̱, Wuribware̱ mò̱ gyi‑o e̱ gye̱ fo̱. Isireelii swe̱e̱re̱ owure‑o e̱ gye̱ fo̱!” ");
INSERT INTO ncuNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ne̱ Yeesuu a tɔwe̱ fe̱yɛ, “Ane̱ŋ ne̱ mo̱ a tɔwe̱ gywii fo̱ fe̱yɛ mo̱ a taare̱ ŋu fo̱, na m bo̱ mfe̱e̱, saŋ ne̱ fo̱ bo̱ kiyii‑o kaase̱‑ɔ se̱, ne̱ fo̱ a kɔɔre̱ mo̱ gyi aaa? Saŋ ko̱ e̱ ba na fo̱ ŋu amo̱ ne̱ a kyɔ amo̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Kase̱ŋtiŋ ne̱ mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ awo̱re̱‑rɔ i buŋŋi‑ro, na Wuribware̱ mbɔɔ e̱ ba kaase̱ ba ywe̱e̱ mo̱, dimaadi mò̱ gyi‑o, si ba kiŋŋi ba yɔ so̱so̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Amo̱ ŋke ŋnyɔ kamɛɛ‑rɔ, ne̱ baa taa ko̱ko̱fɔ Kana maŋ ne̱ ɔ bo̱ Galile̱ya swe̱e̱re̱ se̱‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ne̱ baa te̱e̱ Yeesuu na mò̱ agyase̱po̱‑ɔ fe̱yɛ bo̱ ba ko̱ko̱fɔ‑ɔ‑rɔ. Amɔ Yeesuu mò̱ nyi bo̱ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Saŋ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ, ne̱ ko̱ko̱fɔ‑ɔ‑rɔ a nta‑ɔ a lo̱we̱. Ne̱ Yeesuu mò̱ nyi a tɔwe̱ gywii mò̱ fe̱yɛ, “Bamo̱ nta‑ɔ pɛɛɛ a lo̱we̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ne̱ Yeesuu yɛ, “N na, m fe̱raa, mo̱ saŋ‑ɔ mo̱ŋ tɛɛ fo̱ a ŋ waa ko̱tɔko̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ne̱ Yeesuu mò̱ nyi a tɔwe̱ gywii ayaafɔre̱‑ɔ fe̱yɛ, “Mo̱nꞌ waa ke̱tɔ ke̱maa ne̱ ɔ tɔwe̱ a o gywii mo̱ne̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yudaa awuye de asare̱e̱ ke̱fwe̱e̱ ko̱ ne̱ baa suye le̱e̱ bamo̱ ade̱daapo̱ ase̱‑ɔ. Nkyu ne̱ bo̱ de ba fwe̱e̱ bamo̱ asare̱e̱‑ɔ bo̱ alaŋ dabe̱ dabe̱ ko̱ ne̱ baa ba afo̱re̱ bo̱ waa‑ɔ‑rɔ. Alaŋ mɔ ke̱ke̱maa nkyu e̱ fo̱ aŋko̱re̱ kitiŋ. ");
INSERT INTO ncuNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ne̱ Yeesuu a tɔwe̱ gywii ayaafɔre̱‑ɔ fe̱yɛ bo̱ sɛɛ nkyu bo̱ bo̱rɔ alaŋ‑ɔ. Ne̱ baa sɛɛ nkyu bo̱ bo̱rɔ amo̱ pe̱e̱pe̱e̱pe̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","9","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mbe̱yɔmɔ mo̱nꞌ saa nkyu‑o ŋko̱ le̱e̱ alaŋ‑ɔ ko̱ko̱ŋko̱‑rɔ yaa bo̱ sa ko̱ko̱fɔ‑ɔ ɔgye̱ŋkpɛɛpo̱.” Ne̱ nkyu‑o a buruwi nta. Ne̱ ŋkee baa taa nta‑ɔ yaa mò̱, ne̱ ɔɔ da ke̱e̱. Mò̱ a da ke̱e̱‑ɔ, ɔ mo̱ŋ pini mfe̱ŋ ne̱ nta amo̱ a le̱e̱‑ɔ, amaa ayaafɔre̱ ne̱ baa saa nkyu‑o baa‑ɔ fe̱raa nyi. Amo̱se̱‑ɔ ne̱ ɔɔ te̱e̱ ɔko̱fɔ kuri, ");
INSERT INTO ncuNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ne̱ ɔɔ tɔwe̱ gywii mò̱ fe̱yɛ, “Ɔke̱maa i ke nta timaa‑o pwɛɛ ne̱e̱, ne̱ afɔ pɛɛɛ ya nya nuu ane̱ŋ ne̱ a baare bamo̱‑ɔ pwɛɛ na ɔ dɛɛ baa nta ke̱maa ne̱ ɔ kpa‑ɔ. Amaa fo̱ fe̱raa, fo̱ a taa nta timaa bo̱ sii kamɛɛ bo̱ fo̱ mbe̱yɔmɔ ne̱e̱, ne̱ fo̱ a dɛɛ lee baa.” ");
INSERT INTO ncuNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kana maŋ ne̱ ɔ bo̱ Galile̱ya swe̱e̱re̱ se̱‑ɔ‑rɔ ne̱ Yeesuu a bo̱ le̱e̱ waa atɔ ne̱ a kpe̱ŋ e̱ye̱e̱‑ɔ. Mfe̱ŋ ne̱ ɔɔ gye̱ ŋkpɛɛ kaapo̱ mò̱ ke̱yaale̱ŋ. Amo̱se̱ ne̱ mò̱ agyase̱po̱‑ɔ a kɔɔre̱ mò̱ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Amo̱‑ɔ pɛɛɛ kamɛɛ‑rɔ, ne̱ Yeesuu na mò̱ nyi na mò̱ tire‑ana na mò̱ agyase̱po̱‑ɔ a yɔ Kapaaniyum maŋ‑nɔ, ne̱ baa kye̱na mfe̱ŋ ŋke kafo̱ŋfwe̱e̱ ko̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Kasu kanɔ ateese kigyibe̱e̱ ne̱ ba te̱e̱ ɛ Wuribware̱-a‑kya-ane̱-yɔwe̱‑ɔ a kpa a ko̱ fo̱‑ɔ se̱‑ɔ, ne̱ Yeesuu a yɔ Yɛro̱salɛm maŋ‑nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ne̱ ɔɔ yɔ Wuribware̱ suŋkpa kabuno ya to̱ anyare̱ na ba fe e̱naate̱ na e̱sanne̱ na awurele̱pɔ, ne̱ bamo̱ bo̱ko̱ mɔ te bamo̱ iteeburi ase̱ ba kyeeri Roma swe̱e̱re̱ se̱ atanne̱ ba yaa Yude̱ya swe̱e̱re̱ se̱ atanne̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yeesuu a ŋu amo̱‑ɔ, ne̱ ɔɔ taa ife bo̱ waa paara, ne̱ ɔɔ gya e̱sanne̱‑ɔ na e̱naate̱‑ɔ pɛɛɛ le̱e̱ Wuribware̱ suŋkpa a kabuno‑o, ne̱ ɔɔ gye̱ra gye̱ra atanne̱ akyeeripo̱ a iteeburi‑o bo̱ da, ne̱ ɔɔ ŋo̱ra bamo̱ atanne̱ agyi‑o‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ne̱ ɔɔ sa ne̱ bamo̱ ne̱ ba fe awurele̱pɔ‑ɔ a taa amo̱ le̱e̱ mfe̱ŋ. Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ne̱ ma taa n se̱ aye̱ bo̱ kii ke̱gya gyikpa.” ");
INSERT INTO ncuNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ane̱ŋ ne̱ ɔɔ tɔwe̱‑ɔ se̱‑ɔ, mò̱ agyase̱po̱‑ɔ a nyiŋŋi ane̱ŋ ne̱ abware̱se̱ŋ wo̱re̱‑ɔ a tɔwe̱‑ɔ se̱ fe̱yɛ, “Wuribware̱, ke̱kpa de̱maŋte̱ ne̱ mo̱ e̱ kpa fo̱ suŋkpa‑ɔ a kɔɔre̱ mo̱ kakpo̱nɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ne̱ Yudaa awuye agye̱ŋkpɛɛpo̱ a ba mò̱ ase̱ bo̱ bise mò̱ fe̱yɛ, “Ntɔ atɔ dabe̱ ne̱ fo̱ e̱ taare̱ a fo̱ waa bo̱ kaapo̱ ane̱, na a kaapo̱ fe̱yɛ fo̱ de kpa fe̱yɛ fo̱ waa amo̱‑ɔ?” ");
INSERT INTO ncuNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Mo̱ne̱ ya bwee Wuribware̱ suŋkpa mɔ, ŋke nsa bo̱ fo̱‑ɔ, mo̱‑ɔ mo̱ a be̱e̱ pwɛɛ mò̱ bo̱ ye̱ra.” ");
INSERT INTO ncuNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ne̱ baa bise mò̱ fe̱yɛ, “Baa taa nsu aduna na nsiye ne̱e̱ bo̱ pwɛɛ Wuribware̱ suŋkpa mɔ,† ne̱ fo̱ fe̱raa, fo̱ yɛ ŋke nsa bo̱ fo̱‑ɔ fo̱ a be̱e̱ pwɛɛ mò̱ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Amaa Wuribware̱ suŋkpa ne̱ Yeesuu e̱ tɔwe̱ mò̱ ase̱ŋ‑ɔ mo̱ŋ gye̱ suŋkpa ne̱ bo̱ ye̱re̱ mò̱‑rɔ‑ɔ. Suŋkpa ne̱ ɔ tɔwe̱ mò̱ ase̱ŋ‑ɔ e̱ gye̱ mò̱ fɔŋfɔŋ kayo̱wɔre̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Amo̱se̱ se̱‑ɔ mò̱ a wu ne̱ baa pure mò̱‑ɔ, mò̱ kikyiŋŋi‑ro‑o mò̱ agyase̱po̱‑ɔ a nyiŋŋi si fe̱yɛ ɔɔ tɔwe̱ amo̱‑ɔ, ne̱ baa kɔɔre̱ abware̱se̱ŋ wo̱re̱‑ɔ na ke̱tɔ ne̱ Yeesuu a tɔwe̱‑ɔ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yeesuu a bo̱ Yɛro̱salɛm maŋ‑nɔ saŋ ne̱ ba gyi Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese‑o, ase̱sɛ bwe̱e̱tɔ a kɔɔre̱ mò̱ gyi, ane̱ŋ ne̱ baa ŋu atɔ dabe̱ dabe̱ ne̱ ɔɔ waa‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Amaa Yeesuu mo̱ŋ taa mò̱ e̱ye̱e̱ bo̱ dɔŋŋɔ bamo̱ se̱, a le̱e̱ fe̱yɛ o nyi ane̱ŋ ne̱ bamo̱ pɛɛɛ du‑o. ");
INSERT INTO ncuNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Amo̱se̱ se̱‑ɔ a mo̱ŋ tiri fe̱yɛ ɔko̱ tɔwe̱ ane̱ŋ ne̱ bo̱ du‑o gywii mò̱, bo̱ le̱e̱ fe̱yɛ o nyi ke̱tɔ ne̱ ke̱ bo̱ bamo̱ ŋkpo̱nɔ‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ɔnyare̱ ko̱ bo̱‑rɔ ne̱ ba te̱e̱ mò̱ ɛ Nikodeemus. Ɔ gye̱ Yudaa awuye a maŋ abre̱sɛ‑ɔ ɔko̱, ne̱ ɔ be̱e̱ ɔ gye̱ Farisii awuye‑o ɔko̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Kanye ko̱, ne̱ ɔɔ yɔ Yeesuu ase̱ ya tɔwe̱ fe̱yɛ, “Ɔkaapo̱po̱, ane̱ nyi fe̱yɛ fo̱ gye̱ ɔkaapo̱po̱ ne̱ Wuribware̱ a suŋ bo̱ kyo̱ŋwe̱‑ɔ ne̱e̱, a le̱e̱ fe̱yɛ ɔko̱ maa taare̱ a ɔ waa akpe̱ŋe̱ye̱e̱tɔ mɔ ne̱ fo̱ e̱ waa‑ɔ, amɔ Wuribware̱ ye̱re̱ mò̱‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ne̱ Yeesuu a tɔwe̱ fe̱yɛ, “Mo̱ i gyi fo̱ kase̱ŋtiŋ fe̱yɛ ɔko̱ maa taare̱ a o tii Wuribware̱ a kuwure‑o si, amɔ baa be̱e̱ ko̱we̱ mò̱ pwɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ne̱ Nikodeemus a bise mò̱ fe̱yɛ, “E̱me̱ne̱ ne̱ ba waa na bo̱ be̱e̱ ko̱we̱ se̱sɛ ne̱ ɔɔ daŋ‑ɔ? Kase̱ŋtiŋ ne̱e̱ fe̱yɛ ɔ maa lɛɛ taare̱ a o kiŋŋi lwee mò̱ nyi kame‑ro a ɔ be̱e̱ ko̱we̱ mò̱ nyɔse̱po̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Mo̱ i gyi fo̱ kase̱ŋtiŋ fe̱yɛ, ɔko̱ maa taare̱ a o tii Wuribware̱ a kuwure‑o si, amɔ baa ba nkyu bo̱ bɔ mò̱ asuu, ne̱ Wuribware̱ a kufwiiŋe timaa‑o a ko̱we̱ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mò̱ ne̱ dimaadi a ko̱we̱ mò̱‑ɔ de dimaadi ko̱yo̱wɔre̱gyi, ne̱ mò̱‑ɔ mɔ ne̱ Wuribware̱ a kufwiiŋe timaa‑o a ko̱we̱ mò̱‑ɔ fe̱raa mò̱ kra a nya ŋkpa po̱pwɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Amo̱se̱ se̱‑ɔ fo̱ ma sa a a kpe̱ŋ fo̱ e̱ye̱e̱ fe̱yɛ mo̱ a tɔwe̱ gywii fo̱ fe̱yɛ a tiri fe̱yɛ bo̱ be̱e̱ ko̱we̱ mo̱ne̱ ɔke̱maa. ");
INSERT INTO ncuNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","To, afwii e̱ da a yɔ mfe̱ŋ ne̱ a kpa‑ɔ ne̱e̱. Fo̱ i nu amo̱ se̱, amaa fo̱ mo̱ŋ nyi mfe̱ŋ ne̱ aa le̱e̱‑ɔ na mfe̱ŋ ne̱ a yɔ‑ɔ. Ane̱ŋ dɛɛ ne̱ ane̱ maa nu kaase̱ ane̱ŋ ne̱ Wuribware̱ a kufwiiŋe timaa‑o e̱ ko̱we̱ ɔko̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ne̱ Nikodeemus a lee kanɔ fe̱yɛ, “E̱me̱ne̱ ne̱ amo̱‑ɔ e̱ waa a a waa ane̱ŋ?” ");
INSERT INTO ncuNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ne̱ Yeesuu a be̱ŋŋaa mò̱ fe̱yɛ, “Fo̱ gye̱ Isireelii awuye‑ro ɔkaapo̱po̱ dabe̱‑ɔ, na fo̱ mo̱ŋ nyi amo̱‑ɔ aaa? ");
INSERT INTO ncuNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mo̱ i gyi fo̱ kase̱ŋtiŋ fe̱yɛ ke̱tɔ ke̱maa ne̱ ane̱ nyi‑o ase̱ŋ ne̱ ane̱ e̱ tɔwe̱, ne̱ ke̱tɔ ne̱ ane̱ a ŋu‑o ase̱ŋ ne̱ ane̱ e̱ tɔwe̱. Amaa amo̱ pɛɛɛ gbaa mo̱ne̱ ɔke̱maa maa kɔɔre̱ ane̱ ase̱ŋ o gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kaye̱ mɔ‑rɔ atɔ ase̱ŋ ne̱ mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱, ne̱ mo̱ne̱ maa kɔɔre̱ mo̱ mo̱ne̱ i gyi‑o, saŋbo̱to̱ Wuribware̱ se̱ ase̱ŋ ne̱ mo̱ ya tɔwe̱ gywii mo̱ne̱, ne̱ mo̱ne̱ e̱ kɔɔre̱ mo̱ a mo̱nꞌ gyi aaa? ");
INSERT INTO ncuNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Na ɔko̱ mɔ mo̱ŋ tɛɛ yɔ Wuribware̱ se̱ ya ŋu. Amaa mo̱, dimaadi mò̱ gyi‑o, a le̱e̱ Wuribware̱ se̱ ba. Amo̱se̱ ne̱ mo̱ e̱ taare̱ a n tɔwe̱ Wuribware̱ se̱ atɔ ase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mo̱ne̱ a kare̱ abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ ŋu ane̱ŋ ne̱ ane̱ ɔde̱daapo̱ Mosis a taa kayo̱waa bo̱ waa ke̱tɔ ko̱ fe̱yɛ ko̱wɔ‑ɔ, ne̱ ɔɔ ba ke̱mo̱ bo̱ kye̱na kayii so̱so̱, na ɔke̱maa ne̱ ko̱wɔ a duŋ mò̱ kimukee‑ro mfe̱ŋ‑ɔ, mò̱ ya yase̱ kuŋu de̱e̱re̱ ke̱tɔ‑ɔ na ɔ ma wu, amaa na ɔ nya ŋkpa‑ɔ. Ane̱ŋ dɛɛ ne̱e̱, a tiri fe̱yɛ bo̱ yase̱ mo̱, dimaadi mò̱ gyi‑o, so̱so̱, ");
INSERT INTO ncuNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","na ɔke̱maa ne̱ ɔ kɔɔre̱ mo̱ o gyi‑o maa wu, amaa na ɔ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","A kaapo̱ fe̱yɛ Wuribware̱ a kpa kaye̱‑rɔ ase̱sɛ ke̱baŋse̱‑ɔ se̱, ne̱ ɔɔ taa mò̱ gyi ko̱ŋko̱ wo̱re̱ kpeŋ ne̱ o de‑o sa ane̱ fe̱yɛ ɔke̱maa ne̱ ɔ kɔɔre̱ mò̱ o gyi‑o maa wu, amaa ɔ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","A mo̱ŋ gye̱ fe̱yɛ Wuribware̱ a suŋ mò̱ gyi bo̱ kyo̱ŋwe̱ ne̱e̱ fe̱yɛ ɔ bo̱ kii kaye̱‑rɔ ase̱sɛ ɔse̱ŋgyipo̱, amaa ɔɔ ba ne̱e̱ fe̱yɛ ɔ ba a ɔ bo̱ kii kaye̱‑rɔ ase̱sɛ ɔmo̱rɔwe̱po̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ɔke̱maa ne̱ ɔ kɔɔre̱ mò̱ o gyi‑o, Wuribware̱ maa bu mò̱ ke̱pɔ, amaa ɔke̱maa ne̱ ɔ maa kɔɔre̱ mò̱ o gyi‑o, Wuribware̱ a kyɔ bu mò̱ ke̱pɔ, a le̱e̱ fe̱yɛ ɔ mo̱ŋ kɔɔre̱ Wuribware̱ mò̱ gyi ko̱ŋko̱ kpeŋ‑o gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mfaanɛɛ ne̱ mo̱ne̱ e̱ ba a mo̱nꞌ bo̱ ŋu bamo̱ ne̱ Wuribware̱ i bu ke̱pɔ‑ɔ, amo̱ e̱ gye̱ fe̱yɛ ke̱laŋŋe̱rɔ a ba kaye̱‑rɔ, amaa kaye̱‑rɔ ase̱sɛ e̱ kpa kibugyii‑o bo̱ kyo̱ŋ ke̱laŋŋe̱rɔ‑ɔ, a le̱e̱ fe̱yɛ ba waa atɔ ne̱ a gye̱ bɔye̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ɔke̱maa ne̱ ɔ waa e̱bɔye̱‑ɔ se̱re̱ ke̱laŋŋe̱rɔ‑ɔ. Ane̱ŋ se̱‑ɔ, ɔ maa kpa a ɔ ba ke̱laŋŋe̱rɔ‑rɔ, a le̱e̱ fe̱yɛ ɔ maa kpa a mò̱ e̱bɔye̱‑ɔ le̱e̱ kawu. ");
INSERT INTO ncuNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Amaa ɔke̱maa ne̱ ɔ waa ke̱tɔ ne̱ ke̱ gye̱ kase̱ŋtiŋ‑o e̱ ba ke̱laŋŋe̱rɔ‑rɔ, na ke̱laŋŋe̱rɔ kaapo̱ fe̱yɛ Wuribware̱ e̱ gye̱ ne̱ ɔ kya mò̱‑rɔ a ɔ waa ke̱tɔ ke̱maa.” ");
INSERT INTO ncuNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Amo̱‑ɔ kamɛɛ‑rɔ, ne̱ Yeesuu na mò̱ agyase̱po̱‑ɔ a yɔ Yude̱ya swe̱e̱re̱ se̱. Ne̱ mò̱ aa bamo̱ a kye̱na mfe̱ŋ ŋke mfe̱ne̱ ko̱, ne̱ baa bɔ ase̱sɛ asuu. ");
INSERT INTO ncuNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Saŋ amo̱‑ɔ Yohanee mɔ bo̱ maŋ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Aye̱nɔŋ ne̱ ɔ maa Salim maŋ‑ɔ se̱, ɔ bɔ asuu, a le̱e̱ fe̱yɛ nkyu bo̱ mfe̱ŋ bwe̱e̱tɔ. Ase̱sɛ naa mò̱ ase̱, ne̱ ɔ bɔ bamo̱ asuu. ");
INSERT INTO ncuNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Saŋ amo̱‑ɔ bo̱ mo̱ŋ tɛɛ tii Yohanee. ");
INSERT INTO ncuNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ne̱ Yohanee agyase̱po̱‑ɔ na Yudaanyi ko̱ a le̱e̱ ba gyiiri ikii bo̱ le̱e̱ ane̱ŋ ne̱ ba bɔ asuu‑o si. ");
INSERT INTO ncuNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Amo̱se̱ se̱‑ɔ ne̱ baa yɔ Yohanee ase̱, ne̱ baa tɔwe̱ gywii mò̱ fe̱yɛ, “Ɔkaapo̱po̱, fo̱ a nyiŋŋi ɔnyare̱ ne̱ ɔɔ ba fo̱ ase̱ nno̱ŋ a bo̱ŋbe̱‑ɔ se̱ aaa? Ɔko̱ ne̱ fo̱ a tɔwe̱ mò̱ ase̱ŋ‑ɔ, Yeesuu ne̱ ane̱ de. Mbe̱yɔmɔ ɔ maa se̱ ɔ bɔ asuu, amo̱se̱ se̱‑ɔ ɔke̱maa naa mò̱ ase̱ ɔ bɔ asuu! A bware fe̱yɛ ɔ waa ane̱ŋ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ne̱ Yohanee a be̱ŋŋaa bamo̱ fe̱yɛ, “A bware. Ɔke̱maa na aketɔ ne̱ Wuribware̱ a sa mò̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mo̱ne̱ fɔŋfɔŋ ye̱re̱ mo̱‑rɔ fe̱yɛ mo̱ a tɔwe̱ fe̱yɛ n gye̱ mo̱ e̱ gye̱ Kristoo‑o, amaa Wuribware̱ a suŋ mo̱ bo̱ gye̱ mò̱ ŋkpɛɛ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kristoo du fe̱yɛ ɔko̱fɔ kuri‑o, ne̱ ase̱sɛ ne̱ bo̱ naa mò̱ ase̱‑ɔ du fe̱yɛ mò̱ ɔko̱fɔ‑ɔ. M fe̱raa, n du fe̱yɛ ɔko̱fɔ kuri mò̱ nyare̱ ne̱ ɔ de̱e̱re̱ mò̱ kpa‑ɔ. To, mbe̱yɔmɔ mo̱ a ŋu mò̱ a ba, ne̱ mò̱ a nu mò̱ se̱ŋsa‑ɔ, ne̱ mo̱ akatɔ a gyi bwe̱e̱tɔ fe̱yɛ ŋkee ɔɔ nya mò̱ ɔko̱fɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","A bware fe̱yɛ Yeesuu e̱ gye̱ ne̱ ɔ waa ke̱dabe̱, na mo̱, Yohanee, mɔ ŋ kii kagyingyii.” ");
INSERT INTO ncuNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yeesuu a le̱e̱ Wuribware̱ se̱‑ɔ se̱‑ɔ, ɔ kyɔ ɔke̱maa. Ɔko̱ ne̱ baa ko̱we̱ mò̱ kaye̱ mɔ‑rɔ‑ɔ mɔ gye̱ kaye̱ mɔ‑rɔ se̱sɛ, ne̱ ɔ tɔwe̱ kaye̱ mɔ‑rɔ ase̱ŋ, amaa mò̱ ne̱ ɔɔ le̱e̱ Wuribware̱ se̱‑ɔ e̱ gye̱ ne̱ ɔ kyɔ bamo̱ pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Mò̱ e̱ gye̱ ne̱ ɔ tɔwe̱ ke̱tɔ ne̱ oo ŋu‑o na ke̱tɔ ne̱ oo nu‑o, amaa nsɛ e̱ gye̱ ne̱ ɔɔ kɔɔre̱ mò̱ ase̱ŋ gyi? ");
INSERT INTO ncuNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Amaa ɔke̱maa ne̱ ɔ kɔɔre̱ mò̱ ase̱ŋ‑ɔ o gyi‑o e̱ ba amo̱ a ɔ bo̱ kaapo̱ fe̱yɛ Wuribware̱ e̱ gye̱ kase̱ŋtiŋ wuye. ");
INSERT INTO ncuNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Mò̱ ne̱ Wuribware̱ a suŋ bo̱ kyo̱ŋwe̱‑ɔ e̱ gye̱ ne̱ ɔ tɔwe̱ Wuribware̱ ase̱ŋ, a le̱e̱ fe̱yɛ Wuribware̱ a sa mò̱ mò̱ kufwiiŋe timaa‑o ke̱yaale̱ŋ bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mò̱ se̱ Wuribware̱ a kpa mò̱ ase̱ŋ‑ɔ se̱‑ɔ, ne̱ ɔɔ taa ke̱tɔ ke̱maa bo̱ waa mò̱ ke̱sare̱e̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Amo̱se̱ se̱‑ɔ ɔke̱maa ne̱ ɔ kɔɔre̱ Wuribware̱ mò̱ gyi‑o o gyi‑o e̱ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ, amaa ɔke̱maa ne̱ ɔ maa kɔɔre̱ mò̱ o gyi‑o maa nya ŋkpa pɛɛɛ, na Wuribware̱ kaduŋfwii sii mò̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ne̱ Farisii awuye a nu fe̱yɛ ase̱sɛ ne̱ baa yɔ Yeesuu ase̱, ne̱ ɔɔ bɔ bamo̱ asuu‑o a bo̱ kii mò̱ agyase̱po̱‑ɔ kyo̱ŋ Yohanee lee‑o. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Kase̱ŋtiŋ fe̱raa Yeesuu fɔŋfɔŋ mo̱ŋ bɔ asuu‑o, amaa mò̱ agyase̱po̱‑ɔ ya bɔ ase̱sɛ asuu. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","To, Yeesuu a nu ane̱ŋ ne̱ baa tɔwe̱‑ɔ, ne̱ ɔɔ le̱e̱ Yude̱ya swe̱e̱re̱ se̱ kiŋŋi yɔ Galile̱ya swe̱e̱re̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Saŋ ne̱ ɔ yɔ‑ɔ, ne̱ oo ŋu fe̱yɛ a tiri fe̱yɛ ɔ bo̱rɔ Samariya swe̱e̱re̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ne̱ ɔɔ fo̱ Samariya maŋ ko̱ ne̱ ba te̱e̱ ɛ Sikaa ne̱ ɔ maa swe̱e̱re̱ ko̱ ne̱ Yudaa awuye ɔde̱daapo̱ Yakubu a taa sa mò̱ gyi Yo̱sɛf‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Mfe̱ŋ ne̱ kitiribu ne̱ ba te̱e̱ ke̱mo̱ ɛ Yakubu kitiribu‑o bo̱‑ɔ. Yeesuu a nare̱ kpo̱ne̱‑ɔ se̱‑ɔ, mò̱ a bo̱ fo̱ kitiribu amo̱ ase̱‑ɔ, ne̱ ɔɔ kye̱na ke̱mo̱ ase̱ a o kyure. Saŋ amo̱‑ɔ na kyɔwe̱ a fo̱ mpase̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Yeesuu a te kitiribu‑o ase̱, mfe̱ŋ‑ɔ ne̱ Samariya ɔkye̱e̱ ko̱ a ba a ɔ bo̱ saa nkyu, ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Sa mo̱ nkyu a n nuu.” ");
INSERT INTO ncuNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Saŋ amo̱‑ɔ, mò̱ agyase̱po̱‑ɔ yii maŋ‑nɔ a bo̱ ya sɔɔ ateese. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ne̱ ɔkye̱e̱‑ɔ a lee kanɔ fe̱yɛ, “Fo̱ gye̱ Yudaanyi ne̱e̱, ne̱ mo̱‑ɔ n gye̱ Samariyanyi, ne̱ e̱me̱ne̱ se̱ ne̱ fo̱ e̱ tɔwe̱ fe̱yɛ n sa fo̱ nkyu a fo̱ nuu?” Ke̱tɔ se̱ ne̱ ɔkye̱e̱‑ɔ a tɔwe̱ amo̱‑ɔ e̱ gye̱ fe̱yɛ Yudaa awuye na Samariya awuye mɔ maa nuu ato̱re̱nkyu ko̱ŋko̱‑rɔ. Ane̱ŋ dɛɛ ne̱ bo̱ maa gyi e̱gyare̱ ko̱ŋko̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","To, ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Fo̱ dɛɛ fo̱ nyi ke̱tɔ timaa ne̱ Wuribware̱ e̱ waa a ɔ sa fo̱‑ɔ ne̱e̱, bɛɛɛ fo̱ dɛɛ fo̱ nyi mò̱ ne̱ ɔ yɛ fo̱ sa mò̱ nkyu‑o ne̱e̱‑ɔ, weetee fo̱ de a fo̱ tɔwe̱ gywii mò̱ fe̱yɛ ɔ sa fo̱ nkyu, na ɔ sa fo̱ nkyu ne̱ n sa ŋkpa ne̱ m maa lo̱we̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Yeesuu a tɔwe̱ amo̱‑ɔ, ne̱ ɔkye̱e̱‑ɔ a tɔwe̱ gywii mò̱ fe̱yɛ, “Mo̱ nyaŋpe̱, fo̱ mo̱ŋ de atɔ a fo̱ bo̱ saa nkyu‑o, ne̱ kitiribu‑o mɔ bo̱ keŋ. Ne̱ mfe̱ne̱ ne̱ fo̱ e̱ nya nkyu mɔ ne̱ n sa ŋkpa ne̱ m maa lo̱we̱‑ɔ a fo̱ le̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Fo̱ nyi fe̱yɛ fo̱ kyɔ ane̱ nana Yakubu aaa? Mò̱ e̱ gye̱ ne̱ ɔɔ taa kitiribu mɔ sa ane̱. Ne̱ mò̱ fɔŋfɔŋ na mò̱ gyi‑ana na mò̱ mbo̱ a nuu ke̱mo̱ nkyu‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Ɔke̱maa ne̱ o nuu nkyu mɔ‑ɔ, burufo be̱e̱ ɔ nya mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Amaa ɔke̱maa ne̱ o nuu nkyu ne̱ mo̱ e̱ sa mò̱‑ɔ fe̱raa, burufo maa lɛɛ nya mò̱ pɛɛɛ. Nkyu ne̱ mo̱ e̱ sa mò̱‑ɔ i sii mò̱ e̱ye̱e̱‑rɔ ne̱e̱ fe̱yɛ kabo̱ŋgyi ne̱ ka sa nkyu ne̱ m maa lo̱we̱‑ɔ. Ane̱ŋ a nkyu mɔ e̱ gye̱ ne̱ n sa mò̱ ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ne̱ ɔkye̱e̱‑ɔ yɛ, “Mo̱ nyaŋpe̱, sa mo̱ nkyu amo̱, na burufo maa lɛɛ nya mo̱ pɛɛɛ. N gye̱ ane̱ŋ, mo̱ e̱ de̱e̱ ba mfe̱e̱ a m bo̱ saa nkyu.” ");
INSERT INTO ncuNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ne̱ Yeesuu a tɔwe̱ gywii ɔkye̱e̱‑ɔ fe̱yɛ, “Nare̱ ya te̱e̱ fo̱ kuri, na fo̱ kiŋŋi ba mfe̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","18","Ne̱ ɔkye̱e̱‑ɔ yɛ, “Mo̱ŋ de kuri.” Ne̱ Yeesuu a be̱ŋŋaa mò̱ fe̱yɛ, “Fo̱ mo̱ŋ fo̱ kpa fe̱yɛ fo̱ a tɔwe̱ fe̱yɛ fo̱ mo̱ŋ de kuri, a le̱e̱ fe̱yɛ fo̱ a waare̱e̱ anyare̱ anuu, amaa ɔnyare̱ ne̱ fo̱ te mò̱ aye̱ mbe̱yɔmɔ‑ɔ mo̱ŋ gye̱ fo̱ kuri kase̱ŋtiŋ. Amo̱se̱‑ɔ kase̱ŋtiŋ ne̱ fo̱ a tɔwe̱ gywii mo̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ne̱ ɔkye̱e̱‑ɔ yɛ, “Mo̱ nyaŋpe̱, mo̱ a ŋu fe̱yɛ fo̱ gye̱ Wuribware̱ a akyaamɛɛ‑ɔ ɔko̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","To, amo̱ e̱ gye̱ fe̱yɛ fo̱ nyi Wuribware̱ mfɛɛre̱‑ɔ se̱‑ɔ, fo̱ e̱ taare̱ a fo̱ gyi ase̱ŋ ne̱ aa ba ane̱ Samariya awuye na mo̱ne̱ Yudaa awuye mbo̱ŋtɔ‑rɔ hare̱e̱ le̱e̱ de̱daa‑ɔ, na fo̱ tɔwe̱. Hare̱e̱ le̱e̱ ane̱ ade̱daapo̱ a mbe̱e̱‑ɔ se̱ ne̱ ane̱ Samariya awuye a le̱e̱ suŋ Wuribware̱ ke̱be̱e̱ mɔ se̱, amaa mo̱ne̱ Yudaa awuye fe̱raa yɛ Yɛro̱salɛm maŋ e̱ gye̱ mfe̱ŋ ne̱ ase̱sɛ suŋ Wuribware̱‑ɔ. Nsɛ‑ana lee e̱ bo̱ kɔne̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Ɔpe̱kye̱e̱, kɔɔre̱ mo̱ gyi fe̱yɛ saŋ ko̱ e̱ ba, ne̱ ɔko̱ maa lɛɛ suŋ Wuribware̱ ke̱be̱e̱ mɔ se̱ bɛɛɛ Yɛro̱salɛm maŋ‑nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mo̱ne̱ Samariya awuye mo̱ŋ nyi mò̱ ne̱ mo̱ne̱ i suŋ‑o, amaa ane̱ Yudaa awuye fe̱raa nyi mò̱ ne̱ ane̱ i suŋ‑o, a le̱e̱ fe̱yɛ Yudaa awuye‑ro ne̱ ɔko̱ ne̱ ɔ mo̱rɔwe̱ ase̱sɛ‑ɔ e̱ le̱e̱ a ɔ ba. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","24","N gye̱ mfe̱ŋ ne̱ ase̱sɛ i suŋ Wuribware̱‑ɔ i tiri, amaa kpa suyo ne̱ bo̱ gya se̱ ba suŋ mò̱‑ɔ i tiri. Saŋ e̱ ba, ɔɔ tɔ‑rɔ e̱ba fe̱yɛ ase̱sɛ i suŋ Wuribware̱ to̱ŋ ke̱maa ne̱ bo̱ bo̱‑ɔ. Amaa ke̱bware̱suŋ ne̱ Wuribware̱ e̱ kpa a ɔ le̱e̱ bamo̱ ase̱‑ɔ e̱ gye̱ fe̱yɛ bo̱ ba ŋkpo̱nɔfwiiri na mfɛɛre̱ kpe̱yaa bo̱ suŋ mò̱, a le̱e̱ fe̱yɛ, Wuribware̱ a gye̱ kufwiiŋe‑o si‑o, ɔ kaapo̱ ane̱ dimaadi bo̱ suŋ mò̱ ane̱ŋ ne̱ o du‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ne̱ ɔkye̱e̱‑ɔ a tɔwe̱ gywii mò̱ fe̱yɛ, “Ŋ nyi fe̱yɛ Masiya ne̱ ba te̱e̱ ɛ Kristoo‑o e̱ ba. Mò̱ ya ba, ɔ tɔwe̱ ke̱tɔ ke̱maa a o gywii ane̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Mo̱ e̱ gye̱ mò̱, mo̱ e̱ sa se̱ŋsa fo̱ ase̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Saŋ ne̱ ba sa se̱ŋsa‑ɔ, ne̱ Yeesuu agyase̱po̱‑ɔ a ba, ne̱ aa kpe̱ŋ bamo̱ e̱ye̱e̱ fe̱yɛ ɔɔ sa se̱ŋsa ɔkye̱e̱ ase̱. Amaa bamo̱ ɔko̱ mo̱ŋ bise ɔkye̱e̱‑ɔ fe̱yɛ, “Ntɔ ya waa?”, ne̱ bo̱ mo̱ŋ bise Yeesuu mɔ fe̱yɛ, “E̱me̱ne̱ ne̱e̱ ne̱ fo̱ e̱ sa se̱ŋsa fo̱ i gywii ɔkye̱e̱ amo̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ne̱ ɔkye̱e̱ amo̱ a yɔwe̱ mò̱ nkyu na kalɔ bo̱ ye̱ra, ne̱ oo kiŋŋi yɔ maŋ‑nɔ ya tɔwe̱ gywii ase̱sɛ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mo̱nꞌ ba bo̱ ke̱e̱ ɔnyare̱ ko̱ ne̱ ɔɔ tɔwe̱ ke̱tɔ ke̱maa ne̱ mo̱ a dɛɛ waa‑ɔ gywii mo̱‑ɔ ooo. N gye̱ Kristoo ne̱e̱ e̱e̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ne̱ bamo̱ pɛɛɛ a kpɔwe̱ le̱e̱ maŋ‑ɔ‑rɔ a bo̱ ya de̱e̱re̱ Yeesuu. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ɔkye̱e̱ amo̱ a yii maŋ‑nɔ‑ɔ, ne̱ Yeesuu agyase̱po̱‑ɔ a ko̱re̱ mò̱ fe̱yɛ, “Ɔkaapo̱po̱, kɔɔre̱ ateese gyi.” ");
INSERT INTO ncuNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “N de ateese ne̱ mo̱ i gyi, ne̱ mo̱ne̱ mo̱ŋ nyi amo̱ ase̱ŋ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ne̱ mò̱ agyase̱po̱‑ɔ a kii ba bise abɛɛ fe̱yɛ, “Ɔko̱ a baa mò̱ ateese ne̱e̱ bɛɛɛ?” ");
INSERT INTO ncuNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ ateese e̱ gye̱ fe̱yɛ ŋ waa ke̱tɔ ne̱ mò̱ ne̱ oo suŋ mo̱ bo̱ kyo̱ŋwe̱ kaye̱ mɔ‑rɔ‑ɔ e̱ kpa‑ɔ, na n lo̱we̱ asuŋ ke̱maa ne̱ ɔɔ sa mo̱ a ŋ waa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mo̱ne̱ ya tɔwe̱ fe̱yɛ, ‘A saŋ aferi ana pwɛɛ na yaabraa ke̱te̱ŋŋe̱be̱e̱ dɛɛ fo̱,’ mo̱‑ɔ mɔ mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ mo̱nꞌ yase̱ akatɔ de̱e̱re̱ bo̱ kyo̱ŋwe̱ adɔɔ‑rɔ a mo̱nꞌ ke̱e̱. Yaabraa a fo̱ e̱te̱ŋŋe̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mò̱ ne̱ ɔ te̱ŋŋe̱ na o swii yaabraa mɔ bo̱ tii abɛɛ se̱ a ɔ sa mo̱‑ɔ e̱ nya kakɔka, a le̱e̱ fe̱yɛ yaabraa amo̱ gye̱ ase̱sɛ ne̱ ba nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ. Amo̱se̱‑ɔ odwiipo̱‑ɔ na ɔte̱ŋŋe̱po̱‑ɔ pɛɛɛ akatɔ i gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ke̱kpare̱ mɔ gye̱ kase̱ŋtiŋ ne̱e̱ fe̱yɛ, ‘Ɔko̱ e̱ gye̱ ne̱ o dwii, ne̱ ɔko̱ mɔ e̱ kpa.’ ");
INSERT INTO ncuNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mo̱ a suŋ mo̱ne̱ ne̱e̱ fe̱yɛ mo̱nꞌ ya swii yaabraa ne̱ mo̱ne̱ mo̱ŋ dwii, ne̱ mo̱ne̱ mo̱ŋ dɔɔ‑rɔ‑ɔ, bo̱ tii abɛɛ se̱. Bo̱ko̱ ya kyɔ dwii yaabraa‑ɔ dɔɔ‑rɔ, amaa mo̱ne̱ ya kɔɔre̱ bamo̱ kakɔka ne̱ ba ka a bo̱ nya‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ne̱ Samariya awuye bwe̱e̱tɔ ne̱ bo̱ bo̱ maŋ amo̱‑rɔ‑ɔ a kɔɔre̱ Yeesuu gyi bo̱ le̱e̱ ane̱ŋ ne̱ ɔkye̱e̱ amo̱ a tɔwe̱ gywii bamo̱ fe̱yɛ Yeesuu a tɔwe̱ ke̱tɔ ke̱maa ne̱ mò̱, ɔkye̱e̱‑ɔ, a dɛɛ waa‑ɔ gywii mò̱‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Amo̱se̱‑ɔ Samariya awuye‑o a ba mò̱ ase̱‑ɔ, ne̱ baa ko̱re̱ mò̱ fe̱yɛ ɔ ba bo̱ kye̱na bamo̱ ase̱. Ne̱ Yeesuu a kye̱na bamo̱ ase̱ ŋke ŋnyɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ase̱ŋ ne̱ ɔɔ tɔwe̱ gywii bamo̱‑ɔ se̱, ase̱sɛ bwe̱e̱tɔ a be̱e̱ kɔɔre̱ mò̱ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ne̱ baa tɔwe̱ gywii ɔkye̱e̱‑ɔ fe̱yɛ, “Mbe̱yɔmɔ fe̱raa ane̱ a kɔɔre̱ gyi. N gye̱ ane̱ŋ ne̱ fo̱ a tɔwe̱‑ɔ se̱ ne̱ ane̱ a kɔɔre̱ gyi, amaa ane̱ŋ ne̱ ane̱ fɔŋfɔŋ a nu ane̱ŋ ne̱ ɔɔ tɔwe̱‑ɔ se̱. Ane̱ nyi fe̱yɛ mò̱ e̱ gye̱ kaye̱ mɔ‑rɔ a ase̱sɛ‑ɔ ɔmo̱rɔwe̱po̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yeesuu a gyi ŋke ŋnyɔ mfe̱ŋ‑ɔ, ne̱ ɔɔ le̱e̱ mfe̱ŋ yɔ Galile̱ya swe̱e̱re̱ se̱, ");
INSERT INTO ncuNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","a le̱e̱ fe̱yɛ Yeesuu fɔŋfɔŋ a tɔwe̱ fe̱yɛ, “Wuribware̱ kyaamɛɛ ke̱maa, bo̱ maa bu mò̱ mò̱ aye̱ fe̱yɛ to̱ŋ ko̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Mò̱ a fo̱ Galile̱ya swe̱e̱re̱ se̱‑ɔ, ase̱sɛ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ a kɔɔre̱ mò̱ gyi, a le̱e̱ fe̱yɛ, saŋ ne̱ baa yɔ Yɛro̱salɛm ya gyi Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese‑o mfe̱ŋ‑ɔ, baa ŋu ke̱tɔ ke̱maa ne̱ ɔɔ waa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ne̱ oo kiŋŋi ba Kana maŋ ne̱ ɔ bo̱ Galile̱ya swe̱e̱re̱ se̱‑ɔ‑rɔ mfe̱ŋ ne̱ ɔɔ dɛɛ ba nkyu bo̱ buruwi nta‑ɔ. Saŋ amo̱‑ɔ ɔbre̱sɛ ko̱ bo̱‑rɔ ne̱ ɔɔ le̱e̱ Kapaaniyum, mfe̱ŋ ne̱ mò̱ gyi nyaŋsɛ e̱ lɔ‑ɔ. Ɔnyare̱ mɔ e̱ waa asuŋ ɔ sa owure ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mò̱ a nu fe̱yɛ Yeesuu a le̱e̱ Yude̱ya ba Galile̱ya‑ɔ, ne̱ ɔɔ yɔ mò̱ ase̱ ya ko̱re̱ mò̱ fe̱yɛ ɔ sa a bo̱ yɔ Kapaaniyum maŋ‑nɔ na ɔ ya kya mò̱ gyi ne̱ ɔ lɔ ɔ kpa a o wu‑o sa mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Mo̱ne̱ ɔke̱maa maa kɔɔre̱ mo̱ o gyi, amɔ oo ŋu atɔ dabe̱ na akpe̱ŋe̱ye̱e̱tɔ ne̱ mo̱ e̱ waa‑ɔ pwɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ne̱ ɔbre̱sɛ‑ɔ yɛ, “Mo̱ nyaŋpe̱, ba a ane̱ yɔ pwɛɛ na mo̱ gyi‑o dɛɛ wu.” ");
INSERT INTO ncuNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Nare̱, fo̱ gyi‑o e̱ kpaare̱.” Ne̱ ɔbre̱sɛ‑ɔ a kɔɔre̱ ke̱tɔ ne̱ Yeesuu a tɔwe̱‑ɔ gyi, ne̱ oo kiŋŋi ɔ yɔ pe̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mò̱ a kiŋŋi ɔ yɔ pe̱‑ɔ, ne̱ mò̱ ayaafɔre̱ a gyaŋŋaa mò̱ tɔwe̱ gywii mò̱ fe̱yɛ, “Fo̱ gyi‑o maa se̱ ɔ kpaare̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ne̱ oo bise bamo̱ saŋ ko̱ŋko̱ ne̱ mò̱ gyi amo̱ a ko̱lɔ‑ɔ a bɔ‑ɔ. Ne̱ baa be̱ŋŋaa mò̱ fe̱yɛ, “Ndee mpase̱ ne̱ aŋuafwii amo̱ a yɔwe̱ mò̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ne̱ kayaagyi‑o mò̱ se̱ a nyiŋŋi si fe̱yɛ saŋ ko̱ŋko̱ amo̱ dɛɛ ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ mò̱ gyi‑o e̱ kpaare̱‑ɔ ne̱e̱. Ane̱ŋ se̱‑ɔ, ne̱ mò̱ aa mò̱ ase̱sɛ pɛɛɛ a kɔɔre̱ Yeesuu gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Amo̱‑ɔ e̱ gye̱ atɔ dabe̱ nyɔse̱po̱ ne̱ Yeesuu a waa le̱e̱ saŋ ne̱ ɔɔ le̱e̱ Yude̱ya swe̱e̱re̱ se̱ ba Galile̱ya swe̱e̱re̱ se̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Amo̱‑ɔ pɛɛɛ kamɛɛ‑ɔ, ne̱ Yeesuu a yɔ Yɛro̱salɛm maŋ‑nɔ, a le̱e̱ fe̱yɛ saŋ amo̱‑ɔ Yudaa awuye de kigyibe̱e̱ ko̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ke̱pare̱ ko̱ mɔ bo̱ Yɛro̱salɛm maŋ‑nɔ, ne̱ ki de nkyu, ke̱ maa kideŋbee ne̱ baa pwɛɛ bo̱ muruwaa maŋ‑ɔ kibunogyi ko̱ ne̱ ba te̱e̱ ke̱mo̱ ɛ E̱sanne̱ Kibunogyi‑o. Yudaa awuye e̱ te̱e̱ nkyu amo̱ ne̱e̱ fe̱yɛ Bɛtɛsada. Ki de abraŋdaye̱ anuu bo̱ muruwaa ke̱mo̱ pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Abraŋdaye̱‑ɔ‑rɔ ne̱ ate̱napo̱ na agyabɔɔ na bamo̱ ne̱ bamo̱ ayaa na asare̱e̱ a wu, ne̱ bo̱ maa taare̱ a bo̱ nare̱‑ɔ pɛɛɛ da bo̱ gywii saŋ ne̱ Wuribware̱ kabɔɔ e̱ ba a ɔ bo̱ wure nkyu‑o‑ro‑o. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ke̱tɔ se̱ ne̱ bo̱ gywii ke̱pare̱‑ɔ ase̱‑ɔ e̱ gye̱ fe̱yɛ saŋ ko̱ Wuribware̱ kabɔɔ e̱ le̱e̱ so̱so̱ na ɔ bo̱ waa kyuwuri ke̱pare̱‑ɔ‑rɔ. Mò̱ ya waa kyuwuri‑o ane̱ŋ o yii‑o, amɔ alɔpo̱ ne̱ bo̱ da da‑ɔ, mò̱ ne̱ ɔ gye̱ ŋkpɛɛ ya lwee nkyu‑o‑ro‑o, amɔ mò̱ ko̱lɔgyi ke̱maa ne̱ ɔ lɔ‑ɔ a lo̱we̱ puri amo̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Saŋ amo̱ ɔnyare̱ ko̱ mɔ da mfe̱ŋ dɛɛ, ne̱ ɔɔ lɔ nsu adusa na mburuwa. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yeesuu a ŋu mò̱‑ɔ, ne̱ ɔɔ kyɔ pini fe̱yɛ oo di mfe̱ŋ kyee, ne̱ oo bise mò̱ fe̱yɛ, “Fo̱ e̱ kpa fe̱yɛ fo̱ kpaare̱ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ne̱ ɔlɔpo̱‑ɔ a lee kanɔ fe̱yɛ, “Mo̱ nyaŋpe̱, Wuribware̱ kabɔɔ‑ɔ ya bo̱ waa kyuwuri nkyu‑o‑ro lo̱we̱, mo̱ŋ de ɔko̱ ne̱ ɔ taa mo̱ a ɔ bo̱ waa nkyu‑o‑ro‑o. Amaa mo̱ fɔŋfɔŋ e̱ maa se̱ mo̱ e̱ yɔ, amɔ ɔko̱ a bo̱ kyo̱ŋ mo̱ se̱ gye̱ ŋkpɛɛ ya lwee nkyu‑o‑ro.” ");
INSERT INTO ncuNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Ko̱so̱, taa fo̱ kraŋ na fo̱ nare̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Puri amo̱‑rɔ ne̱ ɔɔ kpaare̱, ne̱ ɔɔ taa mò̱ kraŋ, ne̱ ɔɔ nare̱ o yii. Kake nsi amo̱ mɔ gye̱ kukyure kake. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ne̱ Yudaa awuye abre̱sɛ ko̱ a tɔwe̱ gywii ɔnyare̱ ne̱ Yeesuu a kya mò̱‑ɔ fe̱yɛ, “Ndɔɔ gye̱ kukyure kake, amo̱se̱ se̱‑ɔ fo̱ mo̱ŋ de kpa fe̱yɛ fo̱ so̱rɔ kraŋ kake mɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Ɔnyare̱ ne̱ ɔɔ kya mo̱‑ɔ ya tɔwe̱ gywii mo̱ fe̱yɛ, ‘Taa fo̱ kraŋ na fo̱ nare̱.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ne̱ baa bise mò̱ fe̱yɛ, “Nsɛ ya tɔwe̱ gywii fo̱ fe̱yɛ, ‘Ko̱so̱ taa fo̱ kraŋ na fo̱ nare̱’?” ");
INSERT INTO ncuNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Amaa ɔnyare̱ ne̱ Yeesuu a kya mò̱‑ɔ mo̱ŋ nyi mò̱ ne̱ ɔɔ kya mò̱‑ɔ, a le̱e̱ fe̱yɛ, ase̱sɛ a kyɔ mfe̱ŋ bwe̱e̱tɔ se̱‑ɔ, Yeesuu a le̱e̱ o yii. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Amo̱ kamɛɛ‑rɔ‑ɔ, ne̱ Yeesuu a ŋu mò̱ Wuribware̱ suŋkpa‑ɔ, ne̱ ɔɔ tɔwe̱ gywii mò̱ fe̱yɛ, “Mbe̱yɔmɔ fo̱ a kpaare̱, amo̱se̱ se̱‑ɔ yɔwe̱ e̱bɔye̱ ko̱waa. N gye̱ ane̱ŋ, ko̱tɔko̱ e̱ waa fo̱ na ko̱ kyɔ ke̱mo̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ne̱ ɔnyare̱ amo̱ a le̱e̱ mfe̱ŋ ya tɔwe̱ gywii Yudaa awuye amo̱ fe̱yɛ Yeesuu ya kya mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ane̱ŋ se̱‑ɔ, bo̱ le̱e̱ ane̱ŋ ne̱ Yeesuu a kya ɔko̱ kukyure kake‑o si, ne̱ baa le̱e̱ ba tɔɔraa mò̱ bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “N se̱ i suŋ asuŋ saŋ ke̱maa, amo̱se̱ se̱‑ɔ mo̱‑ɔ mo̱ i suŋ saŋ ke̱maa.” ");
INSERT INTO ncuNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ase̱ŋ mɔ ne̱ ɔɔ tɔwe̱‑ɔ a sa ne̱ Yudaa awuye abre̱sɛ a pee akatɔ fe̱yɛ bo̱ mɔɔ mò̱. N gye̱ sa ne̱ bo̱ yɛ oo kye bamo̱ mbraa ne̱ ŋ ye̱re̱ bo̱ sa kukyure kake‑o wo̱re̱ ne̱e̱, amaa ɔɔ be̱e̱ tɔwe̱ fe̱yɛ Wuribware̱ e̱ gye̱ mò̱ se̱, amo̱‑ɔ e̱ kaapo̱ fe̱yɛ mò̱ aa Wuribware̱ ta ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ne̱ Yeesuu a kya se̱ ɔ be̱ŋŋaa bamo̱ fe̱yɛ, “Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ mo̱, Wuribware̱ mò̱ gyi‑o, maa taare̱ a ŋ waa ke̱tɔ ke̱maa mo̱ e̱ye̱e̱ se̱. Mo̱ e̱ waa ke̱tɔ ke̱maa ne̱ mo̱ i ŋu fe̱yɛ n se̱ e̱ waa‑ɔ ne̱e̱. Ke̱tɔ ne̱ n se̱ e̱ waa‑ɔ ne̱ ŋ gbaa mo̱ e̱ waa, ");
INSERT INTO ncuNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","a le̱e̱ fe̱yɛ n se̱ e̱ kpa mo̱ ase̱ŋ, ne̱ ɔ kaapo̱ mo̱ ke̱tɔ ke̱maa ne̱ mò̱ fɔŋfɔŋ e̱ waa‑ɔ. N se̱ e̱ kaapo̱ mo̱ atɔ dabe̱ dabe̱ a ŋ waa na a kyɔ amo̱‑ɔ, na a kpe̱ŋ mo̱ne̱ pɛɛɛ e̱ye̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Fe̱yɛ ane̱ŋ ne̱ Wuribware̱ i kyiŋŋi bamo̱ ne̱ baa wu‑o, na ɔ be̱e̱ sa bamo̱ ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ, ane̱ŋ dɛɛ ne̱ mo̱, mò̱ gyi‑o, i kyiŋŋi ɔke̱maa ne̱ ɔ pre̱ mo̱‑ɔ a n le̱e̱ lowi‑ro, na n sa mò̱ ane̱ŋ a ŋkpa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","N se̱ fɔŋfɔŋ maa gyi ase̱ŋ o bu ɔko̱ ke̱pɔ, amaa ɔɔ sa mo̱ kpa na ke̱yaale̱ŋ fe̱yɛ mo̱ e̱ gye̱ ne̱ m bo̱ gyi ase̱ŋ, na m bu ke̱pɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Wuribware̱ a waa amo̱‑ɔ ne̱e̱ a ase̱sɛ pɛɛɛ nya bu mò̱ gyi‑o fe̱yɛ ane̱ŋ ne̱ ba bu mò̱‑ɔ. Amo̱se̱‑ɔ ɔke̱maa ne̱ ɔ maa bu mo̱, Wuribware̱ mò̱ gyi‑o, maa bu Wuribware̱ ne̱ oo suŋ mo̱ bo̱ kyo̱ŋwe̱‑ɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ ɔke̱maa ne̱ o nu mo̱ ase̱ŋ, ne̱ ɔ kɔɔre̱ mò̱ ne̱ oo suŋ mo̱‑ɔ o gyi‑o e̱ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ. Kase̱ŋtiŋ si o de ane̱ŋ a ŋkpa‑ɔ le̱e̱ saŋ ne̱ ɔɔ kɔɔre̱ mò̱ gyi‑o. Wuribware̱ maa bu mò̱ ne̱ ɔɔ kɔɔre̱ mò̱ gyi‑o ke̱pɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ ase̱sɛ ne̱ bo̱ te mbe̱yɔmɔ‑ɔ du ne̱e̱ fe̱yɛ bamo̱ ne̱ baa wu‑o. Amaa saŋ e̱ ba, saŋ amo̱ a kyɔ fo̱ gbaa, fe̱yɛ, bamo̱ ya nu ase̱ŋ ne̱ mo̱, Wuribware̱ mò̱ gyi‑o, e̱ tɔwe̱‑ɔ, ne̱ bamo̱ ya kɔɔre̱ gyi, ba nya ŋkpa po̱pwɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Wuribware̱ e̱ gye̱ ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ kuŋu, ane̱ŋ dɛɛ ne̱ ɔɔ sa ne̱ mo̱, mò̱ gyi‑o, gbaa a kii ŋkpa na kukyure amo̱ kuŋu. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ne̱ ɔɔ sa mo̱, mò̱ gyi‑o, kpa fe̱yɛ n gyi ase̱sɛ ase̱ŋ, na m bu bamo̱ ke̱pɔ bɛɛɛ ke̱be̱ŋ, a le̱e̱ fe̱yɛ n gye̱ dimaadi mò̱ gyi‑o dɛɛ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Amo̱se̱ se̱‑ɔ mo̱ne̱ ma sa a amo̱‑ɔ kpe̱ŋ mo̱ne̱ e̱ye̱e̱. Saŋ ko̱ e̱ ba ne̱ bamo̱ ne̱ baa wu‑o pɛɛɛ i nu mo̱ bo̱re̱, na bo̱ le̱e̱ bamo̱ agye̱raŋta‑rɔ ba, na bo̱ ma lɛɛ wu. Bamo̱ ne̱ baa waa itimaa‑o e̱ nya kukyure, na bamo̱ ne̱ baa waa e̱bɔye̱‑ɔ mɔ kɔɔre̱ bamo̱ ke̱pɔ kakɔka.” ");
INSERT INTO ncuNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Ma taare̱ a ŋ waa ke̱tɔ ke̱maa mo̱ e̱ye̱e̱ se̱. Mo̱ i gyi ase̱ŋ ane̱ŋ ne̱ n se̱ a kaapo̱ mo̱‑ɔ ne̱e̱, amo̱se̱ se̱‑ɔ mo̱ i bu ke̱pɔ bɛɛɛ ke̱be̱ŋ kpa se̱ ne̱e̱. Bo̱ le̱e̱ fe̱yɛ n gye̱ ke̱tɔ ne̱ mo̱ fɔŋfɔŋ e̱ kpa‑ɔ ne̱ mo̱ e̱ waa, amaa ke̱tɔ ne̱ mò̱ ne̱ oo suŋ mo̱‑ɔ e̱ kpa‑ɔ wo̱re̱ ne̱ mo̱ e̱ waa. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Fe̱yɛ ɔko̱ kyɔ ɔ mo̱ŋ gye̱ ŋkpɛɛ bo̱ tɔwe̱ mo̱ ase̱ŋ ne̱e̱, weetee mo̱ a ba mo̱ e̱ tɔwe̱ mɔ‑ɔ, mo̱ne̱ e̱ tɔwe̱ ne̱e̱ fe̱yɛ sɛye̱ mo̱ŋ bo̱‑rɔ ne̱ a kaapo̱ fe̱yɛ a gye̱ kase̱ŋtiŋ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Amaa ɔko̱ dɛɛ ɔ bo̱‑rɔ ne̱ ɔɔ tɔwe̱ mo̱ ase̱ŋ gywii mo̱ne̱, mò̱ e̱ gye̱ Yohanee Osuubɔpo̱‑ɔ. Ŋ nyi fe̱yɛ ane̱ŋ ne̱ ɔɔ tɔwe̱ mo̱ ase̱ŋ‑ɔ mo̱ŋ gye̱ kaye̱ba ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mo̱ne̱ a kyɔ suŋ mbɔɔ bo̱ kyo̱ŋwe̱ Yohanee ase̱ fe̱yɛ bo̱ ya bise mò̱ mo̱ ase̱ŋ. Mò̱‑ɔ mɔ a tɔwe̱ se̱sɛ ne̱ n gye̱‑ɔ gywii mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Amaa n gye̱ se̱sɛ dimaadi ne̱ mo̱ e̱ kpa fe̱yɛ ɔ ye̱re̱ mo̱‑rɔ na mo̱nꞌ ŋu fe̱yɛ mo̱ atɔ ke̱kaapo̱‑ɔ gye̱ kase̱ŋtiŋ ne̱e̱. Mo̱ e̱ tɔwe̱ amo̱‑ɔ ne̱e̱ a Wuribware̱ nya mo̱rɔwe̱ mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohanee dɛɛ o du ne̱e̱ fe̱yɛ fetiri ne̱ ɔko̱ a kyaŋŋe̱, ne̱ ɔ laŋŋe̱‑rɔ bwe̱e̱tɔ‑ɔ. Katiŋ ko̱‑ɔ‑rɔ‑ɔ mo̱ne̱ akatɔ a gyi ane̱ŋ ne̱ mo̱ne̱ a ŋu mò̱ ke̱laŋŋe̱rɔ‑ɔ se̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Amaa n de atɔ ko̱ ne̱ a ye̱re̱ mo̱‑rɔ, ne̱ a ko̱ŋ a kyo̱ŋ ane̱ŋ ne̱ Yohanee ye̱re̱ mo̱‑rɔ‑ɔ, atɔ ne̱ mo̱ e̱ waa‑ɔ e̱ gye̱ atɔ ne̱ n se̱ a sa mo̱ fe̱yɛ ŋ waa‑ɔ. Amo̱ e̱ gye̱ ne̱ a tɔwe̱ mo̱ ase̱ŋ, ne̱ a kaapo̱ fe̱yɛ Wuribware̱ ya suŋ mo̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ne̱ n se̱ Wuribware̱ ne̱ oo suŋ mo̱‑ɔ gbaa a tɔwe̱ mo̱ ase̱ŋ. N gye̱ fe̱yɛ mo̱ e̱ kaapo̱ fe̱yɛ mo̱ne̱ a nu mò̱ bo̱re̱, bɛɛɛ mo̱ne̱ a ŋu mò̱ akatɔ‑rɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","40","Amaa ke̱tɔ ne̱ mo̱ e̱ kaapo̱‑ɔ e̱ gye̱ fe̱yɛ n se̱ Wuribware̱ a sa ne̱ baa kyo̱rɛɛ mo̱ ase̱ŋ bo̱ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ. Ɔɔŋ, wo̱re̱ ko̱ŋko̱‑ɔ dɛɛ‑rɔ ne̱ mo̱ne̱ i suye nɛɛnɛɛ, na mo̱nꞌ nya ŋu ane̱ŋ ne̱ mo̱ne̱ e̱ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ. Amo̱ pɛɛɛ gbaa mo̱ne̱ maa kɔɔre̱ abware̱se̱ŋ‑ɔ mo̱ne̱ i gyi. Ke̱tɔ ne̱ ke̱ e̱ kaapo̱ fe̱yɛ mo̱ne̱ maa kɔɔre̱ amo̱ mo̱ne̱ i gyi‑o e̱ gye̱ fe̱yɛ mo̱ne̱ a kine mo̱ ne̱ Wuribware̱ a suŋ mo̱ne̱ ase̱‑ɔ. A le̱e̱ fe̱yɛ mo̱ne̱ mo̱ŋ tɛɛ ŋu fe̱yɛ abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ baa kyo̱rɛɛ fe̱yɛ Wuribware̱ i suŋ mo̱ mo̱ne̱ ase̱. Mo̱‑ɔ mo̱ e̱ gye̱ ne̱ mo̱ e̱ taare̱ a n sa mo̱ne̱ ŋkpa na kukyure ne̱ mo̱ne̱ i buwi mo̱ne̱ e̱ kpa‑ɔ, amaa mo̱ne̱ a kine. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","To, n gye̱ fe̱yɛ mo̱ e̱ kpa a mo̱nꞌ kyo̱rɔ mo̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Amaa ŋ nyi ase̱sɛ suyo ne̱ mo̱ne̱ gye̱‑ɔ, mo̱ne̱ maa kpa Wuribware̱ mo̱ne̱ ŋkpo̱nɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","N se̱ ke̱yaale̱ŋ‑nɔ ne̱ mo̱ a ba, amaa mo̱ne̱ maa kpa a mo̱nꞌ kɔɔre̱ mo̱ gyi. Amaa ɔko̱ ya ba mò̱ fɔŋfɔŋ ke̱yaale̱ŋ bo̱ ba fe̱raa, mo̱ne̱ e̱ kɔɔre̱ mò̱ a mo̱nꞌ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mo̱ne̱ e̱ kpa fe̱yɛ mo̱nꞌ de̱e̱ kyo̱rɔ abɛɛ, amaa mo̱ne̱ maa kpa fe̱yɛ Wuribware̱ ne̱ mò̱ wo̱re̱ kpeŋ e̱ bo̱‑rɔ‑ɔ kyo̱rɔ mo̱ne̱. Amo̱ e̱ gye̱ ke̱tɔ se̱ ne̱ mo̱ne̱ maa taare̱ a mo̱nꞌ kɔɔre̱ mo̱ ase̱ŋ‑ɔ gyi‑o. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mo̱ne̱ ma kaŋ fa fe̱yɛ mo̱ e̱ gye̱ ne̱ mo̱ e̱ tɔwe̱ mo̱ne̱ kuŋu si e̱bɔye̱ a n gywii n se̱. Wuribware̱ mbraa wo̱re̱ ne̱ ane̱ ɔde̱daapo̱ Mosis a kyo̱rɛɛ‑ɔ ne̱ mo̱ne̱ a taa mo̱ne̱ te̱maa pɛɛɛ bo̱ dɔŋŋɔ se̱‑ɔ e̱ gye̱ ne̱ ɔ po̱rɔ mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mo̱ne̱ a dɛɛ kɔɔre̱ Mosis gyi ne̱e̱‑ɔ, weetee mo̱ne̱ a kyɔ kɔɔre̱ ŋ gbaa mo̱ gyi, a le̱e̱ fe̱yɛ mò̱ ya kyo̱rɛɛ mo̱ ase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Amaa mo̱ne̱ a mo̱ŋ kɔɔre̱ ke̱tɔ ne̱ Mosis a kyo̱rɛɛ‑ɔ gyi‑o si‑o, mo̱ne̱ maa taare̱ a mo̱nꞌ kɔɔre̱ ke̱tɔ ne̱ mo̱ e̱ tɔwe̱‑ɔ gyi.” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Amo̱ kamɛɛ ne̱ Yeesuu a ya te̱ŋ Galile̱ya ke̱pare̱ dabe̱‑ɔ‑rɔ. Ke̱pare̱ dabe̱ mɔ dɛɛ ne̱ ba te̱e̱ ɛ Tibeeriyas. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ne̱ ase̱sɛ biribiri a kpɔwe̱ gya mò̱ se̱, a le̱e̱ fe̱yɛ baa ŋu mò̱ akpe̱ŋe̱ye̱e̱tɔ ne̱ ɔɔ waa bo̱ kya ase̱sɛ ne̱ ba lɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ne̱ Yeesuu na mò̱ agyase̱po̱‑ɔ a de̱e̱ ke̱be̱e̱ ko̱ kafwe̱e̱ ya kye̱na ba kyure. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Saŋ ne̱ Yudaa awuye i gyi Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese‑o a tɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ne̱ Yeesuu a de̱e̱re̱ muruwaa, ne̱ oo ŋu fe̱yɛ ase̱sɛ biribiri e̱ ba mò̱ ase̱. Amo̱se̱ se̱‑ɔ ne̱ oo bise Filipo fe̱yɛ, “Mfe̱ne̱ ne̱ ane̱ e̱ bo̱rɔ a ane̱ nya ateese ne̱ a fo̱ ase̱sɛ de̱maŋte̱ mɔ, na ane̱ sɔɔ sa bamo̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yeesuu a tɔwe̱ amo̱‑ɔ ne̱e̱ a ɔ bo̱ kyɔ Filipo‑ro ke̱e̱. Kase̱ŋtiŋ si mò̱‑ɔ mɔ kyɔ o nyi ane̱ŋ ne̱ ɔ waa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ne̱ Filipo a tɔwe̱ gywii mò̱ fe̱yɛ, “Hare̱e̱ ɔke̱maa e̱ nya mbe̱gyɛɛ mbe̱gyɛɛ gbaa, bamo̱ ya ba siidii ŋkpe̱ŋ ŋnyɔ (GHC 2,000) bo̱ sɔɔ bodobodoo, ɔ maa fo̱ bamo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ne̱ mò̱ agyase̱po̱‑ɔ ɔko̱ ne̱ ba te̱e̱ mò̱ ɛ Andruu, ne̱ ɔ gye̱ Simɔŋ Peetroo mò̱ tire‑o yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kanyaŋsɛɛ ko̱ e̱ gye̱ ne̱ ɔ bo̱ mfe̱e̱ ne̱ o de bodobodoo agyi anuu na ŋkiŋgyi ngyingyii ŋnyɔ‑ɔ. Amo̱‑ɔ e̱ fo̱ ase̱sɛ de̱maŋte̱ mɔ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ne̱ Yeesuu a tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Mo̱nꞌ sa a ase̱sɛ‑ɔ kye̱na.” E̱fa mɔ bo̱ mfe̱ŋ bwe̱e̱tɔ. Ne̱ ase̱sɛ a kye̱na kye̱na e̱fa‑ɔ se̱. Fo̱ ya kare̱ anyare̱ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ wo̱re̱ bo̱ bo̱ ŋkpe̱ŋ nnuu. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ne̱ Yeesuu a taa bodobodoo‑o, ne̱ ɔɔ sa Wuribware̱ aŋsɛ we̱e̱ se̱, ne̱ oo ke‑ro sa ase̱sɛ ne̱ bo̱ te mfe̱ŋ‑ɔ. Ane̱ŋ dɛɛ ne̱ ɔɔ waa ŋkiŋgyi‑o mɔ. Ne̱ bodobodoo‑o na ŋkiŋgyi‑o a waa ko̱kyɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bamo̱ pɛɛɛ a gyi ane̱ŋ ne̱ ba taare̱‑ɔ. Saŋ ne̱ baa gyi kpo̱ne̱‑ɔ, ne̱ Yeesuu a tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Mo̱nꞌ swii mpupuriase̱e̱, mo̱ne̱ ma sa a n twe̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ne̱ baa swii bodobodoo mpupuriase̱e̱‑ɔ, ne̱ ŋ ya bo̱rɔ ake kudu anyɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ase̱sɛ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ a ŋu akpe̱ŋe̱ye̱e̱tɔ ne̱ Yeesuu a waa‑ɔ, ne̱ bo̱ yɛ, “Kase̱ŋtiŋ si ɔnyare̱ mɔ gye̱ Wuribware̱ kyaamɛɛ ne̱ ane̱ ɔde̱daapo̱ Mosis yɛ ɔ ba kaye̱ mɔ‑rɔ‑ɔ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yeesuu a nyi fe̱yɛ baa waa siraa a bo̱ bo̱ kra mò̱ ke̱yaale̱ŋ se̱ bo̱ gyi kuwure‑o si‑o, ne̱ ɔ be̱e̱ o yii abe̱e̱‑rɔ mò̱ wo̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ke̱de̱e̱pwɛta a fo̱‑ɔ, ne̱ Yeesuu agyase̱po̱‑ɔ a ba nkyu‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ne̱ baa lwee ko̱re̱e̱‑rɔ, ne̱ baa kiŋŋi yɔ kamɛɛ‑rɔ ya te̱ŋ ke̱pare̱ dabe̱‑ɔ‑rɔ Kapaaniyum a ke̱be̱gya‑ɔ. Kanye a fo̱ na Yeesuu mo̱ŋ tɛɛ ba mò̱ agyase̱po̱‑ɔ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Saŋ amo̱‑ɔ, afwii dabe̱ ko̱ mɔ e̱ waa na a da alaŋkpare̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Mò̱ agyase̱po̱‑ɔ mɔ a pare̱ waa e̱maye̱re̱ e̱sa bo̱ yɔ e̱na‑rɔ‑ɔ, ne̱ baa ŋu Yeesuu naa nkyu si ɔ ba mfe̱ŋ ne̱ ko̱re̱e̱‑ɔ bo̱‑ɔ. Ne̱ kufu a nya bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Mfe̱ŋ ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ ne̱e̱! Mo̱ne̱ ma sa a kufu nya mo̱ne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Mfe̱ŋ ne̱ baa taa mò̱ wɔre̱ se̱ waa ko̱re̱e̱‑ɔ‑rɔ. Bamo̱ a taa mò̱ waa‑rɔ‑ɔ, a mo̱ŋ kyee ne̱ baa daŋ kideŋbe si mfe̱ŋ ne̱ ba yɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kaye̱ ŋke‑o, ase̱sɛ biribiri a ba Galile̱ya ke̱pare̱ dabe̱ a nno̱ŋ a bo̱ŋbe̱‑ɔ ba buwi ba kpa Yeesuu, a le̱e̱ fe̱yɛ ndee baa ŋu ane̱ŋ ne̱ Yeesuu a taa bodobodoo, sa Wuribware̱ aŋsɛ we̱e̱ se̱, ne̱ oo ke‑ro sa ase̱sɛ, ne̱ baa gyi‑o. Amaa bo̱ mo̱ŋ ŋu mò̱ ndɔɔ. Ne̱ baa nyiŋŋi si fe̱yɛ, Yeesuu na mò̱ agyase̱po̱‑ɔ, bamo̱ a pare̱ bo̱ daŋ mfe̱ŋ a kideŋbe‑o si‑o, ko̱re̱e̱ ko̱ŋko̱ wo̱re̱ ne̱ baa bo̱ ba. Ne̱ baa ŋu fe̱yɛ ndɔɔ ko̱re̱e̱‑ɔ mo̱ŋ lɛɛ ɔ bo̱‑rɔ. Ne̱ baa pini fe̱yɛ n gye̱ Yeesuu na mò̱ agyase̱po̱‑ɔ gye̱ ne̱ bo̱ yii, ɔ mo̱ŋ tii bamo̱ se̱ saŋ ne̱ baa yɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","E̱ko̱re̱e̱ ne̱ e̱ ya le̱e̱ Tibeeriyas maŋ‑nɔ‑ɔ e̱ko̱ a bo̱ daŋ mfe̱ŋ ne̱ Yeesuu a sa ne̱ bodobodoo amo̱ a waa ko̱kyɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ase̱sɛ amo̱ a ŋu fe̱yɛ Yeesuu na mò̱ agyase̱po̱‑ɔ mo̱ŋ bo̱‑rɔ‑ɔ, ne̱ baa lwee e̱ko̱re̱e̱‑ɔ‑rɔ yɔ Kapaaniyum maŋ ase̱ ba buwi ba kpa Yeesuu. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ase̱sɛ amo̱ a te̱ŋ ke̱pare̱ dabe̱ amo̱‑ɔ, ne̱ baa ŋu Yeesuu mfe̱ŋ, ne̱ baa bise mò̱ fe̱yɛ, “Ɔkaapo̱po̱, nsaŋ mo̱ ne̱ fo̱ a ba mfe̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ, ke̱tɔ se̱ ne̱ mo̱ne̱ i buwi mo̱ne̱ e̱ kpa mo̱‑ɔ e̱ gye̱ fe̱yɛ mo̱ne̱ a gyi bodobodoo‑o kpo̱ne̱. Amaa n gye̱ sa ne̱ mo̱ne̱ a ŋu akpe̱ŋe̱ye̱e̱tɔ ne̱ mo̱ a waa‑ɔ se̱ ne̱ mo̱ne̱ gya mo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mo̱ne̱ ma tɔɔraa mo̱ne̱ e̱ye̱e̱ suŋ kusuŋ mo̱ne̱ e̱ kpa ateese ne̱ mo̱ne̱ i gyi kaye̱ mɔ‑rɔ, ne̱ a maa kyee na a gyo‑o. Amaa mo̱nꞌ suŋ kusuŋ kpa ateese ne̱ a maa gyo, ne̱ a sa ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ. Ateese mɔ ne̱ a sa ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ, mo̱, dimaadi mò̱ gyi‑o, de a m bo̱ sa mo̱ne̱, a le̱e̱ fe̱yɛ n se̱ Wuribware̱ ya sa mo̱ ane̱ŋ a ke̱yaale̱ŋ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ne̱ baa bise mò̱ fe̱yɛ, “Kusuŋ mo̱ ne̱ ane̱ waa na ke̱ pre̱ Wuribware̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Kusuŋ ne̱ Wuribware̱ e̱ kpa fe̱yɛ mo̱nꞌ waa‑ɔ e̱ gye̱ fe̱yɛ mo̱nꞌ kɔɔre̱ mò̱ ne̱ oo suŋ mò̱ bo̱ kyo̱ŋwe̱‑ɔ gyi.” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ne̱ baa lee kanɔ fe̱yɛ, “Nte̱tɔ ne̱ fo̱ e̱ waa na a kpe̱ŋ ane̱ e̱ye̱e̱, na ane̱ ye̱re̱ ane̱ŋ se̱ bo̱ kɔɔre̱ fo̱ gyi? Tɔwe̱ gywii ane̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Saŋ ne̱ Mosis na ane̱ nana‑ana te kimukee‑ro‑o, baa dɛɛ gyi ateese ne̱ ba te̱e̱ ɛ manaa (kaase̱ e̱ kaapo̱ fe̱yɛ Nte̱tɔ‑ne̱e̱?), fe̱yɛ ane̱ŋ dɛɛ ne̱ baa kyo̱rɛɛ abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ, ‘Ɔɔ sa ne̱ ateese a le̱e̱ so̱so̱ ba kaase̱ ne̱ baa gyi.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “N gye̱ Mosis fɔŋfɔŋ ya sa mo̱ne̱ ateese amo̱. Aa le̱e̱ Wuribware̱ ase̱ ne̱e̱. Na kase̱ŋtiŋ si, ateese amo̱ mo̱ŋ gye̱ ateese ne̱ aa le̱e̱ so̱so̱ ba kaase̱ ne̱ mo̱ e̱ tɔwe̱ amo̱ ase̱ŋ‑ɔ. Amaa n se̱ e̱ gye̱ ne̱ ɔ sa mo̱ne̱ ateese kase̱ŋtiŋ ne̱ aa le̱e̱ Wuribware̱ se̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ateese ne̱ Wuribware̱ e̱ sa mo̱ne̱‑ɔ e̱ gye̱ mò̱ ne̱ oo suŋ le̱e̱ Wuribware̱ se̱ fe̱yɛ ɔ bo̱ sa kaye̱ mɔ‑rɔ a ase̱sɛ‑ɔ ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ne̱ baa tɔwe̱ gywii Yeesuu fe̱yɛ, “Ane̱ nyaŋpe̱, amo̱ fe̱raa, sa ane̱ ateese amo̱ kake ke̱maa.” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ e̱ gye̱ ateese ne̱ a sa ŋkpa na kukyure amo̱‑ɔ. Ɔke̱maa ne̱ ɔ ba mo̱ ase̱‑ɔ, ako̱ŋ maa nya mò̱ pɛɛɛ. Ne̱ ɔke̱maa ne̱ ɔ kɔɔre̱ mo̱ o gyi‑o, burufo maa nya mò̱ pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","To, mbe̱yɔmɔ mo̱ a tɔwe̱ gywii mo̱ne̱ fe̱yɛ mo̱ne̱ a ŋu mo̱, amaa mo̱ne̱ maa kɔɔre̱ mo̱ a mo̱nꞌ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ɔke̱maa ne̱ n se̱ a sa mo̱‑ɔ e̱ ba mo̱ ase̱. Ma gya mò̱ a m bo̱ kyo̱ŋwe̱ daa. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","A le̱e̱ fe̱yɛ, mo̱ŋ le̱e̱ so̱so̱ ba ne̱e̱ a m bo̱ waa mo̱ fɔŋfɔŋ ke̱pre̱ se̱ ko̱tɔko̱, amaa mo̱ a ba ne̱e̱ a m bo̱ waa amo̱ ne̱ a pre̱ mò̱ ne̱ oo suŋ mo̱ bo̱ kyo̱ŋwe̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ke̱tɔ ne̱ mò̱ ne̱ oo suŋ mo̱‑ɔ e̱ kpa‑ɔ e̱ gye̱ fe̱yɛ ase̱sɛ pɛɛɛ ne̱ ɔɔ bo̱ waa mo̱ ke̱sare̱e̱‑rɔ‑ɔ, bamo̱ ɔke̱maa maa kaŋ fo̱ mo̱ se̱, na n kyiŋŋi bamo̱ pɛɛɛ baa ŋkpa‑rɔ kake nsi ne̱ kaye̱ mɔ e̱ gye̱ kɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ke̱tɔ ne̱ n se̱ e̱ kpa‑ɔ e̱ gye̱ fe̱yɛ bamo̱ ɔke̱maa ne̱ ɔ de̱e̱re̱ mo̱, Wuribware̱ mò̱ gyi‑o, ne̱ ɔ kɔɔre̱ mo̱ o gyi‑o e̱ nya ŋkpa na kukyure ne̱ m mo̱ŋ de kɛɛ‑ɔ, na n kyiŋŋi mò̱ le̱e̱ lowi‑ro kake nsi ne̱ kaye̱ mɔ e̱ gye̱ kɛɛ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ne̱ Yudaa awuye abre̱sɛ ne̱ baa nu mò̱ ase̱ŋ‑ɔ iduŋ a fwii, ne̱ baa tɛɛ fe̱yɛ Yeesuu a tɔwe̱ fe̱yɛ, “Mo̱ e̱ gye̱ ateese ne̱ aa le̱e̱ so̱so̱ ba kaase̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ne̱ baa tɔwe̱ fe̱yɛ, “Ɔnyare̱ mɔ, n gye̱ Yo̱sɛf mò̱ gyi ne̱ ba te̱e̱ mò̱ ɛ Yeesuu‑o ne̱e̱ bɛɛɛ? Ane̱ nyi mò̱ se̱ na mò̱ nyi. Ne̱ e̱me̱ne̱ se̱ ne̱ mbe̱yɔmɔ ɔ yɛ ɔɔ le̱e̱ so̱so̱ ba ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Mo̱nꞌ yɔwe̱ ke̱tɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ŋ yɛ ɛɛɛ ɔko̱ maa taare̱ a ɔ ba mo̱ ase̱, amɔ n se̱ ne̱ oo suŋ mo̱ bo̱ kyo̱ŋwe̱‑ɔ a baa mò̱ mo̱ ase̱, na n kyiŋŋi mò̱ a ɔ ba ŋkpa na kukyure‑ro kake ne̱ kaye̱ mɔ e̱ gye̱ kɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Wuribware̱ akyaamɛɛ bo̱ko̱ a kyo̱rɛɛ bo̱ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ, ‘Wuribware̱ e̱ gye̱ ne̱ ɔ kaapo̱ ɔke̱maa.’ Ɔke̱maa ne̱ o nu n se̱ ase̱ŋ, ne̱ o suye a ɔ le̱e̱ mò̱ ase̱‑ɔ e̱ ba mo̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mo̱ne̱ ma fa fe̱yɛ ŋ yɛ ɔko̱ a kyɔ ŋu n se̱, amɔ mo̱ ne̱ mo̱ a le̱e̱ n se̱ ase̱ ba swe̱e̱re̱ mɔ se̱‑ɔ wo̱re̱ ya ŋu mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ, ɔke̱maa ne̱ ɔ kɔɔre̱ mo̱ o gyi‑o e̱ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mo̱ e̱ gye̱ ateese ne̱ a sa ŋkpa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mo̱ne̱ nana‑ana a gyi ateese ne̱ aa le̱e̱ so̱so̱ ba kaase̱ saŋ ne̱ bo̱ te kimukee‑ro‑o, amaa a mo̱ŋ sa ne̱ baa kye̱na nsu pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Amaa ateese kase̱ŋtiŋ ne̱ aa le̱e̱ so̱so̱ ba kaase̱‑ɔ, ane̱ŋ a ateese‑o, ɔke̱maa ne̱ o gyi amo̱‑ɔ maa wu. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mo̱ e̱ gye̱ ateese ne̱ aa le̱e̱ so̱so̱ ba kaase̱‑ɔ. Ɔke̱maa ne̱ o gyi ateese mɔ‑ɔ kakye̱na na kukyure mo̱ŋ de kɛɛ. Ateese ne̱ n de mo̱ e̱ sa mò̱‑ɔ e̱ gye̱ mo̱ ko̱yo̱wɔre̱gyi. N de mo̱ ko̱yo̱wɔre̱gyi mo̱ e̱ sa ase̱sɛ ne̱ bo̱ te kaye̱ mɔ‑rɔ‑ɔ na bo̱ nya nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ne̱ bamo̱ ne̱ baa nu ase̱ŋ ne̱ ɔɔ tɔwe̱‑ɔ iduŋ a fwii, ne̱ bamo̱ wo̱re̱ wo̱re̱ a gyiiri ikii fe̱yɛ, “E̱me̱ne̱ ne̱ ɔnyare̱ mɔ e̱ waa a ɔ taa mò̱ ko̱yo̱wɔre̱gyi sa ane̱ a ane̱ gyi fe̱yɛ ateese?” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ mo̱ne̱ e̱ mo̱ŋ gyi mo̱, dimaadi mò̱ gyi‑o, ko̱yo̱wɔre̱gyi fe̱yɛ ateese‑o, ne̱ mo̱ne̱ e̱ mo̱ŋ nuu mo̱ mbo̱gya, amo̱ fe̱raa mo̱ne̱ maa nya ŋkpa. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ɔke̱maa ne̱ o gyi mo̱ ko̱yo̱wɔre̱gyi fe̱yɛ ateese, ne̱ o nuu mo̱ mbo̱gya‑ɔ de ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ, na n kyiŋŋi mò̱ le̱e̱ lowi‑ro kake ne̱ kaye̱ mɔ e̱ gye̱ kɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","A le̱e̱ fe̱yɛ mo̱ ko̱yo̱wɔre̱gyi e̱ gye̱ ateese kase̱ŋtiŋ‑o, ne̱ mo̱ mbo̱gya mɔ e̱ gye̱ nta kase̱ŋtiŋ‑o. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ɔke̱maa ne̱ o gyi mo̱ ko̱yo̱wɔre̱gyi fe̱yɛ ateese, ne̱ o nuu mo̱ mbo̱gya‑ɔ e̱ kye̱na mo̱ kakpo̱nɔ‑rɔ, na mo̱‑ɔ mɔ n kye̱na mò̱ kakpo̱nɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","N se̱ Wuribware̱ ya suŋ mo̱ bo̱ kyo̱ŋwe̱. Ne̱ mò̱ a ma wu pɛɛɛ‑ɔ se̱‑ɔ, ŋ gbaa n de ŋkpa amo̱ ne̱ o de‑o. Ane̱ŋ dɛɛ ne̱ ɔke̱maa ne̱ o gyi mo̱ ko̱yo̱wɔre̱gyi fe̱yɛ ateese‑o e̱ kye̱na, na ɔ ma wu pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Amo̱‑ɔ e̱ kaapo̱ fe̱yɛ mo̱ ko̱yo̱wɔre̱gyi ne̱ n de‑o e̱ gye̱ ateese ne̱ aa le̱e̱ so̱so̱ ba kaase̱‑ɔ kase̱ŋtiŋ. A mo̱ŋ du ne̱e̱ fe̱yɛ ateese amo̱ ne̱ aa dɛɛ le̱e̱ so̱so̱ ba kaase̱ kimukee amo̱‑rɔ, ne̱ kake ke̱maa ane̱ nana‑ana a swii gyi‑o, a le̱e̱ fe̱yɛ saŋ ko̱ bamo̱ ɔke̱maa a bo̱ wu. Amaa ɔke̱maa ne̱ o gyi ateese ne̱ n de mo̱ e̱ sa mò̱‑ɔ fe̱raa e̱ kye̱na nsu pɛɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Saŋ ne̱ Yeesuu a yɔ ke̱bware̱ko̱re̱kyaŋ ne̱ ke̱ bo̱ Kapaaniyum maŋ‑nɔ‑ɔ ɔ kaapo̱ ke̱mo̱‑rɔ‑ɔ ne̱ ɔɔ tɔwe̱ amo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ase̱sɛ biribiri ne̱ bo̱ gya Yeesuu si‑o bo̱ko̱ a nu amo̱‑ɔ, ne̱ bo̱ yɛ, “Ase̱ŋ mɔ fe̱raa bo̱ le̱ŋ, ɔko̱ maa taare̱ amo̱‑ɔ a ɔ gya se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yeesuu a ŋu fe̱yɛ baa tɛɛ ase̱ŋ amo̱ se̱‑ɔ, ne̱ oo bise bamo̱ fe̱yɛ, “Mo̱ ase̱ŋ mɔ maa nya a a nu ne̱e̱, bɛɛɛ? ");
INSERT INTO ncuNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Fe̱yɛ mo̱ne̱ a ŋu mo̱, dimaadi mò̱ gyi‑o, a yɔ so̱so̱ mfe̱ŋ ne̱ mo̱ a le̱e̱ ba‑ɔ ne̱e̱, weetee e̱me̱ne̱ ne̱ mo̱ne̱ e̱ waa? ");
INSERT INTO ncuNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mo̱ne̱ mo̱ŋ tɛɛ nu kaase̱ fe̱yɛ ase̱ŋkpare̱gyi ne̱ mo̱ a de̱ŋ tɔwe̱ gywii mo̱ne̱‑ɔ gye̱ ke̱kpare̱ ne̱ ke̱mo̱ kaase̱ e̱ gye̱ ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ. N gye̱ se̱sɛ ko̱yo̱wɔre̱gyi ase̱ŋ ne̱ mo̱ e̱ tɔwe̱, amaa mo̱ a kaapo̱ mo̱ne̱ ane̱ŋ ne̱ Wuribware̱ a kufwiiŋe timaa‑o e̱ taare̱ a ɔ sa mo̱ne̱ ane̱ŋ a ŋkpa‑ɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Amo̱ pɛɛɛ gbaa mo̱ne̱ bo̱ko̱ maa kɔɔre̱ mo̱ mo̱ne̱ i gyi.” Ke̱tɔ se̱ ne̱ Yeesuu a tɔwe̱ ane̱ŋ‑ɔ e̱ gye̱ fe̱yɛ ɔ kyɔ o nyi bamo̱ ne̱ bo̱ maa ba a bo̱ bo̱ kɔɔre̱ mò̱ gyi‑o, na mò̱ ne̱ ɔ ba a ɔ bo̱ gyi mò̱ kidiburo‑o. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Mfaanɛɛ se̱ ne̱ mo̱ a tɔwe̱ gywii mo̱ne̱ fe̱yɛ ɔko̱ maa taare̱ a ɔ ba mo̱ ase̱, amɔ n se̱ a sa mò̱ kpa fe̱raa.” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Amo̱‑ɔ se̱‑ɔ, ne̱ ase̱sɛ ne̱ bo̱ gya Yeesuu si‑o bwe̱e̱tɔ a kine mò̱ se̱ ke̱gya. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Amo̱se̱ se̱‑ɔ, ne̱ oo bise mò̱ agyase̱po̱ kudu anyɔ‑ɔ fe̱yɛ, “Amɔ mo̱ne̱ mɔ mo̱ne̱ e̱ kpa ke̱le̱e̱ mo̱ ase̱ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ne̱ Simɔŋ Peetroo a lee kanɔ fe̱yɛ, “Ane̱ nyaŋpe̱, ɔko̱ be̱e̱ ɔ bo̱‑rɔ ne̱ ane̱ gya mò̱ se̱ aaa? Daabii! Ɔko̱ mo̱ŋ bo̱‑rɔ ne̱ ɔ tɔwe̱ ase̱ŋkpare̱gyi ne̱ a kaapo̱ ane̱ ane̱ŋ ne̱ ane̱ e̱ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ, amɔ fo̱ wo̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","A le̱e̱ fe̱yɛ ane̱ saŋ ane̱ e̱ kɔɔre̱ fo̱ ane̱ i gyi, ne̱ ane̱ nyi fe̱yɛ fo̱ e̱ gye̱ ke̱yaafɔre̱ timaa ne̱ Wuribware̱ a lee suŋ bo̱ kyo̱ŋwe̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Mo̱ e̱ gye̱ ne̱ mo̱ a lee mo̱ne̱ abɛɛ kudu anyɔ‑ɔ fe̱yɛ mo̱nꞌ gya mo̱ se̱, bɛɛɛ? Amaa ɔko̱ bo̱ mo̱ne̱‑rɔ ne̱ ɔ gye̱ Ɔbɔnsam mò̱ gyi.” ");
INSERT INTO ncuNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yudas Kariyotinyi ase̱ŋ ne̱ Yeesuu e̱ tɔwe̱‑ɔ. Mò̱ se̱ mɔ e̱ gye̱ Simɔŋ Kariyotinyi. Amaa a bo̱‑rɔ fe̱yɛ Yudas gye̱ Yeesuu agyase̱po̱ kudu anyɔ‑ɔ ɔko̱, ne̱ mò̱‑ɔ mɔ i gyi mò̱ kidiburo. ");
INSERT INTO ncuNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Amo̱‑ɔ pɛɛɛ kamɛɛ‑ɔ, Galile̱ya swe̱e̱re̱ se̱ ne̱ Yeesuu a kya se̱ ɔ naa ɔ kaapo̱, a le̱e̱ fe̱yɛ, mò̱ ya nare̱ Yude̱ya swe̱e̱re̱ se̱, mfe̱ŋ a abre̱sɛ‑ɔ i buwi a bo̱ kpa mò̱ a bo̱ mɔɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ne̱ saŋ a tɔ‑rɔ fe̱yɛ Yudaa awuye gyi Abwii‑ro ke̱kye̱na a kigyibe̱e̱‑ɔ.† ");
INSERT INTO ncuNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ne̱ Yeesuu mò̱ tire‑ana a tɔwe̱ gywii mò̱ fe̱yɛ, “Le̱e̱ mfe̱e̱ yɔ Yude̱ya na fo̱ agyase̱po̱ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ mɔ nya ŋu akpe̱ŋe̱ye̱e̱tɔ ne̱ fo̱ e̱ waa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ɔko̱ ne̱ mò̱ ke̱nyare̱ a de̱e̱‑ɔ mo̱ŋ de ke̱mo̱ ne̱ ɔ waa‑ɔ ɔ kwe̱e̱rɔ. Amo̱se̱‑ɔ fo̱ e̱ taare̱ a fo̱ waa atɔ dabe̱, sa a kaye̱‑rɔ ase̱sɛ pɛɛɛ gyii fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Mò̱ tire‑ana fɔŋfɔŋ gbaa mo̱ŋ kɔɔre̱ mò̱ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ saŋ mo̱ŋ tɛɛ fo̱. Amaa mo̱ne̱ fe̱raa, mo̱ne̱ e̱ taare̱ a mo̱nꞌ yɔ ngyaŋŋe̱‑ɔ‑rɔ saŋ ke̱maa ne̱ mo̱ne̱ e̱ kpa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kaye̱‑rɔ ase̱sɛ maa kisi mo̱ne̱, amaa m fe̱raa, ba kisi mo̱, bo̱ le̱e̱ ane̱ŋ ne̱ mo̱ e̱ tɔwe̱ atɔ ne̱ baa waa ne̱ a gye̱ e̱bɔye̱‑ɔ mo̱ i gywii bamo̱‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mo̱ne̱ fe̱raa, mo̱nꞌ nare̱ ya gyi Abwii‑ro ke̱kye̱na a kigyibe̱e̱‑ɔ. M fe̱raa, ma yɔ, a le̱e̱ fe̱yɛ a mo̱ŋ tɛɛ fo̱ saŋ ne̱ mo̱ e̱ yɔ a ŋ ya gyi ke̱mo̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Mò̱ a tɔwe̱ amo̱‑ɔ, ne̱ ɔɔ kye̱na Galile̱ya swe̱e̱re̱ se̱ ŋke kafwe̱e̱ ko̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Mò̱ tire‑ana a ya gyi Abwii‑ro ke̱kye̱na a kigyibe̱e̱‑ɔ, ne̱ Yeesuu mɔ a yɔ, amaa ɔ mo̱ŋ gya lamaŋ se̱ yɔ, oo ywii yɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ne̱ Yudaa awuye abre̱sɛ‑ɔ i buwi ba kpa mò̱, ne̱ baa bise ngyaŋŋe̱‑ɔ‑rɔ ase̱sɛ fe̱yɛ, “Ŋke̱e̱ mò̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mò̱ ase̱ŋ sooo ne̱ ba ŋwiini lamaŋ‑ɔ‑rɔ. Bamo̱ bo̱ko̱ yɛ, “Ɔ gye̱ se̱sɛ timaa.” Bo̱ko̱ mɔ yɛ, “Daabii! Ɔnyare̱ amo̱ e̱ pe̱nna ase̱sɛ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Amaa ɔko̱ mo̱ŋ taare̱ tɔwe̱ mò̱ kuŋu si ase̱ŋ bo̱ le̱e̱ kawu si, a le̱e̱ fe̱yɛ bo̱ se̱re̱ Yudaa awuye abre̱sɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Amo̱ a fo̱ nse̱na na bo̱ lo̱we̱ kigyibe̱e̱‑ɔ, ne̱ Yeesuu a yɔ Wuribware̱ suŋkpa‑ɔ kabuno ya le̱e̱ ɔ kaapo̱ ase̱sɛ abware̱se̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ne̱ aa kpe̱ŋ Yudaa awuye abre̱sɛ‑ɔ e̱ye̱e̱ bwe̱e̱tɔ, ne̱ baa tɔwe̱ fe̱yɛ, “E̱me̱ne̱ ne̱ ɔnyare̱ mɔ a waa o nyi e̱kaapo̱ faanɛɛ, na ɔ mo̱ŋ nya ke̱kaapo̱ le̱e̱ to̱ŋ ke̱maa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Atɔ mɔ ne̱ mo̱ e̱ kaapo̱‑ɔ mo̱ŋ le̱e̱ mo̱ fɔŋfɔŋ ase̱, amaa aa le̱e̱ mò̱ ne̱ oo suŋ mo̱ bo̱ kyo̱ŋwe̱‑ɔ ase̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ɔke̱maa ne̱ o sure si a ɔ waa ke̱tɔ ne̱ Wuribware̱ e̱ kpa‑ɔ i pini fe̱yɛ ke̱tɔ ne̱ mo̱ e̱ kaapo̱‑ɔ a le̱e̱ Wuribware̱ ase̱ ne̱e̱, bɛɛɛ mo̱ fɔŋfɔŋ ke̱yaale̱ŋ ne̱ n de mo̱ e̱ waa. ");
INSERT INTO ncuNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ɔke̱maa ne̱ ɔ sa se̱ŋsa mò̱ fɔŋfɔŋ ke̱yaale̱ŋ se̱‑ɔ i buwi ɔ kpa ke̱dabe̱ na wuraa a ɔ sa mò̱ e̱ye̱e̱ ne̱e̱. Amaa mò̱ ne̱ ɔ kpa ke̱dabe̱ na wuraa a ɔ sa mò̱ ne̱ oo suŋ mò̱‑ɔ de kase̱ŋtiŋ, ɔ maa ba aye̱ba. ");
INSERT INTO ncuNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mo̱ne̱ e̱ kyo̱rɔ Mosis ne̱ ɔɔ kyo̱rɛɛ Wuribware̱ a mbraa‑ɔ bo̱ sa mo̱ne̱‑ɔ, amaa mo̱ne̱ ko̱ŋko̱ gbaa mo̱ŋ gya mbraa‑ɔ se̱. Ne̱ e̱me̱ne̱ se̱ ne̱ mo̱ne̱ e̱ kpa a mo̱nꞌ mɔɔ mo̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ne̱ lamaŋ‑ɔ a tɔwe̱ gywii mò̱ fe̱yɛ, “Ibrisi te fo̱ se̱. Nsɛ e̱ gye̱ ne̱ ɔ kpa a ɔ mɔɔ fo̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Mo̱ a kya ɔko̱ kukyure kake ne̱e̱, ne̱ aa kpe̱ŋ mo̱ne̱ pɛɛɛ e̱ye̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","To, Mosis a sa mo̱ne̱ Wuribware̱ mbraa ko̱ ne̱ mo̱ne̱ ade̱daapo̱ a kyɔ gya se̱‑ɔ, fe̱yɛ bamo̱ ya ko̱we̱ kagyinyaŋsɛɛ, kake buruwase̱po̱‑ɔ bo̱ te̱ŋ mò̱ ko̱twe̱e̱tu, na kake nsiŋ amo̱ e̱ gye̱ kukyure kake gbaa, bo̱ ma kaŋ yɔwe̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Amo̱se̱ se̱ ne̱ mo̱ne̱ i de kpa fe̱yɛ kukyure kake gbaa mo̱nꞌ te̱ŋ kagyinyaŋsɛɛ ko̱twe̱e̱tu, na mo̱ne̱ ma nya kye Wuribware̱ a mbraa ne̱ Mosis a kyo̱rɛɛ sa mo̱ne̱‑ɔ, ne̱ e̱me̱ne̱ se̱ ne̱ mo̱ne̱ iduŋ a fwii mo̱ se̱ fe̱yɛ mo̱ a kya se̱sɛ kayo̱wɔre̱ mumwii kukyure kake? ");
INSERT INTO ncuNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mo̱ne̱ ma kaŋ fa fe̱yɛ ke̱tɔ ne̱ ɔko̱ e̱ waa‑ɔ gye̱ e̱bɔye̱, amaa mo̱nꞌ de̱e̱re̱ nɛɛnɛɛ ke̱e̱ pwɛɛ, ne̱ mò̱ e̱ waa e̱bɔye̱ ne̱e̱ aaa, itimaa ne̱e̱ aaa, mo̱ne̱ i ŋu.” ");
INSERT INTO ncuNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ase̱sɛ ne̱ bo̱ bo̱ Yɛro̱salɛm maŋ‑nɔ‑ɔ bo̱ko̱ a nu ane̱ŋ ne̱ ɔɔ tɔwe̱‑ɔ, ne̱ bo̱ yɛ, “N gye̱ ɔnyare̱ mɔ ne̱ ane̱ abre̱sɛ e̱ kpa a bo̱ mɔɔ‑ɔ ɔɔɔ? ");
INSERT INTO ncuNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mo̱nꞌ de̱e̱re̱ mò̱ a ye̱re̱ ɔ sa se̱ŋsa lamaŋ‑nɔ, na bo̱ mo̱ŋ tɔwe̱ sɛye̱ bo̱ kye mò̱. Bɛɛɛ aa waa fe̱yɛ baa ŋu ane̱ŋ ne̱ o du‑o, ne̱ baa sure si fe̱yɛ ɔ gye̱ Kristoo kase̱ŋtiŋ aaa? ");
INSERT INTO ncuNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kristoo‑o ya ba, ɔko̱ maa pini mfe̱ŋ ne̱ ɔ le̱e̱ a ɔ ba‑ɔ, amaa ɔnyare̱ mɔ fe̱raa ane̱ nyi mfe̱ŋ ne̱ ɔɔ le̱e̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Saŋ ne̱ Yeesuu bo̱ Wuribware̱ suŋkpa a kabuno‑o ɔ maa se̱ ɔ kaapo̱‑ɔ, oo nu ase̱ŋ ne̱ baa tɔwe̱‑ɔ, ne̱ ɔɔ tɔwe̱ keŋkeŋ fe̱yɛ, “Mo̱ne̱ e̱ fa fe̱yɛ mo̱ne̱ nyi mo̱ na mfe̱ŋ ne̱ mo̱ a le̱e̱‑ɔ ɔɔɔ? N gye̱ mo̱ fɔŋfɔŋ ke̱yaale̱ŋ se̱ ne̱ mo̱ a ba. Mò̱ ne̱ oo suŋ mo̱‑ɔ de kase̱ŋtiŋ, amaa mo̱ne̱ mo̱ŋ nyi mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Amaa m fe̱raa, ŋ nyi mò̱, a le̱e̱ fe̱yɛ mò̱ ase̱ ne̱ mo̱ a le̱e̱, ne̱ mò̱‑ɔ mɔ ya be̱e̱ suŋ mo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ne̱ baa kpa a bo̱ kra Yeesuu, amaa bo̱ mo̱ŋ taare̱ kra mò̱, a le̱e̱ fe̱yɛ mò̱ saŋ mo̱ŋ tɛɛ fo̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Amaa ase̱sɛ‑ɔ bo̱ko̱ a kɔɔre̱ mò̱ gyi, ne̱ baa tɔwe̱ fe̱yɛ, “Kristoo‑o ya ba, ɔ waa atɔ ne̱ a kpe̱ŋ e̱ye̱e̱‑ɔ a ɔ kyo̱ŋ ɔnyare̱ mɔ amo̱‑ɔ ne̱ ɔɔ waa‑ɔ ɔɔɔ?” ");
INSERT INTO ncuNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Saŋ ne̱ Farisii awuye bo̱ko̱ a nu ase̱sɛ‑ɔ i ŋwiini Yeesuu kuŋu si ase̱ŋ mɔ‑ɔ, ne̱ baa sa ne̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ a suŋ Wuribware̱ suŋkpa a ade̱e̱re̱se̱po̱ ko̱ bo̱ kyo̱ŋwe̱ fe̱yɛ bo̱ ya kra Yeesuu. ");
INSERT INTO ncuNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ e̱ kye̱na mo̱ne̱ ase̱ a n kyee kafwe̱e̱ pwɛɛ na n dɛɛ kiŋŋi yɔ mò̱ ne̱ oo suŋ mo̱‑ɔ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mo̱ne̱ saŋ mo̱ne̱ e̱ ba a mo̱nꞌ bo̱ buwi kpa mo̱, na mo̱ne̱ ma lɛɛ ŋu mo̱, a le̱e̱ fe̱yɛ mfe̱ŋ ne̱ mo̱ e̱ yɔ‑ɔ, mo̱ne̱ maa taare̱ a mo̱nꞌ yɔ mfe̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ne̱ Yudaa awuye abre̱sɛ‑ɔ wo̱re̱ wo̱re̱ i bise abɛɛ fe̱yɛ, “Ne̱ mfe̱ne̱ ne̱ ɔ kpa a ɔ yɔ, ne̱ ɔ yɛ ane̱ maa lɛɛ ŋu mò̱‑ɔ ne̱e̱? Amɔ ɔ yɔ Griiki awuye e̱maŋ se̱ a ɔ ya kaapo̱ ane̱ ase̱sɛ ne̱ baa yɔ ya kye̱na mfe̱ŋ‑ɔ na Griiki awuye‑o abware̱se̱ŋ ne̱e̱ e̱e̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ɔ yɛ ane̱ i buwi a ane̱ kpa mò̱, na ane̱ ma ŋu mò̱, na ane̱ ma taare̱ a ane̱ yɔ mfe̱ŋ ne̱ ɔ yɔ‑ɔ. Amɔ kaase̱ e̱ gye̱ e̱me̱ne̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Kigyibe̱e̱‑ɔ kake lalalo̱we̱ ne̱ ka gye̱ kake dabe̱‑ɔ, ne̱ Yeesuu a kyuwi‑ro, ne̱ ɔɔ tɔwe̱ keŋkeŋ fe̱yɛ, “Ɔke̱maa ne̱ burufo de mò̱‑ɔ, ɔ ba mo̱ ase̱ bo̱ nuu nkyu. ");
INSERT INTO ncuNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Fe̱yɛ ane̱ŋ ne̱ baa kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ, ‘Ɔke̱maa ne̱ ɔ kɔɔre̱ mo̱ o gyi‑o, nkyu ne̱ n sa ŋkpa‑ɔ e̱ le̱e̱ mò̱ kakpo̱nɔ‑rɔ fe̱yɛ bo̱ŋ nkyu‑o.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ase̱ŋ ne̱ Yeesuu e̱ tɔwe̱ mfe̱e̱‑ɔ gye̱ Wuribware̱ a kufwiiŋe timaa‑o ase̱ŋ ne̱ bamo̱ ne̱ ba kɔɔre̱ mò̱ a bo̱ gyi‑o e̱ nya‑ɔ ne̱e̱. Amaa saŋ amo̱‑ɔ bo̱ mo̱ŋ tɛɛ nya Wuribware̱ a kufwiiŋe timaa‑o, a le̱e̱ fe̱yɛ Yeesuu mo̱ŋ tɛɛ yɔ Wuribware̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Lamaŋ‑ɔ‑rɔ ase̱sɛ‑ɔ bo̱ko̱ a nu fe̱yɛ ɔɔ tɔwe̱ amo̱‑ɔ, ne̱ bo̱ yɛ, “Kase̱ŋtiŋ si, ɔnyare̱ mɔ gye̱ Wuribware̱ kyaamɛɛ ne̱ Mosis a tɔwe̱ fe̱yɛ ɔ ba‑ɔ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ne̱ bamo̱ bo̱ko̱ mɔ yɛ, “N gye̱ ane̱ŋ ne̱e̱. Mò̱ e̱ gye̱ Kristoo ne̱ Wuribware̱ yɛ o suŋ a ɔ bo̱ kyo̱ŋwe̱‑ɔ.” Amaa bamo̱ bo̱ko̱ yɛ, “N gye̱ Galile̱ya swe̱e̱re̱ se̱ ne̱ Kristoo‑o e̱ le̱e̱, ");
INSERT INTO ncuNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","a le̱e̱ fe̱yɛ baa kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ Kristoo‑o e̱ le̱e̱ Owure Deefid ke̱nana‑rɔ, na Bɛte̱lahɛm maŋ ne̱ baa ko̱we̱ Deefid mò̱‑rɔ‑ɔ‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ne̱ ase̱sɛ‑ɔ a ke‑ro ntuŋ ŋnyɔ ba gyiiri Yeesuu si ikii. ");
INSERT INTO ncuNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ne̱ bamo̱ bo̱ko̱ e̱ kpa a bo̱ kra mò̱, amaa kase̱ŋtiŋ si, bamo̱ ɔko̱ mo̱ŋ dabo̱rɔ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ade̱e̱re̱se̱po̱‑ɔ a kiŋŋi yɔ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na Farisii awuye‑o ase̱‑ɔ, ne̱ baa bise bamo̱ fe̱yɛ, “E̱me̱ne̱ ne̱e̱, ne̱ mo̱ne̱ mo̱ŋ kra mò̱ baa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ne̱ ade̱e̱re̱se̱po̱‑ɔ a lee kanɔ fe̱yɛ, “Ɔko̱ mo̱ŋ tɛɛ tɔwe̱ ase̱ŋ timaa fe̱yɛ ane̱ŋ a ɔnyare̱ mɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ne̱ Farisii awuye‑o a bise ade̱e̱re̱se̱po̱‑ɔ fe̱yɛ, “Amɔ ɔɔ pe̱nna mo̱ne̱ mɔ mo̱ne̱ ne̱e̱ e̱e̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mo̱ne̱ nyi Farisii awuye na maŋ abre̱sɛ ko̱ na baa kɔɔre̱ mò̱ gyi aaa? Mo̱ne̱ e̱ taare̱ a mo̱nꞌ kyii bamo̱ ɔko̱ ke̱nyare̱ aaa? ");
INSERT INTO ncuNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ase̱sɛ laŋgyaŋ mɔ fe̱raa ne̱ baa kɔɔre̱ mò̱ gyi‑o mo̱ŋ nyi Wuribware̱ a mbraa ne̱ Mosis a kyo̱rɛɛ bo̱ be̱ya‑ɔ, amo̱se̱‑ɔ bamo̱ ne̱ Wuribware̱ a da yii. Mo̱ne̱ ma be̱ŋŋaa bamo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ne̱ Farisii awuye ɔbre̱sɛ ko̱ ne̱ ɔɔ dɛɛ bo̱ ŋu Yeesuu kanye ko̱‑ɔ, ne̱ ba te̱e̱ mò̱ ɛ Nikodeemus‑o, a tɔwe̱ gywii mò̱ ko̱so̱bɛɛ‑ana fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ane̱ŋ ne̱ ane̱ mbraa‑ɔ i gyi‑o, ane̱ maa taare̱ a ane̱ bu nyiŋkpasɛ ke̱pɔ na ane̱ mo̱ŋ nu mò̱ kanɔ‑rɔ ase̱ŋ, bɛɛɛ ane̱ mo̱ŋ ŋu ke̱tɔ ne̱ ɔɔ waa‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ne̱ bo̱ yɛ, “To, fo̱ gbaa fo̱ a le̱e̱ Galile̱ya swe̱e̱re̱ se̱ ne̱e̱ e̱e̱e̱? Fo̱ ya suye abware̱se̱ŋ wo̱re̱‑ɔ, fo̱ i ŋu fe̱yɛ Wuribware̱ kyaamɛɛ ko̱ mo̱ŋ tɛɛ le̱e̱ Galile̱ya.” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Amo̱‑ɔ pɛɛɛ kamɛɛ‑ɔ, ne̱ ɔke̱maa yii mò̱ lɔŋ‑nɔ, ne̱ Yeesuu a yɔ Mfɔ-Ayii ke̱be̱e̱‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kaye̱ ŋke‑o, ne̱ Yeesuu a kiŋŋi yɔ Wuribware̱ suŋkpa a kabuno‑o. Ne̱ ase̱sɛ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ pɛɛɛ a kpɔwe̱ muruwaa mò̱, ne̱ ɔɔ kye̱na ɔ kaapo̱ bamo̱ abware̱se̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Mò̱ a bo̱ mfe̱ŋ‑ɔ, ne̱ Wuribware̱ mbraa akaapo̱po̱ na Farisii awuye bo̱ko̱ a baa ɔkye̱e̱ waare̱e̱po̱ ko̱ ne̱ baa kra mò̱ kanyare̱kpa‑rɔ‑ɔ Yeesuu ase̱. Ne̱ baa sa ne̱ ɔɔ ye̱re̱ lamaŋ‑ɔ nse̱na Yeesuu ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ne̱ bo̱ yɛ, “Ɔkaapo̱po̱, ane̱ a kra ɔkye̱e̱ mɔ kanyare̱kpa‑rɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","To, ane̱ŋ ne̱ mbraa ne̱ Wuribware̱ a bo̱rɔ Mosis si sa ane̱‑ɔ e̱ kaapo̱‑ɔ e̱ gye̱ fe̱yɛ ane̱ daye̱ ɔke̱maa ne̱ ɔ waa ane̱ŋ a atɔ‑ɔ abu mɔɔ. Mbe̱yɔmɔ e̱me̱ne̱ ne̱ ane̱ e̱ waa? Ane̱ e̱ kpa a ane̱ nu bo̱ le̱e̱ fo̱ ase̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Baa tɔwe̱ amo̱‑ɔ ne̱e̱, a bo̱ nya nya Yeesuu ke̱bɔye̱, na bo̱ nya po̱rɔ mò̱. Amaa ne̱ oo buŋŋe o de ke̱sare̱e̱gyi ɔ kyo̱rɛɛ swe̱e̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bamo̱ a ye̱re̱ mfe̱ŋ‑ɔ, ne̱ bo̱ maa se̱ ba tɔwe̱ ba gywii mò̱ fe̱yɛ o lee kanɔ me̱naŋ sa bamo̱ na bo̱ ke̱e̱. Ne̱ oo kyuwi‑ro, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ne̱ ɔke̱maa ne̱ ɔ mo̱ŋ tɛɛ waa bɔye̱‑ɔ gye̱ ŋkpɛɛ twe̱e̱ kibu bo̱ da ɔkye̱e̱ mɔ a ŋ ke̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ne̱ ɔɔ be̱e̱ buŋŋe kyo̱rɛɛ swe̱e̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ɔkye̱e̱ a apo̱rɔpo̱‑ɔ a nu amo̱‑ɔ, ne̱ bamo̱ pɛɛɛ a brawe̱‑rɔ ako̱ ako̱ ako̱ ako̱ bo̱ yii. Abre̱sɛ‑ɔ ya gye̱ ŋkpɛɛ pwɛɛ. Ne̱ bamo̱ pɛɛɛ yii yɔwe̱ Yeesuu na ɔkye̱e̱‑ɔ wo̱re̱, na ɔ saŋ ɔ ye̱re̱ lamaŋ‑ɔ akatɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ne̱ Yeesuu a kyuwi‑ro, ne̱ oo bise ɔkye̱e̱‑ɔ fe̱yɛ, “Ŋke̱e̱ bamo̱? Ɔko̱ mo̱ŋ lɛɛ saŋ a o bu fo̱ ke̱pɔ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ne̱ ɔkye̱e̱‑ɔ a lee kanɔ fe̱yɛ, “Mo̱ nyaŋpe̱, ɔko̱ mo̱ŋ lɛɛ ɔ bo̱‑rɔ.” Ne̱ Yeesuu yɛ, “To, m fe̱raa, ma bu fo̱ ke̱pɔ. Amo̱se̱‑ɔ nare̱, amaa le̱e̱ ndɔɔ bo̱ yɔ, fo̱ ma lɛɛ ya waa e̱bɔye̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ne̱ Yeesuu a be̱e̱ sa se̱ŋsa gywii Farisii awuye ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ fe̱yɛ, “N du ne̱e̱ fe̱yɛ ke̱laŋŋe̱rɔ ne̱ ke̱ e̱ laŋŋe̱‑rɔ ke̱ e̱ sa kaye̱‑rɔ ase̱sɛ‑ɔ. Ɔke̱maa ne̱ ɔ gya mo̱ se̱‑ɔ maa nare̱ kibugyii‑ro. Ane̱ŋ a se̱sɛ‑ɔ de ke̱laŋŋe̱rɔ ne̱ ke̱ e̱ sa ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ne̱ Farisii awuye‑o a tɔwe̱ gywii mò̱ fe̱yɛ, “Mbe̱yɔmɔ fo̱ e̱ tɔwe̱ fo̱ fɔŋfɔŋ e̱ye̱e̱ se̱ ase̱ŋ ne̱e̱. Amo̱se̱ se̱‑ɔ ane̱ maa taare̱ a ane̱ kɔɔre̱ fo̱ gyi.” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ne̱ Yeesuu yɛ, “N gye̱ ane̱ŋ ne̱e̱. Hare̱e̱ mo̱ e̱ tɔwe̱ mo̱ fɔŋfɔŋ kuŋu si ase̱ŋ gbaa, ke̱tɔ ne̱ mo̱ e̱ tɔwe̱‑ɔ gye̱ kase̱ŋtiŋ ne̱e̱, a le̱e̱ fe̱yɛ ŋ nyi mfe̱ŋ ne̱ mo̱ a le̱e̱‑ɔ, ne̱ ŋ nyi mfe̱ŋ ne̱ mo̱ e̱ yɔ‑ɔ. Amaa mo̱ne̱ mo̱ŋ nyi mfe̱ŋ ne̱ mo̱ a le̱e̱‑ɔ, na mfe̱ŋ ne̱ mo̱ e̱ yɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mo̱ne̱ fe̱raa, mo̱ne̱ e̱ de̱e̱re̱ ke̱mo̱ ne̱ ki te akatɔ se̱‑ɔ ne̱e̱ a mo̱nꞌ bo̱ po̱rɔ ɔko̱. Amaa m fe̱raa n gye̱ mo̱ kusuŋ ne̱e̱ fe̱yɛ n gyi ɔko̱ ase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Amaa mo̱ a dɛɛ gyi ɔko̱ ase̱ŋ ne̱e̱, weetee mo̱ se̱ŋgyi‑o gye̱ kase̱ŋtiŋ, a le̱e̱ fe̱yɛ n se̱ ne̱ oo suŋ mo̱ bo̱ kyo̱ŋwe̱ kaye̱ mɔ‑rɔ‑ɔ bo̱ mo̱ ase̱, ɔ kya mo̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Amo̱se̱‑ɔ, abɛɛ anyɔ ya tɔwe̱ ase̱ŋ na bamo̱ ɔko̱ kanɔ mo̱ŋ kwe̱e̱ mò̱ ko̱so̱bɛɛ lee si, amo̱ fe̱raa mo̱nꞌ kɔɔre̱ gyi fe̱yɛ bamo̱ ase̱ŋ‑ɔ gye̱ kase̱ŋtiŋ. Mo̱ne̱ mo̱ŋ nyi fe̱yɛ ane̱ŋ ne̱ mbraa ne̱ Wuribware̱ a bo̱rɔ Mosis si sa ane̱‑ɔ e̱ kaapo̱‑ɔ ne̱e̱ e̱e̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","To, mo̱ fɔŋfɔŋ e̱ tɔwe̱ mo̱ kuŋu si ase̱ŋ, ne̱ n se̱ ne̱ oo suŋ mo̱‑ɔ mɔ e̱ tɔwe̱ mo̱ kuŋu si ase̱ŋ ɔ bo̱ tii si. Ane̱ abɛɛ anyɔ ase̱ŋ maa baare a sa mo̱ne̱ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ne̱ baa bise mò̱ fe̱yɛ, “Ŋke̱e̱ fo̱ se̱?” Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Mo̱ne̱ mo̱ŋ nyi mo̱ gbaa, saŋbo̱to̱ n se̱. Mo̱ne̱ i nyi mo̱, amo̱ fe̱raa mo̱ne̱ nyi n se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Mfaanɛɛ a ase̱ŋ ne̱ Yeesuu a tɔwe̱ gywii ase̱sɛ‑ɔ Wuribware̱ suŋkpa a kabuno mfe̱ŋ ne̱ bo̱ de adakaa ne̱ ba twe̱e̱twe̱e̱ atanne̱ ba waa‑rɔ‑ɔ ye̱re̱‑ɔ ne̱e̱. Amaa ɔko̱ mo̱ŋ kra mò̱, a le̱e̱ fe̱yɛ mò̱ saŋ‑ɔ mo̱ŋ tɛɛ fo̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ne̱ Yeesuu a be̱e̱ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ e̱ le̱e̱ mfe̱e̱ a ŋ yɔ. Mo̱ne̱ i buwi a mo̱nꞌ kpa mo̱ kpo̱ne̱, na mo̱ne̱ ma ŋu mo̱, na mo̱ne̱ e̱bɔye̱ sii mo̱ne̱ se̱ a mo̱nꞌ taa bo̱ wu. Mo̱ne̱ maa taare̱ a mo̱nꞌ yɔ mfe̱ŋ ne̱ mo̱ e̱ yɔ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Amo̱se̱‑ɔ ne̱ Yudaa awuye abre̱sɛ‑ɔ a tɔwe̱ fe̱yɛ, “Ɔ yɛ, ane̱ maa taare̱ a ane̱ yɔ mfe̱ŋ ne̱ ɔ yɔ‑ɔ. Amo̱‑ɔ e̱ kaapo̱ ne̱e̱ fe̱yɛ ɔ mɔɔ mò̱ e̱ye̱e̱ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Mo̱ne̱ a le̱e̱ kaye̱ mɔ‑rɔ ne̱e̱. Amaa m fe̱raa, mo̱ŋ le̱e̱ kaye̱ mɔ‑rɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Amo̱se̱ se̱ ne̱ mo̱ a tɔwe̱ gywii mo̱ne̱ fe̱yɛ mo̱ne̱ e̱bɔye̱ i sii mo̱ne̱ se̱, na mo̱nꞌ taa bo̱ wu. Mo̱ne̱ e̱ mo̱ŋ kɔɔre̱ gyi fe̱yɛ mo̱ e̱ gye̱ ne̱ n gye̱ fe̱raa, mo̱ne̱ e̱bɔye̱ i sii mo̱ne̱ se̱, na mo̱nꞌ taa bo̱ wu.” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ne̱ baa bise mò̱ fe̱yɛ, “Nsɛ ne̱ fo̱ e̱ fa fe̱yɛ fo̱ gye̱?” Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “N kyɔ mo̱ŋ tɔwe̱ gywii mo̱ne̱ aaa? ");
INSERT INTO ncuNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","N de ase̱ŋ bwe̱e̱tɔ na n tɔwe̱ bo̱ le̱e̱ mo̱ne̱ e̱bɔye̱ se̱. Mò̱ ne̱ oo suŋ mo̱‑ɔ e̱ gye̱ kase̱ŋtiŋ wuye, ne̱ ke̱tɔ ne̱ mo̱ a nu le̱e̱ mò̱ ase̱‑ɔ wo̱re̱ ne̱ mo̱ e̱ tɔwe̱ mo̱ i gywii kaye̱‑rɔ ase̱sɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ase̱sɛ ne̱ baa nu mò̱ ase̱‑ɔ mo̱ŋ nyi fe̱yɛ mò̱ se̱ Wuribware̱ ne̱ o de. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ne̱ ya yase̱ mo̱, dimaadi mò̱ gyi‑o, so̱so̱, mo̱ne̱ i ŋu fe̱yɛ mo̱ e̱ gye̱ ne̱ n gye̱. Mfe̱ŋ‑ɔ, ne̱ mo̱ne̱ i ŋu fe̱yɛ ma waa ke̱tɔ ke̱maa mo̱ fɔŋfɔŋ e̱ye̱e̱ se̱ ne̱e̱. Amaa mo̱ e̱ tɔwe̱ ke̱tɔ ne̱ n se̱ a tɔwe̱ ɛ n tɔwe̱‑ɔ wo̱re̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mò̱ ne̱ oo suŋ mo̱‑ɔ bo̱ mo̱ ase̱, ɔ mo̱ŋ yɔwe̱ mo̱ wo̱re̱, a le̱e̱ fe̱yɛ mo̱ e̱ waa mò̱ ke̱pre̱ saŋ ke̱maa.” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ase̱sɛ ne̱ baa nu fe̱yɛ Yeesuu a tɔwe̱ amo̱‑ɔ bwe̱e̱tɔ a kɔɔre̱ mò̱ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ ne̱ baa kɔɔre̱ mò̱ gyi‑o fe̱yɛ, “Mo̱ne̱ i de ke̱tɔ ne̱ mo̱ e̱ tɔwe̱‑ɔ‑rɔ, ne̱ mo̱ne̱ e̱ mo̱ŋ yɔwe̱‑rɔ fe̱raa, mo̱ne̱ e̱ gye̱ mo̱ agyase̱po̱ kase̱ŋtiŋ si ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Na mo̱nꞌ gyii kase̱ŋtiŋ‑o, na mo̱ kase̱ŋtiŋ ke̱kaapo̱ e̱ sa a mo̱nꞌ nya mo̱ne̱ e̱ye̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ne̱ bamo̱ bo̱ko̱ a lee kanɔ fe̱yɛ, “Ane̱ a le̱e̱ Abraham ke̱nana‑rɔ ne̱e̱. Ane̱ kyɔ ane̱ mo̱ŋ tɛɛ kii bo̱ko̱ anya. Ne̱ e̱me̱ne̱ se̱ ne̱ fo̱ e̱ tɔwe̱ ɛ ane̱ e̱ nya ane̱ e̱ye̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Kase̱ŋtiŋ ne̱ mo̱ i gyi mo̱ne̱‑ɔ fe̱yɛ ɔke̱maa ne̱ ɔ waa e̱bɔye̱‑ɔ gye̱ e̱bɔye̱ ke̱nya ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ke̱nya ya kyee mò̱ nyaŋpe̱ aye̱ kanɔ ŋke̱maa, ɔ maa kii ogyi, amaa ogyi fe̱raa gye̱ ogyi ne̱e̱ bo̱ yɔ na a mo̱ŋ de kɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Amo̱se̱ se̱‑ɔ Wuribware̱ mò̱ gyi‑o e̱ gye̱ ne̱ mò̱ ya lee mo̱ne̱ le̱e̱ e̱bɔye̱‑rɔ fe̱raa, kase̱ŋtiŋ si mo̱ne̱ e̱ nya mo̱ne̱ e̱ye̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ŋ nyi dame̱naŋsɛ fe̱yɛ mo̱ne̱ e̱ tɔwe̱ kase̱ŋtiŋ fe̱yɛ mo̱ne̱ a le̱e̱ Abraham ke̱nana‑ɔ‑rɔ ne̱e̱. Amaa amo̱ pɛɛɛ gbaa, mo̱ne̱ e̱ kpa fe̱yɛ mo̱nꞌ mɔɔ mo̱, a le̱e̱ fe̱yɛ mo̱ ase̱ŋkpare̱gyi mo̱ŋ bo̱ mo̱ne̱ ŋkpo̱nɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mo̱ e̱ tɔwe̱ ke̱tɔ ne̱ n se̱ a kaapo̱ mo̱‑ɔ ne̱e̱, amaa mo̱ne̱ e̱ waa ke̱tɔ ne̱ mo̱ne̱ se̱ a tɔwe̱ gywii mo̱ne̱‑ɔ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ne̱ baa lee kanɔ fe̱yɛ, “Ane̱ se̱ e̱ gye̱ Abraham.” Ne̱ Yeesuu yɛ, “Mo̱ne̱ dɛɛ mo̱ne̱ gye̱ Abraham mò̱ gyi‑ana kase̱ŋtiŋ ne̱e̱, weetee mo̱ne̱ e̱ waa ke̱tɔ ne̱ ɔɔ waa‑ɔ dɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ke̱tɔ ne̱ mo̱ e̱ waa‑ɔ e̱ gye̱ fe̱yɛ n tɔwe̱ kase̱ŋtiŋ ne̱ mo̱ a nu le̱e̱ Wuribware̱ ase̱‑ɔ gywii mo̱ne̱, amaa amo̱‑ɔ pɛɛɛ gbaa, mo̱ne̱ e̱ kpa fe̱yɛ mo̱nꞌ mɔɔ mo̱ ne̱e̱. Abraham mɔ mo̱ŋ waa ane̱ŋ a atɔ mɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mo̱ne̱ e̱ waa ane̱ŋ ne̱ mo̱ne̱ se̱ a waa‑ɔ ne̱e̱.” Ne̱ baa lee kanɔ fe̱yɛ, “Wuribware̱ wo̱re̱ e̱ gye̱ ane̱ se̱ ne̱ ane̱ de‑o, ane̱ gye̱ mò̱ gyi‑ana kase̱ŋtiŋ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Wuribware̱ dɛɛ ɔ gye̱ mo̱ne̱ se̱ kase̱ŋtiŋ si ne̱e̱, weetee mo̱ne̱ e̱ kpa mo̱ ase̱ŋ, a le̱e̱ fe̱yɛ mo̱ a le̱e̱ Wuribware̱ ase̱ ne̱e̱ ba mfe̱e̱. Mo̱ŋ ba mo̱ fɔŋfɔŋ ke̱yaale̱ŋ se̱ ne̱e̱, amaa mò̱ ne̱ oo suŋ mo̱‑ɔ ke̱yaale̱ŋ se̱ ne̱ mo̱ a ba. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ne̱ weetee ŋkee nte̱tɔ se̱ ne̱ mo̱ne̱ maa nu ke̱tɔ ne̱ mo̱ e̱ tɔwe̱‑ɔ kaase̱‑ɔ ne̱e̱? A du fe̱yɛ mo̱ne̱ maa taare̱ a mo̱nꞌ kɔɔre̱ mo̱ ase̱ŋ ne̱ mo̱ e̱ tɔwe̱‑ɔ gyi ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mo̱ne̱ gye̱ mo̱ne̱ se̱ Ɔbɔnsam mò̱ gyi‑ana ne̱e̱, amo̱se̱‑ɔ ne̱ mo̱ne̱ e̱ kpa a mo̱nꞌ gya ke̱tɔ ne̱ ke̱ e̱ pre̱ mo̱ne̱ se̱‑ɔ se̱. Le̱e̱ atɔ ke̱maa ke̱le̱e̱kaase̱‑rɔ‑ɔ, mo̱ne̱ se̱ gye̱ ɔmɔɔpo̱ ne̱e̱, ne̱ ɔ mo̱ŋ tɛɛ ye̱re̱ kase̱ŋtiŋ a ke̱be̱gya‑ɔ pɛɛɛ, a le̱e̱ fe̱yɛ kase̱ŋtiŋ mo̱ŋ bo̱ mò̱ ase̱. Mò̱ ya ba aye̱ba, ɔ waa ane̱ŋ ne̱ ɔ kyɔ o du‑o ne̱e̱, a le̱e̱ fe̱yɛ ɔ gye̱ ɔye̱bapo̱, mò̱ e̱ gye̱ ŋye̱ba pɛɛɛ kuŋu. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Amaa m fe̱raa, mo̱ i gyi kase̱ŋtiŋ ne̱e̱, amo̱se̱ se̱ ne̱ mo̱ne̱ maa kɔɔre̱ mo̱ mo̱ne̱ i gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mo̱ne̱‑rɔ nsɛ e̱ gye̱ ne̱ ɔ taare̱ a ɔ kaapo̱ mo̱‑rɔ fe̱yɛ mo̱ a gyi ke̱pɔ bo̱ le̱e̱ e̱bɔye̱ ko̱waa se̱? Mo̱ ya tɔwe̱ kase̱ŋtiŋ gywii mo̱ne̱, nte̱tɔ se̱ ne̱ mo̱ne̱ maa kɔɔre̱ mo̱ ase̱ŋ mo̱ne̱ i gyi? ");
INSERT INTO ncuNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ɔke̱maa ne̱ Wuribware̱ e̱ bo̱ mò̱‑ɔ i nu mò̱ ase̱ŋ. Mo̱ne̱ fe̱raa, n gye̱ Wuribware̱ e̱ bo̱ mo̱ne̱ kpa ke̱maa se̱, amo̱se̱ se̱ ne̱ mo̱ne̱ maa nu mo̱ ase̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ne̱ baa bise Yeesuu fe̱yɛ, “A mo̱ŋ gye̱ kase̱ŋtiŋ fe̱yɛ fo̱ gye̱ Samariyanyi, ne̱ ibrisi ko̱ te fo̱ se̱ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Ibrisi ke̱maa mo̱ŋ te mo̱ se̱. Ase̱ŋ ne̱ mo̱ e̱ tɔwe̱‑ɔ e̱ kaapo̱ ne̱e̱ fe̱yɛ mo̱ i bu n se̱ ne̱e̱. Amaa mo̱ne̱ fe̱raa mo̱ne̱ e̱ saare̱ mo̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ma buwi mo̱ e̱ kpa ɔko̱ fe̱yɛ o bu mo̱ ke̱dabe̱ ne̱e̱. Amaa n se̱ e̱ gye̱ ne̱ ɔ kpa fe̱yɛ ɔ bo̱nyaa mo̱. Mò̱ e̱ gye̱ ne̱ o gyi ase̱sɛ ase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ ɔke̱maa ne̱ ɔ gya mo̱ ke̱kaapo̱ se̱‑ɔ maa wu daa.” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ne̱ baa tɔwe̱ gywii Yeesuu fe̱yɛ, “Mbe̱yɔmɔ ane̱ nyi kase̱ŋtiŋ fe̱yɛ ibrisi te fo̱ se̱. Abraham a wu, ne̱ Wuribware̱ akyaamɛɛ a wu, amaa fo̱ fe̱raa, fo̱ e̱ tɔwe̱ ne̱e̱ fe̱yɛ ɔke̱maa ne̱ ɔ gya fo̱ ke̱kaapo̱‑ɔ se̱‑ɔ maa wu daa. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ane̱ se̱ Abraham a wu, amɔ fo̱ e̱ kpa a fo̱ tɔwe̱ ne̱e̱ fe̱yɛ fo̱ kyɔ Abraham aaa? Ne̱ Wuribware̱ a akyaamɛɛ‑ɔ mɔ a wu. Nsɛ ne̱ fo̱ e̱ fa fe̱yɛ fo̱ gye̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “N dɛɛ ŋ yɛ m bu mo̱ e̱ye̱e̱ ke̱dabe̱ ne̱e̱, weetee mo̱ kibu mo̱ e̱ye̱e̱‑ɔ mo̱ŋ de awaasɛ ke̱maa. Ɔko̱ ne̱ ɔ bo̱nyaa mo̱‑ɔ e̱ gye̱ n se̱, mò̱ dɛɛ ne̱ mo̱ne̱ yɛ ɔ gye̱ mo̱ne̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mo̱ne̱ mo̱ŋ nyi mò̱ pɛɛɛ, amaa m fe̱raa, ŋ nyi mò̱. Mo̱ a dɛɛ tɔwe̱ fe̱yɛ mo̱ŋ nyi Wuribware̱ ne̱e̱, amo̱ fe̱raa mo̱ i kii ɔye̱bapo̱ fe̱yɛ mo̱ne̱‑ɔ. Amaa ŋ nyi mò̱, ne̱ n gya mò̱ kanɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mo̱ne̱ se̱ Abraham akatɔ a gyi fe̱yɛ ɔ bo̱ ŋu mo̱ ke̱ba, ne̱ oo ŋu fe̱yɛ mo̱ a ba, ne̱ mò̱ akatɔ a gyi.” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ne̱ baa tɔwe̱ gywii mò̱ fe̱yɛ, “Fo̱ mo̱ŋ tɛɛ gyi nsu adunuu, ne̱ fo̱ yɛ fo̱ a ŋu Abraham aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ mo̱ e̱ gye̱ ne̱ n kyɔ n gye̱ pwɛɛ ne̱ baa dɛɛ ko̱we̱ Abraham.” ");
INSERT INTO ncuNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ne̱ baa taa abu a bo̱ twe̱e̱ bo̱ da mò̱. Amaa Yeesuu a kwe̱e̱rɔ bamo̱ se̱ se̱re̱ le̱e̱ Wuribware̱ suŋkpa a kabuno‑o mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yeesuu a naa ɔ yɔ‑ɔ, ne̱ oo ŋu ɔnyare̱ ko̱ ne̱ baa ko̱we̱ mò̱ te̱napo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ne̱ mò̱ agyase̱po̱‑ɔ a bise mò̱ fe̱yɛ, “Ɔkaapo̱po̱, nsɛ e̱bɔye̱ ya sa ne̱ baa ko̱we̱ ɔnyare̱ mɔ te̱napo̱? Aa le̱e̱ mò̱ fɔŋfɔŋ ase̱ ne̱e̱, bɛɛɛ mò̱ ako̱we̱po̱ e̱bɔye̱ se̱ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Mò̱ akatɔ kibwee‑o mo̱ŋ le̱e̱ mò̱ e̱bɔye̱ se̱ bɛɛɛ mò̱ ako̱we̱po̱ e̱bɔye̱ se̱. Wuribware̱ ya sa ne̱ baa ko̱we̱ mo̱ te̱napo̱, a le̱e̱ fe̱yɛ ɔ kpa a ɔ bo̱rɔ te̱napo̱ mɔ se̱ lee mò̱ ke̱yaale̱ŋ bo̱ kaapo̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kusuŋ amo̱ ne̱ Wuribware̱ a suŋ mo̱ bo̱ kyo̱ŋwe̱ fe̱yɛ ŋ waa‑ɔ ne̱e̱. A saŋ a gye̱ mpase̱ ne̱ mo̱ e̱ waa n se̱ kusuŋ, amaa kibugyii ya ba, ɔko̱ maa lɛɛ taare̱ a o suŋ kusuŋ. ");
INSERT INTO ncuNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mo̱ a tɛɛ m bo̱ kaye̱ mɔ‑rɔ‑ɔ, mo̱ e̱ gye̱ kaye̱‑rɔ ase̱sɛ ke̱laŋŋe̱rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yeesuu a tɔwe̱ amo̱‑ɔ lo̱we̱‑ɔ, ne̱ ɔɔ twe̱e̱ akyɔne̱ we̱e̱ swe̱e̱re̱, ne̱ ɔɔ ba akyɔne̱‑ɔ bo̱ pɔ e̱se̱ kafwe̱e̱, ne̱ ɔɔ ba e̱se̱‑ɔ bo̱ bure ɔnyare̱ amo̱ akatɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ne̱ ɔɔ tɔwe̱ gywii mò̱ fe̱yɛ, “Nare̱ yɔ Silowam ke̱pare̱‑rɔ ya fwe̱e̱ fo̱ akatɔ‑rɔ.” Ke̱nyare̱ Silowam‑o kaase̱ e̱ gye̱ Baa-suŋ-fo̱. Ne̱ ɔnyare̱ amo̱ a ya fwe̱e̱ mò̱ akatɔ‑rɔ, ne̱ oo kiŋŋi ba, na mò̱ akatɔ a buŋŋi. ");
INSERT INTO ncuNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ne̱ te̱napo̱‑ɔ akye̱nabɛɛpo̱ na ase̱sɛ ne̱ baa dɛɛ ŋu mò̱ pwɛɛ ne̱ amo̱‑ɔ a dɛɛ waa‑ɔ a bise abɛɛ fe̱yɛ, “N gye̱ te̱napo̱ ne̱ ɔ dɛɛ o te ɔ ko̱re̱ atɔ‑ɔ ne̱e̱ e̱e̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bo̱ko̱ yɛ, “Mò̱ ne̱e̱.” Ne̱ bo̱ko̱ mɔ yɛ, “N gye̱ mò̱ ne̱e̱. Ɔɔ le̱e̱ mò̱ ne̱e̱.” Ne̱ ɔnyare̱‑ɔ fɔŋfɔŋ yɛ, “Mo̱ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ne̱ baa bise mò̱ fe̱yɛ, “Nte̱tɔ ne̱e̱ ne̱ mbe̱yɔmɔ fe̱raa fo̱ ke̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ne̱ oo lee kanɔ fe̱yɛ, “Ɔnyare̱ ne̱ ba te̱e̱ mò̱ ɛ Yeesuu‑o ya waa e̱se̱, ne̱ ɔɔ bo̱ bure mo̱ akatɔ, ne̱ ɔɔ tɔwe̱ gywii mo̱ fe̱yɛ ŋ yɔ Silowam ke̱pare̱‑rɔ ya fwe̱e̱ mo̱ akatɔ‑rɔ. Ne̱ mo̱ a yɔ mo̱ a de̱ŋ fwe̱e̱‑ɔ, ne̱ mo̱ a ŋu fe̱yɛ ŋ ke̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ne̱ baa bise mò̱ fe̱yɛ, “Mfe̱ne̱ ne̱ ɔ bo̱?” Ne̱ oo lee kanɔ fe̱yɛ, “Mo̱ŋ nyi.” ");
INSERT INTO ncuNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ne̱ baa taa te̱napo̱ ne̱ mbe̱yɔmɔ mò̱ akatɔ a buŋŋi‑o yaa Farisii awuye ase̱ a bo̱ de̱e̱re̱ mò̱ ase̱ŋ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Kake ne̱ Yeesuu a waa e̱se̱ bo̱ kya te̱napo̱ amo̱‑ɔ gye̱ kukyure kake ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ne̱ Farisii awuye‑o a be̱e̱ bise ɔnyare̱‑ɔ ane̱ŋ ne̱ mò̱ akatɔ a waa buŋŋi‑o. Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Ɔɔ taa e̱se̱ ne̱e̱ bo̱ bure mo̱ akatɔ, ne̱ mo̱ a fwe̱e̱ mo̱ akatɔ‑rɔ, ne̱ mbe̱yɔmɔ ŋ ke̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ne̱ Farisii awuye‑o bo̱ko̱ yɛ, “Ɔnyare̱ mɔ ne̱ ɔɔ waa amo̱‑ɔ maa taare̱ a ɔ le̱e̱ Wuribware̱ ase̱, a le̱e̱ fe̱yɛ o suŋ kusuŋ kukyure kake‑o.” Ne̱ bo̱ko̱ mɔ yɛ, “E̱me̱ne̱ ne̱ ɔnyare̱ ne̱ ɔ gye̱ e̱bɔye̱ ɔwaapo̱‑ɔ e̱ taare̱ a ɔ waa ane̱ŋ a akpe̱ŋe̱ye̱e̱tɔ mɔ?” Ne̱ bamo̱ wo̱re̱ wo̱re̱ i gyiiri ikii. ");
INSERT INTO ncuNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ne̱ Farisii awuye‑o a be̱e̱ bise ɔnyare̱‑ɔ fe̱yɛ, “Fo̱ yɛ ɔɔ kya fo̱, ne̱ fo̱ akatɔ a buŋŋi, e̱me̱ne̱ ne̱ fo̱ e̱ fa mò̱ ase̱ŋ?” Ne̱ ɔnyare̱‑ɔ a lee kanɔ fe̱yɛ, “Ɔ gye̱ Wuribware̱ a akyaamɛɛ‑ɔ ɔko̱ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Yudaa awuye abre̱sɛ‑ɔ mo̱ŋ kɔɔre̱ ɔnyare̱ amo̱ ase̱ŋ‑ɔ gyi fe̱yɛ ɔ dɛɛ ɔ gye̱ te̱napo̱ ne̱e̱, ne̱ mbe̱yɔmɔ mò̱ akatɔ a buŋŋi, amɔ bamo̱ a te̱e̱ mò̱ ako̱we̱po̱ bise bamo̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Mò̱ ako̱we̱po̱‑ɔ a ba‑ɔ, ne̱ baa bise bamo̱ fe̱yɛ, “Mo̱ne̱ gyi ne̱e̱ e̱e̱e̱? Mo̱ne̱ yɛ mo̱ne̱ a ko̱we̱ mò̱ te̱napo̱ ne̱e̱. To, e̱me̱ne̱ ya waa ne̱ ŋkee ɔ ke̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ne̱ mò̱ ako̱we̱po̱ a lee kanɔ fe̱yɛ, “Ane̱ nyi fe̱yɛ ane̱ gyi ne̱e̱, ne̱ ane̱ nyi fe̱yɛ ane̱ a ko̱we̱ mò̱ te̱napo̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Amaa ane̱ mo̱ŋ nyi ane̱ŋ ne̱ aa waa ne̱ ŋkee ɔ ke̱e̱‑ɔ, bɛɛɛ ane̱ mo̱ŋ nyi mò̱ ne̱ ɔɔ kya mò̱, ne̱ ŋkee ɔ ke̱e̱‑ɔ. Mo̱nꞌ bise mò̱. Ɔ mo̱ŋ gye̱ keegyi ne̱e̱, ɔ taare̱ a o lee kanɔ sa mò̱ e̱ye̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ke̱tɔ se̱ ne̱ ɔnyare̱‑ɔ ako̱we̱po̱ a tɔwe̱ amo̱‑ɔ e̱ gye̱ fe̱yɛ kufu de bamo̱ Yudaa awuye abre̱sɛ‑ɔ se̱, a le̱e̱ fe̱yɛ baa kyɔ tɔwe̱ fe̱yɛ ɔke̱maa ne̱ ɔ kɔɔre̱ o gyi fe̱yɛ Yeesuu e̱ gye̱ Kristoo‑o, ba gya mò̱ a bo̱ le̱e̱ bamo̱ ke̱bware̱ko̱re̱kyaŋ‑nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Amo̱se̱ se̱ ne̱ ɔnyare̱‑ɔ ako̱we̱po̱ yɛ, “Ɔ mo̱ŋ gye̱ keegyi, mo̱nꞌ bise mò̱ fɔŋfɔŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ne̱ baa te̱e̱ ɔnyare̱ ne̱ baa ko̱we̱ mò̱ te̱napo̱‑ɔ nyɔse̱po̱ baa. Ne̱ baa tɔwe̱ gywii mò̱ fe̱yɛ ɔ ka Wuribware̱ ke̱yaa fe̱yɛ ɔ tɔwe̱ kase̱ŋtiŋ. Ne̱ bo̱ yɛ, “Ane̱ nyi fe̱yɛ ɔnyare̱ ne̱ ba te̱e̱ mò̱ ɛ Yeesuu‑o gye̱ e̱bɔye̱ ɔwaapo̱ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ne̱ ɔnyare̱‑ɔ a lee kanɔ fe̱yɛ, “Ɔ gye̱ e̱bɔye̱ ɔwaapo̱ ne̱e̱ ooo, ɔ mo̱ŋ gye̱ ooo, m fe̱raa mo̱ŋ nyi. Ke̱tɔ ne̱ ŋ nyi‑o e̱ gye̱ fe̱yɛ n dɛɛ n gye̱ te̱napo̱, amaa mbe̱yɔmɔ ŋ ke̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ne̱ baa bise mò̱ fe̱yɛ, “E̱me̱ne̱ ne̱ ɔɔ waa kya fo̱ akatɔ‑ɔ?” ");
INSERT INTO ncuNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ne̱ oo lee kanɔ fe̱yɛ, “Mo̱ a kyɔ tɔwe̱ gywii mo̱ne̱, amaa mo̱ne̱ maa nu. E̱me̱ne̱ se̱ ne̱ mo̱ne̱ be̱e̱ mo̱ne̱ gbaa mo̱ne̱ e̱ kpa a mo̱nꞌ nu? Mo̱ne̱ e̱ kpa a mo̱nꞌ kii mò̱ agyase̱po̱ ne̱e̱ e̱e̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ne̱ baa saare̱ mò̱, ne̱ baa tɔwe̱ gywii mò̱ fe̱yɛ, “Fo̱‑ɔ fo̱ gye̱ se̱sɛ amo̱ ɔgyase̱po̱ ne̱e̱. Amaa ane̱ fe̱raa, ane̱ gye̱ Mosis agyase̱po̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ane̱ nyi fe̱yɛ Wuribware̱ e̱ gye̱ ne̱ ɔɔ sa se̱ŋsa gywii Mosis, amaa ane̱ŋ a se̱sɛ‑ɔ fe̱raa, ane̱ mo̱ŋ nyi mfe̱ŋ ne̱ ɔɔ le̱e̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ne̱ ɔnyare̱ amo̱ a be̱ŋŋaa fe̱yɛ, “Nte̱tɔ ase̱ŋ mɔ ne̱e̱? Mo̱ne̱ yɛ mo̱ne̱ mo̱ŋ nyi mfe̱ŋ ne̱ ɔɔ le̱e̱ ba‑ɔ, amaa oo buŋŋi mo̱ akatɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ane̱ nyi fe̱yɛ Wuribware̱ maa nu e̱bɔye̱ awaapo̱ ase̱ŋ, amɔ bamo̱ ne̱ ba bu mò̱, ne̱ ba waa ane̱ŋ ne̱ ɔ kpa fe̱yɛ bo̱ waa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Le̱e̱ saŋ ne̱ Wuribware̱ a twe̱e̱ kaye̱‑ɔ, ɔko̱ mo̱ŋ tɛɛ ŋu fe̱yɛ ɔko̱ a buŋŋi mò̱ ne̱ baa ko̱we̱ mò̱ te̱napo̱‑ɔ akatɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ɔnyare̱ mɔ dɛɛ ɔ mo̱ŋ le̱e̱ Wuribware̱ ase̱ ne̱e̱, weetee ɔ maa taare̱ a ɔ waa ane̱ŋ a atɔ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ne̱ baa lee kanɔ fe̱yɛ, “Le̱e̱ saŋ ne̱ fo̱ bo̱ fo̱ nyi kame‑ro‑o fo̱ gye̱ e̱bɔye̱ ɔwaapo̱ ne̱e̱. Ne̱ fo̱‑ɔ fo̱ e̱ kpa a fo̱ kaapo̱ ane̱ atɔ aaa?” Ne̱ baa gya mò̱ le̱e̱ bamo̱ ke̱bware̱ko̱re̱kyaŋ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yeesuu a nu fe̱yɛ baa gya ɔnyare̱ amo̱ le̱e̱ bamo̱ ke̱bware̱ko̱re̱kyaŋ‑ɔ‑rɔ, ne̱ oo buwi kpa ɔnyare̱‑ɔ. Mò̱ a ŋu mò̱‑ɔ, ne̱ oo bise mò̱ fe̱yɛ, “Fo̱ e̱ kɔɔre̱ dimaadi mò̱ gyi‑o fo̱ i gyi aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ne̱ ɔnyare̱ amo̱ a lee kanɔ fe̱yɛ, “Mo̱ nyaŋpe̱, kaapo̱ mo̱ dimaadi mò̱ gyi‑o, na ŋ nya kɔɔre̱ mò̱ gyi.” ");
INSERT INTO ncuNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Fo̱ a kyɔ ŋu mò̱, mo̱ e̱ gye̱ mò̱ ne̱ fo̱ aa mò̱ e̱ sa se̱ŋsa mbe̱yɔmɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ne̱ oo lee kanɔ fe̱yɛ, “Mo̱ a kɔɔre̱ fo̱ gyi, mo̱ nyaŋpe̱.” Ne̱ oo kpuni aŋurii suŋ Yeesuu. ");
INSERT INTO ncuNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ne̱ Yeesuu yɛ, “Mo̱ a ba kaye̱ mɔ‑rɔ ne̱e̱ na m bo̱ gyi ase̱sɛ ase̱ŋ, bu ke̱pɔ, na ate̱napo̱ akatɔ buŋŋi, na bamo̱ ne̱ bo̱ ke̱e̱‑ɔ mɔ kii fe̱yɛ ate̱napo̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisii awuye ko̱ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ a nu ane̱ŋ ne̱ ɔɔ tɔwe̱‑ɔ, ne̱ baa bise mò̱ fe̱yɛ, “Ke̱e̱ ɛ. Amo̱‑ɔ e̱ kaapo̱ ne̱e̱ fe̱yɛ ane̱ mɔ ane̱ mo̱ŋ ke̱e̱ ne̱e̱ e̱e̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Mo̱ne̱ dɛɛ mo̱ne̱ mo̱ŋ ke̱e̱ ne̱e̱‑ɔ, weetee mo̱ne̱ mo̱ŋ gye̱ e̱bɔye̱ awaapo̱, amaa mo̱ne̱ a tɔwe̱ ɛ mo̱ne̱ ke̱e̱‑ɔ se̱‑ɔ, mo̱ne̱ e̱bɔye̱ i sii mo̱ne̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ne̱ Yeesuu yɛ, “Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ, mo̱ne̱ nyi fe̱yɛ ane̱ ase̱sɛ e̱ pwɛɛ adeŋbee kuriikuriisɛ ne̱e̱, ne̱ ba kpaa bamo̱ e̱sanne̱ ba waa‑rɔ kanye. Amo̱se̱ se̱‑ɔ ɔke̱maa ne̱ ɔ mo̱ŋ bo̱rɔ kideŋbee a kibunogyi‑o‑ro lweero e̱sanne̱‑ɔ ase̱, ne̱ ɔ de̱e̱ kideŋbee‑o lweero‑o gye̱ oyu ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Amaa ɔko̱ ne̱ ɔ bo̱rɔ kibunogyi‑o‑ro a o lweero e̱sanne̱‑ɔ ase̱‑ɔ e̱ gye̱ e̱sanne̱‑ɔ ɔde̱e̱re̱se̱po̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mò̱ ne̱ ɔ ke̱e̱ kibunogyi‑o si‑o i buŋŋi kpa a ɔ sa mò̱. Na mò̱ a maa se̱ ɔ te̱e̱ e̱sanne̱‑ɔ anyare̱ ako̱ ako̱‑ɔ, na bo̱ pini mò̱ bo̱re̱, na o lee bamo̱ kawu. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Mò̱ ya lee bamo̱ kawu‑o, na ɔ gye̱ bamo̱ ŋkpɛɛ, na bo̱ gya mò̱ se̱, a le̱e̱ fe̱yɛ bo̱ nyi mò̱ bo̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Amaa bo̱ maa gya ɔko̱ se̱, ba se̱re̱ a bo̱ yɔwe̱ se̱sɛ amo̱ ne̱e̱, a le̱e̱ fe̱yɛ bo̱ mo̱ŋ nyi mò̱ bo̱re̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Amaa Yeesuu a da ke̱kpare̱ mɔ‑ɔ, bo̱ mo̱ŋ nu ke̱mo̱ kaase̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ne̱ Yeesuu a be̱e̱ kya se̱ tɔwe̱ fe̱yɛ, “Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ m be̱e̱ n du ne̱e̱ fe̱yɛ e̱sanne̱ a kibunogyi‑o. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bamo̱ ɔke̱maa ne̱ ɔɔ daa mo̱ e̱ba‑ɔ gye̱ oyu ne̱e̱, amaa e̱sanne̱‑ɔ mo̱ŋ gya bamo̱ kanɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","N du ne̱e̱ fe̱yɛ kibunogyi‑o. Ɔke̱maa ne̱ ɔ bo̱rɔ mo̱ se̱ a o lweero‑o maa fo̱, o lweero a ɔ le̱e̱ na ɔ nya gyirokpa timaa. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ayu fe̱raa i lweero ne̱e̱ a bo̱ bo̱ ywii, na bo̱ mɔɔ, na bo̱ nye̱ra. Amaa m fe̱raa, mo̱ a ba ne̱e̱ a bo̱ nya nya ŋkpa na kakatɔgyi na ke̱tɔ ke̱maa ne̱ ki tiri bamo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Mo̱ dɛɛ dɛɛ mo̱ e̱ gye̱ e̱sanne̱ ɔde̱e̱re̱se̱po̱ timaa, ne̱ mo̱ a waa mo̱ e̱ye̱e̱ siraa fe̱yɛ mo̱ e̱ ba a m bo̱ wu sa mo̱ e̱sanne̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Osuŋpo̱ ne̱ ɔ bo̱ mfe̱ŋ, ne̱ ɔ mo̱ŋ gye̱ e̱sanne̱ ɔde̱e̱re̱se̱po̱‑ɔ ya ŋu fe̱yɛ ɔfaasɛ e̱ ba, amɔ ɔ se̱re̱ a ɔ yɔwe̱ e̱sanne̱‑ɔ, a le̱e̱ fe̱yɛ n gye̱ mò̱ e̱ bo̱ e̱sanne̱‑ɔ. Amo̱se̱‑ɔ na ɔfaasɛ‑ɔ lwee e̱sanne̱‑ɔ‑rɔ, amɔ ɔ kra bamo̱ bo̱ko̱, na bamo̱ ne̱ ba saŋ‑ɔ brawe̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ke̱tɔ se̱ ne̱ osuŋpo̱‑ɔ e̱ se̱re̱ a ɔ le̱e̱ mfe̱ŋ‑ɔ e̱ gye̱ fe̱yɛ baa taa mò̱ ne̱e̱ a ɔ de̱e̱re̱ e̱sanne̱‑ɔ se̱, ane̱ŋ se̱‑ɔ bamo̱ ase̱ŋ mo̱ŋ tiri mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Mo̱ e̱ gye̱ e̱sanne̱ ɔde̱e̱re̱se̱po̱ timaa‑o. Ane̱ŋ ne̱ n se̱ nyi mo̱‑ɔ, ne̱ mo̱‑ɔ ŋ nyi n se̱‑ɔ, ane̱ŋ dɛɛ ne̱ ŋ nyi mo̱ e̱sanne̱‑ɔ, ne̱ bamo̱ mɔ bo̱ nyi mo̱. Ne̱ mo̱ a waa siraa fe̱yɛ mo̱ i wu a n sa bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","E̱sanne̱ ko̱ mɔ bo̱‑rɔ ne̱ bo̱ gye̱ mo̱ lee, ne̱ bo̱ mo̱ŋ tii mfe̱e̱ a e̱sanne̱‑ɔ se̱. Mo̱ e̱ baa bamo̱ a m ba bo̱ tii bo̱mo̱‑ɔ se̱. Ba nu mo̱ kanɔ, na bo̱ kii e̱sanne̱ kape ko̱ŋko̱ na ɔde̱e̱re̱se̱po̱ ko̱ŋko̱ lee. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","N se̱ e̱ kpa mo̱ ase̱ŋ, a le̱e̱ fe̱yɛ mo̱ a sure si fe̱yɛ mo̱ i wu a m bo̱ sa ase̱sɛ, na m be̱e̱ bo̱ kyiŋŋi le̱e̱ lowi‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ɔko̱ maa taare̱ a ɔ mɔɔ mo̱, amɔ mo̱ a sa kpa fe̱raa. Mo̱ a lee mo̱ e̱ye̱e̱ fe̱yɛ mo̱ i wu a m bo̱ sa ase̱sɛ. N de kpa fe̱yɛ ŋ wu, ne̱ m be̱e̱ n de kpa fe̱yɛ n kyiŋŋi le̱e̱ lowi‑ro, ane̱ŋ ne̱ n se̱ a tɔwe̱ fe̱yɛ ŋ waa‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ase̱sɛ‑ɔ a nu amo̱‑ɔ, ne̱ baa gyiiri ikii, ne̱ baa ke‑ro ntuŋ ŋnyɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ne̱ bamo̱ bwe̱e̱tɔ a tɔwe̱ fe̱yɛ, “Nte̱tɔ ne̱e̱ ne̱ mo̱ne̱ i nu ɔnyare̱ mɔ ase̱ŋ? Ibrisi te mò̱ se̱, ne̱ ɔ lɔ e̱bo̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ne̱ bamo̱ bo̱ko̱ mɔ a tɔwe̱ fe̱yɛ, “Ɔko̱ ne̱ ibrisi te mò̱ se̱‑ɔ maa taare̱ a ɔ sa se̱ŋsa mfaanɛɛ. E̱me̱ne̱ ne̱ ibrisi e̱ waa a ki buŋŋi ate̱napo̱ akatɔ?” ");
INSERT INTO ncuNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Pwe̱e̱re̱pwe̱e̱re̱‑rɔ Yɛro̱salɛm awuye de kasu kanɔ ngyaŋŋe̱ ko̱ ne̱ ba te̱e̱ ɛ Wuribware̱ suŋkpa a ke̱kpɛɛ iyisi‑o a ŋke‑o.† ");
INSERT INTO ncuNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Saŋ amo̱ ne̱ Yeesuu naa Wuribware̱ suŋkpa a abraŋdaye̱ ne̱ ba te̱e̱ ɛ Solomɔŋ a abraŋdaye̱‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ne̱ ase̱sɛ a kpɔwe̱ muruwaa mò̱, ne̱ baa bise mò̱ fe̱yɛ, “Ŋke mfe̱ne̱ ne̱ fo̱ e̱ kpa fe̱yɛ ane̱ kye̱na, na ane̱ mo̱ŋ nyi ane̱ŋ ne̱ fo̱ du‑o? Tɔwe̱ kase̱ŋtiŋ gywii ane̱. Fo̱ e̱ gye̱ Kristoo‑o ooo?” ");
INSERT INTO ncuNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ne̱ Yeesuu yɛ, “Mo̱ a kyɔ tɔwe̱ gywii mo̱ne̱, amaa mo̱ne̱ mo̱ŋ kɔɔre̱ mo̱ gyi. Atɔ ne̱ n de n se̱ ke̱yaale̱ŋ mo̱ e̱ waa‑ɔ e̱ tɔwe̱ mo̱ ase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Amaa mo̱ne̱ maa kɔɔre̱ mo̱ a mo̱nꞌ gyi, a le̱e̱ fe̱yɛ mo̱ne̱ mo̱ŋ gye̱ mo̱ ase̱sɛ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mo̱ ase̱sɛ fe̱raa i nu mo̱ ase̱ŋ, ne̱ ŋ nyi bamo̱, ne̱ bo̱ gya mo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mo̱ e̱ sa bamo̱ ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ, amo̱se̱‑ɔ bo̱ maa lɛɛ gyi awo̱re̱fɔɔ daa. Ɔko̱ maa taare̱ a ɔ kɔɔre̱ bamo̱ le̱e̱ mo̱ ke̱sare̱e̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","N se̱ ya taa bamo̱ sa mo̱. Ɔ kyɔ ɔke̱maa, amo̱se̱‑ɔ ɔko̱ maa taare̱ a ɔ kɔɔre̱ bamo̱ le̱e̱ n se̱ ke̱sare̱e̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mo̱ aa n se̱ gye̱ ko̱ko̱ŋko̱ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ne̱ ase̱sɛ amo̱ a be̱e̱ taa abu na bo̱ twe̱e̱ bo̱ da mò̱ mɔɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ a waa asuŋ timaa bwe̱e̱tɔ mo̱ne̱ akatɔ‑rɔ, amo̱ ne̱ n se̱ a sa mo̱ fe̱yɛ ŋ waa‑ɔ. Mo̱ asuŋ mɔ‑rɔ, ke̱mo̱ e̱ gye̱ ne̱ ki kye mo̱ne̱, ne̱ mo̱ne̱ e̱ kpa a mo̱nꞌ twe̱e̱ abu bo̱ da mo̱‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ne̱ baa lee kanɔ fe̱yɛ, “N gye̱ asuŋ timaa si ne̱ ane̱ e̱ kpa a ane̱ twe̱e̱ abu bo̱ da fo̱, amaa fo̱ maa bu Wuribware̱ bo̱ le̱e̱ ase̱ŋ ne̱ fo̱ e̱ tɔwe̱‑ɔ se̱. Se̱sɛ e̱ gye̱ fo̱, ne̱ fo̱ e̱ kpa fe̱yɛ fo̱ waa fo̱ e̱ye̱e̱ fe̱yɛ Wuribware̱ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Baa kyo̱rɛɛ mo̱ne̱ fɔŋfɔŋ mbraa wo̱re̱‑ɔ‑rɔ fe̱yɛ Wuribware̱ a te̱e̱ ase̱sɛ ko̱ fe̱yɛ mò̱ gyi‑ana. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","36","Ane̱ nyi fe̱yɛ ane̱ŋ ne̱ abware̱se̱ŋ wo̱re̱‑ɔ a tɔwe̱‑ɔ gye̱ kase̱ŋtiŋ, na ɔko̱ ma taare̱ a ɔ tɔwe̱ ase̱ŋ bo̱ kye wo̱re̱ amo̱. Wuribware̱ a te̱e̱ bamo̱ mò̱ gyi‑ana, ne̱ ɔɔ taa mò̱ ase̱ŋ sa bamo̱. To, n se̱ Wuribware̱ ya lee mo̱ suŋ mo̱ bo̱ kyo̱ŋwe̱ kaye̱‑rɔ, ne̱ e̱me̱ne̱ se̱ ne̱ mo̱ne̱ e̱ tɔwe̱ fe̱yɛ mo̱ a tɔwe̱ fe̱yɛ n gye̱ Wuribware̱ mò̱ gyi‑o si‑o, mo̱ e̱ tɔwe̱ ase̱ŋ mo̱ i kye Wuribware̱ ne̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Mo̱ e̱ mo̱ŋ waa ke̱tɔ ne̱ n se̱ e̱ kpa fe̱yɛ ŋ waa‑ɔ, mo̱ne̱ ma kɔɔre̱ mo̱ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Amaa mo̱ ya waa amo̱ ne̱ a pre̱ n se̱‑ɔ fe̱raa, hare̱e̱ mo̱ne̱ e̱ maa kɔɔre̱ mo̱ ase̱ŋ a mo̱nꞌ gyi gbaa, mo̱nꞌ kɔɔre̱ mo̱ gyi le̱e̱ atɔ ne̱ mo̱ne̱ a ŋu fe̱yɛ mo̱ a waa‑ɔ se̱. Na mo̱nꞌ nya pini, na mo̱nꞌ kɔɔre̱ gyi fe̱yɛ mo̱ aa n se̱ gye̱ ko̱ŋko̱ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ne̱ baa kpa a bo̱ be̱e̱ kra Yeesuu, ne̱ ɔɔ se̱re̱ le̱e̱ bamo̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ne̱ Yeesuu a be̱e̱ kiŋŋi ya te̱ŋ Yo̱o̱daŋ bo̱ŋ‑nɔ yɔ mfe̱ŋ ne̱ Yohanee a dɛɛ bɔ ase̱sɛ asuu‑o, ne̱ ɔɔ kye̱na mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ne̱ ase̱sɛ bwe̱e̱tɔ a ba mò̱ ase̱. Ne̱ baa tɔwe̱ fe̱yɛ, “Yohanee mo̱ŋ waa akpe̱ŋe̱ye̱e̱tɔ ke̱maa. Amaa ke̱tɔ ne̱ Yohanee a tɔwe̱ bo̱ le̱e̱ Yeesuu si‑o gye̱ kase̱ŋtiŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ne̱ ase̱sɛ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ bwe̱e̱tɔ a kɔɔre̱ mò̱ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Ne̱ ɔnyare̱ ko̱ bo̱‑rɔ ne̱ ba te̱e̱ mò̱ ɛ Lasarus. Ne̱ mò̱ aa mò̱ pe̱kye̱e̱‑ana ne̱ ba te̱e̱ bamo̱ ɛ Mariya na Maataa‑ɔ te Bɛtaniya kamaŋgyii‑ro. Mariya mɔ e̱ gye̱ mò̱ ne̱ ane̱ e̱ ba a bo̱ ŋu fe̱yɛ o twiiri laŋpe̱ŋtaa a ɔ we̱e̱ ane̱ nyaŋpe̱ Yeesuu ayaa se̱, na ɔ ba mò̱ ipwii bo̱ kpɛɛ‑ɔ. Ne̱ Lasarus e̱ lɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ne̱ mò̱ pe̱kye̱e̱‑ana a kra bo̱ kyo̱ŋwe̱ Yeesuu tɔwe̱ fe̱yɛ, “Ane̱ nyaŋpe̱, fo̱ nyare̱ timaa e̱ lɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yeesuu a nu‑o, ne̱ ɔ yɛ, “Ko̱lɔ mɔ maa baa Lasarus lowi, amaa kaa ba ne̱e̱ a ase̱sɛ nya ŋu fe̱yɛ Wuribware̱ e̱ gye̱ ne̱ ɔ kyɔ ke̱tɔ ke̱maa, na Wuribware̱ mò̱ gyi‑o bo̱rɔ ke̱mo̱ se̱ bo̱ nya ke̱dabe̱ na wuraa.” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yeesuu e̱ kpa Maataa na Mariya na Lasarus ase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","7","Amaa amo̱ pɛɛɛ gbaa, mò̱ a nya ŋkra fe̱yɛ Lasarus e̱ lɔ‑ɔ, ɔɔ kye̱na mfe̱ŋ ne̱ ɔ bo̱‑ɔ ŋke ŋnyɔ bo̱ tii si, pwɛɛ ne̱ ɔɔ dɛɛ tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Mo̱nꞌ sa a ane̱ kiŋŋi yɔ Yude̱ya swe̱e̱re̱ se̱ mfe̱ŋ ne̱ Lasarus bo̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ne̱ mò̱ agyase̱po̱‑ɔ a bise mò̱ fe̱yɛ, “Ɔkaapo̱po̱, Yudaa awuye a kpa a bo̱ twe̱e̱ abu bo̱ daye̱ fo̱ mɔɔ‑ɔ, a mo̱ŋ tɛɛ kyee, ne̱ fo̱ be̱e̱ fo̱ e̱ yɔ mfe̱ŋ mbe̱yɔmɔ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Kyɔwe̱ e̱ da e̱dɔŋhwe̱re̱e̱ kudu e̱nyɔ, bɛɛɛ n gye̱ ane̱ŋ ne̱e̱ e̱e̱e̱? Amo̱se̱‑ɔ ɔke̱maa ne̱ ɔ naa mpase̱‑ɔ maa da ke̱yaa pɛɛɛ, a le̱e̱ fe̱yɛ kyɔwe̱ a sa ne̱ to̱ŋ ke̱maa ke̱e̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Amaa mò̱ ya nare̱ kanye, ɔ da ke̱yaa a le̱e̱ fe̱yɛ ke̱laŋŋe̱rɔ mo̱ŋ bo̱‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yeesuu a tɔwe̱ amo̱‑ɔ, ne̱ ɔɔ be̱e̱ ba ako̱ bo̱ tii si fe̱yɛ, “Ane̱ nyare̱ Lasarus a di idi, amaa mo̱ e̱ yɔ a n kyiŋŋi mò̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ne̱ mò̱ agyase̱po̱‑ɔ a lee kanɔ fe̱yɛ, “Ane̱ nyaŋpe̱, mò̱ ya di idi fe̱raa, ɔ ko̱so̱ ŋkpa na alaŋfiya‑ro.” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ke̱tɔ ne̱ Yeesuu e̱ kaapo̱‑ɔ e̱ gye̱ fe̱yɛ Lasarus a wu, amaa mò̱ agyase̱po̱‑ɔ fe̱raa nyi fe̱yɛ Yeesuu yɛ idi mɔ ne̱ ɔke̱maa i di‑o ne̱ Lasarus a di. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","15","Ne̱ Yeesuu a kaapo̱‑rɔ gywii bamo̱ fe̱yɛ, “Lasarus a wu. Amaa mo̱ne̱ se̱‑ɔ, mo̱ akatɔ a gyi fe̱yɛ mo̱ a mo̱ŋ bo̱ mò̱ ase̱ saŋ amo̱. Amaa ane̱ ya yɔ mbe̱yɔmɔ‑ɔ, mo̱ne̱ e̱ kɔɔre̱ mo̱ a mo̱nꞌ gyi kase̱ŋtiŋ. Amo̱se̱ se̱‑ɔ mo̱nꞌ sa a ane̱ yɔ mò̱ ase̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas, ne̱ ɔ gye̱ ke̱le̱ŋba‑ɔ, a tɔwe̱ gywii mò̱ bɛɛko̱‑ana agyase̱po̱‑ɔ fe̱yɛ, “Mo̱nꞌ sa a ane̱ aa ɔkaapo̱po̱‑ɔ a yɔ, ne̱ amo̱ e̱ gye̱ lowi ne̱e̱ na ane̱ aa mò̱ a wu.” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yeesuu a kpa a ɔ fo̱ Lasarus‑ana aye̱‑ɔ, oo ŋu fe̱yɛ baa kyɔ pure Lasarus, ne̱ ŋke nna a kyo̱ŋ gbaa. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bɛtaniya na Yɛro̱salɛm e̱ waa e̱maye̱re̱ e̱nyɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ne̱ Yudaa awuye bwe̱e̱tɔ a ba Maataa na Mariya ase̱ a bo̱ bo̱ waa bamo̱ daane̱ke̱na bo̱ le̱e̱ bamo̱ pe̱nyare̱ a lowi‑o si. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Maataa a nu fe̱yɛ Yeesuu e̱ ba‑ɔ, ne̱ ɔɔ le̱e̱ a ɔ ya gyaŋŋaa mò̱. Amaa Mariya fe̱raa a sii lɔŋ‑nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ne̱ Maataa a tɔwe̱ gywii Yeesuu fe̱yɛ, “Mo̱ nyaŋpe̱, fo̱ dɛɛ fo̱ bo̱ mfe̱e̱ ne̱e̱, weetee mo̱ pe̱nyare̱ mo̱ŋ wu. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Amaa hare̱e̱ mbe̱yɔmɔ gbaa ŋ nyi fe̱yɛ Wuribware̱ e̱ sa fo̱ ke̱tɔ ke̱maa ne̱ fo̱ e̱ ko̱re̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Fo̱ pe̱nyare̱ i kyiŋŋi a ɔ le̱e̱ lowi‑ro.” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ne̱ oo lee kanɔ fe̱yɛ, “Ŋ nyi fe̱yɛ kake ne̱ ka gye̱ kaye̱ kɛɛ‑ɔ, o kyiŋŋi a ɔ le̱e̱ lowi‑ro.” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Mo̱ e̱ gye̱ ne̱ mo̱ i kyiŋŋi se̱sɛ a n le̱e̱ lowi‑ro, na n sa mò̱ ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ. Amo̱se̱ se̱‑ɔ ɔke̱maa ne̱ ɔ kɔɔre̱ mo̱ o gyi‑o, hare̱e̱ gbaa mò̱ ya wu, ɔ be̱e̱ o kyiŋŋi a ɔ bo̱ kye̱na kyure. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ne̱ mò̱ i de ane̱ŋ a ŋkpa‑ɔ, ne̱ mò̱ ya kɔɔre̱ mo̱ gyi, ɔ maa lɛɛ gyi awo̱re̱fɔɔ pɛɛɛ. Fo̱ e̱ kɔɔre̱ amo̱‑ɔ fo̱ i gyi aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ne̱ Maataa a lee kanɔ fe̱yɛ, “Mo̱ e̱ kɔɔre̱ mo̱ i gyi fe̱yɛ fo̱ e̱ gye̱ Kristoo, Wuribware̱ mò̱ gyi‑o, ne̱ Wuribware̱ yɛ o suŋ a ɔ bo̱ kyo̱ŋwe̱ kaye̱‑rɔ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Maataa a tɔwe̱ amo̱‑ɔ, ne̱ oo kiŋŋi ya te̱e̱ mò̱ tire Mariya keri si tɔwe̱ gywii mò̱ fe̱yɛ, “Ɔkaapo̱po̱‑ɔ bo̱ mfe̱e̱, ɔ te̱e̱ fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mariya a nu amo̱‑ɔ, ne̱ ɔɔ ko̱so̱ le̱e̱ me̱naŋ a ɔ ya gyaŋŋaa Yeesuu. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yeesuu mo̱ŋ tɛɛ fo̱ maŋ‑ɔ‑rɔ, ɔ saŋ ɔ bo̱ mfe̱ŋ ne̱ Maataa a gyaŋŋaa mò̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ne̱ ase̱sɛ ne̱ bo̱ te Mariya ase̱ ba waa mò̱ daane̱ke̱na‑ɔ a gya mò̱ se̱. Saŋ ne̱ baa ŋu fe̱yɛ ɔɔ ko̱so̱ me̱naŋ le̱e̱‑ɔ, bo̱ nyi fe̱yɛ ɔ yɔ ke̱gye̱raŋta‑ɔ ase̱ a ɔ ya su ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ne̱ Mariya a fo̱ mfe̱ŋ ne̱ Yeesuu bo̱‑ɔ, mò̱ a de̱ŋ ŋu Yeesuu‑o, ne̱ oo kpuni aŋurii mò̱ akatɔ‑rɔ, ne̱ ɔ yɛ, “Mo̱ nyaŋpe̱, fo̱ dɛɛ fo̱ bo̱ mfe̱e̱ ne̱e̱, weetee mo̱ pe̱nyare̱ mo̱ŋ wu.” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yeesuu a ŋu ane̱ŋ ne̱ Mariya i su‑o na ase̱sɛ ne̱ bo̱ gya mò̱ se̱‑ɔ i su‑o, ne̱ mò̱ bo̱re̱‑rɔ a duŋwi mò̱, ne̱ aa waa mò̱ e̱wɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ne̱ oo bise bamo̱ fe̱yɛ, “Mfe̱ne̱ ne̱ mo̱ne̱ a pure mò̱?” Ne̱ bo̱ yɛ, “Ane̱ nyaŋpe̱, bo̱ ke̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ne̱ Yeesuu a su. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ne̱ ase̱sɛ‑ɔ yɛ, “Mo̱nꞌ ke̱e̱ ke̱kpa de̱maŋte̱ ne̱ ɔ kpa mò̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ne̱ bamo̱ bo̱ko̱ yɛ, “Ne̱e̱ mò̱ ya buŋŋi te̱napo̱ a akatɔ‑ɔ, bɛɛɛ? Ne̱ nte̱tɔ ne̱e̱ ne̱ ɔ mo̱ŋ taare̱ kuŋ Lasarus na ɔ ma wu?” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yeesuu bo̱re̱‑rɔ a be̱e̱ duŋwi mò̱, ne̱ ɔɔ yɔ ke̱gye̱raŋta‑ɔ ase̱. Baa seri ke̱gye̱raŋta amo̱ ke̱fo̱re̱‑rɔ ne̱e̱ fe̱yɛ ke̱kyaŋ‑ɔ, ne̱ baa taa ke̱fo̱re̱ bo̱ kpuse ke̱mo̱ kanɔ fe̱yɛ po̱ne̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱nꞌ taye̱ ke̱fo̱re̱‑ɔ le̱e̱‑rɔ.” Ne̱ Lasarus mò̱ pe̱kye̱e̱ Maataa yɛ, “Mo̱ nyaŋpe̱, ane̱ ya taye̱ ke̱fo̱re̱‑ɔ, ane̱ i nu sɔ bɔye̱. Bamo̱ a pure mò̱‑ɔ, ndɔɔ ŋke nna ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ne̱ Yeesuu a tɔwe̱ gywii Maataa fe̱yɛ, “N kyɔ mo̱ŋ tɔwe̱ gywii fo̱ fe̱yɛ, fo̱ ya kɔɔre̱ mo̱ gyi, fo̱ i ŋu ane̱ŋ ne̱ Wuribware̱ a ke̱dabe̱‑ɔ du‑o ooo?” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ne̱ baa taye̱ ke̱fo̱re̱‑ɔ le̱e̱ ke̱gye̱raŋta‑ɔ kanɔ. Ne̱ Yeesuu a de̱e̱re̱ so̱so̱, ne̱ ɔ yɛ, “N se̱, mo̱ e̱ sa fo̱ aŋsɛ fe̱yɛ fo̱ a nu mo̱ ke̱bware̱ko̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ŋ nyi fe̱yɛ fo̱ kyɔ fo̱ i nu mo̱ ke̱bware̱ko̱re̱ saŋ ke̱maa, amaa ase̱sɛ ne̱ bo̱ bo̱ mfe̱e̱‑ɔ se̱ ne̱ mo̱ a tɔwe̱ amo̱‑ɔ, na bo̱ nya kɔɔre̱ gyi fe̱yɛ fo̱ ya suŋ mo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mò̱ a tɔwe̱ amo̱‑ɔ lo̱we̱‑ɔ, ne̱ ɔɔ te̱e̱ keŋkeŋ bo̱ kyo̱ŋwe̱ fe̱yɛ, “Lasarus eee! Le̱e̱ ke̱gye̱raŋta‑ɔ‑rɔ ba!” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ne̱ olowipo̱‑ɔ a le̱e̱ ba, ɔɔ le̱e̱ na kyefuri ŋure mò̱ asare̱e̱ na mò̱ ayaa se̱, na kaprakɛɛ i ŋure mò̱ akatɔ se̱. Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱nꞌ saŋŋe̱ mò̱ a ɔ nare̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ase̱sɛ bwe̱e̱tɔ ne̱ baa ba a bo̱ bo̱ waa Mariya daane̱ke̱na‑ɔ a ŋu akpe̱ŋe̱ye̱e̱tɔ ne̱ Yeesuu a waa‑ɔ, ne̱ baa kɔɔre̱ mò̱ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Amaa bamo̱ bo̱ko̱ a kiŋŋi yɔ Farisii awuye ase̱ ya tɔwe̱ ke̱tɔ ne̱ Yeesuu a waa‑ɔ gywii bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Amo̱se̱ se̱‑ɔ ne̱ Farisii awuye‑o na Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ a te̱e̱ maŋ abre̱sɛ bo̱ gyaŋŋe̱. Bamo̱ a gyaŋŋe̱‑ɔ, ne̱ bo̱ yɛ, “E̱me̱ne̱ ne̱ ane̱ e̱ waa? Mo̱nꞌ ke̱e̱ akpe̱ŋe̱ye̱e̱tɔ mɔ pɛɛɛ ne̱ ɔnyare̱ mɔ e̱ waa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ane̱ ya yɔwe̱ mò̱, ne̱ ɔ kya se̱ mfaanɛɛ, ɔke̱maa e̱ kɔɔre̱ mò̱ o gyi. Na Roma awuye ba bo̱ ye̱re̱ amo̱ se̱, na bo̱ bwee Wuribware̱ suŋkpa mɔ, na bo̱ kpuri ane̱ maŋ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ne̱ bamo̱‑rɔ ɔko̱ ne̱ ba te̱e̱ mò̱ ɛ Kayafas ne̱ ɔ gye̱ Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ kasu amo̱‑rɔ‑ɔ yɛ, “Mo̱ne̱ mo̱ŋ nyi sɛye̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mo̱ne̱ mo̱ŋ nyi fe̱yɛ mo̱ne̱ ya sa ne̱ nyiŋkpasɛ ko̱ŋko̱ a wu sa ase̱sɛ pɛɛɛ, a bɔ fe̱yɛ mo̱ne̱ a sa ne̱ maŋ‑ɔ pɛɛɛ a kpuri aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kase̱ŋtiŋ si fe̱raa, n gye̱ mò̱ fɔŋfɔŋ ke̱yaale̱ŋ se̱ ne̱ ɔɔ tɔwe̱ amo̱‑ɔ. Amaa ane̱ŋ ne̱ ɔ gye̱ Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ‑ɔ kasu amo̱‑rɔ‑ɔ se̱, ɔ tɔwe̱ ne̱e̱ fe̱yɛ Yeesuu e̱ ba a ɔ bo̱ wu sa kade̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Amaa n gye̱ kade̱‑ɔ wo̱re̱, amaa na bamo̱ aa Wuribware̱ ase̱sɛ ne̱ baa brawe̱‑rɔ‑ɔ tii abɛɛ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Le̱e̱ saŋ amo̱ bo̱ yɔ, ne̱ baa da kikpuni fe̱yɛ bo̱ mɔɔ Yeesuu. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Amo̱se̱ se̱‑ɔ Yeesuu mo̱ŋ lɛɛ tu kpa Yude̱ya a e̱maŋ‑ɔ‑rɔ ane̱ŋ ne̱ ase̱sɛ i ŋu mò̱‑ɔ, amaa ɔɔ le̱e̱ mfe̱ŋ yɔ to̱ŋ ko̱ ne̱ a maa kimukee‑o yɔ maŋ ko̱ ne̱ ba te̱e̱ ɛ Ifarim‑o, mfe̱ŋ ne̱ mò̱ aa mò̱ agyase̱po̱‑ɔ a kye̱na kafwe̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yudaa awuye kigyibe̱e̱ ne̱ ba te̱e̱ ɛ Wuribware̱-a‑kya-ane̱-yɔwe̱‑ɔ a tɔ‑rɔ, ne̱ ase̱sɛ bwe̱e̱tɔ a le̱e̱ bamo̱ e̱maŋ se̱ yɔ Yɛro̱salɛm maŋ‑nɔ a bo̱ gye̱ ŋkpɛɛ ya gyee, na bo̱ fwe̱e̱ bamo̱ atɔ buŋsɛ pwɛɛ a bo̱ dɛɛ taare̱ ya gyi ateese‑o. N gye̱ ane̱ŋ, bamo̱ iyisi e̱ nye̱ra bamo̱ mbo̱ ne̱ baa baa bo̱ lɔŋŋɔ Wuribware̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ne̱ ba buwi ba kpa Yeesuu, ne̱ baa gyaŋŋe̱ Wuribware̱ suŋkpa‑ɔ kabuno. Mfe̱ŋ ne̱ baa bise abɛɛ fe̱yɛ, “Ane̱ e̱ fa fe̱yɛ ɔ ba kigyibe̱e̱ mɔ‑rɔ, bɛɛɛ ɔ maa ba aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ke̱tɔ se̱ ne̱ baa tɔwe̱ ane̱ŋ‑ɔ e̱ gye̱ fe̱yɛ Wuribware̱ alɔŋŋɔpo̱‑ɔ na Farisii awuye‑o a sa kanɔ fe̱yɛ ɔke̱maa ne̱ o nyi mfe̱ŋ ne̱ Yeesuu bo̱‑ɔ, bo̱ tɔwe̱ gywii bamo̱, na bo̱ nya ya kra mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ŋke nsiye a saŋ a bo̱ gyaŋŋe̱ gyi Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese‑o, ne̱ Yeesuu a yɔ Bɛtaniya kamaŋgyii, ne̱ Yeesuu a kyiŋŋi Lasarus le̱e̱ lowi‑ro‑o‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ne̱ baa waa ateese mfe̱ŋ sa mò̱. Lasarus mò̱ pe̱kye̱e̱, Maataa, e̱ gye̱ ne̱ ɔ waa ke̱tɔ ke̱maa ɔ sa bamo̱ gyikpa. Lasarus tii bamo̱ ne̱ bamo̱ aa Yeesuu te ba gyi ateese‑o si. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ne̱ Lasarus mò̱ pe̱kye̱e̱ nyɔse̱po̱ Mariya a taa laŋpe̱ŋtaa kɔne̱kɔne̱sɛ ko̱ praŋto̱wa bo̱rɔ, ne̱ mò̱ yawo̱ bo̱ le̱ŋ bwe̱e̱tɔ‑ɔ bo̱ twiiri we̱e̱ Yeesuu ayaa se̱, ne̱ ɔɔ taa mò̱ ipwii o de ɔ kpɛɛ. Ne̱ laŋpe̱ŋtaa‑ɔ sɔ kɔne̱kɔne̱sɛ a kɔɔre̱ lɔŋ amo̱ pɛɛɛ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ne̱ Yeesuu agyase̱po̱‑ɔ ɔko̱ ne̱ ba te̱e̱ ɛ Yudas Kariyotinyi‑o, mò̱ e̱ gye̱ ne̱ ɔ ba a ɔ bo̱ gyi Yeesuu kidiburo‑o, a tɔwe̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Nte̱tɔ se̱ ne̱ ɔkye̱e̱ mɔ a nye̱ra laŋpe̱ŋtaa mɔ ne̱ ba taare̱ a bo̱ fe mò̱ siidii ŋkpe̱ŋ nna, na bo̱ taa atanne̱‑ɔ bo̱ sa atiripo̱‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Mò̱ a tɔwe̱ amo̱‑ɔ, n gye̱ sa ne̱ atiripo̱ ase̱ŋ e̱ gye̱ ne̱ a tiri mò̱, amaa bo̱ le̱e̱ ane̱ŋ ne̱ ɔ gye̱ oyu‑o si. Mò̱ ase̱ ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ atanne̱ bo̱, amaa mò̱‑ɔ mɔ i ywii amo̱ ako̱ o gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ne̱ Yeesuu yɛ, “Mo̱nꞌ yɔwe̱ ɔkye̱e̱ amo̱! Mo̱nꞌ sa a ɔ waa ke̱tɔ ne̱ ɔ waa‑ɔ. A le̱e̱ fe̱yɛ ɔɔ taa laŋpe̱ŋtaa mɔ bo̱ be̱ya sa mo̱, na kake nsi ne̱ mo̱ i wu‑o, ɔ taare̱ a ɔ lɔŋŋɔ mo̱ kayo̱wɔre̱, na bo̱ pure mo̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Na atiripo̱ fe̱raa, mo̱ne̱ aa bamo̱ e̱ bo̱‑rɔ kake ke̱maa, amaa m fe̱raa, mo̱ aa mo̱ne̱ maa kye̱na a bo̱ yɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ne̱ ase̱sɛ bwe̱e̱tɔ a nu fe̱yɛ Yeesuu bo̱ Bɛtaniya kamaŋgyii‑ro, amaa n gye̱ Yeesuu wo̱re̱ se̱ ne̱ baa yɔ mfe̱ŋ, amaa baa yɔ a bo̱ ya ŋu Lasarus ne̱ Yeesuu a kyiŋŋi le̱e̱ lowi‑ro‑o ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Amo̱se̱‑ɔ ne̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ a da Lasarus kuŋu si kikpuni fe̱yɛ bo̱ mɔɔ mò̱ gbaa mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","A le̱e̱ fe̱yɛ ane̱ŋ mɔ ne̱ Yeesuu a waa‑ɔ se̱‑ɔ, Yudaa awuye‑o bwe̱e̱tɔ a le̱e̱ ba kine bamo̱ Wuribware̱ alɔŋŋɔpo̱‑ɔ, ne̱ ŋkee ba kɔɔre̱ Yeesuu ba gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kaye̱ ŋke‑o, ne̱ ase̱sɛ ne̱ baa ba Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese kigyibe̱e̱‑ɔ‑rɔ‑ɔ a nu fe̱yɛ Yeesuu e̱ ba Yɛro̱salɛm maŋ‑nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Amo̱se̱ se̱‑ɔ ne̱ baa ŋeri mbeŋ afe̱raa, ne̱ baa ya gyaŋŋaa mò̱. Na ba fɛɛ‑rɔ fe̱yɛ, “Mo̱nꞌ sa a ane̱ da Wuribware̱ kakyirele. Wuribware̱ yure mò̱ ne̱ ɔ ba mò̱ ke̱nyare̱‑rɔ‑ɔ. Wuribware̱ yure ane̱ Isireelii swe̱e̱re̱ se̱ owure.” ");
INSERT INTO ncuNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ne̱ Yeesuu a ŋu kakurumagyii ko̱ ye̱re̱, ne̱ ɔɔ de̱e̱ kye̱na se̱, fe̱yɛ ane̱ŋ ne̱ abware̱se̱ŋ wo̱re̱‑ɔ a de̱ŋ tɔwe̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Mo̱ne̱ ɔke̱maa ne̱ o te Yɛro̱salɛm maŋ‑nɔ‑ɔ! Mo̱nꞌ sa a mo̱ne̱ akatɔ gyi. Mo̱nꞌ ke̱e̱ mo̱ne̱ owure a de̱e̱ kakurumagyii ɔ ba.” ");
INSERT INTO ncuNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Saŋ ne̱ ɔɔ waa amo̱‑ɔ, mò̱ agyase̱po̱‑ɔ mo̱ŋ nu kaase̱. Amaa saŋ ne̱ Yeesuu a wu, ne̱ oo kyiŋŋi o yii Wuribware̱ se̱‑ɔ, ne̱ baa nyiŋŋi si fe̱yɛ abware̱se̱ŋ wo̱re̱‑ɔ a kyɔ tɔwe̱ mò̱ ase̱ŋ amo̱, ne̱ bo̱ yɛ, “Ane̱ŋ ne̱ ane̱ a waa‑ɔ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ne̱ ase̱sɛ ne̱ bo̱ bo̱ Yeesuu ase̱ saŋ ne̱ ɔɔ te̱e̱ Lasarus le̱e̱ ke̱gye̱raŋta‑rɔ, ne̱ oo kyiŋŋi mò̱ le̱e̱ lowi‑ro‑o, a le̱e̱ tɔwe̱ ke̱tɔ ne̱ baa ŋu‑o. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Amo̱ ya sa ne̱ ase̱sɛ bwe̱e̱tɔ a yɔ ya gyaŋŋaa Yeesuu kpa‑rɔ‑ɔ. Baa nu le̱e̱ bo̱ko̱‑ɔ ase̱ fe̱yɛ mò̱ ya waa ane̱ŋ a akpe̱ŋe̱ye̱e̱tɔ mɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ne̱ Farisii awuye‑o e̱ tɔwe̱ ba gywii abɛɛ fe̱yɛ, “Mo̱ne̱ a ŋu aaa? Ane̱ ase̱ŋ‑ɔ maa kpa a a kra pɛɛɛ‑ɔ. Mo̱nꞌ ke̱e̱ fe̱yɛ kaye̱‑rɔ ase̱sɛ pɛɛɛ a gya mò̱ se̱!” ");
INSERT INTO ncuNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Amɔ Griiki awuye‑o bo̱ko̱ tii bamo̱ ne̱ baa yɔ Yɛro̱salɛm maŋ‑nɔ ya suŋ Wuribware̱ saŋ ne̱ ba gyi Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese‑o si. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ne̱ baa ba Filipo ase̱, ne̱ bo̱ yɛ, “Ɔbre̱sɛ, ane̱ e̱ kpa a ane̱ ŋu Yeesuu ne̱e̱.” (Filipo mɔ gye̱ Yeesuu agyase̱po̱‑ɔ ɔko̱, ne̱ ɔɔ le̱e̱ Bɛtɛsaye̱da maŋ‑nɔ Galile̱ya swe̱e̱re̱ se̱ ne̱e̱.) ");
INSERT INTO ncuNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ne̱ Filipo a ya tɔwe̱ gywii Andruu, ne̱ bamo̱ abɛɛ anyɔ a ya tɔwe̱ ke̱tɔ ne̱ ase̱sɛ amo̱ e̱ kpa‑ɔ gywii Yeesuu. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ne̱ Yeesuu a tɔwe̱ fe̱yɛ, “Mo̱, dimaadi mò̱ gyi‑o, saŋ a fo̱ fe̱yɛ bo̱ sa mo̱ ke̱dabe̱ na wuraa. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ ke̱yaabraagyi ya sii atɔ‑rɔ, ke̱ maa waa sɛye̱, amaa ke̱mo̱ ya le̱e̱ da e̱se̱‑rɔ fe̱raa, ke̱ e̱ kwɛɛ, na kigyi de̱daa‑ɔ wu na ke̱po̱pwɛɛ‑ɔ daŋ ko̱we̱ ayaabraagyi bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ane̱ŋ dɛɛ ne̱ ɔke̱maa ne̱ ɔ kpa mò̱ fɔŋfɔŋ ŋkpa bwe̱e̱tɔ‑ɔ e̱ paŋ mmo̱ ne̱e̱. Ɔke̱maa mɔ ne̱ mò̱ fɔŋfɔŋ ŋkpa ase̱ŋ mo̱ŋ tiri mò̱ bwe̱e̱tɔ kaye̱ mɔ‑rɔ‑ɔ e̱ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ɔke̱maa ne̱ ɔ kpa fe̱yɛ o suŋ sa mo̱‑ɔ, amo̱ fe̱raa ɔ gya mo̱ se̱, na o nu mo̱ kanɔ. Na mò̱ ne̱ o suŋ ɔ sa mo̱‑ɔ ba bo̱ tii mo̱ se̱, na ɔ yɔ to̱ŋ ke̱maa ne̱ mo̱ e̱ yɔ‑ɔ. Ɔke̱maa ne̱ o suŋ ɔ sa mo̱‑ɔ, n se̱ Wuribware̱ e̱ bo̱nyaa mò̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Mbe̱yɔmɔ mo̱ kakpo̱nɔ‑rɔ a nye̱ra. Amɔ n tɔwe̱ gywii n se̱ a o kuŋ ase̱ŋ mɔ ne̱ a kpa a ba mo̱ se̱‑ɔ bɛɛɛ? Daabii! Amo̱ se̱ ne̱ mo̱ a ba. Mo̱ a ba ne̱e̱ a m bo̱ gyi faanɛɛ a awo̱re̱fɔɔ mɔ, na ŋ wu saŋ ko̱ŋko̱ mɔ‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ne̱ ɔɔ ko̱re̱ ke̱bware̱ko̱re̱ fe̱yɛ, “N se̱, sa a fo̱ nya ke̱nyare̱ dabe̱ na wuraa.” Puri amo̱‑rɔ, ne̱ oo nu bo̱re̱ ko̱ le̱e̱ so̱so̱ fe̱yɛ, “Mo̱ a nya ke̱nyare̱ dabe̱ na wuraa, na m be̱e̱ sa a ŋ nya.” ");
INSERT INTO ncuNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ase̱sɛ ne̱ bo̱ ye̱re̱ mfe̱ŋ‑ɔ a nu bo̱re̱‑ɔ, ne̱ bamo̱ bo̱ko̱ yɛ baa nu ne̱e̱ fe̱yɛ bware̱ a su‑ro. Ne̱ bo̱ko̱ mɔ yɛ, “Wuribware̱ kabɔɔ ya sa se̱ŋsa gywii mò̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Amaa Yeesuu a tɔwe̱ gywii bamo̱ ne̱e̱ fe̱yɛ, “N gye̱ mo̱ se̱ ne̱ bo̱re̱ mɔ ne̱ mo̱ne̱ a nu mò̱ le̱e̱ so̱so̱‑ɔ a sa se̱ŋsa, amaa mo̱ne̱ se̱ ne̱ ɔɔ sa na mo̱nꞌ nya nu. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Mbe̱yɔmɔ e̱ gye̱ saŋ ne̱ Wuribware̱ i gyi kaye̱‑rɔ ase̱sɛ ase̱ŋ, na o tu Ɔbɔnsam ne̱ bo̱ fo̱ mbe̱yɔmɔ o de kaye̱‑rɔ ase̱sɛ mfɛɛre̱ se̱ ke̱yaale̱ŋ‑ɔ le̱e̱ mò̱ ke̱yaale̱ŋ‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Bamo̱ ya yase̱ mo̱ so̱so̱, mo̱ i gyiiri ase̱sɛ pɛɛɛ a m baa mo̱ ase̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Mò̱ a tɔwe̱ amo̱‑ɔ, ase̱sɛ e̱ ye̱re̱ amo̱ se̱ a bo̱ bo̱ pini lowi suyo ne̱ ɔ ba a ɔ bo̱ wu‑o. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ne̱ ase̱sɛ‑ɔ a lee kanɔ fe̱yɛ, “A bo̱ Wuribware̱ mbraa a wo̱re̱‑ɔ‑rɔ fe̱yɛ Kristoo‑o e̱ kye̱na nsu pɛɛɛ. Ne̱ e̱me̱ne̱ se̱ ne̱ fo̱ e̱ tɔwe̱ fe̱yɛ a tiri fe̱yɛ bo̱ yase̱ dimaadi mò̱ gyi‑o so̱so̱? Ne̱ ŋkee, nsɛ e̱ gye̱ dimaadi mò̱ gyi ne̱ fo̱ e̱ tɔwe̱ mò̱ ase̱ŋ‑ɔ ne̱e̱? Fo̱ fɔŋfɔŋ ase̱ŋ ne̱ fo̱ e̱ tɔwe̱, bɛɛɛ ɔko̱‑ɔ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “N du fe̱yɛ ke̱laŋŋe̱rɔ‑ɔ. Ke̱laŋŋe̱rɔ‑ɔ e̱ laŋŋe̱ mo̱ne̱‑rɔ a ki kyee kafwe̱e̱. Ane̱ŋ se̱‑ɔ, mo̱nꞌ kya mo̱ne̱ kpa se̱ nare̱ nsaŋ ne̱ ke̱laŋŋe̱rɔ bo̱‑rɔ‑ɔ, na kibugyii ma nya da mo̱ne̱ kpa‑rɔ. A le̱e̱ fe̱yɛ ɔke̱maa ne̱ ɔ naa kibugyii‑ro‑o mo̱ŋ nyi mfe̱ŋ ne̱ ɔ yɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Amo̱se̱, mo̱ a saŋ m bo̱ mo̱ne̱ ase̱‑ɔ, mo̱nꞌ kɔɔre̱ mo̱ gyi, na mo̱nꞌ nya kii ase̱sɛ ne̱ bo̱ te ke̱laŋŋe̱rɔ‑ɔ‑rɔ‑ɔ.” Yeesuu a tɔwe̱ amo̱‑ɔ kamɛɛ‑rɔ, ne̱ ɔɔ le̱e̱ mfe̱ŋ ya kwe̱e̱rɔ bamo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Amaa ɔɔ waa akpe̱ŋe̱ye̱e̱tɔ bwe̱e̱tɔ, ne̱ bamo̱ akatɔ a ŋu, amo̱ pɛɛɛ gbaa bo̱ mo̱ŋ kɔɔre̱ mò̱ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ane̱ŋ ne̱ Wuribware̱ kyaamɛɛ Isaya ne̱ ɔɔ dɛɛ kye̱na‑ɔ a tɔwe̱‑ɔ a ba‑rɔ kase̱ŋtiŋ fe̱yɛ, “Wuribware̱, ɔko̱ bo̱‑rɔ ne̱ ɔɔ kɔɔre̱ ase̱ŋ ne̱ ane̱ a tɔwe̱‑ɔ gyi aaa? Ne̱ ɔko̱ bo̱‑rɔ ne̱ fo̱ a sa ne̱ oo ŋu ane̱ŋ ne̱ fo̱ e̱ kaapo̱ fo̱ ke̱yaale̱ŋ de̱maŋte̱‑ɔ ɔɔɔ?” ");
INSERT INTO ncuNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Isaya a tɔwe̱ ke̱tɔ se̱ ne̱ bo̱ mo̱ŋ taare̱ kɔɔre̱ gyi‑o, ɔ yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Wuribware̱ a buŋ bamo̱ akatɔ se̱, ne̱ ɔɔ sa ne̱ bamo̱ aŋu‑ro a waa le̱ŋ, Le̱e̱ ane̱ŋ se̱‑ɔ, bamo̱ akatɔ maa buŋŋi a bo̱ ŋu atɔ, ne̱ bamo̱ mfɛɛre̱ maa sa a bo̱ nu ase̱ŋ kaase̱, ne̱ bo̱ maa nu bamo̱ e̱ye̱e̱, na ɔ taa bamo̱ e̱bɔye̱ bo̱ ke bamo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ke̱tɔ se̱ ne̱ Isaya a tɔwe̱ amo̱‑ɔ e̱ gye̱ fe̱yɛ oo ŋu Yeesuu ke̱yaale̱ŋ ne̱ ko̱ kyɔ‑ɔ, ne̱ ɔɔ tɔwe̱ mò̱ ase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Amo̱‑ɔ pɛɛɛ gbaa Yudaa awuye abre̱sɛ‑ɔ bwe̱e̱tɔ a kɔɔre̱ mò̱ gyi, amaa Farisii awuye‑o si‑o kufu de bamo̱, amo̱se̱ se̱‑ɔ bo̱ mo̱ŋ lee amo̱ kawu. Kufu de bamo̱ fe̱yɛ bamo̱ ya tɔwe̱ amo̱ ase̱ŋ kawu si, Farisii awuye‑o maa lɛɛ sa bamo̱ kpa a bo̱ lwee bamo̱ ke̱bware̱ko̱re̱kyaŋ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ba kpa ase̱sɛ nkyo̱rɔ bo̱ kyo̱ŋ Wuribware̱ nkyo̱rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ne̱ Yeesuu a yase̱ mò̱ bo̱re̱ tɔwe̱ fe̱yɛ, “Ɔke̱maa ne̱ ɔ kɔɔre̱ mo̱ o gyi‑o, n gye̱ mo̱ wo̱re̱ ne̱ ɔ kɔɔre̱ o gyi, amaa ɔ kɔɔre̱ n se̱ ne̱ oo suŋ mo̱‑ɔ gbaa o gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ane̱ŋ dɛɛ ne̱ ɔke̱maa ne̱ o ŋu mo̱‑ɔ i ŋu mò̱ ne̱ oo suŋ mo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mo̱ a ba kaye̱‑rɔ fe̱yɛ ke̱laŋŋe̱rɔ‑ɔ ne̱e̱, na ɔke̱maa ne̱ ɔ kɔɔre̱ mo̱ o gyi‑o ma nya sii kibugyii‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Amaa ɔke̱maa ne̱ o nu mo̱ ase̱ŋ, ne̱ ɔ maa bu amo̱‑ɔ, n gye̱ mo̱ e̱ gye̱ ne̱ mo̱ i bu mò̱ ke̱pɔ, a le̱e̱ fe̱yɛ mo̱ŋ ba ne̱e̱ a m bo̱ bu kaye̱‑rɔ ase̱sɛ ke̱pɔ. Mo̱ a ba ne̱e̱ a m bo̱ mo̱rɔwe̱ bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","To, se̱sɛ ne̱ o kine mo̱, ne̱ ɔ maa gya mo̱ kanɔ se̱‑ɔ de ɔko̱ ne̱ o bu mò̱ ke̱pɔ‑ɔ. Mò̱ e̱ gye̱ Wuribware̱ ne̱ mo̱ a tɔwe̱ mò̱ ase̱ŋ‑ɔ. Mò̱ e̱ gye̱ ne̱ o bu mò̱ ke̱pɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","N gye̱ mo̱ fɔŋfɔŋ ke̱yaale̱ŋ se̱ ne̱ mo̱ a tɔwe̱, amaa n se̱ ne̱ oo suŋ mo̱‑ɔ ya sa mo̱ kanɔ fe̱yɛ n tɔwe̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mbe̱yɔmɔ ŋ nyi fe̱yɛ ɔke̱maa ne̱ mò̱ ya nu n se̱ kanɔ‑ɔ e̱ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ. Amo̱se̱‑ɔ, ke̱tɔ ne̱ mo̱ e̱ tɔwe̱‑ɔ e̱ gye̱ ane̱ŋ ne̱ n se̱ a tɔwe̱ gywii mo̱ fe̱yɛ n tɔwe̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Amo̱ a saŋ kake ko̱ŋko̱ a bo̱ gyi Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese‑o, Yeesuu a nyi fe̱yɛ mò̱ saŋ‑ɔ a fo̱ fe̱yɛ ɔ le̱e̱ kaye̱ mɔ‑rɔ yɔ mò̱ se̱ ase̱‑ɔ. Ɔɔ kpa mò̱ agyase̱po̱‑ɔ ase̱ŋ saŋ ke̱maa, a le̱e̱ fe̱yɛ bo̱ gye̱ mò̱ fɔŋfɔŋ ase̱sɛ kaye̱ mɔ‑rɔ. Ne̱ mbe̱yɔmɔ ɔ ba a ɔ bo̱ kaapo̱ bamo̱ ane̱ŋ ne̱ ɔ kpa bamo̱ bwe̱e̱tɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ a te ba gyi ke̱de̱e̱pwɛta a ateese‑o, Ɔbɔnsam a kyɔ bo̱ lwee bamo̱ ɔko̱ ne̱ ba te̱e̱ mò̱ ɛ Yudas, Simɔŋ Kariyotinyi mò̱ gyi‑o, kakpo̱nɔ‑rɔ fe̱yɛ o gyi Yeesuu kidiburo. ");
INSERT INTO ncuNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yeesuu mɔ nyi fe̱yɛ mò̱ se̱ a sa mò̱ ke̱yaale̱ŋ ke̱tɔ ke̱maa se̱, ne̱ o nyi fe̱yɛ ɔɔ le̱e̱ Wuribware̱ ase̱ ne̱e̱, ne̱ ɔ be̱e̱ ɔ yɔ mò̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Amo̱‑ɔ pɛɛɛ gbaa Yeesuu a ko̱so̱ teeburi ase̱ ye̱re̱, ne̱ oo buŋŋi mò̱ waagya na kaare̱ ne̱ o buŋ‑o, ne̱ ɔɔ mare̱ brɔde̱baa laare̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ne̱ oo twiiri nkyu waa ke̱baa‑rɔ, ne̱ ɔɔ le̱e̱ ɔ fwe̱e̱ mò̱ agyase̱po̱‑ɔ ayaa se̱, na o de brɔde̱baa ne̱ ɔɔ mare̱ laare̱‑rɔ‑ɔ o de ɔ kpɛɛ bamo̱ ayaa se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ne̱ ɔɔ waa ane̱ŋ‑aaa bo̱ fo̱ Simɔŋ Peetroo si, ne̱ Simɔŋ Peetroo a bise mò̱ fe̱yɛ, “Fo̱ gye̱ mo̱ nyaŋpe̱ ne̱e̱. Ne̱ e̱me̱ne̱ se̱ ne̱ fo̱ e̱ kpa a fo̱ fwe̱e̱ mo̱ ne̱ n gye̱ fo̱ ɔgyase̱po̱‑ɔ ayaa se̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Mbe̱yɔmɔ fo̱ maa nu ke̱tɔ ne̱ mo̱ e̱ waa‑ɔ kaase̱, amaa kamɛɛ‑rɔ fo̱ e̱ ba a fo̱ bo̱ nu kaase̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ne̱ Peetroo a tɔwe̱ gywii Yeesuu fe̱yɛ, “Fo̱ ma fwe̱e̱ mo̱ ayaa mɔ se̱ daa!” Ne̱ Yeesuu yɛ, “Fo̱ e̱ mo̱ŋ sa a m fwe̱e̱ fo̱ ayaa se̱, amo̱ fe̱raa fo̱ maa lɛɛ tii mo̱ agyase̱po̱‑ɔ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ne̱ Simɔŋ Peetroo a lee kanɔ fe̱yɛ, “To, mo̱ nyaŋpe̱, amo̱ fe̱raa n gye̱ mo̱ ayaa se̱ wo̱re̱ ne̱ fo̱ e̱ fwe̱e̱, fwe̱e̱ mo̱ asare̱e̱ se̱ na mo̱ kuŋu‑ro gbaa bo̱ tii si!” ");
INSERT INTO ncuNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ne̱ Yeesuu yɛ, “Ɔke̱maa ne̱ ɔɔ kyɔ gyee‑o mo̱ŋ de iyisi pɛɛɛ, amo̱se̱ se̱‑ɔ, a mo̱ŋ lɛɛ a tiri fe̱yɛ o gyee, amɔ ayaa se̱ ke̱fwe̱e̱ wo̱re̱. Mo̱ne̱ pɛɛɛ ŋkpo̱nɔ‑rɔ mo̱ŋ lɛɛ n de iyisi, amɔ mo̱ne̱‑rɔ ɔko̱ŋko̱ wo̱re̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ke̱tɔ se̱ ne̱ Yeesuu a tɔwe̱ fe̱yɛ, “Mo̱ne̱ pɛɛɛ ŋkpo̱nɔ‑rɔ mo̱ŋ lɛɛ n de iyisi, amɔ mo̱ne̱‑rɔ ɔko̱ŋko̱ wo̱re̱”‑ɔ e̱ gye̱ fe̱yɛ ɔ kyɔ o nyi mò̱ ne̱ ɔ kpa a o gyi mò̱ kidiburo‑o. ");
INSERT INTO ncuNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yeesuu a fwe̱e̱ bamo̱ ayaa se̱ lo̱we̱‑ɔ, ne̱ ɔɔ taa mò̱ kaare̱‑ɔ na mò̱ waagya‑ɔ be̱e̱ buŋ, ne̱ oo kiŋŋi ya kye̱na mò̱ kye̱nakpa teeburi ase̱. Ne̱ oo bise mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Ane̱ŋ mɔ ne̱ mo̱ a waa mo̱ne̱‑ɔ, mo̱ne̱ a nu kaase̱ aaa?” Ne̱ bo̱ mo̱ŋ taare̱ lee kanɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “To, mo̱ne̱ e̱ te̱e̱ mo̱ ɛ ɔkaapo̱po̱ na mo̱ne̱ nyaŋpe̱. A bware fe̱yɛ mo̱ne̱ a te̱e̱ mo̱ ane̱ŋ, a le̱e̱ fe̱yɛ n gye̱ ane̱ŋ kase̱ŋtiŋ‑no ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Fe̱yɛ ane̱ŋ ne̱ mo̱ ne̱ n gye̱ mo̱ne̱ nyaŋpe̱ na ɔkaapo̱po̱‑ɔ a fwe̱e̱ mo̱ne̱ ayaa se̱‑ɔ, ane̱ŋ dɛɛ ne̱ mo̱ne̱ ne̱ mo̱ne̱ gye̱ mo̱ agyase̱po̱‑ɔ mɔ de̱e̱ fwe̱e̱ abɛɛ ayaa se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mo̱ a waa amo̱‑ɔ bo̱ kaapo̱ mo̱ne̱ ne̱e̱ a mo̱ne̱ mɔ mo̱nꞌ de̱e̱ waa ane̱ŋ ne̱ mo̱ a waa sa mo̱ne̱‑ɔ dɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ ke̱yaafɔre̱ ko̱ mo̱ŋ bo̱‑rɔ ne̱ ɔ kyɔ mò̱ nyaŋpe̱. Ane̱ŋ dɛɛ ne̱ kabɔɔ ko̱ mo̱ŋ bo̱‑rɔ ne̱ ɔ kyɔ mò̱ ne̱ oo suŋ mò̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mbe̱yɔmɔ fe̱raa, mo̱ne̱ a ŋu kase̱ŋtiŋ‑o si‑o, mo̱ne̱ ya gya kamo̱ se̱, Wuribware̱ i yure mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","N gye̱ mo̱ne̱ pɛɛɛ ase̱ŋ ne̱ mo̱ e̱ tɔwe̱. Mo̱ne̱‑rɔ ɔko̱ŋko̱ maa nya ane̱ŋ a ŋyure‑o. Mo̱ a lee mo̱ne̱ pɛɛɛ fe̱yɛ mo̱nꞌ ba mo̱ ke̱be̱gya‑ɔ gbaa ooo, ŋ nyi ane̱ŋ ne̱ mo̱ne̱ ɔke̱maa kakpo̱nɔ‑rɔ du‑o. Ne̱ ŋ nyi fe̱yɛ ke̱tɔ ne̱ baa kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ bo̱ le̱e̱ mo̱ne̱‑rɔ ɔko̱ŋko̱ amo̱ se̱‑ɔ tiri fe̱yɛ a ba kase̱ŋtiŋ. A le̱e̱ fe̱yɛ baa kyo̱rɛɛ ne̱e̱ fe̱yɛ, ‘Ɔnyare̱ ne̱ ne̱ mo̱ aa mò̱ ke̱sare̱e̱ da gyare̱ ko̱ŋko̱‑rɔ ane̱ i gyi‑o a twe̱e̱ ke̱yaa bo̱ kye mo̱, taa mo̱ yaa fe.’ ");
INSERT INTO ncuNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mo̱ e̱ tɔwe̱ amo̱‑ɔ mo̱ i gywii mo̱ne̱ pwɛɛ na a dɛɛ ba, na, amo̱ ya ba‑ɔ, mo̱ne̱ ma yɔwe̱ ko̱kɔɔre̱gyi fe̱yɛ mo̱ e̱ gye̱ ne̱ n gye̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ ɔke̱maa ne̱ ɔ kra mò̱ ne̱ mo̱ a suŋ mò̱‑ɔ nɛɛnɛɛ‑ɔ a kra mo̱‑ɔ mɔ nɛɛnɛɛ ne̱e̱, ne̱ mò̱ ne̱ ɔɔ kra mo̱ nɛɛnɛɛ‑ɔ a kra n se̱ Wuribware̱ nɛɛnɛɛ ne̱e̱, a le̱e̱ fe̱yɛ mò̱ ya suŋ mo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yeesuu a tɔwe̱ amo̱‑ɔ lo̱we̱‑ɔ, ne̱ mò̱ kakpo̱nɔ‑rɔ a nye̱ra, ne̱ oo lee amo̱ kawu tɔwe̱ fe̱yɛ, “Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ mo̱ne̱‑rɔ ɔko̱ e̱ ba a ɔ bo̱ gyi mo̱ kidiburo.” ");
INSERT INTO ncuNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ne̱ agyase̱po̱‑ɔ a de̱e̱re̱ abɛɛ na bo̱ nya ŋu mò̱ ne̱ o de‑o. ");
INSERT INTO ncuNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ne̱ agyase̱po̱‑ɔ ɔko̱ ne̱ Yeesuu e̱ kpa mò̱ ase̱ŋ bwe̱e̱tɔ‑ɔ te ɔ gya mò̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ne̱ Simɔŋ a ba mò̱ ke̱sare̱e̱ bo̱ tɔwe̱ ase̱ŋ gywii mò̱ ne̱ o te ɔ gya Yeesuu si‑o fe̱yɛ o bise mò̱ fe̱yɛ nsɛ a ase̱ŋ ne̱ ɔ tɔwe̱‑ɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Amo̱se̱ se̱‑ɔ ne̱ ane̱ŋ a ɔgyase̱po̱‑ɔ a sɔŋ me̱raa Yeesuu, ne̱ oo kuri bise fe̱yɛ, “Mo̱ nyaŋpe̱, nsɛ ne̱ fo̱ de?” ");
INSERT INTO ncuNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Mo̱ e̱ pɔɔrɔ bodobodoo kabe̱gyɛɛ, na mò̱ ne̱ mo̱ e̱ taa a m bo̱ sa mò̱‑ɔ e̱ gye̱ ane̱ŋ a se̱sɛ‑ɔ.” Amo̱se̱ se̱‑ɔ ne̱ ɔɔ te̱ŋ bodobodoo kabe̱gyɛɛ, ne̱ ɔɔ bo̱ pɔɔrɔ, ne̱ ɔɔ taa sa Yudas, Simɔŋ Kariyotinyi mò̱ gyi‑o. ");
INSERT INTO ncuNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yudas a de̱ŋ kɔɔre̱ bodobodoo‑o, ne̱ Ɔbɔnsam a lwee mò̱ mfɛɛre̱‑rɔ, ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Da e̱ye̱e̱ se̱ waa ke̱tɔ ne̱ fo̱ e̱ kpa a fo̱ waa‑ɔ!” ");
INSERT INTO ncuNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Bamo̱ pɛɛɛ ne̱ bo̱ te teeburi ase̱‑ɔ ɔko̱ mo̱ŋ nu ke̱tɔ ne̱ Yeesuu e̱ tɔwe̱ o gywii mò̱‑ɔ kaase̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yudas a gye̱ ɔko̱ ne̱ ɔ de̱e̱re̱ bamo̱ atanne̱ ko̱re̱e̱ se̱‑ɔ se̱‑ɔ, agyase̱po̱‑ɔ bo̱ko̱ nyi fe̱yɛ Yeesuu a tɔwe̱ gywii mò̱ ne̱e̱ fe̱yɛ ɔ ya sɔɔ ateese ne̱ a tiri bamo̱‑ɔ ne̱e̱, bɛɛɛ ɔɔ tɔwe̱ gywii mò̱ ne̱e̱ fe̱yɛ o lee atanne̱‑ɔ ako̱ sa atiripo̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yudas a kɔɔre̱ bodobodoo‑o, ne̱ ɔɔ le̱e̱ kawu kaluwa ko̱ŋko̱ o yii. Saŋ amo̱‑ɔ kyɔwe̱ a lo̱we̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudas a le̱e̱‑ɔ kamɛɛ, ne̱ Yeesuu yɛ, “Mbe̱yɔmɔ Wuribware̱ e̱ kpa a ɔ sa mo̱, dimaadi mò̱ gyi‑o, ke̱dabe̱. Na mo̱nꞌ ye̱re̱ amo̱ se̱ bo̱ ŋu Wuribware̱ ke̱dabe̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","To, Wuribware̱ e̱ bo̱rɔ mo̱ se̱ a ɔ bo̱ kaapo̱ mò̱ fɔŋfɔŋ ke̱dabe̱‑ɔ se̱‑ɔ, ɔ bo̱rɔ mò̱ e̱ye̱e̱ se̱ bo̱ kaapo̱ mo̱, dimaadi mò̱ gyi‑o, ke̱dabe̱. Ɔ kpa a ɔ waa amo̱‑ɔ mbe̱yɔmɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mo̱ gyi‑ana, ane̱ŋ ne̱ mo̱ a tɔwe̱ gywii Yudaa awuye abre̱sɛ‑ɔ dɛɛ ne̱ mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱‑ɔ fe̱yɛ mo̱ aa mo̱ne̱ e̱ kye̱na saŋ katiŋ ko̱ ne̱e̱, mo̱ne̱ i buwi a mo̱nꞌ kpa mo̱, amaa mo̱ne̱ maa taare̱ a mo̱nꞌ yɔ mfe̱ŋ ne̱ mo̱ e̱ yɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mbe̱yɔmɔ mbraa po̱pwɛɛ ne̱ n de mo̱ e̱ sa mo̱ne̱‑ɔ e̱ gye̱ fe̱yɛ mo̱nꞌ de̱e̱ kpa abɛɛ ase̱ŋ. Ane̱ŋ ne̱ mo̱ a kpa mo̱ne̱ ase̱ŋ‑ɔ, ane̱ŋ dɛɛ ne̱ mo̱nꞌ de̱e̱ kpa abɛɛ ase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mo̱ne̱ e̱ kpa abɛɛ ase̱ŋ, amɔ ase̱sɛ pɛɛɛ i ŋu fe̱yɛ mo̱ne̱ gye̱ mo̱ agyase̱po̱ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ne̱ Simɔŋ Peetroo a bise fe̱yɛ, “Mo̱ nyaŋpe̱, mfe̱ne̱ ne̱ fo̱ e̱ yɔ?” Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Fo̱ maa taare̱ a fo̱ gya mo̱ se̱ yɔ mfe̱ŋ ne̱ mo̱ e̱ yɔ‑ɔ mbe̱yɔmɔ, amaa fo̱ saŋ fo̱ e̱ gya mo̱ se̱ kamɛɛ‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ne̱ Peetroo a be̱e̱ bise fe̱yɛ, “Mo̱ nyaŋpe̱, nte̱tɔ ne̱e̱ ne̱ ma taare̱ a n gya fo̱ se̱ mbe̱mbe̱yɔmɔ? Mo̱ a waa siraa fe̱yɛ mo̱ i wu a n sa fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ne̱ Yeesuu a be̱ŋŋaa mò̱ fe̱yɛ, “Kase̱ŋtiŋ ne̱ fo̱ a waa siraa fe̱yɛ fo̱ i wu a fo̱ sa mo̱ aaa? Mo̱ i gyi fo̱ kase̱ŋtiŋ fe̱yɛ, fo̱ e̱ swe̱e̱ iluwi e̱sa fe̱yɛ fo̱ mo̱ŋ nyi mo̱ pwɛɛ na kyaŋare̱ dɛɛ fo̱re̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ne̱ Yeesuu a kya se̱ tɔwe̱ gywii mò̱ agyase̱po̱‑ɔ fe̱yɛ, “Mo̱ne̱ ma lɛɛ sa a mo̱ne̱ iduŋ te̱ŋŋe̱ mo̱ne̱. Mo̱nꞌ de̱e̱ kɔɔre̱ Wuribware̱ gyi, na mo̱nꞌ de̱e̱ kɔɔre̱ mo̱‑ɔ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","A le̱e̱ fe̱yɛ akyaŋ bwe̱e̱tɔ bo̱ n se̱ aye̱, amo̱se̱ se̱‑ɔ mo̱ e̱ gye̱ ŋkpɛɛ a ŋ nya lɔŋŋɔ e̱kye̱nakpa sa mo̱ne̱. Weetee a dɛɛ a mo̱ŋ gye̱ ane̱ŋ ne̱e̱, ma tɔwe̱ amo̱‑ɔ a n gywii mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Fe̱yɛ mo̱ ya lɔŋŋɔ e̱kye̱nakpa sa mo̱ne̱‑ɔ, mo̱ i kiŋŋi a m ba bo̱ taa mo̱ne̱ yaa mo̱ ase̱, na mo̱nꞌ nya kye̱na mfe̱ŋ ne̱ n te‑o. ");
INSERT INTO ncuNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mo̱ne̱ nyi ane̱ŋ ne̱ mo̱ne̱ e̱ waa a mo̱nꞌ yɔ mfe̱ŋ ne̱ mo̱ e̱ ya kye̱na‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ne̱ Tomas a tɔwe̱ gywii mò̱ fe̱yɛ, “Mo̱ nyaŋpe̱, ane̱ mo̱ŋ nyi mfe̱ŋ ne̱ fo̱ e̱ yɔ‑ɔ. Ne̱ e̱me̱ne̱ ne̱ ane̱ e̱ waa a ane̱ ŋu kpa bo̱ yɔ mfe̱ŋ?” ");
INSERT INTO ncuNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ne̱ Yeesuu a be̱ŋŋaa mò̱ fe̱yɛ, “Mo̱‑ɔ mo̱ e̱ gye̱ kpa amo̱. Mo̱ e̱ gye̱ ne̱ ŋ kaapo̱ ɔko̱ kase̱ŋtiŋ a kpa ne̱ ɔ bo̱rɔ se̱, na ɔ nya nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ. Ane̱ŋ se̱‑ɔ, ɔko̱ maa taare̱ a ɔ yɔ n se̱ ase̱, amɔ ɔ bo̱rɔ mo̱ se̱ pwɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mo̱ne̱ nyi mo̱ ne̱e̱, weetee mbe̱yɔmɔ mo̱ne̱ nyi n se̱. Le̱e̱ mbe̱yɔmɔ bo̱ yɔ, mo̱ne̱ i gyii mò̱, a le̱e̱ fe̱yɛ mo̱ne̱ a ŋu mò̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ne̱ Filipo a tɔwe̱ gywii mò̱ fe̱yɛ, “Mo̱ nyaŋpe̱, kaapo̱ ane̱ fo̱ se̱‑ɔ, ke̱tɔ ne̱ ane̱ e̱ kpa‑ɔ pɛɛɛ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Filipo, le̱e̱ ke̱de̱daade̱daa ne̱ mo̱ aa mo̱ne̱ pɛɛɛ a kye̱na‑ɔ. Fo̱ saŋ fo̱ mo̱ŋ nyi mo̱ aaa? Ɔke̱maa ne̱ oo ŋu mo̱‑ɔ, oo ŋu n se̱ ne̱e̱. Ne̱ e̱me̱ne̱ se̱ ne̱ fo̱ yɛ ŋ kaapo̱ mo̱ne̱ n se̱? ");
INSERT INTO ncuNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Fo̱ e̱ kɔɔre̱ fo̱ i gyi fe̱yɛ mo̱ aa n se̱ gye̱ ko̱ko̱ŋko̱, bɛɛɛ? Abware̱se̱ŋ ne̱ mo̱ a tɔwe̱ gywii mo̱ne̱‑ɔ mo̱ŋ le̱e̱ mo̱ ase̱ ne̱e̱. Aa le̱e̱ n se̱ ne̱ ɔ bo̱ mo̱ ase̱‑ɔ ase̱ ne̱e̱. N se̱ bo̱ mo̱ ase̱ ne̱e̱ ɔ waa mò̱ fɔŋfɔŋ kusuŋ. ");
INSERT INTO ncuNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ane̱ŋ se̱‑ɔ, mo̱nꞌ de̱e̱ kɔɔre̱ gyi fe̱yɛ mo̱ aa n se̱ gye̱ ko̱ko̱ŋko̱. Mo̱ne̱ e̱ ma taare̱ a mo̱nꞌ kɔɔre̱ mo̱ fɔŋfɔŋ ase̱ŋ gyi, amo̱ fe̱raa, asuŋ ne̱ mo̱ a waa‑ɔ se̱, mo̱nꞌ kɔɔre̱ mo̱ ase̱ŋ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ ɔke̱maa ne̱ ɔ kɔɔre̱ mo̱ o gyi‑o e̱ waa asuŋ ne̱ mo̱ e̱ waa‑ɔ. Ɔ waa ako̱ na a kyɔ amo̱‑ɔ, a le̱e̱ fe̱yɛ mo̱ e̱ yɔ n se̱ ase̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Mo̱ ya yɔ n se̱ ase̱, ke̱tɔ ke̱maa ne̱ mo̱ne̱ ke̱maa ya ko̱re̱ mo̱ ke̱nyare̱‑rɔ‑ɔ, mo̱ e̱ waa a n sa mò̱, na n se̱ ke̱dabe̱ nya bo̱rɔ mo̱ se̱ bo̱ le̱e̱ kawu. ");
INSERT INTO ncuNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Amo̱se̱ se̱‑ɔ, mo̱ne̱ ya ko̱re̱ ke̱tɔ ke̱maa mo̱ ke̱nyare̱‑rɔ, mo̱ e̱ waa a n sa mo̱ne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Mo̱ne̱ e̱ kpa mo̱ ase̱ŋ fe̱raa, mo̱nꞌ gya mo̱ mbraa se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Na ŋ ye̱re̱‑rɔ tɔwe̱ gywii n se̱, na ɔ ba ɔkyarɔpo̱ bo̱ kyo̱ŋwe̱ mo̱ne̱, na ɔ ye̱re̱ mo̱ ayaa‑rɔ, na mo̱ne̱ aa mò̱ kye̱na. ");
INSERT INTO ncuNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Mò̱ e̱ gye̱ Wuribware̱ a kufwiiŋe‑o, kase̱ŋtiŋ wuye‑o. Kaye̱‑rɔ ase̱sɛ maa taare̱ a bo̱ buŋŋi bamo̱ ŋkpo̱nɔ‑rɔ sa mò̱, a le̱e̱ fe̱yɛ bo̱ mo̱ŋ ke̱e̱ mò̱, ne̱ bo̱ maa taare̱ a bo̱ gyii mò̱. Amaa mo̱ne̱ fe̱raa, mo̱ne̱ e̱ taare̱ a mo̱nꞌ gyii mò̱, a le̱e̱ fe̱yɛ o sii mo̱ne̱ ase̱, na ɔ kye̱na mo̱ne̱ ŋkpo̱nɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ma yɔwe̱ mo̱ne̱ fe̱yɛ aŋɔŋgyi‑o, amaa mo̱ e̱ be̱e̱ kiŋŋi a m ba mo̱ne̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","A bo̱ waa kafwe̱e̱‑ɔ, kaye̱‑rɔ ase̱sɛ maa lɛɛ ŋu mo̱, amaa mo̱ne̱ fe̱raa mo̱ne̱ i ŋu mo̱. Bo̱ le̱e̱ ane̱ŋ ne̱ mo̱ i kyiŋŋi a m be̱e̱ nya ŋkpa‑ɔ se̱‑ɔ, mo̱ne̱ mɔ mo̱ne̱ e̱ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kake amo̱ ya fo̱, mo̱ne̱ i ŋu fe̱yɛ mo̱ aa n se̱ gye̱ ko̱ko̱ŋko̱, ne̱ mo̱ aa mo̱ne̱ mɔ gye̱ ko̱ko̱ŋko̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ɔke̱maa ne̱ ɔ kɔɔre̱ mo̱ mbraa, ne̱ ɔ gya mmo̱ se̱ nɛɛnɛɛ‑ɔ, a kaapo̱ ne̱e̱ fe̱yɛ ɔ kpa mo̱ ase̱ŋ. Ɔko̱ ne̱ ɔ kpa mo̱ ase̱ŋ‑ɔ, n se̱ e̱ kpa mò̱ ase̱ŋ. Na ŋ gbaa, ŋ kpa mò̱ ase̱ŋ, na n sa a o gyii mo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ne̱ Yudas (n gye̱ Yudas Kariyotinyi) yɛ, “Mo̱ nyaŋpe̱, e̱me̱ne̱ ya waa se̱ ne̱ fo̱ maa sa a kaye̱‑rɔ ase̱sɛ gyii fo̱, ne̱ ane̱ wo̱re̱ e̱ gye̱ ne̱ ane̱ i gyii fo̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ne̱ Yeesuu a be̱ŋŋaa mò̱ fe̱yɛ, “Ɔke̱maa ne̱ ɔ kpa mo̱ ase̱ŋ‑ɔ e̱ gya mo̱ kanɔ se̱. Na n se̱ kpa mò̱ ase̱ŋ, na mo̱ aa n se̱ ba mò̱ ase̱ bo̱ kye̱na. ");
INSERT INTO ncuNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ɔke̱maa mɔ ne̱ ɔ maa kpa mo̱ ase̱ŋ‑ɔ maa gya mo̱ kanɔ se̱. Ase̱ŋ ne̱ mo̱ne̱ a nu le̱e̱ mo̱ ase̱‑ɔ mɔ mo̱ŋ le̱e̱ mo̱ fɔŋfɔŋ ase̱ ne̱e̱, amaa aa le̱e̱ n se̱ ne̱ oo suŋ mo̱‑ɔ ase̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Mo̱ a saŋ m bo̱ mo̱ne̱ ase̱‑ɔ, ne̱ mo̱ a tɔwe̱ amo̱‑ɔ gywii mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Amaa mo̱ne̱ ya taŋ mo̱ ase̱ŋ‑ɔ se̱, ɔkyarɔpo̱ amo̱ ne̱ ba te̱e̱ mò̱ ɛ Wuribware̱ a kufwiiŋe timaa‑o ne̱ n se̱ de mò̱ ɔ kyo̱ŋwe̱ mo̱ ke̱nyare̱‑rɔ‑ɔ e̱ kaapo̱ mo̱ne̱ ke̱tɔ ke̱maa, na ɔ sa a mo̱nꞌ nyiŋŋi ke̱tɔ ke̱maa ne̱ mo̱ a tɔwe̱ gywii mo̱ne̱‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ke̱tɔ ne̱ ko̱ kyɔ‑ɔ e̱ gye̱ fe̱yɛ mo̱ e̱ sa mo̱ne̱ kaye̱e̱yuri. Mo̱ fɔŋfɔŋ kaye̱e̱yuri ne̱ n de mo̱ e̱ sa mo̱ne̱, amaa n gye̱ ane̱ŋ ne̱ kaye̱‑rɔ ase̱sɛ de ba sa‑ɔ ne̱ n de mo̱ e̱ sa mo̱ne̱. Mo̱ne̱ ma sa a mo̱ne̱ iduŋ te̱ŋŋe̱ mo̱ne̱ na kufu nya mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mo̱ne̱ a nu fe̱yɛ mo̱ a tɔwe̱ gywii mo̱ne̱ fe̱yɛ mo̱ e̱ yɔ ne̱e̱, amaa mo̱ i kiŋŋi a m ba mo̱ne̱ ase̱, bɛɛɛ? Mo̱ne̱ e̱ kpa mo̱ ase̱ŋ fe̱raa, weetee mo̱ne̱ akatɔ i gyi fe̱yɛ mo̱ a yɔ n se̱ ase̱, a le̱e̱ fe̱yɛ ɔ kyɔ mo̱ kpa ke̱maa se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mo̱ a tɔwe̱ amo̱‑ɔ gywii mo̱ne̱ mbe̱yɔmɔ pwɛɛ na a dɛɛ ba, ne̱ amo̱‑ɔ ya ba‑ɔ, na mo̱nꞌ nya kɔɔre̱ ke̱tɔ ne̱ mo̱ a tɔwe̱‑ɔ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ma lɛɛ taare̱ a mo̱ aa mo̱ne̱ a sa se̱ŋsa kyee, a le̱e̱ fe̱yɛ Ɔbɔnsam ne̱ o de kaye̱‑rɔ ase̱sɛ mfɛɛre̱ se̱ ke̱yaale̱ŋ‑ɔ e̱ ba, amaa ɔ mo̱ŋ de ke̱yaale̱ŋ mo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Amaa amo̱‑ɔ pɛɛɛ e̱ ba na kaye̱‑rɔ ase̱sɛ nya ŋu fe̱yɛ kase̱ŋtiŋ si mo̱ e̱ kpa n se̱ ase̱ŋ, ne̱ mo̱ e̱ waa ke̱tɔ ke̱maa ne̱ n se̱ a tɔwe̱ gywii mo̱ ɛ ŋ waa‑ɔ ne̱e̱. To, mo̱nꞌ sa a ane̱ le̱e̱ mfe̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Bamo̱ a maa se̱ ba yɔ‑ɔ, ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “N du ne̱e̱ fe̱yɛ bobe kiyii timaa. N se̱ mɔ e̱ bo̱ ke̱mo̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ɔ kpo̱ŋŋe̱ kayaagyii ke̱maa ne̱ ka maa swɛɛ agyi‑o a ɔ bo̱ twe̱e̱, na o ŋeri ŋyaagyii ko̱ ne̱ n swɛɛ agyi‑o si, na ŋ nya pɔwe̱ swɛɛ agyi bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mo̱ne̱ fe̱raa, mo̱ abware̱se̱ŋ ne̱ mo̱ a tɔwe̱ gywii mo̱ne̱‑ɔ a kyɔ sa ne̱ mo̱ne̱ a te̱ŋ mo̱ne̱ ŋyo̱wɔre̱ le̱e̱ e̱bɔye̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kiyii‑o yɛ, ŋyaagyii, mo̱nꞌ kye̱na mo̱ se̱ nɛɛnɛɛ, na mo̱‑ɔ ŋ nya kra mo̱ne̱‑rɔ keŋkeŋ. Kiyii kayaagyii maa taare̱ a ka le̱ŋ kamo̱ e̱ye̱e̱ se̱ swɛɛ agyi, amɔ kayaagyii‑o te kiyii‑o si. N du ne̱e̱ fe̱yɛ kiyii‑o, mo̱ne̱ mɔ mo̱ne̱ du fe̱yɛ ŋyaagyii‑o. Ane̱ŋ dɛɛ ne̱ mo̱ne̱ maa taare̱ a mo̱nꞌ swɛɛ agyi, amɔ mo̱ne̱ te mo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ŋ yɛ ɛɛɛ, n du ne̱e̱ fe̱yɛ bobe kiyii‑o, ne̱ mo̱ne̱ mɔ mo̱ne̱ du fe̱yɛ ke̱mo̱ ŋyaagyii‑o. Ɔke̱maa ne̱ o te mo̱ se̱, ne̱ mo̱‑ɔ n de mò̱‑rɔ keŋkeŋ‑o e̱ swɛɛ agyi bwe̱e̱tɔ, a le̱e̱ fe̱yɛ mo̱ne̱ e̱ mo̱ŋ tii mo̱ se̱, mo̱ne̱ wo̱re̱ maa taare̱ a mo̱nꞌ waa sɛye̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Amaa mò̱ ne̱ ɔ mo̱ŋ te mo̱ se̱‑ɔ e̱ le̱e̱ a ɔ le̱e̱ da, na bo̱ taa mò̱ twe̱e̱ bo̱ kyo̱ŋwe̱ fe̱yɛ kiyii kayaagyii‑o, na ka di wo̱re̱. Na bo̱ taa kamo̱ bo̱ waa de̱e̱kpa‑rɔ kure. ");
INSERT INTO ncuNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mo̱ne̱ ya kye̱na mo̱ se̱, ne̱ mo̱‑ɔ mɔ mo̱ a kra mo̱ne̱‑rɔ keŋkeŋ, amo̱ fe̱raa mo̱ne̱ e̱ ko̱re̱ ke̱tɔ ke̱maa ne̱ mo̱ne̱ e̱ kpa‑ɔ, mo̱ne̱ e̱ nya. ");
INSERT INTO ncuNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mo̱ne̱ ya swɛɛ agyi bwe̱e̱tɔ, n se̱ e̱ nya ke̱dabe̱, na a be̱e̱ kaapo̱ fe̱yɛ mo̱ne̱ a kii mo̱ agyase̱po̱‑ɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mo̱ e̱ de̱e̱ kpa mo̱ne̱ ase̱ŋ fe̱yɛ ane̱ŋ dɛɛ ne̱ n se̱ e̱ kpa mo̱ ase̱ŋ‑ɔ. Mo̱ne̱ fe̱raa mo̱nꞌ de̱e̱ kye̱na ane̱ŋ ne̱ a sa a n de̱e̱ kpa mo̱ne̱ ase̱ŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mo̱ne̱ ya gya mo̱ mbraa se̱, mo̱ e̱ de̱e̱ kpa mo̱ne̱ ase̱ŋ, fe̱yɛ ane̱ŋ dɛɛ ne̱ mo̱ a gya n se̱ mbraa se̱, ne̱ ɔ saŋ ɔ kpa mo̱ ase̱ŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Mo̱ a tɔwe̱ amo̱‑ɔ gywii mo̱ne̱ ne̱e̱ a mo̱ne̱ akatɔ nya gyi. Mo̱ne̱ kakatɔgyi bwe̱e̱tɔ mɔ e̱ le̱e̱ mo̱ ase̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ mo̱nꞌ de̱e̱ kpa abɛɛ ase̱ŋ fe̱yɛ ane̱ŋ dɛɛ ne̱ mo̱ŋ kine mo̱ne̱ ase̱ŋ ke̱kpa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ke̱tɔ ne̱ nyiŋkpasɛ e̱ ba a ɔ bo̱ kaapo̱ fe̱yɛ ɔ kpa mò̱ nyare̱‑ana ase̱ŋ bwe̱e̱tɔ‑ɔ e̱ gye̱ fe̱yɛ mò̱ a wu sa bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mo̱ne̱ ya gya ase̱ŋ ne̱ mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱‑ɔ se̱, amo̱ fe̱raa a kaapo̱ fe̱yɛ mo̱ne̱ gye̱ mo̱ nyare̱‑ana ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ma lɛɛ te̱e̱ mo̱ne̱ fe̱yɛ mo̱ ayaafɔre̱, a le̱e̱ fe̱yɛ ke̱yaafɔre̱ mo̱ŋ nyi ke̱tɔ ne̱ mò̱ nyaŋpe̱ e̱ waa‑ɔ. Amaa ŋkee, mo̱ e̱ te̱e̱ mo̱ne̱ fe̱yɛ mo̱ nyare̱‑ana, a le̱e̱ fe̱yɛ mo̱ a tɔwe̱ ke̱tɔ ke̱maa ne̱ mo̱ a nu le̱e̱ n se̱ ase̱‑ɔ gywii mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","N gye̱ mo̱ne̱ ya lee mo̱ fe̱yɛ ŋ kii mo̱ne̱ nyaŋpe̱. Amaa mo̱ ya te̱e̱ mo̱ne̱ fe̱yɛ mo̱nꞌ bo̱ kii mo̱ agyase̱po̱‑ɔ, na n suŋ mo̱ne̱ bo̱ kyo̱ŋwe̱ fe̱yɛ mo̱nꞌ ya swɛɛ agyi bwe̱e̱tɔ, agyi ne̱ a maa gyo‑o. Mo̱ne̱ ya waa amo̱‑ɔ, n se̱ e̱ sa mo̱ne̱ ke̱tɔ ke̱maa ne̱ mo̱ne̱ e̱ ko̱re̱ mo̱ ke̱nyare̱‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Amo̱se̱‑ɔ mbraa ne̱ n de mo̱ e̱ sa mo̱ne̱‑ɔ e̱ gye̱ fe̱yɛ mo̱nꞌ de̱e̱ kpa abɛɛ ase̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “To, mo̱ne̱ ya ŋu fe̱yɛ kaye̱‑rɔ ase̱sɛ i kisi mo̱ne̱, mo̱nꞌ nyiŋŋi si fe̱yɛ ane̱ŋ dɛɛ ne̱ baa kyɔ dɛɛ gye̱ ŋkpɛɛ kisi mo̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mo̱ne̱ dɛɛ mo̱ne̱ tii kaye̱‑rɔ ase̱sɛ se̱, ne̱ mo̱ne̱ aa bamo̱ asuŋ gye̱ ako̱ŋko̱ ne̱e̱‑ɔ, weetee ba kpa mo̱ne̱ ase̱ŋ fe̱yɛ bamo̱ e̱ye̱e̱‑ɔ. Amaa mo̱ a te̱e̱ mo̱ne̱ le̱e̱ kaye̱ mɔ ase̱sɛ‑rɔ. Amo̱se̱ se̱‑ɔ mo̱ne̱ mo̱ŋ lɛɛ mo̱ne̱ bo̱ kaye̱‑rɔ ase̱sɛ a ke̱be̱gya‑ɔ, ane̱ŋ se̱ ne̱ kaye̱‑rɔ ase̱sɛ i kisi mo̱ne̱‑ɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mo̱nꞌ nyiŋŋi ke̱tɔ ne̱ mo̱ a tɔwe̱ gywii mo̱ne̱‑ɔ se̱ fe̱yɛ ke̱yaafɔre̱ ke̱maa mo̱ŋ bo̱‑rɔ ne̱ ɔ kyɔ mò̱ nyaŋpe̱. Amo̱se̱‑ɔ ane̱ŋ ne̱ bo̱ko̱ a gya mo̱ kanɔ se̱‑ɔ dɛɛ ne̱ ba gya mo̱ne̱ lee si. Ane̱ŋ ne̱ bo̱ko̱ mɔ a waa mo̱ awo̱re̱fɔɔ‑ɔ mɔ dɛɛ ne̱ ba waa mo̱ne̱ gbaa mo̱ne̱ awo̱re̱fɔɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ane̱ŋ ne̱ mo̱ne̱ bo̱ mo̱ ke̱be̱gya‑ɔ se̱‑ɔ se̱ ne̱ ba waa mo̱ne̱ amo̱‑ɔ pɛɛɛ, a le̱e̱ fe̱yɛ bo̱ mo̱ŋ nyi mò̱ ne̱ oo suŋ mo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","N dɛɛ mo̱ŋ ba kaye̱ mɔ‑rɔ bo̱ tɔwe̱ abware̱se̱ŋ gywii kamo̱‑rɔ ase̱sɛ ne̱e̱, weetee n se̱ maa bu bamo̱ bɔye̱ ne̱ ba waa‑ɔ ke̱pɔ. Ane̱ŋ ne̱ mo̱ a ba‑ɔ se̱‑ɔ, bo̱ mo̱ŋ lɛɛ bo̱ de ke̱tɔ ne̱ ba ye̱re̱ se̱ a bo̱ bo̱ waa bɔye̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ɔke̱maa ne̱ o kisi mo̱‑ɔ, ane̱ŋ dɛɛ ne̱ o kisi n se̱ gbaa. ");
INSERT INTO ncuNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","N dɛɛ mo̱ŋ ba kaye̱ mɔ‑rɔ bo̱ waa asuŋ ne̱ ɔko̱ mo̱ŋ tɛɛ waa amo̱‑ɔ ne̱e̱, weetee n se̱ maa bu bamo̱ bɔye̱ ne̱ ba waa‑ɔ ke̱pɔ. Ane̱ŋ ne̱ a du‑o, baa ŋu ke̱tɔ ne̱ mo̱ a waa‑ɔ, ne̱ amo̱‑ɔ pɛɛɛ gbaa bo̱ saŋ ba kisi mo̱ aa n se̱ pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Amo̱‑ɔ kyɔ a ba ane̱ŋ, na ke̱tɔ ne̱ abware̱se̱ŋ wo̱re̱‑ɔ a tɔwe̱‑ɔ nya ba kase̱ŋtiŋ fe̱yɛ, ‘Kikisi ne̱ baa kisi mo̱‑ɔ mo̱ŋ de kaase̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ɔkyarɔpo̱ ne̱ ɔ le̱e̱ n se̱ ase̱‑ɔ e̱ ba. Mò̱ e̱ gye̱ Wuribware̱ a kufwiiŋe‑o, kase̱ŋtiŋ wuye‑o. Mò̱ ya ba, mò̱ e̱ gye̱ ne̱ ɔ kya mo̱ne̱‑rɔ. Mo̱ e̱ sa a ɔ le̱e̱ n se̱ ase̱ ba mo̱ne̱ ase̱, na ɔ tɔwe̱ mo̱ ase̱ŋ gywii ase̱sɛ. ");
INSERT INTO ncuNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Na mo̱ne̱ mɔ, mo̱nꞌ tɔwe̱ mo̱ ase̱ŋ, a le̱e̱ fe̱yɛ mo̱ne̱ kyɔ mo̱ne̱ bo̱ mo̱ ase̱ le̱e̱ ke̱gye̱ŋkpɛɛ‑ɔ‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Mo̱ a tɔwe̱ amo̱‑ɔ gywii mo̱ne̱ ne̱e̱ a mo̱ne̱ ma nya kiŋŋi kamɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ba gya mo̱ne̱ a bo̱ le̱e̱ bamo̱ ke̱bware̱ko̱re̱ akyaŋ‑nɔ. Saŋ ko̱ e̱ ba a ɔ bo̱ ba, ne̱ ɔke̱maa ne̱ ɔ mɔɔ mo̱ne̱‑ɔ e̱ fa fe̱yɛ, mò̱ a waa amo̱‑ɔ, ɔɔ waa ko̱tɔko̱ sa Wuribware̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ke̱tɔ se̱ ne̱ ba waa mo̱ne̱ amo̱‑ɔ e̱ gye̱ fe̱yɛ bo̱ mo̱ŋ nyi n se̱, ane̱ŋ dɛɛ ne̱ bo̱ mo̱ŋ nyi mo̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Amaa mo̱ a tɔwe̱ amo̱‑ɔ gywii mo̱ne̱ ne̱e̱ a saŋ‑ɔ ya fo̱ fe̱yɛ bo̱ waa atɔ mɔ, na mo̱nꞌ nya nyiŋŋi si fe̱yɛ mo̱ a kyɔ tɔwe̱ gywii mo̱ne̱.” Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Mo̱ a saŋ m bo̱ mo̱ne̱ ase̱‑ɔ se̱, ne̱ mo̱ŋ wuree tɔwe̱ ase̱ŋ mɔ gywii mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","To, mbe̱yɔmɔ mo̱ e̱ yɔ mò̱ ne̱ oo suŋ mo̱‑ɔ ase̱ ne̱e̱. Amaa mo̱ne̱ ko̱ gbaa mo̱ŋ taare̱ bise mo̱ fe̱yɛ, ‘Mfe̱ne̱ ne̱ fo̱ e̱ yɔ?’ ");
INSERT INTO ncuNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ne̱ mbe̱yɔmɔ fe̱raa ne̱ mo̱ a tɔwe̱ gywii mo̱ne̱‑ɔ, aa ko̱ŋ waa mo̱ne̱ e̱wɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ, mo̱ ya yɔ, a baare a a sa mo̱ne̱, a le̱e̱ fe̱yɛ, mo̱ e̱ mo̱ŋ yɔ, ɔkyarɔpo̱‑ɔ maa ba mo̱ne̱ ase̱. Amaa mo̱ ya yɔ fe̱raa, mo̱ e̱ ba mò̱ a m bo̱ kyo̱ŋwe̱ mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ne̱ mò̱ ya ba‑ɔ, ɔ kaapo̱ ase̱sɛ ne̱ bo̱ bo̱ kaye̱ mɔ‑rɔ‑ɔ fe̱yɛ bo̱ gye̱ abɔye̱waapo̱. Ne̱ ɔ kaapo̱ bamo̱ fe̱yɛ bo̱ be̱e̱ baa waa bɔye̱ fe̱yɛ baa po̱rɔ mo̱ fe̱yɛ mo̱ e̱ gye̱ ɔbɔye̱waapo̱. Ne̱ ɔ be̱e̱ ɔ kaapo̱ bamo̱ ɔko̱ ne̱ Wuribware̱ i bu ke̱pɔ‑ɔ, na ɔko̱ mɔ ne̱ o bu ke̱be̱ŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ɔ kaapo̱ bamo̱ fe̱yɛ bamo̱ e̱ gye̱ ne̱ baa waa bɔye̱, a le̱e̱ fe̱yɛ bo̱ mo̱ŋ kɔɔre̱ mo̱ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ɔ be̱e̱ ɔ kaapo̱ bamo̱ fe̱yɛ bamo̱ mpo̱rɔ mo̱ŋ gye̱ kase̱ŋtiŋ, a le̱e̱ fe̱yɛ mo̱ ya le̱e̱ mfe̱e̱ ne̱ mo̱ne̱ e̱ mo̱ŋ lɛɛ ŋu mo̱, a kaapo̱ ne̱e̱ fe̱yɛ n se̱ Wuribware̱ ase̱ ne̱ mo̱ a yɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ne̱ ɔ be̱e̱ ɔ kaapo̱ bamo̱ fe̱yɛ baa fo̱ kpa bo̱ le̱e̱ ɔko̱ ne̱ Wuribware̱ i bu ke̱pɔ‑ɔ, a le̱e̱ fe̱yɛ Ɔbɔnsam ne̱ ɔ saŋ o de bamo̱ mfɛɛre̱ se̱ ke̱yaale̱ŋ‑ɔ, ne̱ Wuribware̱ a kyɔ gyi mò̱ ase̱ŋ bu mò̱ ke̱pɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","N de ase̱ŋ bwe̱e̱tɔ a n tɔwe̱ gywii mo̱ne̱, amaa mbe̱yɔmɔ amo̱ kunu e̱ waa mo̱ne̱ ase̱ ko̱kyɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Amaa Wuribware̱ a kufwiiŋe‑o fe̱raa, mò̱ a gye̱ kase̱ŋtiŋ wuye‑o si‑o, mò̱ ya ba, ɔ gye̱ mo̱ne̱ ŋkpɛɛ a mo̱nꞌ nu ke̱tɔ ke̱maa kaase̱. N gye̱ mò̱ fɔŋfɔŋ ke̱yaale̱ŋ se̱ ne̱ ɔ tɔwe̱ ase̱ŋ a o gywii mo̱ne̱. Amaa ɔ tɔwe̱ amo̱ ne̱ oo nu‑o ne̱e̱, na ɔ tɔwe̱ atɔ ne̱ a ba a a bo̱ ba‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ɔ sa mo̱ ke̱dabe̱, a le̱e̱ fe̱yɛ o nu mo̱ ase̱ŋ ne̱ n de‑o, na ɔ tɔwe̱ amo̱ gywii mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ase̱ŋ ne̱ n de‑o amo̱ dɛɛ ne̱ n se̱ mɔ de. Amo̱se̱ se̱ ne̱ mo̱ a tɔwe̱ fe̱yɛ Wuribware̱ a kufwiiŋe‑o i nu mo̱ ase̱ŋ ne̱ n de‑o, na ɔ tɔwe̱ gywii mo̱ne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Amo̱ ya waa kafwe̱e̱, mo̱ne̱ maa lɛɛ ŋu mo̱ pɛɛɛ. Amaa a be̱e̱ bo̱ waa kafwe̱e̱‑ɔ, na mo̱nꞌ be̱e̱ ŋu mo̱, a le̱e̱ fe̱yɛ mo̱ e̱ kpa a ŋ yɔ n se̱ ase̱ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ne̱ mò̱ agyase̱po̱‑ɔ bo̱ko̱ a bise bamo̱ wo̱re̱ wo̱re̱ fe̱yɛ, “E̱me̱ne̱ ne̱ amo̱‑ɔ kaase̱ e̱ kaapo̱‑ɔ ne̱e̱? Ɔ tɔwe̱ o gywii ane̱ fe̱yɛ, amo̱ ya waa kafwe̱e̱, ane̱ maa lɛɛ ŋu mò̱, amaa a be̱e̱ bo̱ waa kafwe̱e̱‑ɔ, ane̱ e̱ be̱e̱ ŋu mò̱. Ne̱ ɔɔ be̱e̱ tɔwe̱ fe̱yɛ, ‘a le̱e̱ fe̱yɛ mo̱ e̱ kpa a ŋ yɔ n se̱ ase̱ ne̱e̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","E̱me̱ne̱ ne̱ ‘a bo̱ waa kafwe̱e̱’ mɔ kaase̱ e̱ kaapo̱‑ɔ ne̱e̱? Ane̱ mo̱ŋ nyi ke̱tɔ ne̱ amo̱‑ɔ e̱ kaapo̱‑ɔ!” ");
INSERT INTO ncuNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yeesuu a pini fe̱yɛ ba kpa a bo̱ bise mò̱‑ɔ se̱‑ɔ, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Ŋ yɛ ɛɛɛ, ‘Amo̱ ya waa kafwe̱e̱, mo̱ne̱ maa lɛɛ ŋu mo̱,’ ne̱ m be̱e̱ ŋ yɛ ɛɛɛ, ‘Amaa a be̱e̱ bo̱ waa kafwe̱e̱‑ɔ, na mo̱nꞌ be̱e̱ ŋu mo̱.’ Amo̱‑ɔ ne̱ mo̱ne̱ i bise abɛɛ aaa? ");
INSERT INTO ncuNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ mo̱ne̱ i su akyukyu na imee, amaa kaye̱‑rɔ ase̱sɛ fe̱raa, a waa bamo̱ kakatɔgyi. A waa mo̱ne̱ e̱wɛɛ, amaa mo̱ne̱ e̱wɛɛ‑ɔ i kyurowi na i kii kakatɔgyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ɔkye̱e̱ e̱ kpa a ɔ ko̱we̱ kayaagyi, amɔ mò̱ ase̱ŋ a waa e̱wɛɛ, a le̱e̱ fe̱yɛ mò̱ awo̱re̱fɔɔ saŋ a fo̱. Amaa mò̱ ya ko̱we̱ kayaagyi‑o, amɔ ɔ taŋ mò̱ awo̱re̱fɔɔ se̱. Na mò̱ akatɔ gyi fe̱yɛ ɔɔ ko̱we̱ kayaagyi bo̱ waa kaye̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ane̱ŋ dɛɛ ne̱ a du mo̱ne̱ ase̱. Mbe̱yɔmɔ a maa waa mo̱ne̱ kɔne̱, amaa m be̱e̱ mo̱ i ŋu mo̱ne̱, na mo̱ne̱ akatɔ gyi kyo̱ŋ se̱, kakatɔgyi ne̱ ɔko̱ maa taare̱ a ɔ kɔɔre̱ le̱e̱ mo̱ne̱ ase̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Kake amo̱ ya fo̱, mo̱ne̱ maa bise mo̱ sɛye̱. Amaa mo̱ i gyi mo̱ne̱ kase̱ŋtiŋ fe̱yɛ n se̱ e̱ gye̱ ne̱ ɔ sa mo̱ne̱ ke̱tɔ ke̱maa ne̱ mo̱ne̱ e̱ ko̱re̱ mò̱ mo̱ ke̱nyare̱‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hare̱e̱ le̱e̱ saŋ‑ɔ bo̱ fo̱ mbe̱yɔmɔ, mo̱ne̱ mo̱ŋ tɛɛ ko̱re̱ ko̱tɔko̱ mo̱ ke̱nyare̱‑rɔ. Le̱e̱ ndɔɔ bo̱ yɔ, mo̱nꞌ ko̱re̱ na mo̱nꞌ nya, na mo̱ne̱ akatɔ nya gyi bwe̱e̱tɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ne̱ Yeesuu a kya se̱ tɔwe̱ fe̱yɛ, “Mbe̱yɔmɔ fe̱raa akpare̱‑rɔ ne̱ mo̱ e̱ kaapo̱ mo̱ne̱ atɔ mɔ. Amaa saŋ ko̱ e̱ ba, ne̱ ma lɛɛ ba akpare̱ a m bo̱ kaapo̱ mo̱ne̱. Saŋ amo̱ fe̱raa, mo̱ e̱ tɔwe̱ n se̱ ase̱ŋ a ŋ kaapo̱‑rɔ gywii mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Kake amo̱ ya fo̱ fe̱raa, n gye̱ mo̱ e̱ gye̱ ne̱ mo̱ e̱ ko̱re̱ n se̱ mo̱ne̱ kuŋu si ko̱tɔko̱. Mo̱ne̱ fɔŋfɔŋ e̱ ko̱re̱ mò̱ mo̱ ke̱nyare̱‑rɔ, ");
INSERT INTO ncuNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","a le̱e̱ fe̱yɛ n se̱ fɔŋfɔŋ e̱ kpa mo̱ne̱ ase̱ŋ. Ke̱tɔ se̱ ne̱ n se̱ Wuribware̱ e̱ kpa mo̱ne̱‑ɔ e̱ gye̱ fe̱yɛ mo̱ne̱ e̱ kpa mo̱ ase̱ŋ, ne̱ mo̱ne̱ a kɔɔre̱ gyi fe̱yɛ mo̱ a le̱e̱ mò̱ ase̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mo̱ a le̱e̱ n se̱ ase̱ ne̱e̱, ne̱ mo̱ a ba kaye̱‑rɔ. Ne̱ mbe̱yɔmɔ mo̱ e̱ le̱e̱ kaye̱‑rɔ a ŋ yɔ n se̱ ase̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ne̱ mò̱ agyase̱po̱‑ɔ a tɔwe̱ gywii mò̱ fe̱yɛ, “Ɛhɛɛɛŋ, ŋkee fe̱raa fo̱ a sa se̱ŋsa, na fo̱ mo̱ŋ lɛɛ fo̱ de akpare̱ fo̱ e̱ waa‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ane̱ nyi mbe̱yɔmɔ fe̱yɛ fo̱ nyi ke̱tɔ ke̱maa. Fo̱ nyi ke̱tɔ ne̱ ke̱ bo̱ ane̱ mfɛɛre̱‑rɔ‑ɔ. Amo̱se̱, a mo̱ŋ lɛɛ a tiri fe̱yɛ ɔko̱ bise fo̱ se̱ŋbise ke̱maa. Amo̱‑ɔ e̱ gye̱ ne̱ a sa a ane̱ kɔɔre̱ gyi fe̱yɛ fo̱ a le̱e̱ Wuribware̱ ase̱ ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Mo̱ne̱ e̱ kɔɔre̱ mo̱ mo̱ne̱ i gyi aaa? ");
INSERT INTO ncuNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Saŋ e̱ ba, ɔ kyɔ ɔ fo̱ mfe̱e̱ gbaa, saŋ ne̱ mo̱ne̱ pɛɛɛ e̱ brawe̱‑rɔ‑ɔ, na mo̱nꞌ se̱re̱ yɔwe̱ mo̱ wo̱re̱ kpeŋ bo̱ sii mfe̱e̱. Na mo̱ne̱ ɔke̱maa se̱re̱ yɔ mò̱ aye̱. Amaa kase̱ŋtiŋ si, n gye̱ sa ne̱ mo̱ a saŋ mo̱ wo̱re̱, a le̱e̱ fe̱yɛ n se̱ bo̱ mo̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mo̱ a tɔwe̱ amo̱‑ɔ gywii mo̱ne̱ ne̱e̱ a mo̱nꞌ nya nya kaye̱e̱yuri ne̱ ka le̱e̱ mo̱ ase̱‑ɔ. Kaye̱‑rɔ ase̱sɛ e̱ sa a mo̱nꞌ kpo̱ne̱. Amaa mo̱nꞌ nya wɔre̱ saŋ ke̱maa, a le̱e̱ fe̱yɛ mo̱ a kɔ gyi Ɔbɔnsam, kaye̱‑rɔ a ɔyaale̱ŋpo̱‑ɔ, se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yeesuu a tɔwe̱ amo̱‑ɔ lo̱we̱‑ɔ, ne̱ ɔɔ de̱e̱re̱ Wuribware̱ se̱, ne̱ ɔ yɛ, “N se̱, mo̱ saŋ‑ɔ a fo̱. Sa mo̱ ke̱dabe̱ na wuraa, na n sa a ase̱sɛ ŋu fo̱ ke̱dabe̱ na wuraa ne̱ fo̱ de‑o, ");
INSERT INTO ncuNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","a le̱e̱ fe̱yɛ fo̱ ya sa mo̱ ke̱yaale̱ŋ ase̱sɛ pɛɛɛ se̱, na ŋ nya taa ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ bo̱ sa bamo̱ pɛɛɛ ne̱ fo̱ a sa mo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Bamo̱ a de ŋkpa na kukyure mɔ ne̱ a mo̱ŋ de kɛɛ‑ɔ se̱‑ɔ, bo̱ nyi fo̱, Wuribware̱, ne̱ fo̱ wo̱re̱ kpeŋ e̱ gye̱ nyaŋpe̱‑ɔ, ne̱ bo̱ nyi mo̱, Yeesuu Kristoo, ne̱ fo̱ a suŋ mo̱ bo̱ kyo̱ŋwe̱ kaye̱ mɔ‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mo̱ a lo̱we̱ kusuŋ ne̱ fo̱ a sa mo̱ fe̱yɛ ŋ waa‑ɔ se̱‑ɔ, mo̱ a kaapo̱ fo̱ ke̱dabe̱ na wuraa kaye̱ mɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","N se̱, sa a n kye̱na fo̱ ase̱ mbe̱yɔmɔ, na ŋ nya ke̱dabe̱ na wuraa ne̱ mo̱ aa fo̱ dɛɛ ane̱ de pwɛɛ ne̱ ane̱ a dɛɛ twe̱e̱ kaye̱ mɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Mo̱ a sa ne̱ mo̱ agyase̱po̱ mɔ ne̱ fo̱ a lee le̱e̱ kaye̱ mɔ‑rɔ sa mo̱‑ɔ pɛɛɛ a gyii fo̱. Bo̱ gye̱ fo̱ lee ne̱e̱, ne̱ fo̱ a taa bamo̱ sa mo̱. Ne̱ baa nu fo̱ kanɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Mbe̱yɔmɔ fe̱raa, bo̱ nyi fe̱yɛ ke̱tɔ ke̱maa ne̱ fo̱ a sa mo̱‑ɔ a le̱e̱ fo̱ ase̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ase̱ŋ ne̱ fo̱ a bo̱ sa mo̱‑ɔ ne̱ mo̱ a tɔwe̱ gywii bamo̱, ne̱ baa kɔɔre̱ amo̱ gyi. Bo̱ nyi fe̱yɛ kase̱ŋtiŋ si ne̱ mo̱ a le̱e̱ fo̱ ase̱ ba. Ne̱ baa kɔɔre̱ gyi fe̱yɛ fo̱ ya suŋ mo̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Amo̱se̱‑ɔ, mo̱ e̱ ko̱re̱ ke̱bware̱ko̱re̱ mo̱ e̱ sa bamo̱ ne̱e̱. N gye̱ kaye̱‑rɔ ase̱sɛ pɛɛɛ ne̱ mo̱ e̱ ko̱re̱ mo̱ e̱ sa mbe̱yɔmɔ, amaa mo̱ agyase̱po̱ mɔ ne̱ fo̱ a sa mo̱‑ɔ ne̱ mo̱ e̱ ko̱re̱ ke̱bware̱ko̱re̱ mo̱ e̱ sa. ");
INSERT INTO ncuNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Se̱sɛ ke̱maa ne̱ m bo̱ mò̱‑ɔ gye̱ fo̱ se̱sɛ ne̱e̱, ne̱ se̱sɛ ke̱maa ne̱ fo̱ bo̱ mò̱‑ɔ mɔ gye̱ mo̱ se̱sɛ. Ne̱ mo̱ ke̱dabe̱ a bo̱rɔ bamo̱ se̱ le̱e̱ kawu. ");
INSERT INTO ncuNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ne̱ mbe̱yɔmɔ mo̱ e̱ ba fo̱ ase̱. Ma lɛɛ kye̱na kaye̱‑rɔ. Amaa bamo̱ fe̱raa, bo̱ te kaye̱ mɔ‑rɔ ne̱e̱. N se̱ kpe̱yaa, mo̱ e̱ ko̱re̱ fo̱ fe̱yɛ fo̱ ba fo̱ ke̱nyare̱ ne̱ fo̱ a be̱e̱ sa mo̱‑ɔ ke̱yaale̱ŋ bo̱ kuŋ bamo̱, na bo̱ nya waa ko̱ko̱ŋko̱, fe̱yɛ ane̱ŋ ne̱ mo̱ aa fo̱ e̱ gye̱ ko̱ko̱ŋko̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Mo̱ a bo̱ bamo̱ ase̱‑ɔ, ne̱ mo̱ a ba ke̱nyare̱ amo̱ ne̱ fo̱ a sa mo̱‑ɔ ke̱yaale̱ŋ bo̱ kuŋ bamo̱. Ane̱ŋ se̱‑ɔ, bamo̱ ɔko̱ŋko̱ mo̱ŋ fo̱, amɔ odiburopo̱ ne̱ fo̱ a kyɔ tɔwe̱ fe̱yɛ ɔ fo̱‑ɔ, na ane̱ŋ ne̱ baa kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ nya waa kase̱ŋtiŋ. ");
INSERT INTO ncuNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ne̱ mbe̱yɔmɔ mo̱ e̱ ba fo̱ ase̱ ne̱e̱. Mo̱ e̱ tɔwe̱ ase̱ŋ mɔ kaye̱ mɔ‑rɔ ne̱e̱ na bo̱ nya nya mo̱ kakatɔgyi ne̱ n de‑o bamo̱ ŋkpo̱nɔ‑rɔ bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mo̱ a tɔwe̱ fo̱ ase̱ŋ gywii bamo̱, ne̱ kaye̱ mɔ‑rɔ ase̱sɛ a kisi bamo̱, bo̱ le̱e̱ ane̱ŋ ne̱ bo̱ mo̱ŋ tii kaye̱ mɔ‑rɔ a ase̱sɛ‑ɔ se̱‑ɔ, fe̱yɛ ane̱ŋ dɛɛ ne̱ ŋ gbaa mo̱ŋ tii kaye̱ mɔ‑rɔ a ase̱sɛ‑ɔ se̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ma ko̱re̱ fo̱ ne̱e̱ fe̱yɛ fo̱ lee bamo̱ le̱e̱ kaye̱ mɔ‑rɔ. Amaa ke̱tɔ ne̱ mo̱ e̱ ko̱re̱ fo̱ bwe̱e̱tɔ‑ɔ e̱ gye̱ fe̱yɛ fo̱ kuŋ bamo̱ na bo̱ ma lwee Ɔbɔnsam ke̱sare̱e̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Fe̱yɛ ane̱ŋ ne̱ mo̱ŋ tii kaye̱ mɔ‑rɔ a ase̱sɛ‑ɔ se̱‑ɔ, ane̱ŋ dɛɛ ne̱ bamo̱ gbaa bo̱ mo̱ŋ tii kaye̱ mɔ‑rɔ a ase̱sɛ‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Amo̱se̱‑ɔ, de̱e̱ sa a bo̱ gyii fo̱ kase̱ŋtiŋ‑o na bo̱ nya yɔwe̱ kaye̱ mɔ bo̱ sii kamɛɛ taa bamo̱ e̱ye̱e̱ bo̱ sa fo̱ kase̱ŋtiŋ‑no, a le̱e̱ fe̱yɛ fo̱ ase̱ŋ ne̱ fo̱ e̱ tɔwe̱‑ɔ gye̱ kase̱ŋtiŋ. ");
INSERT INTO ncuNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mo̱ a suŋ bamo̱ bo̱ kyo̱ŋwe̱ kaye̱‑rɔ ne̱e̱ fe̱yɛ ane̱ŋ dɛɛ ne̱ fo̱ a suŋ mo̱ bo̱ kyo̱ŋwe̱ kaye̱‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mo̱ a kperi bamo̱ se̱ taa mo̱ e̱ye̱e̱ bo̱ sa fo̱, na bamo̱‑ɔ bo̱ nya nya taa bamo̱ e̱ye̱e̱ bo̱ sa fo̱ kase̱ŋtiŋ‑no saŋ ke̱maa. ");
INSERT INTO ncuNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ne̱ mbe̱yɔmɔ mo̱ e̱ ko̱re̱ ke̱bware̱ko̱re̱ mo̱ e̱ sa bamo̱ ne̱ ba kɔɔre̱ mo̱ a bo̱ gyi bo̱ le̱e̱ mo̱ agyase̱po̱ mɔ abware̱se̱ŋ ko̱tɔwe̱‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mo̱ ke̱bware̱ko̱re̱ e̱ gye̱ fe̱yɛ bamo̱ pɛɛɛ waa ko̱ko̱ŋko̱. Sa a mo̱ aa bamo̱ aa fo̱ waa ko̱ko̱ŋko̱. N se̱, sa a bo̱ waa ko̱ko̱ŋko̱ fe̱yɛ ane̱ŋ ne̱ mo̱ aa fo̱ gye̱ ko̱ko̱ŋko̱‑ɔ, na kaye̱‑rɔ ase̱sɛ nya kɔɔre̱ gyi fe̱yɛ fo̱ ya suŋ mo̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mo̱ a sa bamo̱ ke̱dabe̱ na wuraa ko̱ŋko̱ ne̱ fo̱ a sa mo̱‑ɔ dɛɛ, na bo̱ nya waa ko̱ko̱ŋko̱ fe̱yɛ ane̱ŋ ne̱ mo̱ aa fo̱ gye̱ ko̱ko̱ŋko̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Na fo̱ sa a mo̱ aa bamo̱ a tii fo̱ se̱ waa ko̱ko̱ŋko̱ kpeŋ, na kaye̱ mɔ‑rɔ a ase̱sɛ‑ɔ nya ŋu fe̱yɛ fo̱ ya suŋ mo̱, ne̱ fo̱ e̱ kpa bamo̱ ase̱ŋ fe̱yɛ ane̱ŋ ne̱ fo̱ e̱ kpa mo̱ ase̱ŋ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","N se̱, agyase̱po̱ ne̱ fo̱ a sa mo̱‑ɔ fe̱raa, ne̱ mo̱ e̱ kpa fe̱yɛ bo̱ ba mo̱ ase̱ mfe̱ŋ ne̱ mo̱ e̱ yɔ‑ɔ, na bo̱ nya ŋu mo̱ ke̱dabe̱ na wuraa, ke̱dabe̱ na wuraa ne̱ fo̱ a sa mo̱‑ɔ, a le̱e̱ fe̱yɛ fo̱ a kpa mo̱ ase̱ŋ pwɛɛ ne̱ ane̱ a dɛɛ twe̱e̱ kaye̱ mɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","N se̱ timaa, kaye̱ mɔ‑rɔ a ase̱sɛ‑ɔ mo̱ŋ nyi fo̱, amaa ŋ nyi fo̱. Ne̱ mo̱ agyase̱po̱‑ɔ mɔ bo̱ nyi fe̱yɛ fo̱ ya suŋ mo̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mo̱ a sa ne̱ baa gyii fo̱. Amaa mo̱ e̱ kya se̱ a n sa a bo̱ gyii fo̱, na ke̱kpa ne̱ fo̱ de sa mo̱‑ɔ nya sii bamo̱ ŋkpo̱nɔ‑rɔ, na mo̱ aa bamo̱ waa ko̱ko̱ŋko̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yeesuu a ko̱re̱ ke̱bware̱ko̱re̱ mɔ lo̱we̱‑ɔ, ne̱ mò̱ aa mò̱ agyase̱po̱‑ɔ a nare̱ ya te̱ŋ Kidrɔŋ Ke̱maŋtaŋ‑nɔ. Baa gyi bane̱ bo̱ muruwaa ayii ko̱ mfe̱ŋ, ne̱ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ a ya lweero. ");
INSERT INTO ncuNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yudas odiburopo̱‑ɔ mɔ nyi mfe̱ŋ ne̱ bane̱‑ɔ bo̱‑ɔ, a le̱e̱ fe̱yɛ Yeesuu mò̱ aa mò̱ agyase̱po̱‑ɔ a gyaŋŋe̱ mfe̱ŋ iluwi bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Amo̱se̱‑ɔ ne̱ Yudas a ba mfe̱ŋ. Mò̱ aa Roma asoogyaa awuye ko̱ na Wuribware̱ suŋkpa ade̱e̱re̱se̱po̱ ko̱ ne̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ na Farisii awuye a suŋ‑o ya ba. Na bo̱ de ado̱ŋtɔ na ifetiri na e̱pɔɔrɔɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yeesuu nyi ke̱tɔ ke̱maa ne̱ ke̱ e̱ ba a ke̱ bo̱ waa mò̱‑ɔ. Amo̱se̱ se̱‑ɔ ne̱ ɔɔ me̱raa se̱ ɔ yɔ bamo̱ ase̱, ne̱ oo bise bamo̱ fe̱yɛ, “Nsɛ ne̱ mo̱ne̱ i buwi mo̱ne̱ e̱ kpa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ne̱ baa lee kanɔ fe̱yɛ, “Yeesuu Nasarɛte̱nyi‑o.” Ne̱ ɔ yɛ, “Mo̱ e̱ bo̱ mfe̱e̱‑ɔ.” Yudas odiburopo̱‑ɔ ye̱re̱ bamo̱ ne̱ mò̱ aa bamo̱ a ba‑ɔ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ e̱ bo̱ mfe̱e̱‑ɔ”‑ɔ, ne̱ baa lwii kamɛɛ ya le̱e̱ daye̱ swe̱e̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ne̱ Yeesuu a be̱e̱ bise bamo̱ fe̱yɛ, “Nsɛ ne̱ mo̱ne̱ i buwi mo̱ne̱ e̱ kpa?” Ne̱ bo̱ be̱e̱ bo̱ yɛ, “Yeesuu Nasarɛte̱nyi‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Mo̱ a kyɔ tɔwe̱ gywii mo̱ne̱ fe̱yɛ m bo̱ mfe̱e̱. Mo̱ne̱ i buwi mo̱ne̱ e̱ kpa mo̱ fe̱raa, mo̱nꞌ sa a bo̱mo̱‑ɔ ne̱ bo̱ tii mo̱ se̱‑ɔ nare̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ɔɔ tɔwe̱ amo̱‑ɔ ne̱e̱ a ke̱tɔ ne̱ ɔɔ kyɔ tɔwe̱‑ɔ nya waa kase̱ŋtiŋ fe̱yɛ, “N se̱, mo̱ŋ sa ne̱ fo̱ ase̱sɛ ne̱ fo̱ a sa mo̱‑ɔ ɔko̱ŋko̱ gbaa a fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saŋ amo̱‑ɔ Simɔŋ Peetroo de ke̱paŋ, ne̱ oo gyiiri ke̱mo̱ le̱e̱ ke̱mo̱ ke̱gyafo̱‑rɔ bo̱ ŋe Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ a anya‑ɔ ɔko̱ kigyisese̱bɔ te̱ŋ. Ke̱nya‑ɔ ke̱nyare̱ e̱ gye̱ Malakus. ");
INSERT INTO ncuNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ne̱ Yeesuu a tɔwe̱ gywii Peetroo fe̱yɛ, “Taa fo̱ ke̱paŋ‑ɔ waa ke̱mo̱ ke̱gyafo̱‑rɔ! A le̱e̱ fe̱yɛ a tiri fe̱yɛ n gyi awo̱re̱fɔɔ mɔ, na ŋ wu lowi ne̱ n se̱ Wuribware̱ a tɔwe̱ fe̱yɛ ŋ wu‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ne̱ asoogyaa awuye‑o na bamo̱ ɔbre̱sɛ na Wuribware̱ suŋkpa a ade̱e̱re̱se̱po̱‑ɔ a kra Yeesuu, ne̱ baa ŋure mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ne̱ baa taa mò̱ yaa Hanaa ne̱ ɔ gye̱ Kayafas mò̱ saa nyaŋsɛ‑ɔ aye̱. Hanaa dɛɛ ɔ gye̱ Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ. Kayafas mɔ e̱ gye̱ Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ kasu amo̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafas ya fo̱re̱ waa Yudaa awuye abre̱sɛ‑rɔ fe̱yɛ a bware fe̱yɛ se̱sɛ ko̱ŋko̱ wu sa ase̱sɛ pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simɔŋ Peetroo na agyase̱po̱‑ɔ ɔko̱ a gya Yeesuu si. Ane̱ŋ a ɔgyase̱po̱‑ɔ nyi Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ‑ɔ dame̱naŋsɛ, amo̱se̱ se̱‑ɔ ne̱ mò̱ aa Yeesuu a nare̱ yɔ ɔlɔŋŋɔpo̱ bre̱sɛ a lɔŋ‑ɔ kabuno. ");
INSERT INTO ncuNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Peetroo a sii ɔ bo̱ lɔŋ‑ɔ kibunogyi‑ro‑o si‑o, mò̱ ko̱so̱bɛɛ ɔgyase̱po̱ ne̱ o nyi ɔlɔŋŋɔpo̱ bre̱sɛ‑ɔ dame̱naŋsɛ‑ɔ a kiŋŋi yɔ kibunogyi‑o‑ro ya sa se̱ŋsa ko̱ gywii kakye̱e̱sɛɛ ne̱ ɔ ye̱re̱ kibunogyi‑o‑ro‑o, ne̱ ɔɔ sa ne̱ Peetroo a lweero. ");
INSERT INTO ncuNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kakye̱e̱sɛɛ ne̱ ɔ ye̱re̱ kibunogyi‑o‑ro‑o a bise Peetroo fe̱yɛ, “Ne̱e̱ fo̱ gye̱ Yeesuu mɔ agyase̱po̱‑ɔ ɔko̱ ne̱e̱ ɛ?” Ne̱ Peetroo a lee kanɔ fe̱yɛ, “Daabii! N gye̱ bamo̱ ɔko̱ e̱ gye̱ mo̱!” ");
INSERT INTO ncuNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Saŋ amo̱‑ɔ afwii bo̱‑rɔ. Ane̱ŋ se̱‑ɔ ne̱ ayaafɔre̱ na ade̱e̱re̱se̱po̱‑ɔ a ba aduŋdurii bo̱ kure de̱e̱kpa, ne̱ baa kya muruwaa ba wo̱re̱, ne̱ Peetroo a yɔ bamo̱ ase̱ mfe̱ŋ ɔ wo̱re̱ de̱e̱kpa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ne̱ Hanaa a bise Yeesuu mò̱ agyase̱po̱‑ɔ kuŋu si ase̱ŋ na mò̱ ke̱kaapo̱‑ɔ ase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Saŋ ke̱maa lamaŋ‑nɔ ne̱ mo̱ e̱ tɔwe̱ abware̱se̱ŋ na mo̱ e̱ kaapo̱ atɔ ke̱bware̱ko̱re̱ akyaŋ‑nɔ na Wuribware̱ suŋkpa mfe̱ŋ ne̱ Yudaa awuye e̱ gyaŋŋe̱‑ɔ. Mo̱ŋ tɛɛ tɔwe̱ ko̱tɔko̱ bo̱ kwe̱e̱rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ne̱ e̱me̱ne̱ se̱ ne̱ fo̱ i bise mo̱ ane̱ŋ a se̱ŋbise mɔ? Bise ase̱sɛ ne̱ mo̱ a kaapo̱ bamo̱‑ɔ. Bise bamo̱ ke̱tɔ ne̱ mo̱ a tɔwe̱ gywii bamo̱‑ɔ. Bo̱ nyi ke̱tɔ ne̱ mo̱ a tɔwe̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yeesuu a tɔwe̱ amo̱‑ɔ, ne̱ ade̱e̱re̱se̱po̱‑ɔ ɔko̱ ne̱ ɔ ye̱re̱ mfe̱ŋ‑ɔ a da mò̱ akatɔ‑rɔ ke̱baa tɔwe̱ fe̱yɛ, “E̱me̱ne̱ se̱ ne̱ fo̱ e̱ sa se̱ŋsa ane̱ŋ fo̱ i gywii Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ‑ɔ?” ");
INSERT INTO ncuNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ne̱ Yeesuu a be̱ŋŋaa mò̱ fe̱yɛ, “Mo̱ ya tɔwe̱ ase̱ŋ ne̱ amo̱ e̱ mo̱ŋ bo̱ daŋ, fo̱ tɔwe̱ ane̱ŋ a ase̱ŋ‑ɔ na ɔke̱maa nu. Ne̱ ke̱tɔ ne̱ mo̱ a tɔwe̱‑ɔ mɔ e̱ gye̱ kase̱ŋtiŋ, ne̱ nte̱tɔ se̱ ne̱ ŋkee fo̱ e̱ da mo̱‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Amo̱‑ɔ kamɛɛ‑rɔ, ne̱ Hanaa a sa ne̱ baa yaa Yeesuu ya bo̱ sa Kayafas, Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ‑ɔ, na agbarabi saŋ a ŋure mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Peetroo saŋ ɔ ye̱re̱ ayaafɔre̱‑ɔ na ade̱e̱re̱se̱po̱‑ɔ ase̱ ɔ wo̱re̱ de̱e̱kpa. Ne̱ bamo̱ bo̱ko̱ a bise mò̱ fe̱yɛ, “Ne̱e̱ fo̱ gye̱ Yeesuu mɔ a agyase̱po̱‑ɔ ɔko̱ ne̱e̱ ɛ?” Amaa Peetroo a swe̱e̱ fe̱yɛ, “Daabii! N gye̱ bamo̱ ɔko̱ e̱ gye̱ mo̱!” ");
INSERT INTO ncuNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ne̱ Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ a anya‑ɔ ɔko̱ ne̱ Peetroo a ba ke̱paŋ bo̱ ŋe mò̱ ke̱se̱bɔ te̱ŋ‑ɔ mò̱ nyipo̱ ko̱ a bise Peetroo fe̱yɛ, “Ne̱e̱ mo̱ a ŋu fo̱ bo̱ mò̱ ase̱ bane̱‑ɔ‑rɔ ɛ?” ");
INSERT INTO ncuNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ne̱ Peetroo a be̱e̱ tɔwe̱ fe̱yɛ, “Daabii!” Puri amo̱‑rɔ, ne̱ kyaŋare̱ a fo̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ne̱ baa lee Yeesuu le̱e̱ Kayafas ase̱ yaa Romanyi gominaa ne̱ ba te̱e̱ mò̱ ɛ Pilat‑o leŋbu‑ro. Saŋ amo̱‑ɔ gye̱gyaye̱ kese‑ro ne̱e̱. Yudaa awuye abre̱sɛ mo̱ŋ kpa kulwee Romanyi leŋbu‑o‑ro a le̱e̱ fe̱yɛ bo̱ yɛ bamo̱ ya waa ane̱ŋ, iyisi e̱ kye̱na bamo̱ se̱, na bo̱ ma taare̱ nya kpa gyi Wuribware̱-a‑kya-ane̱-yɔwe̱ a ateese‑o. ");
INSERT INTO ncuNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Amo̱se̱ se̱‑ɔ ne̱ Gominaa Pilat a le̱e̱ yɔ bamo̱ ase̱ kawu ya bise bamo̱ fe̱yɛ, “Nte̱tɔ bɔye̱ ne̱ ɔnyare̱ mɔ a waa ne̱ mo̱ne̱ a baa mò̱ mfe̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ne̱ baa lee kanɔ fe̱yɛ, “Ɔ dɛɛ ɔ mo̱ŋ waa bɔye̱ ne̱e̱, weetee ane̱ maa baa mò̱ fo̱ ase̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ne̱ gominaa‑o a tɔwe̱ gywii bamo̱ fe̱yɛ, “To, mo̱nꞌ taa mò̱ kiŋŋi, na mo̱nꞌ ya ba mo̱ne̱ fɔŋfɔŋ mbraa bo̱ gyi mò̱ ase̱ŋ.” Ne̱ baa lee kanɔ fe̱yɛ, “Mo̱ne̱ Roma awuye mo̱ŋ sa ane̱ kpa fe̱yɛ ane̱ mɔɔ abɔye̱waapo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Amo̱‑ɔ a ba ne̱e̱ a ke̱tɔ ne̱ Yeesuu a tɔwe̱‑ɔ nya waa kase̱ŋtiŋ bo̱ le̱e̱ lowi suyo ne̱ ɔ ba a ɔ bo̱ wu‑o si. ");
INSERT INTO ncuNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ne̱ gominaa‑o a kiŋŋi yɔ mò̱ leŋbu‑ro, ne̱ ɔɔ te̱e̱ Yeesuu baa bo̱ ye̱ra mò̱ akatɔ‑rɔ. Ne̱ ɔ yɛ, “Baa po̱rɔ fo̱ fe̱yɛ fo̱ a tɔwe̱ fe̱yɛ fo̱ e̱ gye̱ Yudaa awuye owure‑o. E̱me̱ne̱ ne̱ fo̱ i lee kanɔ?” ");
INSERT INTO ncuNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ne̱ Yeesuu a be̱ŋŋaa mò̱ fe̱yɛ, “Se̱ŋbise mɔ a le̱e̱ fo̱ ase̱ ne̱e̱, bɛɛɛ bo̱ko̱ ya tɔwe̱ mo̱ ase̱ŋ gywii fo̱ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ne̱ gominaa‑o a be̱ŋŋaa mò̱ fe̱yɛ, “Nte̱tɔ ne̱ fo̱ e̱ sa se̱ŋsa fo̱ i gywii mo̱ fe̱yɛ mo̱ a gye̱ Yudaanyi‑o? Fo̱ fɔŋfɔŋ ase̱sɛ na fo̱ fɔŋfɔŋ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ ya taa fo̱ bo̱ waa mo̱ ke̱sare̱e̱‑rɔ. Nte̱tɔ ne̱ fo̱ a waa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Amo̱ e̱ gye̱ kase̱ŋtiŋ fe̱yɛ mo̱ e̱ gye̱ owure‑o, n gye̱ kaye̱ mɔ‑rɔ ne̱ mo̱ i gyi kuwure. N dɛɛ mo̱ i gyi kaye̱ mɔ‑rɔ kuwure ne̱e̱, weetee mo̱ kamɛɛ‑rɔ awuye a kɔ bo̱ kuŋ mo̱ na m ma lwee Yudaa awuye abre̱sɛ‑ɔ ke̱sare̱e̱‑rɔ. Daabii, kuwure ne̱ mo̱ i gyi‑o mo̱ŋ bo̱ kaye̱ mɔ‑rɔ mfe̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ne̱ gominaa‑o a bise mò̱ fe̱yɛ, “To, ne̱e̱ fo̱ gye̱ owure ne̱e̱, bɛɛɛ?” Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Mo̱ kuwure mo̱ŋ du fe̱yɛ kuwure ne̱ fo̱ i bise mo̱ ke̱mo̱ ase̱ŋ‑ɔ. Ase̱ŋ ko̱ŋko̱ mɔ se̱ dɛɛ ne̱ baa ko̱we̱ mo̱ waa kaye̱ mɔ‑rɔ na m bo̱ tɔwe̱ kase̱ŋtiŋ‑o. Ɔke̱maa ne̱ ɔ bo̱ kase̱ŋtiŋ a ke̱be̱gya‑ɔ se̱‑ɔ e̱ gya mo̱ kanɔ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ne̱ gominaa‑o a bise mò̱ fe̱yɛ, “Nte̱tɔ e̱ gye̱ kase̱ŋtiŋ?” Ne̱ Gominaa Pilat a kiŋŋi yɔ kawu lamaŋ‑ɔ ase̱, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “M fe̱raa, ma taare̱ a ŋ ŋu ke̱tɔ ne̱ mo̱ e̱ ye̱re̱ se̱ na m bo̱ bu ɔnyare̱ mɔ ke̱pɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","To, ane̱ de ananatɔ ko̱ ne̱ ane̱ e̱ waa ane̱ e̱ sa mo̱ne̱ Wuribware̱-a‑kya-ane̱-yɔwe̱ ateese kigyibe̱e̱ ke̱maa‑rɔ‑ɔ. Amo̱ e̱ gye̱ fe̱yɛ ane̱ lee ase̱sɛ ne̱ ane̱ a tii bamo̱ tiikpa‑ɔ ɔko̱ bo̱ sa mo̱ne̱. Amo̱se̱‑ɔ mbe̱yɔmɔ, mo̱ne̱ e̱ kpa fe̱yɛ n lee mo̱ne̱ Yudaa awuye owure bo̱ sa mo̱ne̱ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ne̱ baa fɛɛ‑rɔ fe̱yɛ, “Daabii! N gye̱ mò̱ ne̱ ane̱ e̱ kpa fe̱yɛ fo̱ lee le̱e̱ tiikpa‑ɔ bo̱ sa ane̱. Lee Bar‑Abas bo̱ sa ane̱!” Bar‑Abas mɔ gye̱ bamo̱ ne̱ baa ko̱so̱ kɔ bo̱ kye Roma abane̱ maŋ mɔ‑rɔ‑ɔ ɔko̱ ne̱ baa kra mò̱ tii‑o ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ne̱ Gominaa Pilat a sa ne̱ mò̱ asoogyaa awuye a da Yeesuu paara. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ne̱ asoogyaa awuye‑o a ba iwu bo̱ lo̱ kuwurepa bo̱ buŋ mò̱, ne̱ baa ba waagya pipee bo̱ buŋ mò̱ fe̱yɛ mò̱ a gye̱ owure‑o. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ne̱ ba ba mò̱ ase̱ ba tɔwe̱ fe̱yɛ, “Aŋsuma, nana, Yudaa awuye owure!” Ne̱ baa daye̱ mò̱ akatɔ‑rɔ abaa kpo̱ra‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ne̱ gominaa‑o a be̱e̱ le̱e̱ ya tɔwe̱ gywii lamaŋ‑ɔ fe̱yɛ, “Mo̱nꞌ laatɔ a mo̱nꞌ nu. Mo̱ i lee mò̱ a m baa mo̱ne̱ ase̱ kawu mfe̱e̱, na mo̱nꞌ nya ŋu fe̱yɛ ma taare̱ a ŋ nya ke̱tɔ ne̱ mo̱ e̱ ye̱re̱ ke̱mo̱ se̱ a m bo̱ bu mò̱ ke̱pɔ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Amo̱se̱ se̱‑ɔ ne̱ Yeesuu a le̱e̱ kawu na o buŋ iwu kuwurepa‑ɔ na waagya pipee‑o. Ne̱ gominaa‑o a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱nꞌ ke̱e̱ ɔnyare̱‑ɔ ne̱e̱!” ");
INSERT INTO ncuNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Saŋ ne̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ na Wuribware̱ suŋkpa ade̱e̱re̱se̱po̱‑ɔ a ŋu mò̱‑ɔ, ne̱ baa fɛɛ‑rɔ tɔwe̱ fe̱yɛ, “Da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱! Da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱!” Ne̱ gominaa‑o a tɔwe̱ gywii bamo̱ fe̱yɛ, “Amo̱ fe̱raa mo̱ne̱ fɔŋfɔŋ taa mò̱ ya da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱. M fe̱raa, ma taare̱ a ŋ ŋu ke̱tɔ bɔye̱ ne̱ ɔɔ waa, ne̱ mo̱ e̱ ye̱re̱ se̱ a m bo̱ bu mò̱ ke̱pɔ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ne̱ lamaŋ‑ɔ a tɔwe̱ bo̱ kyo̱ŋwe̱ mò̱ fe̱yɛ, “Ane̱ de mbraa ne̱ ŋ kaapo̱ fe̱yɛ ɔke̱maa ne̱ ɔ yɛ ɔ gye̱ Wuribware̱ mò̱ gyi‑o, a bware fe̱yɛ o wu. Ɔnyare̱ mɔ yɛ ɔ gye̱ Wuribware̱ mò̱ gyi‑o ne̱e̱. Amo̱se̱ se̱‑ɔ a bware fe̱yɛ o wu.” ");
INSERT INTO ncuNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Gominaa‑o a nu baa tɔwe̱ amo̱‑ɔ, ne̱ kufu ne̱ o de‑o a tii si. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ne̱ oo kiŋŋi yɔ leŋbu‑o‑ro ya bise Yeesuu fe̱yɛ, “Mfe̱ne̱ ne̱ fo̱ a le̱e̱?” Amaa Yeesuu mo̱ŋ lee kanɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ne̱ gominaa‑o a be̱e̱ bise mò̱ fe̱yɛ, “Fo̱ maa be̱ŋŋaa mo̱ ne̱e̱ e̱e̱e̱? Nyiŋŋi si fe̱yɛ n de ke̱yaale̱ŋ fe̱yɛ ŋ yɔwe̱ fo̱ a fo̱ ya kyure, ne̱ n de ke̱yaale̱ŋ fe̱yɛ n da fo̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ne̱ Yeesuu a lee kanɔ fe̱yɛ, “Fo̱ de mo̱ se̱ ke̱yaale̱ŋ a le̱e̱ fe̱yɛ Wuribware̱ ya taa bo̱ sa fo̱. Amo̱se̱ se̱‑ɔ, ɔnyare̱ ne̱ ɔɔ taa mo̱ bo̱ sa fo̱‑ɔ e̱ gye̱ ne̱ ɔɔ waa bɔye̱ kyo̱ŋ fo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Gominaa‑o a nu amo̱‑ɔ, ne̱ ɔɔ le̱ŋ e̱ye̱e̱ ɔ kpa kpa ne̱ ɔ ye̱re̱ se̱ a ɔ bo̱ yɔwe̱ Yeesuu‑o. Amaa lamaŋ‑ɔ a fɛɛ‑rɔ bo̱ kyo̱ŋwe̱ mò̱ fe̱yɛ, “Fo̱ ya yɔwe̱ ɔnyare̱ mɔ bo̱ kyo̱ŋwe̱ kwaa, amo̱ fe̱raa fo̱ mo̱ŋ gye̱ fo̱ owure dabe̱‑ɔ mò̱ nyare̱ ne̱e̱! Ɔke̱maa ne̱ ɔ ba mò̱ e̱ye̱e̱ a ɔ bo̱ kii owure‑o gye̱ owure dabe̱‑ɔ do̱ŋ ne̱e̱!” ");
INSERT INTO ncuNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Gominaa‑o a nu amo̱‑ɔ, ne̱ oo lee Yeesuu kawu, ne̱ ɔɔ kye̱na ɔse̱ŋgyipo̱ a kagya‑ɔ‑rɔ, mfe̱ŋ ne̱ Heebrii se̱ŋsa‑rɔ ba te̱e̱ ɛ Gabataa‑ɔ (kaase̱ e̱ kaapo̱ fe̱yɛ Abraŋdaye̱). ");
INSERT INTO ncuNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ifiyara amo̱, na kyɔwe̱ a yase̱ kafwe̱e̱. Ne̱ gominaa‑o a tɔwe̱ gywii lamaŋ‑ɔ fe̱yɛ, “Mo̱nꞌ ke̱e̱ mo̱ne̱ owure!” ");
INSERT INTO ncuNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ne̱ baa fɛɛ‑rɔ bo̱ kyo̱ŋwe̱ mò̱ fe̱yɛ, “Taa mò̱ nare̱ ya da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱!” Ne̱ gominaa‑o a bise bamo̱ fe̱yɛ, “Mo̱ne̱ e̱ kpa fe̱yɛ n da mo̱ne̱ owure bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱ ne̱e̱ e̱e̱e̱?” Ne̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ a lee kanɔ fe̱yɛ, “Owure ne̱ ane̱ de‑o e̱ gye̱ fo̱ owure dabe̱ ne̱ fo̱ de‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ne̱ ŋkee gominaa‑o a ba Yeesuu bo̱ sa mò̱ asoogyaa awuye fe̱yɛ bo̱ ya da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Amo̱se̱ se̱‑ɔ ne̱ baa taa Yeesuu nare̱, ne̱ ɔɔ ya so̱rɔ mò̱ kiyii kpare̱-abɛɛ‑rɔ baa mfe̱ŋ ne̱ Heebrii se̱ŋsa‑rɔ ba te̱e̱ ɛ Gologotaa‑o (kaase̱ e̱ kaapo̱ fe̱yɛ Ko̱lɔŋko̱rɔŋgyi swe̱e̱re̱). ");
INSERT INTO ncuNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ne̱ baa da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱. Ne̱ baa da anyare̱ anyɔ ko̱ mɔ bo̱ me̱ra ayii kpare̱-abɛɛ‑rɔ se̱, ɔko̱ŋko̱ bo̱ Yeesuu kigyise si, ne̱ ɔko̱ŋko̱ mɔ bo̱ mò̱ ke̱be̱na se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ne̱ Gominaa Pilat a kyo̱rɛɛ bo̱ dɔŋŋɔ ko̱wo̱re̱taa ko̱ se̱ fe̱yɛ, “Yeesuu Nasarɛte̱nyi, Yudaa awuye owure‑o,” ne̱ ɔɔ sa ne̱ baa taa ke̱mo̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ane̱ŋ a kawo̱re̱taa‑ɔ, baa kyo̱rɛɛ ke̱mo̱ se̱ Heebrii na Roma na Griiki e̱se̱ŋsa‑rɔ ne̱e̱. Ne̱ ase̱sɛ bwe̱e̱tɔ a kare̱, a le̱e̱ fe̱yɛ mfe̱ŋ ne̱ baa da Yeesuu bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱‑ɔ na maŋ‑nɔ mo̱ŋ bo̱ e̱fɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ne̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ a ya tɔwe̱ gywii gominaa‑o fe̱yɛ, “Fo̱ ma kyo̱rɛɛ fe̱yɛ, ‘Yudaa awuye owure‑o,’ amaa kyo̱rɛɛ fe̱yɛ, ‘Ɔnyare̱ mɔ yɛ, Mo̱ e̱ gye̱ Yudaa awuye owure‑o.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ne̱ gominaa a lee kanɔ fe̱yɛ, “Ke̱tɔ ne̱ mo̱ a kyo̱rɛɛ‑ɔ, ma lɛɛ kyurowi.” ");
INSERT INTO ncuNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Amɔ asoogyaa awuye‑o a da Yeesuu bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ‑ɔ se̱ lo̱we̱‑ɔ, ne̱ baa taa mò̱ atɔ buŋsɛ, ne̱ baa ke‑ro ntuŋkare̱ nna, katuŋ ke̱maa gye̱ soogyaa ko̱ŋko̱ ke̱maa lee ne̱e̱. Ne̱ baa be̱e̱ taa mò̱ kaare̱ ne̱ baa lo̱, ne̱ bo̱ mo̱ŋ baara‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ne̱ baa tɔwe̱ gywii abɛɛ fe̱yɛ, “Mo̱ne̱ ma sa a ane̱ kyaŋŋe̱ kaare̱‑ɔ‑rɔ, mo̱nꞌ sa a ane̱ waa mpini mpini na mò̱ ne̱ o gyi si‑o na ka kii mò̱ lee.” Ane̱ŋ a ase̱ŋ mɔ a ba ne̱e̱ na ke̱tɔ ne̱ baa kyɔ kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ nya waa kase̱ŋtiŋ fe̱yɛ, “Ne̱ baa waa mpini mpini bo̱ ke mo̱ atɔ buŋsɛ‑rɔ sa abɛɛ.” Ane̱ŋ ne̱ asoogyaa awuye‑o a waa‑ɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yeesuu mò̱ nyi na mò̱ nyikaasɛ na Mariya ne̱ ɔ gye̱ Kilopas mò̱ ka‑ɔ na Mariya Magadalanyi ye̱re̱ bo̱ me̱raa mfe̱ŋ ne̱ baa da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ‑ɔ se̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yeesuu a ŋu mò̱ nyi‑o na ɔgyase̱po̱ ne̱ Yeesuu e̱ kpa mò̱ ase̱ŋ bwe̱e̱tɔ‑ɔ ye̱re̱ mfe̱ŋ‑ɔ, ne̱ ɔɔ tɔwe̱ gywii mò̱ nyi‑o fe̱yɛ, “Ke̱e̱, fo̱ gyi‑o ne̱e̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ne̱ ɔɔ tɔwe̱ gywii mò̱ ɔgyase̱po̱‑ɔ fe̱yɛ, “Ke̱e̱, fo̱ nyi‑o ne̱e̱.” Le̱e̱ mfe̱ŋ‑ɔ ne̱ ɔgyase̱po̱‑ɔ a taa Yeesuu mò̱ nyi‑o yaa bo̱ kye̱na mò̱ aye̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yeesuu a ŋu fe̱yɛ mbe̱yɔmɔ fe̱raa ke̱tɔ ke̱maa a lo̱we̱‑ɔ, na ase̱ŋ ne̱ baa kyɔ kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ‑ɔ nya waa kase̱ŋtiŋ‑o, ne̱ ɔɔ tɔwe̱ fe̱yɛ, “Burufo de mo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kalɔ na nta ko̱ ye̱re̱ mfe̱ŋ, ne̱ baa taa ikyikyee bo̱ da‑rɔ lee bo̱ kye̱na kayii si, yase̱ yaa mò̱ kanɔ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yeesuu a kyo̱kywe̱e̱ nta‑ɔ, ne̱ ɔɔ tɔwe̱ fe̱yɛ, “Aa lo̱we̱.” Ne̱ ɔɔ gyaa kuŋu bo̱ twe̱e̱‑rɔ, ne̱ oo kii E̱bware̱ lee. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ne̱ Yudaa awuye abre̱sɛ‑ɔ a bo̱ ko̱re̱ Gominaa Pilat fe̱yɛ ɔ sa bamo̱ kpa a bo̱ ya gyɛɛ anyare̱ ne̱ baa da bamo̱ bo̱ me̱ra ayii kpare̱-abɛɛ‑rɔ se̱‑ɔ ayaa, na bo̱ maye̱ bamo̱ afuniŋ‑o le̱e̱ ayii kpare̱-abɛɛ‑rɔ‑ɔ se̱. Ke̱tɔ se̱ ne̱ baa ya ko̱re̱ kpa‑ɔ e̱ gye̱ fe̱yɛ kake nsi amo̱ gye̱ Ifiyara, ne̱ bo̱ maa kpa fe̱yɛ afuniŋ‑o kye̱na ayii kpare̱-abɛɛ‑rɔ‑ɔ se̱ Me̱me̱ne̱da, a le̱e̱ fe̱yɛ Me̱me̱ne̱da ne̱ ɔ ba‑ɔ gye̱ Me̱me̱ne̱da kukyure kake dabe̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ne̱ asoogyaa awuye a ya gyɛɛ ɔnyare̱ gye̱ŋkpɛɛsɛ na ɔnyɔse̱po̱ ne̱ baa da bamo̱ aa Yeesuu bo̱ me̱ra ayii kpare̱-abɛɛ‑rɔ‑ɔ se̱‑ɔ ayaa. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Amaa bamo̱ a ba Yeesuu ase̱‑ɔ, baa ŋu fe̱yɛ ɔɔ kyɔ wu, amo̱se̱‑ɔ bo̱ mo̱ŋ lɛɛ gyɛɛ mò̱ ayaa. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Amaa asoogyaa awuye‑o ɔko̱ a yii Yeesuu ke̱kpa keri‑ro. Puri amo̱‑rɔ, ne̱ mbo̱gya na nkyu a le̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Se̱sɛ ne̱ oo ŋu ase̱ŋ mɔ a waa‑ɔ e̱ tɔwe̱ amo̱ ase̱ŋ o gywii mo̱ne̱ ne̱ mo̱ne̱ e̱ kare̱ wo̱re̱ mɔ‑ɔ, na mo̱ne̱ gbaa na mo̱nꞌ de̱e̱ kɔɔre̱ gyi. Ke̱tɔ ne̱ ɔɔ tɔwe̱‑ɔ gye̱ kase̱ŋtiŋ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Amo̱‑ɔ a waa ne̱e̱ na ke̱tɔ ne̱ abware̱se̱ŋ wo̱re̱‑ɔ a tɔwe̱‑ɔ nya waa kase̱ŋtiŋ fe̱yɛ, “Mò̱ kibowii ko̱ŋko̱ gbaa maa gyaa‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Abware̱se̱ŋ wo̱re̱‑ɔ a be̱e̱ tɔwe̱ to̱ŋ ko̱ fe̱yɛ, “Ase̱sɛ e̱ de̱e̱re̱ mo̱ ne̱ baa yii ke̱kpa‑ɔ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Amo̱‑ɔ pɛɛɛ kamɛɛ‑ɔ, ne̱ ɔnyare̱ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Yo̱sɛf ne̱ ɔɔ le̱e̱ Arimate̱ya maŋ‑nɔ‑ɔ a ya ko̱re̱ Gominaa Pilat fe̱yɛ ɔ taa Yeesuu kifuniŋ sa mò̱. Ane̱ŋ a Yo̱sɛf mɔ gya Yeesuu si ɔ kwe̱e̱rɔ ne̱e̱, a le̱e̱ fe̱yɛ ɔ se̱re̱ Yudaa awuye abre̱sɛ‑ɔ. Ne̱ gominaa‑o a sa mò̱ kpa fe̱yɛ ɔ ya taa Yeesuu kifuniŋ‑o nare̱. Amo̱se̱ se̱‑ɔ ne̱ Yo̱sɛf a ya taa kifuniŋ‑o o yii. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodeemus, ne̱ ɔɔ dɛɛ ya ŋu Yeesuu kanye ko̱‑ɔ, na Yo̱sɛf ya yɔ ya pure kifuniŋ‑o. Bamo̱ a yɔ‑ɔ, ne̱ Nikodeemus a taa kakyanne̱ na ndwii ko̱ ne̱ baa bo̱ waa abɛɛ‑rɔ‑ɔ. Mmo̱ pɛɛɛ a bo̱rɔ kyaŋse̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Anyare̱ anyɔ‑ɔ a taa Yeesuu kifuniŋ‑o, ne̱ baa ba kyefuri bo̱ miri mò̱, ne̱ baa ba ndwii‑o na kakyanne̱‑ɔ bo̱ waa‑rɔ, ane̱ŋ ne̱ Yudaa awuye ananatɔ‑rɔ ba lɔŋŋɔ kifuniŋ pwɛɛ na bo̱ dɛɛ pure‑o. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Baa gyi bane̱ bo̱ kuŋ ayii ko̱ me̱raa mfe̱ŋ ne̱ baa mɔɔ Yeesuu‑o. Bane̱ amo̱‑rɔ ne̱ ɔko̱ a ŋeri ke̱fo̱re̱ lee bɔ fe̱yɛ ke̱kyaŋ‑ɔ bo̱ waa ke̱gye̱raŋta po̱pwɛɛ ne̱ bo̱ mo̱ŋ tɛɛ pure ɔko̱ ke̱mo̱‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Amo̱ a gye̱ fe̱yɛ kibugyii ya da, na bamo̱ kukyure kake dabe̱ fo̱‑ɔ, ne̱ ane̱ŋ a ke̱gye̱raŋta‑ɔ maa mfe̱ŋ‑ɔ se̱‑ɔ, ne̱ baa pure Yeesuu mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Kosiyara gye̱gyaye̱ kese‑ro‑o, kaye̱ a mo̱ŋ tɛɛ ke nɛɛnɛɛ‑ɔ, ne̱ Mariya Magadalanyi a yɔ ke̱gye̱raŋta‑ɔ se̱. Mò̱ a fo̱ mfe̱ŋ‑ɔ, ne̱ oo ŋu fe̱yɛ ke̱fo̱re̱ ne̱ baa kuroŋ bo̱ kpuse ke̱gye̱raŋta‑ɔ kanɔ‑ɔ se̱ fe̱yɛ po̱ne̱‑ɔ, baa kyɔ kuroŋ le̱e̱ ke̱gye̱raŋta‑ɔ kanɔ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ane̱ŋ se̱‑ɔ, ne̱ oo kiŋŋi ɔ se̱re̱ ɔ yɔ Simɔŋ Peetroo na ɔgyase̱po̱ ne̱ Yeesuu a kpa mò̱ ase̱ŋ bwe̱e̱tɔ‑ɔ ase̱, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Baa taa ane̱ nyaŋpe̱ le̱e̱ ke̱gye̱raŋta‑ɔ‑rɔ, ane̱ mɔ ane̱ mo̱ŋ nyi mfe̱ŋ ne̱ baa taa mò̱ yaa bo̱ be̱ya‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Amo̱se̱ ne̱ Peetroo na ɔgyase̱po̱ ko̱ amo̱‑ɔ a yɔ ke̱gye̱raŋta‑ɔ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Agyase̱po̱ anyɔ mɔ se̱re̱ ne̱e̱, amaa ɔko̱ŋko̱‑ɔ se̱re̱ keŋkeŋ ɔ kyo̱ŋ Peetroo. Ane̱ŋ se̱‑ɔ ɔɔ fo̱ ke̱gye̱raŋta‑ɔ ase̱ pwɛɛ ne̱ Peetroo a dɛɛ fo̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Mò̱ a fo̱‑ɔ, ne̱ oo buŋŋe de̱e̱re̱ ke̱gye̱raŋta‑ɔ‑rɔ ke̱e̱, ne̱ oo ŋu kyefuri ne̱ baa bo̱ miri Yeesuu kifuniŋ‑o da mfe̱ŋ, amaa ɔ mo̱ŋ lwee ke̱gye̱raŋta‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ne̱ Simɔŋ Peetroo mɔ a sii kamɛɛ ba, ne̱ oo lwee ke̱gye̱raŋta‑ɔ‑rɔ, ne̱ oo ŋu kyefuri‑o da mfe̱ŋ, ");
INSERT INTO ncuNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","na kaprakɛɛ ne̱ baa bo̱ ŋure Yeesuu kuŋu‑o. Kaprakɛɛ ne̱ baa bo̱ ŋure Yeesuu kuŋu‑o na kyefuri‑o mo̱ŋ da to̱ŋ ko̱ŋko̱ ne̱e̱. Kaprakɛɛ‑ɔ a bɔɔ ka da kamo̱ ko̱kwe̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ne̱ ɔgyase̱po̱ ne̱ ɔɔ gye̱ ŋkpɛɛ fo̱ ke̱gye̱raŋta‑ɔ ase̱‑ɔ mɔ a lweero, ne̱ oo ŋu ke̱tɔ ke̱maa. Amo̱se̱ ne̱ ɔɔ kɔɔre̱ ke̱tɔ ne̱ Mariya a tɔwe̱ gywii bamo̱‑ɔ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Amo̱‑ɔ pɛɛɛ gbaa bo̱ mo̱ŋ tɛɛ nu ane̱ŋ ne̱ abware̱se̱ŋ wo̱re̱‑ɔ a tɔwe̱‑ɔ fe̱yɛ o kyiŋŋi a ɔ le̱e̱ lowi‑ro‑o kaase̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ne̱ agyase̱po̱‑ɔ a kiŋŋi bo̱ yii pe̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mariya mɔ ye̱re̱ ke̱gye̱raŋta‑ɔ kawu si o su. Mò̱ a saŋ ɔ maa se̱ o su‑o, ne̱ oo buŋŋe de̱e̱re̱ ke̱gye̱raŋta‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ne̱ oo ŋu Wuribware̱ mbɔɔ ŋnyɔ ko̱ ne̱ bo̱ buŋ atɔ fufuri‑o te mfe̱ŋ ne̱ baa pure Yeesuu‑o, ɔko̱ŋko̱ bo̱ ayaa se̱, ne̱ ɔko̱ mɔ bo̱ aŋu si. Amaa saŋ amo̱, Yeesuu kifuniŋ‑o mo̱ŋ lɛɛ ɔ bo̱ ke̱gye̱raŋta‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ne̱ baa bise mò̱ fe̱yɛ, “Ɔpe̱kye̱e̱, nte̱tɔ ne̱e̱ ne̱ fo̱ i su?” Ne̱ oo lee kanɔ fe̱yɛ, “Baa taa mo̱ nyaŋpe̱ bo̱ de bo̱ yii, ne̱ mo̱ŋ nyi mfe̱ŋ ne̱ baa taa mò̱ yaa bo̱ be̱ya‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ne̱ oo buruwaa, ne̱ oo ŋu Yeesuu a ye̱re̱ mfe̱ŋ, amaa ɔ mo̱ŋ nyi fe̱yɛ Yeesuu ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ne̱ Yeesuu a bise mò̱ fe̱yɛ, “Ɔpe̱kye̱e̱, nte̱tɔ ne̱e̱ ne̱ fo̱ i su? Nsɛ ne̱ fo̱ i buwi fo̱ e̱ kpa?” Ɔkye̱e̱‑ɔ e̱ fa fe̱yɛ bane̱ amo̱ ɔde̱e̱re̱se̱po̱ ne̱e̱, ne̱ ɔɔ tɔwe̱ fe̱yɛ, “Bre̱sɛ, mfe̱ne̱ ne̱ fo̱ a taa mò̱ bo̱ be̱ya? Mo̱ e̱ ko̱re̱ fo̱ tɔwe̱ mfe̱ŋ ne̱ fo̱ a taa mò̱ yaa bo̱ be̱ya‑ɔ, na ŋ nya ya taa mò̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ne̱ Yeesuu a te̱e̱ mò̱ fe̱yɛ, “Mariya!” Ne̱ oo buruwaa mò̱ e̱ye̱e̱ bo̱ ko̱re̱ Yeesuu a ke̱be̱gya‑ɔ se̱, ne̱ ɔɔ ya kpuni aŋurii kra mò̱ ayaa‑rɔ, ne̱ ɔɔ tɔwe̱ Heebrii bamo̱ se̱ŋsa‑rɔ fe̱yɛ, “Rabuni!” Amo̱ kaase̱ e̱ gye̱ “Mo̱ ɔkaapo̱po̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Fo̱ ma kaŋ kra mo̱‑rɔ, a le̱e̱ fe̱yɛ mo̱ŋ tɛɛ yɔ so̱so̱ n se̱ ase̱. Amo̱se̱ se̱‑ɔ, nare̱ mo̱ ko̱so̱bɛɛ‑ana ase̱ ya tɔwe̱ gywii bamo̱ fe̱yɛ mo̱ i kiŋŋi mo̱ e̱ yɔ mò̱ ne̱ ɔ gye̱ n se̱ na mo̱ nyaŋpe̱ Wuribware̱‑ɔ ase̱. Na fo̱ tɔwe̱ gywii bamo̱ fe̱yɛ ŋkee fe̱raa ɔ gye̱ bamo̱ se̱ na bamo̱ nyaŋpe̱ Wuribware̱ bo̱ tii si.” ");
INSERT INTO ncuNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Puri amo̱‑rɔ, ne̱ Mariya Magadalanyi a yɔ ya tɔwe̱ gywii agyase̱po̱‑ɔ fe̱yɛ, “Mo̱ a ŋu ane̱ nyaŋpe̱,” ne̱ ɔɔ tɔwe̱ ane̱ŋ ne̱ Yeesuu a tɔwe̱ gywii mò̱‑ɔ gywii bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kake nsi amo̱ gye̱ Kosiyara. Amo̱ ke̱de̱e̱pwɛta‑ɔ, ne̱ Yeesuu agyase̱po̱‑ɔ a gyaŋŋe̱ twe̱e̱ ke̱kyaŋ‑nɔ bo̱ bo̱‑rɔ, a le̱e̱ fe̱yɛ kufu de bamo̱ bo̱ le̱e̱ Yudaa awuye abre̱sɛ‑ɔ se̱. Ne̱ Yeesuu a bo̱ ye̱re̱ bamo̱ nse̱na‑rɔ. Ne̱ ɔɔ ka bamo̱ kanɔ fe̱yɛ, “E̱ye̱e̱ yure mo̱ne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Mò̱ a tɔwe̱ amo̱‑ɔ kyo̱ŋ‑ɔ, ne̱ ɔɔ ba mò̱ asare̱e̱ na mò̱ keri‑ro bo̱ kaapo̱ bamo̱. Ne̱ agyase̱po̱‑ɔ akatɔ a gyi bwe̱e̱tɔ fe̱yɛ bamo̱ a ŋu Yeesuu. ");
INSERT INTO ncuNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ne̱ Yeesuu a be̱e̱ tɔwe̱ gywii bamo̱ fe̱yɛ, “E̱ye̱e̱ yure mo̱ne̱. To, fe̱yɛ ane̱ŋ ne̱ n se̱ a suŋ mo̱ bo̱ kyo̱ŋwe̱‑ɔ, ane̱ŋ dɛɛ ne̱ mo̱ i suŋ mo̱ne̱ mo̱ e̱ kyo̱ŋwe̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ne̱ oo fwii ŋe waa bamo̱‑rɔ tɔwe̱ fe̱yɛ, “Mo̱nꞌ kɔɔre̱ Wuribware̱ a kufwiiŋe timaa‑o. ");
INSERT INTO ncuNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mo̱ne̱ ya taa bo̱ko̱ e̱bɔye̱ bo̱ ke bamo̱, amo̱ fe̱raa Wuribware̱ gbaa e̱ ba bamo̱ e̱bɔye̱ a ɔ bo̱ ke bamo̱. Ne̱ mo̱ne̱ e̱ mo̱ŋ ba bo̱ ke bamo̱, amo̱ fe̱raa Wuribware̱ gbaa maa ba a ɔ bo̱ ke bamo̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Agyase̱po̱ kudu anyɔ‑ɔ ɔko̱ ne̱ ba te̱e̱ mò̱ ɛ Tomas ne̱ ɔ gye̱ ke̱le̱ŋba‑ɔ mo̱ŋ bo̱ bamo̱ ase̱ nsaŋ ne̱ Yeesuu a ba‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Amo̱se̱ se̱‑ɔ ne̱ agyase̱po̱ ko̱‑ɔ a tɔwe̱ gywii mò̱ fe̱yɛ, “Ane̱ a ŋu ane̱ nyaŋpe̱.” Amaa Tomas a tɔwe̱ gywii bamo̱ fe̱yɛ, “Amɔ mo̱ a ŋu mfe̱ŋ ne̱ baa da mò̱ ndangyii asare̱e̱‑rɔ na n taa mo̱ asare̱e̱gyi bo̱ dabo̱rɔ mfe̱ŋ, na n neŋ mo̱ ke̱sare̱e̱ bo̱ waa mò̱ keri‑ro pwɛɛ na n dɛɛ kɔɔre̱ gyi.” ");
INSERT INTO ncuNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kadaawɔkywe̱e̱ be̱e̱ bo̱ fo̱‑ɔ, ne̱ agyase̱po̱‑ɔ a be̱e̱ bo̱ gyaŋŋe̱ ke̱kyaŋ‑nɔ twe̱e̱ po̱ne̱‑rɔ. Ŋkee fe̱raa Tomas bo̱ bamo̱ ase̱. Ne̱ Yeesuu a be̱e̱ bo̱ ye̱re̱ bamo̱ nse̱na‑rɔ ka bamo̱ kanɔ fe̱yɛ, “E̱ye̱e̱ yure mo̱ne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ne̱ ɔɔ tɔwe̱ gywii Tomas fe̱yɛ, “Taa fo̱ ke̱sare̱e̱gyi bo̱ dɔŋŋɔ se̱ mfe̱e̱, na fo̱ de̱e̱re̱ mo̱ asare̱e̱‑rɔ. Na fo̱ neŋ fo̱ ke̱sare̱e̱ bo̱ waa mo̱ keri‑ro, na fo̱ yɔwe̱ fo̱ ko̱kɔɔre̱gyi ke̱‑mo̱ŋ‑de‑o, na fo̱ kɔɔre̱ gyi fe̱yɛ mo̱ a kyiŋŋi le̱e̱ lowi‑ro.” ");
INSERT INTO ncuNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ne̱ Tomas a lee kanɔ fe̱yɛ, “Mo̱ nyaŋpe̱ na Wuribware̱ e̱ gye̱ fo̱!” ");
INSERT INTO ncuNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Ane̱ŋ ne̱ fo̱ a ŋu mo̱‑ɔ se̱ ne̱ fo̱ e̱ kɔɔre̱ fo̱ i gyi aaa? Bamo̱ ne̱ bo̱ mo̱ŋ ke̱e̱ mo̱, ne̱ baa kɔɔre̱ gyi fe̱yɛ mo̱ a kyiŋŋi le̱e̱ lowi‑ro‑o de ŋyure.” ");
INSERT INTO ncuNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yeesuu a waa akpe̱ŋe̱ye̱e̱tɔ bwe̱e̱tɔ ko̱ mò̱ agyase̱po̱‑ɔ akatɔ‑rɔ ne̱ mo̱ŋ kyo̱rɛɛ waa wo̱re̱ mɔ‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Amaa mo̱ a kyo̱rɛɛ amo̱‑ɔ ne̱e̱ a mo̱nꞌ de̱e̱ kɔɔre̱ gyi fe̱yɛ Yeesuu e̱ gye̱ Kristoo‑o, Wuribware̱ mò̱ gyi‑o, na bo̱ le̱e̱ mo̱ne̱ ko̱kɔɔre̱ mò̱ gyi si na mò̱ ke̱nyare̱ na ke̱yaale̱ŋ se̱, mo̱nꞌ de̱e̱ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Amo̱‑ɔ kamɛɛ‑rɔ, ne̱ Yeesuu a be̱e̱ lee mò̱ e̱ye̱e̱ bo̱ kaapo̱ mò̱ agyase̱po̱‑ɔ bo̱ko̱ Tibeeriyas ke̱pare̱ dabe̱‑ɔ kɛɛ. Mfaanɛɛ ne̱ aa waa. Ne̱ agyase̱po̱ ko̱ a gyaŋŋe̱ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Bamo̱ ne̱ baa gyaŋŋe̱ mfe̱ŋ‑ɔ e̱ gye̱ Simɔŋ Peetroo, na Tomas ne̱ ɔ gye̱ ke̱le̱ŋba‑ɔ, na Nataniyɛl ne̱ ɔɔ le̱e̱ Kana maŋ ne̱ ɔ bo̱ Galile̱ya swe̱e̱re̱ se̱‑ɔ‑rɔ‑ɔ, na Sibidii mò̱ gyi‑ana anyɔ‑ɔ, na Yeesuu agyase̱po̱‑ɔ‑rɔ anyɔ ko̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ne̱ Simɔŋ Peetroo a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ e̱ ya kra ŋkiŋgyi ne̱e̱.” Ne̱ bo̱ yɛ, “Ane̱ aa fo̱ e̱ yɔ.” Ne̱ bamo̱ pɛɛɛ a kye̱na ko̱re̱e̱‑rɔ yɔ. Ne̱ kibugyii a da, ne̱ baa twe̱e̱ kisawu ane̱ŋ‑aaa. Ne̱ kaye̱ a bo̱ ke na bo̱ mo̱ŋ kra sɛye̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Saŋ ne̱ kyɔwe̱ e̱ le̱e̱‑ɔ, ne̱ Yeesuu ye̱re̱ kyukɛɛ, amaa agyase̱po̱‑ɔ mo̱ŋ nyi fe̱yɛ mò̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ne̱ oo bise bamo̱ fe̱yɛ, “Ayaafɔre̱, mo̱ne̱ a kra ko̱tɔko̱ aaa?” Ne̱ baa lee kanɔ fe̱yɛ, “Ane̱ mo̱ŋ kra kataapo̱gyii ko̱ŋko̱ gbaa.” ");
INSERT INTO ncuNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ne̱ ya twe̱e̱ mo̱ne̱ kisawu‑o yaa ko̱re̱e̱‑ɔ kigyise si a keri‑o, mo̱ne̱ e̱ kra ŋkiŋgyi.” Amo̱se̱‑ɔ ne̱ baa twe̱e̱ kisawu‑o bo̱ waa‑rɔ, ne̱ bo̱ mo̱ŋ lɛɛ taare̱ gyiiri lee, a le̱e̱ fe̱yɛ baa kra ŋkiŋgyi bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ne̱ ɔgyase̱po̱ ne̱ Yeesuu e̱ kpa mò̱ ase̱ŋ bwe̱e̱tɔ‑ɔ a tɔwe̱ gywii Peetroo fe̱yɛ, “Ane̱ nyaŋpe̱ ne̱e̱!” Peetroo a nu fe̱yɛ bamo̱ nyaŋpe̱ ne̱e̱‑ɔ, ne̱ oo kpuriti waagya laare̱‑rɔ, a le̱e̱ fe̱yɛ ɔɔ kyɔ lee mò̱ atɔ buŋsɛ le̱e̱ mò̱ kayo̱wɔre̱ se̱ ne̱e̱, ne̱ oo fuwi lwee nkyu‑o‑ro le̱e̱ ɔ twɛɛ ɔ yɔ kideŋbe si. ");
INSERT INTO ncuNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ne̱ agyase̱po̱ ne̱ baa saŋ‑ɔ a kye̱na ko̱re̱e̱‑ɔ‑rɔ ba pare̱ ba daŋ kideŋbe si, na ba gyiiri kisawu ne̱ ŋkiŋgyi a bo̱rɔ‑rɔ‑ɔ, a le̱e̱ fe̱yɛ bamo̱ aa kideŋbe si mo̱ŋ lɛɛ a bo̱ e̱fɔ, a saŋ ayaa waa alafa asa na bo̱ daŋ kideŋbe si. ");
INSERT INTO ncuNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Bamo̱ a fo̱ kideŋbe si‑o, ne̱ baa ŋu aduŋdurii de̱e̱kpa na ŋkiŋgyi tɔ‑rɔ, na bodobodoo. ");
INSERT INTO ncuNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱nꞌ taa ŋkiŋgyi ne̱ mo̱ne̱ a de̱ŋ kra‑ɔ ŋko̱ baa.” ");
INSERT INTO ncuNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ne̱ Simɔŋ Peetroo a lwee ko̱re̱e̱‑ɔ‑rɔ, ne̱ oo gyiiri kisawu‑o yaa kideŋbe si, na ŋkiŋgyi adabe̱ adabe̱ a bo̱rɔ‑rɔ. Mmo̱ pɛɛɛ gye̱ ke̱lafa na adunuu na nsa. Hare̱e̱ ŋkiŋgyi mɔ a kyɔ kanɔ ŋke̱maa‑ɔ gbaa ooo, kisawu‑o mo̱ŋ kyaŋŋe̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ne̱ Yeesuu a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱nꞌ bo̱ gyi.” Amo̱‑ɔ pɛɛɛ gbaa agyase̱po̱‑ɔ ɔko̱ mo̱ŋ bise mò̱ fe̱yɛ, “Fo̱ nsɛ ne̱e̱?”, a le̱e̱ fe̱yɛ bo̱ nyi fe̱yɛ bamo̱ nyaŋpe̱ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ne̱ Yeesuu a taa bodobodoo‑o, ne̱ ɔɔ bo̱ sa bamo̱, ane̱ŋ dɛɛ ne̱ ɔɔ waa ŋkiŋgyi‑o gbaa. ");
INSERT INTO ncuNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Mò̱ a kyiŋŋi le̱e̱ lowi‑ro‑o kamɛɛ‑rɔ, ke̱mo̱‑ɔ e̱ gye̱ sase̱po̱ fe̱yɛ Yeesuu a lee mò̱ e̱ye̱e̱ bo̱ kaapo̱ mò̱ agyase̱po̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Bamo̱ a gyi lo̱we̱‑ɔ, ne̱ Yeesuu a tɔwe̱ gywii Simɔŋ Peetroo fe̱yɛ, “Yohanee mò̱ gyi Simɔŋ, fo̱ e̱ kpa mo̱ ase̱ŋ fo̱ kyɔ ane̱ŋ ne̱ fo̱ bɛɛko̱‑ana mɔ e̱ kpa mo̱ ase̱ŋ‑ɔ ɔɔɔ?” Ne̱ oo lee kanɔ fe̱yɛ, “Mo̱ nyaŋpe̱, fo̱ nyi fe̱yɛ mo̱ e̱ kpa fo̱ ase̱ŋ ɛ.” Ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “De̱e̱re̱ mo̱ nsanne̱gyii‑o si.” ");
INSERT INTO ncuNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ne̱ Yeesuu a tɔwe̱ nyɔse̱po̱ fe̱yɛ, “Yohanee mò̱ gyi Simɔŋ, fo̱ e̱ kpa mo̱ ase̱ŋ aaa?” Ne̱ Peetroo a be̱e̱ lee kanɔ fe̱yɛ, “Mo̱ nyaŋpe̱, fo̱ nyi fe̱yɛ mo̱ e̱ kpa fo̱ ase̱ŋ ɛ.” Ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “De̱e̱re̱ mo̱ e̱sanne̱‑ɔ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ne̱ Yeesuu a tɔwe̱ sase̱po̱ fe̱yɛ, “Yohanee mò̱ gyi Simɔŋ, kase̱ŋtiŋ ne̱ fo̱ e̱ kpa mo̱ ase̱ŋ aaa?” A mo̱ŋ waa Peetroo kɔne̱ fe̱yɛ Yeesuu a be̱e̱ bise mò̱ sase̱po̱. Ane̱ŋ se̱ ne̱ ɔɔ tɔwe̱ gywii Yeesuu fe̱yɛ, “Mo̱ nyaŋpe̱, fo̱ kyɔ fo̱ nyi ke̱tɔ ke̱maa. Fo̱ nyi fe̱yɛ mo̱ e̱ kpa fo̱ ase̱ŋ.” Ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “De̱e̱re̱ mo̱ e̱sanne̱‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mo̱ i gyi fo̱ kase̱ŋtiŋ fe̱yɛ, saŋ ne̱ fo̱ gye̱ kayaafɔre̱gyii‑o fo̱ a nyaa fo̱ ŋkpaŋkaare̱e̱ ba fe bo̱ te̱ŋ se̱ yɔ to̱ŋ ke̱maa ne̱ fo̱ e̱ kpa‑ɔ. Amaa fo̱ ya kii ke̱nyaŋbre̱sɛ, fo̱ i teyi asare̱e̱‑rɔ, na ɔko̱ e̱ gye̱ ne̱ ɔ ba fe a ɔ bo̱ ŋure fo̱, na ɔ yaa fo̱ mfe̱ŋ ne̱ fo̱ maa kpa‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ane̱ŋ a ase̱ŋ mɔ ne̱ ɔɔ tɔwe̱‑ɔ, Yeesuu e̱ kpa a ɔ kaapo̱ ane̱ŋ ne̱ Peetroo e̱ ba a ɔ bo̱ wu, na a sa a Wuribware̱ nya ke̱dabe̱‑ɔ ne̱e̱. Ne̱ Yeesuu a tɔwe̱ gywii mò̱ fe̱yɛ, “Gya mo̱ se̱.” ");
INSERT INTO ncuNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peetroo a kii de̱e̱re̱ kamɛɛ, ne̱ oo ŋu ɔgyase̱po̱ ne̱ Yeesuu e̱ kpa mò̱ ase̱ŋ bwe̱e̱tɔ‑ɔ, mò̱ ne̱ ɔɔ kye̱na me̱raa Yeesuu kake nsi ne̱ baa kye̱na ba gyi, ne̱ oo bise fe̱yɛ, “Mo̱ nyaŋpe̱, nsɛ e̱ gye̱ ne̱ o gyi fo̱ kidiburo?”‑o. ");
INSERT INTO ncuNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Mò̱ a ŋu fe̱yɛ ɔgyase̱po̱ amo̱ e̱ gya bamo̱ se̱‑ɔ, ne̱ oo kuri bise Yeesuu fe̱yɛ, “Mo̱ nyaŋpe̱, ne̱ ɔnyare̱ mɔ mɔ, nte̱tɔ e̱ gye̱ ne̱ a waa mò̱?” ");
INSERT INTO ncuNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ne̱ Yeesuu a be̱ŋŋaa mò̱ fe̱yɛ, “Mo̱ e̱ kpa fe̱yɛ ɔ kye̱na bo̱ fo̱ saŋ ne̱ mo̱ i kiŋŋi a m ba‑ɔ gbaa, a mo̱ŋ gye̱ fo̱ ase̱ŋ. Fo̱ fe̱raa, gya mo̱ se̱ de.” ");
INSERT INTO ncuNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Amo̱se̱ se̱‑ɔ, ne̱ ase̱ŋ amo̱ a saŋŋe̱‑rɔ yɔ Kristoo awuye ase̱ fe̱yɛ ɔgyase̱po̱ amo̱ maa wu. Amaa Yeesuu mo̱ŋ tɔwe̱ fe̱yɛ ɔgyase̱po̱‑ɔ maa wu. Ɔɔ tɔwe̱ ne̱e̱ fe̱yɛ, “Mo̱ e̱ kpa fe̱yɛ ɔ kye̱na bo̱ fo̱ saŋ ne̱ mo̱ i kiŋŋi a m ba‑ɔ gbaa, a mo̱ŋ gye̱ fo̱ ase̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ɔgyase̱po̱ amo̱ ne̱ Yeesuu a tɔwe̱ mò̱ ase̱ŋ‑ɔ dɛɛ e̱ gye̱ ne̱ oo ŋu amo̱‑ɔ pɛɛɛ ne̱ ɔɔ kyo̱rɛɛ bo̱ be̱ya‑ɔ. Ne̱ ane̱ nyi fe̱yɛ ke̱tɔ ne̱ ɔɔ tɔwe̱‑ɔ gye̱ kase̱ŋtiŋ. ");
INSERT INTO ncuNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Mbe̱yɔmɔ, ase̱ŋ bwe̱e̱tɔ bo̱‑rɔ ne̱ Yeesuu a waa bo̱ tii si. Baa dɛɛ kyo̱rɛɛ amo̱ pɛɛɛ bo̱ be̱ya ako̱ ako̱ ne̱e̱‑ɔ, weetee mo̱ e̱ fa fe̱yɛ amo̱ e̱wo̱re̱ ne̱ ba kyo̱rɛɛ‑ɔ maa lɔɔ kaye̱ mɔ‑rɔ gbaa.");
INSERT INTO ncuNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Bre̱sɛ Tiyufilus, mo̱ a kyɔ kyo̱rɛɛ waa mo̱ wo̱re̱ gye̱ŋkpɛɛsɛ ne̱ mo̱ a kyo̱rɛɛ fo̱‑ɔ‑rɔ ke̱tɔ ne̱ Yeesuu a waa, na ase̱ŋ ne̱ ɔɔ kaapo̱‑ɔ, le̱e̱ hare̱e̱ saŋ ne̱ ɔɔ le̱e̱ mò̱ asuŋ kaase̱ bo̱ fo̱ ŋke nsi ne̱ Wuribware̱ a taa mò̱ yaa so̱so̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","Saŋ ne̱ Yeesuu a wu‑o bo̱ fo̱ saŋ ne̱ Wuribware̱ a taa mò̱ yaa so̱so̱‑ɔ gye̱ ŋke aduna. Saŋ amo̱, ɔɔ ba Wuribware̱ a kufwiiŋe timaa‑o e̱le̱ŋ ne̱e̱ bo̱ kaapo̱ mò̱ ase̱sɛ kudu anyɔ ne̱ oo lee, ne̱ ɔɔ te̱e̱ bamo̱ ɛ mò̱ ayaa‑rɔ aye̱re̱po̱‑ɔ ke̱tɔ ne̱ ɔɔ kpa fe̱yɛ bo̱ waa‑ɔ. Ne̱ oo lee mò̱ e̱ye̱e̱ bo̱ kaapo̱ bamo̱, ne̱ ɔɔ be̱e̱ ŋaa, ne̱ ɔɔ be̱e̱ lee mò̱ e̱ye̱e̱ bo̱ kaapo̱ bamo̱ iluwi bwe̱e̱tɔ na e̱kpa bwe̱e̱tɔ se̱, na bo̱ ŋu fe̱yɛ kase̱ŋtiŋ ne̱e̱ mò̱ a wu‑o, oo kyiŋŋi le̱e̱ lowi‑ro. Ne̱ baa ŋu mò̱, ne̱ bamo̱ aa mò̱ a tɔwe̱ Wuribware̱ a kuwure‑o‑ro ase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Saŋ amo̱‑rɔ ne̱ mò̱ aa bamo̱ a be̱e̱ ba gyi ateese saŋ ko̱‑ɔ, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ne̱ ma kaŋ le̱e̱ Yɛro̱salɛm mfe̱ŋ ne̱ mo̱ne̱ bo̱‑ɔ. Amaa mo̱nꞌ gywii Wuribware̱ a kufwiiŋe timaa ne̱ n se̱ Wuribware̱ a tɔwe̱ bo̱ be̱ya fe̱yɛ ɔ sa mo̱ne̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Nkyu ne̱ Yohanee Osuubɔpo̱‑ɔ a bo̱ bɔ ase̱sɛ asuu. Amaa ŋke mfe̱ne̱ mɔ‑rɔ Wuribware̱ e̱ sa a mò̱ kufwiiŋe timaa‑o ywe̱e̱ mo̱ne̱ se̱, na ɔ ba kufwiiŋe timaa amo̱ bo̱ gyee mo̱ne̱.” ");
INSERT INTO ncuNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Saŋ ko̱, bamo̱ aa Yeesuu a be̱e̱ gyaŋŋe̱‑ɔ, ne̱ baa bise mò̱ fe̱yɛ, “Ane̱ nyaŋpe̱, amɔ saŋ mo̱ŋ tɛɛ fo̱ fe̱yɛ fo̱ kɔɔre̱ kuwure le̱e̱ Roma awuye ase̱ kiŋŋaa sa ane̱ Isireelii awuye aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ne̱ Yeesuu a be̱ŋŋaa bamo̱ fe̱yɛ, “Ke̱tɔ ke̱maa e̱le̱ŋ bo̱ n se̱ ke̱sare̱e̱‑rɔ ne̱e̱. Amo̱se̱‑ɔ, a mo̱ŋ gye̱ mo̱ne̱ ase̱ŋ fe̱yɛ mo̱nꞌ pini nyaŋe̱ ko̱ a ke̱tɔ ne̱ ke̱ e̱ waa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Amaa ke̱tɔ ne̱ mo̱nꞌ pini‑o e̱ gye̱ fe̱yɛ Wuribware̱ a kufwiiŋe timaa‑o ya lwee mo̱ne̱‑rɔ, ɔ sa mo̱ne̱ ke̱yaale̱ŋ na wɔre̱, na mo̱nꞌ nare̱ tɔwe̱ atɔ pɛɛɛ ne̱ mo̱ne̱ a ŋu fe̱yɛ mo̱ a waa, na ase̱ŋ ne̱ mo̱ne̱ a nu fe̱yɛ mo̱ a tɔwe̱ saŋ ne̱ m bo̱ mo̱ne̱ ase̱‑ɔ, Yɛro̱salɛm maŋ‑nɔ mfe̱e̱ na ane̱ Yude̱ya swe̱e̱re̱ se̱ na Samariya swe̱e̱re̱ se̱ na ŋkee kaye̱‑rɔ pɛɛɛ mɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yeesuu a de̱ŋ tɔwe̱ ane̱ŋ lo̱we̱‑ɔ, ne̱ ɔɔ le̱e̱ o yii Wuribware̱ se̱, na mò̱ ayaa‑rɔ aye̱re̱po̱‑ɔ ye̱re̱ ba de̱e̱re̱, ne̱ ko̱wo̱re̱ ko̱ a bo̱ mwiire mò̱ se̱, ne̱ bo̱ mo̱ŋ lɛɛ bo̱ ke̱e̱ mò̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bamo̱ a saŋ bo̱ ye̱re̱ ba de̱e̱re̱ so̱so̱‑ɔ, na Yeesuu mɔ e̱ yɔ, ne̱ puri amo̱‑rɔ anyare̱ anyɔ ko̱ mɔ ne̱ bo̱ buŋ atɔ fufuri‑o a le̱e̱ bamo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ne̱ baa tɔwe̱ gywii ayaa‑rɔ aye̱re̱po̱‑ɔ fe̱yɛ, “Galile̱ya swe̱e̱re̱ se̱ awuye, nte̱tɔ ne̱e̱ ne̱ mo̱ne̱ ye̱re̱ mo̱ne̱ e̱ de̱e̱re̱ awo̱re̱‑rɔ? Yeesuu mɔ ne̱ ɔɔ le̱e̱ mo̱ne̱ ase̱ o yii Wuribware̱ ase̱‑ɔ e̱ be̱e̱ kiŋŋi a ɔ ba fe̱yɛ ane̱ŋ mɔ ne̱ mo̱ne̱ a ŋu mò̱ na ɔ yɔ Wuribware̱ se̱‑ɔ mɔ dɛɛ.” ");
INSERT INTO ncuNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ne̱ ayaa‑rɔ aye̱re̱po̱‑ɔ a nare̱ maye̱re̱ ke̱be̱gya le̱e̱ Mfɔ-Ayii ke̱be̱e̱‑ɔ se̱ kiŋŋi yɔ Yɛro̱salɛm maŋ‑nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Bamo̱ pɛɛɛ, Peetroo, na Yohanee, na Yakubu, na Andruu, na Filipo, na Tomas, na Bar‑Tolomiyu, na Matiyo, na Alafiyus mò̱ gyi Yakubu, na Simɔŋ Sɛlɔt, na Yakubu mò̱ gyi Yudas, a fo̱ maŋ‑ɔ‑rɔ, ne̱ baa ya lwee bamo̱ abaŋso̱ro̱o̱‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ke̱kyaŋ mɔ‑rɔ mfe̱ŋ ne̱ bamo̱ aa akye̱e̱ ne̱ bo̱ dɛɛ bo̱ gya Yeesuu si‑o na Yeesuu mò̱ nyi Mariya na mò̱ tire‑ana e̱ gyaŋŋe̱ saŋ ke̱maa ba ko̱re̱ ke̱bware̱ko̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Bo̱ fo̱ ŋke ŋnyɔ ko̱‑ɔ, ne̱ bamo̱ ne̱ baa kɔɔre̱ Yeesuu gyi‑o a bo̱ gyaŋŋe̱. Ba waa ase̱sɛ ke̱lafa na adunyɔ. Ne̱ Peetroo a ko̱so̱ ye̱re̱, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Mo̱ ko̱so̱bɛɛ‑ana, mo̱ne̱ a nyiŋŋi si fe̱yɛ Yudas Kariyotinyi‑o ya kaapo̱ ane̱ŋ ne̱ baa kra Yeesuu‑o. Ke̱tɔ ne̱ ɔɔ waa‑ɔ, Wuribware̱ a kufwiiŋe timaa‑o a kyɔ kaapo̱ ane̱ ɔde̱daapo̱ Deefid ane̱ŋ ne̱ ke̱ e̱ ba a ke̱ bo̱ waa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yudas dɛɛ o tii ane̱ se̱ ne̱e̱, ne̱ ane̱ nyaŋpe̱ a lee mò̱ fe̱yɛ ane̱ aa mò̱ kii mò̱ ayaa‑rɔ aye̱re̱po̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Fo̱ ne̱ fo̱ e̱ kare̱ wo̱re̱ mɔ‑ɔ, nyiŋŋi si fe̱yɛ Yudas a ba atanne̱ ne̱ oo gyi Yeesuu kidiburo‑o nya‑ɔ bo̱ sɔɔ swe̱e̱re̱ sa mò̱ e̱ye̱e̱. Swe̱e̱re̱ amo̱ se̱ dɛɛ ne̱ ɔɔ le̱e̱ da, ne̱ mò̱ amerotɔ pɛɛɛ a le̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ne̱ Yɛro̱salɛm awuye a nu ase̱ŋ amo̱‑ɔ, ne̱ baa sa swe̱e̱re̱ amo̱ mfe̱ŋ ke̱nyare̱ bamo̱ aye̱‑rɔ fe̱yɛ Akɛlɛdama, kaase̱ e̱ kaapo̱ fe̱yɛ Mbo̱gya swe̱e̱re̱.) ");
INSERT INTO ncuNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","To, ne̱ Peetroo a kya se̱ tɔwe̱ fe̱yɛ, “A bo̱ Deefid iliŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ, ‘Mo̱nꞌ sa a mò̱ aye̱ kii ke̱taakpaŋ, na se̱sɛ ma kye̱na mfe̱ŋ.’ Ne̱ a be̱e̱ a bo̱‑rɔ fe̱yɛ, ‘Mo̱nꞌ sa a ɔko̱ ye̱re̱ mò̱ ayaa‑rɔ, na se̱sɛ‑ɔ tii ane̱ se̱ waa ane̱ nyaŋpe̱ kusuŋ.’ ");
INSERT INTO ncuNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Amo̱se̱‑ɔ, mo̱nꞌ sa a ane̱ lee ɔko̱ na ɔ bo̱ tii ane̱ se̱, na mò̱ gbaa tɔwe̱ ane̱ŋ ne̱ Yeesuu a kyiŋŋi le̱e̱ lowi‑ro‑o ase̱ŋ. Se̱sɛ amo̱ waa ɔko̱ ne̱ ɔɔ gya ane̱ aa ane̱ nyaŋpe̱ Yeesuu si saŋ ne̱ ɔ naa ɔ tɔwe̱ abware̱se̱ŋ kaye̱‑rɔ, le̱e̱ hare̱e̱ saŋ ne̱ Yohanee Osuubɔpo̱‑ɔ a bɔ ase̱sɛ asuu‑o bo̱ fo̱ kake ne̱ Yeesuu yii Wuribware̱ se̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Peetroo a sa se̱ŋsa lo̱we̱‑ɔ, ne̱ baa lee abɛɛ anyɔ. Bamo̱ e̱ gye̱ Yo̱sɛf ne̱ ba te̱e̱ mò̱ ɛ Bar‑Sabas (ne̱ bo̱ be̱e̱ ba te̱e̱ mò̱ ɛ Yusutus‑o), na ɔko̱ ne̱ ba te̱e̱ mò̱ ɛ Matiyas‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Ne̱ baa ko̱re̱ ke̱bware̱ko̱re̱ fe̱yɛ, “Ane̱ nyaŋpe̱, fo̱ e̱ gye̱ ne̱ fo̱ nyi se̱sɛ ke̱maa mfɛɛre̱‑rɔ na kakpo̱nɔ‑rɔ. Amo̱se̱‑ɔ fo̱ e̱ gye̱ ne̱ fo̱ e̱ kaapo̱ ane̱ abɛɛ anyɔ mɔ‑rɔ mò̱ ne̱ fo̱ a lee fe̱yɛ o kii fo̱ ayaa‑rɔ aye̱re̱po̱‑ɔ ɔko̱ na o teere Yudas ayaa‑rɔ ne̱ mbe̱yɔmɔ mò̱ bo̱ro̱kɔɔne̱ na e̱bɔye̱ a yaa mò̱ mfe̱ŋ ne̱ ɔ nya mò̱ kakɔka‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ne̱ baa lee ŋyii na bo̱ lee abɛɛ anyɔ amo̱ ɔko̱. Mò̱ ne̱ baa lee‑o e̱ gye̱ Matiyas. Ne̱ oo tii ayaa‑rɔ aye̱re̱po̱ kudu kako̱‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Saŋ ko̱, ne̱ kasu kanɔ kake ne̱ ba te̱e̱ ɛ Pentikos‑o† a fo̱‑ɔ, ne̱ bamo̱ ne̱ baa kɔɔre̱ Yeesuu gyi‑o a gyaŋŋe̱ to̱ŋ ko̱ŋko̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mfe̱ŋ ne̱ baa nu e̱lawo̱ ko̱ a le̱e̱ so̱so̱ na i su fe̱yɛ afwii dabe̱‑ɔ, ne̱ e̱ ya bo̱rɔ lɔŋ ne̱ baa gyaŋŋe̱ bo̱ te mò̱‑rɔ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ne̱ baa ŋu atɔ ko̱ fe̱yɛ de̱e̱kpa‑ɔ a le̱e̱ so̱so̱, ne̱ oo ke‑ro waa agyabreŋ bwe̱e̱tɔ bo̱ ywe̱e̱ ɔke̱maa ne̱ o te ke̱kyaŋ amo̱‑rɔ‑ɔ kuŋu si. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ne̱ Wuribware̱ a kufwiiŋe timaa‑o a ywe̱e̱ ɔke̱maa se̱. Ne̱ ɔɔ sa ne̱ baa le̱e̱ ba sa e̱se̱ŋsa baŋbaŋ ne̱ e̱ mo̱ŋ gye̱ bamo̱ aye̱‑rɔ se̱ŋsa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Saŋ‑ɔ mɔ, Yudaa awuye bwe̱e̱tɔ ko̱ mɔ ne̱ baa tu yɔ bo̱ te kaye̱‑rɔ swe̱e̱re̱ pɛɛɛ se̱‑ɔ a be̱e̱ ba bo̱ gyaŋŋe̱ Yɛro̱salɛm maŋ‑nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Bamo̱ a nu e̱lawo̱ amo̱ a le̱e̱ Yeesuu a akɔɔre̱gyipo̱ a lɔŋ‑ɔ‑rɔ‑ɔ, ne̱ bamo̱‑rɔ bwe̱e̱tɔ a bo̱ gyaŋŋe̱ na bo̱ ŋu ke̱tɔ ne̱ ki de bamo̱‑ɔ. Ne̱ aa kpe̱ŋ bamo̱ e̱ye̱e̱, a le̱e̱ fe̱yɛ bamo̱ a nu bamo̱ ne̱ Wuribware̱ a kufwiiŋe timaa‑o a ywe̱e̱ bamo̱ se̱‑ɔ, ɔke̱maa e̱ sa bamo̱ aye̱‑rɔ se̱ŋsa. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Bo̱ mo̱ŋ nu ke̱tɔ ne̱ kaa ba‑ɔ kaase̱, ne̱ bo̱ yɛ, “Ne̱e̱ ase̱sɛ mɔ ne̱ ba sa se̱ŋsa mfaanɛɛ‑ɔ pɛɛɛ gye̱ Galile̱ya swe̱e̱re̱ se̱ awuye ne̱e̱ ɛ? ");
INSERT INTO ncuNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ne̱ nte̱tɔ ya waa se̱ ne̱ ane̱ ɔke̱maa ne̱ ɔ bo̱ mfe̱e̱‑ɔ i nu bamo̱ a sa ane̱ ɔke̱maa swe̱e̱re̱ se̱ a se̱ŋsa‑ɔ? ");
INSERT INTO ncuNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ane̱ bo̱ko̱ a le̱e̱ Paatiya swe̱e̱re̱ se̱, bo̱ko̱ mɔ a le̱e̱ Mɛde̱ya, bo̱ko̱ mɔ Ilam. Ne̱ bo̱ko̱ mɔ a le̱e̱ Mesopotamiya, na Yude̱ya, na Kapadokiya, na Pontus, na Asiya e̱swe̱e̱re̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ne̱ bo̱ko̱ a le̱e̱ Firigiya, bo̱ko̱ mɔ Pamfiliya, bo̱ko̱ mɔ Igyipiti, bo̱ko̱ a le̱e̱ Libiya swe̱e̱re̱ ne̱ ɔ maa Kireenee maŋ‑nɔ‑ɔ, na Roma maŋ‑nɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ane̱ pɛɛɛ gye̱ Yudaa awuye bɛɛɛ ase̱sɛ laŋgyaŋ ne̱ ane̱ gya Yudaa awuye ke̱bware̱suŋ a e̱kpa‑ɔ se̱. Ne̱ bo̱ko̱ mɔ a le̱e̱ Kriita kwii si na Arabiya e̱swe̱e̱re̱ se̱. Amaa ane̱ mɔ i nu bamo̱ a de ane̱ ɔke̱maa swe̱e̱re̱ se̱ a se̱ŋsa‑ɔ ba tɔwe̱ atɔ dabe̱ ne̱ Wuribware̱ a waa‑ɔ!” ");
INSERT INTO ncuNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ne̱ e̱ye̱e̱ a kpe̱ŋ bamo̱, ne̱ bamo̱ mfɛɛre̱ a waa ko̱kyɔ, ne̱ baa bise abɛɛ fe̱yɛ, “Amo̱‑ɔ kaase̱ e̱ gye̱ e̱me̱ne̱?” ");
INSERT INTO ncuNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Amaa bo̱ko̱ fe̱raa e̱ mɔse̱ bamo̱ ne̱ Wuribware̱ a kufwiiŋe timaa‑o te bamo̱ se̱‑ɔ ne̱e̱, na ba tɔwe̱ fe̱yɛ, “Ase̱sɛ mɔ pɛɛɛ a bwe̱e̱ ne̱e̱!” ");
INSERT INTO ncuNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ne̱ ayaa‑rɔ aye̱re̱po̱ kudu anyɔ‑ɔ a ko̱so̱ ye̱re̱. Ne̱ Peetroo a le̱e̱ bamo̱ ya bo̱ ye̱re̱ akatɔ‑rɔ, ne̱ ɔɔ sa se̱ŋsa gywii ase̱sɛ ne̱ baa gyaŋŋe̱ mfe̱ŋ‑ɔ. Ne̱ ɔɔ yase̱ mò̱ bo̱re̱‑ɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “M bɛɛko̱‑ana Yudaa awuye na ɔke̱maa ne̱ o te Yɛro̱salɛm mfe̱e̱‑ɔ, mo̱nꞌ lɔŋ e̱se̱bɔ na mo̱nꞌ nu ke̱tɔ ne̱ amo̱‑ɔ ne̱ aa ba‑ɔ e̱ kaapo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ase̱sɛ mɔ, n gye̱ sa ne̱ baa bwe̱e̱ fe̱yɛ ane̱ŋ ne̱ mo̱ne̱ e̱ fa‑ɔ. Mbe̱yɔmɔ saŋ a gye̱ gye̱gyaye̱ ne̱e̱, kyɔwe̱ mo̱ŋ tɛɛ daŋ. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Na amo̱‑ɔ ne̱ Wuribware̱ kyaamɛɛ Yo̱wɛl a tɔwe̱ amo̱ ase̱ŋ abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ɔ yɛ, ‘Wuribware̱ yɛ, Mfaanɛɛ ne̱ mo̱ e̱ waa ŋke lalalo̱we̱‑ɔ‑rɔ. Mo̱ e̱ sa a mo̱ kufwiiŋe‑o bo̱ ywe̱e̱ ɔke̱maa se̱. Mo̱ne̱ gyi‑ana, akye̱e̱ na anyare̱ pɛɛɛ, e̱ tɔwe̱ ke̱tɔ ne̱ mo̱ i lee a m bo̱ kaapo̱ bamo̱‑ɔ, na mo̱ne̱ ayaafɔre̱ ŋu mo̱ atɔ idee‑ro, na mo̱ne̱ anyaŋbre̱sɛ ku mo̱ ase̱ŋ‑ɔ idee. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ŋ yɛ, ŋke lalalo̱we̱ amo̱‑rɔ ne̱ mo̱ e̱ sa a mo̱ kufwiiŋe‑o bo̱ ywe̱e̱ anya gbaa se̱, akye̱e̱ na anyare̱ pɛɛɛ, na bo̱ tɔwe̱ ke̱tɔ ke̱maa ne̱ mo̱ i lee a m bo̱ kaapo̱ bamo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mo̱ e̱ kaapo̱ mo̱ ke̱yaale̱ŋ awo̱re̱‑rɔ na swe̱e̱re̱ se̱. Mo̱ne̱ i ŋu mbo̱gya na de̱e̱kpa na e̱bɔɔre̱e̱ bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kibugyii e̱ da mpase̱, na kiferi pee fe̱yɛ mbo̱gya‑ɔ, pwɛɛ na kake dabe̱ dabe̱ ne̱ mo̱ e̱ ba‑ɔ dɛɛ fo̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Na saŋ amo̱, m mo̱rɔwe̱ ɔke̱maa ne̱ o su a ɔ te̱e̱ mo̱‑ɔ.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ne̱ Peetroo a kya se̱ tɔwe̱ fe̱yɛ, “Isireelii awuye, mo̱ne̱ pɛɛɛ a nu Yeesuu Nasarɛte̱nyi ase̱ŋ, bɛɛɛ? Mò̱ e̱ gye̱ ɔko̱ ne̱ Wuribware̱ a bo̱rɔ mò̱ se̱ waa akpe̱ŋe̱ye̱e̱tɔ na atɔ dabe̱ dabe̱ bwe̱e̱tɔ mo̱ne̱ ase̱ mfe̱e̱. Mo̱ne̱ pɛɛɛ nyi amo̱‑ɔ, a le̱e̱ fe̱yɛ mo̱ne̱ akatɔ‑rɔ ne̱ ɔɔ waa amo̱‑ɔ pɛɛɛ. Ne̱ ane̱ŋ a atɔ amo̱ e̱ kaapo̱ fe̱yɛ Wuribware̱ a lee mò̱ suŋ bo̱ kyo̱ŋwe̱ mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ne̱ Wuribware̱ a kyɔ kra bo̱ ye̱re̱ kyee fe̱yɛ ba taa Yeesuu a bo̱ sa mo̱ne̱, ne̱ mo̱ne̱ a sa ne̱ abo̱ro̱kɔɔne̱po̱ a da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱ mɔɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Amaa Wuribware̱ a kyiŋŋi mò̱ le̱e̱ lowi‑ro, ne̱ ɔɔ kɔɔre̱ mò̱ e̱ye̱e̱ le̱e̱ lowi a e̱le̱ŋ‑ɔ‑rɔ, a le̱e̱ fe̱yɛ Wuribware̱ mo̱ŋ sa lowi kpa fe̱yɛ ɔ nya mò̱ se̱ ke̱yaale̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Bo̱ le̱e̱ fe̱yɛ ane̱ ɔde̱daapo̱ Deefid a kyo̱rɛɛ mò̱ ase̱ŋ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ, ‘Mo̱ nyaŋpe̱, mo̱ a ŋu fe̱yɛ fo̱ bo̱ mo̱ ase̱ saŋ ke̱maa. Ane̱ŋ ne̱ fo̱ bo̱ mo̱ kigyise si‑o si, sɛye̱ maa tɔɔraa mo̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Amo̱se̱ ne̱ mo̱ e̱ye̱e̱ a yuri mo̱, ne̱ mo̱ akatɔ a gyi mo̱ e̱ tɔwe̱ fo̱ kuŋu si ase̱ŋ. ne̱ n de te̱maa, a le̱e̱ fe̱yɛ ŋ nyi fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","mo̱ a gye̱ fo̱ ke̱yaafɔre̱ timaa‑o si‑o, fo̱ maa yɔwe̱ mo̱ kra a o sii alowipo̱‑rɔ, fo̱ maa sa a mo̱ kayo̱wɔre̱ gyo ke̱gye̱raŋta‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Fo̱ a kaapo̱ mo̱ kpa ne̱ ɔ yaa mo̱ ŋkpa‑rɔ‑ɔ, na, mo̱ ya yɔ fo̱ ase̱, mo̱ akatɔ gyi bwe̱e̱tɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Mo̱ ko̱so̱bɛɛ‑ana, mo̱nꞌ nu nɛɛnɛɛ fe̱yɛ Owure Deefid, ane̱ ɔde̱daapo̱ dabe̱, mɔ dɛɛ a wu, ne̱ baa pure mò̱‑ɔ, mò̱ ke̱gye̱raŋta saŋ ke̱ bo̱ mfe̱e̱ bo̱ fo̱ ndɔɔ. Amo̱se̱‑ɔ n gye̱ mò̱ e̱ye̱e̱ ase̱ŋ ne̱ ɔ dɛɛ ɔ tɔwe̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Deefid amo̱ dɛɛ ɔ gye̱ Wuribware̱ a akyaamɛɛ‑ɔ ɔko̱ ne̱e̱, ne̱ o nyi dame̱naŋsɛ fe̱yɛ Wuribware̱ a waa e̱taŋ fe̱yɛ ɔ sa a mò̱ ananagyi‑o ɔko̱ gyi kuwure fe̱yɛ ane̱ŋ ne̱ mò̱ fɔŋfɔŋ a gyi‑o dɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ke̱tɔ ne̱ ɔɔ kyɔ ŋu fe̱yɛ Wuribware̱ e̱ ba a ɔ bo̱ waa, ne̱ ɔɔ kyo̱rɛɛ amo̱ ase̱ŋ‑ɔ e̱ gye̱ fe̱yɛ Wuribware̱ i kyiŋŋi Kristoo ne̱ ɔɔ tɔwe̱ bo̱ be̱ya fe̱yɛ o suŋ a ɔ bo̱ kyo̱ŋwe̱‑ɔ le̱e̱ lowi‑ro. Kristoo amo̱ ne̱ Wuribware̱ mo̱ŋ sa a mò̱ kra sii alowipo̱‑rɔ. Ne̱ ɔ mo̱ŋ sa a mò̱ kayo̱wɔre̱ gyo ke̱gye̱raŋta‑rɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ane̱ pɛɛɛ a ŋu Yeesuu amo̱ ne̱ mo̱ e̱ tɔwe̱ mò̱ ase̱ŋ‑ɔ mò̱ kikyiŋŋi le̱e̱ lowi‑ro kamɛɛ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Mò̱ a kyiŋŋi le̱e̱ lowi‑ro‑o, ne̱ ɔɔ yɔ so̱so̱ ya kye̱na Wuribware̱ kigyise si, na mò̱ aa mò̱ gyi kuwure. Ne̱ Wuribware̱ ne̱ ɔ gye̱ mò̱ se̱‑ɔ a sa mò̱ mò̱ kufwiiŋe timaa‑o ne̱ Yeesuu yɛ ɔ sa mò̱ agyase̱po̱‑ɔ. Amo̱se̱‑ɔ ke̱tɔ ne̱ mo̱ne̱ a ŋu, ne̱ mo̱ne̱ a nu ndɔɔ‑ɔ e̱ gye̱ Wuribware̱ a kufwiiŋe timaa‑o ne̱ Yeesuu amo̱ a sa ne̱ ɔɔ bo̱ ywe̱e̱ ane̱ se̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Mò̱ ne̱ mbe̱yɔmɔ o yii so̱so̱, n gye̱ Deefid ya yɔ so̱so̱. Amaa Deefid e̱ gye̱ ne̱ ɔɔ kyo̱rɛɛ mò̱ ne̱ mbe̱yɔmɔ o yii so̱so̱‑ɔ kuŋu si ase̱ŋ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ to̱ŋ ko̱ fe̱yɛ, ‘Wuribware̱ a tɔwe̱ gywii mo̱ nyaŋpe̱ ne̱e̱ ɛ, Kye̱na mo̱ kigyise si mfe̱e̱ na n sa a fo̱ ado̱ŋ pɛɛɛ mɔ ba fo̱ kaase̱.’ ” ");
INSERT INTO ncuNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ne̱ Peetroo a tɔwe̱ bo̱ gye̱ kɛɛ fe̱yɛ, “Amo̱se̱ se̱‑ɔ, mo̱ne̱ Isireelii awuye nu fe̱yɛ Yeesuu mɔ ne̱ baa da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱‑ɔ e̱ gye̱ mò̱ ne̱ Wuribware̱ a lee fe̱yɛ mò̱ e̱ gye̱ Kristoo, ne̱ o kii ɔke̱maa mò̱ nyaŋpe̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Saŋ ne̱ ase̱sɛ pɛɛɛ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ a nu ase̱ŋ mɔ ne̱ Peetroo a tɔwe̱‑ɔ lo̱we̱‑ɔ, ne̱ aa tɔɔraa bamo̱ ŋkpo̱nɔ‑rɔ. Amo̱se̱ ne̱ baa tɔwe̱ gywii Peetroo na ayaa‑rɔ aye̱re̱po̱ ne̱ bo̱ tii si‑o fe̱yɛ, “Ane̱ ko̱so̱bɛɛ‑ana, ne̱ e̱me̱ne̱ ne̱ ane̱ e̱ waa?” ");
INSERT INTO ncuNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ne̱ Peetroo a tɔwe̱ gywii bamo̱ fe̱yɛ, “Mo̱ne̱ ɔke̱maa nu mò̱ e̱ye̱e̱ na o kiŋŋi le̱e̱ mò̱ e̱bɔye̱‑rɔ, na ɔ bɔ asuu Yeesuu Kristoo ke̱nyare̱‑rɔ, na Wuribware̱ taa mo̱ne̱ e̱bɔye̱ bo̱ ke mo̱ne̱, na o ke mo̱ne̱ mò̱ kufwiiŋe timaa‑o. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","A le̱e̱ fe̱yɛ mo̱ne̱ Isireelii awuye na mo̱ne̱ gyi‑ana na bamo̱ ne̱ bo̱ te ke̱fɔ‑ɔ bo̱ tii si, ne̱ Wuribware̱ yɛ ɔ sa mo̱ne̱ mò̱ kufwiiŋe timaa‑o. Kase̱ŋtiŋ fe̱raa, ɔke̱maa ne̱ ane̱ nyaŋpe̱ Wuribware̱ e̱ te̱e̱ a ɔ baa mò̱ ase̱‑ɔ ne̱ Wuribware̱ e̱ sa mò̱ mò̱ kufwiiŋe timaa‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ne̱ Peetroo a tɔwe̱ abware̱se̱ŋ gywii bamo̱ ane̱ŋ‑aaa. Ne̱ ŋkee ɔ yɛ, “Mo̱nꞌ lee mo̱ne̱ e̱ye̱e̱ bo̱ le̱e̱ ke̱se̱bɔgyiiri ne̱ ke̱ e̱ ba ndɔɔ a kaye̱ mɔ‑rɔ a abo̱ro̱kɔɔne̱po̱‑ɔ se̱‑ɔ‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ne̱ bamo̱ bwe̱e̱tɔ a kɔɔre̱ Peetroo ase̱ŋ‑ɔ gyi, ne̱ baa bɔ asuu mfe̱ŋ. Ŋke nsi amo̱, waa ase̱sɛ ŋkpe̱ŋ nsa ya tii bamo̱ ne̱ baa kɔɔre̱ Yeesuu ba gyi‑o si. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Le̱e̱ ŋke nsi amo̱, ne̱ baa le̱e̱ ba suye abware̱se̱ŋ le̱e̱ ayaa‑rɔ aye̱re̱po̱‑ɔ ase̱. Ne̱ bamo̱ pɛɛɛ a waa kanɔ ko̱ŋko̱ tii abɛɛ se̱. Ne̱ ŋkee ba gyaŋŋe̱ ba gyi ateese, na ba ko̱re̱ ke̱bware̱ko̱re̱ saŋ ke̱maa. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ne̱ Wuribware̱ a sa Yeesuu ayaa‑rɔ aye̱re̱po̱‑ɔ ke̱yaale̱ŋ ne̱ baa bo̱ waa akpe̱ŋe̱ye̱e̱tɔ bwe̱e̱tɔ‑ɔ. Ane̱ŋ se̱‑ɔ, ne̱ kufu a nya ɔke̱maa, ne̱ bamo̱ ɔke̱maa a kyo̱rɔ Wuribware̱ a ke̱dabe̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ne̱ akɔɔre̱gyipo̱ amo̱ pɛɛɛ a kya se̱ tii abɛɛ se̱, ne̱ ŋkee bamo̱ ɔko̱ ne̱ mò̱ i de ko̱tɔko̱, mò̱ bɛɛko̱ e̱ taare̱ kra‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Saŋ ko̱ na bo̱ fe bamo̱ mpo̱tɛɛ pɛɛɛ, na bo̱ taa atanne̱‑ɔ bo̱ tii abɛɛ se̱. Na bo̱ sa ɔke̱maa ke̱tɔ ne̱ ki tiri mò̱ ne̱ ɔ kpa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Na ba gyaŋŋe̱ Wuribware̱ suŋkpa‑ɔ kabuno kake ke̱maa, na ba gyaŋŋe̱ ba gyi abɛɛ aye̱ kakatɔgyi‑ro na kakpo̱nɔyuri‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Na ba kyo̱rɔ Wuribware̱. Ne̱ maŋ‑ɔ‑rɔ ase̱sɛ pɛɛɛ mɔ akatɔ a gyi bamo̱ se̱. Na Wuribware̱ e̱ sa ne̱ kake ke̱maa ba nya ase̱sɛ ne̱ Wuribware̱ e̱ mo̱rɔwe̱‑ɔ ba tii bamo̱ e̱ye̱e̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kake ŋko̱ kyɔwe̱ kikpeerebe̱e̱, ne̱ ke̱bware̱ko̱re̱ saŋ a fo̱‑ɔ, ne̱ Peetroo na Yohanee e̱ yɔ Wuribware̱ suŋkpa kabuno na bo̱ ya ko̱re̱ ke̱bware̱ko̱re̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Saŋ amo̱ ɔnyare̱ ko̱ ne̱ hare̱e̱ le̱e̱ mò̱ ŋyaagyi‑ro oo kii ke̱gyabɔɔ‑ɔ mɔ te Wuribware̱ suŋkpa kibunogyi ne̱ ba te̱e̱ ke̱mo̱ ɛ “Kibunogyi dame̱naŋsɛ”‑ɔ kanɔ. Kake ke̱maa bo̱ so̱ mò̱ ba ba mfe̱ŋ, na o te ɔ ko̱re̱ bamo̱ ne̱ ba lwee suŋkpa kabuno a bo̱ ko̱re̱ ke̱bware̱ko̱re̱‑ɔ atanne̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Amo̱se̱‑ɔ, saŋ ne̱ oo ŋu Peetroo na Yohanee i lweero‑o, ne̱ ɔɔ ko̱re̱ bamo̱ fe̱yɛ bo̱ sa mò̱ ko̱tɔko̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ne̱ baa de̱e̱re̱ mò̱ akatɔ‑rɔ, ne̱ Peetroo a tɔwe̱ gywii mò̱ fe̱yɛ, “De̱e̱re̱ ane̱!” ");
INSERT INTO ncuNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Amo̱se̱‑ɔ, ne̱ ɔɔ de̱e̱re̱ bamo̱, na ɔ fa fe̱yɛ ɔ nya ko̱tɔko̱ a ɔ le̱e̱ bamo̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Amaa Peetroo a tɔwe̱ gywii mò̱ ne̱e̱ fe̱yɛ, “Mo̱ŋ de atanne̱, amaa mo̱ e̱ sa fo̱ ke̱tɔ ne̱ n de‑o. Yeesuu Kristoo Nasarɛte̱nyi‑o ke̱nyare̱‑rɔ, ŋ yɛ fo̱ ko̱so̱ nare̱!” ");
INSERT INTO ncuNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ne̱ ɔɔ kra mò̱ kigyisesare̱e̱‑rɔ kya mò̱‑rɔ bo̱ kyuwi‑ro. Puri amo̱‑rɔ mfe̱ŋ ne̱ ke̱gyabɔɔ amo̱ ayaa a waa le̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ne̱ oo fuwi ywe̱e̱, ne̱ ɔɔ ye̱re̱ mò̱ ayaa se̱, ne̱ ɔɔ le̱e̱ ɔ naa. Ne̱ mò̱ aa bamo̱ a lwee Wuribware̱ suŋkpa kabuno, na ɔ naa na o fuwi ɔ ywe̱e̱, na ɔ kyo̱rɔ Wuribware̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ase̱sɛ ne̱ bo̱ bo̱ mfe̱ŋ‑ɔ pɛɛɛ a ŋu mò̱ a naa na ɔ kyo̱rɔ Wuribware̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Saŋ ne̱ baa pini fe̱yɛ ke̱gyabɔɔ ne̱ o te Kibunogyi dame̱naŋsɛ‑ɔ kanɔ ɔ ko̱re̱ atɔ‑ɔ, ne̱ e̱ye̱e̱ a kpe̱ŋ bamo̱ bo̱ le̱e̱ ke̱tɔ ne̱ kaa waa‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Amɔ ke̱gyabɔɔ ne̱ Peetroo a kya‑ɔ maa lɛɛ kpa fe̱yɛ ɔ maye̱ Peetroo na Yohanee. Amo̱se̱‑ɔ, ase̱sɛ a ŋu fe̱yɛ ŋkee ɔɔ kpaare̱, ne̱ mò̱ aa Peetroo na Yohanee bo̱ Wuribware̱ suŋkpa mfe̱ŋ ne̱ ba te̱e̱ ɛ Solomɔŋ abraŋdaye̱‑ɔ, ne̱ e̱ye̱e̱ a kpe̱ŋ bamo̱, ne̱ baa ŋwɛɛnaŋ yɔ bamo̱ ase̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Saŋ ne̱ Peetroo a ŋu ase̱sɛ amo̱‑ɔ, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, “M bɛɛko̱‑ana Isireelii awuye, nte̱tɔ se̱ ne̱ e̱ye̱e̱ a kpe̱ŋ mo̱ne̱, ne̱ mo̱ne̱ e̱ de̱e̱re̱ ane̱ ane̱ŋ? Mo̱ne̱ e̱ fa fe̱yɛ ane̱ fɔŋfɔŋ ke̱yaale̱ŋ bɛɛɛ itimaa ne̱ ane̱ a bo̱ sa ne̱ ke̱gyabɔɔ mɔ a ko̱so̱ nare̱ bɛɛɛ? Yeesuu ke̱yaale̱ŋ‑nɔ ne̱ ane̱ a taare̱ sa ne̱ ɔɔ ko̱so̱ nare̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Wuribware̱ ne̱ ane̱ i suŋ, ne̱ ane̱ ade̱daapo̱ Abraham na Isak na Yakubu a suŋ‑o dɛɛ ya taa mò̱ ke̱yaale̱ŋ bo̱ sa Yeesuu. Yeesuu mɔ dɛɛ ne̱ mo̱ne̱ a taa mò̱ bo̱ waa Gominaa Pilat ke̱sare̱e̱‑rɔ fe̱yɛ ɔ mɔɔ‑ɔ. Gominaa mɔ gbaa a kpa a ɔ yɔwe̱ mò̱ a ɔ nare̱ ya kyure. ");
INSERT INTO ncuNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ŋ yɛ Yeesuu mɔ dɛɛ ne̱ Wuribware̱ a lee suŋ bo̱ kyo̱ŋwe̱ ane̱ Isireelii awuye ase̱. Mò̱ dɛɛ e̱ gye̱ Wuribware̱ ke̱yaafɔre̱ ne̱ baa kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ ɔ mo̱ŋ de e̱bɔye̱, ne̱ mò̱ kakpo̱nɔ‑rɔ a fwiiri‑o. Amaa mo̱ne̱ mɔ mo̱ne̱ yɛ gominaa‑o sa a bo̱ mɔɔ mò̱, na ɔ yɔwe̱ ɔko̱ ne̱ ɔɔ waa ase̱ŋ bɔye̱, ne̱ ɔɔ mɔɔ ase̱sɛ, ne̱ baa tii mò̱‑ɔ bo̱ kyo̱ŋwe̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ne̱ mo̱ne̱ a mɔɔ mò̱ ne̱ ɔɔ kaapo̱ ane̱ kpa ne̱ ane̱ e̱ gya se̱, na ane̱ nya ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ. Amaa Wuribware̱ a kyiŋŋi mò̱ le̱e̱ lowi‑ro, ne̱ ane̱ pɛɛɛ a ŋu. ");
INSERT INTO ncuNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ane̱ŋ ne̱ ane̱ a kɔɔre̱ Yeesuu gyi‑o si, ne̱ ke̱gyabɔɔ mɔ ne̱ mo̱ne̱ ke̱e̱ mbe̱yɔmɔ‑ɔ e̱ taare̱ a ɔ nare̱. Yeesuu ke̱nyare̱ ne̱ ane̱ a bo̱ kya mò̱. Yeesuu ne̱ ane̱ a kɔɔre̱ mò̱ gyi‑o ke̱nyare̱ ne̱ ane̱ a bo̱ kya mò̱ fe̱yɛ ane̱ŋ ne̱ mo̱ne̱ a ŋu mò̱ a kpaare̱ lo̱we̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Mo̱ nyare̱‑ana, mbe̱yɔmɔ ŋ nyi fe̱yɛ mo̱ne̱ aa mo̱ne̱ agye̱ŋkpɛɛpo̱ pɛɛɛ mo̱ŋ nyi ke̱tɔ ne̱ mo̱ne̱ e̱ waa‑ɔ ne̱e̱ se̱ ne̱ mo̱ne̱ a waa Yeesuu ane̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kase̱ŋtiŋ si, ke̱tɔ ne̱ kaa ba‑ɔ ne̱ Wuribware̱ a sa ne̱ mò̱ akyaamɛɛ pɛɛɛ a tɔwe̱ hare̱e̱ le̱e̱ de̱daa‑ɔ fe̱yɛ ke̱ e̱ waa. Amo̱ e̱ gye̱ fe̱yɛ ɔko̱ ne̱ ba te̱e̱ mò̱ ɛ Kristoo‑o (kaase̱ e̱ kaapo̱ fe̱yɛ Wuribware̱ i suŋ mò̱ a ɔ bo̱ kyo̱ŋwe̱‑ɔ) e̱ ba kaye̱ mɔ‑rɔ, amaa kaye̱ mɔ‑rɔ a ase̱sɛ‑ɔ e̱ sa a o ŋu ase̱ŋ. Ne̱ ŋkee Wuribware̱ a sa ne̱ ke̱tɔ ke̱maa ne̱ baa tɔwe̱‑ɔ a ba‑rɔ kase̱ŋtiŋ. ");
INSERT INTO ncuNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Amo̱se̱‑ɔ mo̱nꞌ nu mo̱ne̱ e̱ye̱e̱, na mo̱nꞌ kiŋŋi le̱e̱ mo̱ne̱ e̱bɔye̱‑rɔ, na mo̱nꞌ ba Wuribware̱ ase̱, na ɔ nya taa mo̱ne̱ e̱bɔye̱ bo̱ ke mo̱ne̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Mo̱ne̱ ya waa amo̱‑ɔ, ane̱ nyaŋpe̱ Wuribware̱ e̱ sa a mo̱ne̱ ŋkpo̱nɔ yuri, na ɔ be̱e̱ suŋ Kristoo ne̱ oo lee fe̱yɛ ɔ ba mo̱ne̱ ase̱‑ɔ bo̱ kyo̱ŋwe̱. Kristoo mɔ e̱ gye̱ Yeesuu. ");
INSERT INTO ncuNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","O sii so̱so̱ mfe̱ŋ ne̱ ɔ bo̱‑ɔ bo̱ fo̱ saŋ ne̱ Wuribware̱ e̱ waa ke̱tɔ ke̱maa nɛɛnɛɛ, ane̱ŋ ne̱ mò̱ akyaamɛɛ timaa ne̱ baa dɛɛ kye̱na‑ɔ a tɔwe̱ hare̱e̱ le̱e̱ de̱daa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","A le̱e̱ fe̱yɛ ane̱ ɔde̱daapo̱ Mosis a kyo̱rɛɛ fe̱yɛ, ‘Mo̱ne̱ nyaŋpe̱ Wuribware̱ i lee se̱sɛ ko̱ a ɔ le̱e̱ mo̱ne̱ ako̱we̱bɛɛ‑rɔ, se̱sɛ ne̱ o du fe̱yɛ mo̱, Mosis‑o, fe̱yɛ ɔ waa mò̱ kyaamɛɛ sa mo̱ne̱, A bware fe̱yɛ mo̱nꞌ nu mò̱ ase̱ŋ tɔwe̱sɛ. ");
INSERT INTO ncuNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Amaa Wuribware̱ i lee ɔke̱maa ne̱ ɔ maa nu ane̱ŋ a kyaamɛɛ a kanɔ‑ɔ a ɔ le̱e̱ mò̱ ase̱sɛ‑rɔ, na ɔ gya mò̱ bo̱ kyo̱ŋwe̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Akyaamɛɛ‑ɔ pɛɛɛ bo̱ tii Samuwɛl se̱ na bamo̱ ne̱ baa sii kamɛɛ ne̱ baa tɔwe̱ ke̱tɔ ne̱ Wuribware̱ a tɔwe̱ fe̱yɛ bo̱ tɔwe̱‑ɔ gbaa a tɔwe̱ atɔ ne̱ mbe̱yɔmɔ a waa mɔ‑ɔ pɛɛɛ ase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ase̱ŋ ne̱ Wuribware̱ a tɔwe̱ bo̱ bo̱rɔ mò̱ akyaamɛɛ‑ɔ se̱ na amo̱ ne̱ ɔɔ tɔwe̱ gywii ane̱ ɔde̱daapo̱ Abraham‑ɔ gye̱ ko̱ko̱ŋko̱ ne̱e̱. Ke̱tɔ ne̱ ɔɔ tɔwe̱ gywii Abraham‑ɔ e̱ gye̱ fe̱yɛ, ‘Mo̱ e̱ bo̱rɔ fo̱ ananagyi‑o si a ŋ yure ase̱sɛ pɛɛɛ ne̱ bo̱ bo̱ kaye̱‑rɔ‑ɔ.’ Ase̱ŋ mɔ ne̱ Wuribware̱ a tɔwe̱ bo̱ be̱ya‑ɔ pɛɛɛ gye̱ mo̱ne̱ ne̱ mo̱ne̱ te ndɔɔ‑ɔ lee ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ne̱ mbe̱yɔmɔ Wuribware̱ ke̱yaafɔre̱ Yeesuu mɔ ne̱ ɔɔ gye̱ ŋkpɛɛ suŋ mò̱ bo̱ kyo̱ŋwe̱ mo̱ne̱ Isireelii awuye ase̱, na ɔ bo̱ yure mo̱ne̱ ɔke̱maa, na mo̱nꞌ nya yɔwe̱ bo̱ro̱kɔɔne̱ ne̱ mo̱ne̱ de‑o.” ");
INSERT INTO ncuNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Peetroo na Yohanee saŋ bo̱ ye̱re̱ ba tɔwe̱ abware̱se̱ŋ ba gywii ase̱sɛ‑ɔ, ne̱ Wuribware̱ alɔŋŋɔpo̱ na Wuribware̱ suŋkpa ade̱e̱re̱se̱po̱‑ɔ ɔbre̱sɛ‑ɔ na Sadukii awuye ko̱ a ba mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ne̱ bamo̱ iduŋ a fwii, bo̱ le̱e̱ fe̱yɛ abɛɛ anyɔ‑ɔ e̱ tɔwe̱ abware̱se̱ŋ ne̱e̱ fe̱yɛ Yeesuu a kyiŋŋi le̱e̱ lowi‑ro, ne̱ ke̱tɔ e̱ kaapo̱ fe̱yɛ saŋ ko̱ e̱ ba ne̱ bamo̱ ne̱ baa wu‑o i kyiŋŋi a bo̱ le̱e̱ lowi‑ro. ");
INSERT INTO ncuNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Amo̱se̱‑ɔ, ne̱ baa kra bamo̱ ya tii, na kaye̱ ya ke‑o na bo̱ ŋu ane̱ŋ ne̱ ba waa bamo̱‑ɔ, a le̱e̱ fe̱yɛ saŋ ne̱ baa kra bamo̱‑ɔ, kyɔwe̱ a kyɔ lo̱we̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Amaa bamo̱ ne̱ baa nu Peetroo na Yohanee a atɔ ke̱kaapo̱‑ɔ a kɔɔre̱ Yeesuu gyi. Ne̱ mbe̱yɔmɔ bamo̱ ne̱ baa kɔɔre̱ Kristoo gyi, ne̱ bo̱ gye̱ anyare̱‑ɔ kanɔ a waa ŋkpe̱ŋ nnuu. Akye̱e̱ na ŋyaagyi bwe̱e̱tɔ gbaa a kɔɔre̱ gyi. ");
INSERT INTO ncuNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kaye̱ ŋke‑o, Yudaa awuye agye̱ŋkpɛɛpo̱ na abre̱sɛ na Wuribware̱ mbraa akaapo̱po̱‑ɔ pɛɛɛ a gyaŋŋe̱ Yɛro̱salɛm maŋ‑nɔ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Bamo̱ aa Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ ne̱ ba te̱e̱ ɛ Hanaa, na mò̱ ako̱we̱bɛɛ Kayafas, na Yohanee na Alɛsanda na bamo̱ bo̱ko̱ ne̱ baa saŋ‑ɔ i tii bamo̱ ne̱ baa gyaŋŋe̱‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ne̱ baa sa ne̱ Peetroo na Yohanee a bo̱ ye̱re̱ bamo̱ akatɔ‑rɔ, ne̱ baa bise bamo̱ fe̱yɛ, “E̱me̱ne̱ ne̱ mo̱ne̱ a waa kya ke̱gyabɔɔ‑ɔ? Nte̱tɔ e̱le̱ŋ ne̱ mo̱ne̱ de, bɛɛɛ nsɛ e̱le̱ŋ ne̱ mo̱ne̱ a bo̱ kya ɔnyare̱ amo̱‑ɔ ne̱e̱?” ");
INSERT INTO ncuNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Wuribware̱ a kufwiiŋe timaa‑o a sa Peetroo ke̱yaale̱ŋ bwe̱e̱tɔ‑ɔ se̱‑ɔ, ne̱ ɔɔ be̱ŋŋaa bamo̱ fe̱yɛ, “Maŋ agye̱ŋkpɛɛpo̱ na abre̱sɛ, ");
INSERT INTO ncuNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ndɔɔ fe̱raa, mo̱ne̱ i bise ane̱ ke̱tɔ se̱ ne̱ ane̱ a waa ke̱gyabɔɔ ke̱dame̱naŋsɛ, na ane̱ŋ ne̱ ane̱ a waa kya mò̱‑ɔ bɛɛɛ? ");
INSERT INTO ncuNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","To, mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ Isireelii awuye fe̱yɛ Yeesuu Kristoo Nasarɛte̱nyi e̱le̱ŋ‑nɔ na ke̱nyare̱‑rɔ ne̱ ane̱ a bo̱ kya ɔnyare̱ mɔ, ne̱ mbe̱yɔmɔ ɔɔ kpaare̱ pɛɛɛ, ɔ ye̱re̱ mo̱ne̱ akatɔ‑rɔ mfe̱e̱‑ɔ. Ŋ yɛ ɛɛɛ, Yeesuu mɔ ne̱ mo̱ne̱ a da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱, ne̱ Wuribware̱ a kyiŋŋi mò̱ le̱e̱ lowi‑ro‑o e̱le̱ŋ‑nɔ na ke̱nyare̱‑rɔ ne̱ ane̱ a bo̱ kya ɔnyare̱ mɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yeesuu amo̱ kuŋu si ase̱ŋ ne̱ baa kyo̱rɛɛ waa abware̱se̱ŋ wo̱re̱‑ɔ‑rɔ fe̱yɛ, ‘Ke̱fo̱re̱ serisɛ ko̱ ne̱ apwɛɛpo̱ de bo̱ pwɛɛ ne̱ baa kine ke̱mo̱ bo̱ twe̱e̱‑ɔ, ya ko̱ŋ bo̱ kii ke̱mo̱ ne̱ kaa le̱ŋ lɔŋ‑ɔ pɛɛɛ bo̱ ye̱ra‑ɔ.’ ");
INSERT INTO ncuNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ɔke̱maa mo̱ŋ bo̱ kaye̱ mɔ‑rɔ ne̱ Wuribware̱ a sa e̱le̱ŋ a ɔ taare̱ mo̱rɔwe̱ se̱sɛ, amɔ Yeesuu wo̱re̱ kpeŋ. Mò̱ wo̱re̱ e̱ gye̱ ane̱ pɛɛɛ mɔ ɔmo̱rɔwe̱po̱.” ");
INSERT INTO ncuNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ne̱ e̱ye̱e̱ a ko̱ŋ kpe̱ŋ agye̱ŋkpɛɛpo̱‑ɔ na abre̱sɛ‑ɔ fe̱yɛ Peetroo na Yohanee a nya kakpo̱nɔ be̱ŋŋaa bamo̱ ane̱ŋ, na bamo̱ mɔ bo̱ mo̱ŋ suye wo̱re̱ akatɔ‑rɔ. Ŋkee ne̱ baa nyiŋŋi si fe̱yɛ abɛɛ anyɔ‑ɔ dɛɛ bo̱ gya Yeesuu si ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Amaa bo̱ mo̱ŋ lɛɛ taare̱ bise bamo̱ sɛye̱, a le̱e̱ fe̱yɛ baa ŋu Peetroo na Yohanee na ɔnyare̱ ne̱ baa kya mò̱‑ɔ a ye̱re̱ mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ne̱ bo̱ yɛ Peetroo na Yohanee na ɔnyare̱‑ɔ le̱e̱ se̱ŋgyikpa a ke̱kyaŋ‑ɔ‑rɔ. Bamo̱ a le̱e̱ kawu‑o, ne̱ agye̱ŋkpɛɛpo̱‑ɔ na abre̱sɛ‑ɔ wo̱re̱ wo̱re̱ a le̱e̱ ba tɔwe̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“E̱me̱ne̱ ne̱ ane̱ e̱ waa ase̱sɛ mɔ‑ɔ ne̱e̱? Yɛro̱salɛm awuye pɛɛɛ kyɔ bo̱ nyi fe̱yɛ bamo̱ a waa akpe̱ŋe̱ye̱e̱tɔ mɔ, ne̱ ane̱ gbaa ane̱ maa taare̱ a ane̱ gyiiri amo̱ ikii. ");
INSERT INTO ncuNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Amo̱se̱‑ɔ, mo̱nꞌ sa a ane̱ yii bamo̱ se̱ fe̱yɛ bo̱ ma lɛɛ tɔwe̱ ase̱ŋ Yeesuu ke̱nyare̱‑rɔ gywii ɔko̱. N gye̱ ane̱ŋ, ane̱ maa taare̱ a ane̱ kuŋ ɔke̱maa kunu ase̱ŋ‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ne̱ baa te̱e̱ bamo̱ lweero, ne̱ baa tɔwe̱ gywii bamo̱ fe̱yɛ bo̱ ma lɛɛ kaapo̱ ase̱sɛ atɔ bɛɛɛ tɔwe̱ ase̱ŋ Yeesuu ke̱nyare̱‑rɔ ŋke ŋko̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Amaa Peetroo na Yohanee a be̱ŋŋaa bamo̱ ne̱e̱ fe̱yɛ, “To, mbe̱yɔmɔ mo̱ne̱ fɔŋfɔŋ lee ke̱mo̱ ne̱ ki bware Wuribware̱ ase̱‑ɔ, ane̱ bu mo̱ne̱, bɛɛɛ ane̱ bu Wuribware̱? ");
INSERT INTO ncuNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","A le̱e̱ fe̱yɛ ane̱ fe̱raa, ane̱ maa taare̱ a ane̱ yɔwe̱ ase̱ŋ ne̱ ane̱ a nu, ne̱ ane̱ a ŋu‑o ko̱tɔwe̱.” ");
INSERT INTO ncuNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ne̱ agye̱ŋkpɛɛpo̱‑ɔ na abre̱sɛ‑ɔ a be̱e̱ yii bamo̱ se̱ kyo̱ŋ ke̱gye̱ŋkpɛɛ‑ɔ, ne̱ ŋkee baa yɔwe̱ bamo̱. Bamo̱ gbaa baa ŋu fe̱yɛ bo̱ maa taare̱ a bo̱ gyiiri Peetroo na Yohanee ke̱se̱bɔ, a le̱e̱ fe̱yɛ ase̱sɛ pɛɛɛ a kyo̱rɔ Wuribware̱ bo̱ le̱e̱ ke̱tɔ ne̱ kaa waa ke̱gyabɔɔ‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ke̱gyabɔɔ ne̱ baa kya mò̱ mɔ‑ɔ a gyi kyo̱ŋ nsu aduna. ");
INSERT INTO ncuNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Saŋ ne̱ baa de̱ŋ yɔwe̱ bamo̱‑ɔ, ne̱ Peetroo na Yohanee a kiŋŋi yɔ bamo̱ bɛɛko̱‑ana Yeesuu akɔɔre̱gyipo̱ ase̱ ya tɔwe̱ gywii bamo̱ ke̱tɔ ne̱ Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ na maŋ abre̱sɛ‑ɔ a tɔwe̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Bamo̱ ko̱so̱bɛɛ‑ana‑ɔ a nu‑o, ne̱ bamo̱ pɛɛɛ a gyaŋŋe̱ kyo̱rɔ Wuribware̱ fe̱yɛ, “O Nyaŋpe̱ Wuribware̱, fo̱ ya twe̱e̱ so̱so̱ na kaase̱ na ɔpo̱o̱‑ɔ na ke̱tɔ ke̱maa ne̱ ke̱ bo̱‑rɔ pɛɛɛ‑ɔ, ");
INSERT INTO ncuNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ane̱ nyi fe̱yɛ fo̱ a bo̱rɔ fo̱ kufwiiŋe timaa‑o si bo̱ sa ne̱ ane̱ ɔde̱daapo̱ Owure Deefid, fo̱ ke̱yaafɔre̱, a tɔwe̱ ɛ, ‘Nte̱tɔ se̱ ne̱ nde̱ se̱ awuye iduŋ a fwii, ne̱ ba da Wuribware̱ na owure ne̱ oo lee‑o kuŋu si kikpuni, na bamo̱ mɔ bo̱ maa taare̱ a bo̱ waa sɛye̱‑ɔ ne̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kaye̱ mɔ‑rɔ awure na agye̱ŋkpɛɛpo̱ a ke̱re̱ ke̱naa, na bo̱ waa kanɔ kɔ Wuribware̱ na mò̱ ne̱ oo lee‑o. Amaa bamo̱ mɔ, ba waa kwaa.’ ");
INSERT INTO ncuNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ne̱ amo̱‑ɔ a ba kase̱ŋtiŋ ane̱ŋ, fe̱yɛ Owure Hɛrɔd na Gominaa Pontiyus Pilat na Roma awuye na Yudaa awuye a gyaŋŋe̱ da fo̱ ke̱yaafɔre̱ timaa Yeesuu kuŋu si kikpuni bɔye̱. Baa tii abɛɛ se̱, ne̱ baa kra mò̱ ne̱ fo̱ a suŋ bo̱ kyo̱ŋwe̱ fe̱yɛ ɔ bo̱ mo̱rɔwe̱ ane̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Baa gyaŋŋe̱ waa ke̱tɔ ke̱maa ne̱ fo̱ e̱le̱ŋ‑nɔ fo̱ a kyɔ kra fo̱ mfɛɛre̱ fe̱yɛ ke̱ e̱ waa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Wuribware̱, mbe̱yɔmɔ, ke̱e̱ ane̱ŋ ne̱ ba fuŋte ane̱‑ɔ. Amo̱se̱‑ɔ, sa ane̱ ne̱ ane̱ gye̱ fo̱ ayaafɔre̱‑ɔ kakpo̱nɔ, na ane̱ taare̱ bo̱ tɔwe̱ fo̱ ase̱ŋ timaa‑o na kufu mo̱ŋ de ane̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Teyi fo̱ ke̱sare̱e̱ bo̱ kya alɔpo̱, na fo̱ sa a ane̱ waa atɔ ne̱ a kpe̱ŋ ase̱sɛ e̱ye̱e̱‑ɔ fo̱ ke̱yaafɔre̱ timaa Yeesuu ke̱nyare̱‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Bamo̱ a ko̱re̱ ke̱bware̱ko̱re̱ lo̱we̱‑ɔ, mfe̱ŋ ne̱ baa gyaŋŋe̱‑ɔ pɛɛɛ a le̱ŋkpaŋ ne̱e̱. Ne̱ Wuribware̱ a kufwiiŋe timaa‑o a ywe̱e̱ bamo̱ se̱, ne̱ baa nya ŋkpo̱nɔ ba tɔwe̱ abware̱se̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ne̱ Yeesuu akɔɔre̱gyipo̱‑ɔ pɛɛɛ a waa ko̱ŋko̱. Bamo̱ mfɛɛre̱ na nnɔ pɛɛɛ a waa ŋko̱ŋko̱. Ɔko̱ maa tɔwe̱ fe̱yɛ atɔ ne̱ o de‑o gye̱ mò̱ wo̱re̱ mò̱ lee ne̱e̱. Amaa ɔko̱ ne̱ mò̱ i de ko̱tɔko̱‑ɔ, bamo̱ pɛɛɛ mɔ i ke‑ro ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ne̱ ayaa‑rɔ aye̱re̱po̱ kudu anyɔ‑ɔ a nya Wuribware̱ e̱le̱ŋ bo̱ tɔwe̱ ane̱ nyaŋpe̱ Yeesuu kikyiŋŋi le̱e̱ lowi‑ro ase̱ŋ gywii ase̱sɛ, ne̱ Wuribware̱ a sa bamo̱ pɛɛɛ ŋyure bwe̱e̱tɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ko̱tɔko̱ mo̱ŋ tiri ɔko̱ bamo̱‑rɔ, a le̱e̱ fe̱yɛ bamo̱ ne̱ bo̱ de adɔɔ bɛɛɛ e̱lɔŋ‑ɔ i fe na bo̱ taa atanne̱ ne̱ baa fe nya‑ɔ baa. ");
INSERT INTO ncuNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Na bo̱ taa sa ayaa‑rɔ aye̱re̱po̱‑ɔ na bamo̱‑ɔ bo̱ sa ɔke̱maa ane̱ŋ ne̱ o nyi fe̱yɛ ɔ kpa‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Bamo̱ ne̱ baa fe bamo̱ mpo̱tɛɛ na bamo̱ adɔɔ‑ɔ ɔko̱ ke̱nyare̱ e̱ gye̱ Yo̱sɛf. Ɔɔ le̱e̱ Lewii a kasu‑o‑ro, ne̱ baa ko̱we̱ mò̱ Kiprus kwii si. Ne̱ ayaa‑rɔ aye̱re̱po̱‑ɔ a sa mò̱ ke̱ŋasɛnyare̱ fe̱yɛ Bar‑Nabas, kaase̱ e̱ kaapo̱ fe̱yɛ Ɔko̱‑ne̱‑ɔ‑sa-wɔre̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ne̱ oo fe mò̱ ko̱dɔɔ ne̱ o de‑o, ne̱ ɔɔ baa atanne̱ ne̱ ɔɔ nya‑ɔ baa bo̱ sa ayaa‑rɔ aye̱re̱po̱‑ɔ fe̱yɛ bo̱ ke‑ro sa atiripo̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Amaa saŋ ko̱, ne̱ ɔnyare̱ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Ananiyas‑o na mò̱ ka Safiraa a fe bamo̱ ko̱dɔɔ ko̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ne̱ mò̱ aa mò̱ ka a waa kanɔ, ne̱ ɔɔ te̱ŋ atanne̱‑ɔ kitiŋ lee, ne̱ ɔɔ taa amo̱ ne̱ aa saŋ‑ɔ yaa bo̱ sa ayaa‑rɔ aye̱re̱po̱‑ɔ fe̱yɛ bo̱ ke‑ro sa atiripo̱‑ɔ, ne̱ baa waa fe̱yɛ atanne̱‑ɔ gye̱ amo̱ ne̱ baa fe bamo̱ ko̱dɔɔ‑ɔ nya‑ɔ pɛɛɛ ne̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Mfe̱ŋ ne̱ Peetroo a bise mò̱ fe̱yɛ, “Ananiyas, nte̱tɔ se̱ ne̱ fo̱ a sa ne̱ Ɔbɔnsam a nya fo̱ hare̱e̱ ɔɔ sa ne̱ fo̱ a pe̱nna Wuribware̱ a kufwiiŋe timaa‑o, bo̱ le̱e̱ fe̱yɛ fo̱ a te̱ŋ atanne̱ ne̱ fo̱ a fe fo̱ ko̱dɔɔ‑ɔ nya‑ɔ kitiŋ taa‑ɔ ne̱e̱? ");
INSERT INTO ncuNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Fo̱ e̱ bo̱ ko̱dɔɔ‑ɔ pwɛɛ ne̱ fo̱ a dɛɛ fe, ne̱ fo̱ a be̱e̱ fe‑o atanne̱‑ɔ fo̱ dɛɛ fo̱ e̱ bo̱. Ne̱ nte̱tɔ ne̱e̱ ne̱ fo̱ a waa ane̱ŋ a ase̱ŋ‑ɔ? N gye̱ se̱sɛ ne̱ fo̱ a pe̱nna‑ɔ, Wuribware̱ ne̱ fo̱ a pe̱nna!” ");
INSERT INTO ncuNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiyas a de̱ŋ nu ane̱ŋ ne̱ Peetroo a tɔwe̱‑ɔ lo̱we̱‑ɔ, puri amo̱‑rɔ ne̱ ɔɔ le̱e̱ da wu. Ne̱ kufu a nya ɔke̱maa ne̱ oo nu ase̱ŋ mɔ‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ne̱ ayaafɔre̱ ko̱ a lweero bo̱ ba atɔ bo̱ buŋ mò̱ se̱, ne̱ baa taa mò̱ yaa pure. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Bo̱ fo̱ dɔŋhwe̱re̱e̱ e̱sa‑ɔ, ne̱ mò̱ ka Safiraa mɔ a bo̱ lweero, na ɔ mo̱ŋ nyi ke̱tɔ ne̱ kaa waa mò̱ kuri‑o. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ne̱ Peetroo a bise Safiraa fe̱yɛ, “Gyi kase̱ŋtiŋ fe̱yɛ mo̱ne̱ a fe mo̱ne̱ ko̱dɔɔ‑ɔ, amɔ atanne̱ ne̱ mo̱ne̱ a nya pɛɛɛ‑ɔ e̱ gye̱ amo̱‑ɔ aaa?” Ne̱ ɔɔ be̱ŋŋaa ɛ, “Ɔɔŋ, amo̱ pɛɛɛ ne̱e̱!” ");
INSERT INTO ncuNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ne̱ Peetroo a tɔwe̱ gywii mò̱ fe̱yɛ, “Nte̱tɔ ne̱e̱ ne̱ fo̱ aa fo̱ kuri a waa kanɔ mo̱ne̱ e̱ kyɔ Wuribware̱ a kufwiiŋe‑o‑ro mo̱ne̱ e̱ ke̱e̱? Ase̱sɛ ne̱ baa ya pure fo̱ kuri‑o i kiŋŋi ba ba bo̱ bo̱‑rɔ. Amaa bamo̱ dɛɛ bamo̱ e̱ gye̱ ne̱ ba so̱rɔ fo̱ a bo̱ be̱e̱ bo̱ le̱e̱!” ");
INSERT INTO ncuNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Puri amo̱‑rɔ mfe̱ŋ ne̱ mò̱ gbaa a le̱e̱ da Peetroo ayaa‑rɔ mfe̱ŋ wu. Ayaafɔre̱ amo̱ a bo̱ lweero‑o, baa ŋu mò̱ a wu ɔ da, ne̱ baa so̱rɔ mò̱ le̱e̱, ne̱ baa ya pure mò̱ me̱raa mò̱ kuri. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ne̱ kufu a nya asɔre̱e̱ awuye na ɔke̱maa ne̱ oo nu bamo̱ ilowi‑o si‑o. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_12a","074_5_12a","ACT","5","12a","12a","Ne̱ akɔɔre̱gyipo̱‑ɔ pɛɛɛ a gyaŋŋe̱ Wuribware̱ suŋkpa mfe̱ŋ ne̱ ba te̱e̱ ɛ Solomɔŋ abraŋdaye̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Hare̱e̱ ase̱sɛ pɛɛɛ ya bu bamo̱ gbaa ooo, ɔke̱maa ne̱ ɔ mo̱ŋ tii bamo̱ se̱‑ɔ, kufu de mò̱ kulwee bamo̱‑rɔ gyaŋŋe̱kpa mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Amaa ase̱sɛ bwe̱e̱tɔ, akye̱e̱ na anyare̱ pɛɛɛ ne̱ baa kɔɔre̱ Yeesuu gyi‑o tii akɔɔre̱gyipo̱‑ɔ se̱ saŋ ke̱maa. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_12b","074_5_12b","ACT","5","12b","12b","Ne̱ ayaa‑rɔ aye̱re̱po̱‑ɔ a waa akpe̱ŋe̱ye̱e̱tɔ bwe̱e̱tɔ bo̱ kaapo̱ ase̱sɛ maŋ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Bo̱ le̱e̱ ke̱tɔ ne̱ ayaa‑rɔ aye̱re̱po̱‑ɔ e̱ waa‑ɔ se̱‑ɔ, ase̱sɛ a so̱rɔ bamo̱ alɔpo̱ bwe̱e̱tɔ ya bo̱ be̱ya e̱kraŋ na e̱kyaakyaa na e̱bɛɛre̱ se̱ maŋ‑ɔ‑rɔ mbo̱re̱ se̱, na Peetroo ya kyo̱ŋ mfe̱ŋ a mò̱ kuyayu dɔŋŋɔ bamo̱ se̱ a bo̱ nya kpaare̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ne̱ ase̱sɛ bwe̱e̱tɔ a le̱e̱ e̱maŋ ne̱ e̱ maa Yɛro̱salɛm‑ɔ se̱ so̱rɔ alɔpo̱ na bamo̱ ne̱ ibrisi te bamo̱ se̱‑ɔ baa ayaa‑rɔ aye̱re̱po̱‑ɔ ase̱. Ne̱ baa kya bamo̱ pɛɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Amo̱se̱‑ɔ, ne̱ Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ‑ɔ na mò̱ ase̱sɛ ne̱ mò̱ aa bamo̱ mpe̱pe̱yɔ a tii katuŋ ne̱ ba te̱e̱ ɛ Sadukii awuye‑o de ayaa‑rɔ aye̱re̱po̱‑ɔ ko̱kwe̱e̱, ne̱ bamo̱ iduŋ a fwii bamo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ne̱ baa kra ayaa‑rɔ aye̱re̱po̱‑ɔ pɛɛɛ yaa tii mfe̱ŋ ne̱ baa tii abo̱ro̱kɔɔne̱po̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Amaa ke̱mo̱ kanye ne̱ Wuribware̱ kabɔɔ ko̱ a le̱e̱ so̱so̱ bo̱ taye̱ ke̱kyaŋ ne̱ baa tii bamo̱ ke̱mo̱‑rɔ‑ɔ a po̱ne̱‑ɔ, ne̱ oo lee ayaa‑rɔ aye̱re̱po̱‑ɔ, ne̱ ɔɔ tɔwe̱ gywii bamo̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Mo̱nꞌ nare̱ ya ye̱re̱ Wuribware̱ suŋkpa kabuno, na mo̱nꞌ tɔwe̱ ŋkpa na kukyure ne̱ a mo̱ŋ de kɛɛ‑ɔ ase̱ŋ mfe̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ayaa‑rɔ aye̱re̱po̱‑ɔ mo̱ŋ kine, ne̱ baa fo̱ Wuribware̱ suŋkpa kabuno gye̱gyaye̱ kese‑ro, ne̱ baa le̱e̱ abware̱se̱ŋ‑ɔ ke̱kaapo̱. Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ‑ɔ na mò̱ ase̱sɛ mo̱ŋ nyi fe̱yɛ ayaa‑rɔ aye̱re̱po̱‑ɔ a le̱e̱. Ne̱ baa te̱e̱ Yudaa awuye abre̱sɛ‑ɔ bo̱ gyaŋŋe̱. Ne̱ baa suŋ bo̱ kyo̱ŋwe̱ fe̱yɛ bo̱ lee ayaa‑rɔ aye̱re̱po̱‑ɔ pɛɛɛ baa se̱ŋgyikpa mfe̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Amaa bamo̱ a yɔ‑ɔ, bo̱ mo̱ŋ ŋu bamo̱ tiikpa‑ɔ se̱‑ɔ, ne̱ baa kiŋŋi bo̱ tɔwe̱ gywii abre̱sɛ ne̱ baa gyaŋŋe̱‑ɔ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Saŋ ne̱ ane̱ a yɔ mfe̱ŋ‑ɔ ke̱kyaŋ‑ɔ a tii hare̱e̱ baa twe̱e̱‑rɔ, ne̱ asoogyaa awuye ye̱re̱ ba ke̱e̱ se̱. Amaa ane̱ a taye̱ lweero‑o, ane̱ mo̱ŋ ŋu ɔko̱ ke̱mo̱‑rɔ!” ");
INSERT INTO ncuNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Wuribware̱ suŋkpa ade̱e̱re̱se̱po̱ ɔbre̱sɛ‑ɔ na Wuribware̱ alɔŋŋɔpo̱ abre̱sɛ‑ɔ a nu amo̱‑ɔ, ne̱ aa waa bamo̱ mfɛɛre̱, ne̱ kufu de bamo̱ fe̱yɛ ase̱ŋ e̱ ba. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ne̱ ɔnyare̱ ko̱ a lweero bamo̱ ase̱ mfe̱ŋ, ne̱ ɔ yɛ, “Mo̱ne̱ i nu aaa, ase̱sɛ ne̱ mo̱ne̱ a tii tiikpa‑ɔ ye̱re̱ ba kaapo̱ ase̱sɛ atɔ Wuribware̱ suŋkpa kabuno!” ");
INSERT INTO ncuNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ne̱ Wuribware̱ suŋkpa ade̱e̱re̱se̱po̱ ko̱ na bamo̱ ɔbre̱sɛ a yɔ mfe̱ŋ ya baa ayaa‑rɔ aye̱re̱po̱‑ɔ. Amaa ade̱e̱re̱se̱po̱‑ɔ mo̱ŋ ye̱re̱ bamo̱, a le̱e̱ fe̱yɛ kufu de bamo̱ fe̱yɛ bamo̱ ya ye̱re̱ bamo̱, ase̱sɛ ne̱ bo̱ ye̱re̱ ba nu ayaa‑rɔ aye̱re̱po̱ amo̱ ase̱ŋ mfe̱ŋ‑ɔ e̱ twe̱e̱ bamo̱ abu. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ne̱ baa baa ayaa‑rɔ aye̱re̱po̱‑ɔ baa bo̱ ye̱ra maŋ agye̱ŋkpɛɛpo̱‑ɔ na abre̱sɛ‑ɔ akatɔ‑rɔ. Ne̱ Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ‑ɔ a tɔwe̱ gywii bamo̱ fe̱yɛ, ");
INSERT INTO ncuNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ne̱e̱ ane̱ a sa mo̱ne̱ mbraa fe̱yɛ mo̱ne̱ ma lɛɛ kaapo̱ ase̱sɛ atɔ Yeesuu ke̱nyare̱‑rɔ, amaa mo̱nꞌ de̱e̱re̱ ane̱ŋ ne̱ mo̱ne̱ a waa‑ɔ! Mo̱ne̱ ke̱kaapo̱‑ɔ a saŋŋe̱‑rɔ lwee Yɛro̱salɛm maŋ pɛɛɛ‑rɔ, ne̱ ŋkee mo̱ne̱ e̱ kpa a mo̱nꞌ taa Yeesuu lowi bo̱ so̱rɔ ane̱.” ");
INSERT INTO ncuNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ne̱ Peetroo na ayaa‑rɔ aye̱re̱po̱ ne̱ bo̱ tii si‑o pɛɛɛ a be̱ŋŋaa fe̱yɛ, “Wuribware̱ ne̱ ane̱ i bu, n gye̱ se̱sɛ. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Wuribware̱ ne̱ ane̱ Isireelii awuye a suŋ hare̱e̱ le̱e̱ ane̱ ade̱daapo̱ mbe̱e̱ se̱‑ɔ e̱ gye̱ ne̱ oo kyiŋŋi Yeesuu le̱e̱ lowi‑ro saŋ ne̱ mo̱ne̱ a da mò̱ bo̱ me̱ra kiyii kpare̱-abɛɛ‑rɔ se̱ mɔɔ‑ɔ kamɛɛ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Wuribware̱ a kyiŋŋi mò̱ le̱e̱ lowi‑ro yaa mò̱ ya bo̱ kye̱na mò̱ kigyise si fe̱yɛ mò̱ e̱ gye̱ ane̱ owure na ane̱ ɔmo̱rɔwe̱po̱, na Isireelii awuye nya nu bamo̱ e̱ye̱e̱, na ɔ taa bamo̱ e̱bɔye̱ bo̱ ke bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Amɔ ase̱ŋ ne̱ ane̱ a ye̱re̱ ayaa‑rɔ ane̱ e̱ tɔwe̱. Ne̱ Wuribware̱ a kufwiiŋe timaa ne̱ Wuribware̱ i ke bamo̱ ne̱ ba gya mò̱ kanɔ se̱‑ɔ, e̱ de̱ŋ ɔ be̱e̱ ɔ ye̱re̱ ase̱ŋ amo̱ ayaa‑rɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ayaa‑rɔ aye̱re̱po̱‑ɔ a tɔwe̱ ane̱ŋ‑ɔ, ne̱ Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ‑ɔ na mò̱ ase̱sɛ‑ɔ iduŋ a fwii bamo̱ se̱, hare̱e̱ baa kpa fe̱yɛ bo̱ mɔɔ bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Amaa bamo̱‑rɔ Farisiinyi ko̱ ne̱ ɔke̱maa i bu, ne̱ ba te̱e̱ mò̱ ɛ Gamaliilii‑o a ko̱so̱ ye̱re̱ ne̱e̱, ne̱ ɔɔ sa ne̱ baa lee ayaa‑rɔ aye̱re̱po̱‑ɔ le̱e̱ ngyaŋŋe̱‑ɔ‑rɔ kafwe̱e̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ne̱ ɔɔ sa se̱ŋsa gywii bamo̱ ne̱ baa gyaŋŋe̱‑ɔ fe̱yɛ, “M bɛɛko̱‑ana Isireelii awuye, mo̱nꞌ sa ke̱tɔ ne̱ mo̱ne̱ e̱ kpa a mo̱nꞌ bo̱ waa ase̱sɛ mɔ‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ne̱ mo̱ne̱ a nyiŋŋi si fe̱yɛ ɔnyare̱ ko̱ ne̱ ba te̱e̱ mò̱ ɛ Tiyudas‑o a dɛɛ ba saŋ ko̱, ne̱ ɔ yɛ mò̱ fe̱raa gye̱ se̱sɛ dabe̱ ne̱e̱, ne̱ waa ase̱sɛ alafa ana a gya mò̱ se̱. Amaa Roma awuye asoogyaa ko̱ a mɔɔ mò̱, ne̱ bamo̱ ne̱ bo̱ gya mò̱ se̱‑ɔ a brawe̱‑rɔ, ne̱ mò̱ ase̱ŋ na ke̱tɔ ke̱maa a wu. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Amo̱ kamɛɛ‑rɔ ne̱ Yudas Galile̱yanyi‑o a ba kasu ne̱ baa kare̱ ase̱sɛ kamo̱‑rɔ‑ɔ, ne̱ ase̱sɛ bwe̱e̱tɔ a gya mò̱ se̱, ne̱ baa kɔ Roma awuye‑o, ne̱ Roma awuye amo̱ a mɔɔ mò̱ gbaa mò̱, ne̱ bamo̱ ne̱ bo̱ gya mò̱ se̱‑ɔ pɛɛɛ a brawe̱‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Amo̱se̱‑ɔ mbe̱yɔmɔ mo̱ e̱ tɔwe̱ mo̱ i gywii mo̱ne̱ fe̱yɛ mo̱ne̱ ma waa ase̱sɛ mɔ sɛye̱. Mo̱nꞌ yɔwe̱ bamo̱! Ne̱ ke̱tɔ ne̱ baa waa mɔ‑ɔ e̱ gye̱ bamo̱ fɔŋfɔŋ e̱le̱ŋ ne̱ baa bo̱ waa, amo̱ fe̱raa a gye̱ kɛɛ. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Amaa ne̱ amo̱ ya le̱e̱ Wuribware̱ ase̱ fe̱raa, ane̱ maa taare̱ a ane̱ tii bamo̱ kpa, a le̱e̱ fe̱yɛ mo̱ne̱ aa Wuribware̱ e̱ gye̱ ne̱ mo̱ne̱ e̱ kɔ.” Ne̱ baa gya Gamaliilii a ase̱ŋ‑ɔ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ne̱ baa te̱e̱ ayaa‑rɔ aye̱re̱po̱‑ɔ kiŋŋi baa ngyaŋŋe̱‑ɔ‑rɔ, ne̱ baa sa ne̱ baa daye̱ bamo̱ ko̱kyo̱kywe̱e̱, ne̱ baa be̱e̱ yii bamo̱ se̱ fe̱yɛ bo̱ ma lɛɛ tɔwe̱ ase̱ŋ gywii ase̱sɛ Yeesuu ke̱nyare̱‑rɔ. Ne̱ ŋkee baa yɔwe̱ bamo̱ bo̱ kyo̱ŋwe̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ayaa‑rɔ aye̱re̱po̱‑ɔ a le̱e̱ ngyaŋŋe̱‑ɔ‑rɔ na bamo̱ akatɔ a gyi, a le̱e̱ fe̱yɛ Wuribware̱ a lee bamo̱ sa ne̱ baa kperi Yeesuu si gyi ipeere. ");
INSERT INTO ncuNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ne̱ ŋkee kake ke̱maa bo̱ naa Wuribware̱ suŋkpa kabuno na ase̱sɛ e̱lɔŋ‑nɔ ba kya se̱ ba kaapo̱, na ba tɔwe̱ ase̱ŋ timaa fe̱yɛ Yeesuu e̱ gye̱ Kristoo ne̱ Wuribware̱ a suŋ bo̱ kyo̱ŋwe̱‑ɔ ase̱ŋ ba gywii ase̱sɛ. ");
INSERT INTO ncuNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Saŋ ko̱ bo̱ fo̱‑ɔ, ase̱sɛ ne̱ bo̱ dɛɛ bo̱ gya Kristoo ase̱ŋ ke̱kaapo̱ se̱‑ɔ a waa ko̱kyɔ bwe̱e̱tɔ. Ne̱ e̱kɔ a lwee Yudaa awuye ne̱ baa ko̱we̱ bamo̱ e̱maŋ ne̱ ba sa Griiki se̱ŋsa e̱mo̱‑ɔ‑rɔ na Yudaa awuye ne̱ baa ko̱we̱ bamo̱ bamo̱ fɔŋfɔŋ aye̱‑ɔ mbo̱ŋtɔ‑rɔ. Bamo̱ ne̱ ba sa Griiki‑ro‑o yɛ akɔɔre̱gyipo̱‑ɔ i ke ateese‑ro kake ke̱maa, bamo̱ akpenlekye̱e̱‑ɔ mo̱ŋ nya. ");
INSERT INTO ncuNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Amo̱se̱‑ɔ ne̱ ayaa‑rɔ aye̱re̱po̱ kudu anyɔ‑ɔ a te̱e̱ Kristoo ase̱ŋ ke̱kaapo̱ agyase̱po̱‑ɔ pɛɛɛ bo̱ gyaŋŋe̱, ne̱ baa tɔwe̱ gywii bamo̱ fe̱yɛ, “A mo̱ŋ bware fe̱yɛ ane̱ a yɔwe̱ abware̱se̱ŋ ko̱tɔwe̱, na ane̱ i gyi ateese na atanne̱ ase̱ŋ. ");
INSERT INTO ncuNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Amo̱se̱ se̱‑ɔ, ane̱ ako̱so̱bɛɛ, mo̱nꞌ de̱e̱re̱ mo̱ne̱‑rɔ, na mo̱nꞌ lee abɛɛ asunoo ne̱ mo̱ne̱ nyi fe̱yɛ bo̱ de Wuribware̱ a kufwiiŋe timaa‑o na kanyiase̱ŋ‑ɔ, na ane̱ sa a bamo̱ e̱ de̱ŋ bo̱ de̱e̱re̱ ase̱ŋ‑ɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Na ane̱ fe̱raa ane̱ kusuŋ kii fe̱yɛ ane̱ de̱e̱ kya se̱ ko̱re̱ ke̱bware̱ko̱re̱, ne̱ ane̱ e̱ tɔwe̱ abware̱se̱ŋ.” ");
INSERT INTO ncuNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ne̱ bamo̱ pɛɛɛ akatɔ a gyi mfɛɛre̱ timaa ne̱ ayaa‑rɔ aye̱re̱po̱‑ɔ a baa‑ɔ se̱. Amo̱se̱‑ɔ, ne̱ baa lee Stifaŋ ne̱ mò̱ ko̱kɔɔre̱gyi‑ro bo̱ le̱ŋ‑ɔ, ne̱ o de Wuribware̱ a kufwiiŋe timaa‑o bwe̱e̱tɔ‑ɔ na Filipo na Prokorus na Nikanɔɔ na Timɔŋ na Paame̱nas na Nikolas ne̱ ɔ mo̱ŋ gye̱ Yudaanyi, ne̱ ɔɔ le̱e̱ Ante̱yɔke̱ya maŋ‑nɔ, ne̱ saŋ ko̱ ɔɔ ba o suŋ Wuribware̱ fe̱yɛ ane̱ŋ ne̱ Yudaa awuye i suŋ‑o. ");
INSERT INTO ncuNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ne̱ akɔɔre̱gyipo̱‑ɔ a taa bamo̱ ya bo̱ kaapo̱ ayaa‑rɔ aye̱re̱po̱‑ɔ. Ne̱ bamo̱‑ɔ baa ba asare̱e̱ bo̱ dɔŋŋɔ bamo̱ aŋu si, ne̱ baa ko̱re̱ ke̱bware̱ko̱re̱ sa bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ane̱ŋ se̱‑ɔ, ne̱ abware̱se̱ŋ‑ɔ a kya se̱ yɔ to̱ŋ ke̱maa. Ne̱ akɔɔre̱gyipo̱ ne̱ bo̱ bo̱ Yɛro̱salɛm maŋ‑nɔ‑ɔ a waa ko̱kyɔ. Ne̱ Wuribware̱ alɔŋŋɔpo̱ bwe̱e̱tɔ a bo̱ kɔɔre̱ Yeesuu gyi bo̱ tii bamo̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ne̱ Stifaŋ ne̱ Wuribware̱ a sa ŋyure na e̱le̱ŋ‑ɔ a kya alɔpo̱, ne̱ ɔɔ waa atɔ dabe̱ bwe̱e̱tɔ, ne̱ ase̱sɛ ne̱ baa ŋu‑o e̱ye̱e̱ a kpe̱ŋ bamo̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Amɔ Yudaa awuye ko̱ bo̱‑rɔ ne̱ bo̱ dɛɛ bo̱ gye̱ anya, ne̱ mbe̱yɔmɔ bo̱ gye̱ agyi. Ne̱ bo̱ de bamo̱ fɔŋfɔŋ ke̱bware̱ko̱re̱kyaŋ ba suŋ Wuribware̱ ke̱mo̱‑rɔ. Bamo̱‑ɔ‑rɔ bo̱ko̱ mo̱ŋ sure si, ne̱ baa gyiiri Stifaŋ ikii. Bamo̱ bo̱ko̱ gye̱ Yudaa awuye ne̱ baa le̱e̱ Kireenee na Alɛsandriya e̱maŋ‑nɔ na Kilikiya na Asiya e̱swe̱e̱re̱ se̱. ");
INSERT INTO ncuNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Amaa Wuribware̱ a kufwiiŋe timaa‑o a sa Stifaŋ kanyiase̱ŋ‑ɔ se̱‑ɔ, mò̱ a sa se̱ŋsa‑ɔ, bo̱ mo̱ŋ lɛɛ taare̱ tɔwe̱ sɛye̱ bo̱ gyiiri mò̱ ikii. ");
INSERT INTO ncuNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Amo̱se̱‑ɔ, ne̱ baa sa ase̱sɛ ko̱ atanne̱ na bo̱ tɔwe̱ fe̱yɛ, “Ane̱ a nu mò̱ a tɔwe̱ ase̱ŋ o kye Wuribware̱ na ane̱ mbraa ne̱ Wuribware̱ a bo̱rɔ Mosis si bo̱ sa ane̱‑ɔ.” ");
INSERT INTO ncuNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mfaanɛɛ ne̱ baa waa bo̱ fwii ase̱sɛ na abre̱sɛ na Wuribware̱ mbraa akaapo̱po̱‑ɔ iduŋ. Ne̱ baa kra Stifaŋ yaa maŋ agye̱ŋkpɛɛpo̱‑ɔ na abre̱sɛ‑ɔ akatɔ‑rɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ne̱ baa ba ase̱sɛ ko̱ ne̱ baa bo̱ ba aye̱ba bo̱ dɔŋŋɔ mò̱ se̱ fe̱yɛ, “Saŋ ke̱maa ɔnyare̱ mɔ e̱ tɔwe̱ ase̱ŋ bɔye̱ o kye Wuribware̱ suŋkpa‑ɔ na Wuribware̱ mbraa ne̱ ane̱ a nya le̱e̱ Mosis ase̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ane̱ a nu mò̱ a tɔwe̱ fe̱yɛ Yeesuu Nasarɛte̱nyi‑o i bwee Wuribware̱ suŋkpa, na o kyurowi mbraa ne̱ Mosis a sa ane̱‑ɔ pɛɛɛ!” ");
INSERT INTO ncuNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ne̱ bamo̱ ne̱ bo̱ te se̱ŋgyikpa mfe̱ŋ‑ɔ pɛɛɛ a kii bamo̱ akatɔ bo̱ ye̱ra Stifaŋ si ba de̱e̱re̱ mò̱. Ne̱ baa ŋu fe̱yɛ mò̱ akatɔ‑rɔ du fe̱yɛ Wuribware̱ kabɔɔ lee‑o. ");
INSERT INTO ncuNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ne̱ Wuribware̱ ɔlɔŋŋɔpo̱ bre̱sɛ‑ɔ a bise Stifaŋ ɛ, “Ke̱tɔ ne̱ ba po̱rɔ fo̱ ke̱mo̱ se̱‑ɔ gye̱ kase̱ŋtiŋ aaa?” ");
INSERT INTO ncuNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ne̱ ɔɔ be̱ŋŋaa fe̱yɛ, “N se̱‑ana na n daa‑ana na n tire‑ana, mo̱nꞌ nu mo̱ ase̱! Pwɛɛ ne̱ ane̱ nana Abraham a dɛɛ tu ya kye̱na Haraŋ maŋ‑nɔ‑ɔ, Wuribware̱, owure dabe̱‑ɔ, a lee mò̱ e̱ye̱e̱ bo̱ kaapo̱ mò̱ Mesopotamiya swe̱e̱re̱ se̱ mfe̱ŋ ne̱ Kalade̱ya awuye te‑o. ");
INSERT INTO ncuNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ne̱ ɔɔ tɔwe̱ gywii mò̱ fe̱yɛ, ‘Le̱e̱ swe̱e̱re̱ mɔ se̱ na fo̱ yɔwe̱ fo̱ ako̱we̱bɛɛ na fo̱ yɔ swe̱e̱re̱ ne̱ mo̱ e̱ kaapo̱ fo̱‑ɔ se̱.’ ");
INSERT INTO ncuNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Amo̱se̱‑ɔ, ne̱ ɔɔ le̱e̱ mò̱ swe̱e̱re̱‑ɔ se̱ ya kye̱na Haraŋ. Abraham mò̱ se̱ lowi kamɛɛ, ne̱ Wuribware̱ a sa ne̱ Abraham a be̱e̱ tu bo̱ kye̱na swe̱e̱re̱ mɔ mfe̱e̱ ne̱ mo̱ne̱ te mò̱ se̱‑ɔ. ");
INSERT INTO ncuNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Saŋ‑ɔ, Wuribware̱ mo̱ŋ tɛɛ taa hare̱e̱ swe̱e̱re̱‑ɔ kabe̱gyɛɛ gbaa sa Abraham, amaa ɔɔ tɔwe̱ bo̱ be̱ya fe̱yɛ ɔ saŋ ɔ taa a ɔ bo̱ sa mò̱ aa mò̱ ananagyi. Saŋ ne̱ Wuribware̱ a tɔwe̱ ase̱ŋ mɔ‑ɔ, na Abraham mo̱ŋ de agyi. ");
INSERT INTO ncuNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ke̱tɔ ne̱ Wuribware̱ a tɔwe̱ gywii mò̱‑ɔ e̱ gye̱ fe̱yɛ, ‘Fo̱ ananagyi e̱ ba a bo̱ bo̱ kii afɔ swe̱e̱re̱ baŋbaŋ k