﻿USE sofia;
DROP TABLE IF EXISTS sofia.ncr_vpl;
CREATE TABLE ncr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ncr_vpl WRITE;
INSERT INTO ncr_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Manɛ le maŋkuŋ ma bachiji kfuu chi Jiso Kletu: Jiso gɛ̀ bee mwa wu a kfuu chi Nfoŋ Dabi wù gɛ̀ bee mwa wu a kfuu chi Ablaham le. ");
INSERT INTO ncr_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ablaham gɛ̀ bee chiji Asik, Asik gɛ̀ bee chiji Yakob, Yakob gɛ̀ bee chiji Juda bɛ booŋ bachiji, ");
INSERT INTO ncr_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda gɛ̀ bee chiji Bɛlɛ bɛ Sɛla ba bwee bo gɛ̀ bee Tama. Bɛlɛ gɛ̀ bee chiji Ɛsloŋ, Ɛsloŋ gɛ̀ bee chiji Laŋ. ");
INSERT INTO ncr_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Laŋ gɛ̀ bee chiji Aminada, Aminada gɛ̀ bee chiji Nasoŋ, Nasoŋ gɛ̀ bee chiji Salimoŋ. ");
INSERT INTO ncr_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimoŋ gɛ̀ bee chiji Boa wù bwee gɛ̀ bee Lahab. Boa gɛ̀ bee chiji Obɛd wù bwee gɛ̀ bee Lu. Obɛd gɛ̀ bee chiji Jɛsi. ");
INSERT INTO ncr_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jɛsi gɛ̀ bee chiji Nfoŋ Dabi. Nfoŋ Dabi gɛ̀ bee chiji Salamoŋ wù bwee gɛ̀ bee kwɛ Ulia. ");
INSERT INTO ncr_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salamoŋ gɛ̀ bee chiji Luhobwaŋ, Luhobwaŋ gɛ̀ bee chiji Abija, Abija gɛ̀ bee chiji Asa. ");
INSERT INTO ncr_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa gɛ̀ bee chiji Jɛhoshɛfat, Jɛhoshɛfat gɛ̀ bee chiji Jolaŋ, Jolaŋ gɛ̀ bee chiji Yosaya. ");
INSERT INTO ncr_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Yosaya gɛ̀ bee chiji Jotaŋ, Jotaŋ gɛ̀ bee chiji Aha, Aha gɛ̀ bee chiji Hɛsikaya, ");
INSERT INTO ncr_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hɛsikaya gɛ̀ bee chiji Manase, Manase gɛ̀ bee chiji Amoŋ, Amoŋ gɛ̀ bee chiji Yosaya. ");
INSERT INTO ncr_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosaya gɛ̀ bee chiji Jɛkonia bɛ booŋ ba bwee. Ba gɛ̀ boyi bo shɛshi shige nyu kife kì bamii ba Babiloŋ gɛ̀ kooyɛ bamii ba Ishwala bo gɛɛŋ bɛ bo woŋ wuboo wù Babiloŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ajiŋ ayu, no bo gɛ̀ kooyɛ bamii ba Ishwala bo gɛɛŋ bɛ bo Babiloŋ, Jɛkonia gɛ̀ bee chiji Shalta, Shalta gɛ̀ bee chiji Sɛlubabe, ");
INSERT INTO ncr_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sɛlubabe gɛ̀ bee chiji Abiud, Abiud gɛ̀ bee chiji Ɛliakim, Ɛliakim gɛ̀ bee chiji Aso, ");
INSERT INTO ncr_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aso gɛ̀ bee chiji Sadok, Sadok gɛ̀ bee chiji Akim, Akim gɛ̀ bee chiji Ɛliud, ");
INSERT INTO ncr_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ɛliud gɛ̀ bee chiji Ɛlisa, Ɛlisa gɛ̀ bee chiji Mataŋ, Mataŋ gɛ̀ bee chiji Yakob. ");
INSERT INTO ncr_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakob gɛ̀ bee chiji Yosɛf wù juma Mɛɛle, Mɛɛle nyu wu wù gɛ̀ boyɛ Jiso wù ba tɛŋe lɛ Kletu. ");
INSERT INTO ncr_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Noo, bachiji kfuu chi Jiso banɛ le yuufe ncho banɛh kɛge yi Ablaham le, too bude yi Nfoŋ Dabi le, ka nyu yuufe ncho banɛh kɛge yi Nfoŋ Dabi le too bude sege ba gɛ̀ kooyɛ bamii ba Ishwala ba gɛɛŋ bɛ bo Babiloŋ. Kɛge sege ba gɛ̀ kooyɛ bamii ba Ishwala too bude sege ba gɛ̀ boyɛ Kletu, bachiji kfuu chiboo tɛ nyu yuufe ncho banɛh. ");
INSERT INTO ncr_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Boyɛ chi Jiso Kletu gɛ̀ jiɛnyi a je yinɛ le. Bwee wù Mɛɛle gɛ̀ bee ba seesɛ wa lɛ wu lé wu gê wu nyûme kwɛ Yosɛf. Fɛ bo taashɛ bvuguu, fi gɛ̀ ja fi bu lɛ wu le wa bɛ fwe a bvuŋga bvu Kiyo ki Yuude le. ");
INSERT INTO ncr_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","No fi gɛ̀ kooshɛ noo, Yosɛf wù jwɛɛŋ, no wù gɛ̀ bee muh wù chaaŋ wu koŋe gɛ ki wu chôosɛ wu gɛ, wu mo wu yɛŋ lɛ wu lé wu gâsɛ bɛ wu nyu ajiŋ ajiŋ. ");
INSERT INTO ncr_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","No wu gɛ̀ baaŋ wu kwaji ki wu gê noo, fi kooshɛ lɛ nchɛndaa wu Tada gɛ̀ ja wu to fɛ wu le a kifilɛ le sege wu gɛ̀ lefe wu jɛmɛ wu le lɛ, “Yosɛf, mwa wù a kfuu chi Nfoŋ Dabi le, keefɛ wo fâŋ ki wo jô Mɛɛle bwee yeh wo le gɛ, nje fwe chinɛ chi wu le bɛ chi wù kɛme chi a bvuŋga bvu Kiyo ki Yuude le. ");
INSERT INTO ncr_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Wu lé wu gê wu boo mwa wu jwɛŋsɛ wo chû jee che lɛ Jiso, nje wu lé wu gê wu bvûsɛ bamii be yi bimbefɛ biboo le.” ");
INSERT INTO ncr_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mwɛɛ munɛ munchii gɛ̀ kooshɛ ki fi to fi kojɛ no Tada gɛ̀ jɛmɛ wa jwe wu muh we wu tuŋ le lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Bɛŋ yêgɛ bɛŋ yû, mwa wuchile wumu lé wu gê wu nyu bɛ fwe, wu boo mwa wu jwɛŋsɛ ba tɛ̂ŋe wu lɛ Ɛmaniwe.” Jee chinɛ le lɛ, “Nyo le bɛ bee.” ");
INSERT INTO ncr_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","No kifilɛ kɛɛ gɛ̀ lanɛ Yosɛf noo, wu gɛ̀ kaŋsɛ wu mo wu ge gɛh no nchɛndaa wu Tada gɛ̀ jɛmɛ wu le. Wu gɛ̀ be wu jo Mɛɛle kwɛɛ le, ");
INSERT INTO ncr_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","geenɛ gɛ wu gɛ chee bɛ wu njɛ no muh bɛ kwɛɛ to bo chee gɛ. Bɛ wu chee noo gɛɛŋ bu no Mɛɛle gɛ̀ jiɛnyɛ fɛ wu to wu boo. Yosɛf mo wu chu jee chi mwa wuyu lɛ Jiso. ");
INSERT INTO ncr_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ba gɛ̀ boyi Jiso ntɛ wù Bɛtɛhɛm le a kimbe ki woŋ ki Judia le. Gɛ̀ bee kife kiyu le Hɛlod nyu Nfoŋ wu Judia. Fi kooshɛ lɛ babvufee bamu gɛ̀ bee bo ja woŋ wumu le kimbe kì juu saane yo le, bo to Yɛlusalɛm bo biide lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Nfoŋ wu Bajuu wù ba boyi wɛɛ le faaŋ? Bee biide nɛ nje bee le be yɛŋ joŋ ye le a kimbe kì juu saane yo le, bee mo be ja bee too ki be yuusɛ wu.” ");
INSERT INTO ncr_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nfoŋ Hɛlod doo wu yu saaka wunɛ noo wu shiŋshɛ fitele fie, wu shiŋshɛ mo mu bamii ba Yɛlusalɛm bachii. ");
INSERT INTO ncr_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Wu tɛɛŋ bachiji kintanyɛ ba baaŋ baaŋ bachii bɛ bamii bachii ba duunyi banchi ba Nyo, bamii baa taashɛ. Wu biih bo le laa fɛ ba gɛ̀ bee ki ba boo Mbvusɛ wù Nyo gɛ̀ ka, le faane la? ");
INSERT INTO ncr_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bochvuu lɛ, “Ba gɛ̀ bee boo wu ntɛ wù Bɛtɛhɛm le wu kimbe ki Judia le. Finɛ fiɛɛ le no muh wu ntuŋ wu Nyo gɛ̀ saŋ lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Wo wù Bɛtɛhɛm wu woŋ wu Juda le, keefɛ wo kwâji lɛ wo le fintɛ fì shige baaŋ woŋ wu Juda le gɛ, wo kêe lɛ muh lé wu gê wu bu ntɛ wunɛ le, wu lé wu gê wu sage bamii baŋ ba Ishwala.’” ");
INSERT INTO ncr_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nfoŋ Hɛlod mo wu tɛɛŋ tɛ babvufee baa ajiŋ ajiŋ wu biih ki wu yû a bo le chuule kife ki joŋ yiyu gɛ̀ bu. ");
INSERT INTO ncr_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","No wu yu wu mo wu tuŋ bo Bɛtɛhɛm wu jɛmɛ lɛ, “Bɛŋ gɛ̂ɛŋ bɛŋ tâa bɛŋ gôoŋ mwa wuyu chuule. Bɛŋ doo bɛŋ gooŋ bɛŋ yɛŋ, bɛŋ kaasɛ bɛŋ to bɛŋ sɛ̂ɛŋ mɛne, wu lɛ taŋlo ŋgɛɛŋ tɛ n'yuusɛ wu.” ");
INSERT INTO ncr_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Bamii bayu yu no Nfoŋ jɛmɛ noo, bo mo bo bu bo gɛɛne ŋgɛnɛ wuboo. Lɛ bo doo bo gɛɛŋ, fi kooshɛ lɛ joŋ yì bo gɛ̀ yɛŋ a kimbe kì juu saane yo yɛɛ le ka yi yɛnɛ yi tu yi jiɛnyi yi gɛɛne bo fwe yi duunyi bo je. Yi gɛɛŋ nɛ, yi gɛɛŋ yi bu fɛ mwa wuyu gɛ̀ bee fo, yi mo yi lɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","No bo yɛŋ joŋ yiyu le noo, bo yu njoŋ baaŋ, ye tu yi joŋe bo. ");
INSERT INTO ncr_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bo gɛɛŋ bo lee yeh yi mwa gɛ̀ bee yu le, bo yɛŋ mwa bɛ bwee wù Mɛɛle le, bo mo bo gwe a mwa wuyu jii bo yuusɛ wu. No bo yuuse bo gwenyɛ bikɛɛ biboo bo bvusɛ mwɛɛ muboo mu n'yuusɛ nfoŋ, bo nya wu le. Mwɛɛ munɛ gɛ̀ bee kichwa ki bige kì yɛɛde, bɛ kfuu chi jiiŋ chimi ba tɛŋe lɛ flaŋkiŋsɛŋ, mo kfuu chi mɛɛ ma yefɛ mamu ba tɛŋe lɛ mɛɛl. ");
INSERT INTO ncr_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nyo chiisɛ lo bo le a kifilɛ le lɛ keefɛ bo ka bo tu jiŋ bo gɛɛŋ bo yɛŋ Nfoŋ Hɛlod le gɛ. Bo mo bo tu jiŋ woŋ wuboo le a je yimi le yeye. ");
INSERT INTO ncr_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","No babvufee baa gɛ̀ ja wa bo gɛɛŋ, fi kooshɛ lɛ nchɛndaa wu Tada gɛ̀ ja wu to fɛ Yosɛf le a kifilɛ le wu jɛmɛ wu le lɛ, “Ja we wo jo mwa bɛ bwee bena bo fɛɛ bɛŋ gɛɛŋ woŋ wu Ijib le, bɛŋ nyume yo gɛɛŋ bu kife ki nle ŋge ndu lɛ bɛŋ kaasɛ. Njɛme nɛ nje Nfoŋ Hɛlod goone je ki wu yûuyɛ mwa wunɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yosɛf mo wu ja we, wu jo mwa bɛ bwee antaŋ bo ja bo gɛɛŋ Ijib, ");
INSERT INTO ncr_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","bo tu bo nyu yo gɛɛŋ bu kife ki Nfoŋ Hɛlod gɛ̀ lɛsɛ le. Fi gɛ̀ kooshɛ noo ki fi gê fi to fi kojɛ no Nyo gɛ̀ jɛmɛ jwe wu muh tuŋ we le lɛ, “Nle ntɛɛŋ mwa yaŋ wu bu woŋ wu Ijib le.” ");
INSERT INTO ncr_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hɛlod gɛ̀ doo wu yɛŋ lɛ babvufee baa le bo lɛɛ bɛ wu, fi fuuŋsɛ wu baaŋ. Wu mo wu tuŋ bamii lɛ bo gɛɛŋ Bɛtɛhɛm mo bimbe bi mbebe yo le bichii, bo yuuyɛ booŋ ba bilɛŋsɛ ba le kɛge biluŋ bifɛɛ tuu jiŋ. Wu gɛ̀ nya biluŋ binɛ wu bii no wu gɛ̀ bilɛ babvufee baa le wu yu chuule kife kì bo gɛ̀ yɛŋ joŋ yɛɛ le. ");
INSERT INTO ncr_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Bo gɛɛŋ bo yuuyɛ booŋ banɛ noo, fi mo fi kojɛ no muh wu ntuŋ wu Nyo wù Yɛlimia gɛ̀ jɛmɛ wa lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Bo le bo yu kitada ntɛ wù Lama le, muh jaŋe kwe, wu beede wu fuude ye. Le Lashɛ wu beede booŋ be. Bo chiise wu bo chiise sɛŋ, nje booŋ be baaŋ gɛ yu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nfoŋ Hɛlod gɛ̀ doo wu lɛsɛ, fi kooshɛ lɛ Nchɛndaa wu Tada gɛ̀ bu fɛ Yosɛf le a kifilɛ le woŋ wù Ijib le, wu jɛmɛ wu le lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Ja we, wo jo mwa bɛ bwee bena bo kaasɛ bɛŋ tu jiŋ woŋ wù Ishwala le, nje bo baa bò gɛ̀ goone ki bo jo kinche ki mwa wunɛ le bo kweeyɛ wa.” ");
INSERT INTO ncr_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Noo, Yosɛf mo wu ja we wu jo mwa bɛ bwee bɛ bo tuu jiŋ woŋ wù Ishwala le. ");
INSERT INTO ncr_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Geenɛ, wu gɛ̀ doo wu to, wu yu lɛ mwa Nfoŋ Hɛlod wù Akɛliu le wu ji kinta ki chiji Judia, wu tu wu sage, wu mo wu faŋ ki wu gɛ̂ɛŋ yo. Bo ka bo kajɛ wu a kifilɛ le lɛ keefɛ wu gɛ̂ɛŋ yo gɛ. Wu mo wu bɛɛŋ wu gɛɛŋ nyu kimbe ki woŋ kì Galalee le, ");
INSERT INTO ncr_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","wu gɛɛŋ wu tu wu chee ntɛ wu ba tɛŋe lɛ Nasalɛ le. Fi gɛ̀ kooshi noo ki fi kojɛ no muh wu ntuŋ wu Nyo gɛ̀ jɛmɛ wa lɛ, “Bo lé bo gê bo tɛŋe wu lɛ muh wu Nasalɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Gɛ̀ bee kife kɛɛ le, Joŋ Nlesɛajoo ja wu bunɛ wu gɛɛŋ kwa kimbe ki woŋ kì Judia le wu tu wu feeji bamii le lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Bɛŋ kusɛ muntele mwɛna, nje bvunfoŋ bvù fɛwe le wa mbebe le.” ");
INSERT INTO ncr_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Joŋ wunɛ le muh wù Yosaya wù muh wu ntuŋ wu Nyo gɛ̀ jɛme kune wu sege wu gɛ̀ jɛmɛ lɛ, “Jɛ yi muh jaŋe nchvuuŋ lɛ, ‘Ba sêesɛ je yi Tada, ba nâjɛ yi nyû chaaŋ.’” ");
INSERT INTO ncr_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Joŋ gɛ̀ jiide njú yì ba kɛnyɛ bɛ yvú yi nyaŋ yimi yì ba tɛŋe lɛ kamɛɛ, wu kaane kicha chiŋ ba kɛnyɛ bɛ je yi nyaŋ, mwɛɛ mwe munjile gɛ̀ bee chuma bɛ bvutu bvu nchvuuŋ. ");
INSERT INTO ncr_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","No wu gɛ̀ feeji noo, bamii tu bo bude Yɛlusalɛm bɛ bantɛ le bachii ba Judia mo bimbe bi mbebe Joo yì Jodaŋ le bichii, bo gɛɛne fɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","No bo gɛɛne noo bo sɛŋe bimbefɛ biboo, wu mo wu leese bo a Joo yì Jodaŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Geenɛ, wu gɛ̀ doo wu yɛŋ Bafalashii bɛ Basadushii bamu le wesee bo too lɛ wu leesɛ bo a joo, wu jɛmɛ bo le lɛ, “Kiŋgogɛ ki yó lɛ, teefe yɛɛŋ bɛŋ lɛ bɛŋ lêge shɛ́ŋ yi Nyo yì bɛɛne wu yì wu lé wu gê wu dûnyɛ bɛŋ le, fɛ bɛŋ too nɛ? ");
INSERT INTO ncr_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Bɛŋ gêe mwɛɛ mù duunyi lɛ bɛŋ le bɛŋ kusɛ wa muntele mwɛna. ");
INSERT INTO ncr_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Keefɛ bɛŋ mo bɛŋ dûu gɛh fɛ bikwɛɛ biɛna le lɛ Ablaham le chiji wene gɛ. Nsɛŋe bɛŋ le lɛ taŋlo Nyo fiisɛ ata kanɛ wo tu booŋ ba Ablaham. ");
INSERT INTO ncr_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Bɛŋ kêe lɛ ba le ba gɛɛ wa tɛmɛ fɛ binyi bi bite le. Kite kichii kì baaŋ yuŋ gɛ muntaŋ mù njoŋe gɛ, tu ba lé ba gwô nɛ ba lee ba gɛɛŋ yi gɛŋ le, ba toŋ lo. ");
INSERT INTO ncr_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nleese bɛŋ a joo nje bɛŋ le bɛŋ kusɛ wa muntele mwɛna. Geenɛ muh wù too a mɛ jiŋ kuge wu fede mɛ. Jé ye, gɛ ŋkooji ki ntuu gɛ. Wu lé wu gê wu leese fie bɛŋ nyu chiaaŋ yi Kiyo ki Yuude le, mo yi ŋgu le. ");
INSERT INTO ncr_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Wu kɛme fiɛɛ fie abo fì wu fɛɛde agiŋ yu, wu lé wu yɛ̂ɛsɛ fɛ wu fɛ̂ɛde, wu bânyɛ agiŋ wu gɛ̂ɛ a ŋwaŋ le, wu mo wu kôo munyi wu toŋ bɛ ŋgu wu fiee wu jime gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","No Joŋ gɛ̀ leese bamii a joo noo, Jiso mo wu ja kimbe ki woŋ kì Galalee le wu to fɛ Joo yì Jodaŋ le lɛ Joŋ leesɛ tɛ wu a joo. ");
INSERT INTO ncr_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Geenɛ Joŋ tu wu faŋe wu duu lɛ, “Le wo wù be kɛme ki wo lêesɛ mɛ a joo, wo katu too fɛ mɛne nɛ nɛɛ?” ");
INSERT INTO ncr_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jiso chvuu wu le lɛ, “Chînɛ fi nyume noo mɛɛse! Le yi yinɛ je le yì besa wo lé be gê fiɛɛ fichii fi nyu chaaŋ a Nyo jii.” Noo, Joŋ mo wu bɛɛŋ, wu leesɛ Jiso a joo. ");
INSERT INTO ncr_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Gɛh no Jiso gɛ̀ bude a joo, kibvulɛ gwenyɛ ye, Kiyo ki Nyo shii ki to ye ye le fiɛɛnɛ kibɛmbɛ. ");
INSERT INTO ncr_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Fi kooshɛ lɛ, jɛ gɛ̀ jɛmɛ fɛwe lɛ, “Wunɛ le Mwa yaŋ. Wu le fitele fiaŋ. N'yuge njoŋ bɛ wu baaŋ.” ");
INSERT INTO ncr_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kiyo ki Yuude mo ki ja ki jo Jiso ki gɛɛŋ bɛ wu kwa lɛ debele moŋ wu. ");
INSERT INTO ncr_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Wu gɛɛŋ wù nyu yo wu shee wu too wu chee, wu jii gɛ fiɛɛ gɛ, yi aju le mbaanyɛ. Ajiŋ ayu jɛŋ ja yi yuu wu. ");
INSERT INTO ncr_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Wu wɛɛ wù mone bamii mo wu to wu jɛmɛ wu le lɛ, “Wo nɛ le Mwa Nyo, wo dû ata kanɛ tu bantu ba blɛd.” ");
INSERT INTO ncr_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jiso chvuu wu le lɛ, “Ba le ba saŋ lɛ, ‘Gɛ muh chee gɛh nje mwɛɛ munjile maa gɛ. Muh chee tɛ nje jɛ yichii yì bude jwe wù Nyo le.’” ");
INSERT INTO ncr_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Noo, Sataŋ mo wu jo wu, wu gɛɛŋ bɛ wu a kinlaantɛŋ kì Yɛlusalɛm le, wu leesɛ wu fɛ kigo ki yeh yi kintanyɛ le, ");
INSERT INTO ncr_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","wu jɛmɛ wu le lɛ, “Wo nɛ le Mwa Nyo, wo selɛ fɛkuu, nje fi le ba saŋ lɛ, ‘Nyo lé wu dû banchɛndaa be le lɛ bo chîɛɛŋ wo.’ Fi ka nyu ba saŋ lɛ, ‘Bo lé bo gê bo kaŋ lo wo, lɛ keefɛ wo kfuuŋ kikaa yi tɛdɛ le gɛ.’” ");
INSERT INTO ncr_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jiso chvuu wu le lɛ “Ba le ba saŋ lɛ, ‘Keefɛ wo mône Tada wù Nyo wo gɛ.’” ");
INSERT INTO ncr_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Debele ka wu jo Jiso fo, wu gɛɛŋ nyu yi kikwɛɛ ki mbegɛ wumu wu ndefe fɛwe wesee le, wu mo wu chunyɛ bituŋ bi yi kikwɛɛ ki nshɛŋ le bichii bɛ bvukugɛ bvuyu bvuchii. ");
INSERT INTO ncr_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","No wu chunyi noo wu mo wu jɛmɛ lɛ, “Nlé nnyâ mwɛɛ munɛ munchii wo le, fɛ wo nɛ le wo gwe a mɛ jii wo ŋgvuuŋ mɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jiso jɛmɛ wu le lɛ, “Gɛnɛ yaga Sataŋ! Ba le ba saŋ lɛ, ‘Wo ŋgvûune Tada wù Nyo wo, wo lɛ̂ne nyu wu le maa.’” ");
INSERT INTO ncr_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Noo debele mo wu chinɛ Jiso le, wu gɛɛŋ. Fi kooshɛ lɛ banchɛndaa ba Nyo gɛ̀ ja bo to bo jiiŋe fɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jiso gɛ̀ ja wu yu lɛ ba le ba koo Joŋ Nlesɛajoo ba leesɛ wu yeh yi ncha le, wu mo wu ja wu kaasɛ wu tu jiŋ kimbe kì Galalee le. ");
INSERT INTO ncr_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Wu gɛɛŋ wu bu Nasalɛ, wu ja yo wu gɛɛŋ wu tu wu chee a kilaantɛŋ kì Kafanahum le. Kilaantɛŋ kinɛ gɛ̀ bee mbebe Mamasi wù Galalee le mo mbebe bimbe bi bamii ba Sɛbuluŋ bɛ ba Naftali le. ");
INSERT INTO ncr_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Finɛ fiɛɛ gɛ̀ kooshi nɛ lɛ fi kojɛ no muh wu ntuŋ wu Nyo wù Yosaya gɛ̀ jɛmɛ wa lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Kimbe kì Sɛbuluŋ bɛ kì Naftali, bì le mbebe mamasi le Joo yì Jodaŋ le wuŋ kwege, nshɛŋ yi Galalee yì bamii ba le gɛ Bajuu gɛ, ");
INSERT INTO ncr_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","bamii ba chi shee bo chee kijibɛ le, le bo yɛŋ wa n'yuu wù baaŋ le. Juu le chi saaŋ wa fɛ bamii banɛ, ba chi shee bo chee gwɛŋ wu kijibɛ ki kwe le.” ");
INSERT INTO ncr_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kɛge kife kɛɛ le, Jiso mo wu kɛ wu feeji bamii le wu jɛme lɛ, “Bɛŋ kûsɛ muntele mwɛna, nje bvunfoŋ bvù fɛwe le wa mbebe le!” ");
INSERT INTO ncr_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jiso gɛ̀ ja wu jiɛnyi mbebe Mamasi wù Galalee le, wu yɛŋ bamii bamu le bafɛɛ, nyu muh bɛ mwa bwee. Bamii banɛ gɛ̀ bee Samoŋ wù ba gɛ̀ tɛŋe lɛ Bita, bɛ mwa bwee wù Andulu, bo nooŋ gii a mamasi le, no lɛme chiboo gɛ̀ bee bíɛŋ yi kolɛ. ");
INSERT INTO ncr_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jiso jɛmɛ bo le lɛ, “Bɛŋ bîi mɛne nlé nfɛ̂ bɛŋ bɛŋ koode wa nyume bamii!” ");
INSERT INTO ncr_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kimimia bo mo bo chinɛ gii yiboo le bo bii wu le. ");
INSERT INTO ncr_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jiso gɛ̀ doo wu ja fo wu kɛŋsɛ, wu ka wu yɛŋ bamii bamu le bafɛɛ nyu gɛh muh bɛ mwa bwee. Bamii banɛ gɛ̀ bee Jɛm bɛ mwa bwee wù Joŋ ba gɛ̀ bee booŋ ba Jɛbɛdi, bo nyu a ŋguh le bɛ chiji bo wù Jɛbɛdi bo chvuushi gii. Wu tɛɛŋ tɛ bo. ");
INSERT INTO ncr_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kimimia bo mo bo chinɛ ŋguh le bɛ chiji bo, bo bii wu le. ");
INSERT INTO ncr_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jiso gɛ̀ ja wu jiɛnyi kimbe kì Galalee le kichii wu yɛyi bamii yéh yi buunɛ yiboo le wu feeji tɛ saaka wù joŋe kune bvunfoŋ bvu Nyo. Wu ka fɛde binchɛŋ bichii mo goŋ yichii yi bamii le. ");
INSERT INTO ncr_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Noo, saaka kune wu saaŋe wu gɛɛŋ woŋ wù Silia le wuchii. Bamii mo bo too bɛ bamii bachii ba gɛ̀ chɛne mo ba gɛ̀ bee yi manluŋ le fɛ wu le, kɛnɛ le ba banchɛndaa ba debele njiŋse bɛ bo, kɛnɛ bo gwee kika, kɛnɛ ba kwe wa kimbe kimimia. Bo too bɛ bo noo wu fɛde bo bachii. ");
INSERT INTO ncr_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mo faaŋ fɛ wu gɛ̀ gɛɛne fo binchvu bi bamii bì baaŋ bi kfuune bi bii a wu jiŋ. Bamii banɛ gɛ̀ jade kimbe ki woŋ kì Galalee le, bamu jade a Bilaantɛŋ bi Yuufe le, bamu Yɛlusalɛm mo bantɛ ba Judia ba bamu le. Bamu jade a Joo yì Jodaŋ le wuŋ kwege. ");
INSERT INTO ncr_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jiso gɛ̀ doo wu yɛŋ kinchvu ki bamii le noo, wu mo wu ja wu bɛɛŋ wu gɛɛŋ wu shii yi mbegɛ le, booŋ be ba ŋgoo banyɛ bo to mbebe ye le. ");
INSERT INTO ncr_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Wu mo wu kɛ wu yɛyi bo wu duu lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Kinlaŋye kì baaŋ le fɛ bamii ba kee lɛ bo fuude yi kimbe ki Nyo le, nje bvunfoŋ bvù fɛwe le bvuboo. ");
INSERT INTO ncr_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kinlaŋye kì baaŋ le fɛ bamii ba beede le, nje Nyo lé wu gê wu chiisɛ bo. ");
INSERT INTO ncr_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kinlaŋye kì baaŋ le fɛ bamii ba jode bikwɛɛ biboo fɛkuu, nje bo lé bo gê bo ji kikwɛɛ ki nshɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kinlaŋye kì baaŋ le fɛ bamii ba jɛŋ yuu bo le, kindoŋ yune bo kune kinche ki chaaŋ, nje Nyo lé wu gê bo fuu. ");
INSERT INTO ncr_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kinlaŋye kì baaŋ le fɛ bamii ba koode yii fɛ bamu le, nje Nyo lé wu gê wu koo tɛ yii fɛ bo le. ");
INSERT INTO ncr_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kinlaŋye kì baaŋ le fɛ bamii ba kɛme muntele mu yuude le, nje ba lé ba tɛ̂ŋe bo lɛ booŋ ba Nyo. ");
INSERT INTO ncr_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kinlaŋye kì baaŋ le fɛ bamii ba too bɛ nyiɛgee le nje Nyo lé wu tɛ̂ŋe bo lɛ booŋ be. ");
INSERT INTO ncr_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kinlaŋye kì baaŋ le fɛ bamii ba bo boone bikaa a bo jiŋ nje bo chee kinche ki chaaŋ, nje bvunfoŋ bvù fɛwe le bvuboo. ");
INSERT INTO ncr_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kinlaŋye kì baaŋ le kena, sege bamii naanyi bɛŋ, bo boone bikaa a bɛŋ jiŋ, bo jɛme kfuu chi mwɛɛ mù mbefe munchii kune bɛŋ yi achiji le, nje bɛŋ le bamii baŋ. ");
INSERT INTO ncr_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Fi doo fi kooshi noo bɛŋ mo bɛŋ lâŋeye, nje maajɛ wene wu kuge le woŋ wù fɛwe le. Bɛŋ kêe lɛ, le gɛh noo no bamii gɛ̀ boone bikaa ajiŋ a bamii ba ntuŋ wu Nyo ba gɛ̀ to fwe a bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Le bɛŋ ba le ŋka yi yi nshɛŋ yinɛ le. Geenɛ ŋka ja lo yi chii, ba ka ba ge nɛɛ bɛ yi fɛ yi ka yi kaasɛ yi jɛŋɛ? Gɛ taŋlo ba ka ba ge fiɛɛ fì joŋe bɛ yi gɛ fede lɛ ba noŋ lo bamii fede bo jiɛnyi bɛ bikaa. ");
INSERT INTO ncr_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Le bɛŋ tɛ ba le n'yuu wu yi woŋ kfunɛ le. Gɛ kilaantɛŋ kì ba jonɛ yi mbegɛ le, to ki nyiile gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Gɛ muh to wu chu tɛ kin'yesɛ wu ka wu jo ŋkaa wu kfuusɛ yu gɛ. Wu to wu tome nyume yi fiɛɛ fì ba toome kin'yesɛ fo, ki mo ki yɛ̂ne muh wuchii wù le yeh le. ");
INSERT INTO ncr_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Le gɛh tɛ yɛɛŋyɛɛŋ no n'yuu wene kɛme ki wu bâaŋ a bamii jii, lɛ bo yɛde lɛme chena chì joŋe le bo nyaa mbɛɛŋsɛ Chiji wene wù le fɛwe le. ");
INSERT INTO ncr_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Keefɛ bɛŋ kwâji lɛ nto ki nchîijɛ mwɛɛ mù le a Ŋwa wu banchi ba Musɛ le gɛ, mo mù le a Baŋwa bamii ba ntuŋ wu Nyo le gɛ. Nto ki ŋge mu kojɛ lo. Gɛ nto ki nchiijɛ lo gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nsɛŋe bɛŋ nchiɛɛŋ lɛ gɛɛŋ bu no kibvulɛ bɛ nshɛŋ lé ki tô ki ka, gɛ fijise fi ŋwa a Ŋwa wu banchi le mo fi shige nɛɛ, nyume fi yu fi fe kuu njɛ fi kojɛ no fi chuunyi sɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Fi mo fi nyu lɛ nɛ le yɛɛŋ wù bwɛɛdɛ nchi wumu a banchi banɛ le, wuwɛɛ nchi mo nyu wù shige nɛɛ lɛ, wu tu wu yɛyi bamii lɛ bo bwɛ̂ɛyi tɛ noo, tu mwɛdɛ lé wu gê wù nyu muh wù shige antɛnɛɛ a bvunfoŋ bvù fɛwe. Geenɛ muh wù gɛɛde banchi banɛ, wu ka yɛyi tɛ bamii lɛ bo gɛ̂ɛde, tu mwɛdɛ lé wu gê wù nyu muh wù baaŋ antɛnɛɛ a bvunfoŋ bvù fɛwe. ");
INSERT INTO ncr_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Noo, nsɛŋe bɛŋ le lɛ, nɛ gee chena chì chaaŋ fede gɛ chi bamii ba duunyi banchi ba Nyo gɛ, mo chi Bafalashii lɛ, bɛŋ gɛ yu bɛŋ lee fɛ bvunfoŋ bvù fɛwe le gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Bɛŋ gɛ̀ yu wa ba duu bamii ba fweele le lɛ, ‘Keefɛ wo yûuyɛ muh gɛ! Nɛ muh yuuyi lo muh, tu wù kɛme nsa.’ ");
INSERT INTO ncr_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Geenɛ njɛme bɛŋ le lɛ muh wuchii wù toonyi shɛ́ŋ bɛ mwa bwee, lé wù kɛ̂me tɛ nsa. Muh naŋ mwa bwee, wu kêe lɛ wu lé wu gê wu lɛɛŋ fwe a bamii ba sage bansa. Muh tɛŋe mwa bwee lɛ, ‘Kiyuŋ’ wu kee lɛ wu lé wu lêe ŋgu wù baaŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Fi mo fi nyu lɛ, wo nɛ lɛme ki wo nyâ nnya yo fɛ kitana ki kintanyɛ le, wo kwajɛ lɛ mwa bwoo kɛme wo fɛ shɛŋ, ");
INSERT INTO ncr_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","wo chinɛ nya yo le mbebe kitana ki kintanyɛ le, wo gɛɛŋ bena wu ya bɛŋ tu jwe wu mumwaa, fɛ wo kaasɛ wo to wo nya nnya yo. ");
INSERT INTO ncr_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Muh nɛ jo lo wo wu gɛɛne bɛ wo yeh yi nsa le, wo moŋ bena wu yaŋsɛ bɛŋ seesɛ baaŋ a je, fɛ wu nya wo chiaaŋ yi muh wù sage bansa le, wu feese wo chiaaŋ yi nchi le ba faa wo yeh yi ncha le. ");
INSERT INTO ncr_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nsɛŋe wo nchiɛɛŋ lɛ gɛ taŋlo wo bu yu njɛ wo mɛsɛ wo laŋɛ finini fichii fì ba goone sɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Bɛŋ gɛ̀ yu wa ba duu lɛ, ‘Keefɛ wo jâŋ kwɛ muh gɛ!’ ");
INSERT INTO ncr_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Geenɛ njɛme bɛŋ le lɛ, muh wuchii wù jiiŋe kwɛse wù kɛme ŋkwajɛ wu kinjaŋ fɛ wu le, tu wu le wu jaŋ wa wu fɛ fitele le. ");
INSERT INTO ncr_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nɛ jise chuŋ chì nchiɛɛŋ gee wo gee kimbefɛ, wo bvusɛ jise chiyu wo noŋ. Fi joŋe lɛ wo lɛsɛ kimbe kuŋ ki ye kimimia, fede fɛ ba ge ba noŋ ye yo yichii ŋgu wù baaŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kibo kuŋ kinchiɛɛŋ nɛ gee tɛ wo gee kimbefɛ, wo suunɛ kibo kiyu wo noŋ. Fi joŋe lɛ wo lɛsɛ kimbe kuŋ ki ye kimimia, fede fɛ ye yo yichii gɛɛŋ ŋgu wù baaŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ba gɛ̀ jɛmɛ tɛ lɛ, ‘Nɛ muh kuŋ lo bɛ kwɛɛ, tu wù kɛme ki wu sâŋ ŋwa wu nya kwɛse wuyu le, wù duunyi lɛ gɛ wu baaŋ kwɛɛ gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Geenɛ njɛme bɛŋ le lɛ, muh kuŋ lo bɛ kwɛɛ, nyume gɛ lɛ kwɛse wuyu le wu ge kinjaŋ gɛ, tu wu le wu ge lɛ wu gɛɛŋ wu tu kwɛse wu kinjikuu. Muh jo kwɛse wù bu a jwɛŋsɛ yeh wu gɛɛ a wu yeh, tu wu le wu jo kwɛ muh. ");
INSERT INTO ncr_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Bɛŋ gɛ̀ yu wa tɛ no ba gɛ̀ jɛme bamii ba fweele le lɛ, ‘Sege wo jɛmɛ fiɛɛ wo kaŋ, keefɛ wo nyume njɛ wo ge fi sɛŋ gɛ. Wo kɛme ki wo gê fiɛɛ fì wo le wo jɛmɛ wo kaŋ a Tada fwe lɛ wo lé wo gê.’ ");
INSERT INTO ncr_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Geenɛ, njɛme bɛŋ le lɛ, keefɛ muh doo wu jɛme fiɛɛ wu kaŋ lo gɛ. Keefɛ wo kâŋ a jee chi fɛwe le gɛ, nje fɛwe le kala wu Nyo. ");
INSERT INTO ncr_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Keefɛ wo kâŋ nshɛŋ gɛ, nje nshɛŋ le kitege ki bikaa bi Nyo. Keefɛ wo kâŋ Yɛlusalɛm gɛ, nje Yɛlusalɛm le kilaantɛŋ ki Nfoŋ wù baaŋ. ");
INSERT INTO ncr_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Keefɛ wo kaŋ kikwɛɛ kuŋ gɛ, nje gɛ wo taŋlo wo fɛ yvu yimimia yi tu chibvuu kɛnɛ yi yiide gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Muh nɛ le wu bɛɛŋ fiɛɛ lɛ ‘Ɛɛŋ’, fi kojɛ noo. Wu tuŋ lɛ, ‘Aay’, fi kojɛ noo. Nɛ wu ka tale lo fiɛɛ fo, tu fiɛɛ fiyu ja fɛ muh wu kimbefɛ wɛɛ le. ");
INSERT INTO ncr_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Bɛŋ gɛ̀ yu wa tɛ lɛ ba gɛ̀ jɛmɛ lɛ, ‘Nɛ muh bvuse jise chi muh, ba bvusɛ tɛ che. Muh baa kige ki muh, ba baa tɛ ke.’ ");
INSERT INTO ncr_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Geenɛ, njɛme bɛŋ le lɛ, keefɛ muh nyîide fiɛɛ bɛ muh wù befe gɛ. Nɛ muh le wu suŋ kinlaŋɛ kuŋ kinchiɛɛŋ, wo kaasɛ kiŋkoŋo wu mɛsɛ wu suŋ. ");
INSERT INTO ncr_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Muh some wo lɛ wu fi kikuŋ kuŋ kì antɛŋ, wo mɛsɛ wo nya mo kì akfuuŋ. ");
INSERT INTO ncr_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Muh kane wo lɛ wo jiɛnyɛ wo gɛɛŋ ma wu mumwaa, wo jiɛnyɛ wo bu mo bama bafɛɛ bena wu. ");
INSERT INTO ncr_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Muh lɛgɛ fiɛɛ a wo le, wo nya wu yu. Muh foo fiɛɛ a wo le, keefɛ wo fâŋ ki wo nyâ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Bɛŋ gɛ̀ yu wa lɛ ba gɛ̀ jɛmɛ lɛ, ‘Wo kôŋe muh wù le mbebe yo le wo bâne muh wo wu kimbanɛ.’ ");
INSERT INTO ncr_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Geenɛ, ntu njɛme bɛŋ le lɛ, bɛŋ kôŋe bamii bena ba kimbanɛ, bɛŋ bûune fɛ ba boone bikaa a bɛŋ jiŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Noo, bɛŋ mo bɛŋ nyu booŋ ba Chiji wene wù le fɛwe. Le wu wù gee juu saane fɛ bamii ba befe le mo fɛ ba joŋe le. Wu gee tɛ jaŋ too fɛ bamii ba gee mwɛɛ mù chaaŋ le, mo fɛ bamii ba befe le. ");
INSERT INTO ncr_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Bɛŋ kwaji lɛ bɛŋ nɛ koŋe gɛh nyu bamii ba koŋe bɛŋ, maajɛ wuyu nyume la fɛ bɛŋ le? Gɛ bamii ba koode ŋwa gee tɛ noo gɛ? ");
INSERT INTO ncr_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Bɛŋ nɛ yɛɛse gɛh nyu booŋ ba bwee bena le, tu fiɛɛ fì bɛŋ gee fì bamii bamu gee gɛ le la? Gɛ bamii ba befe gee gɛh yɛɛŋyɛɛŋ no bɛŋ gee gɛ? ");
INSERT INTO ncr_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Fi mo fi nyu lɛ bɛŋ kɛme ki bɛŋ jôŋe bɛŋ gɛɛne bɛŋ mɛɛse no Chiji wene wu fɛwe joŋe wu gɛɛne wu mɛɛse.” ");
INSERT INTO ncr_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Bɛŋ yɛ̂ne lɛ keefɛ bɛŋ doo bɛŋ gee mwɛɛ mù njoŋe, bɛŋ gêe a bamii fwe ki bo yɛ̂ne gɛ. Nɛ bɛŋ gee noo, chiji wene wù le fɛwe gɛ ka wu mâajɛ bɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Noo, sege wo nyaa fiɛɛ muh wù fuude le, keefɛ wo mo wo tôŋe soŋ njɛ bamii ba jɛme yeye bo gee yeye to bo gee yéh yi buunɛ le mo jé le, lɛ bamii shânɛ bo gɛ. Nsɛŋe bɛŋ nchiɛɛŋ lɛ bo le bo kɛmɛ wa maajɛ wuboo. ");
INSERT INTO ncr_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Geenɛ, sege wo nyaa fiɛɛ muh wù fuude le, keefɛ wo gê kibo kuŋ kiŋkoŋo kɛɛ fiɛɛ fì kinchiɛɛŋ gee gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Noo, nnya yo nyû nyilɛ le, Chijo wù yɛde mwɛɛ mu ba gee nyilɛ le, lé wu gê wu maajɛ wo. ");
INSERT INTO ncr_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Sege bɛŋ buune, keefɛ bɛŋ gêe njɛ no bamii ba jɛme yeye bo gee yeye to bo gee gɛ. Bo to bo koŋe ki bo lɛme yéh yi buunɛ le, mo ntasɛ yi jé le bo buune, lɛ bamii yɛ̂ne bo le. Nsɛŋe bɛŋ nchiɛɛŋ lɛ bo le bo kɛmɛ wa maajɛ wuboo. ");
INSERT INTO ncr_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Geenɛ sege wo goone ki wo bûunɛ, wo lee wo gɛɛŋ yeh, wo faa kimbuŋ fɛ wo buune fɛ Chijo wù le nyilɛ le. Chijo wù yɛde mwɛɛ mù ba gee nyilɛ le, lé wu mâajɛ wo. ");
INSERT INTO ncr_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Bɛŋ doo bɛŋ buune, keefɛ bɛŋ shê bɛŋ laane njɛ no bamii ba maa Nyo to bo gee gɛ. Bo gee noo bo kwaji lɛ ba le ba yu buunɛ chiboo nje jɛ́ yì bo jɛme wesee. ");
INSERT INTO ncr_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Keefɛ bɛŋ nyûme njɛ no bo le gɛ. Bɛŋ kêe lɛ Chiji wene kee wa fiɛɛ fì bɛŋ goone fɛ bɛŋ biide. ");
INSERT INTO ncr_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Le nɛ no taŋlo bɛŋ bûune: ‘Chiji wese wù le fɛwe, gêe lɛ bamii ŋgvûune jee chuŋ, ");
INSERT INTO ncr_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","wo gê lɛ bvunfoŋ bwuŋ to, wo gê fiɛɛ fì wo goone fɛkuu fɛnɛ fi nyûme no fi le fɛwe. ");
INSERT INTO ncr_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nya bee bɛ mwɛɛ munjile mu abɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Lɛɛshɛ bimbefɛ biɛsa, no bee tɛ lɛɛshi bimbefɛ bì bamii bamu gee fɛ bee le. ");
INSERT INTO ncr_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Keefɛ wo chînɛ bee lee moŋ wù ya bee le gɛ. Fi bee chiaaŋ yi muh wu kimbefɛ wɛɛ le.’Bvunfoŋ le bwuŋ, bvuŋga nyu bwuŋ, bvukugɛ nyu bwuŋ segechii bvu kage gɛ. Fi nyûme noo. ");
INSERT INTO ncr_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Bɛŋ kêe lɛ nɛ bɛŋ lɛɛshi bimbefɛ bi bamii bamu gee fɛ bɛŋ le, Chiji wene wù le fɛwe lɛɛshɛ tɛ biɛna. ");
INSERT INTO ncr_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Geenɛ, nɛ bɛŋ le njɛ bɛŋ lɛɛshi bimbefɛ bì bamii bamu gee fɛ bɛŋ le sɛŋ, Chiji wene gɛ lɛɛshɛ tɛ biɛna gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Sege bɛŋ bane mwɛɛ munjile, keefɛ bɛŋ jîiŋe nɛ yulaa njɛ no bamii ba chiaase ye gee gɛ. Bo kusɛ manshi maboo lɛ segeyu, wu lɛ bamii yɛ̂ne lɛ bo banɛ mwɛɛ munjile. Nsɛŋe bɛŋ nchiɛɛŋ lɛ bo le bo kɛmɛ wa maajɛ wuboo. ");
INSERT INTO ncr_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Geenɛ, sege wo banɛ mwɛɛ munjile, wo yefɛ kikwɛɛ kuŋ, wo chugɛ bvushi bwuŋ, ");
INSERT INTO ncr_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","wu lɛ keefɛ bamii yɛ̂ne lɛ wo banɛ mwɛɛ munjile gɛ, le yɛde gɛh Chijo wù le nyilɛ le. Le Chijo wù yɛde mwɛɛ mù bamii gee nyilɛ le wu lé wu gê wu mâajɛ wo. ");
INSERT INTO ncr_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Keefɛ bɛŋ gɛ̂ɛde nchvu yene fɛkuu fɛnɛ fɛ taŋlo shé kaaŋ, taŋlo tɛ ŋga koo, bachoŋ taŋlo bo ŋgode bo lee bo choŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Bɛŋ gɛ̂ɛde nchvu yene nyu yi woŋ wù Nyo le, fɛ taŋlo shé gɛ kaaŋ gɛ, taŋlo tɛ ŋga gɛ koo gɛ, bachoŋ taŋlo tɛ bo gɛ ŋgode bo lee bo choŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Bɛŋ kêe lɛ fɛ muh gɛɛde nchvu ye fo le fɛ fitele fie le fo. ");
INSERT INTO ncr_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ajii a muh le kin'yesɛ yi ye ye le. Noo, ajii a wo nɛ yuude lo, tu ye yo yichii le yi yisɛ bɛ n'yuu. ");
INSERT INTO ncr_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Geenɛ, ajii a wo nɛ jime lo, tu ye yo yichii le yi yisɛ bɛ kijibɛ. Nɛ n'yuu wu muh le wu ja wu tu kijibɛ, kijibɛ kiyu jime wa nɛɛ? ");
INSERT INTO ncr_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Gɛ nfwa taŋlo wu lɛ̂ne bachiji kikwɛɛ le bafɛɛ gɛ. Wu nɛ lɛne noo, wu bânɛ wumu, wu koŋe wumu, kɛnɛ wu yuge wumu le chuule wu jode wumu fɛkuu. Gɛ taŋlo bɛŋ lɛ̂ne Nyo le bɛŋ ka lɛne bige le gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Noo, njɛme bɛŋ le lɛ keefɛ bɛŋ lûume kune kinche kena le laa bɛŋ lé bɛŋ jî la lɛ, kɛnɛ bɛŋ mu la lɛ, kɛnɛ kune ye yene laa bɛŋ lé bɛŋ gê bɛŋ jii la lɛ. Gɛ kiyo ki muh fede mwɛɛ munjile gɛ? Gɛ ye yi muh fede tɛ njú gɛ? ");
INSERT INTO ncr_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Bɛŋ jîŋɛ bɛŋ yɛ̂ŋ no munyii mù fuune we le. Gɛ mu to mu boone gɛ, kɛnɛ mu gweji ŋgu mu banyi mu gɛɛde a basaŋkwa le gɛ. Geenɛ, Chiji wene wù le fɛwe nyaŋe gɛh mu. Gɛ bɛŋ yage munyii gɛ? ");
INSERT INTO ncr_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Le yɛɛŋ a bɛŋ ntɛnɛɛ wù fuuŋse, wù taŋlo wu bisɛ gɛh kife shige yi kinche ke le? ");
INSERT INTO ncr_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Bɛŋ luume kune njú nje la? Bɛŋ jîŋɛ bɛŋ yɛ̂ŋ no nfudɛ kuu kwa wù nyu. Gɛ nfudɛ to wu lɛne gɛ kɛnɛ wu shiŋe njú gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Geenɛ, nsɛŋe bɛŋ le lɛ gɛh Nfoŋ Salamoŋ bɛ bvukugɛ bvuchii bvù wu gɛ̀ kɛme gɛ̀ susɛ ye wu bu fɛ nfudɛ wumu le gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nyo nɛ suse agaaŋ a nchvuuŋ nɛ, agaaŋ a kuu abɛŋ, bu antaana ba fwɛɛ lo fɛtaŋ, tu gɛ taŋlo wu susɛ bɛŋ wu fe lo noo gɛ? O oo bamii ba mbɛmɛ wù shige! ");
INSERT INTO ncr_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Noo, keefɛ fi fûuŋse bɛŋ, bɛŋ dûu laa bɛŋ lé bɛŋ gê bɛŋ ji la lɛ, bɛŋ mu la lɛ, kɛnɛ lɛ bɛŋ jii la ye le lɛ. ");
INSERT INTO ncr_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mwɛɛ munɛ munchii le mù bamii ba kee gɛ Nyo gɛ to bo gɛɛde bvufee yi mu le. Bɛŋ le fiena Chiji wene wù le fɛwe kee lɛ bɛŋ goone mwɛɛ munɛ munchii. ");
INSERT INTO ncr_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Bɛŋ ya bɛŋ gɛ̂ɛ bvufee bwena nyu yi bvunfoŋ bvu Nyo le bɛ yi fiɛɛ fì le chaaŋ a wu jii le, wu mo wu nyaa tɛ mwɛɛ munɛ munchii bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Fi mo fi nyu lɛ, keefɛ bɛŋ wɛ̂se kune fɛwɛge gɛ. Ba lé ba bû ba wɛse yi fiɛɛ fì fɛwɛge le, nyu fɛwɛge. Ŋgɛ wu yi juu le kooji gɛh yi juu chiyu chiɛɛ le.” ");
INSERT INTO ncr_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Keefɛ bɛŋ sâge gee chi bamii bamu gɛ, noo, Nyo gɛ sa tɛ chena gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Bɛŋ kêe lɛ je yì bɛŋ sage gee chi muh mu lɛ yu, le gɛh yi yì Nyo lé wu gê wu sa tɛ chena yu. Fiɛɛ fì muh fege fiɛɛ yo fɛ wu nya muh le, le gɛh fi fì Nyo lé wu gê wu fe yo fɛ wu nya mwɛdɛ le. ");
INSERT INTO ncr_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Le nje la fì wo jiiŋe nyu sese chì le a mwa bwoo jii, geenɛ wo yɛde gɛ kikesɛ kì le a chuŋ jise le gɛ? ");
INSERT INTO ncr_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Taŋlo wo ge nɛɛ fɛ wo du mwa bwoo le lɛ, ‘Gɛh lɛ̂ɛŋ mbvusɛ sese chi a wo jii’, geenɛ wo yɛde gɛ kikesɛ kì le a chuŋ jise le gɛ? ");
INSERT INTO ncr_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wo le muh wù chiaase ye! Ya bvusɛ kikesɛ kì le a chuŋ jise le fɛ wo yɛŋ sese chì le a jise chi mwa bwoo le chuule, wo mo wo bvûsɛ. ");
INSERT INTO ncr_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Keefɛ bɛŋ jô fiɛɛ fì Nyo bɛŋ nyâ bvú le gɛ. Nɛ bɛŋ ge noo, yi kaasɛ ye yi lumɛ lo bɛŋ. Keefɛ bɛŋ jô tɛ mbele bɛŋ nya munyuŋa le gɛ. Nɛ bɛŋ ge lo noo, mu jiɛnyɛ lo bɛ bikaa. ");
INSERT INTO ncr_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Bɛŋ bîide, Nyo lé wu nyâ bɛŋ le. Bɛŋ ŋgôone, Nyo lé wu gê bɛŋ yɛŋ. Bɛŋ kûne kimbuŋ, Nyo lé wu gwênyɛ bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Bɛŋ kêe lɛ muh wuchii wù biide, wu lé wu kɛ̂mɛ, muh wuchii wù goone, lé wu gê wu yɛŋ, muh wuchii wù kune kimbuŋ lé ba nyû ba gwenyɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Le yɛɛŋ a bɛŋ ntɛnɛɛ wù mwa ye biide bvulɛɛŋ, wu nyâ wu nyu tɛdɛ? ");
INSERT INTO ncr_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kɛnɛ wu biide biɛŋ, wu nya wu nyu yo? ");
INSERT INTO ncr_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nɛ bɛŋ bamii ba befe bɛŋ kee ki bɛŋ nyâ mwɛɛ mù njoŋe booŋ bena le, tu gɛ Chiji wene wù le fɛwe taŋlo wu nya mwɛɛ mù njoŋe bamii ba biide wu le fede noo gɛ? ");
INSERT INTO ncr_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Fi mo fi nyume lɛ, nɛ le la fì bɛŋ goone lɛ bamii gêe fɛ bɛŋ le, nyume fi, fì bɛŋ gêe tɛ fɛ bo le, nje finɛ fiɛɛ le fiɛɛ fichii fì Ŋwa wu banchi ba Musɛ mo Baŋwa ba bamii ba ntuŋ ba Nyo yɛyi. ");
INSERT INTO ncr_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Bɛŋ lêe a kitaŋ le nyu fɛ jwe wù fasaa le, nje jwe wù buuu bɛ je yì chige gɛɛne nyu fɛ ba lé ba lɛ̂ɛshɛ lo nlɛɛshɛ le, bamii leese fɛ wu kwɛɛ le wesee. ");
INSERT INTO ncr_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Bɛŋ kêe lɛ jwe wu kitaŋ wù fasaa, bɛ je yì tɛɛme gɛɛne nyu fɛ kinche kì kage gɛ le. Bamii ba yɛde yi le bo le shige. ");
INSERT INTO ncr_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Bɛŋ jôde kife bɛ bamii ba mbiane lɛ bo le bamii ba ntuŋ ba Nyo. Bo too fɛ bɛŋ le bo duunyi lɛ bo le shóŋ, geenɛ antɛŋ nyu bakfuula bo taŋlo bo yɛɛsɛ lo shóŋ. ");
INSERT INTO ncr_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Bɛŋ lé bɛŋ gê bɛŋ kɛɛ bo nyu yi gee chiboo le, gɛh yɛɛŋyɛɛŋ no ba to ba kee kite yi muntaŋ mù yune yi ki le. Taŋlo ba ke muntaŋ mu glɛb yi bifafɛ le, kɛnɛ ba ke muntaŋ mu fig yi kite ki mbíaŋ le? ");
INSERT INTO ncr_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Fi nyu lɛ kite kì joŋe kichii to ki yune gɛh nyu muntaŋ mù njoŋe, kite kì befe yune gɛh nyu muntaŋ mù mbefe. ");
INSERT INTO ncr_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Gɛ kite kì joŋe taŋlo ki yuŋ muntaŋ mù mbefe gɛ. Gɛ taŋlo tɛ kite kì befe yuŋ muntaŋ mù njoŋe gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kite kichii kì yune gɛ muntaŋ mù njoŋe gɛ le ba nyu ba gwo ba toŋ lo. ");
INSERT INTO ncr_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Noo, bɛŋ lé bɛŋ kɛ̂ɛ bamii ba chimbiaŋ bayu nyu yi gee chiboo le. ");
INSERT INTO ncr_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Gɛ nyu muh wuchii wu tɛŋe mɛ lɛ, ‘Tada, Tada’, nyu wu lee fɛ bvunfoŋ bvù fɛwe le gɛ. Lé lêe gɛh muh wù gee fiɛɛ fì Chii wù le fɛwe goone. ");
INSERT INTO ncr_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Lé tô nyu abvu bvu nsa wu fɛkimɛsɛ, bamii ba duude biide mɛne lɛ, ‘Tada, Tada, bee gɛ̀ teede gɛ̀ bantuŋ ba Nyo a jee chuŋ le, bee gɛ̀ bvuuse banchɛndaa ba debele yi bamii le a jee chuŋ le, bee ka gee biŋgha bi mwɛɛ a jee chuŋ le?’ ");
INSERT INTO ncr_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mɛ mo ndu bo le lɛ, ‘Gɛ ŋkee bɛŋ gɛ. Bɛŋ ja lo a mɛ jii bamii ba gɛɛde nchi fɛkuu.’ ");
INSERT INTO ncr_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Noo, muh wuchii wù too wu yuge n'yɛyɛ waŋ, wu mo wu gee gɛh no wu duu, wu le gɛh njɛ muh wu bvufee wù gɛ̀ jonɛ yeh ye yi kimbaaŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Jaŋ gwe, jóo yisɛ yi bu, fii fe yi chi yeh yiyu, geenɛ yi gɛ gwe gɛ, nje wu gɛ̀ jooŋ kichi kiyu yi kimbaaŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Geenɛ, muh wù yuge n'yɛyɛ waŋ wù gee gɛ no wu jɛme gɛ, le njɛ kiyuŋ ki muh wù gɛ̀ jonɛ ye yeh nyu yi munshɛɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Jaŋ gwe, jóo yisɛ yi bu, fii fe yi chi yeh yiyu, yi kesɛ, yi shii fɛkuu yichii nɛ wuuu.” ");
INSERT INTO ncr_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jiso gɛ̀ jɛmɛ mwɛɛ munɛ munchii wu mɛsɛ, kinchvu ki bamii kiyu kɛmɛ lo kiŋgha yi n'yɛyɛ we le, ");
INSERT INTO ncr_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","nje wu gɛ̀ yɛyi njɛ muh wù kɛmɛ bvuŋga bvu n'yɛyɛ. Gɛ wu gɛ̀ yɛyi njɛ no bamii baboo ba duunyi banchi ba Nyo gɛ̀ to bo yɛyi gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Sege Jiso gɛ̀ ja yi mbegɛ le wu boh, kinchvu ki bamii kì baaŋ banyɛ ki bii wu le. ");
INSERT INTO ncr_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Fi kooshɛ lɛ muh wumu wù gɛ̀ chɛne bɛ goŋ yì baaŋ, gɛ̀ ja wu to wu tuŋ anyuu a Jiso fwe wu jɛmɛ wu le lɛ, “Tada, taŋlo wo fɛ mɛ n'yuude, fɛ wo nɛ koŋe lo.” ");
INSERT INTO ncr_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jiso mo wu nɛjɛ kibo wu kuŋ wu le wu jɛmɛ lɛ, “Ŋkoŋe lo, tɛ̂mɛ la wo yûude.” Kimimia, goŋ yì baaŋ yiyu mo yi ka ye ye le, wu mo wu tu wu yuude. ");
INSERT INTO ncr_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jiso chiisɛ wu le lɛ, “Wo yɛ̂ne, keefɛ wo sɛ̂ɛŋ muh le gɛ. Geenɛ, gɛnɛ wo chûnyɛ kikwɛɛ kuŋ chiji kintanyɛ le, wo mo wo nya nnyaa yì Musɛ gɛ̀ jɛmɛ lɛ muh kɛmɛ ki wu nyâ ki wu chûnyɛ bamii le lɛ wu le wu tɛmɛ wa yi goŋ yinɛ le wu tu wu yûude.” ");
INSERT INTO ncr_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jiso gɛ̀ ja wu gɛɛŋ wu lee a kilaantɛŋ kì Kafanahum le, kikwɛɛ ki bamii ba nchi kimi gɛ̀ to ki yɛŋ wu le ki ku chiaaŋ wu le ki du lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Tada, mwa yaŋ wu lɛme gime yeh wu ŋgɛɛse lo, wu le wu kwe wa kimbe kimimia.” ");
INSERT INTO ncr_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jiso jɛmɛ wu le lɛ, “Nlé ntô nfɛ̂ wu?” ");
INSERT INTO ncr_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Geenɛ, kikwɛɛ ki bamii ba nchi kɛɛ chvuu Jiso le lɛ, “Tada, gɛ ŋkooji muh wù taŋlo wo to a wu yeh gɛ. Jɛmɛ gɛh nyu jɛ mwa yaŋ wu lɛme mo wu tɛmɛ. ");
INSERT INTO ncr_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nle a bvuŋga bvu muh mu kuu, bamii ba nchi nyu tɛ a mɛ kuu. Njɛme muh le lɛ, ‘Gɛ̂nɛ’, wu mo wu gɛɛne lo, ndu muh le lɛ, ‘Tô’, wu mo wu too lo. Ndu tɛ nfwa waŋ le lɛ, ‘Gêe nɛ’, wu mo wu gee lo.” ");
INSERT INTO ncr_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jiso doo wu yu fiɛɛ fì wu jɛme, jwe yuŋ lo wu. Wu jɛmɛ bamii ba gɛ̀ bii wu le lɛ, “Nsɛŋe bɛŋ nchiɛɛŋ lɛ, ŋge mbaaŋ a n'yɛŋ gɛ muh le Ishwala wù lese kfuu chi finɛ fitele yi ye yaŋ le nɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nsɛŋe bɛŋ le lɛ bamii wesee le bo ja bimbe le bichii, kɛge a juu saane yo gɛɛne bude a chi seele yo, bo to bo shii bo jii mwɛɛ bɛ bachiji bena wù Ablaham mo Asik mo Yakob woŋ wu Nyo wu fɛwe le, ");
INSERT INTO ncr_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","geenɛ, booŋ ba woŋ wuyu le wuboo le ba noŋ bo yi kijibɛ le akfuuŋ fɛ bamii lé bo gê bo beede bo ŋgeji bige.” ");
INSERT INTO ncr_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","No Jiso jɛmɛ noo wu mo wu du kikwɛɛ ki bamii ba nchi kɛɛ le lɛ, “Wo gɛɛne la, fi lé fi gê noo no wo le wo leesɛ fitele ye yaŋ le.” Mwa lɛme wu kikwɛɛ ki bamii ba nchi wuyu mo wu tɛmɛ lo gɛh ki sege. ");
INSERT INTO ncr_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jiso gɛ̀ ja wu gɛɛŋ wu lee a Bita yeh, wu yɛŋ mwɛɛdɛ Bita gime wu chɛne bɛ kin'ya. ");
INSERT INTO ncr_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jiso kuŋ kibo ke le, kin'ya kiyu mo ki chinɛ wu le, wu mo wu ja we wu bijɛ fiɛɛ Jiso ji. ");
INSERT INTO ncr_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Lɛ nyu fɛnfu, bamii tu bo too bɛ bamii wesee ba banchɛndaa ba debele gɛ̀ njiiŋse bɛ bo. Jiso tu wu bvuuse biyo biyu nyu gɛh bɛ jɛ maa. Wu ka fɛde tɛ bamii bachii ba gɛ̀ chɛne. ");
INSERT INTO ncr_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Finɛ fiɛɛ gɛ̀ kooshi ki fi gê fi kojɛ no muh wu ntuŋ wu Nyo wù Yosaya gɛ̀ jɛmɛ wa lɛ, “Wu le wu jo wa goŋ yese besabɛŋ, wu tuu binchɛŋ biɛsa.” ");
INSERT INTO ncr_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jiso gɛ̀ doo wu yɛŋ kinchvu ki bamii kì baaŋ taashɛ mbebe ye le, wu jɛmɛ booŋ be ba ŋgoo le lɛ, “Bee daŋ mamasi bee gɛɛŋ wuŋ kwege.” ");
INSERT INTO ncr_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Muh wumu wù gɛ̀ duunyi banchi ba Nyo mo wu kɛŋsɛ wu jɛmɛ Jiso le lɛ, “Muh n'yɛyɛ, nlé mbîi wo le mo nyu faaŋ fɛ wo gɛɛne fo.” ");
INSERT INTO ncr_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jiso chvuu wu le lɛ,“Binchombiaŋ kɛme bintuge biboo, munyii mù fuune we kɛme yéh yiboo, geenɛ gɛ muh wù jee che le Mwamuh kɛme lo fɛ wu giŋsɛ kikwɛɛ ke fo gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Muh we wu ŋgoo wumu jɛmɛ wu le lɛ, “Tada, chinɛ ŋgɛɛŋ njiiyɛ chijaŋ fɛ nto mbii.” ");
INSERT INTO ncr_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Geenɛ Jiso chvuu wu le lɛ, “Wo bîi mɛne, chinɛ bamii ba kweeyɛ wa bo jiiyi bamii baboo ba kweeyɛ wa.” ");
INSERT INTO ncr_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jiso gɛ̀ gɛɛŋ wu lee a ŋguh le, booŋ be ba ŋgoo bi tɛ wu le yo. ");
INSERT INTO ncr_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Fi kooshɛ lɛ nfuŋ wumu wù baaŋ ja gɛh wu jaŋɛ wu kɛ a mamasi wuyu le wu shiŋshi joo yi bɛɛne yi lese a ŋguh le, yi goone ki yi yîsɛ a ŋguh le. Gɛ̀ bee Jiso lefe lo fie. ");
INSERT INTO ncr_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Booŋ be ba ŋgoo gɛɛŋ bo kaŋsɛ wu bo du lɛ, “Tada, fi bee, bee lé be kwêeyɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Wu kaŋsɛ wu jɛmɛ bo le lɛ, “Ooo bamii ba mbɛmɛ wù shige. Bɛŋ faane la?” No wu jɛmɛ noo wu mo wu ja we wu waŋ nfuŋ wuyu mo joo yì baaŋ, mu lu, manjuu chii nɛ nshiiŋŋ. ");
INSERT INTO ncr_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jwe yuŋ bamii bayu nɛ kah. Bo ghaade lɛ, “Kfuu chi wunɛ muh le wu nɛɛ wù nfuŋ bɛ joo yuge wu le?” ");
INSERT INTO ncr_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jiso gɛ̀ daŋ wu bu wuŋ kwege kimbe ki bamii ba Gadala le. Bɛ bamii bafɛɛ tasɛ banchɛndaa ba debele nyu yi bo le. Bamii bayu gɛ̀ bu afuuŋ yì ba gɛ̀ jiiyi bamii yo le, bo gɛ̀ ŋase baaŋ taŋlo muh gɛ fe lo je yo gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Fi kooshɛ lɛ bo gɛ̀ kɛ bo tu bo wane fɛwɛɛwe bo biide lɛ, “Mwa Nyo, wo fii la a bee le? Wo to fɛnɛ ki wo nyâ ŋgɛ bee le kife baaŋ a kojɛ gɛ?” ");
INSERT INTO ncr_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Gɛ̀ bee ŋgoo yi munyuŋa jii kimbe kiyu le mu duude lo. ");
INSERT INTO ncr_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Banchɛndaa ba debele bayu mo bo lɛgɛ Jiso lɛ, “Kii wo, wo nɛ le wo bvusɛ bee, wo chiiŋsɛ bee yi munyuŋa mwege le.” ");
INSERT INTO ncr_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jiso mo wu jɛmɛ bo le lɛ, “Bɛŋ gɛ̂ɛŋ lo!” Bo mo bo bu, bo gɛɛŋ bo lee yi munyuŋa muyu le. Fi kooshɛ lɛ ŋgoo yi munyuŋa yiyu yichii gɛ̀ kɛŋ yi boh a kiŋkoŋ le, mu shii a mamasi le mu kweeyɛ yo. ");
INSERT INTO ncr_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bamii ba gɛ̀ chiɛɛne munyuŋa muyu fɛɛ lo, bo gɛɛŋ a kilaantɛŋ le, bo sɛɛŋ fiɛɛ fichii nchensɛŋ fì gɛ̀ kooshɛ bɛ bamii ba banchɛndaa ba debele gɛ̀ bee yi bo le. ");
INSERT INTO ncr_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Fi kooshɛ lɛ kilaantɛŋ kiyu kichii gɛ̀ bu lo ki to ki yɛŋ Jiso le. No bo gɛ̀ yɛŋ wu le, bo lɛgɛ lɛ wu ja gwɛŋ wuboo le. ");
INSERT INTO ncr_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jiso lee a ŋguh le, wu kaasɛ wu daŋ wu gɛɛŋ a kilaantɛŋ ke le. ");
INSERT INTO ncr_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Fi kooshɛ lɛ bamii bamu gɛ̀ too bɛ muh mu fɛ wu le a wu kwe wa kimbe kimimia, bo tuu a kidaŋ le. Jiso yɛŋ lɛ bamii bayu le bo leesɛ muntele muboo ye ye le, wu jɛmɛ muh wù gɛ̀ kwe kimbe kimimia wɛɛ le lɛ, “Nsaa yaŋ, jijɛ fitele le. Nle nlɛɛshɛ wa bimbefɛ biuŋ.” ");
INSERT INTO ncr_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Fi kooshɛ lɛ bamii bamu ba gɛ̀ duunyi banchi ba Nyo gɛ̀ kɛ bo tu bo shuŋshi lɛbolɛbo bo duu lɛ, “Muh wunɛ jode kijusɛ ki Nyo.” ");
INSERT INTO ncr_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jiso kɛɛ baŋkwajɛ baboo wu biih bo le lɛ, “Bɛŋ kɛme baŋkwajɛ ba befe a muntele mwɛna le nɛ nje la? ");
INSERT INTO ncr_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Fi chige fì njɛmɛ le fì la? Ki njɛmɛ muh wunɛ le lɛ nle nlɛɛshɛ wa bimbefɛ bie noo, lɛ wu jâ we wu jîɛnyi le? ");
INSERT INTO ncr_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Geenɛ, nlé ŋgê bɛŋ kɛ̂ɛ lɛ muh wu jee che le Mwamuh kɛme bvuŋga fɛkuu fɛnɛ ki wu lɛ̂ɛshɛ bimbefɛ.” No wu jɛmɛ noo wu mo wu du muh wù gɛ̀ kwe kimbe kimimia wɛɛ le lɛ, “Ja we, wo jo bvuko bwuŋ wo gɛ̂ɛne fɛ yeh le.” ");
INSERT INTO ncr_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Wu mo wu ja we wu gɛɛne fɛ yeh le. ");
INSERT INTO ncr_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kinchvu ki bamii yɛŋ fiɛɛ fì kooshi le, nfaaŋ koo bo, bo tu bo tume maŋkuŋ ma Nyo wù le wu nya kfuu chi bvunɛ bvuŋga muh wu wuŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jiso gɛ̀ ja fo wu doo wu jiɛnyi wu gɛɛne wu yɛŋ muh mu le ba tɛŋe lɛ Macho, nyu muh wù gɛ̀ koode ŋwa, wu shii fɛ kijusɛ ke ki lɛme le. Jiso jɛmɛ wu le lɛ, “Wo bîi mɛne!” Wu mo wu ja we wu bii wu le. ");
INSERT INTO ncr_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jiso gɛ̀ ja wu gɛɛŋ wu shii wu jii mwɛɛ a Macho yeh, fi kooshɛ lɛ bamii bamu wesee ba gɛ̀ koode ŋwa, mo bamii ba befe bamu tɛ gɛ̀ to bo shii bo jii mwɛɛ bɛ ba Jiso mo booŋ be ba ŋgoo. ");
INSERT INTO ncr_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bafalashii doo bo yɛŋ no bɛ bo jii mwɛɛ noo bo biih booŋ be ba ŋgoo le lɛ, “Le nje la wù muh wene wu n'yɛyɛ jii mwɛɛ bɛ bamii ba koode ŋwa mo bamii ba befe bamu?” ");
INSERT INTO ncr_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jiso yu no bo biide, wu jɛmɛ bo le lɛ, “Gɛ bamii ba tɛɛme to bo goone muh wu nche gɛ. To goone nyu bamii ba chɛne. ");
INSERT INTO ncr_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Bɛŋ gɛ̂ɛŋ bɛŋ kwâjɛ, bɛŋ yɛ̂ŋ laa kinyi ki fiɛɛ fì ba saŋ finɛ Nyo jɛme lɛ, ‘Ŋgoone lɛ bamii kôode nyu yii fɛ bamii le, gɛ ŋgoone lɛ bo gêe nyu kintanyɛ fɛ mɛne gɛ’, le lɛ la lɛ? Bɛŋ kêe lɛ gɛ nto ki ntɛɛŋ nyu bamii ba chaaŋ gɛ. Nto ki ntɛɛŋ nyume bamii ba befe.” ");
INSERT INTO ncr_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Booŋ ba ŋgoo ba Joŋ gɛ̀ ja bo to bo biih Jiso le lɛ, “Le nje la wù besa Bafalashii banɛ mwɛɛ munjile, buŋ booŋ ba ŋgoo banɛ gɛ?” ");
INSERT INTO ncr_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jiso chvuu bo le lɛ, “Bɛŋ kwaji lɛ taŋlo ba tɛɛŋ bamii ba bvuguu, bo gɛɛŋ bo nyu yii yii chiji bvuguu nyu bɛ bo? Geenɛ, aju too lo a ba lé ba fî chiji bvuguu wuyu a bo le, bo mo bo kɛ bo banɛ mwɛɛ munjile. ");
INSERT INTO ncr_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Gɛ muh taŋlo wu jo finchaŋa fi nju fifɛŋ, wu chvuushɛ nju yì kege yu gɛ. Nɛ wu ge lo noo, finchaŋa fi nju fiyu kfunyɛ fi saayɛ nju yì kege yiyu, kintuge kì le fo ki mɛsɛ ki kugɛ lo ki fe no ki chi shee ki nyume. ");
INSERT INTO ncr_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Gɛ taŋlo tɛ muh jo mbvuuŋ manfɛŋ wu gɛɛ a kolo wu mbvuuŋ wù kege le gɛ, wu ge lo noo, mbvuuŋ manfɛŋ maa ge mo koo, mo saayɛ lo kolo wù kege wɛɛ, mbvuuŋ bɛ kolo mo mu lɛsɛ achiji. Fi kooji le lɛ ba kɛme ki ba gɛɛ mbvuuŋ manfɛŋ nyume a kolo wù fwɛŋ le. Noo, mbvuuŋ bɛ kolo mo, mo nyume.” ");
INSERT INTO ncr_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Gɛh no Jiso gɛ̀ baaŋ wu jɛme bo le noo, fi kooshɛ lɛ muh wù baaŋ wumu gɛ̀ to wu lee wu tuŋ anyuu a wu jii wu lɛgɛ lɛ, “Mwa yaŋ wù kwɛse le wu kwe gɛh mɛɛse nɛ, geenɛ, to wo kuŋ wu le bɛ kibo kuŋ wu kaasɛ wu tu yu.” ");
INSERT INTO ncr_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jiso mo wu ja we bɛ wu tu bo gɛɛne, booŋ be ba ŋgoo bii tɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Fi kooshɛ lɛ kwɛse wumu wù gɛ̀ bee wu chɛŋ wa bɛ kinchɛŋ ki bikɛse lɛ biluŋ le yuufe ncho bifɛɛ gɛ̀ to a Jiso jiŋ wu kuŋ jwe wù nju ye le. ");
INSERT INTO ncr_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Fɛ wu kuŋ noo, gɛ̀ bee wu jɛmɛ wa fɛ fitele fie le lɛ, “Nɛ mɛ moŋ nlo ŋkuŋ gɛh nyu nju ye le, tu nle ntɛmɛ wa.” ");
INSERT INTO ncr_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","No wu kuŋ noo, Jiso kaasɛ ye wu yɛŋ wu le, wu jɛmɛ wu le lɛ, “Mwa yaŋ, keefɛ wo fâane gɛ. Fitele fiuŋ fì wo lese yi ye yaŋ le, le fi ge wa wo tɛmɛ.” Gɛh sege yu, kwɛse wuyu mo wu tɛmɛ lo. ");
INSERT INTO ncr_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jiso gɛɛŋ wu fɛsɛ fɛ muh wù baaŋ wɛɛ yeh le, wu yɛŋ bamii ba gɛ̀ toŋe bandoŋ ba kwe mo kinchvu ki bamii. Ki gɛ̀ bee fo bo fuge lo bɛ kwe. ");
INSERT INTO ncr_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jiso jɛmɛ bo le lɛ, “Bɛŋ sâaŋe, mwa wuyu baaŋ a kwe gɛ, wu lefe lo.” Bamii bayu tu bo keede lo wu. ");
INSERT INTO ncr_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Bo doo bo bvusɛ bamii bayu akfuuŋ, wu mo wu lee wu gɛɛŋ yeh, wu jijɛ mwa wuyu yi kibo le, wu mo wu ja we. ");
INSERT INTO ncr_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Saaka wù kune fiɛɛ fiyu jiɛnyɛ fi gɛɛŋ a kimbe ki woŋ wuyu le kichii. ");
INSERT INTO ncr_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jiso ja fɛ yeh yɛɛ le, wu doo wu jiɛnyi wu gɛɛne, binfeeŋ bimi bifɛɛ, nyu bilɛŋsɛ bi kuŋe bi bii wu le bi wanɛ fɛwɛɛwe bi duu lɛ, “Mwa Nfoŋ Dabi, koo yii fɛ bee le.” ");
INSERT INTO ncr_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jiso gɛɛŋ wu lee yeh, binfeeŋ biyu bi wu le, wu biih bi le lɛ, “Bɛŋ le bɛŋ bɛɛŋ lɛ taŋlo ŋge fiɛɛ fì bɛŋ beede finɛ?” Bi bɛɛŋ lɛ, “Ɛɛŋ Tada.” ");
INSERT INTO ncr_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jiso mo wu kuŋ ajii aboo le wu jɛmɛ lɛ, “Bii yi fitele fì bɛŋ leese yi ye yaŋ le, fi ge ye noo fɛ bɛŋ le.” ");
INSERT INTO ncr_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ajii aboo mo wo gwenyɛ. Jiso mo wu lejɛ lo fi tɛmɛ bo le wu jɛmɛ lɛ, “Bɛŋ yɛ̂ne keefɛ bɛŋ môŋ bɛŋ gê muh kɛ̂ɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Geenɛ, bo ka bo gɛɛŋ bo saŋsɛ lo saaka kune lɛme chi Jiso kimbe ki woŋ wuyu le wuchii. ");
INSERT INTO ncr_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","No bamii bayu gɛ̀ ja wa bo gɛɛne, fi kooshɛ lɛ bamii gɛ̀ ja bo to bɛ kinchifɛ kimi fɛ Jiso le, nchɛndaa wu debele nyu yi wu le. ");
INSERT INTO ncr_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jiso doo wu bvusɛ nchɛndaa wu debele wuyu ye yi muh wuyu le, wu mo wu kɛ wu jɛme. Kinchvu ki bamii yɛŋ noo jwe yuŋ bo, bo tu bo maŋe bo duu lɛ, “Gɛ bo gɛ̀ yu wa bo yɛŋ fiɛɛ njɛ finɛ le woŋ wù Ishwala le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Geenɛ, Bafalashii jɛme fiboo lɛ, “Wu bvuuse banchɛndaa ba debele banɛ nyu bɛ bvuŋga bvu nfoŋ banchɛndaa ba debele.” ");
INSERT INTO ncr_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jiso ja wu jiɛnyi a bilaantɛŋ le bichii mo bantɛ le wu yɛyi bamii yéh yi buunɛ yiboo le, wu ka feeji tɛ saaka wù joŋe kune bvunfoŋ bvu Nyo. Wu gɛ̀ jiɛnyi noo wu fɛde tɛ binchɛŋ bichii mo goŋ yì baaŋ. ");
INSERT INTO ncr_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Wu gɛ̀ yɛŋ binchvu bi bamii le, yii koo wu bɛ bo nje bo gɛ̀ bee yi manluŋ le, muh nyume gɛ yu wù fii bo gɛ, njɛ shóŋ yì le gɛ bɛ muh wù chiɛɛne yi gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Wu mo wu ja wu jɛmɛ booŋ be ba ŋgoo le lɛ, “Ŋgwejɛ duude baaŋ, geenɛ bamii ba ŋgwejɛ nyu shige. ");
INSERT INTO ncr_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Noo, bɛŋ bûune lɛ Tada wù Chiji mwɛ chiiŋsɛ bamii ba ŋgwejɛ a wu mwɛne.” ");
INSERT INTO ncr_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jiso ja wu tɛɛŋ booŋ be ba ŋgoo ba yuufe ncho bafɛɛ bo to. Wu nya bo bvuŋga ki bo bvûuse biyo bì yiide yi bamii le bo ka fɛ̂de binchɛŋ bichii mo goŋ yichii. ");
INSERT INTO ncr_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kanɛ le a jee a booŋ ba ntuŋ ba Jiso ba yuufe ncho bafɛɛ: Wù fwe gɛ̀ bee Samoŋ wù ba ka tɛŋe lɛ Bita, bɛ Andulu wù mwa bwee. Bamu nyu Jɛm wù mwa Jɛbɛdi bɛ mwa bwee wù Joŋ, ");
INSERT INTO ncr_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","mo Filib, Batolomiu, Toma bɛ Macho wù gɛ̀ koode ŋwa, Jɛm wù mwa Alfayu, Tadio, ");
INSERT INTO ncr_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","bɛ Samoŋ wù gɛ̀ bee ŋgoo yi Bajalot le, bɛ Juda Ɛkaliot wù gɛ̀ gesɛ Jiso. ");
INSERT INTO ncr_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jiso tuŋ bamii ba yuufe ncho bafɛɛ banɛ, wu jɛmɛ bo le lɛ, “Bɛŋ doo bɛŋ gɛɛne, keefɛ bɛŋ gɛ̂ɛŋ kijusɛ le njɛ le ki bamii ba le gɛ Bajuu gɛ. Keefɛ bɛŋ gɛ̂ɛŋ bilaantɛŋ bì le bi bamii ba Samaliya le gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Bɛŋ gɛ̂ɛŋ nyu fɛ booŋ ba Ishwala le ba le ba lɛsɛ wa njɛ shóŋ. ");
INSERT INTO ncr_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Bɛŋ doo bɛŋ gɛɛne bɛŋ mo bɛŋ fêeji bɛŋ dûu lɛ, ‘Bvunfoŋ bvu fɛwe le wa mbebe le.’ ");
INSERT INTO ncr_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Bɛŋ fɛ̂de tɛ bamii ba chɛne, bɛŋ gêe bamii ba kweeyɛ wa bo tuu yu, bɛŋ fɛ̂de bamii ba kɛme goŋ yì baaŋ, bɛŋ bvûuse banchɛndaa ba debele yi bamii le. Nle nnya bvuŋga bɛŋ le achiji. Bɛŋ gɛ̂ɛŋ tɛ bɛŋ fîih bamii yu achiji. ");
INSERT INTO ncr_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Bɛŋ doo bɛŋ gɛɛne, keefɛ muh jô bige wu shûu yi kicha le gɛ, kɛnɛ nyu bì kuge, kɛnɛ nyu bì shige, kɛnɛ nyu bì shige shige nɛɛ lɛ. ");
INSERT INTO ncr_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Keefɛ muh jô kikɛɛ gɛ! Keefɛ muh jo bikuŋ bifɛɛ kɛnɛ jé yimi gɛ, mo nyu kimbaŋ gɛ. Bɛŋ kêe lɛ nɛ muh lɛne lɛme, tu le fo fɛ wù kɛme ki wu jîi fo. ");
INSERT INTO ncr_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Bɛŋ doo bɛŋ gɛɛŋ bɛŋ lee a laantɛŋ, kɛnɛ ntɛ le, bɛŋ gooŋ bɛŋ yɛŋ muh wù le wu kojɛ le, bena bo chêe gɛɛŋ bu kife kì bɛŋ le bɛŋ ja yo. ");
INSERT INTO ncr_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Bɛŋ doo bɛŋ gɛɛŋ, bɛŋ doo bɛŋ lese a muh yeh, bɛŋ yɛsɛ yeh yiyu le. ");
INSERT INTO ncr_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Yeh yiyu nɛ le yi kojɛ, kimbonɛ kena to yu yeh. Nɛ yeh yiyu baaŋ kojɛ gɛ, kimbonɛ kena kaasɛ ki tu a bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nɛ muh le wu faŋ ki wu fî bɛŋ kɛnɛ ki wu yû fiɛɛ fì bɛŋ jɛme, bɛŋ doo bɛŋ bude yeh yiyu le kɛnɛ a kilaantɛŋ kiyu le bɛŋ kaajɛ bibvunɛ biboo yi bikaa biɛna le. ");
INSERT INTO ncr_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nsɛŋe bɛŋ nchiɛɛŋ lɛ lé gê doo nyume juu chi nsa wù fɛkimɛsɛ, mwɛɛ bonɛ fɛ kilaantɛŋ ki Sodom bɛ ki Gomola le, fe kilaantɛŋ ki kɛɛ. ");
INSERT INTO ncr_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Bɛŋ yêgɛ bɛŋ yû, ntune bɛŋ, bɛŋ lé bɛŋ gɛ̂ɛŋ bɛŋ nyû njɛ shóŋ antɛnɛɛ a baŋgvufe. Noo, bɛŋ doo bɛŋ jiɛnyi bɛŋ fêefe njɛ yó, bɛŋ nyû tɛ nyiɛgee njɛ bibɛmbɛ. ");
INSERT INTO ncr_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Bɛŋ doo bɛŋ jiɛnyi bɛŋ jôde kife kune bamii. Bɛŋ kêe lɛ ba lé ba gê ba nya bɛŋ chiaaŋ yi bamii ba sage bansa le. Bo lé bo gê bo suŋe bɛŋ yéh yi buunɛ yiboo le. ");
INSERT INTO ncr_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Bo lé bo gê bo chii bɛŋ bo gɛɛŋ bɛ bɛŋ fwe fɛ bamii ba sage bimbe bi woŋ le, mo fwe a banfoŋ nje mɛ, wu lɛ bɛŋ mo bɛŋ jɛme bo le mo bamii ba le gɛ Bajuu le gɛ kune mɛ. ");
INSERT INTO ncr_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ba doo ba nya bɛŋ bo le noo, keefɛ kikwɛɛ fûuŋse bɛŋ laa bɛŋ lé bɛŋ gɛ̂ɛŋ bɛŋ jɛmɛ lɛ la lɛ, je yì nɛɛ le la, nje Nyo lé wu gê wu nya fiɛɛ fì bɛŋ le bɛŋ jɛmɛ kife kiyu le. ");
INSERT INTO ncr_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Bɛŋ kêe lɛ gɛ ka jɛme bɛŋ gɛ. Lé gê jɛ̂me Kiyo ki Chiji wene jwe wene le. ");
INSERT INTO ncr_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Muh lé wu gê wu ja wu jô mwa bwee wu nyâ ba yuuyɛ, chiji mwa jô mwa ye wu nyâ ba yuuyɛ. Booŋ lé bo gê bo ja bo boone bikaa a bachiji baboo jiŋ, bo gee ba yuuyi bo. ");
INSERT INTO ncr_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Bamii bachii lé bo gê bo banɛ bɛŋ nje jee chaŋ. Geenɛ muh wu lé wu kâaŋ shɛ́ŋ gɛɛŋ bu fɛkimɛsɛ, lé wu gê wu bonɛ. ");
INSERT INTO ncr_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Sege bamii booŋ bikaa a bɛŋ jiŋ a kilaantɛŋ kimi le, bɛŋ fɛ̂ɛ bɛŋ gɛ̂ɛŋ a kimi le. Nsɛŋe bɛŋ nchiɛɛŋ lɛ, gɛ bɛŋ nyu bɛŋ jiɛnyɛ bilaantɛŋ bi Ishwala le bichii muh wù jee che le Mwamuh baaŋ to gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Bɛŋ kee lɛ gɛ mwa ŋwa to wu fede muh wù yɛyi wu gɛ, gɛ mwa lɛme to wù fede tɛ chiji kikwɛɛ ke gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Fi le fi kojɛ lɛ mwa ŋwa taŋlo wù nyu njɛ muh wù yɛyi wu, mwa lɛme nyu tɛ njɛ chiji kikwɛɛ ke. Ba nɛ tɛŋe chiji yeh lɛ wu le Bɛsebu, ba gɛ tɛɛŋ booŋ ba yeh bɛ jee chi kuufe ye chi fede chi chiɛɛ gɛ? ");
INSERT INTO ncr_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Noo, keefɛ bɛŋ fâane muh gɛ. Bɛŋ kêe lɛ gɛ fiɛɛ fì ba le ba baŋe fi nyu njɛ fi lé fi tô fi bu fɛ waaŋ sɛŋ gɛ. Gɛ fiɛɛ nyu yu tɛ fì ba nyile fì nyu njɛ ba kɛɛ sɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Fiɛɛ fì nsɛŋe bɛŋ le antaŋ, bɛŋ lé bɛŋ jɛ̂mɛ bamii le fɛnshe. Fì nchvuune bɛŋ le, bɛŋ é bɛŋ jâŋ nyu fɛ kigo ki yeh le. ");
INSERT INTO ncr_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Keefɛ bɛŋ fâane bamii ba taŋlo bo yuuyɛ gɛh nyume nyaŋ yi ye maa, njɛ taŋlo bo yuuyɛ tɛ kiyo sɛŋ gɛ. Bɛŋ fâane nyu Nyo wù taŋlo wu lɛɛshɛ kiyo ki muh bɛ ye ye yi ŋgu wù baaŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Gɛ ba gese munsɛŋ munfɛɛ yi finini le maa gɛ? Geenɛ, gɛ fimimia gwee fɛkuu njɛ Chiji wene le wu bɛɛŋ sɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Fiena le lɛ Nyo kee yvú yichii yì le a bɛŋ fwa. ");
INSERT INTO ncr_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Noo, keefɛ bɛŋ fâane gɛ. Bɛŋ fede munsɛŋ mù duude. ");
INSERT INTO ncr_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Nɛ muh bɛmɛ mɛ a bamii fwe lɛ wu kee mɛ, tu nlé ŋgê mbɛɛŋ tɛ mwɛdɛ fwe a Chijaŋ wù fɛwe. ");
INSERT INTO ncr_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Geenɛ le yɛɛŋ wù faŋ mɛ a bamii fwe, nlé ŋgê nfaŋ tɛ wù fwe a Chii wù fɛwe. ");
INSERT INTO ncr_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Keefɛ bɛŋ kwâji lɛ nto nyu bɛ nyiɛgee yi nshɛŋ le fɛnɛ gɛ. Gɛ nyu fiɛɛ fì nto nje fi gɛ. Nto nyu bɛ jɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Bɛŋ kêe lɛ nto ki ŋge mwa wù jwɛŋsɛ juu bɛ chiji, mwa wù kwɛse juu bɛ bwee, kwɛ mwa juu bɛ bwe jwɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Bamii ba kimbanɛ ba muh lé bo gê bo nyu bamii ba a wu yeh. ");
INSERT INTO ncr_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Nɛ muh koŋe chiji kɛnɛ bwee wu fede mɛ, tu wu baaŋ kojɛ gɛ ki wù nyu muh waŋ gɛ. Muh koŋe tɛ mwa ye wu jwɛŋsɛ kɛnɛ wù kwɛse wu fede mɛ, tu wu baaŋ kojɛ gɛ ki wù nyu muh waŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nɛ muh baaŋ tuu gɛ kintaaŋ ke wu bii mɛne gɛ, tu wu baaŋ kojɛ gɛ ki wù nyu muh waŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nɛ muh baji kinche ke, tu wu lé wu gê wu lɛsɛ kinche kiyu. Geenɛ muh wu lɛsɛ kinche ke nje mɛ, tu wu lé wu gê wù kɛme kinche kì kage gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Nɛ muh fii bɛŋ, tu wu fii nyu mɛ. Muh fii mɛ, tu wu fii nyume muh wu tuŋ mɛ. ");
INSERT INTO ncr_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nɛ muh fii muh wu ntuŋ wu Nyo nje wu kee lɛ le Nyo wù tuŋ wu, tu wu lé wu gê wù kɛme maajɛ wù Nyo maaji bamii be ba ntuŋ yu. Nɛ muh fii muh wù chaaŋ nje wu kee lɛ mwɛdɛ le muh wù chaaŋ, tu wu lé wu gê wù kɛme maajɛ wù Nyo maaji bamii ba chaaŋ yu. ");
INSERT INTO ncr_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nsɛŋe bɛŋ nchiɛɛŋ lɛ, muh wù nya fiŋkoo fi joo yi jiɛɛ muh wu mumwaa a ŋgoo yi bamii ba shige shige banɛ le nje wu kee lɛ le muh waŋ wu ŋgoo, tu gɛ mwɛdɛ nyu wu to wu fu maajɛ we gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jiso mɛsɛ wu tefɛ booŋ be ba ŋgoo ba yuufe ncho bafɛɛ wu mo wu ja fo wu jiɛnyi a bilaantɛŋ bi yo le wu yɛyi bamii wu ka feeji saaka wù joŋe. ");
INSERT INTO ncr_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Gɛ̀ bee kife kiyu le, Joŋ Nlesɛajoo nyu yeh yi ncha le. Wu ja wu yu kune mwɛɛ mu Kletu gɛ̀ gee, wu mo wu tuŋ booŋ be ba ŋgoo bo gɛɛŋ, ");
INSERT INTO ncr_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","bo biih wu le laa le wu wù gɛ̀ bee ki wu gê wu to noo, bo chîɛɛne muh mu la. ");
INSERT INTO ncr_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Bo gɛɛŋ bo biih, Jiso chvuu bo le lɛ, “Bɛŋ kâasɛ bɛŋ gɛ̂ɛŋ bɛŋ sɛ̂ɛŋ Joŋ mwɛɛ mù bɛŋ yu mo mù bɛŋ yɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Binfeeŋ yɛde wa mwɛɛ le, batɛŋlaase jiɛnyi chaaŋ, bamii ba chɛne bɛ goŋ yì baaŋ tɛmɛ wa bo yuude, binchifɛ yuge wa mwɛɛ, bamii ba kweeyɛ kaase bo tuu yu, bo ka feeji tɛ saaka wù joŋe wu Nyo bamii ba kifufe le. ");
INSERT INTO ncr_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Noo, kinlaŋye kì baaŋ le kì muh wù baaŋ mɛ maŋɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Booŋ ba Joŋ ba ŋgoo baa ja, Jiso mo wu kɛ wu jɛme kinchvu ki bamii le kune Joŋ wu biide lɛ, “Bɛŋ chi shee bɛŋ bude bɛŋ gɛɛne kwa ki bɛŋ gɛ̂ɛŋ bɛŋ yɛŋ nyu la le? Gane chì fii fede chi shiŋshi le noo? ");
INSERT INTO ncr_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nɛ ya noo gɛ, bɛŋ chi bude bɛŋ gɛɛne yo nje la? Bɛŋ chi gɛɛne ki bɛŋ yɛ̂ŋ muh le wù susɛ ye bɛ njú yì bonɛ? Bɛŋ yêgɛ bɛŋ yû, bamii ba suse ye bɛ njú yì bonɛ to bo nyu a banto le. ");
INSERT INTO ncr_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nɛ ya noo gɛ, bɛŋ chi bude bɛŋ gɛɛne yo nje la? Ki bɛŋ gɛ̂ɛŋ bɛŋ yɛŋ muh wu ntuŋ wu Nyo le noo? Ɛɛŋ, nsɛŋe bɛŋ le lɛ wu fede muh wu ntuŋ wu Nyo. ");
INSERT INTO ncr_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Le wu wù ba gɛ̀ saŋ kune wù Nyo duu lɛ, ‘Yêgɛ yû, nlé ŋgê nchîiŋsɛ muh waŋ wu ntuŋ wu sâ wo fwe, wu sêesɛ je yo fɛ wo tôo.’ ");
INSERT INTO ncr_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nsɛŋe bɛŋ nchiɛɛŋ lɛ, antɛnɛɛ a bamii ba bikɛse le bo boo wa, ba baaŋ a boo gɛ muh wù kuge wu fede Joŋ Nlesɛajoo gɛ. Geenɛ, muh wù shige antɛnɛɛ a bvunfoŋ bvù fɛwe kuge wu fede wu. ");
INSERT INTO ncr_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kɛge yi kife kì Joŋ Nlesɛajoo gɛ̀ kɛ lɛme che too bude mɛɛse, gɛ̀ bee bamii taŋe bvunfoŋ bvù fɛwe, bamii ba bvuŋga lode bɛ bvuŋga. ");
INSERT INTO ncr_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Bamii ba ntuŋ wu Nyo bachii mo banchi ba Musɛ gɛ̀ jɛme kune bvunfoŋ bvù fɛwe to bu kife ki Joŋ Nlesɛajoo le. ");
INSERT INTO ncr_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nɛ bɛŋ le bɛŋ yɛŋ lɛ bɛŋ taŋlo bɛŋ bɛɛŋ, bɛŋ bɛɛŋ lɛ Joŋ wunɛ le Alaja wù gɛ̀ bee ki wu gê wu to. ");
INSERT INTO ncr_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Muh wù kɛme bintuŋ wu yu.” ");
INSERT INTO ncr_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Jiso ja wu gha lɛ, “Fiɛɛ fì taŋlo mbege kiŋgogɛ ki mɛɛse kinɛ yu le la? Bo le gɛh lo njɛ booŋ ba shige shige ba shiiyɛ manjuu ma waaŋ le, bamu tɛŋe bamu bo biide lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Bee toŋe ndoŋ bɛŋ bine gɛ? Bee nyaa ŋkee wu kwe, bɛŋ bɛmɛ gɛ?’ ");
INSERT INTO ncr_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Njɛme noo nje Joŋ gɛ̀ bee wu to wu faŋ ki wu jîi mwɛɛ kɛnɛ ki wu mûu, bɛŋ tu bɛŋ jɛme lɛ wu kɛme nchɛndaa wu debele yi wu le. ");
INSERT INTO ncr_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Muh wù jee che le Mwamuh doo wu to, wu jii mwɛɛ wu ka muu, bɛŋ lɛ ba jiŋɛ ba yɛŋ, wu jiɛnyi wu wuude lo mwɛɛ munjile wu yaane lo mbvuuŋ, wu ka nyume nsaa yi bamii ba koode ŋwa mo bamii ba befe bamu. Bɛŋ kêe lɛ bvufee to bvu duunyi ye nyu yi fiɛɛ fì bvu lɛne le.” ");
INSERT INTO ncr_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jiso mo wu ja wu kɛ wu kɛnɛ ye yi gee chi bilaantɛŋ bimi bì wu gɛ̀ ge biŋgha bi mwɛɛ bì duude bi le, nje wu gɛ̀ ge noo, bamii ba yo faŋ ki bo kusɛ kinche kiboo. ");
INSERT INTO ncr_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Wu gɛ̀ kɛnɛ noo, wu jɛme lɛ, “Ŋgɛ wù baaŋ le wene bamii ba Kolasiŋ, ŋgɛ wù baaŋ le tɛ wene bɛŋ bamii ba Bɛsada. Bɛŋ kêe lɛ, nɛ ŋgɛ̀ ŋge biŋgha bi mwɛɛ bì ŋgɛ̀ ŋge bɛŋ le, nyume Taya bɛ Sidoŋ, tu bo gɛ̀ bee bo jii wa bimbaŋkwe, bo kfuuŋ taaŋ ye le nchensɛŋ ki bo dunyɛ lɛ bo le bo kusɛ wa muntele muboo. ");
INSERT INTO ncr_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nsɛŋe bɛŋ le lɛ, lé gê doo nyume juu chi nsa wù fɛkimɛsɛ, mwɛɛ bonɛ fɛ bamii ba Taya le mo ba Sidoŋ le fe fɛ bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mo bɛŋ bamii ba Kafanahum, bɛŋ kwaji lɛ ba lé ba gê ba bɛɛŋsɛ bɛŋ, bɛŋ bɛɛŋ fɛwe? Aay! Ba lé ba gê ba shiishɛ lo bɛŋ, bɛŋ shii bɛŋ gɛɛŋ woŋ wu baŋkfu le. Bɛŋ kêe lɛ, nɛ ŋgɛ̀ ŋge biŋgha bi mwɛɛ bì ŋgɛ̀ ŋge bɛŋ le nyu Sodom, tu kilaantɛŋ kiyu be baaŋ yu, too bude abɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nsɛŋe bɛŋ le lɛ, lé gê doo nyume juu chi nsa wu fɛkimɛsɛ, mwɛɛ bonɛ fɛ bamii ba woŋ wu Sodom le fe fɛ bɛŋ le.” ");
INSERT INTO ncr_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Gɛh kife kiyu le, Jiso ja wu jɛmɛ lɛ, “Nnyaa kiyone wo le Chii Nfoŋ kibvulɛ bɛ nshɛŋ, no wo le wo nyilɛ mwɛɛ munɛ babvufee le mo baŋkɛɛ fiɛɛ le, wo dunyɛ nyu mumwone mu bwele le. ");
INSERT INTO ncr_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Le no fi le Chii, nje le no wo gɛ̀ goone lɛ fi nyume. ");
INSERT INTO ncr_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Chii le wu nya wa mwɛɛ munchii mɛne. Gɛ muh nyu yu wù kee Mwa fuge Chiji gɛ. Gɛ muh nyu yu wù kee Chiji fuge Mwa ye gɛ, mo bamii ba Mwa le wu cha wa ki wu dûnyɛ Chiji bo le. ");
INSERT INTO ncr_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Bɛŋ bachii ba le akuu a bvujijɛ bvu yage bɛŋ, bɛŋ to fɛ mɛne, ŋge bɛŋ fufɛ shɛ́ŋ. ");
INSERT INTO ncr_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Bɛŋ jo nyu kimbuŋ kaŋ bɛŋ shumɛ, bɛŋ bîi n'yɛyɛ waŋ le, nje nle fiaŋ muh wù nyiɛgee, ŋkɛme fitele fì jiɛɛ, bɛŋ lé bɛŋ kɛ̂mɛ nfufɛ shɛ́ŋ fɛ muntele mwɛna le. ");
INSERT INTO ncr_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Gɛ kimbuŋ kaŋ yage shumɛ le gɛ, gɛ bvujijɛ bwaŋ jiji gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Gɛ̀ bee kife kiyu le, Jiso bɛ booŋ be ba ŋgoo jiɛnyi bo fede mwɛ wu agiŋ wumu le, nyu juu chi yuuŋ. Gɛ̀ bee jɛŋ yuu booŋ be ba ŋgoo, bo mo bo ja bo kɛ bo suume bichiɛɛ bo jii. ");
INSERT INTO ncr_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Bafalashii yɛŋ, bo jɛmɛ Jiso le lɛ, “Bîjɛ wo yɛ̂ŋ, booŋ buŋ ba ŋgoo gee fiɛɛ fì nchi baaŋ bɛɛŋ gɛ lɛ muh gê juu chi yuuŋ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Wu biih bo le lɛ, “Bɛŋ baaŋ a tɛɛŋ gɛ a Ŋwa wu Nyo le no jɛŋ gɛ̀ yuu Dabi bɛ ŋgoo ye, no wu gɛ̀ ge gɛ? ");
INSERT INTO ncr_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Wu gɛ̀ lee yeh yi Nyo le, wu ji blɛd wù ba le ba cha ba gɛɛ lɛ le wu Nyo, gɛ̀ bee nchi fɛ wu le kɛnɛ bamii ba gɛ̀ bee bɛ wu ki bo ji. Taŋlo ji gɛh nyu bachiji kintanyɛ. ");
INSERT INTO ncr_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Noo, lɛ bɛŋ baaŋ a tɛɛŋ gɛ tɛ a banchi ba Musɛ le, lɛ ge doo nyume juu chi yuuŋ, bachiji kintanyɛ ŋgode nchi wu yuuŋ bo ge lɛme chiboo yeh yi kintanyɛ le, geenɛ, nsa nyu gɛ? ");
INSERT INTO ncr_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nsɛɛŋ bɛŋ le lɛ fiɛɛ le yu fɛnɛ mɛɛse fi kuge fì fede yeh yi kintanyɛ. ");
INSERT INTO ncr_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ba le ba saŋ a Ŋwa wu Nyo le lɛ Nyo jɛme lɛ, ‘Ŋgoone lɛ bamii kôode nyu yii fɛ bamii le, gɛ ŋgoone lɛ bo gêe nyu bintanyɛ fɛ mɛne gɛ.’ Nɛ bɛŋ fɛnɛ bee bɛŋ kee fiɛɛ fì kijusɛ kiyu kinɛ duu, bɛŋ gɛ ka bɛŋ sage bamii ba kɛme jialɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Fi le lɛ muh wù jee che le Mwamuh le Chiji kikwɛɛ ki yuuŋ.” ");
INSERT INTO ncr_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jiso ja fo, wu gɛɛŋ wu lee yeh yi buunɛ yiboo le. ");
INSERT INTO ncr_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Fi kooshɛ lɛ muh mu gɛ̀ bee yu a kibo ke kimi nyume ki kwe wa. Bamii bamu ja bo biih Jiso le lɛ, “Nchi le wu bɛɛŋ lɛ taŋlo ba fɛ muh juu chi yuuŋ?” Bo gɛ̀ biide noo bo goone nyu fiɛɛ fì bo kooyi yi ye ye le. ");
INSERT INTO ncr_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jiso chvuu bo le lɛ, “Le yɛɛŋ a bɛŋ ntɛnɛɛ wù kɛme shóŋ, yimi gwe a kintuge le juu chi yuuŋ, wu gɛ jijɛ wu chii wu bvusɛ gɛ? ");
INSERT INTO ncr_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Gɛ muh wu wuŋ fede shoŋ gɛ? Noo, tu nchi le wu bɛɛŋ lɛ muh ge lɛme chi joŋe juu chi yuuŋ.” ");
INSERT INTO ncr_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Wu mo wu jɛmɛ muh wù gɛ̀ bee kibo nyu ki kwe wɛɛ le lɛ, “Nɛ̂jɛ kibo kuŋ!” Muh wuyu nɛjɛ ki, ki mo ki tɛ̂mɛ ki tu ki nyu gɛh njɛ kimi kɛɛ. ");
INSERT INTO ncr_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Geenɛ Bafalashii bu bo gɛɛŋ bo mo bo chu ntaŋ no bo lé bo gê fɛ bo yuuyɛ Jiso. ");
INSERT INTO ncr_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jiso kɛɛ kune ntaŋ wu ba chu, wu mo wu ja fo. Bamii ba duude bi wu le. Wu fɛ bo bachii ba gɛ̀ kɛme binchɛŋ, ");
INSERT INTO ncr_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","wu chiisɛ bo le lɛ keefɛ bo gê bamii kɛɛ wu gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Fi gɛ̀ bee noo ki fi gê fi kojɛ no muh wu ntuŋ wu Nyo wù Yosaya gɛ̀ jɛme lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Bɛŋ jîŋɛ bɛŋ yɛ̂ŋ, wunɛ le mwa yaŋ wu lɛme wù nle ncha. Ŋkoŋe wu, fitele fiaŋ yuge njoŋ bɛ wu. Nlé ŋgê nnyâ Kiyo kaŋ wu le, wu fêeji bamii ba le gɛ Bajuu le gɛ kune je yì chaaŋ yì wu suune bansa yu. ");
INSERT INTO ncr_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Gɛ wu nyu wu wâade bɛ bamii gɛ, kɛnɛ wu kune jwe gɛ. Gɛ muh nyu wu yu jɛ ye yi bifiaŋ bi jé le gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Gɛ wu nyu wu mɛ̂sɛ wu ŋgode gane chì ŋgvuusɛ wa gɛ. Gɛ wu nyu wu jîŋsɛ kin'yesɛ kì bɛde jibejibe gɛ. Fi lé fi nyû noo gɛɛŋ bu no wu lé wu fɛ̂ je yì chaaŋ, yì wu suume bansa yu lé yi sô. ");
INSERT INTO ncr_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Bamii ba le gɛ Bajuu gɛ bachii lé bo gê bo jîiŋe fwe bo gɛɛ bvufee yi wu le.” ");
INSERT INTO ncr_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Bamii bamu ja bo to bɛ muh mu wu feeŋ, wu nyu kinchifɛ, nchɛndaa wu debele nyu yi wu le. Jiso fɛ wu, wu jɛme wu ka yɛde mwɛɛ le. ");
INSERT INTO ncr_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Jwe yuŋ bamii ba gɛ̀ bee fo bachii, bo tu bo biide lɛ, “Taŋlo muh wunɛ nyu mwa Nfoŋ Dabi?” ");
INSERT INTO ncr_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Geenɛ Bafalashii doo bo yu no bo biide noo bo duu lɛ, “Muh wunɛ bvuuse banchɛndaa ba debele banɛ nyu bɛ bvuŋga bvu Bɛsebu wù le nfoŋ wu banchɛndaa ba debele.” ");
INSERT INTO ncr_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jiso kɛɛ fiɛɛ fì bo kwaji wu mo wu jɛmɛ bo le lɛ, “Nɛ kituŋ ja ki ga ki tu ki juu lɛkilɛki, tu ki lé ki jâ ki tu binfu. Kilaantɛŋ kɛnɛ yeh ja yi gasɛ yi tu juu lɛyilɛyi, yi gɛ ka yi lɛɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nɛ, Sataŋ bvuse ye ye yi muh le, tu wu le wu gasɛ wa ye ye. Nɛ fi le noo, bvunfoŋ bwe gɛ ka bvu lɛɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Fi nɛ le lɛ mbvuuse banchɛndaa ba debele nyu bɛ bvuŋga bvu Bɛsebu, tu bena booŋ bvuuse nyu bɛ bvu yɛɛŋ? Fiɛɛ fì booŋ bena bayu gee duunyi lɛ bɛŋ le bɛŋ gwe wa nsa. ");
INSERT INTO ncr_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Geenɛ nɛ mbvuuse banchɛndaa bayu nyu bɛ bvuŋga bvu Kiyo ki Nyo, tu bvunfoŋ bvu Nyo le bvu to wa fɛ bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Bɛŋ kwaji lɛ taŋlo muh lee a muh wu bvuŋga yeh, wu kudɛ mwɛɛ mwe wu bu bɛ mu, njɛ wu ya wu koo muh wu bvuŋga wuyu wu kaaŋ sɛŋ? Sege wu le wu kaaŋ noo fɛ wu kudɛ mwɛɛ mwe wu bu bɛ mu. ");
INSERT INTO ncr_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nɛ muh baaŋ nyu gɛ kimbe kaŋ le gɛ, tu wu banɛ mɛ. Muh le njɛ wu fii mɛ ki be baanyi lo sɛŋ, tu wu saayi lo. ");
INSERT INTO ncr_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Noo, nsɛŋe bɛŋ le lɛ Nyo taŋlo wu lɛɛshɛ mwɛɛ mù mbefe mo jɛ́ yì befe yichii yì bamii jɛme. Geenɛ muh wù jɛme jɛ yì befe kune Kiyo ki Yuude, tu gɛ taŋlo Nyo lɛɛshɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nɛ muh jɛme jɛ́ yì befe kune muh wu jee che le Mwamuh, tu taŋlo Nyo lɛɛshɛ jɛ́ yiyu. Geenɛ muh jɛme jɛ yì befe kune Kiyo ki Yuude, tu gɛ taŋlo Nyo yu wu lɛɛshɛ gɛ kɛnɛ nyu kife kinɛ le kɛnɛ kife ki too le. ");
INSERT INTO ncr_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Nɛ muh kɛme kite kì joŋe, tu wù kɛme muntaŋ mù njoŋe mù yune yi ki le. Muh nɛ kɛme kite kì befe, tu wù kɛme tɛ muntaŋ mù mbefe mù yune yi ki le. Ba kee kite nyu yi muntaŋ mù yune yi ki le. ");
INSERT INTO ncr_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kiŋgogɛ ki yó lɛ kinɛ, bɛŋ taŋlo bɛŋ ge nɛɛ fɛ bɛŋ jɛme njɛmɛ wù joŋe bɛŋ nyume bamii ba befe? Bɛŋ kêe lɛ fiɛɛ fì le fi yisɛ a fitele fì muh le, le fi fì bude jwe we le. ");
INSERT INTO ncr_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Muh wù kɛme nchvu yi mwɛɛ mù njoŋe a fitele fie le, tu wu lé wu bvûuse mwɛɛ mù njoŋe. Nɛ le muh wù kɛme nyu nchvu yi mwɛɛ mù mbefe, tu wu lé wu bvûuse nyu mwɛɛ mù mbefe. ");
INSERT INTO ncr_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nsɛŋe bɛŋ le lɛ lé tô nyume juu chi nsa wù fɛkimɛsɛ, muh kɛme ki wu tânyɛ jwe yi jɛ́ yì achiji yì wu gɛ̀ jɛme le. ");
INSERT INTO ncr_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Bɛŋ kêe lɛ sege ba sage muh, lé jɛ́ yì bûde jwe we le yì lé yi gê wu yuu, le gɛh tɛ jɛ́ yì bude jwe we le, lé yi gê wu gwe sa.” ");
INSERT INTO ncr_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Bamii bamu ba gɛ̀ duunyi banchi ba Nyo bɛ Bafalashii mo bo ja bo jɛmɛ Jiso le lɛ, “Muh wu N'yɛyɛ, bee goone lɛ wo ge fiɛɛ fì duunyi bvuŋga bwuŋ bee yɛŋ.” ");
INSERT INTO ncr_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jiso chvuu bo le lɛ, “Kiŋgogɛ kì befe kì chinɛ wa Nyo le njɛ kwɛse wu kinjikuu, ki goone ki yɛŋ fiɛɛ fì duunyi bvuŋga bwaŋ le! Gɛ taŋlo ndunyɛ fiɛɛ kiŋgogɛ kinɛ le fede fi muh wu ntuŋ wu Nyo wù Jona gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","No Jona gɛ̀ che a biɛŋ yì kuge shɛŋ yi aju le atade bɛ bintaŋ bitɛde, le gɛh yɛɛŋyɛɛŋ no muh wù jee che le Mwamuh lé wù nyû antɛnɛɛ a nshɛŋ yi aju le atade bɛ bintaŋ bitɛde. ");
INSERT INTO ncr_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Lé doo nyûme juu chi nsa wù fɛkimɛsɛ, bamii ba Ninibɛ lɛɛŋ bɛ kiŋgogɛ ki mɛɛse kinɛ ki ge ba leesɛ ki yi ŋgɛ le, nje bo, bamii ba Ninibɛ gɛ̀ yu fiɛɛ fì Jona feeji, bo kusɛ kinche kiboo. Geenɛ bɛŋ yêgɛ bɛŋ yû, muh le fɛnɛ bɛ fiɛɛ fì kuge fi fede fi Jona. ");
INSERT INTO ncr_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Lé tô nyu juu chì fɛkimɛsɛ Yaa wù gɛ̀ sage kituŋ kì Shɛba wu lɛɛŋ bɛ kiŋgogɛ ki mɛɛse kinɛ wu leesɛ ki ŋgɛ le, nje wu gɛ̀ ja a kituŋ ke le a woŋ juuse yo ki wu tô wu yu bvufee bvu Nfoŋ Salamoŋ. Geenɛ bɛŋ yêgɛ bɛŋ yû, muh mu le fɛnɛ bɛ fiɛɛ fì kuge fi fede fi Salamoŋ. ");
INSERT INTO ncr_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Kiyo kì yiide to ki bu ye yi muh le ki gɛɛŋ nchvuuŋ ki tu ki goone fɛ ki lé ki chêe fo. Geenɛ ki doo ki gooŋ sɛŋ, ");
INSERT INTO ncr_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ki mo ki jɛ̂mɛ kikwɛɛ ke le lɛ, ‘Nlé ŋkâasɛ ntû a mɛ yeh fɛ nchi mbu fo.’ Sege ki kaasɛ ki tu jiŋ ki yɛŋ yeh le fiɛɛ nyu gɛ yu gɛ, ba yɛɛsɛ ba seesɛ yi yuude, ");
INSERT INTO ncr_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","noo ki mo ki kâasɛ ki gɛɛŋ, ki to bɛ biyo bimi bvusooshwi bì befe bì fede ki, bɛ bi mo bi to bi lee bi chee fo. Mwɛɛ mo mu mɛsɛ mu fo lo fɛ mwɛdɛ le segeyu fede no mu chi shee mu nyume. Le gɛh yɛɛŋyɛɛŋ no fi lé fi nyû fɛ kiŋgogɛ kì befe ki mɛɛse kinɛ le.” ");
INSERT INTO ncr_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Gɛh no Jiso gɛ̀ baaŋ wu yɛyi bamii noo, fi kooshɛ lɛ bwe Jiso bɛ booŋ ba bwe Jiso gɛ̀ to bo lɛɛŋ akfuuŋ bo goone lɛ bɛ bo jɛmɛ. ");
INSERT INTO ncr_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Muh mu jɛmɛ Jiso le lɛ, “Bwoo bɛ booŋ ba bwoo lɛme akfuuŋ bo goone lɛ bena bo jɛmɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Wu biih wu le lɛ, “Bwɛɛŋ le yɛɛŋ, booŋ ba bwɛɛŋ le baaŋ?” ");
INSERT INTO ncr_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","No wu bile noo, wu mo wu looŋ bamii be ba ŋgoo, wu du lɛ, “Bwɛɛŋ bɛ booŋ ba bwɛɛŋ le banɛ. ");
INSERT INTO ncr_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Bɛŋ kêe lɛ muh wuchii wù gee fiɛɛ fì Chii wu fɛwe goone le wu wù le mwa bwaaŋ bɛ jɛme yaŋ mo bwɛɛŋ.” ");
INSERT INTO ncr_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Gɛh abvu, Jiso ja wu bu yeh, wu gɛɛŋ wu shii mbebe mamasi le. ");
INSERT INTO ncr_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kinchvu ki bamii kì baaŋ taashɛ mbebe ye le nɛ gɛmm. Wu mo wu ja wu lee wu shii nyu a ŋguh le a joo, kinchvu kiyu lɛme kwa ŋgɛɛme yi joo le. ");
INSERT INTO ncr_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Wu jɛme mwɛɛ wesee a baŋgaŋ le bo le. Wu gɛ̀ jɛmɛ lɛ, “Muh gɛ̀ la ki wu gɛ̂ɛŋ wu noŋ muntaŋ. ");
INSERT INTO ncr_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Wu gɛ̀ doo wu nooŋ, mumu gwe a je, munyii to mu tajɛ mu ji. ");
INSERT INTO ncr_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Muntaŋ mumu gwe fɛ kijusɛ ki ata le nshɛŋ nyu gɛ fo chuule gɛ, mu mo mu yaŋsɛ mu bu nje gɛ nshɛŋ gɛ̀ bee fo chuule gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Muu gɛ̀ doo wu kɛ wu baaŋ wu suŋ muntaŋ muyu. No mu baaŋ a chimɛ gɛ gɛŋ chuule gɛ, mu mo mu yunɛ. ");
INSERT INTO ncr_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mumu muntaŋ gwe yi mbiaŋ le. Mbiaŋ yiyu kuu yi mo yi baŋɛ muntaŋ muyu. ");
INSERT INTO ncr_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Muntaŋ mumu gwe nyu yi nshɛŋ yì joŋe le, mu buujɛ, mu ku mu yuŋ chuule. Binyi bimi nyu ajii gwii, bimi mbambvusoo, bimi mbanshɛ. ");
INSERT INTO ncr_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Muh wù kɛme bintuŋ, wu yu.” ");
INSERT INTO ncr_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Booŋ be ba ŋgoo ja bo kɛŋsɛ bo gɛɛŋ bo biih wu le lɛ, “Le nje la wù wo jɛme bamii banɛ le nyu a baŋgaŋ le?” ");
INSERT INTO ncr_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Wu chvuu bo le lɛ,“Le bɛŋ ba Nyo le wu ge lɛ taŋlo bɛŋ kee mwɛɛ mu bvunfoŋ bvù fɛwe mù le nyilɛ le. Geenɛ wu baaŋ ge gɛ lɛ taŋlo bamii banɛ kɛɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Bɛŋ kêe lɛ muh wù kɛme fiɛɛ lé ba nyû ba ge ba bisɛ wu kɛme fi duude. Muh wù kɛme gɛ mo fiɛɛ fì shige fì wù kɛme ba lé ba fî lo a wu le. ");
INSERT INTO ncr_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nɛ fiɛɛ fì njɛme bo le nyu a baŋgaŋ le, nje bo jiiŋe gɛh lo mwɛɛ bo yɛde gɛ, bo yege gɛh lo mwɛɛ, bo yuge gɛ, kɛnɛ bo kee gɛ mu gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Fiɛɛ fi muh wu ntuŋ wu Nyo wù Yosaya gɛ̀ jɛme le fi kojɛ chuule bɛ fiɛɛ fì bamii banɛ gee. Wu gɛ̀ jɛme lɛ, ‘Bɛŋ lé bɛŋ yêge mwɛɛ, geenɛ bɛŋ yuge gɛ. Bɛŋ lé bɛŋ jîiŋe mwɛɛ, geenɛ bɛŋ yɛde gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nje muntele mu bamii banɛ le mu jiɛ wa, bintuŋ biboo le bi chiinyɛ wa, bo le bo baŋɛ wa ajii aboo. Bo ge noo lɛ fɛ bo yɛ̂ne mwɛɛ le bɛ ajii aboo gɛ, bo yuge mwɛɛ bɛ bintuŋ biboo gɛ, muntele muboo kee gɛ, bo mo bo kaasɛ bo tu jiŋ fɛ mɛne, nfɛ bo.’ ");
INSERT INTO ncr_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Geenɛ, njoŋ wù baaŋ le wene nje ajii a wene yɛde mwɛɛ le, bintuŋ biɛna yuge mwɛɛ. ");
INSERT INTO ncr_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nsɛŋe bɛŋ nchiɛɛŋ lɛ, bamii ba ntuŋ wu Nyo wesee bɛ bamii ba chaaŋ bamu gɛ̀ shee bo beede ki bo yɛŋ mwɛɛ mù bɛŋ yɛne le, bo gɛ baaŋ yɛŋ gɛ. Bo tu bo beede tɛ ki bo yu mwɛɛ mù bɛŋ yuge, bo gɛ baaŋ yu gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Bɛŋ yu la fiɛɛ fì ŋgaŋ wɛɛ wù kune muh wù gɛ̀ nooŋ muntaŋ duunyi. ");
INSERT INTO ncr_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Muh wù yuge fiɛɛ kune bvunfoŋ bvù fɛwe wu ya kee gɛ kinyi kiyu gɛ, Sataŋ wu muh wu kimbefɛ mo wu to wu chufɛ jɛ yì ba bonɛ fɛ fitele fie le yi bu. Finɛ fiɛɛ le muntaŋ mù ba gɛ̀ doo ba nooŋ mu gwe a je. ");
INSERT INTO ncr_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Muntaŋ mù gɛ̀ gwe fɛ kijusɛ ki ata le, le bamii ba yuge jɛ yi Nyo bo mo bo fi lo kimimia bɛ njoŋ. ");
INSERT INTO ncr_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Geenɛ, yi baaŋ a chimɛ gɛ gɛŋ fɛ muntele muboo le gɛ. Yi lɛme gɛh nɛ shige. Nɛ ŋgɛ le wu to kɛnɛ bamii boone nyu bikaa a wu jiŋ nje jɛ yiyu, wu mo wu chii bikaa kimimia. ");
INSERT INTO ncr_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Muntaŋ mù ba gɛ̀ noŋ mu gwe yi mbiaŋ le, le muh wù yuge jɛ yi Nyo, nfuuŋsɛ wu mwɛɛ mu yi woŋ kfunɛ le, mo bɛ kiŋkoŋɛ ki bvukugɛ taashɛ mu baŋɛ jɛ yiyu yi laayɛ lo achiji. ");
INSERT INTO ncr_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Muntaŋ mù ba gɛ̀ noŋ yì nshɛŋ yi joŋe le, le muh wù yuge jɛ yiyu, wu yuge chuule wù gee no yi goone njɛ muntaŋ mù yuŋ mumu nya ajii gwii, mumu ajii mbambvusoo, mumu mbaanshɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jiso ka wu ma ŋgaŋ wumu bo le lɛ, “Bvunfoŋ bvu fɛwe taŋlo ba beji bɛ muh mu wù gɛ̀ gɛnɛ wu noŋ muntaŋ mù njoŋe mù le mu agiŋ a wù mwɛne. ");
INSERT INTO ncr_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Bamii doo bo leefɛ, muh we wu kimbanɛ gɛɛŋ wu noŋ muntaŋ mu agaaŋ yo mù fiɛɛnɛ mu agiŋ, wu mo wu ja. ");
INSERT INTO ncr_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Agiŋ ayu gɛ̀ doo wo ku wo kɛ wo fuuse, muntaŋ mu agaaŋ mwɛɛ mo mu yɛɛŋ tɛ. ");
INSERT INTO ncr_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Bamii ba lɛme ba muh mwɛ kwɛɛ bo to bo biih wu le lɛ, ‘Chiji kikwɛɛ, wo gɛ̀ doo wo noŋ muntaŋ mwɛne nyu mu agiŋ, mu agaaŋ kanɛ jiɛnyi nɛɛ fɛ mu nyu yu ntɛŋ?’ ");
INSERT INTO ncr_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Wu chvuu bo le lɛ, ‘Ge gɛh muh waŋ wu kimbanɛ fiɛɛ fiyu fiɛɛ.’ Bamii ba lɛme bayu biih wu le lɛ, ‘Wo goone lɛ bee gɛɛŋ be juumɛ?’ ");
INSERT INTO ncr_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Chiji kikwɛɛ wuboo faŋ wu jɛme bo le lɛ, ‘Taŋlo bɛŋ doo bɛŋ juume bɛŋ ja bɛŋ baayi tɛ agiŋ yu ntɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Bɛŋ chînɛ mu ku munchii gɛɛŋ bu kife ki ŋgwejɛ. Nɛ doo nyume kife ki ŋgwejɛ le, ndu bamii ba gweji le lɛ bo ya bo juumɛ agaaŋ ayu bo banyɛ bo yilɛ bo gɛɛ bibi le bibi le, bo ge bo toŋ, bo mo bo banyɛ agiŋ bo gɛɛ a ŋwaŋ waŋ le.’” ");
INSERT INTO ncr_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jiso ka wu ma ŋgaŋ wumu bo le lɛ, “Bvunfoŋ bvu fɛwe le njɛ ŋgo yi fintaŋ fimi, fì muh gɛ̀ jo wu noŋ a wu mwɛne. ");
INSERT INTO ncr_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Fintaŋ finɛ fi nyoonyi ajii baaŋ fi fede muntaŋ munchii. Geenɛ, sege fi bu, fi ku fi kugɛ fi fe munte munchii, fi mo fi ja fi tu kite kì munyii mù fuune we to mu joone yi chɛ́ yiyu le.” ");
INSERT INTO ncr_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Wu ka wu ma ŋgaŋ wumu bo le lɛ, “Bvunfoŋ bvu fɛwe le njɛ kinshilɛ kì kwɛse gɛ̀ fe mune bintee bì baaŋ baaŋ bitɛde, wu jo wu fiiŋsɛ yu, wu tojɛ wu gɛɛ, fi mo fi ge mune chiyu bɛɛnyɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jiso gɛ̀ jɛme mwɛɛ munɛ munchii kinchvu ki bamii le nyu a baŋgaŋ le. Nchiɛɛŋ, gɛ wù gɛ̀ bee ki wu jɛ̂me fiɛɛ bo le fuge a ŋgaŋ le sɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Wu gɛ̀ gee noo, ki fi gê fi kojɛ no muh wu ntuŋ wu Nyo wumu gɛ̀ jɛmɛ wa lɛ, “Sege nlé ŋgwênyɛ jwe waŋ bûde gɛh nyu baŋgaŋ. Nlé ŋgê mbwaashɛ mwɛɛ mù gɛ̀ bee nyilɛ le kɛge no ba gɛ̀ fɛ woŋ.” ");
INSERT INTO ncr_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jiso ja wu chinɛ kinchvu ki bamii le wu lee wu gɛɛŋ yeh. Booŋ be ba ŋgoo bi bo biih wu le lɛ, “Gɛh yuusɛ bee fiɛɛ fì ŋgaŋ kune agaaŋ a mwɛne ayu duunyi.” ");
INSERT INTO ncr_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Wu mo wu jɛmɛ lɛ, “Muh wù nooŋ muntaŋ mù njoŋe le muh wù jee che le Mwamuh. ");
INSERT INTO ncr_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mwɛ le woŋ kfunɛ. Muntaŋ mù njoŋe duunyi booŋ ba le bɛ bvunfoŋ bvu Nyo. Agaaŋ nyu booŋ ba le ba muh wu kimbefɛ wɛɛ. ");
INSERT INTO ncr_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Muh wu kimbanɛ wù gɛ̀ noŋ muntaŋ muyu nyu debele. Kife ki ŋgwejɛ le kife ki woŋ kfunɛ lé wu gê wu ka. Bamii ba ŋgwejɛ le banchɛndaa ba Nyo. ");
INSERT INTO ncr_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Gɛh no bo gɛ̀ juumɛ agaaŋ bo baanyi bo tone bɛ ŋgu, le gɛh yɛɛŋyɛɛŋ no fi lé fi nyûme yi kife kì woŋ lé wu ka. ");
INSERT INTO ncr_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Muh wù jee che le Mwamuh lé wu gê wu chiiŋsɛ banchɛndaa be, bo jiɛnyɛ bo baanyɛ mwɛɛ munchii mù too bɛ kimbefɛ mo bamii ba gee bimbefɛ bachii wu bvusɛ a bvunfoŋ bwe le, ");
INSERT INTO ncr_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","wu noŋ fɛ kimbvulɛ ki ŋgu le. Lé fɛ̂ bamii lé bo gê bo beede bo ŋgeji bige fo. ");
INSERT INTO ncr_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Noo, bamii ba chaaŋ bâaŋ njɛ juu a bvunfoŋ bvu Chiji bo le. Muh wù kɛme bintuŋ wu yû. ");
INSERT INTO ncr_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Bvunfoŋ bvu fɛwe le njɛ nchvu yì muh gɛ̀ jo wu gɛɛŋ wu nyilɛ mwɛne. Muh mu gɛ̀ to wu yɛŋ wu mo wu kaasɛ wu baŋɛ, wu kwɛɛde njoŋ yuu lo wu. Wu mo wu gɛɛŋ wu gesɛ mwɛɛ mwe munchii mù wu gɛ̀ kɛme, wu gɛɛŋ wu gu mwɛ kwɛɛ yu. ");
INSERT INTO ncr_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Bvunfoŋ bvu fɛwe ka nyume njɛ muh wu waaŋ wumu wù gɛ̀ jiɛnyi wu goone ajii a mbele a joŋe nɛ chuule. ");
INSERT INTO ncr_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Wu gɛ̀ doo wu goone, wu gɛɛŋ wu yɛŋ wumu le nyu wu tɛɛme kwa. Wu mo wu gɛɛŋ wu gesɛ mwɛɛ mwe munchii mu wù gɛ̀ kɛme wu gɛɛŋ wu gu jise chi mbele chiyu. ");
INSERT INTO ncr_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Bvunfoŋ bvu fɛwe ka nyume gɛh njɛ gwii wù ba gɛ̀ nooŋ a joo, kfuu chi bíɛŋ yichii taashɛ yu, ");
INSERT INTO ncr_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","wu yisɛ. Bamii mo bo chii bo bvusɛ kwa, bo shii fɛkuu, bo cha bíɛŋ yì joŋe bo gɛɛ a ŋkáa le, bo noŋ yì befe. ");
INSERT INTO ncr_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Lé gɛh no lé tô nyume kife kì woŋ lé wu ka. Banchɛndaa ba Nyo bu bo to bo gasɛ bamii ba befe a ba chaaŋ le, ");
INSERT INTO ncr_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","wu noŋ fɛ kimbvulɛ ki ŋgu le, Lé fɛ̂ bamii lé bo gê bo beede bo ŋgeji bige fo.” ");
INSERT INTO ncr_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jiso mo wu biih booŋ be ba ŋgoo le lɛ, “Bɛŋ le bɛŋ yu mwɛɛ munɛ munchii chuule?” Bo bɛɛŋ lɛ, “Ɛɛŋ.” ");
INSERT INTO ncr_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Wu mo wu jɛmɛ bo le lɛ, “Fi mo fi nyume lɛ, muh wuchii wù duunyi banchi ba Nyo le wù ba le ba yɛyɛ wa wu kune bvunfoŋ bvù fɛwe le njɛ chiji yeh wù kɛme nchvu, wu taŋlo wu bvusɛ mwɛɛ mwe munfɛŋ kɛnɛ mù kege yo.” ");
INSERT INTO ncr_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jiso mɛsɛ wu ma baŋgaŋ banɛ, wu mo wu ja yo, ");
INSERT INTO ncr_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","wu gɛɛŋ ntɛ we le, wu gɛɛŋ wu lee wu tu wu yɛyi bamii yeh yiboo yi buunɛ le. Bo yuge n'yɛyɛ we bo kɛme lo ŋgha, bo mo bo kɛ bo tu bo maŋe lɛ, “Muh wunɛ jo faaŋ bvunɛ bvufee bvù baaŋ bɛ bvuŋga bvù wu gee biŋgha bi mwɛɛ yu nɛ? ");
INSERT INTO ncr_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Le gɛ mwa chiji la wunɛ wu kaane bite? Gɛ bwee nyu Mɛɛle gɛ? Gɛ booŋ ba bwee nyu Jɛm bɛ Yosɛf mo Samoŋ bɛ Juda gɛ? ");
INSERT INTO ncr_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Gɛ jɛ́me ye yichii nyume besa bo fɛnɛ gɛ? Muh wunɛ ja faaŋ bɛ mwɛɛ munɛ munchii nɛ?” ");
INSERT INTO ncr_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","No bo ghaade noo bo mo bo faŋ lo wu. Noo Jiso jɛmɛ bo le lɛ, “Ba to ba ŋgvuune muh wu ntuŋ wu Nyo manjuu le manchii, fuge gɛh woŋ we le, bɛ a kfuu che le.” ");
INSERT INTO ncr_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jiso faŋ ki wu ka wu ge biŋgha bi mwɛɛ yo wesee, nje bo gɛ̀ baaŋ leesɛ gɛ muntele yi wu le gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Gɛ̀ bee kife kiyu le, Nfoŋ Hɛlod wù gɛ̀ sage kimbe ki woŋ kì Galalee le, yu kune lɛme chi Jiso. ");
INSERT INTO ncr_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Wu jɛmɛ bachiji woŋ be le lɛ, muh wunɛ le Joŋ Nlesɛajoo wu kaase wu bu yi kwe le. Nɛ fiɛɛ fì ge fɛ wu kɛ̂me bvuŋga ki wu gêe biŋgha bi mwɛɛ munɛ nɛ. ");
INSERT INTO ncr_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Fi le lɛ, Hɛlod gɛ̀ jɛmɛ lɛ ba koo Joŋ, ba kaaŋ, ba faa yeh yi ncha le, nje Hɛlodia wù kwɛ Filib wù mwa bwe Hɛlod, Hɛlod gɛ̀ jo kwɛɛ le. ");
INSERT INTO ncr_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Joŋ faŋ wu du lɛ nchi baaŋ bɛɛŋ gɛ lɛ wu jo wu kwɛɛ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hɛlod mo wu goone je yì wu yuuyɛ Joŋ yu, geenɛ wu faane bamii, njɛ bamii gɛ̀ kɛme Joŋ njɛ muh wu ntuŋ wu Nyo. ");
INSERT INTO ncr_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Lɛ to nyu juu chi Nfoŋ Hɛlod gɛ̀ gee ŋka ki wu kwâjɛ juu chì ba gɛ̀ boyɛ wu, mwa Hɛlodia wù kwɛse lee wu chɛŋ bine a bamii ba gɛ̀ bee fɛ ŋka wɛɛ le, Hɛlod yɛŋ nɛ ye yufɛ wu. ");
INSERT INTO ncr_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Wu mo wu ka mwa wɛɛ, wu ji leh lɛ wu lé wu fâyɛ wu mo nyu bɛ la fì wu lé wu bîih lɛ wu fayɛ wu yu. ");
INSERT INTO ncr_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Bwe mwa wɛɛ mo wu nyiisɛ mwa wu dû lɛ wu nyâ kikwɛɛ ki Joŋ Nlesɛajoo a kidɛŋ le, wu le. ");
INSERT INTO ncr_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Wu jɛmɛ, Nfoŋ Hɛlod yu noo, ye wooŋ lo wu. Geenɛ nje leh wù wu gɛ̀ ji wa fwe a bamii ba gɛ̀ bee fɛ ŋka wɛɛ le, wu mo wu jɛmɛ lɛ ba ge no mwa ye jɛme. ");
INSERT INTO ncr_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Wu mo wu tuŋ bamii bo gɛɛŋ yeh yi ncha le, bo bvusɛ kikwɛɛ ki Joŋ, ");
INSERT INTO ncr_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","bo to bɛ ki a kidɛŋ le bo nya mwa wù kwɛse wɛɛ le, wu mo wu gɛɛŋ wu nya bwee le. ");
INSERT INTO ncr_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Booŋ ba ŋgoo ba Joŋ gɛɛŋ bo jo gvunɛ chi Joŋ bo jiiyɛ, bo gɛɛŋ bo sɛɛŋ saaka wuyu Jiso le. ");
INSERT INTO ncr_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jiso doo wu yu fiɛɛ fì kooshi bɛ Joŋ, wu mo wu lee a ŋguh le wu kɛŋsɛ yo wu gɛɛŋ fɛ bamii gɛ̀ bee gɛ fo gɛ. Geenɛ binchvu bi bamii yu, bo mo bo bu a bilaantɛŋ le bo jiɛnyi bɛ bikaa bo bii wu le. ");
INSERT INTO ncr_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Wu bu a ŋguh le wu doo wu fɛsɛ kwa, wu yɛŋ kinchvu ki bamii le nɛ mamama. Yii koo wu bɛ bo, wu mo wu tu wu fɛde bamii ba gɛ̀ chɛne. ");
INSERT INTO ncr_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Lɛ doo nyume fɛnfu, booŋ be ba ŋgoo kɛŋsɛ bo jɛmɛ wu le lɛ, “Fɛnɛ le kwa, juu gɛɛŋ wa, du lɛ bamii banɛ gɛɛŋ bantɛ le bo gu mwɛɛ muboo munjile.” ");
INSERT INTO ncr_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jiso chvuu bo le lɛ, “Gɛ fi nyu lɛ bo ja gɛ. Le bɛŋ, bɛŋ lé bɛŋ nyâ bo fiɛɛ fì bo lé bo jî.” ");
INSERT INTO ncr_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Bo chvuu wu le lɛ, “Bee kɛme gɛh nyu chefe yi blɛd yishɛŋ bɛ bíɛŋ yifiɛɛ maa.” ");
INSERT INTO ncr_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Wu jɛmɛ bo le lɛ, “Bɛŋ to bɛŋ nya mɛne.” ");
INSERT INTO ncr_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Wu mo wu du kinchvu ki bamii kiyu le lɛ ki shiiyɛ fɛkuu yi agaaŋ le. Wu jo chefe yi yishɛŋ chiɛɛ bɛ bíɛŋ yi yifiɛɛ, wu bijɛ we, wu nya kiyone Nyo le, wu mo wu bwɛɛyɛ wu nya chefe yiyu booŋ be ba ŋgoo le, bo gajɛ kinchvu kiyu le. ");
INSERT INTO ncr_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bamii bachii ji bo fuu. Booŋ ba Jiso ba ŋgoo baanyɛ bimbɛge bì gɛ̀ shɛshɛ bi yisɛ ŋkáa yuufe ncho yifiɛɛ. ");
INSERT INTO ncr_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bamii ba gɛ̀ ji mwɛɛ munjile muyu gɛ̀ bee bilɛŋsɛ njɛ banchvuge batɛŋ, fɛ nyu bikɛse bɛ booŋ. ");
INSERT INTO ncr_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jiso mo wu jɛmɛ booŋ be ba ŋgoo le lɛ bo lee a ŋguh le bo sa fwe wuŋ kwege, wu shɛ̂ɛ wu yɛsɛ kinchvu ki bamii le lɛ ki kwɛɛde. ");
INSERT INTO ncr_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Wu gɛ̀ shɛɛ wu yɛsɛ bo, wu mo wu ja wu bɛɛŋ yi mbegɛ le wu maa ki wu gɛ̂ɛŋ wu buunɛ. Akfuuŋ gɛ̀ jiiŋ wù nyu gɛh fo wu maa. ");
INSERT INTO ncr_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Geenɛ kife kiyu le, ŋguh gɛ̀ bee wa fɛ joo ntɛnɛɛ je yì ndefe le kwa, joo kɛde bɛ wu, nje fii gɛ̀ too je fwe yi chide wu. ");
INSERT INTO ncr_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Lɛ to nyume wa an'yule, Jiso ja wu too fɛ bo le wu jiɛnyi yi joo le. ");
INSERT INTO ncr_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Booŋ be ba ŋgoo doo bo yɛŋ no wu jiɛnyi yi joo le, njaŋ koo bo. Bo tu bo duu lɛ, “Le kiyi kimu.” Bo tu bo wanɛ fɛwɛɛwe bɛ nfaaŋ. ");
INSERT INTO ncr_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kimimia Jiso mo wu jɛmɛ bo le lɛ, “Bɛŋ jîjɛ muntele mwɛna le, le mɛ. Keefɛ bɛŋ fâane gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Bita jɛmɛ wu le lɛ, “Tada nɛ le wo, wo jɛmɛ njiɛnyɛ tɛ yi joo le nto fɛ wo le.” ");
INSERT INTO ncr_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jiso jɛmɛ wu le lɛ, “Wo, tôo la!” Noo, Bita mo wu bu a ŋguh le wu tu wu jiɛnyi yi joo le wu gɛɛne fɛ Jiso le. ");
INSERT INTO ncr_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","No wu gɛ̀ jiɛnyi wu gɛɛne, wu doo wu yɛŋ no fii gee, wu tu wu faane, wu kɛ wu tu wu shiide a joo. No wu shiide wu mo wu bee lɛ, “Tada fi mɛ!” ");
INSERT INTO ncr_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kimimia Jiso noŋ kibo wu jijɛ wu le, wu jɛmɛ wu le lɛ, “O oo, mbɛmɛ wo baaŋ shige! Wo be kɛme kimaŋɛ nje la?” ");
INSERT INTO ncr_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bɛ wu mo bo bɛɛŋ bo lee a ŋguh le, fii yiyu mo yi lu. ");
INSERT INTO ncr_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Booŋ be ba ŋgoo ba gɛ̀ bee a ŋguh le bo mo bo nya ŋgvunɛ wu le bo jɛmɛ lɛ, “Nchiɛɛŋ, wo le Mwa Nyo.” ");
INSERT INTO ncr_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bo daŋ mamasi bo bu kimbe ki Gɛnesalɛt le kwa. ");
INSERT INTO ncr_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bamii ba yo yɛŋ wu le, bo kɛɛ wu, bo mo bo chiiŋsɛ ntuŋ kimbe kiyu le kichii, bamii tu bo too bɛ bamii ba binchɛŋ bachii fɛ Jiso le, ");
INSERT INTO ncr_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","bo lɛge lɛ wu chînɛ bo kuŋ gɛh nyu jwe wù nju ye le. Muh wuchii wù gɛ̀ kune, mo wu tɛmɛ. ");
INSERT INTO ncr_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Bafalashii bɛ bamii bamu ba gɛ̀ duunyi banchi ba Nyo gɛ̀ ja Yɛlusalɛm bo to fɛ Jiso le bo biih wu le lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Le nje la wù booŋ buŋ ba ŋgoo chɛŋe bɛ kinche ki woŋ ki bachiji besa ba fweele? Gɛ bo chuge chiaaŋ a je yì nchi goone le, fɛ bo jii mwɛɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jiso chvuu bo le lɛ, “Le nje la wù bɛŋ ŋgode fiena banchi ba Nyo, bɛŋ bii nyu kinche kena ki woŋ le? ");
INSERT INTO ncr_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Njɛme nɛ, nje Nyo le wu du lɛ, ‘Ŋgvuuŋ chijo bɛ bwoo.’ Wu ka wu du tɛ lɛ, ‘Nɛ muh naŋ lo chiji kɛnɛ bwee, ba yuuyɛ lo mwɛdɛ.’ ");
INSERT INTO ncr_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Geenɛ, bɛŋ tu bɛŋ duu fiena lɛ, ‘Nɛ muh ja wu jɛme chiji le kɛnɛ bwee le lɛ, “Fiɛɛ fì wo bee wo kɛme chiaaŋ yaŋ le nnya wa Nyo le”, tu gɛ taŋlo bɛŋ ka bɛŋ jo fiɛɛ fiyu bɛŋ fih chiji wene yu kɛnɛ bwee wene yu gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Le nɛ no bɛŋ bii kinche kena ki woŋ le bɛŋ gee jɛ yi Nyo tuu fiɛɛ fì achiji. ");
INSERT INTO ncr_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Bamii ba jɛme yeye bo gee yeye banɛ. Fiɛɛ fì muh wu ntuŋ wu Nyo wù Yosaya gɛ̀ jɛme kune bɛŋ le nchiɛɛŋ, no wu gɛ̀ jɛmɛ lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Bamii banɛ ŋgvuune mɛ gɛh fɛmu fɛmu, muntele muboo nyu je yì ndefe le fɛ mɛne. ");
INSERT INTO ncr_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bo yuuse mɛ nyu achiji, nje bo jode mwɛɛ mù bamii kwaji bo yɛyi lɛ le jɛ yaŋ.’” ");
INSERT INTO ncr_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jiso ja wu tɛɛŋ bamii bo to. Wu jɛmɛ bo le lɛ, “Bɛŋ yêgɛ bɛŋ yû, bɛŋ kɛ̂ɛ chuule. ");
INSERT INTO ncr_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Gɛ fiɛɛ fì lese a muh mu taŋlo fi yiisɛ wu gɛ. Le fiɛɛ fì bude lo a muh mu fì taŋlo fi yiisɛ wu.” ");
INSERT INTO ncr_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Booŋ ba Jiso ba ŋgoo ja bo to bo jɛmɛ wu le lɛ, “Wo kee gɛ lɛ Bafalashii be bo yu fiɛɛ fì wo be jɛme fiɛɛ fì gwe fɛ fitele fiboo le?” ");
INSERT INTO ncr_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Wu chvuu bo le lɛ, “Kite kichii kì le njɛ yile chii wù le fɛwe sɛŋ ba lé ba bâa. ");
INSERT INTO ncr_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bɛŋ daayɛ a bo le, le binfeeŋ bì duunyi je bamii le. Nɛ kinfeeŋ duunyi je kimi le, tu bo bachii lé bo gɛ̂ɛŋ bo gwe a kintuge le.” ");
INSERT INTO ncr_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Bita jɛmɛ Jiso le lɛ, “Gɛh yuusɛ bee fiɛɛ fì ŋgaŋ wɛɛ jɛme.” ");
INSERT INTO ncr_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jiso biih lɛ, “Gɛ bɛŋ tɛ kee mwɛɛ gɛ? ");
INSERT INTO ncr_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Gɛ bɛŋ kee lɛ fiɛɛ fichii fì lese a muh mu boge a shɛŋ fi ge fi fe fi bu lo gɛ? ");
INSERT INTO ncr_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Geenɛ, fiɛɛ fì bude jwe wu muh le jade nyu fɛ fitele le. Le fi fì yiise muh. ");
INSERT INTO ncr_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Fi jade nyu fɛ fitele le fɛ muh kɛme ŋkwajɛ wù befe, ki muh yu muh, ki muh jo kwɛ muh kɛnɛ juma muh, muh jaŋ kinjaŋ, ki muh choŋ bvuchoŋ, ki muh bɛɛ jiŋ yi nsa wu chimbiaŋ, kɛnɛ ki muh chɛŋɛ bɛ jee chi muh. ");
INSERT INTO ncr_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Munɛ le mwɛɛ mù taŋlo mu yiisɛ muh. Gɛ ki muh ji bɛ chiaaŋ njɛ wu chugɛ sɛŋ taŋlo fi yiisɛ muh gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jiso ja fo wu kɛŋsɛ yo wu gɛɛŋ kimbe ki Taya bɛ Sidoŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Fi kooshɛ lɛ kwɛse wumu wu Kanan wù gɛ̀ bee yo gɛ̀ ja wu to wu yɛŋ Jiso le, wu bee fɛ wu le lɛ, “O Tada, mwa Nfoŋ Dabi, koo yii fɛ mɛne. Mwa yaŋ wù kwɛse le nchɛndaa wu debele fiinɛ bɛ wu baaŋ.” ");
INSERT INTO ncr_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Geenɛ Jiso yu wu gɛ ghaa lo gɛ. Booŋ be ba ŋgoo kɛŋsɛ bo to bo lɛgɛ wu bo jɛmɛ lɛ, “Du kwɛse wunɛ le lɛ wu gɛ̂ɛne. Wu bii wu nyaa njiɛɛsɛ bee le.” ");
INSERT INTO ncr_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jiso chvuu lɛ, “Ba gɛ̀ tuŋ mɛ nyu fɛ bamii ba Ishwala le maa ba le njɛ shóŋ yi ja wa yi lɛsɛ lo.” ");
INSERT INTO ncr_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Geenɛ kwɛse wɛɛ ja gɛh wu to wu tuŋ anyuu a Jiso jii wu jɛmɛ lɛ, “Tada, fih gɛh mɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jiso chvuu wu le lɛ, “Gɛ fi nyu chuule ki jo ŋgu yi booŋ noŋ bvú le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kwɛse wuyu jɛmɛ lɛ, “Le nchiɛɛŋ chii. Geenɛ bvú to yi boonyi munchvuge mu chiji bo sege wu jii mu gweeyi.” ");
INSERT INTO ncr_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jiso mo wu chvuu wu le lɛ, “O kwɛse wunɛ, mbɛmɛ wo tɛɛme lo. Fi kooshɛ fɛ wo le no wo goone.” Gɛh noo mwa ye mo wu tɛmɛ. ");
INSERT INTO ncr_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jiso gɛ̀ ja fo wu gɛɛne, wu fede mbebe Mamasi wu Galalee le, bo bɛɛŋ bo gɛɛŋ yi mbegɛ le, wu shii fo. ");
INSERT INTO ncr_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kinchvu kì bamii ki baaŋ to fɛ wu le nɛ gɛmm. Bamu gɛ̀ too bɛ bamii ba le batɛŋlaase, mo ba le biŋkɛlɛ, mo ba le binfeeŋ, mo ba le binchifɛ, mo bamu ba chɛne wesee. No bo too bɛ bo, bo gɛɛde a wu jii wu fɛde bo. ");
INSERT INTO ncr_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kinchvu kiyu tu ki kɛme lo kimaŋe no bo gɛ̀ yɛde binchifɛ jɛme, bamii ba le biŋkɛlɛ tɛɛme, batɛŋlaase jiɛnyi tɛ chaaŋ, binfeeŋ yɛde mwɛɛ le. Bo tu bo tume maŋkuŋ ma Nyo wu bamii ba Ishwala. ");
INSERT INTO ncr_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jiso tɛɛŋ booŋ be ba ŋgoo wu jɛmɛ bo le lɛ, “Ŋkɛme yii fɛ kinchvu kinɛ le, nje bo le wa besa bo aju atade, fiɛɛ fì bo ji nyume gɛ yu gɛ. Gɛ ŋkoŋe lɛ nchinɛ bo le bo gɛɛne jɛŋ gɛ, nje taŋlo bo gɛɛŋ bo gwe jɛŋ aje.” ");
INSERT INTO ncr_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Booŋ be ba ŋgoo jɛmɛ wu le lɛ, “Taŋlo besabɛŋ jo faaŋ mwɛɛ munjile nchvuuŋ kfunɛ mù kojɛ ki ba nyaŋɛ kfuu chi kinchvu ki bamii kinɛ yu?” ");
INSERT INTO ncr_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jiso biih bo le lɛ, “Bɛŋ kɛme chefe yi blɛd yimiɛɛ?” Bo chvuu lɛ, “Le bvusooshwi bɛ bíɛŋ nɛ shige.” ");
INSERT INTO ncr_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jiso mo wu du lɛ kinchvu ki bamii kiyu shii fɛkuu ");
INSERT INTO ncr_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Bo shiiyɛ, wu jo chefe yi blɛd yi bvusooshwi chiɛɛ mo bíɛŋ chiɛɛ, wu nya kiyone Nyo le, wu bwɛɛyɛ wu nya booŋ be ba ŋgoo le, bo gajɛ bamii bayu le. ");
INSERT INTO ncr_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Muh wuchii ji, wu fuu. Bo baanyɛ bimbɛge bì gɛ̀ shɛshɛ, bi yisɛ ŋkáa bvusooshwi. ");
INSERT INTO ncr_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bamii ba gɛ̀ ji gɛ̀ bee bilɛŋsɛ banchvuge banɛh, fɛ nyu bikɛse bɛ booŋ. ");
INSERT INTO ncr_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Wu mo wu chinɛ kinchvu kiyu le ki kwɛɛde. Wu lee a ŋguh le wu gɛɛŋ kimbe ki Magadaŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Bafalashii bɛ Basadushii ja bo to fɛ Jiso le ki bo moŋ wu, bo mo bo jɛmɛ lɛ wu ge fiɛɛ fì duunyi bvuŋga bvù ja fɛwe. ");
INSERT INTO ncr_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jiso chvuu bo le lɛ, “Ge doo nyume sege juu seele kibvulɛ yɛɛde lo, bɛŋ du lɛ, ‘Akfuuŋ bude wo joŋ’, nje bɛŋ le bɛŋ yɛŋ lɛ kibvulɛ yɛɛde lo. ");
INSERT INTO ncr_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ge doo nyume sege juu saane, kibvulɛ yɛɛde, kimbɛ shugɛ, bɛŋ du lɛ, ‘Nfuŋ lé wu fê abɛŋ’, nje bɛŋ le bɛŋ yɛŋ kibvulɛ yɛɛde kimbɛ shugɛ. Bɛŋ kee ki bɛŋ jîŋɛ kibvulɛ bɛŋ mo bɛŋ kɛɛ no akfuuŋ lé a nyûme, geenɛ bɛŋ ya kee gɛ banjiŋɛ ba mwɛɛ mù kooshi yi kife kinɛ le duunyi gɛ nje la? ");
INSERT INTO ncr_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kiŋgogɛ kì befe kinɛ kì le ki chinɛ wa Nyo le ki tu njɛ kwɛse wu kinjikuu, ki goone fiɛɛ fì duunyi bvuŋga bvu jade fɛwe. Gɛ taŋlo ndunyɛ fiɛɛ ki le, fede fi muh wu ntuŋ wu Nyo wù Jona gɛ.” No wu jɛmɛ noo wu mo wu chinɛ bo le wu ja wu gɛɛne. ");
INSERT INTO ncr_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Booŋ ba Jiso ba ŋgoo doo bo fɛsɛ wuŋ kwege bo yɛŋ lɛ bo le bo daayɛ ki bo jo blɛd. ");
INSERT INTO ncr_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jiso jɛmɛ bo le lɛ, “Bɛŋ yɛ̂ne, bɛŋ ka jode kife yi kinshilɛ ki Bafalashii mo ki Basadushii le.” ");
INSERT INTO ncr_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Booŋ be ba ŋgoo mo bo kɛ bo jɛme lɛbolɛbo kune fiɛɛ fiyu, bo duu lɛ, “Wu jɛme kinshilɛ kinɛ nɛ nje besabɛŋ baaŋ to gɛ bɛ blɛd gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jiso kɛɛ fiɛɛ fì bo jɛme kune fi wu mo wu jɛmɛ lɛ, “O oo bamii ba mbɛmɛ wù shige banɛ! Bɛŋ jɛme lɛbɛŋlɛbɛŋ kune blɛd wù bɛŋ baaŋ kɛme gɛ nje la? ");
INSERT INTO ncr_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Bɛŋ baaŋ mwɛɛ le a yɛŋ gɛ? Gɛ bɛŋ kwaji chefe yi blɛd yishɛŋ yì bamii chi ji banchvuge batɛŋ gɛ? Bimbɛge bì bɛŋ chi baanyɛ chi bee ŋkáa yimiɛɛ? ");
INSERT INTO ncr_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Gɛ bɛŋ ka kwaji tɛ chefe yi blɛd yì bvusooshwi yì bamii chi ji banchvuge banɛh gɛ? Bɛŋ chi bɛŋ baanyɛ bimbɛge bu ŋkáa yimiɛɛ? ");
INSERT INTO ncr_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ge la lɛ bɛŋ baaŋ kɛɛ gɛ lɛ njɛme nyu kune blɛd gɛ? Ŋka njɛme gɛh lɛ bɛŋ jôde kife kune kinshilɛ ki Bafalashii bɛ Basadushii.” ");
INSERT INTO ncr_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","No wu jɛme noo bo mo bo kɛɛ lɛ gɛ wu jɛme lɛ bo jode kife nyu kune kinshilɛ kì ba toji blɛd yu gɛ, lɛ wu jɛme nyu kune n'yɛyɛ wu Bafalashii bɛ Basadushii. ");
INSERT INTO ncr_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jiso gɛ̀ gɛɛŋ wu bu kimbe ki woŋ wù Kasalia wu Filibi le, wu ja wu biih booŋ be ba ŋgoo le lɛ, “Bamii duu lɛ muh wù jee che le Mwamuh le yɛɛŋ?” ");
INSERT INTO ncr_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bo chvuu wu le lɛ, “Bamii bamu duu lɛ wo le Joŋ Nlesɛajoo, bamu lɛ le Alaja, bamu duu lɛ wo le Yɛlimia kɛnɛ muh wu ntuŋ wu Nyo wumu.” ");
INSERT INTO ncr_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Wu biih bo le lɛ, “Bɛŋ duu fiena lɛ nle yɛɛŋ?” ");
INSERT INTO ncr_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Samoŋ Bita chvuu lɛ, “Wo le Mbvusɛ wù Nyo gɛ̀ ka wu le Mwa Nyo, Nyo wù kɛme kinche.” ");
INSERT INTO ncr_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jiso chvuu wu le lɛ, “Samoŋ mwa Jona, Nyo le wu buu wo, nje gɛ finɛ sɛŋe muh wu wuŋ wo le gɛ, sɛŋe chii wù le fɛwe wo le. ");
INSERT INTO ncr_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ntu jɛme wo le lɛ wo le Bita,le yi kimbaaŋ kinɛ le kì nlé ŋgê njooŋ kintaashɛ kaŋ ki bamii ba mbɛmɛ yu. Gɛ bvuŋga bvu woŋ wu baŋkfu taŋlo bvu yu bvu ya kintaashɛ kiyu gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nlé nnyâ biŋgwenyɛ bi bvunfoŋ bvù fɛwe wo le. Fiɛɛ fì wo le wo kaaŋ fɛkuu fɛnɛ, tu ba le ba kaaŋ wa fɛwe. Fiɛɛ fì wo le wo faanyɛ fɛkuu fɛnɛ, tu ba le ba faanyɛ wa fɛwe.” ");
INSERT INTO ncr_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","No Jiso jɛmɛ noo, wu mo wu chiisɛ lo booŋ be ba ŋgoo le lɛ keefɛ bo môŋ bo sɛ̂ɛŋ muh le lɛ wu le Mbvusɛ wù Nyo gɛ̀ ka gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kɛge yi kife kɛɛ le, Jiso mo wu kɛ wu duunyi booŋ be ba ŋgoo le lɛ wu kɛme ki wu gɛ̂ɛŋ gɛh Yɛlusalɛm. Wu gɛɛŋ wu yɛŋ baŋgɛ ba duude chiaaŋ yi bamii ba sage woŋ bɛ bachiji kintanyɛ ba baaŋ baaŋ mo bamii ba duunyi banchi ba Nyo. Bo mo bo yuuyɛ wu, aju atade wu kaasɛ wu bu yi kwe le. ");
INSERT INTO ncr_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Bita mo wu jo wu bɛ wu kɛŋsɛ. Wu mo wu kɛ wu wame wu yi fiɛɛ fiyu le, wu duu lɛ, “Tada, Nyo ŋgaŋsɛ. Gɛ finɛ fiɛɛ nyu fi yu fi kooshɛ bɛ wo gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jiso kaasɛ ye wu jɛmɛ Bita le lɛ, “Ja a mɛ jiŋ Sataŋ! Wo jeese lo mɛ nje gɛ wo lɛme yi kimbe ki Nyo le gɛ. Wo lɛme nyu yi ki muh wu wuŋ le.” ");
INSERT INTO ncr_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","No Jiso jɛme noo, wu mo wu jɛmɛ booŋ be ba ŋgoo le lɛ, “Muh nɛ goone ki wù nyu muh waŋ wu ŋgoo, tu wù kɛme ki wu fâŋ kikwɛɛ ke, wu tuu kintaaŋ ke wu bii mɛne. ");
INSERT INTO ncr_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Bɛŋ kêe lɛ muh wu baji kinche ke lé wu lɛ̂sɛ lo ki. Geenɛ muh wu le wu lɛsɛ kinche ke nje mɛ, lé wu gê wù kɛme kinche. ");
INSERT INTO ncr_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nɛ ba banyi woŋ kfunɛ wuchii, ba nya muh le lɛ wu ji, wu to wu lɛsɛ kinche ke, mbe we nyume la? Noo, fiɛɛ le yu fì taŋlo muh suuŋ kiyo ke yu le? ");
INSERT INTO ncr_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Bɛŋ kêe lɛ muh wù jee che le Mwamuh lé wu gê wu tô bɛ banchɛndaa be a bvukugɛ bvu chiji le, wu mo wu laŋɛ muh wuchii yi fiɛɛ fì muh le wu ge le. ");
INSERT INTO ncr_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nsɛŋe bɛŋ nchiɛɛŋ lɛ bamii bamu lɛme fɛnɛ gɛ bo nyu bo to bo yu wuŋ wu kwe gɛ, fuge njɛ bo yɛŋ muh wu jee che le Mwamuh too bɛ bvunfoŋ bwe gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Aju fe bvusoo, Jiso jo Bita bɛ Jɛm mo Joŋ wù mwa bwe Jɛm, bɛ bo bɛɛŋ yi mbegɛ wumu wù ndefe fɛwe le, bo tu bo nyu fo lɛbolɛbo. ");
INSERT INTO ncr_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Bo ja bo yɛŋ nfiɛɛnɛ ye kusɛ a bo jii, bvushi bwe tu bvu baaŋ bvu lale njɛ juu, njú ye baaŋ tɛ yi lale nɛ mwamwamwa. ");
INSERT INTO ncr_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Fi kooshɛ lɛ Musɛ bɛ Alaja gɛ̀ ja bo bunɛ fɛ bo le, bo tu bo jɛme bɛ Jiso. ");
INSERT INTO ncr_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Bita mo wu ja gɛh nɛ wu jɛmɛ Jiso le lɛ, “Tada, fi joŋe no bee le fɛnɛ. Nɛ wo koŋe lo njooŋ chúŋ fɛnɛ yishɛde, yimi nyu yo, yimi yi Musɛ, yimi yi Alaja.” ");
INSERT INTO ncr_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Gɛh no wu baaŋ wu jɛme, fi kooshɛ lɛ kimbɛ kì baaŋ nɛ bvuuu ja ki to ki baŋɛ bo, jɛ jɛmɛ a kimbɛ kiyu le lɛ, “Wunɛ le mwa yaŋ, wu le fitele fiaŋ. N'yuge njoŋ bɛ wu baaŋ. Bɛŋ yûge nyu wu le.” ");
INSERT INTO ncr_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Booŋ be ba ŋgoo doo bo yu jɛ yiyu njaŋ koo bo, bo gwe fɛkuu bo tuŋ manshi fɛkuu. ");
INSERT INTO ncr_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Geenɛ Jiso gɛɛŋ wu kuŋ bo le wu jɛmɛ lɛ, “Bɛŋ jâ we! Keefɛ bɛŋ fâane gɛ!” ");
INSERT INTO ncr_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Bo doo bo chiaasɛ ajii we bo gɛ ka bo yɛŋ muh mu le gɛ nyu gɛh Jiso. ");
INSERT INTO ncr_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Bo ja yi mbegɛ wɛɛ le bo doo bo boge, Jiso lejɛ bo le lɛ, “Keefɛ bɛŋ môŋ bɛŋ sɛ̂ɛŋ fiɛɛ fì ajii a wene be yɛŋ le njɛ muh wù jee che le Mwamuh le wu bu wa yi kwe le sɛŋ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Booŋ be ba ŋgoo biih wu le lɛ, “Le nje la wu bamii ba duunyi banchi duu lɛ Alaja kɛme ki wu yâ wu to fɛ Mbvusɛ wù Nyo gɛ̀ ka ge wu to?” ");
INSERT INTO ncr_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jiso chvuu bo le lɛ, “Le nchiɛɛŋ lɛ Alaja kɛme ki wu yâ wu to wu kɛnyɛ mwɛɛ munchii. ");
INSERT INTO ncr_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Geenɛ nsɛŋe bɛŋ le lɛ Alaja le wu to wa bo baaŋ wu kɛɛ gɛ, bo mo bo ge fiɛɛ fì bo koŋe bɛ wu. Nyu gɛh yɛɛŋyɛɛŋ no muh wù jee che le Mwamuh lé wu gê wu yɛŋ ŋgɛ chiaaŋ yiboo le.” ");
INSERT INTO ncr_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","No wu jɛmɛ noo, booŋ be ba ŋgoo mo bo kɛɛ lɛ wu jɛme nyu kune Joŋ Nlesɛajoo. ");
INSERT INTO ncr_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jiso bɛ booŋ be ba ŋgoo gɛ̀ boh bo fɛsɛ fɛ kinchvu ki bamii gɛ̀ bee fo. Muh mu ja wu to wu tuŋ anyuu a Jiso fwe, wu jɛmɛ wu le lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Tada, koo yii fɛ mwa yaŋ le. Wu gwee kika, wu yɛne ŋgɛ baaŋ. Wu jade wu gwe fɛntaŋ, wu ja wu gwe a joo le. ");
INSERT INTO ncr_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mbe nto bɛ wu fɛ booŋ buŋ ba ŋgoo le bo moŋ sɛŋ ki bo fɛ wu.” ");
INSERT INTO ncr_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jiso jɛmɛ lɛ, “O oo! Kiŋgogɛ kì achiji kì baaŋ lee gɛ fitele yi Nyo le gɛ. Nlé ŋgê nyûme bɛ bɛŋ ŋgɛ̂ɛŋ mbû nɛɛ? Nlé ŋkâaŋ shɛ́ŋ bɛ bɛŋ ŋgɛ̂ɛŋ mbû nɛɛ? Bɛŋ to bɛ mwa wuyu fɛnɛ bɛŋ nya mɛne.” ");
INSERT INTO ncr_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Bo gɛɛŋ bɛ wu, Jiso waŋ nchɛndaa wu debele wù gɛ̀ bee yi mwa wɛɛ le wu bu, wu mo wu tɛmɛ lo kimimia. ");
INSERT INTO ncr_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Booŋ ba Jiso ba ŋgoo gɛ̀ gɛɛŋ fɛ wu le ajiŋ ajiŋ, bo biih wu le lɛ, “Le nje la wù bee be moŋ sɛŋ ki be bvusɛ nchɛndaa wu debele wɛɛ?” ");
INSERT INTO ncr_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Wu chvuu bo le lɛ, “Le nje mbɛmɛ wene le shige. Nsɛŋe bɛŋ nchiɛɛŋ lɛ, bɛŋ nɛ be kɛme mbɛmɛ wù le gɛh njɛ shaŋ yi nsuu,taŋlo bɛŋ du mbegɛ wunɛ le lɛ wu mugɛ fɛnɛ wu gɛɛŋ wu lɛɛŋ fɛge, wu mugɛ, fiɛɛ gɛ ya fi nyu yu fì taŋlo fi ya bɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Geenɛ, gɛ kfuu chi wunɛ nchɛndaa wu debele taŋlo wu bu njɛ muh buune wu shee yuuŋ chi mwɛɛ munjile sɛŋ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","No Jiso bɛ booŋ be ba ŋgoo gɛ̀ taashɛ Galalee, wu jɛmɛ bo le lɛ, “Muh wù jee che le Mwamuh lé ba nyû ba ge ba nyâ wu chiaaŋ yi bamii le, ");
INSERT INTO ncr_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ba yûuyɛ wu, doo nyume aju atade, wu bû yi kwe le.” Lɛ bo yu noo, ye wooŋ bo baaŋ. ");
INSERT INTO ncr_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jiso bɛ booŋ be ba ŋgoo gɛɛŋ bo bu Kafanahum, bamii ba gɛ̀ koode ŋwa wu yeh yi kintanyɛ le gɛ̀ to bo yɛŋ Bita le bo soge wu le lɛ, “Muh wene wu n'yɛyɛ too gɛh wu nooŋ ŋwa wu yeh yi kintanyɛ le?” ");
INSERT INTO ncr_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Wu bɛɛŋ lɛ, “Ɛɛŋ.” Bita gɛ̀ doo wu tu fɛ yeh le, yaŋsɛ Jiso wu giŋsɛ fiɛɛ fiyu fɛkuu, wu biih wu le lɛ, “Samoŋ, wo yɛde fiuŋ lɛ la? Banfoŋ ba fɛkuu fɛnɛ to bo koode ŋwa, bo ka bo fii kinsu nyu a baaŋ le? Bo to bo fii a booŋ baboo le noo, a bantolo le le?” ");
INSERT INTO ncr_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Bita chvuu lɛ, “Bo to bo fii nyu a bantolo le.” Jiso jɛmɛ wu le lɛ, “Tu gɛ booŋ baboo kɛme ki bo laaŋe gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Geenɛ, fi le lɛ keefɛ besa wo tɛnɛ muntele mu bamii banɛ gɛ, gɛnɛ wo noŋ ŋgwe a mamasi le, biɛŋ yì wo le wo ya wo koo, wo gwênyɛ jwe wuyu, wo yɛŋ jise chi bige le yo, wo mo wo bvusɛ wo gɛɛŋ wo nya bo le ki wo lâŋɛ ŋwa wese besa wo yu.” ");
INSERT INTO ncr_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kife kiyu le, booŋ ba Jiso ba ŋgoo biih wu le lɛ, “Muh wù kuge wu fede muh wuchii antɛnɛɛ a bvunfoŋ bvù fɛwe le, le wù la?” ");
INSERT INTO ncr_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jiso mo wu tɛɛŋ mwa wu shige wu leesɛ a bo ntɛnɛɛ, ");
INSERT INTO ncr_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","wu jɛmɛ lɛ, “Nsɛŋe bɛŋ nchiɛɛŋ lɛ, bɛŋ baaŋ kusɛ gɛ bɛŋ tu njɛ booŋ ba shige shige gɛ, tu gɛ bɛŋ nyu bɛŋ to bɛŋ lee fɛ bvunfoŋ bvù fɛwe le gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nɛ le yɛɛŋ wu le wu jo kikwɛɛ ke fɛkuu wu tu njɛ mwa wunɛ, tu wu le muh wù kuge antɛnɛɛ a bvunfoŋ bvù fɛwe ");
INSERT INTO ncr_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nɛ muh fii mwa njɛ wunɛ a jee chaŋ le, tu wu fii nyume mɛ. ");
INSERT INTO ncr_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Geenɛ, kɛnɛ nyume yɛɛŋ wù ge mwa wù shige wù lese fitele ye yaŋ le, wu ge kimbefɛ, fi joŋe fɛ wuwɛɛ muh le lɛ ba shɛŋshɛ kibwee ki jɛnɛ a kindoŋ ke le, ba tooŋsɛ wu wu shii wu gɛɛŋ a joo yì baaŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ŋgɛ wù baaŋ le fɛ bamii ba yi woŋ kfunɛ le. Mwɛɛ mù tele bamii fɛ bo gee bimbefɛ kɛme gɛh ki mu nyûme yu. Geenɛ, ŋgɛ wù baaŋ le fɛ muh wù too bɛ mu le. ");
INSERT INTO ncr_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nɛ kibo kuŋ kɛnɛ kikaa kuŋ gee wo gee kimbefɛ, wo suunɛ kibo kiyu kɛnɛ kikaa kiyu wo noŋ. Fi joŋe lɛ wo ge wo lee kinche kì kage gɛ le bɛ kibo kɛnɛ kikaa kiŋkfunɛ, fede ki wo kɛ̂me chiaaŋ yichii kɛnɛ bikaa bichii ba to ba jo wo ba noŋ yi ŋgu wù kage gɛ le. ");
INSERT INTO ncr_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nɛ jise chuŋ gêe wo gee kimbefɛ, wo bvûsɛ jise chiyu wo noŋ. Fi joŋe lɛ wo lee kinche kì kage gɛ le bɛ jise chimimia, fede ki wo kɛ̂me ajii achii, ba noŋ wo ŋgu wù baaŋ le.” ");
INSERT INTO ncr_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Bɛŋ yɛ̂ne lɛ keefɛ bɛŋ jôde booŋ ba shige shige banɛ fɛkuu gɛ. Nsɛŋe bɛŋ le lɛ fɛwe banchɛndaa ba Nyo ba shee bɛ bo, bo nyu segechii fwe a Chii wu fɛwe le. ");
INSERT INTO ncr_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Muh wù jee che le Mwamuh gɛ̀ to ki wu bvûsɛ bamii ba lɛsɛ wa. ");
INSERT INTO ncr_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Bɛŋ kwaji lɛ la? Nɛ muh kɛme shóŋ gwii, yimimia nɛ le yi lɛsɛ a yi ntɛnɛɛ, wu gɛ ya wu chinɛ yi mbaŋbvuugɛ ncho bvuugɛ le, mbegɛ le, wu gɛɛŋ wu gooŋ shoŋ yi yimimia yì lɛsɛ yɛɛ sɛŋ gɛ? ");
INSERT INTO ncr_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nsɛŋe bɛŋ nchiɛɛŋ lɛ, nɛ wu le wu gooŋ wu yɛŋ, wu yuge njoŋ bɛ shoŋ yi yimimia yɛɛ fede yi mbaŋbvuugɛ ncho bvuugɛ yì be baaŋ lɛsɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Le gɛh yɛɛŋyɛɛŋ tɛ no Chijaŋ wù le fɛwe goone gɛ lɛ muh wu mumwaa ŋgoo yi booŋ ba shige shige banɛ le wu lɛsɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Nɛ mwa bwoo le wu ge fiɛɛ fì befe fɛ wo le, wo gɛɛŋ wo yɛŋ wu le wo dunyɛ jialɛ che wu le gɛh bena wu bafɛɛ. Wu nɛ le wu yu fiɛɛ fì wo jɛme, tu wo le wo kaasɛ wa wo kɛme mwa bwoo jiŋ. ");
INSERT INTO ncr_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Wu nɛ baaŋ yu gɛ fiɛɛ fì wo jɛme gɛ, wo jo muh wu mumwaa kɛnɛ bafɛɛ bena bo kaasɛ bɛŋ gɛɛŋ fɛ wu le, fi le lɛ njɛmɛ wuchii kɛ̂me bamii bafɛɛ kɛnɛ batɛde bo bɛɛ jiŋ yi nsa wuyu. ");
INSERT INTO ncr_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Wu nɛ le wu gɛɛŋ wu faŋ ki wu yû fiɛɛ fì bo jɛme, wo jo wu mɛɛse wo gɛɛŋ fɛ kintaashɛ ki bamii ba mbɛmɛ le. Wu faŋ ki wu yû mo fɛ kintaashɛ ki bamii ba mbɛmɛ le, wo jo wu njɛ muh wù kee gɛ Nyo gɛ kɛnɛ njɛ muh wù koode ŋwa. ");
INSERT INTO ncr_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nsɛŋe bɛŋ nchiɛɛŋ lɛ fiɛɛ fì bɛŋ le bɛŋ kaaŋ fɛkuu fɛnɛ, tu ba le ba kaaŋ wa fɛwe, fiɛɛ fì bɛŋ le bɛŋ faanyɛ fɛkuu fɛnɛ, tu ba le ba faanyɛ wa fɛwe. ");
INSERT INTO ncr_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ŋka njɛme bɛŋ le lɛ, nɛ bamii bafɛɛ a bɛŋ ntɛnɛɛ nɛ bɛme yi fiɛɛ le fɛkuu fɛnɛ, bo lɛgɛ a buunɛ le, tu Chii wù le fɛwe lé wu gê fiɛɛ fiyu fɛ bo le. ");
INSERT INTO ncr_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Bɛŋ kêe lɛ fɛ bamii bafɛɛ kɛnɛ batɛde le bo taashɛ fo a jee chaŋ le, tu nle a bo ntɛnɛɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Bita mo wu kɛŋsɛ wu biih Jiso le lɛ, “Tada, le kiŋgane kimɛɛ kì mwa bwɛɛŋ gee mwɛɛ mù mbefe mɛne, nlɛɛshɛ gɛh lo? Taŋlo wu ge, gɛɛŋ bu kiŋgane kinsooshwi?” ");
INSERT INTO ncr_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jiso chvuu wu le lɛ, “Gɛ taŋlo ndu wo le lɛ, taŋlo nyu gɛh kiŋgane kinsooshwi maa gɛ. Taŋlo nyu kiŋgane mbaŋbvusooshwi chikɛ bvusooshwi. ");
INSERT INTO ncr_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nɛ fiɛɛ fì ba taŋlo ba fe bvunfoŋ bvù fɛwe bɛ Nfoŋ wumu wù gɛ̀ goone ki wu sêesɛ bɛ bamii be ba lɛme ba kwa we gɛ̀ bee chiaaŋ yiboo le. ");
INSERT INTO ncr_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","No wu gɛ̀ kɛ ki wu tâade, bo to bɛ muh mu, ye fioo gɛ̀ bee bikɛɛ bi bige banchvuge yuufe. ");
INSERT INTO ncr_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","No bi gɛ̀ ya wu ki wu lâŋɛ, Nfoŋ wɛɛ mo wu jɛme lɛ ba jo wu bɛ kwɛɛ mo booŋ mo mwɛɛ mwe munchii ba gesɛ ba to bɛ bige biyu ba laŋɛ fioo ye yu. ");
INSERT INTO ncr_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","No Nfoŋ wɛɛ jɛme noo, muh wɛɛ gwe a wu jii wu ku chiaaŋ wu le, wu jɛmɛ lɛ, ‘Tada, koo gɛh yii bɛ mɛ, nlé ŋgê nlâŋɛ fiɛɛ fichii.’ ");
INSERT INTO ncr_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Yii koo chiji kikwɛɛ wɛɛ wu chinɛ wu le wu daayɛ lo a fioo yɛɛ le. ");
INSERT INTO ncr_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Geenɛ, muh wɛɛ kibɛɛ bu wu doo wu gɛɛne, wu bu yi muh mu le wù bɛ bo gɛ̀ lɛne Nfoŋ wɛɛ le, wu gɛ̀ kɛme wu fioo kikɛɛ ki bige kimimia.Wu mo wu jijɛ wu yi finse le wu jɛmɛ lɛ, ‘Laŋɛ fioo yo.’ ");
INSERT INTO ncr_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Muh wu lɛme wɛɛ mo wu gwe tɛ a wu jii, wu lɛgɛ wu, wu jɛmɛ lɛ, ‘Koo gɛh yii bɛ mɛ, nlé ŋgê nlâŋɛ wo.’ ");
INSERT INTO ncr_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Wu faŋ, wu jo wu wù gɛɛŋ wu faa wu yeh yi ncha le, lɛ wu nyûme yu gɛɛŋ bu sege wu laŋɛ fioo ye yɛɛ. ");
INSERT INTO ncr_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Bamii bamu ba bɛ bo gɛ̀ lɛne doo bo yɛŋ fiɛɛ fì kooshi le, fi lujɛ bo baaŋ. Bo mo bo gɛɛŋ bo sɛɛŋ fiɛɛ fichii fì kooshi Nfoŋ wɛɛ le. ");
INSERT INTO ncr_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nfoŋ tɛɛŋ wu wu to, wu jɛmɛ wu le lɛ, ‘Wo le fiɛɛ fì achiji. Mbe ndaayɛ a yo fioo le yichii nje wo be wo ku chiaaŋ mɛne. ");
INSERT INTO ncr_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Gɛ be taŋlo tɛ wo koo yii fɛ muh wù bena bo lɛne le no mbe ŋkolɛ tɛ fɛ wo le gɛ?’ ");
INSERT INTO ncr_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nfoŋ wɛɛ toonyɛ shɛ́ŋ, wu nya wu lɛ ba fâa wu yeh yi ncha le, ba nyîɛge bɛ wu, gɛɛŋ bu sege wu lé wu gê wu laŋe fioo ye yɛɛ yichii. ");
INSERT INTO ncr_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Noo, le gɛh yɛɛŋyɛɛŋ no Chijaŋ wù le fɛwe lé wu gê bɛ muh wu mumwaa wu mumwaa bɛŋ le, nɛ muh baaŋ lɛɛshɛ gɛ bɛ fitele fie fichii fiɛɛ fì befe fì mwa bwee le wu ge fɛ wu le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jiso jɛmɛ mwɛɛ munɛ wu mɛsɛ, wu mo wu ja kimbe ki woŋ kì Galalee le, wu gɛɛŋ a kì Judia le, Joo yì Jodaŋ le wuŋ kwege. ");
INSERT INTO ncr_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","No wu gɛnɛ, binchvu bi bamii baanyi bi bi wu le, wu fɛ bo bachii ba gɛ̀ chɛne yo. ");
INSERT INTO ncr_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bafalashii ja bo to fɛ wu le ki bo moŋ wu, bo mo bo biih wu le lɛ, “Nchi le wu bɛɛŋ lɛ taŋlo muh kuŋ bɛ kwɛɛ yi fiɛɛ le kɛnɛ nyu fì la lɛ?” ");
INSERT INTO ncr_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jiso chvuu bo le lɛ, “Bɛŋ baaŋ a tɛɛŋ gɛ fiɛɛ fì ba gɛ̀ saŋ wa lɛ, ‘Gɛ̀ bee fɛŋkɛɛ muh wù gɛ̀ fɛ bamii, wu gɛ̀ fɛ bo nyu jwɛŋsɛ bɛ kwɛse gɛ?’ ");
INSERT INTO ncr_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Wu gɛ̀ fɛ noo, wu mo wu jɛmɛ lɛ, ‘Le nje finɛ fì jwɛŋsɛ lé wu gê wu chinɛ chiji bɛ bwee le, wu taashɛ bɛ kwɛɛ, bo bafɛɛ mo bo tu wa muh wu mumwaa.’ ");
INSERT INTO ncr_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Noo, gɛ bo baaŋ bamii bafɛɛ gɛ, bo le wa muh wu mumwaa. Fi mo fi nyu lɛ, fiɛɛ fì Nyo le wu taashɛ wa, keefɛ muh moŋ ki wu gâsɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Bamii baa mo bo biih Jiso le lɛ, “Tu le nje la fì Musɛ gɛ̀ duu lɛ muh taŋlo wu saŋ ŋwa wu nya kwɛɛ le wù duunyi lɛ wu le wu kuŋ wa bɛ wu, wu mo wu kuŋ bɛ wu?” ");
INSERT INTO ncr_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jiso chvuu lɛ, “Gɛ̀ bee nje bintuŋ biɛna bì tɛmɛ wù Musɛ gɛ̀ chinɛ lɛ muh taŋlo wu kuŋ bɛ kwɛɛ. Geenɛ, gɛ nyu no fi gɛ̀ bee fɛŋkɛɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Njɛme fiaŋ bɛŋ le lɛ, muh ja wu kuŋ bɛ kwɛɛ wu jo wumu, baaŋ nyu gɛ lɛ kwɛse wɛɛ le wu ja wu tu wu jiɛnyi wu jaŋe kinjaŋ sɛŋ gɛ, tu wu le wu ge kimbefɛ njɛ ki wu jâŋ kwɛse wumu.” ");
INSERT INTO ncr_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Booŋ ba Jiso ba ŋgoo yu wunɛ njɛme bo mo bo du wu le lɛ, “Nɛ fi le noo kune jwɛŋsɛ bɛ kwɛse, tu fi be joŋe lɛ muh mɛ fie noo fɛ wu taashɛ bvuguu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jiso jɛmɛ bo le lɛ, “Gɛ nyu muh wuchii wù taŋlo wu bɛɛŋ fiɛɛ finɛ gɛ. Taŋlo bɛɛŋ gɛh bamii ba Nyo le wu ge lɛ bo bɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Bɛŋ kêe lɛ bamii bamu le yu bo goone gɛ bikɛse gɛ, le no ba gɛ̀ boyɛ bo, bo nyume noo. Bamu nyu noo ge bamii bɛ chiaaŋ lɛ bo nyume noo. Bamu nyu fiboo noo ge bo bɛ bikwɛɛ biboo lɛ bo nyume noo nje bvunfoŋ bvù fɛwe. Muh wù taŋlo wu bɛ̂ɛŋ finɛ, wu bɛ̂ɛŋ.” ");
INSERT INTO ncr_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Bamii ja bo too bɛ booŋ fɛ Jiso le lɛ wu kuŋ bo le, wu buunɛ fɛ bo le, booŋ be ba ŋgoo tu bo wame lo bamii baa. ");
INSERT INTO ncr_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jiso jɛmɛ fie lɛ, “Bɛŋ chinɛ booŋ bayu too fɛ mɛne. Keefɛ bɛŋ jêese bo gɛ, nje bvunfoŋ bvù fɛwe le nyu fɛ bamii ba le njɛ booŋ banɛ le.” ");
INSERT INTO ncr_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","No wu jɛmɛ noo, wu mo wu gɛɛ chiaaŋ yi bo le, wu mo wu ja wu gɛɛne. ");
INSERT INTO ncr_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Fi kooshɛ lɛ muh wu kwa wumu gɛ̀ ja wu to fɛ Jiso le, wu biih wu le lɛ, “Muh wù N'yɛyɛ, fiɛɛ fì joŋe fì ŋkɛme ki ŋge fɛ ŋkɛmɛ kinche kì kage gɛ le la?” ");
INSERT INTO ncr_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jiso biih wu le lɛ, “Wo biide nyu mɛne kune fiɛɛ fì joŋe nje la? Muh wù joŋe mɛ gɛh wu wù maa. Nɛ wo goone ki wo gê wo kɛmɛ kinche kì kage gɛ, wo mo wo gɛɛde banchi ba Nyo.” ");
INSERT INTO ncr_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Muh wuyu biih Jiso le lɛ, “Banchi ba Nyo le ba la?” Jiso chvuu lɛ, “Keefɛ wo yûuyɛ muh gɛ, keefɛ wo jâŋ kwɛ muh gɛ, keefɛ wo chôŋ bvuchoŋ gɛ, keefɛ wo bɛ̂ɛ jiŋ yi nsa wu chimbiaŋ gɛ, ");
INSERT INTO ncr_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","wo ŋgvûune chijo bɛ bwoo, bɛ lɛ wo kôŋe muh wù mbebe yo le.” ");
INSERT INTO ncr_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Chumu wɛɛ mo wu jɛmɛ wu le lɛ, “Banchi banɛ bachii nchi gɛɛde wa lo. Ka shɛshi la?” ");
INSERT INTO ncr_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jiso chvuu wu le lɛ, “Nɛ wo fɛnɛ goone ki wo nyûme muh wù joŋe wu gɛɛne wu mɛɛse, wo gɛɛŋ wo gesɛ mwɛɛ mu wo kɛme, wo ga bige biyu ba fuude le, wo mo wo ge wo kɛ̂me nchvu yo nyu yi fɛwe. Wo nɛ lé wo gê noo wo mo wo to wo bîi mɛne.” ");
INSERT INTO ncr_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Sege chumu wuyu yu noo, wu mo wu ja wu gɛɛne wu nyume lo yii yii, nje wu gɛ̀ kɛme kwa baaŋ. ");
INSERT INTO ncr_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jiso mo wu jɛmɛ booŋ be ba ŋgoo le lɛ, “Nsɛŋe bɛŋ nchiɛɛŋ lɛ, fi tɛɛme fɛ muh wu kwa lee fɛ bvunfoŋ bvù fɛwe le. ");
INSERT INTO ncr_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ŋka nsɛŋe bɛŋ le lɛ, fi le chige fɛ nyambala lee a jise chi nsala le, fede fɛ muh wu kwa lee fɛ bvunfoŋ bvu Nyo le.” ");
INSERT INTO ncr_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Sege booŋ ba Jiso ba ŋgoo yu finɛ fiɛɛ, jwe yuŋ bo baaŋ. Bo biih lɛ, “Nɛ finɛ le noo, yu to bonɛ yɛɛŋ?” ");
INSERT INTO ncr_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jiso bijɛ bo nɛɛ, wu jɛmɛ bo le lɛ, “Nɛ le fɛ muh wu wuŋ le, tu fi taŋlo fi ya. Geenɛ fɛ Nyo le gɛ fiɛɛ taŋlo fi ya wu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Bita jɛmɛ wu le lɛ, “Bîjɛ yɛ̂ŋ, bee le be chinɛ wa fiɛɛ fichii, be bii wo le. Bee lé be gê be kɛme la?” ");
INSERT INTO ncr_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jiso jɛmɛ bo le lɛ, “Nsɛŋe bɛŋ nchiɛɛŋ lɛ sege muh wu jee che le Mwamuh le wu shii wa yi kala we wu bvukugɛ bvu yi woŋ wu fwɛŋ le, bɛŋ banɛ ba gɛ̀ bii mɛne, bɛŋ shiiyɛ tɛ yi bakala le yuufe ncho bafɛɛ bɛŋ sâge chikfuu chi Ishwala chi yuufe ncho chifɛɛ. ");
INSERT INTO ncr_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Muh wuchii wù le wu chinɛ la che le, kɛnɛ booŋ ba bwee le, kɛnɛ jɛ́me ye le, kɛnɛ chiji le, kɛnɛ bwee le, kɛnɛ booŋ le, kɛnɛ ŋɛɛ le, wu chinɛ nje mɛ, tu wu lé wu kɛ̂mɛ bamii bɛ mwɛɛ kiŋgane gwii fede no wu gɛ̀ kɛme. Wu lé wu kɛ̂mɛ tɛ kinche kì kage gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Geenɛ, bamii ba duude ba le fwe mɛɛse lé bo gê bo tu ajiŋ, ba duude ba le ajiŋ mɛɛse lé bo gê bo nyu fwe.” ");
INSERT INTO ncr_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jiso ka wu jɛmɛ lɛ, “Bvunfoŋ bvu fɛwe le njɛ chiji la wumu wù gɛ̀ bu wu ja antaana wu gɛɛŋ ki wu jô bamii ba lɛme wu leesɛ a wu mwɛne. ");
INSERT INTO ncr_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","No wu gɛ̀ gɛnɛ wu yɛŋ bo le, bɛ bo mo bo kamɛ lɛ wu lé wu gê wu laŋɛ bo nchvuge nchvuge yi juu le.Wu mo wu chiiŋsɛ bo, bo gɛɛŋ bo lɛne a wu mwɛne. ");
INSERT INTO ncr_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Gɛh njɛ juu bikaa bvuugɛ, wu bu wu gɛɛŋ wu yɛŋ bamii bamu le bo lɛme fɛ waaŋ bo laame. ");
INSERT INTO ncr_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Wu jɛmɛ bo le lɛ, ‘Bɛŋ gɛ̂ɛŋ tɛ bɛŋ lɛ̂ŋ a mɛ mwɛne, nlé nlâŋɛ bɛŋ bɛ nlaŋɛ wù kooji.’ Bo mo bo gɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Wu ka wu bu njɛ fɛnshɛ fɛ ntɛnɛɛ, wu ka wu kaasɛ wu bu njɛ juu bikaa bitɛde, wu jode gɛh bamii ba lɛme. ");
INSERT INTO ncr_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Lɛ nyu njɛ juu bikaa bitɛŋ fɛnfu, wu ka wu bu wu gɛɛŋ wu yɛŋ bamii ba lɛme bamu le. Wu bii bo le lɛ, ‘Le nje la fi bɛŋ to bɛŋ she bɛŋ lɛme fɛnɛ juu chi chile achiji?’ ");
INSERT INTO ncr_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bo chvuu lɛ, ‘Le nje muh baaŋ jo gɛ̀ bee lɛme le gɛ.’ Wu mo wu jɛmɛ bo le lɛ, ‘Bɛŋ gɛ̂ɛŋ tɛ bɛŋ lɛ̂ŋ a mɛ mwɛne.’ ");
INSERT INTO ncr_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Lɛ to nyume fɛnfu, chiji mwɛ kwɛɛ mo wu to wu du chiji kikwɛɛ ki bamii be ba lɛme le lɛ, wu tɛɛŋ bamii ba lɛme, wu nya nlaŋɛ wuboo, wu kɛ fɛ bamii ba be to ajiŋ le, wu gɛɛŋ wu mɛsɛ fɛ ba be to fwe le. ");
INSERT INTO ncr_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Wu mo wu kɛ wu laaŋe. Bamii ba wù gɛ̀ jo bo yi lɛme le juu bikaa bitɛŋ to wu laŋɛ bo nchvuge nchvuge. ");
INSERT INTO ncr_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Bamii ba wu gɛ̀ ya jo bo doo bo too bo mo bo kwaji lɛ ba lé ba lâŋɛ bo ba fe bamu baa. Geenɛ, ba laŋɛ tɛ bo danale danale. ");
INSERT INTO ncr_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","No bo fi nlaŋɛ wuboo bo mo bo kɛ bo tu bo shuŋshi, chiji la wɛɛ, ");
INSERT INTO ncr_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","bo duu lɛ, ‘Bamii banɛ ba wo be jo ajiŋ bo le bo lɛŋ gɛh ntaŋ wu kife kimimia maa, geenɛ wo laŋɛ besa bo yɛɛŋyɛɛŋ bee le be shɛ bee gose ye bɛ lɛme juu chi chile muu suŋe bee.’ ");
INSERT INTO ncr_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Chiji mwɛ wuyu chvuu muh mu bo le lɛ, ‘Nsaa yaŋ, mbaaŋ njiaa gɛ fiɛɛ besa wo gɛ. Besa wo be kamɛ gɛ lɛme chinɛ yi nchvuge le? ");
INSERT INTO ncr_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Joo nlaŋe wo wo gɛ̂ɛne. Koŋ mɛ lɛ nlaŋɛ muh wu ajiŋ yɛɛŋyɛɛŋ njɛ no nlaŋɛ wo. ");
INSERT INTO ncr_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Gɛ ŋkɛme bvuŋga ki ŋge fiɛɛ fì ŋkoŋe bɛ fiɛɛ fì le fiaŋ gɛ? Noo wo bɛɛne kindoŋ nje nle ŋgwenyɛ chiaaŋ yaŋ fɛ bamii le?’” ");
INSERT INTO ncr_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","No Jiso jɛmɛ nɛ, wu mo wu mɛsɛ lɛ, “Le gɛh no bamii ba le ajiŋ mɛɛse lé bo gê bo tu ba fwe, ba fwe tu ba ajiŋ.” ");
INSERT INTO ncr_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jiso gɛ̀ bɛɛne Yɛlusalɛm bɛ booŋ be ba ŋgoo ba yuufe ncho bafɛɛ bo bu a je, wu tɛɛŋ bo bɛ bo kɛŋsɛ yo, wu jɛmɛ bo le lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Bɛŋ yêgɛ bɛŋ yû, bee bɛɛne wa bee gɛɛne Yɛlusalɛm, ba lé ba gɛ̂ɛŋ ba nya muh wù jee che le Mwamuh chiaaŋ yi bachiji kintanyɛ ba baaŋ baaŋ le mo bamii ba duunyi banchi ba Nyo, ba sa wu ba suunɛ lɛ ba yuuyɛ wu, ");
INSERT INTO ncr_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ba mo ba nya wu chiaaŋ yi bituŋ le, ba chwɛɛse wu, ba taane wu bɛ munte, ba mo ba ta wu yi kintaaŋ le, doo nyume aju atade Nyo kaasɛ wu bvusɛ wu yi kwe le.” ");
INSERT INTO ncr_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Bwe booŋ ba Jɛbɛdi gɛ̀ ja wu to fɛ Jiso le bɛ booŋ be, wu tuŋ anyuu a wu jii ki wu lɛ̂gɛ fiɛɛ. ");
INSERT INTO ncr_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jiso bii wu le lɛ, “Wo be goone lɛ la?” Wu jɛmɛ wu le lɛ, “Kaa lɛ lé gê doo nyume sege wo sage bvunfoŋ bwuŋ, booŋ baŋ ba bafɛɛ banɛ shii mbebe yo le, wumu a kibo kuŋ kinchiɛɛŋ le, wumu a kiŋkoŋo le.” ");
INSERT INTO ncr_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jiso chvuu lɛ, “Gɛ bɛŋ kee fiɛɛ fì bɛŋ biide gɛ. Taŋlo bɛŋ mu fiŋkoo fi ŋgɛ fi nlé ŋgê mu?” Bo chvuu lɛ, “Bee taŋlo be mu.” ");
INSERT INTO ncr_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Wu jɛmɛ bo le lɛ, “Bɛŋ lé bɛŋ mû fiŋkoo fiaŋ nchiɛɛŋ. Geenɛ ki bɛŋ shîi a kibo kaŋ kinchiɛɛŋ le bɛ kiŋkoŋo le, gɛ nyume kijusɛ kaŋ ki nya bɛŋ le gɛ. Manjuu mayu le fɛ bamii ba Chii le wu seesɛ wa wu gɛɛ bo le.” ");
INSERT INTO ncr_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kimbɛge ki booŋ ba ŋgoo ba Jiso ba yuufe doo bo yu kune fiɛɛ fiyu, shɛ́ŋ toonyɛ bo bɛ booŋ ba bafɛɛ bayu. ");
INSERT INTO ncr_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Geenɛ Jiso tɛɛŋ bo bachii, bo to wu jɛmɛ bo le lɛ, “Bɛŋ kee lɛ bamii ba sage bituŋ to bo shiide lo yi bamii baboo le, bamii ba baaŋ baaŋ baboo duunyi bvuŋga bvuboo a bo we. ");
INSERT INTO ncr_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Gɛ fifiɛɛ kɛme ki fi nyume a bɛŋ ntɛnɛɛ gɛ. Muh wu goone ki wu nyûme muh wù baaŋ a bɛŋ ntɛnɛɛ wù kɛme ki wu nyûme muh wù lɛne lo bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Muh nɛ goone ki wu nyûme muh wù fwe a bɛŋ ntɛnɛɛ, tu wù kɛme ki wu nyûme nfwa wene. ");
INSERT INTO ncr_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Le gɛh yɛɛŋyɛɛŋ no muh wù jee che le Mwamuh gɛ̀ baaŋ to gɛ lɛ bamii lɛ̂ne lo wu le gɛ. Wu gɛ̀ to ki wu lɛ̂ŋ lo bamii le, wu nyâ kinche ke ki wu sûuŋ muh wù duude yi kwe le.” ");
INSERT INTO ncr_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jiso bɛ booŋ be ba ŋgoo gɛ̀ gɛɛŋ bo doo bo fede Jɛliku, kinchvu ki bamii tu ki kfuunɛ ki bii a wu ajiŋ. ");
INSERT INTO ncr_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Fi kooshɛ lɛ binfeeŋ bimi bifɛɛ, nyu bilɛŋsɛ bì gɛ̀ too gɛh bi shiide jwe wu je le, bi doo bi yu lɛ Jiso fede lo, bi mo bi tu bi wanɛ bi duu lɛ, “Tada, Mwa Nfoŋ Dabi, koo yii fɛ bee le.” ");
INSERT INTO ncr_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kinchvu ki bamii tu ki wanɛ ki duu lɛ bo baŋ lo. Geenɛ bo ka bo waŋ lo bo gɛɛŋ fwe fwe lɛ, “Tada, Mwa Nfoŋ Dabi koo yii fɛ bee le.” ");
INSERT INTO ncr_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jiso mo wu lɛɛŋ, wu tɛɛŋ bo, bo to, wu biih bo le lɛ, “Bɛŋ goone lɛ ŋgê la fɛ bɛŋ le?” ");
INSERT INTO ncr_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bo chvuu lɛ, “Tada, fɛɛ lɛ ajii a wese gwenyɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yii koo Jiso, wu kuŋ ajii aboo le. Kimimia bo mo bo tu bo yɛde mwɛɛ le, bo mo bo ja bo bii Jiso le. ");
INSERT INTO ncr_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jiso bɛ booŋ be ba ŋgoo gɛ̀ doo bo fɛɛse Yɛlusalɛm, bo nyu wa ntɛ wù Bɛfash le, bo nyume mbebe yi mbegɛ wu Bite bi Olif le, wu mo wu tuŋ booŋ be ba ŋgoo bamu bafɛɛ, ");
INSERT INTO ncr_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","wu jɛme bo le lɛ, “Bɛŋ gɛɛŋ ntɛ wù fwe wege le. Bɛŋ doo bɛŋ gɛɛŋ, bɛŋ yɛŋ bwe jaki le ba shuudɛ mwa ye nyume mbebe ye le, bɛŋ faanyɛ, bɛŋ to bɛ bo fɛ mɛne. ");
INSERT INTO ncr_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nɛ muh lé wu jɛ̂mɛ fiɛɛ bɛŋ le, bɛŋ chvuu lɛ Chiji Kikwɛɛ gôone lo, wu mo wu chînɛ lo kimimia bɛŋ to yu.” ");
INSERT INTO ncr_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Finɛ fiɛɛ gɛ̀ kooshɛ noo ki fi gê fi to fi kojɛ no muh wu ntuŋ wu Nyo wumu gɛ̀ jɛmɛ, wu du lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Muh du kilaantɛŋ kì Sayoŋ le lɛ, ‘Bɛŋ jîŋɛ bɛŋ yɛ̂ŋ, Nfoŋ wene too fɛ bɛŋ le. Wu le wu shiishɛ kikwɛɛ ke, wu bɛɛŋ yi jaki le, nyu mwa jaki, jaki wu baaŋ shige.’” ");
INSERT INTO ncr_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Booŋ ba Jiso ba ŋgoo baa gɛɛŋ, bo ge gɛh no wu be jɛmɛ. ");
INSERT INTO ncr_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bo to bɛ jaki wɛɛ mo mwa, bo nooŋ bikuŋ biboo yu wege, Jiso bɛɛŋ wu shii yu we, wu tu wu gɛɛne. ");
INSERT INTO ncr_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kinchvu ki bamii ki duude tu ki dɛŋe tɛ bikuŋ biboo a je, bamu shwage chɛ́ yi bite bo dɛŋe. ");
INSERT INTO ncr_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kinchvu kì gɛ̀ gɛɛne Jiso fwe bɛ kì gɛ̀ bii ajiŋ tu ki wuule lɛ, “Yilili Yilili, mbɛɛŋsɛ nyûme fɛ mwa Nfoŋ Dabi le lɛɛɛ! Nyo le wu noŋ kimbonɛ yi muh wu too a jee chi Tada le lɛɛɛ! Yilili Yilili, mbɛɛŋsɛ nyûme fɛ Nyo wu fɛwe le lɛɛɛ!” ");
INSERT INTO ncr_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jiso gɛɛŋ wu fɛsɛ Yɛlusalɛm, kilaantɛŋ kɛɛ ki shiŋshɛ kichii. Bamii tu bo maŋe, bo biide lɛ, “Wunɛ le yɛɛŋ?” ");
INSERT INTO ncr_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","kinchvu kɛɛ chvuu lɛ, “Le muh wu ntuŋ wu Nyo wù Jiso wù ja ntɛ wu Nasalɛ le, Galalee.” ");
INSERT INTO ncr_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jiso gɛ̀ gɛɛŋ fɛ yeh yi kintanyɛ ki Nyo le, wu kuŋ bamii bachii ba gɛ̀ gese bɛ ba gɛ̀ gude mwɛɛ fo, wu baaji bidaŋ bi bamii ba gɛ̀ kuse bige, bɛ binta bi bamii ba gɛ̀ gese bibɛmbɛ. ");
INSERT INTO ncr_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Wu gɛ̀ kuŋe wu duu lɛ, “Fi le ba saŋ lɛ Nyo duu lɛ, ‘Ba lé ba tɛ̂ŋe yeh yaŋ lɛ yeh yi buunɛ.’ Bɛŋ kaasɛ yi tu bvuta bvu bachoŋ.” ");
INSERT INTO ncr_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jiso tu wù nyu fɛ yeh yi kintanyɛ le, binfeeŋ bɛ bantɛŋelase too wu fɛde bo. ");
INSERT INTO ncr_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Geenɛ, bachiji kintanyɛ ba baaŋ baaŋ bɛ bamii ba gɛ̀ duunyi banchi ba Nyo gɛ̀ doo bo yɛŋ biŋgha bi mwɛɛ bì wu gɛ̀ gee le, bɛ no booŋ ba shige shige gɛ̀ wuule fɛ yeh yi kintanyɛ le, bo duu lɛ, “Yilili Yilili, mbɛɛŋsɛ nyûme fɛ mwa Nfoŋ Dabi le lɛɛɛ”, fi tu fi toonyi lo bo. ");
INSERT INTO ncr_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bo mo bo waŋ lo Jiso lɛ, “Gɛ wo yuge fiɛɛ fì booŋ banɛ duu gɛ?” Wu chvuu bo le lɛ, “Ɛɛŋ, n'yuge lo. Fi le lɛ bɛŋ gɛ̀ baaŋ a tɛɛŋ gɛ wa fiɛɛ fì ba gɛ̀ saŋ lɛ, ‘Nyo lé wu gê mbɛɛŋsɛ wù joŋe wu gɛɛne wu mɛɛse wu tu wu bude de yi booŋ ba shige shige le, bɛ de yi booŋ bo baaŋ bo yaane ambɛŋ le gɛ?’” ");
INSERT INTO ncr_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jiso gɛ̀ ja wu chinɛ bo le, wu bu a kilaantɛŋ kɛɛ le, wu gɛɛŋ ntɛ wu Bɛtani le, wu che yo. ");
INSERT INTO ncr_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Lɛ to nyume antaana, no Jiso gɛ̀ kaase wu tuu jiŋ a kilaantɛŋ ki Yɛlusalɛm le, jɛŋ tu yi yuu wu. ");
INSERT INTO ncr_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Wu yɛŋ kite kimi le mbebe yi je le ba to ba jii, wu mo wu gɛɛŋ fo, geenɛ wu gɛ̀ baaŋ yɛŋ gɛ fiɛɛ le yi ki le gɛ, wu yɛŋ gɛh nyu biŋkamɛ le maa. Wu mo wu noŋ loŋ kite kɛɛ le wu jɛmɛ lɛ, “Keefɛ fintaŋ ka fi yuŋ yi wo le gɛ!” Kimimia, kite kɛɛ mo ki bobɛ lo. ");
INSERT INTO ncr_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Booŋ ba ŋgoo ba Jiso doo bo yɛŋ noo, jwe yuŋ bo. Bo tu bo ghaade lɛ, “Kite kinɛ jiɛnyi nɛɛ fɛ ki bobɛ lo kimimia nɛ?” ");
INSERT INTO ncr_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jiso chvuu bo le lɛ, “Nsɛŋe bɛŋ nchiɛɛŋ lɛ, nɛ bɛŋ leese fitele yi Nyo le, bɛŋ maŋe gɛ, bɛŋ gɛ ge gɛh nyu fiɛɛ fì ŋge bɛ kite kinɛ le maa gɛ. Nɛ bɛŋ jɛme mbegɛ wunɛ le lɛ, ‘Mugɛ ye fɛnɛ wo gɛɛŋ wo gwe a joo yì baaŋ le’, fi kooshɛ gɛh noo. ");
INSERT INTO ncr_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mo nyume la fì bɛŋ lɛge a buunɛ le, bɛŋ lé bɛŋ kɛ̂mɛ nɛ bɛŋ le bɛŋ leesɛ fitele yi Nyo le.” ");
INSERT INTO ncr_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jiso gɛ̀ kaasɛ wu lee fɛ yeh yi kintanyɛ le, bachiji kintanyɛ ba baaŋ baaŋ bɛ bamii ba sage woŋ wu Bajuu gɛ̀ to bo yɛŋ no wu yɛyi bamii, bo mo bo biih wu le lɛ, “Wo jo faaŋ bvuŋga fɛ wo gee mwɛɛ munɛ? Nya yɛɛŋ bvuŋga bvuyu wo le?” ");
INSERT INTO ncr_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jiso chvuu bo le lɛ, “Mɛ tɛ nlé mbîih bɛŋ fiɛɛ. Nɛ bɛŋ chvuse lo, mɛ mo nsɛɛŋ bɛŋ muh wù nya mɛ bvuŋga ki ŋgee mwɛɛ munɛ. ");
INSERT INTO ncr_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Joŋ gɛ̀ leese bamii a joo bvuŋga bvuyu ja faaŋ? Bvu gɛ̀ ja fɛwe noo gɛ̀ nya muh wu wuŋ le?” No wu bile noo, bo tu bo tɛɛnyi lɛbolɛbo lɛ, “Nɛ bee chvuse lɛ gɛ̀ nya Nyo, wu biih bee le laa gɛ̀ ge la lɛ keefɛ bee bɛɛŋ Joŋ le gɛ? ");
INSERT INTO ncr_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Geenɛ, gɛ nyu no bee chvuu lɛ, ‘Gɛ̀ nya muh wu wuŋ gɛ’, nje bee faane kinchvu ki bamii, no bo bachii le bo bɛɛŋ lɛ Joŋ gɛ̀ bee muh wu ntuŋ wu Nyo.” ");
INSERT INTO ncr_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Noo, bo mo bo chvuu Jiso le lɛ, “Gɛ bee kee gɛ.” Jiso mo wu jɛmɛ bo le lɛ, “Tu gɛ mɛ nyu nsɛɛŋ tɛ bɛŋ muh wù nya mɛ bvuŋga lɛ ŋgêe mwɛɛ munɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jiso gɛɛŋ fwe wu biih lɛ, “Bɛŋ kwaji lɛ la kune finɛ? Muh mu gɛ̀ kɛme booŋ ba bilɛŋsɛ bafɛɛ. Wu gɛ̀ ja wu gɛɛŋ fɛ mwa wù ŋgamu le, wu jɛmɛ wu le lɛ, ‘Mwa yaŋ, gɛnɛ wo she wo lɛ̂ne mwɛne abɛŋ.’ ");
INSERT INTO ncr_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Wu chvuu lɛ, ‘Gɛ mɛ nyu ŋgɛɛŋ gɛ.’ Geenɛ wu ja wu kaasɛ wu kusɛ fitele fie wu mo wu gɛɛŋ mwɛne kwɛɛ. ");
INSERT INTO ncr_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Muh wɛɛ gɛɛŋ fɛ wù ajiŋ le wu jɛmɛ gɛh fiɛɛ fì wu be jɛmɛ wa wu ŋgamu le. Wu chvuu wu le lɛ, ‘Nlé ŋgɛ̂ɛŋ chii.’ Geenɛ, wu faŋ ki wu gɛ̂ɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Antɛnɛɛ a booŋ bafɛɛ banɛ, le wu la wù gɛ̀ ge fiɛɛ fì chiji goone?” Bo chvuu lɛ, “Le wù ŋgamu.” Jiso mo wu jɛmɛ bo le lɛ, “Nsɛɛŋ bɛŋ nchiɛɛŋ lɛ, bamii ba koode ŋwa mo bikɛse ba jiikuu bo leese wa fɛ bvunfoŋ bvu Nyo le fwe a bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Njɛme nɛ nje Joŋ Nlesɛajoo gɛ̀ to ki wu dûnyɛ je yì chaaŋ bɛŋ le, bɛŋ faŋ ki bɛŋ bɛ̂ɛŋ wu le, geenɛ bamii ba koode ŋwa bɛ bikɛse ba jiikuu bo bɛɛŋ wu le. Bɛŋ gɛ̀ doo bɛŋ yɛŋ no bo bɛmɛ noo, bɛŋ baaŋ kusɛ gɛ muntele mwɛna lɛ bɛŋ bɛɛŋ tɛ wu le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jiso mo wu ja wu jɛmɛ lɛ, “Bɛŋ yû ŋgaŋ wumu. Muh mu gɛ̀ bee wu lɛŋ mwɛ wu muntaŋ mù ba fɛde mbvuuŋ yu, wu tuŋ kitaŋ ki kɛnɛ, wu fɛ kiso kì ba lé ba sôone mbvuuŋ bude yo, wu tuŋ kitale ki muh wu chiɛɛne mwɛ kwɛɛ, wu mo wu gɛɛ mwɛ kwɛɛ bamii le, wu ja wu gɛɛŋ kituŋ kimi le. ");
INSERT INTO ncr_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kife kì ba to ba kege muntaŋ gɛ̀ to ki kojɛ, wu tuŋ booŋ be ba lɛme fɛ bamii ba wu gɛ̀ gɛlɛ mwɛ kwɛɛ bo le, lɛ bo gɛɛŋ bo fi mwe muntaŋ. ");
INSERT INTO ncr_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bo gɛɛŋ, bamii ba wu gɛ̀ gɛlɛ mwɛ kwɛɛ bo le, bo koo bo, bo suŋ wumu, bo yuuyɛ wumu, bo tumɛ wumu bɛ ata. ");
INSERT INTO ncr_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Wu ka wu tuŋ bamii bamu ba lɛme ba duude bo fede ba fwe baa, bamii baa ka bo ge gɛh yɛɛŋyɛɛŋ no bo gɛ̀ ge bɛ ba fwe baa. ");
INSERT INTO ncr_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ajiŋ ayu wu tuŋ wa nyume mwa ye, wu kwaji lɛ bo lé bo gɛ̂ɛŋ bo ŋgvuuŋ mwa ye wunɛ. ");
INSERT INTO ncr_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Geenɛ, wu gɛɛŋ, bamii bayu doo bo yɛŋ wu le, bo jɛmɛ lɛbolɛbo lɛ, ‘Wunɛ le njibvushɛ bvu muh wu mwɛ kfunɛ. Bɛŋ to bee yuuyɛ wu bee mo be jo bvushɛ bvunɛ.’ ");
INSERT INTO ncr_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Bo mo bo koo wu bo bvusɛ mwɛne kwɛɛ, bo yuuyɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","No Jiso ma nɛ, wu mo wu biih lɛ, “Muh mwɛ kfunɛ ge doo wu to wu ge nɛɛ bɛ bamii banɛ?” ");
INSERT INTO ncr_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bo chvuu lɛ, “Wu lé wu tô wu lɛ̂ɛshɛ lo munyamɛ muyu, wu gɛ̂ɛ mwɛ kwɛɛ bamii bamu bo lé bo gê bo nyaa mwe muntaŋ sege bo kege.” ");
INSERT INTO ncr_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jiso biih bo le lɛ, “Bɛŋ gɛ̀ baaŋ a tɛɛŋ gɛ a Ŋwa wu Nyo le lɛ, ‘Tɛdɛ chiɛɛ chì bamii ba njonɛ gɛ̀ faŋ, gɛ̀ kaasɛ chi tu tɛdɛ chi buu chi yeh. Finɛ gɛ̀ ge Tada, bamii jîiŋe bo kɛme ŋgha?’ ");
INSERT INTO ncr_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Mɛ mo nsɛŋe bɛŋ le lɛ, Nyo le wu fi bvunfoŋ bwe chiaaŋ yene le, wu nya nyu kituŋ ki lé ki gêe no wu goone le.” ");
INSERT INTO ncr_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","“Tɛdɛ chiyu chinɛ muh gwe yi chì le, wu chiaafɛ lo, chi gwe yi muh le, chi baajɛ lo mwɛdɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","No Jiso ma ŋgaŋ wunɛ nɛ, bachiji kintanyɛ ba baaŋ baaŋ mo Bafalashii doo bo yu, bo mo bo kɛɛ lɛ wu ma nyu kune bo. ");
INSERT INTO ncr_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Bo tu bo goone ki bo koo wu, geenɛ, bo kaasɛ bo faŋ kinchvu ki bamii, nje kinchvu kɛɛ gɛ̀ kɛme Jiso njɛ muh wu ntuŋ wu Nyo. ");
INSERT INTO ncr_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jiso ka wu jɛmɛ bo le a baŋgaŋ le, wumu nyu lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Bvunfoŋ bvu fɛwe taŋlo ba beji bɛ nfoŋ wumu wù gɛ̀ seesɛ ŋka wu bvuguu bvu mwa ye wù jwɛŋsɛ. ");
INSERT INTO ncr_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Wu tuŋ booŋ be ba lɛme lɛ bo gɛɛŋ bo tɛɛŋ bamii ba wu chi be bo fɛ ŋka wu bvuguu le lɛ bo tôo. Geenɛ, booŋ bayu gɛɛŋ bamii bayu faŋ lɛ gɛ bo to gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Wu tuŋ banchɛndaa bamu wu jɛmɛ bo le lɛ, ‘Bɛŋ gɛɛŋ bɛŋ jɛmɛ bamii ba nchi ntɛŋe fɛ ŋka wu bvuguu wunɛ le lɛ bo yegɛ bo yu, nle seesɛ wa mwɛɛ munjile, nsɛɛyɛ nyáŋ yì ba bvuushɛ bɛ booŋ ba banaa ba faŋ. Nle nseesɛ wa mwɛɛ munchii, lɛ bo tôo fɛ ŋka le.’ ");
INSERT INTO ncr_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Geenɛ, bo gɛɛŋ bamii bayu chiaasɛ lo, bo ja fiboo bo gɛɛne. Muh mu la a wu mwɛne, muh mu la waaŋ we. ");
INSERT INTO ncr_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Kimbɛge ki bamii koo booŋ bayu bo nyiɛ bɛ bo, bo mo bo yuuyɛ bo. ");
INSERT INTO ncr_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Fitele bɛdɛ nfoŋ wɛɛ, wu tuŋ bamii be ba jɛŋ, bo gɛɛŋ bo lɛɛshɛ lo bamii ba yuuyi booŋ be ba lɛme baa, bo mo bo toŋ kilaantɛŋ kiboo. ");
INSERT INTO ncr_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","No wu ge noo wu mo wu jɛmɛ booŋ be ba lɛme bamu le lɛ, ‘Nle nseesɛ wa ŋka wu bvuguu. Geenɛ bamii ba nchi mbe chi bee gɛ bamii gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Bɛŋ gɛɛŋ ntasɛ yi jé le yichii, bɛŋ tɛɛŋ bamii bachii ba bɛŋ le bɛŋ yɛŋ, lɛ bo to fɛ ŋka wu bvuguu wunɛ le.’ ");
INSERT INTO ncr_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Banchɛndaa baa mo bo gɛɛŋ jé le yichii bo kuŋ bamii bachii ba bo gɛ̀ yɛŋ le bamii ba joŋe bɛ ba befe bo to. Yeh yi bvuguu mo yi yisɛ bɛ bamii. ");
INSERT INTO ncr_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nfoŋ ja wu lee yeh yi bvuguu yiyu le ki wu yɛ̂ŋ bamii ba to fɛ ŋka le, wu mo wu yɛŋ muh mu le yu wu baaŋ jii gɛ njú yi ŋka wu bvuguu gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Wu biih wu le lɛ, ‘Nsaa yaŋ, wo jiɛnyi nɛɛ fɛ wo lee yeh kfunɛ njɛ wo le bɛ njú yi ŋka sɛŋ?’ Muh wɛɛ mɛ jwe wu chile. ");
INSERT INTO ncr_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Noo, nfoŋ mo wu jɛmɛ banchɛndaa be le lɛ, ‘Bɛŋ kaaŋ chiaaŋ ye mo bikaa, bɛŋ noŋ wu kijibɛ le akfuuŋ, yo bamii lé bo gê bo beede bo ŋgeji bige.’” ");
INSERT INTO ncr_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","No Jiso jɛme noo, wu mo wu jɛmɛ lɛ, “Bɛŋ kêe lɛ Nyo le wu tɛɛŋ bamii ba duude, geenɛ wu cha gɛh nyu ba shige.” ");
INSERT INTO ncr_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Bafalashii mo bo ja bo gɛɛŋ bo seesɛ no bo lé bo gê fɛ Jiso loŋsɛ njɛme bo koo wu. ");
INSERT INTO ncr_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bo mo bo tuŋ booŋ baboo ba ŋgoo mo ŋgoo yi bamii ba Nfoŋ Hɛlod fɛ Jiso le. Bo gɛɛŋ bo jɛmɛ wu le lɛ, “Muh wu N'yɛyɛ, bee kee lɛ wo le muh wù nchiɛɛŋ, wo yɛyi bamii bɛ jɛ yi Nyo a je yì nchiɛɛŋ le. Gɛ wo jode lɛ muh mu le yeye gɛ, nje gɛ wo jiiŋe muh yi fiɛɛ fì wu le fi le gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Gɛh sɛɛŋ bee wo ŋkwajɛ. Nchi le wu bɛɛŋ lɛ bee lâaŋe ŋwa Kaisa Nfoŋ wu Lum le, noo keefɛ bee lâaŋe gɛ le?” ");
INSERT INTO ncr_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jiso kɛɛ fiɛɛ fì bo wɛɛne bɛ fi, wu mo wu jɛmɛ bo le lɛ, “Bɛŋ bamii ba jɛme yeye, bɛŋ gee yeye banɛ, bɛŋ tele mɛ nje la? ");
INSERT INTO ncr_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Bɛŋ to bɛ bige bì bɛŋ to bɛŋ laaŋe ŋwa yu n'yɛŋ.” Bo to bɛ danale bo nya wu le. ");
INSERT INTO ncr_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jiso biih bo le lɛ, “Kikwɛɛ kinɛ kì le yu le ki yɛɛŋ? Jee chinɛ chì le yu le chi yɛɛŋ?” ");
INSERT INTO ncr_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bo chvuu lɛ, “Le ki Kaisa lɛ, jee le tɛ che.” Wu mo wu jɛmɛ bo le lɛ, “Bɛŋ nyâa Kaisa le fiɛɛ fì le fi Kaisa, bɛŋ nyâa Nyo le fì le fi Nyo.” ");
INSERT INTO ncr_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Bo yu noo, jwe yuŋ lo bo. Bo mo bo chinɛ wu le bo ja bo gɛɛne. ");
INSERT INTO ncr_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Gɛh abvu, Basadushii ja bo to fɛ Jiso le. Basadushii banɛ gɛ̀ bee ŋgoo yi bamii ba gɛ̀ duu lɛ gɛ bamii nyu bo ge bo bu yi kwe le gɛ. No bo to, bo biih wu le lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Muh wu N'yɛyɛ, Musɛ gɛ̀ saŋ lɛ, ‘Nɛ muh kwe lo mwa sɛŋ, tu mwa bwee kɛme ki wu gɛ̂ɛ kwɛse wuyu bɛ wu boo booŋ a jee chi ŋkfu mwa bwee le.’ ");
INSERT INTO ncr_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mɛɛse, booŋ ba muh mu gɛ̀ chee besa bo yanɛ bvusooshwi. Wù ŋgamu gɛ̀ jo kwɛse, wu jiɛnyɛ wu kwe bɛ wu baaŋ kɛme gɛ mwa gɛ, wu chinɛ kwɛse wuyu wù bii wu le. ");
INSERT INTO ncr_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Fi kooshɛ gɛh noo bɛ wù ka bii wɛɛ le mo wù bii wu wɛɛ le, gɛɛŋ bu fɛ wu bvusooshwi le. ");
INSERT INTO ncr_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ajiŋ ayu, kwɛse wɛɛ kwe tɛ. ");
INSERT INTO ncr_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Noo, mɛɛse no bo bachii bvusooshwi gɛ̀ jo kwɛse wɛɛ, lé gê doo nyume sege bamii bude yi kwe le, kwɛse wɛɛ nyû kwɛ yɛɛŋ?” ");
INSERT INTO ncr_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jiso chvuu bo le lɛ, “Bɛŋ le bɛŋ jiaa, nje gɛ bɛŋ kee fiɛɛ fì ba saŋ a Ŋwa wu Nyo le gɛ. Gɛ bɛŋ kee tɛ bvuŋga bvu Nyo gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bɛŋ kêe lɛ lé tô nyume sege bamii bude yi kwe le, gɛ bilɛŋsɛ bɛ bikɛse baaŋ bo ka bo taashi bvuguu gɛ, gɛ bamii baaŋ bo ka bo nyaa booŋ bo taashi bvuguu gɛ. Bo lé bo tô bo nyume wa njɛ banchɛndaa ba Nyo fɛwe ");
INSERT INTO ncr_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Doo nyume kune mbu wu bamii lé bo gê bo bude yi kwe le, bɛŋ gɛ̀ baaŋ a tɛɛŋ gɛ a Ŋwa wu Nyo le bɛŋ yu fiɛɛ fì wu jɛme bɛŋ le gɛ? Nyo gɛ̀ jɛmɛ lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Le mɛ wù Nyo wu Ablaham bɛ Nyo wu Asik mo Nyo wu Yakob.’ Fi le lɛ gɛ Nyo nyume Nyo wu baŋkfu gɛ, le Nyo wu bamii ba baaŋ yu.” ");
INSERT INTO ncr_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kinchvu ki gɛ̀ lɛme fo yu nchvusɛ wù Jiso chvuse, jwe yuŋ lo bo bɛ n'yɛyɛ we. ");
INSERT INTO ncr_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Bafalashii gɛ̀ doo bo yu lɛ Jiso le wu baŋɛ lo jwe wu Basadushii, bo mo bo banyɛ ye bo to fɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Muh mu bo le wù gɛ̀ kee banchi ba Nyo chuule wu mo wu telɛ wu bɛ mbilɛ wumu lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Muh wù n'yɛyɛ, nchi wù kuge wu fede banchi bachii le wù la?” ");
INSERT INTO ncr_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jiso chvuu wu le lɛ, “Nchi wù kuge le wù duu lɛ, ‘Wo kôŋe Tada wù Nyo wo bɛ fitele fiuŋ fichii, wo nyâ ye yo wu le yichii, wo gɛ̂ɛ bvufee bwuŋ yi wu le bvuchii.’ ");
INSERT INTO ncr_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Wunɛ le nchi wù fwe wù kuge wù fede banchi bachii. ");
INSERT INTO ncr_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Wù bii wu le nyume njɛ wunɛ. Fì le lɛ, ‘Wo kôŋe muh wu le mbebe yo le no wo koŋe kikwɛɛ kuŋ.’ ");
INSERT INTO ncr_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mwɛɛ munchii mù le a Ŋwa wu banchi le, mo mù le a Baŋwa ba bamii ba ntuŋ wu Nyo le, mu lɛme nyu yi banchi ba bafɛɛ banɛ le.” ");
INSERT INTO ncr_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","No Bafalashii gɛ̀ taashɛ fo, Jiso mo wu ja wu biih mbilɛ wumu bo le lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Bɛŋ kwaji lɛ la kune Mbvusɛ wù Nyo gɛ̀ ka? Bɛŋ kwaji lɛ le mwa yɛɛŋ?” Bo chvuu wu le lɛ, “Le mwa Nfoŋ Dabi.” ");
INSERT INTO ncr_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jiso kaasɛ wu biih bo le lɛ, “No le mwa Nfoŋ Dabi, fi jiɛnyi nɛɛ fɛ Kiyo ki Yuude ge Dabi tu wu tɛŋe wu lɛ Tada we? Dabi gɛ̀ jɛmɛ lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Tada Nyo gɛ̀ be wu jɛmɛ Tada waŋ le lɛ, wu shîi a kibo ke kinchiɛɛŋ le, gɛ̂ɛŋ bû sege wu lé wu gê wu gîiŋsɛ bamii be ba kimbanɛ, wu tomɛ bikaa bie yi bo le.’ ");
INSERT INTO ncr_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nɛ Dabi tɛŋe wu lɛ Tada we, fi ka fi jiɛnyɛ nɛɛ fɛ wu tu wù nyu mwa ye?” ");
INSERT INTO ncr_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","No Jiso jɛmɛ nɛ, muh gɛ ka wù nyu yu wu mumwaa wu chvuu fiɛɛ wu le gɛ. Kɛge tɛ abvu, muh gɛ ka wu moŋ lo wu biih fiɛɛ wu le gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jiso mo wu ja wu jɛmɛ kinchvu ki bamii le bɛ booŋ be ba ŋgoo le lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Bamii ba duunyi banchi bɛ Bafalashii le bamii ba le ba jo kinta ki Musɛ. ");
INSERT INTO ncr_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Fi mo fi nyu lɛ, bɛŋ yûge fiɛɛ fichii fì ba sɛŋe bɛŋ le, bɛŋ mo bɛŋ gêe. Geenɛ, keefɛ bɛŋ gêe fiɛɛ fì bo gee gɛ, nje bo feeji yeye, bo gee yeye. ");
INSERT INTO ncr_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bo jade bo yilɛ bvujijɛ bvù fede bvuŋga bvu bamii bo yigɛ bamii yu, ta bo kibɛɛ moŋ ki bo la nyi yi kwaaŋ bo fi bo yu gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Mwɛɛ mù bo gee munchii le gɛh ki bo ge lɛ bamii yɛ̂ne bo le. Muŋku muboo mu Ŋwa wu Nyo le lo mù kuge.Munchaŋa mu de yi njú yiboo le lo mù ndefe. ");
INSERT INTO ncr_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bo to bo gɛɛne fɛ ŋka le bo koŋe ki bo shiide nyu fɛ bamii ŋgvuune bo fo, bo ka gɛɛne yéh yi buunɛ le bo koŋe ki bo shiide nyu yi binta bì fwe le. ");
INSERT INTO ncr_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bo ka koŋe tɛ njiɛnyɛ wu fɛ waaŋ lɛ bamii yɛ̂ɛse bo le, bo ka koŋe lɛ bamii tɛ̂ŋe bo lɛ Balabai. ");
INSERT INTO ncr_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Geenɛ, keefɛ muh bɛɛŋ lɛ bamii tɛ̂ŋe wu lɛ Labai gɛ, nje bɛŋ kɛme Muh wu N'yɛyɛ gɛh wu mumwaa maa, bɛŋ bachii nyu booŋ ba bwe mwa lɛ. ");
INSERT INTO ncr_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Keefɛ bɛŋ tɛ̂ŋe muh mu yi nshɛŋ le fɛnɛ lɛ le chiji wene gɛ, nje bɛŋ kɛme Chiji wene wu mumwaa wù le fɛwe. ");
INSERT INTO ncr_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Keefɛ muh bɛɛŋ lɛ ba tɛŋe wu lɛ Chiji Kikwɛɛ gɛ, nje Chiji Kikwɛɛ wene le gɛh wu mumwaa wù le Kletu. ");
INSERT INTO ncr_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Muh wù baaŋ a bɛŋ ntɛnɛɛ kɛme ki wu nyû muh wù lɛne lo bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mo yɛɛŋ wù bɛɛŋse kikwɛɛ ke, tu Nyo lé wu shîishɛ lo wu, mo yɛɛŋ wù shiishi kikwɛɛ ke, Nyo lé wu bɛ̂ɛŋsɛ lo wu. ");
INSERT INTO ncr_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ŋgɛ wù baaŋ le wene bɛŋ bamii ba duunyi banchi mo bɛŋ Bafalashii. Bɛŋ le bamii ba jɛme yeye, bɛŋ gee yeye! Bɛŋ lɛme a bamii jii bɛŋ baŋe je yì leese fɛ bvunfoŋ bvù fɛwe le. Gɛ bɛŋ koŋe ki bɛŋ lêe bvu le gɛ, bɛŋ ka baŋe je lɛ keefɛ bamii ba koŋe bo lee fo gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ŋgɛ wù baaŋ le wene bɛŋ bamii ba duunyi banchi mo bɛŋ Bafalashii. Bɛŋ shiishi lo bakwɛŋkfu, bɛŋ gee chibuunɛ chì ndefe chi kinchiaasɛ ye. Bɛŋ kêe lɛ wene ŋgɛ lé wu fô lo. ");
INSERT INTO ncr_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ŋgɛ wù baaŋ le wene bɛŋ bamii ba duunyi banchi mo bɛŋ Bafalashii. Bɛŋ le bamii ba jɛme yeye, bɛŋ gee yeye! Bɛŋ jade bɛŋ jiɛnyɛ woŋ wuchii bɛŋ daŋe jóo yì baaŋ baaŋ lɛ bɛŋ goone muh wu mumwaa wù bɛŋ fiisɛ wu tu muh wene wu mbɛmɛ. Nɛ wu le wu tu wa muh wene wu mbɛmɛ, bɛŋ kaasɛ bɛŋ ge fie mɛsɛ fi fo lo, wu tu wu nyu wa muh wu ŋgu wù baaŋ gɛh njɛ bɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ŋgɛ wù baaŋ le wene. Bɛŋ le binfeeŋ bɛŋ duu lɛ bɛŋ duunyi je bamii le! Bɛŋ nyu bamii ba duu lɛ, ‘Nɛ muh jɛme fiɛɛ, wu kaŋ jee chi yeh yi kintanyɛ, tu gɛ nyu fiɛɛ gɛ. Geenɛ, muh nɛ jɛme fiɛɛ wu kaŋ nyu jee chi kichwa ki bige kì yɛɛde ki yeh yi kintanyɛ le, tu wù kɛme ki wu gê no wu jɛme wu kaŋ.’ ");
INSERT INTO ncr_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Binfeeŋ binɛ! Bɛŋ le biyuŋ! Fiɛɛ fì kuge fì fede fimi le fì la? Baaŋ kuge kichwa ki bige kì yɛɛde noo, yeh yi kintanyɛ yì gee kichwa kiyu fɛ ki nyu fiɛɛ fì le fi Nyo le? ");
INSERT INTO ncr_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Bɛŋ jɛme tɛ lɛ, ‘Nɛ muh jɛme fiɛɛ wu kaŋ jee chi kitana ki kintanyɛ, tu gɛ nyu fiɛɛ gɛ. Geenɛ muh jɛme fiɛɛ wu kaŋ nyu jee chi fiɛɛ fì muh nya kintanyɛ yu, tu wù kɛme ki wu gê no wu jɛme wu kaŋ.’ ");
INSERT INTO ncr_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Binfeeŋ binɛ! Fiɛɛ fì kuge fì fede fimi le fì la? Baaŋ le nnya yì kuge noo, kitana ki kintanyɛ kì gee nnya yiyu nyume fiɛɛ fì le fi Nyo le? ");
INSERT INTO ncr_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Fiɛɛ fì le, le lɛ nɛ muh kaŋ jee chi kitana ki kintanyɛ, tu wu kaŋ noo wu kaŋ mo mwɛɛ munchii mù nyume yu. ");
INSERT INTO ncr_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nɛ muh kaŋ jee chi yeh yi kintanyɛ, tu wu kaŋ noo wu kaŋ mo Nyo wù chee yu. ");
INSERT INTO ncr_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nɛ muh kaŋ woŋ wu we, tu wu kaŋ nyu kala wù Nyo mo wu wù Nyo wù shiide yì wu le. ");
INSERT INTO ncr_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ŋgɛ wù baaŋ le wene bɛŋ bamii ba duunyi banchi mo bɛŋ Bafalashii. Bɛŋ le bamii ba jɛme yeye, bɛŋ gee yeye! Bɛŋ to bɛŋ nyaa kimbe kimimia Nyo le a ntɛnɛɛ a bimbe yuufe bi mwɛɛ yeye yeye mù bɛŋ kege bɛŋ gɛɛde a mbáa le lɛ yi yege, geenɛ bɛŋ nooŋe fiɛɛ fì jiji fì nchi jɛme kune fi lɛ bɛŋ gêe, fì le ki bɛŋ gêe mwɛɛ mù kooji fɛ bamii le, bɛŋ kôode yii fɛ bamii le mo ki bɛŋ lêese fitele yi Nyo le. Bɛŋ be kɛme ki bɛŋ gêe mwɛɛ munɛ munchii bɛŋ chinɛ gɛ fimi le gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Binfeeŋ bì duunyi je bamii le! Bɛŋ kuuji munyinyi bɛŋ bvuuse a mbvuuŋ le, geenɛ bɛŋ ka mii nyaŋ yì baaŋ ashɛŋ! ");
INSERT INTO ncr_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ŋgɛ wù baaŋ le wene bɛŋ bamii ba duunyi banchi mo bɛŋ Bafalashii. Bɛŋ le bamii ba jɛme yeye, bɛŋ gee yeye! Bɛŋ chuge muŋkoo bɛ shú ye le, geenɛ mwɛɛ mù yisɛ yo le mù bɛŋ lode a bamii le mo mù bɛŋ yɛɛde ajii yu. ");
INSERT INTO ncr_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Binfeeŋ bi Bafalashii, bɛŋ ya bɛŋ chugɛ muŋkoo bɛ shú nyu antɛŋ, mu mo mu yuude tɛ ye le. ");
INSERT INTO ncr_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ŋgɛ wù baaŋ le wene bɛŋ bamii ba duunyi banchi mo bɛŋ Bafalashii. Bɛŋ le bamii ba jɛme yeye, bɛŋ gee yeye! Bɛŋ le njɛ jɛ́ŋ yì ba le ba seesɛ ba yefɛ yi tu yi baaŋ yi chuunyi ajii yi joŋe, geenɛ antɛŋ ayu nyu a yisɛ bɛ biŋkufɛ bi biŋkwe bi bamii mo mwɛɛ munchii mù yiide. ");
INSERT INTO ncr_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Le gɛh yɛɛŋyɛɛŋ no bɛŋ chuunyi ajii lɛ bɛŋ le bamii ba chaaŋ, geenɛ antɛŋ nyu bɛŋ yisɛ bɛ kinlɛlɛ mo gee chì befe. ");
INSERT INTO ncr_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ŋgɛ wù baaŋ le wene bɛŋ bamii ba duunyi banchi mo bɛŋ Bafalashii. Bɛŋ le bamii ba jɛme yeye, bɛŋ gee yeye! Bɛŋ ba joone jɛ́ŋ yi bamii ba ntuŋ wu Nyo, bɛŋ yeefe tɛ jɛ́ŋ yi bamii ba gɛ̀ kɛme kinche kì chaaŋ bɛŋ seese yi joŋe. ");
INSERT INTO ncr_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Bɛŋ gee noo bɛŋ duu lɛ, ‘Nɛ gɛ̀ bee bee nyu wa yu kife ki bachiji chiji le, tu bee gɛ̀ baaŋ lɛɛŋ gɛ fiesa fɛ fiɛɛ fì bo gɛ̀ ge fɛ ba yuuyɛ bamii ba ntuŋ wu Nyo gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Bɛŋ jɛme noo, bɛŋ jɛme nyu kune bikwɛɛ biɛna bɛŋ mo toone bɛ de yene lɛ bɛŋ le booŋ ba bamii ba gɛ̀ yuuyi bamii ba ntuŋ wu Nyo. ");
INSERT INTO ncr_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Bɛŋ mo bɛŋ gɛɛŋ lo fwe bɛŋ mɛsɛ bɛ lɛme chì bachiji chiji bena gɛ̀ kɛ! ");
INSERT INTO ncr_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yó chinɛ! Kiŋgogɛ ki yó lɛ kinɛ! Bɛŋ kwaji lɛ bɛŋ lé bɛŋ nyûme njɛ ba leesɛ bɛŋ yi ŋgu wu baaŋ le sɛŋ? ");
INSERT INTO ncr_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","No fi le noo, mɛ mo ntune bamii ba ntuŋ wu Nyo fɛ bɛŋ le mo bamii ba bvufee bɛ bamii ba duunyi banchi. Bɛŋ lé bɛŋ yûuyi bamu, bɛŋ taayi bamu yi bintaaŋ le, bɛŋ suŋe bamu yéh yene yi buunɛ le, bɛŋ boone bikaa a bamu jiŋ a bilaantɛŋ le bichii bì bo gɛɛne bi le. ");
INSERT INTO ncr_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Bɛŋ lé bɛŋ gêe noo lɛ kilɛmɛ ki bamii bachii ba gɛ̀ chee kinche kì chaaŋ yi nshɛŋ yinɛ le ba bo gɛ̀ yuuyɛ ki nyû fɛ bɛŋ fwa. Kilɛmɛ kinɛ lé ki nyû fɛ bɛŋ fwa kɛge yi ki Abɛ wù ba gɛ̀ yuuyɛ njɛ wù kɛme jialɛ sɛŋ, to bu yi ki Sakiya wù mwa Belekaya wù bɛŋ gɛ̀ yuuyɛ antɛnɛɛ a yeh yi kintanyɛ bɛ kitana ki kintanyɛ le. ");
INSERT INTO ncr_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nsɛŋe bɛŋ nchiɛɛŋ lɛ, loŋ wu mwɛɛ munɛ munchii lé wu gê wu koo kiŋgogɛ ki mɛɛse kinɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","No Jiso jɛmɛ nɛ, wu mo wu kɛŋ ye lɛ, “Yɛɛbɛɛ Yɛlusalɛm! Yɛɛbɛɛ Yɛlusalɛm! Wo wù yuuyi bamii ba ntuŋ wu Nyo, wo ka tume bamii ba Nyo tuŋ fɛ wo le bɛ ata! Le wa kiŋgane kimɛɛ no mɛ moŋ ki mbanyɛ booŋ buŋ njɛ no bweshii to wu banyɛ booŋ be yi kfugɛ a bibɛɛ bie le, wo faŋ? ");
INSERT INTO ncr_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Bîjɛ yɛ̂ŋ yeh yo lé yi gê yi tu kinfu. ");
INSERT INTO ncr_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nsɛŋe lo wo le lɛ gɛ wo baaŋ wo ka wo yɛŋ mɛne gɛ, gɛɛŋ bu kife kì wo le wo du lɛ, ‘Nyo le wu noŋ kimbonɛ yi muh wù too a jee chi Tada Nyo le.’” ");
INSERT INTO ncr_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jiso bu yeh yi kintanyɛ le, wu doo wu gɛɛne, booŋ be ba ŋgoo kɛŋsɛ bo to mbebe ye le bo duunyi yéh yi fɛ yeh yi kintanyɛ le wu le. ");
INSERT INTO ncr_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Geenɛ, Jiso jɛmɛ bo le lɛ, “Bɛŋ yɛde yéh chinɛ le? Nsɛŋe bɛŋ nchiɛɛŋ lɛ gɛ tɛdɛ chimimia nyu chi shɛɛ yi chimi le njɛ ba kɛsɛ chi fɛkuu sɛŋ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jiso doo wu gɛɛŋ wu bɛɛŋ wu shii yi Mbegɛ wu Bite bi Olif le, booŋ be ba ŋgoo kɛŋsɛ bo to lɛbolɛbo fɛ wu le bo biih lɛ, “Gɛh sɛɛŋ bee kife kì fiɛɛ fiyu finɛ lé fi gê fì kooshɛ, mo njiŋɛ wù lé wu gê wu dûnyɛ kife kì wo lé wo gê wo kaasɛ wo to mo no lɛ woŋ kage wa lo?” ");
INSERT INTO ncr_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jiso chvuu bo le lɛ, “Bɛŋ yɛ̂ne keefɛ muh to wu lɛɛ bɛ bɛŋ, bɛŋ jiaa je gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bɛŋ kêe lɛ bamii ba duude lé bo gê bo too bo jode jee chaŋ bo tɛyi fɛ jii, muh duu lɛ wu le Mbvusɛ wù Nyo gɛ̀ ka. Bo doo bo gee noo bo lɛɛde bɛ bamii ba duude bo jiaade je. ");
INSERT INTO ncr_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Bɛŋ lé bɛŋ gê bɛŋ yuge lɛ ba tune jɛŋ, bɛŋ ka yuge tɛ basaaka lɛ jɛŋ le yi nyume. Bɛŋ doo bɛŋ yuge noo, keefɛ fitele gûde bɛŋ gɛ. Munɛ lé mwɛɛ mù kɛme ki mu gê mu kooshɛ. Geenɛ gɛ mu mo duunyi lɛ woŋ kage wa lo gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kituŋ lé ki gê ki tune jɛŋ bɛ kimi, nfoŋ wumu tune jɛŋ bɛ wumu. Jɛŋ lé yi gê yi koode, nshɛŋ lé yi gê yi shîiŋshi manjuu le manjuu le. ");
INSERT INTO ncr_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mwɛɛ munɛ munchii baaŋ gɛh lo nsasɛ njɛ sege kwɛse kɛ lume. ");
INSERT INTO ncr_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Bamii lé bo gê bo nya bɛŋ ba nyiɛge bɛ bɛŋ, ba yuuyɛ bɛŋ. Bituŋ bichii lé bi gê bi banɛ bɛŋ nje jee chaŋ. ");
INSERT INTO ncr_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Noo, bamii ba duude mo bo chii bikaa a mɛ jiŋ, bo banɛ bikwɛɛ biboo, bo gese bikwɛɛ biboo. ");
INSERT INTO ncr_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bamii ba duude ba mbiane lɛ tuŋ Nyo bo, bo lé bo jâ bo bunɛ bo lɛɛde bɛ bamii wesee. ");
INSERT INTO ncr_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","No kimbefɛ lé ki gê ki duude ki gɛɛne lo fwe, ki ge kiŋkoŋɛ ki bamii ba duude mo ki tu wɛɛ. ");
INSERT INTO ncr_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Geenɛ, muh wù lé wu gê wu kaaŋ shɛ́ŋ gɛɛŋ bu fɛkimɛsɛ lé wù gê wu bonɛ. ");
INSERT INTO ncr_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Bo kɛme gɛh ki bo ge bo fêjɛ saaka wù joŋe wunɛ wù kune bvunfoŋ bvu Nyo gɛɛŋ bu yi kikwɛɛ ki nshɛŋ le kichii bituŋ bichii yu, noo, fɛ woŋ ge wu ka. ");
INSERT INTO ncr_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Noo sege bɛŋ yɛŋ kiŋgha ki fiɛɛ kì taŋlo ki chɛŋɛ bɛ kijusɛ kì muh wu ntuŋ wu Nyo wù Danyɛ gɛ̀ jɛme kune ki, ki lɛme wa yeh yi kintanyɛ le, muh wù tɛŋe ŋwa wunɛ yu finɛ chuule, ");
INSERT INTO ncr_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","bamii ba le Judia mo bo fɛɛ lo bo bɛɛŋ yi bambegɛ le. ");
INSERT INTO ncr_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Keefɛ muh wù le kigo ki yeh le ka wu shii wu lee ki wu jô fiɛɛ fì le yeh gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Keefɛ muh wu le mwɛne ka wu kaase wu kwɛɛde lɛ wu to ki wu jô kikuŋ wu noŋ ye le gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ŋgɛ wù baaŋ le yi aju kaa le, lé wu gê wù nyu wu bikɛse ba le bɛ chifwe, mo ba yaŋse booŋ. ");
INSERT INTO ncr_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Bɛŋ bûune lɛ keefɛ kinlegɛ kinɛ ki nyû yi kife ki nfuŋ le, kɛnɛ juu chi yuuŋ gɛ, ");
INSERT INTO ncr_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","nje ŋgɛ wù baaŋ lé wu gê wu nyûme kife kɛɛ le, kfuu chi wu wɛɛ ŋgɛ gɛ̀ baaŋ a nyu gɛ yu gɛ, kɛge no woŋ gɛ̀ kɛ too bude mɛɛse, gɛ kfuu chi wu wɛɛ baaŋ wu ka wu yu wù nyu yu gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nɛ Nyo gɛ̀ baaŋ gade gɛ aju a ŋgɛ ayu gɛ, tu muh wu wuŋ wu mumwaa bee gɛ wu bonɛ gɛ. Geenɛ wu gɛ̀ gade aju ayu nje bamii be ba wu gɛ̀ cha. ");
INSERT INTO ncr_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Lé doo nyûme sege kɛɛ nɛ muh lé wu jɛ̂mɛ bɛŋ le lɛ, ‘Bɛŋ jîŋɛ bɛŋ yɛ̂ŋ, Mbvusɛ wù Nyo gɛ̀ ka nɛ wu wunɛ fɛnɛ!’ Kɛnɛ lɛ, ‘Nɛ wu wege fege!’ Keefɛ bɛŋ bɛ̂ɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Bɛŋ kêe lɛ bamii lé bo gê bo too bo mbiane lɛ bo le bambvusɛ ba Nyo gɛ̀ ka, bamu duu lɛ bo le bamii ba ntuŋ wu Nyo, bo mo bo gee mwɛɛ mù tɛɛme mù duunyi bvuŋga bvuboo, bo gee tɛ mwɛɛ mù jwe yune, ki bo lɛ̂ɛde bɛ bamii bo jiaade je, bo lɛ̂ɛde mo tɛ bɛ bamii ba Nyo gɛ̀ cha wa, nɛ je le yu. ");
INSERT INTO ncr_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Bɛŋ yêgɛ bɛŋ yû, nle nsɛɛŋ wa mwɛɛ munɛ bɛŋ le fɛ mu ge mu kooshi. ");
INSERT INTO ncr_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Noo, bamii ja bo duu bɛŋ le lɛ, ‘Bɛŋ jîŋɛ bɛŋ yɛ̂ŋ, Mbvusɛ wù Nyo gɛ̀ ka nɛ wu wege chvuuŋ’, keefɛ bɛŋ gɛ̂ɛŋ fo gɛ. Kɛnɛ lɛ, ‘Bɛŋ jîŋɛ bɛŋ yɛ̂ŋ, nɛ wu wunɛ yeh antɛŋ’, keefɛ bɛŋ bɛ̂ɛŋ bo le gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bɛŋ kêe lɛ no jaŋ to yi lale we kimbe kì juu saane le, yi baaŋ yi gɛɛŋ yi bu a juu seele yo, le gɛh yɛɛŋyɛɛŋ no nto wu muh wù jee che le Mwamuh lé wu gê wu nyûme. ");
INSERT INTO ncr_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","‘Mo nyu faaŋ fɛ gvunɛ chi fiɛɛ to chi nyume fo, le gɛh fo fɛ baŋgvuluŋ to bo taashi fo.’ ");
INSERT INTO ncr_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Kimimia, sege kife ki ŋgɛ wù baaŋ wunɛ to wa ki fe, juu ja gɛh nɛ chi jimɛ, kwii gɛ ka wu baaŋ gɛ, jóŋ jade fɛwe yi gweeyi, mwɛɛ mù fɛwe munchii mù kɛme bvuŋga shiiŋshi. ");
INSERT INTO ncr_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Njiŋɛ wu muh wù jee che le Mwamuh mo wu bunɛ yi kibvulɛ le. Bituŋ bichii bi yi nshɛŋ le mo bi kɛ bi fuge lo bɛ kwe. Bamii lé bo gê bo yɛŋ no muh wù jee che le Mwamuh too yi kimbɛ le fɛwe bɛ bvuŋga mo bvukugɛ bvù baaŋ. ");
INSERT INTO ncr_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Sege soŋ yì baaŋ ge doo yi jɛmɛ fɛwɛɛwe, wu mo wu chiiŋsɛ banchɛndaa be bo gɛɛŋ abu a woŋ le ana mo fɛwe, bo banyɛ bamii be ba wu le wu cha wa. ");
INSERT INTO ncr_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Bɛŋ yɛ̂yɛ fiɛɛ yi kiŋgvuŋ le. Chɛ́ too yi boji, biŋkamɛ kɛ bi choone yi chɛ́ yiyu le, bɛŋ mo bɛŋ kɛɛ lɛ akfuuŋ kuse wa. ");
INSERT INTO ncr_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Le gɛh yɛɛŋyɛɛŋ no bɛŋ ge doo bɛŋ yɛne mwɛɛ munɛ le munchii, bɛŋ mo bɛŋ kêe lɛ wu le wa mbebe le, mo a yeh fwɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nsɛŋe bɛŋ nchiɛɛŋ lɛ gɛ kiŋgogɛ ki mɛɛse kinɛ nyu ki to ki ka, njɛ mwɛɛ munɛ munchii kooshɛ sɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kibvulɛ bɛ nshɛŋ lé ki tô ki ka, geenɛ gɛ̀ jɛ yaŋ nyu yi to yi shiiŋshɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Geenɛ gɛ muh nyu yu wù kee juu chiyu kɛnɛ kife kiyu gɛ. Gɛ banchɛndaa ba Nyo ba fɛwe kɛnɛ Mwa Nyo kee tɛ gɛ. Kee gɛh Nyo wù Chiji maa. ");
INSERT INTO ncr_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Gɛh yɛɛŋyɛɛŋ no fi gɛ̀ bee kife ki Nyua le, nyu gɛh no fi lé fi gê fi nyume kife kì muh wù jee che le Mwamuh kaase wu too. ");
INSERT INTO ncr_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Gɛ̀ bee joo baaŋ a yisɛ gɛ yi kikwɛɛ ki nshɛŋ le gɛ, bamii nyu fiboo bo jii mwɛɛ bo ka muu, bikɛse bɛ bilɛŋsɛ taashi bvuguu, bamii nyaa booŋ ba bilɛŋsɛ bo taashi bvuguu bɛ bo, gɛɛŋ bu juu chì Nyua gɛ̀ lesɛ a ŋguh le, ");
INSERT INTO ncr_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","bamii bayu gɛ̀ baaŋ kɛɛ gɛ fiɛɛ fì lé fi kôoshɛ gɛ̀, gɛɛŋ bu sege joo gɛ̀ yisɛ yi nshɛŋ le, yi kudɛ bo bachii yi gɛɛŋ bɛ bo. Le gɛh yɛɛŋyɛɛŋ no fi lé fi gê fi nyume juu chì muh wù jee che le Mwamuh lé wu gê wu tô. ");
INSERT INTO ncr_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Bilɛŋsɛ bafɛɛ lé bo nyû mwɛne, ba jô wu mumwaa wu mumwaa shɛ̂ɛ. ");
INSERT INTO ncr_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Bikɛse bafɛɛ lé bo gê bo goge bvulɛɛŋ fɛ jɛɛŋ, ba jô wu mumwaa wu mumwaa shɛ̂ɛ. ");
INSERT INTO ncr_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Noo, bɛŋ mo bɛŋ chîɛɛne nje gɛ bɛŋ kee juu chì Tada wene lé wu gê wu tô gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Bɛŋ kêe lɛ chiji yeh nɛ kee kife kì choŋ lé wu gê wu tô antaŋ, wu chîɛɛne, wu gɛ ka wu chinɛ lɛ wu to wu ŋgode yeh ye gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Fi mo fi nyu lɛ, bɛŋ tɛ kɛme ki bɛŋ chîɛɛne nje muh wù jee che le Mwamuh lé wu gê wu kaasɛ wu to kife kì bɛŋ kee gɛ le. ");
INSERT INTO ncr_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Mwa lɛme wù le wù nchiɛɛŋ wù ka kɛme bvufee le wù la? Gɛ nyume muh wɛɛ wù chiji kikwɛɛ ke le wu gɛɛ wu lɛ wu jîiŋe fɛ yeh ye le, sege kife doo ki kojɛ, wu nya mwɛɛ munjile booŋ be ba lɛme le gɛ? ");
INSERT INTO ncr_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kinlaŋye kì baaŋ lé ki gê ki nyume ki mwa lɛme wù chiji kikwɛɛ ke, sege wu doo wu too wu yɛŋ wù gee lɛme gɛh yɛɛŋyɛɛŋ no wu bee ki wù gee. ");
INSERT INTO ncr_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nsɛŋe bɛŋ nchiɛɛŋ lɛ chiji kikwɛɛ ke lé wu gê wu bɛɛŋsɛ wu, wu jiiŋe fɛ mwɛɛ mwe le munchii. ");
INSERT INTO ncr_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Geenɛ, nɛ mwa lɛme wɛɛ ja wù kɛme kiŋge kì befe, wu jɛmɛ kikwɛɛ ke le lɛ, ‘Gɛ chiji kikwɛɛ kaŋ nyu wu yaŋsɛ wu kaasɛ wu to gɛ’, ");
INSERT INTO ncr_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","wu mo wu kɛ wu suŋe booŋ ba lɛme bamu ba bɛ bo lɛne, wu jii mwɛɛ wu ka muu bɛ bamii ba yaane mbvuuŋ, ");
INSERT INTO ncr_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","tu chiji kikwɛɛ ke lé wu gê wu ja gɛh wu bunɛ juu chimi chì wu be kwaji gɛ, bɛ kife kì wu be kee gɛ le. ");
INSERT INTO ncr_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Wu doo wu bu noo, wu mo wu gwoojɛ lo mwa ye wu lɛme wɛɛ, wu chiiŋsɛ wu wu gɛɛŋ wù nyu bɛ bamii ba jɛme yeye, bo gee yeye le, nyu fo fɛ bamii lé bo gê bo beede bo ŋgeji bige.” ");
INSERT INTO ncr_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Lé tô nyû kife kɛɛ le taŋlo ba beji bvunfoŋ bvù fɛwe bɛ ŋgóoŋ yi bikɛse yimi yuufe ba gɛ̀ jo bin'yesɛ biboo, bo bu ki bo gɛɛŋ bo fi chiji bvuguu wumu. ");
INSERT INTO ncr_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bo gɛ̀ bee noo batɛŋ nyu biyuŋ, batɛŋ nyu bafeefe. ");
INSERT INTO ncr_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Fì le lɛ ba gɛ̀ bee biyuŋ gɛ̀ jo bin'yesɛ biboo bo gɛ ka bo jo mɛɛ mamu mbebe le gɛ, ");
INSERT INTO ncr_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","geenɛ ba gɛ̀ feefe baa jo biboo bin'yesɛ bo ka bo jo mɛɛ mamu mbebe le. ");
INSERT INTO ncr_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Bo gɛɛŋ bo chiɛɛne chiji bvuguu wɛɛ, wu she yo wesee fɛ wu to, lefɛ mo chi kɛ chi jode bo, bo mo bo lee. ");
INSERT INTO ncr_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Lɛ nyume antaŋ antɛnɛɛ, bo ja bo yu muh wuule lɛ, ‘Yilili Yilili, bɛŋ jîŋɛ bɛŋ yɛ̂ŋ, chiji bvuguu wunɛ lɛɛɛ! Bɛŋ bû bɛŋ tô bɛŋ fî wu lɛɛɛ.’ ");
INSERT INTO ncr_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ŋgóoŋ yi bikɛse baa bachii mo bo ja we bo bɛɛŋsɛ bin'yesɛ biboo. ");
INSERT INTO ncr_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ŋgóoŋ yi bikɛse ba gɛ̀ bee biyuŋ baa bo jɛmɛ ba gɛ̀ feefe baa le lɛ, ‘Kii bɛŋ, bɛŋ nya bee bɛ mɛɛ mɛna mamu. Bin'yesɛ biɛsa shiide wa lo.’ ");
INSERT INTO ncr_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Geenɛ, ba gɛ̀ feefe baa chvuu lɛ, ‘Gɛ mo nyu mo kojɛ fɛ bee le bachii gɛ. Bɛŋ gɛɛŋ nyu fɛ bamii ba gese le, bɛŋ gu mɛna.’ ");
INSERT INTO ncr_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","No bo gɛ̀ gɛɛne ki bo gu, chiji bvuguu mo wu shɛɛ wu fɛsɛ. Baa ba gɛ̀ bee bo seesɛ wa ye yiboo bo chiɛɛne, bo mo bo gɛɛŋ bo lee bɛ wu yeh yi ŋka wu bvuguu le, bo mo bo faa kimbuŋ. ");
INSERT INTO ncr_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ajiŋ ayu ŋgóoŋ yi bikɛse yimi chiɛɛ bo gɛ̀ gɛnɛ ki bo gu mɛɛ fɛsɛ tɛ, bo lɛɛŋ a nfwɛɛŋ bo tu bo duu lɛ, ‘Chiji kikwɛɛ, chiji kikwɛɛ, gwenyɛ kimbuŋ bee lee.’ ");
INSERT INTO ncr_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Geenɛ, wu chvuu bo le lɛ, ‘Nsɛŋe bɛŋ nchiɛɛŋ lɛ gɛh ŋkee bɛŋ gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Fi mo fi nyu lɛ, bɛŋ sêesɛ ye, bɛŋ chîɛɛne, nje gɛ bɛŋ kee juu kɛnɛ kife kiyu gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Kife kiyu le fi lé fi gê fi nyu njɛ muh mu wù gɛ̀ gɛɛne njiɛnyɛ, wu tɛɛŋ booŋ be ba lɛme lɛ wu gɛɛ kwa we chiaaŋ yiboo le. ");
INSERT INTO ncr_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Wu gɛ̀ nya mwa wu lɛme wumu bikɛɛ bi bige bitɛŋ, wu nya wumu bikɛɛ bifɛɛ, wu nya wumu kikɛɛ ki bige kimimia. Wu gɛ̀ nyaa wu bii no bvuŋga bvu muh le. No wu gɛ̀ nya noo, wu mo wu la njiɛnyɛ we. ");
INSERT INTO ncr_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mwa wu lɛme wù gɛ̀ fi bikɛɛ bi bige bitɛŋ mo wu gɛɛŋ kimimia wu ge waaŋ yu, wu ji mbe bikɛɛ bitɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wù gɛ̀ fi bikɛɛ bifɛɛ wu ge tɛ waaŋ, wu ji mbe bikɛɛ bifɛɛ. ");
INSERT INTO ncr_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Geenɛ, mwa lɛme wù gɛ̀ fi kikɛɛ kimimia wɛɛ, gɛɛŋ fie wu chiŋ fɛkuu wu nyilɛ bige bi chiji kikwɛɛ wɛɛ fo. ");
INSERT INTO ncr_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Chiji kikwɛɛ wu booŋ ba lɛme baa gɛ̀ la njiɛnyɛ we, wu gɛɛŋ wu che yo wesee. Wu gɛ̀ doo wu kaasɛ wu to, wu mo wu tɛɛŋ booŋ be ba lɛme lɛ bɛ bo najɛ mwɛɛ. ");
INSERT INTO ncr_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mwa lɛme wù gɛ̀ fi bikɛɛ bi bige bitɛŋ mo wu to nyu bɛ bikɛɛ yuufe, wu jɛmɛ lɛ, ‘Chiji kikwɛɛ, wo gɛ̀ nya mɛ bikɛɛ bi bige bitɛŋ, bîjɛ yɛ̂ŋ, nle nshɛɛ ŋge waaŋ yu, ŋkɛme bimi bikɛɛ bitɛŋ yu we.’ ");
INSERT INTO ncr_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Chiji kikwɛɛ wɛɛ jɛmɛ wu le lɛ, ‘Kiyone baaŋ. Wo le mwa lɛme wù joŋe wo ka nyume wù nchiɛɛŋ! Wo le wo shɛɛ wo kɛɛ ki wo bîjɛ fɛ fiɛɛ fì shige le. Noo, nlé ŋgɛ̂ɛ wo mɛɛse wo jîiŋe nyu fɛ fì kuge le. Lêe antɛnɛɛ a bvujoŋɛ bvu chiji kikwɛɛ kuŋ.’ ");
INSERT INTO ncr_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mwa lɛme wù bie bige gɛ̀ bee bikɛɛ bifɛɛ to tɛ, wu jɛmɛ lɛ, ‘Chiji kikwɛɛ, wo gɛ̀ nya mɛ bikɛɛ bi bige bifɛɛ. Bîjɛ yɛ̂ŋ, nle nshɛɛ ŋge waaŋ yu, ŋkɛme bimi bikɛɛ bi bige bifɛɛ yu we.’ ");
INSERT INTO ncr_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Chiji kikwɛɛ wɛɛ jɛmɛ wu le lɛ, ‘Kiyone baaŋ wo le mwa lɛme wù joŋe wo ka nyume wù nchiɛɛŋ! Wo le wo shɛɛ wo kɛɛ ki wo bîjɛ fɛ fiɛɛ fì shige le. Noo, nlé ŋgɛ̂ɛ wo mɛɛse wo jîiŋe nyu fɛ fì kuge le. Lee antɛnɛɛ a bvujoŋɛ bvu chiji kikwɛɛ kuŋ.’ ");
INSERT INTO ncr_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Mwa lɛme wumu wɛɛ wù gɛ̀ fi kikɛɛ ki bige kimimia to tɛ, wu jɛmɛ lɛ, ‘Chiji kikwɛɛ, ŋkee lɛ wo le muh wù tɛɛme ajiŋ. Wo to wo gweji wo baaŋ booŋ gɛ, wo gwode agiŋ wo baaŋ a noŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Noo, mɛ mo nfaaŋ ŋgɛɛŋ nyilɛ bige biuŋ fɛkuu. Bîjɛ wo yɛŋ, nɛ bige biuŋ binɛ, kô.’ ");
INSERT INTO ncr_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Geenɛ chiji kikwɛɛ wɛɛ chvuu wu le lɛ, ‘Wo le mwa lɛme wù befe, wo le kiŋkwɛŋ! Wo gɛ̀ kee lɛ nto ŋgweji mbaaŋ mbooŋ gɛ, mbaanyi agiŋ mbaaŋ noŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","No wo gɛ̀ kee noo, tu wo gɛ̀ bee wo gɛɛ bige biaŋ a chvu le lɛ sege ŋkaasɛ nfi bige biaŋ biyu bɛ mbe yu we.’ ");
INSERT INTO ncr_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","No wu jɛme noo, wu mo wu jɛmɛ lɛ ba fî kikɛɛ ki bige kiyu a wu le, ba nyâ wù gɛ̀ kɛme bikɛɛ bi bige yuufe le. ");
INSERT INTO ncr_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Bɛŋ kêe lɛ muh wù kɛme ba lé ba bîsɛ lo wu kɛme fi duude. Geenɛ muh wù kɛme gɛ, lé ba nyû ba fî mo fiɛɛ fì shige fì wu kɛme. ");
INSERT INTO ncr_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","No wu jɛme noo wu mo wu jɛmɛ lɛ, ‘Bɛŋ nôŋ kinɛnɛ ki mwa lɛme kinɛ kijibɛ le akfuuŋ, fɛ bamii lé bo gê bo beede fo bo ŋgeji bige.’ ");
INSERT INTO ncr_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Doo nyume kife ki muh wù jee che le Mwamuh kaase wu too bɛ bvukugɛ bwe, wu too bɛ banchɛndaa ba Nyo bachii, wu mo wu shii yi kala we wu bvukugɛ le. ");
INSERT INTO ncr_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bituŋ bichii bi yi kikwɛɛ ki nshɛŋ le banyɛ a wù fwe, wu mo wu ga bo njɛ no muh wu chiɛɛne to wu ga shóŋ wu bvusɛ yi a bí ntɛnɛɛ. ");
INSERT INTO ncr_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Wu lé wu gɛ̀ɛ shóŋ kibo kinchiɛɛŋ le, wu gɛɛ bí kibo kiŋkoŋo le. ");
INSERT INTO ncr_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Wu wù Nfoŋ mo wu du baa bo le kibo kinchiɛɛŋ le lɛ, ‘Bamii ba chii le wu noŋ kimbonɛ yi bo le, bɛŋ to bɛŋ kɛme kijusɛ antɛnɛɛ a bvunfoŋ bvu wu gɛ̀ seesɛ fɛ bɛŋ le kɛge no ba gɛ̀ fɛ woŋ, ");
INSERT INTO ncr_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","nje jɛŋ gɛ̀ yuu mɛ, bɛŋ nya mɛ bɛ mwɛɛ munjile. Kindoŋ gɛ̀ yune mɛ, bɛŋ nya mɛ bɛ fiɛɛ fì mɛ muu. Ŋgɛ̀ bee ntolo, bɛŋ fi mɛ. ");
INSERT INTO ncr_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ŋgɛ̀ bee kichinɛ kiyɛse, bɛŋ jii nju ye yaŋ le. Ŋgɛ̀ chɛne bɛŋ to bɛŋ yɛsɛ mɛne. Ŋgɛ̀ bee yeh yi ncha le, bɛŋ to bɛŋ yɛsɛ mɛne.’ ");
INSERT INTO ncr_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Wu doo wu ge wu jɛme noo, bamii ba chaaŋ bayu mo bo biih wu le lɛ, ‘Tada, le sege la wù bee gɛ̀ yɛŋ wo le jɛŋ yuu wo, bee nya wo mwɛɛ munjile, kɛnɛ sege la wù kindoŋ gɛ̀ yune wo bee nya fiɛɛ fì wo mu? ");
INSERT INTO ncr_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Le sege la wù bee gɛ̀ yɛŋ wo le wo nyu ntolo, bee fi wo, kɛnɛ kichinɛ kiyɛse, bee jii nju ye yo le? ");
INSERT INTO ncr_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Le sege la wù bee gɛ̀ yɛŋ wo le wo chɛne kɛnɛ wo nyu yeh yi ncha le, bee to be yɛsɛ wo le?’ ");
INSERT INTO ncr_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nfoŋ mo wu chvûu bo le lɛ, ‘Nsɛŋe bɛŋ nchiɛɛŋ lɛ no bɛŋ gɛ̀ gee mwɛɛ munɛ, fɛ muh wù shige le fɛ booŋ ba bwɛɛŋ banɛ le, tu bɛŋ gɛ̀ ge nyu fɛ mɛne.’ ");
INSERT INTO ncr_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Noo, wu mo wu du baa bò le a kibo kiŋkoŋo le lɛ, ‘Bɛŋ ba loŋ le wu koo, bɛŋ jâ lo a mɛ jii, bɛŋ gɛ̂ɛŋ bɛŋ lêe yi ŋgu wù kage gɛ le, wù ba gɛ̀ seesɛ fɛ debele le bɛ banchɛndaa be, ");
INSERT INTO ncr_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","nje jɛŋ gɛ̀ yuu mɛ, bɛŋ gɛ nya mɛ bɛ fiɛɛ fijile gɛ. Kindoŋ gɛ̀ yune mɛ, bɛŋ gɛ nya mɛ bɛ fiɛɛ lɛ mɛ mu gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ŋgɛ̀ bee ntolo, bɛŋ gɛ fi mɛ gɛ. Ŋgɛ̀ bee kichinɛ kiyɛse, bɛŋ gɛ jii mɛ nju gɛ. Ŋgɛ̀ nchɛne, ŋka nyu yeh yi ncha le, bɛŋ gɛ to bɛŋ yɛsɛ mɛne gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Bo tɛ mo bo ge bo biih wu le lɛ, ‘Tada, le sege la wù bee gɛ̀ yɛŋ wo le jɛŋ yuu wo, kɛnɛ kindoŋ yune wo, kɛnɛ wo nyu ntolo, kɛnɛ kichinɛ kiyɛse, kɛnɛ wo chɛne, kɛnɛ yeh yi ncha le, bee gɛ fih wo gɛ?’ ");
INSERT INTO ncr_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Wu mo wu chvuu bo le lɛ, ‘Nsɛŋe bɛŋ nchiɛɛŋ lɛ, no bɛŋ gɛ̀ baaŋ ge gɛ mwɛɛ munɛ, fɛ muh wù shige le fɛ booŋ ba bwɛɛŋ banɛ le gɛ, tu bɛŋ gɛ̀ baaŋ ge gɛ nyu fɛ mɛne gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Bobaa bamii mo bo gɛ̂ɛŋ bo lêe ŋgɛ wù kage gɛ le. Geenɛ, baa bò le chaaŋ gɛ̂ɛŋ bo lêe fiboo nyu kinche kì kage gɛ le.” ");
INSERT INTO ncr_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jiso jɛmɛ mwɛɛ munɛ munchii wu mɛsɛ, wu jɛmɛ booŋ be ba ŋgoo le lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Bɛŋ kêe lɛ shɛge wa aju afaa, mo nyume Ŋka wu Ndaŋfe, ba lé ba nyâ muh wù jee che le Mwamuh chiaaŋ yi bamii le ba ta wu yi kintaaŋ le.” ");
INSERT INTO ncr_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Gɛh kife kiyu le, bachiji kintanyɛ ba baaŋ baaŋ bɛ bamii ba sage woŋ mo bo gɛɛŋ bo banyɛ ye a nto wu Kayfa wù gɛ̀ bee kikwɛɛ ki bachiji kintanyɛ le, ");
INSERT INTO ncr_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","bo chu ntaŋ no bo lé bo gê bo wɛɛnɛ fɛ bo koo Jiso, bo yuuyɛ. ");
INSERT INTO ncr_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Bo doo bo chude ntaŋ noo, bo jɛmɛ lɛ, “Keefɛ bee moŋ fiɛɛ finɛ kife ki Ŋka wunɛ le gɛ, nje bee moŋ lo, fi to bɛ jwe a bamii ntɛnɛɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jiso gɛ̀ bee ntɛ wù Bɛtani le, a Samoŋ yeh wù gɛ̀ bee muh goŋ yì baaŋ. ");
INSERT INTO ncr_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Bo shii bo jii mwɛɛ, kwɛse wumu ja wu lee bɛ fikaaŋ fimi ba kɛnyi bɛ tɛdɛ nyu fi mɛɛ mamu mà gwee wuŋ, mò tɛɛme kwa baaŋ, wu mo wu fuushɛ yi kikwɛɛ ki Jiso le. ");
INSERT INTO ncr_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Booŋ ba Jiso ba ŋgoo yɛŋ noo fiɛɛ fiyu toonyɛ lo bo. Bo jɛmɛ lɛ, “Wu chɛŋe bɛ mɛɛ mayu nɛ nje la? ");
INSERT INTO ncr_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Bee taŋlo ba gesɛ mɛɛ manɛ yi bige le wesee, ba nya bige biyu bamii ba fuude le.” ");
INSERT INTO ncr_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Geenɛ, Jiso kɛɛ ŋkwajɛ wuboo, wu jɛmɛ bo le lɛ, “Bɛŋ nyaa ŋgɛ kwɛse wunɛ le nɛ nje la? Wu le wu ge nyu fiɛɛ fì joŋe fɛ mɛne. ");
INSERT INTO ncr_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Bɛŋ kêe lɛ bamii ba fuude lé bo gê bo nyu bena bo segechii, geenɛ gɛ mɛ nyu ŋge nyume bɛ bɛŋ segechii gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wu fuushi mɛɛ manɛ ye yaŋ le nɛ wu seese nyu njiiyɛ waŋ. ");
INSERT INTO ncr_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nsɛŋe bɛŋ nchiɛɛŋ lɛ mo nyu faaŋ fɛ ba lé ba gê ba feeji saaka wù joŋe wunɛ yi kikwɛɛ ki nshɛŋ le kichii fiɛɛ fì kwɛse wunɛ ge ba lé ba sɛ̂ŋe tɛ ki ba kwaji wu.” ");
INSERT INTO ncr_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Muh mu ŋgoo yi booŋ ba ŋgoo ba Jiso ba yuufe ncho bafɛɛ le, wù ba gɛ̀ tɛŋe lɛ Juda Ɛkaliot mo wu ja wu gɛɛŋ fɛ bachiji kintanyɛ ba baaŋ baaŋ le, ");
INSERT INTO ncr_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","wu biih bo le lɛ, “Mɛ nɛ nyâ Jiso chiaaŋ yene le, bɛŋ nyâ mɛ la?” Bo mo bo taŋ bige mbanshɛ bì ba kɛnyi bɛ kichwa kì baaŋ, bo nya wu le. ");
INSERT INTO ncr_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kɛge sege kɛɛ le, wu mo wu kɛ wu goone je yì wu lé wu nyâ Jiso chiaaŋ yiboo le. ");
INSERT INTO ncr_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lɛ doo nyume juu chi fwe chi Ŋka wu Blɛd wù ba baaŋ gɛɛ gɛ Kinshilɛ yo gɛ, booŋ ba ŋgoo ba Jiso to fɛ wu le, bo biih wu le lɛ, “Wo goone lɛ bee gɛɛŋ be seesɛ fɛ wo lé wo jî Ŋka wu Ndaŋfe fo nyu faaŋ?” ");
INSERT INTO ncr_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Wu chvuu bo le lɛ, “Bɛŋ gɛ̂ɛŋ alaantɛŋ, bɛŋ lé bɛŋ yɛ̂ŋ muh mu le, bɛŋ du wu le lɛ, ‘Muh wu N'yɛyɛ duu lɛ kife ke le ki kojɛ ka. Wu lé wu ji Ŋka wu Ndaŋfe bɛ booŋ be ba ŋgoo nyu a wo yeh.’” ");
INSERT INTO ncr_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Booŋ ba ŋgoo bayu gɛɛŋ bo ge gɛh no Jiso be jɛmɛ bo le, bo mo bo seesɛ mwɛɛ munjile mu Ŋka wu Ndaŋfe wuyu fo. ");
INSERT INTO ncr_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Lɛ to nyume fɛnfu, wu shii bɛ booŋ be ba ŋgoo ba yuufe ncho bafɛɛ ki bo jii. ");
INSERT INTO ncr_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Lɛ bo doo bo jii mwɛɛ, wu ja wu jɛmɛ bo le lɛ, “Nsɛŋe bɛŋ nchiɛɛŋ lɛ, muh mu bɛŋ le, lé wu gê wu gêsɛ mɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","No wu jɛmɛ noo, booŋ be ba ŋgoo tu bo nyume yii yii, bo kɛ bo biide wu le wu mumwaa wu mumwaa lɛ, “Le mɛ Tada?” ");
INSERT INTO ncr_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Wu chvuu bo le lɛ, “Muh wù lé wu gêsɛ mɛ le wù leesɛ kibo a shu le besa wu. ");
INSERT INTO ncr_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Muh wù jee che le Mwamuh lé wu gɛ̂ɛŋ gɛh no ba gɛ̀ saŋ kune wu. Geenɛ, ŋgɛ wù baaŋ le fɛ muh wu le wu gesɛ muh wù jee che le Mwamuh le. Fi be joŋe fɛ wuwɛɛ muh le lɛ keefɛ ba bôo wu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Juda wù gɛ̀ bee ki wu gêsɛ Jiso biih tɛ wu le lɛ, “Muh wu N'yɛyɛ le mɛ?” Jiso jɛmɛ wu le lɛ, “Wo le wo jɛmɛ bɛ jwe wo.” ");
INSERT INTO ncr_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","No bo jii mwɛɛ, Jiso ja wu jo blɛd, wu nya kiyone Nyo le, wu bweeyɛ wu nya booŋ be ba ŋgoo le wu jɛmɛ lɛ, “Bɛŋ ko bɛŋ ji, finɛ le ye yaŋ.” ");
INSERT INTO ncr_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Wu ka wu jo tɛ fiŋkoo, wu nya kiyone Nyo le wu mo wu nya fiŋkoo fiyu bo le wu jɛmɛ lɛ, “Bɛŋ mu bɛŋ bachii. ");
INSERT INTO ncr_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Finɛ le kilɛmɛ kaŋ kì Nyo le wu gwo maŋkaŋ yu ki bu nje bamii ba duude, wu lɛ wu lé wu lɛ̂ɛshɛ bimbefɛ biboo. ");
INSERT INTO ncr_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nsɛŋe bɛŋ le lɛ gɛ mbaaŋ ŋka mu mbvuuŋ ma nchwɛŋ wu kite kì laane manɛ gɛ, kɛge mɛɛse gɛɛne bude juu chì nlé ŋgê mû manfɛŋ besabɛŋ antɛnɛɛ a bvunfoŋ bvu Chii gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jiso bɛ booŋ be ba ŋgoo gɛ̀ mɛsɛ, bo yɛɛŋ ŋkee wu mbɛɛŋsɛ, bo mo bo bu bo bɛɛŋ bo gɛɛŋ yi Mbegɛ wu Bite bi Olif le. ");
INSERT INTO ncr_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","No Jiso bɛ booŋ be ba ŋgoo gɛ̀ gɛɛne, wu ja wu jɛmɛ bo le lɛ, “Kintaŋ ki abɛŋ kinɛ le bɛŋ bachii lé bɛŋ gê bɛŋ chii bikaa a mɛ jiŋ nje fiɛɛ fì lé fi gê fi kooshɛ bɛ mɛ. Le no ba le ba saŋ lɛ Nyo duu lɛ, ‘Nlé ŋgê n'yûuyɛ nchiɛnɛ shóŋ, ŋgoo yi shóŋ saaŋɛ.’ ");
INSERT INTO ncr_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Geenɛ, sege Nyo bvusɛ mɛ yi kwe le, nsa bɛŋ fwe Galalee.” ");
INSERT INTO ncr_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Bita mo wu jɛmɛ lo fie wu le lɛ, “Nɛ bamii bachii nɛ chile lo bikaa a wo jiŋ nje fiɛɛ fì lé fi gê fi kooshɛ bɛ wo, tu gɛ taŋlo n'yu nto nchii bikaa a wo jiŋ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jiso jɛmɛ wu le lɛ, “Nsɛŋe wo nchiɛɛŋ lɛ kintaŋ ki abɛŋ kinɛ le, nyishii lé yi gê yi toŋ, wo nyu wo faŋ wa mɛ kiŋgane kintɛde.” ");
INSERT INTO ncr_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Bita jɛmɛ wu le lɛ, “Mo fi nyume lɛ nlé ŋkwê lo besa wo, tu gɛ taŋlo n'yu nfaŋ wo gɛ.” No wu jɛmɛ noo, booŋ ba ŋgoo ba Jiso bamu baa bachii jɛmɛ gɛh tɛ noo. ");
INSERT INTO ncr_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jiso bɛ booŋ be ba ŋgoo gɛ̀ gɛɛŋ bo lee Gɛsɛmani fɛ mwɛ wu muntaŋ wumu le, Jiso jɛmɛ booŋ be ba ŋgoo le lɛ, “Bɛŋ shii fɛnɛ ŋkɛŋsɛ fege mbuunɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Wu jo Bita bɛ booŋ ba Jɛbɛdi ba bafɛɛ, bɛ bo gɛɛŋ. Wu kɛ wu tu wù nyu yii yii, fitele fie fuuŋse wu. ");
INSERT INTO ncr_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Wu mo wu jɛmɛ bo le lɛ, “Fitele fiaŋ le yii yii baaŋ njɛ ŋkwe lo. Bɛŋ shɛ̂ɛ fɛnɛ bɛŋ chîɛɛne!” ");
INSERT INTO ncr_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","No wu jɛmɛ noo, wu mo wu kɛŋsɛ wu gɛɛŋ fwe shige, wu gwe wu tuŋ bvushi fɛkuu wu mo wu buunɛ lɛ, “Chii, nɛ je bee yu yì taŋlo wo ge fiŋkoo fi ŋgɛ finɛ fe lɛ keefɛ mɛ mu gɛ, wo ge. Geenɛ, keefɛ wo gê no ŋgoone gɛ, gêe no wo goone.” ");
INSERT INTO ncr_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Wu gɛ̀ ja wu kaasɛ wu tu jiŋ fɛ booŋ be ba ŋgoo le, wu yɛŋ bo lefe. Wu biih Bita le lɛ, “Fi le lɛ gɛ taŋlo bɛŋ shii bɛ mɛ we gɛɛŋ bu ntaŋ wu kife wu mumwaa gɛ? ");
INSERT INTO ncr_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Bɛŋ nyûme we, bɛŋ bûune lɛ keefɛ moŋ ge wu to fɛ bɛŋ le gɛ. Le nchiɛɛŋ lɛ fitele koŋe lo, geenɛ nyaŋ yi ye wɛɛyi.” ");
INSERT INTO ncr_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Wu ka wu kaasɛ wu gɛɛŋ kiŋgane kinfɛɛ wu buunɛ lɛ, “Chii, nɛ fi le lɛ gɛ fiŋkoo finɛ taŋlo fi fe lɛ keefɛ mɛ mu gɛ, wo ge gɛh no wo koŋe.” ");
INSERT INTO ncr_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Wu doo wu kaasɛ wu tu jiŋ wu ka wu yɛŋ booŋ be ba ŋgoo lefe nje lefɛ gɛ̀ bee bo ajii baaŋ. ");
INSERT INTO ncr_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Wu ka wu chinɛ bo le, wu kaasɛ wu gɛɛŋ wu ka wu buunɛ kiŋgane kintɛde, wu buune wu jɛme gɛh nyu fiɛɛ fì wu be jɛmɛ wa. ");
INSERT INTO ncr_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Wu ka wu kaasɛ wu tu jiŋ fɛ booŋ be ba ŋgoo le wu jɛmɛ bo le lɛ, “Bɛŋ baaŋ gɛh bɛŋ lefe bɛŋ fufe shɛŋ? Bɛŋ jîŋɛ bɛŋ yɛ̂ŋ, kife le ki kojɛ ka. Ba lé ba gêsɛ muh wù jee che le Mwamuh bamii ba befe le. ");
INSERT INTO ncr_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Bɛŋ jâ we besabɛŋ gɛ̂ɛne. Bɛŋ jîŋɛ bɛŋ yɛ̂ŋ, nɛ muh wù gesɛ mɛ wunɛ wu too wa.” ");
INSERT INTO ncr_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Gɛh no Jiso gɛ̀ baaŋ wu jɛme noo, Juda wù gɛ̀ bee muh wu ŋgoo yi booŋ ba Jiso ba yuufe ncho bafɛɛ mo wu bu. Wu gɛ̀ too bɛ kinchvu ki bamii kì baaŋ, bo kɛme nyó bɛ bimbuge, gɛ̀ tuŋ bachiji kintanyɛ ba baaŋ baaŋ mo bamii ba sage woŋ. ");
INSERT INTO ncr_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Gɛ̀ bee muh wù gɛ̀ gesɛ Jiso wu seesɛ wa njiŋɛ bɛ bamii bayu, wu jɛmɛ lɛ, “Muh wù nlé ŋgê, ŋkfugɛ nshiŋɛ, tu le wu, bɛŋ mo bɛŋ koo.” ");
INSERT INTO ncr_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","No bɛ bo to, wu mo wu gɛɛŋ lo fɛ Jiso le kimimia wu jɛmɛ wu le lɛ, “N'yɛɛse wo le Muh wu N'yɛyɛ.” No wu jɛmɛ noo, wu mo wu kfugɛ wu wu shiŋɛ. ");
INSERT INTO ncr_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jiso jɛmɛ wu le lɛ, “Nsaa yaŋ, gee lo fiɛɛ fì wo to ki wo gê.” Bamii baa mo bo gɛɛŋ lo fɛ Jiso le bo koo wu, bo fajɛ. ");
INSERT INTO ncr_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Fi kooshɛ lɛ muh mu wù gɛ̀ bee bɛ Jiso wu mo wu bvusɛ nyo yi jɛŋ, wu chuŋ kintuŋ ki nfwa wu kikwɛɛ ki bachiji kintanyɛ yu, ki suunɛ. ");
INSERT INTO ncr_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jiso jɛmɛ muh wuyu le lɛ, “Kaasɛ chvuu nyo yo fɛ kijusɛ ke le. Wo kêe lɛ muh wuchii wù chiaase nyo we, lé wu gê, wu kwe yi nyo le. ");
INSERT INTO ncr_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Wo kwaji lɛ gɛ taŋlo ndu Chii chiiŋsɛ banchɛndaa be fɛnɛ kimimia banchvuge le, bo fede ŋgoo yuufe ncho yifiɛɛ gɛ? ");
INSERT INTO ncr_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Geenɛ, nja ŋge noo, fi ge fi jiɛnyɛ nɛɛ fɛ fi kooshɛ no ba gɛ̀ saŋ a Ŋwa wu Nyo le, no fi kɛme ki fi nyume?” ");
INSERT INTO ncr_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Sege kɛɛ, Jiso mo wu biih kinchvu kɛɛ le lɛ, “Bɛŋ to ki bɛŋ kôo mɛ, bɛŋ tu too nyu bɛ nyó yi jɛŋ mo bimbuge njɛ bɛŋ too ki bɛŋ kôo nyume muh wu too bɛ ŋgɛ woŋ le? Nchi nshee lɛ juu lɛ juu nshiide yeh yi kintanyɛ le n'yɛyi bamii fo, fɛ bɛŋ koo mɛ sɛŋ, nje la? ");
INSERT INTO ncr_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Geenɛ, finɛ fichii jo kijusɛ ki fi to fi kojɛ no bamii ba ntuŋ wu Nyo gɛ̀ saŋ.” Booŋ ba Jiso ba ŋgoo bachii mo bo noŋ wu fo, bo fɛɛ lo. ");
INSERT INTO ncr_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bamii ba gɛ̀ kolɛ Jiso mo bo jo wu bo gɛɛŋ bɛ wu fɛ Kayfa wù gɛ̀ bee chiji kikwɛɛ ki bachiji kintanyɛ. Bamii ba duunyi banchi ba Nyo bɛ bamii ba sage woŋ gɛ̀ taashɛ wa fo. ");
INSERT INTO ncr_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Bo gɛ̀ gɛɛne bɛ Jiso, Bita bii lo ajiŋ je yì ndefe le. Wu gɛɛŋ wu bu fɛ lakfulɛ chi kikwɛɛ ki bachiji kintanyɛ le, wu lee wu gɛɛŋ wu shii bɛ bamii ba gɛ̀ chiɛɛne la chiyu ki wu yɛ̂ŋ no fi lé fi gê fi jiɛnyɛ fi lɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bachiji kintanyɛ ba baaŋ baaŋ bɛ bamii bachii ba gɛ̀ sage bansa tu bo goone mwɛɛ mu chimbiaŋ mù bo kooyi yi Jiso le mù lé no mû ge ba yuuyɛ lo wu. ");
INSERT INTO ncr_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Geenɛ, bo gɛ̀ baaŋ kɛme gɛ fiɛɛ gɛ, mo no bamii ba duude gɛ̀ too fwe bo bɛɛyi jiŋ yi nsa wu chimbiaŋ. Fi gɛ̀ jiɛnyɛ nɛ, bamii bamu bafɛɛ to bo lɛɛŋ fwe, ");
INSERT INTO ncr_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","bo jɛmɛ lɛ, “Fimbwɛ finɛ chi fi du lɛ fi taŋlo fi sa yeh yi kintanyɛ yi Nyo fi kaasɛ fi jooŋ yi aju le atade.” ");
INSERT INTO ncr_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kikwɛɛ ki bachiji kintanyɛ mo ki ja we ki biih Jiso le lɛ, “Gɛ wo kɛme fiɛɛ fì wo chvuu gɛ? Wo yuge gɛ̀ mwɛɛ mù bamii banɛ kooyi ye yo le?” ");
INSERT INTO ncr_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jiso mɛ gɛh jwe wu chile. Kikwɛɛ ki bachiji kintanyɛ kaasɛ ki jɛmɛ wu le lɛ, “A jee chi Nyo wù kɛme kinche le, nɛ wo fɛnɛ le Mbvusɛ wù Nyo gɛ̀ ka wu le Mwa Nyo, wo sɛɛŋ bee le.” ");
INSERT INTO ncr_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jiso chvuu lɛ, “Fi le no wo jɛme. Geenɛ nsɛŋe bɛŋ le lɛ, ajiŋ a kife kinɛ bɛŋ lé bɛŋ yɛ̂ŋ muh wù jee che le Mwamuh, wu shii a kibo kinchiɛɛŋ ki Muh wù kɛme Bvuŋga, bɛŋ ka bɛŋ yɛŋ no wu too yi kimbɛ le fɛwe” ");
INSERT INTO ncr_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kikwɛɛ ki bachiji kintanyɛ yu noo, wu mo wu saayɛ njú ye, wu jɛmɛ lɛ, “Wu jode kijusɛ ki Nyo. Bee ka goone muh lɛ wu lɛɛŋ fɛnɛ wu jɛmɛ lɛ la? Bɛŋ le bɛŋ yu wa no wu jode kijusɛ ki Nyo. ");
INSERT INTO ncr_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Bɛŋ le bɛŋ suunɛ lɛ la?” Bo chvuu lɛ, “Le muh wù ba yuuyɛ lo.” ");
INSERT INTO ncr_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Bo mo bo kɛ bo chuuyi nchwene yi bvushi bvu Jiso le, bo kfuunyi wu bɛ muŋko, bo suŋe wu bɛ chiaaŋ bo duu wu le lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Wo le Mbvusɛ wù Nyo gɛ̀ ka, gɛh gêe la muh wu ntuŋ wu Nyo kuŋ bee le mɛɛse. Gɛh sɛ̂ɛŋ muh wù suŋ wo.” ");
INSERT INTO ncr_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Gɛ̀ bee Bita shii akfuuŋ fɛ lakfulɛ. Mwa wù kwɛse wumu wù gɛ̀ lɛne fɛ la chiyu le, ja wu to mbebe ye le wu jɛmɛ wu le lɛ, “Wo tɛ be bee bena Jiso wu Galalee wege.” ");
INSERT INTO ncr_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Geenɛ, Bita faŋ a bamii bachii fwe wu jɛmɛ lɛ, “Gɛ ŋkee fiɛɛ fì wo jɛme gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Bita mo wu ja wu bu wu gɛɛŋ wu tu wù nyu jwe wu kitaŋ le. Mwa wù kwɛse wumu wù gɛ̀ lɛne tɛ fo, wu yɛŋ wu le, wu mo wu jɛmɛ bamii ba gɛ̀ lɛme fo le lɛ, “Muh wunɛ bee bɛ Jiso wu Nasalɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Bita ka wu faŋ, wu lejɛ lo wu jɛmɛ lɛ, “Gɛ ŋkee muh wuyu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Lɛ kife kɛŋsɛ shige, bamii ba gɛ̀ lɛme fo kɛŋsɛ bo gɛɛŋ mbebe Bita le bo jɛmɛ wu le lɛ, “Yi nchiɛɛŋ le, wo le tɛ muh mu bo le, nje njɛmɛ wo gɛɛne njɛ wuboo.” ");
INSERT INTO ncr_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Bita mo wu kaŋ, wu tɛɛŋ loŋ yi kikwɛɛ ke le wu jɛmɛ lɛ, “Gɛ ŋkee muh wunɛ gɛ.” Kimimia nyishii mo yi toŋ. ");
INSERT INTO ncr_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Bita kwajɛ njɛme wù Jiso be jɛmɛ wu le lɛ, “Nyishii lé yi gê yi toŋ, wo nyu wo faŋ wa mɛ kiŋgane kintɛde.” Wu ja fo wu bu akfuuŋ, wu bee kwe baaŋ. ");
INSERT INTO ncr_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Akfuuŋ gɛ̀ doo a yuude a too, bachiji kintanyɛ ba baaŋ baaŋ bɛ bamii ba sage woŋ, bo shii bo chu ntaŋ kune Jiso ki bo yuuyɛ wu. ");
INSERT INTO ncr_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bo mo bo kaaŋ wu, bo jo wu bo gɛɛŋ bo nya chiaaŋ yi Balɛt le wù gɛ̀ bee muh wù sage kimbe kiyu le. ");
INSERT INTO ncr_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Juda wù gɛ̀ gesɛ Jiso gɛ̀ doo wu yɛŋ lɛ ba le ba suunɛ wa lɛ ba le ba yuuyɛ wu, shɛ́ŋ tu yi sage wu yi fiɛɛ fì wu ge le wu mo wu jo bige bi mbaanshɛ biɛɛ wu kaasɛ wu gɛɛŋ bɛ bi ki wu chvûu bachiji kintanyɛ ba baaŋ baaŋ bɛ bamii ba sage woŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Lɛ wu gɛɛŋ, wu jɛmɛ bo le lɛ, “Nle ŋge kimbefɛ ki ŋgesɛ muh wù kɛme gɛ jialɛ gɛ.” Bo chvuu wu le lɛ, “Fifiɛɛ kɛme la ki fi gê bɛ bee? Kee wo fiɛɛ fiyu.” ");
INSERT INTO ncr_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Juda bwaŋ bige biyu fɛkuu yeh yi kintanyɛ le, wu mo wu bu, wu gɛɛŋ wu shɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bachiji kintanyɛ ba baaŋ baaŋ tajɛ bige biyu bo jɛmɛ lɛ, “Binɛ le bige bi kilɛmɛ, nchi baaŋ bɛɛŋ gɛ lɛ ba gɛɛ binɛ a nchvu wu yeh yi kintanyɛ le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Bo shii bo chu ntaŋ, bo gɛɛŋ bo gu gwɛŋ wu muh wù maa sháaŋ ki bo jiiyi bantolo fo. ");
INSERT INTO ncr_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Le fiɛɛ fì ba tɛŋe gwɛŋ wuyu bude abɛŋ lɛ, “Gwɛŋ wu Kilɛmɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Fi gɛ̀ kooshɛ noo lɛ fiɛɛ fì muh wu ntuŋ wu Tada Nyo wù Yɛlimia gɛ̀ jɛmɛ mo fi to fi kojɛ no wu gɛ̀ jɛmɛ lɛ, “Bo gɛ̀ jo bige bi mbaanshɛ bì gɛ̀ bee ŋgesɛ we no booŋ ba Ishwala gɛ̀ kamɛ kikwɛɛ ke le, ");
INSERT INTO ncr_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","bo gu gwɛŋ wu muh wù maa shíaaŋ le yu, gɛh no Tada Nyo gɛ̀ jɛme mɛne.” ");
INSERT INTO ncr_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","No Jiso gɛ̀ lɛme a Balɛt muh wù sage fwe, Balɛt biih wu le lɛ “Le wo wu le Nfoŋ wu Bajuu?” Jiso chvuu lɛ, “Le no wo jɛme.” ");
INSERT INTO ncr_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Geenɛ, bachiji kintanyɛ ba baaŋ baaŋ bɛ bamii ba sage woŋ gɛ̀ doo bo kɛ bo chuunyi mwɛɛ yi wu le, wu gɛ ka wu chvuu lo fiɛɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Balɛt mo wu biih wu le lɛ, “Gɛ wo yuge kfuu chi mwɛɛ munɛ mù ba chuunyi wo le gɛ?” ");
INSERT INTO ncr_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Geenɛ, Jiso gɛ chvuu lo fiɛɛ wu le mo fimimia fi bo kooyi wu le gɛ. Muh wù sage wuyu bijɛ nɛɛ jwe yuŋ wu baaŋ. ");
INSERT INTO ncr_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","To nyume kife ki Ŋka wu Ndaŋfe, muh wù sage wunɛ bvusɛ muh wu mumwaa yeh yi ncha le, nyu wu wù bamii goone lɛ wu bvusɛ. ");
INSERT INTO ncr_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Gɛ̀ bee kife kiyu le, muh mu gɛ̀ bee yeh yi ncha le, ba gɛ̀ kee lo wu yi gee che chì befe le, jee che nyu lɛ Balaba. ");
INSERT INTO ncr_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Bamii gɛ̀ doo bo taashɛ, Balɛt biih bo le lɛ, “Bɛŋ goone lɛ mbvusɛ nyu yɛɛŋ yeh yi ncha le? Bɛŋ goone lɛ mbvusɛ Balaba noo, Jiso wù ba tɛŋe lɛ le Mbvusɛ wù Nyo gɛ̀ ka la?” ");
INSERT INTO ncr_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Wu gɛ̀ biide noo nje wu gɛ̀ kee lo lɛ ba gɛ̀ nya Jiso chiaaŋ ye le, nyu nje bo gɛ̀ bɛɛne kindoŋ bɛ wu. ");
INSERT INTO ncr_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Fì taade fo le sege wu gɛ̀ shilɛ fɛ ba gɛ̀ sage bansa fo, kwɛɛ tuŋ ntuŋ fɛ wu le wu jɛmɛ lɛ, “Keefɛ wo gê fiɛɛ bɛ muh wɛɛ gɛ. Le muh wù chaaŋ. Njɛme nɛ nje kifilɛ le ki njiiŋsɛ bɛ mɛ kintaŋ ki abɛŋ le baaŋ kune wu.” ");
INSERT INTO ncr_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","No Balɛt biide noo, bachiji kintanyɛ ba baaŋ baaŋ bɛ bamii ba sage woŋ bɛɛse bamii lɛ bo du lɛ wu bvusɛ nyu Balaba, ba lɛɛshɛ lo Jiso. ");
INSERT INTO ncr_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Muh wù sage ka wu ja wu biih bo le lɛ, “Muh wù bɛŋ goone lɛ nchinɛ antɛnɛɛ a bamii ba bafɛɛ banɛ le, le wù la?” Bo chvuu lɛ, “Balaba!” ");
INSERT INTO ncr_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Balɛt ka wu biih bo le lɛ, “Nɛ ndoo nchinɛ noo, ŋge nɛɛ bɛ Jiso wù ba tɛŋe lɛ Kletu?” Bo bachii jɛmɛ lɛ, “Ba ta lo wu yi kintaaŋ le.” ");
INSERT INTO ncr_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Wu ka wu biih lɛ, “Ba ta wu nje la? Fiɛɛ fì befe fì wu ge le la?” Bo ka bo wanɛ bo gɛɛne gɛh lo fwe fwe lɛ, “Ba ta lo wu yi kintaaŋ le.” ");
INSERT INTO ncr_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Balɛt gɛ̀ doo wu yɛŋ lɛ gɛ je nyu yu gɛ, lɛ wu luume bɛ fiɛɛ finɛ, jwe ja wu bu. Wu fi joo, wu chugɛ chiaaŋ ye yu a kinchvu ki bamii fwe wu jɛmɛ lɛ, “Gɛ chiaaŋ yaŋ nyu fɛ kwe yi muh wunɛ le gɛ. Kee bɛŋ bɛ fi.” ");
INSERT INTO ncr_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bamii bachii chvuu wu le lɛ, “Ɛɛŋ, chinɛ kilɛmɛ ke nyûme yi bikwɛɛ biɛsa le mo yi booŋ besa le.” ");
INSERT INTO ncr_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Balɛt mo wu bvusɛ Balaba no bo gɛ̀ goone, wu jɛmɛ ba taaŋ Jiso, bo mo bo nya lɛ ba gɛɛŋ ba ta yi kintaaŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Bamii ba nchi ba muh wù sage wɛɛ mo bo jo Jiso bo lee bɛ wu a nto we le fɛ ba gɛ̀ tɛŋe lɛ Bletoliuŋ, bo mo bo kuŋ kimbɛge ki ŋgoo yi bamii ba nchi bachii bo taashɛ bo tuŋkigaŋ bo kɛnɛ Jiso. ");
INSERT INTO ncr_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bo baayɛ njú ye, bo jo njú yi bvunfoŋ yì yɛɛde lo bo susɛ ye ye le, ");
INSERT INTO ncr_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","bo lu kifo ki bvunfoŋ ki nyu mbiaŋmbiaŋ bo booŋ a wu fwa, bo nya kimbaŋ a kibo ke kinchiɛɛŋ le, lɛ le kitoomi. Bo mo bo too bo ŋgvuume a wù fwe bo chwɛɛse wu bo duu lɛ, “Biaa bimbaaŋ! Nfoŋ Bajuu!” ");
INSERT INTO ncr_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","No bo gee noo, bo chuuyi chwɛne ye ye le, bo fii kimbaŋ bo shɛde wu yu a fwa. ");
INSERT INTO ncr_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bo chwɛɛsɛ bo mɛsɛ, bo baa nju yi bvunfoŋ yɛɛ, bo kaasɛ bo jii wa nyu njú ye ye ye le, bo mo bo jo wu bo gɛɛne bɛ wu ki bo gɛɛŋ bo ta yi kintaaŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","No bo gɛ̀ gɛɛne, bo bu yi muh mu wu a kilaantɛŋ kì Sɛliŋ le jee che nyu lɛ Samoŋ. Bo tooŋsɛ muh wɛɛ wu tuu kintaaŋ ki Jiso. ");
INSERT INTO ncr_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bo gɛɛŋ bo bu kijusɛ kimu ki ba tɛŋe lɛ Golgota, jee chi kijusɛ kinɛ nyu lɛ Ŋgboge wu Kikwɛɛ, ");
INSERT INTO ncr_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","bo mo bo nya mbvuuŋ ma ba fiiŋsɛ bɛ fiɛɛ fimi fì luji njɛ lele lɛ Jiso mu. Geenɛ wu doo wu moŋ, wu faŋ ki wu mû. ");
INSERT INTO ncr_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Bo mo bo ta wu yi kintaaŋ le, bo jo njú ye bo tuŋ kaŋ yu ki bo ga bikwɛɛ biboo le. ");
INSERT INTO ncr_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","No bo ge noo bo mo bo shii fo bo tu bo chiɛɛne wu. ");
INSERT INTO ncr_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Bo saŋ ŋwa wù duunyi fiɛɛ fì bo ta wu yi kintaaŋ le nje fi, bo mo bo ta yi kintaaŋ le a kikwɛɛ ke we lɛ, “Wunɛ le Jiso, Nfoŋ Bajuu.” ");
INSERT INTO ncr_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bo ta tɛ bachoŋ bafɛɛ yi bintaaŋ le bɛ Jiso, wumu a kibo kinchiɛɛŋ ki Jiso le, wumu a kiŋkoŋo le. ");
INSERT INTO ncr_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bamii tu bo fede bo yɛde Jiso le bo bɛme bɛ bikwɛɛ, bo baade wu bɛ banchuŋ, ");
INSERT INTO ncr_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","bo duu lɛ, “Wo wù chi bee ki wo sâ yeh yi kintanyɛ wo kaasɛ wo jooŋ yi aju le atade, gɛh fi la kikwɛɛ kuŋ! Nɛ wo fɛnɛ le Mwa Nyo, wo shii la yi kintaaŋ kɛɛ le.” ");
INSERT INTO ncr_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bachiji kintanyɛ ba baaŋ baaŋ bɛ bamii ba duunyi banchi mo bamii ba sage woŋ tu bo chwɛɛse tɛ wu bo duu lɛ, ");
INSERT INTO ncr_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Wu chi fii bamii bamu njɛ taŋlo wu fi kikwɛɛ ke sɛŋ. Gɛ wu nyu Nfoŋ wu bamii ba Ishwala gɛ? Wu shii la yi kintaaŋ le mɛɛse bee mo be bɛɛŋ wu le. ");
INSERT INTO ncr_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Wu chi gɛɛde kikwɛɛ yi Nyo le. Nɛ Nyo fɛnɛ koŋe wu, wu fi la wu mɛɛse no wu chi duu lɛ wu le Mwa Nyo.” ");
INSERT INTO ncr_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bachoŋ baa tɛ ba bo gɛ̀ ta yi bintaaŋ le bɛ Jiso, bo tu bo baade tɛ wu bɛ banchuŋ gɛh noo. ");
INSERT INTO ncr_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Juu gɛ̀ bɛɛŋ chi leesɛ, akfuuŋ ja ajiiŋ woŋ wuchii gɛɛne bude juu bikaa bitɛde fɛnshɛ. ");
INSERT INTO ncr_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Lɛ nyu njɛ juu bikaa bitɛde, Jiso ja wu jaŋ fɛwɛɛwe lɛ, “Ɛli, Ɛli, lama sabatani.” Fì le lɛ, “Nyo waŋ, Nyo waŋ, wo noŋ mɛ nɛ nje la?” ");
INSERT INTO ncr_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bamii bamu ba gɛ̀ lɛme fo doo bo yu, bo jɛmɛ lɛ, “Muh wuyu tɛŋe Alaja.” ");
INSERT INTO ncr_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Muh mu bo le mo wu legɛ lo kimimia wu jo kfusha, wu fuuŋ a mbvuuŋ ma ŋgbwamɛ le, wu booŋ yi finte le wu chiaasɛ lɛ wu mu. ");
INSERT INTO ncr_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Geenɛ bamii bamu jɛmɛ lɛ “Gɛh lɛɛŋ nɛ, besabɛŋ yɛŋ laa Alaja le wu to wu fi wu la.” ");
INSERT INTO ncr_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jiso ka wu waŋ fɛwɛɛwe, wu mo wu nya kiyo ke Nyo le. ");
INSERT INTO ncr_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Fi ja fi kooshɛ lɛ, nju yì gɛ̀ gade yeh yi kintanyɛ antɛŋ gɛ̀ badɛ antɛnɛɛ kɛge fɛwe boge bude fɛkuu bimbe bifɛɛ. Nshɛŋ shiŋshɛ, ata baajɛ, ");
INSERT INTO ncr_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","jɛ́ŋ tɛ gwenyɛ bamii ba gɛ̀ bee ba Nyo ba duude ba gɛ̀ kweeyɛ wa mo bo kaasɛ bo bu yi kwe le. ");
INSERT INTO ncr_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jiso gɛ̀ doo wu bu yi kwe le, bamii bayu ja bo gɛɛŋ a kilaantɛŋ kì yuude le Yɛlusalɛm, bamii wesee yɛŋ bo le. ");
INSERT INTO ncr_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Chiji kikwɛɛ ki bamii ba nchi bɛ bamii ba bɛ bo gɛ̀ bee fo bo chiɛɛne Jiso, gɛ̀ doo bo yɛŋ no nshɛŋ shiŋshɛ, bɛ fiɛɛ fì kooshi le, nfaaŋ koo bo baaŋ. Bo jɛmɛ lɛ, “Yi nchiɛɛŋ nchiɛɛŋ le, muh wunɛ chi bee Mwa Nyo.” ");
INSERT INTO ncr_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bikɛse ba duude gɛ̀ lɛme tɛ fo je yì ndefe le bo jiiŋe. Bikɛse banɛ le ba gɛ̀ ja Galalee bo bii Jiso le bo fii wu. ");
INSERT INTO ncr_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ŋgoo yiboo gɛ̀ bee Mɛɛle Madaleŋ mo Mɛɛle wù bwe Jɛm bɛ Yosɛf, mo bwe booŋ ba Jɛbɛdi. ");
INSERT INTO ncr_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Lɛ nyu fɛnfu, muh wu kwa wumu wu Alimatia ja wu to, jee che nyu lɛ Yosɛf. Wu tɛ gɛ̀ bee muh wu ŋgoo yi Jiso le. ");
INSERT INTO ncr_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Wu gɛɛŋ wu yɛŋ Balɛt le wu lɛgɛ lɛ wu nyâ gvunɛ chi Jiso wu le wu gɛ̂ɛŋ wu jîiyɛ. Noo, Balɛt mo wu jɛmɛ lɛ bo gɛ̂ɛŋ bo nyâ wu le. ");
INSERT INTO ncr_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yosɛf fi gvunɛ chiyu wu kujɛ a nju yì yuude le, ");
INSERT INTO ncr_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","wu mo wu gɛɛŋ wu giŋsɛ a jɛŋ ye yì baaŋ yifiɛŋ le. Wu gɛ̀ cho jɛŋ yiyu yi kimbaaŋ le, wu mo wu biŋsɛ kibwee ki tɛdɛ wu baŋɛ jwe wu jɛŋ yɛɛ yu, wu mo wu ja. ");
INSERT INTO ncr_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mɛɛle Madaleŋ bɛ Mɛɛle wumu wɛɛ gɛ̀ bee fo, bo shii mbebe jɛŋ yiyu le, kimbe kege le. ");
INSERT INTO ncr_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Akfuuŋ bu ayuu, juu chi bo to bo seese mwɛɛ mu yuuŋ chiboo gɛ̀ fe wa, bachiji kintanyɛ ba baaŋ baaŋ bɛ Bafalashii gɛɛŋ bo yɛŋ Balɛt le, ");
INSERT INTO ncr_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","bo jɛmɛ wu le lɛ, “Muh wù baaŋ, bee be kwaji fiɛɛ fì muh wu chimbiaŋ wɛɛ gɛ̀ jɛme sege wu gɛ̀ baaŋ yu. Wu gɛ̀ bee wu jɛmɛ lɛ, le to bu aju atade wu kaasɛ wu bu yi kwe le. ");
INSERT INTO ncr_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","No fi le noo, wo du bamii gɛɛŋ bo chîɛɛne jɛŋ yɛɛ gɛɛŋ bu aju atade, nje bee faane lɛ taŋlo booŋ be ba ŋgoo bo ja bo gɛɛŋ bo choŋ gvunɛ che bo ja bɛ chi bo mo bo sɛŋe bamii le lɛ, ‘Wu le wu bu yi kwe le.’ Nɛ bo ge noo, chimbiaŋ chi mɛɛse chinɛ mo chi fo chi fe lo chi fwe.” ");
INSERT INTO ncr_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Balɛt du bo le lɛ, “Bɛŋ jô bamii ba nchi bena bo gɛɛŋ, bɛŋ du bo chiɛɛne jɛŋ yɛɛ chuule no taŋlo bo chiɛɛne.” ");
INSERT INTO ncr_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Noo bo mo bo gɛɛŋ bo baŋɛ jwe wu jɛŋ yiyu chuule bo gɛɛ njiŋɛ yi tɛdɛ chì bo gɛ̀ baŋɛ jwe wu jɛŋ yɛɛ yu, bo mo bo gɛɛ bamii ba nchi bo chîɛɛne. ");
INSERT INTO ncr_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Juu chi yuuŋ gɛ̀ fe, akfuuŋ yuude atoo, nyu juu chi fwe yi kimaa le, Mɛɛle Madaleŋ bɛ Mɛɛle wumu wɛɛ gɛɛŋ ki bo bijɛ jɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Fi kooshɛ lɛ, nshɛŋ gɛ̀ be yi ja yi shiŋshɛ bɛ bvuŋga, nje nchɛndaa Tada gɛ̀ shii we wu to wu biŋsɛ kibwee ki tɛdɛ chiɛɛ chì ba gɛ̀ baŋɛ jwe wu jɛŋ yɛɛ yu wu mo wu shii yu. ");
INSERT INTO ncr_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nchɛndaa wuyu le bvushi bwe gɛ̀ lale njɛ jaŋ, njú ye baaŋ nɛ bvuuu. ");
INSERT INTO ncr_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Bamii ba gɛ̀ chiɛɛne jɛŋ baa yɛŋ wu le bo faaŋ baaŋ, bo koge nɛ kikikiki, bo gweeyɛ fɛkuu bo leefɛ njɛ biŋkwe bi bamii. ");
INSERT INTO ncr_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nchɛndaa wu Nyo wuyu jɛmɛ bikɛse baa le lɛ, “Keefɛ bɛŋ fâane gɛ. Ŋkee lo lɛ bɛŋ goone nyu Jiso wù ba chi ta yi kintaaŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Gɛ wu baaŋ fɛnɛ gɛ, wu le wu bu wa yi kwe le, no wu gɛ̀ jɛme. Bɛŋ to bɛŋ yɛŋ fɛ wu chi gime fo. ");
INSERT INTO ncr_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Bɛŋ mo bɛŋ gɛ̂ɛŋ chige bɛŋ sɛɛŋ booŋ be ba ŋgoo le lɛ wu le wu bu wa yi kwe le, lɛ wu le wu sa wa bɛŋ fwe Galalee. Bɛŋ lé bɛŋ yɛ̂ŋ wu le yo. Bɛŋ yêgɛ bɛŋ yû, bɛŋ le bɛŋ yu wa no nsɛŋe bɛŋ le.” ");
INSERT INTO ncr_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Bikɛse baa mo bo ja fɛ jɛŋ chige chige bɛ nfaaŋ, geenɛ bo kɛme tɛ njoŋ wù baaŋ, bo tu bo lege bo gɛɛne ki bo gɛɛŋ bo sɛɛŋ booŋ ba Jiso ba ŋgoo le. ");
INSERT INTO ncr_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","No bo gɛ̀ gɛɛne, fi kooshɛ lɛ bɛ ba Jiso gɛ̀ tasɛ, wu jɛmɛ bo le lɛ, “N'yɛɛse bɛŋ le.” Bo mo bo to mbebe ye le, bo gwe bo kfugɛ bikaa bie, bo ŋgvuuŋ wu. ");
INSERT INTO ncr_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jiso jɛmɛ bo le lɛ, “Keefɛ bɛŋ fâane gɛ. Bɛŋ gɛ̂ɛŋ bɛŋ dû booŋ ba bwɛɛŋ le lɛ bo gɛ̂ɛne Galalee bo lé bo yɛ̂ŋ mɛne yo.” ");
INSERT INTO ncr_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Sege bikɛse baa gɛ̀ ja bo doo bo gɛɛne, fi kooshɛ lɛ bamii ba nchi ba gɛ̀ chiɛɛne jɛŋ bamu gɛ̀ ja bo gɛɛne alaantɛŋ bo gɛɛŋ bo sɛɛŋ fiɛɛ fichii fì kooshi bachiji kintanyɛ ba baaŋ baaŋ le. ");
INSERT INTO ncr_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bachiji kintanyɛ bayu mo bo kuŋ bamii ba sage woŋ bɛ bo shii bo chu ntaŋ, bo mo bo baŋɛ jwe wu bamii ba nchi baa bɛ bige bì duude, ");
INSERT INTO ncr_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","bo jɛmɛ bo le lɛ, “Bɛŋ sɛ̂ŋe bamii le lɛ bɛŋ chi lefe lo booŋ be ba ŋgoo to bo choŋ gvunɛ che bo gɛɛŋ bɛ chi. ");
INSERT INTO ncr_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nɛ bɛŋ sɛŋe noo, fi lee bintuŋ bi muh wù sage le, wu nɛ goone ki wu nyâ bɛŋ ŋgɛ le, bee seesɛ bɛ wu, wu gɛ ka wu nya bɛŋ ŋgɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Noo bo mo bo fi bige biyu bo tu bo sɛŋe gɛh no ba be jɛmɛ bo le. Kinfɛ kiyu kinɛ mo ki laaŋ antɛnɛɛ a Bajuu too bude abɛŋ lɛ ba gɛ̀ choŋ lo gvunɛ chi Jiso. ");
INSERT INTO ncr_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Booŋ ba ŋgoo ba Jiso ba yuufe ncho wu mumwaa mo bo ja bo gɛɛŋ Galalee, bo bɛɛŋ bo gɛɛŋ yi mbegɛ wù Jiso gɛ̀ jɛmɛ bo le. ");
INSERT INTO ncr_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Bo doo bo yɛŋ wu le, bo ŋgvuuŋ wu. Geenɛ bamu tu bo maŋe wu. ");
INSERT INTO ncr_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jiso ja wu kɛŋsɛ wu to wu du bo le lɛ, “Chii le wu nya wa bvuŋga bvuchii bvu fɛwe mo bvu fɛkuu mɛne. ");
INSERT INTO ncr_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Noo, bɛŋ gɛ̂ɛŋ woŋ le wuchii, bɛŋ gêe bamii nyu bamii baŋ ba ŋgoo, bɛŋ lêese bo a joo a jee chi Nyo wu Chii le, bɛ chi Mwa mo a chi Kiyo ki Yuude le. ");
INSERT INTO ncr_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Bɛŋ yɛ̂yi bo lɛ bo gêe fiɛɛ fichii fì nle n'yɛyɛ bɛŋ yu. Bɛŋ yêgɛ bɛŋ yû, nlé nyûme besabɛŋ segechii gɛɛne bude kife kì woŋ lé wu gê wu ka.”");
INSERT INTO ncr_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Wunɛ le saaka wù joŋe kune Jiso Kletu wu le Mwa Nyo. ");
INSERT INTO ncr_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Wu gɛ̀ kɛ gɛh no Yosaya wù muh wu ntuŋ wu Nyo, gɛ̀ saŋ, Nyo duu lɛ, “Yêgɛ yû, nlé ŋgê nchiiŋsɛ muh waŋ wu ntuŋ wu sa wo fwe, wu lé wu gɛ̂ɛŋ wu seesɛ je yo. ");
INSERT INTO ncr_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Jɛ yi muh jaŋe kwa lɛ ba sêesɛ je yi Tada, ba nâjɛ yi nyu chaaŋ.” ");
INSERT INTO ncr_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Noo, muh mu wù ba gɛ̀ tɛŋe lɛ Joŋ Nlesɛajoo ja wu bunɛ wu gɛɛŋ kwa wu tu wu feeji bamii le lɛ bo kusɛ muntele muboo, wu leesɛ bo a joo lɛ Nyo lɛɛshɛ bimbefɛ biboo. ");
INSERT INTO ncr_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bamii tu bo bude bantɛ ba yi woŋ wu Judia le wuchii, mo a kilaantɛŋ kì Yɛlusalɛm le kichii bo gɛɛne fɛ Joŋ le, bo sɛŋe bimbefɛ biboo lɛ, wu mo wu leese bo a Joo yì Jodaŋ le. ");
INSERT INTO ncr_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Joŋ gɛ̀ jiide njú yì ba kɛnyɛ bɛ yvú yi nyaŋ yimi yì ba tɛŋe lɛ kamɛɛ, wu kaane kicha chiŋ ba kɛnyɛ bɛ je yi nyaŋ, mwɛɛ mwe munjile gɛ̀ bee chuma bɛ bvutu bvu nchvuuŋ. ");
INSERT INTO ncr_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Wu gɛ̀ feeji, wu duu lɛ, “Muh mu too a mɛ jiŋ wu kuge wu fede mɛ, mbaaŋ kojɛ gɛ ki ŋgvuumɛ fɛkuu nfaanyɛ balaba be gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nleese bɛŋ nyu a joo, geenɛ, wu lé wu gê wu leese fie bɛŋ nyu a Kiyo ki Yuude le.” ");
INSERT INTO ncr_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Gɛh aju ayu le, Jiso ja Nasalɛ kimbe ki woŋ kì Galalee le, wu to Joŋ leesɛ wu a joo, fɛ Joo yì Jodaŋ le. ");
INSERT INTO ncr_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Gɛh no Jiso gɛ̀ bude a joo, kibvulɛ gwenyɛ ye, Kiyo ki Yuude shii ki to yi ye ye le fiɛɛnɛ kibɛmbɛ. ");
INSERT INTO ncr_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Jɛ jɛmɛ fɛwe lɛ, “Wo le Mwa yaŋ, wo le fitele fiaŋ, n'yuge njoŋ bɛ wo baaŋ.” ");
INSERT INTO ncr_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kimimia Kiyo ki Yuude mo ki ge Jiso gɛɛŋ wu tu wu chee nchvuuŋ. ");
INSERT INTO ncr_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Wu tu wù nyu yo yi aju le mbaanyɛ, Sataŋ mone wu. Wu gɛ̀ bee yo noo bɛ nyáŋ yi nchvuuŋ, banchɛndaa ba Nyo jiiŋe fɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bo gɛ̀ ja bo koo Joŋ Nlesɛajoo ba leesɛ yeh yi ncha le. Lɛ nyu ajiŋ ayu, Jiso gɛɛŋ Galalee, wu tu wu feeji saaka wù joŋe wu Nyo yo. ");
INSERT INTO ncr_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Wu tu wu feeji, wu duu lɛ, “Kife le ki to ka ki kojɛ, bvunfoŋ bvu Nyo le wa mbebe le. Bɛŋ kûsɛ muntele mwɛna, bɛŋ bɛ̀ɛŋ saaka wù joŋe wunɛ le.” ");
INSERT INTO ncr_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jiso tu wu fede mbebe Mamasi wù Galalee le, wu yɛŋ Samoŋ bɛ mwa bwee, wu Andulu le bo nooŋ gii a mamasi le, no lɛme chiboo gɛ̀ bee bíɛŋ yì kolɛ. ");
INSERT INTO ncr_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jiso jɛmɛ bo le lɛ, “Bɛŋ bîi mɛne, nlé nfɛ̂ bɛŋ bɛŋ kôode wa nyume bamii.” ");
INSERT INTO ncr_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kimimia, bo mo bo chinɛ gii yiboo le, bo tu bo bii wu le. ");
INSERT INTO ncr_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jiso doo wu kɛŋsɛ wu gɛɛŋ fwe, wu yɛŋ Jɛm bɛ mwa bwee wù Joŋ le, bò gɛ̀ bee booŋ ba Jɛbɛdi, bɛ bo nyu a ŋguh le bo chvuushi gii. ");
INSERT INTO ncr_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jiso mo wu tɛɛŋ tɛ bo. Bo chinɛ chiji bo wù Jɛbɛdi le a ŋguh le, bɛ bamii ba bo gɛ̀ jo bo lɛne bo le, bo mo bo tu bo bii wu le. ");
INSERT INTO ncr_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Bɛ ba Jiso ja bo gɛɛŋ a kilaantɛŋ kì Kafanahum le. Lɛ to nyume juu chi yuuŋ, Jiso mo wu gɛɛŋ yeh yi buunɛ le, wu tu wu yɛyi bamii yu. ");
INSERT INTO ncr_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bamii yuge bo kɛme lo ŋgha yi n'yɛyɛ we le, nje wu gɛ̀ yɛyi njɛ muh wù kɛme bvuŋga bvu n'yɛyɛ. Gɛ wu gɛ yɛyi njɛ no bamii ba duunyi banchi ba Nyo to bo yɛyi gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Gɛh sege yu, muh mu gɛ̀ bee yeh yi buunɛ yiyu le, gɛ̀ bee kiyo kì yiide nyu ye ye le. ");
INSERT INTO ncr_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","No wu leese yu, wu mo wu waŋ lɛ, “Jiso wu Nasalɛ, wo goone la a bee le? Wo to ki wo lɛ̂ɛshɛ lo bee? Ŋkee wo chuule. Le wo wù Yuude wù ja fɛ Nyo le.” ");
INSERT INTO ncr_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jiso waŋ kiyo kì yiide kiyu, wu jɛmɛ lɛ, “Baŋ lo, wo bu yi muh wunɛ le.” ");
INSERT INTO ncr_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kiyo kì yiide mo ki ge muh wuyu gwe fɛkuu wu tu wu tage, ki jaŋ fɛwɛɛwe, ki mo ki bû ye ye le. ");
INSERT INTO ncr_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bamii yɛŋ noo, jwe yuŋ bo, bo tu bo maŋe lɛbolɛbo bo biide lɛ, “Finɛ le la? Le n'yɛyɛ wumu wù fwɛŋ? Muh wunɛ kɛme bvuŋga ki wu kâane mo biyo bì yiide bi mo bi yuge wu le.” ");
INSERT INTO ncr_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kimimia, saaka wu kune Jiso saaŋe wu gɛɛŋ bantɛ bachii ba kimbe kì Galalee le. ");
INSERT INTO ncr_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jiso gɛ̀ bu yeh yi buunɛ yɛɛ le, wu gɛɛŋ a Samoŋ bɛ Andulu yeh, Jɛm bɛ Joŋ nyu bɛ bo. ");
INSERT INTO ncr_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Gɛ̀ bee mwɛɛdɛ Samoŋ gime, wu chɛne bɛ kin'ya. Gɛh no Jiso lese yeh, bo mo bo sɛɛŋ lo wu le kune kwɛse wuyu. ");
INSERT INTO ncr_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jiso gɛɛŋ fɛ wu gɛ̀ gime fo, wu jijɛ wu yi kibo le, wu chiaasɛ wu we. Kin'ya kiyu mo ki chinɛ wu le, wu ja we, wu bijɛ fiɛɛ bo ji. ");
INSERT INTO ncr_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Lɛ nyu fɛnfu abvu no juu gɛ̀ seele, bo too bɛ bamii bachii ba gɛ̀ chɛne mo bamii ba banchɛndaa ba Sataŋ gɛ̀ njiiŋse bɛ bo fɛ Jiso le. ");
INSERT INTO ncr_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kilaantɛŋ kiyu kichii ki taashɛ a fwɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Wu fɛde bamii ba duude ba gɛ̀ kɛme binchɛŋ yeye yeye, wu ka bvuuse banchɛndaa ba debele ba duude yi bamii bamu le. Wu doo wu bvuuse, wu gɛ ka wu bɛɛŋ lɛ banchɛndaa bayu jɛme gɛ, nje bo gɛ kee muh wu le wu. ");
INSERT INTO ncr_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Lɛ to nyume antaana kibilebile le, Jiso ja we, wu bu wu gɛɛŋ kijusɛ kimi le wu maa ki wu bûunɛ. ");
INSERT INTO ncr_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Samoŋ bɛ bamii ba bɛ bo gɛ̀ bee, bo shɛɛ bo bu bo gɛɛŋ ki bo gooŋ wu. ");
INSERT INTO ncr_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bo yɛŋ wu le, bo jɛmɛ wu le lɛ, “Bamii bachii le bo shɛɛ bo goone wo.” ");
INSERT INTO ncr_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jiso chvuu fie bo le lɛ, “Bee dâŋ be gɛ̂ɛŋ bantɛ bamu le, lɛ taŋlo nfejɛ tɛ jɛ yi Nyo yo. Le fiɛɛ fì nto nje fi.” ");
INSERT INTO ncr_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Wu mo wu tu wu jiɛnyi kimbe kì Galalee le kichii wu feeji jɛ yi Nyo yéh yi buunɛ yiboo le, wu bvuuse banchɛndaa ba debele lɛ yi bamii le. ");
INSERT INTO ncr_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Muh mu wu gɛ̀ chɛne bɛ goŋ yì baaŋ gɛ̀ ja wu to, wu tuŋ anyuu a Jiso jii, wu lɛgɛ wu, wu jɛmɛ lɛ, “Wo taŋlo wo fɛ mɛ n'yuude, fɛ wo nɛ koŋe lo.” ");
INSERT INTO ncr_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yii koo Jiso, wu nɛjɛ kibo wu kuŋ wu le, wu jɛmɛ wu le lɛ, “Ŋkoŋe lo, tɛ̂mɛ la, wo yûude!” ");
INSERT INTO ncr_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kimimia, goŋ yì baaŋ yiyu mo yi chinɛ wu le, wu tɛmɛ wu tu wu yûude. ");
INSERT INTO ncr_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jiso mo wu jɛmɛ lɛ wu gɛɛne la, wu lejɛ lo wu le, ");
INSERT INTO ncr_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","wu jɛmɛ lɛ, “Yɛ̂ŋ keefɛ wo sɛ̂ɛŋ muh le gɛ. Geenɛ, gɛ̂nɛ wo chûnyɛ kikwɛɛ kuŋ chiji kintanyɛ le, wo mo wo nyâ nnyaa yì Musɛ gɛ̀ jɛmɛ lɛ muh kɛmɛ ki wu nyâ ki wu chûnyɛ bamii le lɛ wu le wu tɛmɛ wa yi goŋ yinɛ le wu mo wu tu wu yûude.” ");
INSERT INTO ncr_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","No Jiso leji noo, muh wuyu tu wu gɛɛŋ wu bwaashi lo fiɛɛ fiyu. Saaka wuyu saaŋe, je gɛ ka yi nyu yu yì taŋlo Jiso lee a kilaantɛŋ le nɛ bwaashaa gɛ. Wu mo wu mɛ gɛh wù nyu nchvuuŋ, bamii jade manjuu le manjuu le, bo too fɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Aju doo a kɛŋsɛ, Jiso kaasɛ wu tu jiŋ Kafanahum. Bamii yu lɛ wu le wa fɛ yeh le, ");
INSERT INTO ncr_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","bo taashɛ fo wesee, je gɛ̀ bee gɛ yu yì taŋlo muh tomɛ kikaa mo a yeh fwɛɛŋ gɛ. Wu tu wu feeji jɛ yi Nyo bo le. ");
INSERT INTO ncr_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Bamii bamu gɛ̀ ja bo too banɛh bɛ muh mu fɛ wu le, bo nyu bo shumɛ yi bvuko le, wu kwe wa kimbe kimimia. ");
INSERT INTO ncr_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Fi ya ki bo lee bo gɛɛŋ bɛ wu fɛ wu le nje bamii gɛ fasɛ baaŋ. Bo mo bo bɛɛŋ nyu a yeh we, bo chiɛɛ kiyɛ. No bo chɛle noo, bo mo bo shiishɛ muh wuyu a fiɛɛ fì wu gɛ̀ gime yo le. ");
INSERT INTO ncr_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jiso yɛŋ no bo le bo leesɛ muntele muboo ye ye le, wu mo wu jɛmɛ muh wù gɛ̀ kwe wa kimbe kimimia wɛɛ le lɛ, “Nsaa yaŋ, nle nlɛɛshɛ wa bimbefɛ biuŋ.” ");
INSERT INTO ncr_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Bamii bamu ba gɛ̀ yɛyi banchi ba Nyo ba gɛ̀ shiiyɛ fo yu noo, bo tu bo shuŋshi a muntele le, bo biide lɛ, ");
INSERT INTO ncr_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Muh wunɛ jɛme nɛ nɛɛ? Wu jode kijusɛ ki Nyo. Le yɛɛŋ wuyu wu taŋlo wu lɛɛshɛ bimbefɛ fuge Nyo sɛŋ?” ");
INSERT INTO ncr_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jiso mo wu kɛɛ a fitele fie le fiɛɛ fì bo gɛ kwaji, wu mo wu biih bo le lɛ, “Bɛŋ kɛme kfuu chi banɛ baŋkwajɛ a muntele mwɛna le nɛ njɛ la? ");
INSERT INTO ncr_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Fi chige fì njɛmɛ muh wunɛ le, le fì la? Ki njɛmɛ lɛ nle nlɛɛshɛ wa bimbefɛ bie noo, lɛ wu jo bvuko bwe wu gɛɛne la? ");
INSERT INTO ncr_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Geenɛ, nlé ŋgê bɛŋ kɛ̂ɛ lɛ muh wù jee che le Mwamuh kɛme bvuŋga fɛkuu fɛnɛ ki wu lɛ̂ɛshɛ bimbefɛ.” Wu mo wu jɛmɛ muh wù gɛ̀ kwe wa kimbe kimimia wɛɛ le lɛ, ");
INSERT INTO ncr_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Njɛme wo le, jâ we wo jô bvuko bwuŋ wo gɛ̂ɛne fɛ wo yeh le.” ");
INSERT INTO ncr_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wu mo wu ja we, wu jo bvuko wu bude bamii bachii jiiŋe wu. Bo jiŋɛ nɛɛ, jwe yuŋ bo, bo tu bo tume maŋkuŋ ma Nyo, bo duu lɛ, “Bee gɛ̀ baaŋ a yɛŋ gɛ kfuu chi finɛ fiɛɛ le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jiso ka wu ja wu gɛɛŋ mbebe mamasi le, kinchvu ki bamii to fo, wu tu wu yɛyi bo. ");
INSERT INTO ncr_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Wu ja wu doo wu gɛɛne, wu yɛŋ Lɛwe wu le mwa Alfayu le, wu shii fɛ kijusɛ ke ki lɛme le, wu koode ŋwa. Jiso jɛmɛ wu le lɛ, “Wo bîi mɛne.” Wu mo wu ja we wu bii wu le. ");
INSERT INTO ncr_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jiso bɛ booŋ be ba ŋgoo gɛɛŋ bo jii mwɛɛ a Lɛwe yeh bɛ bamii ba gɛ̀ koode ŋwa mo bamii bamu ba befe tɛ. Kfuu chi banɛ bamii tu bo bii wu le wesee. ");
INSERT INTO ncr_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bafalashii ba gɛ̀ yɛyi banchi ba Nyo yɛŋ no Jiso jii mwɛɛ bɛ bamii ba befe mo ba gɛ̀ koode ŋwa, bo mo bo biih booŋ be ba ŋgoo le lɛ, “Le nje la fì wu jii mwɛɛ bɛ bamii ba koode ŋwa mo bamii ba befe bamu?” ");
INSERT INTO ncr_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jiso yu no bo biide, wu jɛmɛ bo le lɛ, “Gɛ bamii ba tɛɛme to bo goone muh wu nche gɛ. To goone nyu ba chɛne. Gɛ nto ki ntɛɛŋ bamii ba chaaŋ gɛ. Nto ki ntɛɛŋ nyume bamii ba befe.” ");
INSERT INTO ncr_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Lɛ to nyu, booŋ ba Joŋ ba ŋgoo mo ba Bafalashii bo banɛ mwɛɛ munjile. Bamii bamu mo bo to bo biih Jiso le lɛ, “Le nje la wù booŋ ba ŋgoo ba Joŋ, mo ba Bafalashii bane mwɛɛ munjile, buŋ booŋ ba ŋgoo bane gɛ?” ");
INSERT INTO ncr_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jiso chvuu bo le lɛ, “Taŋlo ba tɛɛŋ bamii fɛ bvuguu le bo gɛɛŋ bo tu bo banɛ mwɛɛ munjile chiji bvuguu nyu bɛ bo? Gɛ taŋlo bo bane mwɛɛ munjile wù nyu bɛ bo gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Geenɛ, kife le ki to kì ba lé ba fî chiji bvuguu wuyu a bo le, bo mo bo kɛ bo banɛ mwɛɛ munjile kife kiyu le. ");
INSERT INTO ncr_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Gɛ muh taŋlo wu jo finchaŋa fi nju fifɛŋ, wu chvuushɛ nju yì kege yu gɛ. Nɛ wu ge lo noo, finchaŋa fi nju fiyu mɛsɛ fi saayɛ lo nju yì kege yiyu, kintuge ki le fo ki mɛsɛ ki kugɛ ki fe no ki gɛ̀ shee ki nyume. ");
INSERT INTO ncr_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Gɛ taŋlo tɛ muh jo mbvuuŋ manfɛŋ, wu gɛɛ a kibɛɛŋ ki mbvuuŋ kì ba kɛnyɛ bɛ je yi nyaŋ, ki juŋ wa le gɛ. Wu nɛ ge lo noo, mbvuuŋ manfɛŋ mayu koo, mo saayɛ kibɛɛŋ kì kege kiyu, mbvuuŋ bɛ kibɛɛŋ mu mo mu lɛsɛ achiji. Fi kooji le lɛ, ba kɛme ki ba gɛɛde mbvuuŋ ma manfɛŋ nyume a bibɛɛŋ bì bifɛŋ le.” ");
INSERT INTO ncr_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Gɛ̀ bee juu chi yuuŋ chimi, Jiso bɛ booŋ be ba ŋgoo bo jiɛnyi bo fede mwɛ wu agiŋ wumu le. Booŋ be ba ŋgoo kɛ bo suume bichiɛɛ bo jii. ");
INSERT INTO ncr_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Bafalashii yɛŋ, bo biih Jiso le lɛ, “Bîjɛ wo yɛ̂ŋ, le nje la fì booŋ buŋ ba ŋgoo gee fiɛɛ fì nchi baaŋ bɛɛŋ gɛ lɛ muh ge juu chi yuuŋ gɛ?” ");
INSERT INTO ncr_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jiso biih tɛ bo le lɛ, “Bɛŋ gɛ̀ baaŋ a tɛɛŋ gɛ a Ŋwa wu Nyo le no jɛŋ gɛ̀ yu Nfoŋ Dabi bɛ ŋgoo ye wu ge gɛ? ");
INSERT INTO ncr_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Gɛ̀ bee kife kì Abiata gɛ̀ bee kikwɛɛ ki bachiji kintanyɛ, Dabi lee yeh yi Nyo le, wu jo blɛd wù ba le ba cha ba gɛɛ lɛ le wu Nyo, wu ji wu ka wu nya tɛ ŋgoo ye yu, gɛ̀ bee nchi lɛ keefɛ muh ji blɛd wuyu fede bachiji kintanyɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jiso mo wu mɛsɛ wu jɛmɛ bo le lɛ, “Nyo gɛ̀ gɛle juu chi yuuŋ nje muh. Gɛ wu gɛ fɛ muh nje juu chi yuuŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Noo, muh wù jee che le Mwamuh le Chiji Kikwɛɛ ki yuuŋ.” ");
INSERT INTO ncr_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jiso ka wu gɛɛŋ wu lee yeh yi buunɛ le. Muh mu nyu yu a kibo ke kwe wa. ");
INSERT INTO ncr_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bamii bamu ba gɛ̀ bee yu bo goone fiɛɛ fì bo kooyi yi Jiso le, bo mo bo noŋ ajii ye ye le bo tu bo jiiŋe laa wu lé wu fɛ̂ muh juu chi yuuŋ la. ");
INSERT INTO ncr_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jiso jɛmɛ muh wu kibo ke gɛ̀ kwe wɛɛ le lɛ, “Jâ we wo tô fɛnɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","No wu to, Jiso biih bamii le lɛ, “Fiɛɛ fì nchi le wu bɛɛŋ lɛ muh ge juu chi yuuŋ le fì la? Ki ba ge fiɛɛ fì joŋe, noo fì befe le? Ki ba fi muh noo, ki ba yuuyɛ lo le?” Bo chii. ");
INSERT INTO ncr_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jiso bijɛ bo bachii wu kɛnɛ bɛ shɛ́ŋ yì toonyɛ, shɛ́ŋ kwe wu, nje muntele muboo mù yiide. Wu jɛmɛ muh wù kibo ke gɛ̀ kwe wɛɛ le lɛ, “Nɛ̂jɛ kibo kuŋ.” Wu nɛjɛ, ki mo ki tɛ̂mɛ. ");
INSERT INTO ncr_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Bafalashii mo bo bu, bo gɛɛŋ bɛ ŋgoo yi bamii ba Nfoŋ Hɛlod bo mo bo chu ntaŋ kimimia no bo lé bo gê fɛ bo yuuyɛ Jiso. ");
INSERT INTO ncr_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jiso bɛ booŋ be ba ŋgoo mo bo ja yo bo gɛɛŋ fɛ Mamasi wù Galalee le. Kinchvu ki bamii kì baaŋ bi wu le. Bamii bamu gɛ̀ ja kimbe kì Galalee bɛ kì Judia le. ");
INSERT INTO ncr_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Bamu ja Yɛlusalɛm, bamu kimbe kì Idumia le, bamu a Joo yì Jodaŋ le wuŋ kwege, bamu bimbe bi Taya bɛ Sidoŋ le. Kinchvu kiyu gɛ̀ too noo nje bo gɛ̀ yuge mwɛɛ mu wu gɛ̀ gee munchii. ");
INSERT INTO ncr_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jiso ja wu jɛmɛ booŋ be ba ŋgoo le lɛ bo gooŋ ŋguh bo seesɛ bo gɛɛ wu lee yo, keefɛ kinchvu kiyu ja ki faase wu gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Wu gɛ̀ jɛme noo nje wu gɛ̀ fɛ wa bamii ba duude, bamii ba binchɛŋ wesee too bo kune wu le. ");
INSERT INTO ncr_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Sege bamii ba biyo bì yiide gɛ̀ njiiŋse bɛ bo gɛ̀ yɛŋ Jiso le bo mo bo gweeyi a wù fwe bo wanɛ bo duu lɛ, “Wo le Mwa Nyo.” ");
INSERT INTO ncr_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","No bo gɛ̀ wanɛ noo, Jiso du lo bo le lɛ keefɛ bo gê bamii kɛ̂ɛ wu gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Wu ja wu bɛɛŋ wu gɛɛŋ yi mbegɛ le, wu tɛɛŋ bamii ba wu gɛ̀ goone bo to fɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Wu baa bamii yuufe ncho bafɛɛ, wu tɛɛŋ bo lɛ booŋ be ba ntuŋ, lɛ bɛ bo nyume, wu tune bo, bo jiɛnyi bo feeji jɛ yi Nyo, ");
INSERT INTO ncr_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","bo ka kɛme bvuŋga ki bo bvuuse banchɛndaa ba debele yi bamii le. ");
INSERT INTO ncr_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Bamii bayu gɛ̀ bee: Samoŋ, wu wù gɛ̀ nya jee che chimi lɛ Bita. ");
INSERT INTO ncr_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jɛm bɛ mwa bwee wù Joŋ ba gɛ̀ bee booŋ ba Jɛbɛdi, ba wu gɛ̀ nya bo jee lɛ, “Boanɛgɛ” chì le lɛ, “Booŋ ba jaŋ yi mgbame.” ");
INSERT INTO ncr_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Bamu nyu Andulu, Filib, Batolomiu, Macho Toma, Jɛm wù mwa Alfayu, Tadio, Samoŋ wù gɛ̀ bee muh ŋgoo yi Bajalot, ");
INSERT INTO ncr_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","mo Juda Ɛkaliot wù gɛ̀ kɛnɛ wu to wu gesɛ Jiso. ");
INSERT INTO ncr_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jiso ja wu gɛɛŋ fɛ wu gɛ̀ chee fo, kinchvu ki bamii ka kitaashɛ fo, bɛ booŋ be ba ŋgoo gɛ baaŋ kɛme gɛ lo je ki bo ji mwɛɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kfuu che gɛ̀ doo chi yu, bo mo bo gɛɛŋ ki bo jo wu nje bamii gɛ̀ duu lɛ wu ghaane lo. ");
INSERT INTO ncr_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Bamii ba gɛ̀ duunyi banchi ba Nyo ba gɛ̀ ja Yɛlusalɛm bo boh yo bo tu bo duu lɛ, “Bɛsebu le ye ye le, wu bvuuse banchɛndaa ba debele banɛ, nyu bɛ bvuŋga bvu Nfoŋ wu banchɛndaa bayu.” ");
INSERT INTO ncr_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jiso bɛɛŋ bo, wu biih bo le a ŋgaŋ le lɛ, “Taŋlo Sataŋ ka wu bvuuse kikwɛɛ ke yi muh le nɛɛ? ");
INSERT INTO ncr_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nɛ kituŋ ja ki gade ki juu lɛkilɛki, ki gɛ ka ki lɛɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Yeh ja yi gade yi juu lɛyilɛyi, yi gɛ ka yi lɛɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Noo, Sataŋ ja wu gade bɛ ŋgoo ye bo juu lɛbolɛbo, wu gɛ ka wu lɛɛŋ gɛ, mo nyu kimɛsɛ ke. ");
INSERT INTO ncr_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Bɛŋ kêe lɛ gɛ muh nyu yu wu taŋlo wu lee yeh yi muh wu bvuŋga le, wu kudɛ mwɛɛ mwe yi nchiɛɛŋ le wu legɛ bɛ mu, njɛ wu ya wu kaaŋ muh bvuŋga wuyu fɛ wu kudɛ sɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nsɛɛŋ bɛŋ le nchiɛɛŋ lɛ Nyo taŋlo wu lɛɛshɛ mwɛɛ mù mbefe mo jɛ́ yì befe yichii yì bamii jɛme. ");
INSERT INTO ncr_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Geenɛ, muh wù jɛme jɛ yì befe kune Kiyo ki Yuude, tu gɛ taŋlo Nyo lɛɛshɛ gɛ, nje wu le wu ge kimbefɛ ki kage gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jiso gɛ̀ jɛme noo nje bamii bayu gɛ̀ duu lɛ kiyo kì yiide le yi ye ye le. ");
INSERT INTO ncr_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Bwe Jiso bɛ booŋ ba bwee Jiso mo bo fɛsɛ, bo lɛɛŋ akfuuŋ, bo tuŋ muh lɛ wu tɛɛŋ wu. ");
INSERT INTO ncr_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Gɛ̀ bee kinchvu ki bamii shii ki tuŋ kigaŋ bo taashɛ. Bo jɛmɛ wu le lɛ, “Bwoo bɛ booŋ ba bwoo goone wo akfuuŋ.” ");
INSERT INTO ncr_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jiso biih lɛ, “Bwaaŋ bɛ booŋ ba bwɛɛŋ le baaŋ?” ");
INSERT INTO ncr_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","No wu bile noo wu mo wu jiŋɛ bamii ba gɛ̀ shilɛ bo tuŋ kigaŋ baa, wu jɛmɛ lɛ, “Bwaaŋ bɛ booŋ ba bwɛɛŋ le banɛ. ");
INSERT INTO ncr_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Muh wuchii wù gee fiɛɛ fì Nyo goone, le wu wu le mwa bwɛɛŋ bɛ jɛme yaŋ mo bwɛɛŋ.” ");
INSERT INTO ncr_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jiso ka wu kɛ wu yɛyi bamii mbebe mamasi le, kinchvu ki bamii taashɛ fo nɛ gɛmm. Wu mo wu ja wu lee wu shii nyu a ŋguh le a joo, kinchvu kiyu lɛme ŋgɛɛme yi joo le kwa. ");
INSERT INTO ncr_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Wu tu wu yɛyi bo bɛ mwɛɛ wesee a baŋgaŋ le. Wu ja wu ma ŋgaŋ wumu bo le lɛ, ");
INSERT INTO ncr_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Bɛŋ yêgɛ bɛŋ yû, muh gɛ̀ la ki wu gɛ̂ɛŋ wu noŋ ŋgo. ");
INSERT INTO ncr_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Wu gɛ̀ doo wu nooŋ, yimi gwe a je, munyii to mu tajɛ mu ji. ");
INSERT INTO ncr_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yimi ŋgo gwe fɛ kijusɛ ki kimbaaŋ le nshɛŋ nyu gɛ fo chuule gɛ. Yi mo yi yaŋsɛ yi bu nje nshɛŋ gɛ̀ bee fo gɛh nɛ shige. ");
INSERT INTO ncr_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Muu doo wu kɛ wu baaŋ, wu suŋ ŋgo yiyu yi bobɛ, nje yi gɛ̀ baaŋ a chimɛ gɛ gɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yimi ŋgo gwe yi mbiaŋ le. Mbiaŋ yiyu kuu yi mo yi baŋɛ ŋgo yiyu, yi gɛ yuŋ muntaŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Yimi gwe nyu yi nshɛŋ yì joŋe le, yi gɛ̀ bu, yi kuu yi yuŋ, yi duu yi fe no ba gɛ̀ noŋ, jise chi ŋgo yune ajii mbaanshɛ, yimi ajii mbambvusoo, yimi ajii gwii.” ");
INSERT INTO ncr_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","No Jiso ma noo wu mo wu mɛsɛ lɛ, “Muh wù kɛme bintuŋ wu yu.” ");
INSERT INTO ncr_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jiso gɛ̀ doo wu nyume wumaa, bamii bamu ba bɛ bo gɛ̀ bee mo booŋ be ba ŋgoo ba yuufe ncho bafɛɛ biih wu le kune ŋgaŋ wuyu. ");
INSERT INTO ncr_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Wu chvuu bo le lɛ, “Le bɛŋ ba Nyo le wu dunyɛ wa kinyilɛ ki bvunfoŋ bwe bɛŋ le. Geenɛ, fɛ bamii bamu le fiɛɛ fichii le nyu a baŋgaŋ le, ");
INSERT INTO ncr_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","wu lɛ bo ge bo jiiŋe, geenɛ bo ya yɛde gɛ, bo ge bo yege, bo ya yuge gɛ. Fi nɛ bee gɛ noo gɛ tu bo bee bo kusɛ wa muntele muboo, Nyo lɛɛshɛ bimbefɛ biboo.” ");
INSERT INTO ncr_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jiso ja wu biih bamii ba gɛ̀ bee bɛ wu le lɛ, “Fi le lɛ bɛŋ baaŋ kɛɛ gɛ fiɛɛ fì ŋgaŋ wunɛ jɛme gɛ? Nɛ bɛŋ baaŋ kɛɛ gɛ wunɛ gɛ, bɛŋ lé bɛŋ gê nɛɛ fɛ bɛŋ kɛɛ baŋgaŋ bamu? ");
INSERT INTO ncr_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ŋgo yì muh wuyu gɛ̀ noŋ le jɛ yi Nyo. ");
INSERT INTO ncr_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ŋgo yì gɛ̀ gwe a je le bamii ba yuge jɛ yi Nyo, Sataŋ mo wu to kimimia wu bvusɛ jɛ yiyu fɛ muntele muboo le. ");
INSERT INTO ncr_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ŋgo yì gɛ̀ gwe fɛ kijusɛ ki ata le, le bamii ba yuge jɛ yi Nyo, bo fi lo kimimia bɛ njoŋ, ");
INSERT INTO ncr_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","geenɛ, yi baaŋ a chimɛ gɛ gɛŋ fɛ muntele muboo le gɛ. Yi lɛme gɛh nɛ shige, nɛ ŋgɛ le wu to, kɛnɛ bamii boone nyu bikaa a bo jiŋ nje jɛ yiyu, bo mo bo chii bikaa kimimia. ");
INSERT INTO ncr_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ŋgo yì gɛ̀ gwe mbiaŋ le, le bamii ba yuge jɛ yi Nyo, ");
INSERT INTO ncr_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","nfuuŋsɛ kune mwɛɛ mu yi woŋ kfunɛ le, bɛ kiŋkoŋɛ ki bvukugɛ mo kiŋkoŋɛ ki mwɛɛ munɛ, mo mu taashɛ mu baŋɛ jɛ yiyu yi laayɛ lo achiji. ");
INSERT INTO ncr_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ŋgo yì gɛ̀ gwe yi nshɛŋ yì joŋe le, le bamii ba yuge jɛ yi Nyo, bo fi, bo gee no yi goone bo gɛɛne lo fwe fwe, gɛh njɛ fɛ ŋgo yì yuŋ ajii mbaanshɛ, yimi ajii mbambvusoo, yimi ajii gwii.” ");
INSERT INTO ncr_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jiso ja wu biih lɛ, “Muh to wu lee bɛ kin'yesɛ yeh wu kfuusɛ bɛ ŋkaa, kɛnɛ wu leesɛ agaguu? Gɛ muh to wu chu wu tome nyume yi fiɛɛ fì ba to ba toome kin'yesɛ fo gɛ? ");
INSERT INTO ncr_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bɛŋ kêe lɛ fiɛɛ fichii fì le nyilɛ le, le ba gɛ̀ nyile lɛ ba ge fi yɛnɛ, fì le ajiŋ ajiŋ fichii ba lé ba gê fi bu fɛ waaŋ. ");
INSERT INTO ncr_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Muh wù kɛme bintuŋ, wu yu.” ");
INSERT INTO ncr_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jiso ka wu jɛmɛ lɛ, “Bɛŋ doo bɛŋ yege jɛ yi Nyo bɛŋ yêge chuule, bɛŋ kêe lɛ je yì muh yege yu le yì Nyo lé wu gê wu fe yo, fɛ wu nya mwɛdɛ le. Wu lé wu gê wu nya noo wu fesɛ lo. ");
INSERT INTO ncr_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Muh wù kɛme fiɛɛ, lé ba nyû ba bisɛ. Muh wù kɛme gɛ fiɛɛ gɛ mo nyu fì shige fì wù kɛme, lé ba nyû ba ge ba fi lo a wu le.” ");
INSERT INTO ncr_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jiso ka wu jɛmɛ lɛ, “Bvunfoŋ bvu Nyo le njɛ ŋgo fɛ muh nooŋ mwɛne. ");
INSERT INTO ncr_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Doo nyume antaŋ wu tu wu lefe, akfuuŋ yuu wu ja we. Ŋgo yiyu gɛ̀ bu yi tu yi kuu, wu baaŋ a kɛɛ gɛ laa yi gee nɛɛ fɛ yi kuu la, ");
INSERT INTO ncr_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","gee gɛh nshɛŋ fɛ yi kuu. Sege yi ja yi chooŋ, yi ja yi faashɛ, yi ge yi ja fo yi tuŋ ajii. ");
INSERT INTO ncr_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Yi doo yi ta, wu mo wu jo finyoo wu lee mwɛne, nje kife ki ŋgwejɛ le ki kojɛ ka.” ");
INSERT INTO ncr_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jiso ka wu ja wu jɛmɛ lɛ, “Taŋlo besabɛŋ fe bvunfoŋ bvu Nyo bɛ la? Taŋlo besabɛŋ fe bɛ ŋgaŋ wù la? ");
INSERT INTO ncr_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Bvu nyume njɛ kfuu chi ŋgo yi fintaŋ fimi,fi nyoonyi ajii fi fede biŋgogɛ bichii fɛnɛ fɛkuu muh gɛ̀ to wu nooŋ a wu mwɛne ");
INSERT INTO ncr_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","yi ku, yi yɛɛŋ yi fe bite bichii bì ba nooŋ mwɛne, chɛ́ ye kuge yi nyaa kiyiŋ, munyii mù fuune we joone yeh a kiyiŋ kiyu le.” ");
INSERT INTO ncr_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Le no Jiso gɛ̀ feeji jɛ yi Nyo bamii le a baŋgaŋ le njɛ banɛ, no taŋlo bo yu bo gɛɛŋ bo bu. ");
INSERT INTO ncr_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Gɛ wu gɛ jɛme fiɛɛ bo le njɛ le a ŋgaŋ le sɛŋ gɛ. Geenɛ, wu gɛ̀ doo wu nyume bɛ booŋ be ba ŋgoo lɛbolɛbo, wu mo wu mɛsɛ wu bwaashɛ baŋgaŋ bayu bachii bo le. ");
INSERT INTO ncr_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jiso yɛyɛ bamii abvu, lɛ doo nyume fɛnfu, wu jɛmɛ booŋ be ba ŋgoo le lɛ, “Bee daŋ mamasi bee gɛɛŋ wuŋ kwege.” ");
INSERT INTO ncr_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bo mo bo chinɛ kinchvu ki bamii kì gɛ̀ bee fo le, bo lee a ŋguh wù Jiso gɛ̀ bee wa yo wɛɛ le, bɛ bo tu bo daŋe, baŋguh bamu bii bo le. ");
INSERT INTO ncr_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","No bo gɛ̀ daŋe, nfuŋ wù baaŋ ja wu jaŋɛ wu kɛ wu tu wu muuse joo, joo lese a ŋguh le yi goone ki yi yîsɛ yo. ");
INSERT INTO ncr_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jiso gɛ̀ bee a ŋguh wɛɛ jiŋ wu lefe, wu giŋsɛ kikwɛɛ yi mbwaaŋ le. Bo gɛɛŋ bo kaŋsɛ wu bo du lɛ, “Muh wu N'yɛyɛ, kwe goone ki yi jô besabɛŋ wo ghaade gɛ?” ");
INSERT INTO ncr_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jiso kaŋsɛ, wu waŋ nfuŋ wuyu, wu jɛmɛ joo le lɛ, “Wo nyûme nshiiŋŋ.” Nfuŋ wuyu mo wu lu, manjuu chii nɛ nshiiŋŋ. ");
INSERT INTO ncr_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Wu mo wu biih booŋ be ba ŋgoo le lɛ, “Bɛŋ faane la? Bɛŋ baaŋ a leesɛ gɛ fitele yi ye yaŋ le gɛ?” ");
INSERT INTO ncr_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ye kuufɛ bo, bo tu bo ghaade fɛwɛɛwe lɛbolɛbo lɛ, “Wunɛ muh le wù nɛɛ, wù nfuŋ bɛ joo yuge wu le?” ");
INSERT INTO ncr_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jiso bɛ booŋ be ba ŋgoo daŋ mamasi wuyu bo bu wuŋ kwege, kimbe ki bamii ba Gɛlasɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","No wu gɛ̀ bude a ŋguh le, wu tasɛ bɛ muh mu wù kiyo kì yiide gɛ̀ njiiŋse bɛ wu, wu bu afuuŋ yì ba gɛ̀ jiiyi bamii yo le. ");
INSERT INTO ncr_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Muh wuyu to wu chee afuuŋ yiyu le. Muh nyu gɛ yu wù taŋlo wu kaaŋ wu mo bɛ bancha gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kiŋgane kì duude le ba gɛ̀ leese wu kinfaŋa le, ba kaaŋ chiaaŋ ye bɛ bancha, wu suume bancha bayu, wu saayɛ binfaŋa biyu. Gɛ muh gɛ̀ kɛme bvuŋga bvù taŋlo wu jijɛ wu le gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Muh wuyu tu wu shɛŋe a manta mayu le wu bɛɛne wu bude yi bambegɛ le antaŋ bɛ fɛnshɛ, wu wanɛ, wu shooshi ye ye bɛ ata. ");
INSERT INTO ncr_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","No wu yɛŋ Jiso le baaŋ je yì ndefe le, wu legɛ wu to wu tuŋ anyuu a wu jii, ");
INSERT INTO ncr_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","wu waŋ fɛwɛɛwe lɛ, “Jiso Mwa Nyo, Nyo wu le Kikwɛɛ ki Mwɛɛ Munchii lɛ, wo fii la a mɛne? Nlɛge wo a jee chi Nyo le lɛ keefɛ wo nyâ mɛ ŋgɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Wu gɛ̀ jɛme noo, nje Jiso gɛ̀ waŋ wa lɛ, “Kiyo kì yiide kinɛ, bû lo yi muh wunɛ le.” ");
INSERT INTO ncr_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jiso biih wu le lɛ, “Jee chuŋ le yɛɛŋ.” Wu chvuu lɛ, “Jee chaŋ le lɛ kinchvu, nje bee duude lo.” ");
INSERT INTO ncr_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","No wu chvuse noo, wu mo wu lɛgɛ Jiso wesee lɛ keefɛ wu kuŋ bɛ bo woŋ wuyu kwɛɛ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Gɛ̀ bee ŋgoo yi munyuŋa mù duude jii mwɛɛ yi mbɛɛsɛ le fo. ");
INSERT INTO ncr_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Biyo bì yiide biyu mo bi lɛgɛ Jiso lɛ, “Wo chiiŋsɛ bee nyu a munyuŋa mwege le bee lee yi mu le.” ");
INSERT INTO ncr_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jiso bɛɛŋ. Biyo biyu mo bi bu yi muh wuyu le, bi gɛɛŋ bi lee yi munyuŋa muyu le. Ŋgoo yi munyuŋa muyu gɛ̀ bee njɛ banchvuge bafɛɛ. Mu sɛŋ mu boh a kiŋkoŋ kɛɛ le, mu shii a mamasi wuyu le, mu kweeyɛ yo. ");
INSERT INTO ncr_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bamii ba gɛ̀ chiɛɛne munyuŋa muyu ja fo, bo fɛɛ lo, bo gɛɛŋ bo sɛɛŋ saaka wuyu a laantɛŋ bɛ bantɛ ba yo le. Bamii tu bo yuge, bo bude bo too ki bo to bo yɛŋ fiɛɛ fì kooshi le. ");
INSERT INTO ncr_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bo to fɛ Jiso gɛ̀ bee fo, bo yɛŋ muh wɛɛ wù kinchvu ki banchɛndaa ba debele gɛ̀ shee bo njiiŋse bɛ wu, wu shii fo, wu jii njú, bvufee bwe kaasɛ wa bvu tu fo. Bo faŋ baaŋ. ");
INSERT INTO ncr_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bamii ba gɛ̀ yɛŋ fiɛɛ fì gɛ̀ kooshɛ le, bo mo bo sɛŋe bo no fi gɛ̀ kooshɛ bɛ muh wɛɛ mo ŋgoo yi munyuŋa yɛɛ. ");
INSERT INTO ncr_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","No bo yu noo, bo kɛ bo lɛge Jiso lɛ wu ja gwɛŋ wuboo le. ");
INSERT INTO ncr_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","No Jiso gɛ̀ goone ki wu lêe a ŋguh le, muh wù banchɛndaa ba debele gɛ̀ bu ye ye le wɛɛ tu wu lɛge Jiso lɛ bɛ wu gɛɛne. ");
INSERT INTO ncr_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jiso faŋ, wu jɛmɛ wu le lɛ, “Wo gɛ̂ɛne nyu fɛ wo kfuuŋ, wo gɛɛŋ wo sɛɛŋ bamii buŋ fiɛɛ fì Tada ge fɛ wo le, bɛ no wu le wu koo yii fɛ wo le.” ");
INSERT INTO ncr_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Noo, muh wuyu mo wu ja, wu gɛɛŋ wu jiɛnyi woŋ wuyu le wuchii, wu ba gɛ̀ tɛŋe lɛ Bilaantɛŋ bì Yuufe le, wu feeji fiɛɛ fì Jiso ge fɛ wu le. Bamii tu bo yuge, bo kɛme lo ŋgha. ");
INSERT INTO ncr_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jiso kaasɛ wu daŋ a ŋguh le wu tu wuŋ kwege wu tu wù nyu mbebe mamasi le, kinchvu ki bamii ka ki taashɛ fo. ");
INSERT INTO ncr_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Chiji kikwɛɛ ki yeh yi buunɛ wumu mo wu ja wu to fo, jee che nyu lɛ Jailu. No wu yɛŋ Jiso le, wu gɛɛŋ wu gwe a wu jii, ");
INSERT INTO ncr_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","wu lɛgɛ wu wesee, wu jɛmɛ lɛ, “Mwa yaŋ wù shige wù kwɛse kwee lo. Kii wo, tô gɛh wo kûŋ wu le wu tɛmɛ, wu tu yu.” ");
INSERT INTO ncr_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jiso mo wu ja bɛ wu tu bo gɛɛne, kinchvu ki bamii kfuunɛ ki bii ki faase Jiso. ");
INSERT INTO ncr_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kwɛse wumu tɛ gɛ̀ bee a kinchvu kiyu ntɛnɛɛ wù nyu wu chɛŋ wa bɛ kinchɛŋ ki bikɛse lɛ biluŋ yuufe ncho bifɛɛ. ");
INSERT INTO ncr_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Wu gɛ̀ bee wu yɛŋ wa ŋgɛ baaŋ a bamii ba nche ba duude jiŋ, wu chɛŋɛ wa fiɛɛ fichii fì wu gɛ̀ kɛme, mwɛɛ foo gɛh lo mu gɛɛne fwe fwe. ");
INSERT INTO ncr_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","No wu gɛ̀ yu wa kune Jiso, wu mo wu to a wu jiŋ a kinchvu ntɛnɛɛ, wu kuŋ nju ye le, ");
INSERT INTO ncr_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","nje wu gɛ̀ duu fɛ fitele fie le lɛ, “Nɛ n'ya ŋkuŋ gɛh nyu nju ye le, tu nle ntɛmɛ wa.” ");
INSERT INTO ncr_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","No wu gɛ̀ kuŋ noo, kinchɛŋ ke mo ki suunɛ kimimia. Kwɛse wuyu yu tɛ ye ye le lɛ wu le wu tɛmɛ wa. ");
INSERT INTO ncr_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jiso doo wu yu ye ye le lɛ bvuŋga le bvu bu ye ye le, wu kaasɛ ye kimimia, wu biih bamii le lɛ, “Kuŋ yɛɛŋ nju yaŋ le?” ");
INSERT INTO ncr_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Booŋ be ba ŋgoo chvuu wu le lɛ, “Wo yɛnɛ gɛ kinchvu ki bamii le no ki faase wo gɛ, wo ka biide laa kuŋ yɛɛŋ wo le la? ");
INSERT INTO ncr_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jiso mɛ gɛh wu tu wu jiiŋe wu kɛɛne ki wu yɛ̂ŋ muh wù kuŋ wu le. ");
INSERT INTO ncr_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","No, kwɛse wuyu gɛ̀ kee fiɛɛ fì kooshi bɛ wu, wu tu wu faane, wu shiŋshi, wu tuŋ anyuu a Jiso jii wu sɛɛŋ nchiɛɛŋ nchiɛɛŋ we wuchii wu le.” ");
INSERT INTO ncr_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jiso jɛmɛ wu le lɛ, “Mwa yaŋ, fitele fiuŋ fì wo lese yi ye yaŋ le le fi ge wa wo tɛmɛ. Wo gɛ̂ɛne la chuule kinchɛŋ kuŋ ka lo nɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Gɛh no Jiso gɛ̀ baaŋ wu jɛme kwɛse wɛɛ le noo, bamii bamu fɛsɛ fo bo ja fɛ la chi Jailu wù chiji kikwɛɛ ki yeh yi buunɛ wɛɛ le, bo jɛmɛ wu le lɛ, “Mwa yo le wu mɛsɛ wa. Wo ka she wo nyaa ŋgɛ muh wu n'yɛyɛ le lɛ la?” ");
INSERT INTO ncr_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","No bo jɛmɛ noo, Jiso yu, geenɛ wu ge gɛh njɛ wu baaŋ yu gɛ, wu jɛmɛ Jailu le lɛ, “Keefɛ wo fâane gɛ, lêesɛ gɛh nyu fitele ye yaŋ le maa.” ");
INSERT INTO ncr_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Bo tu bo gɛɛne gɛh lo, Jiso gɛ faŋ lɛ keefɛ muh bi wu le fede Bita bɛ Jɛm mo Joŋ wù mwa bwee Jɛm gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bo gɛɛŋ bo fɛsɛ fɛ la chi Jailu le, Jiso yɛŋ bamii beede bo fuge lo fo, kwe yode lo fo. ");
INSERT INTO ncr_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Wu lee yeh, wu biih lɛ, “Bɛŋ beede, bɛŋ fuge manjuu le nɛ nje la? Mwa baaŋ kwe gɛ, wu lefe lo.” ");
INSERT INTO ncr_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Bo mo bo ja bo keede lo wu ŋkelɛ le. Wu ja wu bvusɛ bamii bachii akfuuŋ, wu jo gɛh nyu chiji mwa bɛ bwe mwa mo bamii be ba ŋgoo ba batɛde baa, bɛ bo lee bo gɛɛŋ fɛ mwa wuyu gɛ̀ gime fo. ");
INSERT INTO ncr_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Wu jijɛ mwa wuyu yi kibo le wu jɛmɛ a jɛ́ yiboo le lɛ, “Talita Kum!” Fì le lɛ, “Mwa wù kwɛse, njɛme wo le, jâ we!” ");
INSERT INTO ncr_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kimimia noo, wu mo wu ja we wu tu wu jiɛnyi. Mwa wù kwɛse wuyu gɛ̀ bee biluŋ yuufe ncho bifɛɛ. Bo yɛŋ noo jwe yuŋ bo. ");
INSERT INTO ncr_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jiso chiisɛ lo bo le lɛ keefɛ bo gê muh kɛ̂ɛ fiɛɛ fì be bee gɛ, wu mo wu jɛmɛ lɛ bo nya fiɛɛ wu ji. ");
INSERT INTO ncr_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jiso ja fo, wu gɛɛŋ ntɛ we le bɛ booŋ be ba ŋgoo. ");
INSERT INTO ncr_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Gɛ̀ doo nyume juu chiboo chi yuuŋ, wu gɛɛŋ yeh yi buunɛ le wu kɛ wu yɛyi bamii. Bamii ba duude tu bo yuge no wu yɛyi, bo kɛme lo ŋgha. Bo mo bo ja bo ghaade bo duu lɛ, “Muh wunɛ yɛyi munɛ mwɛɛ faaŋ nɛ? Wu jo bvunɛ bvufee faaŋ? Wu jiɛnyi nɛɛ fɛ wù gee binɛ biŋgha bi mwɛɛ nɛ? ");
INSERT INTO ncr_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Le gɛh wu wɛɛ wù kaane bite wù nyu mwa Mɛɛle? Gɛ nyume mwa bwee Jɛm bɛ Yosɛf mo Juda bɛ Samoŋ gɛ? Gɛ jɛ́me ye nyu yanɛ besa bo gɛ?” No bo ghaade noo bo mo bo faŋ lo wu. ");
INSERT INTO ncr_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Noo, Jiso jɛmɛ bo le lɛ, “Ba to ba ŋgvuune muh wu ntuŋ wu Nyo manjuu le manchii, fuge gɛh woŋ we le bɛ a kfuu che le mo a wu yeh wù ba to gɛ ba ŋgvuune wu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","No bo faŋ Jiso noo, fi mo fi gha kì wu ka wu ge biŋgha bi mwɛɛ yo wesee, fede gɛh lɛ wù gɛ̀ bee wu kuŋ bamii ba binchɛŋ le shige wu fɛ bo tɛmɛ. ");
INSERT INTO ncr_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Wu kɛmɛ lo ŋgha no bo gɛ̀ baaŋ lee gɛ fitele yi wu le gɛ. Jiso ja fo wu tu wu jiɛnyi bantɛ ba yo le wu yɛyi bamii. ");
INSERT INTO ncr_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Wu gɛ̀ ja wu tɛɛŋ booŋ be ba ŋgoo ba yuufe ncho bafɛɛ, wu tu wu tune bo akfuuŋ bafɛɛ bafɛɛ, wu nyaa bvuŋga bvù bo bvuuse biyo bì yiide yi bamii le yu. ");
INSERT INTO ncr_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Wu doo wu tune bo wu jɛme lɛ, “Keefɛ bɛŋ jô lo fiɛɛ fede kimbaŋ gɛ. Keefɛ bɛŋ jô mwɛɛ munjile gɛ. Keefɛ bɛŋ jô kikɛɛ kɛnɛ bige a bicha biɛna le gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Bɛŋ lêe jé, geenɛ keefɛ bɛŋ lêe bikuŋ bifɛɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Wu ka wu jɛmɛ bo le lɛ, “Bɛŋ doo bɛŋ gɛɛŋ ntɛ le, bɛŋ lee yeh, bɛŋ chee gɛh nyu yu gɛɛne bu juu chì bɛŋ lé bɛŋ jâ yo. ");
INSERT INTO ncr_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nɛ ntɛ le wu faŋ ki wu fî bɛŋ, wu faŋ ki wu yû fiɛɛ fì bɛŋ jɛme, bɛŋ ja yo, bɛŋ doo bɛŋ jade bɛŋ kaajɛ kibvunɛ kì yi bikaa biɛna le, nyu njiŋɛ wù fiɛɛ fì bo moŋ le.” ");
INSERT INTO ncr_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Noo, bo mo bo ja bo gɛɛŋ bo tu bo jiɛnyi bo feeji lɛ bamii kusɛ muntele muboo. ");
INSERT INTO ncr_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bo ka bvuuse tɛ banchɛndaa ba debele wesee yi bamii le, bo yeefe bamii ba binchɛŋ wesee bɛ mɛɛ bo fɛde bo. ");
INSERT INTO ncr_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nfoŋ Hɛlod yu saaka kune Jiso, no bamii gɛ̀ yu wa jee che manjuu le manchii, bamii bamu tu bo duu lɛ, “Jiso wunɛ le Joŋ Nlesɛajoo wu kaase wu bu yi kwe le. Le fiɛɛ fì ge fɛ wù kɛme bvuŋga ki wù gee biŋgha bi mwɛɛ munɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bamu duu lɛ, “Le Alaja wu kaase wu to.” Bamu tɛ lɛ, “Wu le muh wu ntuŋ wu Nyo wumu gɛh njɛ ba fweele fweele.” ");
INSERT INTO ncr_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Hɛlod doo wu yu mwɛɛ munɛ nɛ wu jɛmɛ fie lɛ, “Le Joŋ Nlesɛajoo wu ŋgɛ̀ mbvusɛ kikwɛɛ ke wu kaase wu bu yi kwe le.” ");
INSERT INTO ncr_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Hɛlod gɛ̀ bee wu tuŋ bamii bo gɛɛŋ bo koo Joŋ, bo kaaŋ wù bo faa yeh yi ncha le nje Hɛlodia wù kwɛ Filib wù mwa bwe Hɛlod, Hɛlod gɛ̀ jo kwɛɛ le. ");
INSERT INTO ncr_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Joŋ tu wu faŋe wu duu wu le lɛ, “Nchi baaŋ bɛɛŋ gɛ lɛ muh jo kwɛ mwa bwee kwɛɛ le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","No Joŋ gɛ̀ duu noo, Hɛlodia mo wu tu wù kɛme wu fɛ fitele le wù goone ki wu yûuyɛ wu, geenɛ wu gɛ kɛmɛ je gɛ, ");
INSERT INTO ncr_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","nje Hɛlod gɛ̀ faane Joŋ lɛ wu le muh wù chaaŋ ka nyume muh wu Nyo. Wu mo wu tu wu yɛde lɛ keefɛ ba yûuyɛ wu gɛ. Hɛlod gɛ̀ doo wu yege fiɛɛ fì Joŋ jɛme, fitele fie tu fi fuuŋse wu baaŋ, geenɛ wu tu wu yuge gɛh njoŋ ki wu yêge fiɛɛ fì wu jɛme. ");
INSERT INTO ncr_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Je mo yi yɛnɛ fɛ Hɛlodia le juu chimi chì Hɛlod gɛ̀ ge ŋka bɛ bachiji woŋ mo bikwɛɛ bi nchi mo bamii ba baaŋ baaŋ ba Galalee ki wu kwâjɛ juu chi ba gɛ̀ boyɛ wu. ");
INSERT INTO ncr_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mwa Hɛlodia wù kwɛse lee wu chɛŋ bine, fi joŋ Hɛlod bɛ bamii be ba ŋka le. Wu mo wu jɛmɛ mwa wuyu le lɛ, “Bîih kɛnɛ la fì wo koŋe, nfayɛ wo yu!” ");
INSERT INTO ncr_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Wu ka wu ji leh wu jɛmɛ lɛ, “Nɛ wo biide nyu la mɛne, mo nyu kiŋgadɛ ki woŋ waŋ, tu nlé nnyâ wo le.” ");
INSERT INTO ncr_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mwa wù kwɛse wuyu mo wu bu wu gɛɛŋ wu biih bwee le lɛ, “Ndu lɛ ba fayɛ mɛ bɛ la?” Bwee chvuu lɛ, “Gɛ̂nɛ, wo dû lɛ ba nya kikwɛɛ ki Joŋ Nlesɛajoo wo le.” ");
INSERT INTO ncr_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Wu mo wu tu jiŋ kimimia, wu jɛmɛ Nfoŋ Hɛlod le lɛ, “Ŋkoŋe lɛ wo nya kikwɛɛ ki Joŋ Nlesɛajoo mɛne mɛɛse a kidɛŋ le.” ");
INSERT INTO ncr_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nfoŋ yu noo, ye wooŋ lo wu. Geenɛ, nje leh wù wu gɛ̀ ji wa fwe a bamii ba gɛ̀ bee fɛ ŋka wɛɛ le, wu goone gɛ ki wu ka wu kusɛ jɛ ye yì wu gɛ̀ jɛmɛ mwa wɛɛ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Wu mo tuŋ lo nchɛndaa kimimia lɛ wu gɛɛŋ wu to bɛ kikwɛɛ ki Joŋ. Wu mo wu gɛɛŋ yeh yi ncha le, wu bvusɛ kikwɛɛ ki Joŋ, ");
INSERT INTO ncr_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","wu gɛɛ a kidɛŋ le, wu to wu nya mwa wuyu le. Wu fi, wu bu bɛ ki wu gɛ̂ɛŋ wu nya bwee le. ");
INSERT INTO ncr_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Booŋ ba ŋgoo ba Joŋ doo bo yu, bo mo bo gɛɛŋ bo jo gvunɛ chi Joŋ bo jiiyɛ. ");
INSERT INTO ncr_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Booŋ ba ntuŋ ba Jiso gɛ̀ jiɛnyɛ bo kaasɛ bo tu jiŋ fɛ wu le, bo sɛɛŋ mwɛɛ munchii mù bo gɛ̀ ge bɛ mù bo gɛ̀ yɛyɛ bamii yu, wu le. ");
INSERT INTO ncr_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Wu mo wu ja wu jɛmɛ bo le lɛ, “Bɛŋ tô besabɛŋ gɛɛŋ kijusɛ kì bamii ya fo gɛ, bee fuudɛ shige.” Wu gɛ̀ jɛme noo nje bamii ba duude gɛ̀ too fɛ bo gɛ̀ bee fo, bamu doo bo jade, bamu tu bo too. Bo kɛme gɛ mo kife kì bo ji mwɛɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bɛ bo mo bo lee a ŋguh le bo kaasɛ ye lɛbolɛbo bo tu bo gɛɛne fɛ kijusɛ kì bamii gɛ̀ bee gɛ fo gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Geenɛ, bamii ba duude yɛŋ gɛh bo le no bo gɛɛne, bo kɛɛ bo, bo mo bo ja a bilaantɛŋ le bichii bo legɛ bo suunɛ bo. Bo gɛɛŋ bo fɛsɛ fo, fɛ Jiso bɛ booŋ be ba ŋgoo fɛsɛ. ");
INSERT INTO ncr_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jiso gɛ̀ doo wu fɛɛse kwa, wu yɛŋ kinchvu ki bamii le nɛ mamama, yii koo wu bɛ bo, nje bo gɛ̀ bee njɛ shóŋ yì le gɛ bɛ muh wù chiɛɛne yi gɛ. Wu mo wu kɛ wu tu wu yɛyi bo, wu yɛyɛ bo bɛ mwɛɛ wesee. ");
INSERT INTO ncr_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Juu gɛ̀ doo chi seele, booŋ be ba ŋgoo kɛŋsɛ bo jɛmɛ wu le lɛ, “Fɛnɛ le nchvuuŋ kife nyu ki gɛɛŋ wa, ");
INSERT INTO ncr_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","gɛh chinɛ bamii banɛ le bo gɛɛŋ bantɛ le bɛ ala a mbebe le, bo gu mwɛɛ muboo munjile.” ");
INSERT INTO ncr_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jiso chvuu fie lɛ, “Le nya bɛŋ fiɛɛ bo le bo ji.” Bo biih wu le lɛ, “Wo goone lɛ bee gooŋ badanale gii yifɛɛ bee gu mwɛɛ munjile yu bee to be nya bo le?” ");
INSERT INTO ncr_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jiso biih bo le lɛ, “Bɛŋ kɛme chefe yi blɛd yimɛɛ? Bɛŋ gɛ̂ɛŋ bɛŋ bîjɛ.” Bo gɛɛŋ bo bijɛ, bo to bo sɛɛŋ lɛ, “Le chefe yi blɛd yishɛŋ bɛ bíɛŋ yifiɛɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jiso mo wu du lɛ booŋ be ba ŋgoo du lɛ bamii shiiyɛ binchvu le binchvu le, yi agaaŋ le. ");
INSERT INTO ncr_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Noo, bamii bayu mo bo shiiyɛ fɛkuu kinchvu le gwii gwii bamu mbaanshɛŋ mbaanshɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jiso jo chefe yi blɛd yì yishɛŋ chiɛɛ bɛ bíɛŋ yì yifiɛɛ chiɛɛ, wu bijɛ we, wu nya kiyone Nyo le, wu mo wu bwɛɛyɛ wu nya booŋ be ba ŋgoo le, bo nya bamii le. Wu gajɛ tɛ bíɛŋ yi yifiɛɛ bo le bachii. ");
INSERT INTO ncr_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bamii bachii ji bo fuu. ");
INSERT INTO ncr_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Booŋ ba Jiso ba ŋgoo baanyɛ bimbɛge bi blɛd bɛ bi bíɛŋ bì gɛ̀ shɛshɛ, bì yisɛ ŋkáa yuufe ncho yifiɛɛ. ");
INSERT INTO ncr_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Bamii ba gɛ̀ ji mwɛɛ munjile muyu gɛh bee bilɛŋsɛ banchvuge batɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jiso mo wu jɛmɛ lɛ booŋ be ba ŋgoo lee a ŋguh le kimimia bo saa fwe Bɛsada, wu shɛɛ wu yɛsɛ bamii le, bo kwɛɛde. ");
INSERT INTO ncr_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Wu gɛ̀ shɛɛ wu yɛsɛ bo, wu mo wu ja wu bɛɛŋ yi mbegɛ le ki wu bûunɛ. ");
INSERT INTO ncr_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Akfuuŋ gɛ̀ jiiŋ, ŋguh nyume wa fɛ joo ntɛnɛɛ, Jiso baaŋ gɛh kwa wu maa. ");
INSERT INTO ncr_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Wu yɛŋ no booŋ be ba ŋgoo lune bɛ ŋguh ki bo kɛɛne, nje fii gɛ̀ too je fwe yi chide wu. Lɛ to nyume an'yule wu ja wu tu wu too fɛ bo le, wu jiɛnyi yi joo le. Wu gɛ̀ too wu goone ki wu fê mbebe yiboo le. ");
INSERT INTO ncr_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Bo doo bo yɛŋ no wu jiɛnyi yi joo le, bo tu bo kwaji lɛ le kiyi. Bo waŋ fɛwɛɛwe, ");
INSERT INTO ncr_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","nje bo bachii gɛ̀ yɛŋ wu le njaŋ koo bo. Kimimia, Jiso mo wu jɛmɛ bo le wu du lɛ, “Bɛŋ jîjɛ muntele mwɛna le, le mɛ! Keefɛ bɛŋ fâane gɛ!” ");
INSERT INTO ncr_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","No wu jɛmɛ noo, wu mo wu lee wu shii a ŋguh le bɛ bo, fii yiyu mo yi lu. Bo bijɛ nɛ, jwe yuŋ bo nɛ kah, ");
INSERT INTO ncr_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","nje bo gɛ̀ baaŋ kɛɛ gɛ fiɛɛ fì chefe yi blɛd chiɛɛ gɛ duunyi kune Jiso gɛ, no bo gɛ̀ baaŋ gwenyɛ gɛ muntele muboo gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Bo gɛ̀ daŋ mamasi bo bu kimbe ki Gɛnesalɛt le kwa, bo fasɛ ŋguh yi ŋgɛɛme yi joo le. ");
INSERT INTO ncr_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","No bo bu a ŋguh le, bamii mo bo kɛɛ lo kimimia lɛ le Jiso, ");
INSERT INTO ncr_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","bo tu bo lege bo gɛɛne bantɛ ba yo le bachii, bo bvuuse bamii ba binchɛŋ bo too bɛ bo a maŋko le mo faaŋ fɛ bo gɛ̀ yuge lɛ Jiso le fo. ");
INSERT INTO ncr_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","No Jiso gɛ̀ gɛɛne mo faaŋ kɛnɛ wu gɛɛne nyu ntɛ le, kɛnɛ a kilaantɛŋ le, kɛnɛ nchvuuŋ, bamii tu bo gɛɛde gɛh bamii ba binchɛŋ fɛ bamii gɛ̀ taashi fo. Jiso doo wu fede, bo tu bo lɛge lɛ wu chînɛ bo kûŋ gɛh nyu jwe wu nju ye le. Muh wuchii wù gɛ̀ kune, mo wu tɛmɛ. ");
INSERT INTO ncr_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Juu chimi Bafalashii bɛ bamii bamu ba gɛ̀ duunyi banchi ba Nyo ja Yɛlusalɛm bo to bo taashɛ mbebe Jiso le. ");
INSERT INTO ncr_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bo ja bo yɛŋ booŋ ba ŋgoo ba Jiso bamu jii mwɛɛ chiaaŋ yi yidɛ, fì le lɛ bo gɛ̀ baaŋ chiaaŋ chugɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Bafalashii bɛ Bajuu bachii gɛ̀ bii gɛh nyu kinche ki woŋ wu bachiji baboo ba fweele le, lɛ gɛ taŋlo muh ji fiɛɛ njɛ wu chugɛ chiaaŋ yɛɛŋyɛɛŋ no bo to bo chuge gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Gɛ taŋlo muh kwɛɛ tɛ fɛ waaŋ wu ji fiɛɛ njɛ bo chugɛ chiaaŋ bɛ bikaa biboo sɛŋ gɛ. Bo ka bo gee mwɛɛ mu a kinche ki woŋ le wesee, gɛh njɛ ki ba chuge muŋkoo mo bibɛɛŋ mo sháaŋ. ");
INSERT INTO ncr_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Bafalashii bɛ bamii ba duunyi banchi bayu mo bo biih Jiso le lɛ, “Le nje la wù booŋ buŋ ba ŋgoo bii gɛ kinche ki woŋ ki bachiji besa ba fweele le gɛ? Le nje la wù bo jii mwɛɛ bɛ chiaaŋ yì yiide?” ");
INSERT INTO ncr_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jiso chvuu bo le lɛ, “Yosaya wù muh wu ntuŋ wu Nyo gɛ̀ jɛme nchiɛɛŋ kune bɛŋ lɛ bɛŋ le bamii ba jɛme yeye, bɛŋ gee yeye. Bɛŋ gee gɛh nyu fiɛɛ fì wu gɛ̀ saŋ, Nyo duu lɛ, ‘Bamii banɛ ŋgvuune mɛ gɛh fɛmu fɛmu, muntele muboo nyu je yì ndefe le fɛ mɛne. ");
INSERT INTO ncr_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bo yuuse mɛ nyu achiji, nje bo jode mwɛɛ mù bamii kwaji, bo yɛyi lɛ le jɛ yaŋ.’ ");
INSERT INTO ncr_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Le gɛh tɛ no bɛŋ chinɛ banchi ba Nyo le, bɛŋ gɛɛde nyu ba gɛle bamii.” ");
INSERT INTO ncr_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jiso jɛmɛ bo le lɛ, “Bɛŋ kɛme je yì chuule ki bɛŋ fâŋ banchi ba Nyo, wu lɛ bɛŋ bîi nyu bena le. ");
INSERT INTO ncr_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Musɛ gɛ̀ jɛmɛ lɛ, ‘Ŋgvuuŋ chijo bɛ bwoo.’ Wu ka wu du tɛ lɛ, ‘Nɛ muh naŋ lo chiji kɛnɛ bwee, ba yuuyɛ lo mwɛdɛ.’ ");
INSERT INTO ncr_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Geenɛ, bɛŋ tu duu fiena lɛ, ‘Nɛ muh kɛme fiɛɛ fì taŋlo wu fih chiji kɛnɛ bwee yu, wu ja wu jɛmɛ chiji bɛ bwee le lɛ fiɛɛ fiyu le Kobaŋ’, fì le lɛ le wa fi Nyo, ");
INSERT INTO ncr_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","tu bɛŋ baaŋ ka bɛɛŋ gɛ lɛ wu jo fiɛɛ fiyu wu fi chiji kɛnɛ bwee yu gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Bɛŋ gee noo, bɛŋ gee jɛ yi Nyo tuu fiɛɛ fì achiji nje kinche kena ki woŋ kì bɛŋ yɛyi bamii yu. Mwɛɛ mumu ka nyume tɛ yu wesee njɛ munɛ mù bɛŋ gee.” ");
INSERT INTO ncr_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jiso ka wu tɛɛŋ bamii bo to, wu jɛmɛ bo le lɛ, “Bɛŋ bachii bɛŋ yêgɛ bɛŋ yû fiɛɛ fì njɛme, bɛŋ kɛɛ chuule. ");
INSERT INTO ncr_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Gɛ fiɛɛ nyu yu a kfuuŋ fì leese yi ye yi muh le fì yiisɛ wu gɛ, le fiɛɛ fì bude a wu shɛŋ fì taŋlo fi yiisɛ wu.  ");
INSERT INTO ncr_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Muh wù kɛme bintuŋ wu yu.” ");
INSERT INTO ncr_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jiso chinɛ bamii bayu le, wu lee yeh, booŋ be ba ŋgoo biih wu le kune ŋgaŋ wuyu. ");
INSERT INTO ncr_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Wu chvuu bo le lɛ, “Gɛ bɛŋ tɛ kee mwɛɛ gɛ? Gɛ bɛŋ kee lɛ fiɛɛ fichii fì muh leese a wu mu gɛ taŋlo fi yiisɛ wu gɛ? ");
INSERT INTO ncr_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Fi le noo, nje fi lese fi ya fi gɛɛŋ nyu fɛ fitele fie le gɛ, fi boh nyu a shɛŋ, fi jiɛnyɛ fi bu lo.” (No Jiso gɛ̀ jɛmɛ noo, fi mo fi nyu lɛ mwɛɛ munjile munchii yuude lo.) ");
INSERT INTO ncr_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Wu ka wu gɛɛŋ fwe wu jɛmɛ lɛ, “Le fiɛɛ fì bude yi muh le, le fi fì yiise muh, ");
INSERT INTO ncr_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","nje mwɛɛ mù mbefe mu muh gee jade nyu fɛ fitele fie le. Mwɛɛ njɛ baŋkwajɛ ba befe, ki muh jaŋ kinjaŋ, ki muh choŋ bvuchoŋ, ki muh yuuyɛ muh, ki muh jaŋ kwɛ muh kɛnɛ juma muh, ");
INSERT INTO ncr_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ki muh guumɛ mwɛɛ, ki muh gee bijo, ki muh lɛɛde kinlɛlɛ, ki muh gee nyiɛŋ, ki muh bɛɛne kindoŋ, ki muh chɛŋe bɛ maŋkuŋ ma bamii, ki muh chiaase ye mo ki muh yuunfe kiyuunfɛ. ");
INSERT INTO ncr_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mwɛɛ mù mbefe munɛ munchii jade nyu fɛ fitele fì muh le, fɛ mu yiise mwɛdɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jiso gɛ̀ ja fo, wu gɛɛŋ kimbe ki bilaantɛŋ bì Taya bɛ Sidoŋ le. No wu gɛnɛ yo, wu lee yeh yimi le wu goone gɛ lɛ muh kɛɛ lɛ wu le yo gɛ. Geenɛ, bamii kɛɛ gɛh lo. ");
INSERT INTO ncr_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kwɛse wumu gɛ̀ bee yo kiyo kì yiide nyu yi mwa ye wù kwɛse le. Kimimia no wu yu kune Jiso, wu mo wu to wu gwe bikaa bie le. ");
INSERT INTO ncr_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Kwɛse wuyu gɛ̀ bee muh wu Glek, gɛ wù gɛ̀ bee muh wu Bajuu gɛ. Ba gɛ̀ boyi wu Fonishia woŋ wù Silia le. No wu gwe noo, wu mo wu lɛgɛ Jiso lɛ wu bvusɛ nchɛndaa debele wuyu yi mwa ye le. ");
INSERT INTO ncr_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jiso chvuu wu le lɛ, “Chinɛ bo ya bo nyaŋɛ booŋ, nje gɛ fi joŋe ki ba jo ŋgu yi booŋ ba noŋ bvú le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kwɛse wuyu chvuu wu le lɛ, “Le nchiɛɛŋ chii. Geenɛ, sege booŋ jii mwɛɛ bvú to yi boonyi munchvuge mu gweeyi fɛkuu” ");
INSERT INTO ncr_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jiso mo wu jɛmɛ wu le lɛ, “Nje fiɛɛ fì wo chvuse finɛ, wo taŋlo wo gɛ̂ɛne fiuŋ, nchɛndaa debele wuyu le wu chinɛ wa mwa yo le.” ");
INSERT INTO ncr_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kwɛse wuyu mo wu ja wu tuu jiŋ fɛ yeh le, wu doo wu gɛɛŋ wu yɛŋ mwa gime fɛnta nchɛndaa debele wuyu nyu wu bu wa. ");
INSERT INTO ncr_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jiso ja kimbe kì Taya le, wu fe Sidoŋ wu ka wu fe kimbe ki Bilaantɛŋ bì Yuufe le, wu mo wu tu je fɛ Mamasi wù Galalee le. ");
INSERT INTO ncr_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bamii bamu gɛ̀ ja bo to bɛ muh mu, wù nyu kinchifɛ wu kee gɛ njɛmɛ gɛ. Bo lɛgɛ Jiso lɛ wu gɛɛ chiaaŋ yi ye ye le, wu fɛ wu. ");
INSERT INTO ncr_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jiso mo wu jo wu bɛ wu bu a kinchvu kɛɛ ntɛnɛɛ bo tu bo nyu lɛbolɛbo. Wu leesɛ nyi yi kwaaŋ a bintuŋ bi muh wuyu le, wu chuuyɛ nchwene wu kuŋ lɛmɛ chi muh wuyu le, ");
INSERT INTO ncr_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","wu bijɛ we, wu shooŋ, wu jɛmɛ wu le lɛ, “Ɛfata”, fì le lɛ, “Gwênyɛ!” ");
INSERT INTO ncr_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Bintuŋ bi muh wuyu mo bi gwenyɛ kimimia, lɛmɛ che yaafɛ, wu mo wu tu wu jɛme chuule. ");
INSERT INTO ncr_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jiso mo wu chiisɛ lo bamii le lɛ keefɛ bo gê bo sɛ̂ɛŋ muh le gɛ. Geenɛ, no wu gɛ̀ chiisɛ, fi ka fi tu fi nyu gɛh noo, bo feeji bo gɛɛne bɛ fi fwe fwe. ");
INSERT INTO ncr_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jwe mo wu yuŋ lo bamii baaŋ. Bo tu bo ghaade, bo duu lɛ, “Jiso kee ki wu gê mwɛɛ munchii chuule. Wu gee binchifɛ yuge mwɛɛ, binjumɛ jɛme.” ");
INSERT INTO ncr_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Gɛh aju ayu le, kinchvu ki bamii ka ki to ki taashɛ nɛ gɛmm. Bo gɛ̀ kɛme gɛ mwɛɛ munjile gɛ, Jiso tɛɛŋ booŋ be ba ŋgoo wu jɛmɛ bo le lɛ, ");
INSERT INTO ncr_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ŋkɛme yii fɛ kinchvu kinɛ le, nje bo le wa besa bo aju atade, fiɛɛ fì bo ji nyume gɛ yu gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nɛ nchinɛ lo bo tuu ala aboo le, bo gɛɛŋ bo gwe jɛŋ a je, no bamu ja jé yì ndefe le.” ");
INSERT INTO ncr_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Booŋ be ba ŋgoo chvuu lɛ, “Taŋlo muh jo faaŋ mwɛɛ munjile nchvuuŋ yanɛ ki wu nyâŋɛ kfuu chi banɛ bamii yu?” ");
INSERT INTO ncr_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Wu biih bo le lɛ, “Bɛŋ kɛme chefe yi blɛd yimiɛɛ?” Bo chvuu lɛ, “Le bvusooshwi.” ");
INSERT INTO ncr_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jiso mo wu du lɛ kinchvu ki bamii kiyu shii fɛkuu. Bo shiiyɛ, wu jo chefe yi blɛd yì bvusooshwi chiɛɛ, wu nya kiyone Nyo le, wu bweeyɛ, wu nya booŋ be ba ŋgoo le, bo gajɛ kinchvu kiyu le. ");
INSERT INTO ncr_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bo gɛ̀ kɛme tɛ bíɛŋ yì shige shige nɛ shige. Wu ka wu jo, wu nya kiyone Nyo le, wu jɛmɛ bo gajɛ bamii bayu le. ");
INSERT INTO ncr_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Muh wuchii ji wu fuu. Bo baanyɛ bimbɛge bì gɛ̀ shɛshɛ, bi yisɛ ŋkáa bvusooshwi. ");
INSERT INTO ncr_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bamii ba gɛ̀ ji gɛ̀ bee njɛ banchvuge banɛh. ");
INSERT INTO ncr_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Wu mo wu chinɛ bo le bo kwɛɛde. Wu lee lo a ŋguh le kimimia bɛ booŋ be ba ŋgoo mo bo ja bo gɛɛŋ kimbe kì Damanuta le. ");
INSERT INTO ncr_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bafalashii gɛ̀ ja bo to fɛ Jiso le, bo kɛ kintɛɛnyɛ bɛ wu, bo jɛme lɛ wu ge fiɛɛ fì duunyi bvuŋga bvu ja fɛwe. Bo gɛ̀ duu noo bo mone lo wu. ");
INSERT INTO ncr_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jiso shooŋ baaŋ, wu jɛmɛ lɛ, “Kiŋgogɛ kinɛ goone fiɛɛ fì duunyi bvuŋga bvu ja fɛwe ki ge la yu? Nsɛŋe bɛŋ nchiɛɛŋ lɛ gɛ kiŋgogɛ kinɛ nyu ki yɛŋ fiɛɛ le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Wu mo wu chinɛ bo le, wu kaasɛ wu lee a ŋguh le, wu tu wu gɛɛne wuŋ kwɛge. ");
INSERT INTO ncr_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jiso gɛ̀ gɛɛne booŋ be ba ŋgoo daayɛ ki bo jo blɛd, bo gɛ̀ kɛme gɛh nyu chefe yimimia a ŋguh le. ");
INSERT INTO ncr_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Wu tu wu teefe bo wu duu lɛ, “Bɛŋ yɛ̂ne, bɛŋ ka bɛŋ jôde kife yi kinshilɛ ki Bafalashii le mo ki Hɛlod.” ");
INSERT INTO ncr_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Booŋ be ba ŋgoo mo bo kɛ bo jɛme lɛbolɛbo kune fiɛɛ fiyu, bo duu lɛ, “Wu jɛme kinshilɛ kinɛ nɛ nje besabɛŋ baaŋ kɛmɛ gɛ blɛd gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jiso kɛɛ fiɛɛ fì bo jɛme kune fi, wu mo wu biih bo le lɛ, “Bɛŋ jɛme nyu kune blɛd wù bɛŋ baaŋ kɛme gɛ nje la? Gɛ bɛŋ yɛde mwɛɛ le kɛnɛ bɛŋ kee mwɛɛ gɛ? Le lɛ bvufee bwena baaŋ a gwenyɛ gɛ? ");
INSERT INTO ncr_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Bɛŋ kɛme ajii bɛŋ yɛde gɛ mwɛɛ le gɛ? Bɛŋ kɛme bintuŋ bɛŋ yuge gɛ mwɛɛ gɛ? Gɛ bɛŋ kwaji mwɛɛ gɛ? ");
INSERT INTO ncr_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Sege ŋgɛ̀ ŋgweeshɛ chefe yi blɛd yishɛŋ yì bamii chi ji banchvuge batɛŋ, bimbɛge bì bɛŋ chi banyɛ chi bee ŋkáa yimiɛɛ?” Bo chvuu lɛ, “Yuufe ncho yifiɛɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Wu ka wu biih, “Kune chefe yì bvusooshwi yì bamii be ji banchvuge banɛh, bimbɛge bì bɛŋ be banyɛ be bee ŋkáa yimiɛɛ?” Bo chvuu lɛ, “bvusooshwi.” ");
INSERT INTO ncr_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Wu mo wu biih bo le lɛ, “Gɛ bɛŋ kɛɛ wa mwɛɛ gɛ?” ");
INSERT INTO ncr_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jiso bɛ booŋ be ba ŋgoo gɛ̀ daŋ bo bu Bɛsada, bamii bamu to bɛ kinfeeŋ kimi fɛ wu le bo lɛgɛ lɛ wu kuŋ wu le, wu fɛ wu. ");
INSERT INTO ncr_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jiso jijɛ wu yi kibo le, bɛ wu bu ntɛ wuyu le. Wu chuuyɛ nchwene yi ajii a we le, wu gɛɛ chiaaŋ yi ye ye le wu mo wu biih wu le lɛ, “Wo yɛde fiɛɛ le?” ");
INSERT INTO ncr_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Kinfeeŋ kiyu chiaasɛ ajii we, ki bijɛ ki jɛmɛ lɛ, “N'yɛde bamii le jibejibe bo jiɛnyi nyu njɛ bite.” ");
INSERT INTO ncr_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jiso ka wu gɛɛ chiaaŋ yi ajii a muh wuyu le, wu bijɛ nɛ tuŋŋ, ajii a we mo wo yuu, wu tu wu yɛde mwɛɛ le munchii chuule. ");
INSERT INTO ncr_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jiso mo wu jɛmɛ wu le lɛ, “Wo gɛ̂ɛne fɛ wo kfuuŋ, wo doo wo gɛɛne keefɛ wo ka wo lêe ntɛ le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jiso bɛ booŋ be ba ŋgoo ja fo bo tu bo gɛɛne bantɛ ba kimbe kì Kasalia wu Filibi le. Bo doo bo gɛɛne, wu biih bo le lɛ, “Bamii duu lɛ nle yɛɛŋ?” ");
INSERT INTO ncr_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bo chvuu lɛ, “Bamii bamu duu lɛ wo le Joŋ Nlesɛajoo, bamu lɛ Alaja, bamu duu lɛ wo le muh wu ntuŋ wu Nyo wumu.” ");
INSERT INTO ncr_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Wu mo wu kaasɛ wu biih bo le lɛ, “Bɛŋ duu fiena lɛ nle yɛɛŋ?” Bita chvuu lɛ, “Wo le Mbvusɛ wù Nyo gɛ̀ ka.” ");
INSERT INTO ncr_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jiso mo wu chiisɛ lo bo le lɛ keefɛ bo môŋ bo sɛ̂ɛŋ finɛ fiɛɛ muh le kune wu gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Wu mo wu kɛ wu yɛyi booŋ be ba ŋgoo wu jɛme kune kikwɛɛ ke lɛ, “Muh wù jee che le Mwamuh kɛme ki wu yɛ̂ŋ baŋgɛ ba duude, bamii ba sage woŋ bɛ bachiji kintanyɛ ba baaŋ baaŋ mo bamii ba duunyi banchi ba Nyo faŋ wu. Bo mo bo yuuyɛ wu, aju fe atade wu kaasɛ wu bu yi kwe le.” ");
INSERT INTO ncr_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Wu jɛme mwɛɛ munɛ bo le nɛ waaŋ. Bita mo wu jo wu bɛ wu kɛŋsɛ yo, wu mo wu kɛ wu wame wu yi fiɛɛ fiyu le. ");
INSERT INTO ncr_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jiso kaasɛ ye, wu bijɛ booŋ be ba ŋgoo, wu waŋ Bita wu jɛmɛ lɛ, “Jâ a mɛ jiŋ Sataŋ! Gɛ wo lɛme yi kimbe ki Nyo le gɛ. Wo lɛme nyu yi ki muh wu wuŋ le.” ");
INSERT INTO ncr_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Wu mo wu tɛɛŋ kinchvu ki bamii bɛ booŋ be ba ŋgoo lɛ, wu jɛmɛ bo le lɛ, “Muh nɛ goone ki wu bîi mɛne, tu wù kɛme ki wu fâŋ kikwɛɛ ke, wu tuu kintaaŋ ke wu bii mɛne. ");
INSERT INTO ncr_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Bɛŋ kêe lɛ muh wu baji kinche ke lɛ keefɛ wu lɛsɛ ki gɛ, lé wu gê wu lɛsɛ lo ki. Geenɛ, Muh wu lɛsɛ kinche ke nje mɛ mo nje saaka wù joŋe le, tu wu baji lo kinche kiyu. ");
INSERT INTO ncr_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ba banyi woŋ kfunɛ wuchii ba nya muh ji, wu lɛsɛ kinche ke, maajɛ wuyu nyu la? ");
INSERT INTO ncr_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Fiɛɛ fì taŋlo muh suuŋ kiyo ke yu le la? ");
INSERT INTO ncr_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Bɛŋ kêe lɛ nɛ muh kɛme bvuya ki wu bîi mɛne mo jɛ yaŋ le, antɛnɛɛ a kiŋgogɛ ki ghɛge mwɛɛ kinɛ ki le njɛ muh wu chinɛ jwɛɛŋ le kɛnɛ kwɛɛ le wu tu wu jaŋe kinjaŋ, wu kêe lɛ muh wu jee che le Mwamuh, bvuya le bvu koo tɛ wu bɛ mwɛdɛ sege wu kaasɛ wu to antɛnɛɛ a bvukugɛ bvu Chiji bɛ banchɛndaa ba Nyo ba yuude.” ");
INSERT INTO ncr_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jiso ka wu jɛmɛ bo le lɛ, “Nsɛŋe bɛŋ nchiɛɛŋ lɛ, bamii bamu lɛme fɛnɛ bo nyu gɛ bo to bo yu wuŋ wu kwe njɛ bo yɛŋ bvunfoŋ bvu Nyo to bɛ bvuŋga bwe sɛŋ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Aju gɛ̀ fe bvusoo, Jiso jo Bita bɛ Jɛm mo Joŋ bɛ bo bɛɛŋ yi mbegɛ wumu le wù ndefe fɛwe le, bo nyu fo gɛh bo bo. Bo ja bo yɛŋ nfiɛɛnɛ ye kusɛ a bo jii, ");
INSERT INTO ncr_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","njú ye baaŋ yi lale yi fede no taŋlo mu chugɛ fɛkuu fɛnɛ yi baaŋ. ");
INSERT INTO ncr_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Bo gɛ̀ ja bo yɛŋ Alaja bɛ Musɛ bo bunɛ fɛ bo le, bo jɛme bɛ Jiso. ");
INSERT INTO ncr_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Bita saa, wu jɛmɛ Jiso le lɛ, “Muh n'yɛyɛ wù baaŋ, fi joŋe no bee le fɛnɛ. Chinɛ bee jooŋ chúŋ yishɛde, yimi yo, yimi yi Musɛ, yimi yi Alaja.” ");
INSERT INTO ncr_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Wu gɛ̀ jɛme noo nje njaŋ gɛ̀ koo bo baaŋ wu gɛ ka wu kɛɛ fiɛɛ fì wu jɛme gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Gɛh no wu jɛme noo, kimbɛ ja ki to ki baŋɛ bo, jɛ jɛmɛ a kimbɛ kiyu le lɛ, “Wunɛ le Mwa yaŋ, wu le fitele fiaŋ. Bɛŋ yûge nyu wu le.” ");
INSERT INTO ncr_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Bo ja bo jaŋe bo doo bo bijɛ bo gɛ ka bo yɛŋ bamii baa le gɛ, bo yɛŋ gɛh nyu Jiso le maa. ");
INSERT INTO ncr_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bo gɛ̀ ja yi mbegɛ wɛɛ le bo doo bo boge, Jiso chiisɛ bo le lɛ keefɛ bo sɛ̂ɛŋ fiɛɛ fì bo be yɛŋ le njɛ muh wù jee che le Mwamuh bu wa yi kwe le sɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Bo yu noo bo gɛɛ a bo shɛŋ, geenɛ bo tu bo ghaade gɛh lɛbolɛbo laa mbu wu yi kwe le wunɛ le nyu la lɛ. ");
INSERT INTO ncr_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bo mo bo ja bo biih Jiso le lɛ, “Le nje la wù bamii ba duunyi banchi duu lɛ Alaja kɛme ki wu yâ wu to fɛ Mbvusɛ wù Nyo gɛ̀ ka ge wu to?” ");
INSERT INTO ncr_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jiso chvuu bo le lɛ, “Le nchiɛɛŋ lɛ Alaja kɛme ki wu yâ wu to wu kɛnyɛ mwɛɛ munchii mu tu mu nyume gɛh no mu gɛ̀ bee. Geenɛ, le nje la wù ba le ba saŋ lɛ muh wù jee che le Mwamuh kɛme ki wu gê wu yɛŋ baŋgɛ ba duude, bamii faŋ wu? ");
INSERT INTO ncr_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nsɛŋe bɛŋ le lɛ Alaja le wu to wa, bo ge fiɛɛ fì bo koŋe bɛ wu. Nyume gɛh no ba gɛ̀ saŋ kune wu.” ");
INSERT INTO ncr_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jiso bɛ booŋ be ba ŋgoo gɛ̀ boh bo to bo fɛsɛ fɛ booŋ be ba ŋgoo bamu gɛ̀ bee fo, wu yɛŋ kinchvu ki bamii kì baaŋ ki kɛnɛ ki baŋ bo, bamii bamu ba gɛ̀ duunyi banchi ba Nyo bo tɛɛnyi kintɛɛnyɛ bɛ bo. ");
INSERT INTO ncr_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kimimia no kinchvu kichii yɛŋ Jiso le, bo njaŋɛ baaŋ, bo legɛ bo gɛɛŋ bo yɛsɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Wu biih bo le lɛ, “Bɛŋ tɛɛnyi kintɛɛnyɛ kune la?” ");
INSERT INTO ncr_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Muh chvuu wu le a kinchvu ntɛnɛɛ lɛ, “Muh wu N'yɛyɛ, mbe nto bɛ mwa yaŋ fɛ wo le nje kiyo kimi le ye ye le, kì gee muh tu kinchifɛ. ");
INSERT INTO ncr_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kiyo kiyu to kichufɛ wu ki noŋ fɛkuu, bifuu tu bi bude a wu mu wu ŋgeji bige, wu jade wu tɛɛnyi. Njɛmɛ lɛ booŋ buŋ ba ŋgoo bvusɛ kiyo kiyu, bo moŋ sɛŋ.” ");
INSERT INTO ncr_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jiso yu noo, wu jɛmɛ lɛ, “O oo! Kiŋgogɛ kì baaŋ lee gɛ fitele yi Nyo le kinɛ gɛ! Nlé nyû bɛ bɛŋ ŋgɛ̂ɛŋ mbû nɛɛ? Nlé ŋkâaŋ shɛ́ŋ bɛ bɛŋ ŋgɛ̂ɛŋ mbû nɛɛ? Bɛŋ to bɛ mwa wuyu fɛnɛ bɛŋ nya mɛne.” ");
INSERT INTO ncr_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bo mo bo jo mwa wuyu bo tu bo too bɛ wu fɛ Jiso le. No kiyo kiyu yɛŋ Jiso le, ki mo ki chûfɛ mwa wuyu kimimia wu gwe fɛkuu wu tu wu biiŋse fo, bifuu bude amu. ");
INSERT INTO ncr_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jiso biih chiji mwa wuyu le lɛ, “Fiɛɛ finɛ gɛ̀ kɛ sege la?” wu chvuu lɛ, “Fi gɛ̀ kɛ wu, wu baaŋ shige. ");
INSERT INTO ncr_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kiyo kiyu le ki noŋ wa wù kiŋgane le kiŋgane le fɛ ŋgu le mo a joo le ki goone ki ki yuuyɛ lo wu. Nɛ wo taŋlo wo ge fiɛɛ, kii wo, wo koo gɛh lo yii fɛ bee le, wo fih bee.” ");
INSERT INTO ncr_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jiso biih wu le lɛ, “Lɛ laa ntaŋlo ŋge fiɛɛ la? Nyo taŋlo wu ge fiɛɛ fichii fɛ muh wù le wu leesɛ fitele yi ye ye le.” ");
INSERT INTO ncr_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kimimia chiji mwa wuyu mo wu jaŋ fɛwɛɛwe lɛ, “Nle nleesɛ fitele yi Nyo le. Gêe lɛ ŋka nleesɛ nfe lo noo.” ");
INSERT INTO ncr_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jiso doo wu yɛŋ kinchvu ki bamii le ki lege ki too ki taashi fɛ wù gɛ̀ bee fo, wu waŋ kiyo kì yiide kiyu wu jɛmɛ lɛ, “Wo, kiyo kì yiide kinɛ kì gee mwa wunɛ jɛme gɛ, wu yuge gɛ tɛ mwɛɛ gɛ, njɛme wo le, bû yi mwa wunɛ le, wo gɛɛŋ lo! Keefɛ wo ka wo lêe ye ye le gɛ!” ");
INSERT INTO ncr_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kiyo kiyu jaŋ fɛwɛɛwe, ki ka kichufɛ mwa wuyu, ki noŋ wu a je yì befe le, ki mo ki bû ye ye le. Wu tu wu gime fɛkuu njɛ kiŋkwe ki muh. Bamii ba duude yɛŋ noo, bo tu bo duu lɛ, “Wu le wu kwe wa.” ");
INSERT INTO ncr_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jiso jijɛ wu yi kibo le wu chiaasɛ wu, wu lɛɛŋ we. ");
INSERT INTO ncr_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jiso bɛ booŋ be ba ŋgoo gɛ̀ gɛɛŋ bo lee yeh, bo biih wu le ajiŋ ajiŋ lɛ, “Le nje la wù bee be moŋ sɛŋ ki be bvusɛ nchɛndaa wu debele wɛɛ?” ");
INSERT INTO ncr_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Wu chvuu bo le lɛ, “Fiɛɛ fì taŋlo fi bvusɛ kfuu chi wunɛ nchɛndaa le gɛh buunɛ maa. Gɛ taŋlo fiɛɛ fimi yeye bvusɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Bo ja fo bo fe je yi Galalee le, Jiso goone gɛ lɛ muh kɛɛ gɛ, ");
INSERT INTO ncr_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","nje wu gɛ̀ jiɛnyi wu yɛyi booŋ be ba ŋgoo. Wu gɛ̀ jɛmɛ bo le lɛ, “Muh wù jee che le Mwamuh le ba nyu ba nya wu chiaaŋ yi bamii le ba yuuyɛ wu. Nɛ bo doo bo yuuyɛ wu noo, ge aju atade, wu bu yi kwe le.” ");
INSERT INTO ncr_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","No wu jɛmɛ noo, bo gɛ̀ baaŋ kɛɛ gɛ fiɛɛ fì wu jɛme gɛ, geenɛ, bo tu bo faane ki bo biih. ");
INSERT INTO ncr_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bo gɛɛŋ bo bu kafanahom, bo gɛ̀ doo bo lee yeh, Jiso biih bo le lɛ, “Bɛŋ be tɛɛnyi kintɛɛnyɛ a je kune la?” ");
INSERT INTO ncr_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Bo mɛ gɛh jwe wuchile, nje bo gɛ̀ jiɛnyi a je bo tɛɛnyi kintɛɛnyɛ lɛbolɛbo lɛ, laa muh wù baaŋ le yɛɛŋ la. ");
INSERT INTO ncr_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jiso shii fɛkuu, wu tɛɛŋ bo ba yuufe ncho bafɛɛ wu jɛmɛ bo le lɛ, “Nɛ muh goone ki wu nyûme muh wù fwe, tu wu kɛme ki wu jô kikwɛɛ ke lɛ wu le kijimɛ mo muh wù lɛne fɛ bamii le bachii.” ");
INSERT INTO ncr_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","No wu jɛmɛ noo, wu mo wu jo mwa wù shige wu leesɛ a bo antɛnɛɛ, wu kaasɛ wu jo wù kɛme abo, wu jɛmɛ bo le lɛ, ");
INSERT INTO ncr_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Nɛ muh fi mwa njɛ wunɛ a jee chaŋ le, tu wu fi nyume mɛ. Muh fii mɛ, tu gɛ wu fii nyume mɛ gɛ, tu wu fii tɛ nyu muh wu tuŋ mɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Joŋ jɛmɛ wu le lɛ, “Muh n'yɛyɛ, bee chi be yɛŋ muh mu le wu tɛŋe jee chuŋ fɛ wu bvuuse banchɛndaa ba debele yi bamii le, be faŋ, nje gɛ wu nyu muh ŋgoo yese besabɛŋ le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Geenɛ Jiso chvuu bo le lɛ, “Keefɛ bɛŋ chîde kfuu chi wɛɛ muh gɛ. Bɛŋ kêe lɛ muh gee kiŋgha ki fiɛɛ wu tɛŋe jee chaŋ, tu gɛ taŋlo wu ka wu jɛme fiɛɛ fì befe kune mɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nɛ muh baaŋ baa gɛ̀ jiŋ besabɛŋ le gɛ, tu wu toone besabɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nsɛŋe bɛŋ nchiɛɛŋ lɛ, muh nya gɛh nyu fiŋkoo fi joo bɛŋ le nje ba tɛŋe bɛŋ lɛ bamii ba Kletu, tu gɛ wu nyu wu to wu fu maajɛ we gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Kɛnɛ nyume yɛɛŋ wù ge booŋ ba shige banɛ bò lese fitele ye yaŋ le ki bo ge kimbefɛ, fi joŋe fɛ wu wɛɛ muh le lɛ ba shɛŋshɛ kibwee ki jɛnɛ a kindoŋ ke le, ba tooŋsɛ wu a joo yì baaŋ le. ");
INSERT INTO ncr_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Fi ka nyume lɛ, kibo kuŋ gêe wo gee kimbefɛ, wo suunɛ kibo kiyu. Fi joŋe lɛ wo lee kinche kì kage gɛ le bɛ kibo kiŋkfunɛ, fede ki wo kɛ̂me chiaaŋ yichii wo gɛɛŋ ŋgu wù baaŋ le wù fiee segechii wu jime gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Nɛ kikaa kuŋ gêe wo gee kimbefɛ, wo suunɛ kikaa kiyu. Fi joŋe lɛ wo lee kinche kì kage gɛ le wo nyu ntɛŋlaase, fede ki wo kɛ̂me bikaa bichii ba noŋ wo ŋgu wù baaŋ le. ");
INSERT INTO ncr_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nɛ jise chuŋ gêe wo gee kimbefɛ, wo bvusɛ jise chiyu wo noŋ. Fi joŋe lɛ wo lee bvunfoŋ bvu Nyo le bɛ jise chimimia, fede ki wo kɛ̂me ajii achii, ba noŋ wo ŋgu wù baaŋ le. ");
INSERT INTO ncr_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kijusɛ kinɛ le fɛ baŋgvule jii bamii fo bo kwee gɛ, ŋgu jime gɛ fo gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Bɛŋ kêe lɛ ŋgu le wu kuŋ muh wuchii le gɛh njɛ no ba to ba yefɛ fiɛɛ bɛ ŋka. ");
INSERT INTO ncr_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ŋka le fiɛɛ fì joŋe, geenɛ sege yi chii, wo ge nɛɛ fɛ yi ka yi kaasɛ yi jɛŋɛ? Bɛŋ nyûme njɛ ŋka yì jɛŋɛ, muh bɛ muh nyûme yi nyiɛgee le.” ");
INSERT INTO ncr_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jiso ja yo, wu gɛɛŋ kimbe ki woŋ kì Judia le, wu daŋ Joo yì Jodaŋ wu gɛɛŋ wuŋ kwege. Binchvu bi bamii ka bi taashi bi too fɛ wu le, wu tu wu yɛyi bo gɛh no wu gɛ̀ to wu yɛyi. ");
INSERT INTO ncr_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bafalashii gɛ̀ ja bo to fɛ wu le ki bo moŋ wu, bo mo bo biih wu le lɛ, “Nchi le wu bɛɛŋ lɛ taŋlo muh kuŋ bɛ kwɛɛ?” ");
INSERT INTO ncr_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jiso kaasɛ wu biih tɛ bo le lɛ, “Musɛ gɛ̀ nya nchi lɛ bɛŋ gêe nɛɛ?” ");
INSERT INTO ncr_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bo chvuu lɛ, “Musɛ gɛ̀ bee wu chinɛ lɛ taŋlo muh kuŋ bɛ kwɛɛ. Wu nɛ kuŋe bɛ wu, wu saŋ ŋwa wù duunyi lɛ wu le wu kuŋ wa wu, wu nya wu le.” ");
INSERT INTO ncr_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jiso chvuu bo le lɛ, “Gɛ̀ bee nje bintuŋ biɛna bì tɛmɛ wù Musɛ gɛ̀ saŋ nchi wunɛ. ");
INSERT INTO ncr_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Geenɛ, gɛ̀ bee fɛŋkɛɛ sege Nyo gɛ̀ fɛde mwɛɛ, wu fɛ jwɛŋsɛ bɛ kwɛse. No wu fɛ noo wu jɛmɛ lɛ, ");
INSERT INTO ncr_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Le nje finɛ fiɛɛ fì jwɛŋsɛ lé wu gê wu chinɛ chiji bɛ bwee le wu taashɛ bɛ kwɛɛ, ");
INSERT INTO ncr_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","bo bafɛɛ mo bo tu muh wu mumwaa.’ Noo, gɛ bo baaŋ bamii bafɛɛ gɛ, bo le wa muh wu mumwaa. ");
INSERT INTO ncr_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Fi mo fì nyu lɛ, fiɛɛ fì Nyo le wu taashɛ wa, keefɛ muh moŋ ki wu gâsɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jiso bɛ booŋ be ba ŋgoo gɛ̀ doo bo nyu yeh, bo ka bo biih wu le kune fiɛɛ fiyu. ");
INSERT INTO ncr_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Wu chvuu bo le lɛ, “Mo yɛɛŋ wù kuŋ bɛ kwɛɛ wu jo wumu, le wu ge kimbefɛ gɛh njɛ ki wu jâŋ kwɛse wumu. ");
INSERT INTO ncr_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nɛ kwɛse bu a jwɛŋsɛ le, wu gɛɛŋ a jwɛŋsɛ wumu le, tu wu le wu ge kimbefɛ fɛ jwɛŋsɛ le ki wu gîiŋ bɛ jwɛŋsɛ wumu.” ");
INSERT INTO ncr_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bamii ja bo too bɛ booŋ fɛ Jiso le lɛ wu kuŋ bo le, booŋ be ba ŋgoo tu bo wame lo bo. ");
INSERT INTO ncr_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jiso doo wu yɛŋ noo, shɛ́ŋ toonyɛ wu, wu jɛmɛ bo le lɛ, “Bɛŋ chînɛ booŋ bayu too fɛ mɛne, fɛ bɛŋ jêese bo gɛ, nje bvunfoŋ bvu Nyo le nyu fɛ bamii ba le njɛ booŋ banɛ le. ");
INSERT INTO ncr_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nsɛŋe bɛŋ nchiɛɛŋ lɛ muh wù baaŋ fi gɛ bvunfoŋ bvu Nyo njɛ mwa wù shige gɛ, tu gɛ wu lee bvunfoŋ bvuyu le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","No wu jɛmɛ noo, wu mo wu jode bo wu tuude, wu gɛɛde chiaaŋ yi bo le, wu nooŋ kimbonɛ yi bo le. ");
INSERT INTO ncr_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jiso ja lɛ wu gɛɛne, muh mu legɛ wu to wu tuŋ anyuu a wu jii wu biih wu le lɛ, “Muh wù N'yɛyɛ, wo le muh wù joŋe, fiɛɛ fì ŋkɛme ki ŋge fɛ ŋkɛme kinche kì kage gɛ le la?” ");
INSERT INTO ncr_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jiso biih wu le lɛ, “Wo tɛŋe mɛ lɛ muh wù joŋe nje la? Gɛ muh nyu yu wù joŋe gɛ. Mɛ gɛh Nyo maa wù joŋe. ");
INSERT INTO ncr_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Gɛ wo kee banchi ba duu lɛ, ‘Keefɛ wo yûuyɛ muh gɛ, keefɛ wo jâŋ kwɛ muh gɛ, keefɛ wo chôŋ bvuchoŋ gɛ, keefɛ wo bɛ̂ɛ jiŋ yi nsa wu chimbiaŋ gɛ, keefɛ wo fîge kinfi gɛ, bɛ lɛ wo ŋgvûune chijo bɛ bwoo gɛ?’” ");
INSERT INTO ncr_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Muh wuyu chvuu Jiso le lɛ, “Muh wu N'yɛyɛ, banchi banɛ bachii le ŋgɛ̀ ŋkɛ wa ŋgɛɛde mbaaŋ chumu.” ");
INSERT INTO ncr_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jiso bijɛ wu nɛ tuŋŋ, wu koŋ wu, wu mo wu jɛmɛ wu le lɛ, “Tu fiɛɛ le fi shɛɛ fimimia fì wo baaŋ wo ge. Gɛ̂nɛ wo gêsɛ mwɛɛ mwuŋ munchii mù wo kɛme, wo gâ bige biyu bamii ba fuude le, wo mo wo ge wo kɛme nchvu nyu yi woŋ wù fɛwe. Nɛ wo doo wo ge noo, wo mo wo kâasɛ wo tô wo bîi mɛne.” ");
INSERT INTO ncr_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","No Jiso jɛmɛ noo, muh wuyu yu bvushi chvuu lo wu, wu kaasɛ ye wu tu wu gɛɛne wù nyu lo yii yii, nje wu gɛ̀ kɛme kwa baaŋ. ");
INSERT INTO ncr_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jiso ja wu kaasɛ ye wu bijɛ booŋ be ba ŋgoo nɛɛ, wu jɛmɛ bo le lɛ, “Fi lé fi gê fi tɛɛme baaŋ fɛ bamii ba kwa le, ki bo lee yi bvunfoŋ bvu Nyo le.” ");
INSERT INTO ncr_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Njɛmɛ wuyu fuuŋsɛ booŋ be ba ŋgoo. Jiso ka wu jɛmɛ bo le lɛ, “Booŋ baŋ, fi tɛɛme baaŋ fɛ muh le ki wu lêe yi bvunfoŋ bvu Nyo le. ");
INSERT INTO ncr_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Fi le chige fɛ nyambala le ki yi lêe a jise chi nsala le fede fɛ muh wu kwa le ki wu lêe yi bvunfoŋ bvu Nyo le.” ");
INSERT INTO ncr_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Bo yu noo fi gha bo baaŋ, bo tu bo maŋe lɛ, “Nɛ finɛ le noo, yu to bonɛ yɛɛŋ?” ");
INSERT INTO ncr_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jiso kaasɛ wu bijɛ bo nɛɛ, wu jɛmɛ lɛ, “Finɛ fiɛɛ taŋlo fi gha muh wu wuŋ, geenɛ gɛ taŋlo fi gha Nyo gɛ, nje Nyo taŋlo wu ge fiɛɛ fichii.” ");
INSERT INTO ncr_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Bita mo wu ja wu jɛmɛ Jiso le lɛ, “Bîjɛ yɛ̂ŋ, bee le be chinɛ wa fiɛɛ fichii le bee tu be bii wo le.” ");
INSERT INTO ncr_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jiso chvuu wu le lɛ, “Nsɛŋe wo nchiɛɛŋ lɛ, gɛ muh nyu yu wu le wu chinɛ yeh ye le, kɛnɛ booŋ ba bwee le, kɛnɛ jɛ́me ye le, kɛnɛ bwee le, kɛnɛ chiji le, kɛnɛ booŋ le, kɛnɛ ŋɛɛ le, wu chine nje mɛ bɛ saaka wù joŋe wu Nyo, ");
INSERT INTO ncr_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","wù lé wu gê wù nyu njɛ wù kɛme yéh mo booŋ ba bwee, mo jɛ́me, mo babwee, mo booŋ, mo ŋɛɛ yi kinche ki mɛɛse le kiŋgane gwii gɛ. Bamii lé bo gê bo boone tɛ bikaa a wu jiŋ, ge doo nyume kife ki kinche kì too le, wù kɛme kinche kì kage gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Geenɛ, bamii ba duude ba le fwe mɛɛse le bo tu ba ajiŋ, ba duude ba le ajiŋ mɛɛse le bo tu ba fwe.” ");
INSERT INTO ncr_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jiso bɛ booŋ be ba ŋgoo gɛ̀ ja bo jo je, bo bɛɛne Yɛlusalɛm wu saa fwe. Booŋ be ba ŋgoo kɛme lo ŋgha. Bamii ba gɛ̀ bii tɛ tu bo kɛme nfaaŋ. Jiso ka wu jo booŋ be ba ŋgoo ba yuufe ncho bafɛɛ bɛ bo kɛŋsɛ yo wu tu wu sɛŋe bo fiɛɛ fì lé fi gê fi kooshɛ bɛ wu. ");
INSERT INTO ncr_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Wu jɛme bo le lɛ, “Bɛŋ yêgɛ bɛŋ yû, bee bɛɛne wa bee gɛɛne Yɛlusalɛm, ba lé ba gɛ̂ɛŋ ba nya muh wù jee che le Mwamuh chiaaŋ yi bachiji kintanyɛ ba baaŋ baaŋ le mo bamii ba duunyi banchi ba Nyo, ba sa wu ba suunɛ lɛ ba yuuyɛ wu, ba mo ba nya wu chiaaŋ yi bituŋ le, ");
INSERT INTO ncr_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ba chwɛɛse wu, ba chuuyi wu bɛ nchwene ye ye le, ba taane wu bɛ munte, ba yuuyɛ wu, ge doo nyume aju atade, wu bu yi kwe le.” ");
INSERT INTO ncr_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jɛm bɛ Joŋ ba gɛ̀ bee booŋ ba Jɛbɛdi ja bo kɛŋsɛ bo to a Jiso fwe bo jɛmɛ wu le lɛ, “Muh wu N'yɛyɛ, fiɛɛ le yu fì bee goone lɛ wo ge fɛ bee le.” ");
INSERT INTO ncr_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Wu biih bo le lɛ, “Bɛŋ goone lɛ ŋge la fɛ bɛŋ le?” ");
INSERT INTO ncr_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bo chvuu lɛ, “Bee goone lɛ sege wo le yi kala wu bvukugɛ bwuŋ le, bee shii yi binta bì baaŋ baaŋ le, muh mu a kibo kuŋ kinchiɛɛŋ le, wumu a kibo kiŋkoŋo le.” ");
INSERT INTO ncr_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jiso chvuu bo le lɛ, “Gɛ bɛŋ kee fiɛɛ fì bɛŋ biide gɛ. Taŋlo bɛŋ mu fiŋkoo fi ŋgɛ fì nlé ŋgê mmû, kɛnɛ bɛŋ lêe kfuu chi ŋgɛ wù baaŋ wù nlé ŋgê nlee wu le?” ");
INSERT INTO ncr_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bo chvuu wu le lɛ, “Bee taŋlo be ge.” Jiso jɛmɛ bo le lɛ, “Bɛŋ taŋlo bɛŋ mu fiŋkoo fi ŋgɛ fì nlé ŋgê mu, bɛŋ lêe tɛ kfuu chi ŋgɛ wù baaŋ wù nlé ŋgê nlee le, ");
INSERT INTO ncr_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","geenɛ ki bɛŋ shîi a kibo kaŋ kinchiɛɛŋ le kɛnɛ kiŋkoŋo le gɛ nyume kijusɛ kaŋ ki nya muh le gɛ. Manjuu mayu le fɛ bamii ba ba le ba seesɛ wa fɛ bo le.” ");
INSERT INTO ncr_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kimbɛge ki booŋ ba ŋgoo ba Jiso ba yuufe doo bo yu kune fiɛɛ fiyu bo tu bo toonyi shɛ́ŋ bɛ Jɛm mo Joŋ. ");
INSERT INTO ncr_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jiso tɛɛŋ bo bachii bo to, wu jɛmɛ bo le lɛ, “Gɛ bɛŋ kee lɛ bamii ba sage bituŋ to bo shiide lo yi bamii baboo le, bamii ba baaŋ baaŋ baboo duunyi bvuŋga bvuboo a bo we gɛ? ");
INSERT INTO ncr_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Gɛ fifiɛɛ fiɛɛ kɛme ki fi nyume a bɛŋ ntɛnɛɛ gɛ. Muh wù goone ki wu nyûme muh wù baaŋ a bɛŋ ntɛnɛɛ kɛme ki wu nyûme muh wù lɛne lo bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Muh nɛ goone ki wu nyûme muh wù fwe a bɛŋ ntɛnɛɛ, tu wù kɛme ki wù nyu nfwa wù muh wuchii. ");
INSERT INTO ncr_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Bɛŋ kêe lɛ gɛ muh wù jee che le Mwamuh gɛ̀ to lɛ bamii lɛne lo wu le gɛ. Wu gɛ̀ to ki wu lɛ̂ŋ lo bamii le, wu nya kinche ke ki wu sûuŋ muh wù duude chiaaŋ yi kwe le.” ");
INSERT INTO ncr_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Bo jiɛnyɛ bo to bo bu ntɛ wu Jɛliku le. Jiso gɛ̀ doo wu jade yo bɛ booŋ be ba ŋgoo mo kinchvu ki bamii kì baaŋ, kinfeeŋ kimi shii jwe wu je le ki lɛge mwɛɛ jee che nyu lɛ Batimayu, wù mwa Timayu. ");
INSERT INTO ncr_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Wu doo wu yu lɛ le Jiso wu Nasalɛ, wu mo wu kɛ wu tu wanɛ fɛwɛɛwe lɛ, “Jiso, Mwa Nfoŋ Dabi, koo yii fɛ mɛne.” ");
INSERT INTO ncr_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bamii ba duude tu bo wanɛ bo duu lɛ wu baŋ lo. Geenɛ wu ka wu mɛsɛ wu waŋ lo fɛwɛɛwe lɛ, “Mwa Nfoŋ Dabi, koo yii fɛ mɛne.” ");
INSERT INTO ncr_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jiso lɛɛŋ, wu jɛmɛ lɛ bo tɛɛŋ wu. Bo mo bo tɛɛŋ kinfeeŋ kiyu bo jɛmɛ lɛ, “Wo le wo kɛme kishi kì joŋe, ja we, wu tɛŋe wo.” ");
INSERT INTO ncr_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kinfeeŋ kiyu mo ki noŋ nju ye fɛkuu, ki selɛ we ki gɛɛŋ fɛ Jiso le. ");
INSERT INTO ncr_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jiso biih ki le lɛ, “Wo goone lɛ ŋge la fɛ wo le?” Kinfeeŋ kiyu chvuu lɛ, “Muh wu N'yɛyɛ, ŋkoŋe kì n'yɛne mwɛɛ le.” ");
INSERT INTO ncr_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jiso mo wu jɛmɛ wu le lɛ, “Wo gɛɛne fiuŋ. Fitele fì wo leese yi ye yaŋ le, le fi ge wa ajii awo gwenyɛ.” Kimimia noo ajii awe mo a yuu wu tu wu yɛne mwɛɛ le, wu tu wu bii Jiso le a wu gɛ̀ gɛɛne yo. ");
INSERT INTO ncr_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jiso bɛ booŋ be ba ŋgoo jiɛnyɛ bo gɛ̀ doo bo fɛɛse Yɛlusalɛm, mbebe yi ntɛ wu Bɛfash bɛ wu Bɛtani le, bo nyume mbebe yi Mbegɛ wu Bite bi Olif le, wu baa booŋ be ba ŋgoo bafɛɛ wu tuŋ, ");
INSERT INTO ncr_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","wu jɛmɛ bo le lɛ, “Bɛŋ gɛ̂ɛŋ ntɛ wù fwe wege le. Bɛŋ lé bɛŋ lêese yo nɛ kimimia, bɛŋ yɛŋ mwa jaki le ba shuudɛ, muh baaŋ yu a bɛɛŋ gɛ, bɛŋ fâanyɛ bɛŋ tô bɛ wu. ");
INSERT INTO ncr_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nɛ muh le wu biih bɛŋ le laa bɛŋ faanyi nje la lɛ, bɛŋ chvuu lɛ chiji kikwɛɛ goone lo, wu lé wu kâasɛ wu chvuu jiŋ gɛh mɛɛ mɛɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bo mo bo ja bo gɛɛŋ bo yɛŋ mwa jaki wuyu le ba shuudɛ a yeh yimi nfwɛɛŋ mbebe yi je le. Bo mo bo faanyɛ. ");
INSERT INTO ncr_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Bo doo bo faanyi bamii bamu ba gɛ̀ lɛme fo biih bo le lɛ, “Bɛŋ faanyi mwa jaki wɛɛ nje la?” ");
INSERT INTO ncr_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bo mo bo sɛɛŋ bo fiɛɛ fì Jiso be jɛmɛ. Bo chinɛ bo gɛɛne bɛ wu. ");
INSERT INTO ncr_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bo to bɛ wu fɛ Jiso le, bo dɛŋ njú yiboo yi nyaŋ yiyu le, Jiso mo wu bɛɛŋ yu. ");
INSERT INTO ncr_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bamii ba duude tu bo dɛŋe njú a je, bamu shwage chɛ́ yi bite nchvuuŋ, bo dɛŋe tɛ a je. ");
INSERT INTO ncr_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bamii ba gɛ̀ gɛɛne Jiso fwe mo ba gɛ̀ bii ajiŋ bo wuule lɛ, “Yilili Yilili, mbɛɛŋsɛ nyûme fɛ Nyo le lɛɛɛ! Nyo le wu noŋ kimbonɛ yi muh wù too a jee chi Tada le lɛɛɛ! ");
INSERT INTO ncr_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nyo le wu noŋ kimbonɛ yi bvunfoŋ bvu chiji wese besabɛŋ wù Dabi le bvù too le! Yilili Yilili, mbɛɛŋsɛ nyûme fɛ Nyo wu fɛwe le lɛɛɛ!” ");
INSERT INTO ncr_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jiso gɛɛŋ wu fɛsɛ Yɛlusalɛm, wu lee fɛ yeh yi kintanyɛ le, wu bijɛ no mwɛɛ munchii nyume. Wu doo wu mɛsɛ a kife gɛɛŋ wa, bɛ booŋ be ba ŋgoo ba yuufe ncho bafɛɛ ja bo gɛɛŋ Bɛtani. ");
INSERT INTO ncr_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Akfuuŋ bu ayuu Jiso bɛ booŋ be ba ŋgoo ja Bɛtani bo ka bo gɛɛne Yɛlusalɛm, jɛŋ tu yi yuu wu. ");
INSERT INTO ncr_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Wu yɛŋ kite kimi ki bojɛ je yì ndefe le kì ba to ba jii. Wu mo wu gɛɛŋ fo ki wu yɛ̂ŋ laa le no wu ke fiɛɛ yi ki le wu ji la. Wu doo wu gɛɛŋ wu bu fo wu gɛ yɛŋ fiɛɛ le yi ki le gɛ, wu yɛŋ gɛh nyu biŋkamɛ le maa, nje gɛ gɛ̀ bee kife kì ki to ki yune gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Wu mo wu jɛmɛ kite kiyu le lɛ, “Gɛ muh baaŋ wu ka wu yu wu to wu ji fiɛɛ yi wo le gɛ!” No wu jɛmɛ noo booŋ be ba ŋgoo yu. ");
INSERT INTO ncr_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bo ja bo gɛɛŋ bo fɛsɛ Yɛlusalɛm, Jiso gɛɛŋ fɛ yeh yi kintanyɛ le wu kɛ wu kuŋe bamii ba gɛ̀ kamɛ waaŋ fo. Wu gɛ̀ kuŋe noo wu baaji bidaŋ bi bamii ba gɛ̀ kuse bige, mo binta bi bamii ba gɛ̀ gese bibɛmbɛ. ");
INSERT INTO ncr_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Wu faŋ lɛ keefɛ muh ka wu tuu fiɛɛ wu jiɛnyɛ wu daŋ bɛ fi fɛ yeh yi kintanyɛ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Wu tu wu yɛyi bo wu duu lɛ, “Du ba gɛ̀ saŋ lɛ Nyo duu lɛ, ‘Yeh yaŋ ba lé ba tɛ̂ŋe lɛ yeh yi buunɛ yi bituŋ bichii?’ Geenɛ bɛŋ kaasɛ yi tu bvuta bvu bachoŋ.” ");
INSERT INTO ncr_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bachiji kintanyɛ ba baaŋ baaŋ bɛ bamii ba gɛ̀ duunyi banchi gɛ̀ yu, bo tu bo goone je yì bo yuuyɛ wu yu. Bo gɛ̀ kɛme nfaaŋ kune wu nje kinchvu ki bamii gɛ̀ yuge n'yɛyɛ we bo yuge njoŋ. ");
INSERT INTO ncr_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Lɛ doo nyume fɛnfu, Jiso bɛ booŋ be ba ŋgoo bu a kilaantɛŋ kiyu le. ");
INSERT INTO ncr_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Jiso bɛ booŋ be ba ŋgoo gɛ̀ bu bo fede antaana, bo yɛŋ kite kɛɛ le ki bobɛ wa kichii ki shii ki bu yi gɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Bita kwajɛ fiɛɛ fì chi kooshɛ, wu jɛmɛ Jiso le lɛ, “Muh wu N'yɛyɛ, yɛŋ no kite kɛɛ kì wo chi njiŋ le ki bobɛ wa.” ");
INSERT INTO ncr_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jiso chvuu bo le lɛ, “Nɛ bɛŋ leese fitele yi Nyo le, ");
INSERT INTO ncr_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","nsɛŋe bɛŋ nchiɛɛŋ lɛ, muh jɛme mbegɛ wunɛ le lɛ, ‘Mugɛ fɛnɛ wo gɛɛŋ wo gwe a joo yì baaŋ le’, wu duu noo wu maŋe gɛ a fitele le gɛ, wu bɛɛŋ lɛ fiɛɛ fì wu jɛme le fi kooshɛ, tu wu lé wu mûgɛ. ");
INSERT INTO ncr_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Noo, nsɛŋe bɛŋ le lɛ, mo nyume la fì bɛŋ lɛge a buunɛ le, bɛŋ bɛɛŋ lɛ bɛŋ le bɛŋ kɛme wa, tu bɛŋ lé bɛŋ kɛ̂mɛ. ");
INSERT INTO ncr_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Bɛŋ doo bɛŋ lɛɛŋ tɛ ki bɛŋ bûune, fi nyume lɛ muh kɛme muh mu fɛ fitele le, wu lɛɛshɛ fiɛɛ fiyu. Bɛŋ gêe noo lɛ Chiji wene wù le fɛwe lɛɛshɛ tɛ biɛna bimbefɛ.  ");
INSERT INTO ncr_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nɛ bɛŋ baaŋ lɛɛshɛ gɛ bimbefɛ bi bamii bamu gɛ, Chiji wene wù le fɛwe gɛ lɛɛshɛ tɛ biɛna gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jiso bɛ booŋ be ba ŋgoo ka bo gɛɛŋ bo lee Yɛlusalɛm. Wu gɛ̀ doo wu jiɛnyi fɛ yeh yi kintanyɛ le, bachiji kintanyɛ ba baaŋ baaŋ bɛ bamii ba duunyi banchi ba Nyo mo bamii ba sage woŋ ja bo to bo yɛŋ wu le, ");
INSERT INTO ncr_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","bo biih wu le lɛ, “Wo jo faaŋ bvuŋga ki wo gêe mwɛɛ munɛ? Nya yɛɛŋ bvuŋga bvuyu wo le ki wo gêe mwɛɛ munɛ?” ");
INSERT INTO ncr_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jiso nchvuu bo le lɛ, “Nle mbiih fiɛɛ bɛŋ le fimimia, bɛŋ nɛ le bɛŋ chvuu, mɛ mo nsɛɛŋ bɛŋ muh wu nya bvuŋga lɛ ŋgêe mwɛɛ munɛ yu. ");
INSERT INTO ncr_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Gɛ̀ nya yɛɛŋ bvuŋga Joŋ le ki wu lêese bamii a joo? Bvu gɛ̀ ja fɛwe noo gɛ̀ nya muh wu wuŋ le? Bɛŋ chvuu mɛne n'yu!” ");
INSERT INTO ncr_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bo ja bo tu bo tɛɛnyi lɛbolɛbo lɛ, “Nɛ bee chvuse lɛ bvu gɛ̀ ja fɛwe, wu biih bee le laa gɛ̀ ge la lɛ keefɛ bee bɛɛŋ Joŋ le gɛ? ");
INSERT INTO ncr_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Bee chvuse lɛ gɛ̀ nya muh wu wuŋ, fi chiɛɛŋ yo?” Bo gɛ̀ faane bamii, nje bamii bachii gɛ̀ bɛɛŋ lɛ Joŋ gɛ̀ bee muh wu ntuŋ wu Nyo. ");
INSERT INTO ncr_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Noo, bo mo bo chvuu Jiso le lɛ, “Gɛ bee kee gɛ.” Jiso mo wu jɛmɛ bo le lɛ, “Tu gɛ nyu nsɛ̂ɛŋ tɛ bɛŋ muh wù nya bvuŋga mɛne lɛ ŋgêe mwɛɛ munɛ yu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jiso mo wu ja wu tu wu jɛme bo le a baŋgaŋ le lɛ, “Muh mu gɛ̀ bee wu lɛŋ mwɛ wu muntaŋ mù ba fɛde mbvuuŋ yu, wu tuŋ kitaŋ ki kɛnɛ, wu fɛ kiso kì ba lé ba sôone muntaŋ fo mbvuuŋ bude, wu tuŋ kitale ki muh wu chiɛɛne mwɛ kwɛɛ, wu mo wu nya mwɛ kwɛɛ chiaaŋ yi bamii le, wu mo wu ja wu gɛɛŋ kituŋ kimi le. ");
INSERT INTO ncr_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kife kì ba kege muntaŋ to ki kojɛ, wu tuŋ mwa lɛme fɛ bamii ba wù gɛ̀ nya mwɛ bo le lɛ wu fi mwe muntaŋ wu to bɛ mu. ");
INSERT INTO ncr_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Wu gɛɛŋ bo koo lo wu bo suŋ, bo kuŋ wu tu jiŋ chiaaŋ chiaaŋ. ");
INSERT INTO ncr_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Muh mwɛ kwɛɛ ka wu tuŋ mwa lɛme wumu, wu gɛɛŋ, bo ka bo suŋ wu bo chiɛɛ kikwɛɛ, bo choosɛ wu. ");
INSERT INTO ncr_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Wu ka wu tuŋ wumu, bo yuuyɛ wɛɛ. Wu ka wu tuŋ bamu wu mumwaa wu mumwaa bo duude lo, ba suŋ bamu, ba yuuyɛ bamu. ");
INSERT INTO ncr_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Wu gɛ̀ tuŋ bo, to shɛɛ wa gɛh muh wu mumwaa, muh wunɛ nyume mwa ye, wu le fitele fie. Wu mɛsɛ wu tuŋ wu fɛ bo le wu kwaji lɛ bo lé bo gɛ̂ɛŋ bo ŋgvuuŋ mwa ye wunɛ. ");
INSERT INTO ncr_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Geenɛ, bamii bayu jɛmɛ lɛbolɛbo lɛ, ‘Wunɛ le nji bvushɛ bvu muh wu mwɛ kfunɛ, bɛŋ to bee yuuyɛ wu bvushɛ bvuyu tu bwesa besabɛŋ.’ ");
INSERT INTO ncr_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Bo mo bo koo wu, bo yuuyɛ, bo bvusɛ bo noŋ akfuuŋ a kitaŋ.” ");
INSERT INTO ncr_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","No Jiso jɛmɛ nɛ, wu mo wu biih lɛ, “Fiɛɛ fì taŋlo chiji kikwɛɛ wu mwɛ kfunɛ ge le la? Wu lé wu gê wu tô wu lɛɛshɛ lo bamii bayu, wu nya mwɛ kwɛɛ nyu wa bamii bamu le. ");
INSERT INTO ncr_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Bɛŋ gɛ̀ baaŋ a tɛɛŋ gɛ kijusɛ kinɛ a Ŋwa wu Nyo le gɛ? Ba le ba saŋ lɛ, ‘Tɛdɛ chiyu chiɛɛ chì bamii ba joone gɛ̀ faŋ, gɛ̀ ja chi kaasɛ chi tu tɛdɛ chi buu chi yeh. ");
INSERT INTO ncr_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Finɛ gɛ̀ ge Tada, bee jiiŋe bee kɛme ŋgha.’” ");
INSERT INTO ncr_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Bamii banɛ yu ŋgaŋ wunɛ, bo mo bo kɛɛ lɛ Jiso ma nyu bo le. Bo tu bo goone ki bo koo wu, bo faŋ kinchvu ki bamii ki gɛ̀ bee fo. Bo mo bo chinɛ wu le wu ja wu gɛɛne. ");
INSERT INTO ncr_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bikwɛɛ bi woŋ gɛ̀ ja bi tuŋ Bafalashii mo bamii bamu ba ŋgoo yi Nfoŋ Hɛlod le lɛ bo gɛɛŋ bo telɛ Jiso lɛ bo koo wu yi njɛmɛ we le. ");
INSERT INTO ncr_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bo to, bo jɛmɛ Jiso le lɛ, “Muh wu N'yɛyɛ, bee kee lɛ wo to wo jɛme gɛh nyu nchiɛɛŋ, nje gɛ wo faane jise chi muh gɛ, kɛnɛ fiɛɛ fì le mwɛdɛ gɛ. Wo yɛyi nchiɛɛŋ nyu jɛ yi Nyo. Gɛh sɛɛŋ bee laa nchi le wu bɛɛŋ lɛ bee lâaŋe ŋwa Kaisa Nfoŋ wù Lum le, noo wu baaŋ bɛɛŋ gɛ le? ");
INSERT INTO ncr_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Bee lâaŋe, noo keefɛ be lâaŋe gɛ la?” Jiso kɛɛ fiɛɛ fì bo gɛ̀ wɛɛne bɛ fi, wu chvuu lɛ, “Bɛŋ tele mɛ nje la? Bɛŋ to bɛ danale n'yɛŋ.” ");
INSERT INTO ncr_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bo to bɛ wu, wu fi, wu biih lɛ, “Kikwɛɛ kinɛ kì le yu, le ki yɛɛŋ lɛ, jee chinɛ le chi yɛɛŋ lɛ?” Bo chvuu lɛ, “Le ki Kaisa lɛ, jee le gɛh tɛ che.” ");
INSERT INTO ncr_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jiso mo wu jɛmɛ bo le lɛ, “Bɛŋ nyâa fiɛɛ fì le fi Kaisa wu le, bɛŋ nyâa fi Nyo Nyo le.” Bo yu noo, jwe yuŋ lo bo kune wu. ");
INSERT INTO ncr_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Basadushii bamu gɛ̀ ja bo to ki bo biih fiɛɛ Jiso le. Basadushii gɛ̀ bee bamii ba gɛ̀ duu lɛ gɛ bamii nyu bo ge bo bu yi kwe le gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","No bo to, bo biih wu le lɛ, “Muh wu N'yɛyɛ, Musɛ gɛ̀ saŋ a banchi besa le lɛ, ‘Nɛ muh jo kwɛse wu kwe mwa sɛŋ, tu mwa bwee kɛme ki wu gɛ̂ɛ kwɛse wuyu bɛ wu boo booŋ a jee chi ŋkfu mwa bwee le.’ ");
INSERT INTO ncr_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Noo, muh mu gɛ̀ kɛme booŋ ba bilɛŋsɛ bvusooshwi, wù ŋgamu gɛ̀ jo kwɛse, wu kwe mwa sɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wù bii wu le, gɛɛ kwɛse wuyu, wu kwe tɛ mwa sɛŋ. Fi gɛ̀ kooshɛ gɛh tɛ yɛɛŋyɛɛŋ bɛ wù gɛ bii wuwɛɛ le. ");
INSERT INTO ncr_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bo gɛ̀ gɛɛ wu bachii, muh gɛ̀ baaŋ nyu gɛ yu antɛnɛɛ a bamii ba bvusooshwi wù boo mwa bɛ kwɛse wɛɛ gɛ. Ajiŋ ayu kwɛse wɛɛ kwe tɛ. ");
INSERT INTO ncr_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","No bamii ba bvusooshwi bayu gɛ̀ jo kwɛse wɛɛ bachii, sege bamii bude yi kwe le, wu le wù nyu kwɛ yɛɛŋ?” ");
INSERT INTO ncr_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jiso jɛmɛ bo le lɛ, “Bɛŋ jɛme nɛ bɛŋ jiaade lo nje gɛ bɛŋ kee fiɛɛ fì ba saŋ a Ŋwa wu Nyo le gɛ, gɛ bɛŋ kee tɛ bvuŋga bvu Nyo gɛ? ");
INSERT INTO ncr_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Fiɛɛ fì le, le lɛ lé gê nyu sege bamii bude yi kwe le, gɛ bilɛŋsɛ bɛ bikɛse baaŋ bo ka bo taashi bvuguu gɛ, bamii baaŋ gɛ bo ka bo nyaa booŋ bo taashi bvuguu gɛ. Bo lé bo tô bo nyume wa njɛ banchɛndaa ba Nyo fɛwe. ");
INSERT INTO ncr_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Fiɛɛ fì kune no bamii lé bo gê bo bude yi kwe le, bɛŋ gɛ̀ baaŋ a tɛɛŋ gɛ kijusɛ a Ŋwa wu Musɛ le kune kite ki mbiaŋ kì wu gɛ̀ yɛŋ ki bɛde, Nyo jɛmɛ Musɛ le, wu duu lɛ, ‘Le mɛ wù Nyo wu Ablaham bɛ Nyo wu Asik mo Nyo wu Yakob?’ ");
INSERT INTO ncr_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Wu lɛ gɛ Nyo nyume Nyo wu baŋkfu gɛ, le Nyo wu bamii ba baaŋ yu. Bɛŋ le bɛŋ jiaa baaŋ.” ");
INSERT INTO ncr_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Muh mu wù gɛ̀ duunyi banchi ba Nyo gɛ̀ ja wu to, wu doo wu yu no Jiso bɛ bamii baa tɛɛnyi kintɛɛnyɛ, wu ka wu yɛŋ no wu chvuu fiɛɛ fì bo biide wu le a je yì joŋe le, wu mo wu biih tɛ Jiso le lɛ, “Nchi wù fede banchi bachii le wù la?” ");
INSERT INTO ncr_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jiso chvuu wu le lɛ, “Nchi wù fede banchi bachii le wunɛ wu duu lɛ, ‘O bamii ba Ishwala bɛŋ yû, Tada Nyo, wù Nyo wese besabɛŋ, Tada Nyo wuyu le gɛh wu mumwaa. ");
INSERT INTO ncr_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Wo kôŋe Tada Nyo wo bɛ fitele fiuŋ fichii, wo nya kikwɛɛ kuŋ wu le kichii, wo gɛ̂ɛde bvufee bwuŋ ye ye le bvuchii, wo lɛ̂ne fɛ wu le bɛ bvuŋga bwuŋ bvuchii.’ ");
INSERT INTO ncr_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nchi wù bii wunɛ le le lɛ, ‘Wo kôŋe muh wù le mbebe yo le no wo koŋe kikwɛɛ kuŋ.’ Gɛ nchi wumu ka nyu yu wù fede banɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Muh wù gɛ̀ duunyi banchi ba Nyo wɛɛ jɛmɛ Jiso le lɛ, “Muh N'yɛyɛ, wo le wo chvuu chuule. Wo jɛme nyu nchiɛɛŋ lɛ Nyo le gɛh wu mumwaa gɛ wumu ka nyume yu wù fede wu gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ki wo kôŋe wu bɛ fitele fichii, wo gɛ̂ɛde bvufee ye ye le bvuchii, wo lɛ̂ne fɛ wu le bɛ bvuŋga bvuchii, bɛ kì wo kôŋe muh wu le mbebe yo le no wo koŋe kikwɛɛ kuŋ, fi fede lo ki ba gee bintanyɛ bɛ nyáŋ yì tonɛ mo bintanyɛ bimi.” ");
INSERT INTO ncr_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jiso doo wu yɛŋ no wu chvuu njɛ muh bvufee, wu mo wu jɛmɛ wu le lɛ, “Gɛ wo nyu je yì ndefe le ki wo lêe bvunfoŋ bvù Nyo le gɛ.” Ajiŋ ayu, muh gɛ̀ baaŋ ka moŋ gɛ, ki wu tô wu biih fiɛɛ wu le gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jiso tu wu yɛyi bamii fɛ yeh yi kintanyɛ le, wu gɛ̀ ja wu biih bo le lɛ, “Bamii ba duunyi banchi jiɛnyi nɛɛ fɛ bo tu bo duu lɛ Mbvusɛ wù Nyo gɛ̀ ka le mwa Nfoŋ Dabi le? ");
INSERT INTO ncr_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kiyo ki Yuude gɛ̀ ge wa Nfoŋ Dabi wunɛ jɛmɛ kune Mbvusɛ wuyu wu duu lɛ, Tada Nyo gɛ̀ jɛmɛ Tada waŋ le lɛ, ‘Wu shii a kibo ke kinchiɛɛŋ le, gɛɛŋ bu sege wu lé wu gê wu giiŋsɛ bamii be ba kimbanɛ wu tomɛ bikaa bie yi bo le.’ ");
INSERT INTO ncr_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Nɛ Dabi kibɛɛ tɛŋe wu lɛ Tada we, fi ka fì jiɛnyɛ nɛɛ fɛ wu tu wù nyu mwa ye?” No Jiso jɛme mwɛɛ munɛ nɛ, kinchvu ki bamii kì gɛ̀ bee fo, tu ki yege, njoŋ yuu lo bo. ");
INSERT INTO ncr_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Wu doo wu yɛyi bamii wu ja wu jɛmɛ bo le lɛ, “Bɛŋ yɛ̂ne kune bamii ba duunyi banchi ba Nyo. Bo koŋe ki bo nooŋ nyu bikuŋ bì ndefe bo jiɛnyi bɛ bi manjuu ma ba kame chiwaaŋ fo lɛ bamii yɛ̂ɛse bo le bɛ ŋgvunɛ. ");
INSERT INTO ncr_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bo koŋe ki bo shiide nyu fwe yéh yi buunɛ le. Sege bo le bo gɛɛŋ fɛ ŋka le, bo shiide nyu binta bì baaŋ baaŋ le. ");
INSERT INTO ncr_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bo shiishi bakwɛŋkfu bo lɛɛde bɛ bo, bo fii yéh bɛ mwɛɛ muboo, bo buuse bo bɛ chibuunɛ chì ndefe. Wuboo ŋgɛ lé wu gê wu ya lo.” ");
INSERT INTO ncr_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jiso ja wu gɛɛŋ wu shii kimbe kege le fɛ ŋku wu nnya le fɛ yeh yi kintanyɛ le, wu jiiŋe no bamii too bo gɛɛde bige a ŋku wuyu le. Bamii ba kwa ba duude tu bo too bo gɛɛde bige yo wesee. ");
INSERT INTO ncr_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kwɛŋkfu wumu gɛ̀ ja wu to nyu muh wu kifufe, wu gɛɛ munini yo munfɛɛ mù le jise chi bige chi le gɛ fiɛɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jiso bɛɛŋ booŋ be ba ŋgoo wu jɛmɛ bo le lɛ, “Nsɛŋe bɛŋ nchiɛɛŋ lɛ kwɛŋkfu wunɛ wu le muh kifufe nɛ, le wu nya wu fe bamii bachii ba gɛɛde fiɛɛ a ŋku wu yeh yi kintanyɛ le. ");
INSERT INTO ncr_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bamii bachii ba be nyaa, be too nyu bɛ bimbɛge bi bvukugɛ bvuboo bvù le bvu yisɛ wa bvu tu bvu fuushi kuu. Geenɛ kwɛse wunɛ wu le kifufe kifufe nɛ le wu nya fiɛɛ fichii fì wu gɛɛde kikwɛɛ yu, nyu fi fì wu bee ki wu chêe yi fi le.” ");
INSERT INTO ncr_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jiso gɛ̀ doo wu jade fɛ yeh yi kintanyɛ le, mwa ye wu ŋgoo wumu jɛmɛ wu le lɛ, “Muh wu N'yɛyɛ bîjɛ yɛ̂ŋ bibwee bi ata bì le yi yéh chinɛ le. Le lo biŋgha bi yéh!” ");
INSERT INTO ncr_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jiso chvuu wu le lɛ, “Wo yɛde biŋgha bi yéh chinɛ le? Gɛ tɛdɛ chimimia nyu chi ge chi shɛɛ yi chimi le njɛ ba kɛsɛ fɛkuu sɛŋ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jiso gɛɛŋ wu bɛɛŋ wu shii yi Mbegɛ wu Bite bi Olif le a kimbe kì jiiŋe yeh yi kintanyɛ le, Bita bɛ Jɛm mo Joŋ mo Andulu gɛɛŋ lɛbolɛbo bo biih wu le lɛ, ");
INSERT INTO ncr_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Gɛh sɛɛŋ bee kife kì finɛ lé fi gê fì kooshɛ, wo ka wo sɛɛŋ njiŋɛ wù lé wu gê wu dûnyɛ kife ki mwɛɛ muyu munɛ munchii lé mu gê mu kôoshɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jiso mo wu jɛmɛ bo le lɛ, “Bɛŋ yɛ̂ne keefɛ muh to wu lɛɛ bɛ bɛŋ, bɛŋ jiaa je gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bamii ba duude lé bo gê bo too bo jode jee chaŋ bo tɛyi fɛ jii, muh duu lɛ, ‘Le mɛ wuyu.’ Sege bo doo bo gee noo bo lɛɛde bɛ bamii wesee bo jiaade je. ");
INSERT INTO ncr_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Bɛŋ doo bɛŋ yu lɛ ba tune jɛŋ kɛnɛ lɛ jɛŋ le yi nyume, keefɛ fitele gûde bɛŋ gɛ. Munɛ le mwɛɛ mù kɛme ki mu gê mu kooshɛ. Geenɛ gɛ mu mo duunyi lɛ woŋ kage wa lo gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kituŋ lé ki gê ki tune jɛŋ bɛ kimi, Nfoŋ wumu tune jɛŋ bɛ wumu. Nshɛŋ lé yi gê yi shîiŋshi manjuu le manjuu le, jɛŋ lé yi gê yi kôode. Mwɛɛ munɛ munchii baaŋ gɛh lo nsasɛ njɛ sege kwɛse kɛ lume. ");
INSERT INTO ncr_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Bɛŋ doo bɛŋ nyume bɛŋ yɛ̂ne. Bɛŋ kêe lɛ ba lé ba gê ba nyâ bɛŋ chiaaŋ yi bamii ba sage bansa le. Bo lé bo gê bo sûŋe bɛŋ yéh yi buunɛ le. Bɛŋ lé bɛŋ gê bɛŋ lɛ̂ɛŋ fwe a bamii ba sage bimbe bi woŋ le, mo fwe a banfoŋ nje mɛ, wu lɛ bɛŋ jɛmɛ bo le kune mɛ. ");
INSERT INTO ncr_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Geenɛ bo kɛme ki bo ya bo fejɛ saaka wù joŋe wu Nyo bituŋ le bichii. ");
INSERT INTO ncr_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Sege ba koo bɛŋ ba gɛɛŋ ba nya bɛŋ yeh yi nsa le, keefɛ kikwɛɛ saaŋe bɛŋ laa bɛŋ lé bɛŋ gɛ̂ɛŋ bɛŋ tâanyi jwe lɛ la lɛ. Sege bɛŋ gɛɛŋ, bɛŋ jɛme gɛh nyu fiɛɛ fì bude jwe wene le kife kɛɛ le, nje gɛ baaŋ jɛme bɛŋ gɛ. Lé ge nyâ Kiyo ki Yuude njɛme jwe wene le. ");
INSERT INTO ncr_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Muh lé wu jâ wu jo mwa bwee wu nya ba yuuyɛ, chiji mwa jo mwa ye wu nya ba yuuyɛ. Booŋ lé bo gê bo jâ bo bôone bikaa a bachiji baboo bɛ babwee baboo jiŋ, bo gee ba yuuyi bo. ");
INSERT INTO ncr_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bamii bachii lé bo gê bo bânɛ bɛŋ nje jee chaŋ. Geenɛ, muh wu lé wu gê wu kâaŋ shɛ́ŋ gɛɛŋ bu fɛkimɛsɛ lé wu gê wu bônɛ. ");
INSERT INTO ncr_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","(Muh wù tɛŋe ŋwa wunɛ wu yû finɛ chuule). Sege bɛŋ yɛŋ kiŋgha ki fiɛɛ le kì taŋlo ki chɛŋe bɛ kijusɛ ki lɛme wa fo fɛ ki kɛme gɛ ki ki nyume fo gɛ, bamii ba le Judia mo bo fɛɛ lo bo bɛɛŋ yi bambegɛ le. ");
INSERT INTO ncr_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Keefɛ muh wù le kigo ki yeh le ka wu shîi ki wu lêe yeh lɛ wu jo fiɛɛ lɛ wu legɛ bɛ fi gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Keefɛ muh wù le mwɛne ka wu kwɛ̂ɛdɛ lɛ wu to wu jo nju ye yi bulɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ŋgɛ wù baaŋ le yi aju kaa le, lé wu gê nyû wu bikɛse ba le bɛ chifwe, mo ba yaŋse booŋ. ");
INSERT INTO ncr_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Bɛŋ bûune lɛ keefɛ fiɛɛ finɛ ge fi kooshɛ nyu kife ki nfuŋ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Bamii lé bo gê bo yɛ̂ŋ ŋgɛ aju ayu le, kfuu chi wuwɛɛ ŋgɛ gɛ̀ baaŋ a nyu gɛ yu gɛ kɛge no Nyo gɛ̀ fɛ woŋ too bude mɛɛse. Gɛ kfuu chi wuwɛɛ baaŋ wu ka wu yu wù nyu yu gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nɛ Tada gɛ̀ baaŋ gade gɛ aju a ŋgɛ ayu gɛ, tu gɛ muh wu wuŋ wu mumwaa bee wu bonɛ gɛ. Geenɛ wu gɛ̀ gade aju ayu nje bamii be ba wu gɛ̀ cha. ");
INSERT INTO ncr_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Muh nɛ lé wu dû bɛŋ le aju ayu le lɛ, ‘Bɛŋ jîŋɛ bɛŋ yɛ̂ŋ, Mbvusɛ wù Nyo gɛ̀ ka wunɛ fɛnɛ!’ Kɛnɛ lɛ, ‘Bɛŋ yɛŋ nɛ wu wege fege!’ Keefɛ bɛŋ bɛ̂ɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Bɛŋ kêe lɛ bamii lé bo gê bo tôo bo mbîane lɛ bo le bambvusɛ ba Nyo gɛ̀ ka, bamu duu lɛ bo le bamii ba ntuŋ wu Nyo, bo mo bo gee mwɛɛ mù duunyi bvuŋga bvuboo, bo gee tɛ mwɛɛ mu jwe yune, ki bo lɛ̂ɛde bɛ bamii ba Nyo gɛ̀ cha wa lɛ bo jiaade je, nɛ je le yu. ");
INSERT INTO ncr_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Bɛŋ yɛ̂ne! Nle nsɛɛŋ wa mwɛɛ munɛ bɛŋ le munchii le fɛ mu ge mu kooshi. ");
INSERT INTO ncr_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Lé ge doo nyûme aju ayu kaa le sege baŋgɛ bayu fe wa, juu ja nɛ chi jime, kwii gɛ ka wu baaŋ tɛ gɛ, ");
INSERT INTO ncr_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","jóŋ jade fɛwe yi gweeyi, mwɛɛ mù fɛwe munchii mù kɛme bvuŋga, shiiŋshi. ");
INSERT INTO ncr_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Noo, bamii mo bo yɛŋ no muh wù jee che le Mwamuh shiide wu too yi kimbɛ le wù kɛme bvuŋga bvù baaŋ mo bvukugɛ. ");
INSERT INTO ncr_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Wu mo wu chîiŋsɛ banchɛndaa be bo gɛ̂ɛŋ abu a woŋ a ana a yi nshɛŋ le mo fɛwe, bo banyɛ bamii be ba wu le wu cha. ");
INSERT INTO ncr_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Bɛŋ yɛ̂yɛ fiɛɛ yi kiŋgvuŋ le. Chɛ́ ye ge doo yi boji, biŋkamɛ kɛ bi choone yi ki le, bɛŋ mo bɛŋ kɛɛ lɛ akfuuŋ kusɛ wa. ");
INSERT INTO ncr_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Le gɛh yɛɛŋyɛɛŋ no bɛŋ ge doo bɛŋ yɛne mwɛɛ munɛ kooshi, bɛŋ mo bɛŋ kɛɛ lɛ wu le wa mbebe le, mo a yeh fwɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nsɛŋe bɛŋ nchiɛɛŋ lɛ gɛ kiŋgogɛ ki mɛɛse kinɛ nyu ki to ki ka, njɛ mwɛɛ munɛ munchii kooshɛ sɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kibvulɛ bɛ nshɛŋ lé ki tô ki ka, geenɛ gɛ jɛ yaŋ nyu yi to yi shiiŋshɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Geenɛ gɛ muh nyu yu wù kee juu chiyu kɛnɛ kife kiyu gɛ. Gɛ banchɛndaa ba Nyo ba fɛwe kɛnɛ Mwa Nyo kee tɛ gɛ. Kee gɛh Nyo wù Chiji maa. ");
INSERT INTO ncr_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Noo bɛŋ yɛ̂ne bɛŋ ka chîɛɛne nje gɛ bɛŋ kee kife kiyu gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Fi lé fi gê fi nyû njɛ fɛ muh mu wu gɛ̀ gɛɛne njiɛnyɛ, wu doo wu jade, wu gɛɛ yeh ye chiaaŋ yi booŋ be ba lɛme le, muh bɛ che lɛme, muh bɛ che lɛme, wu du muh wù chiɛɛne jwe wu kitaŋ le lɛ wu shɛɛ wu chîɛɛne chuule. ");
INSERT INTO ncr_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Noo, bɛŋ mo bɛŋ chîɛɛne, nje gɛ bɛŋ kee kife kì chiji kikwɛɛ lé wu gê wu tô gɛ. Nɛ taŋlo wu ge wu to fɛnfu, kɛnɛ antaŋ antɛnɛɛ, kɛnɛ yi nyishii yi fwe le, kɛnɛ antaana. ");
INSERT INTO ncr_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Keefɛ wu ge wu ja wu bunɛ wu yɛŋ bɛŋ lefe gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Fiɛɛ fì njɛme bɛŋ le finɛ le njɛme tɛ muh le wuchii, ‘Muh wuchii chîɛɛne.’” ");
INSERT INTO ncr_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Gɛ̀ shɛge aju afaa mo nyume Ŋka wu Ndaŋfe mo Ŋka wu Blɛd wù ba baaŋ gɛɛ gɛ kinshilɛ yo gɛ. Bachiji kintanyɛ ba baaŋ baaŋ mo bamii ba duunyi banchi ba Nyo mo bo goone je yì bo koo Jiso yu nyilɛ le, bo yuuyɛ. ");
INSERT INTO ncr_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Bo chu ntaŋ lɛbolɛbo lɛ, “Keefɛ besabɛŋ moŋ fiɛɛ finɛ kife kì ba gee Ŋka le gɛ, nje besabɛŋ moŋ lo, fi to bɛ jwe a bamii ntɛnɛɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jiso gɛ̀ bee ntɛ wù Bɛtani le, a Samoŋ yeh wù gɛ̀ shɛɛ wù nyu muh goŋ yì baaŋ, bo shii bo jii mwɛɛ, kwɛse wumu ja wu lee bɛ fikaaŋ fi mɛɛ mà gwee wuŋ. Mɛɛ mayu gɛ̀ tɛɛme kwa, ba kɛnyi bɛ nad lɛwulɛwu. No wu leese, wu mo wu gwenyɛ jwe wu fikaaŋ fiyu wu fuushɛ mɛɛ mayu yi kikwɛɛ ki Jiso le. ");
INSERT INTO ncr_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bamii bamu ja bo tu bo shuŋshi lɛbolɛbo bo duu lɛ, “Wu chɛŋe bɛ mɛɛ mayu nɛ nje la? ");
INSERT INTO ncr_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ba taŋlo ba gesɛ mɛɛ mayu fe bige banchvuge gii yitɛde, ba nya bige biyu bamii ba kifufe le.” Bo tu bo ŋase lo bɛ wu. ");
INSERT INTO ncr_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Geenɛ, Jiso jɛmɛ bo le lɛ, “Bɛŋ chînɛ wu le. Bɛŋ nyaa ŋgɛ wu le nɛ nje la? Wu le wu ge nyu fiɛɛ fì joŋe fɛ mɛne. ");
INSERT INTO ncr_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Bɛŋ kêe lɛ bamii ba fuude lé bo gê bo nyûme bɛ bɛŋ segechii. Bɛŋ taŋlo bɛŋ fiih bo sege bɛŋ koŋe. Geenɛ, gɛ mɛ nyu ŋge nyume besabɛŋ segechii gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kwɛse wunɛ le wu ge nyu fiɛɛ fì taŋlo wu ge. Wu yefɛ mɛ bɛ mɛɛ manɛ nɛ nyu wu seese nyu ye yaŋ baaŋ lo no ba lé ba gê ba jîiyɛ mɛ. ");
INSERT INTO ncr_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nsɛŋe bɛŋ nchiɛɛŋ lɛ, mo nyu faaŋ fɛ ba lé ba gê ba fêeji saaka wù joŋe wunɛ yi kikwɛɛ ki nshɛŋ le kichii, fiɛɛ fì kwɛse wunɛ ge ba lé ba sɛ̂ŋe tɛ, ki ba kwaji wu.” ");
INSERT INTO ncr_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Juda Ɛkaliot wù gɛ̀ bee muh a ŋgoo yi booŋ ba ŋgoo ba Jiso ba yuufe ncho bafɛɛ le, mo wu ja wu gɛɛŋ fɛ bachiji kintanyɛ ba baaŋ baaŋ le lɛ wu gesɛ Jiso bo le. ");
INSERT INTO ncr_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bo doo bo yu noo bo yu njoŋ baaŋ, bo mo bo ka lɛ bo lé bo nyâ wu bige. Wu mo wu kɛ wu goone je yì wu lé wu nyâ Jiso chiaaŋ yiboo le. ");
INSERT INTO ncr_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Juu chì fwe chi Ŋka wu Blɛd wù ba baaŋ gɛɛ gɛ kinshilɛ yo gɛ, gɛ̀ to chi kojɛ chì bo to bo sɛɛyi mwa kiya wu Ŋka wu Ndaŋfe, booŋ ba Jiso ba ŋgoo biih wu le lɛ, “Wo goone lɛ bee gɛɛŋ bee seesɛ nyu faaŋ fɛ wo lé wo jî Ŋka wu Ndaŋfe fo?” ");
INSERT INTO ncr_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Wu mo wu tuŋ booŋ be ba ŋgoo bamu bafɛɛ, wu jɛmɛ bo le lɛ, “Bɛŋ gɛ̂ɛŋ alaantɛŋ, bɛŋ doo bɛŋ gɛɛne, bɛŋ yɛ̂ŋ muh le wu tuu joo a shaaŋ le, bɛŋ bi wu le. ");
INSERT INTO ncr_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Sege wu gɛɛŋ wu lee yeh yì wu le wu lee yu, bɛŋ jɛ̂mɛ muh wù kɛme yeh yiyu le lɛ, Muh wu N'yɛyɛ biide laa kibuu ki yeh yi bamii ba njiɛnyɛ kɛɛ kì bɛ booŋ be ba ŋgoo lé bo jî Ŋka wu Ndaŋfe yu le faane la? ");
INSERT INTO ncr_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wu lé wu dûnyɛ kibuu ki yeh ki awe ba nyu ba seesɛ wa ba kɛnyɛ, bɛŋ mo bɛŋ seesɛ mwɛɛ munjile yu.” ");
INSERT INTO ncr_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Booŋ ba ŋgoo bayu mo bo ja bo gɛɛŋ a kilaantɛŋ kiyu le, bo gɛɛŋ bo yɛŋ mwɛɛ nyu gɛh yɛɛŋyɛɛŋ no Jiso gɛ̀ jɛme bo le. Bo mo bo seesɛ mwɛɛ munjile mu Ŋka wu Ndaŋfe wuyu fo. ");
INSERT INTO ncr_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Lɛ to nyume fɛnfu, Jiso bɛ booŋ be ba ŋgoo ba yuufe ncho bafɛɛ taashɛ yu. ");
INSERT INTO ncr_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Bo shii bo tu bo jii mwɛɛ, Jiso ja wu jɛmɛ bo le lɛ, “Nsɛŋe bɛŋ nchiɛɛŋ lɛ muh mu bɛŋ le, lé wu gê wu gêsɛ mɛ, muh wunɛ jii mwɛɛ besa wu.” ");
INSERT INTO ncr_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Bo yu noo, bo ja bo tu bo nyume yii yii, bo jɛme wu le, wu mumwaa wu mumwaa lɛ, “Le mɛ?” ");
INSERT INTO ncr_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Wu chvuu lɛ, “Le gɛh muh mu bɛŋ ba yuufe ncho bafɛɛ le wù besa wu chude blɛd a shu le. ");
INSERT INTO ncr_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Muh wù jee che le Mwamuh le wu gɛɛŋ gɛh no ba gɛ̀ saŋ kune wu. Geenɛ, ŋgɛ wù baaŋ le fɛ muh wù gesɛ muh wù jee che le Mwamuh. Fi be joŋe fɛ wuwɛɛ muh le lɛ keefɛ ba bôo wu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","No bo gɛ̀ jii mwɛɛ, Jiso ja wu jo blɛd, wu nya kiyone Nyo le, wu bweeyɛ, wu nya booŋ be ba ŋgoo le wu jɛmɛ lɛ, “Bɛŋ ko, finɛ le ye yaŋ.” ");
INSERT INTO ncr_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wu mo wu jo tɛ fiŋkoo, wu nya kiyone Nyo le, wu mo wu nya fiŋkoo fiyu bo le, lɛ bo mu bo bachii. ");
INSERT INTO ncr_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Wu jɛmɛ bo le lɛ, “Finɛ le kilɛmɛ kaŋ kì Nyo gwo maŋkaŋ yu ki bu njɛ muh wù duude. ");
INSERT INTO ncr_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nsɛŋe bɛŋ nchiɛɛŋ lɛ gɛ̀ mbaaŋ ŋka mu mbvuuŋ ma nchwɛŋ wu kite ki laane manɛ gɛ, gɛɛŋ bu juu chì nlé ŋgê mmû ma manfɛŋ antɛnɛɛ a bvunfoŋ bvu Nyo.” ");
INSERT INTO ncr_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jiso bɛ booŋ be ba ŋgoo gɛ̀ mɛsɛ, bo yɛɛŋ ŋkee wu mbɛɛŋsɛ, bo mo bo bu bo bɛɛŋ bo gɛɛŋ yi Mbegɛ wu Bite bi Olif le. ");
INSERT INTO ncr_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jiso gɛ̀ ja wu jɛmɛ bo le lɛ, “Bɛŋ bachii lé bɛŋ gê bɛŋ chîi bikaa a mɛ jiŋ. Le no ba le ba saŋ lɛ Nyo duu lɛ, ‘Nlé ŋgê n'yu nchiɛnɛ shóŋ, shóŋ saaŋɛ.’ ");
INSERT INTO ncr_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Geenɛ, sege Nyo bvusɛ mɛ yi kwe le, nsa bɛŋ fwe Galalee.” ");
INSERT INTO ncr_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Bita chvuu Jiso le lɛ, “Nɛ bamii bachii chile bikaa a wo jiŋ, tu gɛ taŋlo nchii biaŋ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jiso jɛmɛ wu le lɛ, “Nsɛŋe wo nchiɛɛŋ lɛ kintaŋ ki abɛŋ kinɛ le, nyishii lé yi gê yi tôŋ kiŋgane kinfɛɛ, nyu wo faŋ wa mɛ kiŋgane kintɛde.” ");
INSERT INTO ncr_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Bita jɛmɛ fi tɛmɛ lo wu du lɛ, “Mo fi nyume lɛ nlé ŋkwê lo besa wo, tu gɛ taŋlo n'yu nfaŋ wo gɛ.” No wu jɛmɛ noo, bo bachii jɛmɛ gɛh tɛ noo. ");
INSERT INTO ncr_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Bo gɛɛŋ bo lee fɛ mwɛ wu kitaŋ kimi le, ba tɛŋe lɛ Gɛsɛmani, Jiso jɛmɛ booŋ be ba ŋgoo le lɛ, “Bɛŋ shîi fɛnɛ, ŋgɛɛŋ mbuunɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Wu mo wu jo Bita bɛ Jɛm mo Joŋ, bɛ bo ja fo. Wu ja wu tu wu kwaji mwɛɛ wu nyume yi maluŋ le. ");
INSERT INTO ncr_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Wu jɛmɛ bo le lɛ, “Fitele fiaŋ le yii yii baaŋ njɛ ŋkwe lo. Bɛŋ shɛ̂ɛ fɛnɛ bɛŋ chîɛɛne.” ");
INSERT INTO ncr_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jiso ja fo wu kɛŋsɛ wu gɛɛŋ fwe shige, wu gwe fɛkuu, wu buunɛ lɛ nɛ je be bee yu, kife ki ŋgɛ kinɛ ki fe lo. ");
INSERT INTO ncr_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Wu buunɛ lɛ, “Aba, Chii, wo taŋlo wo ge fiɛɛ fichii. Wo chîaasɛ fiŋkoo fi ŋgɛ finɛ lɛ keefɛ mɛ mu gɛ. Geenɛ, gee gɛh no wo koŋe. Keefɛ wo gê no ŋkoŋe gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jiso kaasɛ wu tu jiŋ fɛ bo le, wu yɛŋ bo lefe. Wu biih Bita le lɛ, “Samoŋ, wo lefe lo? Gɛ taŋlo wo chiɛɛŋ, gɛɛŋ bu yi ntaŋ wu kife le kimimia gɛ? ");
INSERT INTO ncr_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Bɛŋ nyûme we bɛŋ bûune lɛ keefɛ moŋ ge wu to fɛ bɛŋ le gɛ. Le nchiɛɛŋ lɛ fitele koŋe lo, geenɛ nyaŋ yi ye wɛɛyi.” ");
INSERT INTO ncr_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","No wu jɛmɛ noo wu ka wu kaasɛ wu gɛɛŋ wu buunɛ gɛh no wu be buunɛ wa. ");
INSERT INTO ncr_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Wu doo wu kaasɛ wu tu jiŋ wu ka wu yɛŋ booŋ be ba ŋgoo lefe nje lefɛ gɛ̀ bee bo ajii baaŋ. Bo gɛ kɛɛ fiɛɛ fì bo chvuu wu le gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Wu kaasɛ wu tu jiŋ kiŋgane kintɛde, wu biih bo le lɛ, “Bɛŋ baaŋ gɛh bɛŋ lefe bɛŋ fufe shɛŋ? Chi le chi kojɛ. Le wa kife. Ba le ba gesɛ wa muh wù jee che le Mwamuh bamii ba befe le. ");
INSERT INTO ncr_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bɛŋ jâ we besabɛŋ gɛ̂ɛne. Bɛŋ jîŋɛ bɛŋ yɛ̂ŋ, nɛ muh wù gesɛ mɛ wunɛ, wu too wa.” ");
INSERT INTO ncr_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Gɛh no Jiso gɛ̀ baaŋ wu jɛme noo, kimimia Juda wù gɛ̀ bee muh ŋgoo yi booŋ ba Jiso ba yuufe ncho bafɛɛ le mo wu bunɛ. Wu gɛ̀ too bɛ kinchvu ki bamii bo kɛme nyó bɛ bimbuge, gɛ̀ tuŋ bachiji kintanyɛ ba baaŋ baaŋ bɛ bamii ba duunyi banchi mo bamii ba sage woŋ. ");
INSERT INTO ncr_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Gɛ̀ bee muh wù gɛ̀ gesɛ Jiso wu seesɛ wa njiŋɛ bɛ bamii bayu wu jɛmɛ lɛ, “Muh wù nlé ŋgê ŋkfugɛ nshiŋɛ, tu le wu, bɛŋ mo bɛŋ koo, bɛŋ jô bɛŋ gɛ̂ɛne bɛ wu bɛŋ jîiŋe lɛ keefɛ wu legɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","No Juda to noo, wu mo wu gɛɛŋ lo fɛ Jiso le kimimia, wu yɛsɛ wu le lɛ, “Muh wu N'yɛyɛ.” No wu jɛmɛ noo, wu mo wu kfugɛ wu wu shiŋɛ. ");
INSERT INTO ncr_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Bamii baa mo bo koo Jiso, bo fajɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Muh mu wù gɛ̀ lɛme bɛ ba Jiso mo wu bvusɛ nyo yi jɛŋ, wu chuŋ kintuŋ ki nfwa wu kikwɛɛ ki bachiji kintanyɛ yu, ki suunɛ. ");
INSERT INTO ncr_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jiso biih bamii bayu le lɛ, “Bɛŋ to ki bɛŋ kôo mɛ bɛŋ tu bɛŋ too bɛ nyó yi jɛŋ mo bimbuge njɛ bɛŋ too ki bɛŋ kôo nyûme chôŋ? ");
INSERT INTO ncr_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nchi nshee lɛ juu lɛ juu nshiide fɛ yeh yi kintanyɛ le, n'yɛyi bamii jɛ yi Nyo fo fɛ bɛŋ koo mɛ sɛŋ nje la? Geenɛ, finɛ fichii jo kijusɛ ki fi to fi kojɛ no bamii ba ntuŋ wu Nyo gɛ̀ saŋ.” ");
INSERT INTO ncr_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Booŋ ba Jiso ba ŋgoo bachii mo bo noŋ wu fo, bo fɛɛ lo. ");
INSERT INTO ncr_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Chumu wumu bi wu le, wu baaŋ noŋ gɛ fiɛɛ ye le gɛ, wu buu gɛh nyu mwa nju ye le. Bo gɛɛŋ lɛ bo koo tɛ wu, ");
INSERT INTO ncr_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","nju yiyu faanyɛ, wu chinɛ yu wu legɛ kichinɛ kiyɛsɛ. ");
INSERT INTO ncr_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bo mo bo jo Jiso, bo gɛɛŋ bɛ wu fɛ kikwɛɛ ki bachiji kintanyɛ le. Bachiji kintanyɛ ba baaŋ baaŋ bɛ bamii ba sage woŋ mo bamii ba duunyi banchi taashɛ fo. ");
INSERT INTO ncr_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Bo gɛ̀ gɛɛne bɛ Jiso, Bita bii lo ajiŋ je yì ndefe le. Wu gɛɛŋ wu bu fɛ lakfulɛ chi kikwɛɛ ki bachiji kintanyɛ le, wu shii bɛ bamii ba gɛ̀ chiɛɛne la chiyu bo tu bo yɛse ŋgu. ");
INSERT INTO ncr_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bachiji kintanyɛ ba baaŋ baaŋ bɛ bamii bachii ba gɛ̀ sage bansa tu bo goone mwɛɛ mu bo kooyi yi Jiso le mu lé no mû ge ba yûuyɛ lo wu. Geenɛ, bo gɛ̀ baaŋ yɛŋ gɛ fiɛɛ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bamii ba duude bɛɛ jiŋ yi nsa wu chimbiaŋ kune Jiso. Geenɛ, muh jɛme gɛ fiɛɛ fì too fi kooji bɛ fi muh mu gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Bamii bamu gɛ̀ ja bo lɛɛŋ we, bo chu chiboo chimbiaŋ ye ye le bo jɛmɛ lɛ, ");
INSERT INTO ncr_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Bee chi be yu wu duu lɛ wu lé wu gê wu sâ yeh yi kintanyɛ yinɛ yì jonɛ muh wu wuŋ, wu jo aju atade, wu kaasɛ wu jooŋ yimi, jonɛ gɛ muh wu wuŋ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mo no bo gɛ̀ jɛme noo, njɛmɛ wuboo too gɛ wù kooji gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kikwɛɛ ki bachiji kintanyɛ mo ki ja ki lɛɛŋ we a bamii fwe, ki biih Jiso le lɛ, “Gɛ wo kɛme fiɛɛ fì wo chvuu gɛ? Wo yuge gɛ̀ mwɛɛ mù bamii banɛ kooyi ye yo le?” ");
INSERT INTO ncr_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jiso mɛ gɛh jwe wuchile, wu gɛ chvuu fiɛɛ gɛ. Kikwɛɛ ki bachiji kintanyɛ ka ki biih Jiso le lɛ, “Le wo wu le Mbvusɛ wù Nyo gɛ̀ ka wu le Mwa Nyo, Nyo wù ba yuuse?” ");
INSERT INTO ncr_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jiso chvuu lɛ, “Le mɛ. Bɛŋ lé bɛŋ yɛ̂ŋ no muh wù jee che le Mwamuh shii a kibo kinchiɛɛŋ ki Muh wù Kɛme Bvuŋga, bɛŋ ka bɛŋ yɛŋ no wu too yi kimbɛ le fɛwe.” ");
INSERT INTO ncr_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kikwɛɛ ki bachiji kintanyɛ yu noo, wu saayɛ njú ye, wu biih lɛ, “Fiɛɛ baaŋ yu fì besabɛŋ ka be goone lɛ muh lɛɛŋ fɛnɛ wu jɛmɛ, lɛ la? ");
INSERT INTO ncr_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Gɛ bɛŋ yu no wu jode kijusɛ ki Nyo gɛ? Bɛŋ jɛme lɛ la?” Bamii bachii mo bo suunɛ lɛ wu le muh wu ba yuuyɛ lo. ");
INSERT INTO ncr_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bamii bamu kɛ bo chuuyi nchwɛne yi Jiso le, bo kaaŋ ajii awe, bo tu bo kfuunyi wu bɛ muŋko, bo duu lɛ, “Gɛh gêe la muh wu ntuŋ wu Nyo kuŋ mɛɛse.” Bamii ba nchi gɛ̀ ja bo jo Jiso bo kɛ bo suŋe. ");
INSERT INTO ncr_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","No Bita gɛ̀ bee je akuu akuu fɛ lakfulɛ, mwa wù kwɛse wu gɛ̀ lɛne fɛ la chi kikwɛɛ ki bachiji kintanyɛ le ja wu to mbebe ye le. ");
INSERT INTO ncr_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","No wu yɛŋ Bita le wu yɛse ŋgu, wu bijɛ wu nɛ tuŋŋ, wu jɛmɛ lɛ, “Wo tɛ be bee bena Jiso muh wu Nasalɛ wege.” ");
INSERT INTO ncr_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Bita faŋ, wu jɛmɛ lɛ, “Gɛ ŋkee fiɛɛ fì wo jɛme finɛ gɛ. Gɛ ŋkee gɛ.” No wu jɛmɛ noo, wu mo wu ja fo wu gɛɛne fɛ jwe wu kitaŋ le, nyishii mo yi toŋ. ");
INSERT INTO ncr_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mwa wù kwɛse wɛɛ ka wu yɛŋ wu le, wu jɛmɛ bamii ba gɛ̀ lɛme fo le lɛ, “Muh wunɛ le muh mu a bo ntɛnɛɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Bita ka wu faŋ. Kife gɛ̀ doo ki kɛŋsɛ shige, bamii ba gɛ̀ lɛme fo ka bo jɛmɛ Bita le lɛ, “Le nchiɛɛŋ lɛ wo le muh wuboo, nje wo le tɛ muh wu Galalee.” ");
INSERT INTO ncr_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Bita mo wu kaŋ, wu tɛɛŋ loŋ yi kikwɛɛ ke le wu jɛmɛ lɛ, “Gɛ ŋkee muh wunɛ wu bɛŋ jɛme kune wu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kimimia nyishii mo yi toŋ kiŋgane kinfɛɛ. Wu mo wu kwajɛ njɛmɛ wù Jiso be jɛmɛ wu le lɛ, “Nyishii lé yi gê yi tôŋ kiŋgane kinfɛɛ, a wo faŋ wa mɛ kiŋgane kintɛde.” Wu mo wu kɛsɛ kwe wu tu wu beede. ");
INSERT INTO ncr_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","No bvu gɛ̀ yuude bvu too nɛ, bachiji kintanyɛ ba baaŋ baaŋ bɛ bamii ba sage woŋ mo bamii ba duunyi banchi ba Nyo, bɛ bamii bamu bachii ba sage bansa mo bo shii bo chu ntaŋ, bo kaaŋ Jiso, bo jo wu bo gɛɛŋ bo nya chiaaŋ yi Balɛt le. ");
INSERT INTO ncr_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Balɛt biih Jiso le lɛ, “Le wo wu le Nfoŋ Bajuu?” Jiso chvuu wu le lɛ, “Le no wo jɛme.” ");
INSERT INTO ncr_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bachiji kintanyɛ ba baaŋ baaŋ kɛ bo tu bo chuunyi mwɛɛ ye yi Jiso le wesee. ");
INSERT INTO ncr_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Noo, Balɛt ka wu biih Jiso le lɛ, “Gɛ wo kɛme fiɛɛ fì wo chvuu gɛ? Wo yuge gɛh mwɛɛ mù ba chuunyi yi ye yo le?” ");
INSERT INTO ncr_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Geenɛ Jiso gɛ chvuu lo fiɛɛ wu le gɛ. Jwe yuŋ Balɛt. ");
INSERT INTO ncr_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ge to nyume kife ki Ŋka wu Ndaŋfe wunɛ le, Balɛt bvusɛ muh wu ncha wù mumwaa yeh yi ncha le wù bamii le bo lɛgɛ. ");
INSERT INTO ncr_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Gɛ̀ bee kife kiyu le, muh mu nyu yeh yi ncha le jee che nyu lɛ Balaba, wu nyu ŋgoo yi bamii ba gɛ̀ bee yeh yi ncha le ba gɛ̀ kɛ ŋgɛ alaantɛŋ bo yuuyɛ bamii. ");
INSERT INTO ncr_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kinchvu ki bamii mo ki to ki kɛ ki biide lɛ Balɛt ge gɛh no wu to wù gee fɛ bo le. ");
INSERT INTO ncr_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Balɛt biih bo le lɛ, “Bɛŋ goone lɛ mbvusɛ nyu Nfoŋ wu Bajuu?” ");
INSERT INTO ncr_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Wu gɛ̀ biide noo nje wu gɛ̀ kee lɛ bachiji kintanyɛ ba baaŋ baaŋ le bo nya Jiso chiaaŋ ye le nje bo gɛ̀ bɛɛne kindoŋ bɛ wu. ");
INSERT INTO ncr_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Geenɛ, bachiji kintanyɛ ba baaŋ baaŋ bɛɛsɛ kinchvu ki bamii lɛ bo du lɛ wu bvusɛ nyu Balaba. ");
INSERT INTO ncr_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Balɛt ka wu biih bo le lɛ, “Ndoo mbvusɛ noo, ŋge nɛɛ bɛ muh wunɛ wù bɛŋ tɛŋe lɛ Nfoŋ wu Bajuu?” ");
INSERT INTO ncr_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bo mo bo waŋ lo fɛwɛɛwe lɛ, “Ba tâ lo wu yi kintaaŋ le.” ");
INSERT INTO ncr_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Balɛt biih bo le lɛ, “Ba ta wu nje la? Fiɛɛ fì befe fì wu ge le la?” Bo ka bo wanɛ bo gɛɛne gɛh lo fwe lɛ, “Ba tâ wu yi kintaaŋ le.” ");
INSERT INTO ncr_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Noo, Balɛt mo wu bvusɛ Balaba nje wu gɛ̀ goone ki wu gê no kinchvu goone. Wu jɛmɛ ba taaŋ Jiso, bo mo bo nya lɛ ba gɛɛŋ ba ta yi kintaaŋ le. ");
INSERT INTO ncr_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Bamii ba nchi baa mo bo jo Jiso bo lee bo gɛɛŋ bɛ wu a nto fɛ ba gɛ̀ tɛŋe lɛ Bletoliuŋ. Lɛ bo lee, bo mo bo kuŋ kimbɛge ki ŋgoo yi bamii ba nchi bachii bo taashɛ. ");
INSERT INTO ncr_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bo mo bo jo nju yi bvunfoŋ bo susɛ wu ye le, bo ka bo lu kifo ki bvunfoŋ ki nyu mbiaŋmbiaŋ bo booŋ a wu fwa. ");
INSERT INTO ncr_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bo kɛ bo buune wu bo duu lɛ, “Biaa yi bimbaaŋ. Nfoŋ Bajuu.” ");
INSERT INTO ncr_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","No bo gee noo bo tu bo suŋe wu bɛ kimbaŋ yi kikwɛɛ le, bo chuuyi wu bɛ chwɛne ye ye le, bo too bo tumɛ anyuu a wu jii, bo buune wu. ");
INSERT INTO ncr_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bo gɛ̀ chwɛɛsɛ wu noo bo mɛsɛ, bo kaasɛ bo baa nju yi bvunfoŋ chiɛɛ, bo jii njú ye, ye ye le, bo mo bo jo wu bo gɛɛne bɛ wu ki bo gɛɛŋ bo ta yi kintaaŋ le. ");
INSERT INTO ncr_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Bo doo bo gɛɛne, bo tasɛ bɛ muh mu wu kwɛɛde nchvuuŋ jee che nyu lɛ Samoŋ, gɛ̀ bee muh wu Sɛliŋ. Wu gɛ̀ bee chiji Alɛksanda bɛ Lufu. Bo mo bo tooŋsɛ wu lɛ wu tuu kintaaŋ ki Jiso. ");
INSERT INTO ncr_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bo tu bo gɛɛne bɛ Jiso bo gɛɛŋ bo bu kijusɛ kimu ki ba tɛŋe lɛ Golgota le, (Jee chinɛ le lɛ Ŋgboge wu Kikwɛɛ), ");
INSERT INTO ncr_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","bo mo bo nya mbvuuŋ ma ba fiiŋsɛ bɛ nche yimi ba tɛŋe lɛ mɛɛl. Geenɛ Jiso gɛ mu gɛ. ");
INSERT INTO ncr_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bo mo bo ta wu yi kintaaŋ le. Ba jo njú ye ki bo ga bikwɛɛ biboo le, bo tuŋ kaŋ bɛ njú yiyu ki bo kɛɛ muh wu jo. ");
INSERT INTO ncr_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kife ki ba gɛ̀ ta Jiso yi kintaaŋ le gɛ̀ bee juu bikaa bvuugɛ ataana. ");
INSERT INTO ncr_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bo saŋ ŋwa wu duunyi fiɛɛ fì bo ta wu yi kintaaŋ le nje fi lɛ, wu le, “Nfoŋ wu Bajuu.” ");
INSERT INTO ncr_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ba gɛ̀ ta tɛ bachoŋ bafɛɛ yi bintaaŋ le, wumu a kibo ki Jiso kinchiɛɛŋ le, wumu a kibo ke kiŋkoŋo le.  ");
INSERT INTO ncr_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Fi mo fi kojɛ no ba gɛ̀ saŋ a Ŋwa wu Nyo le lɛ, “Ba gɛ̀ ta wu bɛ bamii ba befe.” ");
INSERT INTO ncr_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bamii tu bo fede bo yɛde Jiso le bo bɛme bɛ bikwɛɛ, bo baade wu bɛ banchuŋ bo duu lɛ, “Ahaaa! Wo wù chi bee ki wo sâ yeh yi kintanyɛ wo kaasɛ wo jooŋ yi aju le atade, ");
INSERT INTO ncr_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","gɛh fi la kikwɛɛ kuŋ wo shii yi kintaaŋ kɛɛ le.” ");
INSERT INTO ncr_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bachiji kintanyɛ ba baaŋ baaŋ bɛ bamii ba duunyi banchi ba Nyo tu bo buu tɛ wu lɛbolɛbo bo duu lɛ, “Wu chi fii bamii bamu njɛ wu taŋlo wu fi kikwɛɛ ke sɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Wu, wu le Mbvusɛ wu Nyo gɛ̀ ka, wù le Nfoŋ wu bamii ba Ishwala, wu shîi la yi kintaaŋ le mɛɛse bee yɛŋ bee mo be bɛɛŋ wu le.” Bamii baa ba bo gɛ̀ ta yi bintaaŋ le bɛ Jiso tu bo baade tɛ wu bɛ banchuŋ. ");
INSERT INTO ncr_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Juu gɛ̀ bɛɛŋ chi leesɛ, akfuuŋ ja ajiiŋ woŋ wuchii gɛɛne bude juu bikaa bitɛde fɛnshɛ. ");
INSERT INTO ncr_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Lɛ to nyume juu bikaa bitɛde, Jiso ja wu jaŋ fɛwɛɛwe lɛ, “Ɛloy, Ɛloy lama sabatani.” Fì le lɛ, “Nyo waŋ, Nyo waŋ, wo noŋ mɛ nɛ nje la?” ");
INSERT INTO ncr_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bamii bamu ba gɛ̀ lɛme fo doo bo yu, bo jɛmɛ lɛ, “Bɛŋ yêgɛ bɛŋ yû, wu tɛŋe Alaja.” ");
INSERT INTO ncr_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Muh mu bo le ja wu legɛ wu jo kfusha, wu fuuŋ a mbvuuŋ ma ŋgbwamɛ le, wu booŋ yi finte le wu chiaasɛ lɛ wu mu, bo mo bo jɛmɛ lɛ, “Gɛh lɛ̂ɛŋ nɛ besabɛŋ yɛŋ laa Alaja le wu to wu shiishɛ wu yi kintaaŋ kinɛ le lɛ.” ");
INSERT INTO ncr_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jiso ja wu waŋ fɛwɛɛwe wu mo wu yɛnɛ n'yɛnɛ wu kimaga. ");
INSERT INTO ncr_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nju yì gɛ̀ gade yeh yi kintanyɛ antɛŋ badɛ antɛnɛɛ kɛge fɛwe boge bude fɛkuu bimbe bifɛɛ. ");
INSERT INTO ncr_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Chiji kikwɛɛ ki bamii ba nchi wù gɛ̀ lɛme a Jiso fwe doo wu yɛŋ je yì Jiso kwe yi le, wu mo wu jɛmɛ lɛ, “Nchiɛɛŋ nchiɛɛŋ, muh wunɛ chi bee Mwa Nyo.” ");
INSERT INTO ncr_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bikɛse bamu gɛ̀ lɛme fo je yì ndefe le bo jiiŋe. Ŋgoo yiboo gɛ̀ bee Mɛɛle Madaleŋ bɛ Mɛɛle wù bwe Jɛm wù shige bɛ Yosɛf, wumu nyu Salome. ");
INSERT INTO ncr_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Bikɛse banɛ le ba gɛ̀ bii Jiso le Galalee bo fii wu. Bo gɛ̀ bee fo bɛ bikɛse bamu tɛ wesee ba gɛ̀ bi Jiso le bɛ bo to Yɛlusalɛm. ");
INSERT INTO ncr_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Gɛ̀ bee wa fɛnfu abvu, no gɛ̀ bee Juu chi Nseesɛ ki bo lee yi juu chi yuuŋ le, ");
INSERT INTO ncr_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","muh mu wu Alimatia wù ba gɛ̀ tɛŋe lɛ Yosɛf, kaaŋ fitele wu gɛɛŋ wu yɛŋ Balɛt le ki wu lɛ̂gɛ gvunɛ chi Jiso wu gɛɛŋ wu jiiyɛ. Yosɛf wunɛ gɛ̀ bee ŋgoo yi bamii ba sage woŋ, bamii gɛ̀ ŋgvuune wu chuule. Wu kibɛɛ gɛ̀ chiɛɛne tɛ kife kì bvunfoŋ bvu Nyo lé bvu gê bvu tô ");
INSERT INTO ncr_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Balɛt yu, jwe yuŋ lo wu lɛ Jiso be wu kwe wa. Wu tɛɛŋ kikwɛɛ ki bamii ba nchi kɛɛ ki to, wu biih wu le laa Jiso be wu kwe wa lɛ. ");
INSERT INTO ncr_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Wu doo wu yu a kikwɛɛ ki bamii ba nchi kiyu le lɛ Jiso be wu kwe wa, wu mo wu nya gvunɛ chiyu Yosɛf le. ");
INSERT INTO ncr_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yosɛf mo wu ja wu gɛɛŋ wu gu nju yì joŋe, wu gɛɛŋ wu shiishɛ gvunɛ chi Jiso, wu baŋɛ a nju le, wu gɛɛŋ wu giŋsɛ a jɛŋ yì ba cho yi kimbaaŋ le, wu biŋsɛ kibwee ki tɛdɛ wu baŋɛ jwe wu jɛŋ yɛɛ yu. ");
INSERT INTO ncr_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mɛɛle Madaleŋ bɛ Mɛɛle wù bwe Yosɛf yɛŋ kijusɛ ki ba jiiyɛ Jiso fo. ");
INSERT INTO ncr_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Juu chi yuuŋ gɛ̀ fe, Mɛɛle Madaleŋ bɛ Mɛɛle wu bwe Jɛm, mo Salome gu mɛɛ mà gwee wuŋ ki bo gɛɛŋ bo yefɛ gvunɛ chi Jiso yu. ");
INSERT INTO ncr_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Gɛ̀ bee baaŋ lo ataana gɛh no nshwa muu ta yi juu chi fwe chi kimaa le, bo ja bo gɛɛne fɛ jɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bo doo bo gɛɛne noo bo mo bo jɛme lɛbolɛbo lɛ laa le biŋsɛ yɛɛŋ tɛdɛ chì ba chi baŋɛ jwe wu jɛŋ yu fɛ bo lee la? ");
INSERT INTO ncr_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Geenɛ bo doo bo noŋ ajii, bo yɛŋ a ba biŋsɛ wa tɛdɛ chiyu. Tɛdɛ chinɛ gɛ̀ bee lo kibwee ki tɛdɛ. ");
INSERT INTO ncr_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Bo doo bo lee bo gɛɛŋ a jɛŋ, bo yɛŋ chumu wumu le wù nyu wu shii kibo kinchiɛɛŋ le wu noŋ nju yì ndefe, yi baaŋ. Ye kuufɛ bo nɛ wuuu. ");
INSERT INTO ncr_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Chumu wuyu jɛmɛ bo le lɛ, “Keefɛ jwe yûŋ bɛŋ gɛ. Ŋkee lo lɛ bɛŋ goone nyu Jiso wu Nasalɛ wù ba chi ta yi kintaaŋ le. Gɛ wu baaŋ fɛnɛ gɛ. Wu le wu bu wa yi kwe le. Bɛŋ jîŋɛ bɛŋ yɛ̂ŋ fɛ ba chi giŋsɛ wu fo. ");
INSERT INTO ncr_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Bɛŋ gɛ̂ɛŋ bɛŋ sɛ̂ɛŋ booŋ be ba ŋgoo le, mo Bita lɛ wu le wu sa wa bɛŋ fwe Galalee. Bɛŋ lé bɛŋ gɛ̂ɛŋ bɛŋ yɛ̂ŋ wu le yo no wu gɛ̀ jɛmɛ wa bɛŋ le.” ");
INSERT INTO ncr_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Bikɛse baa bu a jɛŋ bo shiŋshi nɛ kikikiki, bo ja bo fɛɛ lo nje jwe gɛ̀ yuŋ bo nɛ kah. Bo gɛ̀ jɛmɛ fiɛɛ muh le gɛ, nje bo gɛ faane lo.  ");
INSERT INTO ncr_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jiso gɛ̀ bu yi kwe le juu chi fwe chi kimaa le baaŋ kibilebile le, wu ya wu bunɛ nyu fɛ Mɛɛle Madaleŋ wù wu gɛ̀ bvusɛ banchɛndaa ba debele ye ye le bvusooshwi. ");
INSERT INTO ncr_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mɛɛle mo wu gɛɛŋ wu sɛɛŋ bamii ba bɛ ba Jiso gɛ̀ kɛ bo nyume le. Bamii banɛ gɛ̀ shii bo beede bo soge bikwɛɛ. ");
INSERT INTO ncr_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Bo doo bo yu no kwɛse wɛɛ duu lɛ wu be wu yɛŋ Jiso le, lɛ wu le yu, bo gɛ bɛɛŋ gɛ mbɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ajiŋ ayu Jiso ka wu dunyɛ ye ye bamii be bamu ba ŋgoo le bafɛɛ bo gɛɛne ntɛ wumu le, nfiɛɛnɛ ye nyu yi kusɛ wa. ");
INSERT INTO ncr_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bo tu jiŋ, bo gɛɛŋ bo sɛɛŋ kimbɛge ki bamii ba ŋgoo le, bo faŋ ki bo bɛɛŋ bo le. ");
INSERT INTO ncr_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ajiŋ ayu Jiso dunyɛ ye ye nyu wa booŋ be ba yuufe ncho wu mumwaa le kibɛɛ bɛ bo jii mwɛɛ. Wu sa bo, nje bo gɛ̀ kɛme gɛ mbɛmɛ gɛ, bo tɛɛme bikwɛɛ ki bo bɛɛŋ bamii ba gɛ̀ yɛŋ wu le sege wù gɛ̀ bu yi kwe le. ");
INSERT INTO ncr_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Wu mo wu jɛmɛ bo le lɛ, “Bɛŋ gɛ̂ɛŋ woŋ le wuchii, bɛŋ gɛ̂ɛŋ bɛŋ fêeji saaka wù joŋe wù le wu Nyo bamii le bachii. ");
INSERT INTO ncr_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Muh wù bɛɛŋ saaka wuyu le, ba leesɛ wu a joo, lé wu gê wu bônɛ. Muh wù baaŋ bɛɛŋ gɛ, lé wu gê wu gwê nsa. ");
INSERT INTO ncr_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Bamii ba bɛɛŋ lé bo gê bo gêe mwɛɛ mù duunyi bvuŋga bvu Nyo njɛ munɛ: Bo lé bo gê bo bvûuse banchɛndaa ba debele yi bamii le, a jee chaŋ le. Bo lé bo gê bo jɛ̂me jɛ́ yì fiɛŋ. ");
INSERT INTO ncr_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bo lé bo jîji yó le bɛ chiaaŋ. Nɛ bo mu nlo, wu gɛ ge fiɛɛ bɛ bo gɛ. Bo lé bo gɛ̂ɛde chiaaŋ yi bamii ba chɛne le, bo tɛɛme.” ");
INSERT INTO ncr_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tada Jiso jɛmɛ bo le noo wu mɛsɛ, Nyo mo wu jo wu, wu bɛɛŋ we wu shii a kibo ki Nyo kinchiɛɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Booŋ be ba ŋgoo mo bo bu bo tu bo jiɛnyi bo feeji saaka wù joŋe manjuu le manchii. Tada lɛne bɛ bo wu toone fiɛɛ fì bo gɛ̀ feeji lɛ le nchiɛɛŋ bɛ mwɛɛ mù duunyi bvuŋga bvu Nyo, mù bo gɛ̀ gee.");
INSERT INTO ncr_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Muh wù baaŋ Teofilus, bamii ba duude le bo moŋ wa ki bo saŋ kune mwɛɛ mu gɛ̀ kooshɛ a bee ntɛnɛɛ. ");
INSERT INTO ncr_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ba gɛ̀ saŋ mwɛɛ munɛ gɛh yɛɛŋyɛɛŋ no bee gɛ̀ yu wa a bamii ba gɛ̀ yɛde bɛ ajii aboo, bo ka feeji saaka wɛɛ no mu gɛ̀ kɛ. ");
INSERT INTO ncr_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","No nle njo wa kife ki ntaa mwɛɛ munɛ munchii kɛge fɛŋkɛɛ, mo n'yɛŋ lɛ, fi joŋe lɛ mbanyɛ nsaŋ tɛ fɛ wo le a je yì kooji le. ");
INSERT INTO ncr_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ŋge finɛ lɛ wo kɛ̂ɛ kinchiɛɛŋ wu mwɛɛ mù ba gɛ̀ fejɛ wa wo le. ");
INSERT INTO ncr_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Sege Nfoŋ Hɛlod gɛ̀ sage woŋ wu Judia, chiji kintanyɛ wumu gɛ̀ bee jee che nyume lɛ Sakiya. Wu gɛ̀ lɛne a kinchvu ki bachiji kintanyɛ ba Abija le, kwɛɛ gɛ̀ bu tɛ a kfuu chi Aloŋ le, ba tɛŋe wu lɛ Alisabɛ. ");
INSERT INTO ncr_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bamii ba bafɛɛ banɛ gɛ̀ bee bamii ba chaaŋ a Nyo jii, bo gɛɛde banchi ba Tada bachii, bo kɛme gɛ jialɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Geenɛ, bo gɛ̀ kɛme gɛ mwa gɛ, nje Alisabɛ gɛ̀ bee kaa, bo bachii gɛ̀ bee bo juŋ wa. ");
INSERT INTO ncr_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kife gɛ̀ to ki kojɛ, ki kinchvu ki Sakiya bo lɛne yeh yi kintanyɛ yi Tada le. Wu gɛ̀ bee chiji kintanyɛ a Nyo jii abvu, ");
INSERT INTO ncr_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","bo gɛ̀ baa wu, bii no bo to bo baade bachiji kintanyɛ yi kinche kiboo le. Wu mo wu lee yeh yi kintanyɛ le, ki wu tôŋ jiiŋ. ");
INSERT INTO ncr_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kife gɛ̀ kojɛ kì wu toŋ jiiŋ, bamii bachii ba gɛ̀ bee akfuuŋ, buune. ");
INSERT INTO ncr_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nchɛndaa wu Tada ja wu bunɛ a wu jii, wu lɛɛŋ kibo kinchiɛɛŋ ki kitana ki jiiŋ le. ");
INSERT INTO ncr_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sege Sakiya gɛ̀ yɛŋ wu le, njaŋ koo wu, wu kɛmɛ nfaaŋ baaŋ. ");
INSERT INTO ncr_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Geenɛ, nchɛndaa wɛɛ jɛmɛ wu le lɛ, “Keefɛ wo fâane gɛ. Nyo le wu yu wa buunɛ chuŋ. Kwoo, wu Alisabɛ lé wu tô wu bôo mwa wù jwɛŋsɛ, wo nya jee che lɛ Joŋ. ");
INSERT INTO ncr_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wu lé wu gê wu tô bɛ kinlaŋye fɛ wo le, bamii ba duude le bo yuge njoŋ nje boyɛ che. ");
INSERT INTO ncr_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Wu lé wu gê wù nyû muh wù baaŋ a Nyo jii. Keefɛ wu yu wu to wu muu mbvuuŋ gɛ, fɛ nyume mo ma tɛɛme gɛ. Kiyo ki Yuude lé ki gê ki yîsɛ ye ye le wu baaŋ a bwee shɛŋ. ");
INSERT INTO ncr_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Wu lé wu gê bamii ba Ishwala ba duude bo kusɛ muntele muboo bo kaasɛ bo tu bɛ Tada wù Nyo wuboo. ");
INSERT INTO ncr_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Wu lé wu sâ fwe a Tada bɛ fitele mo bvuŋga bvu Alaja, ki wu kûsɛ muntele mu bachiji booŋ, mu nyu yi booŋ baboo le. Wu lé wu gê bamii ba tɛɛme bintuŋ chinɛ bintuŋ bi tɛmɛ le, bo kusɛ kinche kiboo, bo kɛme baŋkwajɛ nyu ba bamii ba chaaŋ. Wu lé wu gê noo, lɛ bamii nyû bo seesɛ bo chiɛɛne Tada.” ");
INSERT INTO ncr_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakiya biih nchɛndaa wu Nyo le lɛ, “Fiɛɛ fì yu fi ge ŋkɛɛ, besa kwaaŋ nyu bee juŋ wa nɛ, le la?” ");
INSERT INTO ncr_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nchɛndaa Nyo wɛɛ chvuu lɛ, “Le mɛ wù Gabliya, nlɛme bvushi bvu Nyo le segechii, nyu wu wù tuŋ mɛ ki nto nsɛɛŋ wo saaka wù joŋe wunɛ. ");
INSERT INTO ncr_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Bîjɛ yɛ̂ŋ, no wo baaŋ bɛɛŋ gɛ̀ saaka wunɛ le gɛ, kife lé ki tô ki kojɛ kì fi kɛmɛ ki fi kooshɛ, wo lé wo tû kinchifɛ, wo gɛ ka wo jɛme gɛ, gɛɛŋ bu sege fiɛɛ finɛ lé fi kôoshɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","No fi gɛ̀ kooshi noo, bamii ba gɛ̀ lɛme akfuuŋ bo chiɛɛne Sakiya bo kɛmɛ lo ŋgha laa le la fì ge wu she yu baaŋ nɛ lɛ. ");
INSERT INTO ncr_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sege wu gɛ̀ bu yu, wu ka kee gɛ ki wu jɛ̂me bo le gɛ. Bo mo bo kɛɛ lɛ Nyo le wu dunyɛ fiɛɛ fì ghage wu le yu. Wu mo wu fege lo mwɛɛ bɛ chiaaŋ, wu ya jɛme gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sakiya gɛ̀ mɛsɛ lɛme che yeh yi kintanyɛ le, wu mo wu kaasɛ wu tu jiŋ fɛ wu kfuuŋ. ");
INSERT INTO ncr_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Aju gɛ̀ fe, kwɛɛ wu Alisabɛ kɛmɛ fwe, wu mo wu nyume yeh yeh yi kii le yitɛŋ. ");
INSERT INTO ncr_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Alisabɛ mo wu jɛmɛ lɛ, “Mɛɛse Tada le wu koo wa yii fɛ mɛne, wu bvusɛ bvuya yi kikwɛɛ kaŋ le.” ");
INSERT INTO ncr_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Fwe chi Alisabɛ gɛ̀ bu kii bvusoo, Nyo tuŋ nchɛndaa we wù Gabliya ntɛ wumu wu Galalee le jee nyume lɛ Nasalɛ. ");
INSERT INTO ncr_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Wu gɛ̀ gɛɛŋ bɛ ntuŋ fɛ ŋgooŋ kwɛse wumu le jee che nyume lɛ Mɛɛle, wu baaŋ mwa wuchile. Wu ge bee ba seesɛ wa lɛ wu lé wu nyûme kwɛ Yosɛf wu a kfuu chi Nfoŋ Dabi le. ");
INSERT INTO ncr_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nchɛndaa wu Nyo wɛɛ gɛɛŋ wu yɛŋ Mɛɛle le, wu jɛmɛ wu le lɛ, “N'yɛsɛ wo le! Tada le wu baa wo wu ka nyume bɛ wo.” ");
INSERT INTO ncr_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mɛɛle yu fi ya wu baaŋ, wu tu wu maŋe laa kfuu chi wunɛ n'yɛsɛ le wu nɛɛ nɛ lɛ. ");
INSERT INTO ncr_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Geenɛ, nchɛndaa wu Nyo jɛmɛ wu le lɛ, “Mɛɛle fɛ wo fâane gɛ, Nyo le wu cha wo. ");
INSERT INTO ncr_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Bîjɛ yɛ̂ŋ, wo lé wo gê wo kɛ̂me fwe, wo boo mwa wù jwɛŋsɛ, wo nya jee lɛ Jiso. ");
INSERT INTO ncr_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Wu lé wu gê wu nyû muh wù baaŋ, ba lé ba tɛ̂ŋe wu lɛ Mwa Nyo, Nyo wu le Kikwɛɛ ki Mwɛɛ Munchii. Tada Nyo lé wu gê wu shîishɛ wu yi kala wu Nfoŋ Dabi wu chiji kfuu chiboo le. ");
INSERT INTO ncr_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Wu lé wu sâge kfuu chi Yakob segechii, gɛ bvunfoŋ bwe nyu bvu to bvu ka gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mɛɛle biih nchɛndaa wu Nyo le lɛ, “Finɛ lé fi fê nɛɛ, mbaaŋ mwa wuchile.” ");
INSERT INTO ncr_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nchɛndaa wu Nyo chvuu wu le lɛ, “Kiyo ki Yuude lé ki tô yi ye yo le, bvuŋga bvu Nyo wu le Kikwɛɛ ki Mwɛɛ Munchii ki ge ki yisɛ yi ye yo le. Noo, mwa wu wo lé wo gê wo bôo le wu yuude, ba mo ba tɛŋe wu lɛ Mwa Nyo. ");
INSERT INTO ncr_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Bîjɛ wo yɛ̂ŋ, mwa bwee chijo wù Alisabɛ wu le wu nyuufɛ wa wu juŋ ba chi tɛŋe wu lɛ kaa, wu le mɛɛse bɛ fwe kii bvusoo, wu lé wu bôo mwa wù jwɛŋsɛ. ");
INSERT INTO ncr_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Gɛ fiɛɛ nyu yu fì taŋlo fi ya Nyo gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mɛɛle mo wu jɛmɛ lɛ, “Nɛ mɛ wunɛ fɛnɛ wu le mwa lɛme wu Nyo. Wu gê, fi kôoshɛ bɛ mɛ no wo jɛme.” No wu jɛme noo, nchɛndaa wu Nyo mo wu ja. ");
INSERT INTO ncr_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Gɛh aju ayu le, Mɛɛle seesɛ wu ja wu mo wu yaŋse wu gɛɛne ntɛ wumu wu woŋ wu mbegɛ wu Juda le, ");
INSERT INTO ncr_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","wu gɛɛŋ wu bu yo, wu lee a Sakiya ye wu yɛsɛ kwɛɛ wù Alisabɛ le. ");
INSERT INTO ncr_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","No Alisabɛ gɛ̀ yu n'yɛsɛ wu Mɛɛle, mwa jaŋɛ a wu shɛŋ baaŋ. Kiyo ki Yuude yisɛ yi ye ye le. ");
INSERT INTO ncr_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Wu mo wu wulɛ fɛwɛɛwe, wu jɛmɛ lɛ, “Kimbonɛ ki Nyo le yi ye yo le fede bikɛse bachii, kimbonɛ ke le yi mwa wu wo lé wo bôo le. ");
INSERT INTO ncr_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Finɛ fiɛɛ fì baaŋ jiɛnyi nɛɛ nɛ, lɛ bwe Tada waŋ le wu la jigɛ a mɛne? ");
INSERT INTO ncr_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Bîjɛ wo yɛ̂ŋ, sege mbe n'yu n'yɛsɛ wo, mwa mo wu jaŋɛ a mɛ shɛŋ bɛ kinlaŋye kì baaŋ. ");
INSERT INTO ncr_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kinlaŋye kì baaŋ le fɛ wo le, nje wo le wo bɛɛŋ lɛ ŋka wù Nyo gɛ̀ ka wo lé wu tô wu kôjɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mɛɛle jɛmɛ lɛ, “Fitele fiaŋ yuuse Tada Nyo, ");
INSERT INTO ncr_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","shɛ́ŋ yaŋ yuge njoŋ nje Nyo wu le Mbvusɛ waŋ. ");
INSERT INTO ncr_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Wu le wu kwajɛ mɛ, nle gɛh lo muh we wu lɛme wu nchɛ. Kɛge yi mɛɛse le gɛɛne lo, kiŋgogɛ kichii lé ki jɛ̂me lɛ, Nyo le wu noŋ kimbonɛ yi ye yaŋ le, ");
INSERT INTO ncr_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","nje Nyo wu Bvuŋga Bvuchii le wu ge wa mwɛɛ mù baaŋ baaŋ fɛ mɛne. Gɛ jee che taŋlo ba beji bɛ chimi gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Wu koode yii fɛ bamii ba ŋgvuune wu le. Yii yinɛ le fɛ kiŋgogɛ le kichii. ");
INSERT INTO ncr_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Wu le wu dunyɛ bvuŋga bvu kibo ke, wu taashɛ bamii ba chiaase ye, bantaŋ baboo bo laayɛ. ");
INSERT INTO ncr_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wu le wu shwa wa banfoŋ ba baaŋ baaŋ yi bakala le, wu bɛɛŋsɛ nyu bamii ba nchɛ nchɛ. ");
INSERT INTO ncr_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wu le wu nyaŋɛ wa bamii ba jɛŋ yuu bo, bo fuu bɛ mwɛɛ mù joŋe, wu kuŋ ba kwa bo gɛɛŋ chiaaŋ chiaaŋ. ");
INSERT INTO ncr_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Wu le wu fi muh we wu lɛme wù Ishwala, wu kwajɛ ki wu kôo yii fɛ Ablaham bɛ kfuu che le, gɛɛne mɛɛse gɛh no wu gɛ̀ ka wa bɛ bachiji chiji besa.” ");
INSERT INTO ncr_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","No Mɛɛle jɛmɛ noo, wu che bɛ Alisabɛ kii yi tɛdɛ fɛ wu kaasɛ wu tu jiŋ fɛ wu kfuuŋ. ");
INSERT INTO ncr_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kife ki Alisabɛ ki boyɛ gɛ̀ to ki kojɛ, wu boo mwa wu jwɛŋsɛ. ");
INSERT INTO ncr_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kfuu che, bɛ bamii ba gɛ̀ chee kimbe kɛɛ le, yu lɛ Tada le wu koo yii fɛ wu le baaŋ, bɛ bo tu bo laŋeye. ");
INSERT INTO ncr_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Aju gɛ̀ to a bu nyaaŋ, ba to lɛ ba chvuu mwa yeh, bo mo bo goone ki bo chu jee lɛ Sakiya nyu jee chi chiji, ");
INSERT INTO ncr_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","geenɛ bwee faŋ, wu jɛmɛ lɛ ba tɛ̂ŋe wu lɛ Joŋ. ");
INSERT INTO ncr_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bo jɛmɛ wu le lɛ “Gɛ muh nyu yu a kfuu chena le bɛ jee chinɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Bo ja bo fege bɛ chiaaŋ chiji mwa le, ki bo kɛɛ laa wu be goone lɛ ba chu jee chi mwa lɛ yɛɛŋ la. ");
INSERT INTO ncr_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Wu mo wu fe tɛ, lɛ ba to bɛ fiɛɛ wu saŋ yu we. Lɛ ba to bɛ fi wu mo wu saŋ lɛ, “Jee che le Joŋ.” Bo yɛŋ noo jwe yuŋ bo. ");
INSERT INTO ncr_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kimimia, jwe wu Sakiya mo wu gwenyɛ, lɛmɛ che yaafɛ, wu kaasɛ wu tu wu jɛme. Wu mo wu kɛ wu tume maŋkuŋ ma Nyo. ");
INSERT INTO ncr_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Bamii ba ntɛ wuyu le kɛmɛ ŋgha baaŋ. Saaka wu mwɛɛ munɛ munchii saaŋe wu gɛɛŋ woŋ wu mbegɛ wu Judia wuyu le wuchii. ");
INSERT INTO ncr_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bamii bachii ba gɛ̀ yu mwɛɛ munɛ munchii bo kɛmɛ faaŋ bo biide laa wunɛ mwa lé wu yu wu tô wu nyume nɛɛ lɛ, nje fi gɛ duunyi lɛ kimbonɛ ki Nyo le yi ye ye le. ");
INSERT INTO ncr_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Kiyo ki Yuude ja ki yisɛ ye yi Sakiya wu chiji Joŋ le, wu mo wu kɛ wu jɛme njɛ muh wu ntuŋ wu Nyo, wu duu lɛ, ");
INSERT INTO ncr_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Besabɛŋ bɛ̂ɛŋse Tada Nyo wu bamii ba Ishwala. Wu le wu to wa ki wu sûuŋ bamii be yi ŋgɛ le. ");
INSERT INTO ncr_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Wu le wu gɛɛ wa muh we wu bvuŋga wù lé wu gê besabɛŋ bônɛ, wu bu kfuu chi muh we wu lɛme wù Nfoŋ Dabi le. ");
INSERT INTO ncr_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Finɛ le no wu gɛ̀ ka wa jwe wu bamii be ba ntuŋ ba yuude le baaŋ lo nchensɛŋ no wu gɛ̀ gɛlɛ, ");
INSERT INTO ncr_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","lɛ wu lé wu bvûsɛ bee chiaaŋ yi bamii ba goone ki bo lɛɛshɛ bee le, mo bamii besa ba kimbanɛ. ");
INSERT INTO ncr_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Wu gɛ̀ ka lɛ wu lé wu kôo yii fɛ bachiji chiji besa le, wu mo wu chee wu kwaji maŋkaŋ mɛ mà wu gɛ̀ gwo bɛ Nyo. ");
INSERT INTO ncr_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Wu gɛ̀ ka fɛ Ablaham wù chiji bachiji besa wu ji leh lɛ, ");
INSERT INTO ncr_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","wu lé wu gê wu bvûsɛ bee chiaaŋ yi bamii besa ba kimbanɛ le, lɛ besabɛŋ lɛ̂ne wu le bee ya faane gɛ, ");
INSERT INTO ncr_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","besabɛŋ chêe kinche kì yuude bɛ kì chaaŋ a wu jii aju achii yi nshilɛ wese le. ");
INSERT INTO ncr_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Wo wù mwa yaŋ ba lé ba tɛ̂ŋe wo lɛ muh wu ntuŋ wu Nyo, Nyo wu le Kikwɛɛ ki Mwɛɛ Munchii, nje wo lé wo sâ fwe a Tada ki wo sêesɛ je ye. ");
INSERT INTO ncr_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Wo lé wo fêeji bamii be je yì taŋlo bo kɛmɛ mbvusɛ yu, fì le nlɛɛshɛ wù Nyo lé wu gê wu lɛ̂ɛshɛ bimbefɛ biboo, ");
INSERT INTO ncr_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","nje yii yì baaŋ yì wu kole fɛ bamii le. Wu lé wu chîiŋsɛ Mbvusɛ wu shiide wu too we gɛh njɛ juu fɛ chi le chi saaŋ. ");
INSERT INTO ncr_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Wu lé wu nyâ n'yuu bamii ba le yi kijibɛ le mo bamii ba le jwe wu kwe le, wu mo wu gɛɛ besabɛŋ je yì kimbonɛ le.” ");
INSERT INTO ncr_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mwa Sakiya wɛɛ mo wu tu wu kuu yi nyaŋ yi ye le, wu kuu tɛ a kiyo le. Wu mo wu ja wu gɛɛŋ wu tu wu chee nyu nchvuuŋ, gɛɛŋ bu juu chì wu gɛ̀ bu ki wu dûnyɛ kikwɛɛ ke bamii ba Ishwala le. ");
INSERT INTO ncr_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Gɛ̀ bee kife kɛɛ le, nchi bu lɛ ba saŋ maŋkuŋ ma bamii bachii ba le yi bituŋ bi woŋ wu Lum le. Wu gɛ̀ bu a Kaisa Augustu wù gɛ̀ bee Nfoŋ wù baaŋ wu yo le. ");
INSERT INTO ncr_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kintaŋ kinɛ gɛ̀ bee kì fwe kife kì Kwelino gɛ̀ bee muh wù baaŋ wu Lum wù gɛ̀ sage kimbe ki woŋ ki Silia le. ");
INSERT INTO ncr_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Noo, bamii bachii mo bo kaase bo tuu jiŋ bantɛ baboo le, lɛ bo gɛɛŋ bo saŋ ajee aboo ki ba taŋ bo. ");
INSERT INTO ncr_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosɛf tɛ mo wu ja Nasalɛ ntɛ wumu wu Galalee le, wu bɛɛŋ wu gɛɛŋ Bɛtɛhɛm kimbe ki woŋ ki Judia le a ba gɛ̀ boyɛ Nfoŋ Dabi yo. Wu gɛ̀ gɛnɛ yo nje wù gɛ̀ bee muh wu a kfuu chi Nfoŋ Dabi le. ");
INSERT INTO ncr_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yosɛf gɛ̀ gɛɛne bɛ Mɛɛle wù wu gɛ̀ lesɛ lɛ wu lé wu gê wù nyu kwɛɛ ki bo saŋ ajee, wù nyu bɛ fwe. ");
INSERT INTO ncr_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","No bo gɛ̀ gɛnɛ bo bu yo, kife ke ki boyɛ to ki kojɛ. ");
INSERT INTO ncr_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Wu boo mwa ye wu bvuchile nyu mwa wù jwɛŋsɛ, wu kujɛ a nju le, wu giŋsɛ a ŋguh wu nyáŋ le, nje bo gɛ̀ kɛme gɛ kibuu ki kinche ki bamii ba jiɛnyi le gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Gɛ̀ bee kife kiyu le, bamii ba chiɛɛne kiji ki shóŋ bamu nyu mbebe ntɛ wɛɛ le, bo chiɛɛne shóŋ yiboo antaŋ. ");
INSERT INTO ncr_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nchɛndaa wu Tada jâgɛ nɛ wu bu a bo jii, n'yuu wù Nyo baaŋ fɛ bo gɛ̀ bee fo, bo kɛmɛ nfaaŋ baaŋ. ");
INSERT INTO ncr_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Geenɛ, nchɛndaa wu Tada wuyu jɛmɛ bo le lɛ, “Keefɛ bɛŋ fâane gɛ. Bɛŋ yû, ntoo nyu bɛ saaka wù joŋe fɛ bɛŋ le, wu lé wu gê wu nyâ njoŋ wù baaŋ fɛ bamii le bachii. ");
INSERT INTO ncr_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Yi juu chi abɛŋ le ba le ba boo Mbvusɛ ntɛ wu Nfoŋ Dabi le wù le Kletu wù Tada. ");
INSERT INTO ncr_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Finɛ le nyu njiŋɛ ki wu dûnyɛ mwa wuyu bɛŋ le. Bɛŋ lé bɛŋ gê bɛŋ gɛ̂ɛŋ bɛŋ yɛ̂ŋ wu le ba kujɛ a nju le ba giŋsɛ a ŋguh wu nyáŋ le.” ");
INSERT INTO ncr_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Gɛh noo, bo ja bo jaŋɛ bo yɛŋ nchɛndaa wu Nyo wɛɛ le bɛ kinchvu ki bamu ba duude le bo tume maŋkuŋ ma Nyo bo duu lɛ, ");
INSERT INTO ncr_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Mbɛɛŋsɛ nyûme fɛ Nyo wù le fɛwe le, kimbonɛ nyume fɛkuu fɛnɛ fɛ bamii ba Nyo yuge njoŋ bɛ bo le.” ");
INSERT INTO ncr_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Sege banchɛndaa ba Nyo baa gɛ̀ ja bo chinɛ bo le bo kaasɛ bo bɛɛŋ fɛwe, bamii ba chiɛɛne shóŋ bayu jɛmɛ ye yiboo le lɛ, “Bee gɛ̂ɛŋ mɛɛse wunɛ Bɛtɛhɛm, bee gɛ̂ɛŋ be yɛ̂ŋ fiɛɛ finɛ fi kooshi le fì Nyo le wu ge lɛ bee kɛɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Fo ki sege, bo mo bo ja bo gɛɛne chige chige, bo gɛɛŋ bo yɛŋ Yosɛf bɛ Mɛɛle mo mwa, wu gime a ŋguh wu nyáŋ le. ");
INSERT INTO ncr_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","No bo yɛŋ noo, bo mo bo kɛ bo feeji mwɛɛ munchii mu nchɛndaa wu Nyo be sɛŋe bo le kune mwa wuyu. ");
INSERT INTO ncr_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Jwe yuŋ bamii bachii ba gɛ̀ yu mwɛɛ mù bamii ba chiɛɛne shóŋ baa gɛ̀ jɛme bo le. ");
INSERT INTO ncr_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Geenɛ, Mɛɛle yu wu gɛɛ fɛ fitele fie le wu tu wu kwaji segechii. ");
INSERT INTO ncr_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bamii ba chiɛɛne shóŋ baa kaase bo tuu jiŋ bo yuuse Nyo bo tume maŋkuŋ mɛ nje bo gɛ̀ gɛɛŋ bo yɛŋ mwɛɛ munchii nyu gɛh yɛɛŋyɛɛŋ no nchɛndaa wu Nyo gɛ̀ sɛŋe. ");
INSERT INTO ncr_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mwa wuyu bu aju nyaaŋ, ba chvuu wu yeh, ba mo ba chu wu jee lɛ Jiso, jee chinɛ nyu gɛh chi chì nchɛndaa wu Nyo gɛ̀ sɛŋe bwee le fɛ wu ge wu kɛmɛ fwe. ");
INSERT INTO ncr_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kife gɛ̀ kojɛ kì ba ge kintanyɛ ki ba kfuŋ bikwɛɛ biboo no nchi wu Musɛ gɛ̀ goone. Bo mo bo jo mwa bo bɛɛŋ bɛ wu Yɛlusalɛm ki bo gɛɛŋ bo nya Tada le. ");
INSERT INTO ncr_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Finɛ le no ba gɛ̀ saŋ a ŋwa wu banchi ba Tada le lɛ, “Muh nɛ le wu boo mwa wu bvuchile nyume mwa wu jwɛŋsɛ, wu nya nyu Tada le.” ");
INSERT INTO ncr_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bo gɛ̀ gɛɛŋ tɛ ki bo ge kintanyɛ kinɛ bɛ bimbɛmbɛ bifɛɛ, no nyu bɛ booŋ ba mundoŋɛ bafɛɛ bii no fi gɛ̀ bee a Ŋwa wu banchi ba Tada le. ");
INSERT INTO ncr_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Lɛ nyu kife kiyu le, chiji la wumu nyu Yɛlusalɛm ba tɛŋe lɛ Simuŋ. Wu gɛ̀ bee muh wù chaaŋ wù gee no Nyo goone, wu gɛ̀ chiɛɛne muh wù lé wu gê wu tô ki wu jîɛɛsɛ muntele mu bamii ba Ishwala. Kiyo ki Yuude gɛ̀ bee yi ye ye le, ");
INSERT INTO ncr_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ki gɛ̀ ge wa wu kɛɛ lɛ gɛ kwe nyu yi jo wu, njɛ wu yɛŋ muh wu Mbvusɛ wù Tada gɛ̀ ka le gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kiyo ki Yuude ja ki ge Simuŋ gɛɛŋ yeh yi kintanyɛ le. Yosɛf bɛ Mɛɛle gɛ̀ doo bo to bɛ mwa yeh yi kintanyɛ le ki bo ge no nchi gɛ̀ goone, ");
INSERT INTO ncr_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simuŋ fi mwa wu kɛmɛ wu mo wu kɛ wu tu wu tume maŋkuŋ ma Nyo, wu duu lɛ, ");
INSERT INTO ncr_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Tada, no wo le wo ge wa ŋka wo wu to wu kojɛ, jôo lɛ muh wo wu lɛme yi kimbonɛ le. ");
INSERT INTO ncr_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ajii a waŋ le wo yɛŋ wa Mbvusɛ le, ");
INSERT INTO ncr_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","wù wo le wo chiiŋsɛ le, bamii bachii lé bo gê bo yɛ̂ŋ wu le. ");
INSERT INTO ncr_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Wu lé wu gê wù nyû kin'yesɛ fɛ bamii ba kee gɛ Nyo gɛ, wu lɛ bo tɛ kee wo, wu gê bo bɛ̂ɛŋse jee chi bamii buŋ ba Ishwala we.” ");
INSERT INTO ncr_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Chiji mwa bɛ bwe mwa yu mwɛɛ mu Simuŋ jɛme kune mwa wunɛ, jwe yuŋ bo. ");
INSERT INTO ncr_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Wu mo wu gɛɛ kimbonɛ ye yiboo le, wu jɛmɛ Mɛɛle wu bwee le lɛ, “Nyo le wu cha wa mwa yo wunɛ, nto we lé wu gê bamii ba Ishwala ba duude bo gwêeyi, bamu jâde lo we. Wu le njiŋɛ wu fiɛɛ fì bamii lé bo gê bo jɛ̂me mwɛɛ yi ye ye le. ");
INSERT INTO ncr_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Noo, finɛ mo fi duunyi mwɛɛ mù bamii nyile a muntele muboo le. Mwɛɛ munɛ munchii lé mu gê fitele fiuŋ nyu njɛ ba le ba booŋ bɛ finyoo.” ");
INSERT INTO ncr_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Gɛ̀ bee gɛh kife kiyu le, kwɛse wumu nyu ba tɛŋe lɛ Ana, wù nyu muh wu ntuŋ wu Nyo. Wu gɛ̀ bee mwa Fanuel wu le muh wu a kfuu chi Ashɛl le. Kwɛse wɛɛ gɛ̀ bee wu juŋ wa baaŋ. Wu gɛ̀ bee bɛ jwɛɛŋ gɛh yi biluŋ le bvusooshwi maa, jwɛɛŋ mo wu kwe. ");
INSERT INTO ncr_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Wu tu wù nyu gɛh wa fie kwɛŋkfu, wu shee yeh yi kintanyɛ le wu yuuse Nyo antaŋ bɛ fɛnshe, wu banɛ mwɛɛ munjile, wu buune. Biluŋ bie gɛ̀ bee wa mbanyaaŋ ncho binɛh (84). ");
INSERT INTO ncr_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Gɛh kife kiyu le kì ba gɛ̀ to bɛ mwa yeh yi kintanyɛ le, kwɛse wɛɛ gɛ̀ yɛŋ bo le, wu mo wu nya kiyone fɛ Nyo le, wu jɛmɛ kune mwa wunɛ bamii bachii ba gɛ̀ chiɛɛne kife kì Nyo le wu suuŋ bamii ba Yɛlusalɛm chiaaŋ yi ŋgɛ le. ");
INSERT INTO ncr_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Sege Yosɛf bɛ Mɛɛle gɛ̀ mɛsɛ mwɛɛ munchii no nchi wù Nyo gɛ̀ goone, bo mo bo kaase bo tuu jiŋ ntɛ wuboo wu Nasalɛ le a kimbe ki woŋ kì Galalee le. ");
INSERT INTO ncr_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mwa wuyu mo wu tu wu kuu wù kɛme bvuŋga, wu yisɛ bɛ bvufee bvu baaŋ, chiaaŋ yi Nyo nyume yi ye ye le. ");
INSERT INTO ncr_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Chiji Jiso bɛ bwee gɛ̀ bɛɛne Yɛlusalɛm biluŋ bichii fɛ Ŋka wu Ndaŋfe le. ");
INSERT INTO ncr_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jiso gɛ̀ bu biluŋ yuufe ncho bifɛɛ, bo ka bo bɛɛŋ fɛ ŋka wɛɛ le gɛh no bo gɛ̀ to bo bɛɛne. ");
INSERT INTO ncr_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","No bo gɛ̀ ji wa Ŋka bo mɛsɛ, bo doo bo kaase bo tuu jiŋ, mwa wù Jiso shɛɛ ajiŋ Yɛlusalɛm, geenɛ chiji bɛ bwee gɛ̀ baaŋ kɛɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bo jiɛnyɛ juu chi chile, bo kwaji gɛh lɛ wu le antɛnɛɛ a ŋgoo yi bamii ba bɛ bo gɛ̀ jiɛnyi le. Bo mo bo kɛ bo goone wu antɛnɛɛ a kfuu chiboo bɛ nsáa yiboo, ");
INSERT INTO ncr_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","lɛ bo gooŋ sɛɛŋ, bo mo bo kaasɛ bo tu jiŋ Yɛlusalɛm ki bo gooŋ wu yo. ");
INSERT INTO ncr_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Gɛh doo nyume ajiŋ a aju atade no bo gɛ̀ kɛ bo goone wu, bo yɛŋ wu le nyu yeh yi kintanyɛ le, wu shii yu bɛ bamii ba n'yɛyɛ, wu yege ba n'yɛyɛ, wu biide ba mbilɛ. ");
INSERT INTO ncr_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bamii bachii ba gɛ̀ yege mo bo kɛmɛ ŋgha baaŋ nje wu gɛ̀ kee mwɛɛ baaŋ wu ka chvuse bambilɛ chuule. ");
INSERT INTO ncr_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","No bwee bɛ chiji yɛŋ wu le, de yuŋ bo. Bwee bɛɛŋ wu wu du lɛ, “Mwa wo jeese la bɛ bee nɛ? Bîjɛ yɛ̂ŋ, besa chijo le bɛ gooŋ wa wo bee tu be wɛɛse lo.” ");
INSERT INTO ncr_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Wu chvuu lɛ, “Bɛŋ be goone mɛ nje la? Gɛ bɛŋ be kee lɛ ŋkɛmɛ ki nyûme a chii yeh fɛnɛ gɛ?” ");
INSERT INTO ncr_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Geenɛ, bo gɛ̀ baaŋ kɛɛ gɛ fiɛɛ fì wu gɛ̀ jɛme gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Wu mo wu ja bɛ bo boge Nasalɛ. Wu gɛɛŋ wu yuge bo le chuule. No mwɛɛ munɛ gɛ̀ kooshi nɛ, bwee gɛɛ fɛ fitele fie le wu kwaji segechii. ");
INSERT INTO ncr_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jiso mo wu kuu, wù kɛme bvufee bvù baaŋ, Nyo koŋe wu, bamii tɛ koŋe wu. ");
INSERT INTO ncr_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Gɛ̀ bee kife kì Joŋ wù mwa Sakiya gɛ̀ bee nchvuuŋ, ntuŋ wu Nyo to fɛ wu le. Kiluŋ kɛɛ gɛ̀ bee Tabilu sage wa njɛ Nfoŋ wu baaŋ wu Lum yi biluŋ le yuufe ncho bitɛŋ. Bontu Balɛt gɛ̀ sage kimbe ki woŋ kì Judia le, Hɛlod sage Galalee. Filib wù mwa bwe Hɛlod sage kimbe kì Itula bɛ kì Talikona, Lasana sage Abilɛŋ. Gɛh bee tɛ kife kì Anas bɛ Kayfa gɛ̀ bee bikwɛɛ bi bachiji kintanyɛ. ");
INSERT INTO ncr_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","No Joŋ yu ntuŋ wu Nyo wunɛ, wu mo wu ja wu gɛɛŋ bimbe bi woŋ wuchii wu mbebe Joo yì Jodaŋ le, wu tu wu feeji bamii le lɛ bo kusɛ muntele muboo, wu leesɛ bo a joo lɛ Nyo lɛɛshɛ bimbefɛ biboo. ");
INSERT INTO ncr_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Finɛ le no Yosaya wù muh wu ntuŋ wu Nyo gɛ̀ saŋ wa a Ŋwa we le lɛ, “Jɛ yi muh jaŋe nchvuuŋ lɛ, bɛŋ sêesɛ je yi Tada, bɛŋ nâjɛ yi nyu chaaŋ, ");
INSERT INTO ncr_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","bɛŋ kêeshɛ bambegɛ ba baaŋ baaŋ bɛ ba shige shige bachii, bɛŋ yîsɛ biwolo bichii, bɛ jé yi ŋgoŋe yi nyu chaaŋ, bɛŋ yîsɛ bintuge a jé le yichii bi nyu nɛ nleŋeleŋe, ");
INSERT INTO ncr_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","bamii bachii mô bo yɛ̂ŋ no Nyo fiih bamii.” ");
INSERT INTO ncr_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","No Joŋ feeji noo, binchvu bi bamii mo bi too lɛ wu leesɛ bo a joo. Wu mo wu kɛ wu jɛme bo le lɛ, “Kiŋgogɛ ki yó lɛ, teefe yɛɛŋ bɛŋ lɛ bɛŋ lêge shɛ́ŋ yi Nyo yî bɛɛne wu, yi wu lé wu gê wu dûnyɛ bɛŋ le, fɛ bɛŋ too nɛ? ");
INSERT INTO ncr_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Bɛŋ gêe mwɛɛ mù duunyi lɛ bɛŋ le bɛŋ kusɛ wa muntele mwɛna. Keefɛ bɛŋ mo bɛŋ kɛ̂ bɛŋ dûu gɛh lo fɛ bikwɛɛ biɛna le lɛ Ablaham le chiji wene gɛ. Nsɛŋe bɛŋ le lɛ taŋlo Nyo fiisɛ ata kanɛ wo tu booŋ ba Ablaham. ");
INSERT INTO ncr_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Bɛŋ kêe lɛ ba le ba gɛɛ wa tɛmɛ fɛ binyi bi bite le. Kite kichii ki baaŋ yuŋ gɛ muntaŋ mù njoŋe gɛ, tu ba lé ba gwô nɛ ba lêe ba gɛ̂ɛŋ yi gɛŋ le, ba tôŋ lo.” ");
INSERT INTO ncr_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Binchvu bi bamii biɛɛ yu, bi biih Joŋ le lɛ, “Bee lé be gê nɛɛ mɛɛse?” ");
INSERT INTO ncr_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Wu chvuu lɛ, “Muh wù kɛme bikuŋ bifɛɛ wu nyâ kimi muh mu wù kɛme gɛ le, wù kɛme mwɛɛ munjile wu nyâ muh wù kɛme gɛ le.” ");
INSERT INTO ncr_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Bamii bamu ba gɛ̀ koode ŋwa to fɛ wu le lɛ wu leesɛ bo a joo, bo biih wu le lɛ, “Muh wu N'yɛyɛ, bee lé be gê nɛɛ fiesa?” ");
INSERT INTO ncr_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Wu chvuu bo le lɛ, “Keefɛ bɛŋ fîi kwa wu ŋwa fede no nchi goone gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Bamii ba nchi to tɛ fɛ wu le bo biih lɛ, “Fiesa fiɛɛ fì bee lé be gê le la?” Wu chvuu lɛ, “Bɛŋ yɛ̂ne keefɛ bɛŋ chûuse bamii bɛŋ lode bige, bɛŋ gôone mwɛɛ mù achiji a bamii le gɛ! Bɛŋ yûge njoŋ bɛ nlaŋe wene!” ");
INSERT INTO ncr_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","No bamii gɛ̀ bee wa bo chiɛɛne Kletu wù Nyo gɛ̀ ka wa, bo tu bo ghaade mwɛɛ mu Joŋ, bo kwaji lɛ segemu wu le Mbvusɛ wɛɛ. ");
INSERT INTO ncr_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Joŋ mo wu kɛɛ wu jɛmɛ bo le lɛ, “Nleese bɛŋ nyu gɛh a joo maa, geenɛ muh wu kuge wu fede mɛ baaŋ wu too ajiŋ, ŋkooji gɛ ki ŋgvuumɛ nfaanyɛ jé ye gɛ. Wu lé wu lêese fie bɛŋ nyu chiaaŋ yi Kiyo ki Yuude le bɛ ŋgu le. ");
INSERT INTO ncr_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Wu kɛmɛ fiɛɛ fie abo fì wu fɛɛde agiŋ yu, wu yɛɛsɛ fɛ wu lé wu fɛ̂ɛde fo, wu bânyɛ agiŋ wu gɛɛ a ŋwaŋ le, wu mo wu koo munyi wu toŋ bɛ ŋgu wù fiee wu jime gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Le nɛ no Joŋ gɛ̀ feeji saaka wù joŋe wu Nyo bamii le wu ka nyaa bo bɛ nteefɛ jé le wesee. ");
INSERT INTO ncr_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Geenɛ, wu tu wu jɛme Hɛlod wu gɛ̀ sage kune kiŋge ke wu kaji lo, nje Hɛlod gɛ̀ jo Hɛlodia wù kwɛ mwa bwee kwɛɛ le! Wu ka wu jɛme kune mwɛɛ mù mbefe munchii mu Hɛlod gɛ̀ jialɛ. ");
INSERT INTO ncr_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hɛlod gɛ̀ mɛsɛ wu doosɛ lo wu jɛmɛ lɛ ba koo Joŋ ba baŋ yeh yi ncha le. ");
INSERT INTO ncr_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Sege Joŋ gɛ̀ baaŋ wu leese bamii a joo, wu leesɛ juu chimi lɛ wu mɛsɛ Jiso tɛ to wu leesɛ wu a joo. Jiso gɛh bunɛ, kibvulɛ gwenyɛ ye, ");
INSERT INTO ncr_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Kiyo ki Yuude shii ki to yi ye ye le fiɛɛnɛ kibɛmbɛ. Jɛ jɛmɛ fɛwe lɛ, “Wo le mwa yaŋ, wo le fitele fiaŋ, n'yuge njoŋ bɛ wo baaŋ.” ");
INSERT INTO ncr_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jiso gɛ̀ bee njɛ biluŋ mbaanshɛ sege wu gɛ̀ kɛ lɛme che. Bamii gɛ̀ kwaji lɛ wu le mwa Yosɛf wù mwa Ali. ");
INSERT INTO ncr_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ali gɛ̀ bee mwa Mata, wù mwa Lɛwe, wù gɛ̀ bee mwa Malki wù mwa Jana, wù gɛ̀ bee mwa Yosɛf. ");
INSERT INTO ncr_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosɛf wunɛ gɛ̀ bee mwa Matatia, wù mwa Amo, wù gɛ̀ bee mwa Nahum, wù mwa Ɛsli, wù gɛ̀ bee mwa Naga. ");
INSERT INTO ncr_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naga gɛ̀ bee mwa Maa wù mwa Matatia, wù gɛ̀ bee mwa Semeiŋ, wù mwa Yosek, wù gɛ̀ bee mwa Joda. ");
INSERT INTO ncr_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda gɛ̀ bee mwa Joanan, wù mwa Lesa, wù gɛ̀ bee mwa Sɛlubabe, wù mwa Shalta, wù gɛ̀ bee mwa Nɛli. ");
INSERT INTO ncr_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nɛli gɛ̀ bee mwa Mɛlki wù mwa Adi, wù gɛ̀ bee mwa Kosam, wù mwa Ɛmadam, wù gɛ̀ bee mwa Ɛl. ");
INSERT INTO ncr_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ɛl gɛ̀ bee mwa Joshwa wù mwa Ɛlisa, wù gɛ̀ bee mwa Yolim wù mwa Mata wù gɛ̀ bee mwa Lɛwe. ");
INSERT INTO ncr_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lɛwe gɛ̀ bee mwa Semuŋ wù mwa Juda, wù gɛ̀ bee mwa Yosɛf, wù mwa Yonam, wù gɛ̀ bee mwa Ɛliakim. ");
INSERT INTO ncr_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ɛliakim gɛ̀ bee mwa Melia wù mwa Mɛna, wù gɛ̀ bee mwa Matata wù mwa Nataŋ, wù gɛ̀ bee mwa Dabi. ");
INSERT INTO ncr_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dabi gɛ̀ bee mwa Jɛsi, wù mwa Obɛ, wù gɛ̀ bee mwa Boa, wù mwa Sala wù gɛ̀ bee mwa Nasoŋ. ");
INSERT INTO ncr_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasoŋ gɛ̀ bee mwa Aminada, wù mwa Amiŋ, wù gɛ̀ bee mwa Ani, wù mwa Ɛsloŋ, wù gɛ̀ bee mwa Bɛlɛ wù mwa Juda. ");
INSERT INTO ncr_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda gɛ̀ bee mwa Yakob wù mwa Asik, wù gɛ̀ bee mwa Ablaham, wù mwa Tɛla, wù gɛ̀ bee mwa Nao. ");
INSERT INTO ncr_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nao gɛ̀ bee mwa Sɛlug wù mwa Leu, wù gɛ̀ bee mwa Bɛlɛg wù mwa Ɛba, wù gɛ̀ bee mwa Shela. ");
INSERT INTO ncr_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shela gɛ̀ bee mwa Kanan wù mwa Afasad, wù gɛ̀ bee mwa Shem wù mwa Nyua, wù gɛ̀ bee mwa Lamek. ");
INSERT INTO ncr_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek gɛ̀ bee mwa Metusela wù mwa Ɛnok, wù gɛ̀ bee mwa Jalɛ wù mwa Malalɛl, wù gɛ̀ bee mwa Kenan. ");
INSERT INTO ncr_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan wunɛ gɛ̀ bee mwa Ɛnosh wù mwa Sɛt, Sɛt gɛ̀ bee mwa Adam, Adam gɛ̀ bee mwa Nyo. ");
INSERT INTO ncr_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jiso gɛ̀ ja fɛ Joo yì Jodaŋ le, wù nyu wu yisɛ bɛ Kiyo ki Yuude. Ki jo wu wu ja wu gɛɛŋ wu chee nchvuuŋ. ");
INSERT INTO ncr_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Wu nyu yo yi aju le mbaanyɛ, debele mone wu. Wu gɛ̀ bee yo noo wu jii gɛ mwɛɛ gɛ. Aju ayu gɛ̀ fe, jɛŋ mo yi yuu wu. ");
INSERT INTO ncr_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Debele mo wu jɛmɛ wu le lɛ, “Wo nɛ le Mwa Nyo, wo dû tɛdɛ chinɛ chi tu blɛd.” ");
INSERT INTO ncr_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jiso chvuu wu le lɛ, “Ba le ba saŋ lɛ, ‘Gɛ muh chee gɛh nje blɛd maa gɛ.’” ");
INSERT INTO ncr_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Debele jo wu wù bɛɛŋ bɛ wu kijusɛ kimi le fɛwɛɛwe, wu dunyɛ wu bituŋ bi yi kikwɛɛ ki nshɛŋ le bichii. Jiso yɛŋ nɛ ŋwaaŋ. ");
INSERT INTO ncr_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Debele mo wu jɛmɛ wu le lɛ, “Ba le ba nya wa kikwɛɛ ki nshɛŋ kinɛ mɛne kichii, taŋlo nnya mo nyu yɛɛŋ wù ŋkoŋe le. Nlé nnyâ wo le wo sâge, wo kɛ̂me bvukugɛ bɛ bvuŋga bvuyu bvuchii. ");
INSERT INTO ncr_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Fi le gɛh lɛ wo tûŋ anyuu wo ŋgvûuŋ mɛ, mɛ mo nnya fiɛɛ fichii wo le.” ");
INSERT INTO ncr_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jiso chvuu wu le lɛ, “Ba le ba saŋ lɛ, ‘Wo ŋgvûune Tada wu le Nyo wo, wo lɛ̂ne gɛh nyu wu le maa.’” ");
INSERT INTO ncr_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sataŋ mo wu jo wu wu gɛɛŋ bɛ wu a kinlaantɛŋ kì Yɛlusalɛm le, wu leesɛ wu fɛ kigo ki yeh yi kintanyɛ le, wu jɛmɛ wu le lɛ, “Wo nɛ le Mwa Nyo, wo selɛ fɛkuu, ");
INSERT INTO ncr_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","nje fi le ba saŋ lɛ, ‘Nyo lé wu dû banchɛndaa be le lɛ bo chîɛɛŋ wo.’ ");
INSERT INTO ncr_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Fi ka nyu ba saŋ lɛ, ‘Bo lé bo gê bo kâŋ wo lɛ keefɛ wo kfûuŋ kikaa yi tɛdɛ le gɛ.’” ");
INSERT INTO ncr_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jiso chvuu wu le lɛ, “Ŋwa wu Nyo duu tɛ lɛ, ‘Keefɛ wo mône Tada wù Nyo wo gɛ.’” ");
INSERT INTO ncr_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sege debele gɛ̀ mɛsɛ wa jé yichii yì wu gɛ taŋlo wu moŋ Jiso yu, wu mo wu ja wu gɛɛŋ wu chiɛɛne kife kimi. ");
INSERT INTO ncr_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jiso ja wu tu jiŋ Galalee, wù nyu wu yisɛ bɛ bvuŋga bvu Kiyo ki Yuude. Saaka kune wu mo wu saaŋe wu gɛɛŋ bimbe bi woŋ wu yo le bichii. ");
INSERT INTO ncr_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Wu tu wu yɛyi bamii yéh yi buunɛ le, bamii bachii bɛɛŋse wu. ");
INSERT INTO ncr_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jiso mo wu ja wu gɛɛne ntɛ wu Nasalɛ a wu gɛ̀ ta yo. Lɛ to nyume juu chiboo chi yuuŋ, wu gɛɛŋ yeh yi buunɛ le gɛh no wu gɛ̀ shee wu gɛɛne. Wu gɛ̀ ja wu lɛɛŋ we ki wu tɛ̂ɛŋ Ŋwa wu Nyo. ");
INSERT INTO ncr_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ba nya wu Ŋwa wù Yosaya wù muh wu ntuŋ wu Nyo gɛ̀ saŋ. Wu faanyɛ wu bijɛ kijusɛ kimi kì ba saŋ fo lɛ, ");
INSERT INTO ncr_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Kiyo ki Tada Nyo le ye yaŋ le, nje wu le wu yefɛ wa mɛ lɛ nto, nfejɛ saaka wù joŋe bamii ba kifufe le. Wu lé wu tûŋ mɛ lɛ nto, ntefɛ bamii ba le yeh yi ncha le lɛ ba lé ba bvusɛ bo, ŋka ntefɛ binfeeŋ lɛ bo lé bo yɛ̂ŋ mwɛɛ le. Wu tuŋ tɛ mɛ lɛ nto mbvûsɛ bamii ba ba nyiɛge bɛ bo yeh yi ncha le, ");
INSERT INTO ncr_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ŋka nfêjɛ lɛ kiluŋ kinɛ, le kì Tada lé wu gê wu bvûsɛ bamii.” ");
INSERT INTO ncr_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","No Jiso tɛŋe nɛ, wu kaasɛ wu kɛbɛ ŋwa wɛɛ wu nya muh wù to wu gɛɛde le wu mo wu shii fɛkuu. Bamii bachii ba gɛ̀ bee yeh yi buunɛ le bo tuŋ ajii ye ye le. ");
INSERT INTO ncr_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Wu mo wu kɛ wu naji bo le lɛ, “Fiɛɛ finɛ fì bɛŋ yu a Ŋwa wu Nyo le, le fi to wa fi kojɛ abɛŋ.” ");
INSERT INTO ncr_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bamii yegɛ fi joŋ bo le baaŋ, bo kɛme ŋgha yi njɛmɛ wù joŋe wù bude jwe we le. Bo mo bo ja bo maŋe, bo biide lɛ, “Wunɛ le gɛh mwa Yosɛf nɛ?” ");
INSERT INTO ncr_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jiso mo wu jɛmɛ bo le lɛ, “Gɛ maŋe lɛ bɛŋ lé bɛŋ mâ ŋgaŋ mɛne lɛ, ‘Muh wu fɛde bamii, fɛ̂ɛ la kikwɛɛ kuŋ.’ Bɛŋ dûu lɛ ŋgê tɛ mwɛɛ fɛnɛ mu bɛŋ chi yuge lɛ nchi ŋgee Kafanahum.” ");
INSERT INTO ncr_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jiso ka wu jɛmɛ bo le lɛ, “Nsɛŋe bɛŋ nchiɛɛŋ lɛ, gɛ taŋlo ba ŋgvuuŋ muh wu ntuŋ wu Nyo woŋ we le gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Yi nchiɛɛŋ le, nsɛŋe bɛŋ le lɛ gɛ̀ bee kife ki muh wu ntuŋ wu Nyo wù Alaja le, jaŋ gɛ̀ she we yi biluŋ le bitɛde bɛ kii bvusoo, jɛŋ koo woŋ wuchii. Bakwɛŋkfu gɛ̀ bee woŋ wu Ishwala le kife kiyu le bo duude. ");
INSERT INTO ncr_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Geenɛ, Nyo gɛ̀ baaŋ tuŋ gɛ Alaja fɛ muh le a bo ntɛnɛɛ gɛ, wu tuŋ fie nyu fɛ kwɛŋkfu wù gɛ̀ bee Salafa le, woŋ wu Sidoŋ le. ");
INSERT INTO ncr_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Bɛŋ tane tɛ lɛ, gɛ̀ bee kife ki muh wu ntuŋ wu Nyo wù Ɛlisha le, bamii gɛ̀ bee Ishwala bo duude bo kɛme goŋ yì baaŋ, gɛ̀ muh lɛ bo le gɛ bonɛ gɛ. Gɛ̀ mɛ gɛh Nama wù woŋ wù Silia le wumaa wù ba gɛ̀ fɛ wu, wu yuu.” ");
INSERT INTO ncr_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","No Jiso jɛme noo, bamii bachii ba gɛ̀ bee yeh yi buunɛ le yu, muntele bɛdɛ lo bo. ");
INSERT INTO ncr_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bo ja we, bo doonɛ wu, bo bu bɛ wu a kinlaantɛŋ ki yu le, bo bɛɛŋ bo bu yi jwe wu kiŋkoŋ kì gɛ̀ bee yi mbegɛ le a ntɛ wuboo le, nje bo gɛ̀ goone ki bo doonɛ wu lɛ wu gwe yo. ");
INSERT INTO ncr_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Geenɛ, wu fe a bo ntɛnɛɛ wu gɛɛne fie. ");
INSERT INTO ncr_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jiso mo wu ja wu boh Kafanahum, ntɛ wumu wu Galalee le. Doo nyu juu chi yuuŋ, wu gɛɛŋ wu yɛyi bamii yeh yi buunɛ le. ");
INSERT INTO ncr_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Bamii bayu bachii bo yuge bo kɛme lo ŋgha yi n'yɛyɛ we le, nje n'yɛyɛ we gɛ̀ kɛme bvuŋga. ");
INSERT INTO ncr_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Muh mu gɛ̀ bee yeh yi buunɛ yiyu le, kiyo kì yiide nyu yi ye ye le. Wu mo wu ja wu waŋ lɛ, ");
INSERT INTO ncr_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Abaay Jiso wu Nasalɛ, wo goone la a bee le? Wo to ki wo lɛ̂ɛshɛ lo bee? Ŋkee wo chuule. Le wo wɛɛ wù le muh wù yuude wù ja fɛ Nyo le.” ");
INSERT INTO ncr_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jiso waŋ kiyo kì yiide kiyu, wu jɛmɛ lɛ, “Baŋ lo, wo bu yi muh wunɛ le.” Ki mo ki bɛ̂ɛŋsɛ muh wuyu ki tuŋ fɛkuu a bamii jii, ki mo ki bû ye ye le, geenɛ ki gɛ̀ baaŋ nya gɛ wu nfu gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bamii bachii bijɛ, jwe yuŋ bo. Bo tu bo maŋe, bo biide lɛ, “Wunɛ njɛmɛ le wu nɛɛ wù muh wunɛ kɛme? Wu kɛme bvuŋga bvù baaŋ bvù wu wame biyo bì yiide bi bude ye yi bamii le.” ");
INSERT INTO ncr_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Saaka wu kune Jiso jiɛnyɛ bantɛ bachii ba le kimbe ki yo le. ");
INSERT INTO ncr_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jiso gɛ̀ ja wu bu yeh yi buunɛ yɛɛ le, wu gɛɛŋ wu lee a Samoŋ yeh. Gɛ̀ bee mwɛɛdɛ Samoŋ chɛne bɛ kin'ya. Bo lɛgɛ lɛ Jiso fih wu. ");
INSERT INTO ncr_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Wu gɛɛŋ fɛ wu gɛ̀ gime fo, wu lɛɛŋ a wu we, wu waŋ kin'ya kiyu, ki chinɛ wu le wu tɛmɛ. Kimimia, kwɛse wɛɛ mo wu ja we wu bijɛ fiɛɛ bo ji. ");
INSERT INTO ncr_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Juu gɛ̀ doo chi seele, bamii ba gɛ̀ kɛme bamii ba chɛne bɛ binchɛŋ yeye yeye bo mo jode bo bachii bo too bɛ bo fɛ Jiso le. Wu mo wu kune bo le bachii, bo tɛɛme. ");
INSERT INTO ncr_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Banchɛndaa ba Sataŋ gɛ̀ bude ye yi bamii bamu ba duude le tɛ bo wanɛ lɛ, “Wo le Mwa Nyo.” Geenɛ, Jiso lejɛ lɛ keefɛ bo jɛ̂me gɛ, nje bo gɛ̀ kee lɛ Jiso le Mbvusɛ wù Nyo gɛ̀ ka. ");
INSERT INTO ncr_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Akfuuŋ gɛ̀ bu ayuu, Jiso bu wu gɛɛŋ kijusɛ kimi le wu maa. Bamii gɛ̀ shɛɛ bo kɛ bo goone wu. Bo doo bo to bo yɛŋ wu le, wu goone wa lɛ wu ja ntɛ wɛɛ le. Bo mo bo goone jé lɛ wu mɛ bɛ bo. ");
INSERT INTO ncr_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Geenɛ, wu faŋ wu jɛmɛ bo le lɛ, “Ŋkɛme ki nfêjɛ saaka wù joŋe kune bvunfoŋ bvu Nyo bantɛ bamu le tɛ, nje le fiɛɛ fì Nyo tuŋ mɛ lɛ nto ŋge.” ");
INSERT INTO ncr_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Wu mo wu ja wu gɛɛŋ wu jiɛnyi wu feeji saaka wɛɛ yéh yi buunɛ le, woŋ kwɛɛ le wuchii. ");
INSERT INTO ncr_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Gɛ̀ bee juu chimi, Jiso ja wu lɛme mbebe Mamasi wù Gɛnesalɛt le, gɛ̀ bee bamii tuŋ kiŋgaŋ bo faase wu bo yuge jɛ yi Nyo. ");
INSERT INTO ncr_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Wu ja wu yɛŋ baŋguh bafɛɛde june wu joo le, bamii ba gɛ̀ kɛme bo nyu bo bu wa yo bo chuge gii yiboo yi bíɛŋ. ");
INSERT INTO ncr_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Wu gɛɛŋ wu lee a ŋguh wumu le, nyu wu Samoŋ, wu jɛmɛ lɛ wu tooŋsɛ wu lee wù gɛɛŋ a joo shige. Wu tooŋsɛ, Jiso mo wu shii yo bamii nyu kwa wu yɛyi bo. ");
INSERT INTO ncr_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Wu gɛ̀ yɛyɛ wu mɛsɛ, wu mo wù jɛmɛ Samoŋ le lɛ, “Tôoŋsɛ ŋguh wu lee wu gɛɛŋ fɛ joo njuume fo, bɛŋ noŋ gii yene bɛŋ koo bíɛŋ.” ");
INSERT INTO ncr_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Samoŋ chvuu lɛ, “Chiji kikwɛɛ, bee chi che lo we bee nooŋ gii bvu yuu, bee baaŋ fiɛɛ koo gɛ. Geenɛ, no jɛmɛ wo, nlé nôŋ gɛh lo.” ");
INSERT INTO ncr_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Bo gɛɛŋ bo noŋ, bo koo bíɛŋ yo wesee, bo doo bo bvuuse, gii yiboo goone ki yi sûumɛ. ");
INSERT INTO ncr_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Noo, bo ŋwalɛ bamii baboo ba kinchvu a ŋguh wumu le lɛ bo to bo fih bo. Bo to bo bvusɛ bíɛŋ yiyu yi yisɛ baŋguh baboo, baŋguh tu bo goone ki bo shiide a joo. ");
INSERT INTO ncr_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Samoŋ Bita yɛŋ fiɛɛ fì kooshi le, wu mo wu gɛɛŋ wu tuŋ anyuu wu ŋgvuumɛ a Jiso jii wu jɛmɛ lɛ, “Kii wo Tada, ja fiuŋ fɛnɛ wo chinɛ mɛne, nle fiaŋ muh wù befe.” ");
INSERT INTO ncr_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Wu gɛ̀ jɛme noo, nje wu bɛ bamii be ba kinchvu gɛ̀ yɛŋ bíɛŋ yì bo gɛ̀ kolɛ le, ye kuufɛ bo. ");
INSERT INTO ncr_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ye kuufɛ tɛ Jɛm bɛ Joŋ booŋ ba Jɛbɛdi ba gɛh bee tɛ a kinchvu ki Samoŋ le. Jiso jɛmɛ Samoŋ le lɛ, “Keefɛ wo fâane gɛ. Kɛge mɛɛse gɛɛne fwe, wo lé wo koode wa nyume bamii.” ");
INSERT INTO ncr_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Lɛ bo yu noo, bo mo bo bvusɛ baŋguh baboo kwa, bo chinɛ mwɛɛ munchii le bo mo bo bii Jiso le. ");
INSERT INTO ncr_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Lɛ to nyume kife kimi le, Jiso nyu a kinlaantɛŋ kimi le, muh mu nyu yo goŋ yì baaŋ nyu yi ji wu. Muh wuyu yɛŋ Jiso le, wu to wu gwe a wu jii, wu lɛgɛ wu wu jɛmɛ lɛ, “Tada, wo taŋlo wo fɛ mɛ n'yuu, fɛ wo nɛ koŋe lo.” ");
INSERT INTO ncr_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jiso mo wu nɛjɛ kibo wu kuŋ wu le wu jɛmɛ lɛ, “Ŋkoŋe lo, tɛ̂mɛ la wo yûude.” Kimimia, goŋ yì baaŋ yiyu mo yi chinɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jiso chiisɛ wu le lɛ, “Wo yɛ̂ne keefɛ wo sɛ̂ɛŋ muh le gɛ. Geenɛ, wo gɛ̂ɛŋ wo chûnyɛ ye yo chiji kintanyɛ le, wo mo wo nyâ nyaa yì Musɛ gɛ̀ jɛmɛ lɛ muh kɛmɛ ki wu nyâ ki wu chûnyɛ bamii le lɛ wu le wu tɛmɛ yi goŋ yinɛ le wu mo wu yuude.” ");
INSERT INTO ncr_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","No Jiso gɛ̀ chiisɛ muh wɛɛ le noo, saaka wu kune Jiso ka wu jiɛnyɛ wu fe lo, binchvu bì baaŋ baaŋ bi bamii bi baanyi bi too ki bi yû n'yɛyɛ we, bɛ ki wu fɛ̂de binchɛŋ biboo. ");
INSERT INTO ncr_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Geenɛ, Jiso to wu chinɛ bo le wu gɛɛŋ wu buune nchvuuŋ. ");
INSERT INTO ncr_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Gɛ̀ bee juu chimi Jiso yɛyi bamii, bvuŋga bvu Tada nyu yi ye ye le lɛ wu fɛde binchɛŋ yu. Bafalashii bɛ bamii ba gɛ̀ duunyi banchi ba Nyo shii fo, ba gɛ̀ bu bantɛ bachii ba Galalee le, mo bimbe bi Judia bɛ Yɛlusalɛm le. ");
INSERT INTO ncr_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Fi kooshɛ lɛ bamii bamu gɛ̀ bee bo ja bo too bo shumɛ muh yi bvuko le, wù nyu wu kwe kimbe kimimia. Bo gɛ̀ mone ki bo to bo lee bɛ wu yeh, bo giŋsɛ a Jiso fwe. ");
INSERT INTO ncr_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Geenɛ, bo gɛ̀ baaŋ kɛmɛ gɛ̀ je ki bo lee bɛ wu gɛ, nje bamii gɛ̀ fasɛ baaŋ. Bo mo bo bɛɛŋ nyu a yeh we, bo chiɛɛ kiyɛ, bo shiishɛ muh wuyu a bamii ntɛnɛɛ, a Jiso fwe, a fiɛɛ fì wu gɛ̀ gime yo le. ");
INSERT INTO ncr_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","No Jiso gɛ̀ yɛŋ lɛ bamii baa le bo gɛɛ muntele muboo ye ye le, wu mo wu jɛmɛ muh wuyu le lɛ, “Nsaa yaŋ, nle nlɛɛshɛ wa bimbefɛ biuŋ.” ");
INSERT INTO ncr_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Bamii ba gɛ̀ duunyi banchi ba Nyo bɛ kinchvu ki Bafalashii baa, mo bo kɛ bo fiɛge bo duu lɛ, “Wunɛ le yɛɛŋ wù jode kijusɛ ki Nyo? Le yɛɛŋ wù taŋlo wu lɛɛshɛ bimbefɛ, fuge Nyo sɛŋ?” ");
INSERT INTO ncr_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jiso kɛɛ fiɛɛ fì bo shuŋshi, wu biih bo le lɛ, “Bɛŋ kɛme kfuu chi banɛ baŋkwajɛ a muntele mwɛna le nɛ nje la? ");
INSERT INTO ncr_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Fi chige le fi la, ki njɛmɛ lɛ nle nlɛɛshɛ wa bimbefɛ bi muh wunɛ noo, lɛ wu ja we wu jiɛnyi le? ");
INSERT INTO ncr_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Geenɛ, nlé ŋgê bɛŋ kɛ̂ɛ lɛ muh wù jee che le Mwamuh kɛme bvuŋga fɛkuu fɛnɛ ki wu lɛ̂ɛshɛ bimbefɛ.” Wu mo wu jɛmɛ muh wu gɛ̀ kwe wa kimbe kimimia wuyu le lɛ, “Jɛme mɛ wo le, jâ we, wo jô bvuko bwuŋ wo gɛ̂ɛne a wo yeh.” ");
INSERT INTO ncr_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kimimia, wu mo wu ja we wu lɛɛŋ a bamii jii, wu mo wu jo fiɛɛ fì wu gɛ̀ gime yu wege wu mo wu ja wu gɛɛne fɛ wu kfuuŋ, wu tume maŋkuŋ ma Nyo. ");
INSERT INTO ncr_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Bamii yɛŋ noo, jwe yuŋ bo bo kɛmɛ kiŋgha, bo tume maŋkuŋ ma Nyo bo duu lɛ, “Bee le be yɛŋ biŋgha bi mwɛɛ le abɛŋ.” ");
INSERT INTO ncr_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jiso gɛ̀ ja wu bu fo wu jiɛnyi. Wu doo wu gɛɛne, wu yɛŋ muh mu wu gɛ̀ koode ŋwa le ba tɛŋe lɛ Lɛwe, wu gɛ̀ shii kijusɛ ke ki lɛme le. Jiso jɛmɛ wu le lɛ, “Wo bîi mɛne!” ");
INSERT INTO ncr_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lɛwe chinɛ mwɛɛ munchii le, wu ja we wu mo wu bii Jiso le. ");
INSERT INTO ncr_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Noo, Lɛwe mo wu ge ŋka wu baaŋ a wu yeh ki wu ŋgvûuŋ Jiso. Bamii ba gɛ̀ koode ŋwa ŋɛɛne lo fo, mo bamii bamu ba bɛ bo gɛ̀ jii mwɛɛ. ");
INSERT INTO ncr_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bafalashii bɛ bamii baboo ba kinchvu ba gɛ̀ duunyi banchi ba Nyo bo kɛ bo shuŋshi, bo biide booŋ ba ŋgoo ba Jiso le lɛ, “Le nje la fì bɛŋ jii bɛŋ muu mwɛɛ bɛ bamii ba koode ŋwa mo bamii bamu ba befe?” ");
INSERT INTO ncr_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jiso chvuu bo le lɛ, “Gɛ bamii ba tɛɛme to bo goone muh wu nche gɛ. To goone nyu bamii ba chɛne. ");
INSERT INTO ncr_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Gɛ nto ki ntɛɛŋ bamii ba chaaŋ gɛ. Nto ki ntɛɛŋ nyume bamii ba befe lɛ bo kusɛ muntele muboo.” ");
INSERT INTO ncr_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bo gɛ̀ ja bo ghaayi Jiso lɛ, “Booŋ ba ŋgoo ba Joŋ ja bo banɛ mwɛɛ munjile bo buune lɛfolɛfo, nyu gɛh no ba Bafalashii gee, geenɛ buŋ booŋ jii lo fiboo bo ka muu mwɛɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jiso ma jɛ bo le lɛ, “Taŋlo muh tɛɛŋ bamii fɛ bvuguu le bo to bo banɛ mwɛɛ munjile chiji bvuguu nyu bɛ bo? ");
INSERT INTO ncr_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Geenɛ, kife lé ki tô ki kôjɛ ki ba lé ba fî chiji bvuguu wuyu, a bo le, le a bvu wu bo lé bo kɛ̂ bo bânɛ mwɛɛ munjile kife kɛɛ le.” ");
INSERT INTO ncr_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Wu ka wu ma ŋgaŋ wumu bo le lɛ, “Gɛ muh taŋlo wu saayɛ nju yifiɛŋ wu chvuushɛ yì kege yu gɛ. Wu ge lo noo, tu wu le wu chɛŋɛ bɛ nju yifiɛŋ yɛɛ. Gɛ taŋlo fichaŋa fì fɛŋ fiɛɛ gɛɛŋ yɛɛŋyɛɛŋ bɛ nju yì kege yɛɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Gɛ taŋlo muh tɛ jo mbvuuŋ ma manfɛŋ, wu gɛɛ a kolo wu mbvuuŋ wù juŋ wa le gɛ. Wu ge lo noo, mbvuuŋ ma manfɛŋ maa ge mo koo, mo saayɛ lo kolo wù kege wɛɛ, mbvuuŋ bɛ kolo mu mo mu lɛsɛ achiji. ");
INSERT INTO ncr_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Fi kooji le lɛ, ba kɛme ki ba gɛɛ mbvuuŋ ma manfɛŋ nyu a kolo wù fwɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Bɛŋ kee tɛ lɛ gɛ muh nyu yu wù muu mbvuuŋ ma koo wa wù ka wu koŋe ma manfɛŋ gɛ. Wu to wu duu gɛh lɛ mà koo wa maa le mà joŋe.” ");
INSERT INTO ncr_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Gɛ̀ bee juu chi yuuŋ chimi, Jiso bɛ booŋ be ba ŋgoo bo jiɛnyi bo fede mwɛ wu agiŋ wumu le. Booŋ be ba ŋgoo ja bo kɛ bo suume bichiɛɛ bo fise abo bo jii. ");
INSERT INTO ncr_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Bafalashii bamu yɛŋ noo, bo biih lɛ, “Le nje la fì bɛŋ gee fiɛɛ fì nchi baaŋ bɛɛŋ gɛ lɛ muh gee juu chi yuuŋ gɛ?” ");
INSERT INTO ncr_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jiso biih tɛ bo le lɛ, “Fi le lɛ bɛŋ baaŋ a tɛɛŋ gɛ a Ŋwa wu Nyo le no jɛŋ gɛ̀ yu Nfoŋ Dabi bɛ ŋgoo ye, wu ge gɛ? ");
INSERT INTO ncr_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Wu gɛ̀ lee yeh yi Nyo le, wu jo blɛd wù ba le ba cha ba gɛɛ lɛ le wu Nyo, wu ji wu nya tɛ ŋgoo ye yu, gɛ̀ bee nchi fɛ muh ji blɛd wɛɛ fede bachiji kintanyɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jiso mo wu mɛsɛ wu jɛmɛ bo le lɛ, “Muh wù jee che le Mwamuh le Chiji Kikwɛɛ ki yuuŋ.” ");
INSERT INTO ncr_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Gɛ̀ bee juu chi yuuŋ chimi, Jiso gɛɛŋ wu lee yeh yi buunɛ yimi le wu yɛyi bamii. Muh mu nyume yu bɛ kibo ke kinchiɛɛŋ ki kwe ka. ");
INSERT INTO ncr_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Bamii ba gɛ̀ duunyi banchi ba Nyo mo Bafalashii bo tu bo goone fiɛɛ fì bo kooyi yi Jiso le. Bo mo bo booŋ ajii ye ye le bo jiiŋe laa wu le wu fɛ muh juu chi yuuŋ la. ");
INSERT INTO ncr_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jiso kɛɛ fiɛɛ fì bo fiine bɛ fi, wu jɛmɛ muh wù kibo ke gɛ̀ kwe wɛɛ le lɛ, “Jâ we, wo tô wo lɛ̂ɛŋ fɛnɛ.” Wu mo wu ja we wu lɛɛŋ fo. ");
INSERT INTO ncr_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jiso biih bo le lɛ, “Mbiide nyu bɛŋ le lɛ, fiɛɛ fì nchi bɛmɛ lɛ muh ge juu chi yuuŋ le fì la? Ki muh ge fiɛɛ fì joŋe, noo fì befe le? Ki muh fi muh, noo ki muh yuuyɛ lo muh le?” ");
INSERT INTO ncr_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Wu bijɛ bo ajii ajii wu kɛnɛ bo bachii, wu mo wu jɛmɛ muh wɛɛ le lɛ, “Nɛ̂jɛ kibo kuŋ.” Wu nɛjɛ ki, ki mo ki tɛ̂mɛ. ");
INSERT INTO ncr_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Geenɛ, fi toonyɛ lo bamii baa baaŋ, bo mo bo kɛ bo chude bantaŋ no taŋlo bo ge bɛ Jiso. ");
INSERT INTO ncr_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Gɛh aju ayu le, Jiso ja wu bɛɛŋ yi mbegɛ le wu gɛɛŋ wu buune, wu gɛ̀ che wu buune Nyo kintaŋ kichii. ");
INSERT INTO ncr_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Akfuuŋ bu ayuu, wu tɛɛŋ bamii ba gɛ̀ bii wu le, bo to. Wu cha bamu yuufe ncho bafɛɛ wu tɛɛŋ bo lɛ booŋ ba ntuŋ. ");
INSERT INTO ncr_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ajee a bamii bayu gɛ̀ bee: Samoŋ, wù wu gɛ̀ nya jee che chimi lɛ Bita, bɛ Andulu wù mwa bwee Samoŋ wɛɛ. Bamu nyu Jɛm, Joŋ, Filib, Batolomiu, ");
INSERT INTO ncr_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Macho, Toma mo Jɛm wù mwa Alfayu, Samoŋ wù gɛ̀ bee muh wu ka yi Bajalot le, ");
INSERT INTO ncr_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Juda wù mwa Jɛm mo Juda Ɛkaliot wù gɛ̀ kɛnɛ wu to wu gesɛ Jiso. ");
INSERT INTO ncr_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","No wu gɛ̀ cha bo noo, bɛ bo bachii mo bo ja bo boge. Lɛ bo boh, wu lɛɛŋ yi bale le, bamii be ba ŋgoo gɛ̀ bee wa fo wesee mo binchvu bi bamii bi ta lo ye fo bì gɛ̀ ja Judia bɛ Yɛlusalɛm. Bamii bamu gɛ̀ ja manjuu ma mbebe joo yì baaŋ le njɛ Taya bɛ Sidoŋ. ");
INSERT INTO ncr_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bo gɛ̀ to ki bo yu n'yɛyɛ wu Jiso, wu ka wu fɛ binchɛŋ biboo. Bamii ba biyo bì yiide gɛ̀ njiŋse bɛ bo too tɛ wu bvuuse biyo biyu. ");
INSERT INTO ncr_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bamii bachii mo bo goone ki bo kuŋ wu le, nje bvuŋga bvù gɛ̀ bude ye ye le gɛ fɛde bamii bachii ba gɛ kune wu le. ");
INSERT INTO ncr_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jiso gɛ̀ ja wu bijɛ bamii be ba ŋgoo, wu jɛmɛ lɛ, “Kinlaŋye kì baaŋ le kena, bɛŋ ba kɛme gɛ, nje bvunfoŋ bvu Nyo le nyu fɛ bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kinlaŋye kì baaŋ le kena, bɛŋ ba beede jɛŋ mɛɛse, nje Nyo lé wu gê lɛ bɛŋ fuu. Kinlaŋye kì baaŋ le kena, bɛŋ ba beede mɛɛse, nje bɛŋ lé bɛŋ gê bɛŋ kwâase chike. ");
INSERT INTO ncr_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kinlaŋye kì baaŋ le kena, sege bɛŋ bii muh wù jee che le Mwamuh le, bamii bane bɛŋ, bo bvuuse bɛŋ a bo ntɛnɛɛ, bo naanyi bɛŋ, bo ka nyaa bɛŋ ajee a befe. ");
INSERT INTO ncr_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Fi doo fi kooshi noo, bɛŋ mo bɛŋ lâŋeye, bɛŋ bînɛ, bɛŋ yûge njoŋ, nje maajɛ wene wù kuge le woŋ wù fɛwe le. Bɛŋ kêe lɛ le gɛh noo no bachiji chiji bamii baa gɛ̀ nyiɛge bɛ bamii ba ntuŋ wu Nyo ba fweele noo. ");
INSERT INTO ncr_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Geenɛ, ŋgɛ wù baaŋ le wene, bɛŋ bamii ba bvukugɛ, nje kinlaŋye kena ki kage nyu fɛnɛ. ");
INSERT INTO ncr_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ŋgɛ wù baaŋ le wene, bɛŋ ba ate le a yisɛ mɛɛse, nje bɛŋ lé bɛŋ gê bɛŋ bêede jɛŋ. Ŋgɛ wù baaŋ le wene, bɛŋ ba keede mɛɛse, nje bɛŋ lé bɛŋ gê bɛŋ bêede bɛŋ sôge bikwɛɛ. ");
INSERT INTO ncr_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ŋgɛ wù baaŋ le wene, sege bamii bachii bɛɛŋse bɛŋ. Bɛŋ kêe lɛ le gɛh noo no bachiji chiji bamii baa gɛ̀ bɛɛŋse bamii ba chimbiaŋ ba gɛ̀ mbiane lɛ bo le bamii ba ntuŋ ba Nyo. ");
INSERT INTO ncr_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Geenɛ, njɛme bɛŋ banɛ ba yuge fiɛɛ fì njɛme le, lɛ bɛŋ kôŋe bamii bena ba kimbanɛ, bɛŋ gêe nyu mwɛɛ mù njoŋe fɛ baa bò banɛ bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Bɛŋ lɛ̂ge lɛ Nyo nôŋ nyu kimbonɛ yi bamii ba buune lɛ loŋ tô fɛ bɛŋ le, bɛŋ ka bûune fɛ bamii ba nyuse bɛ bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Muh suŋ wo yi kilaŋɛ le, wo kaasɛ kimu wu mɛsɛ wu suŋ. Muh baa kikuŋ kuŋ ki akfuuŋ, wo chinɛ wu jo ki antɛŋ tɛ. ");
INSERT INTO ncr_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Muh lɛgɛ fiɛɛ a wo le, wo nya wu yu. Muh nɛ jo lo mwɛɛ mwuŋ, keefɛ wo shê wo kâ wo bîide gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Bɛŋ gêe bamii bamu le no bɛŋ koŋe lɛ ba gêe fɛ bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Bɛŋ nɛ koŋe gɛh nyu bamii ba koŋe bɛŋ, maajɛ wuyu nyume la fɛ bɛŋ le? Gɛ bamii ba befe gee gɛh noo gɛ? Bo koŋe gɛh tɛ nyu bamii ba koŋe bo. ");
INSERT INTO ncr_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Bɛŋ nɛ gee mwɛɛ mù njoŋe nyu gɛh fɛ bamii ba gee tɛ fɛ bɛŋ le, maajɛ wuyu nyume la fɛ bɛŋ le? Gɛ bamii ba befe gee gɛh yɛɛŋyɛɛŋ no bɛŋ gee gɛ? ");
INSERT INTO ncr_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Bɛŋ nɛ foose bamii bɛ mwɛɛ nyu gɛh baa ba bɛŋ jiiŋe lɛ taŋlo bo kaasɛ bo chvuu, fiɛɛ fì bo nya kiyone yi fi le nyu la? Gɛ bamii ba befe foose gɛ mwɛɛ nsáa yiboo le nje bo kee lɛ bo le bo ge bo kaasɛ bo chvuu fiɛɛ fichii gɛ? ");
INSERT INTO ncr_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Fi kooji lɛ bɛŋ kôŋe bamii bena ba kimbanɛ, bɛŋ gêe nyu mwɛɛ mù njoŋe fɛ bo le, bɛŋ fôose bamii bɛ mwɛɛ bɛŋ jiiŋe gɛ lɛ bo lé bo gê bo kâasɛ bo chvûu gɛ. Noo, bɛŋ mo bɛŋ kɛmɛ maajɛ wù kuge, bɛŋ ka bɛŋ nyu booŋ ba Nyo, wu le Kikwɛɛ ki Mwɛɛ Munchii, nje le gɛh tɛ noo no wù gee mwɛɛ mù njoŋe fɛ bamii bachii ba yɛɛde ajii le mo ba kɛme muntele mù yiide. ");
INSERT INTO ncr_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Bɛŋ kôode yii fɛ bamii le gɛh yɛɛŋyɛɛŋ no Chiji wene koode tɛ fɛ bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Keefɛ bɛŋ sâge bimbefɛ bi bamii bamu gɛ, noo Nyo gɛ̀ sa tɛ biɛna gɛ. Keefɛ bɛŋ bôone bikaa a bamii jiŋ lɛ bo lee ŋgɛ le gɛ, noo Nyo gɛ ka wu booŋ tɛ a bɛŋ jiŋ gɛ. Bɛŋ fôose bamii bamu, noo, Nyo to wu foose tɛ bɛŋ. ");
INSERT INTO ncr_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Bɛŋ nyâa nnyaa bamii le, Nyo lé wu gê wu nyâ tɛ bɛŋ le. Sege wu lé wu nyâ, wu lé wu fê chuule wu shiiŋshɛ, wu chiiŋ fi yisɛ fi fuushi kuu. Fiɛɛ fi muh fege fiɛɛ yo fɛ wu nya muh le, le gɛh fi fì Nyo le wu fe yo fɛ wu nya mwɛdɛ le tɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jiso ka wu ma ŋgaŋ wumu bo le lɛ, “Gɛ taŋlo kinfeeŋ dunyɛ je kimi le gɛ. Wu moŋ lo, bo bachii gwe a kintuge le. ");
INSERT INTO ncr_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Bɛŋ kee lɛ gɛ mwa ŋwa to wu fede muh wù yɛyi wu gɛ, le sege wu yɛyɛ wa wu mɛsɛ, wu kee njɛ muh wù gɛ̀ yɛyɛ wu. ");
INSERT INTO ncr_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Le nje la fì wo jiiŋe nyu sese chi le a mwa bwoo jii, geenɛ wo yɛde gɛ kikesɛ kì le a chuŋ jise le gɛ? ");
INSERT INTO ncr_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Taŋlo wo ge nɛɛ fɛ wo du mwa bwoo le lɛ, ‘Mwa bwɛɛŋ, gɛh lɛ̂ɛŋ mbvusɛ sese a wo jii’, geenɛ wo yɛde gɛ kikesɛ kì le a chuŋ jise le gɛ? Wo le muh wù chiaase ye! Yaŋsɛ wo bvusɛ kikesɛ kì le a chuŋ jise le fɛ wo yɛŋ sese chi le a jise chi mwa bwoo le chuule wo mo wo bvusɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jiso ka wu jɛmɛ lɛ, “Gɛ taŋlo kite kì joŋe yuŋ muntaŋ mù mbefe gɛ. Gɛ taŋlo tɛ kite kì befe yuŋ muntaŋ mù njoŋe gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ba kee kite nyu yi muntaŋ mù yune yi ki le. Gɛ taŋlo muh ke fimbi yi kite ki mbiaŋ le gɛ, gɛ taŋlo tɛ muh ke biŋgele yi kite ki jiaaŋ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Muh nɛ kɛme nchvu yi mwɛɛ mù njoŋe a fitele fie le, tu wu lé wu bvûuse nyu mwɛɛ mù njoŋe. Muh wù nchvu ye le mwɛɛ mù mbefe a fitele fie le, bvuuse gɛh nyu mwɛɛ mù mbefe. Fi le noo nje fiɛɛ fì le fi yisɛ fɛ fitele fì muh le, le fi fì bude jwe we le.” ");
INSERT INTO ncr_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jiso mo wu biih lɛ, “Le nje la fi bɛŋ tɛŋe mɛ lɛ, ‘Tada, Tada’, bɛŋ gee gɛ fiɛɛ fì njɛme bɛŋ le gɛ? ");
INSERT INTO ncr_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Muh wuchii wù too wu yuge n'yɛyɛ waŋ wu mo wù gee gɛh no wu duu, nlé ndûnyɛ bɛŋ le mɛɛse no wuwɛɛ muh le. ");
INSERT INTO ncr_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wu le gɛh njɛ muh wu gɛ̀ jonɛ yeh, wu ya wu chiŋ wu shii, wu gɛɛŋ wu kuŋ kimbaaŋ le fɛ wu gɛɛ kichi, wu mo wu jooŋ. Joo gɛ̀ yisɛ, yi bu yi to yi kfuuŋ yeh yi yu, yi gɛ̀ shiiŋshɛ yi gɛ, nje wu gɛ̀ jooŋ yi chuule. ");
INSERT INTO ncr_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Geenɛ, muh wù yuge n'yɛyɛ waŋ wù gee gɛ no wu jɛme gɛ, le njɛ muh wù gɛ̀ jonɛ yeh, wu taashɛ gɛh lo nshɛŋ wu mo wu jooŋ kichi sɛŋ. Joo gɛ̀ bu yi to yi kfuuŋ yeh yiyu, kiŋgane kimimia yi kesɛ nɛ wuuu, yi saaŋe lo.” ");
INSERT INTO ncr_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","No Jiso gɛ̀ mɛsɛ wa wu yɛyɛ bamii bɛ mwɛɛ munchii, wu mo wu ja wu gɛɛŋ a kinlaantɛŋ kì Kafanahum le. ");
INSERT INTO ncr_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kikwɛɛ ki ŋgoo yimi yi bamii ba nchi ba Lum gɛ̀ bee yo, wù kɛme nfwa we wumu, wu koŋe wù baaŋ. Nfwa wɛɛ chɛne, wù nyu wa jwe wu kwe le. ");
INSERT INTO ncr_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kikwɛɛ kiyu doo ki yu kune Jiso, wu mo wu tuŋ bamii ba gɛ̀ sage woŋ wu Bajuu lɛ bo gɛɛŋ bo lɛgɛ Jiso lɛ wu boh wu to wu fɛ nfwa we. ");
INSERT INTO ncr_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bo mo bo gɛɛŋ bo yɛŋ Jiso le bo ku chiaaŋ wu le, bo jɛmɛ lɛ, “Kee kee, to wo gɛɛŋ wo fi muh wese wunɛ, le muh wù taŋlo wo fi wu. ");
INSERT INTO ncr_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Wu koŋe woŋ wese baaŋ, le wu wù gɛ̀ jonɛ yeh yese yi buunɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jiso mo wu ja bɛ bo gɛɛne. Bo doo bo fɛɛse fɛ yeh yi chiji kikwɛɛ ki bamii ba nchi kɛɛ le, wu tuŋ nsáa ye yimi lɛ yi gɛɛŋ yi chi Jiso. Yi gɛɛŋ, yi tasɛ bɛ wu, yi jɛmɛ wu le lɛ, “Tada, kikwɛɛ ki bamii ba nchi duu lɛ keefɛ wo ka wo shê wo yɛ̂ne ŋgɛ wo tôo gɛ. Lɛ wu baaŋ kojɛ gɛ muh wù taŋlo wo lee a wu yeh gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Le fiɛɛ fì be ge tɛ lɛ keefɛ wu to bɛ bikaa bie lɛ wu yɛŋ wo le gɛ. Geenɛ, lɛ wo jɛ̂mɛ gɛh nyu jɛ mwa ye wu lɛme mo wu tɛmɛ. ");
INSERT INTO ncr_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Lɛ wu tɛ le muh a bvuŋga bvu muh mu kuu, bamii ba nchi tɛ nyume a wu kuu. Wu to wu du muh le lɛ, ‘Gɛ̂nɛ’, wu mo wu gɛ̂ɛne lo, wu du muh le lɛ, ‘Tô’, wu mo wu too lo. Wu du tɛ nfwa we le lɛ, ‘Gêe nɛ’, wu mo wù gee lo.” ");
INSERT INTO ncr_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Lɛ Jiso yu ntuŋ wɛɛ noo, jwe yuŋ lo wu, wu kaasɛ ye wu jɛmɛ kinchvu ki bamii kì gɛ̀ biih wu le lɛ, “Nsɛŋe bɛŋ le lɛ mbaaŋ n'yɛŋ gɛ muh le Ishwala wu lese kfuu chi finɛ fitele yi ye yaŋ le nɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bamii baa bachiji kikwɛɛ ki bamii ba nchi gɛ̀ tuŋ doo bo kaasɛ bo tu yeh, bo yɛŋ nfwa wɛɛ nyu wu tɛmɛ wa. ");
INSERT INTO ncr_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ajiŋ a yu, Jiso bɛ booŋ be ba ŋgoo ja bo gɛɛne ntɛ wumu le ba tɛŋe lɛ Nayiŋ, kinchvu ki bamii kfuunɛ ki bii a wu jiŋ. ");
INSERT INTO ncr_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","No bo gɛ̀ gɛɛne, bo doo bo bu jwe wu kitaŋ wu gɛ̀ lese ntɛ wɛɛ le, bo bijɛ bo yɛŋ no bo tuu gvunɛ chi muh bo bude bɛ chi. Muh wuyu gɛ̀ bee gɛh wu maa chiaaŋ yi bwee le. Bwee gɛ̀ bee kwɛŋkfu. Ba gɛ̀ bude yu noo, kinchvu ki bamii ba duude ntɛ wɛɛ le bii bwe mwa wɛɛ le nɛ mamama. ");
INSERT INTO ncr_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Lɛ Tada doo wu yɛŋ kwɛse wɛɛ le, wu koo yii, wu jɛmɛ wu le lɛ, “Keefɛ wo bêede gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","No wu jɛmɛ noo, wu mo wu fe wu gɛɛŋ wu kuŋ bvuko bvù ba gɛ̀ tulɛ gvunɛ chiɛɛ yu. Bamii ba gɛ̀ tuude mo bo lɛɛŋ. Wu jɛmɛ lɛ, “Chumu, njɛme wo le, jâ we!” ");
INSERT INTO ncr_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Wu mo wu ja we wu shii, wu kɛ wu jɛme. Jiso jijɛ wu le wu nya bwee le. ");
INSERT INTO ncr_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Bamii bachii yɛŋ noo, jwe yuŋ bo. Bo kɛ bo tume maŋkuŋ ma Nyo bo duu lɛ, “Muh wu ntuŋ wu Nyo wù baaŋ le wu bunɛ a bee ntɛnɛɛ. Nyo le wu to wa ki wu fîh bamii be.” ");
INSERT INTO ncr_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Saaka wu kune Jiso mo wu jiɛnyɛ wu gɛɛŋ woŋ wu Judia le wuchii bɛ bituŋ bi mbebe yo le. ");
INSERT INTO ncr_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Booŋ ba ŋgoo ba Joŋ yu tɛ mwɛɛ munɛ munchii, bo gɛɛŋ bo sɛɛŋ wu le. Wu tɛɛŋ bamu bafɛɛ, ");
INSERT INTO ncr_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","wu tuŋ bo fɛ Tada le lɛ bo gɛɛŋ bo biih wu le laa lé wu wù gɛ̀ bee ki wu gê wu to noo, bo chîɛɛne muh mu la. ");
INSERT INTO ncr_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bo gɛɛŋ bo yɛŋ Jiso le, bo jɛmɛ wu le lɛ, “Joŋ Nlesɛajoo le wu tuŋ bee ki bee to be biih wo le laa le wo wù gɛ̀ bee ki wo tô noo, bo chîɛɛne muh mu la?” ");
INSERT INTO ncr_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Bo gɛ̀ biide noo, Jiso le kife kiyu wu fɛde binchɛŋ bì duude bɛ goŋ yi baaŋ baaŋ, wu ka bvuuse biyo bì befe ye yi bamii le, wu gwenyi ajii a binfeeŋ bì duude. ");
INSERT INTO ncr_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jiso chvuu bo le lɛ, “Bɛŋ kâasɛ bɛŋ gɛ̂ɛŋ bɛŋ sɛ̂ɛŋ Joŋ mwɛɛ mù bɛŋ yɛŋ mo mù bɛŋ yu. Binfeeŋ yɛde wa mwɛɛ le, batɛŋlaase jiɛnyi chaaŋ, bamii ba chɛne bɛ goŋ yì baaŋ bo tɛmɛ wa bo yuude. Binchifɛ yuge wa mwɛɛ, bamii kaase bo bude yi kwe le, bo ka feeji tɛ saaka wù joŋe wu Nyo bamii ba kifufe le. ");
INSERT INTO ncr_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kinlaŋye kì baaŋ le kì muh wù baaŋ mɛ maŋɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bamii ba Joŋ gɛ̀ tuŋ baa ja, Jiso mo wu kɛ wu jɛme kinchvu ki bamii le kune Joŋ, wu biide lɛ, “Bɛŋ chi bude bɛŋ gɛɛne nchvuuŋ ki bɛŋ gɛ̂ɛŋ bɛŋ yɛŋ nyu la le? Gane chì fii fede chi shiŋshi le? ");
INSERT INTO ncr_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","No gɛ nyu noo gɛ, bɛŋ chi bude bɛŋ gɛɛne bɛŋ yɛde nyu la le? Muh wù susɛ ye bɛ njú yì bonɛ ye le? Bɛŋ yêgɛ bɛŋ yû, bamii ba suse ye bɛ njú yì tɛɛme kwa bo jii bikwɛɛ biboo bo to bo nyu gɛh nyu anto. ");
INSERT INTO ncr_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Bɛŋ chi gɛɛne noo ki bɛŋ yɛ̂ŋ nyu la le? Muh wu ntuŋ wu Nyo le noo? Ɛɛŋ, tu bɛŋ chi bɛŋ yɛŋ. Nsɛŋe bɛŋ le lɛ, wu fede muh wu ntuŋ wu Nyo. ");
INSERT INTO ncr_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Le wu wù ba gɛ̀ saŋ kune wù Nyo duu lɛ, ‘Yêgɛ yû, nlé ŋgê nchiiŋsɛ muh waŋ wu ntuŋ wu sa wo fwe, wu lé wu gɛ̂ɛŋ wu sêesɛ je yo fɛ wo too.’ ");
INSERT INTO ncr_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nsɛŋe bɛŋ le lɛ antɛnɛɛ a bamii ba le wa yi kikwɛɛ ki nshɛŋ le too bude mɛɛse, gɛ muh nyu yu wù kuge wu fede Joŋ gɛ. Geenɛ, muh wu le muh wù shige antɛnɛɛ a bvunfoŋ bvu Nyo, le wu wù kuge wu fede wu.” ");
INSERT INTO ncr_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Bamii bachii mo bamii ba gɛ̀ koode ŋwa yu no Jiso jɛme lɛ Joŋ gɛ̀ bee muh wu ntuŋ wu Nyo bo bɛɛŋse lɛ bvunfoŋ bvu Nyo le bvù chaaŋ, nje bo tɛ gɛ̀ bɛɛŋ Joŋ leesɛ bo a joo ");
INSERT INTO ncr_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Geenɛ, Bafalashii mo bamii ba gɛ̀ kee banchi ba Nyo chuule gɛ̀ faŋ fiboo ntaŋ wù Nyo gɛ̀ too bɛ wu nje bo gɛ̀ faŋ lɛ keefɛ Joŋ leesɛ bo a joo tɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jiso ja wu gha lɛ, “Fiɛɛ fì taŋlo mbege kiŋgogɛ ki mɛɛse kinɛ yu le la? Bo le njɛ la? ");
INSERT INTO ncr_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nlé nsɛ̂ɛŋ bɛŋ fiɛɛ fì bo le njɛ fi. Bo le gɛh njɛ booŋ ba shige shige bo le bo shiiyɛ manjuu ma waaŋ le, bamu tɛŋe bamu bo biide lɛ, ‘Bee toŋe ndoŋ fɛ bɛŋ bine sɛŋ? Bee nyaa ŋkee wu kwe bɛŋ mbɛmɛ gɛ?’ ");
INSERT INTO ncr_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Le gɛh no Joŋ Nlesɛajoo gɛ to, wu shee jɛŋ wu muu gɛ mbvuuŋ gɛ, bɛŋ lɛ wu kɛmɛ nyu nchɛndaa wu debele ye ye le. ");
INSERT INTO ncr_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Muh wù jee che le Mwamuh doo wu to, wu jii wu muu, bɛŋ lɛ ba bijɛ ba yɛŋ, wu jiɛnyi wu wuude mwɛɛ munjile wu yaane mbvuuŋ, wu ka nyu nsaŋ yi bamii ba koode ŋwa mo bamii ba befe bamu. ");
INSERT INTO ncr_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Geenɛ, bamii bachii ba toone bvufee bvu Nyo duunyi lɛ le bvù kooji.” ");
INSERT INTO ncr_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Muh wu Bafalashii wumu tɛɛŋ Jiso lɛ wu to wu ji mwɛɛ a wu yeh. Jiso bɛɛŋ wu gɛɛŋ bo shii bo mo bo jii mwɛɛ. ");
INSERT INTO ncr_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Fi kooshɛ lɛ kinjikuu kimu gɛ̀ bee tɛ ntɛ wɛɛ le. Wu yu lɛ Jiso jii mwɛɛ a muh Bafalashii wɛɛ yeh, wu mo wu jo fiŋkaaŋ fi mɛɛ ma yefɛ ma gwee wuŋ wu gɛɛŋ bɛ mo fo. ");
INSERT INTO ncr_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Wu gɛɛŋ wu lee wu lɛɛŋ mbebe yi Jiso le, wu kɛ wu beede, ajoo chiɛɛnyi yi bikaa bi Jiso le. Wu mo wu ŋgvuumɛ, wu ŋgvuusɛ kikwɛɛ ke wu shode bikaa bi Jiso bɛ yvu ye yi kikwɛɛ, wu shiŋe wu, wu mo wu yefɛ bɛ mɛɛ maa. ");
INSERT INTO ncr_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Muh Bafalashii wɛɛ wù gɛ̀ tɛŋɛ Jiso lɛ wu to wu ji mwɛɛ, lɛ wu yɛŋ noo, wu kwajɛ a fitele fie le “Be bee lɛ muh wunɛ nyume muh wu ntuŋ wu Nyo tu wu bee wu kɛɛ fiɛɛ fì le kwɛse wunɛ wù kune wu le, lɛ le kinjikuu.” ");
INSERT INTO ncr_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jiso ja wu jɛmɛ muh Bafalashii wɛɛ le lɛ, “Samoŋ, ŋkɛme fiɛɛ fì njɛmɛ wo le.” Wu chvuu lɛ, “Muh wu N'yɛyɛ, jɛ̂mɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jiso mo wu kɛ lɛ, “Muh mu gɛ̀ be wu foosɛ bamii bafɛɛ bige, wu foosɛ muh mu bɛ badanale gii yitɛŋ, wu foosɛ muh mu badanale Mbaanshɛŋ. ");
INSERT INTO ncr_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bi gɛ̀ ya bo bachii ki bo kaasɛ bo laŋɛ, wu mo wu chinɛ bige biyu bo le. Mɛɛse wo yɛne lɛ antɛnɛɛ a bamii ba bafɛɛ banɛ muh wù taŋlo wu koŋe wu wesee le wù la?” ");
INSERT INTO ncr_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Samoŋ chvuu lɛ, “Le muh wù ba gɛ̀ chinɛ ye fioo yi duude le.” Jiso bɛɛŋ lɛ, “Wo le wo chvuu chuule.” ");
INSERT INTO ncr_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","No wu mbɛmɛ noo, wu kaasɛ ye wu bijɛ kwɛse wɛɛ, wu mo wu jɛmɛ Samoŋ le lɛ, “Wo le wo yɛŋ kwɛse wunɛ le? No mbe nto a wo yeh, wo be baaŋ nya gɛ mɛ mo bɛ joo ki nchugɛ bikaa yu gɛ. Geenɛ, kwɛse wunɛ le wu chugɛ wa bikaa biaŋ nyu bɛ ajoo, wu sho bɛ yvu ye yi kikwɛɛ. ");
INSERT INTO ncr_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wo be baaŋ yɛsɛ gɛ mɛne wo shiŋe mɛ gɛ. Geenɛ kɛge no mbe to fɛnɛ, le no kwɛse wunɛ shiŋe bikaa biaŋ. ");
INSERT INTO ncr_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wo be baaŋ yefɛ gɛ kikwɛɛ kaŋ gɛ mo nyu bɛ mɛɛ gɛ mbɛŋ. Geenɛ, kwɛse wunɛ le wu yefɛ wa bikaa biaŋ nyu bɛ mɛɛ ma gwee wuŋ. ");
INSERT INTO ncr_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Noo, nsɛŋe wo le lɛ, kwɛse wunɛ le wu dunyɛ kiŋkoŋɛ kì baaŋ nje ba le ba lɛɛshɛ wa bimbefɛ bie bì duude baaŋ. Geenɛ, muh wù ba lɛɛshɛ bimbefɛ bie bì le shige duunyi kiŋkoŋɛ kì shige.” ");
INSERT INTO ncr_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jiso mo wu jɛmɛ kwɛse wɛɛ le lɛ, “Ba le ba lɛɛshɛ wa bimbefɛ biuŋ.” ");
INSERT INTO ncr_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bamii ba bɛ bo gɛ̀ jii mwɛɛ mo bo kɛ bo tu bo shuŋshi lɛbolɛbo bo duu lɛ, “Le yɛɛŋ wunɛ mbɛŋ wu mo lɛɛshi lo bimbefɛ bi bamii?” ");
INSERT INTO ncr_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jiso mo wu mɛsɛ wu jɛmɛ kwɛse wɛɛ le lɛ, “Wo gɛ̂ɛne fiuŋ chuule fitele fì wo lese ye yaŋ le le fi ge fia wo bonɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ajiŋ a yu, Jiso ja wu jiɛnyi a bilaantɛŋ bɛ bantɛ le wu feeji saaka wù joŋe kune bvunfoŋ bvu Nyo. Booŋ be ba ŋgoo lɛ ba yuufe ncho bafɛɛ gɛ̀ bii wu le, ");
INSERT INTO ncr_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","noo bikɛse bamu ba wu gɛ̀ fɛ binchɛŋ biboo bɛ bamu ba wu gɛ̀ bvusɛ biyo bì befe ye yiboo le. Bikɛse banɛ gɛ̀ bee Mɛɛle wù bo gɛ̀ tɛŋe lɛ Madaleŋ, wù wu gɛ̀ bvusɛ banchɛndaa ba debele yi ye ye le bvusooshwi. ");
INSERT INTO ncr_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nyume Joana wù jwɛɛŋ gɛ̀ bee Chusa wù gɛ̀ lɛne Hɛlod le, mo Susana bɛ bikɛse bamu wesee. Bo gɛ̀ jiɛnyi noo, bo bvuse mwɛɛ a bikɛɛ biboo le, bo fii Jiso yu bɛ booŋ be ba ŋgoo lɛ. ");
INSERT INTO ncr_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bamii gɛ̀ ja bantɛ le bantɛ le bo too fɛ Jiso le. Kinchvu ki bamii gɛ̀ yisɛ fo, wu ma ŋgaŋ bo le lɛ. ");
INSERT INTO ncr_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Muh gɛ̀ la ki wu gɛ̂ɛŋ wu noŋ muntaŋ. Wu gɛ̀ doo wu nooŋ, mumu gweeyɛ a je, bamii fede bo jiɛnyi bɛ bikaa, munyii mù fuune we gɛ̀ tajɛ mu ji. ");
INSERT INTO ncr_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mumu gwe fɛ kijusɛ ki ata le, lɛ mu doo mu buujɛ mu mo mu yunɛ nje kijusɛ kɛɛ gɛ̀ bee ki yɛŋe. ");
INSERT INTO ncr_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mumu muntaŋ gwe yi mbiaŋ le, lɛ mu doo mu buujɛ mu kuu bɛ mbiaŋ yiyu, yi mo yi baŋe muntaŋ mwɛɛ lɛ fɛ mu kuu gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mumu gwe nyu yi nshɛŋ yì joŋe le, lɛ mu buujɛ, mu kuu, ba gɛ̀ gwejɛ mu bu kiŋgane gwii fede no ba gɛ̀ noŋ.” No Jiso ma noo, wu mo wu jaŋ lɛ, “Muh wù kɛme bintuŋ, wu yu.” ");
INSERT INTO ncr_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Booŋ be ba ŋgoo gɛ̀ ja bo biih wu le laa ŋgaŋ wɛɛ duunyi lɛ la lɛ? ");
INSERT INTO ncr_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Wu chvuu bo le lɛ, “Le bɛŋ ba Nyo le wu ge lɛ taŋlo bɛŋ kee mwɛɛ mu bvunfoŋ bwe mù le nyilɛ le. Geenɛ, bamii bamu yuge fiboo nyume a baŋgaŋ le. Fi le noo no fi gɛ̀ bee wa lɛ, ‘Bo lé bo gê bo jîiŋe gɛh lo mwɛɛ bo yɛde gɛ, Bo yege gɛh lo bo yuge gɛ fiɛɛ gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Bɛŋ yu la fiɛɛ fì ŋgaŋ wɛɛ duunyi. Muntaŋ mwɛɛ le jɛ yi Nyo. ");
INSERT INTO ncr_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Muntaŋ mù gɛ̀ gwe a je, le bamii ba yuge jɛ yi Nyo debele mo wu to wu bvusɛ saaka wɛɛ a muntele muboo le, lɛ keefɛ bo bɛ̂ɛŋ bo tô bo lûŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Muntaŋ mù gɛ̀ gwe fɛ kijusɛ ki ata le, le bamii ba yuge jɛ yi Nyo bo mo bo fi lo bɛ njoŋ, geenɛ yi baaŋ a chimɛ gɛ gɛŋ fɛ muntele muboo le gɛ, bo bɛmɛ gɛh nyu fɛmu fɛmu. Moŋ nɛ le wu to, wu mo wu chii bikaa. ");
INSERT INTO ncr_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Muntaŋ mù gɛ̀ gwe yi mbiaŋ le, le bamii ba yuge jɛ yi Nyo, bo doo bo gɛɛne, nfuuŋsɛ bɛ bvukugɛ mo njoŋ wu mwɛɛ mu yi kikfuuŋ le mo mu to mu yigɛ jɛ yiyu yi laayɛ lo yi ka kuu gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Muntaŋ mù gɛ̀ gwe yi nshɛŋ yì joŋe le, mu le bamii ba kɛme muntele mù njoŋe, ba yuge jɛ yi Nyo, bo mo bo lee lo muntele muboo yi le, bo mo bo kaane shɛ́ŋ, bo gee no yi goone bo gɛɛne lo fwe fwe. ");
INSERT INTO ncr_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Gɛ muh to wu chu kin'yesɛ wu ka wu jo ŋkaa wu kfuusɛ yu gɛ. Gɛ taŋlo wu ka wu leesɛ tɛ agaguu gɛ. Wu to wu chu, kinʼyesɛ wu tome nyu yi fiɛɛ fì ba to ba toome kin'yesɛ fo, lɛ bamii doo bo lese yeh bo yɛde n'yuu le. ");
INSERT INTO ncr_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Fiɛɛ fichii fì le nyilɛ le, le fi nyu fi yɛne, mwɛɛ mù ajiŋ ajiŋ le mu bu n'yuu le. ");
INSERT INTO ncr_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Noo, bɛŋ doo bɛŋ yege jɛ yi Nyo bɛŋ mo bɛŋ yege yi chuule bɛŋ kêe lɛ muh wù kɛme fiɛɛ lé ba nyû ba bîsɛ lo. Muh wù kɛme gɛ fiɛɛ gɛ mo nyu fì shige fì wu kwaji lɛ wù kɛme lo ba lé ba fî lo a wu le.” ");
INSERT INTO ncr_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","No Jiso gɛ̀ yɛyi bamii noo, bwe Jiso bɛ booŋ ba bwe Jiso ja bo to lɛ bo yɛŋ wu le. Fi ya bo no bo lee nje kinchvu ki bamii gɛ̀ duude baaŋ. ");
INSERT INTO ncr_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Muh mu jɛmɛ Jiso le lɛ, “Bwoo bɛ booŋ ba bwoo lɛme akfuuŋ bo goone ki bo yɛŋ wo le.” ");
INSERT INTO ncr_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Wu chvuu fie lɛ, “Bwɛɛŋ bɛ booŋ ba bwɛɛŋ le bamii ba yuge jɛ yi Nyo bo gee no yi goone.” ");
INSERT INTO ncr_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Lɛ ka nyu juu chimi, Jiso jɛmɛ booŋ be ba ŋgoo le lɛ, “Bee daŋ mamasi bee gɛɛŋ wuŋ kwege.” Bo mo bo lee a ŋguh le bo daŋe. ");
INSERT INTO ncr_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","No bo gɛ̀ daŋe, Jiso kɛ wu lefe. Nfuŋ ja wu kɛ wu shii, wu fuge joo bɛ bvuŋga joo lese a ŋguh le yi goone ki yi yîsɛ yo, bo nyu wa lo jwe wu kwe le. ");
INSERT INTO ncr_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Bo gɛɛŋ bo kaŋsɛ Jiso bo du lɛ, “Chiji Kikwɛɛ, Chiji Kikwɛɛ, bee le be kweeyɛ.” Jiso kaŋsɛ wu waŋ nfuŋ bɛ joo yì gɛ̀ fuge yiyu, nfuŋ wuyu lu, joo mo yi chii nɛ shiiŋŋ. ");
INSERT INTO ncr_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Wu biih bo le laa, “Bɛŋ leese fitele nyu yi yɛɛŋ le mbɛŋ?” Ye kuufɛ bo, bo kɛmɛ nfaaŋ bo ghaade lɛ, “Wunɛ le muh wù nɛɛ wù wanɛ nfuŋ bɛ joo mu yuge wu le?” ");
INSERT INTO ncr_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Bo daŋ mamasi wɛɛ bo bu wuŋ kwege kimbe ki Gɛlasɛŋ le, bo chinɛ wa kimbe ki woŋ kì Galalee le. ");
INSERT INTO ncr_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jiso doo wu bude a ŋguh le, lɛ wu fɛsɛ kwa, bɛ muh mu wu a kinlaantɛŋ ki yu le tasɛ bɛ banchɛndaa ba debele bo fuuŋse wu. Bo che wa ye ye le baaŋ wu jiɛnyi kichinɛ kiyɛse, wu chee nyu afuuŋ yì ba gɛ̀ jiiyi bamii yo le. Wu ka chee gɛ fɛ yeh le gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","No wu yɛŋ Jiso le, wu mo wu saa wu chinɛ kitada, wu gɛɛŋ wu gwe a wu jii, wu waŋ bɛ bvuŋga lɛ, “Jiso, Mwa Nyo, Nyo wu le Kikwɛɛ ki Mwɛɛ Munchii lɛ, wo goone la a mɛne? Kii kii, keefɛ wo nyâ mɛ ŋgɛ le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Wu gɛ̀ jɛme noo nje Jiso gɛ̀ bee wu waŋ wa kiyo ki debele kiyu lɛ ki bû yi muh wuyu le. Ki to ki tu ki chuufe wù kiŋgane le kiŋgane le ba koode lo wu, ki ba koo ba kaaŋ chiaaŋ mo bikaa bɛ ncha fɛ ba tu ba chiɛɛne. Bo gɛ̀ kaaŋ noo, wu suume gɛh lo, kiyo kiyu mo ki chuufe wu, wu mo wu tu wu lege wu gɛɛne nchvuuŋ. ");
INSERT INTO ncr_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jiso mo wu biih muh wɛɛ le lɛ, “Jee chuŋ le yɛɛŋ?” Wu chvuu lɛ, “Jee chaŋ le kinchvu.” Wu gɛ̀ chvuse noo nje banchɛndaa ba debele gɛ̀ bee bo chiiŋ lo yi ye ye le. ");
INSERT INTO ncr_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Banchɛndaa bayu lɛgɛ Jiso lɛ keefɛ wu chiiŋsɛ bo nyu a kintuge kì shiide nɛ ŋooŋŋ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Gɛ̀ bee ŋgoo yi munyuŋa yimi jii mwɛɛ yi mbɛɛsɛ le fo, banchɛndaa ba debele bayu mo bo lɛgɛ Jiso lɛ wu chiiŋsɛ bo bo boh bo gɛɛŋ bo lee nyu yi munyuŋa muyu le. Wu bɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Bo mo bo bu ye yi muh wuyu le, bo daŋsɛ bo gɛɛŋ bo lee yi munyuŋa muyu le. Mu sɛŋ mu boh a kiŋkoŋ le, mu shii a mamasi wɛɛ le, mu kweeyɛ yo. ");
INSERT INTO ncr_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bamii ba gɛ̀ chiɛɛne munyuŋa muyu yɛŋ fiɛɛ fì gɛ̀ kooshɛ le, bo ja fo, bo baa lo legɛ, bo gɛɛŋ bo sɛɛŋ saaka wuyu a kilaantɛŋ bɛ bantɛ ba yo le. ");
INSERT INTO ncr_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bamii tu bo yuge, bo bude bo gɛɛne ki bo yɛŋ tɛ fiɛɛ fì kooshi le. Bo to fɛ Jiso be bee fo, bo yɛŋ muh wɛɛ le, banchɛndaa ba debele baa chinɛ wa wu le, wu shii mbebe Jiso le, wu jii njú, bvufee bwe kaasɛ wa bvu tu fo. Bo faŋ baaŋ. ");
INSERT INTO ncr_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bamii ba gɛ̀ yɛŋ fiɛɛ fì gɛ̀ kooshɛ le kɛ bo sɛŋe bo no fi gɛ̀ jiɛnyɛ bɛ muh wɛɛ wu gɛ̀ kɛme banchɛndaa ba debele fɛ wu tɛmɛ. ");
INSERT INTO ncr_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Bamii bachii ba bimbe bì Gɛlasɛŋ le kɛmɛ faaŋ, bo mo bo chooŋɛ Jiso lɛ wu gɛ̂ɛne. Jiso mo wu ja fie, wu lee a ŋguh le lɛ wu gɛɛne, ");
INSERT INTO ncr_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","muh wɛɛ wu banchɛndaa ba debele gɛ̀ bu yi ye ye le mo wu lɛgɛ Jiso lɛ bɛ wu gɛɛne. Jiso faŋ, wu chvuu wu jiŋ wu jɛmɛ lɛ, ");
INSERT INTO ncr_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Wo gɛ̂ɛne nyu fɛ wo kfuuŋ, wo gɛ̂ɛŋ wo sɛɛŋ bamii buŋ fiɛɛ fì Nyo ge fɛ wo le.” Noo, muh wɛɛ mo wu tu jiŋ wu gɛɛŋ wu jiɛnyi kinlaantɛŋ kɛɛ le kichii, wu sɛŋe kiŋgha ki fiɛɛ fì Jiso ge fɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jiso daŋ mamasi, wu kaasɛ wu tu jiŋ kimbe kɛge le. Kinchvu ki bamii kì be shɛshɛ ki chiɛɛne wu fo fi wu. ");
INSERT INTO ncr_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Jwɛŋsɛ wumu gɛ̀ to fo ba tɛŋe lɛ Jailu, nyu chiji kikwɛɛ ki yeh yi buunɛ yi yo le. No wu to, wu fe wu gɛɛŋ wu tuŋ anyuu wu ŋgvuumɛ a Jiso jii, wu ku chiaaŋ lɛ wu to gɛh a wu yeh, ");
INSERT INTO ncr_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","lɛ mwa ye kwee lo. Wu gɛ̀ kɛme mwa, ka gɛh wu maa, nyu mwa wù kwɛse wù nyu biluŋ yuufe ncho bifɛɛ. Bɛ Jiso ja bo gɛɛne kinchvu ki bamii faase Jiso. ");
INSERT INTO ncr_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kwɛse wumu nyu a bo ntɛnɛɛ wù nyu wu chɛŋ wa bɛ kinchɛŋ ki bikɛse yi biluŋ le yuufe ncho bifɛɛ. Wu lɛsɛ wa fiɛɛ fichii fì wu gɛ̀ kɛme chiaaŋ yi bamii ba bifudɛ le, ki gɛ̀ ya bo ki bo fɛ. ");
INSERT INTO ncr_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Wu kɛŋsɛ wu to a Jiso jiŋ, wu kuŋ jwe wù nju yi Jiso le. Kimimia kinchɛŋ ke mo ki suunɛ. ");
INSERT INTO ncr_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jiso biih lɛ, “Kuŋ yɛɛŋ mɛne?” Bamii bachii maŋe lo. Bita ja wu biih lɛ, “Chiji Kikwɛɛ, gɛ wo yɛde lɛ kinchvu ki bamii faase wo gɛ?” ");
INSERT INTO ncr_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jiso duu gɛh lɛ, “Muh le wu kuŋ mɛne. Nle yu no bvuŋga le bvu bu ye yaŋ le.” ");
INSERT INTO ncr_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kwɛse wɛɛ yɛŋ lɛ gɛ je nyu yu yì taŋlo wu nyilɛ gɛ, njaŋ mo yi koo wu wu gɛɛŋ wu tuŋ anyuu a Jiso jii wu mo wu sɛɛŋ bamii bachii yu fiɛɛ fì be ge wu fɛ wu kuŋ Jiso le, wu ka wu sɛɛŋ no wu be kuŋ noo kinchɛŋ ke suunɛ lo kimimia. ");
INSERT INTO ncr_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jiso jɛmɛ wu le lɛ, “Mwa yaŋ, fitele fiuŋ fì wo lese yi ye yaŋ le, le fi ge wa wo tɛmɛ. Wo gɛ̂ɛne la chuule.” ");
INSERT INTO ncr_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Gɛh no Jiso gɛ̀ baaŋ wu jɛme kwɛse wɛɛ le noo, muh mu fɛsɛ fo wu ja fɛ la chi Jailu wù chiji kikwɛɛ ki yeh yi buunɛ yɛɛ le, wu jɛmɛ wu le lɛ, “Mwa yo le wu mɛsɛ wa. Keefɛ wo ka wo shê wo nyâa ŋgɛ Muh wu N'yɛyɛ le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Wu doo wu jɛmɛ noo, Jiso yu, wu jɛmɛ Jailu le lɛ, “Keefɛ wo fâane gɛ, lêesɛ gɛh nyu fitele fiuŋ yi ye yaŋ le maa, mwa yo lé wu tɛ̂mɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Bo mo bo ja bo gɛɛne fɛ Jailu kfuuŋ, lɛ wu doo wu gɛɛŋ wu fɛsɛ fo, Jiso faŋ lɛ muh yeh lee gɛ. Wu jo gɛh nyu Bita bɛ Jɛm mo Joŋ mo chiji mwa bɛ bwe mwa bɛ bo lee. ");
INSERT INTO ncr_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Gɛ̀ bee bamii yode lo fo, kwe fiee lo fo. Jiso jɛmɛ lɛ, “Bɛŋ lû bɛ kwe, mwa wunɛ baaŋ kwe gɛ, wu lefe lo.” ");
INSERT INTO ncr_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bamii ja bo tu bo keede lo wu fo, nje bo gɛ̀ kee chuule lɛ mwa wuyu le wu kwe wa. ");
INSERT INTO ncr_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Wu gɛɛŋ fɛ mwa wuyu gɛ̀ gime fo, wu jijɛ wu yi kibo le wu tɛɛŋ lɛ, “Mwa wù kwɛse, ja we!” ");
INSERT INTO ncr_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Wu mo wu kaasɛ wu tu yu, wu mo wu ja we kimimia. Jiso jɛmɛ lɛ ba jiŋɛ fiɛɛ ba nya wu wu ji. ");
INSERT INTO ncr_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Bwee bɛ chiji yɛŋ fiɛɛ fì kooshi le, jwe yuŋ bo. Jiso leh lo lɛ keefɛ bo sɛ̂ɛŋ muh fiɛɛ fì kooshi gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jiso gɛ̀ ja wu tɛɛŋ booŋ be ba ŋgoo ba yuufe ncho bafɛɛ, bo taashɛ bo to. Wu nya bo bvuŋga bɛ je yì bo bvuuse banchɛndaa ba debele ye yi bamii le bo ka fɛde binchɛŋ, ");
INSERT INTO ncr_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","wu mo wu tuŋ bo lɛ bo gɛ̂ɛŋ bo fêeji bamii kune bvunfoŋ bvu Nyo bo ka fɛde bamii ba binchɛŋ. ");
INSERT INTO ncr_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Wu ka wu jɛmɛ bo le lɛ, “Bɛŋ doo bɛŋ gɛɛne, keefɛ muh jô fiɛɛ gɛ. Keefɛ muh jô kimbaŋ gɛ, mo nyume kikɛɛ gɛ, mo nyume fiɛɛ fijile gɛ, mo nyu bige gɛ. Keefɛ muh jô bikuŋ bifɛɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Bɛŋ doo bɛŋ gɛɛne bɛŋ lee ntɛ le, yeh yì ba gɛɛ bɛŋ yu, bɛŋ mo bɛŋ chêe gɛh nyu yu gɛɛŋ bu sege bɛŋ lé bɛŋ jâ ntɛ wɛɛ le. ");
INSERT INTO ncr_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nɛ ntɛ wumu le wu faŋ ki wu fî bɛŋ, bɛŋ ja yo, sege bɛŋ bude bɛŋ kaajɛ bibvunɛ bi yi bikaa biɛna le, fi ge fi nyume njiŋɛ yi fiɛɛ fì bo moŋ le.” ");
INSERT INTO ncr_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bo mo bo ja bo gɛɛne, bo gɛɛŋ bo tu bo jiɛnyi bantɛ le bantɛ le, bo feeji saaka wù joŋe wu kune bvunfoŋ bvu Nyo, bo mo bo fɛde bamii ba binchɛŋ bachii. ");
INSERT INTO ncr_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Hɛlod wù gɛ̀ sage kimbe ki woŋ kì Galalee yu mwɛɛ munchii mù gɛ̀ kooshi, mu fuuŋsɛ wu nje bamii bamu gɛ̀ jade bo duu lɛ Jiso wunɛ le Joŋ Nlesɛajoo wu kaase wu bu. ");
INSERT INTO ncr_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bamu duu lɛ le Alaja wu kaase wu to. Bamu duu fiboo lɛ le muh wu ntuŋ wu Nyo wu fweele wumu wu kaase wu bu yi kwe le. ");
INSERT INTO ncr_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hɛlod mo wu ghaa lɛ, “Joŋ le nche mbvusɛ wa kikwɛɛ ke. Wunɛ muh ka nyume yɛɛŋ mɛɛse wù mɛ n'yuge kfuu chi munɛ mwɛɛ kune wu?” Wu mo wu goone lɛ wu bee wu yɛŋ Jiso wɛɛ le. ");
INSERT INTO ncr_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Booŋ ba ntuŋ ba Jiso gɛ̀ jiɛnyɛ bo kaasɛ bo tu jiŋ, bo sɛɛŋ mwɛɛ munchii mù bo ge fɛ wu le. Wu mo wu ja wu jo bo bɛ bo kɛŋsɛ yo, bo bu bo gɛɛne je yi a kinlaantɛŋ kì Bɛsada le. ");
INSERT INTO ncr_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Geenɛ, kinchvu ki bamii kɛɛ ki kuŋe ki bii wu le, wu fi bo wu mo wu kɛ wu feeji kune bvunfoŋ bvu Nyo wu ka fɛde bamii ba chɛne. ");
INSERT INTO ncr_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Lɛ juu doo chi gɛɛne ki chi selɛ, booŋ ba Jiso ba ŋgoo ba yuufe ncho bafɛɛ bo kɛŋsɛ bo to bo jɛmɛ wu le lɛ, “Dû lɛ bamii banɛ le lɛ bo gɛ̂ɛŋ bantɛ bɛ ala a mbebe le, bo gû mwɛɛ muboo munjile bɛ fɛ bo lé bo chê fo, nje fɛnɛ le nchvuuŋ.” ");
INSERT INTO ncr_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jiso chvuu fie lɛ, “Le bɛŋ, bɛŋ lé bɛŋ nyâ bo fiɛɛ fì bo lé bo jî.” Bo jɛmɛ lɛ, “Fiɛɛ fì bee kɛme le gɛh chefe yi blɛd yishɛŋ bɛ bíɛŋ yifiɛɛ. Fuge noo sɛŋ tu wo goone lɛ bee gɛɛŋ be gu lo mwɛɛ munjile ŋguu le fɛ bee to be nya bamii banɛ le bachii.” ");
INSERT INTO ncr_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Bo gɛ̀ duu noo nje bamii gɛ̀ bee fo wesee, bilɛŋsɛ maa gɛ̀ bee njɛ banchvuge batɛŋ. Jiso mo wu jɛmɛ booŋ be ba ŋgoo le lɛ, “Bɛŋ du bamii baa shiiyɛ fɛkuu manjuu le manjuu le, njɛ mbaanshɛŋ, mbaanshɛŋ.” ");
INSERT INTO ncr_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bo jɛmɛ, bo mo bo shiiyɛ bo bachii. ");
INSERT INTO ncr_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jiso jo chefe yi blɛd yi yishɛŋ chiɛɛ bɛ bíɛŋ yi yifiɛɛ chiɛɛ, wu bijɛ we, wu nya kiyone Nyo le, wu mo wu bwɛɛyɛ wu nya booŋ be ba ŋgoo le lɛ bo gâ binchvu bi bamii baa le. ");
INSERT INTO ncr_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bo gajɛ, bamii bachii ji bo fuu, booŋ ba Jiso ba ŋgoo baanyɛ bimbɛge bì gɛ̀ gweeyɛ, bi yisɛ ŋkaa yuufe ncho yifiɛɛ. ");
INSERT INTO ncr_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Lɛ nyu juu chimi, Jiso buune wu maa, booŋ be ba ŋgoo nyu mbebe ye le. Wu ja wu biih bo le lɛ, “Bamii duu lɛ nle yɛɛŋ?” ");
INSERT INTO ncr_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bo chvuu lɛ, “Bamii bamu duu lɛ wo le Joŋ Nlesɛajoo, bamu lɛ Alaja, bamu duu lɛ wo le muh wu ntuŋ wu Nyo wu fweele wumu wu kaase wu bu yi kwe le.” ");
INSERT INTO ncr_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Wu mo wu biih bo le lɛ, “Bɛŋ duu finɛ lɛ nle yɛɛŋ?” Bita chvuu lɛ, “Wo le Mbvusɛ wù Nyo gɛ̀ ka.” ");
INSERT INTO ncr_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jiso mo wu chiisɛ bo le lɛ keefɛ bo ka bo môŋ lo bo sɛ̂ɛŋ finɛ muh le gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Wu mo wu jɛmɛ bo le lɛ, “Muh wù jee che le Mwamuh kɛme ki wu gê wu yɛŋ baŋgɛ ba duude, bamii ba sage woŋ bɛ bachiji kintanyɛ ba baaŋ baaŋ mo bamii ba duunyi banchi ba Nyo faŋ wu. Bo mo bo yuuyɛ wu, aju fe atade, wu kaasɛ wu bu yi kwe le.” ");
INSERT INTO ncr_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jiso mo wu jɛmɛ bamii le bachii lɛ, “Muh nɛ goone ki wù nyu muh waŋ, tu wù kɛme ki wu fâŋ kikwɛɛ ke, wu tûude kintaaŋ ke aju achii wu bii mɛne. ");
INSERT INTO ncr_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Bɛŋ kêe lɛ muh wù baji kinche ke, tu wu lé wu gê wu lɛsɛ gɛh lo ki. Geenɛ, muh wù lɛsɛ kinche ke nje mɛ, tu wu baji lo kinche ke. ");
INSERT INTO ncr_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ba banyi woŋ kfunɛ wuchii ba nya muh le, wu ji, ki wu lɛ̂sɛ kɛnɛ ki wu jîŋ kinche ke, mbe we nyu la? ");
INSERT INTO ncr_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Bɛŋ kêe lɛ muh kɛme bvuya ki wu bîi mɛne mo jɛ yaŋ le, wu mo wu kee lɛ muh wù jee che le Mwamuh lé wu gê wu kɛ̂me tɛ bvuya fɛ mwɛdɛ le sege wu kaasɛ wu to antɛnɛɛ a bvukugɛ bwe, bvù ka nyume tɛ bvu Nyo wù le chiji banchɛndaa be ba yuude. ");
INSERT INTO ncr_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nsɛŋe bɛŋ nchiɛɛŋ lɛ, bamii bamu lɛme fɛnɛ bo nyu gɛ bo to bo yu wuŋ wu kwe gɛ fɛ bo yɛŋ mo fɛ Nyo sage bvunfoŋ bwe fo gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Gɛ̀ bee gɛh njɛ aju nyaaŋ, no Jiso jɛme mwɛɛ munɛ, wu jo Bita bɛ Joŋ mo Jɛm bɛ bo bɛɛŋ yi mbegɛ wumu le lɛ wu gɛɛŋ wu buunɛ. ");
INSERT INTO ncr_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Wu gɛɛŋ wu doo wu buune, nfiɛɛnɛ ye ja yi kusɛ, nju ye tɛ kusɛ yi tu yi baaŋ yi lale nɛ mwawmwawmwaw. ");
INSERT INTO ncr_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Fi kooshɛ lɛ bamii bafɛɛ, nyu Musɛ bɛ Alaja gɛ̀ bee bo ja bo bunɛ bo tu bo jɛme bɛ Jiso. ");
INSERT INTO ncr_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","N'yulɛ wù Nyo baaŋ yi bo le. Bɛ bo jɛme kune kwe yi Jiso gɛ̀ kɛme ki wu gɛ̂ɛŋ wu kwe Yɛlusalɛm ki fi gê fi to fi kojɛ no Nyo gɛ̀ gɛlɛ. ");
INSERT INTO ncr_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Bo gɛ̀ jɛme noo, Bita bɛ Joŋ mo Jɛm lefɛ goge lo bo. Bo doo bo kaŋsɛ, bo yɛŋ no n'yulɛ wù Nyo baaŋ ye yi Jiso le, bo ka bo yɛŋ bamii bafɛɛ baa le bo lɛme bɛ wu. ");
INSERT INTO ncr_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Bamii ba bafɛɛ bayu doo bo baa bikaa, Bita ja wu bunɛ wu jɛmɛ Jiso le lɛ, “Chiji Kikwɛɛ, fi joŋe no bee le fɛnɛ. Chinɛ bee jooŋ chúŋ yishɛde, yimi nyu yo, yimi nyu yi Musɛ, yimi nyu yi Alaja.” Wu gɛ̀ jɛme noo, wu kee gɛ mo fiɛɛ fì wu jɛme gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Gɛh no wu baaŋ wu jɛme noo, kimbɛ ja ki to a bo we ki baŋɛ bo. Bo tu bo kɛmɛ nfaaŋ no bo gɛ̀ bee a kimbɛ ntɛnɛɛ. ");
INSERT INTO ncr_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Jɛ bu a kimbɛ kiyu le yi jɛmɛ lɛ, “Wunɛ le Mwa yaŋ wu nle ncha. Bɛŋ yûge wu le.” ");
INSERT INTO ncr_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","No jɛ yɛɛ jɛme noo yi mɛsɛ, bo ja bo yɛŋ Jiso lɛme fo wumaa. Bo gɛ ka bo sɛɛŋ muh fiɛɛ fì bo yɛŋ yi mbegɛ wɛɛ le kife kiyu le gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Akfuuŋ gɛ̀ bu a yuu, bɛ ba Jiso ja yi mbegɛ le bo tu bo bohge. Bo doo bo bohge, bo tasɛ bɛ kinchvu ki bamii kì duude. ");
INSERT INTO ncr_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Lɛ bo bijɛ bo yɛŋ muh mu wu ja wu tu wu wanɛ a kinchvu kɛɛ ntɛnɛɛ lɛ, “Muh wu N'yɛyɛ, kii wo bijɛ gɛh fɛ mwa yaŋ le. Kagɛ mwa yaŋ wunɛ nɛ. ");
INSERT INTO ncr_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kiyo kimi jade kichufɛ wu ki noŋ, wu tage, wu funɛ, bifuu bude a wu mu. Ki gɛɛne lo bɛ wu, gɛ ki bɛme lɛ wu yɛnɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mbe nlɛgɛ wa booŋ buŋ ba ŋgoo lɛ bo bvusɛ kiyo kiyu bo moŋ sɛŋ.” ");
INSERT INTO ncr_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jiso yu noo, wu jɛmɛ lɛ, “O oo! Kiŋgogɛ kì achiji kì baaŋ lee gɛ fitele yi Nyo le gɛ. Nlé nyû bɛ bɛŋ ŋgɛ̂ɛŋ mbû nɛɛ, nlé ŋkâaŋ shɛ́ŋ bɛ bɛŋ ŋgɛ̂ɛŋ mbû nɛɛ?” Wu mo wu jɛmɛ chiji mwa wɛɛ le lɛ, “Tô bɛ mwa yo fɛnɛ!” ");
INSERT INTO ncr_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wu jo wu doo wu too bɛ wu, nchɛndaa debele wɛɛ ka wu chiaasɛ mwa wɛɛ wu noŋ fɛkuu, wu tage. Jiso waŋ kiyo kì yiide kiyu ki bu yi mwa wɛɛ le, wu mo wu tɛmɛ. Jiso mo wu nya wu chiji le. ");
INSERT INTO ncr_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bamii bachii yɛŋ bvuŋga bvù le bvu Nyo le, jwe yuŋ bo. No bo gɛ̀ baaŋ bo kɛme kiŋgha ki mwɛɛ munchii mù Jiso gɛ̀ gee le, wu ja wu jɛmɛ booŋ bɛ ba ŋgoo le lɛ, ");
INSERT INTO ncr_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Bɛŋ yêgɛ chuule fiɛɛ fì nle njɛme bɛŋ le. Muh wù jee che le Mwamuh lé ba nyû ba gê ba nyâ wu chiaaŋ yi bamii le.” ");
INSERT INTO ncr_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Lɛ wu jɛmɛ noo, bo gɛ kɛɛ fiɛɛ fì wu jɛme gɛ, nje fiɛɛ fimi gɛ̀ baŋe lɛ keefɛ bo kɛ̂ɛ gɛ, geenɛ bo gɛ̀ faŋ ki bo biih kune njɛmɛ wuyu. ");
INSERT INTO ncr_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Bo gɛ̀ ja bo kɛ kintɛɛnyɛ lɛbolɛbo laa bo le nɛ muh wù baaŋ a bo ntɛnɛɛ le yɛɛŋ la. ");
INSERT INTO ncr_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jiso kɛɛ fiɛɛ fì bo gɛ̀ kwaji fɛ muntele muboo le, wu mo wu jo mwa wù shige wu gɛɛ mbebe ye le, ");
INSERT INTO ncr_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","wu jɛmɛ bo le lɛ, “Muh nɛ fii mwa njɛ wunɛ a jee chaŋ le, tu wu fii nyu mɛ. Muh fii mɛ, tu wu fii nyume muh wù tuŋ mɛ. Fi mo fi nyu lɛ, muh wù jode kikwɛɛ ke njɛ mwa wù shige a bɛŋ ntɛnɛɛ le wu, wu le muh wù baaŋ.” ");
INSERT INTO ncr_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Joŋ biih wu le lɛ, “Chiji kikwɛɛ, bee le be yɛŋ muh mu le wu tɛŋe jee chuŋ fɛ wu bvuuse banchɛndaa ba debele yi bamii le, be faŋ, nje gɛ wu nyu muh ŋgoo yese le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jiso chvuu fie lɛ, “Keefɛ bɛŋ chîde kfuu chi wɛɛ muh gɛ, nje muh wù baaŋ baa gɛ jiŋ bɛŋ le gɛ, tu wu toone lo bɛŋ.” ");
INSERT INTO ncr_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kife kì Nyo gɛ̀ bee ki wu jô Jiso wu bɛɛŋ bɛ wu we lɛ ki to ki kojɛ, Jiso soge gɛh ki wu gɛ̂ɛŋ Yɛlusalɛm, wu mo wu ja wu gɛɛne. ");
INSERT INTO ncr_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Wu doo wu ja, wu tuŋ bamii bamu fwe. Bo gɛɛŋ bo lee ntɛ wumu wu Samaliya le lɛ bo seesɛ kijusɛ yo wu le. ");
INSERT INTO ncr_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bamii ba yo kuŋ wu bɛ kijusɛ bo faŋ ki bo fi wu, nje bo gɛ̀ kee lo lɛ wu fede wu gɛɛne nyu Yɛlusalɛm. ");
INSERT INTO ncr_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jɛm bɛ Joŋ ba le booŋ ba Jiso ba ŋgoo gɛ̀ yu fiɛɛ fiyu, bo biih lɛ, “Tada, bee tɛɛŋ ŋgu we wu shii wu to wu lɛɛshɛ bamii bayu?” ");
INSERT INTO ncr_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jiso kaasɛ ye wu waŋ bo, ");
INSERT INTO ncr_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","wu mo wu ja bɛ booŋ be ba ŋgoo bo mo bo tu bo gɛɛne wa je yi ntɛ wumu le yeye. ");
INSERT INTO ncr_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Bɛ bo doo bo gɛɛne, muh mu jɛmɛ Jiso le lɛ, “Nlé mbîi wo le manjuu manchii ma wo gɛɛne fo.” ");
INSERT INTO ncr_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jiso chvuu wu le lɛ, “Binchombiaŋ kɛme bintuge biboo, munyii mù fuune we kɛme yéh yiboo, geenɛ gɛ̀ muh wù jee che le Mwamuh kɛme lo fɛ wu giŋsɛ kikwɛɛ ke fo gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jiso ja wu jɛmɛ muh mu le lɛ, “Wo bîi mɛne!” Muh wɛɛ chvuu lɛ, “Tada, chinɛ mɛne n'ya ŋgɛɛŋ jiiyɛ chijaŋ fɛ mbii wo le.” ");
INSERT INTO ncr_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Geenɛ Jiso chvuu wu le lɛ, “Chînɛ bamii ba kweeyɛ wa jîiyi biŋkwe biboo, wo gɛ̂ɛŋ fiuŋ wo fêeji kune bvunfoŋ bvu Nyo.” ");
INSERT INTO ncr_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Muh mu ka wu jɛmɛ lɛ, “Tada, nlé mbîi wo le, geenɛ ya chinɛ ŋgɛɛŋ n'yɛsɛ kfuu chaŋ le fɛ mbii wo le.” ");
INSERT INTO ncr_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jiso chvuu muh wɛɛ le lɛ, “Muh ŋgvuumɛ bɛ ji ki wu lɛ̂ŋ lɛme, wu ka lɛne wu jiiŋe jiŋ, tu mwɛdɛ baaŋ kojɛ gɛ ki wù nyu antɛnɛɛ a bvunfoŋ bvu Nyo le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ajiŋ ayu, Tada baayɛ bamii bamu mbaŋbvusooshwi ncho bafɛɛ. Wu tuŋ fwe, bafɛɛ bafɛɛ lɛ bo gɛɛŋ bantɛ le yeye yeye, bo gɛɛŋ bo jiɛnyi manjuu ma wu lé gê wu fê mo le manchii. ");
INSERT INTO ncr_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Wu doo wu tune bo wu jɛmɛ lɛ, “Ŋgwejɛ duude baaŋ geenɛ bamii ba gwejɛ nyu shige. Noo, bɛŋ bûune lɛ Tada wù Chiji mwɛ, chîiŋsɛ bamii ba ŋgwejɛ a wu mwɛne. ");
INSERT INTO ncr_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Bɛŋ gɛ̂ɛne le. Bîjɛ yɛ̂ŋ bɛŋ doo bɛŋ gɛɛne bɛŋ kee lɛ ntune bɛŋ lɛ bɛŋ gɛɛŋ bɛŋ nyu njɛ booŋ ba shóŋ antɛnɛɛ a baŋgvufe. ");
INSERT INTO ncr_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bɛŋ doo bɛŋ gɛɛne, keefɛ muh jô kikɛɛ kɛnɛ bige mo jé yimi gɛ. Bɛŋ doo bɛŋ bu a je, keefɛ bɛŋ lɛ̂mɛ bɛŋ yɛɛse bamii le gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Bɛŋ doo bɛŋ gɛɛne bɛŋ lee yeh yì bɛŋ lé bɛŋ lêe yu, bɛŋ ya bɛŋ jɛmɛ yeh yɛɛ le lɛ, ‘Kimbonɛ nyûme yeh kfunɛ.’ ");
INSERT INTO ncr_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Muh wù koŋe kimbonɛ nɛ le yu, kimbonɛ kena mɛ yeh kwɛɛ. Muh nɛ yu gɛ, kimbonɛ kɛɛ kaasɛ ki tu jiŋ a bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Sege bɛŋ lee yeh, bɛŋ mo bɛŋ mɛ gɛh bɛŋ chee gɛh nyu yu. Keefɛ bɛŋ kûse yéh gɛ. Fiɛɛ fijile fichii fi ba nya bɛŋ le, bɛŋ jii, kɛnɛ nyu fimule, bɛŋ muu, nje muh wu lɛne lɛme, kɛme ki wù kɛme nlaŋɛ we. ");
INSERT INTO ncr_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Bɛŋ lee ntɛ le, ba fi bɛŋ, ba nya mo la lɛ bɛŋ ji, bɛŋ mo bɛŋ jii lo. ");
INSERT INTO ncr_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Bɛŋ doo bɛŋ nyume yo, bɛŋ mo bɛŋ fɛ̂de bamii ba chɛne, bɛŋ ka bɛŋ feeji bamii le bachii lɛ bvunfoŋ bvu Nyo le wa mbebe yiboo le. ");
INSERT INTO ncr_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Geenɛ, bɛŋ lee ntɛ le, ba faŋ ki ba fi bɛŋ, bɛŋ bu bɛŋ gɛɛŋ bifiaŋ bi jé le bɛŋ jaŋ lɛ, ");
INSERT INTO ncr_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Mo kibvunɛ ki ntɛ wunɛ le ki bee jo yi bikaa biɛsa le nɛ ki kinɛ fɛnɛ no bee kaaji, fiɛɛ fichii kaasɛ fi tu yi bikwɛɛ biɛna le. Geenɛ, bɛŋ kêe lɛ bvunfoŋ bvu Nyo le wa mbebe le.’ ");
INSERT INTO ncr_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nsɛŋe bɛŋ le lɛ, lé tô nyûme juu chi nsa wu fɛkimɛsɛ, mwɛɛ bonɛ fɛ kilaantɛŋ ki Sodom le fede kilaantɛŋ kɛɛ le.” ");
INSERT INTO ncr_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jiso ja wu jɛmɛ lɛ, “Ŋgɛ wù baaŋ le wene bɛŋ bamii ba Kolasiŋ, ŋgɛ wù baaŋ le tɛ wene bɛŋ bamii ba Bɛsada. Bɛŋ kêe lɛ, nɛ ŋgɛ̀ ŋge biŋgha bi mwɛɛ bì ŋgɛ̀ ŋge bɛŋ le nyume Taya bɛ Sidoŋ, tu bo gɛ̀ bee bo jii wa bimbaŋkwe, bo kfuuŋ taaŋ ye le nchensɛŋ ki bo dunyɛ lɛ bo le bo kusɛ wa muntele muboo. ");
INSERT INTO ncr_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Bɛŋ kêe lɛ lé tô nyûme juu chi nsa wù fɛkimɛsɛ, mwɛɛ bonɛ fɛ bamii ba Taya le mo ba Sidoŋ le fede fɛ bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mo bɛŋ bamii ba Kafanahum, bɛŋ kwaji lɛ ba lé ba gê ba bɛ̂ɛŋsɛ bɛŋ, bɛŋ bɛɛŋ fɛwe? Aay! Ba lé ba shîishɛ lo bɛŋ bɛŋ shii bɛŋ gɛɛŋ woŋ wu baŋkfu le.” ");
INSERT INTO ncr_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jiso mo wu jɛmɛ bamii ba wu gɛ̀ tuŋ baa le lɛ, “Muh nɛ yûge bɛŋ le, tu mwɛdɛ yuge nyume mɛne, muh faŋ bɛŋ, tu wu faŋ nyume mɛ. Muh faŋ mɛ, tu mwɛdɛ faŋ nyu muh wu tuŋ mɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Bamii ba mbaŋbvusooshwi ncho bafɛɛ baa jiɛnyɛ bo tu jiŋ bo yuge njoŋ, bo mo bo duu Jiso le lɛ, “Tada, bee chi tɛŋe jee chuŋ, mo banchɛndaa ba debele, bo yuge bee le.” ");
INSERT INTO ncr_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jiso chvuu bo le lɛ, “Nchi n'yɛŋ debele gwe njɛ jaŋ fɛ yi lalɛ we yi lee fɛkuu ");
INSERT INTO ncr_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nle nya wa bvuŋga bɛŋ le bvù taŋlo bɛŋ jiɛnyi yó bɛ baŋgaŋ yu. Mo ŋka nya bɛŋ bvuŋga bvù bɛŋ yage bvuŋga bvu debele wu muh wu kimbanɛ yu bvuchii. Gɛ taŋlo fiɛɛ shiŋshɛ bɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Geenɛ, keefɛ bɛŋ yûge njoŋ lɛ banchɛndaa ba debele yuge bɛŋ le gɛ. Bɛŋ yûge njoŋ nyu lɛ ajee a wene le ba saŋ wa a Ŋwa wu Nyo le fɛwe.” ");
INSERT INTO ncr_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Gɛh kife kiyu le, Kiyo ki Yuude ge njoŋ yuu lo Jiso. Wu mo wu jɛmɛ lɛ, “Nnyaa kiyone wo le Chii Nfoŋ kibvulɛ bɛ nshɛŋ no wo le wo nyilɛ mwɛɛ munɛ ba bvufee le mo baŋkɛɛ fiɛɛ le, wo dunyɛ nyu mumwone mù bwele le. Le no fi le Chii, nje le no wo gɛ̀ goone lɛ fi nyume.” ");
INSERT INTO ncr_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jiso ka wu jɛmɛ lɛ, “Chii le wu nya wa mwɛɛ munchii mɛne. Gɛ muh nyu yu wu kee Mwa wu le mɛ gɛ, le gɛh Chii maa wu kee. Gɛ muh nyu yu wu kee Chii gɛ, le gɛh mɛ wù Mwa ye mo bamii ba Mwa le wu cha wa ki wu dûnyɛ Chii bo le.” ");
INSERT INTO ncr_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Wu ja wu kaasɛ ye wu jɛmɛ booŋ be ba ŋgoo le lɛbolɛbo lɛ “Njoŋ wù baaŋ le wene lɛ ajii a wene yɛne mwɛɛ munɛ le. ");
INSERT INTO ncr_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Bɛŋ kêe lɛ bamii ba ntuŋ wu Nyo ba duude bɛ banfoŋ gɛ̀ shee bo beede ki bo yɛŋ mwɛɛ mù bɛŋ yɛne le, bo gɛ baaŋ yɛŋ gɛ. Bo tu bo beede tɛ ki bo yu mwɛɛ mù bɛŋ yuge, bo gɛ baaŋ yu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Fi ja fi kooshɛ lɛ, muh mu wù gɛ̀ kee banchi ba Nyo chuule, gɛ̀ ja wu to ki wu môŋ Jiso, wu mo wu biih wu le lɛ, “Muh wu N'yɛyɛ, fiɛɛ fì ŋkɛme ki ŋge fɛ ŋkɛmɛ kinche kì kage gɛ le la?” ");
INSERT INTO ncr_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jiso biih wu le lɛ, “Ba le ba saŋ a Ŋwa wu banchi ba Nyo le lɛ muh gêe nyu nɛɛ? Wo tɛŋe wo yuge lɛ la?” ");
INSERT INTO ncr_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Wu chvuu lɛ, “Ba le ba saŋ lɛ, ‘Wo kôŋe Tada Nyo wo bɛ fitele fiuŋ fichii, wo nyâ kikwɛɛ kuŋ wu le kichii, wo lɛ̂ne wu le bɛ bvuŋga bwuŋ bvuchii, wo gɛ̂ɛde bvufee bwuŋ bvuchii ye ye le, wo ka wo kôŋe muh wù le mbebe yo le gɛh no wo koŋe kikwɛɛ kuŋ.’” ");
INSERT INTO ncr_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jiso jɛmɛ lɛ, “Wo le wo chvuu chuule. Wo gêe noo wo mo wo kɛme kinche kì kage gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Muh wɛɛ mo wu ja wu lɛɛŋ wu goone ki wu chûnyɛ lɛ wu le muh, wu mo wu biih Jiso le lɛ, “Muh wù le mbebe yaŋ le le yɛɛ?” ");
INSERT INTO ncr_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jiso tu wu chvuu nyu a ŋgaŋ le lɛ, “Muh mu gɛ̀ ja Yɛlusalɛm wu bohge Jɛliku, wu doo wu gɛɛne wu gwe chiaaŋ yi bachoŋ le. Bo suŋ wu, wu chidɛ, bo baayɛ njú ye bo jo bɛ mwɛɛ mwe munchii, bo mo bo noŋ wu fo bo legɛ bo gɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Fi gɛ̀ ja fi kooshɛ lɛ muh mu gɛ̀ boge je yiyu le, nyu chiji kintanyɛ, wu yɛŋ muh wuyu le, wu wɛɛŋ lo wu fe. ");
INSERT INTO ncr_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Muh mu tɛ gɛ̀ ja wu too, nyu muh wu kfuu chi Lɛwe le, lɛ wu to wu bu fo, wu yɛŋ wu le, wu wɛɛŋ lo tɛ wu fe. ");
INSERT INTO ncr_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Geenɛ, muh mu gɛ̀ ja wu jiɛnyi tɛ wu too, nyu muh wu Samaliya. Wu gɛ̀ to wu bu fo, wu yɛŋ wu le wu koo yii fɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Wu gɛɛŋ mbebe ye le, wu fuushɛ mbvuuŋ bɛ mɛɛ fɛ banfu be le, wu kaaŋ bɛ nju, wu mo wu tuu wu yi nyaŋ ye yi wu gɛ̀ jiɛnyi yu wege le, wu gɛɛŋ bɛ wu yeh yì bamii ba jiɛnyɛ gɛ̀ too bo chee yu wu jiiŋe fɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Bɛ wu che, bvu bu bvu yuu, wu bvusɛ badanale bafɛɛ wu nya muh yeh yiyu le, wu jɛmɛ wu le lɛ, ‘Shɛɛ wo jîiŋe fɛ muh wunɛ le. Wo nɛ le wo shɛɛ wo lɛsɛ bige bi fesɛ, ndoo ŋkaasɛ nchvuu wo le.’” ");
INSERT INTO ncr_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","No Jiso ma noo, wu mo wu biih muh wɛɛ wù gɛ̀ kee nchi le lɛ, “Antɛnɛɛ a bamii ba batɛde banɛ, wo yɛne lɛ le muh wù la wù gɛ̀ dunyɛ lɛ wu le muh wù mbebe muh wɛɛ wù bachoŋ gɛ̀ suŋ le?” ");
INSERT INTO ncr_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Wu chvuu lɛ, “Le muh wù gɛ̀ kolɛ yii fɛ muh wuyu le.” Jiso mo wu jɛmɛ wu le lɛ, “Wo gɛ̂ɛne, wo gɛɛŋ wo gêe tɛ noo.” ");
INSERT INTO ncr_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jiso bɛ booŋ be ba ŋgoo gɛ̀ ja bo tu bo gɛɛne, bo gɛɛŋ bo lee ntɛ wumu le, kwɛse wumu nyu yo ba tɛŋe lɛ Mata. Wu fi Jiso a wu yeh. ");
INSERT INTO ncr_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Wu gɛ̀ kɛme jɛme yimi ba tɛŋe lɛ Mɛɛle. No Jiso gɛ gɛnɛ wu lee yu, Mɛɛle mo wu gɛɛŋ wu shii mbebe ye le wu yege fiɛɛ fì wu yɛyi. ");
INSERT INTO ncr_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mata nyu fie wu luume nyu bɛ ntɛ. Wu gɛ̀ ja wu to wu biih Jiso le lɛ, “Tada, wo yɛde gɛh no jɛme yaŋ le yi chinɛ mɛne mbuge mɛ maa, wo ghade gɛ? Du gɛh lɛ wu to wu fih mɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tada chvuu wu le lɛ, “Mata, Mata, wo buge, wo nyaa ŋgɛ kikwɛɛ kuŋ le yi mwɛɛ mù duude le, ");
INSERT INTO ncr_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","fiɛɛ fì fishaŋ le gɛh fimimia. Mɛɛle le wu cha wa fiɛɛ fì fishaŋ, gɛ muh nyu yu wu ka wu fi a wu le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Gɛ̀ bee juu chimi, Jiso buune kijusɛ kimi le, wu bûunɛ wu mɛsɛ, mwa ye wu ŋgoo wumu du wu le lɛ, “Tada, yɛyɛ bee no be buune, gɛh yɛɛŋyɛɛŋ no Joŋ tɛ gɛ̀ yɛyɛ bamii be ba ŋgoo no bo buune.” ");
INSERT INTO ncr_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jiso mo wu jɛmɛ bo le lɛ, “Bɛŋ doo bɛŋ buune bɛŋ mo bɛŋ jɛ̂me lɛ, ‘Chiji wese, gêe bamii ŋgvûune jee chuŋ, wo gê lɛ bvunfoŋ bwuŋ to. ");
INSERT INTO ncr_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Wo nyâ bee mwɛɛ munjile aju achii, ");
INSERT INTO ncr_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","lɛ̂ɛshɛ bimbefɛ biɛsa, no bee tɛ lɛɛshi bimbefɛ bì bamii bamu gee fɛ bee le. Keefɛ wo chînɛ bee lee moŋ wù ya bee le gɛ.’” ");
INSERT INTO ncr_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","No wu jɛmɛ noo wu mo wu be bo le lɛ, “Bɛŋ jô lɛ, muh mu bɛŋ le wu ja wu gɛɛŋ wu kuŋ yeh yi nsaa ye antaŋ antɛnɛɛ wu jɛmɛ lɛ, ‘Nsaa yaŋ, ja gɛh we wo foosɛ mɛ bɛ chefe yi bvulɛɛŋ yi shɛde. ");
INSERT INTO ncr_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Nsaa yaŋ yimi le yi ja yi bunɛ yi la mɛ jigɛ, n'ya ŋkɛme gɛ fiɛɛ fì nlé ntɛ̂ wu yu gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ba jo lɛ nsaa yo yi wo be kuŋ yɛɛ kaasɛ yi chvuu fie yeh wo le lɛ, ‘Keefɛ wo fûuŋse mɛ gɛ. Besa booŋ baŋ le be giiŋ wa be faa kimbuŋ. Gɛ taŋlo ŋka nja we lɛ ŋgoone fiɛɛ fì nnya wo le gɛ.’” ");
INSERT INTO ncr_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","No Jiso be noo, wu ka wu jɛmɛ lɛ, “Nsɛŋe bɛŋ le lɛ wu nɛ baaŋ ja gɛh we wu nya wo bvulɛɛŋ bvù wo biide nje wu le nsaa yo sɛŋ, tu wu lé wu gê wu jâ gɛh we wu nya wo fiɛɛ fichii fì wo goone sege wo mɛ gɛh fo wo kune. ");
INSERT INTO ncr_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Njɛme bɛŋ le lɛ, bɛŋ bîide, Nyo lé wu nyâ bɛŋ le. Bɛŋ ŋgôone, Nyo lé wu gê bɛŋ yɛ̂ŋ. Bɛŋ kûne kimbuŋ, Nyo lé wu gwênyɛ bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Bɛŋ kêe lɛ muh wuchii wu biide, wu lé wu gê wu kɛ̂mɛ, muh wuchii wu goone, lé wu gê wu yɛ̂ŋ, muh wu kune kimbuŋ lé ba nyû ba gwênyɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Le chiji mwa wu la a bɛŋ ntɛnɛɛ wù mwa ye biide biɛŋ, wu nya wù nyu yo? ");
INSERT INTO ncr_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Noo lɛ mwa be biide nyu gine wo nya wù nyu ŋgaŋ le? ");
INSERT INTO ncr_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","No bɛŋ le bamii ba befe bɛŋ kee ki bɛŋ nya mwɛɛ mù njoŋe booŋ bena le, tu gɛ taŋlo Chiji wene wù le fɛwe nya tɛ Kiyo ki Yuude bamii ba biide wu le fede noo gɛ?” ");
INSERT INTO ncr_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jiso gɛ̀ bvusɛ banchɛndaa ba debele yi muh mu le nyu kinchifɛ. No nchɛndaa wu debele wuyu gɛ̀ bu, muh wuyu mo wu kɛ wu jɛme. Kinchvu ki bamii yɛŋ noo bo kɛmɛ lo kiŋgha baaŋ. ");
INSERT INTO ncr_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Geenɛ bamii bamu tu bo duu lɛ, “Wu bvuuse banchɛndaa ba debele nɛ nyu bɛ bvuŋga bvu Bɛsebu wu Nfoŋ banchɛndaa ba debele.” ");
INSERT INTO ncr_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bamii bamu tu bo lɛge ki bo koo wu bo duu lɛ wu gê fiɛɛ fì duunyi lɛ bvuŋga bvunɛ ja fɛwe. ");
INSERT INTO ncr_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jiso kɛɛ baŋkwajɛ baboo wu mo wu jɛmɛ lɛ, “Kituŋ nɛ ja ki gade, ki tu ki juu lɛkilɛki, tu gɛ ki nyu ki lɛɛŋ gɛ. Kfuu ja chi gade chi juu lɛchilɛchi tu chi le chi gwe. ");
INSERT INTO ncr_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Le gɛh yɛɛŋyɛɛŋ no Sataŋ bɛ ŋgoo ye ja bo gade bo tu juu lɛbolɛbo, bvunfoŋ bwe gɛ ka bvu lɛɛŋ gɛ. Njɛme noo nje bɛŋ duu lɛ mbvuuse banchɛndaa ba debele nyu bɛ bvuŋga bvu Bɛsebu. ");
INSERT INTO ncr_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Fi nɛ le lɛ mbvuuse banchɛndaa ba debele nyu bɛ bvuŋga bvu Bɛsebu, tu bena booŋ bvuuse nyu bɛ bvu yɛɛŋ? Fiɛɛ fì booŋ bena bayu gee, duunyi lɛ bɛŋ le bɛŋ gwe wa nsa. ");
INSERT INTO ncr_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Geenɛ nɛ mbvuuse banchɛndaa bayu nyu bɛ kibo ki Nyo, tu bvunfoŋ bvu Nyo bvu yu le bvu to wa fɛ bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Bɛŋ kêe lɛ sege muh wu tɛɛme seesɛ wa mwɛɛ mwe mu jɛŋ wu shii wu tu wu chiɛɛne la che yu, muh gɛ ka wu shiŋshɛ fiɛɛ fie gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Geenɛ, ŋga wumu wu fede wu ja lo wu to wu juu bɛ wu, wu suŋ wu, wu mo wu lo mwɛɛ mwe mu jɛŋ munchii mù wu gɛɛde kikwɛɛ ke yu, wu ka wu banyɛ mwɛɛ mwe munchii wu gɛɛŋ bɛ nsáa ye ga. ");
INSERT INTO ncr_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nɛ muh baaŋ nyu gɛ kimbe kaŋ le gɛ, tu wu banɛ mɛ. Muh le njɛ wu fiih mɛ ki be baanyi lo sɛŋ, tu wu saayi lo. ");
INSERT INTO ncr_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Sege kiyo kì yiide le ki bu ye yi muh le ki mo ki gɛ̂ɛŋ nchvuuŋ ki goone fɛ ki lé ki chêe fo. Geenɛ ki doo ki gooŋ sɛŋ, ki mo ki jɛ̂mɛ kikwɛɛ ke le lɛ, ‘Nlé ŋkâasɛ ntû a mɛ yeh fɛ nchi mbu fo.’ ");
INSERT INTO ncr_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Sege ki kaasɛ ki tu jiŋ ki yɛŋ yeh yiyu nyu ba yɛɛsɛ, ba seesɛ yi tu yi yuude, ");
INSERT INTO ncr_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ki mo ki kâasɛ ki gɛɛŋ, ki to bɛ biyo bimi bvusooshwi bì befe bì fede ki, bɛ bi mo bi to bi lee bi chee fo. Mwɛɛ mo mu mɛsɛ mu fo lo fɛ mwɛdɛ le segeyu fede no mu gɛ̀ shee mu nyume.” ");
INSERT INTO ncr_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","No Jiso gɛ̀ baaŋ wu jɛme mwɛɛ munɛ nɛ, kwɛse wumu ja wu jaŋe a kinchvu ki bamii kɛɛ ntɛnɛɛ wu jɛme lɛ, “Kinlaŋye kì baaŋ le ki kwɛse wu gɛ̀ boyɛ wo, wu ka wu yaŋsɛ wo.” ");
INSERT INTO ncr_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jiso chvuu fie lɛ, “Kinlaŋye kì baaŋ le nyu ki bamii ba yuge jɛ yi Nyo bo gee no yi goone.” ");
INSERT INTO ncr_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","No binchvu bi bamii gɛ̀ taashi bi too mbebe ye le, wu ja wu jɛmɛ lɛ, “Kiŋgogo kì mɛɛse kinɛ le kì befe. Ki goone kì ki yɛŋ kiŋgha ki fiɛɛ fì duunyi bvuŋga bwaŋ le, gɛ taŋlo ndunyɛ ki le gɛ. Geenɛ, kiŋgha ki fiɛɛ baaŋ ya gɛ njiŋɛ wu muh wu ntuŋ wu Nyo wù Jona gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","No fiɛɛ fì Jona gɛ̀ ge, gɛ̀ bee kiŋgha ki fiɛɛ fɛ bamii ba Ninibɛ le, le gɛh yɛɛŋyɛɛŋ no fiɛɛ fì muh wù jee che le Mwamuh gee lé gê nyûme kiŋgha ki fiɛɛ fɛ kiŋgogo kì mɛɛse kinɛ le. ");
INSERT INTO ncr_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Lé tô nyu juu chì fɛkimɛsɛ Yaa wù gɛ̀ sage kituŋ kì Shɛba wu lɛɛŋ bɛ kiŋgogɛ ki mɛɛse kinɛ wu leesɛ ki ŋgɛ le, nje wu gɛ̀ ja a kituŋ ke le a woŋ juuse yo, ki wu tô wu yu bvufee bvu Nfoŋ Salamoŋ. Geenɛ bɛŋ yêgɛ bɛŋ yû, muh mu le fɛnɛ bɛ fiɛɛ fì kuge fi fede fi Salamoŋ. ");
INSERT INTO ncr_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Bamii ba Ninibɛ lé bo gê bo lôoŋ tɛ kiŋgoge ki mɛɛse kinɛ abvu bwɛɛ lɛ ki gɛ̀ jiaa baaŋ, nje bo gɛ̀ yu fiɛɛ fì Jona gɛ feeji, bo kusɛ muntele muboo. Geenɛ nɛ muh mu wunɛ fɛnɛ bɛ fiɛɛ fì fede fi Jona, bɛŋ kuse gɛ muntele mwɛna gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Gɛ muh to wu chu kin'yesɛ wu lee agaaguu gɛ. Gɛ taŋlo tɛ muh ka wu jo ŋkaa wu kfuusɛ yu gɛ. Wu to wu chude kin'yesɛ, wu toome nyu yi fiɛɛ fì ba to ba toome kin'yesɛ fo, lɛ bamii doo bo lese yeh bo yɛde n'yulɛ le. ");
INSERT INTO ncr_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ajii a wo le kin'yesɛ kì le yi ye yo le. Jise chuŋ nɛ yuude lo, tu ye yo yichii le yi yisɛ bɛ n'yuu. Geenɛ, jise chuŋ nɛ yuude gɛ, tu ye yo yichii le yi yisɛ lo bɛ kijibɛ. ");
INSERT INTO ncr_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Fi mo fi tu fi nyu lɛ, wo jîiŋe laa wo jiɛnyi nyu antɛnɛɛ a n'yuu noo, antɛnɛɛ a kijibɛ le lɛ. ");
INSERT INTO ncr_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nɛ ye yo le yi yisɛ bɛ n'yuu kimbe kimi nyu gɛ yi kijibɛ le gɛ, tu mwɛɛ munchii le mu mo mu yuude gɛh njɛ no kin'yesɛ to ki baaŋ ki nyaa n'yulɛ ye yo le.” ");
INSERT INTO ncr_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jiso gɛ̀ mɛsɛ njɛmɛ we, muh wu Bafalashii wumu tɛɛŋ wu lɛ wu to bɛ wu gɛɛŋ bo ji mwɛɛ. Jiso mo wu gɛɛŋ, wu lee, wu shii bɛ wu mo bo jii mwɛɛ, ");
INSERT INTO ncr_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","wu gɛ̀ baaŋ chiaaŋ chugɛ gɛ. Muh Bafalashii wɛɛ bijɛ fi ya wu. ");
INSERT INTO ncr_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tada kɛɛ fiɛɛ fì wu kwaji wu mo wu jɛmɛ wu le lɛ, “Bɛŋ Bafalashii chuge muŋkoo bɛ shú ye le, geenɛ mwɛɛ mù mbefe bɛ kin'yɛlɛ ajii yisɛ lo fɛ muntele mwɛna le. ");
INSERT INTO ncr_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Biyuŋ binɛ! Gɛ Nyo wù gɛ̀ fɛ akfuuŋ, nyu wu wù ka fɛ antɛŋ tɛ gɛ? ");
INSERT INTO ncr_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Fiɛɛ fì bɛŋ bee ki bɛŋ gêe le lɛ, bɛŋ nyâa mwɛɛ mù bɛŋ kɛme a mwɛɛ mwɛɛ le bamii ba kifufe le, mwɛɛ munchii mo mu yuude fɛ bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ŋgɛ wù baaŋ le wene Bafalashii. Bɛŋ nyaa kimbe kimimia Nyo le antɛnɛɛ a bimbe yuufe bi mbaa yì bɛŋ kege mo mwɛɛ mu bɛŋ gɛɛde a mbaa le lɛ yi yege, geenɛ bɛŋ ka chine ki bɛŋ gêe mwɛɛ mù kooji fɛ bamii le, bɛ ki kɛme kiŋkoŋɛ ki Nyo. Bɛŋ be kɛme ki bɛŋ gêe mwɛɛ munɛ munchii bɛŋ chinɛ gɛ fimi le gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ŋgɛ wù baaŋ le wene Bafalashii. Bɛŋ to bɛŋ koŋe ki bɛŋ shîide nyu fwe yéh yi buunɛ le, bɛŋ ka koŋe lɛ ba yɛ̂ɛse bɛŋ le fɛ waaŋ bɛ ŋgvunɛ. ");
INSERT INTO ncr_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ŋgɛ wù baaŋ le wene, nje bɛŋ le gɛh njɛ jɛ́ŋ yi ba yɛne gɛ, bamii jiɛnyi yi le bo kee gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","No Jiso gɛ̀ jɛme nɛ, muh mu wu gɛ̀ kee banchi ba Nyo chuule jɛmɛ wu le lɛ, “Muh wu N'yɛyɛ, wo kee gɛ̀ lɛ mwɛɛ mù wo jɛme le mu kuŋ bee le tɛ!” ");
INSERT INTO ncr_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jiso chvuu lɛ, “Ŋgɛ wù baaŋ le tɛ wene bɛŋ bamii ba kee banchi ba Nyo chuule. Bɛŋ yige bamii bɛ mwɛɛ mujiji mù fede bvuŋga bvuboo njɛ taŋlo bɛŋ la gɛ lo nyi yi kwaaŋ yi kibo ki bɛŋ fîh bo yu sɛŋ. ");
INSERT INTO ncr_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ŋgɛ wù baaŋ le wene. Bɛŋ ba joone jɛ́ŋ yi bamii ba ntuŋ wu Nyo ba bachiji chiji bena gɛ̀ yuuyɛ wa. ");
INSERT INTO ncr_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Finɛ duunyi lɛ bɛŋ toone kiŋge ki bachiji chiji bena. Ba gɛ̀ yuuyɛ bamii ba ntuŋ wu Nyo, bɛŋ mo bɛŋ shɛɛ bɛŋ kɛɛnyi bɛŋ joone jɛ́ŋ yiboo. ");
INSERT INTO ncr_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Le fiɛɛ fì gɛ̀ ge Nyo bɛ bvufee bwe fɛ wu jɛmɛ lɛ, ‘Nlé ŋgê nchîiŋsɛ bamii baŋ ba ntuŋ bɛ booŋ baŋ ba ntuŋ fɛ bo le, bo lé bo yûuyɛ bamu bo boone bikaa a bamu jiŋ.’ ");
INSERT INTO ncr_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Noo, Nyo lé wu gê wu bîih kiŋgogo ki mɛɛse kinɛ le kune kilɛmɛ ki bamii be ba ntuŋ bachii ba bo gɛ̀ yuuyɛ kɛge no woŋ gɛ̀ kɛ. ");
INSERT INTO ncr_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Wu lé wu gê wu bîihde kɛge yi kilɛmɛ ki Abɛ le gɛɛne bude yi ki Sakiya wù ba gɛ̀ yuuyɛ antɛnɛɛ a kitana ki kintanyɛ bɛ yeh yi kintanyɛ le. Nsɛŋe lo bɛŋ nchiɛɛŋ lɛ Nyo lé wu gê wu bîih kiŋgogo ki mɛɛse kinɛ le kune kwe yi bamii bayu bachii. ");
INSERT INTO ncr_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ŋgɛ wù baaŋ le wene bɛŋ bamii ba kee banchi ba Nyo wesee. Bɛŋ le bɛŋ nyilɛ kiŋgwenyɛ ki jwe wu fwese wù taŋlo muh lee yu fɛ wu kɛɛ fiɛɛ fì kooji. Bɛŋ le bɛŋ faŋ ki bɛŋ lêe, bɛŋ tu bɛŋ baŋe bamii ba goone ki bo lee lɛ keefɛ bo lêe gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jiso gɛ̀ ja fo ki wu gɛ̂ɛne, Bafalashii bɛ bamii ba gɛ̀ duunyi banchi ba Nyo bo kɛ bo tu bo leeshi lo wu bɛ jɛ́ bo biide mwɛɛ wu le wesee wesee, ");
INSERT INTO ncr_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","bo gɛ̀ gee noo bo lɛge lo wu ki bo yu fiɛɛ jwe we le, bo mo bo koo wu. ");
INSERT INTO ncr_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","No Jiso gɛ̀ jɛmɛ, binchvu bi bamii mo bi taashi bi too fo banchvuge le banchvuge le bo faase wu. Bamu jiɛnyi bikaa bi bamu. Jiso ja wu kɛ wu tu wu jɛme nyu booŋ be ba ŋgoo le wu duu lɛ, “Bɛŋ jôde kife bɛ kinshilɛ ki Bafalashii ki le gee chiboo chì bo jɛme yeye, bo gee yeye. ");
INSERT INTO ncr_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Bɛŋ kêe lɛ fiɛɛ fì ba nyile fi kɛme ki fi to fi bu fɛ waaŋ. Gɛ fiɛɛ nyu yu tɛ fì ba nyile fì lé fi gê njɛ ba kɛ̂ɛ sɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Bɛŋ kêe lɛ fiɛɛ fichii fì bɛŋ jɛme antaŋ lé ba nyû ba yû fɛnshɛ. Fiɛɛ fichii fì bɛŋ fale yeh bɛŋ chvuune lo lé ba nyû ba tô ba jaŋ lo fɛ kigo ki yeh le. ");
INSERT INTO ncr_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nsáa yaŋ, njɛme bɛŋ le lɛ keefɛ bɛŋ fâane bamii ba taŋlo bo yuuyɛ gɛh nyume nyaŋ yi ye maa, njɛ taŋlo bo ka bo ge fiɛɛ fimi sɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Bɛŋ yêgɛ bɛŋ yû muh wù bɛŋ fâane, bɛŋ fâne nyu Nyo nje le wu wù kɛme bvuŋga ki wu yûuyɛ muh, wu ka wu leesɛ mwɛdɛ yi ŋgu wù baaŋ le. Ŋka njɛme bɛŋ le lɛ bɛŋ fâane gɛh nyu wu maa. ");
INSERT INTO ncr_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Gɛ bɛŋ kee lɛ ba to ba gese munsɛŋ muntɛŋ yi munini le munfɛɛ maa gɛ? Geenɛ, gɛ finsɛŋ fimi nyu yu fimimia fì Nyo to wu daayi a fi le gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Fiena le lɛ Nyo kee yvú yichii yì le a bɛŋ fwa. Keefɛ bɛŋ fâane gɛ. Bɛŋ fede munsɛŋ mù duude. ");
INSERT INTO ncr_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Nsɛŋe tɛ bɛŋ le lɛ, muh bɛmɛ mɛ a bamii fwe lɛ wu kee mɛ, tu muh wù jee che le Mwamuh lé wu gê wu bɛ̂ɛŋ tɛ mwɛdɛ a banchɛndaa ba Nyo fwe lɛ wu kee wu. ");
INSERT INTO ncr_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Geenɛ muh ma lo mɛ a bamii fwe tu mɛ tɛ nlé mmâ mwɛdɛ a banchɛndaa ba Nyo jii. ");
INSERT INTO ncr_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Fi ka nyume lɛ, Nyo lé wu gê wu lɛ̂ɛshɛ jɛ́ yì befe yì muh jɛme kune muh wù jee che le lɛ Mwamuh, geenɛ gɛ Nyo nyu wu yu wu to wu lɛɛshɛ jɛ́ yì befe yì muh jɛme kune Kiyo ki Yuude gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Sege ba koo bɛŋ ba gɛɛŋ bɛ bɛŋ yéh yi buunɛ le, kɛnɛ nyu fwe a bamii ba sage woŋ, kɛnɛ nyu fwe a bamii ba kɛme bvuŋga bvù bo sage tɛ, lɛ bo gɛɛŋ bo sa bɛŋ, keefɛ kikwɛɛ fûuŋse bɛŋ laa bɛŋ le bɛŋ gɛɛŋ bɛŋ taanyi jwe bɛŋ duu lɛ la lɛ, kɛnɛ bɛŋ jɛme nɛɛ lɛ. ");
INSERT INTO ncr_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Lé gê nyume kife kiyu le, Kiyo ki Yuude sɛɛŋ bɛŋ fiɛɛ fì bɛŋ lé bɛŋ jɛ̂mɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","No Jiso gɛ̀ teede booŋ be ba ŋgoo le noo, muh mu ja wu jɛmɛ antɛnɛɛ a kinchvu ki bamii le, wu du wu le lɛ, “Muh wu N'yɛyɛ, du Mwa bwɛɛŋ le lɛ wu ga bvushɛ bwesa wu nya bwaŋ.” ");
INSERT INTO ncr_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jiso biih wu le lɛ, “Jwɛŋsɛ, gɛle yɛɛŋ mɛ lɛ nsûune bansa bena, ŋka ŋgâde bvushɛ bwena?” ");
INSERT INTO ncr_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","No wu biide noo wu mo wu jɛmɛ muh wuchii le lɛ, “Bɛŋ jôde kife bɛŋ yɛ̂ne keefɛ bɛŋ yɛ̂ɛde ajii yi mwɛɛ le gɛ, nje gɛ kinche kimu nyu njɛ mwɛɛ mu wù kɛme gɛ, mo mwɛdɛ tu wù kɛme bvukugɛ nɛɛ la.” ");
INSERT INTO ncr_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","No wu jɛmɛ noo, wu mo wu ma ŋgaŋ lɛ, “Muh wu kwa wumu gɛ̀ kɛme mwɛ we, mwɛɛ joŋ yu baaŋ. ");
INSERT INTO ncr_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Wu mo wu kɛ wu kwaji lɛ laa wu lé wu gê nɛɛ la? Wu lé wu gɛ̂ɛ ŋgu ye yɛɛ faaŋ la? ");
INSERT INTO ncr_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Wu mo wu ja wu chu ntaŋ lɛ, ‘Fiɛɛ fì nlé ŋgê le finɛ. Nlé nsâ basaŋkwa baŋ, ŋkâasɛ njôoŋ ba kuge, mo ŋgɛ̂ɛ ŋgu bɛ mwɛɛ mwaŋ yu munchii. ");
INSERT INTO ncr_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ndoo ŋge noo, mɛ mo ndu kikwɛɛ kaŋ le lɛ nle muh wu kishi. Ŋkɛme mwɛɛ mù nlé ŋgê njîi biluŋ bì duude le. Gɛ mbaaŋ ntu mbuge gɛ. Nlé njîi gɛh wa lo, ŋka mmuu n'yuge njoŋ.’ ");
INSERT INTO ncr_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","No wu seese noo, Nyo mo wu tɛɛŋ wu lɛ, ‘Kiyuŋ kinɛ! Kintaŋ ki abɛŋ le nlé ŋkâasɛ njô kiyo kuŋ. N'yɛŋ laa mwɛɛ munɛ munchii mù wo seese wo gɛɛ lé gê nyû mu yɛɛŋ la?’” ");
INSERT INTO ncr_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","No Jiso jɛme nɛ wu mo wu jɛmɛ lɛ, “Le gɛh yɛɛŋyɛɛŋ no fì lé fi gê fi nyû fɛ muh wu banyi bvukugɛ fɛ kikwɛɛ ke le wù kɛme gɛ bvukugɛ kimbe ki Nyo le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Wu ka wu ja wu jɛme wa nyu booŋ be ba ŋgoo le lɛ, “Keefɛ bɛŋ lûume kune kinche kena lɛ laa bɛŋ lé bɛŋ gê bɛŋ jî la lɛ, kɛnɛ kune ye yene lɛ laa bɛŋ lé bɛŋ jîi la lɛ. ");
INSERT INTO ncr_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Bɛŋ kêe lɛ kiyo ki muh fede mwɛɛ munjile, ye yi muh fede njú. ");
INSERT INTO ncr_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Bɛŋ jîŋɛ bɛŋ yɛŋ biŋaŋa, gɛ bi to bi lɛne gɛ, gɛ bi to bi gweji ŋgu gɛ. Gɛ bi kɛme basaŋkwa kɛnɛ baŋwaŋ gɛ. Geenɛ Nyo nyaŋe gɛh bi bichii. Gɛ bɛŋ kee lɛ bɛŋ yage munyii gɛ? ");
INSERT INTO ncr_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Le yɛɛŋ a bɛŋ ntɛnɛɛ wù fuuŋse, wù taŋlo wu bisɛ gɛh kife shige yi kinche ke le? ");
INSERT INTO ncr_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","No gɛ taŋlo bɛŋ ge mo fì shige finɛ gɛ, gee la fì bɛŋ soge bikwɛɛ kune mwɛɛ munɛ? ");
INSERT INTO ncr_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Bɛŋ jîŋɛ bɛŋ yɛ̂ŋ no nfudɛ to wu kuu wù nyu. Gɛ nfudɛ to wu lɛne gɛ, gɛ wu shiŋe njú gɛ. Geenɛ, nsɛŋe bɛŋ le lɛ gɛh Nfoŋ Salamoŋ bɛ bvukugɛ bwe bvuchii bvù wu gɛ̀ kɛme wu gɛ̀ suse ye wu bu fɛ nfudɛ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","No Nyo suse agaaŋ a nchvuuŋ nɛ, agaaŋ a kuu abɛŋ, bu antaana ba fwɛɛ lo fɛtaŋ, tu gɛ taŋlo wu susɛ bɛŋ wu fe lo noo gɛ? O oo bamii ba mbɛmɛ wù shige lɛ! ");
INSERT INTO ncr_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Fi mo fi nyu lɛ keefɛ fi fûuŋse bɛŋ gɛ, keefɛ bɛŋ kwâji laa bɛŋ lé bɛŋ jî la bɛŋ tu bɛŋ mû la lɛ, ");
INSERT INTO ncr_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","nje munɛ mwɛɛ to kwaji gɛh bamii ba bituŋ bi yi nshɛŋ yinɛ le. Bɛŋ kêe lɛ Chiji wene kee lo lɛ bɛŋ koŋe mwɛɛ munɛ munchii. ");
INSERT INTO ncr_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Bɛŋ gɛ̂ɛ bvufee bwena nyu yi bvunfoŋ bvu Nyo le, wu mo wu nyaa tɛ mwɛɛ munɛ munchii bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ŋgoo yaŋ, no bɛŋ le shige nɛ, keefɛ bɛŋ fâane gɛ, nje Chiji wene le wu koŋ wa ki wu nyâ bvunfoŋ bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Bɛŋ gesɛ mwɛɛ mu bɛŋ kɛmɛ, bɛŋ ga bige biyu bamii ba fuude le, bɛŋ gôone bikɛɛ nyu bì taŋlo bi gɛ suumɛ gɛ. Bɛŋ gɛ̂ɛde kwa wene nyu yi woŋ wù Nyo le, fɛ taŋlo wu gɛ ka gɛ, fɛ choŋ taŋlo wu gɛ fe fo gɛ, fɛ shé taŋlo yi gɛ kaaŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Bɛŋ kêe lɛ fɛ muh gɛɛde nchvu ye fo le fɛ fitele fie le fo. ");
INSERT INTO ncr_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Bɛŋ kaaŋ bicha biɛna, bɛŋ chu bin'yesɛ bɛŋ chîɛɛne lɛme, ");
INSERT INTO ncr_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","gɛh njɛ booŋ ba lɛme to bo chiɛɛne kikwɛɛ kiboo wù nyu kijusɛ ki bvuguu le. Wu doo wu kaasɛ wu to wu kuŋ kimbuŋ ba gwenyɛ lo wu lee. ");
INSERT INTO ncr_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kinlaŋye kì baaŋ le ki nyu fɛ booŋ ba lɛme le sege kikwɛɛ kiboo fɛsɛ wu yɛŋ bo nyu we bo chiɛɛne wu. Nsɛŋe bɛŋ nchiɛɛŋ lɛ wu lé wu gê wu chɛ̂mɛ nju ye wu kaaŋ, bo shiiyɛ fɛkuu wu to bɛ mwɛɛ munjile wu gajɛ bo le. ");
INSERT INTO ncr_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kinlaŋye kì baaŋ le ki nyu ki booŋ ba lɛme ba wu lé wu gê wu fɛ̂sɛ wu yɛ̂ŋ bo nyu bo chiɛɛne wu. Kɛnɛ wu lé wu gê wu tô antaŋ antɛnɛɛ, kɛnɛ sege nyishii to yi toŋe. ");
INSERT INTO ncr_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Bɛŋ kêe lɛ chiji yeh nɛ kee kife ki choŋ le wu to, tu wu lé wu chîɛɛne. Wu gɛ̀ chinɛ lɛ ba ŋgode yeh ye gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Bɛŋ tɛ kɛme ki bɛŋ chîɛɛne, nje muh wù jee che le Mwamuh lé wu gê wu kâasɛ wu to kife kì bɛŋ kee gɛ le.” ");
INSERT INTO ncr_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Bita mo wu ja wu biih wu le lɛ, “Tada, wo ma ŋgaŋ wunɛ nyu bee le, noo bamii bachii le lɛ?” ");
INSERT INTO ncr_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tada chvuu lɛ, “Mwa lɛme wu le wù nchiɛɛŋ wù ka kɛme bvufee le wù la? Gɛ nyume muh wɛɛ wù chiji kikwɛɛ ke le wu gɛɛ wu lɛ wu jîiŋe fɛ yeh ye le, sege kife doo ki kojɛ wu nya mwɛɛ munjile booŋ be ba lɛme le gɛ? ");
INSERT INTO ncr_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kinlaŋye kì baaŋ lé ki gê ki nyûme ki mwa lɛme wù chiji kikwɛɛ ke, sege wu doo wu too wu yɛŋ wù gee lɛme gɛh yɛɛŋyɛɛŋ no wu bee ki wù gee. ");
INSERT INTO ncr_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nsɛŋe bɛŋ nchiɛɛŋ lɛ chiji kikwɛɛ ke lé wu gê wu bɛ̂ɛŋsɛ wu, wu jiiŋe fɛ mwɛɛ mwe le munchii. ");
INSERT INTO ncr_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Geenɛ, nɛ mwa lɛme wɛɛ ja wu jɛmɛ kikwɛɛ ke le lɛ, ‘Gɛ chiji kikwɛɛ kaŋ nyu wu yaŋsɛ wu kaasɛ gɛ’, wu mo wu kɛ wu suŋe booŋ ba lɛme ba bilɛŋsɛ mo ba bikɛse, wu jii wu ka muu mbvuuŋ mo koode wu, ");
INSERT INTO ncr_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","chiji kikwɛɛ ke lé wu gê wu jâ gɛh wu bûnɛ juu chimi chì wu be kwaji gɛ bɛ kife kì wu be kee gɛ le. Wu doo wu ge wu bu noo, wu mo wu gwoojɛ lo mwa ye wu lɛme wɛɛ, wu chiiŋsɛ wu wu gɛɛŋ wù nyu bɛ bamii ba lɛme gɛ jɛ yi boo le gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Mwa lɛme wù kee fiɛɛ fì chiji kikwɛɛ ke goone lɛ wu gêe, wu baaŋ seesɛ gɛ ye ki wu gêe gɛ, tu ba lé ba tâaŋ wu bɛ munte wesee. ");
INSERT INTO ncr_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mwa lɛme wɛɛ wu kee gɛ fiɛɛ fì chiji kikwɛɛ ke goone lɛ wu gêe gɛ, wu fɛ fiɛɛ fì taŋlo ba taaŋ wu bɛ munte wesee, lé ba nyû ba wêjɛ gɛh lo wuwɛɛ shige. Muh wù ba nya mwɛɛ wu le wesee le wu wù ba lé ba gôone mwɛɛ wu le wesee. Muh wù ba le ba gɛɛ mwɛɛ chiaaŋ ye le wesee lé ba nyû ba bîih mwɛɛ wu le wesee.” ");
INSERT INTO ncr_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jiso ka wu jɛmɛ booŋ be ba ŋgoo le lɛ, “Nto ki nfwɛɛ nyu ŋgu yi nshɛŋ le. Muh jo lɛ wu be bɛde wa lo. ");
INSERT INTO ncr_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ŋkɛme kfuu chi ŋgɛ wù baaŋ wumu ki nlee wu le, fitele fiaŋ lé fi jɛ̂de gɛh sege nlé nlêe wa wu le. ");
INSERT INTO ncr_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Bɛŋ kwaji lɛ nto nyu bɛ kimbonɛ yi nshɛŋ le fɛnɛ? Ŋgaŋ! Bɛŋ kêe lɛ nto nyu bɛ kiŋgaye. ");
INSERT INTO ncr_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kɛge yi mɛɛse le gɛɛne fwe, yeh yì le bɛ bamii batɛŋ lé yi gê yi gâ ye. Bamii batɛde lé bo gê bo gâ ye bɛ ba bafɛɛ, ba bafɛɛ ga ye bɛ ba batɛde. ");
INSERT INTO ncr_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Chiji mwa lé wu gê wu gâ ye bɛ mwa ye wù jwɛŋsɛ, mwa wù jwɛŋsɛ juu bɛ chiji. Bwe mwa lé wu gê wu jûu bɛ mwa ye wù kwɛse, mwa wù kwɛse juu bɛ bwee. Bwe jwɛŋsɛ lé wu gê wu jûu bɛ kwɛ mwa ye, kwɛ mwa juu bɛ bwe jwɛɛŋ.” ");
INSERT INTO ncr_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jiso gɛ̀ du kinchvu ki bamii le lɛ, “Bɛŋ to bɛŋ yɛde sege kimbɛ bɛɛne je ajuu seele yo, bɛŋ mo bɛŋ duu lɛ, ‘Jaŋ lé yi gwê.’ Yi ge yi mo yi gwe. ");
INSERT INTO ncr_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Sege bɛŋ yɛde tɛ nfuŋ bɛɛne je akuu akuu, bɛŋ mo bɛŋ tu bɛŋ duu lɛ, ‘Kiyufɛ kì baaŋ lé ki nyû yu.’ Ki mo ki nyûme yu. ");
INSERT INTO ncr_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Bɛŋ bamii ba jɛme yeye, bɛŋ tu bɛŋ gee yeye banɛ, no bɛŋ jiiŋe kibvulɛ bɛ nshɛŋ bɛŋ mo bɛŋ sɛŋe no akfuuŋ le wo nyume, gɛ taŋlo bɛŋ tɛ kɛɛ mwɛɛ mù Nyo duunyi yi kife kinɛ le gɛ nje la? ");
INSERT INTO ncr_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Gɛ taŋlo bɛŋ tɛ kwaji fiɛɛ fì chaaŋ fi taŋlo bɛŋ gêe gɛ? ");
INSERT INTO ncr_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nɛ muh lé wu jô wo wu gɛɛne bɛ wo yeh yi nsa le, wo mo wo moŋ ki wo bɛ̂ɛŋ ki bɛŋ sêesɛ baaŋ a je, keefɛ wo gê wu chîi wo wu gɛ̂ɛŋ wu nyâ wo chiaaŋ yi muh wù sage bansa le gɛ, wu fêese lo wo chiaaŋ yi bamii ba nchi le tu ba lé ba fâa wo yeh yi cha le. ");
INSERT INTO ncr_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nsɛŋe wo le lɛ gɛ taŋlo wo bu yu njɛ wo mɛsɛ wo laŋɛ finini fichii fì ba goone sɛŋ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Gɛ̀ bee kife kiyu le, bamii bamu ja bo sɛɛŋ Jiso kune bamii ba Galalee bamu ba gɛ̀ gɛnɛ ki bo ge kintanyɛ fɛ Nyo le, Balɛt tuŋ bamii bo gɛɛŋ bo gwoojɛ bo, bilɛmɛ biboo taashɛ bɛ bi nyáŋ yì bo gɛ gee kintanyɛ kɛɛ yu. ");
INSERT INTO ncr_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jiso yege nɛɛ, wu biih bo le lɛ, “Bɛŋ kwaji lɛ bamii bayu gɛ kwe kfuu chi yɛɛ kwe noo nje bimbefɛ biboo gɛ̀ fede bi bamii ba Galalee bamu noo? ");
INSERT INTO ncr_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Gɛ nyu noo gɛ. Nsɛŋe bɛŋ le lɛ, bɛŋ baaŋ kûsɛ gɛ muntele mwɛna gɛ, bɛŋ bachii lé bɛŋ kwêeyɛ gɛh noo. ");
INSERT INTO ncr_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Bɛŋ tane gɛh bamii ba yuufe ncho nyaaŋ baa ba yeh yì ndefe gɛ̀ kesɛ Siloŋ yi yuuyɛ bo? Bɛŋ kwaji lɛ bamii bayu gɛ̀ kweeyi noo nje bimbefɛ biboo gɛ̀ fede bi bamii ba Yɛlusalɛm bamu noo? ");
INSERT INTO ncr_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Gɛ nyu noo gɛ. Nsɛŋe bɛŋ le lɛ, bɛŋ baaŋ kûsɛ gɛ muntele mwɛna gɛ, bɛŋ bachii lé bɛŋ gê bɛŋ kwêeyɛ gɛh noo.” ");
INSERT INTO ncr_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jiso mo wu ma ŋgaŋ wumu bo le lɛ, “Gɛ bee kife kimi le, muh mu yii kite ki muntaŋ a wu mwɛne.Lɛ kife kojɛ, wu to ki wu kê, wu gɛ yɛŋ muntaŋ yuŋ yi ki le gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Wu mo wu jɛmɛ muh wù gɛ̀ jiiŋe fɛ mwɛ we le lɛ, ‘Bîjɛ yɛ̂ŋ, le wa biluŋ bitɛde mɛɛse no ntoo ki ŋke muntaŋ yi kite kinɛ le, n'yɛde gɛ fiɛɛ le yi ki le gɛ. Gwôo lo. Ki baŋe nshɛŋ yinɛ achiji.’ ");
INSERT INTO ncr_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Muh we wu lɛme wɛɛ chvuu lɛ, ‘Chiji kikwɛɛ, ka chinɛ gɛh yu kiluŋ kinɛ, nɛ ki baaŋ yuŋ gɛ, mɛ mo nchiŋ kinyi kiyu ŋgɛɛ chvune fo. ");
INSERT INTO ncr_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Sege bu kiluŋ kì too le ki yuŋ, fi joŋ, ki nɛ baaŋ yuŋ gɛ, mɛ mo ŋgwo lo.’” ");
INSERT INTO ncr_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Gɛ̀ bee juu chi yuuŋ chimi, Jiso yɛyi bamii yeh yi buunɛ yimi le. ");
INSERT INTO ncr_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kwɛse wumu nyu yu kiyo kì befe kimi nyu ye ye le, kì to ki ge muh tu muh wu chigoŋ. Ki gɛ ge wa wu chɛŋ yi biluŋ le yuufe ncho nyaaŋ jiŋ ŋgvuusɛ wu, taŋlo wu gɛ ka wu lɛɛŋ we chaaŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jiso yɛŋ kwɛse wuyu le wu tɛɛŋ wu wu to wu jɛmɛ wu le lɛ, “Bwaaŋ, wo le wo bonɛ wa chiaaŋ yi goŋ yo yinɛ le.” ");
INSERT INTO ncr_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","No wu jɛmɛ noo, wu mo wu chiaasɛ kibo wu kuŋ wu le. Kimimia, jiŋ yɛɛ kaasɛ yi nɛjɛ ye, wu lɛɛŋ we chaaŋ, wu mo wu tu wu tume maŋkuŋ ma Nyo. ");
INSERT INTO ncr_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Chiji kikwɛɛ wu yeh yi buunɛ yiyu yɛŋ lɛ Jiso le wu fɛ kwɛse wuyu nyu juu chi yuuŋ, fiɛɛ fiyu toonyɛ lo wu baaŋ. Wu mo wu tu wu sage bamii le wu duu lɛ, “Aju a lɛme le bvusoo. Bɛŋ tôo ba fɛde binchɛŋ biɛna nyu ajuu kaa le. Keefɛ muh ka wu môŋ wu to juu chi yuuŋ lɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tada chvuu wu le lɛ, “Bɛŋ bamii ba jɛme yeye, bɛŋ gee yeye banɛ. Nɛ le juu chi yuuŋ, muh wu mumwaa mumwaa abɛŋ ntɛnɛɛ gɛ ka wu jo kɛnɛ jaki fɛ wu chee fo wu gɛɛŋ wu nya wu joo gɛ? ");
INSERT INTO ncr_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kwɛse wunɛ le nyu mwa Ablaham, debele nyu wu lee wa wu yeh yi ncha le biluŋ yuufe ncho nyaaŋ, fi baaŋ joŋ gɛ no ba bvusɛ wu yi ŋgɛ le juu chi yuuŋ gɛ?” ");
INSERT INTO ncr_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","No Jiso jɛmɛ noo, bvuya koo bamii be ba kimbanɛ, bamii ba duude tu bo laŋe lo ye fiboo nje biŋgha bi mwɛɛ bichii bì Jiso gɛ̀ gee. ");
INSERT INTO ncr_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jiso ja wu ghaa lɛ “Bvunfoŋ bvu Nyo le njɛ la? Fiɛɛ fì taŋlo mbege yu le la? ");
INSERT INTO ncr_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ka nyu gɛh njɛ ŋgo yi fintaŋ fimi fì muh gɛ̀ noŋ a wu mwɛne, yi gɛ̀ bu, yi ku yi yɛɛŋ yi tu kite kì munyii mu fuune we to mu joone yi chɛ́ yiyu le.” ");
INSERT INTO ncr_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Wu ka wu jɛmɛ lɛ, “Taŋlo ŋka mbege bvunfoŋ bvu Nyo bɛ la? ");
INSERT INTO ncr_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ka nyu gɛh njɛ kinshilɛ kì kwɛse gɛ̀ fe mune bintee bì baaŋ baaŋ bitɛde wu jo wu fiiŋsɛ yu, wu tojɛ wu gɛɛ, fi mo fi ge mune chiyu bɛɛnyɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jiso gɛ ja wu gɛɛne Yɛlusalɛm. No wu gɛ gɛɛne wu fede bilaantɛŋ bɛ bantɛ le wu yɛyi bamii. ");
INSERT INTO ncr_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Muh mu ja wu biih wu le lɛ, “Tada, le bamii ba shige bo lé bo gê bo bônɛ?” Jiso mo wu chvuu wa nyu bamii le bachii lɛ, ");
INSERT INTO ncr_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Bɛŋ lûumɛ chuule ki bɛŋ lêe nyu fɛ jwe wu fwese kwɛɛ wu le fasaa le. Nje nsɛŋe bɛŋ le lɛ bamii ba duude lé bo gê bo gôone ki bo lee bo gɛ kɛmɛ je gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kife lé ki kôjɛ, kì chiji yeh lé wu jâ we wu faa kimbuŋ. Wu doo wu faa, bɛŋ mɛ akfuuŋ bɛŋ kune kimbuŋ bɛŋ lɛge lɛ, ‘Chiji Kikwɛɛ, gwenyɛ kimbuŋ be lee.’ Wu mo wu chvuu bɛŋ le lɛ, ‘Gɛ ŋkee a bɛŋ ja yo gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Bɛŋ mo bɛŋ kɛ bɛŋ taanyi lɛ, ‘Le bee ba chi jii mwɛɛ bee ka muu mwɛɛ. Wo gɛ jiɛnyi wo yɛyi bamii bantɛ besa le.’ ");
INSERT INTO ncr_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Wu ka wu kaasɛ wu chvuu lɛ, ‘Nsɛŋe lo bɛŋ le lɛ gɛ ŋkee a bɛŋ ja yo gɛ. Bɛŋ ja lo a mɛ fwɛɛŋ bɛŋ banɛ bɛŋ jiɛnyi bɛŋ fige mwɛɛ.’ ");
INSERT INTO ncr_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Bɛŋ lé bɛŋ gê bɛŋ yɛ̂ŋ Ablaham bɛ Asik mo Yakob mo bamii ba ntuŋ wu Nyo bachii antɛnɛɛ a bvunfoŋ bvu Nyo, bɛŋ nyu ba baŋ bɛŋ akfuuŋ, bɛŋ mo bɛŋ beede bɛŋ ŋgeji bige. ");
INSERT INTO ncr_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bamii lé bo jâ bimbe le bichii, kɛge a juu saane yo gɛɛne bude a chi seele yo mo aweawe bɛ akuuakuu a woŋ, bo to bo shii bo jii antɛnɛɛ a bvunfoŋ bvu Nyo. ");
INSERT INTO ncr_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Bɛŋ kêe lɛ bamii bamu ba le ajiŋ mɛɛse lé bo gê bo nyû fwe, bamu ba le fwe mɛɛse lé bo gê bo nyû ajiŋ.” ");
INSERT INTO ncr_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Lɛ nyu gɛh kife kiyu le, Bafalashii jɛmɛ Jiso le lɛ, “Bu fiuŋ wo ja wo gɛɛne kimbe kimi le nje Nfoŋ Hɛlod goone ki wu yû wo.” ");
INSERT INTO ncr_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jiso chvuu bo le lɛ, “Bɛŋ gɛ̂ɛŋ bɛŋ du nchombiaŋ wuyu le lɛ mbvuuse banchɛndaa ba debele ye yi bamii le abɛŋ, ŋka nfɛde binchɛŋ, nyu gɛh no nlé mbû ŋge fɛwɛge, doo nyume fɛ bu shɛ ataana, mɛ mo mmɛsɛ lɛme chaŋ. ");
INSERT INTO ncr_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Geenɛ, nle ŋkɛ jiɛnyɛ waŋ wu Yɛlusalɛm abɛŋ, ŋka mbu njiɛnyɛ fɛwɛge gɛɛne bude fɛ bu she fɛwɛge. Fi baaŋ kojɛ gɛ lɛ ba yuuyɛ muh wu ntuŋ wu Nyo kijusɛ kimi le fede Yɛlusalɛm gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","No Jiso jɛmɛ nɛ, wu mo wu kɛŋ ye lɛ, “Yɛɛbɛɛ Yɛlusalɛm! Yɛɛbɛɛ Yɛlusalɛm! Wo wù yuuyi bamii ba ntuŋ ba Nyo, wo ka tume bamii ba Nyo tuŋ fɛ wo le bɛ ata. Le wa kiŋgane kimɛɛ no mɛ moŋ ki mbanyɛ booŋ buŋ njɛ no bweshii to wu banyɛ booŋ be yi kfugɛ, a bibɛɛ bie le, wo faŋ? ");
INSERT INTO ncr_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Bîjɛ yɛ̂ŋ, yeh yo lé yi gê yi tu binfu. Nsɛŋe bɛŋ le lɛ gɛ bɛŋ baaŋ bɛŋ ka bɛŋ yɛŋ mɛne gɛ, gɛɛne bude kife ki bɛŋ lé bɛŋ dû lɛ, ‘Nyo le wu noŋ kimbonɛ yi muh wu too a jee chi Tada Nyo le.’” ");
INSERT INTO ncr_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Gɛ bee juu chi yuuŋ chimi, Jiso gɛɛŋ ki wu jî mwɛɛ a muh wù baaŋ wumu yeh. Muh wɛɛ gɛ̀ bee muh wu Bafalashii. Bamii ba gɛ̀ bee fo tu bo weede Jiso ki bo yɛŋ fiɛɛ fì wu lé wu gê. ");
INSERT INTO ncr_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Gɛ bee muh mu lɛme fo a Jiso jii wu chɛne bɛ chi goŋ chi ge wa chiaaŋ bɛ bikaa muji. ");
INSERT INTO ncr_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jiso biih Bafalashii bɛ bamii ba gɛ̀ kee banchi ba Nyo ba gɛ̀ bee fo le lɛ, “Nchi wese le wu bɛɛŋ lɛ taŋlo ba fɛ muh juu chi yuuŋ noo wu baaŋ bɛɛŋ gɛ le?” ");
INSERT INTO ncr_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Bo gɛ chvuu fiɛɛ gɛ. Jiso jijɛ muh wɛɛ le, wu fɛ wu wu tɛmɛ, wu mo wu jɛmɛ lɛ wu gɛ̂ɛne. ");
INSERT INTO ncr_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jiso biih bo le lɛ, “Le yɛɛŋ a bɛŋ ntɛnɛɛ wù kɛme mwakɛnɛ naa wu gwe a fwɛŋ le juu chi yuuŋ mwɛdɛ gɛ bvusɛ lo kimimia gɛ?” ");
INSERT INTO ncr_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Bo ma fiɛɛ fì bo chvuu. ");
INSERT INTO ncr_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jiso gɛ̀ bijɛ wu yɛŋ no bamii too bo chage gɛh nyu manjuu ma fwe fɛ bo shiide fo, wu ma ŋgaŋ bo le lɛ, ");
INSERT INTO ncr_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Sege muh ka bvuguu, ba tɛɛŋ wo fo wo gɛɛŋ, keefɛ wo shîi nyu fɛ kijusɛ kì fwe le gɛ, nje taŋlo nyu ba sɛɛŋ tɛ muh mu wù baaŋ wù fede wo le. ");
INSERT INTO ncr_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Chiji bvuguu wù chi tɛŋe bɛŋ bachii nɛ lé wu jâ wu tô wu mo wu dû wo le lɛ, ‘Jâ we wo nyâ kijusɛ kuŋ muh wù baaŋ wunɛ le.’ Wo mo wo ja bɛ bvuya wo gɛɛŋ wo shii nyu wa ajiŋ. ");
INSERT INTO ncr_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Sege ba sɛɛŋ wo ŋka wu bvuguu, wo gɛɛŋ fo, wo shii nyu ajiŋ, wu lɛ chiji bvuguu lé wu jâ wu tô wu dû lo wo le lɛ, ‘Nsaa yaŋ, ja we fɛnɛ wo gɛɛŋ wo shii nyu fwe.’ Noo, wo mo wo kɛme mbɛɛŋsɛ fwe a bamii bachii ba le fo. ");
INSERT INTO ncr_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Le gɛh yɛɛŋyɛɛŋ no muh wuchii wu bɛɛŋse kikwɛɛ ke lé ba nyû ba gê ba shîishɛ lo wu. Muh wu shiishi kikwɛɛ ke ba lé ba bɛ̂ɛŋsɛ lo wu.” ");
INSERT INTO ncr_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jiso mo wu ja wu kaasɛ wu jɛme chiji yeh wu gɛ tɛŋe wu a wu yeh le lɛ, “Sege wo goone ki wo tɛ̂ɛŋ bamii lɛ bo to bo ji mwɛɛ, keefɛ wo tɛ̂ɛŋ nyume nsáa yo kɛnɛ booŋ ba bwoo kɛnɛ kfuu chuŋ gɛ, mo nyu bamii ba kwa bo le ntɛ wo le gɛ. Wo nɛ tɛŋe nyu bobaa bamii, tu bo lé bo gê bo kâasɛ bo tɛɛŋ tɛ wo a bo yeh, fi mo fi nyume lɛ bo le bo chvuu wa kibo kuŋ. ");
INSERT INTO ncr_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Sege wo gee ŋka, wo tɛɛŋ nyu bamii ba kifufe, biŋkelɛ bɛ ba tɛŋlaase mo binfeeŋ. ");
INSERT INTO ncr_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Wo ge noo, wo mo wo kɛmɛ kimbonɛ, nje gɛ bo baa bamii kɛme fiɛɛ fì taŋlo bo kaasɛ bo chvuu wo le gɛ. Le gɛh Nyo wu lé wu lâŋɛ wo juu chi bamii ba chaaŋ lé bo gê bo bûde yi kwe le.” ");
INSERT INTO ncr_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","No Jiso jɛme noo, muh mu wu bɛ bo gɛ jii mwɛɛ mo wu jɛmɛ wu le lɛ, “Kinlaŋye kì baaŋ le ki muh wù lé wu gê wu jîi mwɛɛ antɛnɛɛ a bvunfoŋ bvu Nyo.” ");
INSERT INTO ncr_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jiso mo wu chvuu wu le lɛ, “Gɛ bee kife kimi le, muh mu seesɛ ŋka wù baaŋ, wu tɛɛŋ bamii ba duude. ");
INSERT INTO ncr_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Juu gɛ̀ to chi kojɛ, wu tuŋ mwa ye wu lɛme lɛ wu jiɛnyɛ wu sɛɛŋ bamii le bachii ba gɛ̀ bee ki bo to le, lɛ mwɛɛ munchii le ba seesɛ wa. ");
INSERT INTO ncr_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Mwa ye wu lɛme wɛɛ mo wu gɛɛŋ wu yɛŋ bo le, bo kɛ bo beeyi ye wu mumwaa wu mumwaa, muh wù fwe gɛ̀ ja wu jɛmɛ wu le lɛ, ‘Nchi ŋgu mwɛ waŋ wù fwɛŋ, ŋkɛme ki ŋgɛɛŋ njiŋɛ. Kii wo, keefɛ bɛŋ chîɛɛne mɛ gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wu ka wu yɛŋ muh mu le, mwɛdɛ jɛmɛ lɛ, ‘Nchi ŋgu banaa baŋ ba lɛme yuufe, ŋgɛɛne mɛɛse ki mɛ mmoŋ bo. Kii wo, keefɛ bɛŋ chîɛɛne mɛ gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wu yɛŋ muh mu le, wu jɛmɛ fie lɛ, ‘Nchi njo kwɛse, gɛ kife nyume yu kì taŋlo nto gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Lɛ bo chvuu noo, mwa muh wu lɛme wɛɛ mo wu tu jiŋ wu gɛɛŋ wu sɛɛŋ fiɛɛ fichii chiji kikwɛɛ ke le. Chiji ŋka wɛɛ yu, fitele lujɛ lo wu. Wu mo wu kaasɛ wu tuŋ mwa ye wu lɛme wɛɛ wu jɛmɛ lɛ, ‘Bû chige, wo gɛ̂ɛŋ alaantɛŋ wo jîɛnyɛ ntasɛ yi jé le bɛ bifiaŋ bi jé le bichii, wo kûŋ bamii ba kifufe, batɛŋlaase, bɛ binfeeŋ mo biŋkɛlɛ, lɛ bo to.’ ");
INSERT INTO ncr_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Wu gɛɛŋ wu kaasɛ wu to wu jɛmɛ lɛ, ‘Chiji kikwɛɛ, nle ŋge wa no wo be jɛmɛ, geenɛ, yeh baaŋ yisɛ gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Chiji wɛɛ jɛmɛ wu le lɛ, ‘Bu mɛɛse wo gɛɛŋ wo jiɛnyi a jé le bɛ bifiaŋ bi jé le bichii, wo kuŋ lo bamii bo to, yeh yaŋ yisɛ. ");
INSERT INTO ncr_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kɛɛ lɛ gɛ muh wu mumwaa antɛnɛɛ a bamii banɛ ba nchi n'ya mbe bo, nyu bo ge bo moŋ lo fiɛɛ fiaŋ fijile a bo mu gɛ.’” ");
INSERT INTO ncr_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jiso ka wu ja wu gɛɛne, binchvu bi bamii bì duude bii wu le. Wu ja wu kaasɛ ye wu jɛmɛ bo le lɛ, ");
INSERT INTO ncr_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Gɛ taŋlo muh nyu muh waŋ wu ŋgoo njɛ wu koŋe mɛ wù yage bwee bɛ chiji sɛŋ gɛ, wu ka koŋe mɛ wù fede kwɛɛ bɛ booŋ be mo booŋ ba bwee mo jɛ́me ye gɛ. Wu kɛmɛ tɛ ki wu kôŋe mɛ wù fede no wu koŋe kikwɛɛ ke. ");
INSERT INTO ncr_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Gɛ taŋlo muh tɛ nyu muh waŋ wu ŋgoo njɛ wu le wu tuu ke kintaaŋ wu bii mɛne sɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Le yɛɛŋ a bɛŋ ntɛnɛɛ wu goone ki wu jôoŋ yeh yì ndefe fɛwe, wu gɛ ya wu shii fɛkuu wu kwajɛ laa wù kɛme gɛ bige bi kooji bì taŋlo wu jooŋ yeh yinɛ yu wu mɛsɛ la? ");
INSERT INTO ncr_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Wu nɛ baaŋ noo ge gɛ tu wu lé wu gê wu jâ wu gɛ̂ɛ kinfu ki yeh, yeh ya wu ki wu mɛ̂sɛ. Sege bamii fede bo mo bo buu wu bo duu lɛ, ");
INSERT INTO ncr_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Mbwɛ wunɛ chi wu kɛ yeh yi ya wu ki wu mɛ̂sɛ.’ ");
INSERT INTO ncr_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Gɛh yɛɛŋyɛɛŋ tɛ, le nfoŋ wu la wu goone ki wu tûŋ jɛŋ bɛ nfoŋ wumu wu gɛ ya wu shii fɛkuu bɛ bamii be wu kwajɛ laa taŋlo wu bɛ bamii be ba jɛŋ ba banchvuge yuufe tuŋ jɛŋ bɛ nfoŋ wumu wu le bɛ bamii be ba jɛŋ banchvuge mbanfiɛɛ gɛ? ");
INSERT INTO ncr_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Wu nɛ le wu kwajɛ wu yɛŋ lɛ fi lé fi gê fi ghâ wu, wu mo wu tuŋ bamii be bamu bo gɛɛŋ bo yɛŋ nfoŋ wumu wɛɛ le wu baaŋ je yì ndefe le bo lɛgɛ wu lɛ nyiɛgee nyu a bo ntɛnɛɛ. ");
INSERT INTO ncr_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Fi mo fi nyu lɛ, muh wù baaŋ chinɛ gɛ mwɛɛ mwe le munchii gɛ, wu gɛ nyu muh waŋ wu ŋgoo gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ŋka le fiɛɛ fì joŋe. Geenɛ, sege yi chii, wo ge nɛɛ bɛ yi fɛ yi ka yi kaasɛ yi jɛŋɛ? ");
INSERT INTO ncr_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tu yi le yi lɛsɛ wa achiji. Gɛ yi baaŋ no ba noŋ mwɛne njɛ chvune gɛ. Yi le wa gɛh lɛ ba noŋ lo. Muh wù kɛme bintuŋ ki wu yû, wu yu.” ");
INSERT INTO ncr_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bamii ba gɛ̀ koode ŋwa mo bamii ba befe bamu gɛ̀ too fɛ Jiso le ki bo yegɛ fiɛɛ fì wu gɛ̀ yɛyi. ");
INSERT INTO ncr_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Bafalashii bɛ bamii ba gɛ̀ duunyi banchi ba Nyo kɛ bo tu bo shuŋshi, bo duu lɛ, “Muh wunɛ fii bamii ba befe wu ka jii mwɛɛ bɛ bo.” ");
INSERT INTO ncr_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Noo, Jiso mo wu ma ŋgaŋ wunɛ bo le lɛ, ");
INSERT INTO ncr_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Le muh wù la wu kɛmɛ shóŋ gwee, wu nɛ le wu lɛsɛ yimimia. Wu gɛ chinɛ yi baŋbvuugɛ ncho bvuugɛ le nchvuuŋ wu gɛɛŋ wu gooŋ yimimia yɛɛ yi lɛse, gɛɛne bude sege wu yɛŋ yi le sɛŋ? ");
INSERT INTO ncr_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nɛ wu le wu gooŋ wu yɛŋ, wu yu njoŋ, wu tuu yi fɛgbwe, ");
INSERT INTO ncr_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","wu kwɛɛde bɛ yi fɛ yeh le. Wu doo wu kwɛɛ bɛ yi, wu mo wu tɛɛŋ nsáa ye bɛ bamii ba chee mbebe ye le wu du lɛ, ‘Bɛŋ tô bee laŋye nje shoŋ yaŋ yì be lɛsɛ, ŋkaasɛ n'yɛŋ yi le.’ ");
INSERT INTO ncr_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Gɛh noo nsɛŋe bɛŋ le lɛ le gɛh yɛɛŋyɛɛŋ no kinlaŋye kì baaŋ lé ki nyû woŋ wù fɛwe le, nje muh wu kimbefɛ wu mumwaa wu le wu kusɛ fitele fie. Bo lé bo lâŋeye fɛ wuwɛɛ muh le fede bamii ba mbaŋbvuugɛ ncho bvuugɛ ba le chaaŋ ba baaŋ gɛ bo goone ŋkusɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Noo, laa le kwɛse wu la wù kɛmɛ bige yuufe, jise nɛ le chi lɛsɛ fo wu tu wu laame? Wu gɛ chu kin'yesɛ wu yɛsɛ, wu yɛɛsɛ yeh, wu gooŋ chuule gɛɛŋ bu sege wu yɛŋ gɛ? ");
INSERT INTO ncr_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Wu nɛ le wu gooŋ wu yɛŋ, wu mo wu banyɛ nsáa ye bɛ bamii ba chee mbebe ye le wu du lɛ, ‘Bɛŋ tô be laŋye, jise chaŋ chi bige, chi be lɛsɛ, ŋka ŋkaasɛ n'yɛŋ chi le.’ ");
INSERT INTO ncr_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nsɛŋe bɛŋ le lɛ, le gɛh yɛɛŋyɛɛŋ no banchɛndaa ba Nyo lé bo laŋeye nje muh wu kimbefɛ wu mumwaa wu le wu kusɛ fitele fie.” ");
INSERT INTO ncr_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jiso ka wu jɛme lɛ, “Muh mu gɛ̀ kɛmɛ booŋ ba bilɛŋsɛ bafɛɛ. ");
INSERT INTO ncr_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Wù ajiŋ mo wu ja wu jɛmɛ wu le lɛ, ‘Chii, gaa bwaŋ bvushɛ wo nya mɛne mɛɛse.’ Noo, chiji mo wu ga bvushɛ bwɛɛ bo le. ");
INSERT INTO ncr_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mwa wù ajiŋ wɛɛ fi bwe bvushɛ, lɛ doo nyu ajiŋ a aju shige, wu baanyɛ bwe bvushɛ wu gesɛ wu mo wu la bala woŋ wumu wù je yì ndefe le, wu mo wu gɛɛŋ wu tu wu jii kiŋgaŋ wu chɛŋe bɛ bige biyu yi kinche ki achiji le. ");
INSERT INTO ncr_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Wu gɛ̀ doo wu buŋ bi ka, jɛŋ yi tɛɛme ja yi koo woŋ kwɛɛ le, wu tu wu fuge fiɛɛ fijile. ");
INSERT INTO ncr_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Noo, wu mo wu gɛɛŋ wu gooŋ lɛme muh mu wu woŋ kwɛɛ le. Muh wɛɛ mo wu tuŋ wu wu gɛɛŋ wu chiɛɛne munyuŋa mwe. ");
INSERT INTO ncr_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Wu mo wu ja wu koŋe ki wu jîi mwɛɛ munjile mu munyuŋa to mu jii. Geenɛ muh gɛ nyaa gɛ wu bɛ fiɛɛ fì wu ji gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Wu mo wu kɛ wu tu wu kwaji mwɛɛ, lɛ wu doo wu tɛɛŋ bvufee bwe jiŋ, wu mo wu du lɛ, ‘Bamii ba lɛne chii le bo kɛmɛ mwɛɛ munjile wesee mu yage bo, nɛ mɛ fɛnɛ ŋkwee bɛ jɛŋ. ");
INSERT INTO ncr_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nlé njâ we, ŋgɛ̂ɛŋ fɛ chii le, ndu wu le lɛ, “Chii, nle ŋge kimbefɛ fɛ Nyo le mo fɛ wo le. ");
INSERT INTO ncr_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Gɛ mbaaŋ ŋka ŋkooji lɛ ba ka ba tɛŋe mɛ lɛ mwa yo gɛ. Jôo gɛh lo mɛ mɛɛse njɛ muh wo wu lɛme.”’ ");
INSERT INTO ncr_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Noo, wu mo wu ja wu tuu jiŋ fɛ chiji le. Wu doo wu too wu bude wa mbebe la le, chiji noŋ ajii wu yɛŋ wu le. Wu koo yii bɛ mwa ye, wu ja we, wu legɛ wu gɛɛŋ, wu kfugɛ wu, wu mo wu shiŋɛ wu. ");
INSERT INTO ncr_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mwa wɛɛ mo wu jɛmɛ wu le lɛ, ‘Chii, nle ŋge kimbefɛ fɛ Nyo wu fɛwe le mo fɛ wo le. Mbaaŋ gɛ ŋka ŋkooji lɛ ba ka ba tɛŋe mɛ lɛ mwa yo gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Geenɛ, chiji ka wu tɛɛŋ lo bamii be ba lɛme wu jɛmɛ lɛ, ‘Bɛŋ gɛ̂ɛŋ chige, bɛŋ gooŋ kikuŋ kì joŋe chuule bɛŋ to bɛŋ noŋ wu ye le bɛŋ ka bɛŋ leesɛ wu fincha kwaaŋ le mo jé bikaa bie le. ");
INSERT INTO ncr_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bɛŋ gɛ̂ɛŋ bɛŋ kòo kijunɛ ki naa wù faŋ bɛŋ sɛ̂ɛ besabɛŋ jîi be lâŋeye, ");
INSERT INTO ncr_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","nje mwa yaŋ wunɛ chi bee wu kwe wa wu kaasɛ wu tu yu. Wu chi bee wu lɛsɛ wa, wu kaasɛ wu yɛnɛ.’ Noo, bo mo bo kɛ bo laŋeye. ");
INSERT INTO ncr_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Fiɛɛ finɛ gɛ̀ kooshi noo, mwa wu ŋgamu gɛ̀ bee nchvuuŋ. Lɛ wu doo wu kwɛɛde, lɛ wu to wu bu mbebe la le, wu yu no ba kude bine ba bine. ");
INSERT INTO ncr_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Wu tɛɛŋ muh wu lɛme wumu wu biih laa ba bine nyu la lɛ. ");
INSERT INTO ncr_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Wu chvuu wu le lɛ, ‘Mwa bwoo le wu tu jiŋ abɛŋ. Noo, chiji wene sɛɛ kijunɛ ki naa wù faŋ, nje wu bee wu yɛŋ mwa bwoo le wù nyu yu, wu tɛɛme.’ ");
INSERT INTO ncr_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Wu yu noo shɛ́ŋ ka yi toonyɛ lo wu, wu mo wu faŋ ki wu lêe yeh. Chiji bu wu gɛɛŋ wu tu wu chooŋe wu lɛ wu lee ye. ");
INSERT INTO ncr_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Geenɛ, wu tu wu chvuu chiji le lɛ, ‘Bîjɛ yɛ̂ŋ, nchi nlɛne wo le njɛ nfwa yi biluŋ binɛ le bichii, ŋgɛ mbaaŋ a nfaŋ gɛ ki ŋge fiɛɛ fiuŋ fimi gɛ. Wo gɛ mbaaŋ a nya gɛ mɛ mo bu mwa bi lɛ nlaŋye yu besa nsáa yaŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mwa yo wunɛ wù chi gɛnɛ wu buŋ bvushɛ bɛ bikɛse ba le binjikuu, doo wu to, wo mo wo koo lo kijunɛ ki naa wù faŋ wo sɛɛ nje wu.’ ");
INSERT INTO ncr_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Chiji chvuu wu le lɛ, ‘Mwa yaŋ, besa wo le gɛh fɛnɛ segechii, fiɛɛ fichii fì ŋkɛmɛ le gɛ fiuŋ. ");
INSERT INTO ncr_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Geenɛ, fi bee joŋe lɛ bee laŋeye nje mwa bwoo wunɛ chi bee wu kwe wa, wu kaasɛ wu tu yu, wu chi bee wu lɛsɛ wa, wu kaasɛ wu yɛnɛ.’ ” ");
INSERT INTO ncr_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jiso ka wu jɛmɛ booŋ be ba ŋgoo le lɛ, “Muh wu kwa wumu gɛ̀ kɛme mwa ye wu lɛme wù wu gɛ̀ gɛlɛ lɛ wu jîiŋe fɛ kwa we le. Wu ja wu yu lɛ mwa ye wu lɛme wɛɛ bunɛ lo bige bie. ");
INSERT INTO ncr_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Wu mo wu tɛɛŋ mwa ye wu lɛme wɛɛ wu biih wu le lɛ, ‘Finɛ fi n'yuge kune wo le la? Bânyɛ baŋwa bachii ba wo chi saŋe kwa waŋ yo wo tô wo chvûu mɛne. Gɛ wo baaŋ wo ka wo lɛne mɛne gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Mwa ye wu lɛme wɛɛ gɛɛŋ wu shii wu kwajɛ lɛ, ‘No chiji kikwɛɛ kaŋ kuŋe wa bɛ mɛ fɛ lɛme le, nlé ŋgê nɛɛ? No nle njɛ ŋkɛme bvuŋga bvu nlɛne bɛ ji sɛŋ, ŋkɛme bvuya ki nlɛge kilɛgɛ.’ ");
INSERT INTO ncr_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Wu mo wu ja wu kwajɛ lɛ, ‘Nle ŋkɛɛ wa fiɛɛ fì nlé ŋgê, fi le lɛ sege ba kuŋ bɛ mɛ fɛ lɛme le, ŋka ŋkɛme nsáŋ yì taŋlo yi fii mɛ yéh yiboo le.’ ");
INSERT INTO ncr_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Noo, wu mo wu tɛɛŋ bamii ba gɛ̀ kɛme fioo yi chiji kikwɛɛ ke wu mumwaa wu mumwaa. Wu fwe to wu biih wu le lɛ, ‘Wo laaŋe chiji kikwɛɛ kaŋ nɛɛ?’ ");
INSERT INTO ncr_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Wu chvuu lɛ, ‘Le muŋkaaŋ mu mɛɛ mù baaŋ baaŋ gwii.’ Wu jɛmɛ lɛ, ‘Kô ŋwa wo wu fioo wunɛ wo shîi fɛkuu chige, wo kûsɛ wo sâŋ lɛ le muŋkaaŋ mbaanshɛŋ.’ ");
INSERT INTO ncr_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Wu kaasɛ wu biih muh mu le lɛ, ‘Wo laaŋe yo, nɛɛ?’ Wu chvuu lɛ, ‘Le bikɛɛ bi agiŋ gwii.’ Wu jɛmɛ lɛ, ‘Kô ŋwa wo wu fioo wunɛ wo kûsɛ wo sâŋ lɛ le bikɛɛ mbanyaaŋ.’ ");
INSERT INTO ncr_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Chiji kikwɛɛ wù mwa lɛme wɛɛ gɛ̀ yɛŋ no wu gɛ̀ fige wu noo, wu ka wu bɛɛŋsɛ lo wu lɛ wu le wu feefɛ baaŋ.” Jiso mo wu mɛsɛ lɛ, “Bamii ba kiŋkfuuŋ kinɛ le feefe yi mwɛɛ mu bo gee le fede no bamii ba n'yuu feefe yi muboo mu le n'yuu le. ");
INSERT INTO ncr_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Noo, njɛme bɛŋ le lɛ, bɛŋ jôde kwa wene wu fɛkuu fɛnɛ bɛŋ koode nsáŋ yu, fi le lɛ, sege wu ka, Nyo fi bɛŋ a wu yeh fɛ bɛŋ lé bɛŋ gê bɛŋ nyûme fo segechii. ");
INSERT INTO ncr_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Muh wù taŋlo wu kɛɛ ki wu bîjɛ fɛ fiɛɛ fì shige le chuule taŋlo wu kɛɛ ki wu bîjɛ tɛ fɛ fì kuge le. Muh wù fɛde kinfi yi fiɛɛ fì shige le, tu taŋlo wu fige tɛ yi fì kuge le. ");
INSERT INTO ncr_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nɛ bɛŋ le njɛ bɛŋ taŋlo bɛŋ kɛɛ ki bɛŋ bîjɛ fɛ bvukugɛ bvu fɛkuu fɛnɛ le sɛŋ, lé nya yɛɛŋ bɛŋ kwa wù nchiɛɛŋ? ");
INSERT INTO ncr_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Bɛŋ le njɛ bɛŋ taŋlo bɛŋ kɛɛ ki bɛŋ bîji fɛ fiɛɛ fì muh mu le chuule sɛŋ, ge nya yɛɛŋ bɛŋ fiena? ");
INSERT INTO ncr_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Gɛ nfwa taŋlo wu lɛ̂ne bachiji kikwɛɛ le bafɛɛ gɛ. Wu nɛ lɛne noo, wu bâne wumu, wu koŋe wumu, kɛnɛ wu yuge wumu le chuule wu jode wumu fɛkuu. Gɛ taŋlo bɛŋ lɛ̂ne Nyo le bɛŋ ka lɛne bige le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","No Jiso jɛme noo, Bafalashii yu mwɛɛ munchii bo ja bo tu bo buu lo wu, nje bo gɛ̀ koŋe bige baaŋ. ");
INSERT INTO ncr_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jiso mo wu jɛmɛ bo le lɛ, “Le bɛŋ banɛ ba duunyi ye lɛ bɛŋ lé bamii ba joŋe a bamii fwe, geenɛ Nyo kee mwɛɛ munchii mu le muntele mwɛna le. Bɛŋ kêe lɛ mwɛɛ mù bamii bɛɛŋse, le mwɛɛ mù Nyo jiiŋe mu kuufe ye fɛ wu le.” ");
INSERT INTO ncr_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jiso ka wu jɛmɛ lɛ, “Gɛ̀ bee fweele ba feeji nyu banchi ba Musɛ bɛ mwɛɛ mu bamii ba ntuŋ ba Nyo gɛ̀ saŋ. Geenɛ, kɛge no Joŋ gɛ̀ to, bo tu bo feeji wa nyu saaka wù joŋe wù kune bvunfoŋ bvu Nyo. Muh wuchii mo wu tu wu taŋe ki wu lêe antɛnɛɛ a bvunfoŋ bvu Nyo bvuyu le. ");
INSERT INTO ncr_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Fi le chige fɛ kibvulɛ bɛ nshɛŋ ka, fede fɛ jise chi ŋwa lɛsɛ achiji a ŋwa wu banchi le. ");
INSERT INTO ncr_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Fi nyume lɛ, muh kuŋe bɛ kwɛɛ, wu jo wumu, tu wu le wu ge kimbefɛ bvushi bvu Nyo le njɛ kinjaŋ. Muh jo kwɛse wu bu wa a muh yeh, tu mwɛdɛ le wu jo kwɛ muh.” ");
INSERT INTO ncr_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jiso ka wu ja wu jɛmɛ lɛ, “Muh kwa wumu gɛ̀ bee yu, wu susɛ ye bɛ njú yì joŋe yi kwa, wu jii ki kfuuŋ ke aju achii. ");
INSERT INTO ncr_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Muh kifufe wumu nyu tɛ yu, jee che nyu Lasulo. Biŋkogo gɛ̀ koo wu ye yichii. Ba gɛ̀ gɛɛ wu wu shee wu gime jwe wu fwese wu muh wu kwa wɛɛ le, ");
INSERT INTO ncr_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","wu chiɛɛne laa sege wu jii mwɛɛ fiɛɛ shɛɛ wu boŋ wu ji la. No wu gɛ̀ gime fo noo, bvú mɛɛse yi too yi laaji biŋkogo bie. ");
INSERT INTO ncr_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Yi kife kimi le, muh kifufe wɛɛ kwe, banchɛndaa ba Nyo gɛ̀ tuu wu bo gɛɛŋ bo gɛɛ wu kijusɛ ki joŋe le mbebe Ablaham le. Muh wu kwa wɛɛ gɛ̀ kwe tɛ ba jiiyɛ wu. ");
INSERT INTO ncr_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Wu gɛɛŋ wù nyu woŋ wu baŋkfu le wu tu wù nyu fo yi ŋgɛ wù baaŋ le. Wu gɛ̀ ja wu noŋ ajii, wu yɛŋ Ablaham le je yì ndefe le bɛ Lasulo mbebe ye le. ");
INSERT INTO ncr_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Wu tɛɛŋ lɛ, ‘Chii Ablaham, kôo yii fɛ mɛne wo chîiŋsɛ Lasulo lɛ wu lêesɛ nyi yi kwaaŋ yi kibo ke a joo le wu tô wu jîɛɛsɛ lɛmɛ chaŋ yu. Nle lo yi manluŋ mà baaŋ le yi ŋgu kfunɛ le.’ ");
INSERT INTO ncr_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ablaham chvuu fie lɛ, ‘Mwa yaŋ, kwajɛ sege wo gɛ̀ baaŋ wo chee yi nshɛŋ le. Wo gɛ̀ kɛme mwɛɛ mù joŋe munchii sege kɛɛ, Lasulo yɛne fie nyu ŋgɛ. Mɛɛse Lasulo le yi bvujoŋɛ le, wo nyu yi maluŋ le. ");
INSERT INTO ncr_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Gɛ mɛ gɛh finɛ fiɛɛ maa gɛ. Wo kêe tɛ lɛ mɛɛse kiŋkoŋ ki baaŋ le ba seesɛ lɛ gɛ taŋlo muh ja fɛnɛ wu daŋsɛ wu to fɛ wo le gɛ, gɛ taŋlo tɛ muh ja fɛ wo le wu daŋ wu to tɛ fɛnɛ gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Muh kwa wɛɛ ka wu lɛgɛ lɛ, ‘Kii wo chii, tûŋ gɛh Lasulo fɛ bee kfuuŋ. ");
INSERT INTO ncr_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ŋkɛme booŋ ba bwɛɛŋ batɛŋ, wu gɛ̂ɛŋ wu chîisɛ bo le lɛ bo yɛ̂nɛ keefɛ bo tô tɛ fɛ kijusɛ ki ŋgɛ kinɛ le gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ablaham chvuu fie lɛ, ‘Booŋ ba bwoo kɛme baŋwa ba Musɛ gɛ̀ saŋ bɛ baŋwa ba bamii ba ntuŋ wu Nyo gɛ̀ saŋ, bo nyu bo yûge mwɛɛ mu bo duu.’ ");
INSERT INTO ncr_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Muh kwa wɛɛ faŋ wu jɛmɛ lɛ, ‘Aay chii Ablaham, be bee nyu muh mu wù bu yi kwe le wu gɛɛŋ wu fejɛ bo le, tu bo bee bo yu bo kusɛ muntele muboo.’ ");
INSERT INTO ncr_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ablaham chvuu wu le lɛ, ‘Bo faŋ ki bo yu fiɛɛ fì Musɛ bɛ bamii ba ntuŋ wu Nyo duu, tu gɛ taŋlo bo yu tɛ mo fiɛɛ fì muh wu bu yi kwe le jɛme gɛ.’” ");
INSERT INTO ncr_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jiso jɛmɛ booŋ be ba ŋgoo le lɛ, “Gɛ mwɛɛ mù tele bamii fɛ bo gêe kimbefɛ nyu njɛ mu lé mu nyû yu sɛŋ gɛ. Geenɛ, ŋgɛ wù baaŋ le fɛ muh wù tele lɛ bamii gêe bimbefɛ le. ");
INSERT INTO ncr_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Fi joŋe fɛ wu wɛɛ muh le lɛ ba shɛŋshɛ ki bwee ki jɛnɛ a kindoŋ ke le, ba tooŋsɛ wu a joo yì baaŋ le, fede fɛ wù gee booŋ banɛ gêe bimbefɛ. ");
INSERT INTO ncr_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Bɛŋ doo bɛŋ nyume bɛŋ yɛ̂ne. Mwa bwoo nɛ le wu ge fiɛɛ fì befe, wo jɛmɛ wu le. Wu nɛ le wu kusɛ, wo foosɛ wu. ");
INSERT INTO ncr_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Wu nɛ le wu ge mwɛɛ mù mbefe fɛ wo le, kiŋgane kinsooshwi yi juu le, wu kaasɛ wu to wu ku chiaaŋ lɛ wu le wu jiaa, tu wo kɛmɛ ki wo fôosɛ wu.” ");
INSERT INTO ncr_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Booŋ ba Tada ba ntuŋ ja bo jɛmɛ wu le lɛ, “Gee lɛ mbɛmɛ wese tɛɛme chuule.” ");
INSERT INTO ncr_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tada chvuu bo le lɛ, “Nsɛŋe bɛŋ nchiɛɛŋ lɛ, bɛŋ nɛ be kɛme mbɛmɛ wu le gɛh njɛ shaŋ yì nsuu, tu taŋlo bɛŋ du kite kì baaŋ kinɛ le lɛ ki mugɛ ye, fɛnɛ ki gɛɛŋ ki lɛɛŋ a joo yì baaŋ le, tu ki lé ki mo ki yû lo bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Bɛŋ jo lɛ muh wu ŋgoo yɛne kɛmɛ mwa ye wu lɛme, wu she wu lɛne mwɛne, kɛnɛ wu be jiiŋe nyu fɛ shóŋ le, wu doo wu kwɛɛ, taŋlo wu mo wu du lɛ mwa ye wu lɛme wɛɛ gɛɛŋ lo wu jo mwɛɛ mwe munjile wu shii wu jii? ");
INSERT INTO ncr_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Gɛ taŋlo fi nyu noo gɛ. Fiɛɛ fì wu taŋlo wu du le gɛ lɛ wu gɛ̂ɛŋ wu kûsɛ njú, wu sêesɛ mwɛɛ munjile mwe wu tô bɛ mu, wu mo wu chîɛɛne, wu doo wu jî mwɛɛ, wu muu, wu bânyɛ shú fɛ wu gɛ̂ɛŋ wu jîi mwe. ");
INSERT INTO ncr_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mwa ye wu lɛme wɛɛ ge mwɛɛ munɛ munchii, wu she wu nyaa wu kiyone? ");
INSERT INTO ncr_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Le gɛh yɛɛŋyɛɛŋ no fiena le. Bɛŋ doo bɛŋ ge wa lɛme chì ba gɛ̀ nya bɛŋ le chi ka, bɛŋ du lɛ, ‘Bee le gɛh lo fiesa booŋ ba lɛme, bee le be ge wa lɛme chesa.’” ");
INSERT INTO ncr_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jiso gɛ̀ gɛɛne Yɛlusalɛm, wu fede a kijwe ki woŋ wu Samaliya bɛ ki Galalee le. ");
INSERT INTO ncr_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Wu gɛ̀ gɛɛne wu doo wu leese ntɛ wumu le, bilɛŋsɛ bamu yuufe ba gɛ̀ chɛne bɛ goŋ yì baaŋ yɛŋ wu le bo nyu je yì ndefe le, ");
INSERT INTO ncr_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","bo mo bo tɛɛŋ bɛ jɛ yi tɛɛme lɛ, “Jiso chiji kikwɛɛ, koo gɛh yii fɛ bee le.” ");
INSERT INTO ncr_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","No Jiso yɛŋ bo le, wu jɛmɛ lɛ, “Bɛŋ gɛ̂ɛŋ bɛŋ dûnyɛ ye yene bachiji kintanyɛ le.” No bo ja bo gɛɛne bo mo bo tɛmɛ bo yuu bo baaŋ a je. ");
INSERT INTO ncr_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Muh mu a bo antɛnɛɛ yɛŋ lɛ wu le wu tɛmɛ wa, wu kaasɛ wu tu jiŋ fɛ Jiso le wu yuuse Nyo fɛwɛɛwe. ");
INSERT INTO ncr_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Noo, wu gɛɛŋ wu mo wu gwe a Jiso jii, wu nya wu kiyone. Muh wuyu gɛ̀ bee muh wu Samaliya. ");
INSERT INTO ncr_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jiso jɛmɛ lɛ, “Bamii bee yuufe ba mbe nfɛ bo mo bo yuu, ba bvuugɛ le faane? ");
INSERT INTO ncr_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Fi le lɛ muh baaŋ nyu gɛ yu, wù yɛŋ lɛ wu lé wu kâasɛ wu tu jiŋ wu nya mbɛɛŋsɛ Nyo le fede ntolo wunɛ gɛ?” ");
INSERT INTO ncr_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jiso mo wu jɛmɛ wu le lɛ, “Ja we wo gɛ̂ɛne fiuŋ. Fitele fì wo lese yi ye yaŋ le, le fi ge wa wo tɛmɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Bafalashii gɛ ja bo biih Jiso le laa bvunfoŋ bvu Nyo bvunɛ le bvu to sege la lɛ. Wu chvuu lɛ, “Gɛ njiŋɛ nyu yu wù lé wu gê wu dûnyɛ sege Nyo lé wu gê wu kɛ̂ wu sâge bvunfoŋ bwe bvunɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Gɛ muh nyu yu wù lé wu gê wu dû lɛ, ‘Bɛŋ jîŋɛ bɛŋ yɛ̂ŋ, nɛ Nyo wunɛ wu sage fɛnɛ’, kɛnɛ lɛ, ‘Nɛ wu wege wu sage fɛge gɛ.’ Bɛŋ yêgɛ bɛŋ yû, bvunfoŋ bvu Nyo le nyu a bɛŋ ntɛnɛɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Wu mo wu kaasɛ wu jɛmɛ wa nyu booŋ be ba ŋgoo le lɛ, “Kife too lo kì bɛŋ lé bɛŋ gê bɛŋ gôone ki bɛŋ yɛ̂ŋ muh wù jee che le Mwamuh le gɛh yi juu le chimimia, bɛŋ gɛ yɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Lé gê nyû kife kɛɛ le bamii bamu duu lɛ, ‘Bɛŋ jîŋɛ bɛŋ yɛ̂ŋ, nɛ muh wege fɛge’, kɛnɛ lɛ, ‘Bɛŋ jîŋɛ bɛŋ yɛ̂ŋ, nɛ muh wunɛ fɛnɛ.’ Bo doo bo jɛme noo, keefɛ bɛŋ bîi bo le gɛ. Keefɛ bɛŋ gɛ̂ɛne bɛŋ biji gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Bɛŋ kee no jaŋ to yi lale we nɛ mwamwamwa, abu a woŋ a ana le achii yuu nɛ mwaaŋ, bamii bachii yɛŋ. Le gɛh yɛɛŋyɛɛŋ no bamii bachii lé bo tô bo yɛ̂ŋ muh wù jee che le Mwamuh le juu chì wu kaase wu too. ");
INSERT INTO ncr_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Geenɛ, no wu lé wu gê wu gɛ̂ɛne, fɛ wu kaasɛ wu to, lé wu kɛ̂me ki wu yâ wu yɛ̂ŋ baŋgɛ ba duude kiŋgogɛ ki mɛɛse kinɛ faŋ wu. ");
INSERT INTO ncr_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Gɛh yɛɛŋyɛɛŋ no fi gɛ̀ bee kife kì Nyua le, nyu gɛh no fi lé fi gê fi nyûme kife kì muh wù jee che le Mwamuh. ");
INSERT INTO ncr_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bo gɛ̀ jii mwɛɛ, bo ka muu, bikɛse bɛ bilɛŋsɛ taashɛ bvuguu, bamii nyaa booŋ ba taashi bvuguu bɛ bo, gɛɛŋ bu juu chì Nyua gɛ̀ lesɛ a ŋguh le, joo gɛ̀ bu yi to yi lɛɛshɛ bo bachii. ");
INSERT INTO ncr_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Fi lé fi gê fi nyû tɛ gɛh yɛɛŋyɛɛŋ no fi gɛ̀ bee kife ki Lod le. Bamii gɛ̀ jii mwɛɛ, bo muu, bo kame waaŋ, bo lɛne ŋɛ, bo ka joone yéh. ");
INSERT INTO ncr_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Juu chi Lod gɛ̀ bu Sodom, Nyo mo wu shiishɛ ŋgu we wu shiide wu bɛde nje muŋkaŋ, wu shii wu mo wu lɛɛshɛ bamii ba Sodom bachii. ");
INSERT INTO ncr_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Le gɛh no fi lé fi gê fi nyûme juu chi muh wù jee che le Mwamuh lé wu gê wu jâgɛ wu bunɛ. ");
INSERT INTO ncr_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Lé tô nyû abvu bwɛɛ, keefɛ muh wu le kigo ki yeh le, mwɛɛ mwe nyume yeh, ka wu shii ki wu lêe yeh lɛ wu jo fiɛɛ fì le yeh gɛ. Yɛɛŋyɛɛŋ tɛ, keefɛ muh wu le nchvuuŋ ka wu kwɛɛde ki wu tô wu jo fiɛɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Bɛŋ kwâji fiɛɛ fì gɛ̀ kooshɛ bɛ kwɛ Lod. ");
INSERT INTO ncr_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Muh wù goone ki wu bâji kinche ke lɛ keefɛ wu lɛsɛ gɛ, tu wu lé wu lɛ̂sɛ lo. Muh wù lɛsɛ kinche ke tu wu lé wu bâji lo kinche ke. ");
INSERT INTO ncr_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nduu bɛŋ le lɛ, lé gê nyû kintaŋ kɛɛ le, bamii lé bo gê bo gîme fɛnta bafɛɛ, ba jo wu mumwaa wu mumwaa shɛɛ. ");
INSERT INTO ncr_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Bikɛse bafɛɛ lé bo gê bo gôge bvulɛɛŋ fɛ jɛɛŋ, ba jo wu mumwaa wu mumwaa shɛɛ. ");
INSERT INTO ncr_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Bilɛŋsɛ bafɛɛ lé bo gê bo nyû mwɛne, ba jo wu mumwaa wumu shɛɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Booŋ be ba ŋgoo biih wu le lɛ, “Tada, fiɛɛ fiyu lé fi gê fi kôoshɛ nyu faaŋ?” Wu chvuu nyu a ŋgaŋ le lɛ, “Fɛ gvunɛ chi fiɛɛ to chi nyume fo le gɛh fo fɛ baŋgvuluŋ to bo taashi fo.” ");
INSERT INTO ncr_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jiso mo wu ma ŋgaŋ wumu ki wu yɛ̂yɛ booŋ be ba ŋgoo, lɛ bo kɛme ki bo bûunɛ segechii bo ya fwɛɛne gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Wu jɛmɛ lɛ, “Muh wù sage bansa wumu gɛ̀ bee a kinlaantɛŋ kimi le, wu faane gɛ Nyo gɛ, wu yɛde gɛ jise chi muh le gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kwɛŋkfu wumu gɛ̀ bee tɛ a kinlaantɛŋ kɛɛ le. Wu gɛ̀ gɛɛne segechii wu kude chiaaŋ muh wù sage bansa wɛɛ le lɛ wu fîh wu ki wu sûunɛ nsa we bɛ muh we wu kimbanɛ. ");
INSERT INTO ncr_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Muh wɛɛ leese gɛ gvune atunu gɛ, kwɛŋkfu wɛɛ mɛ gɛh wu gɛɛne fo. Ajiŋ ayu muh wɛɛ jɛmɛ kikwɛɛ ke le lɛ, ‘No nle fɛnɛ gɛ nfane Nyo gɛ, gɛ muh kooji fiɛɛ a mɛ jii gɛ, ");
INSERT INTO ncr_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","geenɛ no kwɛŋkfu wunɛ too gɛh wu fuuŋse mɛ nɛ, nlé n'yɛ̂ŋ lɛ nlé nsûunɛ nsa we no wu goone, fuge noo sɛŋ, tu wu lé wu mɛ gɛh wu tôo wu jêese mɛ nɛ, muh lé wu jâ wu kwê lo a wu bo.’” ");
INSERT INTO ncr_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","No Tada ma noo, wu mo wu jɛmɛ lɛ, “Bɛŋ yu fiɛɛ fì muh wu gɛ̀ sage bansa ba kinfi, wunɛ gɛ jɛme. ");
INSERT INTO ncr_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","No wu gɛ fi kwɛŋkfu wɛɛ nɛ, gɛ taŋlo Nyo fi tɛ bamii be ba wu le wu cha wa ba beede fɛ wu le antaŋ bɛ fɛnshɛ gɛ? Taŋlo wu tu wu chiide lo ye? ");
INSERT INTO ncr_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nsɛŋe bɛŋ le lɛ Nyo lé wu sûunɛ lo nsa wuboo chige. Geenɛ muh wù jee che le Mwamuh doo wu kaase wu too, wu lé wu yɛ̂ŋ bamii nyu yu ba leese muntele yi Nyo le fɛkuu fɛnɛ noo?” ");
INSERT INTO ncr_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jiso ja wu ka wu ma ŋgaŋ wumu, nyu bamii ba gɛ̀ yɛde ye yiboo le, lɛ bo le bamii ba chaaŋ, bo mo bo tu bo nyiɛŋse lo bamii bamu. ");
INSERT INTO ncr_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Wu jɛmɛ lɛ, “Bamii bamu bafɛɛ gɛ̀ bee bo bɛɛŋ bo gɛɛŋ yeh yi kintanyɛ le, ki bo buunɛ. Muh mu gɛ̀ bee muh Bafalashii, wumu nyu muh wù koode ŋwa. ");
INSERT INTO ncr_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Bo gɛɛŋ bo lee yeh yi kintanyɛ le, muh wu Bafalashii wɛɛ gɛɛŋ wu lɛɛŋ fie wu mo wu buunɛ lɛ, ‘Nyo, nnyaa wo kiyone njɛ gɛ mɛ nyume nje bamii bamu gɛ. Gɛ n'yɛɛde ajii yi mwɛɛ le gɛ. Gɛ nfige kinfi gɛ. Gɛ njaŋe bikɛɛ bamii lɛ gɛ, gɛ mɛ nyume tɛ njɛ muh wù koode ŋwa wege gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nto mbane mwɛɛ munjile aju afaa yi kimaa le. Nto nnyaa kimbe kimimia wo le a ntɛnɛɛ a bimbe yuufe bi mwɛɛ munchii mu ŋkɛme.’ ");
INSERT INTO ncr_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Geenɛ, muh wù gɛ̀ koode ŋwa wɛɛ gɛ̀ lɛɛŋ fie je yì ndefe le, wu gɛ bijɛ mo we gɛ, wu so kikwɛɛ, wu koo yii, wu mo wu buunɛ lɛ, ‘O Nyo, nle fiaŋ muh wù befe, kôo yii fɛ mɛne.’” ");
INSERT INTO ncr_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","No Jiso ma nɛ, wu mo wu du lɛ, “Nsɛŋe bɛŋ le lɛ muh wù gɛ̀ koode ŋwa wɛɛ gɛ̀ bu wu bohge a wu yeh, wù nyu chaaŋ a Nyo jii fede muh wu Bafalashii wɛɛ. Le gɛh yɛɛŋyɛɛŋ no muh wuchii wù bɛɛŋse ye ye, lé ba nyû ba gê ba shiishɛ lo wu, muh wuchii wù shiishi kikwɛɛ ke, ba lé ba gê ba bɛ̂ɛŋsɛ lo wu.” ");
INSERT INTO ncr_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bamii gɛ̀ ja bo too bɛ booŋ ba shige shige fɛ Jiso le lɛ wu kuŋ bo le. Booŋ be ba ŋgoo yɛŋ noo, bo tu bo leese lo bo. ");
INSERT INTO ncr_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Geenɛ, Jiso tɛɛŋ booŋ bayu lɛ bo tôo, wu mo wu jɛmɛ booŋ be ba ŋgoo le lɛ, “Bɛŋ chînɛ booŋ ba shige shige too fɛ mɛne. Keefɛ bɛŋ jêese bo gɛ, nje bvunfoŋ bvu Nyo, le nyu fɛ bamii ba le nje booŋ banɛ le. ");
INSERT INTO ncr_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nsɛŋe bɛŋ nchiɛɛŋ lɛ, muh wù baaŋ fi gɛ bvunfoŋ bvu Nyo njɛ mwa wù shige gɛ, tu gɛ wu nyu wu ge wu lee fɛ bvunfoŋ bvuyu le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Muh wù baaŋ wumu biih Jiso le lɛ, “Muh wu N'yɛyɛ, wo wù muh wù joŋe, fiɛɛ fì ŋkɛme ki ŋge fɛ ŋkɛmɛ kinche kì kage gɛ, le la?” ");
INSERT INTO ncr_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jiso biih wu le lɛ, “Wo tɛŋe mɛ lɛ muh wù joŋe nje la? Gɛ muh nyu yu wù joŋe gɛ. Mɛ gɛh Nyo maa wù joŋe. ");
INSERT INTO ncr_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Geenɛ, ki ntu jiŋ yi fiɛɛ fì wo be bilɛ le, wo kee gɛ banchi ba duu lɛ, ‘Keefɛ wo jâŋ kwɛ muh gɛ, keefɛ wo yûuyɛ muh gɛ, keefɛ wo chôŋ bvuchoŋ gɛ, keefɛ wo bɛ̂ɛ jiŋ yi nsa wu chimbiaŋ gɛ’, bɛ lɛ, ‘Wo ŋgvûune chijo bɛ bwoo’ gɛ?” ");
INSERT INTO ncr_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Wu chvuu lɛ, “Banchi banɛ bachii ŋgɛ ŋkɛ wa ŋgɛɛde mbaaŋ chumu.” ");
INSERT INTO ncr_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jiso yu noo, wu jɛmɛ wu le lɛ, “Tu fiɛɛ le fi shɛɛ fimimia fì wo baaŋ wo ge. Gɛnɛ, wo gesɛ mwɛɛ mwuŋ munchii, wo ga bige biyu bamii ba fuude le, wo mo wo kɛme nchvu nyu woŋ wù fɛwe. Wo doo wo ge noo, wo mo wo tô wo bîi mɛne.” ");
INSERT INTO ncr_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Geenɛ lɛ wu yu noo, ye mo yi wooŋ lo wu, nje wu gɛ̀ kɛme kwa baaŋ. ");
INSERT INTO ncr_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jiso biji wu nɛ, wu jɛmɛ lɛ, “Fi tɛɛme baaŋ fɛ muh wu kwa lee fɛ bvunfoŋ bvu Nyo le. ");
INSERT INTO ncr_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Fi le chige fɛ nyambala leki yi lêe a jise chi nsala le fede fɛ muh wu kwa ki wu lêe yi bvunfoŋ bvu Nyo le.” ");
INSERT INTO ncr_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bamii ba gɛ̀ bee fo yu noo, bo biih lɛ, “Finɛ le noo, yu to bonɛ yɛɛŋ?” ");
INSERT INTO ncr_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Geenɛ Jiso chvuu lɛ, “Gɛ fiɛɛ fì ghage bamii ki bo ge taŋlo fi gha Nyo no wu ge gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Bita jɛmɛ wu le lɛ, “Bîjɛ yɛ̂ŋ, bee le be chinɛ wa mwɛɛ mwesa le, bee tu be bii wo le.” ");
INSERT INTO ncr_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jiso chvuu bo le lɛ, “Nsɛɛŋ bɛŋ nchiɛɛŋ lɛ, gɛ muh nyume yu wù le wu chinɛ la che le, kɛnɛ kwɛɛ le, kɛnɛ booŋ ba bwee le, kɛnɛ chiji le bɛ bwee le, kɛnɛ booŋ be le, nje bvunfoŋ bvu Nyo, ");
INSERT INTO ncr_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","wu ge wu nyu wu nyume njɛ wu kɛmɛ bamii bɛ mwɛɛ wesee yi kiŋkfuuŋ kinɛ le yage mù wu chinɛ le gɛ. Lé tô nyûme yi kife ki kiŋkfuuŋ kì too le, wu kɛ̂me kinche kì kage gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jiso ja wu jo booŋ be ba ŋgoo ba yuufe ncho bafɛɛ bɛ bo kɛŋsɛ yo. Wu jɛmɛ bo le lɛ, “Bɛŋ yêgɛ bɛŋ yû, bee bɛɛne wa bee gɛɛne Yɛlusalɛm, sege bee bɛɛŋ be bu yo, fiɛɛ fichii fì bamii ba ntuŋ wu Nyo gɛ̀ saŋ kune muh wù jee che le Mwamuh lé fi tô fi kojɛ. ");
INSERT INTO ncr_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Fi mo fi tu fi nyu lɛ ba lé ba nyâ wu chiaaŋ yi bituŋ le, ba chwɛɛse wu, ba naanyi wu, ba chuuyi wu bɛ nchwene ye ye le. ");
INSERT INTO ncr_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ba taane wu bɛ munte, ba yuuyɛ wu, ge doo nyume aju atade, wu bu yi kwe le.” ");
INSERT INTO ncr_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Jiso jɛmɛ noo, fi fuuŋsɛ bo, bo baaŋ kɛɛ gɛ laa wu jɛme lɛ la lɛ, nje fiɛɛ fimi gɛ̀ ge lɛ fɛ bo kɛɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jiso gɛ̀ doo wu fede a kinlaantɛŋ ki Jɛliku le, kinfeeŋ kimi shii jwe wu je le, ki lɛge mwɛɛ. ");
INSERT INTO ncr_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Wu yu no kinchvu ki bamii kfuunɛ ki fede, wu mo wu biih laa le la lɛ? ");
INSERT INTO ncr_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bo chvuu wu le lɛ, le Jiso wu Nasalɛ wu fede. ");
INSERT INTO ncr_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Wu mo wu kɛ wu tu wu wanɛ lɛ, “Jiso, Mwa Nfoŋ Dabi, kôo yii fɛ mɛne.” ");
INSERT INTO ncr_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bamii ba gɛ̀ saa fwe, waŋ wu bo jɛmɛ lɛ wu baŋ lo. Geenɛ wu ka wu mɛsɛ lo wu waŋ fɛwɛɛwe lɛ, “Mwa Nfoŋ Dabi, kôo yii fɛ mɛne.” ");
INSERT INTO ncr_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jiso yu, wu lɛɛŋ wu jɛmɛ lɛ bo to bɛ wu. Bo to bɛ wu, Jiso biih wu le lɛ, ");
INSERT INTO ncr_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Wo goone lɛ ŋge la fɛ wo le?” Wu chvuu lɛ, “Tada, gêe lɛ ŋka yɛnɛ mwɛɛ le.” ");
INSERT INTO ncr_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jiso mo wu jɛmɛ wu le lɛ, “Wo yɛ̂ne la mwɛɛ le. Fitele fiuŋ fì wo lese yi ye yaŋ le, le fi ge wa ajii awo gwenyɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kimimia noo, wu mo wu kaasɛ wu tu wu yɛde mwɛɛ le. Wu mo wu ja wu tu wu bii Jiso le wu tume maŋkuŋ ma Nyo. Bamii bachii ba gɛ̀ bee fo yɛŋ, bo nya mbɛɛŋsɛ Nyo le. ");
INSERT INTO ncr_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jiso gɛɛŋ wu lee a kinlaantɛŋ ki Jɛliku le, wu fede. ");
INSERT INTO ncr_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Muh mu gɛ̀ bee yo jee che nyu lɛ Sakio, nyu chiji kikwɛɛ ki bamii ba koode ŋwa, nyu tɛ muh wu kwa. ");
INSERT INTO ncr_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Wu gɛ̀ goone ki wu yɛ̂ŋ Jiso le no wu fede. Geenɛ, fi ya wu nje wu gɛ̀ kfufe lo, kinchvu ki bamii baŋe wu. ");
INSERT INTO ncr_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Wu mo wu legɛ wu gɛɛŋ fwe, wu gɛɛŋ wu bɛɛŋ yi kite kimi le lɛ Jiso ge doo wu fede wu yɛŋ wu le. Nje wu gɛ̀ bee ki wu fê je yo. ");
INSERT INTO ncr_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jiso gɛɛŋ wu bu fo, wu noŋ ajii wu yɛŋ wù le fɛwe, wu tɛɛŋ wu lɛ, “Sakio, shîlɛ chige wo tô, nje ŋkɛme ki nche a wo yeh a bɛŋ.” ");
INSERT INTO ncr_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Wu mo wu tɛɛshɛ lo wu shii yi kite kɛɛ le, wu fi Jiso bɛ kinlaŋye. ");
INSERT INTO ncr_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bamii bachii ba gɛ̀ yɛŋ no Jiso gɛ̀ gɛɛne bɛ wu, bo mo bo kɛ bo tu bo shuŋshi bo duu lɛ, “Muh wunɛ gɛɛne wa ki wu gɛ̂ɛŋ wu che bɛ muh wù befe wunɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Lɛ bo doo bo gɛɛŋ bo nyume Sakio ja wu lɛɛŋ we wu jɛmɛ Jiso le lɛ, “Tada, bîjɛ yɛ̂ŋ, nlé ŋgâ mwɛɛ mwaŋ antɛnɛɛ nya bamii ba kifufe le. Nɛ ŋgɛ̀ mbee nfi wa muh, tu nlé ŋkâasɛ nchvuu kiŋgane kinɛh, mwɛdɛ le.” ");
INSERT INTO ncr_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","No Jiso yu noo, wu jɛmɛ wu le lɛ, “Yi abɛŋ le, nfi le wu to wa yeh kfunɛ, no chiji la chinɛ le tɛ mwa Ablaham. ");
INSERT INTO ncr_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Muh wù jee che le Mwamuh gɛ̀ to ki wu gôoŋ bamii ba le bo lɛsɛ wa, wu bvusɛ bo.” ");
INSERT INTO ncr_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","No bamii gɛ̀ yege no Jiso jɛme mwɛɛ munɛ, wu ja wu mo wu gɛɛŋ fwe wu ma ŋgaŋ wumu bo le, nje gɛ̀ shɛshi wa shige wu lee Yɛlusalɛm, bamii kwaji lɛ segemu Nyo le wa ki wu kɛ̂ wu sage bvunfoŋ bwe. ");
INSERT INTO ncr_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Wu jɛmɛ lɛ, “Gɛ̀ bee kife kimu, mwa nfoŋ wumu ja woŋ wuboo le wu gɛɛŋ woŋ wumu le, je yì ndefe le, lɛ ba gɛɛŋ ba ghaa wu nfoŋ le, fɛ wu kaasɛ wu to wu sage bvunfoŋ bwe. ");
INSERT INTO ncr_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Wu gɛ̀ doo wu jade, wu tɛɛŋ booŋ be ba lɛme ba yuufe, wu ga bige bo le kikɛɛ kikɛɛ, wu jɛmɛ lɛ, ‘Bɛŋ kô, bɛŋ shɛ̂ɛ bɛŋ gêe waaŋ yu fɛ ntoo.’ ");
INSERT INTO ncr_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Wu mo wu ja, bamii ba woŋ kwɛɛ le gɛ̀ bane wu baaŋ. Bo mo bo shɛɛ bo tuŋ bamii a wu jiŋ lɛ, bo gɛɛŋ bo du lɛ gɛ bo koŋe muh wɛɛ lɛ wu nyume nfoŋ wuboo gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ba gɛ̀ gɛɛŋ gɛh ba ghaa wu. Sege wu gɛ̀ tu jiŋ wu nyu wu fi wa bvunfoŋ, wu du ba tɛɛŋ booŋ be ba lɛme baa ba wu gɛ̀ ga bige bo le, ki wu yɛ̂ŋ laa bo gɛ̀ shɛɛ bo ge waaŋ bo kɛmɛ mbe la. ");
INSERT INTO ncr_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Wù fwe to wu jɛmɛ lɛ, ‘Chiji wese, kikɛɛ kuŋ ki bige kì wo gɛ nya mɛne, nle nshɛɛ ŋkɛme mbe yo bikɛɛ yuufe.’ ");
INSERT INTO ncr_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Wu yu joŋ, wu chooŋe wu, wu jɛmɛ lɛ, ‘Wo le mwa lɛme wù joŋe. No wo le wo shɛɛ wo kɛɛ ki wo bîjɛ fɛ fiɛɛ fì shige le. Noo, nlé ŋgɛ̂ɛ wo wo sâge bantɛ yuufe.’ ");
INSERT INTO ncr_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Wù bii fo tɛ to wu jɛmɛ lɛ, ‘Chiji wese, kikɛɛ kuŋ ki bige kì wo gɛ̀ nya mɛne nle nshɛɛ ŋkɛme mbe yo bikɛɛ bitɛŋ.’ ");
INSERT INTO ncr_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Wu jɛmɛ wu le lɛ, ‘Nlé ŋgɛ̂ɛ wo wo sâge bantɛ batɛŋ.’ ");
INSERT INTO ncr_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Mwa lɛme wumu to wu jɛmɛ fie lɛ, ‘Chiji wese, kikɛɛ kuŋ ki bige kinɛ nle nshɛɛ kaaŋ a nchaŋa yi nju le ŋgɛɛ. ");
INSERT INTO ncr_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nchi gɛɛde nje wo tɛɛme ajiŋ, nfane wo. Wo gɛ̀ bee njɛ wo le wo gɛɛ sɛŋ, wo mo wo to wo jo lo. Doo nyume njɛ wo le wo mbooŋ fiɛɛ sɛŋ, wo mo wo to wo gweji lo.’ ");
INSERT INTO ncr_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Chiji kikwɛɛ we jɛmɛ wu le lɛ, ‘Wo le mwa wù befe. Njɛmɛ wù bu jwe wo le le wu, wù nlé njo nsa wo yu. Wo gɛ̀ kee lɛ ntɛɛme ajiŋ, njode fiɛɛ njɛ nle ŋgɛɛ sɛŋ, nle njɛ mbooŋ fiɛɛ sɛŋ mo nto gweji lo. ");
INSERT INTO ncr_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Wo gɛ̀ doo wo kee noo, gɛ̀ ge la fɛ wo jo bige biaŋ wo gɛɛŋ wo gɛɛ a nchvu le sɛŋ, wu lɛ sege ŋkaasɛ nto nfi bɛ mbe?’ ");
INSERT INTO ncr_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Wu mo wu jɛme bamii ba gɛ̀ lɛme mbebe ye le lɛ, ‘Bɛŋ fì kikɛɛ ki bige kiyu a wu le, bɛŋ nyâ muh wù kɛme bikɛɛ bi bige yuufe le.’ ");
INSERT INTO ncr_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bo kajɛ lo, bo jɛmɛ lɛ, ‘Chiji kikwɛɛ, wù kɛme wa bikɛɛ bi bige yuufe.’ ");
INSERT INTO ncr_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Wu jɛmɛ lɛ, ‘Nsɛŋe bɛŋ le lɛ muh wù kɛme fiɛɛ lé ba nyû ba bîsɛ. Geenɛ muh wù kɛme gɛ, fì shige fì wù kɛme lé ba nyû ba fî lo a wu le. ");
INSERT INTO ncr_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Yi mɛɛse le, bamii baa ba gɛ̀ banɛ mɛ, bo faŋe lɛ keefɛ mɛ nyû nfoŋ wuboo gɛ, bɛŋ gɛ̂ɛŋ bɛŋ tô bɛ bo bɛŋ yûuyɛ a mɛ jii.’” ");
INSERT INTO ncr_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ajiŋ ayu no Jiso gɛ̀ jɛmɛ mwɛɛ munɛ, wu mo wu ja wu tu wu saa fwe wu bɛɛne wu gɛɛne Yɛlusalɛm. ");
INSERT INTO ncr_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Sege wu gɛ̀ doo wu fɛɛse ntɛ wù Bɛfash bɛ wù Bɛtani le, bo nyume mbebe yi mbegɛ wu Bite bi Olif le, wu mo wu baa booŋ be ba ŋgoo bamu bafɛɛ wu tuŋ bo, ");
INSERT INTO ncr_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","wu jɛme lɛ, “Bɛŋ gɛ̂ɛŋ ntɛ wù fwe wege le. Bɛŋ doo bɛŋ lese yo, bɛŋ yɛŋ mwa jaki le, ba shuudɛ wù muh gɛ baaŋ yu we a bɛɛŋ gɛ, bɛŋ faanyɛ bɛŋ to bɛ wu fɛnɛ. ");
INSERT INTO ncr_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Bɛŋ doo bɛŋ faanyɛ, muh nɛ le wu biih laa bɛŋ faanyi nje la lɛ, bɛŋ chvuu lɛ Chiji Kikwɛɛ goone lo.” ");
INSERT INTO ncr_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Booŋ ba ŋgoo baa gɛ̀ gɛɛŋ bo yɛŋ fiɛɛ fichii nyu gɛh yɛɛŋyɛɛŋ no wu be jɛme. ");
INSERT INTO ncr_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bo gɛ̀ doo bo faanyi mwa jaki wɛɛ, bamii ba gɛ̀ kɛme biih lɛ, “Bɛŋ faanyi mwa jaki wɛɛ nje la?” ");
INSERT INTO ncr_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bo chvuu lɛ, “Chiji Kikwɛɛ goone ki wu bɛ̂ɛŋ yu.” ");
INSERT INTO ncr_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bo mo bo jo bo to bɛ wu fɛ Jiso le, bo dɛŋ bikuŋ biboo yi jaki wuyu wɛɛ le, bo mo bo bɛɛŋsɛ Jiso yu we. ");
INSERT INTO ncr_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Wu ja wu gɛɛne, bamii dɛŋe bikuŋ biboo a je, wu fede yu. ");
INSERT INTO ncr_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Wu gɛɛŋ, lɛ wu fɛsɛ fɛ je yì bohge a mbegɛ wu Bite bi Olif le, kinchvu ki bamii be ba ŋgoo bachii jaŋɛ, bo tu bo wuule bo yuuse Nyo fɛwɛɛwe, nje biŋgha bi mwɛɛ bichii bì bo gɛ̀ yɛne le. ");
INSERT INTO ncr_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Bo tu bo wuule bo duu lɛ, “Nyo le wu noŋ kimbonɛ yi Nfoŋ wù too a jee chi Tada le. Nyiɛgee le fɛwe, bvukugɛ nyu bvu Nyo wù fɛwe le.” ");
INSERT INTO ncr_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Bafalashii bamu ba gɛ̀ bee a kinchvu kɛɛ ntɛnɛɛ mo bo ja bo jɛmɛ Jiso le lɛ, “Muh wu N'yɛyɛ, dû lɛ bamii buŋ ba ŋgoo banɛ bâŋ lo.” ");
INSERT INTO ncr_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jiso chvuu lɛ, “Nsɛŋe bɛŋ le lɛ bo be baŋ lo, ata kanɛ wuule gɛh lo.” ");
INSERT INTO ncr_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jiso doo wu bu mbebe Yɛlusalɛm le, wu bijɛ yo nɛɛ, wu kesɛ bɛ kwe, ");
INSERT INTO ncr_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","wu tu taanyi lɛ, “O Yɛlusalɛm, nɛ bɛŋ banɛ be kee fiɛɛ fì taŋlo fi to bɛ kimbonɛ fɛ bɛŋ le yi juu chi abɛŋ le! Geenɛ mɛɛse gɛ taŋlo bɛŋ kɛɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Noo, bɛŋ kêe lɛ kife too lo ki bamii bena ba kimbanɛ lé bo nyû bo gê bo tô bo jôoŋ kitaŋ bo gɛŋ bɛŋ bo kɛnɛ, bo baŋ bɛŋ antɛŋ bimbe bichii. ");
INSERT INTO ncr_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bo lé bo gê bo lêe bo lɛ̂ɛshɛ lo bɛŋ mo booŋ bena, bo sa yeh yene, tɛdɛ gɛ shɛɛ yi chimi le gɛ. Fi lé fi gê fi kôoshɛ noo, nje bɛŋ baaŋ kɛɛ gɛ kife kì Nyo gɛ̀ to fɛ bɛŋ le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jiso gɛɛŋ fɛ yeh yi kintanyɛ le, wu kɛ wu kuŋe bamii ba gɛ̀ gese mwɛɛ fo, ");
INSERT INTO ncr_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","wu duu bo le lɛ, “Fi le ba saŋ lɛ Nyo duu lɛ, ‘Yeh yaŋ le yeh yi buunɛ.’ Geenɛ bɛŋ kaasɛ yi tu ‘Bvuta bvu bachoŋ.’” ");
INSERT INTO ncr_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jiso shee wu yɛyi bamii fɛ yeh yi kintanyɛ le aju achii. Bachiji kintanyɛ ba baaŋ baaŋ bɛ bamii ba gɛ̀ duunyi banchi ba Nyo, mo bamii ba baaŋ baaŋ ba yo tu bo weede ki bo yuuyɛ wu. ");
INSERT INTO ncr_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Geenɛ bo gɛ kɛmɛ je gɛ, nje bamii bachii gɛ̀ shee gɛh lo mbebe Jiso le, bo goone gɛ ki bo sho lo fiɛɛ fimimia fɛ mwɛɛ mù wu gɛ̀ yɛyi le gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Lɛ nyu juu chimi Jiso yɛyi bamii, wu ka feeji saaka wù joŋe wu Nyo bo le fɛ yeh yi kintanyɛ le. Bachiji kintanyɛ ba baaŋ baaŋ bɛ bamii ba duunyi banchi ba Nyo, mo bamii ba sage woŋ to, ");
INSERT INTO ncr_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","bo biih wu le lɛ, “Gɛh sɛ̂ɛŋ bee mu wù nya wo bvuŋga lɛ wo gêe mwɛɛ munɛ? Nya yɛɛŋ bvuŋga bvuyu wo le?” ");
INSERT INTO ncr_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jiso chvuu bo le lɛ, “Mɛ tɛ nlé mbîi bɛŋ fiɛɛ. Bɛŋ sɛɛŋ mɛne mɛɛse. ");
INSERT INTO ncr_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Bvuŋga bvù Joŋ gɛ̀ leese bamii yu a joo gɛ̀ ja fɛwe noo gɛ̀ nya muh wu wuŋ le?” ");
INSERT INTO ncr_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Bo mo bo koo nchvuuŋ lɛbolɛbo lɛ, “Bee chvuse lɛ gɛ̀ nya Nyo, wu biih bee le laa gɛ̀ ge la lɛ fɛ bee bɛɛŋ Joŋ le la? ");
INSERT INTO ncr_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Bee chvuse lɛ gɛ̀ nya muh wu wuŋ, bamii bachii tume bee bɛ ata, nje bo gɛ̀ bɛɛŋ lɛ le nchiɛɛŋ lɛ Joŋ gɛ̀ bee muh wu ntuŋ wu Nyo.” ");
INSERT INTO ncr_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Noo, bo mo bo chvuu lɛ, “Gɛ bee kee muh wu gɛ̀ nya gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jiso mo wu jɛmɛ bo le lɛ, “Tu gɛ mɛ nyu nsɛɛŋ tɛ bɛŋ muh wù nya bvuŋga mɛne lɛ ŋgêe mwɛɛ munɛ yu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jiso mo wu ja wu ma ŋgaŋ bamii le lɛ, “Muh mu gɛ̀ lɛŋ mwɛ wu muntaŋ mu mbvuuŋ. Wu gɛɛ mwɛ kwɛɛ bamii le, wu mo wu ja wu gɛɛŋ kituŋ kimi le, wu gɛɛŋ wu che yo wesee. ");
INSERT INTO ncr_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kife kì ba to ba kege muntaŋ gɛ̀ to ki kojɛ, wu tuŋ mwa ye wu lɛme lɛ wu gɛɛŋ wu fi mwe muntaŋ. Wu gɛɛŋ, bamii baa ba wu gɛ̀ gɛlɛ mwɛ wu muntaŋ kwɛɛ bo le, bo suŋ lo wu, bo kuŋ bɛ wu, wu tu jiŋ chiaaŋ chiaaŋ. ");
INSERT INTO ncr_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Muh wɛɛ ka wu tuŋ mwa ye wu lɛme wumu, bo ka bo suŋ wuwɛɛ, bo choosɛ lo wu, bo kuŋ wu, wu tu jiŋ chiaaŋ chiaaŋ. ");
INSERT INTO ncr_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Wu ka wu tuŋ wumu kintɛde, bo juŋsɛ wu, bo noŋ wu akfuuŋ. ");
INSERT INTO ncr_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Muh wu mwɛ wu muntaŋ kwɛɛ kwajɛ lɛ, ‘Nlé ŋgê nɛɛ? Nlé ntuŋ wa mɛɛse nyume mwa yaŋ wu le fitele fiaŋ. Segemu bo gɛɛŋ bo gvuuŋ wu.’ ");
INSERT INTO ncr_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Geenɛ bamii baa ba wu gɛ̀ gɛlɛ mwɛ kwɛɛ bo le bo yɛŋ wu le, bo nchvuuŋ nchvuuŋ lɛbolɛbo lɛ, ‘Wunɛ le njibvushɛ bvu muh wu mwɛ kfunɛ. Bee yuuyɛ wu bee mo be jo mwɛ kfunɛ.’ ");
INSERT INTO ncr_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bo mo bo koo wu, bo bvusɛ mwɛne kwɛɛ bo yuuyɛ.” No Jiso ma noo, wu mo wu biih lɛ, “Bɛŋ kwaji lɛ muh wu mwɛ kwɛɛ le wu to wu ge nɛɛ bɛ bamii baa? ");
INSERT INTO ncr_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nsɛŋe bɛŋ le lɛ wu lé wu gê wu tô wu lɛ̂ɛshɛ lo bamii bayu, wu gɛɛ mwɛ kwɛɛ nyu wa bamii bamu le.” No bamii yu noo, bo kajɛ lo lɛ, “Nyo lôŋsɛ lo.” ");
INSERT INTO ncr_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jiso bijɛ bo nɛɛ, wu biih lɛ, “Tu finɛ fì ba saŋ a Ŋwa wu Nyo le jɛme lɛ la, fi le lɛ, ‘Tɛdɛ chiyu chiɛɛ chì bamii ba joone gɛ̀ faŋ, gɛ̀ kaasɛ chi tu tɛdɛ chi buu chi yeh?’ ");
INSERT INTO ncr_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Tɛdɛ chiyu chinɛ le chi chì muh gwe yu wu chiaafɛ lo, chi gwe yi muh le, chi baajɛ lo mwɛdɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","No Jiso ma ŋgaŋ wunɛ nɛ, bamii ba gɛ̀ duunyi banchi ba Nyo bɛ bachiji kintanyɛ ba baaŋ baaŋ mo bo goone lɛ bo koo wu kife kɛɛ le. Bo gɛ̀ goone ki bo koo wu nje bo gɛ̀ kee lɛ wu gɛ̀ ma ŋgaŋ wɛɛ nyu bo le, geenɛ bo faane bamii. ");
INSERT INTO ncr_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Bo tu bo bii bikaa bie le, bo ke bamii, bo tuŋ bo gɛɛŋ bo keeyi wu, bo buuse lɛ bo le bamii ba chaaŋ. Bo gɛ̀ gee noo ki bo yu fiɛɛ jwe we le, bo mo bo koo wu bo nya chiaaŋ yi muh wù sage kimbe kì Lum kɛɛ le. ");
INSERT INTO ncr_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bamii bayu mo bo ja bo biih wu le lɛ, “Muh wu N'yɛyɛ, bee kee lɛ mwɛɛ munɛ mù wo jɛme mo mù wo yɛyi le mu kooji, gɛ wo jiiŋe jise chi muh gɛ. Wo yɛyi nchiɛɛŋ nyu fiɛɛ fì Nyo goone lɛ bamii gêe. ");
INSERT INTO ncr_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Bee mo bee biide lɛ laa, nchi le wu bɛɛŋ lɛ bee laaŋe ŋwa Kaisa Nfoŋ wu Lum le?” ");
INSERT INTO ncr_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jiso kɛɛ fiɛɛ fì bo wɛɛne bɛ fi, wu jɛmɛ lɛ, ");
INSERT INTO ncr_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Bɛŋ tô bɛ danale wu mumwaa n'yɛŋ.” Bo to bɛ wu, wu biih lɛ, “Kikwɛɛ kinɛ kì le yu le ki yɛɛŋ, jee chinɛ le chi yɛɛŋ lɛ?” Bo chvuu lɛ, “Le ki Kaisa, jee le tɛ che.” ");
INSERT INTO ncr_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jiso mo wu jɛmɛ lɛ, “Bɛŋ nyâa Kaisa le fiɛɛ fì le fi Kaisa, bɛŋ nyâa Nyo le fì le fi Nyo.” ");
INSERT INTO ncr_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bamii baa yu fi fuuŋsɛ bo, bo mɛ gɛh jwe wuchile bo ka kɛme gɛ fiɛɛ fì bo koo wu yu a bamii jii gɛ, antɛnɛɛ a mwɛɛ mù wu gɛ̀ jɛme le. ");
INSERT INTO ncr_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Bamii bamu ŋgoo yi Basadushii le gɛ̀ ja bo to fɛ Jiso le. Basadushii banɛ gɛ̀ bee bamii ba gɛ̀ duu lɛ gɛ bamii nyu bo ge bo bu yi kwe le gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Bo biih wu le lɛ, “Muh wu N'yɛyɛ, Musɛ gɛ̀ saŋ a nchi wese le lɛ, ‘Nɛ muh kɛme kwɛse wu kwe njɛ bɛ wu le bo boo mwa sɛŋ, tu mwa bwee kɛme ki wu gɛ̂ɛ kwɛse wuyu, bɛ wu boo booŋ a jee chi ŋkfu mwa bwee le.’ ");
INSERT INTO ncr_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Mɛɛse, booŋ ba muh mu gɛ̀ bee bvusooshwi, mwa wù ŋgamu gɛ̀ kɛme kwɛse, wu kwe bɛ kwɛɛ kɛme gɛ mwa gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mwa wù gɛ̀ bii wu le gɛɛ kwɛse wɛɛ, wu kwe tɛ mwa sɛŋ. ");
INSERT INTO ncr_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Wù gɛ̀ ka bii wu le, ka wu gɛɛ tɛ kwɛse wɛɛ, wu kwe tɛ mwa sɛŋ. Fi gɛ̀ kooshɛ noo bɛ booŋ ba bvusooshwi baa bachii, muh bo le baaŋ boo gɛ mwa bɛ kwɛse wɛɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ajiŋ ayu kwɛse wɛɛ kwe tɛ. ");
INSERT INTO ncr_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","No bamii ba bvusooshwi bayu gɛ̀ jo kwɛse wɛɛ bachii, lé gê doo nyûme sege bamii bude yi kwe le, wù nyu kwɛ yɛɛŋ?” ");
INSERT INTO ncr_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jiso chvuu bo le lɛ, “Yi kiŋkfuuŋ ki abɛŋ le, bilɛŋsɛ bɛ bikɛse le bo taashi bvuguu, bamii ka nyaa booŋ bamii taashi bvuguu bɛ bo. ");
INSERT INTO ncr_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Geenɛ, bamii ba le ba kojɛ ki bo kɛme kijusɛ yi woŋ wu too le sege bo kaasɛ bo bu yi kwe le, gɛ bo nyu bo ka bo taashi bvuguu gɛ, bamii baaŋ gɛ bo ka bo nyaa booŋ bo taashi bvuguu gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Gɛ bo baaŋ bo ka bo kweeyɛ gɛ, nje bo lé bo gê bo nyû wa njɛ banchɛndaa ba Nyo. Bo lé bo tô bo nyûme wa booŋ ba Nyo, nje bo lé bo kâasɛ wa bo bu yi kwe le. ");
INSERT INTO ncr_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nchiɛɛŋ wɛɛ le lɛ Musɛ kibɛɛ gɛ̀ yuusɛ wa bamii, no bo lé bo gê bo kâasɛ bo bu yi kwe le, no wu gɛ̀ saŋ wa kune kite ki mbiaŋ kì wu gɛ̀ yɛŋ ki bɛde. Wu tɛŋe Tada kijusɛ ki ŋwa kiyu le lɛ wu le Nyo wu Ablaham, bɛ Nyo wu Asik mo Nyo wu Yakob. ");
INSERT INTO ncr_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Wu nɛ tɛŋe noo, tu baŋkfu banɛ le bamii ba baaŋ yu, gɛ Nyo nyume Nyo wu baŋkfu gɛ, wu le Nyo wu bamii ba baaŋ yu, nje fɛ Nyo le, bamii bachii ba le fo le ba wuŋe.” ");
INSERT INTO ncr_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","No Jiso jɛmɛ noo, bamii ba gɛ̀ duunyi banchi ba Nyo, bo bɛɛŋsɛ wu bo jɛmɛ lɛ, “Muh wu N'yɛyɛ, wo le wo chvuu chuule.” ");
INSERT INTO ncr_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Gɛh noo, muh ka wu moŋ lo wu biih wu fiɛɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jiso mo wu ja wu biih fie bo le lɛ, “Bamii jiɛnyi nɛɛ fɛ bo tu bo duu lɛ, Mbvusɛ wù Nyo gɛ̀ ka le mwa Nfoŋ Dabi? ");
INSERT INTO ncr_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Gɛ bɛŋ kee lɛ Dabi kibɛɛ gɛ̀ bee wu saŋ a Ŋwa wu Yuusɛ le lɛ, ‘Tada Nyo gɛ̀ jɛmɛ Tada waŋ le lɛ, wu shii a kibo ke kinchiɛɛŋ le, ");
INSERT INTO ncr_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","gɛɛŋ bu sege nlé ŋgê ŋgiiŋsɛ bamii be ba kimbanɛ, wu tomɛ bikaa bie yi bo le, njɛ kitege ki bikaa.’ ");
INSERT INTO ncr_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nɛ Dabi tɛŋe wu lɛ Tada we, fi ka fi jiɛnyɛ nɛɛ fɛ wu tu wù nyu mwa ye?” ");
INSERT INTO ncr_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jiso mo wu ja wu tu wu jɛme wa nyu booŋ be ba ŋgoo le, bamii bachii yuge. Wu jɛmɛ bo le lɛ, ");
INSERT INTO ncr_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Bɛŋ yɛ̂ne kune bamii ba duunyi banchi ba Nyo. Bo koŋe ki bo nooŋ nyu bikuŋ bì ndefe bo jiɛnyi bɛ bi, bo koŋe lɛ bamii yɛ̂ɛse bo le manjuu ma ba kame chi waaŋ bɛ ŋgvunɛ. Bo koŋe ki bo shiide binta bì baaŋ baaŋ yéh yi buunɛ le. Sege bo lé bo gɛ̂ɛŋ fɛ ŋka le, bo koŋe ki bo shiide nyu fwe. ");
INSERT INTO ncr_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bo shiishi bakwɛŋkfu, bo lɛɛde bɛ bo, bo fii yéh bɛ mwɛɛ muboo, bo buuse bo bɛ chibuunɛ chì ndefe. Wuboo ŋgɛ lé wu gê wu yâ lo.” ");
INSERT INTO ncr_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jiso ja wu noŋ jise, wu yɛŋ no bamii ba kwa gɛɛde nnya yiboo a ŋku wu nnya le fɛ yeh yi kintanyɛ le. ");
INSERT INTO ncr_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Wu yɛŋ tɛ kwɛŋkfu wumu nyu muh wu kifufe, no wu gɛ̀ gɛlɛ munini munfɛɛ a ŋku wuyu le. ");
INSERT INTO ncr_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Wu mo wu jɛmɛ lɛ, “Nsɛŋe bɛŋ nchiɛɛŋ lɛ kwɛŋkfu wunɛ wu le muh kifufe nɛ, le wu nya wu fe bamii bachii ba be nya. ");
INSERT INTO ncr_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Bamii bachii ba be nyaa, be too nyu bɛ bimbɛge bi bvukugɛ bvuboo bvù gɛ̀ bee bvu yisɛ wa bvu tu bvu fuushi kuu. Geenɛ kwɛse wunɛ wu le kifufe kifufe nɛ le wu nya fiɛɛ fichii fi wu gɛɛde kikwɛɛ ke yu le.” ");
INSERT INTO ncr_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Booŋ ba Jiso ba ŋgoo bamu gɛ̀ ja bo kune kitada kune yeh yi kintanyɛ, bo bɛɛŋse ata a joŋe a ba gɛ̀ joone yu, bɛ mwɛɛ mù bamii gɛ̀ nyaa ki ba kɛnyi yu. Wu jɛmɛ bo le lɛ, ");
INSERT INTO ncr_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Bɛŋ yɛne mwɛɛ munɛ le? Juu too lo chì gɛ tɛdɛ chimimia nyu chi ge chi shɛɛ yi chimi le gɛ njɛ ba kɛsɛ fɛkuu sɛŋ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bo biih wu le lɛ, “Muh wu N'yɛyɛ, finɛ lé fi gê fi kôoshɛ sege la? Njiŋɛ wu lé wu gê wu dûnyɛ kife kì fi lé fi gê fì kôoshɛ le nyu la?” ");
INSERT INTO ncr_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jiso chvuu lɛ, “Bɛŋ yɛ̂ne keefɛ muh to wu lɛɛ bɛ bɛŋ, bɛŋ jiaa je gɛ. Bɛŋ kêe lɛ bamii lé bo gê bo tôo wesee, bo jode jee chaŋ bo tɛyi fɛ jii, muh mo wu duu lɛ, le mɛ wù le Mbvusɛ, kife too wa mbebe le. Bo doo bo gee noo, keefɛ bɛŋ yêge gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Sege bɛŋ yu ba tune jɛŋ manjuu le manjuu le, baŋgɛ nyu woŋ le, Keefɛ bɛŋ fâane gɛ. Mwɛɛ munɛ kɛme ki mu yâ mu kooshɛ. Geenɛ, gɛ fi duunyi lɛ woŋ lé wu kâ sege yu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jiso ka wu jɛmɛ bo le lɛ, “Kituŋ lé ki tûne jɛŋ bɛ kimi, nfoŋ wumu tune jɛŋ bɛ wumu. ");
INSERT INTO ncr_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Biŋgha bi mwɛɛ lé bi gê bi kôoshi manjuu le manjuu le. Nshɛŋ lé yi gê yi shîiŋshi bɛ bvuŋga. Jɛŋ lé yi gê yi kôode, binchɛŋ lé bi gê bi nyû manjuu le manchii. Banjiŋɛ ba kuufe ye lé bo gê bo dûunyi ye yi kibvulɛ le bo nyaa nfaaŋ bamii le. ");
INSERT INTO ncr_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Bɛŋ kêe lɛ mwɛɛ muyu fɛ mu ge mu kooshi, ba lé ba gê ba kôoyi bɛŋ ba nyiɛge bɛ bɛŋ. Ba lé ba gɛ̂ɛŋ bɛ bɛŋ, ba sa yéh yi buunɛ le, ba chiiŋsɛ bɛŋ yeh yi ncha le. Ba ka ba jo bɛŋ nje jee chaŋ ba gɛɛŋ bɛ bɛŋ fwe a ba nfoŋ bɛ bamii ba sage bimbe bi woŋ lɛ, ");
INSERT INTO ncr_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","sege kɛɛ mo nyume kife fɛ bɛŋ le kì bɛŋ jɛme kune mɛ bo le. ");
INSERT INTO ncr_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Sege ba koo bɛŋ noo, bɛŋ gɛɛ lɛ gɛ nyume bɛŋ buge laa bɛŋ lé bɛŋ gɛ̂ɛŋ bɛŋ tâanyi jwe lɛ la lɛ, ");
INSERT INTO ncr_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","nje nlé ŋgê nnyâ njɛme jwe wene le, mo bvufee bɛŋ le. Gɛ bamii bena ba kimbanɛ nyu bo lɛɛŋ ki bo tɛɛnyi bɛ bɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bamii ba lé bo gêsɛ bɛŋ lé nyû bachiji bena, bɛ ba bwe bena, mo booŋ ba bwee bena, mo kfuu chena bɛ nsáa yene. Lé nyâ gɛh bo bɛŋ fɛ ba yuuyɛ bɛŋ bamu. ");
INSERT INTO ncr_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Bamii bachii lé bo gê bo bânɛ bɛŋ, nje jee chaŋ. ");
INSERT INTO ncr_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Geenɛ, mo nyu yvu yimimia gɛ yi nyu yi lɛsɛ a bɛŋ fwa gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Bɛŋ kâaŋ shɛ́ŋ, bɛŋ lé bɛŋ gê bɛŋ kɛ̂me kinche. ");
INSERT INTO ncr_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Sege bɛŋ yɛŋ bamii ba jɛŋ tuŋ kiŋgaŋ bo kɛnɛ kinlaantɛŋ kì Yɛlusalɛm bo tasɛ, bɛŋ mo bɛŋ kɛɛ lɛ kife le ki kojɛ ka ki ba lé ba lɛ̂ɛshɛ ki. ");
INSERT INTO ncr_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Sege fi doo fi kooshɛ noo, bamii ba le Judia mo bo fɛɛ lo bo bɛɛŋ yi bambegɛ le, bo le a kilaantɛŋ kiyu le bu. Keefɛ muh wù le nchvuuŋ wu ka wu too ki wu lêe yo gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Aju kaa le, le wo a Nyo le wu noŋ ŋgɛ Yɛlusalɛm nje kiŋge kiboo, ki fi gê fi to fi kojɛ no ba gɛ̀ saŋ wa a Ŋwa wu Nyo le. ");
INSERT INTO ncr_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ŋgɛ wù baaŋ, yi aju kaa le, lé wu gê nyu wu bikɛse ba le bɛ chifwe, mo ba yaŋse booŋ. Nyo lé wu gê wu tôonyɛ shɛ́ŋ bɛ bamii banɛ, wu noŋ ŋgɛ wù baaŋ yi woŋ kfunɛ le. ");
INSERT INTO ncr_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ba lé ba gwôojɛ lo bamii bamu, ba kooyɛ bamu ba gajɛ bo gɛɛŋ bo nyu nfa yi bituŋ le bichii. Bamii ba kee gɛ Nyo gɛ lé bo gê bo yîgɛ lo Yɛlusalɛm, bo gɛɛŋ bo bu no kife kiboo le ki kojɛ. ");
INSERT INTO ncr_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Banjiŋɛ ba kuufe ye lé bo gê bo dûunyi ye yi juu le bɛ yi kwii le mo yi jóŋ le. Fi yi nshɛŋ le, le nyu lɛ bituŋ lé bi gê bi nyû yi maluŋ le, bi ŋgɛɛse no joo yì baaŋ lé gê yi kfûune yi yode. ");
INSERT INTO ncr_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nfaaŋ lé wu gê bamii gûde, bo shiŋshi nɛ kikikiki. Bo lé bo gê bo kwâji mwɛɛ mu kuufe ye mù lé mu ge mu kôoshi yi nshɛŋ le, mwɛɛ mù fɛwe munchii mù kɛme bvuŋga shiiŋshi. ");
INSERT INTO ncr_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Noo bamii mo bo yɛŋ no muh wù jee che le Mwamuh shiide wu too kimbɛ le wù kɛme bvuŋga mo bvukugɛ bvù baaŋ. ");
INSERT INTO ncr_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Sege mwɛɛ munɛ kɛ mu kooshi, bɛŋ lɛ̂ɛŋ we, bɛŋ kɛme bikwɛɛ we, nje kife kì Nyo le wu bvusɛ bɛŋ le wa a bo.” ");
INSERT INTO ncr_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","No Jiso jɛmɛ noo, wu mo wu be lɛ, “Bɛŋ yɛ̂yɛ fiɛɛ yi kiŋgvuŋ bɛ bite bimi bì kalɛ le. ");
INSERT INTO ncr_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bi kɛge ki bi chôone, bɛŋ mo bɛŋ kɛɛ lɛ akfuuŋ kusɛ wa. ");
INSERT INTO ncr_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Le gɛh yɛɛŋyɛɛŋ no bɛŋ ge doo bɛŋ yɛne mwɛɛ munɛ kooshi, bɛŋ mo bɛŋ kɛɛ lɛ bvunfoŋ bvu Nyo le wa a yeh fwɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nsɛŋe bɛŋ nchiɛɛŋ lɛ gɛ kiŋgogɛ ki mɛɛse kinɛ, nyu ki to ki ka njɛ mwɛɛ munɛ munchii jo kijusɛ sɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kibvulɛ bɛ nshɛŋ lé ki kâ, geenɛ gɛ jɛ yaŋ nyu yi to yi shiiŋshɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Bɛŋ yɛ̂ne keefɛ bɛŋ jîɛnyi bɛŋ jii nyu bikwɛɛ biɛna gɛ, bɛŋ muu bɛŋ jede gɛ! Keefɛ bɛŋ gɛ̂ɛde bvufee nyu yi kinche ki kiŋgaŋ le gɛ, juu chiyu lé chi gê chi jâ chi jâŋɛ chi kôo bɛŋ gɛ njɛ kintase. ");
INSERT INTO ncr_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Fiɛɛ fi yi juu chiyu chinɛ le, lé fi gê fi tô yi bamii le bachii ba le yi kikwɛɛ ki nshɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Bɛŋ mo bɛŋ lɛ̂me bɛŋ tɛɛme, bɛŋ bûune Nyo segechii, lɛ munɛ mwɛɛ ge doo mu kooshi, wu nya bɛŋ bɛ je yì bɛŋ lé bɛŋ wɛ̂ɛŋ bɛŋ fe yo fɛ bɛŋ lɛɛŋ fwe a muh wù jee che le Mwamuh.” ");
INSERT INTO ncr_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jiso mo wu shee wu yɛyi bamii yeh yi kintanyɛ le aju ayu le achii. Yi binfu le bichii, wu bɛɛne wu gɛɛne wu chee yi Mbegɛ wu Bite bi Olif le. ");
INSERT INTO ncr_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bamii bachii gɛ̀ bude bo gɛɛne fɛ yeh yi kintanyɛ le, bo yuge yɛyɛ we. ");
INSERT INTO ncr_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kife ki Ŋka wu Blɛd wù ba baaŋ kinshilɛ yo gɛɛ gɛ, wù ba tɛŋe lɛ Ŋka wu Ndaŋfe, gɛ̀ bee wu too wa mbebe le. ");
INSERT INTO ncr_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bachiji kintanyɛ ba baaŋ baaŋ bɛ bamii ba gɛ̀ duunyi banchi ba Nyo, bo gɛ̀ goone je yì bo yuuyɛ Jiso nyu nyilɛ le, nje bo gɛ̀ faane bamii. ");
INSERT INTO ncr_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sataŋ lee a fitele fì Juda wù ba gɛ̀ tɛŋe lɛ Ɛkaliot le, nyu muh wu ŋgoo yi booŋ ba Jiso ba yuufe ncho bafɛɛ. ");
INSERT INTO ncr_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Wu ja wu gɛɛŋ fɛ bachiji kintanyɛ ba baaŋ baaŋ le, bɛ bikwɛɛ bi nchi bì gɛ̀ chiɛɛne yeh yi kintanyɛ. Bɛ bo mo bo seesɛ no wu lé wu gê fɛ wu gêsɛ Jiso bo le. ");
INSERT INTO ncr_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bo yu njoŋ bo mo bo bɛɛŋ ki bo laŋɛ wu bɛ bige. ");
INSERT INTO ncr_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Wu bɛɛŋ, wu mo wu gɛɛŋ wu kɛ wu goone je yì wu lé wu nyâ Jiso chiaaŋ yiboo le, sege bamii ba duude ya fo gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Juu chi Ŋka wu Blɛd wù ba baaŋ Kinshilɛ yo gɛɛ gɛ, chi ba lé ba sɛ̂ɛ mwa kiya wu Ŋka wu Ndaŋfe wɛɛ gɛ̀ to chi kojɛ, ");
INSERT INTO ncr_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jiso mo wu tuŋ Bita bɛ Joŋ wu jɛmɛ lɛ, “Bɛŋ gɛ̂ɛŋ bɛŋ sêesɛ mwɛɛ mù bee lé be gê be jî Ŋka wunɛ yu.” ");
INSERT INTO ncr_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bo biih wu le lɛ, “Wo goone lɛ bee gɛɛŋ be seesɛ nyu faane?” ");
INSERT INTO ncr_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Wu chvuu bo le lɛ, “Bɛŋ yû, sege bɛŋ lese bɛŋ gɛɛne alaantɛŋ, bɛŋ lé bɛŋ yɛ̂ŋ muh mu le wu tuu joo a shaaŋ le, bɛŋ bî wu le, yeh yì wu gɛɛŋ wu lee yu. ");
INSERT INTO ncr_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Bɛŋ doo bɛŋ bi, bɛŋ jɛ̂mɛ chiji yeh yɛɛ le lɛ Muh wu N'yɛyɛ biide laa kibuu ki bamii ba njiɛnyɛ kɛɛ kì bɛ booŋ be ba ŋgoo le bo ji Ŋka wu Ndaŋfe yu le faane la? ");
INSERT INTO ncr_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wu mo wu dunyɛ kibuu ki yeh ki awe, ba nyu ba seesɛ wa ba kɛnyɛ, bɛŋ mo bɛŋ sêesɛ mwɛɛ munjile yu.” ");
INSERT INTO ncr_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Noo, bo gɛɛŋ bo yɛŋ mwɛɛ gɛh yɛɛŋyɛɛŋ no Jiso gɛ̀ jɛmɛ bo le. Bo mo bo seesɛ mwɛɛ munjile mu Ŋka wu Ndaŋfe wuyu fo. ");
INSERT INTO ncr_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Lɛ kife to ki kojɛ, Jiso bɛ booŋ be ba ntuŋ to bo shii bo jii mwɛɛ. ");
INSERT INTO ncr_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Wu ja wu jɛmɛ bo le lɛ, “Nchi ŋkoŋe lo baaŋ ki nji Ŋka wu Ndaŋfe wunɛ bɛ bɛŋ fɛ ŋge yɛŋ ŋgɛ wù too le. ");
INSERT INTO ncr_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Bɛŋ kêe lɛ gɛ mbaaŋ ŋka ŋge nji ŋka wunɛ gɛ, gɛɛne bude no fi lé fi gê fi tô fi kôjɛ sege Nyo lé wu gê wu sâge bvunfoŋ bwe.” ");
INSERT INTO ncr_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Wu jo fiŋkoo, wu nya kiyone Nyo le wu jɛmɛ lɛ, “Bɛŋ kô bɛŋ mù bɛŋ bachii bɛŋ kɛnɛ. ");
INSERT INTO ncr_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nsɛŋe bɛŋ le lɛ, kɛge mɛɛse gɛɛne, gɛ mbaaŋ ŋka mu mbvuuŋ ma nchwɛŋ wu kite ki laane manɛ gɛ, gɛɛne bude sege bvunfoŋ bvu Nyo lé bvu gê bvu tô” ");
INSERT INTO ncr_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Wu jo blɛd, wu nya kiyone Nyo le, wu bwɛɛyɛ wu nya bo le wu jɛmɛ lɛ, “Finɛ le ye yaŋ yi nnya nje bɛŋ. Bɛŋ gêe finɛ noo ki bɛŋ kwâji mɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Gɛh yɛɛŋyɛɛŋ no bo mɛɛse mwɛɛ munjile, wu jo fiŋkoo wu jɛmɛ lɛ, “Fiŋkoo finɛ le maŋkaŋ ma manfɛŋ ma Nyo gwo bɛ kilɛmɛ kaŋ ki bu nje bɛŋ. ");
INSERT INTO ncr_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Geenɛ, bɛŋ yêgɛ bɛŋ yû! Muh wù lé wu gêsɛ mɛ jii mwɛɛ fɛnɛ besa wu. ");
INSERT INTO ncr_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Bɛŋ kêe lɛ muh wù jee che le Mwamuh lé wu gɛ̂ɛŋ gɛh no Nyo gɛ̀ seesɛ. Geenɛ, ŋgɛ wù baaŋ le fɛ muh wù lé wu gêsɛ wu le.” ");
INSERT INTO ncr_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Bo mo bo kɛ bo biide ye yi biboo le laa muh wù taŋlo wu ge noo a bo ntɛnɛɛ le yɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Bo gɛ̀ ja bo kɛ kintɛɛnyɛ lɛbolɛbo laa bo le nɛ muh wù baaŋ a bo ntɛnɛɛ le yɛɛŋ? ");
INSERT INTO ncr_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jiso jɛmɛ bo le lɛ, “Banfoŋ ba bituŋ kɛme bvuŋga a bamii baboo we, bamii ba sage woŋ bo duu lɛ ba tɛ̂ŋe bo lɛ bitooŋ bi bamii. ");
INSERT INTO ncr_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Geenɛ, gɛ taŋlo fi nyûme noo bɛ bɛŋ gɛ. Muh wù baaŋ a bɛŋ ntɛnɛɛ jôde lɛ wu le mwa wù shige, muh wu le kikwɛɛ le njɛ muh wù lɛne bɛŋ le bachii. ");
INSERT INTO ncr_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Muh wù baaŋ le wù la, muh wù yɛmɛ wu jii lo nji le noo, muh wù dɛɛde le? Gɛ nyu muh wù yɛmɛ wu jii lo gɛ? Geenɛ nle a bɛŋ ntɛnɛɛ njɛ muh wù lɛne bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","No nshee n'yɛde baŋgɛ segechii, le gɛh bɛŋ banɛ ba to ba nyume besabɛŋ. ");
INSERT INTO ncr_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Fi mo fi nyu lɛ, gɛh yɛɛŋyɛɛŋ no Chii le wu nya mɛ bvunfoŋ lɛ nsâge, nnya tɛ bɛŋ bvuŋga lɛ bɛŋ sâge. ");
INSERT INTO ncr_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nnya wu lɛ besabɛŋ ge be jii mwɛɛ, be muu mwɛɛ kijusɛ kimimia a nto waŋ le, bɛŋ shiiyɛ yi bakala le, bɛŋ sage chikfuu chi Ishwala chi yuufe ncho chifɛɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jiso mo wu ja wu tɛɛŋ Bita lɛ, “Samoŋ, Samoŋ yegɛ yu wo kêe lɛ Sataŋ le wu fi bvuŋga ki wu chɛ̂gɛ bɛŋ bachii wu bvusɛ bamu gɛh njɛ no muh to wu fɛɛde agiŋ wu bvusɛ munyi. ");
INSERT INTO ncr_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Geenɛ nle mbuunɛ fɛ wo le, lɛ keefɛ fitele fiuŋ mo fi bu lo yi ye yaŋ le gɛ. Sege wo kaasɛ wo tɛɛŋ bvufee bwuŋ jiŋ, wo nya bvuŋga booŋ ba bwoo le.” ");
INSERT INTO ncr_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Bita du lɛ, “Tada, mo nyu ki ŋgɛɛŋ ncha, no nyu kɛnɛ ki ŋkwe lo, tu nle gɛh besa wo.” ");
INSERT INTO ncr_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jiso chvuu wu le lɛ, “Bita, yû nsɛŋe wo le, nyishii lé yi gê yi tôŋ abɛŋ, wo nyu wo faŋ wa mɛ kiŋgane kintɛde, lɛ gɛ wo kee mɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Wu ja wu biih bo le lɛ, “Bɛŋ kwaji kife kì ŋgɛ ntuŋ bɛŋ bige sɛŋ, kikɛɛ sɛŋ, jé sɛŋ, no bɛŋ gɛ̀ gɛnɛ bɛŋ jiɛnyi, bɛŋ gɛ̀ bee bɛŋ fu fiɛɛ?” Bo chvuu lɛ, “Ayɛɛ, bee gɛ̀ baaŋ fiɛɛ fu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Wu mo wu jɛmɛ bo le lɛ, “Yi mɛɛse le, muh nɛ kɛme bige, mo nyu kikɛɛ, wu jo. Muh nɛ kɛme gɛ nyo yi jɛŋ gɛ, wu gesɛ kikuŋ ke wu gu nyo yu. ");
INSERT INTO ncr_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Njɛme finɛ nje fiɛɛ fì ba gɛ̀ saŋ a Ŋwa wu Nyo le lɛ, ‘Ba gɛ̀ taŋ wu bɛ bamii ba befe’, fi kɛme ki fi kooshɛ bɛ mɛ mɛɛse. Bɛŋ kêe lɛ mwɛɛ mù ba gɛ̀ saŋ kune mɛ lé mu tôo wa ki mu kôjɛ munchii.” ");
INSERT INTO ncr_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bo mo bo jaŋɛ lɛ, “Tada, bîjɛ yɛ̂ŋ bee kɛme nyó yi jɛŋ yifiɛɛ.” Wu chvuu lɛ, “Bɛŋ lû noo!” ");
INSERT INTO ncr_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jiso gɛ̀ ja wu bu alaantɛŋ bɛ booŋ be ba ŋgoo, bo mo bo kɛ bo bɛɛne mbegɛ wu Bite bi Olif, nyu no wu to wù gee. ");
INSERT INTO ncr_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bo bɛɛŋ bo bu fɛ bo gɛ̀ gɛɛne fo, wu jɛmɛ bo le lɛ, “Bɛŋ bûune lɛ keefɛ moŋ to fɛ bɛŋ le, wu ya bɛŋ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","No wu jɛmɛ noo, wu mo wu kɛŋsɛ wu gɛɛŋ wu bu fɛ taŋlo muh noŋ tɛdɛ chi gɛɛŋ chi bu fo, wu mo wu ŋgvuumɛ fɛkuu wu buunɛ lɛ, ");
INSERT INTO ncr_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Chii, fi nɛ le fi kojɛ fɛ wo le, wo chiaasɛ fiŋkoo fi ŋgɛ finɛ lɛ keefɛ mmu gɛ. Geenɛ gêe gɛh no wo koŋe, keefɛ wo gê no ŋkoŋe gɛ.”  ");
INSERT INTO ncr_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","No wu buunɛ noo, nchɛndaa Nyo shii we wu to fɛ wu le, wu nya wu bvuŋga. ");
INSERT INTO ncr_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jiso nyu fitele fie suume wu baaŋ nɛ wɛɛmm wɛɛmm. Wu buunɛ lo chi shaŋ chiɛɛ, mbunyɛ chiɛɛnyi yi nshɛŋ le njɛ bitɛde bi kilɛmɛ. ");
INSERT INTO ncr_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Wu buunɛ wu mɛsɛ, wu tu jiŋ fɛ booŋ be ba ŋgoo le, wu yɛŋ lefɛ ge wa bo fwɛɛŋ bo tu bo lefe. ");
INSERT INTO ncr_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Wu biih bo le lɛ, “Bɛŋ ka lefe lo? Bɛŋ jâ we bɛŋ bûune fɛ moŋ ge wu to fɛ bɛŋ le, wu ya bɛŋ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Gɛh no wu gɛ̀ baaŋ wu jɛme, kinchvu ki bamii bunɛ bo tu bo too, nyume gɛh Juda wù gɛ̀ bee muh wu ŋgoo yi booŋ ba Jiso ba yuufe ncho bafɛɛ le, wu gɛ̀ too bo fwe. Wu to mbebe Jiso le wu ŋkfugɛ wu. ");
INSERT INTO ncr_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Geenɛ, Jiso biih Juda le lɛ, “Wo nɛ goone ki wo kfûgɛ Muh wù jee che le Mwamuh nɛ ki wo dûnyɛ lɛ ba koo wu?” ");
INSERT INTO ncr_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Booŋ be ba ŋgoo ba gɛ̀ bee mbebe ye le yɛŋ fiɛɛ fì gɛ̀ kooshi le, bo biih lɛ, “Tada, bee gwôojɛ bamii banɛ?” ");
INSERT INTO ncr_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Muh mu bo le gɛ̀ goone ki wu gwô, wu mo wu chuŋ nyu kintuŋ kinchiɛɛŋ ki fwa wu kikwɛɛ ki bachiji kintanyɛ. ");
INSERT INTO ncr_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jiso kaŋ lɛ, “Keefɛ muh ka wu môŋ gɛ!” Wu mo wu kuŋ kintuŋ ki muh wuyu le ki mo ki kâasɛ ki tu fo. ");
INSERT INTO ncr_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Bamii ba gɛ̀ too ki bo koo Jiso gɛ̀ bee bachiji kintanyɛ ba baaŋ baaŋ bɛ bikwɛɛ bi nchi bì gɛ̀ chiɛɛne yeh yi kintanyɛ mo bamii ba gɛ̀ sage woŋ. Wu biih bo le lɛ, “Bɛŋ to ki bɛŋ kôo mɛ, bɛŋ mo bɛŋ too bɛ nyó yi jɛŋ mo bimbuge njɛ bɛŋ too ki bɛŋ kôo nyume choŋ? ");
INSERT INTO ncr_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nchi nshee lɛ juu lɛ juu mo fɛ yeh yi kintanyɛ le, fɛ bɛŋ koo mɛ sɛŋ nje la? Geenɛ, mɛɛse le kife kena ki taŋlo bɛŋ ge fiɛɛ, nyume kife ki bvuŋga bvu ki kijibɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Bamii bayu mo bo koo Jiso bo gɛɛne bɛ wu fɛ la chi kikwɛɛ ki bachiji kintanyɛ le, Bita bii ajiŋ je yì ndefe le. ");
INSERT INTO ncr_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Bo gɛɛŋ bo fwɛɛ ŋgu lakfulɛ fɛ ntɛnɛɛ, lɛ bo shii bo yɛse. Bita mo wu to wu shii bɛ bo. ");
INSERT INTO ncr_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","No ŋgu kwɛɛ gɛ̀ bɛde noo, mwa wù kwɛse wumu wù gɛ̀ lɛne fɛ la chiyu le ja wu yɛŋ Bita le no wu shii. Wu bijɛ wu nɛ tuŋŋ wu jɛmɛ lɛ, “Muh wunɛ be bee bɛ muh wege.” ");
INSERT INTO ncr_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Bita mo wu kajɛ lo ye, wu jɛmɛ lɛ, “Kwɛse wunɛ, gɛ ŋkee wu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kife doo ki kɛŋsɛ gɛ nɛ shige, muh mu ka wu yɛŋ wu le, wu mo wu jɛmɛ lɛ, “Wo tɛ le muh ŋgoo yiboo le.” Geenɛ Bita jɛmɛ lɛ, “Jwɛŋsɛ, gɛ mɛ nyume muh mu a bo ntɛnɛɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kife gɛɛŋ ki bu njɛ ntaŋ wu kife kimimia, muh mu ka wu taŋ lɛ, “Nchiɛɛŋ, muh wunɛ be bee bɛ wu, nje wu le tɛ muh wu Galalee.” ");
INSERT INTO ncr_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Bita mo wu faŋ wu jɛmɛ lɛ, “Jwɛŋsɛ wunɛ, gɛ ŋkee fiɛɛ fì wo jɛme gɛ.” Gɛ no wu gɛh baaŋ wu jɛme, kimimia nyishii mo yi toŋ. ");
INSERT INTO ncr_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tada kaasɛ ye ajii a we tasɛ bɛ a Bita. Bita kwajɛ njɛmɛ wù Tada be jɛmɛ wu le lɛ, “Nyishii lé yi tôŋ abɛŋ, wo nyu wo faŋ wa mɛ kiŋgane kintɛde.” ");
INSERT INTO ncr_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Wu ja fo wu bu akfuuŋ, wu bee kwe baaŋ. ");
INSERT INTO ncr_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Bamii ba gɛ jiji Jiso le bo mo bo kɛ bo buu wu, bo suŋe wu, ");
INSERT INTO ncr_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","bo baŋe bvushi bwe bɛ nju, bo duu wu le lɛ, “Gɛ gee la muh wu ntuŋ wu Nyo kuŋ. Gɛh sɛɛŋ muh wu suŋ wo.” ");
INSERT INTO ncr_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bo ka bo baade lo wu bɛ bachuŋ wesee. ");
INSERT INTO ncr_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Akfuuŋ gɛ̀ doo a yuude a too, bamii ba sage woŋ bɛ bachiji kintanyɛ ba baaŋ baaŋ mo bamii ba duunyi banchi ba Nyo banyɛ ye bachii. No bo banyi noo, bo mo bo jo Jiso bo gɛɛŋ bɛ wu fɛ bo gɛ̀ sage bansa fo. ");
INSERT INTO ncr_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","No bo gɛnɛ bɛ wu noo, bo biih wu le lɛ, “Nɛ le wo wu le Mbvusɛ wù Nyo gɛ̀ ka, wo sɛ̂ɛŋ bee le?” Wu chvuu lɛ, “Nsɛŋe lo bɛŋ le, bɛŋ gɛ bɛɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Mbiide fiɛɛ bɛŋ le, bɛŋ gɛ chvuu gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Geenɛ, kɛge yi mɛɛse le, muh wù jee che le Mwamuh lé wu gê wu shîi a kibo kinchiɛɛŋ ki Nyo wu bvuŋga le.” ");
INSERT INTO ncr_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bo mo bo jaŋɛ bo bachii lɛ, “Fi nɛ le lɛ, le wo wu le Mwa Nyo?” Wu chvuu lɛ, “Fi le no bɛŋ jɛme.” ");
INSERT INTO ncr_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Bo mo bo jɛmɛ lɛ, “Taŋlo bo ka bo goone lo muh mu ki wu sɛ̂ɛŋ lɛ la? Bee le be yu wa fiɛɛ fì wu jɛme bɛ jwe we.” ");
INSERT INTO ncr_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","No ŋgoo yi bamii ba sage bansa jɛmɛ noo, bo mo bo ja bo bachii bo jo Jiso bo gɛɛne bɛ wu fɛ Balɛt le. ");
INSERT INTO ncr_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","No bo gɛnɛ bo bu fo, bo kɛ bo tu bo chuuyi mwɛɛ ye ye le, bo duu lɛ, “Muh wunɛ jiɛnyi wu chɛŋe bɛ woŋ wese, wu faŋe lɛ keefɛ bamii laaŋe ŋwa Kaisa wù Nfoŋ wu Lum le gɛ, wu ka jɛmɛ lɛ wu le Mbvusɛ wù Nyo gɛ̀ ka, fi duunyi lɛ wu le Nfoŋ wumu tɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Balɛt biih Jiso le lɛ, “Le wo wu le Nfoŋ Bajuu?” Jiso chvuu wu le lɛ, “Le no wo jɛme.” ");
INSERT INTO ncr_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Balɛt mo wu ja wu jɛmɛ bachiji kintanyɛ ba baaŋ baaŋ bɛ kinchvu ki bamii ki gɛ̀ bee fo le lɛ, “Mbaaŋ yɛŋ gɛ fiɛɛ fì muh wunɛ jiale le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Bo bachii tu bo nyiide gɛh lɛ, “Muh wunɛ jiɛnyi wu yɛyi bamii woŋ wu Judia le wuchii wu nyiise lɛ bo tɛɛme bikwɛɛ. Wu gɛ̀ kɛ Galalee, wu le wu to wa wu fɛsɛ mɛɛse a kinlaantɛŋ kinɛ le.” ");
INSERT INTO ncr_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","No Balɛt yu finɛ noo, wu mo wu biih wu le lɛ, “Muh wunɛ le muh wu Galalee?” ");
INSERT INTO ncr_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Bo bɛɛŋ, wu mo wu tuŋ Jiso fɛ Nfoŋ Hɛlod le, nje le wu wù gɛ̀ sage kimbe ki woŋ kwɛɛ le, wu gɛ̀ bee tɛ Yɛlusalɛm kife kiyu le. ");
INSERT INTO ncr_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Bo gɛɛŋ bɛ Jiso, Nfoŋ Hɛlod yɛŋ wu le wu yu njoŋ baaŋ, nje wu gɛ̀ shee wu yuge kune wu, wù kɛme kiŋkoŋɛ ki wu yɛ̂ŋ wu le, wu jiiŋe tɛ lɛ segemu Jiso lé wu gê fiɛɛ fì duunyi bvuŋga bvu Nyo wu yɛŋ. ");
INSERT INTO ncr_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Wu she wu biih mwɛɛ Jiso le wesee, geenɛ wu gɛ chvuu fiɛɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Wu gɛ̀ biide bachiji kintanyɛ ba baaŋ baaŋ bɛ bamii ba gɛ̀ duunyi banchi ba Nyo lɛme tɛ fo bo chuunyi mwɛɛ mù tɛɛme ye yi Jiso le. ");
INSERT INTO ncr_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Nfoŋ Hɛlod bɛ bamii be banchi ja bo mo bo kɛ bo keede wu, bo sɛɛse wu, bo susɛ wu bɛ njú yi woŋ, bo chwɛɛsɛ wu bo chvuu wu tu jiŋ fɛ Balɛt le. ");
INSERT INTO ncr_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Gɛ̀ bee Balɛt bɛ Nfoŋ Hɛlod banɛ. Abvubwɛɛ, bo tu nsaŋ. ");
INSERT INTO ncr_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","No bo chvuse Jiso jiŋ, Balɛt kuŋ bachiji kintanyɛ ba baaŋ baaŋ mo bamii ba gɛ̀ sage woŋ, wu ka wu kuŋ bamii bachii. ");
INSERT INTO ncr_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Bo taashɛ, wu du bo le lɛ, “Bɛŋ be too bɛ muh wunɛ fɛnɛ lɛ wù gee bamii tɛɛme bikwɛɛ, ndoo ntaa mwɛɛ mu bɛŋ nyiide bɛ mu a bɛŋ jii, bɛŋ yêgɛ bɛŋ yû, mbaaŋ yɛŋ gɛ mwɛɛ mù bɛŋ chuunyi ye ye le lɛ wu le wu ge fiɛɛ fimi gɛ, ");
INSERT INTO ncr_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nfoŋ Hɛlod tɛ be baaŋ yɛŋ gɛ. Le fiɛɛ fì be ge fɛ wu kaasɛ wu chvuu muh wunɛ jiŋ besabɛŋ le. Bɛŋ yɛŋ tɛ lɛ muh wunɛ baaŋ jiaa gɛ fiɛɛ fì taŋlo ba yuuyɛ lo wu gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Noo, nlé ntâaŋ gɛh lo wu, nchînɛ wu le, wu gɛ̂ɛne.” ");
INSERT INTO ncr_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","To nyume kife ki Ŋka wu Ndaŋfe wunɛ, tu Balɛt kɛme ki wu bvûsɛ muh wu mumwaa yeh yi cha le wu nya bamii le. ");
INSERT INTO ncr_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Bamii bachii mo bo ja bo kɛ bo wanɛ lo bo gɛɛne yu lɛ, “Wo lɛ̂ɛshɛ lo muh wunɛ, wo bvûse Balaba yeh yi cha le wo nyâ bee le!” ");
INSERT INTO ncr_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balaba wunɛ gɛ̀ bee yeh yi cha le nje wu gɛ̀ kɛ ŋgɛ alaantɛŋ wu yu muh. ");
INSERT INTO ncr_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Balɛt yu noo wu ka wu jɛmɛ bamii bachii le nje wu gɛ̀ goone ki wu chînɛ Jiso le. ");
INSERT INTO ncr_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Geenɛ, bo tu bo wanɛ gɛh lɛ, “Ba tâ lo wu yi kintaaŋ le, ba tâ lo wu yi kintaaŋ le!” ");
INSERT INTO ncr_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Balɛt ka wu jɛmɛ bamii le kiŋgane kintɛde lɛ, “Ba tâ wu nje la? Fiɛɛ fì befe fi wu ge le la? Mbaaŋ n'yɛŋ gɛ jialɛ chì wu ge le, ki ba yuuyɛ lo wu gɛ. Nlé ntaaŋ lo wu, nchinɛ wu le.” ");
INSERT INTO ncr_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Bo mo bo mɛ gɛh bo wanɛ lo bɛ bvuŋga lɛ, “Ba tâ lo wu yi kintaaŋ le.” Ŋ'waŋ wuboo ya Balɛt. ");
INSERT INTO ncr_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Noo, Balɛt suunɛ nsa wu chinɛ wu le, lɛ bo ge bɛ wu no bo koŋe. ");
INSERT INTO ncr_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Wu mo wu bvusɛ muh wɛɛ yeh yi ncha le, nyu wu wù bo gɛ̀ biide, wù gɛ̀ kɛ ŋgɛ alaantɛŋ wu ka wu yuuyɛ muh. No wu bvuse, wu mo wu nya Jiso no bo gɛ̀ goone. ");
INSERT INTO ncr_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Bo mo bo jo Jiso bo gɛɛne bɛ wu. No bo gɛɛne, bo tasɛ bɛ muh mu wu kwɛɛde nchvuuŋ, jee che nyu lɛ Samoŋ, nyu muh wu Sɛliŋ. Bo tooŋsɛ wu bo mo bo gɛɛ kintaaŋ ki Jiso fɛ wu gbwe, wu mo wu tuu wu bii Jiso le. ");
INSERT INTO ncr_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bɛ bo mo bo gɛɛne, kinchvu ki bamii ki duude bii bo le. Bamu nyu bikɛse bo gɛ̀ beede, bo taanyi baŋgɛ be. ");
INSERT INTO ncr_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jiso ja wu kaasɛ ye wu jɛmɛ bo le lɛ, “Bikɛse ba Yɛlusalɛm, keefɛ bɛŋ bêede fɛ mɛne gɛ. Bɛŋ bêede nyu fɛ bikwɛɛ biɛna le, mo fɛ booŋ bena le. ");
INSERT INTO ncr_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Bɛŋ kêe lɛ kife too lo kì ba lé ba gê ba jɛ̂me lɛ, njoŋ wù baaŋ le wù bikɛse ba le kaa bo baaŋ mwa boo gɛ, bo gɛ baaŋ mwa a yaŋse gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Lé gê nyû kife kiyu le, bamii wanɛ lɛ bambegɛ ba baaŋ baaŋ le lɛ, ‘Bɛŋ gwêeyɛ ye yese le’, bo wanɛ bambegɛ ba shige shige le lɛ, ‘Bɛŋ bâŋɛ bee’. ");
INSERT INTO ncr_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Bo lé bo gê bo wânɛ noo nje bamii gee kfuu chi finɛ fiɛɛ bɛ kite kì baaŋ ki jiɛɛ, bo ge nɛɛ bɛ kì le ki yunɛ ka.” ");
INSERT INTO ncr_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","No bo gɛ̀ gɛɛne bɛ Jiso noo, bo gɛ̀ kɛme bamii bancha bafɛɛ ba bɛ bo gɛ̀ gɛɛne ki bo yuuyɛ bo tɛ. ");
INSERT INTO ncr_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Bo gɛɛŋ bo bu kijusɛ kimu ki ba tɛŋe lɛ Ŋgboge wu Kikwɛɛ, bo mo bo ta Jiso yi kintaaŋ le, bo ta tɛ bamii bancha bafɛɛ baa yi bintaaŋ le, wu mumwaa a kibo ki Jiso kinchiɛɛŋ le, wumu a kibo kiŋkoŋo le. ");
INSERT INTO ncr_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jiso ja wu jɛmɛ lɛ, “Chii, lɛ̂ɛshɛ bimbefɛ bi bamii banɛ, nje gɛ bo kee fiɛɛ fì bo gee gɛ.” Bamii bayu jo njú yi Jiso bo tuŋ kaŋ yu ki bo ga bikwɛɛ biboo le. ");
INSERT INTO ncr_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mwɛɛ munɛ munchii gɛ̀ kooshi bɛ Jiso noo, bamii lɛme fo bo jiiŋe. Bamii ba gɛ̀ sage woŋ ka bo ja fiboo bo buu lo wu bo duu lɛ, “Wu chi fii bamii bamu, wu fi lɛ kikwɛɛ ke mɛɛse, wu nɛ le Mbvusɛ wù Nyo gɛ̀ ka, wu cha.” ");
INSERT INTO ncr_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Bamii ba nchi tɛ tu bo chwɛɛse wu, bo nya wu mbvuuŋ ma ŋgbwamɛ, ");
INSERT INTO ncr_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","bo jɛmɛ lɛ, “Wo fɛnɛ le Nfoŋ wu Bajuu, fîh kikwɛɛ kuŋ.” ");
INSERT INTO ncr_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Bo saŋ ŋwa bo ta a kikwɛɛ ki Jiso we lɛ, “Wunɛ le Nfoŋ wu Bajuu.” ");
INSERT INTO ncr_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Muh wu ncha wumu wù bɛ bo gɛ̀ shɛnɛ yi bintaaŋ le fo, wu ja wu tu wu naanyi Jiso, wu duu lɛ, “Le gɛh wo wù Mbvusɛ wù Nyo gɛ̀ ka? Fîh kikwɛɛ kuŋ, wo fîh tɛ bee.” ");
INSERT INTO ncr_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Muh mu wɛɛ yu fiɛɛ fì wu jɛme, wu wamɛ wu bii lɛ, “Gɛ wo faane Nyo gɛ? Wo le yi ŋgɛ le yɛɛŋ nje no wu le. ");
INSERT INTO ncr_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Besa wo kwee nchiɛɛŋ nchiɛɛŋ nyu nlaŋe wu mwɛɛ mù mbefe mu besa wo ge le, geenɛ muh wunɛ kwe fie wu baaŋ jiaa gɛ fiɛɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Muh ncha wunɛ mo wu jɛmɛ lɛ, “Jiso, wo ge wo tâne mɛ sege wo lé wo sâge bvunfoŋ bwuŋ.” ");
INSERT INTO ncr_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jiso jɛmɛ wu le lɛ, “Nsɛŋe wo nchiɛɛŋ lɛ abɛŋ le nyu besa wo kijusɛ ki njoŋ ki Nyo le.” ");
INSERT INTO ncr_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Juu gɛ̀ bɛɛŋ chi leesɛ, akfuuŋ ja ajiiŋ, woŋ wuchii gɛɛne bude juu bikaa bitɛde fɛnshɛ, ");
INSERT INTO ncr_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Nju yì gɛ̀ gade yeh yi kintanyɛ yi mo yi suunɛ antɛnɛɛ yi tu bimbe bifɛɛ. ");
INSERT INTO ncr_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jiso gɛ̀ bee yi kintaaŋ le, wu ja wu waŋ fɛwɛɛwe lɛ, “Chii, nnyaa kiyo kaŋ chiaaŋ yo le.” No wu jɛmɛ noo, wu mo wu yɛnɛ n'yɛnɛ wu kimaga. ");
INSERT INTO ncr_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Chiji kikwɛɛ ki bamii ba nchi wù gɛ̀ lɛme fo, wu doo wu yɛŋ fiɛɛ fì kooshi le, wu nya mbɛɛŋsɛ Nyo le wu jɛmɛ lɛ, “Nchiɛɛŋ nchiɛɛŋ, muh wunɛ chi bee gɛ bɛ jialɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Bamii bachii ba gɛ̀ taashɛ fo ki bo yɛŋ fiɛɛ fì kooshi le, bo yɛŋ noo bo mo bo ja bo kaase bo kwɛɛde ala aboo le, bo soge bikwɛɛ. ");
INSERT INTO ncr_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Nsáa yi Jiso yichii gɛ̀ to fiboo yi lɛɛŋ nyu je yì ndefe le bo tu bo yɛde fiɛɛ fì kooshi le. Bamu gɛ̀ bee bikɛse ba gɛ̀ ja Galalee bo bi wu le. ");
INSERT INTO ncr_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Muh mu gɛ̀ bee kife kiyu le ba tɛŋe lɛ Yosɛf, gɛ̀ bee muh wu a kinlaantɛŋ ki Bajuu kimi kì ba gɛ̀ tɛŋe lɛ Alimatia. Wu gɛ̀ bee muh wù joŋe, ka nyume muh wù chaaŋ a Nyo jii, wu chiɛɛne tɛ kife kì Nyo lé wu gê wu tô wu sâge bvunfoŋ bwe. Wu gɛ̀ bee tɛ muh wu ŋgoo yi bamii ba gɛ̀ sage bansa le. Geenɛ, wu gɛ̀ baaŋ bɛɛŋ gɛ fie fiɛɛ fì bo gɛ̀ seesɛ ki bo ge bɛ Jiso gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Wu gɛɛŋ fɛ Balɛt le, wu lɛgɛ ki wu gɛ̂ɛŋ wu jo gvunɛ chi Jiso. ");
INSERT INTO ncr_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Balɛt bɛɛŋ, wu mo wu gɛɛŋ wu shiishɛ gvunɛ chiyu, wu baŋɛ a nju le wu tuu, wu gɛɛŋ wu giŋsɛ a jɛŋ yi ba gɛ̀ cho yi kimbaaŋ le, ba baaŋ muh yo a jiiyɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Gɛ̀ bee Juu chi nseesɛ ki bo lee juu chi yuuŋ le, shɛge wa shige yuuŋ chiyu kɛ. ");
INSERT INTO ncr_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Bikɛse baa ba gɛ̀ ja Galalee bo bi Jiso le, bo bi Yosɛf le fɛ jɛŋ, ki bo gɛɛŋ bo yɛŋ no wu giŋse gvunɛ chi Jiso a jɛŋ. ");
INSERT INTO ncr_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bo gɛ̀ ja fo, bo mo bo tuu jiŋ ala aboo le, bo gɛɛŋ bo seesɛ mɛɛ mà joŋe mà yefɛ mà gwee wuŋ mà bo gɛ̀ yeefe agvuuŋ yu. Gɛ̀ bee juu chi yuuŋ, bo she yuuŋ no nchi wuboo gɛ̀ goone. ");
INSERT INTO ncr_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Juu chi yuuŋ gɛ̀ fe, bvuyuu juu chì fwe yi kimaa le. Bikɛse baa bu bo yaŋsɛ lo an'yule, bo jo mɛɛ mà gwee wuŋ mà bo gɛ̀ seesɛ bo mo bo gɛɛne bɛ mo fɛ jɛŋ. ");
INSERT INTO ncr_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Lɛ bo doo bo gɛɛŋ bo bu fo, bo yɛŋ ba biŋsɛ wa tɛdɛ chì ba gɛ̀ baŋɛ jwe wu jɛŋ yɛɛ yu. ");
INSERT INTO ncr_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Lɛ bo lee bo gɛɛŋ a jɛŋ bo gɛ yɛŋ gvunɛ chi Tada Jiso le gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bo gɛ̀ lɛɛŋ fo bo ŋgɛsɛ lo. Fi kooshɛ lɛ bilɛŋsɛ bafɛɛ gɛ̀ bee bo ja bo to bo lɛɛŋ mbebe yiboo le, bo noŋ njú yì baaŋ yi lale. ");
INSERT INTO ncr_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bikɛse baa gɛ̀ faaŋ baaŋ, bo mo bo tuŋ bikwɛɛ fɛkuu. Bilɛŋsɛ baa biih bo le lɛ, “Le nje la wù bɛŋ goone muh wù baaŋ yu antɛnɛɛ a baŋkfu? ");
INSERT INTO ncr_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Gɛ wu nyu fɛnɛ gɛ, wu le wu bu wa yi kwe le. Bɛŋ kwâjɛ fiɛɛ fì wu gɛ̀ jɛmɛ bɛŋ le sege bena bo gɛ̀ bee Galalee. ");
INSERT INTO ncr_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Wu gɛ̀ bee wu jɛmɛ lɛ, ‘Muh wù jee che le Mwamuh lé ba kɛ̂me ki ba nyâ wu chiaaŋ yi bamii ba befe le, ba ge ba ta wu yi kintaaŋ le, doo bu aju atade, wu bu yi kwe le.’” ");
INSERT INTO ncr_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Bo mo bo kwajɛ fiɛɛ fì Jiso gɛ̀ jɛmɛ bo le. ");
INSERT INTO ncr_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Bo gɛ̀ ja fɛ jɛŋ, bo kaasɛ bo tu jiŋ bo gɛɛŋ bo sɛɛŋ mwɛɛ munɛ munchii booŋ be ba ŋgoo ba yuufe ncho wu mumwaa le mo bamii bachii ba gɛ̀ bii wu le. ");
INSERT INTO ncr_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Bikɛse ba gɛ̀ sɛŋe fiɛɛ fì gɛ̀ kooshɛ fiyu booŋ ba ntuŋ ba Jiso le gɛ̀ bee Mɛɛle Madaleŋ, Joana mo Mɛɛle wu bwe Jɛm bɛ bikɛse bamu. ");
INSERT INTO ncr_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Bo yu njɛmɛ wuyu gɛh njɛ le njɛmɛ wu achiji, bo gɛ bɛɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Geenɛ, Bita ja we, wu legɛ wu gɛɛŋ wu bu fɛ jɛŋ, wu ŋgvuumɛ wu bijɛ a jɛŋ wu yɛŋ gɛh nyu njú yì ba gɛ̀ giŋsɛ Jiso yu le. Wu mo wu ja wu tuu jiŋ fɛ yeh le wù kɛme kiŋgha yi fiɛɛ fì kooshi le. ");
INSERT INTO ncr_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Fi gɛ̀ kooshɛ gɛh abvu lɛ, bamii bamu bafɛɛ bo gɛ̀ bii Jiso le bo gɛ̀ ja Yɛlusalɛm bo gɛɛne ntɛ wù ba tɛŋe lɛ Imayu le, gɛ̀ bee njɛ bama bvusooshwi ki wo gɛ̂ɛŋ wo bu yo. ");
INSERT INTO ncr_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bo tu bo gɛɛne bo jɛme lɛbolɛbo kune mwɛɛ mù gɛ̀ kooshɛ munchii. ");
INSERT INTO ncr_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","No bo gɛ̀ jiɛnyi bo jɛme bo tuu fo noo, Jiso gɛ̀ bee wu kɛŋsɛ wu to mbebe yiboo le wu tu wu jiɛnyi bɛ bo. ");
INSERT INTO ncr_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Fiɛɛ fimi ge lɛ keefɛ bo kɛ̂ɛ muh wuyu gɛ. ");
INSERT INTO ncr_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jiso mo wu ja wu biih bo le lɛ, “Le fiɛɛ fì la fì bɛŋ jiɛnyi bɛŋ jɛme kune fi?” No wu biide noo, bo lɛɛmɛ bɛ yii yi manshi maboo le. ");
INSERT INTO ncr_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Muh lɛ bo le wu jee che gɛ̀ bee lɛ Kleofa wu biih wu le lɛ, “Mɛ gɛh wo maa wu le ntolo Yɛlusalɛm wù baaŋ kɛɛ gɛ mwɛɛ mu chi kooshɛ yo aju kane le gɛ?” ");
INSERT INTO ncr_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Wu biih lɛ, “Mwɛɛ mù la?” Bo chvuu lɛ, “Mwɛɛ mù chi kooshɛ bɛ Jiso wu Nasalɛ. Muh wunɛ chi bee muh wu ntuŋ wu Nyo. Mwɛɛ mù wu chi gee mo mù wu chi jɛme chi bee mù ghage. Chi bee muh wù kuge baaŋ a Nyo fwe bɛ bamii bachii. ");
INSERT INTO ncr_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Bachiji kintanyɛ ba baaŋ baaŋ bɛ bamii ba sage woŋ wese chi bo nya wu lɛ ba yuuyɛ. Bo chi bo mo bo ta wu yi kintaaŋ le. ");
INSERT INTO ncr_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Bee chi be gɛɛ wa bvufee yi ye ye le, lɛ le wu wù lé wu gê wu sûuŋ bamii ba Ishwala chiaaŋ yi ŋgɛ le. Geenɛ le ge wa aju atade no mwɛɛ muyu chi kooshɛ. ");
INSERT INTO ncr_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Fimi nyu bikɛse bamu ŋgoo yese le, bo be bo jɛmɛ fi fuuŋsɛ lo bee, lɛ bo le bo bu bo gɛɛŋ fɛ jɛŋ ataana, ");
INSERT INTO ncr_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","bo baaŋ yɛŋ gɛ gvunɛ che le gɛ. Bo doo bo kaase bo tuu jiŋ, bo sɛɛŋ lɛ bo bee bo yɛŋ banchɛndaa ba Nyo le njɛ bo yɛŋ a kifilɛ le, bo jɛmɛ bo le lɛ Jiso le yu. ");
INSERT INTO ncr_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bamii bamu ŋgoo yese le, le bo gɛɛŋ fɛ jɛŋ fɛ yu bo yɛŋ yi le gɛh yɛɛŋyɛɛŋ no bikɛse bayu be jɛmɛ, geenɛ, bo baaŋ yɛŋ gɛ Jiso le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jiso jɛmɛ bo le lɛ, “O oo, biyuŋ binɛ, muntele mwɛna jiɛɛ baaŋ ki bɛŋ bɛ̂ɛŋ mwɛɛ mù bamii ba ntuŋ wu Nyo gɛ̀ jɛme. ");
INSERT INTO ncr_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Gɛ bɛŋ kee lɛ Mbvusɛ wù Nyo gɛ̀ ka gɛ̀ kɛme ki wu yɛ̂ŋ baŋgɛ fɛ wu lee yi bvukugɛ bwe le gɛ?” ");
INSERT INTO ncr_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jiso mo wu kɛ wu naji bo mwɛɛ munchii mù ba gɛ̀ saŋ a Ŋwa wu Nyo le kune wu kɛge yi mù Musɛ gɛ̀ saŋ le, gɛɛŋ bu tɛ yi mu bamii ba ntuŋ wu Nyo le. ");
INSERT INTO ncr_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","No bo gɛ̀ too wa bo bude mbebe ntɛ wu bo gɛ̀ gɛɛne yo le, Jiso ja wu tu wù gee njɛ wu fede lo. ");
INSERT INTO ncr_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Bo lɛgɛ wu wesee bo jɛmɛ lɛ, “Bee gɛ̂ɛŋ be chê, kife le ki gɛɛŋ ka baaŋ, akfuuŋ kɛ wa a jimɛ.” Noo, wu bɛɛŋ ki wu gɛ̂ɛŋ wu che bɛ bo. ");
INSERT INTO ncr_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Bo gɛɛŋ, bo doo bo jii mwɛɛ, wu jo chefe yi blɛd, wu nya kiyone Nyo le, wu bwɛɛyɛ wu nya bo le. ");
INSERT INTO ncr_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kimimia noo, ajii aboo yuu, bo mo bo kɛɛ wu. Wu jaŋɛ wu lɛsɛ a bo jii. ");
INSERT INTO ncr_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bo shɛɛ bo tu bo maŋe lɛbolɛbo lɛ, “Gɛ muntele mwesa besa wo be yuufe sege wu be jɛme besa wo le a je, wu naji mwɛɛ mu a Ŋwa wu Nyo le gɛ?” ");
INSERT INTO ncr_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bo mo bo ja kimimia kinfu kɛɛ le juu chi yu bo mo bo tuu jiŋ Yɛlusalɛm. Bo doo bo gɛɛŋ, bo yɛŋ booŋ ba Jiso ba ŋgoo ba yuufe ncho wu mumwaa le bo banyɛ ye kijusɛ ki mumwaa bɛ bamii bamu bo gɛ̀ kɛ bo bii wu le. ");
INSERT INTO ncr_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Bo jɛme lɛ, “Nchiɛɛŋ nchiɛɛŋ, Tada wese le wu bu yi kwe le. Wu bee wu jagɛ wu bunɛ a Samoŋ jii.” ");
INSERT INTO ncr_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Bo mo bo sɛɛŋ tɛ bo fiɛɛ fì be kooshɛ bɛ bo a je, bo mo bo najɛ tɛ no bo be kɛlɛ lɛ le wu, sege wu be bwɛɛyɛ blɛd. ");
INSERT INTO ncr_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Gɛh no bo gɛ̀ baaŋ bo jɛme noo, Jiso jagɛ wu bunɛ a bo antɛnɛɛ wu mo wu yɛsɛ bo le lɛ, “Kimbonɛ nyûme fɛ bɛŋ le.” ");
INSERT INTO ncr_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Njaŋ koo bo, bo tu bo faane, bo kwaji lɛ bo le bo yɛŋ nyu kiyi kimi le. ");
INSERT INTO ncr_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Wu biih bo le lɛ, “Bɛŋ faane la? Ge la fɛ bɛŋ maŋɛ mɛ? ");
INSERT INTO ncr_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Bɛŋ jîŋɛ bɛŋ yɛ̂ŋ chiaaŋ yaŋ bɛ bikaa biaŋ, bɛŋ mo bɛŋ kɛɛ lɛ le mɛ kibɛɛ. Bɛŋ monyɛ ye yaŋ bɛŋ mo bɛŋ kɛɛ, nje gɛ kiyi to ki kɛme nyaŋ yi ye bɛ biŋkufɛ no bɛŋ yɛde ŋkɛme nɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","No wu jɛme noo, wu mo wu dunyɛ chiaaŋ ye bɛ bikaa bie bo le. ");
INSERT INTO ncr_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Bo bijɛ Jiso, njoŋ yuuyɛ lo bo, bo mo bo ŋgɛsɛ lo. Fi ya bo ki bo bɛɛŋ lɛ le wu. Wu ja wu biih bo le lɛ, “Bɛŋ kɛme fiɛɛ fijile fɛnɛ?” ");
INSERT INTO ncr_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bo jo kinchiŋ ki biɛŋ yi ba yoŋ wa, bo nya wu le. ");
INSERT INTO ncr_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Wu fi wu ji a bo jii. ");
INSERT INTO ncr_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Wu mo wu jɛmɛ bo le lɛ, “Mwɛɛ munɛ mu bɛŋ yɛŋ abɛŋ le mu mù ŋgɛ̀ njɛme bɛŋ le kune mu mbaaŋ besabɛŋ. Ŋgɛ̀ ndu lɛ mwɛɛ munchii mù ba gɛ̀ saŋ kune mɛ a Ŋwa wu Musɛ le, bɛ a Baŋwa ba bamii ba ntuŋ wu Nyo le mo a Ŋwa wu Mbɛɛŋsɛ le, mu kɛme ki mu tô mu kojɛ.” ");
INSERT INTO ncr_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Wu mo wu gwenyɛ bvufee bvuboo, bo kɛɛ mwɛɛ mu le a Ŋwa wu Nyo le. ");
INSERT INTO ncr_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Wu jɛmɛ lɛ, “Ba le ba saŋ lɛ Mbvusɛ wù Nyo gɛ̀ ka kɛme ki wu yɛ̂ŋ ŋgɛ wu kwe, doo ge aju atade, wu bu yi kwe le. ");
INSERT INTO ncr_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Fi mo fi nyu tɛ lɛ bo lé bo kɛ̂ Yɛlusalɛm, bo fêeji bituŋ le bichii kune jee che lɛ bamii bachii kusɛ muntele muboo, fɛ Nyo lɛɛshɛ bimbefɛ biboo. ");
INSERT INTO ncr_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Lé ge fêeji bɛŋ banɛ ba yɛŋ mwɛɛ munɛ le. ");
INSERT INTO ncr_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Bɛŋ yêgɛ bɛŋ yû, nlé ŋgê nchîiŋsɛ nnya yì Chii gɛ̀ ka wa bɛŋ yu. Noo, bɛŋ mɛ gɛh alaantɛŋ yanɛ bɛŋ chîɛɛne bvuŋga bvù lé bvu gê bvu shîi fɛwe bvu tô fɛ bɛŋ le.” ");
INSERT INTO ncr_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Wu jo bo wu bu bɛ bo a kinlaantɛŋ kiyu le, bɛ bo gɛɛŋ bo bu mbebe ntɛ wù Bɛtani le, wu chiaasɛ chiaaŋ ye we, wu noŋ kimbonɛ ye yiboo le. ");
INSERT INTO ncr_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Gɛ no wu gɛ̀ baaŋ wu nooŋ kimbonɛ ye yiboo le noo, wu mo wu ja wu tu wu bɛɛne we, wu mo wu bɛɛŋ wu lɛsɛ. ");
INSERT INTO ncr_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bo nya mbɛɛŋsɛ wù baaŋ wu le, bo mo bo ja fo bo tuu jiŋ Yɛlusalɛm bɛ kinlaŋye fɛ muntele muboo le. ");
INSERT INTO ncr_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bo gɛɛŋ bo mo bo shee yeh yi kintanyɛ le, bo bɛɛŋse Nyo bo yuuse wu segechii.");
INSERT INTO ncr_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Gɛ̀ bee fɛŋkɛɛ Jɛ nyu wa yu. Jɛ yiyu gɛ̀ bee bɛ Nyo, Jɛ yiyu nyume Nyo. ");
INSERT INTO ncr_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Wu gɛ̀ bee wa fɛŋkɛɛ bɛ Nyo. ");
INSERT INTO ncr_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nyo gɛ̀ fɛ mwɛɛ munchii fede chiaaŋ ye le. Gɛ fiɛɛ nyu yu fimimia fì Nyo gɛ̀ fɛ njɛ wu le fo sɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Wu kɛme kinche yi ye ye le, kinche kiyu le n'yulɛ fɛ bamii le. ");
INSERT INTO ncr_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","N'yulɛ wɛɛ baaŋ kijibɛ le, gɛ kijibɛ kiyu taŋlo ki jiŋsɛ wu gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Muh mu le yu wù Nyo gɛ̀ tuŋ jee che nyu lɛ Joŋ. ");
INSERT INTO ncr_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Wu gɛ̀ to ki wu jɛ̂me kune n'yulɛ, wu bɛɛyi jiŋ yi nsa we, ki wu gê bamii bachii lee muntele yi n'yuu wɛɛ le. ");
INSERT INTO ncr_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Gɛ wu wù Joŋ gɛ̀ bee n'yulɛ wɛɛ gɛ. Wu gɛ̀ to ki wu bɛ̂ɛyɛ nyu jiŋ yi nsa wu n'yulɛ wɛɛ. ");
INSERT INTO ncr_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","N'yulɛ wù nchiɛɛŋ wù duunyi n'yuu fɛ bamii le bachii gɛ̀ too yi woŋ kfunɛ le. ");
INSERT INTO ncr_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Wu gɛ̀ bee yi woŋ le, woŋ kfunɛ nyu Nyo wù gɛ̀ fɛ fede chiaaŋ ye le, geenɛ bamii ba le ba yi woŋ kfunɛ le gɛ̀ baaŋ kɛɛ gɛ wu gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Wu gɛ̀ to yi woŋ we le, bamii ba be gɛ baaŋ fi gɛ wu gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Geenɛ, bamii bachii ba gɛ̀ fi wu, bo lee muntele yi jee che le, wu nya bvuŋga bo le lɛ bo nyume booŋ ba Nyo. ");
INSERT INTO ncr_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Gɛ booŋ ba Nyo banɛ nyu ba ba boyi bo ba bii nyu kilɛmɛ ki kfuu le gɛ, kɛnɛ no muh goone gɛ, kɛnɛ yi boyɛ chi muh wu wuŋ le gɛ. Ba boyi bo ba bii nyu boyɛ chì le chi Nyo le. ");
INSERT INTO ncr_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jɛ yiyu gɛ̀ bee yi tu muh wu wuŋ, yi tu yi chee a bee ntɛnɛɛ, a yi yisɛ bɛ kiŋkoŋɛ ki Nyo mo nchiɛɛŋ. Bee yɛŋ bvukugɛ bwe le. Bvukugɛ bvu le bvu Mwa wu mɛ gɛh wu wù ja fɛ Chiji le. ");
INSERT INTO ncr_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Joŋ gɛ̀ bɛɛyɛ jiŋ yi nsa kune wu, wu tu wu jaŋe lɛ, “Wunɛ le muh wù ŋgɛ̀ njɛme kune wu nduu lɛ, ‘Muh wù too a mɛ jiŋ kuge wu fede mɛ, nje wu gɛ̀ bee wa fɛ mɛ nyume.’” ");
INSERT INTO ncr_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","No wu le wu yisɛ bɛ kiŋkoŋɛ ki Nyo, wu mo wu nyaa bee bachii bɛ kiŋkoŋɛ yi kiŋkoŋɛ le. ");
INSERT INTO ncr_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Bee kee lɛ Nyo gɛ̀ nya banchi fede chiaaŋ yi Musɛ le. Geenɛ, kiŋkoŋɛ ki Nyo bɛ nchiɛɛŋ le ki to ki fede nyu chiaaŋ yi Jiso Kletu le. ");
INSERT INTO ncr_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Gɛ muh nyu yu wu gɛ̀ yu wa wu yɛŋ Nyo le gɛ. Le gɛh Mwa ye wù mɛ gɛh wu maa wu le mbebe yi Chiji le, wu le wu ge bee kɛɛ wu. ");
INSERT INTO ncr_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Finɛ le fiɛɛ fì Joŋ gɛ̀ jɛmɛ sege bikwɛɛ bi Bajuu bi Yɛlusalɛm gɛ̀ tuŋ bachiji kintanyɛ bɛ bamii ba Lɛwe lɛ bo biih Joŋ le laa le wu, wu yɛɛŋ lɛ. ");
INSERT INTO ncr_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Joŋ gɛ̀ baaŋ faŋ gɛ̀ ki wu chvûu mbilɛ wuboo gɛ. Wu jɛmɛ bɛ jwe we lɛ, “Gɛ nyu mɛ wù Mbvusɛ wù Nyo gɛ̀ ka gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Bo biih wu le lɛ, “Le wo wu yɛɛŋ? Le wo wu Alaja?” Wu chvuu bo le lɛ, “Gɛ mɛ nyume Alaja gɛ.” Bo ka bo biih lɛ, “Le wo wù Muh wu Ntuŋ wù Nyo wɛɛ?” Wu faŋ. ");
INSERT INTO ncr_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Bo ka bo biih wu le lɛ, “Tu nɛ lɛ le wo wu yɛɛŋ? Wo jɛme lɛ la kune kikwɛɛ kuŋ? Gɛh sɛɛŋ bee be kɛme fiɛɛ fì bee kaasɛ be gɛɛŋ be chvuu bamii ba tuŋ bee le.” ");
INSERT INTO ncr_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Joŋ chvuu bo le no Yosaya wù muh wu ntuŋ wu Nyo gɛ̀ jɛmɛ lɛ, “Nle jɛ yì jaŋe nchvuuŋ lɛ, ‘Ba najɛ je yi Tada yi nyu chaaŋ.’” ");
INSERT INTO ncr_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Bamii banɛ gɛ̀ tuŋ Bafalashii bo. ");
INSERT INTO ncr_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Bo biih Joŋ le lɛ, “Nɛ baaŋ nyu gɛ lɛ wo le Mbvusɛ wù Nyo gɛ̀ ka gɛ kɛnɛ Alaja gɛ, kɛnɛ Muh wu Ntuŋ wù Nyo wɛɛ gɛ, wo tu leese bamii a joo nje la?” ");
INSERT INTO ncr_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Joŋ chvuu bo le lɛ, “Nleese gɛh fiaŋ bamii nyu a joo, geenɛ muh mu le yu a bɛŋ ntɛnɛɛ bɛŋ kee gɛ wu gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Le wu wù too a mɛ jiŋ, mbaaŋ ŋkojɛ gɛ ki nfaanyɛ kfuu wu balaba be gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Fiɛɛ finɛ fichii gɛ̀ kooshi nyu Bɛtani Joo yì Jodaŋ le, wuŋ kwɛge fɛ Joŋ gɛ̀ leese bamii fo a joo. ");
INSERT INTO ncr_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Akfuuŋ bu a yuu, Joŋ yɛŋ Jiso too, wu mo wu jɛmɛ lɛ, “Bɛŋ bîjɛ bɛŋ yɛ̂ŋ, wunɛ le Mwa Shoŋ wù Nyo wù chiaase bimbefɛ bi yi nshɛŋ le! ");
INSERT INTO ncr_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Le wu wù nchi njɛme kune wu, nduu lɛ, ‘Muh mu too wɛ a mɛ jiŋ wu kuge wu fede mɛ, nje wu gɛ̀ bee wa fɛ mɛ nyume.’ ");
INSERT INTO ncr_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Gɛ mɛ kibɛɛ ŋgɛ̀ ŋkee wu gɛ. Geenɛ, ŋgɛ̀ nto nleese bamii a joo fi le lɛ bamii ba Ishwala kɛɛ wu.” ");
INSERT INTO ncr_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Joŋ gɛ̀ bee wu ka wu jɛmɛ ki wu bɛ̂ɛ jiŋ yi nsa we wu duu lɛ, “Ŋgɛ̀ n'yɛŋ Kiyo shiide ki too fɛwe njɛ kibɛmbɛ, ki to ye ye le. ");
INSERT INTO ncr_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Gɛ mɛ kibɛɛ ŋgɛ̀ ŋkee wu gɛ. Geenɛ, muh wu gɛ̀ tuŋ mɛ lɛ nto nleese bamii a joo gɛ̀ jɛmɛ mɛne lɛ, ‘Muh wù wo lé wo yɛ̂ŋ Kiyo shiide fɛwe ki too yi ye ye le, le wu wù lé wu gê wu lêese bamii chiaaŋ yi Kiyo ki Yuude le.’ ");
INSERT INTO ncr_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Finɛ le fiɛɛ fì ŋgɛ̀ n'yɛŋ, mbɛɛyi jiŋ yi nsa wuyu nduu lɛ muh wunɛ le Mwa Nyo.” ");
INSERT INTO ncr_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Akfuuŋ bu ayuu, Joŋ ka wu lɛme gɛh fɛɛ fɛ wu gɛ̀ lɛme bɛ booŋ be ba ŋgoo ba bafɛɛ fo. ");
INSERT INTO ncr_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Wu ja wu yɛŋ no Jiso jiɛnyi wu fede, wu mo wu jɛmɛ lɛ, “Bɛŋ bîjɛ bɛŋ yɛ̂ŋ, wunɛ le Mwa Shoŋ wu Nyo!” ");
INSERT INTO ncr_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Booŋ be ba ŋgoo ba bafɛɛ banɛ doo bo yu no wu jɛme noo, bo mo bo ja bo tu bo bii Jiso le. ");
INSERT INTO ncr_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jiso kaasɛ ye wu yɛŋ no bo bii, wu biih bo le lɛ, “Bɛŋ goone nyu la?” Bo biih wu le lɛ, “Labai, wo chee faaŋ?” (Jee chi Labai chinɛ le lɛ, “Muh wu N'yɛyɛ wù Baaŋ.”) ");
INSERT INTO ncr_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jiso chvuu bo le lɛ, “Bɛŋ tô bɛŋ yɛ̂ŋ.” Bo mo bo gɛɛŋ bo yɛŋ fɛ wu gɛ̀ chee fo. Bɛ bo mo bo nyu shwaa akfuuŋ jiiŋ. Kife kì bo gɛ̀ bi wu le gɛ̀ bee wa gɛh njɛ juu bikaa binɛh fɛnfu. ");
INSERT INTO ncr_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Muh wu mumwaa ŋgoo yi bamii ba bafɛɛ ba gɛ̀ yu no Joŋ jɛme bo mo bo bii Jiso le, gɛ̀ bee Andulu wù mwa bwe Samoŋ Bita. ");
INSERT INTO ncr_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andulu wɛɛ mo wu gɛɛŋ wu gooŋ mwa bwe wu Samoŋ, wu sɛɛŋ wu le lɛ, “Bee le be yɛŋ wa Mbvusɛ wù Nyo gɛ̀ ka le” (fì le lɛ le Kletu). ");
INSERT INTO ncr_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Noo, wu mo wu jo Samoŋ wu gɛɛŋ bɛ wu fɛ Jiso le. Jiso bijɛ wu nɛ tuŋŋ, wu jɛmɛ lɛ, “Le wo wù Samoŋ wù mwa Joŋ. Ba lé ba tɛ̂ŋe wa wo lɛ Sɛfa.” (Jee chi Sɛfa chinɛ le lɛ Bita). ");
INSERT INTO ncr_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Akfuuŋ gɛ̀ bu a yuu, Jiso yɛŋ lɛ wu lé wu gɛ̂ɛŋ kimbe kì Galalee le. Wu gɛɛŋ wu yɛŋ Filib le, wu jɛme wu le lɛ, “Wo bîi mɛne.” ");
INSERT INTO ncr_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filib wunɛ gɛ̀ bee muh wu a kilaantɛŋ kì Bɛsada le. Kilaantɛŋ kinɛ le ki Andulu bɛ Bita. ");
INSERT INTO ncr_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filib gɛɛŋ wu gooŋ Natanya wu jɛmɛ wu le lɛ, “Bee le be yɛŋ wa muh wù Musɛ gɛ̀ saŋ a Ŋwa wu banchi le kune wu, bɛ wù bamii ba ntuŋ wu Nyo gɛ̀ saŋ tɛ kune wu. Muh wunɛ le Jiso wu Nasalɛ wù mwa Yosɛf.” ");
INSERT INTO ncr_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanya chvuu wu le lɛ, “Fiɛɛ fì joŋe taŋlo fi bu Nasalɛ?” Filib jɛmɛ wu le lɛ, “To wo yɛŋ.” ");
INSERT INTO ncr_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jiso ja wu yɛŋ Natanya too, wu jɛme kune wu lɛ, “Bɛŋ jîŋɛ bɛŋ yɛ̂ŋ, muh wunɛ le muh wu Ishwala wù nchiɛɛŋ. Gɛ kinche ki chimbiaŋ nyu ye ye le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanya biih Jiso le lɛ, “Wo ge nɛɛ fɛ wo kɛɛ mɛ nɛ?” Jiso chvuu wu le lɛ, “No Filib be too ki wu tɛ̂ɛŋ wo, mbee n'yɛŋ wa wo le fɛ kinyi ki kite ki fig kɛɛ le.” ");
INSERT INTO ncr_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanya chvuu wu le lɛ, “Labai, wo le Mwa Nyo! Wo le Nfoŋ wu Ishwala!” ");
INSERT INTO ncr_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jiso jɛmɛ wu le lɛ, “Wo fɛnɛ bɛmɛ mɛne mɛɛse nje mɛ le ndu wo le lɛ mbe n'yɛŋ wa wo le fɛ kinyi ki kite kɛɛ le? Wo lé wo yɛ̂ŋ mwɛɛ mù kuge mù fede munɛ le.” ");
INSERT INTO ncr_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jiso ka wu jɛmɛ wu le lɛ, “Nsɛŋe bɛŋ nchiɛɛŋ nchiɛɛŋ lɛ bɛŋ lé bɛŋ gê bɛŋ yɛ̂ŋ kibvulɛ gwenyɛ, banchɛndaa ba Nyo bɛɛne, bo boge yi muh wù jee che le Mwamuh le.” ");
INSERT INTO ncr_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Aju gɛ̀ bu atade, bo gee ŋka wu bvuguu a kilaantɛŋ kì Kana kimbe kì Galalee le, bwe Jiso gɛ̀ bee fo. ");
INSERT INTO ncr_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Bo gɛ̀ be Jiso bɛ booŋ be ba ŋgoo fɛ ŋka wɛɛ le. ");
INSERT INTO ncr_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mbvuuŋ gɛ̀ ka, bwe Jiso be wu wu du lɛ, “Gɛ mbvuuŋ baaŋ yu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jiso chvuu wu le lɛ, “Kwɛse, wo bege mɛ yu nje la? Kife kaŋ baaŋ a kojɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Bwee jɛmɛ bamii ba gabe le lɛ, “Fiɛɛ fichii fì wu lé wu jɛ̂me lɛ bɛŋ ge, bɛŋ ge.” ");
INSERT INTO ncr_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Gɛ̀ bee sháaŋ lɛme fo bvusoo yì bo kɛnyɛ bɛ ata. Sháaŋ chinɛ le yì Bajuu gɛ̀ gɛɛde joo yì bo chuge ye yu ki bo yuude a Nyo jii. Shaaŋ yimimia gɛ̀ jode joo njɛ baleta mbambvusooshwi ncho batɛŋ (75) gɛɛne bude baleta gwii kicho yuufe ncho batɛŋ (115). ");
INSERT INTO ncr_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jiso ja wu jɛmɛ bamii ba gabe baa le lɛ, “Bɛŋ tuu joo bɛŋ yisɛ a sháaŋ chiɛɛ le.” Bo mo bo tuu joo bo yisɛ a sháaŋ yiyu le. ");
INSERT INTO ncr_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Wu mo wu jɛmɛ bo le lɛ, “Bɛŋ sɛɛ yimi mɛɛse bɛŋ gɛɛŋ bɛ yi fɛ chiji gabe le.” Bo sɛɛ bo gɛɛŋ bɛ yi. ");
INSERT INTO ncr_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Chiji gabɛ fi, wu moŋ joo yiyu wu yu yi nyu yi tu wa mbvuuŋ. Wu ma laa manɛ mbvuuŋ ja faane la. (Geenɛ, bamii ba gabe ba gɛ̀ sɛlɛ joo yiyu gɛ̀ kee fɛ mo gɛ̀ ja fo.) Chiji gabe mo wu tɛɛŋ chiji bvuguu, ");
INSERT INTO ncr_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","wu biih wu le lɛ, “Bamii to bo ya bo ga nyume mbvuuŋ ma joŋe fwe fɛ ŋka le, sege bamii mu wa bo fuu, fɛ bo gade ma joŋe, wo tu wo gɛɛ fiuŋ mbvuuŋ ma joŋe wo to bɛ mo nyu mɛɛse?” ");
INSERT INTO ncr_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Finɛ gɛ̀ bee fiɛɛ fì fwe fi duunyi bvukugɛ bvu Jiso fì wu gɛ̀ ge antɛnɛɛ a mwɛɛ mu duunyi bvukugɛ bwe. Wu gɛ̀ ge fiɛɛ finɛ a kilaantɛŋ kì Kana kimbe kì Galalee le. No wu ge noo, fi mo fi duunyi bvukugɛ bwe, booŋ be ba ŋgoo mo bo leese fitele yi ye ye le. ");
INSERT INTO ncr_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ajiŋ ayu, Jiso ja wu boh Kafanahum bɛ bwee mo booŋ ba bwee ba bilɛŋsɛ mo booŋ be ba ŋgoo, bɛ bo che yo aju shige. ");
INSERT INTO ncr_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Aju a Ŋka wu Bajuu wu ba tɛŋe lɛ Ndaŋfe gɛ̀ too wa mbebe le, Jiso ja wu bɛɛŋ Yɛlusalɛm. ");
INSERT INTO ncr_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Wu gɛɛŋ wu bu fɛ yeh yi kintanyɛ le, wu yɛŋ bamii ba gɛ̀ gese banaa bɛ shóŋ mo bimbɛmbɛ mo ba gɛ̀ kuse bige bo shiiyɛ. ");
INSERT INTO ncr_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Wu jo bakfuu wu kɛnyɛ ŋgwaŋ yu, wu kuŋ bo bachii yu, wu kuŋ mo shóŋ bɛ banaa wu bvusɛ yeh yi kintanyɛ le. Wu ka wu taashɛ bige bi bamii gɛ̀ kuse, wu bajɛ bidaŋ biboo, ");
INSERT INTO ncr_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","wu jɛmɛ bamii ba gɛ̀ gese bimbɛmbɛ le lɛ, “Bɛŋ jô mwɛɛ munɛ bɛŋ jâ yu fɛnɛ! Keefɛ bɛŋ jô yeh yi Chii tu yeh yi waaŋ gɛ!” ");
INSERT INTO ncr_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","No wu jɛmɛ noo, booŋ be ba ŋgoo mo bo kwajɛ fiɛɛ fì ba saŋ a Ŋwa wu Nyo le lɛ, “Kiŋkoŋɛ kì baaŋ kì ŋkɛme fɛ yeh yo le taŋlo ki yuuyɛ lo mɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Bikwɛɛ bi Bajuu mo bi biih wu le lɛ, “Fiɛɛ fì duunyi bvukugɛ bwuŋ fì wo taŋlo wo ge fi dunyɛ bee le lɛ ba le ba nya bvuŋga wo le ki wo gêe finɛ le la.” ");
INSERT INTO ncr_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jiso chvuu bo le lɛ, “Bɛŋ sâ yeh yi kintanyɛ yinɛ, ŋkaasɛ njo aju atade yi lɛɛŋ we.” ");
INSERT INTO ncr_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Bajuu baa biih wu le lɛ, “Fi gɛ̀ jo biluŋ mbaanyɛ ncho bvusoo ki bo jooŋ yeh yi kintanyɛ yinɛ, wo lɛ wo lé wo jô fiuŋ nyu aju atade yi lɛɛŋ we?” ");
INSERT INTO ncr_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Geenɛ, Jiso gɛ̀ jɛme yeh yi kintanyɛ yinɛ nyu ye ye. ");
INSERT INTO ncr_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Noo, sege wu gɛ̀ bu wa yi kwe le, booŋ be ba ŋgoo mo bo kwajɛ fiɛɛ fì wu gɛ̀ jɛmɛ. Bo mo bo bɛɛŋ fiɛɛ fì le a Ŋwa wu Nyo le, bo ka bo bɛɛŋ njɛmɛ wù Jiso gɛ̀ jɛme le. ");
INSERT INTO ncr_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","No Jiso gɛ̀ bee Yɛlusalɛm fɛ Ŋka wu Ndaŋfe wunɛ le, bamii ba duude gɛ̀ leesɛ muntele ye ye le nje mwɛɛ mù duunyi bvukugɛ bwe mù wu gɛ̀ gee. ");
INSERT INTO ncr_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Geenɛ, Jiso gɛ̀ baaŋ gɛɛ gɛ fie bvufee bwe yi bo le gɛ, nje wu gɛ̀ kee bamii bachii no bo le. ");
INSERT INTO ncr_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Wu gɛ̀ baaŋ koŋ gɛ lɛ muh mu she wu sɛŋe lo wu le kune muh wu wuŋ gɛ, nje wu kibɛɛ gɛ̀ kee fiɛɛ fì muh wu wuŋ kɛme a wu shɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Muh ŋgoo yi Bafalashii wumu gɛ̀ bee ba tɛŋe lɛ Nikodɛmu, wu gɛ̀ bee muh wu kinchvu ki bikwɛɛ bi woŋ wu Bajuu. ");
INSERT INTO ncr_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Muh wunɛ gɛ̀ ja wu to fɛ Jiso le antaŋ wu du wu le lɛ, “Labai, bee kee lɛ wo le muh wu n'yɛyɛ wù ja fɛ Nyo le, nje gɛ muh nyu yu wù taŋlo wu gee kfuu chi munɛ mwɛɛ mù duunyi bvukugɛ bvu Nyo mù wo gee munɛ, njɛ Nyo le bɛ wu sɛŋ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jiso chvuu wu le lɛ, “Nsɛŋe wo nchiɛɛŋ nchiɛɛŋ lɛ, njɛ ba boo muh mboyɛ wu fwɛŋ sɛŋ, tu gɛ mwɛdɛ nyu wu yɛŋ bvunfoŋ bvu Nyo le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodɛmu biih Jiso le lɛ, “Taŋlo ba ge nɛɛ fɛ ba ka ba boo muh a wu ta wa? Taŋlo wu ka wu kaasɛ wu tu a bwee shɛŋ fɛ ba ka ba boo wu?” ");
INSERT INTO ncr_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jiso chvuu wu le lɛ, “Nsɛŋe wo nchiɛɛŋ nchiɛɛŋ lɛ, muh nɛ baaŋ kɛme gɛ boyɛ chi joo bɛ chi Kiyo gɛ, tu gɛ taŋlo wu lee fɛ bvunfoŋ bvu Nyo le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Muh wu wuŋ boyi muh wu wuŋ, Kiyo boyi kiyo. ");
INSERT INTO ncr_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Keefɛ jwe yûne wo lɛ nle njɛmɛ wo le lɛ ba kɛme ki ba boo bɛŋ bachii mboyɛ wù fwɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Fii to yi fede gɛh no yi koŋe, wo yuge no yi fede, geenɛ gɛ taŋlo wo sɛɛŋ laa yi jade faaŋ, yi gɛɛne faaŋ la. Le gɛh yɛɛŋyɛɛŋ no fi le fɛ muh wù kɛme wa boyɛ chi Kiyo le.” ");
INSERT INTO ncr_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodɛmu mo wu ghaa lɛ, “Taŋlo finɛ fiɛɛ jiɛnyɛ nɛɛ la?” ");
INSERT INTO ncr_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jiso chvuu wu le lɛ, “Wo le muh wu n'yɛyɛ wu bamii ba Ishwala, wo kee gɛ finɛ fiɛɛ gɛ? ");
INSERT INTO ncr_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nsɛŋe wo nchiɛɛŋ nchiɛɛŋ lɛ, bee jɛme fiɛɛ nyu fì bee kee, bee bɛɛyi jiŋ yi nsa nyu fiɛɛ fì nyu fi bee le bee yɛŋ wa, geenɛ gɛ bɛŋ bɛmɛ fiɛɛ fì bee jɛme le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nɛ nsɛŋe bɛŋ mwɛɛ nyu mu yi nshɛŋ le fɛnɛ njɛ bɛŋ bɛmɛ lo sɛŋ, bɛŋ lé bɛŋ jîɛnyɛ nɛɛ fɛ bɛŋ bɛɛŋ mu nsɛŋe nyu mu woŋ wù Nyo le? ");
INSERT INTO ncr_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Gɛ muh nyu yu wu le wu bɛɛŋ wa woŋ wù Nyo le gɛ. Mɛ gɛh muh wù gɛ̀ ja fo wu to fɛkuu fɛnɛ, muh wunɛ nyu muh wù jee che le Mwamuh. ");
INSERT INTO ncr_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","No Musɛ gɛ̀ shɛŋshɛ yo yi ba gɛ fɛ bɛ kichwa yi kite le nchvuuŋ, le gɛh yɛɛŋyɛɛŋ no ba kɛme ki ba ge ba shɛŋshɛ muh wù jee che le Mwamuh, ");
INSERT INTO ncr_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","wu lɛ mo nyu yɛɛŋ wu le wu leesɛ fitele yi ye ye le, tu wu lé wu kɛ̂mɛ kinche kì kage gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Nyo gɛ̀ bee wu koŋ woŋ kfunɛ baaŋ, wu tuŋ Mwa ye wù wu mumwaa, wu lɛ le yɛɛŋ wù leesɛ fitele ye ye le, mwɛdɛ gɛ lɛsɛ gɛ, wu kɛmɛ nyu kinche kì kage gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Gɛ Nyo gɛ̀ tuŋ Mwa ye yi woŋ kfunɛ le lɛ wu to wu sa bamii ba gwe nsa gɛ. Nyo gɛ̀ tuŋ lɛ wu to wu bvusɛ lo bo fede yi Mwa ye le. ");
INSERT INTO ncr_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Muh wu le wu leesɛ fitele yi wu le gɛ wu nyu wu ge wu gwe nsa gɛ. Geenɛ muh wù baaŋ leesɛ gɛ fitele yi wu le gɛ le wu gwe wa nsa, nje wu baaŋ leesɛ gɛ̀ fitele yi jee chi Mwa Nyo wu mɛ gɛh wu gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ba lé ba gê ba sûunɛ nsa yi yinɛ je le, nje n'yulɛ le wu to yi woŋ kfunɛ le, bamii koŋe gɛh fiboo nyu kijibɛ fede n'yulɛ. Bo koŋe noo nje gee chiboo le chì befe. ");
INSERT INTO ncr_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Muh wuchii wù gee gee chì befe wu to wu banɛ n'yulɛ, gɛ taŋlo wù bu fɛ n'yulɛ le gɛ, lɛ keefɛ gee che yɛ̂nɛ fɛ waaŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Geenɛ muh wù gee fiɛɛ fì kooji to wu too fɛ n'yulɛ le, lɛ gee che dûunyi lɛ le chi muh wu Nyo.” ");
INSERT INTO ncr_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ajiŋ ayu le, Jiso bɛ booŋ be ba ŋgoo ja bo gɛɛne kimbe kimi ki Judia le. Bɛ bo gɛɛŋ bo tu bo nyu yo wu leese bamii a joo. ");
INSERT INTO ncr_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Joŋ tɛ gɛ̀ leese bamii a joo ntɛ wu Ɛnoŋ le mbebe wu Salim le nje joo gɛ̀ bee fo baaŋ. Bamii too wu leese bo a joo. ");
INSERT INTO ncr_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Finɛ gɛ̀ bee ba baaŋ a leesɛ gɛ wa wu yeh yi ncha le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Booŋ ba Joŋ ba ŋgoo bamu bɛ muh wu Bajuu wumu gɛ̀ ja bo kɛ kintɛɛnyɛ kune ye yì ba chuge ki ba yuude a Nyo jii. ");
INSERT INTO ncr_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Booŋ ba ŋgoo ba Joŋ ja bo gɛɛŋ fɛ Joŋ le, bo jɛmɛ wu le lɛ, “Labai, muh wɛɛ wù gɛ̀ bee bena wu fɛ Joo yì Jodaŋ le wuŋ kwege wù wo gɛ̀ jɛme baaŋ kune wu nɛ, yɛŋ nɛ wu wege wu leese bamii a joo, bamii bachii gɛɛne gɛ wa nyu fɛ wu le.” ");
INSERT INTO ncr_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Joŋ chvuu bo le lɛ, “Gɛ muh taŋlo wù nyu fiɛɛ njɛ ge Nyo wù nyu fi sɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Bɛŋ kibɛɛ taŋlo bɛŋ bɛɛ jiŋ yi nsa waŋ lɛ ŋgɛ̀ mbee njɛmɛ lɛ gɛ nyume mɛ wù le Mbvusɛ wù Nyo gɛ̀ ka gɛ. Geenɛ ba gɛ̀ tuŋ mɛ lɛ nsa wù fwe. ");
INSERT INTO ncr_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Muh bvuguu le muh wù kɛme kwɛse wù fwɛŋ. Nsaŋ yi muh bvuguu wù lɛme mbebe yi muh bvuguu wɛɛ le wu yuge jɛ ye, wu to wu laŋeye baaŋ no wu yuge jɛ ye. Le gɛh yɛɛŋyɛɛŋ no nle mɛɛse n'yisɛ bɛ kinlaŋye. ");
INSERT INTO ncr_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Wu kɛme ki wu kû wu gɛ̂ɛŋ lo fwe, ntû lo jiŋ. ");
INSERT INTO ncr_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Muh wù ja fɛwe wu kuge wu fede bamii bachii. Muh wu yi nshɛŋ le, le muh wu yi nshɛŋ le, wu jɛme mwɛɛ nyu mu yi nshɛŋ le. Muh wù ja woŋ wù fɛwe le, wu kuge wu fede bamii bachii, ");
INSERT INTO ncr_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","wu bɛɛyi jiŋ yi nsa yi mwɛɛ nyu mu wu le wu yɛŋ wa wu ka wu yu. Geenɛ, gɛ muh nyu yu wù bɛmɛ fiɛɛ fì wu jɛme le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Muh wù bɛmɛ fiɛɛ fì wu jɛme duunyi lɛ wu toone fiɛɛ fì le lɛ Nyo jɛme nchiɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Muh wù Nyo tuŋ to wu jɛme gɛh nyu jɛ yi Nyo, nje Nyo le wu nya Kiyo ke wu le nfee sɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Chiji Mwa wu koŋe Mwa, wu mo wu nya mwɛɛ munchii chiaaŋ ye le. ");
INSERT INTO ncr_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Muh wu le wu leesɛ fitele yi Mwa le wù kɛme kinche kì kage gɛ. Muh wù baaŋ yu gɛ wu le gɛ, gɛ wu nyu wu kɛmɛ kinche gɛ. Wuwɛɛ muh le shɛ́ŋ yi Nyo toonyi bɛ wu baaŋ.” ");
INSERT INTO ncr_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jiso gɛ̀ kɛɛ lɛ Bafalashii le bo yu lɛ wu lɛne bamii ba ŋgoo bo too wu leese bo a joo fede Joŋ. ");
INSERT INTO ncr_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Geenɛ gɛ nyu wu wù gɛ̀ leese bo a joo gɛ, gɛ̀ leese booŋ be ba ŋgoo lɛ maa. ");
INSERT INTO ncr_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Wu doo wu kɛɛ noo, wu mo wu ja a kimbe ki woŋ kì Judia kiyu le, wu kaase wu tuu jiŋ kì Galalee le. ");
INSERT INTO ncr_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Wu gɛ̀ kɛme ki wu fê je kimbe ki Samaliya le. ");
INSERT INTO ncr_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Wu gɛ gɛɛŋ wu bu a kilaantɛŋ ki Samaliya kimi le ki ba gɛ tɛŋe lɛ Sika, ki le mbebe mwɛ wu Yakob gɛ nya mwa ye wu Yosɛf le. ");
INSERT INTO ncr_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Fwɛŋ wu joo wu Yakob gɛ̀ chiŋ gɛ̀ bee fo. No Jiso gɛ̀ jiɛnyɛ wa baaŋ wu fwɛɛŋ, wu mo wu shii mbebe fwɛŋ wu joo kwɛɛ le. Kife gɛ̀ bee njɛ juu bikaa ncho bifɛɛ fɛnshɛ. ");
INSERT INTO ncr_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Kwɛse wumu wu Samaliya gɛ̀ to ki wu tûu joo fo, Jiso jɛmɛ wu le lɛ, “Nya mɛ bɛ joo mu.” ");
INSERT INTO ncr_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Gɛ̀ bee booŋ ba ŋgoo ba Jiso gɛɛŋ alaantɛŋ ki bo gu mwɛɛ munjile. ");
INSERT INTO ncr_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kwɛse wɛɛ biih Jiso le lɛ, “Wo le muh wu Bajuu, nle muh wu Samaliya, wo ge nɛ fɛ wo tu wo lɛge joo a mɛne?” Kwɛse wɛɛ gɛ̀ duu noo, nje Bajuu gɛ̀ nyiɛŋse lo bamii ba Samaliya. ");
INSERT INTO ncr_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jiso chvuu wu le lɛ, “Nɛ wo be kee nnya yì le yi Nyo, mo muh wù duu wo le lɛ wo nyâ wu bɛ joo, tu wo be wo lɛgɛ lɛ wu nyâ wo bɛ joo yì bohge segechii.” ");
INSERT INTO ncr_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kwɛse wɛɛ kaasɛ wu biih Jiso le lɛ, “Chii, njɛ wo kɛme fiɛɛ fì wo tuu joo yo sɛŋ, fwɛŋ kfunɛ shiide nɛ, wo lé wo jô faaŋ yɛɛ joo yi boge segechii? ");
INSERT INTO ncr_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Fi le lɛ wo kuge wo fede chiji wese wù Yakob wù gɛ̀ chiŋ fwɛŋ kfunɛ wu gɛɛ bee le, wu kibɛɛ gɛ̀ mu joo yo, booŋ be mu, nyáŋ ye tɛ mu?” ");
INSERT INTO ncr_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jiso chvuu wu le lɛ, “Muh wuchii wù muu joo yinɛ kindoŋ baaŋ ki yune wu. ");
INSERT INTO ncr_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Geenɛ, nɛ le yɛɛŋ wù lé wu gê wu mû joo yì nlé ŋgê nyâ, gɛ kindoŋ baaŋ ki ka ki yune wu gɛ. Joo yì nlé nyâ wu le, lé yi jâ yi tû nchweŋ wu joo yì bude yi ye ye le segechii, yi lé yi jîɛnyɛ yi tô yi nyâ wu kinche kì kage gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Kwɛse wɛɛ mo wu jɛmɛ Jiso le lɛ, “Chii, nya mɛ bɛ kfuu chi yinɛ joo yi le lɛ keefɛ kindoŋ ka ki yune mɛ gɛ, ŋgɛ ŋka ntoo fɛnɛ ki ntuude joo gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jiso jɛmɛ wu le lɛ, “Gɛnɛ wo tɛɛŋ jwɛɛŋ, bena wu to.” ");
INSERT INTO ncr_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Kwɛse wuyu chvuu wu le lɛ, “Gɛ ŋkɛme jwɛŋsɛ gɛ.” Jiso jɛmɛ wu le lɛ, “Wo le wo jɛmɛ chuule no wo jɛmɛ lɛ gɛ wo kɛme jwɛŋsɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Wo gɛ̀ kɛme wa bilɛŋsɛ batɛŋ, wu bena wu le mɛɛse gɛ nyu mo jwɛɛŋ wo gɛ. Fiɛɛ fì wo jɛme le nchiɛɛŋ.” ");
INSERT INTO ncr_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Kwɛse wɛɛ jɛmɛ Jiso le lɛ, “Chii, nle n'yɛŋ mɛɛse lɛ wo le muh wu ntuŋ wu Nyo. ");
INSERT INTO ncr_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bachiji besa gɛ̀ shee bo buune Nyo yi mbegɛ wunɛ le, bɛŋ Bajuu duu fiena lɛ fɛ bamii kɛme ki bo buune Nyo fo le gɛh Yɛlusalɛm.” ");
INSERT INTO ncr_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jiso chvuu wu le lɛ, “Kwɛse, bɛ̂ɛŋ fiɛɛ fì njɛme finɛ. Kife too lo kì bɛŋ lé bɛŋ bûune Nyo wù Chii ka nyume gɛ yi mbegɛ wunɛ le gɛ, kɛnɛ Yɛlusalɛm gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Bɛŋ bamii ba Samaliya buune fiɛɛ fì bɛŋ kee gɛ, bee Bajuu buune be kee fiɛɛ fì bee buune, nje mbvusɛ jade fɛ Bajuu le. ");
INSERT INTO ncr_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Geenɛ, kife too lo, ki to wa, kì bamii ba buune Nyo nchiɛɛŋ nchiɛɛŋ lé bo gê bo bûune Nyo wù Chii a kiyo le bɛ yi nchiɛɛŋ le. Le kfuu chi bamii ba Nyo wù Chii goone lɛ bo buune wu. ");
INSERT INTO ncr_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nyo le Kiyo, bamii ba buune wu bo kɛme ki bo buune a kiyo le bɛ yi nchiɛɛŋ le.” ");
INSERT INTO ncr_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kwɛse wɛɛ jɛmɛ Jiso le lɛ, “Ŋkee lɛ Mbvusɛ wù Nyo gɛ̀ ka too lo, wù ba tɛŋe lɛ Kletu. Sege wu doo wu to, wu mo wu najɛ mwɛɛ munchii bee le.” ");
INSERT INTO ncr_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jiso jɛmɛ wu le lɛ, “Mɛ wunɛ wù njɛme wo le le mɛ wuyu.” ");
INSERT INTO ncr_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Gɛh segeyu, booŋ ba Jiso ba ŋgoo mo bo kaasɛ bo to. Jwe yuŋ lo bo no wu jɛme bɛ kwɛse wɛɛ. Geenɛ, muh mu bo le gɛ̀ baaŋ biih gɛ wu le laa wu goone la lɛ, kɛnɛ lɛ Jiso jɛme bɛ kwɛse wɛɛ nje la lɛ. ");
INSERT INTO ncr_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kwɛse wɛɛ mo wu gɛɛ shaaŋ ye yi joo fo, wu gɛɛŋ alaantɛŋ, wu gɛɛŋ wu be bamii lɛ, ");
INSERT INTO ncr_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Bɛŋ tô bɛŋ yɛ̂ŋ muh mu le wu to wu sɛɛŋ fiɛɛ fichii fì ŋgɛ̀ ŋge wa. Taŋlo muh wunɛ nyume Mbvusɛ wù Nyo gɛ̀ ka?” ");
INSERT INTO ncr_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Bamii bu alaantɛŋ bo gɛɛne fɛ Jiso le. ");
INSERT INTO ncr_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Gɛ̀ bee booŋ ba ŋgoo ba Jiso shɛɛ wa bo lɛge Jiso bo duu wu le lɛ, “Labai, jî mwɛɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Geenɛ, Jiso chvuu bo le lɛ, “Ŋkɛme mwɛɛ munjile mù njii gɛ bɛŋ kee mu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Booŋ be ba ŋgoo mo bo gha lɛbolɛbo lɛ, “Muh le wu shɛɛ wu to bɛ mwɛɛ munjile wu nya wu le?” ");
INSERT INTO ncr_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jiso jɛmɛ bo le lɛ, “Mwɛɛ munjile mwaŋ le lɛ ŋge fiɛɛ fì muh wu tuŋ mɛ goone, lɛ mɛ mɛsɛ lɛme che chichii. ");
INSERT INTO ncr_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Gɛ bɛŋ duu fiena lɛ shɛshi gɛh kii yinɛh, mo nyu kife ki ŋgwejɛ gɛ? Nduu bɛŋ le lɛ, bɛŋ chîaasɛ ajii we bɛŋ jîŋɛ bɛŋ yɛ̂ŋ no mwɛɛ le wa ŋɛɛ le no ba gwejɛ. ");
INSERT INTO ncr_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Muh wù gweji kɛme nlaŋe we, wu baanyi ŋgu wu gɛɛde yi kinche kì kage gɛ le, noo le muh wù boone bɛ muh wù gwejɛ mo bo laŋeye yi muh le wu mumwaa. ");
INSERT INTO ncr_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Finɛ fiɛɛ duunyi lɛ ŋgaŋ wunɛ le nchiɛɛŋ wù duu lɛ, ‘Muh mu boone, muh mu gwejɛ.’ ");
INSERT INTO ncr_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ntuŋ bɛŋ lɛ bɛŋ gɛɛŋ bɛŋ gwejɛ mwɛɛ mù bɛŋ gɛ baaŋ lɛŋ gɛ. Bamii bamu le bo booŋ, bɛŋ lee bvujoŋɛ bvu lɛme chiboo le.” ");
INSERT INTO ncr_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Bamii ba Samaliya ba duude a kilaantɛŋ kiyu le gɛ̀ lee muntele yi Jiso le nje fiɛɛ fì kwɛse wɛɛ gɛ̀ jɛmɛ bo le lɛ, “Wu be wu sɛɛŋ lo mɛ fiɛɛ fichii fì ŋgɛ̀ ŋge wa.” ");
INSERT INTO ncr_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Noo, bo doo bo to bo yɛŋ Jiso le, bo lɛgɛ lɛ bɛ bo che. Wu bɛɛŋ, bɛ bo che aju afaa. ");
INSERT INTO ncr_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bamii ba duude ka bo leesɛ muntele yi Jiso le nje jɛmɛ we. ");
INSERT INTO ncr_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Bamii baa jɛmɛ kwɛse wɛɛ le lɛ, “Bee le be leesɛ muntele yi ye ye le, ka nyu gɛ nje njɛmɛ wo gɛ. Bee le be yu wa bɛ bintuŋ biɛsa, bee kɛɛ lɛ muh wunɛ le Mbvusɛ wù woŋ kfunɛ wu nchiɛɛŋ.” ");
INSERT INTO ncr_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Lɛ aju fe afaa, Jiso ja wu gɛɛne Galalee. ");
INSERT INTO ncr_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Wu kibɛɛ gɛ̀ bee wu yu wu jɛmɛ lɛ gɛ ba to ba ŋgvuune muh wu ntuŋ wu Nyo woŋ we le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Wu gɛ̀ doo wu gɛɛŋ wu fɛsɛ Galalee, bamii ba yo fi wu nje bo gɛ̀ yɛŋ mwɛɛ mu wu gɛ̀ ge fɛ ŋka le Yɛlusalɛm, nje bo tɛ gɛ̀ bee fɛ ŋka wɛɛ le. ");
INSERT INTO ncr_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jiso ka wu kaasɛ wu gɛɛŋ Kana wu a kimbe kì Galalee le, a wu gɛ̀ kaasɛ joo yo yi tu mbvuuŋ. Gɛ̀ bee muh wù baaŋ wumu nyu a kilaantɛŋ kì Kafanahum le, mwa ye wù jwɛŋsɛ chɛne. ");
INSERT INTO ncr_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Muh wù baaŋ wɛɛ doo wu yu lɛ Jiso le wu ja wa Judia wu too Galalee, wu gɛɛŋ fɛ wu le, wu ku chiaaŋ lɛ wu boh wu to wu fɛ mwa ye, lɛ wu le wa jwe wu kwe le. ");
INSERT INTO ncr_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jiso mo wu jɛmɛ wu le lɛ, “Nɛ bɛŋ le njɛ bɛŋ yɛŋ mwɛɛ mù duunyi bvukugɛ bvu Nyo le sɛŋ, bɛŋ nɛ baaŋ yɛŋ gɛ tɛ mwɛɛ mu jwe wu yune le sɛŋ, bɛŋ gɛ leesɛ fitele yi ye yaŋ le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Muh wù baaŋ wɛɛ jɛmɛ wu le lɛ, “Chii, tô gɛh be bohge lo, fɛ mwa yaŋ kwe gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jiso chvuu wu le lɛ, “Wo gɛ̂ɛne, mwa yo le yu.” Muh wɛɛ gɛ̀ bɛɛŋ fiɛɛ fì Jiso jɛme wu le, wu mo wu ja wu gɛɛne. ");
INSERT INTO ncr_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","No wu gɛ̀ boge, bɛ booŋ be ba lɛme lɛ tasɛ, bo sɛɛŋ wu le lɛ mwa wɛɛ le yu. ");
INSERT INTO ncr_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Noo, wu biih bo kife ki wu chi kɛ̂ wu tɛɛme. Bo jɛmɛ wu le lɛ, “Chi bee njɛ juu kikaa kimimia fɛnshɛ, kin'ya kiyu mo ki chinɛ wu le.” ");
INSERT INTO ncr_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Chiji mwa wɛɛ mo wu kwajɛ lɛ le kife kiyu kì Jiso chi jɛme wu le lɛ, “Mwa yo le yu.” Wu bɛ yeh ye yichii mo bo leesɛ muntele yi Jiso le. ");
INSERT INTO ncr_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Finɛ fiɛɛ fì duunyi bvukugɛ bvu Jiso, gɛ̀ bee fi kiŋgane kinfɛɛ fì wu gɛ̀ ge sege wu gɛ̀ ja Judia wu to Galalee. ");
INSERT INTO ncr_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ajiŋ ayu ŋka wu Bajuu wumu gɛ̀ bee Yɛlusalɛm, Jiso bɛɛŋ yo. ");
INSERT INTO ncr_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kintuge ki joo kimi gɛ̀ bee yo ba tɛŋe a jɛ́ yi Ibulu le lɛ Bɛseda, ki le mbebe Jwe wu Kitaŋ ki Shóŋ le. Ba nyu ba jooŋ baŋgaa fo batɛŋ, ");
INSERT INTO ncr_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","bamii ba binchɛŋ gɛ̀ shee bo loone lo fo, binfeeŋ bɛ bantɛŋelase mo ba kwe wa kimbe kimimia. Bo gɛ̀ shee bo gime fo bo chiɛɛne sege joo le yi ja yi shiŋshɛ. ");
INSERT INTO ncr_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Nchɛndaa Tada wumu gɛ̀ too kife le kife le, wu leese wu shiŋshi joo yiyu. Muh wù fwe wù ya wu lee yo sege Nchɛndaa wuyu shiŋshɛ joo yiyu, tu wu lé wu tɛ̂mɛ yi kinchɛŋ ke le mo nyu ki nɛɛ lɛ. ");
INSERT INTO ncr_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Muh mu gɛ̀ bee fo wu gɛ̀ chɛŋ wa biluŋ mbaanshɛ ncho nyaaŋ. ");
INSERT INTO ncr_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jiso doo wu to fo wu yɛŋ wu le, wu kɛɛ lɛ wu gɛ̀ giiŋ wa fo ntaŋ wù ndefɛ le, wu biih wu le lɛ, “Wo koŋe ki wo tɛ̂mɛ?” ");
INSERT INTO ncr_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Muh wu kinchɛŋ wɛɛ chvuu lɛ, “Chii, gɛ ŋkɛme muh wù taŋlo wu fih wu leesɛ mɛ a joo yinɛ le sege yi shiŋshi gɛ. Sege yi shiŋshɛ, ndoo ŋgɛɛne ki nlee, nto muh mu nyu wu lee wa a mɛne.” ");
INSERT INTO ncr_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jiso jɛmɛ wu le lɛ, “Jâ we, wo jô kijinɛ kuŋ, wo gɛ̂ɛne.” ");
INSERT INTO ncr_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kimimia, muh wɛɛ mo wu tɛmɛ, wu jo kijinɛ ke wu mo wu gɛɛne. Abvu gɛ̀ bee juu chi yuuŋ. ");
INSERT INTO ncr_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Bajuu mo bo jɛmɛ muh wù ba gɛ̀ fɛ wɛɛ le lɛ, “Abɛŋ le juu chi yuuŋ nchi baaŋ bɛɛŋ gɛ lɛ wo tuu kijinɛ kuŋ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Wu chvuu bo le lɛ, muh wu be fɛ mɛ ntɛmɛ be wu jɛmɛ mɛne lɛ, “Jôo kijinɛ kuŋ wo gɛ̂ɛne.” ");
INSERT INTO ncr_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Bo biih wu le lɛ, “Le yɛɛŋ wuyu wù be jɛmɛ wo le lɛ wo jo kijinɛ kuŋ wo gɛɛne?” ");
INSERT INTO ncr_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Gɛ muh wu ba gɛ̀ fɛ wɛɛ gɛ̀ kee mo muh wù fɛ wu gɛ, nje Jiso gɛ̀ ja wa wu lee wu gɛɛŋ antɛnɛɛ a kinchvu ki bamii kì gɛ̀ bee fo. ");
INSERT INTO ncr_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Lɛ nyu ajiŋ ayu, Jiso yɛŋ wu le fɛ yeh yi kintanyɛ le, wu jɛmɛ wu le lɛ, “Bîjɛ yɛ̂ŋ no wo le wo tɛmɛ wa. Keefɛ wo ka wo gêe bimbefɛ gɛ. Wo ka ge lo, fiɛɛ lé fi gê fi gwê ye yo le fì kuufe ye fi fede finɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Muh wɛɛ ja wu gɛɛŋ wu sɛɛŋ Bajuu le lɛ le Jiso wù be fɛ wu. ");
INSERT INTO ncr_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Bajuu mo bo kɛ bo tu bo boone bikaa a Jiso jiŋ, nje wu gɛ̀ fɛ muh wunɛ nyu juu chi yuuŋ. ");
INSERT INTO ncr_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jiso jɛmɛ bo le lɛ, “Chii to wu lɛne segechii, mɛ tɛ nlɛne noo.” ");
INSERT INTO ncr_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Njɛmɛ wunɛ ge Bajuu mɛsɛ lo bo tu bo goone baaŋ ki bo yuuyɛ wu, nje gɛ gɛ̀ mɛ gɛh yuuŋ chi wu gɛ̀ ŋgode maa gɛ. Wu gɛ̀ tɛŋe tɛ Nyo lɛ Chiji, wu fege ye ye lɛ wu le yɛɛŋyɛɛŋ bɛ Nyo. ");
INSERT INTO ncr_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jiso gɛ̀ ja wu jɛmɛ bo le lɛ, “Nsɛŋe bɛŋ le nchiɛɛŋ nchiɛɛŋ lɛ gɛ mɛ wù Mwa taŋlo ŋge fiɛɛ a bvuŋga bwaŋ le gɛ. Ŋgee gɛh nyu fiɛɛ fì n'yɛde Chii gee. Fiɛɛ fì Chiji Mwa gee, le gɛh fi fi Mwa le wù gee tɛ, ");
INSERT INTO ncr_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","nje Chiji Mwa wɛɛ wù koŋe Mwa to wu duunyi Mwa mwɛɛ munchii mù wu wù Chiji Mwa gee. Wu baaŋ wu ka wu dunyɛ mwɛɛ mù fede munɛ wu le, wu gêe bɛŋ yɛ̂de, jwe yûne lo bɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","No Chiji Mwa bvuuse bamii yi kwe le wu nyaa kinche bo le, le gɛh yɛɛŋyɛɛŋ no Mwa nyaa kinche mo yɛɛŋ wù wu koŋe le. ");
INSERT INTO ncr_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ki ntaa fo gɛ Chiji Mwa sage muh mu gɛ. Wu lé wu nyâ nsa wuchii nyu chiaaŋ yi Mwa ye le, ");
INSERT INTO ncr_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","wu lɛ taŋlo bamii bachii ŋgvûune Mwa, gɛh yɛɛŋyɛɛŋ no ba ŋgvuune tɛ Chiji. Nɛ muh le yu wu ŋgvuune gɛ Mwa gɛ, tu gɛ wu ŋgvuune Chiji wu tuŋ wu gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nsɛŋe bɛŋ le nchiɛɛŋ nchiɛɛŋ lɛ muh wu yu jɛ yaŋ, wu bɛɛŋ muh wù tuŋ mɛ le, wù kɛme kinche kì kage gɛ. Gɛ mwɛdɛ baaŋ wu ka wù kɛme nsa gɛ. Wuwɛɛ muh le wu bu wa chiaaŋ yi kwe le, wu lee kinche le. ");
INSERT INTO ncr_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nsɛŋe bɛŋ nchiɛɛŋ nchiɛɛŋ lɛ kife too lo, ki nyu ki to wa, kì bamii ba kweeyɛ wa lé bo yû jɛ yi Mwa Nyo, baa bò lé bo gê bo yû, lé bo kɛ̂me kinche. ");
INSERT INTO ncr_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Fi le noo, nje no kinche jade yi Chiji Mwa le, le gɛh yɛɛŋyɛɛŋ no wu nya bvuŋga Mwa le lɛ kinche jâde tɛ yi ye ye le. ");
INSERT INTO ncr_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Wu lé wu nyâ tɛ bvuŋga Mwa le lɛ wu sûunɛ bansa, nje wu le Mwa wu le Muh wù jee che le Mwamuh. ");
INSERT INTO ncr_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Keefɛ jwe yûnɛ bɛŋ yi finɛ fiɛɛ le gɛ. Kife too lo kì bamii bachii ba le a jɛ́ŋ lé bo yû jɛ ye, ");
INSERT INTO ncr_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","bo bu a jɛŋ, bo gee mwɛɛ mù njoŋe, bo bu bo lee kinche kì kage gɛ le, ba gɛ̀ gee mwɛɛ mù mbefe, bo bu ba sa bo, bo gwe nsa. ");
INSERT INTO ncr_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Gɛ fiɛɛ nyu yu fì ntaŋlo ŋge a bvuŋga bwaŋ le gɛ. Nsage nsa mbii no n'yuge, je yì nsuune yu le yi chaaŋ, nje gɛ ŋgoone ki ŋgee fiɛɛ fì koŋe mɛ gɛ. Ŋgee nyu fiɛɛ fì muh wù tuŋ mɛ goone. ");
INSERT INTO ncr_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nɛ mbɛɛyi jiŋ yi nsa wu kikwɛɛ kaŋ, tu gɛ fiɛɛ fì njɛme kooji gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Geenɛ, muh mu le yu wù bɛɛyi jiŋ yi nsa waŋ, ŋkee lo lɛ fiɛɛ fì wu jɛme kune mɛ le nchiɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Bɛŋ gɛ̀ tuŋ bamii fɛ Joŋ le, wu gɛɛŋ wu bɛɛ jiŋ yi nsa kune nchiɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Gɛ nyu lɛ ŋkoŋe lɛ jɛ̂me muh wu wuŋ kune muh wù le mɛ gɛ. Geenɛ, njɛme nɛ wu lɛ bɛŋ taŋlo bɛŋ bonɛ. ");
INSERT INTO ncr_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Joŋ gɛ̀ bee njɛ kin'yesɛ kì ba chu ki bɛɛde ki nyaa n'yulɛ, bɛŋ koŋe ki bɛŋ nyûme yi n'yulɛ we le yi kife ki shige le, bɛŋ laŋeye. ");
INSERT INTO ncr_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Fiɛɛ fimi le yu fì duunyi muh wu le mɛ fì fede Joŋ. Fi le lɛ, lɛme chi Chii nya lɛ nlɛŋ mmɛsɛ, chi le mwɛɛ mu ŋgee munɛ, mu duunyi lɛ tuŋ Chii mɛ. ");
INSERT INTO ncr_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Chii, wu tuŋ mɛ wù kibɛɛ le wu bɛɛ tɛ jiŋ yi nsa waŋ. Bɛŋ gɛ̀ baaŋ a yu gɛ jɛ ye gɛ, bɛŋ gɛ̀ baaŋ a yɛŋ gɛ wu le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Gɛ bɛŋ kɛme tɛ jɛ ye a muntele mwɛna le gɛ, nje bɛŋ baaŋ lee gɛ muntele yi muh wu wù tuŋ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Bɛŋ taade a Ŋwa wu Nyo le nje bɛŋ kwaji lɛ le yo a bɛŋ lé bɛŋ kɛme fiɛɛ fì lé fi gê bɛŋ kɛ̂me kinche kì kage gɛ. Fiɛɛ fì le a Ŋwa wuyu wunɛ le jɛme nyu kune mɛ. ");
INSERT INTO ncr_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Geenɛ, bɛŋ ka faŋe ki bɛŋ tô fɛ mɛne lɛ bɛŋ kɛme kinche. ");
INSERT INTO ncr_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Gɛ ŋgoone mbɛɛŋsɛ nyu wù jade fɛ muh wu wuŋ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Geenɛ ŋkee bɛŋ. Ŋkee lɛ gɛ bɛŋ kɛme kiŋkoŋɛ ki Nyo a muntele mwɛna le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nto a jee chi Chii le, bɛŋ baaŋ mɛ fi gɛ. Nɛ be to muh mu a jee che le, tu wuwɛɛ muh bɛŋ bee bɛŋ mo bɛŋ fi lo wu. ");
INSERT INTO ncr_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Taŋlo bɛŋ ge nɛɛ fɛ bɛŋ bɛɛŋ mɛne, bɛŋ nyu bamii ba goone mbɛɛŋsɛ nyu wu jade fɛ bikwɛɛ biɛna le, bɛŋ goone gɛ mbɛɛŋsɛ wu jade nyu fɛ Nyo wù mɛ gɛh wu le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Keefɛ bɛŋ kwâji lɛ le mɛ wù nle ndunyɛ gee chena chì befe Chii le gɛ. Le Musɛ wu bɛŋ gɛle bvufee ye ye le, le wu wù lé wu dunyɛ gee chena Chii le. ");
INSERT INTO ncr_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nɛ bɛŋ gɛ̀ bɛɛŋ wa Musɛ le nchiɛɛŋ, tu bɛŋ be bɛŋ bɛɛŋ mɛne nje wu gɛ̀ saŋ kune mɛ. ");
INSERT INTO ncr_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Geenɛ no bɛŋ gɛ̀ baaŋ bɛɛŋ gɛ mo mwɛɛ mù wu gɛ̀ saŋ le gɛ, taŋlo bɛŋ ge nɛɛ fɛ bɛŋ bɛɛŋ fiɛɛ fì njɛme le?” ");
INSERT INTO ncr_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ajiŋ ayu, Jiso gɛ̀ ja wu gɛɛŋ wu daŋ Mamasi wù Galalee, wu gɛɛŋ wuŋ kwege. Mamasi wunɛ gɛ̀ bee wù ba tɛŋe tɛ lɛ wu Tibɛlia. ");
INSERT INTO ncr_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kinchvu ki bamii banyɛ a wu jiŋ nje bo gɛ̀ yɛŋ mwɛɛ mù duunyi bvukugɛ bwe le mu wu gɛ̀ gee fɛ bamii ba binchɛŋ le no wu gɛ̀ fɛde bo. ");
INSERT INTO ncr_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jiso bɛ booŋ be ba ŋgoo ja bo bɛɛŋ bo gɛɛŋ bo shii yi mbegɛ le. ");
INSERT INTO ncr_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Gɛ̀ bee sege kɛɛ, Ŋka wu Bajuu wu Ndaŋfe nyu wa abo. ");
INSERT INTO ncr_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jiso gɛ̀ doo wu noŋ ajii, wu yɛŋ no kinchvu ki bamii too fɛ wu le, wu mo wu biih Filib le lɛ, “Bee lé be gê nɛɛ fɛ bee gu mwɛɛ munjile bamii banɛ ji?” ");
INSERT INTO ncr_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Wu gɛ̀ biide noo, wu mone gɛh lo Filib nje wu kibɛɛ gɛ̀ bee wu kee wa fiɛɛ fì wu lé wu gê. ");
INSERT INTO ncr_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filib chvuu wu le lɛ, “Gɛ bige bì ba laaŋe mwa wu lɛme yu yi aju le gii yifɛɛ kooji no taŋlo ba gu mwɛɛ munjile mu muh wu mumwaa wu mumwaa bo le kɛmɛ fi shige gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Mwa ye wu ŋgoo wumu wù jee che gɛ̀ bee lɛ Andulu wù mwa bwe Samoŋ Bita mo wu jɛmɛ wu le lɛ, ");
INSERT INTO ncr_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Mwa wù jwɛŋsɛ wumu le fɛnɛ wù kɛme chefe yi blɛd yishɛŋ bɛ bíɛŋ yifiɛɛ, geenɛ finɛ fiɛɛ taŋlo fi ge la fɛ kfuu chi banɛ bamii ba duude nɛ le?” ");
INSERT INTO ncr_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jiso jɛmɛ lɛ, “Bɛŋ dû bamii baa le lɛ bo shîiyɛ fɛkuu” Gɛ̀ bee agaaŋ nyu fo wesee, bo mo bo jɛmɛ bo shiiyɛ, bilɛŋsɛ maa gɛ̀ bee njɛ banchvuge batɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jiso mo wu jo chefe yi blɛd chiɛɛ, wu nya kiyone Nyo le, wu mo wu gajɛ bamii ba gɛ̀ shiiyɛ baa le. Wu ge gɛh yɛɛŋyɛɛŋ bɛ bíɛŋ chiɛɛ. Muh wuchii kɛme gɛh no wu gɛ̀ goone. ");
INSERT INTO ncr_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bo gɛ̀ ji bo fuu, wu jɛme booŋ be ba ŋgoo le lɛ, “Bɛŋ bânyɛ bimbɛge, wu lɛ keefɛ fiɛɛ lɛsɛ achiji gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Noo, bo mo bo banyɛ bimbɛge bi chefe yi blɛd yi yishɛŋ chiɛɛ bì gɛ̀ shɛshɛ, bi yisɛ ŋkáa yuufe ncho yifiɛɛ. ");
INSERT INTO ncr_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Bamii baa doo bo yɛŋ fiɛɛ fì duunyi bvukugɛ bwe le finɛ fì wu gɛ̀ ge, bo mo bo jɛmɛ lɛ, “Muh wunɛ le nchiɛɛŋ Muh wu Ntuŋ wu Nyo wɛɛ wù gɛ̀ bee ki wu tô yi woŋ kfunɛ le.” ");
INSERT INTO ncr_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jiso gɛ̀ doo wu yɛŋ lɛ bamii baa goone ki bo to bo koo wu bvuŋga le, bo ghaa Nfoŋ wuboo le, wu mo wu wɛɛŋ wu kaasɛ wu bɛɛŋ yi mbegɛ le wu tu wù nyu yo wu maa. ");
INSERT INTO ncr_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Lɛ to nyu fɛnfu, booŋ be ba ŋgoo boh bo gɛɛŋ fɛ mamasi le, ");
INSERT INTO ncr_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","bo lee a ŋguh le bo kɛ bo daŋe bo gɛɛne Kafanahum. Gɛ̀ bee sege kɛɛ akfuuŋ nyu a jiiŋ wa Jiso baaŋ a to gɛ fɛ bo gɛ̀ bee fo gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Joo gɛ̀ ja yi shiŋshi, nje nfuŋ wu baaŋ gɛ̀ fede lo. ");
INSERT INTO ncr_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bo tu bo chiide ŋguh bo daŋe, bo gɛ̀ gɛɛŋ wa bo bu njɛ bama batɛde kɛnɛ banɛh lɛɛ, bo ja bo yɛŋ Jiso le wu jiɛnyi yi joo le wu too wa mbebe yi ŋguh le. Njaŋ koo bo. ");
INSERT INTO ncr_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Geenɛ, wu jɛmɛ bo le lɛ, “Keefɛ bɛŋ fâane gɛ, le mɛ!” ");
INSERT INTO ncr_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bo yu noo, bo mo bo tu bo koŋe ki bo jo wu a ŋguh le. Lɛ bo njaŋɛ, ŋguh fɛɛse wa ŋgɛɛmɛ yi joo le kwa fɛ bo gɛ̀ gɛɛne fo. ");
INSERT INTO ncr_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Akfuuŋ gɛ̀ bu ayuu, bamii ba gɛ̀ shɛshɛ mamasi wuŋ kwɛge kwaji lɛ ŋguh gɛ̀ bee fo wu mumwaa, Jiso gɛ̀ baaŋ lee gɛ a ŋguh wɛɛ le bɛ booŋ be ba ŋgoo lɛ gɛ, booŋ be ba ŋgoo gɛ̀ ja bo gɛɛŋ bo maa. ");
INSERT INTO ncr_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Geenɛ, baŋguh bamu gɛ̀ bee bo ja je Tibɛlia, bo daŋ bo to mbebe kijusɛ kì Tada gɛ̀ jo blɛd fo wu nya kiyone Nyo le, bamii ji. ");
INSERT INTO ncr_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","No bamii bayu yɛŋ lɛ gɛ Jiso kɛnɛ booŋ be ba ŋgoo nyu fo gɛ, bo mo bo lee a baŋguh baa le, bo daŋ bo gɛɛŋ Kafanahum ki bo gooŋ Jiso. ");
INSERT INTO ncr_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bo doo bo gɛɛŋ bo yɛŋ wu le wuŋ kwege, bo biih wu le lɛ, “Labai, wo tu to fɛnɛ sege la?” ");
INSERT INTO ncr_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jiso chvuu bo le lɛ, “Nsɛŋe bɛŋ nchiɛɛŋ nchiɛɛŋ lɛ gɛ bɛŋ goone mɛ nyu nje mwɛɛ mù duunyi bvukugɛ bwaŋ bvu bɛŋ yɛde ŋgee le gɛ. Bɛŋ goone mɛ nyu nje bɛŋ chi bɛŋ ji chefe yi blɛd chiɛɛ bɛŋ fuu. ");
INSERT INTO ncr_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Keefɛ bɛŋ lɛ̂ne gɛh ki bɛŋ kɛ̂me nyu mwɛɛ munjile mù taŋlo mu chɛŋe gɛ. Bɛŋ lɛ̂ne ki bɛŋ kɛ̂me mwɛɛ munjile mù le mu mɛ gɛh mu nyume yu gɛɛŋ bu yi kinche kì kage gɛ le. Mu munɛ le mu, mù muh wù jee che le Mwamuh lé wu gê wu nyâ bɛŋ le. Le wu wù Nyo wu le Chiji le wu gɛɛ njiŋɛ we yi ye ye le ki wu dûnyɛ lɛ wu lé wu bɛ̂ɛŋ wu.” ");
INSERT INTO ncr_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Bo mo bo biih wu le lɛ, “Mwɛɛ mù bee kɛme ki be gêe mu mo mu nyû lɛ bee gee nyu lɛme chi Nyo le mù la?” ");
INSERT INTO ncr_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jiso chvuu bo le lɛ, “Lɛme chi Nyo le chinɛ chi le lɛ, bɛŋ lêesɛ muntele yi muh wù wu le wu tuŋ le.” ");
INSERT INTO ncr_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Noo, bo mo bo biih wu le lɛ, “Fiɛɛ fì duunyi bvukugɛ bwuŋ fì wo taŋlo wo ge lɛ bee yɛŋ bee mo be leesɛ muntele yi ye yo le, le la? Fiɛɛ fì wo taŋlo wo ge le la? ");
INSERT INTO ncr_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Bachiji besa gɛ̀ ji mana kwa, nyu no ba saŋ lɛ, ‘Wu gɛ̀ nya bo bɛ mwɛɛ munjile mù jade woŋ wù fɛwe le bo ji.’” ");
INSERT INTO ncr_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","No bo jɛmɛ noo, Jiso mo wu chvuu bo le lɛ, “Nsɛŋe bɛŋ nchiɛɛŋ nchiɛɛŋ lɛ gɛ gɛ̀ bee Musɛ wù gɛ̀ nya mwɛɛ munjile mù jade woŋ wù fɛwe bɛŋ le gɛ. Le Chii wù gɛ̀ nya mwɛɛ munjile mù le mù nchiɛɛŋ mù jade fɛwe. ");
INSERT INTO ncr_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Bɛŋ kêe lɛ mwɛɛ munjile mu Nyo, le mumwɛɛ mù ja fɛwe mu shii mu to mu nyaa kinche bamii ba yi woŋ kfunɛ le.” ");
INSERT INTO ncr_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Bo jɛmɛ wu le lɛ, “Tada, wo nyâa bee bɛ mwɛɛ munjile munɛ segechii.” ");
INSERT INTO ncr_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jiso mo wu jɛmɛ bo le lɛ, “Nle mwɛɛ munjile mu nyaa kinche. Gɛ muh wù too fɛ mɛne baaŋ wu ka wu yuge jɛŋ gɛ. Muh wù le wu leesɛ fitele fie yi ye yaŋ le, gɛ kindoŋ baaŋ ki ka ki yune wu gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Geenɛ nle njɛmɛ wa bɛŋ le lɛ bɛŋ le bɛŋ yɛŋ mɛne, bɛŋ faŋ ki bɛŋ lêesɛ fitele ye yaŋ le. ");
INSERT INTO ncr_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bamii bachii ba Chii le wu nya mɛne le bo too fɛ mɛne. Muh wù too fɛ mɛne gɛ nyu ŋkuŋ bɛ wu gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nja fɛwe nto fɛkuu fɛnɛ. Gɛ nto ki ŋge nyu fiɛɛ fì goone mɛ gɛ. Nto ki ŋge nyu fiɛɛ fì muh wù tuŋ mɛ goone. ");
INSERT INTO ncr_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Fiɛɛ fì muh wu tuŋ mɛ goone le finɛ fì le lɛ, keefɛ nlɛsɛ lo muh wu mumwaa fɛ bamii ba wu le wu nya mɛne gɛ, geenɛ lɛ, nlé ŋgê mbvûsɛ lo bo yi kwe le juu chi fɛkimɛsɛ. ");
INSERT INTO ncr_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Bɛŋ kêe lɛ fiɛɛ fì Chii goone le finɛ fì le lɛ muh wuchii wù le wu yɛŋ Mwa ye le, wu leesɛ fitele yi ye ye le, wu lé wu kɛ̂me kinche kì kage gɛ, nlé ŋgê mbvûsɛ mwɛdɛ yi kwe le juu chi fɛkimɛsɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Bajuu mo bo kɛ bo tu bo shuŋshi kune wu nje wu gɛ jɛmɛ lɛ, “Nle mwɛɛ munjile mù ja fɛwe mu to fɛkuu fɛnɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Bo tu bo shuŋshi noo bo biide lɛ, “Wunɛ le gɛ Jiso wu le mwa Yosɛf? Gɛ chiji bɛ bwee nyu besabɛŋ kee bo gɛ?” Fi jiɛnyi nɛɛ mɛɛse fɛ wu tu wu duu lɛ, “Nja nyu fɛwe?” ");
INSERT INTO ncr_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jiso chvuu bo le lɛ, “Keefɛ bɛŋ shûŋshi lɛbɛŋlɛbɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Gɛ muh taŋlo wu to fɛ mɛne njɛ chile Chii wù tuŋ mɛ lɛ wu to fɛ mɛne sɛŋ gɛ. Nlé ŋge mbvûsɛ mwɛdɛ yi kwe le juu chi fɛkimɛsɛ. ");
INSERT INTO ncr_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Bamii ba ntuŋ wu Nyo gɛ̀ saŋ lɛ, ‘Nyo lé wu gê wu yɛ̂yɛ bo bachii.’ Noo muh wuchii wu le wu yu fiɛɛ fì Chii yɛyi wu kɛɛ, lé wu gê wu tô fɛ mɛne. ");
INSERT INTO ncr_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Gɛ njɛme nɛ lɛ muh le yu wu yɛŋ wa Chii le gɛ. Mɛ gɛh wuwɛɛ wù ja fɛ Nyo le wu le wu yɛŋ wa Chii le. ");
INSERT INTO ncr_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nsɛŋe bɛŋ nchiɛɛŋ nchiɛɛŋ lɛ, muh wu le wu bɛɛŋ lé wu kɛ̂mɛ kinche kì kage gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nle mwɛɛ munjile mù nyaa kinche bamii le. ");
INSERT INTO ncr_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Bachiji bena gɛ̀ ji mana kwa, geenɛ bo gɛ̀ kweeyɛ gɛ lo. ");
INSERT INTO ncr_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mwɛɛ munjile munɛ mu ja fɛwe mu to, nɛ muh le wu ji wu gɛ ka wu kwe gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nle mwɛɛ munjile mù ja fɛwe, mù nyaa kinche bamii le. Nɛ muh ji mwɛɛ munjile munɛ, wu mɛ gɛh wu nyume yu segechii. Mwɛɛ munjile munɛ mù nlé ŋgê nyâ wu lɛ bamii ba yi woŋ kfunɛ le kɛmɛ kinche nyu ye yaŋ.” ");
INSERT INTO ncr_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Bajuu mo bo ja bo kɛ bo tu bo waade lɛbolɛbo bo biide lɛ, “Muh wunɛ taŋlo wu ge nɛɛ fɛ wu nya ye ye lɛ bee ji?” ");
INSERT INTO ncr_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jiso mo wu jɛmɛ bo le lɛ, “Nsɛŋe bɛŋ nchiɛɛŋ nchiɛɛŋ lɛ bɛŋ baaŋ ji gɛ ye yi muh wù jee che le Mwamuh gɛ, bɛŋ mu tɛ kilɛmɛ ke gɛ, bɛŋ gɛ kɛme kinche ye yene le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Muh wù jii ye yaŋ wu ka muu kilɛmɛ kaŋ kɛme kinche kì kage gɛ. Nlé ŋgê mbvûsɛ wu yi kwe le juu chi fɛkimɛsɛ, ");
INSERT INTO ncr_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","nje ye yaŋ le lo mwɛɛ munjile, kilɛmɛ kaŋ le fiɛɛ fimule. ");
INSERT INTO ncr_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Muh wu jii ye yaŋ wu ka muu kilɛmɛ kaŋ wu chee yi ye yaŋ le mɛ tɛ nchee yi ye ye le. ");
INSERT INTO ncr_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Chii wù tuŋ mɛ kɛme kinche, ŋkɛme kinche nje Chii. Noo muh wu jii ye yaŋ le wù kɛme tɛ kinche nje mɛ. ");
INSERT INTO ncr_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Munɛ mwɛɛ munjile le mù ja fɛwe mu to. Gɛ mu nyu njɛ mwɛɛ mù bachiji bena gɛ̀ ji bo kweeyɛ lo gɛ. Muh wù jii munɛ mwɛɛ munjile wu lé wu mɛ̂ gɛh wu nyûme yu segechii.” ");
INSERT INTO ncr_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Mwɛɛ munɛ le mù Jiso gɛ̀ jɛme no wu gɛ̀ yɛyi bamii yeh yi buunɛ le Kafanahum. ");
INSERT INTO ncr_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Bamii ba Jiso ba ŋgoo ba duude yu n'yɛyɛ wunɛ bo ja bo jɛmɛ lɛ, “Wunɛ njɛmɛ tɛɛme baaŋ! Taŋlo bɛɛŋ yɛɛŋ wunɛ njɛmɛ?” ");
INSERT INTO ncr_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Geenɛ, Jiso kɛɛ lɛ bamii be ba ŋgoo lɛ shuŋshi lɛbolɛbo kune njɛmɛ wunɛ, wu mo wu biih bo le lɛ, “Fiɛɛ fì njɛme finɛ le fi shiŋshɛ muntele mwɛna? ");
INSERT INTO ncr_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Nɛ fi le noo, bɛŋ ge nɛɛ fɛ bɛŋ yɛŋ muh wù jee che le Mwamuh wu kaase wu bɛɛne fɛ wu gɛ̀ shee wù nyu fo fweele? ");
INSERT INTO ncr_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kiyo ki Nyo le fiɛɛ fì nyaa kinche. Gɛ nyaŋ ye kɛme lo fiɛɛ ki yi gê gɛ. Njɛmɛ wù njɛme bɛŋ le, le wu kiyo, le fiɛɛ fì nyaa kinche. ");
INSERT INTO ncr_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Geenɛ, bɛŋ bamu le bɛŋ yu bɛŋ baaŋ bɛɛŋ gɛ njɛmɛ wunɛ le gɛ.” Jiso gɛ̀ jɛme nɛ nje wu gɛ̀ kee wa fɛŋkɛɛ bamii ba baaŋ a leesɛ gɛ muntele yi ye ye le gɛ, wu kee tɛ muh wù lé wu gê wu gesɛ wu. ");
INSERT INTO ncr_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Wu ka wu jɛmɛ bo le lɛ, “Nɛ fiɛɛ fì mbe njɛmɛ wa bɛŋ le lɛ gɛ muh taŋlo wu to fɛ mɛne njɛ Chii le wu nya je wu le sɛŋ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ajiŋ ayu, bamii be ba ŋgoo ba duude mo bo chii bikaa a wu jiŋ bo gɛ ka bo jiɛnyi bɛ wu gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jiso ja wu biih booŋ be ba ŋgoo ba yuufe ncho bafɛɛ le lɛ, “Gɛ bɛŋ tɛ goone ki bɛŋ gɛ̂ɛŋ gɛ?” ");
INSERT INTO ncr_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Samoŋ Bita chvuu wu le lɛ, “Tada, bee gɛɛŋ nyu fɛ yɛɛŋ le. Kɛme wo njɛme wu nyaa kinche kì kage gɛ, ");
INSERT INTO ncr_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","bee le be bɛɛŋ wa, bee ka be kɛɛ lɛ le wo wɛɛ wu yuude wù ja fɛ Nyo le.” ");
INSERT INTO ncr_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jiso jɛmɛ bo le lɛ, “Cha gɛ mɛ bɛŋ ba yuufe ncho bafɛɛ banɛ? Geenɛ, muh mu a bɛŋ ntɛnɛɛ le debele.” ");
INSERT INTO ncr_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jiso gɛ̀ jɛme noo nyu kune Juda wù mwa Samoŋ Ɛkaliot. Wu gɛ̀ bee ŋgoo yi booŋ ba Jiso ba yuufe ncho bafɛɛ le, gɛ̀ bee wù wu gɛ̀ bee ki wu jîɛnyɛ wu gesɛ Jiso. ");
INSERT INTO ncr_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ajiŋ ayu Jiso mɛ gɛh wu jiɛnyi nyu kimbe kì Galalee le. Wu gɛ baaŋ ka gɛɛŋ gɛ kì Judia le gɛ, nje Bajuu gɛ̀ goone ki bo yuuyɛ wu. ");
INSERT INTO ncr_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kife ki Ŋka wu Bajuu wù ba gɛ̀ tɛŋe lɛ Ŋka wu Chúŋ gɛ̀ bee ki too wa mbebe le. ");
INSERT INTO ncr_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Booŋ ba bwe Jiso mo bo jɛmɛ wu le lɛ, “Jâ yanɛ wo gɛ̂ɛŋ Judia lɛ bamii buŋ ba ŋgoo yɛŋ lɛme chi wo lɛne le. ");
INSERT INTO ncr_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Muh nɛ lɛne lɛme wu goone lɛ bamii kɛɛ wu, wu gɛ ya wu lɛne nyilɛ le gɛ. No wo gee mwɛɛ munɛ, wo gɛ̂ɛŋ wo dûnyɛ kikwɛɛ kuŋ woŋ le.” ");
INSERT INTO ncr_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Booŋ ba bwee baa gɛ̀ jɛme noo nje bo gɛ̀ baaŋ leesɛ gɛ muntele muboo yi ye ye le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jiso chvuu bo le lɛ, “Kife kaŋ baaŋ a to gɛ. Fɛ bɛŋ le le kife kena to ki nyu ki kojɛ ka. ");
INSERT INTO ncr_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Gɛ bamii ba le ba yi woŋ kfunɛ le taŋlo bo banɛ bɛŋ gɛ. Geenɛ, bo banɛ mɛ nje njɛme bo le kune gee chiboo chì befe. ");
INSERT INTO ncr_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Bɛŋ bɛ̂ɛne fiena bɛŋ gɛɛne fɛ ŋka le. Gɛ mbɛɛŋ yo gɛ. Kife kaŋ baaŋ a to gɛ ki kojɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","No wu jɛmɛ noo, wu mo wu mɛ gɛh Galalee. ");
INSERT INTO ncr_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Geenɛ, sege booŋ ba bwee gɛ̀ bɛnɛ wa fɛ Ŋka wɛɛ le, wu gɛ̀ shɛɛ wu bɛɛŋ tɛ yo. Wu doo wu bɛɛne, wu bɛɛne bamii yɛde gɛ wu le gɛ, wu bɛɛne fie nyu nyilɛ le. ");
INSERT INTO ncr_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Fi gɛ̀ bee Bajuu goone wa wu fɛ Ŋka wɛɛ le, bo biide lɛ, “Wu le faaŋ mbɛŋ?” ");
INSERT INTO ncr_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Bamii gɛ̀ ja bo tu bo chuune kune wu baaŋ. Bamu bɛɛŋse lɛ, “Wu le muh wù joŋe.” Bamu kaji lo lɛ, “Wu lɛɛde lo bɛ bamii.” ");
INSERT INTO ncr_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Geenɛ, muh gɛ̀ baaŋ nyu gɛ yu wu le wu jɛmɛ kune wu fɛ waaŋ gɛ, nje bo gɛ faane bikwɛɛ bi Bajuu. ");
INSERT INTO ncr_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Aju a Ŋka gɛ̀ gade wa antɛnɛɛ, Jiso gɛɛŋ wu lee fɛ yeh yi kintanyɛ le wu yɛyi bamii. ");
INSERT INTO ncr_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Bikwɛɛ bi Bajuu tu bi yuge bi kɛme lo ŋgha, bi maŋe lɛ, “Muh wunɛ jiɛnyi nɛɛ fɛ wu tu wu kee mwɛɛ nɛ njɛ wu gɛ yɛyɛ wa Ŋwa wu Nyo sɛŋ.” ");
INSERT INTO ncr_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jiso mo wu ja wu jɛmɛ lɛ, “Gɛ n'yɛyɛ wu n'yɛyi wunɛ nyu waŋ gɛ. Le wu muh wu tuŋ mɛ. ");
INSERT INTO ncr_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Muh nɛ goone ki wù gee nyu fiɛɛ fì Nyo goone, wu mo wu kɛɛ lɛ laa n'yɛyɛ wunɛ jade nyu fɛ Nyo le noo, n'yɛyi a bvuŋga bwaŋ le la. ");
INSERT INTO ncr_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Muh wù jɛme nyu a bvuŋga bwe le to wu gôone mbɛɛŋsɛ nyu fɛ kikwɛɛ ke le. Geenɛ muh wù goone jee chì kuge nyu chi muh wù tuŋ wu to nyu muh wu nchiɛɛŋ, chimbiaŋ nyu gɛ yi ye ye le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musɛ gɛ̀ nya gɛ banchi bɛŋ le? Geenɛ, gɛ muh mu bɛŋ le gɛɛde banchi baa gɛ! Bɛŋ goone ki bɛŋ yûuyɛ mɛ nje la?” ");
INSERT INTO ncr_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Bamii baa chvuu wu le lɛ, “Wo kɛmɛ nchɛndaa wu debele yi ye yo le. Muh wù goone ki wu yûuyɛ wo le yɛɛŋ?” ");
INSERT INTO ncr_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jiso jɛmɛ bo le lɛ, “Ŋgɛ̀ ŋge lɛme chimimia bɛŋ tu bɛŋ kɛme lo ŋgha kune chi. ");
INSERT INTO ncr_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musɛ gɛ nya nchi lɛ bɛŋ chvûse booŋ yeh. Gɛ nchi wunɛ gɛ̀ bu mo nyu a Musɛ le gɛ. Wu gɛ̀ bu nyu a bachiji bena le. Bɛŋ mo bɛŋ tu bɛŋ chvuse booŋ yeh mo nyu juu chi yuuŋ. ");
INSERT INTO ncr_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nɛ ba chvuse muh ye juu chi yuuŋ keefɛ bo ŋgôde nchi wu Musɛ lɛ gɛ, bɛŋ tu bɛŋ yuge nsaasɛ bɛ mɛ lɛ nle nfɛ muh wu tɛmɛ ye yichii juu chi yuuŋ nje la? ");
INSERT INTO ncr_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Keefɛ bɛŋ sâge nsa bɛŋ suune bɛŋ baaŋ ya taa gɛ bɛŋ yɛŋ gɛ. Bɛŋ sâge a je yì kooji le.” ");
INSERT INTO ncr_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Bamii ba Yɛlusalɛm bamu mo bo ja bo biih lɛ, “Wunɛ le gɛ muh wu ba goone lɛ ba yuuyɛ? ");
INSERT INTO ncr_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Bɛŋ jîŋɛ bɛŋ yɛ̂ŋ nɛ wu wunɛ fɛnɛ wu jɛme wu chuunyi fɛ waaŋ njɛ muh jɛme fiɛɛ wu le sɛŋ. Taŋlo nyu lɛ bikwɛɛ bi woŋ le bi kɛɛ wa chuule lɛ muh wunɛ le Mbvusɛ wù Nyo gɛ̀ ka? ");
INSERT INTO ncr_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Geenɛ, besabɛŋ kee a muh wunɛ ja yo. Sege Mbvusɛ wù Nyo gɛ̀ ka lé wu gê wu tô gɛ muh nyu wu gê wu kɛ̂ɛ a wu ja yo gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Noo, Jiso gɛ̀ doo wu yɛyi bamii fɛ yeh yi kintanyɛ le wu ja wu jaŋ fɛwɛɛwe lɛ, “Bɛŋ kee mɛ, bɛŋ kee tɛ a nja yo. Geenɛ, gɛ nto fɛnɛ a bvuŋga bwaŋ le gɛ. Muh wù tuŋ mɛ le muh wù nchiɛɛŋ, bɛŋ ya kee gɛ wu gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ŋkee wu nje nja fɛ wu le, le wu wù tuŋ mɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","No wu jɛmɛ noo, bamii bamu mo bo tu bo goone ki bo koo wu. Geenɛ, muh gɛ̀ baaŋ kuŋ gɛ wu le gɛ, nje kife ke gɛ̀ baaŋ a to gɛ ki kojɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Geenɛ, bamii ba duude leesɛ muntele yi ye ye le bo tu bo duu lɛ, “Sege Mbvusɛ wù Nyo gɛ̀ ka lé wu gê wu tô, taŋlo wu ka wu ge mwɛɛ mu duunyi bvukugɛ bvu Nyo fede muh mu wunɛ ge wa?” ");
INSERT INTO ncr_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Bafalashii gɛ̀ doo bo yu no kinchvu ki bamii lɛ chuune kune Jiso, bɛ bachiji kintanyɛ ba baaŋ baaŋ mo bo tuŋ bamii ba nchi lɛ bo gɛɛŋ bo koo wu. ");
INSERT INTO ncr_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","No bo gɛnɛ, Jiso jɛmɛ lɛ, “Nlé nyûme besabɛŋ gɛh yi kife le nɛ shige, mɛ mo ŋkaasɛ ntu jiŋ fɛ muh wù tuŋ mɛ le. ");
INSERT INTO ncr_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Bɛŋ lé bɛŋ gê bɛŋ shɛ̂ɛ bɛŋ gôoŋ mɛ nɛ, bɛŋ gɛ ka bɛŋ yɛ̂ŋ mɛne gɛ. Fɛ ŋgɛɛne fo gɛ taŋlo bɛŋ tô fo gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Bajuu jɛmɛ bikwɛɛ biboo le lɛ, “Muh wunɛ goone ki wu gɛ̂ɛŋ nyu faane fɛ besabɛŋ lé be gê be gôoŋ wu bee gɛ ka be yɛ̂ŋ wu le gɛ? Wu goone ki wu gɛ̂ɛŋ nyu a bituŋ bi bamii besa gɛ̀ saaŋe bo gɛɛŋ bo tu bo chee bi le, wu gɛɛŋ wu yɛyi bamii ba bituŋ bi yo le? ");
INSERT INTO ncr_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Fiɛɛ fì wu duu lɛ, ‘Bɛŋ lé bɛŋ gê bɛŋ gôoŋ mɛ bɛŋ gɛ ka bɛŋ yɛ̂ŋ mɛne gɛ, fɛ ŋgɛɛne fo gɛ taŋlo bɛŋ tô fo gɛ’, wu jɛmɛ fi nyu lɛ la?” ");
INSERT INTO ncr_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Lɛ to nyu juu chi Ŋka chi fɛkimɛsɛ chì gɛ̀ bee juu chi Ŋka wɛɛ chi baaŋ, Jiso gɛ ja wu lɛɛŋ we wu jaŋ lɛ, “Nɛ kindoŋ yune muh, mwɛdɛ to fɛ mɛne wu mu fiɛɛ. ");
INSERT INTO ncr_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Muh wù le wu leesɛ fitele ye yaŋ le, fi lé fi nyû gɛh no Ŋwa wu Nyo jɛmɛ lɛ, ‘Joo yì nyaa kinche lé yi gê yi bûde a fitele fie le yi bohge nɛ kokokokoko.’” ");
INSERT INTO ncr_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Finɛ fiɛɛ Jiso gɛ̀ jɛme nyu kune Kiyo kì bamii ba gɛ̀ leesɛ fitele yi ye ye le lɛ bo lé bo gê bo kɛ̂mɛ. Gɛ̀ bee kife kinɛ le ba baaŋ a nya gɛ Kiyo kiyu bo le gɛ, nje Jiso gɛ̀ bee ba baaŋ a yuusɛ gɛ wa wu, ki wu lêe bvukugɛ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Bamii yu fiɛɛ finɛ fì Jiso gɛ jɛme, bamu jɛmɛ lɛ, “Muh wunɛ le Muh wu Ntuŋ wù Nyo wɛɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bamu jɛmɛ lɛ, “Wunɛ le Mbvusɛ wù Nyo gɛ̀ ka.” Geenɛ, bamu biih fiboo lɛ, “Mbvusɛ wù Nyo gɛ̀ ka gɛ̀ kɛme ki wu bû nyu Galalee? ");
INSERT INTO ncr_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Gɛ Ŋwa wu Nyo jɛme lɛ Mbvusɛ wɛɛ lé wu gê wu bû nyu a kfuu chi Nfoŋ Dabi le, ntɛ wu Bɛtɛhɛm le, wu le ntɛ wu Dabi le?” ");
INSERT INTO ncr_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","No bamii jɛmɛ noo, kiŋgaye mo ki to a bo antɛnɛɛ kune Jiso. ");
INSERT INTO ncr_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bamii bamu bo le tu bo goone ki bo koo wu, geenɛ muh gɛ̀ baaŋ kuŋ gɛ wu le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Bamii ba nchi baa mo bo ja, bo kaasɛ bo tu jiŋ fɛ bachiji kintanyɛ ba baaŋ baaŋ le bɛ Bafalashii, bo biih bamii ba nchi baa le lɛ, “Bɛŋ baaŋ bɛ wu to gɛ nje la?” ");
INSERT INTO ncr_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Bamii ba nchi baa chvuu bo le lɛ, “Muh gɛ̀ baaŋ a yu gɛ wu jɛme gɛh njɛ muh wunɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Bafalashii biih bo le lɛ, “Wu le wu gɛɛŋ wa wu lɛɛ tɛ mo bɛ bɛŋ fo? ");
INSERT INTO ncr_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Bɛŋ le bɛŋ yɛŋ bikwɛɛ bi woŋ, kɛnɛ Bafalashii leesɛ fitele yi ye ye le? ");
INSERT INTO ncr_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Le gɛ kinchvu kinɛ ki ya kee gɛ nchi wù Nyo gɛ. Loŋ le fɛ bo fwa.” ");
INSERT INTO ncr_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodɛmu wù gɛ̀ bee muh mu ŋgoo yi Bafalashii le, wu gɛ̀ gɛɛŋ wa juu chimi wu yɛŋ Jiso le, wu gɛ̀ bee fo. Wu biih bo le lɛ, ");
INSERT INTO ncr_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nchi wese besabɛŋ le wu bɛɛŋ lɛ ba suune nsa wu muh ba baaŋ yegɛ gɛ ba yu fiɛɛ fì wu jɛme le gɛ?” ");
INSERT INTO ncr_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Bo mo bo biih wu le lɛ, “Wo ja tɛ Galalee le? Talɛ a Ŋwa wu Nyo le chuule wo yɛŋ lɛ gɛ taŋlo muh wu ntuŋ wu Nyo wumu yu wu to wu bu Galalee la.” ");
INSERT INTO ncr_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Bo mo bo jade wu mumwaa mumwaa bo tuu yéh yiboo le. ");
INSERT INTO ncr_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jiso ja wu bɛɛŋ fie nyu yi Mbegɛ wu Bite bi Olif le. ");
INSERT INTO ncr_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Akfuuŋ bu a yuu, wu ka wu kaasɛ wu gɛɛŋ fɛ yeh yi kintanyɛ le. Bamii bachii taashɛ mbebe ye le, wu mo wu shii fɛkuu wu tu wu yɛyi bo. ");
INSERT INTO ncr_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Bamii ba gɛ̀ duunyi banchi bɛ Bafalashii ja bo to bɛ kwɛse wumu wu ba kole wu wu gime bɛ jwɛŋsɛ wumu. No bo to bɛ wu, bo leesɛ wu a bo fwe, ");
INSERT INTO ncr_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","bo jɛmɛ Jiso le lɛ, “Muh N'yɛyɛ, kwɛse wunɛ le ba koo wu, wu gime bɛ jwɛŋsɛ wumu. ");
INSERT INTO ncr_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","A banchi le, Musɛ gɛ̀ du lɛ wunɛ kwɛse le wu ba tumɛ lo bɛ ata wu kwe. Wo le wo jɛmɛ fiuŋ lɛ la?” ");
INSERT INTO ncr_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bo gɛ̀ gee noo bo tele lo Jiso laa wu lé wu lôŋsɛ njɛmɛ bo mo bo kɛ̂me fiɛɛ fì bo kôoyi yi ye ye le lɛ. Geenɛ, Jiso ŋgvuusɛ wu tu wu saŋe fiɛɛ fɛkuu bɛ nyi yi kwaŋ. ");
INSERT INTO ncr_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bo mɛ gɛh bo lɛme fo bo dode. Wu ja wu lɛɛŋ we wu jɛmɛ bo le lɛ, “Nɛ muh le yu a bɛŋ ntɛnɛɛ wù kɛme gɛ kimbefɛ gɛ, wù nyu muh wù fwe wù to wu ya wu tuŋ kwɛse wunɛ bɛ tɛdɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","No Jiso jɛmɛ noo, wu ka wu kaasɛ wu ŋgvuusɛ wu tu wu saŋe fiɛɛ fɛkuu bɛ nyi yi kwaŋ. ");
INSERT INTO ncr_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","No bo yu fiɛɛ fì Jiso jɛme, bo mo bo kɛ bo tu bo saaŋe wu mumwaa wu mumwaa bo gɛɛne kɛge yi ŋgaamii le. Bo saaŋe noo, kwɛse wɛɛ shɛɛ wu tu wu lɛme fo bɛ Jiso maa. ");
INSERT INTO ncr_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jiso kaasɛ wu lɛɛŋ we, wu biih kwɛse wɛɛ le lɛ, “Kwɛse, bo le faaŋ? Muh baaŋ nyu gɛ yu wu du lɛ wo kɛme gɛh ki wo kwê gɛ?” ");
INSERT INTO ncr_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Wu chvuu lɛ, “Muh baaŋ nyu gɛ yu gɛ, Tada.” Jiso mo wu jɛmɛ lɛ, “Gɛ taŋlo ndu tɛ lɛ wo kɛme ki wo kwê gɛ. Gɛ̂nɛ la, geenɛ keefɛ wo gɛ̂ɛŋ wo ka wo gêe kimbefɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jiso ka wu jɛmɛ bamii baa le lɛ, “Le mɛ wù le n'yulɛ wu yi woŋ kfunɛ le. No nyu yɛɛŋ wu bii mɛne gɛ taŋlo wu jiɛnyi kijibɛ le gɛ. Wu lé wu kɛ̂mɛ n'yulɛ wù nyaa kinche bamii le.” ");
INSERT INTO ncr_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Bafalashii mo bo jɛmɛ wu le lɛ, “Wo bɛɛyi jiŋ yi nsa fɛ kikwɛɛ kuŋ le. Fiɛɛ fì wo jɛme gɛ fi kooji gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jiso chvuu bo le lɛ, “Mɛ, nɛ mbɛɛyi jiŋ yi nsa fɛ kikwɛɛ kaŋ le, tu fiɛɛ fì njɛme kooji lo, nje ŋkee fɛ nja fo, ŋkee tɛ fɛ ŋgɛɛne fo. Geenɛ, gɛ bɛŋ kee fɛ nja fo gɛ, kɛnɛ fɛ ŋgɛɛne fo gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Bɛŋ sage bamii njɛ bamii ba wuŋ. Gɛ nsage fiaŋ muh gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Geenɛ, mbe nsage lo muh, tu nsage a je yì kooji le, nje gɛ nsage mɛ maa gɛ. Nsage besa Chii wù tuŋ mɛ. ");
INSERT INTO ncr_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","A ŋwa wene wu banchi le ba le ba saŋ lɛ, nɛ bamii bɛɛyi jiŋ yi nsa wu fiɛɛ bafɛɛ, tu le nchiɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mbɛɛyi jiŋ yi nsa fɛ kikwɛɛ kaŋ le, Chii wù tuŋ mɛ bɛɛ tɛ jiŋ yi nsa waŋ.” ");
INSERT INTO ncr_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Bo mo bo biih wu le lɛ, “Chijo le faaŋ?” Jiso chvuu lɛ, “Gɛ bɛŋ kee mɛ gɛ kɛnɛ Chijaŋ gɛ. Nɛ bɛŋ be kee mɛ, tu bɛŋ be kee tɛ Chijaŋ.” ");
INSERT INTO ncr_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jiso gɛ̀ jɛme mwɛɛ munɛ no wu gɛ̀ yɛyi bamii fɛ yeh yi kintanyɛ le mbebe fɛ bo to bo nyaa bige bi yeh yi kintanyɛ le. Geenɛ, muh gɛ̀ baaŋ koo gɛ wu gɛ, nje kife ke gɛ̀ baaŋ a kojɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jiso ka wu jɛmɛ bo le lɛ, “Nlé ŋgê ŋgɛ̂ɛŋ, bɛŋ shɛ̂ɛ bɛŋ gôoŋ mɛ bɛŋ jiɛnyɛ bɛŋ kwe bɛ bimbefɛ biɛna. Fɛ ŋgɛɛne fo gɛ taŋlo bɛŋ to fo gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Bajuu mo bo biih lɛ, Wu lé wu gê wu yûuyɛ kikwɛɛ ke, no wu du lɛ, “Fɛ ŋgɛɛne fo gɛ taŋlo bɛŋ to fo gɛ?” ");
INSERT INTO ncr_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jiso jɛmɛ bo le lɛ, “Bɛŋ ja fɛkuu fɛnɛ, nja fiaŋ fɛwe. Bɛŋ le bamii ba le ba yi woŋ kfunɛ le. Gɛ mɛ nyu muh wu yi woŋ kfunɛ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Njɛmɛ wa lɛ bɛŋ lé bɛŋ gê bɛŋ kwêeyɛ antɛnɛɛ a bimbefɛ biɛna. Bɛŋ kêe lɛ bɛŋ lé bɛŋ gê bɛŋ kwêeyɛ antɛnɛɛ a bimbefɛ biɛna fɛnɛ bɛŋ baaŋ bɛɛŋ gɛ lɛ le mɛ wuyu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bo biih wu le lɛ, “Le wo wu yɛɛŋ?” Jiso chvuu lɛ, “Nle muh wù nchi nto nsɛŋe bɛŋ le kune wu kɛge fɛŋkɛɛ. ");
INSERT INTO ncr_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ŋkɛme mwɛɛ wesee mù ntaŋlo njɛme kune bɛŋ bɛ mwɛɛ wesee mù ntaŋlo nsa bɛŋ yu. Geenɛ, muh wù tuŋ mɛ le muh wù nchiɛɛŋ. Fiɛɛ fì nsɛŋe woŋ le le fì n'yu a wu le.” ");
INSERT INTO ncr_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","No wu jɛmɛ noo, bo gɛ kɛɛ lɛ wu jɛme bo le nyu kune Chiji gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Noo Jiso mo wu jɛmɛ bo le lɛ, “Sege bɛŋ lé bɛŋ gê bɛŋ shɛ̂ŋshɛ muh wù jee che le Mwamuh fɛwe, bɛŋ mo bɛŋ kɛɛ lɛ le mɛ wuyu, bɛ lɛ gɛ ŋgee fiɛɛ fimi a bvuŋga bwaŋ le gɛ, lɛ njɛme nɛ le noo no Chii yɛyi mɛ. ");
INSERT INTO ncr_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Muh wù tuŋ mɛ le besa wu. Gɛ wu baaŋ wu chine mɛne lɛ mɛ nyu mɛ maa gɛ, nje nto ŋgee fiɛɛ segechii nyu fì joŋe fɛ wu le.” ");
INSERT INTO ncr_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","No Jiso gɛ̀ jɛmɛ mwɛɛ munɛ nɛ, bamii ba duude lee muntele yi ye ye le. ");
INSERT INTO ncr_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jiso mo wu jɛmɛ wa nyu Bajuu ba gɛ̀ leesɛ muntele yi ye ye le lɛ, “Bɛŋ nɛ mɛ gɛh bɛŋ lɛme yi jɛ yaŋ le, bɛŋ nyûme bamii baŋ ba nchiɛɛŋ ba ŋgoo, ");
INSERT INTO ncr_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","bɛŋ mo bɛŋ kɛɛ nchiɛɛŋ wuyu wu ge bɛŋ bu yi bvunfa le.” ");
INSERT INTO ncr_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bo chvuu wu le lɛ, “Bee le kfuu chi Ablaham, bee gɛ̀ baaŋ a nyu gɛ nfa chiaaŋ yi muh mu le gɛ. Fi jiɛnyi nɛɛ fɛ wo duu lɛ bee lé be gê be bû yi bvunfa le?” ");
INSERT INTO ncr_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jiso chvuu bo le lɛ, “Nsɛŋe bɛŋ nchiɛɛŋ nchiɛɛŋ lɛ muh wuchii wù gee kimbefɛ le nfwa wu kimbefɛ. ");
INSERT INTO ncr_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Gɛ nfwa to wu mɛ gɛh wù nyu muh wu yeh yi wu le yu segechii gɛ. Le mɛ gɛh mwa yeh wù to wù nyu muh wu yeh yiyu le segechii. ");
INSERT INTO ncr_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Noo, nɛ Mwa bvuse bɛŋ yi bvunfa le, tu bɛŋ le bɛŋ bu wa bvu le nchiɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ŋkee lɛ bɛŋ le kiŋgogɛ ki Ablaham, geenɛ bɛŋ goone gɛh ki bɛŋ yûuyɛ mɛ nje gɛ jɛ yaŋ kɛme kijusɛ yi ye yene le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Njɛme nyu fiɛɛ fì n'yɛŋ a Chii le, bɛŋ gee fiena nyu fiɛɛ fì bɛŋ yu a chiji wene le.” ");
INSERT INTO ncr_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bo chvuu wu le lɛ, “Ablaham le Chiji wese.” Jiso jɛmɛ bo le lɛ, “Nɛ bɛŋ bee booŋ ba Ablaham, tu bɛŋ be bɛŋ gee fiɛɛ nyu fi Ablaham gɛ̀ gee. ");
INSERT INTO ncr_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nle nsɛɛŋ bɛŋ nchiɛɛŋ wu n'yu a Nyo le. Geenɛ, mɛɛse bɛŋ goone ki bɛŋ yûuyɛ lo mɛ, gɛ finɛ fiɛɛ nyu fi fì Ablaham gɛ̀ gee gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Bɛŋ gee nyu fiɛɛ fì chiji wene gee.” Bo, jɛmɛ wu le lɛ, “Gɛ bee nyu booŋ ba ba boyi kuu gɛ. Bee kɛme Chiji wese wu mumwaa, nyu Nyo.” ");
INSERT INTO ncr_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jiso jɛmɛ bo le lɛ, “Nɛ Nyo be bee nyu chiji wene, tu bɛŋ be koŋe mɛ, nje nja nyu fɛ Nyo le, fɛ nto. Gɛ nto a bvuŋga bwaŋ le gɛ. Tuŋ wu mɛ. ");
INSERT INTO ncr_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Le nje la fi bɛŋ yuge gɛ fiɛɛ fì njɛme gɛ? Gɛ nyu nje bɛŋ le bɛŋ faŋ ki bɛŋ yû jɛ yaŋ le? ");
INSERT INTO ncr_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Bɛŋ le booŋ bachiji wene wu debele, fiɛɛ fì bɛŋ goone le ki bɛŋ gêe nyu fiɛɛ fì chiji wene goone. Wu gɛ̀ bee wa muh wù yuuyi bamii kɛge lo fɛŋkɛɛ. Gɛ wu kɛme fiɛɛ ki wu gê bɛ nchiɛɛŋ gɛ, nje gɛ nchiɛɛŋ nyu lo yi ye ye le gɛ. Wu ge doo wu mbiane chimbiaŋ wu jɛme gɛh nyu no gee che le, nje wu le muh wu chimbiaŋ wù nyu chiji chimbiaŋ. ");
INSERT INTO ncr_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Geenɛ, nsɛŋe fiaŋ nyu nchiɛɛŋ, le fiɛɛ fì bɛŋ baaŋ bɛɛŋ gɛ mɛne gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Le yɛɛŋ a bɛŋ ntɛnɛɛ wu taŋlo wu dunyɛ fiɛɛ fì befe fì nle ŋge? No, fiɛɛ fì nsɛŋe bɛŋ le le nchiɛɛŋ, ge la lɛ keefɛ bɛŋ bɛ̂ɛŋ mɛne gɛ? ");
INSERT INTO ncr_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Muh wu le muh wù Nyo wu to wu yuge jɛ yi Nyo. Fiɛɛ fì bɛŋ yuge gɛ jɛ yi Nyo gɛ le nje gɛ bɛŋ nyu bamii ba Nyo gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Bajuu mo bo jɛmɛ Jiso le lɛ, “Gɛ bee be be sɛɛŋ wa nchiɛɛŋ lɛ wo nɛ wo nyu muh wu Samaliya nchɛndaa debele nyu yi ye yo le gɛ?” ");
INSERT INTO ncr_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jiso chvuu bo le lɛ, “Gɛ nchɛndaa wu debele nyu yi ye yaŋ le gɛ. Ŋgvuune fiaŋ Chii, geenɛ bɛŋ ŋgvuune gɛ mɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Gɛ ŋgôone mbɛɛŋsɛ fɛ kikwɛɛ kaŋ le gɛ. Muh le yu wu mumwaa wù goone fiɛɛ fiyu, nyu wu wù suune bansa. ");
INSERT INTO ncr_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nsɛŋe bɛŋ nchiɛɛŋ nchiɛɛŋ lɛ muh nɛ yuge jɛ yaŋ, wu gɛ yu wu to wu kwe gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Bajuu jɛmɛ wu le lɛ, “Bee le be kɛɛ wa mɛɛse lɛ nchɛndaa wu debele le yi ye yo le. Ablaham gɛ̀ kwe wa, bamii ba ntuŋ wu Nyo kweeyɛ tɛ, wo tu wo duu lɛ muh yuge jɛ yo le, wu gɛ ka wu yu wu to wu kwe gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Wo fede chiji wese wù Ablaham wù gɛ̀ kwe wa, wo fede tɛ bamii ba ntuŋ wu Nyo ba gɛ̀ kweeyɛ baa? Wo kwaji lɛ wo le la?” ");
INSERT INTO ncr_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jiso chvuu bo le lɛ, “Nɛ le lɛ mbɛɛŋse kikwɛɛ kaŋ, tu fifiɛɛ le achiji. Le Chii wù bɛɛŋse mɛ, nyu wu wù bɛŋ duu lɛ le Nyo wene. ");
INSERT INTO ncr_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Geenɛ, gɛ bɛŋ kee wu gɛ. Kee gɛh mɛ wù. Nɛ nja njɛme lɛ gɛ ŋkee wu gɛ, tu nle muh wu chimbiaŋ njɛ bɛŋ. Geenɛ, no fi le, le mɛ wù kee wu, n'yuge jɛ ye le. ");
INSERT INTO ncr_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Chiji wene wù Ablaham gɛ̀ bee wu laŋeye lɛ wu lé wu gê wu yɛ̂ŋ aju a waŋ le. Wu gɛ̀ yɛŋ, wu yuge njoŋ.” ");
INSERT INTO ncr_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Bajuu mo bo jaŋe lɛ, “Wo le njɛ wo bu wa biluŋ mbaanshɛŋ sɛŋ, tu nyu lɛ wo gɛ̀ yɛŋ wa Ablaham le?” ");
INSERT INTO ncr_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jiso chvuu bo le lɛ, “Nsɛŋe bɛŋ nchiɛɛŋ nchiɛɛŋ lɛ, fɛ Ablaham gɛ̀ bee ki wù nyu, mɛ nyume wa.” ");
INSERT INTO ncr_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Bo yu noo, bo mo bo jo ata lɛ bo tumɛ Jiso yu. Jiso mo wu nyilɛ wu bu yeh yi kintanyɛ le. ");
INSERT INTO ncr_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","No Jiso gɛ̀ doo wu jiɛnyi, wu yɛŋ jwɛŋsɛ wumu le ba gɛ̀ boyi wu wù nyu wa kinfeeŋ. ");
INSERT INTO ncr_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Booŋ bɛ ba ŋgoo, biih wu le lɛ, “Labai, gɛ̀ ge yɛɛŋ kimbefɛ fɛ ba boo muh wunɛ nyu wu feeŋ wa? Gɛ̀ ge muh wunɛ, noo bwee bɛ chiji le?” ");
INSERT INTO ncr_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jiso chvuu bo le lɛ, “Gɛ nyu muh wunɛ gɛ, kɛnɛ bwee bɛ chiji bò gɛ̀ ge kimbefɛ gɛ. Ba gɛ̀ boyi wu noo lɛ lɛme chi Nyo ge chi dunyɛ ye yi ye ye le. ");
INSERT INTO ncr_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Bee kɛme ki bee lɛ̂ne lɛme chi muh wù tuŋ mɛ baaŋ fɛnshɛ. Kintaŋ too lo nyu kife kì taŋlo wu gɛ lɛŋ fiɛɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Gɛɛne bude sege la no nle yi woŋ kfunɛ le, le mɛ wù le n'yulɛ wu yi woŋ kfunɛ le.” ");
INSERT INTO ncr_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","No Jiso jɛme njɛmɛ wunɛ, wu mo wu chvuuyɛ nchwene fɛkuu, wu tojɛ nshɛŋ wu mo wu yefɛ ajii a muh wɛɛ yu, ");
INSERT INTO ncr_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","wu mo wu jɛmɛ wu le lɛ, “Gɛ̂nɛ wo chûgɛ a Kinchvuuŋ ki Siloŋ le.” (Jee chi Siloŋ le lɛ, “Ba tuŋ lo.”) Wu mo wu gɛɛŋ wu chugɛ, wu kaase wu too wu yɛde wa mwɛɛ le. ");
INSERT INTO ncr_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Bamii ba gɛ̀ chee mbebe ye le, mo bamii ba gɛ̀ shee bo yɛde wu le njɛ muh kilɛgɛ bo tu bo ghaade lɛ, “Wunɛ le gɛh muh wɛɛ wu chi bee wu shiide wu lɛge kilɛgɛ?” ");
INSERT INTO ncr_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bamu tu bo duu lɛ, “Le wu.” Bamu lɛ, “Aay, wu fiɛɛnɛ lo wu.” Muh wɛɛ jɛmɛ lɛ, “Le mɛ wuyu.” ");
INSERT INTO ncr_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Noo, bo mo bo biih wu le lɛ, “Ajii a wo ge nɛɛ fɛ a gwenyɛ?” ");
INSERT INTO ncr_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Wu chvuu lɛ, “Muh wù ba tɛŋe lɛ Jiso be wu tojɛ nshɛŋ wu yefɛ ajii a waŋ yu, wu jɛmɛ lɛ ŋgɛ̂ɛŋ nchûgɛ Siloŋ. Mɛ mo ŋgɛɛŋ nchugɛ, ajii a waŋ mo a gwenyɛ ye.” ");
INSERT INTO ncr_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bo biih wu le lɛ, “Wu le faaŋ?” Wu chvuu lɛ, “Gɛ ŋkee gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Bo mo bo ja bo jo muh wɛɛ wu gɛ̀ shee wù nyu wu feeŋ bo gɛɛŋ bɛ wu fɛ Bafalashii le. ");
INSERT INTO ncr_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Juu chì Jiso gɛ̀ tojɛ nshɛŋ wu ka wu gwenyɛ ajii a muh wɛɛ yu gɛ̀ bee juu chi yuuŋ. ");
INSERT INTO ncr_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Bafalashii baa ka bo biih tɛ wu le no wu ge ajii awe kaa wo gwenyɛ. Wu chvuu bo le lɛ, “Wu be wu yefɛ ajii awaŋ bɛ nshɛŋ, ŋgɛɛŋ nchugɛ mɛ mo tu n'yɛde mwɛɛ le.” ");
INSERT INTO ncr_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Bafalashii mo bo jɛmɛ lɛ, “Gɛ muh wunɛ ja fɛ Nyo le gɛ, nje wu lɛne juu chi yuuŋ.” Bamu jɛmɛ fiboo lɛ, “Taŋlo muh wù gee bimbefɛ jiɛnyɛ nɛɛ fɛ wù gee kfuu chi munɛ mwɛɛ mù duunyi bvukugɛ bvu Nyo?” Kiŋgaye mo ki to a bo ntɛnɛɛ. ");
INSERT INTO ncr_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Bo ka bo kaasɛ bo biih muh wɛɛ le lɛ, “Wo jɛme fiuŋ lɛ la kune muh wɛɛ no wu be gwenyɛ ajii awo?” Wu chvuu lɛ, “Muh wɛɛ le muh wu ntuŋ wu Nyo.” ");
INSERT INTO ncr_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Gɛ Bajuu gɛ̀ bɛɛŋ lɛ muh wɛɛ gɛ̀ shee wù nyu wu feeŋ gɛ fɛ ba gwenyɛ ajii awe gɛ. Ba gɛ jiɛnyɛ ba tɛɛŋ bwee bɛ chiji bo to. ");
INSERT INTO ncr_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ba biih bo le lɛ, “Wunɛ le gɛ mwa wene wù bɛŋ duu lɛ ba gɛ̀ boo wu wù nyu wa kinfeeŋ? Wu ge nɛɛ fɛ wu ka wu yɛde mwɛɛ le mɛɛse?” ");
INSERT INTO ncr_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Bwee bɛ chiji chvuu lɛ, “Bee kee lo lɛ wunɛ le mwa wese wù bee gɛ̀ boyɛ wù nyu wu feeŋ wa. ");
INSERT INTO ncr_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Geenɛ, kɛnɛ fi tu ge nɛɛ fɛ wu tu wu yɛde mwɛɛ le mɛɛse gɛ̀ bee kɛɛ gɛ. Gɛ bee kɛɛ tɛ muh wu gwenyi ajii awe gɛ. Bɛŋ, biih nyu wu le. Wu le wa muh wu a jii yuu wu. Wu taŋlo wu jɛmɛ fɛ kikwɛɛ ke le.” ");
INSERT INTO ncr_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Bwee bɛ chiji gɛ̀ jɛme noo nje bo gɛ̀ faane Bajuu, fi nyu Bajuu gɛ̀ leesɛ wa lɛ muh moŋ lo wu jɛmɛ bɛ jwe we lɛ Jiso le Mbvusɛ wù Nyo gɛ̀ ka, ba kuŋ lo mwɛdɛ yeh yi buunɛ le. ");
INSERT INTO ncr_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Le fiɛɛ fì bwee bɛ chiji gɛ̀ jɛmɛ lɛ wu le wa muh wu ajii yuu wu, lɛ bo biih nyu wu le. ");
INSERT INTO ncr_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Yi kiŋgane kinfɛɛ le, bo ka bo tɛɛŋ muh wɛɛ wù gɛ̀ shee wù nyu wu feeŋ wa, bo jɛmɛ wu le lɛ, “Tee fiɛɛ fì nchiɛɛŋ mbɛɛŋsɛ gɛ̂ɛŋ fɛ Nyo le. Bee kee fiesa lɛ muh wunɛ le muh wù gee bimbefɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Wu chvuu lɛ, “Kɛnɛ wù gee bimbefɛ, tu gɛ ŋkee gɛ. Fiɛɛ fimimia fì ŋkee le gɛh lɛ nchi mbee nyu nfeeŋ, mɛɛse n'yɛde wa mwɛɛ le.” ");
INSERT INTO ncr_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Bo ka bo biih wu le lɛ, “Wu be ge nɛɛ bɛ wo? Wu be ge nɛɛ fɛ wu gwenyɛ ajii awo?” ");
INSERT INTO ncr_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Wu chvuu bo le lɛ, “Mbe nsɛɛŋ wa bɛŋ le, bɛŋ baaŋ koŋ gɛ ki bɛŋ yû gɛ. Bɛŋ ka goone ki bɛŋ yû bɛŋ ge la? Bɛŋ tɛ goone ki bɛŋ nyû bamii be ba ŋgoo lɛ?” ");
INSERT INTO ncr_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Bo naanyɛ lo wu bo jɛmɛ lɛ, “Le wo wu le muh we wu ŋgoo. Bee le fiesa bamii ba ŋgoo ba Musɛ. ");
INSERT INTO ncr_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Bee kee lo lɛ Musɛ le wu wù Nyo gɛ̀ shee wu jɛme bɛ wu. Geenɛ muh wunɛ gɛ̀ bee kee a wu bu yo gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Muh wɛɛ chvuu lɛ, “Habaay! Finɛ le lo kiŋgha ki fiɛɛ lɛ! Bɛŋ duu lɛ gɛ bɛŋ kee a wu bu yo gɛ? Geenɛ wu le wu gwenyɛ ajii awaŋ. ");
INSERT INTO ncr_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Bee kee lo lɛ gɛ Nyo to wu yuge buunɛ chi muh wù gee bimbefɛ gɛ. Geenɛ, muh nɛ ŋgvuune Nyo, wù gee fiɛɛ fì wu goone, tu Nyo lé wu yûge buunɛ che. ");
INSERT INTO ncr_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kɛge no woŋ gɛ̀ kɛ bo gɛ̀ baaŋ a yu gɛ lɛ muh le wu gwenyɛ ajii a muh wu ba gɛ̀ boyɛ wu wù nyu wu feeŋ wa gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nɛ fi be baaŋ nyu gɛ lɛ muh wunɛ ja fɛ Nyo le gɛ, tu gɛ wu bee no wu ge fiɛɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Bo jɛmɛ wu le lɛ, “Wo le ba gɛ̀ boyi wo wuchii a bimbefɛ ntɛnɛɛ, wo tu wo goone ki wo yɛ̂yi bee?” No bo jɛmɛ noo, bo mo bo kuŋ wu a bo ntɛnɛɛ. ");
INSERT INTO ncr_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","No Jiso yu lɛ ba le ba kuŋ wa muh wɛɛ a bo ntɛnɛɛ, wu gooŋ wu wu yɛŋ wu le, wu biih wu le lɛ, “Wo le wo leesɛ fitele yi muh wù jee che le Mwamuh le?” ");
INSERT INTO ncr_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Wu biih lɛ, “Muh wɛɛ le yɛɛŋ chii? Gɛh sɛɛŋ mɛ, wu lɛ nlee fitele yi ye ye le.” ");
INSERT INTO ncr_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jiso jɛmɛ wu le lɛ, “Wo le wo yɛŋ wa wu le. Le wu wù bena wu jɛme mɛɛse.” ");
INSERT INTO ncr_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Muh wɛɛ mo wu jɛmɛ lɛ, “Tada nle nleesɛ.” No wu jɛmɛ noo, wu mo wu tuŋ anyuu a wu fwe wu nya ŋgvunɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jiso jɛmɛ lɛ, “Nto yi woŋ kfunɛ le lɛ ba sa bamii, ba yɛde gɛ mwɛɛ le gɛ bo yɛ̂ne, bo yɛde mwɛɛ le, tu binfeeŋ.” ");
INSERT INTO ncr_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","No Jiso jɛmɛ noo, Bafalashii ba gɛ̀ bee mbebe ye le bo yu bo mo bo biih wu le lɛ, “Bee tɛ le binfeeŋ?” ");
INSERT INTO ncr_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jiso jɛmɛ bo le lɛ, “Nɛ bɛŋ bee binfeeŋ, tu chiaaŋ yene bee yɛse yi bimbefɛ le. Geenɛ mɛɛse bɛŋ duu lɛ bɛŋ yɛde mwɛɛ le, bimbefɛ biɛna le bi mɛ gɛh yi bikwɛɛ biɛna le.” ");
INSERT INTO ncr_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Nsɛŋe bɛŋ nchiɛɛŋ nchiɛɛŋ lɛ, muh wù leese a kitaŋ ki shóŋ le, wu baaŋ lee gɛ nyu fɛ jwe wu kitaŋ le gɛ, wu bɛɛŋ lo yi kitaŋ le fɛ wu lee, tu wuwɛɛ muh le choŋ, nyu muh wù lode mwɛɛ bɛ bvuŋga. ");
INSERT INTO ncr_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Geenɛ muh wù chiɛɛne shóŋ to wu leese fie nyu fɛ jwe wu kitaŋ le. ");
INSERT INTO ncr_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Wuwɛɛ muh le muh, wù muh wù chiɛɛne jwe wu kitaŋ to wu gwenyɛ jwe wu kitaŋ, wu lee wu tɛɛŋ shóŋ ye a jee le, yi yu jɛ ye, wu mo wu jo wu bu bɛ yi akfuuŋ. ");
INSERT INTO ncr_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Sege wu bvusɛ shóŋ ye yichii akfuuŋ, wu mo wu gɛɛne fwe wu tɛŋe shóŋ yiyu yi bii wu le, nje yi kee jɛ ye. ");
INSERT INTO ncr_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Nɛ le muh wu nchɛ, yi gɛ bi wu le gɛ. Yi tu yi lege lo wu, nje gɛ yi kee jɛ yi muh wu nchɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","No Jiso ma ŋgaŋ wunɛ bo le noo, bo gɛ kɛɛ fiɛɛ fì wu jɛme bo le a ŋgaŋ wɛɛ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Noo, Jiso ka wu jɛmɛ bo le lɛ, “Nsɛŋe bɛŋ nchiɛɛŋ nchiɛɛŋ lɛ le mɛ wù le jwe wu kitaŋ fɛ shóŋ fede fo. ");
INSERT INTO ncr_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bamii bachii ba gɛ̀ sa mɛ fwe gɛ̀ bee bachoŋ mo bamii ba lode mwɛɛ a bvuŋga le. Noo shóŋ gɛ̀ baaŋ yu gɛ fiɛɛ fì bo gɛ̀ jɛme gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Le mɛ wù le jwe wu kitaŋ. Muh fe yi ye yaŋ le fɛ wu lee, tu wu lé wu gê wu bônɛ. Wu lé wu gê wu nyû njɛ shoŋ yì bude yi gɛɛne yi jii mwɛɛ yi kaase yi tuu jiŋ a kitaŋ le. ");
INSERT INTO ncr_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Choŋ to wu too gɛh ki wu chôŋ lo, bɛ ki wu yû lo, mo ki wu chɛ̂ŋe lo bɛ fiɛɛ. Nto fiaŋ lɛ bamii kɛmɛ nyu kinche, kinche ki yisɛ chuule. ");
INSERT INTO ncr_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Le mɛ wù le nchiɛnɛ shóŋ wù joŋe. Nchiɛnɛ shóŋ wù joŋe nyaa kinche ke ki wu kwê nje shóŋ ye. ");
INSERT INTO ncr_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Muh wù ba jo gɛh lo wu lɛme le, njɛ le muh wù chiɛɛne shóŋ sɛŋ, gɛ shóŋ nyu ye gɛ, wu yɛŋ kfuula too, wu mo wu noŋ shóŋ wu fɛɛ lo, kfuula mo wu shɛɛ wu kooyɛ shóŋ yimi, yimi saaŋɛ. ");
INSERT INTO ncr_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Wu to wu lege nje ba jo lo wu lɛme le, wu kwe gɛ fiɛɛ fɛ shóŋ chiɛɛ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Le mɛ wù le nchiɛnɛ shóŋ wù joŋe. Ŋkee shóŋ yì le yaŋ, shóŋ yaŋ kee tɛ mɛ, ");
INSERT INTO ncr_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","gɛh yɛɛŋyɛɛŋ no Chii kee mɛ, ŋkee tɛ Chii, nle nnya kinche kaŋ ki ŋkwe nje shóŋ yaŋ. ");
INSERT INTO ncr_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ŋkɛme tɛ shóŋ yimi yì le gɛ ŋgoo yinɛ le gɛ. Ŋkɛme ki nto bɛ yi tɛ yi yûge jɛ yaŋ, ŋgoo yaŋ yi shóŋ mo yi nyu yimimia nchiɛnɛ shóŋ le wu mumwaa. ");
INSERT INTO ncr_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Nle nnya kinche kaŋ ki ŋkwe wu lɛ taŋlo ŋkaasɛ nfi kinche kaŋ jiŋ. Nɛ fiɛɛ fì Chii koŋe mɛ yu. ");
INSERT INTO ncr_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Gɛ muh nyu yu wu fii kinche kaŋ gɛ. Nyaa mɛ kinche kaŋ a koŋ waŋ le. Ŋkɛme bvuŋga ki nnya kinche kaŋ ki ŋkwe, ŋkɛme bvuŋga ki ŋkaasɛ nfi kinche kaŋ jiŋ. Finɛ fiɛɛ le fì jɛmɛ Chii lɛ ŋgê.” ");
INSERT INTO ncr_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","No Jiso jɛmɛ mwɛɛ munɛ nɛ, kiŋgaye ka ki to antɛnɛɛ a Bajuu. ");
INSERT INTO ncr_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bamii ba duude bo tu bo duu lɛ, “Wu kɛme nchɛndaa wu debele, wu jede lo. Bɛŋ yege nyu la a wu le?” ");
INSERT INTO ncr_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Geenɛ bamu tu bo duu lɛ, “Gɛ banɛ bajɛme nyu ba muh wù kɛme banchɛndaa ba debele gɛ. Taŋlo nchɛndaa wu debele gwenyɛ ajii a kinfeeŋ?” ");
INSERT INTO ncr_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Gɛ̀ bee kife ki Ŋka wumu ki ba kwajɛ no ba gɛ̀ kaasɛ ba gwenyɛ yeh yi kintanyɛ Yɛlusalɛm, ");
INSERT INTO ncr_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jiso gɛɛŋ wu jiɛnyi fɛ yeh yi kintanyɛ le, fɛ ŋgaa wu Salamoŋ le. Sege kɛɛ gɛ̀ bee kife ki nfii. ");
INSERT INTO ncr_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Bajuu ja bo to bo tuŋ kiŋgaŋ bo tasɛ, bo biih wu le lɛ, “Wo lé wo gê wo chînɛ bee be mɛ̂ gɛh be ŋgɛ̂ɛme nɛ gɛ̂ɛŋ bû nɛɛ? Nɛ wo le Mbvusɛ wù Nyo gɛ̀ ka, wo sɛɛŋ bee le chaaŋ.” ");
INSERT INTO ncr_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jiso chvuu bo le lɛ, “Nle nsɛɛŋ wa bɛŋ le, bɛŋ baaŋ bɛɛŋ gɛ. Chilɛme chi ŋgee a jee chi Chii le, chi duunyi muh wu le mɛ. ");
INSERT INTO ncr_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Geenɛ bɛŋ baaŋ bɛɛŋ gɛ, nje gɛ bɛŋ nyu ŋgoo yi shóŋ yaŋ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Shóŋ yaŋ to yi yuge jɛ yaŋ. Ŋkee yi, yi bii mɛne, ");
INSERT INTO ncr_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","nyaa kinche kì kage gɛ yi le. Gɛ yi nyu yi to yi lɛsɛ gɛ. Gɛ muh nyu yu wu yu wu lo yi chiaaŋ yaŋ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Chii wu le wu nya shóŋ yi yu mɛne fede muh wuchii, gɛ muh nyu yu wù taŋlo wu lo yi chiaaŋ ye le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Besa Chii le fiɛɛ le fimimia.” ");
INSERT INTO ncr_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Bajuu ka bo jo ata ki bo tumɛ wu yu. ");
INSERT INTO ncr_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jiso biih bo le lɛ, “Bɛŋ le bɛŋ yɛŋ wa chilɛme chì joŋe le wesee chì Chii jɛme lɛ ŋgêe. Le chi la, chi bɛŋ goone ki bɛŋ tûmɛ mɛ nje chi?” ");
INSERT INTO ncr_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Bo chvuu wu le lɛ, “Gɛ bee tume wo nyu nje lɛme chì joŋe chì wo ge gɛ. Bee tume wo nyu nje wo chɛŋe bɛ jee chi Nyo. Wo le gɛh lo muh wu wuŋ, wo duu lɛ wo le Nyo.” ");
INSERT INTO ncr_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jiso chvuu bo le lɛ, “Gɛ fi nyu ba saŋ a Ŋwa wene wu banchi le lɛ Nyo jɛme yo lɛ, ‘Nle njɛmɛ lɛ bɛŋ le banyo?’ ");
INSERT INTO ncr_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nyo tɛŋe bamii bayu lɛ banyo, nyu gɛh bo bayu ba jɛ ye gɛ̀ gɛnɛ fɛ bo le, besabɛŋ kee lɛ gɛ fiɛɛ fì le a Ŋwa wu Nyo le taŋlo fi kusɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","No fi le noo, le nje la fì bɛŋ jɛme muh wù Chii cha wu tuŋ yi woŋ kfunɛ le lɛ wu chɛŋe bɛ jee chi Nyo, gɛ nje wu le wu jɛmɛ lɛ wu le Mwa Nyo? ");
INSERT INTO ncr_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nle njɛ ŋgee nyu chilɛme chì Chii lɛ sɛŋ, keefɛ bɛŋ bɛ̂ɛŋ mɛne gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Geenɛ le lɛ ŋgee nyu chi, bɛŋ baaŋ bɛɛŋ gɛ mo mɛne gɛ, bɛŋ bɛɛŋ chi le, bɛŋ mo bɛŋ kee chuule lɛ Chii le yi ye yaŋ le, mɛ nyu ye yi Chii le.” ");
INSERT INTO ncr_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bajuu ka bo goone ki bo koo wu, geenɛ wu tɛɛshɛ chiaaŋ yiboo le. ");
INSERT INTO ncr_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jiso ka wu gɛɛŋ wu daŋ Joo yì Jodaŋ kiwuŋ kì Joŋ gɛ̀ kɛ wu leese bamii yo a joo, wu tu wù nyu yo. ");
INSERT INTO ncr_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bamii ba duude tu bo too bo yɛde wu le. Bo gɛ̀ ja bo jɛmɛ lɛ, “Joŋ gɛ̀ baaŋ ge gɛ fiɛɛ fimi fì duunyi bvukugɛ bvu Nyo gɛ. Geenɛ fiɛɛ fichii fì wu gɛ̀ jɛmɛ kune muh wunɛ gɛ̀ bee fì nchiɛɛŋ.” ");
INSERT INTO ncr_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Noo bamii ba duude leesɛ muntele yi Jiso le yo. ");
INSERT INTO ncr_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Muh mu wù jee che gɛ̀ bee Lasolo gɛ̀ ja wu chɛne. Wu gɛ̀ bee muh wu ntɛ wù Bɛtani le, wu chee yo bɛ jɛ́me ye yi gɛ̀ bee Mɛɛle bɛ Mata. ");
INSERT INTO ncr_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mɛɛle wunɛ wù mwa bwee wu Lasolo gɛ̀ chɛne, nyu wu wù gɛ yefɛ bikaa bi Tada bɛ mɛɛ ma gwee wuŋ, wu sho bɛ yvu ye yi kikwɛɛ. ");
INSERT INTO ncr_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","No wu gɛ̀ chɛne noo, jɛ́me ye yiyu mo yi chiiŋsɛ tuŋ fɛ Jiso le lɛ, “Tada, muh wɛɛ wu le fitele fiuŋ chɛne lo.” ");
INSERT INTO ncr_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Lɛ Jiso doo wu yu ntuŋ wɛɛ, wu jɛmɛ lɛ, “Gɛ kinchɛŋ kinɛ nyu ki kwe gɛ. Ki lé ki dûnyɛ nyu bvukugɛ bvù le bvu Nyo, wu lɛ Mwa Nyo taŋlo wu kɛmɛ mbɛɛŋsɛ nje ki.” ");
INSERT INTO ncr_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jiso gɛ̀ koŋe Mata bɛ mwa bwee wu Mɛɛle mo Lasolo baaŋ. ");
INSERT INTO ncr_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Geenɛ, sege wu gɛ̀ yu lɛ Lasolo chɛne lo, wu ka wu che fɛ wù gɛ̀ bee fo aju afaa. ");
INSERT INTO ncr_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ajiŋ ayu, wu jɛmɛ booŋ be ba ŋgoo le lɛ, “Bee kaasɛ be tu jiŋ Judia.” ");
INSERT INTO ncr_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Bo biih wu le lɛ, “Labai, le gɛ kiŋguu kiŋguu nɛ wu Bajuu chi goone ki bo tumɛ wo bɛ ata wo kwe, wo ka tuu yo?” ");
INSERT INTO ncr_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jiso chvuu bo le lɛ, “Gɛ bikaa bi kife nyu yi juu le yuufe ncho bifɛɛ gɛ? Nɛ muh jiɛnyi fɛnshɛ, tu gɛ taŋlo wu baŋsɛ yi fiɛɛ le gɛ, nje n'yulɛ wu yi woŋ kfunɛ le baaŋ fɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Geenɛ, muh jiɛnyi antaŋ, tu taŋlo wu baŋsɛ, nje gɛ wù kɛme n'yulɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","No wu jɛmɛ noo, wu mo wu du bo le lɛ, “Nsaa yese besabɛŋ wu Lasolo le wu lee wa, geenɛ nlé ŋgɛ̂ɛŋ ŋkâŋsɛ wu a lefɛ chiyu le.” ");
INSERT INTO ncr_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Booŋ be ba ŋgoo jɛmɛ wu le lɛ, “Tada, finɛ le lɛ wu lefe lo, tu wu lé wu gê wu tɛ̂mɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jiso gɛ jɛme kune kwe yi Lasolo, geenɛ bo yuge lɛ wu jɛme nyu kune lefɛ chi leefɛ. ");
INSERT INTO ncr_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jiso mo wu jɛmɛ bo le chaaŋ lɛ, “Lasolo le wu kwe wa. ");
INSERT INTO ncr_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Geenɛ n'yuge njoŋ nje bɛŋ, lɛ nchi mbee gɛ fo gɛ, wu lɛ bɛŋ leesɛ fitele yi ye yaŋ le. Bee gɛ̂ɛne a wu le yo.” ");
INSERT INTO ncr_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Toma wu ba gɛ tɛŋe jee che chimi lɛ Amaŋ, jɛmɛ booŋ ba ŋgoo bamu le lɛ, “Bee gɛɛŋ tɛ wu lɛ bee taŋlo be kwe bɛ wu.” ");
INSERT INTO ncr_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","No Jiso gɛ̀ fɛsɛ fo, wu yu lɛ Lasolo le wu che wa a jɛŋ aju ana. ");
INSERT INTO ncr_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bɛtani yanɛ gɛ̀ bee mbebe Yɛlusalɛm le njɛ bama bafɛɛ. ");
INSERT INTO ncr_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Bajuu ba duude gɛ̀ to fɛ Mata bɛ Mɛɛle le lɛ bo koo yii bɛ bo yi kwe yi mwa bwe bo le. ");
INSERT INTO ncr_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mata doo wu yu lɛ Jiso too lo, wu mo wu bu ki wu gɛ̂ɛŋ bɛ wu tasɛ, geenɛ Mɛɛle shɛɛ yeh. ");
INSERT INTO ncr_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata gɛɛŋ wu du Jiso le lɛ, “Tada, chi bee wo nyu fɛnɛ, tu gɛ mwa bwaaŋ chi bee wu kwe gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Geenɛ, ŋkee lɛ mɛɛse wunɛ le no nyu la fì wo lɛgɛ a Nyo le tu wu lé wu nyâ wo le.” ");
INSERT INTO ncr_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jiso jɛmɛ wu le lɛ, “Mwa bwoo lé wu kâasɛ wu bû yi kwe le.” ");
INSERT INTO ncr_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mata jɛmɛ wu le lɛ, “Ŋkee lo lɛ wu lé wu kâasɛ wu bû juu chì kimɛsɛ chì bamii lé bo bûde yi kwe le.” ");
INSERT INTO ncr_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jiso du wu le lɛ, “Le mɛ wù bvuuse bamii yi kwe le, mɛ nyume kinche. Muh wù le wu leesɛ fitele yi ye yaŋ le mo wu nyu wu kwe, wu lé wu nyû yu, ");
INSERT INTO ncr_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","le yɛɛŋ wu le yu mɛɛse wu leesɛ fitele ye yaŋ le, gɛ wu nyu wu kwe gɛ. Wo le wo bɛɛŋ finɛ?” ");
INSERT INTO ncr_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Wu bɛɛŋ lɛ, “Ɛɛŋ Tada, nle mbɛɛŋ lɛ wo le Mbvusɛ wù Nyo gɛ̀ ka. Wo le Mwa Nyo wù gɛ̀ bee ki wu gê wu to yi woŋ kfunɛ le.” ");
INSERT INTO ncr_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","No Mata jɛmɛ noo, wu mo wu gɛɛŋ wu tɛɛŋ Mɛɛle wù mwa bwee, wu jɛmɛ wu le fɛkuu fɛkuu lɛ, “Muh wu N'yɛyɛ le wa fɛnɛ, wu tɛŋe wo.” ");
INSERT INTO ncr_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","No wu yu noo, wu mo wu ja lo we chige ki wu gɛ̂ɛŋ wu yɛŋ wu le. ");
INSERT INTO ncr_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Gɛ̀ bee Jiso baaŋ a lee gɛ ntɛ le gɛ. Wu gɛ̀ baaŋ gɛh fɛ Mata gɛ gɛnɛ wu yɛŋ wu le fo. ");
INSERT INTO ncr_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Bajuu ba gɛ̀ bee bɛ ba Mɛɛle bo koode yii bo doo bo yɛŋ no wu ja we wu bu yeh, bo ja bo bii wu le bo kwaji lɛ wu gɛɛne fɛ jɛŋ ki wu gɛ̂ɛŋ wu beede fo. ");
INSERT INTO ncr_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mɛɛle gɛ̀ gɛɛŋ wu fɛsɛ fɛ Jiso gɛ̀ bee fo, wu yɛŋ wu le, wu gwe bikaa bie le wu jɛmɛ lɛ, “Tada, wo chi bee wo nyu fɛnɛ, tu mwa bwaaŋ chi baaŋ kwe gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jiso doo wu yɛŋ no wu beede, Bajuu ba gɛ̀ bii wu le beede tɛ, fiɛɛ fiyu shiŋshɛ fitele fie baaŋ, ye bee wu. ");
INSERT INTO ncr_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Wu ja wu biih lɛ, “Bɛŋ jiiyi wu faaŋ?” Bo jɛmɛ wu le lɛ, “Tada, tô wo yɛ̂ŋ.” ");
INSERT INTO ncr_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jiso bee kwe. ");
INSERT INTO ncr_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Bajuu yɛŋ noo bo jɛmɛ lɛ, “Bɛŋ jîŋɛ bɛŋ yɛ̂ŋ no wu chi koŋe wu.” ");
INSERT INTO ncr_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Geenɛ bamu ka bo jɛmɛ lɛ, “Gɛ nyu wu wù chi gwenyɛ ajii a kinfeeŋ kɛɛ gɛ, tu gɛ nyu no wu baŋ muh wunɛ ki wu kwê gɛ?” ");
INSERT INTO ncr_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Fitele fie ka fi shiŋshɛ wu baaŋ. Wu ja wu gɛɛŋ wu fɛsɛ fɛ jɛŋ. Jɛŋ yinɛ gɛ̀ bee bvuta ba baŋɛ jwe wuyu bɛ kibwee ki tɛdɛ. ");
INSERT INTO ncr_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jiso jɛmɛ lɛ, “Bɛŋ chîaasɛ tɛdɛ chiɛɛ.” Mata wu jɛme yi muh wù gɛ̀ kwe wɛɛ jɛmɛ Jiso le lɛ, “Tada, mɛɛse le wu saane wa. Le wa aju ana no wu chi kwe.” ");
INSERT INTO ncr_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jiso biih wu le lɛ, “Mbe ndu gɛ wo le lɛ wo nɛ le wo leesɛ fitele ye yaŋ le, wo lé wo gê wo yɛ̂ŋ bvukugɛ bvù le bvu Nyo le?” ");
INSERT INTO ncr_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Noo, bo mo bo chiaasɛ tɛdɛ chiyu. Jiso chiaasɛ ajii we wu jɛmɛ lɛ, “Chii, nnyaa kiyone wo le no wo le wo yu buunɛ chaŋ. ");
INSERT INTO ncr_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ŋkee lɛ wo to wo yuge buunɛ chaŋ segechii. Geenɛ, njɛme finɛ baaŋ nje bamii banɛ ba lɛme fɛnɛ, fi le lɛ taŋlo bo bɛɛŋ lɛ tuŋ wo mɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","No wu jɛmɛ noo, wu jaŋ bɛ jɛ yi tɛɛme lɛ, “Lasolo, bû!” ");
INSERT INTO ncr_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Muh wù gɛ̀ kwe wa wɛɛ mo wu bu, ba diiŋ chiaaŋ ye, bɛ bikaa bie, bɛ nchaŋa yi nju, ba diiŋ tɛ bvushi bwe bɛ nchaŋa yi nju. Jiso jɛmɛ bo le lɛ, “Bɛŋ fâanyɛ wu, bɛŋ chînɛ wu gɛ̂ɛne.” ");
INSERT INTO ncr_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Bajuu ba duude ba gɛ̀ to fɛ Mɛɛle le bo doo bo yɛŋ fiɛɛ fì Jiso ge le, bo mo bo leesɛ fitele yi ye ye le. ");
INSERT INTO ncr_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Geenɛ, bamu ka bo gɛɛŋ fiboo bo yɛŋ nyu Bafalashii le, bo sɛɛŋ bo fiɛɛ fì Jiso ge. ");
INSERT INTO ncr_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Bachiji kintanyɛ ba baaŋ baaŋ bɛ Bafalashii mo bo kuŋ bikwɛɛ bi woŋ lɛ bo jɛmɛ lɛ, “Bee lé be gê nɛɛ? Muh wunɛ gee mwɛɛ wesee mu duunyi bvukugɛ bvu Nyo. ");
INSERT INTO ncr_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nɛ besabɛŋ chinɛ lo wu gɛɛŋ bɛ fi fwe, tu bamii bachii lé bo gê bo lêese fitele yi ye ye le, bamii ba Lum ba sage bee lé bo gê bo jâ bo to bo bvuushɛ kijusɛ ki yuude kesa kinɛ bɛ kituŋ kesa.” ");
INSERT INTO ncr_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Geenɛ, muh mu bo le wù jee che gɛ̀ bee Kayfa, wù gɛ̀ bee kikwɛɛ ki bachiji kintanyɛ kiluŋ kɛɛ le ja wu jɛmɛ fie bo le lɛ, “Gɛ bɛŋ kee fiɛɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Gɛ bɛŋ kee lɛ fi joŋe fɛ bɛŋ le lɛ muh wu mumwaa kwe fɛ bamii le bachii fede fɛ kituŋ kichii lɛsɛ lo?” ");
INSERT INTO ncr_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Gɛ Kayfa gɛ̀ jɛme fiɛɛ finɛ bɛ bvufee bwe gɛ. Wu njɛ kikwɛɛ ki bachiji kintanyɛ kiluŋ kɛɛ le gɛ jɛme nɛ wu teede nyu ntuŋ wu Nyo, lɛ Jiso gɛ̀ kɛme ki wu kwê fɛ kituŋ ki Bajuu le. ");
INSERT INTO ncr_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Gɛ gɛ̀ mɛ gɛh fɛ kituŋ kiyu le maa gɛ, wu gɛ̀ kɛme ki wu kwê ki wu bâanyɛ booŋ ba le ba Nyo bachii ba le bituŋ bimi le, lɛ bo nyû yi fiɛɛ le fimimia. ");
INSERT INTO ncr_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kɛge abvu, bikwɛɛ bi woŋ mo bi kɛ bi jode ntaŋ no bi lé bi gê fɛ bi yuuyɛ Jiso. ");
INSERT INTO ncr_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Noo, Jiso tu wu faane ki wu ka wu jîɛnyi nɛ waaŋ antɛnɛɛ a Bajuu. Wu ja fie yo wu gɛɛŋ kituŋ kimi ki le mbebe woŋ wu munshɛɛŋ le bɛ booŋ be ba ŋgoo tu bo chee yo a kilaantɛŋ kimi le ba tɛŋe lɛ Ɛfɛlɛm. ");
INSERT INTO ncr_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ŋka wu Bajuu wu Ndaŋfe gɛ̀ too wa mbebe le, bamii tu bo jade bimbe le bo bɛɛne Yɛlusalɛm ki bo kfuŋ bikwɛɛ biboo fɛ juu chinɛ to. ");
INSERT INTO ncr_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Bo gɛɛŋ bo kɛ bo tu bo goone Jiso bo biide lɛbolɛbo no bo gɛ̀ lɛme fɛ yeh yi kintanyɛ le bo duu lɛ, “Bɛŋ kwaji lɛ la? Gɛ wu to fɛ ŋka wunɛ le gɛ?” ");
INSERT INTO ncr_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Gɛ̀ bee bachiji kintanyɛ ba baaŋ baaŋ mo Bafalashii bo nya wa nchi lɛ muh wù kee fɛ Jiso le fo, wu ge bo kɛɛ, wu lɛ taŋlo bo koo wu. ");
INSERT INTO ncr_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Gɛ̀ bee shege wa aju bvusoo mo nyu kife ki Ŋka wu Ndaŋfe, Jiso ja wu gɛɛŋ ntɛ wù Bɛtani le a Lasolo wù Jiso gɛ̀ bvusɛ wu yi kwe le gɛ̀ bee yo. ");
INSERT INTO ncr_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","No wu gɛnɛ yo, bo fɛ mwɛɛ munjile ki bo tɛ wu yu. Mata gɛ̀ bee muh wu gabe Lasolo nyu muh mu ŋgoo yi bamii ba gɛ̀ shilɛ bo jii mwɛɛ bɛ Jiso le. ");
INSERT INTO ncr_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mɛɛle ja wu jo fikaaŋ fi mɛɛ ma yefɛ mamu ma gwee wuŋ, wu chvu bikaa bi Jiso le, wu sho bɛ yvu ye yi kikwɛɛ. Mɛɛ maa gɛ̀ tɛɛme kwa baaŋ, ba gɛ̀ kɛnyi bɛ fiɛɛ fimi ba tɛŋe lɛ naad lɛwulɛwu. No wu chvu noo, yeh tu yi gwee wuŋ wù joŋe yichii. ");
INSERT INTO ncr_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Juda Ɛkaliot wù gɛ̀ bee muh ŋgoo yi booŋ ba Jiso le, (Wu gɛ̀ jiɛnyɛ wu to wu gesɛ wu) wu ja wu jɛmɛ lɛ, ");
INSERT INTO ncr_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Be ge la lɛ keefɛ bo gêsɛ mɛɛ manɛ banchvuge gii yitɛde, bo nya bige biyu bamii ba fuude le gɛ?” ");
INSERT INTO ncr_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Gɛ Juda gɛ̀ jɛme nɛ lɛ wù kɛme kiŋkoŋɛ fɛ bamii ba fuude le gɛ. Wu gɛ̀ bee choŋ wù nyu muh wuboo wu gɛɛde kikɛɛ, wu gɛ̀ leese chiaaŋ yo wu fiih kikwɛɛ ke yu. ");
INSERT INTO ncr_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jiso jɛmɛ lɛ, “Chînɛ wu le. Wu be gɛɛde mɛɛ manɛ ki wu sêesɛ nyu njiiyɛ waŋ yu. ");
INSERT INTO ncr_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Bamii ba fuude lé bo nyû gɛh bɛ bɛŋ segechii, geenɛ gɛ mɛ nyu ŋge nyume besabɛŋ segechii gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Kinchvu ki Bajuu gɛ̀ yu lɛ Jiso le yo, bo mo bo to yo. Gɛ bo gɛ̀ too gɛh nje Jiso maa gɛ. Bo gɛ̀ too tɛ ki bo yɛŋ Lasolo wù Jiso gɛ̀ bvusɛ yi kwe le. ");
INSERT INTO ncr_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Noo, bachiji kintanyɛ ba baaŋ baaŋ tu bo kage lɛ bo lé bo yûuyɛ tɛ Lasolo, ");
INSERT INTO ncr_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","nje gɛ̀ bee nje wu wù Bajuu ba duude gɛ̀ chinɛ wa bo le, bo leese fitele nyu yi Jiso le. ");
INSERT INTO ncr_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Lɛ akfuuŋ bu ayuu, kinchvu ki bamii ki gɛ̀ to fɛ ŋka wuyu le bo yu lɛ Jiso le a je wu too Yɛlusalɛm. ");
INSERT INTO ncr_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Bo mo bo jo bidaadɛ bo bu ki bo gɛɛŋ bo fi wu yu a je. No bo gɛ̀ gɛɛne noo bo wuule bo duu lɛ, “Yilili Yilili, mbɛɛŋsɛ nyûme fɛ Nyo le lɛɛɛ! Nyo le wu noŋ kimbonɛ yi muh wù too a jee chi Tada le lɛɛɛ! Le wu wu le Nfoŋ wu Ishwala lɛɛɛ!” ");
INSERT INTO ncr_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jiso gooŋ mwa jaki, wu bɛɛŋ yu. Fi mo fi nyu no ba gɛ̀ saŋ lɛ, ");
INSERT INTO ncr_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Bamii ba Sayoŋ, keefɛ bɛŋ fâane gɛ. Bɛŋ jîŋɛ bɛŋ yɛ̂ŋ, Nfoŋ wene too lo, wu le wu bɛɛŋ yi mwa jaki le.” ");
INSERT INTO ncr_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Gɛ booŋ ba Jiso ba ŋgoo gɛ̀ kɛɛ fɛŋkɛɛ fiɛɛ fì fiɛɛ finɛ gɛ̀ duunyi gɛ. No Jiso gɛ̀ leesɛ wa yi bvukugɛ bwe le, bo mo bo kwajɛ lɛ ba gɛ̀ saŋ fiɛɛ finɛ kune wu, fi gɛ̀ kooshɛ bɛ wu gɛh no ba gɛ̀ saŋ. ");
INSERT INTO ncr_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Kinchvu kì gɛ̀ bee bɛ Jiso juu chì wu gɛ̀ tɛŋe Lasolo a jɛŋ wu bvusɛ wu yi kwe le, gɛ̀ gɛɛne bo nsɛŋe no bo gɛ̀ yɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kinchvu kiyu gɛ̀ bu ki gɛɛŋ ki fi wu a je nje bo gɛ̀ yu lɛ wu gɛ̀ ge fiɛɛ finɛ fì duunyi bvukugɛ bvu Nyo. ");
INSERT INTO ncr_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Bafalashii yɛŋ nɛ bo tu bo jɛme lɛbolɛbo lɛ, “Bɛŋ le bɛŋ yɛŋ gɛ lo? Gɛ fiɛɛ nyu yu fì taŋlo bɛŋ ka bɛŋ ge gɛ. Woŋ wuchii le wu banyɛ wa wu bii wu le.” ");
INSERT INTO ncr_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Bamii bamu gɛ̀ bee ŋgoo yi bamii ba gɛ̀ bɛnɛ Yɛlusalɛm ki bo bunɛ Nyo kife ki ŋka kinɛ le gɛ̀ bee Baglek. ");
INSERT INTO ncr_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Baglek banɛ gɛɛŋ bo yɛŋ Filib wù gɛ̀ ja a kilaantɛŋ kì Bɛsada le kimbe kì Galalee le, bo jɛmɛ wu le lɛ, “Ŋgamu, bee goone ki be yɛŋ Jiso le.” ");
INSERT INTO ncr_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filib mo wu gɛɛŋ wu sɛɛŋ Andulu le, bɛ wu gɛɛŋ bo sɛɛŋ Jiso le. ");
INSERT INTO ncr_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jiso chvuu bo le lɛ, “Kife le ki kojɛ ka ki muh wù jee che le Mwamuh le wù kɛme jee chì kuge. ");
INSERT INTO ncr_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nsɛŋe bɛŋ nchiɛɛŋ nchiɛɛŋ lɛ, ŋgo yi fiɛɛ baaŋ gwe gɛ yi nshɛŋ le yi kwe gɛ, yi mɛ gɛh yi maa. Geenɛ yi kwe lo, yi yuŋ muntaŋ wesee. ");
INSERT INTO ncr_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Muh wù koŋe kinche ke baaŋ lé wu gê wu lɛ̂sɛ kinche kiyu, muh wù banɛ kinche ke yi woŋ kfunɛ le wu lé wu gɛ̂ɛ lo ki, wu lé wu gê wu kɛ̂me kinche kì kage gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nɛ muh lɛne mɛne, tu wù kɛme ki wu bîi mɛne, mo nyu faaŋ fɛ mɛ le fo, muh waŋ wu lɛme nyû tɛ fo. Nɛ muh lɛne mɛne, tu Chii le wu ge wu buuŋ wu.” ");
INSERT INTO ncr_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jiso ja wu jɛmɛ lɛ, “Mɛɛse fitele fuuŋse lo mɛ. Taŋlo ndu lɛ la? Lɛ Chii bvusɛ mɛ antɛnɛɛ a kife ki ŋgɛ kinɛ le? Aay, le nje kife kiyu kinɛ kì ŋgɛ̀ nto. ");
INSERT INTO ncr_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Chii, gêe lɛ jee chuŋ kuge.” No wu jɛmɛ noo, jɛ shii fɛwe lɛ, “Nle ŋge wa chi kuge, mbaaŋ ŋka ŋge.” ");
INSERT INTO ncr_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kinchvu ki gɛ̀ lɛme fo doo ki yu jɛ yiyu, bo jɛmɛ fiboo lɛ, “Wame jaŋ.” Bamu jɛmɛ lɛ, “Jɛmɛ nchɛndaa wu Nyo wu le.” ");
INSERT INTO ncr_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jiso chvuu lɛ, “Jɛ yinɛ to nje bɛŋ. Gɛ yi to nje mɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Mɛɛse le wa kife kì ba lé ba sâ woŋ kfunɛ. Mɛɛse ba lé ba shwâ nfoŋ wù sage woŋ kfunɛ. ");
INSERT INTO ncr_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Geenɛ fiaŋ le lɛ sege ba lé ba shɛ̂ŋshɛ mɛ fɛwe, nchii bamii bachii bo to yi ye yaŋ le.” ");
INSERT INTO ncr_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jiso gɛ̀ jɛme noo wu duunyi nyu kfuu chi kwe yi wù gɛ̀ bee ki wu kwê. ");
INSERT INTO ncr_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Kinchvu ki bamii chvuu wu le lɛ, “Bee yuge a Ŋwa wu banchi le lɛ Mbvusɛ wù Nyo gɛ̀ ka lé wu gê wu fejɛ.” Fi jiɛnyi nɛɛ fɛ wo duu lɛ, “Ba kɛme ki ba ge ba shɛ̂ŋshɛ Mwamuh fɛwe?” Muh wù jee che le Mwamuh wɛɛ le wù la? ");
INSERT INTO ncr_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jiso jɛmɛ bo le lɛ, “N'yulɛ le wù nyu bɛ bɛŋ yi kife le shige. Bɛŋ mo bɛŋ jîɛnyi no bɛŋ kɛme n'yulɛ bɛ bɛŋ, keefɛ kijibɛ ja ki baŋe bɛŋ gɛ. Gɛ muh wu jiɛnyi kijibɛ le to wu kee fɛ wu gɛɛne fo gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","No bɛŋ kɛme n'yulɛ bɛ bɛŋ, bɛŋ bɛɛŋ n'yulɛ wunɛ le, fi le lɛ bɛŋ mo bɛŋ nyu booŋ ba n'yulɛ.” No Jiso jɛmɛ mwɛɛ munɛ nɛ, wu mo wu ja wu gɛɛŋ wu nyilɛ. ");
INSERT INTO ncr_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Mo no wu gɛ̀ ge mwɛɛ wesee mu duunyi bvukugɛ bwe bo yɛŋ, bo gɛ̀ baaŋ leesɛ gɛ fitele yi ye ye le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Fi gɛ̀ bee noo lɛ fi kojɛ no Yosaya wu muh wu ntuŋ wu Nyo gɛ̀ jɛmɛ lɛ, “Tada, le yɛɛŋ wu le wu bɛɛŋ fiɛɛ fì bee jɛme le? Le fɛ baaŋ le wu Tada le wu dunyɛ bvuŋga bvu kibo ke?” ");
INSERT INTO ncr_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Noo, tu gɛ taŋlo bo leesɛ fitele yi ye ye le gɛ, nje Yosaya gɛ̀ ka wu jɛmɛ kijusɛ kimu le lɛ, ");
INSERT INTO ncr_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Wu le wu baŋ ajii aboo, wu ge muntele muboo tu mu jiɛɛ, wu lɛ keefɛ bo yɛ̂ne mwɛɛ le bɛ ajii aboo gɛ, bo kee mwɛɛ a muntele muboo le gɛ, bo kaasɛ bo tu jiŋ fɛ mɛne nfɛ̂ bo.” ");
INSERT INTO ncr_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yosaya gɛ̀ jɛme mwɛɛ munɛ nje wu gɛ̀ yɛŋ wa bvukugɛ bvu Jiso le, wu mo wu jɛme kune wu. ");
INSERT INTO ncr_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Mo nyu no bamii gɛ̀ baaŋ leesɛ gɛ muntele yi Jiso le gɛ, bamii wesee bo gɛ̀ bee bikwɛɛ bi woŋ gɛ̀ leesɛ muntele yi ye ye le, geenɛ bo faŋ ki bo jɛme bɛ de yiboo, nje bo gɛ̀ faane Bafalashii lɛ keefɛ bo kûŋ bo yeh yi buunɛ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bo gɛ faane noo nje bo gɛ koŋe ki bo kɛme mbɛɛŋsɛ nyu wù jade fɛ bamii le fede ki bo kɛme nyu wù jade fɛ Nyo le. ");
INSERT INTO ncr_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jiso ja wu jaŋ fɛwɛɛwe wu jɛmɛ lɛ, “Muh wù le wu leesɛ fitele yi ye yaŋ le, gɛ wu leese nyu yi ye yaŋ le gɛ. Wu leese nyu yi muh wu tuŋ mɛ le. ");
INSERT INTO ncr_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Muh nɛ yɛŋ mɛne, tu wu le wu yɛŋ nyu muh wu tuŋ mɛ le. ");
INSERT INTO ncr_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nto woŋ kfunɛ le njɛ n'yulɛ, lɛ le yɛɛŋ wu le wu leesɛ fitele yi ye yaŋ le wu gɛ ka wu mɛ gɛh nyu yi kijibɛ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Muh yu jɛ yaŋ, wu baaŋ gɛɛ gɛ, ŋgɛ nsa wu gɛ, nje gɛ ŋgɛ̀ nto ki nsage bamii ba yi woŋ kfunɛ le lɛ bo gwe nsa gɛ. Nto ki Mbvusɛ lo bo. ");
INSERT INTO ncr_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Muh wu le wu ma mɛ wù faŋ ki wu fî jɛ yaŋ wù kɛme fiɛɛ fì lé fi gê fi sâ wu. Jɛ yi nle njɛme wu le, le fiɛɛ fì lé fi gê fi sâ wu wù gwe nsa juu chì kimɛsɛ. ");
INSERT INTO ncr_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Fi le noo nje gɛ njɛme nyu a bvuŋga bwaŋ le gɛ. Chii wù tuŋ mɛ le wu wù du lɛ njɛ̂me, nya wu fiɛɛ fì njɛ̂me, wu sɛŋe no njɛ̂me. ");
INSERT INTO ncr_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ŋkee lɛ fiɛɛ fì wu du lɛ njɛ̂me le fi nyaa kinche kì kage gɛ. Noo, fiɛɛ fì njɛme le fi Chii duu lɛ njɛ̂me.” ");
INSERT INTO ncr_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Gɛ̀ bee akfuuŋ bude ayuu mo nyu Ŋka wu Ndaŋfe, Jiso kɛɛ lɛ kife kì wu lé wu chînɛ woŋ kfunɛ le, wu kaasɛ wu gɛɛŋ fɛ Chiji le, le ki kojɛ ka. No wu gɛ̀ koŋe bamii ba gɛ̀ bee be yi woŋ kfunɛ le, wu koŋ bo wu gɛɛŋ wu mɛsɛ. ");
INSERT INTO ncr_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","No bo gɛ̀ jii mwɛɛ fɛnfu, debele nyu wu leesɛ wa ŋkwajɛ a fitele fì Juda wù mwa Samoŋ Ɛkaliot le lɛ wu gêsɛ Jiso. ");
INSERT INTO ncr_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","No Jiso gɛ̀ kee lɛ Chiji le wu nya wa mwɛɛ munchii chiaaŋ ye le, bɛ lɛ wu gɛ̀ ja fɛ Nyo le, wù nyu wu kaasɛ wu tu jiŋ fɛ Nyo le, ");
INSERT INTO ncr_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","wu mo wu ja we a mwɛɛ munjile, wu baayɛ bikuŋ bie, wu jo nju yi ba shode ye yu, wu kaaŋ chiŋ, ");
INSERT INTO ncr_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","wu mo wu chvu joo a ŋkaa le, wu kɛ wu chuge bikaa bi booŋ be ba ŋgoo yu, wu shode bɛ nju yi wu gɛ̀ shulɛ chiŋ yɛɛ. ");
INSERT INTO ncr_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","No wu gɛ̀ chuge lɛ wu to wu bu fɛ Samoŋ Bita le, wu biih wu le lɛ, “Tada, lé chûgɛ wo bikaa biaŋ?” ");
INSERT INTO ncr_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jiso chvuu wu le lɛ, “Gɛ fiɛɛ fì ŋgee taŋlo wo kɛɛ mɛɛse gɛ. Wo lé wo gê wo kɛ̂ɛ nyu ajiŋ.” ");
INSERT INTO ncr_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Bita jɛmɛ Jiso le lɛ, “Gɛ taŋlo wo yu wo chugɛ bikaa biaŋ gɛ.” Jiso chvuu wu le lɛ, “Nɛ mbaaŋ wo chugɛ gɛ, tu gɛ wo kɛme fiɛɛ bɛ mɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Samoŋ Bita mo wu jɛmɛ Jiso le lɛ, “Tada, finɛ le noo, tu gɛ wo nyu wo chugɛ gɛh nyu bikaa biaŋ maa gɛ. Wo lé wo chûgɛ tɛ chiaaŋ yaŋ bɛ kikwɛɛ kaŋ fo.” ");
INSERT INTO ncr_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jiso jɛmɛ wu le lɛ, “Muh wù chugɛ wa ye le wu yuu wa ye yichii, gɛ wo kɛme ki wu ka wu chûgɛ ye fede bikaa gɛ. Bɛŋ le bɛŋ yuude wa, geenɛ gɛ nyu bɛŋ bachii ba yuude gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jiso gɛ̀ jɛme noo nje wu gɛ̀ kɛɛ wa muh wu lé wu gê wu gêsɛ wu. Le fiɛɛ fì wu gɛ̀ jɛmɛ lɛ, “Gɛ bɛŋ yuude bachii gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jiso gɛ̀ mɛsɛ wu chugɛ bikaa biboo, wu noŋ bikuŋ bie ye le, wu kaasɛ wu gɛɛŋ wu tu fɛ kijusɛ ke le, wu mo wu biih bo le lɛ, “Bɛŋ le bɛŋ kɛɛ fiɛɛ fì ŋge fɛ bɛŋ le finɛ? ");
INSERT INTO ncr_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Bɛŋ tɛŋe mɛ lɛ Muh wu N'yɛyɛ bɛŋ ka tɛŋe lɛ Tada, bɛŋ tɛŋe nyu chuule noo nje le fiɛɛ fì nle fi. ");
INSERT INTO ncr_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nɛ le lɛ le mɛ wù Tada wene ŋka nyume Muh wene wu N'yɛyɛ wu le wu chugɛ bikaa biɛna, tu bɛŋ tɛ kɛme ki bɛŋ chûge bikaa bi muh lɛ muh. ");
INSERT INTO ncr_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ŋge noo ki ndunyɛ bɛŋ le lɛ bɛŋ gêe tɛ no ŋge fɛ bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nsɛŋe bɛŋ nchiɛɛŋ nchiɛɛŋ lɛ gɛ mwa wu lɛme to wu kuge wu fede chiji wu lɛme gɛ, gɛ̀ muh wù ba tuŋ lo to wu kuge tɛ wu fede muh wù tuŋ wu gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Bɛŋ nɛ kee mwɛɛ munɛ, bɛŋ gee mu, njoŋ wù baaŋ nyû wene. ");
INSERT INTO ncr_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Gɛ njɛme nyu kune bɛŋ bachii gɛ. Ŋkee bamii ba nle ncha. Geenɛ, fi le lɛ fiɛɛ fì le a Ŋwa wu Nyo le fi kɛme ki fi to fi kojɛ no ba gɛ̀ saŋ lɛ, ‘Muh wù jii mwɛɛ munjile mwaŋ le wu ja wu bii bikaa biaŋ le.’ ");
INSERT INTO ncr_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nsɛŋe fiɛɛ finɛ bɛŋ le mɛɛse fi nyu fi ge fi kooshɛ, fi le lɛ fi doo fi kooshɛ, bɛŋ mo bɛŋ bɛɛŋ lɛ le mɛ wuyu kibɛɛ. ");
INSERT INTO ncr_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nsɛŋe bɛŋ nchiɛɛŋ nchiɛɛŋ lɛ muh wù le wu fi mo muh wù la wù ntuŋ, tu wu fi nyume mɛ. Muh wù fi mɛ tu wu fi nyu muh wù tuŋ mɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","No Jiso jɛmɛ mwɛɛ munɛ nɛ, fitele ja fi tu fi fuuŋse wu. Wu ja wu jɛmɛ chaaŋ wu du lɛ, “Nsɛŋe bɛŋ nchiɛɛŋ nchiɛɛŋ lɛ muh mu bɛŋ le, lé wu gê wu gêsɛ mɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Booŋ be ba ŋgoo ja bo tu bo jiiŋe ye yiboo bo maŋe laa wu jɛme nyu muh wù la lɛ. ");
INSERT INTO ncr_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Muh mu ŋgoo yi booŋ ba Jiso le wù Jiso gɛ̀ koŋe, gɛ̀ yɛmɛ wu jii mwɛɛ mbebe ye le. ");
INSERT INTO ncr_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Samoŋ Bita ŋwalɛ wu, wu jɛmɛ lɛ wu bîih Jiso le laa, wu jɛme nyu yɛɛŋ la. ");
INSERT INTO ncr_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Noo, wu yɛɛŋ wu gɛɛŋ yi Jiso le wu biih wu le lɛ, “Tada, le yɛɛŋ?” ");
INSERT INTO ncr_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jiso chvuu wu le lɛ, “Le muh wù nlé bwɛ̂ɛdɛ blɛd nchu a joo yi mbaa le nya wu le.” Noo, wu mo wu chu blɛd a joo yi mbaa le wu nya Juda wù mwa Samoŋ Ɛkaliot le. ");
INSERT INTO ncr_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Gɛh no Juda fi blɛd wɛɛ nɛ, Sataŋ mo wu lee yi ye ye le. Jiso jɛmɛ wu le lɛ, “Yâŋsɛ gê fiɛɛ fì wo goone ki wo gê.” ");
INSERT INTO ncr_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Muh mu ŋgoo yiboo le gɛ̀ baaŋ kɛɛ gɛ fiɛɛ fì wu jɛme wu le noo gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Bamu gɛ̀ kwaji lɛ no Juda gɛ̀ bee muh wù gɛɛde kikɛɛ, lɛ Jiso jɛme wu le lɛ wu gɛɛŋ wu gu mwɛɛ mù bo goone ki bo ji Ŋka yu, kɛnɛ lɛ wu gɛɛŋ wu nya fiɛɛ bamii ba fuude le. ");
INSERT INTO ncr_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","No Juda fi blɛd wɛɛ noo wu ji, wu mo wu bu lo kimimia wu gɛɛŋ. Sege kɛɛ gɛ̀ bee wa antaŋ. ");
INSERT INTO ncr_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","No Juda bu wu gɛɛŋ noo, Jiso shɛɛ wu jɛmɛ lɛ, “Mɛɛse bo lé bo kɛ̂ bo yɛ̂de bvukugɛ bvu muh wù jee che le Mwamuh le, bo mo bo yɛde tɛ bvukugɛ bvù le bvu Nyo yi ye ye le. ");
INSERT INTO ncr_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nɛ bo yɛŋ bvukugɛ bvu Nyo yi ye ye le, tu Nyo lé wu dûnyɛ tɛ bvukugɛ bvu Mwa ye yi wu wù Nyo le. Wu lé wu dûnyɛ lo kimimia. ");
INSERT INTO ncr_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Booŋ baŋ, nlé nyû besabɛŋ yi kife le nɛ shige. Bɛŋ lé bɛŋ shɛ̂ɛ bɛŋ gôoŋ mɛ bɛŋ gɛ yɛ̂ŋ gɛ. No ŋgɛ njɛmɛ Bajuu le, le no njɛme bɛŋ le mɛɛse lɛ, ‘Fɛ ŋgɛɛne fo gɛ taŋlo bɛŋ to fo gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nyaa nchi bɛŋ le, nyu nchi wu fwɛŋ lɛ bɛŋ doo bɛŋ shɛɛ bɛŋ kôŋe ye yene. Bɛŋ kôŋe gɛh yɛɛŋyɛɛŋ no ŋkoŋe bɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nɛ bɛŋ le bɛŋ shɛɛ bɛŋ kɛme kiŋkoŋɛ noo, finɛ fiɛɛ ge bamii bachii mo bo kee lɛ bɛŋ le booŋ baŋ ba ŋgoo.” ");
INSERT INTO ncr_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Samoŋ Bita mo wu biih Jiso le lɛ, “Tada, wo gɛɛne nyu faaŋ?” Jiso chvuu lɛ, “Fɛ ŋgɛɛne fo gɛ taŋlo wo bi mɛne mɛɛse gɛ. Wo lé wo shɛ̂ɛ fɛ wo bi.” ");
INSERT INTO ncr_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Bita kaasɛ wu biih wu le lɛ, “Tada, gɛ taŋlo mbii wo le mɛɛse gɛ nje la? Nlé nnyâ kinche kaŋ ki ŋkwe nje wo.” ");
INSERT INTO ncr_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jiso biih wu le lɛ, “Wo taŋlo wo nyâ kinche kuŋ ki wo kwê nje mɛ? Nsɛŋe wo nchiɛɛŋ nchiɛɛŋ lɛ nyishii lé yi gê yi tôŋ a wo faŋ wa mɛ kiŋgane kintɛde.” ");
INSERT INTO ncr_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jiso ka wu jɛmɛ booŋ be ba ŋgoo le lɛ, “Keefɛ bɛŋ chînɛ muntele mwɛna fuuŋse bɛŋ gɛ. Bɛŋ lêesɛ muntele yi Nyo le, bɛŋ lêese tɛ muntele ye yaŋ le. ");
INSERT INTO ncr_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","A Chii yeh, bibuu le yu wesee. Fi be baaŋ nyu gɛ noo gɛ, tu mbe baaŋ njɛme gɛ lɛ ŋgɛɛne ki nseesɛ kijusɛ bɛŋ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Lɛ ndoo ŋgɛɛŋ nsêesɛ kijusɛ bɛŋ le, ŋkâasɛ ntô njô bɛŋ besabɛŋ nyume, fi le lɛ fɛ nle fo, bɛŋ nyû tɛ fo. ");
INSERT INTO ncr_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Bɛŋ kee je yì gɛɛne fɛ ŋgɛɛne fo.” ");
INSERT INTO ncr_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma mo wu jɛmɛ wu le lɛ, “Tada, gɛ̀ bee kee fɛ wo gɛɛne fo gɛ. Bee lé be gê nɛɛ fɛ bee kɛɛ je yiyu?” ");
INSERT INTO ncr_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jiso chvuu lɛ, “Nle je, mɛ nyume kinchiɛɛŋ, nyume kinche. Gɛ muh taŋlo wu gɛɛŋ fɛ Chii le njɛ wu fe yi ye yaŋ le sɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nɛ bɛŋ be kee mɛ, tu bɛŋ be kee tɛ Chii. Kɛge yi mɛɛse le bɛŋ kɛɛ wa wu, bɛŋ ka bɛŋ yɛŋ wu le.” ");
INSERT INTO ncr_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filib jɛmɛ wu le lɛ, “Tada dunyɛ Chijo bee le, bee yɛŋ be mo be fuu.” ");
INSERT INTO ncr_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jiso chvuu wu le lɛ, “Filib, besabɛŋ le be che wa baaŋ nɛ wo ya kee gɛ mɛ gɛ? Muh wu le wu yɛŋ mɛne, tu wu yɛŋ wa Chii le. Wo jiɛnyi nɛɛ fɛ wo tu wo jɛme lɛ ndûnyɛ Chii bɛŋ le? ");
INSERT INTO ncr_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Wo baaŋ bɛɛŋ gɛ lɛ nle yi Chii le, Chii nyu ye yaŋ le gɛ? Njɛmɛ wù njɛme bɛŋ le gɛ njɛme nyu a bvuŋga bwaŋ le gɛ. Chii wu le ye yaŋ le, le wu wù gee chilɛme che. ");
INSERT INTO ncr_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Bɛŋ bɛɛŋ mɛne lɛ nle yi Chii le, Chii nyu ye yaŋ le. Nɛ bɛŋ baaŋ bɛɛŋ gɛ mɛ yi fiɛɛ fì njɛme le gɛ, bɛŋ bɛɛŋ nje chilɛme chi ŋgee le. ");
INSERT INTO ncr_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nsɛŋe bɛŋ nchiɛɛŋ nchiɛɛŋ lɛ muh wù le wu leesɛ fitele ye yaŋ le, wu lé wu gêe tɛ chilɛme chì ŋgee chinɛ. Wu lé wu gê wu gêe chilɛme chì fede chì ŋgê chinɛ, nje ŋgɛɛne wa fɛ Chii le. ");
INSERT INTO ncr_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nɛ le la fi bɛŋ biide a jee chaŋ le, nle ŋge fi, fi le lɛ Chiji Mwa taŋlo wu kɛme jee chì kuge nje Mwa. ");
INSERT INTO ncr_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nɛ bɛŋ biide la ajee chaŋ le, tu nlé ŋgê fi. ");
INSERT INTO ncr_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Nɛ bɛŋ koŋe mɛ, bɛŋ gɛ̂ɛde banchi baŋ, ");
INSERT INTO ncr_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","nlé ŋgê nlɛ̂gɛ Chii wu nyâ bɛŋ bɛ Muh wu Nfih wumu wù lé wu nyû bena bo segechii. ");
INSERT INTO ncr_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Muh wunɛ le Kiyo ki kinchiɛɛŋ lɛ. Gɛ nyu muh wù taŋlo bamii ba le ba yi woŋ kfunɛ le fi wu gɛ, nje gɛ bo yɛne wu le gɛ kɛnɛ gɛ bo tɛ kee wu gɛ. Bɛŋ le fiena bɛŋ kee wu, nje wu chee bena bo, wu lé wu gê wu nyû ye yene le. ");
INSERT INTO ncr_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Gɛ mɛ nyu ŋge nchinɛ bɛŋ le bɛŋ nyu njɛ booŋ ba baŋkfu gɛ. Nlé ŋgê ŋkâasɛ nto nyu besabɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Shɛgɛ wa shige bamii ba le ba yi woŋ kfunɛ le bo gɛ ka bo yɛŋ mɛne gɛ. Geenɛ, bɛŋ lé bɛŋ yɛ̂ŋ mɛne. No nlé ŋgê nyûme yu, bɛŋ tɛ ge bɛŋ nyu yu. ");
INSERT INTO ncr_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Lé gê nyû abvu bɛŋ kɛɛ lɛ nle yi Chii le, bɛŋ nyu tɛ ye yaŋ le, mɛ nyu ye yene le. ");
INSERT INTO ncr_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Muh wù kee banchi baŋ wu gɛɛde, le wuwɛɛ wù koŋe mɛ. Muh wù koŋe mɛ le wù Chii lé wu kôŋe wu. Nlé ŋgê ŋkôŋe tɛ wu, ndunyɛ kikwɛɛ kaŋ wu le.” ");
INSERT INTO ncr_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Juda wumu (Nyume gɛ wɛɛ wu ba tɛŋe lɛ Ɛkaliot gɛ) biih wu le lɛ, “Tada, fi lé fi jîɛnyɛ nɛɛ fɛ wo dunyɛ kikwɛɛ kuŋ nyu bee le, ya nyume gɛ bamii ba le ba yi woŋ kfunɛ le gɛ?” ");
INSERT INTO ncr_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jiso chvuu wu le lɛ, “Nɛ muh koŋe mɛ, tu wu lé wu gɛ̂ɛde njɛme waŋ, Chii lé wu kôŋe wu, besa Chii le be ge be to fɛ wu le bee chee besa bo. ");
INSERT INTO ncr_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Muh wu koŋe gɛ mɛ gɛ, gɛ wu to wu gɛɛdɛ njɛme waŋ gɛ. Gɛ njɛme wù bɛŋ yuge wunɛ nyu waŋ gɛ. Le wu Chii wù tuŋ mɛ. ");
INSERT INTO ncr_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Mwɛɛ munɛ njɛme bɛŋ le mbaaŋ besabɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Geenɛ, Muh wu Nfii wu le Kiyo ki Yuude wù Chii lé wu gê wu chîŋsɛ a jee chaŋ le, lé wu gê wu yɛ̂yɛ bɛŋ bɛ mwɛɛ munchii wu ka wu ge bɛŋ tâne mwɛɛ munchii mù nle njɛmɛ wa bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nle ŋgɛɛ nyiɛgee wu nyûme bɛ bɛŋ. Nnyâa nyiɛgee wù le waŋ bɛŋ le. Gɛ nnyaa nyiɛgee wunɛ bɛŋ le no bamii ba le ba yi woŋ kfunɛ le to bo nyaa gɛ. Keefɛ bɛŋ chînɛ muntele mwɛna fûuŋse bɛŋ gɛ kɛnɛ bɛŋ kɛme nfaaŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Bɛŋ le bɛŋ yu wa no njɛme lɛ ŋgɛɛne wa lo, nlé ŋgê ŋkâasɛ ntô nyume besabɛŋ. Nɛ bɛŋ be koŋe mɛ, tu bɛŋ bee bɛŋ lâŋe lo ye, nje ŋgɛɛne nyu fɛ Chii le, no Chii kuge wu fede mɛ. ");
INSERT INTO ncr_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mɛɛse nle njɛmɛ wa fiɛɛ finɛ bɛŋ le fi baaŋ a kooshɛ gɛ, sege fi ge fi kooshɛ, bɛŋ mo bɛŋ bɛɛŋ mɛne. ");
INSERT INTO ncr_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Gɛ mbaaŋ ŋka nshe njɛme besabɛŋ baaŋ gɛ, nje nfoŋ wù sage woŋ kfunɛ too wa lo. Gɛ fi nyu lɛ wu kɛme bvuŋga a mɛ we gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Geenɛ, ŋgee nyu no Chii duu lɛ ŋgêe wu lɛ bamii ba le ba yi woŋ kfunɛ le taŋlo bo kɛɛ lɛ ŋkoŋe Chii. Bɛŋ ja we be gɛ̂ɛne.” ");
INSERT INTO ncr_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Nle chwɛŋ wu kite ki muntaŋ ki nchiɛɛŋ nchiɛɛŋ, Chii le muh wù kɛnyi chwɛŋ kwɛɛ. ");
INSERT INTO ncr_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Chɛ́ yaŋ yichii yì baaŋ muntaŋ yuŋ gɛ, wu to wu ge wu shwagɛ wu bvusɛ. Yì yune muntaŋ wu lé wu gê wu sêesɛ wu kɛ̂nyɛ wu lɛ yi yûude yi mo yi yune muntaŋ wesee. ");
INSERT INTO ncr_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Njɛmɛ wù njɛme bɛŋ le, le wu ge wa bɛŋ tu bɛŋ yuude. ");
INSERT INTO ncr_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Bɛŋ mɛ gɛh bɛŋ nyû ye yaŋ le, mɛ tɛ nyû ye yene le. Gɛ chɛ taŋlo yi yuŋ muntaŋ lɛyilɛyi njɛ yi le yi kite le sɛŋ gɛ. Le gɛh yɛɛŋyɛɛŋ no gɛ taŋlo bɛŋ ge fiɛɛ njɛ bɛŋ le ye yaŋ le sɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nle chwɛŋ wu kite ki muntaŋ, bɛŋ nyu chɛ́ yiyu. Muh wù le ye yaŋ le mɛ tɛ nyu yi ye ye le, le wuwɛɛ muh wu le njɛ chɛ́ yi taŋlo yi yune muntaŋ wesee, nje mbaaŋ nyu gɛ, muh gɛ ge fiɛɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Muh wù le njɛ wu le yi ye yaŋ le sɛŋ wu le njɛ chɛ yì ba lé ba bvûsɛ ba nôŋ lo, yi yûnɛ. Kfuu chi chiɛɛ chɛ́ lé ba nyû ba bânyɛ ba nôŋ fɛ ŋgu le, yi fie lo. ");
INSERT INTO ncr_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nɛ bɛŋ mɛ gɛh bɛŋ nyu yi ye yaŋ le jɛ yaŋ nyu ye yene le, bɛŋ nɛ biide nyu la fì bɛŋ goone, tu ba lé ba gê fi fɛ bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nɛ bɛŋ le njɛ chɛ́ yì yune muntaŋ wesee, finɛ fiɛɛ nyâa jee chì kuge Chii le, fi mo fi dûunyi lɛ bɛŋ le bamii baŋ ba ŋgoo. ");
INSERT INTO ncr_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","No Chii koŋe mɛ le gɛh yɛɛŋyɛɛŋ no ŋkoŋe bɛŋ. Bɛŋ mɛ gɛh bɛŋ nyû antɛnɛɛ a kiŋkoŋɛ kaŋ. ");
INSERT INTO ncr_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nɛ bɛŋ gɛ̂ɛde banchi baŋ, bɛŋ mɛ gɛh antɛnɛɛ a kiŋkoŋɛ kaŋ, gɛh no nle ŋgɛɛ banchi ba Chii, mɛ gɛh nyu antɛnɛɛ a kiŋkoŋɛ ke. ");
INSERT INTO ncr_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Mwɛɛ munɛ mù njɛme bɛŋ le, le lɛ kinlaŋye kaŋ nyûme fɛ bɛŋ le, bɛŋ mo bɛŋ kɛ̂me kinlaŋye kì le ki yisɛ. ");
INSERT INTO ncr_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nchi waŋ le wunɛ wù lɛ bɛŋ kôŋe gɛh no ŋkoŋe bɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Gɛ kiŋkoŋɛ kimu ka nyu yu kì kuge kì fede kì le lɛ muh nyâ kinche ke kì wu kwe nje nsáa ye gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Bɛŋ nɛ gee fiɛɛ fì nduu lɛ bɛŋ gêe, tu bɛŋ le nsáa yaŋ. ");
INSERT INTO ncr_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Gɛ ŋka ntɛŋe bɛŋ lɛ booŋ ba lɛme gɛ, nje gɛ mwa wu lɛme to wu kee fiɛɛ fichii fì chiji we wu lɛme gee gɛ. Ntɛŋe wa bɛŋ lɛ nsáa yaŋ nje fiɛɛ fichii fì n'yu a Chii le nle ŋge wa bɛŋ kɛɛ. ");
INSERT INTO ncr_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Gɛ gɛ̀ cha bɛŋ mɛ gɛ. Le mɛ wù gɛ̀ cha bɛŋ, mbaa bɛŋ ŋgɛɛ lɛ bɛŋ nyûme njɛ chɛ́ yì yune muntaŋ, muntaŋ mù lé mu mɛ̂ gɛh mu nyû yu. Nɛ bɛŋ gee noo, mo nyu la fì bɛŋ biide Chii le a jee chaŋ le tu wu lé wu nyâ bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nchi wù nyaa bɛŋ le abɛŋ le wunɛ, lɛ bɛŋ kôŋe ye yene. ");
INSERT INTO ncr_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Nɛ woŋ kfunɛ banɛ bɛŋ, bɛŋ kee lɛ wu gɛ̀ kɛ wa wu banɛ mɛ fɛ wu tu wu banɛ bɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nɛ bɛŋ bee bamii ba yi woŋ kfunɛ le, tu woŋ kfunɛ bee wu koŋe bɛŋ njɛ bamii baboo. Geenɛ, gɛ bɛŋ baaŋ bɛŋ nyu bamii ba le ba yi woŋ kfunɛ le gɛ. Nle ncha wa bɛŋ yi woŋ kfunɛ le. Nɛ fiɛɛ fì woŋ kfunɛ banɛ bɛŋ yu. ");
INSERT INTO ncr_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Bɛŋ kwâjɛ njɛmɛ wù ŋgɛ̀ njɛme bɛŋ le lɛ, gɛ mwa wu lɛme kuge wu fede chiji we wu lɛme gɛ. Nɛ ba boone bikaa a mɛ jiŋ, tu ba lé ba gê ba bôone tɛ a bɛŋ jiŋ. Nɛ le lɛ bo yuge njɛmɛ waŋ, tu bo lé bo gê bo yû tɛ wene. ");
INSERT INTO ncr_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Finɛ le fiɛɛ fì ba lé ba gê bɛ bɛŋ nje mɛ, nje gɛ bo kee muh wù gɛ̀ tuŋ mɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nɛ baaŋ nyu gɛ lɛ nle nto njɛmɛ bo le gɛ, tu bo be baaŋ kɛme gɛ jialɛ gɛ. Geenɛ, mɛɛse bo kɛme gɛ fiɛɛ fì bo tânyɛ jwe yu yi bimbefɛ biboo le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Muh wù banɛ mɛ banɛ tɛ Chii. ");
INSERT INTO ncr_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Be baaŋ nyu gɛ lɛ nle ŋge kfuu chi chilɛme chi muh gɛ baaŋ a yu gɛ wu ge a bo ntɛnɛɛ gɛ, tu bo be baaŋ kɛme gɛ jialɛ gɛ. Geenɛ bo le bo yɛŋ, bo tu bo banɛ mɛ mo Chii. ");
INSERT INTO ncr_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Finɛ fiɛɛ le noo ki fi gê jɛ to yi kojɛ no ba gɛ̀ saŋ a Ŋwa wu banchi baboo le lɛ, ‘Ba baŋ mɛ achiji.’ ");
INSERT INTO ncr_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Geenɛ, Muh wu Nfii wù nlé ŋgê nchîiŋsɛ lé wu gê wu tô, wu ja fɛ Chii le. Muh wu Nfii wunɛ le Kiyo kinchiɛɛŋ kibɛɛ kì jade fɛ Chii le. Sege wu to, wu lé wu bɛ̂ɛ jiŋ yi nsa waŋ. ");
INSERT INTO ncr_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Bɛŋ tɛ lé bɛŋ bɛ̂ɛ jiŋ yi nsa waŋ, nje bɛŋ gɛ̀ bee bɛ mɛ kɛge fɛŋkɛɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Njɛme mwɛɛ munɛ munchii bɛŋ le lɛ keefɛ bɛŋ gê bɛŋ gwê yi mbɛmɛ wene le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ba lé ba gê ba kûŋe bɛ bɛŋ yeh yi buunɛ le. Yi nchiɛɛŋ le, kife too lo ki muh doo wu yuuyi muh mu bɛŋ le, wu yûuyi wu kwaji lɛ wù gee nyu lɛme chi joŋe fɛ Nyo le. ");
INSERT INTO ncr_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bo lé bo gêe noo, nje bo baaŋ a kɛɛ gɛ Chii gɛ kɛnɛ mɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Njɛme mwɛɛ munɛ munchii bɛŋ le nɛ lɛ sege kife kiyu kojɛ, bɛŋ kwajɛ no ŋgɛ̀ njɛmɛ wa bɛŋ le kune mu. Ŋgɛ̀ mbaaŋ njɛmɛ gɛ mwɛɛ munɛ bɛŋ le fɛŋkɛɛ gɛ, nje ŋgɛ̀ bee besabɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Mɛɛse ntuu wa jiŋ fɛ wu wù gɛ̀ tuŋ mɛ le. Geenɛ, muh mu bɛŋ le baaŋ biih gɛ mɛne laa ŋgɛɛne faaŋ la. ");
INSERT INTO ncr_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Bɛŋ le yii yii nje nle njɛmɛ wa mwɛɛ munɛ bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","No fi le noo, nsɛŋe bɛŋ nchiɛɛŋ lɛ, fi joŋe fɛ bɛŋ le lɛ ŋgɛɛŋ. Nɛ mbaaŋ ŋgɛɛŋ gɛ, Muh wu Nfii wɛɛ gɛ to fɛ bɛŋ le gɛ. Geenɛ, ŋgɛnɛ lo, mɛ mo nchîiŋsɛ wu fɛ bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Sege wu lé wu tô, wu chîɛɛyɛ kinyi ki bamii ba le ba yi woŋ kfunɛ le, wu gê bo yɛ̂ŋ bimbefɛ biboo le, wu ge bo yɛŋ fiɛɛ fì le kinche ki chaaŋ le, wu ka wu ge tɛ ba yɛŋ fi le nsa wu le wù Nyo le. ");
INSERT INTO ncr_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Wu lé wu gê ba yɛ̂ŋ bimbefɛ biboo le, no bo baaŋ leesɛ gɛ muntele yi ye yaŋ le gɛ, ");
INSERT INTO ncr_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","wu gê ba yɛ̂ŋ fiɛɛ fì le kinche kì chaaŋ le no ŋgɛɛne wa fɛ Chii le, bɛŋ baaŋ bɛŋ ka bɛŋ yɛŋ mɛne gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Wu lé wu gê ba yɛ̂ŋ fiɛɛ fì le nsa wù Nyo le nje nfoŋ wù sage woŋ kfunɛ le nsa koo wa wu. ");
INSERT INTO ncr_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Mbaaŋ ŋkɛme mwɛɛ wesee ki njɛ̂me bɛŋ le, geenɛ gɛ taŋlo mu lee bintuŋ biɛna le mɛɛse chuule gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Sege Kiyo ki kinchiɛɛŋ lɛ lé ki tô, ki fi bɛŋ bɛŋ kɛɛ nchiɛɛŋ wuchii. Gɛ wu nyu wu jɛme nyu a bvuŋga bwe le gɛ. Fiɛɛ fichii fì wu le wu yu le fi fì wu lé wu gê wu jɛ̂me, wu mo wu sɛ̂ɛŋ bɛŋ mwɛɛ mù lé mu gê mu tô. ");
INSERT INTO ncr_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Wu lé wu gê wu dûnyɛ bvukugɛ bwaŋ, no wu lé wu gê wu jôde nyu fiɛɛ fì le fiaŋ wu sɛŋe bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Fiɛɛ fi Chii fichii le fiaŋ. Le fiɛɛ fì njɛme lɛ wu lé wu jôde nyu fiɛɛ fì le fiaŋ wu sɛŋe bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Shɛgɛ wa shige bɛŋ gɛ ka bɛŋ yɛŋ mɛne gɛ, doo nyu shige bɛŋ ka bɛŋ yɛŋ mɛne.” ");
INSERT INTO ncr_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","No Jiso jɛmɛ noo, booŋ be ba ŋgoo bamu ghaa lɛbolɛbo lɛ, “Le la fì wu duu besabɛŋ le lɛ, shɛgɛ wa shige bee gɛ ka be yɛŋ wu le gɛ, ge doo nyu shige be ka be yɛŋ wu le, bɛ lɛ wu gɛɛne fɛ Chii le? ");
INSERT INTO ncr_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Fiɛɛ fì wu tu duu lɛ shɛgɛ wa shige le lɛ la? Gɛ bee kɛɛ fiɛɛ fì wu jɛme noo gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jiso doo wu kɛɛ lɛ bo goone ki bo biih wu fiɛɛ fì wu jɛme, wu mo wu biih lɛ, “Bɛŋ ghaade lɛbɛŋlɛbɛŋ kune fiɛɛ fì njɛme, ‘Lɛ shɛgɛ wa shige bɛŋ gɛ ka bɛŋ yɛŋ mɛne gɛ, ge doo nyume shige bɛŋ ka bɛŋ yɛŋ mɛne?’ ");
INSERT INTO ncr_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nsɛ̂ŋe bɛŋ nchiɛɛŋ nchiɛɛŋ lɛ, bɛŋ lé bɛŋ gê bɛŋ bêede kwe, bɛŋ fûge bamii ba le ba yi woŋ kfunɛ le laŋe lo fiboo ye. Bɛŋ lé bɛŋ nyû yi yii le, geenɛ yii yene lé yi gê yi jâ yi tû kinlaŋye. ");
INSERT INTO ncr_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Sege kwɛse doo wu lune, wu tu wu yuge nsaasɛ, nje kife ke ki boyɛ le ki kojɛ ka. Sege wu boo mwa, wu gɛ ka wu yuge nsaasɛ wɛɛ gɛ, nje wu yuge wa nyu njoŋ lɛ muh wu wuŋ le wu to yi woŋ le. ");
INSERT INTO ncr_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Le gɛh no fi le fɛ bɛŋ le mɛɛse. Bɛŋ le yii yii, geenɛ ndoo ŋkaasɛ n'yɛŋ bɛŋ le, bɛŋ kɛ̂me nyu kinlaŋye fɛ muntele mwɛna le, kfuu chi kɛɛ kinlaŋye le ki nyu kì muh taŋlo wu gɛ fi a bɛŋ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Lé gê nyû kife kɛɛ le, bɛŋ gɛ kâ bɛŋ biih fiɛɛ mɛne gɛ. Nsɛŋe bɛŋ nchiɛɛŋ nchiɛɛŋ lɛ, nɛ bɛŋ biide la Chii le a jee chaŋ le, wu nyâ fi bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kɛge lo too bude mɛɛse, bɛŋ gɛ̀ baaŋ a biih gɛ fiɛɛ Chii le ajee chaŋ le gɛ. Bɛŋ biih, bɛŋ lé bɛŋ kɛ̂mɛ, wu lɛ kinlaŋye kena yisɛ. ");
INSERT INTO ncr_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Njɛme njɛmɛ wunɛ mɛ mage gɛ lo, geenɛ kife too lo ki mbaaŋ gɛ ŋka njɛme bɛŋ le mɛ mage gɛ lo gɛ. Nlé ŋgê njɛme wa bɛŋ le waaŋ kune Chii. ");
INSERT INTO ncr_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Lé gê nyû kife kɛɛ le, bɛŋ bîide fiɛɛ Chii le ajee chaŋ le. Gɛ njɛme bɛŋ le lɛ nlé ŋgê nlɛ̂gɛ fiɛɛ a Chii le bɛŋ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Chii kibɛɛ koŋe bɛŋ, nje bɛŋ le bɛŋ koŋ mɛ bɛŋ ka bɛŋ bɛɛŋ lɛ nja fɛ wu wù Chii le. ");
INSERT INTO ncr_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ŋgɛ̀ ja fɛ Chii le nto yi woŋ kfunɛ le, njade wa yi woŋ kfunɛ le ntuu jiŋ fɛ Chii le.” ");
INSERT INTO ncr_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","No Jiso jɛmɛ noo booŋ be ba ŋgoo bɛɛsɛ lo bo du lɛ, “Ahaa! Wo jɛme wa mɛɛse waaŋ gɛ wo ka mage lo gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mɛɛse bee le bee yɛŋ wa lɛ wo kee mwɛɛ munchii wo chiɛɛne gɛ lɛ muh biih fiɛɛ wo le gɛ. Finɛ fiɛɛ le fi ge bee mo be bɛɛŋ lɛ wo ja fɛ Nyo le.” ");
INSERT INTO ncr_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jiso chvuu bo le lɛ, “Bɛŋ nɛ le bɛŋ bɛɛŋ mɛɛse? ");
INSERT INTO ncr_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kife too lo, ki to wa, kì bɛŋ lé bɛŋ sâaŋɛ wu mumwaa wu mumwaa muh gɛɛne a wu yeh, bɛŋ chinɛ mɛne mɛ maa. Geenɛ gɛ mɛ nyu mɛ maa gɛ, nje Chii le besa wu. ");
INSERT INTO ncr_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Njɛme mwɛɛ munɛ bɛŋ le fi le lɛ bɛŋ le yi ye yaŋ le, bɛŋ mo bɛŋ kɛ̂me nyiɛgee. Yi woŋ kfunɛ le, le bɛŋ kɛme baŋgɛ, geenɛ bɛŋ kâane shɛ́ŋ. Nle nso wa woŋ kfunɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","No Jiso gɛ̀ jɛmɛ njɛmɛ wunɛ wu mɛsɛ, wu chiaasɛ ajii wu bijɛ we wu buunɛ lɛ, “Chii, kife le ki kojɛ ka. Dunyɛ bvukugɛ bvu Mwa yo, fi le lɛ Mwa taŋlo wu dûnyɛ bvukugɛ bwuŋ. ");
INSERT INTO ncr_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Wu taŋlo wu dûnyɛ nje wo le wo nya wu bvuŋga awe a muh wu wuŋ wuchii, lɛ wu nyâ kinche kì kage gɛ bo baa bachii ba wo le wo nya wu le. ");
INSERT INTO ncr_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kinche kì kage gɛ kinɛ le finɛ fì le lɛ bo kêe wo lɛ le gɛh wo wù Nyo wu nchiɛɛŋ, bo ka kee tɛ mɛ wù Jiso Kletu wu wo tuŋ. ");
INSERT INTO ncr_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nle ndunyɛ wa bvukugɛ bwuŋ yi nshɛŋ le no nle mɛsɛ wa lɛme chì wo nya lɛ nlɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Yi mɛɛse le Chii, kaasɛ wo nyâ mɛ bvukugɛ mbebe yo le bvù ŋgɛ̀ nshee ŋkɛme fweele fɛ woŋ kɛ. ");
INSERT INTO ncr_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nle ndunyɛ wa wo bamii ba wo gɛ̀ baayɛ woŋ kfunɛ le wo nya mɛne. Bamii banɛ gɛ̀ bee buŋ, wo mo wo nya bo mɛne. Bo le bo yu jɛ yo. ");
INSERT INTO ncr_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Bo le bo kɛɛ wa mɛɛse lɛ fiɛɛ fichii fì ŋkɛme le fi ja nyu fɛ wo le. ");
INSERT INTO ncr_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Njɛme nɛ nje nle nnya wa jɛ yì wo gɛ̀ nya mɛne bo le, bo fi, bo mo bo kɛɛ yi nchiɛɛŋ lɛ nja fɛ wo le, bo bɛɛŋ tɛ lɛ tuŋ wo mɛ. ");
INSERT INTO ncr_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Mbuune nɛ nyu fɛ bo banɛ le. Gɛ mbuune nyu fɛ bo baa ba le ba yi woŋ kfunɛ le gɛ. Mbuune nyu fɛ bo banɛ ba wo le wo nya mɛne, nje le bamii buŋ. ");
INSERT INTO ncr_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Mwɛɛ munchii mù ŋkɛme le mwuŋ, mwɛɛ mu munchii mù wo kɛme le mwaŋ. Le yi bo le wu bvukugɛ bwaŋ chuunyi. ");
INSERT INTO ncr_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mɛɛse gɛ mbaaŋ yi woŋ kfunɛ le gɛ. Geenɛ bo baaŋ yi woŋ kfunɛ le, ŋkaase wa ntoo fɛ wo le. Chii wù yuude, chiɛnɛ bo ajee chuŋ chi wo le wo nya mɛne, fi le lɛ bo nyû yi muh le wu mumwaa gɛh no besa wo le yi muh le wu mumwaa. ");
INSERT INTO ncr_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Sege ŋgɛ̀ bee besa bo, ŋgɛɛ bo ajee chuŋ chi wo nya mɛne. Nle nchiɛɛŋ bo, muh mu bo le baaŋ lɛsɛ gɛ, fede gɛ wuwɛɛ wù gɛ̀ bee wa ki wu lɛ̂sɛ. Finɛ gɛ̀ bee fi le lɛ fiɛɛ fì ba gɛ̀ saŋ a Ŋwa wu Nyo le, fi to fi kojɛ. ");
INSERT INTO ncr_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Mɛɛse ŋkaase wa ntoo fɛ wo le, mwɛɛ munɛ le njɛme mbaaŋ yi woŋ kfunɛ le fi le lɛ taŋlo bo kɛme njoŋ waŋ wu yisɛ ye yiboo le. ");
INSERT INTO ncr_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nle nnya wa jɛ yo chiaaŋ yiboo le, bamii ba le ba yi woŋ kfunɛ le mo bo banɛ bo nje gɛ bo nyu bamii ba yi woŋ kfunɛ le gɛ, yɛɛŋyɛɛŋ tɛ no gɛ mɛ nyu muh wu yi woŋ kfunɛ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Gɛ mbuune nɛ lɛ wo bvûsɛ bo yi woŋ kfunɛ le gɛ. Mbuune nyu lɛ wo gɛ̂ŋ bo lɛ keefɛ bo lêe chiaaŋ yi muh wu kimbefɛ wɛɛ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Gɛ bo nyu bamii ba yi woŋ kfunɛ le gɛ, yɛɛŋyɛɛŋ tɛ lɛ gɛ mɛ nyu muh wu yi woŋ kfunɛ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Sêesɛ bo wo gɛɛ, bo yûude antɛnɛɛ a kinchiɛɛŋ. Jɛ yo le kinchiɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","No wo gɛ tuŋ mɛ yi woŋ kfunɛ le, le gɛh yɛɛŋyɛɛŋ no nle ntuŋ bo yi woŋ kfunɛ le. ");
INSERT INTO ncr_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mɛ mo nseesɛ kikwɛɛ kaŋ ŋgɛɛ nje bo, wu lɛ taŋlo bo tɛ sêesɛ biboo bikwɛɛ bo gɛɛ yi kinchiɛɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Gɛ mbuune gɛh nyu fɛ bamii banɛ le maa gɛ. Mbuune tɛ fɛ bamii bachii bo lé bo gê bo yû jɛ yiboo bo leesɛ muntele yi ye yaŋ le. ");
INSERT INTO ncr_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mbuune lɛ bo bachii nyûme yi muh le wu mumwaa gɛh no wo wu Chii le yi ye yaŋ le mɛ nyume yi ye yo le. Mbuune lɛ bo tɛ gê bo nyû ye yese besa wo le lɛ bamii ba le ba yi woŋ kfunɛ le bo bɛ̂ɛŋ lɛ gɛ̀ tuŋ wo mɛ. ");
INSERT INTO ncr_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Bvukugɛ bvù wo gɛ̀ buu mɛ yu, nle nya wa bo le lɛ bo nyû yi muh le wu mumwaa, gɛh no besa wo le yi muh le wu mumwaa, ");
INSERT INTO ncr_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","nle yi bo le, wo nyu yi ye yaŋ le. Lɛ bo nyû yi muh le wu mumwaa, noo, bamii ba le ba yi woŋ kfunɛ le mo bo kɛɛ lɛ tuŋ wo mɛ, wo koŋe bo gɛh no wo koŋe mɛ. ");
INSERT INTO ncr_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Chii, ŋgoone lɛ bobaa ba wo le wo nya mɛne ge bo nyûme tɛ besa bo fɛ nle nyû fo, wu lɛ bo ge bo yɛ̂ŋ bvukugɛ bvù wo gɛ̀ nya mɛne nje kiŋkoŋɛ kuŋ fɛ mɛne fɛ woŋ kfunɛ kɛ. ");
INSERT INTO ncr_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ooo Chii wù chaaŋ, gɛ bamii ba le ba yi woŋ kfunɛ le kee wo gɛ, geenɛ ŋkee wo, bamii baŋ banɛ le bo kɛɛ lɛ tuŋ wo mɛ. ");
INSERT INTO ncr_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nle ŋge wa bo kɛɛ wo, mbaaŋ ki ŋgee bo kêe wo, wu lɛ kiŋkoŋɛ kì wo koŋe mɛ yu taŋlo ki nyûme yi bo le, mɛ tɛ nyu yi bo le.” ");
INSERT INTO ncr_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","No Jiso gɛ̀ buunɛ wu mɛsɛ, bɛ booŋ be ba ŋgoo ja fo, bo gɛɛŋ bo daŋ kiwolo kì ba tɛŋe lɛ Kidloŋ, bo bu wuŋ kwege fɛ mwɛ wu bite bi muntaŋ le, bo lee yo. ");
INSERT INTO ncr_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Juda wù gɛ̀ gesɛ Jiso gɛ̀ kee tɛ kijusɛ kɛɛ, nje Jiso bɛ booŋ be ba ŋgoo gɛ̀ gɛɛne bo taashi fo lɛfolɛfo. ");
INSERT INTO ncr_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Noo, Juda mo wu gɛɛŋ fo bɛ ŋgoo yi bamii ba nchi mo bamii bamu ba gɛ̀ chiɛɛne yeh yi kintanyɛ. Bamii banɛ gɛ̀ tuŋ bachiji kintanyɛ ba baaŋ baaŋ mo Bafalashii. Bo gɛ̀ gɛɛne bo kɛme bin'yesɛ bɛ chiŋguji chì ba chu mo mwɛɛ mu jɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","No Jiso gɛ̀ kee wa fiɛɛ fì gɛ̀ bee ki fì kooshɛ bɛ wu, wu mo wu kɛŋsɛ wu to fwe, wu biih bo le lɛ, “Bɛŋ goone nyu yɛɛŋ?” ");
INSERT INTO ncr_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Bo chvuu wu le lɛ, “Jiso wu Nasalɛ.” Jiso jɛmɛ bo le lɛ, “Le mɛ wuyu.” Gɛ̀ bee Juda wu gɛ̀ gesɛ wu, wu lɛme bɛ bamii baa. ");
INSERT INTO ncr_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","No Jiso jɛmɛ bo le lɛ, “Le mɛ wuyu,” bo kaasɛ bo tu lo jiŋ jiŋ, bo gweeyɛ fɛkuu. ");
INSERT INTO ncr_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Wu ka wu biih bo le lɛ, “Bɛŋ goone nyu yɛɛŋ?” Bo chvuu lɛ, “Jiso wu Nasalɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jiso jɛmɛ bo le lɛ, “Nle nsɛɛŋ wa bɛŋ le lɛ le mɛ wuyu. Nɛ bɛŋ goone nyu mɛ, bɛŋ chinɛ bamii banɛ le bo gɛɛne.” ");
INSERT INTO ncr_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Wu gɛ̀ jɛme noo ki wu gê fi to fi kojɛ jɛ yì wu gɛ̀ jɛmɛ wa Chiji le lɛ, “Mbaaŋ lɛsɛ gɛ wu mumwaa fɛ baa ba wo gɛ̀ nya mɛne gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Samoŋ Bita gɛ̀ kɛme nyo yi jɛŋ. Wu mo wu baa yi a ŋku le, wu chuŋ kintuŋ ki nfwa wu kikwɛɛ ki bachiji kintanyɛ kinchiɛɛŋ yu, ki suunɛ. Jee chi nfwa wɛɛ gɛ̀ bee Maliku. ");
INSERT INTO ncr_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jiso jɛmɛ Bita le lɛ, “Kâasɛ chvûu nyo yo a ŋku le. Gɛ mɛ nyu mmù a fiŋkoo fi ŋgɛ fì Chii le wu nya mɛne gɛ?” ");
INSERT INTO ncr_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kikwɛɛ ki bamii ba nchi bɛ ŋgoo yi bamii ba nchi mo bamii ba gɛ̀ chiɛɛne yeh yi kintanyɛ yi Bajuu mo bo fajɛ Jiso le bo kaaŋ wu bɛ bakfuu. ");
INSERT INTO ncr_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Bo ya bo jo wu bo gɛɛŋ bɛ wu fɛ Anas le, nje Anas gɛ̀ bee chiji kwɛ Kayfa wù gɛ̀ bee kikwɛɛ ki bachiji kintanyɛ kiluŋ kɛɛ le. ");
INSERT INTO ncr_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Le Kayfa wunɛ wù gɛ̀ nya nteefɛ Bajuu le lɛ fi joŋe lɛ muh wu mumwaa kwê fɛ bamii le bachii. ");
INSERT INTO ncr_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","No bo gɛ gɛɛne bɛ Jiso noo, Samoŋ Bita bɛ mwa ŋgoo wu Jiso wumu gɛ̀ biih wu le. No mwa ŋgoo wu Jiso wunɛ gɛ̀ bee kikwɛɛ ki bachiji kintanyɛ kee wu, wu mo wu bi Jiso le wu gɛɛŋ wu lee fɛ lakfulɛ chi kikwɛɛ ki bachiji kintanyɛ le. ");
INSERT INTO ncr_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Bita shɛɛ wu lɛme akfuuŋ mbebe jwe wu kitaŋ le. Lɛ mwa ŋgoo wu Jiso wɛɛ wù kikwɛɛ ki bachiji kintanyɛ gɛ̀ kee wu, gɛ̀ kaasɛ wu bu wu to, wu jɛme bɛ mwa wù kwɛse wù gɛ̀ chiɛɛne jwe wu kitaŋ, wu jo Bita wu lee bɛ wu. ");
INSERT INTO ncr_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mwa wù kwɛse wù gɛ̀ lɛne fɛ la chiɛɛ le biih Bita le lɛ, “Gɛ wo tɛ nyume muh wu ŋgoo yi muh wunɛ le gɛ?” Bita chvuu lɛ, “Gɛ nnyu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Gɛ̀ bee akfuuŋ jiɛɛ, booŋ ba lɛme bɛ bamii ba gɛ̀ chiɛɛne yeh yi kintanyɛ bo fwɛɛ ŋgu bo lɛme fo bo yɛse. Bita mo wu fe, wu gɛɛŋ wu lɛme bɛ bo wu yɛse tɛ. ");
INSERT INTO ncr_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kikwɛɛ ki bachiji kintanyɛ tu ki biide mwɛɛ Jiso le kune booŋ be ba ŋgoo mo kune n'yɛyɛ we. ");
INSERT INTO ncr_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jiso chvuu wu le lɛ, “Ŋgɛ̀ nto njɛme woŋ le wuchii fi chuunyi waaŋ. Nto n'yɛyi bamii yéh yi buunɛ le mo yéh yì kintanyɛ le fɛ Bajuu bachii le bo taashɛ fo. Gɛ nto njɛme fiɛɛ fimi nyilɛ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Wo biide mwɛɛ munɛ mɛne nje la? Wo bîide nyu bamii bò to bo yuge no nto n'yɛyi le. Bo kee fiɛɛ fì nto njɛme.” ");
INSERT INTO ncr_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","No Jiso jɛme noo, muh mu ŋgoo yi bamii ba gɛ̀ chiɛɛne yeh yi kintanyɛ gɛ̀ lɛme mbebe le wu tuŋ Jiso bɛ kibo bvushi le, wu biih wu le lɛ, “Yinɛ le je yì wo chvuse fiɛɛ yu kikwɛɛ ki bachiji kintanyɛ le?” ");
INSERT INTO ncr_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jiso biih wu le lɛ, “Mɛ nɛ le njɛme njiaa, wo dunyɛ jialɛ chiyu. Nɛ le lɛ njɛme nyu nchiɛɛŋ, wo ka wo suŋ lo mɛ nje la?” ");
INSERT INTO ncr_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anas mo wu ja wu chiiŋsɛ Jiso fɛ Kayfa wù kikwɛɛ ki bachiji kintanyɛ le. Jiso gɛ̀ bee wu baaŋ ba nyu ba kaaŋ wu bɛ bakfuu. ");
INSERT INTO ncr_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","No Samoŋ Bita gɛ̀ baaŋ wu lɛme wu yɛse ŋgu, bamii biih wu le lɛ, “Gɛ wo nyume muh mu ŋgoo yi bamii be le gɛ?” Geenɛ Bita faŋ wu jɛmɛ lɛ, “Gɛ mɛ nyume muh mu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mwa wu lɛme wu kikwɛɛ ki bachiji kintanyɛ wumu ka wu biih Bita le lɛ, “Mbe mbaaŋ n'yɛŋ gɛ wo le bena wu fɛ mwɛ wu kitaŋ kwɛɛ le gɛ?” Mwa wu lɛme wɛɛ gɛ̀ bee muh wu kfuu chi muh wɛɛ wu Bita gɛ̀ suunɛ kintuŋ ke. ");
INSERT INTO ncr_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Bita ka wu faŋ. Gɛh segeyu, nyishii mo yi toŋ. ");
INSERT INTO ncr_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Bamii mo bo jo Jiso fɛ yeh yi Kayfa le bo gɛɛne bɛ wu a nto wu muh wu Lum wu gɛ̀ sage yo le. Gɛ̀ bee baaŋ antaana. Bo doo bo gɛɛŋ bo gɛ baaŋ lee gɛ̀ fiboo bo gɛɛŋ anto wu muh wɛɛ le gɛ, nje bo gɛ̀ leese lo, bo mo bo tuu ŋkfuŋ, bo gɛ ka bo ji Ŋka wu Ndaŋfe gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Noo, Balɛt mo wu bu wu to wu yɛŋ bo le wu biih bo le lɛ, “Fiɛɛ fì bɛŋ yɛŋ muh wunɛ jiaa le la?” ");
INSERT INTO ncr_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bo chvuu wu le lɛ, “Muh wunɛ be baaŋ ge gɛ fiɛɛ fì befe gɛ, tu bee be baaŋ to gɛ bɛ wu ki be nya wo le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Balɛt chvuu bo le lɛ, “Bɛŋ jô wu bɛŋ sâ wu, bii no nchi wene goone.” Bajuu du wu le lɛ, “Gɛ bee kɛme bvuŋga ki be yuuyɛ muh gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Njɛmɛ wunɛ mo wu ge fi kojɛ a jɛ yi Jiso gɛ jɛmɛ wa le, ki wu dûunyi kfuu chi kwe yì wu gɛ̀ bee ki wu kwê yi le. ");
INSERT INTO ncr_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Balɛt kaasɛ wu lee wu gɛɛŋ a nto we le, wu tɛɛŋ ba to bɛ Jiso, wu biih wu le lɛ, “Le wo wu le Nfoŋ Bajuu?” ");
INSERT INTO ncr_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jiso biih wu le lɛ, “Wo jɛme finɛ nyu ŋkwajɛ wu wo noo, jɛmɛ bamii bamu wo le kune mɛ?” ");
INSERT INTO ncr_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Balɛt biih wu le lɛ, “Nle muh wu Bajuu? Le bamii buŋ ba woŋ bɛ bachiji kintanyɛ ba baaŋ baaŋ bo to bɛ wo bo nya mɛne. Wo jiale nyu la?” ");
INSERT INTO ncr_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jiso chvuu wu le lɛ, “Gɛ bvunfoŋ bwaŋ nyu njɛ bvu yi woŋ kfunɛ le gɛ. Nɛ bvunfoŋ bwaŋ be bee njɛ bvu yi woŋ kfunɛ le, tu bamii baŋ ba lɛme be bo ju, lɛ keefɛ ba nyâ mɛ chiaaŋ yi Bajuu le gɛ. Geenɛ gɛ bvunfoŋ bwaŋ nyu bvu ja yi woŋ kfunɛ le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Balɛt mo wu biih wu le lɛ, “Nɛ lɛ wo le nfoŋ?” Jiso chvuu wu le lɛ, “Le no wo jɛme lɛ nle nfoŋ. Ba gɛ̀ boo mɛ, nto yi woŋ kfunɛ le nje finɛ fi le lɛ nto njɛme kune kinchiɛɛŋ. Muh wuchii wu bii kinchiɛɛŋ le to wu yuge jɛ yaŋ.” ");
INSERT INTO ncr_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Balɛt ghaa lɛ, “Nchiɛɛŋ le la?” No wu ghale noo wu mo wu kaasɛ wu bu wu gɛɛŋ wu yɛŋ Bajuu baa le wu jɛmɛ bo le lɛ, “Mbaaŋ n'yɛŋ gɛ fiɛɛ fì wu jiale le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Geenɛ bɛŋ kɛme kinche kena lɛ ge doo nyume yi kife ki Ŋka wu Ndaŋfe le, mbvusɛ muh wu ncha wu mumwaa yeh yi ncha le. Bɛŋ goone lɛ mbvusɛ nyu nfoŋ wene wu Bajuu?” ");
INSERT INTO ncr_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Bajuu baa waŋ lo fɛwɛɛwe lɛ, “Aay, gɛ̀ bee goone muh wunɛ gɛ, bvusɛ nyu Balaba!” Balaba wunɛ gɛ̀ bee muh a ŋgoo yi bamii ba gɛ̀ juu bɛ bala wu Lum. ");
INSERT INTO ncr_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Balɛt mo wu jo Jiso wu nya ba ndiinyɛ wu. ");
INSERT INTO ncr_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Bamii ba nchi lu kifo ki bvunfoŋ ki nyu mbiaŋmbiaŋ bo booŋ a wu fwa, bo jo njú yi bvunfoŋ yi yɛɛle lo, bo susɛ ye ye le. ");
INSERT INTO ncr_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bo mo bo too fɛ wu le bo buune wu, bo duu lɛ, “Biaa yi bimbaaŋ! Nfoŋ Bajuu!” No bo gee noo, bo maamɛ wu bɛ chiaaŋ. ");
INSERT INTO ncr_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Balɛt ka wu bu akfuuŋ wu du bamii le lɛ, “Bɛŋ yɛŋ, mbvuse muh wunɛ nnya bɛŋ le, fi le lɛ bɛŋ kɛɛ lɛ mbaaŋ n'yɛŋ gɛ fiɛɛ fì wu jiale le le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jiso mo wu bu wu too bɛ kifo ki mbiaŋ fwa mo njú yi bvunfoŋ ye le. Balɛt mo wu jɛmɛ bo le lɛ, “Bɛŋ jîŋɛ bɛŋ yɛ̂ŋ nɛ muh wuyu wunɛ!” ");
INSERT INTO ncr_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","No bachiji kintanyɛ ba baaŋ baaŋ bɛ bamii ba gɛ̀ chiɛɛne yeh yi kintanyɛ doo bo yɛŋ wu le noo, bo mo bo tu bo wanɛ lo lɛ, “Tâ lo wu yi kintaaŋ le, tâ lo wu yi kintaaŋ le!” Balɛt jɛmɛ bo le lɛ, “Bɛŋ jô wu bɛ chiaaŋ yene bɛŋ tâ yi kintaaŋ le, nje mbaaŋ n'yɛŋ gɛ jialɛ che le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Bajuu baa chvuu wu le lɛ, “Bee kɛme nchi wese, nchi wuyu duunyi lɛ wù kɛme ki wu kwê, nje wu le wu jo kikwɛɛ ke lɛ wu le Mwa Nyo.” ");
INSERT INTO ncr_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Balɛt doo wu yu njɛme wunɛ noo wù kɛme lo nfaaŋ baaŋ. ");
INSERT INTO ncr_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Bɛ Jiso tu jiŋ a kibuu le, wu biih Jiso le lɛ, “Wo ja faaŋ?” Geenɛ Jiso gɛ chvuu lo fiɛɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Balɛt biih Jiso le lɛ, “Gɛ wo nyu wo jɛmɛ mɛne gɛ? Gɛ wo kee lɛ ŋkɛme bvuŋga ki nchinɛ wo le, ŋka ŋkɛme bvuŋga ki ndu ba ta wo yi kintaaŋ le gɛ?” ");
INSERT INTO ncr_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jiso chvuu wu le lɛ, “Gɛ taŋlo wo kɛme bvuŋga a mɛ we njɛ ba le ba nya bvuŋga bvuyu wo le fɛwe sɛŋ gɛ. Noo, nje finɛ fiɛɛ muh wù nya mɛ chiaaŋ yo le wu kɛme kimbefɛ kì kuge ki fede kuŋ.” ");
INSERT INTO ncr_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Balɛt doo wu yu njɛmɛ wunɛ, wu mo wu kɛ wu tu wu goone je ki wu chînɛ wu le. Geenɛ Bajuu waŋ lo fɛwɛɛwe lɛ, “Nɛ wo moŋ lo wo chinɛ muh wunɛ le, tu gɛ wo nyu nsaa yi Kaisa wù Nfoŋ wù baaŋ wu Lum gɛ. Muh wuchii wù yuuse kikwɛɛ ke, lɛ wu le Nfoŋ le muh wu kimbanɛ wu Kaisa.” ");
INSERT INTO ncr_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Balɛt doo wu ka wu yu wunɛ njɛmɛ, wu mo wu bu bɛ Jiso, wu shii yi kinta ki nsa le, fɛ Kijusɛ kì ba tɛŋe lɛ ba jonɛ bɛ Ata, nyume a jɛ́ yi Ibulu le lɛ Gabata. ");
INSERT INTO ncr_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Gɛ̀ bee Juu chi Nseesɛ wu Ŋka wu Ndaŋfe, kife gɛ̀ bee wa njɛ juu bikaa yuufe ncho bifɛɛ. Balɛt jɛmɛ Bajuu le lɛ, “Bɛŋ jîŋɛ bɛŋ yɛ̂ŋ nɛ Nfoŋ wene wunɛ!” ");
INSERT INTO ncr_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Bajuu baa tu bo wanɛ lo lɛ, “Gɛ̂nɛ lo bɛ wu, gɛ̂nɛ lo bɛ wu, tâ lo wu yi kintaaŋ le!” Balɛt biih bo le lɛ, “Nta Nfoŋ wene yi kintaaŋ le?” Bachiji kintanyɛ ba baaŋ baaŋ chvuu wu le lɛ, “Gɛ bee kɛme Nfoŋ wumu fede Kaisa gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Balɛt mo wu nya Jiso bo le lɛ bo gɛɛŋ bo tâ yi kintaaŋ le. ");
INSERT INTO ncr_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Bo mo bo jo Jiso bo bu bɛ wu. Wu tuu kintaaŋ ke wu gɛɛne fɛ ba tɛŋe lɛ Ŋgboge wu Kikwɛɛ, ba tɛŋe a jɛ́ yi Ibulu le lɛ Golgota. ");
INSERT INTO ncr_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Bo mo bo gɛɛŋ bo ta wu fo yi kintaaŋ le, bo ta tɛ bamii bamu bafɛɛ yi bintaaŋ le, wumu anchiɛɛŋ, wumu aŋkoŋo, Jiso nyu antɛnɛɛ. ");
INSERT INTO ncr_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Balɛt tɛ saŋ fiɛɛ fimi ba ta yi kintaaŋ ki Jiso le. Fiɛɛ fì wu gɛ̀ saŋ gɛ̀ bee lɛ, “Jiso wu Nasalɛ, Nfoŋ wu Bajuu.” ");
INSERT INTO ncr_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Bajuu ba duude gɛ̀ tɛɛŋ fiɛɛ fì wu gɛ̀ saŋ fiyu, nje fɛ ba gɛ̀ ta Jiso yi kintaaŋ le fo gɛ̀ bee mbebe a kilaantɛŋ le, wu gɛ̀ saŋ fiɛɛ finɛ a jɛ́ yi Ibulu le bɛ yi Latiŋ mo a yi Glek le. ");
INSERT INTO ncr_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Bachiji kintanyɛ ba baaŋ baaŋ bɛ Bajuu bo gɛɛŋ bo jɛmɛ Balɛt le lɛ, “Keefɛ wo sâŋ lɛ, ‘Nfoŋ wu Bajuu gɛ.’ Saŋ nyu lɛ, ‘Muh wunɛ duu lɛ wu le Nfoŋ wu Bajuu.’” ");
INSERT INTO ncr_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Balɛt chvuu bo le lɛ, “Fiɛɛ fì nsaŋ nle nsaŋ wa.” ");
INSERT INTO ncr_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","No bamii ba nchi gɛ̀ ta wa Jiso yi kintaaŋ le, bo mo bo jo njú ye bo ga bikwɛɛ biboo le manjuu manɛh no bo gɛ̀ bee. Bo gɛ̀ jo mo kikuŋ ke. Geenɛ kikuŋ kinɛ ba gɛ̀ tuŋ lo abadaa le, kɛge kindoŋ le boge bude yi bikaa le. ");
INSERT INTO ncr_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Noo, bo mo bo jɛme lɛbolɛbo lɛ, “Keefɛ besabɛŋ saayɛ kikuŋ kinɛ gɛ. Bee tuŋ kaŋ yu, be yɛŋ muh wù lé wu kɛ̂mɛ.” Finɛ fiɛɛ gɛ̀ kooshi ki fi gê fi to fi kojɛ no ba gɛ̀ saŋ a Ŋwa wu Nyo le lɛ, “Bo gɛ̀ ga njú yaŋ yi bikwɛɛ biboo le, bo tuŋ kaŋ bɛ kikuŋ kaŋ.” Noo, bamii ba nchi baa gɛ̀ ge gɛh nyu fiɛɛ fiyu finɛ. ");
INSERT INTO ncr_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Bikɛse bamu gɛ̀ lɛme fo mbebe yi kintaaŋ ki Jiso le. Bikɛse banɛ gɛ̀ bee bwe Jiso bɛ mwa bwe bwe Jiso wù kwɛse mo Mɛɛle wù kwɛ Kloba mo Mɛɛle Madaleŋ. ");
INSERT INTO ncr_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jiso gɛ̀ ja wu yɛŋ bwee le, mo mwa ye wu ŋgoo wɛɛ wù wu gɛ̀ koŋe, bo lɛme mbebe ye le, wu jɛmɛ bwee le lɛ, “Kwɛse, bîjɛ yɛ̂ŋ, wunɛ le wa mwa yo.” ");
INSERT INTO ncr_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","No wu jɛmɛ noo, wu kaasɛ wu jɛmɛ tɛ mwa ye wu ŋgoo wɛɛ le lɛ, “Bîjɛ yɛ̂ŋ, wunɛ le wa bwoo.” Kɛge sege kɛɛ mwa ye wu ŋgoo wɛɛ mo wu jo bwe Jiso wu gɛɛŋ bɛ wu tu bo chee wa nyu a wu yeh. ");
INSERT INTO ncr_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ajiŋ ayu no Jiso gɛ̀ kee lɛ fiɛɛ fichii le fi ka wa, wu mo wu ja ki wu gê fi kojɛ no ba gɛ̀ saŋ a Ŋwa wu Nyo le, wu jɛmɛ lɛ, “Kindoŋ yune mɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ŋkonyi wumu gɛ̀ bee fo bɛ mbvuuŋ ma ŋgbwamɛ mo yisɛ yo. Bamii ba nchi baa mo bo fuuŋ kfusha yo bo booŋ yi finte fi isob le bo chiaasɛ we fɛ jwe we le. ");
INSERT INTO ncr_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jiso doo wu fi mbvuuŋ maa wu mo wu jɛmɛ lɛ, “Fi le fi ka wa.” No wu jɛmɛ noo, wu ŋgvuusɛ kikwɛɛ, kiyo ke mo ki bu. ");
INSERT INTO ncr_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","No abvu gɛ̀ bee juu chi nseesɛ ki bo lee juu chi yuuŋ le, Bajuu tu bo goone ki bo ge lɛ keefɛ agvuŋ ayu mɛ yi bintaaŋ le juu chi yuuŋ gɛ, (tete yuuŋ chiyu gɛ̀ bee chi baaŋ). Bo mo bo gɛɛŋ bo yɛŋ Balɛt le bo lɛgɛ lɛ wu du bo ŋgoojɛ bikaa bi bamii ba gɛ̀ bee yi bintaaŋ le baa fi fɛ bo yaŋsɛ bo kweeyɛ ba shiishɛ bo, ba chiaasɛ. ");
INSERT INTO ncr_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Noo, bamii ba nchi mo bo to bo ŋgoojɛ bikaa bi muh wù fwe wɛɛ, bo ŋgoojɛ tɛ bi muh mu wɛɛ wù ba gɛ̀ ta bɛ wu. ");
INSERT INTO ncr_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Geenɛ, bo gɛ̀ doo bo to bo bu fɛ Jiso le, bo yɛŋ lɛ wu le wu kwe wa, bo gɛ ka bo ŋgoojɛ bikaa bie gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Muh mu ŋgoo yi bamii ba nchi le booŋ chita chi Jiso bɛ gooŋ. No wu bonɛ noo, kimimia kilɛmɛ bɛ joo ta bu fo. ");
INSERT INTO ncr_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Muh wù gɛ̀ yɛŋ mwɛɛ munɛ le, le wu bɛɛ jiŋ yi nsa wuyu, njɛmɛ we nyu nchiɛɛŋ, wu kee lo lɛ wu jɛme nyu nchiɛɛŋ lɛ taŋlo bɛŋ bɛ̂ɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Mwɛɛ munɛ gɛ̀ kooshi lɛ fiɛɛ fì ba gɛ̀ saŋ a Ŋwa wu Nyo le to fi kojɛ no ba gɛ̀ saŋ lɛ, “Gɛ kiŋkufɛ ke kimimia ba gɛ̀ ŋgode gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Fi ka nyu ba saŋ kijusɛ kimu le a Ŋwa wu Nyo le lɛ, “Bamii lé bo gê bo jîiŋe muh wɛɛ wù ba le ba booŋ.” ");
INSERT INTO ncr_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ajiŋ ayu Yosɛf wu Alimatia ja wu gɛɛŋ wu yɛŋ Balɛt le wu lɛgɛ lɛ wu bɛɛŋ wu jo gvunɛ chi Jiso. Yosɛf wunɛ gɛ̀ bee muh ŋgoo yi Jiso le, geenɛ wù nyu gɛh ajiŋ ajiŋ nje wu gɛ̀ faane Bajuu. Balɛt bɛɛŋ, wu mo wu gɛɛŋ ki wu jô gvunɛ chiyu. ");
INSERT INTO ncr_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodɛmu wù gɛ̀ ya wu gɛɛŋ wu yɛŋ Jiso le kintaŋ kimi le wu to tɛ bɛ mɛɛ ma gwee wuŋ bɛ alos ba taashɛ ba fiiŋsɛ, njijɛ wuyu gɛ̀ bee njɛ bakilu mbanshɛ ncho batɛde. ");
INSERT INTO ncr_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Bɛ wu shiishɛ gvunɛ chi Jiso, bo yefɛ bɛ mɛɛ mà gwee wuŋ, ba baŋɛ bɛ nju, ba jiiyɛ wu no gɛ̀ bee a kinche ki woŋ wu Bajuu le. ");
INSERT INTO ncr_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Mwɛ wu kintaŋ wumu gɛ̀ bee mbebe fɛ ba gɛ̀ ta Jiso yi kintaaŋ le fo. Mwɛ wuyu gɛ̀ bee jɛŋ yifiɛŋ nyu fo ba baaŋ muh yo a jiiyɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Noo, no abvu gɛ̀ bee juu chi Bajuu chi Nseesɛ wu juu chi Yuuŋ, jɛŋ yiyu nyu tɛ mbebe le, bo mo bo leesɛ Jiso yo. ");
INSERT INTO ncr_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Gɛ̀ bee juu chi fwe yi kimaa le, Mɛɛle Madaleŋ bu wu ja lo kibilebile, wu gɛɛŋ fɛ jɛŋ, wu yɛŋ ba chiaasɛ wa tɛdɛ chì ba gɛ̀ baŋɛ jwe wu jɛŋ yu. ");
INSERT INTO ncr_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Noo, wu mo wu legɛ wu gɛɛŋ wu yɛŋ Samoŋ Bita le bɛ mwa ŋgoo wu Jiso wumu wɛɛ wu Jiso gɛ̀ koŋe wu, wu jɛmɛ bo le lɛ, “Ba le ba bvusɛ wa Tada a jɛŋ, bee kee gɛ laa ba gɛle wu faaŋ lɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Bita bɛ mwa ŋgoo wu Jiso wɛɛ mo bo bu bo gɛɛne fɛ jɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bo gɛ̀ gɛɛne bo lege lo, geenɛ mwa ŋgoo wu Jiso wɛɛ legɛ wu fe Bita wu ya wu fɛsɛ fɛ jɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","No wu fɛse, wu gvuusɛ wu bijɛ, wu yɛŋ njú yi ba gɛ̀ giŋsɛ Jiso yu yi gime yo. Wu bijɛ noo wu gɛ lee yo gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Samoŋ Bita bi wu le wu fɛsɛ fo, wu mo wu lee lo wu gɛɛŋ a jɛŋ. No wu lese, wu yɛŋ nyu gɛh njú chiɛɛ le yi gime, ");
INSERT INTO ncr_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","mo finchaŋa fi nju fiɛɛ fì ba gɛ̀ dimɛ kikwɛɛ ki Jiso yu fi gime gɛ bɛ njú yimi chiɛɛ gɛ. Geenɛ ba gɛ̀ kɛbe lɛfilɛfi ba gɛɛ ke kijusɛ le. ");
INSERT INTO ncr_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Mwa ŋgoo wu Jiso wumu wɛɛ wù gɛ̀ yaŋsɛ wu fɛsɛ fɛ jɛŋ mo wu lee tɛ wu gɛɛŋ a jɛŋ wu yɛŋ fiɛɛ finɛ le wu mo wu bɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Gɛ̀ bee ba baaŋ a kɛɛ gɛ kinyi ki fiɛɛ fì le a Ŋwa wu Nyo le lɛ Jiso gɛ̀ kɛme ki wu gê wu bu yi kwe le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Booŋ ba ŋgoo ba Jiso baa kaasɛ bo kwɛɛ fɛ yeh le. ");
INSERT INTO ncr_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Geenɛ Mɛɛle shɛɛ wu tu wu lɛme wu beede fɛ jɛŋ. No wu gɛ̀ beede wu ja wu gvuusɛ wu bijɛ a jɛŋ, ");
INSERT INTO ncr_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","wu yɛŋ banchɛndaa ba Nyo le bafɛɛ bo noŋ njú yì baaŋ bo shii fɛ ba gɛ̀ giŋsɛ gvunɛ chi Jiso fo, wumu fɛ kikwɛɛ ki Jiso gɛ̀ gime fo, wumu fɛ bikaa bie gɛ̀ gime fo. ");
INSERT INTO ncr_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Banchɛndaa ba Nyo baa biih wu le lɛ, “Kwɛse, wo beede la?” Wu chvuu lɛ, “Mbeede nje ba le ba chiaasɛ Tada waŋ ba ja bɛ wu gɛ n'ya kee fɛ ba gɛle wu fo gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","No wu jɛmɛ noo, wu doo wu kaasɛ ye wu yɛŋ Jiso lɛme. Geenɛ wu gɛ̀ baaŋ kɛɛ gɛ lɛ le Jiso gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jiso biih wu le lɛ, “Kwɛse, wo beede la? Wo goone nyu yɛɛŋ?” Mɛɛle mo wu kwaji lɛ le muh wu jiiŋe fɛ mwɛ wu kitaŋ kwɛɛ le. Wu mo wu jɛmɛ wu le lɛ, “Chii, wo nɛ le wo tuu wu wo ja bɛ wu, wo sɛɛŋ mɛ fɛ wo gɛle wu fo ŋgɛɛŋ njo nja bɛ wu.” ");
INSERT INTO ncr_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jiso ja wu bɛɛŋ wu lɛ, “Mɛɛle.” Wu kaasɛ ye wu tɛɛŋ wu a jɛ́ yi Ibulu le lɛ, “Laboni”, fì le lɛ, “Muh wu N'yɛyɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jiso jɛmɛ wu le lɛ, “Keefɛ wo jîji mɛne gɛ, nje mbaaŋ a bɛɛŋ gɛ fɛ Chii le gɛ. Gɛ̂nɛ nyu fɛ booŋ ba bwɛɛŋ le wo sɛ̂ɛŋ bo le lɛ mbɛɛne wa fɛ Chii wu le tɛ Chiji wene, mo fɛ Nyo waŋ wu le tɛ Nyo wene.” ");
INSERT INTO ncr_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mɛɛle Madaleŋ mo wu gɛɛŋ wu sɛɛŋ booŋ ba Jiso ba ŋgoo le lɛ wu le wu yɛŋ Tada le, wu ka wu sɛɛŋ bo le lɛ wu le wu jɛmɛ mwɛɛ munɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Gɛ̀ bee fɛnfu abvubwɛɛ nyume juu chi fwe yi kimaa le, booŋ ba ŋgoo ba Jiso nyume yeh bo faa bimbuŋ, nje bo gɛ̀ faane Bajuu. Jiso ja gɛh wu bunɛ wu lɛɛŋ a bo ntɛnɛɛ, wu yɛsɛ bo le lɛ, “Kimbonɛ nyûme fɛ bɛŋ le.” ");
INSERT INTO ncr_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","No wu jɛme bo le noo, wu mo wu dunyɛ chiaaŋ ye bɛ chita che bo le. Booŋ ba Jiso ba ŋgoo yu njoŋ baaŋ no bo yɛŋ Tada le. ");
INSERT INTO ncr_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jiso ka wu kaasɛ wu jɛmɛ bo le lɛ, “Kimbonɛ nyûme fɛ bɛŋ le. No Chii gɛ tuŋ mɛ, le gɛh yɛɛŋyɛɛŋ no nlé ntûne bɛŋ mɛ̂ɛse.” ");
INSERT INTO ncr_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","No wu jɛmɛ noo, wu mo wu yɛnɛ bo le wu jɛmɛ lɛ, “Bɛŋ fi Kiyo ki Yuude. ");
INSERT INTO ncr_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Bɛŋ nɛ lɛɛshɛ bimbefɛ bi muh, tu Nyo le wu lɛɛshɛ wa. Bɛŋ faŋ ki bɛŋ lɛ̂ɛshɛ, tu bi lé bi mɛ̂ gɛh noo.” ");
INSERT INTO ncr_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Sege Jiso gɛ̀ to fɛ booŋ be ba ŋgoo le, Toma wù gɛ̀ bee ŋgoo yi booŋ ba yuufe ncho bafɛɛ le wu ba gɛ̀ tɛŋe jee che chimi lɛ Amaŋ, wù gɛ̀ bee gɛ bɛ bo gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kimbɛge ki booŋ ba ŋgoo ba Jiso gɛ̀ jɛmɛ wu le lɛ, “Bee le be yɛŋ Tada le.” Geenɛ, wu jɛmɛ fie bo le lɛ, “Mɛ nɛ nlé njɛ n'yɛŋ de yi bíɛɛŋ chiɛɛ chiaaŋ ye le sɛŋ, nleesɛ kwaaŋ jwe wu bíɛɛŋ yiyu le sɛŋ, nleesɛ tɛ kibo kaŋ yi chita che le sɛŋ, ŋgɛ mbɛɛŋ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kimaa kuŋ, booŋ ba Jiso ba ŋgoo ka bo nyu yeh, Toma nyu tɛ bɛ bo, ba nyu ba faa de yi fese yi yeh. Geenɛ, Jiso ja wu bunɛ a bo ntɛnɛɛ, wu jɛmɛ bo le lɛ, “Kimbonɛ nyûme fɛ bɛŋ le.” ");
INSERT INTO ncr_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","No wu jɛmɛ noo, wu mo wu jɛmɛ Toma le lɛ, “Lêesɛ kwaaŋ wo yi chiaaŋ yaŋ le, wo yɛ̂ŋ no yi le, wo ka wo lêesɛ tɛ kibo kuŋ yi chita chaŋ le. Keefɛ wo mâŋe gɛ, bɛ̂ɛŋ!” ");
INSERT INTO ncr_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma chvuu wu le lɛ, “Tada waŋ, mo Nyo waŋ!” ");
INSERT INTO ncr_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jiso jɛmɛ wu le lɛ, “Wo le wo bɛɛŋ mɛɛse nje wo le wo yɛŋ mɛne? Kinlaŋye kì baaŋ le fɛ bamii ba baaŋ yɛŋ gɛ mɛne gɛ, geenɛ, bo bɛɛŋ.” ");
INSERT INTO ncr_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jiso gɛ̀ bee wu ge mwɛɛ wesee mù duunyi bvuŋga bvu Nyo, booŋ be ba ŋgoo yɛŋ, ba baaŋ a saŋ gɛ a ŋwa wunɛ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Geenɛ, munɛ mù ba le ba saŋ, lé ki fi gê lɛ bɛŋ bɛɛŋ lɛ Jiso le Mbvusɛ wù Nyo gɛ̀ ka, lɛ le Mwa Nyo. Nɛ bɛŋ bɛmɛ noo, bɛŋ ge bɛŋ kɛmɛ kinche kì kage gɛ nje jee che. ");
INSERT INTO ncr_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ajiŋ ayu Jiso ka wu dunyɛ kikwɛɛ ke booŋ be ba ŋgoo le mbebe Mamasi wù Tibɛlia le. Fi gɛ̀ kooshi a yinɛ je le: ");
INSERT INTO ncr_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Samoŋ Bita bɛ Toma wù ba gɛ̀ tɛŋe lɛ Amaŋ, mo Natanya wu Kana kimbe kì Galalee le, mo booŋ ba Jɛbɛdi lɛ, mo booŋ ba ŋgoo ba Jiso bamu bafɛɛ gɛ̀ bee kijusɛ kimimia. ");
INSERT INTO ncr_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Samoŋ Bita ja wu jɛmɛ bo le lɛ, “Nlade bíɛŋ.” Bo jɛmɛ wu le lɛ, “Besabɛŋ le be la.” Bɛ bo mo bo bu bo gɛɛŋ bo lee a ŋguh le. Geenɛ, bo jiɛnyɛ bo che a joo bo gɛ koo fiɛɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Lɛ akfuuŋ kɛ a yuude a too, Jiso to wu lɛɛŋ ŋgɛɛmɛ yi joo le, booŋ be ba ŋgoo gɛ̀ baaŋ kɛɛ gɛ lɛ le wu gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jiso biih bo le lɛ, “Booŋ baŋ, bɛŋ le bɛŋ koo gɛh bíɛŋ?” Bo chvuu wu le lɛ, “Aay.” ");
INSERT INTO ncr_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Wu jɛmɛ bo le lɛ, “Bɛŋ noŋ gwii je kibo kinchiɛɛŋ ki ŋguh le bɛŋ lé bɛŋ kôo fiɛɛ.” Bo mo bo noŋ, wu tu wu yage bo ki bo chii, nje bo gɛ̀ koo bíɛŋ yo wesee. ");
INSERT INTO ncr_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mwa ŋgoo wu Jiso wɛɛ wù Jiso gɛ̀ koŋe doo wu yɛŋ noo, wu mo wu jɛmɛ Bita le lɛ, “Le Tada.” No Samoŋ Bita yu lɛ le Tada, wu mo wu jii njú ye ye le, nje wu gɛ̀ bee ye yi yɛse. No wu jile njú ye noo wu mo wu selɛ a joo wu tu wu gɛɛne fɛ Jiso le. ");
INSERT INTO ncr_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Geenɛ, booŋ ba ŋgoo bamu baa tu bo bii a ŋguh le bo chiide gwii kwɛɛ wù nyu wu yisɛ bɛ bíɛŋ. Gɛ bo gɛ̀ baaŋ je yì ndefe le fɛ bo bu kwa gɛ. Bantaŋ gɛ̀ shɛɛ wa njɛ ŋkɛŋɛ mbaanshɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Bo gɛɛŋ bo fɛsɛ kwa bo yɛŋ ŋgu le wu keede lo yi bika le, bíɛŋ nyu yu, blɛd nyu tɛ fo. ");
INSERT INTO ncr_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jiso jɛmɛ bo le lɛ, “Bɛŋ to bɛ bíɛŋ yimi yì bɛŋ kole.” ");
INSERT INTO ncr_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Noo Samoŋ Bita gɛɛŋ wu bɛɛŋ a ŋguh le wu chii gwii wu bu kwa wù nyu wu yisɛ bɛ bíɛŋ yì kuge yi gɛ̀ bee gwii kicho mbaanshɛŋ ncho yishɛde (153). No yi gɛ̀ bee wesee nɛ, gwii gɛ̀ baaŋ saayɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jiso jɛmɛ bo le lɛ, “Bɛŋ tô bɛŋ ji mwɛɛ.” Muh wu mumwaa booŋ be ba ŋgoo le gɛ̀ baaŋ moŋ gɛ wu biih wu le laa le wu wù yɛɛŋ lɛ. Bo gɛ̀ kee lo lɛ le Tada. ");
INSERT INTO ncr_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jiso mo wu gɛɛŋ wu jo blɛd wɛɛ wu nya bo le mo bíɛŋ chiɛɛ fo. ");
INSERT INTO ncr_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Finɛ gɛ̀ bee wa kiŋgane kintɛde no Jiso gɛ̀ dunyɛ kikwɛɛ ke booŋ be ba ŋgoo le kɛge no wu gɛ̀ bu yi kwe le. ");
INSERT INTO ncr_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Bo gɛ̀ ji mwɛɛ bo mɛsɛ, Jiso bɛɛŋ Bita wu biih wu le lɛ, “Samoŋ mwa Joŋ, wo koŋe mɛ wo fede bamu banɛ?” Wu chvuu lɛ, “Ɛɛŋ Tada, wo kee lo lɛ ŋkoŋe wo.” Jiso jɛmɛ wu le lɛ, “Wo, nyâŋe booŋ ba shóŋ yaŋ.” ");
INSERT INTO ncr_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jiso ka wu bɛɛŋ wu ki kiŋgane kinfɛɛ wu biih wu le lɛ, “Samoŋ mwa Joŋ, wo koŋe mɛ?” Wu chvuu lɛ, “Ɛɛŋ Tada, wo kee lo lɛ ŋkoŋe wo.” Wu jɛmɛ wu le lɛ, “Wo jîiŋe, fɛ shóŋ yaŋ le.” ");
INSERT INTO ncr_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jiso ka wu bɛɛŋ wu ki kiŋgane kintɛde wu biih wu le lɛ, “Samoŋ mwa Joŋ, wo koŋe mɛ?” Bita yu no Jiso biide wu le kiŋgane kintɛde laa wu koŋe wu la, fi fuuŋsɛ lo wu. Wu jɛmɛ Jiso le lɛ, “Tada, wo kee mwɛɛ munchii, wo kee lo lɛ ŋkoŋe wo.” Jiso jɛmɛ wu le lɛ, “Wo, nyâŋe shóŋ yaŋ. ");
INSERT INTO ncr_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nsɛŋe wo nchiɛɛŋ nchiɛɛŋ lɛ, sege wo gɛ̀ baaŋ chumu, le wo wù gɛ̀ jiide njú yo wo gɛɛne fɛ wo koŋe fo. Geenɛ, sege wo juŋ wa wo le wo chîaasɛ lo chiaaŋ we muh mu jii njú ye yo le, wu jô wo wu gɛ̂ɛŋ bɛ wo fɛ wo koŋe gɛ ki wo gɛ̂ɛŋ fo gɛ.” ");
INSERT INTO ncr_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jiso gɛ̀ jɛme finɛ wu duunyi nyu kfuu chi kwe yi Bita gɛ̀ bee ki wu gê wu kwe, yi to bɛ jee chì kuge fɛ Nyo le. No Jiso jɛmɛ noo, wu mo wu jɛmɛ wu le lɛ, “Wo bîi mɛne.” ");
INSERT INTO ncr_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Bita doo wu kaasɛ ye wu yɛŋ mwa ŋgoo wɛɛ wù Jiso gɛ̀ koŋe le wu bii wu le. Mwa ŋgoo wunɛ le wu, wù gɛ̀ yɛmɛ wu gɛɛŋ yi Jiso le sege bɛ bo gɛ̀ jii mwɛɛ fɛnfu yi kimɛsɛ le, wu biih wu le lɛ, “Tada, le yɛɛŋ wù lé wu gê wu gêsɛ wo?” ");
INSERT INTO ncr_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","No Bita yɛŋ no mwa ŋgoo wɛɛ bii bo le, wu biih Jiso le lɛ, “Tada, fi muh wunɛ le lɛ la?” ");
INSERT INTO ncr_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jiso chvuu wu le lɛ, “Nɛ fi le lɛ mbe ŋkoŋe lɛ wu mɛ gɛh wù nyu fɛnɛ gɛɛne bude no nlé ŋgê ŋkâasɛ nto, fifiɛɛ kɛ̂me la ki fi gê bɛ wo? Wo bîi mɛne.” ");
INSERT INTO ncr_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","No Jiso jɛmɛ noo, njɛmɛ mo wu gɛɛŋ antɛnɛɛ a bamii ba mbɛmɛ le lɛ, gɛ mwa ŋgoo wu Jiso wunɛ nyu wu ge wu kwe gɛ. Geenɛ, Jiso gɛ̀ baaŋ du gɛ lɛ gɛ wu nyu wu ge wu kwe gɛ. Wu gɛ̀ jɛmɛ gɛh lɛ, “Nɛ fi le lɛ mbe ŋgoone lɛ wu mɛ gɛh wu nyume gɛɛne bude no nlé ŋgê ŋkâasɛ ntô, fifiɛɛ kɛme la ki fi gê bɛ wo.” ");
INSERT INTO ncr_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Mwa ŋgoo wuyu wunɛ wù jɛme kune mwɛɛ munɛ, le wu wù saŋ mwɛɛ munɛ, bee kee lo lɛ fiɛɛ fì wu jɛme kune fi le nchiɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Mwɛɛ mumu le tɛ yu wesee mù Jiso gɛ̀ ge, bee lɛ ba saŋ munchii, n'yɛnɛ lɛ gɛ kikwɛɛ ki nshɛŋ kichii taŋlo ki kɛmɛ fɛ ba gɛɛ baŋwa baa fo gɛ.");
INSERT INTO ncr_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Chɛla Teofilus, a ŋwa wù fwe wu ŋgɛ̀ nsaŋ fɛ wo le, ŋgɛ̀ nsaŋ kune mwɛɛ munchii mù Jiso gɛ̀ gee mo mù wu gɛ̀ yɛyi bamii yu, kɛge no wu gɛ̀ kɛ lɛme che, ");
INSERT INTO ncr_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","gɛɛŋ bu juu chì Nyo gɛ̀ jo wu wu bɛɛŋ we. Fɛ Nyo jo wu wu bɛɛŋ we, wu gɛ̀ bee wu fe yi bvuŋga bvu Kiyo ki Yuude le ki wu têefe booŋ be ba ntuŋ ba wu gɛ̀ cha. ");
INSERT INTO ncr_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Sege wu gɛ̀ bu yi kwe le, wu gɛ̀ bee wu dunyɛ ye ye bo le yi aju le mbaanyɛ jé yì duude le yì duunyi lɛ wu le yu. Wu ka wu jɛmɛ bo le kune bvunfoŋ bvu Nyo. ");
INSERT INTO ncr_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","No bɛ bo gɛ̀ bee noo, wu jɛmɛ, bo le lɛ, “Keefɛ bɛŋ jâ Yɛlusalɛm gɛ. Bɛŋ chîɛɛne nnya yì Chii gɛ̀ ka bɛŋ yu yì bɛŋ gɛ̀ yu wa njɛme kune yi. ");
INSERT INTO ncr_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Bɛŋ kêe lɛ Joŋ gɛ̀ leese bamii a joo, geenɛ ajiŋ aju shige Nyo lé wu gê wu lêesɛ bɛŋ nyu yi Kiyo ki Yuude le.” ");
INSERT INTO ncr_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jiso bɛ booŋ be ba ntuŋ gɛ̀ bee kife kimi le, bo biih wu le lɛ, “Tada, kife le ki kojɛ ka kì wo lé wo gê bamii besa ba Ishwala kaasɛ bo sâge bvunfoŋ bvuboo lɛ?” ");
INSERT INTO ncr_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Wu chvuu bo le lɛ, “Kife kɛnɛ juu chì fi lé fi kôoshɛ noo le nyu seesɛ Chii bɛ bvuŋga bwe, gɛ nyu kijusɛ kena ki bɛŋ kɛ̂ɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Fi bɛŋ kɛme ki bɛŋ kêe le lɛ Kiyo ki Yuude lé ki tô ki yisɛ yi ye yene le, bɛŋ mo bɛŋ kɛmɛ bvuŋga, bɛŋ kɛ bɛŋ sɛ̂ŋe kune mɛ Yɛlusalɛm mo bimbe bi Judia bɛ Samaliya le bichii, gɛɛŋ bu abu a woŋ le ana.” ");
INSERT INTO ncr_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Gɛh no wu gɛ̀ baaŋ wu jɛme noo, Nyo jo wu wu tu wu bɛɛne we bo jiiŋe no wu bɛɛne, wu bɛɛŋ kimbɛ baŋe wu, wu lɛsɛ a bo jii. ");
INSERT INTO ncr_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","No bo gɛ̀ nooŋ aji kibvulɛ le bo jiiŋe no wu bɛɛne, fi kooshɛ lɛ bilɛŋsɛ bafɛɛ gɛ̀ ja bo bu gɛh nɛ fɛ bo le bo noŋ njú yì baaŋ ye le, bo lɛɛŋ mbebe yiboo le, ");
INSERT INTO ncr_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","bo biih bo le lɛ, “Bilɛŋsɛ ba Galalee, bɛŋ lɛme bɛŋ jiiŋe la kibvulɛ le? Jiso wunɛ wù Nyo jo a bɛŋ ntɛnɛɛ wu bɛɛne we wu lé wu gê wu kâasɛ wu tô gɛh yɛɛŋyɛɛŋ no bɛŋ yɛŋ wu bɛɛne we nɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Booŋ ba ntuŋ ba Jiso, mo bo ja fɛ Mbegɛ wù ba tɛŋe lɛ wu Bite bi Olif le, bo ja bo tuu jiŋ Yɛlusalɛm, gɛ̀ bee njɛ kiŋgadɛ ki ma ki ba gɛɛŋ ba bu yo. ");
INSERT INTO ncr_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","No bo lese yo, bo mo bo bɛɛŋ bo gɛɛŋ a kibuu ki yeh yi awe le fɛ bo gɛ̀ gɛɛne bo bɛɛde fo. Bamii banɛ gɛ̀ bee Bita, Joŋ, Jɛm mo Andulu, Filib bɛ Toma, Batolomiu bɛ Macho, Jɛm wù mwa Alfayu, Samoŋ wù gɛ̀ bee muh ŋgoo yi Salot, mo Juda wù mwa Jɛm. ");
INSERT INTO ncr_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bɛ bikɛse bamu mo Mɛɛle wù bwe Jiso bɛ booŋ ba bwe Jiso to bo taashi yi fiɛɛ le fimimia ki bo buune segechii. ");
INSERT INTO ncr_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Gɛ̀ bee aju ayu le, booŋ ba ŋgoo ba Jiso taashɛ. Bo to fo njɛ muh gwii kicho mbaanfiɛɛ (120). Bita ja we wu jɛmɛ bo le lɛ, ");
INSERT INTO ncr_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Booŋ ba bwɛɛŋ, fiɛɛ fì Ŋwa wu Nyo jɛme gɛ̀ kɛme ki fi kôoshɛ. Gɛ̀ bee fiɛɛ fì Kiyo ki Yuude gɛ̀ ge Dabi jɛmɛ baaŋ lo kune Juda wu gɛ̀ lɛme fwe fɛ ba koo Jiso. ");
INSERT INTO ncr_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Bɛŋ kee lɛ Juda wunɛ gɛ̀ bee muh mu ŋgoo yese le, wù kɛme che lɛme a bee ntɛnɛɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Fɛ Bita jɛme noo, Juda gɛ̀ bee wu jo wa bige bì ba gɛ̀ nya wu le yi fiɛɛ fì wu gɛ̀ moŋ le, wu gu kijusɛ yu. Kijusɛ kinɛ le fɛ wu gɛ̀ gwe fo bɛ kikwɛɛ tee badɛ antɛnɛɛ, bvulɛ bu akfuuŋ bvuchii. ");
INSERT INTO ncr_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Bamii ba Yɛlusalɛm bachii yu, bo mo bo tɛŋe kijusɛ kiyu a jɛ yiboo le lɛ Akeldama, fì le lɛ, “Gwɛŋ wu Kilɛmɛ.”) ");
INSERT INTO ncr_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Bita ka wu jɛmɛ lɛ, “Dabi gɛ̀ saŋ a Ŋwa wu N'yuusɛ le lɛ, ‘Ba chînɛ la che tû binfu, muh gɛ ka wu chêe fo gɛ.’ Fi ka nyu wu saŋ lɛ, ‘Muh mu kɛme ki wu jô kijusɛ ke ki lɛme lɛ.’ ");
INSERT INTO ncr_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","No fi le noo, muh mu kɛme ki wu tâa fɛ bee le, besa bo feeji lɛ Tada Jiso gɛ̀ bu yi kwe le. Kfuu chi wuwɛɛ muh kɛme ki wu nyûme muh wu gɛ̀ jiɛnyi besa bo segechii no Jiso gɛ̀ jiɛnyi besa bo kɛge yi kife ki Joŋ gɛ̀ leese bamii a joo le, gɛɛŋ bu juu chi Nyo gɛ̀ jo Jiso a bee ntɛnɛɛ wu bɛɛŋ we.” ");
INSERT INTO ncr_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","No wu jɛme noo, ba baa bamii bafɛɛ, muh mu gɛ̀ bee Yosɛf wù ba gɛ̀ tɛŋe lɛ Basaba ba ka tɛŋe lɛ Justu, wumu nyu Matia. ");
INSERT INTO ncr_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","No bo bale noo, bo mo bo buunɛ lɛ, “Tada, wo kee muntele mu bamii bachii. Noo, dunyɛ bee muh wù wo le wo cha antɛnɛɛ a bamii bafɛɛ banɛ, ");
INSERT INTO ncr_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","lɛ wu nyû mwa ntuŋ wu Jiso wù jo kijusɛ ki Juda ki lɛme lɛ, kì wu gɛ̀ ja wu chinɛ wu gɛɛŋ fɛ ke kijusɛ le.” ");
INSERT INTO ncr_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","No bo buunɛ noo, bo mo bo saŋ ajee aboo, bo shiŋshɛ, chi Matia bu chi gwe. Bo mo bo taa wu fɛ ŋgoo yi booŋ ba ntuŋ ba Jiso le ba yuufe ncho wu mumwaa le. ");
INSERT INTO ncr_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Juu chi Ŋka wumu wù ba gɛ̀ tɛŋe lɛ Bɛntɛko gɛ̀ to chi kojɛ, bamii bachii ba gɛ̀ leesɛ fitele yi Jiso le, bo taashɛ kijusɛ kimimia. ");
INSERT INTO ncr_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Bo gɛ̀ ja bo jaŋe bo yu no fiɛɛ fuune fi shiide we njɛ mwacha. Fi shii fi lee fi yisɛ yeh yichii yì bo gɛ̀ bee yu. ");
INSERT INTO ncr_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Bo doo bo bijɛ, bo yɛŋ fiɛɛ fimi fi nyu njɛ chilɛme chiŋgu, fi mo fi saaŋe fi gɛɛŋ yi bo le muh wu mumwaa wu mumwaa. ");
INSERT INTO ncr_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kiyo ki Yuude mo ki yisɛ yi bo le bachii, ki ge bo tu bo jɛme jɛ́ yi bituŋ yeye yeye. ");
INSERT INTO ncr_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Gɛ̀ bee kife kɛɛ le, Bajuu ba gɛ̀ leesɛ muntele yi Nyo le gɛ̀ bee Yɛlusalɛm, bo ja bituŋ le bichii bi yi kikwɛɛ ki nshɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","No bo yu noo, bo mo bo taashɛ bo to wesee fɛ bamii ba gɛ̀ leesɛ muntele yi Jiso le. Bamii ba gɛ̀ leesɛ muntele yi Jiso le bayu mo bo jɛme, muh wu mumwaa wu mumwaa bo le yuge a jɛ́ yiboo le. Fi fuuŋsɛ bo. ");
INSERT INTO ncr_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Jwe yuŋ bo, bo tu bo ghaade, bo duu lɛ, “Gɛ bamii ba jɛme banɛ bachii nyu bamii ba Galalee gɛ? ");
INSERT INTO ncr_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Fi jiɛnyi nɛɛ fɛ bee yuge muh wu mumwaa wu mumwaa bo le jɛme a jɛ́ yi bituŋ biɛsa le? ");
INSERT INTO ncr_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Bee bamu ja Batia, bamu ja Mɛde bɛ Ɛlaŋ, bamu ja Misobotɛmia bɛ Judia mo Kafadosia, bamu ja Bontu bɛ Ɛsia. ");
INSERT INTO ncr_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Bee bamu ja Fligia bɛ Banfilia, bamu Ijib bɛ bimbe bi Libia le, bì le mbebe a kilaantɛŋ kì Sɛliŋ le. Bee bamu ja Lum, nyu Bajuu bɛ bamii bo kaase lo bo tu bamii ba mbɛmɛ wu Bajuu le. ");
INSERT INTO ncr_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Bee bamu ja Klɛt bɛ Alɛbia. Bee tu yuge a jɛ́ yi bituŋ biɛsa le yeye yeye no bamii banɛ jɛme biŋgha bi mwɛɛ bì Nyo gee.” ");
INSERT INTO ncr_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Jwe yuŋ bo, bo tu bo maŋe lɛbolɛbo laa finɛ fiɛɛ duunyi lɛ la lɛ. ");
INSERT INTO ncr_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Bamii bamu tu bo keede lo fiboo bo duu lɛ, “Bamii banɛ le mbvuuŋ koo wa bo.” ");
INSERT INTO ncr_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Noo, Bita bɛ kimbɛge ki booŋ ba ntuŋ ba Jiso ba yuufe ncho wu mumwaa mo bo lɛɛŋ fo. Bita mo wu kɛ wu tu wu jɛme kinchvu ki bamii le fɛwɛɛwe lɛ, “Bɛŋ Bajuu mo bamii bachii ba chee Yɛlusalɛm, ŋgoone lɛ bɛŋ kɛ̂ɛ finɛ. Bɛŋ nyâ bintuŋ chuule yi fiɛɛ fì nlé njɛmɛ bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mbvuuŋ baaŋ koo gɛ bamii banɛ no bɛŋ kwaji gɛ. Mɛɛse baaŋ gɛh lo juu bikaa bvuugɛ antaana. ");
INSERT INTO ncr_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Fiɛɛ fì kooshi finɛ mɛɛse le fì Juɛl wù muh wu ntuŋ wu Nyo gɛ̀ jɛmɛ wa lɛ, ");
INSERT INTO ncr_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Nyo duu lɛ, lé doo nyûme yi aju a kimɛsɛ le, wu chvû Kiyo ke yi bamii le bachii. Noo booŋ bena ba bilɛŋsɛ mo ba bikɛse, bo yûge mwɛɛ mù wu jɛme, bo sɛŋe bamii le, mwɛɛ njɛ bifilɛ too fɛ chuu yi bamii bena le, bifilɛ laane ŋgaamii bena. ");
INSERT INTO ncr_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Lé ge doo nyûme aju ayu le, wu chvû Kiyo ke yi bamii ba lɛme be le bachii, bilɛŋsɛ bɛ bikɛse, bo yûge mwɛɛ mù wu jɛme, bo sɛŋe bamii le. ");
INSERT INTO ncr_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Fi le lɛ wu gee mwɛɛ mu jwe wu yune le fɛwe, wu ka wu gee mwɛɛ mù duunyi bvuŋga bwe yi nshɛŋ le. Kilɛmɛ bɛ ŋgu mo chinjige chì kuufe ye le chi nyûme. ");
INSERT INTO ncr_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Juu lé chi gê chi jîmɛ, kwii jâ wu yɛ̂ɛde njɛ kilɛmɛ, fɛ juu chi baaŋ chi Tada chi kiŋgha ge chi to. ");
INSERT INTO ncr_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Noo, le yɛɛŋ wù lé wu gê wu lɛ̂ge Tada, wu lé wu gê wu bvûsɛ wu.’” ");
INSERT INTO ncr_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Bita ka wu jɛmɛ lɛ, “Bamii ba Ishwala, bɛŋ yêgɛ bɛŋ yû chuule fiɛɛ fì njɛme. Jiso wu Nasalɛ gɛ̀ bee muh wù Nyo gɛ̀ dunyɛ bɛŋ le chuule lɛ le wu wù tuŋ wu no wu gɛ̀ ge Jiso gee mwɛɛ mù duunyi bvuŋga bvu Nyo, bɛ mwɛɛ mu de yì yunɛ, bɛ biŋgha bi mwɛɛ a bɛŋ ntɛnɛɛ. Bɛŋ kee mwɛɛ munɛ chuule. ");
INSERT INTO ncr_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jiso wunɛ le muh wù ba gɛ̀ nya bɛŋ le, gɛ̀ seese Nyo fi ge fi kooshi wu gɛ̀ kee wa. Bɛŋ mo bɛŋ yuuyɛ wu no bɛŋ gɛ̀ nya wu chiaaŋ yi bamii ba befe le, ba ta wu yi kintaaŋ le. ");
INSERT INTO ncr_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Geenɛ, Nyo kaasɛ wu bvusɛ wu yi kwe le, wu bonɛ chiaaŋ yi kwe le nje gɛ kwe gɛ̀ taŋlo yi mɛ yi jiji wu le gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dabi gɛ̀ bee wu jɛmɛ wa kune Jiso wunɛ wu duu lɛ, ‘N'yɛde Tada le wu nyu besa wu segechiikibo kaŋ kinchiɛɛŋ le, gɛ taŋlo fiɛɛ shîŋshɛ mɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Noo, fitele fiaŋ mo fi yuge njoŋ, njɛme bɛ kinlaŋye. Nle muh nyu ŋge ŋkwe gɛh lo, geenɛ njiiŋe gɛh nyu fwe, ");
INSERT INTO ncr_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","nje gɛ wo wù Nyo nyu wo ge wo chinɛ kiyo kaŋ woŋ wu baŋkfu le gɛ. Gɛ wo nyu wo ge wo chinɛ Mwa yo wu lɛme wù Yuude wu fo a jɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Wo le wo dunyɛ wa mɛ je yì taŋlo nfê yu fɛ mbonɛ. Nlé ŋgê nlaŋeye, no nlé ŋgê nyume a wo fwe.’” ");
INSERT INTO ncr_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Bita ka wu jɛmɛ lɛ, “Booŋ ba bwɛɛŋ, taŋlo njɛme bɛŋ le n'ya maŋe gɛ lɛ chiji chiji wese wu Nfoŋ Dabi gɛ̀ kwe, ba jiiyɛ wu, jɛŋ ye le fɛnɛ too bude abɛŋ. ");
INSERT INTO ncr_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Wu gɛ̀ bee muh wu ntuŋ wu Nyo, wu ka kee ŋka wù Nyo gɛ̀ ka wa wu yu, wu ji leh lɛ wu lé wu gê wu gɛɛ mwa wu a kfuu che le yi kala we le. ");
INSERT INTO ncr_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Wu mo wu yaŋsɛ wu yɛŋ fiɛɛ fì Nyo gɛ̀ bee ki wu gê le, wu jɛmɛ lɛ Mbvusɛ wù Nyo gɛ̀ ka lé wu gê wu bû yi kwe le. Le fiɛɛ fì wu gɛ̀ jɛmɛ lɛ, ‘Wu gɛ̀ baaŋ mɛ gɛh woŋ wu baŋkfu le gɛ, ye ye gɛ̀ baaŋ fo gɛ a jɛŋ gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jiso wunɛ Nyo gɛ̀ bvusɛ wu yi kwe le, bee bachii be le bamii be ba ŋgoo bee gɛ yɛŋ wu le. ");
INSERT INTO ncr_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nyo le wu bɛɛŋsɛ wa wu, wu shiishɛ wu a kibo ke kinchiɛɛŋ le, wu nya wu Kiyo ki Yuude no wu gɛ̀ ka. Fiɛɛ fì bɛŋ yɛde bɛŋ ka yuge mɛɛse le Kiyo kiyu kì Jiso nya bee le. ");
INSERT INTO ncr_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Gɛ nyu Dabi wù gɛ̀ bɛnɛ we gɛ. Dabi kibɛɛ gɛ̀ jɛmɛ fie lɛ, ‘Tada Nyo gɛ̀ jɛmɛ Tada waŋ le lɛ, “shilɛ a kibo kaŋ kinchiɛɛŋ le, ");
INSERT INTO ncr_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","gɛɛŋ bu sege nlé ŋgê ŋgîiŋsɛ bamii buŋ ba kimbanɛ, wo tomɛ bikaa biuŋ yi bo le njɛ kitege ki bikaa.”’ ");
INSERT INTO ncr_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Noo, bamii bachii ba Ishwala mo bo kêe chuule lɛ Jiso wunɛ wù bɛŋ gɛ̀ ta yi kintaaŋ le, le wu wù Nyo le wu gɛɛ wa lɛ le Tada ka nyu Mbvusɛ wù wu gɛ̀ ka.” ");
INSERT INTO ncr_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","No bamii bayu yu noo, njɛme wɛɛ koo bo. Bo mo bo biih Bita bɛ kimbɛge ki booŋ ba ntuŋ ba Jiso le lɛ, “Booŋ ba bwɛɛŋ, bee lé be gê nɛɛ mɛɛse?” ");
INSERT INTO ncr_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Bita chvuu bo le lɛ, “Muh wu mumwaa wu mumwaa kûsɛ fitele fie, ba lêesɛ wu a joo a jee chi Jiso Kletu le lɛ Nyo lɛ̂ɛshɛ bimbefɛ bie wu ka wu nyâ wu bɛ nnya yi Kiyo ki Yuude. ");
INSERT INTO ncr_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ŋka wuyu wunɛ le fɛ bɛŋ le, bɛ fɛ booŋ bena le, ka nyume fɛ bamii bachii ba le yaga le. Fi le lɛ wu fɛ bamii bachii ba Tada Nyo wese tɛŋe lɛ bo too fɛ wu le.” ");
INSERT INTO ncr_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Bita ka wu jɛme mwɛɛ wesee, wu teefe bo, wu chiisɛ lɛ bo fîh bikwɛɛ biboo yi ŋgɛ wù lé wu gê wu tô yi kiŋgogɛ kì befe kinɛ le. ");
INSERT INTO ncr_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Bamii yu njɛmɛ wu Bita wunɛ, ba duude bɛɛŋ, ba mo ba leesɛ bo a joo. Juu chiyu bamii taa fɛ ŋgoo yi bamii ba Jiso le njɛ banchvuge batɛde (3,000). ");
INSERT INTO ncr_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bo mo bo nya bikwɛɛ biboo, bo yuge mwɛɛ nyu mù booŋ ba ntuŋ ba Jiso gɛ yɛyi. Bɛ bo mo bo nyu yi kintaashɛ le, bo bwɛɛyi blɛd, bo ka bo buune yi kintaashɛ le. ");
INSERT INTO ncr_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Booŋ ba ntuŋ ba Jiso tu bo gêe mwɛɛ mu de yì yunɛ bɛ mwɛɛ wesee mù duunyi bvuŋga bvu Nyo, bamii yɛde, fi ghage lo bo. ");
INSERT INTO ncr_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ŋgoo yi bamii ba mbɛmɛ bachii tu bo nyu yi muh le wu mumwaa, bo kɛme fiɛɛ fiboo fimimia. ");
INSERT INTO ncr_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bo gɛ̀ ja bo gese manjuu maboo bɛ mwɛɛ muboo, bo gade bige biyu lɛbolɛbo no ŋgɛ wu muh gɛ̀ bee. ");
INSERT INTO ncr_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Bo mo bo shee bo taashi fɛ yeh yi kintanyɛ le aju achii, bo jii mwɛɛ yi kintaashɛ le, a la le bɛ kinlaŋye fɛ muntele muboo le, bo yɛɛde gɛ ajii gɛ, ");
INSERT INTO ncr_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","bo yuusɛ Nyo. Bamii bachii koŋe bo. Tada tu wu fii bamii aju achii, wu taade yi ŋgoo yiboo le. ");
INSERT INTO ncr_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Gɛ̀ bee juu chimi, Bita bɛ Joŋ ja bo bɛɛne fɛ yeh yi kintanyɛ le juu bikaa bitɛde fɛnshɛ, gɛ̀ bee kife ki buunɛ. ");
INSERT INTO ncr_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Gɛh kife kiyu le, bamii tuu muh mu bo too bɛ wu, bo shiishɛ wu fɛ jwe wu kitaŋ wù ba gɛ̀ tɛŋe lɛ wù Joŋe wù gɛ̀ leese fɛ yeh yi kintanyɛ le. Muh wuyu ba gɛ̀ boyi wu, wù nyu kiŋkɛlɛ, bamii gɛ̀ tuude wu aju achii bo too bo shiishi fɛ wu lɛgɛ bige fo a bamii ba fede bo leese yeh yi kintanyɛ le. ");
INSERT INTO ncr_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Wu yɛŋ Bita bɛ Joŋ bo fede ki bo lee yu, wu mo wu tu wu lɛgɛ bige a bo le. ");
INSERT INTO ncr_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Bita bɛ Joŋ noŋ ajii yi ye ye le. Bita jɛmɛ wu le lɛ, “Bîjɛ bee!” ");
INSERT INTO ncr_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Wu mo wu bijɛ bo, wu kwaji lɛ bo le bo nyâ wu fiɛɛ. ");
INSERT INTO ncr_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Bita jɛmɛ wu le lɛ, “Gɛ ŋkɛme bige gɛ mbɛŋ, geenɛ, fiɛɛ fì ŋkɛme nlé nnyâ wo le. Njɛme wo le a jee chi Jiso Kletu wu Nasalɛ le lɛ, jâ we wo jîɛnyi!” ");
INSERT INTO ncr_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","No wu jɛmɛ noo, wu mo wu jijɛ wu yi kibo kinchiɛɛŋ le, wu chiaasɛ wu we. Kimimia, bikaa bɛ muŋgolo bi muh wuyu mo bi tɛmɛ. ");
INSERT INTO ncr_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Wu selɛ we wu lɛɛŋ, wu mo wu kɛ wu tu wu jiɛnyi. Bɛ bo gɛɛŋ bo lee fɛ yeh yi kintanyɛ le, wu tu wu jiɛnyi fo wu seele we, wu yuuse Nyo. ");
INSERT INTO ncr_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bamii bachii ba gɛ̀ yɛde no wu jiɛnyi wu yuuse Nyo, ");
INSERT INTO ncr_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","bo kɛɛ lɛ le muh wù gɛ̀ shee wu lɛgɛ kilɛgɛ jwe wu kitaŋ wù Joŋe wù leese fɛ yeh yi kintanyɛ le. Ajii jiiŋ bo, bo kɛme kiŋgha yi fiɛɛ fì kooshi bɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Muh wuyu ŋɛɛŋ lo yi Bita bɛ Joŋ le. Bamii yɛŋ de yuŋ bo, bo tu bo lege bachii bo gɛɛne bo taade bo le fɛ kijusɛ kì ba gɛ̀ tɛŋe lɛ Ŋgaa yi Salamoŋ le. ");
INSERT INTO ncr_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Bita yɛŋ no bamii taashɛ bo too, wu mo wu jɛmɛ bo le lɛ, “Bamii ba Ishwala, le nje la wu jwe yune bɛŋ kune fiɛɛ finɛ, fɛ bɛŋ jiiŋe bee nɛ? Bɛŋ kwaji fiena lɛ ge bvuŋga bwesa muh wunɛ fɛ wu jiɛnyi? Noo bɛŋ kwaji tɛ lɛ ge kinche kesa kì yuude le? Gɛ nyu noo gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Fi le lɛ Nyo wu Ablaham bɛ wu Asik mo wu Yakob, wu le Nyo wu bachiji chiji besa bachii gɛ̀ bɛɛŋsɛ wa Jiso muh we wu lɛme le wu gɛɛ wu mbebe ye le. Jiso wunɛ le wu wù bɛŋ gɛ̀ faŋ, bɛŋ jo bɛŋ nya bamii ba sage le, Balɛt tu wu goone ki wu chînɛ wu le, bɛŋ faŋ. ");
INSERT INTO ncr_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jiso gɛ̀ bee muh wu yuude, wù nyu chaaŋ, bɛŋ faŋ wu, bɛŋ jɛmɛ lɛ ba bvusɛ nyu muh wù gɛ̀ yuuyi bamii, ba nya bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Bɛŋ gɛ̀ ge noo bɛŋ mo bɛŋ yuuyɛ muh wù nyaa kinche bamii le. Geenɛ, Nyo kaasɛ wu bvusɛ wu yi kwe le, bee yɛŋ wu le bee mo be sɛŋe kune wu. ");
INSERT INTO ncr_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ge jee chi Jiso wuyu fɛ kiŋkɛlɛ kinɛ kì bɛŋ yɛde, bɛŋ kee, fɛ ki ja ki jiɛnyi. Fi kooshi noo nje bee le bee lee fitele yi Jiso le, fitele fì bee leese yi ye ye le mo fi ge muh wunɛ mo wu tɛmɛ chuule nɛ no bɛŋ yɛde. ");
INSERT INTO ncr_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Mɛɛse booŋ ba bwɛɛŋ, ŋkêe lɛ fiɛɛ fì bɛŋ bɛ bikwɛɛ biɛna bi woŋ gɛ̀ ge bɛ Jiso le bɛŋ gɛ̀ ge bɛŋ kee gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Fi gɛ̀ kooshɛ yinɛ je le ki fi gê fi to fi kojɛ no Nyo gɛ̀ ge wa bamii be ba ntuŋ le bachii wu gɛ̀ jɛmɛ baaŋ lo lɛ Mbvusɛ we, wu wù gɛ̀ ka lé wu gê wu yɛ̂ŋ ŋgɛ. ");
INSERT INTO ncr_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Noo, bɛŋ kusɛ muntele mwɛna bɛŋ kaasɛ bɛŋ tu jiŋ fɛ wu le, fi le lɛ wu chiijɛ bimbefɛ biɛna, ");
INSERT INTO ncr_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","wu mo wu ge shɛ́ŋ jɛde bɛŋ, wu chiiŋsɛ Jiso wù Mbvusɛ wù wu gɛ̀ balɛ fɛ bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jiso wunɛ kɛme ki wu mɛ̂ fɛwe gɛɛŋ bu kife kì Nyo lé wu gê wu sêesɛ mwɛɛ munchii mu kaasɛ mu tu munfɛŋ, no wu gɛ̀ jɛme de yi bamii be ba ntuŋ ba yuude le baaŋ lo nchensɛŋ. ");
INSERT INTO ncr_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Musɛ gɛ̀ jɛmɛ lɛ, ‘Tada Nyo lé wu gê wu bvûsɛ muh we wu ntuŋ wumu a booŋ ba bwe wene ntɛnɛɛ, wu chîiŋsɛ fɛ bɛŋ le gɛh no wu gɛ̀ bvusɛ mɛ, bɛŋ kɛme ki bɛŋ yûge fiɛɛ fì wu jɛme bɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Muh wu le njɛ wu yuge muh wu ntuŋ wuyu le sɛŋ, le ba nyu ba bvûsɛ wu ŋgoo yi bamii ba Nyo le, ba lɛ̂ɛshɛ lo wu.’ ");
INSERT INTO ncr_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Le gɛh tɛ no bamii ba ntuŋ wu Nyo bachii kɛge yi Samwe le bɛ baa ba gɛ̀ to a wu jiŋ gɛ̀ jɛmɛ wa kune mwɛɛ mù kooshi aju kanɛ le. ");
INSERT INTO ncr_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mwɛɛ munchii mù Nyo gɛ̀ ka de yi bamii be ba ntuŋ banɛ le le mwɛna, leh wù Nyo gɛ̀ ji bɛ bachiji chiji bena, le tɛ fɛ bɛŋ le. Le no Nyo gɛ̀ jɛmɛ Ablaham le lɛ, ‘Nlé ŋgê nôŋ kimbonɛ yi bamii bachii le yi kikwɛɛ ki nshɛŋ le, fede yi mwa wu a wo yeh le.’ ");
INSERT INTO ncr_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nyo mo wu cha muh we wu lɛme wu ya wu tuŋ nyu fɛ bɛŋ le lɛ wu tô wu nôŋ kimbonɛ yi ye yene le, wu gê bɛŋ chinɛ jé yene yì befe le.” ");
INSERT INTO ncr_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Gɛ̀ no Bita bɛ Joŋ gɛ̀ baaŋ bo jɛme bamii le noo, bachiji kintanyɛ bamu bɛ bikwɛɛ bi bamii ba nchi bo gɛ̀ chiɛɛne yeh yi kintanyɛ mo Basadushii bamu selɛ fo. ");
INSERT INTO ncr_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Bo gɛ̀ toonyi shɛ́ŋ nje Bita bɛ Joŋ gɛ̀ yɛyi bamii, bo feeji lɛ no Jiso gɛ̀ bu yi kwe le, le no baŋkfu lé bo gê bo bû tɛ yi kwe le. ");
INSERT INTO ncr_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Bo mo bo koo bo ba gɛɛŋ ba faa no gɛ̀ bee wa fɛnfu, lɛ bvu doo bvuyuu, fɛ bo tû bo yûge. ");
INSERT INTO ncr_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Geenɛ, bamii ba duude bo gɛ̀ yu wa n'yɛyɛ wu Bita bɛ Joŋ, bo gɛ̀ bɛɛŋ, ŋgoo yiboo duu, bilɛŋsɛ mo bo nyume wa njɛ banchvuge batɛŋ (5,000). ");
INSERT INTO ncr_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Bvu gɛ̀ bu bvuyuu, bachiji woŋ bɛ bamii ba sage woŋ mo bamii ba gɛ̀ duunyi banchi ba Nyo, taashɛ kijusɛ ki mumwaa Yɛlusalɛm. ");
INSERT INTO ncr_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas wù kikwɛɛ ki bachiji kintanyɛ bɛ Kayfa mo Joŋ bɛ Alɛksanda mo bamii bamu ba gɛ̀ bee tɛ kfuu chi kikwɛɛ ki bachiji kintanyɛ nyu fo. ");
INSERT INTO ncr_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bo mo bo leesɛ Bita bɛ Joŋ a bo jii, bo biih bo le lɛ, “Bɛŋ chi jo faaŋ bvuŋga fɛ bɛŋ fɛ muh wunɛ? Bɛŋ chi fɛ a jee chi yɛɛŋ le?” ");
INSERT INTO ncr_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Kiyo ki Yuude yisɛ yi Bita le, ki ge wu chvuu bo le lɛ, “Chiji woŋ bɛ bamii ba sage woŋ, ");
INSERT INTO ncr_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","bee lɛme fɛnɛ abɛŋ ki bee tanyɛ jwe kune lɛme chì joŋe chì bee chi ge fɛ kiŋkɛlɛ kinɛ le, fɛ wu jîɛnyi. No bɛŋ goone ki bɛŋ kɛ̂ɛ no fi chi jiɛnyɛ, ");
INSERT INTO ncr_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","bɛŋ mo bamii bachii ba Ishwala kêe lɛ muh wunɛ lɛme a bɛŋ jii mɛɛse wù nyu wu tɛmɛ nɛ, nje jee chi Jiso Kletu wu Nasalɛ. Jiso wunɛ le wù bɛŋ gɛ̀ jo bɛŋ ta yi kintaaŋ le wu kwe, geenɛ Nyo kaasɛ wu bvusɛ wu yi kwe le. ");
INSERT INTO ncr_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Wu le tɛdɛ chi Ŋwa wu Nyo jɛmɛ kune chi lɛ, ‘Tɛdɛ chì bamii ba njonɛ gɛ̀ faŋ lé chi jâ chi tû tɛdɛ chi buu chi yeh.’ ");
INSERT INTO ncr_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Le gɛh Jiso maa wù bvuuse bamii. Gɛ jee chi muh mu ka nyume yu fɛkuu fɛnɛ chi Nyo le wu gɛɛ lɛ taŋlo chi bvuuse bamii gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Bamii ba gɛ̀ sage baa, yu no Bita bɛ Joŋ jɛme bo ya faane gɛ, bo ka bo yɛŋ lɛ le bamii ba nchɛ, bo kee gɛ ŋwa chuule gɛ, de yuŋ lo bo. Bo mo bo kɛɛ lɛ fi le noo, nje le bamii ba gɛ̀ jiɛnyi bɛ Jiso. ");
INSERT INTO ncr_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Bo gɛ ka bo kɛme fiɛɛ fì bo tɛɛnyi Bita bɛ Joŋ yi fi le gɛ, nje bo gɛ̀ yɛde muh wù ba gɛ̀ fɛ le, wu lɛme bɛ bo. ");
INSERT INTO ncr_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Bamii ba gɛ̀ sage bayu ja bo bvusɛ bo akfuuŋ, bo mo bo shɛɛ bo tu bo chude bantaŋ lɛbolɛbo bo duu lɛ, ");
INSERT INTO ncr_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Bee lé be gê nɛɛ bɛ bamii banɛ? Bamii bachii ba Yɛlusalɛm le bo kɛɛ wa kune fiɛɛ fì duunyi bvuŋga bvu Nyo bwanyi le finɛ fi bo ge, gɛ taŋlo bee faŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Geenɛ, ki bee ge lɛ keefɛ saaka wuyu wunɛ ka wu sâaŋe wu gɛ̂ɛne fwe gɛ, bee kâjɛ bamii banɛ lɛ keefɛ bo ka bo môŋ lo bo jɛ̂mɛ fiɛɛ muh le kune jee chi Jiso wunɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Bo tɛɛŋ Bita bɛ Joŋ bo kaasɛ bo lee. Bo lejɛ lo bo le lɛ keefɛ bo ka bo môŋ lo bo jɛme, kɛnɛ bo yɛyi muh kune jee chi Jiso gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Bita bɛ Joŋ chvuu fiboo lɛ, “Bɛŋ kwâjɛ laa fiɛɛ fì le chuule fɛ Nyo le, le lɛ bee yû nyu bɛŋ le noo, wu wù Nyo le la? ");
INSERT INTO ncr_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Gɛ taŋlo bee lu ki be jɛ̂me kune mwɛɛ mù bee le be yɛŋ bee ka be yu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Bamii ba gɛ̀ sage bayu bo ka bo lejɛ lo fi tɛmɛ, bo mo bo chinɛ bo le bo ja bo gɛɛne. Bo gɛ̀ fu fiɛɛ fì bo leesɛ bo yi ŋgɛ le, nje bamii bachii gɛ̀ yuuse Nyo yi fiɛɛ fì gɛ̀ kooshɛ le, ");
INSERT INTO ncr_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","fi ka fi ge muh wuyu wù ba gɛ̀ ge fiɛɛ fì duunyi bvuŋga bvu Nyo finɛ ki ba fɛ wu wù tɛmɛ gɛ̀ bee wu fede wa biluŋ mbaanyɛ. ");
INSERT INTO ncr_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","No bo chinɛ Bita bɛ Joŋ le noo, bo kaasɛ bo tu jiŋ fɛ bamii baboo ba ŋgoo le, bo sɛɛŋ bo fiɛɛ fì bachiji kintanyɛ ba baaŋ baaŋ bɛ bamii ba sage woŋ be jɛmɛ. ");
INSERT INTO ncr_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Bo yu, bo mo bo banyɛ ye bo lɛgɛ Nyo yi muh le wu mumwaa lɛ, “Tada, Chiji Kikwɛɛ wù gɛ̀ fɛ kibvulɛ bɛ nshɛŋ bɛ jóo mo mwɛɛ munchii mù le manjuu manɛ le. ");
INSERT INTO ncr_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wo wù gɛ̀ ge chiji bachiji besa wù Dabi wù gɛ̀ bee mwa yo wu lɛme, wu jɛmɛ bɛ bvuŋga bvu Kiyo ki Yuude le lɛ, ‘Le nje la wù bamii ba le gɛ Bajuu gɛ fuge bɛ fiɛɛ shɛ́ŋ le, bamii chude bantaŋ njɛ bo lé bo lɛ̂ɛŋ sɛŋ? ");
INSERT INTO ncr_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Banfoŋ ba fɛkuu fɛnɛ seese jɛŋ, bamii ba sage woŋ taashi ki bo juu bɛ Tada bɛ muh we wù wu le wu yefɛ lɛ le Mbvusɛ.’ ");
INSERT INTO ncr_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Le gɛh yɛɛŋyɛɛŋ bɛ fiɛɛ fì gɛ̀ kooshɛ alaantɛŋ yanɛ. Nfoŋ Hɛlod bɛ Bontu Balɛt gɛ̀ taashɛ bɛ bamii ba le gɛ Bajuu gɛ mo bamii ba Ishwala bo ji nchvuuŋ yi Jiso wu le mwa yo wu lɛme wù yuude wù wo gɛ̀ yefɛ lɛ wu le Mbvusɛ. ");
INSERT INTO ncr_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bo gɛ̀ taashɛ ki bo ge nyu mwɛɛ mù wo gɛ̀ bee wo seesɛ wa je yì ndefe le bɛ bvuŋga bwuŋ no wo koŋe lɛ mu gê mu kôoshɛ. ");
INSERT INTO ncr_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Noo, yi mɛɛse le Tada, bîjɛ wo yɛ̂ŋ je yì bamii banɛ nyuse bɛ bee. Nya bee bamii buŋ ba lɛme bɛ muntele mù tɛɛme ki bee feeji jɛ yo bee faane gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nya bee bɛ bvuŋga bwuŋ bee fɛde bamii bee ka gee mwɛɛ mù duunyi bvuŋga bwuŋ bɛ mwɛɛ mu de yì yunɛ a jee chi Jiso wù Mwa yo wu lɛme wù yuude le.” ");
INSERT INTO ncr_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","No bo mɛse bo buunɛ, nshɛŋ shiŋshɛ fɛ bo gɛ̀ bee fo. Kiyo ki Yuude yisɛ yi bo le, bo mo bo tu bo feeji jɛ yi Nyo bo faane gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ŋgoo yi bamii ba mbɛmɛ gɛ̀ bee fitele fimimia, bo nyu yi muh le wu mumwaa, muh tɛŋe gɛ fiɛɛ fimi lɛ le fie wumaa gɛ. Fiɛɛ fi muh gɛ̀ bee fi bamii bachii. ");
INSERT INTO ncr_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Nyo nya bvuŋga bvù baaŋ booŋ ba ntuŋ ba Jiso le, bo tu bo feeji bamii le fi tɛɛme lo lɛ Tada Jiso gɛ̀ bu yi kwe le. Nfii wu Nyo nyume yi bo le bachii wesee. ");
INSERT INTO ncr_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Gɛ muh gɛ̀ nyu yu wu fuude a bo ntɛnɛɛ gɛ, nje bamii ba gɛ̀ kɛme ŋɛɛ kɛnɛ yéh, bo gɛ̀ gese bo too bɛ bige biyu, ");
INSERT INTO ncr_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","bo nyaa chiaaŋ yi booŋ ba ntuŋ ba Jiso le, bo mo bo gade bamii le bachii no ŋgɛ wu muh gɛ̀ bee. ");
INSERT INTO ncr_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Muh mu gɛ̀ bee ba tɛŋe lɛ Yosɛf, booŋ ba ntuŋ ba Jiso chu jee che chimi lɛ Banaba, (Chì le lɛ, Muh N'yufɛ Muntele). Wu gɛ̀ bee muh wu a kfuu chi Lɛwe le, ba gɛ̀ boyi wu Sablu. ");
INSERT INTO ncr_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Wu mo wu gɛɛŋ tɛ wu gesɛ we mwɛ, wu to wu nya bige biyu chiaaŋ yi booŋ ba ntuŋ ba Jiso le. ");
INSERT INTO ncr_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Muh mu wù ba gɛ̀ tɛŋe lɛ Anania bɛ kwɛɛ wu Safɛla gɛ̀ gesɛ tɛ kijusɛ. ");
INSERT INTO ncr_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Bɛ kwɛɛ seesɛ bo gade bige biyu, wu mo wu jo kimbɛge wu gɛɛŋ wu nya chiaaŋ yi booŋ ba ntuŋ ba Jiso le. ");
INSERT INTO ncr_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","No wu nya noo, Bita biih wu le lɛ, “Anania, ge la fɛ wo chinɛ Sataŋ lee a fitele fiuŋ le wu gê lɛ wo mbîaŋ chimbiaŋ fɛ Kiyo ki Yuude le, wo mo wo gade bige bì wo gese kijusɛ yu? ");
INSERT INTO ncr_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Fɛ wo chi bee ki wo gêsɛ kijusɛ kinɛ gɛ chi bee kuŋ gɛ? Wo doo wo gesɛ bige nyume tɛ biuŋ gɛ? Wo ge nɛɛ fɛ wo ge kfuu chi finɛ fiɛɛ? Wo baaŋ mbiaŋ gɛ nyu bɛ bamii gɛ, wo mbiane nyu fɛ Nyo le.” ");
INSERT INTO ncr_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kimimia no Anania yu jɛmɛ wunɛ noo, wu mo wu gwe wu kwe. Bamii bachii bo gɛ̀ yu saaka wuyu faaŋ baaŋ. ");
INSERT INTO ncr_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Chuu yi bamii to yi banyɛ wu a nju le, bo jo wu bo bu bɛ wu bo gɛɛŋ bo jiiyɛ. ");
INSERT INTO ncr_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ajiŋ njɛ juu bataŋ batɛde, kwɛɛ lee, wu kee gɛ̀ fiɛɛ fì be kooshɛ bɛ jwɛɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Bita biih wu le lɛ, “Gɛh sɛ̂ɛŋ mɛ, binɛ le bige bichii bì bena jwɛɛŋ be gesɛ kijusɛ kɛɛ yu?” Wu chvuu lɛ, “Ɛɛŋ, le bi nɛ bichii.” ");
INSERT INTO ncr_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Bita ka wu biih wu le lɛ, “Bena jwɛɛŋ ge nɛɛ fɛ bɛŋ seesɛ ki bɛŋ môŋ Kiyo ki Tada lɛ? Yêgɛ yû, mɛɛse nchiŋ yi bamii ba gɛnɛ ki bo jiiyɛ jwɛɛŋ le wa a yeh fwɛɛŋ, bo lé bo lêe bo tûu tɛ wo bo bû bɛ wo bo gɛ̂ɛŋ bo jîiyɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","No Bita jɛmɛ noo, kimimia Safɛla mo wu gwe a wu jii wu kwe. Chuu yi bamii baa doo bo lee bo yɛŋ wù nyu wu kwe wa, bo mo bo tuu wu bo bu bɛ wu bo gɛɛŋ bo jiiyɛ mbebe jwɛɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kintaashɛ ki bamii ba mbɛmɛ kichii mo bamii bachii ba gɛ̀ yu saaka wuyu faaŋ baaŋ. ");
INSERT INTO ncr_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Booŋ ba ntuŋ ba Jiso tu bo gee mwɛɛ mù duunyi bvuŋga bvu Nyo bɛ mwɛɛ mù duude mu de yì yunɛ a bamii ntɛnɛɛ. Bamii ba mbɛmɛ bachii gɛ̀ taashi fɛ Kibuu ki Salamoŋ le fɛ yeh yi kintanyɛ le. ");
INSERT INTO ncr_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Gɛ muh wu nchɛ gɛ̀ mone ki wu tâashi bɛ bo gɛ. Geenɛ bamii tu bo bɛɛŋse bo chuule. ");
INSERT INTO ncr_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Bilɛŋsɛ bɛ bikɛse ba duude ba gɛ̀ leesɛ muntele yi Tada le, tu bo taade fɛ ŋgoo yiboo le. ");
INSERT INTO ncr_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Mwɛɛ mù booŋ ba ntuŋ ba Jiso gɛ̀ gee, ge bamii tuude bamii ba binchɛŋ bo giŋse mbebe jé le yi binta le mo yi bijinɛ le, lɛ sege Bita doo wu fede, mo nyu gɛh kinjiinyi ke ki gwe yi muh le. ");
INSERT INTO ncr_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Binchvu bi bamii jade bilaantɛŋ bi mbebe Yɛlusalɛm le bi too bɛ bamii ba binchɛŋ mo ba kɛme biyo bì yiide ye yi boo le, ba fɛde bo bachii bo tɛɛme. ");
INSERT INTO ncr_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kikwɛɛ ki bachiji kintanyɛ bɛ ŋgoo ye yì gɛ̀ bee Basadushii gɛ̀ ja bo kɛ bo tu bo ghɛge booŋ ba ntuŋ ba Jiso, ");
INSERT INTO ncr_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","bo mo bo tuŋ bamii bo gɛɛŋ bo koo bo, ba faa yeh yi ncha le. ");
INSERT INTO ncr_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Geenɛ, antaŋ nchɛndaa wu Tada gɛ̀ gwenyɛ de yi fwese yi yeh yi ncha wu bvusɛ bo. No wu bvuse bo, wu mo wu jɛmɛ lɛ, ");
INSERT INTO ncr_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Bɛŋ gɛ̂ɛŋ yeh yi kintanyɛ le kibɛɛ, bɛŋ gɛ̂ɛŋ bɛŋ lɛ̂ɛŋ bɛŋ fêeji fiɛɛ fichii bamii le kune kinche kifɛŋ kinɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","No bo yu noo, bo mo bo gɛɛŋ. Akfuuŋ gɛ̀ doo a yuude, bo lee fɛ yeh yi kintanyɛ le, bo mo bo kɛ bo tu bo yɛyi bamii. Gɛh kife kiyu le, kikwɛɛ ki bachiji kintanyɛ bɛ bamii be ba ŋgoo, bo kuŋ bamii ba Ishwala ba sage woŋ bachii bɛ bo shii, bo mo bo tuŋ bamii ba nchi ki bo gɛɛŋ yeh yi ncha le, bo gɛɛŋ bo to bɛ booŋ ba ntuŋ ba Jiso. ");
INSERT INTO ncr_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Bo gɛɛŋ bo bu fo bo gooŋ bo sɛŋ bo mo bo tu jiŋ bo sɛɛŋ lɛ, ");
INSERT INTO ncr_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Bee le be gɛɛŋ be bu fɛ yeh yi ncha le, bee yɛŋ de yi fwese nyu ba faa chuule bamii ba nchi lɛme fo bo chiɛɛne. Bee doo be gwenyɛ yeh bee lee bee baaŋ yɛŋ gɛ muh le yu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kikwɛɛ ki bamii ba nchi ba gɛ̀ chiɛɛne yeh yi kintanyɛ bɛ bachiji kintanyɛ ba baaŋ baaŋ yu noo, fi fuuŋsɛ bo, bo tu bo ghaade laa bo lé bo gê bo tû faaŋ bɛ finɛ fiɛɛ lɛ. ");
INSERT INTO ncr_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Muh ja wu lee wu jɛmɛ bo le lɛ, “Bɛŋ yû, bamii baa ba bɛŋ chi baŋ yeh yi ncha le, bo lɛme wa fɛ yeh yi kintanyɛ le bo yɛyi bamii.” ");
INSERT INTO ncr_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","No bo yu noo, kikwɛɛ ki bamii ba nchi, bɛ ŋgoo ye mo bo bu bo gɛɛŋ bo jo bo, bo tu bo too bɛ bo. Geenɛ, bo gɛ̀ baaŋ jo gɛ bo bo kaaŋ lo bo gɛ, nje bo, bamii ba nchi baa gɛ̀ faane lɛ bamii baa le bo tûmɛ bo bɛ ata. ");
INSERT INTO ncr_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bo to bɛ booŋ ba ntuŋ ba Jiso, bo lee bɛ bo, bo lɛɛŋ fwe a bamii ba sage woŋ. Kikwɛɛ ki bachiji kintanyɛ biide bo mwɛɛ wu duu lɛ, ");
INSERT INTO ncr_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Bee le be moŋ wa ki be lejɛ lo lɛ keefɛ bɛŋ ka bɛŋ môŋ bɛŋ yɛ̂yɛ muh kune jee chi muh wunɛ gɛ. Geenɛ, bɛŋ yɛ̂ŋ fiɛɛ fì bɛŋ moŋ! Bɛŋ le bɛŋ ge wa n'yɛyɛ wene saaŋe Yɛlusalɛm achii. Bɛŋ goone ki bɛŋ gê fi dûunyi lɛ bee kee fiɛɛ fɛ kwe ye le.” ");
INSERT INTO ncr_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Bita bɛ ŋgoo yi booŋ ba ntuŋ ba Jiso chvuu lɛ, “Bee kɛme ki be yû nyu Nyo le, nyume gɛ a muh le gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Bɛŋ gɛ̀ ta Jiso yi kintaaŋ le wu kwe. Nyo wu bachiji chiji wese bvusɛ wu yi kwe le, ");
INSERT INTO ncr_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","wu bɛɛŋsɛ wu, wu shiishɛ wu a kibo ke kinchiɛɛŋ le, lɛ wu nyûme Chiji kikwɛɛ mo Mbvusɛ, fi le lɛ bamii ba Ishwala kûsɛ muntele muboo, wu wù Nyo lɛ̂ɛshɛ bimbefɛ biboo. ");
INSERT INTO ncr_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Bee le be yɛŋ mwɛɛ munɛ le, bee mo be tu be sɛŋe bamii le, Kiyo ki Yuude kì Nyo nyaa bamii ba yuge wu le ki toone tɛ lɛ mwɛɛ munɛ le nchiɛɛŋ.” ");
INSERT INTO ncr_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","No bamii ba gɛ̀ sage woŋ yu njɛmɛ wunɛ noo, muntele bɛde lo bo. Bo mo bo goone ki bo yuuyɛ booŋ ba ntuŋ ba Jiso. ");
INSERT INTO ncr_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Geenɛ, muh mu ŋgoo yi bamii ba gɛ̀ sage woŋ le, wù jee che gɛ̀ bee Gamala, nyu muh wu Bafalashii ka nyu muh wù duunyi banchi ba Nyo, bamii bachii ŋgvuune wu chuule wu ja we. No wu ja we, wu jɛmɛ bo le lɛ bo ya bo bvusɛ booŋ ba ntuŋ ba Jiso akfuuŋ. ");
INSERT INTO ncr_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Wu shɛɛ wu jɛmɛ bamii ba gɛ̀ sage woŋ le lɛ, “Bamii ba Ishwala, bɛŋ jô wɛɛ bɛ fiɛɛ fì bɛŋ goone ki bɛŋ gê bɛ bamii banɛ. ");
INSERT INTO ncr_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Bɛŋ kwâjɛ lɛ gɛ̀ bee kife kimi le, muh mu ja fɛnɛ ba tɛŋe lɛ Tioda, wu tu wu duunyi lɛ wu le muh wù baaŋ. Bamii banyɛ a wu jiŋ njɛ gii yinɛh. Ba gɛ̀ yuuyɛ wu ŋgoo ye saaŋe, fiɛɛ fì wu gɛ̀ too bɛ fi laayɛ achiji. ");
INSERT INTO ncr_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ajiŋ ayu, muh mu ka wu ja kife kì ba gɛ̀ taŋe bamii ba tɛŋe lɛ Juda, nyu muh wu Galalee. Wu chii bamii wesee a wu jiŋ. Ba gɛ̀ yuuyɛ tɛ wu, ŋgoo ye saaŋe. ");
INSERT INTO ncr_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Yi finɛ le, ntêefe bɛŋ lɛ keefɛ bɛŋ gê fiɛɛ bɛ bamii banɛ gɛ. Bɛŋ chînɛ je yiboo le! Finɛ le lɛ fiɛɛ fì bo too bɛ fi finɛ bo ka yɛyi bamii yu finɛ nɛ kɛ muh wu wuŋ, tu fi le fi laayɛ achiji. ");
INSERT INTO ncr_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nɛ fi le lɛ fiɛɛ fiyu kɛ Nyo, tu gɛ taŋlo bɛŋ ge bɛŋ so bo gɛ. Bɛŋ yɛ̂nɛ, keefɛ fi jâ fi bû lɛ bɛŋ juu nyu bɛ Nyo.” ");
INSERT INTO ncr_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","No Gamala jɛmɛ noo, bamii ba gɛ̀ sage woŋ bo yu nteefe ye, bo kaasɛ bo tɛɛŋ booŋ ba ntuŋ ba Jiso bo lee. No bo lese noo, bo taaŋ bo, bo chiisɛ lo lɛ keefɛ bo ka bo môŋ lo bo yɛ̂yɛ muh kune jee chi Jiso gɛ, bo mo bo chinɛ bo le lɛ bo gɛ̂ɛne. ");
INSERT INTO ncr_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","No bo bu yu bo ja bo gɛɛne fiboo bo yuge nyu njoŋ lɛ bo le bo kojɛ bamii ba, ba choose bo nje jee chi Jiso. ");
INSERT INTO ncr_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Lɛ bo gɛɛŋ noo, bo ka bo tu bo yɛyi bamii aju achii fɛ yeh yi kintanyɛ le mo ala le, bo feeji saaka wù joŋe wu Jiso, lɛ Jiso le Mbvusɛ wù Nyo gɛ̀ ka. ");
INSERT INTO ncr_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Lɛ nyu kife kimi le, no ŋgoo yi bamii ba mbɛmɛ gɛ̀ kuu yi gɛɛne fwe Bajuu ba gɛ̀ jɛme nyu jɛ́ yi Glek bo ja bo kɛ bo tu bo shuŋshi Bajuu ba gɛ̀ jɛme jɛ́ yi woŋ, lɛ bo gaji mwɛɛ ba kwɛŋkfu le aju achii bo yɛde gɛ ba kwɛŋkfu baboo le gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Noo, booŋ ba ntuŋ ba Jiso ba yuufe ncho bafɛɛ mo bo kuŋ ŋgoo yi bamii ba mbɛmɛ bachii bo jɛmɛ bo le lɛ, “Gɛ fi kooji lɛ bee chînɛ ki be fêeji jɛ yi Nyo bee gɛ̂ɛŋ be shîi yi gabe le gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Booŋ ba bwe wese, fi joŋe lɛ bɛŋ bâayɛ bamii bvusooshwi a bɛŋ ntɛnɛɛ, bee nyâ lɛme chinɛ chiaaŋ yiboo le. Bɛŋ doo bɛŋ baayi bɛŋ bijɛ nyu bamii ba kɛme kinche kì joŋe, bo yisɛ bɛ Kiyo ki Yuude bo ka kɛme bvufee. ");
INSERT INTO ncr_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Noo, bee mo be nyâ bikwɛɛ biɛsa nyu yi buunɛ le bɛ yi lɛme chi jɛ yi Nyo le.” ");
INSERT INTO ncr_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Bamii bachii yu ntaŋ wɛɛ, wu joŋ bo le. Bo mo bo baa Tifiŋ wu nyume muh wù mbɛmɛ we le wu yisɛ chuule wu nyu wu yisɛ tɛ bɛ Kiyo ki Yuude. Bamu nyu Filib bɛ Blukolu, Nikano bɛ Timoŋ, Balmɛna bɛ Nikola wù gɛ̀ bee muh wu Antiok wù gɛ̀ kaasɛ lo wu tu muh wu mbɛmɛ wu Bajuu. ");
INSERT INTO ncr_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bo mo bo jo bamii banɛ bo leesɛ fwe a booŋ ba ntuŋ ba Jiso le, bo gɛɛ chiaaŋ yi bo le, bo buunɛ fɛ bo le. ");
INSERT INTO ncr_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Jɛ yi Nyo mo yi saaŋe yi gɛɛne lo. Ŋgoo yi bamii ba mbɛmɛ yi Yɛlusalɛm tu yi kuu yi gɛɛne fwe chuule Bachiji kintanyɛ ba duude lee tɛ muntele yi Jiso le. ");
INSERT INTO ncr_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Tifiŋ gɛ̀ bee wu yisɛ bɛ nfii wu Nyo bɛ bvuŋga, wu gee mwɛɛ mù jwe wù yunɛ, bɛ mwɛɛ mù duunyi bvuŋga bvu Nyo a bamii ntɛnɛɛ. ");
INSERT INTO ncr_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Bamii bamu gɛ̀ ja bo kɛ bo tɛɛnyi bɛ ba Tifiŋ. Bamii baa gɛ̀ bee Bajuu ba gɛ̀ ja Sɛliŋ bɛ Alɛksanda mo Silisia bɛ Ɛsia. Gɛ̀ bee bamii ba yeh yi buunɛ yi ba gɛ̀ tɛŋe lɛ yi Nfa ba bu wa yi Bvunfa le. ");
INSERT INTO ncr_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","No bo gɛ̀ tɛɛnyi noo, Kiyo ki Yuude nya Tifiŋ bɛ bvufee, muh nyume gɛ yu wu le no wu so wu gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Bo mo bo ja bo bɛɛse bamii bamu ajiŋ ajiŋ ki bo mbîane lɛ, bo le bo yu Tifiŋ jɛme jɛ́ yì befe kune Musɛ bɛ Nyo. ");
INSERT INTO ncr_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","No bo ge noo, bo mo bo shiŋshɛ muntele mu bamii, bɛ mu bamii ba sage woŋ, mo mu bamii ba duunyi banchi ba Nyo. Bo mo bo lee yi Tifiŋ le, bo jo wu bo gɛɛŋ bɛ wù fwe a bamii ba woŋ ba gɛ̀ sage bansa. ");
INSERT INTO ncr_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Bamii baa ka bo to bɛ bamii bamu bo lɛme jiŋ yi nsa wu chimbiaŋ, bo tu bo kooyi mwɛɛ yi Tifiŋ le bo duu lɛ, “Gɛ muh wunɛ to wù nyu njɛ wu jɛme jɛ́ yì befe kune yeh kintanyɛ yinɛ bɛ banchi ba Musɛ lɛ sɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Bee le be yu wa wu jɛme lɛ Jiso wu Nasalɛ wɛɛ le wu sa yeh yi kintanyɛ yinɛ, wu ka wu kusɛ kinche kesa ki woŋ kì Musɛ gɛ̀ yɛyɛ bee yu.” ");
INSERT INTO ncr_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Bamii bachii ba gɛ̀ bee yeh yi nsa le noŋ ajii yi Tifiŋ le, bo ja bo yɛŋ bvushi bwe kaasɛ wa ye bvu tu bvu fiɛɛnɛ bvu nchɛndaa wu Nyo. ");
INSERT INTO ncr_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kikwɛɛ ki bachiji kintanyɛ biih Tifiŋ le lɛ, “Mwɛɛ mù ba jɛme munɛ le nchiɛɛŋ?” ");
INSERT INTO ncr_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Tifiŋ chvuu lɛ, “Bachii bɛ booŋ ba bwɛɛŋ, bɛŋ yêgɛ bɛŋ yû. Nyo wu bvukugɛ gɛ̀ bunɛ fɛ chiji wese wù Ablaham le wu baaŋ wu chee Misobotɛmia, fɛ wu ja wu gɛɛŋ wu tu wu chee Alaŋ, ");
INSERT INTO ncr_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","wu jɛmɛ wu le lɛ, ‘Chînɛ kfuu chuŋ le, wo bû woŋ wene le, wo gɛɛŋ woŋ wu nlé ndûnyɛ wo le.’ ");
INSERT INTO ncr_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Noo, wu mo wu ja Chadia ayu, wu gɛɛŋ wu tu wu chee Alaŋ. Chiji gɛ̀ doo wu kwe, Nyo ge wu ja wu to yanɛ a bɛŋ chee yo mɛɛse. ");
INSERT INTO ncr_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Wu tu wù nyu yanɛ, Nyo gɛ̀ baaŋ nya gɛ wu mo bɛ gwɛŋ gɛ, geenɛ, wu ka lɛ wu lé wu gê wu nyâ wu woŋ kfunɛ nyû we bɛ kiŋgogɛ ke. Nyo gɛ̀ ka noo, Ablaham baaŋ a kɛme gɛ mwa gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nyo ka wu jɛmɛ wu le lɛ, ‘Kiŋgogɛ kuŋ lé ki gê ki nyû bantolo woŋ wumu le, ki lɛne bvunfa yo, ba nyuse bɛ bo yi biluŋ le gii yinɛh (400). ");
INSERT INTO ncr_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nlé ŋgê nôŋ ŋgɛ yi woŋ wuyu le, kiŋgogɛ kuŋ lé ki gê ki bû yo ki tô ki bûunɛ Nyo yanɛ.’ ");
INSERT INTO ncr_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nyo ka wu ji leh bɛ Ablaham, njiŋɛ wu leh wunɛ le lɛ Ablaham lé wu gê wu chvûse booŋ be yeh. Ablaham gɛ̀ boo Asik, lɛ doo nyume aju nyaaŋ wu chvuu wu yeh. Asik gɛ̀ boo Yakob wu chvuu tɛ wu yeh. Yakob gɛ̀ chvûu tɛ booŋ be ba yuufe ncho bafɛɛ yeh ba le bachiji chiji besa fɛ kfuu chesa besabɛŋ to chi saane. ");
INSERT INTO ncr_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Bachiji chiji besa baa gɛ̀ ja bo tu bo bɛɛne kindoŋ bɛ Yosɛf wù mwa bwe bo, bo mo bo gesɛ wu, wu gɛɛŋ wu tu wù nyu nfwa woŋ wu Ijib le. Geenɛ, Nyo tu wu jiiŋe gɛh fɛ wu le, ");
INSERT INTO ncr_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","wu fii wu yi baŋgɛ be le bachii. Nyo ka wu nya wu bɛ bvufee, wu fɛ Falawu, Nfoŋ wu Ijib tu wu koŋe wu, wu mo wu gɛɛ wu lɛ wù nyû ŋkfuŋ we wù baaŋ, wu ka nyu muh wù jîiŋe fɛ kfuu che le. ");
INSERT INTO ncr_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Jɛŋ gɛ̀ ja yi koo Ijib aju achii mo Kanan, bamii yɛŋ ŋgɛ baaŋ. Bachiji chiji besa gɛ̀ kɛme gɛh fiɛɛ fijile gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yakob gɛ̀ yu lɛ mwɛɛ munjile le Ijib, wu mo wu tuŋ booŋ be ba le bachiji chiji besa, bo gɛɛŋ yo ŋgɛnɛ wu fweele le. ");
INSERT INTO ncr_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Bo gɛ̀ doo bo kaasɛ bo gɛɛŋ yo ŋgɛnɛ wu kinfɛɛ le, Yosɛf mo wu ge booŋ ba bwee kɛɛ wu. Wu mo wu dunyɛ tɛ bo Falawu le. ");
INSERT INTO ncr_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yosɛf mo wu chiiŋsɛ ntuŋ fɛ Yakob wu chiji le, lɛ wu bɛ kfuu che chichii tò Ijib. Kfuu chi Yakob gɛ̀ bee kife kiyu le muh mbaŋbvusooshwi ncho batɛŋ (75). ");
INSERT INTO ncr_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakob yu noo, wu mo wu jo kfuu che chichii bo boh Ijib. Wu bɛ bachiji chiji besa gɛ̀ kweeyɛ yo bachii. ");
INSERT INTO ncr_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Bo gɛ̀ tuu agvuŋ aboo bo kaasɛ bo to, bo jiiyɛ Shɛkem a jɛŋ yi Ablaham gɛ̀ gu a booŋ ba Amo le. ");
INSERT INTO ncr_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Kife gɛ̀ doo ki kojɛ ki Nyo lé wu gê fiɛɛ fì wu gɛ̀ ka wa Ablaham yu, bamii besa duu wa Ijib baaŋ. ");
INSERT INTO ncr_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Bamii ba Ijib gɛ̀ ghaa nfoŋ wumu wu ya kee gɛ Yosɛf gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nfoŋ wuyu mo wu wɛɛne, wu ghɛge bamii besa, wu tooŋse lɛ bachiji chiji besa nôoŋe mu mwonɛ mu booŋ akfuuŋ bo kweeyi. ");
INSERT INTO ncr_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Le kife kinɛ kì ba gɛ̀ boyɛ Musɛ, nyu mwa wù joŋe baaŋ fɛ Nyo le. Bo kɛmɛ wu yeh yi kii le yi tɛde, ");
INSERT INTO ncr_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","bo mo bo jo wu bo gɛɛŋ bo gɛɛ akfuuŋ. Mwa Nfoŋ Falawu wù kwɛse gɛ̀ gɛɛŋ wu boŋ wu, wu lɛyɛ wu njɛ mwa ye. ");
INSERT INTO ncr_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Bo mo bo yɛyɛ Musɛ bɛ bvufee bvu bamii ba Ijib bvuchii, wù nyu muh wù kee njɛmɛ bɛ ki wu gêe mwɛɛ chuule. ");
INSERT INTO ncr_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Wu gɛ̀ doo wu bu biluŋ mbaanyɛ, wu ja wu kwajɛ lɛ wu lé wu gɛ̂ɛŋ wu yɛ̂ŋ no booŋ ba bwee ba le bamii ba Ishwala nyume. ");
INSERT INTO ncr_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Wu doo wu gɛɛne, wu yɛŋ muh wu Ijib nyuse muh wu Ishwala wumu. Wu lee fo lɛ wu chvuu kichvusɛ, wu mo wu yuuyɛ lo muh wu Ijib wɛɛ. ");
INSERT INTO ncr_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Wu gɛ̀ kwaji lɛ booŋ ba bwee le bo kɛɛ lɛ tuŋ Nyo wu lɛ wu tô wu bvûsɛ bo yi ŋgɛ le. Geenɛ, bo gɛ̀ baaŋ kɛɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Bvu gɛ̀ bu bvu yuu, Musɛ ka wu gɛɛne, wu bu yi bamii ba Ishwala le bafɛɛ bo ja bo juu lɛbolɛbo. Wu lee fo ki wu gâde bvuju bvuyu, wu biih bo le lɛ, ‘Booŋ ba bwɛɛŋ, bɛŋ le muh bɛ mwa bwee, ge la bɛŋ fɛ bɛŋ juu lɛbɛŋlɛbɛŋ?’ ");
INSERT INTO ncr_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Muh wù gɛ̀ nyuse mwa bwee wɛɛ ka wu tooŋsɛ lo Musɛ, wu biih wu le lɛ, ‘Gɛle yɛɛŋ wo lɛ wo sâge bee, wo suunɛ bansa besa? ");
INSERT INTO ncr_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wo fɛnɛ ka goone ki wo yûuyɛ mɛ gɛh no wo chi yuuyɛ muh wu Ijib wɛɛ ŋguufɛ?’ ");
INSERT INTO ncr_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musɛ yu noo, wu mo wu faaŋ wu ja woŋ wu Ijib le, wu fɛɛ lo wu gɛɛŋ wù nyu woŋ wu Midian le, wu gɛ̀ boo booŋ ba bilɛŋsɛ bafɛɛ yo. ");
INSERT INTO ncr_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Lɛ nyume ajiŋ a biluŋ mbaanyɛ, nchɛndaa wu Nyo bunɛ fɛ Musɛ le, yi ŋgu le wu bɛde yi kite ki mbiaŋ le nchvuuŋ mbebe Mbegɛ wù Sina le. ");
INSERT INTO ncr_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musɛ yɛŋ fi gha wu, wu kɛŋsɛ mbebe le ki wu bîjɛ chuule no wu kɛŋse, wu yu Tada Nyo jɛmɛ wu le lɛ, ");
INSERT INTO ncr_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Le mɛ wù Nyo wu bachiji chiji bena, Nyo wu Ablaham bɛ wu Asik mo wu Yakob.’ Musɛ yu noo, wu tu wu koge bɛ nfaaŋ baaŋ, wu gɛ ka wu moŋ lo wu jiŋɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Tada Nyo ka wu jɛmɛ wu le lɛ, ‘Bâayɛ balaba buŋ, nje fɛnɛ fɛ wo lɛme fo le kijusɛ kì yuude. ");
INSERT INTO ncr_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nle n'yɛŋ wa chuule no ba nyiɛge bɛ bamii baŋ Ijib, ŋka n'yu no bo tune, mɛ mo nshii nto ki mbvûsɛ bo yi ŋgɛ wuyu le. Yêgɛ yû, nlé ntûŋ wo Ijib mɛɛse.’ ");
INSERT INTO ncr_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Musɛ wunɛ le wu wù bo gɛ̀ faŋ wa, bo biih wu le lɛ, ‘Gɛle yɛɛŋ wo lɛ wo sâge bee, wo suunɛ bansa besa?’ Le wu wù Nyo gɛ̀ tuŋ lɛ wu gɛɛŋ wù nyu muh wu ge wu sage bo, wu ge wu bvusɛ bo yi ŋgɛ le. Nyo gɛ̀ tuŋ nyu nchɛndaa we wu to yi kite ki mbiaŋ kì gɛ̀ bɛde kɛɛ le wu fejɛ ntuŋ wɛɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Musɛ mo wu gɛɛŋ Ijib, wu ge mwɛɛ mu de yì yunɛ bɛ biŋgha bi mwɛɛ, wu bvusɛ bo yo. Wu ge mumu nyu fɛ joo yì Baaŋ yì Yɛɛde le, wu ka wu ge mumu nchvuuŋ a bo gɛ̀ jiɛnyi yo yi biluŋ le mbaanyɛ. ");
INSERT INTO ncr_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Le Musɛ wuyu wu gɛ̀ jɛmɛ bamii ba Ishwala le lɛ, ‘Nyo lé wu gê wu bvûsɛ muh we wu ntuŋ wumu a booŋ ba bwe wene ntɛnɛɛ, wu chîiŋsɛ fɛ bɛŋ le, gɛh no wu gɛ̀ bvusɛ mɛ.’ ");
INSERT INTO ncr_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ka nyume gɛh wu wù Musɛ wù nchɛndaa wu Nyo gɛ̀ jɛmɛ wu le yi mbegɛ wu Sina le kife kì kintaashɛ ki bamii ba Ishwala gɛ̀ bee nchvuuŋ bɛ bachiji chiji besa, Nyo nya jɛ yì nyaa kinche lɛ wu feesɛ bee le. ");
INSERT INTO ncr_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Geenɛ, bachiji chiji besa ka bo faŋ ki bo yu fiɛɛ fì Musɛ jɛme, bo baa lo jiŋ wu le, bo tu bo koŋe ki bɛ bo kaase bo tuu lo fiboo jiŋ Ijib. ");
INSERT INTO ncr_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Bo mo bo jɛmɛ Aloŋ le lɛ, ‘Maa banyo bo lé bo sâa bee fwe, nje bee baaŋ ka kɛɛ gɛ fiɛɛ fì kooshi bɛ Musɛ wɛɛ wu gɛ̀ bvusɛ bee woŋ wu Ijib le gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Bo mo bo kɛnyɛ fimooso fi fiɛɛnɛ mwa naa, bo sɛɛyi nyáŋ bo ge kintanyɛ yu fi le, bo tu bo laŋeye yi fiɛɛ fì kɛnyɛ bo bɛ chiaaŋ yiboo le. ");
INSERT INTO ncr_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","No bo ge noo, Nyo mo wu baa jiŋ bo le, bo tu bo buune wa nyu fɛ juu bɛ kwii le mo jóŋ. Nyu gɛh no ba gɛ̀ saŋ a ŋwa wu bamii ba ntuŋ wu Nyo le lɛ, Nyo jɛme lɛ, ‘Bamii ba Ishwala, bɛŋ gɛ̀ sɛɛyi nyáŋ nchvuuŋ yi biluŋ le mbaanyɛ, bɛŋ tuufe nyu mɛ yu? ");
INSERT INTO ncr_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Bɛŋ gɛ̀ jiɛnyi bɛŋ tuude nyu chuŋ yi nyo wù bo tɛŋe lɛ Molok, bɛŋ ka tuude joŋ yì ba kɛnyɛ lɛ le nyo wù jee le Lefaŋ, nyu mumooso mù bɛŋ gɛ̀ kɛnyɛ ki bɛŋ bûune mu. Nje finɛ, nlé ŋgê mbvûsɛ bɛŋ, bɛŋ bû bɛŋ gɛ̂ɛŋ bɛŋ fê lo Babiloŋ.’ ");
INSERT INTO ncr_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Bachiji chiji besa gɛ̀ jiɛnyi nchvuuŋ bo kɛme chuŋ yì duunyi lɛ Nyo le bɛ bo, bo gɛ̀ fɛ chuŋ yɛɛ bii yɛɛŋyɛɛŋ no yi Nyo gɛh chunyɛ Musɛ le gɛ̀ bee. ");
INSERT INTO ncr_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Booŋ ba bachiji chiji besa gɛ̀ fi, bo tuu bo to yû yanɛ kife kì bɛ ba Joshwa gɛ̀ lode nshɛŋ yi bituŋ bì gɛ̀ bee yanɛ le, nyu Nyo wu gɛ̀ gɛɛne fwe wu kuŋe bituŋ biyu. Chuŋ yiyu mo yi nyu yanɛ too bude kife kì Nfoŋ Dabi gɛ̀ sage woŋ kfunɛ. ");
INSERT INTO ncr_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Wu yɛŋ lɛ Nyo koŋe wu chuule wu mo wu lɛgɛ lɛ Nyo bɛ̂ɛŋ wu jooŋ yeh wu nyâ wu wù Nyo wu Yakob chêe yu. ");
INSERT INTO ncr_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Gɛ̀ jiɛnyi Salamoŋ wu jôoŋ yeh yi Nyo yɛɛ. ");
INSERT INTO ncr_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Geenɛ, Tada Nyo wu le kikwɛɛ ki mwɛɛ munchii, to gɛ wu chee yeh yi jonɛ bamii le gɛ. Le gɛh yɛɛŋyɛɛŋ no muh wu ntuŋ wu Nyo wumu gɛ̀ saŋ wa lɛ Nyo jɛme lɛ, ");
INSERT INTO ncr_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Fɛwe le kala waŋ, nshɛŋ yinɛ le kitege ki bikaa biaŋ. Tada jɛmɛ lɛ yeh yi taŋlo muh jooŋ lɛ le nyume yaŋ taŋlo yi nyu nɛɛ? Noo, kijusɛ le yu kì taŋlo nshii fo le? ");
INSERT INTO ncr_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Gɛ fɛ mɛ mwɛɛ munɛ munchii gɛ?’” ");
INSERT INTO ncr_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Tifiŋ mo wu ja wu jɛmɛ lɛ, “Bɛŋ tɛɛme bikwɛɛ baaŋ, muntele mwɛna bɛ bintuŋ biɛna le lo binshushu. Bena bachiji chiji bena le gɛh yɛɛŋyɛɛŋ. Bɛŋ faŋe segechii ki bɛŋ yûge Kiyo ki Yuude le. ");
INSERT INTO ncr_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Muh wu ntuŋ wu Nyo wumu le yu wù bachiji chiji bena gɛ̀ baaŋ booŋ gɛ bikaa a wu jiŋ gɛ? Ba gɛ̀ yuuyɛ bamii ba ntuŋ ba Nyo ba gɛ̀ jɛmɛ wa lɛ Muh wu Lɛme wù Nyo wù Chaaŋ lé wu gê wu tô. Wu gɛ̀ to, bɛŋ gesɛ wu, bɛŋ ka bɛŋ yuuyɛ wu. ");
INSERT INTO ncr_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ka nyume gɛh bɛŋ ba Nyo gɛ tuŋ banchɛndaa be bo nya banchi be bɛŋ le bɛŋ faŋ ki bɛŋ bîi bo le.” ");
INSERT INTO ncr_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","No bamii ba gɛ̀ sage woŋ yu fiɛɛ fì Tifiŋ jɛmɛ, muntele bɛde lo bo, bo tu bo ŋgeji bige. ");
INSERT INTO ncr_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kiyo ki Yuude yisɛ yi Tifiŋ le, wu tu wu jiiŋe fie nyume we, wu ja wu yɛŋ n'yuu wu le wù Nyo le, wu ka wu yɛŋ Jiso wu lɛɛŋ a kibo kinchiɛɛŋ ki Nyo le. ");
INSERT INTO ncr_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tifiŋ ja wu jɛmɛ lɛ, “Bɛŋ jîŋɛ bɛŋ yɛ̂ŋ, nle n'yɛŋ fɛwe gwenyɛ, muh wù jee che le Mwamuh lɛme a kibo kinchiɛɛŋ ki Nyo le.” ");
INSERT INTO ncr_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Bo yu fiɛɛ fiyu, bo mo bo baŋ bintuŋ bɛ chiaaŋ, bo wanɛ fɛwɛɛwe, bo mo bo saa bachii bo gwe yi Tifiŋ le, ");
INSERT INTO ncr_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","bo chii wu bo bu bɛ wu a kilaantɛŋ kɛɛ le, bo gɛɛŋ bo tumɛ wu bɛ ata. Bamii ba gɛ̀ bɛɛyi jiŋ yi nsa we baayɛ bikuŋ biboo, bo nya chumu wumu wu ba gɛ̀ tɛŋe lɛ Sol le, fɛ bo tume wu. ");
INSERT INTO ncr_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","No ba gɛ̀ tume Tifiŋ bɛ ata noo, wu buunɛ lɛ, “Tada Jiso, fîh kiyo kaŋ.” ");
INSERT INTO ncr_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Wu mo wu ja wu tuŋ anyuu fɛkuu, wu jaŋ fɛwɛɛwe lɛ, “Tada, keefɛ wo jîŋɛ fiɛɛ fì befe finɛ fì bamii banɛ gee gɛ.” No wu jɛmɛ noo, wu mo wu kwe. ");
INSERT INTO ncr_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","No ba yuuyi Tifiŋ, Sol tooŋ. Gɛh abvu, bo kɛ bo nyaa ŋgɛ wu tɛɛme kintaashɛ ki bamii ba mbɛmɛ ba Yɛlusalɛm le. Ki saaŋe kichii ki bu yo, ki gɛɛŋ bimbe bi Judia bɛ Samaliya le, shɛɛ gɛh booŋ ba ntuŋ ba Jiso. ");
INSERT INTO ncr_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Bilɛŋsɛ bamu ba gɛ̀ leesɛ muntele yi Nyo le chuule to bo jo gvunɛ chi Tifiŋ bo jiiyɛ, bo bee wu wesee. ");
INSERT INTO ncr_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Geenɛ, Sol nyu fie wu gɛɛne lo bɛ kintaashɛ ki bamii ba mbɛmɛ, wu kooyi bamii ba mbɛmɛ, lɛ yeh lɛ yeh, ba bilɛŋsɛ bɛ bikɛse wu tunɛ yeh yi ncha le. ");
INSERT INTO ncr_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Bamii ba gɛ̀ saaŋe baa tu bo gɛɛne manjuu le manchii bo feeji jɛ yi Nyo. ");
INSERT INTO ncr_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filib bu fie wu gɛɛŋ nyu a kilaantɛŋ ki Samaliya le, wu tu wu feeji saaka yo kune Mbvusɛ wù Nyo gɛ̀ ka. ");
INSERT INTO ncr_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bamii ba duude yuge bo ka yɛnɛ mwɛɛ mù duunyi bvuŋga bvu Nyo mù wu gɛ̀ gee le, bo mo bo nya bintuŋ wu le chuule. ");
INSERT INTO ncr_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Biyo bì yiide gɛ̀ bude yi bamii le, bi wanɛ fɛwɛɛwe, bamii ba duude ba gɛ̀ kwe kimbe kimimia mo batɛŋɛlase bo ja we tɛ. ");
INSERT INTO ncr_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Noo, kinlaŋye kì baaŋ tu ki nyu a kilaantɛŋ kiyu le. ");
INSERT INTO ncr_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Muh mu gɛ̀ bee a kilaantɛŋ kiyu le jee che nyu lɛ Samoŋ, wu gɛ̀ shɛɛ gɛh wu duunyi nfiŋ ye kɛge lo, bamii ba Samaliya bachii yɛde jwe yune bo. Wu ka duu lɛ wu le muh wù baaŋ. ");
INSERT INTO ncr_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Bamii bachii ba a kilaantɛŋ kiyu le kɛge ba shige shige le gɛɛne ba baaŋ baaŋ le bo nya bintuŋ wu le, bo duu lɛ, “Muh wunɛ le bvuŋga bvu Nyo bvù ba tɛŋe lɛ le Bvuŋga bvù Baaŋ.” ");
INSERT INTO ncr_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bo gɛ̀ nyaa bintuŋ wu le noo, nje wu gɛ̀ shee wu duunyi nfiŋ ye kɛge lo je yì ndefe le bamii yɛde jwe yune bo. ");
INSERT INTO ncr_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Geenɛ, Filib gɛ̀ doo wu to wu feeji saaka wù joŋe kune bvunfoŋ bvu Nyo mo kune jee chi Jiso Kletu, bikɛse bɛ bilɛŋsɛ bɛɛŋ saaka wuyu le wu mo leesɛ bo a joo. ");
INSERT INTO ncr_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Samoŋ wɛɛ kibɛɛ bɛɛŋ tɛ ba leesɛ wu a joo. Wu mo wu mɛ gɛh wù nyu mbebe yi Filib le wu yɛde biŋgha bi mwɛɛ bì baaŋ baaŋ bɛ mwɛɛ mù duunyi bvuŋga bvu Nyo mù wu gɛ̀ gee jwe yune wu. ");
INSERT INTO ncr_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Booŋ ba ntuŋ ba Jiso gɛ̀ yu Yɛlusalɛm lɛ bamii ba Samaliya le bo fi wa jɛ yi Nyo, bo mo bo tuŋ Bita bɛ Joŋ fɛ bo le. ");
INSERT INTO ncr_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Bo gɛɛŋ bo bu yo, bo buunɛ fɛ bamii ba mbɛmɛ ba yo le lɛ bo kɛmɛ Kiyo ki Yuude, ");
INSERT INTO ncr_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","nje Kiyo ki Yuude gɛ̀ baaŋ a to gɛ fɛ muh lɛ bo le gɛ. Ba gɛ̀ leesɛ bo nyu a joo maa a jee chi Tada Jiso le. ");
INSERT INTO ncr_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Bita bɛ Joŋ buunɛ, bo gɛɛ chiaaŋ yi bo le, bo mo bo kɛmɛ Kiyo ki Yuude. ");
INSERT INTO ncr_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Samoŋ doo wu yɛŋ no booŋ ba ntuŋ ba Jiso gɛɛde chiaaŋ yi bamii le Kiyo ki Yuude too yi bo le, wu nya bige Bita bɛ Joŋ le, ");
INSERT INTO ncr_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","wu du lɛ, “Bɛŋ nya mɛ bɛ bvuŋga bvunɛ tɛ, fi le lɛ mo nyu yɛɛŋ wù nle ŋgɛɛ chiaaŋ yaŋ yi ye ye le, wu kɛmɛ Kiyo ki Yuude.” ");
INSERT INTO ncr_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Bita chvuu wu le lɛ, “Wo bɛ bige biuŋ biyu bɛŋ lé bɛŋ lɛ̂sɛ lo. Wo jiɛnyi nɛɛ fɛ wo kwaji lɛ taŋlo ba gu nyaa yi le yi Nyo bɛ bige? ");
INSERT INTO ncr_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Gɛ wo kɛme lo kijusɛ antɛnɛɛ a lɛme chinɛ gɛ, nje gɛ fitele fiuŋ yuude fɛ Nyo le gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kaasɛ fitele fiuŋ yi fiɛɛ fì befe fì wo goone ki wo gê finɛ le, wo buunɛ laa taŋlo Tada Nyo lɛɛshɛ baŋkwajɛ ba befe banɛ ba wo kɛme fɛ fitele le la. ");
INSERT INTO ncr_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","N'yɛde lɛ wo le wo yisɛ wa bɛ n'yɛlɛ ajii, wo tu nfwa wu kimbefɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Samoŋ chooŋɛ Bita bɛ Joŋ lɛ, “Kii, bɛŋ buunɛ fɛ Tada le lɛ keefɛ fiɛɛ fimi antɛnɛɛ a mwɛɛ mu bɛŋ jɛme munɛ kooshɛ bɛ mɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Bita bɛ Joŋ gɛ̀ mɛsɛ bo fejɛ jɛ yi Tada, bo sɛɛŋ mwɛɛ mù bo kee kune Jiso, bo ja bo tuu jiŋ Yɛlusalɛm. No bo gɛ̀ tuu jiŋ noo, bo fede bantɛ ba duude ba Samaliya le, bo feeji saaka wù joŋe wu le wù Nyo yo. ");
INSERT INTO ncr_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nchɛndaa Tada gɛ̀ ja wu jɛmɛ Filib le lɛ, “Ja wo boh je akuu akuu, wo gɛɛŋ a je yì jade Yɛlusalɛm yi fede nchvuuŋ yi gɛɛne Gasa le.” ");
INSERT INTO ncr_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filib ja wu boge. Muh wù baaŋ wumu wu Itobia gɛ̀ bee yo a je. Wu gɛ̀ bee muh wù ba bvuushɛ, nyu muh wù gɛ̀ jiiŋe fɛ kwa wu Yaa Kanda wù gɛ̀ sage woŋ wu Itobia le. Muh wɛɛ gɛ̀ ja Yɛlusalɛm a wu gɛ gɛnɛ ki wu bûunɛ Nyo yo, ");
INSERT INTO ncr_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","wu tu wu tuu jiŋ woŋ we le a koto kimu ki nyáŋ gɛ̀ chiide le, wù nyu wu shii yo, wu tɛŋe fiɛɛ a Ŋwa wù Yosaya wù muh wu ntuŋ wu Nyo gɛ̀ saŋ le. ");
INSERT INTO ncr_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Kiyo ki Yuude jɛmɛ Filib le lɛ, “Kɛŋsɛ wo gɛɛŋ mbebe koto kege le.” ");
INSERT INTO ncr_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filib legɛ wu gɛɛŋ mbebe ki le, wu yu muh wɛɛ tɛŋe a ŋwa wu Yosaya le. Wu bii wu le lɛ, “Wo tɛŋe nɛ wo yuge fiɛɛ fì wu jɛme?” ");
INSERT INTO ncr_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Wu chvuu lɛ, “Taŋlo n'yu nɛɛ njɛ muh najɛ mɛne sɛŋ?” Wu jɛmɛ lɛ Filib bɛɛŋ bo shii a koto le. ");
INSERT INTO ncr_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Kijusɛ kì wu gɛ̀ tɛŋe fo a Ŋwa wɛɛ le gɛ̀ jɛme lɛ, “Wu gɛ̀ bee njɛ shoŋ yì ba gɛɛne ki ba sɛɛ, ka nyu njɛ mwa shoŋ sege ba muu yvú ye ye le, yi beede gɛ. Le gɛh tɛ noo no wù gɛ̀ bee jwe wu chile. ");
INSERT INTO ncr_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ba gɛ̀ choosɛ wu, ba faŋ ki ba sa nsa we chuule. Le yɛɛŋ wu yu wu to wu jɛme kune booŋ be, a ba suuŋ wa kinche ke fɛkuu fɛnɛ?” ");
INSERT INTO ncr_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Muh wù baaŋ wɛɛ mo wu lɛgɛ Filib wu jɛmɛ lɛ, “Kii wo, gɛ̀ sɛɛŋ mɛ, muh wu ntuŋ wu Nyo wunɛ, wu jɛme nyu kune yɛɛŋ? Wu jɛme kune kikwɛɛ ke noo kune muh mu le?” ");
INSERT INTO ncr_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filib mo wu kɛ gɛh bɛ kijusɛ kiyu a Ŋwa wɛɛ le, wu tu wu naji saaka wù joŋe wu kune Jiso. ");
INSERT INTO ncr_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Bɛ wu tu bo gɛɛne gɛh a je, bo gɛɛŋ bo bu fɛ kijusɛ kimi le joo nyu fo. Muh wù baaŋ wɛɛ jɛmɛ lɛ, “Bîjɛ yɛ̂ŋ, yinɛ le joo fɛnɛ, taŋlo ŋka nfaŋ la lɛ, keefɛ wo lêe mɛ a joo?”  ");
INSERT INTO ncr_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filib chvuu wu le lɛ, “Wo fɛnɛ le wo bɛɛŋ Jiso Kletu le bɛ fitele fiuŋ fichii, tu nle nlee wo a joo.” Wu chvuu lɛ, “Nle mbɛɛŋ lɛ Jiso Kletu le Mwa Nyo.” ");
INSERT INTO ncr_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Muh wù baaŋ wɛɛ mo wu du lɛ bo lɛɛŋ bɛ koto. Bɛ Filib shii, bo lee bo gɛɛŋ a joo, Filib leesɛ wu a joo. ");
INSERT INTO ncr_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","No bo gɛ̀ bude a joo, Kiyo ki Tada chufɛ Filib fo, muh wù baaŋ wɛɛ gɛ ka wu yɛŋ wu le gɛ. Geenɛ, wu tu wu gɛɛne gɛh fie wu laŋeye. ");
INSERT INTO ncr_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filib ja wu bunɛ nyu wa Asotu, wu ja wu tu wu gɛɛne, wu fede a bilaantɛŋ le bichii, wu feeji saaka wù joŋe wu Nyo, wu gɛɛŋ wu bu a kilaantɛŋ ki Kasalia le. ");
INSERT INTO ncr_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Gɛ̀ bee kife kɛɛ le, Sol baaŋ gɛh wu fuge, wu kaji bamii ba ŋgoo ba Tada lɛ wu lé wu yûuyɛ bo. Wu mo wu gɛɛŋ fɛ kikwɛɛ ki bachiji kintanyɛ le, ");
INSERT INTO ncr_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","wu lɛgɛ lɛ wu nya wu baŋwa wu gɛɛŋ bɛ bo yéh yi buunɛ yi Damasku le, ba duunyi lɛ wu yɛŋ lo, no bamii ba yo bo bii Je yi Tada le mo nyu bikɛse, mo nyu bilɛŋsɛ, wu kooyɛ bo wu kaaŋ, wu to bɛ bo Yɛlusalɛm. ");
INSERT INTO ncr_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Wu nya, Sol ja wu gɛɛne Damasku, wu doo wu fɛɛse a kilaantɛŋ kɛɛ le, n'yuu wumu ja wu lalɛ fɛwe, wu shii ye ye le. ");
INSERT INTO ncr_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Wu gwe fɛkuu, wu yu jɛ jɛmɛ wu le lɛ, “Sol, Sol, wo boone bikaa a mɛ jiŋ nɛ nje la?” ");
INSERT INTO ncr_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Wu biih lɛ, “Tada, le wo wù yɛɛŋ?” Jɛ yiyu chvuu lɛ, “Le mɛ wù Jiso, le mɛ wù wo boone bikaa a mɛ jiŋ. ");
INSERT INTO ncr_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Yi mɛɛse le, ja we, wo lee wo gɛɛŋ a laantɛŋ, ba sɛɛŋ wo fiɛɛ fì wo kɛme ki wo gêe.” ");
INSERT INTO ncr_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Bamii ba gɛ̀ jiɛnyi bɛ ba Sol lɛɛŋ fo bo ŋgɛsɛ, no bo gɛ̀ yuge jɛ yiyu bo yɛde gɛ muh le gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol gɛ̀ ja we fɛkuu fɛɛ, lɛ wu doo wu gwenyɛ ajii, wu ka yɛde gɛ mwɛɛ le gɛ. Bo jijɛ wu yi kibo le, bo tu bo chiɛɛji wu bo gɛɛne bɛ wu Damasku. ");
INSERT INTO ncr_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Wu gɛɛŋ wu tu wù nyu yi aju le atade wu yɛde gɛ mwɛɛ le gɛ. Wu gɛ̀ bee noo, wu jii gɛ fiɛɛ gɛ, wu muu gɛ tɛ fiɛɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Muh mbɛmɛ wumu gɛ̀ bee Damasku ayu jee che nyu lɛ Anania. Tada Jiso ja wu tɛɛŋ wu a fiɛɛ le njɛ kifilɛ le lɛ, “Anania.” Wu bɛɛŋ lɛ, “Tada, nɛ mɛ wunɛ fɛnɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Tada jɛmɛ wu le lɛ, “Ja, wo gɛ̂ɛne a je yì ba tɛŋe lɛ Chaaŋ le, wo doo wo bu fɛ yeh yi Juda le, wo bii muh mu wu Tasu wu ba tɛŋe lɛ Sol. Yegɛ yu, wu le fo wu buune, ");
INSERT INTO ncr_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","wu be wu yɛŋ wa muh mu a fiɛɛ le njɛ kifilɛ ba tɛŋe lɛ Anania, wu to wu gɛɛ chiaaŋ ye ye le, lɛ wu kaasɛ wu yɛde mwɛɛ le.” ");
INSERT INTO ncr_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Geenɛ, Anania jɛmɛ lɛ, “Tada, nle n'yu wa a bamii ba duude le kune muh wunɛ, no wù gee mwɛɛ mù mbefe fɛ bamii ba le ba Nyo le, ba Yɛlusalɛm le. ");
INSERT INTO ncr_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Wu too nɛ, wù nyu wu fi bvuŋga a bachiji bintanyɛ ba baaŋ baaŋ le, lɛ wu to wu kooyɛ bamii bachii yanɛ bo buunɛ bo tɛŋe jee chuŋ.” ");
INSERT INTO ncr_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Tada chvuu wu le lɛ, “Gɛnɛ gɛh lo. Nle ncha wa muh wunɛ, muh waŋ wu lɛme le, lɛ wu fêeji jee chaŋ bamii ba le gɛ Bajuu le gɛ, bɛ banfoŋ baboo, mo bamii ba Ishwala le. ");
INSERT INTO ncr_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mɛ kibɛɛ nlé ndunyɛ wu no wù kɛme ki wu yɛ̂ŋ ŋgɛ nje jee chaŋ.” ");
INSERT INTO ncr_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Noo, Anania mo wu gɛɛŋ, wu lee yeh yɛɛ le, wu gɛɛ chiaaŋ ye yi Sol le, wu tɛɛŋ lɛ, “Sol mwa bwaaŋ, tuŋ Tada Jiso mɛ. Le wu wù Jiso wù wo chi yɛŋ a je sege wo chi too yanɛ. Wu tuŋ mɛ lɛ, nto ŋge wo kaasɛ wo yɛ̂de mwɛɛ le, lɛ Kiyo ki Yuude to ki yisɛ ye yo le.” ");
INSERT INTO ncr_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Gɛh no wu jɛmɛ noo, fiɛɛ fimi njɛ bibagɛ mo bi bu a Sol jii bi gwe fɛkuu, wu mo wu tu wu yɛde mwɛɛ le. Wu ja we, bo mo bo leesɛ wu a joo. ");
INSERT INTO ncr_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Wu gɛ̀ ji mwɛɛ, bvuŋga kaasɛ bvu tu ye ye le. Sol gɛ̀ che Damasku bɛ ŋgoo yi bamii ba mbɛmɛ, yi aju le shige, ");
INSERT INTO ncr_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","wu mo wu kɛ lo kimimia wu tu wu jiɛnyi yéh yi buunɛ le, wu feeji lɛ, “Jiso le Mwa Nyo.” ");
INSERT INTO ncr_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Bamii bachii ba gɛ̀ yuge bo tu bo maŋe lɛ, “Wunɛ le gɛ muh wù chi jiɛnyi wu gɛɛne lo bɛ bamii ba buune bo tɛŋe jee chinɛ Yɛlusalɛm gɛ? Gɛ̀ wu to yanɛ nɛ ki wu kôoyi ba le yanɛ wu kaasɛ wu gɛɛne bɛ bo, wu nyaa chiaaŋ yi bachiji kintanyɛ ba baaŋ baaŋ le gɛ?” ");
INSERT INTO ncr_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sol tu wu feeji gɛh fiɛɛ kune Jiso fi tɛɛme lo, wu duunyi lɛ Jiso le Mbvusɛ wù Nyo gɛ̀ ka. Bajuu ba gɛ̀ bee Damasku bo ma lo fiɛɛ fì taŋlo bo chvuu wu le. ");
INSERT INTO ncr_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Aju gɛ̀ doo wo fe wesee, Bajuu bayu shii, bo chu ntaŋ ki bo yuuyɛ Sol. ");
INSERT INTO ncr_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Bo tu bo shiide, bo chiɛɛne wu jwe wu kitaŋ ki Damasku le, lɛ wu doo wu fede, kɛnɛ nyu antaŋ kɛnɛ nyu fɛnshɛ, ki bo yuuyɛ wu. Geenɛ, Sol kɛɛ ntaŋ wuboo. ");
INSERT INTO ncr_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Bamii be ba ŋgoo gɛ̀ jo wu antaŋ, bo leesɛ a ŋkaa le, bo bvusɛ wu fɛ nto wu kitaŋ le, bo shiishɛ wu fɛkuu wa akfuuŋ. ");
INSERT INTO ncr_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol tu jiŋ Yɛlusalɛm, wu doo wu goone ki wu tâashɛ bɛ ŋgoo yi bamii ba mbɛmɛ, bo tu bo faane lo wu, nje gɛ bo gɛ̀ bɛmɛ chuule lɛ wu le muh wuboo wu ŋgoo gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Geenɛ, Banaba jo wu, bɛ wu gɛɛŋ fɛ booŋ ba ntuŋ ba Jiso le. Wu sɛɛŋ bo le no Sol gɛ̀ yɛŋ Tada le a je Tada jɛmɛ wu le, wu mo wu sɛɛŋ bo no wu gɛ̀ feeji kune Jiso Damasku wu faane gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Noo, Sol mo wu tu wù nyu bɛ bo wu jiɛnyi manjuu le manchii Yɛlusalɛm, wu feeji kune Jiso, wu faane gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Wu gɛ̀ jɛme tɛ Bajuu ba gɛ̀ jɛme jɛ yi Glek le, wu tɛɛnyi kintɛɛnyɛ bɛ bo, bo ja bo goone ki bo yuuyɛ wu. ");
INSERT INTO ncr_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Bamii ba mbɛmɛ kɛɛ lɛ bo goone ki bo yuuyɛ wu, bo mo bo jo wu bo boh bɛ wu a kilaantɛŋ ki Kasalia le, bo chiiŋsɛ wu gɛɛŋ Tasu. ");
INSERT INTO ncr_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Yi kife kinɛ le, kintaashɛ ki bamii ba mbɛmɛ fufɛ shɛ́ŋ yi ŋgɛ le a bimbe bi woŋ wu Judia bɛ Galalee mo Samaliya le. Kiyo ki Yuude ge kintaashɛ kiyu ki tɛmɛ, ki mo ki tôone ŋgoo yɛɛ yi kuu. Bo tu bo chee, bo ŋgvuune gɛh nyu Tada. ");
INSERT INTO ncr_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Bita tu wu jiɛnyi, wu gɛɛne fɛ bamii ba le ba Nyo le manjuu le manchii, wu jiɛnyɛ wu gɛɛŋ wu bu fɛ bamii ba Lida le. ");
INSERT INTO ncr_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","No wù gɛ̀ bee yo, wu yɛŋ muh mu le wu kwe kimbe kimimia, jee che nyu Ania wù nyu wu ge wa fɛnta biluŋ nyaaŋ. ");
INSERT INTO ncr_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","No Bita yɛŋ wu le, wu tɛɛŋ lɛ, “Ania, Jiso Kletu fɛ wa wo. Ja we wo kɛnyɛ kinta kuŋ.” Kimimia Ania mo wu ja we. ");
INSERT INTO ncr_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Bamii ba Lida, mo ba yi bale yi Shaloŋ le, yichii mo bo yɛŋ no muh wuyu le wu tɛmɛ wa, bo leesɛ muntele yi Tada Jiso le. ");
INSERT INTO ncr_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Gɛ bee kwɛse wumu nyu a kilaantɛŋ ki Joba le, nyu muh wu mbɛmɛ, jee che nyume Tabita, chì le a jɛ yi Glek le lɛ Doka. Wu gɛ̀ gee mwɛɛ mù njoŋe segechii, wu fii bamii ba fuude. ");
INSERT INTO ncr_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Lɛ nyume aju ayu le, kwɛse wuyu gwe kinchɛŋ, wu mo wu kwe. Bo chugɛ gvunɛ che, bo bɛɛŋ bo gɛɛ kimbe ki yeh ki awe le. ");
INSERT INTO ncr_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","No Joba gɛ̀ bee mbebe yi Lida le, ŋgoo yi bamii ba mbɛmɛ yu lɛ Bita le Lida, bo mo bo tuŋ bilɛŋsɛ bafɛɛ fɛ wu le. Bo gɛɛŋ bo lɛgɛ wu, lɛ kii wu, lɛ wu to gɛh bikaa le. ");
INSERT INTO ncr_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Bita mo wu ja gɛh noo bɛ bo gɛɛne. Wu gɛɛŋ wu bu fo, bo jo wu bo bɛɛŋ bɛ wu kimbe ki yeh yi awe kɛɛ le. Bakwɛŋkfu ba yo bachii tuŋ kiŋgaŋ fo bo tu bo beede, bo duunyi njú yì Doka gɛ̀ fɛde sege wu gɛ̀ baaŋ yu. ");
INSERT INTO ncr_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Bita bvusɛ bo akfuuŋ bachii, wu tuŋ anyuu fɛkuu wu buunɛ, wu kaasɛ ye wu jɛmɛ gvunɛ chiyu le lɛ, “Tabita ja we.” Wu mo wu gwenyɛ ajii, wu bijɛ Bita, wu mo wu ja wu shii we. ");
INSERT INTO ncr_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Bita jijɛ wu yi kibo le, wu lɛɛŋ we. Wu kaasɛ wu tɛɛŋ bamii ba le ba Nyo bɛ bakwɛŋkfu baa, wu dunyɛ wu bo le, a wu kaasɛ wa wu tu yu. ");
INSERT INTO ncr_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Saaka wuyu saaŋe wu gɛɛŋ Joba achii. Bamii ba duude leesɛ muntele yi Tada le. ");
INSERT INTO ncr_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Bita tu wù nyu Joba yi aju a duude le, wu chee bɛ muh mu wù gɛ̀ kɛɛnyi jé, jee che nyu lɛ Samoŋ. ");
INSERT INTO ncr_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Muh mu gɛ̀ bee a kilaantɛŋ ki Kasalia le ba tɛŋe wu lɛ Konɛyu, nyu kikwɛɛ ki ŋgoo yimi yi bamii ba nchi ba Lum, yì ba gɛ̀ tɛŋe lɛ yi Itali. ");
INSERT INTO ncr_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Wu gɛ̀ bee muh wù bamii bachii ba a wu yeh gɛ̀ bee bo leesɛ muntele yi Nyo le chuule. Wu ŋgvuune, wu buune Nyo segechii, wu nyaa nnya ye chuule. Bajuu ba gɛ̀ fuude le. ");
INSERT INTO ncr_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Gɛ̀ bee juu chimi njɛ juu bikaa bitɛde fɛnshɛ, fiɛɛ, njɛ kifilɛ ja fi to fɛ wu le, wu jagɛ wu yɛŋ nchɛndaa wu Nyo le chuule a fiɛɛ fiyu le. Nchɛndaa wɛɛ gɛ̀ to wu lee wu tɛɛŋ wu lɛ, “Konɛyu.” ");
INSERT INTO ncr_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Konɛyu faaŋ, wu noŋ ajii ye ye le wu biih wu le lɛ, “Chiji kikwɛɛ, le la?” Nchɛndaa wɛɛ chvuu lɛ, “Nyo le wu yu wa buunɛ chuŋ, wu ka wu yɛŋ nnya yi wo nyaa bamii ba fuude le, wu kwajɛ wo. ");
INSERT INTO ncr_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Yi mɛɛse le, tuŋ bamii Joba bo gɛɛŋ bo tɛɛŋ muh mu wù jee che le Samoŋ, chimi lɛ Bita. ");
INSERT INTO ncr_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Wu chee bɛ Samoŋ wu kɛɛnyi jé wu la che le mbebe joo yì baaŋ le.” ");
INSERT INTO ncr_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","No nchɛndaa wu Nyo wɛɛ jɛme noo wu mo wu ja. Konɛyu shɛɛ wu tɛɛŋ bamii be ba lɛme bafɛɛ, wu tɛɛŋ tɛ muh nchi wumu wù gɛ̀ chiɛɛne wu, gɛ̀ bee muh wù gɛ̀ leesɛ tɛ fitele yi Nyo le. ");
INSERT INTO ncr_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Lɛ bo to, wu sɛɛŋ fiɛɛ fichii fì be kooshɛ bɛ wu bo le, wu mo wu tuŋ bo Joba. ");
INSERT INTO ncr_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Akfuuŋ bu ayuu, gɛ̀ bee njɛ fɛnshɛ antɛnɛɛ, bo fɛɛse wa a kilaantɛŋ kiyu le. Bita ja wu bɛɛŋ a yeh we ki wu bûunɛ. ");
INSERT INTO ncr_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Jɛŋ kɛ yi yuu wu, wu mo wu goone ki wu jî mwɛɛ, ba baaŋ ba dɛɛde lo mwɛɛ munjile. Fiɛɛ njɛ kifilɛ ja fi to fɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Wu yɛŋ a fiɛɛ fiyu le, kibvulɛ gwenyɛ, fiɛɛ fimi shiide fɛwe njɛ kikwɛɛ ki nju, ba jiji yi abu le ana. ");
INSERT INTO ncr_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Chikfuu chi nyáŋ yichii, yì jiɛnyi nshɛŋ le, bɛ yì loone, mo munyii mù fuune we, nyu yi nju yiyu le. ");
INSERT INTO ncr_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Jɛ ja yi jɛmɛ wu le lɛ, “Bita, ja we wo yuuyɛ wo ji.” ");
INSERT INTO ncr_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Bita chvuu lɛ, “Tada, gɛ taŋlo mɛ moŋ gɛ, nje ŋgɛ mbaaŋ aji gɛ wa fiɛɛ fì nchɛ kɛnɛ fiɛɛ fì le njɛ fi yuude gɛ sɛŋ.” ");
INSERT INTO ncr_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Jɛ yiyu ka yi jɛmɛ wu le lɛ, “Keefɛ wo nyîɛŋse fiɛɛ fì Nyo le wu fɛ wa fi yuude gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Fi kooshɛ noo bu kiŋgane kintɛde, bo mo bo kaasɛ bo bɛɛŋsɛ fiɛɛ fiyu we. ");
INSERT INTO ncr_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Fiɛɛ fiyu fì gɛ̀ to njɛ kifilɛ fi fuuŋsɛ Bita wu tu wu maŋe laa fi duunyi nyu la lɛ. Gɛh segeyu bamii ba Konɛyu gɛ̀ tuŋ baa to wa bo biide fɛ la chi Samoŋ wù gɛ̀ kɛɛnyi jé le fo, bo tu bo lɛme jwe wu kitaŋ le, ");
INSERT INTO ncr_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","bo tɛŋe, bo biide lɛ, “Muh wu jiɛnyɛ wumu le fɛnɛ jee che nyu lɛ Samoŋ Bita?” ");
INSERT INTO ncr_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","No Bita gɛ̀ baaŋ wu kwaji kune fiɛɛ fiyu fì gɛ̀ to fɛ wu le, Kiyo ki Yuude ja ki jɛmɛ wu le lɛ, “Bîjɛ yɛ̂ŋ, bamii batɛde goone wo. ");
INSERT INTO ncr_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ja we wo boh bena bo gɛɛne kikaa kimimia. Keefɛ wo chîide lo ye gɛ, tuŋ mɛ bo.” ");
INSERT INTO ncr_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Noo, Bita mo wu ja wu boh, wu jɛmɛ bamii bayu le lɛ, “Le mɛ wù bɛŋ goone. Bɛŋ to lɛ la?” ");
INSERT INTO ncr_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bo chvuu lɛ, “Konɛyu wu le kikwɛɛ ki ŋgoo yimi yi bamii ba nchi ba Lum le wu tuŋ bee. Wu le muh wù chaaŋ, wu faane Nyo, Bajuu bachii ŋgvuune wu. Nchɛndaa wu Nyo wù yuude wumu chi wu jɛmɛ wu le lɛ wu chiiŋsɛ ntuŋ lɛ wo to a wu yeh, wu yu fiɛɛ fì wo lé wo jɛ̂me wu le.” ");
INSERT INTO ncr_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","No bo chvuse noo, Bita mo wu jɛmɛ bo lee bɛ bo che. Akfuuŋ bu ayuu, wu ja bɛ bo mo bo gɛɛne. Bamii ba mbɛmɛ bamu ba Joba bi wu le. ");
INSERT INTO ncr_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Bo jiɛnyɛ bo che, bvu bu bvu yuu bo fɛsɛ Kasalia. Konɛyu bɛ bamii be ba kfuu mo nsáa ye yi shɛ́ŋ yi wu gɛ̀ tɛŋɛ gɛ̀ bee bo chiɛɛne wa bo. ");
INSERT INTO ncr_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","No Bita gɛ̀ lese wu gɛɛne yeh, bɛ Konɛyu tasɛ. Konɛyu gwe a wu jii wu ŋgvuuŋ wu. ");
INSERT INTO ncr_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Geenɛ, Bita chiaasɛ wu we wu jɛmɛ lɛ, “Ja we, nle gɛh tɛ fiaŋ muh wu wuŋ njɛ wo.” ");
INSERT INTO ncr_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Wu tu wu jɛme bɛ Konɛyu bo lese bo gɛɛne yeh, bo doo bo lee, bo yɛŋ bamii so lo yu. ");
INSERT INTO ncr_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Wu jɛmɛ bo le lɛ, “Bɛŋ kee chuule lɛ nchi wese baaŋ bɛɛŋ gɛ lɛ muh wu Bajuu lade jigɛ wu ka taashi nsaŋ bɛ muh wu le gɛ muh wu Bajuu gɛ. Geenɛ, Nyo le wu dunyɛ mɛne lɛ gɛ ŋkɛme ki ntɛŋe muh mu nduu lɛ wu le muh wù nchɛ kɛnɛ lɛ gɛ wu yuude gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Noo, bɛŋ chi doo bɛŋ chiiŋsɛ ntuŋ lɛ nto, mɛ mo nto, mbaaŋ tɛɛnyɛ gɛ. Mɛ mo mbiide bɛŋ le laa bɛŋ tɛŋe mɛ lɛ la lɛ?” ");
INSERT INTO ncr_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Konɛyu chvuu lɛ, “Abɛŋ le wa aju ana no nchi mbee a mɛ yeh njɛ kife ki mɛɛse le juu bikaa bitɛde fɛnshɛ mbuune. Muh mu jagɛ wu bu a mɛ fwe wù nyu wu noŋ njú yi lale ye le. ");
INSERT INTO ncr_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Wu jɛmɛ mɛne lɛ, ‘Konɛyu, Nyo le wu yu wa buunɛ chuŋ wu ka wu yɛŋ nnya yi wo nyaa bamii ba fuude le, wu kwajɛ wo. ");
INSERT INTO ncr_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Noo, tuŋ bamii Joba bo gɛɛŋ bo tɛɛŋ muh mu wù jee che le Samoŋ, chimi lɛ Bita. Wu chee bɛ Samoŋ wù kɛɛnyi jé wù la che le mbebe joo yì baaŋ le.’ ");
INSERT INTO ncr_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kimimia noo, nchi mo nchiiŋsɛ ntuŋ lɛ wo to. Wo to nɛ, fi joŋ baaŋ. Bee mo be nyume fɛnɛ a Nyo jii ki bee yu fiɛɛ fì Tada tuŋ wo lɛ wo to wo jɛmɛ bee le.” ");
INSERT INTO ncr_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Bita mo wu kɛ wu tu wu jɛme wu duu lɛ, “Yi nchiɛɛŋ le, nle n'yɛŋ lɛ gɛh Nyo duunyi yeye yeye gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Muh wuchii wù faane wu, wu ka gee fiɛɛ fì chuule le, wu fii wu wu jiiŋe gɛ laa mwɛdɛ bu faane la. ");
INSERT INTO ncr_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Bɛŋ kee ntuŋ wu Nyo gɛ̀ chiiŋsɛ fɛ bamii ba Ishwala le, wu feeji saaka wù joŋe lɛ Jiso Kletu gɛ̀ to wu lɛ nyiɛgee taŋlo wù nyu antɛnɛɛ a Nyo bɛ bamii. Jiso Kletu wunɛ le Kikwɛɛ ki bamii bachii. ");
INSERT INTO ncr_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Bɛŋ kee fiɛɛ fì gɛ̀ kooshɛ woŋ wu Judia le wuchii, fi gɛ̀ kɛ Galalee ajiŋ a kife kì Joŋ gɛ̀ feeji wu leese bamii a joo. ");
INSERT INTO ncr_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Bɛŋ kee tɛ no Nyo gɛ̀ chvu lo Kiyo ki Yuude yi Jiso wu Nasalɛ le, wu ka wu nya bvuŋga wu le, wu tu wu nyume bɛ wu. No Nyo gɛ̀ bee bɛ wu, wu tu wu jiɛnyi manjuu le manchii wù gee lɛme chì joŋe wu ka fɛde bamii ba debele nyuse. ");
INSERT INTO ncr_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Le bee ba gɛ̀ yɛŋ mwɛɛ mù wu gɛ̀ gee woŋ wu Bajuu le wuchii, bɛ mù wu gɛ̀ gee a kilaantɛŋ ki Yɛlusalɛm le. Ba gɛ̀ ta wu yi kintaaŋ le wu kwe. ");
INSERT INTO ncr_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Geenɛ, lɛ doo nyu aju atade, Nyo bvusɛ wu yi kwe le, wu ge bamii yɛŋ wu le. ");
INSERT INTO ncr_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Gɛ nyu bamii bachii ba gɛ̀ yɛŋ wu le gɛ. Gɛ̀ yɛŋ gɛh bee ba Nyo gɛ̀ cha lɛ bee feeji kune Jiso. Bee gɛ̀ jii mwɛɛ bee ka muu besa ba Jiso sege wu gɛ̀ bu yi kwe le. ");
INSERT INTO ncr_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Wu jɛmɛ lɛ bee lé be gê be fêeji jɛ yi Nyo bamii le, bee ka sɛŋe bo le lɛ le wu wù Nyo le wu baa lɛ le wu wù ge wu sa bamii ba baaŋ yu mo ba kweeyɛ wa. ");
INSERT INTO ncr_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Jiso wunɛ le wu wù bamii ba ntuŋ wu Nyo bachii gɛ̀ jɛme kune wu lɛ le yɛɛŋ wu lé wu gɛ̂ɛ fitele fie yi ye ye le, Nyo le wu lɛɛshɛ bimbefɛ bie fede yi jee che le.” ");
INSERT INTO ncr_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Gɛh no Bita gɛ̀ baaŋ wu jɛme mwɛɛ munɛ, Kiyo ki Yuude ja ki shii, ki to yi muh le wuchii wù gɛ yuge njɛmɛ wɛɛ le. ");
INSERT INTO ncr_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","De yuŋ bamii ba mbɛmɛ ba le Bajuu ba gɛ̀ bi Bita le, no bo gɛ̀ yɛŋ Nyo nya tɛ nnya ye yì le Kiyo ki Yuude bamii ba le gɛ Bajuu gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Bajuu baa tu bo yuge no bo jɛme jɛ́ yì bo kee gɛ, bo yuuse Nyo. Bita mo wu biih lɛ, ");
INSERT INTO ncr_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“No Kiyo ki Yuude le ki to wa yi bamii banɛ le gɛh yɛɛŋyɛɛŋ no ki gɛ̀ to yi ye yese besabɛŋ le, taŋlo muh ka wu faŋ lɛ keefɛ ba lêesɛ bo a joo gɛ?” ");
INSERT INTO ncr_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","No Bita bile noo, wu mo wu jɛmɛ lɛ ba leesɛ bo a joo a jee chi Jiso Kletu le. Ajiŋ ayu le, bamii bayu lɛgɛ lɛ wu che bɛ bo yi aju le shige fɛ wu ja. ");
INSERT INTO ncr_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Booŋ ba ntuŋ ba Jiso mo bamii ba mbɛmɛ ba Judia bachii gɛ̀ yu lɛ bamii ba le gɛ Bajuu gɛ le bo fi wa tɛ jɛ yi Nyo. ");
INSERT INTO ncr_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Bita gɛ̀ doo wu kaasɛ wu bɛɛŋ Yɛlusalɛm, bamii ba mbɛmɛ bamu tu bo sage wu. Bamii banɛ le ba gɛ̀ lɛme gɛh lɛ ba kɛme ki ba chvuu muh wu le gɛ muh Bajuu gɛ yeh, fɛ mwɛdɛ nyu muh wu Nyo. ");
INSERT INTO ncr_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Bo tu bo sage wu bo biide lɛ, “Wo chi jiɛnyi nɛɛ fɛ wo la jigɛ a bamii ba baaŋ binshushu le, wo ka jii mwɛɛ bena bo?” ");
INSERT INTO ncr_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Bita mo wu najɛ chuule fiɛɛ fichii fì gɛ̀ kooshɛ, wu jɛmɛ bo le lɛ, ");
INSERT INTO ncr_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ŋgɛ mbee a kilaantɛŋ kì Joba le mbuune, fiɛɛ njɛ kifilɛ ja fi to fɛ mɛne. N'yɛŋ a fiɛɛ fiyu le, fiɛɛ fimi shiide fɛwe njɛ kikwɛɛ ki nju, ba jiji yi abu le ana. Fi shii, fi lɛɛŋ a mɛ jii. ");
INSERT INTO ncr_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ndoo mbijɛ yo, n'yɛŋ nyáŋ le chikfuu le chikfuu le, yimi nyume yi fɛ yeh le, yimi nyume yi nchvuuŋ bɛ yì loone, mo munyii mù fuune we. ");
INSERT INTO ncr_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nja n'yu jɛ jɛmɛ mɛne lɛ, ‘Bita, ja we wo yuuyɛ wo ji.’ ");
INSERT INTO ncr_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nchvuu lɛ, ‘Tada, gɛ taŋlo mɛ moŋ gɛ. Gɛ fiɛɛ fì nchɛ kɛnɛ fi yuude gɛ, gɛ lee wa a mɛ mu gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Jɛ yiyu ka yi jɛmɛ we lɛ, ‘Keefɛ wo nyîɛŋse fiɛɛ fì Nyo le wu fɛ wa fi yuude gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Fi kooshɛ noo bu kiŋgane kintɛde bo mo bo kaasɛ bo chii fiɛɛ fiyu fichii fi bɛɛŋ we. ");
INSERT INTO ncr_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Gɛh segeyu, bamii batɛde fɛsɛ fɛ yeh yì ŋgɛ̀ nchee fo, bo ja Kasalia, ba tuŋ lɛ bo to bo tɛɛŋ mɛ. ");
INSERT INTO ncr_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Kiyo ki Yuude jɛmɛ mɛne lɛ keefɛ mɛ nyiɛŋse ki ŋgɛɛŋ besa bamii bayu gɛ. Booŋ ba bwee besa ba Joba ba bvusoo banɛ bi mɛne, besa bo bachii gɛɛŋ be lee a muh wuyu yeh. ");
INSERT INTO ncr_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","No bee lese, wu sɛɛŋ bee no wu gɛ̀ yɛŋ nchɛndaa wu Nyo le a wu yeh, wu jɛmɛ lɛ ntuŋ muh Joba wu gɛɛŋ wu tɛɛŋ muh mu wù ba tɛŋe lɛ Samoŋ Bita. ");
INSERT INTO ncr_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Muh wɛɛ lé wu gê wu tô bɛ saaka wu bamii bachii ba le a wu yeh lé bo gê bo bônɛ yu. ");
INSERT INTO ncr_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ndoo ŋkɛ lɛ njɛme, Kiyo ki Yuude ja ki shii yi bamii bayu le gɛh yɛɛŋyɛɛŋ no ki gɛ̀ to yi ye yese besabɛŋ le fɛŋkɛɛ. ");
INSERT INTO ncr_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","N'yɛŋ noo, mɛ mo ŋkwajɛ fiɛɛ fì Tada gɛ̀ jɛmɛ lɛ, ‘Joŋ gɛ leese bamii a joo, geenɛ, Nyo lé wu gê wu lêesɛ bɛŋ nyu yi Kiyo ki Yuude le.’ ");
INSERT INTO ncr_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","No Nyo gɛ̀ nya bamii bayu bɛ nnya nyu gɛh yì wu gɛ̀ nya besabɛŋ le sege besabɛŋ gɛ̀ leesɛ muntele yi Tada Jiso Kletu le, nle yɛɛŋ wù nfaŋ fiɛɛ fì gee Nyo?” ");
INSERT INTO ncr_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Bamii bayu yu no Bita jɛme noo, bo gɛ ka bo sage wu gɛ. Bo mo bo ja bo tumɛ nyu maŋkuŋ ma Nyo bo duu lɛ, “Finɛ le noo, tu Nyo le wu nya wa tɛ je bamii ba le gɛ Bajuu gɛ, lɛ bo kusɛ muntele muboo ki bo kɛme kinche kì kage gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Bamii ba gɛ̀ saaŋe no ŋgɛ kɛ, sege ba gɛ̀ yuuyɛ Tifiŋ bo gɛɛŋ manjuu le manjuu le, bo gɛɛŋ bo bu Fonishia, bamu gɛɛŋ Sablu, bamu Antiok. No bo gɛnɛ noo, bo tu bo feeji jɛ yi Nyo nyu gɛh Bajuu le maa. ");
INSERT INTO ncr_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Geenɛ, bamii ba mbɛmɛ bamu ba gɛ̀ ja Sablu bɛ Sɛliŋ, bo gɛɛŋ Antiok bo tu bo feeji tɛ saaka wù joŋe wù kune Tada Jiso fɛ bamii ba le gɛ Bajuu le gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Yi bvuŋga bvu Tada Nyo le, bo ge bamii ba duude leesɛ muntele yi Tada Jiso le, bo kusɛ bo tu bɛ wu. ");
INSERT INTO ncr_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Saaka wuyu wunɛ lee bintuŋ bi kintaashɛ ki bamii ba mbɛmɛ le Yɛlusalɛm. Bo mo bo tuŋ Banaba Antiok ayu. ");
INSERT INTO ncr_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Wu gɛɛŋ wu bu yo, wu yɛŋ no Nyo le wu dunyɛ fitele fì joŋe fɛ bo le, wu yu njoŋ, wu mo wu teefe bo no bo bîi Tada le bɛ muntele muboo munchii. ");
INSERT INTO ncr_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banaba wunɛ gɛ̀ bee muh wù joŋe, wu yisɛ bɛ Kiyo ki Yuude wu ka kɛme mbɛmɛ chuule. Noo, wu ge bamii ba duude ba yo lee muntele yi Tada le. ");
INSERT INTO ncr_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Banaba gɛ̀ ja wu gɛɛŋ Tasu ki wu gôoŋ Sol. ");
INSERT INTO ncr_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Wu gɛ̀ gooŋ wu yɛŋ wu le, wu jo wu bɛ wu tu jiŋ Antiok. Bɛ wu tu bo nyume yo yi kiluŋ le kichile bɛ kintaashɛ ki bamii ba mbɛmɛ, bo yɛyi bamii ba duude. Le Antiok ayu a ba gɛ̀ kɛ ba tɛŋe ŋgoo yi bamii ba mbɛmɛ lɛ bamii ba Kletu. ");
INSERT INTO ncr_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Lɛ nyume gɛh kife kiyu le, bamii bamu ba gɛ̀ sɛŋe mwɛɛ mù bo yuge Nyo jɛme, ja Yɛlusalɛm bo boh bo gɛɛŋ Antiok ayu. ");
INSERT INTO ncr_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Kiyo ki Yuude ge muh mu bo le wù jee che gɛ̀ bee Agabu ki wu jâ wu lɛɛŋ we, wu tee lɛ jɛŋ yì tɛɛme lé yi gê yi kôo bituŋ bichii. Jɛŋ yiyu gɛ̀ bee yi jiɛnyɛ yi koo kife kì Klawdiu gɛ̀ bee Nfoŋ wu Lum. ");
INSERT INTO ncr_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ŋgoo yi bamii ba mbɛmɛ ba Antiok yu noo, bo seesɛ lɛ muh wuchii su bige no wù kɛme, bo fih booŋ ba bwe bo ba le Judia yu. ");
INSERT INTO ncr_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bo mo bo su, bo tuŋ Banaba bɛ Sol bɛ bige biyu lɛ bo gɛɛŋ bo nya bachiji kintaashɛ ki bamii ba mbɛmɛ le. ");
INSERT INTO ncr_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Gɛ̀ bee kife kiyu le, Nfoŋ Hɛlod kɛ wu nyaa ŋgɛ bamii bamu ba kintaashɛ ki bamii ba mbɛmɛ le. ");
INSERT INTO ncr_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Wu jɛmɛ ba gwoojɛ Jɛm wù mwa bwe Joŋ wu kwe. ");
INSERT INTO ncr_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Wu gɛ̀ doo wu yɛŋ lɛ fi le fi joŋ Bajuu le, wu mo wu gɛɛŋ fwe wu jɛmɛ ba koo tɛ Bita. Ba gɛ̀ kole wu yi aju a Ŋka wu Blɛd wù ba baaŋ gɛɛ gɛ Kishilɛ yo gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","No bo kole wu, bo faa wu yeh yi ncha le, bo gɛɛ ŋgoo yi bamii ba nchi yeye yeye lɛ bo chiɛɛne wu banɛh banɛh. Hɛlod gɛ̀ gɛle Bita noo lɛ Ŋka wu Ndaŋfe ge doo wu fe, wu bvusɛ wu wù leesɛ a bamii fwe ba sa wu. ");
INSERT INTO ncr_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Bita tu wù nyu gɛh yeh yi ncha le. Geenɛ, kintaashɛ ki bamii ba mbɛmɛ tu ki buune Nyo fɛ wu le wesee. ");
INSERT INTO ncr_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Lɛ doo nyume kintaŋ kì akfuuŋ bude ayuu Hɛlod bvusɛ Bita lɛ ba sa wu, Bita lefe antɛnɛɛ a bamii ba nchi bafɛɛ ba kaaŋ wu bɛ bancha bafɛɛ, bo tu bo chiɛɛne wu. Bamii ba nchi bamu chiɛɛne a yeh yi ncha fwe. ");
INSERT INTO ncr_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Fi kooshɛ lɛ nchɛndaa Tada gɛ̀ ja wu jagɛ nɛ wu bu, n'yuu baaŋ yeh yi ncha yiyu le. Nchɛndaa wɛɛ kuŋ Bita yi kibɛne le, wu kaŋsɛ. Wu jɛmɛ wu le lɛ, “Ja we chige.” No wu jɛmɛ noo, bancha baa mo bo faanyɛ chiaaŋ yi Bita le bo gwe fɛkuu. ");
INSERT INTO ncr_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Wu ka wu jɛmɛ wu le lɛ, “Jilɛ nju yo, wo lee jé yo.” Bita ge noo. Nchɛndaa wɛɛ ka wu jɛmɛ lɛ, “Buu nju yo ye le wo bîi mɛne.” ");
INSERT INTO ncr_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Bita buu, wu bii wu le akfuuŋ. Gɛ wu gɛ̀ kee lɛ fiɛɛ fì nchɛndaa wɛɛ gee le nchiɛɛŋ gɛ. Wu gɛ̀ kwaji lɛ le fiɛɛ njɛ kifilɛ fi too fɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bɛ wu jiɛnyɛ bo fe kijusɛ ki fwe fɛ bamii ba nchi gɛ̀ chiɛɛne fo, bo fe bvu ajiŋ, bo fɛsɛ jwe wu kitaŋ wù bude wu gɛɛne a kilaantɛŋ le, ba fɛ bɛ kinchvu. Jwe wu kitaŋ kiyu gwenyɛ lɛwulɛwu, bo bu. No bo bu noo, bo tu bo jiɛnyi bo boge gɛh a je, nchɛndaa Tada Nyo wɛɛ mo wu ja wu lɛsɛ a wu jii. ");
INSERT INTO ncr_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Bita shɛɛ, bvufee to wu fo, wu jɛmɛ lɛ, “Mɛɛse nle ŋkɛɛ wa lɛ le nchiɛɛŋ lɛ be tuŋ Tada Nchɛndaa we lɛ wu to wu bvusɛ mɛ chiaaŋ yi Hɛlod le, mbu yi ŋgɛ wù Bajuu chi chiɛɛne lɛ bo lé bo gê bo nyâ mɛne.” ");
INSERT INTO ncr_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","No wu kɛle noo, wu mo wu ja wu gɛɛne fɛ yeh yi Mɛɛle wù bwe Joŋ Maliku le, bamii ba duude nyu bo taashɛ fo bo buune. ");
INSERT INTO ncr_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Wu gɛɛŋ wu bu fo, wu kuŋ jwe wu kitaŋ, mwa wù kwɛse wumu jee che nyu lɛ Loda wù gɛ̀ lɛne fɛ yeh yiyu le to ki wu gwênyɛ. ");
INSERT INTO ncr_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Wu doo wu yu lɛ le jɛ yi Bita, njoŋ yuuyɛ lo wu, wu baaŋ a gwenyɛ gɛ kitaŋ gɛ, wu ka wu ja wu legɛ wu kaasɛ wu lee wu gɛɛŋ yeh, wu sɛɛŋ bamii le lɛ, “Bita le jwe wu kitaŋ le.” ");
INSERT INTO ncr_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bo chvuu wu le lɛ, “Wo jede lo.” Wu tu wu tɛɛnyi gɛh lɛ le Bita. Bo ja bo jɛmɛ lɛ “Taŋlo nyu Nchɛndaa wu Nyo we.” ");
INSERT INTO ncr_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","No bo gɛ̀ jɛme noo, Bita mɛ gɛh wu kune. Bo doo bo gwenyɛ, bo yɛŋ nyu nchiɛɛŋ lɛ le wu, jwe yuŋ bo. ");
INSERT INTO ncr_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Wu fe bɛ chiaaŋ lɛ bo lu bɛ jwe, wu mo wu sɛɛŋ bo no Tada be bvusɛ wu yeh yi ncha le, wu ka wu jɛmɛ lɛ bo sɛɛŋ Jɛm le mo bamii ba mbɛmɛ le bachii. No wu jɛmɛ noo, wu mo wu ja wu gɛɛŋ kimbe kimi le. ");
INSERT INTO ncr_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Akfuuŋ bu ayuu, bvufee chɛŋe lo bamii ba nchi laa tu kooshi la bɛ Bita la. ");
INSERT INTO ncr_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Hɛlod bvusɛ bamii lɛ bo jiɛnyɛ bo gooŋ wu. Bo gooŋ, bo gooŋ sɛŋ. Wu mo wu tɛɛŋ bamii ba nchi ba gɛ̀ chiɛɛne Bita baa, wu biih mwɛɛ bo le, wu jɛmɛ lɛ ba jo bo ba gɛɛŋ ba lɛɛshɛ lo bo. Ajiŋ ayu, Hɛlod ja kimbe ki woŋ wu Judia le, wu boh wu gɛɛŋ wu tu wù nyu a kilaantɛŋ kì Kasalia le. ");
INSERT INTO ncr_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Gɛ̀ bee kife kiyu le Nfoŋ Hɛlod toonyi shɛ́ŋ bɛ bamii ba Taya mo ba Sidoŋ. Bamii bayu mo bo banyɛ ye ki bo gɛɛŋ bo ku chiaaŋ lɛ nyiɛgee nyume yu, nje woŋ wuboo gɛ̀ kɛme mwɛɛ munjile nyu woŋ we le. Bo gɛɛŋ, bo ya bo koo nsaŋ bɛ Blastu wù gɛ̀ bee chɛfoŋ. ");
INSERT INTO ncr_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Juu gɛ̀ to chi kojɛ, Nfoŋ Hɛlod noŋ njú ye yi woŋ, wu shii yi kala le, wu tu wu nyaa njɛme bamii bayu le. ");
INSERT INTO ncr_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Bo ja bo wuule lo, bo yuuse wu bo duu lɛ, “Wunɛ njɛmɛ le wu nyo, gɛ nyu wu muh wu wuŋ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kimimia, nchɛndaa Tada mo wu tuŋ kinchɛŋ yi Nfoŋ Hɛlod le, nje wu gɛ̀ baaŋ feesɛ gɛ mbɛɛŋsɛ wuyu Nyo le gɛ. Baŋgvule mo bo ji wu, wu kwe. ");
INSERT INTO ncr_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Geenɛ, jɛ yi Nyo tu yi leese a muntele mu bamii le, yi saaŋe yi gɛɛne lo fwe fwe. ");
INSERT INTO ncr_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banaba bɛ Sol gɛ̀ mɛsɛ fiɛɛ fì ba gɛ̀ tuŋ bo yu Yɛlusalɛm, bo mo bo kaasɛ bo tu jiŋ Antiok. Bo doo bo tuu jiŋ, bo jo Joŋ Maliku. ");
INSERT INTO ncr_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Bamii bamu gɛ̀ bee a kintaashɛ ki bamii ba mbɛmɛ le Antiok, nyu ba sɛŋe mwɛɛ mù bo gɛ̀ yuge Nyo jɛme, bo ka yɛyi bamii. Bamii bayu gɛ̀ bee Banaba bɛ Simuŋ wù ba gɛ̀ tɛŋe lɛ wù Yiide, mo Lusu wu Sɛliŋ bɛ Sol mo Manɛŋ wù ba gɛ̀ lɛyɛ wu bɛ Hɛlod wù muh wu nsa. ");
INSERT INTO ncr_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Gɛ̀ bee bo bane mwɛɛ munjile bo buune Nyo, Kiyo ki Yuude ja ki jɛmɛ bo le lɛ, “Bɛŋ baa Banaba bɛ Sol bɛŋ gɛɛ yeye, bo lɛ̂ne lɛme chì nle ntɛɛŋ bo lɛ bo lɛ̂ne.” ");
INSERT INTO ncr_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Bo yu noo, bo ka bo bane gɛh mwɛɛ munjile bo buune, bo gɛ̀ ja bo gɛɛ chiaaŋ yi bo le, bo mo bo chiiŋsɛ bo, bo tu bo gɛɛne. ");
INSERT INTO ncr_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Banaba bɛ Sol mo bo gɛɛne gɛh no Kiyo ki Yuude gɛ̀ tuŋ bo. Bo ja bo boh a kilaantɛŋ kì Sɛlusia le, bo lee a ŋguh wu a joo le, bo daŋsɛ, bo gɛɛne woŋ wù Sablu le. ");
INSERT INTO ncr_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","No bo daŋ, bo bu a kilaantɛŋ kì Salami le, bo tu bo jiɛnyi bo feeji jɛ yi Nyo yéh yi buunɛ yi Bajuu le, Joŋ Maliku jiɛnyi bɛ bo, wu fii bo. ");
INSERT INTO ncr_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bo jiɛnyɛ yi woŋ wu a joo ntɛnɛɛ wuyu le, bo daŋsɛ bo gɛɛŋ bo bu mo a kilaantɛŋ kì Bafo le. Lɛ bo gɛɛŋ bo bu yi muh wu Bajuu wumu le yo, nyu muh wu nfiŋ jee che nyu lɛ Bal Jiso, wu gɛ̀ mbiane lɛ wu le muh wù sɛŋe mwɛɛ mù wu gɛ̀ yuge Nyo jɛme. ");
INSERT INTO ncr_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Wu to wu shee bɛ Sɛgu Bawolu wù muh wù sage woŋ wuyu. Muh wù sage wuyu gɛ̀ kɛme bvufee baaŋ. Wu tɛɛŋ Banaba bɛ Sol nje wu gɛ̀ goone ki wu yû jɛ yi Nyo. ");
INSERT INTO ncr_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Bo to, geenɛ Ɛlima wù muh nfiŋ wɛɛ no jee che le a jɛ yi Glek le, wu mo wu tɛɛnyi bɛ bo, wu mone ki wu gê lɛ keefɛ muh wù sage wɛɛ lee fitele yi Jiso le gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Kiyo ki Yuude yisɛ yi Sol le, wù jee che chimi gɛ̀ bee lɛ Bol, wu noŋ ajii yi muh nfiŋ wɛɛ le, ");
INSERT INTO ncr_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","wu jɛmɛ wu le lɛ, “Wo le mwa debele, wo le muh wù banɛ fiɛɛ fichii fì le chuule. Kilɛlɛ bɛ chimbiaŋ le mu chiiŋ fɛ fitele fiuŋ le. Gɛ taŋlo wo nyu nɛ njɛ wo kuse nchiɛɛŋ wù Nyo tûu chimbiaŋ sɛŋ gɛ? ");
INSERT INTO ncr_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Yegɛ yu, mɛɛse kibo ki Nyo le ki gwe ye yo le wo feeŋ, fi lé fi jô kife fɛ wo ka wo yɛŋ juu le.” Kimimia noo, fiɛɛ fimi shii gɛ̀ njɛ kimbɛ, fi baŋe ajii a Ɛlima. Wu mo wu ja wu tu wu monyi lo manjuu, wu goone muh wù chiɛɛji wu. ");
INSERT INTO ncr_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Muh wù sage wɛɛ yɛŋ noo, wu mo wu lee fitele yi Jiso le, no wu gɛ̀ kɛme kiŋgha yi mwɛɛ mù bo gɛ̀ yɛyi kune Tada Jiso. ");
INSERT INTO ncr_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Bol bɛ ŋgoo ye lee a ŋguh le Bafo, bo daŋ joo yì baaŋ bo bu a kilaantɛŋ kì Bɛlga le woŋ wù Banfilia le. No bo bu yo, Joŋ Maliku chinɛ bo le, wu tu jiŋ Yɛlusalɛm. ");
INSERT INTO ncr_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Bo ja yo, bo fe bo gɛɛŋ a kilaantɛŋ kì Antiok wu Bisidia le. Lɛ to nyu juu chi yuuŋ, bo gɛɛŋ bo lee bo shii yeh yi buunɛ le. ");
INSERT INTO ncr_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bamii gɛ̀ ja bo tɛɛŋ a Ŋwa wu banchi ba Musɛ le bɛ wu bamii ba ntuŋ wu Nyo bo mɛsɛ, bachiji kikwɛɛ ki yeh yi buunɛ yiyu le mo bo tuŋ ntuŋ fɛ ba Bol le lɛ, “Booŋ ba bwe wese, bɛŋ nɛ kɛme fiɛɛ fì bɛŋ tefɛ bamii yu, bɛŋ jɛmɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Bol mo wu ja we, wu chi bamii bɛ kibo wu mo wu kɛ wu jɛme lɛ, “Bamii ba Ishwala bɛ bamii ba le gɛ Bajuu gɛ ba ŋgvuune tɛ Nyo, bɛŋ yêgɛ bɛŋ yû. ");
INSERT INTO ncr_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nyo wu bamii ba Ishwala gɛ̀ cha bachiji chiji besa, wu ge kfuu chiboo tu chi kuu sege bo gɛ̀ bee bantolo woŋ wù Ijib le. Wu mo wu bvusɛ bo yo bɛ bvuŋga bwe, ");
INSERT INTO ncr_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","wu koo yii bɛ bo, wu tu wu jiiŋe fɛ bo le nchvuuŋ yi biluŋ le mbaanyɛ. ");
INSERT INTO ncr_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Wu gɛ̀ ge ba shiiŋshɛ bituŋ bvusooshwi woŋ wù Kanan le, wu mo wu nya woŋ kwɛɛ tu wuboo. ");
INSERT INTO ncr_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Mwɛɛ munɛ munchii gɛ̀ jo njɛ biluŋ gii yinɛh kicho mbaanshɛŋ (450). No wu nya woŋ kwɛɛ bo le, wu mo wu gɛɛ bamii ba sâge bo. Bo sa bo gɛɛŋ bo bu yi kife kì muh we wu ntuŋ wù Samwe gɛ̀ sage le. ");
INSERT INTO ncr_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Gɛh yi kife kɛɛ le bo gɛ̀ ja bo lɛgɛ ki bo kɛme nyu nfoŋ, Nyo mo wu nya Sol, mwa Kish wu kfuu chi Bɛnjamɛ le. Wu sa bvunfoŋ yi biluŋ le mbaanyɛ. ");
INSERT INTO ncr_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Nyo gɛ̀ shwa wu, wu gɛɛ Dabi Nfoŋ wuboo le. Nyo gɛ̀ bee wu jɛmɛ kune Dabi wunɛ lɛ, ‘Nle n'yɛŋ Dabi wù mwa Jɛsi le nyu fitele fiaŋ. Wu lé wu gee fiɛɛ fichii fì ŋgoone.’ ");
INSERT INTO ncr_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Gɛ̀ bee a kfuu chi Nfoŋ Dabi wunɛ le wù Nyo gɛ̀ bvusɛ Mbvusɛ, wu nya bamii ba Ishwala le no wu gɛ̀ ka wa. Mbvusɛ wunɛ nyu Jiso. ");
INSERT INTO ncr_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Fɛ Jiso wunɛ kɛ lɛme che gɛ̀ bee Joŋ feeji wa bamii bachii ba Ishwala le lɛ bo kusɛ muntele muboo wu leesɛ bo a joo. ");
INSERT INTO ncr_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Joŋ gɛ̀ bee wa ki wu mɛ̂sɛ lɛme che, wu gɛ̀ ja wu biih bamii le lɛ, ‘Bɛŋ kwaji lɛ nle yɛɛŋ? Gɛ n'ya nyume muh wù bɛŋ chiɛɛne gɛ. Muh wu too a mɛ jiŋ, mbaaŋ ŋkojɛ gɛ muh wu le no ŋgvuumɛ nfaanyɛ jé ye gɛ.’” ");
INSERT INTO ncr_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Bol gɛɛŋ fwe wu jɛmɛ lɛ, “Booŋ bwɛɛŋ ba le a kfuu chi Ablaham le mo bɛŋ bamii bachii ba le gɛ Bajuu gɛ ba ŋgvuune tɛ Nyo, Nyo gɛ̀ chiiŋsɛ ntuŋ wunɛ wu taŋlo wu bvusɛ bamii yu nyu besabɛŋ. ");
INSERT INTO ncr_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Geenɛ, bamii ba Yɛlusalɛm bɛ bamii baboo bo sage woŋ, bo faŋ ki bo jo Jiso njɛ Mbvusɛ. Bo ka bo faŋ ki bo kɛɛ kinyi ki mwɛɛ mù bamii ba ntuŋ wu Nyo gɛ̀ saŋ kune wu. Nyu gɛ mu mù bo gɛ̀ shee bo tɛŋe aju a yuuŋ le achii. Bo gɛ̀ doo bo jɛme lɛ ba yuuyɛ wu noo, finɛ fiɛɛ mo fi ge fi to fi kojɛ no bamii ba ntuŋ wu Nyo gɛ̀ jɛmɛ. ");
INSERT INTO ncr_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","No bo gɛ̀ baaŋ yɛŋ gɛ jialɛ chì taŋlo bo yuuyɛ wu yu gɛ, bo gɛɛŋ fwe bo jɛmɛ Balɛt le lɛ ba yuuyɛ wu. ");
INSERT INTO ncr_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Bo gɛ̀ ge fiɛɛ fichii no Ŋwa wu Nyo gɛ̀ jɛme kune Jiso, bo shiishɛ wu yi kintaaŋ le bo gɛɛŋ bo leesɛ wu a jɛŋ. ");
INSERT INTO ncr_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Geenɛ, Nyo kaasɛ wu bvusɛ wu yi kwe le. ");
INSERT INTO ncr_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Wu dunyɛ kikwɛɛ ke yi aju a duude le, bamii ba bɛ bo gɛ̀ ja Galalee bo gɛɛŋ Yɛlusalɛm. Le bo ba feeji kune wu mɛɛse bamii ba Ishwala le. ");
INSERT INTO ncr_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Noo, bee tu be nyu tɛ fɛnɛ mɛɛse ki be feeji saaka wù joŋe wunɛ bɛŋ le. Saaka wunɛ le lɛ, fiɛɛ fì Nyo gɛ̀ ka wa bachiji chiji bamii ba Ishwala yu, ");
INSERT INTO ncr_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","le wu ge wa fi to fi kojɛ mɛɛse kife kesa besabɛŋ le, besabɛŋ ba le booŋ baboo. Finɛ kooji no Nyo gɛ̀ bvusɛ Jiso yi kwe le. Ba le ba saŋ wa kune fiɛɛ finɛ a Ŋwa wu N'yuusɛ le bimbe bifɛɛ, Nyo jɛme lɛ, ‘Wo le mwa yaŋ, abɛŋ nle chijo.’ ");
INSERT INTO ncr_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Kune mbvusɛ wù Nyo gɛ̀ bvusɛ Jiso yi kwe le lɛ keefɛ wu fo gɛ, Nyo gɛ̀ jɛme a yinɛ je le lɛ, ‘Nlé ŋgê nnyâ bɛŋ kimbonɛ kì le kaŋ, ki ŋgɛ ŋkawa Dabi yu, wu lee.’ ");
INSERT INTO ncr_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Fi le ba ka ba saŋ a kijusɛ kimi le a Ŋwa wu N'yuusɛ le Dabi jɛme lɛ, ‘Gɛ wo nyu wo ge wo chinɛ Mwa yo wu lɛme wù Yuude le, wu fo a jɛŋ gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Fi kune Dabi le lɛ wu gɛ̀ lɛŋ lɛme che chì Nyo gɛ̀ nya wu le yi kife ke le, wu ge wu kwe ba jiiyɛ wu mbebe bachiji le, wu fo. ");
INSERT INTO ncr_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Geenɛ, muh wunɛ wù Nyo gɛ̀ bvusɛ yi kwe le gɛ̀ baaŋ fo gɛ a jɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Noo, booŋ ba bwɛɛŋ, bɛŋ mo bɛŋ kêe chuule lɛ saaka wunɛ wù ba feeji lɛ Nyo lɛɛshi bimbefɛ bi bamii wu lɛɛshi nje Jiso wunɛ. ");
INSERT INTO ncr_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Muh wù leese fitele fie yi Jiso le, le wu bonɛ wa yi bimbefɛ bie le bichii, le fiɛɛ fì taŋlo nchi wu Musɛ gɛ ge gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Noo, bɛŋ yɛ̂ne lɛ keefɛ fiɛɛ fì ba saŋ a ŋwa wu bamii ba ntuŋ wu Nyo le fi koo bɛŋ gɛ. Ba jɛme yo lɛ, ");
INSERT INTO ncr_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Bɛŋ yêgɛ bɛŋ yû bɛŋ ba chwɛɛse Nyo. De lé yi gê yi yûŋ bɛŋ, bɛŋ kweeyɛ. Nlé ŋgê môŋ fiɛɛ yi kife kena le, nyu fi muh be jɛme lo bɛŋ le, bɛŋ gɛ bɛɛŋ gɛ.’” ");
INSERT INTO ncr_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Bol bɛ Banaba gɛ̀ doo bo bude yeh yi buunɛ yiyu le, bamii bayu tu bo lɛgɛ lɛ bo ka bo to gɛh juu chi yuuŋ chì too le bo ka bo jɛme mwɛɛ munɛ. ");
INSERT INTO ncr_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Bamii gɛ̀ doo bo bu yeh yi buunɛ le, bamii ba duude ba gɛ̀ bee Bajuu bɛ bamii ba gɛ̀ kusɛ bo tu bamii ba mbɛmɛ ba Bajuu le, tu bo bii Bol bɛ Banaba le. Bo tu bo jɛme bo teede bamii bayu le lɛ bo yûge gɛh nyu Nyo le, lɛ bo mɛ gɛh bo nyu yi nfii wù Nyo le. ");
INSERT INTO ncr_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Lɛ to nyu juu chi yuuŋ chì bii chiɛɛ le, gɛ̀ shɛɛ gɛh shige kilaantɛŋ kichii gɛ̀ bu ki to ki yu jɛ yi Nyo. ");
INSERT INTO ncr_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Bajuu yɛŋ no kinchvu ki bamii taashɛ noo, bo tu bo bɛɛnɛ kindoŋ, bo tɛɛnyi fiɛɛ fì Bol be jɛme le, bo naanyi wu. ");
INSERT INTO ncr_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Bol bɛ Banaba tu bo jɛme lo bo faane gɛ, bo duu lɛ, “Fi le chuule lɛ bee ya be fejɛ jɛ yi Nyo nyu bɛŋ Bajuu le. No bɛŋ le bɛŋ laasɛ lo, bɛŋ jo bikwɛɛ biɛna lɛ bɛŋ baaŋ kojɛ gɛ ki bɛŋ kɛ̂me kinche kì kage gɛ, tu bee lé be fîisɛ fiesa be feeji nyu bamii ba le gɛ Bajuu le gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Le no Nyo le wu jɛme bee le, wu gɛ̀ duu lɛ, ‘Nle ntomɛ wo lɛ wo nyume kin'yesɛ yi bamii ba le gɛ Bajuu gɛ, wo lé wo gê wo bvûsɛ bamii ba le abu a woŋ le achii bo bonɛ.’” ");
INSERT INTO ncr_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Bamii ba le gɛ Bajuu gɛ yu noo, bo tu bo yuge njoŋ, bo bɛɛŋse jɛ yi Tada. Bamii ba duude bɛɛŋ saaka wɛɛ le, nyu ba Nyo gɛ̀ cha wa lɛ bo lé bo kɛ̂me kinche kì kage gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Jɛ yi Tada mo yi jiɛnyɛ woŋ kwɛɛ le wuchii. ");
INSERT INTO ncr_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Geenɛ, Bajuu mo bo ja bo bɛɛse bachiji ntɛ bɛ bikɛse ba baaŋ baaŋ, bikɛse banɛ nyu bo, bo gɛ̀ bee bo too yeh yi buunɛ le, bo tu bo banɛ Bol bɛ Banaba, bo mo bo kuŋ bo lɛ bo ja yo. ");
INSERT INTO ncr_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Bo doo bo jade noo, bo kaajɛ bibvunɛ yi bikaa biboo le lɛ le njiŋɛ wu fiɛɛ fì bo moŋ, bo mo bo gɛɛŋ a kilaantɛŋ kì Ikoniuŋ le. ");
INSERT INTO ncr_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ŋgoo yi bamii ba mbɛmɛ lɛ shɛɛ yi tu yi nyu fiboo yi yuge njoŋ baaŋ, Kiyo ki Yuude nyu ki yisɛ ye yiboo le. ");
INSERT INTO ncr_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","No Bol bɛ Banaba gɛ̀ gɛnɛ Ikoniuŋ, bo ka bo ge gɛh yɛɛŋyɛɛŋ no bo gɛ̀ ge Antiok, ki bo lee yeh yi buunɛ yi Bajuu yi yo le, bo feeji saaka wù joŋe yu. Bo fejɛ chuule Bajuu mo bamii ba le gɛ Bajuu gɛ bɛɛŋ wesee. ");
INSERT INTO ncr_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Geenɛ, Bajuu ba gɛ̀ faŋ ki bo bɛɛŋ bo ja bo bɛɛse bamii bamu ba le gɛ Bajuu gɛ, bo chɛŋe bɛ muntele muboo, bo tôonyi shɛ́ŋ bɛ bamii ba mbɛmɛ. ");
INSERT INTO ncr_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Bol bɛ Banaba mɛ gɛh yo kife ki ndefe le, bo tu bo feeji kune Tada bo faane gɛ. Tada nya bo bɛ bvuŋga ki bo gee mwɛɛ mù duunyi bvuŋga bvu Nyo bɛ mwɛɛ mu jwe wu yunɛ mù duunyi lɛ fiɛɛ fì bo feeji kune Tada no wu le wu dunyɛ fitele fì joŋe fɛ bamii le, le nchiɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Bamii ba a kilaantɛŋ kiyu le gadɛ. Bamu tu kimbe ki Bajuu ba gɛ̀ faŋe ki bo bɛɛŋ baa le, bamu tu kimbe ki booŋ ba ntuŋ ba Jiso le. ");
INSERT INTO ncr_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Bajuu baa bɛ bamii ba le gɛ Bajuu gɛ mo bikwɛɛ bi woŋ taashɛ, bo chu ntaŋ ki bo nyiɛ bɛ booŋ ba ntuŋ ba Jiso, ki bo tumɛ bo bɛ ata bo kweeyɛ. ");
INSERT INTO ncr_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Bo kɛɛ ntaŋ wɛɛ, bo mo bo legɛ bo gɛɛŋ woŋ wù Likonia le, bo tu bo jiɛnyi bilaantɛŋ bì Lista bɛ Dɛbi le mo bantɛ ba mbebe yo le, ");
INSERT INTO ncr_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Bo feeji saaka wù joŋe yo. ");
INSERT INTO ncr_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Muh mu gɛ̀ bee Lista, wu gɛ̀ bee wu shee gɛ fɛkuu, taŋlo wu gɛ jiɛnyɛ gɛ, nje ba gɛ̀ boyi wu, wù nyu kiŋkɛlɛ. Lɛ to nyu juu chimi, ");
INSERT INTO ncr_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","wu shii wu yege fiɛɛ fì Bol gɛ yɛyi. Bol noŋ ajii ye ye le, wu yɛŋ muh wɛɛ kɛme mbɛmɛ lɛ Nyo taŋlo wu fɛ wu, wu tɛmɛ, ");
INSERT INTO ncr_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","wu mo wu jɛmɛ wu le fɛwɛɛwe lɛ, “Ja lɛɛŋ we.” Wu mo wu selɛ we, wu kɛ wu tu wu jiɛnyi. ");
INSERT INTO ncr_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kinchvu ki bamii yɛŋ fiɛɛ fì Bol ge le, bo mo bo tuŋ kitada, bo jɛmɛ a jɛ́ yi Likonia le lɛ, “Banyo le bo tu bamii bo shii bo to fɛ bee le.” ");
INSERT INTO ncr_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bo tu bo tɛŋe Banaba lɛ Siyu, bo mo bo tɛŋe Bol lɛ Ɛmi lɛ le gɛh wu wù to wu jɛme segechii. ");
INSERT INTO ncr_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Gɛ̀ bee yeh yi kintanyɛ yi nyo wù bo tɛŋe lɛ Siyu wunɛ le nyu mbebe kilaantɛŋ kiyu le. Chiji kintanyɛ wu fo mo wu jo banaa ba bilɛŋsɛ bɛ nfude wu mo wu too bɛ bo jwe wu kitaŋ le lɛ bɛ bamii ge kintanyɛ yu fɛ Banaba bɛ Bol le. ");
INSERT INTO ncr_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Booŋ ba ntuŋ ba Jiso banɛ kɛɛ fiɛɛ fì bɛ bamii bayu gɛ̀ goone ki bo ge, bo saayɛ njú ye yiboo le, bo legɛ bo lee a bamii bayu ntɛnɛɛ, bo tu bo ghaade lɛ, ");
INSERT INTO ncr_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Bamii banɛ, bɛŋ gee nyu la finɛ? Bee le gɛh bamii yɛɛŋyɛɛŋ njɛ bɛŋ, bee to fɛnɛ ki bee fejɛ saaka wù joŋe wù jade fɛ Nyo le lɛ bɛŋ chinɛ banyo ba achiji banɛ le, bɛŋ bîi nyu Nyo wu le Nyo le. Wu gɛ̀ fɛ kibvulɛ bɛ nshɛŋ bɛ jóo mo mwɛɛ munchii mù le manjuu manɛ le. ");
INSERT INTO ncr_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Gɛ̀ bee fweele, wu chinɛ bamii le bituŋ le bichii, bo gee no bo koŋe. ");
INSERT INTO ncr_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Geenɛ, wu tu wù gee gɛh mwɛɛ mù njoŋe fɛ bamii le ki fi dûunyi lɛ wu le yu. Wu tu wu nyaa bo bɛ jaŋ, bo kɛme ŋgu kife kì kooji le, bo jii bo yuge njoŋ.” ");
INSERT INTO ncr_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","No Banaba bɛ Bol jɛmɛ mwɛɛ munɛ bo le nɛ, bo ge lo nɛ cho, fɛ bo lu ki bo ge kintanyɛ fɛ bo le. ");
INSERT INTO ncr_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Bajuu bamu gɛ̀ ja bo to yo, bo ja Antiok bɛ Ikoniuŋ, bo bɛɛse bamii ba duude lɛ bo tumɛ Bol bɛ ata. No bo tumɛ noo, bo mo bo chii wu bo bu bɛ wu a kilaantɛŋ le bo kwaji lɛ wu le wu kwe wa. ");
INSERT INTO ncr_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Geenɛ, ŋgoo yi bamii ba mbɛmɛ gɛ̀ to bo taashɛ a wu we, wu kaasɛ wu ja we, wu tu a kilaantɛŋ kiyu le. Bvu gɛ̀ bu bvu yuu, wu bɛ Banaba mo bo ja yo, bo gɛɛne a kilaantɛŋ kì Dɛbi le. ");
INSERT INTO ncr_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","No Bol bɛ Banaba leese Dɛbi, bo fejɛ saaka wù joŋe kune Jiso, bo kɛme bamii ba mbɛmɛ yo wesee. Bo gɛ̀ ja yo bo tu bo kaase bo tuu jiŋ, bo fede a bilaantɛŋ bì Lista bɛ Ikoniuŋ le mo Antiok wu Bisidia le. ");
INSERT INTO ncr_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","No bo fede noo, bo chiaase muntele mu bamii ba mbɛmɛ, bo teede bo le lɛ bo mɛ gɛh bo lɛ̂me chuule yi mbɛmɛ wuboo le, bo kêe lɛ bɛ bo kɛme ki bo yɛŋ baŋgɛ ba duude fɛ bo ge bo lee bvunfoŋ bvu Nyo le. ");
INSERT INTO ncr_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Bo tu bo baayi bachiji bintaashɛ bi bamii ba mbɛmɛ, bo gɛɛde bintaashɛ bi bamii ba mbɛmɛ le bichii. No bo gɛ̀ gɛɛde noo bo banɛ mwɛɛ munjile bo buune bo mo bo nya bo chiaaŋ yi Tada Jiso wù bo bɛmɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Bol bɛ Banaba gɛ̀ fe woŋ wù Bisidia le, bo daŋsɛ bo gɛɛŋ wù Banfilia le, ");
INSERT INTO ncr_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","bo fejɛ jɛ yi Nyo a kilaantɛŋ kì Bɛlga le, bo boh bo gɛɛŋ a kilaantɛŋ kì Atalia le. ");
INSERT INTO ncr_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","No bo boh yo, bo lee a ŋguh wu a joo le, bo tu bo kaase bo tuu jiŋ Antiok. Antiok yanɛ nyu yo a ba gɛ̀ nya bo chiaaŋ yi Nyo le wu nya bo bɛ nfii we, bo tu bo jiɛnyi bo gee lɛme chinɛ chì bo gɛ̀ mɛsɛ. ");
INSERT INTO ncr_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","No bo fɛse yo, bo baanyɛ kintaashɛ ki bamii ba mbɛmɛ, bo sɛɛŋ fiɛɛ fichii bo le no Nyo chi lɛŋ bɛ bo, bɛ no wu chi gwenyɛ muntele mu bamii ba le gɛ Bajuu gɛ, bo lee muntele yi Jiso le. ");
INSERT INTO ncr_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Bol bɛ Banaba che bɛ ŋgoo yi bamii ba mbɛmɛ bayu kife ndefɛ. ");
INSERT INTO ncr_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Bamii bamu gɛ̀ ja Judia, bo boh bo to Antiok, bo tu bo yɛyi bamii ba mbɛmɛ, lɛ gɛ taŋlo Nyo bvusɛ muh njɛ ba chvuu mwɛdɛ yeh no nchi wu Musɛ duunyi sɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Bol bɛ Banaba kajɛ lo n'yɛyɛ wuyu, bɛ bamii bayu she bo tɛɛnyi kintɛɛnyɛ yu we nyu gɛ kì wɛɛ gɛ. Fi gɛ̀ ya, kintaashɛ ki bamii ba mbɛmɛ ki Antiok bo baa Bol bɛ Banaba mo bamii ba mbɛmɛ bamu, bo tuŋ lɛ bo bɛɛŋ Yɛlusalɛm bo yɛŋ booŋ ba ntuŋ ba Jiso bɛ bikwɛɛ bi kintaashɛ ki bamii ba mbɛmɛ ki yo le, lɛ bo lee jwe fɛ fiɛɛ fiyu le. ");
INSERT INTO ncr_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Noo, kintaashɛ ki bamii ba mbɛmɛ ki Antiok mo ki chiiŋsɛ bo, bo tu bo gɛɛne bo fede bimbe bì Fonishia bɛ bì Samaliya le bo sɛŋe bamii ba mbɛmɛ ba yo le, lɛ bamii ba le gɛ Bajuu gɛ le bo kusɛ wa. Bamii bachii ba gɛ̀ yuge noo, bo tu bo laŋeye baaŋ. ");
INSERT INTO ncr_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Bo bɛɛŋ bo gɛɛŋ bo fɛsɛ Yɛlusalɛm, kintaashɛ ki bamii ba mbɛmɛ bɛ booŋ ba ntuŋ ba Jiso mo bachiji kintaashɛ ki yo fi bo. Bo sɛɛŋ fiɛɛ fichii bo le no Nyo chi lɛŋ chiaaŋ yiboo le. ");
INSERT INTO ncr_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Geenɛ, bamii ba mbɛmɛ bamu bo gɛ̀ bee tɛ a ŋgoo yi Bafalashii le, ja we bo jɛmɛ lɛ, “Ba kɛme gɛh ki ba chvûuse bamii ba le gɛ Bajuu gɛ yeh, bo jɛ̂mɛ bo le lɛ bo bii banchi ba Musɛ le.” ");
INSERT INTO ncr_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","No bo jɛmɛ noo, booŋ ba ntuŋ ba Jiso bɛ bachiji kintaashɛ ka bo shii ki bo lee antɛnɛɛ a fiɛɛ fiyu. ");
INSERT INTO ncr_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Bo gɛ̀ she bo jɛme bo gɛɛŋ je yì ndefɛ le, Bita ja wu lɛɛŋ we wu jɛmɛ lɛ, “Booŋ ba bwɛɛŋ, bɛŋ kee lɛ gɛ̀ bee fweele Nyo baa mɛ a bɛŋ ntɛnɛɛ lɛ le yi jwe waŋ le wù bamii ba le gɛ Bajuu gɛ le bo yuge saaka wù joŋe bo bɛmɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nyo wù kee muntele mu bamii, wu dunyɛ lɛ wu lé wu fi bamii ba le gɛ Bajuu gɛ, wu nya bo bɛ Kiyo ki Yuude yɛɛŋyɛɛŋ no wu gɛh nya besabɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Wu gɛ̀ baaŋ dunyɛ gɛ yeye besabɛŋ le bɛ bamii bayu le gɛ. Wu gɛ̀ ge muntele muboo tu mu yuude njɛ bo gɛ̀ bee bo leesɛ muntele yi Jiso le. ");
INSERT INTO ncr_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","No fi le noo, bɛŋ jiɛnyi nɛɛ fɛ bɛŋ goone ki bɛŋ shîŋshi fitele fì Nyo, bɛŋ jode bvujijɛ bɛŋ gɛɛde yi ŋgoo yi bamii ba mbɛmɛ le, bvujijɛ bvunɛ gɛ̀ ya wa bee mo bachiji chiji besa? ");
INSERT INTO ncr_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Gɛ fi nyume chuule gɛ. Besabɛŋ le be bɛɛŋ lɛ Nyo bvuuse besabɛŋ nje fitele fì joŋe fì Tada Jiso le wu dunyɛ fɛ besabɛŋ le. Nyu gɛh tɛ yɛɛŋyɛɛŋ no wu bvuuse bamii ba le gɛ Bajuu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","No Bita jɛme wu mɛsɛ, bamii bachii chiifɛ, bo tu bo yege no Banaba bɛ Bol jɛme no bo gɛ̀ jiɛnyi bo gɛɛne fɛ bamii ba le gɛ Bajuu le gɛ, Nyo nyaa bo bɛ bvuŋga lɛ bo gêe mwɛɛ mù duunyi bvuŋga bvu Nyo bɛ mwɛɛ mu de yì yunɛ. ");
INSERT INTO ncr_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Bo jɛmɛ bo mɛsɛ, Jɛm mo wu jɛmɛ lɛ, “Booŋ ba bwɛɛŋ, bɛŋ yêgɛ bɛŋ yû fiɛɛ fì nle njɛmɛ. ");
INSERT INTO ncr_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Samoŋ be wu sɛɛŋ wa besabɛŋ le no Nyo gɛ̀ kɛ wu dunyɛ tɛ kiŋkoŋɛ ke fɛ bamii ba le gɛ Bajuu le gɛ, wu cha bamu a bo ntɛnɛɛ lɛ le bamii be. ");
INSERT INTO ncr_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Fiɛɛ fì bamii ba ntuŋ wu Nyo gɛ̀ saŋ jiɛnyi gɛh kikaa kimimia bɛ fì Nyo gɛ̀ ge. Ba gɛ̀ saŋ lɛ, ");
INSERT INTO ncr_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Kife too lo kì nlé ŋgê ŋkâasɛ ntô, ŋkɛnyɛ yeh yi Dabi yì le yi gwe wa. Nlé ŋgê njôoŋ bifu biyu, bi kaasɛ bi lɛɛŋ we. ");
INSERT INTO ncr_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Noo, kimbɛge ki bamii mo ki goone Tada, bamii banɛ bachii nyu bamii ba le gɛ Bajuu gɛ ba nle ncha, lɛ le bamii baŋ. ");
INSERT INTO ncr_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Finɛ jɛmɛ Nyo, wu gɛ̀ ge wa bamii kɛɛ baaŋ lo nchensɛŋ.’ ");
INSERT INTO ncr_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","N'yɛnɛ fiaŋ lɛ keefɛ besabɛŋ nyâa ŋgɛ bamii ba le gɛ Bajuu bò le bo leesɛ fitele yi Nyo le gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Besabɛŋ saŋ gɛh nyu ŋwa fɛ bo le, lɛ keefɛ bo jîi mwɛɛ mù ba le ba ge bintanyɛ yu fɛ banyo le gɛ, nje le mwɛɛ mu nyiɛnɛ. Keefɛ bo kɛ̂me fiɛɛ fì bo gee bɛ kinjaŋ gɛ. Keefɛ bo jîi nyáŋ njɛ ba sɛɛ kilɛmɛ bu sɛŋ gɛ. Keefɛ bo jîi kilɛmɛ ki nyaŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ba saŋ noo, nje banchi ba Musɛ banɛ ba gɛ̀ yɛyɛ wa nchensɛŋ manjuu le manchii bamii yuge, le gɛh bo ba bo tɛŋe abɛŋ yéh yi buunɛ le aju a yuuŋ le achii.” ");
INSERT INTO ncr_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Noo, booŋ ba ntuŋ ba Jiso bɛ bachiji kintaashɛ mo kintaashɛ ki bamii ba mbɛmɛ kichii bɛɛŋ fiɛɛ fiyu, bo mo bo yɛŋ lɛ fi joŋe lɛ bo baa bamii a bo ntɛnɛɛ bo tuŋ bɛ ba Banaba mo Bol bo gɛɛŋ Antiok. Bo mo bo baa Juda wù jee che chimi gɛ̀ bee lɛ Basaba, bo ka bo baa tɛ Sila. Bamii bafɛɛ banɛ gɛ̀ bee bikwɛɛ antɛnɛɛ a bamii ba mbɛmɛ. ");
INSERT INTO ncr_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Bo saŋ ŋwa wù ba lé ba tûŋ bo yu wu le lɛ, “Bee booŋ ba bwe wene ba le booŋ ba ntuŋ ba Jiso bɛ bachiji kintaashɛ yɛɛse bɛŋ bamii ba mbɛmɛ bachii ba le gɛ Bajuu gɛ, ba le a kilaantɛŋ kì Antiok le bɛ ba le kimbe kì Silia le mo ba le a kì Silisia le. ");
INSERT INTO ncr_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Bee le be yu lɛ bamii bamu le bo bu a bee ntɛnɛɛ bo to bo tu bo nyaa ŋgɛ, bo chɛŋe bɛ bvufee bwena bɛ n'yɛyɛ wumu njɛ le bee be tuŋ bo sɛŋ. ");
INSERT INTO ncr_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Noo, bee mo be shii bachii bee bɛɛŋ lɛ ba baa bamii bamu ba tuŋ fɛ bɛŋ le, bo tôo bɛ ba Banaba mo Bol bo le nsáa yese yi shɛ́ŋ. ");
INSERT INTO ncr_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Bamii banɛ le bo nya wa kinche kiboo nje lɛme chi Tada wese besabɛŋ wù Jiso Kletu le. ");
INSERT INTO ncr_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Bee mo be tuŋ Juda bɛ Sila lɛ bo to bo jɛmɛ tɛ bɛ jwe fiɛɛ fì le a ŋwa wunɛ le. ");
INSERT INTO ncr_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Besa ba Kiyo ki Yuude le be yɛŋ lɛ fi baaŋ joŋ gɛ ki bee yigɛ bɛŋ bɛ bvujijɛ bvumu fede banchi ba shaŋ banɛ ba le lɛ: ");
INSERT INTO ncr_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Keefɛ bɛŋ jîi mwɛɛ munjile mù ba le ba ge bintanyɛ yu fɛ banyo le gɛ. Keefɛ bɛŋ jîi kilɛmɛ ki nyaŋ gɛ. Keefɛ bɛŋ jîi nyaŋ njɛ ba sɛɛ kilɛmɛ bu sɛŋ gɛ. Keefɛ bɛŋ kɛ̂me fiɛɛ fì bɛŋ gee bɛ kinjaŋ gɛ. Bɛŋ nɛ lege mwɛɛ munɛ, tu bɛŋ gee chuule. Ba shɛɛ wa.” ");
INSERT INTO ncr_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Bo gɛ̀ saŋ noo bo mo bo tuŋ bamii baa yu bo boh Antiok. Bo gɛɛŋ, bo kuŋ kintaashɛ ki bamii ba mbɛmɛ ki yo kichii, bo nya ŋwa wɛɛ bo le. ");
INSERT INTO ncr_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Bo tɛɛŋ ŋwa wɛɛ, saaka wuyu jiɛɛsɛ muntele muboo, bo yu njoŋ baaŋ. ");
INSERT INTO ncr_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Juda bɛ Sila gɛ̀ bee bamii ba gɛ̀ sɛŋe mwɛɛ mù bo gɛ̀ yuge Nyo jɛmɛ, bo nya nteefe yì duude bamii ba mbɛmɛ le, bo tu bo kɛme bvuŋga a muntele le. ");
INSERT INTO ncr_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Bo che yo yi kife kimu le. Bamii ba mbɛmɛ gɛ̀ chiiŋsɛ bo, bo tu bo kaase bɛ kimbonɛ bo tuu jiŋ fɛ bamii ba gɛ̀ tuŋ bo le. ");
INSERT INTO ncr_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Bol bɛ Banaba mɛ gɛh Antiok, bɛ bamii bamu yɛyi bo ka feeji jɛ yi Tada. ");
INSERT INTO ncr_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Kife gɛ̀ doo ki kɛŋsɛ, Bol jɛmɛ Banaba le lɛ, “Besa wo kaasɛ be tu jiŋ be jiɛnyɛ bilaantɛŋ bi besa wo chi feeji jɛ yi Tada bi le, be yɛŋ laa bamii ba mbɛmɛ ba yo gee nɛɛ la.” ");
INSERT INTO ncr_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banaba mo wu goone ki wu jô Joŋ Maliku lɛ bɛ bo jiɛnyɛ. ");
INSERT INTO ncr_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Geenɛ, Bol faŋ wu koŋe gɛ lɛ bo jo wu gɛ, nje wù gɛ̀ bee wu chinɛ bo le Banfilia wu faŋ ki wu mɛ̂sɛ njiɛnyɛ wu bɛ bo gɛ kɛmɛ. ");
INSERT INTO ncr_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Bol bɛ Banaba gɛ̀ she bo kɛmɛ kintɛɛnyɛ baaŋ, bo mo bo gasɛ. Banaba jo Maliku, bɛ wu lee a ŋguh wu a joo le, bo gɛɛŋ Sablu. ");
INSERT INTO ncr_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Bol cha fie nyu Sila. Bɛ wu doo bo jade, bamii ba mbɛmɛ nya bo chiaaŋ yi nfii wu Tada le. ");
INSERT INTO ncr_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Bo gɛɛŋ je bimbe bi Silia bɛ bì Silisia le, bo tu bo jiɛnyi bo chiaase muntele mu kintaashɛ ki bamii ba mbɛmɛ. ");
INSERT INTO ncr_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Bol jiɛnyɛ wu gɛɛŋ wu bu a kilaantɛŋ kì Dɛbi le, wu gɛ̀ ja wu gɛɛŋ kì Lista le. Muh wu ŋgoo wu Jiso wumu gɛ̀ bee Lista ayu jee che nyu lɛ Timoti, bwee nyu muh wu Bajuu, wù nyu tɛ muh wu mbɛmɛ, geenɛ chiji gɛ̀ bee muh wu Baglek. ");
INSERT INTO ncr_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Timoti wunɛ gɛ̀ bee muh, bamii ba mbɛmɛ bachii ba Lista mo ba Ikoniuŋ bɛɛŋse wu. ");
INSERT INTO ncr_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Bol tu wu goone ki wu jô wu lɛ bɛ wu jiɛnyi, wu mo wu chvuu wu yeh. Wu gɛ̀ chvuse wu yeh noo, nje Bajuu bachii ba gɛ̀ chee bimbe biyu le gɛ kee lo lɛ chiji Timoti gɛ̀ bee muh Baglek. ");
INSERT INTO ncr_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Bo tu bo jiɛnyi bo gɛɛne a bilaantɛŋ le, bo doo bo gɛɛne noo bo sɛŋe bamii ba mbɛmɛ, banchi ba booŋ ba ntuŋ ba Jiso mo bachiji kintaashɛ ki Yɛlusalɛm gɛ̀ shilɛ bo bɛɛŋ lɛ ba gɛɛde. ");
INSERT INTO ncr_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Noo, bintaashɛ bi bamii ba mbɛmɛ biyu tu bi tɛɛme bi gɛɛne fwe fwe yi mbɛmɛ le. Bamii tu bo taade fɛ bo le aju achii. ");
INSERT INTO ncr_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Bol bɛ ŋgoo ye ja ki bo gɛɛŋ bo fejɛ jɛ yi Nyo woŋ wu Ɛsia le, Kiyo ki Yuude faŋ. Bo mo bo jiɛnyɛ bo fe nyu je kimbe ki Fligia bɛ ki Galɛshiaŋ le. ");
INSERT INTO ncr_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Bo gɛ̀ doo bo gɛɛŋ bo bu mbebe woŋ wù Misia le bo goone ki bo lee bo gɛɛŋ kimbe kì Bitinia le, Kiyo ki Jiso ka ki faŋ. ");
INSERT INTO ncr_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Noo, bo mo bo fe woŋ wù Misia, bo daŋsɛ bo gɛɛŋ a kilaantɛŋ kì Towa le. ");
INSERT INTO ncr_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Lɛ to nyu antaŋ, fiɛɛ njɛ kifilɛ ja fi to fɛ Bol le. Wu yɛŋ a fiɛɛ fiyu le muh mu wu Masɛdonia lɛme wu lɛge wu lɛ, “Kii wo, daŋ gɛh wo to Masɛdonia yanɛ wo fih bee.” ");
INSERT INTO ncr_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","No fiɛɛ fiyu gɛ to fɛ Bol le noo, besa bo mo be yɛŋ lɛ Nyo le wu dunyɛ lɛ bee gɛɛŋ be fejɛ saaka we wù joŋe woŋ wù Masɛdonia le. Kimimia, bee mo be seesɛ ki bee gɛɛŋ yo. ");
INSERT INTO ncr_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Bee ja Towa, bee daŋ chaaŋ a ŋguh wu a joo le, bee bu Samotɛ. Bvu bu bvu yuu bee gɛɛŋ fwe bee bu Niaboli. ");
INSERT INTO ncr_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Bee gɛ̀ ja fo bee jiɛnyɛ be gɛɛŋ Filibi, nyu kilaantɛŋ ki kimbe ki fwe le Masɛdonia. Kilaantɛŋ kiyu gɛ̀ bee ki bala wu Lum. Bee che yo yi aju le. ");
INSERT INTO ncr_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Lɛ doo nyu juu chi yuuŋ, bee bu a kilaantɛŋ kiyu le, bee gɛɛŋ jwe wu joo le, fɛ bee gɛ̀ kwaji lɛ le kijusɛ ki Bajuu ki buunɛ. No bee gɛnɛ, bikɛse bamu gɛ̀ taashɛ wa fo, bee mo be shii bee tu be jɛme bo le. ");
INSERT INTO ncr_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Kwɛse wumu gɛ̀ bee fo wu yuge tɛ, jee che nyu lɛ Lidia, wù gɛ̀ bee wu ŋgvuune Nyo. Wu bu a kilaantɛŋ kì Tayatila le, wu gese kfuu chi njú yimi, yi nyu njɛ yi yɛɛde lo, yi tɛɛme kwa. Tada gwenyɛ fitele fie, wu bɛɛŋ fiɛɛ fì Bol gɛ̀ jɛme le. ");
INSERT INTO ncr_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Bo gɛ̀ leesɛ wu bɛ bamii ba a wu yeh a joo, wu mo wu lɛgɛ bee wu jɛmɛ lɛ, “Kii bɛŋ, bɛŋ nɛ le bɛŋ yɛŋ lɛ nle nleesɛ fitele fiaŋ fichii yi Tada le, bɛŋ to gɛ, bɛŋ gɛɛŋ bɛŋ che a mɛ yeh.” Wu mɛ gɛh wu tu wu dode, bee ja be bɛɛŋ, bee gɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Lɛ to nyume juu chimi no bee gɛ̀ gɛɛne fɛ kijusɛ ki buunɛ le, bee tasɛ bɛ mwa wù kwɛse wumu wù nyu nfwa. Wu gɛ̀ kɛme kiyo kimu yi ye ye le, kì ge muh tu muh jiaaŋ. Bamii ba gɛ̀ kɛme mwa wù kwɛse wɛɛ gɛ̀ kade bige ye ye le chuule nje wu gɛ̀ sɛŋe mwɛɛ mù gɛ̀ bee ki mu kôoshi. ");
INSERT INTO ncr_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Mwa wù kwɛse wuyu doo wu yɛŋ besa Bol le, wu mo wu bii bee le wu wanɛ, wu duu lɛ, “Bamii banɛ le bamii ba lɛme ba Nyo wu le kikwɛɛ ki mwɛɛ munchii, bo duunyi je yì taŋlo bɛŋ jiɛnyɛ yu fɛ bɛŋ bonɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Wu gɛ̀ ge noo bu aju a duude le, fi gɛ̀ ja fi toonyɛ Bol, wu kaasɛ ye wu waŋ kiyo kiyu wu jɛmɛ lɛ, “Njɛme wo le, a jee chi Jiso Kletu le, lɛ wo bu ye yi mwa wunɛ le.” Ki mo ki bû yi ye ye le fo ki sege. ");
INSERT INTO ncr_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Bamii ba gɛ̀ kɛme nfwa wɛɛ yɛŋ lɛ je yiboo yi bige le yi ka wa, bo mo bo koo Bol bɛ Sila bo chii bo, bo gɛɛŋ bɛ bo fwe a bachiji woŋ le fɛ waaŋ. ");
INSERT INTO ncr_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","No bo gɛnɛ bɛ bo, bo leesɛ bo fwe a bala wu Lum wù gɛ̀ sage bansa bo jɛmɛ lɛ, “Bamii banɛ le Bajuu, bo nyaa ŋgɛ a kilaantɛŋ kesa le. ");
INSERT INTO ncr_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bo yɛyi bamii bɛ kinche kì nchi wese baaŋ bɛɛŋ gɛ. Bee le bamii ba Lum, gɛ taŋlo bee bîi kinche kiyu le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Kinchvu ki bamii kì gɛ̀ bee fo mo ki tooŋ bo, bo gwe yi Bol bɛ Sila le. Bamii ba gɛ̀ sage bansa baa mo bo saayɛ njú yi Bol bɛ Sila, bo jɛmɛ lɛ ba taaŋ bo. ");
INSERT INTO ncr_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Bo suŋ bo wesee, bo jo bo bo gɛɛŋ bo leesɛ yeh yi ncha le, bo jɛmɛ lɛ muh wù to wu chiɛɛne yeh yi ncha wu chîɛɛne bo chuule. ");
INSERT INTO ncr_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","No wu yu noo, wu mo wu jo bo wu gɛɛŋ wu faa bo a kibuu ki yeh yi ncha ki antɛŋ le, wu kaaŋ bikaa biboo yi kinfaŋa le. ");
INSERT INTO ncr_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Lɛ to nyume njɛ antaŋ antɛnɛɛ, Bol bɛ Sila buune bo yɛɛnɛ bo yuuse Nyo, bamii bancha yege, ");
INSERT INTO ncr_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","nshɛŋ ja yi shiŋshɛ bɛ bvuŋga, yeh yi ncha shiŋshɛ yi gɛɛŋ yi bu yi kichi le. Kimimia, de yi fese yichii gwenyɛ, bancha faanyɛ yi bamii bancha le bachii. ");
INSERT INTO ncr_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Muh wù gɛ̀ chiɛɛne yeh yi ncha yiyu kaŋsɛ, wu doo wu yɛŋ lɛ de yi fese le yi gwenyɛ wa, wu mo wu tu wu kwaji lɛ bamii bancha baa le bo legɛ wa. Wu mo wu baa nyo a ŋku le lɛ wu yuuyɛ kikwɛɛ ke yu. ");
INSERT INTO ncr_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Bol waŋ fɛwɛɛwe wu jɛmɛ lɛ, “Keefɛ wo yûuyɛ kikwɛɛ kuŋ gɛ. Bee le fɛnɛ bee bachii.” ");
INSERT INTO ncr_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Muh wù gɛ̀ chiɛɛne yeh yi ncha yɛɛ tɛɛŋ muh, wu to bɛ kin'yesɛ, wu legɛ wu lee yeh, wu gɛɛŋ wu tuŋ anyuu a Bol bɛ Sila fwe wu koge bɛ nfaaŋ. ");
INSERT INTO ncr_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Wu ja wu jo bo, bɛ bo bu akfuuŋ, wu biih bo le lɛ, “Ba chii, taŋlo ŋge nɛɛ fɛ mbonɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bo chvuu wu le lɛ, “Leesɛ fitele yi Tada Jiso le, bena bamii ba le a wo yeh bɛŋ ge bɛŋ bonɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Bo mo bo fejɛ saaka wu kune Tada fɛ bamii ba a wu yeh le. ");
INSERT INTO ncr_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Wu jo bo gɛh kitaŋ kiyu le, wu chugɛ banfu baboo. Kimimia, bo mo bo leesɛ wu bɛ bamii be bachii ba a wu yeh a joo. ");
INSERT INTO ncr_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Wu mo wu jo bo, bɛ bo bɛɛŋ a wu yeh, wu nya mwɛɛ munjile bo ji. Bɛ bamii bachii ba a wu yeh mo bo tu bo laŋeye lɛ bo le bo lee wa muntele yi Nyo le. ");
INSERT INTO ncr_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Akfuuŋ bu ayuu, bala wu Lum wɛɛ wu gɛ̀ sage bansa tuŋ bamii ba nchi lɛ bo gɛɛŋ bo du muh wù chiɛɛne yeh yi ncha yɛɛ le lɛ wu bvusɛ bamii baa bo gɛ̂ɛne. ");
INSERT INTO ncr_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Muh wù gɛ̀ chiɛɛne yeh yi ncha yiyu mo wu gɛɛŋ wu yɛŋ Bol le, wu jɛmɛ wu le lɛ, “Bala le wu tuŋ ntuŋ lɛ ba bvusɛ bɛŋ, bɛŋ gɛ̂ɛne yi kimbonɛ le.” ");
INSERT INTO ncr_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Geenɛ, Bol jɛmɛ bamii ba nchi baa le lɛ, “Ba chi ba suŋ bee fɛ waaŋ, ba baaŋ sagɛ nsa wese gɛ, bee nyu tɛ bamii ba Lum, ba ka ba faa bee yeh, bo jɛme mɛɛse lɛ ba bvusɛ bee ajiŋ ajiŋ nɛ nɛɛ? Gɛ taŋlo fi kooshɛ noo gɛ. Le ge to gɛh bala wuyu fɛnɛ fɛ wu bvusɛ bee.” ");
INSERT INTO ncr_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Bamii ba nchi baa kaasɛ bo tu jiŋ, bo gɛɛŋ bo sɛɛŋ bala wu Lum wɛɛ le no Bol jɛmɛ. Bo yu lɛ Bol bɛ Sila le tɛ bamii ba Lum, bo mo bo tu bo faane. ");
INSERT INTO ncr_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Bo mo bo to bo ku chiaaŋ bo le, bo bvusɛ bo yeh yi ncha le, bo chiiŋsɛ bo, bo lɛgɛ bo lɛ bo ja a kilaantɛŋ kɛɛ le. ");
INSERT INTO ncr_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Bol bɛ Sila bu yeh yi ncha le, bo gɛɛŋ a Lidia yeh, bamii ba mbɛmɛ nyu yu. Bo teefe bo, bo mo bo ja yo. ");
INSERT INTO ncr_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Bol bɛ Sila mo bo ja bo gɛɛne, bo fe a bilaantɛŋ bì Anfiboli bɛ Abolonia le, bo daŋsɛ bo gɛɛŋ bo bu Tɛsalonika, fɛ yeh yi buunɛ yi Bajuu gɛ̀ bee fo. ");
INSERT INTO ncr_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Bol mo wu gɛɛŋ wu lee yeh yi buunɛ le, gɛh no kinche ke gɛ̀ bee, wu tu wu too wu jɛme bamii le yu, yi aju a yuuŋ le atade, wu duunyi fiɛɛ fichii a Ŋwa wu Nyo le. ");
INSERT INTO ncr_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Wu tu wu naji yo, wu chiɛɛyi lɛ Mbvusɛ wù Nyo gɛ̀ ka gɛ̀ kɛme ki wu yɛ̂ŋ ŋgɛ, wu kaasɛ wu bu yi kwe le. Jiso wunɛ wù wu feeji kune wu, le Mbvusɛ wɛɛ. ");
INSERT INTO ncr_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Lɛ bamii bamu yu noo, bo taa fɛ Bol bɛ Sila le. Baglek bamu ba gɛ̀ ŋgvuune Nyo mo bikɛse ba baaŋ baaŋ bamu gɛ̀ bɛɛŋ tɛ bo duude. ");
INSERT INTO ncr_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Geenɛ, Bajuu bamu mo bo tu bo bɛɛne kindoŋ Bol bɛ Sila le, bo kuŋ bamii bamu bo shee gɛh nɛ achiji bɛ bo taashɛ yi kinchvu le, bo kɛ jwe alaantɛŋ. Bo mo bo ja bo gɛɛŋ bo ŋgodɛ yeh yi Jasoŋ bo goone Bol bɛ Sila ki bo bvusɛ bo, bo nya bamii le akfuuŋ. ");
INSERT INTO ncr_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Bo doo bo gooŋ sɛŋ, bo mo bo chii Jasoŋ bɛ bamii ba mbɛmɛ bamu bo gɛɛŋ bɛ bo fwe fɛ bachiji ntɛ le, bo tu bo wanɛ bo duu lɛ, “Bamii banɛ le bo jiɛnyi bo fiise woŋ tuu anfisɛ, bo to wa bo bu yanɛ, ");
INSERT INTO ncr_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jasoŋ fi bo, wu gɛɛ a wu yeh. Bo bachii ŋgode banchi ba Nfoŋ wu Lum, bo duu lɛ Nfoŋ wumu le yu jee che nyu lɛ Jiso.” ");
INSERT INTO ncr_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Bachiji ntɛ bɛ bamii yu noo, bo ja bo tu bo wɛɛse lo. ");
INSERT INTO ncr_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Bo mo bo kaaŋ Jasoŋ bɛ bamii ba mbɛmɛ bo nya bige lɛ, fi ka kooshɛ lo, bo gɛ ka bo kaasɛ bo chvuu bige biyu bo le gɛ. Bo mo bo chinɛ bo le lɛ bo gɛɛne. ");
INSERT INTO ncr_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Akfuuŋ gɛ̀ doo ajiiŋ, bamii ba mbɛmɛ jo Bol bɛ Sila bo chiiŋsɛ bo tu bo gɛɛne a kilaantɛŋ kì Bɛlia le. No bo lese yo, bo gɛɛŋ yeh yi buunɛ yi Bajuu le. ");
INSERT INTO ncr_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Bajuu ba yo gɛ̀ bee bamii ba gɛ̀ kee fiɛɛ bo fede ba Tɛsalonika, nje bo gɛ̀ fi n'yɛyɛ chuule bɛ kiŋkoŋɛ, bo tu bo taade a Ŋwa wu Nyo le aju achii ki bo yɛŋ laa mwɛɛ mù Bol yɛyi bo yu le nchiɛɛŋ lɛ. ");
INSERT INTO ncr_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Bo mo bo bɛɛŋ jɛ yi Nyo le wesee. Bikɛse ba baaŋ baaŋ ba duude ba gɛ̀ bee Baglek mo bilɛŋsɛ ba duude ba gɛ̀ bee tɛ Baglek bo bɛɛŋ tɛ. ");
INSERT INTO ncr_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Geenɛ, Bajuu ba Tɛsalonika gɛ̀ yu lɛ Bol le wu gɛɛŋ wa wu tu wu feeji jɛ yi Nyo Bɛlia, bo mo bo gɛɛŋ tɛ yo, bo bɛɛse kinchvu ki bamii bo kɛ jwe. ");
INSERT INTO ncr_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Bamii ba mbɛmɛ mo bo jɛmɛ lo Bol le kimimia wu gɛɛŋ june wu joo yì baaŋ le. Geenɛ, Sila bɛ Timoti shɛɛ Bɛlia. ");
INSERT INTO ncr_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bamii ba gɛ̀ gɛnɛ ki bo chiiŋsɛ Bol, bo gɛɛŋ bo bu Atɛŋ bo mo bo chinɛ wu le. Bo doo bo tuu jiŋ, Bol tuŋ bo lɛ bo gɛɛŋ bo fejɛ Sila bɛ Timoti le lɛ bo moŋ ki bo bi wu le chige. ");
INSERT INTO ncr_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Bol mo wu chiɛɛne Sila bɛ Timoti Atɛŋ. Wu gɛ̀ doo wu jiɛnyi yo, wu yɛŋ kilaantɛŋ kiyu ki yisɛ bɛ mumooso. Fi shiŋshɛ fitele fie. ");
INSERT INTO ncr_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Wu mo wu gɛɛŋ yeh yi buunɛ yi Bajuu le, wu jɛme bɛ bo mo bamii ba gɛ̀ bee gɛ Bajuu gɛ ba gɛ̀ buunɛ tɛ Nyo fo. Wu ka wu jɛme aju achii fɛ waaŋ bamii ba gɛ̀ jade bo too fo le. ");
INSERT INTO ncr_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bamii ba n'yɛyɛ bamu ba bo gɛ tɛŋe lɛ Ɛbikoliaŋ mo ba bo gɛ̀ tɛŋe lɛ Sitok bo ja bo tu bo tɛɛnyi tɛ kintɛɛnyɛ bɛ ba Bol. No Bol gɛ̀ feeji kune Jiso bɛ bu yi kwe le, bamu mo bo tu bo biide lɛ, “Kiyuŋ kinɛ kune jwe yi la le?” Bamu tu bo duu fiboo lɛ, “Fi yɛnɛ gɛh njɛ wu feeji kune banyo ba bamii bamu.” ");
INSERT INTO ncr_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Noo, bo mo bo jo Bol bɛ bo gɛɛŋ fɛ kinshilɛ kì ba gɛ̀ tɛŋe lɛ Aleobagu, Bo du wu le lɛ, “Bee goone ki bee ka be yu kune n'yɛyɛ wu fwɛŋ wunɛ wù wo too bɛ wu laa wu duu lɛ la lɛ. ");
INSERT INTO ncr_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Wo jɛmɛ mwɛɛ mu bee gɛ̀ baaŋ a yu gɛ. Noo, bee goone ki be kɛɛ kinyi kiyu.” ");
INSERT INTO ncr_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Bamii ba Atɛŋ mo bantolo ba yo bo tu bo nyu fiboo ki bo shee bo yuge nyu mwɛɛ mu munfɛŋ, mu bo jɛme kune mu.) ");
INSERT INTO ncr_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Bol mo wu lɛɛŋ fwe a kinshilɛ kì Aleobagu kɛɛ le, wu jɛmɛ lɛ, “Bamii ba Atɛŋ, n'yɛnɛ lɛ a jé le yichii bɛŋ ŋgvuune banyo baŋaa. ");
INSERT INTO ncr_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Njɛme nɛ, nje nchi njiɛnyi a kilaantɛŋ kena le, ndoo njiŋɛ manjuu mà bɛŋ buune banyo mo le, n'yɛŋ kitana ki kintanyɛ kimi le ba saŋ yi yu le lɛ, ‘Fɛ nyo wù ba kee gɛ le.’ Nyo wuyu wù bɛŋ buunɛ, bɛŋ kee gɛ, le wu wù nlé nfêjɛ bɛŋ le mɛ̂ɛse. ");
INSERT INTO ncr_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Nyo wuyu le wu wù gɛ̀ fɛ woŋ kfunɛ bɛ mwɛɛ munchii mù le yi wu le. Le wu wu le Nfoŋ wu kibvulɛ bɛ nshɛŋ, gɛ wu chee yéh yi kintanyɛ yì jonɛ bamii le gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Gɛ wu fuge fiɛɛ fimi fì wu jiiŋe lɛ muh lɛŋ fɛ wu le gɛ, nje le wu wù gee bamii bachii bo yɛneh, bo nyu yu, bo kɛme fiɛɛ fichii fì bo goone. ");
INSERT INTO ncr_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Wu gɛ̀ bee wu ge chikfuu chi bamii chichii bu yi muh le wu mumwaa bo tu bo nyu yi kikwɛɛ ki nshɛŋ le. Fɛ wu ge noo, gɛ̀ bee wu seesɛ wa kife kì bo lé bo gê bo nyûme yu, mo bijwii bi manjuu ma bo lé bo gê bo chêe mo le. ");
INSERT INTO ncr_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Wu gɛ̀ ge noo, lɛ bamii ge bo ghaade laa bo lé bo gê bo yû bo yɛ̂ŋ wu le lɛ. Geenɛ, gɛ Nyo nyu je yì ndefe le fɛ muh lɛ bɛŋ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Finɛ le gɛh yɛɛŋyɛɛŋ no muh mu gɛ̀ jɛmɛ wa lɛ, ‘Le wu wù gee fɛ besabɛŋ chee, bee ka jiɛnyi, bee ka nyume no besabɛŋ le.’ Muh wene wu binfɛ wumu gɛ̀ jɛmɛ wa tɛ lɛ, ‘Besabɛŋ le booŋ be.’ ");
INSERT INTO ncr_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","No besabɛŋ le booŋ ba Nyo noo, keefɛ besabɛŋ kwaji lɛ Nyo fiɛɛnɛ fiɛɛ fì seese muh bɛ bvufee bwe gɛ, fì ba suŋ bɛ kichwa ki bige gɛ, kɛnɛ ba kɛnyɛ lo bɛ tɛdɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Gɛ̀ bee kife kì bamii gɛ̀ baaŋ kijibɛ le, bo gee mwɛɛ mù mbefe munɛ, Nyo nchînɛ yu. Geenɛ, mɛɛse wu duu lɛ bamii bachii kusɛ muntele muboo. ");
INSERT INTO ncr_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Bo kûsɛ nje wu le wu gɛɛ juu chì wu lé wu gê wu sâ woŋ wuchii wu bii nchiɛɛŋ le. Wu le wu cha wa muh we wù lé wu gê wu sâge. Finɛ le wu dunyɛ wa bamii le bachii lɛ le nchiɛɛŋ no wu gɛ̀ bvusɛ muh wɛɛ yi kwe le.” ");
INSERT INTO ncr_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","No Bol jɛmɛ noo, bo yu, wu bɛɛŋ kune mbu yi kwe le, bamii bamu ja bo tu bo keede lo wu. Bamu jɛmɛ fiboo lɛ, “Bee goone ki be ka be yu kune fiɛɛ fì wo jɛme finɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Noo, Bol mo wu bu wu chinɛ bo le. ");
INSERT INTO ncr_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Geenɛ, bamii bamu bɛɛŋ fiɛɛ fì wu gɛ̀ jɛme le, bo taa fɛ wu le. Muh mu bo le gɛ̀ bee Dionisiu wù gɛ̀ bee muh wu kinshilɛ ki Aleobagu, wumu nyu kwɛse jee che nyu lɛ Damale mo bamii bamu tɛ. ");
INSERT INTO ncr_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ajiŋ ayu, Bol ja Atɛŋ wu gɛɛŋ a kilaantɛŋ kì Kolɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","No wu gɛ̀ gɛnɛ yo, bɛ muh wu Bajuu wumu tasɛ jee che nyu lɛ Akwela, ba gɛ̀ boyi wu Bontu. Akwela bɛ Blisila wù kwɛɛ baaŋ gɛh no bo ja Itali, nje Klawdiu wù Nfoŋ wu Lum gɛ̀ bee wu bvusɛ nchi lɛ Bajuu bachii bu yo. Bol gɛ̀ la jigɛ a bo le, ");
INSERT INTO ncr_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Wu doo wu yɛŋ lɛ bo kɛɛnyi jé yì bo saŋe chúŋ yu, gɛ̀ bee tɛ lɛme chì wu wù Bol gɛ̀ chee nje chi, wu mo wu tu wu chee fo, bɛ bo lɛne. ");
INSERT INTO ncr_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Lɛ to nyume aju a yuuŋ le achii, wu gɛɛne yeh yi buunɛ le, wu jɛme bɛ Bajuu mo Baglek bo gɛ̀ bee yu, wu mone ki wu gê bo bɛ̂ɛŋ fiɛɛ fì wu yɛyi le. ");
INSERT INTO ncr_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sila bɛ Timoti gɛ̀ doo bo ja Masɛdonia bo to, Bol mo wu jo kife ke kichii wu tu wu feeji nyu jɛ yi Nyo, wu duunyi Bajuu le, lɛ Mbvusɛ wù Nyo gɛ̀ ka le Jiso. ");
INSERT INTO ncr_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Geenɛ, Bajuu bayu gɛ̀ ja bo tɛɛnyi fiɛɛ fì wu gɛ̀ jɛme le, bo tu bo naanyi wu. Wu mo wu sɛsɛ njú ye wu jɛmɛ bo le lɛ, “Kwe yene nyûme chiaaŋ yene le. Gɛ chiaaŋ yaŋ nyu fo gɛ. Kɛge yi mɛɛse le, nlé ŋgɛ̂ɛne wa nyu a bamii ba le gɛ Bajuu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Wu mo wu chinɛ bo le, wu bu wu gɛɛŋ wu tu wu chee wa nyu bɛ muh mu wu le gɛ muh wu Bajuu gɛ, muh wɛɛ gɛ̀ ŋgvuune Nyo. Jee che gɛ̀ bee lɛ Titiu Justu, la che nyu mbebe yeh yi buunɛ le. ");
INSERT INTO ncr_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Klisbu wù kikwɛɛ ki yeh yi buunɛ, bɛ bamii bachii ba a wu yeh gɛ̀ leesɛ muntele yi Tada le. Bamii ba Kolɛŋ ba duude tu bo yuge no Bol feeji kune Jiso, bo bɛmɛ, ba leese bo a joo. ");
INSERT INTO ncr_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Lɛ to nyu kitaŋ kimi le, Tada jɛme Bol le a fiɛɛ le njɛ kifilɛ le lɛ, “Keefɛ wo fâane gɛ, wo fêeji gɛh jɛ yaŋ wo gɛɛne bɛ yi. Keefɛ wo lû gɛ, ");
INSERT INTO ncr_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","nje nle besa wo, gɛ muh nyu yu wù taŋlo wu gê fiɛɛ bɛ wo gɛ. Bamii baŋ le a kilaantɛŋ kinɛ le wesee.” ");
INSERT INTO ncr_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Noo, Bol tu wù nyu yo yi kiluŋ le bɛ kimbɛge, wu yɛyi bamii bɛ jɛ yi Nyo. ");
INSERT INTO ncr_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","No Bol gɛ̀ bee yo, Galio gɛ̀ doo wù nyu muh wù sage kimbe kì Akɛya le, Bajuu banyɛ ye bo koo wu bo gɛɛŋ bɛ wu yeh yi nsa le, ");
INSERT INTO ncr_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","bo jɛmɛ Galio le lɛ, “Muh wunɛ mone ki wu fîise bamii lɛ bo bûunɛ Nyo a je yimi le yeye nyu gɛ no nchi goone gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Bol ja lɛ wu jɛmɛ, Galio ja wu jɛmɛ Bajuu baa le lɛ, “Bajuu bɛŋ yu, fiɛɛ finɛ be bee fiɛɛ fimi fì befe fì muh wunɛ le wu ge, kɛnɛ le nchi wumu wù wu ŋgode, tu mbe ŋkaaŋ shɛ́ŋ n'yegɛ fiɛɛ fì bɛŋ jɛme le. ");
INSERT INTO ncr_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Geenɛ, no fiɛɛ finɛ le gɛ kintɛɛnyɛ kune jɛ́ bɛ ajee no banchi bena le, bɛŋ sêesɛ lɛbɛŋlɛbɛŋ. Gɛ taŋlo nsâ finɛ fiɛɛ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","No wu jɛmɛ noo, wu mo wu kuŋ bo, bo bu yeh yi nsa le. ");
INSERT INTO ncr_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Bo bachii mo bo ja bo lee yi Sostɛne wù gɛ̀ bee kikwɛɛ ki yeh yi buunɛ le, bo mo bo suŋ wu a yeh yi nsa fwe. Galio gɛ kwe lo fie fiɛɛ fo gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Ajiŋ ayu, Bol ka wu che Kolɛŋ bɛ bamii ba mbɛmɛ yi aju le wesee, wu mo wu ja wu chinɛ bo le bɛ ba Blisila mo Akwela bo lee a ŋguh wu a joo le ki bo gɛɛŋ Silia. Fɛ bo ja Sɛŋkliya fɛ bo gɛ̀ lɛsɛ a ŋguh le fo, Bol mu kikwɛɛ nje ŋka wù wu gɛ̀ ge fɛ Nyo le. ");
INSERT INTO ncr_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Bo mo bo gɛɛne, lɛ bo gɛɛŋ bo bu Ɛfɛsu, Bol chinɛ Blisila bɛ Akwela le yo, wu ja wu gɛɛŋ fie nyu yeh yi buunɛ yi Bajuu le, wu jɛmɛ Bajuu le yu. ");
INSERT INTO ncr_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Bo lɛgɛ lɛ wu ka wu che gɛh bɛ bo aju a duude le, wu faŋ. ");
INSERT INTO ncr_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Geenɛ, wu gɛ̀ doo wu jade, wu jɛmɛ bo le lɛ, “Nlé ŋgê ŋkâasɛ nto fɛ bɛŋ le fɛ Nyo nɛ le wu bɛɛŋ.” No wu jɛmɛ noo, wu mo wu lee a ŋguh le wu ja Ɛfɛsu. ");
INSERT INTO ncr_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ŋguh gɛ̀ gɛɛŋ wu bu Kasalia, Bol bu, wu bɛɛŋ wu gɛɛŋ wu yɛsɛ kintaashɛ ki bamii ba mbɛmɛ le Yɛlusalɛm, wu mo wu ja wu boh Antiok. ");
INSERT INTO ncr_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Wu gɛ̀ che yo kife kɛŋsɛ, wu mo wu kaasɛ wu ja wu jiɛnyi wu fede a bimbe bì Galɛshiaŋ bɛ Fligia le, wu kaŋse muntele mu bamii ba mbɛmɛ ba yo. ");
INSERT INTO ncr_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Muh wu Bajuu wumu gɛ̀ ja wu to Ɛfɛsu jee che nyu lɛ Abolo, ba gɛ̀ boyi wu Alɛksanda. Gɛ̀ bee muh wù kee njɛmɛ, wu kee tɛ Ŋwa wu Nyo chuule. ");
INSERT INTO ncr_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ba gɛ̀ yɛyɛ wa wu bɛ Je yì Tada duunyi, wu mo wu fiee lo bɛ n'yɛyɛ kune Jiso, wu yɛyi bamii chuule. Geenɛ, wu gɛ̀ kee gɛh nyu fiɛɛ fì Joŋ gɛ̀ feeji wu leese bamii a joo. ");
INSERT INTO ncr_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","No wu gɛ̀ to Ɛfɛsu, wu mo wu kɛ wu yɛyi bamii yeh yi buunɛ le wu faane gɛ. Blisila bɛ Akwela gɛ̀ yu no wu yɛyi noo, bo mo bo jo wu, bo gɛɛŋ bo ka bo yuusɛ wu wesee kune Je yì Nyo duunyi. ");
INSERT INTO ncr_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Abolo gɛ̀ ja wu kwaji lɛ wu lé wu dâŋ wu gɛ̂ɛŋ kimbe kì Akɛya le. Bamii ba mbɛmɛ ba Ɛfɛsu mo bo fih wu, bo saŋ ŋwa fɛ ŋgoo yi bamii ba mbɛmɛ ba Akɛya le, bo toone lɛ wu doo wu fɛsɛ bo fîh wu. No wu gɛ̀ gɛnɛ yo, wu fih bamii ba mbɛmɛ chuule, bamii banɛ le bo ba Nyo gɛ̀ dunyɛ fitele fì joŋe, wu fɛ bo leesɛ muntele yi Jiso Kletu le. ");
INSERT INTO ncr_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Wu tu wu tɛɛnyi kintɛɛnyɛ bɛ Bajuu nɛ waaŋ nyume gɛ kì shige shige gɛ, wu soo bo, wu duunyi a Ŋwa wu Nyo le lɛ Jiso le Mbvusɛ wù Nyo gɛ̀ ka. ");
INSERT INTO ncr_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Gɛ̀ bee sege Abolo gɛ̀ bee Kolɛŋ, Bol gɛ̀ jo je yì antɛŋ antɛŋ a bimbe bì wu gɛ̀ jiɛnyi yo le, wu fɛsɛ Ɛfɛsu. No wu fɛse yo, wu yɛŋ ŋgoo yi bamii ba mbɛmɛ bamu le, ");
INSERT INTO ncr_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","wu biih bo le lɛ, “Kiyo ki Yuude gɛ̀ bee ki to yi bɛŋ le sege bɛŋ gɛ̀ lesɛ muntele yi Jiso le?” Bo chvuu lɛ, “Bee gɛ̀ baaŋ a yugɛ mbɛŋ lɛ fiɛɛ fimi le Kiyo ki Yuude gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Bol biih lɛ, “Finɛ le noo, ba gɛ̀ leese bɛŋ a joo nje la?” Bo chvuu lɛ, “Ba gɛ̀ leese bee a joo ba bii no Joŋ gɛh feeji.” ");
INSERT INTO ncr_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Bol mo wu jɛmɛ bo le lɛ, “Joŋ gɛ̀ leese bamii a joo, ki wu dûnyɛ lɛ bo le bo kusɛ muntele muboo, wu gɛ̀ duu lɛ bo bɛ̂ɛŋ nyu muh wù too a wu jiŋ le, muh wù wu gɛ̀ duu gɛ̀ bee Jiso.” ");
INSERT INTO ncr_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Bamii bayu yu no Bol jɛme noo, ba mo ba leesɛ bo a joo nyu wa a jee chi Tada Jiso le. ");
INSERT INTO ncr_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Bol gɛɛ chiaaŋ yi bo le, Kiyo ki Yuude mo ki to yi bo le. Bo mo bo ja bo tu bo jɛme jɛ́ yì bo kee gɛ, bo mo bo sɛŋe bamii mwɛɛ mù bo yuge Nyo jɛme. ");
INSERT INTO ncr_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bamii bayu gɛ̀ bee njɛ muh yuufe ncho bafɛɛ. ");
INSERT INTO ncr_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Bol mo wù nyu gɛh Ɛfɛsu, wu gɛɛne yeh yi buunɛ le yi kii le yi tɛde, wu jɛme bamii bayu le wu faane gɛ. Bɛ bo tu bo tɛɛnyi kintɛɛnyɛ, wu mone ki wu gê lɛ bo bɛ̂ɛŋ fiɛɛ fì wu jɛme kune bvunfoŋ bvu Nyo. ");
INSERT INTO ncr_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Bamii bamu tɛmɛ bikwɛɛ bo faŋ ki bo bɛɛŋ, bo mo bo tu bo jɛme jɛ́ yì befe a bamii jii kune Je yi Tada. Bol mo wu chinɛ bo le, wu jo ŋgoo yi bamii ba mbɛmɛ, bɛ bo gɛɛŋ nyu yeh yi n'yɛyɛ yi Talanu le, wu tu wu jɛme bo le yu aju achii. ");
INSERT INTO ncr_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Bol ge noo yi biluŋ le bifɛɛ. Noo, Bajuu mo Baglek bachii ba woŋ wù Ɛsia wuyu le yu jɛ yi Tada. ");
INSERT INTO ncr_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Bol tu wù nyu, Nyo gee, wu fɛde biŋgha bi mwɛɛ nyu lo mu de yì yunɛ. ");
INSERT INTO ncr_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Bo gɛ̀ jode fiɛɛ fie fi ye le njɛ finchaŋa fi nju, kɛnɛ nju ye yi lɛme, bo gɛɛŋ bo kuŋ muh wu kinchɛŋ yu, wu mo wu tɛmɛ lo, nɛ le wù kɛme kiyo kì befe yi ye ye le, ki mo ki bû. ");
INSERT INTO ncr_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Bajuu bamu bo gɛ̀ bee bo jiɛnyi bo bvuuse biyo bì befe yi bamii le, bo mo bo ja bo tu bo mone ki bo tɛŋe jee chi Tada Jiso, fɛ bo bvuuse biyo biyu. Muh gɛ̀ jade wu mo wu jɛmɛ kiyo kì befe le lɛ, “Mbvuuse wo a jee chi Jiso wù Bol feeji le.” ");
INSERT INTO ncr_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Bamii ba gɛ̀ mone fiɛɛ fiyu gɛ̀ bee bvusooshwi, gɛ̀ bee booŋ ba Sikɛfa wù kikwɛɛ ki bachiji kintanyɛ ki Bajuu. ");
INSERT INTO ncr_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Kiyo kì befe gɛ̀ biih bo le lɛ, “Ŋkee Jiso, ŋkee tɛ Bol, bɛŋ le fiena baaŋ?” ");
INSERT INTO ncr_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Muh wu kiyo kì befe kiyu gɛ̀ bee yi ye ye le mo wu gwe lo yi bamii bayu le, wu gosɛ bo kuu, bo fɛɛ lo bo bu a muh wuyu yeh bo nyu wa bichinɛ biyɛse bɛ banfu ye le. ");
INSERT INTO ncr_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Bajuu bɛ Baglek bachii bo gɛ̀ chee Ɛfɛsu yu kune fiɛɛ fiyu, bo tu bo faane. Bamii mo bo ŋgvuune jee chi Tada Jiso fede lo. ");
INSERT INTO ncr_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Bamii ba duude ba gɛ̀ bee wa bamii ba mbɛmɛ tu bo too bo sɛŋe bo ka bwaashi mwɛɛ mu kijibɛ le mù ba gɛ̀ gee. ");
INSERT INTO ncr_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bamu wesee bò gɛ̀ fɛde ŋgaŋ, bo baanyɛ baŋwa baboo ba ŋgaŋ, bo to bɛ bo, bo toŋ a bamii jii. Bo taŋ kwa wu baŋwa bayu bachii, wu bu njɛ ajii a bige banchvuge mbaanshɛŋ (50,000). ");
INSERT INTO ncr_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Noo, mwɛɛ munɛ, ge jɛ yi Tada tu yi leese a muntele mu bamii le bɛ bvuŋga, yi saaŋe yi gɛɛne lo fwe fwe. ");
INSERT INTO ncr_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Lɛ tu nyume ajiŋ ayu, Bol yɛŋ lɛ wu lé wu gɛ̂ɛŋ Yɛlusalɛm, fi le lɛ wu doo wu gɛɛne, wu fe je bimbe bì Masɛdonia bɛ Akɛya le. Wu ka wu du lɛ, “Ndoo ŋgɛɛŋ mbu Yɛlusalɛm, ŋkɛme ki ŋgɛ̂ɛŋ tɛ mbû Lum.” ");
INSERT INTO ncr_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Wu ya wu tuŋ bamii bafɛɛ, Timoti bɛ Ɛlastu ba gɛ̀ fii wu, bo gɛɛŋ fwe Masɛdonia. Wu shɛɛ wu ka wu che Ɛsia shige. ");
INSERT INTO ncr_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Lɛ nyu gɛh kife kiyu le, ŋgɛ ja wu kɛ Ɛfɛsu kune Je yi Tada, nyume gɛ wù shige gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Chiji kilamɛ wumu gɛ̀ bee yo, jee che nyu lɛ Dɛmitiyu, wu suŋe mwɛɛ mù fiɛɛnɛ yeh yi kintanyɛ yi nyo wù ba tɛŋe lɛ Atɛmi. Lɛme chiyu chinɛ chi too bɛ bige fɛ bamii ba tonɛ kilamɛ le nyume gɛ bi wɛɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Dɛmitiyu mo wu kuŋ bamii ba gɛ̀ tonɛ kilamɛ baa bachii mo bamii ba gɛ̀ lɛne kfuu chi lɛme chiɛɛ, bo taashɛ. Wu jɛmɛ bo le lɛ, “Booŋ ba bwɛɛŋ, bɛŋ kee lɛ lɛme chinɛ le besabɛŋ ŋode lo bige yi chi le. ");
INSERT INTO ncr_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Bɛŋ yɛne bɛŋ ka yuge fiɛɛ fì fimbwɛ fì Bol finɛ gee. Wu jiɛnyi wu duu lɛ gɛ banyo ba bo kɛnyi lo bɛ chiaaŋ nyu banyo gɛ. Wu le wu ge wa noo, wu kaase bvufee bvu bamii wesee Ɛfɛsu yanɛ, wu tu fiise wa tɛ bvu bamii ba Ɛsia bachii ba bɛme wu le. ");
INSERT INTO ncr_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","N'yɛde lɛ lɛme chesa chinɛ le chi kɛme jee chì befe. Gɛ mɛ gɛh noo gɛ, yeh yi kintanyɛ yi nyo wù baaŋ wù kwɛse wu Atɛmi le tu fiɛɛ fì achiji. Fi kooshi lo noo, tu bo choosɛ wa nyo wu baaŋ wunɛ wu bo ŋgvuune Ɛsia achii, kikwɛɛ ki nshɛŋ kichii ŋgvuune tɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","No bamii bayu yu noo, muntele bɛde lo bo. Bo mo bo kɛ bo tu bo wanɛ, bo duu lɛ, “Atɛmi wu Ɛfɛsu le nyo wu baaŋ.” ");
INSERT INTO ncr_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kilaantɛŋ kiyu kichii mo ki saa. Kinchvu ki bamii kì to ki taashɛ ki mo ki lêe yi Gayu bɛ Alistaku le, gɛ̀ bee bamii ba Masɛdonia ba gɛ̀ jiɛnyi bɛ ba Bol, ki chii bo ki gɛɛŋ bɛ bo yeh yi nshilɛ le bɛ ŋgvunɛ. ");
INSERT INTO ncr_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Bol goone ki wu lêe wu gɛɛŋ fwe a kinchvu kiyu, bamii ba mbɛmɛ lɛ faŋ. ");
INSERT INTO ncr_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Bamii bamu ba baaŋ baaŋ ba yo ba kɛme woŋ bo gɛ̀ bee nsáa ye, bo ka bo chiiŋsɛ ntuŋ fɛ wu le bo lɛgɛ lɛ keefɛ wu môŋ lo wu tômɛ kikaa yu gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Kinchvu kì gɛ̀ taashɛ kiyu mo ki ja ki saa ki tu ki wanɛ gɛh lo nchɛ nchɛ. Banɛ wanɛ finɛ, baga wanɛ fiege. Gɛ̀ bamii ba duude gɛ̀ kee lo fiɛɛ fì bo gɛ taashɛ fo nje fi gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Bajuu mo bo jo Alɛksanda bo feesɛ wu fwe a kinchvu ki bamii, bamii bamu yɛŋ bo tu bo kwaji lɛ wu kee fiɛɛ fo. Wu tu wu chide bamii bɛ kibo ki wu tânyɛ jwe we. ");
INSERT INTO ncr_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Bamii bayu gɛ̀ doo bo kɛɛ lɛ Alɛksanda le muh wu Bajuu, bo ka bo mɛɛse bo wanɛ lo bo gɛɛne fwe fwe yi muh le wu mumwaa, bo duu lɛ, “Atɛmi wu Ɛfɛsu le nyo wù baaŋ.” Bo gɛ̀ waŋ noo, gɛɛŋ bu bantaŋ ba kife lɛ bafɛɛ. ");
INSERT INTO ncr_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Muh wu saŋe wu a kilaantɛŋ kiyu le gɛ̀ ja wu chi bo, bo lu bɛ jwe. Wu biih bo le lɛ, “Bamii ba Ɛfɛsu, muh le yu wù maŋe lɛ gɛ̀ kɛme bee ba Ɛfɛsu banɛ yeh yi kintanyɛ yi nyo wù Atɛmi mo tɛdɛ chi nyo chì gɛ gwe fɛwe le gɛ? ");
INSERT INTO ncr_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","No muh ya yu wù taŋlo wu tɛɛnyɛ finɛ fiɛɛ gɛ, tu bɛŋ bee bɛŋ laame, bɛŋ gɛ ya bɛŋ yufe nɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Bɛŋ to bɛ bamii banɛ fɛnɛ njɛ bo le bo choŋ fiɛɛ yeh yi banyo le sɛŋ, kɛnɛ njɛ bo le bo jɛmɛ jɛ́ yì befe kune nyo wese wù kwɛse wunɛ sɛŋ. ");
INSERT INTO ncr_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Dɛmitiyu bɛ bamii be nɛ kɛme nsa bɛ muh, tu aju a nsa le yu, taŋlo bo gɛɛŋ bo yɛŋ bamii ba sage bansa le, bɛ bo sa. ");
INSERT INTO ncr_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Fiɛɛ fimi nɛ ka nyume yu fì fede finɛ fì bɛŋ goone, tu ba lé ba jîŋɛ antɛnɛɛ ayu fɛ nshilɛ wu bachiji ntɛ le. ");
INSERT INTO ncr_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Njɛme nɛ, nje n'yɛde lɛ fiɛɛ fì abɛŋ finɛ lé fi lêe bee jwe le, lɛ bee le be kɛ ŋgɛ. Fi kooshi lo noo, bee gɛ ka be kɛme fiɛɛ fì kooji fì be chvûu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","No wu jɛmɛ noo, wu mo wu jɛmɛ kinchvu kiyu saaŋɛ. ");
INSERT INTO ncr_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ŋgɛ wù gɛ̀ bee Ɛfɛsu ka, Bol tɛɛŋ ŋgoo yi bamii ba mbɛmɛ, wu teefe bo wu mo wu yɛsɛ bo le, wu tu wu gɛɛne masɛdonia. ");
INSERT INTO ncr_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Wu gɛɛŋ, wu jiɛnyɛ bimbe bi yo le, wu kaŋse muntele mu bamii ba mbɛmɛ chuule wu mo wu daŋsɛ wu gɛɛŋ Glee, ");
INSERT INTO ncr_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","wu che yo kii yi tɛde. Wu gɛ̀ ja fi nyu lɛ wu lé wu gɛ̂ɛŋ wu lêe a ŋguh wu a joo le wu gɛɛŋ Silia, wu mo wu yu lɛ Bajuu weede wu a je. Wu mo wu yɛŋ lɛ joŋe lɛ wu kâasɛ wu tû jiŋ je yi Masɛdonia le. ");
INSERT INTO ncr_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Wu gɛ̀ jiɛnyi bɛ ba Sobata mwa Bilu wù Bɛlia, mo Alistaku bɛ Sɛkundu ba Tɛsalonika, mo Gayu wu Dɛbi, mo Timoti, mo Tichiku bɛ Tofimu ba gɛ̀ bee bamii ba Ɛsia. ");
INSERT INTO ncr_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Bamii banɛ mo bo gɛɛŋ fwe bo tu bo chiɛɛne besa ba Bol Towa. ");
INSERT INTO ncr_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ŋka wu Blɛd wù ba baaŋ gɛɛ gɛ Kinshilɛ yo gɛ fe, bee lee a ŋguh le Filibi, bee jo aju atɛŋ bee taa bo le Towa, besa bo che yo aju bvusooshwi. ");
INSERT INTO ncr_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Lɛ to nyu juu chi fwe yi kimaa le, bee tasɛ yi kintaashɛ le fɛnfu ki bee bwɛɛyɛ blɛd. No Bol gɛ̀ bee ki wu bû wu ja sege bvu yuu, wu mo wu kɛ wu jɛme bo le, wu jɛme shwaa gɛɛŋ bu antaŋ antɛnɛɛ. ");
INSERT INTO ncr_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Besa bo gɛ̀ bee nyu a kibuu ki yeh yi awe le, bin'yesɛ baaŋ yu wesee. ");
INSERT INTO ncr_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Chumu wumu wù jee che gɛ̀ bee Yutiku shii yi nto wu yeh yɛɛ le. Wu ja wu kɛ wu tu wu lefe, no Bol gɛ̀ jɛme wu gɛɛne gɛh lo. Lefe doo chi goge wa lo wu, wu mo wu ja fo wu gwe achiŋ, fo gɛ̀ bee yeh yi fɛwe yi shɛde kɛge fɛkuu. Ba gɛɛŋ ba jo wu a wu kwe wa. ");
INSERT INTO ncr_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Bol shii wu gɛɛŋ wu ŋgvuumɛ a wu we, wu kfugɛ wu, wu jɛmɛ bamii le lɛ, “Kiyo ke baaŋ yu, keefɛ bɛŋ bûge gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Bol ja wu kaasɛ wu bɛɛŋ a kibuu ki awe kɛɛ le, wu bwɛɛde blɛd wu ji, fɛ wu ka wu kɛ wu tu wu jɛme, wu tu wu jɛme bvuchvuu bu bvu yuu wu mo wu ja. ");
INSERT INTO ncr_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bamii gɛ̀ jo chumu wɛɛ bo kwɛɛ bɛ wu fɛ wu yeh le wù nyu wu tu wa wu wuŋe, muntele jɛde bo. ");
INSERT INTO ncr_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Bee gɛ̀ lee a ŋguh wu a joo le, bee gɛɛŋ Aso, no Bol gɛ̀ seesɛ wa lɛ le yo a bee lé be jô wu yo. Wu gɛ̀ jɛme noo, nje wu gɛ̀ goone ki wu jîɛnyɛ bɛ bikaa. ");
INSERT INTO ncr_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Wu taa bee le Aso, bee mo be jo wu a ŋguh le, besa bo gɛɛŋ bee bu Mitiliŋ. ");
INSERT INTO ncr_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Bee ja fo a ŋguh le, bvu bu bvu yuu, bee fɛsɛ mbebe Kio le, bee fe, bvu ka bvu yuu, bee fɛsɛ Samo, bee mo bee fe, bvu ka bvu yuu, bee lee Miletu. ");
INSERT INTO ncr_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Bee gɛ̀ jiɛnyi noo, bee wɛɛne lo Ɛfɛsu nje gɛ Bol gɛ goone ki wu fêesɛ kife Ɛsia gɛ. Wu gɛh gɛɛne chige chige laa taŋlo wù nyû Yɛlusalɛm juu chi Ŋka wu Bɛntɛko le lɛ. ");
INSERT INTO ncr_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Lɛ bee lee Miletu, Bol chiiŋsɛ ntuŋ fɛ bachiji kintaashɛ ki bamii ba mbɛmɛ le Ɛfɛsu lɛ bo tô bo yɛ̂ŋ wu le. ");
INSERT INTO ncr_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Bo gɛ̀ to, wu jɛmɛ bo le lɛ, “Bɛŋ kee no kinche kaŋ gɛ̀ bee besabɛŋ kɛge yi juu chi fwe chì ŋgɛ̀ ntomɛ kikaa yi nshɛŋ yi Ɛsia yinɛ le. ");
INSERT INTO ncr_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ŋgɛ̀ mbee nshiishɛ kikwɛɛ kaŋ, ntu nlɛne fɛ Nyo le bɛ joo ajii le. Ŋka n'yɛŋ baŋgɛ jé le wesee no Bajuu gɛ̀ boone bikaa a mɛ jiŋ. ");
INSERT INTO ncr_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Bɛŋ ka kee no ŋgɛ̀ n'yɛyi bɛŋ fɛ waaŋ, ŋka njiɛnyi n'yɛyi yéh le. Ŋgɛ mbaaŋ nyilɛ gɛ fiɛɛ fimi fì taŋlo fi fii bɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ŋgɛ̀ nfeeji gɛh nyu fiɛɛ fimimia Bajuu le mo bamii ba le gɛ Bajuu le gɛ, nduu lɛ bo kûsɛ muntele muboo, bo tû bɛ Nyo, bo lêe fitele yi Tada wese bɛsabɛŋ wu Jiso Kletu le. ");
INSERT INTO ncr_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Mɛɛse, bɛŋ yêgɛ bɛŋ yû, ŋgɛɛne Yɛlusalɛm nyu no Kiyo ki Yuude jɛmɛ mɛne, ŋkee gɛ laa gɛɛne kooshɛ la bɛ mɛ yo la. ");
INSERT INTO ncr_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Fiɛɛ fì ŋkee le gɛh lɛ manjuu manchii ma nfede mo le, le Kiyo ki Yuude sɛŋe mɛne lɛ ncha bɛ ŋgɛ chiɛɛne mɛ fwe. ");
INSERT INTO ncr_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Geenɛ, gɛ n'yɛde kinche kaŋ lɛ le fiɛɛ gɛ, fede lɛ mɛ mɛ̂sɛ lɛme chì Tada Jiso le wu nya mɛne chì le lɛ nfêeji saaka wù joŋe wù kune no Nyo le wu ndunyɛ fitele fì joŋe fɛ bamii be le. ");
INSERT INTO ncr_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Yi mɛɛse le, bɛŋ yêgɛ bɛŋ yû, ŋkee lɛ gɛ muh mu bɛŋ le wù besabɛŋ bɛ bo chi bee, nfeeji kune bvunfoŋ bvu Nyo wu baaŋ wu ka wu yɛ̂ŋ bvushi bwaŋ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Mɛ mo njɛme bɛŋ le chuule abɛŋ lɛ nɛ muh mu bɛŋ le lɛse lo mɛɛse, tu gɛ ŋkɛme kibo fo gɛ, ");
INSERT INTO ncr_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","nje nchi mbaaŋ nyilɛ gɛ ki nsɛɛŋ bɛŋ fiɛɛ fichii fì Nyo goone gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Bɛŋ doo bɛŋ shɛɛ, bɛŋ bîji fɛ bikwɛɛ biɛna le mo fɛ ŋgoo yi bamii ba mbɛmɛ le bo le njɛ shóŋ, yi Kiyo ki Yuude le ki gɛɛ bɛŋ a bo we. Bɛŋ nyûme banchiɛnɛ shóŋ ba kintaashɛ ki bamii ba Nyo kì wu gɛ̀ gu bɛ kilɛmɛ ki Mwa ye. ");
INSERT INTO ncr_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ŋkee lo lɛ ŋge ndoo mbaa kikaa, bakfuula tô bo lêe ŋgoo yɛnɛ le, bo gɛ ya bo châge lo muh wù bo koo gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Bamii bamu, le bo bu mo a bɛŋ ntɛnɛɛ bo lɛ̂ɛde bɛ ŋgoo yi bamii ba mbɛmɛ, bo chiide bo tuu a ŋgoo yiboo le. ");
INSERT INTO ncr_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Noo, bɛŋ yɛ̂ne, bɛŋ kwâji lɛ yi biluŋ le bitɛde nle n'yɛyɛ wa bɛŋ bachii antaŋ bɛ fɛnshɛ bɛ joo ajii le. ");
INSERT INTO ncr_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Mɛ mo nyâa bɛŋ mɛɛse chiaaŋ yi Nyo le mo yi jɛ ye yì le kune nfii wù Nyo fɛ bamii le. Jɛ yinɛ le yì taŋlo yi gê bɛŋ kûu, fi le lɛ bɛŋ tô bɛŋ kɛ̂mɛ kijuu fɛ kijusɛ ki Nyo le wu gɛɛ bamii ba wu le wu ge lɛ bo nyûme be. ");
INSERT INTO ncr_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ŋgɛ̀ mbaaŋ a booŋ gɛ ajii yi bige bi muh le kɛnɛ yi njú yi muh le gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Bɛŋ kee chuule lɛ le chiaaŋ yaŋ chinɛ yì gɛ̀ lɛne fiɛɛ fichii fì besa ŋgoo yaŋ gɛ̀ goone. ");
INSERT INTO ncr_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Yi mwɛɛ munchii le, ŋgɛ̀ nduunyi bɛŋ le lɛ muh kɛme ki wu lɛ̂ne chuule ki wu fîih bamii baŋgɛ, kwaji no Tada Jiso gɛ̀ jɛmɛ lɛ, ‘Kinlaŋye kì baaŋ le ki muh wù nyaa lo, fede muh wù fii lo le.’” ");
INSERT INTO ncr_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","No Bol mɛse jɛmɛ noo, bɛ bo mo bo tuŋ anyuu fɛkuu bachii, bo buunɛ. ");
INSERT INTO ncr_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Bo ja bo kesɛ bɛ kwe bo tu bo beede, bo kfugɛ Bol bo shiiŋe wu, lɛ ba shɛɛ wa. ");
INSERT INTO ncr_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Fiɛɛ fì gɛ̀ ge fɛ bo tu bo beede baaŋ nɛ, le jɛ yì Bol gɛ̀ jɛmɛ lɛ gɛ bo baaŋ bo ka bo yɛŋ bvushi bweŋ le gɛ. Bo mo bo chiiŋsɛ wu bo gɛɛŋ bo bu fɛ wù gɛ̀ bee ki wu lêe ŋguh wu a joo fo. ");
INSERT INTO ncr_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Besa ba Bol yɛsɛ bo le, bee mo be ja fo bee daŋ a ŋguh le njilele, bee fɛsɛ Ko. Bvu bu bvu yuu, bee gɛɛŋ Lodɛ, bee gɛ̀ ja fo, bee gɛɛŋ Batala. ");
INSERT INTO ncr_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","No bee bu yo, bee yɛŋ ŋguh wumu wu a joo le wù gɛ̀ gɛɛne Fonishia, bee mo bee lee yo bee gɛɛne. ");
INSERT INTO ncr_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Bee gɛ̀ yɛŋ Sablu le, bee chinɛ kibo kiŋkoŋo le, bee mo be fe bee gɛɛŋ bee bu Taya, woŋ wù Silia le fɛ ŋguh gɛ̀ bee ki wu bvûsɛ mwɛɛ fo. ");
INSERT INTO ncr_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Bee gooŋ bamii ba mbɛmɛ, besa bo che aju bvusooshwi, Kiyo ki Yuude ge, bo teefɛ Bol lɛ keefɛ wu môŋ lo wu gɛ̂ɛŋ Yɛlusalɛm gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Besa bo gɛ̀ che, juu gɛ̀ doo chi to chi kojɛ chì bee ja, bee mo be jo je. Bo bachii mo bikɛɛ baboo mo booŋ, bo chiiŋsɛ bee bo bu a kilaantɛŋ kɛɛ le bo gɛɛŋ bo bu jwe wu joo yì baaŋ le, besa bo tuŋ anyuu fɛkuu, bee buunɛ bee mo be yɛsɛ. ");
INSERT INTO ncr_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Bee lee a ŋguh le, bo tu bo tuu jiŋ fɛ yeh le. ");
INSERT INTO ncr_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Bee mo be ja Taya, bee jo je, bee gɛɛŋ bee bu Tolɛmaŋ. Besa booŋ ba bwee besa ba mbɛmɛ yɛsɛ, bee che juu chimimia. ");
INSERT INTO ncr_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Bvu bu bvu yuu, bee ja, bee gɛɛŋ bee fɛsɛ Kasalia, bee gɛɛŋ a Filib yeh, wu gɛ̀ jiɛnyi wu feeji jɛ yi Nyo, besa bo che. Filib wunɛ gɛ̀ bee muh wu mumwaa a ŋgoo yi bamii ba bvusooshwi ba bo gɛ̀ baayɛ baa le. ");
INSERT INTO ncr_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Wu gɛ̀ kɛme booŋ ba bikɛse banɛh, bo baaŋ a kɛɛ gɛ bilɛŋsɛ gɛ, bo gɛ̀ sɛŋe bamii mwɛɛ mù bo gɛ yuge Nyo jɛme. ");
INSERT INTO ncr_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Bee tu be nyu yo yi aju a duude le, muh mu gɛ̀ sɛŋe mwɛɛ mù wu gɛ̀ yuge Nyo jɛme, wu gɛ̀ ja Judia wu boh wu to yo, jee che nyu lɛ Agabu. ");
INSERT INTO ncr_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Wu to wu yɛŋ bee le, wu jo kicha ki Bol, wu kaaŋ bikaa bie bi wu wù Agabu mo chiaaŋ ye yu, wu mo wu fejɛ lɛ, “Kiyo ki Yuude duu lɛ le nɛ no Bajuu ba Yɛlusalɛm lé bo gê bo kâaŋ muh wù kɛme kicha kinɛ nɛ, bo nya wu chiaaŋ yi bamii ba le gɛ Bajuu le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","No bee yu noo, besa bamii bachii ba gɛ̀ bee fo bee tu bee lɛge Bol lɛ keefɛ wu gɛ̂ɛŋ Yɛlusalɛm gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Wu chvuu lɛ, “Bɛŋ gee nyu la finɛ nɛ? Bɛŋ kee gɛ lɛ bɛŋ beede nɛ bɛŋ shiŋshi fitele fiaŋ? Nle nseesɛ wa lɛ gɛ nyu nlee gɛh nyu ncha maa Yɛlusalɛm gɛ. Nle nseesɛ tɛ ki ŋkwê lo yo nje jee chi Tada Jiso.” ");
INSERT INTO ncr_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","No je gɛ̀ baaŋ nyu gɛ yu ki bee ge wu kusɛ ŋkwajɛ we gɛ, bee mo be lu, bee jɛmɛ gɛh wa lɛ, “Fi nyûme gɛh no Tada goone.” ");
INSERT INTO ncr_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Aju fe, bee banyɛ mwɛɛ mwesa, bee mo be bɛɛne Yɛlusalɛm. ");
INSERT INTO ncr_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Bamii ba mbɛmɛ bamu ba Kasalia bɛɛŋ besa bo, bee gɛɛŋ a Mɛnasoŋ yeh a bee gɛ̀ bee ki be chee yu. Mɛnasoŋ wunɛ gɛ̀ bee muh wu Sablu, gɛ̀ bee muh mu antɛnɛɛ a bamii ba gɛ̀ ya leesɛ muntele yi Jiso le. ");
INSERT INTO ncr_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","No bee gɛ̀ fɛsɛ Yɛlusalɛm, bamii ba mbɛmɛ ba yo fi bee chuule. ");
INSERT INTO ncr_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Akfuuŋ bu a yuu, besa ba Bol la jigɛ a Jɛm le, bachiji kintaashɛ gɛ̀ bee tɛ fo bachii. ");
INSERT INTO ncr_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Bol yɛsɛ bo le, wu mo wu nyiɛlɛ bo fiɛɛ fichii fì Nyo gɛ̀ ge fɛ bamii ba le gɛ Bajuu le gɛ, fede yi lɛme chì wu gɛ̀ lɛne le. ");
INSERT INTO ncr_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Lɛ bo yu noo, bo mo bo kɛ bo tumɛ maŋkuŋ ma Nyo. Geenɛ, bo gɛ̀ ja bo du Bol le lɛ, “Mwa bwe wese, bîjɛ wo yɛ̂ŋ no Bajuu le bo leesɛ wa fitele yi Jiso le banchvuge le banchvuge le. Geenɛ, bo le noo bo baaŋ gɛh bo lɛme yi banchi ba Musɛ le bo tɛɛme, ");
INSERT INTO ncr_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ba gɛ̀ sɛɛŋ wa bo le kune wo lɛ wo jiɛnyi wo yɛyi Bajuu ba chee bituŋ bimi le lɛ bo chinɛ banchi ba Musɛ le, wo jɛme lɛ keefɛ ba chvûuse booŋ yeh gɛ, bɛ lɛ keefɛ bo bîi kinche ki woŋ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","No fi le ba lé ba kɛ̂ɛ gɛh lɛ wo le wo to, taŋlo besabɛŋ ge nɛɛ mɛɛse? ");
INSERT INTO ncr_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Bee lé be sɛ̂ɛŋ wo fiɛɛ fì wo lé wo gê. Bee kɛme bamii fɛnɛ banɛh bo le bo ge ŋka fɛ Nyo le. ");
INSERT INTO ncr_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Jôo bo, bena bo gɛ̂ɛŋ bɛŋ kfûŋ bikwɛɛ biɛna, wo lâŋɛ fiɛɛ fichii fì bo kɛme ki bo laŋɛ, fi le lɛ bo gɛ̂ɛŋ bo mû bikwɛɛ biboo. Wo ge noo, bamii bachii mo bo kee lɛ wo gɛɛde tɛ banchi ba Musɛ, mwɛɛ munchii mù bo jɛme kune wo gɛ nyu mù nchiɛɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Fi kune bamii ba mbɛmɛ ba le gɛ Bajuu gɛ, bee gɛ̀ jo wa ntaŋ bee saŋ ŋwa bee chiiŋsɛ fɛ bo le lɛ keefɛ bo jîi mwɛɛ munjile mù ba le ba ge kintanyɛ yu fɛ banyo le gɛ. Keefɛ bo jîi kilɛmɛ ki nyaŋ gɛ. Keefɛ bo jîi nyaŋ yì le njɛ ba sɛɛ kilɛmɛ bu sɛŋ gɛ. Keefɛ bo kɛ̂me fiɛɛ ki bo ge bɛ kinjaŋ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Noo, Bol mo wu jo bamii bayu, akfuuŋ gɛ̀ bu a yuu bɛ bo gɛɛŋ bo kfuŋ bikwɛɛ biboo. Bol mo wu gɛɛŋ yeh yi kintanyɛ le, wu sɛɛŋ juu chì aju a kfuŋ doo wo kage, bo mo bo ge kintanyɛ fɛ bo le, muh wu mumwaa wu mumwaa. ");
INSERT INTO ncr_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Aju ayu gɛ̀ doo aka, a gɛ̀ bee bvusooshwi, Bajuu bamu bo gɛ̀ ja Ɛsia bo yɛŋ Bol fɛ yeh yi kintanyɛ le, bo bɛɛsɛ kinchvu ki bamii, bo koo wu, ");
INSERT INTO ncr_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","bo tu bo chinɛ bitada bo duu lɛ, “Bamii ba Ishwala, bɛŋ fîh bee! Le muh wunɛ wù jiɛnyi wu yɛyi mwɛɛ mù mbefe bamii le manjuu le manchii kune woŋ wese besabɛŋ kfunɛ le bɛ banchi ba Musɛ mo kune yeh yi kintanyɛ yinɛ. Wu le wu mɛsɛ wa wu jo bamii ba le gɛ Bajuu gɛ, wu to bɛ bo fɛnɛ fɛ yeh yi kintanyɛ yinɛ le, wu chɛŋe bɛ kijusɛ kì yuude kinɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Bo gɛ̀ jɛme noo, nje bo gɛ̀ yɛŋ Bol jiɛnyi a kilaantɛŋ kɛɛ le bɛ Tofimu muh wu Ɛfɛsu. Bo mo bo kwaji lɛ Bol le wu lee bɛ wu fɛ yeh yi kintanyɛ le. ");
INSERT INTO ncr_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Kitada kiyu, ge kilaantɛŋ kɛɛ kichii shiŋshɛ, bamii tu bo lege bo too fo. Bo fajɛ Bol le, bo chii wu bo bu bɛ wu yeh yi kintanyɛ le, kimimia, bo mo bo faa de yi fese. ");
INSERT INTO ncr_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Bo tu bo goone ki bo yuuyɛ Bol, saaka wuyu lee bintuŋ bi chiji kikwɛɛ ki bikwɛɛ bi bamii ba nchi ba Lum le, lɛ Yɛlusalɛm achii juune lo. ");
INSERT INTO ncr_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Wu mo wu ja lo kimimia, wu jo bamii ba nchi bɛ bikwɛɛ bimi bi ŋgoo yi bamii ba nchi, bɛ bo legɛ bo boh fo. Bamii doo bo yɛŋ bamii ba nchi le, chiji kikwɛɛ ki bikwɛɛ bi nchi nyume fo, bo mo bo lu ki bo suŋe Bol. ");
INSERT INTO ncr_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Chiji kikwɛɛ ki nchi kɛɛ mo ki to ki koo Bol, wu jɛmɛ bo kaaŋ wu bɛ bancha bafɛɛ. Wu biih bo le lɛ, “Wunɛ le yɛɛŋ? Wu jiale nyu la?” ");
INSERT INTO ncr_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Fo ja fo tu fo yode lo, banɛ wanɛ finɛ, baga wanɛ fiege. Wu baaŋ a yugɛ chuule laa be kooshi nyu la lɛ. Wu mo wu ja wu jɛmɛ lɛ ba jo Bol ba bɛɛŋ bɛ wu fɛ la chi bamii ba nchi le. ");
INSERT INTO ncr_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Bamii ba nchi mo bo jo wu, bo gɛ̀ doo bo bɛɛne bo too bo bu fɛ bikaa bi je bì ba sɛle lo le, bo mo bo ja bo tuu lo Bol, no kinchvu gɛ̀ fuge gɛh ki bii a wu jiŋ. ");
INSERT INTO ncr_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ki gɛ̀ bii noo ki wanɛ, ki duu lɛ, “Ba lɛ̂ɛshɛ lo wu!” ");
INSERT INTO ncr_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Bo gɛ̀ doo bo lese wa bɛ Bol fɛ la chi bamii ba nchi le, wu lɛgɛ chiji kikwɛɛ ki bikwɛɛ bi nchi wu du lɛ, “Taŋlo njɛmɛ fiɛɛ wo le?” Wu yu noo, wu biih Bol le lɛ, “Fi le lɛ wo kee jɛ́ yi Glek? ");
INSERT INTO ncr_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Gɛ wo nyume muh wu Ijib wɛɛ wù gɛ̀ kɛ ŋgɛ bɛ bikwɛɛ bi woŋ kife kimi le, wu chii ŋgoo yi bamii banchvuge banɛh (4,000) ba gɛ̀ yuuyi bamii, bɛ bo gɛɛŋ bo tu bo nyume nchvuuŋ gɛ?” ");
INSERT INTO ncr_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Bol chvuu lɛ, “Nle muh wu Bajuu, ba gɛ̀ boyi mɛ Tasu woŋ wù Silisia le, gɛ Tasu nyu kilaantɛŋ ki nchɛ gɛ. Kii wo, nyâ gɛh mɛ je njɛ̂mɛ bamii banɛ le.” ");
INSERT INTO ncr_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Chiji Kikwɛɛ ki bikwɛɛ bi nchi kɛɛ mo ki nya wu je lɛ wu jɛ̂mɛ. Bol mo wu lɛɛŋ fo, fɛ bikaa bi je bì ba sɛle lo bie le, wu chi bamii bɛ kibo. Bo lu bɛ jwe, wu jɛmɛ bo le a jɛ́ yi Ibulu le lɛ, ");
INSERT INTO ncr_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Bachii bɛ booŋ ba bwɛɛŋ, bɛŋ yêgɛ ntanyɛ jwe waŋ a bɛŋ fwe.” ");
INSERT INTO ncr_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Bo doo bo yu no wu jɛme nyu a jɛ́ yiboo yi Ibulu le, bo mɛsɛ bo chii nɛ nshiiŋ. Bol jɛmɛ lɛ, ");
INSERT INTO ncr_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Nle muh wu Bajuu, ba gɛ̀ boyi mɛ Tasu woŋ wù Silisia le, geenɛ ba lɛyɛ mɛ Yɛlusalɛm yanɛ, ŋgɛ n'yɛyi ŋwa chiaaŋ yi Gamala le. Wu yɛyɛ mɛ bɛ banchi ba bachiji besa lɛ chuule mɛ mo nlɛme yi fiɛɛ fì Nyo le ntɛɛme chuule gɛ njɛ bɛŋ bachii ba le fɛnɛ abɛŋ. ");
INSERT INTO ncr_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ŋgɛ̀ mboone bikaa a bamii jiŋ ba gɛ̀ bii Jɛ yi Tada le, ŋgee ba yuuyi bo, ŋkoode bilɛŋsɛ bɛ bikɛse ntune yeh yi ncha le. ");
INSERT INTO ncr_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Finɛ le fiɛɛ, kikwɛɛ ki bachiji kintanyɛ bɛ bamii ba sage woŋ kee chuule. Le bo ba gɛ̀ nya baŋwa lɛ ŋgɛ̂ɛŋ bɛ bo fɛ booŋ ba bwe besa ba Damasku le. Mɛ mo ntu njiɛnyi ŋgɛɛne ki ŋkooyɛ bamii ba bii Je yi Tada le, ŋkaaŋ, nto bɛ bo Yɛlusalɛm ba nya bo ŋgɛ le. ");
INSERT INTO ncr_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Ŋgɛ̀ ndoo nfɛɛse Damasku njɛ fɛnshɛ ŋgaaŋ, n'yuu wumu ja wu lalɛ fɛwe, wu shii ye yaŋ le. ");
INSERT INTO ncr_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ŋgwe fɛkuu, n'yu jɛ jɛmɛ mɛne lɛ, ‘Sol, Sol, wo boone bikaa a mɛ jiŋ nɛ nje la?’ ");
INSERT INTO ncr_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Mbiih lɛ, ‘Tada, le wo wù yɛɛŋ?’ Jɛ yiyu chvuu lɛ, ‘Le mɛ wù Jiso wu Nasalɛ, le mɛ wù wo boone bikaa a mɛ jiŋ.’ ");
INSERT INTO ncr_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Bamii ba gɛ̀ bee besa bo gɛ̀ yɛŋ n'yulɛ wuyu le, geenɛ bo gɛ̀ baaŋ yugɛ jɛ yi muh wù gɛ̀ jɛme besa wu le gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ŋka biih lɛ, ‘Tada, taŋlo ŋge nɛɛ?’ Wu chvuu mɛne lɛ, ‘Jâ we, wo lêe wo gɛ̂ɛŋ Damasku, ba lé ba sɛ̂ɛŋ wo lɛme chichii chì Nyo le wu seesɛ lɛ wo lé wo lɛ̂ŋ.’ ");
INSERT INTO ncr_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ŋgɛ ja fo, n'yulɛ wɛɛ ge wa nfeeŋ, bamii ba besa bo gɛ̀ jiɛnyi mo bo chiɛɛji wa lo mɛ, bo lee bo gɛɛŋ bɛ mɛ Damasku. ");
INSERT INTO ncr_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Muh mu gɛ̀ bee Damasku ayu, jee che nyu lɛ Anania, wu gɛ̀ ŋgvuune Nyo chuule wu gɛɛde banchi besa, Bajuu bachii ba gɛ̀ bee yo bo bɛɛŋse wu. ");
INSERT INTO ncr_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Wu gɛ̀ ja wu to wu yɛŋ mɛne, wu lɛɛŋ mbebe yaŋ le wu jɛmɛ mɛne lɛ, ‘Sol mwa bwaaŋ, wo kâasɛ wu yɛ̂de mwɛɛ le!’ Gɛh segeyu le noo, mɛ mo ŋkaasɛ ntu n'yɛde mwɛɛ le, mɛ mo n'yɛŋ tɛ wu wù Anania le. ");
INSERT INTO ncr_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Wu jɛmɛ mɛne lɛ, ‘Nyo wu bachiji besa le wu baa wa wo lɛ wo kɛ̂ɛ fiɛɛ fì wu goone, bɛ lɛ wo yɛ̂ŋ Muh we wu Lɛme wu Chaaŋ le, wo yu njɛmɛ wù bude jwe we le. ");
INSERT INTO ncr_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Wo lé wo gê wo nyû muh wù fêeji kune wu, wo sɛ̂ŋe bamii bachii fiɛɛ fì wo yɛŋ bɛ fì wo yu. ");
INSERT INTO ncr_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","No fi le noo mɛɛse, wo ka chiɛɛne la? Jâ we ba lêesɛ wo a joo, ki ba chûgɛ bimbefɛ biuŋ, no wo lɛge fɛ Tada le.’ ");
INSERT INTO ncr_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Sege ŋgɛ̀ ntu jiŋ Yɛlusalɛm, ndoo mbuune yeh yi kintanyɛ le, fiɛɛ njɛ kifilɛ ja fi to fɛ mɛne. ");
INSERT INTO ncr_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","N'yɛŋ Tada le a fiɛɛ fiyu le, wu jɛmɛ mɛne lɛ, ‘Yâŋsɛ wo jâ Yɛlusalɛm yanɛ chige nje gɛ bamii ba yanɛ nyume bo ge bo bɛɛŋ fiɛɛ fì wo feeji kune mɛ gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nchvuu wu le lɛ, ‘Tada, bo kee chuule lɛ ŋgɛ̀ leese yeh yi buunɛ le, ŋkoode bamii ba le bo leesɛ muntele yi ye yo le, nsuŋe. ");
INSERT INTO ncr_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Sege ba gɛ̀ yuuyɛ Tifiŋ wù gɛ̀ feeji bamii le kune wo, ŋgɛ̀ bee fo, ntoone. Le mɛ wù bamii ba gɛ̀ yuuyɛ wu, bo gɛ̀ baayɛ njú yiboo, bo nya lɛ ŋkɛme.’ ");
INSERT INTO ncr_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Tada ka wu jɛmɛ mɛne lɛ, ‘Jâ yanɛ, nje nlé ntûŋ wo je yì ndefɛ le fɛ bamii ba le gɛ Bajuu le gɛ.’” ");
INSERT INTO ncr_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","No Bol gɛ̀ jɛme bamii yege, wunɛ jɛmɛ gɛ̀ doo wu bu jwe we le, bo kɛ bo tu bo wanɛ lo fɛwɛɛwe, bo duu lɛ, “Ba lɛ̂ɛshɛ lo kfuu chi wunɛ muh yi nshɛŋ le. Gɛ nyu muh wù nyume yu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Bo tu bo wanɛ noo, bo sɛɛse njú yiboo we, bo nooŋ kibvunɛ we. ");
INSERT INTO ncr_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Chiji kikwɛɛ ki bikwɛɛ bi bamii ba nchi mo ki ja ki jɛmɛ lɛ nchi jo Bol wu gɛɛŋ bɛ wu fɛ la chiboo le, lɛ bo doo bo gɛɛŋ bɛ wu bo tâaŋ wu, bo bîih mwɛɛ wu le, wu sɛ̂ɛŋ fiɛɛ fì ge Bajuu fɛ bo tu bo wanɛ nɛ. ");
INSERT INTO ncr_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Bo mo bo gɛɛŋ bɛ wu bo kaaŋ, bo ja lɛ bo tâane, Bol biih kikwɛɛ ki ŋgoo yi bamii ba nchi kimi kì gɛ̀ lɛme fo le lɛ, “Nchi le wu bɛɛŋ lɛ ba taaŋ muh wu Lum njɛ ba sa nsa we sɛŋ?” ");
INSERT INTO ncr_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Kikwɛɛ ki ŋgoo yi bamii ba nchi kiyu yu noo, ki mo ki gɛ̂ɛŋ ki yɛŋ kikwɛɛ kiboo le, ki jɛmɛ wu le lɛ, “Wo goone ki wo môŋ nyu la? Wo kêe lɛ muh wunɛ le muh wu Lum.” ");
INSERT INTO ncr_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Chiji kikwɛɛ kiyu yu noo, wu mo wu gɛɛŋ wu yɛŋ Bol le wu biih wu le lɛ, “Gɛh sɛɛŋ mɛ, wo le muh wu Lum?” Wu bɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Chiji kikwɛɛ kiyu jɛmɛ wu le lɛ, “Ŋgɛ̀ ŋgu bɛ bige bì duude, fɛ ntu nyû muh wu Lum.” Bol chvuu wu le lɛ, “Nle fiaŋ muh wu Lum, mboyɛ le.” ");
INSERT INTO ncr_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Bamii baa bo gɛ̀ bee ki bo biide mwɛɛ wu le mo bo chii bikaa fo ki sege, chiji kikwɛɛ kiboo tu wu faane tɛ, nje wu gɛ̀ jɛmɛ bo le lɛ bo kaaŋ Bol nyu muh wu Lum. ");
INSERT INTO ncr_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Chiji kikwɛɛ kiyu tu wu goone gɛ̀ ki wu ghedɛ wu kɛ̂ɛ chuule fiɛɛ fì Bajuu gɛ̀ fiɛge yi Bol le. Bvu bu bvu yuu, wu jɛmɛ bo faanyɛ Bol, bo tɛɛŋ bachiji kintanyɛ ba baaŋ baaŋ mo bamii bachii ba sage woŋ, lɛ bo to, wu leesɛ Bol a bo fwe. ");
INSERT INTO ncr_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Bol noŋ ajii yi bamii ba sage woŋ le, wu jɛmɛ lɛ, “Booŋ ba bwɛɛŋ, yi kinche kaŋ le too bude abɛŋ, nto ŋgee nyu mwɛɛ mu ŋkee lɛ mu le chuule a Nyo jii, gɛ fiɛɛ nyu yu fì sage mɛ fɛ fitele fiaŋ le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Anania wù gɛ̀ bee kikwɛɛ ki bachiji kintanyɛ jɛmɛ bamii ba gɛ̀ lɛme mbebe Bol le lɛ bo kfûuŋ jwe we. ");
INSERT INTO ncr_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Bol chvuu wu le lɛ, “Nyo lé wu gê wu kfûuŋ tɛ wo. Wo fiɛɛnɛ kimbe ki ba le ba yefɛ ki tu ki baaŋ gɛ nyu ye le. Wo shile fɛɛ lɛ wo sage wo bii nchi le, wo ka ŋgode nchi wuyu wo duu lɛ ba kfuuŋ lo mɛ?” ");
INSERT INTO ncr_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Bamii ba gɛ̀ lɛme mbebe yi Bol le bo biih wu le lɛ, “Wo naanyi kikwɛɛ ki bachiji kintanyɛ ki Nyo?” ");
INSERT INTO ncr_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Wu chvuu lɛ, “Booŋ ba bwɛɛŋ, gɛ mɛ be ŋkee lɛ le kikwɛɛ ki bachiji kintanyɛ gɛ. Ba le ba saŋ lɛ, ‘Keefɛ muh jɛ̂me jɛ́ yì befe kune muh wù sage bamii le gɛ.’” ");
INSERT INTO ncr_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Bol gɛ̀ doo wu bijɛ wu yɛŋ lɛ bamii ba gɛ̀ bee fo bamu le Basadushii, bamu nyu Bafalashii, wu mo wu jɛmɛ bɛ jɛ yì tɛɛme antɛnɛɛ a bamii ba sage woŋ baa le lɛ, “Booŋ ba bwɛɛŋ, nle muh wu Bafalashii, nyu mwa muh wu Bafalashii. Nle fɛnɛ yi nsa le nje njiiŋe fwe, ŋkee lɛ baŋkfusa lé bo gê bo bû yi kwe le.” ");
INSERT INTO ncr_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","No wu jɛmɛ noo, Basadushii bɛ Bafalashii mo bo ja bo kɛ waa, nshilɛ wuyu mo wu ga ye. ");
INSERT INTO ncr_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Bo gɛ̀ waade noo, nje Basadushii gɛ̀ duu lɛ gɛ baŋkfusa nyu bo ge bo bu yi kwe le gɛ, bo ka duu lɛ gɛ fiɛɛ fimi nyu yu njɛ banchɛndaa ba Nyo kɛnɛ biyo gɛ. Geenɛ, Bafalashii bɛmɛ lɛ mwɛɛ munɛ munchii le lo. ");
INSERT INTO ncr_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Waa ja wu tɛmɛ lo fo, bamii bamu ba gɛ̀ duunyi banchi ba gɛ̀ bee yi ŋgoo yi Bafalashii le, lɛɛŋ fo bo jɛmɛ fi tɛmɛ lo, bo du lɛ, “Bee baaŋ yɛŋ gɛ fiɛɛ fì muh wunɛ jiale le gɛ. Taŋlo nyu kiyo kimi kɛnɛ Nchɛndaa wu Nyo wu jɛme wu le.” ");
INSERT INTO ncr_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Waa wuyu mo wu ja wu goone ki wu tû nyu bvuju, kikwɛɛ ki bikwɛɛ bi bamii ba nchi tu ki faane lɛ segemu bo lé bo jâ bo sâayɛ lo Bol fo yi bimbe le. Wu mo wu jɛmɛ lɛ nchi boh fo, bo lô Bol chiaaŋ yiboo le, bo kâasɛ bo bɛ̂ɛŋ bɛ wu fɛ la chi nchi le. ");
INSERT INTO ncr_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Lɛ nyu antaŋ, Tada to wu lɛɛŋ mbebe yi Bol le, wù jɛmɛ wu le lɛ, “Kânɛ shɛ́ŋ. No wo le wo sɛɛŋ wa bamii le kune mɛ Yɛlusalɛm, le gɛh yɛɛŋyɛɛŋ no wo lé wo gê wo sɛ̂ɛŋ tɛ Lum.” ");
INSERT INTO ncr_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Akfuuŋ bu a yuu, Bajuu bamu koo nchvuuŋ, bo ji leh lɛ gɛ bo nyu bo ji fiɛɛ gɛ kɛnɛ bo mu fiɛɛ gɛ, gɛ fɛ bo yu Bol. ");
INSERT INTO ncr_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Bamii baa ba gɛ̀ kolɛ nchvuuŋ, bo gɛ̀ ji leh fede bamii mbaanyɛ. ");
INSERT INTO ncr_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Bo mo bo gɛɛŋ fɛ bachiji kintanyɛ ba baaŋ baaŋ le, mo bamii ba sage woŋ, bo jɛmɛ bo le lɛ, “Bee le be ji wa lo leh lɛ gɛ̀ bee nyu be lee lo fiɛɛ amu gɛ njɛ bee yuuyɛ Bol sɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Yi mɛɛse le, bɛŋ bamii ba nchi ba sage woŋ bɛŋ chiiŋsɛ ntuŋ fɛ kikwɛɛ ki bikwɛɛ bi bamii ba nchi le, bo bvûsɛ wu lɛ wu ka wu bôosɛ Bol wu tô a bɛŋ fwe, lɛ bɛŋ goone ki bɛŋ ka bɛŋ tâa nsa we chuule. Noo, bee mo be wêedɛ wu a je, bo doo bo boge bɛ wu, bee mo be yûuyɛ wu baaŋ a je.” ");
INSERT INTO ncr_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","No bo gɛ̀ kolɛ nchvuuŋ yɛɛ noo, mwa jɛme Bol wù jwɛŋsɛ yu, wu mo wu gɛɛŋ fɛ la chi bamii ba nchi le, wu sɛɛŋ Bol le. ");
INSERT INTO ncr_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Wu mo wu tɛɛŋ kikwɛɛ ki ŋgoo yi bamii ba nchi kimi wu jɛmɛ ki le lɛ, “Jôo chumu wunɛ wo gɛ̂ɛŋ bɛ wu fɛ kikwɛɛ ki bikwɛɛ bi bamii ba nchi le, wù kɛme fiɛɛ ki wu sɛ̂ɛŋ wu le.” ");
INSERT INTO ncr_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Wu mo wu jo wu, wu gɛɛŋ bɛ wu fɛ chiji kikwɛɛ ki bikwɛɛ bi nchi le, wu jɛmɛ wu le lɛ, “Bol wu muh ncha le wu tɛɛŋ mɛ, wu jɛmɛ lɛ njô chumu wunɛ ntô bɛ wu fɛ wo le, lɛ wù kɛme fiɛɛ fì wu sɛ̂ɛŋ wo le.” ");
INSERT INTO ncr_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Chiji kikwɛɛ kɛɛ mo ki jijɛ wu yi kibo le, bɛ wu lee yeh, wu biih wu le lɛ, “Le la fì wo goone ki wo sɛ̂ɛŋ mɛne?” ");
INSERT INTO ncr_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Chumu wɛɛ chvuu lɛ, “Bajuu bamu le bo jo ntaŋ lɛ bo lé bo dû wo le lɛ wo shîishɛ Bol wu to fwe a bamii ba sage woŋ le fɛwɛge, lɛ bo gôone ki bo tâa nsa we chuule, bo gee noo bo buuse lo. ");
INSERT INTO ncr_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Keefɛ wo gê wo bɛ̂ɛŋ gɛ, nje bamii le yu, fede muh mbaanyɛ bo weede a je, bo ji leh lɛ gɛ bo nyu bo jî fiɛɛ gɛ, mo ki bo mû fiɛɛ gɛ njɛ bo yuuyɛ Bol sɛŋ gɛ. Bo le mɛɛse bo seesɛ wa ye, bo tu bo chiɛɛne gɛh nyu fiɛɛ fì wo lé wo jɛ̂mɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Chiji kikwɛɛ ki bikwɛɛ bi bamii ba nchi kɛɛ mo ki jɛmɛ lɛ chumu wɛɛ gɛ̂ɛne, wu chiisɛ wu le lɛ keefɛ wu doo wu gɛɛne wu gê muh kɛ̂ɛ lɛ wu le wu sɛɛŋ fiɛɛ fiyu gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Chiji kikwɛɛ ki bikwɛɛ bi bamii ba nchi kɛɛ mo ki tɛɛŋ bikwɛɛ bi ŋgóo yi bamii ba nchi lɛ bifɛɛ, wu jɛmɛ bi le lɛ, “Bɛŋ sêesɛ bamii ba nchi gii yifɛɛ (200) bɛ nyámbala mbambvusooshwi (70) bɛ ba agóŋ gii yifɛɛ (200), doo nyume njɛ juu bikaa bvuugɛ antaŋ, bo gɛ̂ɛŋ Kasalia. ");
INSERT INTO ncr_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Bɛŋ sêesɛ tɛ nyambala Bol le, bɛŋ jô wu bɛŋ gɛ̂ɛŋ bɛ wu fɛ Fɛli wù muh wù sage le, keefɛ fiɛɛ kôoshɛ bɛ wu a je gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","No wu jɛmɛ noo, wu mo bo saŋ ŋwa wu duu lɛ, ");
INSERT INTO ncr_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Le mɛ wù Klawdiu Lisia. Nsaŋe ŋwa wunɛ fɛ wo le muh wù baaŋ wù Fɛli wù muh wù sage. N'yɛɛse wo le. ");
INSERT INTO ncr_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Bajuu chi bo koo muh wunɛ bo goone ki bo yuuyɛ. N'yu lɛ le muh wu Lum, besa bamii baŋ banchi chi be gɛɛŋ bee mo be lee fo bee lo wu chiaaŋ yiboo le. ");
INSERT INTO ncr_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nchi ŋgoone ki n'yu fiɛɛ fì bo fiege wu yu, nchi mo mboh bɛ wu fɛ bamii baboo ba sage woŋ le. ");
INSERT INTO ncr_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Bo doo bo taa, nchi n'yɛŋ lɛ mwɛɛ mù bo fiege wu yu le gɛ kintɛɛnyɛ kune banchi baboo lɛ, wu baaŋ ge gɛ̀ fiɛɛ fì ba yuuyɛ lo wu gɛ kɛnɛ lɛ ba lee wu yeh yi ncha le gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Muh chi doo wu sɛɛŋ mɛne lɛ Bajuu bamu le bo koo nchvuuŋ ki bo yuuyɛ muh wunɛ, mɛ mo nchiiŋsɛ wu fɛ wo le, kimimia. Nle njɛmɛ tɛ bamii ba fiege mwɛɛ yi ye ye le lɛ bo tô bo yɛ̂ŋ nyu wo le, bo sɛ̂ɛŋ fiɛɛ fì bɛ bo kɛme.” ");
INSERT INTO ncr_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Bamii ba nchi mo bo ja bo ge gɛh no kikwɛɛ kiboo gɛ̀ jɛmɛ, bo jo Bol antaŋ, bɛ bo gɛɛŋ bo bu Antibati. ");
INSERT INTO ncr_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Akfuuŋ bu a yuu, bamii ba nchi ba gɛ̀ jiɛnyi bɛ bikaa chinɛ Bol chiaaŋ yi baa bo gɛ̀ jiɛnyi yi nyámbala le, lɛ bo gɛ̂ɛne bɛ wu fwe, bo mo bo kaasɛ bo tu jiŋ fɛ la chiboo le. ");
INSERT INTO ncr_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Bo gɛ̀ gɛɛŋ bo fɛsɛ Kasalia, bo nya ŋwa wɛɛ muh wù sage le, bo mo bo nya tɛ Bol chiaaŋ ye le. ");
INSERT INTO ncr_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Wu fi ŋwa wɛɛ wu tɛɛŋ, wu biih laa Bol bu kimbe ki la le lɛ. Wu doo wu yu lɛ Bol le muh wu Silisia, ");
INSERT INTO ncr_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","wu mo wu jɛmɛ wu le lɛ, “Nlè ŋge n'yêgɛ nsa wo sege bamii ba bena bo kɛme nsa fɛsɛ fɛnɛ.” Wu mo wu jɛmɛ lɛ ba jo Bol ba gɛ̂ɛŋ ba gɛ̂ɛ wu a nto wu Hɛlod le, bo chîɛɛne wu. ");
INSERT INTO ncr_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Aju gɛ̀ bu atɛŋ, Anania wù kikwɛɛ ki bachiji kintanyɛ, bɛ bamii bamu ba sage woŋ, mo Tɛtulu wù gɛ̀ kee nchi chuule bo boh bo gɛɛŋ Kasalia. Bo mo bo gɛɛŋ bo yɛŋ Fɛli muh wù sage le, bo giŋsɛ nsa wuboo wù kune Bol a wu fwe. ");
INSERT INTO ncr_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Bo tɛɛŋ Bol, Tɛtulu mo wu kɛ wu teede mwɛɛ yi ye ye le, wu jɛmɛ Fɛli le lɛ, “Muh wù baaŋ, kimbonɛ le yi woŋ kfunɛ le too bude yi mɛɛse le, nyu nje je yì joŋe yi wo sage yu, baŋkusɛ ba joŋe le yu wesee woŋ kfunɛ le, chiaaŋ yo le. ");
INSERT INTO ncr_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Bamii bachii yuge njoŋ baaŋ fede je yì wo sage yu manjuu le manchii, segechii. ");
INSERT INTO ncr_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Gɛ ŋkoŋe ki njeese kife kuŋ baaŋ gɛ, nlɛge lɛ wo yêgɛ gɛh shige, wo yû fiɛɛ fì bee le be jɛ̂mɛ. ");
INSERT INTO ncr_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Bee le be yɛŋ lɛ muh wunɛ le muh wu fiɛɛ. Wu jiɛnyi wu shiŋshi ŋgɛ antɛnɛɛ a Bajuu yi kikwɛɛ ki nshɛŋ le kichii. Ka nyu wu wu le kikwɛɛ ki ŋgoo yi ba tɛŋe lɛ yi Nasalɛ. ");
INSERT INTO ncr_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","Wu gɛ̀ goone tɛ ki wu chɛ̂ŋe bɛ yeh yi kintanyɛ bee koo wu. ");
INSERT INTO ncr_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Wo bile lo mwɛɛ muh wunɛ le, wo yu a wu le mwɛɛ munɛ munchii mù bee jɛme kune wu.” ");
INSERT INTO ncr_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","No Tɛtulu jɛmɛ noo, Bajuu tooŋ, bo bɛɛsɛ lɛ mwɛɛ munɛ munchii le nchiɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Muh wù sage wɛɛ fe lɛ Bol jɛme. Wu mo wu jɛmɛ lɛ, “Ŋkee lɛ wo le wo sa wa bansa woŋ kfunɛ le yi biluŋ le wesee. Mɛ mo n'yuge njoŋ ki nlɛ̂ɛŋ ntânyɛ jwe waŋ a wo jii. ");
INSERT INTO ncr_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Wo nɛ ja lo wo biide, wo yu lɛ aju baaŋ a fe gɛ wa yuufe ncho afaa no nchi mbɛnɛ Yɛlusalɛm ki mbuunɛ Nyo gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Bajuu gɛ̀ baaŋ yɛŋ gɛ ntɛɛnyi kintɛɛnyɛ besa muh gɛ, bo gɛ̀ baaŋ yɛŋ gɛ tɛ mbɛɛse bamii yeh yi kintanyɛ le kɛnɛ yéh yi buunɛ le, kɛnɛ kijusɛ kimu le a kilaantɛŋ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Gɛ bo kɛme lo fiɛɛ fì duunyi lɛ nle ŋge mwɛɛ munɛ mù bo kooyi yi ye yaŋ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Nle mbɛɛŋ finɛ a wo fwe, lɛ mbuune Nyo wu bachiji besa mbii Je yì bo tɛŋe lɛ le yì befe. Mbɛmɛ nyu mwɛɛ munchii mù le a Ŋwa wu banchi ba Musɛ le bɛ mù le a Baŋwa ba bamii ba ntuŋ wu Nyo le. ");
INSERT INTO ncr_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Njiiŋe fwe yi Nyo le gɛh yɛɛŋyɛɛŋ no bamii banɛ tɛ jiiŋe, lɛ bamii bachii ba joŋe bɛ bamii ba befe lé bo gê bo bu yi kwe le. ");
INSERT INTO ncr_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Noo, mɛ mo ghede chuule segechii nchee kinche ki kooji a Nyo fwe bɛ bamii, fi le lɛ keefɛ fiɛɛ nyû yu fì sâge mɛ fɛ fitele le gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Le wa biluŋ bì duude le no ŋgɛ ja Yɛlusalɛm, nchi ŋkaasɛ ŋgɛɛŋ yo ki nya bige bamii baŋ ba woŋ le, mo ŋge kintanyɛ. ");
INSERT INTO ncr_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Le fiɛɛ finɛ fì bo gɛ̀ yɛŋ mɛne yeh yi kintanyɛ le ŋgee, nyu ŋkfuŋ wa kikwɛɛ kaŋ. Gɛ bamii kɛnɛ jwe wu waa gɛ̀ bee fo gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Bajuu bamu ba Ɛsia gɛ̀ bee fo, bo be kɛme ki bo nyu fɛnɛ ki bo sɛɛŋ wo fiɛɛ fì bo kɛme kune mɛ, fɛnɛ le lɛ fiɛɛ le yu. ");
INSERT INTO ncr_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Baaŋ noo nyu gɛ, bamii banɛ sɛɛŋ la fiɛɛ fì bo gɛ̀ yɛŋ lɛ nle njiaa sege nchi nlɛme fwe a bamii ba sage woŋ, ");
INSERT INTO ncr_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","fede fiɛɛ fichii fì ŋgɛ̀ njɛmɛ bɛ jɛ yì tɛɛme bo le lɛ, nle a bo fwe yi kife kɛɛ le yi nsa le nje nle mbɛɛŋ lɛ baŋkfusa lé bo gê bo bû yi kwe le.” ");
INSERT INTO ncr_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Lɛ Bol jɛmɛ noo, Fɛli yegɛ nɛɛ, nyu muh wù kee wa kune Je yi Tada chuule, wu mo wu sheeshɛ nsa wu jɛmɛ lɛ, “Sege Lisia wù chiji kikwɛɛ ki bikwɛɛ bi bamii ba nchi lé wu bôh wu tô, fɛ nsuunɛ nsa wunɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Wu mo wu jɛmɛ lɛ kikwɛɛ ki ŋgoo yimi yi bamii ba nchi jo Bol yi gɛɛŋ yi leesɛ yeh, bo chîɛɛne. Geenɛ, lɛ bo nyâ gɛh wu bɛ je, bo chînɛ nsáa ye too yi fii wu. ");
INSERT INTO ncr_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Aju gɛ̀ doo wo kɛŋsɛ, Fɛli bɛ Dusila wù kwɛɛ wù gɛ̀ bee muh wu Bajuu bo to. Fɛli gɛɛŋ wu tɛɛŋ Bol wu to, bo tu bo yege fiɛɛ fì wu jɛme kune ki muh leesɛ fitele yi Kletu Jiso le. ");
INSERT INTO ncr_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Wu doo wu jɛme kune no taŋlo muh nyume muh wù joŋe, bɛ no taŋlo muh shee bɛ kikwɛɛ ke, bɛ no Nyo lé wu gê wu sâ bamii, Fɛli yu noo, ye kuufɛ wu. Wu mo wu jɛmɛ Bol le lɛ, “Taŋlo wo gɛ̂ɛne mɛɛse, ŋge ndoo ŋkɛme kife fɛ ŋka ntɛ̂ɛŋ wo.” ");
INSERT INTO ncr_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Wu gɛ̀ jɛme noo, wù kɛme ŋkwajɛ lɛ segemu Bol lé wu kê wu bɛ kwa. Wu tu wu tɛŋe Bol lɛfolɛfo bɛ wu fɛde kinfɛ. ");
INSERT INTO ncr_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Gɛh noo, gɛh noo, biluŋ kuŋ bifɛɛ. Ba gɛ̀ doo ba gɛɛ Bolsiu Fɛstu yi kinta ki Fɛli le, Fɛli tu wu goone lɛ wu gê Bajuu kôŋe wu, wu mo wu chinɛ Bol le yeh ncha le. ");
INSERT INTO ncr_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Gɛ doo nyu aju atade no Fɛstu gɛ̀ kɛ wu sage kimbe ki woŋ kì Judia le, wu ja Kasalia wu bɛɛŋ Yɛlusalɛm. ");
INSERT INTO ncr_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Bachiji kintanyɛ ba baaŋ baaŋ bɛ bikwɛɛ bi Bajuu bi woŋ mo bo to bo yɛŋ wu le, bo giŋsɛ nsa wù bo kɛme bɛ Bol a wu jii, bo tu bo lɛge wu, ");
INSERT INTO ncr_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","lɛ wu dûnyɛ gɛh nyu kiŋkoŋɛ fɛ bo le, wu gê bo chîiŋsɛ Bol wu tô Yɛlusalɛm. Bo gɛ̀ gee noo, bo seesɛ wa lɛ bo lé bo wêede bo yûuyɛ wu a je. ");
INSERT INTO ncr_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fɛstu chvuu bo le lɛ, “Bol le yeh yi ncha le Kasalia, mɛ kibɛɛ nlé ŋkâase ntûu yo aju kane le. ");
INSERT INTO ncr_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Bamii bamu ba le bikwɛɛ biɛna, bî mɛne Kasalia, bo tô bo jɛ̂me fiɛɛ fì wu jiale nyu yo nɛ fiɛɛ le yu.” ");
INSERT INTO ncr_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fɛstu gɛ̀ che bɛ bo gɛɛŋ bu njɛ aju nyaaŋ kɛnɛ yuufe, wu mo wu kaasɛ wu tu jiŋ Kasalia. Akfuuŋ bu ayuu, wu gɛɛŋ wu shii yeh yi nsa le, wu jɛmɛ lɛ bo to bɛ Bol. ");
INSERT INTO ncr_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","No Bol fɛɛse, Bajuu ba gɛ̀ ja Yɛlusalɛm bo boh yo, bo mo bo lɛɛmɛ bo kɛnɛ wu, bo tu bo kooyi mwɛɛ ye ye le wesee fì shige nyume gɛ yu gɛ. Geenɛ, fiɛɛ nyu gɛ yu fì bo taŋlo bo sɛɛŋ fì duunyi lɛ wu le wu ge fimi gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Bol tanyɛ jwe we wu jɛmɛ lɛ, “Mbaaŋ njiaa gɛ lo nchi wu Bajuu, kɛnɛ wu yeh yi kintanyɛ le, kɛnɛ wu Nfoŋ wu Lum gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Geenɛ, Fɛstu tu wu goone lɛ wu ge Bajuu kôŋe wu, wu mo wu biih Bol le lɛ, “Wo koŋe ki wo bɛ̂ɛŋ Yɛlusalɛm mɛ kibɛɛ nsâ sa wo yo yi mwɛɛ munɛ le?” ");
INSERT INTO ncr_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Bol chvuu lɛ, “Nlɛme wa fɛnɛ nyu a ŋku wu nsa le, nyu wu Nfoŋ wu Lum. Le nyu fɛnɛ fɛ ba be ba sa nsa waŋ fo. Wo kibɛɛ kee chuule lɛ mbaaŋ njiaa gɛ fiɛɛ besa Bajuu gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Finɛ nyume lɛ nle ŋgode nchi, njiaa fiɛɛ fì taŋlo ba yuuyɛ lo mɛ, ŋgɛ nfaŋ kwe gɛ. Geenɛ, nɛ le lɛ mwɛɛ mù bo kooyi ye yaŋ le le chimbiaŋ, tu gɛ muh nyu yu wù taŋlo wu nya mɛ chiaaŋ yi Bajuu banɛ le gɛ. Nlé nlɛ̂gɛ lɛ nsa waŋ gɛ̂ɛŋ fwe fɛ Nfoŋ wu Lum le.” ");
INSERT INTO ncr_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Fɛstu yu noo, bɛ bamii be ba bɛ bo gɛ̀ sage bansa chvuuŋ chvuuŋ. Wu mo wu jɛmɛ Bol le lɛ, “No wo le wo lɛgɛ wa lɛ nsa wo lé wu gɛ̂ɛŋ fɛ Nfoŋ wu Lum le, tu wu lé wu gɛ̂ɛŋ fo.” ");
INSERT INTO ncr_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Gɛ̀ bee kife kimi le ajiŋ ayu, Nfoŋ Agliba bɛ Bɛni la jigɛ a Fɛstu le Kasalia ki bo yɛsɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Bo gɛ̀ doo bo nyu yo yi aju a duude le, Fɛstu ja wu be Nfoŋ bɛ nsa wu Bol wu jɛmɛ lɛ, “Muh mu le fɛnɛ wù Fɛli gɛ̀ chinɛ yeh yi ncha le, ");
INSERT INTO ncr_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ŋgɛ̀ ndoo ŋgɛɛŋ Yɛlusalɛm, bachiji kintanyɛ ba baaŋ baaŋ bɛ bamii ba sage woŋ wu Bajuu giŋsɛ nsa we a mɛ jii lɛ ndu lɛ wu le wu gwe nsa. ");
INSERT INTO ncr_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Njɛmɛ bo le lɛ, gɛ nchi wu bamii ba Lum nyu wu bɛɛŋ lɛ ba suunɛ lɛ muh le wu gwe nsa njɛ ba le ba nya wa muh wɛɛ je wu lɛɛŋ a ŋku wu nsa le fwe a bamii ba bɛ bo kɛme nsa ki wu tânyɛ jwe we yi mwɛɛ mù bo kooyi ye ye le sɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Bo gɛ̀ doo bo to fɛnɛ, ŋgɛ̀ mbaaŋ ndɛdɛ gɛ. Akfuuŋ bu a yuu, ŋgɛɛŋ nshii yeh yi nsa le njɛmɛ lɛ ba to bɛ muh wɛɛ. ");
INSERT INTO ncr_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Bamii ba bɛ bo gɛ̀ kɛme nsa gɛ̀ doo bo lɛɛŋ we, bo gɛ dunyɛ jialɛ chì ŋgɛ̀ ŋkwaji lɛ taŋlo bo sɛɛŋ ye ye le gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Bo tu bo jɛme nyu mwɛɛ mu mbejɛ ye ye le kune je yì bo buune Nyo yu yo, mo kune muh mu wù ba tɛŋe lɛ Jiso wu gɛ̀ kwe wa, geenɛ Bol lɛme gɛh lɛ wu le yu. ");
INSERT INTO ncr_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","No ŋgɛ mbaaŋ ŋkɛɛ gɛ no ntaŋlo nlee antɛnɛɛ a mwɛɛ munɛ gɛ, mɛ mo mbiih Bol le laa wu koŋe ki wu bɛ̂ɛŋ Yɛlusalɛm ba sa nsa we yo kune mwɛɛ munɛ lɛ. ");
INSERT INTO ncr_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Wu chvuu lɛ wu le wu mɛ gɛh yeh yi ncha le, le gɛh Nfoŋ wu Lum wu lé wu gê wu sûunɛ nsa we. Mɛ mo ndu lɛ ba gɛ̂ɛ wu yeh, ba chîɛɛne gɛɛŋ bu no nlé ŋgê nchîiŋsɛ wu fɛ Nfoŋ wu Lum le.” ");
INSERT INTO ncr_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agliba yege nɛɛ, wu jɛmɛ Fɛstu le lɛ, “Mɛ kibɛɛ ŋkoŋe ki n'yû mwɛɛ munɛ jwe wu muh wu yu le.” Fɛstu chvuu lɛ, “Wo lé wo bû, wo yû nyu fɛwɛge.” ");
INSERT INTO ncr_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Akfuuŋ bu a yuu, Agliba bɛ Bɛni tu bo jiɛnyi bo too bo ŋage lo baaŋ. Bɛ bachiji bikwɛɛ bi bamii ba nchi mo bamii ba baaŋ baaŋ ba a laantɛŋ, bo jiɛnyɛ bo to bo lee ŋgaa. Fɛstu mo wu jɛmɛ bo to bɛ Bol. ");
INSERT INTO ncr_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","No bo to bɛ wu, Fɛstu jɛmɛ lɛ, “Nfoŋ Agliba bɛ bamii bachii ba le fɛnɛ, bɛŋ yɛŋ muh wunɛ le. Le muh wù Bajuu bachii too bo dode mɛne yanɛ mo Yɛlusalɛm kune wu, bo wanɛ, bo duu lɛ gɛ nyu muh wù nyûme yu gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Mbaaŋ n'yɛŋ gɛ lɛ wu le wu ge fiɛɛ fì ba yuuyɛ wu yu gɛ. No wu chi lɛgɛ wa lɛ nsa we gɛ̂ɛŋ fwe nyu fɛ Nfoŋ wu Lum le, mɛ mo n'yɛŋ lɛ nlé nchîiŋsɛ wu fɛ wu le. ");
INSERT INTO ncr_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Geenɛ, ŋgɛ ŋkee lo chuule fiɛɛ fì taŋlo nsâŋ fɛ Nfoŋ wu le chiji kikwɛɛ kaŋ le kune wu gɛ. Noo, mɛ mo nleesɛ wu a bɛŋ jii mɛɛse, nchensɛŋ fɛ wo wu Nfoŋ Agliba le, lɛ bɛŋ ntâa nsa we, laa ŋkɛ̂me fiɛɛ fì taŋlo nsâŋ la. ");
INSERT INTO ncr_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","N'yɛde lɛ fi baaŋ nyu gɛ chuule lɛ nchîiŋsɛ muh wu ncha fɛ Nfoŋ le njɛ ndunyɛ fiɛɛ fì bo duu lɛ wu le wu jiaa sɛŋ gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Nfoŋ Agliba mo wu jɛmɛ Bol le lɛ, “Le kijusɛ kuŋ mɛɛse ki wo jɛ̂mɛ bɛ jwe wo.” Bol mo wu chiaasɛ kibo we, wu kɛ ki wu tânyɛ jwe we, wu duu lɛ, ");
INSERT INTO ncr_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Mbɛɛ, n'yɛde lɛ kishi kaŋ le ki joŋ lɛ mbaaŋ ki nlɛɛŋ ntanyɛ jwe waŋ abɛŋ fwe yi mwɛɛ munchii mù Bajuu kooyi ye yaŋ le. ");
INSERT INTO ncr_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Njɛme nɛ, nje ba kee chuule kinche ki woŋ wu Bajuu mo bintɛɛnyɛ bì bo to bo kɛme. Noo, nlé nlɛ̂gɛ lɛ bo yêgɛ bɛ nyiɛgee bo yû fiɛɛ fì nlé njɛ̂mɛ. ");
INSERT INTO ncr_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Bajuu bachii kee kinche kaŋ baaŋ lo. Bo kee no ŋgɛ̀ nchee woŋ wese le mo Yɛlusalɛm. ");
INSERT INTO ncr_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Bo kee kɛge lo je yì ndefe le lɛ nle muh wu Bafalashii, nyume ŋgoo yì tɛɛme chuule yi fiɛɛ fì Nyo le fede yimi yichii. Finɛ le fiɛɛ nɛ le lɛ bo koŋe ki bo jɛmɛ, bo lé bo bɛ̂ɛŋ lɛ le nchiɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Nlɛme fɛnɛ mɛɛse yi nsa le nje njiiŋe fwe, ŋkee ŋka wù Nyo gɛ̀ ka wa bachiji besa yu. ");
INSERT INTO ncr_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ŋka wunɛ le lɛ chikfuu chesa chì yuufe ncho chifɛɛ, chi chiɛɛne no ba buune Nyo bɛ kiŋkoŋɛ antaŋ bɛ fɛnshɛ. Mbɛɛ, le lɛ nje ŋka wɛɛ wù Bajuu kɛme nsa yu besa bo. ");
INSERT INTO ncr_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Mbiide bo le mo bamii bachii le laa, ge la fì bɛŋ yɛne fi tɛɛme ki bɛŋ bɛ̂ɛŋ lɛ taŋlo Nyo bvusɛ muh yi kwe le la? ");
INSERT INTO ncr_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Mɛ kibɛɛ ŋgɛ̀ ŋkwaji lɛ ŋkɛme ki ŋgê fiɛɛ fichii ki nchîijɛ jee chi Jiso wu Nasalɛ. ");
INSERT INTO ncr_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Finɛ le lo fiɛɛ fì ŋgɛ̀ ŋge Yɛlusalɛm. Ŋgɛ̀ nfi bvuŋga a bachiji kintanyɛ ba baaŋ baaŋ le ŋkoo bamii ba Nyo wesee, nfaa yeh yi ncha le. Gɛ kagɛ finɛ gɛ. Ba gɛ̀ bee ki ba yuuyɛ bo, mɛ tɛ ntooŋ. ");
INSERT INTO ncr_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ŋgɛ̀ nyaa ŋgɛ bo le lɛfolɛfo yéh yi buunɛ le yichii, ŋkane lɛ bo jɛ̂me jɛ́ yì befe kune muh wù Jiso. Shɛ́ŋ bɛɛne mɛ bɛ bo baaŋ, mboone bikaa a bo jiŋ, gɛɛne bude bilaantɛŋ bi bituŋ bimi le. ");
INSERT INTO ncr_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Mo nja ŋgɛɛne Damasku, a bachiji kintanyɛ ba baaŋ baaŋ nyu bo saŋ ŋwa, bo nya mɛ bvuŋga. ");
INSERT INTO ncr_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Mbɛɛ, ŋgɛ̀ ndoo ŋgɛɛne nyu juu leesɛ cha, nja n'yɛŋ n'yuu wumu ja gɛh wu lalɛ fɛwe wu baaŋ wu fede juu, wu shii wu to yi besa bamii ba besa bo gɛ̀ jiɛnyi le. ");
INSERT INTO ncr_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Bee bachii ja be gwe fɛkuu, n'yu jɛ biih mɛne a jɛ́ yi Ibulu le lɛ, ‘Sol, Sol, wo boone bikaa a mɛ jiŋ nɛ nje la? Wo gee nɛ, wo kfuunɛ nyu ye yo, njɛ fɛ naa lɛme wu boone ye ye yi kimbaŋ ki chiji le.’ ");
INSERT INTO ncr_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Mbiih lɛ, ‘le wo wù yɛɛŋ Tada?’ Wu chvuu lɛ, ‘Le mɛ wù Jiso, le mɛ wù wo boone bikaa a mɛ jiŋ. ");
INSERT INTO ncr_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Jâ lɛ̂ɛŋ we. Fiɛɛ fì ge lɛ mbunɛ fɛ wo le, le ki mbâa wo muh waŋ wu lɛme le, wo fêeji mwɛɛ mù wo yɛŋ abɛŋ bɛ mù mbaaŋ ki ndûnyɛ wo le. ");
INSERT INTO ncr_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nlé nfî wo chiaaŋ yi Bajuu le mo bamii ba le gɛ Bajuu gɛ, nyu bo ba nlé ntûŋ wo fɛ bo le. ");
INSERT INTO ncr_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Wo lé wo gɛ̂ɛŋ wo gwênyɛ ajii aboo, wo bvûsɛ bo kijibɛ le, wo lêesɛ bo nyu yi n'yuu le, bo bû chiaaŋ yi Sataŋ le, bo nyû bɛ Nyo, bo lêe fitele ye yaŋ le, Nyo lɛ̂ɛshɛ bimbefɛ biboo. Bo mo bo kɛ̂me kijuu fɛ kijusɛ ki bamii ba wu le wu ge lɛ bo nyû be le.’ ");
INSERT INTO ncr_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Mbɛɛ, no fi gɛ̀ kooshɛ noo, mɛ mo ŋge gɛh no wu jɛme mɛne fɛwe ");
INSERT INTO ncr_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Mɛ mo n'ya ŋkɛ ntu nfeeji Damasku, fɛ ŋge ŋgɛɛŋ Yɛlusalɛm. Ntu njiɛnyi woŋ wù Judia le wuchii mo bituŋ le bichii bì le gɛ bi Bajuu gɛ, nfeeji bo le lɛ bo kûsɛ muntele muboo, bo tu bɛ Nyo, bo gêe nyu mwɛɛ mù duunyi lɛ bo le bo kusɛ wa. ");
INSERT INTO ncr_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Nɛ la fiɛɛ fì gɛ̀ ge fɛ Bajuu koo mɛ yeh yi kintanyɛ le bo goone ki bo yuuyɛ mɛ. ");
INSERT INTO ncr_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Geenɛ, Nyo tu wu fiih mɛ too bude abɛŋ. Mɛ mo ntu nlɛme fɛnɛ nfeeji tɛ bamii ba baaŋ baaŋ le mo ba shige shige le. Fiɛɛ fì nfeeji le gɛh fi fì Musɛ bɛ bamii ba ntuŋ wu Nyo gɛ̀ teede lɛ fi lé fi gê fi kôoshɛ. ");
INSERT INTO ncr_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Bo gɛ̀ duu lɛ Mbvusɛ wù Nyo gɛ̀ ka kɛme ki wu gê wu yɛŋ ŋgɛ, nyû muh wù fwe ki wu bû yi kwe le, wu dûnyɛ n'yuu fɛ Bajuu le mo bamii ba le gɛ Bajuu gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","No Bol gɛ̀ taanyi jwe we wu gɛɛne, Fɛstu ja wu waŋ lo wu jɛmɛ lɛ, “Bol wo jede wa lo. N'yɛyɛ wo wù baaŋ le wu ge wa wo ja wo jede lo.” ");
INSERT INTO ncr_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Bol chvuu Fɛstu le lɛ, “Gɛ njede gɛ muh wù baaŋ. Fiɛɛ fì njɛme le nchiɛɛŋ, njɛme bɛ bvufee bwaŋ fo. ");
INSERT INTO ncr_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Njɛme Nfoŋ le nɛ adaŋadaŋ, nje bo kee mwɛɛ munɛ, gɛ mu gɛ kooshi kijibɛ le gɛ, gɛ fimi nyu yu njɛ bo kee lo sɛŋ gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Mbɛɛ, bo le bo bɛɛŋ gɛ fiɛɛ fì Baŋwa ba bamii ba ntuŋ wu Nyo jɛme le? Ŋkee lɛ bo le bo bɛɛŋ.” ");
INSERT INTO ncr_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Nfoŋ Agliba biih Bol le lɛ, “Wo kwaji lɛ taŋlo wo fîisɛ mɛ ntû muh wu Kletu gɛh yi kife ki shige le nɛ?” ");
INSERT INTO ncr_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Bol chvuu lɛ, “Kɛnɛ ki le shige, kɛnɛ kì ndefe, buunɛ chaŋ fɛ Nyo le gɛh lɛ keefɛ ka wo maa gɛ. Muh wuchii wu le fɛnɛ abɛŋ wu yuge no njɛmɛ, wu fîisɛ tɛ wù nyû njɛ no nle, geenɛ fuge gɛh bancha banɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Nfoŋ ja we, muh wù sage bɛ Bɛni mo bamii ba bɛ bo gɛ̀ shilɛ ja tɛ we. ");
INSERT INTO ncr_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Bo bu, bo tu bo jɛme lɛbolɛbo lɛ, “Muh wunɛ baaŋ ge gɛ fiɛɛ fì ba yuuyɛ lo wu gɛ kɛnɛ ki ba leesɛ wu yeh yi ncha le gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Nfoŋ Agliba jɛmɛ Fɛstu le lɛ, “Be baaŋ nyu gɛ lɛ muh wunɛ le wu lɛgɛ wa lɛ nsa we gɛ̂ɛŋ fɛ Nfoŋ wu Lum le gɛ, tu ba be ba chinɛ wu le.” ");
INSERT INTO ncr_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Bo gɛ̀ doo bo seesɛ lɛ besa ba Bol lee a fitima fi a joo le be gɛɛŋ woŋ wù Itali le, bo mo bo nya Bol bɛ bamii bancha bamu chiaaŋ yi Juliu wù gɛ̀ bee kikwɛɛ ki ŋgoo yimi yi bamii ba nchi ba Nfoŋ wu Lum le. ");
INSERT INTO ncr_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Besa bo lee a ŋguh wù gɛ̀ ja Adamitiu le wù gɛ̀ bee ki wu gɛ̂ɛne wu lɛme manjuu ma yi ŋgɛɛme yi joo le, kimbe kì Ɛsia le. Alistaku muh wù Tɛsalonika, woŋ wù Masɛdonia le gɛ̀ bee tɛ besa bo. Besa bo mo be gɛɛne. ");
INSERT INTO ncr_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Akfuuŋ bu a yuu, bee fɛsɛ Sidoŋ, Juliu dunyɛ kiŋkoŋɛ fɛ Bol le, wu chinɛ wu le lɛ wu gɛɛŋ fɛ nsáa ye le a kilaantɛŋ le lɛ bo fi wu bɛ fiɛɛ fì wu goone. ");
INSERT INTO ncr_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Bee gɛ̀ kaasɛ be lee a fitima le fo, bee gɛ̀ doo be gɛɛne, fii tu yi too yi chidɛ bee fwe, bee mo be wɛɛne wa woŋ wù Sablu wu a joo ntɛnɛɛ le, wu tu wu chide fii. ");
INSERT INTO ncr_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Bee gɛ̀ gɛɛŋ be daŋ joo yì baaŋ yì le mbebe woŋ wù Silisia le bee ka bee daŋ yi mbebe yi woŋ wù Banfilia le, bee mo be fɛsɛ a kilaantɛŋ kì Mila le, woŋ wu Lisia le. ");
INSERT INTO ncr_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Kikwɛɛ ki ŋgoo yi bamii ba nchi kɛɛ gɛ̀ yɛŋ fitima fi a joo le yo fì gɛ̀ ja Alɛksanda fi gɛɛne Itali le, wu mo wu bvusɛ bee, be lee nyu a fifiɛɛ le. ");
INSERT INTO ncr_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Bee gɛ̀ ja fo, bee jiɛnyi gɛh nɛ wɛɛ wɛɛ yi aju a duude le, be gɛ̀ luŋ lo fɛ be fɛsɛ mbebe kilaantɛŋ kì Sinidu le. No fii gɛ̀ baaŋ bɛɛŋ gɛ lɛ be gɛɛŋ fwe chaaŋ gɛ, bee mo be mɛ be wɛɛne wa lo Klɛt woŋ wu fɛ joo ntɛnɛɛ le, wu chide fii, bee mo be fe Salmoni kijusɛ ki leese ki gɛɛne a joo yi woŋ wuyu le. ");
INSERT INTO ncr_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Bee mɛ gɛh be tu be wɛɛne be tuu ŋgɛɛme yi joo le, bee gɛ̀ luŋ lo fɛ be gɛɛŋ be bu kijusɛ kì ba tɛŋe lɛ Jwe wu Joo wù Nyiɛgee le, wù gɛ̀ bee mbebe kilaantɛŋ kì Lasia le. ");
INSERT INTO ncr_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","No bee gɛ̀ lɛsɛ wa kife a je wesee, Juu chi Baaŋ chi Nlɛɛshɛ Bimbefɛ gɛ̀ fe wa, nyu wa kife ki nfuŋ wù tɛɛme, Bol mo wu nya ntefɛ bamii ba a fitima le lɛ, ");
INSERT INTO ncr_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Bachii, n'yɛde lɛ kɛge fɛnɛ gɛɛne fwe njiɛnyɛ wese lé wu gê wu chɛ̂ŋɛ, kinla lé ki nyume yu, nyume gɛ ki mwɛɛ bɛ fitima maa gɛ, bamii lé bo gê bo kwêeyɛ tɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Geenɛ, kikwɛɛ ki bamii ba nchi faŋ ki bo yu jɛmɛ wu Bol, bo yu nyu fi chiji kikwɛɛ ki fitima bɛ chiji fitima. ");
INSERT INTO ncr_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","No jwe wu joo wuyu gɛ̀ baaŋ joŋ gɛ ki bee nyu fo yi kife ki nfuŋ wù tɛɛme le gɛ, bamii ba duude tu bo toone lɛ joŋe lɛ bo gɛ̂ɛne fwe, bo mone laa taŋlo bo fɛsɛ jwe wu joo wu Fonik le, wu le woŋ wù Klɛt ayu le, bo feesɛ kife kiyu fo. Jwe wu joo wuyu kwɛɛ gɛ̀ jiiŋe je awe awe wu ka jiiŋe tɛ je akuu akuu a juu seele yo. ");
INSERT INTO ncr_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Fii yimi gɛh ja yi tu yi bɛɛne je akuu akuu nɛ wɛɛ, bamii ba a fitima le tu bo kwaji lɛ bo kɛme wa fiɛɛ fì bo be goone. Bo mo bo baa kifase ki fitima, bo tu bo gɛɛne a joo, bo tuu gɛh ŋgɛɛme le ŋgɛɛme le Klɛt ayu. ");
INSERT INTO ncr_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Nfuŋ wù tɛɛme wu ba tɛŋe lɛ, “Wù je a kibo kiŋkoŋo le a juu saane yo”, gɛ̀ ja wu jaŋɛ gɛh nɛ woŋ wuyu le, wu shii a joo. ");
INSERT INTO ncr_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","No wu shile, wu kfuŋ fitima je gɛ ka yi nyu yu yi fi gɛɛne gɛ, bo mo bo chinɛ fitima le, nfuŋ tu wu tuude wu gɛɛne bɛ fi. ");
INSERT INTO ncr_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Bee tu be gɛɛne gɛ lo, be gɛɛŋ be fe akuu akuu a woŋ wumu wu shige le a joo ntɛnɛɛ ba tɛŋe lɛ Kawda. Woŋ wuyu tu wu chide fii, bee tu be lune ki be bɛɛŋsɛ ŋguh a fitima le. ");
INSERT INTO ncr_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Bee gɛ̀ bɛɛŋsɛ, be mo be kaaŋ fitima bɛ bakfuu lɛ keefɛ fi sâayɛ gɛ, bee doo be gɛɛne bee tu be faane lɛ fitima le fi gɛɛŋ fi kfuŋ ye mbebe woŋ wù Libia le yi biji bi munshɛɛŋ bì gɛ̀ bee a joo. Bo mo bo shiishɛ nju yi fii, bo chinɛ fitima tu fi gɛɛne lɛfilɛfi. ");
INSERT INTO ncr_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","No nfuŋ wuyu gɛ̀ tɛɛme gɛh wu gɛɛne lo, akfuuŋ bu a yuu, bo mo bo kɛ bo tu bo bvuuse mwɛɛ a fitima le, bo nooŋe a joo. ");
INSERT INTO ncr_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Bvu gɛ̀ bu bvu ka bvu yuu, bamii ba a fitima le bvusɛ mwɛɛ mu a fitima le, bo noŋ a joo bɛ chiaaŋ yiboo. ");
INSERT INTO ncr_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Aju gɛ̀ fe wesee bee baaŋ yɛŋ gɛ juu le gɛ kɛnɛ jóŋ, nfuŋ kfuune gɛh lo nyu gɛ wu wɛɛ gɛ, bee mo be kɛɛ lɛ fiesa le fi ka wa. ");
INSERT INTO ncr_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","No bamii gɛ̀ che wa aju a duude le bo baaŋ a ji gɛ fiɛɛ gɛ, Bol ja wu kɛŋsɛ wu lɛɛŋ fwe wu jɛmɛ lɛ, “Bachii, chi bee bɛŋ yu mɛne bee mɛ Klɛt, tu besabɛŋ baaŋ kɛmɛ gɛ ŋgɛ wunɛ bɛ kinla kinɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Geenɛ, nlɛge lɛ bɛŋ kaaŋ shɛ́ŋ, nje gɛ muh mu bɛŋ le nyume wu lɛsɛ gɛ, lé lɛ̂sɛ gɛh nyu fitima maa. ");
INSERT INTO ncr_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Njɛme nɛ nje Nyo wù kɛme mɛ, wù mbuune, chi wu tuŋ nchɛndaa we abɛŋ antaŋ wu to wu lɛɛŋ mbebe yaŋ le, ");
INSERT INTO ncr_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","wu jɛmɛ mɛne lɛ, ‘Bol, keefɛ wo fâane gɛ. Wo kɛme ki wo tô wo lɛ̂ɛŋ a Nfoŋ wu Lum fwe. Bîjɛ yɛ̂ŋ, Nyo le wu dunyɛ wa kiŋkoŋɛ fɛ wo le wu ge lɛ gɛ muh mu ŋgoo yi bamii ba bena bo le a fitima le nyu wu ge wu lɛsɛ gɛ.’ ");
INSERT INTO ncr_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Noo, bachii, bɛŋ kâaŋ shɛ́ŋ. Nle nleesɛ fitele yi Nyo le lɛ fiɛɛ fì wu jɛme mɛne ge fi kooshɛ gɛh yɛɛŋyɛɛŋ no wu jɛme. ");
INSERT INTO ncr_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","No fi le noo, fitima kɛme ki fi kfûŋ ye yi woŋ wumu le a joo ntɛnɛɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Lɛ to nyu aju ncho ana yuufe le nfuŋ baaŋ gɛh wu kɛde bɛ bee a joo yì baaŋ yi Adia le. Lɛ tu nyu gɛh njɛ antaŋ antɛnɛɛ, bamii ba lɛne a fitima le ja bo kwaji lɛ segemu bo bude wa mbebe yi nshɛŋ le. ");
INSERT INTO ncr_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Bo mo bo fe joo no yi juume bɛ kfuu ba nyu ba shɛŋshɛ fiɛɛ yu, bo yɛŋ lɛ yi le ŋkeŋe mbaaŋfiɛɛ. Bo kɛŋsɛ fwe, bo ka bo fe, bo yɛŋ yi kɛme wa nyu yuufe ncho yishɛŋ. ");
INSERT INTO ncr_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Bo tu bo faane lɛ taŋlo fitima gɛɛŋ fi kfuŋ ye yi bimbaaŋ le, bo mo bo shiishɛ bifase binɛh a joo a fitima jiŋ, bo tu bo buune laa akfuuŋ le a yuu gɛh lo la. ");
INSERT INTO ncr_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Bamii ba gɛ̀ lɛne a fitima le gɛ̀ ja bo goone ki bo legɛ bo bu a fitima le, bo mo bo shiishɛ ŋguh a joo, bo tu bo buuse lɛ bo goone ki bo shiishɛ bifase bi fitima bi fwe a joo. ");
INSERT INTO ncr_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Bol jɛmɛ kikwɛɛ ki bamii ba nchi le bɛ bamii be le lɛ, “Bamii banɛ moŋ lo bo bu a fitima le, muh mu bɛŋ le gɛ luŋ lo gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Bamii ba nchi mo bo suume bakfuu ba bo gɛ̀ shuuyɛ ŋguh yu, bo mo bo chinɛ ki wu lɛ̂ŋɛ wu gɛɛne. ");
INSERT INTO ncr_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","No bvu gɛ̀ doo bvu saaŋe, Bol lɛgɛ bamii bachii lɛ bo ji mwɛɛ, wu du lɛ, “Abɛŋ le wa aju yuufe ncho ana no bɛŋ le yi nfaaŋ le, fiɛɛ baaŋ a lee gɛ a bɛŋ mu gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Mɛ mo ntu nlɛge lɛ bɛŋ jî gɛh fiɛɛ, ye tû bɛŋ fo. Gɛ yvu yimimia nyu yi ge yi lɛsɛ lo a muh fwa gɛ.” ");
INSERT INTO ncr_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","No wu jɛmɛ noo, wu mo wu jo blɛd, wu nya kiyone Nyo le, wu bwɛɛdɛ wu tu wu jii a bamii bachii jii. ");
INSERT INTO ncr_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Bo mo bo kaaŋ shɛ́ŋ bachii bo ji mwɛɛ. ");
INSERT INTO ncr_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Bee bachii ba gɛ̀ bee a fitima le gɛ̀ bee muh gii yifɛɛ kicho mbaŋbvusooshwi ncho bvusoo (276). ");
INSERT INTO ncr_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Bamii bachii gɛ̀ ji mwɛɛ bo fuu, bo mo bo bvusɛ agiŋ a gɛ̀ bee a fitima le, bo noŋ a joo ki bo ge lɛ fi yâafɛ. ");
INSERT INTO ncr_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Akfuuŋ gɛ̀ yuu, kwa yɛnɛ, bamii ba lɛne a fitima le gɛ kɛɛ kijusɛ kiyu gɛ. Geenɛ, bo yɛŋ kiwuu le, ki gɛɛŋ ki bu yi munshɛɛŋ le, bo mo bo yɛŋ lɛ bo moŋ no fitima lee fi gɛɛŋ fi faaŋɛ yi ŋgɛɛme yi joo le. ");
INSERT INTO ncr_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Bo mo bo suumɛ bifase bie bi shii bi gɛɛŋ a joo, bo mo bo kaasɛ bo faanyɛ bakfuu ba bo gɛ̀ shuuyɛ bite bì ba fiise fitima yu, bo mo bo bɛɛŋsɛ tɛ nju yi fii yi fwe, fii lee yo yi tu yi doone fitima fi gɛɛne a kiwuu kiyu le. ");
INSERT INTO ncr_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Geenɛ, fi doo fi gɛɛne, fi kfuŋ ye yi kiji ki munshɛɛŋ le a joo. Kimbe ki fitima ki fwe lee ki chi yi ki le, ki faŋ fɛ ki ka ki shiŋshi. Joo mo yi tu yi kfuune kimbe ki ajiŋ ki saayi. ");
INSERT INTO ncr_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Bamii ba nchi mo bo ja bo tu bo goone lɛ bo yuuyɛ bamii bancha bachii lɛ keefɛ muh lɛ bo le ge wu ja wu tiigɛ joo wu bu wu legɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Geenɛ, kikwɛɛ ki bamii ba nchi tu ki goone lɛ ki fi Bol, ki mo ki kâŋ lɛ keefɛ bo gê noo gɛ, wu jɛmɛ fie lɛ bamii ba kee ki bo tiigɛ joo, bo ya bo selɛ a joo, bo tiigɛ bo bu kwa, ");
INSERT INTO ncr_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","kimbɛge ki bamii bîi yi bite bì badaa le mo yi bimbwɛɛyɛ bi fitima le. Le nɛ no bee gɛ̀ jiɛnyɛ bee fɛsɛ kwa bee bachii chuule. ");
INSERT INTO ncr_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","No bee gɛ̀ fɛsɛ kwa ayu chuule noo, bee mo be yu lɛ ba tɛŋe kijusɛ kiyu lɛ Malta, gɛ̀ bee woŋ wu fɛ joo ntɛnɛɛ. ");
INSERT INTO ncr_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Bamii ba woŋ kwɛɛ le dunyɛ kiŋkoŋɛ fɛ bee le ki duude wesee, bo fi bee, bo fwɛɛ ŋgu bee tu be yɛse, nje jaŋ gɛ̀ kɛ wa yi too fii gude bee. ");
INSERT INTO ncr_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Bol ja wu banyɛ ŋgaaŋ wu gɛɛŋ lɛ wu fwɛɛ, kifaa gɛ̀ bee ŋgaaŋ yiyu le, ŋgu yufɛ wu ge ki mo ki bû, ki luŋ kibo ke ki tu ki shiɛɛne yi ki le. ");
INSERT INTO ncr_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Bamii ba woŋ kwɛɛ le doo bo yɛŋ no ki shiɛɛne yi kibo ke le, bo mo bo tu bo jɛme lɛbolɛbo lɛ, “Muh wunɛ gɛ̀ bee wu yu wa muh. Wu bee wu bonɛ ki wu kwê a joo, geenɛ loŋ le wu koo wu wù nyu wu kwê.” ");
INSERT INTO ncr_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Geenɛ, Bol sɛsɛ lo kifaa kiyu ki gwe yi ŋgu le, fiɛɛ gɛ ge wu gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Bamii bayu mo bo tu bo chiɛɛne, bo kwaji lɛ ye yi Bol lé yi kɛ̂ yi bɛ̂ɛnyi, kɛnɛ lɛ wu lé wu jâ wu jâgɛ wu gwê nɛ wu kwê. Bo gɛ̀ chiɛɛŋ bo chiɛɛŋ sɛŋ, bo doo bo yɛŋ lɛ fiɛɛ baaŋ wu ge gɛ, bo mo bo kusɛ ŋkwajɛ wuboo, bo ja bo tu bo duu lɛ, “Muh wunɛ le nyo wumu.” ");
INSERT INTO ncr_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Muh wu sage yo gɛ̀ kɛme ŋɛɛ ye mbebe fɛ bee gɛ̀ bee fo. Jee chi muh wɛɛ nyu lɛ Bubliu. Wu fi bee, besa bo che aju atade wu jiiŋe fɛ bee le chuule. ");
INSERT INTO ncr_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Fi kooshɛ lɛ chiji Bubliu gɛ̀ gime wu chɛne bɛ kin'ya wu nyii wu fiiŋse. Bol mo wu gɛɛŋ fɛ wu gɛ̀ gime fo, wu buunɛ, wu gɛɛ chiaaŋ ye ye le, wu fɛ wu. ");
INSERT INTO ncr_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","No fi gɛ̀ kooshɛ noo, bamii ba woŋ kwɛɛ le bachii bo gɛ̀ kɛme binchɛŋ bo tu bo too Bol fɛde tɛ bo. ");
INSERT INTO ncr_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Bo tu bo nyaa bee bɛ mwɛɛ wesee. Bee gɛ̀ doo be jade yo, bo ka bo to bɛ mwɛɛ munchii mù bee gɛ̀ goone ba gɛɛ a fitima le. ");
INSERT INTO ncr_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Bee lee a fitima le bee tu be gɛɛne bee nyu be che wa Malta woŋ wu fɛ joo ntɛnɛɛ kwɛɛ le yi kii le yi tɛde. Fitima fiɛɛ gɛ̀ bee fi Alɛksanda ba tɛŋe lɛ Banyo ba le Amaŋ, Wu gɛ̀ bee woŋ kwɛɛ le wu chiɛɛne lɛ kife ki nfuŋ wù tɛɛme fe. ");
INSERT INTO ncr_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Bee gɛ̀ gɛɛŋ be bu jwe wu joo wu a kilaantɛŋ kì Silaku le, bee che yo aju atade, ");
INSERT INTO ncr_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","bee gɛ̀ ja yo, be gɛɛŋ be fɛsɛ jwe wu joo wu a kilaantɛŋ kì Lɛgium le bee che yo. Akfuuŋ bu a yuu, fii kɛ yi tu yi bɛɛne je akuu akuu, bee tu be gɛɛne, gɛ̀ bee yi aju le afaa, bee fɛsɛ jwe wu joo wù Butiole le. ");
INSERT INTO ncr_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","No bee fɛɛse yo, bee yɛŋ bamii ba mbɛmɛ ba yo le, bo lɛgɛ lɛ bee gɛɛŋ gɛh besa bo che aju bvusooshwi. Besa bo gɛ̀ che, fɛ bee gɛɛŋ be fɛsɛ Lum. ");
INSERT INTO ncr_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","No bee gɛ̀ gɛɛne, bamii ba mbɛmɛ ba Lum gɛ̀ doo bo yu lɛ bee too lo, bo bu bo tu bo jiɛnyi bo too lɛ besa bo tasɛ. Bo to bo bu mo fɛ Waaŋ wu Abiyu le, bɛ fɛ Yéh yi Bamii ba Njiɛnyɛ le Yishɛde. Bol yɛŋ bo le, fitele fie jiɛde, wu nya kiyone Nyo le. ");
INSERT INTO ncr_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Bee gɛ̀ fɛsɛ Lum, ba chinɛ Bol le wu tu wu chee fie wumaa, muh wu nchi chiɛɛne wu. ");
INSERT INTO ncr_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Aju gɛ̀ fe atade, Bol tɛɛŋ bikwɛɛ bi Bajuu bi yo. Bi to, wu jɛmɛ bo le lɛ, “Booŋ ba bwɛɛŋ, nle yi ncha le nɛ ba gɛ̀ kole mɛ nyu Yɛlusalɛm, ba nya mɛ chiaaŋ yi bamii ba Lum le, mbaaŋ njiaa gɛ lo fiɛɛ gɛ, bamii besa le, kɛnɛ kinche ki bachiji besa kimu le gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Bamii ba Lum baa gɛ̀ doo bo taa nsa waŋ, bo baaŋ yɛŋ gɛ fiɛɛ fì taŋlo bo yuuyɛ mɛ yi fi le gɛ. Bo mo bo tu bo goone ki bo chinɛ mɛne, ");
INSERT INTO ncr_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","geenɛ, Bajuu faŋ lo. Mɛ mo ntu nlɛgɛ lɛ nsa waŋ gɛɛŋ fwe fɛ Nfoŋ wu Lum le. Gɛ ŋgɛ̀ ŋgee noo, lɛ ŋkɛme fiɛɛ fì ŋkooyɛ yi bamii baŋ le gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Nɛ fiɛɛ fì ge mɛ fɛ ntɛɛŋ bɛŋ lɛ be jɛmɛ. Nle yi bancha banɛ le nɛ nyu nje muh wù besabɛŋ bamii ba Ishwala chi chiɛɛne.” ");
INSERT INTO ncr_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Bamii baa chvuu wu le lɛ, “Bee kɛmɛ gɛ ŋwa wù ja Judia kune wo gɛ, muh mu booŋ ba bwe wese ba jade yo bo too yanɛ bo baaŋ somɛ gɛ wo gɛ kɛnɛ bo jɛme fiɛɛ fì befe kune wo gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Geenɛ, bee lé be kôŋ ki be yû fiɛɛ fì wo kwaji. Fì bee kee le gɛh lɛ ŋgoo yinɛ yì wo le yi le bamii kaji gɛh lo yi manjuu le manchii.” ");
INSERT INTO ncr_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Bo mo bo gɛɛ juu chì bo lé bo tô Bol jɛ̂mɛ bo le. Lɛ to nyume abvu bwɛɛ, bamii taashɛ wesee fɛ wu gɛ̀ chee fo, wu kɛ ataana gɛɛne bude fɛnfu, wu naji fiɛɛ fichii bo le, wu feeji kune bvunfoŋ bvu Nyo. Wu ka wu jɛme wu duunyi mwɛɛ mu le a Ŋwa wu banchi ba Musɛ le bɛ a Baŋwa ba bamii ba ntuŋ wu Nyo le kune Jiso, wu mone ki wu gê bo bɛ̂ɛŋ lɛ fiɛɛ fì wu jɛme le nchiɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Bamii bamu bɛɛŋ fiɛɛ fì wu gɛ̀ jɛme le, Bamu faŋ ki bo bɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Bo ja bo saa lɛbolɛbo bo mo bo tu bo bude no Bol noŋ jɛ lɛ, “Fiɛɛ fì Kiyo ki Yuude gɛ̀ jɛmɛ bachiji bena le jwe wu muh wu ntuŋ wu Nyo wù Yosaya le, le nchiɛɛŋ. ");
INSERT INTO ncr_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Ki gɛ̀ jɛmɛ lɛ, ‘Gɛnɛ du bamii bayu le lɛ, bɛŋ lé bɛŋ gê bɛŋ yêge mwɛɛ chuule geenɛ bɛŋ yuge gɛ, bɛŋ jîiŋe mwɛɛ chuule geenɛ bɛŋ yɛne gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Fi le noo nje muntele mu bamii bayu le mu wɛɛ wa. Bo le bo baŋ wa bintuŋ biboo, bo kfugɛ ajii aboo. Bo ge noo lɛ keefɛ ajii aboo yɛ̂ne mwɛɛ le gɛ, keefɛ bintuŋ biboo yûge mwɛɛ gɛ, muntele muboo yûge gɛ, lɛ bo tu jiŋ fɛ mɛne, nfɛ bo.’” ");
INSERT INTO ncr_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Bol mo wu mɛsɛ lɛ, “Bɛŋ kêe lɛ saaka wunɛ wu kune no Nyo bvuuse bamii, le wu chiiŋsɛ wa fɛ bamii ba le gɛ Bajuu gɛ, bo nyu bo yu.” ");
INSERT INTO ncr_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","No wu jɛmɛ noo, Bajuu bayu mo bo ja bo bude, bo tɛɛnyi kintɛɛnyɛ yi njɛmɛ wuyu le, nyu gɛ ki wɛɛ gɛ. ");
INSERT INTO ncr_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Bol tu wu chee gɛh yeh yì wu gɛ̀ laaŋe lo le yi biluŋ le bifɛɛ, wu fii bamii bachii ba gɛ̀ too a wu le. ");
INSERT INTO ncr_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Wu tu wu feeji kune bvunfoŋ bvu Nyo, wu ka yɛyi bamii kune Tada Jiso Kletu, wu jɛme wu faane gɛ, muh jeese gɛ wu gɛ.");
INSERT INTO ncr_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Le mɛ wù Bol wù mwa lɛme wu Kletu Jiso. Nyo gɛ̀ bee wu tɛɛŋ mɛ lɛ nyûme mwa ntuŋ wu Jiso, wu gɛɛ lɛ nfêeji saaka wù joŋe wù wu Nyo. ");
INSERT INTO ncr_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Saaka wù joŋe wunɛ le wù Nyo gɛ̀ ka wa bamii yu nchensɛŋ fede yi bamii be ba ntuŋ le, no fi le ba saŋ a Ŋwa we wù yuude le. ");
INSERT INTO ncr_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Wu le kune Mwa ye wù gɛ̀ tu muh wu wuŋ, ba boo wu a kfuu chi Nfoŋ Dabi le. ");
INSERT INTO ncr_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Tada wese besabɛŋ wù Jiso Kletu, le Nyo gɛ̀ dunyɛ wu fede yi Kiyo ki Yuude le, lɛ le Mwa ye wù kɛme bvuŋga no wu gɛ̀ bvusɛ wu yi kwe le. ");
INSERT INTO ncr_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Ge Jiso Kletu fɛ Nyo baa mɛ lɛ mɛ nnyûme mwa ye wu ntuŋ, wu lɛ ŋgê bamii ba woŋ bachii ba le gɛ Bajuu gɛ lêesɛ fitele yi ye ye le, bo yûge nyu wu le bo yuuse jee che. ");
INSERT INTO ncr_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Bɛŋ tɛ le ŋgoo yi bamii ba Nyo le wu tɛɛŋ lɛ bo nyu bami