﻿USE sofia;
DROP TABLE IF EXISTS sofia.ncq_vpl;
CREATE TABLE ncq_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ncq_vpl WRITE;
INSERT INTO ncq_vpl VALUES ("PR1_1","021_1_1","PRO","1","1","1","ໄນ່ ລາ ມັຮ ປັຣນາຍ ປາລີ່ ພາຍາ ໂຊໂລໂມນ, ເຕືາວ ປັຣເຍືາ ກວາຍ ອິດຊະຣາເອລ, ກອນ ຣາເລົາ ດາວິດ. ");
INSERT INTO ncq_vpl VALUES ("PR1_2","021_1_2","PRO","1","2","2","ຕຶ່ງ ປຶ່ງ ໄນ່ ເບີນ ປັຣນາຍ ປາລີ່ ພາຍາ ໂອນ ເຍືາ ດັງ ແຈງ ແຕ ເກືາ ປັຣນາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ກະ ແຕ ປັຣນາຍ ຕຽຮ ອາຕີ ອຶນຕຣູ່ ລາລື່, ດໍອ໌ ຈ່ອຍ ໂອນ ເຍືາ ດັງ ແຈງ ແຕ ປັຣນາຍ ອຶນຕຣູ່ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR1_3","021_1_3","PRO","1","3","3","ມັຮ ປັຣນາຍ ປາລີ່ ພາຍາ ອາຣຍານ ໂອນ ເຍືາ ດັງ ແຕ ຕະ ເປາະ ໂອນ ຣາໄງ່ອ໌ ຣາລັ່ງ ຕຶ່ງ ແດີຍ ເຍືາ, ກະ ແກີດ ກວາຍ ຕານັ່ອງ ຕາປຶ່ງ, ຕະ ຣານະ ປຍາຍ໌ ອໍ, ກະ ຣານະ ມັນຕັ່ດ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR1_4","021_1_4","PRO","1","4","4","ປັຣນາຍ ປາລີ່ ພາຍາ ຕະ ໂອນ ກວາຍ ຕາ ເກີ່ຍ ຣຍານ ເຕ່ອ໌ ດັງ, ກະ ຕະ ໂອນ ກວາຍ ນຸ່ມ ດັງ ຕະ ຣານະ ໂອນ ກຣັ່ກ ອໍ, ");
INSERT INTO ncq_vpl VALUES ("PR1_5","021_1_5","PRO","1","5","5","ເຕ່ອ໌ ຈ່ອຍ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ໂອນ ດັງ ຊາອຶ່ຍ ລາລື່ ແອັນ, ກະ ຊາດອຍ ຣານາ ໂອນ ກວາຍ ກາ ດັງ ຊາອຶ່ຍ, ");
INSERT INTO ncq_vpl VALUES ("PR1_6","021_1_6","PRO","1","6","6","ຕະ ໂອນ ໄລ່ ເຕ່ອ໌ ຊາປຸ່ຮ ປັຣນາຍ ຊາກຳ ຣາໄລ່ຮ; ກະ ໂອນ ໄລ່ ດັງ ມັຮ ປັຣນາຍ ແກຣ່ະ ແຕ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ອາຕີ. ");
INSERT INTO ncq_vpl VALUES ("PR1_7","021_1_7","PRO","1","7","7","ຢຳນັ່ບ ເຢືາງ ເຈົາຣາຊີ ລາ ກັ່ລ ຣາໄງ່ອ໌ ຣາລັ່ງ. ມາ ມັຮ ກວາຍ ຊາກູລ ພາມາດ ຣາໄງ່ອ໌ ຣາລັ່ງ, ກະ ປາງາຍ ອີ ຣຍານ. ");
INSERT INTO ncq_vpl VALUES ("PR1_8","021_1_8","PRO","1","8","8","ກອນ ເອີຍ! ອຶງເຄາະ ໄມ່ ຊາງັດ ມັຮ ປັຣນາຍ ອຶມເປ່ອ໌ ອຶມປໍ່ ປາຕັບ, ກະ ອຶນໂຈຍ ຕັຮ ມັຮ ປັຣນາຍ ໄລ່ ຕຽຮ. ");
INSERT INTO ncq_vpl VALUES ("PR1_9","021_1_9","PRO","1","9","9","ມັຮ ປັຣນາຍ ໄລ່ ອາຕີ ໄມ່ ແກີດ ນ່ະ ກຸນຕຣວາອ໌ ເນົ່າ ອາປື່ງ ຕຶ່ງ ແປຼີ, ແຕີລາ ນ່ະ ກາຣັຮ ອາກວາອ໌ ຊັຣແຢັຮ ຕຶ່ງ ຕາກອງ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("PR1_10","021_1_10","PRO","1","10","10","ກອນ ເອີຍ! ຄັນ ມັຮ ກວາຍ ໂລ່ຍຮ ປັຣຕຶ່ ໄມ່, ໄມ່ ອຶນໂຈຍ ຕະ ຕາປູ່ນ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("PR1_11","021_1_11","PRO","1","11","11","ຄັນ ໄລ່ ປາຍ: “ໄມ່ ເປາະ ກະ ຮິ! ໄຮ ໂຕ່ະ ເກຣາະ ຕະ ມັຮ ກວາຍ ມັນຕັ່ດ ມັນດຍາຮ, ກະ ກາຈີດ ໄລ່ ໂອນ ເອິງ ຣາງຶ່ຮ ໄຮ! ");
INSERT INTO ncq_vpl VALUES ("PR1_12","021_1_12","PRO","1","12","12","ໄຮ ກາຈີດ ຕັຮ ໄລ່, ນ່ະ ປີ່ງ ກູມູ່ຍ໌ ຕາລວາມ ກວາຍ ອາມົ່ງ, ກະ ກູແຕັລ ອາປັອງ ໄລ່ ກາ ບັນ ເຣ່ງ ຕຶ່ງ ຕຣຸ່ງຕຣັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR1_13","021_1_13","PRO","1","13","13","ໄຮ ອີ ຣາມົຮ ມັຮ ເກຣີ່ງ ເບີນ ເກືາ ຊາອຶ່ຍ, ເຈີ່ ປູຣ ອາເຈົາ ໂອນ ປັ່ນ ດຸງ ໄຮ. ");
INSERT INTO ncq_vpl VALUES ("PR1_14","021_1_14","PRO","1","14","14","ເຢີ່ ແຕີ່ອ໌ ແອີດ ກະ ຮິ! ເຈີ່ ໄຮ ຣຳແປອ໌ ເກຣີ່ງ ກາ ໄຮ ຕວຍ໌.” ");
INSERT INTO ncq_vpl VALUES ("PR1_15","021_1_15","PRO","1","15","15","ກອນ ເອີຍ! ໄມ່ ອຶນໂຈຍ ເປາະ ກະ ໄລ່; ອຶງເຄາະ ໄມ່ ວຍາຣ ເຢີ່ງ ແຕ ຣານາ ໄລ່ ເປາະ. ");
INSERT INTO ncq_vpl VALUES ("PR1_16","021_1_16","PRO","1","16","16","ໄລ່ ກຸນເຕົາ ລາລື່ ອີ ຕະ ຣານະ ຕາ ອໍ. ໄລ່ ຕາຣວາລ ອີ ກາຈີດ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("PR1_17","021_1_17","PRO","1","17","17","ຄັນ ແຈມ ເຮີມ ບັອງ ກາ ກວາຍ ຢັ່ງ ມ່ອງ, ລາ ຕາ ເບີນ ແກີດ ເກືາ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR1_18","021_1_18","PRO","1","18","18","ມາ ມັຮ ກວາຍ ຕາ ອໍ ກັອຍ, ນ່ະ ຕານ ຊາງ ກູວາງ ຈະ ເບີມ. ເຈີ່ ກາຈີດ ຈະ ເບີມ ຕຶ່ງ ຊາງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR1_19","021_1_19","PRO","1","19","19","ມູເຈິງ ກັອຍ ເຕ່ ກວາຍ ມັ່ກ ກຸມປູ່ຣ ກູເວືາດ ເກຣີ່ງ ເນົ່າ, ແດີຍ ອາມົ່ງ ອັນ ແກີດ ປິ່ດ. ");
INSERT INTO ncq_vpl VALUES ("PR1_20","021_1_20","PRO","1","20","20","ຊາງັດ ກັອຍ! ຊຽງ ຣາໄງ່ອ໌ ຣາລັ່ງ ຊາບາວ ຕຶ່ງ ມັຮ ຣານາ, ກະ ກາເລີຍ໌ ຕຶ່ງ ມັຮ ຕາລາດ. ");
INSERT INTO ncq_vpl VALUES ("PR1_21","021_1_21","PRO","1","21","21","ຊຽງ ກັອຍ ໂດງ ແຕີ່ອ໌ ມັຮ ງັ່ຮ ຕົ່ງ ວຍາງ ເມືອງ, ປໍ ອຶນຕຸ ກອນແຊມ ດຸ ໂຣ່ມ ຣາໂຊ ມັນຕຸ, ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("PR1_22","021_1_22","PRO","1","22","22","“ມັຮ ກວາຍ ຊາກູລ ເອີຍ! ອຶນນັ່ອງ ມາແລ່ະ ດູ່ນ ເຍືາ ອີ ແກີດ ຊາກູລ? ອຶນນັ່ອງ ມາແລ່ະ ດູ່ນ ເຍືາ ຢໍອ໌ ອີ ພາມາດ ຣາໄງ່ອ໌ ຣາລັ່ງ? ອຶນນັ່ອງ ມາແລ່ະ ດູ່ນ ເຍືາ ປາງາຍ ອີ ຣຍານ ໂອນ ດັງ? ");
INSERT INTO ncq_vpl VALUES ("PR1_23","021_1_23","PRO","1","23","23","ອຶງເຄາະ ເຍືາ ຊາງັດ ແຕີ່ອ໌ ເກົາ ກາໄຕ່ຮ ອາຕີ; ເກົາ ອີ ຕຽຮ ຣາມຶ່ຮ ອໍ ໂອນ ເຍືາ, ກະ ອີ ອຶມແປອ໌ ຣາໄງ່ອ໌ ຣາລັ່ງ ໂອນ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("PR1_24","021_1_24","PRO","1","24","24","ເກົາ ກູອ໌ ເຍືາ, ມາ ເຍືາ ຕາ ເບີນ ຕາແອີຍ; ເກົາ ກູວອຍ໌ ເຍືາ, ມາ ເຍືາ ຕາ ເບີນ ຣາບູລ ເລີຍ. ");
INSERT INTO ncq_vpl VALUES ("PR1_25","021_1_25","PRO","1","25","25","ເຍືາ ຕະ ງິ່ລ ງູງິ່ລ ລາລື່ ແຕ ຊັນຕອຍ໌ ເກົາ ຕຽຮ ອາຕີ, ກະ ຕາ ແອອ໌ ອີ ໂອນ ເກົາ ຕາໄມຮ. ");
INSERT INTO ncq_vpl VALUES ("PR1_26","021_1_26","PRO","1","26","26","ຍ່ອນ ນ່ະກັອຍ, ແຕີ່ອ໌ ເຍືາ ຣາມົຮ ຕຸ່ຮ ກັ່ດ, ລື່ ເກົາ ກາຈັງ ອາເຢ່ ເຍືາ. ແຕີ່ອ໌ ເຍືາ ອຶງກັອຮ ປັຣຢິ່ຣ, ເກົາ ອີ ກາຈັງ ເຈືາດ ພາມາດ ເຣືາງ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("PR1_27","021_1_27","PRO","1","27","27","ໄຈ ລາລື່ ເຍືາ ແກີດ ກູຈີດ ປິ່ດ ນ່ະ ກູຢາລ ຣາປູ່ອ໌, ກະ ອາກັນ ເກຣ່າະ ກຣຍາດ ແຕີ່ອ໌ ປໍ ເຍືາ ນ່ະ ກູຢາລ ອາເວ່ງ; ລື່ ເຍືາ ເບີນ ຕຸ່ຮ ງໍ່ ກະ ຕຸ່ຮ ກັ່ດ. ");
INSERT INTO ncq_vpl VALUES ("PR1_28","021_1_28","PRO","1","28","28","ບັອງ ກັອຍ ແຕິ່ ເຍືາ ກູອ໌ ເກົາ, ມາ ເກົາ ຕາ ເບີນ ຕາແອີຍ; ເຍືາ ຈໍ່ອ໌ ເກົາ ກູ່ ອຶນຕຸ, ມາ ເຍືາ ຕາ ເບີນ ຣາມົຮ. ");
INSERT INTO ncq_vpl VALUES ("PR1_29","021_1_29","PRO","1","29","29","ເຍືາ ຕາ ແອອ໌ ອີ ຣຍານ, ກະ ເຍືາ ຕາ ແອອ໌ ອີ ຢຳນັ່ບ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("PR1_30","021_1_30","PRO","1","30","30","ເຍືາ ຕາ ແອອ໌ ອີ ຊາງັດ ເລີຍ ຊັນຕອຍ໌ ເກົາ ຕຽຮ ອາຕີ, ກະ ເຍືາ ຕາ ເບີນ ຣາມິ່ງ ເລີຍ ແຕີ່ອ໌ ເກົາ ຕາໄມຮ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("PR1_31","021_1_31","PRO","1","31","31","ຍ່ອນ ນ່ະກັອຍ, ລື່ ເຍືາ ເບີນ ຣັ່ບ ເກືາ ຕາປູ່ນ ມັຮ ຣານະ ຕາ ອໍ ເຍືາ ຕະ. ກະ ຍ່ອນ ແຕ ຊາອຶ່ຍ ເງ່ ຕາ ອໍ ເຍືາ ອາລັ່ອຮ, ເຍືາ ແກີດ ນ່ະ ຈາ ປາໄຊ ປາລາງ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("PR1_32","021_1_32","PRO","1","32","32","ມັຮ ກວາຍ ຊາກູລ ກູຈີດ ຍ່ອນ ໄລ່ ຕາ ແອອ໌ ຣາໄງ່ອ໌ ຣາລັ່ງ; ຣາມຶ່ຮ ກູຈີດ ປິ່ດ ແຕີ່ອ໌ ປໍ ໄລ່ ຍ່ອນ ໄລ່ ຕາ ເບີນ ຣາບູລ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR1_33","021_1_33","PRO","1","33","33","ມາ ກວາຍ ອາແລ່ະ ຕະ ຕາປູ່ນ ເກົາ, ກວາຍ ກັອຍ ແອີດ ກຼີດ ກຼອດ ຈອດ ອໍ. ອັນ ຕາ ເບີນ ຄຶ່ດ ອຶງກັອຮ ອາກັນ ເກຣ່າະ ກຣຍາດ ອຶນເຕົ່າ ແຕີ່ອ໌ ປໍ ອັນ.” ");
INSERT INTO ncq_vpl VALUES ("PR2_1","021_2_1","PRO","2","1","1","ກອນ ເອີຍ! ອຶງເຄາະ ໄມ່ ອີດ ມັຮ ຊັນຕອຍ໌ ເກົາ ອາຕີ, ກະ ອຶນໂຈຍ ຊາລີຣ ມັຮ ຣາມຶ່ຮ ເກົາ ແປຣີ ໄມ່ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("PR2_2","021_2_2","PRO","2","2","2","ອຶງເຄາະ ໄມ່ ປາແຈງ ກູຕູຣ ຊາງັດ ມັຮ ເງ່ ຣາໄງ່ອ໌ ຣາລັ່ງ, ກະ ອຶງເຄາະ ໄມ່ ກູຕົງ ອຶນແຍ່ະ ຣາງຶ່ຮ ໂອນ ດັງ ແຕ ເງ່ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR2_3","021_2_3","PRO","2","3","3","ອຶງເຄາະ ໄມ່ ກູໂກຼຍ໌ ແຊອ໌ ໂອນ ດັງ, ກະ ຊາບາວ ຈໍ່ອ໌ ໂອນ ຊາປຸ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("PR2_4","021_2_4","PRO","2","4","4","ອຶງເຄາະ ໄມ່ ຈໍ່ອ໌ ຣາໄງ່ອ໌ ຣາລັ່ງ ນ່ະ ໄມ່ ຈໍ່ອ໌ ປຣະ, ແຕີລາ ມັຮ ມູ່ນ ເນົ່າ ປາໂຕ່ະ ດໍອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR2_5","021_2_5","PRO","2","5","5","ຄັນ ໄມ່ ຕະ ນ່ະກັອຍ, ລາ ໄມ່ ດັງ ຢຳນັ່ບ ອຶນເຈົາ ໄຮ; ກະ ເຕ່ອ໌ ຣາມົຮ ກະ ດັງ ເງ່ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("PR2_6","021_2_6","PRO","2","6","6","ເຢືາງ ເຈົາຣາຊີ ລາ ອັນ ກາ ໂອນ ຣາໄງ່ອ໌ ຣາລັ່ງ; ຊັນຕອຍ໌ ແຕ ແບອ໌ ອັນ ຕະ ໂອນ ກວາຍ ເຕ່ອ໌ ດັງ ກະ ເຕ່ອ໌ ຊາປຸ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("PR2_7","021_2_7","PRO","2","7","7","ອັນ ເນ່ ມັຮ ກວາຍ ກາ ເບີນ ຣາງຶ່ຮ ຕານັ່ອງ ອໍ, ອັນ ຊາລີອ໌ ມັຮ ກວາຍ ກາ ຕະ ປຍາຍ໌ ເລືອຍໆ. ");
INSERT INTO ncq_vpl VALUES ("PR2_8","021_2_8","PRO","2","8","8","ອັນ ກຸ່ມກຍາອ໌ ມັຮ ກວາຍ ຕະ ຣານະ ຕານັ່ອງ ຕາປຶ່ງ, ກະ ກູຣຍາອ໌ ດໍອ໌ ໄລ່ ກາ ຊາອຳ ອັນ ປຍາຍ໌ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR2_9","021_2_9","PRO","2","9","9","ຄັນ ໄມ່ ຊາງັດ ເກົາ, ເຈີ່ ໄມ່ ເຕ່ອ໌ ດັງ ຣານະ ຕານັ່ອງ ອໍ, ຣານະ ປຍາຍ໌, ກະ ຣານະ ມັນຕັ່ດ ມັນດຍາຮ. ກູ່ ຣາມຶ່ຮ ອໍ ກັອຍ ລາ ໄມ່ ເຕ່ອ໌ ຕະ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("PR2_10","021_2_10","PRO","2","10","10","ນ່ະກັອຍ ລື່ ໄມ່ ແກີດ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ, ກະ ຣາງຶ່ຮ ໄມ່ ຊັອງ ຣໍ່ອ໌ ຍ່ອນ ແຕ ມັຮ ເງ່ ໄມ່ ດັງ. ");
INSERT INTO ncq_vpl VALUES ("PR2_11","021_2_11","PRO","2","11","11","ຍ່ອນ ໄມ່ ດັງ ເງ່ ຕະ ກຣັ່ກ ອໍ ກະ ໄມ່ ຊາປຸ່ຮ ແຕ ມັຮ ເງ່ ປຍາຍ໌, ລື່ ມັຮ ຣາມຶ່ຮ ກັອຍ ກູຣຍາອ໌ ໄມ່, ");
INSERT INTO ncq_vpl VALUES ("PR2_12","021_2_12","PRO","2","12","12","ກະ ກາຕັງ ໄມ່ ຕາ ໂອນ ຕະ ຣານະ ໂລ່ຍຮ. ກະ ຣານະ ໄນ່ ຈ່ອຍ ໄມ່ ໂອນ ແວັດ ແຕ ກວາຍ ແຣັ່ງ ກາ ຕະ ອຶນຕີ ຕຳໄບອ໌ ຕຳບັອງ. ");
INSERT INTO ncq_vpl VALUES ("PR2_13","021_2_13","PRO","2","13","13","ກວາຍ ກັອຍ ຕັຮ ເຈີ່ ຣານາ ຕານັ່ອງ ອໍ ອີ ເປາະ ຕຶ່ງ ຣານາ ການຳ ແອັນ; ");
INSERT INTO ncq_vpl VALUES ("PR2_14","021_2_14","PRO","2","14","14","ກວາຍ ກັອຍ ຊັອງ ຣໍ່ອ໌ ຕຶ່ງ ຣານະ ຕາ ອໍ, ກະ ມັ່ກ ຕະ ກູຈົກ ກູຈີວ ກູວີວ ກູວາວ; ");
INSERT INTO ncq_vpl VALUES ("PR2_15","021_2_15","PRO","2","15","15","ຕຶ່ງ ແດີຍ ອາມົ່ງ ໄລ່ ຕະ ແອີງ ໂກ່ະ ກີ່ ຊັອງ, ກະ ຣານາ ໄລ່ ຕາ ເບີນ ຕານັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("PR2_16","021_2_16","PRO","2","16","16","ໄມ່ ເຕ່ອ໌ ວຍາຣ ແຕ ມັນແຊມ ກາ ເປາະ ປັຣລື່ຍ, ລາ ມັນແຊມ ກາ ປິ່ ປຣຸ່ງ ໂອນ ປັອງ ຕໍ ຊາຣັອງ ໂອນ ຈວາດ ຕຶ່ງ ຣານະ ໂລ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("PR2_17","021_2_17","PRO","2","17","17","ມັນແຊມ ໄນ່ ຕາ ເບີນ ຕານັ່ອງ ໂຈະ ກາຢາອ໌ ອັນ ແຕ ຕາແບິ, ກະ ອັນ ຊາລີຣ ມັຮ ຊັນຕອຍ໌ ກາ ອັນ ປັຣຄັນ ຢັ່ຮ ເມືາງ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("PR2_18","021_2_18","PRO","2","18","18","ຄັນ ໄມ່ ມາ ເປາະ ປໍ ອຶນຕຸ ມັນແຊມ ກັອຍ ແອີດ, ລາ ນ່ະ ໄມ່ ເປາະ ຕຶ່ງ ຣານາ ກູຈີດ, ຍ່ອນ ຣານາ ກັອຍ ເປາະ ປໍ ອຶນຕຸ ກວາຍ ກູຈີດ ແອີດ. ");
INSERT INTO ncq_vpl VALUES ("PR2_19","021_2_19","PRO","2","19","19","ອາແລ່ະ ກາ ເປາະ ລາເງີ່ບ ມັນແຊມ ກັອຍ ລາ ຈວາຍ໌ ຊັຣລຸ ໂບະ ກັລ. ແດີຍ ອາມົ່ງ ອັນ ແກີດ ແກຼິກຼູ່ ຣູ່ບາ ເລີຍ. ");
INSERT INTO ncq_vpl VALUES ("PR2_20","021_2_20","PRO","2","20","20","ຍ່ອນ ນ່ະກັອຍ, ໄມ່ ອຶງເຄາະ ດວຍ໌ ເຕຣ່ງ ກວາຍ ອໍ, ກະ ຕະ ເປາະ ຕຶ່ງ ປັຣຊັອຮ ອາແລ່ະ ກາ ຕອຍ ປັຣຮອຍ ອາແລ່ະ ກາ ປຍາຍ໌. ");
INSERT INTO ncq_vpl VALUES ("PR2_21","021_2_21","PRO","2","21","21","ຍ່ອນ ແອີງ ມັຮ ກວາຍ ຊາເບິງ ກະ ກວາຍ ຕານັ່ອງ ອໍ ຊັອງ ເບີນ ແອີດ ຕຶ່ງ ກຣວາງ ກູແຕອ໌ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("PR2_22","021_2_22","PRO","2","22","22","ມາ ລື່ ເຢືາງ ເຈົາຣາຊີ ຕູ່ຍຮ ອາລັ່ອຮ ມັຮ ກວາຍ ຕາ ອໍ ແຕ ກູແຕອ໌ ກັອຍ, ກະ ປູ່ຍ໌ ອຶນແຍ່ະ ມັຮ ກວາຍ ໂລ່ຍຮ ນ່ະ ເນົ່າ ເຣີ່ອ໌ ກັ່ລ ອາລ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("PR3_1","021_3_1","PRO","3","1","1","ກອນ ເອີຍ! ອຶນໂຈຍ ຊາລີຣ ແຕ ມັຮ ຣາມຶ່ຮ ເກົາ ອາຕີ. ອຶງເຄາະ ໄມ່ ເຈີ ດໍອ໌ ຕຶ່ງ ຣາງຶ່ຮ ມັຮ ຣາມຶ່ຮ ເກົາ ປາຕັບ. ");
INSERT INTO ncq_vpl VALUES ("PR3_2","021_3_2","PRO","3","2","2","ປັຣນາຍ ເກົາ ຕຽຮ ອາຕີ ເຕ່ອ໌ ໂອນ ໄມ່ ແກີດ ກົງ ອາມົ່ງ ດູ່ນ, ກະ ເບີນ ບັນຊວານ ອຽນ ອໍ ຕຶ່ງ ກູ່ ຣານະ ໄມ່ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("PR3_3","021_3_3","PRO","3","3","3","ອຶນໂຈຍ ຕັຮ ເລີຍ ຣາງຶ່ຮ ອາໂຢ່ະ ປາຊິ ກະ ຣາງຶ່ຮ ຕານັ່ອງ ຕາປຶ່ງ. ອຶງເຄາະ ໄມ່ ອີດ ມັຮ ຣາມຶ່ຮ ກັອຍ ອຶງກວາອ໌ ດໍອ໌ ຕຶ່ງ ຕາກອງ; ອຶງເຄາະ ໄມ່ ຄຽນ ດໍອ໌ ຕຶ່ງ ຣາງຶ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("PR3_4","021_3_4","PRO","3","4","4","ເຈີ່ ໄມ່ ແກີດ ດັອຮ ບຸມບວລ ຮູລ ຢຸນຢົ່ງ, ກະ ເຢືາງ ເຈົາຣາຊີ ກະ ມັຮ ກວາຍ ຊັອງ ຣໍ່ອ໌ ຣາງຶ່ຮ ກະ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("PR3_5","021_3_5","PRO","3","5","5","ອຶງເຄາະ ໄມ່ ຊາອຳ ເຢືາງ ເຈົາຣາຊີ ອຶນແຍ່ະ ຣາງຶ່ຮ ຣາແຮີ. ອຶນໂຈຍ ປັ່ອງ ແຕ ຣາມຶ່ຮ ໄມ່ ຄຶ່ດ ປາຍ ດັງ. ");
INSERT INTO ncq_vpl VALUES ("PR3_6","021_3_6","PRO","3","6","6","ອຶງເຄາະ ໄມ່ ຄຶ່ດ ອຶນໂຍ່ງ ປໍ ເຢືາງ ເຈົາຣາຊີ ແຕ ກູ່ ຣານະ ໄມ່ ອີ ຕະ, ເຈີ່ ເມ່ນ ອັນ ໂອນ ໄມ່ ເຮີມ ຣານາ ປຍາຍ໌ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR3_7","021_3_7","PRO","3","7","7","ອຶນໂຈຍ ຄຶ່ດ ປາຍ ໄມ່ ດັງ ກາເລີຍ ແຕ ກວາຍ ການໍ່ອ໌; ມາ ອຶງເຄາະ ໄມ່ ຕະ ຕາປູ່ນ ເຢືາງ ເຈົາຣາຊີ, ກະ ວຍາຣ ເຢີ່ງ ແຕ ຣານະ ຕາ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR3_8","021_3_8","PRO","3","8","8","ຄັນ ໄມ່ ຕະ ນ່ະກັອຍ, ລາ ແກີດ ນ່ະ ຣາເຮົາ ແບຼງ ດໍອ໌ ປົວ ເບິ ໄມ່, ກະ ຕະ ບັນ ກູ່ ຣາມຶ່ຮ ອາອີ່. ");
INSERT INTO ncq_vpl VALUES ("PR3_9","021_3_9","PRO","3","9","9","ອຶງເຄາະ ໄມ່ ຢຳນັ່ບ ເຢືາງ ເຈົາຣາຊີ ກະ ມ່ອບ ຊາງ ມູ່ນມັ່ງ ຊັງ ຊານາ ໄມ່ ໂອນ ອັນ, ກະ ມ່ອບ ຊາງ ມັຮ ປາໄລ ຊັຣນົຮ ໄມ່ ອີດ ແຕ ຕາແບິ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR3_10","021_3_10","PRO","3","10","10","ຄັນ ໄມ່ ຕະ ນ່ະກັອຍ, ໄມ່ ເບີນ ໂດຍ ຕາ ຣາລໍ່ ທຣໍ ຕາ ຣາລິ່ຮ, ກະ ເບີນ ບຼັອງ ອາງຸ່ນ ແກຼີຍ ເກຼືາຍ ເຕົ່າ ແອິ ອຶນຕຸ ອີ ດໍອ໌ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("PR3_11","021_3_11","PRO","3","11","11","ກອນ ເອີຍ! ແຕີ່ອ໌ ເຢືາງ ເຈົາຣາຊີ ແອບ ອາຕີ, ອຶງເຄາະ ໄມ່ ອຶນໂຈຍ ພາມາດ, ກະ ອຶນໂຈຍ ຕາ ເມ່ນ ຕະ ມັຮ ປັຣນາຍ ອັນ ຕາໄມຮ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("PR3_12","021_3_12","PRO","3","12","12","ເຢືາງ ເຈົາຣາຊີ ແອບ ອາຕີ ມັຮ ກວາຍ ກາ ອັນ ອາໂຢ່ະ, ນ່ະ ອຶມປໍ່ ແອບ ອາຕີ ກອນ ກາ ອັນ ປາຊິ. ");
INSERT INTO ncq_vpl VALUES ("PR3_13","021_3_13","PRO","3","13","13","ບຸ່ນ ລາລື່ ແຕີ່ອ໌ ປໍ ກວາຍ ກາ ຣາມົຮ ອາກັນ ຣາໄງ່ອ໌ ຣາລັ່ງ, ລາ ກວາຍ ກາ ເບີນ ຣາງຶ່ຮ ຊາປຸ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("PR3_14","021_3_14","PRO","3","14","14","ຣາໄງ່ອ໌ ຣາລັ່ງ ລາ ເກືາ ເປ່ງ ກາເລີຍ ແຕ ປຣະ ແຢງ. ");
INSERT INTO ncq_vpl VALUES ("PR3_15","021_3_15","PRO","3","15","15","ຣາໄງ່ອ໌ ຣາລັ່ງ ເບີນ ເກືາ ກາເລີຍ ແຕ ມັຮ ຕາເມົາ ເປ່ງ, ລື່ ຕາ ເບີນ ຣາມຶ່ຮ ອຶນເຕົ່າ ກວາຍ ຢໍອ໌ ອີ ເບີນ, ມາ ເຕ່ອ໌ ຕາລີ ກະ ຣາໄງ່ອ໌ ຣາລັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR3_16","021_3_16","PRO","3","16","16","ຣາໄງ່ອ໌ ຣາລັ່ງ ໂອນ ໄມ່ ເຕ່ອ໌ ແກີດ ກົງ ອາມົ່ງ ດູ່ນ, ແກີດ ຊຸ ອາຊັອຮ ກະ ເບີນ ຊະເຢືາງ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("PR3_17","021_3_17","PRO","3","17","17","ຣາໄງ່ອ໌ ຣາລັ່ງ ຕະ ໂອນ ແດີຍ ອາມົ່ງ ໄມ່ ຣໍ່ອ໌ ອໍ, ກະ ເດີງ ໄມ່ ປໍ ອຶນຕຸ ອຽນ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR3_18","021_3_18","PRO","3","18","18","ຣາໄງ່ອ໌ ຣາລັ່ງ ລາ ນ່ະ ອາລ່ອງ ໂອນ ກວາຍ ເຕ່ອ໌ ອາມົ່ງ; ບຸ່ນ ລາລື່ ກວາຍ ກາ ໂປຍ໌ ດໍອ໌ ປາໄລ ແຕ ກັ່ລ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR3_19","021_3_19","PRO","3","19","19","ເຢືາງ ເຈົາຣາຊີ ແຕງ ກຣວາງ ກູແຕອ໌ ໄນ່ ຍ່ອນ ຣາໄງ່ອ໌ ຣາລັ່ງ ແຕ ອັນ; ຍ່ອນ ແຕ ອັນ ດັງ, ນ່ະກັອຍ ເຕ່ອ໌ ອັນ ອາຈຸຮ ມັນລັ່ອງ ໂອນ ແອີດ ຕຶ່ງ ມວຍ ອຶນຕຸ. ");
INSERT INTO ncq_vpl VALUES ("PR3_20","021_3_20","PRO","3","20","20","ອັນ ດັງ ຕະ ໂອນ ແດີອ໌ ກູລິ່ຮ ອາລັ່ອຮ, ກະ ຕະ ໂອນ ຣາມິ່ລ ແກີດ ແດີອ໌ ເມືາ ແຊງ ປໍ ກຣວາງ ກູແຕອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR3_21","021_3_21","PRO","3","21","21","ກອນ ເອີຍ! ອຶງເຄາະ ໄມ່ ຢຸມ ໂອນ ຈັບ ອາກັນ ຣາໄງ່ອ໌ ຣາລັ່ງ ກະ ດັງ ຕະ ໂອນ ກຣັ່ກ ອໍ. ອຶນໂຈຍ ໂອນ ບາຣ ຣາມຶ່ຮ ໄນ່ ຣາຕັຮ ແຕ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("PR3_22","021_3_22","PRO","3","22","22","ບາຣ ຣາມຶ່ຮ ກັອຍ ລື່ ຕະ ໂອນ ໄມ່ ເບີນ ອາມົ່ງ, ກະ ແກີດ ນ່ະ ຈຸ່ ໄມ່ ອຶງກວາອ໌ ຕຶ່ງ ຕາກອງ. ");
INSERT INTO ncq_vpl VALUES ("PR3_23","021_3_23","PRO","3","23","23","ໄມ່ ເຕ່ອ໌ ຕາຢັຮ ເປາະ ກຼີດ ກຼອດ ຈອດ ອໍ, ກະ ຕາ ເບີນ ກູຕົ່ຮ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR3_24","021_3_24","PRO","3","24","24","ແຕີ່ອ໌ ໄມ່ ມູ່ດ ບິ, ລາ ໄມ່ ຕາ ເບີນ ຊັອງ ອຶງກັອຮ ອຶນເຕົ່າ, ກະ ໄມ່ ເຕ່ອ໌ ບິ ລາງ່ຳ ກ່ຳ ລາເງ່ດ. ");
INSERT INTO ncq_vpl VALUES ("PR3_25","021_3_25","PRO","3","25","25","ໄມ່ ຕາ ເບີນ ຄຶ່ດ ນັ່ອງ ແຕ ກູຈີດ ປິ່ດ ກາ ແຕີ່ອ໌ ໄຈ ລາລື່ ປໍ ກວາຍ ຕາ ອໍ, ນ່ະ ກູຢາລ ຣາປູ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR3_26","021_3_26","PRO","3","26","26","ເຢືາງ ເຈົາຣາຊີ ອີ ກຸ່ມກຍາອ໌ ກູຣຍາອ໌ ດໍອ໌ ໄມ່. ອັນ ຕາ ເບີນ ຕັຮ ໄມ່ ໂອນ ຈວາດ ຕຶ່ງ ຣາບາງ ເນົ່າ ຕໍ ດໍອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR3_27","021_3_27","PRO","3","27","27","ບັອງ ແລ່ະ ໄມ່ ເຕ່ອ໌ ຈ່ອຍ, ລາ ອຶງເຄາະ ໄມ່ ຈ່ອຍ ມັຮ ກວາຍ ກາ ເບີນ ຕຸ່ຮ ກັ່ດ. ");
INSERT INTO ncq_vpl VALUES ("PR3_28","021_3_28","PRO","3","28","28","ອຶນໂຈຍ ໂອນ ເຢົ່າ ແອີດ ເກຣາະ ໄມ່ ແຕີ່ອ໌ ຕາໄງ ປັຣແນີ; ຄັນ ໄມ່ ເຕ່ອ໌ ຈ່ອຍ ໄລ່, ລາ ອຶງເຄາະ ຈ່ອຍ ແຕິ່. ");
INSERT INTO ncq_vpl VALUES ("PR3_29","021_3_29","PRO","3","29","29","ອຶນໂຈຍ ອາລັ່ອຮ ເງ່ ຕາ ອໍ ໂຈະ ເຢົ່າ ກາ ແອີດ ມູ ດຸງ ຈຸງ ມູ ວີ່ລ ກະ ໄມ່, ຍ່ອນ ເຍືາ ຢິດ ແດີອ໌ ມູ ອຶນຕຣັ່ອຮ ອັອຮ ແດີອ໌ ມູ ອຶນຕຣີ່ນ. ");
INSERT INTO ncq_vpl VALUES ("PR3_30","021_3_30","PRO","3","30","30","ອຶນໂຈຍ ບຣອຮ ອາຕ່ຳ ບຣຳ ອາເວ່ຣ ຕາ ແກີດ ກຼອງ ກະ ກວາຍ ການໍ່ອ໌, ຍ່ອນ ອັນ ຕາ ເກີ່ຍ ຕະ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("PR3_31","021_3_31","PRO","3","31","31","ອຶນໂຈຍ ຊັຣແມງ ກູມິ່ ແຕ ກວາຍ ແຣັ່ງ, ແຕີລາ ດວຍ໌ ນ່ະ ເຕຣ່ງ ໄລ່, ");
INSERT INTO ncq_vpl VALUES ("PR3_32","021_3_32","PRO","3","32","32","ຍ່ອນ ເຢືາງ ເຈົາຣາຊີ ຊາອັຣ ມັຮ ກວາຍ ຣາງຶ່ຮ ໂກ່ະ, ມາ ອັນ ຊັອງ ຊັຣນັບ ກະ ກວາຍ ມັນຕັ່ດ ມັນດຍາຮ. ");
INSERT INTO ncq_vpl VALUES ("PR3_33","021_3_33","PRO","3","33","33","ເຢືາງ ເຈົາຣາຊີ ເວ່ນ ມັຮ ດຸງຊູ ກວາຍ ໂລ່ຍຮ, ມາ ອັນ ຈໍອ໌ ກຼື່ອ໌ ກາຕື່ອ໌ ອາຢວຣ ມັຮ ດຸງຊູ ກວາຍ ຕານັ່ອງ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR3_34","021_3_34","PRO","3","34","34","ເຢືາງ ເຈົາຣາຊີ ດໍອ໌ ມັ່ດ ໂຈະ ກວາຍ ໂອດ, ມາ ອັນ ຈ່ອຍ ເມືາດ ກວາຍ ກາ ອາແຊງ ຈະ. ");
INSERT INTO ncq_vpl VALUES ("PR3_35","021_3_35","PRO","3","35","35","ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ເບີນ ຊະເຢືາງ ປັຣເລືາງ ປາເນົາ, ມາ ມັຮ ກວາຍ ຊາກູລ ຕາ ແກີດ ອາລຶ່ ອາຈຍາອ໌ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR4_1","021_4_1","PRO","4","1","1","ມັຮ ກອນ ຣາມອນ ເອີຍ! ອຶງເຄາະ ເຍືາ ຕະ ຕາປູ່ນ ຊັນຕອຍ໌ ອຶມປໍ່ ປາຕັບ ເຍືາ. ອຶງເຄາະ ເຍືາ ຊາງັດ ໂອນ ກຣັ່ກ, ເຈີ່ ເຍືາ ເຕ່ອ໌ ຊາປຸ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("PR4_2","021_4_2","PRO","4","2","2","ເກົາ ອາຕີ ເຍືາ ແອີງ ຣານະ ອໍ. ຍ່ອນ ນ່ະກັອຍ, ອຶງເຄາະ ເຍືາ ອຶນໂຈຍ ຕັຮ. ");
INSERT INTO ncq_vpl VALUES ("PR4_3","021_4_3","PRO","4","3","3","ບັອງ ເກົາ ອຶນນັ່ອງ ກັຣແນນ, ອຶມເປ່ອ໌ ອຶມປໍ່ ເກົາ ເບີນ ແອີງ ມານະ ເກົາ, ກະ ໄລ່ ອາໂຢ່ະ ລາລື່ ເກົາ; ");
INSERT INTO ncq_vpl VALUES ("PR4_4","021_4_4","PRO","4","4","4","ອຶມປໍ່ ເກົາ ອາຕີ ເກົາ ປາຍ: “ອຶງເຄາະ ໄມ່ ຊາແຍີ, ກະ ອຶນໂຈຍ ຊາລີຣ ມັຮ ຊັນຕອຍ໌ ເກົາ ປາຕັບ. ອຶງເຄາະ ໄມ່ ຕະ ຕາປູ່ນ ໂອນ ກຣັ່ກ ມັຮ ປັຣນາຍ ເກົາ ອາຕີ, ເຈີ່ ໄມ່ ເບີນ ອາມົ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR4_5","021_4_5","PRO","4","5","5","ອຶງເຄາະ ໄມ່ ຣຍານ ໂອນ ແກີດ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ກະ ຊາປຸ່ຮ. ອຶນໂຈຍ ຊາລີຣ, ແຕີລາ ງວາຍ ຕັຮ ຊັອງ ແຕ ມັຮ ປັຣນາຍ ເກົາ ປາຕັບ. ");
INSERT INTO ncq_vpl VALUES ("PR4_6","021_4_6","PRO","4","6","6","ອຶນໂຈຍ ຕັຮ ໂລ່ ເມືາດ ຣາໄງ່ອ໌ ຣາລັ່ງ, ຍ່ອນ ອັນ ເຕ່ອ໌ ກຸ່ມກຍາອ໌ ໄມ່; ອຶງເຄາະ ໄມ່ ປາຊິ ຣາໄງ່ອ໌ ຣາລັ່ງ, ເຈີ່ ເຕ່ອ໌ ອັນ ກູຣຍາອ໌ ໄມ່ ໂອນ ແອີດ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR4_7","021_4_7","PRO","4","7","7","ຣາໄງ່ອ໌ ຣາລັ່ງ ລາ ປື່ດ ກາເລີຍ ອຶນແຍ່ະ ແຕ ການໍ່ອ໌. ນ່ະກັອຍ, ອຶງເຄາະ ໄມ່ ຈີວ໌ ປິ່ດ ມັຮ ມູ່ນ ກູ່ ຣາມຶ່ຮ ໂອນ ເຕ່ອ໌ ໄມ່ ເບີນ ຣາໄງ່ອ໌ ຣາລັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR4_8","021_4_8","PRO","4","8","8","ອຶງເຄາະ ໄມ່ ປາຊິ ຣາໄງ່ອ໌ ຣາລັ່ງ, ເຈີ່ ລື່ ຣາໄງ່ອ໌ ຣາລັ່ງ ຕະ ໂອນ ໄມ່ ແກີດ ຊະເຢືາງ. ອຶງເຄາະ ໄມ່ ຊັນຕັ່ບ ດໍອ໌ ຣາໄງ່ອ໌ ຣາລັ່ງ, ຍ່ອນ ຣາມຶ່ຮ ກັອຍ ເຕ່ອ໌ ຕະ ໂອນ ກວາຍ ການໍ່ອ໌ ຢຳນັ່ບ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("PR4_9","021_4_9","PRO","4","9","9","ຣາໄງ່ອ໌ ຣາລັ່ງ ໄມ່ ແກີດ ນ່ະ ກຸນຕຣວາອ໌ ອາງອື່ຣ ລາລື່ ກາ ເນົ່າ ອາປື່ງ ໂຈະ ຕຶ່ງ ແປຼີ ໄມ່.” ");
INSERT INTO ncq_vpl VALUES ("PR4_10","021_4_10","PRO","4","10","10","ກອນ ເອີຍ! ຊາງັດ ເກົາ! ອຶງເຄາະ ໄມ່ ຢຳ ອຶນແຍ່ະ ຣາງຶ່ຮ ຣາແຮີ ມັຮ ຊັນຕອຍ໌ ເກົາ ປາຕັບ, ໂອນ ໄມ່ ເຕ່ອ໌ ເບີນ ແກີດ ກົງ ອາມົ່ງ ດູ່ນ. ");
INSERT INTO ncq_vpl VALUES ("PR4_11","021_4_11","PRO","4","11","11","ເກົາ ອາຕີ ໄມ່ ແຕ ຣາໄງ່ອ໌ ຣາລັ່ງ ກະ ເງ່ ຕະ ເປາະ ຕຶ່ງ ຣານາ ຕານັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("PR4_12","021_4_12","PRO","4","12","12","ຄັນ ໄມ່ ຕະ ນ່ະກັອຍ, ຕາ ເບີນ ມວຍ ຣາມຶ່ຮ ອຶນເຕົ່າ ເຕ່ອ໌ ກາຕັງ ຣານາ ໄມ່ ເປາະ. ແຕີ່ອ໌ ໄມ່ ຕາລຸ່ຮ, ໄມ່ ຕາ ເບີນ ກູຕົ່ຮ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR4_13","021_4_13","PRO","4","13","13","ອຶງເຄາະ ໄມ່ ເຈີ ເລືອຍໆ ມັຮ ຣາມຶ່ຮ ກາ ໄມ່ ຣຍານ ເຈີ່. ມັຮ ຣາມຶ່ຮ ກັອຍ ເຕ່ອ໌ ອາໂຢ່ງ ແດີຍ ອາມົ່ງ; ອຶງເຄາະ ໄມ່ ຢຸມ ຈັບ ມັຮ ຣາມຶ່ຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR4_14","021_4_14","PRO","4","14","14","ອຶນໂຈຍ ຕາປູ່ນ ເງ່ ກວາຍ ຕາ ອໍ; ອຶນໂຈຍ ຕະ ນ່ະ ກວາຍ ແຣັ່ງ ດຸ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("PR4_15","021_4_15","PRO","4","15","15","ອຶນໂຈຍ ຕະ ນ່ະກັອຍ! ອຶງເຄາະ ໄມ່ ວຍາຣ ເຢີ່ງ ແຕ ມັຮ ຣານະ ຕາ ອໍ! ອຶງເຄາະ ໄມ່ ແວັ່ຮ ຕັຮ ແຕ ຣານາ ກັອຍ, ກະ ເປາະ ຕຶ່ງ ຣານາ ຕານັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("PR4_16","021_4_16","PRO","4","16","16","ກວາຍ ຕາ ອໍ ແກີດ ຊາແຮລ ຊາໂຮຍ໌ ຄັນ ໄລ່ ຕາ ຢວາຮ ເບີນ ຕະ ຣານະ ໂລ່ຍຮ. ໄລ່ ມູ່ດ ບິ ມາ ມັ່ດ ໄລ່ ລູລົງ ລູໂລຍ໌ ເລືອຍໆ ຄັນ ໄລ່ ຕາ ຢວາຮ ຕະ ກວາຍ ການໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR4_17","021_4_17","PRO","4","17","17","ຣານະ ຕາ ອໍ ກະ ແຣັ່ງ ແກີດ ນ່ະ ຊັຣນາ ກະ ແດີອ໌ ງ່ອຍ໌ ໂອນ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("PR4_18","021_4_18","PRO","4","18","18","ຣານາ ມັຮ ກວາຍ ຕານັ່ອງ ອໍ ແກີດ ນ່ະ ເທຣີງ ມັ່ດ ມານາງ ຕາແບິ ລັ່ອຮ, ແກີດ ປັ່ງ ອາຊັອຮ ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ. ");
INSERT INTO ncq_vpl VALUES ("PR4_19","021_4_19","PRO","4","19","19","ມາ ຣານາ ມັຮ ກວາຍ ຕາ ອໍ ເປາະ ແກີດ ນ່ະ ການຳ ປິງ. ໄລ່ ແດິມ, ມາ ໄລ່ ຕາ ເບີນ ດັງ ອຶນເຕົ່າ ໄລ່ ກູຕົ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("PR4_20","021_4_20","PRO","4","20","20","ກອນ ເອີຍ! ອຶງເຄາະ ໄມ່ ຊາງັດ ມັຮ ປັຣນາຍ ເກົາ ປາຍ. ອຶງເຄາະ ໄມ່ ປາແຈງ ກູຕູຣ ຊາງັດ ປັຣນາຍ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("PR4_21","021_4_21","PRO","4","21","21","ອຶນໂຈຍ ໂອນ ປັຣນາຍ ກັອຍ ປິ່ດ ເມືາດ ແຕ ໄມ່. ອຶງເຄາະ ໄມ່ ເຈີ ດໍອ໌ ມັຮ ປັຣນາຍ ກັອຍ ຕຶ່ງ ຣາງຶ່ຮ ຣາແຮີ. ");
INSERT INTO ncq_vpl VALUES ("PR4_22","021_4_22","PRO","4","22","22","ອາແລ່ະ ກາ ຊາອຳ ປັຣນາຍ ກັອຍ ເບີນ ແດີຍ ອາມົ່ງ ອໍ; ກະ ປັຣນາຍ ກັອຍ ຕະ ໂອນ ຈະຈັ່ນ ອັນ ແກີດ ບັນ ເຣ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR4_23","021_4_23","PRO","4","23","23","ອຶງເຄາະ ໄມ່ ກຍາອ໌ ອໍ ມັຮ ຣາງຶ່ຮ ໄມ່ ຄຶ່ດ, ຍ່ອນ ມັຮ ຣານະ ໄມ່ ຕະ ລາ ແຕີ່ອ໌ ແຕ ຣາງຶ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("PR4_24","021_4_24","PRO","4","24","24","ອຶງເຄາະ ໄມ່ ຕັຮ ຊັອງ ປັຣນາຍ ຕະ ອຶນຕີ ຕາ ເບີນ ລື່. ອຶນໂຈຍ ຣາບູລ ກະ ມັຮ ຣານະ ຣາໂລ່ບ. ");
INSERT INTO ncq_vpl VALUES ("PR4_25","021_4_25","PRO","4","25","25","ອຶງເຄາະ ໄມ່ ເນ່ ຕານັ່ອງ ເລືອຍໆ ປໍ ເມືາງ ບັອງ ໄມ່ ເປາະ ຕຶ່ງ ຣານາ, ກະ ອຶນໂຈຍ ລົ່ບລີ່ ກຼີມັ່ດ ປໍ ໄນ່ ປໍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR4_26","021_4_26","PRO","4","26","26","ອຶງເຄາະ ໄມ່ ຕາຕ່ອຍ໌ ເປາະ ຕຶ່ງ ຣານາ ຕານັ່ອງ, ເຈີ່ ເຕ່ອ໌ ໄມ່ ຕະ ແກີດ ແປີດ ແຮີຍ ຕຶ່ງ ກູ່ ຣາມຶ່ຮ ໄມ່ ອີ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("PR4_27","021_4_27","PRO","4","27","27","ອຶງເຄາະ ໄມ່ ວຍາຣ ແຕ ມັຮ ຣານະ ໂກ່ະ; ອຶນໂຈຍ ກູຢາວ ອາລັ່ອຮ ແຕ ຣານາ ປຍາຍ໌. ");
INSERT INTO ncq_vpl VALUES ("PR5_1","021_5_1","PRO","5","1","1","ກອນ ເອີຍ! ອຶງເຄາະ ໄມ່ ຊາງັດ ໂອນ ກຣັ່ກ ແຕ ຣາໄງ່ອ໌ ຣາລັ່ງ, ກະ ມັຮ ຣາມຶ່ຮ ເກົາ ດັງ; ");
INSERT INTO ncq_vpl VALUES ("PR5_2","021_5_2","PRO","5","2","2","ເຈີ່ ໄມ່ ເຕ່ອ໌ ດັງ ຕະ ຣານະ ກຣັ່ກ ອໍ, ກະ ປັຣນາຍ ໄມ່ ປາຍ ເຕ່ອ໌ ອາປັຮ ໄມ່ ດັງ ຊາອຶ່ຍ ເງ່ ຣາໄງ່ອ໌ ຣາລັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR5_3","021_5_3","PRO","5","3","3","ແບອ໌ ມັນແຊມ ເປາະ ປັຣລື່ຍ ອຶງເງືາມ ນ່ະ ແດີອ໌ ກາຮຍາລ, ກະ ປັຣໄລຮ ປັຣນາຍ ອັນ ລາງ່ອດ ລາເງ່ຮ ນ່ະ ອຶນຊີ່ງ ອາໂປ່ນ; ");
INSERT INTO ncq_vpl VALUES ("PR5_4","021_5_4","PRO","5","4","4","ມາ ແຕີ່ອ໌ ປັຣຊົດ, ມັນແຊມ ກັອຍ ແກີດ ນ່ະ ບັດ ອຶນຕັງ, ກະ ເບິ ຣາຮື່ບ ນ່ະ ປຼາ ດາວ ເບິ ບາຣ ກັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("PR5_5","021_5_5","PRO","5","5","5","ມັນແຊມ ກັອຍ ອີ ເດີງ ໄມ່ ເປາະ ປໍ ອຶນຕຸ ກວາຍ ກູຈີດ ແອີດ, ຍ່ອນ ຣານາ ອັນ ລາ ເປາະ ປໍ ອຶນຕຸ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("PR5_6","021_5_6","PRO","5","6","6","ອັນ ຕາ ເບີນ ຣາບູລ ຣານາ ເປາະ ປໍ ອຶນຕຸ ອາມົ່ງ, ມາ ອັນ ເປາະ ຕຶ່ງ ຣານາ ໂກ່ະ ຕາ ດັງ ປໍ ແລ່ະໆ. ");
INSERT INTO ncq_vpl VALUES ("PR5_7","021_5_7","PRO","5","7","7","ມັຮ ກອນ ເອີຍ! ອຶງເຄາະ ເຍືາ ຊາງັດ ເກົາ! ອຶນໂຈຍ ຊາລີຣ ມັຮ ປັຣນາຍ ເກົາ ອາຕີ. ");
INSERT INTO ncq_vpl VALUES ("PR5_8","021_5_8","PRO","5","8","8","ອຶງເຄາະ ເຍືາ ວຍາຣ ເຢີ່ງ ແຕ ມັນແຊມ ຕະ ນ່ະກັອຍ, ກະ ອຶນໂຈຍ ຕາຮຍາດ ແຈ່ະ ງັ່ຮ ຕົ່ງ ດຸງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR5_9","021_5_9","PRO","5","9","9","ຄັນ ໄມ່ ເປາະ ແຈ່ະ, ອຶງກັອຮ ປຍາຍ໌ ກວາຍ ການໍ່ອ໌ ຕາ ເບີນ ຢຳນັ່ບ ນັ່ອງ ໄມ່; ກະ ລື່ ໄມ່ ກູຈີດ ແຕ ອາຕີ ກວາຍ ແຣັ່ງ ບັອງ ອຶນນັ່ອງ ນຸ່ມ. ");
INSERT INTO ncq_vpl VALUES ("PR5_10","021_5_10","PRO","5","10","10","ມັຮ ກວາຍ ແຕ ກຣວາງ ການໍ່ອ໌ ອີ ອີດ ອຶນແຍ່ະ ມັຮ ເກຣີ່ງ ໄມ່; ເຈີ່ ມັຮ ເກຣີ່ງ ກາ ໄມ່ ປາໂຣມ ແກີດ ເກຣີ່ງ ກວາຍ ການໍ່ອ໌ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR5_11","021_5_11","PRO","5","11","11","ພໍກາ ປັຣຊົດ ແດີຍ ອາມົ່ງ ໄມ່, ລື່ ໄມ່ ບິ ຊາໂຊຍ ຕຶ່ງ ອຶນຕິ ໄມ່, ຍ່ອນ ຈະຈັ່ນ ໄມ່ ແກີດ ອອຍ໌ ຣັ່ອຮ ກັອຮ ຊາລ. ");
INSERT INTO ncq_vpl VALUES ("PR5_12","021_5_12","PRO","5","12","12","ເຈີ່ ໄມ່ ອີ ປາຍ ນ່ະໄນ່: “ຍ່ອນ ນານ່ະ ແຕ ເກົາ ຕາ ມັ່ກ ກວາຍ ການໍ່ອ໌ ກາແອັຮ ເກົາ, ກະ ຕາ ແອອ໌ ກວາຍ ການໍ່ອ໌ ຕາໄມຮ? ");
INSERT INTO ncq_vpl VALUES ("PR5_13","021_5_13","PRO","5","13","13","ເກົາ ຕາ ເບີນ ຊາງັດ ປັຣນາຍ ມັຮ ອາຈານ ອາຕີ. ເກົາ ຕາ ເບີນ ຣາມິ່ງ ແຕ ປັຣນາຍ ໄລ່ ປາຍ. ");
INSERT INTO ncq_vpl VALUES ("PR5_14","021_5_14","PRO","5","14","14","ເກົາ ແກີດ ກູມາລ ຕະ ຕຶ່ງ ອຶນດີ ກວາຍ ຕຶ່ງ ເມືອງ ເກົາ, ບັອງ ໄລ່ ແຕີ່ອ໌ ໂຣ່ມ ມັນຕຸ.” ");
INSERT INTO ncq_vpl VALUES ("PR5_15","021_5_15","PRO","5","15","15","ອຶງເຄາະ ໄມ່ ງ່ອຍ໌ ແອີງ ແດີອ໌ ແຕ ແດີອ໌ ກັອຮ ໄມ່ ເບີມ; ອຶງເຄາະ ໄມ່ ອາໂຢ່ະ ແອີງ ລາກວຍ ໄມ່ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("PR5_16","021_5_16","PRO","5","16","16","ອຶນໂຈຍ ໂອນ ແດີອ໌ ປັຣໂລ່ຍ໌ ໄມ່ ເກຼືາຍ ຕຶ່ງ ຣານາ, ໂອນ ມັນແຊມ ການໍ່ອ໌ ກາ ຕາ ແກີນ ລາກວຍ ໄມ່ ງ່ອຍ໌. ");
INSERT INTO ncq_vpl VALUES ("PR5_17","021_5_17","PRO","5","17","17","ອຶງເຄາະ ໄມ່ ບິ ອາລຶ່ງ ແອີງ ລາກວຍ ໄມ່ ຊັອງ; ອຶນໂຈຍ ບິ ກະ ມັນແຊມ ການໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR5_18","021_5_18","PRO","5","18","18","ນ່ະກັອຍ, ອຶງເຄາະ ໄມ່ ແອີດ ຣໍ່ອ໌ ກະ ແອີງ ລາກວຍ ໄມ່ ຊັອງ, ລາ ລາກວຍ ກາ ໄມ່ ເບີນ ບັອງ ເຍືາ ອຶນນັ່ອງ ນຸ່ມ. ");
INSERT INTO ncq_vpl VALUES ("PR5_19","021_5_19","PRO","5","19","19","ລາກວຍ ກັອຍ ເຈຍ ອໍ ລາມວາຍ໌, ອັນ ບັນ ນ່ະ ໄຕ່ອ໌ ຣາໄງ່ອ໌ ນ່ະ ໂປຍຮ. ຊາແນ ອັນ ຕະ ໂອນ ໄມ່ ຊັອງ ຣໍ່ອ໌ ນ່ະ ຄູຍ; ກະ ຣາງຶ່ຮ ອາໂຢ່ະ ອັນ ຕະ ໂອນ ໄມ່ ບູຍ ນ່ະ ເກ່ນ. ");
INSERT INTO ncq_vpl VALUES ("PR5_20","021_5_20","PRO","5","20","20","ກອນ ເອີຍ! ຍ່ອນ ນານ່ະ ໄມ່ ອູອຍາຣ ອູໄອອ໌ ຢໍອ໌ ອີ ເບີນ ລາກວຍ ກວາຍ ການໍ່ອ໌? ອຶນໂຈຍ ຊາອູບ ກຍາວ ມັນແຊມ ກາ ຕີນ ອາລ່ອງ ບາຣ ໄປ ອາໄລ່ ປູນ ເຊີງ. ");
INSERT INTO ncq_vpl VALUES ("PR5_21","021_5_21","PRO","5","21","21","ເຢືາງ ເຈົາຣາຊີ ເຮີມ ກູ່ ຣາມຶ່ຮ ໄມ່ ຕະ. ອຶມປຶ່ ໄມ່ ເປາະ ປໍ ແລ່ະ, ລາ ອັນ ແອີດ ເນ່ ເລືອຍໆ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("PR5_22","021_5_22","PRO","5","22","22","ຣານະ ໂລ່ຍຮ ແກີດ ນ່ະ ຣາບາງ ໂອນ ມັຮ ກວາຍ ຕະ ໂລ່ຍຮ; ໄລ່ ກັອຍ ຕານ ຊາງ ກູວາງ ໂຈະ ຈະ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("PR5_23","021_5_23","PRO","5","23","23","ໄລ່ ກູຈີດ ຍ່ອນ ໄລ່ ຕາ ເບີນ ກຍາອ໌ ອໍ ຈະ ໄລ່ ເບີມ. ໄລ່ ແກີດ ແກຼິກຼູ່ ຍ່ອນ ຣານະ ໄລ່ ຕະ ເຈຍ ຊາກູລ. ");
INSERT INTO ncq_vpl VALUES ("PR6_1","021_6_1","PRO","6","1","1","ກອນ ເອີຍ! ໄມ່ ເກີ່ຍ ລັບ ຕູ່ ຕາງ ກວາຍ ການໍ່ອ໌ ບໍ? ກະ ໄມ່ ເກີ່ຍ ປັງ ເກຣີ່ງ ອີ ກູລັຮ ຕູ່ ຕາງ ກວາຍ ກາ ຕາ ເບີນ ຊາກັ່ລ ມັ່ດ ຊາກັ່ດ ເມືາງ ບໍ? ");
INSERT INTO ncq_vpl VALUES ("PR6_2","021_6_2","PRO","6","2","2","ອຶງກັອຮ ປຍາຍ໌ ເນົ່າ ໂກບ ໄມ່ ຍ່ອນ ແຕ ປັຣນາຍ ໄມ່ ເບີມ; ນ່ະ ໄມ່ ຕານ ຊາງ ກູວາງ ໂຈະ ຈະ ເບີມ ຍ່ອນ ແຕ ປັຣນາຍ ໄມ່ ລັບ. ");
INSERT INTO ncq_vpl VALUES ("PR6_3","021_6_3","PRO","6","3","3","ກອນ ເອີຍ! ຄັນ ນ່ະກັອຍ, ໄມ່ ແອີດ ຕຶ່ງ ຕາລາງ ອາຕີ ກວາຍ ກັອຍ ເຈີ່. ໄນ່ ລາ ຣານະ ໄມ່ ເຕ່ອ໌ ຣາກຼັຮ ແຕ ຣາມຶ່ຮ ກັອຍ: ອຶງເຄາະ ໄມ່ ເປາະ ຣາມົຮ ກວາຍ ກັອຍ ໄຈ, ກະ ກູກຸຮ ກູກວຍ ໂອນ ອັນ ອາກຼັຮ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("PR6_4","021_6_4","PRO","6","4","4","ໄມ່ ອຶນໂຈຍ ບິ ຢວາຮ; ອຶນໂຈຍ ກາແຍດ ມັ່ດ ຢວາຮ. ");
INSERT INTO ncq_vpl VALUES ("PR6_5","021_6_5","PRO","6","5","5","ອຶງເຄາະ ໄມ່ ກູໄຣ່ຮ ໂອນ ຣາກຼັຮ ແຕ ຣາບາງ ກັອຍ, ນ່ະ ແຈມ ແຕີລາ ແຢີດ ຣາກຼັຮ ແຕ ຣາບາງ ເປຣືານ. ");
INSERT INTO ncq_vpl VALUES ("PR6_6","021_6_6","PRO","6","6","6","ກວາຍ ປາງາຍ ຣຳແປັຮ ເອີຍ! ໄມ່ ເປາະ ເນ່ ຊາໂມຍ໌ ກັອຍ, ເຈີ່ ຕາຕ່ອຍ໌ ເນ່ ເຕຣ່ງ ອັນ ໂອນ ໄມ່ ແກີດ ຣາໄງ່ອ໌ ຣາລັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR6_7","021_6_7","PRO","6","7","7","ຊາໂມຍ໌ ແອິ ເນືາຍ ອາໂຢ່ງ, ແອິ ເທົາແກ, ແອິ ອັນ ກາ ຊົດ ຊາຊາຍ; ");
INSERT INTO ncq_vpl VALUES ("PR6_8","021_6_8","PRO","6","8","8","ມາ ຍາມ ປາຣັງ ອັນ ອຶງໂກຍ ປາໂຣມ ດໍອ໌ ຊັຣນາ ແຕີ່ອ໌ ຍາມ ອາງີ່ນ. ");
INSERT INTO ncq_vpl VALUES ("PR6_9","021_6_9","PRO","6","9","9","ກວາຍ ປາງາຍ ຣຳແປັຮ ເອີຍ! ອຶນນັ່ອງ ມາແລ່ະ ດູ່ນ ໄມ່ ອີ ບິ ຊານວຣ ເລືອຍໆ? ມາແລ່ະ ແຕ ໄມ່ ອີ ຕາແມີ? ");
INSERT INTO ncq_vpl VALUES ("PR6_10","021_6_10","PRO","6","10","10","ໄມ່ ປາຍ ນ່ະໄນ່: “ເກົາ ອີ ບິ ຕານັ່ອງ ອຶງກີງ ມາໂຮຍ ຊັອງ; ເກົາ ອີ ກູຣຸ ອາຕີ ບິ ຣາລູ່ ມາໂຮຍ ເວືາຍ.” ");
INSERT INTO ncq_vpl VALUES ("PR6_11","021_6_11","PRO","6","11","11","ມາ ບັອງ ໄມ່ ບິ, ຕຸ່ຮ ກາດີດ ແຕີ່ອ໌ ປໍ ໄມ່ ນ່ະ ຊາແວງ ເດີງ ດາວ ແຕີ່ອ໌ ປົນ. ");
INSERT INTO ncq_vpl VALUES ("PR6_12","021_6_12","PRO","6","12","12","ມັຮ ກວາຍ ກູເກືາງ ກະ ກວາຍ ແຣັ່ງ, ໄລ່ ມັ່ກ ລາລື່ ຕະ ອຶນຕີ ອາໂລກ. ");
INSERT INTO ncq_vpl VALUES ("PR6_13","021_6_13","PRO","6","13","13","ໄລ່ ມາຍີ່ວ ມັ່ດ, ອາວິ່ດ ອາເຢີງ ແຕີລາ ຊາດອຍ ປໍ ໄນ່ ປໍ ກັອຍ; ຄັນ ໄມ່ ເຮີມ ນ່ະກັອຍ, ລາ ເຕຣ່ງ ໄລ່ ອີ ພິ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("PR6_14","021_6_14","PRO","6","14","14","ຣາງຶ່ຮ ໄລ່ ອາລັ່ອຮ ແອີງ ເງ່ ຕາ ອໍ, ຈໍ່ອ໌ ອີ ຕະ ກູດີ່ງ ກູດາງ ກູຊາງ ກູເປືາຍ ຕຶ່ງ ກູ່ ອຶນຕຸ. ");
INSERT INTO ncq_vpl VALUES ("PR6_15","021_6_15","PRO","6","15","15","ຍ່ອນ ນ່ະກັອຍ, ຣາມຶ່ຮ ຕຸ່ຮ ກັ່ດ ຊາແຣັຮ ຊາຣວຍ ແຕີ່ອ໌ ປໍ ໄລ່, ກະ ໄລ່ ແກີດ ກູຈີດ ປິ່ດ ແດັດ ດຽລ. ");
INSERT INTO ncq_vpl VALUES ("PR6_16","021_6_16","PRO","6","16","16","ເບີນ ຕາປູ່ລ ຣາມຶ່ຮ ເຢືາງ ເຈົາຣາຊີ ອຶງຄື່ນ ກະ ຊາອັຣ, ລາ ນ່ະໄນ່: ");
INSERT INTO ncq_vpl VALUES ("PR6_17","021_6_17","PRO","6","17","17","ລາ ອາຊັອຮ ມັ່ດ ຕາແບງ ອາແຊງ ມັ່ດ ກູເຊົາ; ເລືາຍຮ ກາ ດຸ ອາໂລກ; ອາຕີ ກາ ກາຈີດ ກວາຍ ຕາ ເບີນ ຕະ ໂລ່ຍຮ ອຶນເຕົ່າ; ");
INSERT INTO ncq_vpl VALUES ("PR6_18","021_6_18","PRO","6","18","18","ຣາງຶ່ຮ ກາ ກູຈົກ ກູຈີວ ກູວີວ ກູວາວ ໂຈະ ກວາຍ ການໍ່ອ໌; ອາເຢີງ ກາ ປາລັອງ ຕະ ຣານະ ຕາ ອໍ; ");
INSERT INTO ncq_vpl VALUES ("PR6_19","021_6_19","PRO","6","19","19","ກວາຍ ດຸ ປ່ອງ ອາແປັດ ກວາຍ ການໍ່ອ໌, ກະ ກວາຍ ກາ ມັ່ກ ຕະ ໂອນ ຣາລຸຮ ຕຣໍ່ ຣາລໍ່ ວີ່ລ. ");
INSERT INTO ncq_vpl VALUES ("PR6_20","021_6_20","PRO","6","20","20","ກອນ ເອີຍ! ອຶງເຄາະ ໄມ່ ຕະ ປວາຍ ປັຣນາຍ ອຶມເປ່ອ໌ ອຶມປໍ່ ປາຕັບ; ອຶນໂຈຍ ຊາລີຣ ມັຮ ຣາມຶ່ຮ ໄລ່ ຕຽຮ. ");
INSERT INTO ncq_vpl VALUES ("PR6_21","021_6_21","PRO","6","21","21","ອຶງເຄາະ ໄມ່ ເຈີ ດໍອ໌ ເລືອຍໆ ຕຶ່ງ ຣາງຶ່ຮ, ກະ ອຶງເຄາະ ໄມ່ ອຶງກວາອ໌ ດໍອ໌ ມັຮ ຣາມຶ່ຮ ກັອຍ ນ່ະ ເນົ່າ ອຶງກວາອ໌ ກາຣັຮ ຕຶ່ງ ຕາກອງ; ");
INSERT INTO ncq_vpl VALUES ("PR6_22","021_6_22","PRO","6","22","22","ບັອງ ໄມ່ ເປາະ ຕຶ່ງ ຣານາ, ປັຣນາຍ ໄລ່ ກາໄຕ່ຮ ເຕ່ອ໌ ອາໂຢ່ງ ໄມ່; ບັອງ ໄມ່ ບິ, ປັຣນາຍ ກັອຍ ເຕ່ອ໌ ກຸ່ມກຍາອ໌ ໄມ່; ແຕີ່ອ໌ ໄມ່ ຕາແມີ, ມັຮ ປັຣນາຍ ກັອຍ ເຕ່ອ໌ ຕາໄມຮ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("PR6_23","021_6_23","PRO","6","23","23","ຣາມຶ່ຮ ໄລ່ ປາຕັບ ປາເລືາງ ໂອນ ປັ່ງ ຕຶ່ງ ຣານາ ໄມ່ ເປາະ; ປັຣນາຍ ໄລ່ ຕຽຮ ອາຕີ, ໂອນ ແດີຍ ອາມົ່ງ ໄມ່ ຕະ ແກີດ ແປີດ ແຮີຍ. ");
INSERT INTO ncq_vpl VALUES ("PR6_24","021_6_24","PRO","6","24","24","ມັຮ ປັຣນາຍ ກັອຍ ເຕ່ອ໌ ກຸ່ມກຍາອ໌ ໄມ່ ໂອນ ແວັດ ແຕ ມັນແຊມ ຕາ ອໍ, ກູຣຍາອ໌ ດໍອ໌ ໄມ່ ແຕ ປັຣນາຍ ມັນແຊມ ກາ ອາເຣີ່ຍຮ ບາຣ ແບອ໌ ອາແຊອ໌ ບາຣ ໂຈຣ. ");
INSERT INTO ncq_vpl VALUES ("PR6_25","021_6_25","PRO","6","25","25","ອຶນໂຈຍ ໂອນ ຊາແນ ມັນແຊມ ກັອຍ ຕະ ໂອນ ຣາງຶ່ຮ ໄມ່ ບິ ຕາບື່ ອຶມເປົາ ບິ ຊາເດົາ ເຮີມ; ອຶນໂຈຍ ໂອນ ກັຣແບັຮ ມັ່ດ ອັນ ແກີດ ຣາບາງ ກວຍ໌ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("PR6_26","021_6_26","PRO","6","26","26","ມັນແຊມ ຈິ ຈະ ຕະ ໂອນ ໄມ່ ແກີດ ກາດີດ. ມາ ຄັນ ໄມ່ ເປາະ ຕາ ອໍ ກະ ລາກວຍ ເນົ່າ, ລາ ຕະ ໂອນ ເຈືາດ ໄມ່ ຊາແຣັຮ ຊາຣວຍ. ");
INSERT INTO ncq_vpl VALUES ("PR6_27","021_6_27","PRO","6","27","27","ເຕ່ອ໌ ມາ ຕາ ເບີນ ຄັນ ເນົ່າ ອີດ ຣາແຮິ ອູ່ຍຮ, ເຈີ່ ກາອື່ ຕຶ່ງ ອາເປີ່ມ, ມາ ອາຢັ່ອຮ ອັນ ຕາ ເບີນ ກາດ? ");
INSERT INTO ncq_vpl VALUES ("PR6_28","021_6_28","PRO","6","28","28","ເຕ່ອ໌ ບໍ ຄັນ ເນົ່າ ຊາເຕືາຍ໌ ຕຶ່ງ ຣາແຮິ ອູ່ຍຮ, ມາ ອາເຢີງ ຕາ ເບີນ ປັລດົງ? ");
INSERT INTO ncq_vpl VALUES ("PR6_29","021_6_29","PRO","6","29","29","ກວາຍ ອາແລ່ະ ກາ ເປາະ ຕາ ອໍ ກະ ລາກວຍ ເນົ່າ, ລາ ອັນ ແກີດ ນ່ະກັອຍ ເຕ່. ກວາຍ ອາແລ່ະ ກາ ຕະ ນ່ະກັອຍ, ອັນ ໄກຣ ໂຕ່ດ ອຶນຕັອງ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR6_30","021_6_30","PRO","6","30","30","ເນົ່າ ຕາ ເບີນ ອຶງຄື່ນ ຄັນ ກວາຍ ແອິ ຊັຣນາ ເລືາ ອຶນແຕີດ ມາ ຕູຕວຍ໌ ຊັຣນາ; ");
INSERT INTO ncq_vpl VALUES ("PR6_31","021_6_31","PRO","6","31","31","ມາ ຄັນ ເນົ່າ ໂກບ ອັນ, ລາ ອຶງເຄາະ ອັນ ຕູ່ ຕາປູ່ລ ເຮີບ, ລາ ອັນ ອຶງເຄາະ ປິ່ດ ອຶນແຍ່ະ ຕຽນ ວັ່ນ. ");
INSERT INTO ncq_vpl VALUES ("PR6_32","021_6_32","PRO","6","32","32","ມາ ອຶງເກ່າະ ອຶນແຢດ ຣາເລົາ ອາແລ່ະ ກາ ປັຣລື່ຍ ລາກວຍ ເນົ່າ, ຕາ ເບີນ ຣີ່ດ ກຣ່ອງ; ອັນ ຕະ ໂອນ ເຈືາດ ອັນ ຊາແຣັຮ ຊາຣວຍ. ");
INSERT INTO ncq_vpl VALUES ("PR6_33","021_6_33","PRO","6","33","33","ລື່ ຊະເຢືາງ ອັນ ແກີດ ຣາລິ່ຮ, ກະ ເມ່ນ ເນົ່າ ປຍາຍຮ ລຳປີ ອັນ; ເຈີ່ ອັນ ແກີດ ກູມາລ ລົບ ມູ ຕາຕຶ່ບ. ");
INSERT INTO ncq_vpl VALUES ("PR6_34","021_6_34","PRO","6","34","34","ກາຢາອ໌ ມັນແຊມ ກັອຍ ແກີດ ອຶງຄື່ນ ລາລື່ ຍ່ອນ ອັນ ປາຊິ ລາກວຍ ອັນ; ແຕີ່ອ໌ ອັນ ກັຣລັຮ ແດີອ໌, ອັນ ຕາ ເບີນ ອາລິ່ຮ ອາຈຸຮ ໂຈະ ອາແລ່ະ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("PR6_35","021_6_35","PRO","6","35","35","ອັນ ຕາ ເບີນ ອີດ ປຣະ ກາເນືາຍ, ແຕີລາ ຣັ່ບ ຣັງອອຍ ເນົ່າ ຊັດ ຣາເວືາຍ, ຍ່ອນ ມັຮ ເກຣີ່ງ ກັອຍ ຕາ ເຕ່ອ໌ ຕະ ໂອນ ຣາງຶ່ຮ ອຶງຄື່ນ ອັນ ແກີດ ປຣາຍ. ");
INSERT INTO ncq_vpl VALUES ("PR7_1","021_7_1","PRO","7","1","1","ກອນ ເອີຍ! ອຶງເຄາະ ໄມ່ ຊາແຍີ ມັຮ ປັຣນາຍ ເກົາ ປາຕັບ. ອຶນໂຈຍ ຊາລີຣ ມັຮ ຣານະ ເກົາ ໂອນ ໄມ່ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("PR7_2","021_7_2","PRO","7","2","2","ອຶງເຄາະ ໄມ່ ຕະ ປວາຍ ມັຮ ຣານະ ເກົາ ອາຕີ, ເຈີ່ ໄມ່ ເບີນ ອາມົ່ງ. ອຶງເຄາະ ໄມ່ ກຍາອ໌ ໂອນ ຈັບ ມັຮ ປັຣນາຍ ເກົາ ໂອນ, ນ່ະ ໄມ່ ກຍາອ໌ ມັ່ດ ໄມ່ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("PR7_3","021_7_3","PRO","7","3","3","ອຶງເຄາະ ໄມ່ ກູໂປດ ໂອນ ຈັບ ກູ່ ຕາໄງ ຊາເດົາ ມັຮ ປັຣນາຍ ເກົາ ອາຕີ ໄມ່; ອຶງເຄາະ ໄມ່ ຄຽນ ດໍອ໌ ມັຮ ປັຣນາຍ ກັອຍ ຕຶ່ງ ຣາງຶ່ຮ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("PR7_4","021_7_4","PRO","7","4","4","ອຶງເຄາະ ໄມ່ ອາໂຢ່ະ ຣາໄງ່ອ໌ ຣາລັ່ງ ນ່ະ ໄມ່ ອາໂຢ່ະ ອາມໍ່ອ໌ ໄມ່ ເຕ່, ກະ ອຶງເຄາະ ໄມ່ ປາຊິ ຣາໄງ່ອ໌ ຣາລັ່ງ ນ່ະ ໄມ່ ປາຊິ ຊັຣມະ ຊັຣກັ່ລ. ");
INSERT INTO ncq_vpl VALUES ("PR7_5","021_7_5","PRO","7","5","5","ມັຮ ຣາມຶ່ຮ ກັອຍ ເຕ່ອ໌ ກຸ່ມກຍາອ໌ ໄມ່ ແຕ ມັນແຊມ ເປາະ ຕາ ອໍ, ລາ ມັນແຊມ ກາ ອາເຣີ່ຍຮ ບາຣ ແບອ໌ ອາແຊອ໌ ບາຣ ໂຈຣ. ");
INSERT INTO ncq_vpl VALUES ("PR7_6","021_7_6","PRO","7","6","6","ເບີນ ມວຍ ຕາໄງ ເກົາ ຕາມັອກ ແຕ ມານັ່ກໄດ ດຸງ ເກົາ; ");
INSERT INTO ncq_vpl VALUES ("PR7_7","021_7_7","PRO","7","7","7","ເຈີ່ ເກົາ ເຮີມ ມັຮ ຣາເລົາ ນຸ່ມ ຊາກູລ ເປາະ ຕຶ່ງ ຣານາ. ກະ ເກົາ ເຮີມ ມານະ ຣາເລົາ ນຸ່ມ ຕາ ເບີນ ຊາປຸ່ຮ ອຶນເຕົ່າ ເລີຍ. ");
INSERT INTO ncq_vpl VALUES ("PR7_8","021_7_8","PRO","7","8","8","ອັນ ຕາຢັຮ ແຕີ່ອ໌ ປໍ ປຶ່ຮ ຣານາ; ກະ ເບີນ ມານະ ມັນແຊມ ຊາເກືາງ ເນືາງ ປັຣນາຍ ແອີດ ຕຶ່ງ ອຶນຕຸ ກັອຍ. ຣາເລົາ ກັອຍ ຕາຢັຮ ແຈ່ະ ດຸງ ມັນແຊມ ກັອຍ ");
INSERT INTO ncq_vpl VALUES ("PR7_9","021_7_9","PRO","7","9","9","ບັອງ ມັນລັ່ອງ ຊາເດົາ ການຳ ປິງ. ");
INSERT INTO ncq_vpl VALUES ("PR7_10","021_7_10","PRO","7","10","10","ເຈີ່ ມັນແຊມ ກັອຍ ແຕີ່ອ໌ ຣາມົຮ ອັນ; ເນືາງ ກັອຍ ຕັອກ ເກຣີ່ງ ນ່ະ ມັນແຊມ ຈິ ຈະ, ກະ ອາລັ່ອຮ ເງ່ ຣາພິ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR7_11","021_7_11","PRO","7","11","11","ມັນແຊມ ໄນ່ ລາ ກວາຍ ດູໄດອ໌ ດູດັຣ ຢໍອ໌ ອີ ເບີນ ຣາເລົາ ຕາ ດັງ ກູມາລ ເຈືາດ; ອັນ ລາແດິຮ ລາແດີບ ກູ່ ຮັອງ ດຸງ ກູ່ ຕາຣົ່ງ ຊູ. ");
INSERT INTO ncq_vpl VALUES ("PR7_12","021_7_12","PRO","7","12","12","ອັນ ດຸ ແອີດ ເກຣາະ ຕຶ່ງ ປຶ່ຮ ຣານາ, ແຕີລາ ຕຶ່ງ ຊັງອາຣ ອຶນດີ ເມືອງ, ແຕີລາ ຕຶ່ງ ຕາລາດ. ");
INSERT INTO ncq_vpl VALUES ("PR7_13","021_7_13","PRO","7","13","13","ອັນ ປາລັອງ ກຍາວ ກະ ຣາໂຮນ ຣາເລົາ ນຸ່ມ ກັອຍ; ອັນ ເນ່ ບຼີ່ວໆ ກະ ປາຍ ນ່ະໄນ່: ");
INSERT INTO ncq_vpl VALUES ("PR7_14","021_7_14","PRO","7","14","14","“ຕາໄງ ໄນ່ ເກົາ ເດີງ ເກຣີ່ງ ແຕີ່ອ໌ ມ່ອບ ຊາງ, ກະ ເບີນ ໄຊອ໌ ແຕ ເກຣີ່ງ ມ່ອບ ຊາງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR7_15","021_7_15","PRO","7","15","15","ເຈີ່ ເກົາ ລັ່ອຮ ອາກັ່ນ ໄມ່, ຍ່ອນ ເກົາ ຢໍອ໌ ອີ ຣາມົຮ ໄມ່; ກະ ຊານໍ່ ເກົາ ຣາມົຮ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("PR7_16","021_7_16","PRO","7","16","16","ເກົາ ເຊີນ ດໍອ໌ ອຶນຕິ ແຕ ເປຣ່ ລາເກືາ ເປ່ງ ຊາອຶ່ຍ ເລືາຍ ແຕ ກຣວາງ ເອຢິບ. ");
INSERT INTO ncq_vpl VALUES ("PR7_17","021_7_17","PRO","7","17","17","ເກົາ ເຊີນ ອາຣິ ກັອຍ ກະ ໂຈະ ຣາແລງ ປາຮວມ, ຊຽດ ອາລ່ອງ, ກະ ເກຣີ່ງ ປາຮວມ ການໍ່ອ໌ ແຮີ ຕຶ່ງ ອາຣິ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR7_18","021_7_18","PRO","7","18","18","ເປາະ ລະ! ເຈີ່ ໄຮ ປຣ່ອມ ຣໍ່ອ໌ ບູຍ ໂປ່ງບຣາງ. ໄຮ ບິ ມັນຕຸ ໂອນ ຣໍ່ອ໌! ");
INSERT INTO ncq_vpl VALUES ("PR7_19","021_7_19","PRO","7","19","19","ກາຢາອ໌ ເກົາ ຕາ ເບີນ ແອີດ ອຶນດຸງ; ອັນ ເປາະ ກຣວາງ ເຢີ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR7_20","021_7_20","PRO","7","20","20","ອັນ ເດີງ ປຣະ ຊາອຶ່ຍ, ອຶນນັ່ອງ ບາຣ ອາທິດ ແຕ ອັນ ເຈົາ ລັ່ຮ.” ");
INSERT INTO ncq_vpl VALUES ("PR7_21","021_7_21","PRO","7","21","21","ມັນແຊມ ກັອຍ ປິ່ ປຣຸ່ງ ໂອນ ປັອງ ຕໍ ຊາຣັອງ ໂອນ ຈວາດ ແຕ ປັຣນາຍ ອັນ ກາ ລາເມ່ນ ອໍໍ. ");
INSERT INTO ncq_vpl VALUES ("PR7_22","021_7_22","PRO","7","22","22","ບັອງ ກັອຍ ແຕິ່ ຣາເລົາ ກັອຍ ປວາຍ ມັນແຊມ ກັອຍ, ນ່ະ ຕາແກງ ທູ່ນ ເນົ່າ ເຕິ ປໍ ອຶນຕຸ ກາຈີດ, ແກີດ ນ່ະ ໂປຍຮ ເປາະ ຣວຍໆ, ເຈີ່ ເປາະ ປໍ ອຶນຕຸ ເນົ່າ ເຊີຍ ຕາຮໍ, ");
INSERT INTO ncq_vpl VALUES ("PR7_23","021_7_23","PRO","7","23","23","ຕາພັອງ ອັນ ຈວາດ ເລີຍ. ຣາເລົາ ໄນ່ ລາ ນ່ະ ແຈມ ປັຣ ໂຈະ ເຣ່ວ, ມາ ອັນ ຕາ ເບີນ ດັງ ເລີຍ ອັນ ບັອງ ປັຣ ໂຈະ ປໍ ອຶນຕຸ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("PR7_24","021_7_24","PRO","7","24","24","ມັຮ ກອນ ເອີຍ! ຊານໍ່ ອຶງເຄາະ ເຍືາ ຊາງັດ ເກົາ. ອຶງເຄາະ ເຍືາ ຢຳ ໂອນ ກຣັ່ກ ລາລື່ ແຕ ປັຣນາຍ ເກົາ ອາຕີ. ");
INSERT INTO ncq_vpl VALUES ("PR7_25","021_7_25","PRO","7","25","25","ອຶນໂຈຍ ໂອນ ມັນແຊມ ເບີນ ຊາເຕືາຍ໌ ເຍືາ; ອຶນໂຈຍ ຊາປິ່ລ ກະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR7_26","021_7_26","PRO","7","26","26","ອັນ ເກີ່ຍ ຕະ ໂອນ ຊາອຶ່ຍ ນະ ຣາເລົາ ແກີດ ຣາລຸຮ ຣຸ່ງຣັ່ງ; ກະ ຍ່ອນ ແຕ ອັນ, ຊາອຶ່ຍ ນະ ຣາເລົາ ກູຈີດ ປິ່ດ ແດັດ ດຽລ. ");
INSERT INTO ncq_vpl VALUES ("PR7_27","021_7_27","PRO","7","27","27","ຄັນ ເຍືາ ເປາະ ປໍ ດຸງ ອັນ, ລາ ມູເຈິງ ເຍືາ ເປາະ ປໍ ຕຣຸ່ງຕຣັ່ງ, ລາ ປໍ ປີ່ງ ກູມູ່ຍ໌. ");
INSERT INTO ncq_vpl VALUES ("PR8_1","021_8_1","PRO","8","1","1","ອຶງເຄາະ ຊາງັດ! ປັຣນາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ບັອງ ຊາບາວ ອາຕີ; ປັຣນາຍ ກັອຍ ກູອ໌ ໂອນ ຊາອຶ່ຍ ນະ ກວາຍ ເບີນ ຊັອງ ຊຽງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR8_2","021_8_2","PRO","8","2","2","ປັຣນາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ແອີດ ຕຶ່ງ ອານວລ ກົຮ ກະ ຕຶ່ງ ຣານາ ປັຣແວັຮ. ");
INSERT INTO ncq_vpl VALUES ("PR8_3","021_8_3","PRO","8","3","3","ປັຣນາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ແອີດ ແຈ່ະ ປັຣລັອຮ ເມືອງ, ກະ ຊາບາວ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("PR8_4","021_8_4","PRO","8","4","4","“ເອີ ມັຮ ກວາຍ ເອີຍ! ເກົາ ກູອ໌ ເຍືາ! ຊຽງ ເກົາ ຊາບາວ ຮັບ ແຕີ່ອ໌ ປໍ ກູ່ ນະ ກວາຍ ຕຶ່ງ ກຣວາງ ກູແຕອ໌ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("PR8_5","021_8_5","PRO","8","5","5","ມັຮ ເຍືາ ກາ ຕະ ນ່ະ ກັຣແນນ ເອີຍ! ອຶງເຄາະ ເຍືາ ຣຍານ ໂອນ ດັງ ເງ່ ຣາໄງ່ອ໌ ຣາລັ່ງ. ມັຮ ກວາຍ ຊາກູລ ເອີຍ! ອຶງເຄາະ ເຍືາ ຣຍານ ໂອນ ແຄວ໌. ");
INSERT INTO ncq_vpl VALUES ("PR8_6","021_8_6","PRO","8","6","6","ອຶງເຄາະ ເຍືາ ຊາງັດ ມັຮ ປັຣນາຍ ເກົາ ປາຍ, ຍ່ອນ ປັຣນາຍ ກັອຍ ເບີນ ເກືາ ລາລື່; ກູ່ ຣາມຶ່ຮ ເກົາ ປາຍ ລາ ແອີງ ປຍາຍ໌. ");
INSERT INTO ncq_vpl VALUES ("PR8_7","021_8_7","PRO","8","7","7","ປັຣໄລຮ ປັຣນາຍ ເກົາ ແອີງ ໄກຣ ອຶນແຍ່ະ; ເກົາ ຊາອັຣ ກູ່ ປັຣນາຍ ອາໂລກ. ");
INSERT INTO ncq_vpl VALUES ("PR8_8","021_8_8","PRO","8","8","8","ກູ່ ປັຣນາຍ ເກົາ ປາຍ ລາ ແອີງ ຕານັ່ອງ, ຕາ ເບີນ ປັຣນາຍ ອຶນເຕົ່າ ມາ ໂກ່ະ ແຕີລາ ອາໂລກ. ");
INSERT INTO ncq_vpl VALUES ("PR8_9","021_8_9","PRO","8","9","9","ມັຮ ກວາຍ ຣາໄງ່ອ໌ ເຕ່ອ໌ ດັງ ແຈງ ແຕ ປັຣນາຍ ເກົາ ປາຍ; ມັຮ ກວາຍ ກາ ດັງ, ເຕ່ອ໌ ໄລ່ ຊາປຸ່ຮ ປາຍ ປັຣນາຍ ເກົາ ລາ ປຍາຍ໌ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("PR8_10","021_8_10","PRO","8","10","10","ຄາອ໌ ໄມ່ ຣຽຮ ປັຣນາຍ ເກົາ ຕຽຮ ໄນ່ ແຕ ໄມ່ ຣຽຮ ປຣະ; ຄາອ໌ ໄມ່ ຣຽຮ ໂອນ ດັງ ແຈງ ແຕ ໄມ່ ຈໍ່ອ໌ ແຢງ. ");
INSERT INTO ncq_vpl VALUES ("PR8_11","021_8_11","PRO","8","11","11","ຍ່ອນ ຣາໄງ່ອ໌ ຣາລັ່ງ ເບີນ ເກືາ ກາເລີຍ ແຕ ຕາເມົາ ເປ່ງ; ອຶນເຕົ່າ ໄມ່ ຢໍອ໌ ອີ ເບີນ, ລາ ຕາ ເຕ່ອ໌ ຕາລີ ກະ ຣາໄງ່ອ໌ ຣາລັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR8_12","021_8_12","PRO","8","12","12","ເກົາ ໄນ່ ແຕິ່ ລາ ຣາໄງ່ອ໌ ຣາລັ່ງ; ເກົາ ເຕ່ອ໌ ຕາຕ່ອຍ໌ ຣາໄລ່ຮ; ເກົາ ເບີນ ເງ່ ດັງ ກະ ເງ່ ຕະ ກຣັ່ກ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR8_13","021_8_13","PRO","8","13","13","ຄັນ ເຍືາ ຢຳນັ່ບ ເຢືາງ ເຈົາຣາຊີ ປຍາຍ໌ ລາລື່, ລາ ເຍືາ ຊາອັຣ ຣານະ ຕາ ອໍ; ເກົາ ຊາອັຣ ຣານະ ໂອດ, ແຣັ່ງ, ຣານະ ຕາ ອໍ, ກະ ປັຣນາຍ ອາແປັດ. ");
INSERT INTO ncq_vpl VALUES ("PR8_14","021_8_14","PRO","8","14","14","ເກົາ ອາລັ່ອຮ ເງ່, ເຈີ່ ເກົາ ຕະ ຕາປູ່ນ ເງ່ ກັອຍ; ເກົາ ເບີນ ຊາປຸ່ຮ ກະ ເກົາ ເບີນ ອຳນາດ. ");
INSERT INTO ncq_vpl VALUES ("PR8_15","021_8_15","PRO","8","15","15","ຍ່ອນ ເກົາ ຈ່ອຍ, ມັຮ ເຕືາວ ປັຣເຍືາ ເຕ່ອ໌ ແກີດ ຊົດ, ກະ ມັຮ ກວາຍ ຊົດ ເຕ່ອ໌ ອາລັ່ອຮ ຄານອດ ຕານັ່ອງ ຕາປຶ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR8_16","021_8_16","PRO","8","16","16","ຍ່ອນ ແຕ ເກົາ, ມັຮ ກວາຍ ຊົດ ຕຶ່ງ ກຣວາງ ກູແຕອ໌ ໄນ່ ເບີນ ອຳນາດ, ກະ ເກົາ ຈ່ອຍ ໂອນ ໄລ່ ຕຳເປຣ່ອ໌ ປັຣນາຍ, ຕາ ເບີນ ຮັກບັງ ຊັງບຍາງ. ");
INSERT INTO ncq_vpl VALUES ("PR8_17","021_8_17","PRO","8","17","17","ເກົາ ອາໂຢ່ະ ອາແລ່ະ ກາ ອາໂຢ່ະ ເກົາ; ອາແລ່ະ ກາ ຈໍ່ອ໌ ເກົາ, ອັນ ຣາມົຮ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("PR8_18","021_8_18","PRO","8","18","18","ເກົາ ເບີນ ຊະເຢືາງ ປັຣເລືາງ ປາເນົາ ດໍອ໌ ໂອນ ເຍືາ, ດິ່ຮ ຊຸ ເບີນ ເຕີນ ປໍອ໌ ກະ ປຣຽດ ອໍ ທຣໍ ບອງ. ");
INSERT INTO ncq_vpl VALUES ("PR8_19","021_8_19","PRO","8","19","19","ມັຮ ຣາມຶ່ຮ ເກົາ ໂອນ ເຍືາ ລາ ອໍ ກາເລີຍ ແຕ ແຢງ; ເປ່ງ ກາເລີຍ ແຕ ປຣະ. ");
INSERT INTO ncq_vpl VALUES ("PR8_20","021_8_20","PRO","8","20","20","ເກົາ ຕະ ເປາະ ຕຶ່ງ ຣານາ ຕານັ່ອງ ອໍ, ກະ ຕຶ່ງ ຣານາ ປຍາຍ໌ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR8_21","021_8_21","PRO","8","21","21","ເກົາ ໂອນ ກວາຍ ກາ ອາໂຢ່ະ ເກົາ ເບີນ ຕຽນ ວັ່ນ ຊາປັ່ນ ປຣະ, ກະ ເກົາ ຕະ ໂອນ ດຸງ ໄລ່ ເບີນ ໂດຍ ຕາ ຣາລໍ່ ທຣໍ ຕາ ຣາລິ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("PR8_22","021_8_22","PRO","8","22","22","“ເຢືາງ ເຈົາຣາຊີ ແຕງ ເກົາ ອຶນໂຍ່ງ, ເຈີ່ ອັນ ແຕງ ມັຮ ຣາມຶ່ຮ ການໍ່ອ໌; ຕາແບິ ລາລື່ ລາ ອັນ ແຕງ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("PR8_23","021_8_23","PRO","8","23","23","ອັນ ແຕງ ເກົາ ແຕ ແດີຍ ອຶມແບິ ອາໄຣ່, ອຶນໂຍ່ງ ແຕ ອັນ ແຕງ ກຣວາງ ກູແຕອ໌ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("PR8_24","021_8_24","PRO","8","24","24","ເບີນ ເກົາ ອຶນໂຍ່ງ ເວືາຍ, ແວັດ ກັອຍ ແຕ ເບີນ ທາເລ, ກະ ເບີນ ປັຣໂລ່ຍ໌ ແດີອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR8_25","021_8_25","PRO","8","25","25","ອຶນໂຍ່ງ ອັນ ອາຈຸຮ ມັຮ ກົຮ ກີ່ງ, ກະ ອຶນໂຍ່ງ ແຕ ອັນ ແຕງ ມັຮ ກົຮ ກ່ອຣ ຈອຣ ຕູມ, ລາ ເກົາ ເບີນ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("PR8_26","021_8_26","PRO","8","26","26","ອຶນໂຍ່ງ ເຢືາງ ເຈົາຣາຊີ ແຕງ ກຣວາງ, ແຕງ ເນືາ ໄທຣ, ແຕີລາ ແຕງ ກູແຕອ໌ ເຮີບ ຕາແບິ. ");
INSERT INTO ncq_vpl VALUES ("PR8_27","021_8_27","PRO","8","27","27","ເກົາ ເບີນ ແອີດ ຕຶ່ງ ອຶນຕຸ ກັອຍ ບັອງ ອັນ ອາຈຸຮ ມັນລັ່ອງ; ບັອງ ອັນ ກັຣຢັ່ຮ ເປິບ ມັນລັ່ອງ ກະ ທາເລ; ");
INSERT INTO ncq_vpl VALUES ("PR8_28","021_8_28","PRO","8","28","28","ບັອງ ອັນ ອາຈຸຮ ມັຮ ຣາມິ່ລ ຕຶ່ງ ມັນລັ່ອງ, ກະ ບັອງ ອັນ ຕະ ປັຣໂລ່ຍ໌ ແດີອ໌ ລັ່ອຮ ອາຊັອຮ; ");
INSERT INTO ncq_vpl VALUES ("PR8_29","021_8_29","PRO","8","29","29","ບັອງ ອັນ ຕະ ຣາລັ່ນ ໂອນ ທາເລ ແອີດ, ຕາ ໂອນ ທາເລ ເປຼີຍ ແຕ ຣາລັ່ນ ກາ ອັນ ນັ່ດ ດໍອ໌; ບັອງ ອັນ ອາຈຸຮ ຕານາງ ກຣວາງ ກູແຕອ໌ ໄນ່, ບັອງ ກັອຍ ເກົາ ເບີນ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("PR8_30","021_8_30","PRO","8","30","30","ບັອງ ກັອຍ ເກົາ ແອີດ ກະ ອັນ, ນ່ະ ກວາຍ ເຈືາງ ອຶມປຣ່ອມ ຕະ ດຸງ ເຕ່. ເກົາ ຕະ ໂອນ ອັນ ຊັອງ ຣໍ່ອ໌ ບູຍ ກູ່ ຣາໄງ; ກະ ເກົາ ຊັອງ ຣໍ່ອ໌ ເລືອຍໆ ແອີດ ຢັ່ຮ ເມືາງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR8_31","021_8_31","PRO","8","31","31","ເກົາ ຊັອງ ບູຍ ແຮີຣ ລາລື່ ຍ່ອນ ອັນ ແຕງ ກຣວາງ ກູແຕອ໌ ໄນ່, ກະ ເກົາ ຊັອງ ຣໍ່ອ໌ ຣາງຶ່ຮ ອັນ ແຕງ ກູ່ ນະ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("PR8_32","021_8_32","PRO","8","32","32","“ມັຮ ກວາຍ ນຸ່ມ ເອີຍ! ອຶງເຄາະ ເຍືາ ຊາງັດ ເກົາ ນໍ! ອຶງເຄາະ ເຍືາ ຕະ ຕາປູ່ນ ນ່ະ ເກົາ ປາຍ; ນ່ະກັອຍ ຣາງຶ່ຮ ເຍືາ ແກີດ ຣໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR8_33","021_8_33","PRO","8","33","33","ອຶງເຄາະ ເຍືາ ຕະ ຕາປູ່ນ ມັຮ ປັຣນາຍ ເກົາ ຕຽຮ. ອຶງເຄາະ ເຍືາ ແກີດ ຣາໄງ່ອ໌ ຣາລັ່ງ; ອຶນໂຈຍ ກູເຕືາງ ຕັຮ ມັຮ ປັຣນາຍ ເກົາ ຕຽຮ. ");
INSERT INTO ncq_vpl VALUES ("PR8_34","021_8_34","PRO","8","34","34","ກວາຍ ອາແລ່ະ ຊາງັດ ເກົາ, ກວາຍ ກັອຍ ເບີນ ບຸ່ນ; ອັນ ກັອຍ ແອີດ ອາກັ່ນ ເລືອຍໆ ຕຶ່ງ ງັ່ຮ ຕົ່ງ ດຸງ ເກົາ ໄງ ຣາໄງ. ");
INSERT INTO ncq_vpl VALUES ("PR8_35","021_8_35","PRO","8","35","35","ກວາຍ ອາແລ່ະ ກາ ຣາມົຮ ເກົາ, ອັນ ເບີນ ອາມົ່ງ, ກະ ເຢືາງ ເຈົາຣາຊີ ຊັອງ ຣໍ່ອ໌ ກະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR8_36","021_8_36","PRO","8","36","36","ກວາຍ ອາແລ່ະ ມາ ຕາ ເບີນ ຣາມົຮ ເກົາ, ລາ ອັນ ຕະ ໂອນ ຈະ ອັນ ເບີມ ຊາແຣັຮ ຊາຣວຍ; ກວາຍ ອາແລ່ະ ມາ ຊາອັຣ ເກົາ, ລາ ອັນ ຢໍອ໌ ອາກັນ ກູຈີດ ແດັດ ດຽລ.” ");
INSERT INTO ncq_vpl VALUES ("PR9_1","021_9_1","PRO","9","1","1","ເງ່ ຣາໄງ່ອ໌ ຣາລັ່ງ ຈົຮ ດຸງ ອັນ, ອັນ ປາຕຶ່ງ ຕາປູ່ລ ລຳ ຕາໂນລ. ");
INSERT INTO ncq_vpl VALUES ("PR9_2","021_9_2","PRO","9","2","2","ຣາໄງ່ອ໌ ຣາລັ່ງ ກຍາກ ຊັນຕຣັ່ນ ດໍອ໌ ຈາ ຣໍ່ອ໌, ບອງ ເກຣີ່ງ ປາຮວມ ໂຈະ ຕຶ່ງ ບຼັອງ ອາງຸ່ນ, ກະ ກຽມ ກູໂຕອ໌ ຈາ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("PR9_3","021_9_3","PRO","9","3","3","ຣາໄງ່ອ໌ ຣາລັ່ງ ແປຣີ ມັຮ ມັນແຊມ ຕະ ຣານະ ອັນ ລັ່ອຮ ຊາບາວ ແຕ ອຶນຕຸ ຕີ່ ລາລື່ ຕຶ່ງ ເມືອງ, ປາຍ ນ່ະໄນ່: ");
INSERT INTO ncq_vpl VALUES ("PR9_4","021_9_4","PRO","9","4","4","“ມັຮ ກວາຍ ຊາກູລ ເອີຍ! ມູ່ດ ປໍ ໄນ່!” ເຈີ່ ອັນ ການື່ຍ ມັຮ ກວາຍ ຊາກູລ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("PR9_5","021_9_5","PRO","9","5","5","“ເປາະ ປໍ ໄນ່! ແຕີ່ອ໌ ຈາ ໂດຍ, ກະ ງ່ອຍ໌ ບຼັອງ ອາງຸ່ນ ກາ ເກົາ ບອງ ດໍອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR9_6","021_9_6","PRO","9","6","6","ອຶງເຄາະ ເຍືາ ຕັຮ ຊັອງ ເງ່ ຊາກູລ, ເຈີ່ ເຍືາ ເຕ່ອ໌ ເບີນ ອາມົ່ງ. ອຶງເຄາະ ເຍືາ ຕະ ເປາະ ປວາຍ ເງ່ ຣາໄງ່ອ໌ ຣາລັ່ງ.” ");
INSERT INTO ncq_vpl VALUES ("PR9_7","021_9_7","PRO","9","7","7","ຄັນ ໄມ່ ກາໄຕ່ຮ ອາຕີ ກວາຍ ອາຊັອຮ ຈະ, ລາ ອັນ ອາເຢ່ ພາມາດ ລັ່ຮ ໄມ່. ຄັນ ໄມ່ ຕຽຮ ກວາຍ ແຣັ່ງ, ເຈີ່ ອັນ ປາຍ ຕິ່ ລັ່ຮ ໂຈະ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("PR9_8","021_9_8","PRO","9","8","8","ອຶນໂຈຍ ຕາໄມຮ ກວາຍ ອາຊັອຮ ຈະ, ຍ່ອນ ອັນ ອີ ຊາອັຣ ໄມ່. ມາ ຄັນ ໄມ່ ກາໄຕ່ຮ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ, ເມ່ນ ອັນ ຢຳນັ່ບ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("PR9_9","021_9_9","PRO","9","9","9","ກູ່ ຊັນຕອຍ໌ ໄມ່ ອາຕີ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ, ອັນ ແກີດ ຣາໄງ່ອ໌ ຣາລັ່ງ ເຕີມ ແອັນ. ມັຮ ຊັນຕອຍ໌ ໄມ່ ອາຕີ ກວາຍ ຕານັ່ອງ ອໍ, ອັນ ແກີດ ດັງ ອາຊັອຮ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR9_10","021_9_10","PRO","9","10","10","ຢຳນັ່ບ ເຢືາງ ເຈົາຣາຊີ ລາ ກັ່ລ ຣາໄງ່ອ໌ ຣາລັ່ງ. ຄັນ ໄມ່ ດັງ ເຢືາງ ກາ ບຣັຮ ອໍ, ລາ ແຮງ ໄມ່ ເບີນ ຊາປຸ່ຮ ຊາອຶ່ຍ. ");
INSERT INTO ncq_vpl VALUES ("PR9_11","021_9_11","PRO","9","11","11","ຣາໄງ່ອ໌ ຣາລັ່ງ ໂອນ ໄມ່ ເບີນ ແກີດ ກົງ ອາມົ່ງ ດູ່ນ. ");
INSERT INTO ncq_vpl VALUES ("PR9_12","021_9_12","PRO","9","12","12","ຄັນ ໄມ່ ເບີນ ຣາໄງ່ອ໌ ຣາລັ່ງ, ລື່ ໄມ່ ເບີມ ເບີນ ເກືາ ອາຊັອຮ; ມາ ຄັນ ໄມ່ ຕາ ແອອ໌ ຣາໄງ່ອ໌ ຣາລັ່ງ, ລາ ໄມ່ ແຕິ່ ຣາມົຮ ຕຸ່ຮ ກັ່ດ. ");
INSERT INTO ncq_vpl VALUES ("PR9_13","021_9_13","PRO","9","13","13","ຣານະ ຊາກູລ ລາ ນ່ະ ມັນແຊມ ກາ ມັ່ກ ປູປົ່ກ ຊາແບລ ຊາກອລ; ອັນ ຕາ ດັງ ກຍາອ໌ ຈະ ອັນ ເບີມ, ກະ ອັນ ຕາ ດັງ ແອີດ ມັນຕັ່ດ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR9_14","021_9_14","PRO","9","14","14","ມັນແຊມ ກັອຍ ດຸ ຕາກູ ຕຶ່ງ ງັ່ຮ ຕົ່ງ ດຸງ ອັນ, ແຕີລາ ຕຶ່ງ ອຶນຕຸ ຕີ່ ລາລື່ ຕຶ່ງ ເມືອງ; ");
INSERT INTO ncq_vpl VALUES ("PR9_15","021_9_15","PRO","9","15","15","ເຈີ່ ອັນ ຊາບາວ ໂຈະ ກວາຍ ກາ ເປາະ ເຈົາ ແຕ ຣານະ ໄລ່. ອັນ ປາຍ ນ່ະໄນ່: ");
INSERT INTO ncq_vpl VALUES ("PR9_16","021_9_16","PRO","9","16","16","“ມັຮ ກວາຍ ຊາກູລ ເອີຍ! ມູ່ດ ປໍ ໄນ່!” ເຈີ່ ອັນ ປັຣຕຶ່ ມັຮ ກວາຍ ຊາກູລ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("PR9_17","021_9_17","PRO","9","17","17","“ງ່ອຍ໌ ແດີອ໌ ກາ ເນົ່າ ຕວຍ໌ ລາ ອຶງເງືາມ ກາເລີຍ. ຈາ ໂດຍ ກາ ເນົ່າ ຕວຍ໌ ລາ ແອມ ລາລື່ ເຕ່.” ");
INSERT INTO ncq_vpl VALUES ("PR9_18","021_9_18","PRO","9","18","18","ມັຮ ກວາຍ ກາ ແອີດ ຕຶ່ງ ຕາລາງ ອາຕີ ມັນແຊມ ກັອຍ, ໄລ່ ຕາ ເບີນ ດັງ ເລີຍ ໄລ່ ບັອງ ຊາປິ່ລ ຕຶ່ງ ຕຣຸ່ງຕຣັ່ງ, ລາ ອຶນຕຸ ກວາຍ ກູຈີດ ແອີດ. ");
INSERT INTO ncq_vpl VALUES ("PR10_1","021_10_1","PRO","10","1","1","ໄນ່ ລາ ປັຣນາຍ ປາລີ່ ພາຍາ ແຕ ເຕືາວ ປັຣເຍືາ ໂຊໂລໂມນ: ກອນ ຣາໄງ່ອ໌ ຣາລັ່ງ ຕະ ໂອນ ອຶມເປ່ອ໌ ອຶມປໍ່ ຣໍ່ອ໌ ຣາງຶ່ຮ ຊັນຕຣຸ່ຮ ລ່ອມ; ມາ ກອນ ກາ ຊາກູລ ຕະ ໂອນ ໄລ່ ແກີດ ຕຸ່ຮ ງໍ່. ");
INSERT INTO ncq_vpl VALUES ("PR10_2","021_10_2","PRO","10","2","2","ຊຸ ເບີນ ຍ່ອນ ແຕ ຕະ ຣານະ ຕາ ອໍ, ລາ ຕາ ເບີນ ແກີດ ເກືາ ອຶນເຕົ່າ; ມາ ເງ່ ຕານັ່ອງ ອໍ ເຕ່ອ໌ ຈ່ອຍ ອາມົ່ງ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("PR10_3","021_10_3","PRO","10","3","3","ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ໂອນ ກວາຍ ຕານັ່ອງ ອໍ ແກີດ ຕຸ່ຮ ກູປາຍຮ ມາເຍືາຍຮ ໂດຍ; ມາ ອັນ ຕາ ໂອນ ກວາຍ ຕາ ອໍ ເບີນ ມັຮ ຣາງຶ່ຮ ໄລ່ ຊັອງ ຢໍອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR10_4","021_10_4","PRO","10","4","4","ກວາຍ ອາລັ່ຮ ແກີດ ຕຸ່ຮ ຕັລ ຕາກັລ ຕາບີງ; ມາ ກວາຍ ແທຣິງ ແກີດ ຊຸ ເບີນ ເຕີນ ປໍອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR10_5","021_10_5","PRO","10","5","5","ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ປາໂຣມ ຣາມັ່ດ ດໍອ໌ ທຣໍ ແຕີ່ອ໌ ຍາມ ຣິ່ ໂດຍ; ມາ ກວາຍ ບິ ກູຕຸ່ ຕູ່ຣ ມູ່ຣ ມຍາຣ ແຕີ່ອ໌ ຍາມ ຊູຊອດ, ລື່ ອັນ ແກີດ ກູມາລ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("PR10_6","021_10_6","PRO","10","6","6","ກວາຍ ຕານັ່ອງ ອໍ ເບີນ ບຸ່ນ ຕຶ່ງ ຣາແລີຍ ແກີຍ ຣາແອີຍ ຕຶ່ງ ຣາແລີຍ໌ ແກີຍ໌; ມາ ປັຣນາຍ ກວາຍ ຕາ ອໍ ດຸ ປາໂຕ່ະ ມັຮ ເງ່ ແຣັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR10_7","021_10_7","PRO","10","7","7","ບຸ່ນ ລາລື່ ໄຮ ຊາແຍີ ກວາຍ ຕານັ່ອງ ອໍ, ມາ ກວາຍ ຕາ ອໍ ເນົ່າ ຊາລີຣ ໄຈ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR10_8","021_10_8","PRO","10","8","8","ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ຣັ່ບ ອີດ ແຕີ່ອ໌ ເນົ່າ ຕຽຮ ປັຣນາຍ ອໍ; ມາ ກວາຍ ຊາກູລ ມັ່ກ ຊູຊວາອ໌, ລາ ແກີດ ຣານະ ຣຸ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR10_9","021_10_9","PRO","10","9","9","ກວາຍ ຕານັ່ອງ ອໍ ເບີນ ແອີດ ກຼີດ ກຼອດ ຈອດ ອໍ; ມາ ກວາຍ ໂກ່ະ, ແຕີ່ອ໌ ປັຣຊົດ ເນົ່າ ຊາແຕີມ ແຕ ຣານະ ຕາ ອໍ ອັນ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("PR10_10","021_10_10","PRO","10","10","10","ກວາຍ ມາຍີ່ວ ມັ່ດ ມັ່ກ ຕະ ອຶນຕີ ອາໂລກ, ລື່ ອັນ ຕະ ໂອນ ຈະ ອັນ ຕຸ່ຮ ຕັລ ຕາກັລ ຕາບີງ; ມາ ກວາຍ ອາແລ່ະ ຍັ່ນ ກາແອັຮ ຢັ່ຮ ເມືາງ ກວາຍ ຕະ ຣານະ ໂລ່ຍຮ, ເຈີ່ ອັນ ເດີງ ຣານະ ຣາຕອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR10_11","021_10_11","PRO","10","11","11","ປັຣນາຍ ກວາຍ ອໍ ແກີດ ນ່ະ ປັຣໂລ່ຍ໌ ແດີອ໌ ໂອນ ອາມົ່ງ; ມາ ປັຣນາຍ ກວາຍ ຕາ ອໍ ປາໂຕ່ະ ດໍອ໌ ມັຮ ເງ່ ແຣັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR10_12","021_10_12","PRO","10","12","12","ມານະ ຊາອັຣ ມານະ ຕະ ໂອນ ຣາລຸຮ ຕຣໍ່ ຣາລໍ່ ວີ່ລ; ມາ ມານະ ອາໂຢ່ະ ມານະ ຕະ ໂອນ ມານະ ເຕ່ອ໌ ຕັຮ ໂລ່ຍຮ ມານະ. ");
INSERT INTO ncq_vpl VALUES ("PR10_13","021_10_13","PRO","10","13","13","ກວາຍ ກາ ປາຍ ນານ່ະ ເກືາ ກາຮາ ນານ່ະ ແບຼງ, ລາ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ; ມາ ກວາຍ ຊາກູລ, ເນົ່າ ວັ່ດ ອັນ ແຕ ກ່ອນ. ");
INSERT INTO ncq_vpl VALUES ("PR10_14","021_10_14","PRO","10","14","14","ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ປາໂຣມ ໂອນ ດັງ ຊາອຶ່ຍ, ມູເຈິງ ເນົ່າ ອຶງໂກຍ ປາໂຣມ ທຣໍ ຕຶ່ງ ຊູ; ມາ ແບອ໌ ກວາຍ ຊາກູລ ແຮງ ປິ່ດ ຕາແປດ ແທຣດ ຕາປູ່ນ. ");
INSERT INTO ncq_vpl VALUES ("PR10_15","021_10_15","PRO","10","15","15","ມັຮ ກວາຍ ຊຸ ເບີນ ເຕີນ ປໍອ໌ ປັ່ອງ ມູ່ນມັ່ງ ຊັງ ຊານາ; ມາ ກວາຍ ຕຸ່ຮ ຊັຣນາ ເລືາ ອຶນແຕີດ ແອິ ອຶນເຕົ່າ ອີ ປັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("PR10_16","021_10_16","PRO","10","16","16","ກວາຍ ຕານັ່ອງ ອໍ ເບີນ ແກີດ ກົງ ອາມົ່ງ ດູ່ນ; ມາ ກວາຍ ຕາ ອໍ ປິ່ດ ນ່ະ ຣາໄບຮ ກັລໄດຮ ນ່ະ ມັນຈິ່ລ. ");
INSERT INTO ncq_vpl VALUES ("PR10_17","021_10_17","PRO","10","17","17","ກວາຍ ອາແລ່ະ ມາ ຊາງັດ ປັຣນາຍ ເນົ່າ ຕຽຮ, ອັນ ເບີນ ອາມົ່ງ; ມາ ກວາຍ ອາແລ່ະ ກາ ຕາ ເບີນ ຣາບູລ ແຕີ່ອ໌ ເນົ່າ ຕາໄມຮ, ລາ ອັນ ແກຼິກຼູ່ ຣູ່ບາ. ");
INSERT INTO ncq_vpl VALUES ("PR10_18","021_10_18","PRO","10","18","18","ກວາຍ ອາແລ່ະ ມາ ປາໂຕ່ະ ຣາງຶ່ຮ ຊາອັຣ, ອັນ ລາ ກວາຍ ອາໂລກ; ກວາຍ ອາແລ່ະ ກາ ຕາແມີຍຮ ຈາ ອຶນຕຣິ່ນ ຕາມິ່ນ ຈາ ອຶນຈີ, ລາ ກວາຍ ຊາກູລ. ");
INSERT INTO ncq_vpl VALUES ("PR10_19","021_10_19","PRO","10","19","19","ກວາຍ ແບອ໌ ອຶນຕາງ ເກືາງ ຕາດັຮ ລາ ມັ່ກ ເລ່ຣ; ມາ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ມູ ປັຣໄລຮ ແບຼງ ມູ ຊັຣແລງ ຄິດ. ");
INSERT INTO ncq_vpl VALUES ("PR10_20","021_10_20","PRO","10","20","20","ປັຣນາຍ ກວາຍ ຕານັ່ອງ ອໍ ແກີດ ນ່ະ ແດີອ໌ ປຣະ ແດີອ໌ ແຢງ; ມາ ຣາງຶ່ຮ ກວາຍ ຕາ ອໍ ຄຶ່ດ ຕາ ເບີນ ເກືາ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR10_21","021_10_21","PRO","10","21","21","ປັຣນາຍ ກວາຍ ອໍ ຊາແລັຮ ມູ ກຼອງ ແກີດ ປຣະ ແກີດ ຕາຣຍາອ໌; ມາ ກວາຍ ຊາກູລ ຊາແລັຮ ມູ ກຼອງ ແກີດ ປິ່ດ ຕາແປດ ແທຣດ ຕາປູ່ນ. ");
INSERT INTO ncq_vpl VALUES ("PR10_22","021_10_22","PRO","10","22","22","ເຢືາງ ເຈົາຣາຊີ ຈໍອ໌ ກຼື່ອ໌ ກາຕື່ອ໌ ອາຢວຣ ໂອນ ກວາຍ ແກີດ ຊຸ ເບີນ ເຕີນ ປໍອ໌. ກະ ອັນ ຕາ ເບີນ ຕະ ໂອນ ໄລ່ ຊາປິ່ລ ຕຶ່ງ ແດີອ໌ ອຶນຕຣູ່ ຕູ່ ຮັບ. ");
INSERT INTO ncq_vpl VALUES ("PR10_23","021_10_23","PRO","10","23","23","ກວາຍ ຊາກູລ ມັ່ກ ລາລື່ ຕະ ຣານະ ຕາ ອໍ; ມາ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ຊັອງ ຣໍ່ອ໌ ແຕ ຣານະ ຣາໄງ່ອ໌ ຣາລັ່ງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR10_24","021_10_24","PRO","10","24","24","ຣານະ ອຶນເຕົ່າ ກວາຍ ຕາ ອໍ ຊັອງ ອຶງກັອຮ, ຣານະ ກັອຍ ລື່ ແຕີ່ອ໌ ປໍ ອັນ; ມາ ຣານະ ອຶນເຕົ່າ ກວາຍ ຕານັ່ອງ ຊັອງ ຢໍອ໌, ລື່ ອຶນເຈົາ ໂອນ ອັນ ເບີນ. ");
INSERT INTO ncq_vpl VALUES ("PR10_25","021_10_25","PRO","10","25","25","ພໍກາ ກູຢາລ ຣາປູ່ອ໌ ພັດ ແວັດ ເຈີ່, ຕາ ເບີນ ນັ່ອງ ກວາຍ ຕາ ອໍ; ມາ ກວາຍ ຕານັ່ອງ ອໍ ອຶນນັ່ອງ ແອີດ ກຼີດ ກຼອດ ຈອດ ອໍ ເລືອຍໆ. ");
INSERT INTO ncq_vpl VALUES ("PR10_26","021_10_26","PRO","10","26","26","ນ່ະ ອຶນເຍາະ ຕະ ໂອນ ກາແນງ ແກີດ ກາຮຽລ, ກະ ປາຮຍາອ໌ ອູ່ຍຮ ໂທຍ ຕະ ໂອນ ມັ່ດ ແກີດ ຕຣັນ, ມູເຈິງ ກັອຍ ເຕ່ ກວາຍ ອາລັ່ຮ ຕະ ໂອນ ເນືາຍ ມິ່ດ ອາອຸ່ງ ປຸ່ງ ອຶນໂຊະ. ");
INSERT INTO ncq_vpl VALUES ("PR10_27","021_10_27","PRO","10","27","27","ກວາຍ ອາແລ່ະ ຢຳນັ່ບ ເຢືາງ ເຈົາຣາຊີ, ອັນ ແກີດ ກົງ ອາມົ່ງ ດູ່ນ; ມາ ແດີຍ ອາມົ່ງ ກວາຍ ແຣັ່ງ ແກີດ ອຶງແກັຮ ອາແຊງ. ");
INSERT INTO ncq_vpl VALUES ("PR10_28","021_10_28","PRO","10","28","28","ແຕີ່ອ໌ ປັຣຊົດ, ຣາມຶ່ຮ ກາ ກວາຍ ອໍ ອຶງກ່ອງ ຕະ ຣໍ່ອ໌ ນ່ະ ຄູຍ ບູຍ ນ່ະ ເກ່ນ; ມາ ຣາມຶ່ຮ ກາ ກວາຍ ຕາ ອໍ ອຶງກ່ອງ ແກີດ ແດັດ ປິ່ດ ຊາລີຣ. ");
INSERT INTO ncq_vpl VALUES ("PR10_29","021_10_29","PRO","10","29","29","ເຢືາງ ເຈົາຣາຊີ ລາ ອຶນຕຸ ກວາຍ ຕານັ່ອງ ອໍ ປັ່ອງ; ມາ ອັນ ອາປິ່ດ ກວາຍ ຕະ ຣານະ ຕາ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR10_30","021_10_30","PRO","10","30","30","ກວາຍ ຕານັ່ອງ ອໍ ເບີນ ແອີດ ກຼີດ ກຼອດ ຈອດ ອໍ; ມາ ກວາຍ ຕາ ອໍ ກູຈີດ ປິ່ດ ແດັດ ດຽລ ຕຶ່ງ ກຣວາງ ກູແຕອ໌ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("PR10_31","021_10_31","PRO","10","31","31","ແບອ໌ ກວາຍ ຕານັ່ອງ ອໍ ຕະ ອຶນຕີ ປັຣນາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ; ມາ ອຶມວຍາດ ກວາຍ ຕາ ອໍ, ເນົ່າ ກີມ ຕັຮ. ");
INSERT INTO ncq_vpl VALUES ("PR10_32","021_10_32","PRO","10","32","32","ກວາຍ ຕານັ່ອງ ອໍ ຕະ ອຶນຕີ ແກີດ ຊັຣນັບ; ມາ ກວາຍ ຕາ ອໍ ປາຍ ກາເລີຍ ອາຍີ່ ຕີ່ ກາເລີຍ ອາກູນ. ");
INSERT INTO ncq_vpl VALUES ("PR11_1","021_11_1","PRO","11","1","1","ເຢືາງ ເຈົາຣາຊີ ຊາອັຣ ລາລື່ ກວາຍ ກາ ແຕັດ ຊິງ ແຄງ ອີ ກຸມປູ່ຣ ກູເວືາດ ເນົ່າ; ມາ ອັນ ຣໍ່ອ໌ ກະ ກວາຍ ແຕັດ ຊິງ ເຈຍ ປຍາຍ໌. ");
INSERT INTO ncq_vpl VALUES ("PR11_2","021_11_2","PRO","11","2","2","ກວາຍ ອາຊັອຮ ຈະ ອີ ແກີດ ກູມາລ; ມາ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ດຸ ອາແຊງ ຈະ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("PR11_3","021_11_3","PRO","11","3","3","ກວາຍ ຕານັ່ອງ ຕາປຶ່ງ ເບີນ ຣາມຶ່ຮ ມັນຕັ່ດ ອໍ ອາໂຢ່ງ ເລືອຍໆ ອັນ; ມາ ກວາຍ ໂກ່ະ ກາດີ ກີ ກາດູດ ແກີດ ປິ່ດ ຍ່ອນ ແຕ ຣານະ ອັນ ຕະ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("PR11_4","021_11_4","PRO","11","4","4","ມັຮ ມູ່ນມັ່ງ ຊັງ ຊານາ ຕາ ເຕ່ອ໌ ຣາຈ່ອຍ ກວາຍ ແຕີ່ອ໌ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ຕັດຊີ່ນ; ມາ ເງ່ ຕານັ່ອງ ອໍ ເຕ່ອ໌ ຈ່ອຍ ອາມົ່ງ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("PR11_5","021_11_5","PRO","11","5","5","ກວາຍ ກາ ມັນຕັ່ດ ມັນດຍາຮ, ຣາມຶ່ຮ ມັນຕັ່ດ ກັອຍ ຕະ ໂອນ ແດີຍ ອາມົ່ງ ອັນ ແກີດ ຕານັ່ອງ ຕາປຶ່ງ; ມາ ກວາຍ ແຣັ່ງ, ຣານະ ແຣັ່ງ ກັອຍ ຕະ ໂອນ ແດີຍ ອາມົ່ງ ອັນ ແກີດ ຊາແຣັຮ ຊາຣວຍ. ");
INSERT INTO ncq_vpl VALUES ("PR11_6","021_11_6","PRO","11","6","6","ຣານະ ຕານັ່ອງ ອໍ ຈ່ອຍ ອາມົ່ງ ກວາຍ ຕານັ່ອງ ຕາປຶ່ງ; ມາ ກວາຍ ໂກ່ະ ກີ່ ຕານ ຊາງ ກູວາງ ໂຈະ ຈະ ເບີມ ຍ່ອນ ອັນ ໂລ່ບ ເນົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR11_7","021_11_7","PRO","11","7","7","ແຕີ່ອ໌ ກວາຍ ຕາ ອໍ ກູຈີດ, ຣາມຶ່ຮ ອັນ ອຶງກ່ອງ ລາ ກູຈີດ ເຕ່; ມັຮ ມູ່ນມັ່ງ ອັນ ປັ່ອງ ລາ ຕາ ເບີນ ແກີດ ເກືາ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR11_8","021_11_8","PRO","11","8","8","ເຢືາງ ເຈົາຣາຊີ ຈ່ອຍ ໂອນ ກວາຍ ຕານັ່ອງ ອໍ ແວັດ ແຕ ມັຮ ຣານະ ຕຸ່ຮ ກັ່ດ; ມາ ຣານະ ຕຸ່ຮ ກັ່ດ ກັອຍ ແຕີ່ອ໌ ປໍ ກວາຍ ແຣັ່ງ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR11_9","021_11_9","PRO","11","9","9","ກວາຍ ຕາ ເບີນ ຊາງັດ ເຢືາງ ເຈົາຣາຊີ, ປັຣໄລຮ ປັຣນາຍ ອັນ ຕະ ໂອນ ຣາລຸຮ ຕຣໍ່ ຣາລໍ່ ວີ່ລ; ມາ ກວາຍ ຕານັ່ອງ ອໍ ເບີນ ແວັດ, ຍ່ອນ ອັນ ປັ່ອງ ຣາໄງ່ອ໌ ຣາລັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR11_10","021_11_10","PRO","11","10","10","ແຕີ່ອ໌ ກວາຍ ຕານັ່ອງ ອໍ ແກີດ ຊຸ ເບີນ ເຕີນ ປໍອ໌, ດຸງ ວີ່ລ ແກີດ ຣໍ່ອ໌ ບູຍ ລາແຮີຍ ລາແຕິ່ຮ; ແຕີ່ອ໌ ກວາຍ ຕາ ອໍ ແກີດ ຣຸ່ງ ປິ່ດ, ເບີນ ຊັອງ ແຕິ່ ຊຽງ ຕຣຍາວ ກະ ຕຣຸ່ຮ ເຕຣີ່ລ ຣໍ່ອ໌ ບູຍ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR11_11","021_11_11","PRO","11","11","11","ກວາຍ ຕານັ່ອງ ອໍ ອາແຕີ່ອ໌ ຣາມຶ່ຮ ບຸ່ນ ໂອນ ດຸງ ວີ່ລ; ມາ ປັຣນາຍ ກວາຍ ແຣັ່ງ ຕະ ໂອນ ຣາລຸຮ ຕຣໍ່ ຣາລໍ່ ວີ່ລ. ");
INSERT INTO ncq_vpl VALUES ("PR11_12","021_11_12","PRO","11","12","12","ກວາຍ ຊາກູລ ລຶ່ບ ຕາ ລຶ່ບ ພູມາດ ເລືອຍໆ ເຢົ່າ ອັນ ເບີມ; ມາ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ແອີດ ຣາງຍາອ໌ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("PR11_13","021_11_13","PRO","11","13","13","ກວາຍ ຕາແມີຍຮ ຈາ ອຶນຕຣິ່ນ ຕາມິ່ນ ຈາ ອຶນຈີ; ມາ ກວາຍ ເນົ່າ ເຕ່ອ໌ ຊາອຳ, ອັນ ປາໂຕ່ະ ດໍອ໌ ຕຶ່ງ ຣາງຶ່ຮ ມັຮ ຣາມຶ່ຮ ແກຣ່ະ. ");
INSERT INTO ncq_vpl VALUES ("PR11_14","021_11_14","PRO","11","14","14","ກຣວາງ ແອິ ກວາຍ ອາໂຢ່ງ, ລາ ແກີດ ຣຸ່ງ ຣັ່ງ; ມາ ກຣວາງ ອາແລ່ະ ເບີນ ຊາອຶ່ຍ ກວາຍ ຕຽຮ ອາຕີ, ກຣວາງ ກັອຍ ຕາ ເບີນ ແຢັ່ຮ ອຶງກອຍ ທຣອຍ ອຶງໂກ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR11_15","021_11_15","PRO","11","15","15","ກວາຍ ກາ ກ່ຳ ຕູ່ ໂອນ ກວາຍ ກາ ຕາ ເບີນ ຊາກັ່ລ ມັ່ດ ຊາກັ່ດ ເມືາງ, ລາ ນ່ະ ອັນ ປາໂຣມ ຕຸ່ຮ ກັ່ດ ໂຈະ ຈະ ອັນ ເບີມ; ມາ ກວາຍ ກາ ຕາ ເບີນ ລັບ ນ່ະກັອຍ, ອັນ ແອີດ ກຼີດ ກາແຍດ ກຼຍາຣ. ");
INSERT INTO ncq_vpl VALUES ("PR11_16","021_11_16","PRO","11","16","16","ຄາອ໌ ແກີດ ມັນແຊມ ອໍ ຣາງຶ່ຮ, ກາ ເບີນ ຊະເຢືາງ ປັຣເລືາງ ປາເນົາ; ແຕ ແກີດ ຣາເລົາ ເຮາະ, ກາ ຊຸ ເບີນ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR11_17","021_11_17","PRO","11","17","17","ກວາຍ ເບີນ ຣາງຶ່ຮ ອາໂຢ່ະ ຕະ, ຣາມຶ່ຮ ກັອຍ ແກີດ ເກືາ ໂອນ ຈະ ອັນ ເບີມ; ມາ ກວາຍ ຊາອ໌ ອາແຕີ່ອ໌ ຣາມຶ່ຮ ຕຸ່ຮ ກັ່ດ ໂອນ ຈະ ອັນ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("PR11_18","021_11_18","PRO","11","18","18","ເກືາ ກວາຍ ແຣັ່ງ ເບີນ, ລາ ມາໂຮຍ ຊັອງ; ມາ ເກືາ ກວາຍ ຕະ ຣານະ ຕານັ່ອງ ອໍ ເບີນ, ແອີດ ຊົດ ແດີຍ ເລີ່ຍ ກູມໍ. ");
INSERT INTO ncq_vpl VALUES ("PR11_19","021_11_19","PRO","11","19","19","ກວາຍ ອາແລ່ະ ຕານັ່ອງ ອໍ, ກວາຍ ກັອຍ ແກີດ ກົງ ອາມົ່ງ ດູ່ນ; ມາ ກວາຍ ອາແລ່ະ ມັ່ກ ເລືອຍໆ ອີ ຕະ ຣານະ ໂລ່ຍຮ, ກວາຍ ກັອຍ ກູຈີດ ປິ່ດ ແດັດ ດຽລ. ");
INSERT INTO ncq_vpl VALUES ("PR11_20","021_11_20","PRO","11","20","20","ເຢືາງ ເຈົາຣາຊີ ຊາອັຣ ມັຮ ກວາຍ ເບີນ ຣາງຶ່ຮ ໂກ່ະ; ມາ ອັນ ອາໂຢ່ະ ມັຮ ກວາຍ ຕະ ເລືອຍໆ ຣານະ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR11_21","021_11_21","PRO","11","21","21","ມັຮ ກວາຍ ແຣັ່ງ, ປຍາຍ໌ ລື່ ເນົ່າ ໂຈະ ໂຕ່ດ ໄລ່; ມາ ມັຮ ກວາຍ ຕານັ່ອງ ອໍ, ໄລ່ ແວັດ ວາງ ແຕ ເກຣ່າະ ກຣຍາດ. ");
INSERT INTO ncq_vpl VALUES ("PR11_22","021_11_22","PRO","11","22","22","ມັນແຊມ ຣູ່ບເຣືາງ ອໍ, ມາ ຕາ ແພບ, ລາ ມູເຈິງ ແວນ ແຢງ ກາ ເນົ່າ ຊາກັບ ຕຶ່ງ ມຸ່ຮ ອາລີ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR11_23","021_11_23","PRO","11","23","23","ມັຮ ຣາມຶ່ຮ ກວາຍ ຕານັ່ອງ ອໍ ອຶງກ່ອງ, ແຕີ່ອ໌ ປັຣຊົດ ຣາມຶ່ຮ ກັອຍ ແກີດ ແອີງ ຣານະ ອໍ; ມາ ມັຮ ຣາມຶ່ຮ ກວາຍ ແຣັ່ງ ອຶງກ່ອງ, ແຕີ່ອ໌ ປັຣຊົດ ຣາມຶ່ຮ ກັອຍ ຕະ ໂອນ ເຢືາງ ເຈົາຣາຊີ ອຶງຄື່ນ. ");
INSERT INTO ncq_vpl VALUES ("PR11_24","021_11_24","PRO","11","24","24","ອາແລ່ະ ຣາຈ່ອຍ ກວາຍ ການໍ່ອ໌ ຊາອຶ່ຍ, ອັນ ເບີນ ຣັ່ບ ລັ່ຮ ຊາອຶ່ຍ ກາເລີຍ ແຕ ກັອຍ ແອັນ; ມາ ກວາຍ ປັຣຈົ່ກ, ອັນ ແກີດ ກາດີດ ຕຸ່ຮ ລາລື່ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR11_25","021_11_25","PRO","11","25","25","ກວາຍ ຕາຮັຣ, ມັຮ ຣານະ ອັນ ຕະ ລື່ ແກີດ ເກືາ; ກວາຍ ຣາຈ່ອຍ ເຢົ່າ, ລື່ ເຢົ່າ ຈ່ອຍ ລັ່ຮ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR11_26","021_11_26","PRO","11","26","26","ເນົ່າ ດຸ ເວ່ນ ກວາຍ ປາໂຕ່ະ ອາແຊິ, ຍ່ອນ ອັນ ອີ ຈິ ເປ່ງ ກາເລີຍ, ມາ ເນົ່າ ຍ່ອງ ກວາຍ ກາ ອີ ຈິ ອາແຊິ ໂອນ ເຢົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR11_27","021_11_27","PRO","11","27","27","ຄັນ ອາແລ່ະ ຈໍ່ອ໌ ຣານະ ອໍ, ເນົ່າ ຢຳນັ່ບ ອັນ; ມາ ຄັນ ອັນ ຈໍ່ອ໌ ຣານະ ຕາ ອໍ, ຣານະ ຕາ ອໍ ກັອຍ ລົ່ບ ລັ່ຮ ປໍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR11_28","021_11_28","PRO","11","28","28","ກວາຍ ອາແລ່ະ ມາ ປັ່ອງ ຕຶ່ງ ມູ່ນມັ່ງ, ອັນ ແກີດ ອອຍ໌ ຣັ່ອຮ ກັອຮ ຊາລ ນ່ະ ຊາລາ ໂຄ; ມາ ກວາຍ ຕານັ່ອງ ອໍ ແກີດ ຊຸ ເບີນ ເຕີນ ປໍອ໌ ນ່ະ ຊາລາ ຣາມົ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR11_29","021_11_29","PRO","11","29","29","ກວາຍ ຣາໄປຮ ແກງ ຣາແປງ ບວງ ຕຶ່ງ ດຸງຊູ ອັນ, ລາ ກວາຍ ຕາລູຍ໌. ມັຮ ກວາຍ ຊາກູລ ອຶງເຄາະ ແກີດ ຊູລ ໂອນ ມັຮ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR11_30","021_11_30","PRO","11","30","30","ຣານະ ກວາຍ ຕານັ່ອງ ອໍ ຕະ ລາ ນ່ະ ປາໄລ ແຕ ອາລ່ອງ ໂອນ ກວາຍ ເບີນ ອາມົ່ງ; ກວາຍ ຈ່ອຍ ກວາຍ ການໍ່ອ໌ ເບີນ ອາມົ່ງ, ອັນ ລາ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR11_31","021_11_31","PRO","11","31","31","ຄັນ ກວາຍ ຕານັ່ອງ ອໍ ຣັ່ບ ກົງ ແຕ ມັຮ ຣານະ ອັນ ຕະ ຕຶ່ງ ແດີຍ ໄນ່, ກາເລີຍ ແຕ ກັອຍ ແອັນ ກວາຍ ກາ ຕີອ໌ ຣາງິ່ລ ຈິ່ລ ກູແຕອ໌ ອຶງເຄາະ ຣັ່ບ ໂຕ່ດ ແຕ ມັຮ ຣານະ ໄລ່ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("PR12_1","021_12_1","PRO","12","1","1","ກວາຍ ອາແລ່ະ ກາ ມັ່ກ ເນົ່າ ຕຽຮ ແຕີ່ອ໌ ອັນ ຕະ ໂລ່ຍຮ, ອັນ ລາ ກວາຍ ດັງ; ມາ ກວາຍ ອາແລ່ະ ຕາ ມັ່ກ ເນົ່າ ຕຽຮ, ລາ ກວາຍ ຊາກູລ. ");
INSERT INTO ncq_vpl VALUES ("PR12_2","021_12_2","PRO","12","2","2","ເຢືາງ ເຈົາຣາຊີ ຊັອງ ຣໍ່ອ໌ ຣາງຶ່ຮ ໂຈະ ກວາຍ ອໍ; ມາ ອັນ ອີ ຕະ ໂຕ່ດ ກວາຍ ກາ ອາລັ່ອຮ ເງ່ ຕາ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR12_3","021_12_3","PRO","12","3","3","ກວາຍ ແຣັ່ງ ຕາ ເຕ່ອ໌ ແອີດ ກຼີດ ກຼອດ ຈອດ ອໍ; ມາ ກວາຍ ຕານັ່ອງ ອໍ ຕາຢຶ່ງ ຄຳ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR12_4","021_12_4","PRO","12","4","4","ລາກວຍ ກາ ເບີນ ຣາງຶ່ຮ ຣາແຮີ ອໍ ປາຊະ ປາເຢືາງ ກາຢາອ໌ ອັນ; ມາ ລາກວຍ ກາ ເມືາງ ປໍ ຣາຕັອງ ກຣັອງ ປໍ ຕາແປັຮ, ລາ ນ່ະ ເບິ ອຶນໂຊະ ປຣີ່ໆ ຕຶ່ງ ອຶງຮາງ ກາຢາອ໌ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR12_5","021_12_5","PRO","12","5","5","ມັຮ ເງ່ ກວາຍ ຕານັ່ອງ ອໍ, ເຕ່ອ໌ ເນົ່າ ຊາອຳ; ມາ ມັຮ ເງ່ ກວາຍ ແຣັ່ງ ມັ່ກ ອີ ອາໂລກ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("PR12_6","021_12_6","PRO","12","6","6","ມັຮ ປັຣນາຍ ກວາຍ ແຣັ່ງ ຕະ ໂອນ ເນົ່າ ປິິ່ດ ຣາແປີບ ແຢີບ ຣາເວືາຍ; ມາ ມັຮ ປັຣນາຍ ກວາຍ ຕານັ່ອງ ອໍ ເຕ່ອ໌ ຣາຈ່ອຍ ກວາຍ ໂອນ ແວັດ ແຕ ເນົ່າ ອີ ຕະ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("PR12_7","021_12_7","PRO","12","7","7","ກວາຍ ແຣັ່ງ ແກີດ ຣາລຸຮ ກະ ຈຸ່ມເຈືອ ອັນ ແກີດ ແດັດ ປິ່ດ ຊາລີຣ; ມາ ຈຸ່ມເຈືອ ກວາຍ ຕານັ່ອງ ອໍ ດັຮ ປາງ ກອນ ຮອນ ປາງ ອາເຈົາ. ");
INSERT INTO ncq_vpl VALUES ("PR12_8","021_12_8","PRO","12","8","8","ເກືາ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ຣັ່ບ ລາ ດັອຮ ບຸມບວລ ຮູລ ຢຸນຢົ່ງ; ມາ ເກືາ ກວາຍ ຣາງຶ່ຮ ໂກ່ະ ຣັ່ບ ລາ ເນົ່າ ກາຈັງ ເຈືາດ ພູມາດ ເຣືາງ. ");
INSERT INTO ncq_vpl VALUES ("PR12_9","021_12_9","PRO","12","9","9","ຄາອ໌ ແກີດ ກວາຍ ເມືາດ ກາ ຕະ ນ່ະ ຊູລ ຈາ ນ່ະ ອາຍາ, ແຕ ຕະ ນ່ະ ອາຍາ ມາ ຈາ ນ່ະ ຊູລ. ");
INSERT INTO ncq_vpl VALUES ("PR12_10","021_12_10","PRO","12","10","10","ກວາຍ ຕານັ່ອງ ອໍ ບັນ ກຍາອ໌ ອໍ ຊັນຕຣັ່ນ ອັນ; ມາ ກວາຍ ແຣັ່ງ ປາຊັງ ຕັຮ ມັຮ ຊັນຕຣັ່ນ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR12_11","021_12_11","PRO","12","11","11","ກວາຍ ກາ ແທຣິງ ຕະ ເນືາ ໄທຣ, ກວາຍ ກັອຍ ເບີນ ໂດຍ ຕາ ຣາລໍ່ ທຣໍ ຕາ ຣາລິ່ຮ; ມາ ກວາຍ ດຸ ເປາະ ກູເກືາງ, ອັນ ຕະ ດຸງ ຕາ ຕຸ່ກ ກາໄຣ ຕະ ໄທຣ ຕາ ຕຸ່ກ ກູປຼູອ໌, ໂລ່ ເມືາດ ກາໄຊ ກູມໍ. ");
INSERT INTO ncq_vpl VALUES ("PR12_12","021_12_12","PRO","12","12","12","ມັຮ ກວາຍ ໂກ່ະ ໄລ່ ຈໍ່ອ໌ ເລືອຍໆ ເງ່ ມານະ ໂລ່ບ ມານະ; ມາ ມັຮ ກວາຍ ຕານັ່ອງ ອໍ ກູດຸ ຕະ ກາດະ ຈາ ຕຶ່ງ ຣານາ ປຍາຍ໌. ");
INSERT INTO ncq_vpl VALUES ("PR12_13","021_12_13","PRO","12","13","13","ກວາຍ ແຣັ່ງ ຕານ ຊາງ ກູວາງ ໂຈະ ຈະ ເບີມ ຍ່ອນ ແຕ ປັຣນາຍ ອັນ ອາໂລກ; ມາ ກວາຍ ຕານັ່ອງ ອໍ ຕາ ເບີນ ປິ່ດ ຣາແປີບ ແຢີບ ຣາເວືາຍ. ");
INSERT INTO ncq_vpl VALUES ("PR12_14","021_12_14","PRO","12","14","14","ກວາຍ ແຄວ໌ ຕະ ອຶນຕີ, ອຶນເຕົ່າ ອັນ ອີ ເບີນ, ລາ ເບີນ; ມູເຈິງ ກັອຍ ເຕ່, ກວາຍ ລື່ ເບີນ ເກືາ ແຕ ຣານະ ອໍ ອັນ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("PR12_15","021_12_15","PRO","12","15","15","ກວາຍ ຊາກູລ ຄຶ່ດ ປາຍ ມັຮ ຣານະ ອັນ ຕະ ລາ ປຍາຍ໌ ເຈີ່; ມາ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ, ອັນ ຊາງັດ ປັຣນາຍ ເນົ່າ ປາຕັບ ປານໍ ປາຕໍ ປາກິ່ຣ. ");
INSERT INTO ncq_vpl VALUES ("PR12_16","021_12_16","PRO","12","16","16","ກວາຍ ຊາກູລ ຕີອ໌ ຣາງິ່ລ ຈິ່ລ ກູແຕອ໌; ມາ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ຣາລິງ ຕາ ເບີນ ໂຕຍ໌ ຣາໂລຍ໌ ຕາ ເບີນ ອີດ ມັຮ ປັຣນາຍ ກວາຍ ການໍ່ອ໌ ພູມາດ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR12_17","021_12_17","PRO","12","17","17","ກວາຍ ຕານັ່ອງ ອາຕີ ລື່ ແຕ ຣານະ ກາ ອັນ ເຮີມ; ມາ ພາເຍືານ ມາລ່ຳ ມາລ່ອຍ ຊາງັດ ແຈມ ຊວລ ຕຶ່ງ ອາລ່ອງ ຢອງ ຊວລ ຕຶ່ງ ຕາຣົ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR12_18","021_12_18","PRO","12","18","18","ກວາຍ ກາ ປາຍ ອາລັ່ອຮ ມາ ຕາ ເບີນ ຄຶ່ດ ອຶນໂຍ່ງ, ລາ ນ່ະ ອັນ ໄປ່ອ໌ ກວາຍ ການໍ່ອ໌ ແຕ ດາວ; ມາ ປັຣນາຍ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ເຕ່ອ໌ ປົວ ໂອນ ແກີດ ບັນ ລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("PR12_19","021_12_19","PRO","12","19","19","ປັຣນາຍ ອາຕີ ປຍາຍ໌, ແອີດ ດູ່ນ ກູມໍ ກຣໍ ກາໄຊ; ມາ ປັຣນາຍ ອາຕີ ອາໂລກ, ແກີດ ແດັດ ປິ່ດ ຊາລີຣ. ");
INSERT INTO ncq_vpl VALUES ("PR12_20","021_12_20","PRO","12","20","20","ກວາຍ ມັ່ກ ອາລັ່ອຮ ເງ່ ຕາ ອໍ ອາປັຮ ອັນ ເບີນ ຣາງຶ່ຮ ອາໂລກ; ມາ ກວາຍ ອາລັ່ອຮ ເງ່ ອໍ, ແອີດ ຣໍ່ອ໌ ບູຍ ລາແຮີຍ ລາແຕິ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("PR12_21","021_12_21","PRO","12","21","21","ກວາຍ ຕານັ່ອງ ອໍ ຕາ ເບີນ ຣາມົຮ ເກຣ່າະ ກຣຍາດ ອຶນເຕົ່າ; ມາ ກວາຍ ຕາ ອໍ ເບີນ ຕຸ່ຮ ຕັລ ຕາກັລ ຕາບີງ. ");
INSERT INTO ncq_vpl VALUES ("PR12_22","021_12_22","PRO","12","22","22","ເຢືາງ ເຈົາຣາຊີ ອຶງຄື່ນ ກວາຍ ຕະ ອຶນຕີ ອາໂລກ; ມາ ອັນ ຊັອງ ຣໍ່ອ໌ ໂຈະ ກວາຍ ກາ ຕະ ນ່ະ ປັຣນາຍ ກາ ໄລ່ ປາຍ. ");
INSERT INTO ncq_vpl VALUES ("PR12_23","021_12_23","PRO","12","23","23","ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ຕາ ເບີນ ອາປັຮ ປາຍ ອັນ ດັງ ຊາອຶ່ຍ; ມາ ກວາຍ ຊາກູລ ດຸ ປາຍ ປັຣນາຍ ກາ ຕະ ໂອນ ເນົ່າ ດັງ ອັນ ເຈຍ ປຼຸງ. ");
INSERT INTO ncq_vpl VALUES ("PR12_24","021_12_24","PRO","12","24","24","ກວາຍ ແທຣິງ ເຕ່ອ໌ ແກີດ ຊົດ ກວາຍ ການໍ່ອ໌; ມາ ກວາຍ ປາງາຍ, ອັນ ແກີດ ຊູລ ເນົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR12_25","021_12_25","PRO","12","25","25","ກວາຍ ກາ ບິ ຕາ ລາເງ່ດ ກາແຍດ ຕາ ກຼຽມ, ນ່ະ ອັນ ໂດລ ເກຣີ່ງ ອຶນຕັອງ; ມາ ປັຣນາຍ ລາເມ່ນ ອໍ ຕະ ໂອນ ກວາຍ ແກີດ ຣໍ່ອ໌ ຣາງຶ່ຮ ຊັນຕຣຸ່ຮ ລ່ອມ. ");
INSERT INTO ncq_vpl VALUES ("PR12_26","021_12_26","PRO","12","26","26","ກວາຍ ຕານັ່ອງ ອໍ ເດີງ ເຢົ່າ ເປາະ ປໍ ຣານາ ປຍາຍ໌; ມາ ກວາຍ ຕາ ອໍ ຕະ ໂອນ ຈະ ອັນ ເບີມ ແກຼິ ຣານາ. ");
INSERT INTO ncq_vpl VALUES ("PR12_27","021_12_27","PRO","12","27","27","ກວາຍ ປາງາຍ ອາລັ່ຮ ອີ ຕະ ຈາ ເລີຍ ໄຊອ໌ ກາ ອັນ ອຶມປັນ, ມາ ກວາຍ ແທຣິງ ເບີນ ຕຽນ ວັ່ນ ຊາປັ່ນ ປຣະ. ");
INSERT INTO ncq_vpl VALUES ("PR12_28","021_12_28","PRO","12","28","28","ກວາຍ ຕາປູ່ນ ເງ່ ຕານັ່ອງ ອໍ ແກີດ ກົງ ອາມົ່ງ ດູ່ນ; ມາ ກວາຍ ຕາປູ່ນ ເງ່ ຕາ ອໍ ແກີດ ກູຈີດ ປິ່ດ ແດັດ ດຽລ. ");
INSERT INTO ncq_vpl VALUES ("PR13_1","021_13_1","PRO","13","1","1","ກອນ ກາ ຣາໄງ່ອ໌ ຣາລັ່ງ ຊາງັດ ປັຣນາຍ ອຶມປໍ່ ອັນ ຕຽຮ ອາຕີ; ມາ ກວາຍ ກາ ມັ່ກ ຍ່ອງ ຈະ ເບີມ, ອັນ ຕາ ແອອ໌ ເນົ່າ ຕາໄມຮ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR13_2","021_13_2","PRO","13","2","2","ກວາຍ ອໍ ເບີນ ຣັ່ບ ເກືາ ຍ່ອນ ແຕ ປັຣໄລຮ ປັຣນາຍ ອັນ ອໍ; ມາ ກວາຍ ຕາ ອໍ ຢໍອ໌ ອີ ຕະ ແອີງ ຣານະ ຊາອ໌ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("PR13_3","021_13_3","PRO","13","3","3","ກວາຍ ດັງ ກຍາອ໌ ແບອ໌ ອັນ ເບີມ, ລາ ອັນ ກຍາອ໌ ຣາງຶ່ຮ ອັນ ເຕ່; ກວາຍ ຕະ ອຶນຕີ ມາ ຕາ ເບີນ ຄຶ່ດ ອຶນໂຍ່ງ, ລາ ນ່ະ ອັນ ອາປິ່ດ ຈະ ອັນ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("PR13_4","021_13_4","PRO","13","4","4","ກວາຍ ອາລັ່ຮ ຕາ ດັງ ເບີນ ມັຮ ຣາມຶ່ຮ ອັນ ຢໍອ໌ ອີ ເບີນ; ມາ ກວາຍ ແທຣິງ, ໂດຍ ແຕີ່ອ໌ ລາລ່ະ ປຣະ ແຕີ່ອ໌ ລາລວຍ. ");
INSERT INTO ncq_vpl VALUES ("PR13_5","021_13_5","PRO","13","5","5","ກວາຍ ຕານັ່ອງ ອໍ ຊາອັຣ ປັຣນາຍ ອາໂລກ; ມາ ກວາຍ ກາ ຕາ ອໍ ຣາງຶ່ຮ ຕະ ຣານະ ໂອນ ແກີດ ກູມາລ ກະ ຕັງຮາງ. ");
INSERT INTO ncq_vpl VALUES ("PR13_6","021_13_6","PRO","13","6","6","ຣານະ ຕານັ່ອງ ອໍ ບັນ ກຍາອ໌ ກວາຍ ຕະ ປຍາຍ໌; ມາ ຣານະ ຕາ ອໍ ອາປິ່ດ ກວາຍ ຕະ ໂລ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("PR13_7","021_13_7","PRO","13","7","7","ເບີນ ກວາຍ ກາ ກາດີດ ແປັກໆ, ມາ ຕະ ນ່ະ ອັນ ຊຸ ເບີນ; ມາ ເບີນ ເຕ່ ກວາຍ ຊຸ ເບີນ ເຕີນ ປໍອ໌ ກາ ຕະ ນ່ະ ກວາຍ ກາດີດ. ");
INSERT INTO ncq_vpl VALUES ("PR13_8","021_13_8","PRO","13","8","8","ກວາຍ ຊຸ ເບີນ ເຕ່ອ໌ ໄທ ລັ່ຮ ແດີຍ ອາມົ່ງ ອັນ ແຕ ປຣະ; ມາ ກວາຍ ກາດີດ ຕາ ເບີນ ເນົ່າ ອີ ປາຕຸ່ຮ ປາຕັລ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR13_9","021_13_9","PRO","13","9","9","ກວາຍ ຕານັ່ອງ ອໍ ແກີດ ນ່ະ ຕາບອງ ປາເລືາງ ປັ່ງ ໂປ່ຍ໌; ມາ ກວາຍ ແຣັ່ງ ແກີດ ນ່ະ ຕາກຍາງ ກາ ລາລີວ ອີ ປັດ. ");
INSERT INTO ncq_vpl VALUES ("PR13_10","021_13_10","PRO","13","10","10","ຣານະ ໂອດ ອາແຕີ່ອ໌ ມັຮ ຣາໂລຍຮ ຣາແລັຮ ຊັອງ; ມາ ຄາອ໌ ຊາງັດ ປັຣນາຍ ຕຽຮ ດໍອ໌ ແກີດ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR13_11","021_13_11","PRO","13","11","11","ກວາຍ ກາ ເບີນ ມູ່ນມັ່ງ ລຳແບີ, ລາ ປິ່ດ ລຳແບີ ເຕ່; ມາ ກວາຍ ຊຸ ຍ່ອນ ອັນ ທຣັຮ ປາຮູຣ ຢູຣ ກູມິ່ລ, ລາ ອັນ ແກີດ ຊຸ ອາຊັອຮ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR13_12","021_13_12","PRO","13","12","12","ຄັນ ກວາຍ ແອີດ ອຶງກ່ອງ ງູງຸ່ ງູງູ່ລ ແຕ ມວຍ ຣາມຶ່ຮ ອຶນເຕົ່າ, ຣາງຶ່ຮ ຣາແຮີ ອັນ ແກີດ ລາແກັຮ; ມາ ຄັນ ຣາມຶ່ຮ ອັນ ອຶງກ່ອງ ລື່ ແຕີ່ອ໌, ຣາງຶ່ຮ ອັນ ຊັອງ ຣໍ່ອ໌ ບູຍ ລາແຮີຍ ລາແຕິ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("PR13_13","021_13_13","PRO","13","13","13","ຣາມຶ່ຮ ຕຸ່ຮ ກັ່ດ ແຕີ່ອ໌ ປໍ ກວາຍ ກາ ພູມາດ ປັຣນາຍ ຕຽຮ; ມາ ກວາຍ ກາ ຢຳ ປັຣນາຍ ຕາໄມຮ, ອັນ ຕາ ເບີນ ແຢັ່ຮ ອຶງກອຍ ທຣອຍ ອຶງໂກ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR13_14","021_13_14","PRO","13","14","14","ປັຣນາຍ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ອາຕີ ລາ ນ່ະ ປັຣໂລ່ຍ໌ ແດີອ໌ ໂອນ ກວາຍ ເບີນ ອາມົ່ງ, ດໍອ໌ ເຕ່ອ໌ ຈ່ອຍ ໂອນ ແວັດ ແຕ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("PR13_15","021_13_15","PRO","13","15","15","ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ, ລາ ເນົ່າ ຢຳນັ່ບ; ມາ ກວາຍ ຕາ ເບີນ ຕານັ່ອງ ຕາປຶ່ງ, ລາ ອັນ ແກີດ ກູຈີດ ປິ່ດ ແດັດ ດຽລ. ");
INSERT INTO ncq_vpl VALUES ("PR13_16","021_13_16","PRO","13","16","16","ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ຄຶ່ດ ເວືາຍ ແຕ ອັນ ຕະ; ມາ ກວາຍ ຊາກູລ ອາປັຮ ໂອນ ກວາຍ ການໍ່ອ໌ ເຮີມ ອັນ ເຈຍ ຊາກູລ. ");
INSERT INTO ncq_vpl VALUES ("PR13_17","021_13_17","PRO","13","17","17","ກວາຍ ອາແລ່ະ ເດີງ ປັຣນາຍ ປາເຣິຮ ກາ ມາລ່ຳ ມາລ່ອຍ, ລາ ອັນ ຕະ ຣາລຸຮ ຕຣໍ່ ຣາລໍ່ ວີ່ລ; ມາ ກວາຍ ປາເຣິຮ ປຍາຍ໌ ລາລື່, ລາ ນ່ະ ອັນ ເດີງ ອາແຕີ່ອ໌ ຣາມຶ່ຮ ອຽນ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR13_18","021_13_18","PRO","13","18","18","ກວາຍ ກາ ຕາ ແອອ໌ ເນົ່າ ກາໄຕ່ຮ ອາຕີ, ລື່ ອັນ ແກີດ ກາດີດ ກະ ກູມາລ ຕະ; ມາ ກວາຍ ອາແລ່ະ ຢຳ ອີດ ມັຮ ປັຣນາຍ ເນົ່າ ກາໄຕ່ຮ ອາຕີ, ລາ ອັນ ເບີນ ຊະເຢືາງ ປັຣເລືາງ ປາເນົາ. ");
INSERT INTO ncq_vpl VALUES ("PR13_19","021_13_19","PRO","13","19","19","ຄັນ ກວາຍ ເບີນ ມັຮ ຣາມຶ່ຮ ອັນ ຊັອງ ຢໍອ໌ ອີ ເບີນ, ລາ ອັນ ຊັອງ ຣໍ່ອ໌; ມາ ກວາຍ ຊາກູລ ຕາ ເກີ່ຍ ກູໄຣ່ຮ ຕັຮ ມັຮ ຣານະ ຕາ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR13_20","021_13_20","PRO","13","20","20","ກວາຍ ອາແລ່ະ ກາ ຣາແຕັດ ກະ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ, ກວາຍ ກັອຍ ແກີດ ຣາໄງ່ອ໌ ຣາລັ່ງ ເຕ່; ມາ ຄັນ ອັນ ຣາແຕັດ ກະ ກວາຍ ຊາກູລ, ລາ ອັນ ແກີດ ປິ່ດ ຕາແປດ ແທຣດ ຕາປູ່ນ. ");
INSERT INTO ncq_vpl VALUES ("PR13_21","021_13_21","PRO","13","21","21","ຣານະ ຕຸ່ຮ ກັ່ດ ປວາຍ ກວາຍ ໂລ່ຍຮ ກູ່ ຣາໄງ ກູ່ ຊາເດົາ; ມາ ກວາຍ ຕານັ່ອງ ອໍ ເບີນ ເກືາ ອໍ ກູ່ ຣາມຶ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("PR13_22","021_13_22","PRO","13","22","22","ກວາຍ ອໍ ດໍອ໌ ມັຮ ມູ່ນ ອັນ ໂອນ ກອນ ອາເຈົາ; ມາ ມັຮ ມູ່ນ ກວາຍ ແຣັ່ງ, ລື່ ແກີດ ມູ່ນ ກວາຍ ຕານັ່ອງ ອໍ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR13_23","021_13_23","PRO","13","23","23","ອຶມປຶ່ ປຣຽດ ອໍ ທຣໍ ບອງ ຕຶ່ງ ເນືາ ໄທຣ ກວາຍ ກາດີດ, ມາ ກວາຍ ແຣັ່ງ ໂລ່ບ ອຶນແຍ່ະ ຊັຣນົຮ ກວາຍ ກາດີດ ຈົຮ. ");
INSERT INTO ncq_vpl VALUES ("PR13_24","021_13_24","PRO","13","24","24","ກວາຍ ອາແລ່ະ ມາ ຕາ ເບີນ ປາຕັບ ປານໍ ປາຕໍ ປາກິ່ຣ ກອນ, ລາ ບັອງ ອັນ ຊາອັຣ ກອນ; ມາ ຄັນ ອັນ ອາໂຢ່ະ ກອນ ອັນ, ອັນ ອຶງເຄາະ ກູດຸ ອາຣຍານ. ");
INSERT INTO ncq_vpl VALUES ("PR13_25","021_13_25","PRO","13","25","25","ກວາຍ ຕານັ່ອງ ອໍ ໂດຍ ພໍ ຈາ ອາກາ ພໍໍ ບຸຮ; ມາ ກວາຍ ແຣັ່ງ ແກີດ ຕຸ່ຮ ກູປາຍຮ ມາເຍືາຍຮ ໂດຍ ເລືອຍໆ. ");
INSERT INTO ncq_vpl VALUES ("PR14_1","021_14_1","PRO","14","1","1","ມັນແຊມ ຣາໄງ່ອ໌ ຣາລັ່ງ ເຕ່ອ໌ ແກີດ ດຸງ ແກີດ ຊູ; ມາ ມັນແຊມ ຊາກູລ ຕະ ໂອນ ດຸງຊູ ອັນ ເບີມ ແກີດ ປິ່ດ ປວາດ. ");
INSERT INTO ncq_vpl VALUES ("PR14_2","021_14_2","PRO","14","2","2","ກວາຍ ຕານັ່ອງ ຕາປຶ່ງ ຢຳນັ່ບ ເຢືາງ ເຈົາຣາຊີ; ມາ ກວາຍ ໂກ່ະ ກາດີ ກີ່ ກາດູດ ພູມາດ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("PR14_3","021_14_3","PRO","14","3","3","ປັຣນາຍ ໂອດ ແຕ ກວາຍ ຊາກູລ ແກີດ ນ່ະ ກ່ອນ ວັ່ດ ຈະ ອັນ ເບີມ; ມາ ປັຣນາຍ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ກຸ່ມກຍາອ໌ ເລືອຍໆ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR14_4","021_14_4","PRO","14","4","4","ຄັນ ແອິ ຕາຣຍາອ໌ ໄທ ເນືາ, ຊູ ທຣໍ ແກີດ ຊານັອຮ ເມືາດ; ມາ ຄັນ ອີ ເບີນ ທຣໍ ປັ່ນ ຊູ ລາ ອຶງເຄາະ ເບີນ ຕາຣຍາອ໌ ໄທ ເນືາ. ");
INSERT INTO ncq_vpl VALUES ("PR14_5","021_14_5","PRO","14","5","5","ພາເຍືານ ກາ ເນົ່າ ເຕ່ອ໌ ຢຳ, ລາ ກວາຍ ກາ ປາຍ ແອີງ ປັຣນາຍ ປຍາຍ໌; ມາ ພາເຍືານ ກາ ເນົ່າ ຕາ ເຕ່ອ໌ ນັ່ບ, ລາ ກວາຍ ກາ ປາຍ ແອີງ ປັຣນາຍ ອາໂລກ. ");
INSERT INTO ncq_vpl VALUES ("PR14_6","021_14_6","PRO","14","6","6","ກວາຍ ກາ ມັ່ກ ພາມາດ ອຶມປຶ່ ໄລ່ ຈໍ່ອ໌ ຣາໄງ່ອ໌ ຣາລັ່ງ, ລາ ຕາ ເກີ່ຍ ຣາມົຮ; ມາ ກວາຍ ກາ ຕາໄບອ໌ ຣຍານ ໄຈ ລາລື່ ດັງ. ");
INSERT INTO ncq_vpl VALUES ("PR14_7","021_14_7","PRO","14","7","7","ອຶງເຄາະ ແອີດ ເຢີ່ງ ແຕ ກວາຍ ຊາກູລ, ຍ່ອນ ອັນ ຕາ ເຕ່ອ໌ ອາຣຍານ ໄມ່ ມວຍ ຣາມຶ່ຮ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR14_8","021_14_8","PRO","14","8","8","ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ເຕ່ອ໌ ຣຽຮ ມັຮ ເງ່ ປຍາຍ໌ ອີ ຕະ ຣານະ; ມາ ກວາຍ ຊາກູລ ອາລັ່ອຮ ແອີງ ເງ່ ອາໂລກ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("PR14_9","021_14_9","PRO","14","9","9","ກວາຍ ຊາກູລ ຕາ ເບີນ ຣາບູລ ອຶນເຕົ່າ ອັນ ຕະ ຣານະ ໂລ່ຍຮ; ມາ ກວາຍ ຕານັ່ອງ ອໍ, ອັນ ຕະ ຣໍ່ອ໌ ຣາງຶ່ຮ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("PR14_10","021_14_10","PRO","14","10","10","ຕຶ່ງ ຣາງຶ່ຮ ກູ່ ນະ ກວາຍ ເບີນ ຣາມຶ່ຮ ອຶນຕັງ ອາແຮັຣ ກະ ເບີນ ຣາມຶ່ຮ ຣໍ່ອ໌; ມາ ຕາ ເບີນ ເນົ່າ ການໍ່ອ໌ ເຕ່ອ໌ ຣາຈຸງ ແຕ ມັຮ ຣາມຶ່ຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR14_11","021_14_11","PRO","14","11","11","ດຸງ ກວາຍ ແຣັ່ງ ແກີດ ປິ່ດ ນ່ະ ຣາໄບຮ ກັລໄດຮ ນ່ະ ມັນຈິ່ລ; ມາ ດຸງ ກວາຍ ຕານັ່ອງ ອໍ ແກີດ ຊຸ ເບີນ ເຕີນ ປໍອ໌ ອໍ ອາຊັອຮ. ");
INSERT INTO ncq_vpl VALUES ("PR14_12","021_14_12","PRO","14","12","12","ເບີນ ມວຍ ຣານາ ກວາຍ ຄຶ່ດ ປາຍ ປຍາຍ໌, ມາ ແຕີ່ອ໌ ປັຣຊົດ ຣານາ ກັອຍ ເດີງ ປໍ ອຶນຕຸ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("PR14_13","021_14_13","PRO","14","13","13","ອຶມປຶ່ ໄຮ ເຮີມ ກວາຍ ກາຈັງ, ມາ ໄຮ ຕາ ດັງ ປຍາຍ໌ ຕຶ່ງ ຣາງຶ່ຮ ອັນ ຊັອງ ງໍ່ ລາ ເບີນ; ກະ ພໍກາ ແວັດ ຣໍ່ອ໌ ບູຍ, ເຈີ່ ແຕີ່ອ໌ ງໍ່ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR14_14","021_14_14","PRO","14","14","14","ກວາຍ ແຣັ່ງ, ລື່ ອັນ ເບີນ ຣັ່ບ ລັ່ຮ ເກືາ ແຣັ່ງ; ມາ ກວາຍ ອໍ ເບີນ ຣັ່ບ ລັ່ຮ ເກືາ ອໍ, ຍ່ອນ ແຕ ຣານະ ອໍ ກາ ອັນ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("PR14_15","021_14_15","PRO","14","15","15","ກວາຍ ຊາກູລ ຊັອງ ເນົ່າ ປາຍ ອຶນເຕົ່າ, ລາ ອັນ ຊາງັດ ອຶນແຍ່ະ; ມາ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ຄຶ່ດ ອຶນໂຍ່ງ ເວືາຍ ແຕ ອັນ ຕາຢັຮ. ");
INSERT INTO ncq_vpl VALUES ("PR14_16","021_14_16","PRO","14","16","16","ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ຢຳນັ່ບ ເຢືາງ ເຈົາຣາຊີ, ກະ ອັນ ວຍາຣ ຕັຮ ແຕ ຣານະ ຕາ ອໍ; ມາ ກວາຍ ຊາກູລ ຕາ ເບີນ ຕາຕ່ອຍ໌ ໂອນ ກຣັ່ກ, ກະ ອັນ ກຸນເຕົາ ລາລື່ ອີ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("PR14_17","021_14_17","PRO","14","17","17","ຣານະ ກວາຍ ກຸນເຕົາ ເຮາະ ຕະ ລາ ຣານະ ຊາກູລ; ກະ ເນົ່າ ຊາອັຣ ກວາຍ ຕະ ປຼາ. ");
INSERT INTO ncq_vpl VALUES ("PR14_18","021_14_18","PRO","14","18","18","ກວາຍ ຊາກູລ ຣັ່ບ ເກືາ ແຕ ຣານະ ປຼຸງ; ມາ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ຣັ່ບ ລັ່ຮ ເກືາ ແກີດ ດັງ ລາລື່ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR14_19","021_14_19","PRO","14","19","19","ປັຣແນີ ມັນເຕຣືາ ກວາຍ ແຣັ່ງ ລື່ ຄຣາບ ກູກຸຮ ກວາຍ ອໍ; ໄລ່ ແຕີ່ອ໌ ປໍ ງັ່ຮ ຕົ່ງ ດຸງ ກວາຍ ຕານັ່ອງ ອໍ, ເຈີ່ ແຊອ໌ ອັນ ຈ່ອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR14_20","021_14_20","PRO","14","20","20","ກວາຍ ກາດີດ ເນົ່າ ຕູນ ມານັ່ຮ, ກວາຍ ອາລັ່ຮ ເນົ່າ ຕູນ ຕູຕວຍ໌; ມາ ກວາຍ ຊຸ, ເບຼີ ເນົ່າ ອີ ອຶງແຮງ, ອຶນຊີ່ງ ເນົ່າ ອີ ຢູບ. ");
INSERT INTO ncq_vpl VALUES ("PR14_21","021_14_21","PRO","14","21","21","ຄັນ ກວາຍ ອາແລ່ະ ຢໍອ໌ ອີ ແອີດ ຣໍ່ອ໌ ບູຍ, ອຶງເຄາະ ອັນ ອາໂຢ່ະ ຕະ ມັຮ ກວາຍ ກາດີດ: ມາ ກວາຍ ອາແລ່ະ ພູມາດ ກວາຍ ການໍ່ອ໌, ກວາຍ ກັອຍ ຕະ ໂລ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("PR14_22","021_14_22","PRO","14","22","22","ກວາຍ ອາລັ່ອຮ ເງ່ ອີ ຕະ ຣານະ ຕາ ອໍ, ລື່ ອັນ ແກຼິ ຣານາ; ມາ ກວາຍ ກາ ອາລັ່ອຮ ເງ່ ອີ ຕະ ຣານະ ອໍ, ເນົ່າ ອາໂຢ່ະ ລັ່ຮ ອັນ ກະ ຕະ ຕານັ່ອງ ຕາປຶ່ງ ໂຈະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR14_23","021_14_23","PRO","14","23","23","ກວາຍ ແທຣິງ ເບີນ ໂດຍ ຕາ ຣາລໍ່ ທຣໍ ຕາ ຣາລິ່ຮ; ມາ ກວາຍ ປາໂລງ ບີ່ອ໌ ປັຣນາຍ ປາຍ ບີ່ອ໌ ຊັນຕອຍ໌, ແກີດ ຕຸ່ຮ ກາດີດ. ");
INSERT INTO ncq_vpl VALUES ("PR14_24","021_14_24","PRO","14","24","24","ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ເບີນ ຣັ່ບ ມັຮ ມູ່ນມັ່ງ ຊັງ ຊານາ, ມາ ກວາຍ ຊາກູລ ຣັ່ບ ລັ່ຮ ເກືາ ຕາປູ່ນ ຣານະ ຊາກູລ ກາ ໄລ່ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("PR14_25","021_14_25","PRO","14","25","25","ພາເຍືານ ກາ ຕະ ອຶນຕີ ປຍາຍ໌, ລາ ອັນ ຈ່ອຍ ມັຮ ກວາຍ ໂອນ ເບີນ ອາມົ່ງ; ມາ ກວາຍ ອາຕີ ຕາ ເບີນ ຕານັ່ອງ, ອັນ ລາ ກວາຍ ຈິ ເຢົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR14_26","021_14_26","PRO","14","26","26","ກວາຍ ຢຳນັ່ບ ເຢືາງ ເຈົາຣາຊີ ແອີດ ກຼີດ ກຼອດ ຈອດ ອໍໍ, ກະ ກອນ ອາເຈົາ ອັນ ຕາ ເບີນ ປິ່ດ ຣາແປີບ ແຢີບ ຣາເວືາຍ. ");
INSERT INTO ncq_vpl VALUES ("PR14_27","021_14_27","PRO","14","27","27","ຢຳນັ່ບ ເຢືາງ ເຈົາຣາຊີ ລາ ນ່ະ ປັຣໂລ່ຍ໌ ແດີອ໌ ໂອນ ກວາຍ ເບີນ ອາມົ່ງ, ດໍອ໌ ເຕ່ອ໌ ຈ່ອຍ ໂອນ ແວັດ ແຕ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("PR14_28","021_14_28","PRO","14","28","28","ເຕືາວ ປັຣເຍືາ ກາ ເບີນ ກຼຶ່ງ ກອນແຊມ, ອັນ ແກີດ ຊະເຢືາງ ປັຣເລືາງ ປາເນົາ; ມາ ເຕືາວ ປັຣເຍືາ ກາ ແອິ ກອນແຊມ, ອັນ ແອິ ອຳນາດ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR14_29","021_14_29","PRO","14","29","29","ຣາໄງ່ອ໌ ລາລື່ ກວາຍ ກາ ຈາ ອຶງກ່ອຍ ນ່ອຍ໌ ງ່ອຍ໌ ອຶງກ່ອຍ ອາຕີ; ມາ ກວາຍ ມິ່ດ ອາອຸ່ງ ປຸ່ງ ລັງໄກຮ ລາ ກວາຍ ຊາກູລ. ");
INSERT INTO ncq_vpl VALUES ("PR14_30","021_14_30","PRO","14","30","30","ເບີນ ຣາງຶ່ຮ ອຽນ ອໍ ຕະ ໂອນ ຈະຈັ່ນ ແກີດ ບັນ ເຣ່ງ; ມາ ຣາງຶ່ຮ ຊັຣແມງ ກູມິ່ ຕະ ໂອນ ຈະຈັ່ນ ແກີດ ຊາຣີ່ ຊາກໍ່. ");
INSERT INTO ncq_vpl VALUES ("PR14_31","021_14_31","PRO","14","31","31","ກວາຍ ອາແລ່ະ ຕະ ຕຸ່ຮ ກວາຍ ກາດີດ, ລາ ມູເຈິງ ອັນ ພູມາດ ເຢືາງ ກາ ແຕງ ກວາຍ ກັອຍ; ມາ ກວາຍ ອາແລ່ະ ກາ ອາໂຢ່ະ ຕະ ກວາຍ ແອິ ຊັຣນາ ເລືາ ອຶນແຕີດ, ລາ ອັນ ຢຳນັ່ບ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("PR14_32","021_14_32","PRO","14","32","32","ພໍກາ ອາກັນ ກູຈີດ ປິ່ດ ແຕີ່ອ໌, ກວາຍ ແຣັ່ງ ແກີດ ຊາແຣັຮ ຊາຣວຍ ຍ່ອນ ໄລ່ ຕະ ຕາມມັຮ; ມາ ກວາຍ ຕານັ່ອງ ອໍ ເບີນ ອຶນຕຸ ອຽນ ອໍ ຍ່ອນ ໄລ່ ຕະ ຕານັ່ອງ ຕາປຶ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR14_33","021_14_33","PRO","14","33","33","ຣາໄງ່ອ໌ ຣາລັ່ງ ດັຮ ຕຶ່ງ ຣາງຶ່ຮ ກວາຍ ດັງ ຊາອຶ່ຍ; ມາ ອາກັນ ຣາໄງ່ອ໌ ຣາລັ່ງ ຕາ ເບີນ ດັຮ ຕຶ່ງ ຣາງຶ່ຮ ກວາຍ ກາ ຊາກູລ. ");
INSERT INTO ncq_vpl VALUES ("PR14_34","021_14_34","PRO","14","34","34","ກວາຍ ຕານັ່ອງ ອໍ ຕະ ໂອນ ກຣວາງ ແກີດ ປື່ດ ອາຊັອຮ; ມາ ກວາຍ ໂລ່ຍຮ ຕະ ໂອນ ກຣວາງ ໄລ່ ແກີດ ກູມາລ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("PR14_35","021_14_35","PRO","14","35","35","ເຕືາວ ປັຣເຍືາ ຊັອງ ຣໍ່ອ໌ ຣາງຶ່ຮ ໂຈະ ມັຮ ກວາຍ ຕະ ຣານະ ອັນ ກາ ຣາໄງ່ອ໌ ຣາລັ່ງ; ມາ ເຕືາວ ປັຣເຍືາ ຊັອງ ອຶງຄື່ນ ໂຈະ ມັຮ ກວາຍ ກາ ຕະ ໂອນ ອັນ ແກີດ ກູມາລ. ");
INSERT INTO ncq_vpl VALUES ("PR15_1","021_15_1","PRO","15","1","1","ປັຣນາຍ ລາວິ່ ນ່ະ ດາຍ ລາເວືາຍ ນ່ະ ແດີອ໌ ຕະ ໂອນ ຣາງຶ່ຮ ອຶງຄື່ນ ແກີດ ປຣາຍ; ມາ ຊັນຕອຍ໌ ຣາລັ່ດ ຣາລວາອ໌ ຕະ ໂອນ ຣາງຶ່ຮ ແກີດ ໂຍ່ບ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR15_2","021_15_2","PRO","15","2","2","ແບອ໌ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ຕຽຮ ຕະ ໂອນ ໄຮ ຊັອງ ຣໍ່ອ໌ ກູຕູຣ; ມາ ແບອ໌ ກວາຍ ຊາກູລ ປາຍ ລາແບະ ລາບື່ບ ແອີງ ປັຣນາຍ ຊາກູລ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("PR15_3","021_15_3","PRO","15","3","3","ເຢືາງ ເຈົາຣາຊີ ເຮີມ ອຶນແຍ່ະ ກູ່ ຣານະ; ອັນ ຕາຕ່ອຍ໌ ເນ່ ເລືອຍໆ ມັຮ ຣານະ ກວາຍ ອໍ ກະ ກວາຍ ຕາ ອໍ ດຸ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("PR15_4","021_15_4","PRO","15","4","4","ປັຣນາຍ ລາເມ່ນ ອໍ ແກີດ ນ່ະ ອາລ່ອງ ໂອນ ເບີນ ອາມົ່ງ; ມາ ປັຣນາຍ ອຶນຈິກ ອຶນຕັງ ຕະ ໂອນ ແກີດ ຕິ່ ມິ່ດ ປັຣອວຍ໌. ");
INSERT INTO ncq_vpl VALUES ("PR15_5","021_15_5","PRO","15","5","5","ກວາຍ ຊາກູລ ພາມາດ ປັຣນາຍ ອຶມປໍ່ ຕຽຮ; ມາ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ຊາງັດ ກະ ຕະ ຕາປູ່ນ. ");
INSERT INTO ncq_vpl VALUES ("PR15_6","021_15_6","PRO","15","6","6","ຕຶ່ງ ດຸງ ກວາຍ ຕານັ່ອງ ອໍ ເບີນ ແອີງ ມູ່ນມັ່ງ ຊັງ ຊານາ; ມາ ມູ່ນມັ່ງ ອຶນເຕົ່າ ກາ ກວາຍ ເຮາະ ເບີນ ແຮງ ປິ່ດ ຕາແປດ ແທຣດ ຕາປູ່ນ. ");
INSERT INTO ncq_vpl VALUES ("PR15_7","021_15_7","PRO","15","7","7","ແບອ໌ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ຕຽຮ ໂອນ ກວາຍ ດັງ ເງ່; ມາ ກວາຍ ຊາກູລ ຕາ ເບີນ ຕະ ນ່ະກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR15_8","021_15_8","PRO","15","8","8","ແຕີ່ອ໌ ກວາຍ ຕານັ່ອງ ອໍ ເກົາແຊອ໌, ລາ ເຢືາງ ເຈົາຣາຊີ ຊັອງ ຣໍ່ອ໌; ມາ ອັນ ຊາອັຣ ມັຮ ເກຣີ່ງ ມ່ອບ ຊາງ ແຕ ກວາຍ ແຣັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR15_9","021_15_9","PRO","15","9","9","ເຢືາງ ເຈົາຣາຊີ ຊາອັຣ ຣານະ ກວາຍ ຕາ ອໍ ຕະ; ມາ ອັນ ອາໂຢ່ະ ກວາຍ ຕະ ຣານະ ປຍາຍ໌. ");
INSERT INTO ncq_vpl VALUES ("PR15_10","021_15_10","PRO","15","10","10","ກວາຍ ອາແລ່ະ ມາ ຕັຮ ຣານາ ຕານັ່ອງ ອໍ, ໂຕ່ດ ອັນ ອຶນຕັອງ ລາລື່; ກວາຍ ອາແລ່ະ ມາ ພາມາດ ຊັນຕອຍ໌ ກາໄຕ່ຮ ອາຕີ, ລາ ອັນ ກູຈີດ ປິ່ດ ແດັດ ດຽລ. ");
INSERT INTO ncq_vpl VALUES ("PR15_11","021_15_11","PRO","15","11","11","ເຢືາງ ເຈົາຣາຊີ ດັງ ອຶນແຍ່ະ ກູ່ ຣານະ ຕຶ່ງ ອຶນຕຸ ກວາຍ ກູຈີດ ແອີດ; ກາເລີຍ ແຕ ກັອຍ ແອັນ, ອັນ ດັງ ກູ່ ຣາມຶ່ຮ ຣາງຶ່ຮ ກວາຍ ຄຶ່ດ. ");
INSERT INTO ncq_vpl VALUES ("PR15_12","021_15_12","PRO","15","12","12","ກວາຍ ກາ ມັ່ກ ຍ່ອງ ຈະ ເບີມ, ອັນ ຕາ ແອອ໌ ເນົ່າ ຕາໄມຮ; ກະ ອັນ ຕາ ມັ່ກ ຊັຣຮົງ ກະ ກວາຍ ກາ ດັງ ກາເລີຍ ແຕ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR15_13","021_15_13","PRO","15","13","13","ຣາງຶ່ຮ ຣໍ່ອ໌ ຕະ ໂອນ ມັ່ດ ມຸ່ຮ ປັ່ງ ໂປ່ຍ໌, ມາ ຣາງຶ່ຮ ງໍ່ ຕະ ໂອນ ມັ່ດ ມຸ່ຮ ແກີດ ຊູບ ອາເຕຣົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR15_14","021_15_14","PRO","15","14","14","ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ຢໍອ໌ ລາລື່ ອີ ຣຍານ; ມາ ກວາຍ ຊາກູລ ມັ່ກ ແອີງ ຣານະ ມາລ່ຳ ມາລ່ອຍ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("PR15_15","021_15_15","PRO","15","15","15","ກູ່ ຣາໄງ ກວາຍ ຕຸ່ຮ ບາບ ຈາ ໂດຍ ມູ ຣາໂມ່ດ ອາຍຸ່ ອາກັນ ເກຣ່າະ ຈາ ໂດຍ ມູ ຣາເມ່າະ ອາຍຸ່ ອາກັນ ກຣຍາດ; ມາ ກວາຍ ກາ ເບີນ ຣາງຶ່ຮ ຣາແຮີ ຣໍ່ອ໌, ອັນ ຕະ ກູ່ ຣາໄງ ໂອນ ແກີດ ຣໍ່ອ໌ ບູຍ. ");
INSERT INTO ncq_vpl VALUES ("PR15_16","021_15_16","PRO","15","16","16","ຄາອ໌ ແກີດ ກວາຍ ແອິ ຊັຣນາ ເລືາ ອຶນແຕີດ ມາ ຢຳນັ່ບ ເຢືາງ ເຈົາຣາຊີ, ແຕ ແກີດ ກວາຍ ຊຸ ເບີນ ເຕີນ ປໍອ໌ ມາ ອຸກອັງ ກາຈັງ ຕາ ລັ່ອຮ. ");
INSERT INTO ncq_vpl VALUES ("PR15_17","021_15_17","PRO","15","17","17","ຄາອ໌ ຈາ ບັດ ບາຍ ມັນຕຸ ກະ ກວາຍ ມານະ ອາໂຢ່ະ ມານະ, ແຕ ຈາ ໄຊອ໌ ຕາແກງ ປຼຶ່ມ ກະ ກວາຍ ກາ ມານະ ຊາອັຣ ມານະ. ");
INSERT INTO ncq_vpl VALUES ("PR15_18","021_15_18","PRO","15","18","18","ກວາຍ ກາ ຕີອ໌ ຣາງິ່ລ ຈິ່ລ ກູແຕອ໌ ຕະ ໂອນ ແກີດ ຣາໂລຍຮ; ມາ ກວາຍ ກາ ເບີນ ຣາງຶ່ຮ ລາວິ່ ນ່ະ ດາຍ ລາເວືາຍ ນ່ະ ແດີອ໌ ອາແຕີ່ອ໌ ຣາມຶ່ຮ ອຽນ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR15_19","021_15_19","PRO","15","19","19","ກວາຍ ປາງາຍ ຣຳແປັຮ ຣາມົຮ ຕຸ່ຮ ກັ່ດ ຊົດ ແດີຍ ອາມົ່ງ ອັນ; ມາ ກວາຍ ຕານັ່ອງ ຕາປຶ່ງ ຕະ ເປາະ ຕຶ່ງ ຣານາ ຊຽລ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR15_20","021_15_20","PRO","15","20","20","ກອນ ຣາໄງ່ອ໌ ຣາລັ່ງ ຕະ ໂອນ ອຶມເປ່ອ໌ ອຶມປໍ່ ຣໍ່ອ໌ ຣາງຶ່ຮ ຊັນຕຣຸ່ຮ ລ່ອມ; ມາ ກອນ ຊາກູລ ປາຍ ໂບຼດ ໂຊດ ບຼັລ. ");
INSERT INTO ncq_vpl VALUES ("PR15_21","021_15_21","PRO","15","21","21","ກວາຍ ຊາກູລ ຊັອງ ຣໍ່ອ໌ ຕຶ່ງ ຣານະ ຊາກູລ ອັນ; ມາ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ຕະ ເລືອຍໆ ຣານະ ປຍາຍ໌. ");
INSERT INTO ncq_vpl VALUES ("PR15_22","021_15_22","PRO","15","22","22","ຄັນ ແອິ ກວາຍ ຊັຣຮົງ, ມັຮ ເງ່ ເນົ່າ ອາລັ່ອຮ ຕາ ເບີນ ແກີດ ອຶນເຕົ່າ; ມາ ຄັນ ເບີນ ກຼຶ່ງ ກວາຍ ຕຽຮ, ມັຮ ເງ່ ອາລັ່ອຮ ກັອຍ ລື່ ຕະ ແກີດ ແປີດ ແຮີຍ. ");
INSERT INTO ncq_vpl VALUES ("PR15_23","021_15_23","PRO","15","23","23","ກວາຍ ຕາແອີຍ ປຍາຍ໌ ຣານາ ກະ ປຍາຍ໌ ປາເນ່ນ, ກວາຍ ກັອຍ ຊັອງ ຣໍ່ອ໌ ບູຍ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR15_24","021_15_24","PRO","15","24","24","ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ເປາະ ຣານາ ຊັອຮ ປໍ ອຶນຕຸ ອາມົ່ງ, ອັນ ເຕ່ອ໌ ວຍາຣ ແຕ ຣານາ ເປາະ ອາແຊງ ປໍ ອຶນຕຸ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("PR15_25","021_15_25","PRO","15","25","25","ເຢືາງ ເຈົາຣາຊີ ອີ ຕາລຸຮ ດຸງ ກວາຍ ກາ ອາຊັອຮ ຈະ; ມາ ອັນ ກຍາອ໌ ຣາລັ່ນ ກູແຕອ໌ ອາກັນ ກູມາຍ. ");
INSERT INTO ncq_vpl VALUES ("PR15_26","021_15_26","PRO","15","26","26","ເຢືາງ ເຈົາຣາຊີ ຊາອັຣ ມັຮ ຣາງຶ່ຮ ກວາຍ ແຣັ່ງ ຄຶ່ດ; ມາ ອັນ ຊັອງ ຣໍ່ອ໌ ແຕ ຊັນຕອຍ໌ ກວາຍ ເບີນ ຣາງຶ່ຮ ບຣັຮ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR15_27","021_15_27","PRO","15","27","27","ກວາຍ ຢໍອ໌ ອີ ແກີດ ຊຸ ໄຈ ມາ ຕາ ເບີນ ຕະ ປຍາຍ໌ ຣານາ, ລາ ອັນ ອາແຕີ່ອ໌ ຣາມຶ່ຮ ຕຸ່ຮ ກັ່ດ ປໍ ດຸງຊູ ອັນ; ມາ ກວາຍ ອາແລ່ະ ຕາ ເບີນ ຣັ່ບ ປຣະ ເນົ່າ ບຸ່ນ, ອັນ ແກີດ ກົງ ອາມົ່ງ ດູ່ນ. ");
INSERT INTO ncq_vpl VALUES ("PR15_28","021_15_28","PRO","15","28","28","ກວາຍ ຕານັ່ອງ ອໍ ຄຶ່ດ ເວືາຍ ນານ່ະ ອັນ ອີ ຕາແອີຍ; ມາ ກວາຍ ຕາ ອໍ ຕາແອີຍ ແອີງ ປັຣນາຍ ກາດັຮ ອາເລືາ ກາດາ ອາຮໍ. ");
INSERT INTO ncq_vpl VALUES ("PR15_29","021_15_29","PRO","15","29","29","ເຢືາງ ເຈົາຣາຊີ ແອີດ ເຢີ່ງ ແຕ ກວາຍ ຕາ ອໍ; ມາ ອັນ ຊາງັດ ປັຣນາຍ ກວາຍ ຕານັ່ອງ ອໍ ເກົາແຊອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR15_30","021_15_30","PRO","15","30","30","ມັ່ດ ມຸ່ຮ ປັ່ງ ໂປ່ຍ໌ ຕະ ໂອນ ກວາຍ ຊັອງ ຣໍ່ອ໌, ກະ ຊັອງ ຮານ ອໍ ຕະ ໂອນ ຣາງຶ່ຮ ຣໍ່ອ໌ ນ່ະ ຄູຍ ບູຍ ນ່ະ ເກ່ນ. ");
INSERT INTO ncq_vpl VALUES ("PR15_31","021_15_31","PRO","15","31","31","ກວາຍ ອາແລ່ະ ມາ ຊາງັດ ແຕີ່ອ໌ ເນົ່າ ກາໄຕ່ຮ ອາຕີ, ເຈີ່ ອັນ ແກີດ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR15_32","021_15_32","PRO","15","32","32","ກວາຍ ອາແລ່ະ ມາ ຕາ ເບີນ ຊາງັດ ປັຣນາຍ ເນົ່າ ກາໄຕ່ຮ ອາຕີ, ກວາຍ ກັອຍ ຕາ ເບີນ ປາຊິ ແດີຍ ອາມົ່ງ ອັນ ເບີມ; ມາ ກວາຍ ອາແລ່ະ ຊາງັດ ປັຣນາຍ ເນົ່າ ຕຽຮ, ກວາຍ ກັອຍ ແກີດ ຣາໄງ່ອ໌ ຣາລັ່ງ ອາຊັອຮ. ");
INSERT INTO ncq_vpl VALUES ("PR15_33","021_15_33","PRO","15","33","33","ຢຳນັ່ບ ເຢືາງ ເຈົາຣາຊີ, ລາ ອາຣຍານ ໂອນ ແກີດ ຣາໄງ່ອ໌ ຣາລັ່ງ; ແອີງ ກວາຍ ອາແຊງ ຈະ ເຕ່ອ໌ ເບີນ ຊະເຢືາງ ປັຣເລືາງ ປາເນົາ. ");
INSERT INTO ncq_vpl VALUES ("PR16_1","021_16_1","PRO","16","1","1","ມັຮ ກວາຍ ດຸ ອາລັ່ອຮ ເງ່; ມາ ກູ່ ປັຣນາຍ ອຶງເຄາະ ເຢືາງ ເຈົາຣາຊີ ປຣ່ອມ ແຕ ເຕ່ອ໌ ແກີດ. ");
INSERT INTO ncq_vpl VALUES ("PR16_2","021_16_2","PRO","16","2","2","ມັຮ ກວາຍ ຄຶ່ດ ກູ່ ຣານະ ໄລ່ ຕະ ລາ ປຍາຍ໌; ມາ ເຢືາງ ເຈົາຣາຊີ ດັງ ກູ່ ຣາມຶ່ຮ ຕຶ່ງ ຣາງຶ່ຮ ຣາແຮີ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("PR16_3","021_16_3","PRO","16","3","3","ມັຮ ຣານະ ໄມ່ ອີ ຕະ, ອຶງເຄາະ ໄມ່ ມ່ອບ ໂອນ ເຢືາງ ເຈົາຣາຊີ, ເຈີ່ ກູ່ ຣານະ ກັອຍ ລື່ ຕະ ແກີດ ແປີດ ແຮີຍ. ");
INSERT INTO ncq_vpl VALUES ("PR16_4","021_16_4","PRO","16","4","4","ກູ່ ຣານະ ເຢືາງ ເຈົາຣາຊີ ຕະ ລາ ອັນ ເບີນ ເງ່ ເຈີ່; ດິ່ຮ ອາກັນ ເກຣ່າະ ກຣຍາດ ລາ ອັນ ກຽມ ດໍອ໌ ໂອນ ກວາຍ ແຣັ່ງ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("PR16_5","021_16_5","PRO","16","5","5","ເຢືາງ ເຈົາຣາຊີ ຊາອັຣ ມັຮ ກວາຍ ໂອດ ອົງ; ປຍາຍ໌ ລາລື່ ໄລ່ ຕາ ເຕ່ອ໌ ແວັດ ແຕ ອັນ ຕະ ໂຕ່ດ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("PR16_6","021_16_6","PRO","16","6","6","ຄັນ ກວາຍ ຕະ ຕານັ່ອງ ຕາປຶ່ງ ກະ ອາໂຢ່ະ ເຢືາງ ເຈົາຣາຊີ, ລື່ ເຢືາງ ເຈົາຣາຊີ ຕັຮ ໂລ່ຍຮ ອັນ; ຄັນ ກວາຍ ອາແລ່ະ ຢຳນັ່ບ ເຢືາງ ເຈົາຣາຊີ, ກວາຍ ກັອຍ ເຕ່ອ໌ ວຍາຣ ແວັດ ແຕ ມັຮ ຣານະ ຕາ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR16_7","021_16_7","PRO","16","7","7","ແຕີ່ອ໌ ກວາຍ ອາແລ່ະ ຕະ ໂອນ ເຢືາງ ເຈົາຣາຊີ ຊັອງ ຣໍ່ອ໌ ຣາງຶ່ຮ; ອຶມປຶ່ ກວາຍ ກາ ດໍອ໌ ມິ່ດ ຊາກິ່ດ ຣ່ອຍ໌, ລາ ເຢືາງ ເຈົາຣາຊີ ຕະ ໂອນ ແກີດ ຣາຕອຍ ລັ່ຮ ກະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR16_8","021_16_8","PRO","16","8","8","ຄາອ໌ ເບີນ ປຣະ ບີ່ອ໌ ມາ ຕະ ຕານັ່ອງ ຕາປຶ່ງ ອໍ, ແຕ ເບີນ ປຣະ ຊາອຶ່ຍ ມາ ກຸມປູ່ຣ ກູເວືາດ ໂລ່ບ ເລືອຍໆ ກວາຍ ການໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR16_9","021_16_9","PRO","16","9","9","ກວາຍ ດຸ ອາລັ່ອຮ ມັຮ ເງ່; ມາ ແອີງ ເຢືາງ ເຈົາຣາຊີ ແຕິ່ ອາໂຢ່ງ ຣານະ ອັນ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("PR16_10","021_16_10","PRO","16","10","10","ແຕີ່ອ໌ ເຕືາວ ປັຣເຍືາ ປາຍ ມວຍ ຣາມຶ່ຮ ອຶນເຕົ່າ, ລາ ອັນ ປາຍ ຕາງ ແບອ໌ ເຢືາງ ເຈົາຣາຊີ; ອຶງເຄາະ ອັນ ຕຳເປຣ່ອ໌ ປັຣນາຍ, ຕາ ເບີນ ຮັກບັງ ຊັງບຍາງ. ");
INSERT INTO ncq_vpl VALUES ("PR16_11","021_16_11","PRO","16","11","11","ເຢືາງ ເຈົາຣາຊີ ຢໍອ໌ ລາລື່ ຊິງ ພາດີ ກະ ຕຳເປ່ກ ເຕ່ກ ຣາລີ, ກະ ຣານະ ຈິແຈີງ ລາ ອັນ ຢໍອ໌ ອີ ໂອນ ແກີດ ນ່ະກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("PR16_12","021_16_12","PRO","16","12","12","ມັຮ ເຕືາວ ປັຣເຍືາ ຊາອັຣ ຣານະ ຕາ ອໍ, ຍ່ອນ ອຳນາດ ຊົດ ໄລ່ ເຕ່ອ໌ ແກີດ ຄຳ ຄັນ ເບີນ ຣາມຶ່ຮ ປຍາຍ໌ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR16_13","021_16_13","PRO","16","13","13","ມັຮ ເຕືາວ ປັຣເຍືາ ຢໍອ໌ ລາລື່ ຊາງັດ ກວາຍ ຕະ ອຶນຕີ ຣາມຶ່ຮ ປຍາຍ໌; ໄລ່ ຊັອງ ຣໍ່ອ໌ ກະ ກວາຍ ອາຕີ ແອີງ ປັຣນາຍ ຕານັ່ອງ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR16_14","021_16_14","PRO","16","14","14","ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ຕະ ໂອນ ເຕືາວ ປັຣເຍືາ ຕາ ເບີນ ໂຍ່ບ ເຣືາຍ; ຄັນ ເຕືາວ ປັຣເຍືາ ຊັອງ ອຶງຄື່ນ, ເຕ່ອ໌ ອັນ ຕະ ໂອນ ເນົ່າ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("PR16_15","021_16_15","PRO","16","15","15","ແຕີ່ອ໌ ເຕືາວ ປັຣເຍືາ ກາຈັງ ກັຣຮຽວ, ລາ ຕະ ໂອນ ກອນແຊມ ແກີດ ກົງ ອາມົ່ງ ດູ່ນ; ກະ ຄັນ ອັນ ຊັອງ ໄກຣ ຣາງຶ່ຮ, ຣາມຶ່ຮ ກັອຍ ລາ ນ່ະ ເມືາ ປຣຍາຮ. ");
INSERT INTO ncq_vpl VALUES ("PR16_16","021_16_16","PRO","16","16","16","ຄາອ໌ ເບີນ ຣາງຶ່ຮ ຣາໄງ່ອ໌ ຣາລັ່ງ ກະ ດັງ, ແຕ ເບີນ ປຣະ ແຢງ ຊາອຶ່ຍ. ");
INSERT INTO ncq_vpl VALUES ("PR16_17","021_16_17","PRO","16","17","17","ກວາຍ ເປາະ ຕຶ່ງ ຣານາ ປຍາຍ໌, ອັນ ເຕ່ອ໌ ວຍາຣ ເຢີ່ງ ແຕ ຣານະ ຕາ ອໍ; ກວາຍ ກາ ເນ່ ກຣັ່ກ ຕຶ່ງ ຣານາ ອັນ ເປາະ, ເຕ່ອ໌ ອັນ ກູຣຍາອ໌ ແດີຍ ອາມົ່ງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR16_18","021_16_18","PRO","16","18","18","ຣານະ ອາຊັອຮ ຈະ ຕະ ຣາລຸຮ ຕຣໍ່ ຣາລໍ່ ວີ່ລ, ກະ ກວາຍ ໂອດ ແກີດ ຊາຕຣົ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("PR16_19","021_16_19","PRO","16","19","19","ຄາອ໌ ອາແຊງ ຈະ ເບີມ ກະ ແອີດ ມັນຕຸ ກະ ກວາຍ ກາດີດ, ແຕ ຈຸງ ມັຮ ເກຣີ່ງ ກຸມປູ່ຣ ກູເວືາດ ມັນຕຸ ກະ ກວາຍ ກາ ປັຣໂອດ. ");
INSERT INTO ncq_vpl VALUES ("PR16_20","021_16_20","PRO","16","20","20","ອຶງເຄາະ ໄມ່ ຕະ ຕາປູ່ນ ມັຮ ປັຣນາຍ ເນົ່າ ກາໄຕ່ຮ ອາຕີ, ເຈີ່ ແດີຍ ອາມົ່ງ ໄມ່ ແກີດ ອໍ ເລືອຍໆ; ບຸ່ນ ລາລື່ ກວາຍ ກາ ຊາອຳ ເລືອຍໆ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("PR16_21","021_16_21","PRO","16","21","21","ກວາຍ ກາ ດັງ ໄວ່ ເນົ່າ ປາຍ ອັນ ຣາໄງ່ອ໌ ຣາລັ່ງ; ກວາຍ ກາ ອາຕີ ປັຣນາຍ ລາເມ່ນ ອໍ, ເນົ່າ ຊາງັດ ອີດ. ");
INSERT INTO ncq_vpl VALUES ("PR16_22","021_16_22","PRO","16","22","22","ຣາໄງ່ອ໌ ຣາລັ່ງ ແກີດ ນ່ະ ປັຣໂລ່ຍ໌ ແດີອ໌ ໂອນ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ເບີນ ອາມົ່ງ; ມາ ກວາຍ ຊາກູລ ຣັ່ບ ລັ່ຮ ເກືາ ແຕ ຣາມຶ່ຮ ຊາກູລ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR16_23","021_16_23","PRO","16","23","23","ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ຄຶ່ດ ອຶນໂຍ່ງ ເວືາຍ ແຕ ປາຍ; ເຈີ່ ແບອ໌ ປັຣນາຍ ອັນ ແກີດ ບຼະ ແບຼງ. ");
INSERT INTO ncq_vpl VALUES ("PR16_24","021_16_24","PRO","16","24","24","ປັຣນາຍ ລາເມ່ນ ອໍ ລາ ອຶງເງືາມ ນ່ະ ແດີອ໌ ກາຮຍາລ; ຕະ ໂອນ ຈະຈັ່ນ ແກີດ ບັນ ເຣ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR16_25","021_16_25","PRO","16","25","25","ເບີນ ມວຍ ຣານາ ກວາຍ ຄຶ່ດ ປາຍ ປຍາຍ໌ ເຈີ່, ມາ ປັຣຊົດ ລາລື່ ຣານາ ກັອຍ ເດີງ ອັນ ເຈົາ ປໍ ອຶນຕຸ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("PR16_26","021_16_26","PRO","16","26","26","ມາເຍືາຍຮ ປຸ່ງ ຕະ ໂອນ ກວາຍ ແກີດ ແທຣິງ; ອັນ ກາດຸ ຕະ ຍ່ອນ ອັນ ຊັອງ ຢໍອ໌ ອີ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("PR16_27","021_16_27","PRO","16","27","27","ກວາຍ ແຣັ່ງ ອາລັ່ອຮ ເລືອຍໆ ເງ່ ອີ ຕະ ກວາຍ ການໍ່ອ໌; ເລືາຍຮ ອັນ ແກີດ ນ່ະ ອູ່ຍຮ ກູເລົ່າອ໌ ເບຼືານໆ. ");
INSERT INTO ncq_vpl VALUES ("PR16_28","021_16_28","PRO","16","28","28","ກວາຍ ດຸ ກັຣຈຸ່ກ ຕະ ໂອນ ແກີດ ຣາໂລຍຮ; ກວາຍ ກາ ຕາແມີຍຮ ຈາ ອຶນຕຣິ່ນ ຕາມິ່ນ ຈາ ອຶນຈີ ຕະ ໂອນ ເຢົ່າ ຣາຕັຮ. ");
INSERT INTO ncq_vpl VALUES ("PR16_29","021_16_29","PRO","16","29","29","ກວາຍ ຊາອ໌ ດຸ ອາໂລກ ເຢົ່າ, ເຈີ່ ເດີງ ໄລ່ ເປາະ ຕຶ່ງ ຣານາ ກູຈີດ ປິ່ດ ແດັດ ດຽລ. ");
INSERT INTO ncq_vpl VALUES ("PR16_30","021_16_30","PRO","16","30","30","ອຶງເຄາະ ໄມ່ ເນ່ ໂອນ ອໍ ແຕີ່ອ໌ ກວາຍ ມາຍີ່ວ ມັ່ດ ກະ ກາຈັງ ກັຣຮຽວ; ອຶງກັອຮ ປຍາຍ໌ ຣາງຶ່ຮ ໄລ່ ອີ ກູແຕັລ ເຍືາ ຕຶ່ງ ປຣຸ່ງ ອຶນຕຣູ່ ຕູ່ ຮັບ. ");
INSERT INTO ncq_vpl VALUES ("PR16_31","021_16_31","PRO","16","31","31","ແກີດ ກົງ ອາມົ່ງ ດູ່ນ ລາ ເກືາ ກວາຍ ຕານັ່ອງ ອໍ; ໂຊະ ປຼວາອ໌ ລາ ນ່ະ ກຸນຕຣວາອ໌ ໂອນ ກວາຍ ຕານັ່ອງ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR16_32","021_16_32","PRO","16","32","32","ເບີນ ຣາງຶ່ຮ ຈາ ອຶງກ່ອຍ ນ່ອຍ໌ ງ່ອຍ໌ ອຶງກ່ອຍ ອາຕີ ອໍ ກາເລີຍ ແຕ ເບີນ ອຳນາດ; ກະ ກວາຍ ກາ ດັງ ກຍາອ໌ ຈະ ເບີມ ລາ ອໍ ກາເລີຍ ແຕ ກວາຍ ກາ ຣາຈິ່ລ ເຣືາບ ມັຮ ເມືອງ. ");
INSERT INTO ncq_vpl VALUES ("PR16_33","021_16_33","PRO","16","33","33","ກວາຍ ດຸ ມັນຕັດ ຢໍອ໌ ອີ ດັງ ເງ່ ເຢືາງ ເຈົາຣາຊີ; ມາ ກູ່ ຣາມຶ່ຮ ເມ່ນ ເຢືາງ ເຈົາຣາຊີ ແຕິ່ ກາ ເຕ່ອ໌ ອາປັຮ. ");
INSERT INTO ncq_vpl VALUES ("PR17_1","021_17_1","PRO","17","1","1","ຄາອ໌ ໄຮ ຈາ ແອີງ ໂດຍ ເມືາດ ມາ ຣາງຶ່ຮ ໄຮ ແອີດ ອຽນ ອໍ, ແຕ ໄຮ ຈາ ເປ່ລ ຣໍ່ອ໌ ມາ ຕຶ່ງ ດຸງ ຣາໂລຍຮ ຣາແລັຮ ຣາແຈັ່ຮ ຣາຢັອງ. ");
INSERT INTO ncq_vpl VALUES ("PR17_2","021_17_2","PRO","17","2","2","ກວາຍ ຊູລ ຣາໄງ່ອ໌ ຣາລັ່ງ, ແກີດ ຊົດ ກາເລີຍ ແຕ ກອນ ຣາເລົາ ເນືາຍ ກາ ປາຍ ໂບຼດ ໂຊດ ບຼັລ; ກະ ກວາຍ ຊູລ ກັອຍ ເບີນ ຣັ່ບ ປູ່ດ ແຕ ມູ່ນ ມູເຈິງ ມັຮ ແຊມອາຍ ກວາຍ ຕຶ່ງ ດຸງ ກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("PR17_3","021_17_3","PRO","17","3","3","ປຣະ ແຢງ ອຶງເຄາະ ເນົ່າ ລ່ອງ ຕຶ່ງ ອູ່ຍຮ; ມູເຈິງ ກັອຍ ເຕ່ ເຢືາງ ເຈົາຣາຊີ ລ່ອງ ຣາງຶ່ຮ ຣາແຮີ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("PR17_4","021_17_4","PRO","17","4","4","ກວາຍ ແຣັ່ງ ດຸ ຊາງັດ ປັຣນາຍ ເນົ່າ ກັຣຈຸ່ກ; ກວາຍ ອາໂລກ ດຸ ຊາງັດ ປັຣນາຍ ຣາພິ. ");
INSERT INTO ncq_vpl VALUES ("PR17_5","021_17_5","PRO","17","5","5","ກວາຍ ອາແລ່ະ ກາ ກາຈັງ ເຈືາດ ພາມາດ ເຣືາງ ກວາຍ ກາດີດ, ລາ ອັນ ພາມາດ ເຢືາງ ເຈົາຣາຊີ ກາ ແຕງ ກວາຍ ກັອຍ ເຕ່. ກວາຍ ອາແລ່ະ ປາຍຽມ ຍັ່ບ ກວາຍ ກາ ເກຣ່າະ ກຣຍາດ, ກວາຍ ກັອຍ ເຢືາງ ເຈົາຣາຊີ ໂຈະ ໂຕ່ດ. ");
INSERT INTO ncq_vpl VALUES ("PR17_6","021_17_6","PRO","17","6","6","ມັຮ ກອນ ອາເຈົາ ແກີດ ນ່ະ ກຸນຕຣວາອ໌ ໂອນ ກວາຍ ເທົາ; ມູເຈິງ ອຶມເປ່ອ໌ ອຶມປໍ່ ຕະ ໂອນ ກອນ ໄລ່ ຊັອງ ຣໍ່ອ໌ ຣາງຶ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("PR17_7","021_17_7","PRO","17","7","7","ກວາຍ ຊາກູລ ປາຍ ນານ່ະ ຕາ ແກີດ ເກືາ ກາຮາ ນານ່ະ ຕາ ແກີດ ແບຼງ; ມູເຈິງ ກັອຍ ເຕ່, ປັຣນາຍ ກວາຍ ຊົດ ຕາ ເບີນ ຣາປຍາຍ໌ ກະ ປັຣນາຍ ອາໂລກ. ");
INSERT INTO ncq_vpl VALUES ("PR17_8","021_17_8","PRO","17","8","8","ກວາຍ ກາ ມັ່ກ ປຣະ ບຸ່ນ, ຣາມຶ່ຮ ກັອຍ ແກີດ ອຳນາດ ໂອນ ອັນ; ຍ່ອນ ປໍ ແລ່ະ ອັນ ອີ ເປາະ, ກະ ອຶນເຕົ່າ ອັນ ອີ ຕະ, ລາ ເຕ່ອ໌ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("PR17_9","021_17_9","PRO","17","9","9","ກວາຍ ອາແລ່ະ ອີ ຣາຕອຍ ກະ ເຢົ່າ, ອຶງເຄາະ ອັນ ດັງ ຕັຮ ໂລ່ຍຮ ເຢົ່າ; ມາ ກວາຍ ດຸ ລາລຶ່ບ ເລືອຍໆ ໂລ່ຍຮ ເຢົ່າ, ອັນ ກັອຍ ຕະ ໂອນ ແກີດ ຣາໂລຍຮ. ");
INSERT INTO ncq_vpl VALUES ("PR17_10","021_17_10","PRO","17","10","10","ກາແອັຮ ມວຍ ກຼອງ, ລາ ເບີນ ເກືາ ລາລື່ ໂອນ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ, ກາເລີຍ ແຕ ເນົ່າ ປຍາຍຮ ກວາຍ ຊາກູລ ມວຍ ຣ່ອຍ ເຮີບ. ");
INSERT INTO ncq_vpl VALUES ("PR17_11","021_17_11","PRO","17","11","11","ກວາຍ ຕາ ອໍ ຈໍ່ອ໌ ເລືອຍໆ ອີ ຣາຈິ່ລ ກະ ກວາຍ ຊົດ; ນ່ະກັອຍ ກວາຍ ຊົດ ອັນ ແປຣີ ກວາຍ ຊາອ໌ ເປາະ ຄານາບ ລັ່ຮ ກວາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR17_12","021_17_12","PRO","17","12","12","ຄາອ໌ ຣາມົຮ ຊາເກົ່າ ກັນ ເນົ່າ ຕາແບິ ປາໂຣນ ກອນ ອັນ, ແຕ ຣາມົຮ ກວາຍ ຊາກູລ ກາ ຕະ ຢຸ່ຮໆ ເລືອຍໆ. ");
INSERT INTO ncq_vpl VALUES ("PR17_13","021_17_13","PRO","17","13","13","ຄັນ ກວາຍ ຕະ ຣານະ ຕາ ອໍ ເຕ່ນ ຣານະ ອໍ, ຣານະ ຕາ ອໍ ຕາ ເກີ່ຍ ແວັດ ແຕ ດຸງຊູ ກວາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR17_14","021_17_14","PRO","17","14","14","ຄັນ ຈີຈໍ່ອ໌ ຢໍອ໌ ອີ ໂອນ ຣາໂລຍຮ, ລາ ມູເຈິງ ລຸ່ຮ ການີ່ງ ແດີອ໌; ນ່ະກັອຍ ອຶງເຄາະ ຕາງິ່ດ ແຕິ່ ແຕ ຣາໂລຍຮ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR17_15","021_17_15","PRO","17","15","15","ບາຣ ຣາມຶ່ຮ ກາ ເຢືາງ ເຈົາຣາຊີ ຊາອັຣ ລາ ນ່ະໄນ່: ຕູນ ອາແປັດ ກວາຍ ຕາ ເບີນ ໂລ່ຍຮ, ກະ ອາໂຣຍຮ ກວາຍ ໂລ່ຍຮ ແຕ ອຶນໂຍ່ງ ອັນ ຣັ່ບ ໂຕ່ດ. ");
INSERT INTO ncq_vpl VALUES ("PR17_16","021_17_16","PRO","17","16","16","ໂລ່ ເມືາດ ກວາຍ ຊາກູລ ອາປິ່ດ ປຣະ ອີ ແຈີງ ຣາໄງ່ອ໌ ຣາລັ່ງ, ຍ່ອນ ກວາຍ ກັອຍ ເຈຍ ຕາ ເບີນ ຊາປຸ່ຮ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR17_17","021_17_17","PRO","17","17","17","ເຢົ່າ ຣາຕອຍ, ໄລ່ ມານະ ອາໂຢ່ະ ມານະ ກູ່ ຣາໄງ; ກະ ແຊມອາຍ ມານະ ງື່ ຣາຈ່ອຍ ມານະ ແຕີ່ອ໌ ຕຸ່ຮ ກັ່ດ. ");
INSERT INTO ncq_vpl VALUES ("PR17_18","021_17_18","PRO","17","18","18","ແອີງ ກວາຍ ຊາກູລ ແຕິ່ ກາ ປຣ່ອມ ກ່ຳ ຕູ່ ໂອນ ກວາຍ ການໍ່ອ໌, ກະ ມັ່ກ ລັບ ຕູ່ ຕາງ ເຢົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR17_19","021_17_19","PRO","17","19","19","ກວາຍ ມັ່ກ ຣາໂລຍຮ ລາ ມູເຈິງ ອັນ ປາຊິ ອາກັນ ໂລ່ຍຮ. ກວາຍ ຕະ ງັ່ຮ ຕົ່ງ ໂຢງ ປັຣໂອດ ປາຍ ຊຸ, ລາ ອັນ ຈາຈໍ່ອ໌ ອີ ອາປິ່ດ ຈະ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("PR17_20","021_17_20","PRO","17","20","20","ກວາຍ ຣາງຶ່ຮ ຣາແຮີ ໂກ່ະ ຕາ ເຕ່ອ໌ ເບີນ ຣາມຶ່ຮ ອໍ; ກະ ກວາຍ ຕະ ອຶນຕີ ອາໂລກ, ເມ່ນ ອັນ ແກີດ ປິ່ດ ນ່ະ ຣາໄບຮ ກັລໄດຮ ນ່ະ ມັນຈິ່ລ. ");
INSERT INTO ncq_vpl VALUES ("PR17_21","021_17_21","PRO","17","21","21","ອຶມເປ່ອ໌ ອຶມປໍ່ ເບີນ ກອນ ຊາກູລ, ໄລ່ ແກີດ ຕຸ່ຮ ງໍ່ ຕຶ່ງ ຣາງຶ່ຮ; ຄັນ ກອນ ເນົ່າ ກາ ເຮາະ, ລື່ ຕາ ເກີ່ຍ ເບີນ ຣໍ່ອ໌ ບູຍ. ");
INSERT INTO ncq_vpl VALUES ("PR17_22","021_17_22","PRO","17","22","22","ຣາງຶ່ຮ ຣໍ່ອ໌ ບູຍ ແກີດ ນ່ະ ຣາເຮົາ ແບຼງ ໂອນ ຈະຈັ່ນ ບັນ ເຣ່ງ; ມາ ຣາງຶ່ຮ ງໍ່ ຕະ ໂອນ ຈະ ກວາຍ ແກີດ ອອຍ໌ ຣັ່ອຮ ກັອຮ ຊາລ. ");
INSERT INTO ncq_vpl VALUES ("PR17_23","021_17_23","PRO","17","23","23","ກວາຍ ຕາ ອໍ ຣັ່ບ ປຣະ ເນົ່າ ບຸ່ນ ແກຣ່ະໆ; ໂອນ ປັຣຈີນ ປັຣນາຍ ຮັກບັງ ຊັງບຍາງ. ");
INSERT INTO ncq_vpl VALUES ("PR17_24","021_17_24","PRO","17","24","24","ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ລາແຮິຮ ລາແຮີບ ຈໍ່ອ໌ ຣາມຶ່ຮ ຣາໄງ່ອ໌ ຣາລັ່ງ; ມາ ກວາຍ ຊາກູລ ລາແດິຮ ລາແດີບ ກູ່ ຮັອງ ດຸງ ຕາຣົ່ງ ຊູ. ");
INSERT INTO ncq_vpl VALUES ("PR17_25","021_17_25","PRO","17","25","25","ກອນ ຣາເລົາ ຊາກູລ ຕະ ໂອນ ອຶມເປ່ອ໌ ອຶມປໍ່ ແກີດ ງໍ່; ອັນ ຕະ ໂອນ ໄລ່ ແກີດ ຕຣຍາອ໌ ຕຶ່ງ ຣາງຶ່ຮ ຣາແຮີ. ");
INSERT INTO ncq_vpl VALUES ("PR17_26","021_17_26","PRO","17","26","26","ຕາ ເບີນ ປຍາຍ໌ ຕະ ໂຕ່ດ ກວາຍ ຕາ ເບີນ ໂລ່ຍຮ, ແຕີລາ ປຍາຍຮ ກວາຍ ຕານັ່ອງ ຕາປຶ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR17_27","021_17_27","PRO","17","27","27","ກວາຍ ດັງ ຊາອຶ່ຍ, ອັນ ຕາ ເບີນ ຢໍອ໌ ອີ ປາຍ ລຶ່ບ ຕາ ລຶ່ບ; ກວາຍ ຊາປຸ່ຮ ຊາອຶ່ຍ ເຈີ່, ອັນ ເບີນ ຣາງຶ່ຮ ລາວິ່ ນ່ະ ດາຍ ລາເວືາຍ ນ່ະ ແດີອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR17_28","021_17_28","PRO","17","28","28","ຄັນ ກວາຍ ຊາກູລ ມາ ແອີດ ຣາງຍາອ໌, ລາ ເນົ່າ ຄຶ່ດ ປາຍ ອັນ ດັງ; ກະ ຄັນ ອັນ ກູແມມ ແບອ໌, ເນົ່າ ປາຍ ອັນ ເບີນ ຣາງຶ່ຮ ຣາໄງ່ອ໌ ຣາລັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR18_1","021_18_1","PRO","18","1","1","ກວາຍ ຕາ ເບີນ ຣາຕອຍ ກະ ເຢົ່າ ໄບ, ລາ ອັນ ຣາບູລ ແອີງ ແຕ ຈະ ອັນ ເບີມ; ອັນ ຕາ ເບີນ ປຣ່ອມ ກະ ຣານະ ປຍາຍ໌. ");
INSERT INTO ncq_vpl VALUES ("PR18_2","021_18_2","PRO","18","2","2","ກວາຍ ຊາກູລ ຕາ ເບີນ ຣາບູລ ອີ ດັງ ມວຍ ຣາມຶ່ຮ ອຶນເຕົ່າ; ມາ ອັນ ຣາເມົ່າ ອີ ອາປັຮ ແອີງ ຣາງຶ່ຮ ອັນ ຄຶ່ດ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("PR18_3","021_18_3","PRO","18","3","3","ອາກັນ ໂລ່ຍຮ ກະ ອາກັນ ກູມາລ ລາ ເປາະ ມັນຕຸ. ຄັນ ອາກັນ ກູມາລ ແຕີ່ອ໌, ເຈີ່ ເບີນ ແຕິ່ ປັຣນາຍ ພາມາດ. ");
INSERT INTO ncq_vpl VALUES ("PR18_4","021_18_4","PRO","18","4","4","ມັຮ ປັຣນາຍ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ແກີດ ນ່ະ ປັຣໂລ່ຍ໌ ອາກັນ ຣາໄງ່ອ໌ ຣາລັ່ງ, ອຶນຕຣູ່ ນ່ະ ທາເລ, ກະ ຣາລັ່ງ ນ່ະ ແດີອ໌ ຕູມ ກາ ປຼົຮ. ");
INSERT INTO ncq_vpl VALUES ("PR18_5","021_18_5","PRO","18","5","5","ຕາ ເບີນ ປຍາຍ໌ ຮັກບັງ ຊັງບຍາງ ໂອນ ກວາຍ ໂລ່ຍຮ ແຕີລາ ຕູນ ອາແປັດ ກວາຍ ຕາ ເບີນ ຕະ ໂລ່ຍຮ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR18_6","021_18_6","PRO","18","6","6","ຄັນ ກວາຍ ຊາກູລ ຈໍ່ອ໌ ເລືອຍໆ ອີ ຣາໂລຍຮ, ກັອຍ ລາ ນ່ະ ອັນ ມັນຕຣັ່ນ ໂອນ ເນົ່າ ປຍາຍຮ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR18_7","021_18_7","PRO","18","7","7","ປັຣນາຍ ກວາຍ ຊາກູລ ປາຍ ລາ ອາປິ່ດ ຈະ ອັນ ເບີມ; ອັນ ຕານ ຊາງ ກູວາງ ໂຈະ ຈະ ອັນ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("PR18_8","021_18_8","PRO","18","8","8","ຣານະ ຕາແມີຍຮ ເຢົ່າ ແກີດ ບະ ປາຈົກ ນ່ະ ຣາແວັ່ຮ; ກະ ກວາຍ ອາແລ່ະ ຊາງັດ ປັຣນາຍ ກັອຍ, ອັນ ລື່ນ ໄຈ ລາລື່ ຣາມຶ່ຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR18_9","021_18_9","PRO","18","9","9","ກວາຍ ອາລັ່ຮ ກະ ກວາຍ ມັ່ກ ຕາລຸຮ ລາ ລີ ຣາລີ. ");
INSERT INTO ncq_vpl VALUES ("PR18_10","021_18_10","PRO","18","10","10","ຣາມຶ່ຮ ເຢືາງ ເຈົາຣາຊີ ແກີດ ນ່ະ ດຸງ ຍາມ ຄຳ ລາລື່, ລາ ອຶນຕຸ ກວາຍ ຕານັ່ອງ ອໍ ເຕ່ອ໌ ປັ່ອງ ໂອນ ແກີດ ກຼີດ ກຼອດ ຈອດ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR18_11","021_18_11","PRO","18","11","11","ມັຮ ກວາຍ ຊຸ ດຸ ຄຶ່ດ ປາຍ ມູ່ນມັ່ງ ໄລ່ ເຕ່ອ໌ ກຸ່ມກຍາອ໌ ໄລ່, ແກີດ ນ່ະ ວຍາງ ດໍອ໌ ກູຣຍາອ໌ ເມືອງ. ");
INSERT INTO ncq_vpl VALUES ("PR18_12","021_18_12","PRO","18","12","12","ກວາຍ ປັຣໂອດ ຈະ ເບີມ ແກີດ ແດັດ ປິ່ດ ຊາລີຣ, ມາ ກວາຍ ອາແຊງ ຈະ ເບີນ ຊະເຢືາງ ປັຣເລືາງ ປາເນົາ. ");
INSERT INTO ncq_vpl VALUES ("PR18_13","021_18_13","PRO","18","13","13","ຊາງັດ ອຶນໂຍ່ງ ເວືາຍ ແຕ ຕາແອີຍ; ຄັນ ຕາແອີຍ ອຶນໂຍ່ງ ຊາງັດ, ລາ ຊາກູລ ກະ ກູມາລ ຕະ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR18_14","021_18_14","PRO","18","14","14","ຣາງຶ່ຮ ບັນ ເຣ່ງ ເຕ່ອ໌ ຈີວ໌ ເລືອຍໆ ອາອີ່ ຕາກົຮ; ມາ ກວາຍ ກາ ແອິ ຣາງຶ່ຮ ອຶງກ່ອງ ອັນ ຕາ ເຣືາບ ຈີວ໌ ອຶນເຕົ່າ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("PR18_15","021_18_15","PRO","18","15","15","ມັຮ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ອູອຍາຣ ອູໄອອ໌ ອີ ຣຍານ ໂອນ ດັງ; ໄລ່ ກູຕົງ ອຶນແຍ່ະ ຣາງຶ່ຮ ຣາແຮີ ຈໍ່ອ໌ ອີ ແກີດ ຣາໄງ່ອ໌ ຣາລັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR18_16","021_18_16","PRO","18","16","16","ຄັນ ຢໍອ໌ ອີ ຣາມົຮ ກວາຍ ເບີນ ອຳນາດ ປື່ດ, ຣາມຶ່ຮ ກັອຍ ອຽນ ລາລື່ ຄັນ ໄມ່ ອາແຕີ່ອ໌ ຣັງອອຍ ປໍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR18_17","021_18_17","PRO","18","17","17","ກວາຍ ກາ ຕາແບິ ລາລື່ ລັ່ອຮ ຕະ ອຶນຕີ ຕຶ່ງ ອຶນຕຸ ປັຣຈີນ, ປັຣນາຍ ອັນ ປາຍ ອາຣັ່ງ ປຍາຍ໌, ພໍກາ ແຕີ່ອ໌ ມານະ ແອັນ ຕະ ອຶນຕີ ຣາລັ່ດ ລັ່ຮ ກວາຍ ກັອຍ, ກັອຍ ແຕ ເນົ່າ ດັງ ແຈງ. ");
INSERT INTO ncq_vpl VALUES ("PR18_18","021_18_18","PRO","18","18","18","ຄັນ ບາຣ ນະ ກວາຍ ຊົດ ຣາຈຽນ ຕຶ່ງ ອຶນຕຸ ປັຣຈີນ ປັຣນາຍ, ອຶງເຄາະ ໄລ່ ປັຣຈີນ ໂອນ ແມິ່ມ ຣານາ ມັນຕັດ ອາຍຸ່ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR18_19","021_18_19","PRO","18","19","19","ຣາຈ່ອຍ ມັຮ ແຊມອາຍ, ລາ ມູເຈິງ ກະ ຕະ ວຍາງ ເມືອງ ໂອນ ຄຳ ລາລື່; ມາ ແຊມອາຍ ກາ ຣາໂລຍຮ ຣາແລັຮ, ລາ ມູເຈິງ ອີດ ຕາອ໌ ກຼັງ ດໍອ໌ ງັ່ຮ ຕົ່ງ ຕາ ໂອນ ມູ່ດ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("PR18_20","021_18_20","PRO","18","20","20","ປັຣໄລຮ ປັຣນາຍ ກວາຍ ແຄວ໌ ຕະ ອຶນຕີ, ລາ ນ່ະ ຣາແວັ່ຮ ແອມ ອໍ; ອັນ ຕະ ໂອນ ກວາຍ ຊັອງ ຣໍ່ອ໌ ນ່ະ ປຸ່ງ ກາ ຈາ ປາໄຊ. ");
INSERT INTO ncq_vpl VALUES ("PR18_21","021_18_21","PRO","18","21","21","ມັຮ ປັຣນາຍ ລັ່ອຮ ແຕ ແບອ໌, ເຕ່ອ໌ ຈ່ອຍ ໂອນ ອັນ ເບີນ ອາມົ່ງ ແຕີລາ ໂອນ ກູຈີດ; ກວາຍ ກາ ອຶນຊອຍ໌ ແບອ໌, ລາ ອຶງເຄາະ ຣັ່ບ ເກືາ ແຕ ປັຣນາຍ ອັນ ປາຍ. ");
INSERT INTO ncq_vpl VALUES ("PR18_22","021_18_22","PRO","18","22","22","ຣາເລົາ ກາ ຣາມົຮ ລາກວຍ ລາ ນ່ະ ອັນ ຣາມົຮ ຣັງອອຍ ເບີນ ເກືາ ລາລື່; ອັນ ຣັ່ບ ບຸ່ນ ເກີ່ຍ ຣາແອີຍ ປັ່ນ ແຕ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("PR18_23","021_18_23","PRO","18","23","23","ກວາຍ ຕຸ່ຮ ກາດີດ ກູໂກຼຍ໌ ກູເກຼ່ງ ໂອນ ເນົ່າ ຊັອງ ອາໂຢ່ະ ຕະ; ມາ ກວາຍ ຊຸ ຕາແອີຍ ຊັງໄກຮ ຊັງແກີລ. ");
INSERT INTO ncq_vpl VALUES ("PR18_24","021_18_24","PRO","18","24","24","ເບີນ ເຢົ່າ ຣາຕອຍ ຊາອຶ່ຍ ນະ, ມາ ຕາ ເບີນ ຣາຕອຍ ດູ່ນ; ມາ ເບີນ ເຕ່ ເຢົ່າ ຣາຕອຍ ລາລື່ ກາ ແຈ່ະ ຊຍາດ ກາເລີຍ ແຕ ແຊມອາຍ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("PR19_1","021_19_1","PRO","19","1","1","ຄາອ໌ ແກີດ ກວາຍ ກາດີດ ມາ ຕານັ່ອງ ຕາປຶ່ງ, ແຕ ແກີດ ກວາຍ ຊາກູລ ກາ ຕະ ອຶນຕີ ອາໂລກ. ");
INSERT INTO ncq_vpl VALUES ("PR19_2","021_19_2","PRO","19","2","2","ຕາ ເບີນ ອໍ ຄັນ ກວາຍ ຕາ ມຸ່ຮ ມາ ຕະ ກຸນເຕົາ; ຮັບ ຕັລຕວາລ, ລາ ແກຼິ ຣານາ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("PR19_3","021_19_3","PRO","19","3","3","ກວາຍ ກາ ຕະ ຣານະ ຊາກູລ ລາ ບັອງ ອາປິ່ດ ຈະ ເບີມ, ເຈີ່ ອັນ ອູໂອຍ ປາຍ ເຢືາງ ເຈົາຣາຊີ ຕະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR19_4","021_19_4","PRO","19","4","4","ກວາຍ ຊຸ ເບີນ, ເບີນ ເຢົ່າ ຊາອຶ່ຍ ໄມ ຕາໄມ; ມາ ກວາຍ ກາດີດ ອຶມປຶ່ ເຢົ່າ ກາ ອັນ ເບີນ ບີ່ອ໌ ນະ, ລາ ໄລ່ ອີ ຕັຮ ຊັອງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR19_5","021_19_5","PRO","19","5","5","ກວາຍ ປາຍ ໂລ່ຍຮ ກູໂຕຍຮ ອຶນຍິ່ຮ ຕຶ່ງ ອຶນຕຸ ປັຣຈີນ ປັຣນາຍ, ອຶງເຄາະ ຣັ່ບ ໂຕ່ດ; ກວາຍ ມັ່ກ ປາຍ ຣາຍິ່ງ ຣາຍັ່ງ ແອີງ ປັຣນາຍ ອາໂລກ, ອັນ ຕາ ເຕ່ອ໌ ໄງ່ອ໌ ແຕ ເນົ່າ ຕະ ໂຕ່ດ. ");
INSERT INTO ncq_vpl VALUES ("PR19_6","021_19_6","PRO","19","6","6","ຊາອຶ່ຍ ນະ ກວາຍ ກູຕົງ ເລືອຍໆ ອີດ ຣາງຶ່ຮ ກວາຍ ເບີນ ອຳນາດ; ກະ ກູ່ ນະ ກວາຍ ຢໍອ໌ ລາລື່ ອີ ຕະ ເຢົ່າ ກະ ກວາຍ ດຸ ເດີງ ຣັງອອຍ ໂອນ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR19_7","021_19_7","PRO","19","7","7","ມັຮ ແຊມອາຍ ກວາຍ ກາດີດ, ໄລ່ ຊາອັຣ ຕະ ອັນ, ກະ ມັຮ ເຢົ່າ ອັນ ລາ ວຍາຣ ເຢີ່ງ ແຕ ອັນ ເຕ່. ອຶມປຶ່ ອັນ ກູກຸຮ ກູກວຍ ອຶນແຍ່ະ ຣາງຶ່ຮ, ລາ ຕາ ເບີນ ເນົ່າ ອີ ຣາຕອຍ ກະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR19_8","021_19_8","PRO","19","8","8","ກວາຍ ກາ ຣາໄງ່ອ໌ ຣາລັ່ງ, ອັນ ດັງ ອາໂຢ່ະ ແດີຍ ອາມົ່ງ ອັນ ເບີມ; ກວາຍ ກາ ເຈີ ເລືອຍໆ ມັຮ ຣາມຶ່ຮ ອັນ ຣຍານ, ລາ ອັນ ຕະ ແກີດ ແປີດ ແຮີຍ. ");
INSERT INTO ncq_vpl VALUES ("PR19_9","021_19_9","PRO","19","9","9","ກວາຍ ປາຍ ໂລ່ຍຮ ກູໂຕຍຮ ອຶນຍິ່ຮ ຕຶ່ງ ອຶນຕຸ ປັຣຈີນ ປັຣນາຍ, ອຶງເຄາະ ຣັ່ບ ໂຕ່ດ; ກວາຍ ປາຍ ຣາຍິ່ງ ຣາຍັ່ງ ແອີງ ປັຣນາຍ ອາໂລກ, ແຮງ ອັນ ແກີດ ປິ່ດ ຕາແປດ ແທຣດ ຕາປູ່ນ. ");
INSERT INTO ncq_vpl VALUES ("PR19_10","021_19_10","PRO","19","10","10","ກວາຍ ຊາກູລ ຕາ ເບີນ ປຍາຍ໌ ຕັອກ ຈາ ຊະຊາຍ; ກະ ກວາຍ ຊູລ ຕາ ເບີນ ປຍາຍ໌ ແກີດ ຊົດ ກອນ ເຕືາວ ປັຣເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("PR19_11","021_19_11","PRO","19","11","11","ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ເຣືາບ ຈີວ໌ ເລືອຍໆ. ກະ ກວາຍ ກາ ໂລ່ຍຮ ປື່ດ ມັນແທຣດ ໂລ່ຍຮ ແກດ ມັນທຣຳ, ລາ ເນົ່າ ຢຳນັ່ບ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR19_12","021_19_12","PRO","19","12","12","ແຕີ່ອ໌ ເຕືາວ ປັຣເຍືາ ອຶງຄື່ນ, ຣາມຶ່ຮ ກັອຍ ລາ ນ່ະ ກູລາ ຊິງ ອາຣື່; ມາ ແຕີ່ອ໌ ອັນ ອາໂຢ່ະ ຕະ, ໄນ່ ລາ ນ່ະ ຕາລຸ່ ປູປຣີ່ວ ໂຈະ ຕຶ່ງ ບັດ ອຶນຍ່ອມ. ");
INSERT INTO ncq_vpl VALUES ("PR19_13","021_19_13","PRO","19","13","13","ກອນ ຊາກູລ ຕະ ໂອນ ອຶມປໍ່ ແກີດ ຣາລຸຮ ຕຣໍ່ ຣາລໍ່ ວີ່ລ; ກະ ລາກວຍ ກາ ອາຊັອຮ ມັ່ດ ຕາແບງ ອາແຊງ ມັ່ດ ກູເຊົາ, ລາ ຕະ ໂອນ ຊາອີຣ ນ່ະ ແດີອ໌ ຕາເຢາະ ເລືອຍໆ. ");
INSERT INTO ncq_vpl VALUES ("PR19_14","021_19_14","PRO","19","14","14","ປຣະ ແຢງ ດຸງ ໄທຣ ເນືາ ປຼື່ ລາ ມູ່ນ ແຕ ອຶມເປ່ອ໌ ອຶມປໍ່; ມາ ລາກວຍ ມັນຕັ່ດ ອໍ ລາ ຣັງອອຍ ກາ ເຢືາງ ເຈົາຣາຊີ ໂອນ. ");
INSERT INTO ncq_vpl VALUES ("PR19_15","021_19_15","PRO","19","15","15","ກວາຍ ປາງາຍ ບິ ກູຕຸ່ ຕູ່ຣ ເລືອຍໆ, ອັນ ແກີດ ຕຸ່ຮ ກູປາຍຮ ມາເຍືາຍຮ ໂດຍ. ");
INSERT INTO ncq_vpl VALUES ("PR19_16","021_19_16","PRO","19","16","16","ອຶງເຄາະ ຢຸມ ໂອນ ຈັບ ມັຮ ປັຣນາຍ ປາຕັບ, ໂອນ ແດີຍ ອາມົ່ງ ໄມ່ ແກີດ ກົງ ອາມົ່ງ ດູ່ນ; ກວາຍ ອາແລ່ະ ມາ ຕາ ເບີນ ຣາເມົ່າ ແຕ ປັຣນາຍ ປາຕັບ, ລາ ອັນ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("PR19_17","021_19_17","PRO","19","17","17","ຄັນ ເຍືາ ໂອນ ເກຣີ່ງ ອຶນເຕົ່າ ປໍ ກວາຍ ກາດີດ, ລາ ມູເຈິງ ເຍືາ ໂອນ ເຢືາງ ເຈົາຣາຊີ ເມືານ; ເຈີ່ ລື່ ເຢືາງ ເຈົາຣາຊີ ກູລັຮ ລັ່ຮ ກວາຍ ກາ ຕະ ນ່ະກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR19_18","021_19_18","PRO","19","18","18","ອຶງເຄາະ ໄມ່ ແອບ ອາຕີ ກອນ ໄມ່ ແຕ ບັອງ ໄລ່ ອຶນນັ່ອງ ກັຣແນນ, ມາ ຄັນ ໄມ່ ຕາ ເບີນ ແອບ, ລາ ນ່ະ ໄມ່ ຕະ ໂອນ ໄລ່ ອາປິ່ດ ຈະ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("PR19_19","021_19_19","PRO","19","19","19","ກວາຍ ມິ່ດ ອາອຸ່ງ ປຸ່ງ ອຶນໂຊະ, ອັນ ອຶງເຄາະ ຣັ່ບ ເບີມ ໂຕ່ດ ແຕ ມັຮ ຣານະ ອັນ ຕະ; ຄັນ ເຍືາ ລັບ ອາເຈົາ ອັນ ມູ ເຮີບ ເຈີ່, ເຮີບ ອຶນຕູ່ນ ອຶງເຄາະ ເຍືາ ຈ່ອຍ ລັ່ຮ ຊາ. ");
INSERT INTO ncq_vpl VALUES ("PR19_20","021_19_20","PRO","19","20","20","ກວາຍ ຕາປູ່ນ ອີດ ປັຣນາຍ ເນົ່າ ຕຽຮ, ກະ ຕາປູ່ນ ມັຮ ປັຣນາຍ ເນົ່າ ປາຕັບ, ອຶນຕູ່ນ ລາ ອັນ ລື່ ແກີດ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR19_21","021_19_21","PRO","19","21","21","ມັຮ ກວາຍ ດຸ ອາລັ່ອຮ ຊາອຶ່ຍ ເງ່; ມາ ແອີງ ເຢືາງ ເຈົາຣາຊີ ແຕິ່ ກາ ຕະ ໂອນ ມັຮ ຣາມຶ່ຮ ແກີດ ແມິ່ມ. ");
INSERT INTO ncq_vpl VALUES ("PR19_22","021_19_22","PRO","19","22","22","ກວາຍ ກຸມປູ່ຣ ກູເວືາດ ຕາ ຄຳ ຕາ ແຢິຮ, ປຍາຍ໌ ອັນ ແກີດ ກູມາລ; ຄາອ໌ ໄຮ ກາດີດ, ແຕ ໄຮ ຕະ ອຶນຕີ ອາໂລກ. ");
INSERT INTO ncq_vpl VALUES ("PR19_23","021_19_23","PRO","19","23","23","ກວາຍ ຢຳນັ່ບ ເຢືາງ ເຈົາຣາຊີ ເບີນ ຣັ່ບ ເກືາ ນ່ະໄນ່: ແກີດ ກົງ ອາມົ່ງ ດູ່ນ, ແອີດ ຣໍ່ອ໌ ບູຍ, ກະ ແວັດ ແຕ ເກຣ່າະ ກຣຍາດ ອາອີ່ ຕາກົຮ. ");
INSERT INTO ncq_vpl VALUES ("PR19_24","021_19_24","PRO","19","24","24","ກວາຍ ປາງາຍ ຣຳແປັຮ ຈວາຍ໌ ຣາແວັ່ຮ ຕຶ່ງ ຕາງານ, ມາ ອັນ ຊັອງ ອາລັ່ຮ ອີ ໂຈະ ຕຶ່ງ ແບອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR19_25","021_19_25","PRO","19","25","25","ແຕີ່ອ໌ ກວາຍ ຊາກູລ ເຮີມ ເນົ່າ ໂຈະ ໂຕ່ດ ກວາຍ ອາຊັອຮ ຈະ, ເຕ່ອ໌ ອັນ ຣຍານ ແຕ ຣາມຶ່ຮ ກັອຍ. ຄັນ ເຍືາ ກາໄຕ່ຮ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ, ລາ ອັນ ແກີດ ຣາໄງ່ອ໌ ຣາລັ່ງ ອາຊັອຮ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR19_26","021_19_26","PRO","19","26","26","ກວາຍ ອາແລ່ະ ຕູ່ຍຮ ອາຢ່ະ ຕະ ອຶມເປ່ອ໌ ອຶມປໍ່, ກວາຍ ກັອຍ ຕະ ໂອນ ແກີດ ກູມາລ ກະ ເນົ່າ ດັນເດີງ ເລືອຍໆ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR19_27","021_19_27","PRO","19","27","27","ກວາຍ ກາ ຕາ ແອອ໌ ອີ ຊາງັດ ແຕີ່ອ໌ ເນົ່າ ກາໄຕ່ຮ ອາຕີ ອັນ, ລາ ຕາ ເບີນ ດູ່ນ, ມັຮ ຣາມຶ່ຮ ກາ ອັນ ຣຍານ ແກີດ ແດັດ ປິ່ດ ຊາລີຣ. ");
INSERT INTO ncq_vpl VALUES ("PR19_28","021_19_28","PRO","19","28","28","ກວາຍ ຕະ ອຶນຕີ ພາມາດ ເລືອຍໆ ຕຶ່ງ ອຶນຕຸ ປັຣຈີນ ປັຣນາຍ, ກວາຍ ກັອຍ ຕາ ເບີນ ຣາເມົ່າ ເລີຍ ແຕ ຣາມຶ່ຮ ຕານັ່ອງ ຕາປຶ່ງ. ກວາຍ ແຣັ່ງ ລື່ນ ຣາມຶ່ຮ ຕາ ອໍ ນ່ະ ອັນ ລື່ນ ຊັຣນາ. ");
INSERT INTO ncq_vpl VALUES ("PR19_29","021_19_29","PRO","19","29","29","ກວາຍ ອາເຢ່ ພາມາດ ເຢືາງ ເຈົາຣາຊີ ອຶງເຄາະ ຣັ່ບ ໂຕ່ດ ກາ ເຢືາງ ເຈົາຣາຊີ ກຽມ ດໍອ໌; ກະ ກວາຍ ກາ ຕະ ຣານະ ຊາກູລ ອຶງເຄາະ ຣາມົຮ ຣາວັ່ດ ຕຶ່ງ ກຣັອງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR20_1","021_20_1","PRO","20","1","1","ງ່ອຍ໌ ບຼັອງ ລວາດ ງື່ ຕະ ໂອນ ກວາຍ ຊູລີ່ ກະ ຣາໂລຍຮ ເລືອຍໆ; ກວາຍ ມັ່ກ ງ່ອຍ໌ ບຼັອງ ລາ ຕາ ແກີນ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR20_2","021_20_2","PRO","20","2","2","ແຕີ່ອ໌ ເຕືາວ ປັຣເຍືາ ໂຍ່ບ, ລາ ນ່ະ ກູລາ ຊິງ ອາຣື່; ກວາຍ ກາ ຕະ ໂອນ ເຕືາວ ປັຣເຍືາ ອຶງຄື່ນ, ລາ ນ່ະ ອັນ ກາຈີດ ຈະ ອັນ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("PR20_3","021_20_3","PRO","20","3","3","ອໍ ລາລື່ ໂອນ ກວາຍ ວຍາຣ ແຕ ຣາໂລຍຮ; ມາ ກູ່ ນະ ກວາຍ ຊາກູລ ໄຈ ລາລື່ ຣາໂລຍຮ. ");
INSERT INTO ncq_vpl VALUES ("PR20_4","021_20_4","PRO","20","4","4","ກວາຍ ກາ ອາລັ່ຮ ຕາ ເບີນ ຊາຕວງ ເນືາ ແຕີ່ອ໌ ຍາມ ຊາຕວງ, ເຈີ່ ແຕີ່ອ໌ ຍາມ ຣິ່ ອັນ ຕາ ເບີນ ອຶນເຕົ່າ ອີ ຣິ່. ");
INSERT INTO ncq_vpl VALUES ("PR20_5","021_20_5","PRO","20","5","5","ຣາງຶ່ຮ ກວາຍ ຄຶ່ດ ລາ ອຶນຕຣູ່ ນ່ະ ກຼົງ ແດີອ໌; ມາ ກວາຍ ອາແລ່ະ ເຕ່ອ໌ ດັງ ຣາມຶ່ຮ ກັອຍ, ອັນ ເຕ່ອ໌ ຊາປຸ່ຮ ຣາງຶ່ຮ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("PR20_6","021_20_6","PRO","20","6","6","ເບີນ ຊາອຶ່ຍ ນະ ກວາຍ ອາງ ປາຍ ໄລ່ ຕະ ຕານັ່ອງ ຕາປຶ່ງ; ມາ ກັ່ດ ລາລື່ ຈໍ່ອ໌ ກວາຍ ກາ ເຈຍ ຕານັ່ອງ ຕາປຶ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR20_7","021_20_7","PRO","20","7","7","ບຸ່ນ ລາລື່ ມັຮ ກອນ ກາ ເບີນ ອຶມປໍ່ ຕານັ່ອງ ອໍ ກະ ຕະ ປຍາຍ໌ ເລືອຍໆ. ");
INSERT INTO ncq_vpl VALUES ("PR20_8","021_20_8","PRO","20","8","8","ພໍກາ ເຕືາວ ປັຣເຍືາ ບັອງ ປັຣຈີນ ປັຣນາຍ, ແຕີ່ອ໌ ອັນ ເຮີມ ຣານະ ຕາ ອໍ ລາ ອັນ ຊາກັ່ລ ແຕິ່. ");
INSERT INTO ncq_vpl VALUES ("PR20_9","021_20_9","PRO","20","9","9","ເນົ່າ ກາ ຍັ່ນ ປາຍ ນ່ະໄນ່: \"ຣາງຶ່ຮ ເກົາ ບຣັຮ ອໍ ເລືອຍໆ. ກະ ເກົາ ແອິ ໂລ່ຍຮ ອຶນເຕົ່າ ເລີຍ”? ");
INSERT INTO ncq_vpl VALUES ("PR20_10","021_20_10","PRO","20","10","10","ເຢືາງ ເຈົາຣາຊີ ຊາອັຣ ກວາຍ ກາ ໂລ່ບ ແຕ ຊິງ, ກະ ເຕ່ກ ຕຳເປ່ກ ກາ ຕາ ເບີນ ປຍາຍ໌. ");
INSERT INTO ncq_vpl VALUES ("PR20_11","021_20_11","PRO","20","11","11","ອຶມປຶ່ ກັຣແນນ ລາ ອາປັຮ ໂອນ ເນົ່າ ເຮີມ ຣານະ ອັນ ຕະ; ເຈີ່ ໄຮ ດັງ ອັນ ລາ ກວາຍ ອໍ ກະ ຕານັ່ອງ ຕາປຶ່ງ ມາ ຕາ ເບີນ. ");
INSERT INTO ncq_vpl VALUES ("PR20_12","021_20_12","PRO","20","12","12","ເຢືາງ ເຈົາຣາຊີ ແຕງ ກູຕູຣ ໂອນ ໄຮ ຊາງັດ, ແຕງ ມັ່ດ ໂອນ ໄຮ ເນ່. ");
INSERT INTO ncq_vpl VALUES ("PR20_13","021_20_13","PRO","20","13","13","ກວາຍ ກາ ຢໍອ໌ ອີ ບິ ລຳແປ່ະ ລັງຮຍາ, ລາ ອັນ ແກີດ ກາດີດ; ກວາຍ ກູດຸ ຕະ ກາດະ ຈາ, ອັນ ລື່ ເບີນ ໂດຍ ພໍ ຈາ ອາກາ ພໍ ບຸຮ. ");
INSERT INTO ncq_vpl VALUES ("PR20_14","021_20_14","PRO","20","14","14","ກວາຍ ມັ່ກ ຕິ ປາຍ ເກຣີ່ງ ເປ່ງ ລາລື່, ມາ ແຕີ່ອ໌ ອັນ ລັ່ອຮ ແຕ ອຶນຕຸ ເນົ່າ ຈິ, ອັນ ໂອດ ປາຍ ອັນ ແຈີງ ອຶງແຮລ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR20_15","021_20_15","PRO","20","15","15","ປັຣນາຍ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ອາຕີ, ລາ ເບີນ ເກືາ ກາເລີຍ ແຕ ແຢງ ກະ ຕາເມົາ ເປ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR20_16","021_20_16","PRO","20","16","16","ຄັນ ກວາຍ ຊາກູລ ເບີນ ລັບ ຕູ່ ຕາງ ໂອນ ກວາຍ ຕາ ເບີນ ຊາກັ່ລ ມັ່ດ ຊາກັ່ດ ເມືາງ, ປຍາຍ໌ ເນົ່າ ອີດ ມູ່ນ ອັນ ປັງ ດໍອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR20_17","021_20_17","PRO","20","17","17","ເບີນ ເກຣີ່ງ ແຕ ຣາພິ, ລາ ນ່ະ ຣາແວັ່ຮ ປາຈົກ ລາລື່; ມາ ແວັດ ກັອຍ, ຕຶ່ງ ແບອ໌ ອັນ ເບີນ ແອີງ ຊັຣຮັນ ຊາງາຍ໌. ");
INSERT INTO ncq_vpl VALUES ("PR20_18","021_20_18","PRO","20","18","18","ປັຣນາຍ ຕຽຮ ອໍ ຕະ ໂອນ ຣານະ ແກີດ ແມິ່ມ; ອຶນໂຈຍ ເປາະ ຣາຈິ່ລ ຄັນ ຕາ ຢວາຮ ອາລັ່ອຮ ເງ່ ຣາຈິ່ລ. ");
INSERT INTO ncq_vpl VALUES ("PR20_19","021_20_19","PRO","20","19","19","ກວາຍ ອຶນຊອຍ໌ ແບອ໌ ຕາ ເຕ່ອ໌ ປາໂຕ່ະ ປັຣນາຍ ແກຣ່ະ; ອຶງເຄາະ ໄມ່ ແອີດ ເຢີ່ງ ແຕ ກວາຍ ປາຍ ລຶ່ບ ຕາ ລຶ່ບ. ");
INSERT INTO ncq_vpl VALUES ("PR20_20","021_20_20","PRO","20","20","20","ກວາຍ ເວ່ນ ອຶມເປ່ອ໌ ຕີອ໌ ອຶມປໍ່, ແດີຍ ອາມົ່ງ ອັນ ແກີດ ນ່ະ ຕາກຍາງ ປັຣຍຶ່ບ ປັດ ຕຶ່ງ ອຶນຕຸ ການຳ. ");
INSERT INTO ncq_vpl VALUES ("PR20_21","021_20_21","PRO","20","21","21","ມູ່ນ ກາ ເບີນ ລຳໂບຍ໌ ໂຕຍ໌ ລຳແບີ, ແຕີ່ອ໌ ປັຣຊົດ ມູ່ນ ກັອຍ ຕາ ເບີນ ເກືາ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR20_22","021_20_22","PRO","20","22","22","ອຶນໂຈຍ ປາຍ ນ່ະໄນ່: “ລື່ ເກົາ ກູລັຮ ແດີອ໌ ລັ່ຮ ຍ່ອນ ໄມ່ ຕະ ໂລ່ຍຮ ໂຈະ ເກົາ.” ມາ ອຶງເຄາະ ເຍືາ ອາກັ່ນ ເຢືາງ ເຈົາຣາຊີ, ຍ່ອນ ອັນ ເຕ່ອ໌ ຈ່ອຍ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("PR20_23","021_20_23","PRO","20","23","23","ເຢືາງ ເຈົາຣາຊີ ອຶງຄື່ນ ກວາຍ ແຕັດ ຊິງ ມາ ຕາ ເບີນ ປຍາຍ໌. ");
INSERT INTO ncq_vpl VALUES ("PR20_24","021_20_24","PRO","20","24","24","ກູ່ ຕັນຢັຮ ໄຮ ເປາະ, ລາ ເຢືາງ ເຈົາຣາຊີ ແຕິ່ ອາໂຢ່ງ ຣານາ ໄຮ. ຕາ ເບີນ ເນົ່າ ເຕ່ອ໌ ດັງ ແຕ ເຈືາດ ອັນ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("PR20_25","021_20_25","PRO","20","25","25","ອຶງເຄາະ ຄຶ່ດ ລາລື່ ເວືາຍ ແຕ ປັຣຄັນ ກະ ເຢືາງ ເຈົາຣາຊີ ປາຍ ອີ ມ່ອບ ຊາງ ເກຣີ່ງ ໂອນ ອັນ. ອຶງກັອຮ ປຍາຍ໌ ອຶນຕູ່ນ ກັອຍ, ເຍືາ ແກີດ ປາຊິ ຕາແອອ໌ ອີ ມ່ອບ ນັ່ອງ ເກຣີ່ງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR20_26","021_20_26","PRO","20","26","26","ເຕືາວ ປັຣເຍືາ ກາ ຣາໄງ່ອ໌ ຣາລັ່ງ, ເຕ່ອ໌ ອັນ ດັງ ອາແລ່ະ ກາ ຕະ ໂລ່ຍຮ, ເຈີ່ ອັນ ໂຈະ ໂຕ່ດ ແຕິ່ ກວາຍ ກັອຍ, ກະ ຕາ ເບີນ ອາໂຢ່ະ ຕະ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("PR20_27","021_20_27","PRO","20","27","27","ປັ່ງ ແຕ ເຢືາງ ເຈົາຣາຊີ ປາເລືາງ ຕາຕ່ອຍ໌ ເຮີມ ອຶນແຍ່ະ ມັຮ ຣາງຶ່ຮ ຣາແຮີ ກວາຍ, ກະ ມັຮ ມິ່ດ ໄລ່ ຄຶ່ດ. ");
INSERT INTO ncq_vpl VALUES ("PR20_28","021_20_28","PRO","20","28","28","ເຕືາວ ປັຣເຍືາ ເຕ່ອ໌ ແກີດ ຊົດ ດູ່ນ ຄັນ ອັນ ອາໂຢ່ງ ໂອນ ຣາຕອຍ ຣາເດີງ ຣາເຕີງ ຣາບັນ; ຄັນ ອັນ ຕາ ເບີນ ຮັກບັງ ຊັງບຍາງ, ລາ ເຢືາງ ເຈົາຣາຊີ ກູຣຍາອ໌ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR20_29","021_20_29","PRO","20","29","29","ກວາຍ ດຸ ຍ່ອງ ກວາຍ ນຸ່ມ ຍ່ອນ ໄລ່ ບັນ ເຣ່ງ; ກະ ກວາຍ ເທົາ ແກີດ ຊະເຢືາງ ປັຣເລືາງ ປາເນົາ ລາ ຍ່ອນ ໄລ່ ເບີນ ໂຊະ ປຼວາອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR20_30","021_20_30","PRO","20","30","30","ອໍ ໂອນ ຕະ ໂຕ່ດ ກວາຍ ອຶນຕັອງ ລາລື່, ຍ່ອນ ຣານະ ຕຸ່ຮ ກັ່ດ ກັອຍ ເຕ່ອ໌ ແອບ ໂອນ ກວາຍ ແກີດ ຣາງຶ່ຮ ຕາໄມ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR21_1","021_21_1","PRO","21","1","1","ເຢືາງ ເຈົາຣາຊີ ອາໂຢ່ງ ຣາງຶ່ຮ ເຕືາວ ປັຣເຍືາ, ນ່ະ ອັນ ອາວີ່ຮ ຣານາ ໂອນ ແດີອ໌ ປຼົຮ ປໍ ໄນ່ ປໍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR21_2","021_21_2","PRO","21","2","2","ກູ່ ຣານະ ກວາຍ ຕະ, ອັນ ຄຶ່ດ ປາຍ ປຍາຍ໌ ລາລື່ ເຈີ່, ມາ ເຢືາງ ເຈົາຣາຊີ ແອີດ ຊາລີອ໌ ເລືອຍໆ ຣາງຶ່ຮ ຣາແຮີ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("PR21_3","021_21_3","PRO","21","3","3","ເຢືາງ ເຈົາຣາຊີ ຢໍອ໌ ໄຮ ຕະ ຣານະ ຕານັ່ອງ ຕາປຶ່ງ ກະ ປຍາຍ໌ ອໍ, ກາເລີຍ ແຕ ອັນ ຢໍອ໌ ໄຮ ເດີງ ເກຣີ່ງ ມ່ອບ ຊາງ ໂອນ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR21_4","021_21_4","PRO","21","4","4","ກວາຍ ກາ ອາຊັອຮ ມັ່ດ ຕາແບງ ອາແຊງ ມັ່ດ ກູເຊົາ, ລາ ເບີນ ໂລ່ຍຮ ລາລື່; ຍ່ອນ ຣານະ ກັອຍ ອາປັຮ ໂອນ ເນົ່າ ເຮີມ ປາຍ ໄລ່ ລາ ກວາຍ ຕາ ອໍ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR21_5","021_21_5","PRO","21","5","5","ອາລັ່ອຮ ເງ່ ກຣັ່ກ ອໍ ກະ ກູດຸ ຕະ ກາດະ ຈາ, ຣາມຶ່ຮ ກັອຍ ຕະ ໂອນ ແກີດ ຊຸ ເບີນ; ມາ ຄັນ ຮັບ ກຸນເຕົາ ອີ ເບີນ ລຳໂບຍ໌ ໂຕຍ໌ ລຳແບີ, ລາ ຕະ ໂອນ ແກີດ ກາດີດ ແຕິ່. ");
INSERT INTO ncq_vpl VALUES ("PR21_6","021_21_6","PRO","21","6","6","ເບີນ ຕຽນ ວັ່ນ ຍ່ອນ ອາໂລກ, ແກີດ ປິ່ດ ໄຈ ລາລື່, ແກີດ ນ່ະ ຕາລຸ່ ກາ ປັຣຮຍາດ ຢາຢຍາຮ ກະ ນ່ະ ຕານ ຊາງ ກູວາງ ຈະ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("PR21_7","021_21_7","PRO","21","7","7","ມັຮ ກວາຍ ຕາ ອໍ ອຶງເຄາະ ຣາມົຮ ເກຣ່າະ ກຣຍາດ ຍ່ອນ ແຕ ຣານະ ຊາອ໌ ໄລ່ ຕະ; ໄລ່ ຕາ ມັ່ກ ລາລື່ ຕະ ຣານະ ປຍາຍ໌. ");
INSERT INTO ncq_vpl VALUES ("PR21_8","021_21_8","PRO","21","8","8","ມັຮ ກວາຍ ກາ ຕະ ຣານະ ໂລ່ຍຮ, ໄລ່ ເປາະ ຕຶ່ງ ຣານາ ໂກ່ະ ກີ່; ມາ ມັຮ ກວາຍ ກາ ມັນຕັ່ດ ມັນດຍາຮ, ໄລ່ ຕະ ຣານະ ຕານັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("PR21_9","021_21_9","PRO","21","9","9","ຄາອ໌ ແອີດ ຕຶ່ງ ຕຳປວລ ດຸງ, ແຕ ແອີດ ມວຍ ດຸງ ກະ ລາກວຍ ກາ ເຍ່າະ ອາເຍ່າະ ຍີ່ວ ອາຍີ່ວ. ");
INSERT INTO ncq_vpl VALUES ("PR21_10","021_21_10","PRO","21","10","10","ກວາຍ ຕາ ອໍ ແດັກ ປາແດັກ ຢໍອ໌ ອີ ຕະ ຣານະ ຕາ ອໍ; ອັນ ແອິ ເລີຍ ຣາງຶ່ຮ ອາໂຢ່ະ ຕະ ໂຈະ ກວາຍ ການໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR21_11","021_21_11","PRO","21","11","11","ແຕີ່ອ໌ ກວາຍ ຊາກູລ ເຮີມ ເນົ່າ ໂຈະ ໂຕ່ດ ກວາຍ ອາຊັອຮ ຈະ, ເຕ່ອ໌ ອັນ ຕາຕ່ອຍ໌ ແຕ ຣາມຶ່ຮ ກັອຍ; ແຕີ່ອ໌ ເນົ່າ ອາຕີ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ, ອັນ ເບີນ ດັງ ຊາອຶ່ຍ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR21_12","021_21_12","PRO","21","12","12","ເຢືາງ ເຈົາຣາຊີ ລາ ເຢືາງ ຕານັ່ອງ ອໍ, ອັນ ດັງ ອຶນແຍ່ະ ມັຮ ຣານະ ຕາ ອໍ ຕຶ່ງ ດຸງ ກວາຍ ແຣັ່ງ, ກະ ອັນ ຕະ ໂອນ ໄລ່ ແກີດ ແດັດ ປິ່ດ ຊາລີຣ. ");
INSERT INTO ncq_vpl VALUES ("PR21_13","021_21_13","PRO","21","13","13","ກວາຍ ກາ ຕາ ແອອ໌ ອີ ຊາງັດ ແຕີ່ອ໌ ກວາຍ ກາດີດ ແຊອ໌ ແຕ ອັນ, ລາ ຕາ ເບີນ ເນົ່າ ຊາງັດ ເຕ່ ແຕີ່ອ໌ ອັນ ແຊອ໌ ໂອນ ເນົ່າ ຈ່ອຍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR21_14","021_21_14","PRO","21","14","14","ຄັນ ກວາຍ ອາແລ່ະ ໂຍ່ບ, ເນົ່າ ເກືາຍ ແກຣ່ະໆ, ເຈີ່ ຣາງຶ່ຮ ອຶງຄື່ນ ກັອຍ ແກີດ ອຶງກ່ອຍ ປຣາຍ ລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("PR21_15","021_21_15","PRO","21","15","15","ກວາຍ ຕານັ່ອງ ອໍ ຊັອງ ຣໍ່ອ໌ ຣາງຶ່ຮ ແຕີ່ອ໌ ອັນ ເຮີມ ເນົ່າ ປັຣຈີນ ປຍາຍ໌ ອໍ; ມາ ມັຮ ກວາຍ ຕາ ອໍ, ໄລ່ ຊັອງ ເກຣ່າະ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR21_16","021_21_16","PRO","21","16","16","ອາກັນ ກູຈີດ ແອີດ ອາກັ່ນ ເລືອຍໆ, ກວາຍ ກາ ແອີດ ແຊີຍ ແຕ ຣານາ ກາ ປຍາຍ໌ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR21_17","021_21_17","PRO","21","17","17","ກວາຍ ກາ ມັ່ກ ງ່ອຍ໌ ຈາ ກູຕາ ກູລຍາອ໌, ມັ່ກ ຈາ ຊັຣນາ ເປ່ງ, ກວາຍ ກັອຍ ຕາ ເກີ່ຍ ແກີດ ຊຸ ເບີນ. ");
INSERT INTO ncq_vpl VALUES ("PR21_18","021_21_18","PRO","21","18","18","ຄັນ ມັຮ ກວາຍ ຕາ ອໍ ຈໍ່ອ໌ ເງ່ ອີ ຕະ ຕຸ່ຮ ກວາຍ ຕານັ່ອງ ອໍ, ເຈີ່ ຣາມຶ່ຮ ຕຸ່ຮ ກັອຍ ລື່ ແຕີ່ອ໌ ລັ່ຮ ປໍ ຈະ ໄລ່ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("PR21_19","021_21_19","PRO","21","19","19","ຄາອ໌ ແອີດ ຕຶ່ງ ຕຍາຮ, ແຕ ແອີດ ມວຍ ດຸງ ກະ ລາກວຍ ກາ ມັ່ກ ປູປົ່ກ ຊາແບລ ຊາກອລ. ");
INSERT INTO ncq_vpl VALUES ("PR21_20","021_21_20","PRO","21","20","20","ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ປາໂຣມ ມັຮ ມູ່ນມັ່ງ ຕຶ່ງ ດຸງ ອັນ; ມາ ກວາຍ ຊາກູລ, ມາແລ່ະ ອັນ ເບີນ ອັນ ຕັອກ ຈາ ປັຣຮຍາດ. ");
INSERT INTO ncq_vpl VALUES ("PR21_21","021_21_21","PRO","21","21","21","ກວາຍ ຕານັ່ອງ ຕາປຶ່ງ ກະ ເບີນ ຣາງຶ່ຮ ອາໂຢ່ະ ຕະ, ອັນ ແກີດ ກົງ ອາມົ່ງ ດູ່ນ; ເບີນ ເນົ່າ ຍ່ອງ ກະ ຊະເຢືາງ ປັຣເລືາງ ປາເນົາ. ");
INSERT INTO ncq_vpl VALUES ("PR21_22","021_21_22","PRO","21","22","22","ເນືາຍ ຕາຮານ ຣາໄງ່ອ໌ ຣາລັ່ງ, ເຕ່ອ໌ ອັນ ເຣືາບ ປູຣ ຕາລາ ເມືອງ ກາ ເບີນ ກຼຶ່ງ ຕາຮານ, ດິ່ຮ ຕາລຸຮ ວຍາງ ເມືອງ ຄຳ ກາ ມັຮ ກອນແຊມ ປັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("PR21_23","021_21_23","PRO","21","23","23","ກວາຍ ດັງ ກຍາອ໌ ເລືາຍຮ ເບີມ, ຣາມຶ່ຮ ຕຸ່ຮ ກັ່ດ ຕາ ເບີນ ແຕີ່ອ໌ ປໍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR21_24","021_21_24","PRO","21","24","24","ກວາຍ ອາຊັອຮ ຈະ ກະ ໂອດ ອົງ, ກວາຍ ກັອຍ ມັ່ກ ລາລື່ ພາມາດ ກວາຍ ການໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR21_25","021_21_25","PRO","21","25","25","ກວາຍ ປາງາຍ ຣຳແປັຮ ອີ ຕະ ຣານະ, ລາ ນ່ະ ອັນ ກາຈີດ ຈະ ອັນ ເບີມ; ");
INSERT INTO ncq_vpl VALUES ("PR21_26","021_21_26","PRO","21","26","26","ອັນ ກຸມປູ່ຣ ກູເວືາດ ຢໍອ໌ ອີ ເບີນ ເກຣີ່ງ ເກຣົ່າ ຊາອຶ່ຍ. ມາ ກວາຍ ຕານັ່ອງ ອໍ ຢໍອ໌ ອີ ຈ່ອຍ ກວາຍ ການໍ່ອ໌, ຍ່ອນ ອັນ ຕາຮັຣ. ");
INSERT INTO ncq_vpl VALUES ("PR21_27","021_21_27","PRO","21","27","27","ເຢືາງ ເຈົາຣາຊີ ຊາອັຣ ເກຣີ່ງ ກວາຍ ແຣັ່ງ ມ່ອບ ຊາງ; ໄລ່ ມ່ອບ ຊາງ ມາ ຣາງຶ່ຮ ໄລ່ ຄຶ່ດ ຕາ ເບີນ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR21_28","021_21_28","PRO","21","28","28","ກວາຍ ຕູນ ອາແປັດ ກວາຍ ການໍ່ອ໌, ລື່ ເນົ່າ ຕາ ເບີນ ຕາຕູ່ນ ປັຣນາຍ ອັນ; ມາ ກວາຍ ກາ ອາຕີ ປຍາຍ໌ ລາ ເນົ່າ ກຳ ຢຳ ປັຣນາຍ. ");
INSERT INTO ncq_vpl VALUES ("PR21_29","021_21_29","PRO","21","29","29","ກວາຍ ຕານັ່ອງ ອໍ ຄຶ່ດ ໂອນ ກຣັ່ກ ເວືາຍ ແຕ ຣານະ ອັນ ອີ ຕະ; ມາ ກວາຍ ຕາ ອໍ ຕະ ໂຈະ ໂອນ ເນົ່າ ຄຶ່ດ ປາຍ ອັນ ດັງ. ");
INSERT INTO ncq_vpl VALUES ("PR21_30","021_21_30","PRO","21","30","30","ອາກັນ ຣາໄງ່ອ໌ ຣາລັ່ງ ດັງ ຊາປຸ່ຮ ລາ ຕາຄຳ ເຢືາງ ເຈົາຣາຊີ ຄັນ ອັນ ຕາ ເບີນ ປຣ່ອມ. ");
INSERT INTO ncq_vpl VALUES ("PR21_31","021_21_31","PRO","21","31","31","ອຶມປຶ່ ເບີນ ມວຍ ຈຸ່ມ ອາແຊັຮ ກຽມ ດໍອ໌ ລັ່ອຮ ຣາຈິ່ລ, ມາ ແອີງ ເຢືາງ ເຈົາຣາຊີ ແຕິ່ ໂອນ ເຕ່ອ໌ ຣາຈິ່ລ ເຣືາບ. ");
INSERT INTO ncq_vpl VALUES ("PR22_1","021_22_1","PRO","22","1","1","ຄັນ ເນົ່າ ປາຣຽຮ ແຕ ຊຸ ເບີນ ກະ ດັອຮ ບຸມບວລ ຮູລ ຢຸນຢົ່ງ, ອໍ ໂອນ ຣຽຮ ອີດ ດັອຮ ບຸມບວລ ຮູລ ຢຸນຢົ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR22_2","021_22_2","PRO","22","2","2","ກວາຍ ຊຸ ກະ ກວາຍ ກາດີດ ເບີນ ມວຍ ຣາມຶ່ຮ ກາ ມູເຈິງ, ບາຣ ນະ ໄລ່ ລາ ເຢືາງ ເຈົາຣາຊີ ແຕິ່ ກາ ແຕງ. ");
INSERT INTO ncq_vpl VALUES ("PR22_3","021_22_3","PRO","22","3","3","ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ເຮີມ ເຕຣົາຕຣູລ ອີ ແຕີ່ອ໌ ປໍ ອັນ; ນ່ະກັອຍ ອັນ ວຍາຣ ຕັຮ ແຕ ຣາມຶ່ຮ ກັອຍ; ມາ ກວາຍ ຕາ ເບີນ ດັງ ອຶນເຕົ່າ, ອັນ ລາລີວ ເປາະ, ເຈີ່ ອັນ ຣາມົຮ ເລືອຍໆ ຣາມຶ່ຮ ຕຸ່ຮ ກັ່ດ. ");
INSERT INTO ncq_vpl VALUES ("PR22_4","021_22_4","PRO","22","4","4","ຄັນ ກວາຍ ຕະ ຕາປູ່ນ ເຢືາງ ເຈົາຣາຊີ ກະ ອາແຊງ ຈະ ເບີມ, ລື່ ອັນ ແກີດ ຊຸ ເບີນ ເຕີນ ປໍອ໌; ຊະເຢືາງ ປັຣເລືາງ ປາເນົາ, ກະ ແກີດ ກົງ ອາມົ່ງ ດູ່ນ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("PR22_5","021_22_5","PRO","22","5","5","ມັຮ ຣານາ ກວາຍ ຕາ ອໍ ເປາະ ເບີນ ແອີງ ຣາບາງ ກະ ຊັຣເລືາ; ມາ ກວາຍ ດັງ ກຍາອ໌ ອໍ ແດີຍ ອາມົ່ງ, ອັນ ເຕ່ອ໌ ວຍາຣ ແວັດ ແຕ ຣາມຶ່ຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR22_6","021_22_6","PRO","22","6","6","ອຶງເຄາະ ອາຣຍານ ປາຕັບ ປານໍ ປາຕໍ ປາກິ່ຣ ມັຮ ກອນ, ເຈີ່ ແຕີ່ອ໌ ອຶນຕູ່ນ ໄລ່ ຕະ ຕາປູ່ນ ເລືອຍໆ ຊົດ ແດີຍ ອາມົ່ງ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("PR22_7","021_22_7","PRO","22","7","7","ມັຮ ກວາຍ ກາດີດ ແກີດ ຊູລ ໂອນ ກວາຍ ຊຸ; ກວາຍ ກາ ວ່ະ ປຣະ, ອັນ ແກີດ ຊູລ ໂອນ ກວາຍ ກາ ອາວະ. ");
INSERT INTO ncq_vpl VALUES ("PR22_8","021_22_8","PRO","22","8","8","ກວາຍ ກາ ຕຣຶ່ຮ ຣາມຶ່ຮ ຕາ ອໍ, ອັນ ເບີນ ຊອດ ຣາມຶ່ຮ ຕຸ່ຮ ກັ່ດ; ກະ ກວາຍ ອາແລ່ະ ດົຮ ກວາຍ ການໍ່ອ໌, ປັຣແນີ ມັນເຕຣືາ ຣານະ ອັນ ແກີດ ປິ່ດ ເມືາດ. ");
INSERT INTO ncq_vpl VALUES ("PR22_9","021_22_9","PRO","22","9","9","ອຶງເຄາະ ໄມ່ ເບີນ ຣາງຶ່ຮ ຣາແຮີ ຕາຮັຣ ກະ ອຶມແປອ໌ ຊັຣນາ ໂອນ ກວາຍ ກາດີດ, ເຈີ່ ບຸ່ນ ເກີ່ຍ ຣາແອີຍ ປັ່ນ ແຕີ່ອ໌ ປໍ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("PR22_10","021_22_10","PRO","22","10","10","ຄັນ ຕູ່ຍຮ ອາລັ່ອຮ ກວາຍ ດຸ ຣາໂລຍຮ, ຕາ ເບີນ ເບີນ ນັ່ອງ ຣານະ ຣາຈຽນ ຣາຕວາອ໌, ແຕີລາ ຣາໂລຍຮ ຣາແລັຮ ຣາແຈັ່ຮ ຣາຢັອງ. ");
INSERT INTO ncq_vpl VALUES ("PR22_11","021_22_11","PRO","22","11","11","ກວາຍ ເບີນ ຣາງຶ່ຮ ບຣັຮ ອໍ ກະ ຕະ ອຶນຕີ ປັຣນາຍ ລາເມ່ນ ອໍ, ລື່ ເຕືາວ ປັຣເຍືາ ຢໍອ໌ ອີ ແກີດ ເຢົ່າ ກະ ອັນ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR22_12","021_22_12","PRO","22","12","12","ເຢືາງ ເຈົາຣາຊີ ກຸ່ມກຍາອ໌ ເລືອຍໆ ຣາມຶ່ຮ ປຍາຍ໌; ມາ ອັນ ຕະ ໂອນ ປັຣນາຍ ກວາຍ ຕະ ອຶນຕີ ອາໂລກ ແກີດ ແດັດ ປິ່ດ ຊາລີຣ. ");
INSERT INTO ncq_vpl VALUES ("PR22_13","021_22_13","PRO","22","13","13","ກວາຍ ອາລັ່ຮ ຢໍອ໌ ອີ ແອີດ ອຶນດຸງ ເລືອຍໆ; ອັນ ປາຍ ອາເກີນ ນ່ະໄນ່: “ອຶງກັອຮ ປຍາຍ໌ ເບີນ ກູຊັນ ເກຣາະ ຕຶ່ງ ຣານາ ກູລາ ເກຣາະ ຕຶ່ງ ກາຕຣໍ່ ອີ ກັບ ຈາ ເກົາ.” ");
INSERT INTO ncq_vpl VALUES ("PR22_14","021_22_14","PRO","22","14","14","ມັນແຊມ ກາ ເປາະ ປັຣລື່ຍ, ລາ ນ່ະ ອັນ ປິ່ ປຣຸ່ງ ໂອນ ປັອງ ຕໍ ຊາຣັອງ ໂອນ ຈວາດ; ປຣຸ່ງ ໄນ່ ແອີດ ເກຣາະ ກວາຍ ກາ ຕະ ໂອນ ເຢືາງ ເຈົາຣາຊີ ອຶງຄື່ນ ຊາປິ່ລ ອາແຊງ. ");
INSERT INTO ncq_vpl VALUES ("PR22_15","021_22_15","PRO","22","15","15","ກັຣແນນ ດຸ ຕະ ມາເລີ່ຍ໌ ມາເລີ່ງ, ມາ ເຕ່ອ໌ ເນົ່າ ແອບ ອາຕີ ອັນ ໂອນ ຕະ ຣານະ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR22_16","021_22_16","PRO","22","16","16","ກວາຍ ອາແລ່ະ ເດີງ ຣັງອອຍ ຊາດາລ ມັ່ດ ໂອນ ກວາຍ ຊຸ, ແຕີລາ ຕະ ຕຸ່ຮ ກວາຍ ກາດີດ ຍ່ອນ ຢໍອ໌ ອີ ແກີດ ຊຸ ເຕ່, ກວາຍ ກັອຍ ລື່ ຕະ ໂອນ ຈະ ອັນ ເບີມ ແອິ ຊັຣນາ ເລືາ ອຶນແຕີດ. ");
INSERT INTO ncq_vpl VALUES ("PR22_17","021_22_17","PRO","22","17","17","ອຶງເຄາະ ໄມ່ ຊາງັດ ນໍ! ເກົາ ອີ ອາຣຍານ ໂອນ ໄມ່ ດັງ ແຕ ມັຮ ປັຣນາຍ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ; ອຶງເຄາະ ໄມ່ ຣຍານ ແຕ ມັຮ ຣາມຶ່ຮ ເກົາ ອາຕີ. ");
INSERT INTO ncq_vpl VALUES ("PR22_18","021_22_18","PRO","22","18","18","ຄັນ ໄມ່ ຊາແຍີ ກະ ເຕ່ອ໌ ອາຕີ ລັ່ຮ ມັຮ ຣາມຶ່ຮ ໄນ່, ລື່ ໄມ່ ແກີດ ຣໍ່ອ໌ ບູຍ. ");
INSERT INTO ncq_vpl VALUES ("PR22_19","021_22_19","PRO","22","19","19","ເກົາ ຢໍອ໌ ໄມ່ ຊາອຳ ເຢືາງ ເຈົາຣາຊີ ອຶນແຍ່ະ ຣາງຶ່ຮ ຣາແຮີ; ຍ່ອນ ນ່ະກັອຍ ເກົາ ອາຕີ ໄມ່ ແຕ ປັຣນາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("PR22_20","021_22_20","PRO","22","20","20","ເກົາ ຄຽນ ໄປ ຈິ່ດ ປັຣນາຍ ຕຽຮ ໄນ່ ໂອນ ໄມ່, ຢໍອ໌ ໄມ່ ດັງ ກະ ຊາປຸ່ຮ ແຕ ຣາມຶ່ຮ ອໍ ລາລື່ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("PR22_21","021_22_21","PRO","22","21","21","ມັຮ ຣາມຶ່ຮ ໄນ່ ອີ ອາຣຍານ ໄມ່ ໂອນ ດັງ ແຕ ມັຮ ຣາມຶ່ຮ ປຍາຍ໌ ລາລື່. ກະ ຄັນ ເນົ່າ ແປຣີ ໄມ່ ເປາະ ຈໍ່ອ໌ ຣາມຶ່ຮ ປຍາຍ໌ ກັອຍ, ລາ ໄມ່ ເຕ່ອ໌ ເດີງ ອາເຈົາ ປັຣນາຍ ຕາແອີຍ ປຍາຍ໌ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR22_22","021_22_22","PRO","22","22","22","ອຶນໂຈຍ ກຸມປູ່ຣ ກວາຍ ກາດີດ ຍ່ອນ ເຍືາ ເບີນ ອຳນາດ ກາເລີຍ ແຕ ໄລ່; ອຶນໂຈຍ ຕະ ຕຸ່ຮ ກວາຍ ກາ ຕາ ເບີນ ເນົ່າ ຣາປາຍ ຈ່ອຍ ປໍ ອຶນຕຸ ປັຣຈີນ ປັຣນາຍ. ");
INSERT INTO ncq_vpl VALUES ("PR22_23","021_22_23","PRO","22","23","23","ຍ່ອນ ເຢືາງ ເຈົາຣາຊີ ຕະ ປັຣນາຍ ຈ່ອຍ ໄລ່, ກະ ອັນ ຕາເຕາະ ອີ ຕະ ເລືອຍໆ ແດີຍ ອາມົ່ງ ກວາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR22_24","021_22_24","PRO","22","24","24","ອຶນໂຈຍ ຣາຕອຍ ກະ ກວາຍ ອາຕູຍຮ ປັຣໄງຮ ອາໄຕຮ ປັຣງັອງ, ອັນ ກາ ຕີອ໌ ຣາງິ່ລ ຈິ່ລ ກູແຕອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR22_25","021_22_25","PRO","22","25","25","ອຶງກັອຮ ປຍາຍ໌ ໄມ່ ຣາປັ່ດ ມູ່ລ ຣາບູລ ລຶ່ມ, ເຈີ່ ຕາ ເຕ່ອ໌ ຣາປຽນ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("PR22_26","021_22_26","PRO","22","26","26","ອຶນໂຈຍ ກ່ຳ ຕູ່ ຕາງ ເຢົ່າ, ແຕີລາ ລັບ ຕູ່ ໂອນ ກວາຍ ການໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR22_27","021_22_27","PRO","22","27","27","ຄັນ ໄມ່ ມາ ຕາ ເບີນ ອຶນເຕົ່າ ອີ ກູລັຮ ຕູ່, ກາ ອຶນຕິ ໄມ່ ບິ ລາ ປັຣຮຍາດ ອຶນແຍ່ະ ເນົ່າ ອີດ. ");
INSERT INTO ncq_vpl VALUES ("PR22_28","021_22_28","PRO","22","28","28","ອຶນໂຈຍ ອາລຽນ ລັກ ຣາລັ່ນ ຕຍາ, ກາ ອາຈວາຍຮ ອາເຈ່ຮ ເຍືາ ຈົຮ ດໍອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR22_29","021_22_29","PRO","22","29","29","ຄັນ ໄມ່ ເຮີມ ເບີນ ກວາຍ ເຈືາງ ຕະ ຣານະ ອໍ, ກວາຍ ກັອຍ ເຕ່ອ໌ ຕະ ຣານະ ໂອນ ເຕືາວ ປັຣເຍືາ, ຕາ ແກີນ ໂອນ ກວາຍ ເມືາດ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("PR23_1","021_23_1","PRO","23","1","1","ແຕີ່ອ໌ ໄມ່ ຕາກູ ຈາ ກະ ກວາຍ ເບີນ ອຳນາດ, ອຶງເຄາະ ໄມ່ ຄຶ່ດ ໂອນ ອໍ, ອັນ ກາ ບັອງ ຈູຈາ ກະ ໄມ່ ລາ ເນົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR23_2","021_23_2","PRO","23","2","2","ຄັນ ໄມ່ ເກີ່ຍ ຈາ ຊາອຶ່ຍ, ອຶງເຄາະ ໄມ່ ອົດ ເວືາຍ. ");
INSERT INTO ncq_vpl VALUES ("PR23_3","021_23_3","PRO","23","3","3","ອຶນໂຈຍ ມັ່ກ ຊັຣນາ ອັນ ອາລັ່ອຮ ໂອນ ຈາ; ອຶງກັອຮ ປຍາຍ໌ ອັນ ອາລັ່ອຮ ເງ່ ຣາພິ ໄມ່ ລາ ເບີນ. ");
INSERT INTO ncq_vpl VALUES ("PR23_4","021_23_4","PRO","23","4","4","ອຶງເຄາະ ໄມ່ ຣາໄງ່ອ໌ ຣາລັ່ງ ແຕີ່ອ໌ ໄມ່ ຕະ ຣານະ; ອຶນໂຈຍ ຕະ ລວາດ ງື່ ຍ່ອນ ອີ ເບີນ ຕຽນວັ່ນ ຊາປັ່ນ ປຣະ ຊາອຶ່ຍ; ");
INSERT INTO ncq_vpl VALUES ("PR23_5","021_23_5","PRO","23","5","5","ຍ່ອນ ປຣະ ໄມ່ ເຕ່ອ໌ ປິ່ດ ຕຶ່ງ ມວຍ ກັຣແບັຮ ມັ່ດ ຊັອງ, ນ່ະ ອັນ ເບີນ ຊານັງ ປັຣ ມູເຈິງ ກາລາງ ອາກຣຶ່. ");
INSERT INTO ncq_vpl VALUES ("PR23_6","021_23_6","PRO","23","6","6","ອຶນໂຈຍ ຈາ ມັນຕຸ ກະ ກວາຍ ປັຣຈົ່ກ, ແຕີລາ ມັ່ກ ຊັຣນາ ແອມ ກາ ອັນ ອາລັ່ອຮ ໂອນ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("PR23_7","021_23_7","PRO","23","7","7","ອັນ ປາຍ ນ່ະໄນ່: “ແຊອ໌ ການື່ຍ ໄມ່ ຈາ ກະ ອັອຮ ເຕີມ ແອັນ,” ມາ ຕາ ແກີນ ລື່ ນ່ະກັອຍ, ຍ່ອນ ອັນ ຊັອງ ໂລ່ ລາລື່ ແຕ ມັຮ ຊັຣນາ ອັນ ອາລັ່ອຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR23_8","021_23_8","PRO","23","8","8","ລື່ ໄມ່ ກູຕາ ອາລັ່ອຮ ລັ່ຮ ອຶນແຍ່ະ ມັຮ ຊັຣນາ ກາ ໄມ່ ຈາ, ກະ ມັຮ ປັຣນາຍ ກາ ໄມ່ ອາເຈີ່ນ ອັນ ຕາ ເບີນ ແກີດ ເກືາ ອຶນເຕົ່າ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("PR23_9","021_23_9","PRO","23","9","9","ອຶນໂຈຍ ປູປົ່ຮ ແບອ໌ ນັ່ອງ ອາຕີ ກວາຍ ຊາກູລ ໂອນ ດັງ, ຍ່ອນ ອັນ ຕາ ດັງ ປາຊິ ມັຮ ຣາມຶ່ຮ ຣາໄງ່ອ໌ ຣາລັ່ງ ກາ ໄມ່ ອາຕີ. ");
INSERT INTO ncq_vpl VALUES ("PR23_10","021_23_10","PRO","23","10","10","ອຶນໂຈຍ ອາລຽນ ລັກ ຣາລັ່ນ ຕຍາ, ກະ ອຶນໂຈຍ ໂລ່ບ ກູແຕອ໌ ກອນ ກູມູ່ຍ໌, ");
INSERT INTO ncq_vpl VALUES ("PR23_11","021_23_11","PRO","23","11","11","ຍ່ອນ ເຢືາງ ເຈົາຣາຊີ ກາ ເຣ່ງ ລາລື່ ກຸ່ມກຍາອ໌ ໄລ່, ກະ ອັນ ແຕິ່ ອີ ຣາປາຍ ກະ ໄມ່ ຕາງ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("PR23_12","021_23_12","PRO","23","12","12","ອຶງເຄາະ ໄມ່ ເຈີ ດໍອ໌ ລາລື່ ແຕ ມັຮ ປັຣນາຍ ເນົ່າ ອາຕີ, ກະ ຣຍານ ໂອນ ກຣັ່ກ ມາແລ່ະ ໄມ່ ເຣືາບ ຣຍານ. ");
INSERT INTO ncq_vpl VALUES ("PR23_13","021_23_13","PRO","23","13","13","ອຶນໂຈຍ ອາລັ່ຮ ອີ ມັນຣາບ ກອນ ເຍືາ. ຄັນ ເຍືາ ວັ່ດ ອັນ ແຕ ຣາວັ່ດ, ລາ ອັນ ຕາ ເບີນ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("PR23_14","021_23_14","PRO","23","14","14","ເຍືາ ຕະ ນ່ະກັອຍ, ລາ ຈ່ອຍ ແດີຍ ອາມົ່ງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR23_15","021_23_15","PRO","23","15","15","ກອນ ເອີຍ! ຄັນ ໄມ່ ມາ ເບີນ ຣາງຶ່ຮ ຣາໄງ່ອ໌ ຣາລັ່ງ, ເກົາ ກາ ອຶມປໍ່ ຊັອງ ຣໍ່ອ໌ ຣາງຶ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("PR23_16","021_23_16","PRO","23","16","16","ອຶມປໍ່ ໄມ່ ຣໍ່ອ໌ ຣາງຶ່ຮ, ແຕີ່ອ໌ ຊັອງ ກອນ ອັນ ຕະ ອຶນຕີ ແອີງ ປັຣນາຍ ປຍາຍ໌. ");
INSERT INTO ncq_vpl VALUES ("PR23_17","021_23_17","PRO","23","17","17","ອຶນໂຈຍ ຊັຣແມງ ແຕ ມັຮ ກວາຍ ໂລ່ຍຮ; ມາ ຊົດ ແດີຍ ອາມົ່ງ ໄມ່ ອຶງເຄາະ ໄມ່ ຢຳນັ່ບ ເລືອຍໆ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("PR23_18","021_23_18","PRO","23","18","18","ຄັນ ໄມ່ ຕະ ນ່ະກັອຍ, ລາ ໄມ່ ອຶງກ່ອງ ເບີນ ແດີຍ ອາມົ່ງ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR23_19","021_23_19","PRO","23","19","19","ກອນ ເອີຍ! ອຶງເຄາະ ໄມ່ ຊາງັດ ນໍ! ອຶງເຄາະ ໄມ່ ຣາໄງ່ອ໌ ຣາລັ່ງ ເລືອຍໆ, ກະ ຄຶ່ດ ໂອນ ກຣັ່ກ ແຕ ແດີຍ ອາມົ່ງ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("PR23_20","021_23_20","PRO","23","20","20","ອຶນໂຈຍ ຣາຕອຍ ກະ ກວາຍ ມັ່ກ ງ່ອຍ໌ ຈາ ກູຕາ ກູລຍາອ໌, ແຕີລາ ກວາຍ ກາ ມັ່ກ ແຈັ່ຮ ກຸ່ມປູ່ຣ. ");
INSERT INTO ncq_vpl VALUES ("PR23_21","021_23_21","PRO","23","21","21","ກວາຍ ມັ່ກ ບູລ ບຼັອງ ກະ ຈາ ຊາອຶ່ຍ ລື່ ແກີດ ກາດີດ. ຄັນ ໄມ່ ມັ່ກ ຈາ ງ່ອຍ໌ ກະ ບິ ຊັອງ, ຕາ ເບີນ ດູ່ນ ໄມ່ ຕັອກ ເກຣີ່ງ ຣາແຮອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR23_22","021_23_22","PRO","23","22","22","ອຶງເຄາະ ໄມ່ ຊາງັດ ປັຣນາຍ ອຶມເປ່ອ໌ ອຶມປໍ່ ກາ ອາເມືາ ໂອນ ໄມ່ ເບີນ ອາມົ່ງ. ອຶນໂຈຍ ຕັຮ ຊະເຢືາງ ໄລ່ ແຕີ່ອ໌ ໄລ່ ເທົາ. ");
INSERT INTO ncq_vpl VALUES ("PR23_23","021_23_23","PRO","23","23","23","ອຶງເຄາະ ໄມ່ ຈໍ່ອ໌ ຣາມຶ່ຮ ປຍາຍ໌; ອຶງເຄາະ ໄມ່ ຈໍ່ອ໌ ຣາໄງ່ອ໌ ຣາລັ່ງ ກະ ຣຍານ ໂອນ ດັງ ແຈງ, ຍ່ອນ ມັຮ ຣາມຶ່ຮ ກັອຍ ເບີນ ເກືາ ລາລື່; ອໍ ໂອນ ໄມ່ ປາຊິ, ກະ ອຶນໂຈຍ ຕັຮ. ");
INSERT INTO ncq_vpl VALUES ("PR23_24","021_23_24","PRO","23","24","24","ອຶມປໍ່ ຊັອງ ຣໍ່ອ໌ ແຕີ່ອ໌ ອັນ ເຮີມ ກອນ ແກີດ ກວາຍ ຕານັ່ອງ ອໍ. ແຕີ່ອ໌ ກອນ ເບີນ ຣາງຶ່ຮ ຣາໄງ່ອ໌ ຣາລັ່ງ, ອຶມປໍ່ ແກີດ ຣໍ່ອ໌ ຣາງຶ່ຮ ຊັນຕຣຸ່ຮ ລ່ອມ. ");
INSERT INTO ncq_vpl VALUES ("PR23_25","021_23_25","PRO","23","25","25","ອຶງເຄາະ ໄມ່ ຕະ ໂອນ ອຶມເປ່ອ໌ ອຶມປໍ່ ຊັອງ ຣໍ່ອ໌ ບູຍ ແຕ ໄມ່, ກະ ອຶງເຄາະ ຕະ ໂອນ ອັນ ກາ ຣັ່ຮ ໄມ່ ແກີດ ລາແຮີຍ ລາແຕິ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("PR23_26","021_23_26","PRO","23","26","26","ກອນ ເອີຍ! ອຶງເຄາະ ໄມ່ ຣັ່ບ ອີດ ໂອນ ອໍ ມັຮ ຣາມຶ່ຮ ອຶມປໍ່ ໄມ່ ອາຕີ, ກະ ດວຍ໌ ເຕຣ່ງ ອຶມປໍ່ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("PR23_27","021_23_27","PRO","23","27","27","ມັນແຊມ ຈິ ຈະ ກະ ມັນແຊມ ຕີນ ອາລ່ອງ ບາຣ ໄປ ອາໄລ່ ປູນ ເຊີງ, ໄລ່ ເດີງ ກວາຍ ຊາປິ່ລ ປຣຸ່ງ ຮັອງ ປັອງ ປຶ່ຮ ແລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("PR23_28","021_23_28","PRO","23","28","28","ມັຮ ມັນແຊມ ກັອຍ ແອີດ ຈ່ອມ ເນ່ ນ່ະ ກວາຍ ຕູຕວຍ໌, ກະ ຕະ ໂອນ ຊາອຶ່ຍ ນະ ຣາເລົາ ຕາ ເບີນ ຕານັ່ອງ ຕາປຶ່ງ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("PR23_29","021_23_29","PRO","23","29","30","ເນົ່າ ອັນ ກາ ຊູໂຊຍ ຊາຊິຮ? ເນົ່າ ອັນ ກາ ຣາຈຽນ ຣາໂຊ? ໄນ່ ລາ ອັນ ກາ ມັ່ກ ງ່ອຍ໌ ບຼັອງ, ອັນ ຕາ ເກີ່ຍ ຕາງິ່ດ ກັຣຈຸ ຊາອຶ່ຍ ຊາແນັດ ບຼັອງ. ນ່ະກັອຍ, ເກົາ ອີ ໂອນ ໄມ່ ດັງ ຣາມຶ່ຮ ຕຸ່ຮ ອາຣຶ່ກ ແຕ ກວາຍ ກັອຍ. ອັນ ເບີນ ເລືອຍໆ ຣາມຶ່ຮ ຕຸ່ຮ ກັ່ດ, ອັນ ປູປົ່ກ ຕຸ່ຮ ເລືອຍໆ, ມັ່ດ ອັນ ກູເຊົາ ທົງພົງ, ກະ ຈະຈັ່ນ ອັນ ແກີດ ຕຣຸ່ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("PR23_31","021_23_31","PRO","23","31","31","ຍ່ອນ ນ່ະກັອຍ, ອຶນໂຈຍ ກູມິ່ ບຼັອງ ອາງຸ່ນ, ອຶມປຶ່ ອັນ ແກີດ ປູປົ່ຮ ກູເຊົາ ອໍ ລາລື່ ກະ ຣາລັ່ງ ແອມ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR23_32","021_23_32","PRO","23","32","32","ມາ ແວັດ ໄມ່ ງ່ອຍ໌ ໄມ່ ຊັອງ ຕິ່, ນ່ະ ກູຊັນ ເບີນ ປີ່ຮ ຕອດ. ");
INSERT INTO ncq_vpl VALUES ("PR23_33","021_23_33","PRO","23","33","33","ໄມ່ ແກີດ ການຳ ປິງ ກະ ລາເລືາຍ ມັ່ດ; ໄມ່ ແກີດ ແກຼິ ຕາ ເຕ່ອ໌ ຕະ ອຶນຕີ ໂອນ ແຈງ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("PR23_34","021_23_34","PRO","23","34","34","ໄມ່ ຊັອງ ນ່ະ ແອີດ ຕຶ່ງ ອຶນດີ ກຼົງ ທາເລ, ກະ ນ່ະ ແອີດ ຕຶ່ງ ຕົວະ ລາລິ່ກ ລາລັ່ອກ ຕາຕຶ່ງ ຕາໂຕະ ເຕົ່າ ຊາວີຣ ແປຼີ. ");
INSERT INTO ncq_vpl VALUES ("PR23_35","021_23_35","PRO","23","35","35","ເຈີ່ ໄມ່ ປາຍ ນ່ະໄນ່: “ຕາ ດັງ ເນົ່າ ຈົ່ກ ເກົາ; ຕາ ດັງ ເນົ່າ ຕັ່ຮ ເກົາ; ມາ ເກົາ ຕາ ເບີນ ຊັອງ ຕິ່, ກະ ຕາ ເບີນ ເຈີ ອຶນເຕົ່າ ເລີຍ. ມາແລ່ະ ແຕ ເກົາ ອີ ຕາແມີ; ເກົາ ອີ ຕອກ ລັ່ຮ ມວຍ ຈອກ ແອັນ.” ");
INSERT INTO ncq_vpl VALUES ("PR24_1","021_24_1","PRO","24","1","1","ອຶນໂຈຍ ຊັຣແມງ ແຕ ມັຮ ກວາຍ ຕາ ອໍ; ອຶນໂຈຍ ຣາຕອຍ ກະ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("PR24_2","021_24_2","PRO","24","2","2","ໄລ່ ຄຶ່ດ ເລືອຍໆ ອີ ຕະ ໂອນ ແກີດ ຣາລຸຮ; ແບອ໌ ໄລ່ ມັ່ກ ລາລື່ ຕະ ໂອນ ກວາຍ ການໍ່ອ໌ ຣາມົຮ ຕຸ່ຮ ກັ່ດ. ");
INSERT INTO ncq_vpl VALUES ("PR24_3","021_24_3","PRO","24","3","3","ຍ່ອນ ເບີນ ຣາໄງ່ອ໌ ຣາລັ່ງ ກະ ຊາປຸ່ຮ, ແຕ ເຕ່ອ໌ ເນົ່າ ປາຕຶ່ງ ດຸງ. ");
INSERT INTO ncq_vpl VALUES ("PR24_4","021_24_4","PRO","24","4","4","ຍ່ອນ ດັງ ຊາອຶ່ຍ ເງ່, ນ່ະກັອຍ ຕຶ່ງ ການົງ ດຸງ ປັ່ນ ແອີງ ເກຣີ່ງ ເປ່ງ ກະ ມັຮ ມູ່ນ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR24_5","021_24_5","PRO","24","5","5","ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ, ອັນ ລື່ ແກີດ ກວາຍ ເບີນ ອຳນາດ; ກະ ກວາຍ ດັງ ຊາອຶ່ຍ, ອັນ ແກີດ ເຣ່ງ ອາຊັອຮ. ");
INSERT INTO ncq_vpl VALUES ("PR24_6","021_24_6","PRO","24","6","6","ຄັນ ໄມ່ ຢໍອ໌ ອີ ມູ່ດ ປໍ ອຶນຕຸ ຣາຈິ່ລ, ອຶງເຄາະ ໄມ່ ອາລັ່ອຮ ເງ່ ຣາຈິ່ລ ອຶນໂຍ່ງ ເວືາຍ. ກະ ຄັນ ເບີນ ຊາອຶ່ຍ ນະ ກວາຍ ຕຽຮ, ເຕ່ອ໌ ໄມ່ ຣາຈິ່ລ ເຣືາບ. ");
INSERT INTO ncq_vpl VALUES ("PR24_7","021_24_7","PRO","24","7","7","ປັຣນາຍ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ປາຍ ລາ ອຶນຕຣູ່ ລາລື່; ກວາຍ ຊາກູລ ຕາ ເຕ່ອ໌ ຊາປຸ່ຮ ປັຣນາຍ ກັອຍ. ແຕີ່ອ໌ ເບີນ ຣາມຶ່ຮ ຊັຣຮົງ ແຈ່ະ ງັ່ຮ ຕົ່ງ ເມືອງ, ກວາຍ ຊາກູລ ຕາ ເບີນ ອຶນເຕົ່າ ອີ ປາຍ. ");
INSERT INTO ncq_vpl VALUES ("PR24_8","021_24_8","PRO","24","8","8","ຄັນ ໄມ່ ມາ ອາລັ່ອຮ ເລືອຍໆ ເງ່ ຕາ ອໍ, ກູ່ ນະ ກວາຍ ເບີນ ດັງ ລາ ໄມ່ ອາລັກ ອາແລວ໌. ");
INSERT INTO ncq_vpl VALUES ("PR24_9","021_24_9","PRO","24","9","9","ມັຮ ຣານະ ອຶນເຕົ່າ ກວາຍ ຊາກູລ ຄຶ່ດ ແກີດ ຣານະ ໂລ່ຍຮ ອຶນແຍ່ະ. ເນົ່າ ຊາອັຣ ກວາຍ ດຸ ອີ ກາຈັງ ເຈືາດ ພາມາດ ເຣືາງ ກວາຍ ການໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR24_10","021_24_10","PRO","24","10","10","ຄັນ ໄມ່ ເປ່ ຣາງຶ່ຮ ບັອງ ຣາມຶ່ຮ ຕຸ່ຮ ກັ່ດ ແຕີ່ອ໌, ເຈີ່ ບັນ ເຣ່ງ ໄມ່ ລື່ ແກີດ ອຽວ໌ ແຕິ່. ");
INSERT INTO ncq_vpl VALUES ("PR24_11","021_24_11","PRO","24","11","11","ອຶນໂຈຍ ກຣໍ ຣາຈ່ອຍ ກວາຍ ກາ ເນົ່າ ຮອຣ ອີ ກາຈີດ, ອຶມປຶ່ ກວາຍ ກັອຍ ຕາ ເບີນ ຕະ ໂລ່ຍຮ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR24_12","021_24_12","PRO","24","12","12","ຄັນ ໄມ່ ປາຍ ນ່ະໄນ່: “ຣາມຶ່ຮ ກັອຍ ຕາ ແກີນ ຣານະ ເກົາ.” ມາ ເຢືາງ ເຈົາຣາຊີ ແອີດ ເນ່ ເລືອຍໆ ໄມ່; ອັນ ດັງ ກູ່ ຣາມຶ່ຮ ຕຶ່ງ ຣາງຶ່ຮ ໄມ່, ກະ ອັນ ກູລັຮ ເກືາ ຕາປູ່ນ ຣານະ ກາ ໄມ່ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("PR24_13","021_24_13","PRO","24","13","13","ກອນ ເອີຍ! ອຶງເຄາະ ໄມ່ ງ່ອຍ໌ ແດີອ໌ ກາຮຍາລ, ຍ່ອນ ແດີອ໌ ກາຮຍາລ ກັອຍ ແອມ ລາລື່. ແດີອ໌ ກາຮຍາລ ກັອຍ ອຶງເງືາມ ຕຶ່ງ ເລືາຍຮ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("PR24_14","021_24_14","PRO","24","14","14","ອຶງເຄາະ ໄມ່ ດັງ ເຕ່ ລາ ຣາມຶ່ຮ ຣາໄງ່ອ໌ ຣາລັ່ງ ແກີດ ອໍ ໂອນ ແດີຍ ອາມົ່ງ ໄມ່. ອຶງເຄາະ ໄມ່ ຣັ່ບ ຣາໄງ່ອ໌ ຣາລັ່ງ, ເຈີ່ ປໍ ເມືາງ ໄມ່ ຕະ ແກີດ ແປີດ ແຮີຍ. ");
INSERT INTO ncq_vpl VALUES ("PR24_15","021_24_15","PRO","24","15","15","ອຶນໂຈຍ ແກີດ ນ່ະ ກວາຍ ຕາ ອໍ ອາລັ່ອຮ ເງ່ ອີ ປູຣ ກວາຍ ຕານັ່ອງ ອໍ, ແຕີລາ ໂລ່ບ ດຸງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR24_16","021_24_16","PRO","24","16","16","ຍ່ອນ ກວາຍ ຕານັ່ອງ ອໍ ແດິມ ຕາປູ່ລ ເຮີບ, ລາ ອັນ ຢວຣ ຕາຢຶ່ງ ລັ່ຮ; ມາ ຄັນ ກວາຍ ຕາ ອໍ ແດິມ ມູ ເຮີບ ຊັອງ, ລາ ອັນ ກູຈີດ ປິ່ດ ແດັດ ດຽລ. ");
INSERT INTO ncq_vpl VALUES ("PR24_17","021_24_17","PRO","24","17","17","ອຶນໂຈຍ ຊັອງ ຣໍ່ອ໌ ແຕີ່ອ໌ ກວາຍ ກາ ດໍອ໌ ມິ່ດ ຊາກິ່ດ ຣ່ອຍ໌ ກະ ໄມ່ ຣາມົຮ ຕຸ່ຮ ກັ່ດ, ກະ ອຶນໂຈຍ ຊັອງ ແອີນ ແຕີ່ອ໌ ອັນ ແດິມ. ");
INSERT INTO ncq_vpl VALUES ("PR24_18","021_24_18","PRO","24","18","18","ຄັນ ໄມ່ ມາ ປາອຽບ ອັນ ໂອນ ປຣຍາອ໌, ເຢືາງ ເຈົາຣາຊີ ດັງ, ກະ ອັນ ຕາ ເບີນ ຣໍ່ອ໌ ແຕ ຣາມຶ່ຮ ກັອຍ; ອຶງກັອຮ ປຍາຍ໌ ອັນ ຕາ ເບີນ ໂຈະ ໂຕ່ດ ກວາຍ ກັອຍ ລາ ເບີນ. ");
INSERT INTO ncq_vpl VALUES ("PR24_19","021_24_19","PRO","24","19","19","ອຶນໂຈຍ ຊັອງ ຕຸ່ຮ ຕຶ່ງ ຣາງຶ່ຮ ຣາແຮີ ຍ່ອນ ແຕ ກວາຍ ແຣັ່ງ; ອຶນໂຈຍ ຊັຣແມງ ກູມິ່ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("PR24_20","021_24_20","PRO","24","20","20","ຍ່ອນ ແດີຍ ອາມົ່ງ ກວາຍ ຕາ ອໍ ຕາ ເບີນ ອຶງກ່ອງ ແກີດ ອໍ ອຶນເຕົ່າ; ແດີຍ ອາມົ່ງ ອັນ ແກີດ ນ່ະ ຕາກຍາງ ກາ ລາລີວ ອີ ປັດ. ");
INSERT INTO ncq_vpl VALUES ("PR24_21","021_24_21","PRO","24","21","21","ກອນ ເອີຍ! ອຶງເຄາະ ໄມ່ ຢຳນັ່ບ ເຢືາງ ເຈົາຣາຊີ, ກະ ເຕືາວ ປັຣເຍືາ ແຮີ. ອຶນໂຈຍ ປຣ່ອມ ກະ ມັຮ ກວາຍ ກາ ຣາຄັດ ໂຈະ ເຢືາງ ເຈົາຣາຊີ ກະ ເຕືາວ ປັຣເຍືາ, ");
INSERT INTO ncq_vpl VALUES ("PR24_22","021_24_22","PRO","24","22","22","ຍ່ອນ ໄຈ ລາລື່ ກວາຍ ກາ ຕະ ນ່ະກັອຍ ອີ ຣາມົຮ ເກຣ່າະ ກຣຍາດ. ໄມ່ ຕາ ເຕ່ອ໌ ດັງ ຣາມຶ່ຮ ກູຈີດ ຊາແຣັຮ ຊາຣວຍ ອຶນເຕົ່າ ແອັນ ອີ ແຕີ່ອ໌ ປໍ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("PR24_23","021_24_23","PRO","24","23","23","ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ປາຍ ເຕີມ ແອັນ ນ່ະໄນ່: ລື່ ຕາ ເບີນ ປຍາຍ໌, ຄັນ ປັຣຈີນ ປັຣນາຍ ມາ ຮັກບັງ ຊັງບຍາງ. ");
INSERT INTO ncq_vpl VALUES ("PR24_24","021_24_24","PRO","24","24","24","ຄັນ ກວາຍ ປັຣຈີນ ປັຣນາຍ ມາ ປາຍ ກວາຍ ໂລ່ຍຮ ແກີດ ຕາ ເບີນ ໂລ່ຍຮ, ລື່ ປຍາຍ໌ ມັຮ ກວາຍ ອຶງຄື່ນ ກະ ເວ່ນ ອັນ ກາ ປັຣຈີນ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR24_25","021_24_25","PRO","24","25","25","ມາ ຄັນ ອັນ ປັຣຈີນ ໂອນ ກວາຍ ໂລ່ຍຮ ຣັ່ບ ໂຕ່ດ, ລາ ອັນ ເບີນ ຣັ່ບ ບຸ່ນ ເກີ່ຍ ຣາແອີຍ ປັ່ນ ຊະເຢືາງ ປັຣເລືາງ ປາເນົາ. ");
INSERT INTO ncq_vpl VALUES ("PR24_26","021_24_26","PRO","24","26","26","ກວາຍ ກາ ຕາແອີຍ ຕານັ່ອງ, ລື່ ອາປັຮ ອັນ ແກີດ ເຢົ່າ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("PR24_27","021_24_27","PRO","24","27","27","ອຶງເຄາະ ໄມ່ ຈັ່ດ ຈອຍ ໄທຣ ໄມ່ ໂອນ ແມິ່ມ ອຶນແຍ່ະ ເວືາຍ; ແວັດ ກັອຍ ແຕ ໄມ່ ຕະ ດຸງ ແອີດ. ");
INSERT INTO ncq_vpl VALUES ("PR24_28","021_24_28","PRO","24","28","28","ອຶນໂຈຍ ຕູນ ອາແປັດ ກວາຍ ການໍ່ອ໌ ບັອງ ເນົ່າ ຕັດຊີ່ນ; ກະ ອຶນໂຈຍ ອາໂລກ ກວາຍ ຕັດຊີ່ນ. ");
INSERT INTO ncq_vpl VALUES ("PR24_29","021_24_29","PRO","24","29","29","ອຶນໂຈຍ ປາຍ ນ່ະໄນ່: “ເກົາ ອີ ຕະ ລັ່ຮ ອັນ ນ່ະ ອັນ ຕະ ໂຈະ ເກົາ; ເກົາ ອີ ກູລັຮ ແດີອ໌ ລັ່ຮ ໂຈະ ອັນ.” ");
INSERT INTO ncq_vpl VALUES ("PR24_30","021_24_30","PRO","24","30","30","ເບີນ ມວຍ ຕາໄງ ເກົາ ເປາະ ຊາລັຮ ໄທຣ, ກະ ຊວນ ອາງຸ່ນ ກວາຍ ອາລັ່ຮ ກະ ຊາກູລ. ");
INSERT INTO ncq_vpl VALUES ("PR24_31","021_24_31","PRO","24","31","31","ຊວນ ກັອຍ ເບີນ ແອີງ ປູ່ລ ຊັຣເລືາ, ກະ ເບີນ ແອີງ ບັດ. ວຍາງ ຕາເມົາ ກາ ກຣ່ອງ ຊວນ ກັອຍ ລາ ຣາລຸຮ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("PR24_32","021_24_32","PRO","24","32","32","ເກົາ ແອີດ ຄຶ່ດ ກະ ຕາຕ່ອຍ໌ ແຕ ມັຮ ຣາມຶ່ຮ ກັອຍ, ເຈີ່ ເກົາ ດັງ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("PR24_33","021_24_33","PRO","24","33","33","ບິ ຕານັ່ອງ ອຶງກີງ ເວືາຍ, ກະ ຣາລູ່ ມາໂຮຍ; ");
INSERT INTO ncq_vpl VALUES ("PR24_34","021_24_34","PRO","24","34","34","ບັອງ ກັອຍ ແຕິ່, ຣາມຶ່ຮ ຕຸ່ຮ ກາດີດ ແຕີ່ອ໌ ປໍ ໄມ່ ນ່ະ ກວາຍ ຣາປົນ ແຕີ່ອ໌; ກະ ຣາມຶ່ຮ ຕຸ່ຮ ກູປາຍຮ ມາເຍືາຍຮ ໂດຍ ແຕີ່ອ໌ ນ່ະ ຊາແວງ ເດີງ ດາວ ແຕີ່ອ໌ ຣາຈິ່ລ ກະ ປົນ ອີດ ອຶນແຍ່ະ ເກຣີ່ງ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("PR25_1","021_25_1","PRO","25","1","1","ໄນ່ ລາ ມັຮ ປັຣນາຍ ປາລີ່ ພາຍາ ເຕືາວ ປັຣເຍືາ ໂຊໂລໂມນ ປາຍ ເຕີມ ແອັນ; ມັຮ ກວາຍ ຕະ ຣານະ ເຕືາວ ປັຣເຍືາ ເຮເຊກີຢາ ຕຶ່ງ ກຣວາງ ຢູດາຍ ຄຽນ ດວຍ໌ ລັ່ຮ ມັຮ ຣາມຶ່ຮ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("PR25_2","021_25_2","PRO","25","2","2","ກູ່ ຣານະ ກາ ເຢືາງ ເຈົາຣາຊີ ປາໂຕ່ະ ດໍອ໌ ລາ ອາປັຮ ອຳນາດ ອາງອື່ຣ ແຕ ອັນ; ກະ ກູ່ ຣາມຶ່ຮ ກາ ມັຮ ເຕືາວ ປັຣເຍືາ ອາລັ່ອຮ ໂອນ ດັງ, ລາ ອາປັຮ ອຳນາດ ປື່ດ ແຕ ອັນ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("PR25_3","021_25_3","PRO","25","3","3","ໄຮ ຕາ ເຕ່ອ໌ ດັງ ແຕ ມັຮ ຣານະ ເຕືາວ ປັຣເຍືາ ແອີດ ຄຶ່ດ; ຍ່ອນ ຣາງຶ່ຮ ອັນ ລາ ຕີ່ ກວາ ປຣັ່ຮ ຕາວັ່ຮ ກວາ ກຣວາງ. ");
INSERT INTO ncq_vpl VALUES ("PR25_4","021_25_4","PRO","25","4","4","ອຶງເຄາະ ໂຕະ ປຣະ ໂອນ ຊາແຣັຮ ລັ່ອຮ ອຶນແຍ່ະ ເວືາຍ, ເຈີ່ ກວາຍ ເຈືາງ ເຕ່ອ໌ ອີດ ປຣະ ກັອຍ ຕະ ເກຣີ່ງ ປັຣໂອດ. ");
INSERT INTO ncq_vpl VALUES ("PR25_5","021_25_5","PRO","25","5","5","ມູເຈິງ ກັອຍ ເຕ່, ອຶງເຄາະ ຕູ່ຍຮ ຕັຮ ມັຮ ກວາຍ ຕາ ອໍ ແຕ ເມືາງ ເຕືາວ ປັຣເຍືາ; ເຈີ່ ອັນ ເຕ່ອ໌ ຕະ ຊົດ ແກີດ ຈັບ ຍ່ອນ ອັນ ປັຣຈີນ ຕານັ່ອງ ຕາປຶ່ງ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR25_6","021_25_6","PRO","25","6","6","ແຕີ່ອ໌ ໄມ່ ຕາຢຶ່ງ ຢັ່ຮ ເມືາງ ເຕືາວ ປັຣເຍືາ, ໄມ່ ອຶນໂຈຍ ຕະ ນ່ະ ເນືາຍ. ");
INSERT INTO ncq_vpl VALUES ("PR25_7","021_25_7","PRO","25","7","7","ຄາອ໌ ໂອນ ເຕືາວ ປັຣເຍືາ ອາຊັອຮ ອຳນາດ ໄມ່, ແຕ ອັນ ອາລິ່ຮ ອຳນາດ ໄມ່ ກະ ໂອນ ກວາຍ ການໍ່ອ໌ ແອັນ ເຕ່ນ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("PR25_8","021_25_8","PRO","25","8","8","ແຕີ່ອ໌ ໄມ່ ເຮີມ ເນົ່າ ຕະ ຣານະ ຕາ ອໍ ອຶນເຕົ່າ, ອຶນໂຈຍ ກຸນເຕົາ ອາແຕີ່ອ໌ ປໍ ອຶນຕຸ ປັຣຈີນ ປັຣນາຍ. ອຶງກັອຮ ປຍາຍ໌ ເບີນ ກວາຍ ປາຍ ກູໂຕ ໄມ່ ແຕິ່ ກາ ຕະ ໂລ່ຍຮ, ຄັນ ນ່ະກັອຍ ນານ່ະ ໄມ່ ອີ ຕະ? ");
INSERT INTO ncq_vpl VALUES ("PR25_9","021_25_9","PRO","25","9","9","ຄັນ ໄມ່ ກະ ເຢົ່າ ໄມ່ ມາ ເບີນ ອຶມພາ ເງ່, ອຶງເຄາະ ເຍືາ ຊັຣຮົງ ເວືາຍ, ກະ ອຶນໂຈຍ ອາຕີ ກວາຍ ການໍ່ອ໌ ປັຣນາຍ ແກຣ່ະ ກາ ເຍືາ ຊັຣຮົງ. ");
INSERT INTO ncq_vpl VALUES ("PR25_10","021_25_10","PRO","25","10","10","ຄັນ ຕາ ເບີນ ນ່ະກັອຍ, ກູ່ ນະ ດັງ ໄມ່ ຕາ ເຣືາບ ຢຸມ ຣາມຶ່ຮ ແກຣ່ະ; ເຈີ່ ໄມ່ ແກີດ ກູມາລ ຕະ ຕາ ເກີ່ຍ ປິ່ດ ຊົດ ອາຍຸ່ ຈຸ ກັຣວາງ. ");
INSERT INTO ncq_vpl VALUES ("PR25_11","021_25_11","PRO","25","11","11","ຄັນ ເນົ່າ ອາຕີ ເງ່ ອໍ ກະ ແຈງ, ໄນ່ ລາ ນ່ະ ຣູ່ບ ເນົ່າ ລູ່ບ ແຕ ປຣະ ແຢງ. ");
INSERT INTO ncq_vpl VALUES ("PR25_12","021_25_12","PRO","25","12","12","ກວາຍ ກາ ຊາງັດ ປັຣນາຍ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ຕຽຮ, ລາ ອັນ ຣັ່ບ ເກືາ ກາເລີຍ ແຕ ແວນ, ແຕີລາ ເກຣີ່ງ ປັຣໂອດ ກາ ຕະ ແຕ ແຢງ ກາ ເຈຍ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR25_13","021_25_13","PRO","25","13","13","ນ່ະ ແດີອ໌ ຢິນ ຕະ ໂອນ ກວາຍ ຊູຊອດ ແກີດ ລາຮາງ; ກວາຍ ຕະ ຣານະ ຕານັ່ອງ ຕາປຶ່ງ, ຕະ ໂອນ ກວາຍ ກາ ແປຣີ ອັນ ເປາະ ຊັອງ ຣໍ່ອ໌ ຣາງຶ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("PR25_14","021_25_14","PRO","25","14","14","ກວາຍ ກາ ເອີອ໌ ອີ ໂອນ ຣັງອອຍ ມາ ອັນ ຕາ ເບີນ ໂອນ, ລາ ມູເຈິງ ເບີນ ຣາມິ່ລ ກະ ກູຢາລ, ມາ ຕາ ເບີນ ເມືາ. ");
INSERT INTO ncq_vpl VALUES ("PR25_15","021_25_15","PRO","25","15","15","ຄັນ ກວາຍ ຈາ ອຶງກ່ອຍ ນ່ອຍ໌ ງ່ອຍ໌ ອຶງກ່ອຍ ອາຕີ ກວາຍ ຊົດ, ເຕ່ອ໌ ອັນ ຕະ ໂອນ ກວາຍ ຊົດ ຊາງັດ; ກະ ຄັນ ອັນ ຕະ ອຶນຕີ ລາເມ່ນ ອໍ, ເຕ່ອ໌ ອັນ ຕະ ໂອນ ກວາຍ ຊົດ ຕາປູ່ນ ປັຣນາຍ ອັນ ອາຕີ. ");
INSERT INTO ncq_vpl VALUES ("PR25_16","021_25_16","PRO","25","16","16","ອຶນໂຈຍ ງ່ອຍ໌ ແດີອ໌ ກາຮຍາລ ລວາດ ງື່; ຄັນ ງ່ອຍ໌ ຊາອຶ່ຍ ເນີ່ມ, ອຶງກັອຮ ປຍາຍ໌ ປາລາງ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("PR25_17","021_25_17","PRO","25","17","17","ອຶນໂຈຍ ເປາະ ຊາອົຮ ເຢົ່າ ເລືອຍໆ, ຍ່ອນ ອຶງກັອຮ ປຍາຍ໌ ອັນ ຊັອງ ຕາ ເມ່ນ ໄມ່, ເຈີ່ ຊາອັຣ ຕະ ໄມ່ ເລີຍ. ");
INSERT INTO ncq_vpl VALUES ("PR25_18","021_25_18","PRO","25","18","18","ຕູນ ອາແປັດ ກວາຍ ການໍ່ອ໌ ລາ ນ່ະ ອີ ກາຈີດ ອັນ ແຕ ດາວ, ຣາກັລ, ແຕີລາ ກຳ ຊານາ ກາ ປຼາ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR25_19","021_25_19","PRO","25","19","19","ຄັນ ປັ່ອງ ກວາຍ ຕາ ເບີນ ຕານັ່ອງ ຕາປຶ່ງ ແຕີ່ອ໌ ຣາມົຮ ຕຸ່ຮ ກັ່ດ, ລາ ມູເຈິງ ຈາ ມາ ກາແນງ ແກີດ ຣາໄມ່, ແຕີລາ ນ່ະ ກວາຍ ໂຢດ ອາເຢີງ ຕາຢັຮ ເປາະ. ");
INSERT INTO ncq_vpl VALUES ("PR25_20","021_25_20","PRO","25","20","20","ຄັນ ລ່ຳ ໂອນ ກວາຍ ງໍ່ ຊາງັດ, ລາ ນ່ະ ຕວດ ຕຳປັອກ ອັນ ຕຶ່ງ ຕາໄງ ຊາແງດ, ແຕີລາ ອີດ ບອຍ ອາປຍາອ໌ ຕຶ່ງ ເບິ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR25_21","021_25_21","PRO","25","21","21","ຄັນ ກວາຍ ອວານ ໄມ່ ມາ ມາເຍືາຍຮ, ລາ ອຶງເຄາະ ໄມ່ ໂອນ ອັນ ຈາ; ຄັນ ອັນ ອາເຣືາງ ແດີອ໌, ລາ ອຶງເຄາະ ໄມ່ ໂອນ ອັນ ງ່ອຍ໌. ");
INSERT INTO ncq_vpl VALUES ("PR25_22","021_25_22","PRO","25","22","22","ຕະ ນ່ະກັອຍ, ລາ ຕະ ໂອນ ອັນ ຊັອງ ກູມາລ ຕະ, ກະ ເຢືາງ ເຈົາຣາຊີ ລື່ ໂອນ ໄມ່ ເບີນ ເກືາ. ");
INSERT INTO ncq_vpl VALUES ("PR25_23","021_25_23","PRO","25","23","23","ມູເຈິງ ກູຢາລ ຢັ່ຮ ແປີງ ເດີງ ແດີອ໌ ເມືາ, ມາຮ ກັອຍ ເຕ່ ກວາຍ ອຶນຊອຍ໌ ແບອ໌ ອາແຕີ່ອ໌ ຣາມຶ່ຮ ອວານ. ");
INSERT INTO ncq_vpl VALUES ("PR25_24","021_25_24","PRO","25","24","24","ຄາອ໌ ແອີດ ຊັອງ ຕຶ່ງ ຕຳປວລ ດຸງ, ແຕ ແອີດ ມວຍ ດຸງ ກະ ລາກວຍ ດຸ ຣາໂລຍຮ ເລືອຍໆ. ");
INSERT INTO ncq_vpl VALUES ("PR25_25","021_25_25","PRO","25","25","25","ຄັນ ຊັອງ ເນົ່າ ຊາບາວ ຣານະ ອໍ ແຕ ອຶນຕຸ ເຢີ່ງ, ກັອຍ ລາ ມູເຈິງ ງ່ອຍ໌ ແດີອ໌ ຢິນ ບັອງ ຊາແອີດ ອາໂຣ່ະ. ");
INSERT INTO ncq_vpl VALUES ("PR25_26","021_25_26","PRO","25","26","26","ກວາຍ ຕານັ່ອງ ອໍ ມາ ຊາງັດ ກະ ຕາຕູ່ນ ກວາຍ ຕາ ອໍ, ລາ ມູເຈິງ ແດີອ໌ ປັຣໂລ່ຍ໌ ແກີດ ແປຣິ່, ແຕີລາ ແດີອ໌ ກັອຮ ເບີນ ເນົ່າ ໂຈະ ຣາເຮົາ ບູລ. ");
INSERT INTO ncq_vpl VALUES ("PR25_27","021_25_27","PRO","25","27","27","ຕາ ເບີນ ອໍ ງ່ອຍ໌ ແດີອ໌ ກາຮຍາລ ຮັບ ເນີ່ມ; ມູເຈິງ ກັອຍ ເຕ່ ຕາ ເບີນ ອໍ ຈໍ່ອ໌ ເລືອຍໆ ໂອນ ເນົ່າ ຍ່ອງ ຈະ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("PR25_28","021_25_28","PRO","25","28","28","ກວາຍ ຕາ ດັງ ກຍາອ໌ ຈະ ເບີມ ລາ ມູເຈິງ ເມືອງ ເບີນ ວຍາງ ເຈີ່ ຣາລຸຮ. ");
INSERT INTO ncq_vpl VALUES ("PR26_1","021_26_1","PRO","26","1","1","ຕາ ເບີນ ປຍາຍ໌ ໄຮ ໂອນ ຊະເຢືາງ ປໍ ກວາຍ ປຼຸງ; ມູເຈິງ ຕາ ເບີນ ປຍາຍ໌ ແດີອ໌ ລາຕາອ໌ ແຊງ ຍາມ ປາຣັງ, ແຕີລາ ເມືາ ອາແຊງ ຍາມ ຊູຊອດ. ");
INSERT INTO ncq_vpl VALUES ("PR26_2","021_26_2","PRO","26","2","2","ຊັນຕອຍ໌ ຣາເວ່ນ ຕາ ເຕ່ອ໌ ຕະ ອຶນເຕົ່າ ກວາຍ ກາ ຕາ ເບີນ ຕະ ໂລ່ຍຮ. ຊັນຕອຍ໌ ກັອຍ ລາ ນ່ະ ແຈມ ກາ ປັຣ ກຼະ ຕາຕຶ່ງ ຕາໂຕະ, ມາ ຕາ ເບີນ ຣາມົຮ ອຶນຕຸ ອີ ປົກ. ");
INSERT INTO ncq_vpl VALUES ("PR26_3","021_26_3","PRO","26","3","3","ກ່ອນ ກຽມ ດໍອ໌ ປຍາຍຮ ອາແຊັຮ, ກີມ ກຽມ ດໍອ໌ ເດີງ ອາແຊັຮ ແຈລ, ກະ ຣາວັ່ດ ກຽມ ດໍອ໌ ໂອນ ກວາຍ ຊາກູລ. ");
INSERT INTO ncq_vpl VALUES ("PR26_4","021_26_4","PRO","26","4","4","ອຶນໂຈຍ ຕາແອີຍ ປັຣນາຍ ກວາຍ ຊາກູລ ອາເບຼິຮ, ອຶງກັອຮ ປຍາຍ໌ ໄມ່ ອີ ແກີດ ຊາກູລ ນ່ະ ອັນ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("PR26_5","021_26_5","PRO","26","5","5","ຄັນ ກວາຍ ຊາກູລ ປາຍ ຕາ ແກີດ ກຼອງ, ອຶງເຄາະ ໄມ່ ຕາແອີຍ ອັນ; ຄັນ ໄມ່ ຕາ ເບີນ ຕາແອີຍ ອຶນເຕົ່າ, ອັນ ຄຶ່ດ ປາຍ ອັນ ຣາໄງ່ອ໌ ຣາລັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR26_6","021_26_6","PRO","26","6","6","ຄັນ ໄມ່ ແປຣີ ກວາຍ ຊາກູລ ເດີງ ປັຣນາຍ, ລາ ນ່ະ ໄມ່ ກັອຮ ອາເຢີງ ໄມ່ ເບີມ, ແຕີລາ ນ່ະ ໄມ່ ງ່ອຍ໌ ປີ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("PR26_7","021_26_7","PRO","26","7","7","ປັຣນາຍ ປາລີ່ ພາຍາ ກາ ລັ່ອຮ ແຕ ແບອ໌ ກວາຍ ຊາກູລ, ລາ ນ່ະ ອາເຢີງ ແປຼ ປູເປາະ ແອວ໌ ອາວ໌ໆ. ");
INSERT INTO ncq_vpl VALUES ("PR26_8","021_26_8","PRO","26","8","8","ຄັນ ຍ່ອງ ກວາຍ ຊາກູລ ລາ ມູເຈິງ ອີດ ຕາເມົາ ຊັດ ຕຶ່ງ ກຸນທຸ່ນ. ");
INSERT INTO ncq_vpl VALUES ("PR26_9","021_26_9","PRO","26","9","9","ປັຣນາຍ ປາລີ່ ພາຍາ ກາ ລັ່ອຮ ແຕ ແບອ໌ ກວາຍ ຊາກູລ ລາ ມູເຈິງ ກວາຍ ບູລ ບຼັອງ ຊາເກີຍ ປັລ ຊັຣເລືາ ຕຶ່ງ ອາຕີ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR26_10","021_26_10","PRO","26","10","10","ກວາຍ ອາແລ່ະ ຈາງ ກວາຍ ຊາກູລ ໂອນ ຕະ ຣານະ, ລາ ອັນ ຕະ ໂອນ ກູ່ ນະ ກວາຍ ຕະ ຣານະ ອັນ ແກີດ ຕຸ່ຮ ກັ່ດ. ");
INSERT INTO ncq_vpl VALUES ("PR26_11","021_26_11","PRO","26","11","11","ຄັນ ກວາຍ ຊາກູລ ຕະ ລຶ່ບ ຕາ ລຶ່ບ ຣານະ ຊາກູລ, ລາ ມູເຈິງ ອາຈໍ ເປາະ ແຢລ ລັ່ຮ ກັຣຕາ ອັນ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("PR26_12","021_26_12","PRO","26","12","12","ຄາອ໌ ໄຮ ອຶງກ່ອງ ແຕ ກວາຍ ຊາກູລ, ແຕ ໄຮ ອຶງກ່ອງ ກວາຍ ອາຊັອຮ ຈະ ກາ ປາຍ ອັນ ຣາໄງ່ອ໌ ຣາລັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR26_13","021_26_13","PRO","26","13","13","ກວາຍ ອາລັ່ຮ ມັ່ກ ປາຍ ອາເກີນ ນ່ະໄນ່: “ເບີນ ກູຊັນ ເກຣາະ ຕຶ່ງ ຣານາ, ກູລາ ເກຣາະ ຕຶ່ງ ກາຕຣໍ່.” ");
INSERT INTO ncq_vpl VALUES ("PR26_14","021_26_14","PRO","26","14","14","ກວາຍ ອາລັ່ຮ ປາລັດ ປາແລ ຕຶ່ງ ຊານ່ອນ, ນ່ະ ງັ່ຮ ຕົ່ງ ເປິຮ ກາໄຕ່ຮ, ມາ ຕາ ເບີນ ຣາຊີ່ອ໌ ປໍ ແລ່ະ. ");
INSERT INTO ncq_vpl VALUES ("PR26_15","021_26_15","PRO","26","15","15","ກວາຍ ອາລັ່ຮ ຈວາຍ໌ ຊັຣນາ, ມາ ດິ່ຮ ຕຶ່ງ ແບອ໌ ເບີມ ລາ ອັນ ອາລັ່ຮ ອີ ໂຈະ. ");
INSERT INTO ncq_vpl VALUES ("PR26_16","021_26_16","PRO","26","16","16","ກວາຍ ອາລັ່ຮ ຄຶ່ດ ປາຍ ອັນ ຣາໄງ່ອ໌ ກາເລີຍ ແຕ ຕາປູ່ລ ນະ ກວາຍ ຕານີ່ບ ກາ ແຄວ໌ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR26_17","021_26_17","PRO","26","17","17","ຄັນ ເປາະ ຣາບູລ ແຕ ປັຣນາຍ ກວາຍ ຣາຈຽນ ຣາໂລຍຮ, ກາ ຕາ ແກີນ ຣານະ ເບີມ, ລາ ນ່ະ ແຍັກ ກູຕູຣ ອາຈໍ ບັອງ ອັນ ເປາະ ຊາລັຮ. ");
INSERT INTO ncq_vpl VALUES ("PR26_18","021_26_18","PRO","26","18","19","ກວາຍ ມັ່ກ ຣາພິ ກວາຍ ການໍ່ອ໌, ປາຍ ອັນ ຣາຢອຍ໌ ຊັອງ; ກັອຍ ລາ ມູເຈິງ ກວາຍ ຢຸ່ຮ ປັນ ກຳ ອູ່ຍຮ ອີ ກາຈີດ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("PR26_20","021_26_20","PRO","26","20","20","ຄັນ ຕາ ເບີນ ເບີນ ອຶນລູ່ຍ໌, ອູ່ຍຮ ແກີດ ປັດ; ຄັນ ຕາ ເບີນ ເບີນ ກວາຍ ກາ ຕາແມີຍຮ ຈາ ອຶນຕຣິ່ນ ຕາມິ່ນ ຈາ ອຶນຈີ, ລາ ຕາ ເບີນ ນັ່ອງ ປັຣນາຍ ຣາໂລຍຮ. ");
INSERT INTO ncq_vpl VALUES ("PR26_21","021_26_21","PRO","26","21","21","ກູຈັຮ ຕະ ໂອນ ແກີດ ຣາແຮິ ອູ່ຍຮ, ອຶນລູ່ຍ໌ ຕະ ໂອນ ອູ່ຍຮ ເບຼີ; ມູເຈິງ ກັອຍ ເຕ່ ກວາຍ ຣາຢົວະ ຕະ ໂອນ ແກີດ ຣາໂລຍຮ. ");
INSERT INTO ncq_vpl VALUES ("PR26_22","021_26_22","PRO","26","22","22","ຊັນຕອຍ໌ ຕັຣແມີຍຮ ລາ ປາຈົກ ປາຈຍາກ ລາລື່; ກະ ກວາຍ ກາ ຊາງັດ ອັນ ລື່ນ ໄຈ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR26_23","021_26_23","PRO","26","23","23","ເບີນ ກວາຍ ຕະ ອຶນຕີ ລາວິ່ ນ່ະ ດາຍ ລາເວືາຍ ນ່ະ ແດີອ໌, ມາ ຣາງຶ່ຮ ຣາແຮີ ອັນ ຊາອ໌; ປັຣນາຍ ກັອຍ ລາ ມູເຈິງ ອີດ ປຣະ ຕຍາ ລູ່ບ ອາແດັຮ ກູແຕອ໌ ກາ ຕາ ເບີນ ເກືາ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR26_24","021_26_24","PRO","26","24","24","ກວາຍ ຊາອັຣ ກວາຍ ການໍ່ອ໌, ອັນ ປາໂຕ່ະ ຣາມຶ່ຮ ກັອຍ ແຕ ປັຣໄລຮ ປັຣນາຍ ລາເມ່ນ ອໍ, ມາ ຣາງຶ່ຮ ອັນ ກູຈົກ ກູຈີວ ກູວີວ ກູວາວ. ");
INSERT INTO ncq_vpl VALUES ("PR26_25","021_26_25","PRO","26","25","25","ອັນ ຕະ ອຶນຕີ ອຶນຊີ່ງ ອຶງເງືາມ, ມາ ອຶນໂຈຍ ຊາງັດ ປັຣນາຍ ອັນ ປາຍ, ຍ່ອນ ຣາງຶ່ຮ ແຣັ່ງ ຕະ ຊົດ ເລືອຍໆ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR26_26","021_26_26","PRO","26","26","26","ອັນ ປາໂຕ່ະ ເລືອຍໆ ຣາງຶ່ຮ ອຶງຄື່ນ, ມາ ປັຣແນີ ມັນເຕຣືາ ກູ່ ນະ ກວາຍ ເບີນ ເຮີມ ມັຮ ຣານະ ຊາອ໌ ກາ ອັນ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("PR26_27","021_26_27","PRO","26","27","27","ກວາຍ ປິ່ ປຣຸ່ງ ໂຈະ ກວາຍ ການໍ່ອ໌, ລື່ ອັນ ແຕິ່ ອີ ຊາປິ່ລ ຕຶ່ງ ປຣຸ່ງ ກັອຍ. ກວາຍ ອາແລ່ະ ຕະ ໂອນ ຕາເມົາ ຊາປີລ ແຕ ກົຮ, ລື່ ຕາເມົາ ກັອຍ ຊາປີລ ກາຕັ່ບ ອັນ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("PR26_28","021_26_28","PRO","26","28","28","ກວາຍ ຊາອັຣ ກວາຍ ການໍ່ອ໌, ມັ່ກ ຕູນ ອາແປັດ ໂອນ ກວາຍ ກັອຍ ປິ່ດ ຕາແປດ ແທຣດ ຕາປູ່ນ; ກວາຍ ກາ ມັນຕຣັ່ນ ເຢົ່າ ມາ ຕາ ເບີນ ລື່, ລາ ນ່ະ ອັນ ອາແຕີ່ອ໌ ກູຈີດ ປິ່ດ ປໍ ເຢົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR27_1","021_27_1","PRO","27","1","1","ອຶນໂຈຍ ໂອດ ອຶນໂຍ່ງ ແຕ ຣານະ ໄມ່ ອີ ຕະ ຕາໄງ ປັຣແນີ, ຍ່ອນ ໄມ່ ຕາ ເບີນ ດັງ ອຶນເຕົ່າ ດິ ອີ ແຕີ່ອ໌ ຕຶ່ງ ຕາໄງ ປັຣແນີ. ");
INSERT INTO ncq_vpl VALUES ("PR27_2","021_27_2","PRO","27","2","2","ໂອນ ກວາຍ ການໍ່ອ໌ ຍ່ອງ ໄມ່, ມາ ໄມ່ ອຶນໂຈຍ ໂອນ ປັຣນາຍ ກັອຍ ລັ່ອຮ ແຕ ແບອ໌ ໄມ່ ເບີມ; ຄັນ ເນົ່າ ຍ່ອງ ໄມ່ ລາ ອໍ ເຈີ່, ມາ ຕາ ເບີນ ປຍາຍ໌ ໄມ່ ອາຊັອຮ ເຢືາງ ຈະ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("PR27_3","021_27_3","PRO","27","3","3","ຄັນ ກວາຍ ຊາກູລ ຣາຍົວະ, ຣາມຶ່ຮ ກັອຍ ລາ ອຶນຕັອງ ກາເລີຍ ແຕ ຕາເມົາ ກະ ຊາງາຍ໌. ");
INSERT INTO ncq_vpl VALUES ("PR27_4","021_27_4","PRO","27","4","4","ປັຣນາຍ ກູເຕົາ ຣາງຶ່ຮ ລາ ປຼາ ກະ ຊາອ໌ ລາລື່; ມາ ຣາບວາຮ ລາ ຕາ ອໍ ກາເລີຍ ແຕ ກັອຍ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR27_5","021_27_5","PRO","27","5","5","ຄາອ໌ ຣາປາຍ ຢັ່ຮ ເມືາງ ແຕິ່, ແຕ ອາໂຢ່ະ ມາ ຕາ ເບີນ ອາປັຮ. ");
INSERT INTO ncq_vpl VALUES ("PR27_6","021_27_6","PRO","27","6","6","ອຶມປຶ່ ມັຮ ເຢົ່າ ຕະ ໂອນ ໄມ່ ຊັອງ ຕິ່ ຕຶ່ງ ຣາງຶ່ຮ, ລາ ອຶນນັ່ອງ ໄລ່ ອາໂຢ່ະ ໄມ່. ມາ ຄັນ ກວາຍ ຣາອວານ ຊາປ່ະ ເປີ່ຣ ກະ ໄມ່, ລາ ອຶງເຄາະ ລາວັ່ງ ອໍ! ");
INSERT INTO ncq_vpl VALUES ("PR27_7","021_27_7","PRO","27","7","7","ແຕີ່ອ໌ ຈາ ປາໄຊ ເຈີ່, ອຶມປຶ່ ແດີອ໌ ກາຮຍາລ ລາ ຕາ ຊັອງ ອີ ງ່ອຍ໌ ນັ່ອງ; ມາ ແຕີ່ອ໌ ຊັອງ ມາເຍືາຍຮ, ອຶມປຶ່ ຊັຣນາ ອຶນຕັງ ລາ ປາຍ ອຶງເງືາມ. ");
INSERT INTO ncq_vpl VALUES ("PR27_8","021_27_8","PRO","27","8","8","ກວາຍ ຕັຮ ດຸງ ເບີມ, ລາ ມູເຈິງ ແຈມ ຕັຮ ຊານົຮ. ");
INSERT INTO ncq_vpl VALUES ("PR27_9","021_27_9","PRO","27","9","9","ແດີອ໌ ປາຮວມ ກະ ແດີອ໌ ອານາ ຕະ ໂອນ ໄຮ ຊັອງ ຣໍ່ອ໌ ຕຶ່ງ ຣາງຶ່ຮ; ມາ ຣາງຶ່ຮ ອາໂຢ່ະ ແຕ ເຢົ່າ ຣາຕອຍ ລາ ປາຮວມ ກາເລີຍ ແຕ ແຮີຍ ຣາແລງ ອາລ່ອງ ຣໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR27_10","021_27_10","PRO","27","10","10","ອຶນໂຈຍ ຊາລີຣ ມັຮ ເຢົ່າ, ແຕີລາ ເຢົ່າ ອຶມປໍ່ ໄມ່. ແຕີ່ອ໌ ໄມ່ ຕຸ່ຮ ກັ່ດ ອຶນໂຈຍ ຈໍ່ອ໌ ນັ່ອງ ແຊມອາຍ ກະ ແຄີຍ ກູຢາ ກາ ແອີດ ເຢີ່ງ ແຕ ໄມ່; ມາ ອຶງເຄາະ ໄມ່ ແຊອ໌ ມັຮ ເຢົ່າ ແຈ່ະ ຊຍາດ ຊັອງ ຈ່ອຍ, ຍ່ອນ ພວາອ໌ ແກີດ ຣານາ ເມືາ ແກີດ ຣາລັ່ນ. ");
INSERT INTO ncq_vpl VALUES ("PR27_11","021_27_11","PRO","27","11","11","ກອນ ເອີຍ! ອຶງເຄາະ ໄມ່ ແກີດ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ, ນ່ະກັອຍ ເກົາ ກາ ອຶມປໍ່ ຊັອງ ຣໍ່ອ໌ ຣາງຶ່ຮ; ແຕີ່ອ໌ ເນົ່າ ຕິ ປາຍ ເກົາ ຕາ ເບີນ ຕາໄມຮ ໄມ່, ລາ ເຕ່ອ໌ ເກົາ ຣາປາຍ ລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("PR27_12","021_27_12","PRO","27","12","12","ມັຮ ກວາຍ ກາ ດັງ, ເຕ່ອ໌ ໄລ່ ວຍາຣ ແຕ ມັຮ ຣານະ ຕຸ່ຮ ກັ່ດ ກາ ອີ ແຕີ່ອ໌; ມາ ມັຮ ກວາຍ ຕາ ເບີນ ດັງ ອຶນເຕົ່າ, ໄລ່ ເປາະ ຕຣູໂຕຣະ, ເຈີ່ ໄລ່ ຣາມົຮ ຕຸ່ຮ ກັ່ດ. ");
INSERT INTO ncq_vpl VALUES ("PR27_13","021_27_13","PRO","27","13","13","ຄັນ ກວາຍ ຊາກູລ ມາ ກ່ຳ ຕູ່ ຕາງ ກວາຍ ແຕ ກຣວາງ ການໍ່ອ໌, ລາ ປຍາຍ໌ ເນົ່າ ອີດ ມູ່ນ ອັນ ຕະ ຕິກ. ");
INSERT INTO ncq_vpl VALUES ("PR27_14","021_27_14","PRO","27","14","14","ຄັນ ຕາຣື່ບ ແຕ ປຼື່, ລູລຸງ ໄມ່ ປາຍ ບຸ່ນ ໂອນ ເຢົ່າ ໄມ່, ລາ ອັນ ຄຶ່ດ ປາຍ ກັອຍ ລາ ຊັນຕອຍ໌ ຣາເວ່ນ. ");
INSERT INTO ncq_vpl VALUES ("PR27_15","021_27_15","PRO","27","15","15","ລາກວຍ ກາ ຣາໂລຍຮ ຣາແລັຮ ເລືອຍໆ, ລາ ມູເຈິງ ຕາໄງ ເມືາ ຈັນແຈັກ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR27_16","021_27_16","PRO","27","16","16","ກວາຍ ກາ ກາແອັຮ ອັນ ລາ ນ່ະ ກາແອັຮ ກູຢາລ, ແຕີລາ ອີດ ອາຕີ ໂກບ ອຶນຊີ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR27_17","021_27_17","PRO","27","17","17","ກວາຍ ດຸ ອີດ ຕາອ໌ ໄນ່ ກີ່ດ ກະ ຕາອ໌ ກັອຍ ໂອນ ເບິ; ມູເຈິງ ກັອຍ ເຕ່, ມານະ ອຶງເຄາະ ຣຍານ ແຕ ມານະ ໂອນ ແກີດ ຣາໄງ່ອ໌ ຣາລັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR27_18","021_27_18","PRO","27","18","18","ກວາຍ ເນ່ ຊາລີອ໌ ກັ່ລ ລາວັ່ຮ, ອັນ ເບີນ ຈາ ປາໄລ ກັອຍ; ກວາຍ ເນ່ ຊາລີອ໌ ອຶນເຈົາ ອັນ, ລື່ ເນົ່າ ຢຳນັ່ບ ກວາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR27_19","021_27_19","PRO","27","19","19","ແຕີ່ອ໌ ໄມ່ ປູບ ຊາລັ່ງ ຕຶ່ງ ກຣັອງ ແດີອ໌, ໄມ່ ເຮີມ ລັ່ຮ ມາມ ເບີມ; ກະ ແຕີ່ອ໌ ໄມ່ ເນ່ ລັ່ຮ ຕຶ່ງ ຣານະ ໄມ່ ຕະ, ໄມ່ ດັງ ລັ່ຮ ຣາງຶ່ຮ ໄມ່ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("PR27_20","021_27_20","PRO","27","20","20","ອາກັນ ກູຈີດ ກະ ຕຸ່ຮ ອາຣຶ່ກ ລື່ນ ກວາຍ ຕາ ເກີ່ຍ ປາໄຊ; ມູເຈິງ ກັອຍ ເຕ່ ມັ່ດ ໄຮ ເນ່ ມາແລ່ະ ລາ ຕາ ເກີ່ຍ ເປ່. ");
INSERT INTO ncq_vpl VALUES ("PR27_21","021_27_21","PRO","27","21","21","ເນົ່າ ດຸ ລ່ອງ ແຢງ ກະ ປຣະ ຕຶ່ງ ອູ່ຍຮ; ມາ ເນົ່າ ດຸ ລ່ອງ ກວາຍ ແຕ ປັຣນາຍ ຍ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("PR27_22","021_27_22","PRO","27","22","22","ອຶມປຶ່ ໄມ່ ອີດ ອຶນຕຣີ່ ກຼົຮ ກວາຍ ຊາກູລ ຕຶ່ງ ຕາປັລ ມູເຈິງ ໄມ່ ກຼົຮ ໂດຍ ທຣໍ, ມາ ໄມ່ ຕາ ເຕ່ອ໌ ຕຣວາຮ ອາກັນ ຊາກູລ ໂອນ ລັ່ອຮ ແຕ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR27_23","021_27_23","PRO","27","23","23","ອຶງເຄາະ ໄມ່ ກຍາອ໌ ໂອນ ກຣັ່ກ ມັຮ ແກະ ກະ ຕາແກງ ໄມ່, ");
INSERT INTO ncq_vpl VALUES ("PR27_24","021_27_24","PRO","27","24","24","ຍ່ອນ ມູ່ນ ໄມ່ ຕາ ເບີນ ແອີດ ເລືອຍໆ; ອຶມປຶ່ ອຳນາດ ເຕືາວ ປັຣເຍືາ ລາ ຕາ ເບີນ ຄຳ ໂອນ ກູ່ ທຣາບ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("PR27_25","021_27_25","PRO","27","25","25","ພໍກາ ແມິ່ມ ໄມ່ ເວືາຍ ບັດ ປໍ ເນືາ ກະ ປໍ ກ່ອຣ ກົຮ, ແວັດ ກັອຍ ລາ ອັນ ໄບອ໌ ລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("PR27_26","021_27_26","PRO","27","26","26","ບັອງ ກັອຍ, ເຕ່ອ໌ ໄມ່ ກິດ ໂຊະ ແກະ ຕະ ຕຳປັອກ, ກະ ເຕ່ອ໌ ໄມ່ ຈິ ມັຮ ອຶມແບອ໌ ໄມ່, ເຈີ່ ເປາະ ແຈີງ ກູແຕອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR27_27","021_27_27","PRO","27","27","27","ມັຮ ອຶມແບອ໌ ກາ ໄມ່ ຕາ ເບີນ ຈິ, ອັນ ເຕ່ອ໌ ໂອນ ໄມ່ ອີດ ແດີອ໌ ຕົຮ ດໍອ໌ ຊານາ ໄມ່ ກະ ດຸງຊູ ໄມ່, ດິ່ຮ ມັຮ ກວາຍ ມັນແຊມ ກາ ຕະ ຣານະ ໂອນ ໄມ່ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("PR28_1","021_28_1","PRO","28","1","1","ກວາຍ ຕາ ອໍ ຕາລຸ່ຮ ອຶມປຣາຍຮ ອຶມປຣັງ ອຶມປຶ່ ຕາ ເບີນ ເນົ່າ ໄລ; ມາ ກວາຍ ຕານັ່ອງ ອໍ ຍັ່ນ ນ່ະ ກູລາ ຊິງ. ");
INSERT INTO ncq_vpl VALUES ("PR28_2","021_28_2","PRO","28","2","2","ແຕີ່ອ໌ ກອນແຊມ ຕຶ່ງ ມວຍ ກຣວາງ ຣາໂລຍຮ ຣາຕວາອ໌, ໄລ່ ຣາປຽນ ເລືອຍໆ ກວາຍ ຊົດ. ມາ ແຕີ່ອ໌ ເບີນ ກວາຍ ຊົດ ຣາໄງ່ອ໌ ຣາລັ່ງ ກາ ຕະ ແກີດ ແປີດ ແຮີຍ, ກຣວາງ ກັອຍ ເຕ່ອ໌ ແກີດ ຄຳ ດູ່ນ ກູມໍ ກຣໍ ກາໄຊ. ");
INSERT INTO ncq_vpl VALUES ("PR28_3","021_28_3","PRO","28","3","3","ກວາຍ ຊົດ ມາ ເນືາບ ກວາຍ ກາດີດ, ລາ ມູເຈິງ ເມືາ ຈັ່ນ ປຸ່ຮ ມັຮ ປາໄລ ຊັຣນົຮ ໂອນ ທຣູ່ອ໌ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("PR28_4","021_28_4","PRO","28","4","4","ມັຮ ກວາຍ ກາ ຕັຮ ຄານອດ, ໄລ່ ຍ່ອງ ກວາຍ ຕາ ອໍ; ມາ ມັຮ ກວາຍ ກາ ຕະ ປວາຍ ຄານອດ, ໄລ່ ຣາຈຽນ ລັ່ຮ ກະ ກວາຍ ຕາ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR28_5","021_28_5","PRO","28","5","5","ມັຮ ກວາຍ ຕາ ອໍ ຕາ ເບີນ ດັງ ເລີຍ ຣາມຶ່ຮ ຕານັ່ອງ; ມາ ມັຮ ກວາຍ ກາ ຕາປູ່ນ ເຢືາງ ເຈົາຣາຊີ, ໄລ່ ດັງ ຣາມຶ່ຮ ຕານັ່ອງ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR28_6","021_28_6","PRO","28","6","6","ຄາອ໌ ແກີດ ກວາຍ ກາດີດ ກາ ຕານັ່ອງ ຕາປຶ່ງ, ແຕ ແກີດ ກວາຍ ຊຸ ຍ່ອນ ກຸມປູ່ຣ ກູເວືາດ ເນົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR28_7","021_28_7","PRO","28","7","7","ມັຮ ກວາຍ ນຸ່ມ ກາ ຢຳນັ່ບ ຄານອດ, ໄລ່ ລາ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ; ມາ ໄລ່ ກາ ຣາຕອຍ ກະ ກວາຍ ຈາ ຕາ ຄຳ ຕາ ແຢິຮ, ຕະ ໂອນ ອຶມປໍ່ ໄລ່ ຊັອງ ກູມາລ. ");
INSERT INTO ncq_vpl VALUES ("PR28_8","021_28_8","PRO","28","8","8","ກວາຍ ກາ ເບີນ ມູ່ນມັ່ງ ຊັງ ຊານາ ຍ່ອນ ໂລ່ບ ຈາ ປຣະ ແຢງ; ປັຣແນີ ມັນເຕຣືາ ກວາຍ ການໍ່ອ໌ ກາ ເບີນ ຣາງຶ່ຮ ຣາແຮີ ຢໍອ໌ ອີ ຈ່ອຍ ກວາຍ ກາດີດ ແອັນ ເບີນ ຕັອກ ມູ່ນ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR28_9","021_28_9","PRO","28","9","9","ກວາຍ ອາແລ່ະ ມາ ຕາ ເບີນ ຕະ ປວາຍ ຄານອດ, ເຢືາງ ເຈົາຣາຊີ ອຶງຄື່ນ ປັຣນາຍ ກວາຍ ກັອຍ ເກົາແຊອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR28_10","021_28_10","PRO","28","10","10","ກວາຍ ອາແລ່ະ ກາ ປາເຕີຣ ກວາຍ ຕານັ່ອງ ອໍ ຕະ ໂລ່ຍຮ, ກວາຍ ກັອຍ ລື່ ຊາປິ່ລ ລັ່ຮ ຕຶ່ງ ປຣຸ່ງ ອັນ ເບີມ; ມາ ກວາຍ ກາ ຕາ ເບີນ ໂລ່ຍຮ, ອັນ ເບີນ ຣັ່ບ ຣາມຶ່ຮ ອໍ ແກີດ ເກືາ. ");
INSERT INTO ncq_vpl VALUES ("PR28_11","021_28_11","PRO","28","11","11","ກວາຍ ຊຸ ດຸ ຄຶ່ດ ປາຍ ອັນ ເບີນ ຣາງຶ່ຮ ຣາໄງ່ອ໌ ຣາລັ່ງ; ມາ ກວາຍ ກາດີດ ກາ ດັງ ແຈງ, ອັນ ດັງ ກວາຍ ກັອຍ ຕາ ເບີນ ລື່ ຣາໄງ່ອ໌ ຣາລັ່ງ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR28_12","021_28_12","PRO","28","12","12","ແຕີ່ອ໌ ກວາຍ ຕານັ່ອງ ອໍ ຣັ່ບ ອຳນາດ ແກີດ ຊົດ, ມັຮ ກວາຍ ຊັອງ ຣໍ່ອ໌; ມາ ແຕີ່ອ໌ ກວາຍ ແຣັ່ງ ຕະ ຊົດ, ມັຮ ກອນແຊມ ອຶມປຣາຍຮ ອຶມປຣັງ ໂຕ່ະ. ");
INSERT INTO ncq_vpl VALUES ("PR28_13","021_28_13","PRO","28","13","13","ກວາຍ ອາແລ່ະ ມາ ປູ່ລ ປາໂຕ່ະ ມັຮ ຣານະ ໂລ່ຍຮ ອັນ, ແດີຍ ອາມົ່ງ ກວາຍ ກັອຍ ຕະ ນານ່ະ ລາ ຕາ ລັ່ອຮ; ມາ ກວາຍ ອາແລ່ະ ງີ່ນ ຄໍ ໂລ່ຍຮ ອັນ, ເຢືາງ ເຈົາຣາຊີ ອາໂຢ່ະ ຕະ ກວາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR28_14","021_28_14","PRO","28","14","14","ກວາຍ ອາແລ່ະ ຕະ ຕາປູ່ນ ເຢືາງ ເຈົາຣາຊີ, ກວາຍ ກັອຍ ເບີນ ບຸ່ນ; ມາ ກວາຍ ອາແລ່ະ ກັ່ອງ ເງືານ, ກວາຍ ກັອຍ ແກີດ ຣຸ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR28_15","021_28_15","PRO","28","15","15","ກວາຍ ແຣັ່ງ ກາ ຊົດ ມັຮ ກວາຍ ກາດີດ, ອັນ ລາ ນ່ະ ກູລາ ຊິງ ອາຣື່, ແຕີລາ ຊາເກົ່າ ປາລັອງ ອີ ກັບ ມັຮ ກວາຍ ກາ ແອິ ມູ່ ກາ ຈ່ອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR28_16","021_28_16","PRO","28","16","16","ກວາຍ ຊົດ ມາ ຊາອ໌ ລາລື່, ອັນ ເນືາບ ເລືອຍໆ ກອນແຊມ; ມາ ກວາຍ ຊົດ ກາ ຊາອັຣ ຣານະ ກຸມປູ່ຣ ກູເວືາດ, ລື່ ອັນ ແກີດ ຊົດ ດູ່ນ ກູມໍ ກຣໍ ກາໄຊ. ");
INSERT INTO ncq_vpl VALUES ("PR28_17","021_28_17","PRO","28","17","17","ກວາຍ ກາຈີດ ກວາຍ ການໍ່ອ໌, ລື່ ອັນ ຣ່ະ ອຶນແຍ່ະ ແດີຍ ອາມົ່ງ ອັນ. ອຶນໂຈຍ ໂອນ ກວາຍ ອາແລ່ະ ຈ່ອຍ ອັນ! ");
INSERT INTO ncq_vpl VALUES ("PR28_18","021_28_18","PRO","28","18","18","ກວາຍ ອາແລ່ະ ມາ ເປາະ ຕຶ່ງ ຣານາ ຕານັ່ອງ ຕາປຶ່ງ, ກວາຍ ກັອຍ ແອີດ ກຼີດ ກຼອດ ຈອດ ອໍ; ກວາຍ ອາແລ່ະ ມາ ຕາ ເບີນ ຕານັ່ອງ ຕາປຶ່ງ, ອັນ ກັອຍ ແກີດ ແດິມ ອາແຊງ. ");
INSERT INTO ncq_vpl VALUES ("PR28_19","021_28_19","PRO","28","19","19","ກວາຍ ກາ ແທຣິງ ຕະ ເນືາ ໄທຣ, ກວາຍ ກັອຍ ເບີນ ໂດຍ ຕາ ຣາລໍ່ ທຣໍ ຕາ ຣາລິ່ຮ; ມາ ກວາຍ ດຸ ເປາະ ກູເກືາງ, ອັນ ແກີດ ຕຸ່ຮ ຊັຣນາ ເລືາ ອຶນແຕີດ. ");
INSERT INTO ncq_vpl VALUES ("PR28_20","021_28_20","PRO","28","20","20","ກວາຍ ຕານັ່ອງ ຕາປຶ່ງ ເບີນ ບຸ່ນ ຊາອຶ່ຍ; ມາ ກວາຍ ກຸນເຕົາ ອີ ຊຸ, ອັນ ຕາ ເຕ່ອ໌ ໄງ່ອ໌ ໂຕ່ດ. ");
INSERT INTO ncq_vpl VALUES ("PR28_21","021_28_21","PRO","28","21","21","ຄັນ ປັຣຈີນ ປັຣນາຍ ມາ ຮັກບັງ ຊັງບຍາງ, ຣາມຶ່ຮ ກັອຍ ຕາ ເບີນ ອໍ. ມາ ເບີນ ເຕ່ ກວາຍ ປັຣຈີນ ປັຣນາຍ ກາ ປຣ່ອມ ຕະ ໂລ່ຍຮ ອຶມປຶ່ ມູ ຣາແບງ ໂດຍ ບີ່ອ໌ໆ ກາ ເນົ່າ ບຸ່ນ. ");
INSERT INTO ncq_vpl VALUES ("PR28_22","021_28_22","PRO","28","22","22","ກວາຍ ປັຣຈົ່ກ ດຸ ກຸນເຕົາ ລາລື່ ອີ ແກີດ ຊຸ; ມາ ອັນ ຕາ ເບີນ ດັງ ແຕ ອາກັນ ກາດີດ ແອີດ ອາກັ່ນ ເລືອຍໆ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR28_23","021_28_23","PRO","28","23","23","ຄາອ໌ ເນົ່າ ຕາໄມຮ ໄຮ, ແຕ ເນົ່າ ອາຈວຣ ໄຮ; ຍ່ອນ ແວັດ ກັອຍ, ໄຮ ອີ ຍ່ອງ ກວາຍ ກາ ຕາໄມຮ ໄຮ. ");
INSERT INTO ncq_vpl VALUES ("PR28_24","021_28_24","PRO","28","24","24","ກວາຍ ອາແລ່ະ ຕວຍ໌ ເກຣີ່ງ ອຶມເປ່ອ໌ ອຶມປໍ່ ອັນ, ມາ ປາຍ ອັນ ຕາ ເບີນ ຕະ ໂລ່ຍຮ ອຶນເຕົ່າ, ລາ ຕາ ເບີນ ອຶມພາ ອຶນເຕົ່າ ກະ ກວາຍ ກູດີ່ງ ກູດາງ ກາຊາງ ກູເປືາຍ. ");
INSERT INTO ncq_vpl VALUES ("PR28_25","021_28_25","PRO","28","25","25","ກວາຍ ມັ່ກ ກຸມປູ່ຣ ກູເວືາດ ລາ ອາແຕີ່ອ໌໌ ຣານະ ຣາໂລຍຮ; ມາ ກວາຍ ອາແລ່ະ ກາ ຢຳນັ່ບ ເຢືາງ ເຈົາຣາຊີ, ລື່ ອັນ ເບີນ ກູ່ ຣາມຶ່ຮ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR28_26","021_28_26","PRO","28","26","26","ກວາຍ ກາ ຊາອຳ ເລືອຍໆ ຈະ ອັນ ເບີມ, ກວາຍ ກັອຍ ລາ ກວາຍ ຊາກູລ; ມາ ກວາຍ ກາ ຕະ ຕາປູ່ນ ປັຣນາຍ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ອາຕີ, ອັນ ແອີດ ກຼີດ ກຼອດ ຈອດ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR28_27","021_28_27","PRO","28","27","27","ກວາຍ ຈ່ອຍ ກວາຍ ກາດີດ, ອັນ ຕາ ເກີ່ຍ ແອິ; ມາ ກວາຍ ກາ ເນ່ ຊັອງ ປໍ ກວາຍ ກາດີດ, ອັນ ຣັ່ບ ຊັນຕອຍ໌ ກວາຍ ກັອຍ ເວ່ນ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR28_28","021_28_28","PRO","28","28","28","ແຕີ່ອ໌ ກວາຍ ແຣັ່ງ ເບີນ ແກີດ ຊົດ, ມັຮ ກອນແຊມ ໂຕ່ະ ອຶນແຍ່ະ; ມາ ແຕີ່ອ໌ ກວາຍ ແຣັ່ງ ກັອຍ ແກີດ ຣຸ່ງ ຣາລຸຮ ເຈີ່, ເບີນ ກວາຍ ຕານັ່ອງ ອໍ ຊັອຮ ແກີດ ຊົດ ເຕ່ນ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR29_1","021_29_1","PRO","29","1","1","ກວາຍ ອາແລ່ະ ຊາອຶ່ຍ ເຮີບ ເນົ່າ ກາໄຕ່ຮ ອາຕີ ມາ ອັນ ເງືານ ເລືອຍໆ, ກວາຍ ກັອຍ ຊັນຕັຣ ແດິມ, ກະ ອັນ ຕາ ເຕ່ອ໌ ຢວຣ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("PR29_2","021_29_2","PRO","29","2","2","ແຕີ່ອ໌ ກວາຍ ຕານັ່ອງ ອໍ ແກີດ ຊົດ, ມັຮ ກອນແຊມ ແກີດ ຣໍ່ອ໌ ບູຍ; ມາ ຄັນ ກວາຍ ຕາ ອໍ ແກີດ ຊົດ, ມັຮ ກອນແຊມ ຊູໂຊຍ ປັຣລູງ ປັຣລີງ. ");
INSERT INTO ncq_vpl VALUES ("PR29_3","021_29_3","PRO","29","3","3","ກອນ ກາ ອູອຍາຣ ອູໄອອ໌ ຢໍອ໌ ອີ ເບີນ ຣາງຶ່ຮ ຣາໄງ່ອ໌ ຣາລັ່ງ, ອັນ ຕະ ໂອນ ອຶມປໍ່ ອັນ ຊັອງ ຣໍ່ອ໌ ຣາງຶ່ຮ; ມາ ກວາຍ ກາ ອີ ເບີນ ມັນແຊມ ຈິ ຈະ, ລາ ກວາຍ ຊາ ອຶນເຕີນ. ");
INSERT INTO ncq_vpl VALUES ("PR29_4","021_29_4","PRO","29","4","4","ຄັນ ເຕືາວ ປັຣເຍືາ ຕະ ຊົດ ຕານັ່ອງ ຕາປຶ່ງ, ກຣວາງ ອັນ ລື່ ແກີດ ເຣ່ງ; ມາ ຄັນ ອັນ ມັ່ກ ປຣະ ແຢງ ກາ ເນົ່າ ບຸ່ນ, ເຈີ່ ກຣວາງ ອັນ ແກີດ ຣາລຸຮ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("PR29_5","021_29_5","PRO","29","5","5","ກວາຍ ດຸ ອາຈວຣ ເຢົ່າ, ກັອຍ ລາ ມູເຈິງ ອັນ ຕານ ຊາງ ກູວາງ ໂຈະ ຈະ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("PR29_6","021_29_6","PRO","29","6","6","ກວາຍ ຕາ ອໍ ຈວາດ ລັ່ຮ ຕຶ່ງ ຣານະ ໂລ່ຍຮ ເບີມ, ມາ ກວາຍ ຕານັ່ອງ ອໍ ລ່ຳ ລາລິງ ຣໍ່ອ໌ ບູຍ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR29_7","021_29_7","PRO","29","7","7","ກວາຍ ຕານັ່ອງ ອໍ ດັງ ອາແຣິ່ ຈ່ອຍ ກວາຍ ກາດີດ; ມາ ກວາຍ ຕາ ອໍ, ອັນ ຕາ ເບີນ ຣາບູລ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR29_8","021_29_8","PRO","29","8","8","ກວາຍ ດຸ ຣາຍົວະ ກວາຍ ການໍ່ອ໌, ຕະ ໂອນ ຣາລຸຮ ຕຣໍ່ ຣາລໍ່ ວີ່ລ; ມາ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ, ຕະ ໂອນ ເຢົ່າ ຣາຕອຍ ຣາເດີງ ຣາເຕີງ ຣາບັນ. ");
INSERT INTO ncq_vpl VALUES ("PR29_9","021_29_9","PRO","29","9","9","ແຕີ່ອ໌ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ປ່ອງ ກວາຍ ຊາກູລ ປໍ ອຶນຕຸ ປັຣຈີນ ປັຣນາຍ, ກວາຍ ຊາກູລ ກັອຍ ເຮາະ ກະ ຕະ ອຶນຕີ ປາໂລງ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("PR29_10","021_29_10","PRO","29","10","10","ກວາຍ ດຸ ກາຈີດ ກວາຍ ການໍ່ອ໌, ອັນ ອຶງຄື່ນ ກວາຍ ຕານັ່ອງ ຕາປຶ່ງ, ກະ ອັນ ຈໍ່ອ໌ ເລືອຍໆ ເງ່ ອີ ກາຈີດ ກວາຍ ຕານັ່ອງ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR29_11","021_29_11","PRO","29","11","11","ກວາຍ ຊາກູລ ເບີນ ມິ່ດ ອາອຸ່ງ ປຸ່ງ ລັງໄກຮ, ມາ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ດັງ ອົດ ຣາງຍາອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR29_12","021_29_12","PRO","29","12","12","ຄັນ ກວາຍ ຊົດ ຊາງັດ ປັຣນາຍ ແຈມ ຊວລ ຕຶ່ງ ອາລ່ອງ ຢອງ ຊວລ ຕຶ່ງ ຕາຣົ່ງ, ນ່ະກັອຍ ອຶນແຍ່ະ ມັຮ ກວາຍ ຕະ ຣານະ ອັນ ແກີດ ກວາຍ ໂລ່ຍຮ ອຶນແຍ່ະ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("PR29_13","021_29_13","PRO","29","13","13","ກວາຍ ກາດີດ ກະ ກວາຍ ດຸ ຕະ ຕຸ່ຮ ເນົ່າ, ໄລ່ ເບີນ ມວຍ ຣາມຶ່ຮ ມູເຈິງ, ລາ ເຢືາງ ເຈົາຣາຊີ ໂອນ ມັ່ດ ໄລ່ ບາຣ ນະ ເຕ່ອ໌ ເຮີມ. ");
INSERT INTO ncq_vpl VALUES ("PR29_14","021_29_14","PRO","29","14","14","ຄັນ ເຕືາວ ປັຣເຍືາ ຕາ ເບີນ ຮັກບັງ ຊັງບຍາງ ໂຈະ ກວາຍ ກາດີດ, ລາ ອັນ ເບີນ ແກີດ ເຕືາວ ປັຣເຍືາ ດູ່ນ ກູມໍ ກຣໍ ກາໄຊ. ");
INSERT INTO ncq_vpl VALUES ("PR29_15","021_29_15","PRO","29","15","15","ປຍາຍ໌ ລາລື່ ໂອນ ວັ່ດ ແອບ ກອນ, ໂອນ ອັນ ແກີດ ຣາໄງ່ອ໌ ຣາລັ່ງ. ຄັນ ກອນ ມາ ໄຈ່, ລາ ຕະ ໂອນ ອຶມເປ່ອ໌ ອັນ ກູມາລ ຕະ ເນົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR29_16","021_29_16","PRO","29","16","16","ແຕີ່ອ໌ ມັຮ ກວາຍ ແຣັ່ງ ແກີດ ຊົດ, ເຈີ່ ຣານະ ໂລ່ຍຮ ແກີດ ຊາອຶ່ຍ ອາຊັອຮ; ມາ ມັຮ ກວາຍ ຕານັ່ອງ ອໍ ລື່ ເບີນ ເຮີມ ແຕີ່ອ໌ ອຳນາດ ກວາຍ ຕາ ອໍ ຣາລິ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("PR29_17","021_29_17","PRO","29","17","17","ອຶງເຄາະ ເຍືາ ກາ ອຶມເປ່ອ໌ ອຶມປໍ່ ແທຣິງ ແອບ ກອນ ໂອນ ແກີດ ມັນຕັ່ດ ອໍ, ລື່ ກອນ ກັອຍ ຕະ ໂອນ ເຍືາ ແອີດ ຣໍ່ອ໌ ບູຍ ລາແຮີຍ ລາແຕິ່ຮ, ກະ ໂອນ ເຍືາ ຊັອງ ແອີນ ຕຶ່ງ ຣາງຶ່ຮ ຣາແຮີ. ");
INSERT INTO ncq_vpl VALUES ("PR29_18","021_29_18","PRO","29","18","18","ຄັນ ກຣວາງ ອາແລ່ະ ກາ ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ອາປັຮ ເລືາຍ, ກຣວາງ ກັອຍ ລື່ ແກີດ ກຣວາງ ຕາ ເບີນ ແກີດ ຄານອດ; ມາ ບຸ່ນ ລາລື່ ມັຮ ກວາຍ ກາ ຢຸມ ຈັບ ມັຮ ຄານອດ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("PR29_19","021_29_19","PRO","29","19","19","ຄັນ ເບີນ ກວາຍ ຕະ ຣານະ ໄມ່, ຕາ ເຕ່ອ໌ ອາຕີ ໄລ່ ແອີງ ແບອ໌ ຊັອງ; ອຶມປຶ່ ອັນ ຊັອງ ປັຣນາຍ ໄມ່ ປາຍ, ມາ ອັນ ຕາ ເບີນ ຊາງັດ ປັຣນາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR29_20","021_29_20","PRO","29","20","20","ຄາອ໌ ໄຮ ອຶງກ່ອງ ແຕ ກວາຍ ຊາກູລ, ແຕ ໄຮ ອຶງກ່ອງ ແຕ ກວາຍ ກາ ປາຍ ອາລັ່ອຮ ມາ ຕາ ເບີນ ຄຶ່ດ ອຶນໂຍ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR29_21","021_29_21","PRO","29","21","21","ຄັນ ໄມ່ ປົວະ ເລືອຍໆ ອັນ ກາ ຕະ ຣານະ ໂອນ ໄມ່, ນັ່ບ ແຕ ອັນ ແກີດ ເຕົ່າ ປື່ດ, ນ່ະກັອຍ ອັນ ອາແຕີ່ອ໌ ແອີງ ຣາມຶ່ຮ ງໍ່ ປໍ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("PR29_22","021_29_22","PRO","29","22","22","ກວາຍ ເຮາະ, ອັນ ດຸ ຣາຍົວະ ໂອນ ເນົ່າ ຣາໂລຍຮ, ກະ ກວາຍ ກາ ຮັບ ກຸນເຕົາ, ອັນ ລື່ ຕະ ໂລ່ຍຮ ຊາອຶ່ຍ. ");
INSERT INTO ncq_vpl VALUES ("PR29_23","021_29_23","PRO","29","23","23","ກວາຍ ອາແລ່ະ ອາຊັອຮ ຈະ, ອັນ ຊາແລັຮ; ມາ ຄັນ ອັນ ອາແຊງ ຈະ, ອັນ ເບີນ ຊະເຢືາງ ປັຣເລືາງ ປາເນົາ. ");
INSERT INTO ncq_vpl VALUES ("PR29_24","021_29_24","PRO","29","24","24","ກວາຍ ກາ ປຣ່ອມ ກະ ກວາຍ ຕູຕວຍ໌, ອັນ ຈຸງ ອາປິ່ດ ຈະ ເບີມ. ແຕີ່ອ໌ ເນົ່າ ຕັດຊີ່ນ ແຕ ຣານະ ກັອຍ, ອຶມປຶ່ ອັນ ຊັອງ ຊັນຕອຍ໌ ຣາເວ່ນ ແຕ ກວາຍ ຕາລາ, ລາ ອັນ ຕາ ຍັ່ນ ອາຕີ ປຍາຍ໌ ແຕ ເຢົ່າ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR29_25","021_29_25","PRO","29","25","25","ກວາຍ ອາແລ່ະ ກາ ປັ່ອງ ອຳນາດ ກວາຍ, ລາ ນ່ະ ອັນ ຕານ ຊາງ ກູວາງ ໂຈະ ຈະ ເບີມ; ມາ ກວາຍ ຊາອຳ ເຢືາງ ເຈົາຣາຊີ, ແອີດ ກຼີດ ກຼອດ ຈອດ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR29_26","021_29_26","PRO","29","26","26","ກູ່ ນະ ມັ່ກ ກວາຍ ຊົດ ຕະ ອໍ ໂອນ ໄລ່; ມາ ຣານະ ຕັດຊີ່ນ ກາ ປຍາຍ໌ ອໍ ລາ ແອີງ ເຢືາງ ເຈົາຣາຊີ ຊັອງ ເຕ່ອ໌ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("PR29_27","021_29_27","PRO","29","27","27","ກວາຍ ຕານັ່ອງ ອໍ ຊາອັຣ ກວາຍ ຕາ ອໍ; ກະ ກວາຍ ຕາ ອໍ ຊາອັຣ ເຕ່ ກວາຍ ຕານັ່ອງ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("PR30_1","021_30_1","PRO","30","1","1","ມັຮ ປັຣນາຍ ອາກູຣ ກອນ ຣາເລົາ ຢາເກ ປາຍ ນ່ະໄນ່: ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ແອີດ ກະ ເກົາ! ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ແອີດ ກະ ເກົາ, ກະ ຕາ ເບີນ ເນົ່າ ຣາຈ່ອຍ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("PR30_2","021_30_2","PRO","30","2","2","ເກົາ ແກີດ ນ່ະ ມານຳ ຊັນຕຣັ່ນ, ຕາ ແກີນ ນ່ະ ກວາຍ; ເກົາ ຕາ ເບີນ ຊາປຸ່ຮ ອຶນເຕົ່າ ນ່ະ ກວາຍ ການໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR30_3","021_30_3","PRO","30","3","3","ເກົາ ຕາ ເກີ່ຍ ຣຍານ ປັຣນາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ, ກະ ຕາ ເບີນ ດັງ ອຶນເຕົ່າ ເລີຍ ແຕ ເງ່ ເຢືາງ ເຈົາຣາຊີ, ອັນ ກາ ບຣັຮ ອໍ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR30_4","021_30_4","PRO","30","4","4","ເນົ່າ ກາ ເບີນ ຊັອຮ ປໍ ມັນລັ່ອງ ກະ ແຊງ ລັ່ຮ ດໍອ໌ ອາຕີ ແຕ ຣາມຶ່ຮ ກັອຍ? ເນົ່າ ກາ ເຕ່ອ໌ ຢຸມ ກູຢາລ, ແຕີລາ ກູໂຢບ ແດີອ໌ ຕຶ່ງ ອາຣິ? ເນົ່າ ກາ ຕະ ຣາລັ່ນ ໂອນ ກຣວາງ ກູແຕອ໌ ໄນ່? ອັນ ລາ ເນົ່າ? ກະ ເນົ່າ ລາ ກອນ ຣາເລົາ ອັນ? ເອົາ, ແຊອ໌ ໄມ່ ອາຕີ, ຄັນ ໄມ່ ດັງ! ");
INSERT INTO ncq_vpl VALUES ("PR30_5","021_30_5","PRO","30","5","5","ຣາມຶ່ຮ ເຢືາງ ເຈົາຣາຊີ ປັຣຄັນ ເຕ່ອ໌ ໄຮ ນັ່ບ ເລືອຍໆ. ອັນ ລາ ນ່ະ ແຄລ ໂອນ ມັຮ ກວາຍ ແຕີ່ອ໌ ປັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("PR30_6","021_30_6","PRO","30","6","6","ອຶນໂຈຍ ເຕີມ ມວຍ ຣາມຶ່ຮ ອຶນເຕົ່າ ຕຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ; ຄັນ ໄມ່ ເຕີມ, ລື່ ອັນ ໄຄອ໌ ກະ ອາປັຮ ໂອນ ກວາຍ ດັງ ໄມ່ ລາ ກວາຍ ອາໂລກ. ");
INSERT INTO ncq_vpl VALUES ("PR30_7","021_30_7","PRO","30","7","7","ເອີ ເຢືາງ ເຈົາຣາຊີ ເອີຍ! ແຊອ໌ ເຍືາ ຈ່ອຍ ເກົາ. ເກົາ ແຊອ໌ ບາຣ ຣາມຶ່ຮ ອຶນໂຍ່ງ ເກົາ ກູຈີດ, ");
INSERT INTO ncq_vpl VALUES ("PR30_8","021_30_8","PRO","30","8","8","ລາ ອຶນໂຈຍ ໂອນ ເກົາ ແກີດ ກວາຍ ອາໂລກ, ກະ ອຶນໂຈຍ ໂອນ ເກົາ ແກີດ ຊຸ, ແຕີລາ ກາດີດ. ແຊອ໌ ເຍືາ ຈ່ອຍ ໂອນ ເກົາ ພໍ ຕັອກ ຄຳ ຈາ ລາ ແປະ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("PR30_9","021_30_9","PRO","30","9","9","ຄັນ ເກົາ ມາ ເບີນ ຊາອຶ່ຍ ລາລື່, ອຶງກັອຮ ປຍາຍ໌ ເກົາ ກາແລີຍຮ ເຍືາ. ມາ ຄັນ ເກົາ ກາດີດ ລາລື່, ອຶງກັອຮ ປຍາຍ໌ ເກົາ ເປາະ ຕູຕວຍ໌ ແຕີລາ ໂລ່ບ ເນົ່າ, ກະ ຕະ ໂອນ ເຍືາ, ລາ ເຢືາງ ເຈົາຣາຊີ ເກົາ, ແກີດ ກູມາລ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("PR30_10","021_30_10","PRO","30","10","10","ອຶນໂຈຍ ຕູນ ກວາຍ ຕະ ຣານະ ບັອງ ອັນ ແອີດ ຢັ່ຮ ເມືາງ ເນືາຍ ອັນ; ຄັນ ໄມ່ ຕະ ນ່ະກັອຍ, ອຶງກັອຮ ປຍາຍ໌ ກວາຍ ຕະ ຣານະ ກັອຍ ເວ່ນ ໄມ່, ເຈີ່ ໄມ່ ອຶງເຄາະ ຣັ່ບ ໂຕ່ດ ແຕ ຣານະ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR30_11","021_30_11","PRO","30","11","11","ເບີນ ມັຮ ກວາຍ ດຸ ເວ່ນ ອຶມເປ່ອ໌ ອຶມປໍ່ ເບີມ, ກະ ຕາ ດັງ ຊາແອີນ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("PR30_12","021_30_12","PRO","30","12","12","ເບີນ ມັຮ ກວາຍ ຄຶ່ດ ໄລ່ ບຣັຮ ອໍ, ມາ ໄລ່ ລາ ເຈຍ ແປຣິ່. ");
INSERT INTO ncq_vpl VALUES ("PR30_13","021_30_13","PRO","30","13","13","ເບີນ ມັຮ ກວາຍ ກູລຍາດ ມັ່ດ ໂຈະ ກວາຍ ການໍ່ອ໌, ຍ່ອນ ໄລ່ ຄຶ່ດ ໄລ່ ອໍ ກາເລີຍ ແຕ ກວາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR30_14","021_30_14","PRO","30","14","14","ເບີນ ມັຮ ກວາຍ ແກີດ ນ່ະ ຊັນຕຣັ່ນ ເບີນ ກາແນງ ແກີດ ໂກຼຍ ນ່ະ ດາວ ແຕີລາ ອຶມປຽດ. ໄລ່ ອີ ຕາລອງ ຈາ ອຶນແຍ່ະ ມັຮ ກວາຍ ຕຸ່ຮ ກາດີດ, ກະ ອາປິ່ດ ມັຮ ກວາຍ ຕຸ່ຮ ກູປາຍຮ ມາເຍືາຍຮ ໂດຍ ຕຶ່ງ ກຣວາງ ກູແຕອ໌ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("PR30_15","021_30_15","PRO","30","15","15","ແຕັ່ຮ ເບີນ ບາຣ ນະ ກອນ ມັນແຊມ; ກະ ບາຣ ນະ ມັນແຊມ ກັອຍ ຊາບາວ ປາຍ: ‘ເດີງ ປໍ ໄນ່ ເກົາ ຕາ ຄຳ! ເດີງ ປໍ ໄນ່ ເກົາ ຕາ ຄຳ!’ ເບີນ ປູນ ຣາມຶ່ຮ ຕາ ເກີ່ຍ ຄຳ ລາ ນ່ະໄນ່: ");
INSERT INTO ncq_vpl VALUES ("PR30_16","021_30_16","PRO","30","16","16","ອຶນຕຸ ກວາຍ ກູຈີດ ແອີດ; ມັນແຊມ ກາແດງ; ກູແຕອ໌ ຊາແອີດ ອາກັ່ນ ແດີອ໌ ເມືາ; ກະ ອູ່ຍຮ ເບຼີ ຕາ ເກີ່ຍ ປັດ. ");
INSERT INTO ncq_vpl VALUES ("PR30_17","021_30_17","PRO","30","17","17","ກວາຍ ກາ ອາເຢ່ ພາມາດ ອຶມເປ່ອ໌ ອຶມປໍ່ ແຕີລາ ປາເລີຍ ໄລ່, ປຍາຍ໌ ລາລື່ ກາອາອ໌ ຈັອຮ ຕັຮ ມັ່ດ ອັນ, ກະ ໂອນ ມຽດ ຈາ ຕັຮ ໄຊອ໌ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR30_18","021_30_18","PRO","30","18","18","ເບີນ ປູນ ຣາມຶ່ຮ ເກົາ ຕາ ເບີນ ດັງ ກະ ຊັອງ ງຶ່ດ ລາລື່, ລາ ນ່ະໄນ່: ");
INSERT INTO ncq_vpl VALUES ("PR30_19","021_30_19","PRO","30","19","19","ແຈມ ກາລາງ ປັຣ ປາແຈງ ຕາຕຶ່ງ ຕາໂຕະ ຕຶ່ງ ມັນລັ່ອງ; ກູຊັນ ລາລ່ອຣ ຕຶ່ງ ຕາເມົາ ໂກ່ລ; ຕົວະ ເປາະ ຕຶ່ງ ກຼົງ ທາເລ; ກະ ມັນແຊມ ຣາເລົາ ແກີດ ມານະ ອີ ເບີນ ມານະ. ");
INSERT INTO ncq_vpl VALUES ("PR30_20","021_30_20","PRO","30","20","20","ລາກວຍ ຕາ ເບີນ ຕານັ່ອງ ອີ ຕະ ນ່ະໄນ່: ແວັດ ອັນ ປັຣລື່ຍ, ອັນ ເປາະ ອຶມເປີ່ຍ ແດີອ໌ ໂອນ ບຣັຮ, ເຈີ່ ປາຍ ນ່ະໄນ່: ‘ເກົາ ຕາ ເບີນ ຕະ ໂລ່ຍຮ ອຶນເຕົ່າ!’ ");
INSERT INTO ncq_vpl VALUES ("PR30_21","021_30_21","PRO","30","21","21","ເບີນ ປູນ ຣາມຶ່ຮ ກຣວາງ ກູແຕອ໌ ໄນ່ ຕາ ເຣືາບ ຈີວ໌ ເລີຍ, ລາ ນ່ະໄນ່: ");
INSERT INTO ncq_vpl VALUES ("PR30_22","021_30_22","PRO","30","22","22","ກວາຍ ຊູລ ມາ ຊັອຮ ແກີດ ເຕືາວ ປັຣເຍືາ; ກວາຍ ຊາກູລ ມາ ຈາ ປຣຍາອ໌ ລາລື່; ");
INSERT INTO ncq_vpl VALUES ("PR30_23","021_30_23","PRO","30","23","23","ມັນແຊມ ຕາກົງ ມາ ເບີນ ກາຢາອ໌; ກະ ມັນແຊມ ຊູລ ມາ ແກີດ ຊົດ ອຶນເຈົາ ມັນແຊມ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR30_24","021_30_24","PRO","30","24","24","ຕຶ່ງ ກຣວາງ ກູແຕອ໌ ໄນ່ ເບີນ ປູນ ຊາແນັດ ຊັນຕຣັ່ນ ແກດໆ ລາລື່, ມາ ຣາໄງ່ອ໌ ຣາລັ່ງ ລາລື່, ລາ ນ່ະໄນ່: ");
INSERT INTO ncq_vpl VALUES ("PR30_25","021_30_25","PRO","30","25","25","ຊາໂມຍ໌: ອັນ ອຽວ໌, ມາ ອັນ ປາໂຣມ ດໍອ໌ ມັຮ ຊັຣນາ ບັອງ ຍາມ ປາຣັງ. ");
INSERT INTO ncq_vpl VALUES ("PR30_26","021_30_26","PRO","30","26","26","ກູປີ່: ອັນ ອຽວ໌ ເຕ່, ມາ ອັນ ຕະ ອຶນຕຸ ແອີດ ຕຶ່ງ ປື່ນ ຕາເມົາ. ");
INSERT INTO ncq_vpl VALUES ("PR30_27","021_30_27","PRO","30","27","27","ລາມ: ອັນ ແອິ ເຕືາວ ປັຣເຍືາ, ມາ ແຕີ່ອ໌ ອັນ ລັ່ອຮ, ອັນ ເປາະ ແກີດ ຈຸ່ມ. ");
INSERT INTO ncq_vpl VALUES ("PR30_28","021_30_28","PRO","30","28","28","ຊາແຕນ: ເຕ່ອ໌ ໄມ່ ໂກບ ອັນ ແຕ ອາຕີ ເມືາດ ຊັອງ, ມາ ໄມ່ ເຮີມ ອັນ ປັຣໂກ່ຍ໌ ຊາອຶ່ຍ ລຳ ຕຶ່ງ ດຸງ ເຕືາວ ປັຣເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("PR30_29","021_30_29","PRO","30","29","29","ເບີນ ປູນ ຣາມຶ່ຮ ກາ ຕາຢັຮ ກຣັ່ກ ລາລື່, ລາ ນ່ະໄນ່: ");
INSERT INTO ncq_vpl VALUES ("PR30_30","021_30_30","PRO","30","30","30","ກູລາ ຊິງ ລາ ຊັນຕຣັ່ນ ເຣ່ງ, ກະ ອັນ ເປາະ ລັນຕ່ອຍ໌ໆ ຕາ ເບີນ ອຶງກັອຮ ອຶນເຕົ່າ; ");
INSERT INTO ncq_vpl VALUES ("PR30_31","021_30_31","PRO","30","31","31","ອຶນຕຣວຍ ໂຕ່ງ ເປາະ ແລແຄໆ; ອຶມແບອ໌ ທູ່ນ ເປາະ ຊັນຊິ່ລ; ກະ ເຕືາວ ປັຣເຍືາ ຕາຢັຮ ເພຶອໆ ອຶນໂຍ່ງ ມັຮ ກອນແຊມ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR30_32","021_30_32","PRO","30","32","32","ຄັນ ໄມ່ ລາ ກວາຍ ຊາກູລ ມາ ປັຣໂອດ, ແຕີລາ ອາລັ່ອຮ ເງ່ ຕາ ອໍ, ອຶງເຄາະ ໄມ່ ກູປັດ ຕັຮ ແບອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR30_33","021_30_33","PRO","30","33","33","ຄັນ ໄມ່ ອີດ ແດີອ໌ ຕົຮ, ເຈີ່ ກູວັຣ ເລືອຍໆ, ເຈີ່ ອັນ ກ່ອນ ແກີດ ເກຣີ່ງ ຊັຣນາ. ຄັນ ໄມ່ ຈົ່ກ ມຸ່ຮ ກວາຍ ການໍ່ອ໌, ລາ ອາຮາມ ລັ່ອຮ. ກະ ຄັນ ໄມ່ ຣາຍົວະ ເຕົ່າ ແກີດ ອຶງຄື່ນ, ມາໂຮຍ ແກີດ ຣາໂລຍຮ. ");
INSERT INTO ncq_vpl VALUES ("PR31_1","021_31_1","PRO","31","1","1","ປັຣນາຍ ເຕືາວ ປັຣເຍືາ ເລມູເອລ ຕຽຮ; ປັຣນາຍ ໄນ່ ອຶມເປ່ອ໌ ອັນ ເບີມ ກາ ອາຕີ. ");
INSERT INTO ncq_vpl VALUES ("PR31_2","021_31_2","PRO","31","2","2","ໄມ່ ລາ ກອນ ກາ ອຶມເປ່ອ໌ ອາໂຢ່ະ ລາລື່; ໄມ່ ລາ ເຢືາງ ເຈົາຣາຊີ ໂອນ ຍ່ອນ ເກົາ ແຊອ໌ ແຕ ອັນ. ອຶນເຕົ່າ ດິ ໄມ່ ຢໍອ໌ ເກົາ ອຶມເປ່ອ໌ ອາຕີ ໄມ່? ");
INSERT INTO ncq_vpl VALUES ("PR31_3","021_31_3","PRO","31","3","3","ອຶນໂຈຍ ອາລັ່ອຮ ເຣ່ງ ໄມ່ ເປາະ ລາເງີ່ບ ລາແປີ, ກະ ອຶນໂຈຍ ມ່ອບ ປຣະ ໂອນ ມັນແຊມ ຈິ ຈະ, ຍ່ອນ ມັຮ ມັນແຊມ ກັອຍ ອາປິ່ດ ເຕືາວ ປັຣເຍືາ ຊາອຶ່ຍ ນະ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("PR31_4","021_31_4","PRO","31","4","4","ເລມູເອລ ເອີຍ! ອຶງເຄາະ ໄມ່ ຊາງັດ ນໍ! ຕາ ເບີນ ອໍ ໂອນ ເຕືາວ ປັຣເຍືາ ງ່ອຍ໌ ເລືອຍໆ ບຼັອງ ອາງຸ່ນ, ແຕີລາ ມັ່ກ ລາລື່ ງ່ອຍ໌ ຈາ ກູຕາ ກູລຍາອ໌. ");
INSERT INTO ncq_vpl VALUES ("PR31_5","021_31_5","PRO","31","5","5","ແຕີ່ອ໌ ມັຮ ເຕືາວ ປັຣເຍືາ ງ່ອຍ໌ ບຼັອງ, ໄລ່ ຊາລີຣ ອຶນແຍ່ະ ມັຮ ຄານອດ, ກະ ຕາ ເບີນ ຊາແຍີ ນັ່ອງ ມັຮ ກວາຍ ຕຸ່ຮ ກູປາຍຮ ມາເຍືາຍຮ ໂດຍ. ");
INSERT INTO ncq_vpl VALUES ("PR31_6","021_31_6","PRO","31","6","6","ໂອນ ບຼັອງ ປໍ ກວາຍ ກາ ແຈ່ະ ອີ ກູຈີດ, ກະ ໂອນ ມັຮ ກວາຍ ກາ ຕຸ່ຮ ງໍ່. ");
INSERT INTO ncq_vpl VALUES ("PR31_7","021_31_7","PRO","31","7","7","ໂອນ ໄລ່ ງ່ອຍ໌ ເຢືາອ໌ ຊາລີຣ ຊັອງ ມັຮ ຣາມຶ່ຮ ຕຸ່ຮ ກາດີດ, ກະ ໂອນ ໄລ່ ຕາ ເບີນ ຊາແຍີ ນັ່ອງ ມັຮ ຣາມຶ່ຮ ຕຸ່ຮ ອາຣຶ່ກ. ");
INSERT INTO ncq_vpl VALUES ("PR31_8","021_31_8","PRO","31","8","8","ອຶງເຄາະ ໄມ່ ຣາປາຍ ຈ່ອຍ ມັຮ ກວາຍ ກາ ປາຍ ຕາ ເກືາ ກາຮາ ຕາ ແບຼງ, ດໍອ໌ ຣາຈ່ອຍ ໄລ່ ກາ ແອິ ອຶນຕຸ ປັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("PR31_9","021_31_9","PRO","31","9","9","ອຶງເຄາະ ໄມ່ ຣາປາຍ ຈ່ອຍ ໄລ່, ກະ ປັຣຈີນ ໂອນ ຕານັ່ອງ ລາລື່. ອຶງເຄາະ ໄມ່ ເນ່ ຊາລີອ໌ ກວາຍ ກາ ແອິ ຊັຣນາ ເລືາ ອຶນແຕີດ, ກະ ຕະ ຕານັ່ອງ ຕາປຶ່ງ ເລືອຍໆ ໂຈະ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("PR31_10","021_31_10","PRO","31","10","10","ລາກວຍ ກາ ເບີນ ຣາງຶ່ຮ ຣາແຮີ ອໍ, ລາ ເບີນ ເກືາ ກາເລີຍ ແຕ ມັຮ ຕາເມົາ ເປ່ງ, ມາ ກັ່ດ ລາລື່ ອີ ຣາມົຮ ມັນແຊມ ກາ ນ່ະກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR31_11","021_31_11","PRO","31","11","11","ກາຢາອ໌ ນັ່ບ ອຶນແຍ່ະ ຣາງຶ່ຮ ລາກວຍ ກາ ເບີນ ຣາງຶ່ຮ ອໍ, ກະ ຕາ ເກີ່ຍ ແອິ ມວຍ ຣາມຶ່ຮ ອໍ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("PR31_12","021_31_12","PRO","31","12","12","ຊົດ ແດີຍ ອາມົ່ງ, ມັນແຊມ ກັອຍ ຕະ ແອີງ ຣານະ ອໍ ໂອນ ກາຢາອ໌ ອັນ; ກະ ອັນ ຕາ ເກີ່ຍ ຕະ ຕາ ອໍ ອຶນເຕົ່າ ໂຈະ ກາຢາອ໌ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR31_13","021_31_13","PRO","31","13","13","ອາຕີ ອັນ ແຕັຮ ຕານ ຕາ ເກີ່ຍ ຕາງິ່ດ, ອັນ ຕານ ຕຳປັອກ ແຕ ໂຊະ ແກະ ກະ ອາຣິ ກຼໍອ໌ ລາເກືາ ເປ່ງ. ");
INSERT INTO ncq_vpl VALUES ("PR31_14","021_31_14","PRO","31","14","14","ອັນ ປາໂຣມ ດໍອ໌ ເກຣີ່ງ ຊັຣນາ ຊາອຶ່ຍ ລາລື່ ຕຶ່ງ ດຸງ ອັນ, ນ່ະ ຕົວະ ລາຮອຍ ປາຕຸ່ ມັຮ ເກຣີ່ງ ຈິແຈີງ ແຕ ອຶນຕຸ ກາ ເຢີ່ງ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR31_15","021_31_15","PRO","31","15","15","ອັນ ຕາແມີ ແຕ ອຶນນັ່ອງ ການຳ ດໍອ໌ ກຽມ ຊັຣນາ ໂອນ ດຸງຊູ ອັນ, ດິ່ຮ ກຽມ ຣານະ ໂອນ ມັຮ ມັນແຊມ ກາ ຕະ ຣານະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR31_16","021_31_16","PRO","31","16","16","ອັນ ຣຽຮ ກະ ແຈີງ ອຶນຕຸ ກູແຕອ໌ ດໍອ໌ ຕະ ຊວນ ຈົຮ ປາໄລ ອາງຸ່ນ ແຕ ປຣະ ອັນ ຈໍ່ອ໌ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("PR31_17","021_31_17","PRO","31","17","17","ອັນ ລາ ມັນແຊມ ເຣ່ງ ກະ ແທຣິງ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR31_18","021_31_18","PRO","31","18","18","ອັນ ດັງ ເງ່ ຈິແຈີງ ກາ ເບີນ ກຳໄລ, ກະ ອັນ ຕະ ຣານະ ຕາພັອງ ດີດຶ່ກ ດີດື່ນ. ");
INSERT INTO ncq_vpl VALUES ("PR31_19","021_31_19","PRO","31","19","19","ອັນ ອູອຍາດ ເບີມ ກູປາຍຮ, ກະ ຕານ ເລືອຍໆ ອາຣິ. ");
INSERT INTO ncq_vpl VALUES ("PR31_20","021_31_20","PRO","31","20","20","ອັນ ເບີນ ຣາງຶ່ຮ ຕາຮັຣ ໂຈະ ກວາຍ ກາດີດ ກະ ກວາຍ ຕຸ່ຮ ອາຣຶ່ກ. ");
INSERT INTO ncq_vpl VALUES ("PR31_21","021_31_21","PRO","31","21","21","ພໍກາ ແຕີ່ອ໌ ຍາມ ອາງີ່ນ, ອັນ ຕາ ເບີນ ຄຶ່ດ ອຶນເຕົ່າ, ຍ່ອນ ກອນ ກາຢາອ໌ ອັນ ເຈີ່ ເບີນ ກູ່ ມັຮ ຕຳປັອກ ໂອນ ແກີດ ຊັງອຳ. ");
INSERT INTO ncq_vpl VALUES ("PR31_22","021_31_22","PRO","31","22","22","ອັນ ຕານ ດໍອ໌ ອາແຢີ ກະ ຕຳປັອກ ແຕ ອາຣິ ແຈບ ອໍ ຊີ ອາອູຍ. ");
INSERT INTO ncq_vpl VALUES ("PR31_23","021_31_23","PRO","31","23","23","ຣາມຶ່ຮ ກາຢາອ໌ ອັນ ແກີດ ດັອຮ ບຸມບວລ ຮູລ ຢຸນຢົ່ງ, ກະ ກາຢາອ໌ ອັນ ຕາກູ ມັນຕຸ ກະ ກວາຍ ອາໂຢ່ງ ມັຮ ກອນແຊມ. ");
INSERT INTO ncq_vpl VALUES ("PR31_24","021_31_24","PRO","31","24","24","ອັນ ຕະ ຕຳປັອກ ແຕ ອາຣິ ກຼໍອ໌ ແຈບ ອໍ, ຕະ ກັນຕັ່ນ, ກະ ຈິ ໂອນ ກວາຍ ລາຮອຍ. ");
INSERT INTO ncq_vpl VALUES ("PR31_25","021_31_25","PRO","31","25","25","ອັນ ລາ ມັນແຊມ ບັນ ເຣ່ງ ລາລື່ ກະ ເບີນ ຊະເຢືາງ; ກະ ອັນ ຕາ ເບີນ ຄຶ່ດ ອຶງກັອຮ ອຶນເຕົ່າ ແຕ ແດີຍ ອາມົ່ງ ອັນ ປໍ ເມືາງ. ");
INSERT INTO ncq_vpl VALUES ("PR31_26","021_31_26","PRO","31","26","26","ອັນ ຕະ ອຶນຕີ ລາວິ່ ນ່ະ ດາຍ ລາເວືາຍ ນ່ະ ແດີອ໌; ກະ ອັນ ກາໄຕ່ຮ ອາຕີ ອຶນເຕົ່າ ລາ ແຄວ໌ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("PR31_27","021_31_27","PRO","31","27","27","ອັນ ເນ່ ເລືອຍໆ ມັຮ ຣານະ ແຕ ດຸງຊູ ອັນ; ກະ ອັນ ກູດຸ ຕະ ກາດະ ຈາ ເລືອຍໆ. ");
INSERT INTO ncq_vpl VALUES ("PR31_28","021_31_28","PRO","31","28","28","ມັຮ ກອນ ອັນ ຊັອງ ຣໍ່ອ໌ ລາລື່ ໂຈະ ອັນ ກະ ປາຍ ບຸ່ນ ໂອນ ອັນ; ກະ ກາຢາອ໌ ອັນ ຍ່ອງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR31_29","021_31_29","PRO","31","29","29","ກາຢາອ໌ ອັນ ປາຍ ນ່ະໄນ່: “ມັນແຊມ ເບີນ ຣາງຶ່ຮ ອໍ ລາ ຊາອຶ່ຍ ນະ, ມາ ໄມ່ ເບີນ ຣາງຶ່ຮ ອໍ ກາເລີຍ ແຕ ມັຮ ມັນແຊມ ກັອຍ.” ");
INSERT INTO ncq_vpl VALUES ("PR31_30","021_31_30","PRO","31","30","30","ຊາແນ ແກີດ ອໍ ບີ່ອ໌ ຢັ່ຮ ນໍ່ອ໌ ຊັອງ, ກະ ຣູ່ບເຣືາງ ອໍ ລາ ມາໂຮຍ ຊັອງ; ມາ ມັນແຊມ ກາ ຢຳນັ່ບ ເຢືາງ ເຈົາຣາຊີ, ປຍາຍ໌ ເນົ່າ ຍ່ອງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("PR31_31","021_31_31","PRO","31","31","31","ອຶງເຄາະ ເຍືາ ກູລັຮ ເກືາ ເຣ່ງ ໂອນ ມັນແຊມ ໄນ່ ຍ່ອນ ແຕ ມັຮ ຣານະ ອັນ ຕະ. ປຍາຍ໌ ລາລື່ ໂອນ ກູ່ ນະ ກຳ ຢຳ ປັຣນາຍ ອັນ.");
INSERT INTO ncq_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ເຢຊູ ກຣີດ ແຕີ່ອ໌ ແຕ ຈຸ່ມເຈືອ ດາວິດ; ກະ ດາວິດ ແຕີ່ອ໌ ແຕ ຈຸ່ມເຈືອ ອັບຣາຮາມ. ອຶນແຍ່ະ ມັຮ ຣາມຶ່ຮ ອາຈວາຍຮ ອາເຈ່ຮ ເຢຊູ ລາ ນ່ະໄນ່: ");
INSERT INTO ncq_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ອັບຣາຮາມ ລາ ອຶມປໍ່ ອີຊາກ. ອີຊາກ ລາ ອຶມປໍ່ ຢາໂຄບ. ຢາໂຄບ ລາ ອຶມປໍ່ ຢູດາ ກະ ອຶນແຍ່ະ ມັຮ ແຊມອາຍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ຢູດາ ລາ ອຶມປໍ່ ບາຣ ນະ ເປເຣັດ ກະ ເຊຣາ; ກະ ອຶມເປ່ອ໌ ໄລ່ ບາຣ ນະ ກັອຍ ລາ ຕາມາ. ເປເຣັດ ລາ ອຶມປໍ່ ເຮຊະໂຣນ. ເຮຊະໂຣນ ລາ ອຶມປໍ່ ຣາມ. ");
INSERT INTO ncq_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ຣາມ ລາ ອຶມປໍ່ ອຳມີນາດາບ. ອຳມີນາດາບ ລາ ອຶມປໍ່ ນາໂຊນ. ນາໂຊນ ລາ ອຶມປໍ່ ຊັລໂມນ. ");
INSERT INTO ncq_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ຊັລໂມນ ລາ ອຶມປໍ່ ໂບອາດ; ກະ ອຶມເປ່ອ໌ ໂບອາດ ລາ ຣາຮາບ. ໂບອາດ ລາ ອຶມປໍ່ ໂອເບັດ; ກະ ອຶມເປ່ອ໌ ໂອເບັດ ລາ ຣຸດ. ໂອເບັດ ລາ ອຶມປໍ່ ເຢຊີ. ");
INSERT INTO ncq_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ເຢຊີ ລາ ອຶມປໍ່ ເຕືາວ ປັຣເຍືາ ດາວິດ. ດາວິດ ລາ ອຶມປໍ່ ໂຊໂລໂມນ; ກະ ອຶມເປ່ອ໌ ໂຊໂລໂມນ ລາ ບາດເຊບາ. ແຕ ອຶນໂຍ່ງ ອຶມເປ່ອ໌ ອັນ ລາ ລາກວຍ ອູຣີຢາ. ");
INSERT INTO ncq_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ໂຊໂລໂມນ ລາ ອຶມປໍ່ ເຣໂຮໂບອາມ. ເຣໂຮໂບອາມ ລາ ອຶມປໍ່ ອາບີຢາ. ອາບີຢາ ລາ ອຶມປໍ່ ອາຊາ. ");
INSERT INTO ncq_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ອາຊາ ລາ ອຶມປໍ່ ເຢໂຮຊາພັດ. ເຢໂຮຊາພັດ ລາ ອຶມປໍ່ ເຢໂຮຣາມ. ເຢໂຮຣາມ ລາ ອຶມປໍ່ ອຸດຊີຢາ. ");
INSERT INTO ncq_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ອຸດຊີຢາ ລາ ອຶມປໍ່ ໂຢທາມ. ໂຢທາມ ລາ ອຶມປໍ່ ອາຮາດ. ອາຮາດ ລາ ອຶມປໍ່ ເຮເຊກີຢາ. ");
INSERT INTO ncq_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ເຮເຊກີຢາ ລາ ອຶມປໍ່ ມານາເຊ. ມານາເຊ ລາ ອຶມປໍ່ ອາໂມນ. ອາໂມນ ລາ ອຶມປໍ່ ໂຢຊີຢາ. ");
INSERT INTO ncq_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ໂຢຊີຢາ ອາເມືາ ເຢໂຮຍອາກິນ ກະ ອຶນແຍ່ະ ມັຮ ແຊມອາຍ ອັນ ບັອງ ກາ ກວາຍ ບາບີໂລນ ໂກບ ເດີງ ກວາຍ ອິດຊະຣາເອລ ປໍ ກຣວາງ ບາບີໂລນ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ແວັດ ເນົ່າ ໂກບ ເດີງ ກວາຍ ອິດຊະຣາເອລ ແອີດ ປໍ ກຣວາງ ບາບີໂລນ, ນ່ະກັອຍ ເຢໂຮຍອາກິນ ອາເມືາ ເຊອານຕີເອລ. ເຊອານຕີເອລ ລາ ອຶມປໍ່ ເຊຣຸບບາເບລ. ");
INSERT INTO ncq_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ເຊຣຸບບາເບລ ລາ ອຶມປໍ່ ອາບີອຸດ. ອາບີອຸດ ລາ ອຶມປໍ່ ເອລີອາກິມ. ເອລີອາກິມ ລາ ອຶມປໍ່ ອາເຊຣີ. ");
INSERT INTO ncq_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ອາເຊຣີ ລາ ອຶມປໍ່ ຊາດົກ. ຊາດົກ ລາ ອຶມປໍ່ ອາກີມ. ອາກີມ ລາ ອຶມປໍ່ ເອລີອຸດ. ");
INSERT INTO ncq_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ເອລີອຸດ ລາ ອຶມປໍ່ ເອເລອາຊາຣ. ເອເລອາຊາຣ ລາ ອຶມປໍ່ ມັດທານ. ມັດທານ ລາ ອຶມປໍ່ ຢາໂຄບ. ");
INSERT INTO ncq_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ຢາໂຄບ ລາ ອຶມປໍ່ ໂຢເຊັບ. ໂຢເຊັບ ລາ ກາຢາອ໌ ມາຣີ. ກະ ມາຣີ ລາ ອຶມເປ່ອ໌ ເຢຊູ, ລາ ອັນ ກາ ເນົ່າ ດໍອ໌ ກຣີດ. ");
INSERT INTO ncq_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ນ່ະກັອຍ, ແຕ ແດີຍ ອັບຣາຮາມ ແຕີ່ອ໌ ແດີຍ ດາວິດ ລາ ເບີນ ມັນຈິ່ດ ລາ ປູນ ແດີຍ. ນັ່ບ ແຕ ແດີຍ ດາວິດ ແຕີ່ອ໌ ແດີຍ ເນົ່າ ໂກບ ກວາຍ ອິດຊະຣາເອລ ເດີງ ປໍ ກຣວາງ ບາບີໂລນ ລາ ເບີນ ມັນຈິ່ດ ລາ ປູນ ແດີຍ. ເຈີ່ ແຕ ແດີຍ ເນົ່າ ໂກບ ກວາຍ ອິດຊະຣາເອລ ເດີງ ປໍ ກຣວາງ ບາບີໂລນ ເຕົ່າ ແຕີ່ອ໌ ແດີຍ ເຢຊູ ກຣີດ ລາ ເບີນ ມັນຈິ່ດ ລາ ປູນ ແດີຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ເຢຊູ ກຣີດ ແກີດ ມັຮ ປັຣນາຍ ໄນ່ ອາຕີ. ມາຣີ, ອຶມເປ່ອ໌ ເຢຊູ, ລາ ຊຳປົວະ ໂຢເຊັບ. ໂຢເຊັບ ຕາ ຢວາຮ ອີດ ມາຣີ, ມາ ມາຣີ ແອີດ ຕຶ່ງ ຈະ ເຈີ່ ແຕ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ຍ່ອນ ໂຢເຊັບ ລາ ກວາຍ ມັນຕັ່ດ, ອັນ ຕາ ຢໍອ໌ ອີ ໂອນ ມາຣີ ກູມາລ ຕະ ເນົ່າ. ອັນ ແອີດ ຄຶ່ດ ຕຶ່ງ ຣາງຶ່ຮ ອັນ, ປາໂຕ່ະ ປັຣນາຍ ອີ ຕັຮ ມາຣີ. ");
INSERT INTO ncq_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ບັອງ ກາ ອັນ ແອີດ ຄຶ່ດ ຣານະ ກັອຍ, ອັນ ຣາເລົາ ອຶມເປົາ. ອັນ ເຮີມ ມານະ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ແຕີ່ອ໌ ປໍ ອັນ. ເທວາດາ ກັອຍ ປາຍ: \"ໂຢເຊັບ ເອີຍ! ໄມ່ ກາ ກວາຍ ແຕ ຈຸ່ມເຈືອ ດາວິດ. ໄມ່ ອຶນໂຈຍ ອຶງກັອຮ ອີດ ມາຣີ ຕະ ລາກວຍ ໄມ່, ຍ່ອນ ອັນ ແອີດ ຕຶ່ງ ຈະ ກອນ ແຕ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ປັຣແນີ ມັນເຕຣືາ ອັນ ຣັ່ຮ ກອນ ຣາເລົາ. ໄມ່ ດໍອ໌ ຣາມຶ່ຮ ກອນ ກັອຍ ລາ ເຢຊູ, ຍ່ອນ ອັນ ຈ່ອຍ ອາມົ່ງ ອຶນແຍ່ະ ມັຮ ກວາຍ ອັນ, ກະ ຕັຮ ໂລ່ຍຮ ໄລ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ອຶນແຍ່ະ ຣານະ ໄນ່ ແກີດ ຊັງໄກຣ ກະ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ອຶນໂຍ່ງ ຣານາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ອັນ ແຕ ອຶມແບິ. ກວາຍ ກັອຍ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","\"ເຈີ່ ປໍ ເມືາງ ເບີນ ມານະ ກູໂມຣ ຕາ ເບີນ ບິ ກະ ຣາເລົາ ມາ ອັນ ແອີດ ຕຶ່ງ ຈະ. ອັນ ຣັ່ຮ ກອນ ຣາເລົາ. ເນົ່າ ດໍອ໌ ກອນ ກັອຍ ເອມານູເອລ.\" (ປັຣນາຍ ເອມານູເອລ ໄນ່ ຕະ ອຶນຕີ ລັ່ຮ ລາ 'ເຢືາງ ເຈົາຣາຊີ ແອີດ ກະ ໄຮ.') ");
INSERT INTO ncq_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ພໍກາ ໂຢເຊັບ ຕາແມີ, ອັນ ຕະ ຕາປູ່ນ ອຶນແຍ່ະ ມັຮ ປັຣນາຍ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ໂອນ ອັນ ອີດ ມາຣີ ຕະ ລາກວຍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ມາ ອັນ ຕາ ຢວາຮ ບິ ມັນຕຸ ກະ ມາຣີ ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ມາຣີ ຣັ່ຮ ກອນ ຣາເລົາ ກັ່ລ. ກະ ອັນ ດໍອ໌ ຣາມຶ່ຮ ກອນ ກັອຍ ລາ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ເຢຊູ ແກີດ ຕຶ່ງ ເມືອງ ເບັດເລເຮັມ, ແຄງ ຢູດາຍ, ບັອງ ກາ ແດີຍ ເຮໂຣດ ແກີດ ເຕືາວ ປັຣເຍືາ. ແວັດ ກັອຍ ເບີນ ກວາຍ ກາ ດັງ ແຕ ມັນໂຕຣ ແຕີ່ອ໌ ປໍ ເມືອງ ເຢຣູຊາເລັມ ແຕ ກຣວາງ ໄລ່, ຢັ່ຮ ມັ່ດ ມານາງ ລັ່ອຮ. ");
INSERT INTO ncq_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ໄລ່ ກັອຍ ຕາແບີບ ປາຍ: \"ປໍ ແລ່ະ ອັນ ກາ ຕາແບິ ແກີດ ປັຣແນີ ມັນເຕຣືາ ແກີດ ເຕືາວ ປັຣເຍືາ ກວາຍ ອິດຊະຣາເອລ? ຮິ ເຮີມ ເຈີ່ ມັນໂຕຣ ອັນ ແຕ ມັ່ດ ມານາງ ລັ່ອຮ. ນ່ະກັອຍ ຮິ ແຕີ່ອ໌ ອີ ຊາງ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ພໍກາ ເຕືາວ ປັຣເຍືາ ເຮໂຣດ ຊັອງ ປັຣນາຍ ໄນ່, ອັນ ຊັອງ ເກຣ່າະ ລາລື່, ກະ ອຶນແຍ່ະ ມັຮ ກວາຍ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ ລາ ຊັອງ ເກຣ່າະ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ເຮໂຣດ ປາໂຣມ ອຶນແຍ່ະ ມັຮ ກວາຍ ຊົດ ມູ່ ໄລ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ກະ ມັຮ ກວາຍ ອາຕີ ຄານອດ ຈຸ່ມ ອິດຊະຣາເອລ ແອີດ ຕຶ່ງ ເມືອງ ກັອຍ. ອັນ ຕາແບີບ ໄລ່ ກັອຍ ປາຍ: \"ປໍ ແລ່ະ ກຣີດ ແກີດ, ອັນ ກາ ເຢືາງ ເຈົາຣາຊີ ຣຽຮ ໂອນ ຈ່ອຍ ອາມົ່ງ ກວາຍ?\" ");
INSERT INTO ncq_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ໄລ່ ກັອຍ ຕາແອີຍ ປາຍ: \"ກຣີດ ແກີດ ຕຶ່ງ ເມືອງ ເບັດເລເຮັມ, ແຄງ ຢູດາຍ, ຍ່ອນ ເບີນ ມານະ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ຄຽນ ດໍອ໌ ແຕ ອຶມແບິ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","'ເອີ ເມືອງ ເບັດເລເຮັມ ແຄງ ຢູດາຍ ເອີຍ! ໄມ່ ລາ ຕາ ແກີນ ເມືອງ ກາ ເບີນ ອຳນາດ ແກດໆ, ຄັນ ຕາລີ ກະ ມັຮ ເມືອງ ການໍ່ອ໌ ຕຶ່ງ ແຄງ ຢູດາຍ. ຍ່ອນ ເບີນ ມານະ ແຕີ່ອ໌ ແຕ ໄມ່ ກາ ເບີນ ຊົດ ປື່ດ ລາລື່. ອັນ ອາໂຢ່ງ ມັຮ ກອນແຊມ ເກົາ, ລາ ກວາຍ ອິດຊະຣາເອລ.'\" ");
INSERT INTO ncq_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ແວັດ ກັອຍ ເຮໂຣດ ກູອ໌ ຕວຍ໌ ມັຮ ກວາຍ ກາ ດັງ ແຕ ມັນໂຕຣ ກະ ຕາແບີບ ໄລ່ ກັອຍ ກຣັ່ກ ລາລື່ ບັອງ ແລ່ະ ໄລ່ ເຮີມ ມັນໂຕຣ ກັອຍ ລັ່ອຮ? ");
INSERT INTO ncq_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ນ່ະກັອຍ ອັນ ແປຣີ ມູ່ ກາ ດັງ ແຕ ມັນໂຕຣ ເປາະ ປໍ ເມືອງ ເບັດເລເຮັມ. ອັນ ອາຕີ ໄລ່ ປາຍ: \"ເຍືາ ເປາະ ຈໍ່ອ໌ ກຣັ່ກ ລາລື່ ກອນ ກັອຍ. ແຕີ່ອ໌ ເຍືາ ຣາມົຮ ກອນ ກັອຍ, ເຍືາ ອາຕີ ເກົາ ແຮີ. ເກົາ ລາ ອີ ເປາະ ຊາງ ອັນ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ແວັດ ໄລ່ ຊາງັດ ປັຣນາຍ ເຕືາວ ປັຣເຍືາ ປາຍ ນ່ະກັອຍ, ໄລ່ ເປາະ ລັ່ຮ. ກະ ໄລ່ ເຮີມ ລັ່ຮ ມັນໂຕຣ ຢັ່ຮ ມັ່ດ ມານາງ ລັ່ອຮ. ມັນໂຕຣ ກັອຍ ເປາະ ອຶນໂຍ່ງ ໄລ່, ກະ ຕາງິ່ດ ຕາປຶ່ງ ອຶນຕຸ ກອນ ກັອຍ ແອີດ. ");
INSERT INTO ncq_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ແຕີ່ອ໌ ກວາຍ ກາ ດັງ ແຕ ມັນໂຕຣ ເຮີມ ລັ່ຮ ມັນໂຕຣ ກັອຍ, ໄລ່ ຊັອງ ຣໍ່ອ໌ ບູຍ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ບັອງ ກາ ໄລ່ ມູ່ດ ຕຶ່ງ ດຸງ, ໄລ່ ເຮີມ ກອນ ກັອຍ ກະ ມາຣີ, ອຶມເປ່ອ໌ ອັນ. ໄລ່ ກຼຸ່ ຣາໂກລ ຊາງ ກອນ ກັອຍ. ເຈີ່ ໄລ່ ເປິຮ ຮີ່ບ ກາ ເບີນ ເກຣີ່ງ ເກືາ ເປ່ງ ລາລື່, ອາລັ່ອຮ ມ່ອບ ໂອນ ກອນ ກັອຍ ລາ ແຢງ, ຣາແລງ ອາລ່ອງ ປາຮວມ, ກະ ຊຽດ ອາລ່ອງ ປາຮວມ. ");
INSERT INTO ncq_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ເຈີ່ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ລັ່ຮ ໄລ່ ແຕ ປາເນົາ ໄລ່ ຣາເລົາ ອຶມເປົາ ໂອນ ໄລ່ ອຶນໂຈຍ ເຈົາ ນັ່ອງ ປໍ ດຸງ ເຮໂຣດ. ນ່ະກັອຍ ໄລ່ ເຈົາ ປໍ ກຣວາງ ໄລ່, ມາ ເຈົາ ລັ່ຮ ຣານາ ການໍ່ອ໌ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ພໍກາ ແວັດ ກວາຍ ກາ ດັງ ແຕ ມັນໂຕຣ ເຈົາ ເຈີ່, ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ແຕີ່ອ໌ ປໍ ໂຢເຊັບ ຣານາ ຣາເລົາ ອຶມເປົາ, ປາຍ: \"ໄມ່ ຢວຣ ຕາຢຶ່ງ, ເດີງ ກອນ ກະ ອຶມເປ່ອ໌ ອັນ ລັ່ອຮ ເປາະ ປໍ ກຣວາງ ເອຢິບ ແອັນ. ເຍືາ ແອີດ ຕຶ່ງ ກຣວາງ ກັອຍ ເວືາຍ ເຕົ່າ ແຕີ່ອ໌ ເກົາ ອາຕີ ລັ່ຮ ໂອນ ເຍືາ ເຈົາ, ຍ່ອນ ເຕືາວ ປັຣເຍືາ ເຮໂຣດ ຢໍອ໌ ອີ ກາຈີດ ກອນ ເຍືາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ນ່ະກັອຍ ໂຢເຊັບ ຢວຣ ຕາຢຶ່ງ. ແຕ ອຶນນັ່ອງ ການຳ ອັນ ເດີງ ອຶມເປ່ອ໌ ກະ ກອນ ກັອຍ ຕາລຸ່ຮ ແອີດ ຕຶ່ງ ກຣວາງ ເອຢິບ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ໄລ່ ແອີດ ປໍ ກັອຍ ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ເຮໂຣດ ກູຈີດ. ຣານະ ໄນ່ ຣາປຍາຍ໌ ກະ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ປາຍ ຣານາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ ປາຍ: \"ເກົາ ກູອ໌ ກອນ ເກົາ ລັ່ອຮ ແຕ ກຣວາງ ເອຢິບ.\" ");
INSERT INTO ncq_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ພໍກາ ເຮໂຣດ ດັງ ກວາຍ ກາ ດັງ ແຕ ມັນໂຕຣ ອາໂລກ ອັນ, ອັນ ຊັອງ ອວານ ລາລື່. ອັນ ແປຣີ ໂອນ ເນົ່າ ກາຈີດ ອຶນແຍ່ະ ມັຮ ກັຣແນນ ຣາເລົາ ເຕີ ບາຣ ກູມໍ ອາແຊງ ແອີດ ຕຶ່ງ ເມືອງ ເບັດເລເຮັມ ກະ ມັຮ ເມືອງ ການໍ່ອ໌ ແອີດ ອຶມແປຣ ເມືອງ ກັອຍ ແຮີ, ຍ່ອນ ອັນ ຊາແຍີ ແຕ ຕາໄງ ກວາຍ ກາ ດັງ ແຕ ມັນໂຕຣ ອາຕີ ໂອນ ອັນ ດັງ. ");
INSERT INTO ncq_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ນ່ະກັອຍ ແກີດ ຣາປຍາຍ໌ ປັຣນາຍ ເຢເຣມີຢາ, ອັນ ກາ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ປາຍ ແຕ ອຶມແບິ ນ່ະໄນ່: ");
INSERT INTO ncq_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","\"ເນົ່າ ຊັອງ ເບີນ ຊຽງ ກູໂກຼຍ໌ ກູເກຼ່ງ ແຕ ວີ່ລ ຣາມາ, ອາມໍອ໌ ຣາເຊລ ເຍືາມ ຊາແຍີ ກອນ ອັນ. ອັນ ຕາ ເບີນ ຊາງັດ ປັຣນາຍ ເນົ່າ ຕາລື່ນ, ຍ່ອນ ກອນ ອັນ ຕາ ເບີນ ນັ່ອງ.\" ");
INSERT INTO ncq_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ແວັດ ເຮໂຣດ ກູຈີດ ເຈີ່, ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ແຕີ່ອ໌ ລັ່ຮ ປໍ ໂຢເຊັບ ແອີດ ຕຶ່ງ ກຣວາງ ເອຢິບ ແຕ ອັນ ຣາເລົາ ອຶມເປົາ. ");
INSERT INTO ncq_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ເທວາດາ ກັອຍ ປາຍ: \"ຢວຣ ຕາຢຶ່ງ. ເດີງ ກອນ ກະ ອຶມເປ່ອ໌ ອັນ ເປາະ ເຈົາ ລັ່ຮ ປໍ ກຣວາງ ອິດຊະຣາເອລ, ຍ່ອນ ກວາຍ ກາ ຢໍອ໌ ອີ ກາຈີດ ກອນ ໄມ່, ອັນ ກູຈີດ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ນ່ະກັອຍ ໂຢເຊັບ ຢວຣ ຕາຢຶ່ງ, ເດີງ ກອນ ລາກວຍ ອັນ ເຈົາ ລັ່ຮ ປໍ ກຣວາງ ອິດຊະຣາເອລ. ");
INSERT INTO ncq_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ມາ ພໍກາ ໂຢເຊັບ ຊັອງ ເນົ່າ ປາຍ ອາກເຄລາວ ແກີດ ເຕືາວ ປັຣເຍືາ ຕຶ່ງ ແຄງ ຢູດາຍ ເຕ່ນ ລັ່ຮ ເຮໂຣດ, ອຶມປໍ່ ອັນ; ນ່ະກັອຍ ໂຢເຊັບ ອຶງກັອຮ ອີ ເຈົາ ປໍ ກັອຍ. ມາ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ລັ່ຮ ອັນ ຣານາ ຣາເລົາ ອຶມເປົາ. ເຈີ່ ອັນ ເປາະ ປໍ ແຄງ ຄາລີເລ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ອັນ ເປາະ ແອີດ ຕຶ່ງ ວີ່ລ ນາຊາເຣັດ. ນ່ະກັອຍ ແກີດ ຣາປຍາຍ໌ ນ່ະ ປັຣນາຍ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ປາຍ ແຕ ອຶມແບິ ນ່ະໄນ່: \"ເນົ່າ ດໍອ໌ ອັນ ລາ ກວາຍ ນາຊາເຣັດ.\" ");
INSERT INTO ncq_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ບັອງ ກາ ກັອຍ, ໂຢຮັນ ກາ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ແຕີ່ອ໌ ອາຕີ ແຕ ຣານະ ເຢືາງ ເຈົາຣາຊີ ປໍ ຕຍາຮ ຕຶ່ງ ແຄງ ຢູດາຍ. ");
INSERT INTO ncq_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ອັນ ອາຕີ ປາຍ: \"ອຶງເຄາະ ເຍືາ ປຽນ ອີດ ຣາງຶ່ຮ ຕາໄມ ແອັນ, ຍ່ອນ ແຈ່ະ ເຈີ່ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ.\" ");
INSERT INTO ncq_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ເອຊາຢາ, ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ອາຕີ ແຕ ໂຢຮັນ ປາຍ: \"ເບີນ ຊຽງ ເນົ່າ ຊາບາວ ອາຕີ ເຣ່ງ ລາລື່ ແຕ ຕຍາຮ ປາຍ: 'ເຍືາ ອຶງເຄາະ ອາຕຶ່ ຣານາ ໂອນ ອຶນເຈົາ ໄຮ. ຕະ ໂອນ ຕານັ່ອງ ຣານາ ອັນ ອີ ເປາະ.'\" ");
INSERT INTO ncq_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ໂຢຮັນ ໄນ່ ເກີ່ຍ ຕັອກ ຕຳປັອກ ເນົ່າ ຕະ ແຕ ໂຊະ ອູ່ດ. ກະ ອັນ ກັນຕັ່ນ ດໍອ໌ ອຶງກັຣ ຊັນຕຣັ່ນ ຕຶ່ງ ອຶງກີງ ອັນ. ອັນ ຈາ ລາມ, ກະ ອັນ ງ່ອຍ໌ ແດີອ໌ ກາຮຍາລ ແຕ ຕຍາຮ. ");
INSERT INTO ncq_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ເບີນ ກວາຍ ແຕີ່ອ໌ ປໍ ອັນ ແຕ ເມືອງ ເຢຣູຊາເລັມ, ກະ ຈວບ ອຶນແຍ່ະ ແຄງ ຢູດາຍ, ກະ ກວາຍ ກາ ແອີດ ອຶມແປຣ ຕາເລ່ ຈໍແດນ. ");
INSERT INTO ncq_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ໄລ່ ງີ່ນ ໂລ່ຍຮ, ເຈີ່ ໂຢຮັນ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ໄລ່ ຕຶ່ງ ຕາເລ່ ຈໍແດນ. ");
INSERT INTO ncq_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ພໍກາ ໂຢຮັນ ເຮີມ ກຼຶ່ງ ກວາຍ ແຕ ຈຸ່ມ ພາຣີຊາຍ ກະ ຈຸ່ມ ຊາດູກາຍ, ແຕີ່ອ໌ ປໍ ອັນ ໂອນ ອັນ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ໄລ່, ນ່ະກັອຍ ອັນ ປາຍ ໂຈະ ໄລ່ ກັອຍ: \"ເຍືາ ລາ ປຼາ ນ່ະ ກູຊັນ ຕູ່ຣ. ເຍືາ ຕາ ເຕ່ອ໌ ວຍາຣ ແວັດ ແຕ ເຢືາງ ເຈົາຣາຊີ ຕະ ເຍືາ ແຕີ່ອ໌ ອັນ ຕະ ໂຕ່ດ ກວາຍ ໂລ່ຍຮ ຕຶ່ງ ຕາໄງ ປັຣຊົດ. ");
INSERT INTO ncq_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ອຶງເຄາະ ເຍືາ ຕະ ຣານະ ອໍ. ໄນ່ ລາ ອາປັຮ ໂອນ ເນົ່າ ດັງ ເຍືາ ປຽນ ແກີດ ຣາງຶ່ຮ ຕາໄມ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ເຍືາ ອຶນໂຈຍ ຄຶ່ດ ປາຍ ເຍືາ ເຕ່ອ໌ ວຍາຣ ແວັດ ແຕ ໂຕ່ດ ໄນ່ ຍ່ອນ ເຍືາ ປາຍ: 'ອັບຣາຮາມ ລາ ອາຈວາຍຮ ອາເຈ່ຮ ຮິ.' ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ຄັນ ເຢືາງ ເຈົາຣາຊີ ຢໍອ໌, ເຕ່ອ໌ ອັນ ອີດ ຕາເມົາ, ເຈີ່ ແຕງ ຈຸ່ມເຈືອ ອັບຣາຮາມ ແຕ ມັຮ ຕາເມົາ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ຊານໍ່ ນ່ະ ເບີນ ຈວາງ ປຼາ ປາຢື່ ແຈ່ະ ກັ່ລ ອາລ່ອງ. ກັ່ລ ອາແລ່ະ ມາ ຕາ ເບີນ ແກີດ ປາໄລ ອໍ, ເນົ່າ ຕາມື່່ ແຕ ຈວາງ ໄນ່, ເຈີ່ ແກຼງ ຕັຮ ຕຶ່ງ ອູ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ໄກຣ ລາລື່ ເກົາ ຕະ ຣີ່ດ ໄນ່ ໂອນ ເຍືາ ຣານາ ແດີອ໌, ຕະ ອາປັຮ ເຍືາ ປຽນ ແກີດ ຣາງຶ່ຮ ຕາໄມ ແອັນ. ມາ ອັນ ກາ ແຕີ່ອ໌ ອຶນຕູ່ນ ເກົາ, ອັນ ກັອຍ ຊົດ ແກຼີຍ ແຕ ເກົາ. ເກົາ ລາ ຕາ ເບີນ ປຍາຍ໌ ຕາແຢອ໌ ແກີບ ອັນ, ຍ່ອນ ເກົາ ລາ ອຳນາດ ແກດໆ ລາລື່. ອັນ ກັອຍ ຕະ ຣີ່ດ ໂອນ ເຍືາ ເບີນ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ກະ ອູ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ອາຕີ ອັນ ຢຸມ ຕາວີ່ງ, ເຈີ່ ອັນ ອູມ ອຶນແຍ່ະ ມັຮ ທຣໍ ອັນ. ອາແລ່ະ ກາ ຈອງ, ອັນ ດໍອ໌ ຕຶ່ງ ຊູ. ອາແລ່ະ ກາ ຊາກາມ, ອັນ ອາປັອງ ຕັຮ ຕຶ່ງ ອູ່ຍຮ ກາ ຕາ ແກີດ ປັດ ໂອນ ກາດ ຊັອງ.\" ");
INSERT INTO ncq_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ບັອງ ກາ ກັອຍ ເຢຊູ ລັ່ອຮ ແຕ ແຄງ ຄາລີເລ ເປາະ ປໍ ຕາເລ່ ຈໍແດນ, ຍ່ອນ ຢໍອ໌ ອີ ໂອນ ໂຢຮັນ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ມາ ໂຢຮັນ ຣາຈຽນ ຕາ ຢໍອ໌ ອີ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ອັນ. ໂຢຮັນ ປາຍ: \"ປຍາຍ໌ ລາລື່ ລາ ໄມ່ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ເກົາ. ມາ ຍ່ອນ ນານ່ະ ໄມ່ ແຕີ່ອ໌ ປໍ ເກົາ ຢໍອ໌ ເກົາ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ໄມ່?\" ");
INSERT INTO ncq_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ມາ ເຢຊູ ຕາແອີຍ ລັ່ຮ ໂຢຮັນ ປາຍ: \"ຊານໍ່ ອຶງເຄາະ ໄມ່ ຕະ ໂອນ ເກົາ. ນ່ະກັອຍ, ອຶງເຄາະ ໄຮ ຕະ ກູ່ ຣາມຶ່ຮ ມັຮ ເຢືາງ ເຈົາຣາຊີ ໂອນ ໄຮ ຕະ.\" ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ເຈີ່ ໂຢຮັນ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ແວັດ ໂຢຮັນ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ເຢຊູ, ເຈີ່ ເຢຊູ ຊັອຮ ແຕ ແດີອ໌. ບັອງ ກາ ກັອຍ ແຕິ່, ມັນລັ່ອງ ນ່ະ ເນົ່າ ເປິຮ, ກະ ເຢຊູ ເຮີມ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ແຊງ ແຕ ມັນລັ່ອງ ນ່ະ ແຈມ ປາເຣືາດ, ເຈີ່ ປົກ ຕຶ່ງ ຈະ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ກະ ເບີນ ຊຽງ ເຢືາງ ເຈົາຣາຊີ ຊາບາວ ອາຕີ ແຕ ມັນລັ່ອງ ປາຍ: \"ໄນ່ ລາ ກອນ ເກົາ, ອັນ ກາ ເກົາ ອາໂຢ່ະ ລາລື່. ອຶນເຕົ່າ ອັນ ຕະ, ລາ ເກົາ ຣໍ່ອ໌ ອຶນແຍ່ະ.\" ");
INSERT INTO ncq_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ແວັດ ກັອຍ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ເດີງ ເຢຊູ ເປາະ ປໍ ຕຍາຮ, ໂອນ ເຢືາງ ຊາຕານ ລ່ອງ ອັນ ໂອນ ຕະ ຣານະ ໂລ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ເຢຊູ ອົດ ຊັຣນາ ອຶນແຍ່ະ ປູນ ຈິ່ດ ຕາໄງ ປູນ ຈິ່ດ ຊາເດົາ. ແວັດ ກັອຍ ອັນ ຊັອງ ມາເຍືາຍຮ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ເຈີ່ ເຢືາງ ຊາຕານ ແຕີ່ອ໌ ປໍ ເຢຊູ, ກະ ອັນ ປາຍ: \"ຄັນ ໄມ່ ກອນ ເຢືາງ ເຈົາຣາຊີ, ເອົາ ໄມ່ ຕະ ໂອນ ມັຮ ຕາເມົາ ໄນ່ ແກີດ ຊັຣນາ ຈາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ມາ ເຢຊູ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ຄຽນ ປາຍ: 'ກວາຍ ຕາ ເບີນ ອາມົ່ງ ຍ່ອນ ແຕ ແອີງ ເກຣີ່ງ ຊັຣນາ ຈາ ຊັອງ, ມາ ກວາຍ ເບີນ ອາມົ່ງ ຍ່ອນ ແຕ ກູ່ ປັຣນາຍ ກາ ລັ່ອຮ ແຕ ແບອ໌ ເຢືາງ ເຈົາຣາຊີ.'\" ");
INSERT INTO ncq_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ແວັດ ກັອຍ ເຢືາງ ຊາຕານ ເດີງ ເຢຊູ ມູ່ດ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ. ອັນ ໂອນ ເຢຊູ ຕາຢຶ່ງ ຕຶ່ງ ອານວລ ດຸງ ຊາງ ປື່ດ. ");
INSERT INTO ncq_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ເຈີ່ ເຢືາງ ຊາຕານ ປາຍ: \"ຄັນ ໄມ່ ກອນ ເຢືາງ ເຈົາຣາຊີ, ເອົາ ໄມ່ ປັອງ ອາແຊງ, ຍ່ອນ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ຄຽນ ດໍອ໌ ປາຍ: 'ເຢືາງ ເຈົາຣາຊີ ແປຣີ ເທວາດາ ອັນ ກຍາອ໌ ໄມ່. ກະ ໄລ່ ຕາແດີງ ຣັ່ບ ໄມ່ ແຕ ອາຕີ ໄລ່ ໂອນ ຕາ ເບີນ ເບິ ອຶນເຕົ່າ ອາເຢີງ ໄມ່ ແຕ ຕາເມົາ.'\" ");
INSERT INTO ncq_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ມາ ເຢຊູ ຕາແອີຍ ລັ່ຮ ອັນ ປາຍ: \"ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ອັນ ປາຍ ເຕ່: 'ເຍືາ ອຶນໂຈຍ ລ່ອງ ເຢືາງ ເຈົາຣາຊີ, ອຶນເຈົາ ເຍືາ.'\" ");
INSERT INTO ncq_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ເຈີ່ ເຢືາງ ຊາຕານ ເດີງ ເຢຊູ ຊັອຮ ຕຶ່ງ ກົຮ ຕີ່ ລາລື່ ແອັນ. ອັນ ອາປັຮ ໂອນ ເຢຊູ ເຮີມ ອຶນແຍ່ະ ມັຮ ກຣວາງ ຊົດ, ກຣວາງ ປື່ດ ກະ ອຶນແຍ່ະ ຣາມຶ່ຮ ອຳນາດ ຕຶ່ງ ກູແຕອ໌ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ເຢືາງ ຊາຕານ ອາຕີ ເຢຊູ ປາຍ: \"ອຶນແຍ່ະ ມັຮ ກຣວາງ ໄນ່ ເກົາ ມ່ອບ ໂອນ ໄມ່, ຄັນ ໄມ່ ກຼຸ່ ຣາໂກລ ຊາງ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ມາ ເຢຊູ ຕາແອີຍ ລັ່ຮ ອັນ ປາຍ: \"ອາຍຮ ຊາຕານ ໄນ່! ໄມ່ ເປາະ ເຢີ່ງ ແຕ ເກົາ. ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ຄຽນ ປາຍ ເຈີ່: 'ອຶງເຄາະ ເຍືາ ຊາງ ເຢືາງ ເຈົາຣາຊີ, ລາ ອຶນເຈົາ ເຍືາ, ກະ ຕະ ແອີງ ຣານະ ອັນ ຊັອງ.'\" ");
INSERT INTO ncq_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ເຈີ່ ເຢືາງ ຊາຕານ ລັ່ອຮ ແຕິ່ ແຕ ເຢຊູ, ກະ ມັຮ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ແຕີ່ອ໌ ເນ່ ຊາລີອ໌ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ພໍກາ ເຢຊູ ຊັອງ ປາຍ ເນົ່າ ໂກບ ໂຢຮັນ ໂຈະ ຕຶ່ງ ກໍ່ອ໌, ເຈີ່ ອັນ ເປາະ ລັ່ຮ ປໍ ແຄງ ຄາລີເລ. ");
INSERT INTO ncq_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ແວັດ ອັນ ລັ່ອຮ ແຕ ວີ່ລ ນາຊາເຣັດ, ເຈີ່ ອັນ ມູ່ດ ແອີດ ຕຶ່ງ ເມືອງ ກາເປນາອູມ ແອັນ. ເມືອງ ໄນ່ ແອີດ ຕຶ່ງ ປຶ່ຮ ທາເລ ຣາປັ່ງ, ແຈ່ະ ຣາລັ່ນ ກຣວາງ ເຊບູໂລນ ກະ ກຣວາງ ເນັບທາລີ. ");
INSERT INTO ncq_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ອັນ ຕະ ນ່ະກັອຍ ໂອນ ແກີດ ຣາປຍາຍ໌ ມັຮ ປັຣນາຍ ເອຊາຢາ, ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","\"ກຣວາງ ເຊບູໂລນ ກະ ກຣວາງ ເນັບທາລີ ເອີຍ! ກຣວາງ ເຍືາ ແອີດ ຢັ່ຮ ອຶນຕົ່ຮ ຕາເລ່ ຈໍແດນ ແຈ່ະ ຣານາ ເປາະ ລຍາບ ປຶ່ຮ ທາເລ ຣາປັ່ງ ຄາລີເລ. ແຄງ ຄາລີເລ ເບີນ ກວາຍ ຕາ ແກີນ ກວາຍ ອິດຊະຣາເອລ ແອີດ. ");
INSERT INTO ncq_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ໄລ່ ກາ ແອີດ ຕຶ່ງ ອຶນຕຸ ການຳ, ໄລ່ ເຮີມ ປັ່ງ ປື່ດ ລາລື່. ກະ ໄລ່ ກາ ແອີດ ຕຶ່ງ ອຶນຕຸ ກູຈີດ, ເບີນ ປັ່ງ ປາເລືາງ ປໍ ໄລ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ແຕ ບັອງ ກັອຍ ແຕິ່ ເຢຊູ ຕາແບິ ອາຕີ ແຕ ຣານະ ເຢືາງ ເຈົາຣາຊີ. ອັນ ອາຕີ ປາຍ: \"ອຶງເຄາະ ເຍືາ ປຽນ ແກີດ ຣາງຶ່ຮ ຕາໄມ ແອັນ, ຍ່ອນ ແຈ່ະ ເຈີ່ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ.\" ");
INSERT INTO ncq_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ບັອງ ກາ ເຢຊູ ເປາະ ອຶມແປຣ ປຶ່ຮ ທາເລ ຣາປັ່ງ ຄາລີເລ, ອັນ ເຮີມ ບາຣ ນະ ແຊມອາຍ, ຊີໂມນ (ກາ ເນົ່າ ດໍອ໌ ເປໂຕ) ກະ ອັນເດອາ. ໄລ່ ບາຣ ນະ ກັອຍ ແອີດ ຕິງ ມ່ອງ ອາກາ ຕຶ່ງ ທາເລ ຣາປັ່ງ, ຍ່ອນ ໄລ່ ລາ ກວາຍ ເກີ່ຍ ຈໍ່ອ໌ ອາກາ. ");
INSERT INTO ncq_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ເຢຊູ ປາຍ ໂຈະ ໄລ່ ກັອຍ: \"ເຍືາ ປວາຍ ເກົາ, ເຈີ່ ເກົາ ຕະ ໂອນ ເຍືາ ແກີດ ກວາຍ ກາ ຈໍ່ອ໌ ກວາຍ ນ່ະ ເຍືາ ຈໍ່ອ໌ ອາກາ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ບັອງ ກາ ກັອຍ ແຕິ່ ໄລ່ ຕັຮ ມ່ອງ; ເຈີ່ ໄລ່ ປວາຍ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ເຢຊູ ເປາະ ບີ່ອ໌ ແອັນ; ເຈີ່ ອັນ ເຮີມ ບາຣ ນະ ແຊມອາຍ ການໍ່ອ໌ ຣາມຶ່ຮ ຢາໂກໂບ ກະ ໂຢຮັນ. ໄລ່ ບາຣ ນະ ກັອຍ ແອີດ ຕຶ່ງ ຕົວະ ກະ ອຶມປໍ່ ໄລ່ ເຊເບດາຍ, ພູງ ລັ່ຮ ມ່ອງ ໄລ່. ເຢຊູ ກູອ໌ ບາຣ ນະ ແຊມອາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ບັອງ ກາ ກັອຍ ແຕິ່ ໄລ່ ບາຣ ນະ ກັອຍ ຕັຮ ຕົວະ ກະ ອຶມປໍ່ ໄລ່, ເຈີ່ ປວາຍ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ເຢຊູ ເປາະ ຈວບ ແຄງ ຄາລີເລ ອາຕີ ປັຣນາຍ ອໍ ແຕ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ຕຶ່ງ ມັຮ ດຸງ ຊາງ ກວາຍ ອິດຊະຣາເອລ. ກະ ອັນ ປົວ ໂອນ ກວາຍ ແກີດ ແບຣັຮ ແຕ ກູ່ ຣາມຶ່ຮ ອາອີ່. ");
INSERT INTO ncq_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ຣານະ ເຢຊູ ຕະ ເປາະ ປຼັຮ ກູ່ ອຶນຕຸ ຕຶ່ງ ແຄງ ຊີເຣຍ. ກະ ເນົ່າ ເດີງ ປໍ ອັນ ກຼຶ່ງ ກວາຍ ກາ ເບີນ ຊາອຶ່ຍ ຣາມຶ່ຮ ອາອີ່ ນ່ະໄນ່: ກວາຍ ເບີນ ອາອີ່ ຊາປັ່ລ, ໄລ່ ກາ ເຢືາງ ຕາ ອໍ ຕຣວບ, ໄລ່ ກາ ອາອີ່ ຢຸ່ຮ ໄປຣ່ອ໌, ກະ ໄລ່ ກາ ເບີນ ອາອີ່ ລ່ອຍ. ເຢຊູ ປົວ ອຶນແຍ່ະ ມັຮ ກວາຍ ອາອີ່ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ນ່ະກັອຍ ກຼຶ່ງ ລາລື່ ກວາຍ ປວາຍ ເຢຊູ. ໄລ່ ແຕີ່ອ໌ ແຕ ແຄງ ຄາລີເລ, ກຣວາງ ເດກາໂປລີ, ເມືອງ ເຢຣູຊາເລັມ, ແຄງ ຢູດາຍ, ກະ ກຣວາງ ຢັ່ຮ ອຶນຕົ່ຮ ຕາເລ່ ຈໍແດນ. ");
INSERT INTO ncq_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ແຕີ່ອ໌ ເຢຊູ ເຮີມ ກຼຶ່ງ ລາລື່ ກວາຍ ແອີດ ອຶງກັອຍ, ອັນ ຊັອຮ ຕຶ່ງ ກົຮ; ເຈີ່ ອັນ ຕາກູ. ມູ່ ໄລ່ ກາ ຣຍານ ແຕ ອັນ ຕາກູ ແຈ່ະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ເຈີ່ ເຢຊູ ຕາແບິ ອາຕີ ໄລ່ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","\"ບຸ່ນ ລາລື່ ໄລ່ ກາ ງີ່ນ ປາຍ ຣາງຶ່ຮ ໄລ່ ຕາ ເບີນ ອໍ ອຶນເຕົ່າ, ຍ່ອນ ໄລ່ ເບີນ ຈຸງ ເຕ່ ມັຮ ກາ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ. ");
INSERT INTO ncq_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ບຸ່ນ ລາລື່ ໄລ່ ກາ ເຍືາມ ຕຸ່ຮ ຕຶ່ງ ແດີຍ ໄນ່, ຍ່ອນ ປັຣແນີ ມັນເຕຣືາ ເຢືາງ ເຈົາຣາຊີ ແຕິ່ ຕາລື່ນ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ບຸ່ນ ລາລື່ ໄລ່ ກາ ເບີນ ຣາງຶ່ຮ ລາເມ່ນ ອໍ, ຍ່ອນ ປັຣແນີ ມັນເຕຣືາ ເຢືາງ ເຈົາຣາຊີ ໂອນ ໄລ່ ຕາລາ ກຣວາງ ກູແຕອ໌. ");
INSERT INTO ncq_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ບຸ່ນ ລາລື່ ໄລ່ ກາ ອູອຍາຣ ອູໄອອ໌ ຢໍອ໌ ອີ ຕະ ຣານະ ຕານັ່ອງ ອໍ, ຍ່ອນ ປັຣແນີ ມັນເຕຣືາ ເຢືາງ ເຈົາຣາຊີ ໂອນ ໄລ່ ເບີນ ນ່ະ ຣາງຶ່ຮ ໄລ່ ຢໍອ໌ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ບຸ່ນ ລາລື່ ໄລ່ ກາ ຊັອງ ອາໂຢ່ະ ຕະ ກວາຍ ການໍ່ອ໌, ຍ່ອນ ປັຣແນີ ມັນເຕຣືາ ເຢືາງ ເຈົາຣາຊີ ຊັອງ ອາໂຢ່ະ ຕະ ໄລ່ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ບຸ່ນ ລາລື່ ໄລ່ ກາ ເບີນ ຣາງຶ່ຮ ຕາ ເບີນ ໂລ່ຍຮ ອຶນເຕົ່າ, ຍ່ອນ ປັຣແນີ ມັນເຕຣືາ ໄລ່ ເບີນ ເຮີມ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ບຸ່ນ ລາລື່ ກວາຍ ກາ ເດີງ ເຢົ່າ ຣາຕອຍ ລັ່ຮ, ຍ່ອນ ປັຣແນີ ມັນເຕຣືາ ເຢືາງ ເຈົາຣາຊີ ດໍອ໌ ກວາຍ ກັອຍ ລາ ກອນ ອາໄກ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ບຸ່ນ ລາລື່ ໄລ່ ກາ ເບີນ ຊາອຶ່ຍ ຣາມຶ່ຮ ຕຸ່ຮ ກັ່ດ ກວາຍ ຕະ ໄລ່ ຍ່ອນ ໄລ່ ຕາປູ່ນ ຣານະ ເຢືາງ ເຈົາຣາຊີ, ຍ່ອນ ໄລ່ ເບີນ ຈຸງ ເຕ່ ມັຮ ກາ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ. ");
INSERT INTO ncq_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ບຸ່ນ ລາລື່ ໂອນ ເຍືາ, ແຕີ່ອ໌ ກວາຍ ການໍ່ອ໌ ອາເຢ່ ພາມາດ ເຍືາ, ຕະ ເຍືາ, ກະ ຕູນ ເຍືາ ຕະ ອຶນແຍ່ະ ມັຮ ຣານະ ຕາ ອໍ, ຍ່ອນ ເຍືາ ຕາປູ່ນ ຣານະ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ອຶງເຄາະ ເຍືາ ແອີດ ຣໍ່ອ໌ ກະ ຕຳໂປກ, ຍ່ອນ ເຢືາງ ເຈົາຣາຊີ ດໍອ໌ ໂອນ ເຍືາ ເບີນ ເກືາ ຊາອຶ່ຍ ຕຶ່ງ ມັນລັ່ອງ. ມູເຈິງ ກັອຍ ເຕ່ ມັຮ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ ຈີວ໌ ເນົ່າ ຕະ ໄລ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","\"ເຍືາ ລາ ນ່ະ ບອຍ ໂອນ ກວາຍ ການໍ່ອ໌ ແອີດ ຕຶ່ງ ກູແຕອ໌ ໄນ່. ມາ ຄັນ ບອຍ ແກີດ ອຶນຕຍາຮ, ນານ່ະ ອີ ຕະ ໂອນ ແກີດ ບະ ລັ່ຮ? ຕາ ເຕ່ອ໌ ຕະ ອຶນເຕົ່າ ນັ່ອງ ບອຍ ກັອຍ. ໄຮ ທໍອ໌ ຕັຮ ໂອນ ກວາຍ ຊາເຕືາຍ໌ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","\"ເຍືາ ລາ ນ່ະ ປັ່ງ ປາເລືາງ ໂອນ ອຶນແຍ່ະ ກວາຍ ຕຶ່ງ ກູແຕອ໌ ໄນ່. ເຍືາ ລາ ນ່ະ ມວຍ ເມືອງ ປື່ດ ແອີດ ຕຶ່ງ ປັຣແລີ ກົຮ. ຕາ ເບີນ ເນົ່າ ເຕ່ອ໌ ກາຕັງ ປັ່ງ ແຕ ເມືອງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ມູເຈິງ ກັອຍ ເຕ່, ຕາ ເບີນ ເນົ່າ ຕາກັດ ຕາກຍາງ, ເຈີ່ ກຣວາອ໌ ໂຈະ ກາເຣຍ. ມາ ເນົ່າ ດໍອ໌ ຕຶ່ງ ໂຣ່ງ ໂອນ ປັ່ງ ປາເລືາງ ອຶນແຍ່ະ ມັຮ ກວາຍ ຕຶ່ງ ດຸງ. ");
INSERT INTO ncq_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ມູເຈິງ ກັອຍ ເຕ່, ເຍືາ ອຶງເຄາະ ໂອນ ປັ່ງ ແຕ ເຍືາ ປາເລືາງ ໂອນ ກວາຍ ການໍ່ອ໌ ເຮີມ. ນ່ະກັອຍ ໄລ່ ເຮີມ ມັຮ ຣານະ ອໍ ເຍືາ ຕະ; ເຈີ່ ໄລ່ ຍ່ອງ ອຶມປໍ່ ເຍືາ ກາ ແອີດ ຕຶ່ງ ມັນລັ່ອງ.\" ");
INSERT INTO ncq_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","\"ເຍືາ ອຶນໂຈຍ ຄຶ່ດ ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່ ມາ ຢໍອ໌ ອີ ອາປິ່ດ ຕັຮ ຄານອດ ໂມເຊ ແຕີລາ ປັຣນາຍ ໄລ່ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ. ເກົາ ແຕີ່ອ໌ ຕາ ແກີນ ອີ ອາປິ່ດ ຣານະ ກັອຍ, ມາ ເກົາ ແຕີ່ອ໌ ຢໍອ໌ ອີ ໂອນ ຣານະ ກັອຍ ແກີດ ຣາປຍາຍ໌. ");
INSERT INTO ncq_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ຄັນ ອຶນນັ່ອງ ເບີນ ມັນລັ່ອງ ກະ ກູແຕອ໌, ຕາ ເບີນ ປິ່ດ ມວຍ ຣາມຶ່ຮ ອຶນເຕົ່າ ເນົ່າ ຄຽນ ຕຶ່ງ ຄານອດ ໄນ່ ເຕົ່າ ຣາປຍາຍ໌ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ນ່ະກັອຍ ຄັນ ກວາຍ ອາແລ່ະ ມາ ຕັຮ ມວຍ ຣານະ ອຶນເຕົ່າ ແຕ ຄານອດ ກັອຍ ກະ ອາຕີ ກວາຍ ການໍ່ອ໌ ໂອນ ຕັຮ ເຕ່, ກວາຍ ກັອຍ ຕາ ເຕ່ອ໌ ແກີດ ຊົດ ອຶນເຕົ່າ ຕຶ່ງ ຈຸ່ມ ກາ ເຢືາງ ເຈົາຣາຊີ ຊົດ. ມາ ກວາຍ ອາແລ່ະ ກາ ຕະ ຕາປູ່ນ ຄານອດ ກັອຍ ກະ ອາຕີ ໂອນ ກວາຍ ການໍ່ອ໌ ຕະ ຕາປູ່ນ ເຕ່, ກວາຍ ກັອຍ ແກີດ ຊົດ ຕຶ່ງ ຈຸ່ມ ກາ ເຢືາງ ເຈົາຣາຊີ ຊົດ. ");
INSERT INTO ncq_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ນ່ະກັອຍ ເກົາ ອາຕີ ເຍືາ, ຄັນ ເຍືາ ຢໍອ໌ ອີ ມູ່ດ ຕຶ່ງ ຈຸ່ມ ກາ ເຢືາງ ເຈົາຣາຊີ ຊົດ, ອຶງເຄາະ ເຍືາ ຕາປູ່ນ ຣານະ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ອໍ ແກຼີຍ ແຕ ມັຮ ກວາຍ ອາຕີ ຄານອດ ກະ ມັຮ ກວາຍ ພາຣີຊາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","\"ເຍືາ ຊັອງ ເຈີ່ ເນົ່າ ອາຕີ ແຕ ອຶມແບິ ປາຍ: 'ເຍືາ ອຶນໂຈຍ ກາຈີດ ກວາຍ. ກວາຍ ອາແລ່ະ ມາ ກາຈີດ ກວາຍ ການໍ່ອ໌, ເນົ່າ ຕະ ໂຕ່ດ ລັ່ຮ ອັນ.' ");
INSERT INTO ncq_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ມາ ເກົາ ອາຕີ ເຍືາ ປາຍ: ກວາຍ ອາແລ່ະ ມາ ຊັອງ ອວານ ກະ ແຊມອາຍ ອັນ, ກວາຍ ກັອຍ ເຢືາງ ເຈົາຣາຊີ ຕະ ໂຕ່ດ. ອາແລ່ະ ກາ ຣາໂລຍຮ ກະ ແຊມອາຍ, ກະ ປາຍ ໂຈະ ແຊມອາຍ: 'ໄມ່ ຊາກູລ ລາລື່,' ນ່ະກັອຍ ເຕ່ອ໌ ກວາຍ ຊົດ ຕັດຊີ່ນ. ກະ ກວາຍ ອາແລ່ະ ກາ ປາຍ ໂຈະ ແຊມອາຍ: 'ໄມ່ ລາ ກວາຍ ຢຸ່ຮ,' ກວາຍ ກັອຍ ເຕ່ອ໌ ເຢືາງ ເຈົາຣາຊີ ອາປັອງ ຕັຮ ຕຶ່ງ ປຣຸ່ງ ອູ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ນ່ະກັອຍ, ຄັນ ເຍືາ ເດີງ ເກຣີ່ງ ອີ ຊາງ ໂອນ ເຢືາງ ເຈົາຣາຊີ ປໍ ຊັນເຕຣືາງ ຣີ່ດ, ມາ ບັອງ ກາ ກັອຍ ເຍືາ ຊາແຍີ ລັ່ຮ ແຊມອາຍ ດໍອ໌ ມັ່ດ ກະ ເຍືາ, ");
INSERT INTO ncq_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ອຶງເຄາະ ເຍືາ ອາຈຸຮ ດໍອ໌ ເກຣີ່ງ ຊາງ ກັອຍ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ ເວືາຍ. ເຈີ່ ເຍືາ ລົ່ບ ເຈົາ ກະ ຣາອໍ ລັ່ຮ ກະ ແຊມອາຍ. ເຈີ່ ເຍືາ ເປາະ ລັ່ຮ ປໍ ດຸງ ຊາງ ມ່ອບ ເກຣີ່ງ ກັອຍ ໂອນ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","\"ແຕີ່ອ໌ ເຍືາ ຣາໂລຍຮ ກະ ກວາຍ ການໍ່ອ໌, ກະ ກວາຍ ກັອຍ ອີ ເດີງ ເຍືາ ຣາມົຮ ກວາຍ ຊົດ, ອຶງເຄາະ ເຍືາ ປຣ່ອມ ຣາຕອຍ ລັ່ຮ ບັອງ ກາ ເຍືາ ຕາ ຢວາຮ ແຕີ່ອ໌ ປໍ ກວາຍ ຊົດ ກັອຍ. ຄັນ ເຍືາ ຕາ ເບີນ ປຣ່ອມ ຣາຕອຍ ໄວ່, ອຶງກັອຮ ປຍາຍ໌ ກວາຍ ກັອຍ ເດີງ ເຍືາ ແຕີ່ອ໌ ປໍ ກວາຍ ຊົດ ກາເລີຍ ແຕ ກັອຍ ແອັນ. ເຈີ່ ກວາຍ ຊົດ ກັອຍ ມ່ອບ ໂອນ ເນົ່າ ໂຈະ ເຍືາ ຕຶ່ງ ກໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ເຍືາ ຕາ ເຕ່ອ໌ ລັ່ອຮ ແຕ ກໍ່ອ໌ ເຕົ່າ ເຍືາ ຈີວ໌ ກູລັຮ ອຶນແຍ່ະ ມັຮ ປຣະ ກວາຍ ຊົດ ກັອຍ ປາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","\"ເຍືາ ຊັອງ ປັຣນາຍ ເນົ່າ ອາຕີ ປາຍ: 'ເຍືາ ອຶນໂຈຍ ປັຣລື່ຍ ລາກວຍ ແຕີລາ ກາຢາອ໌ ເນົ່າ.' ");
INSERT INTO ncq_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ມາ ເກົາ ອາຕີ ເຍືາ ປາຍ: ກວາຍ ອາແລ່ະ ມາ ເນ່ ປໍ ກວາຍ ມັນແຊມ ກະ ຣາງຶ່ຮ ອັນ ຄຶ່ດ ຢໍອ໌ ອີ ເບີນ ມັນແຊມ ກັອຍ, ໂລ່ຍຮ ກວາຍ ກັອຍ ມູເຈິງ ອັນ ປັຣລື່ຍ ມັນແຊມ ກັອຍ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ນ່ະກັອຍ ຄັນ ມັ່ດ ເຍືາ ກັ່ຮ ອາຕ່ຳ ຕະ ໂອນ ເຍືາ ຕະ ໂລ່ຍຮ, ເຍືາ ອຶງເຄາະ ກູໄລອ໌ ຕັຮ ກຼອງ ມັ່ດ ກັອຍ. ຄາອ໌ ເຍືາ ປິ່ດ ບີ່ອ໌ ກຼອງ ມັ່ດ ເຍືາ, ແຕ ເຍືາ ປິ່ດ ອຶນແຍ່ະ ຈະ ເຍືາ ຕຶ່ງ ປຣຸ່ງ ອູ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ກະ ຄັນ ອາຕີ ເຍືາ ກັ່ຮ ອາຕ່ຳ ຕະ ໂອນ ເຍືາ ຕະ ໂລ່ຍຮ, ອຶງເຄາະ ເຍືາ ກັອຮ ແກຼງ ຕັຮ ອາຕີ ກັອຍ. ຄາອ໌ ເຍືາ ປິ່ດ ບີ່ອ໌ ອາຕີ ຊັອງ, ແຕ ເຍືາ ປິ່ດ ອຶນແຍ່ະ ຈະ ເຍືາ ຕຶ່ງ ປຣຸ່ງ ອູ່ຍຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","\"ເບີນ ເນົ່າ ຄຽນ ປາຍ: 'ກວາຍ ອາແລ່ະ ກາ ອີ ຕັຮ ລາກວຍ ອັນ, ອັນ ອຶງເຄາະ ຕະ ເຈຍ ຣາຕັຮ ໂອນ ລາກວຍ.' ");
INSERT INTO ncq_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ມາ ເກົາ ອາຕີ ເຍືາ ປາຍ: ຄັນ ກວາຍ ອາແລ່ະ ຕັຮ ລາກວຍ ອັນ ມາ ລາກວຍ ອັນ ຕາ ເບີນ ໂລ່ຍຮ ຍ່ອນ ປັຣລື່ຍ ກະ ຣາເລົາ ການໍ່ອ໌, ຣາເລົາ ກັອຍ ຕະ ໂອນ ລາກວຍ ອັນ ແກີດ ໂລ່ຍຮ ຄັນ ລາກວຍ ອີດ ກາຢາອ໌ ຕາໄມ. ກະ ໂລ່ຍຮ ເຕ່ ກວາຍ ການໍ່ອ໌ ກາ ອີດ ມັນແຊມ ກັອຍ, ມູເຈິງ ອັນ ປັຣລື່ຍ ລາກວຍ ເນົ່າ.\" ");
INSERT INTO ncq_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","\"ເຍືາ ຊັອງ ເຈີ່ ເນົ່າ ປາຍ ແຕ ອຶມແບິ: 'ຄັນ ເຍືາ ຄີນ ອຶນເຕົ່າ ມາ ອາງ ຣາມຶ່ຮ ເຢືາງ ເຈົາຣາຊີ, ເຍືາ ຕາ ເຕ່ອ໌ ຕັຮ.' ");
INSERT INTO ncq_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ມາ ເກົາ ອາຕີ ເຍືາ ປາຍ: ຄັນ ເຍືາ ຢໍອ໌ ອີ ປຣ່ອມ ອຶນເຕົ່າ, ເຍືາ ອຶນໂຈຍ ອາງ ຣາມຶ່ຮ ອຶນເຕົ່າ. ອຶນໂຈຍ ອາງ ມັນລັ່ອງ, ຍ່ອນ ມັນລັ່ອງ ລາ ອຶນຕຸ ເຢືາງ ເຈົາຣາຊີ ແອີດ. ");
INSERT INTO ncq_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ອຶນໂຈຍ ອາງ ກູແຕອ໌, ຍ່ອນ ກູແຕອ໌ ລາ ເຢືາງ ເຈົາຣາຊີ ຕາລາ. ອຶນໂຈຍ ອາງ ເມືອງ ເຢຣູຊາເລັມ, ຍ່ອນ ເມືອງ ກັອຍ ລາ ເມືອງ ເຢືາງ ເຈົາຣາຊີ, ອັນ ກາ ເຕືາວ ປັຣເຍືາ ປື່ດ. ");
INSERT INTO ncq_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ກະ ເຍືາ ອຶນໂຈຍ ອາງ ກາ ແປຼີ ໂຊະ ເຍືາ, ຍ່ອນ ເຍືາ ຕາ ເຕ່ອ໌ ຕະ ມວຍ ອຶນແຕຣັ່ຮ ໂຊະ ກຼໍອ໌ ແຕີລາ ກູມ. ");
INSERT INTO ncq_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ຄັນ ປຍາຍ໌, ເຍືາ ປາຍ ບີ່ອ໌ 'ປຍາຍ໌.' ຄັນ ຕາ ປຍາຍ໌, ເຍືາ ປາຍ 'ຕາ ປຍາຍ໌.' ຄັນ ເຍືາ ຈໍ່ອ໌ ປາຍ ຊາອຶ່ຍ ປັຣນາຍ ການໍ່ອ໌, ລາ ແຕ ເຢືາງ ຊາຕານ.\" ");
INSERT INTO ncq_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","\"ເຍືາ ຊັອງ ເຈີ່ ເນົ່າ ປາຍ: 'ອຶນເຕົ່າ ເນົ່າ ຕະ ເຍືາ, ເຍືາ ຕະ ລັ່ຮ ມູເຈິງ ກັອຍ ເຕ່.' ");
INSERT INTO ncq_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ມາ ເກົາ ອາຕີ ເຍືາ ປາຍ: ເຍືາ ອຶນໂຈຍ ກັຣລັຮ ແດີອ໌ ໂຈະ ກວາຍ ກາ ຕະ ເຍືາ. ຄັນ ເນົ່າ ຕັ່ຮ ກາແລງ ບັງ ເຍືາ ຢັ່ຮ ອາຕ່ຳ, ເຍືາ ຕໍ ໂອນ ອັນ ຕັ່ຮ ຢັ່ຮ ອາເວ່ຣ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ຄັນ ເນົ່າ ເດີງ ເຍືາ ແຕີ່ອ໌ ປໍ ກວາຍ ຕັດຊີ່ນ ຢໍອ໌ ອີ ເບີນ ອາຢັ່ອຮ ຕຶ່ງ ປື່ນ ແຕ ຈະ ເຍືາ, ເຍືາ ຕວດ ກາ ອາຢັ່ອຮ ຕ່ອງ ຢັ່ຮ ແປີງ ແຮີ ໂອນ ປໍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ຄັນ ເນົ່າ ມັນຕຣຸ່ ໂອນ ເຍືາ ເປາະ ມວຍ ລັກ, ເຍືາ ເປາະ ບາຣ ລັກ ເລີ່ຍ ກະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ຄັນ ກວາຍ ອາແລ່ະ ແຊອ໌ ອຶນເຕົ່າ ແຕ ເຍືາ, ເຍືາ ໂອນ ອັນ ອາກັອຍ. ກະ ຄັນ ກວາຍ ອາແລ່ະ ຢໍອ໌ ອີ ວ່ະ ອຶນເຕົ່າ ແຕ ເຍືາ, ເຍືາ ໂອນ ອັນ ວ່ະ.\" ");
INSERT INTO ncq_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","\"ເຍືາ ຊັອງ ເຈີ່ ເນົ່າ ປາຍ: 'ເຍືາ ອາໂຢ່ະ ເຢົ່າ ເຍືາ ກະ ຊາອັຣ ກວາຍ ກາ ຢໍອ໌ ອີ ຕະ ເຍືາ.' ");
INSERT INTO ncq_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ມາ ເກົາ ອາຕີ ເຍືາ ປາຍ: ອຶງເຄາະ ເຍືາ ອາໂຢ່ະ ກວາຍ ກາ ອວານ ເຍືາ, ກະ ອຶງເຄາະ ເຍືາ ເກົາແຊອ໌ ໂອນ ເຢືາງ ເຈົາຣາຊີ ຈ່ອຍ ກວາຍ ກາ ຕະ ຕຸ່ຮ ກັ່ດ ໂຈະ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ຕະ ນ່ະກັອຍ ເຍືາ ແກີດ ກອນ ອາໄກ ອຶມປໍ່ ເຍືາ ຕຶ່ງ ມັນລັ່ອງ. ຍ່ອນ ອັນ ໂອນ ມັ່ດ ມານາງ ອັນ ປາເລືາງ ປໍ ກວາຍ ອໍ ກະ ກວາຍ ຕາ ອໍ. ກະ ອັນ ໂອນ ເມືາ ປຸ່ຮ ກວາຍ ຕານັ່ອງ ອໍ, ກະ ກວາຍ ຕາ ເບີນ ຕານັ່ອງ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ຄັນ ເຍືາ ມາ ອາໂຢ່ະ ແອີງ ໄລ່ ກາ ອາໂຢ່ະ ເຍືາ ຊັອງ, ອຶນເຕົ່າ ເຢືາງ ເຈົາຣາຊີ ໂອນ ເຍືາ ເບີນ ເກືາ? ກວາຍ ກາ ອີດ ປຣະ ປາຊີ ໄລ່ ຕະ ມູເຈິງ ກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ກະ ຄັນ ເຍືາ ກັຣບັນ ກັຣຊວານ ອໍ ແອີງ ແຊມອາຍ ເຍືາ ຊັອງ, ຕາ ເບີນ ອຶມພາ ອຶນເຕົ່າ ແຕ ກວາຍ ການໍ່ອ໌. ໄລ່ ກາ ຕາ ເບີນ ດັງ ເຢືາງ ເຈົາຣາຊີ ຕະ ມູເຈິງ ກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ນ່ະກັອຍ ອຶງເຄາະ ເຍືາ ເບີນ ຣາງຶ່ຮ ນ່ະ ອຶມປໍ່ ເຍືາ ຕຶ່ງ ມັນລັ່ອງ, ອັນ ກາ ອໍ ກາເລີຍ ແຕ ການໍ່ອ໌.\" ");
INSERT INTO ncq_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","\"ອຶງເຄາະ ເຍືາ ລາວັ່ງ ໂອນ ອໍ! ແຕີ່ອ໌ ເຍືາ ຕະ ຣານະ ອໍ ອຶນເຕົ່າ ໂອນ ເຢືາງ ເຈົາຣາຊີ, ເຍືາ ອຶນໂຈຍ ຕະ ໂອນ ກວາຍ ການໍ່ອ໌ ເຮີມ. ຄັນ ເຍືາ ຕະ ນ່ະກັອຍ, ອຶມປໍ່ ເຍືາ ຕຶ່ງ ມັນລັ່ອງ ຕາ ເບີນ ໂອນ ເກືາ ອຶນເຕົ່າ ມັຮ ຣານະ ເຍືາ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","\"ແຕີ່ອ໌ ເຍືາ ອີ ຈ່ອຍ ກວາຍ ກາດີດ, ເຍືາ ອຶນໂຈຍ ອາປັຮ ໂອນ ກວາຍ ການໍ່ອ໌ ເຮີມ, ຢໍອ໌ ອີ ໂອນ ເນົ່າ ຍ່ອງ ເຍືາ. ຊາອຶ່ຍ ນະ ກວາຍ ເກີ່ຍ ຕະ ນ່ະກັອຍ ຕຶ່ງ ດຸງ ຊາງ ກະ ຕຶ່ງ ຣານາ. ໄລ່ ຢໍອ໌ ອີ ໂອນ ກວາຍ ການໍ່ອ໌ ເຮີມ ກະ ຍ່ອງ ໄລ່. ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ໄລ່ ກັອຍ ເບີນ ເກືາ ເຈີ່ ແຕ ກວາຍ ຍ່ອງ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ມາ ແຕີ່ອ໌ ເຍືາ ອີ ຈ່ອຍ ກວາຍ ກາດີດ, ອຶງເຄາະ ເຍືາ ຕະ ຣາງຍາອ໌ ຊັອງ, ອຶນໂຈຍ ໂອນ ກວາຍ ການໍ່ອ໌ ເຮີມ. ");
INSERT INTO ncq_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ເຍືາ ຕະ ຣາງຍາອ໌, ມາ ອຶມປໍ່ ເຍືາ ຕຶ່ງ ມັນລັ່ອງ ເຮີມ ມັຮ ຣານະ ເຍືາ ຕະ ຣາງຍາອ໌ ກັອຍ, ກະ ອັນ ໂອນ ເຍືາ ເບີນ ເກືາ ມັຮ ຣານະ ກາ ເຍືາ ຕະ.\" ");
INSERT INTO ncq_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","\"ແຕີ່ອ໌ ເຍືາ ເກົາແຊອ໌, ເຍືາ ອຶນໂຈຍ ຕະ ນ່ະ ກວາຍ ມາມ ອໍ ມາ ຣາງຶ່ຮ ໂກ່ະ. ມັຮ ກວາຍ ກັອຍ ເກີ່ຍ ຕາຢຶ່ງ ເກົາແຊອ໌ ຕຶ່ງ ດຸງ ຊາງ ກະ ຕຶ່ງ ຣານາ ແຮີ, ຢໍອ໌ ອີ ໂອນ ກວາຍ ເຮີມ ບັອງ ໄລ່ ເກົາແຊອ໌, ເຈີ່ ຍ່ອງ ໄລ່. ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ໄລ່ ກັອຍ ເບີນ ເກືາ ເຈີ່ ແຕ ຣານະ ກາ ໄລ່ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ມາ ເຍືາ, ແຕີ່ອ໌ ເຍືາ ເກົາແຊອ໌, ອຶງເຄາະ ເຍືາ ມູ່ດ ປໍ ກຼຸງ ຣາງຍາອ໌, ກະ ກາໄຕ່ຮ ງັ່ຮ ຕົ່ງ. ເຈີ່ ເຍືາ ເກົາແຊອ໌ ແຕ ອຶມປໍ່ ເຍືາ, ອັນ ກາ ເຍືາ ຕາ ເຕ່ອ໌ ເຮີມ. ມາ ອັນ ເຕ່ອ໌ ເຮີມ ເຍືາ ແອີດ ເກົາແຊອ໌ ອຶນຕຸ ຣາງຍາອ໌ ກັອຍ, ກະ ອັນ ກູລັຮ ເກືາ ແຕ ຣານະ ເຍືາ ຕະ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","\"ແຕີ່ອ໌ ເຍືາ ເກົາແຊອ໌, ເຍືາ ອຶນໂຈຍ ອາຣ່ອຍ ຊັອງ ນ່ະ ກວາຍ ຕາ ເບີນ ດັງ ເຢືາງ ເຈົາຣາຊີ. ໄລ່ ຄຶ່ດ ປາຍ ອຶງເຄາະ ເກົາແຊອ໌ ລາແບະ ລາບື່ບ ຊາອຶ່ຍ ປັຣນາຍ ແຕ ເຕ່ອ໌ ເຢືາງ ເຈົາຣາຊີ ຊາງັດ. ");
INSERT INTO ncq_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ມາ ເຍືາ ອຶນໂຈຍ ຕະ ນ່ະ ໄລ່ ກັອຍ. ອຶມປໍ່ ເຍືາ ຕຶ່ງ ມັນລັ່ອງ ດັງ ຣາມຶ່ຮ ອຶນເຕົ່າ ເຍືາ ແອິ ແຕ ບັອງ ກາ ເຍືາ ຕາ ຢວາຮ ແຊອ໌ ແຕ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ນ່ະກັອຍ ແຕີ່ອ໌ ເຍືາ ເກົາແຊອ໌, ອຶງເຄາະ ເຍືາ ເກົາແຊອ໌ ປາຍ: 'ອຶມປໍ່ ຮິ ແອີດ ຕຶ່ງ ມັນລັ່ອງ ເອີຍ! ແຊອ໌ ເຍືາ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ ຢຳນັ່ບ ຣາມຶ່ຮ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ແຊອ໌ ເຍືາ ແກີດ ຊົດ ກູ່ ຣາງຶ່ຮ ກວາຍ ຕຶ່ງ ກູແຕອ໌ ໄນ່. ກະ ແຊອ໌ ໂອນ ກວາຍ ຕຶ່ງ ກູແຕອ໌ ໄນ່ ປວາຍ ຣາງຶ່ຮ ເຍືາ, ມູເຈິງ ເນົ່າ ປວາຍ ຣາງຶ່ຮ ເຍືາ ຕຶ່ງ ມັນລັ່ອງ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ແຊອ໌ ເຍືາ ໂອນ ຮິ ຄຳ ຈາ ຕາໄງ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ແຊອ໌ ເຍືາ ຕັຮ ໂລ່ຍຮ ກາ ຮິ ຕະ ເຈີ່, ມູເຈິງ ຮິ ຕັຮ ໂລ່ຍຮ ກາ ເນົ່າ ຕະ ໂຈະ ຮິ. ");
INSERT INTO ncq_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ແຊອ໌ ເຍືາ ອຶນໂຈຍ ໂອນ ເນົ່າ ລ່ອງ ຮິ, ກະ ອຶນໂຈຍ ໂອນ ເຢືາງ ຊາຕານ ປັຣຕຶ່ ຮິ ຕະ ຣານະ ຕາ ອໍ. ຍ່ອນ ອຶນແຍ່ະ ຊົດ ປື່ດ, ອຶນແຍ່ະ ອຳນາດ, ກະ ອຶນແຍ່ະ ອາງອື່ຣ ແອີດ ເລືອຍໆ ກະ ເຍືາ ຊົດ ແດີຍ ເລີ່ຍ ກູມໍ. ອາແມນ!' ");
INSERT INTO ncq_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","\"ຄັນ ເຍືາ ຕັຮ ໂລ່ຍຮ ກວາຍ ການໍ່ອ໌ ຕະ ໂຈະ ເຍືາ, ອຶມປໍ່ ເຍືາ ຕຶ່ງ ມັນລັ່ອງ ຕັຮ ເຕ່ ໂລ່ຍຮ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ມາ ຄັນ ເຍືາ ຕາ ເບີນ ຕັຮ ໂລ່ຍຮ ກວາຍ ການໍ່ອ໌ ຕະ ໂຈະ ເຍືາ, ອຶມປໍ່ ເຍືາ ຕຶ່ງ ມັນລັ່ອງ ຕາ ເບີນ ຕັຮ ເຕ່ ໂລ່ຍຮ ເຍືາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","\"ແຕີ່ອ໌ ເຍືາ ຕະ ຣີ່ດ ອົດ ຊັຣນາ ອີ ຊາງ ເຢືາງ ເຈົາຣາຊີ, ເຍືາ ອຶນໂຈຍ ຕະ ມັ່ດ ມຸ່ຮ ຊູບ ໂງ່ດ ນ່ະ ກວາຍ ມາມ ອໍ ມາ ຣາງຶ່ຮ ໂກ່ະ. ໄລ່ ກັອຍ ຕະ ມັ່ດ ມຸ່ຮ ຊູບ ໂອນ ກວາຍ ການໍ່ອ໌ ດັງ ປາຍ ໄລ່ ອົດ ຊັຣນາ ຈາ. ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ໄລ່ ກັອຍ ເບີນ ຣັ່ບ ເຈີ່ ເກືາ ແຕ ຣານະ ໄລ່ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ມາ ແຕີ່ອ໌ ເຍືາ ອົດ ຊັຣນາ ດໍອ໌ ຊາງ ເຢືາງ ເຈົາຣາຊີ, ອຶງເຄາະ ເຍືາ ກູລຍາ ມາມ ກະ ຊຽດ ໂຊະ ໂປ່ຍ. ");
INSERT INTO ncq_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ອຶນໂຈຍ ໂອນ ກວາຍ ການໍ່ອ໌ ດັງ ປາຍ ເຍືາ ອົດ ຊັຣນາ. ມາ ແອີງ ອຶມປໍ່ ເຍືາ ແຕິ່, ອັນ ກາ ເຍືາ ຕາ ເຕ່ອ໌ ເຮີມ, ອັນ ເຮີມ ມັຮ ຣານະ ເຍືາ ຕະ ຕຶ່ງ ອຶນຕຸ ຣາງຍາອ໌ ກັອຍ. ກະ ອັນ ກູລັຮ ເກືາ ມັຮ ຣານະ ກາ ເຍືາ ຕະ.\" ");
INSERT INTO ncq_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","\"ເຍືາ ອຶນໂຈຍ ປາໂຣມ ມູ່ນ ຕຶ່ງ ແດີຍ ໄນ່. ຍ່ອນ ເບີນ ອຶນຕຣູ່ນ ເລືານ ກະ ຊາແຣັຮ ຈາ, ກະ ເບີນ ຊາແວງ ມູ່ດ ຕູຕວຍ໌. ");
INSERT INTO ncq_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ມາ ອຶງເຄາະ ເຍືາ ດໍອ໌ ມູ່ນ ຕຶ່ງ ມັນລັ່ອງ, ລາ ອຶນຕຸ ກາ ຕາ ເບີນ ອຶນຕຣູ່ນ ເລືານ ກະ ຊາແຣັຮ ເຕ່ອ໌ ຈາ, ກະ ຕາ ເບີນ ຊາແວງ ມູ່ດ ຕູຕວຍ໌. ");
INSERT INTO ncq_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ຍ່ອນ ອຶນຕຸ ແລ່ະ ເຍືາ ດໍອ໌ ມັຮ ມູ່ນ ເຍືາ, ຣາງຶ່ຮ ເຍືາ ແອີດ ຄຶ່ດ ເລືອຍໆ ແຕ ອຶນຕຸ ກັອຍ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","\"ມັ່ດ ກວາຍ ລາ ນ່ະ ຕາບອງ ໂອນ ຈະ ກວາຍ. ຄັນ ມັ່ດ ເຍືາ ມາ ເຮີມ, ອຶນແຍ່ະ ຈະ ເຍືາ ແກີດ ປັ່ງ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ມາ ຄັນ ມັ່ດ ເຍືາ ແກີດ ແຊີມ, ອຶນແຍ່ະ ຈະ ເຍືາ ແກີດ ການຳ ຍີຍີ່ດ ເຕ່. ຄັນ ເຍືາ ຕາ ເບີນ ເບີນ ປັຣນາຍ ປັ່ງ ຕຶ່ງ ຣາງຶ່ຮ ເຍືາ, ແຮງ ເຍືາ ແອີດ ຕຶ່ງ ການຳ ປິງ ລາລື່ ແອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","\"ຕາ ເບີນ ອາແລ່ະ ມາ ເຕ່ອ໌ ແກີດ ຊູລ ໂອນ ບາຣ ນະ ອຶນເຈົາ. ປຍາຍ໌ ອັນ ຊາອັຣ ອຶນເຈົາ ໄນ່, ມາ ອາໂຢ່ະ ອຶນເຈົາ ກັອຍ. ແຕີລາ ອັນ ຊາງັດ ອຶນເຈົາ ໄນ່, ມາ ຕາ ເບີນ ຊາງັດ ອຶນເຈົາ ກັອຍ. ມູເຈິງ ກັອຍ ເຕ່ ເຍືາ ຕາ ເຕ່ອ໌ ປວາຍ ຣານະ ເຢືາງ ເຈົາຣາຊີ ມູ ເປຣິຮ ກະ ປວາຍ ຣານະ ຢໍອ໌ ອີ ເບີນ ເກຣີ່ງ ຊານົກ ຕຶ່ງ ແດີຍ ໄນ່ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","\"ນ່ະກັອຍ ເກົາ ອາຕີ ເຍືາ, ອຶນໂຈຍ ອຸກ ແຕ ຊັຣນາ ເຍືາ ຈາ, ແດີອ໌ ເຍືາ ງ່ອຍ໌, ກະ ຕຳປັອກ ເຍືາ ຕັອກ. ໄຮ ເບີນ ອາມົ່ງ ລາ ປື່ດ ກາເລີຍ ແຕ ໄຮ ເບີນ ຊັຣນາ ຈາ. ກະ ໄຮ ເບີນ ຈະຈັ່ນ, ລາ ປື່ດ ກາເລີຍ ແຕ ໄຮ ເບີນ ຕຳປັອກ ຕັອກ. ");
INSERT INTO ncq_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ເຍືາ ເນ່ ມັຮ ແຈມ ກາ ເກີ່ຍ ປັຣ ຕຶ່ງ ມັນລັ່ອງ. ອັນ ຕາ ເບີນ ຈັ່ດ ຈອຍ, ຕາ ເບີນ ຊອດ, ກະ ຕາ ເບີນ ດໍອ໌ ຊັຣນາ ອຶນເຕົ່າ ຕຶ່ງ ຊູ. ມາ ອຶມປໍ່ ເຍືາ ຕຶ່ງ ມັນລັ່ອງ ແຈມ ກຍາອ໌ ໂອນ ແຈມ ກັອຍ. ເຍືາ ລາ ເຢືາງ ເຈົາຣາຊີ ປາຊິ ກາເລີຍ ແຕ ແຈມ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ຕາ ເບີນ ກວາຍ ອາແລ່ະ ມາ ເຕ່ອ໌ ຕໍ ອາຍຸ່ ອັນ ໂອນ ຕີ່ ບີ່ອ໌ ແອັນ ຍ່ອນ ອັນ ອຸກ ຊາອຶ່ຍ. ");
INSERT INTO ncq_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","\"ກະ ນານ່ະ ເຍືາ ອຸກ ແຕ ຕຳປັອກ ກາ ເຍືາ ຕັອກ? ເຍືາ ເນ່ ປໍ ປຍາຣ ບັດ. ປຍາຣ ກັອຍ ຕາ ເບີນ ຕຸ່ຮ ຕະ ຣານະ ແຕີລາ ຕານ ຕຳປັອກ ຕັອກ. ");
INSERT INTO ncq_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ມາ ເກົາ ອາຕີ ເຍືາ, ເຕືາວ ປັຣເຍືາ ໂຊໂລໂມນ, ອັນ ລາ ກວາຍ ຊຸ ລາລື່, ມາ ອັນ ຕາ ເບີນ ຕັອກ ຕຳປັອກ ອໍ ນ່ະ ປຍາຣ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ເຢືາງ ເຈົາຣາຊີ ແຕິ່ ໂອນ ປຍາຣ ກັອຍ ແກີດ ອໍ. ມາ ປຍາຣ ກັອຍ ອາມົ່ງ ມາໂຮຍ ຊັອງ. ຕາໄງ ໄນ່ ອັນ ຈັຮ, ມາ ຕາໄງ ປັຣແນີ ເນົ່າ ອາປັອງ ຕັຮ ຕຶ່ງ ອູ່ຍຮ. ມາ ເຢືາງ ເຈົາຣາຊີ ຈ່ອຍ ເຍືາ ໂອນ ເບີນ ຕຳປັອກ ຕັອກ ກາເລີຍ ແຕ ບັດ ກັອຍ ແອັນ. ມາ ນານ່ະ ແຕ ເຍືາ ຊາອຳ ບີ່ອ໌ ລາລື່? ");
INSERT INTO ncq_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","\"ນ່ະກັອຍ ເຍືາ ອຶນໂຈຍ ອຸກ ກະ ປາຍ: 'ນານ່ະ ໄຮ ອີ ຕະ ໂອນ ເບີນ ຊັຣນາ ຈາ, ເບີນ ແດີອ໌ ງ່ອຍ໌, ແຕີລາ ເບີນ ຕຳປັອກ ຕັອກ ຕຶ່ງ ຕາໄງ ອຶນຕູ່ນ?' ");
INSERT INTO ncq_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ອຶນແຍ່ະ ມັຮ ຣາມຶ່ຮ ໄນ່ ກວາຍ ກາ ຕາ ເບີນ ດັງ ເຢືາງ ເຈົາຣາຊີ ຊັອງ ອຸກ ລາລື່. ມາ ອຶມປໍ່ ເຍືາ ຕຶ່ງ ມັນລັ່ອງ ດັງ ເຈີ່ ເຍືາ ອຶງເຄາະ ເບີນ ມັຮ ຣາມຶ່ຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ມາ ອຶນໂຍ່ງ ລາລື່ ອຶງເຄາະ ເຍືາ ຈໍ່ອ໌ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ກະ ຣານະ ຕານັ່ອງ ອໍ ແຕ ອັນ. ຄັນ ເຍືາ ຕະ ນ່ະກັອຍ, ອັນ ຈ່ອຍ ເຕ່ ມັຮ ຣາມຶ່ຮ ກາ ເຍືາ ອຶງເຄາະ ເບີນ. ");
INSERT INTO ncq_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ນ່ະກັອຍ ເຍືາ ອຶນໂຈຍ ອຸກ ອຶນເຕົ່າ ແຕ ຕາໄງ ປັຣແນີ. ຍ່ອນ ປັຣແນີ ລາ ເບີນ ເຕ່ ຣານະ ອຸກ. ຕຸ່ຮ ກັ່ດ ຕາໄງ ແລ່ະ, ເຍືາ ຈີວ໌ ຕາໄງ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","\"ເຍືາ ອຶນໂຈຍ ຕິ ກວາຍ ການໍ່ອ໌, ໂອນ ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ຕິ ລັ່ຮ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ຍ່ອນ ມາແລ່ະ ຊາອຶ່ຍ ເຍືາ ອາເກີນ ໂລ່ຍຮ ເຢົ່າ ເຍືາ, ເຢືາງ ເຈົາຣາຊີ ອາເກີນ ລັ່ຮ ໂລ່ຍຮ ເຍືາ ມາຮ ກັອຍ ເຕ່. ກະ ມາແລ່ະ ເຍືາ ໂຈະ ໂຕ່ດ ກວາຍ ການໍ່ອ໌, ເຢືາງ ເຈົາຣາຊີ ໂຈະ ລັ່ຮ ໂຕ່ດ ເຍືາ ມາຮ ກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ນານ່ະ ເຍືາ ເຮີມ ບຣິຮ ຕຶ່ງ ມັ່ດ ເຢົ່າ, ມາ ເຍືາ ຕາ ເບີນ ດັງ ປາລິຮ ອາລ່ອງ ກາ ກາຕັງ ມັ່ດ ເຍືາ? ");
INSERT INTO ncq_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ນານ່ະ ແຕ ຍັ່ນ ເຍືາ ປາຍ ກະ ເຢົ່າ ນ່ະໄນ່: 'ໂອນ ເກົາ ອີດ ຕັຮ ບຣິຮ ແຕ ມັ່ດ ໄມ່.' ມາ ເຍືາ ຕາ ເບີນ ດັງ ປາລິຮ ອາລ່ອງ ກາ ກາຕັງ ມັ່ດ ເຍືາ? ");
INSERT INTO ncq_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ເຍືາ ລາ ກວາຍ ມາມ ອໍ ມາ ຣາງຶ່ຮ ໂກ່ະ! ອຶງເຄາະ ເຍືາ ອີດ ຕັຮ ປາລິຮ ອາລ່ອງ ແຕ ມັ່ດ ເຍືາ ເວືາຍ. ນ່ະກັອຍ ເຕ່ອ໌ ເຍືາ ເຮີມ ແຈງ ເຈີ່ ເຕ່ອ໌ ເຍືາ ອີດ ຕັຮ ບຣິຮ ແຕ ມັ່ດ ເຢົ່າ. ");
INSERT INTO ncq_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","\"ເຍືາ ອຶນໂຈຍ ອີດ ເກຣີ່ງ ເນົ່າ ອີ ໂອນ ເຢືາງ ເຈົາຣາຊີ, ເຈີ່ ຊາດຸຮ ໂອນ ອາຈໍ. ກະ ອຶນໂຈຍ ອີດ ເກຣີ່ງ ປາຊິ, ເຈີ່ ຊາດຸຮ ໂອນ ອາລີ່ອ໌. ຊັນຕຣັ່ນ ກັອຍ ຕາ ດັງ ປາຊິ ເກຣີ່ງ ກັອຍ. ແວັດ ອັນ ຊາເຕືາຍ໌ ຊາແມບ ເກຣີ່ງ ກັອຍ, ເຈີ່ ອັນ ອີ ລົ່ບ ລັ່ຮ ກັບ ເຍືາ ແອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","\"ຄັນ ເຍືາ ແຊອ໌, ເຍືາ ເບີນ. ຄັນ ເຍືາ ຈໍ່ອ໌, ເຍືາ ຣາມົຮ. ຄັນ ເຍືາ ກູໂຕຍຮ ຕົ່ງ, ເນົ່າ ເປິຮ ໂອນ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ຍ່ອນ ກູ່ ນະ ອາແລ່ະ ກາ ແຊອ໌, ອັນ ເບີນ. ອາແລ່ະ ກາ ຈໍ່ອ໌, ອັນ ຣາມົຮ. ອາແລ່ະ ກາ ກູໂຕຍຮ ຕົ່ງ, ເນົ່າ ເປິຮ ໂອນ. ");
INSERT INTO ncq_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ມັຮ ເຍືາ ກາ ເບີນ ກອນ ເຈີ່, ນານ່ະ ຄັນ ກອນ ເຍືາ ແຊອ໌ ຈາ ໂດຍ, ເຍືາ ໂອນ ອັນ ຈາ ຕາເມົາ ບໍ? ");
INSERT INTO ncq_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ກະ ຄັນ ອັນ ແຊອ໌ ອາກາ, ເຍືາ ໂອນ ອັນ ກູຊັນ ບໍ? ");
INSERT INTO ncq_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ເຍືາ ລາ ອຶນແຍ່ະ ກວາຍ ຕາ ເບີນ ອໍ, ມາ ອຶນນັ່ອງ ເຍືາ ດັງ ໂອນ ເກຣີ່ງ ອໍ ປໍ ກອນ ເຍືາ. ກາເລີຍ ແຕ ກັອຍ ແອັນ ອຶມປໍ່ ເຍືາ ຕຶ່ງ ມັນລັ່ອງ ໂອນ ເກຣີ່ງ ອໍ, ຄັນ ເຍືາ ແຊອ໌ ແຕ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","\"ນ່ະກັອຍ ອຶນເຕົ່າ ເຍືາ ຢໍອ໌ ກວາຍ ການໍ່ອ໌ ຕະ ໂຈະ ເຍືາ, ອຶງເຄາະ ເຍືາ ຕະ ໂຈະ ກວາຍ ການໍ່ອ໌ ນ່ະກັອຍ ເຕ່. ຄັນ ເຍືາ ຕະ ນ່ະກັອຍ ລາ ເຍືາ ປວາຍ ປຍາຍ໌ ເຈີ່ ຄານອດ ເຢືາງ ເຈົາຣາຊີ ກະ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","\"ອຶງເຄາະ ເຍືາ ມູ່ດ ຣານາ ງັ່ຮ ຕົ່ງ ເກ່ບ, ຍ່ອນ ຕົ່ງ ຕາວັ່ຮ ກະ ຣານາ ປື່ດ, ລາ ເປາະ ປໍ ປຣຸ່ງ ອູ່ຍຮ. ກຼຶ່ງ ກວາຍ ຣຽຮ ເປາະ ຣານາ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ມາ ງັ່ຮ ຕົ່ງ ເກ່ບ ກະ ຣານາ ກັ່ດ, ລາ ເປາະ ປໍ ອຶນຕຸ ອາມົ່ງ. ມາ ບີ່ອ໌ ນະ ກວາຍ ຣາມົຮ ຣານາ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","\"ອຶງເຄາະ ເຍືາ ລາວັ່ງ ໂອນ ອໍ, ແຕ ກວາຍ ກາ ຕະ ອຶນຕີ ອາໂລກ ແຕີ່ອ໌ ປໍ ເຍືາ ປາຍ ໄລ່ ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ. ໄລ່ ແຕີ່ອ໌ ປໍ ເຍືາ ຕະ ຄູ່ນ ນ່ະ ແກະ ມາ ຣາງຶ່ຮ ໄລ່ ລາ ນ່ະ ຊາກັອງ, ປຼາ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ເຕ່ອ໌ ເຍືາ ຊາກັ່ລ ໄລ່, ແຕີ່ອ໌ ເຍືາ ເຮີມ ຣານະ ໄລ່ ຕະ. ກັ່ລ ຊັຣເລືາ ຕາແກີງ ຕາ ເກີ່ຍ ແກີດ ປາໄລ ອາງຸ່ນ. ກະ ກັ່ລ ຊັຣເລືາ ຈົງ ຕາ ເກີ່ຍ ແກີດ ປາໄລ ລາວັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ມູເຈິງ ກັອຍ ເຕ່ ອາລ່ອງ ອໍ ແກີດ ປາໄລ ອໍ, ກະ ອາລ່ອງ ຕາ ອໍ ແກີດ ປາໄລ ຕາ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ອາລ່ອງ ອໍ ຕາ ເຕ່ອ໌ ແກີດ ປາໄລ ຕາ ອໍ, ກະ ອາລ່ອງ ຕາ ອໍ ຕາ ເຕ່ອ໌ ແກີດ ປາໄລ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ຄັນ ອາລ່ອງ ອາແລ່ະ ຕາ ເບີນ ແກີດ ປາໄລ ອໍ, ເນົ່າ ໄປ່ອ໌ ເຈີ່ ແກຼງ ຕັຮ ຕຶ່ງ ອູ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ມູເຈິງ ກັອຍ ເຕ່ ເຍືາ ເຕ່ອ໌ ຊາກັ່ລ ກວາຍ ກາ ຕະ ອຶນຕີ ອາໂລກ ປາຍ ໄລ່ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ຍ່ອນ ເຍືາ ເຮີມ ແຕ ມັຮ ຣານະ ໄລ່ ຕະ.\" ");
INSERT INTO ncq_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","\"ຕາ ເບີນ ກູ່ ນະ ກາ ດໍອ໌ ເກົາ ລາ ອຶນເຈົາ ມາ ເຕ່ອ໌ ມູ່ດ ຕຶ່ງ ອຶນຕຸ ເຢືາງ ເຈົາຣາຊີ ຊົດ ຕຶ່ງ ມັນລັ່ອງ. ແອີງ ໄລ່ ກາ ຕະ ຕາປູ່ນ ຣາງຶ່ຮ ອຶມປໍ່ ເກົາ ຕຶ່ງ ມັນລັ່ອງ ແຕິ່ ເຕ່ອ໌ ເບີນ ມູ່ດ. ");
INSERT INTO ncq_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ແຕີ່ອ໌ ຕາໄງ ກັອຍ ຊາອຶ່ຍ ກວາຍ ປາຍ ໂຈະ ເກົາ ນ່ະໄນ່: 'ອຶນເຈົາ ເອີຍ! ອຶນເຈົາ ເອີຍ! ຍ່ອນ ຣາມຶ່ຮ ເຍືາ ຮິ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ. ກະ ຍ່ອນ ຣາມຶ່ຮ ເຍືາ ຮິ ຕູ່ຍຮ ເຢືາງ ຕາ ອໍ, ກະ ຕະ ຊາອຶ່ຍ ຣານະ ຕາ ເກີ່ຍ ເຮີມ.' ");
INSERT INTO ncq_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ມາ ເກົາ ຕາແອີຍ ໄລ່ ປາຍ: 'ເກົາ ຕາ ເບີນ ດັງ ເຍືາ. ເຍືາ ເປາະ ຊັອງ ແຕ ໄນ່. ເຍືາ ລາ ກວາຍ ຕະ ຣານະ ຕາ ອໍ.'\" ");
INSERT INTO ncq_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","\"ນ່ະກັອຍ ກວາຍ ອາແລ່ະ ກາ ຊາງັດ ກະ ຕະ ປວາຍ ປັຣນາຍ ເກົາ ອາຕີ ໄນ່, ອັນ ລາ ນ່ະ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ກາ ຈົຮ ດຸງ ຕຶ່ງ ຕາເມົາ ຕາຕາຣ. ");
INSERT INTO ncq_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ແຕີ່ອ໌ ເມືາ ຈັ່ນ, ແດີອ໌ ປື່ດ ກຼຸ່ຮ, ກະ ກູຢາລ ຣາປູ່ອ໌ ເຣ່ງ, ມາ ດຸງ ກັອຍ ຈັບ ຕາ ເບີນ ແດິມ, ຍ່ອນ ກວາຍ ກາ ຕະ ດຸງ ກັອຍ ຈົຮ ຕຶ່ງ ຕາເມົາ. ");
INSERT INTO ncq_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","ມາ ກວາຍ ອາແລ່ະ ກາ ຊັອງ ປັຣນາຍ ເກົາ ອາຕີ ໄນ່, ມາ ຕາ ເບີນ ຕະ ປວາຍ, ອັນ ກັອຍ ລາ ນ່ະ ກວາຍ ຊາກູລ ກາ ຈົຮ ດຸງ ຕຶ່ງ ຊາງາຍ໌. ");
INSERT INTO ncq_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ແຕີ່ອ໌ ເມືາ ຈັ່ນ, ແດີອ໌ ປື່ດ ກຼຸ່ຮ, ກະ ກູຢາລ ຣາປູ່ອ໌ ເຣ່ງ, ເຈີ່ ດຸງ ກັອຍ ແກີດ ຊາຣຳ; ເຈີ່ ຣາລຸຮ ອຶນແຍ່ະ!\" ");
INSERT INTO ncq_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ແວັດ ເຢຊູ ອາຕີ ອຶນແຍ່ະ ມັຮ ປັຣນາຍ ໄນ່, ອຶນແຍ່ະ ມັຮ ກວາຍ ກຼຶ່ງ ແອີດ ອຶມແປຣ ກັອຍ ຊັອງ ງຶ່ດ ລາລື່ ແຕ ອັນ ອາຕີ, ");
INSERT INTO ncq_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ຍ່ອນ ອັນ ອາຕີ ນ່ະ ກວາຍ ກາ ເບີນ ອຳນາດ ປື່ດ ລາລື່, ອຶມພາ ແຕ ກວາຍ ອາຕີ ຄານອດ ເກີ່ຍ ອາຕີ. ");
INSERT INTO ncq_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ພໍກາ ເຢຊູ ແຊງ ແຕ ກົຮ, ເບີນ ກຼຶ່ງ ກວາຍ ປວາຍ ອຶນຕູ່ນ ກຣັອງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ເບີນ ມານະ ກວາຍ ຣາເລົາ ອາອີ່ ຕູ່ດ ແຕີ່ອ໌ ກຼຸ່ ຣາໂກລ ຢັ່ຮ ເມືາງ ເຢຊູ, ກະ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ຄັນ ອຶນເຈົາ ຢໍອ໌ ອີ ປົວ ໂອນ ເກົາ ແກີດ ແບຣັຮ, ເຕ່ອ໌ ອຶນເຈົາ ຕະ.\" ");
INSERT INTO ncq_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ເຢຊູ ຊາປ່ະ ອາຕີ ຕຶ່ງ ຈະ ກວາຍ ອາອີ່ ກັອຍ, ເຈີ່ ປາຍ: \"ເກົາ ຢໍອ໌ ອີ ໂອນ ໄມ່ ແກີດ ແບຣັຮ.\" ບັອງ ກາ ກັອຍ ແຕິ່ ກວາຍ ອາອີ່ ຕູ່ດ ກັອຍ ແກີດ ແບຣັຮ. ");
INSERT INTO ncq_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ເຈີ່ ເຢຊູ ປາຕັບ ອັນ ປາຍ: \"ໄມ່ ອຶນໂຈຍ ອາຕີ ໂອນ ກວາຍ ການໍ່ອ໌ ດັງ ແຕ ຣານະ ໄນ່. ມາ ໄມ່ ເປາະ ອາປັຮ ຈະ ໄມ່ ໂອນ ກວາຍ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ເນ່. ກະ ໄມ່ ມ່ອບ ຊາງ ໂອນ ເຢືາງ ເຈົາຣາຊີ ມັຮ ຣາມຶ່ຮ ໂມເຊ ປາຕັບ ແຕ ອຶມແບິ. ໄນ່ ລາ ອາປັຮ ໂອນ ກວາຍ ການໍ່ອ໌ ດັງ ປາຍ ໄມ່ ແກີດ ແບຣັຮ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ບັອງ ກາ ເຢຊູ ມູ່ດ ຕຶ່ງ ເມືອງ ກາເປນາອູມ, ເບີນ ມານະ ກວາຍ ໂຣມ ກາ ຊົດ ມວຍ ຣ່ອຍ ຕາຮານ ແຕີ່ອ໌ ປໍ ອັນ ກະ ແຊອ໌ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","\"ອຶນເຈົາ ເອີຍ! ມານະ ກວາຍ ຊູລ ຕຶ່ງ ດຸງ ເກົາ ອາອີ່ ລ່ອຍ ຊາປັ່ລ ລາລື່.\" ");
INSERT INTO ncq_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ເຢຊູ ຕາແອີຍ ອັນ ປາຍ: \"ເຕ່ອ໌ ເກົາ ເປາະ ປົວ ໂອນ ອັນ ແກີດ ແບຣັຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ມາ ອັນ ກາ ຊົດ ຕາຮານ ກັອຍ ປາຍ: \"ອຶນເຈົາ ເອີຍ, ເກົາ ຕາ ເບີນ ປຍາຍ໌ ເປາະ ອີດ ອຶນເຈົາ ໂອນ ເປາະ ປໍ ດຸງ ເກົາ. ມາ ເກົາ ແຊອ໌ ອຶນເຈົາ ປາຍ ຊັອງ ໂອນ ຊູລ ເກົາ ແກີດ ແບຣັຮ. ");
INSERT INTO ncq_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ເກົາ ເບີມ ລາ ອຶນນັ່ອງ ເບີນ ເນືາຍ, ກະ ເກົາ ລາ ເນືາຍ ກວາຍ ການໍ່ອ໌ ເຕ່. ຄັນ ເກົາ ແປຣີ ກວາຍ ໄນ່: 'ເປາະ!' ອັນ ເປາະ. ຄັນ ເກົາ ແປຣີ ກວາຍ ກັອຍ: 'ແຕີ່ອ໌ ປໍ ໄນ່!' ອັນ ແຕີ່ອ໌. ຄັນ ເກົາ ແປຣີ ຊູລ ເກົາ: 'ຕະ ນ່ະໄນ່!' ອັນ ຕະ.\" ");
INSERT INTO ncq_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ບັອງ ກາ ເຢຊູ ຊັອງ ປັຣນາຍ ກັອຍ, ຣາງຶ່ຮ ອັນ ຊັອງ ງຶ່ດ ລາລື່. ກະ ອັນ ປາຍ ໂຈະ ກວາຍ ການໍ່ອ໌ ກາ ແອີດ ອຶມແປຣ ອັນ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ເກົາ ຕາ ເກີ່ຍ ເຮີມ ກວາຍ ອິດຊະຣາເອລ ມາ ຊາອຳ ນ່ະ ກວາຍ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ກະ ເກົາ ອາຕີ ເຕ່ ເຍືາ ປາຍ: ເບີນ ກຼຶ່ງ ກວາຍ ແຕີ່ອ໌ ແຕ ຢັ່ຮ ມັ່ດ ມານາງ ລັ່ອຮ, ກະ ຢັ່ຮ ມັ່ດ ມານາງ ປັດ. ໄລ່ ເບີນ ຕາກູ ຈາ ຕຶ່ງ ອຶນຕຸ ເຢືາງ ເຈົາຣາຊີ ຊົດ ຕຶ່ງ ມັນລັ່ອງ ມັນຕຸ ກະ ອັບຣາຮາມ, ອີຊາກ, ກະ ຢາໂຄບ. ");
INSERT INTO ncq_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ມາ ມັຮ ກວາຍ ອິດຊະຣາເອລ ກາ ເນົ່າ ດໍອ໌ ກອນແຊມ ເຢືາງ ເຈົາຣາຊີ, ໄລ່ ກາ ຕາ ເບີນ ຊາອຳ, ເຢືາງ ເຈົາຣາຊີ ແກຼງ ຕັຮ ໄລ່ ຕຶ່ງ ອຶນຕຸ ການຳ, ລາ ອຶນຕຸ ເຍືາມຍີ່ດ ກະ ກາເຕຣືອກ ກາແນງ ກາບາງ ຊັອງ ຕຸ່ຮ ອາຣຶ່ກ ລາລື່.\" ");
INSERT INTO ncq_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ແວັດ ກັອຍ, ເຢຊູ ອາຕີ ເນືາຍ ຕາຮານ ກັອຍ ປາຍ: \"ໄມ່ ເຈົາ ປໍ ດຸງ. ມັຮ ຣານະ ກາ ໄມ່ ຊາອຳ ກັອຍ, ໄມ່ ເບີນ ເຈີ່.\" ບັອງ ກາ ກັອຍ ແຕິ່ ຊູລ ເນືາຍ ຕາຮານ ກັອຍ ແກີດ ແບຣັຮ. ");
INSERT INTO ncq_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ບັອງ ກາ ເຢຊູ ມູ່ດ ຕຶ່ງ ດຸງ ເປໂຕ, ອັນ ເຮີມ ກູຢາກັນ ເປໂຕ ບິ ແອີດ ຕຶ່ງ ກາເຈີ່ງ ແກີດ ອາອີ່ ກູເຕົາ ຈະ. ");
INSERT INTO ncq_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ເຢຊູ ຊາປ່ະ ຕຶ່ງ ອາຕີ ອາຢ່ະ ກັອຍ, ເຈີ່ ກູເຕົາ ກັອຍ ແກີດ ປິ່ດ. ເຈີ່ ອັນ ຢວຣ, ກະ ຕະ ຊັຣນາ ຈາ ໂອນ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ພໍກາ ຕາບື່ ເນົ່າ ເດີງ ກຼຶ່ງ ກວາຍ ກາ ເບີນ ເຢືາງ ຕາ ອໍ ຕຣວບ ແຕີ່ອ໌ ປໍ ເຢຊູ. ເຈີ່ ເຢຊູ ຕູ່ຍຮ ອາລັ່ອຮ ມັຮ ເຢືາງ ຕາ ອໍ ກັອຍ ຍ່ອນ ແຕ ປັຣນາຍ ອັນ. ກະ ອັນ ປົວ ກູ່ ນະ ກວາຍ ກາ ເບີນ ອາອີ່ ການໍ່ອ໌ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ອັນ ຕະ ຣານະ ກັອຍ ໂອນ ແກີດ ຣາປຍາຍ໌ ກະ ປັຣນາຍ ເອຊາຢາ, ລາ ກວາຍ ກາ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ປາຍ: \"ມານະ ອັນ ແຕິ່ ເຕ່ອ໌ ປົວ ກະ ອີດ ຕັຮ ອຶນແຍ່ະ ມັຮ ຣາມຶ່ຮ ອາອີ່ ໄຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ພໍກາ ເຢຊູ ເຮີມ ກຼຶ່ງ ກວາຍ ແອີດ ອຶມແປຣ ອັນ, ອັນ ແປຣີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ອາລອງ ອັນ ຢັ່ຮ ອຶນຕົ່ຮ ທາເລ ຣາປັ່ງ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ເບີນ ມານະ ກວາຍ ອາຕີ ຄານອດ ແຕີ່ອ໌ ປໍ ອັນ ກະ ປາຍ: \"ອາຈານ ເອີຍ! ປໍ ແລ່ະ ອາຈານ ເປາະ, ເກົາ ອີ ປວາຍ ອາຈານ ປໍ ກັອຍ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ມາ ເຢຊູ ຕາແອີຍ ອັນ ປາຍ: \"ຕາຈໍອ໌ ອຶນນັ່ອງ ເບີນ ກື່ບ, ກະ ແຈມ ອຶນນັ່ອງ ເບີນ ຊານົຮ, ມາ ເກົາ ກອນ ເຢືາງ ແກີດ ກວາຍ ຕາ ເບີນ ອຶນຕຸ ແລ່ະ ອີ ໂອນ ອັນ ບິ.\" ");
INSERT INTO ncq_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ເບີນ ມານະ ການໍ່ອ໌ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ເກຣາະ ອຶມປໍ່ ເກົາ ກູຈີດ ເວືາຍ. ແວັດ ເກົາ ແຕິບ ອຶມປໍ່ ເກົາ, ກັອຍ ແຕ ເກົາ ອີ ປວາຍ ອຶນເຈົາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ມາ ເຢຊູ ຕາແອີຍ ອັນ ປາຍ: \"ໄມ່ ປວາຍ ເກົາ ຊັອງ. ດໍອ໌ ໂອນ ໄລ່ ກາ ຕາ ເບີນ ມວຍ ຣາງຶ່ຮ ກະ ເກົາ ແຈມ ກຍາອ໌ ເບີມ ກວາຍ ການໍ່ອ໌ ກາ ຕາ ເບີນ ມວຍ ຣາງຶ່ຮ ກະ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ເຈີ່ ເຢຊູ ຊັອຮ ຕຶ່ງ ຕົວະ, ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ຊັອຮ ອາລຶ່ງ ອັນ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ແວັດ ກັອຍ ຊັນຕັຣ ເບີນ ກູຢາລ ຣາປູ່ອ໌ ເຣ່ງ ລາລື່ ຕະ ໂອນ ແດີອ໌ ປ່ອງ ເຈີ່ ກຼຸ່ຮ ຕົວະ ເຣ່ງ ລາລື່ ແຈ່ະ ອີ ລັ່ອງ. ມາ ບັອງ ກາ ກັອຍ ເຢຊູ ອຶນນັ່ອງ ບິ. ");
INSERT INTO ncq_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ເປາະ ອາໄມ່ຮ ອັນ ກະ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ຈ່ອຍ ເລີ່! ໄຮ ແຈ່ະ ອີ ກູຈີດ ເອີຍ໌!\" ");
INSERT INTO ncq_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ມາ ເຢຊູ ຕາແອີຍ ລັ່ຮ ໄລ່ ປາຍ: \"ນານ່ະ ແຕ ເຍືາ ອຶງກັອຮ? ເຍືາ ຊາອຳ ບີ່ອ໌ ລາລື່ ບໍ?\" ເຈີ່ ເຢຊູ ຢວຣ ຕາຢຶ່ງ ກາແອັຮ ກູຢາລ ກະ ແດີອ໌ ປ່ອງ. ນ່ະກັອຍ ແດີອ໌ ກະ ກູຢາລ ກັອຍ ແກີດ ຕາງິ່ດ. ");
INSERT INTO ncq_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ໄລ່ ຊັອງ ງຶ່ດ ລາລື່ ກະ ປາຍ: \"ນານ່ະ ກວາຍ ໄນ່? ກູຢາລ ກະ ແດີອ໌ ມາ ຊາງັດ ອັນ!\" ");
INSERT INTO ncq_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ພໍກາ ເຢຊູ ໄກ່ອ໌໌ ແຕີ່ອ໌ ຢັ່ຮ ອຶນຕົ່ຮ ທາເລ ຣາປັ່ງ ກັອຍ, ອັນ ມູ່ດ ຕຶ່ງ ກຣວາງ ເຄຣາຊາ. ອັນ ຣາມົຮ ບາຣ ນະ ກາ ເບີນ ເຢືາງ ຕາ ອໍ ຕຣວບ, ໄລ່ ລັ່ອຮ ແຕ ປີ່ງ ກູມູ່ຍ໌. ໄລ່ ກັອຍ ເຮາະ ລາລື່; ຕາ ເບີນ ເນົ່າ ຍັ່ນ ພາ ອຶນຕຸ ໄລ່ ແອີດ. ");
INSERT INTO ncq_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ບັອງ ກາ ໄລ່ ເຮີມ ເຢຊູ, ໄລ່ ບາຣ ນະ ກັອຍ ແຮຣ ເຣ່ງ ລາລື່ ປາຍ: \"ເອີ ກອນ ເຢືາງ ເຈົາຣາຊີ ເອີຍ! ອຶນເຕົ່າ ເຍືາ ຢໍອ໌ ອີ ຕະ ກະ ຮິ? ຊານໍ່ ຕາ ຢວາຮ ແຕີ່ອ໌ ປາເນ່ນ ຮິ ຈີວ໌ ຕຸ່ຮ ກັ່ດ. ມາ ເຍືາ ຢໍອ໌ ອີ ຕະ ໂອນ ຮິ ຈີວ໌ ແຕ ຊານໍ່ ແຕິ່ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ແຈ່ະ ອຶນຕຸ ກັອຍ ເບີນ ມວຍ ຈຸ່ມ ອາລີ່ອ໌ ຊາອຶ່ຍ ລາລື່ ແອີດ ຈໍ່ອ໌ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ເຢືາງ ຕາ ອໍ ກັອຍ ກູກຸຮ ແຊອ໌ ແຕ ເຢຊູ ປາຍ: \"ຄັນ ເຍືາ ອີ ຕູ່ຍຮ ອາລັ່ອຮ ຮິ, ແຊອ໌ ເຍືາ ໂອນ ຮິ ມູ່ດ ຕຶ່ງ ຈຸ່ມ ອາລີ່ອ໌ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ເຢຊູ ແປຣີ ເຢືາງ ຕາ ອໍ ກັອຍ ປາຍ: \"ເຍືາ ເປາະ ແຕິ່!\" ເຈີ່ ເຢືາງ ຕາ ອໍ ກັອຍ ລັ່ອຮ ແຕິ່ ແຕ ຈະ ກວາຍ ມູ່ດ ຕຶ່ງ ຈຸ່ມ ອາລີ່ອ໌ ແອັນ. ເຈີ່ ຈຸ່ມ ອາລີ່ອ໌ ກັອຍ ຕາລຸ່ຮ ໄວ່ ແຕ ແລັ່ຮ ຕາຣວາລ ອາປັອງ ປໍ ທາເລ ຣາປັ່ງ, ເຈີ່ ກູຈີດ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ໄລ່ ກາ ກຍາອ໌ ອາລີ່ອ໌ ກັອຍ ຕາລຸ່ຮ ເຈົາ ປໍ ວີ່ລ ອາຕີ ລັ່ຮ ກູ່ ຣານະ ແຕ ໄລ່ ບາຣ ນະ ກາ ເບີນ ເຢືາງ ຕາ ອໍ ຕຣວບ, ໂອນ ເນົ່າ ດັງ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ເຈີ່ ກູ່ ນະ ກວາຍ ແອີດ ຕຶ່ງ ເມືອງ ກັອຍ, ໄລ່ ລັ່ອຮ ແຕ ເມືອງ ຢໍອ໌ ອີ ຣາມົຮ ເຢຊູ. ບັອງ ກາ ໄລ່ ເຮີມ ເຢຊູ, ໄລ່ ແຊອ໌ ໂອນ ເຢຊູ ລັ່ອຮ ແຕ ກຣວາງ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ເຈີ່ ເຢຊູ ຊັອຮ ລັ່ຮ ຕຶ່ງ ຕົວະ. ອັນ ໄກ່ອ໌໌ ລັ່ຮ ຢັ່ຮ ອຶນຕົ່ຮ ທາເລ ຣາປັ່ງ, ອັນ ມູ່ດ ຕຶ່ງ ເມືອງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ເຈີ່ ເນົ່າ ເດີງ ປໍ ອັນ ມານະ ກວາຍ ອາອີ່ ລ່ອຍ. ອັນ ບິ ຕຶ່ງ ຈຸ່ງຈາງ. ເຢຊູ ເຮີມ ຣາງຶ່ຮ ໄລ່ ກັອຍ ຊາອຳ ລາລື່. ນ່ະກັອຍ ອັນ ປາຍ ໂຈະ ກວາຍ ລ່ອຍ ກັອຍ ປາຍ: \"ກອນ ເອີຍ! ໄມ່ ອຶນໂຈຍ ອຶງກັອຮ ອຶນເຕົ່າ ນັ່ອງ! ໂລ່ຍຮ ໄມ່ ເກົາ ຕັຮ ໂອນ ເຈີ່!\" ");
INSERT INTO ncq_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ບັອງ ກາ ກັອຍ ເບີນ ມູ່ ກາ ອາຕີ ຄານອດ ແອີດ ປໍ ກັອຍ ເຕ່. ໄລ່ ຄຶ່ດ ຕຶ່ງ ຣາງຶ່ຮ ໄລ່ ປາຍ: \"ກວາຍ ໄນ່, ອັນ ຢໍອ໌ ອີ ເບີນ ອຳນາດ ຣາລີ ກະ ເຢືາງ ເຈົາຣາຊີ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ມາ ເຢຊູ ດັງ ເຈີ່ ໄລ່ ຄຶ່ດ ນ່ະກັອຍ. ອັນ ຕາແບີບ ໄລ່ ກັອຍ ປາຍ: \"ນານ່ະ ເຍືາ ຄຶ່ດ ຣານະ ຕາ ອໍ ນ່ະກັອຍ ຕຶ່ງ ຣາງຶ່ຮ ເຍືາ? ");
INSERT INTO ncq_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ປັຣນາຍ ອາແລ່ະ ກາ ເຍືາ ຊັອງ ອຽນ ກາເລີຍ ເກົາ ອາຕີ ກວາຍ ລ່ອຍ ກັອຍ ປາຍ: 'ໂລ່ຍຮ ໄມ່ ເກົາ ຕັຮ ໂອນ ເຈີ່,' ແຕີລາ: 'ໄມ່ ຢວຣ ຕາຢຶ່ງ ເປາະ.' ");
INSERT INTO ncq_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ມາ ຊານໍ່ ເກົາ ອີ ຕະ ໂອນ ກວາຍ ລ່ອຍ ໄນ່ ແກີດ ແບຣັຮ ໂອນ ເຍືາ ດັງ ແຈງ ລາລື່, ເກົາ ລາ ກອນ ເຢືາງ ແກີດ ກວາຍ, ເບີນ ອຳນາດ ຕຶ່ງ ກູແຕອ໌ ໄນ່. ເກົາ ເຕ່ອ໌ ຕັຮ ໂລ່ຍຮ ກວາຍ.\" ແວັດ ກັອຍ ເຢຊູ ອາຕີ ໂອນ ກວາຍ ລ່ອຍ ປາຍ: \"ໂອນ ໄມ່ ຢວຣ ຕາຢຶ່ງ! ໂດລ ອີດ ຈຸ່ງຈາງ ໄມ່! ເຈີ່ ໄມ່ ເຈົາ ລັ່ຮ ປໍ ດຸງ!\" ");
INSERT INTO ncq_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ເຈີ່ ກວາຍ ອາອີ່ ກັອຍ ຢວຣ ຕາຢຶ່ງ ກະ ເຈົາ ລັ່ຮ ປໍ ດຸງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ບັອງ ກາ ກວາຍ ກຼຶ່ງ ກັອຍ ເຮີມ ຣານະ ໄນ່, ໄລ່ ຊັອງ ງຶ່ດ ລາລື່, ກະ ໄລ່ ຍ່ອງ ເຢືາງ ເຈົາຣາຊີ ຍ່ອນ ອັນ ໂອນ ກວາຍ ເບີນ ອຳນາດ ນ່ະກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ເຈີ່ ເຢຊູ ລັ່ອຮ ແຕ ອຶນຕຸ ກັອຍ. ບັອງ ກາ ອັນ ເປາະ ຕຶ່ງ ຣານາ ອັນ ເຮີມ ມານະ ຣາມຶ່ຮ ມັດທາຍ ຕາກູ ຕະ ຣານະ ຕຶ່ງ ດຸງ ເນົ່າ ປາໂຣມ ອີດ ປຣະ ປາຊີ. ເຈີ່ ເຢຊູ ກູອ໌ ອັນ ປາຍ: \"ໂອນ ໄມ່ ເປາະ ອາລຶ່ງ ເກົາ!\" ເຈີ່ ມັດທາຍ ຢວຣ ຕາຢຶ່ງ ເປາະ ອາລຶ່ງ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ບັອງ ກາ ເຢຊູ ຕາກູ ຈາ ຕຶ່ງ ດຸງ ມັດທາຍ ເບີນ ກຼຶ່ງ ກວາຍ ການໍ່ອ໌ ແຕີ່ອ໌ ຈາ ມັນຕຸ ກະ ອັນ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ. ໄລ່ ກັອຍ ລາ ກວາຍ ປາໂຣມ ອີດ ປຣະ ປາຊີ ກະ ກວາຍ ການໍ່ອ໌ ກາ ຕາ ເບີນ ປວາຍ ຄານອດ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ເບີນ ກວາຍ ແຕ ຈຸ່ມ ພາຣີຊາຍ ເຮີມ ນ່ະກັອຍ. ເຈີ່ ໄລ່ ຕາແບີບ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ປາຍ: \"ນານ່ະ ອາຈານ ເຍືາ ຈາ ມັນຕຸ ກະ ໄລ່ ກາ ປາໂຣມ ອີດ ປຣະ ປາຊີ ກະ ກວາຍ ໂລ່ຍຮ ການໍ່ອ໌ ແຮີ?\" ");
INSERT INTO ncq_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ພໍກາ ເຢຊູ ຊັອງ ໄລ່ ປາຍ ນ່ະກັອຍ, ອັນ ຕາແອີຍ ລັ່ຮ ໄລ່ ປາຍ: \"ກວາຍ ບັນ ເຣ່ງ ອໍ ຕາ ເບີນ ເປາະ ແຊອ໌ ໂອນ ເນົ່າ ປົວ. ມາ ແອີງ ກວາຍ ອາອີ່ ຊັອງ ເປາະ ແຊອ໌ ໂອນ ເນົ່າ ປົວ. ");
INSERT INTO ncq_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ, ອັນ ປາຍ ເຈີ່ ນ່ະໄນ່: 'ເກົາ ຢໍອ໌ ອີ ໂອນ ເຍືາ ມານະ ອາໂຢ່ະ ຕະ ມານະ ກາເລີຍ ແຕ ເກົາ ຢໍອ໌ ອີ ໂອນ ເຍືາ ອີດ ຊັນຕຣັ່ນ ມ່ອບ ຊາງ ເກົາ.' ອຶງເຄາະ ເຍືາ ເປາະ ຣຍານ ໂອນ ດັງ ແຈງ ປັຣນາຍ ກັອຍ. ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່ ເກົາ ຕາ ເບີນ ກູອ໌ ກວາຍ ກາ ຕານັ່ອງ ອໍ. ມາ ເກົາ ກູອ໌ ກວາຍ ກາ ເບີນ ໂລ່ຍຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ແວັດ ກັອຍ ມູ່ ກາ ຣຍານ ແຕ ໂຢຮັນ ແຕີ່ອ໌ ປໍ ເຢຊູ. ໄລ່ ຕາແບີບ ອັນ ປາຍ: \"ນານ່ະ ມູ່ ຮິ ກະ ຈຸ່ມ ພາຣີຊາຍ ເດີງ ຣີ່ດ ອົດ ຊັຣນາ ດໍອ໌ ຊາງ ເຢືາງ ເຈົາຣາຊີ, ມາ ມູ່ ກາ ຣຍານ ແຕ ອາຈານ ຕາ ເບີນ ຕະ ມູເຈິງ ຮິ?\" ");
INSERT INTO ncq_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ບັອງ ກາ ປັຣລົວະ ອີ ອີດ ລາກວຍ, ມັຮ ເຢົ່າ ກາ ແອີດ ກະ ອັນ ໄລ່ ຕາ ເຕ່ອ໌ ອົດ ຊັຣນາ. ມາ ພໍກາ ຕາໄງ ປັຣລົວະ ກັອຍ ຕາ ເບີນ ແອີດ ນັ່ອງ ກະ ເຢົ່າ ອັນ, ຕາໄງ ກັອຍ ໄລ່ ອີ ອົດ ຊັຣນາ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","\"ຕາ ເບີນ ກວາຍ ອາແລ່ະ ອີດ ອາຣົ່ຮ ຕາໄມ ເຈີ່ ທາບ ໂຈະ ອາຢັ່ອຮ ຕຍາ. ຄັນ ອາຣົ່ຮ ຕາໄມ ກັອຍ ຣາຮົດ, ອັນ ອີ ຕະ ໂອນ ອາຢັ່ອຮ ກັອຍ ຣາແຮອ໌ ຕາວັ່ຮ ອຶງກວາ ຕຍາ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ກະ ຕາ ເບີນ ກວາຍ ອາແລ່ະ ອີດ ບຼັອງ ຕາໄມ ມາ ຕຣອງ ໂຈະ ຕຶ່ງ ຕູຍ ອຶງກັຣ ຕຍາ. ຄັນ ເນົ່າ ຕະ ນ່ະກັອຍ, ບຼັອງ ຕາໄມ ອັນ ອີ ຕະ ໂອນ ຕູຍ ອຶງກັຣ ຕຍາ ກັອຍ ແກີດ ປັຣອາອ໌. ອຶງເຄາະ ອີດ ບຼັອງ ຕາໄມ ໂຈະ ຕຶ່ງ ຕູຍ ອຶງກັຣ ຕາໄມ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ບັອງ ກາ ເຢຊູ ອາຕີ ກວາຍ ກັອຍ, ເບີນ ມານະ ກາ ຕາລາ ດຸງ ຊາງ ຈຸ່ມ ອິດຊະຣາເອລ ແຕີ່ອ໌ ປໍ ອັນ. ກວາຍ ກັອຍ ກຼຸ່ ຣາໂກລ ຢັ່ຮ ເມືາງ ເຢຊູ, ກະ ປາຍ: \"ກອນ ມັນແຊມ ເກົາ ກູຈີດ ເຈີ່. ເກົາ ແຊອ໌ ອາຈານ ແຕີ່ອ໌ ຊາປ່ະ ອາຕີ ຕຶ່ງ ຈະ ກອນ ເກົາ, ໂອນ ອັນ ເບີນ ອາມົ່ງ ລັ່ຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ນ່ະກັອຍ ເຢຊູ ຢວຣ ຕາຢຶ່ງ ເປາະ ມັນຕຸ ກະ ອຶມປໍ່ ອາມໍອ໌ ກັອຍ. ກາ ມູ່ ກາ ຣຍານ ແຕ ອັນ ລາ ເປາະ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ບັອງ ກາ ກັອຍ ເບີນ ມານະ ມັນແຊມ ແຕີ່ອ໌ ຢັ່ຮ ກຣັອງ ເຢຊູ. ມັນແຊມ ກັອຍ ອາອີ່ ແກີດ ຮື່. ອຶນແຍ່ະ ມັນຈິ່ດ ລາ ບາຣ ກູມໍ ມາ ຕາ ແກີດ ປຣາຍ ອາອີ່ ກັອຍ. ນ່ະກັອຍ ອັນ ຊາປ່ະ ຕວຍ໌ ເປິບ ອາຢັ່ອຮ ຕີ່ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ມັນແຊມ ກັອຍ ຄຶ່ດ ຕຶ່ງ ຣາງຶ່ຮ ອັນ ປາຍ: \"ຄັນ ເກົາ ຊາປ່ະ ອາຢັ່ອຮ ເຢຊູ, ເກົາ ແກີດ ແບຣັຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ເຢຊູ ກູລຽວ ເນ່ ຢັ່ຮ ກຣັອງ ອັນ. ພໍກາ ອັນ ເຮີມ ມັນແຊມ ກັອຍ, ເຈີ່ ອັນ ປາຍ: \"ອາມໍອ໌ ເອີຍ, ໄມ່ ອຶນໂຈຍ ອຶງກັອຮ ອຶນເຕົ່າ. ຈະ ໄມ່ ແກີດ ແບຣັຮ ເຈີ່ ຍ່ອນ ໄມ່ ຊາອຳ.\" ບັອງ ກາ ກັອຍ ແຕິ່ ມັນແຊມ ກັອຍ ແກີດ ແບຣັຮ. ");
INSERT INTO ncq_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ແວັດ ກັອຍ ເຢຊູ ມູ່ດ ຕຶ່ງ ດຸງ ອັນ ກາ ຕາລາ ດຸງ ຊາງ ຈຸ່ມ ອິດຊະຣາເອລ. ອັນ ເຮີມ ໄລ່ ປຼົງ ຕາຣີລ ກະ ເຍືາມ ກູໂກຼຍ໌ ຮື່ ປັຣຮື່. ");
INSERT INTO ncq_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ອັນ ອາຕີ ໄລ່ ກັອຍ ປາຍ: \"ເຍືາ ລັ່ອຮ ອຶນແຍ່ະ ແຕ ດຸງ ໄນ່! ມັນແຊມ ໄນ່ ຕາ ເບີນ ກູຈີດ, ອັນ ບິ ຊັອງ!\" ມາ ໄລ່ ກັອຍ ກັຣຈັງ ເຈືາດ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ພໍກາ ກວາຍ ກຼຶ່ງ ລັ່ອຮ ອຶນແຍ່ະ ແຕ ກັອຍ, ເຢຊູ ມູ່ດ ຕຶ່ງ ກຼຸງ ມັນແຊມ ກາ ກູຈີດ ກັອຍ. ອັນ ຢຸມ ອາຕີ ອາມໍອ໌ ກັອຍ. ເຈີ່ ອາມໍອ໌ ກັອຍ ຢວຣ ຕາຢຶ່ງ. ");
INSERT INTO ncq_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ປັຣນາຍ ໄນ່ ເປາະ ປຼັຮ ກູ່ ອຶນຕຸ ຕຶ່ງ ກຣວາງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ພໍກາ ເຢຊູ ລັ່ອຮ ແຕ ອຶນຕຸ ກັອຍ, ເບີນ ບາຣ ນະ ກວາຍ ຊູດ ມັ່ດ ປວາຍ ອຶນຕູ່ນ ກຣັອງ ອັນ. ໄລ່ ຊາບາວ ເຣ່ງ ລາລື່ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ອຶນເຈົາ ກາ ແຕ ຈຸ່ມເຈືອ ດາວິດ! ແຊອ໌ ອຶນເຈົາ ອາໂຢ່ະ ຕະ ຮິ ແຮີ!\" ");
INSERT INTO ncq_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ບັອງ ກາ ເຢຊູ ມູ່ດ ຕຶ່ງ ດຸງ, ໄລ່ ບາຣ ນະ ກວາຍ ຊູດ ມັ່ດ ກັອຍ ແຕີ່ອ໌ ປໍ ອັນ. ເຢຊູ ຕາແບີບ ໄລ່ ກັອຍ ປາຍ: \"ເຍືາ ຊາອຳ ປາຍ ເກົາ ເຕ່ອ໌ ຕະ ໂອນ ມັ່ດ ເຍືາ ແກີດ ແບຣັຮ ບໍ?\" ໄລ່ ບາຣ ນະ ກັອຍ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ຮິ ຊາອຳ, ອຶນເຈົາ ເອີຍ!\" ");
INSERT INTO ncq_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ເຈີ່ ເຢຊູ ຊາປ່ະ ອາຕີ ຕຶ່ງ ມັ່ດ ໄລ່ ບາຣ ນະ ກັອຍ, ກະ ອັນ ປາຍ: \"ເຍືາ ຊາອຳ ນານ່ະ, ໂອນ ອັນ ແກີດ ນ່ະກັອຍ!\" ");
INSERT INTO ncq_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ນ່ະກັອຍ ມັ່ດ ໄລ່ ບາຣ ນະ ກັອຍ ແກີດ ປັ່ງ ລັ່ຮ. ມາ ເຢຊູ ປາຕັບ ໄລ່ ໄຄອ໌ ລາລື່ ປາຍ: \"ເຍືາ ອຶນໂຈຍ ອາຕີ ໂອນ ກວາຍ ການໍ່ອ໌ ດັງ ແຕ ຣານະ ໄນ່!\" ");
INSERT INTO ncq_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ມາ ແວັດ ໄລ່ ລັ່ອຮ ແຕ ດຸງ ກັອຍ, ໄລ່ ອາຕີ ແຕ ຣານະ ເຢຊູ ຕະ ຕົວ ກູ່ ອຶນຕຸ ຕຶ່ງ ກຣວາງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ບັອງ ກາ ກວາຍ ຊູດ ມັ່ດ ລັ່ອຮ ແຕ ອຶນຕຸ ກັອຍ, ເບີນ ກວາຍ ການໍ່ອ໌ ເດີງ ມານະ ກວາຍ ເກີອ໌ ແຕີ່ອ໌ ປໍ ເຢຊູ. ອັນ ແກີດ ເກີອ໌ ຍ່ອນ ເບີນ ເຢືາງ ຕາ ອໍ ຕະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ແວັດ ເຢຊູ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ແຕ ກວາຍ ເກີອ໌ ກັອຍ, ເຈີ່ ກວາຍ ເກີອ໌ ກັອຍ, ອັນ ເຕ່ອ໌ ຕະ ອຶນຕີ ລັ່ຮ. ອຶນແຍ່ະ ມັຮ ກວາຍ ການໍ່ອ໌ ກັອຍ ຊັອງ ງຶ່ດ ລາລື່. ກະ ໄລ່ ປາຍ: \"ໄຮ ຕາ ເກີ່ຍ ເຮີມ ຣານະ ນ່ະໄນ່ ແຕີ່ອ໌ ປໍ ກຣວາງ ອິດຊະຣາເອລ!\" ");
INSERT INTO ncq_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ມາ ຈຸ່ມ ພາຣີຊາຍ ປາຍ: \"ໄກຣ ລາລື່ ເຢືາງ ຊາຕານ ແຕິ່ ໂອນ ກວາຍ ໄນ່ ເບີນ ອຳນາດ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ເຢຊູ ເປາະ ຊາອົຮ ຕຶ່ງ ເມືອງ ປື່ດ ເມືອງ ແກດ, ອາຕີ ຕຶ່ງ ມັຮ ດຸງ ຊາງ ກວາຍ ອິດຊະຣາເອລ. ອັນ ອາຕີ ປັຣນາຍ ອໍ ແຕ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ. ກະ ອັນ ປົວ ກູ່ ຣາມຶ່ຮ ກວາຍ ເບີນ ອາອີ່. ");
INSERT INTO ncq_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ພໍກາ ອັນ ເຮີມ ກວາຍ ກຼຶ່ງ, ຣາງຶ່ຮ ອັນ ຊັອງ ອາໂຢ່ະ ຕະ ກວາຍ ກັອຍ, ຍ່ອນ ໄລ່ ຕາ ດັງ ອີ ຕະ ອຶນເຕົ່າ, ກະ ໄລ່ ປັຣວັດ ປັຣເວີ, ນ່ະ ແກະ ແອິ ກວາຍ ຕາລາ. ");
INSERT INTO ncq_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ນ່ະກັອຍ ເຢຊູ ປາຍ ໂຈະ ມູ່ ກາ ຣຍານ ແຕ ອັນ: \"ທຣໍ ຕຶ່ງ ໄທຣ ຕາວັ່ຮ ຈີນ ລາລື່ ເຈີ່, ມາ ເບີນ ບີ່ອ໌ ນະ ກວາຍ ເປາະ ຊອດ ທຣໍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ອຶງເຄາະ ເຍືາ ແຊອ໌ ແຕ ອຶນເຈົາ ໄທຣ, ໂອນ ອັນ ແປຣີ ເບີນ ຊາອຶ່ຍ ນະ ແອັນ ເປາະ ຊອດ ທຣໍ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ເຢຊູ ກູອ໌ ມູ່ ມວຍ ຈິ່ດ ລາ ບາຣ ນະ ກາ ຣຍານ ແຕ ອັນ ແຕີ່ອ໌ ປໍ ອັນ. ອັນ ໂອນ ໄລ່ ກັອຍ ເບີນ ອຳນາດ ເຕ່ອ໌ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ແຕ ຈະ ກວາຍ ກະ ເຕ່ອ໌ ປົວ ກູ່ ຣາມຶ່ຮ ກວາຍ ອາອີ່. ");
INSERT INTO ncq_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ຣາມຶ່ຮ ມວຍ ຈິ່ດ ລາ ບາຣ ນະ ກາ ເຢຊູ ຣຽຮ ລາ ນ່ະໄນ່: ອຶນໂຍ່ງ ລາລື່ ລາ ຊີໂມນ, ອັນ ກາ ເນົ່າ ດໍອ໌ ເປໂຕ ແຮີ, ກະ ອັນເດອາ, ລາ ອາແອມ ຊີໂມນ. ແວັດ ກັອຍ ເບີນ ບາຣ ນະ ແຊມອາຍ ກອນ ເຊເບດາຍ, ຢາໂກໂບ ກະ ໂຢຮັນ. ");
INSERT INTO ncq_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ອຶນຕູ່ນ ໄນ່ ເບີນ ພີລິບ ກະ ບາຣໂທໂລມາຍ, ໂທມາ ກະ ມັດທາຍ, ອັນ ກາ ປາໂຣມ ປຣະ ປາຊີ. ເບີນ ຢາໂກໂບ, ກອນ ອາລະພາຍ ກະ ທາດາຍ. ");
INSERT INTO ncq_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ເບີນ ຊີໂມນ ເຊໂລເຕ ກະ ຢູດາ ອິດຊະກາຣີອົດ, ອັນ ກາ ມ່ອບ ໂອນ ເນົ່າ ກາຈີດ ຕັຮ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ເຢຊູ ແປຣີ ມວຍ ຈິ່ດ ລາ ບາຣ ນະ ໄນ່ ໂອນ ເປາະ ຕະ ຣານະ ອັນ. ອັນ ປາຕັບ ໄລ່ ກັອຍ ປາຍ: \"ເຍືາ ອຶນໂຈຍ ເປາະ ປໍ ກຣວາງ ກາ ຕາ ແກີນ ກວາຍ ອິດຊະຣາເອລ. ກະ ອຶນໂຈຍ ມູ່ດ ຕຶ່ງ ເມືອງ ກວາຍ ຊາມາເຣຍ. ");
INSERT INTO ncq_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ມາ ໂອນ ເຍືາ ເປາະ ປໍ ກວາຍ ອິດຊະຣາເອລ ຊັອງ. ໄລ່ ກັອຍ ນ່ະ ແກະ ກາ ແກຼິ ຣານາ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ເຍືາ ເປາະ ອາຕີ ປາຍ: 'ແຈ່ະ ລາລື່ ເຈີ່ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ!' ");
INSERT INTO ncq_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ອຶງເຄາະ ເຍືາ ປົວ ກວາຍ ອາອີ່ ກະ ອາໂມ່ຍຮ ໄລ່ ກາ ກູຈີດ ເຈີ່. ອຶງເຄາະ ເຍືາ ປົວ ໄລ່ ກາ ເບີນ ອາອີ່ ຕູ່ດ ກະ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ແຕ ຈະ ກວາຍ. ເຍືາ ຣັ່ບ ເຈີ່ ມັຮ ຣາມຶ່ຮ ເກົາ ຈ່ອຍ ເມືາດ ໂອນ ເຍືາ. ນ່ະກັອຍ ຊານໍ່ ອຶງເຄາະ ເຍືາ ຈ່ອຍ ເມືາດ ກວາຍ ການໍ່ອ໌ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ເຍືາ ອຶນໂຈຍ ກຽມ ດໍອ໌ ແຢງ ກະ ປຣະ ຕຶ່ງ ຕູຍ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ອຶນໂຈຍ ເດີງ ຕູຍ ນ່ະ ກວາຍ ຊູແຊອ໌ ເກຣີ່ງ ແຕ ກວາຍ ການໍ່ອ໌. ອຶນໂຈຍ ເດີງ ບາຣ ປຼັ່ຮ ອາຢັ່ອຮ ແຕີລາ ບາຣ ກູ່ ແກີບ ແຕີລາ ບາຣ ອຶນແຕຣັ່ຮ ຣາແລີງ. ກວາຍ ອາແລ່ະ ມາ ຕະ ຣານະ ຈ່ອຍ ກວາຍ ການໍ່ອ໌, ອຶງເຄາະ ກວາຍ ການໍ່ອ໌ ກັອຍ ຈ່ອຍ ລັ່ຮ ໂອນ ອັນ ເບີນ ເກຣີ່ງ ຊັຣນາ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","\"ບັອງ ກາ ເຍືາ ແຕີ່ອ໌ ປໍ ວີ່ລ ປື່ດ ວີ່ລ ແກດ, ອຶງເຄາະ ເຍືາ ມູ່ດ ຕຶ່ງ ວີ່ລ ກັອຍ ຈໍ່ອ໌ ກວາຍ ຕານັ່ອງ ກາ ຣັ່ບ ຕາແບີບ ອໍ ເຍືາ. ເຈີ່ ເຍືາ ແອີດ ຕຶ່ງ ດຸງ ກວາຍ ກັອຍ ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ເຍືາ ລັ່ອຮ ແຕ ວີ່ລ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ບັອງ ກາ ເຍືາ ມູ່ດ ຕຶ່ງ ດຸງ, ອຶງເຄາະ ເຍືາ ຕາແບີບ ກັຣຮານ ອໍ ກະ ດຸງຊູ ກວາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ຄັນ ກວາຍ ຕຶ່ງ ດຸງ ກັອຍ ຣັ່ບ ກະ ຣາບັນ ອໍ ເຍືາ, ເຍືາ ເກົາແຊອ໌ ໂອນ ໄລ່ ເບີນ ບັນຊວານ ອຽນ ອໍ. ມາ ຄັນ ໄລ່ ຕາ ເບີນ ຣັ່ບ ກະ ຣາບັນ ອໍ ເຍືາ, ເຍືາ ອຶນໂຈຍ ເກົາແຊອ໌ ນ່ະກັອຍ ໂອນ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ຄັນ ເບີນ ມວຍ ດຸງ ແຕີລາ ມວຍ ວີ່ລ, ກວາຍ ຕຶ່ງ ອຶນຕຸ ກັອຍ ຕາ ເບີນ ຣັ່ບ ເຍືາ ກະ ໄລ່ ຕາ ຢໍອ໌ ອີ ຊາງັດ ປັຣນາຍ ເຍືາ ອາຕີ, ພໍກາ ເຍືາ ລັ່ອຮ ແຕ ອຶນຕຸ ກັອຍ ອຶງເຄາະ ເຍືາ ກັນຕຣິ່ຮ ພຸ່ນ ກູແຕອ໌ ແຕ ອາເຢີງ ຕະ ໂອນ ເນົ່າ ດັງ ປາຍ ກວາຍ ຕຶ່ງ ອຶນຕຸ ກັອຍ ຕາ ເບີນ ຣັ່ບ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ: ແຕີ່ອ໌ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ຕັດຊີ່ນ ອຶນແຍ່ະ ມັຮ ກວາຍ, ອັນ ຕະ ໂອນ ໄລ່ ກາ ແອີດ ຕຶ່ງ ວີ່ລ ກັອຍ ເບີນ ຕຸ່ຮ ກັ່ດ ກາເລີຍ ແຕ ໄລ່ ກາ ແອີດ ຕຶ່ງ ເມືອງ ໂຊໂດມ ກະ ເມືອງ ໂກໂມຣາ ແຕ ອຶມແບິ.\" ");
INSERT INTO ncq_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","\"ເນ່ ໄນ່! ເກົາ ແປຣີ ເຍືາ ໂອນ ເປາະ ນ່ະ ແກະ ແອີດ ອຶນດີ ຊາກັອງ. ນ່ະກັອຍ ອຶງເຄາະ ເຍືາ ແກີດ ແຄວ໌ ນ່ະ ກູຊັນ, ກະ ຄູ່ນ ມັນຕັ່ດ ອໍ ນ່ະ ແຈມ ປາເຣືາດ. ");
INSERT INTO ncq_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ອຶງເຄາະ ເຍືາ ລາວັ່ງ ກວາຍ ການໍ່ອ໌, ຍ່ອນ ໄລ່ ອີ ໂກບ ເຍືາ, ເຈີ່ ເດີງ ເຍືາ ແຕີ່ອ໌ ປໍ ກວາຍ ຊົດ. ກະ ໄລ່ ໂອນ ເນົ່າ ປຍາຍຮ ເຍືາ ຕຶ່ງ ດຸງ ຊາງ ກວາຍ ອິດຊະຣາເອລ. ");
INSERT INTO ncq_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ຍ່ອນ ເຍືາ ຕາປູ່ນ ເກົາ, ເບີນ ກວາຍ ການໍ່ອ໌ ອີ ເດີງ ເຍືາ ແຕີ່ອ໌ ປໍ ກວາຍ ຊົດ ກະ ແຕີ່ອ໌ ປໍ ເຕືາວ ປັຣເຍືາ ແຮີ. ກັອຍ ແຕ ເຍືາ ເບີນ ອາຕີ ແຕ ຣານະ ເກົາ ຢັ່ຮ ເມືາງ ໄລ່ ກັອຍ ກະ ຢັ່ຮ ເມືາງ ກວາຍ ຕາ ແກີນ ກວາຍ ອິດຊະຣາເອລ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ແຕີ່ອ໌ ເນົ່າ ເດີງ ເຍືາ ປໍ ກວາຍ ຊົດ, ເຍືາ ອຶນໂຈຍ ອຸກ ດໍອ໌ ແຕ ອຶນເຕົ່າ ເຍືາ ຢໍອ໌ ອີ ປາຍ. ບັອງ ກາ ກັອຍ ເຍືາ ເບີນ ຣັ່ບ ມັຮ ປັຣນາຍ ເຍືາ ຢໍອ໌ ອີ ປາຍ. ");
INSERT INTO ncq_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ປັຣນາຍ ກັອຍ ຕາ ເບີນ ປັຣນາຍ ເຍືາ ເບີມ; ມາ ຣາເວືາຍ ອຶມປໍ່ ເຍືາ ຕຶ່ງ ມັນລັ່ອງ, ອັນ ອາຕີ ໂອນ ເຍືາ ດັງ ມັຮ ປັຣນາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","\"ແຊມອາຍ ອີ ໂກບ ຣາຕວາອ໌ ແຊມອາຍ, ເຈີ່ ມ່ອບ ໂອນ ເນົ່າ ກາຈີດ, ກະ ອຶມປໍ່ ຕະ ມູເຈິງ ກັອຍ ເຕ່ ກະ ກອນ ອັນ. ກອນ ອາໄກ ຣາອວານ ໂຈະ ອຶມເປ່ອ໌ ອຶມປໍ່ ໄລ່, ກະ ໄລ່ ມ່ອບ ອຶມເປ່ອ໌ ອຶມປໍ່ ໂອນ ເນົ່າ ກາຈີດ ຕັຮ. ");
INSERT INTO ncq_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ອຶນແຍ່ະ ມັຮ ກວາຍ ຊາອັຣ ເຍືາ ຍ່ອນ ເຍືາ ປວາຍ ຣານະ ເກົາ. ມາ ກວາຍ ອາແລ່ະ ກາ ເຣືາບ ຈີວ໌ ເຕົ່າ ຊົດ ແດີຍ ອັນ, ເຢືາງ ເຈົາຣາຊີ ຈ່ອຍ ອາມົ່ງ ກວາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ແຕີ່ອ໌ ກວາຍ ຕະ ຕຸ່ຮ ກັ່ດ ໂຈະ ເຍືາ ຕຶ່ງ ມວຍ ເມືອງ, ໂອນ ເຍືາ ຕາລຸ່ຮ ລັ່ອຮ ແຕ ເມືອງ ກັອຍ ເປາະ ປໍ ເມືອງ ການໍ່ອ໌ ແອັນ. ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ແຕີ່ອ໌ ກອນ ເຢືາງ ແກີດ ກວາຍ ແຕີ່ອ໌ ລັ່ຮ ປໍ ກູແຕອ໌ ໄນ່, ເຍືາ ຕາ ຢວາຮ ເປາະ ອາຕີ ອຶນແຍ່ະ ກູ່ ເມືອງ ຕຶ່ງ ກຣວາງ ອິດຊະຣາເອລ. ");
INSERT INTO ncq_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","\"ອັນ ກາ ຣຍານ ຕາ ເບີນ ປື່ດ ກາເລີຍ ແຕ ອາຈານ ອັນ. ກະ ອັນ ກາ ແກີດ ຊູລ ຕາ ເບີນ ປື່ດ ກາເລີຍ ແຕ ອຶນເຈົາ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ນ່ະກັອຍ ອັນ ກາ ຣຍານ ອຶງເຄາະ ປຣ່ອມ ຈີວ໌ ຕຸ່ຮ ກັ່ດ ມູເຈິງ ອາຈານ ອັນ ເຕ່. ກະ ອັນ ກາ ແກີດ ຊູລ ອຶງເຄາະ ປຣ່ອມ ຈີວ໌ ຕຸ່ຮ ກັ່ດ ມູເຈິງ ອຶນເຈົາ ອັນ ເຕ່. ຄັນ ເນົ່າ ພາມາດ ອັນ ກາ ອຶນເຈົາ ດຸງ, ດໍອ໌ ອັນ ລາ ຣາມຶ່ຮ ເບເອລເຊບູລ, ອຶນຕັອງ ກາເລີຍ ແອັນ ເນົ່າ ພາມາດ ກວາຍ ການໍ່ອ໌ ຕຶ່ງ ດຸງ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","\"ນ່ະກັອຍ ເຍືາ ອຶນໂຈຍ ອຶງກັອຮ ກວາຍ ການໍ່ອ໌, ຍ່ອນ ຄັນ ເບີນ ຣາມຶ່ຮ ອຶນເຕົ່າ ເນົ່າ ປູ່ລ ປາໂຕ່ະ ຊານໍ່, ເຈີ່ ປໍ ເມືາງ ຣາມຶ່ຮ ກັອຍ ເນົ່າ ຕາ ເຕ່ອ໌ ປູ່ລ ປາໂຕ່ະ ນັ່ອງ. ກະ ຣານະ ອຶນເຕົ່າ ເນົ່າ ຕະ ແກຣ່ະ ຊານໍ່, ເຈີ່ ປໍ ເມືາງ ຣານະ ກັອຍ ເນົ່າ ຕາ ເຕ່ອ໌ ຕະ ແກຣ່ະ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ມັຮ ປັຣນາຍ ອຶນເຕົ່າ ເກົາ ອາຕີ ເຍືາ ຕຶ່ງ ອຶນຕຸ ການຳ, ອຶງເຄາະ ເຍືາ ອາຕີ ລັ່ຮ ປັຣນາຍ ກັອຍ ຕຶ່ງ ອຶນຕຸ ປັ່ງ ແອັນ. ກະ ປັຣນາຍ ອຶນເຕົ່າ ເກົາ ຣາຮາຍ໌ ໂອນ ແອີງ ເຍືາ ຊັອງ, ອຶງເຄາະ ເຍືາ ອາຕີ ລັ່ຮ ປັຣນາຍ ກັອຍ ເຣ່ງ ລາລື່ ແຕ ຕຳປວລ ດຸງ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ເຍືາ ອຶນໂຈຍ ອຶງກັອຮ ໄລ່ ກາ ເຕ່ອ໌ ກາຈີດ ຈະ ເຍືາ, ມາ ຣາເວືາຍ ເຍືາ ໄລ່ ຕາ ເຕ່ອ໌ ກາຈີດ. ມາ ອຶງເຄາະ ເຍືາ ອຶງກັອຮ ແອີງ ເຢືາງ ເຈົາຣາຊີ ຊັອງ, ຍ່ອນ ເຢືາງ ເຈົາຣາຊີ ເຕ່ອ໌ ກາຈີດ ຈະ ເຍືາ, ກະ ຣາເວືາຍ ເຍືາ ເຕ່ອ໌ ອັນ ອາປັອງ ຕຶ່ງ ປຣຸ່ງ ອູ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ເຕ່ອ໌ ເຍືາ ແຈີງ ແຈມ ຈາບ ບາຣ ລຳ, ມາ ເກືາ ມວຍ ຢາດ ຊັອງ. ມາ ຄັນ ເບີນ ມານຳ ແຈມ ຈາບ ກັອຍ ກູຈີດ, ອຶມປໍ່ ເຍືາ ຕຶ່ງ ມັນລັ່ອງ ດັງ ເຈີ່ ແຕ ຣາມຶ່ຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ໄກຣ ລາລື່ ກູ່ ເຊັນ ໂຊະ ຕຶ່ງ ແປຼີ ເຍືາ, ເຢືາງ ເຈົາຣາຊີ ນັ່ບ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ນ່ະກັອຍ, ເຍືາ ອຶນໂຈຍ ອຶງກັອຮ ອຶນເຕົ່າ ນັ່ອງ, ຍ່ອນ ຣາງຶ່ຮ ເຍືາ ລາ ເຢືາງ ເຈົາຣາຊີ ປາຊິ ກາເລີຍ ແຕ ຊາອຶ່ຍ ລຳ ແຈມ ຈາບ. ");
INSERT INTO ncq_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","\"ກວາຍ ອາແລ່ະ ມາ ງີ່ນ ຢັ່ຮ ເມືາງ ກວາຍ ການໍ່ອ໌, ປາຍ ອັນ ເບີນ ມູ ຣາງຶ່ຮ ກະ ເກົາ, ມູເຈິງ ກັອຍ ເຕ່ ເກົາ ງີ່ນ ລັ່ຮ ອັນ ຢັ່ຮ ເມືາງ ອຶມປໍ່ ເກົາ ຕຶ່ງ ມັນລັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ມາ ກວາຍ ອາແລ່ະ ມາ ກາແລີຍຮ ເກົາ ຢັ່ຮ ເມືາງ ກວາຍ ການໍ່ອ໌, ມູເຈິງ ກັອຍ ເຕ່ ເກົາ ກາແລີຍຮ ລັ່ຮ ອັນ ຢັ່ຮ ເມືາງ ອຶມປໍ່ ເກົາ ຕຶ່ງ ມັນລັ່ອງ.\" ");
INSERT INTO ncq_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","\"ເຍືາ ອຶນໂຈຍ ຄຶ່ດ ປາຍ ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່ ໂອນ ກູ່ ນະ ກວາຍ ຕຶ່ງ ກູແຕອ໌ ໄນ່ ແອີດ ອຽນ ອໍ. ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່ ເກົາ ຕາ ເບີນ ຕະ ໂອນ ກວາຍ ແອີດ ອຽນ ອໍ, ມາ ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່ ເກົາ ເດີງ ເກຣີ່ງ ປຼາ. ");
INSERT INTO ncq_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່ ຕະ ໂອນ ເຍືາ ມານະ ຕາ ເບີນ ຊັງໄກຣ ໂຈະ ມານະ. ກອນ ຣາເລົາ ຕາ ເບີນ ຊັງໄກຣ ກະ ອຶມປໍ່. ກອນ ມັນແຊມ ຕາ ເບີນ ຊັງໄກຣ ກະ ອຶມເປ່ອ໌. ກູມັນ ຕາ ເບີນ ຊັງໄກຣ ກະ ກູຢາກັນ. ");
INSERT INTO ncq_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ໄລ່ ກາ ຢໍອ໌ ອີ ຕະ ເຍືາ ລາ ກວາຍ ແຕ ດຸງຊູ ເຍືາ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","\"ກວາຍ ອາແລ່ະ ມາ ອາໂຢ່ະ ອຶມເປ່ອ໌ ອຶມປໍ່ ອັນ ກາເລີຍ ແຕ ອັນ ອາໂຢ່ະ ເກົາ, ກວາຍ ກັອຍ ຕາ ເບີນ ໄກຣ ແກີດ ກວາຍ ປວາຍ ເກົາ. ກະ ກວາຍ ອາແລ່ະ ມາ ອາໂຢ່ະ ກອນ ຣາເລົາ ແຕີລາ ກອນ ມັນແຊມ ກາເລີຍ ແຕ ອັນ ອາໂຢ່ະ ເກົາ, ກວາຍ ກັອຍ ຕາ ເບີນ ໄກຣ ແກີດ ກວາຍ ປວາຍ ເກົາ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ກວາຍ ອາແລ່ະ ມາ ຕາ ເບີນ ໂດລ ອາລ່ອງ ຊັງກັງ ອັນ ເບີມ ກະ ຕາ ເບີນ ປວາຍ ເກົາ, ກວາຍ ກັອຍ ລາ ຕາ ເບີນ ໄກຣ ແກີດ ກວາຍ ຣຍານ ແຕ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ກວາຍ ອາແລ່ະ ມາ ປາຊິ ຣາງຶ່ຮ ອັນ ຕຶ່ງ ແດີຍ ໄນ່, ຣາງຶ່ຮ ກວາຍ ກັອຍ ແກີດ ປິ່ດ. ມາ ກວາຍ ອາແລ່ະ ມາ ຈີວ໌ ປິ່ດ ຣາງຶ່ຮ ອັນ ຕຶ່ງ ແດີຍ ໄນ່ ຍ່ອນ ຣານະ ເກົາ, ກວາຍ ກັອຍ ເບີນ ອາມົ່ງ.\" ");
INSERT INTO ncq_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","\"ກວາຍ ອາແລ່ະ ມາ ຣັ່ບ ອໍ ເຍືາ, ໄນ່ ລາ ນ່ະ ກວາຍ ກັອຍ ຣັ່ບ ອໍ ເກົາ ເຕ່. ກະ ກວາຍ ອາແລ່ະ ມາ ຣັ່ບ ອໍ ເກົາ, ໄນ່ ລາ ນ່ະ ກວາຍ ກັອຍ ຣັ່ບ ອໍ ອັນ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ກວາຍ ອາແລ່ະ ມາ ຣັ່ບ ອໍ ກວາຍ ກາ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ຍ່ອນ ອັນ ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ກວາຍ ກັອຍ ເບີນ ເກືາ ມູເຈິງ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ເຕ່. ກະ ກວາຍ ອາແລ່ະ ມາ ຣັ່ບ ອໍ ກວາຍ ຕານັ່ອງ ອໍ ຍ່ອນ ອັນ ລາ ກວາຍ ຕານັ່ອງ ອໍ, ກວາຍ ກັອຍ ເບີນ ເກືາ ມູເຈິງ ກວາຍ ກາ ຕານັ່ອງ ອໍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ຄັນ ເບີນ ກວາຍ ອາແລ່ະ ມາ ໂອນ ງ່ອຍ໌ ມວຍ ຈອກ ແດີອ໌ ຢິນ ປໍ ກວາຍ ກາ ຕາ ເບີນ ຊົດ ອຶນເຕົ່າ ຕຶ່ງ ມູ່ ກາ ຣຍານ ແຕ ເກົາ ຍ່ອນ ກວາຍ ກັອຍ ຕາປູ່ນ ເກົາ, ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ອັນ ກາ ຈ່ອຍ ກັອຍ ຕາ ເບີນ ແອິ ເກືາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ແວັດ ເຢຊູ ປາຕັບ ມູ່ ມວຍ ຈິ່ດ ລາ ບາຣ ນະ ກາ ຣຍານ ແຕ ອັນ ມັຮ ປັຣນາຍ ກັອຍ, ເຈີ່ ອັນ ລັ່ອຮ ແຕ ອຶນຕຸ ກັອຍ. ເປາະ ອາຕີ ຕຶ່ງ ມັຮ ເມືອງ ອຶມແປຣ ກັອຍ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ບັອງ ກາ ກັອຍ ໂຢຮັນ ກາ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ແອີດ ຕຶ່ງ ກໍ່ອ໌. ພໍກາ ອັນ ຊັອງ ເນົ່າ ຕະ ອຶນຕີ ແຕ ຣານະ ເຢຊູ ກຣີດ ຕະ, ເຈີ່ ອັນ ແປຣີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ເປາະ ປໍ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ອັນ ໂອນ ໄລ່ ກັອຍ ຕາແບີບ ເຢຊູ ປາຍ: \"ອາຈານ ເອີຍ! ປຍາຍ໌ ມາ ຕາ ເບີນ, ອາຈານ ລາ ມານະ ກາ ເຢືາງ ເຈົາຣາຊີ ຣຽຮ ໂອນ ຈ່ອຍ ອາມົ່ງ ອຶນແຍ່ະ ມັຮ ກວາຍ? ແຕີລາ ອຶງເຄາະ ຮິ ອຶງກ່ອງ ກວາຍ ການໍ່ອ໌ ແອັນ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ເຍືາ ເຈົາ ອາຕີ ລັ່ຮ ໂຢຮັນ ມັຮ ຣານະ ເຍືາ ຊັອງ ກະ ເຍືາ ເຮີມ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ກວາຍ ຊູດ ມັ່ດ ແກີດ ບຣາງ ລັ່ຮ. ກວາຍ ໂຢດ ເຕ່ອ໌ ເປາະ ລັ່ຮ. ກວາຍ ອາອີ່ ຕູ່ດ ແກີດ ແບຣັຮ ອຶນແຍ່ະ. ກວາຍ ຕຸ່ງ ແກີດ ຊັອງ ລັ່ຮ. ກວາຍ ກາ ກູຈີດ ເຈີ່ ໂມ່ຍຮ ລັ່ຮ. ກະ ກວາຍ ກາດີດ ເບີນ ຊັອງ ເຕ່ ປັຣນາຍ ອໍ ແຕ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ບຸ່ນ ລາລື່ ກວາຍ ກາ ຕາ ເບີນ ຕັຮ ຊາອຳ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ແວັດ ມູ່ ກາ ຣຍານ ແຕ ໂຢຮັນ ເຈົາ ລັ່ຮ ປໍ ອັນ, ເຢຊູ ອາຕີ ແຕ ໂຢຮັນ ໂອນ ກວາຍ ກຼຶ່ງ ກັອຍ ຊັອງ. ອັນ ຕາແບີບ ໄລ່ ປາຍ: \"ພໍກາ ເຍືາ ເປາະ ຣາມົຮ ໂຢຮັນ ຕຶ່ງ ຕຍາຮ, ອຶນເຕົ່າ ເຍືາ ຢໍອ໌ ອີ ເຮີມ ຕຶ່ງ ອຶນຕຸ ກັອຍ? ເຍືາ ຢໍອ໌ ອີ ເຮີມ ກູຢາລ ແປຼິ່ ກັ່ລ ອາຕັອງ ເລ່ດ ຕາຕຶ່ງ ຕາໂຕະ ບໍ? ");
INSERT INTO ncq_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ມາ ເຍືາ ເປາະ ຢໍອ໌ ອີ ເຮີມ ອຶນເຕົ່າ? ເຍືາ ຢໍອ໌ ອີ ເຮີມ ມານະ ແຊິບ ອາຢັ່ອຮ ອໍ ບໍ? ໄລ່ ກາ ແຊິບ ອາຢັ່ອຮ ອໍ ລາ ແອີດ ຕຶ່ງ ດຸງ ເຕືາວ ປັຣເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ມາ ອຶນເຕົ່າ ເຍືາ ຢໍອ໌ ອີ ເຮີມ ຕຶ່ງ ອຶນຕຸ ກັອຍ? ເຍືາ ຄຶ່ດ ຢໍອ໌ ອີ ເຮີມ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ບໍ? ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ໂຢຮັນ ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ເຕ່, ມາ ອັນ ເບີນ ອຳນາດ ປື່ດ ກາເລີຍ ອຶນແຍ່ະ ແຕ ກວາຍ ການໍ່ອ໌ ກາ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ, ກວາຍ ຄຽນ ເຈີ່ ມັຮ ກາ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ອຶນໂຍ່ງ ແຕ ໂຢຮັນ ປາຍ: 'ເກົາ ລາ ເຢືາງ ເຈົາຣາຊີ ອີ ແປຣີ ກວາຍ ກາ ເດີງ ປັຣນາຍ ເກົາ ແຕີ່ອ໌ ອຶນໂຍ່ງ ໄມ່. ອັນ ຈັຮ ຣານາ ໂອນ ໄມ່, ກອນ ເອີຍ.' ");
INSERT INTO ncq_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ກູ່ ນະ ກວາຍ ກາ ແກີດ ແຕ ມັນແຊມ ຕຶ່ງ ກູແຕອ໌ ໄນ່, ຕາ ເບີນ ເນົ່າ ປື່ດ ກາເລີຍ ແຕ ໂຢຮັນ, ອັນ ກາ ເກີ່ຍ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌. ມາ ເກົາ ອາຕີ ເຍືາ ປາຍ ແອັນ: ກວາຍ ອາແລ່ະ ມາ ຕາ ເບີນ ປື່ດ ອຶນເຕົ່າ ຕຶ່ງ ມູ່ ກາ ເຢືາງ ເຈົາຣາຊີ ຊົດ, ເຢືາງ ເຈົາຣາຊີ ໂອນ ກວາຍ ກັອຍ ເບີນ ອຳນາດ ກາເລີຍ ແຕ ໂຢຮັນ ເບີນ. ");
INSERT INTO ncq_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ແຕ ຕາໄງ ໂຢຮັນ ກາ ເກີ່ຍ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ເຕົ່າ ແຕີ່ອ໌ ຊານໍ່, ເບີນ ກວາຍ ອາຕີ ແຕ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ. ຊາອຶ່ຍ ລາລື່ ກວາຍ ຢໍອ໌ ອີ ມູ່ດ ຕຶ່ງ ຈຸ່ມ ກາ ເຢືາງ ເຈົາຣາຊີ ຊົດ, ມາ ໄລ່ ຄຶ່ດ ໄລ່ ເຕ່ອ໌ ມູ່ດ ຍ່ອນ ຣາງຶ່ຮ ໄລ່ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ເຢືາງ ເຈົາຣາຊີ ອາຕີ ອຶນໂຍ່ງ ຣານາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ ກະ ຣານາ ຄານອດ ໂມເຊ ປາຍ ປັຣແນີ ມັນເຕຣືາ ອັນ ຕະ ຊົດ. ອັນ ອາຕີ ຣານາ ກັອຍ ເຕົ່າ ແຕີ່ອ໌ ແດີຍ ໂຢຮັນ. ");
INSERT INTO ncq_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ຄັນ ເຍືາ ຊາອຳ ປັຣນາຍ ເນົ່າ ປາຍ ແຕ ອຶມແບິ ແຕ ເອລີຢາ, ນ່ະກັອຍ ເຍືາ ເບີນ ດັງ ໂຢຮັນ ໄນ່ ລາ ມູເຈິງ ເອລີຢາ ກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ອາແລ່ະ ເບີນ ກູຕູຣ, ໂອນ ອັນ ຊາງັດ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","\"ນານ່ະ ເຕ່ອ໌ ເກົາ ຊາກຳ ມັຮ ກວາຍ ຕຶ່ງ ແດີຍ ໄນ່? ໄກຣ ລາລື່ ມັຮ ກວາຍ ແອີດ ຕຶ່ງ ແດີຍ ໄນ່ ລາ ນ່ະ ກັຣແນນ ແອີດ ຣາເຈ່າະ ຕຶ່ງ ຕາລາດ. ມວຍ ມູ່ ກັຣແນນ ກັອຍ ກູອ໌ ເຢົ່າ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ໄລ່ ປາຍ: 'ຮິ ປຼົງ ຕາຣີລ ເຈີ່ ຣາເຈ່າະ ເຊີບ ດົນຕີ. ມາ ເຍືາ ຕາ ເບີນ ມູ່ດ ອາເຢີນ ກະ ອຶມປ່ອນ ບຼະໆ ກະ ຮິ! ກະ ຮິ ຣາເຈ່າະ ຕະ ຣາເປີບ, ມາ ເຍືາ ຕາ ເບີນ ປຣ່ອມ ມູ່ດ ເຍືາມ ກູໂກຼຍ໌ ກະ ຮິ!' ");
INSERT INTO ncq_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ໂຢຮັນ ແຕີ່ອ໌ ປໍ ໄນ່, ອັນ ຕາ ເບີນ ງ່ອຍ໌ ຈາ ນ່ະ ກວາຍ ການໍ່ອ໌. ອັນ ຈາ ແອີງ ລາມ ກະ ງ່ອຍ໌ ແດີອ໌ ກາຮຍາລ. ນ່ະກັອຍ ເນົ່າ ປາຍ ອັນ ລາ ກວາຍ ຢຸ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ມາ ເກົາ ກອນ ເຢືາງ ແກີດ ກວາຍ, ເກົາ ແຕີ່ອ໌ ງ່ອຍ໌ ຈາ ມູເຈິງ ກວາຍ ການໍ່ອ໌ ເຕ່. ນ່ະກັອຍ ເນົ່າ ປາຍ ເກົາ ນ່ະໄນ່: 'ຕິຮ! ອັນ ກັອຍ ຢໍອ໌ ອີ ງ່ອຍ໌ ຈາ ກຸມປູ່ຣ ຊັອງ! ກະ ອັນ ແກີດ ເຢົ່າ ກວາຍ ກາ ອີດ ປຣະ ປາຊີ ກະ ກວາຍ ໂລ່ຍຮ ການໍ່ອ໌ ແຮີ!' ມາ ກວາຍ ອາແລ່ະ ກາ ຣາໄງ່ອ໌ ຣາລັ່ງ, ປັຣແນີ ມັນເຕຣືາ ກວາຍ ການໍ່ອ໌ ງີ່ນ ເຕ່ ກວາຍ ກັອຍ ຣາໄງ່ອ໌ ຣາລັ່ງ, ຍ່ອນ ໄລ່ ເຮີມ ຣານະ ກວາຍ ກັອຍ ຕະ.\" ");
INSERT INTO ncq_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ເຈີ່ ເຢຊູ ຊັອງ ຕຸ່ຮ ລາລື່ ຍ່ອນ ມັຮ ກວາຍ ຕຶ່ງ ເມືອງ ກາ ອັນ ຕະ ຊາອຶ່ຍ ຣານະ ຕາ ເກີ່ຍ ເຮີມ, ໄລ່ ຕາ ເບີນ ປຽນ ແກີດ ຣາງຶ່ຮ ຕາໄມ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ອັນ ປາຍ ໂຈະ ໄລ່ ນ່ະໄນ່: \"ບາບ ລາລື່ ແຕີ່ອ໌ ປໍ ເຍືາ ກາ ແອີດ ຕຶ່ງ ເມືອງ ໂຄຣາຊິນ! ກະ ບາບ ລາລື່ ໂອນ ເຍືາ ກາ ແອີດ ຕຶ່ງ ເມືອງ ເບັດຊາອີດາ! ຄັນ ເກົາ ມາ ຕະ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ຕຶ່ງ ເມືອງ ຕີເຣ ກະ ເມືອງ ຊີໂດນ ມູເຈິງ ເກົາ ຕະ ຕຶ່ງ ເມືອງ ເຍືາ ເຈີ່, ດູ່ນ ເຈີ່ ກວາຍ ຕຶ່ງ ເມືອງ ກັອຍ ປຽນ ແກີດ ຣາງຶ່ຮ ຕາໄມ ແອັນ. ກະ ດູ່ນ ເຈີ່ ໄລ່ ກັອຍ ຕັອກ ຕຳປັອກ ເຍືາມ ຕຸ່ຮ ກະ ກູບຸງ ພຸ່ນ ກູແຕອ໌ ໂຈະ ຕຶ່ງ ຈະ ໄລ່, ຕະ ໂອນ ເນົ່າ ດັງ ປາຍ ໄລ່ ຊັອງ ຕຸ່ຮ ຍ່ອນ ໄລ່ ເບີນ ໂລ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ນ່ະກັອຍ ເກົາ ອາຕີ ເຍືາ, ແຕີ່ອ໌ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ຕັດຊີ່ນ ອຶນແຍ່ະ ມັຮ ກວາຍ, ຕາໄງ ກັອຍ ອັນ ຊັອງ ອາໂຢ່ະ ຕະ ກວາຍ ກາ ແອີດ ຕຶ່ງ ເມືອງ ຕີເຣ ກະ ເມືອງ ຊີໂດນ ກາເລີຍ ແຕ ອັນ ຊັອງ ອາໂຢ່ະ ຕະ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ກະ ເຍືາ ກາ ແອີດ ຕຶ່ງ ເມືອງ ກາເປນາອູມ ເອີຍ! ເຍືາ ຄຶ່ດ ປາຍ ເຍືາ ເຕ່ອ໌ ຊັອຮ ເບີມ ປໍ ມັນລັ່ອງ ບໍ? ໄກຣ ລາລື່ ປັຣແນີ ມັນເຕຣືາ ເຢືາງ ເຈົາຣາຊີ ອາປັອງ ຕັຮ ເຍືາ ຕຶ່ງ ປຣຸ່ງ ອູ່ຍຮ. ຄັນ ເກົາ ມາ ຕະ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ຕຶ່ງ ເມືອງ ໂຊໂດມ ມູເຈິງ ເກົາ ຕະ ຕຶ່ງ ເມືອງ ເຍືາ, ເຈີ່ ເມືອງ ໂຊໂດມ ກັອຍ ອຶນນັ່ອງ ແກີດ ເມືອງ ເຕົ່າ ຊານໍ່. ");
INSERT INTO ncq_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ນ່ະກັອຍ ເກົາ ອາຕີ ເຍືາ, ແຕີ່ອ໌ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ຕັດຊີ່ນ ອຶນແຍ່ະ ມັຮ ກວາຍ, ຕາໄງ ກັອຍ ອັນ ຊັອງ ອາໂຢ່ະ ຕະ ກວາຍ ຕຶ່ງ ເມືອງ ໂຊໂດມ ກາເລີຍ ແຕ ອັນ ຊັອງ ອາໂຢ່ະ ຕະ ເຍືາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ບັອງ ກາ ກັອຍ ເຢຊູ ເກົາແຊອ໌ ປາຍ: \"ອຶມປໍ່ ເອີຍ! ອຶມປໍ່ ລາ ອຶນເຈົາ ມັນລັ່ອງ ກະ ກູແຕອ໌! ເກົາ ຊາແອີນ ໄມ່, ໄມ່ ອາປັຮ ເຈີ່ ຣານະ ໄມ່ ໂອນ ກວາຍ ກາ ນ່ະ ກັຣແນນ ແກດໆ, ໄລ່ ກາ ຕາ ເກີ່ຍ ຣຍານ ອຶນເຕົ່າ. ມາ ໄມ່ ປາໂຕ່ະ ຣານະ ໄນ່ ແຕ ກວາຍ ກາ ຣາໄງ່ອ໌, ໄລ່ ກາ ຣຍານ ຊາອຶ່ຍ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ປຍາຍ໌, ອຶມປໍ່ ເອີຍ, ເກົາ ຍ່ອງ ໄມ່, ຍ່ອນ ຣານະ ກັອຍ ອໍ ຢັ່ຮ ເມືາງ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","ກູ່ ຣາມຶ່ຮ ອຶມປໍ່ ເກົາ ມ່ອບ ໂອນ ເກົາ ເບີນ. ຕາ ເບີນ ກວາຍ ອາແລ່ະ ມາ ດັງ ກູ່ ຣາມຶ່ຮ ແຕ ກອນ ເຢືາງ ເຈົາຣາຊີ. ແອີງ ອຶມປໍ່ ອັນ ແຕິ່ ດັງ ກູ່ ຣາມຶ່ຮ ກັອຍ. ກະ ຕາ ເບີນ ກວາຍ ອາແລ່ະ ດັງ ກູ່ ຣາມຶ່ຮ ແຕ ອຶມປໍ່ ຕຶ່ງ ມັນລັ່ອງ. ແອີງ ກອນ ເຢືາງ ເຈົາຣາຊີ ແຕິ່ ດັງ ກູ່ ຣາມຶ່ຮ ກັອຍ. ກະ ກວາຍ ອາແລ່ະ ກາ ກອນ ເຢືາງ ເຈົາຣາຊີ ຣຽຮ, ອັນ ອາປັຮ ໂອນ ກວາຍ ກັອຍ ດັງ ເຕ່ ແຕ ອຶມປໍ່ ຕຶ່ງ ມັນລັ່ອງ.\" ");
INSERT INTO ncq_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","ແວັດ ເຢຊູ ເກົາແຊອ໌ ນ່ະກັອຍ, ເຈີ່ ອັນ ປາຍ: \"ອຶນແຍ່ະ ມັຮ ເຍືາ ກາ ຊັອງ ລາແກັຮ ລາລື່, ກະ ອຶນແຍ່ະ ມັຮ ເຍືາ ກາ ໂດລ ເກຣີ່ງ ອຶນຕັອງ ເອີຍ! ເຍືາ ແຕີ່ອ໌ ປໍ ເກົາ! ເກົາ ອີ ຕະ ໂອນ ເຍືາ ແກີດ ປຣາຍ ລາແກັຮ. ");
INSERT INTO ncq_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ເກົາ ເບີນ ຣາງຶ່ຮ ມັນຕັ່ດ, ກະ ເກົາ ຕາ ເບີນ ຈໍ່ອ໌ ເນົ່າ ຍ່ອງ ເກົາ. ອຶງເຄາະ ເຍືາ ອີດ ມັຮ ຣານະ ເກົາ ອາຕີ ໂອນ ເຍືາ, ກະ ອຶງເຄາະ ເຍືາ ຣຍານ ແຕ ເກົາ. ນ່ະກັອຍ ຣາເວືາຍ ເຍືາ ເບີນ ແອີດ ອຽນ ອໍ ເລືອຍໆ. ");
INSERT INTO ncq_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ຍ່ອນ ແອກ ອອງ ເກົາ ໂອນ ເຍືາ ໂດລ ລາ ອຽນ, ກະ ປັຣໂດລ ເກົາ ໂອນ ເຍືາ ເດີງ ລາ ອຶງຮາລ.\" ");
INSERT INTO ncq_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ຕຶ່ງ ມວຍ ຕາໄງ ຣາລູ່ ກັອຍ, ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ມູ່ດ ຕຶ່ງ ໄທຣ ເນົ່າ ຈົຮ ທຣໍ. ບັອງ ກາ ໄລ່ ມູ່ດ ຕຶ່ງ ໄທຣ ກັອຍ, ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ຊັອງ ມາເຍືາຍຮ. ນ່ະກັອຍ ບັອງ ໄລ່ ເປາະ, ບັອງ ໄລ່ ກິດ ອີດ ຣາກົ່ງ ໂດຍ ອຶງກຣິ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ພໍກາ ກວາຍ ພາຣີຊາຍ ເຮີມ ນ່ະກັອຍ, ໄລ່ ປາຍ ກະ ເຢຊູ ນ່ະໄນ່: \"ມູ່ ກາ ຣຍານ ແຕ ອາຈານ, ໄລ່ ຕາ ເບີນ ຊາງັດ ຄານອດ ກາ ຕາ ໂອນ ຕະ ຣານະ ຕຶ່ງ ຕາໄງ ຣາລູ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ມາ ເຢຊູ ຕາແອີຍ ລັ່ຮ ໄລ່ ກັອຍ ປາຍ: \"ເຍືາ ຕາ ເກີ່ຍ ອານ ບໍ ຣານະ ດາວິດ ກະ ຈຸ່ມ ອັນ ຕະ, ບັອງ ກາ ໄລ່ ມາເຍືາຍຮ? ");
INSERT INTO ncq_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ດາວິດ ມູ່ດ ຕຶ່ງ ດຸງ ຊາງ ເຢືາງ ເຈົາຣາຊີ. ອັນ ຈາ ໂດຍ ບຸຮ ກາ ກວາຍ ມ່ອບ ໂອນ ເຢືາງ ເຈົາຣາຊີ, ກະ ອັນ ໂອນ ຈຸ່ມ ອັນ ຈາ ເຕ່. ຕາປູ່ນ ຕາມ ຄານອດ ໄຮ ລາ ແອີງ ກວາຍ ຊາງ ຣີ່ດ ຊັອງ ເຕ່ອ໌ ຈາ ໂດຍ ບຸຮ ກັອຍ. ມາ ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ຕິ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ແຕີລາ ເຍືາ ຕາ ເກີ່ຍ ອານ ບໍ ຕຶ່ງ ຄານອດ ໂມເຊ ມັຮ ກວາຍ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ເກີ່ຍ ມູ່ດ ຕະ ຣານະ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ ຕຶ່ງ ຕາໄງ ຣາລູ່? ມາ ຕາ ເບີນ ເນົ່າ ປາຍ ໄລ່ ກັອຍ ຕະ ໂລ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ມາ ເກົາ ອາຕີ ເຍືາ ປາຍ: ແອີດ ອຶນໄນ່ ຊານໍ່ ເບີນ ມານະ ປື່ດ ກາເລີຍ ແຕ ດຸງ ຊາງ ປື່ດ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ, ອັນ ອາຕີ ປາຍ: 'ເກົາ ຢໍອ໌ ອີ ໂອນ ມານະ ຊັອງ ອາໂຢ່ະ ຕະ ໂຈະ ມານະ ກາເລີຍ ແຕ ເກົາ ຢໍອ໌ ອີ ໂອນ ເນົ່າ ມ່ອບ ຊັນຕຣັ່ນ ຊາງ ເກົາ.' ຄັນ ເຍືາ ດັງ ແຈງ ລາລື່ ແຕ ປັຣນາຍ ໄນ່, ເຍືາ ຕາ ເຣືາບ ປາຍ ໄລ່ ກັອຍ ເບີນ ໂລ່ຍຮ ຍ່ອນ ຕະ ຣານະ ຕຶ່ງ ຕາໄງ ຣາລູ່. ");
INSERT INTO ncq_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ເກົາ, ກອນ ເຢືາງ ແກີດ ກວາຍ, ລາ ອຶນເຈົາ ເຕ່ ຕາໄງ ຣາລູ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ເຢຊູ ເປາະ ແຕ ອຶນຕຸ ກັອຍ, ເຈີ່ ອັນ ມູ່ດ ຕຶ່ງ ດຸງ ຊາງ ກວາຍ ອິດຊະຣາເອລ. ");
INSERT INTO ncq_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ແອີດ ອຶງກັອຍ ເບີນ ມານະ ກວາຍ ຣາກຸ ອາຕີ ມັງກັ່ຮ. ມັຮ ກວາຍ ການໍ່ອ໌ ຕຶ່ງ ດຸງ ຊາງ ກັອຍ ຕາແບີບ ເຢຊູ ປາຍ: \"ຕາປູ່ນ ຣີ່ດ ໄຮ, ເຕ່ອ໌ ມາ ຕາ ເບີນ ໄຮ ປົວ ກວາຍ ອາອີ່ ຕຶ່ງ ຕາໄງ ຣາລູ່?\" ກວາຍ ກາ ຕາແບີບ ກັອຍ, ໄລ່ ຈໍ່ອ໌ ຣານະ ໂລ່ຍຮ ແຕ ເຢຊູ ໂອນ ເຕ່ອ໌ ໄລ່ ປ່ອງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ມາ ເຢຊູ ຕາແອີຍ ລັ່ຮ ໄລ່ ປາຍ: \"ຄັນ ເບີນ ມານະ ແຕ ມູ່ ເຍືາ ມາ ເບີນ ແກະ ຊາປິ່ລ ຕຶ່ງ ປຣຸ່ງ ຕຶ່ງ ຕາໄງ ຣາລູ່, ອັນ ອາແຣິ່ ຈ່ອຍ ໂອນ ແກະ ກັອຍ ຊັອຮ ແຕ ປຣຸ່ງ ກັອຍ, ປຍາຍ໌ ມາ ຕາ ເບີນ? ");
INSERT INTO ncq_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ໄກຣ ລາລື່ ເຢືາງ ເຈົາຣາຊີ ປາຊິ ຣາງຶ່ຮ ກວາຍ ກາເລີຍ ແຕ ອັນ ປາຊິ ຣາງຶ່ຮ ແກະ. ຍ່ອນ ນ່ະກັອຍ ເຕ່ອ໌ ໄຮ ມານະ ຈ່ອຍ ມານະ ຕຶ່ງ ຕາໄງ ຣາລູ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ເຈີ່ ເຢຊູ ອາຕີ ອັນ ກາ ຣາກຸ ອາຕີ ກັອຍ ປາຍ: \"ໄມ່ ອາລັ່ອຮ ອາຕີ ໄມ່!\" ກວາຍ ກັອຍ ອາລັ່ອຮ ອາຕີ. ເຈີ່ ອາຕີ ອັນ ແກີດ ແບຣັຮ ແຕິ່. ແກີດ ອໍ ລັ່ຮ ມູເຈິງ ອາຕີ ຢັ່ຮ ມັງກັ່ຮ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ມັຮ ຈຸ່ມ ພາຣີຊາຍ ກັອຍ, ໄລ່ ລັ່ອຮ ແຕ ດຸງ ຊາງ. ເຈີ່ ໄລ່ ຊັຣຮົງ ອີ ກາຈີດ ຕັຮ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ພໍກາ ເຢຊູ ດັງ ໄລ່ ອີ ກາຈີດ ອັນ, ນ່ະກັອຍ ອັນ ລັ່ອຮ ແຕ ອຶນຕຸ ກັອຍ, ກະ ເບີນ ກຼຶ່ງ ກວາຍ ຕາປູ່ນ ກຣັອງ ອັນ. ກະ ເຢຊູ ປົວ ກູ່ ນະ ໄລ່ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ເຢຊູ ປາຕັບ ໄລ່ ອຶນໂຈຍ ໂອນ ກວາຍ ການໍ່ອ໌ ດັງ ອັນ ລາ ເນົ່າ. ");
INSERT INTO ncq_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ອັນ ປາຕັບ ນ່ະກັອຍ ໂອນ ແກີດ ຣາປຍາຍ໌ ມັຮ ປັຣນາຍ ເອຊາຢາ, ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ປາຍ ແຕ ອຶມແບິ ນ່ະໄນ່: ");
INSERT INTO ncq_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","\"ໄນ່ ລາ ກວາຍ ກາ ຕະ ຣານະ ເກົາ, ອັນ ກາ ເກົາ ຣຽຮ ເຈີ່. ເກົາ ອາໂຢ່ະ ລາລື່ ອັນ, ກະ ຣາງຶ່ຮ ເກົາ ຊັອງ ຣໍ່ອ໌ ລາລື່ ກະ ອັນ. ເກົາ ໂອນ ອັນ ເບີນ ຣາເວືາຍ ເກົາ. ກະ ປັຣແນີ ມັນເຕຣືາ ອັນ ອາຕີ ໂອນ ກູ່ ນະ ກວາຍ ດັງ ປາຍ ເກົາ ຕະ ຊັງໄກຣ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ອັນ ຕາ ເບີນ ຣາຈຽນ ກະ ຕາ ເບີນ ປາຍ ເຣ່ງ ໂຈະ ເນົ່າ. ກະ ອັນ ຕາ ເບີນ ໂຍ່ບ ເຣ່ງ ອຶນເຕົ່າ ຕຶ່ງ ເມືອງ. ");
INSERT INTO ncq_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ມັຮ ກວາຍ ລາ ນ່ະ ກັ່ລ ອາຕັອງ ກາ ແຈ່ະ ອີ ຕາແກັ່ຮ ເຈີ່, ມາ ອັນ ຕາ ເບີນ ແດັຮ; ກະ ນ່ະ ຕາກຍາງ ກາ ແຈ່ະ ອີ ປັດ ເຈີ່. ມາ ອັນ ຕາ ເບີນ ອາປັດ. ອັນ ອຶນນັ່ອງ ອາໂຢ່ະ ຕະ ໄລ່ ກັອຍ ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ອັນ ຕັດຊີ່ນ ປຍາຍ໌ ລາລື່ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ອຶນແຍ່ະ ມັຮ ກວາຍ ກູ່ ກຣວາງ ແອີດ ອຶງກ່ອງ ອັນ ກາ ຈ່ອຍ ອາມົ່ງ ໄລ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ແວັດ ກັອຍ ເນົ່າ ເດີງ ແຕີ່ອ໌ ປໍ ເຢຊູ ມານະ ເບີນ ບາຣ ຣາມຶ່ຮ ອາອີ່. ລາ ມັ່ດ ຊູດ ກະ ແກີດ ເກີອ໌, ຍ່ອນ ເຢືາງ ຕາ ອໍ ຕະ ອັນ. ເຢຊູ ປົວ ກວາຍ ອາອີ່ ກັອຍ ໂອນ ມັ່ດ ອັນ ບຣາງ ລັ່ຮ ກະ ໂອນ ອັນ ເຕ່ອ໌ ຕະ ອຶນຕີ ລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ມັຮ ກວາຍ ກຼຶ່ງ ກັອຍ ຊັອງ ງຶ່ດ ລາລື່. ກະ ໄລ່ ຕາແບີບ ປາຍ: \"ປຍາຍ໌ ມາ ຕາ ເບີນ, ເຢຊູ ໄນ່ ລາ ອັນ ກາ ແຕ ຈຸ່ມເຈືອ ເຕືາວ ປັຣເຍືາ ດາວິດ ກາ ໄຮ ອຶງກ່ອງ?\" ");
INSERT INTO ncq_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ພໍກາ ຈຸ່ມ ພາຣີຊາຍ ຊັອງ ກວາຍ ກຼຶ່ງ ກັອຍ ປາຍ ນ່ະກັອຍ, ໄລ່ ປາຍ: \"ອັນ ໄນ່ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ຍ່ອນ ເຢືາງ ເບເອລເຊບູລ ໂອນ ອັນ ເບີນ ອຳນາດ ຕະ ຣານະ ກັອຍ. ເຢືາງ ເບເອລເຊບູລ ໄນ່ ລາ ຊົດ ອຶນແຍ່ະ ເຢືາງ ຕາ ອໍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ເຢຊູ ດັງ ການິ່ດ ໄລ່ ຄຶ່ດ ນ່ະກັອຍ. ເຈີ່ ອັນ ປາຍ ນ່ະໄນ່ ແອັນ ໂຈະ ໄລ່: \"ຄັນ ເບີນ ມວຍ ກຣວາງ ມາ ອຶມແປອ໌ ແກີດ ຊາອຶ່ຍ ຈຸ່ມ ມານະ ຣາຕະ ໂຈະ ມານະ, ເຈີ່ ກຣວາງ ກັອຍ ຕາ ເບີນ ແກີດ ນັ່ອງ ກຣວາງ. ກະ ຄັນ ເບີນ ມວຍ ເມືອງ ແຕີລາ ມວຍ ດຸງ ມາ ມານະ ຣາຕະ ໂຈະ ມານະ, ຕາ ເບີນ ແກີດ ນັ່ອງ ເມືອງ ແຕີລາ ດຸງ. ");
INSERT INTO ncq_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ຄັນ ເຢືາງ ຊາຕານ ມາ ຕູ່ຍຮ ຈຸ່ມ ອັນ ເບີມ, ຈຸ່ມ ກັອຍ ແກີດ ຣາຕັຮ. ເຈີ່ ຕາ ເບີນ ແກີດ ຈຸ່ມ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ເຍືາ ປາຍ ເກົາ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ຍ່ອນ ເຢືາງ ເບເອລເຊບູລ ໂອນ ເກົາ ເບີນ ອຳນາດ ຕະ ຣານະ ກັອຍ. ມາ ຄັນ ກວາຍ ກາ ປວາຍ ເຍືາ ຕະ ຣານະ ມູເຈິງ ກັອຍ ເຕ່, ເຍືາ ຕາ ເບີນ ປາຍ ໄລ່ ເບີນ ອຳນາດ ແຕ ເຢືາງ ເບເອລເຊບູລ. ຍ່ອນ ນ່ະກັອຍ, ໄກຣ ລາລື່ ເບີນ ແຕ ມູ່ ເຍືາ ແຕິ່ ກາ ຕິ ເຍືາ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ມາ ຄັນ ເກົາ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ຍ່ອນ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ໂອນ ເກົາ ຕະ, ຣານະ ໄນ່ ອາປັຮ ໂອນ ເຍືາ ດັງ ປາຍ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ແຕີ່ອ໌ ເຈີ່ ປໍ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","\"ຕາ ເບີນ ອາແລ່ະ ເຕ່ອ໌ ມູ່ດ ປົນ ຕຶ່ງ ດຸງ ກວາຍ ບັນ ເຣ່ງ ຄັນ ຕາ ເບີນ ຊັດ ດໍອ໌ ກວາຍ ກັອຍ ອຶນໂຍ່ງ. ອຶງເຄາະ ຊັດ ດໍອ໌ ກວາຍ ກັອຍ ເວືາຍ ແຕ ເຕ່ອ໌ ມູ່ດ ປົນ ອີດ ເກຣີ່ງ ຕຶ່ງ ດຸງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","\"ກວາຍ ອາແລ່ະ ມາ ຕາ ເບີນ ປຣ່ອມ ມູ ຣາງຶ່ຮ ກະ ເກົາ, ນ່ະ ກວາຍ ກັອຍ ດໍອ໌ ມັ່ດ ກະ ເກົາ. ກະ ກວາຍ ອາແລ່ະ ມາ ຕາ ເບີນ ຕະ ຣານະ ຈ່ອຍ ໂອນ ກວາຍ ການໍ່ອ໌ ແຕີ່ອ໌ ປໍ ເກົາ, ໄນ່ ລາ ມູເຈິງ ກວາຍ ກັອຍ ຕາ ຢໍອ໌ ອີ ໂອນ ກວາຍ ການໍ່ອ໌ ປວາຍ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ນ່ະກັອຍ ເກົາ ອາຕີ ເຍືາ, ກວາຍ ອາແລ່ະ ມາ ເບີນ ໂລ່ຍຮ ອຶນເຕົ່າ, ກະ ກວາຍ ອາແລ່ະ ມາ ພາມາດ ເຢືາງ ເຈົາຣາຊີ, ອຶນແຍ່ະ ຣາມຶ່ຮ ໂລ່ຍຮ ກັອຍ ເຕ່ອ໌ ເຢືາງ ເຈົາຣາຊີ ຕັຮ. ມາ ຄັນ ກວາຍ ອາແລ່ະ ມາ ພາມາດ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ, ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ຕັຮ ນັ່ອງ ໂລ່ຍຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ກວາຍ ອາແລ່ະ ມາ ພາມາດ ເກົາ ກອນ ເຢືາງ ແກີດ ກວາຍ, ເຢືາງ ເຈົາຣາຊີ ເຕ່ອ໌ ຕັຮ ໂລ່ຍຮ ກັອຍ. ມາ ຄັນ ກວາຍ ອາແລ່ະ ມາ ພາມາດ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ, ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ຕັຮ ນັ່ອງ ໂລ່ຍຮ ກັອຍ ແຕ ແດີຍ ໄນ່ ເຕົ່າ ແຕີ່ອ໌ ແດີຍ ອຶນຕູ່ນ.\" ");
INSERT INTO ncq_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","ເຢຊູ ອາຕີ ແອັນ ປາຍ: \"ຄັນ ຢໍອ໌ ອີ ເບີນ ປາໄລ ອໍ, ອຶງເຄາະ ເບີນ ກັ່ລ ອາລ່ອງ ອໍ. ຄັນ ເບີນ ກັ່ລ ຕາ ອໍ, ປາໄລ ອັນ ລາ ຕາ ອໍ ເຕ່. ຄັນ ເຍືາ ເຮີມ ປາໄລ, ເຍືາ ດັງ ກັ່ລ. ");
INSERT INTO ncq_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ເຍືາ ລາ ນ່ະ ກູຊັນ ເບີນ ປີ່ຮ! ນານ່ະ ແຕ ເຍືາ ກວາຍ ຕາ ອໍ ມາ ເຕ່ອ໌ ປາຍ ປັຣນາຍ ອໍ? ຣານະ ອຶນເຕົ່າ ກາ ເບີນ ຕຶ່ງ ຣາງຶ່ຮ ກວາຍ, ແບອ໌ ກວາຍ ກັອຍ ປາຍ ອາລັ່ອຮ. ");
INSERT INTO ncq_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ກວາຍ ມັນຕັ່ດ ອໍ, ອັນ ເບີນ ຣານະ ອໍ ຕຶ່ງ ຣາງຶ່ຮ ອັນ. ນ່ະກັອຍ ຣານະ ອໍ ລັ່ອຮ ແຕ ຣາງຶ່ຮ ກວາຍ ກັອຍ. ກະ ກວາຍ ຕາ ອໍ, ອັນ ເບີນ ຣານະ ຕາ ອໍ ຕຶ່ງ ຣາງຶ່ຮ ອັນ. ນ່ະກັອຍ ຣານະ ຕາ ອໍ ລັ່ອຮ ແຕ ຣາງຶ່ຮ ກວາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ມາ ເກົາ ອາຕີ ເຍືາ ປາຍ: ກວາຍ ກາ ອາຕີ ປັຣນາຍ ຕາ ແກີດ ເກືາ, ເຢືາງ ເຈົາຣາຊີ ຕາແບີບ ກວາຍ ກັອຍ ແຕ ຣານະ ກັອຍ ແຕີ່ອ໌ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ຕັດຊີ່ນ ອຶນແຍ່ະ ມັຮ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ຍ່ອນ ນ່ະກັອຍ, ເຢືາງ ເຈົາຣາຊີ ຕັດຊີ່ນ ເຍືາ ມັຮ ປັຣນາຍ ເຍືາ ປາຍ. ຄັນ ເຍືາ ປາຍ ປັຣນາຍ ອໍ, ອັນ ດັງ ເຍືາ ລາ ກວາຍ ຕານັ່ອງ ອໍ. ມາ ຄັນ ເຍືາ ປາຍ ປັຣນາຍ ຕາ ອໍ, ອັນ ດັງ ປາຍ ເຍືາ ລາ ກວາຍ ຕາ ເບີນ ອໍ ກະ ອັນ ໂຈະ ໂຕ່ດ ເຍືາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ແວັດ ກັອຍ, ເບີນ ກວາຍ ອາຕີ ຄານອດ ກະ ກວາຍ ແຕ ຈຸ່ມ ພາຣີຊາຍ, ໄລ່ ແຊອ໌ ແຕ ເຢຊູ ປາຍ: \"ອາຈານ ເອີຍ! ຮິ ຢໍອ໌ ອີ ເຮີມ ອາຈານ ຕະ ຣານະ ຕາ ເກີ່ຍ ເຮີມ.\" ");
INSERT INTO ncq_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ມາ ເຢຊູ ຕາແອີຍ ລັ່ຮ ໄລ່ ປາຍ: \"ກວາຍ ຕຶ່ງ ແດີຍ ໄນ່ ລາ ຕາ ອໍ ລາລື່, ກະ ໄລ່ ຕາ ຢໍອ໌ ອີ ຊາງ ນັ່ອງ ເຢືາງ ເຈົາຣາຊີ. ເຍືາ ແຊອ໌ ແຕ ເກົາ ມວຍ ຣາມຶ່ຮ ຕາ ເກີ່ຍ ເຮີມ, ມາ ເກົາ ຕາ ເບີນ ຕະ ໂອນ ເຍືາ. ເຍືາ ເບີນ ເຈີ່ ຣາມຶ່ຮ ຕາ ເກີ່ຍ ເຮີມ ແຕ ໂຢນາ, ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ. ");
INSERT INTO ncq_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ໂຢນາ ໄນ່, ອັນ ແອີດ ຕຶ່ງ ປຸ່ງ ອາກາ ປື່ດ ເບີນ ໄປ ຕາໄງ ໄປ ຊາເດົາ. ມູເຈິງ ກັອຍ ເຕ່ ເກົາ ກອນ ເຢືາງ ແກີດ ກວາຍ ແອີດ ຕຶ່ງ ປີ່ງ ກູມູ່ຍ໌ ຕຶ່ງ ກູແຕອ໌ ເບີນ ໄປ ຕາໄງ ໄປ ຊາເດົາ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ແຕີ່ອ໌ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ຕັດຊີ່ນ ອຶນແຍ່ະ ມັຮ ກວາຍ, ກວາຍ ແຕ ເມືອງ ນີນາເວ ແຕ ອຶມແບິ ລາລື່ ຕິ ກວາຍ ແອີດ ຕຶ່ງ ແດີຍ ໄນ່. ໄລ່ ເຕ່ອ໌ ຕິ ນ່ະກັອຍ, ລາ ຍ່ອນ ບັອງ ກາ ໄລ່ ຊັອງ ປັຣນາຍ ໂຢນາ ອາຕີ, ໄລ່ ຕັຮ ຣາງຶ່ຮ ຕຍາ ເຈີ່ ອີດ ຣາງຶ່ຮ ຕາໄມ ແອັນ. ມາ ຊານໍ່, ແອີດ ອຶນໄນ່ ເບີນ ມານະ ປື່ດ ກາເລີຍ ແຕ ໂຢນາ ມາ ເຍືາ ຕາ ເບີນ ຊາງັດ ອັນ! ");
INSERT INTO ncq_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ແຕີ່ອ໌ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ຕັດຊີ່ນ ອຶນແຍ່ະ ມັຮ ກວາຍ, ເບີນ ມັນແຊມ ກາ ແກີດ ເຕືາວ ປັຣເຍືາ ແຕ ອຶມແບິ, ຕຶ່ງ ກຣວາງ ເຊບາ, ອັນ ຕິ ກວາຍ ແອີດ ຕຶ່ງ ແດີຍ ໄນ່. ອັນ ເຕ່ອ໌ ຕິ ນ່ະກັອຍ, ຍ່ອນ ອັນ ແຕີ່ອ໌ ແຕ ກຣວາງ ເຢີ່ງ ລາລື່ ຢໍອ໌ ອີ ຊາງັດ ປັຣນາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ແຕ ເຕືາວ ປັຣເຍືາ ໂຊໂລໂມນ ອາຕີ. ມາ ຊານໍ່, ແອີດ ອຶນໄນ່ ເບີນ ມານະ ຣາໄງ່ອ໌ ຣາລັ່ງ ກາເລີຍ ແຕ ໂຊໂລໂມນ ແອັນ ມາ ເຍືາ ຕາ ເບີນ ຊາງັດ ອັນ! ");
INSERT INTO ncq_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","\"ພໍກາ ເຢືາງ ຕາ ອໍ ລັ່ອຮ ແຕ ຈະ ກວາຍ, ເຈີ່ ເຢືາງ ຕາ ອໍ ກັອຍ ເປາະ ຕຶ່ງ ອຶນຕຸ ຊາແອີດ. ອັນ ຈໍ່ອ໌ ອຶນຕຸ ອີ ຣາລູ່, ມາ ອັນ ຕາ ເບີນ ຣາມົຮ. ");
INSERT INTO ncq_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ເຈີ່ ອັນ ຄຶ່ດ ປາຍ: 'ເກົາ ເຈົາ ລັ່ຮ ປໍ ອຶນຕຸ ກາ ເກົາ ລັ່ອຮ ແຕ ອຶນໂຍ່ງ ຊາ.' ພໍກາ ອັນ ເຈົາ ປໍ ອຶນຕຸ ກັອຍ, ອັນ ເຮີມ ແອີງ ອຶນຕຸ ເມືາດ ຊັອງ. ອຶນຕຸ ກັອຍ ຊຽລ ອໍ, ກະ ເກຣີ່ງ ອຶນເຕົ່າ ຕຶ່ງ ອຶນຕຸ ກັອຍ ອາຕຶ່ ອໍ ອຶນແຍ່ະ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ເຈີ່ ອັນ ເປາະ ອີດ ເດີງ ອາເຈົາ ຕາປູ່ລ ນະ ເຢືາງ ຕາ ອໍ ການໍ່ອ໌ ແອັນ ໂອນ ແອີດ ກະ ອັນ ຕຶ່ງ ອຶນຕຸ ກັອຍ. ໄລ່ ລາ ຕາ ອໍ ກາເລີຍ ແຕ ອັນ ແອັນ. ນ່ະກັອຍ ແດີຍ ອາມົ່ງ ກວາຍ ກັອຍ ຕາ ອໍ ກາເລີຍ ແຕ ອຶນໂຍ່ງ ແອັນ. ໄກຣ ລາລື່ ແດີຍ ຕາ ອໍ ໄນ່ ລາ ມູເຈິງ ກັອຍ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ບັອງ ກາ ເຢຊູ ອຶນນັ່ອງ ຕະ ອຶນຕີ ກະ ມັຮ ກວາຍ ກຼຶ່ງ ກັອຍ, ເບີນ ອຶມເປ່ອ໌ ກະ ແຊມອາຍ ອັນ ແອີດ ຕາຢຶ່ງ ຢັ່ຮ ນໍ່ອ໌. ໄລ່ ຢໍອ໌ ອີ ຕະ ອຶນຕີ ກະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ເບີນ ມານະ ກວາຍ ການໍ່ອ໌ ອາຕີ ເຢຊູ ປາຍ: \"ອຶມເປ່ອ໌ ກະ ແຊມອາຍ ອາຈານ ແອີດ ຢັ່ຮ ນໍ່ອ໌. ໄລ່ ຢໍອ໌ ອີ ຕະ ອຶນຕີ ກະ ອາຈານ.\" ");
INSERT INTO ncq_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ມາ ເຢຊູ ຕາແບີບ ປາຍ: \"ເນົ່າ ແກີດ ອຶມເປ່ອ໌ ເກົາ, ກະ ເນົ່າ ແກີດ ແຊມອາຍ ເກົາ?\" ");
INSERT INTO ncq_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ເຈີ່ ເຢຊູ ຊາດອຍ ອາຕີ ອັນ ໂຈະ ໄລ່ ກາ ຣຍານ ແຕ ອັນ, ກະ ອັນ ປາຍ: \"ໄນ່ ລາ ອຶມເປ່ອ໌ ກະ ແຊມອາຍ ເກົາ! ");
INSERT INTO ncq_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ອາແລ່ະ ລາ ໂທຍ ກາ ຊາງັດ ກະ ຕະ ປວາຍ ຣານະ ອຶມປໍ່ ເກົາ ຕຶ່ງ ມັນລັ່ອງ, ໄລ່ ກັອຍ ແກີດ ແຊມອາຍ ແຊມແອີຍ ກະ ອຶມເປ່ອ໌ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ຕາໄງ ກັອຍ ເຢຊູ ລັ່ອຮ ແຕ ດຸງ, ເຈີ່ ເປາະ ຕາກູ ຕຶ່ງ ປຶ່ຮ ທາເລ ຣາປັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ເບີນ ກຼຶ່ງ ກວາຍ ແອີດ ໂຣ່ມ ອຶມແປຣ ອັນ. ນ່ະກັອຍ ອັນ ຊັອຮ ຕາກູ ຕຶ່ງ ຕົວະ. ມາ ມັຮ ກວາຍ ກຼຶ່ງ ກັອຍ, ໄລ່ ອຶນນັ່ອງ ແອີດ ຕາຢຶ່ງ ຕຶ່ງ ປຶ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ເຈີ່ ເຢຊູ ອາຕີ ມັຮ ກວາຍ ກຼຶ່ງ ກັອຍ ຊາອຶ່ຍ ຣາມຶ່ຮ ແຕ ປັຣນາຍ ຊາກຳ. ອັນ ອາຕີ ປາຍ: \"ເບີນ ມານະ ກວາຍ ເປາະ ຕຣຶ່ຮ ກູປຼູອ໌. ");
INSERT INTO ncq_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ບັອງ ກາ ອັນ ຕຣຶ່ຮ, ເບີນ ກຼອງ ຊາແລັຮ ຕຶ່ງ ຣານາ. ເຈີ່ ແຈມ ແຊງ ຕອດ ຈາ ກຼອງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ເບີນ ກຼອງ ການໍ່ອ໌ ຊາແລັຮ ຕຶ່ງ ກູແຕອ໌ ກາດາ, ປື່ນ ກູແຕອ໌ ເບີນ ແອີງ ຕາຕາຣ. ເຈີ່ ໄວ່ ລາລື່ ກຼອງ ກັອຍ ດັຮ, ຍ່ອນ ກູແຕອ໌ ກັອຍ ຕາ ເບີນ ອຶນຕຣູ່. ");
INSERT INTO ncq_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ມາ ແຕີ່ອ໌ ມັ່ດ ມານາງ ລັ່ອຮ ພວາອ໌ ເຣ່ງ ລາລື່, ຊັຣນົຮ ກັອຍ ແກີດ ຣັ່ອຮ, ຍ່ອນ ເຣ່ຮ ອັນ ຕາ ເບີນ ອຶນຕຣູ່. ອັນ ຣັ່ອຮ, ເຈີ່ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ເບີນ ກຼອງ ການໍ່ອ໌ ຊາແລັຮ ຕຶ່ງ ກູແຕອ໌ ກາ ເບີນ ເຣ່ຮ ຊັຣເລືາ. ພໍກາ ຊັຣເລືາ ກັອຍ ດັຮ, ອັນ ຣິ່ ດໍອ໌ ຊັຣນົຮ ກາ ຕາແບິ ດັຮ ແຕ ກຼອງ ກວາຍ ກັອຍ ຕຣຶ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ກະ ເບີນ ກຼອງ ການໍ່ອ໌ ແອັນ ຊາແລັຮ ຕຶ່ງ ກູແຕອ໌ ອໍ. ກຼອງ ກັອຍ ດັຮ ອໍ, ກັ່ລ ອັນ ແກີດ ປາໄລ ອໍ. ມວຍ ກຼອງ ແກີດ ປາໄລ ມວຍ ຣ່ອຍ. ມວຍ ກຼອງ ແກີດ ປາໄລ ຕາປັ່ດ ຈິ່ດ. ກະ ມວຍ ກຼອງ ແອັນ ແກີດ ປາໄລ ໄປ ຈິ່ດ. ");
INSERT INTO ncq_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ອາແລ່ະ ເບີນ ກູຕູຣ, ໂອນ ອັນ ຊາງັດ ເບີມ.\" ");
INSERT INTO ncq_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ແຕີ່ອ໌ ປໍ ອັນ ກະ ຕາແບີບ ອັນ ປາຍ: \"ຍ່ອນ ນານ່ະ ອາຈານ ອາຕີ ແຕ ປັຣນາຍ ຊາກຳ ໂຈະ ມັຮ ກວາຍ ກັອຍ?\" ");
INSERT INTO ncq_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ເຢຊູ ຕາແອີຍ ປາຍ: \"ເຢືາງ ເຈົາຣາຊີ ໂອນ ເຍືາ ດັງ ມັຮ ປັຣນາຍ ປາໂຕ່ະ ແຕ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ, ມາ ອັນ ຕາ ເບີນ ໂອນ ໄລ່ ກັອຍ ດັງ. ");
INSERT INTO ncq_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ກວາຍ ອາແລ່ະ ກາ ເບີນ ເຈີ່, ເກົາ ຈ່ອຍ ໂອນ ກວາຍ ກັອຍ ແຮງ ເບີນ ຊາອຶ່ຍ ລາລື່ ແອັນ. ມາ ກວາຍ ອາແລ່ະ ກາ ຕາ ເບີນ ເບີນ, ແຮງ ເກົາ ອີດ ລັ່ຮ ອຶນແຍ່ະ ແຕ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ຍ່ອນ ນ່ະກັອຍ ແຕ ເກົາ ອາຕີ ແຕ ປັຣນາຍ ຊາກຳ ໂຈະ ມັຮ ກວາຍ ກັອຍ, ລາ ຍ່ອນ ໄລ່ ເນ່ ມາ ໄລ່ ຕາ ເບີນ ເຮີມ, ໄລ່ ຊາງັດ ມາ ໄລ່ ຕາ ເບີນ ຊັອງ, ກະ ໄລ່ ຕາ ເບີນ ຊາປຸ່ຮ ອຶນເຕົ່າ ເລີ່ຍ. ");
INSERT INTO ncq_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ນ່ະກັອຍ, ຍ່ອນ ແຕ ໄລ່ ກັອຍ ແກີດ ຣາປຍາຍ໌ ກະ ປັຣນາຍ ເອຊາຢາ, ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ປາຍ ດໍອ໌: 'ເຍືາ ຊັອງ ເລືອຍໆ, ມາ ເຍືາ ຕາ ເບີນ ຊາປຸ່ຮ. ກະ ເຍືາ ເນ່ ເລືອຍໆ, ມາ ເຍືາ ຕາ ເບີນ ເຮີມ ອຶນເຕົ່າ ເລີ່ຍ. ");
INSERT INTO ncq_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ຍ່ອນ ອຶນແຍ່ະ ມັຮ ກວາຍ ເບີນ ຣາງຶ່ຮ ກັ່ອງ, ນ່ະກັອຍ ໄລ່ ກູປັດ ກູຕູຣ, ຕາ ແອອ໌ ອີ ຊັອງ. ກະ ໄລ່ ກາແຍດ ມັ່ດ, ຕາ ແອອ໌ ອີ ເຮີມ. ຄັນ ມັ່ດ ໄລ່ ມາ ເຮີມ, ກູຕູຣ ໄລ່ ມາ ຊັອງ, ກະ ຣາງຶ່ຮ ໄລ່ ມາ ດັງ, ອຶງກັອຮ ປຍາຍ໌ ໄລ່ ອີ ລົ່ບ ລັ່ຮ ປຽນ ແກີດ ຣາງຶ່ຮ ຕາໄມ ແອັນ, ໂອນ ເຕ່ອ໌ ເກົາ ປົວ ໂອນ ໄລ່.' ");
INSERT INTO ncq_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","\"ມາ ເຍືາ, ເຍືາ ເບີນ ບຸ່ນ ຊາອຶ່ຍ. ເຍືາ ເບີນ ມັ່ດ ກາ ເຕ່ອ໌ ເຮີມ. ກະ ເຍືາ ເບີນ ກູຕູຣ ກາ ເຕ່ອ໌ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ເບີນ ຊາອຶ່ຍ ນະ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ, ກະ ເບີນ ກຼຶ່ງ ກວາຍ ການໍ່ອ໌ ຕານັ່ອງ ອໍ ເຕ່, ອຶນແຍ່ະ ມັຮ ໄລ່ ກັອຍ ຢໍອ໌ ອີ ເຮີມ ມັຮ ຣານະ ເຍືາ ເຮີມ ຊານໍ່, ມາ ໄລ່ ຕາ ດັງ ເບີນ ເຮີມ. ກະ ໄລ່ ກັອຍ ຢໍອ໌ ອີ ຊັອງ ມັຮ ປັຣນາຍ ເຍືາ ຊັອງ ຊານໍ່, ມາ ໄລ່ ຕາ ດັງ ເບີນ ຊັອງ.\" ");
INSERT INTO ncq_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","\"ນ່ະກັອຍ, ເຍືາ ຊາງັດ ໂອນ ກຣັ່ກ ມັຮ ຣາມຶ່ຮ ປັຣນາຍ ຊາກຳ ແຕ ມານະ ຕຣຶ່ຮ ກູປຼູອ໌ ລາ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ເບີນ ກວາຍ ກາ ຊັອງ ປັຣນາຍ ອໍ ແຕ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ, ມາ ອັນ ຕາ ເບີນ ຊາປຸ່ຮ ກະ ອັນ ຕາ ເບີນ ຊາງັດ ອຶນເຕົ່າ. ເຈີ່ ເຢືາງ ຊາຕານ ແຕີ່ອ໌ ປົນ ອີດ ປັຣນາຍ ອໍ ແຕ ຣາງຶ່ຮ ກວາຍ ກັອຍ. ກວາຍ ກັອຍ ນ່ະ ກູແຕອ໌ ກາ ເນົ່າ ຊາເຕືາຍ໌ ຕຶ່ງ ຣານາ. ກຼອງ ກັອຍ ຊາແລັຮ, ມາ ອັນ ຕາ ເບີນ ດັຮ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ເບີນ ກວາຍ ການໍ່ອ໌ ນ່ະ ກູແຕອ໌ ກາດາ ເບີນ ຕາຕາຣ ປື່ນ ກູແຕອ໌. ພໍກາ ເນົ່າ ອາຕີ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ອັນ ຊັອງ ປັຣນາຍ ກັອຍ. ໄວ່ ລາລື່ ອັນ ອີດ ກະ ປຣ່ອມ ຊາອຳ ປັຣນາຍ ກັອຍ ຣໍ່ອ໌ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ມາ ອັນ ກັອຍ ຕາ ເບີນ ແກີດ ເຣ່ຮ ອຶນຕຣູ່. ນ່ະກັອຍ ອັນ ເບີນ ອາມົ່ງ ມາໂຮຍ ຊັອງ. ຄັນ ເບີນ ຕຸ່ຮ ກັ່ດ ແຕີ່ອ໌ ປໍ ອັນ ຍ່ອນ ອັນ ຊາອຳ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ອັນ ຕາ ເບີນ ຊາອຳ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ເບີນ ກວາຍ ການໍ່ອ໌ ນ່ະ ກູແຕອ໌ ກາ ເບີນ ຊັຣເລືາ. ພໍກາ ເນົ່າ ອາຕີ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ອັນ ຊັອງ ປັຣນາຍ ກັອຍ. ມາ ຣາງຶ່ຮ ອັນ ແອີດ ຣາບູລ ຣານະ ຕຶ່ງ ແດີຍ ໄນ່, ກະ ອັນ ຢໍອ໌ ອີ ຊຸ ເບີນ. ມັຮ ຣາມຶ່ຮ ກັອຍ ຣິ່ ດໍອ໌ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ໂອນ ຕາ ເບີນ ແກີດ ປາໄລ. ");
INSERT INTO ncq_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ມາ ເບີນ ກວາຍ ການໍ່ອ໌ ນ່ະ ກູແຕອ໌ ອໍ. ພໍກາ ເນົ່າ ອາຕີ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ອັນ ກັອຍ ຊາງັດ ປັຣນາຍ ກັອຍ ກະ ອັນ ດັງ ແຈງ ລາລື່. ອັນ ກັອຍ ແກີດ ປາໄລ. ອັນ ກາ ແກີດ ປາໄລ ມວຍ ຣ່ອຍ. ອັນ ກາ ແກີດ ປາໄລ ຕາປັ່ດ ຈິ່ດ, ກະ ອັນ ກາ ແກີດ ປາໄລ ໄປ ຈິ່ດ.\" ");
INSERT INTO ncq_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ເຢຊູ ອາຕີ ແຕ ປັຣນາຍ ຊາກຳ ແອັນ ໂຈະ ໄລ່ ກັອຍ ປາຍ: \"ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ຕຶ່ງ ຣາງຶ່ຮ ກວາຍ ລາ ນ່ະ ມານະ ຈັ່ດ ທຣໍ ອໍ ຕຶ່ງ ໄທຣ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ມາ ເບີນ ມວຍ ຊາເດົາ, ບັອງ ກາ ອຶນແຍ່ະ ມັຮ ກວາຍ ບິ, ມານະ ກາ ຊັອງ ອວານ ກະ ອັນ ກາ ຕາລາ ໄທຣ ກັອຍ, ອັນ ມູ່ດ ຕຣຶ່ຮ ກຼອງ ໂດຍ ຕາປັຣ ຕຶ່ງ ໄທຣ ກັອຍ. ແວັດ ອັນ ຕຣຶ່ຮ ກຼອງ ກັອຍ, ເຈີ່ ອັນ ລັ່ອຮ ແຕ ໄທຣ. ");
INSERT INTO ncq_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ແຕີ່ອ໌ ກັ່ລ ທຣໍ ກັອຍ ດັຮ ກະ ປັຣລຶ່ມ, ກຼອງ ໂດຍ ຕາປັຣ ກັອຍ ດັຮ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ນ່ະກັອຍ ກວາຍ ກາ ຕະ ຣານະ ໂອນ ອຶນເຈົາ ກັອຍ, ໄລ່ ແຕີ່ອ໌ ປໍ ອຶນເຈົາ ກະ ປາຍ: 'ອຶນເຈົາ ເອີຍ! ປຍາຍ໌ ມາ ຕາ ເບີນ, ອຶນເຈົາ ຈັ່ດ ແອີງ ກຼອງ ທຣໍ ຊັອງ ຕຶ່ງ ໄທຣ ອຶນເຈົາ? ຄັນ ນ່ະກັອຍ, ແຕ ແລ່ະ ໂດຍ ຕາປັຣ ໄນ່ ແຕີ່ອ໌?' ");
INSERT INTO ncq_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ອຶນເຈົາ ຕາແອີຍ ລັ່ຮ ປາຍ: 'ເບີນ ມານະ ກາ ຊັອງ ອວານ ກະ ເກົາ ຕະ ຣານະ ກັອຍ.' \"ໄລ່ ກາ ຕະ ຣານະ ອຶນເຈົາ ກັອຍ ຕາແບີບ ລັ່ຮ ປາຍ: 'ອຶນເຈົາ ຢໍອ໌ ອີ ໂອນ ຮິ ເປາະ ເຣີ່ອ໌ ຕັຮ ກັ່ລ ໂດຍ ຕາປັຣ ກັອຍ ບໍ?' ");
INSERT INTO ncq_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","\"ອຶນເຈົາ ກັອຍ ຕາແອີຍ ລັ່ຮ ປາຍ: 'ຕາ ເບີນ. ເກົາ ອຶງກັອຮ ບັອງ ກາ ເຍືາ ເຣີ່ອ໌ ກັ່ລ ໂດຍ ຕາປັຣ ກັອຍ, ເຍືາ ເຣີ່ອ໌ ກາ ກັ່ລ ໂດຍ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ໄຮ ດໍອ໌ ກັ່ລ ໂດຍ ກະ ກັ່ລ ໂດຍ ຕາປັຣ ກັອຍ ດັຮ ມັນຕຸ ເວືາຍ ໂອນ ເຕົ່າ ແຕີ່ອ໌ ປາເນ່ນ ຕາໄງ ໄຮ ຊອດ. ແຕີ່ອ໌ ຕາໄງ ກັອຍ, ເກົາ ແປຣີ ໄລ່ ກາ ຈ່ອຍ ຊອດ ໂດຍ ໂອນ ເຣີ່ອ໌ ຕັຮ ກັ່ລ ໂດຍ ຕາປັຣ ເວືາຍ. ເຈີ່ ໄລ່ ປາໂຣມ ມັຮ ກັ່ລ ກັອຍ, ກະ ອາປັອງ ຕັຮ ຕຶ່ງ ອູ່ຍຮ. ແວັດ ກັອຍ, ໄລ່ ຊອດ ໂດຍ ໄລ່ ໂຈະ ຕຶ່ງ ຊູ.'\" ");
INSERT INTO ncq_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ເຢຊູ ອາຕີ ແຕ ປັຣນາຍ ຊາກຳ ແອັນ ໂຈະ ໄລ່ ກັອຍ ປາຍ: \"ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ຕຶ່ງ ຣາງຶ່ຮ ກວາຍ ລາ ນ່ະ ມວຍ ກຼອງ ປາກາດ. ເບີນ ກວາຍ ອີດ ກຼອງ ໄນ່ ຕຣຶ່ຮ ຕຶ່ງ ຊວນ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ກຼອງ ກັອຍ ລາ ແກດໆ ກາເລີຍ ອຶນແຍ່ະ ແຕ ກຼອງ ການໍ່ອ໌. ມາ ແຕີ່ອ໌ ອັນ ດັຮ, ອັນ ປື່ດ ກາເລີຍ ແຕ ມັຮ ບັດ ການໍ່ອ໌. ອັນ ແກີດ ນ່ະ ອາລ່ອງ, ໂອນ ເຕ່ອ໌ ແຈມ ຕະ ຊົຮ ຕຶ່ງ ອາແບງ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ເຢຊູ ອາຕີ ມວຍ ປັຣນາຍ ຊາກຳ ແອັນ ໂຈະ ໄລ່ ກັອຍ ປາຍ: \"ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ຕຶ່ງ ຣາງຶ່ຮ ກວາຍ ລາ ນ່ະ ບວຮ ຊື່ອ໌. ເບີນ ມັນແຊມ ອີດ ບີ່ອ໌ ເກຣີ່ງ ກັອຍ; ເຈີ່ ອັນ ເປຍ ໂຈະ ແປງ ຕຶ່ງ ອາແດັຮ ປື່ດ. ເຈີ່ ແປງ ກັອຍ ແກີດ ຊື່ອ໌ ອາຊັອຮ ອຶນແຍ່ະ.\" ");
INSERT INTO ncq_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ເຢຊູ ອາຕີ ກູ່ ຣາມຶ່ຮ ໄນ່ ແຕ ປັຣນາຍ ຊາກຳ ໂຈະ ກວາຍ ກຼຶ່ງ ກັອຍ. ອັນ ຕາ ເບີນ ອາຕີ ໄລ່ ອຶນເຕົ່າ ມາ ຕາ ເບີນ ປາຍ ແຕ ປັຣນາຍ ຊາກຳ. ");
INSERT INTO ncq_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ອັນ ຕະ ນ່ະກັອຍ ໂອນ ແກີດ ຣາປຍາຍ໌ ກະ ປັຣນາຍ ມານະ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ ປາຍ ແຕ ເຢຊູ ນ່ະໄນ່: \"ບັອງ ກາ ເກົາ ຕະ ອຶນຕີ ກະ ໄລ່, ເກົາ ອາຕີ ແຕ ປັຣນາຍ ຊາກຳ. ແຕ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ແຕງ ມັນລັ່ອງ ກະ ກູແຕອ໌, ອັນ ປາໂຕ່ະ ມັຮ ປັຣນາຍ ເກົາ ອາຕີ ໄລ່ ຊານໍ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ແວັດ ກັອຍ ເຢຊູ ໂອນ ກວາຍ ກຼຶ່ງ ກັອຍ ເຈົາ; ເຈີ່ ອັນ ມູ່ດ ຕຶ່ງ ດຸງ. ມູ່ ກາ ຣຍານ ແຕ ອັນ ແຕີ່ອ໌ ແຊອ໌ ແຕ ອັນ ປາຍ: \"ອາຈານ ເອີຍ! ຮິ ແຊອ໌ ອາຈານ ອາຕີ ໂອນ ຮິ ດັງ ແຕ ປັຣນາຍ ຊາກຳ ທຣໍ ກະ ໂດຍ ຕາປັຣ.\" ");
INSERT INTO ncq_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ອັນ ກາ ຈັ່ດ ທຣໍ ອໍ ກັອຍ ລາ ກອນ ເຢືາງ ແກີດ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ໄທຣ ກັອຍ ລາ ກູ່ ກຣວາງ ຕຶ່ງ ກູແຕອ໌ ໄນ່. ກຼອງ ອໍ ກັອຍ ລາ ອຶນແຍ່ະ ມັຮ ກວາຍ ກາ ແກີດ ກອນ ອາໄກ ເຢືາງ ເຈົາຣາຊີ. ໂດຍ ຕາປັຣ ກັອຍ ລາ ອຶນແຍ່ະ ມັຮ ກວາຍ ກາ ແກີດ ກອນ ອາໄກ ເຢືາງ ຊາຕານ. ");
INSERT INTO ncq_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ອັນ ກາ ຕຣຶ່ຮ ໂດຍ ຕາປັຣ ກັອຍ ລາ ເຢືາງ ຊາຕານ. ອັນ ກັອຍ ອວານ ກະ ອຶນເຈົາ ໄທຣ ກັອຍ. ປາເນ່ນ ຊອດ ທຣໍ ກັອຍ ລາ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ຕັດຊີ່ນ ອຶນແຍ່ະ ມັຮ ກວາຍ. ກະ ໄລ່ ກາ ຈ່ອຍ ຊອດ ທຣໍ ກັອຍ ລາ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ໄລ່ ກັອຍ ເຣີ່ອ໌ ກະ ປາໂຣມ ໂດຍ ຕາປັຣ ກັອຍ ອາປັອງ ຕັຮ ຕຶ່ງ ອູ່ຍຮ. ມູເຈິງ ກັອຍ ເຕ່ ເຢືາງ ເຈົາຣາຊີ ຕະ ກະ ກວາຍ ຕຶ່ງ ຕາໄງ ອັນ ຕັດຊີ່ນ ອຶນແຍ່ະ ມັຮ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ກອນ ເຢືາງ ແກີດ ກວາຍ, ອັນ ແປຣີ ເທວາດາ ອັນ ເປາະ ອຶນແຍ່ະ ກູ່ ອຶນຕຸ ອັນ ຊົດ, ເຈີ່ ປາໂຣມ ກູ່ ນະ ກວາຍ ກາ ຕະ ໂລ່ຍຮ ກະ ກູ່ ນະ ກວາຍ ກາ ອາໂຢ່ງ ກວາຍ ການໍ່ອ໌ ຕະ ໂລ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ເຈີ່ ເທວາດາ ກັອຍ ອາປັອງ ຕັຮ ມັຮ ກວາຍ ເບີນ ໂລ່ຍຮ ຕຶ່ງ ປຣຸ່ງ ອູ່ຍຮ. ອຶນຕຸ ກັອຍ ໄລ່ ຈີວ໌ ໂຕຍ໌ ບາບ ລາລື່. ໄລ່ ເຍືາມ ກູໂກຼຍ໌ ກະ ໄລ່ ກາເຕຣືອກ ກາແນງ ກາບາງ ຊັອງ ຕຸ່ຮ ກັ່ດ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ເຈີ່ ບັອງ ກາ ກັອຍ ມັຮ ກວາຍ ກາ ຕານັ່ອງ ອໍ ເບີນ ແອີດ ຕຶ່ງ ອຶນຕຸ ອຶມປໍ່ ໄລ່ ຊົດ ຕຶ່ງ ມັນລັ່ອງ. ໄລ່ ແກີດ ນ່ະ ມັ່ດ ມານາງ ປາເລືາງ ຕຶ່ງ ອຶນຕຸ ກັອຍ. ອາແລ່ະ ເບີນ ກູຕູຣ, ໂອນ ອັນ ຊາງັດ ເບີມ.\" ");
INSERT INTO ncq_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","\"ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ຕຶ່ງ ຣາງຶ່ຮ ກວາຍ ລາ ນ່ະ ເນົ່າ ແຕິບ ເກຣີ່ງ ເປ່ງ ຕຶ່ງ ກູແຕອ໌. ພໍກາ ກວາຍ ການໍ່ອ໌ ຣາມົຮ ເກຣີ່ງ ກັອຍ, ອັນ ກູບິລ ໂອນ ແກຣ່ະ ລັ່ຮ ເກຣີ່ງ ກັອຍ. ເຈີ່ ອັນ ເຈົາ ຈິ ອຶນແຍ່ະ ມັຮ ເກຣີ່ງ ແຕ ດຸງ ອັນ. ກະ ອັນ ເປາະ ແຈີງ ອຶນຕຸ ກູແຕອ໌ ກັອຍ ແອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","\"ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ຕຶ່ງ ຣາງຶ່ຮ ກວາຍ ລາ ນ່ະ ມານະ ຈໍ່ອ໌ ຢໍອ໌ ອີ ແຈີງ ຈຸ່ ຕຍາ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ແຕີ່ອ໌ ອັນ ຣາມົຮ ມວຍ ກຼອງ ຈຸ່ ອໍ ກາເລີຍ ແຕ ການໍ່ອ໌, ເຈີ່ ອັນ ເປາະ ຈິ ອຶນແຍ່ະ ມັຮ ມູ່ນ ອັນ ເບີນ. ແວັດ ກັອຍ ອັນ ແຈີງ ກຼອງ ຈຸ່ ຕຍາ ອໍ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","\"ກະ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ຕຶ່ງ ຣາງຶ່ຮ ກວາຍ ລາ ນ່ະ ມ່ອງ ຕໍ ອາກາ ເນົ່າ ຕິງ ຕຶ່ງ ແດີອ໌. ກູ່ ຣາມຶ່ຮ ອາກາ ໄກຣ ຕຶ່ງ ມ່ອງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ພໍກາ ອາກາ ໄກຣ ປັ່ນ ມ່ອງ, ກວາຍ ກາ ຈໍ່ອ໌ ອາກາ ກັອຍ, ໄລ່ ຮອຣ ອາຊັອຮ ມ່ອງ ຕຶ່ງ ປຶ່ຮ. ເຈີ່ ໄລ່ ຕາກູ ຣຽຮ ອາກາ. ອາກາ ອໍ, ໄລ່ ໂຈະ ຕຶ່ງ ກາເຣຍ. ອາກາ ຕາ ອໍ, ໄລ່ ຕັຮ. ");
INSERT INTO ncq_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ແຕີ່ອ໌ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ຕັດຊີ່ນ ອຶນແຍ່ະ ມັຮ ກວາຍ, ອັນ ຕະ ມູເຈິງ ກັອຍ ເຕ່. ອັນ ແປຣີ ມັຮ ເທວາດາ ອັນ ເປາະ ຣຽຮ ກວາຍ. ໄລ່ ປາໂຣມ ມັຮ ກວາຍ ຕາ ອໍ ກາຢັ່ຮ ຕັຮ ແຕ ກວາຍ ຕານັ່ອງ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ເຈີ່ ໄລ່ ອາປັອງ ຕັຮ ຊັອງ ມັຮ ກວາຍ ຕາ ອໍ ກັອຍ ຕຶ່ງ ປຣຸ່ງ ອູ່ຍຮ. ແອີດ ອຶນຕຸ ກັອຍ ໄລ່ ຈີວ໌ ໂຕຍ໌ ບາບ ລາລື່. ໄລ່ ເຍືາມ ກູໂກຼຍ໌ ກະ ໄລ່ ກາເຕຣືອກ ກາແນງ ກາບາງ ຊັອງ ຕຸ່ຮ ອາຣຶ່ກ ລາລື່.\" ");
INSERT INTO ncq_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ແວັດ ກັອຍ ເຢຊູ ຕາແບີບ ໄລ່ ກັອຍ ປາຍ: \"ມັຮ ຣາມຶ່ຮ ໄນ່, ເຍືາ ຊາປຸ່ຮ ມາ ຕາ ເບີນ?\" ໄລ່ ກັອຍ ຕາແອີຍ ປາຍ: \"ເອີອ໌. ຮິ ຊາປຸ່ຮ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ເຢຊູ ອາຕີ ແອັນ ປາຍ: \"ຄັນ ນ່ະກັອຍ, ກູ່ ນະ ກວາຍ ອາຕີ ຄານອດ ຈຸ່ມ ອິດຊະຣາເອລ ກາ ຣຍານ ແອັນ ແຕ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ, ກວາຍ ກັອຍ ລາ ນ່ະ ອຶນເຈົາ ດຸງ ກາ ອາລັ່ອຮ ມັຮ ກາ ມູ່ນ ອັນ ເກຣີ່ງ ຕຍາ ກະ ເກຣີ່ງ ຕາໄມ, ຍ່ອນ ອັນ ເຕ່ອ໌ ອາຕີ ແຕ ຣານະ ຕຍາ ກະ ແຕ ຣານະ ຕາໄມ ແຮີ ໂອນ ເນົ່າ ຊັອງ.\" ");
INSERT INTO ncq_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ແວັດ ເຢຊູ ອາຕີ ປັຣນາຍ ຊາກຳ ກັອຍ, ອັນ ລັ່ອຮ ແຕ ອຶນຕຸ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ອັນ ເຈົາ ປໍ ວີ່ລ ອັນ, ລາ ວີ່ລ ນາຊາເຣັດ. ອັນ ແອີດ ອຶງກັອຍ ອາຕີ ຕຶ່ງ ດຸງ ຊາງ ກວາຍ ອິດຊະຣາເອລ. ໄລ່ ກາ ຊາງັດ ປັຣນາຍ ອັນ, ໄລ່ ກັອຍ ຊັອງ ງຶ່ດ ລາລື່. ກະ ໄລ່ ຕາແບີບ ປາຍ: \"ແຕ ແລ່ະ ອັນ ໄນ່ ເບີນ ປັຣນາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ໄນ່? ກະ ຍ່ອນ ນານ່ະ ອັນ ເຕ່ອ໌ ຕະ ຣານະ ຕາ ເກີ່ຍ ເຮີມ? ");
INSERT INTO ncq_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ເມ່ນ ມາ ຕາ ເບີນ, ອັນ ໄນ່ ລາ ກອນ ກວາຍ ເຈືາງ ຕະ ອາລ່ອງ? ເມ່ນ ມາ ຕາ ເບີນ, ມາຣີ ລາ ອຶມເປ່ອ໌ ອັນ, ກະ ຢາໂກໂບ, ໂຢເຊັບ, ຊີໂມນ, ກະ ຢູດາ ລາ ອາແອມ ອັນ? ");
INSERT INTO ncq_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ກະ ເມ່ນ ມາ ຕາ ເບີນ, ອາມໍ່ອ໌ ອັນ ແອີດ ມູ່ ວີ່ລ ກະ ໄຮ? ມາ ນານ່ະ ກວາຍ ໄນ່ ເຕ່ອ໌ ຕະ ຊາອຶ່ຍ ຣານະ ນ່ະກັອຍ?\" ");
INSERT INTO ncq_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ເຈີ່ ໄລ່ ພາມາດ ເຢຊູ; ໄລ່ ຊັອງ ອວານ ລາລື່ ກະ ປັຣນາຍ ອັນ ອາຕີ ນ່ະກັອຍ. ເຢຊູ ອາຕີ ໂຈະ ໄລ່ ກັອຍ ປາຍ: \"ຄັນ ເບີນ ມານະ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ເປາະ ອາຕີ ຕຶ່ງ ເມືອງ ການໍ່ອ໌, ກວາຍ ເມືອງ ກັອຍ ຢຳນັ່ບ ອັນ. ມາ ຄັນ ອັນ ອາຕີ ຕຶ່ງ ວີ່ລ ອັນ ເບີມ, ກະ ຕຶ່ງ ດຸງ ອັນ ເບີມ, ໄລ່ ກັອຍ ຕາ ເບີນ ຢຳນັ່ບ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ນ່ະກັອຍ ເຢຊູ ຕາ ເບີນ ຕະ ຊາອຶ່ຍ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ຕຶ່ງ ວີ່ລ ກັອຍ, ຍ່ອນ ໄລ່ ຕາ ເບີນ ຊາອຳ. ");
INSERT INTO ncq_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ບັອງ ກາ ກັອຍ ເຕືາວ ປັຣເຍືາ ເຮໂຣດ ຊັອງ ປັຣນາຍ ເນົ່າ ອາຕີ ແຕ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ອັນ ອາຕີ ກວາຍ ຕະ ຣານະ ອັນ ປາຍ: \"ອັນ ໄນ່ ລາ ເມ່ນ ໂຢຮັນ, ອັນ ກາ ເກີ່ຍ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌. ອັນ ຢວຣ ອາມົ່ງ ລັ່ຮ ແຕ ປີ່ງ. ຍ່ອນ ນ່ະກັອຍ ແຕ ອັນ ເບີນ ອຳນາດ ຕະ ຣານະ ຕາ ເກີ່ຍ ເຮີມ.\" ");
INSERT INTO ncq_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ເຮໂຣດ ປາຍ ນ່ະກັອຍ ຍ່ອນ ແຕ ອຶນໂຍ່ງ ອັນ ແປຣີ ຕາຮານ ອັນ ໂກບ ກະ ຊັດ ໂຢຮັນ, ເຈີ່ ໂຈະ ອັນ ຕຶ່ງ ກໍ່ອ໌. ເຮໂຣດ ຕະ ນ່ະກັອຍ ຍ່ອນ ແຕ ເຮໂຣເດຍ, ລາກວຍ ອັນ. ແຕ ກໍ ລາລື່ ເຮໂຣເດຍ ລາ ລາກວຍ ພີລິບ, ອາແອມ ເຮໂຣດ. ");
INSERT INTO ncq_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ບັອງ ກາ ກັອຍ ໂຢຮັນ ອາຕີ ເຕືາວ ປັຣເຍືາ ເຮໂຣດ ປາຍ: \"ເຢືາງ ເຈົາຣາຊີ ຕາ ຢໍອ໌ ອີ ໂອນ ໄມ່ ອີດ ລາກວຍ ອາແອມ ໄມ່!\" ");
INSERT INTO ncq_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ນ່ະກັອຍ ເບີນ ເຮໂຣດ ຄຶ່ດ ຢໍອ໌ ອີ ກາຈີດ ໂຢຮັນ, ມາ ອັນ ອຶງກັອຮ ກວາຍ ຈຸ່ມ ອິດຊະຣາເອລ, ຍ່ອນ ໄລ່ ປາຍ ໂຢຮັນ ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ມາ ແຕີ່ອ໌ ມວຍ ຕາໄງ ແອັນ ເຮໂຣດ ຕະ ເປ່ລ ບູຍ ຊາແຍີ ລັ່ຮ ຕາໄງ ອັນ ແກີດ. ບັອງ ກັອຍ ກອນ ມັນແຊມ ເຮໂຣເດຍ, ອັນ ອຶມປ່ອນ ບຼະໆ ຢັ່ຮ ເມືາງ ກວາຍ ຕາມອຍ ກັອຍ. ນ່ະກັອຍ ເຮໂຣດ ຊັອງ ຣໍ່ອ໌ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ອັນ ເອີອ໌, ກະ ອັນ ຄີນ ກະ ມັນແຊມ ກັອຍ ປາຍ: \"ອຶນເຕົ່າ ໄມ່ ແຊອ໌, ເກົາ ໂອນ ອາກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ນ່ະກັອຍ ອຶມເປ່ອ໌ ອາມໍອ໌ ກັອຍ ແປຣີ ກອນ ອັນ ແຊອ໌ ມູ ຣາມຶ່ຮ ປາຍ: \"ເກົາ ແຊອ໌ ແຕ ໄມ່ ແປຼີ ໂຢຮັນ, ອັນ ກາ ເກີ່ຍ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌. ແຊອ໌ ໄມ່ ໂຈະ ຕຶ່ງ ກູໂຕອ໌ ຊານໍ່ ແຕິ່!\" ");
INSERT INTO ncq_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ເຕືາວ ປັຣເຍືາ ກັອຍ ຊັອງ ຕຸ່ຮ ລາລື່. ມາ ຍ່ອນ ອັນ ຄີນ ຢັ່ຮ ເມືາງ ຕາມອຍ ກັອຍ, ເຈີ່ ອັນ ແປຣີ ໂອນ ເນົ່າ ຕະ ມູເຈິງ ມັນແຊມ ກັອຍ ແຊອ໌. ");
INSERT INTO ncq_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ອັນ ໂອນ ເນົ່າ ມູ່ດ ກັອຮ ຕາກອງ ໂຢຮັນ ຕຶ່ງ ກໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ເນົ່າ ໂຈະ ແປຼີ ໂຢຮັນ ຕຶ່ງ ກູໂຕອ໌ ເດີງ ອາຊວຍ ໂອນ ປໍ ມັນແຊມ ກັອຍ. ເຈີ່ ມັນແຊມ ກັອຍ ມ່ອບ ໂອນ ອຶມເປ່ອ໌ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ແວັດ ກັອຍ ມູ່ ກາ ຣຍານ ແຕ ໂຢຮັນ ແຕີ່ອ໌ ອີດ ຈະ ໂຢຮັນ ເດີງ ແຕິບ. ກະ ໄລ່ ເປາະ ອາຕີ ເຢຊູ ແຕ ຣາມຶ່ຮ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ພໍກາ ເຢຊູ ຊັອງ ແຕ ຣານະ ກັອຍ, ອັນ ລັ່ອຮ ແຕ ອຶນຕຸ ອັນ ແອີດ. ຊັອຮ ຕຶ່ງ ຕົວະ ເປາະ ປໍ ອຶນຕຸ ຕາ ເບີນ ເນົ່າ ແອີດ, ຢໍອ໌ ອີ ແອີດ ມານະ ຊັອງ. ມາ ພໍກາ ກວາຍ ກຼຶ່ງ ຊັອງ ເນົ່າ ປາຍ ອັນ ເປາະ; ນ່ະກັອຍ ໄລ່ ລັ່ອຮ ແຕ ເມືອງ ໄລ່, ເປາະ ຣານາ ອາເຢີງ ຕາປູ່ນ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ພໍກາ ເຢຊູ ແຊງ ແຕ ຕົວະ, ອັນ ເຮີມ ກວາຍ ກຼຶ່ງ ກັອຍ. ເຈີ່ ຣາງຶ່ຮ ອັນ ຊັອງ ອາໂຢ່ະ ຕະ ມັຮ ກວາຍ ກັອຍ. ກະ ອັນ ປົວ ມັຮ ກວາຍ ອາອີ່ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ແຈ່ະ ມານາງ ອີ ຕາບື່, ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ແຕີ່ອ໌ ປໍ ອັນ, ປາຍ: \"ອຶນໄນ່ ເຢີ່ງ ແຕ ກວາຍ ແອີດ, ກະ ມັ່ດ ມານາງ ແຈ່ະ ອີ ຊາເດົາ ເຈີ່. ແຊອ໌ ອາຈານ ອາຕີ ມັຮ ກວາຍ ກຼຶ່ງ ໄນ່ ເຈົາ ແຕ ໄນ່ ມູ່ດ ຕຶ່ງ ເມືອງ ອຶມແປຣ ໄນ່ ໂອນ ໄລ່ ແຈີງ ເບີມ ເກຣີ່ງ ຊັຣນາ ຈາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ຕາ ເບີນ ຕຸ່ຮ ອຶງເຄາະ ໄລ່ ເຈົາ ແຕ ໄນ່. ເຍືາ ແຕິ່ ໂອນ ໄລ່ ກັອຍ ເບີນ ເກຣີ່ງ ຊັຣນາ ຈາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ມາ ໄລ່ ອາຕີ ເຢຊູ ປາຍ: \"ຮິ ຕາ ເບີນ ອຶນເຕົ່າ ອີ ໂອນ ໄລ່. ເບີນ ບີ່ອ໌ ເຊີງ ລຳ ໂດຍ ບຸຮ ກະ ບາຣ ລຳ ອາກາ ຊັອງ.\" ");
INSERT INTO ncq_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ເຢຊູ ແປຣີ ໄລ່ ປາຍ: \"ເດີງ ໂດຍ ບຸຮ ກະ ອາກາ ກັອຍ ແຕີ່ອ໌ ປໍ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ເຢຊູ ແປຣີ ມັຮ ກວາຍ ກຼຶ່ງ ກັອຍ ຕາກູ ຕຶ່ງ ກູແຕອ໌. ເຈີ່ ອັນ ອີດ ເຊີງ ລຳ ໂດຍ ບຸຮ ກະ ບາຣ ລຳ ອາກາ ກັອຍ. ອັນ ຕາເງີ່ອ໌ ອາຊັອຮ ປໍ ມັນລັ່ອງ ກະ ຊາແອີນ ເຢືາງ ເຈົາຣາຊີ ເບີນ ເກຣີ່ງ ຊັຣນາ ຈາ ໄນ່. ແວັດ ກັອຍ ອັນ ປີຮ ໂດຍ ບຸຮ ກັອຍ. ເຈີ່ ອັນ ມ່ອບ ໂອນ ມູ່ ກາ ຣຍານ ແຕ ອັນ, ໂອນ ໄລ່ ກັອຍ ອຶມແປອ໌ ໂອນ ມັຮ ກວາຍ ກຼຶ່ງ ກັອຍ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ອຶນແຍ່ະ ມັຮ ກວາຍ ຈາ ປາໄຊ ກູ່ ນະ. ແວັດ ໄລ່ ຈາ, ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ປາໂຣມ ລັ່ຮ ມັຮ ອຶງກັຮ ເບີນ ມັນຈິ່ດ ລາ ບາຣ ກາເຣຍ. ");
INSERT INTO ncq_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ອຶນແຍ່ະ ມັຮ ກວາຍ ກາ ຈາ ກັອຍ ເບີນ ມາຮ ເຊີງ ປັ່ນ ນະ ແອີງ ກວາຍ ຊາຊາຍ ຣາເລົາ ຊັອງ, ຕາ ເບີນ ນັ່ບ ກວາຍ ມັນແຊມ ກະ ກັຣແນນ. ");
INSERT INTO ncq_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ແວັດ ກັອຍ ເຢຊູ ໂອນ ມູ່ ກາ ຣຍານ ແຕ ອັນ ຊັອຮ ຕຶ່ງ ຕົວະ ກະ ເປາະ ອຶນໂຍ່ງ ປໍ ປຶ່ຮ ອຶນຕົ່ຮ ກັອຍ. ເຈີ່ ອັນ ອາຕີ ໂອນ ມັຮ ກວາຍ ກຼຶ່ງ ກັອຍ ເຈົາ ປໍ ດຸງ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ແວັດ ກວາຍ ກຼຶ່ງ ກັອຍ ເຈົາ, ເຢຊູ ຊັອຮ ເກົາແຊອ໌ ຕຶ່ງ ກົຮ ມານະ ອັນ. ພໍກາ ຊາເດົາ, ເຢຊູ ອຶນນັ່ອງ ແອີດ ຕຶ່ງ ກົຮ ມານະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ມາ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ, ໄລ່ ແອີດ ຕຶ່ງ ຕົວະ ອຶນດີ ທາເລ ຣາປັ່ງ. ເບີນ ແດີອ໌ ປ່ອງ ກຼຸ່ຮ ຕົວະ ໄລ່ ຮັບ ລາລື່, ຍ່ອນ ກູຢາລ ແອີດ ແປຼິ່ ເລືອຍໆ ຕົວະ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ອຶນນັ່ອງ ຊາເດົາ ແຈ່ະ ອີ ປັ່ງ ເຢຊູ ແຕີ່ອ໌ ປໍ ໄລ່. ອັນ ຕາຢັຮ ແປີງ ກຣັອງ ທາເລ ຣາປັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ພໍກາ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ເຮີມ ອັນ ຕາຢັຮ ແປີງ ກຣັອງ ແດີອ໌ ກັອຍ, ໄລ່ ຊັອງ ອຶງກັອຮ ລາລື່, ກະ ໄລ່ ປາຍ: \"ກູມູ່ຍ໌ ລື່ດ ເອີຍ໌ ອາໄນ່!\" ນ່ະກັອຍ ໄລ່ ແຮຣ ເຣ່ງ ລາລື່ ຍ່ອນ ໄລ່ ຊັອງ ອຶງກັອຮ. ");
INSERT INTO ncq_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ມາ ເຢຊູ ອາຕີ ແຕິ່ ໄລ່ ປາຍ: \"ໂອນ ຣາງຶ່ຮ ເຍືາ ແອີດ ອຽນ ອໍ. ໄນ່ ລາ ຈະ ເກົາ. ເຍືາ ອຶນໂຈຍ ອຶງກັອຮ ອຶນເຕົ່າ.\" ");
INSERT INTO ncq_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ເຈີ່ ເປໂຕ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ຄັນ ເມ່ນ ອຶນເຈົາ, ເກົາ ແຊອ໌ ອຶນເຈົາ ໂອນ ເກົາ ຕາຢັຮ ແປີງ ກຣັອງ ແດີອ໌ ແຕີ່ອ໌ ປໍ ອຶນເຈົາ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ເຢຊູ ຕາແອີຍ ອັນ ປາຍ: \"ແຕີ່ອ໌ ປໍ ໄນ່!\" ເຈີ່ ເປໂຕ ແຊງ ແຕ ຕົວະ. ອັນ ຕາຢັຮ ແປີງ ກຣັອງ ແດີອ໌ ແຕີ່ອ໌ ປໍ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ມາ ພໍກາ ເປໂຕ ຊັອງ ກູຢາລ ແປຼິ່ ຕຶ່ງ ຈະ ອັນ, ອັນ ຊັອງ ອຶງກັອຮ ລາລື່. ນ່ະກັອຍ ອັນ ຊັຣລຸ ອາແຊງ ຕຶ່ງ ແດີອ໌, ເຈີ່ ອັນ ແຮຣ ເຣ່ງ ລາລື່ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ຈ່ອຍ ເກົາ ແຮີ!\" ");
INSERT INTO ncq_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ບັອງ ກັອຍ ແຕິ່ ເຢຊູ ຕາແວີ ອາຕີ ຊັນຕັ່ບ ອາແຣິ່ ເປໂຕ ແຕ ແດີອ໌. ກະ ເຢຊູ ອາຕີ ອັນ ປາຍ: \"ໄມ່ ຊາອຳ ບີ່ອ໌ ລາລື່! ນານ່ະ ແຕ ໄມ່ ອຶນນັ່ອງ ກູຄຶ່ດ?\" ");
INSERT INTO ncq_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ເຈີ່ ເຢຊູ ກະ ເປໂຕ ຊັອຮ ຕຶ່ງ ຕົວະ, ກະ ກູຢາລ ກັອຍ ຕາ ເບີນ ແປຼິ່ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ນ່ະກັອຍ ອຶນແຍ່ະ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ແອີດ ຕຶ່ງ ຕົວະ ກັອຍ, ໄລ່ ກັອຍ ກູກຸຮ ຊາງ ເຢຊູ. ໄລ່ ປາຍ: \"ໄກຣ ລາລື່ ອຶນເຈົາ ລາ ກອນ ເຢືາງ ເຈົາຣາຊີ!\" ");
INSERT INTO ncq_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ໄລ່ ເປາະ ຢັ່ຮ ອຶນຕົ່ຮ ທາເລ ຣາປັ່ງ ແຕີ່ອ໌ ປໍ ກຣວາງ ເຄັນເນຊາເຣັດ. ");
INSERT INTO ncq_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ກວາຍ ແອີດ ຕຶ່ງ ກຣວາງ ກັອຍ ຊາກັ່ລ ເຢຊູ. ນ່ະກັອຍ ໄລ່ ອາຕີ ໂອນ ເນົ່າ ເດີງ ມັຮ ກວາຍ ກາ ເບີນ ອາອີ່ ແອີດ ຕຶ່ງ ກຣວາງ ກັອຍ ແຕີ່ອ໌ ປໍ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ກະ ໄລ່ ກັອຍ ແຊອ໌ ແຕ ເຢຊູ ໂອນ ມັຮ ກວາຍ ອາອີ່ ເຕ່ອ໌ ຊາປ່ະ ຕຶ່ງ ເປິບ ອາຢັ່ອຮ ຕີ່ ເຢຊູ. ກວາຍ ອາແລ່ະ ກາ ເບີນ ຊາປ່ະ, ຈະ ກວາຍ ກັອຍ ແກີດ ແບຣັຮ. ");
INSERT INTO ncq_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ອຶນຕູ່ນ ກັອຍ ເບີນ ມັຮ ກວາຍ ແຕ ຈຸ່ມ ພາຣີຊາຍ ກະ ແຕ ມູ່ ກວາຍ ອາຕີ ຄານອດ ແຕ ເມືອງ ເຢຣູຊາເລັມ ແຕີ່ອ໌ ປໍ ເຢຊູ. ໄລ່ ກັອຍ ຕາແບີບ ເຢຊູ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","\"ນານ່ະ ມູ່ ກາ ຣຍານ ແຕ ອາຈານ ຕາ ເບີນ ຕາປູ່ນ ຣີ່ດ ອາຈວາຍຮ ອາເຈ່ຮ ໄຮ? ນານ່ະ ອຶນໂຍ່ງ ໄລ່ ອີ ຈາ ມາ ໄລ່ ຕາ ເບີນ ກູໂຊຍ໌ ອາຕີ ຕາປູ່ນ ຣີ່ດ ກັອຍ?\" ");
INSERT INTO ncq_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ເຢຊູ ຕາແອີຍ ລັ່ຮ ໄລ່ ປາຍ: \"ນານ່ະ ເຍືາ ຕັຮ ປັຣນາຍ ປາຕັບ ແຕ ເຢືາງ ເຈົາຣາຊີ, ມາ ເຍືາ ຕາປູ່ນ ຣີ່ດ ເຍືາ ເບີມ ແອັນ? ");
INSERT INTO ncq_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ເຢືາງ ເຈົາຣາຊີ ປາຕັບ ປາຍ: 'ອຶງເຄາະ ເຍືາ ຢຳນັ່ບ ອຶມເປ່ອ໌ ອຶມປໍ່ ເຍືາ,' ກະ 'ກວາຍ ອາແລ່ະ ມາ ພາມາດ ອຶມເປ່ອ໌ ອຶມປໍ່, ກວາຍ ກັອຍ ອຶງເຄາະ ຈີວ໌ ກູຈີດ.' ");
INSERT INTO ncq_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ມາ ເຍືາ ອາຕີ ປາຍ: 'ຄັນ ກວາຍ ອາແລ່ະ ມາ ເບີນ ເກຣີ່ງ ກາ ອັນ ເຕ່ອ໌ ຈ່ອຍ ອຶມເປ່ອ໌ ອຶມປໍ່ ອັນ, ມາ ອັນ ປາຍ ເກຣີ່ງ ກັອຍ ອັນ ເອີອ໌ ອີ ຊາງ ໂອນ ເຢືາງ ເຈົາຣາຊີ ເຈີ່, ");
INSERT INTO ncq_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ນ່ະກັອຍ ອັນ ຕາ ເບີນ ຕຸ່ຮ ຈ່ອຍ ນັ່ອງ ອຶມເປ່ອ໌ ອຶມປໍ່ ອັນ.' ມາ ຕະ ນ່ະກັອຍ ລາ ກວາຍ ກັອຍ ຕາ ເບີນ ຢຳນັ່ບ ອຶມເປ່ອ໌ ອຶມປໍ່ ອັນ. ມູເຈິງ ກັອຍ ເຕ່ ເຍືາ ອີດ ຣີ່ດ ອາຈວາຍຮ ອາເຈ່ຮ ເຍືາ ເບີມ ເຕ່ນ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ເຍືາ ລາ ກວາຍ ມາມ ອໍ ມາ ຣາງຶ່ຮ ໂກ່ະ! ປຍາຍ໌ ມັຮ ປັຣນາຍ ເອຊາຢາ ປາຍ ແຕ ເຍືາ: ");
INSERT INTO ncq_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","'ມັຮ ກວາຍ ໄນ່ ຢຳນັ່ບ ເກົາ ແອີງ ແບອ໌ ຊັອງ, ມາ ຣາງຶ່ຮ ໄລ່ ແອີດ ເຢີ່ງ ແຕ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ກະ ໄລ່ ຊາງ ເລືອຍໆ ເກົາ ມາ ຕາ ເບີນ ແກີດ ເກືາ ອຶນເຕົ່າ, ຍ່ອນ ໄລ່ ອາຕີ ປັຣນາຍ ກວາຍ, ມາ ຢໍອ໌ ອີ ໂອນ ເນົ່າ ການໍ່ອ໌ ຄຶ່ດ ປາຍ ປັຣນາຍ ແຕ ເຢືາງ ເຈົາຣາຊີ.'\" ");
INSERT INTO ncq_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ແວັດ ກັອຍ ເຢຊູ ກູອ໌ ກວາຍ ກຼຶ່ງ ແຕີ່ອ໌ ປໍ ອັນ. ອັນ ອາຕີ ໄລ່ ປາຍ: \"ເຍືາ ຊາງັດ ໂອນ ກຣັ່ກ! ");
INSERT INTO ncq_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ອຶນແຍ່ະ ມັຮ ເກຣີ່ງ ຊັຣນາ ກາ ກວາຍ ຈາ ອາມູ່ດ ແຕ ແບອ໌ ຕາ ເບີນ ຕະ ໂອນ ແກີດ ຕາ ອໍ. ມາ ກູຄຶ່ດ ຕຶ່ງ ຣາງຶ່ຮ ເບີມ, ກາ ແບອ໌ ປາຍ ອາລັ່ອຮ, ຣານະ ກັອຍ ໂອນ ກວາຍ ແກີດ ຕາ ເບີນ ອໍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ແວັດ ກັອຍ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ແຕີ່ອ໌ ຕາແບີບ ອັນ ປາຍ: \"ອາຈານ ດັງ ມາ ຕາ ເບີນ, ຈຸ່ມ ພາຣີຊາຍ ຊັອງ ອວານ ກະ ອາຈານ, ຍ່ອນ ແຕ ມັຮ ປັຣນາຍ ອາຈານ ອາຕີ ແຕ ອຶນໂຍ່ງ ກັອຍ?\" ");
INSERT INTO ncq_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ເຢຊູ ຕາແອີຍ ໄລ່ ແຕ ປັຣນາຍ ຊາກຳ ປາຍ: \"ຄັນ ກັ່ລ ອາລ່ອງ ອາແລ່ະ ມາ ອຶມປໍ່ ເກົາ ຕຶ່ງ ມັນລັ່ອງ ຕາ ເບີນ ຈົຮ, ປັຣແນີ ມັນເຕຣືາ ອັນ ເຣີ່ອ໌ ຕັຮ ກັ່ລ ອາລ່ອງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ນ່ະກັອຍ ເຍືາ ອຶນໂຈຍ ຣາບູລ ກະ ໄລ່. ໄລ່ ລາ ນ່ະ ກວາຍ ຊູດ ມັ່ດ ກາ ຢໍອ໌ ອີ ເຕິ ກວາຍ ຊູດ ມັ່ດ ການໍ່ອ໌. ເຈີ່ ໄລ່ ຊາປິ່ລ ມັນຕຸ ຕຶ່ງ ປຣຸ່ງ.\" ");
INSERT INTO ncq_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ແວັດ ກັອຍ ເປໂຕ ແຊອ໌ ແຕ ເຢຊູ ປາຍ: \"ແຊອ໌ ອາຈານ ອາຕີ ໂອນ ແຈງ ແຕ ປັຣນາຍ ຊາກຳ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ເຢຊູ ຕາແບີບ ລັ່ຮ ປາຍ: \"ເຍືາ ຕາ ເບີນ ຊາປຸ່ຮ ມູເຈິງ ກວາຍ ການໍ່ອ໌ ເຕ່ ບໍ? ");
INSERT INTO ncq_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ນານ່ະ ເຍືາ ອຶນນັ່ອງ ຕາ ຢວາຮ ຊາປຸ່ຮ ຊາ? ເກຣີ່ງ ຊັຣນາ ຈາ ກາ ມູ່ດ ແຕ ແບອ໌, ລື່ນ ປໍ ປຸ່ງ, ເຈີ່ ລັ່ອຮ ຣານາ ແປຣິ່. ");
INSERT INTO ncq_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ມາ ປັຣນາຍ ອຶນເຕົ່າ ກາ ລັ່ອຮ ແຕ ແບອ໌, ອຶນແຍ່ະ ປັຣນາຍ ກັອຍ ລັ່ອຮ ແຕ ຣາງຶ່ຮ. ຣາມຶ່ຮ ກັອຍ ຕະ ໂອນ ກວາຍ ແກີດ ຕາ ເບີນ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ມັຮ ຣາມຶ່ຮ ຕາ ອໍ ກາ ລັ່ອຮ ແຕ ຣາງຶ່ຮ ກວາຍ ລາ ນ່ະໄນ່: ກູຄຶ່ດ ຕາມມັຮ, ກາຈີດ ກວາຍ, ປັຣລື່ຍ ລາກວຍ ແຕີລາ ກາຢາອ໌ ເນົ່າ, ຕາ ເບີນ ລາກວຍ ກາຢາອ໌ ມາ ບິ ມັນຕຸ, ຕູຕວຍ໌, ບູບວກ, ກະ ພາມາດ. ");
INSERT INTO ncq_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ອຶນແຍ່ະ ຣາມຶ່ຮ ໄນ່ ຕະ ໂອນ ກວາຍ ແກີດ ໂລ່ຍຮ. ມາ ຄັນ ເນົ່າ ຈາ ຊັຣນາ ມາ ຕາ ຢວາຮ ອາເຣືາວ ອາຕີ, ຣານະ ກັອຍ ລາ ຕາ ເບີນ ແກີດ ໂລ່ຍຮ ອຶນເຕົ່າ.\" ");
INSERT INTO ncq_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ແວັດ ກັອຍ ເຢຊູ ລັ່ອຮ ແຕ ອຶນຕຸ ກັອຍ, ມູ່ດ ຕຶ່ງ ກຣວາງ ອຶມແປຣ ເມືອງ ຕີເຣ ກະ ເມືອງ ຊີໂດນ. ");
INSERT INTO ncq_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ເບີນ ມັນແຊມ ແຕ ຈຸ່ມ ການາອານ ແອີດ ຕຶ່ງ ກຣວາງ ກັອຍ ແຕີ່ອ໌ ປໍ ເຢຊູ; ກະ ປາຍ ເຣ່ງ ນ່ະໄນ່: \"ອຶນເຈົາ ເອີຍ! ອຶນເຈົາ ກາ ແຕ ຈຸ່ມເຈືອ ເຕືາວ ປັຣເຍືາ ດາວິດ! ແຊອ໌ ອຶນເຈົາ ອາໂຢ່ະ ຕະ ເກົາ ແຮີ. ກອນ ມັນແຊມ ເກົາ ເບີນ ອາອີ່ ຮັບ ລາລື່, ເບີນ ເຢືາງ ຕາ ອໍ ຕຣວບ ເລືອຍໆ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ມາ ເຢຊູ ຕາ ເບີນ ຕາແອີຍ ອັນ ອຶນເຕົ່າ. ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ແຕີ່ອ໌ ປໍ ອັນ ປາຍ: \"ແຊອ໌ ອາຈານ ແປຣີ ໂອນ ມັນແຊມ ໄນ່ ເຈົາ, ຍ່ອນ ອັນ ປວາຍ ເລືອຍໆ ໄຮ, ຣາແຊອ໌ ທໍ ແຕ ໄຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ເຢຊູ ຕາແອີຍ ປາຍ: \"ເຢືາງ ເຈົາຣາຊີ ແປຣີ ເກົາ ແຕີ່ອ໌ ແອີງ ປໍ ຈຸ່ມ ອິດຊະຣາເອລ ຊັອງ. ໄລ່ ກັອຍ ລາ ນ່ະ ແກະ ແກຼິ ຣານາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ມັນແຊມ ກັອຍ ກຼຸ່ ຣາໂກລ ຢັ່ຮ ເມືາງ ເຢຊູ, ປາຍ: \"ກູກຸຮ ອຶນເຈົາ ເກົາ ເອີຍ! ແຊອ໌ ອຶນເຈົາ ຈ່ອຍ ເກົາ ແຮີ!\" ");
INSERT INTO ncq_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ມາ ເຢຊູ ຕາແອີຍ ປາຍ: \"ຕາ ປຍາຍ໌ ອີດ ເກຣີ່ງ ຊັຣນາ ກັຣແນນ ຈາ; ເຈີ່ ແກຼງ ຕັຮ ໂອນ ອາຈໍ ຈາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ມັນແຊມ ກັອຍ ຕາແອີຍ ເຢຊູ ປາຍ: \"ປຍາຍ໌ ອຶນເຈົາ ປາຍ. ມາ ເຕ່ອ໌ ອາຈໍ ຈາ ຣາບຍາອ໌ ຣາບິນ ກາ ຊາແລັຮ ຕຶ່ງ ປື່ນ ອຶນຕຸ ອຶນເຈົາ ຈາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ນ່ະກັອຍ ເຢຊູ ຕາແອີຍ ມັນແຊມ ກັອຍ: \"ໄມ່ ລາ ມັນແຊມ ກາ ຊາອຳ ກຣັ່ກ ລາລື່. ຣາມຶ່ຮ ໄມ່ ແຊອ໌, ເກົາ ໂອນ ໄມ່ ເບີນ ຣາມຶ່ຮ ກັອຍ.\" ບັອງ ກາ ເຢຊູ ປາຍ ນ່ະກັອຍ, ກອນ ມັນແຊມ ກັອຍ ແບຣັຮ ແຕິ່. ");
INSERT INTO ncq_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ເຢຊູ ລັ່ອຮ ແຕ ອຶນຕຸ ກັອຍ, ເປາະ ແຈ່ະ ທາເລ ຣາປັ່ງ ຄາລີເລ ແອັນ. ເຈີ່ ອັນ ຊັອຮ ຕາກູ ຕຶ່ງ ກົຮ. ");
INSERT INTO ncq_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ກຼຶ່ງ ກວາຍ ແຕີ່ອ໌ ປໍ ອັນ. ໄລ່ ກັອຍ ເດີງ ປໍ ເຢຊູ ກວາຍ ເບີນ ຊາອຶ່ຍ ຣາມຶ່ຮ ອາອີ່ ນ່ະໄນ່: ກວາຍ ໂຢດ, ກວາຍ ຊູດ ມັ່ດ, ກວາຍ ລ່ອຍ, ກວາຍ ເກີອ໌, ກະ ກຼຶ່ງ ກວາຍ ກາ ເບີນ ຣາມຶ່ຮ ອາອີ່ ການໍ່ອ໌ ແຮີ. ໄລ່ ດໍອ໌ ມັຮ ກວາຍ ອາອີ່ ກັອຍ ແຈ່ະ ອາເຢີງ ເຢຊູ. ເຈີ່ ເຢຊູ ປົວ ອຶນແຍ່ະ ມັຮ ກວາຍ ອາອີ່ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ກວາຍ ກຼຶ່ງ ກັອຍ ຊັອງ ງຶ່ດ ລາລື່ ພໍກາ ໄລ່ ເຮີມ ກວາຍ ເກີອ໌ ມາ ເຕ່ອ໌ ຕະ ອຶນຕີ ລັ່ຮ, ກວາຍ ລ່ອຍ ມາ ແກີດ ອໍ ລັ່ຮ, ກວາຍ ໂຢດ ມາ ເຕ່ອ໌ ປູເປາະ ລັ່ຮ, ກວາຍ ຊູດ ມັ່ດ ມາ ແກີດ ປັ່ງ ລັ່ຮ. ໄລ່ ຍ່ອງ ລາລື່ ເຢືາງ ເຈົາຣາຊີ, ກາ ຈຸ່ມ ອິດຊະຣາເອລ ຊາງ. ");
INSERT INTO ncq_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ເຢຊູ ກູອ໌ ມູ່ ກາ ຣຍານ ແຕ ອັນ ແຕີ່ອ໌ ປໍ ອັນ. ອັນ ປາຍ: \"ເກົາ ຊັອງ ອາໂຢ່ະ ຕະ ລາລື່ ມັຮ ກວາຍ ກຼຶ່ງ ໄນ່, ຍ່ອນ ໄລ່ ແອີດ ກະ ເກົາ ອຶນແຍ່ະ ໄປ ຕາໄງ ເຈີ່, ກະ ໄລ່ ແອິ ເກຣີ່ງ ຊັຣນາ ຈາ. ເກົາ ຕາ ຢໍອ໌ ອີ ໂອນ ໄລ່ ເຈົາ ບັອງ ໄລ່ ມາເຍືາຍຮ, ອຶງກັອຮ ໄລ່ ອຽວ໌ ຕຶ່ງ ຣານາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ຕາແບີບ ລັ່ຮ ອັນ ປາຍ: \"ນານ່ະ ໄຮ ອີ ຕະ ໂອນ ເບີນ ເກຣີ່ງ ຊັຣນາ ຈາ ຊານາ ກວາຍ ກຼຶ່ງ ໄນ່, ຍ່ອນ ອຶນໄນ່ ເຢີ່ງ ແຕ ອຶນຕຸ ກວາຍ ແອີດ?\" ");
INSERT INTO ncq_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ເຢຊູ ຕາແບີບ ລັ່ຮ ໄລ່ ປາຍ: \"ເຍືາ ເບີນ ໂດຍ ບຸຮ ອຶນຊິ ລຳ?\" ໄລ່ ຕາແອີຍ ປາຍ: \"ຮິ ເບີນ ຕາປູ່ລ ລຳ ໂດຍ ບຸຮ ກະ ບາຣ ໄປ ລຳ ອາກາ ຊັອງ.\" ");
INSERT INTO ncq_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ເຢຊູ ແປຣີ ກຼຶ່ງ ກວາຍ ກັອຍ ຕາກູ ຕຶ່ງ ກູແຕອ໌. ");
INSERT INTO ncq_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ເຈີ່ ອັນ ອີດ ຕາປູ່ລ ລຳ ໂດຍ ບຸຮ ກະ ບາຣ ໄປ ລຳ ອາກາ ກັອຍ. ອັນ ຊາແອີນ ເຢືາງ ເຈົາຣາຊີ ເບີນ ເກຣີ່ງ ຈາ ໄນ່. ແວັດ ກັອຍ ອັນ ປີຮ ໂດຍ ບຸຮ ກະ ອາກາ ອາແວີຍ ໂອນ ມູ່ ກາ ຣຍານ ແຕ ອັນ; ເຈີ່ ໄລ່ ອຶມແປອ໌ ໂອນ ມັຮ ກວາຍ ກຼຶ່ງ ກັອຍ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ອຶນແຍ່ະ ມັຮ ກວາຍ ກັອຍ ຈາ ປາໄຊ ອຶນແຍ່ະ. ກະ ໄລ່ ປາໂຣມ ລັ່ຮ ມັຮ ອຶງກັຮ ກາ ແກຼີຍ ແຕ ໄລ່ ຈາ ປັ່ນ ລັ່ຮ ຕາປູ່ລ ກາເຣຍ. ");
INSERT INTO ncq_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ອຶນແຍ່ະ ມັຮ ກວາຍ ກາ ຈາ ກັອຍ ເບີນ ປູນ ປັ່ນ ນະ ແອີງ ກວາຍ ຊາຊາຍ ຣາເລົາ ຊັອງ, ຕາ ເບີນ ນັ່ບ ກວາຍ ມັນແຊມ ກະ ກັຣແນນ. ");
INSERT INTO ncq_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ແວັດ ກັອຍ ເຢຊູ ແປຣີ ມັຮ ກວາຍ ກຼຶ່ງ ກັອຍ ເຈົາ. ເຈີ່ ອັນ ຊັອຮ ຕຶ່ງ ຕົວະ ເປາະ ປໍ ກຣວາງ ມາຄາດານ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ເບີນ ມັຮ ກວາຍ ແຕ ຈຸ່ມ ພາຣີຊາຍ ກະ ແຕ ຈຸ່ມ ຊາດູກາຍ ແຕີ່ອ໌ ປໍ ເຢຊູ. ໄລ່ ຢໍອ໌ ອີ ລ່ອງ ອັນ. ນ່ະກັອຍ ໄລ່ ແຊອ໌ ແຕ ເຢຊູ ໂອນ ອັນ ຕະ ຣານະ ອາປັຮ ໂອນ ໄລ່ ດັງ ອຳນາດ ອັນ ແຕີ່ອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ມາ ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ບັອງ ກາ ມັ່ດ ມານາງ ແຈ່ະ ອີ ປັດ, ຄັນ ເທຣີງ ກູເຊົາ, ເຍືາ ປາຍ: 'ປັຣແນີ ພວາອ໌.' ");
INSERT INTO ncq_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ມາ ແຕີ່ອ໌ ຕາຣື່ບ ມັນລັ່ອງ ຕາແບິ ປັ່ງ ຍາຍຶ່ມ, ຄັນ ເຍືາ ເຮີມ ເທຣີງ ກູເຊົາ ຊາ ກະ ມັນລັ່ອງ ການຳ ອຶນຕັອງ, ເຍືາ ປາຍ: 'ຕາໄງ ໄນ່ ເມືາ ຈັ່ນ.' ນ່ະກັອຍ ເຍືາ ຊາກັ່ລ ຣາມິ່ລ ກັອຍ ເມືາ ມາ ພວາອ໌, ມາ ເຍືາ ຕາ ເບີນ ດັງ ອຶນເຕົ່າ ແຕ ຣານະ ກາ ເຢືາງ ເຈົາຣາຊີ ໂອນ ເຍືາ ດັງ ຕຶ່ງ ແດີຍ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ກວາຍ ຕຶ່ງ ແດີຍ ໄນ່, ໄລ່ ຕາ ອໍ ລາລື່, ກະ ໄລ່ ຕາ ຢໍອ໌ ອີ ຊາງ ນັ່ອງ ເຢືາງ ເຈົາຣາຊີ. ເຍືາ ແຊອ໌ ແຕ ເກົາ ມູ ຣານະ ຕາ ເກີ່ຍ ເຮີມ, ມາ ເກົາ ຕາ ເບີນ ຕະ ໂອນ ເຍືາ. ເຍືາ ເບີນ ເຈີ່ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ແຕ ໂຢນາ, ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ.\" ເຈີ່ ເຢຊູ ລັ່ອຮ ແຕ ໄລ່ ກັອຍ, ເປາະ ປໍ ອຶນຕຸ ການໍ່ອ໌ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ພໍກາ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ເປາະ ຢັ່ຮ ອຶນຕົ່ຮ ທາເລ ຣາປັ່ງ, ໄລ່ ຊາລີຣ ເດີງ ໂດຍ ບຸຮ. ");
INSERT INTO ncq_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ເຈີ່ ເຢຊູ ອາຕີ ໄລ່ ກັອຍ ປາຍ: \"ເຍືາ ເນ່ ອໍ! ໂອນ ເຍືາ ລາວັ່ງ ບວຮ ຊື່ອ໌ ແຕ ຈຸ່ມ ພາຣີຊາຍ ກະ ຈຸ່ມ ຊາດູກາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ໄລ່ ກັອຍ ຊັຣຮົງ ລັ່ຮ ປັຣນາຍ ເຢຊູ ປາຍ, ກະ ມານະ ອາຕີ ມານະ ປາຍ: \"ເຮີມ ອັນ ປາຍ ນ່ະກັອຍ, ຍ່ອນ ໄຮ ຕາ ເບີນ ເດີງ ໂດຍ ບຸຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ພໍກາ ເຢຊູ ຊັອງ ໄລ່ ປາຍ ນ່ະກັອຍ, ອັນ ອາຕີ ແອັນ ໂຈະ ໄລ່ ປາຍ: \"ງຶ່ດ ລາລື່, ເຍືາ ຊາອຳ ບີ່ອ໌! ນານ່ະ ແຕ ເຍືາ ຊັຣຮົງ ປາຍ ຍ່ອນ ເຍືາ ແອິ ໂດຍ ບຸຮ ຈາ? ");
INSERT INTO ncq_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ເຍືາ ຕາ ຢວາຮ ຊາປຸ່ຮ ບໍ? ເຍືາ ຊາແຍີ ມາ ຕາ ເບີນ ແຕ ເຊີງ ລຳ ໂດຍ ບຸຮ ເກົາ ຊານາ ໂອນ ເຊີງ ປັ່ນ ນະ ກວາຍ ຈາ? ບັອງ ກາ ກັອຍ ເຍືາ ປາໂຣມ ລັ່ຮ ເບີນ ອຶນຊິ ກາເຣຍ ແກຼີຍ ແຕ ກວາຍ ຈາ ກັອຍ? ");
INSERT INTO ncq_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ກະ ເຍືາ ຊາແຍີ ມາ ຕາ ເບີນ ແຕ ຕາປູ່ລ ລຳ ໂດຍ ບຸຮ ເກົາ ຊານາ ໂອນ ປູນ ປັ່ນ ນະ ກວາຍ ຈາ? ບັອງ ກາ ກັອຍ ເຍືາ ປາໂຣມ ລັ່ຮ ເບີນ ອຶນຊິ ກາເຣຍ ແກຼີຍ ແຕ ກວາຍ ຈາ ກັອຍ? ");
INSERT INTO ncq_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ພໍກາ ເກົາ ອາຕີ ເຍືາ ແຕ ບວຮ ຊື່ອ໌ ຄອງ ຈຸ່ມ ພາຣີຊາຍ ກະ ຈຸ່ມ ຊາດູກາຍ, ນານ່ະ ເຍືາ ຕາ ເບີນ ດັງ ປັຣນາຍ ກັອຍ ລາ ປັຣນາຍ ຊາກຳ ຊັອງ?\" ");
INSERT INTO ncq_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ມູ່ ກາ ຣຍານ ແຕ ອັນ ຊາປຸ່ຮ ເຢຊູ ຕາ ເບີນ ອາຕີ ແຕ ບວຮ ຊື່ອ໌. ມາ ອັນ ອາຕີ ແຕ ປັຣນາຍ ຈຸ່ມ ພາຣີຊາຍ ກະ ຈຸ່ມ ຊາດູກາຍ. ");
INSERT INTO ncq_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ພໍກາ ເຢຊູ ມູ່ດ ຕຶ່ງ ກຣວາງ ແຈ່ະ ເມືອງ ກາຍຊາເຣຍ ພີລິບປອຍ, ອັນ ຕາແບີບ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ມັຮ ກວາຍ ປາຍ ເກົາ, ກອນ ເຢືາງ ແກີດ ກວາຍ, ລາ ເນົ່າ?\" ");
INSERT INTO ncq_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ໄລ່ ກັອຍ ຕາແອີຍ ປາຍ: \"ເບີນ ອັນ ກາ ປາຍ ອາຈານ ລາ ໂຢຮັນ, ອັນ ກາ ເກີ່ຍ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌. ເບີນ ອັນ ກາ ປາຍ ອາຈານ ລາ ເອລີຢາ. ກະ ເບີນ ອັນ ກາ ປາຍ ອາຈານ ລາ ເຢເຣມີຢາ ແຕີລາ ມານະ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ການໍ່ອ໌.\" ");
INSERT INTO ncq_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ເຢຊູ ຕາແບີບ ລັ່ຮ ໄລ່ ປາຍ: \"ມາ ເຍືາ ແອັນ ປາຍ ເກົາ ລາ ເນົ່າ?\" ");
INSERT INTO ncq_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ຊີໂມນ ເປໂຕ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ອາຈານ ລາ ກຣີດ, ອັນ ກາ ເຢືາງ ເຈົາຣາຊີ ຣຽຮ ໂອນ ຈ່ອຍ ອາມົ່ງ ກວາຍ. ອາຈານ ລາ ກອນ ເຢືາງ ເຈົາຣາຊີ, ກອນ ອັນ ກາ ອາມົ່ງ ເລືອຍໆ.\" ");
INSERT INTO ncq_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ເຈີ່ ເຢຊູ ອາຕີ ລັ່ຮ ເປໂຕ ປາຍ: \"ບຸ່ນ ລາລື່ ໄມ່, ຊີໂມນ, ກອນ ໂຢນາ! ຣານະ ປຍາຍ໌ ມັຮ ໄມ່ ປາຍ ໄນ່ ຕາ ແກີນ ລັ່ອຮ ແຕ ຣາງຶ່ຮ ກວາຍ, ມາ ອຶມປໍ່ ເກົາ ຕຶ່ງ ມັນລັ່ອງ ໂອນ ໄມ່ ດັງ ຣານະ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ເກົາ ອາຕີ ໄມ່, ໄມ່ ລາ ນ່ະ ຕາເມົາ, ນ່ະກັອຍ ໄມ່ ເບີນ ຣາມຶ່ຮ ເປໂຕ ແອັນ. ກະ ຍ່ອນ ໄມ່ ປາຍ ນ່ະກັອຍ, ເກົາ ໂອນ ຊາອຶ່ຍ ນະ ກວາຍ ມູ່ດ ຊາອຳ ເກົາ. ອຳນາດ ແຕ ເຢືາງ ຕາ ອໍ ຕາ ເຕ່ອ໌ ເຣືາບ ອຶນເຕົ່າ ໄລ່ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ເກົາ ໂອນ ໄມ່ ເບີນ ອຳນາດ ຕຶ່ງ ຈຸ່ມ ກາ ເຢືາງ ເຈົາຣາຊີ ຊົດ. ນ່ະກັອຍ ຣາມຶ່ຮ ອຶນເຕົ່າ ໄມ່ ປຣ່ອມ, ເຢືາງ ເຈົາຣາຊີ ປຣ່ອມ ເຕ່ ຣາມຶ່ຮ ກັອຍ. ກະ ຣາມຶ່ຮ ອຶນເຕົ່າ ໄມ່ ຕາ ເບີນ ປຣ່ອມ, ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ປຣ່ອມ ເຕ່ ຣາມຶ່ຮ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ອັນ ປາຕັບ ມູ່ ກາ ຣຍານ ແຕ ອັນ ອຶນໂຈຍ ໂອນ ເນົ່າ ການໍ່ອ໌ ດັງ ປາຍ ອັນ ລາ ກຣີດ, ອັນ ກາ ເຢືາງ ເຈົາຣາຊີ ຣຽຮ ໂອນ ຈ່ອຍ ອາມົ່ງ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ແວັດ ກັອຍ ເຢຊູ ຕາແບິ ອາຕີ ແຈງ ລາລື່ ໂອນ ມູ່ ກາ ຣຍານ ແຕ ອັນ ດັງ. ອັນ ປາຍ: \"ເກົາ ອຶງເຄາະ ເຈົາ ປໍ ເມືອງ ເຢຣູຊາເລັມ. ອຶນຕຸ ກັອຍ ເກົາ ອຶງເຄາະ ຈີວ໌ ຊາອຶ່ຍ ຣາມຶ່ຮ ຕຸ່ຮ ກັ່ດ. ມັຮ ກວາຍ ເທົາແກ ຈຸ່ມເຈືອ, ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ກະ ມັຮ ກວາຍ ອາຕີ ຄານອດ, ໄລ່ ຕະ ເກົາ. ເຈີ່ ໄລ່ ກາຈີດ ເກົາ, ມາ ແຕີ່ອ໌ ຕາໄງ ໄປ ເກົາ ອາມົ່ງ ລັ່ຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ແວັດ ກັອຍ ເປໂຕ ຕະ ອຶນຕີ ແອີງ ມານະ ອັນ ກະ ເຢຊູ. ເຈີ່ ອັນ ກາແອັຮ ເຢຊູ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ເກົາ ແຊອ໌ ຣານະ ໄນ່ ອຶນໂຈຍ ໂອນ ແຕີ່ອ໌ ປໍ ອຶນເຈົາ!\" ");
INSERT INTO ncq_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ມາ ເຢຊູ ກູລຍານ ກະ ອາຕີ ເປໂຕ ປາຍ: \"ໄມ່ ເປາະ ເຢີ່ງ ແຕ ເກົາ, ຊາຕານ! ໄມ່ ອີ ກາຕັງ ເກົາ, ຕາ ໂອນ ຕະ ແວັດ ຣານະ ເກົາ! ໄມ່ ຕາ ເບີນ ຄຶ່ດ ນ່ະ ເຢືາງ ເຈົາຣາຊີ! ມາ ໄມ່ ຄຶ່ດ ນ່ະ ກວາຍ ຊັອງ!\" ");
INSERT INTO ncq_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ແວັດ ກັອຍ ເຢຊູ ອາຕີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ຄັນ ເບີນ ກວາຍ ອາແລ່ະ ມາ ຢໍອ໌ ອີ ປວາຍ ເກົາ, ອຶງເຄາະ ອັນ ຕັຮ ຣານະ ອັນ ເບີມ. ອຶງເຄາະ ອັນ ອີດ ໂດລ ອາລ່ອງ ຊັງກັງ ອັນ ເບີມ, ກະ ອຶງເຄາະ ອັນ ປວາຍ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ກວາຍ ອາແລ່ະ ມາ ປາຊິ ຣາງຶ່ຮ ອັນ ຕຶ່ງ ແດີຍ ໄນ່, ຣາງຶ່ຮ ກວາຍ ກັອຍ ແກີດ ປິ່ດ. ມາ ກວາຍ ອາແລ່ະ ມາ ຈີວ໌ ປິ່ດ ຣາງຶ່ຮ ອັນ ຕຶ່ງ ແດີຍ ໄນ່ ຍ່ອນ ອັນ ປວາຍ ຣານະ ເກົາ, ກວາຍ ກັອຍ ເບີນ ອາມົ່ງ. ");
INSERT INTO ncq_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ຄັນ ກວາຍ ອາແລ່ະ ມາ ເບີນ ຕຸ່ກ ມາເລ່ກ ແຊກ ມາການ ເກຣີ່ງ ເກຣົ່າ ຕຶ່ງ ແດີຍ ໄນ່ ຕາ ເບີນ ແອິ ອຶນເຕົ່າ, ມາ ອັນ ປິ່ດ ຊັອງ ຣາງຶ່ຮ ອັນ ເບີມ, ອຶນເຕົ່າ ລະ ເກືາ ໂອນ ອັນ? ມາ ເບີນ ເກຣີ່ງ ອຶນເຕົ່າ ກາ ກວາຍ ເຕ່ອ໌ ຣາປຽນ ໂອນ ເບີນ ອາມົ່ງ ຊົດ ແດີຍ ເລີ່ຍ ກູມໍ? ");
INSERT INTO ncq_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ປັຣແນີ ມັນເຕຣືາ ກອນ ເຢືາງ ແກີດ ກວາຍ ແຕີ່ອ໌ ລັ່ຮ ມັນຕຸ ກະ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ, ກະ ອັນ ເບີນ ອຳນາດ ອາງອື່ຣ ແຕ ອຶມປໍ່ ອັນ ຕຶ່ງ ມັນລັ່ອງ. ບັອງ ກາ ກັອຍ ອັນ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ ເບີນ ເກືາ ໄລ່, ຕາປູ່ນ ມັຮ ຣານະ ໄລ່ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ເບີນ ກວາຍ ກາ ຕາຢຶ່ງ ແອີດ ອຶນໄນ່ ຊານໍ່, ໄລ່ ຕາ ເບີນ ກູຈີດ ຢວາຮ ເຕົ່າ ແຕີ່ອ໌ ໄລ່ ເບີນ ເຮີມ ກອນ ເຢືາງ ແກີດ ກວາຍ ຕະ ຊົດ.\" ");
INSERT INTO ncq_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ແວັດ ຕາປັ່ດ ຕາໄງ ແອັນ ເຢຊູ ເດີງ ເປໂຕ, ກະ ໄລ່ ບາຣ ນະ ແຊມອາຍ ຢາໂກໂບ ກະ ໂຢຮັນ ຊັອຮ ກະ ອັນ ຕຶ່ງ ກົຮ ກາ ຕີ່. ແອີງ ໄລ່ ປູນ ນະ ແຕິ່ ແອີດ ອຶງກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ເຈີ່ ໄລ່ ເຮີມ ຈະ ເຢຊູ ປຽນ ແກີດ ອຶມພາ ແອັນ ຢັ່ຮ ເມືາງ ໄລ່ ໄປ ນະ ກັອຍ. ມາມ ອັນ ປາເລືາງ ນ່ະ ມັ່ດ ມານາງ. ກະ ຕຳປັອກ ອັນ ແກີດ ກຼໍອ໌ ຊັຣມຍາລ ມັ່ດ. ");
INSERT INTO ncq_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ກະ ໄລ່ ໄປ ນະ ກັອຍ ເຮີມ ໂມເຊ ກະ ເອລີຢາ ຕະ ອຶນຕີ ກະ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ເຈີ່ ເປໂຕ ອາຕີ ເຢຊູ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ຮິ ແອີດ ອຶນໄນ່ ລາ ອໍ ລາລື່. ຄັນ ອຶນເຈົາ ອີ ເບີນ, ຮິ ອີ ຕະ ໄປ ລຳ ຊູ, ມານຳ ລາ ຕະ ໂອນ ອຶນເຈົາ, ມານຳ ລາ ຕະ ໂອນ ໂມເຊ, ກະ ມານຳ ແອັນ ລາ ຕະ ໂອນ ເອລີຢາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ບັອງ ກາ ເປໂຕ ອຶນນັ່ອງ ປາຍ, ເບີນ ຣາມິ່ລ ກຼໍອ໌ ຕວມ ດໍອ໌ ຈະ ໄລ່. ກະ ເບີນ ຊຽງ ຊາບາວ ອາຕີ ແຕ ຣາມິ່ລ ກັອຍ ປາຍ: \"ໄນ່ ລາ ກອນ ເກົາ ກາ ເກົາ ອາໂຢ່ະ ລາລື່. ອຶນເຕົ່າ ອັນ ຕະ, ລາ ເກົາ ຣໍ່ອ໌ ອຶນແຍ່ະ. ກະ ອຶນເຕົ່າ ອັນ ອາຕີ, ອຶງເຄາະ ເຍືາ ຊາງັດ ອັນ ນໍ!\" ");
INSERT INTO ncq_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ພໍກາ ໄລ່ ໄປ ນະ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ຊັອງ ຊຽງ ກັອຍ, ໄລ່ ຄຣາບ ຕຶ່ງ ກູແຕອ໌. ");
INSERT INTO ncq_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ເຢຊູ ແຕີ່ອ໌ ຊາປ່ະ ໄລ່ ກັອຍ, ກະ ອັນ ປາຍ: \"ເຍືາ ຢວຣ ຕາຢຶ່ງ! ອຶນໂຈຍ ອຶງກັອຮ ອຶນເຕົ່າ!\" ");
INSERT INTO ncq_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ນ່ະກັອຍ ໄລ່ ຕາເງີ່ອ໌ ອາຊັອຮ, ເຈີ່ ໄລ່ ເຮີມ ແອີງ ມານະ ເຢຊູ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ບັອງ ກາ ໄລ່ ກັອຍ ແຊງ ແຕ ກົຮ, ເຢຊູ ປາຕັບ ໄລ່ ໄປ ນະ ກັອຍ ປາຍ: \"ເຍືາ ອຶນໂຈຍ ອາຕີ ໂອນ ກວາຍ ການໍ່ອ໌ ດັງ ມັຮ ຣາມຶ່ຮ ເຍືາ ເຮີມ, ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ເກົາ ກອນ ເຢືາງ ແກີດ ກວາຍ ກູຈີດ ເຈີ່ ອາມົ່ງ ລັ່ຮ ແຕ ປີ່ງ.\" ");
INSERT INTO ncq_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ເຈີ່ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ຕາແບີບ ອັນ ປາຍ: \"ນານ່ະ ກວາຍ ອາຕີ ຄານອດ ປາຍ ເອລີຢາ ອຶງເຄາະ ແຕີ່ອ໌ ອຶນໂຍ່ງ ກຣີດ?\" ");
INSERT INTO ncq_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ເມ່ນ ເຈີ່ ເອລີຢາ ແຕີ່ອ໌ ອຶນໂຍ່ງ, ໂອນ ອາຕຶ່ ກູ່ ຣາມຶ່ຮ ແກີດ ຕາໄມ ລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ມາ ເກົາ ອາຕີ ເຍືາ, ເອລີຢາ ແຕີ່ອ໌ ເຈີ່, ມາ ກວາຍ ຕາ ເບີນ ດັງ ກະ ຕາ ເບີນ ຊາກັ່ລ ອັນ. ມາ ຣານະ ອຶນເຕົ່າ ເນົ່າ ຢໍອ໌ ອີ ຕະ ໂຈະ ອັນ, ເນົ່າ ຕະ ເຈີ່. ປັຣແນີ ມັນເຕຣືາ ໄລ່ ອີ ຕະ ມູເຈິງ ກັອຍ ເຕ່ ໂຈະ ເກົາ, ກອນ ເຢືາງ ແກີດ ກວາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ແວັດ ກັອຍ, ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ດັງ ເຢຊູ ປາຍ ເອລີຢາ ໄນ່ ລາ ຊາກຳ ແຕ ໂຢຮັນ, ອັນ ກາ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌. ");
INSERT INTO ncq_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ບັອງ ກາ ໄລ່ ກັອຍ ເຈົາ ລັ່ຮ ປໍ ກວາຍ ກຼຶ່ງ, ເບີນ ມານະ ຣາເລົາ ແຕີ່ອ໌ ປໍ ເຢຊູ. ອັນ ກຼຸ່ ຣາໂກລ, ກະ ອັນ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","\"ອຶນເຈົາ ເອີຍ! ເກົາ ແຊອ໌ ອຶນເຈົາ ອາໂຢ່ະ ຕະ ກອນ ຣາເລົາ ເກົາ, ຍ່ອນ ກອນ ເກົາ ເບີນ ອາອີ່ ຢຸ່ຮ ຕາຊອງ. ແຕີ່ອ໌ ອັນ ມຶ່ຮ ອັນ ແດິມ ຕຶ່ງ ອູ່ຍຮ ແຕີລາ ຕຶ່ງ ແດີອ໌. ");
INSERT INTO ncq_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ເກົາ ເດີງ ອັນ ປໍ ມູ່ ກາ ຣຍານ ແຕ ອຶນເຈົາ ເຈີ່, ມາ ໄລ່ ກັອຍ ຕາ ເຕ່ອ໌ ປົວ.\" ");
INSERT INTO ncq_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ນ່ະກັອຍ ເຢຊູ ຕາແອີຍ ປາຍ: \"ເຍືາ ກາ ແອີດ ຕຶ່ງ ແດີຍ ໄນ່ ເອີຍ! ເຍືາ ຕາ ເບີນ ຊາອຳ, ກະ ເຍືາ ລາ ກວາຍ ກາ ເງືານ ລາລື່. ອຶນນັ່ອງ ດູ່ນ ມາແລ່ະ ເກົາ ແອີດ ກະ ເຍືາ ກະ ຈີວ໌ ເຍືາ ຕາ ເບີນ ຊາອຳ? ເດີງ ໂອນ ກັຣແນນ ກັອຍ ແຕີ່ອ໌ ປໍ ເກົາ ແມຮ!\" ");
INSERT INTO ncq_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ເຈີ່ ເຢຊູ ຕູ່ຍຮ ເຢືາງ ຕາ ອໍ ໂອນ ອັນ ລັ່ອຮ ແຕ ຈະ ກັຣແນນ ກັອຍ. ພໍກາ ເຢືາງ ຕາ ອໍ ລັ່ອຮ ແຕ ຈະ ກັຣແນນ ກັອຍ, ກັຣແນນ ກັອຍ ແກີດ ແບຣັຮ ແຕິ່. ");
INSERT INTO ncq_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ແວັດ ແຕ ກັອຍ, ເຢຊູ ແອີດ ມັນຕຸ ກະ ແອີງ ມູ່ ກາ ຣຍານ ແຕ ອັນ. ໄລ່ ຕາແບີບ ເຢຊູ ປາຍ: \"ນານ່ະ ແຕ ຮິ ຕາ ເຣືາບ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ກັອຍ?\" ");
INSERT INTO ncq_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ຣານະ ກັອຍ ລາ ຍ່ອນ ເຍືາ ຕາ ເບີນ ຊາອຳ. ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ຄັນ ເຍືາ ຊາອຳ, ເບີນ ມາຮ ມູ ກຼອງ ປາກາດ ຊັອງ, ເຕ່ອ໌ ເຍືາ ແປຣີ ກົຮ ໄນ່ ປາຍ: 'ເອົາ ໄມ່ ຊີອ໌ ແຕ ອຶນໄນ່, ແອີດ ປໍ ອຶນຕຸ ກັອຍ ແອັນ!' ຄັນ ເຍືາ ຊາອຳ, ກົຮ ກັອຍ ລື່ ເປາະ. ກະ ຣານະ ອຶນເຕົ່າ ເຍືາ ຢໍອ໌ ອີ ຕະ, ແກີດ ຣານະ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ກວາຍ ອາແລ່ະ ກາ ຢໍອ໌ ອີ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ນ່ະໄນ່, ກວາຍ ກັອຍ ອຶງເຄາະ ອົດ ຊັຣນາ ກະ ເກົາແຊອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ບັອງ ກາ ອຶນແຍ່ະ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ໂຣ່ມ ຕຶ່ງ ແຄງ ຄາລີເລ, ເຢຊູ ອາຕີ ໄລ່ ປາຍ: \"ແຈ່ະ ອີ ແຕີ່ອ໌ ເຈີ່ ເນົ່າ ອີ ມ່ອບ ເກົາ, ກອນ ເຢືາງ ແກີດ ກວາຍ, ປໍ ອາຕີ ກວາຍ ຊົດ. ");
INSERT INTO ncq_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ໄລ່ ກາຈີດ ເກົາ, ມາ ແຕີ່ອ໌ ຕາໄງ ໄປ ເກົາ ອາມົ່ງ ລັ່ຮ.\" ນ່ະກັອຍ ມູ່ ກາ ຣຍານ ແຕ ອັນ ຊັອງ ຕຸ່ຮ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ບັອງ ກາ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ແຕີ່ອ໌ ປໍ ເມືອງ ກາເປນາອູມ, ເບີນ ກວາຍ ແຕ ດຸງ ຊາງ ປື່ດ ແປຣີ ມັຮ ກວາຍ ອິດຊະຣາເອລ ອຶງເຄາະ ໂອນ ປຣະ ຈ່ອຍ ຕຶ່ງ ດຸງ ຊາງ ປວາຍ ຄານອດ ໂມເຊ. ໄລ່ ແຕີ່ອ໌ ປໍ ເປໂຕ ກະ ໄລ່ ຕາແບີບ ອັນ ປາຍ: \"ອາຈານ ໄມ່ ໂອນ ເຕ່ ປຣະ ປໍ ດຸງ ຊາງ, ມາ ຕາ ເບີນ?\" ");
INSERT INTO ncq_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ເປໂຕ ຕາແອີຍ ປາຍ: \"ອັນ ລາ ໂອນ ເຕ່.\" ພໍກາ ເປໂຕ ມູ່ດ ຕຶ່ງ ດຸງ, ເຢຊູ ຕາແບີບ ອັນ ອຶນໂຍ່ງ ປາຍ: \"ຊີໂມນ ເອີຍ! ອຶນເຕົ່າ ໄມ່ ຄຶ່ດ, ມັຮ ເຕືາວ ປັຣເຍືາ ຕຶ່ງ ແດີຍ ໄນ່ ປາໂຣມ ອີດ ປຣະ ແຕ ເນົ່າ? ໄລ່ ອີດ ປຣະ ແຕ ກອນ ໄລ່ ເບີມ, ແຕີລາ ແຕ ກວາຍ ການໍ່ອ໌?\" ");
INSERT INTO ncq_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ເປໂຕ ຕາແອີຍ ເຢຊູ ປາຍ: \"ໄລ່ ອີດ ແຕ ກວາຍ ການໍ່ອ໌.\" ເຈີ່ ເຢຊູ ປາຍ ແອັນ: \"ຄັນ ນ່ະກັອຍ, ມັຮ ກອນ ໄລ່ ເບີມ, ໄລ່ ຕາ ເບີນ ຕຸ່ຮ ໂອນ ປຣະ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ມາ ຍ່ອນ ໄຮ ຕາ ຢໍອ໌ ອີ ໂອນ ໄລ່ ກາ ປາໂຣມ ປຣະ ກັອຍ ຊັອງ ຕາ ຣໍ່ອ໌ ຣາງຶ່ຮ ກະ ໄຮ, ໄມ່ ເປາະ ຕາໄບຮ ອາກາ ປໍ ທາເລ ຣາປັ່ງ. ອາກາ ກາ ຕາແບິ ໄມ່ ເບີນ, ໄມ່ ກັຮ ແບອ໌. ເຈີ່ ໄມ່ ຣາມົຮ ມູ ກຼອງ ປຣະ ຕຶ່ງ ແບອ໌ ອາກາ ກັອຍ. ປຣະ ກັອຍ ກູ່ ໂອນ ໄຮ ຈ່ອຍ ດຸງ ຊາງ. ເຈີ່ ໄມ່ ເດີງ ອາເຈົາ ໂອນ ປໍ ໄລ່ ກາ ປາໂຣມ ປຣະ ຈ່ອຍ ດຸງ ຊາງ ປື່ດ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ບັອງ ກັອຍ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ແຕີ່ອ໌ ປໍ ອັນ, ເຈີ່ ໄລ່ ຕາແບີບ ອັນ ປາຍ: \"ຕຶ່ງ ຈຸ່ມ ກາ ເຢືາງ ເຈົາຣາຊີ ຊົດ, ເນົ່າ ແກີດ ປື່ດ ກາເລີຍ ອຶນແຍ່ະ?\" ");
INSERT INTO ncq_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ເຢຊູ ກູອ໌ ມານະ ກັຣແນນ ໂອນ ອັນ ແອີດ ອຶນດີ ອຶນແຍ່ະ ໄລ່ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ກະ ອັນ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ຄັນ ເຍືາ ມາ ຕາ ເບີນ ແກີດ ຣາງຶ່ຮ ຕາໄມ, ກະ ຕາ ເບີນ ແກີດ ນ່ະ ກັຣແນນ ໄນ່, ເຍືາ ຕາ ເຕ່ອ໌ ມູ່ດ ຕຶ່ງ ຈຸ່ມ ກາ ເຢືາງ ເຈົາຣາຊີ ຊົດ. ");
INSERT INTO ncq_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ກວາຍ ອາແລ່ະ ມາ ອາແຊງ ຈະ ອັນ ເບີມ ໂອນ ແກີດ ນ່ະ ກັຣແນນ ໄນ່, ກວາຍ ກັອຍ ແກີດ ປື່ດ ແກຼີຍ ອຶນແຍ່ະ ຕຶ່ງ ຈຸ່ມ ກາ ເຢືາງ ເຈົາຣາຊີ ຊົດ. ");
INSERT INTO ncq_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ກະ ກວາຍ ອາແລ່ະ ມາ ຣັ່ບ ອໍ ມານະ ກັຣແນນ ມາຮ ໄນ່ ຍ່ອນ ອັນ ຊາອຳ ເກົາ, ກວາຍ ກັອຍ ຣັ່ບ ອໍ ກາ ເກົາ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","\"ກວາຍ ອາແລ່ະ ມາ ປັຣຕຶ່ ມານະ ກັຣແນນ ແກດ ມາຮ ກັຣແນນ ໄນ່ ກາ ຊາອຳ ເກົາ ເຈີ່, ໂອນ ກັຣແນນ ກັອຍ ຕະ ໂລ່ຍຮ, ຄາອ໌ ອີດ ຕາເມົາ ປື່ດ ຊັດ ໂຈະ ຕຶ່ງ ຕາກອງ ອັນ ກັອຍ ເຈີ່ ອາປັອງ ຕັຮ ອັນ ຕຶ່ງ ທາເລ. ");
INSERT INTO ncq_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ກັ່ດ ລາລື່ ໂອນ ກວາຍ ຕຶ່ງ ແດີຍ ໄນ່, ຍ່ອນ ເບີນ ຊາອຶ່ຍ ຣາມຶ່ຮ ອີ ລ່ອງ ໄລ່ ໂອນ ຕະ ໂລ່ຍຮ. ມັຮ ຣາມຶ່ຮ ກັອຍ ແຕີ່ອ໌ ເລືອຍໆ, ມາ ບາບ ລາລື່ ແຕີ່ອ໌ ປໍ ກວາຍ ກາ ອີ ປັຣຕຶ່ ກວາຍ ການໍ່ອ໌ ຕະ ໂລ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","\"ຄັນ ອາຕີ ແຕີລາ ອາເຢີງ ເຍືາ ມາ ເດີງ ເຍືາ ຕະ ໂລ່ຍຮ, ອຶງເຄາະ ເຍືາ ກັອຮ ແກຼງ ຕັຮ ອາຕີ ແຕີລາ ອາເຢີງ ເຍືາ. ຄາອ໌ ເຍືາ ແອີດ ອາມົ່ງ ເບີນ ມູ່ດ ຕຶ່ງ ອຶນຕຸ ເຢືາງ ເຈົາຣາຊີ ຊົດ ເບີນ ອາຕີ ແຕີລາ ອາເຢີງ ຕາລິ່ດ, ລາ ອໍ ກາເລີຍ ແຕ ເບີນ ກູ່ ອາຕີ ອາເຢີງ ບາຣ ລໍາ ມາ ເຢືາງ ເຈົາຣາຊີ ແກຼງ ເຍືາ ຕຶ່ງ ປຣຸ່ງ ອູ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ກະ ຄັນ ກຼອງ ມັ່ດ ເຍືາ ມາ ເດີງ ໂອນ ເຍືາ ຕະ ໂລ່ຍຮ, ອຶງເຄາະ ເຍືາ ກູໄລອ໌ ແກຼງ ຕັຮ ກຼອງ ມັ່ດ ກັອຍ. ເຍືາ ແອີດ ອາມົ່ງ ເບີນ ມູ່ດ ຕຶ່ງ ອຶນຕຸ ເຢືາງ ເຈົາຣາຊີ ຊົດ ເບີນ ແອີງ ມວຍ ກຼອງ ມັ່ດ ຊັອງ, ອໍ ກາເລີຍ ແຕ ເບີນ ກູ່ ບາຣ ກຼອງ ມັ່ດ ມາ ເຢືາງ ເຈົາຣາຊີ ແກຼງ ເຍືາ ຕຶ່ງ ປຣຸ່ງ ອູ່ຍຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","\"ເຍືາ ລາວັ່ງ ໂອນ ອໍ! ອຶນໂຈຍ ພາມາດ ມານະ ອາແລ່ະ ແຕ ມັຮ ກັຣແນນ ໄນ່. ຍ່ອນ ເກົາ ອາຕີ ເຍືາ ປາຍ: ເບີນ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ຕຶ່ງ ມັນລັ່ອງ ກຍາອ໌ ເລືອຍໆ ກັຣແນນ ກັອຍ. ມັຮ ເທວາດາ ກັອຍ, ໄລ່ ແອີດ ເລືອຍໆ ຢັ່ຮ ມັ່ດ ອຶມປໍ່ ເກົາ ຕຶ່ງ ມັນລັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ຍ່ອນ ກອນ ເຢືາງ ແກີດ ກວາຍ ແຕີ່ອ໌ ຢໍອ໌ ອີ ຈ່ອຍ ອາມົ່ງ ມັຮ ກວາຍ ກາ ແກຼິ ຣານາ. ");
INSERT INTO ncq_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","\"ນານ່ະ ເຍືາ ຄຶ່ດ? ຄັນ ເບີນ ກວາຍ ອາແລ່ະ ກາ ເບີນ ມວຍ ຣ່ອຍ ລຳ ແກະ, ມາ ແກະ ມານຳ ແກຼິ ຣານາ, ນານ່ະ ກວາຍ ກັອຍ ອີ ຕະ? ອັນ ດໍອ໌ ແກະ ກາ ຕາເກ່ຮ ຈິ່ດ ຕາເກ່ຮ ລຳ ກັອຍ ຕຶ່ງ ກົຮ, ເຈີ່ ອັນ ເປາະ ຈໍ່ອ໌ ມານຳ ແກະ ກາ ແກຼິ ຣານາ ກັອຍ ບໍ? ");
INSERT INTO ncq_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ມາ ຄັນ ອັນ ຣາມົຮ ລັ່ຮ ແກະ ກັອຍ, ອັນ ຊັອງ ຣໍ່ອ໌ ແຕ ແກະ ກັອຍ ກາເລີຍ ແຕ ອັນ ຊັອງ ຣໍ່ອ໌ ແຕ ຕາເກ່ຮ ຈິ່ດ ຕາເກ່ຮ ລຳ ກາ ຕາ ເບີນ ປິ່ດ. ");
INSERT INTO ncq_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ມູເຈິງ ກັອຍ ເຕ່ ອຶມປໍ່ ເຍືາ ຕຶ່ງ ມັນລັ່ອງ ຕາ ຢໍອ໌ ອີ ໂອນ ປິ່ດ ມານະ ແຕ ກັຣແນນ ແກດໆ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","\"ຄັນ ເບີນ ມານະ ແຊມອາຍ ມາ ຕະ ໂລ່ຍຮ ໂຈະ ໄມ່, ອຶງເຄາະ ໄມ່ ເປາະ ກາແອັຮ ກະ ອາຕີ ອັນ, ແອີງ ເຍືາ ບາຣ ນະ ຊັອງ. ຄັນ ອັນ ຊາງັດ ປັຣນາຍ ໄມ່, ອັນ ແກີດ ລັ່ຮ ແຊມອາຍ ໄມ່ ຊາ. ");
INSERT INTO ncq_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ມາ ຄັນ ອັນ ຕາ ເບີນ ຊາງັດ ປັຣນາຍ ໄມ່, ເຈີ່ ໄມ່ ເດີງ ມານະ ແຕີລາ ບາຣ ນະ ແອັນ ເປາະ ລັ່ຮ ປໍ ອັນ. ຕະ ນ່ະກັອຍ ເຍືາ ຕາປູ່ນ ຄານອດ ເຢືາງ ເຈົາຣາຊີ ປາຕັບ ໂອນ ເຕ່ອ໌ ດັງ ແຈງ ກວາຍ ອາແລ່ະ ກາ ເບີນ ໂລ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ມາ ຄັນ ອັນ ຕາ ເບີນ ປຣ່ອມ ຊາງັດ ລັ່ຮ ບາຣ ໄປ ນະ ກັອຍ, ເຈີ່ ເຍືາ ອາຕີ ໂອນ ອຶນແຍ່ະ ມູ່ ກາ ຊາອຳ ດັງ ເຕ່. ກະ ຄັນ ອັນ ຕາ ເບີນ ຕະ ຕາປູ່ນ ປັຣນາຍ ມູ່ ກາ ຊາອຳ ອາຕີ, ເຈີ່ ເຍືາ ຕະ ໂຈະ ກວາຍ ກັອຍ ນ່ະ ອັນ ລາ ກວາຍ ກາ ຕາ ເບີນ ຊາອຳ, ແຕີລາ ນ່ະ ອັນ ລາ ກວາຍ ກາ ອີດ ປຣະ ປາຊີ. ");
INSERT INTO ncq_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","\"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ຣາມຶ່ຮ ອຶນເຕົ່າ ເຍືາ ປຣ່ອມ, ເຢືາງ ເຈົາຣາຊີ ປຣ່ອມ ຣາມຶ່ຮ ກັອຍ ເຕ່. ກະ ຣາມຶ່ຮ ອຶນເຕົ່າ ເຍືາ ຕາ ເບີນ ປຣ່ອມ, ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ປຣ່ອມ ເຕ່ ຣາມຶ່ຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ກະ ເກົາ ອາຕີ ຕານັ່ອງ ແອັນ ໂອນ ເຍືາ ປາຍ: ຄັນ ບາຣ ນະ ເຍືາ ກາ ແອີດ ຕຶ່ງ ກູແຕອ໌ ໄນ່, ມາ ປຣ່ອມ ແຊອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ, ຣາມຶ່ຮ ອຶນເຕົ່າ ເຍືາ ແຊອ໌, ອຶມປໍ່ ເກົາ ຕຶ່ງ ມັນລັ່ອງ ໂອນ ເຍືາ ເບີນ ຣາມຶ່ຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ກະ ຄັນ ເບີນ ບາຣ ໄປ ນະ ແອີດ ໂຣ່ມ ມັນຕຸ ຍ່ອນ ໄລ່ ອີ ປວາຍ ເກົາ, ເກົາ ແອີດ ມັນຕຸ ເຕ່ ກະ ໄລ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ແວັດ ກັອຍ ເປໂຕ ແຕີ່ອ໌ ປໍ ເຢຊູ ກະ ຕາແບີບ ອັນ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ອຶນຊິ ເຮີບ ແຊມອາຍ ເກົາ ຕະ ໂລ່ຍຮ ໂຈະ ເກົາ, ນ່ະ ເກົາ ຕັຮ ໂລ່ຍຮ ກັອຍ? ຕາປູ່ລ ເຮີບ ຊັອງ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ມາ ເຢຊູ ຕາແອີຍ ລັ່ຮ ໂຈະ ອັນ ປາຍ: \"ເກົາ ຕາ ເບີນ ປາຍ ແອີງ ຕາປູ່ລ ເຮີບ ຊັອງ. ອຶງເຄາະ ເຍືາ ຕັຮ ເບີນ ຕາປູ່ລ ຈິ່ດ ຕາປູ່ລ ເຮີບ.\" ");
INSERT INTO ncq_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","\"ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ລາ ນ່ະ ມານະ ກວາຍ ເຕືາວ ປັຣເຍືາ. ເຕືາວ ປັຣເຍືາ ກັອຍ ຢໍອ໌ ອີ ຕອມ ລັ່ຮ ປຣະ ແຕ ກວາຍ ກາ ຕູ່ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ບັອງ ກາ ກັອຍ ເນົ່າ ເດີງ ປໍ ອັນ ມານະ ກວາຍ ກາ ຕູ່ ເຕືາວ ປັຣເຍືາ ມວຍ ຈິ່ດ ປັ່ນ ແນນ ປຣະ. ");
INSERT INTO ncq_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ອັນ ຕາ ເບີນ ອຶນເຕົ່າ ອີ ກູລັຮ ນັ່ອງ ປຣະ ເຕືາວ ປັຣເຍືາ ກັອຍ. ນ່ະກັອຍ ເຕືາວ ປັຣເຍືາ ແປຣີ ໂອນ ໄລ່ ກັອຍ ເດີງ ຈິ ອັນ, ໂອນ ແກີດ ຊູລ ເນົ່າ, ກະ ຈິ ກອນ ລາກວຍ ອັນ ກະ ມູ່ນ ອັນ ແຮີ. ອຶນແຍ່ະ ປຣະ ເກືາ ກັອຍ, ເຈີ່ ອີດ ກູລັຮ ລັ່ຮ ປຣະ ກາ ຕູ່ ເຕືາວ ປັຣເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ມາ ກວາຍ ກາ ຕູ່ ກັອຍ, ອັນ ກຼຸ່ ຣາໂກລ ຢັ່ຮ ເມືາງ ເຕືາວ ປັຣເຍືາ ກັອຍ, ອັນ ປາຍ: 'ແຊອ໌ ກູກຸຮ ເຕືາວ ປັຣເຍືາ. ແຊອ໌ ເຕືາວ ປັຣເຍືາ ອຶນໂຈຍ ກຸນເຕົາ ຢວາຮ. ເກົາ ແຊອ໌ ເປາະ ຈໍ່ອ໌ ເວືາຍ, ເຈີ່ ເກົາ ກູລັຮ ອຶນແຍ່ະ ໂອນ ເຕືາວ ປັຣເຍືາ.' ");
INSERT INTO ncq_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ພໍກາ ເຕືາວ ປັຣເຍືາ ກັອຍ ຊັອງ ກວາຍ ກັອຍ ກ່ອບ ນ່ະກັອຍ, ອັນ ຊັອງ ອາໂຢ່ະ ຕະ ໂຈະ ກວາຍ ກັອຍ. ເຈີ່ ອັນ ຕັຮ ອຶນແຍ່ະ ມັຮ ປຣະ ກາ ກວາຍ ກັອຍ ຕູ່ ອັນ. ເຈີ່ ອັນ ໂອນ ກວາຍ ກັອຍ ເຈົາ. ");
INSERT INTO ncq_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","\"ກວາຍ ກັອຍ ລັ່ອຮ ແຕ ເຕືາວ ປັຣເຍືາ ກັອຍ; ເຈີ່ ອັນ ຣາມົຮ ມານະ ເຢົ່າ ອັນ ກາ ຕູ່ ອັນ. ເຢົ່າ ກັອຍ ຕູ່ ອັນ ມວຍ ຣ່ອຍ ກຼອງ ປຣະ ອານາມ ຊັອງ. ອັນ ໂກບ ຕາກອງ ກວາຍ ກັອຍ; ເຈີ່ ອັນ ປາຍ: 'ໄມ່ ກູລັຮ ແຕິ່ ປຣະ ກາ ໄມ່ ຕູ່ ເກົາ.' ");
INSERT INTO ncq_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ກວາຍ ກາ ຕູ່ ກັອຍ ຄຣາບ ຕຶ່ງ ກູແຕອ໌; ເຈີ່ ແຊອ໌ ກ່ອບ ອັນ ປາຍ: 'ແຊອ໌ ໄມ່ ອຶນໂຈຍ ກຸນເຕົາ ຢວາຮ. ເກົາ ແຊອ໌ ເປາະ ຈໍ່ອ໌ ເວືາຍ, ເຈີ່ ເກົາ ກູລັຮ ອຶນແຍ່ະ ໂອນ ໄມ່.' ");
INSERT INTO ncq_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ມາ ອັນ ຕາ ປຣ່ອມ. ອັນ ໂອນ ເນົ່າ ໂກບ ກວາຍ ກາ ຕູ່ ກັອຍ, ໂຈະ ຕຶ່ງ ກໍ່ອ໌ ເຕົ່າ ແຕີ່ອ໌ ກວາຍ ກັອຍ ກູລັຮ ອຶນແຍ່ະ ປຣະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ພໍກາ ກວາຍ ການໍ່ອ໌ ກາ ຕະ ຣານະ ເຕືາວ ປັຣເຍືາ ກັອຍ ເຮີມ ອັນ ຕະ ນ່ະກັອຍ, ໄລ່ ຊັອງ ຕຸ່ຮ ລາລື່. ເຈີ່ ໄລ່ ເຈົາ ອາຕີ ລັ່ຮ ເຕືາວ ປັຣເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ເຈີ່ ເຕືາວ ປັຣເຍືາ ກູອ໌ ລັ່ຮ ກວາຍ ກັອຍ. ອັນ ປາຍ ໂຈະ ກວາຍ ກັອຍ: 'ໄມ່ ລາ ຕາ ອໍ ລາລື່. ເກົາ ຕັຮ ອຶນແຍ່ະ ປຣະ ກາ ໄມ່ ຕູ່ ເກົາ ຍ່ອນ ໄມ່ ກ່ອບ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ມາ ນານ່ະ ໄມ່ ຕາ ເບີນ ອາໂຢ່ະ ຕະ ລັ່ຮ ເຢົ່າ ມູເຈິງ ເກົາ ອາໂຢ່ະ ຕະ ໄມ່ ເຕ່?' ");
INSERT INTO ncq_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ເຕືາວ ປັຣເຍືາ ກັອຍ ຊັອງ ອຶງຄື່ນ ລາລື່. ເຈີ່ ອັນ ແປຣີ ເນົ່າ ໂຈະ ກວາຍ ກັອຍ ຕຶ່ງ ກໍ່ອ໌ ກະ ຕະ ຕຸ່ຮ ລາລື່ ໂຈະ ອັນ ເຕົ່າ ອັນ ກູລັຮ ອຶນແຍ່ະ ປຣະ ກາ ອັນ ຕູ່ ເຕືາວ ປັຣເຍືາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ເຈີ່ ເຢຊູ ອາຕີ ແອັນ: \"ມູເຈິງ ກັອຍ ເຕ່ ອຶມປໍ່ ເກົາ ຕຶ່ງ ມັນລັ່ອງ ຕະ ກະ ເຍືາ, ຄັນ ເຍືາ ຕາ ເບີນ ຕັຮ ໂລ່ຍຮ ແຊມອາຍ ເຍືາ ອຶນແຍ່ະ ແຕ ຣາງຶ່ຮ ເຍືາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ແວັດ ເຢຊູ ອາຕີ ປັຣນາຍ ກັອຍ, ອັນ ລັ່ອຮ ແຕ ແຄງ ຄາລີເລ, ເຈີ່ ມູ່ດ ປໍ ແຄງ ຢູດາຍ ແອັນ ຢັ່ຮ ອຶນຕົ່ຮ ຕາເລ່ ຈໍແດນ. ");
INSERT INTO ncq_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ແອີດ ອຶງກັອຍ ເບີນ ກຼຶ່ງ ກວາຍ ປວາຍ ອັນ, ກະ ເຢຊູ ປົວ ອຶນແຍ່ະ ກູ່ ຣາມຶ່ຮ ກາ ໄລ່ ກັອຍ ອາອີ່. ");
INSERT INTO ncq_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ເບີນ ກວາຍ ແຕ ຈຸ່ມ ພາຣີຊາຍ ແຕີ່ອ໌ ປໍ ເຢຊູ ຢໍອ໌ ອີ ລ່ອງ ຊາລີອ໌ ອັນ. ເຈີ່ ໄລ່ ຕາແບີບ ອັນ ປາຍ: \"ຕາປູ່ນ ຄານອດ ໄຮ, ເຕ່ອ໌ ມາ ຕາ ເບີນ ກວາຍ ຣາເລົາ ຕັຮ ລາກວຍ ອັນ, ຄັນ ອັນ ເບີນ ລາໂປຍຮ ແຕ ລາກວຍ ອັນ?\" ");
INSERT INTO ncq_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ເຢຊູ ຕາແອີຍ ລັ່ຮ ໄລ່: \"ເຍືາ ອານ ເຈີ່ ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ປາຍ: 'ແຕ ຕາແບິ ລາລື່ ເຢືາງ ເຈົາຣາຊີ ແຕງ ກວາຍ ຣາເລົາ ກະ ກວາຍ ມັນແຊມ ແຮີ.' ");
INSERT INTO ncq_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ກະ ເຢືາງ ເຈົາຣາຊີ ປາຍ ແອັນ ນ່ະໄນ່: 'ຍ່ອນ ແຕ ຣານະ ກັອຍ ກວາຍ ຣາເລົາ ອຶງເຄາະ ກາຢັ່ຮ ແຕ ອຶມເປ່ອ໌ ອຶມປໍ່, ເຈີ່ ແອີດ ຣາຕອຍ ມູ ຣາງຶ່ຮ ກະ ລາກວຍ ອັນ. ນ່ະກັອຍ ບາຣ ນະ ລາກວຍ ກະ ກາຢາອ໌ ກັອຍ ແກີດ ນ່ະ ມານະ ຊັອງ.' ");
INSERT INTO ncq_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ໄລ່ ກັອຍ ຕາ ເບີນ ແກີດ ນັ່ອງ ບາຣ ນະ. ມາ ໄລ່ ແກີດ ນ່ະ ມານະ ຊັອງ. ນ່ະກັອຍ, ຄັນ ເຢືາງ ເຈົາຣາຊີ ອາມົຮ ໂອນ ໄລ່ ແກີດ ລາກວຍ ກາຢາອ໌, ອຶນໂຈຍ ໂອນ ກວາຍ ອາແລ່ະ ກາຢັ່ຮ ໂອນ ໄລ່ ຣາຕັຮ ນັ່ອງ.\" ");
INSERT INTO ncq_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ກວາຍ ພາຣີຊາຍ ກັອຍ ຕາແບີບ ລັ່ຮ ເຢຊູ ປາຍ: \"ນານ່ະ ໂມເຊ ປາຕັບ ຮິ, ຄັນ ກວາຍ ອາແລ່ະ ມາ ຢໍອ໌ ອີ ຕັຮ ລາກວຍ ອັນ, ອຶງເຄາະ ກວາຍ ກັອຍ ຄຽນ ຕຶ່ງ ເຈຍ ມັຮ ຣານະ ກັອຍ ໂອນ ກວາຍ ການໍ່ອ໌ ດັງ? ນ່ະກັອຍ ເຕ່ອ໌ ອັນ ຕັຮ ລາກວຍ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ມາ ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ໂມເຊ ປາຕັບ ໂອນ ເຍືາ ເຕ່ອ໌ ຕັຮ ລາກວຍ ເຍືາ ລາ ຍ່ອນ ເຍືາ ເບີນ ຣາງຶ່ຮ ກັ່ອງ ລາລື່ ຕາ ຢໍອ໌ ອີ ຊາງັດ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ. ມາ ແຕ ຕາແບິ ເຢືາງ ເຈົາຣາຊີ ແຕງ ຕຸ່ກ ຣາມຶ່ຮ, ອັນ ຕາ ເບີນ ໂອນ ຕະ ນ່ະກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ມາ ເກົາ ອາຕີ ເຍືາ ປາຍ, ກວາຍ ອາແລ່ະ ກາ ຕັຮ ລາກວຍ ອັນ, ມາ ລາກວຍ ອັນ ຕາ ເບີນ ຕະ ໂລ່ຍຮ ຍ່ອນ ປັຣລື່ຍ ກະ ຣາເລົາ ການໍ່ອ໌, ເຈີ່ ອັນ ອີດ ມັນແຊມ ຕາໄມ ແອັນ, ອັນ ຕະ ໂລ່ຍຮ ໂຈະ ລາກວຍ ຕຍາ ອັນ, ມູເຈິງ ອັນ ເປາະ ປັຣລື່ຍ. ");
INSERT INTO ncq_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ອາຕີ ອັນ ປາຍ: \"ຄັນ ລາກວຍ ກາຢາອ໌ ມາ ຕາ ເຕ່ອ໌ ຣາຕັຮ, ຄາອ໌ ອຶນໂຈຍ ຣາອີດ ນັ່ອງ ລາກວຍ ກາຢາອ໌.\" ");
INSERT INTO ncq_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ມັຮ ປັຣນາຍ ເກົາ ອາຕີ ກະ ເຍືາ ໄນ່, ຕາ ເບີນ ກູ່ ນະ ກວາຍ ເຣືາບ ຕະ ຕາປູ່ນ ປັຣນາຍ ໄນ່. ແອີງ ໄລ່ ກາ ເຢືາງ ເຈົາຣາຊີ ຈ່ອຍ ຊັອງ ເຣືາບ ຕະ ຕາປູ່ນ. ");
INSERT INTO ncq_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ເບີນ ກວາຍ ກາ ຕາ ຢໍອ໌ ອີ ອີດ ລາກວຍ, ຍ່ອນ ຈະ ໄລ່ ຕາ ເບີນ ອໍ ແຕ ຕາໄງ ອຶມເປ່ອ໌ ໄລ່ ຣັ່ຮ. ເບີນ ກວາຍ ການໍ່ອ໌ ກາ ຕາ ຢໍອ໌ ອີ ອີດ ລາກວຍ ຍ່ອນ ເບີນ ເນົ່າ ລັດ ໄລ່. ກະ ເບີນ ກວາຍ ການໍ່ອ໌ ກາ ຕາ ຢໍອ໌ ອີ ອີດ ລາກວຍ ຍ່ອນ ໄລ່ ຢໍອ໌ ອີ ຕະ ຣານະ ເຢືາງ ເຈົາຣາຊີ ອຶນແຍ່ະ ຣາງຶ່ຮ ຣາແຮີ ໄລ່. ກວາຍ ອາແລ່ະ ມາ ເຣືາບ ຕະ ຕາປູ່ນ ມັຮ ປັຣນາຍ ໄນ່, ໂອນ ກວາຍ ກັອຍ ຕະ.\" ");
INSERT INTO ncq_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ເບີນ ກວາຍ ເດີງ ມັຮ ກັຣແນນ ແຕີ່ອ໌ ປໍ ເຢຊູ ຢໍອ໌ ອີ ໂອນ ເຢຊູ ຊາປ່ະ ອາຕີ ຕຶ່ງ ກັຣແນນ ກັອຍ, ກະ ເກົາແຊອ໌ ໂອນ ໄລ່. ມາ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ກາແອັຮ ມັຮ ກວາຍ ກາ ເດີງ ກັຣແນນ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ເຢຊູ ປາຍ: \"ເຍືາ ໂອນ ກັຣແນນ ແຕີ່ອ໌ ປໍ ເກົາ. ອຶນໂຈຍ ກາຕັງ ໄລ່, ຍ່ອນ ຕຶ່ງ ຈຸ່ມ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ເບີນ ແອີງ ກວາຍ ກາ ເບີນ ຣາງຶ່ຮ ນ່ະ ກັຣແນນ ໄນ່ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ແວັດ ເຢຊູ ຊາປ່ະ ອາຕີ ອັນ ຕຶ່ງ ມັຮ ກັຣແນນ ກັອຍ, ເຈີ່ ອັນ ເປາະ ແຕ ອຶນຕຸ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ເບີນ ມານະ ຣາເລົາ ແຕີ່ອ໌ ປໍ ເຢຊູ. ອັນ ຕາແບີບ ເຢຊູ ປາຍ: \"ອາຈານ ເອີຍ! ຣານະ ອໍ ອຶນເຕົ່າ ອຶງເຄາະ ເກົາ ຕະ ໂອນ ເຕ່ອ໌ ເກົາ ເບີນ ອາມົ່ງ ເລືອຍໆ?\" ");
INSERT INTO ncq_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ເຢຊູ ຕາແອີຍ ລັ່ຮ ອັນ ປາຍ: \"ນານ່ະ ໄມ່ ຕາແບີບ ເກົາ ແຕ ຣານະ ອໍ? ເບີນ ແອີງ ເຢືາງ ເຈົາຣາຊີ ຊັອງ ອໍ. ຄັນ ໄມ່ ຢໍອ໌ ອີ ເບີນ ອາມົ່ງ ເລືອຍໆ, ອຶງເຄາະ ໄມ່ ຕະ ຕາປູ່ນ ອຶນແຍ່ະ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ປາຕັບ.\" ");
INSERT INTO ncq_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ກວາຍ ຣາເລົາ ກັອຍ ຕາແບີບ ລັ່ຮ ປາຍ: \"ປັຣນາຍ ປາຕັບ ອາແລ່ະ?\" ເຢຊູ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ອຶນໂຈຍ ກາຈີດ ກວາຍ; ອຶນໂຈຍ ປັຣລື່ຍ ລາກວຍ ເນົ່າ; ອຶນໂຈຍ ຕູຕວຍ໌; ອຶນໂຈຍ ຕະ ອຶນຕີ ອາໂລກ; ");
INSERT INTO ncq_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ຢຳນັ່ບ ອຶມເປ່ອ໌ ອຶມປໍ່; ກະ ອາໂຢ່ະ ເຢົ່າ ມູເຈິງ ໄມ່ ອາໂຢ່ະ ຈະ ໄມ່ ເບີມ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ກວາຍ ນຸ່ມ ກັອຍ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ກູ່ ປັຣນາຍ ປາຕັບ ກັອຍ ເກົາ ຕະ ຕາປູ່ນ ອຶນແຍ່ະ ເຈີ່. ມາ ຣານະ ອຶນເຕົ່າ ກາ ເກົາ ຕາ ຢວາຮ ຕະ?\" ");
INSERT INTO ncq_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ເຢຊູ ອາຕີ ລັ່ຮ ອັນ ປາຍ: \"ຄັນ ໄມ່ ຢໍອ໌ ອີ ເບີນ ຣາງຶ່ຮ ກາ ຕາ ເບີນ ແອິ ມວຍ ຣາມຶ່ຮ ອໍ ອຶນເຕົ່າ, ໂອນ ໄມ່ ເປາະ ຈິ ອຶນແຍ່ະ ມັຮ ມູ່ນ ໄມ່, ເຈີ່ ອີດ ປຣະ ກັອຍ ຈ່ອຍ ໂອນ ມັຮ ກວາຍ ກາດີດ. ຄັນ ໄມ່ ຕະ ນ່ະກັອຍ, ໄມ່ ເບີນ ມູ່ນ ອໍ ຕຶ່ງ ມັນລັ່ອງ. ເຈີ່ ໄມ່ ແຕີ່ອ໌ ປວາຍ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ກວາຍ ນຸ່ມ ກັອຍ ເປາະ ແຕ ກັອຍ ກະ ອັນ ຊັອງ ຕຸ່ຮ ຕຶ່ງ ຣາງຶ່ຮ ອັນ, ຍ່ອນ ອັນ ລາ ກວາຍ ຊຸ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ແວັດ ກັອຍ ເຢຊູ ອາຕີ ລັ່ຮ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ມັຮ ກວາຍ ຊຸ ເບີນ, ກັ່ດ ລາລື່ ໂອນ ໄລ່ ກັອຍ ມູ່ດ ຕຶ່ງ ຈຸ່ມ ກາ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ. ");
INSERT INTO ncq_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ກະ ເກົາ ອາຕີ ເຍືາ ແອັນ ປາຍ: ຊັນຕຣັ່ນ ອູ່ດ ມາ ລວາຍ໌ ຕາຣົ່ງ ມັນຈິ່ລ, ອຶນເນີ່ມ ອຽນ ກາເລີຍ ແຕ ກວາຍ ຊຸ ເບີນ ອີ ມູ່ດ ຕຶ່ງ ຈຸ່ມ ກາ ເຢືາງ ເຈົາຣາຊີ ຊົດ.\" ");
INSERT INTO ncq_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ພໍ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ຊັອງ ນ່ະກັອຍ, ໄລ່ ຊັອງ ງຶ່ດ ລາລື່ ກະ ໄລ່ ຕາແບີບ ປາຍ: \"ຄັນ ນ່ະກັອຍ, ເນົ່າ ເຕ່ອ໌ ເບີນ ອາມົ່ງ ເລືອຍໆ?\" ");
INSERT INTO ncq_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ເຢຊູ ເນ່ ປໍ ໄລ່ ກະ ອາຕີ ໄລ່ ປາຍ: \"ກວາຍ ລາ ຕາ ເຕ່ອ໌ ຕະ ເບີມ ຣານະ ກັອຍ, ມາ ເຢືາງ ເຈົາຣາຊີ ເຕ່ອ໌ ຕະ ກູ່ ຣາມຶ່ຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ແວັດ ກັອຍ ເປໂຕ ປາຍ ໂຈະ ເຢຊູ ນ່ະໄນ່: \"ຮິ ຕັຮ ອຶນແຍ່ະ ກູ່ ຣາມຶ່ຮ ຮິ ເບີນ, ຍ່ອນ ຮິ ອີ ເປາະ ກະ ອາຈານ. ນ່ະກັອຍ ປັຣແນີ ມັນເຕຣືາ ຮິ ເບີນ ເກືາ ອຶນເຕົ່າ?\" ");
INSERT INTO ncq_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ເຢຊູ ຕາແອີຍ ໄລ່ ກັອຍ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ຕຶ່ງ ແດີຍ ຕາໄມ, ບັອງ ກາ ເກົາ, ກອນ ເຢືາງ ແກີດ ກວາຍ, ຕາກູ ຕຶ່ງ ອຶນຕຸ ເກົາ ຊົດ, ບັອງ ກັອຍ ເຍືາ ກາ ປວາຍ ເກົາ, ເຍືາ ເບີນ ຕາກູ ຕຶ່ງ ມັນຈິ່ດ ລາ ບາຣ ອຶນຕຸ ຊົດ ເຕ່ ໂອນ ຕັດຊີ່ນ ອຶນແຍ່ະ ມັນຈິ່ດ ລາ ບາຣ ຈຸ່ມ ກວາຍ ອິດຊະຣາເອລ. ");
INSERT INTO ncq_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ກະ ຄັນ ກວາຍ ອາແລ່ະ ຕັຮ ດຸງ, ຕັຮ ແຊມອາຍ ແຊມແອີຍ, ຕັຮ ອຶມເປ່ອ໌ ອຶມປໍ່, ຕັຮ ກອນ ອາໄກ, ແຕີລາ ຕັຮ ໄທຣ, ຍ່ອນ ອັນ ຢໍອ໌ ອີ ປວາຍ ເກົາ, ກວາຍ ກັອຍ ເບີນ ຣັ່ບ ລັ່ຮ ມວຍ ຣ່ອຍ ຕໍ ກາເລີຍ ແຕ ອຶນໂຍ່ງ ແອັນ. ກະ ເຈີ່ ປໍ ເມືາງ ກວາຍ ກັອຍ ເບີນ ອາມົ່ງ ເລືອຍໆ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ມາ ຊາອຶ່ຍ ນະ ກາ ແກີດ ປື່ດ ຊານໍ່, ເຈີ່ ປໍ ເມືາງ ໄລ່ ກັອຍ ແກີດ ແກດໆ ແອັນ. ກະ ຊາອຶ່ຍ ນະ ກາ ແກີດ ແກດໆ ຊານໍ່, ເຈີ່ ປໍ ເມືາງ ໄລ່ ກັອຍ ແກີດ ປື່ດ ແອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","\"ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ລາ ນ່ະ ກວາຍ ອຶນເຈົາ ຊວນ ປາໄລ ອາງຸ່ນ. ແຕ ປຼື່ ລາລື່ ອັນ ເປາະ ຈໍ່ອ໌ ກວາຍ ທູແທ ຕະ ຣານະ ຕຶ່ງ ຊວນ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ອຶນເຈົາ ກັອຍ ປຣ່ອມ ໂອນ ປຣະ ປໍ ກວາຍ ທູແທ ກັອຍ ມວຍ ຕາໄງ ມວຍ ກຼອງ ປຣະ ອານາມ. ເຈີ່ ອັນ ແປຣີ ໄລ່ ກັອຍ ເປາະ ຕະ ຣານະ ຕຶ່ງ ຊວນ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ແຕີ່ອ໌ ມານາງ ຈັຮ, ອຶນເຈົາ ກັອຍ ເປາະ ຈໍ່ອ໌ ລັ່ຮ ກວາຍ ທູແທ ຕະ ຣານະ ຕຶ່ງ ຊວນ ອັນ. ອັນ ຣາມົຮ ມັຮ ກວາຍ ຕຶ່ງ ຕາລາດ ກາ ຕາ ເບີນ ຕະ ຣານະ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ອັນ ອາຕີ ໄລ່ ກັອຍ ປາຍ: 'ເຍືາ ເປາະ ຕະ ຣານະ ຕຶ່ງ ຊວນ ເກົາ. ເກົາ ໂອນ ປຣະ ປໍ ເຍືາ ເກືາ ກາ ເຍືາ ຕະ ຣານະ.' ");
INSERT INTO ncq_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","\"ນ່ະກັອຍ ໄລ່ ກັອຍ ເປາະ. ແຕີ່ອ໌ ມານາງ ຕີລມູ່ລ ກະ ມານາງ ວີ່ຮ, ອຶນເຈົາ ກັອຍ ເປາະ ຈໍ່ອ໌ ລັ່ຮ ກວາຍ ການໍ່ອ໌ ກະ ແປຣີ ໄລ່ ເປາະ ຕະ ຣານະ ຕຶ່ງ ຊວນ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ພໍກາ ຕາບື່, ອຶນເຈົາ ກັອຍ ເປາະ ປໍ ຕາລາດ ຊາ. ອັນ ຣາມົຮ ມັຮ ກວາຍ ການໍ່ອ໌ ກາ ຕາ ເບີນ ຕະ ຣານະ ອຶນເຕົ່າ. ອັນ ຕາແບີບ ມັຮ ກວາຍ ກັອຍ ປາຍ: 'ນານ່ະ ເຍືາ ແອີດ ເມືາດ ຊັອງ ອຶນໄນ່? ອຶນແຍ່ະ ມວຍ ຕາໄງ ໄນ່ ເຍືາ ຕາ ເບີນ ຕະ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","\"ໄລ່ ກັອຍ ຕາແອີຍ ປາຍ: 'ຍ່ອນ ຕາ ເບີນ ເນົ່າ ກູອ໌ ຮິ ທູແທ.' \"ນ່ະກັອຍ ກວາຍ ອຶນເຈົາ ກັອຍ ປາຍ ແອັນ ໂຈະ ໄລ່ ນ່ະໄນ່: 'ເອົາ, ເຍືາ ເປາະ ຕະ ຕຶ່ງ ຊວນ ເກົາ ເຕ່.' ");
INSERT INTO ncq_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","\"ພໍກາ ຕາບື່ ແຈ່ະ ອີ ຊາເດົາ, ອຶນເຈົາ ກັອຍ ແປຣີ ກວາຍ ກາ ຕະ ຈ່ອຍ ອັນ ປາຍ: 'ໄມ່ ເປາະ ກູອ໌ ມັຮ ກວາຍ ທູແທ ເຈີ່ ໂອນ ປຣະ ປໍ ໄລ່. ໄມ່ ໂອນ ໄລ່ ກາ ມູ່ດ ຕະ ອຶນຕູ່ນ ເວືາຍ. ແວັດ ກັອຍ ໄມ່ ໂອນ ໄລ່ ກາ ມູ່ດ ຕະ ຣານະ ອຶນໂຍ່ງ ແອັນ.' ");
INSERT INTO ncq_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","\"ໄລ່ ກາ ຕາແບິ ຕະ ຣານະ ມານາງ ຕາບື່ ແຕີ່ອ໌ ປໍ ອຶນເຈົາ; ເຈີ່ ອຶນເຈົາ ໂອນ ໄລ່ ມານະ ມວຍ ກຼອງ ປຣະ ອານາມ. ");
INSERT INTO ncq_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ນ່ະກັອຍ ມັຮ ໄລ່ ກາ ຕະ ຣານະ ອຶນໂຍ່ງ, ໄລ່ ຄຶ່ດ ປາຍ ໄລ່ ເບີນ ຊາອຶ່ຍ ກາເລີຍ ແຕ ກວາຍ ກາ ຕະ ອຶນຕູ່ນ. ມາ ພໍກາ ໄລ່ ແຕີ່ອ໌ ປໍ ອຶນເຈົາ, ອຶນເຈົາ ໂອນ ໄລ່ ມານະ ມວຍ ກຼອງ ປຣະ ອານາມ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ແວັດ ໄລ່ ອີດ ປຣະ, ເຈີ່ ໄລ່ ຣາຈຽນ ກະ ອຶນເຈົາ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ໄລ່ ປາຍ: 'ມັຮ ກວາຍ ກາ ແຕີ່ອ໌ ອຶນຕູ່ນ ກັອຍ, ໄລ່ ຕະ ມາໂຮຍ ຊັອງ. ມາ ຮິ ໄນ່, ຮິ ຕະ ອຶນແຍ່ະ ຕາໄງ. ຮິ ຈີວ໌ ຕຍາງ ພວາອ໌ ກະ ຈີວ໌ ລາແກັຮ ລາລື່ ອຶນແຍ່ະ ມູ ຕາໄງ. ມາ ອຶນເຈົາ ໂອນ ປຣະ ປໍ ຮິ ມູເຈິງ ກະ ໄລ່ ກັອຍ ເຕ່.' ");
INSERT INTO ncq_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","\"ມາ ອຶນເຈົາ ກັອຍ ຕາແອີຍ ມານະ ແຕ ໄລ່ ກັອຍ ປາຍ: 'ເຢົ່າ ເອີຍ! ເກົາ ຕາ ເບີນ ໂລ່ບ ເຍືາ. ເຍືາ ປຣ່ອມ ກະ ເກົາ ເຈີ່, ເຍືາ ຕະ ມວຍ ຕາໄງ, ເກົາ ໂອນ ເຍືາ ມານະ ມວຍ ກຼອງ ປຣະ. ");
INSERT INTO ncq_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ເຍືາ ອີດ ປຣະ ເຍືາ, ເຈີ່ ເຍືາ ເຈົາ. ຄັນ ເກົາ ມາ ອີ ໂອນ ມັຮ ກວາຍ ກາ ຕະ ອຶນຕູ່ນ ໄນ່ ຣາລີ ກະ ເຍືາ ເຕ່, ");
INSERT INTO ncq_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ເຕ່ອ໌ ມາ ຕາ ເບີນ ເກົາ ຕະ ນ່ະກັອຍ ກະ ປຣະ ເກົາ ເບີມ? ນານ່ະ ເຍືາ ຊັອງ ອວານ ເຍືາ ເຮີມ ເກົາ ຕະ ຣານະ ອໍ ໂອນ ກວາຍ ການໍ່ອ໌?' ");
INSERT INTO ncq_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","\"ນ່ະກັອຍ, ໄລ່ ກາ ອຶນຕູ່ນ ຊານໍ່, ປັຣແນີ ມັນເຕຣືາ ໄລ່ ແກີດ ອຶນໂຍ່ງ. ກະ ໄລ່ ກາ ອຶນໂຍ່ງ ຊານໍ່, ປັຣແນີ ມັນເຕຣືາ ໄລ່ ກັອຍ ແກີດ ອຶນຕູ່ນ ແອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ບັອງ ກາ ເຢຊູ ຊັອຮ ປໍ ເມືອງ ເຢຣູຊາເລັມ, ອັນ ເດີງ ແອີງ ມູ່ ກາ ຣຍານ ແຕ ອັນ ຊັອງ ເປາະ ກະ ອັນ. ບັອງ ກາ ໄລ່ ເປາະ ຕຶ່ງ ຣານາ ເຢຊູ ອາຕີ ໄລ່ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","\"ໂອນ ເຍືາ ຊາງັດ! ໄຮ ອີ ຊັອຮ ປໍ ເມືອງ ເຢຣູຊາເລັມ. ແອີດ ອຶນຕຸ ກັອຍ ເນົ່າ ອີ ມ່ອບ ເກົາ ກອນ ເຢືາງ ແກີດ ກວາຍ ໂອນ ກວາຍ ກາ ຊົດ ຊາງ ຣີ່ດ ກະ ມັຮ ກວາຍ ອາຕີ ຄານອດ. ໄລ່ ກັອຍ ນັ່ດ ດໍອ໌ ອຶງເຄາະ ເກົາ ຈີວ໌ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ເຈີ່ ໄລ່ ມ່ອບ ເກົາ ປໍ ກວາຍ ຕາ ແກີນ ກວາຍ ອິດຊະຣາເອລ. ກວາຍ ກັອຍ ອາເຢ່ ພາມາດ ເກົາ, ໄປຣ່ຮ ເກົາ, ກະ ແຕັຮ ເກົາ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ. ມາ ແຕີ່ອ໌ ຕາໄງ ໄປ, ເກົາ ອາມົ່ງ ລັ່ຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ແວັດ ກັອຍ, ເບີນ ລາກວຍ ເຊເບດາຍ ກະ ບາຣ ນະ ກອນ ຣາເລົາ ອັນ ແຕີ່ອ໌ ປໍ ເຢຊູ. ມັນແຊມ ກັອຍ ກຼຸ່ ຣາໂກລ ຢັ່ຮ ເມືາງ ເຢຊູ ກະ ແຊອ໌ ມວຍ ຣາມຶ່ຮ ແຕ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ເຢຊູ ຕາແບີບ ມັນແຊມ ກັອຍ ປາຍ: \"ອຶນເຕົ່າ ໄມ່ ຢໍອ໌ ອີ ເບີນ?\" ມັນແຊມ ກັອຍ ຕາແອີຍ ປາຍ: \"ແຊອ໌ ອາຈານ ໂອນ ບາຣ ລຳ ກອນ ເກົາ ໄນ່ ຕາກູ ມານະ ຢັ່ຮ ອາຕ່ຳ, ມານະ ຢັ່ຮ ອາເວ່ຣ ອາຈານ, ແຕີ່ອ໌ ອາຈານ ແກີດ ຊົດ.\" ");
INSERT INTO ncq_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ມາ ເຢຊູ ຕາແອີຍ ໄລ່ ກັອຍ ປາຍ: \"ເຍືາ ອຶນນັ່ອງ ຕາ ເບີນ ດັງ ຣາມຶ່ຮ ກາ ເຍືາ ແຊອ໌! ເຍືາ ເຣືາບ ງ່ອຍ໌ ມວຍ ຈອກ ກາ ເກົາ ອີ ງ່ອຍ໌ ບໍ?\" ໄລ່ ບາຣ ນະ ກັອຍ ຕາແອີຍ ອັນ ປາຍ: \"ຮິ ເຣືາບ.\" ");
INSERT INTO ncq_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ເຈີ່ ເຢຊູ ອາຕີ ລັ່ຮ ໄລ່ ປາຍ: \"ປັຣແນີ ມັນເຕຣືາ ເຍືາ ອຶງເຄາະ ງ່ອຍ໌ ມວຍ ຈອກ ກະ ເກົາ ເຕ່. ມາ ເກົາ ຕາ ເຕ່ອ໌ ໂອນ ເຍືາ ຕາກູ ຢັ່ຮ ອາຕ່ຳ ກະ ຢັ່ຮ ອາເວ່ຣ ເກົາ. ຣານະ ໄນ່ ແອີງ ອຶມປໍ່ ເກົາ ຊັອງ ເຕ່ອ໌ ຣຽຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ພໍກາ ໄລ່ ມວຍ ຈິ່ດ ນະ ການໍ່ອ໌ ຕຶ່ງ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ຊັອງ ຣານະ ໄນ່, ໄລ່ ກັອຍ ຊັອງ ອຶງຄື່ນ ລາລື່ ໂຈະ ບາຣ ນະ ແຊມອາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ນ່ະກັອຍ ເຢຊູ ກູອ໌ ອຶນແຍ່ະ ມູ່ ກັອຍ ແຕີ່ອ໌ ປໍ ອັນ. ກະ ອັນ ອາຕີ ໄລ່ ກັອຍ ປາຍ: \"ເຍືາ ດັງ ເຈີ່ ມັຮ ກວາຍ ຊົດ ຕຶ່ງ ແດີຍ ໄນ່, ໄລ່ ຕະ ໂອນ ມັຮ ກອນແຊມ ອຶງກັອຮ ໄລ່; ເຈີ່ ໄລ່ ມັນຕຣຸ່ ກອນແຊມ ກະ ຕະ ຕຸ່ຮ ກັ່ດ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ມາ ເຍືາ ອຶນໂຈຍ ຕະ ນ່ະກັອຍ. ກວາຍ ອາແລ່ະ ຢໍອ໌ ອີ ແກີດ ປື່ດ ຕຶ່ງ ມູ່ ເຍືາ, ອຶງເຄາະ ອັນ ຕະ ຣານະ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ກະ ກວາຍ ອາແລ່ະ ມາ ຢໍອ໌ ອີ ແກີດ ປື່ດ ແກຼີຍ ອຶນແຍ່ະ ແຕ ການໍ່ອ໌ ຕຶ່ງ ມູ່ ເຍືາ, ອຶງເຄາະ ອັນ ກັອຍ ແກີດ ຊູລ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ມູເຈິງ ກັອຍ ເຕ່, ເກົາ ກອນ ເຢືາງ ແກີດ ກວາຍ ຕາ ເບີນ ແຕີ່ອ໌ ປໍ ໄນ່ ໂອນ ເນົ່າ ຈ່ອຍ ເກົາ, ມາ ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່ ອີ ຈ່ອຍ ກວາຍ ການໍ່ອ໌. ກະ ເກົາ ຈີວ໌ ກູຈີດ ອີ ໄທ ຊາອຶ່ຍ ນະ ກວາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ບັອງ ກາ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ລັ່ອຮ ແຕ ເມືອງ ເຢຣີໂກ, ເບີນ ກຼຶ່ງ ກວາຍ ປວາຍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ເບີນ ບາຣ ນະ ກວາຍ ຊູດ ມັ່ດ ແອີດ ຕາກູ ແຈ່ະ ຣານາ. ໄລ່ ຊັອງ ເຢຊູ ເປາະ ພາ ແຈ່ະ ໄລ່. ເຈີ່ ໄລ່ ຊາບາວ ເຣ່ງ ລາລື່ ປາຍ: \"ອຶນເຈົາ, ແຕ ຈຸ່ມເຈືອ ດາວິດ ເອີຍ! ແຊອ໌ ອຶນເຈົາ ອາໂຢ່ະ ຕະ ຮິ ແຮີ!\" ");
INSERT INTO ncq_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ມັຮ ກວາຍ ກຼຶ່ງ ກັອຍ ກາແອັຮ ໂຈະ ໄລ່ ບາຣ ນະ ກວາຍ ຊູດ ມັ່ດ ກະ ອາຕີ ໄລ່ ປາຍ: \"ເຍືາ ອຶນໂຈຍ ຕະ ແບອ໌ ນັ່ອງ!\" ມາ ໄລ່ ບາຣ ນະ ກັອຍ ຊາບາວ ເຣ່ງ ລາລື່ ແອັນ ປາຍ: \"ອຶນເຈົາ ແຕ ຈຸ່ມເຈືອ ດາວິດ ເອີຍ! ແຊອ໌ ອຶນເຈົາ ອາໂຢ່ະ ຕະ ຮິ ແຮີ!\" ");
INSERT INTO ncq_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ນ່ະກັອຍ ເຢຊູ ຕາງິ່ດ. ເຈີ່ ອັນ ກູອ໌ ບາຣ ນະ ກັອຍ ກະ ຕາແບີບ ໄລ່ ກັອຍ ປາຍ: \"ອຶນເຕົ່າ ເຍືາ ໂອນ ເກົາ ຈ່ອຍ ເຍືາ?\" ");
INSERT INTO ncq_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ໄລ່ ກັອຍ ຕາແອີຍ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ຮິ ຢໍອ໌ ອີ ບຣາງ ເຮີມ ເຕ່!\" ");
INSERT INTO ncq_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ເຈີ່ ເຢຊູ ຊັອງ ອາໂຢ່ະ ຕະ ໄລ່ ບາຣ ນະ ກັອຍ, ກະ ອັນ ຊາປ່ະ ອາຕີ ຕຶ່ງ ມັ່ດ ໄລ່ ກັອຍ. ບັອງ ກາ ກັອຍ ແຕິ່ ມັ່ດ ໄລ່ ບາຣ ນະ ກັອຍ ແກີດ ປັ່ງ ລັ່ຮ. ເຈີ່ ໄລ່ ປວາຍ ເຢຊູ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ພໍກາ ໄລ່ ກັອຍ ແຈ່ະ ອີ ແຕີ່ອ໌ ເມືອງ ເຢຣູຊາເລັມ, ໄລ່ ຕາແບິ ແຕີ່ອ໌ ວີ່ລ ເບັດພາເຄ ແອີດ ຕຶ່ງ ກົຮ ອາໂປ່ນ. ພໍກາ ໄລ່ ແຕີ່ອ໌ ປໍ ກາຕຣໍ່ ເມືອງ ກັອຍ, ເຢຊູ ແປຣີ ບາຣ ນະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","\"ເຍືາ ເປາະ ປໍ ເມືອງ ໄນ່. ພໍກາ ເຍືາ ມູ່ດ ປໍ ກັອຍ, ເຍືາ ຣາມົຮ ແຕິ່ ອາກັນ ອາແຊັຮ ແຈລ ກະ ກອນ ອັນ, ເນົ່າ ຊັດ ດໍອ໌ ຕຶ່ງ ລັກ ປໍ ກັອຍ. ເຍືາ ອາແລັ່ຮ; ເຈີ່ ເຍືາ ເຕິ ເດີງ ປໍ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ຄັນ ເບີນ ອາແລ່ະ ຕາແບີບ ເຍືາ ປາຍ: 'ນານ່ະ ເຍືາ ຕະ ນ່ະກັອຍ?' ເຍືາ ຕາແອີຍ ປາຍ: 'ອຶນເຈົາ ໄຮ ຢໍອ໌ ອີ ເມືານ. ແວັດ ອັນ ເມືານ, ເຈີ່ ອັນ ເດີງ ກູລັຮ ລັ່ຮ ໂອນ ເຍືາ.'\" ");
INSERT INTO ncq_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ມັຮ ຣາມຶ່ຮ ໄນ່ ຣາປຍາຍ໌ ກະ ປັຣນາຍ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ປາຍ ແຕ ອຶມແບິ: ");
INSERT INTO ncq_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","\"ອຶງເຄາະ ໄມ່ ອາຕີ ກວາຍ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ ປາຍ: 'ເຕືາວ ປັຣເຍືາ ເຍືາ ແຕີ່ອ໌ ປໍ ເຍືາ ເຈີ່. ອັນ ລາ ກວາຍ ເບີນ ຣາງຶ່ຮ ລາເວືາຍ ອໍ. ກະ ອັນ ຕາກູ ຕຶ່ງ ກຣັອງ ອາແຊັຮ ແຈລ, ອາແຊັຮ ກອນ ກັອຍ.'\" ");
INSERT INTO ncq_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ນ່ະກັອຍ ໄລ່ ບາຣ ນະ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ, ເປາະ ຕະ ກູ່ ຣາມຶ່ຮ ມັຮ ກາ ອັນ ແປຣີ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ໄລ່ ເດີງ ອາຊວຍ ປໍ ເຢຊູ ກອນ ກະ ອາກັນ ອາແຊັຮ ແຈລ ກັອຍ. ກະ ໄລ່ ເຊີນ ຕຳປັອກ ໄລ່ ຕຶ່ງ ກຣັອງ ອາແຊັຮ. ເຈີ່ ເຢຊູ ຊັອຮ ຈິ່ຮ ຕຶ່ງ ກຣັອງ ອາແຊັຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ກຼຶ່ງ ລາລື່ ກວາຍ ເຊີນ ຕຳປັອກ ໄລ່ ຕຶ່ງ ຣານາ. ເບີນ ໄລ່ ກາ ມູ່ດ ຕຶ່ງ ອາຣື່ຍຮ, ກັຣໄປຮ ໂກຍ໌ ອາລ່ອງ, ເຈີ່ ໄລ່ ເຊີນ ຕຶ່ງ ຣານາ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ອັນ ກາ ຕາຢັຮ ອຶນໂຍ່ງ ກະ ອັນ ກາ ຕາຢັຮ ອຶນຕູ່ນ, ໄລ່ ຕຣຍາວ ເຣ່ງ ລາລື່ ປາຍ: \"ໂຮຊັນນາ! ຍ່ອງ ອັນ ກາ ແຕ ຈຸ່ມເຈືອ ເຕືາວ ປັຣເຍືາ ດາວິດ, ອັນ ກາ ເຢືາງ ເຈົາຣາຊີ ຣຽຮ ໂອນ ຈ່ອຍ ອາມົ່ງ ກວາຍ! ແຊອ໌ ເຢືາງ ເຈົາຣາຊີ ໂອນ ເບີນ ບຸ່ນ ປໍ ກວາຍ ກາ ແຕີ່ອ໌ ຍ່ອນ ຣາມຶ່ຮ ເຢືາງ ເຈົາຣາຊີ. ໂຮຊັນນາ! ຍ່ອງ ເຢືາງ ເຈົາຣາຊີ!\" ");
INSERT INTO ncq_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ບັອງ ກາ ເຢຊູ ມູ່ດ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ, ອຶນແຍ່ະ ມັຮ ກວາຍ ກາ ແອີດ ຕຶ່ງ ເມືອງ ກັອຍ, ໄລ່ ປັຣລັອງ ເນ່ ກະ ໄລ່ ຕາແບີບ ປາຍ: \"ກວາຍ ໄນ່ ລາ ເນົ່າ?\" ");
INSERT INTO ncq_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ກວາຍ ກຼຶ່ງ ກັອຍ ຕາແອີຍ ປາຍ: \"ໄນ່ ລາ ເຢຊູ. ອັນ ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ວີ່ລ ນາຊາເຣັດ ແຄງ ຄາລີເລ.\" ");
INSERT INTO ncq_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ເຢຊູ ມູ່ດ ຕຶ່ງ ຊັງອາຣ ດຸງ ຊາງ ປື່ດ. ກະ ອັນ ຕູ່ຍຮ ອາລັ່ອຮ ອຶນແຍ່ະ ມັຮ ກວາຍ ກາ ຈູຈິ ຕຶ່ງ ຊັງອາຣ ດຸງ ຊາງ ກັອຍ. ອັນ ກູແຕັລ ກາເຈີ່ງ ເນົ່າ ປຽນ ປຣະ ກະ ກາເຈີ່ງ ເນົ່າ ຕາກູ ຈິ ແຈມ ປາເຣືາດ. ");
INSERT INTO ncq_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ອັນ ອາຕີ ກວາຍ ກັອຍ ປາຍ: \"ຕຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ຄຽນ ປາຕັບ ດໍອ໌ ປາຍ: 'ເນົ່າ ດໍອ໌ ດຸງ ເກົາ ລາ ດຸງ ໂອນ ກວາຍ ເກົາແຊອ໌ ຊັອງ.' ມາ ເຍືາ ຕະ ໂອນ ດຸງ ໄນ່ ແກີດ ນ່ະ ກື່ບ ໂອນ ກວາຍ ຊາແວງ ມູ່ດ ໂຕ່ະ!\" ");
INSERT INTO ncq_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ແວັດ ກັອຍ, ເບີນ ກວາຍ ຊູດ ມັ່ດ ກະ ກວາຍ ໂຢດ ແຕີ່ອ໌ ປໍ ເຢຊູ ປໍ ດຸງ ຊາງ ປື່ດ ກັອຍ. ເຈີ່ ເຢຊູ ປົວ ໄລ່ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ມາ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ກະ ມັຮ ກວາຍ ອາຕີ ຄານອດ, ໄລ່ ຊັອງ ອຶງຄື່ນ ລາລື່ ພໍກາ ໄລ່ ເຮີມ ຣານະ ເຢຊູ ຕະ, ກະ ພໍກາ ໄລ່ ຊັອງ ກວາຍ ກັຣແນນ ຕຣຍາວ ກູປໍ ເຣ່ງ ລາລື່ ຕຶ່ງ ຊັງອາຣ ດຸງ ຊາງ ປື່ດ ປາຍ: \"ໂຮຊັນນາ! ຍ່ອງ ອັນ ກາ ແຕ ຈຸ່ມເຈືອ ເຕືາວ ປັຣເຍືາ ດາວິດ!\" ");
INSERT INTO ncq_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ນ່ະກັອຍ ໄລ່ ຕາແບີບ ເຢຊູ ປາຍ: \"ອາຈານ ຊັອງ ມາ ຕາ ເບີນ ມັຮ ກວາຍ ກັຣແນນ ໄນ່ ຕຣຍາວ ກູປໍ?\" ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ເກົາ ຊັອງ. ນານ່ະ ປາຍ ເຍືາ ຕາ ເກີ່ຍ ອານ ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ? ອັນ ອາຕີ ປາຍ: 'ເຢືາງ ເຈົາຣາຊີ ເອີຍ! ເຍືາ ຕະ ໂອນ ແບອ໌ ກັຣແນນ ກາ ແກດ ລາລື່, ກາ ໄລ່ ກາ ອຶນນັ່ອງ ອູອ໌ ຕົຮ, ລາ ລ່ຳ ຍ່ອງ ເຍືາ.'\" ");
INSERT INTO ncq_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ແວັດ ກັອຍ ເຢຊູ ລັ່ອຮ ແຕ ໄລ່, ເປາະ ປໍ ວີ່ລ ເບັດທານີ ແອັນ. ຊາເດົາ ກັອຍ ອັນ ບິ ຕຶ່ງ ເມືອງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ປັ່ງ ຕາຣື່ບ ປັຣແນີ, ບັອງ ກາ ເຢຊູ ເຈົາ ລັ່ຮ ປໍ ເມືອງ ເຢຣູຊາເລັມ, ອັນ ຊັອງ ມາເຍືາຍຮ ໂດຍ. ");
INSERT INTO ncq_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ອັນ ເຮີມ ກັ່ລ ລາວັ່ຮ ແອີດ ແຈ່ະ ຣານາ, ເຈີ່ ອັນ ແຕີ່ອ໌ ແຈ່ະ ກັ່ລ ອາລ່ອງ ກັອຍ. ອັນ ເຮີມ ແອີງ ຊາລາ ເມືາດ, ຕາ ເບີນ ປາໄລ ອຶນເຕົ່າ. ອັນ ອາຕີ ກັ່ລ ອາລ່ອງ ກັອຍ ປາຍ: \"ເຈີ່ ປໍ ເມືາງ ໄມ່ ຕາ ເບີນ ແກີດ ປາໄລ ນັ່ອງ!\" ບັອງ ກາ ກັອຍ ແຕິ່ ກັ່ລ ອາລ່ອງ ກັອຍ ແກີດ ຣັ່ອຮ. ");
INSERT INTO ncq_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ພໍ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ເຮີມ ຣານະ ໄນ່, ໄລ່ ຊັອງ ງຶ່ດ ລາລື່ ກະ ໄລ່ ຕາແບີບ ປາຍ: \"ນານ່ະ ກັ່ລ ອາລ່ອງ ໄນ່ ແກີດ ຣັ່ອຮ ໄວ່ ລາລື່?\" ");
INSERT INTO ncq_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ເຢຊູ ຕາແອີຍ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ຄັນ ເຍືາ ມາ ຊາອຳ ກຣັ່ກ ລາລື່ ກະ ຕາ ເບີນ ເບີນ ຣາງຶ່ຮ ກາເຕີ່ນໆ, ເຍືາ ເຕ່ອ໌ ຕະ ເຕ່ ມູເຈິງ ເກົາ ຕະ ກະ ອາລ່ອງ ໄນ່. ກະ ເຍືາ ເຕ່ອ໌ ຕະ ຣານະ ການໍ່ອ໌ ເຕ່. ເຕ່ອ໌ ເຍືາ ແປຣີ ກົຮ ໄນ່ ປາຍ: 'ໄມ່ ຣາວີ່ຮ ຊາປີລ ປໍ ທາເລ.' ນ່ະກັອຍ, ກົຮ ໄນ່ ຣາວີ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ຄັນ ເຍືາ ຊາອຳ ກຣັ່ກ ລາລື່, ຣາມຶ່ຮ ອຶນເຕົ່າ ກາ ເຍືາ ເກົາແຊອ໌, ເຍືາ ເບີນ ຣາມຶ່ຮ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ເຢຊູ ເຈົາ ລັ່ຮ ປໍ ຊັງອາຣ ດຸງ ຊາງ ປື່ດ ຊາ. ບັອງ ກາ ອັນ ອາຕີ ກວາຍ ກາ ແອີດ ຕຶ່ງ ກັອຍ, ເບີນ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ກະ ມັຮ ກວາຍ ເທົາແກ ຈຸ່ມເຈືອ ແຕີ່ອ໌ ປໍ ກັອຍ ເຕ່; ກະ ໄລ່ ຕາແບີບ ອັນ ປາຍ: \"ໄມ່ ເບີນ ອຳນາດ ແຕ ແລ່ະ ກາ ໄມ່ ຕະ ຣານະ ໄນ່? ເນົ່າ ໂອນ ໄມ່ ເບີນ ອຳນາດ ກັອຍ?\" ");
INSERT INTO ncq_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ເກົາ ຕາແບີບ ເຍືາ ມວຍ ຣາມຶ່ຮ ອຶນໂຍ່ງ. ຄັນ ເຍືາ ຕາແອີຍ ເກົາ, ເກົາ ອາຕີ ເຕ່ ເຍືາ ເນົ່າ ກາ ໂອນ ເກົາ ເບີນ ອຳນາດ ໂອນ ຕະ ຣານະ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ເນົ່າ ກາ ໂອນ ອຳນາດ ປໍ ໂຢຮັນ ກາ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌? ອຳນາດ ກັອຍ ແຕີ່ອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ ມາ ແຕີ່ອ໌ ແຕ ກວາຍ ຊັອງ?\" ເຈີ່ ໄລ່ ມານະ ຊັຣຮົງ ມານະ ປາຍ: \"ຄັນ ໄຮ ຕາແອີຍ ອັນ ປາຍ: 'ຣານະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໄນ່ ແຕີ່ອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ,' ອຶງກັອຮ ອັນ ຕາແບີບ ລັ່ຮ ໄຮ ປາຍ: 'ຄັນ ນ່ະກັອຍ, ນານ່ະ ເຍືາ ຕາ ເບີນ ຊາອຳ ໂຢຮັນ?' ");
INSERT INTO ncq_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ມາ ຄັນ ໄຮ ຕາແອີຍ ອັນ ປາຍ: 'ຣານະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໄນ່ ຈຸງ ແຕີ່ອ໌ ແຕ ກວາຍ ຊັອງ,' ໄຮ ອຶງກັອຮ ກອນແຊມ, ຍ່ອນ ໄລ່ ກັອຍ ຊາອຳ ໂຢຮັນ ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ນ່ະກັອຍ ໄລ່ ຕາແອີຍ ເຢຊູ ປາຍ: \"ຮິ ຕາ ດັງ.\" ເຈີ່ ເຢຊູ ຕາແອີຍ ລັ່ຮ ໄລ່ ປາຍ: \"ເຈີ່! ເກົາ ຕາ ເບີນ ອາຕີ ເຕ່ ໂອນ ເຍືາ ດັງ ເນົ່າ ກາ ໂອນ ເກົາ ເບີນ ອຳນາດ ຕະ ມັຮ ຣານະ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","\"ອຶນເຕົ່າ ເຍືາ ຄຶ່ດ ແຕ ປັຣນາຍ ຊາກຳ ໄນ່? ເບີນ ມານະ ກາ ເບີນ ບາຣ ລຳ ກອນ ຣາເລົາ. ອຶມປໍ່ ກັອຍ ແຕີ່ອ໌ ປໍ ອັນ ກາ ອາຍ, ກະ ແປຣີ ອັນ ປາຍ: 'ກອນ ເອີຍ! ຕາໄງ ໄນ່ ໄມ່ ເປາະ ຕະ ຣານະ ຕຶ່ງ ຊວນ ອາງຸ່ນ ໄຮ, ນໍ.' ");
INSERT INTO ncq_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ກອນ ກັອຍ ຕາແອີຍ ປາຍ: 'ເກົາ ອາລັ່ຮ ອີ ເປາະ ຕະ.' ມາ ອັນ ຄຶ່ດ ລັ່ຮ ອຶນຕູ່ນ ແອັນ; ເຈີ່ ອັນ ເປາະ ຕະ ຣານະ ຕຶ່ງ ຊວນ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","\"ເຈີ່ ອຶມປໍ່ ກັອຍ ແຕີ່ອ໌ ປໍ ອາແອມ ແອັນ, ກະ ແປຣີ ອັນ ມູເຈິງ ກັອຍ ເຕ່. ກອນ ກັອຍ ຕາແອີຍ ປາຍ: 'ໂທຍ! ເກົາ ອີ ເປາະ.' ມາ ອັນ ຕາ ເບີນ ເປາະ. ");
INSERT INTO ncq_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","\"ບາຣ ນະ ກອນ ຣາເລົາ ກັອຍ, ອັນ ກາ ອາແລ່ະ ຕະ ຕາປູ່ນ ຣາງຶ່ຮ ອຶມປໍ່?\" ໄລ່ ກັອຍ ຕາແອີຍ ເຢຊູ ປາຍ: \"ອັນ ກາ ອາຍ.\" ເຈີ່ ເຢຊູ ອາຕີ ແອັນ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ມັຮ ກວາຍ ກາ ປາໂຣມ ປຣະ ປາຊີ ກະ ມັຮ ກວາຍ ມັນແຊມ ກາ ຈິ ຈະ, ໄລ່ ເບີນ ມູ່ດ ຕຶ່ງ ຈຸ່ມ ກາ ເຢືາງ ເຈົາຣາຊີ ຊົດ ອຶນໂຍ່ງ ແຕ ເຍືາ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ໂຢຮັນ ແຕີ່ອ໌ ອາປັຮ ເຍືາ ຣານາ ຕານັ່ອງ ອໍ ເຈີ່, ມາ ເຍືາ ຕາ ເບີນ ຊາອຳ ອັນ. ມາ ມັຮ ກວາຍ ກາ ປາໂຣມ ປຣະ ປາຊີ ກະ ມັຮ ກວາຍ ມັນແຊມ ກາ ຈິ ຈະ, ໄລ່ ຊາອຳ ໂຢຮັນ. ເຍືາ ເຮີມ ເຈີ່ ມັຮ ຣານະ ກັອຍ, ມາ ອຶນນັ່ອງ ເຍືາ ຕາ ເບີນ ປຽນ ຊາ ໂອນ ແກີດ ຣາງຶ່ຮ ຕາໄມ ແອັນ, ກະ ເຍືາ ຕາ ເບີນ ຊາອຳ ໂຢຮັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","\"ເຍືາ ຊາງັດ ມວຍ ປັຣນາຍ ຊາກຳ ການໍ່ອ໌ ແອັນ ປາຍ: ເບີນ ມານະ ອຶນເຈົາ, ອັນ ຈົຮ ວັ່ຣ ອາງຸ່ນ ຕຶ່ງ ຊວນ. ອັນ ຕະ ກຣ່ອງ ອຶມແປຣ ຊວນ ກັອຍ. ອັນ ປິ່ ປຣຸ່ງ; ເຈີ່ ກາຕາອ໌ ຕາເມົາ ດໍອ໌ ປັດ ແດີອ໌ ອາງຸ່ນ ຮອຍ ຕຶ່ງ ກັອຍ. ກະ ອັນ ຕະ ຊູ ອຽນ ແອີດ ກຍາອ໌ ຕຶ່ງ ຊວນ ກັອຍ. ແວັດ ກັອຍ ອັນ ໂອນ ກວາຍ ການໍ່ອ໌ ເມືານ ຕະ ຊວນ ອັນ. ໄລ່ ປຣ່ອມ ອຶມແປອ໌ ປາໄລ ກັອຍ. ເຈີ່ ອັນ ເປາະ ປໍ ກຣວາງ ການໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ແຕີ່ອ໌ ປາເນ່ນ ປາໄລ ກັອຍ ຈີນ, ກວາຍ ອຶນເຈົາ ກັອຍ ແປຣີ ມັຮ ກວາຍ ຊູລ ອັນ ໂອນ ເປາະ ອີດ ຊັຣແນອ໌ ອັນ ແຕ ໄລ່ ກາ ເມືານ ຕະ ຊວນ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ມາ ກວາຍ ກາ ເມືານ ຕະ ຊວນ ກັອຍ, ໄລ່ ໂກບ ກວາຍ ຊູລ ກັອຍ. ອັນ ກາ ມານະ, ໄລ່ ປຍາຍຮ. ມານະ ແອັນ ໄລ່ ກາຈີດ. ມານະ ແອັນ ໄລ່ ແກຼງ ໂຈະ ຕາເມົາ. ");
INSERT INTO ncq_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ເຈີ່ ອຶນເຈົາ ກັອຍ ແປຣີ ກວາຍ ຊູລ ການໍ່ອ໌ ແອັນ, ເປາະ ກຼຶ່ງ ກາເລີຍ ແຕ ອຶນໂຍ່ງ. ມາ ໄລ່ ຕະ ໂຈະ ກວາຍ ຊູລ ກັອຍ ມູເຈິງ ກັອຍ ຊາ. ");
INSERT INTO ncq_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ປັຣຊົດ ເລີ່ຍ, ອຶນເຈົາ ກັອຍ ແປຣີ ກອນ ຣາເລົາ ອັນ ເບີມ ເປາະ ປໍ ກວາຍ ກາ ເມືານ ຕະ ຊວນ ກັອຍ. ອັນ ຄຶ່ດ ປາຍ: 'ໄລ່ ກັອຍ ຢຳນັ່ບ ກອນ ເກົາ.' ");
INSERT INTO ncq_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ມາ ແຕີ່ອ໌ ກວາຍ ກາ ເມືານ ຕະ ຊວນ ກັອຍ ເຮີມ ກອນ ອຶນເຈົາ ກັອຍ, ໄລ່ ຊັຣຮົງ ປາຍ: 'ໄນ່ ລາ ກອນ ອຶນເຈົາ ຊວນ. ໄຮ! ໄຮ ກາຈີດ ຕັຮ ອັນ. ເຈີ່ ອຶນແຍ່ະ ມູ່ນ ອັນ ໄຮ ແອັນ ເບີນ ຕາລາ!' ");
INSERT INTO ncq_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ເຈີ່ ໄລ່ ໂກບ ກອນ ອຶນເຈົາ ກັອຍ, ກາຕັ່ອງ ອາລັ່ອຮ ແຕ ຊວນ, ກະ ໄລ່ ກາຈີດ ຕັຮ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","\"ແຕີ່ອ໌ ອຶນເຈົາ ກັອຍ ເປາະ ປໍ ຊວນ ອັນ, ນານ່ະ ອັນ ອີ ຕະ ກະ ໄລ່ ກາ ເມືານ ຕະ ຊວນ ອັນ?\" ");
INSERT INTO ncq_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ກວາຍ ກັອຍ ຕາແອີຍ ເຢຊູ ປາຍ: \"ອັນ ກາຈີດ ຕັຮ ມັຮ ກວາຍ ຕາ ອໍ ກັອຍ. ເຈີ່ ອັນ ໂອນ ກວາຍ ການໍ່ອ໌ ແອັນ ເມືານ ຕະ ຊວນ ອັນ. ແຕີ່ອ໌ ປາເນ່ນ ປາໄລ ກັອຍ ຈີນ, ກວາຍ ການໍ່ອ໌ ກັອຍ ອຶມແປອ໌ ໂອນ ອຶນເຈົາ ກັອຍ ເບີນ ຊັຣແນອ໌ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ເຈີ່ ເຢຊູ ອາຕີ ລັ່ຮ ກວາຍ ກັອຍ ປາຍ: \"ນານ່ະ ປາຍ ເຍືາ ຕາ ເກີ່ຍ ອານ ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ປາຍ: 'ຕາເມົາ ກາ ກວາຍ ເຈືາງ ຕະ ດຸງ ຕາເວ່ງ ຕັຮ ເຈີ່, ມາ ເຢືາງ ເຈົາຣາຊີ ອີດ ຕາເມົາ ກັອຍ ດໍອ໌ ຕຶ່ງ ກູຈົ່ກ ຕະ ໂອນ ດຸງ ແກີດ ຈັບ. ຣານະ ໄນ່ ອຶນເຈົາ ໄຮ ຕະ. ພໍກາ ມັ່ດ ໄຮ ເຮີມ, ຣາງຶ່ຮ ໄຮ ຊັອງ ງຶ່ດ ລາລື່.' ");
INSERT INTO ncq_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","ນ່ະກັອຍ ເກົາ ອາຕີ ເຍືາ ປາຍ: ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ປຣ່ອມ ນັ່ອງ ໂອນ ເຍືາ ມູ່ດ ຕຶ່ງ ຈຸ່ມ ອັນ ຊົດ, ມາ ອັນ ໂອນ ກວາຍ ການໍ່ອ໌ ແອັນ ມູ່ດ. ກວາຍ ກັອຍ ຕະ ຣານະ ອໍ ນ່ະ ອາລ່ອງ ກາ ແກີດ ປາໄລ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ກວາຍ ອາແລ່ະ ມາ ແດິມ ຕຶ່ງ ຕາເມົາ ໄນ່, ອັນ ກູຈີດ ເລີ່ຍ. ມາ ຄັນ ຕາເມົາ ໄນ່ ມາ ຊາແລັຮ ໄກຣ ຕຶ່ງ ຈະ ກວາຍ, ກວາຍ ກັອຍ ເປຣັຍ ເລີ່ຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ພໍກາ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ກະ ມັຮ ກວາຍ ພາຣີຊາຍ ຊັອງ ປັຣນາຍ ຊາກຳ ເຢຊູ ອາຕີ ກັອຍ, ນ່ະກັອຍ ໄລ່ ດັງ ເຢຊູ ຊາກຳ ແຕ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ນ່ະກັອຍ ໄລ່ ຈໍ່ອ໌ ຣາລິ່ຮ ຢໍອ໌ ອີ ໂກບ ອັນ, ມາ ໄລ່ ອຶງກັອຮ ກອນແຊມ, ຍ່ອນ ມັຮ ກວາຍ ກັອຍ ຊາອຳ ເຢຊູ ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ກຣັ່ກ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ເຢຊູ ອາຕີ ລັ່ຮ ໄລ່ ແຕ ປັຣນາຍ ຊາກຳ ການໍ່ອ໌ ແອັນ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","\"ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ລາ ນ່ະ ເຕືາວ ປັຣເຍືາ ກຽມ ດໍອ໌ ອີ ຈາ ດອງ ໂອນ ກອນ ຣາເລົາ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ເຕືາວ ປັຣເຍືາ ກັອຍ ແປຣີ ມັຮ ຊູລ ອັນ ເປາະ ອີດ ມັຮ ກວາຍ ກາ ອັນ ການື່ຍ ເຈີ່, ໂອນ ໄລ່ ແຕີ່ອ໌ ແຮ ຈາ ດອງ ກັອຍ. ມາ ມັຮ ກວາຍ ກັອຍ, ໄລ່ ຕາ ຢໍອ໌ ອີ ແຕີ່ອ໌ ແຮ. ");
INSERT INTO ncq_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ນ່ະກັອຍ ເຕືາວ ປັຣເຍືາ ກັອຍ ແປຣີ ຊູລ ການໍ່ອ໌ ແອັນ, ກະ ປາຕັບ ໄລ່ ປາຍ: 'ເຍືາ ປາຍ ໂຈະ ກວາຍ ກາ ເກົາ ການື່ຍ ເຈີ່ ນ່ະໄນ່: \"ເຕືາວ ປັຣເຍືາ ຮິ ກຽມ ດໍອ໌ ອີ ຈາ ດອງ ເຈີ່. ຕາແກງ ທູ່ນ ກະ ກອນ ຕາແກງ ປຼຶ່ມ ອັນ ກຍາກ ເຈີ່; ກະ ກູ່ ຣານະ ການໍ່ອ໌ ອັນ ກຽມ ດໍອ໌ ອຶນແຍ່ະ ເຈີ່. ມາ ຊານໍ່ ແຊອ໌ ເຍືາ ເປາະ ແຮ ຈາ ດອງ ກັອຍ.\"' ");
INSERT INTO ncq_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","\"ມາ ມັຮ ກວາຍ ກາ ອັນ ການື່ຍ ກັອຍ, ໄລ່ ຕາ ເບີນ ຊາງັດ ປັຣນາຍ ກັອຍ. ໄລ່ ຢໍອ໌ ອີ ຕະ ແອີງ ຣານະ ໄລ່ ຊັອງ. ອັນ ກາ ເປາະ ຕະ ໄທຣ. ອັນ ກາ ເປາະ ຈິແຈີງ. ");
INSERT INTO ncq_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ມັຮ ກວາຍ ການໍ່ອ໌ ໂກບ ຊູລ ເຕືາວ ປັຣເຍືາ ກັອຍ. ໄລ່ ໂຍ່ບ, ໄລ່ ປຍາຍຮ, ກະ ໄລ່ ກາຈີດ ຕັຮ ຊູລ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ນ່ະກັອຍ ເຕືາວ ປັຣເຍືາ ກັອຍ ຊັອງ ອວານ ລາລື່. ອັນ ແປຣີ ຕາຮານ ອັນ ເປາະ ກາຈີດ ລັ່ຮ ມັຮ ກວາຍ ກາ ກາຈີດ ຕັຮ ຊູລ ອັນ. ກະ ມັຮ ຕາຮານ ກັອຍ ຈັອງ ຕັຮ ເມືອງ ກວາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ເຈີ່ ເຕືາວ ປັຣເຍືາ ກູອ໌ ລັ່ຮ ມັຮ ຊູລ ອັນ. ອັນ ປາຕັບ ໄລ່ ປາຍ: 'ດອງ ໄນ່ ກຽມ ດໍອ໌ ເຈີ່. ມາ ມັຮ ໄລ່ ກາ ເກົາ ການື່ຍ, ຣາງຶ່ຮ ໄລ່ ຕາ ເບີນ ປຍາຍ໌ ໂອນ ເປາະ ແຮ ຈາ ດອງ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ຊານໍ່ ເຍືາ ເປາະ ກູ່ ປັຣແວັຮ ຣານາ. ເຍືາ ຣາມົຮ ກວາຍ ອາແລ່ະ, ເຍືາ ການື່ຍ ກວາຍ ກັອຍ ແຕີ່ອ໌ ແຮ ຈາ ດອງ ໄນ່.' ");
INSERT INTO ncq_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ນ່ະກັອຍ ຊູລ ເຕືາວ ປັຣເຍືາ ກັອຍ ລັ່ອຮ ເປາະ ຕຶ່ງ ຣານາ. ໄລ່ ຣາມົຮ ກວາຍ ອາແລ່ະ, ໄລ່ ເດີງ ກວາຍ ກັອຍ ແຕີ່ອ໌ ແຮ ຈາ ດອງ ກາ ເຕືາວ ປັຣເຍືາ ຕະ. ໄລ່ ເດີງ ມັຮ ກວາຍ ຕາ ອໍ ກະ ມັຮ ກວາຍ ອໍ ແຮີ. ນ່ະກັອຍ ຕຶ່ງ ກຼຸງ ດຸງ ເຕືາວ ປັຣເຍືາ ກັອຍ ເບີນ ກຼຶ່ງ ກວາຍ ກູທັດ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","\"ພໍກາ ເຕືາວ ປັຣເຍືາ ມູ່ດ ເນ່ ຕຶ່ງ ກຼຸງ ມັຮ ກວາຍ ແຮ ຈາ ດອງ ກັອຍ, ອັນ ເຮີມ ເບີນ ມານະ ຕາ ເບີນ ແຊິບ ອາຢັ່ອຮ ເກີ່ຍ ເນົ່າ ເປາະ ຈາ ດອງ. ");
INSERT INTO ncq_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ເຈີ່ ອັນ ປາຍ ໂຈະ ກວາຍ ກັອຍ: 'ເຢົ່າ ເອີຍ! ນານ່ະ ໄມ່ ແຕີ່ອ໌ ແຮ ຈາ ດອງ ໄນ່ ມາ ໄມ່ ຕາ ເບີນ ແຊິບ ອາຢັ່ອຮ ກາ ເກີ່ຍ ເນົ່າ ເປາະ ຈາ ດອງ?' ມາ ກວາຍ ກັອຍ ຕາ ເຕ່ອ໌ ຕາແອີຍ ອຶນເຕົ່າ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","\"ເຈີ່ ເຕືາວ ປັຣເຍືາ ກັອຍ ແປຣີ ຊູລ ອັນ ປາຍ: 'ເຍືາ ຊັດ ອາເຢີງ ອາຕີ ອັນ, ກະ ເຍືາ ແກຼງ ຕັຮ ອັນ ຢັ່ຮ ນໍ່ອ໌ ຕຶ່ງ ອຶນຕຸ ການຳ. ອຶນຕຸ ກັອຍ ເນົ່າ ເຍືາມຍີ່ດ ກະ ກາເຕຣືອກ ກາແນງ ກາບາງ ຊັອງ ຕຸ່ຮ ອາຣຶ່ກ ລາລື່.'\" ");
INSERT INTO ncq_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ເຢຊູ ປາຍ ແອັນ: \"ເບີນ ກຼຶ່ງ ລາລື່ ກວາຍ ເຢືາງ ເຈົາຣາຊີ ກູອ໌, ມາ ເບີນ ບີ່ອ໌ ນະ ຊັອງ ອັນ ຣຽຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ແວັດ ກັອຍ ມັຮ ກວາຍ ຈຸ່ມ ພາຣີຊາຍ ເປາະ ຊັຣຮົງ ຈາຈໍ່ອ໌ ຣາລິ່ຮ ຢໍອ໌ ອີ ໂອນ ເຢຊູ ຕະ ອຶນຕີ ໂລ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ໄລ່ ກັອຍ ແປຣີ ກວາຍ ແຕ ມູ່ ໄລ່ ກະ ແຕ ເຕືາວ ປັຣເຍືາ ເຮໂຣດ ເປາະ ແຕີ່ອ໌ ປໍ ເຢຊູ. ກວາຍ ກັອຍ ອາຕີ ເຢຊູ ປາຍ: \"ອາຈານ ເອີຍ! ຮິ ດັງ ເຈີ່ ອາຈານ ລາ ກວາຍ ຕານັ່ອງ ອໍ. ກະ ອາຈານ ອາຕີ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ລາ ປຍາຍ໌ ກະ ອາຈານ ຕາ ເບີນ ຕາປູ່ນ ອາແລ່ະ. ຍ່ອນ ຢັ່ຮ ເມືາງ ອາຈານ ອຶນແຍ່ະ ມັຮ ກວາຍ ແກີດ ລີ ຣາລີ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ນ່ະກັອຍ ຮິ ແຊອ໌ ອາຈານ ອາຕີ ໂອນ ຮິ. ນານ່ະ ອາຈານ ຄຶ່ດ, ປຍາຍ໌ ມາ ຕາ ເບີນ ໄຮ ອຶງເຄາະ ມ່ອບ ປຣະ ປາຊີ ປໍ ເຕືາວ ປັຣເຍືາ ໂຣມ ກາ ກຣິ່ຮ?\" ");
INSERT INTO ncq_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ມາ ເຢຊູ ດັງ ເຈີ່ ໄລ່ ລ່ອງ ອັນ, ຢໍອ໌ ອີ ໂອນ ອັນ ຕາ ດັງ ຕາແອີຍ. ອັນ ປາຍ ໂຈະ ໄລ່: \"ເຍືາ ລາ ກວາຍ ມາມ ອໍ ມາ ຣາງຶ່ຮ ໂກ່ະ! ນານ່ະ ເຍືາ ຈໍ່ອ໌ ຣາລິ່ຮ ໂຈະ ເກົາ? ");
INSERT INTO ncq_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ເຍືາ ໂອນ ເກົາ ເນ່ ປຣະ ປາຊີ ກັອຍ!\" ເຈີ່ ໄລ່ ເດີງ ໂອນ ອັນ ເນ່ ມວຍ ກຼອງ ປຣະ. ");
INSERT INTO ncq_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ເຢຊູ ຕາແບີບ ໄລ່ ປາຍ: \"ຣູ່ບ ເນົ່າ ກະ ຣາມຶ່ຮ ເນົ່າ ຄຽນ ດໍອ໌ ຕຶ່ງ ປຣະ ໄນ່?\" ");
INSERT INTO ncq_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ໄລ່ ກັອຍ ຕາແອີຍ ປາຍ: \"ຣູ່ບ ເຕືາວ ປັຣເຍືາ ໂຣມ ກາ ກຣິ່ຮ.\" ເຈີ່ ເຢຊູ ອາຕີ ລັ່ຮ ໄລ່ ປາຍ: \"ເກຣີ່ງ ເຕືາວ ປັຣເຍືາ ໂຣມ, ອຶງເຄາະ ເຍືາ ກູລັຮ ລັ່ຮ ໂອນ ເຕືາວ ປັຣເຍືາ ໂຣມ, ກະ ເກຣີ່ງ ເຢືາງ ເຈົາຣາຊີ, ອຶງເຄາະ ເຍືາ ກູລັຮ ລັ່ຮ ໂອນ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ພໍກາ ໄລ່ ຊັອງ ປັຣນາຍ ກັອຍ, ໄລ່ ຊັອງ ງຶ່ດ ລາລື່. ກະ ໄລ່ ລັ່ອຮ ແຕ ເຢຊູ, ເປາະ ອຶນຕຸ ການໍ່ອ໌ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ຕາໄງ ກັອຍ ເບີນ ກວາຍ ແຕ ຈຸ່ມ ຊາດູກາຍ ແຕີ່ອ໌ ປໍ ເຢຊູ. ໄລ່ ກັອຍ ປາຍ ກວາຍ ກາ ກູຈີດ ເຈີ່, ຕາ ເຕ່ອ໌ ອາມົ່ງ ລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ໄລ່ ຕາແບີບ ເຢຊູ ປາຍ: \"ອາຈານ ເອີຍ! ໂມເຊ ຄຽນ ເຈີ່ ອາຕີ ໂອນ ຮິ ປາຍ: 'ຄັນ ອາຍ ກູຈີດ ເຈີ່, ມາ ອັນ ຕາ ເບີນ ກອນ ຢວາຮ, ອຶງເຄາະ ອາແອມ ອັນ ແອັນ ເຊີບ ລາກວຍ ອາຍ, ໂອນ ອັນ ເບີນ ກອນ ດໍອ໌ ແກີດ ກອນ ຈຸ່ມເຈືອ ອາຍ ອັນ.' ");
INSERT INTO ncq_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ອຶມແບິ ອາໄຣ່ ເບີນ ຕາປູ່ລ ນະ ແຊມອາຍ ແອີດ ກະ ຮິ. ອັນ ກາ ອາຍ ກັ່ລ ກັອຍ ອີດ ລາກວຍ. ອັນ ຕາ ຢວາຮ ເບີນ ກອນ, ອຶນໂຍ່ງ ອັນ ກູຈີດ. ນ່ະກັອຍ ອາແອມ ອຶນດີ ແອັນ ເຊີບ ລາກວຍ ອາຍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ກະ ມູເຈິງ ກັອຍ ເຕ່ ແຕ ອາແອມ ອຶນດີ ເຕົ່າ ແຕີ່ອ໌ ອາແອມ ອາລັອຮ. ອຶນແຍ່ະ ໄລ່ ແຊມອາຍ ກັອຍ ເຊີບ ມານຳ ລາກວຍ ອາຍ, ກະ ໄລ່ ກູຈີດ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ປັຣຊົດ ເລີ່ຍ ມັນແຊມ ກັອຍ ລາ ກູຈີດ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ພໍກາ ໄລ່ ກາ ກູຈີດ ອາມົ່ງ ລັ່ຮ, ມັນແຊມ ກັອຍ ແກີດ ລາກວຍ ເນົ່າ ແອັນ, ຍ່ອນ ໄລ່ ຕາປູ່ລ ນະ ກັອຍ ຕາລາ ອຶນແຍ່ະ ມັນແຊມ ກັອຍ?\" ");
INSERT INTO ncq_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ເຢຊູ ຕາແອີຍ ໄລ່ ກັອຍ ປາຍ: \"ເຍືາ ຕະ ອຶນຕີ ຕາ ປຍາຍ໌, ຍ່ອນ ເຍືາ ຕາ ເບີນ ດັງ ແຕ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ເນົ່າ ຄຽນ ແຕ ອຶມແບິ, ກະ ເຍືາ ຕາ ດັງ ກາ ອຳນາດ ປື່ດ ລາລື່ ແຕ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ພໍກາ ໄລ່ ກາ ກູຈີດ ອາມົ່ງ ລັ່ຮ, ໄລ່ ຕາ ເບີນ ຣາອີດ ນັ່ອງ ແກີດ ລາກວຍ ກາຢາອ໌. ມາ ໄລ່ ແອີດ ຕຶ່ງ ມັນລັ່ອງ ມູເຈິງ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ແອີດ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ມາ ຣາມຶ່ຮ ກວາຍ ກູຈີດ, ເຈີ່ ອາມົ່ງ ລັ່ຮ, ນານ່ະ ປາຍ ເຍືາ ຕາ ເກີ່ຍ ອານ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ເຍືາ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","'ເກົາ ລາ ເຢືາງ ເຈົາຣາຊີ ກາ ອັບຣາຮາມ, ອີຊາກ, ກະ ຢາໂຄບ ອຶນນັ່ອງ ຊາງ ຕຶ່ງ ມັນລັ່ອງ.' ເຕ່ອ໌ ໄຮ ດັງ ໄລ່ ກັອຍ ອາມົ່ງ ລັ່ຮ ແຕ ກູຈີດ, ຍ່ອນ ກວາຍ ກູຈີດ ຕາ ເຕ່ອ໌ ຊາງ ເຢືາງ ເຈົາຣາຊີ. ແອີງ ໄລ່ ກາ ອາມົ່ງ ຊັອງ ເຕ່ອ໌ ຊາງ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ພໍກາ ມັຮ ກວາຍ ກຼຶ່ງ ຊາງັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ໄລ່ ຊັອງ ງຶ່ດ ລາລື່ ມັຮ ປັຣນາຍ ອັນ ອາຕີ. ");
INSERT INTO ncq_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ພໍກາ ຈຸ່ມ ພາຣີຊາຍ ຊັອງ ເຢຊູ ຕາແອີຍ ຕະ ໂອນ ຈຸ່ມ ຊາດູກາຍ ຕາ ແກີດ ຕະ ແບອ໌ ເລີ່ຍ, ໄລ່ ກັອຍ ໂຣ່ມ ຊັຣຮົງ. ");
INSERT INTO ncq_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ມານະ ແຕ ກວາຍ ກັອຍ ລາ ອາຈານ ອາຕີ ຄານອດ ອິດຊະຣາເອລ. ອັນ ອີ ລ່ອງ ເຢຊູ ແຕ ມວຍ ປັຣນາຍ ຕາແບີບ. ");
INSERT INTO ncq_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","ອັນ ຕາແບີບ ປາຍ: \"ອາຈານ ເອີຍ! ຕຶ່ງ ຄານອດ ໄຮ, ຣາມຶ່ຮ ປາຕັບ ອຶນເຕົ່າ ກາ ປື່ດ ແກຼີຍ ອຶນແຍ່ະ ແຕ ຣາມຶ່ຮ ການໍ່ອ໌?\" ");
INSERT INTO ncq_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ເຢຊູ ຕາແອີຍ ອັນ ປາຍ: \"ອຶງເຄາະ ເຍືາ ອາໂຢ່ະ ເຢືາງ ເຈົາຣາຊີ, ອຶນເຈົາ ເຍືາ, ອຶນແຍ່ະ ຣາງຶ່ຮ ເຍືາ, ອຶນແຍ່ະ ຣາແຮີ ເຍືາ, ກະ ອຶນແຍ່ະ ການິ່ດ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ປັຣນາຍ ປາຕັບ ໄນ່ ລາ ປື່ດ ແກຼີຍ ອຶນແຍ່ະ ແຕ ປັຣນາຍ ການໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ກະ ປັຣນາຍ ປາຕັບ ບາຣ ແກຼີຍ ອຶນແຍ່ະ ແຕ ການໍ່ອ໌ ລາ ອາໄນ່: ອຶງເຄາະ ເຍືາ ອາໂຢ່ະ ເຢົ່າ ນ່ະ ເຍືາ ອາໂຢ່ະ ຈະ ເຍືາ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ຄັນ ເບີນ ບາຣ ປັຣນາຍ ປາຕັບ ໄນ່, ເບີນ ເຈີ່ ອຶນແຍ່ະ ຄານອດ ເຢືາງ ເຈົາຣາຊີ ໂອນ ຣານາ ໂມເຊ, ກະ ອຶນແຍ່ະ ປັຣນາຍ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ບັອງ ກາ ຈຸ່ມ ພາຣີຊາຍ ໂຣ່ມ ຊັຣຮົງ, ເຢຊູ ຕາແບີບ ໄລ່ ກັອຍ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","\"ອຶນເຕົ່າ ເຍືາ ຄຶ່ດ ແຕ ມານະ ກຣີດ? ອັນ ລາ ແຕ ຈຸ່ມເຈືອ ເນົ່າ?\" ໄລ່ ກັອຍ ຕາແອີຍ ປາຍ: \"ອັນ ລາ ແຕ ຈຸ່ມເຈືອ ດາວິດ.\" ");
INSERT INTO ncq_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ນ່ະກັອຍ ເຢຊູ ຕາແບີບ ລັ່ຮ ໄລ່ ປາຍ: \"ຄັນ ນ່ະກັອຍ, ນານ່ະ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ໂອນ ເຕືາວ ປັຣເຍືາ ດາວິດ ດໍອ໌ ກຣີດ ລາ 'ອຶນເຈົາ?' ຍ່ອນ ແຕ ອຶມແບິ ເຕືາວ ປັຣເຍືາ ດາວິດ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","'ເຢືາງ ເຈົາຣາຊີ ອາຕີ ໂຈະ ອຶນເຈົາ ເກົາ ປາຍ: \"ໄມ່ ຕາກູ ແອີດ ຢັ່ຮ ອາຕ່ຳ ເກົາ ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ແລ່ະ ເກົາ ໂອນ ໄລ່ ກາ ຢໍອ໌ ອີ ກາຈີດ ໄມ່ ແອີດ ປື່ນ ຕາລາງ ອາເຢີງ ໄມ່ ແກີດ ຊູລ ໄມ່.\"' ");
INSERT INTO ncq_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ຄັນ ດາວິດ ດໍອ໌ ກຣີດ ໄນ່ ລາ 'ອຶນເຈົາ,' ນານ່ະ ເຕ່ອ໌ ດາວິດ ດໍອ໌ ກວາຍ ແຕ ຈຸ່ມເຈືອ ອັນ ເບີມ ລາ 'ອຶນເຈົາ'?\" ");
INSERT INTO ncq_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ຕາ ເບີນ ເນົ່າ ເຕ່ອ໌ ຕາແອີຍ ມວຍ ປັຣນາຍ ອຶນເຕົ່າ. ກະ ແຕ ຕາໄງ ກັອຍ ຕາ ເບີນ ເນົ່າ ຍັ່ນ ຕາແບີບ ນັ່ອງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ແວັດ ກັອຍ ເຢຊູ ອາຕີ ລັ່ຮ ມັຮ ກວາຍ ກຼຶ່ງ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","\"ກວາຍ ອາຕີ ຄານອດ ກະ ກວາຍ ພາຣີຊາຍ, ໄລ່ ກັອຍ ແກີດ ກວາຍ ອາຕີ ເຍືາ ໄປຼຮ ລັ່ຮ ໂມເຊ. ");
INSERT INTO ncq_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ນ່ະກັອຍ, ອຶງເຄາະ ເຍືາ ຕະ ຕາປູ່ນ ນ່ະ ປັຣນາຍ ໄລ່ ອາຕີ. ມາ ເຍືາ ອຶນໂຈຍ ດວຍ໌ ມັຮ ຣານະ ໄລ່ ຕະ, ຍ່ອນ ແບອ໌ ໄລ່ ປາຍ ມາ ໄລ່ ຕາ ເບີນ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ໄລ່ ອາຕີ ໂອນ ເຍືາ ຕາປູ່ນ ຄານອດ ກັ່ດ ລາລື່ ນ່ະ ໄລ່ ໂອນ ປາລ ເຍືາ ໂດລ ເກຣີ່ງ ອຶນຕັອງ. ມາ ອາຕີ ໄລ່ ຕາ ເບີນ ອີດ ຈ່ອຍ ອຶນເຕົ່າ ເກຣີ່ງ ອຶນຕັອງ ແຕ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ກູ່ ຣານະ ໄລ່ ຕະ, ໄລ່ ຢໍອ໌ ອີ ໂອນ ກວາຍ ການໍ່ອ໌ ເຮີມ ມັຮ ຣານະ ກັອຍ. ໄລ່ ໂຈະ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ຕຶ່ງ ໂຮບ ອຶງກັຣ. ເຈີ່ ໄລ່ ຊັດ ໂຮບ ກັອຍ ຕຶ່ງ ອຶມແບຼງ ກະ ໄລ່ ຕາປື່ງ ຕຶ່ງ ກາລຍາອ໌. ກະ ໄລ່ ຕະ ຢ່ອຍ ຕີ່ ລາລື່ ຕຶ່ງ ອາຢັ່ອຮ ຕ່ອງ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ໄລ່ ຢໍອ໌ ອີ ຕາກູ ຢັ່ຮ ແປີງ ແຕີ່ອ໌ ເນົ່າ ການື່ຍ ໄລ່ ແຕີ່ອ໌ ຈາ. ກະ ໄລ່ ຢໍອ໌ ອີ ເບີນ ກາເຈີ່ງ ຕາກູ ອໍ ແກຼີຍ ອຶນແຍ່ະ ແຕ ກວາຍ ການໍ່ອ໌ ແອີດ ຕຶ່ງ ດຸງ ຊາງ. ");
INSERT INTO ncq_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ໄລ່ ຢໍອ໌ ກວາຍ ການໍ່ອ໌ ຣາບັນ ອໍ ໄລ່ ບັອງ ກາ ໄລ່ ແອີດ ກະ ກວາຍ ກຼຶ່ງ. ກະ ໄລ່ ຢໍອ໌ ເນົ່າ ດໍອ໌ ໄລ່ ລາ 'ອາຈານ.' ");
INSERT INTO ncq_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ມາ ເຍືາ ອຶນໂຈຍ ຢໍອ໌ ອີ ໂອນ ກວາຍ ການໍ່ອ໌ ດໍອ໌ ເຍືາ ລາ 'ອາຈານ,' ຍ່ອນ ເຍືາ ເບີນ ແອີງ ມານຳ ອາຈານ ຊັອງ, ກະ ເຍືາ ລາ ນ່ະ ແຊມອາຍ ຣາລີ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ກະ ເຍືາ ອຶນໂຈຍ ດໍອ໌ ກວາຍ ແອີດ ຕຶ່ງ ກູແຕອ໌ ໄນ່ ມາ 'ອຶມປໍ່ ເຍືາ,' ຍ່ອນ ເຍືາ ເບີນ ແອີງ ມານຳ ອຶມປໍ່ ຊັອງ, ອັນ ກາ ແອີດ ຕຶ່ງ ມັນລັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ກະ ເຍືາ ອຶນໂຈຍ ຢໍອ໌ ອີ ໂອນ ກວາຍ ການໍ່ອ໌ ດໍອ໌ ເຍືາ ລາ 'ກວາຍ ຊົດ,' ຍ່ອນ ເຍືາ ເບີນ ແອີງ ມານຳ ຊົດ ຊັອງ, ອັນ ລາ ມານະ ກຣີດ. ");
INSERT INTO ncq_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ຄັນ ເບີນ ກວາຍ ຕຶ່ງ ມູ່ ເຍືາ ມາ ຢໍອ໌ ອີ ແກີດ ປື່ດ ແກຼີຍ ອຶນແຍ່ະ ແຕ ກວາຍ ການໍ່ອ໌, ອຶງເຄາະ ອັນ ແກີດ ກວາຍ ຕະ ຣານະ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ກວາຍ ອາແລ່ະ ມາ ອາຊັອຮ ຈະ ອັນ ເບີມ, ປັຣແນີ ມັນເຕຣືາ ກວາຍ ກັອຍ ແກີດ ແກດ. ກະ ກວາຍ ອາແລ່ະ ກາ ອາແຊງ ຈະ ອັນ ເບີມ, ປັຣແນີ ມັນເຕຣືາ ກວາຍ ກັອຍ ແກີດ ປື່ດ. ");
INSERT INTO ncq_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","\"ບາບ ລາລື່ ແຕີ່ອ໌ ປໍ ເຍືາ ກາ ກວາຍ ອາຕີ ຄານອດ ກະ ກວາຍ ພາຣີຊາຍ, ລາ ກວາຍ ມາມ ອໍ ມາ ຣາງຶ່ຮ ໂກ່ະ! ຍ່ອນ ເຍືາ ກາຕັງ ຕາ ໂອນ ກວາຍ ມູ່ດ ຕຶ່ງ ຈຸ່ມ ກາ ເຢືາງ ເຈົາຣາຊີ ຊົດ. ເຍືາ ຕາ ແອອ໌ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ເຍືາ, ກະ ເຍືາ ຕາ ເບີນ ໂອນ ກວາຍ ການໍ່ອ໌ ເບີນ ນ່ະກັອຍ ເຕ່! ");
INSERT INTO ncq_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","\"ບາບ ລາລື່ ແຕີ່ອ໌ ປໍ ເຍືາ ກາ ກວາຍ ອາຕີ ຄານອດ ກະ ກວາຍ ພາຣີຊາຍ, ລາ ກວາຍ ມາມ ອໍ ມາ ຣາງຶ່ຮ ໂກ່ະ! ຍ່ອນ ເຍືາ ໂລ່ບ ມັຮ ດຸງ ອຶມເປ່ອ໌ ກູມາຍ. ກະ ເຍືາ ເກົາແຊອ໌ ປັຣນາຍ ຕີ່ ຢໍອ໌ ອີ ໂອນ ເນົ່າ ປາຍ ເຍືາ ຕານັ່ອງ ອໍ. ນ່ະກັອຍ ເຈີ່ ປໍ ເມືາງ ໂຕ່ດ ເຍືາ ອຶນຕັອງ ກາເລີຍ ແຕ ກວາຍ ການໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","\"ບາບ ລາລື່ ແຕີ່ອ໌ ປໍ ເຍືາ ກາ ກວາຍ ອາຕີ ຄານອດ ກະ ກວາຍ ພາຣີຊາຍ, ລາ ກວາຍ ມາມ ອໍ ມາ ຣາງຶ່ຮ ໂກ່ະ! ຍ່ອນ ເຍືາ ຕະ ອຶນແຍ່ະ ຣາງຶ່ຮ ຣາແຮີ ຢໍອ໌ ອີ ໂອນ ກວາຍ ການໍ່ອ໌ ຕັຮ ຊັອງ ຣາງຶ່ຮ ໄລ່; ເຈີ່ ຕາປູ່ນ ຣາງຶ່ຮ ເຍືາ ແອັນ. ມາ ແຕີ່ອ໌ ໄລ່ ຕາປູ່ນ ຣາງຶ່ຮ ເຍືາ, ເຍືາ ຕະ ໂອນ ໄລ່ ແກີດ ຕາ ອໍ ແກຼີຍ ແຕ ເຍືາ ແອັນ; ເຈີ່ ປຍາຍ໌ ເຢືາງ ເຈົາຣາຊີ ອາປັອງ ຕັຮ ເຍືາ ຕຶ່ງ ປຣຸ່ງ ອູ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","\"ບາບ ລາລື່ ແຕີ່ອ໌ ປໍ ເຍືາ ກາ ນ່ະ ກວາຍ ຊູດ ມັ່ດ ມາ ຢໍອ໌ ອີ ອາໂຢ່ງ ກວາຍ ການໍ່ອ໌. ເຍືາ ອາຕີ ໂຈະ ກວາຍ ການໍ່ອ໌ ປາຍ: 'ຄັນ ກວາຍ ອາແລ່ະ ກາ ຄີນ, ມາ ອັນ ກູອ໌ ດຸງ ຊາງ ປື່ດ, ປັຣນາຍ ກວາຍ ກັອຍ ຄີນ ຕາ ເບີນ ຕຸ່ຮ ຕະ ຕາປູ່ນ. ມາ ຄັນ ກວາຍ ອາແລ່ະ ກາ ຄີນ ມາ ອັນ ກູອ໌ ແຢງ ແອີດ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ ກັອຍ, ອຶງເຄາະ ກວາຍ ກັອຍ ຕະ ຕາປູ່ນ ປັຣນາຍ ກາ ອັນ ຄີນ.' ");
INSERT INTO ncq_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ເຍືາ ລາ ກວາຍ ຊາກູລ ກະ ເຍືາ ກາ ນ່ະ ກວາຍ ຊູດ ມັ່ດ ເອີຍ! ອາແລ່ະ ກາ ປື່ດ ກາເລີຍ, ແຢງ ແຕີລາ ດຸງ ຊາງ ປື່ດ ກາ ຕະ ໂອນ ແຢງ ກັອຍ ແກີດ ອໍ ຢັ່ຮ ເມືາງ ເຢືາງ ເຈົາຣາຊີ? ");
INSERT INTO ncq_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ກະ ເຍືາ ອາຕີ ປາຍ ເຕ່: 'ຄັນ ກວາຍ ອາແລ່ະ ຄີນ, ມາ ອັນ ກູອ໌ ຊັນເຕຣືາງ ຣີ່ດ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ, ປັຣນາຍ ກວາຍ ກັອຍ ຄີນ ຕາ ເບີນ ຕຸ່ຮ ຕະ ຕາປູ່ນ. ມາ ຄັນ ກວາຍ ອາແລ່ະ ກາ ຄີນ ມາ ອັນ ກູອ໌ ເກຣີ່ງ ຊາງ ຕຶ່ງ ຊັນເຕຣືາງ ຣີ່ດ ກັອຍ, ອຶງເຄາະ ກວາຍ ກັອຍ ຕະ ຕາປູ່ນ ປັຣນາຍ ກາ ອັນ ຄີນ.' ");
INSERT INTO ncq_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ເຍືາ ລາ ນ່ະ ກວາຍ ຊູດ ມັ່ດ! ອາແລ່ະ ກາ ປື່ດ ກາເລີຍ, ເກຣີ່ງ ຊາງ ແຕີລາ ຊັນເຕຣືາງ ຣີ່ດ ກາ ຕະ ໂອນ ເກຣີ່ງ ກັອຍ ແກີດ ອໍ ຢັ່ຮ ເມືາງ ເຢືາງ ເຈົາຣາຊີ? ");
INSERT INTO ncq_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ນ່ະກັອຍ, ຄັນ ກວາຍ ອາແລ່ະ ຄີນ ມາ ອັນ ກູອ໌ ຊັນເຕຣືາງ ຣີ່ດ, ລາ ມູເຈິງ ກວາຍ ກັອຍ ຄີນ ໂຈະ ເກຣີ່ງ ຊາງ ຕຶ່ງ ຊັນເຕຣືາງ ຣີ່ດ ກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ກະ ຄັນ ກວາຍ ອາແລ່ະ ຄີນ ມາ ອັນ ກູອ໌ ດຸງ ຊາງ ປື່ດ, ລາ ມູເຈິງ ອັນ ຄີນ ໂຈະ ເຢືາງ ເຈົາຣາຊີ ເຕ່, ຍ່ອນ ດຸງ ຊາງ ກັອຍ ລາ ດຸງ ຊາງ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ກະ ຄັນ ກວາຍ ອາແລ່ະ ກາ ຄີນ ມາ ອັນ ກູອ໌ ມັນລັ່ອງ, ມູເຈິງ ອັນ ຄີນ ໂຈະ ເຢືາງ ເຈົາຣາຊີ ເຕ່, ຍ່ອນ ເຢືາງ ເຈົາຣາຊີ ແອີດ ຕຶ່ງ ມັນລັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","\"ບາບ ລາລື່ ແຕີ່ອ໌ ປໍ ເຍືາ ກາ ກວາຍ ອາຕີ ຄານອດ ກະ ກວາຍ ພາຣີຊາຍ, ລາ ກວາຍ ມາມ ອໍ ມາ ຣາງຶ່ຮ ໂກ່ະ! ຍ່ອນ ເຍືາ ມ່ອບ ຊາງ ໂອນ ເຢືາງ ເຈົາຣາຊີ ມວຍ ປູ່ດ ແຕ ມວຍ ຈິ່ດ ປູ່ດ ບັດ ບາຍ ອາຊາຍ ກູຕຽມ ເຍືາ, ມາ ເຍືາ ຕາ ເບີນ ຊາງັດ ຣານະ ການໍ່ອ໌ ລາ ປື່ດ ກາເລີຍ ແຕ ຣີ່ດ ຊາງ ກັອຍ ຕຶ່ງ ຄານອດ ເຢືາງ ເຈົາຣາຊີ. ຣານະ ປື່ດ ກັອຍ ລາ ນ່ະໄນ່: ເຍືາ ອຶງເຄາະ ຕະ ຊັງໄກຣ ອໍ, ອຶງເຄາະ ເບີນ ຣາງຶ່ຮ ຊັອງ ອາໂຢ່ະ ຕະ ໂຈະ ກວາຍ ການໍ່ອ໌, ກະ ອຶງເຄາະ ຕະ ໄກຣ ລາລື່ ໂອນ ກວາຍ ການໍ່ອ໌ ເຕ່ອ໌ ຊາງັດ ເຍືາ. ເກົາ ຕາ ເບີນ ໂອນ ເຍືາ ຕັຮ ເມືາດ ຣານະ ມ່ອບ ຊາງ ກັອຍ, ມາ ມັຮ ຣາມຶ່ຮ ປື່ດ ກາເລີຍ, ລາ ອຶງເຄາະ ເຍືາ ຕະ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ເຍືາ ລາ ນ່ະ ກວາຍ ຊູດ ມັ່ດ ມາ ຢໍອ໌ ອີ ອາໂຢ່ງ ກວາຍ ການໍ່ອ໌! ເຍືາ ຢໍອ໌ ອີ ອີດ ຕັຮ ອາຍື່ອ໌ ແຕ ແດີອ໌ ງ່ອຍ໌, ມາ ຄັນ ເບີນ ຊັນຕຣັ່ນ ອູ່ດ, ເຍືາ ລື່ນ ອຶນແຍ່ະ ກຼຳ ແຕິ່. ");
INSERT INTO ncq_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","\"ບາບ ລາລື່ ແຕີ່ອ໌ ປໍ ເຍືາ ກາ ກວາຍ ອາຕີ ຄານອດ ກະ ກວາຍ ພາຣີຊາຍ, ລາ ກວາຍ ມາມ ອໍ ມາ ຣາງຶ່ຮ ໂກ່ະ! ຍ່ອນ ເຍືາ ລາ ນ່ະ ຕາງານ ກະ ກູໂຕອ໌ ເນົ່າ ອາເຣືາວ ໂອນ ບຣັຮ ອໍ ແອີງ ຢັ່ຮ ນໍ່ອ໌ ຊັອງ, ມາ ຕຶ່ງ ແປີງ ງັ່ຮ ກັອຍ ອຶນນັ່ອງ ແປຣິ່. ແປຣິ່ ກັອຍ ລາ ເຍືາ ຣາປົນ ກະ ເຍືາ ອາໂຢ່ະ ແອີງ ຈະ ເຍືາ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ເອີ ມັຮ ກວາຍ ພາຣີຊາຍ, ເຍືາ ລາ ນ່ະ ກວາຍ ຊູດ ມັ່ດ! ອຶນໂຍ່ງ ລາລື່ ເຍືາ ອຶງເຄາະ ອາເຣືາວ ໂອນ ບຣັຮ ຕຶ່ງ ແປີງ ງັ່ຮ ຕາງານ ເວືາຍ. ຄັນ ເຍືາ ຕະ ນ່ະກັອຍ, ຢັ່ຮ ນໍ່ອ໌ ຕາງານ ກັອຍ ແກີດ ບຣັຮ ເຕ່! ");
INSERT INTO ncq_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","\"ບາບ ລາລື່ ແຕີ່ອ໌ ປໍ ເຍືາ ກວາຍ ອາຕີ ຄານອດ ກະ ກວາຍ ພາຣີຊາຍ, ລາ ກວາຍ ມາມ ອໍ ມາ ຣາງຶ່ຮ ໂກ່ະ! ເຍືາ ລາ ນ່ະ ປີ່ງ ກູມູ່ຍ໌ ເນົ່າ ເຕືາ ກຼໍອ໌ ອໍ ແອີງ ຢັ່ຮ ນໍ່ອ໌ ຊັອງ, ມາ ຕຶ່ງ ປື່ນ ກັອຍ ເບີນ ອຶງຮາງ ກວາຍ ກູຈີດ ກະ ອຶນໂຊະ ປຣີ່ໆ. ");
INSERT INTO ncq_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ເຍືາ ລາ ມູເຈິງ ກັອຍ ເຕ່. ເຍືາ ຢໍອ໌ ອີ ໂອນ ກວາຍ ການໍ່ອ໌ ປາຍ ເຍືາ ລາ ກວາຍ ຕານັ່ອງ ອໍ, ມາ ຣາງຶ່ຮ ເຍືາ ເບີນ ຊາອຶ່ຍ ໂລ່ຍຮ, ກະ ເຍືາ ມາມ ອໍ ມາ ຣາງຶ່ຮ ໂກ່ະ. ");
INSERT INTO ncq_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","\"ບາບ ລາລື່ ແຕີ່ອ໌ ປໍ ເຍືາ ກາ ກວາຍ ອາຕີ ຄານອດ ກະ ກວາຍ ພາຣີຊາຍ, ລາ ກວາຍ ມາມ ອໍ ມາ ຣາງຶ່ຮ ໂກ່ະ! ເຍືາ ຕະ ປີ່ງ ອໍ ໂອນ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ. ກະ ເຍືາ ຕະ ໂອນ ອໍ ລາລື່ ມັຮ ປີ່ງ ກວາຍ ຕານັ່ອງ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ກະ ເຍືາ ເກີ່ຍ ປາຍ ນ່ະໄນ່ ແຮີ: 'ຄັນ ຮິ ມາ ແອີດ ແຕ ອຶມແບິ ກັອຍ ມວຍ ໂປຣ່ອ໌ ກະ ອາຈວາຍຮ ອາເຈ່ຮ ຮິ, ຮິ ຕາ ເບີນ ກາຈີດ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ມູເຈິງ ໄລ່ ກັອຍ ຕະ.' ");
INSERT INTO ncq_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ແຕີ່ອ໌ ເຍືາ ປາຍ ນ່ະກັອຍ, ເຍືາ ງີ່ນ ເຍືາ ລາ ກວາຍ ຈຸ່ມເຈືອ ມູ່ ກາ ກາຈີດ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ. ");
INSERT INTO ncq_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ເອົາ, ເຍືາ ເປາະ ແຕິ່! ເຍືາ ຕະ ໂອນ ແມິ່ມ ມັຮ ຣານະ ອາຈວາຍຮ ອາເຈ່ຮ ເຍືາ! ");
INSERT INTO ncq_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ເຍືາ ລາ ກວາຍ ກາ ເບີນ ຣາງຶ່ຮ ຕາ ອໍ ນ່ະ ກູຊັນ ປຼາ. ເຍືາ ຕາ ເຕ່ອ໌ ວຍາຣ ແຕ ເຢືາງ ເຈົາຣາຊີ ຕັດຊີ່ນ ເຍືາ ກະ ຕະ ໂຕ່ດ ເຍືາ ຕຶ່ງ ປຣຸ່ງ ອູ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ນ່ະກັອຍ ເກົາ ອາຕີ ເຍືາ ປາຍ: ປັຣແນີ ມັນເຕຣືາ ເກົາ ແປຣີ ມັຮ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ການໍ່ອ໌ ແອັນ, ກະ ມັຮ ກວາຍ ຣາໄງ່ອ໌ ຣາລັ່ງ ລາລື່, ກະ ມັຮ ກວາຍ ອາຕີ ຄານອດ ແຕີ່ອ໌ ປໍ ເຍືາ. ແຕ ມູ່ ກັອຍ, ເບີນ ອັນ ກາ ເຍືາ ກາຈີດ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ. ເບີນ ອັນ ກາ ເຍືາ ປຍາຍຮ ຕຶ່ງ ດຸງ ຊາງ ເຍືາ. ກະ ເບີນ ອັນ ກາ ເຍືາ ຕູ່ຍຮ ອາລັ່ອຮ ແຕ ເມືອງ ໄນ່ ເປາະ ປໍ ເມືອງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ນ່ະກັອຍ ໂຕ່ດ ໄລ່ ກາ ກາຈີດ ກວາຍ ຕານັ່ອງ ອໍ ຕຶ່ງ ກູແຕອ໌ ໄນ່, ເຢືາງ ເຈົາຣາຊີ ໂອນ ເຍືາ ຕຳເປຣ່ອ໌ ເຕ່ ໂຕ່ດ ກັອຍ, ຍ່ອນ ເຍືາ ລາ ຈຸ່ມເຈືອ ໄລ່ ກັອຍ. ໂຕ່ດ ກັອຍ ເບີນ ແຕ ຕາໄງ ໄລ່ ກາຈີດ ອາເບລ, ອັນ ກາ ກວາຍ ຕານັ່ອງ ອໍ ແຕ ອຶມແບິ; ກະ ເຕົ່າ ໂອນ ແຕີ່ອ໌ ໄລ່ ກາຈີດ ເຊກາຣີຢາ ລາ ກອນ ເບເຣກີຢາ ແອັນ. ເຍືາ ກາຈີດ ເຊກາຣີຢາ ປື່ນ ກຼຸງ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ ແຈ່ະ ຊັນເຕຣືາງ ກາ ໄລ່ ຊາງ ຣີ່ດ. ");
INSERT INTO ncq_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ກູ່ ຣາມຶ່ຮ ໂຕ່ດ ກັອຍ ແຕີ່ອ໌ ປໍ ເຍືາ ກາ ແອີດ ຕຶ່ງ ແດີຍ ໄນ່! ");
INSERT INTO ncq_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","\"ເອີ ເຢຣູຊາເລັມ, ເຍືາ ກາ ແອີດ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ ເອີຍ! ເຍືາ ລາ ກວາຍ ກາ ເກີ່ຍ ກາຈີດ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ກະ ເຍືາ ແກຼງ ຕາເມົາ ໂຈະ ມັຮ ກວາຍ ກາ ເຢືາງ ເຈົາຣາຊີ ແປຣີ ແຕີ່ອ໌ ປໍ ເຍືາ. ເບີນ ຊາອຶ່ຍ ເຮີບ ເຈີ່ ເກົາ ຢໍອ໌ ອີ ປາໂຣມ ອຶນແຍ່ະ ມັຮ ເຍືາ ນ່ະ ອຶນຕຣວຍ ອາກັນ ກູຕຣຸກ ກູອ໌ ກອນ ອັນ ໂອນ ແອີດ ປື່ນ ຊານັງ. ມາ ເຍືາ ຕາ ປຣ່ອມ! ");
INSERT INTO ncq_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ຊານໍ່ ເກົາ ຕາ ເບີນ ເປາະ ໄກຼ່ຮ ເກຼີ່ ນັ່ອງ ດຸງຊູ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ນ່ະກັອຍ ເກົາ ອາຕີ ເຍືາ ປາຍ: ປັຣແນີ ມັນເຕຣືາ ເຍືາ ຕາ ເບີນ ເຮີມ ນັ່ອງ ເກົາ ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ເຍືາ ປາຍ: 'ບຸ່ນ ລາລື່ ອັນ ກາ ແຕີ່ອ໌ ຍ່ອນ ຣາມຶ່ຮ ອຶນເຈົາ ໄຮ.'\" ");
INSERT INTO ncq_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ພໍກາ ເຢຊູ ລັ່ອຮ ແຕ ດຸງ ຊາງ ປື່ດ, ເຈີ່ ເປາະ ຕຶ່ງ ຣານາ, ເບີນ ມູ່ ກາ ຣຍານ ແຕ ອັນ ແຕີ່ອ໌ ປໍ ອັນ ກະ ຊາດອຍ ໂອນ ອັນ ເນ່ ປໍ ດຸງ ຊາງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ເຢຊູ ອາຕີ ໄລ່ ກັອຍ ປາຍ: \"ເຍືາ ເຮີມ ອຶນແຍ່ະ ດຸງ ປື່ດ ແອີດ ອຶນໄນ່ ບໍ? ເຈີ່ ປໍ ເມືາງ ຕາເມົາ ເນົ່າ ຕະ ດຸງ ປື່ດ ໄນ່ ຕາ ເບີນ ຣາແຕັດ ນັ່ອງ ມັນຕຸ. ອັນ ຣາຕັຮ ອຶນແຍ່ະ.\" ");
INSERT INTO ncq_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ບັອງ ກາ ເຢຊູ ຕາກູ ແອີດ ຕຶ່ງ ກົຮ ອາໂປ່ນ, ເບີນ ແອີງ ມູ່ ກາ ຣຍານ ແຕ ອັນ ຊັອງ ແຕີ່ອ໌ ກະ ອັນ. ໄລ່ ຕາແບີບ ອັນ ປາຍ: \"ອາຈານ ເອີຍ! ແຊອ໌ ອາຈານ ອາຕີ ໂອນ ຮິ ດັງ, ອຶນນັ່ອງ ມາແລ່ະ ດູ່ນ ຣານະ ໄນ່ ແຕີ່ອ໌? ເບີນ ອຶນເຕົ່າ ອາປັຮ ໂອນ ຮິ ດັງ ອາຈານ ແຕີ່ອ໌ ລັ່ຮ ປໍ ກູແຕອ໌ ໄນ່ ກະ ແຕີ່ອ໌ ຕາໄງ ປັຣຊົດ?\" ");
INSERT INTO ncq_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ອຶງເຄາະ ເຍືາ ລາວັ່ງ ໂອນ ອໍ. ອຶນໂຈຍ ໂອນ ເນົ່າ ຣາພິ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ເຈີ່ ປໍ ເມືາງ ເບີນ ຊາອຶ່ຍ ນະ ແຕີ່ອ໌ ອາງ ຣາມຶ່ຮ ເກົາ, ກະ ປາຍ: 'ກູໂຕ ເກົາ ໄນ່ ແຕິ່ ລາ ກຣີດ!' ນ່ະກັອຍ ໄລ່ ຣາພິ ກຼຶ່ງ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ພໍກາ ເຍືາ ຊັອງ ຮານ ເນົ່າ ຣາຕະ ແຈ່ະໆ ເຢີ່ງໆ, ເຍືາ ອຶນໂຈຍ ເກຣ່າະ ອຶນເຕົ່າ. ຣານະ ໄນ່ ອຶງເຄາະ ແຕີ່ອ໌ ອຶນໂຍ່ງ ເວືາຍ. ມາ ຕາ ຢວາຮ ແຕີ່ອ໌ ຕາໄງ ປັຣຊົດ. ");
INSERT INTO ncq_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ເບີນ ມູ່ ໄນ່ ຣາຕະ ກະ ມູ່ ກັອຍ, ກະ ກຣວາງ ໄນ່ ຣາຕະ ກະ ກຣວາງ ກັອຍ. ເບີນ ຊາອຶ່ຍ ອຶນຕຸ ແອິ ຊັຣນາ ຈາ. ກະ ເບີນ ຊາອຶ່ຍ ອຶນຕຸ ກູແຕອ໌ ຣາໄມ່ ກະ ກູກື່ດ. ");
INSERT INTO ncq_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ມັຮ ຣາມຶ່ຮ ໄນ່ ລາ ຣາມຶ່ຮ ຕຸ່ຮ ກັ່ດ ກາ ຕາແບິ ຊັອງ, ນ່ະ ມັນແຊມ ຕິ່ ຕຶ່ງ ປຸ່ງ ອີ ຣັ່ຮ ກອນ. ");
INSERT INTO ncq_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","\"ເບີນ ກວາຍ ມ່ອບ ເຍືາ ປໍ ອາຕີ ກວາຍ ຕາ ອໍ ໂອນ ໄລ່ ກັອຍ ກາຈີດ ເຍືາ. ຕຶ່ງ ຕາໄງ ກັອຍ ອຶນແຍ່ະ ມັຮ ກວາຍ ຊາອັຣ ເຍືາ ຍ່ອນ ເຍືາ ປວາຍ ຣານະ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ບັອງ ກາ ກັອຍ ເບີນ ຊາອຶ່ຍ ນະ ກວາຍ ກາ ຕາປູ່ນ ເກົາ, ໄລ່ ຕາ ເຣືາບ ຕາປູ່ນ ນັ່ອງ. ໄລ່ ມານະ ປ່ອງ ມານະ ໂອນ ກວາຍ ຊົດ ກາຈີດ. ກະ ໄລ່ ມານະ ຊາອັຣ ມານະ. ");
INSERT INTO ncq_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ເບີນ ຊາອຶ່ຍ ນະ ກວາຍ ແຕີ່ອ໌ ປາຍ ໄລ່ ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ. ມາ ໄລ່ ຣາພິ ໂອນ ກຼຶ່ງ ກວາຍ ຊັຣລຸ ກະ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ຍ່ອນ ຣານະ ຕາ ອໍ ເປາະ ປຼັຮ ກູ່ ອຶນຕຸ, ນ່ະກັອຍ ໄລ່ ກາ ມານະ ອາໂຢ່ະ ມານະ ແຕ ອຶນໂຍ່ງ, ແກີດ ອຶນຕຍາຮ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ມາ ມັຮ ກວາຍ ກາ ເຣືາບ ຈີວ໌ ເຕົ່າ ຊົດ ແດີຍ ໄລ່, ເຢືາງ ເຈົາຣາຊີ ຈ່ອຍ ອາມົ່ງ ກວາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ປັຣນາຍ ອໍ ແຕ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ, ເບີນ ກວາຍ ອາຕີ ປັຣນາຍ ກັອຍ ປຼັຮ ກູ່ ກຣວາງ ຕຶ່ງ ກູແຕອ໌ ໄນ່ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ ເຕ່ອ໌ ດັງ. ແວັດ ກັອຍ, ແຕີ່ອ໌ ຕາໄງ ປັຣຊົດ ເລີ່ຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","\"ປັຣແນີ ມັນເຕຣືາ ເຍືາ ເຮີມ ມັຮ ຣາມຶ່ຮ ກາ ດານີເອລ, ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ປາຍ ແຕ ອຶມແບິ ເຈີ່. ດານີເອລ ປາຍ ເບີນ ເນົ່າ ດໍອ໌ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ ເກຣີ່ງ ແປຣິ່ ກາ ເຢືາງ ເຈົາຣາຊີ ຕາ ແອອ໌ ອີ ເຮີມ (ກວາຍ ອາແລ່ະ ກາ ອານ ປັຣນາຍ ໄນ່, ອຶງເຄາະ ອັນ ຊາປຸ່ຮ ເບີມ ແຕ ປັຣນາຍ ໄນ່.) ");
INSERT INTO ncq_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ຕາໄງ ກັອຍ ກວາຍ ກາ ແອີດ ຕຶ່ງ ແຄງ ຢູດາຍ ອຶງເຄາະ ຕາລຸ່ຮ ຊັອຮ ແອີດ ຕຶ່ງ ກົຮ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ອັນ ກາ ແອີດ ຕຶ່ງ ຕຳປວລ ດຸງ ເປືາຣ, ອຶງເຄາະ ອັນ ຕາລຸ່ຮ ອາແຊງ ອຶນໂຈຍ ມູ່ດ ອີດ ນັ່ອງ ເກຣີ່ງ ຕຶ່ງ ດຸງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ອັນ ກາ ແອີດ ປໍ ໄທຣ ອຶງເຄາະ ອຶນໂຈຍ ເຈົາ ອີດ ນັ່ອງ ເກຣີ່ງ ແຕ ດຸງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ຕຶ່ງ ຕາໄງ ກັອຍ ໂຕຍ໌ ບາບ ລາລື່ ໄລ່ ກາ ແອີດ ຕຶ່ງ ຈະ ກະ ໄລ່ ກາ ອາໂຍະ ກອນ. ");
INSERT INTO ncq_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ນ່ະກັອຍ, ອຶງເຄາະ ເຍືາ ເກົາແຊອ໌ ອຶນໂຈຍ ໂອນ ເຍືາ ຕາລຸ່ຮ ຕຶ່ງ ກາໄຊ ຊາແງດ, ກະ ເກົາແຊອ໌ ອຶນໂຈຍ ໂອນ ເຍືາ ຕາລຸ່ຮ ຕຶ່ງ ຕາໄງ ຣາລູ່. ");
INSERT INTO ncq_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ຕຶ່ງ ຕາໄງ ກັອຍ ເບີນ ຕຸ່ຮ ກັ່ດ ກາເລີຍ ແຕ ຕາແບິ ເຢືາງ ເຈົາຣາຊີ ແຕງ ມັນລັ່ອງ ກູແຕອ໌ ເຕົ່າ ແຕີ່ອ໌ ຊານໍ່. ກະ ປັຣແນີ ມັນເຕຣືາ ຕາ ເບີນ ຕຸ່ຮ ກັ່ດ ນັ່ອງ ນ່ະ ຕາໄງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ຄັນ ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ອາຣູ່ຍ໌ ລັ່ຮ ມັຮ ຕາໄງ ກັອຍ, ຕາ ເບີນ ເນົ່າ ເຕ່ອ໌ ອາມົ່ງ ນັ່ອງ. ມາ ຍ່ອນ ອັນ ຢໍອ໌ ອີ ຈ່ອຍ ມັຮ ກວາຍ ກາ ອັນ ຣຽຮ, ອັນ ອາຣູ່ຍ໌ ລັ່ຮ ມັຮ ຕາໄງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","\"ຄັນ ເນົ່າ ອາຕີ ເຍືາ ປາຍ: 'ໄນ່! ອັນ ໄນ່ ລາ ກຣີດ!' ແຕີລາ 'ຕິຮ! ອັນ ກາ ແອີດ ປໍ ກັອຍ ລາ ກຣີດ!' ເຍືາ ອຶນໂຈຍ ຊາງັດ ປັຣນາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ຍ່ອນ ປັຣແນີ ມັນເຕຣືາ ເບີນ ກວາຍ ຕາ ແກີນ ກຣີດ, ກະ ຕາ ແກີນ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ແຕີ່ອ໌ ປໍ ເຍືາ. ໄລ່ ກັອຍ ອາປັຮ ມັຮ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ດໍອ໌ ອີ ບູບວກ ອາໂລກ. ຄັນ ເຕ່ອ໌, ໄລ່ ຢໍອ໌ ອີ ຣາກຽວ ກວາຍ ກາ ເຢືາງ ເຈົາຣາຊີ ຣຽຮ ເຈີ່, ໂອນ ໄລ່ ຕະ ຣານະ ຕາ ອໍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ໄນ່! ເກົາ ອາຕີ ດໍອ໌ ໂອນ ເຍືາ ດັງ ອຶນໂຍ່ງ ແຕ ຣານະ ກັອຍ ຕາ ຢວາຮ ແຕີ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","\"ນ່ະກັອຍ, ຄັນ ເບີນ ເນົ່າ ອາຕີ ເຍືາ ປາຍ: 'ຕິຮ! ເບີນ ມານະ ກຣີດ ແອີດ ຕຶ່ງ ຕຍາຮ ກັອຍ!,' ເຍືາ ອຶນໂຈຍ ເປາະ ແຕີ່ອ໌ ອຶນຕຸ ກັອຍ. ແຕີລາ ໄລ່ ປາຍ: 'ຕິຮ! ມານະ ກຣີດ ແອີດ ໂຕ່ະ ຕຶ່ງ ດຸງ ກັອຍ!' ເຍືາ ອຶນໂຈຍ ຊາງັດ. ");
INSERT INTO ncq_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ໄກຣ ລາລື່, ເກົາ ກອນ ເຢືາງ ແກີດ ກວາຍ ແຕີ່ອ໌ ນ່ະ ຕາລຍາຣ ກັລກາງ ແຕ ມັ່ດ ມານາງ ລັ່ອຮ ແຕີ່ອ໌ ມັ່ດ ມານາງ ປັດ. ");
INSERT INTO ncq_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","\"ອຶນຕຸ ແລ່ະ ເບີນ ກູມັບ, ອຶນຕຸ ກັອຍ ເບີນ ແຈມ ມຽດ ແຊງ ໂຣ່ມ ຈາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ເຢຊູ ອາຕີ ແອັນ ປາຍ: \"ແວັດ ແຕ ຕາໄງ ຕຸ່ຮ ກັ່ດ ກັອຍ, ມັ່ດ ມານາງ ແກີດ ການຳ, ກະ ຣາລັ່ງ ກາໄຊ ຕາ ເບີນ ປາເລືາງ ນັ່ອງ. ມັນໂຕຣ ຊາແລັຮ ແຕ ມັນລັ່ອງ. ກະ ມັຮ ຣາມຶ່ຮ ອຶນເຕົ່າ ກາ ເບີນ ອຳນາດ ຕຶ່ງ ມັນລັ່ອງ, ເຢືາງ ເຈົາຣາຊີ ຕະ ໂອນ ຣາໄມ່ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ແວັດ ກັອຍ ແອີດ ຕຶ່ງ ມັນລັ່ອງ ເບີນ ມວຍ ຣາມຶ່ຮ ໂອນ ເນົ່າ ດັງ ແຕ ກອນ ເຢືາງ ແກີດ ກວາຍ. ເຈີ່ ກູ່ ຣາມຶ່ຮ ກວາຍ ແອີດ ຕຶ່ງ ກູແຕອ໌ ໄນ່, ໄລ່ ເຍືາມ ກູໂກຼຍ໌ ຍ່ອນ ໄລ່ ຊັອງ ອຶງກັອຮ. ໄລ່ ເຮີມ ເກົາ, ລາ ກອນ ເຢືາງ ແກີດ ກວາຍ, ແຕີ່ອ໌ ອຶນດີ ຣາມິ່ລ, ເບີນ ອຳນາດ ປື່ດ ກະ ອາງອື່ຣ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ບັອງ ກາ ກັອຍ ເນົ່າ ຊັອງ ຊຽງ ເນົ່າ ປຼົງ ຕາກອຍ ເຣ່ງ ລາລື່, ເຈີ່ ເກົາ ແປຣີ ມັຮ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ປາໂຣມ ກູ່ ນະ ມັຮ ກວາຍ ກາ ເກົາ ຣຽຮ ແຕ ແປີງ ເຕົ່າ ແຕີ່ອ໌ ປໍ ກາແດີບ, ກະ ກູ່ ອຶນຕຸ ຈວບ ປື່ນ ມັນລັ່ອງ ກຣຸ່ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","\"ເຍືາ ຊາງັດ ເກົາ ຊາກຳ ແຕ ອາລ່ອງ ລາວັ່ຮ. ຄັນ ອາແບງ ອາລ່ອງ ກັອຍ ອຶນນັ່ອງ ອຶນຍ່ອມ, ອັນ ໄບອ໌ ປາດັອຮ ລັ່ຮ ຊາລາ ອຶນຍ່ອມ ເຕ່. ນ່ະກັອຍ ເຍືາ ດັງ ແຈ່ະ ອີ ແຕີ່ອ໌ ກາໄຊ ພວາອ໌. ");
INSERT INTO ncq_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ມູເຈິງ ກັອຍ ເຕ່, ຄັນ ເຍືາ ເຮີມ ອຶນແຍ່ະ ຣາມຶ່ຮ ໄນ່ ແຕີ່ອ໌, ນ່ະກັອຍ ເຍືາ ດັງ ກອນ ເຢືາງ ແກີດ ກວາຍ ແຈ່ະ ອີ ແຕີ່ອ໌ ເຈີ່. ອັນ ຕາມັອກ ແອີດ ຕຶ່ງ ງັ່ຮ ຕົ່ງ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ມັຮ ກວາຍ ຕຶ່ງ ແດີຍ ໄນ່ ຕາ ເບີນ ກູຈີດ ອຶນແຍ່ະ, ອຶນໂຍ່ງ ແຕ ອຶນແຍ່ະ ຣາມຶ່ຮ ໄນ່ ແຕີ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ເຈີ່ ປໍ ເມືາງ ມັນລັ່ອງ ກະ ກູແຕອ໌ ແກີດ ປິ່ດ ອຶນແຍ່ະ, ມາ ປັຣນາຍ ເກົາ ອາຕີ ຕາ ເບີນ ແກີດ ປິ່ດ.\" ");
INSERT INTO ncq_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","\"ຕາ ເບີນ ເນົ່າ ດັງ ຕາໄງ ແລ່ະ ແຕີລາ ບັອງ ກາ ແລ່ະ ຣານະ ກັອຍ ແຕີ່ອ໌. ມັຮ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ຕຶ່ງ ມັນລັ່ອງ, ກະ ກອນ ເຢືາງ ເຈົາຣາຊີ ແຮີ ລາ ຕາ ເບີນ ດັງ ເຕ່ ຕາໄງ ກັອຍ. ແອີງ ມານະ ອຶມປໍ່ ເກົາ ແຕິ່ ດັງ ຕາໄງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ກອນ ເຢືາງ ແກີດ ກວາຍ ແຕີ່ອ໌ ລັ່ຮ ປໍ ກູແຕອ໌ ໄນ່ ລາ ນ່ະ ແດີຍ ໂນອາ ແຕ ອຶມແບິ. ");
INSERT INTO ncq_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ຕຶ່ງ ແດີຍ ໂນອາ ກັອຍ, ແຕ ອຶນໂຍ່ງ ຣາລ່ຳ ແດີອ໌ ອີ ແຕີ່ອ໌, ກວາຍ ຕຶ່ງ ແດີຍ ກັອຍ ຈາ ງ່ອຍ໌ ຣໍ່ອ໌ ບູຍ. ໄລ່ ອີດ ກອນ ລາກວຍ ມັນຕັ່ດ ແຕ ອຶນລີ່ງ ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ໂນອາ ຊັອຮ ຕຶ່ງ ຕົວະ. ");
INSERT INTO ncq_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ໄລ່ ຕາ ເບີນ ດັງ ຣາມຶ່ຮ ອຶນເຕົ່າ ເລີ່ຍ ກາ ແຕີ່ອ໌ ປໍ ໄລ່. ມາ ບັອງ ກາ ຣາລ່ຳ ແດີອ໌ ກັອຍ ແຕີ່ອ໌, ເຈີ່ ແດີອ໌ ກັອຍ ເດີງ ໄລ່ ຊາໂລຍ ອຶນແຍ່ະ. ພໍກາ ກອນ ເຢືາງ ແກີດ ກວາຍ ແຕີ່ອ໌ ລັ່ຮ ປໍ ກູແຕອ໌ ໄນ່ ລາ ມູເຈິງ ກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ບັອງ ກັອຍ ເບີນ ບາຣ ນະ ຣາເລົາ ແອີດ ຕະ ຣານະ ຕຶ່ງ ໄທຣ. ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ເດີງ ມານະ, ມາ ມານະ ແອັນ ອັນ ໂອນ ແອີດ ລັ່ຮ ຕຶ່ງ ໄທຣ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ກະ ບັອງ ກັອຍ ເຕ່ ເບີນ ບາຣ ນະ ມັນແຊມ ແອີດ ກູກຼົຮ ທຣໍ. ເທວາດາ ກັອຍ ເດີງ ມານະ, ກະ ມານະ ແອັນ ອັນ ໂອນ ແອີດ ລັ່ຮ ອຶງກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ນ່ະກັອຍ ອຶງເຄາະ ເຍືາ ຕາງວຍ ເລືອຍໆ, ຍ່ອນ ເຍືາ ຕາ ດັງ ຕາໄງ ແລ່ະ ອຶນເຈົາ ເຍືາ ແຕີ່ອ໌ ລັ່ຮ ປໍ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ອຶງເຄາະ ເຍືາ ດັງ ເຕ່, ຄັນ ອຶນເຈົາ ດຸງ ມາ ດັງ ບັອງ ແລ່ະ ກວາຍ ຊາແວງ ອີ ມູ່ດ ຕູຕວຍ໌ ຕຶ່ງ ດຸງ ອັນ, ອຶນເຈົາ ດຸງ ກັອຍ ຕາງວຍ ເລືອຍໆ ຕາ ເບີນ ໂອນ ກວາຍ ຊາແວງ ກັອຍ ເຕ່ອ໌ ມູ່ດ ຕູຕວຍ໌ ຕຶ່ງ ດຸງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ນ່ະກັອຍ ອຶງເຄາະ ເຍືາ ກຽມ ດໍອ໌ ເລືອຍໆ ເຕ່, ຍ່ອນ ເຍືາ ຕາ ເບີນ ດັງ ບັອງ ກາ ແລ່ະ ເກົາ ກອນ ເຢືາງ ແກີດ ກວາຍ ແຕີ່ອ໌ ລັ່ຮ. ເກົາ ແຕີ່ອ໌ ຕຶ່ງ ຕາໄງ ກາ ເຍືາ ຕາ ເບີນ ຄຶ່ດ ອຶນເຕົ່າ ປາຍ ເກົາ ອີ ແຕີ່ອ໌.\" ");
INSERT INTO ncq_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","\"ຄັນ ເບີນ ກວາຍ ຊູລ ຕະ ອໍ ກະ ຣາໄງ່ອ໌ ຣາລັ່ງ, ເນືາຍ ຈົຮ ໂອນ ອັນ ຕະ ຊົດ ເນ່ ມັຮ ກວາຍ ການໍ່ອ໌ ກາ ຕະ ຣານະ ອັນ. ເນືາຍ ອາຕີ ໂອນ ໄລ່ ຈາ ອຶນເຕົ່າ, ອັນ ອີດ ໂອນ ໄລ່ ຣາມຶ່ຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ຄັນ ຊູລ ກັອຍ ຕະ ປຍາຍ໌ ອຶນແຍ່ະ ມັຮ ຣານະ ເນືາຍ ອັນ ອາຕີ, ອັນ ຊັອງ ຣໍ່ອ໌ ບັອງ ກາ ເນືາຍ ອັນ ເຈົາ ລັ່ຮ ປໍ ດຸງ! ");
INSERT INTO ncq_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ປັຣແນີ ມັນເຕຣືາ ເນືາຍ ກັອຍ ໂອນ ຊູລ ກັອຍ ບັນ ກຍາອ໌ ອຶນແຍ່ະ ມັຮ ມູ່ນ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ມາ ຄັນ ກວາຍ ຊູລ ກັອຍ ມາ ຕາ ເບີນ ອໍ, ອັນ ຄຶ່ດ ຕຶ່ງ ຣາງຶ່ຮ ອັນ ປາຍ: 'ອຶນນັ່ອງ ດູ່ນ, ແຕ ເນືາຍ ເກົາ ເຈົາ.' ");
INSERT INTO ncq_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ນ່ະກັອຍ ອັນ ປຍາຍຮ ມັຮ ຊູລ ກາ ຕະ ຣານະ ເນືາຍ ອັນ, ກະ ອັນ ເປາະ ຈາ ງ່ອຍ໌ ໂອນ ບູລ ລໍາແປ່ະ ລັງຮຍາ ນ່ະ ເນົ່າ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ເຈີ່ ເນືາຍ ຊູລ ກັອຍ ເຈົາ, ມາ ຊູລ ກັອຍ ຕາ ເບີນ ດັງ ຕາໄງ ກັອຍ, ກະ ອັນ ຕາ ເບີນ ຄຶ່ດ ອຶນເຕົ່າ ເລີ່ຍ ແຕ ຣານະ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ນ່ະກັອຍ ເນືາຍ ກັອຍ ໄປ່ອ໌ ຕັຮ ຈະ ກວາຍ ຊູລ ກັອຍ. ກະ ເນືາຍ ກັອຍ ໂອນ ຊູລ ກັອຍ ແອີດ ມັນຕຸ ກະ ໄລ່ ກາ ມາມ ອໍ ມາ ຣາງຶ່ຮ ໂກ່ະ. ອຶນຕຸ ກັອຍ ເນົ່າ ເຍືາມ ກະ ເນົ່າ ກາເຕຣືອກ ກາແນງ ກາບາງ ຊັອງ ຕຸ່ຮ ກັ່ດ ລາລື່.\" ");
INSERT INTO ncq_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","\"ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ລາ ນ່ະ ມວຍ ຈິ່ດ ນະ ກູໂມຣ ກາ ອີດ ຕາກຍາງ ໄລ່, ເຈີ່ ໄລ່ ເກຣາະ ອີ ເປາະ ປັຣຊວຍ ກະ ອັນ ກາ ອີ ອີດ ລາກວຍ. ");
INSERT INTO ncq_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ເຊີງ ນະ ກູໂມຣ ກັອຍ ລາ ຊາກູລ, ກະ ເຊີງ ນະ ລາ ຣາໄງ່ອ໌ ຣາລັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ໄລ່ ກາ ຊາກູລ, ໄລ່ ເດີງ ຕາກຍາງ ມາ ໄລ່ ຕາ ເບີນ ເດີງ ອຶນຊີ່ງ ກັຣເລີຍ. ");
INSERT INTO ncq_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ມາ ໄລ່ ກາ ຣາໄງ່ອ໌ ຣາລັ່ງ, ໄລ່ ເດີງ ຕາກຍາງ, ກະ ເດີງ ອຶນຊີ່ງ ຕຶ່ງ ກອງ ການໍ່ອ໌ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ມາ ດູ່ນ ລາລື່ ອັນ ກາ ເປາະ ອີດ ລາກວຍ ກັອຍ ຕາ ເບີນ ແຕີ່ອ໌. ເຈີ່ ມັຮ ກູໂມຣ ກັອຍ, ອັນ ກາ ບິກູ, ອັນ ກາ ບິ ລາເງ່ດ ເລີ່ຍ. ");
INSERT INTO ncq_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","\"ແຕີ່ອ໌ ດີດຶ່ກ ເນົ່າ ກູອ໌ ເຣ່ງ ລາລື່ ປາຍ: 'ເຍືາ ເນ່! ອັນ ກາ ເປາະ ອີດ ລາກວຍ ແຕີ່ອ໌ ເຈີ່! ເຍືາ ເປາະ ຣາມົຮ ອັນ!' ");
INSERT INTO ncq_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ອຶນແຍ່ະ ມັຮ ມວຍ ຈິ່ດ ນະ ກູໂມຣ ກັອຍ ຕາແມີ ອຶນແຍ່ະ. ກະ ໄລ່ ກຽມ ດໍອ໌ ຕາກຍາງ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ໄລ່ ກາ ຊາກູລ ປາຍ ກະ ໄລ່ ກາ ຣາໄງ່ອ໌ ຣາລັ່ງ ນ່ະໄນ່: 'ແຊອ໌ ເຍືາ ອຶມແປອ໌ ໂອນ ຮິ ແຮີ ອຶນຊີ່ງ ເຍືາ. ຕາກຍາງ ຮິ ອຶນແຍ່ະ ອຶນຊີ່ງ ເຈີ່.' ");
INSERT INTO ncq_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ມາ ໄລ່ ກາ ຣາໄງ່ອ໌ ຣາລັ່ງ ຕາແອີຍ ລັ່ຮ ໄລ່ ປາຍ: 'ຮິ ຕາ ເຕ່ອ໌ ອຶມແປອ໌. ອຶງກັອຮ ອຶນຊີ່ງ ຕາ ເບີນ ຕາກັງ ໂອນ ຮິ ກະ ເຍືາ. ປຍາຍ໌ ເຍືາ ເປາະ ແຈີງ ປໍ ມູ່ ກາ ຈິ ອຶນຊີ່ງ ກັອຍ.' ");
INSERT INTO ncq_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ມາ ບັອງ ກາ ໄລ່ ເປາະ ແຈີງ, ບັອງ ກາ ກັອຍ ແຕິ່ ອັນ ກາ ເປາະ ອີດ ລາກວຍ ແຕີ່ອ໌. ກະ ໄລ່ ເຊີງ ນະ ກາ ອຶນນັ່ອງ ເບີນ ອຶນຊີ່ງ, ໄລ່ ມູ່ດ ແຮ ຈາ ປັຣຊວຍ ມັນຕຸ ກະ ອັນ ກາ ອີດ ລາກວຍ. ເຈີ່ ເນົ່າ ກາໄຕ່ຮ ຕົ່ງ. ");
INSERT INTO ncq_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","\"ແວັດ ກັອຍ, ໄລ່ ກາ ເປາະ ແຈີງ ອຶນຊີ່ງ ເຈົາ. ໄລ່ ກູອ໌ ປາຍ: 'ອຶນເຈົາ ເອີຍ! ອຶນເຈົາ ເອີຍ! ເປິຮ ກູຕົ່ງ ໂອນ ຮິ ມູ່ດ ເຕ່!' ");
INSERT INTO ncq_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ມາ ອຶນເຈົາ ກັອຍ ຕາແອີຍ ລັ່ຮ ປາຍ: 'ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ເກົາ ຕາ ເບີນ ດັງ ເຍືາ.'\" ");
INSERT INTO ncq_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ເຈີ່ ເຢຊູ ປາຍ ແອັນ: \"ນ່ະກັອຍ ອຶງເຄາະ ເຍືາ ແອີດ ຕາງວຍ ເລືອຍໆ, ຍ່ອນ ເຍືາ ຕາ ເບີນ ດັງ ຕາໄງ ແລ່ະ ກະ ບັອງ ແລ່ະ ກອນ ເຢືາງ ແກີດ ກວາຍ ແຕີ່ອ໌ ລັ່ຮ ປໍ ກູແຕອ໌ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","\"ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ລາ ນ່ະ ມານະ ກວາຍ ເປາະ ຕາມອຍ ກຣວາງ ເຢີ່ງ. ບັອງ ກາ ອັນ ແຈ່ະ ອີ ເປາະ, ອັນ ກູອ໌ ກວາຍ ຕະ ຣານະ ອັນ. ເຈີ່ ອັນ ມ່ອບ ໂອນ ມັຮ ກວາຍ ກັອຍ ປຣະ ມູ່ນ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ອັນ ກາ ຣາໄງ່ອ໌ ລາລື່, ອັນ ໂອນ ເຊີງ ແນນ. ອັນ ກາ ຣາໄງ່ອ໌ ພາດາມ ຊັອງ, ອັນ ໂອນ ບາຣ ແນນ. ກະ ອັນ ກາ ຣາໄງ່ອ໌ ບີ່ອ໌, ອັນ ໂອນ ມວຍ ແນນ ຊັອງ. ເຈີ່ ອຶນເຈົາ ກັອຍ ເປາະ. ");
INSERT INTO ncq_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ອັນ ກາ ຣັ່ບ ເຊີງ ແນນ ກັອຍ ເປາະ ຈິແຈີງ ແຕິ່. ເຈີ່ ອັນ ເບີນ ກຳໄລ ເຊີງ ແນນ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ອັນ ກາ ຣັ່ບ ບາຣ ແນນ ກັອຍ, ອັນ ຕະ ມູເຈິງ ກັອຍ ເຕ່. ເຈີ່ ອັນ ເບີນ ກຳໄລ ບາຣ ແນນ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ມາ ອັນ ກາ ຣັ່ບ ມວຍ ແນນ ຊັອງ, ອັນ ປິ່ ປຣຸ່ງ, ເຈີ່ ອັນ ແຕິບ ດໍອ໌ ປຣະ ອຶນເຈົາ ອັນ ຕຶ່ງ ກູແຕອ໌. ");
INSERT INTO ncq_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","\"ດູ່ນ ກາໄຊ ດູ່ນ ກູມໍ, ອຶນເຈົາ ກັອຍ ລົ່ບ ເຈົາ ລັ່ຮ. ອັນ ຕາແບີບ ລັ່ຮ ມັຮ ປຣະ ກາ ອັນ ໂອນ ປໍ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ກວາຍ ກາ ຣັ່ບ ເຊີງ ແນນ, ອັນ ແຕີ່ອ໌ ເດີງ ເຊີງ ແນນ ການໍ່ອ໌ ແອັນ. ກະ ອັນ ປາຍ: 'ອຶນເຈົາ ເອີຍ! ແຕ ຕາແບິ ອຶນເຈົາ ໂອນ ເກົາ ເຊີງ ແນນ. ມາ ຊານໍ່ ເກົາ ເບີນ ກຳໄລ ເຊີງ ແນນ ແອັນ.' ");
INSERT INTO ncq_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ອຶນເຈົາ ກັອຍ ຕາແອີຍ ປາຍ: 'ອໍ ເຈີ່! ໄມ່ ລາ ກວາຍ ຕະ ຣານະ ອໍ ກະ ປຍາຍ໌ ລາລື່. ໄມ່ ຕະ ຕານັ່ອງ ຕາປຶ່ງ ລາລື່ ຕຶ່ງ ຣາມຶ່ຮ ແກດໆ ໄນ່. ນ່ະກັອຍ ເກົາ ໂອນ ໄມ່ ຕາລາ ຊາອຶ່ຍ ຣາມຶ່ຮ ປື່ດ ລາລື່ ແອັນ. ກະ ເກົາ ໂອນ ໄມ່ ເບີນ ແອີດ ຣໍ່ອ໌ ບູຍ ມັນຕຸ ກະ ເກົາ ເຕ່.' ");
INSERT INTO ncq_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ກວາຍ ກາ ຣັ່ບ ບາຣ ແນນ ກັອຍ, ອັນ ແຕີ່ອ໌ ກະ ເດີງ ບາຣ ແນນ ການໍ່ອ໌ ແອັນ. ກະ ອັນ ປາຍ: 'ອຶນເຈົາ ເອີຍ! ແຕ ຕາແບິ ອຶນເຈົາ ໂອນ ເກົາ ບາຣ ແນນ. ມາ ຊານໍ່ ເກົາ ເບີນ ກຳໄລ ບາຣ ແນນ ແອັນ.' ");
INSERT INTO ncq_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ອຶນເຈົາ ກັອຍ ຕາແອີຍ ປາຍ: 'ອໍ ເຈີ່! ໄມ່ ລາ ກວາຍ ຕະ ຣານະ ອໍ ກະ ປຍາຍ໌ ລາລື່. ໄມ່ ຕະ ຕານັ່ອງ ຕາປຶ່ງ ລາລື່ ຕຶ່ງ ຣາມຶ່ຮ ແກດໆ ໄນ່. ນ່ະກັອຍ ເກົາ ໂອນ ໄມ່ ຕາລາ ຊາອຶ່ຍ ຣາມຶ່ຮ ປື່ດ ລາລື່ ແອັນ. ກະ ເກົາ ໂອນ ໄມ່ ເບີນ ແອີດ ຣໍ່ອ໌ ບູຍ ມັນຕຸ ກະ ເກົາ ເຕ່.' ");
INSERT INTO ncq_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","\"ອຶນຕູ່ນ ກັອຍ ກວາຍ ກາ ຣັ່ບ ມວຍ ແນນ, ອັນ ແຕີ່ອ໌ ກະ ປາຍ: 'ອຶນເຈົາ ເອີຍ! ເກົາ ດັງ ໄມ່ ປາຊິ ລາລື່ ປຣະ ໄມ່. ໄມ່ ຕາ ເບີນ ຈົຮ, ມາ ໄມ່ ອີ ໂປຍ໌. ກະ ໄມ່ ຕາ ເບີນ ຈັ່ດ, ມາ ໄມ່ ອີ ຊອດ. ");
INSERT INTO ncq_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ຍ່ອນ ເກົາ ອຶງກັອຮ, ເຈີ່ ເກົາ ແຕິບ ດໍອ໌ ປຣະ ໄມ່ ຕຶ່ງ ກູແຕອ໌. ຊານໍ່ ເກົາ ກູລັຮ ລັ່ຮ ໂອນ ອຶນເຈົາ ປຣະ ໄນ່.' ");
INSERT INTO ncq_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ອຶນເຈົາ ກັອຍ ຕາແອີຍ ປາຍ: 'ໄມ່ ລາ ກວາຍ ຕາ ອໍ ກະ ອາລັ່ຮ ລາລື່. ໄມ່ ດັງ ເຈີ່ ເກົາ ຕາ ເບີນ ຈົຮ, ມາ ເກົາ ອີ ໂປຍ໌. ກະ ເກົາ ຕາ ເບີນ ຈັ່ດ, ມາ ເກົາ ອີ ຊອດ. ");
INSERT INTO ncq_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ຄັນ ນ່ະກັອຍ, ຄາອ໌ ໄມ່ ດໍອ໌ ປຣະ ເກົາ ຕຶ່ງ ທະນາຄານ. ເຈີ່ ແຕີ່ອ໌ ຕາໄງ ອາແລ່ະ ເກົາ ເຈົາ ລັ່ຮ, ເກົາ ເບີນ ປຣະ ກັອຍ ກະ ກຳໄລ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ນ່ະກັອຍ ຊານໍ່, ອີດ ຊັອງ ປຣະ ແຕ ກວາຍ ໄນ່, ເຈີ່ ໂອນ ອັນ ກາ ເບີນ ມວຍ ຈິ່ດ ແນນ ກັອຍ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ອັນ ກາ ເບີນ ຊາອຶ່ຍ, ເກົາ ໂອນ ອັນ ເບີນ ຊາອຶ່ຍ ລາລື່ ແອັນ, ແກຼີຍ ຕັອກ ແກຼີຍ ຈາ. ມາ ອັນ ກາ ຕາ ເບີນ ເບີນ ອຶນເຕົ່າ ເລີ່ຍ, ເກົາ ໂອນ ອັນ ແອິ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ມັຮ ກວາຍ ກາ ຕະ ຕາ ເບີນ ແກີດ ກຳໄລ ອຶນເຕົ່າ, ຕາແກລ ອາລັ່ອຮ ຕັຮ ອັນ ໂອນ ອັນ ແອີດ ຕຶ່ງ ອຶນຕຸ ການຳ. ອຶນຕຸ ກັອຍ ລາ ເນົ່າ ເຍືາມຍີ່ດ ກະ ກາເຕຣືອກ ກາແນງ ກາບາງ ຊັອງ ຕຸ່ຮ ອາຣຶ່ກ ລາລື່.'\" ");
INSERT INTO ncq_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","\"ບັອງ ກາ ກອນ ເຢືາງ ແກີດ ກວາຍ ແຕີ່ອ໌ ລັ່ຮ ແກີດ ເຕືາວ ປັຣເຍືາ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ, ບັອງ ກັອຍ ອັນ ຕາກູ ຕຶ່ງ ຣາກູ ເຕືາວ ປັຣເຍືາ. ຣູ່ບເຣືາງ ອັນ ອາງອື່ຣ, ກະ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ແຕີ່ອ໌ ກະ ອັນ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ບັອງ ກັອຍ ອຶນແຍ່ະ ມັຮ ກວາຍ ໂຣ່ມ ແອີດ ຢັ່ຮ ເມືາງ ອັນ, ກະ ອັນ ກາຢັ່ຮ ອຶນແຍ່ະ ມັຮ ກວາຍ ກັອຍ ແກີດ ບາຣ ຈຸ່ມ, ນ່ະ ກວາຍ ກຍາອ໌ ກາຢັ່ຮ ແກະ ກະ ອຶມແບອ໌. ");
INSERT INTO ncq_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ເຈີ່ ອັນ ໂອນ ມັຮ ແກະ ແອີດ ຢັ່ຮ ອາຕ່ຳ, ກະ ອັນ ໂອນ ມັຮ ອຶມແບອ໌ ແອີດ ຢັ່ຮ ອາເວ່ຣ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ເຈີ່ ເຕືາວ ປັຣເຍືາ ກັອຍ ອາຕີ ໂຈະ ໄລ່ ກາ ແອີດ ຢັ່ຮ ອາຕ່ຳ ອັນ ປາຍ: 'ອຶມປໍ່ ເກົາ ໂອນ ເຍືາ ເບີນ ບຸ່ນ ຊາອຶ່ຍ. ເຍືາ ມູ່ດ ຕະ ຊົດ ຕຶ່ງ ອຶນຕຸ ເຢືາງ ເຈົາຣາຊີ ກຽມ ດໍອ໌ ມູ່ນ ໂອນ ເຍືາ. ມູ່ນ ໄນ່ ອັນ ກຽມ ດໍອ໌ ໂອນ ເຍືາ ແຕ ຕາໄງ ອັນ ແຕງ ຕຸ່ກ ຣ່ອຍ ຄຳ ຣາມຶ່ຮ ຕຶ່ງ ມັນລັ່ອງ ກະ ຕຶ່ງ ກູແຕອ໌. ");
INSERT INTO ncq_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ບັອງ ກາ ເກົາ ຊັອງ ມາເຍືາຍຮ, ເຍືາ ແຈມ ໂອນ ເກົາ ຈາ. ບັອງ ກາ ເກົາ ອາເຣືາງ ແດີອ໌, ເຍືາ ໂອນ ເກົາ ງ່ອຍ໌. ບັອງ ກາ ເກົາ ແກີດ ຕາມອຍ ກາ ເຍືາ ຕາ ເບີນ ຊາກັ່ລ, ເຍືາ ຣາບັນ ຕະ ແບອ໌ ອໍ ໂອນ ເກົາ ມູ່ດ ຕຶ່ງ ດຸງ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ບັອງ ກາ ເກົາ ແອິ ຕຳປັອກ, ເຍືາ ໂອນ ເກົາ ເບີນ ຕຳປັອກ. ບັອງ ກາ ເກົາ ອາອີ່, ເຍືາ ເປາະ ເກຼີ່ ເກົາ. ບັອງ ກາ ເກົາ ແອີດ ຕຶ່ງ ກໍ່ອ໌, ເຍືາ ເປາະ ຊາອົຮ ເກົາ.' ");
INSERT INTO ncq_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ເຈີ່ ໄລ່ ກາ ຕານັ່ອງ ອໍ ກັອຍ ຕາແບີບ ປາຍ: 'ອຶນເຈົາ ເອີຍ! ບັອງ ກາ ແລ່ະ ຮິ ເຮີມ ອຶນເຈົາ ມາເຍືາຍຮ ກະ ຮິ ແຈມ ໂອນ ອຶນເຈົາ? ແຕີລາ ອຶນເຈົາ ອາເຣືາງ ແດີອ໌ ກາ ຮິ ໂອນ ອຶນເຈົາ ງ່ອຍ໌? ");
INSERT INTO ncq_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ບັອງ ກາ ແລ່ະ ຮິ ເຮີມ ອຶນເຈົາ ແກີດ ກວາຍ ຕາມອຍ ກາ ຮິ ຕາ ເບີນ ຊາກັ່ລ, ກະ ຮິ ຣາບັນ ຕະ ແບອ໌ ອໍ ໂອນ ອຶນເຈົາ ມູ່ດ ຕຶ່ງ ດຸງ ຮິ? ແຕີລາ ອຶນເຈົາ ແອິ ຕຳປັອກ ກະ ຮິ ໂອນ ອຶນເຈົາ ເບີນ ຕຳປັອກ? ");
INSERT INTO ncq_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ກະ ບັອງ ກາ ແລ່ະ ຮິ ເຮີມ ອຶນເຈົາ ອາອີ່ ແຕີລາ ແອີດ ຕຶ່ງ ກໍ່ອ໌, ມາ ຮິ ເປາະ ຊາອົຮ ອຶນເຈົາ?' ");
INSERT INTO ncq_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ເຈີ່ ເຕືາວ ປັຣເຍືາ ກັອຍ ຕາແອີຍ ລັ່ຮ ປາຍ: 'ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ບັອງ ກາ ເຍືາ ຕະ ມັຮ ຣານະ ກັອຍ ໂຈະ ແຊມອາຍ ເກົາ ກາ ຕາ ເບີນ ເນົ່າ ອີ ຈ່ອຍ, ໄນ່ ລາ ມູເຈິງ ເຍືາ ຕະ ໂຈະ ເກົາ ເຕ່!' ");
INSERT INTO ncq_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","\"ແວັດ ກັອຍ, ເຕືາວ ປັຣເຍືາ ກັອຍ ອາຕີ ໂອນ ໄລ່ ກາ ແອີດ ຢັ່ຮ ອາເວ່ຣ ອັນ ແອັນ ປາຍ: 'ເຍືາ ແອີດ ເຢີ່ງ ແຕ ເກົາ, ຍ່ອນ ເຢືາງ ເຈົາຣາຊີ ດໍອ໌ ເຍືາ ລາ ກວາຍ ໂລ່ຍຮ. ອັນ ໂອນ ເຍືາ ແອີດ ຕຶ່ງ ອຶນຕຸ ອູ່ຍຮ ເບຼີ ຊົດ ແດີຍ, ອຶນຕຸ ກາ ເຢືາງ ເຈົາຣາຊີ ກຽມ ດໍອ໌ ໂອນ ເຢືາງ ຊາຕານ ກະ ອຶນແຍ່ະ ມັຮ ເຢືາງ ກາ ຊົດ ປໍ ເຢືາງ ຊາຕານ. ");
INSERT INTO ncq_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ບັອງ ກາ ເກົາ ຊັອງ ມາເຍືາຍຮ, ເຍືາ ຕາ ເບີນ ແຈມ ໂອນ ເກົາ ຈາ. ບັອງ ກາ ເກົາ ອາເຣືາງ ແດີອ໌, ເຍືາ ຕາ ເບີນ ໂອນ ເກົາ ງ່ອຍ໌. ");
INSERT INTO ncq_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ບັອງ ກາ ເກົາ ແກີດ ກວາຍ ຕາມອຍ ກາ ເຍືາ ຕາ ເບີນ ຊາກັ່ລ, ເຍືາ ຕາ ເບີນ ຣາບັນ ຕະ ແບອ໌ ອໍ ໂອນ ເກົາ ມູ່ດ ຕຶ່ງ ດຸງ ເຍືາ. ບັອງ ກາ ເກົາ ແອິ ຕຳປັອກ, ເຍືາ ຕາ ເບີນ ໂອນ ເກົາ ເບີນ ຕຳປັອກ. ບັອງ ກາ ເກົາ ອາອີ່ ກະ ແອີດ ຕຶ່ງ ກໍ່ອ໌, ເຍືາ ຕາ ເບີນ ເປາະ ເກຼີ່ ກະ ຊາອົຮ ເກົາ.' ");
INSERT INTO ncq_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ເຈີ່ ໄລ່ ກວາຍ ກັອຍ ຕາແບີບ ເຕືາວ ປັຣເຍືາ ປາຍ: 'ອຶນເຈົາ ເອີຍ! ບັອງ ກາ ແລ່ະ ຮິ ເຮີມ ອຶນເຈົາ ຊັອງ ມາເຍືາຍຮ, ແຕີລາ ອາເຣືາງ ແດີອ໌, ແຕີລາ ແກີດ ກວາຍ ຕາມອຍ ຮິ ຕາ ເບີນ ຊາກັ່ລ, ແຕີລາ ອຶນເຈົາ ແອິ ຕຳປັອກ, ແຕີລາ ອຶນເຈົາ ອາອີ່ ກະ ແອີດ ຕຶ່ງ ກໍ່ອ໌, ມາ ຮິ ຕາ ເບີນ ຈ່ອຍ ອຶນເຈົາ?' ");
INSERT INTO ncq_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ເຈີ່ ເຕືາວ ປັຣເຍືາ ກັອຍ ຕາແອີຍ ລັ່ຮ ໄລ່ ປາຍ: ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ບັອງ ກາ ເຍືາ ຕາ ເບີນ ຈ່ອຍ ໂອນ ມັຮ ກວາຍ ກາ ຕາ ເບີນ ເນົ່າ ອີ ຈ່ອຍ, ມູເຈິງ ເຍືາ ຕາ ເບີນ ຈ່ອຍ ເກົາ ເຕ່.' ");
INSERT INTO ncq_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ນ່ະກັອຍ ມັຮ ໄລ່ ກາ ຕາ ເບີນ ຈ່ອຍ ກັອຍ, ໄລ່ ອຶງເຄາະ ມູ່ດ ຕຶ່ງ ອຶນຕຸ ຕຸ່ຮ ກັ່ດ ເລືອຍໆ. ມາ ໄລ່ ກາ ກວາຍ ຕານັ່ອງ ອໍ, ໄລ່ ເບີນ ມູ່ດ ຕຶ່ງ ອຶນຕຸ ເບີນ ອາມົ່ງ ຊົດ ແດີຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ແວັດ ເຢຊູ ອາຕີ ອຶນແຍ່ະ ປັຣນາຍ ກັອຍ, ອັນ ອາຕີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","\"ເຍືາ ດັງ ເຈີ່, ອຶນນັ່ອງ ບາຣ ຕາໄງ ແອັນ ໄຮ ອີ ຈາ ຣໍ່ອ໌ ຊາແຍີ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ອາກຼັຮ ຈຸ່ມ ໄຮ. ຕາໄງ ກັອຍ ລາ ຕາໄງ ເນົ່າ ມ່ອບ ເກົາ, ກອນ ເຢືາງ ແກີດ ກວາຍ, ປໍ ອາຕີ ກວາຍ ກາ ແຕັຮ ເກົາ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ.\" ");
INSERT INTO ncq_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ບັອງ ກັອຍ ເບີນ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ກະ ມັຮ ກວາຍ ເທົາແກ ຈຸ່ມເຈືອ, ໄລ່ ແອີດ ໂຣ່ມ ຊັຣຮົງ ຕຶ່ງ ດຸງ ອັນ ກາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ. ຣາມຶ່ຮ ກວາຍ ກັອຍ ລາ ກາຢະພາ. ");
INSERT INTO ncq_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ໄລ່ ຊັຣຮົງ ຈໍ່ອ໌ ຣາລິ່ຮ ອີ ໂກບ ກະ ກາຈີດ ເຢຊູ, ມາ ໄລ່ ຕາ ຢໍອ໌ ອີ ໂອນ ເນົ່າ ດັງ. ");
INSERT INTO ncq_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ໄລ່ ປາຍ: \"ໄຮ ຕາ ເຕ່ອ໌ ຕະ ນ່ະກັອຍ ຕຶ່ງ ຕາໄງ ຈາ ຣໍ່ອ໌, ຍ່ອນ ອຶງກັອຮ ກວາຍ ກຼຶ່ງ ກັອຍ ໄລ່ ກັຣຈີດ ລັ່ຮ ກະ ໄຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ບັອງ ກາ ເຢຊູ ແອີດ ຕຶ່ງ ວີ່ລ ເບັດທານີ, ອັນ ແອີດ ຕຶ່ງ ດຸງ ຊີໂມນ, ລາ ກວາຍ ກາ ບັອງ ອາໄຣ່ ເບີນ ອາອີ່ ຕູ່ດ. ");
INSERT INTO ncq_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ເບີນ ມານະ ມັນແຊມ ແຕີ່ອ໌ ປໍ ເຢຊູ. ອັນ ເດີງ ມວຍ ກອງ ແດີອ໌ ປາຮວມ. ກອງ ກັອຍ ເນົ່າ ຕະ ແຕ ຕາເມົາ ເບີນ ຣາມຶ່ຮ 'ອາລາບາດ.' ແດີອ໌ ປາຮວມ ຕຶ່ງ ກອງ ກັອຍ ເປ່ງ ລາລື່. ບັອງ ກາ ເຢຊູ ແອີດ ຈາ, ມັນແຊມ ກັອຍ ທໍອ໌ ແດີອ໌ ປາຮວມ ກັອຍ ຕຶ່ງ ແປຼີ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ພໍກາ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ເຮີມ ມັນແຊມ ກັອຍ ຕະ ນ່ະກັອຍ, ໄລ່ ຊັອງ ອຶງຄື່ນ ລາລື່, ກະ ໄລ່ ປາຍ: \"ນານ່ະ ມັນແຊມ ໄນ່ ຕະ ຣານະ ກັອຍ, ໂລ່ ເມືາດ ມູ່ນ? ");
INSERT INTO ncq_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ຄັນ ຈິ ແດີອ໌ ປາຮວມ ໄນ່, ເບີນ ຊາອຶ່ຍ ປຣະ. ເຕ່ອ໌ ອີດ ປຣະ ກັອຍ ຈ່ອຍ ໂອນ ມັຮ ກວາຍ ກາດີດ!\" ");
INSERT INTO ncq_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ມາ ເຢຊູ ຊັອງ ໄລ່ ປາຍ ນ່ະກັອຍ, ກະ ອັນ ອາຕີ ໄລ່ ປາຍ: \"ນານ່ະ ເຍືາ ຕະ ໂອນ ມັນແຊມ ໄນ່ ຕຸ່ຮ? ມັນແຊມ ໄນ່ ຕະ ຣານະ ອໍ ໂອນ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ມັຮ ກວາຍ ກາດີດ ແອີດ ເລືອຍໆ ກະ ເຍືາ. ມາ ຈະ ເກົາ ຕາ ເບີນ ແອີດ ຊົດ ແດີຍ ກະ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ມັນແຊມ ໄນ່ ທໍອ໌ ແດີອ໌ ປາຮວມ ຕຶ່ງ ຈະ ເກົາ, ກຽມ ດໍອ໌ ໂອນ ເນົ່າ ແຕິບ ຈະ ເກົາ ຕຶ່ງ ປີ່ງ. ");
INSERT INTO ncq_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ຕຶ່ງ ກູ່ ອຶນຕຸ ຈວບ ກູແຕອ໌ ໄນ່, ແຕີ່ອ໌ ເນົ່າ ອາຕີ ປັຣນາຍ ອໍ ແຕ ເຢືາງ ເຈົາຣາຊີ, ເນົ່າ ອາຕີ ເຕ່ ກາ ຣານະ ມັນແຊມ ໄນ່ ຕະ, ດໍອ໌ ໂອນ ກວາຍ ຊາແຍີ ລັ່ຮ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ແວັດ ກັອຍ ຢູດາ ອິດຊະກາຣີອົດ, ອັນ ກາ ແຕ ມູ່ ມວຍ ຈິ່ດ ລາ ບາຣ ນະ, ອັນ ແຕີ່ອ໌ ປໍ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ກະ ອັນ ອາຕີ ໄລ່ ປາຍ: \"ຄັນ ເກົາ ມາ ມ່ອບ ຈະ ເຢຊູ ແຕີ່ອ໌ ປໍ ອາຕີ ເຍືາ, ອຶນເຕົ່າ ເຍືາ ອີ ໂອນ ເກົາ?\" ນ່ະກັອຍ ໄລ່ ປຣ່ອມ ໂອນ ໄປ ຈິ່ດ ກຼອງ ປຣະ. ");
INSERT INTO ncq_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ແວັດ ກັອຍ, ຢູດາ ຈໍ່ອ໌ ຕາໄງ ແລ່ະ ກາ ອໍ ອີ ມ່ອບ ເຢຊູ ໂອນ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ຕຶ່ງ ມັຮ ຕາໄງ ຈຸ່ມ ອິດຊະຣາເອລ ຈາ ຣໍ່ອ໌ ຊາແຍີ ຕາໄງ ອາກຼັຮ, ອຶນແຍ່ະ ຕາປູ່ລ ຕາໄງ ໄລ່ ຈາ ໂດຍ ບຸຮ ແອິ ບວຮ ຊື່ອ໌. ຕຶ່ງ ຕາໄງ ມວຍ ກັອຍ, ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ແຕີ່ອ໌ ປໍ ອັນ ກະ ຕາແບີບ ປາຍ: \"ອຶນຕຸ ອາແລ່ະ ອາຈານ ຢໍອ໌ ອີ ໂອນ ຮິ ເປາະ ກຽມ ດໍອ໌ ໂອນ ອາຈານ ຈາ ເປ່ລ ບູຍ ຕາໄງ ອາກຼັຮ?\" ");
INSERT INTO ncq_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ເຍືາ ມູ່ດ ຕຶ່ງ ເມືອງ; ເຈີ່ ເຍືາ ເປາະ ປໍ ດຸງ ກວາຍ ກາ ເກົາ ຊາກັ່ລ ກັອຍ. ເຍືາ ປາຍ ໂຈະ ອັນ ນ່ະໄນ່: 'ອາຈານ ປາຍ: ແຈ່ະ ອີ ແຕີ່ອ໌ ປາເນ່ນ ເກົາ ກູຈີດ ເຈີ່. ເກົາ ກະ ມູ່ ກາ ຣຍານ ແຕ ເກົາ ຢໍອ໌ ອີ ຈາ ເປ່ລ ບູຍ ຕາໄງ ອາກຼັຮ ຕຶ່ງ ດຸງ ໄມ່.'\" ");
INSERT INTO ncq_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ນ່ະກັອຍ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ເປາະ ຕະ ນ່ະ ເຢຊູ ປາຕັບ ໄລ່. ກະ ໄລ່ ກຽມ ຊັຣນາ ຈາ ມວຍ ເປ່ລ ຊາແຍີ ຕາໄງ ອາກຼັຮ ອຶງກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ແຕີ່ອ໌ ຍາຍຶ່ມ ເຢຊູ ຕາກູ ຈາ ມັນຕຸ ກະ ມວຍ ຈິ່ດ ລາ ບາຣ ນະ ມູ່ ກາ ຣຍານ ແຕ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ບັອງ ກາ ໄລ່ ຈາ, ເຢຊູ ອາຕີ ໄລ່ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ເບີນ ມານະ ແຕ ມູ່ ເຍືາ ອີ ມ່ອບ ໂອນ ເນົ່າ ກາຈີດ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ອຶນແຍ່ະ ມັຮ ມູ່ ກາ ຣຍານ ແຕ ອັນ ຊັອງ ຕຸ່ຮ ລາລື່, ກະ ມູ ເຈີ ມານະ ໄລ່ ຕາແບີບ ເຢຊູ ປາຍ: \"ເກົາ ມາ ຕາ ເບີນ, ອຶນເຈົາ?\" ");
INSERT INTO ncq_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ອັນ ກາ ຕຸ ຈາ ໂດຍ ບຸຮ ມວຍ ຕາງານ ກະ ເກົາ, ອັນ ກັອຍ ແຕິ່ ມ່ອບ ເກົາ ໂອນ ເນົ່າ ກາຈີດ. ");
INSERT INTO ncq_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ກອນ ເຢືາງ ແກີດ ກວາຍ ອຶງເຄາະ ກູຈີດ ມັຮ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ເຈີ່ ແຕ ອັນ. ມາ ບາບ ລາລື່ ແຕີ່ອ໌ ປໍ ອັນ ກາ ມ່ອບ ກອນ ເຢືາງ ແກີດ ກວາຍ! ປຍາຍ໌ ລາ ອຶມເປ່ອ໌ ອັນ ອຶນໂຈຍ ຣັ່ຮ ອັນ!\" ");
INSERT INTO ncq_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ຢູດາ, ອັນ ກາ ອີ ມ່ອບ ເຢຊູ ຕາແບີບ ປາຍ: \"ເກົາ ມາ ຕາ ເບີນ, ອາຈານ?\" ເຢຊູ ອາຕີ ອັນ ປາຍ: \"ປຍາຍ໌ ນ່ະ ໄມ່ ປາຍ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ບັອງ ກາ ໄລ່ ຈາ, ເຢຊູ ອີດ ມານຳ ໂດຍ ບຸຮ. ອັນ ຊາແອີນ ເຢືາງ ເຈົາຣາຊີ, ເຈີ່ ອັນ ປີຮ ໂດຍ ບຸຮ ກັອຍ, ອາແວີຍ ໂອນ ມັຮ ມູ່ ກາ ຣຍານ ແຕ ອັນ. ອັນ ປາຍ: \"ເຍືາ ຣັ່ບ ຈາ; ໄນ່ ລາ ຈະ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ແວັດ ກັອຍ ອັນ ອີດ ຈອກ ແອັນ. ອັນ ຊາແອີນ ເຢືາງ ເຈົາຣາຊີ; ເຈີ່ ອັນ ອາແວີຍ ໂອນ ມູ່ ກາ ຣຍານ ແຕ ອັນ. ອັນ ປາຍ: \"ໂອນ ອຶນແຍ່ະ ນະ ເຍືາ ງ່ອຍ໌. ");
INSERT INTO ncq_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ໄນ່ ລາ ອາຮາມ ເກົາ ກາ ລັ່ອຮ ຕະ ໂອນ ຣາປຍາຍ໌ ກະ ເຢືາງ ເຈົາຣາຊີ ປັຣຄັນ ປັຣນາຍ ຕາໄມ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ. ຍ່ອນ ແຕ ອາຮາມ ເກົາ ເຢືາງ ເຈົາຣາຊີ ຕັຮ ໂລ່ຍຮ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ເກົາ ອາຕີ ເຍືາ ປາຍ: ເກົາ ຕາ ເບີນ ງ່ອຍ໌ ນັ່ອງ ແດີອ໌ ແຕ ປາໄລ ອາງຸ່ນ ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ເກົາ ງ່ອຍ໌ ແດີອ໌ ອາງຸ່ນ ຕາໄມ ແອັນ ມັນຕຸ ກະ ເຍືາ ຕຶ່ງ ອຶນຕຸ ອຶມປໍ່ ເກົາ ຊົດ.\" ");
INSERT INTO ncq_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ແວັດ ໄລ່ ລ່ຳ ປັຣນາຍ ຍ່ອງ, ເຈີ່ ໄລ່ ລັ່ອຮ ແຕ ກັອຍ ຊັອຮ ຕຶ່ງ ກົຮ ອາໂປ່ນ. ");
INSERT INTO ncq_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ບັອງ ກາ ກັອຍ ເຢຊູ ອາຕີ ໄລ່ ປາຍ: \"ຊາເດົາ ໄນ່ ອຶນແຍ່ະ ມັຮ ເຍືາ ຕັຮ ອຶນແຍ່ະ ເກົາ. ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ເຈີ່ ປາຍ: 'ເກົາ ໂອນ ເນົ່າ ກາຈີດ ກວາຍ ກາ ກຍາອ໌ ແກະ; ເຈີ່ ອຶນແຍ່ະ ແກະ ກັອຍ ອຶມປຣາຍຮ ອຶມປຣັງ ຕາລຸ່ຮ ປໍ ໄນ່ ຕາລຸ່ຮ ປໍ ກັອຍ.' ");
INSERT INTO ncq_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ມາ ແຕີ່ອ໌ ເກົາ ອາມົ່ງ ລັ່ຮ, ເກົາ ເປາະ ອຶນໂຍ່ງ ເຍືາ ປໍ ແຄງ ຄາລີເລ.\" ");
INSERT INTO ncq_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ເປໂຕ ອາຕີ ເຢຊູ ປາຍ: \"ຄັນ ອຶນແຍ່ະ ມັຮ ກວາຍ ການໍ່ອ໌ ມາ ຕັຮ ອາຈານ, ເກົາ ຕາ ເບີນ ຕັຮ!\" ");
INSERT INTO ncq_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ເຢຊູ ອາຕີ ລັ່ຮ ອັນ ປາຍ: \"ໄກຣ ລາລື່ ເກົາ ອາຕີ ໄມ່, ຕຶ່ງ ຊາເດົາ ໄນ່ ແຕິ່ ອຶນໂຍ່ງ ອຶນຕຣວຍ ຕາກາຣ, ໄມ່ ກາແລີຍຮ ເກົາ ເບີນ ໄປ ເຮີບ.\" ");
INSERT INTO ncq_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ມາ ເປໂຕ ຕາແອີຍ ປາຍ: \"ຄັນ ເນົ່າ ກາຈີດ ເກົາ ກະ ອາຈານ, ລາ ເຈີ່. ເກົາ ຕາ ເບີນ ກາແລີຍຮ ແລີ່!\" ກະ ອຶນແຍ່ະ ມັຮ ມູ່ ກັອຍ ປາຍ ມູເຈິງ ປັຣນາຍ ເປໂຕ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ເຈີ່ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ແຕີ່ອ໌ ປໍ ຊວນ ເຄັດເຊມາເນ. ເຢຊູ ອາຕີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ເຍືາ ແອີດ ຕາກູ ອຶນໄນ່ ນໍ. ເກົາ ອີ ເປາະ ເກົາແຊອ໌ ປໍ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ເຈີ່ ເຢຊູ ເດີງ ເປໂຕ ກະ ບາຣ ນະ ແຊມອາຍ ກອນ ເຊເບດາຍ ເປາະ ກະ ອັນ. ຕາແບິ ກັອຍ ເຢຊູ ຊັອງ ເກຣ່າະ ກະ ຕຸ່ຮ ລາລື່ ຕຶ່ງ ຣາງຶ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ອັນ ອາຕີ ໄລ່ ໄປ ນະ ກັອຍ ປາຍ: \"ຣາງຶ່ຮ ເກົາ ຊັອງ ຕຸ່ຮ ລາລື່, ຕາ ເຣືາບ ອາມົ່ງ ນັ່ອງ. ເຍືາ ແອີດ ອຶນໄນ່ ເວືາຍ. ເຍືາ ຕາງວຍ ເກຣາະ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ເຈີ່ ເຢຊູ ເປາະ ບີ່ອ໌ ແອັນ. ອັນ ປາດິຮ ຕຶ່ງ ກູແຕອ໌ ມູ່ ຕາແຕິບ, ກະ ອັນ ເກົາແຊອ໌ ປາຍ: \"ເອີ ອຶມປໍ່ ເກົາ ເອີຍ! ຄັນ ໄມ່ ຊັອງ ປຍາຍ໌, ເກົາ ແຊອ໌ ໄມ່ ອາຢິ່ ຈອກ ຕຸ່ຮ ກັ່ດ ໄນ່ ໂອນ ແວັດ ແຕ ເກົາ. ມາ ເກົາ ຕາ ແອອ໌ ຕາປູ່ນ ຣາງຶ່ຮ ເກົາ ເບີມ, ມາ ອີ ຕາປູ່ນ ແອີງ ຣາງຶ່ຮ ໄມ່ ຊັອງ.\" ");
INSERT INTO ncq_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ເຈີ່ ເຢຊູ ເຈົາ ລັ່ຮ ປໍ ໄປ ນະ ມູ່ ກາ ຣຍານ ແຕ ອັນ. ອັນ ເຮີມ ໄລ່ ກັອຍ ບິ. ອັນ ຕາແບີບ ເປໂຕ ປາຍ: \"ນານ່ະ ເຍືາ ຕາ ເຣືາບ ເກຣາະ ມາໂຮຍ ກະ ເກົາ? ");
INSERT INTO ncq_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ອຶງເຄາະ ເຍືາ ຕາແມີ ກະ ເກົາແຊອ໌ ອຶນໂຈຍ ໂອນ ເນົ່າ ປັຣຕຶ່ ເຍືາ ຕະ ໂລ່ຍຮ. ຣາງຶ່ຮ ເຍືາ ລາ ບັນ ເຣ່ງ, ມາ ຈະຈັ່ນ ເຍືາ ລາ ອຽວ໌.\" ");
INSERT INTO ncq_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ເຢຊູ ເປາະ ເຮີບ ກາ ບາຣ ແອັນ ອີ ເກົາແຊອ໌ ລັ່ຮ ປໍ ກັອຍ. ອັນ ເກົາແຊອ໌ ປາຍ: \"ອຶມປໍ່ ເກົາ ເອີຍ! ຄັນ ໄມ່ ຕາ ເບີນ ອາຢິ່ ຈອກ ຕຸ່ຮ ກັ່ດ ໄນ່ ໂອນ ແວັດ ແຕ ເກົາ, ມາ ໄມ່ ໂອນ ເກົາ ງ່ອຍ໌, ເກົາ ປຣ່ອມ ຕາປູ່ນ ແອີງ ຣາງຶ່ຮ ໄມ່ ຊັອງ.\" ");
INSERT INTO ncq_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ເຈີ່ ເຢຊູ ເຈົາ ລັ່ຮ ປໍ ໄປ ນະ ມູ່ ກາ ຣຍານ ແຕ ອັນ. ອັນ ເຮີມ ໄລ່ ບິ ລັ່ຮ. ໄລ່ ຕາ ເຣືາບ ກູເລືານ; ລາກຶ່ບ ເລືອຍໆ ອຶງກັຣ ມັ່ດ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ເຢຊູ ລັ່ອຮ ແຕ ໄລ່ ຊາ, ກະ ອັນ ເປາະ ເກົາແຊອ໌ ເຮີບ ກາ ໄປ ແອັນ. ອັນ ເກົາແຊອ໌ ມູເຈິງ ປັຣນາຍ ແຕ ອຶນໂຍ່ງ ຊາ. ");
INSERT INTO ncq_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ເຈີ່ ອັນ ເຈົາ ລັ່ຮ ປໍ ມູ່ ກາ ຣຍານ ແຕ ອັນ ກະ ປາຍ: \"ນານ່ະ ອຶນນັ່ອງ ເຍືາ ບິ ກະ ຣາລູ່ ລັ່ຮ? ປາເນ່ນ ເກົາ ແຈ່ະ ອີ ແຕີ່ອ໌ ເຈີ່. ກອນ ເຢືາງ ແກີດ ກວາຍ, ເນົ່າ ມ່ອບ ອັນ ແຕີ່ອ໌ ປໍ ອາຕີ ກວາຍ ໂລ່ຍຮ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ຢວຣ ຕາຢຶ່ງ! ໄຮ ເປາະ! ເຍືາ ເນ່, ອັນ ກາ ມ່ອບ ເກົາ ແຕີ່ອ໌ ເຈີ່!\" ");
INSERT INTO ncq_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ບັອງ ກາ ເຢຊູ ອຶນນັ່ອງ ອາຕີ, ເບີນ ຢູດາ, ມານະ ແຕ ມູ່ ມວຍ ຈິ່ດ ລາ ບາຣ ນະ ກັອຍ, ແຕີ່ອ໌ ມັນຕຸ ກະ ກວາຍ ກຼຶ່ງ. ມັຮ ກວາຍ ກຼຶ່ງ ກັອຍ, ໄລ່ ແຕີ່ອ໌ ແຕ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ກະ ກວາຍ ເທົາແກ ຈຸ່ມເຈືອ. ໄລ່ ເດີງ ດາວ ກະ ກ່ອນ. ");
INSERT INTO ncq_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ອັນ ກາ ມ່ອບ ເຢຊູ, ອັນ ອາຕີ ດໍອ໌ ໂອນ ມັຮ ກວາຍ ກຼຶ່ງ ກັອຍ ດັງ. ອັນ ອາຕີ ໄລ່ ກັອຍ ປາຍ: \"ຄັນ ອາແລ່ະ ເຍືາ ເຮີມ ເກົາ ໂຮນ, ລາ ຈະ ອັນ ກາ ເຍືາ ອີ ເບີນ. ເຈີ່ ໂກບ ອັນ ກັອຍ ແຕິ່!\" ");
INSERT INTO ncq_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ນ່ະກັອຍ ຢູດາ ແຕີ່ອ໌ ປໍ ເຢຊູ, ກະ ອັນ ປາຍ: \"ບັນຊວານ ເຕ່ ອາຈານ.\" ເຈີ່ ອັນ ໂຮນ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ເຢຊູ ອາຕີ ຢູດາ ປາຍ: \"ເຢົ່າ ເອີຍ! ຣານະ ອຶນເຕົ່າ ໄມ່ ຢໍອ໌ ອີ ຕະ, ໄມ່ ຕະ ໄວ່!\" ເຈີ່ ເນົ່າ ແຕີ່ອ໌ ໂກບ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ເບີນ ມານະ ແຕ ມູ່ ກາ ຕາປູ່ນ ເຢຊູ ທອດ ດາວ ແຕ ຊອຣ. ອັນ ກັຣໄປຮ ມານະ ຊູລ ອັນ ກາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ, ປຍາຍ໌ ຕາລິ່ດ ມວຍ ກັ່ຮ ກູຕູຣ. ");
INSERT INTO ncq_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ເຢຊູ ອາຕີ ອັນ ກັອຍ ປາຍ: \"ໄມ່ ໂຈະ ລັ່ຮ ດາວ ໄມ່ ຕຶ່ງ ຊອຣ. ກວາຍ ອາແລ່ະ ຢຸມ ດາວ, ກວາຍ ກັອຍ ກູຈີດ ລັ່ຮ ຣານາ ດາວ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ໄມ່ ດັງ ມາ ຕາ ເບີນ, ຄັນ ເກົາ ຢໍອ໌, ເຕ່ອ໌ ເກົາ ແຊອ໌ ແຕ ອຶມປໍ່ ເກົາ ໂອນ ອັນ ແປຣີ ເທວາດາ ອັນ ແກຼີຍ ແຕ ມວຍ ຈິ່ດ ລາ ບາຣ ກອງທັບ ແຕີ່ອ໌ ຈ່ອຍ ເກົາ? ");
INSERT INTO ncq_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ມາ ຄັນ ເກົາ ຕະ ນ່ະກັອຍ, ຕາ ເບີນ ຣາປຍາຍ໌ ມັຮ ເຢືາງ ເຈົາຣາຊີ ປາຍ ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ອັນ ແຕ ອຶມແບິ. ປຶ່ງ ກັອຍ ປາຍ ມັຮ ຣານະ ໄນ່ ອຶງເຄາະ ແກີດ.\" ");
INSERT INTO ncq_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ເຈີ່ ເຢຊູ ຕາແບີບ ມັຮ ກວາຍ ກຼຶ່ງ ກັອຍ ແອັນ: \"ນານ່ະ ເຍືາ ແຕີ່ອ໌ ປໍ ໄນ່ ມາ ເດີງ ດາວ ກະ ກ່ອນ ອີ ໂກບ ເກົາ? ເຍືາ ຄຶ່ດ ປາຍ ເກົາ ລາ ກວາຍ ຊາແວງ ບໍ? ກູ່ ຣາໄງ ເກົາ ແອີດ ອາຕີ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ, ມາ ເຍືາ ຕາ ເບີນ ໂກບ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ມາ ຣານະ ໄນ່ ຕະ ໂອນ ແກີດ ຣາປຍາຍ໌ ມັຮ ປັຣນາຍ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ຄຽນ ດໍອ໌ ແຕ ອຶມແບິ ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ.\" ເຈີ່ ມັຮ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ, ໄລ່ ຕາລຸ່ຮ ຕັຮ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ແວັດ ກັອຍ ໄລ່ ກາ ໂກບ ເຢຊູ ເດີງ ອັນ ເປາະ ປໍ ດຸງ ກາຢະພາ, ອັນ ກາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ. ອຶນແຍ່ະ ມັຮ ກວາຍ ເທົາແກ ຈຸ່ມເຈືອ ກະ ກວາຍ ອາຕີ ຄານອດ ເປາະ ໂຣ່ມ ຊັຣຮົງ ປໍ ອຶນຕຸ ກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ເປໂຕ ຣາປວາຍ ເຢີ່ງໆ ອຶນຕູ່ນ ກຣັອງ ເຢຊູ. ອັນ ມູ່ດ ຕຶ່ງ ຊັງອາຣ ດຸງ ອັນ ກາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ. ອັນ ຕາກູ ມັນຕຸ ກະ ຕາຮານ ກວາຍ ຊົດ ກັອຍ, ຢໍອ໌ ອີ ດັງ ອຶນເຕົ່າ ໄລ່ ຕະ ກະ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ກະ ຈຸ່ມ ໄລ່ ກາ ຊັຣຮົງ ຕັດຊີ່ນ, ໄລ່ ຈໍ່ອ໌ ກວາຍ ກາ ເຕ່ອ໌ ຕູນ ເຢຊູ. ໄລ່ ຢໍອ໌ ອີ ກາຈີດ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ເບີນ ຊາອຶ່ຍ ກວາຍ ແຕີ່ອ໌ ຕູນ ເຢຊູ, ມາ ຕາ ເບີນ ຣາປຍາຍ໌. ກວາຍ ຊົດ ກັອຍ ຕາ ເບີນ ຣາມົຮ ມວຍ ຣາມຶ່ຮ ຕາ ອໍ ອຶນເຕົ່າ ແຕ ເຢຊູ ຕະ. ອຶນຕູ່ນ ເລີ່ຍ ເບີນ ບາຣ ນະ ແອັນ ແຕີ່ອ໌ ຕູນ ອັນ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ໄລ່ ປາຍ: \"ກວາຍ ໄນ່ ປາຍ: 'ເຕ່ອ໌ ເກົາ ຕາລຸຮ ດຸງ ຊາງ ປື່ດ ເຢືາງ ເຈົາຣາຊີ. ເຈີ່ ເກົາ ຕະ ລັ່ຮ ໄປ ຕາໄງ ລາ ເຈີ່ ແຕິ່.'\" ");
INSERT INTO ncq_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ເຈີ່ ອັນ ກາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ, ອັນ ຢວຣ ຕາຢຶ່ງ ກະ ອັນ ຕາແບີບ ເຢຊູ ປາຍ: \"ມັຮ ກວາຍ ໄນ່ ປ່ອງ ໄມ່. ປຍາຍ໌ ໄມ່ ປາຍ ນ່ະກັອຍ, ມາ ຕາ ເບີນ? ກະ ອຶນເຕົ່າ ໄມ່ ຢໍອ໌ ອີ ຕາແອີຍ ລັ່ຮ ໂຈະ ໄລ່ ກັອຍ?\" ");
INSERT INTO ncq_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ມາ ເຢຊູ ແອີດ ອາວື່ລ ຊັອງ. ອັນ ຕາ ເບີນ ປາຍ ອຶນເຕົ່າ. ເຈີ່ ອັນ ກາ ຕາລາ ຣີ່ດ ກັອຍ ປາຍ ແອັນ: \"ຢັ່ຮ ເມືາງ ເຢືາງ ເຈົາຣາຊີ, ອັນ ກາ ອາມົ່ງ ເລືອຍໆ, ເກົາ ແປຣີ ໄມ່ ຄີນ ກະ ຮິ, ໄມ່ ລາ ມານະ ກຣີດ, ລາ ກອນ ເຢືາງ ເຈົາຣາຊີ, ມາ ຕາ ເບີນ?\" ");
INSERT INTO ncq_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ເຢຊູ ຕາແອີຍ ອັນ ປາຍ: \"ປຍາຍ໌ ມັຮ ໄມ່ ປາຍ. ມາ ເກົາ ອາຕີ ລັ່ຮ ເຍືາ ປາຍ: ເຈີ່ ປໍ ເມືາງ ເຍືາ ເຮີມ ກອນ ເຢືາງ ແກີດ ກວາຍ ຕາກູ ຢັ່ຮ ອາຕ່ຳ ເຢືາງ ເຈົາຣາຊີ ກາ ເບີນ ອຳນາດ ປື່ດ ລາລື່, ກະ ອັນ ແຕີ່ອ໌ ອຶນດີ ຣາມິ່ລ ແຕ ມັນລັ່ອງ.\" ");
INSERT INTO ncq_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ນ່ະກັອຍ ອັນ ກາ ຕາລາ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ ແຈອ໌ ຕຳປັອກ ອັນ ເບີມ ຕະ ໂອນ ເນົ່າ ດັງ ປາຍ ອັນ ຊັອງ ຕຸ່ຮ ລາລື່. ກະ ອັນ ປາຍ ໂຈະ ອຶນແຍ່ະ ມັຮ ກວາຍ ການໍ່ອ໌: \"ອັນ ໄນ່ ປາຍ ນ່ະກັອຍ, ລາ ນ່ະ ອັນ ພາມາດ ເຢືາງ ເຈົາຣາຊີ. ຈ່ຳ ໄຮ ອີ ຕາແບີບ ນັ່ອງ ກວາຍ ການໍ່ອ໌? ເຍືາ ຊັອງ ເຈີ່ ອັນ ປາຍ ປັຣນາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ນານ່ະ ເຍືາ ຄຶ່ດ ແຕ ຣາມຶ່ຮ ກັອຍ?\" ມາ ໄລ່ ກັອຍ ຕາແອີຍ ປາຍ: \"ປຍາຍ໌ ອັນ ອຶງເຄາະ ກູຈີດ!\" ");
INSERT INTO ncq_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ເຈີ່ ໄລ່ ກູຈົຮ ໂຈະ ມາມ ເຢຊູ, ກະ ຈົ່ກ ອັນ. ມາ ເບີນ ກວາຍ ການໍ່ອ໌ ຕັ່ຮ ອັນ, ");
INSERT INTO ncq_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ກະ ຕາແບີບ ປາຍ: \"ເອີ ກຣີດ ເອີຍ! ຄັນ ໄມ່ ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ເອົາ ໄມ່ ອາຕີ ຮິ, ເນົ່າ ກາ ຈົ່ກ ໄມ່?\" ");
INSERT INTO ncq_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ເປໂຕ ແອີດ ຕາກູ ຕຶ່ງ ຊັງອາຣ ດຸງ. ເບີນ ມານະ ມັນແຊມ ກາ ຕະ ຣານະ ໂອນ ອັນ ກາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ, ອັນ ແຕີ່ອ໌ ປໍ ເປໂຕ, ເຈີ່ ອັນ ປາຍ ໂຈະ ເປໂຕ: \"ໄມ່ ລາ ກວາຍ ກາ ແອີດ ກະ ເຢຊູ, ກວາຍ ແຕ ແຄງ ຄາລີເລ.\" ");
INSERT INTO ncq_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ມາ ເປໂຕ ກາແລີຍຮ ເຢຊູ ຢັ່ຮ ເມືາງ ອຶນແຍ່ະ ນະ ກວາຍ ກັອຍ, ປາຍ: \"ເກົາ ຕາ ເບີນ ຊາປຸ່ຮ ອຶນເຕົ່າ ໄມ່ ປາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ເຈີ່ ອັນ ເປາະ ປໍ ງັ່ຮ ຕົ່ງ ກຣ່ອງ. ເບີນ ມັນແຊມ ການໍ່ອ໌ ແອັນ ເຮີມ ອັນ, ກະ ປາຍ ໂຈະ ມັຮ ກວາຍ ກຼຶ່ງ ກັອຍ: \"ກວາຍ ໄນ່ ເມ່ນ ອັນ ແອີດ ກະ ເຢຊູ ກວາຍ ແຕ ວີ່ລ ນາຊາເຣັດ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ມາ ເປໂຕ ກາແລີຍຮ ຊາ ເຢຊູ, ກະ ອັນ ຄີນ: \"ເກົາ ຕາ ດັງ ອັນ ກັອຍ ລາ ເນົ່າ!\" ");
INSERT INTO ncq_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ມາໂຮຍ ແອັນ ເບີນ ມັຮ ກວາຍ ການໍ່ອ໌ ກາ ແອີດ ແຈ່ະ ກັອຍ ແຕີ່ອ໌ ປໍ ເປໂຕ, ກະ ປາຍ: \"ໄກຣ ລາລື່ ໄມ່ ລາ ແຕ ມູ່ ກັອຍ ເຕ່, ຍ່ອນ ຊຽງ ໄມ່ ຕະ ອຶນຕີ ລາ ມູເຈິງ ກະ ກວາຍ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ມາ ເປໂຕ ອັນ ຄີນ ກຼໍອ໌ ແປຼີ ກຼໍອ໌ ໂຊະ. ອັນ ຕາແອີຍ ກະ ຣາຈຽນ ເລືອຍໆ ປາຍ: \"ເກົາ ຕາ ເກີ່ຍ ເຮີມ ຕາ ເກີ່ຍ ດັງ ກວາຍ ກັອຍ!\" ບັອງ ກາ ກັອຍ ແຕິ່ ອຶນຕຣວຍ ຕາກາຣ. ");
INSERT INTO ncq_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ເຈີ່ ເປໂຕ ຊາແຍີ ລັ່ຮ ມັຮ ປັຣນາຍ ເຢຊູ ອາຕີ ອັນ ປາຍ: \"ແຕ ອຶນໂຍ່ງ ອຶນຕຣວຍ ຕາ ຢວາຮ ຕາກາຣ, ໄມ່ ກາແລີຍຮ ເກົາ ເບີນ ໄປ ເຮີບ.\" ເຈີ່ ເປໂຕ ລັ່ອຮ ແຕ ກັອຍ; ກະ ອັນ ເຍືາມ ເລີ່ຍ. ");
INSERT INTO ncq_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ພໍກາ ປັ່ງ ຕາຣື່ບ ປັຣແນີ ແອັນ, ຕາແບິ ຍາຍຶ່ມ, ອຶນແຍ່ະ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ກະ ອຶນແຍ່ະ ມັຮ ກວາຍ ເທົາແກ ຈຸ່ມເຈືອ, ໄລ່ ຊັຣຮົງ ຈໍ່ອ໌ ຣານາ ອີ ກາຈີດ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ໄລ່ ຊັດ ອັນ ກະ ເດີງ ມ່ອບ ປໍ ອາຕີ ປີລາດ, ລາ ກວາຍ ໂຣມ ກາ ຊົດ ຕຶ່ງ ກຣວາງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ພໍກາ ຢູດາ, ອັນ ກາ ມ່ອບ ເຢຊູ, ຊັອງ ກວາຍ ຊົດ ປາຍ ເຢຊູ ອຶງເຄາະ ກູຈີດ, ອັນ ຊັອງ ຕຸ່ຮ ລາລື່ ຍ່ອນ ອັນ ຕະ ຣານະ ກັອຍ. ເຈີ່ ອັນ ເດີງ ລັ່ຮ ໄປ ຈິ່ດ ກຼອງ ປຣະ ກັອຍ ກູລັຮ ລັ່ຮ ປໍ ອຶນແຍ່ະ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ກະ ມັຮ ກວາຍ ເທົາແກ ຈຸ່ມເຈືອ. ");
INSERT INTO ncq_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ອັນ ປາຍ: \"ເກົາ ຕະ ໂລ່ຍຮ ຍ່ອນ ເກົາ ມ່ອບ ມານະ ກາ ຕາ ເບີນ ເບີນ ໂລ່ຍຮ ອຶນເຕົ່າ.\" ມາ ໄລ່ ກັອຍ ຕາແອີຍ ຢູດາ ປາຍ: \"ຣານະ ກັອຍ ຕາ ເບີນ ອຶນເຕົ່າ ກະ ຮິ. ຕາມ ໄມ່!\" ");
INSERT INTO ncq_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ຢູດາ ແກຼງ ຕັຮ ປຣະ ກັອຍ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ. ເຈີ່ ອັນ ລັ່ອຮ ເປາະ ຢະ, ອັນ ຊັອຮ ຊັດ ອຶນໄຊ ເກຣືາວ ຕຶ່ງ ກັ່ລ ອາລ່ອງ ເຈີ່ ອັນ ຊັດ ຕຶ່ງ ຕາກອງ ອັນ ແອັນ, ເຈີ່ ອັນ ປັອງ ອາແຊງ ກູຈີດ ເລີ່ຍ. ");
INSERT INTO ncq_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ກັອຍ, ໄລ່ ໂຕຍ໌ ລັ່ຮ ປຣະ ກັອຍ, ກະ ໄລ່ ປາຍ: \"ປຣະ ໄນ່ ລາ ປຣະ ເກືາ ອາຮາມ ກວາຍ. ນ່ະກັອຍ ຕາປູ່ນ ຄານອດ ໄຮ ຕາ ເຕ່ອ໌ ດໍອ໌ ປຣະ ໄນ່ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ.\" ");
INSERT INTO ncq_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ເຈີ່ ໄລ່ ຊັຣຮົງ. ແວັດ ກັອຍ ໄລ່ ແຈີງ ມວຍ ອຶນຕຸ ກູແຕອ໌ ແຕ ປຣະ ກັອຍ. ກູແຕອ໌ ກັອຍ ໄລ່ ແຈີງ ແຕ ກວາຍ ເຈືາງ ຕະ ເກຣີ່ງ ແຕ ກູແຕອ໌ ກໍອ໌. ກວາຍ ຊົດ ກັອຍ ອີ ແຈີງ ອຶນຕຸ ກູແຕອ໌ ກັອຍ, ອຽນ ແຕິບ ກວາຍ ກາ ຕາ ເບີນ ຊາກັ່ລ ມາ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ນ່ະກັອຍ ເຕົ່າ ຕາໄງ ໄນ່ ເນົ່າ ອາມຶ່ຮ ກູແຕອ໌ ກັອຍ ລາ 'ຕາລິງ ອາຮາມ.' ");
INSERT INTO ncq_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","ນ່ະກັອຍ ແກີດ ຣາປຍາຍ໌ ມັຮ ປັຣນາຍ ເຢເຣມີຢາ, ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ປາຍ: \"ເນົ່າ ອີດ ໄປ ຈິ່ດ ກຼອງ ປຣະ ກະ ແຈີງ ມວຍ ອຶນຕຸ ກູແຕອ໌ ແຕ ກວາຍ ເຈືາງ ຕະ ເກຣີ່ງ ແຕ ກູແຕອ໌ ກໍອ໌, ນ່ະ ອຶນເຈົາ ເກົາ ແປຣີ ເກົາ ຕະ. ໄປ ຈິ່ດ ກຼອງ ປຣະ ກັອຍ ລາ ເກືາ ກວາຍ ອິດຊະຣາເອລ ນັ່ດ ດໍອ໌ ໂອນ ຣາງຶ່ຮ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ເຢຊູ ແອີດ ຕາຢຶ່ງ ຢັ່ຮ ເມືາງ ປີລາດ, ລາ ກວາຍ ໂຣມ ກາ ຊົດ ຕຶ່ງ ກຣວາງ ກັອຍ. ກວາຍ ຊົດ ກັອຍ ຕາແບີບ ເຢຊູ ປາຍ: \"ໄມ່ ລາ ເຕືາວ ປັຣເຍືາ ຈຸ່ມ ອິດຊະຣາເອລ ບໍ?\" ເຢຊູ ຕາແອີຍ ປາຍ: \"ເມ່ນ, ປຍາຍ໌ ໄມ່ ປາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ນ່ະກັອຍ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ກະ ກວາຍ ເທົາແກ ຈຸ່ມເຈືອ, ໄລ່ ປ່ອງ ເຢຊູ. ມາ ເຢຊູ ຕາ ເບີນ ຕາແອີຍ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ເຈີ່ ປີລາດ ຕາແບີບ ແອັນ: \"ໄມ່ ຊັອງ ມາ ຕາ ເບີນ ໄລ່ ປ່ອງ ໄມ່ ຊາອຶ່ຍ ຣາມຶ່ຮ?\" ");
INSERT INTO ncq_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ມາ ເຢຊູ ຕາ ເບີນ ຕາແອີຍ ອຶນເຕົ່າ ເລີ່ຍ. ນ່ະກັອຍ ກວາຍ ຊົດ ກັອຍ ຊັອງ ງຶ່ດ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ແຕີ່ອ໌ ຕາໄງ ກວາຍ ອິດຊະຣາເອລ ໂຣ່ມ ຈາ ຣໍ່ອ໌ ຊາແຍີ ຕາໄງ ອາກຼັຮ, ກວາຍ ຊົດ ກຣວາງ ກັອຍ ເບີນ ຣີ່ດ ອາໂຣຍຮ ມານະ ກວາຍ ໂຕ່ດ ແຕ ກໍ່ອ໌ ຕາມ ຣາງຶ່ຮ ກອນແຊມ ຣຽຮ ຢໍອ໌ ອີ ອາໂຣຍຮ. ");
INSERT INTO ncq_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ບັອງ ກາ ກັອຍ ເບີນ ມານະ ກວາຍ ເນົ່າ ໂກບ ດໍອ໌ ຕຶ່ງ ກໍ່ອ໌, ຣາມຶ່ຮ ບາຣາບາ. ກູ່ ນະ ກວາຍ ດັງ ອຶນແຍ່ະ ຣາມຶ່ຮ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ນ່ະກັອຍ, ບັອງ ກາ ກຼຶ່ງ ກວາຍ ໂຣ່ມ, ປີລາດ ຕາແບີບ ມັຮ ກວາຍ ກັອຍ ປາຍ: \"ກວາຍ ອາແລ່ະ ເຍືາ ຢໍອ໌ ອີ ໂອນ ເກົາ ອາໂຣຍຮ ໂອນ ເຍືາ, ບາຣາບາ, ແຕີລາ ເຢຊູ, ລາ ອັນ ກາ ເນົ່າ ດໍອ໌ ກຣີດ?\" ");
INSERT INTO ncq_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ປີລາດ ດັງ ເຈີ່ ຕຶ່ງ ຣາງຶ່ຮ ອັນ ອຶນແຍ່ະ ມັຮ ກວາຍ ຊົດ ກັອຍ ຊັຣແມງ ແຕ ເຢຊູ ຍ່ອນ ມັຮ ກອນແຊມ ໄລ່ ຢໍອ໌ ອີ ຕາປູ່ນ ເຢຊູ. ນ່ະກັອຍ ໄລ່ ເດີງ ເຢຊູ ແຕີ່ອ໌ ປໍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ບັອງ ກາ ປີລາດ ຕາກູ ຕຶ່ງ ອຶນຕຸ ອັນ ຕັດຊີ່ນ, ລາກວຍ ອັນ ພາອ໌ ປັຣນາຍ ແຕີ່ອ໌ ປໍ ອັນ ປາຍ: \"ໄມ່ ອຶນໂຈຍ ຕະ ອຶນເຕົ່າ ກະ ກວາຍ ກັອຍ, ຍ່ອນ ອັນ ຕາ ເບີນ ເບີນ ໂລ່ຍຮ ອຶນເຕົ່າ. ຕາບື່ ປາໄຮ ເກົາ ຣາເລົາ ອຶມເປົາ ແຕ ອັນ, ເຈີ່ ຕາໄງ ໄນ່ ເກົາ ຊັອງ ເກຣ່າະ ລາລື່.\" ");
INSERT INTO ncq_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ມາ ອຶນແຍ່ະ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ກະ ອຶນແຍ່ະ ກວາຍ ເທົາແກ ຈຸ່ມເຈືອ, ໄລ່ ແປຣີ ມັຮ ກວາຍ ກຼຶ່ງ ກັອຍ ແຊອ໌ ແຕ ກວາຍ ຊົດ ໂອນ ອາໂຣຍຮ ບາຣາບາ, ມາ ກາຈີດ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ອັນ ກາ ຊົດ ກັອຍ ຕາແບີບ ກວາຍ ກຼຶ່ງ ກັອຍ ປາຍ: \"ບາຣ ນະ ກວາຍ ໄນ່, ເຍືາ ຢໍອ໌ ອີ ໂອນ ເກົາ ອາໂຣຍຮ ອັນ ກາ ອາແລ່ະ?\" ໄລ່ ຕາແອີຍ: \"ບາຣາບາ!\" ");
INSERT INTO ncq_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ປີລາດ ຕາແບີບ ແອັນ ປາຍ: \"ຄັນ ນ່ະກັອຍ, ນານ່ະ ເຍືາ ໂອນ ເກົາ ຕະ ກະ ເຢຊູ, ລາ ອັນ ກາ ເນົ່າ ດໍອ໌ ກຣີດ?\" ໄລ່ ກັອຍ ຕາແອີຍ ປາຍ: \"ແຕັຮ ອັນ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ!\" ");
INSERT INTO ncq_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ປີລາດ ຕາແບີບ ລັ່ຮ ຊາ: \"ນານ່ະ? ອຶນເຕົ່າ ອັນ ຕະ ໂລ່ຍຮ ກະ ເຍືາ?\" ມາ ໄລ່ ກັອຍ ຕາແອີຍ ເຣ່ງ ລາລື່ ກາເລີຍ ແຕ ອຶນໂຍ່ງ: \"ແຕັຮ ອັນ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ!\" ");
INSERT INTO ncq_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ພໍກາ ປີລາດ ດັງ ອັນ ຕາ ເຕ່ອ໌ ຕະ ອຶນເຕົ່າ ນັ່ອງ ອີ ຈ່ອຍ ເຢຊູ, ກະ ອັນ ອຶງກັອຮ ກວາຍ ກຼຶ່ງ ກັອຍ ກັຣຈີດ ແອັນ, ນ່ະກັອຍ ອັນ ອີດ ແດີອ໌; ເຈີ່ ອັນ ອາເຣືາວ ອາຕີ ຢັ່ຮ ເມືາງ ກວາຍ ກຼຶ່ງ ກັອຍ, ກະ ອັນ ປາຍ: \"ໄນ່ ເກົາ ຕະ ໂອນ ເຍືາ ດັງ ເກົາ ຕາ ເບີນ ໂຕ່ດ ອຶນເຕົ່າ ແຕ ກວາຍ ໄນ່ ກູຈີດ. ຣານະ ກັອຍ ຕາມ ເຍືາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ອຶນແຍ່ະ ມັຮ ກວາຍ ກຼຶ່ງ ກັອຍ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ໂຕ່ດ ກວາຍ ກັອຍ ກູຈີດ ແຊອ໌ ໂອນ ແຕີ່ອ໌ ປໍ ຮິ ກະ ແຕີ່ອ໌ ປໍ ກອນ ອາໄກ ຮິ ແຮີ.\" ");
INSERT INTO ncq_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ເຈີ່ ປີລາດ ອາໂຣຍຮ ບາຣາບາ ໂອນ ມັຮ ກວາຍ ກຼຶ່ງ ກັອຍ. ມາ ເຢຊູ, ປີລາດ ໂອນ ເນົ່າ ໄປຣ່ຮ ອັນ. ແວັດ ກັອຍ ອັນ ມ່ອບ ເຢຊູ ໂອນ ໄລ່ ເດີງ ແຕັຮ ອັນ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ. ");
INSERT INTO ncq_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ເຈີ່, ມັຮ ຕາຮານ ປີລາດ, ໄລ່ ເດີງ ເຢຊູ ມູ່ດ ຕຶ່ງ ດຸງ ເນົ່າ ເກີ່ຍ ຕັດຊີ່ນ ກວາຍ. ອຶນຕຸ ກັອຍ ເບີນ ກຼຶ່ງ ຕາຮານ ການໍ່ອ໌ ແຕີ່ອ໌ ແອີດ ອຶມແປຣ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ໄລ່ ຕວດ ຕັຮ ຕຳປັອກ ເຢຊູ, ກະ ໄລ່ ອາແຊິບ ອັນ ອາຢັ່ອຮ ຕີ່ ຊີ່ ອາອູຍ. ");
INSERT INTO ncq_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ໄລ່ ຕະ ກຸນຕຣວາອ໌ ຊັຣເລືາ ອາປື່ງ ຕຶ່ງ ແປຼີ ອັນ. ກະ ໄລ່ ໂອນ ອັນ ຢຸມ ຣາແລີງ ຢັ່ຮ ອາຕີ ອາຕ່ຳ ອັນ. ແວັດ ກັອຍ ໄລ່ ກຼຸ່ ຣາໂກລ ຢັ່ຮ ເມືາງ ອັນ ກະ ອາເຢ່ ພາມາດ ອັນ ປາຍ: \"ກູກຸຮ ເນົ່າ ຊາຊາຍ ເຕືາວ ປັຣເຍືາ ອິດຊະຣາເອລ!\" ");
INSERT INTO ncq_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ໄລ່ ກູຈົຮ ໂຈະ ຕຶ່ງ ຈະ ເຢຊູ, ກະ ໄລ່ ອີດ ຣາແລີງ ກັອຍ ເຈີ່ ໄລ່ ປຍາຍຮ ອັນ ຕຶ່ງ ແປຼີ ຕາ ດັງ ອຶນຊິ ເຮີບ. ");
INSERT INTO ncq_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ແວັດ ໄລ່ ອາເຢ່ ພາມາດ ອັນ ນ່ະກັອຍ, ເຈີ່ ໄລ່ ຕວດ ອາຢັ່ອຮ ຕີ່ ກະ ອາແຊິບ ລັ່ຮ ຕຳປັອກ ອັນ ເບີມ. ເຈີ່ ໄລ່ ເດີງ ອັນ ລັ່ອຮ ກະ ແຕັຮ ອັນ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ. ");
INSERT INTO ncq_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ພໍກາ ໄລ່ ລັ່ອຮ ແຕ ເມືອງ, ໄລ່ ຣາມົຮ ຕຶ່ງ ຣານາ ມານະ ເບີນ ຣາມຶ່ຮ ຊີໂມນ. ອັນ ລາ ແຕ ກຣວາງ ກີເຣເນ. ໄລ່ ມັນຕຣຸ່ ອັນ ໂອນ ໂດລ ອາລ່ອງ ຊັງກັງ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ໄລ່ ກັອຍ ແຕີ່ອ໌ ປໍ ອຶນຕຸ ເບີນ ຣາມຶ່ຮ ໂຄລະໂຄທາ. ປັຣນາຍ ໄນ່ ອຶນຕີ ລັ່ຮ ລາ 'ອຶງຮາງ ຕາຕາຣ ແປຼີ.' ");
INSERT INTO ncq_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ແອີດ ອຶນຕຸ ກັອຍ ເນົ່າ ໂອນ ເຢຊູ ງ່ອຍ໌ ບຼັອງ ກາ ເນົ່າ ກູຈຸ ກະ ເກຣີ່ງ ອຶນຕັງ. ເຢຊູ ຈີ່ມ, ມາ ອັນ ຕາ ເບີນ ງ່ອຍ໌. ");
INSERT INTO ncq_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ເຈີ່ ໄລ່ ແຕັຮ ເຢຊູ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ. ກະ ໄລ່ ອຶມແປອ໌ ຕຳປັອກ ອັນ ຣານາ ມັນຕັດ ອາຍຸ່, ອາແລ່ະ ເບີນ ລາ ໂທຍ. ");
INSERT INTO ncq_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ແວັດ ກັອຍ ໄລ່ ຕາກູ ກຍາອ໌ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ຢັ່ຮ ແປີງ ແປຼີ ເຢຊູ ໄລ່ ດໍອ໌ ມູ່ ແພນ ກາດານ; ກະ ໄລ່ ຄຽນ ປັຣນາຍ ປາຍ: ກວາຍ ໄນ່ ລາ ເຢຊູ. ອັນ ລາ ເຕືາວ ປັຣເຍືາ ກວາຍ ອິດຊະຣາເອລ. ");
INSERT INTO ncq_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ບັອງ ກາ ກັອຍ ເນົ່າ ແຕັຮ ບາຣ ນະ ກວາຍ ຊາແວງ ແຈ່ະ ເຢຊູ ເຕ່, ມານະ ຢັ່ຮ ອາຕ່ຳ, ມານະ ຢັ່ຮ ອາເວ່ຣ. ");
INSERT INTO ncq_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ມັຮ ກວາຍ ກາ ເປາະ ພາ ອຶນຕຸ ກັອຍ, ໄລ່ ກັອຍ ງູງິ່ຣ ແປຼີ ກະ ອາເຢ່ ພາມາດ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ໄລ່ ປາຍ: \"ໄມ່ ໄນ່ ເອີຍ໌ ກາ ປາຍ ບັອງ ກັອຍ ໄມ່ ຕາລຸຮ ດຸງ ຊາງ ເຢືາງ ເຈົາຣາຊີ. ເຈີ່ ໄມ່ ຕະ ລັ່ຮ ໄປ ຕາໄງ ລາ ເຈີ່ ແຕິ່. ເອົາ ຊານໍ່ ໄມ່ ຈ່ອຍ ອາມົ່ງ ລັ່ຮ ຈະ ໄມ່ ເບີມ. ຄັນ ໄມ່ ລາ ເມ່ນ ກອນ ເຢືາງ ເຈົາຣາຊີ, ໄມ່ ແຊງ ແຕ ອາລ່ອງ ຊັງກັງ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ກະ ເບີນ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ກະ ມັຮ ກວາຍ ອາຕີ ຄານອດ, ກະ ມັຮ ກວາຍ ເທົາແກ ຈຸ່ມເຈືອ, ອຶນແຍ່ະ ໄລ່ ກັອຍ ອາເຢ່ ພາມາດ ເຢຊູ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","ໄລ່ ປາຍ: \"ກວາຍ ການໍ່ອ໌ ເຕ່ອ໌ ອັນ ຈ່ອຍ ອາມົ່ງ, ມາ ຈະ ອັນ ເບີມ, ຕາ ເຮີມ ເຕ່ອ໌ ອັນ ຈ່ອຍ. ຄັນ ອັນ ລາ ເຕືາວ ປັຣເຍືາ ກວາຍ ອິດຊະຣາເອລ, ໂອນ ອັນ ແຊງ ເບີມ ແຕ ອາລ່ອງ ຊັງກັງ ກັອຍ. ຄັນ ນ່ະກັອຍ, ໄຮ ຊາອຳ ເຕ່ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ອັນ ຊາອຳ ເຢືາງ ເຈົາຣາຊີ, ກະ ອັນ ປາຍ ອັນ ລາ ກອນ ເຢືາງ ເຈົາຣາຊີ. ຄັນ ນ່ະກັອຍ, ໂອນ ເຢືາງ ເຈົາຣາຊີ ຈ່ອຍ ອາມົ່ງ ອັນ ຊານໍ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ກະ ໄລ່ ບາຣ ນະ ຊາແວງ ກາ ເນົ່າ ແຕັຮ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ ມວຍ ເປຣິຮ ກະ ເຢຊູ, ໄລ່ ອາເຢ່ ພາມາດ ເຢຊູ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ແຕ ມັ່ດ ມານາງ ຕີລມູ່ລ ເຕົ່າ ແຕີ່ອ໌ ມານາງ ວີ່ຮ, ແກີດ ການຳ ອຶນແຍ່ະ ຕຶ່ງ ກຣວາງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ແຕີ່ອ໌ ມານາງ ກູແວີ ອີ ວີ່ຮ ເຢຊູ ກູອ໌ ເຣ່ງ ລາລື່ ປາຍ: \"ເອລີ, ເອລີ, ແລມາ ຊາບັກທານີ?\" ປັຣນາຍ ໄນ່ ອຶນຕີ ລັ່ຮ ລາ: \"ເຢືາງ ເຈົາຣາຊີ ເກົາ ເອີຍ! ເຢືາງ ເຈົາຣາຊີ ເກົາ ເອີຍ! ນານ່ະ ໄມ່ ຕັຮ ເກົາ?\" ");
INSERT INTO ncq_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ເບີນ ກວາຍ ກາ ແອີດ ຕາຢຶ່ງ ແຈ່ະ ກັອຍ, ໄລ່ ຊັອງ ເຢຊູ ກູອ໌. ໄລ່ ປາຍ: \"ອັນ ກູອ໌ ເອລີຢາ!\" ");
INSERT INTO ncq_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ເບີນ ມານະ ແຕ ໄລ່ ກັອຍ, ອັນ ຕາລຸ່ຮ ອີດ ມວຍ ປານຍາລ ອາຣິ. ອັນ ອາລຸ ອາຣິ ກັອຍ ຕຶ່ງ ບຼັອງ ອຶນເຍາະ, ກະ ອັນ ຊັດ ອາຣິ ກັອຍ ຕຶ່ງ ຊັຣນວາຍຮ. ເຈີ່ ອັນ ອາແວີຍ ໂອນ ເຢຊູ ກາຢັບ ງ່ອຍ໌. ");
INSERT INTO ncq_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ມາ ກວາຍ ການໍ່ອ໌ ປາຍ: \"ໄຮ ເກຣາະ ເວືາຍ. ໄຮ ເນ່ ເວືາຍ ເອລີຢາ ແຕີ່ອ໌ ຈ່ອຍ ອັນ, ມາ ຕາ ເບີນ!\" ");
INSERT INTO ncq_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ເຢຊູ ອູໂອຍ ເຣ່ງ ລາລື່ ຊາ, ເຈີ່ ອັນ ຕາອັອຮ ຣາງຶ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ບັອງ ກາ ກັອຍ ແຕິ່ ອາຣິ ກາ ເນົ່າ ກາຕັງ ກຼຸງ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ ແກີດ ຣາແຮອ໌ ແຕ ຕີ່ ແຕີ່ອ໌ ເຕືາບ, ແກີດ ບາຣ ຊາແຣອ໌. ກູແຕອ໌ ກູກື່ດ, ກະ ຕາເມົາ ແກີດ ປຼັຮ. ");
INSERT INTO ncq_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ປີ່ງ ກູມູ່ຍ໌ ນ່ະ ເນົ່າ ເປິຮ ເບີມ ໂອນ ຊາອຶ່ຍ ນະ ກວາຍ ກາ ຕາປູ່ນ ຣານະ ເຢືາງ ເຈົາຣາຊີ ກາ ກູຈີດ ເບີນ ອາມົ່ງ ລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ແວັດ ເຢຊູ ອາມົ່ງ ລັ່ຮ, ມັຮ ກວາຍ ກາ ກູຈີດ ກັອຍ, ໄລ່ ລັ່ອຮ ເຕ່ ແຕ ປີ່ງ ໄລ່. ກະ ໄລ່ ມູ່ດ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ. ແອີດ ອຶນຕຸ ກັອຍ ເບີນ ກຼຶ່ງ ກວາຍ ການໍ່ອ໌ ເຮີມ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ບັອງ ກາ ກັອຍ ເບີນ ມານະ ຕາຮານ ກາ ຊົດ ມວຍ ຣ່ອຍ ຕາຮານ ການໍ່ອ໌. ອັນ ກະ ຕາຮານ ການໍ່ອ໌ ກັອຍ ແອີດ ກຍາອ໌ ເຢຊູ. ອຶນແຍ່ະ ໄລ່ ກັອຍ ເຮີມ ກູແຕອ໌ ກູກື່ດ, ກະ ໄລ່ ເຮີມ ອຶນແຍ່ະ ຣາມຶ່ຮ ການໍ່ອ໌ ແຮີ. ນ່ະກັອຍ ໄລ່ ຊັອງ ອຶງກັອຮ, ກະ ໄລ່ ປາຍ: \"ເມ່ນ ລາລື່ ໄນ່ ລາ ກອນ ເຢືາງ ເຈົາຣາຊີ!\" ");
INSERT INTO ncq_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ເບີນ ຊາອຶ່ຍ ນະ ກວາຍ ມັນແຊມ ແອີດ ແຕ ເຢີ່ງ ຕາເງີ່ອ໌ ເນ່ ປໍ ເຢຊູ ເຕ່. ແຕ ອຶນໂຍ່ງ ໄລ່ ກັອຍ ຕາປູ່ນ ເຢຊູ ແຕ ແຄງ ຄາລີເລ, ກະ ໄລ່ ແຈມ ກຍາອ໌ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ຕຶ່ງ ມູ່ ມັນແຊມ ກັອຍ ເບີນ ມາຣີ ແຕ ວີ່ລ ມັກດາລາ, ກະ ມາຣີ ລາ ອຶມເປ່ອ໌ ຢາໂກໂບ ກະ ໂຢເຊັບ, ກະ ອຶມເປ່ອ໌ ໄລ່ ບາຣ ນະ ກອນ ເຊເບດາຍ. ");
INSERT INTO ncq_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ແຕີ່ອ໌ ມານາງ ຕາບື່ ແຈ່ະ ອຶນຕຣວຍ ອີ ມູ່ດ ລົ່ກ, ແຕີ່ອ໌ ມານະ ກວາຍ ຊຸ ແຕ ເມືອງ ອາຣີມາທາຍ. ຣາມຶ່ຮ ອັນ ລາ ໂຢເຊັບ. ອັນ ລາ ກວາຍ ຣຍານ ແຕ ເຢຊູ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ອັນ ເປາະ ປໍ ປີລາດ, ກະ ອັນ ແຊອ໌ ກູມູ່ຍ໌ ເຢຊູ. ປີລາດ ແປຣີ ໂອນ ເນົ່າ ໂອນ ກູມູ່ຍ໌ ເຢຊູ ປໍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ນ່ະກັອຍ ອັນ ອີດ ກູມູ່ຍ໌ ເຢຊູ, ກະ ອັນ ຕວມ ກູມູ່ຍ໌ ກັອຍ ແຕ ອາຣິ ກຼໍອ໌ ແຈບ ອໍ ກາ ອຶນນັ່ອງ ຕາໄມ. ");
INSERT INTO ncq_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ເຈີ່ ອັນ ດໍອ໌ ກູມູ່ຍ໌ ກັອຍ ຕຶ່ງ ປີ່ງ ຕາໄມ ຄອງ ອັນ, ປີ່ງ ກາ ເນົ່າ ໄປອ໌ ຕຶ່ງ ຕາເມົາ. ເຈີ່ ອັນ ວິ່ລ ຕາເມົາ ກາຕັງ ງັ່ຮ ປີ່ງ ກັອຍ. ແວັດ ກັອຍ ອັນ ເປາະ. ");
INSERT INTO ncq_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ມາຣີ ແຕ ວີ່ລ ມັກດາລາ, ກະ ມາຣີ ການໍ່ອ໌ ແຮີ, ໄລ່ ຕາກູ ຕາເງີ່ອ໌ ເນ່ ປໍ ງັ່ຮ ປີ່ງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ມາຮ ຕາໄງ ປັຣແນີ ແອັນ ລາ ຕາໄງ ຣາລູ່. ຕາໄງ ກັອຍ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ກະ ມັຮ ກວາຍ ພາຣີຊາຍ, ໄລ່ ເປາະ ຣາມົຮ ປີລາດ. ");
INSERT INTO ncq_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ໄລ່ ປາຍ ໂຈະ ປີລາດ: \"ອາຈວາຍຮ ເອີຍ! ຮິ ຊາແຍີ ບັອງ ກາ ກວາຍ ອາໂລກ ກັອຍ ອຶນນັ່ອງ ອາມົ່ງ ອັນ ປາຍ: 'ເກົາ ກູຈີດ, ມາ ແວັດ ໄປ ຕາໄງ ແອັນ ເກົາ ອາມົ່ງ ລັ່ຮ.' ");
INSERT INTO ncq_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ນ່ະກັອຍ ຮິ ແຊອ໌ ອາຈວາຍຮ ໂອນ ເນົ່າ ກຍາອ໌ ອໍ ປີ່ງ ກູມູ່ຍ໌ ກັອຍ ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ໄປ. ເຈີ່ ມູ່ ກາ ຣຍານ ແຕ ອັນ ຕາ ເຕ່ອ໌ ເປາະ ອີດ ຕວຍ໌ ຈະ ກູມູ່ຍ໌ ກັອຍ. ຄັນ ໄລ່ ເບີນ ຕວຍ໌, ໄລ່ ອາຕີ ກະ ກວາຍ ການໍ່ອ໌ ປາຍ: 'ເຢຊູ ກູຈີດ, ເຈີ່ ອັນ ອາມົ່ງ ລັ່ຮ.' ຄັນ ໄລ່ ປາຍ ເຢຊູ ອາມົ່ງ ລັ່ຮ, ອາໂລກ ກັອຍ ອຶນຕັອງ ກາເລີຍ ແຕ ເນົ່າ ອາໂລກ ປາຍ ອັນ ລາ ກຣີດ.\" ");
INSERT INTO ncq_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ເຈີ່ ປີລາດ ຕາແອີຍ ໄລ່ ປາຍ: \"ເຍືາ ອີດ ຕາຮານ ເຍືາ ເບີມ ໂອນ ໄລ່ ເປາະ ກຍາອ໌ ປີ່ງ ກັອຍ, ຕາມ ຣາງຶ່ຮ ເຍືາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ໄລ່ ລັ່ອຮ ແຕ ກັອຍ, ເຈີ່ ໄລ່ ກາໄຕ່ຮ ດໍອ໌ ຕະ ໂອນ ຈັບ ລາລື່ ງັ່ຮ ປີ່ງ ກັອຍ. ກະ ໄລ່ ໂອນ ຕາຮານ ກຍາອ໌ ອຶນຕຸ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ແວັດ ຕາໄງ ຣາລູ່, ແຕີ່ອ໌ ຕາໄງ ມວຍ ຕຶ່ງ ອາທິດ ຕາໄມ, ຕາຣື່ບ ກັອຍ ອຶນນັ່ອງ ຍາຍຶ່ມ ເບີນ ມາຣີ ແຕ ວີ່ລ ມັກດາລາ ກະ ມາຣີ ການໍ່ອ໌ ເປາະ ເນ່ ປີ່ງ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ບັອງ ກັອຍ ເບີນ ກູແຕອ໌ ກູກື່ດ ຮັບ ລາລື່, ຍ່ອນ ເບີນ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ແຊງ ວິ່ລ ຕາເມົາ ກາ ເນົ່າ ກາຕັງ ງັ່ຮ ປີ່ງ ເຢຊູ, ເຈີ່ ຕາກູ ຕຶ່ງ ຕາເມົາ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ຣູ່ບເຣືາງ ເທວາດາ ກັອຍ ລາ ນ່ະ ຕາລຍາຣ, ກະ ຕຳປັອກ ອັນ ລາ ກຼໍອ໌ ຊັຣມຍາລ ມັ່ດ. ");
INSERT INTO ncq_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ມັຮ ຕາຮານ ກາ ກຍາອ໌ ປີ່ງ ກັອຍ ໄລ່ ຊັອງ ອຶງກັອຮ ລາລື່ ກະ ກາໄກ່ຮ. ໄລ່ ແກີດ ນ່ະ ກວາຍ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ມັນແຊມ ກັອຍ ປາຍ: \"ເຍືາ ອຶນໂຈຍ ອຶງກັອຮ ອຶນເຕົ່າ. ເກົາ ດັງ ເຍືາ ຈໍ່ອ໌ ເຢຊູ, ອັນ ກາ ເນົ່າ ແຕັຮ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ. ");
INSERT INTO ncq_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ອັນ ຕາ ເບີນ ແອີດ ອຶນໄນ່ ນັ່ອງ. ອັນ ອາມົ່ງ ລັ່ຮ ເຈີ່ ນ່ະ ອັນ ປາຍ ໂຈະ ເຍືາ ແຕ ອຶນໂຍ່ງ. ເຍືາ ແຕີ່ອ໌ ປໍ ໄນ່, ເນ່ ປໍ ອຶນຕຸ ເນົ່າ ດໍອ໌ ກູມູ່ຍ໌ ອັນ ແຕ ອຶນໂຍ່ງ. ");
INSERT INTO ncq_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ເຈີ່ ເຍືາ ເປາະ ໄວ່ ເຈົາ ອາຕີ ມັຮ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: 'ເຢຊູ ອາມົ່ງ ລັ່ຮ ເຈີ່. ຊານໍ່ ອັນ ເປາະ ອຶນໂຍ່ງ ເຍືາ ເຈົາ ປໍ ແຄງ ຄາລີເລ. ຕຶ່ງ ອຶນຕຸ ກັອຍ ເຍືາ ເບີນ ຣາມົຮ ອັນ!' ອຶງເຄາະ ເຍືາ ຊາແຍີ ລັ່ຮ ມັຮ ປັຣນາຍ ກາ ເກົາ ອາຕີ ເຍືາ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ນ່ະກັອຍ ມັນແຊມ ກັອຍ ລັ່ອຮ ແຕ ປີ່ງ. ກາ ໄລ່ ອຶງກັອຮ, ກາ ໄລ່ ຣໍ່ອ໌ ແຮີ. ໄລ່ ຕາລຸ່ຮ ເປາະ ອາຕີ ມັຮ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ບັອງ ກາ ໄລ່ ເປາະ, ເຢຊູ ຣາມົຮ ໄລ່, ກະ ອັນ ກັຣບັນ ໄລ່ ປາຍ: \"ໂອນ ເຍືາ ແອີດ ບັນຊວານ ເຕ່.\" ມັນແຊມ ກັອຍ ແຕີ່ອ໌ ປໍ ເຢຊູ, ຊາອູບ ອາເຢີງ ອັນ, ກະ ຊາງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ເຢຊູ ອາຕີ ໄລ່ ປາຍ: \"ເຍືາ ອຶນໂຈຍ ອຶງກັອຮ ອຶນເຕົ່າ. ເຍືາ ເປາະ ອາຕີ ແຊມອາຍ ເກົາ ໂອນ ໄລ່ ເປາະ ປໍ ແຄງ ຄາລີເລ. ຕຶ່ງ ອຶນຕຸ ກັອຍ ໄລ່ ເບີນ ຣາມົຮ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ບັອງ ກາ ມັນແຊມ ກັອຍ ອຶນນັ່ອງ ເປາະ ຕຶ່ງ ຣານາ, ຕາຮານ ກາ ກຍາອ໌ ປີ່ງ ເຢຊູ ເຈົາ ປໍ ເມືອງ ກະ ອາຕີ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ກູ່ ຣາມຶ່ຮ ມັຮ ກາ ໄລ່ ເຮີມ. ");
INSERT INTO ncq_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ມັຮ ກວາຍ ຊົດ ກັອຍ, ໄລ່ ໂຣ່ມ ຊັຣຮົງ ກະ ມັຮ ກວາຍ ເທົາແກ ຈຸ່ມເຈືອ. ເຈີ່ ໄລ່ ໂອນ ຊາອຶ່ຍ ປຣະ ປໍ ຕາຮານ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ກະ ໄລ່ ອາຕີ ຕາຮານ ກັອຍ ປາຍ: \"ໂອນ ເຍືາ ປາຍ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ແຕີ່ອ໌ ຊາເດົາ ອີດ ຕວຍ໌ ຈະ ກູມູ່ຍ໌ ເຢຊູ ບັອງ ກາ ເຍືາ ບິ. ");
INSERT INTO ncq_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ມາ ຄັນ ປີລາດ, ອັນ ກາ ຊົດ ກຣວາງ, ເບີນ ຊັອງ ແຕ ຣາມຶ່ຮ ໄນ່, ຮິ ຣາປາຍ ຈ່ອຍ ເຍືາ ເຕ່ ໂອນ ກວາຍ ຊົດ ກັອຍ ຕາ ເບີນ ຕະ ອຶນເຕົ່າ ກະ ເຍືາ.\" ");
INSERT INTO ncq_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ມັຮ ກວາຍ ຕາຮານ ກັອຍ, ໄລ່ ອີດ ປຣະ ກັອຍ ກະ ໄລ່ ຕະ ຕາປູ່ນ ມັຮ ປັຣນາຍ ກາ ເນົ່າ ປາຕັບ ໄລ່. ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ໄນ່ ເບີນ ກວາຍ ອິດຊະຣາເອລ ອາຕີ ປັຣນາຍ ກັອຍ ດັອຮແດີນ ໂອນ ກວາຍ ການໍ່ອ໌ ດັງ. ");
INSERT INTO ncq_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ໄລ່ ມວຍ ຈິ່ດ ລາ ມານະ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ, ໄລ່ ຊັອຮ ປໍ ກົຮ ຕຶ່ງ ແຄງ ຄາລີເລ ປໍ ອຶນຕຸ ເຢຊູ ອາຕີ ໂອນ ໄລ່ ເປາະ. ");
INSERT INTO ncq_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ພໍກາ ໄລ່ ເຮີມ ເຢຊູ, ໄລ່ ຊາງ ອັນ; ມາ ເບີນ ບາຣ ໄປ ນະ ແຕ ມູ່ ກັອຍ ອຶນນັ່ອງ ກູຄຶ່ດ ຕາ ເບີນ ນັ່ບ. ");
INSERT INTO ncq_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ເຢຊູ ແຕີ່ອ໌ ປໍ ໄລ່ ກະ ອາຕີ ໄລ່ ປາຍ: \"ອຶນແຍ່ະ ອຳນາດ ຕຶ່ງ ມັນລັ່ອງ ກະ ຕຶ່ງ ກູແຕອ໌, ເຢືາງ ເຈົາຣາຊີ ມ່ອບ ໂອນ ເກົາ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ນ່ະກັອຍ ອຶງເຄາະ ເຍືາ ເປາະ ອາຕີ ກູ່ ນະ ກວາຍ ໂອນ ໄລ່ ແກີດ ກວາຍ ຣຍານ ແຕ ເກົາ ເຕ່. ອຶງເຄາະ ເຍືາ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ໄລ່, ຍ່ອນ ຣາມຶ່ຮ ອຶມປໍ່, ຍ່ອນ ຣາມຶ່ຮ ກອນ, ກະ ຍ່ອນ ຣາມຶ່ຮ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ອຶງເຄາະ ເຍືາ ອາຕີ ໄລ່ ໂອນ ໄລ່ ຕະ ຕາປູ່ນ ກູ່ ຣາມຶ່ຮ ກາ ເກົາ ປາຕັບ ເຍືາ. ກະ ໄກຣ ລາລື່ ເກົາ ແອີດ ກະ ເຍືາ ຊົດ ແດີຍ ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ປັຣຊົດ.\"");
INSERT INTO ncq_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ປັຣນາຍ ໄນ່ ຕາແບິ ອາຕີ ປັຣນາຍ ອໍ ແຕ ເຢຊູ ກຣີດ ກອນ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ຣານະ ໄນ່ ເອຊາຢາ, ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ຄຽນ ອາຕີ ດໍອ໌ ອຶນໂຍ່ງ ໂຢຮັນ ອີ ແຕີ່ອ໌. ເອຊາຢາ ຄຽນ ປາຍ: \"ເກົາ ລາ ເຢືາງ ເຈົາຣາຊີ ອີ ແປຣີ ກວາຍ ອາຕີ ປັຣນາຍ ເກົາ ແຕີ່ອ໌ ອຶນໂຍ່ງ ໄມ່. ອັນ ຈັຮ ຣານາ ໂອນ ໄມ່, ກອນ ເອີຍ. ");
INSERT INTO ncq_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ເບີນ ຊຽງ ກວາຍ ມານະ, ອັນ ຊາບາວ ອາຕີ ເຣ່ງ ລາລື່ ແຕ ຕຍາຮ ປາຍ: 'ເຍືາ ອຶງເຄາະ ອາຕຶ່ ຣານາ ໂອນ ອຶນເຈົາ ໄຮ. ຕະ ໂອນ ຕານັ່ອງ ຣານາ ອັນ ອີ ເປາະ.'\" ");
INSERT INTO ncq_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ນ່ະກັອຍ ແຕີ່ອ໌ ມານະ ຣາມຶ່ຮ ໂຢຮັນ. ອັນ ແອີດ ຕຶ່ງ ຕຍາຮ, ກະ ອັນ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ກວາຍ. ອັນ ເປາະ ອາຕີ ໂອນ ອຶນແຍ່ະ ກູ່ ນະ ດັງ ແຕ ຣານະ ຣີ່ດ ຕຶ່ງ ແດີອ໌. ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໄນ່ ລາ ຕະ ໂອນ ເນົ່າ ດັງ ກວາຍ ເບີນ ປຽນ ອີດ ຣາງຶ່ຮ ຕາໄມ ແອັນ, ໂອນ ເຢືາງ ເຈົາຣາຊີ ຕັຮ ໂລ່ຍຮ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ນ່ະກັອຍ ກອນແຊມ ຊາອຶ່ຍ ນະ ແຕ ແຄງ ຢູດາຍ ກະ ແຕ ເມືອງ ເຢຣູຊາເລັມ ແຕີ່ອ໌ ປໍ ໂຢຮັນ. ໄລ່ ກັອຍ ງີ່ນ ໂລ່ຍຮ, ເຈີ່ ໂຢຮັນ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ໄລ່ ຕຶ່ງ ຕາເລ່ ຈໍແດນ. ");
INSERT INTO ncq_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ໂຢຮັນ ຕັອກ ເກຣີ່ງ ເນົ່າ ຕະ ແຕ ໂຊະ ຊັນຕຣັ່ນ ອູ່ດ. ອັນ ກັນຕັ່ນ ປັຣນຸ່ງ ອຶງກັຣ ຕຶ່ງ ອຶງກີງ ອັນ; ຊັຣນາ ອັນ ຈາ ລາ ລາມ ກະ ອັນ ງ່ອຍ໌ ແດີອ໌ ກາຮຍາລ ແຕ ຕຍາຮ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ອັນ ອາຕີ ກອນແຊມ ປາຍ: \"ເບີນ ມານະ ອີ ແຕີ່ອ໌ ອຶນຕູ່ນ ເກົາ ກາ ເບີນ ອຳນາດ ປື່ດ ກາເລີຍ ແຕ ເກົາ. ເກົາ ລາ ຕາ ເບີນ ປຍາຍ໌ ອາແລັ່ຮ ອຶນໄຊ ແກີບ ແຕ ອາເຢີງ ອັນ, ຍ່ອນ ເກົາ ລາ ອຳນາດ ແກດໆ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ເກົາ ຕະ ຣີ່ດ ໂອນ ເຍືາ ຕຶ່ງ ແດີອ໌ ຊັອງ, ມາ ອັນ ຕະ ຣີ່ດ ໂອນ ເຍືາ ເບີນ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ບັອງ ກາ ໂຢຮັນ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ປໍ ກັອຍ, ເຢຊູ ແຕີ່ອ໌ ແຕ ວີ່ລ ນາຊາເຣັດ ແຄງ ຄາລີເລ. ເຈີ່ ໂຢຮັນ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ເຢຊູ ຕຶ່ງ ຕາເລ່ ຈໍແດນ. ");
INSERT INTO ncq_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ພໍກາ ເຢຊູ ຊັອຮ ແຕ ແດີອ໌, ອັນ ຕາເງີ່ອ໌ ອາຊັອຮ ປໍ ມັນລັ່ອງ. ອັນ ເຮີມ ມັນລັ່ອງ ເປິຮ ອາລັ່ອຮ. ເບີນ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ນ່ະ ແຈມ ປາເຣືາດ ແຊງ ປໍ ຈະ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ເຈີ່ ເບີນ ຊຽງ ຊາບາວ ອາຕີ ແຕ ມັນລັ່ອງ ປາຍ: \"ໄມ່ ລາ ກອນ ເກົາ, ອັນ ກາ ເກົາ ອາໂຢ່ະ ລາລື່; ເກົາ ຊັອງ ຣໍ່ອ໌ ລາລື່ ກະ ໄມ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ບັອງ ກາ ກັອຍ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ແປຣີ ເຢຊູ ເປາະ ປໍ ຕຍາຮ. ");
INSERT INTO ncq_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ເຢຊູ ແອີດ ອຶງກັອຍ ເບີນ ເຢືາງ ຊາຕານ ລ່ອງ ອັນ ອຶນແຍ່ະ ປູນ ຈິ່ດ ຊາເດົາ ປູນ ຈິ່ດ ຕາໄງ, ອັນ ຢໍອ໌ ອີ ປັຣຕຶ່ ເຢຊູ ໂອນ ຕະ ໂລ່ຍຮ. ເຢຊູ ແອີດ ມັນຕຸ ກະ ຊັນຕຣັ່ນ ກຣວາງ, ກະ ເບີນ ເທວາດາ ເນ່ ຊາລີອ໌ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ແວັດ ເນົ່າ ໂກບ ໂຢຮັນ ໂຈະ ຕຶ່ງ ກໍ່ອ໌, ເຢຊູ ເປາະ ປໍ ແຄງ ຄາລີເລ ອາຕີ ປັຣນາຍ ອໍ ແຕ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ອັນ ອາຕີ ປາຍ: \"ແຈ່ະ ອີ ແຕີ່ອ໌ ເຈີ່ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ເອີອ໌ ດໍອ໌ ອີ ຕະ ຊົດ ຕຶ່ງ ຣາງຶ່ຮ ກວາຍ. ອຶງເຄາະ ເຍືາ ຕັຮ ຣາງຶ່ຮ ຕຍາ ອີດ ຣາງຶ່ຮ ຕາໄມ ກະ ຊາອຳ ປັຣນາຍ ອໍ ແຕ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ບັອງ ກາ ເຢຊູ ເປາະ ຕາມ ປຶ່ຮ ທາເລ ຣາປັ່ງ ຄາລີເລ, ອັນ ເຮີມ ບາຣ ນະ ແຊມອາຍ ຣາມຶ່ຮ ຊີໂມນ ກະ ອັນເດອາ. ໄລ່ ຕິງ ມ່ອງ ຕຶ່ງ ທາເລ ຣາປັ່ງ ຍ່ອນ ໄລ່ ກັອຍ ລາ ກວາຍ ຈໍ່ອ໌ ອາກາ. ");
INSERT INTO ncq_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ເຢຊູ ອາຕີ ໄລ່ ປາຍ: \"ເຍືາ ເປາະ ກະ ເກົາ. ເຈີ່ ເກົາ ໂອນ ເຍືາ ແກີດ ກວາຍ ຈໍ່ອ໌ ກວາຍ ນ່ະ ເຍືາ ຈໍ່ອ໌ ອາກາ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ໄລ່ ບາຣ ນະ ແຊມອາຍ ກັອຍ ຕັຮ ແຕິ່ ມ່ອງ, ເຈີ່ ໄລ່ ເປາະ ກະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ເຢຊູ ຕາຢັຮ ເປາະ ບຍາອ໌ ແອັນ, ເຈີ່ ອັນ ເຮີມ ບາຣ ນະ ແຊມອາຍ ຣາມຶ່ຮ ຢາໂກໂບ ກະ ໂຢຮັນ ກອນ ຣາເລົາ ເຊເບດາຍ. ໄລ່ ກັອຍ ແອີດ ພູງ ມ່ອງ ຕຶ່ງ ຕົວະ. ");
INSERT INTO ncq_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ພໍ ກັອຍ ເຢຊູ ກູອ໌ ໄລ່ ບາຣ ນະ ແຊມອາຍ ກັອຍ. ເຈີ່ ໄລ່ ບາຣ ນະ ຣາຕັຮ ແຕ ເຊເບດາຍ ອຶມປໍ່ ໄລ່, ໂອນ ອັນ ແອີດ ຕຶ່ງ ຕົວະ ກະ ກວາຍ ທູແທ. ເຈີ່ ໄລ່ ບາຣ ນະ ກັອຍ ເປາະ ກະ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ເປາະ ປໍ ເມືອງ ກາເປນາອູມ. ແຕີ່ອ໌ ຕາໄງ ຣາລູ່ ເຢຊູ ມູ່ດ ຕຶ່ງ ດຸງ ຊາງ ກວາຍ ອິດຊະຣາເອລ, ເຈີ່ ອັນ ອາຣຍານ ກວາຍ ອຶງກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ອຶນແຍ່ະ ນະ ກວາຍ ກາ ໂຣ່ມ ອຶງກັອຍ ຊັອງ ງຶ່ດ ລາລື່ ພໍກາ ໄລ່ ຊັອງ ປັຣນາຍ ອັນ ອາຕີ. ອັນ ອາຣຍານ ນ່ະ ກວາຍ ເບີນ ອຳນາດ, ລາ ອຶມພາ ແຕ ມູ່ ກາ ອາຕີ ຄານອດ ອາຣຍານ. ");
INSERT INTO ncq_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ຕຶ່ງ ດຸງ ຊາງ ກັອຍ ເບີນ ມານະ ກວາຍ ຣາເລົາ ກາ ເຢືາງ ຕາ ອໍ ຕຣວບ. ອັນ ແຮຣ ເຣ່ງ ລາລື່ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","\"ເຢຊູ ກວາຍ ວີ່ລ ນາຊາເຣັດ ເອີຍ! ເຍືາ ແຕີ່ອ໌ ຕະ ອຶນເຕົ່າ ປໍ ຮິ? ເຍືາ ແຕີ່ອ໌ ປໍ ໄນ່ ເຍືາ ອີ ອາປິ່ດ ຮິ ບໍ? ຮິ ດັງ ເຈີ່ ປາຍ ເຍືາ ແຕີ່ອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ ກະ ເຍືາ ລາ ຕາ ເບີນ ໂລ່ຍຮ ອຶນເຕົ່າ.\" ");
INSERT INTO ncq_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ເຢຊູ ກາແອັຮ ເຢືາງ ຕາ ອໍ ກັອຍ ປາຍ: \"ອຶນໂຈຍ ຕະ ແບອ໌! ໄມ່ ລັ່ອຮ ແຕິ່ ແຕ ຈະ ກວາຍ ໄນ່!\" ");
INSERT INTO ncq_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ເຢືາງ ຕາ ອໍ ຕະ ໂອນ ກວາຍ ກັອຍ ດາແດັຮ ອຶນແຍ່ະ ເຣ່ງ ກະ ອັນ ແຮຣ ເຣ່ງ ລາລື່. ເຈີ່ ອັນ ລັ່ອຮ ແຕ ຈະ ກວາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ອຶນແຍ່ະ ນະ ກວາຍ ອຶງກັອຍ ໄລ່ ຊັອງ ງຶ່ດ ລາລື່. ເຈີ່ ໄລ່ ຣາໂຊ ມັນຕຸ ປາຍ: \"ນານ່ະ ອັນ ອາຕີ ປັຣນາຍ ຕາໄມ? ອັນ ເບີນ ອຳນາດ ປື່ດ ລາລື່; ເຕ່ອ໌ ອັນ ກາແອັຮ ເຢືາງ ຕາ ອໍ, ເຈີ່ ເຢືາງ ຕາ ອໍ ຊາງັດ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ນ່ະກັອຍ ປັຣນາຍ ເນົ່າ ຕະ ອຶນຕີ ແຕ ເຢຊູ ແກີດ ດັອຮແດີນ ເປາະ ກູ່ ວີ່ລ ຕຶ່ງ ແຄງ ຄາລີເລ. ");
INSERT INTO ncq_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ພໍກາ ໄລ່ ລັ່ອຮ ແຕ ດຸງ ຊາງ ກັອຍ, ຢາໂກໂບ ກະ ໂຢຮັນ ໄລ່ ເປາະ ກະ ເຢຊູ ປໍ ດຸງ ຊີໂມນ ກະ ອັນເດອາ. ");
INSERT INTO ncq_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ກູຢາກັນ ຊີໂມນ ບິ ຍ່ອນ ອັນ ອາອີ່ ກູເຕົາ ຈະ; ເຈີ່ ໄລ່ ອາຕີ ໂອນ ເຢຊູ ດັງ ປາຍ ອາຢ່ະ ອາໄນ່ ອາອີ່. ");
INSERT INTO ncq_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ເຢຊູ ເປາະ ປໍ ອາຢ່ະ ກັອຍ, ເຈີ່ ເຢຊູ ຢຸມ ອາຕີ ອາຢວຣ ອັນ; ພໍກາ ກັອຍ ເຈີ່ ອັນ ແກີດ ແບຣັຮ. ເຈີ່ ອັນ ອາລັ່ອຮ ໂດຍ ແດີອ໌ ໂອນ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ແວັດ ມານາງ ປັດ ຕາບື່ ກັອຍ, ເນົ່າ ເດີງ ປໍ ເຢຊູ ອຶນແຍ່ະ ນະ ກວາຍ ກາ ຕິ່ ອາອີ່ ກະ ມັຮ ກາ ກວາຍ ເຢືາງ ຕາ ອໍ ຕຣວບ. ");
INSERT INTO ncq_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ກອນແຊມ ອຶນແຍ່ະ ນະ ຕຶ່ງ ເມືອງ ກັອຍ ເບີນ ເປາະ ໂຣ່ມ ອຶມແປຣ ງັ່ຮ ຕົ່ງ ດຸງ ເຢຊູ ແອີດ. ");
INSERT INTO ncq_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ເຢຊູ ປົວ ຊາອຶ່ຍ ນະ ກູ່ ຣາມຶ່ຮ ກາ ໄລ່ ອາອີ່. ອັນ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ແຕ ຈະ ກວາຍ ແຮີ, ອັນ ຕາ ໂອນ ເຢືາງ ຕາ ອໍ ຕະ ອຶນຕີ ອຶນເຕົ່າ, ຍ່ອນ ເຢືາງ ຕາ ອໍ ກັອຍ ຊາກັ່ລ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ປຼື່ ຕາຣື່ບ ຕາໄງ ຕາໄມ ແຕ ການໍາໆ, ເຢຊູ ລັ່ອຮ ແຕ ດຸງ, ເຈີ່ ອັນ ເປາະ ປໍ ອຶນຕຸ ກາ ຕາ ເບີນ ກວາຍ ແອີດ, ກະ ອັນ ແອີດ ເກົາແຊອ໌ ອຶງກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ຊີໂມນ ກະ ເຢົ່າ ອັນ ເປາະ ຈໍ່ອ໌ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ພໍກາ ໄລ່ ຣາມົຮ ອັນ, ໄລ່ ອາຕີ ອັນ ປາຍ: \"ອຶນແຍ່ະ ກູ່ ນະ ກວາຍ ຈໍ່ອ໌ ອີ ຣາມົຮ ໄມ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ເຢຊູ ຕາແອີຍ ລັ່ຮ ໄລ່ ກັອຍ ປາຍ: \"ໄຮ ອຶງເຄາະ ເປາະ ປໍ ວີ່ລ ການໍ່ອ໌ ອຶມແປຣ ໄນ່ ແອັນ. ເກົາ ຢໍອ໌ ອີ ອາຕີ ກອນແຊມ ກັອຍ ແຮີ. ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່ ລາ ຍ່ອນ ເກົາ ອີ ຕະ ຣານະ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ນ່ະກັອຍ ເຢຊູ ເປາະ ອາຕີ ຕຶ່ງ ມັຮ ກາ ດຸງ ຊາງ ຕຶ່ງ ແຄງ ຄາລີເລ. ອັນ ຕູ່ຍຮ ເຢືາງ ຕາ ອໍ ແຕ ຈະ ກວາຍ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ເບີນ ມານະ ກວາຍ ຣາເລົາ ອາອີ່ ຕູ່ດ ແຕີ່ອ໌ ປໍ ເຢຊູ. ອັນ ກຼຸ່ ຣາໂກລ ຢັ່ຮ ເມືາງ ເຢຊູ, ກະ ອັນ ປາຍ: \"ຄັນ ໄມ່ ຢໍອ໌ ອີ ປົວ ໂອນ ເກົາ ແກີດ ແບຣັຮ, ເຕ່ອ໌ ໄມ່ ຕະ.\" ");
INSERT INTO ncq_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ເຢຊູ ອາໂຢ່ະ ຕະ ກວາຍ ກັອຍ, ເຈີ່ ອັນ ຊາປ່ະ ອາຕີ ຕຶ່ງ ກວາຍ ກັອຍ, ກະ ອັນ ປາຍ: \"ເກົາ ຢໍອ໌ ອີ ໂອນ ໄມ່ ແກີດ ແບຣັຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ພໍກາ ກັອຍ ກວາຍ ຣາເລົາ ກາ ອາອີ່ ຕູ່ດ, ຈະ ອັນ ແກີດ ແບຣັຮ ອໍ ລັ່ຮ ນ່ະ ຕຍາ. ");
INSERT INTO ncq_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ເຢຊູ ໂອນ ກວາຍ ກັອຍ ເປາະ, ກະ ອັນ ປາຕັບ ດໍອ໌ ກວາຍ ກັອຍ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","\"ອຶນໂຈຍ ອາຕີ ໂອນ ກວາຍ ອາແລ່ະ ດັງ ແຕ ຣານະ ໄນ່. ມາ ໄມ່ ເປາະ ອາປັຮ ຈະ ໄມ່ ໂອນ ກວາຍ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ເນ່. ກະ ໄມ່ ມ່ອບ ຊາງ ໂອນ ເຢືາງ ເຈົາຣາຊີ ມັຮ ຣາມຶ່ຮ ກາ ໂມເຊ ປາຕັບ ແຕ ອຶມແບິ ອາໄຣ່. ໄນ່ ລາ ອາປັຮ ໂອນ ກວາຍ ການໍ່ອ໌ ດັງ ໄມ່ ແບຣັຮ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ມາ ແວັດ ກວາຍ ກັອຍ ລັ່ອຮ ແຕ ກັອຍ, ອັນ ເປາະ ຕະ ອຶນຕີ ແຕ ຣານະ ເຢຊູ ຈ່ອຍ ອັນ. ເຈີ່ ປັຣນາຍ ໄນ່ ດັອຮແດີນ. ຍ່ອນ ນ່ະກັອຍ ຄັນ ເຢຊູ ຢໍອ໌ ອີ ມູ່ດ ຕຶ່ງ ວີ່ລ, ອຶງເຄາະ ອັນ ມູ່ດ ຕວຍ໌ ຕາ ເບີນ ໂອນ ເນົ່າ ເຮີມ ຈະ ອັນ. ອັນ ແອີດ ປໍ ນໍ່ອ໌ ວີ່ລ ຕຶ່ງ ອຶນຕຸ ຕາ ເບີນ ເນົ່າ ແອີດ. ມາ ອຶນນັ່ອງ ເບີນ ກວາຍ ແຕ ຊາອຶ່ຍ ອຶນຕຸ ແຕີ່ອ໌ ປໍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ແວັດ ບາຣ ໄປ ຕາໄງ ເຢຊູ ເຈົາ ລັ່ຮ ປໍ ເມືອງ ກາເປນາອູມ. ພໍກາ ເນົ່າ ຊັອງ ຮານ ປາຍ ອັນ ເຈົາ ແຕີ່ອ໌ ປໍ ດຸງ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ກວາຍ ເປາະ ໂຣ່ມ ປໍ ດຸງ ອັນ ກຼຶ່ງ ລາລື່. ຕຶ່ງ ງັ່ຮ ຕົ່ງ ດຸງ ຕາ ເບີນ ອຶນຕຸ ອີ ມູ່ດ ນັ່ອງ, ອຶນແຍ່ະ ກູທັດ ເຈີ່. ນ່ະກັອຍ ເຢຊູ ອາຕີ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ໂອນ ໄລ່ ຊາງັດ. ");
INSERT INTO ncq_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ເບີນ ຣາເລົາ ປູນ ນະ ກຣາງ ມານະ ກວາຍ ຣາເລົາ ແກີດ ລ່ອຍ, ເດີງ ອາຊວຍ ອັນ ປໍ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ມາ ພໍກາ ໄລ່ ເຮີມ ກຼຶ່ງ ລາລື່ ກວາຍ ແອີດ ເນ່ດ ເຢຊູ, ເຈີ່ ໄລ່ ຕາ ດັງ ຣານາ ແລ່ະ ອີ ມູ່ດ ປໍ ອັນ. ນ່ະກັອຍ ໄລ່ ເປິຮ ຣານາ ຕຳປວລ ດຸງ ຕາປຶ່ງ ເຢຊູ ແອີດ, ອີ ໂຢ່ລ ອາແຊງ ຈຸ່ງຈາງ ກວາຍ ລ່ອຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ເຢຊູ ດັງ ໄລ່ ຊາອຳ ກຣັ່ກ ລາລື່, ນ່ະກັອຍ ອັນ ອາຕີ ກວາຍ ລ່ອຍ ປາຍ: \"ກອນ ເອີຍ! ໂລ່ຍຮ ໄມ່ ເກົາ ຕັຮ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ເບີນ ມັຮ ກວາຍ ກາ ອາຕີ ຄານອດ ຕາກູ ອຶງກັອຍ ເຕ່. ໄລ່ ຄຶ່ດ ຕຶ່ງ ຣາງຶ່ຮ ໄລ່ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","\"ນານ່ະ ກວາຍ ໄນ່ ປາຍ ນ່ະກັອຍ? ຕາ ເບີນ ກວາຍ ອາແລ່ະ ເຕ່ອ໌ ຕັຮ ໂລ່ຍຮ ກວາຍ. ມານະ ເຢືາງ ເຈົາຣາຊີ ແຕິ່ ເຕ່ອ໌ ຕັຮ ໂລ່ຍຮ ກວາຍ. ອັນ ຢໍອ໌ ອີ ເບີນ ອຳນາດ ຣາລີ ກະ ເຢືາງ ເຈົາຣາຊີ ເຕ່, ເຈີ່ ອັນ ຕະ ອຶນຕີ ນ່ະກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ບັອງ ກັອຍ ແຕິ່ ເຢຊູ ດັງ ໄລ່ ຄຶ່ດ ນ່ະກັອຍ ຕຶ່ງ ຣາງຶ່ຮ ໄລ່. ອັນ ອາເບຼິຮ ໄລ່ ປາຍ: \"ນານ່ະ ແຕ ເຍືາ ຄຶ່ດ ນ່ະກັອຍ? ");
INSERT INTO ncq_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ປັຣນາຍ ອາແລ່ະ ກາ ເຍືາ ຊັອງ ອຽນ ກາເລີຍ ເກົາ ອາຕີ ກວາຍ ລ່ອຍ ກັອຍ ປາຍ: 'ໂລ່ຍຮ ໄມ່ ເກົາ ຕັຮ ເຈີ່,' ແຕີລາ 'ໄມ່ ຢວຣ ຕາຢຶ່ງ ເປາະ. ໄມ່ ເດີງ ອາເຈົາ ຈຸ່ງຈາງ ໄມ່.' ");
INSERT INTO ncq_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ມາ ຊານໍ່ ເກົາ ອີ ຕະ ໂອນ ກວາຍ ລ່ອຍ ໄນ່ ແກີດ ແບຣັຮ, ໂອນ ເຍືາ ດັງ ແຈງ ລາລື່ ປາຍ ເກົາ ລາ ກອນ ເຢືາງ ແກີດ ກວາຍ ເບີນ ອຳນາດ ຕຶ່ງ ກູແຕອ໌ ໄນ່. ເກົາ ເຕ່ອ໌ ຕັຮ ໂລ່ຍຮ ກວາຍ.\" ແວັດ ກັອຍ ເຢຊູ ອາຕີ ໂອນ ກວາຍ ລ່ອຍ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","\"ເກົາ ໂອນ ໄມ່ ຢວຣ ຕາຢຶ່ງ; ໄມ່ ໂດລ ອີດ ຈຸ່ງຈາງ ໄມ່, ເຈີ່ ໄມ່ ເຈົາ ລັ່ຮ ປໍ ດຸງ.\" ");
INSERT INTO ncq_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ພໍກາ ກັອຍ ກວາຍ ລ່ອຍ ຢວຣ ຕາຢຶ່ງ, ອັນ ອີດ ແຕິ່ ຈຸ່ງຈາງ ອັນ, ເຈີ່ ອັນ ລັ່ອຮ ແຕ ກວາຍ ກຼຶ່ງ. ພໍກາ ມັຮ ກວາຍ ເຮີມ ຣານະ ກັອຍ, ໄລ່ ຊັອງ ງຶ່ດ ລາລື່, ກະ ໄລ່ ຍ່ອງ ເຢືາງ ເຈົາຣາຊີ. ໄລ່ ປາຍ: \"ໄຮ ຕາ ເກີ່ຍ ເຮີມ ຣານະ ນ່ະໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ແວັດ ກັອຍ ເຢຊູ ເປາະ ລັ່ຮ ຊາ ຕາມ ປຶ່ຮ ທາເລ ຣາປັ່ງ ຄາລີເລ. ເບີນ ກວາຍ ກຼຶ່ງ ລາລື່ ແຕີ່ອ໌ ປໍ ອັນ, ເຈີ່ ອັນ ອາຕີ ໄລ່ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ພໍກາ ອັນ ເປາະ, ອັນ ເຮີມ ເລວີ ກອນ ຣາເລົາ ອາລະພາຍ ແອີດ ຕາກູ ຕະ ຣານະ ຕຶ່ງ ດຸງ ເນົ່າ ຕາໂຣມ ອີດ ປຣະ ປາຊີ. ເຢຊູ ປາຍ ກະ ເລວີ ນ່ະໄນ່: \"ໂອນ ໄມ່ ເປາະ ອາລຶ່ງ ເກົາ.\" ເຈີ່ ເລວີ ຢວຣ ຕາຢຶ່ງ ເປາະ ກະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ພໍກາ ເຢຊູ ເປາະ ຈາ ໂດຍ ຕຶ່ງ ດຸງ ເລວີ, ເບີນ ກຼຶ່ງ ກວາຍ ແອີດ ອຶງກັອຍ ກາ ດຸ ຕາໂຣມ ອີດ ປຣະ ປາຊີ, ກະ ກວາຍ ການໍ່ອ໌ ກາ ຕາ ເບີນ ປວາຍ ຄານອດ ແຮີ ຈາ ອາລຶ່ງ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ, ຍ່ອນ ໄລ່ ເປາະ ກະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ເບີນ ກວາຍ ອາຕີ ຄານອດ ແຕ ຈຸ່ມ ພາຣີຊາຍ ເຮີມ ເຢຊູ ຈາ ໂດຍ ກະ ກວາຍ ຕາໂຣມ ອີດ ປຣະ ປາຊີ ກະ ກວາຍ ກາ ຕາ ເບີນ ເດີງ ຣີ່ດ. ກວາຍ ອາຕີ ຄານອດ ອາເບຼິຮ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ປາຍ: \"ນານ່ະ ອັນ ກັອຍ ຈາ ກະ ກວາຍ ກາ ອີດ ປຣະ ປາຊີ ກະ ກວາຍ ໂລ່ຍຮ ການໍ່ອ໌ ແຮີ?\" ");
INSERT INTO ncq_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ພໍກາ ເຢຊູ ຊັອງ ໄລ່ ກັອຍ ປາຍ ນ່ະກັອຍ, ເຈີ່ ອັນ ອາຕີ ໄລ່ ປາຍ: \"ກວາຍ ບັນ ເຣ່ງ ອໍ ຕາ ເບີນ ເປາະ ແຊອ໌ ໂອນ ເນົ່າ ປົວ. ມາ ແອີງ ກວາຍ ອາອີ່ ຊັອງ ເປາະ ແຊອ໌ ໂອນ ເນົ່າ ປົວ. ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່ ເກົາ ຕາ ເບີນ ກູອ໌ ກວາຍ ກາ ຕານັ່ອງ ອໍ. ມາ ເກົາ ກູອ໌ ກວາຍ ກາ ເບີນ ໂລ່ຍຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ມັຮ ມູ່ ກາ ຣຍານ ແຕ ໂຢຮັນ ກະ ມັຮ ກວາຍ ພາຣີຊາຍ, ໄລ່ ດຸ ຣຽຮ ຕາໄງ ດໍອ໌ ຕະ ຣີ່ດ ອົດ ຊັຣນາ. ເບີນ ກວາຍ ແຕີ່ອ໌ ອາເບຼິຮ ເຢຊູ ປາຍ: \"ມູ່ ກາ ຣຍານ ແຕ ໂຢຮັນ ກະ ມູ່ ກາ ຣຍານ ແຕ ພາຣີຊາຍ ໄລ່ ເດີງ ຣີ່ດ ອົດ ຊັຣນາ. ນານ່ະ ມູ່ ກາ ຣຍານ ແຕ ໄມ່ ຕາ ເບີນ ຕະ ນ່ະ ໄລ່ ກັອຍ ເຕ່?\" ");
INSERT INTO ncq_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ເຢຊູ ຕາແອີຍ ລັ່ຮ ໄລ່ ປາຍ: \"ບັອງ ກາ ປັຣລົວະ ແຈ່ະ ອີ ອີດ ລາກວຍ, ມັຮ ເຢົ່າ ກາ ແອີດ ກະ ອັນ ໄລ່ ຕາ ເຕ່ອ໌ ອົດ ຊັຣນາ. ");
INSERT INTO ncq_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ມາ ພໍກາ ແຕີ່ອ໌ ຕາໄງ ປັຣລົວະ ກັອຍ ຕາ ເບີນ ແອີດ ນັ່ອງ ກະ ເຢົ່າ ອັນ, ຕາໄງ ກັອຍ ໄລ່ ອີ ອົດ ຊັຣນາ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","\"ຕາ ເບີນ ກວາຍ ອາແລ່ະ ອີດ ອາຣົ່ຮ ຕາໄມ ເຈີ່ ທາບ ໂຈະ ອາຢັ່ອຮ ຕຍາ. ຄັນ ອາຣົ່ຮ ຕາໄມ ກັອຍ ຣາຮົດ, ອັນ ອີ ຕະ ໂອນ ອາຢັ່ອຮ ກັອຍ ຣາແຮອ໌ ຕາວັ່ຮ ອຶງກວາ ຕຍາ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ກະ ຕາ ເບີນ ກວາຍ ອາແລ່ະ ອີດ ບຼັອງ ຕາໄມ ມາ ຕຣອງ ໂຈະ ຕຶ່ງ ຕູຍ ອຶງກັຣ ຕຍາ. ຄັນ ເນົ່າ ຕະ ນ່ະກັອຍ, ບຼັອງ ຕາໄມ ອັນ ອີ ຕະ ໂອນ ຕູຍ ອຶງກັຣ ຕຍາ ແກີດ ປັຣອາອ໌. ອຶງເຄາະ ອີດ ບຼັອງ ຕາໄມ ໂຈະ ຕຶ່ງ ຕູຍ ອຶງກັຣ ຕາໄມ.\" ");
INSERT INTO ncq_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ຕຶ່ງ ຕາໄງ ຣາລູ່ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ຕາຢັຮ ພາ ອຶນດີ ຕົ່ງ ໄທຣ. ບັອງ ກາ ໄລ່ ຕາຢັຮ ຕຶ່ງ ຣານາ ກັອຍ, ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ກິດ ອີດ ຣາກົ່ງ ໂດຍ ອຶງກຣິ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ຈຸ່ມ ພາຣີຊາຍ ປາຍ ໂຈະ ເຢຊູ: \"ນານ່ະ ມູ່ ກາ ຣຍານ ແຕ ໄມ່ ຕາ ເບີນ ຊາງັດ ຄານອດ ກາ ຕາ ໂອນ ຕະ ຣານະ ຕຶ່ງ ຕາໄງ ຣາລູ່?\" ");
INSERT INTO ncq_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ເຍືາ ຕາ ເກີ່ຍ ອານ ບໍ ຣານະ ດາວິດ ກະ ຈຸ່ມ ອັນ ຕະ, ບັອງ ໄລ່ ມາເຍືາຍຮ ກະ ແອິ ໂດຍ? ");
INSERT INTO ncq_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ບັອງ ກັອຍ ອາບີອາທາ ແກີດ ອັນ ກາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ. ດາວິດ ມູ່ດ ຕຶ່ງ ດຸງ ຊາງ ເຢືາງ ເຈົາຣາຊີ. ອັນ ຈາ ໂດຍ ບຸຮ ກາ ກວາຍ ມ່ອບ ໂອນ ເຢືາງ ເຈົາຣາຊີ, ກະ ອັນ ໂອນ ຈຸ່ມ ອັນ ຈາ ເຕ່. ຕາປູ່ນ ຕາມ ຄານອດ ໄຮ ລາ ແອີງ ກວາຍ ຊາງ ຣີ່ດ ຊັອງ ເຕ່ອ໌ ຈາ ໂດຍ ບຸຮ ກັອຍ. ມາ ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ຕິ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ເຢຊູ ອາຕີ ລັ່ຮ ໄລ່ ປາຍ: \"ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ແຕງ ຕາໄງ ຣາລູ່ ມາ ໂອນ ກວາຍ ຢຳນັ່ບ ຕາໄງ ກັອຍ, ມາ ອັນ ແຕງ ຕາໄງ ຣາລູ່ ລາ ຢໍອ໌ ອີ ຈ່ອຍ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ນ່ະກັອຍ ເຕ່ ກອນ ເຢືາງ ແກີດ ກວາຍ, ອັນ ອຶນເຈົາ ຕາໄງ ຣາລູ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ແວັດ ກັອຍ ເຢຊູ ມູ່ດ ລັ່ຮ ຕຶ່ງ ດຸງ ຊາງ ຈຸ່ມ ອິດຊະຣາເອລ. ຕຶ່ງ ດຸງ ຊາງ ກັອຍ ເບີນ ມານະ ຣາເລົາ ຣາກຸ ອາຕີ. ");
INSERT INTO ncq_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ມາ ເບີນ ກວາຍ ກາ ແອີດ ອຶງກັອຍ ຈ່ອມ ເນ່ ເຢຊູ, ອັນ ອີ ປົວ ກວາຍ ກັອຍ ຕຶ່ງ ຕາໄງ ຣາລູ່ ມາ ຕາ ເບີນ. ໄລ່ ຈໍ່ອ໌ ຣານະ ໂລ່ຍຮ ແຕ ເຢຊູ ໂອນ ເຕ່ອ໌ ໄລ່ ປ່ອງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ເຢຊູ ປາຍ ໂຈະ ກວາຍ ກາ ຣາກຸ ອາຕີ ກັອຍ: \"ໄມ່ ຢວຣ ຕາຢຶ່ງ ຢັ່ຮ ເມືາງ ກວາຍ ກຼຶ່ງ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ເຈີ່ ເຢຊູ ອາເບຼິຮ ໄລ່ ປາຍ: \"ຕຶ່ງ ຕາໄງ ຣາລູ່, ຄານອດ ໄຮ ໂອນ ຕະ ນານ່ະ? ໄຮ ອີ ຕະ ອໍ ມາ ໄຮ ອີ ຕະ ຕາ ອໍ? ໄຮ ອີ ຈ່ອຍ ໂອນ ກວາຍ ອາມົ່ງ, ມາ ໄຮ ອີ ກາຈີດ ກວາຍ?\" ມາ ໄລ່ ແອີດ ຣາອຍາບ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ເຢຊູ ກູລຽວ ເນ່ ປໍ ໄລ່, ກະ ອັນ ຊັອງ ອຶງຄື່ນ. ອັນ ຊັອງ ຕຸ່ຮ ລາລື່, ຍ່ອນ ຣາງຶ່ຮ ໄລ່ ຕາ ເບີນ ຊາງັດ. ເຢຊູ ອາຕີ ກວາຍ ກາ ຣາກຸ ອາຕີ ປາຍ: \"ໄມ່ ອາລັ່ອຮ ອາຕີ ໄມ່!\" ພໍກາ ກວາຍ ກັອຍ ອາລັ່ອຮ ອາຕີ ອັນ, ເຈີ່ ອາຕີ ອັນ ປຣາຍ ອໍ ລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ຈຸ່ມ ພາຣີຊາຍ ລັ່ອຮ ແຕ ດຸງ ໂຣ່ມ ກັອຍ. ໄລ່ ເປາະ ຣາມົຮ ຈຸ່ມ ເຮໂຣດ, ເຈີ່ ໄລ່ ກັອຍ ຊັຣຮົງ ອີ ຕະ ນານ່ະ ອີ ກາຈີດ ຕັຮ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","ເຢຊູ ເດີງ ມູ່ ກາ ຣຍານ ແຕ ອັນ ລັ່ອຮ ເປາະ ອຶມແປຣ ປຶ່ຮ ທາເລ ຣາປັ່ງ ຄາລີເລ. ເບີນ ມັຮ ກອນແຊມ ກຼຶ່ງ ນະ ແຕ ແຄງ ຄາລີເລ ກະ ແຄງ ຢູດາຍ ຣາປວາຍ ເນ່ ເຢຊູ. ເບີນ ກວາຍ ແຕີ່ອ໌ ແຕ ເມືອງ ເຢຣູຊາເລັມ, ແຕ ກຣວາງ ອີດູມາຍ, ກະ ກຣວາງ ຢັ່ຮ ອຶນຕົ່ຮ ຕາເລ່ ຈໍແດນ. ເບີນ ກວາຍ ແຕ ກຣວາງ ອຶມແປຣ ເມືອງ ຕີເຣ ກະ ເມືອງ ຊີໂດນ ແຮີ. ໄລ່ ແຕີ່ອ໌ ປໍ ເຢຊູ ຍ່ອນ ໄລ່ ຊັອງ ມັຮ ຣານະ ກາ ອັນ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ເຢຊູ ແປຣີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ໂອນ ເປາະ ອີດ ຕົວະ ແກດ ແຕີ່ອ໌ ຣັ່ບ ອັນ ກະ ຕາ ໂອນ ກວາຍ ກຼຶ່ງ ກັອຍ ຣາເນ່ດ ຈະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ກວາຍ ຕິ່ ອາອີ່ ອີ ເນ່ດ ຊາປ່ະ ຈະ ອັນ ຍ່ອນ ເຢຊູ ປົວ ກຼຶ່ງ ກວາຍ ກາ ຕິ່ ອາອີ່. ");
INSERT INTO ncq_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ພໍກາ ເຢືາງ ຕາ ອໍ ເຮີມ ເຢຊູ, ໄລ່ ແດິມ ຢັ່ຮ ເມືາງ ເຢຊູ, ເຈີ່ ໄລ່ ປາຍ: \"ໄມ່ ລາ ກອນ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ມາ ເຢຊູ ປາຕັບ ເຢືາງ ຕາ ອໍ ກັອຍ, ຕາ ໂອນ ໄລ່ ອາຕີ ໂອນ ກວາຍ ການໍ່ອ໌ ດັງ ປາຍ ອັນ ລາ ກອນ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ເຢຊູ ຊັອຮ ປໍ ກົຮ, ເຈີ່ ອັນ ກູອ໌ ອີດ ກວາຍ ກາ ອັນ ອີ ຣຽຮ ໂອນ ແຕີ່ອ໌ ປໍ ອັນ. ເຈີ່ ໄລ່ ກັອຍ ແຕີ່ອ໌ ປໍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ອັນ ຣຽຮ ອີດ ມັນຈິ່ດ ລາ ບາຣ ນະ, ກະ ອັນ ດໍອ໌ ໄລ່ ກັອຍ ລາ ກວາຍ ກາ ອັນ ປາຈຸ່ຮ ໂອນ ເປາະ ຕະ ຣານະ ອັນ. ເຢຊູ ອາຕີ ໄລ່ ປາຍ: \"ເກົາ ຣຽຮ ອີດ ເຍືາ ໂອນ ແອີດ ອາລຶ່ງ ເກົາ, ກະ ໂອນ ເຍືາ ເປາະ ອາຕີ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ອັນ ໂອນ ມູ່ ກັອຍ ເບີນ ອຳນາດ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ມັນຈິ່ດ ລາ ບາຣ ນະ ກາ ເຢຊູ ຣຽຮ ເບີນ ຣາມຶ່ຮ ນ່ະໄນ່: ຊີໂມນ ກາ ເຢຊູ ຈົຮ ຣາມຶ່ຮ ເປໂຕ, ");
INSERT INTO ncq_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ຢາໂກໂບ ກະ ໂຢຮັນ. ໂຢຮັນ ລາ ອາແອມ ຢາໂກໂບ. ໄລ່ ບາຣ ນະ ລາ ກອນ ເຊເບດາຍ. ເຢຊູ ຈົຮ ຣາມຶ່ຮ ຕາໄມ ໂອນ ໄລ່ ບາຣ ນະ ກັອຍ ລາ ໂບອະເນເຄ, ຕະ ອຶນຕີ ລັ່ຮ ລາ 'ກອນ ກຣຶ່ມ.' ");
INSERT INTO ncq_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ອັນ ກູອ໌ ອັນເດອາ, ພີລິບ, ບາຣໂທໂລມາຍ, ມັດທາຍ, ໂທມາ, ຢາໂກໂບ ກອນ ຣາເລົາ ອາລະພາຍ, ທາດາຍ, ຊີໂມນ ເຊໂລເຕ, ");
INSERT INTO ncq_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ກະ ຢູດາ ອິດຊະກາຣີອົດ, ອັນ ກາ ຈິ ໂອນ ເນົ່າ ກາຈີດ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ແວັດ ກັອຍ ເຢຊູ ເຈົາ ລັ່ຮ ປໍ ດຸງ. ເຈີ່ ກຼຶ່ງ ລາລື່ ກວາຍ ເປາະ ໂຣ່ມ ລັ່ຮ ປໍ ເຢຊູ, ເຕົ່າ ກູທັດ ດຸງ. ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ຕາ ດັງ ເບີນ ຈາ ໂດຍ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ພໍກາ ອຶມເປ່ອ໌ ກະ ອາແອມ ເຢຊູ ຊັອງ ແຕ ຣານະ ໄນ່, ໄລ່ ຢໍອ໌ ອີ ອາລັ່ອຮ ເຢຊູ ແຕ ກວາຍ ກຼຶ່ງ ກັອຍ, ຍ່ອນ ໄລ່ ຊັອງ ເນົ່າ ຕະ ອຶນຕີ ປາຍ: \"ອຶງກັອຮ ອັນ ແກີດ ກວາຍ ຢຸ່ຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ເບີນ ຈຸ່ມ ກວາຍ ອາຕີ ຄານອດ ແຊງ ແຕ ເມືອງ ເຢຣູຊາເລັມ. ໄລ່ ປາຍ: \"ກວາຍ ໄນ່ ເຢືາງ ເບເອລເຊບູລ ຕຣວບ ອັນ ເຈີ່. ກະ ອັນ ເຕ່ອ໌ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ຍ່ອນ ເຢືາງ ກາ ຊົດ ອຶນແຍ່ະ ເຢືາງ ຕາ ອໍ ໂອນ ອັນ ເບີນ ອຳນາດ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ເຈີ່ ເຢຊູ ກູອ໌ ກວາຍ ອາຕີ ຄານອດ ໂອນ ແຕີ່ອ໌ ປໍ ອັນ. ອັນ ອາຕີ ໄລ່ ແຕ ປັຣນາຍ ຊາກຳ ປາຍ: \"ເຢືາງ ຊາຕານ ອີ ຕະ ຈຸ່ມ ອັນ ເບີມ ເບີນ ບໍ? ");
INSERT INTO ncq_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ຄັນ ເບີນ ມວຍ ກຣວາງ ມາ ອຶມແປອ໌ ແກີດ ຊາອຶ່ຍ ຈຸ່ມ ມານະ ຣາຕະ ໂຈະ ມານະ, ເຈີ່ ກຣວາງ ກັອຍ ຕາ ເບີນ ແກີດ ນັ່ອງ ກຣວາງ. ");
INSERT INTO ncq_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ຄັນ ກວາຍ ຕຶ່ງ ດຸງຊູ ມາ ມານະ ຣາຕະ ໂຈະ ມານະ, ເຈີ່ ດຸງ ກັອຍ ລາ ຕາ ເບີນ ແກີດ ນັ່ອງ ດຸງ. ");
INSERT INTO ncq_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ຄັນ ເຢືາງ ຊາຕານ ຣາຕະ ກະ ຈຸ່ມ ອັນ ເບີມ ກະ ຕະ ໂອນ ຈຸ່ມ ອັນ ຣາຕັຮ ອຶນແຍ່ະ, ຕາ ເບີນ ແກີດ ຈຸ່ມ ນັ່ອງ. ແກີດ ປິ່ດ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","\"ຕາ ເບີນ ອາແລ່ະ ເຕ່ອ໌ ມູ່ດ ປົນ ຕຶ່ງ ດຸງ ກວາຍ ບັນ ເຣ່ງ, ຄັນ ຕາ ເບີນ ຊັດ ດໍອ໌ ກວາຍ ກັອຍ ອຶນໂຍ່ງ. ອຶງເຄາະ ຊັດ ດໍອ໌ ກວາຍ ກັອຍ ເວືາຍ ແຕ ເຕ່ອ໌ ມູ່ດ ປົນ ອີດ ເກຣີ່ງ ຕຶ່ງ ດຸງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","\"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ກູ່ ຣານະ ໂລ່ຍຮ ກວາຍ ຕະ, ກະ ກູ່ ຣາມຶ່ຮ ກວາຍ ດຸ ພາມາດ, ເຕ່ອ໌ ເຢືາງ ເຈົາຣາຊີ ຕັຮ ໂລ່ຍຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ມາ ຄັນ ກວາຍ ອາແລ່ະ ມາ ພາມາດ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ, ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ຕັຮ ໂລ່ຍຮ ກັອຍ. ກະ ອັນ ເບີນ ໂລ່ຍຮ ເຕົ່າ ຊົດ ອຶນແຍ່ະ ແດີຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ເຢຊູ ອາຕີ ປາຍ ນ່ະກັອຍ ລາ ຍ່ອນ ໄລ່ ກັອຍ ປາຍ: \"ເບີນ ເຢືາງ ຕາ ອໍ ຕຣວບ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ເຈີ່ ອຶມເປ່ອ໌ ກະ ອາແອມ ເຢຊູ ໄລ່ ຕາຢຶ່ງ ຢັ່ຮ ນໍ່ອ໌ ດຸງ. ໄລ່ ແປຣີ ກວາຍ ເປາະ ກູອ໌ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ເບີນ ກວາຍ ກຼຶ່ງ ລາລື່ ຕາກູ ຣ່ອບ ເຢຊູ. ໄລ່ ກັອຍ ອາຕີ ປາຍ: \"ອຶມເປ່ອ໌ ກະ ອາແອມ ໄມ່ ແອີດ ຢັ່ຮ ນໍ່ອ໌. ໄລ່ ຢໍອ໌ ອີ ຣາມົຮ ໄມ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ມາ ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ເນົ່າ ແກີດ ອຶມເປ່ອ໌ ເກົາ ກະ ອາແອມ ເກົາ?\" ");
INSERT INTO ncq_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ເຈີ່ ເຢຊູ ກູລຍານ ເນ່ ກວາຍ ກາ ຕາກູ ຣ່ອບ ອັນ. ເຢຊູ ອາຕີ ປາຍ: \"ໄນ່ ລາ ອຶມເປ່ອ໌ ກະ ອາແອມ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ອາແລ່ະ ລາ ໂທຍ ກາ ຊາງັດ ກະ ຕະ ປວາຍ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ໄລ່ ກັອຍ ລາ ແຊມອາຍ ແຊມແອີຍ ກະ ອຶມເປ່ອ໌ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ເຢຊູ ຕາແບິ ອາຕີ ກວາຍ ຕຶ່ງ ອຶມແປຣ ທາເລ ຣາປັ່ງ ຄາລີເລ. ກຼຶ່ງ ລາລື່ ກວາຍ ແຕີ່ອ໌ ປໍ ອັນ. ເຢຊູ ຊັອຮ ຕາກູ ຕຶ່ງ ຕົວະ, ແອີດ ແຈ່ະ ປຶ່ຮ ທາເລ. ເບີນ ຊາອຶ່ຍ ນະ ກວາຍ ແອີດ ຊາງັດ ອຶມແປຣ ປຶ່ຮ ທາເລ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ເຢຊູ ອາຕີ ໄລ່ ກັອຍ ຊາອຶ່ຍ ປັຣນາຍ ຊາກຳ. ອັນ ອາຕີ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","\"ໂອນ ເຍືາ ຊາງັດ ເວືາຍ, ເບີນ ມານະ ກວາຍ ເປາະ ຕຣຶ່ຮ ກູປຼູອ໌. ");
INSERT INTO ncq_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ພໍກາ ອັນ ຕຣຶ່ຮ, ເບີນ ກຼອງ ກາ ຊາແລັຮ ຕຶ່ງ ຣານາ, ເຈີ່ ແຈມ ແຊງ ຕອດ ຈາ ກຼອງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ເບີນ ກຼອງ ກາ ຊາແລັຮ ຕຶ່ງ ກູແຕອ໌ ກາດາ, ປື່ນ ກູແຕອ໌ ເບີນ ແອີງ ຕາຕາຣ. ເຈີ່ ໄວ່ ລາລື່ ກຼອງ ກັອຍ ດັຮ, ຍ່ອນ ກູແຕອ໌ ຕາ ເບີນ ອຶນຕຣູ່. ");
INSERT INTO ncq_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ພໍກາ ມານາງ ຈັຮ ພວາອ໌ ເຣ່ງ ລາລື່, ຊັຣນົຮ ກັອຍ ແກີດ ຣັ່ອຮ, ຍ່ອນ ເຣ່ຮ ອັນ ຕາ ເບີນ ອຶນຕຣູ່. ອັນ ຣັ່ອຮ, ເຈີ່ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ມາ ເບີນ ກຼອງ ກາ ຊາແລັຮ ຕຶ່ງ ກູແຕອ໌ ກາ ເບີນ ເຣ່ຮ ຊັຣເລືາ. ພໍກາ ຊັຣເລືາ ກັອຍ ປື່ດ, ອັນ ຣິ່ ດໍອ໌ ຊັຣນົຮ ກາ ຕາແບິ ດັຮ ແຕ ກຼອງ ກວາຍ ກັອຍ ຕຣຶ່ຮ. ເຈີ່ ກັ່ລ ຊັຣນົຮ ກັອຍ ຕາ ແກີດ ປາໄລ. ");
INSERT INTO ncq_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ເບີນ ມັຮ ກຼອງ ກາ ຊາແລັຮ ຕຶ່ງ ກູແຕອ໌ ອໍ; ກຼອງ ກັອຍ ດັຮ ອໍ; ກັ່ລ ອັນ ແກີດ ປາໄລ ອໍ; ມວຍ ກຼອງ, ອັນ ກາ ແກີດ ໄປ ຈິ່ດ ກຼອງ, ອັນ ກາ ແກີດ ຕາປັ່ດ ຈິ່ດ ກຼອງ, ອັນ ກາ ແກີດ ມູ ຣ່ອຍ ກຼອງ.\" ");
INSERT INTO ncq_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ເຢຊູ ປາຍ: \"ອາແລ່ະ ກາ ເບີນ ກູຕູຣ, ໂອນ ອັນ ຊາງັດ ເບີມ.\" ");
INSERT INTO ncq_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ພໍກາ ເຢຊູ ແອີດ ມານະ ອັນ, ເຈີ່ ມວຍ ຈິ່ດ ລາ ບາຣ ນະ ກາ ຣຍານ ແຕ ອັນ, ກະ ມັຮ ກວາຍ ກາ ແອີດ ອຶມແປຣ ອັນ, ໄລ່ ອາເບຼິຮ ແຕ ປັຣນາຍ ຊາກຳ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ເຢືາງ ເຈົາຣາຊີ ໂອນ ເຍືາ ດັງ ແຈງ ເຈີ່, ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ມັຮ ຣາງຶ່ຮ ກວາຍ. ມາ ກວາຍ ການໍ່ອ໌ ເກົາ ອາຕີ ແຕ ປັຣນາຍ ຊາກຳ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ເກົາ ຕະ ນ່ະໄນ່: 'ໂອນ ໄລ່ ເນ່ ເລືອຍໆ, ມາ ໄລ່ ຕາ ເບີນ ເຮີມ; ໄລ່ ຊາງັດ ເລືອຍໆ, ມາ ໄລ່ ຕາ ເບີນ ຊາປຸ່ຮ. ຄັນ ໄລ່ ເຮີມ ກະ ໄລ່ ຊາປຸ່ຮ, ເຈີ່ ໄລ່ ເຈົາ ລັ່ຮ ປໍ ເຢືາງ ເຈົາຣາຊີ, ເຈີ່ ເຢືາງ ເຈົາຣາຊີ ຕັຮ ໂລ່ຍຮ ໂອນ ໄລ່.\"' ");
INSERT INTO ncq_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ເຢຊູ ອາເບຼິຮ ໄລ່ ປາຍ: \"ມູ່ ເຍືາ ຕາ ຢວາຮ ດັງ ປັຣນາຍ ຊາກຳ ໄນ່ ບໍ? ນານ່ະ ເຕ່ອ໌ ເຍືາ ອີ ດັງ ປັຣນາຍ ຊາກຳ ການໍ່ອ໌? ");
INSERT INTO ncq_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ກວາຍ ກາ ຕຣຶ່ຮ ກູປຼູອ໌ ກັອຍ, ລາ ອັນ ກາ ຕຣຶ່ຮ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ກຼອງ ກາ ຊາແລັຮ ຕຶ່ງ ຣານາ, ລາ ກວາຍ ກາ ຊັອງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ. ເຈີ່ ເຢືາງ ຊາຕານ ເຣືາດ ອີດ ອຶນແຍ່ະ ປັຣນາຍ ໄລ່ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ກຼອງ ກາ ຊາແລັຮ ອາແຊງ ຕຶ່ງ ກູແຕອ໌ ກາດາ ເບີນ ຕາຕາຣ ປື່ນ ກູແຕອ໌, ລາ ນ່ະ ມູ່ ກາ ຊັອງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ເຈີ່ ໄລ່ ຊັອງ ຣໍ່ອ໌ ອີດ ດໍອ໌ ອຶນແຍ່ະ ຣາງຶ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ພໍກາ ແຕີ່ອ໌ ຕຸ່ຮ ກັ່ດ ກະ ເນົ່າ ໄຄອ໌ ເຣ່ງ ຍ່ອນ ໄລ່ ຊາອຳ ເຢືາງ ເຈົາຣາຊີ, ເຈີ່ ໄລ່ ຕັຮ ແຕິ່, ຍ່ອນ ໄລ່ ແອິ ເຣ່ຮ ອຶນຕຣູ່ ກະ ຕາ ເຣືາບ ອົດ ດູ່ນ. ");
INSERT INTO ncq_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ກຼອງ ກາ ຊາແລັຮ ຕຶ່ງ ກູແຕອ໌ ເບີນ ຊັຣເລືາ, ລາ ນ່ະ ກວາຍ ກາ ຊັອງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ");
INSERT INTO ncq_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ມາ ໄລ່ ອຶນເນີ່ມ ຄຶ່ດ ແຕ ຣາງຶ່ຮ ຕຶ່ງ ແດີຍ ໄນ່ ກະ ໄລ່ ຢໍອ໌ ອີ ຊຸ ອີ ເບີນ. ຣາບູລ ໄລ່ ຄຶ່ດ ກູ່ ຣາມຶ່ຮ ມັຮ ກາ ໄລ່ ອີ ເບີນ. ເກຣີ່ງ ກັອຍ ຣິ່ ດໍອ໌ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ກາ ໄລ່ ຊັອງ. ເຈີ່ ປັຣນາຍ ກັອຍ ຕາ ເບີນ ແກີດ ເກືາ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ກຼອງ ກາ ຊາແລັຮ ຕຶ່ງ ກູແຕອ໌ ອໍ ກັອຍ, ລາ ນ່ະ ໄລ່ ກາ ຊັອງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ເຈີ່ ໄລ່ ຣັ່ບ ອີດ ດໍອ໌, ເຈີ່ ອັນ ກາ ແກີດ ປາໄລ ໄປ ຈິ່ດ, ອັນ ກາ ແກີດ ປາໄລ ຕາປັ່ດ ຈິ່ດ, ອັນ ກາ ແກີດ ປາໄລ ມູ ຣ່ອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ເຈີ່ ເຢຊູ ອາຕີ ປາຍ: \"ຕາ ເບີນ ກວາຍ ອາແລ່ະ ຕາກັດ ຕາກຍາງ ເຈີ່ ກຣວາອ໌ ໂຈະ ກາເຣຍ ແຕີລາ ດໍອ໌ ປື່ນ ກາເຈີ່ງ ບິ. ມາ ເນົ່າ ດໍອ໌ ຕຶ່ງ ໂຣ່ງ ຕາກຍາງ. ");
INSERT INTO ncq_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ກູ່ ຣາມຶ່ຮ ກາ ກວາຍ ປາໂຕ່ະ ດໍອ໌, ເຈີ່ ປໍ ເມືາງ ແກີດ ອຶມປັຮ ເຮີມ ອຶນແຍ່ະ; ປັຣນາຍ ອຶນເຕົ່າ ກາ ແກຣ່ະ, ເຈີ່ ປໍ ເມືາງ ເນົ່າ ອາລັ່ອຮ ໂອນ ດັງ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ອາແລ່ະ ກາ ເບີນ ກູຕູຣ, ໂອນ ອັນ ຊາງັດ ເບີມ.\" ");
INSERT INTO ncq_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ເຢຊູ ອາຕີ ໄລ່ ປາຍ: \"ອຶງເຄາະ ເຍືາ ຊາງັດ ໂອນ ອໍ ມັຮ ປັຣນາຍ ເຍືາ ຊັອງ. ມາແລ່ະ ຊາອຶ່ຍ ເຍືາ ຢໍອ໌ ອີ ຊາງັດ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ເຢືາງ ເຈົາຣາຊີ ໂອນ ເຍືາ ດັງ ລັ່ຮ ມາຮ ກັອຍ ເຕ່. ກະ ອັນ ໂອນ ຊາອຶ່ຍ ກາເລີຍ ແຕ ຕຍາ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ກວາຍ ອາແລ່ະ ກາ ເບີນ ເຈີ່, ແຮງ ເກົາ ໂອນ ກວາຍ ກັອຍ ເບີນ ຊາອຶ່ຍ ລາລື່ ແອັນ, ມາ ກວາຍ ກາ ຕາ ເບີນ ເບີນ, ແຮງ ເກົາ ອີດ ລັ່ຮ ອຶນແຍ່ະ ແຕ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ເຢຊູ ອາຕີ ແອັນ ປາຍ: \"ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ຕຶ່ງ ຣາງຶ່ຮ ກວາຍ ລາ ນ່ະ ຣາເລົາ ກາ ຕຣຶ່ຮ ກູປຼູອ໌ ຕຶ່ງ ກູແຕອ໌. ");
INSERT INTO ncq_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ຣາເລົາ ກັອຍ ຊາເດົາ ອັນ ບິ, ຕາໄງ ອັນ ຕາແມີ. ເຈີ່ ກູປຼູອ໌ ກັອຍ ດັຮ ແກີດ ປື່ດ ອາຊັອຮ, ມາ ອັນ ຕາ ເບີນ ດັງ ນານ່ະ ກູປຼູອ໌ ແກີດ ນ່ະກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ຍ່ອນ ກູແຕອ໌ ອາເມືາ ໂອນ ກູປຼູອ໌ ດັຮ ອາຊັອຮ ອໍ, ເຈີ່ ແກີດ ກັ່ລ ອຶນຍ່ອມ. ກັ່ລ ອຶນຍ່ອມ ປາດັອຮ ອາລັ່ອຮ ແກີດ ເວືາງ. ເຈີ່ ກັ່ລ ກັອຍ ແກີດ ຣາກົ່ງ ກະ ເບີນ ກຼອງ ຈອງ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ພໍກາ ຊັຣນົຮ ຈີນ, ເຈີ່ ກວາຍ ກັອຍ ໂອນ ກວາຍ ທູແທ ຣິ່ ແຕິ່, ຍ່ອນ ແຕີ່ອ໌ ປາເນ່ນ ຣິ່ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ເຢຊູ ປາຍ: \"ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ຕຶ່ງ ຣາງຶ່ຮ ກວາຍ ລາ ນ່ະ ອຶນເຕົ່າ? ນານ່ະ ໄຮ ອີ ຊາກຳ ໂອນ ເນົ່າ ດັງ ແຕ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ຕຶ່ງ ຣາງຶ່ຮ ກວາຍ? ");
INSERT INTO ncq_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ລາ ນ່ະ ມູ ກຼອງ ປາກາດ ເນົ່າ ຕຣຶ່ຮ ຕຶ່ງ ກູແຕອ໌. ກຼອງ ກັອຍ ລາ ແກດ ກາເລີຍ ແຕ ກຼອງ ການໍ່ອ໌ ຕຶ່ງ ກຣວາງ ກູແຕອ໌ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ພໍກາ ຕຣຶ່ຮ ຕຶ່ງ ກູແຕອ໌, ເຈີ່ ອັນ ດັຮ ອາຊັອຮ ປື່ດ ກາເລີຍ ບັດ ການໍ່ອ໌, ກະ ອັນ ໄບອ໌ ແກີດ ອຶງເກືາອ໌ ເຈີ່ ປຼົວ ແກີດ ອາແບງ ປື່ດ; ເຕ່ອ໌ ແຈມ ຕະ ຊົຮ ຕຶ່ງ ອາແບງ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ເຢຊູ ອາຕີ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ໂອນ ກວາຍ ແຕ ປັຣນາຍ ຊາກຳ; ມາຮ ແລ່ະ ໄລ່ ເຕ່ອ໌ ຊາປຸ່ຮ, ອັນ ອາຕີ ມາຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ເຢຊູ ອາຕີ ໂຈະ ກວາຍ ກຼຶ່ງ ແອີງ ປັຣນາຍ ຊາກຳ ຊັອງ, ແຕ ບັອງ ກາ ອັນ ແອີດ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ, ອັນ ຕະ ອຶນຕີ ລັ່ຮ ປັຣນາຍ ຊາກຳ ໂອນ ໄລ່ ດັງ ອຶນແຍ່ະ ກູ່ ຣາມຶ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ແຕີ່ອ໌ ມານາງ ຕາບື່ ຕາໄງ ກັອຍ, ເຢຊູ ອາຕີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ໄຮ ໄກ່ອ໌໌ ຢັ່ຮ ອຶນຕົ່ຮ ທາເລ ຣາປັ່ງ ແອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ເຈີ່ ໄລ່ ລັ່ອຮ ແຕ ກວາຍ ກຼຶ່ງ ຊັອຮ ຕຶ່ງ ຕົວະ ກາ ເຢຊູ ແອີດ ເຈີ່. ໄລ່ ເດີງ ເຢຊູ ເປາະ. ກະ ເບີນ ຕົວະ ການໍ່ອ໌ ແຮີ ເປາະ ມູ ເປຣິຮ. ");
INSERT INTO ncq_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ແວັດ ກັອຍ ແກີດ ກູຢາລ ຣາປູ່ອ໌ ເຣ່ງ ອາຊັອຮ ຕະ ໂອນ ແດີອ໌ ປ່ອງ ກັຣຊາຍ໌ ອາມູ່ດ ຕຶ່ງ ຕົວະ. ຕົວະ ໄລ່ ແຈ່ະ ອີ ລັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ເຢຊູ ອຶນນັ່ອງ ບິ ຕາໂກລ ຣາໂນລ ແອີດ ຢັ່ຮ ເຕຣືາຍ ຕົວະ. ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ແຕີ່ອ໌ ອາໄມ່ຮ ອັນ. ເຈີ່ ໄລ່ ປາຍ: \"ອາຈານ ເອີຍ! ໄມ່ ຕາ ເບີນ ຣາບູລ ບໍ, ໄຮ ແຈ່ະ ອີ ກູຈີດ ເອີຍ໌?\" ");
INSERT INTO ncq_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ເຢຊູ ຢວຣ ຕາຢຶ່ງ ກາແອັຮ ກູຢາລ, ກະ ອັນ ອາຕີ ແດີອ໌ ປາຍ: \"ແອີດ ອໍ! ໄມ່ ອຶນໂຈຍ ປ່ອງ ນັ່ອງ.\" ເຈີ່ ກູຢາລ ຕາງິ່ດ ກະ ແດີອ໌ ຕາ ເບີນ ຣາໄມ່ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ເຈີ່ ເຢຊູ ອາເບຼິຮ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ນານ່ະ ເຍືາ ອຶງກັອຮ? ເຍືາ ຕາ ຢວາຮ ຊາອຳ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ມາ ໄລ່ ຊັອງ ອຶງກັອຮ ລາລື່. ມານະ ອາເບຼິຮ ມານະ ປາຍ: \"ກວາຍ ໄນ່ ລາ ເນົ່າ? ນານ່ະ ແຕ ກູຢາລ ກະ ແດີອ໌ ລາ ຊາງັດ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ແວັດ ກັອຍ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ໄລ່ ເປາະ ແຕີ່ອ໌ ປຶ່ຮ ອຶນຕົ່ຮ ທາເລ ຣາປັ່ງ ຄາລີເລ ຕຶ່ງ ແຄດ ເຄຣາຊາ. ");
INSERT INTO ncq_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ພໍກາ ເຢຊູ ແຊງ ແຕ ຕົວະ ກັອຍ, ເບີນ ຣາເລົາ ມານະ ກາ ເຢືາງ ຕາ ອໍ ຕຣວບ; ອັນ ລັ່ອຮ ແຕ ປີ່ງ ກູມູ່ຍ໌ ອີ ແຕີ່ອ໌ ປໍ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ຣາເລົາ ໄນ່ ອັນ ແອີດ ຕຶ່ງ ປີ່ງ ກູມູ່ຍ໌. ຕາ ເບີນ ອາແລ່ະ ເຕ່ອ໌ ຊັດ ດໍອ໌ ອັນ. ເນົ່າ ອີດ ອຶນໄຊ ໂຊ ຊັດ ດໍອ໌ ອັນ ລາ ຕາ ເບີນ ແອີດ. ");
INSERT INTO ncq_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ເນົ່າ ເກີ່ຍ ຊັດ ອຶນໄຊ ໂຊ ຕຶ່ງ ອາເຢີງ ອາຕີ ອັນ. ຊາອຶ່ຍ ຕໍ່ ເຈີ່ ມາ ອັນ ກູເນືາອ໌ ອຶນໄຊ ໂຊ ຕາອັອຮ ກະ ຕາອ໌ ຕຶ່ງ ອາເຢີງ ອັນ, ຕາແກັ່ຮ ອຶນແຍ່ະ ກູ່ ຕໍ່. ຍ່ອນ ອັນ ເຣ່ງ ລາລື່ ຕາ ເບີນ ອາແລ່ະ ເຕ່ອ໌ ກູຣຍາອ໌ ດໍອ໌ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ກາ ຕາໄງ ກາ ຊາເດົາ ອັນ ຕັນຕຽວ ແອີດ ຕຶ່ງ ປີ່ງ ກູມູ່ຍ໌ ກະ ຕຶ່ງ ກົຮ. ເຈີ່ ອັນ ແຮຣ ກະ ອີດ ຕາເມົາ ໂຊດ ຈະ ອັນ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ພໍກາ ອັນ ເຮີມ ເຢຊູ ແຕ ເຢີ່ງໆ ອັນ ຕາລຸ່ຮ ມູ່ດ ປໍ ເຢຊູ ກະ ອັນ ຄຣາບ ຢັ່ຮ ເມືາງ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ເຈີ່ ອັນ ແຮຣ ອຶນແຍ່ະ ເຣ່ງ ປາຍ: \"ເຢຊູ ກອນ ເຢືາງ ເຈົາຣາຊີ ກາ ຊົດ ກາເລີຍ ອຶນແຍ່ະ ແຕ ການໍ່ອ໌ ເອີຍ, ອຶນເຕົ່າ ໄມ່ ອີ ເບີນ ແຕ ເກົາ? ເກົາ ແຊອ໌ ໂອນ ໄມ່ ລັບ ກະ ເຢືາງ ເຈົາຣາຊີ ປາຍ ໄມ່ ຕາ ເບີນ ຕະ ຕຸ່ຮ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ອັນ ປາຍ ນ່ະໄນ່ ຍ່ອນ ອັນ ຊັອງ ເຢຊູ ອາຕີ ປາຍ: \"ເຢືາງ ຕາ ອໍ ເອີຍ! ໄມ່ ລັ່ອຮ ເດິຮ ແຕ ຈະ ກວາຍ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ເຢຊູ ອາເບຼິຮ ອັນ ປາຍ: \"ນານ່ະ ຣາມຶ່ຮ ໄມ່?\" ອັນ ຕາແອີຍ ປາຍ: \"ຣາມຶ່ຮ ເກົາ ລາ ກອງທັບ, ຍ່ອນ ຕຶ່ງ ຈະ ເກົາ ເບີນ ເຢືາງ ຕາ ອໍ ກຼຶ່ງ ລາລື່.\" ");
INSERT INTO ncq_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ອັນ ແຊອ໌ ເລືອຍໆ ແຕ ເຢຊູ ຕາ ໂອນ ຕູ່ຍຮ ອາລັ່ອຮ ໄລ່ ແຕ ກຣວາງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ແຈ່ະ ກັອຍ ເບີນ ຈຸ່ມ ອາລີ່ອ໌ ຊາອຶ່ຍ ລາລື່ ແອີດ ຈໍ່ອ໌ ຈາ ຕາມ ຊາຮິງ ກົຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ມັຮ ກາ ເຢືາງ ຕາ ອໍ ກູກຸຮ ແຊອ໌ ແຕ ເຢຊູ ປາຍ: \"ໂອນ ຮິ ມູ່ດ ແອີດ ຕຶ່ງ ຈຸ່ມ ອາລີ່ອ໌ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ເຢຊູ ໂອນ ໄລ່ ມູ່ດ. ເຈີ່ ເຢືາງ ຕາ ອໍ ລັ່ອຮ ແຕ ກວາຍ ກັອຍ, ໄລ່ ມູ່ດ ຕຶ່ງ ຈຸ່ມ ອາລີ່ອ໌ ແອັນ. ເຈີ່ ອາລີ່ອ໌ ບາຣ ປັ່ນ ລຳ ກັອຍ, ຕາລຸ່ຮ ອາແຊງ ແຕ ຊາຮິງ ກົຮ ຕາຣວາລ ອາປັອງ ປໍ ທາເລ ຣາປັ່ງ, ເຈີ່ ກູຈີດ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ກວາຍ ກາ ກຍາອ໌ ອາລີ່ອ໌ ຕາລຸ່ຮ ເປາະ ອາຕີ ຣາມຶ່ຮ ກາ ໄລ່ ເຮີມ ໂອນ ກວາຍ ຕຶ່ງ ເມືອງ ກະ ກວາຍ ຢັ່ຮ ນໍ່ອ໌ ເມືອງ ໂອນ ເນົ່າ ດັງ. ນ່ະກັອຍ ມັຮ ກາ ກອນແຊມ ເປາະ ຊາລີອ໌ ຣານະ ອຶນເຕົ່າ ກາ ແກີດ. ");
INSERT INTO ncq_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ພໍກາ ໄລ່ ແຕີ່ອ໌ ປໍ ເຢຊູ ໄລ່ ເຮີມ ກວາຍ ກາ ແຕ ອຶນໂຍ່ງ ເບີນ ເຢືາງ ຕາ ອໍ ກຼຶ່ງ ລາລື່ ຕຣວບ; ອັນ ໂຈະ ເກຣີ່ງ ກະ ອັນ ຕາກູ ແອີດ ອໍ. ອັນ ຕາ ເບີນ ຢຸ່ຮ ນັ່ອງ. ເຈີ່ ກວາຍ ກຼຶ່ງ ກັອຍ ໄລ່ ແກີດ ອຶງກັອຮ. ");
INSERT INTO ncq_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ກວາຍ ກາ ເຮີມ ຣານະ ກາ ແກີດ ກະ ກວາຍ ກາ ເຢືາງ ຕາ ອໍ ຕຣວບ ກະ ຈຸ່ມ ອາລີ່ອ໌ ກັອຍ, ໄລ່ ຕະ ອຶນຕີ ຣານະ ກັອຍ ໂອນ ກວາຍ ການໍ່ອ໌ ດັງ. ");
INSERT INTO ncq_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ນ່ະກັອຍ ໄລ່ ແຊອ໌ ໂອນ ເຢຊູ ລັ່ອຮ ແຕ ເມືອງ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ພໍກາ ເຢຊູ ຊັອຮ ລັ່ຮ ຕຶ່ງ ຕົວະ, ກວາຍ ກາ ເຢືາງ ຕາ ອໍ ຕຣວບ ແຊອ໌ ເປາະ ກະ ອັນ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ເຢຊູ ຕາ ໂອນ ອັນ ເປາະ ອາລຶ່ງ, ເຈີ່ ອັນ ປາຍ: \"ໄມ່ ເຈົາ ປໍ ດຸງ ໄມ່, ເປາະ ຣາມົຮ ແຊມອາຍ ໄມ່. ເຈີ່ ໄມ່ ຕະ ອຶນຕີ ຣານະ ປື່ດ ກາ ເຢືາງ ເຈົາຣາຊີ ຈ່ອຍ ໄມ່ ຍ່ອນ ອັນ ອາໂຢ່ະ ຕະ ໄມ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ເຈີ່ ຣາເລົາ ກັອຍ ອັນ ເປາະ ອາຕີ ແຕ ຣານະ ເຢຊູ ຈ່ອຍ ອັນ ປໍ ເມືອງ ເດກາໂປລີ. ກະ ກວາຍ ກາ ຊັອງ ກັອຍ ແກີດ ງຶ່ດ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ເຢຊູ ຈິ່ຮ ຕົວະ ໄກ່ອ໌໌ ອຶນຕົ່ຮ ທາເລ ຣາປັ່ງ. ພໍກາ ແຕີ່ອ໌ ປຶ່ຮ ເບີນ ກວາຍ ກຼຶ່ງ ລາລື່ ແຕີ່ອ໌ ໂຣ່ມ ຈວບ ຈະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ເບີນ ມານະ ກວາຍ ຣາເລົາ ຣາມຶ່ຮ ຢາອີຣໂຣ ກາ ຕາລາ ມວຍ ດຸງ ຊາງ ກວາຍ ອິດຊະຣາເອລ ຕຶ່ງ ກຣວາງ ກັອຍ. ພໍກາ ອັນ ເຮີມ ເຢຊູ, ອັນ ຄຣາບ ອາແຊງ ແຈ່ະ ອາເຢີງ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ອັນ ແຊອ໌ ກູກຸຮ ກູກວຍ ໂອນ ເຢຊູ ຈ່ອຍ, ເຈີ່ ອັນ ປາຍ: \"ກອນ ມັນແຊມ ເກົາ ອາອີ່ ຮັບ ລາລື່. ແຊອ໌ ໄມ່ ເປາະ ຊາປ່ະ ອາຕີ ໂຈະ ກອນ ເກົາ ແຮີ ໂອນ ອັນ ແບຣັຮ ອາມົ່ງ ອໍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ເຢຊູ ເປາະ ກະ ຢາອີຣໂຣ. ກວາຍ ກຼຶ່ງ ລາລື່ ເປາະ ອາລຶ່ງ ເຢຊູ ເຕົ່າ ກູທັດ ຣາເນ່ດ ຈະ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ຕຶ່ງ ມັຮ ກາ ກວາຍ ກັອຍ ເບີນ ມັນແຊມ ມານະ ອັນ ອາອີ່ ແກີດ ຮື່ ອຶນແຍ່ະ ມັນຈິ່ດ ລາ ບາຣ ກູມໍ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ອັນ ເປາະ ຈໍ່ອ໌ ມໍ ປົວ. ປິ່ດ ອຶນແຍ່ະ ປຣະ ແຢງ ໂອນ ມໍ ກັອຍ, ມາ ອັນ ຕາ ເບີນ ປຣາຍ. ແຮງ ອັນ ແກີດ ອຶງກວາ ຕຍາ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ພໍກາ ອັນ ຊັອງ ຮານ ເນົ່າ ປາຍ ແຕ ເຢຊູ, ເຈີ່ ອັນ ຕາຢັຮ ອາມູ່ດ ອຶນຕູ່ນ ກຣັອງ ເຢຊູ ມັນຕຸ ກະ ກວາຍ ກຼຶ່ງ. ອັນ ຊາປ່ະ ອາຢັ່ອຮ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ອັນ ຄຶ່ດ ຕຶ່ງ ຣາງຶ່ຮ ປາຍ: \"ຄັນ ເກົາ ຊາປ່ະ ອາຢັ່ອຮ ອັນ, ອາຣັ່ງ ເກົາ ອີ ແບຣັຮ ແຕິ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ພໍກາ ອັນ ຊາປ່ະ ອາຢັ່ອຮ ເຢຊູ, ອາອີ່ ລັ່ອຮ ອາຮາມ ກັອຍ ແກີດ ແບຣັຮ ແຕິ່. ອັນ ດັງ ຕຶ່ງ ຈະ ອັນ ແບຣັຮ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ເຈີ່ ເຢຊູ ດັງ ອຳນາດ ລັ່ອຮ ແຕ ຈະ ອັນ, ເຈີ່ ອັນ ກູເລືານ ເນ່ ປໍ ກວາຍ ກຼຶ່ງ ກັອຍ, ກະ ອັນ ອາເບຼິຮ ປາຍ: \"ເນົ່າ ກາ ຊາປ່ະ ອາຢັ່ອຮ ເກົາ?\" ");
INSERT INTO ncq_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ມູ່ ກາ ຣຍານ ແຕ ອັນ ຕາແອີຍ ປາຍ: \"ໄມ່ ເຮີມ ເຈີ່ ກວາຍ ກຼຶ່ງ ລາລື່ ແອີດ ຣາເນ່ດ ຈະ ໄມ່. ນານ່ະ ໄມ່ ອຶນນັ່ອງ ອາເບຼິຮ ຮິ ປາຍ: 'ເນົ່າ ຊາປ່ະ ອາຢັ່ອຮ ເກົາ?'\" ");
INSERT INTO ncq_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ມາ ເຢຊູ ອຶນເນີ່ມ ກູລຍານ ເນ່ ຣ່ອບ ອຶນແຍ່ະ ກວາຍ ອຶງກັອຍ, ອັນ ອີ ຊາລີອ໌ ເນົ່າ ກາ ຊາປ່ະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ມັນແຊມ ກັອຍ ຊັອງ ອຶງກັອຮ ກາໄກ່ຮ ລາລື່, ຍ່ອນ ອັນ ດັງ ອຶນເຕົ່າ ກາ ແກີດ ກະ ອັນ. ມັນແຊມ ກັອຍ ກຼຸ່ ຣາໂກລ ອາແຊງ ຊຳປັ່ຮ ເຢຊູ ເຈີ່ ອັນ ອາຕີ ຕານັ່ອງ ໂອນ ເຢຊູ ຊາງັດ. ");
INSERT INTO ncq_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ເຢຊູ ອາຕີ ອັນ ປາຍ: \"ອາມໍອ໌ ເອີຍ! ຍ່ອນ ໄມ່ ຊາອຳ, ອາອີ່ ໄມ່ ແກີດ ແບຣັຮ ເຈີ່. ໂອນ ໄມ່ ເຈົາ ອຽນ ອໍ; ໄມ່ ຕາ ເບີນ ຕຸ່ຮ ນັ່ອງ.\" ");
INSERT INTO ncq_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ບັອງ ກາ ເຢຊູ ອຶນນັ່ອງ ແອີດ ຕະ ອຶນຕີ ກັອຍ, ເບີນ ກວາຍ ແຕີ່ອ໌ ແຕ ດຸງ ຢາອີຣໂຣ ປາຍ ໂຈະ ຢາອີຣໂຣ ນ່ະໄນ່: \"ກອນ ມັນແຊມ ໄມ່ ກູຈີດ ເຈີ່. ໄມ່ ອຶນໂຈຍ ປາຕຸ່ຮ ອາຈານ ນັ່ອງ.\" ");
INSERT INTO ncq_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ເຢຊູ ຕາ ເບີນ ຣາບູລ ອຶນເຕົ່າ ແຕ ປັຣນາຍ ໄລ່ ຕະ ອຶນຕີ. ເຢຊູ ອາຕີ ຢາອີຣໂຣ ປາຍ: \"ອຶນໂຈຍ ອຶງກັອຮ. ໄມ່ ຊາອຳ ຊັອງ.\" ");
INSERT INTO ncq_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ເຢຊູ ໂອນ ແອີງ ເປໂຕ, ຢາໂກໂບ, ກະ ໂຢຮັນ ອາແອມ ຢາໂກໂບ ເປາະ ກະ ອັນ. ກວາຍ ການໍ່ອ໌ ອັນ ຕາ ເບີນ ໂອນ ເປາະ ອາລຶ່ງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ພໍກາ ໄລ່ ແຕີ່ອ໌ ປໍ ດຸງ ຢາອີຣໂຣ, ເຢຊູ ເຮີມ ກວາຍ ກຼຶ່ງ ເຍືາມ ກູມູ່ຍ໌ ເຣ່ງ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ເຢຊູ ມູ່ດ ຕຶ່ງ ດຸງ. ເຈີ່ ອັນ ຕາແບີບ ປາຍ: \"ອຶນເຕົ່າ ເຍືາ ຕະ ອຶ່ກກະທຶ່ກ, ກະ ເຍືາ ເຍືາມ ຕະ ອຶນເຕົ່າ? ກັຣແນນ ມັນແຊມ ໄນ່ ອັນ ຕາ ເບີນ ກູຈີດ; ອັນ ບິ ຊັອງ.\" ");
INSERT INTO ncq_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ອຶນແຍ່ະ ນະ ກວາຍ ກາ ແອີດ ອຶງກັອຍ ກັຣຈັງ ເຈືາດ ເຢຊູ. ເຈີ່ ເຢຊູ ຕູ່ຍຮ ອາລັ່ອຮ ອຶນແຍ່ະ ນະ ໄລ່, ເຈີ່ ອັນ ໂອນ ແອີງ ອຶມເປ່ອ໌ ອຶມປໍ່ ກັຣແນນ ກະ ໄປ ນະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ແຕິ່ ມູ່ດ ຕຶ່ງ ກູນົງ ກາ ກັຣແນນ ກັອຍ ບິ. ");
INSERT INTO ncq_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ເຢຊູ ໂກບ ອາຕີ ກັຣແນນ ກັອຍ, ເຈີ່ ອັນ ປາຍ: \"ອາມໍອ໌ ເອີຍ, ໄມ່ ຢວຣ!\" ");
INSERT INTO ncq_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ມັນແຊມ ກັອຍ ຢວຣ ຕາຢຶ່ງ ແຕິ່. ເຈີ່ ອັນ ຕາຢັຮ ເປາະ ອຶມແປຣ ກັອຍ (ມັນແຊມ ກັອຍ ອາຍຸ່ ມັນຈິ່ດ ລາ ບາຣ ກູມໍ). ເຈີ່ ຣາງຶ່ຮ ໄລ່ ກັອຍ ຊັອງ ງຶ່ດ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ເຢຊູ ປາຕັບ ດໍອ໌ ຕາ ເບີນ ໂອນ ໄລ່ ຕະ ອຶນຕີ ຣານະ ໄນ່ ໂອນ ອາແລ່ະ ດັງ. ເຈີ່ ອັນ ປາຍ: \"ເຍືາ ອີດ ຊັຣນາ ໂອນ ອາມໍອ໌ ໄນ່ ຈາ.\" ");
INSERT INTO ncq_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ເຢຊູ ລັ່ອຮ ແຕ ກັອຍ ເຈີ່ ອັນ ເຈົາ ລັ່ຮ ປໍ ວີ່ລ ອັນ ເບີມ. ມູ່ ກາ ຣຍານ ແຕ ອັນ ລາ ເປາະ ກະ ອັນ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ພໍກາ ແຕີ່ອ໌ ຕາໄງ ຣາລູ່, ເຢຊູ ແອີດ ອາຕີ ຕຶ່ງ ດຸງ ຊາງ. ເບີນ ກວາຍ ກຼຶ່ງ ລາລື່ ແອີດ ອຶງກັອຍ. ພໍກາ ໄລ່ ຊັອງ ປັຣນາຍ ເຢຊູ ອາຕີ, ໄລ່ ຊັອງ ງຶ່ດ ລາລື່. ເຈີ່ ໄລ່ ມານະ ອາເບຼິຮ ມານະ ປາຍ: \"ປັຣນາຍ ອັນ ອາຕີ ໄນ່ ແຕີ່ອ໌ ແຕ ແລ່ະ? ແຕ ແລ່ະ ອັນ ຣາໄງ່ອ໌ ຣາລັ່ງ ລາລື່ ໄນ່? ເຕ່ອ໌ ອັນ ຕະ ຣານະ ຕາ ເກີ່ຍ ເຮີມ. ");
INSERT INTO ncq_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","\"ເມ່ນ ອັນ ໄນ່ ບໍ ກວາຍ ເຈືາງ ຕະ ອາລ່ອງ? ອັນ ໄນ່ ບໍ ກອນ ມາຣີ, ອາຍ ຢາໂກໂບ, ໂຢເຊັບ, ຢູດາ, ກະ ຊີໂມນ? ມັຮ ອາແອມ ມັນແຊມ ອັນ ແອີດ ຕຶ່ງ ວີ່ລ ໄຮ ໄນ່ ເຕ່ ເມ່ນ ບໍ?\" ໄລ່ ພາມາດ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ເຈີ່ ເຢຊູ ອາຕີ ໂຈະ ໄລ່ ປາຍ: \"ກວາຍ ກາ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ມັຮ ກວາຍ ແຕ ວີ່ລ ການໍ່ອ໌ ຢຳນັ່ບ ອັນ, ມາ ກວາຍ ຕຶ່ງ ວີ່ລ ອັນ ເບີມ, ກະ ມັຮ ແຊມອາຍ ຕຶ່ງ ດຸງຊູ ອັນ ເບີມ, ໄລ່ ຕາ ເບີນ ຢຳນັ່ບ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ຍ່ອນ ນ່ະກັອຍ ເຢຊູ ຕາ ເຕ່ອ໌ ຕະ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ຕຶ່ງ ວີ່ລ ອັນ. ອັນ ຊາປ່ະ ອາຕີ ຕຶ່ງ ກວາຍ ອາອີ່ ບຍາອ໌ ນະ ຊັອງ, ຕະ ໂອນ ໄລ່ ແບຣັຮ. ");
INSERT INTO ncq_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ເຢຊູ ຊັອງ ງຶ່ດ ຕຶ່ງ ຣາງຶ່ຮ ອັນ, ຍ່ອນ ມັຮ ກວາຍ ຕຶ່ງ ວີ່ລ ອັນ ຕາ ເບີນ ຊາອຳ ອັນ. ເຈີ່ ເຢຊູ ເປາະ ອາຕີ ກູ່ ວີ່ລ ອຶມແປຣ ກຣວາງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ເຢຊູ ແປຣີ ມັນຈິ່ດ ລາ ບາຣ ນະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ໂອນ ເປາະ ແກີດ ກູ່. ເຢຊູ ໂອນ ໄລ່ ເບີນ ອຳນາດ ເຕ່ອ໌ ຕູ່ຍຮ ເຢືາງ ຕາ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ເຈີ່ ອັນ ອາຕີ ໄລ່ ປາຍ: \"ອຶນໂຈຍ ເດີງ ອຶນເຕົ່າ ຕຶ່ງ ຈະ ເຍືາ, ອຶນໂຈຍ ເດີງ ໂດຍ ຣາແວັ່ຮ, ອຶນໂຈຍ ເດີງ ຕູຍ, ອຶນໂຈຍ ເດີງ ປຣະ ໂຈະ ຕຶ່ງ ບອບ, ມາ ໂອນ ເຍືາ ເດີງ ແອີງ ຣາແລີງ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ໂອນ ເຍືາ ແຊິບ ແກີບ, ມາ ເຍືາ ອຶນໂຈຍ ເດີງ ອາຢັ່ອຮ ບາຣ ປຼັ່ຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ເຢຊູ ອາຕີ ໄລ່ ປາຍ: \"ດຸງ ອາແລ່ະ ກາ ຣັ່ບ ເຍືາ, ໂອນ ເຍືາ ແອີດ ດຸງ ອາກັອຍ ເຕົ່າ ແຕີ່ອ໌ ເຍືາ ລັ່ອຮ ແຕ ວີ່ລ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ຄັນ ວີ່ລ ອາແລ່ະ ກາ ຕາ ເບີນ ຣັ່ບ ກະ ຕາ ເບີນ ຊາງັດ ປັຣນາຍ ເຍືາ, ພໍກາ ເຍືາ ລັ່ອຮ ແຕ ວີ່ລ ກັອຍ, ໂອນ ເຍືາ ກັນຕຣິ່ຮ ພຸ່ນ ກູແຕອ໌ ແຕ ອາເຢີງ ເຍືາ ຕະ ໂອນ ເນົ່າ ດັງ ປາຍ ວີ່ລ ກັອຍ ລາ ຕາ ເບີນ ຣັ່ບ ເຍືາ.\" ");
INSERT INTO ncq_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ເຈີ່ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ໄລ່ ລັ່ອຮ ເປາະ ອາຕີ ໂອນ ກວາຍ ຕັຮ ຣາງຶ່ຮ ຕຍາ ອີດ ຣາງຶ່ຮ ຕາໄມ. ");
INSERT INTO ncq_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ໄລ່ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ແຕ ຈະ ກວາຍ, ກະ ໄລ່ ອາເຕືາ ອຶນຊີ່ງ ຕະ ຣີ່ດ ຕຶ່ງ ຈະ ກວາຍ ອາອີ່ ໂອນ ແກີດ ແບຣັຮ. ");
INSERT INTO ncq_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ເຮໂຣດ ແກີດ ຊົດ ຕຶ່ງ ແຄງ ຄາລີເລ. ອັນ ຊັອງ ດັອຮແດີນ ປັຣນາຍ ແຕ ເຢຊູ ປຼັຮ ກຣວາງ ກັອຍ. ເບີນ ກວາຍ ປາຍ: \"ໂຢຮັນ ກາ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂມ່ຍຮ ລັ່ຮ ເຈີ່. ຍ່ອນ ນ່ະກັອຍ ອັນ ເບີນ ອຳນາດ ເຕ່ອ໌ ຕະ ຣານະ ຕາ ເກີ່ຍ ເຮີມ.\" ");
INSERT INTO ncq_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ເບີນ ອັນ ກາ ປາຍ: \"ອັນ ກັອຍ ລາ ເອລີຢາ.\" ເບີນ ອັນ ກາ ປາຍ: \"ອັນ ໄນ່ ລາ ກວາຍ ກາ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ມູເຈິງ ນ່ະ ໄລ່ ກາ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶນໂຍ່ງ.\" ");
INSERT INTO ncq_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ພໍກາ ເຕືາວ ປັຣເຍືາ ເຮໂຣດ ຊັອງ ນ່ະກັອຍ ເຈີ່ ອັນ ປາຍ: \"ເມ່ນ ໂຢຮັນ ກາ ໄຮ ກັອຮ ຕາກອງ ກັອຍ ໂມ່ຍຮ ລັ່ຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ແຕ ອຶນໂຍ່ງ ກັອຍ ເຮໂຣດ ແປຣີ ໂອນ ເນົ່າ ໂກບ ໂຢຮັນ ຊັດ ກະ ໂຈະ ດໍອ໌ ຕຶ່ງ ກໍ່ອ໌. ເຮໂຣດ ຕະ ນ່ະກັອຍ ຍ່ອນ ເຮໂຣເດຍ ກາ ອັນ ອີດ ຕະ ລາກວຍ. ແຕ ອຶນໂຍ່ງ ເຮໂຣເດຍ ແກີດ ລາກວຍ ພີລິບ ອາແອມ ເຮໂຣດ. ");
INSERT INTO ncq_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ໂຢຮັນ ອາຕີ ເຮໂຣດ ປາຍ: \"ໄມ່ ຕະ ນ່ະໄນ່ ຕາ ໄກຣ; ໄມ່ ອີດ ກູມັນ ໄມ່ ເບີມ ຕະ ລາກວຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","ນ່ະກັອຍ ເຮໂຣເດຍ ຊັອງ ອວານ ໂຢຮັນ, ກະ ອີ ກາຈີດ ອັນ. ມາ ອັນ ຕາ ເຕ່ອ໌ ກາຈີດ ຍ່ອນ ເຮໂຣດ ກູຣຍາອ໌ ດໍອ໌ ໂຢຮັນ. ເຮໂຣດ ຢຳ ກະ ອຶງກັອຮ ໂຢຮັນ ຍ່ອນ ອັນ ດັງ ໂຢຮັນ ລາ ກວາຍ ອໍ ກະ ກວາຍ ຕານັ່ອງ. ພໍກາ ເຮໂຣດ ຊາງັດ ໂຢຮັນ ຕະ ອຶນຕີ, ອັນ ແກີດ ຕຸ່ຮ ຕຶ່ງ ຣາງຶ່ຮ. ມາ ອັນ ອຶນນັ່ອງ ຢໍອ໌ ອີ ຊາງັດ ປັຣນາຍ ໂຢຮັນ ຕະ ອຶນຕີ. ");
INSERT INTO ncq_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ເຈີ່ ແຕີ່ອ໌ ຕາໄງ ເຮໂຣເດຍ ເບີນ ຣານາ ອີ ກາຈີດ ໂຢຮັນ ລາ ນ່ະໄນ່: ຕຶ່ງ ຕາໄງ ກັອຍ ເນົ່າ ຈາ ຣໍ່ອ໌ ຊາແຍີ ຕາໄງ ເຕືາວ ປັຣເຍືາ ເຮໂຣດ ແກີດ. ອັນ ການື່ຍ ມັຮ ກວາຍ ກາ ຊົດ ປື່ນ ອັນ, ມັຮ ກາ ເນືາຍ ຕາຮານ, ກະ ກວາຍ ປື່ດ ອຶນແຍ່ະ ນະ ຕຶ່ງ ແຄງ ຄາລີເລ ໂອນ ແຕີ່ອ໌ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ພໍກາ ກອນ ກູໂມຣ ເຮໂຣເດຍ ແຕີ່ອ໌ ມູ່ດ ອຶມປ່ອນ, ອັນ ຕະ ໂອນ ເຮໂຣດ ກະ ຕາມອຍ ໄກຣ ຣາງຶ່ຮ. ເຈີ່ ເຮໂຣດ ປາຍ ໂຈະ ມັນແຊມ ກັອຍ: \"ອຶນເຕົ່າ ໄມ່ ອີ ເບີນ ໂອນ ໄມ່ ແຊອ໌. ອຶນເຕົ່າ ໄມ່ ແຊອ໌ ເກົາ ອີ ໂອນ ອາກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ເຕືາວ ປັຣເຍືາ ອຶນນັ່ອງ ລັບ ປາຍ: \"ເກົາ ອີ ໂອນ ໄມ່ ກູ່ ຣາມຶ່ຮ ກາ ໄມ່ ແຊອ໌. ກາ ກຣວາງ ກູແຕອ໌ ເກົາ ຕາລາ, ເກົາ ອີ ອຶມແປອ໌ ຕາດີ່ ໂອນ ໄມ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ເຈີ່ ກູໂມຣ ກັອຍ ອັນ ເປາະ ອາເບຼິຮ ອຶມເປ່ອ໌ ອັນ: \"ອຶນເຕົ່າ ໄມ່ ໂອນ ເກົາ ແຊອ໌?\" ອຶມເປ່ອ໌ ອັນ ປາຍ: \"ໂອນ ໄມ່ ແຊອ໌ ແປຼີ ໂຢຮັນ ກາ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌.\" ");
INSERT INTO ncq_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ເຈີ່ ອັນ ຕາລຸ່ຮ ເປາະ ອາຕີ ເຮໂຣດ ປາຍ: \"ເກົາ ແຊອ໌ ແປຼີ ໂຢຮັນ ອັນ ກາ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ກັອຍ, ໂຈະ ຕຶ່ງ ກູໂຕອ໌ ຊານໍ່ ໄນ່ ແຕິ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ຣານະ ໄນ່ ຕະ ໂອນ ເຕືາວ ປັຣເຍືາ ເຮໂຣດ ຊັອງ ຕຸ່ຮ ຣາງຶ່ຮ ລາລື່. ອັນ ຕາ ເບີນ ອີ ໂອນ ໂຢຮັນ ປໍ ໄລ່, ມາ ອັນ ຣັ່ບ ແບອ໌ ເຈີ່ ຢັ່ຮ ເມືາງ ຕາມອຍ ຊາອຶ່ຍ ນະ. ");
INSERT INTO ncq_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ເຈີ່ ເຮໂຣດ ແປຣີ ຕາຮານ ໂອນ ເປາະ ອີດ ແປຼີ ໂຢຮັນ. ຕາຮານ ກັອຍ ເປາະ ປໍ ກໍ່ອ໌ ເຈີ່ ກັອຮ ຕາກອງ ໂຢຮັນ. ");
INSERT INTO ncq_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ເຈີ່ ອັນ ອີດ ແປຼີ ໂຢຮັນ ໂຈະ ຕຶ່ງ ກູໂຕອ໌ ແຕີ່ອ໌ ມ່ອບ ໂອນ ມັນແຊມ ກັອຍ. ເຈີ່ ມັນແຊມ ກັອຍ ມ່ອບ ໂອນ ອຶມເປ່ອ໌ ອັນ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ພໍກາ ມູ່ ກາ ຣຍານ ແຕ ໂຢຮັນ ໄລ່ ຊັອງ ຮານ ນ່ະກັອຍ, ເຈີ່ ໄລ່ ເປາະ ອີດ ຈະ ໂຢຮັນ ເດີງ ແຕິບ. ");
INSERT INTO ncq_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ເຈົາ ລັ່ຮ ປໍ ອັນ. ເຈີ່ ໄລ່ ອາຕີ ໂອນ ເຢຊູ ດັງ ກູ່ ຣາມຶ່ຮ ກາ ໄລ່ ຕະ ກະ ກູ່ ຣາມຶ່ຮ ໄລ່ ອາຕີ. ");
INSERT INTO ncq_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ເຈີ່ ເຢຊູ ປາຍ: \"ໄຮ ເປາະ ຈໍ່ອ໌ ອຶນຕຸ ຣາງຍາອ໌ ໂອນ ເຍືາ ຣາລູ່ ບຍາອ໌.\" ຍ່ອນ ກວາຍ ກຼຶ່ງ ລາລື່ ຕັນຕຽວ ຕະ ໂອນ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ຕາ ເຕ່ອ໌ ຈາ ໂດຍ. ");
INSERT INTO ncq_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ເຈີ່ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ໄລ່ ຈິ່ຮ ຕົວະ ອີ ເປາະ ປໍ ອຶນຕຸ ຣາງຍາອ໌ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ມາ ກຼຶ່ງ ກວາຍ ເຮີມ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ໄກ່ອ໌໌ ເປາະ ປໍ ອຶນຕຸ ຕາ ເບີນ ເນົ່າ ແອີດ. ເຈີ່ ກວາຍ ກຼຶ່ງ ແຕ ຊາອຶ່ຍ ວີ່ລ ກັອຍ ໄລ່ ຕາລຸ່ຮ ລັ່ດ ຣານາ ກົຮ ເຈີ່ ໄລ່ ແຕີ່ອ໌ ປໍ ກັອຍ ອຶນໂຍ່ງ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ພໍກາ ເຢຊູ ແຊງ ແຕ ຕົວະ, ອັນ ເຮີມ ກວາຍ ກຼຶ່ງ ກັອຍ ແຕີ່ອ໌ ອຶນໂຍ່ງ, ເຈີ່ ໄລ່ ເກຣາະ ອັນ. ເຢຊູ ຄຶ່ດ ອາໂຢ່ະ ຕະ ໄລ່, ຍ່ອນ ໄລ່ ແກີດ ນ່ະ ຈຸ່ມ ແກະ ກາ ຕາ ເບີນ ກວາຍ ກຍາອ໌. ເຈີ່ ເຢຊູ ອາຕີ ໂອນ ໄລ່ ດັງ ຊາອຶ່ຍ ຣາມຶ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ພໍກາ ມານາງ ຕາບື່ ເຈີ່, ມູ່ ກາ ຣຍານ ແຕີ່ອ໌ ປໍ ເຢຊູ, ເຈີ່ ໄລ່ ປາຍ: \"ມານາງ ຕາບື່ ເຈີ່. ອຶນໄນ່ ລາ ອຶນຕຸ ຣາງຍາອ໌. ");
INSERT INTO ncq_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ແຊອ໌ ອາຈານ ອາຕີ ມັຮ ກວາຍ ກຼຶ່ງ ກັອຍ ເຈົາ ແຈີງ ໂດຍ ຣາແວັ່ຮ ຈາ ຕຶ່ງ ມັຮ ກາ ດຸງ ວີ່ລ ອຶມແປຣ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ເຍືາ ແຕິ່ ຈໍ່ອ໌ ໂດຍ ຣາແວັ່ຮ ໂອນ ໄລ່ ຈາ.\" ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ຕາແອີຍ ປາຍ: \"ໄມ່ ໂອນ ຮິ ເປາະ ແຈີງ ໂດຍ ຣາແວັ່ຮ ອຶນແຍ່ະ ບາຣ ຣ່ອຍ ກຼອງ ປຣະ ອານາມ ໄນ່ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ເຢຊູ ອາເບຼິຮ ໄລ່ ປາຍ: \"ເຍືາ ເບີນ ໂດຍ ບຸຮ ອຶນຊິ ລຳ? ເປາະ ຊາລີອ໌ ແມະ.\" ໄລ່ ເປາະ ຈໍ່ອ໌, ເຈີ່ ໄລ່ ອາຕີ ປາຍ: \"ເບີນ ເຊີງ ລຳ ໂດຍ ບຸຮ, ກະ ບາຣ ລຳ ອາກາ.\" ");
INSERT INTO ncq_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ເຢຊູ ອາຕີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ເຍືາ ໂອນ ໄລ່ ແອີດ ແກີດ ຈຸ່ມ ຕາກູ ແອີດ ຕຶ່ງ ບັດ.\" ");
INSERT INTO ncq_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ນ່ະກັອຍ ໄລ່ ຕາກູ ແກີດ ຊາອຶ່ຍ ຈຸ່ມ, ມູ ຈຸ່ມ ມວຍ ຣ່ອຍ ນະ, ມູ ຈຸ່ມ ເຊີງ ຈິ່ດ ນະ. ");
INSERT INTO ncq_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ເຈີ່ ເຢຊູ ອີດ ໂດຍ ບຸຮ ເຊີງ ລຳ ກະ ອາກາ ບາຣ ລຳ. ອັນ ຕາເງີ່ອ໌ ອາຊັອຮ ປໍ ມັນລັ່ອງ ຊາແອີນ ເຢືາງ ເຈົາຣາຊີ, ເຈີ່ ອັນ ປີຮ ໂດຍ ບຸຮ ອາແວີຍ ໂອນ ປໍ ມູ່ ກາ ຣຍານ ແຕ ອັນ, ໂອນ ໄລ່ ເປາະ ອຶມແປອ໌ ໂອນ ມັຮ ກວາຍ ກຼຶ່ງ ກັອຍ. ເຢຊູ ອຶມແປອ໌ ອາກາ ບາຣ ລຳ ໂອນ ກວາຍ ເບີນ ຈາ ກູ່ ນະ. ");
INSERT INTO ncq_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ອຶນແຍ່ະ ມັຮ ກວາຍ ກັອຍ ຈາ ປາໄຊ ກູ່ ນະ. ");
INSERT INTO ncq_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ແວັດ ໄລ່ ຈາ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ປາໂຣມ ລັ່ຮ ມັຮ ກາ ໂດຍ ບຸຮ ກະ ອາກາ ກາ ແກຼີຍ ໄລ່ ຈາ, ເບີນ ມັນຈິ່ດ ລາ ບາຣ ກາເຣຍ. ");
INSERT INTO ncq_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ກວາຍ ຣາເລົາ ກາ ຈາ ອຶງກັອຍ ເບີນ ເຊີງ ປັ່ນ ນະ. ");
INSERT INTO ncq_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ເຈີ່ ເຢຊູ ໂອນ ມູ່ ກາ ຣຍານ ແຕ ອັນ ຊັອຮ ຕຶ່ງ ຕົວະ ກະ ເປາະ ອຶນໂຍ່ງ ອັນ ປໍ ອຶນຕົ່ຮ ທາເລ ຣາປັ່ງ ປໍ ເມືອງ ເບັດຊາອີດາ. ເຢຊູ ອາຕີ ໂອນ ກວາຍ ກຼຶ່ງ ກັອຍ ເຈົາ ລັ່ຮ ປໍ ດຸງ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ແວັດ ກວາຍ ກຼຶ່ງ ເຈົາ ເຈີ່, ເຢຊູ ຊັອຮ ປໍ ກົຮ, ອັນ ອີ ເກົາແຊອ໌ ມານະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ພໍກາ ມານາງ ຕາບື່ ເຈີ່, ຕົວະ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ແອີດ ອຶນດີ ທາເລ ຣາປັ່ງ. ມາ ເຢຊູ ອຶນນັ່ອງ ແອີດ ຕຶ່ງ ປຶ່ຮ; ອັນ ຕາ ຢວາຮ ເປາະ. ");
INSERT INTO ncq_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ເຢຊູ ເຮີມ ມູ່ ກາ ຣຍານ ແຕ ອັນ ເປືາຍ ຕົວະ ຣານຸ່ຮ ລາລື່ ຍ່ອນ ເບີນ ກູຢາລ ເຣ່ງ ກຼຸ່ຮ ແປຼີ ຕົວະ. ພໍກາ ກຣວາງ ແຈ່ະ ອີ ປັ່ງ ເຢຊູ ຕາຢັຮ ແປີງ ກຣັອງ ແດີອ໌ ເປາະ ປໍ ມູ່ ກາ ຣຍານ ແຕ ອັນ. ເຢຊູ ຕາຢັຮ ນ່ະ ອີ ເປຼີຍ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ພໍກາ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ເຮີມ ອັນ ຕາຢັຮ ແປີງ ກຣັອງ ແດີອ໌, ໄລ່ ຄຶ່ດ ປາຍ ກູມູ່ຍ໌. ເຈີ່ ໄລ່ ແຮຣ ເຣ່ງ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ກູ່ ນະ ໄລ່ ເຮີມ ອຶນແຍ່ະ, ກະ ໄລ່ ຊັອງ ອຶງກັອຮ ລາລື່. ເຈີ່ ເຢຊູ ອາຕີ ໂຈະ ໄລ່ ປາຍ: \"ໂອນ ຣາງຶ່ຮ ເຍືາ ແອີດ ອຽນ ອໍ. ໄນ່ ລາ ຈະ ເກົາ. ເຍືາ ອຶນໂຈຍ ອຶງກັອຮ ອຶນເຕົ່າ.\" ");
INSERT INTO ncq_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ເຈີ່ ເຢຊູ ຊັອຮ ຕຶ່ງ ຕົວະ ເປາະ ກະ ໄລ່. ເຈີ່ ກູຢາລ ລາ ຕາງິ່ດ ເຕ່. ມູ່ ກາ ຣຍານ ແຕ ອັນ ຊັອງ ງຶ່ດ ລາລື່ ຕຶ່ງ ຣາງຶ່ຮ ໄລ່, ");
INSERT INTO ncq_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ຍ່ອນ ໄລ່ ອຶນເນີ່ມ ຕາ ເບີນ ດັງ ເຢຊູ ຕະ ອຶນເຕົ່າ ບັອງ ກາ ອັນ ປີຮ ອຶມແປອ໌ ໂດຍ ບຸຮ, ຍ່ອນ ຣາງຶ່ຮ ໄລ່ ກັ່ອງ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ພໍກາ ໄລ່ ເປາະ ໄກ່ອ໌໌ ປຶ່ຮ ອຶນຕົ່ຮ ເຈີ່, ໄລ່ ດໍອ໌ ຕົວະ ຕຶ່ງ ອຶນຕຣີ່ນ ແດີອ໌ ເມືອງ ເຄັນເນຊາເຣັດ. ");
INSERT INTO ncq_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ພໍກາ ໄລ່ ແຊງ ແຕ ຕົວະ, ມັຮ ກວາຍ ອຶງກັອຍ ໄລ່ ຊາກັ່ລ ແຕິ່ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ໄລ່ ຕາລຸ່ຮ ເປາະ ອາຕີ ມັຮ ກາ ກວາຍ ຕິ່ ອາອີ່ ອຶມແປຣ ກັອຍ, ເຈີ່ ໄລ່ ອີດ ກວາຍ ຕິ່ ອາອີ່ ກຣາງ ເດີງ ປໍ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ກູ່ ອຶນຕຸ ກາ ເຢຊູ ເປາະ ຕຶ່ງ ວີ່ລ, ຕຶ່ງ ເມືອງ, ແຕີລາ ອຶນຕຸ ການໍ່ອ໌ ແຮີ, ກອນແຊມ ໄລ່ ເດີງ ກວາຍ ຕິ່ ອາອີ່ ຊາຣີ່ ຊາກໍ່ ດໍອ໌ ລຍາບ ຕາລາດ, ຕຶ່ງ ຊັງອາຣ ວີ່ລ. ມູ່ ກາ ເດີງ ມັຮ ກວາຍ ຕິ່ ອາອີ່ ກັອຍ, ໄລ່ ແຊອ໌ ແຕ ເຢຊູ ໂອນ ກວາຍ ຕິ່ ອາອີ່ ຊາປ່ະ ເປິບ ອາຢັ່ອຮ ຕີ່ ເຢຊູ. ກູ່ ນ່ະ ກາ ເບີນ ຊາປ່ະ ເປິບ ອາຢັ່ອຮ ເຢຊູ ລາ ແກີດ ແບຣັຮ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ມັຮ ກາ ກວາຍ ພາຣີຊາຍ ກະ ມັຮ ກວາຍ ອາຕີ ຄານອດ, ໄລ່ ແຕີ່ອ໌ ແຕ ເມືອງ ເຢຣູຊາເລັມ ກະ ໂຣ່ມ ຣ່ອບ ຈະ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ໄລ່ ຈ່ອມ ຊາລີອ໌ ເຮີມ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ຈາ ໂດຍ ຕາ ເບີນ ກູໂຊຍ໌ ອາຕີ ຕາປູ່ນ ຣີ່ດ. ");
INSERT INTO ncq_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ມັຮ ກວາຍ ພາຣີຊາຍ ກະ ກວາຍ ອິດຊະຣາເອລ ກູ່ ນະ ກາ ຊາງັດ ປັຣນາຍ ອາຈວາຍຮ ອາເຈ່ຮ ອາຕີ ດໍອ໌, ຄັນ ຕາ ເບີນ ກູໂຊຍ໌ ອາຕີ ຕາປູ່ນ ຣີ່ດ ລາ ຕາ ເບີນ ເຕ່ອ໌ ຈາ ໂດຍ. ");
INSERT INTO ncq_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ມັຮ ເກຣີ່ງ ຊັຣນາ ໄລ່ ແຈີງ ແຕ ຕາລາດ ຄັນ ໄລ່ ຕາ ເບີນ ອາເຣືາວ ຕະ ຕາປູ່ນ ຣີ່ດ ລາ ໄລ່ ຕາ ເຕ່ອ໌ ຈາ, ກະ ໄລ່ ເດີງ ຣີ່ດ ຊາອຶ່ຍ ຣາມຶ່ຮ, ມວຍ ລາ ຣີ່ດ ອາເຣືາວ ອາແດັຮ ຕາງານ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ນ່ະກັອຍ ກວາຍ ພາຣີຊາຍ ກະ ກວາຍ ອາຕີ ຄານອດ ໄລ່ ອາເບຼິຮ ເຢຊູ ປາຍ: \"ນານ່ະ ແຕ ມູ່ ກາ ຣຍານ ແຕ ໄມ່ ຕາ ເບີນ ຕະ ຕາປູ່ນ ຣີ່ດ ກາ ອາຈວາຍຮ ອາເຈ່ຮ ອາຕີ ດໍອ໌ ແຕ ອຶມແບິ? ມາ ໄລ່ ຈາ ຕາ ເບີນ ກູໂຊຍ໌ ອາຕີ ຕາປູ່ນ ຣີ່ດ?\" ");
INSERT INTO ncq_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ເອຊາຢາ ກາ ຕະ ອຶນຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ຕະ ອຶນຕີ ໄກຣ ແຕ ເຍືາ. ເຍືາ ລາ ກວາຍ ມາມ ອໍ ມາ ຣາງຶ່ຮ ໂກ່ະ, ນ່ະ ອັນ ຄຽນ ດໍອ໌ ປາຍ: 'ມັຮ ກວາຍ ໄນ່ ຢຳນັ່ບ ເກົາ ແອີງ ແບອ໌ ຊັອງ, ມາ ຣາງຶ່ຮ ໄລ່ ແອີດ ເຢີ່ງ ແຕ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ກະ ໄລ່ ຊາງ ເລືອຍໆ ເກົາ ມາ ຕາ ເບີນ ແກີດ ເກືາ ອຶນເຕົ່າ, ຍ່ອນ ໄລ່ ອາຕີ ປັຣນາຍ ກວາຍ, ມາ ຢໍອ໌ ອີ ໂອນ ເນົ່າ ການໍ່ອ໌ ຄຶ່ດ ປາຍ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ.' ");
INSERT INTO ncq_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","ມູ່ ເຍືາ ຕັຮ ຄານອດ ກາ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ດໍອ໌, ເຈີ່ ເຍືາ ຊາງັດ ປັຣນາຍ ກາ ກວາຍ ອາຕີ ດໍອ໌ ແອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ເຈີ່ ເຢຊູ ອາຕີ ແອັນ ປາຍ: \"ເຍືາ ຣາໄງ່ອ໌ ລາລື່ ອີ ຕັຮ ປັຣນາຍ ປາຕັບ ແຕ ເຢືາງ ເຈົາຣາຊີ, ກະ ເຍືາ ຕະ ຕາປູ່ນ ຣີ່ດ ເຍືາ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ໂມເຊ ອາຕີ ປາຍ: 'ອຶງເຄາະ ເຍືາ ຢຳນັ່ບ ອຶມເປ່ອ໌ ອຶມປໍ່ ເຍືາ,' ກະ ອັນ ປາຍ 'ກວາຍ ອາແລ່ະ ກາ ພາມາດ ອຶມເປ່ອ໌ ອຶມປໍ່, ກວາຍ ກັອຍ ອຶງເຄາະ ຈີວ໌ ກູຈີດ.' ");
INSERT INTO ncq_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ມາ ມູ່ ເຍືາ ອາຕີ ປາຍ: 'ຄັນ ກວາຍ ອາແລ່ະ ມາ ເບີນ ເກຣີ່ງ ກາ ອັນ ເຕ່ອ໌ ຈ່ອຍ ອຶມເປ່ອ໌ ອຶມປໍ່ ອັນ, ມາ ອັນ ປາຍ ເກຣີ່ງ ກັອຍ ອັນ ເອີອ໌ ອີ ຊາງ ໂອນ ເຢືາງ ເຈົາຣາຊີ ເຈີ່, ");
INSERT INTO ncq_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ນ່ະກັອຍ ອັນ ຕາ ເບີນ ຕຸ່ຮ ຈ່ອຍ ນັ່ອງ ອຶມເປ່ອ໌ ອຶມປໍ່ ອັນ.' ");
INSERT INTO ncq_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ນ່ະກັອຍ ເຍືາ ອີດ ຣີ່ດ ອາຈວາຍຮ ອາເຈ່ຮ ເຍືາ ເບີມ ເຕ່ນ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ. ກະ ຊາອຶ່ຍ ຣາມຶ່ຮ ການໍ່ອ໌ ເຍືາ ດຸ ຕະ ນ່ະກັອຍ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ເຢຊູ ກູອ໌ ຊາ ມັຮ ກອນແຊມ, ກະ ອາຕີ ໄລ່ ປາຍ: \"ໂອນ ເຍືາ ຊາງັດ ກຣັ່ກ ປັຣນາຍ ເກົາ ອີ ອາຕີ ໂອນ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ກູ່ ຣາມຶ່ຮ ມັຮ ກາ ກວາຍ ຈາ ຕາ ເບີນ ຕະ ໂອນ ກວາຍ ແກີດ ໂລ່ຍຮ. ມາ ມັຮ ຣາມຶ່ຮ ຕາ ອໍ ກາ ລັ່ອຮ ແຕ ຣາງຶ່ຮ ກວາຍ ຕະ ໂອນ ກວາຍ ແກີດ ຕາ ເບີນ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(ອາແລ່ະ ກາ ເບີນ ກູຕູຣ, ໂອນ ອັນ ຊາງັດ ເບີມ.) ");
INSERT INTO ncq_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ພໍກາ ເຢຊູ ຣາຕັຮ ແຕ ກວາຍ ກຼຶ່ງ ກັອຍ, ເຈີ່ ອັນ ມູ່ດ ຕຶ່ງ ດຸງ. ມູ່ ກາ ຣຍານ ແຕ ອັນ ຕາແບີບ ອັນ ແຕ ປັຣນາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ນານ່ະ ເຍືາ ອຶນນັ່ອງ ຕາ ເບີນ ດັງ? ເຍືາ ຕາ ຢວາຮ ຊາປຸ່ຮ ກູ່ ຣາມຶ່ຮ ມັຮ ກາ ກວາຍ ຈາ ຕາ ເບີນ ຕະ ໂອນ ກວາຍ ແກີດ ໂລ່ຍຮ, ");
INSERT INTO ncq_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ຍ່ອນ ກູ່ ຣາມຶ່ຮ ກັອຍ ຕາ ເບີນ ມູ່ດ ຕຶ່ງ ຣາງຶ່ຮ, ມາ ອັນ ມູ່ດ ຕຶ່ງ ປຸ່ງ; ເຈີ່ ໄຮ ເປາະ ອຶມປຸ່ງ ຕັຮ.\" (ເຢຊູ ປາຍ ປັຣນາຍ ໄນ່ ອາຕີ ໂອນ ດັງ ຊັຣນາ ກູ່ ຣາມຶ່ຮ ລາ ຈາ ເບີນ ອຶນແຍ່ະ.) ");
INSERT INTO ncq_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ເຈີ່ ເຢຊູ ຕະ ອຶນຕີ ປາຍ: \"ມັຮ ຣາມຶ່ຮ ຕາ ອໍ ກາ ລັ່ອຮ ແຕ ຣາງຶ່ຮ ກວາຍ ກັອຍ, ກາ ຕະ ໂອນ ກວາຍ ແກີດ ຕາ ເບີນ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ມັຮ ຣາມຶ່ຮ ຕາມມັຮ ກັອຍ ລາ ນ່ະໄນ່: ເບີນ ມັນແຊມ ຣາເລົາ ຕະ ໂລ່ຍຮ, ຕູຕວຍ໌, ກາຈີດ ກວາຍ, ປັຣລື່ຍ ລາກວຍ ເນົ່າ ແຕີລາ ກາຢາອ໌ ເນົ່າ, ");
INSERT INTO ncq_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ກຸມປູ່ຣ ເກຣີ່ງ ເນົ່າ, ຕະ ຕາ ອໍ ໂຈະ ເຢົ່າ, ອາໂລກ ເຢົ່າ, ຕະ ຣານະ ກູມາລ, ຊັຣແມງ ເຢົ່າ, ຕາແມີຍຮ ເຢົ່າ, ຍ່ອງ ຈະ ເບີມ, ຕະ ຣານະ ຊາກູລ. ");
INSERT INTO ncq_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ອຶນແຍ່ະ ມັຮ ຣາມຶ່ຮ ໄນ່ ລັ່ອຮ ແຕ ຣາງຶ່ຮ ກວາຍ ກະ ຕະ ໂອນ ກວາຍ ແກີດ ໂລ່ຍຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ເຢຊູ ລັ່ອຮ ແຕ ກັອຍ, ເຈີ່ ອັນ ເປາະ ປໍ ເມືອງ ຕີເຣ. ເຢຊູ ມູ່ດ ປໍ ມວຍ ດຸງ ຕຶ່ງ ເມືອງ ກັອຍ ມາ ຕາ ເບີນ ໂອນ ເນົ່າ ດັງ ປາຍ ອັນ ແອີດ ອຶງກັອຍ, ມາ ເຢຊູ ຕາ ເຕ່ອ໌ ໂຕ່ະ. ");
INSERT INTO ncq_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ຕຶ່ງ ເມືອງ ກັອຍ ເບີນ ມັນແຊມ ມານະ ກາ ເຢືາງ ຕາ ອໍ ຕຣວບ ກອນ ກູໂມຣ ອັນ. ພໍກາ ອັນ ຊັອງ ປາຍ ເຢຊູ ແຕີ່ອ໌, ເຈີ່ ອັນ ເປາະ ປໍ ເຢຊູ ກະ ອັນ ຄຣາບ ອາແຊງ ຢັ່ຮ ເມືາງ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ມັນແຊມ ກັອຍ ລາ ກວາຍ ກຣີກ; ອັນ ແກີດ ຕຶ່ງ ໂພນີເຊຍ ແຄງ ຊີເຣຍ. ອັນ ແຊອ໌ ກູກຸຮ ກູກວຍ ແຕ ເຢຊູ ໂອນ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ແຕ ຈະ ກອນ ກູໂມຣ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ເຈີ່ ເຢຊູ ຕາແອີຍ ປາຍ: \"ໂອນ ມັຮ ກາ ກັຣແນນ ຈາ ປາໄຊ ເວືາຍ. ຕາ ເບີນ ປຍາຍ໌ ຄັນ ອີດ ຊັຣນາ ກັຣແນນ ຊາດຸຮ ໂອນ ອາຈໍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ມັນແຊມ ກັອຍ ຕາແອີຍ ປາຍ: \"ເມ່ນ ເຈີ່! ມາ ອາຈໍ ກາ ແອີດ ປື່ນ ກາເຈີ່ງ ອຶນເນີ່ມ ເບີນ ຈາ ມັຮ ກາ ອຶງກັຮ ກັຣແນນ ຕັຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ເຈີ່ ເຢຊູ ອາຕີ ໂຈະ ອັນ ປາຍ: \"ຍ່ອນ ປັຣນາຍ ໄມ່ ຕະ ອຶນຕີ ນ່ະກັອຍ, ເຕ່ອ໌ ໄມ່ ເຈົາ ເຈີ່. ເຢືາງ ຕາ ອໍ ລັ່ອຮ ເຈີ່ ແຕ ຈະ ກອນ ໄມ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ພໍກາ ມັນແຊມ ກັອຍ ເຈົາ ແຕີ່ອ໌ ດຸງ, ອັນ ເຮີມ ກອນ ກູໂມຣ ອັນ ແອີດ ຕຶ່ງ ກາເຈີ່ງ, ກະ ເຢືາງ ຕາ ອໍ ລັ່ອຮ ເຈີ່ ແຕ ຈະ ກອນ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ພໍກາ ເຢຊູ ລັ່ອຮ ແຕ ເມືອງ ຕີເຣ ເປາະ ຊາລັຮ ຣານາ ເມືອງ ຊີໂດນ, ເຈີ່ ອັນ ເປາະ ປໍ ເມືອງ ເດກາໂປລີ ແຈ່ະ ທາເລ ຣາປັ່ງ ຄາລີເລ. ");
INSERT INTO ncq_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ເບີນ ກວາຍ ເດີງ ມານະ ຣາເລົາ ກາ ຕຸ່ງ ກູຕູຣ ແບອ໌ ເກີອ໌ ແຕີ່ອ໌ ປໍ ເຢຊູ ກະ ໄລ່ ແຊອ໌ ໂອນ ເຢຊູ ຊາປ່ະ ອາຕີ ຕຶ່ງ ຈະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ເຢຊູ ເດີງ ກວາຍ ກາ ຕຸ່ງ ກູຕູຣ ກະ ແບອ໌ ເກີອ໌ ກັອຍ ລັ່ອຮ ແຕ ກວາຍ ກຼຶ່ງ, ເຈີ່ ອັນ ອີດ ກັລດອຍ ອາຕີ ບາຣ ກັ່ຮ ເຈີ່ ຈວາຍ໌ ກູຕູຣ ກວາຍ ກັອຍ. ອັນ ກູຈົຮ ໂຈະ ຕຶ່ງ ອາຕີ ອັນ ເຈີ່ ອັນ ອາແຕັດ ໂຈະ ເລືາຍຮ ກວາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ເຢຊູ ຕາເງີ່ອ໌ ອາຊັອຮ ປໍ ມັນລັ່ອງ, ເຈີ່ ອັນ ຊາງົ່ຮ ກະ ອາຕີ ປາຍ: \"ເອພາທາ!\" ປັຣນາຍ ໄນ່ ອາຕີ ລັ່ຮ ປາຍ: \"ໂອນ ເປິຮ ອາລັ່ອຮ!\" ");
INSERT INTO ncq_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ເຈີ່ ກູຕູຣ ກວາຍ ຕຸ່ງ ກັອຍ ເຕ່ອ໌ ຊັອງ, ກະ ເລືາຍຮ ອັນ ແກີດ ລາເມ່ນ ອໍ, ເຕ່ອ໌ ຕະ ອຶນຕີ. ");
INSERT INTO ncq_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ເຢຊູ ອາຕີ ມັຮ ກອນແຊມ ປາຍ: \"ອຶນໂຈຍ ອາຕີ ໂອນ ອາແລ່ະ ດັງ ຣານະ ໄນ່.\" ເຢຊູ ປາຕັບ ຊາອຶ່ຍ ຕໍ່, ມາ ໄລ່ ແຮງ ອາຕີ ໂອນ ກວາຍ ດັງ ຊາອຶ່ຍ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ມັຮ ກາ ກອນແຊມ ກັອຍ ໄລ່ ຊັອງ ງຶ່ດ ລາລື່ ກະ ໄລ່ ປາຍ: \"ກູ່ ຣາມຶ່ຮ ກາ ອັນ ຕະ ແອີງ ອໍ ອຶນແຍ່ະ. ກະ ກວາຍ ກາ ກູຕູຣ ຕຸ່ງ ອັນ ຕະ ໂອນ ເຕ່ອ໌ ຊັອງ. ກວາຍ ກາ ເກີອ໌ ອັນ ຕະ ໂອນ ເຕ່ອ໌ ຕະ ອຶນຕີ ແອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ແວັດ ກັອຍ ຕາ ເບີນ ດູ່ນ, ກອນແຊມ ກຼຶ່ງ ລາລື່ ແຕີ່ອ໌ ໂຣ່ມ ຊາ. ພໍກາ ໄລ່ ຕາ ເບີນ ອຶນເຕົ່າ ອີ ຈາ, ເຢຊູ ກູອ໌ ມູ່ ກາ ຣຍານ ແຕ ອັນ, ກະ ອັນ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","\"ເກົາ ອາໂຢ່ະ ຕະ ກວາຍ ຈຸ່ມ ໄນ່, ຍ່ອນ ໄລ່ ແອີດ ອາລຶ່ງ ໄຮ ໄປ ຕາໄງ ເຈີ່, ກະ ໄລ່ ຕາ ເບີນ ອຶນເຕົ່າ ອີ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ຄັນ ເກົາ ໂອນ ໄລ່ ເຈົາ ປໍ ວີ່ລ ແຕີລາ ປໍ ເມືອງ ໄລ່ ບັອງ ກາ ໄລ່ ມາເຍືາຍຮ, ອຶງກັອຮ ໄລ່ ອຽວ໌ ຕຶ່ງ ຣານາ. ຍ່ອນ ເບີນ ອັນ ກາ ແຕີ່ອ໌ ແຕ ເຢີ່ງ.\" ");
INSERT INTO ncq_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ມູ່ ກາ ຣຍານ ແຕ ອັນ ຕາແອີຍ ປາຍ: \"ຕຶ່ງ ຕຍາຮ ນ່ະໄນ່, ແຕ ແລ່ະ ຮິ ອີ ຈໍ່ອ໌ ໂດຍ ຣາແວັ່ຮ ອີ ໂອນ ໄລ່ ຈາ ປາໄຊ?\" ");
INSERT INTO ncq_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ເຢຊູ ອາເບຼິຮ ໄລ່ ປາຍ: \"ເຍືາ ເບີນ ໂດຍ ບຸຮ ອຶນຊິ ລຳ?\" ໄລ່ ຕາແອີຍ ປາຍ: \"ຮິ ເບີນ ຕາປູ່ລ ລຳ.\" ");
INSERT INTO ncq_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ເຢຊູ ອາຕີ ກວາຍ ກຼຶ່ງ ກັອຍ ໂອນ ໄລ່ ຕາກູ ຕຶ່ງ ກູແຕອ໌. ເຈີ່ ເຢຊູ ອີດ ໂດຍ ບຸຮ ຕາປູ່ລ ລຳ ກັອຍ ເຈີ່ ເກົາ ຊາແອີນ ເຢືາງ ເຈົາຣາຊີ, ເຈີ່ ອັນ ປີຮ ໂດຍ ບຸຮ ໂອນ ມູ່ ກາ ຣຍານ ແຕ ອັນ ເປາະ ອຶມແປອ໌ ໂອນ ມັຮ ກາ ກວາຍ ກຼຶ່ງ ກັອຍ ກູ່ ນະ. ");
INSERT INTO ncq_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ກະ ໄລ່ ເບີນ ອາກາ ແກດ ບາຣ ໄປ ລຳ. ເຈີ່ ເຢຊູ ອີດ ອາກາ ກັອຍ ຊາແອີນ ເຢືາງ ເຈົາຣາຊີ, ກະ ເຢຊູ ໂອນ ປໍ ມູ່ ກາ ຣຍານ ແຕ ອັນ ເປາະ ອຶມແປອ໌ ໂອນ ກວາຍ ກຼຶ່ງ ກັອຍ ຊາ. ");
INSERT INTO ncq_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ກູ່ ນະ ໄລ່ ຈາ ປາໄຊ ອຶນແຍ່ະ; ເຈີ່ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ປາໂຣມ ລັ່ຮ ມັຮ ອຶງກັຮ ກາ ແກຼີຍ ແຕ ໄລ່ ຈາ ເບີນ ຕາປູ່ລ ກາເຣຍ. ");
INSERT INTO ncq_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ຕຶ່ງ ອຶນຕຸ ກັອຍ ເບີນ ກວາຍ ປູນ ປັ່ນ ນະ ຣາເລົາ ກາ ເບີນ ຈາ; ເຈີ່ ເຢຊູ ອາຕີ ໂອນ ໄລ່ ເຈົາ ປໍ ວີ່ລ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ເຈີ່ ແວັດ ກັອຍ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ຈິ່ຮ ຕົວະ ເປາະ ປໍ ເມືອງ ດານມານຸທາ. ");
INSERT INTO ncq_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ຈຸ່ມ ພາຣີຊາຍ ແຕີ່ອ໌ ປໍ ເຢຊູ. ເຈີ່ ໄລ່ ຣາຈຽນ ກະ ອັນ, ໄລ່ ແຊອ໌ ແຕ ເຢຊູ ໂອນ ອັນ ຕະ ຣານະ ອາປັຮ ໂອນ ໄລ່ ດັງ ອຳນາດ ອັນ ແຕີ່ອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ເຢຊູ ຊາງົ່ຮ, ເຈີ່ ອັນ ອາເບຼິຮ ໄລ່ ປາຍ: \"ອຶນເຕົ່າ ກາ ຕະ ກວາຍ ແດີຍ ຊານໍ່ ມັ່ກ ຈາຈໍ່ອ໌ ຣານະ ກາ ຕາ ເກີ່ຍ ເຮີມ? ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ ປາຍ ເກົາ ຕາ ເບີນ ອີ ອາລັ່ອຮ ຣານະ ກາ ຕາ ເກີ່ຍ ເຮີມ ໂອນ ເຍືາ ເຮີມ ຊານໍ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ເຈີ່ ເຢຊູ ແຊງ ຈິ່ຮ ຕົວະ ໄກ່ອ໌໌ ທາເລ ຣາປັ່ງ ເປາະ ປໍ ປຶ່ຮ ອຶນຕົ່ຮ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ຊາລີຣ ອີດ ເດີງ ໂດຍ ບຸຮ, ກະ ໄລ່ ເບີນ ໂດຍ ບຸຮ ມານຳໆ ຕຶ່ງ ຕົວະ. ");
INSERT INTO ncq_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ເຢຊູ ອາຕີ ໄລ່ ປາຍ: \"ເຍືາ ເນ່ ອໍ! ໂອນ ເຍືາ ລາວັ່ງ ບວຮ ຊື່ອ໌ ແຕ ຈຸ່ມ ພາຣີຊາຍ ກະ ຈຸ່ມ ເຮໂຣດ.\" ");
INSERT INTO ncq_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ໄລ່ ກາ ຣຍານ ແຕ ອັນ ມານະ ຣາໂຊ ມານະ ປາຍ: \"ເຮີມ ອັນ ປາຍ ນ່ະກັອຍ ຍ່ອນ ໄຮ ຕາ ເບີນ ເດີງ ໂດຍ ບຸຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ເຢຊູ ດັງ ເຈີ່ ໄລ່ ຄຶ່ດ ນ່ະກັອຍ, ເຈີ່ ອັນ ອາເບຼິຮ ປາຍ: \"ນານ່ະ ເຍືາ ປາຍ ຍ່ອນ ເຍືາ ຕາ ເບີນ ເດີງ ໂດຍ ບຸຮ? ເຍືາ ຕາ ດັງ ຢວາຮ ບໍ? ຣາງຶ່ຮ ເຍືາ ອຶນນັ່ອງ ການຳ ປິງ ບໍ? ");
INSERT INTO ncq_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ເຍືາ ເບີນ ມັ່ດ ມາ ເຍືາ ຕາ ເບີນ ເຮີມ; ເຍືາ ເບີນ ກູຕູຣ ມາ ເຍືາ ຕາ ເບີນ ຊັອງ. ເຍືາ ເຈີ ມາ ຕາ ເບີນ? ");
INSERT INTO ncq_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ບັອງ ກາ ເກົາ ປີຮ ໂດຍ ບຸຮ ເຊີງ ລຳ ໂອນ ກວາຍ ເຊີງ ປັ່ນ ນະ, ເຍືາ ຕາໂຣມ ມັຮ ອຶງກັຮ ກັອຍ ເບີນ ອຶນຊິ ກາເຣຍ?\" ໄລ່ ຕາແອີຍ ປາຍ: \"ມັນຈິ່ດ ລາ ບາຣ ກາເຣຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ເຢຊູ ອາເບຼິຮ ໄລ່ ປາຍ: \"ບັອງ ກາ ເກົາ ປີຮ ໂດຍ ບຸຮ ຕາປູ່ລ ລຳ ໂອນ ກວາຍ ປູນ ປັ່ນ ນະ ກັອຍ, ເຍືາ ຕາໂຣມ ມັຮ ອຶງກັຮ ກັອຍ ເບີນ ອຶນຊິ ກາເຣຍ?\" ໄລ່ ຕາແອີຍ ປາຍ: \"ເບີນ ຕາປູ່ລ ກາເຣຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ເຈີ່ ເຢຊູ ອາເບຼິຮ ໄລ່ ປາຍ: \"ເຍືາ ອຶນເນີ່ມ ຕາ ຢວາຮ ດັງ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ເຈີ່ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ມູ່ດ ປໍ ເມືອງ ເບັດຊາອີດາ. ກວາຍ ຕຶ່ງ ເມືອງ ກັອຍ ເດີງ ອາແຕີ່ອ໌ ປໍ ເຢຊູ ມານະ ກວາຍ ຣາເລົາ ຊູດ ມັ່ດ, ກະ ໄລ່ ແຊອ໌ ໂອນ ເຢຊູ ຊາປ່ະ ຈະ ກວາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ເຢຊູ ເຕິ ອາຕີ ກວາຍ ຊູດ ມັ່ດ ກັອຍ ເດີງ ປໍ ນໍ່ອ໌ ເມືອງ. ອັນ ກູຈົຮ ໂຈະ ມັ່ດ ກວາຍ ກັອຍ, ເຈີ່ ອັນ ຊາປ່ະ ອາຕີ ໂຈະ ກວາຍ ກັອຍ ກະ ອັນ ອາເບຼິຮ ປາຍ: \"ອຶນເຕົ່າ ດິ ໄມ່ ເຮີມ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ກວາຍ ຊູດ ມັ່ດ ກັອຍ ຕາເງີ່ອ໌ ອາຊັອຮ, ເຈີ່ ອັນ ຕາແອີຍ ປາຍ: \"ເກົາ ເຮີມ ກວາຍ ແກີດ ນ່ະ ກັ່ລ ອາລ່ອງ ອຶນຕະ ຣາວີ່ລ ຣາວື່ລ.\" ");
INSERT INTO ncq_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ເຢຊູ ຊາປ່ະ ອາຕີ ໂຈະ ມັ່ດ ກວາຍ ກັອຍ ຊາ. ກວາຍ ກັອຍ ອັນ ເຕ່ອ໌ ກູເລືານ ລັ່ຮ, ເຈີ່ ມັ່ດ ກວາຍ ກັອຍ ແກີດ ປັ່ງ ລັ່ຮ ກະ ອັນ ເຮີມ ກູ່ ຣາມຶ່ຮ ປັ່ງ ອໍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ເຢຊູ ອາຕີ ໂອນ ອັນ ເຈົາ ປໍ ດຸງ, ກະ ອາຕີ ປາຍ: \"ໄມ່ ອຶນໂຈຍ ມູ່ດ ຕະ ອຶນຕີ ໂອນ ກວາຍ ຕຶ່ງ ເມືອງ ກັອຍ ດັງ ນໍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ແວັດ ກັອຍ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ເປາະ ປໍ ມັຮ ວີ່ລ ກາ ແອີດ ອຶມແປຣ ເມືອງ ກາຍຊາເຣຍ ພີລິບປອຍ. ບັອງ ກາ ໄລ່ ເປາະ, ເຢຊູ ອາເບຼິຮ ໄລ່ ປາຍ: \"ມັຮ ກາ ກວາຍ ປາຍ ເກົາ ລາ ເນົ່າ?\" ");
INSERT INTO ncq_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ມູ່ ກາ ຣຍານ ແຕ ອັນ ຕາແອີຍ ປາຍ: \"ເບີນ ອັນ ກາ ປາຍ ອາຈານ ລາ ໂຢຮັນ, ອັນ ກາ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌. ເບີນ ອັນ ກາ ປາຍ ອາຈານ ລາ ເອລີຢາ. ເບີນ ອັນ ກາ ປາຍ ອາຈານ ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ເຈີ່ ເຢຊູ ອາເບຼິຮ ໄລ່ ປາຍ: \"ເຍືາ ແອັນ ປາຍ ເກົາ ລາ ເນົ່າ?\" ເປໂຕ ຕາແອີຍ ປາຍ: \"ອາຈານ ລາ ກຣີດ, ອັນ ກາ ເຢືາງ ເຈົາຣາຊີ ໂອນ ຈ່ອຍ ອາມົ່ງ ກວາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ເຢຊູ ປາຕັບ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ອຶນໂຈຍ ອາຕີ ໂອນ ອາແລ່ະ ດັງ ແຕ ຣານະ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ເຈີ່ ເຢຊູ ຕາແບິ ອາຕີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ເກົາ ລາ ກອນ ເຢືາງ ແກີດ ກວາຍ ອຶງເຄາະ ຈີວ໌ ຕຸ່ຮ ກັ່ດ ຊາອຶ່ຍ ຣາມຶ່ຮ. ກະ ກວາຍ ເທົາແກ ຈຸ່ມເຈືອ, ມູ່ ກາ ຊົດ ຊາງ ຣີ່ດ, ກະ ກວາຍ ອາຕີ ຄານອດ, ໄລ່ ຊາອັຣ ກະ ອວານ ເກົາ, ກະ ໄລ່ ກາຈີດ ຕັຮ ເກົາ. ມາ ແຕີ່ອ໌ ຕາໄງ ໄປ ເກົາ ອາມົ່ງ ລັ່ຮ ແຕ ກູຈີດ.\" ");
INSERT INTO ncq_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ເຢຊູ ຕະ ອຶນຕີ ໂອນ ໄລ່ ດັງ ກູ່ ຣາມຶ່ຮ. ເປໂຕ ເດີງ ເຢຊູ ລັ່ອຮ ເປາະ ຕະ ອຶນຕີ ປໍ ນໍ່ອ໌ ແອີງ ໄລ່ ບາຣ ນະ ຊັອງ. ເຈີ່ ອັນ ກາແອັຮ ຕາ ໂອນ ເຢຊູ ຕະ ອຶນຕີ ນັ່ອງ ນ່ະກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ເຢຊູ ກູລຍານ ຊາລີອ໌ ປໍ ມູ່ ກາ ຣຍານ ແຕ ອັນ ກະ ອັນ ກາແອັຮ ເປໂຕ ປາຍ: \"ໄມ່ ເປາະ ເຢີ່ງ ແຕ ເກົາ, ຊາຕານ! ໄມ່ ຕາ ເບີນ ຄຶ່ດ ນ່ະ ເຢືາງ ເຈົາຣາຊີ! ມາ ໄມ່ ຄຶ່ດ ນ່ະ ກວາຍ ຊັອງ!\" ");
INSERT INTO ncq_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ແວັດ ກັອຍ ເຢຊູ ກູອ໌ ກວາຍ ກຼຶ່ງ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ໂອນ ແຕີ່ອ໌ ປໍ ອັນ, ເຈີ່ ອັນ ປາຍ: \"ຄັນ ກວາຍ ອາແລ່ະ ຢໍອ໌ ອີ ປວາຍ ເກົາ ອຶງເຄາະ ກວາຍ ກັອຍ ອຶນໂຈຍ ອີດ ຣາງຶ່ຮ ອັນ ເບີມ, ມາ ອຶງເຄາະ ອັນ ອີດ ໂດລ ອາລ່ອງ ຊັງກັງ ອັນ ເບີມ, ກະ ອຶງເຄາະ ອັນ ປວາຍ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ກວາຍ ອາແລ່ະ ກາ ປາຊິ ຣາງຶ່ຮ ອັນ ຕຶ່ງ ແດີຍ ໄນ່, ຣາງຶ່ຮ ກວາຍ ກັອຍ ປິ່ດ ເມືາດ. ມາ ກວາຍ ອາແລ່ະ ກາ ຈີວ໌ ປິ່ດ ຣາງຶ່ຮ ອັນ ຍ່ອນ ອັນ ປວາຍ ເກົາ ກະ ຍ່ອນ ອັນ ອາຕີ ປັຣນາຍ ອໍ ແຕ ເກົາ, ຣາງຶ່ຮ ກວາຍ ກັອຍ ຕາ ເບີນ ແກີດ ປິ່ດ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ກວາຍ ອາແລ່ະ ກາ ເບີນ ຕຸ່ກ ມາເລ່ກ ແຊກ ມາການ ເກຣີ່ງ ເກຣົ່າ ຕຶ່ງ ແດີຍ ໄນ່, ມາ ອັນ ປິ່ດ ຊັອງ ຣາງຶ່ຮ ອັນ ເບີມ, ອຶນເຕົ່າ ລະ ເກືາ ໂອນ ອັນ? ");
INSERT INTO ncq_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ຕາ ເບີນ ເກຣີ່ງ ອຶນເຕົ່າ ກວາຍ ເຕ່ອ໌ ຣາປຽນ ໂອນ ອາມົ່ງ ຊົດ ແດີຍ ເລີ່ຍ ກູມໍ. ");
INSERT INTO ncq_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ຄັນ ກວາຍ ອາແລ່ະ ມາ ກູມາລ ຕະ ແຕ ເກົາ ກະ ກູມາລ ຕະ ແຕ ປັຣນາຍ ເກົາ ຕຶ່ງ ແດີຍ ຊານໍ່ ກາ ຕາ ເບີນ ຕານັ່ອງ ກະ ຕາ ເບີນ ຕາປູ່ນ ເຢືາງ ເຈົາຣາຊີ, ເກົາ ກອນ ເຢືາງ ແກີດ ກວາຍ ກູມາລ ຕະ ລັ່ຮ ແຕ ກວາຍ ກັອຍ ພໍກາ ເກົາ ແຕີ່ອ໌ ປໍ ກູແຕອ໌ ໄນ່. ຕາໄງ ກັອຍ ເກົາ ເບີນ ອາງອື່ຣ ແຕ ອຶມປໍ່ ເກົາ ກະ ອຶມປຣ່ອມ ເປາະ ກະ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ກາ ຕາ ເບີນ ໂລ່ຍຮ ອຶນເຕົ່າ.\" ");
INSERT INTO ncq_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ເຈີ່ ເຢຊູ ຕະ ອຶນຕີ ໂຈະ ໄລ່ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ: ເບີນ ກວາຍ ກາ ຕາຢຶ່ງ ແອີດ ອຶນໄນ່, ໄລ່ ຕາ ເບີນ ກູຈີດ ຢວາຮ ເຕົ່າ ແຕີ່ອ໌ ໄລ່ ເຮີມ ອຳນາດ ເຢືາງ ເຈົາຣາຊີ ແຕີ່ອ໌ ປໍ ກູແຕອ໌ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ແວັດ ຕາປັ່ດ ຕາໄງ ເຢຊູ ເດີງ ເປໂຕ, ຢາໂກໂບ, ກະ ໂຢຮັນ ຊັອຮ ປໍ ກົຮ ກາ ຕີ່. ແອີດ ຕຶ່ງ ກົຮ ກັອຍ ແອີງ ໄລ່ ປູນ ນະ ຊັອງ. ເຈີ່ ໄລ່ ເຮີມ ຈະ ເຢຊູ ປຽນ ຢັ່ຮ ເມືາງ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ກົນ ອາຢັ່ອຮ ເຢຊູ ແກີດ ກຼໍອ໌ ຊັຣມຍາລ ມັ່ດ. ຕາ ເບີນ ກວາຍ ອາແລ່ະ ຕຶ່ງ ກູແຕອ໌ ໄນ່ ເຕ່ອ໌ ປົ່ຮ ໂອນ ກຼໍອ໌ ນ່ະກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ເຈີ່ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ຊັນຕັຣ ເຮີມ ເອລີຢາ ກະ ໂມເຊ ແອີດ ຕະ ອຶນຕີ ກະ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ເປໂຕ ອາຕີ ເຢຊູ ປາຍ: \"ອາຈານ ເອີຍ! ອໍ ລາລື່ ໄຮ ເບີນ ແອີດ ອຶນໄນ່. ມາ ຮິ ອີ ຕະ ໄປ ລໍາ ຊູ, ມານຳ ລາ ຕະ ໂອນ ອາຈານ, ມານຳ ລາ ຕະ ໂອນ ໂມເຊ, ມານຳ ແອັນ ລາ ຕະ ໂອນ ເອລີຢາ. ");
INSERT INTO ncq_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ເປໂຕ ຕະ ອຶນຕີ ນ່ະກັອຍ ລາ ອັນ ຕາ ດັງ ອີ ປາຍ ອຶນເຕົ່າ, ຍ່ອນ ໄລ່ ກາ ຣຍານ ໄປ ນະ ຊັອງ ອຶງກັອຮ ຮັບ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ເຈີ່ ເບີນ ຣາມິ່ລ ແຕີ່ອ໌ ປໍ ກັອຍ ເຈີ່ ຕວມ ດໍອ໌ ຈະ ໄລ່. ເບີນ ມວຍ ປັຣນາຍ ລັ່ອຮ ແຕ ຣາມິ່ລ ກັອຍ ປາຍ: \"ໄນ່ ລາ ກອນ ເກົາ ກາ ເກົາ ອາໂຢ່ະ ລາລື່; ອຶງເຄາະ ເຍືາ ຊາງັດ ອັນ ນໍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ແວັດ ກັອຍ ໄລ່ ໄປ ນະ ກູເລືານ ເນ່ ລັ່ຮ ບັອງ ກາ ໄລ່ ຊັອງ ປັຣນາຍ ກັອຍ, ມາ ໄລ່ ຕາ ເບີນ ເຮີມ ອຶນເຕົ່າ ນັ່ອງ. ມານະ ເຢຊູ ແຕິ່ ແອີດ ກະ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ບັອງ ກາ ໄລ່ ຕາຢັຮ ອາແຊງ ແຕ ກົຮ, ເຢຊູ ອາຕີ ໄລ່ ຕາ ໂອນ ເປາະ ອາຕີ ໂອນ ອາແລ່ະ ດັງ ກູ່ ຣາມຶ່ຮ ກາ ໄລ່ ເຮີມ, ເຕົ່າ ແຕີ່ອ໌ ກອນ ເຢືາງ ແກີດ ກວາຍ ໂມ່ຍຮ ລັ່ຮ ແຕ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ມູ່ ກາ ຣຍານ ໄປ ນະ ກັອຍ ໄລ່ ຕະ ຕາປູ່ນ ເຢຊູ ອາຕີ, ມາ ມານະ ອາເບຼິຮ ມານະ ປາຍ: \"ອຶນເຕົ່າ ອັນ ປາຍ ໂມ່ຍຮ ລັ່ຮ ແຕ ກູຈີດ ກັອຍ?\" ");
INSERT INTO ncq_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ໄລ່ ອາເບຼິຮ ເຢຊູ ປາຍ: \"ນານ່ະ ມັຮ ກວາຍ ອາຕີ ຄານອດ ກະ ກວາຍ ອິດຊະຣາເອລ ປາຍ ເອລີຢາ ອຶງເຄາະ ແຕີ່ອ໌ ອຶນໂຍ່ງ ກຣີດ?\" ");
INSERT INTO ncq_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ເຢຊູ ຕາແອີຍ ປາຍ: \"ເມ່ນ ເຈີ່ ເອລີຢາ ແຕີ່ອ໌ ອຶນໂຍ່ງ, ກະ ອັນ ແຕີ່ອ໌ ຕະ ໂອນ ກູ່ ຣາມຶ່ຮ ແກີດ ນ່ະ ຕຍາ ລັ່ຮ. ມາ ນ່ະ ແຕ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ຄຽນ ດໍອ໌ ປາຍ ກອນ ເຢືາງ ແກີດ ກວາຍ ອຶງເຄາະ ຕຸ່ຮ ກັ່ດ ຊາອຶ່ຍ ຣາມຶ່ຮ ກະ ເນົ່າ ພາມາດ ອັນ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ມາ ເກົາ ອາຕີ ເຍືາ ປາຍ ເອລີຢາ ແຕີ່ອ໌ ເຈີ່; ອຶນເຕົ່າ ໄລ່ ຢໍອ໌ ອີ ຕະ ໂຈະ ອັນ ໄລ່ ຕະ ນ່ະກັອຍ, ມູເຈິງ ເນົ່າ ຄຽນ ດໍອ໌ ເຈີ່ ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ພໍກາ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ໄປ ນະ ເຈົາ ລັ່ຮ ປໍ ອຶນຕຸ ມູ່ ກາ ຣຍານ ແຕ ອັນ ການໍ່ອ໌ ແອີດ ເກຣາະ, ເບີນ ກວາຍ ກຼຶ່ງ ລາລື່ ໂຣ່ມ ອຶງກັອຍ, ກະ ມັຮ ກວາຍ ອາຕີ ຄານອດ ຣາຈຽນ ກະ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ເຈີ່ ມັຮ ກາ ກວາຍ ກັອຍ ງຶ່ດ ລາລື່ ພໍກາ ໄລ່ ເຮີມ ເຢຊູ ແຕີ່ອ໌, ເຈີ່ ໄລ່ ປາລັອງ ຕາໂຣ່ອ໌ ປໍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ເຢຊູ ອາເບຼິຮ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ອຶນເຕົ່າ ເຍືາ ຣາຈຽນ?\" ");
INSERT INTO ncq_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ເບີນ ຣາເລົາ ມານະ ແຕ ກວາຍ ກຼຶ່ງ ຕາແອີຍ ປາຍ: \"ອາຈານ ເອີຍ! ເກົາ ເດີງ ກອນ ຣາເລົາ ເກົາ ເປາະ ປໍ ໄມ່, ຍ່ອນ ເຢືາງ ຕາ ອໍ ຕຣວບ ກອນ ເກົາ ເຕົ່າ ອັນ ຕາ ແກີດ ຕະ ອຶນຕີ. ");
INSERT INTO ncq_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ແຕີ່ອ໌ ເຢືາງ ກັອຍ ຕຣວບ, ອັນ ຕະ ໂອນ ກັຣແນນ ແດິມ, ກະ ອັນ ໂອນ ກັຣແນນ ກັອຍ ແກີດ ດາແດັຮ ກະ ແກີດ ປູປົ່ຮ ແບອ໌ ກະ ອັນ ກາເຕຣືອກ ກາແນງ, ເຈີ່ ອັນ ແກີດ ກັ່ອງ ອຶນແຍ່ະ ຈະ. ນ່ະກັອຍ ເກົາ ໂອນ ມູ່ ກາ ຣຍານ ແຕ ໄມ່ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ແຕ ຈະ ກອນ ເກົາ ມາ ໄລ່ ຕາ ເຕ່ອ໌ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ເຈີ່ ເຢຊູ ຕາແອີຍ ປາຍ: \"ມູ່ ເຍືາ ກາ ຕາ ເບີນ ຊາອຳ ເອີຍ! ອຶນນັ່ອງ ດູ່ນ ມາແລ່ະ ເກົາ ແອີດ ກະ ເຍືາ ກະ ຈີວ໌ ເຍືາ ຕາ ເບີນ ຊາອຳ? ເດີງ ໂອນ ກັຣແນນ ກັອຍ ແຕີ່ອ໌ ປໍ ເກົາ ແມຮ!\" ");
INSERT INTO ncq_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ເຈີ່ ໄລ່ ກັອຍ ເດີງ ກັຣແນນ ແຕີ່ອ໌ ປໍ ເຢຊູ. ເຢືາງ ຕາ ອໍ ກັອຍ ພໍກາ ອັນ ເຮີມ ເຢຊູ ອັນ ຕະ ໂອນ ກັຣແນນ ກັອຍ ແດິມ ກະ ດາແດັຮ ຕຶ່ງ ກູແຕອ໌. ກະ ອັນ ຕະ ໂອນ ກັຣແນນ ກັອຍ ປາເລົາ ລູເລືາອ໌ ລົ່ບລີ່, ເຈີ່ ລັ່ອຮ ປູປົ່ຮ ແຕ ແບອ໌. ");
INSERT INTO ncq_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ເຢຊູ ອາເບຼິຮ ອຶມປໍ່ ກັຣແນນ ກັອຍ ປາຍ: \"ດູ່ນ ມາແລ່ະ ເຈີ່ ກອນ ໄມ່ ແກີດ ນ່ະໄນ່?\" ອຶມປໍ່ ກັຣແນນ ກັອຍ ປາຍ: \"ແກີດ ແຕ ອັນ ແກດໆ. ");
INSERT INTO ncq_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ຊາອຶ່ຍ ຕໍ່ ເຈີ່ ເຢືາງ ຕາ ອໍ ໄນ່ ອີ ກາຈີດ ກອນ ເກົາ. ອັນ ກູແຕັລ ໂຈະ ຕຶ່ງ ອູ່ຍຮ ກະ ອັນ ກູແຕັລ ອາປັອງ ປໍ ແດີອ໌. ຄັນ ເຕ່ອ໌ ໄມ່ ຕະ, ແຊອ໌ ໄມ່ ຈ່ອຍ ກະ ອາໂຢ່ະ ຕະ ຮິ ແຮີ!\" ");
INSERT INTO ncq_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ເຢຊູ ຕາແອີຍ ປາຍ: \"ນານ່ະ ແຕ ໄມ່ ປາຍ ຄັນ ເຕ່ອ໌ ໄມ່ ຕະ? ກູ່ ຣາມຶ່ຮ ລາ ເຕ່ອ໌ ແກີດ ອຶນແຍ່ະ ຄັນ ໄມ່ ຊາອຳ.\" ");
INSERT INTO ncq_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ເຈີ່ ອຶມປໍ່ ກັຣແນນ ກັອຍ ອັນ ປາຍ: \"ໄມ່ ຈ່ອຍ ເກົາ ແຮີ; ເກົາ ຊາອຳ ເຈີ່, ມາ ແຊອ໌ ໄມ່ ຈ່ອຍ ໂອນ ເກົາ ຊາອຳ ເຣ່ງ ອາຊັອຮ ແອັນ!\" ");
INSERT INTO ncq_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ພໍກາ ເຢຊູ ເຮີມ ກວາຍ ກຼຶ່ງ ລາລື່ ຣາເນ່ດ ອີ ມູ່ດ ຊາລີອ໌ ແຈ່ະ, ເຢຊູ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ກັອຍ ປາຍ: \"ເຢືາງ ແບອ໌ ເກີອ໌ ກະ ກູຕູຣ ຕຸ່ງ, ເກົາ ຕູ່ຍຮ ໂອນ ໄມ່ ລັ່ອຮ ແຕ ກັຣແນນ ໄນ່. ເຈີ່ ໄມ່ ອຶນໂຈຍ ແຕີ່ອ໌ ມູ່ດ ລັ່ຮ ນັ່ອງ.\" ");
INSERT INTO ncq_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ເຢືາງ ຕາ ອໍ ກັອຍ ອັນ ແຮຣ ກະ ອັນ ຕະ ໂອນ ກວາຍ ກັອຍ ດາແດັຮ ອຶນແຍ່ະ ເຣ່ງ, ເຈີ່ ອັນ ລັ່ອຮ ແຕ ກັຣແນນ ກັອຍ. ກັຣແນນ ກັອຍ ອຶນຈົນ ໄປຣ່ອ໌, ເຈີ່ ກຼຶ່ງ ນະ ປາຍ: \"ອັນ ກູຈີດ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ເຢຊູ ໂກບ ອາຕີ ກັຣແນນ ກັອຍ, ເຈີ່ ອັນ ກາຕັ່ອງ ອາຢວຣ. ກັຣແນນ ກັອຍ ຢວຣ ຕາຢຶ່ງ ລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ບັອງ ກາ ເຢຊູ ມູ່ດ ປໍ ດຸງ, ມູ່ ກາ ຣຍານ ແຕ ອັນ ອາເບຼິຮ ອັນ ປາຍ: \"ນານ່ະ ແຕ ຮິ ຕາ ເຣືາບ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ກັອຍ?\" ");
INSERT INTO ncq_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ເຢືາງ ຕາ ອໍ ນ່ະໄນ່ ເຍືາ ຕາ ເຕ່ອ໌ ຕູ່ຍຮ ອາລັ່ອຮ ຄັນ ເຍືາ ຕາ ເບີນ ເກົາແຊອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ລັ່ອຮ ແຕ ກັອຍ ເຈີ່ ໄລ່ ເປາະ ຊາລັຮ ແຄງ ຄາລີເລ. ເຢຊູ ຕາ ເບີນ ໂອນ ເນົ່າ ດັງ ປາຍ ອັນ ແອີດ ອຶນແລ່ະ, ");
INSERT INTO ncq_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ຍ່ອນ ອັນ ແອີດ ອາຕີ ມູ່ ກາ ຣຍານ ແຕ ອັນ. ອັນ ອາຕີ ປາຍ: \"ແຈ່ະ ເຈີ່ ເນົ່າ ອີ ມ່ອບ ເກົາ ກອນ ເຢືາງ ແກີດ ກວາຍ ໂອນ ປໍ ອາຕີ ກວາຍ ຊົດ. ເຈີ່ ໄລ່ ກາຈີດ ເກົາ, ມາ ແວັດ ກັອຍ ແຕີ່ອ໌ ຕາໄງ ໄປ ເກົາ ໂມ່ຍຮ ລັ່ຮ ແຕ ກູຈີດ.\" ");
INSERT INTO ncq_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ມູ່ ກາ ຣຍານ ແຕ ອັນ ອຶນເນີ່ມ ຕາ ເບີນ ດັງ ປັຣນາຍ ກາ ເຢຊູ ປາຍ, ມາ ໄລ່ ຕາ ຍັ່ນ ອາເບຼິຮ ລັ່ຮ ອັນ ແຕ ປັຣນາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ແຕີ່ອ໌ ປໍ ເມືອງ ກາເປນາອູມ. ພໍກາ ໄລ່ ມູ່ດ ຕຶ່ງ ດຸງ, ເຈີ່ ເຢຊູ ອາເບຼິຮ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ບັອງ ໄຮ ເປາະ ຕຶ່ງ ຣານາ ກັອຍ, ອຶນເຕົ່າ ເຍືາ ຣາຈຽນ ຕະ?\" ");
INSERT INTO ncq_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ໄລ່ ແອີດ ຣາອຍາບ, ຍ່ອນ ບັອງ ກາ ໄລ່ ເປາະ ຕຶ່ງ ຣານາ ໄລ່ ຣາຈຽນ ປາຍ ເນົ່າ ກາ ປື່ດ ກາເລີຍ ແຕ ເຢົ່າ ຕຶ່ງ ມູ່ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ເຢຊູ ຕາກູ ເຈີ່ ອັນ ກູອ໌ ມູ່ ກາ ຣຍານ ແຕ ອັນ ອຶນແຍ່ະ ມັນຈິ່ດ ລາ ບາຣ ນະ ແຕີ່ອ໌ ປໍ ອັນ, ເຈີ່ ອັນ ອາຕີ ໄລ່ ປາຍ: \"ຄັນ ອາແລ່ະ ກາ ຢໍອ໌ ອີ ແກີດ ປື່ດ ກາເລີຍ ເຢົ່າ, ໂອນ ກວາຍ ກັອຍ ແກີດ ຊູລ ກູ່ ນະ.\" ");
INSERT INTO ncq_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ເຢຊູ ອີດ ກັຣແນນ ແກດໆ ມານະ ແຕີ່ອ໌ ຕາຢຶ່ງ ແອີດ ຢັ່ຮ ເມືາງ ໄລ່. ເຢຊູ ກາອື່ ກັຣແນນ ກັອຍ, ເຈີ່ ອັນ ອາຕີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","\"ກວາຍ ອາແລ່ະ ກາ ຣັ່ບ ອໍ ກັຣແນນ ແກດໆ ນ່ະໄນ່ ຍ່ອນ ອັນ ຊາອຳ ເກົາ, ນ່ະ ອັນ ຣັ່ບ ອໍ ເກົາ ເຕ່. ກະ ກວາຍ ອາແລ່ະ ກາ ຣັ່ບ ອໍ ເກົາ ລາ ນ່ະ ອັນ ຣັ່ບ ອໍ ເຢືາງ ເຈົາຣາຊີ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ໂຢຮັນ ອາຕີ ເຢຊູ ປາຍ: \"ອາຈານ ເອີຍ! ຮິ ເຮີມ ກວາຍ ມານະ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ກະ ອັນ ກູອ໌ ຣາມຶ່ຮ ອາຈານ. ມາ ຮິ ກາແອັຮ ອັນ ຍ່ອນ ອັນ ລາ ຕາ ແກີນ ກວາຍ ໄຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ເຢຊູ ອາຕີ ປາຍ: \"ອຶນໂຈຍ ກາແອັຮ ອັນ, ຍ່ອນ ກວາຍ ອາແລ່ະ ກາ ອີດ ຣາມຶ່ຮ ເກົາ ດໍອ໌ ຕະ ຣານະ ຕາ ເກີ່ຍ ເຮີມ, ກວາຍ ກັອຍ ຕາ ເຕ່ອ໌ ປຽນ ປາຍ ຕາ ອໍ ແຕ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ກວາຍ ອາແລ່ະ ກາ ຕາ ເບີນ ຕະ ຕາ ອໍ ໂຈະ ໄຮ, ອັນ ກັອຍ ແອີດ ຢັ່ຮ ໄຮ. ");
INSERT INTO ncq_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ກວາຍ ອາແລ່ະ ກາ ປີ່ງ ໂອນ ມວຍ ຈອກ ແດີອ໌ ໂອນ ເຍືາ ງ່ອຍ໌ ຍ່ອນ ເຍືາ ແອີດ ຢັ່ຮ ເກົາ, ກວາຍ ກັອຍ ຕາ ເບີນ ແອິ ເກືາ. ");
INSERT INTO ncq_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","\"ຄັນ ເບີນ ກວາຍ ອາແລ່ະ ກາ ປັຣຕຶ່ ກັຣແນນ ກາ ຊາອຳ ເກົາ ໂອນ ອັນ ຕະ ໂລ່ຍຮ, ຄາອ໌ ອີດ ຕາເມົາ ປື່ດ ຊັດ ໂຈະ ຕຶ່ງ ຕາກອງ ອັນ ກັອຍ ເຈີ່ ອາປັອງ ຕັຮ ຕຶ່ງ ທາເລ. ");
INSERT INTO ncq_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ຄັນ ອາຕີ ເຍືາ ມັງກັ່ຮ ຕະ ໂອນ ເຍືາ ຕະ ໂລ່ຍຮ, ອຶງເຄາະ ເຍືາ ກັອຮ ແກຼງ ຕັຮ ຊັອງ. ຄາອ໌ ແອີດ ກະ ເຢືາງ ເຈົາຣາຊີ ເບີນ ອາຕີ ມວຍ ກັ່ຮ ລາ ອໍ ກາເລີຍ ແຕ ເບີນ ອາຕີ ບາຣ ກັ່ຮ ມາ ຊາແລັຮ ຕຶ່ງ ປຣຸ່ງ ອູ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ຕຶ່ງ ກັອຍ ເບີນ ອຶມປາງ ກາ ຕາ ແກີດ ກູຈີດ ນັ່ອງ, ກະ ອູ່ຍຮ ກາ ເບຼີ ຕາ ແກີດ ປັດ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ຄັນ ອາເຢີງ ເຍືາ ມັງກັ່ຮ ຕະ ໂອນ ເຍືາ ເບີນ ໂລ່ຍຮ, ອຶງເຄາະ ເຍືາ ກັອຮ ຕັຮ ຊັອງ. ຄາອ໌ ແອີດ ກະ ເຢືາງ ເຈົາຣາຊີ ເບີນ ອາເຢີງ ມວຍ ກັ່ຮ ລາ ອໍ ກາເລີຍ ແຕ ເບີນ ອາເຢີງ ອຶນແຍ່ະ ບາຣ ກັ່ຮ ມາ ຊາແລັຮ ຕຶ່ງ ປຣຸ່ງ ອູ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ຕຶ່ງ ກັອຍ ເບີນ ອຶມປາງ ກາ ຕາ ແກີດ ກູຈີດ ກະ ອູ່ຍຮ ກາ ເບຼີ ຕາ ແກີດ ປັດ. ");
INSERT INTO ncq_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ຄັນ ກຼອງ ມັ່ດ ເຍືາ ມັງກັ່ຮ ຕະ ໂອນ ເຍືາ ຕະ ໂລ່ຍຮ, ອຶງເຄາະ ເຍືາ ກູໄລອ໌ ຕັຮ ຊັອງ. ຄາອ໌ ແອີດ ກະ ເຢືາງ ເຈົາຣາຊີ ເບີນ ມັ່ດ ມວຍ ກັ່ຮ ລາ ອໍ ກາເລີຍ ແຕ ເບີນ ກຼອງ ມັ່ດ ອຶນແຍ່ະ ບາຣ ກັ່ຮ ມາ ຊາແລັຮ ຕຶ່ງ ປຣຸ່ງ ອູ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ຕຶ່ງ ກັອຍ ເບີນ ອຶມປາງ ກາ ຕາ ແກີດ ກູຈີດ ກະ ອູ່ຍຮ ກາ ເບຼີ ຕາ ແກີດ ປັດ. ");
INSERT INTO ncq_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","\"ເກຣີ່ງ ຣາແວັ່ຮ ອຶນເຕົ່າ ກາ ເນົ່າ ອີ ອັງ ປາແດງ ອູ່ຍຮ ອຶງເຄາະ ເນົ່າ ເປຍ ໂຈະ ບອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ບອຍ ລາ ເກຣີ່ງ ອໍ, ມາ ຄັນ ບອຍ ແກີດ ອຶນຕຍາຮ, ນານ່ະ ເຍືາ ອີ ຕະ ໂອນ ອັນ ບະ ລັ່ຮ? ອຶງເຄາະ ເຍືາ ແກີດ ນ່ະ ບອຍ ກະ ແອີດ ຣາຕອຍ ຊັງໄກຣ ຣໍ່ອ໌ ບູຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ເຈີ່ ເຢຊູ ລັ່ອຮ ແຕ ກັອຍ ເປາະ ປໍ ແຄງ ຢູດາຍ ກະ ໄກ່ອ໌໌ ຕາເລ່ ຈໍແດນ ເປາະ ປຶ່ຮ ຢັ່ຮ ອຶນຕົ່ຮ. ເບີນ ກວາຍ ກຼຶ່ງ ແຕີ່ອ໌ ປໍ ອັນ, ເຈີ່ ອັນ ອາຕີ ໄລ່ ນ່ະ ອັນ ເກີ່ຍ ອາຕີ ແຕ ອຶນໂຍ່ງ. ");
INSERT INTO ncq_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ເບີນ ມັຮ ກວາຍ ພາຣີຊາຍ ແຕີ່ອ໌ ປໍ ເຢຊູ. ໄລ່ ລ່ອງ ຊາລີອ໌ ອັນ, ເຈີ່ ໄລ່ ອາເບຼິຮ ອັນ ປາຍ: \"ຕາປູ່ນ ຄານອດ ເຢືາງ ເຈົາຣາຊີ, ຣາເລົາ ຕັຮ ລາກວຍ ເບີນ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ເຈີ່ ເຢຊູ ອາເບຼິຮ ລັ່ຮ ໄລ່ ປາຍ: \"ໂມເຊ ອາຕີ ດໍອ໌ ເຍືາ ນານ່ະ?\" ");
INSERT INTO ncq_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ໄລ່ ຕາແອີຍ ປາຍ: \"ໂມເຊ ໂອນ ຄຽນ ປຶ່ງ ຣາຕັຮ, ເຈີ່ ຣາເລົາ ຕັຮ ລາກວຍ ລາ ເບີນ.\" ");
INSERT INTO ncq_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ໂມເຊ ຄຽນ ອາຕີ ດໍອ໌ ນ່ະກັອຍ ຍ່ອນ ຣາງຶ່ຮ ເຍືາ ເງືານ ລາລື່ ຕາ ແອອ໌ ອີ ຊາງັດ. ");
INSERT INTO ncq_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ແຕ ອຶມແບິ ເຢືາງ ເຈົາຣາຊີ ແຕງ ຣາເລົາ ມານະ ມັນແຊມ ມານະ ມູເຈິງ ເນົ່າ ຄຽນ ດໍອ໌ ເຈີ່ ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ນ່ະກັອຍ ຣາເລົາ ຕັຮ ອຶມເປ່ອ໌ ອຶມປໍ່, ເປາະ ແອີດ ອາລຶ່ງ ລາກວຍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ເຈີ່ ໄລ່ ບາຣ ນະ ແກີດ ມູ ຈະ. ໄລ່ ບາຣ ນະ ລາ ຕາ ເບີນ ແກີດ ນັ່ອງ ບາຣ ນະ, ມາ ໄລ່ ແກີດ ມານະ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ຍ່ອນ ເຢືາງ ເຈົາຣາຊີ ຕະ ໂອນ ແກີດ ມານະ ຊັອງ, ເຈີ່ ອຶນໂຈຍ ໂອນ ກວາຍ ອາແລ່ະ ກາຢັ່ຮ ໂອນ ໄລ່ ຣາຕັຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ພໍກາ ໄລ່ ແອີດ ລັ່ຮ ຕຶ່ງ ດຸງ ເຈີ່ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ອາເບຼິຮ ອັນ ແຕ ຣານະ ຣາຕັຮ ກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ຣາເລົາ ອາແລ່ະ ມາ ຕັຮ ລາກວຍ, ເຈີ່ ເປາະ ອີດ ມັນແຊມ ຕາໄມ ແອັນ, ກວາຍ ກັອຍ ຕະ ໂລ່ຍຮ ໂຈະ ລາກວຍ ຕຍາ ອັນ ມູເຈິງ ອັນ ເປາະ ປັຣລື່ຍ. ");
INSERT INTO ncq_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ນ່ະກັອຍ ເຕ່ ຄັນ ມັນແຊມ ອາແລ່ະ ກາ ຕັຮ ກາຢາອ໌, ເຈີ່ ອັນ ເປາະ ອີດ ກາຢາອ໌ ຕາໄມ ແອັນ, ມັນແຊມ ກັອຍ ຕະ ໂລ່ຍຮ ໂຈະ ກາຢາອ໌ ຕຍາ ອັນ, ມູເຈິງ ອັນ ເປາະ ປັຣລື່ຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ແວັດ ກັອຍ ເນົ່າ ເດີງ ກັຣແນນ ແຕີ່ອ໌ ປໍ ເຢຊູ ກະ ໂອນ ເຢຊູ ຊາປ່ະ ອາຕີ ໂຈະ ກັຣແນນ ກັອຍ ໂອນ ໄລ່ ເບີນ ບຸ່ນ. ມາ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ກາແອັຮ ໄລ່ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ພໍກາ ເຢຊູ ເຮີມ ນ່ະກັອຍ, ອັນ ກູແທອ໌ ມູ່ ກາ ຣຍານ ແຕ ອັນ. ເຈີ່ ອັນ ປາຍ ໂຈະ ໄລ່: \"ເຍືາ ໂອນ ກັຣແນນ ແຕີ່ອ໌ ປໍ ເກົາ. ອຶນໂຈຍ ກາຕັງ ໄລ່; ເຢືາງ ເຈົາຣາຊີ ອີ ຕະ ຊົດ ຕຶ່ງ ຣາງຶ່ຮ ກວາຍ ກາ ນ່ະ ກັຣແນນ ໄນ່ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ຄັນ ອາແລ່ະ ກາ ຕາ ເບີນ ປຣ່ອມ ໂອນ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ນ່ະ ກັຣແນນ ປຣ່ອມ, ອັນ ຕາ ເຕ່ອ໌ ມູ່ດ ຕຶ່ງ ຈຸ່ມ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ.\" ");
INSERT INTO ncq_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ເຈີ່ ເຢຊູ ກາອື່ ກັຣແນນ ກັອຍ. ອັນ ຊາປ່ະ ອາຕີ ໂຈະ ກັຣແນນ ກັອຍ ກະ ອັນ ຈໍອ໌ ບຸ່ນ ໂອນ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ພໍກາ ເຢຊູ ເປາະ ຕຶ່ງ ຣານາ ກັອຍ ເບີນ ຣາເລົາ ມານະ ປາລັອງ ປໍ ເຢຊູ. ອັນ ກຼຸ່ ຣາໂກລ ຢັ່ຮ ເມືາງ ເຢຊູ, ເຈີ່ ອັນ ອາເບຼິຮ ປາຍ: \"ອາຈານ ກາ ອໍ ເອີຍ! ນານ່ະ ເກົາ ອີ ຕະ ໂອນ ຕາ ເບີນ ກູຈີດ ກະ ແອີດ ອາມົ່ງ ເລືອຍໆ?\" ");
INSERT INTO ncq_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ເຢຊູ ຕາແອີຍ ອັນ ປາຍ: \"ນານ່ະ ໄມ່ ກູອ໌ ເກົາ ປາຍ ອາຈານ ກາ ອໍ?\" ຕາ ເບີນ ອາແລ່ະ ກາ ຕານັ່ອງ ອໍ ແຕ ມານະ, ແອີງ ເຢືາງ ເຈົາຣາຊີ ຊັອງ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ໄມ່ ລາ ດັງ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ດໍອ໌ ປາຍ: \"ອຶນໂຈຍ ກາຈີດ ກວາຍ, ອຶນໂຈຍ ປັຣລື່ຍ ລາກວຍ ກາຢາອ໌ ເນົ່າ, ອຶນໂຈຍ ຕວຍ໌ ເກຣີ່ງ ເຢົ່າ, ອຶນໂຈຍ ຕູນ ເຢົ່າ, ອຶນໂຈຍ ໂລ່ບ ເຢົ່າ, ໂອນ ຊາງັດ ອຶມເປ່ອ໌ ອຶມປໍ່ ໄມ່ ເບີມ.\" ");
INSERT INTO ncq_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ກວາຍ ກັອຍ ຕາແອີຍ ປາຍ: \"ອາຈານ ເອີຍ! ແຕ ເກົາ ອຶນເນີ່ມ ແກດ ແຕີ່ອ໌ ຊານໍ່ ໄນ່, ເກົາ ຕະ ຕາປູ່ນ ອຶນແຍ່ະ ມັຮ ປັຣນາຍ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ເຈີ່ ເຢຊູ ຊາລີອ໌ ປໍ ກວາຍ ກັອຍ, ກະ ອັນ ຊັອງ ອາໂຢ່ະ ກວາຍ ກັອຍ, ເຈີ່ ອັນ ປາຍ: \"ຊານໍ່ ໄນ່ ໄມ່ ອຶນນັ່ອງ ແອິ ມວຍ ຣາມຶ່ຮ, ໂອນ ໄມ່ ເປາະ ຈິ ອຶນແຍ່ະ ມັຮ ມູ່ນ ໄມ່, ເຈີ່ ໄມ່ ໂອນ ມັຮ ກວາຍ ກາດີດ. ນ່ະກັອຍ ເຕ່ອ໌ ໄມ່ ເບີນ ມູ່ນ ອໍ ຕຶ່ງ ມັນລັ່ອງ, ເຈີ່ ໄມ່ ແຕີ່ອ໌ ປວາຍ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ພໍກາ ອັນ ຊັອງ ເຢຊູ ປາຍ ນ່ະກັອຍ, ເຈີ່ ກວາຍ ກັອຍ ແກີດ ຊູບ ແຕິ່ ມັ່ດ ມຸ່ຮ ອັນ, ກະ ອັນ ຊັອງ ຕຸ່ຮ ຕຶ່ງ ຣາງຶ່ຮ ອັນ, ຍ່ອນ ອັນ ລາ ກວາຍ ຊຸ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ເຢຊູ ກູລຍານ ເນ່ ຊາ, ເຈີ່ ອັນ ອາຕີ ໂຈະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ກັ່ດ ລາລື່ ກວາຍ ກາ ຊຸ ເບີນ ອີ ມູ່ດ ຕຶ່ງ ຈຸ່ມ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ.\" ");
INSERT INTO ncq_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ພໍກາ ມູ່ ກາ ຣຍານ ແຕ ອັນ ຊັອງ ອັນ ປາຍ ນ່ະກັອຍ ໄລ່ ແກີດ ງຶ່ດ ລາລື່. ເຢຊູ ອາຕີ ຊາ ໂຈະ ໄລ່ ປາຍ: \"ມັຮ ກອນ ອາໄກ ເກົາ ເອີຍ! ກັ່ດ ລາລື່ ອີ ມູ່ດ ແອີດ ອາລຶ່ງ ຈຸ່ມ ກາ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ. ");
INSERT INTO ncq_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ຊັນຕຣັ່ນ ອູ່ດ ລວາຍ໌ ຕາຣົ່ງ ມັນຈິ່ລ ອຶນເນີ່ມ ອຽນ ກາເລີຍ ແຕ ກວາຍ ຊຸ ເບີນ ອີ ມູ່ດ ຕຶ່ງ ຈຸ່ມ ກາ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ.\" ");
INSERT INTO ncq_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ເຈີ່ ມູ່ ກາ ຣຍານ ແຕ ອັນ ແຮງ ງຶ່ດ ລາລື່ ແອັນ, ເຈີ່ ໄລ່ ມານະ ອາເບຼິຮ ມານະ ປາຍ: \"ຄັນ ນ່ະກັອຍ ເນົ່າ ກາ ເຕ່ອ໌ ເບີນ ອາມົ່ງ?\" ");
INSERT INTO ncq_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ເຢຊູ ກູລຍານ ເນ່ ປໍ ໄລ່ ເຈີ່ ອັນ ປາຍ: \"ກວາຍ ຕາ ເຕ່ອ໌ ຕະ ຣານະ ກັອຍ, ມາ ເຢືາງ ເຈົາຣາຊີ ເຕ່ອ໌ ຕະ ກູ່ ຣາມຶ່ຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ເຈີ່ ເປໂຕ ປາຍ: \"ຮິ ຕັຮ ອຶນແຍ່ະ ກູ່ ຣາມຶ່ຮ ຍ່ອນ ຮິ ອີ ເປາະ ກະ ໄມ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ເຢຊູ ອາຕີ ໂຈະ ໄລ່ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ: ກວາຍ ອາແລ່ະ ກາ ຕັຮ ດຸງ ຕັຮ ແດີອ໌, ຕັຮ ແຊມອາຍ ແຊມແອີຍ, ຕັຮ ອຶມເປ່ອ໌ ອຶມປໍ່, ຕັຮ ກອນ, ຕັຮ ເນືາ ປຼື່ ຍ່ອນ ອີ ເປາະ ອາລຶ່ງ ເກົາ ກະ ອີ ອາຕີ ປັຣນາຍ ອໍ ແຕ ເຢືາງ ເຈົາຣາຊີ, ");
INSERT INTO ncq_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ກວາຍ ກັອຍ ເບີນ ຣັ່ບ ລັ່ຮ ເກຣີ່ງ ມວຍ ຣ່ອຍ ຕໍ່ ກາເລີຍ ແຕ ອຶນໂຍ່ງ ຕຶ່ງ ກູແຕອ໌ ໄນ່ ນ່ະ ດຸງ ແດີອ໌, ແຊມອາຍ ແຊມແອີຍ, ອຶມເປ່ອ໌ ອຶມປໍ່, ກອນ, ເນືາ ປຼື່, ກະ ເບີນ ເນົ່າ ຕະ ຕຸ່ຮ ຊາອຶ່ຍ ແຮີ, ມາ ເຈີ່ ປໍ ເມືາງ ອັນ ອາມົ່ງ ເລືອຍໆ. ");
INSERT INTO ncq_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ຊາອຶ່ຍ ນະ ກວາຍ ກາ ແກີດ ປື່ດ ຊານໍ່, ປັຣແນີ ມັນເຕຣືາ ໄລ່ ແກີດ ແກດໆ, ມາ ກວາຍ ກາ ແກີດ ແກດໆ ຊານໍ່, ປັຣແນີ ມັນເຕຣືາ ໄລ່ ແກີດ ປື່ດ ແອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ບັອງ ກາ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ເປາະ ປໍ ເມືອງ ເຢຣູຊາເລັມ, ເຢຊູ ຕາຢັຮ ເປາະ ອຶນໂຍ່ງ ແຕ ມູ່ ກາ ຣຍານ ແຕ ອັນ. ເຈີ່ ມູ່ ກັອຍ ຊັອງ ງຶ່ດ. ມາ ກວາຍ ການໍ່ອ໌ ກາ ເປາະ ຕາຢັຮ ກະ ໄລ່ ຊັອງ ອຶງກັອຮ. ເຢຊູ ເດີງ ມູ່ ກາ ຣຍານ ແຕ ອັນ ມັນຈິ່ດ ລາ ບາຣ ນະ ຕາຢັຮ ອາລັ່ອຮ ແຕ ກວາຍ ກຼຶ່ງ, ເຈີ່ ອັນ ອາຕີ ໂອນ ໄລ່ ດັງ ຣານະ ອຶນເຕົ່າ ກາ ແຈ່ະ ອີ ແກີດ ກະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ເຈີ່ ເຢຊູ ປາຍ: \"ໂອນ ເຍືາ ຊາງັດ! ໄຮ ອີ ຊັອຮ ປໍ ເມືອງ ເຢຣູຊາເລັມ. ອຶນຕຸ ກັອຍ ເນົ່າ ອີ ມ່ອບ ເກົາ ກອນ ເຢືາງ ແກີດ ກວາຍ ໂອນ ກວາຍ ກາ ຊົດ ຊາງ ຣີ່ດ ກະ ກວາຍ ອາຕີ ຄານອດ, ເຈີ່ ໄລ່ ນັ່ດ ດໍອ໌ ອຶງເຄາະ ເກົາ ຈີວ໌ ກູຈີດ. ກະ ໄລ່ ມ່ອບ ເກົາ ໂອນ ກວາຍ ຕາ ແກີນ ກວາຍ ອິດຊະຣາເອລ. ");
INSERT INTO ncq_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ເຈີ່ ກວາຍ ກັອຍ ໄລ່ ອາເຢ່ ກະ ພາມາດ ເກົາ, ໄລ່ ກູຈົຮ ໂຈະ ເກົາ, ກະ ໄລ່ ວັ່ດ, ເຈີ່ ໄລ່ ກາຈີດ ຕັຮ ເກົາ. ມາ ແວັດ ໄປ ຕາໄງ ເກົາ ໂມ່ຍຮ ລັ່ຮ ແຕ ກູຈີດ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ເຈີ່ ຢາໂກໂບ ກະ ໂຢຮັນ ກອນ ເຊເບດາຍ ຊີ່ອ໌ ອາມູ່ດ ແຈ່ະ ເຢຊູ ເຈີ່ ໄລ່ ປາຍ: \"ອາຈານ ເອີຍ! ຮິ ບາຣ ນະ ຢໍອ໌ ອີ ໂອນ ອາຈານ ຈ່ອຍ ມວຍ ຣາມຶ່ຮ ເບີນ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ເຢຊູ ອາເບຼິຮ ໄລ່ ປາຍ: \"ອຶນເຕົ່າ ເຍືາ ອີ ເບີນ ໂອນ ເກົາ ຈ່ອຍ?\" ");
INSERT INTO ncq_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ໄລ່ ຕາແອີຍ ປາຍ: \"ພໍກາ ອາຈານ ເບີນ ແອີດ ຕຶ່ງ ອຶນຕຸ ອາງອື່ຣ, ແຊອ໌ ໂອນ ຮິ ບາຣ ນະ, ມານະ ຕາກູ ຢັ່ຮ ອາຕ່ຳ ມານະ ຕາກູ ຢັ່ຮ ອາເວ່ຣ ອາຈານ.\" ");
INSERT INTO ncq_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ເຍືາ ອຶນເນີ່ມ ຕາ ຢວາຮ ດັງ ຣາມຶ່ຮ ກາ ເຍືາ ແຊອ໌. ຈອກ ກາ ເກົາ ງ່ອຍ໌ ກັອຍ, ເຍືາ ງ່ອຍ໌ ເບີນ ບໍ? ກະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ກາ ເກົາ ຣັ່ບ ກັອຍ, ເຍືາ ຣັ່ບ ເບີນ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ໄລ່ ຕາແອີຍ ປາຍ: \"ເບີນ.\" ເຈີ່ ເຢຊູ ອາຕີ ໂຈະ ໄລ່ ປາຍ: \"ຈອກ ກາ ເກົາ ງ່ອຍ໌, ເຍືາ ເບີນ ງ່ອຍ໌ ເຕ່. ຣີ່ດ ຕຶ່ງ ແດີອ໌ ກາ ເກົາ ຣັ່ບ, ອຶງເຄາະ ເຍືາ ເບີນ ຣັ່ບ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ມາ ເນົ່າ ກາ ເບີນ ຕາກູ ຢັ່ຮ ອາຕ່ຳ ຢັ່ຮ ອາເວ່ຣ ເກົາ, ເກົາ ຕາ ເບີນ ຣຽຮ. ມາ ເຢືາງ ເຈົາຣາຊີ ຣຽຮ ດໍອ໌ ກວາຍ ກັອຍ ແຕ ອຶນໂຍ່ງ.\" ");
INSERT INTO ncq_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ພໍກາ ມູ່ ກາ ຣຍານ ແຕ ອັນ ມັນຈິ່ດ ນະ ຊັອງ ນ່ະກັອຍ, ໄລ່ ກັອຍ ຊັອງ ອຶງຄື່ນ ລາລື່ ໂຈະ ຢາໂກໂບ ກະ ໂຢຮັນ. ");
INSERT INTO ncq_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ເຈີ່ ເຢຊູ ກູອ໌ ໄລ່ ກັອຍ ໂອນ ມູ່ດ ໂຣ່ມ ມັນຕຸ, ເຈີ່ ອັນ ປາຍ: \"ມູ່ ເຍືາ ດັງ ເຈີ່ ເຕືາວ ປັຣເຍືາ ກາ ຊົດ ຕຶ່ງ ກຣວາງ ການໍ່ອ໌ ໄລ່ ຕະ ໂອນ ກອນແຊມ ອຶງກັອຮ ໄລ່; ມັຮ ກວາຍ ຊົດ ປື່ນ ອັນ ຕະ ຕຸ່ຮ ກັ່ດ ມັຮ ກອນແຊມ. ");
INSERT INTO ncq_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ມາ ມູ່ ເຍືາ ອຶນໂຈຍ ຕະ ນ່ະກັອຍ. ຄັນ ກວາຍ ອາແລ່ະ ຕຶ່ງ ຈຸ່ມ ເຍືາ ຢໍອ໌ ອີ ແກີດ ປື່ດ, ໂອນ ອັນ ຕະ ຣານະ ຈ່ອຍ ອຶນແຍ່ະ ນະ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ຄັນ ກວາຍ ອາແລ່ະ ຢໍອ໌ ອີ ແກີດ ປື່ດ ກາເລີຍ ແຕ ການໍ່ອ໌, ໂອນ ອັນ ແກີດ ຊູລ ອຶນແຍ່ະ ກູ່ ນະ. ");
INSERT INTO ncq_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ຍ່ອນ ເກົາ ກອນ ເຢືາງ ແກີດ ກວາຍ ຕາ ເບີນ ແຕີ່ອ໌ ປໍ ໄນ່ ໂອນ ກວາຍ ການໍ່ອ໌ ແກີດ ຊູລ ເກົາ, ມາ ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່ ອີ ແກີດ ຊູລ ກວາຍ ການໍ່ອ໌, ກະ ຈີວ໌ ກູຈີດ ອີ ໄທ ລັ່ຮ ຊາອຶ່ຍ ນະ ກວາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ຕາຢັຮ ເປາະ ແຕີ່ອ໌ ເມືອງ ເຢຣີໂກ; ບັອງ ກາ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ລັ່ອຮ ແຕ ເມືອງ ເຢຣີໂກ ເປາະ ມັນຕຸ ກະ ກວາຍ ກຼຶ່ງ, ເບີນ ມານະ ກວາຍ ຊູດ ມັ່ດ ຣາມຶ່ຮ ບາຣຕີມາຍ ກອນ ຣາເລົາ ຕີມາຍ ຕາກູ ຊູແຊອ໌ ແອີດ ອຶມແປຣ ຣານາ. ");
INSERT INTO ncq_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ພໍກາ ກວາຍ ຊູດ ມັ່ດ ກັອຍ ດັງ ປາຍ ເຢຊູ ກວາຍ ແຕ ວີ່ລ ນາຊາເຣັດ ເປາະ ຊາລັຮ ແຈ່ະ ອັນ, ເຈີ່ ອັນ ກູອ໌ ປາຍ: \"ເຢຊູ ກວາຍ ຈຸ່ມເຈືອ ດາວິດ ເອີຍ! ແຊອ໌ ໄມ່ ອາໂຢ່ະ ຕະ ເກົາ ແຮີ!\" ");
INSERT INTO ncq_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ຊາອຶ່ຍ ນະ ກາແອັຮ ໂອນ ອັນ ແອີດ ຣາງຍາອ໌ ຕາ ເບີນ ໂອນ ອັນ ຕະ ແບອ໌, ມາ ແຮງ ອັນ ກູອ໌ ເຣ່ງ ອາຊັອຮ ລາລື່: \"ເຢຊູ ຈຸ່ມເຈືອ ດາວິດ ເອີຍ! ແຊອ໌ ໄມ່ ອາໂຢ່ະ ຕະ ເກົາ ແຮີ!\" ");
INSERT INTO ncq_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ເຢຊູ ຕາງິ່ດ, ເຈີ່ ອັນ ແປຣີ ກວາຍ ກາ ແອີດ ແຈ່ະ ອັນ ປາຍ: \"ເຍືາ ໂອນ ອັນ ແຕີ່ອ໌ ປໍ ໄນ່.\" ເຈີ່ ໄລ່ ກັອຍ ກູອ໌ ກວາຍ ຊູດ ມັ່ດ ກັອຍ ອາຕີ ອັນ ປາຍ: \"ໂອນ ໄມ່ ຣໍ່ອ໌ ຣາງຶ່ຮ, ເຈີ່ ຢວຣ ຕາຢຶ່ງ. ເຢຊູ ກູອ໌ ໄມ່ ໂອນ ເປາະ ປໍ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ກວາຍ ຊູດ ມັ່ດ ກັອຍ ກູເຕືາງ ຕັຮ ອາຣິ ກາ ອັນ ອຶງກວາມ ແຕ ຈະ ອັນ, ເຈີ່ ອັນ ຢວຣ ຢຸ່ກຢັ່ກ ຕາຢັຮ ເປາະ ຕາໂຣ່ອ໌ ປໍ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ເຈີ່ ເຢຊູ ຕາແບີບ ອັນ ປາຍ: \"ໄມ່ ໂອນ ເກົາ ຈ່ອຍ ອຶນເຕົ່າ ໄມ່?\" ກວາຍ ຊູດ ມັ່ດ ຕາແອີຍ ປາຍ: \"ອາຈານ ເອີຍ! ເກົາ ຢໍອ໌ ອີ ບຣາງ ເຮີມ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ເຢຊູ ຕາແອີຍ ປາຍ: \"ເປາະ ເລີ່ຍ, ຍ່ອນ ໄມ່ ຊາອຳ ມັ່ດ ໄມ່ ເຕ່ອ໌ ບຣາງ ລັ່ຮ.\" ບັອງ ກາ ກັອຍ ແຕິ່ ມັ່ດ ອັນ ບຣາງ ລັ່ຮ, ເຈີ່ ອັນ ເປາະ ອາລຶ່ງ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ພໍກາ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ມູ່ດ ແຈ່ະ ອີ ແຕີ່ອ໌ ເມືອງ ເຢຣູຊາເລັມ ແຈ່ະ ວີ່ລ ເບັດພາເຄ ກະ ວີ່ລ ເບັດທານີ, ໄລ່ ແຕີ່ອ໌ ປໍ ກົຮ ອາໂປ່ນ. ເຢຊູ ແປຣີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ບາຣ ນະ ໂອນ ເປາະ ອຶນໂຍ່ງ, ເຈີ່ ອັນ ອາຕີ ໄລ່ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","\"ອຶງເຄາະ ເຍືາ ມູ່ດ ຕຶ່ງ ວີ່ລ ຢັ່ຮ ເມືາງ ເຍືາ ກັອຍ. ພໍກາ ເຍືາ ມູ່ດ ປໍ ກັອຍ ເຍືາ ຣາມົຮ ມານຳ ອາແຊັຮ ແຈລ ອຶນນັ່ອງ ນຸ່ມ ເນົ່າ ຊັດ ດໍອ໌ ອຶງກັອຍ. ອາແຊັຮ ແຈລ ກັອຍ ຕາ ເບີນ ອາແລ່ະ ຈິ່ຮ ຢວາຮ. ເຍືາ ອາແລັ່ຮ ອັນ ແຕ ກັອຍ; ເຈີ່ ເດີງ ປໍ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ຄັນ ເບີນ ອາແລ່ະ ຕາແບີບ ເຍືາ ປາຍ: 'ອຶນເຕົ່າ ເຍືາ ອາແລັ່ຮ ຕະ ອາແຊັຮ ໄນ່?' ໂອນ ເຍືາ ຕາແອີຍ ໄລ່ ປາຍ: 'ອຶນເຈົາ ໄຮ ອີ ເມືານ. ອຶນແນະ ຮິ ກູລັຮ ແຕິ່.'\" ");
INSERT INTO ncq_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ເຈີ່ ມູ່ ກາ ຣຍານ ແຕ ອັນ ບາຣ ນະ ກັອຍ ເປາະ, ເຈີ່ ໄລ່ ຣາມົຮ ອາແຊັຮ ແຈລ ມານຳ ເນົ່າ ຊັດ ດໍອ໌ ຢັ່ຮ ນໍ່ອ໌ ດຸງ ແຈ່ະ ຣານາ. ບັອງ ກາ ໄລ່ ອາແລັ່ຮ ອຶນໄຊ ອັນ, ");
INSERT INTO ncq_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ເບີນ ກວາຍ ຕາຢຶ່ງ ແອີດ ແຈ່ະ ກັອຍ ຕາແບີບ ໄລ່ ປາຍ: \"ເຍືາ ອາແລັ່ຮ ຕະ ອຶນເຕົ່າ ອາແຊັຮ ແຈລ ໄນ່? ເຍືາ ອີ ເດີງ ປໍ ແລ່ະ?\" ");
INSERT INTO ncq_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ໄລ່ ຕາແອີຍ ຕາປູ່ນ ເຢຊູ ອາຕີ ແຕ ອຶນໂຍ່ງ ກັອຍ, ເຈີ່ ກວາຍ ກັອຍ ໂອນ ໄລ່ ອີດ ອາແຊັຮ ແຈລ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ເຈີ່ ໄລ່ ບາຣ ນະ ກັອຍ ເຕິ ອາແຊັຮ ແຈລ ເດີງ ປໍ ເຢຊູ. ໄລ່ ອີດ ອາຢັ່ອຮ ແປີງ ຕວດ ອີ ເຊີນ ຕຶ່ງ ກຣັອງ ອາແຊັຮ ແຈລ ກັອຍ, ເຈີ່ ໂອນ ເຢຊູ ຊັອຮ ຈິ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ເບີນ ຊາອຶ່ຍ ນະ ກວາຍ ອີດ ອາຢັ່ອຮ ແປີງ ຕວດ ເຊີນ ຕຶ່ງ ຣານາ. ເບີນ ມັຮ ກວາຍ ກາ ໄປ່ອ໌ ອີດ ປົ່ດ ອາລ່ອງ ເຊີນ ຕຶ່ງ ຣານາ. ");
INSERT INTO ncq_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ກວາຍ ກາ ຕາຢັຮ ອຶນໂຍ່ງ ກະ ກວາຍ ກາ ຕາຢັຮ ຕາປູ່ນ ກຣັອງ ເຢຊູ ອຶມປຣ່ອມ ປາຍ ເຣ່ງ ລາລື່ ນ່ະໄນ່: \"ຍ່ອງ ເຢືາງ ເຈົາຣາຊີ! ແຊອ໌ ໂອນ ເຢືາງ ເຈົາຣາຊີ ໂອນ ເຍືາ ເບີນ ບຸ່ນ, ເຍືາ ກາ ແຕີ່ອ໌ ຍ່ອນ ຣາມຶ່ຮ ເຢືາງ ເຈົາຣາຊີ! ");
INSERT INTO ncq_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ໂອນ ໄຮ ຍ່ອງ ເຢືາງ ເຈົາຣາຊີ. ແຕີ່ອ໌ ເຈີ່ ຊົດ ແຕ ເຕືາວ ປັຣເຍືາ ດາວິດ, ອາຈວາຍຮ ອາເຈ່ຮ ໄຮ! ໂຮຊັນນາ! ຍ່ອງ ເຢືາງ ເຈົາຣາຊີ!\" ");
INSERT INTO ncq_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ເຈີ່ ເຢຊູ ມູ່ດ ປໍ ເມືອງ ເຢຣູຊາເລັມ, ກະ ອັນ ມູ່ດ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ. ພໍກາ ອັນ ກູລຍານ ເນ່ ອຶນແຍ່ະ, ເຈີ່ ອັນ ລັ່ອຮ ແຕ ດຸງ ຊາງ ປື່ດ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ມັນຈິ່ດ ລາ ບາຣ ນະ. ເຈີ່ ໄລ່ ມູ່ດ ຕຶ່ງ ວີ່ລ ເບັດທານີ ແອັນ ຍ່ອນ ມານາງ ແຈ່ະ ອີ ຕາບື່ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ພໍກາ ຕາໄງ ຕາໄມ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ລັ່ອຮ ແຕ ວີ່ລ ເບັດທານີ. ເຈີ່ ເຢຊູ ຊັອງ ມາເຍືາຍຮ ໂດຍ. ");
INSERT INTO ncq_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ພໍກາ ເຢຊູ ເຮີມ ແຕ ເຢີ່ງ ມູ ກັ່ລ ລາວັ່ຮ ເບີນ ຊາລາ ຊາອຶ່ຍ, ເຈີ່ ເຢຊູ ມູ່ດ ເນ່ ເບີນ ມາ ຕາ ເບີນ ປາໄລ, ມາ ອັນ ເຮີມ ຕາ ເບີນ ປາໄລ. ເບີນ ແອີງ ຊາລາ ເມືາດ, ຍ່ອນ ຕາ ຢວາຮ ແຕີ່ອ໌ ປາເນ່ນ ປາໄລ. ");
INSERT INTO ncq_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ເຢຊູ ປາຍ ໂຈະ ກັ່ລ ລາວັ່ຮ ກັອຍ: \"ແຕ ຊານໍ່ ເດີງ ປໍ ກັອຍ ແນະ, ອຶນໂຈຍ ໂອນ ອາແລ່ະ ເບີນ ຈາ ປາໄລ ໄມ່ ນັ່ອງ.\" ມູ່ ກາ ຣຍານ ແຕ ອັນ ຊັອງ ເຢຊູ ປາຍ ນ່ະກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ແວັດ ກັອຍ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ເປາະ ແຕີ່ອ໌ ເມືອງ ເຢຣູຊາເລັມ. ເຢຊູ ມູ່ດ ຕຶ່ງ ຊັງອາຣ ດຸງ ຊາງ ປື່ດ, ເຈີ່ ອັນ ຕູ່ຍຮ ອາລັ່ອຮ ມັຮ ກວາຍ ຈູຈິ ຕຶ່ງ ດຸງ ຊາງ ກັອຍ. ເຢຊູ ກາແຕິບ ຕັຮ ມັຮ ອຶນຕຸ ເນົ່າ ປຽນ ປຣະ, ກະ ອຶນຕຸ ກວາຍ ຕາກູ ຈິ ແຈມ ປາເຣືາດ. ");
INSERT INTO ncq_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ເຈີ່ ເຢຊູ ກາແອັຮ ຕາ ໂອນ ກວາຍ ເດີງ ເກຣີ່ງ ຊາລັຮ ດຸງ ຊາງ. ");
INSERT INTO ncq_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ເຈີ່ ເຢຊູ ອາຕີ ໄລ່ ປາຍ: \"ຕຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ຄຽນ ປາຕັບ ດໍອ໌ ປາຍ: \"ຕຶ່ງ ດຸງ ຊາງ ເກົາ ລາ ອຶນຕຸ ກວາຍ ກູ່ ກຣວາງ ກູແຕອ໌ ເກົາແຊອ໌ ຊັອງ. ມາ ເຍືາ ຕະ ດຸງ ໄນ່ ແກີດ ກື່ບ ໂອນ ກວາຍ ຊາແວງ ມູ່ດ ໂຕ່ະ!\" ");
INSERT INTO ncq_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ພໍກາ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ກະ ມູ່ ກາ ອາຕີ ຄານອດ ອິດຊະຣາເອລ ຊັອງ ນ່ະກັອຍ, ເຈີ່ ໄລ່ ຈໍ່ອ໌ ຣານາ ອີ ກາຈີດ ເຢຊູ. ມາ ໄລ່ ອຶງກັອຮ ເຢຊູ ຍ່ອນ ມັຮ ກອນແຊມ ຊາງັດ ກະ ງຶ່ດ ຕຶ່ງ ຣາງຶ່ຮ ໄລ່, ຍ່ອນ ແຕ ປັຣນາຍ ເຢຊູ ອາຕີ. ");
INSERT INTO ncq_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ພໍກາ ມານາງ ຕາບື່, ເຈີ່ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ລັ່ອຮ ແຕ ເມືອງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ປັ່ງ ຕາຣື່ບ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ຕາຢັຮ ຊາລັຮ ກັ່ລ ລາວັ່ຮ ກາ ເຢຊູ ເວ່ນ ແຕ ຕາໄງ ອຶນໂຍ່ງ. ມູ່ ກາ ຣຍານ ແຕ ອັນ ເຮີມ ກັ່ລ ລາວັ່ຮ ກັອຍ ຣັ່ອຮ ກູຈີດ ແຕ ໂກຍ໌ ແຕີ່ອ໌ ເຣ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ເປໂຕ ຄຶ່ດ ຊາແຍີ ບັອງ ກາ ເຢຊູ ເວ່ນ ດໍອ໌ ກັ່ລ ອາລ່ອງ ກັອຍ, ປາໄຮ. ອັນ ອາຕີ ເຢຊູ ປາຍ: \"ອາຈານ ເອີຍ! ຊາລີອ໌ ກັອຍ ແມະ, ກັ່ລ ລາວັ່ຮ ກາ ອາຈານ ເວ່ນ ດໍອ໌ ຣັ່ອຮ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ເຢຊູ ອາຕີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ອຶງເຄາະ ເຍືາ ຊາອຳ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ອາແລ່ະ ກາ ອາຕີ ກົຮ ໄນ່ ປາຍ 'ເອົາ! ໄມ່ ອາຊີ່ອ໌ ເຈີ່ ຊາແລັຮ ອາແຊງ ປໍ ທາເລ,' ຄັນ ອັນ ຕາ ເບີນ ກູຄຶ່ດ ອຶນເຕົ່າ ຕຶ່ງ ຣາງຶ່ຮ ອັນ ມາ ອັນ ຊາອຳ, ເຕ່ອ໌ ແກີດ ນ່ະ ອັນ ອາຕີ. ");
INSERT INTO ncq_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ອຶນເຕົ່າ ເຍືາ ແຊອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ, ເຍືາ ອຶງເຄາະ ຊາອຳ ຕຶ່ງ ຣາງຶ່ຮ ເຍືາ ກະ ອຶງກ່ອງ ເບີນ, ເຈີ່ ເຍືາ ເບີນ ຣັ່ບ ຣາມຶ່ຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","\"ແຕີ່ອ໌ ເຍືາ ຕາຢຶ່ງ ເກົາແຊອ໌, ຄັນ ອຶນເຕົ່າ ເຍືາ ເບີນ ອາກັນ ຣາລິ່ຮ ຕຶ່ງ ຣາງຶ່ຮ ເຍືາ ໂຈະ ເຢົ່າ ໄບ ຕຶ່ງ ວີ່ລ, ອຶງເຄາະ ເຍືາ ຕັຮ ໂລ່ຍຮ ໂອນ ໄລ່; ນ່ະກັອຍ ເຕ່ອ໌ ເຢືາງ ເຈົາຣາຊີ ຕັຮ ໂລ່ຍຮ ໂອນ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ຄັນ ເຍືາ ມາ ຕາ ເບີນ ຕັຮ ໂລ່ຍຮ ກວາຍ ກາ ຕະ ໂລ່ຍຮ ໂຈະ ເຍືາ, ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ຕັຮ ໂອນ ເຕ່ ໂລ່ຍຮ ເຍືາ.\" ");
INSERT INTO ncq_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ເຈີ່ ແວັດ ກັອຍ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ມູ່ດ ຊາ ປໍ ເມືອງ ເຢຣູຊາເລັມ. ພໍກາ ເຢຊູ ຕາຢັຮ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ, ຈຸ່ມ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ, ມູ່ ກາ ອາຕີ ຄານອດ, ກະ ມັຮ ກວາຍ ເທົາແກ ຈຸ່ມເຈືອ ມັຮ ໄລ່ ກັອຍ ແຕີ່ອ໌ ປໍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ເຈີ່ ໄລ່ ຕາແບີບ ເຢຊູ ປາຍ: \"ໄມ່ ເບີນ ອຳນາດ ແຕ ແລ່ະ ໂອນ ຕະ ຣານະ ໄນ່? ເນົ່າ ກາ ໂອນ ໄມ່ ເບີນ ອຳນາດ ກັອຍ?\" ");
INSERT INTO ncq_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ເຢຊູ ຕາແອີຍ ໄລ່ ກັອຍ ປາຍ: \"ເກົາ ຢໍອ໌ ອີ ຕາແບີບ ເຍືາ ມວຍ ຣາມຶ່ຮ ອຶນໂຍ່ງ. ຄັນ ເຍືາ ຕາແອີຍ ເກົາ, ເຈີ່ ເກົາ ອາຕີ ໂອນ ເຍືາ ດັງ ເກົາ ຕະ ຣານະ ໄນ່ ລາ ຍ່ອນ ອຳນາດ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ໂອນ ເຍືາ ອາຕີ ເກົາ ເວືາຍ: ເນົ່າ ກາ ໂອນ ອຳນາດ ປໍ ໂຢຮັນ ກາ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌? ອຳນາດ ກັອຍ ແຕີ່ອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ ມາ ແຕີ່ອ໌ ແຕ ກວາຍ ຊັອງ?\" ");
INSERT INTO ncq_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ໄລ່ ກັອຍ ມານະ ຕາແບີບ ມານະ ປາຍ: \"ໄຮ ອີ ຕາແອີຍ ນານ່ະ? ຄັນ ໄຮ ຕາແອີຍ ປາຍ: ແຕີ່ອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ, ອຶງກັອຮ ອັນ ອາເບຼິຮ ລັ່ຮ ແອັນ ປາຍ: 'ຄັນ ນ່ະກັອຍ ນານ່ະ ເຍືາ ຕາ ເບີນ ຊາອຳ ໂຢຮັນ?' ");
INSERT INTO ncq_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ມາ ຄັນ ໄຮ ຕາແອີຍ ປາຍ: 'ຣານະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໄນ່ ຈຸງ ແຕີ່ອ໌ ແຕ ກວາຍ ຊັອງ,' ອຶງກັອຮ ກອນແຊມ ໄຄອ໌ ໄຮ, ຍ່ອນ ອຶນແຍ່ະ ກອນແຊມ ປາຍ ໂຢຮັນ ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ເຈີ່ ໄລ່ ຕາແອີຍ ເຢຊູ ປາຍ: \"ຮິ ຕາ ດັງ.\" ເຈີ່ ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ຄັນ ນ່ະກັອຍ ເກົາ ຕາ ເບີນ ອາຕີ ເຍືາ ເຕ່ ເນົ່າ ກາ ໂອນ ເກົາ ເບີນ ອຳນາດ ຕະ ມັຮ ຣານະ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ເຈີ່ ເຢຊູ ຕະ ອຶນຕີ ປັຣນາຍ ຊາກຳ ປາຍ: \"ເບີນ ຣາເລົາ ມານະ ຕະ ຊວນ ອາງຸ່ນ. ອັນ ຕະ ດໍອ໌ ກຣ່ອງ ຈວບ ຊວນ, ກະ ອັນ ຈັອຮ ຕາເມົາ ຕະ ດໍອ໌ ຣາເລ່າະ ອຽນ ອີ ປັດ ໂຈະ ແດີອ໌ ອາງຸ່ນ. ອັນ ຕະ ດໍອ໌ ດຸງ ກຍາອ໌ ແຮີ. ພໍກາ ກັອຍ ອັນ ໂອນ ກວາຍ ເມືານ ຕະ, ເຈີ່ ອັນ ເປາະ ກຣວາງ ການໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ພໍກາ ແຕີ່ອ໌ ປາເນ່ນ ເນົ່າ ໂປຍ໌ ປາໄລ ອາງຸ່ນ, ອັນ ແປຣີ ມານະ ກວາຍ ຊູລ ອັນ ເປາະ ປໍ ມູ່ ກາ ເມືານ ຕະ ຊວນ ກັອຍ, ໂອນ ເປາະ ອີດ ຊັຣແນອ໌ ອັນ ແຕ ຊັຣນົຮ ແຕ ມູ່ ກາ ເມືານ ຕະ ຊວນ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ພໍກາ ກວາຍ ຊູລ ເປາະ ແຕີ່ອ໌ ຊວນ, ເຈີ່ ໄລ່ ກາ ເມືານ ຕະ ຊວນ ກັອຍ ໂກບ ອັນ ກະ ໄລ່ ປຍາຍຮ ອັນ ເຈີ່ ໄລ່ ຕູ່ຍຮ ໂອນ ອັນ ເຈົາ ລັ່ຮ ແອີງ ຈະ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ເຈີ່ ອຶນເຈົາ ຊວນ ກັອຍ ແປຣີ ກວາຍ ຊູລ ມານະ ແອັນ ເປາະ ປໍ ໄລ່ ກັອຍ, ເຈີ່ ໄລ່ ກັອຍ ປຍາຍຮ ຊູລ ກັອຍ ຈົນ ເບິ ແປຼີ ໂຊະ, ກາ ໄລ່ ປາຍ ອາລິ່ຮ ຊູລ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ອຶນເຈົາ ຊວນ ກັອຍ ແປຣີ ລັ່ຮ ຊູລ ມານະ ແອັນ ເປາະ ປໍ ກັອຍ, ເຈີ່ ໄລ່ ກັອຍ ກາຈີດ ຕັຮ ຊູລ ກັອຍ. ອຶນເຈົາ ຊວນ ແປຣີ ລັ່ຮ ຊາ ຊູລ ອັນ ຊາອຶ່ຍ ນະ. ອັນ ກາ ມູ່ ກັອຍ ຕະ ປຍາຍຮ, ອັນ ກາ ເນົ່າ ກາຈີດ ຕັຮ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ພໍກາ ປັຣຕູຍ໌ ອຶນເນີ່ມ ມານະ ກອນ ຣາເລົາ ກາ ອັນ ອາໂຢ່ະ ລາລື່. ອຶນເຈົາ ຊວນ ກັອຍ ແປຣີ ກອນ ອັນ ແອັນ ເປາະ. ອັນ ຄຶ່ດ ປາຍ ເນົ່າ ຢຳນັ່ບ ກອນ ອັນ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ມາ ໄລ່ ກາ ເມືານ ຊວນ ກັອຍ ປາຍ: \"ອັນ ໄນ່ ກາ ຕາລາ ມັຮ ກາ ມູ່ນ ໄນ່. ອຶງເຄາະ ໄຮ ກາຈີດ ຕັຮ ອັນ, ເຈີ່ ອຶນແຍ່ະ ມູ່ນ ອັນ ໄຮ ແອັນ ເບີນ ຕາລາ!'\" ");
INSERT INTO ncq_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ຍ່ອນ ນ່ະກັອຍ, ໄລ່ ກັອຍ ໂກບ ກອນ ອຶນເຈົາ ຊວນ ກັອຍ ເປາະ ກາຈີດ ຕັຮ, ເຈີ່ ໄລ່ ຕາເວ່ງ ອາລັ່ອຮ ຢັ່ຮ ນໍ່ອ໌ ຊວນ.\" ");
INSERT INTO ncq_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ເຢຊູ ຕາແບີບ ປາຍ: \"ຄັນ ແກີດ ນ່ະກັອຍ, ອຶນເຈົາ ຊວນ ອີ ຕະ ນານ່ະ? ອັນ ອີ ເປາະ ກາຈີດ ຕັຮ ອຶນແຍ່ະ ນະ ມູ່ ກາ ເມືານ ຊວນ ອັນ, ເຈີ່ ຊວນ ອາງຸ່ນ ກັອຍ ອັນ ໂອນ ກວາຍ ການໍ່ອ໌ ແອັນ ເມືານ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ໄກຣ ມາ ຕາ ເບີນ ເຍືາ ອານ ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ກາ ເນົ່າ ຄຽນ ດໍອ໌ ປາຍ ນ່ະໄນ່: 'ຕາເມົາ ກາ ກວາຍ ເຈືາງ ຕະ ດຸງ ຕາເວ່ງ ຕັຮ ເຈີ່, ມາ ເຢືາງ ເຈົາຣາຊີ ອີດ ຕາເມົາ ກັອຍ ດໍອ໌ ຕຶ່ງ ກູຈົ່ກ ຕະ ໂອນ ດຸງ ແກີດ ຈັບ. ");
INSERT INTO ncq_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ຣານະ ໄນ່ ລາ ແຕີ່ອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ, ພໍກາ ມັ່ດ ໄຮ ເຮີມ, ຣາງຶ່ຮ ໄຮ ຊັອງ ງຶ່ດ ລາລື່.'\" ");
INSERT INTO ncq_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ນ່ະກັອຍ ໄລ່ ຈໍ່ອ໌ ຣາລິ່ຮ ອີ ໂກບ ເຢຊູ ຍ່ອນ ໄລ່ ດັງ ອັນ ປາຍ ປັຣນາຍ ຊາກຳ ໄນ່ ແຕ ໄລ່, ມາ ໄລ່ ອຶງກັອຮ ມັຮ ກອນແຊມ ກັອຍ. ເຈີ່ ໄລ່ ເປາະ ຕັຮ ແຕ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ເຈີ່ ຈຸ່ມ ພາຣີຊາຍ ກະ ມູ່ ເຮໂຣດ ໄລ່ ແປຣີ ກວາຍ ໂອນ ເປາະ ຈໍ່ອ໌ ເຢຊູ, ເຈີ່ ອຶງກ່ອຍ ຕາຕ່ອຍ໌ ຈໍ່ອ໌ ຣານະ ໂລ່ຍຮ ແຕ ປັຣນາຍ ອັນ ຕະ ອຶນຕີ. ");
INSERT INTO ncq_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ໄລ່ ກັອຍ ເປາະ ແຕີ່ອ໌ ປໍ ເຢຊູ ເຈີ່ ໄລ່ ຕາແບີບ ເຢຊູ ປາຍ: \"ອາຈານ ເອີຍ! ຮິ ດັງ ເຈີ່ ປາຍ ອາຈານ ລາ ກວາຍ ຕານັ່ອງ ອໍ, ກະ ອາຈານ ຕາ ເບີນ ຕາປູ່ນ ອາແລ່ະ, ຍ່ອນ ຢັ່ຮ ເມືາງ ອາຈານ ອຶນແຍ່ະ ມັຮ ກວາຍ ແກີດ ລີ ຣາລີ ອຶນແຍ່ະ. ມາ ອາຈານ ອາຕີ ປັຣນາຍ ຕານັ່ອງ ແຕ ເຢືາງ ເຈົາຣາຊີ ໂອນ ກວາຍ ຕະ ປວາຍ. ແຊອ໌ ອາຈານ ອາຕີ ໂອນ ຮິ, ປຍາຍ໌ ມາ ຕາ ເບີນ ໄຮ ອຶງເຄາະ ມ່ອບ ປຣະ ປາຊີ ປໍ ເຕືາວ ປັຣເຍືາ ໂຣມ ກາ ກຣິ່ຮ? ຮິ ອຶງເຄາະ ໂອນ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ເຢຊູ ດັງ ປາຍ ໄລ່ ແຕີ່ອ໌ ລ່ອງ ອັນ. ເຈີ່ ອັນ ຕາແອີຍ ໄລ່ ປາຍ: \"ມູ່ ເຍືາ ແຕີ່ອ໌ ລ່ອງ ເກົາ ຕະ ອຶນເຕົ່າ? ເຍືາ ອີດ ປຣະ ອານາມ ມູ ກຼອງ ປໍ ໄນ່ ໂອນ ເກົາ ຊາລີອ໌.\" ");
INSERT INTO ncq_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ໄລ່ ອີດ ປຣະ ອານາມ ໂອນ ປໍ ເຢຊູ, ເຈີ່ ເຢຊູ ຕາແບີບ ໄລ່ ປາຍ: \"ຣູ່ບ ເນົ່າ ກະ ຣາມຶ່ຮ ເນົ່າ ຄຽນ ດໍອ໌ ຕຶ່ງ ປຣະ ໄນ່?\" ໄລ່ ຕາແອີຍ ປາຍ: \"ຣູ່ບ ເຕືາວ ປັຣເຍືາ ໂຣມ ກາ ກຣິ່ຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ເຢຊູ ອາຕີ ໄລ່ ປາຍ: \"ເກຣີ່ງ ເຕືາວ ປັຣເຍືາ ໂຣມ ກາ ກຣິ່ຮ ອຶງເຄາະ ເຍືາ ກູລັຮ ລັ່ຮ ໂອນ ເຕືາວ ປັຣເຍືາ ໂຣມ ກາ ກຣິ່ຮ; ກະ ເກຣີ່ງ ເຢືາງ ເຈົາຣາຊີ ອຶງເຄາະ ເຍືາ ກູລັຮ ລັ່ຮ ໂອນ ເຢືາງ ເຈົາຣາຊີ.\" ພໍກາ ອຶນແຍ່ະ ນະ ໄລ່ ຊັອງ ເຢຊູ ຕາແອີຍ, ໄລ່ ຊັອງ ງຶ່ດ ລາລື່ ແຕ ປັຣນາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ເບີນ ກວາຍ ແຕ ຈຸ່ມ ຊາດູກາຍ ແຕີ່ອ໌ ປໍ ເຢຊູ ເຕ່. ໄລ່ ກັອຍ ປາຍ ກວາຍ ກາ ກູຈີດ ເຈີ່ ຕາ ເຕ່ອ໌ ອາມົ່ງ ລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","ໄລ່ ຕາແບີບ ເຢຊູ ປາຍ: \"ອາຈານ ເອີຍ! ໂມເຊ ຄຽນ ເຈີ່ ໂອນ ໄຮ ດັງ, ຄັນ ອາຍ ກູຈີດ, ມາ ລາກວຍ ອັນ ອຶນນັ່ອງ ອາມົ່ງ ກະ ໄລ່ ຕາ ເກີ່ຍ ເບີນ ກອນ, ນ່ະກັອຍ ອາແອມ ອັນ ແອັນ ອຶງເຄາະ ແຈມ ລາກວຍ ອາຍ, ໂອນ ອັນ ເບີນ ກອນ ແກີດ ຈຸ່ມເຈືອ ອາຍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ອຶມແບິ ອາໄຣ່ ເບີນ ຕາປູ່ລ ນະ ແຊມອາຍ. ອາຍ ກັ່ລ ໄລ່ ອີດ ລາກວຍ. ເຈີ່ ອັນ ກູຈີດ ແຕ ຕາ ຢວາຮ ເບີນ ກອນ. ");
INSERT INTO ncq_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ເຈີ່ ອາແອມ ກາ ເຕ່ດ ອັນ ແອັນ ເຊີບ ລາກວຍ ອາຍ ອັນ. ມາ ຕາ ຢວາຮ ເບີນ ກອນ ເຈີ່ ອັນ ກູຈີດ ເຕ່. ນ່ະກັອຍ ອາແອມ ອາລັອຮ ແອັນ ລາ ມູເຈິງ ອາຍ ອຶນດີ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ໄລ່ ຕາປູ່ລ ນະ ຕະ ມູເຈິງ ກັອຍ ເຕ່. ອາແລ່ະ ລາ ຕາ ເບີນ ເບີນ ກອນ, ມາ ພໍກາ ໄລ່ ຕາປູ່ລ ນະ ກູຈີດ ອຶນແຍ່ະ; ກະ ອຶນຕູ່ນ ແອັນ ມັນແຊມ ກັອຍ ກູຈີດ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ພໍກາ ມັຮ ກວາຍ ກູຈີດ ເບີນ ອາມົ່ງ ລັ່ຮ, ມັນແຊມ ກັອຍ ລາ ລາກວຍ ເນົ່າ? ຍ່ອນ ຕາປູ່ລ ນະ ໄລ່ ລາ ແກີດ ກາຢາອ໌ ມັນແຊມ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ເຢຊູ ອາຕີ ລັ່ຮ ໄລ່ ກັອຍ ປາຍ: \"ເຍືາ ຕະ ອຶນຕີ ຕາ ປຍາຍ໌, ຍ່ອນ ເຍືາ ຕາ ເບີນ ດັງ ປັຣນາຍ ແຕ ເຢືາງ ເຈົາຣາຊີ ກາ ເນົ່າ ຄຽນ ແຕ ອຶມແບິ; ກະ ເຍືາ ຕາ ເບີນ ດັງ ອຳນາດ ປື່ດ ລາລື່ ແຕ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ພໍກາ ໄລ່ ກາ ກູຈີດ ກັອຍ ອາມົ່ງ ລັ່ຮ, ໄລ່ ຕາ ເບີນ ຣາອີດ ນັ່ອງ ແກີດ ລາກວຍ ກາຢາອ໌, ມູເຈິງ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ຕຶ່ງ ມັນລັ່ອງ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","\"ມາ ແຕ ຣານະ ກວາຍ ກູຈີດ, ເຈີ່ ອາມົ່ງ ລັ່ຮ, ນານ່ະ ເຍືາ ຕາ ເກີ່ຍ ອານ ຕຶ່ງ ປຶ່ງ ໂມເຊ ຄຽນ ແຕ ປູ່ລ ອູ່ຍຮ ກາ ເບຼີ ມາ ຕາ ເບີນ ກາດ. ປໍ ອຶນຕຸ ກັອຍ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ໂມເຊ ປາຍ: 'ເກົາ ລາ ເຢືາງ ເຈົາຣາຊີ ກາ ອັບຣາຮາມ, ອີຊາກ, ກະ ຢາໂຄບ ອຶນນັ່ອງ ຊາງ ຕຶ່ງ ມັນລັ່ອງ.' ");
INSERT INTO ncq_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ເຕ່ອ໌ ໄຮ ດັງ ໄລ່ ກັອຍ ອາມົ່ງ ລັ່ຮ ແຕ ກູຈີດ, ຍ່ອນ ກວາຍ ກູຈີດ ຕາ ເຕ່ອ໌ ຊາງ ເຢືາງ ເຈົາຣາຊີ. ແອີງ ໄລ່ ກາ ອາມົ່ງ ຊັອງ ເຕ່ອ໌ ຊາງ ອັນ. ມາ ເຍືາ ຕາ ເບີນ ດັງ ອຶນເຕົ່າ ເລີ່ຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ເບີນ ມານະ ແຕ ມູ່ ກາ ອາຕີ ຄານອດ ແຕີ່ອ໌ ປໍ ກັອຍ ກະ ຊັອງ ໄລ່ ກັອຍ ຕະ ອຶນຕີ. ອັນ ຊັອງ ເຢຊູ ຕາແອີຍ ອໍ ລາລື່, ນ່ະກັອຍ ອັນ ຕາແບີບ ເຢຊູ ປາຍ: \"ແຕ ມັຮ ຄານອດ ເຢືາງ ເຈົາຣາຊີ ປາຕັບ, ຄານອດ ອາແລ່ະ ກາ ປື່ດ ກາເລີຍ ອຶນແຍ່ະ ແຕ ການໍ່ອ໌?\" ");
INSERT INTO ncq_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ເຢຊູ ຕາແອີຍ ລັ່ຮ ອັນ ປາຍ: \"ໄນ່ ລາ ຄານອດ ປື່ດ ກາເລີຍ ອຶນແຍ່ະ ແຕ ການໍ່ອ໌ ເຢືາງ ເຈົາຣາຊີ ປາຕັບ: 'ກວາຍ ອິດຊະຣາເອລ ເອີຍ! ເຍືາ ຊາງັດ! ເຢືາງ ເຈົາຣາຊີ, ອຶນເຈົາ ໄຮ, ເບີນ ແອີງ ມານະ ອັນ ແຕິ່. ");
INSERT INTO ncq_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ອຶງເຄາະ ເຍືາ ອາໂຢ່ະ ເຢືາງ ເຈົາຣາຊີ, ອຶນເຈົາ ເຍືາ, ອຶນແຍ່ະ ຣາງຶ່ຮ ເຍືາ, ອຶນແຍ່ະ ຣາແຮີ ເຍືາ, ອຶນແຍ່ະ ການິ່ດ ເຍືາ, ກະ ອຶນແຍ່ະ ບັນ ເຣ່ງ ເຍືາ.' ");
INSERT INTO ncq_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ກະ ຄານອດ ປາຕັບ ກາ ບາຣ ປື່ດ ກາເລີຍ ອຶນແຍ່ະ ແຕ ການໍ່ອ໌ ລາ ນ່ະໄນ່: 'ອຶງເຄາະ ເຍືາ ອາໂຢ່ະ ເຢົ່າ ມູເຈິງ ເຍືາ ອາໂຢ່ະ ຈະ ເຍືາ ເບີມ.' ຕາ ເບີນ ຄານອດ ປາຕັບ ອາແລ່ະ ປື່ດ ກາເລີຍ ແຕ ບາຣ ຄານອດ ປາຕັບ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ອັນ ກາ ແຕ ມູ່ ກາ ອາຕີ ຄານອດ ກັອຍ ຕາແອີຍ ລັ່ຮ ເຢຊູ ປາຍ: \"ອາຈານ ເອີຍ! ໄກຣ ລາລື່ ອາຈານ ອາຕີ. ອາຈານ ອາຕີ ປຍາຍ໌, ເຢືາງ ເຈົາຣາຊີ ລາ ມານະ ອັນ ຊັອງ, ແວັດ ແຕ ເຢືາງ ເຈົາຣາຊີ ລາ ຕາ ເບີນ ເຢືາງ ອາແລ່ະ ກາ ຊົດ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ຄັນ ໄຮ ອາໂຢ່ະ ເຢືາງ ເຈົາຣາຊີ ອຶນແຍ່ະ ຣາງຶ່ຮ, ອຶນແຍ່ະ ການິ່ດ, ກະ ອຶນແຍ່ະ ບັນ ເຣ່ງ, ກະ ໄຮ ອາໂຢ່ະ ເຢົ່າ ມາຮ ໄຮ ອາໂຢ່ະ ຈະ ໄຮ ເບີມ, ຣານະ ໄນ່ ລາ ອໍ ກາເລີຍ ແຕ ເນົ່າ ບຸຮ ຊັນຕຣັ່ນ ແຕີລາ ມ່ອບ ເກຣີ່ງ ການໍ່ອ໌ ດໍອ໌ ຊາງ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ເຢຊູ ຊັອງ ອັນ ກັອຍ ຕາແອີຍ ແຄວ໌ ລາລື່, ເຈີ່ ເຢຊູ ອາຕີ ລັ່ຮ ອັນ ປາຍ: \"ແຈ່ະ ໄມ່ ອີ ເບີນ ມູ່ດ ຕຶ່ງ ຈຸ່ມ ກາ ເຢືາງ ເຈົາຣາຊີ ຊົດ, ຕາ ເບີນ ດູ່ນ ນັ່ອງ.\" ແວັດ ກັອຍ ຕາ ເບີນ ເນົ່າ ຍັ່ນ ຕາແບີບ ນັ່ອງ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ບັອງ ກາ ເຢຊູ ອາຕີ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ, ອັນ ຕາແບີບ ປາຍ: \"ນານ່ະ ກວາຍ ອາຕີ ຄານອດ ປາຍ ກຣີດ ລາ ແຕ ຈຸ່ມເຈືອ ດາວິດ? ");
INSERT INTO ncq_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ກູໂຕ ດາວິດ ແຕິ່ ປາຍ ປັຣນາຍ ໄນ່ ຍ່ອນ ແຕ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ແປຣີ ອັນ ປາຍ ນ່ະໄນ່: 'ເຢືາງ ເຈົາຣາຊີ ອາຕີ ໂຈະ ອຶນເຈົາ ເກົາ ປາຍ: \"ໄມ່ ຕາກູ ແອີດ ຢັ່ຮ ອາຕ່ຳ ເກົາ ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ແລ່ະ ເກົາ ໂອນ ໄລ່ ກາ ຢໍອ໌ ອີ ກາຈີດ ໄມ່ ແອີດ ປື່ນ ຕາລາງ ອາເຢີງ ໄມ່, ແກີດ ຊູລ ໄມ່.\"' ");
INSERT INTO ncq_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ກູໂຕ ດາວິດ ແຕິ່ ດໍອ໌ ກຣີດ ໄນ່ ລາ 'ອຶນເຈົາ.' ນານ່ະ ເຕ່ອ໌ ດາວິດ ດໍອ໌ ກວາຍ ແຕ ຈຸ່ມເຈືອ ອັນ ເບີມ ລາ 'ອຶນເຈົາ?'\" ກວາຍ ກຼຶ່ງ ກັອຍ ຊັອງ ຣໍ່ອ໌ ອໍ ລາລື່ ເຢຊູ ອາຕີ ນ່ະກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ບັອງ ກາ ເຢຊູ ອາຕີ, ອັນ ປາຍ ນ່ະໄນ່: \"ເຍືາ ອຶນໂຈຍ ຕະ ມູເຈິງ ກວາຍ ອາຕີ ຄານອດ. ໄລ່ ກັອຍ ຢໍອ໌ ອີ ແຊິບ ລາລື່ ອາຢັ່ອຮ ຕ່ອງ, ກະ ໄລ່ ຢໍອ໌ ລາລື່ ໂອນ ກວາຍ ການໍ່ອ໌ ຣາບັນ ອໍ ໄລ່ ບັອງ ກາ ໄລ່ ແອີດ ກະ ກວາຍ ກຼຶ່ງ. ");
INSERT INTO ncq_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ໄລ່ ຢໍອ໌ ອີ ເບີນ ກາເຈີ່ງ ຕາກູ ອໍ ລາລື່ ກາເລີຍ ອຶນແຍ່ະ ແຕ ການໍ່ອ໌ ແອີດ ຕຶ່ງ ດຸງ ຊາງ, ກະ ໄລ່ ຢໍອ໌ ອີ ຕາກູ ຢັ່ຮ ຕີ່ ແຕີ່ອ໌ ເນົ່າ ການື່ຍ ໄລ່ ແຕີ່ອ໌ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ໄລ່ ກັອຍ ໂລ່ບ ມັຮ ດຸງ ອຶມເປ່ອ໌ ກູມາຍ; ເຈີ່ ໄລ່ ເກົາແຊອ໌ ປັຣນາຍ ຕີ່ ຢໍອ໌ ອີ ໂອນ ເນົ່າ ຍ່ອງ ປາຍ ໄລ່ ເມ່ນ ຕານັ່ອງ ອໍ. ມາ ເຈີ່ ປໍ ເມືາງ ໂຕ່ດ ໄລ່ ກັອຍ ອຶນຕັອງ ກາເລີຍ ກວາຍ ການໍ່ອ໌.\" ");
INSERT INTO ncq_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ແວັດ ກັອຍ ເຢຊູ ແອີດ ຕາກູ ແຈ່ະ ອຶນຕຸ ເນົ່າ ເກີ່ຍ ໂຈະ ປຣະ ຊາງ. ອັນ ເນ່ ກວາຍ ກຼຶ່ງ ກັອຍ ໂຈະ ປຣະ ຊາງ ຕຶ່ງ ຮີ່ບ ກັອຍ. ກຼຶ່ງ ກວາຍ ຊຸ ໂຈະ ປຣະ ຊາອຶ່ຍ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ມາ ເບີນ ມານະ ອຶມເປ່ອ໌ ກູມາຍ ກາດີດ ລາລື່ ແຕີ່ອ໌ ປໍ ກັອຍ. ອັນ ໂຈະ ບາຣ ກຼອງ ປຣະ ກາ ເບີນ ເກືາ ບີ່ອ໌ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ເຈີ່ ເຢຊູ ກູອ໌ ມູ່ ກາ ຣຍານ ແຕ ອັນ ແຕີ່ອ໌ ປໍ ອັນ, ກະ ອັນ ອາຕີ ໄລ່ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ອຶມເປ່ອ໌ ກູມາຍ ກາດີດ ໄນ່, ອັນ ໂຈະ ປຣະ ຊາອຶ່ຍ ກາເລີຍ ອຶນແຍ່ະ ແຕ ມັຮ ກວາຍ ການໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ອຶນແຍ່ະ ມັຮ ກວາຍ ກັອຍ ໂຈະ ປຣະ ແກຼີຍ ໄລ່ ຕັອກ ຈາ; ມາ ອຶມເປ່ອ໌ ກູມາຍ ໄນ່ ແອິ ລາລື່, ມາຮ ແລ່ະ ອັນ ເບີນ ອັນ ໂຈະ ອຶນແຍ່ະ ມາຮ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ພໍກາ ເຢຊູ ລັ່ອຮ ແຕ ດຸງ ຊາງ ປື່ດ, ເບີນ ມານະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ອາຕີ ອັນ ປາຍ: \"ອາຈານ ເອີຍ! ເນ່ ປໍ ກັອຍ! ດຸງ ຊາງ ປື່ດ ກັອຍ ກາ ເນົ່າ ຕະ ແຕ ຕາເມົາ ປື່ດ ລາ ອໍ ລາລື່!\" ");
INSERT INTO ncq_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ມາ ເຢຊູ ຕາແບີບ ລັ່ຮ ອັນ: \"ໄມ່ ເຮີມ ດຸງ ປື່ດ ໄນ່ ບໍ? ເຈີ່ ປໍ ເມືາງ ຕາເມົາ ກາ ເນົ່າ ຕະ ດຸງ ປື່ດ ໄນ່ ຕາ ເບີນ ຣາແຕັດ ນັ່ອງ ມັນຕຸ. ອັນ ຣາຕັຮ ອຶນແຍ່ະ.\" ");
INSERT INTO ncq_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ແວັດ ກັອຍ ເຢຊູ ຕາກູ ແອີດ ຕຶ່ງ ກົຮ ອາໂປ່ນ ຕາປຶ່ງ ດຸງ ຊາງ ປື່ດ. ເປໂຕ, ຢາໂກໂບ, ໂຢຮັນ, ກະ ອັນເດອາ, ແອີງ ໄລ່ ປູນ ນະ ແຕິ່ ແອີດ ກະ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ໄລ່ ກັອຍ ຕາແບີບ ອັນ ປາຍ: \"ແຊອ໌ ອາຈານ ອາຕີ ໂອນ ຮິ ດັງ, ອຶນນັ່ອງ ມາແລ່ະ ດູ່ນ ຣານະ ໄນ່ ແຕີ່ອ໌? ອຶນເຕົ່າ ກາ ແຕີ່ອ໌ ອາປັຮ ອຶນໂຍ່ງ ໂອນ ເນົ່າ ດັງ ປາຍ ຣານະ ໄນ່ ອີ ແຕີ່ອ໌?\" ");
INSERT INTO ncq_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ອຶງເຄາະ ເຍືາ ລາວັ່ງ ໂອນ ອໍ. ອຶນໂຈຍ ໂອນ ເນົ່າ ຣາພິ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ເຈີ່ ປໍ ເມືາງ ເບີນ ຊາອຶ່ຍ ນະ ແຕີ່ອ໌ ອາງ ຣາມຶ່ຮ ເກົາ. ໄລ່ ປາຍ ນ່ະໄນ່: 'ກູໂຕ ເກົາ ໄນ່ ແຕິ່ ລາ ກຣີດ!' ນ່ະກັອຍ ໄລ່ ຣາພິ ກຼຶ່ງ ນະ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","\"ພໍກາ ເຍືາ ຊັອງ ຮານ ເນົ່າ ຣາຕະ ແຈ່ະໆ ເຢີ່ງໆ, ເຍືາ ອຶນໂຈຍ ເກຣ່າະ ອຶນເຕົ່າ. ຣານະ ໄນ່ ອຶງເຄາະ ແຕີ່ອ໌ ອຶນໂຍ່ງ ເວືາຍ. ມາ ຕາ ຢວາຮ ແຕີ່ອ໌ ເຈຍ ຕາໄງ ປັຣຊົດ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ເບີນ ມູ່ ໄນ່ ຣາຕະ ກະ ມູ່ ກັອຍ; ກະ ກຣວາງ ໄນ່ ຣາຕະ ກະ ກຣວາງ ກັອຍ. ເບີນ ຊາອຶ່ຍ ອຶນຕຸ ກູແຕອ໌ ຣາໄມ່ ກູກື່ດ. ກະ ເບີນ ຊາອຶ່ຍ ອຶນຕຸ ແອິ ຊັຣນາ ຈາ. ມັຮ ຣາມຶ່ຮ ໄນ່ ລາ ຕາແບິ ແຕີ່ອ໌. ອຶນນັ່ອງ ເບີນ ຊາອຶ່ຍ ແອັນ ຣາມຶ່ຮ ຕຸ່ຮ ກັ່ດ ກາ ອີ ແຕີ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","\"ຍ່ອນ ນ່ະກັອຍ ອຶງເຄາະ ເຍືາ ລາວັ່ງ ໂອນ ອໍ. ເນົ່າ ໂກບ ເຍືາ, ເດີງ ເຍືາ ແຕີ່ອ໌ ປໍ ກວາຍ ຊົດ. ກະ ເນົ່າ ປຍາຍຮ ເຍືາ ຕຶ່ງ ດຸງ ຊາງ ກວາຍ ອິດຊະຣາເອລ. ອຶງເຄາະ ເຍືາ ຕາຢຶ່ງ ຢັ່ຮ ເມືາງ ກວາຍ ຊົດ ກະ ກວາຍ ເຕືາວ ປັຣເຍືາ ແຮີ ຍ່ອນ ເຍືາ ຕາປູ່ນ ເກົາ, ໂອນ ເຍືາ ອາຕີ ໂອນ ໄລ່ ດັງ ເຕ່ ແຕ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ອຶງເຄາະ ມູ່ ກາ ຕາປູ່ນ ເກົາ ອາຕີ ປັຣນາຍ ອໍ ແຕ ເຢືາງ ເຈົາຣາຊີ ໂອນ ອຶນແຍ່ະ ກູ່ ກຣວາງ ກວາຍ ດັງ ອຶນໂຍ່ງ ຕາໄງ ປັຣຊົດ. ");
INSERT INTO ncq_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ພໍກາ ເນົ່າ ໂກບ ເຍືາ ເດີງ ຕັດຊີ່ນ, ເຍືາ ອຶນໂຈຍ ອຸກ ດໍອ໌, ອຶນເຕົ່າ ເຍືາ ຢໍອ໌ ອີ ປາຍ. ມາ ເຍືາ ປາຍ ຕາປູ່ນ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ໂອນ ເຍືາ ອາຕີ ບັອງ ກາ ກັອຍ. ຍ່ອນ ປັຣນາຍ ໄນ່ ລາ ຕາ ແກີນ ປັຣນາຍ ເຍືາ, ມາ ປັຣນາຍ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ບັອງ ກາ ກັອຍ, ແຊມອາຍ ອີ ໂກບ ຣາຕວາອ໌ ແຊມອາຍ, ເຈີ່ ມ່ອບ ໂອນ ເນົ່າ ກາຈີດ, ກະ ອຶມປໍ່ ມ່ອບ ໂອນ ເນົ່າ ກາຈີດ ກອນ. ກອນ ອາໄກ ຣາອວານ ໂຈະ ອຶມເປ່ອ໌ ອຶມປໍ່ ໄລ່, ກະ ມ່ອບ ອຶມເປ່ອ໌ ອຶມປໍ່ ໄລ່ ໂອນ ເນົ່າ ກາຈີດ ຕັຮ. ");
INSERT INTO ncq_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ອຶນແຍ່ະ ມັຮ ກວາຍ ຊາອັຣ ເຍືາ ຍ່ອນ ເຍືາ ປວາຍ ຣານະ ເກົາ. ມາ ກວາຍ ອາແລ່ະ ກາ ເຣືາບ ຈີວ໌ ເຕົ່າ ຊົດ ແດີຍ ອັນ, ເຢືາງ ເຈົາຣາຊີ ຈ່ອຍ ອາມົ່ງ ກວາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","\"ປັຣແນີ ມັນເຕຣືາ ເຍືາ ເບີນ ເຮີມ ເນົ່າ ດໍອ໌ ເກຣີ່ງ ແປຣິ່ ກາ ເຢືາງ ເຈົາຣາຊີ ຊາອັຣ ຕະ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ (ກວາຍ ອາແລ່ະ ກາ ອານ ປັຣນາຍ ໄນ່ ອຶງເຄາະ ອັນ ຊາປຸ່ຮ ເບີມ ແຕ ປັຣນາຍ ໄນ່). ຕາໄງ ກັອຍ ກວາຍ ກາ ແອີດ ຕຶ່ງ ແຄງ ຢູດາຍ ອຶງເຄາະ ຕາລຸ່ຮ ຊັອຮ ແອີດ ຕຶ່ງ ກົຮ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ອັນ ກາ ແອີດ ຕຶ່ງ ແປີງ ຕຳປວລ ດຸງ ເປືາຣ, ອຶນໂຈຍ ແຊງ ອີດ ນັ່ອງ ເກຣີ່ງ ຕຶ່ງ ປື່ນ ດຸງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ອັນ ກາ ແອີດ ປໍ ໄທຣ, ອຶນໂຈຍ ເຈົາ ອີດ ນັ່ອງ ເກຣີ່ງ ແຕ ດຸງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ຕຶ່ງ ຕາໄງ ກັອຍ ໂຕຍ໌ ບາບ ລາລື່ ໄລ່ ກາ ແອີດ ຕຶ່ງ ຈະ ກະ ໄລ່ ກາ ອາອູອ໌ ກອນ. ");
INSERT INTO ncq_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ອຶງເຄາະ ເຍືາ ເກົາແຊອ໌ ອຶນໂຈຍ ໂອນ ມັຮ ຣາມຶ່ຮ ໄນ່ ແຕີ່ອ໌ ຕຶ່ງ ກາໄຊ ຊາແງດ. ");
INSERT INTO ncq_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ຍ່ອນ ຕຶ່ງ ຕາໄງ ກັອຍ ເບີນ ຕຸ່ຮ ກັ່ດ ກາເລີຍ ແຕ ຕາແບິ ເຢືາງ ເຈົາຣາຊີ ແຕງ ມັນລັ່ອງ ກູແຕອ໌ ເຕົ່າ ແຕີ່ອ໌ ຊານໍ່. ກະ ອຶນຕູ່ນ ແອັນ ຕາ ເບີນ ຕຸ່ຮ ກັ່ດ ນັ່ອງ ນ່ະ ຕາໄງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ຄັນ ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ອາຣູ່ຍ໌ ລັ່ຮ ມັຮ ຕາໄງ ກັອຍ, ຕາ ເບີນ ກວາຍ ອາແລ່ະ ເຕ່ອ໌ ອາມົ່ງ ນັ່ອງ. ມາ ຍ່ອນ ອັນ ຢໍອ໌ ອີ ຈ່ອຍ ມັຮ ກວາຍ ກາ ອັນ ຣຽຮ, ອັນ ອາຣູ່ຍ໌ ລັ່ຮ ມັຮ ຕາໄງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","\"ຄັນ ເນົ່າ ອາຕີ ເຍືາ ປາຍ: 'ໄນ່! ອັນ ໄນ່ ລາ ກຣີດ!' ແຕີລາ 'ຕິຮ! ອັນ ກາ ແອີດ ປໍ ກັອຍ ລາ ກຣີດ!' ເຍືາ ອຶນໂຈຍ ຊາງັດ ປັຣນາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ຍ່ອນ ປັຣແນີ ມັນເຕຣືາ ເບີນ ກວາຍ ກາ ຕາ ແກີນ ກຣີດ, ກະ ຕາ ແກີນ ກວາຍ ກາ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ໄລ່ ແຕີ່ອ໌ ປໍ ໄນ່. ໄລ່ ກັອຍ ຕະ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ອີ ຣາພິ ກວາຍ ການໍ່ອ໌ ແຮີ. ຄັນ ເຕ່ອ໌, ໄລ່ ຢໍອ໌ ອີ ຣາພິ ກວາຍ ກາ ເຢືາງ ເຈົາຣາຊີ ຣຽຮ ເຈີ່, ໂອນ ຕະ ຣານະ ຕາ ອໍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ນ່ະກັອຍ ອຶງເຄາະ ເຍືາ ແອີດ ເນ່ ອໍ. ມັຮ ຣາມຶ່ຮ ໄນ່ ເກົາ ອາຕີ ດໍອ໌ ໂອນ ເຍືາ ດັງ ອຶນໂຍ່ງ. ");
INSERT INTO ncq_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","ມາ ຕຶ່ງ ຕາໄງ ກັອຍ, ແວັດ ແຕ ຕາໄງ ຕຸ່ຮ ກັ່ດ ລາລື່, ມັ່ດ ມານາງ ຕາ ເບີນ ປັ່ງ ນັ່ອງ, ກະ ຣາລັ່ງ ກາໄຊ ລາ ຕາ ເບີນ ປັ່ງ ນັ່ອງ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ມັນໂຕຣ ຊາແລັຮ ແຕ ມັນລັ່ອງ, ກະ ມັຮ ຣາມຶ່ຮ ອຶນເຕົ່າ ກາ ເບີນ ອຳນາດ ຕຶ່ງ ມັນລັ່ອງ, ເຢືາງ ເຈົາຣາຊີ ຕະ ໂອນ ຣາໄມ່ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ພໍກາ ກັອຍ, ເນົ່າ ເຮີມ ເກົາ ກອນ ເຢືາງ ແກີດ ກວາຍ ແຕ ອຶນດີ ຣາມິ່ລ, ເບີນ ອຳນາດ ປື່ດ ລາລື່ ກະ ຣູ່ບເຣືາງ ອາງອື່ຣ. ");
INSERT INTO ncq_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ບັອງ ກາ ກັອຍ ເກົາ ແປຣີ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ປາໂຣມ ກູ່ ນະ ມັຮ ກວາຍ ກາ ເກົາ ຣຽຮ ຈວບ ອຶນແຍ່ະ ມັນລັ່ອງ ກູແຕອ໌ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","ເຢຊູ ອາຕີ ແອັນ ປາຍ: \"ເຍືາ ຊາງັດ ເກົາ ຊາກຳ ແຕ ອາລ່ອງ ລາວັ່ຮ. ຄັນ ອາແບງ ອາລ່ອງ ກັອຍ ອຶນນັ່ອງ ອຶນຍ່ອມ, ອັນ ໄບອ໌ ປາດັອຮ ລັ່ຮ ຊາລາ ອຶນຍ່ອມ ເຕ່. ນ່ະກັອຍ ເຍືາ ດັງ ແຈ່ະ ອີ ແຕີ່ອ໌ ກາໄຊ ພວາອ໌. ");
INSERT INTO ncq_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ມູເຈິງ ກັອຍ ເຕ່, ຄັນ ເຍືາ ເຮີມ ອຶນແຍ່ະ ຣາມຶ່ຮ ໄນ່ ແຕີ່ອ໌, ນ່ະກັອຍ ເຍືາ ດັງ ກອນ ເຢືາງ ແກີດ ກວາຍ ແຈ່ະ ອີ ແຕີ່ອ໌ ເຈີ່. ເກົາ ຕາມັອກ ແອີດ ຕຶ່ງ ງັ່ຮ ຕົ່ງ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ມັຮ ກວາຍ ຕຶ່ງ ແດີຍ ໄນ່ ຕາ ເບີນ ກູຈີດ ອຶນແຍ່ະ, ອຶນໂຍ່ງ ແຕ ອຶນແຍ່ະ ຣາມຶ່ຮ ໄນ່ ແຕີ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ເຈີ່ ປໍ ເມືາງ, ມັນລັ່ອງ ກະ ກູແຕອ໌ ແກີດ ປິ່ດ ອຶນແຍ່ະ, ມາ ປັຣນາຍ ເກົາ ອາຕີ ຕາ ເບີນ ແກີດ ປິ່ດ. ");
INSERT INTO ncq_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","\"ຕາ ເບີນ ເນົ່າ ດັງ ຕາໄງ ອຶນເຕົ່າ ແຕີລາ ບັອງ ແລ່ະ ຣານະ ກັອຍ ແຕີ່ອ໌. ມັຮ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ຕຶ່ງ ມັນລັ່ອງ, ກະ ກອນ ເຢືາງ ເຈົາຣາຊີ ແຮີ ລາ ຕາ ເບີນ ດັງ ເຕ່ ຕາໄງ ກັອຍ. ແອີງ ມານະ ອຶມປໍ່ ເກົາ ແຕິ່ ດັງ ຕາໄງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","\"ນ່ະກັອຍ ອຶງເຄາະ ເຍືາ ແອີດ ອໍ, ເຍືາ ເກຣາະ, ເຍືາ ຕາງວຍ ເລືອຍໆ, ຍ່ອນ ເຍືາ ຕາ ເບີນ ດັງ ຕາໄງ ແລ່ະ ຣານະ ໄນ່ ແຕີ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ຣານະ ໄນ່ ລາ ມູເຈິງ ມານະ ຣາເລົາ ເປາະ ຕາມອຍ ກຣວາງ ເຢີ່ງ. ພໍກາ ອັນ ລັ່ອຮ ແຕ ດຸງ ອັນ, ອັນ ມ່ອບ ໂອນ ກວາຍ ຕະ ຣານະ ອັນ ອຶມພາ ຣານະ ຕະ ຕຶ່ງ ດຸງ ອັນ. ກະ ອັນ ປາຕັບ ກວາຍ ກາ ກຍາອ໌ ງັ່ຮ ຕົ່ງ ໂອນ ອັນ ຕາງວຍ ເລືອຍໆ. ");
INSERT INTO ncq_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ນ່ະກັອຍ ອຶງເຄາະ ເຍືາ ຕາງວຍ ເລືອຍໆ, ຍ່ອນ ເຍືາ ຕາ ດັງ ຕາໄງ ແລ່ະ ອຶນເຈົາ ດຸງ ເຈົາ ລັ່ຮ. ປຍາຍ໌ ອັນ ເຈົາ ຊາເດົາ ລາ ເບີນ. ປຍາຍ໌ ອັນ ເຈົາ ດີດຶ່ກ ລາ ເບີນ. ປຍາຍ໌ ອັນ ເຈົາ ອຶນຕຣວຍ ຕາກາຣ ລາ ເບີນ. ປຍາຍ໌ ອັນ ເຈົາ ຕາຣື່ບ ລາ ເບີນ. ");
INSERT INTO ncq_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ອຶງເຄາະ ເຍືາ ລາວັ່ງ. ອຶງກັອຮ ຊັຣໂບຼ ອັນ ເຈົາ, ເຈີ່ ອັນ ຣາມົຮ ເຍືາ ບິ. ");
INSERT INTO ncq_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ມັຮ ຣາມຶ່ຮ ເກົາ ອາຕີ ເຍືາ, ເກົາ ອາຕີ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ ເຕ່: ອຶງເຄາະ ເຍືາ ຕາງວຍ ເລືອຍໆ!\" ");
INSERT INTO ncq_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ອຶນນັ່ອງ ບາຣ ຕາໄງ ກວາຍ ອິດຊະຣາເອລ ອີ ຈາ ຣໍ່ອ໌ ຊາແຍີ ຕາໄງ ອາກຼັຮ. ກະ ໄລ່ ຕະ ຣີ່ດ ຈາ ໂດຍ ບຸຮ ແອິ ບວຮ ຊື່ອ໌. ນ່ະກັອຍ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ກະ ກວາຍ ອາຕີ ຄານອດ, ໄລ່ ຈໍ່ອ໌ ຣານາ ຢໍອ໌ ອີ ໂກບ ເຢຊູ ກະ ອີ ກາຈີດ ອັນ, ມາ ໄລ່ ຕາ ແອອ໌ ໂອນ ກວາຍ ການໍ່ອ໌ ດັງ. ");
INSERT INTO ncq_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ໄລ່ ຊັຣຮົງ ປາຍ: \"ໄຮ ຕາ ເຕ່ອ໌ ຕະ ນ່ະໄນ່ ຕຶ່ງ ຕາໄງ ຈາ ຣໍ່ອ໌. ອຶງກັອຮ ກວາຍ ກຼຶ່ງ ກັອຍ ອຶມປຣາຍຮ ອຶມປຣັງ ອວານ ລັ່ຮ ໄຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ບັອງ ກາ ເຢຊູ ແອີດ ຕຶ່ງ ວີ່ລ ເບັດທານີ, ອັນ ແອີດ ຕຶ່ງ ດຸງ ຊີໂມນ, ກວາຍ ກາ ເບີນ ອາອີ່ ຕູ່ດ ແຕ ອຶນໂຍ່ງ. ບັອງ ກາ ເຢຊູ ແອີດ ຈາ, ເບີນ ມານະ ມັນແຊມ ແຕີ່ອ໌ ປໍ ອັນ, ເດີງ ມວຍ ກອງ ແດີອ໌ ປາຮວມ. ກອງ ກັອຍ ເນົ່າ ຕະ ແຕ ຕາເມົາ ເບີນ ຣາມຶ່ຮ 'ອາລາບາດ.' ແດີອ໌ ປາຮວມ ຕຶ່ງ ກອງ ກັອຍ ເປ່ງ ລາລື່, ເນົ່າ ດໍອ໌ 'ນາຣາດາ.' ມັນແຊມ ກັອຍ ປີຮ ກອງ ກັອຍ, ເຈີ່ ອັນ ແຢດ ແດີອ໌ ປາຮວມ ຕຶ່ງ ແປຼີ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ເບີນ ກວາຍ ແອີດ ອຶງກັອຍ ຊັອງ ອຶງຄື່ນ ລາລື່, ກະ ໄລ່ ຊັຣຮົງ ປາຍ: \"ນານ່ະ ແດີອ໌ ປາຮວມ ໄນ່ ມາ ອັນ ຕັຮ ເມືາດ ຊັອງ ນ່ະກັອຍ? ");
INSERT INTO ncq_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ຄັນ ຈິ ແດີອ໌ ປາຮວມ ໄນ່, ເບີນ ປຣະ ກາເລີຍ ແຕ ເກືາ ເນົ່າ ທູແທ ໄປ ຣ່ອຍ ຕາໄງ. ເຈີ່ ເຕ່ອ໌ ອີດ ປຣະ ກັອຍ ຈ່ອຍ ໂອນ ກວາຍ ກາດີດ.\" ເຈີ່ ໄລ່ ໂຍ່ບ ກະ ມັນແຊມ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ມາ ເຢຊູ ອາຕີ ໄລ່ ປາຍ: \"ຕາມ ອັນ. ອຶນເຕົ່າ ໂຍ່ບ ຕະ ມັນແຊມ ກັອຍ? ນານ່ະ ເຍືາ ຕະ ໂອນ ອັນ ຕຸ່ຮ? ອັນ ຕະ ຣານະ ອໍ ໂອນ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ກວາຍ ກາດີດ ແອີດ ເລືອຍໆ ກະ ເຍືາ. ມາແລ່ະ ເຍືາ ຢໍອ໌ ອີ ຈ່ອຍ, ເຕ່ອ໌ ເຍືາ ຈ່ອຍ. ມາ ຈະ ເກົາ ຕາ ເບີນ ແອີດ ເລືອຍໆ ກະ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ຣານະ ອຶນເຕົ່າ ເຕ່ອ໌ ມັນແຊມ ໄນ່ ຕະ, ອັນ ຕະ. ອັນ ແຢດ ແດີອ໌ ປາຮວມ ຕຶ່ງ ຈະ ເກົາ, ກຽມ ດໍອ໌ ອຶນໂຍ່ງ ເນົ່າ ແຕິບ ເກົາ ຕຶ່ງ ປີ່ງ. ");
INSERT INTO ncq_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ຕຶ່ງ ກູ່ ອຶນຕຸ ຈວບ ກູແຕອ໌ ໄນ່, ແຕີ່ອ໌ ເນົ່າ ອາຕີ ປັຣນາຍ ອໍ ແຕ ເຢືາງ ເຈົາຣາຊີ, ເນົ່າ ອາຕີ ຣານະ ມັນແຊມ ໄນ່ ຕະ, ໂອນ ກວາຍ ຊາແຍີ ລັ່ຮ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ແວັດ ກັອຍ ຢູດາ ອິດຊະກາຣີອົດ, ມານະ ແຕ ມູ່ ມວຍ ຈິ່ດ ລາ ບາຣ ນະ, ອັນ ແຕີ່ອ໌ ປໍ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ຢໍອ໌ ອີ ມ່ອບ ເຢຊູ ໂອນ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ພໍກາ ໄລ່ ກັອຍ ຊັອງ ຣານະ ນ່ະກັອຍ, ໄລ່ ແອີນ ລາລື່, ກະ ໄລ່ ປຣ່ອມ ອີ ໂອນ ຢູດາ ປຣະ. ນ່ະກັອຍ ຢູດາ ຈໍ່ອ໌ ຕາໄງ ແລ່ະ ກາ ອໍ ອີ ມ່ອບ ເຢຊູ ໂອນ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ຕຶ່ງ ຕາໄງ ກວາຍ ອິດຊະຣາເອລ ຕະ ຣີ່ດ ຈາ ໂດຍ ບຸຮ ແອິ ບວຮ ຊື່ອ໌ ກະ ກຍາກ ແກະ ຊາແຍີ ຕາໄງ ອາກຼັຮ, ຕາໄງ ກັອຍ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ຕາແບີບ ອັນ ປາຍ: \"ອຶນຕຸ ແລ່ະ ໄມ່ ໂອນ ຮິ ເປາະ ກຽມ ດໍອ໌ ຈາ ຊາແຍີ ລັ່ຮ ຕາໄງ ອາກຼັຮ?\" ");
INSERT INTO ncq_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ເຢຊູ ແປຣີ ບາຣ ນະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ເຍືາ ມູ່ດ ຕຶ່ງ ວີ່ລ ກັອຍ. ເຈີ່ ເຍືາ ເບີນ ຣາມົຮ ມານະ ຣາເລົາ ຕາແຢອ໌ ອາລວຍ ແດີອ໌. ເຍືາ ເປາະ ຕາປູ່ນ ກຣັອງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ຄັນ ອັນ ມູ່ດ ດຸງ ອາແລ່ະ, ເຍືາ ອາຕີ ອຶນເຈົາ ດຸງ ກັອຍ ປາຍ: \"ອາຈານ ແປຣີ ຮິ ຕາແບີບ ເຍືາ ອຶນແລ່ະ ກຼຸງ ຕາມອຍ? ຕຶ່ງ ກຼຸງ ກັອຍ ເກົາ ຢໍອ໌ ອີ ຈາ ເປ່ລ ບູຍ ຊາແຍີ ຕາໄງ ອາກຼັຮ ກະ ມູ່ ກາ ຣຍານ ແຕ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ເຈີ່ ອັນ ກັອຍ ຊາດອຍ ໂອນ ເຍືາ ມວຍ ກຼຸງ ປື່ດ ຕຶ່ງ ຣານ ແປີງ. ຕຶ່ງ ກຼຸງ ກັອຍ ເບີນ ເຈີ່ ກູ່ ຣາມຶ່ຮ ມັຮ ເກຣີ່ງ ຕັອກ. ເຍືາ ກຽມ ໂອນ ໄຮ ຈາ ປໍ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ໄລ່ ບາຣ ນະ ລັ່ອຮ ແຕ ກັອຍ ມູ່ດ ຕຶ່ງ ວີ່ລ. ໄລ່ ຣາມົຮ ອຶນແຍ່ະ ນ່ະ ປັຣນາຍ ເຢຊູ ອາຕີ ດໍອ໌ ອຶນໂຍ່ງ. ເຈີ່ ໄລ່ ກຽມ ຊັຣນາ ຈາ ມວຍ ເປ່ລ ຊາແຍີ ຕາໄງ ອາກຼັຮ ອຶງກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ແຕີ່ອ໌ ຍາຍຶ່ມໆ ເຢຊູ ກະ ມູ່ ກາ ມວຍ ຈິ່ດ ລາ ບາຣ ນະ ແຕີ່ອ໌ ປໍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ບັອງ ກາ ໄລ່ ຕາກູ ຈາ, ເຢຊູ ອາຕີ ໄລ່ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ເບີນ ມານະ ແຕ ເຍືາ ກາ ຈາ ມັນຕຸ ກະ ເກົາ, ປັຣແນີ ມັນເຕຣືາ ອັນ ອີ ມ່ອບ ເກົາ ໂອນ ເນົ່າ ກາຈີດ.\" ");
INSERT INTO ncq_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ໄລ່ ກັອຍ ຊັອງ ຕຸ່ຮ ລາລື່, ກະ ໄລ່ ຕາແບີບ ເຢຊູ ມູ ເຈີ ມານະ ປາຍ: \"ເກົາ ມາ ຕາ ເບີນ, ອາຈານ?\" ");
INSERT INTO ncq_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ກວາຍ ໄນ່ ລາ ມານະ ແຕ ເຍືາ ກາ ມວຍ ຈິ່ດ ລາ ບາຣ ນະ; ອັນ ຕຸ ຈາ ໂດຍ ບຸຮ ມວຍ ຕາງານ ກະ ເກົາ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ກອນ ເຢືາງ ແກີດ ກວາຍ ອຶງເຄາະ ກູຈີດ ມັຮ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ເຈີ່ ແຕ ອັນ. ມາ ອັນ ກາ ຈິ ກອນ ເຢືາງ ແກີດ ກວາຍ, ບາບ ລາລື່ ແຕີ່ອ໌ ປໍ ອັນ. ປຍາຍ໌ ລາ ອຶມເປ່ອ໌ ອັນ ອຶນໂຈຍ ຣັ່ຮ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ບັອງ ກາ ໄລ່ ຈາ, ເຢຊູ ອີດ ໂດຍ ບຸຮ. ອັນ ຊາແອີນ ເຢືາງ ເຈົາຣາຊີ, ເຈີ່ ອັນ ປີຮ ໂດຍ ບຸຮ ກັອຍ, ອາແວີຍ ໂອນ ມູ່ ກາ ຣຍານ ແຕ ອັນ ຈາ. ອັນ ອາຕີ ໄລ່ ປາຍ: \"ເຍືາ ຣັ່ບ. ໄນ່ ລາ ຈະ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ແວັດ ກັອຍ ອັນ ອີດ ຈອກ. ເຈີ່ ອັນ ຊາແອີນ ເຢືາງ ເຈົາຣາຊີ, ອັນ ອາແວີຍ ໂອນ ມູ່ ກາ ຣຍານ ແຕ ອັນ ງ່ອຍ໌. ເຈີ່ ອຶນແຍ່ະ ນະ ໄລ່ ກັອຍ ງ່ອຍ໌. ");
INSERT INTO ncq_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ກະ ເຢຊູ ອາຕີ ໄລ່ ປາຍ: \"ໄນ່ ລາ ອາຮາມ ເກົາ. ອາຮາມ ໄນ່ ລັ່ອຮ ຕະ ໂອນ ກວາຍ ດັງ ເຢືາງ ເຈົາຣາຊີ ປັຣຄັນ ປັຣນາຍ ຕາໄມ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ເກົາ ຕາ ເບີນ ງ່ອຍ໌ ນັ່ອງ ແດີອ໌ ແຕ ປາໄລ ອາງຸ່ນ ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ເກົາ ງ່ອຍ໌ ແດີອ໌ ກັອຍ ຕາໄມ ແອັນ ຕຶ່ງ ອຶນຕຸ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ.\" ");
INSERT INTO ncq_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ແວັດ ໄລ່ ລ່ຳ ຍ່ອງ ເຢືາງ ເຈົາຣາຊີ, ເຈີ່ ໄລ່ ລັ່ອຮ ແຕ ກັອຍ ຊັອຮ ຕຶ່ງ ກົຮ ອາໂປ່ນ. ");
INSERT INTO ncq_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ເຢຊູ ອາຕີ ໄລ່ ປາຍ: \"ອຶນແນະ ມັຮ ເຍືາ ຕັຮ ອຶນແຍ່ະ ເກົາ. ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ເຈີ່ ປາຍ: 'ເກົາ ໂອນ ເນົ່າ ກາຈີດ ກວາຍ ກຍາອ໌ ແກະ, ເຈີ່ ອຶນແຍ່ະ ແກະ ກັອຍ ຣາຕັຮ ຣາຕາຍ໌.' ");
INSERT INTO ncq_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ມາ ແຕີ່ອ໌ ເກົາ ອາມົ່ງ ລັ່ຮ, ເກົາ ເປາະ ອຶນໂຍ່ງ ເຍືາ ຕຶ່ງ ແຄງ ຄາລີເລ.\" ");
INSERT INTO ncq_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ເປໂຕ ອາຕີ ເຢຊູ ປາຍ: \"ອຶມປຶ່ ອຶນແຍ່ະ ມັຮ ກວາຍ ການໍ່ອ໌ ຕັຮ ໄມ່, ລາ ເກົາ ຕາ ເບີນ ຕັຮ ໄມ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ເຢຊູ ອາຕີ ລັ່ຮ ເປໂຕ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ໄມ່, ຕຶ່ງ ຊາເດົາ ໄນ່ ແຕິ່, ອຶນໂຍ່ງ ອຶນຕຣວຍ ຕາກາຣ ບາຣ ເຮີບ, ໄມ່ ກາແລີຍຮ ເກົາ ເບີນ ໄປ ເຮີບ.\" ");
INSERT INTO ncq_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ມາ ເປໂຕ ຕາແອີຍ ຣາຊວນ ເລືອຍໆ ປາຍ: \"ຄັນ ເນົ່າ ກາຈີດ ເກົາ ກະ ໄມ່ ລາ ໂທຍ. ເກົາ ຕາ ເບີນ ກາແລີຍຮ ໄມ່ ເລີ່!\" ກະ ອຶນແຍ່ະ ມັຮ ມູ່ ກັອຍ ປາຍ ມູເຈິງ ປັຣນາຍ ເປໂຕ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ພໍກາ ໄລ່ ກັອຍ ແຕີ່ອ໌ ມວຍ ຊວນ ກາ ເນົ່າ ດໍອ໌ ເຄັດເຊມາເນ, ເຢຊູ ອາຕີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ເຍືາ ແອີດ ຕາກູ ອຶນໄນ່ ນໍ. ເກົາ ອີ ເປາະ ເກົາແຊອ໌ ປໍ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ອັນ ເດີງ ເປໂຕ, ຢາໂກໂບ, ກະ ໂຢຮັນ ເປາະ ກະ ອັນ. ເຈີ່ ຣາງຶ່ຮ ເຢຊູ ຊັອງ ເກຣ່າະ ກະ ຕຸ່ຮ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ອັນ ປາຍ ນ່ະໄນ່: \"ຣາງຶ່ຮ ເກົາ ຊັອງ ຕຸ່ຮ ລາລື່, ຕາ ເຣືາບ ອາມົ່ງ ນັ່ອງ. ເຍືາ ແອີດ ເກຣາະ ເກົາ ອຶນໄນ່. ເຍືາ ຕາງວຍ ກະ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ເຈີ່ ເຢຊູ ເປາະ ບີ່ອ໌ ແອັນ. ອັນ ປາດິຮ ຕຶ່ງ ກູແຕອ໌ ມູ່ ຕາຕຶ່ບ. ອັນ ເກົາແຊອ໌ ຄັນ ເຕ່ອ໌, ໂອນ ຣານະ ໄນ່ ເປາະ ແວັດ ແຕ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ອັນ ເກົາແຊອ໌ ປາຍ: \"ອຶມປໍ່, ອຶມປໍ່ ເກົາ ເອີຍ! ອຶນເຕົ່າ ໄມ່ ອີ ຕະ, ເຕ່ອ໌ ໄມ່ ຕະ. ເກົາ ແຊອ໌ ໄມ່ ອາຢິ່ ຈອກ ຕຸ່ຮ ກັ່ດ ໄນ່ ໂອນ ແວັດ ແຕ ເກົາ. ມາ ເກົາ ຕາ ແອອ໌ ອີ ຕາປູ່ນ ຣາງຶ່ຮ ເກົາ ເບີມ. ເກົາ ອີ ຕາປູ່ນ ແອີງ ຣາງຶ່ຮ ໄມ່ ຊັອງ.\" ");
INSERT INTO ncq_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ເຈີ່ ເຢຊູ ລົ່ບ ລັ່ຮ, ກະ ຣາມົຮ ໄລ່ ບິ. ເຈີ່ ອັນ ຕາແບີບ ເປໂຕ ປາຍ: \"ຊີໂມນ ເອີຍ! ໄມ່ ບິ ບໍ? ນານ່ະ ໄມ່ ຕາ ເຣືາບ ຕາງວຍ ກະ ເກົາ ມາໂຮຍ? ");
INSERT INTO ncq_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ອຶງເຄາະ ເຍືາ ຕາແມີ ກະ ເກົາແຊອ໌ ອຶນໂຈຍ ໂອນ ເນົ່າ ປັຣຕຶ່ ເຍືາ ຕະ ໂລ່ຍຮ. ຣາງຶ່ຮ ເຍືາ ລາ ບັນ ເຣ່ງ, ມາ ຈະຈັ່ນ ເຍືາ ລາ ອຽວ໌.\" ");
INSERT INTO ncq_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ນ່ະກັອຍ ເຢຊູ ເປາະ ເກົາແຊອ໌ ລັ່ຮ. ອັນ ເກົາແຊອ໌ ປັຣນາຍ ມູເຈິງ ແຕ ອຶນໂຍ່ງ. ");
INSERT INTO ncq_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ເຈີ່ ອັນ ລົ່ບ ລັ່ຮ ປໍ ອຶນຕຸ ໄລ່ ກັອຍ ແອີດ. ອັນ ຣາມົຮ ໄລ່ ບິ ລັ່ຮ ຊາ, ຍ່ອນ ມັ່ດ ໄລ່ ອຶນຕັອງ ລາລື່ ຕາ ເຣືາບ ກູເລືານ. ໄລ່ ກັອຍ ຕາ ດັງ ນານ່ະ ອີ ຕາແອີຍ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ນ່ະກັອຍ ເຢຊູ ເຈົາ ລັ່ຮ ແຕີ່ອ໌ ອຶນຕຸ ໄລ່ ກັອຍ ແອີດ ເຮີບ ກາ ໄປ ແອັນ. ກະ ອັນ ຕາແບີບ ໄລ່ ປາຍ: \"ນານ່ະ ອຶນນັ່ອງ ເຍືາ ບິ ກະ ຣາລູ່ ລັ່ຮ ຊາ? ເຍືາ ອຶນໂຈຍ ບິ ນັ່ອງ. ແຕີ່ອ໌ ປາເນ່ນ ເຈີ່. ກອນ ເຢືາງ ແກີດ ກວາຍ, ເນົ່າ ຈິ ອັນ ປໍ ອາຕີ ກວາຍ ໂລ່ຍຮ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ຢວຣ ຕາຢຶ່ງ! ໄຮ ເປາະ! ເຍືາ ເນ່ ຕິຮ! ອັນ ກາ ມ່ອບ ເກົາ ແຕີ່ອ໌ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ບັອງ ກາ ເຢຊູ ອຶນນັ່ອງ ອາຕີ ນ່ະກັອຍ, ບັອງ ກາ ກັອຍ ແຕິ່ ຢູດາ ແຕີ່ອ໌. ອັນ ລາ ແຕ ມູ່ ກາ ມວຍ ຈິ່ດ ລາ ບາຣ ນະ ກາ ຣຍານ ແຕ ເຢຊູ. ກຼຶ່ງ ກວາຍ ເດີງ ດາວ ກະ ຣາກັລ ແຕີ່ອ໌ ກະ ຢູດາ ແຕ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ແຕ ກວາຍ ອາຕີ ຄານອດ, ກະ ກວາຍ ເທົາແກ ຈຸ່ມເຈືອ. ");
INSERT INTO ncq_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ອັນ ກາ ອີ ຈິ ເຢຊູ ອາຕີ ໂອນ ເນົ່າ ດັງ ອຶນໂຍ່ງ ປາຍ: \"ຄັນ ອາແລ່ະ ເຍືາ ເຮີມ ເກົາ ໂຮນ, ລາ ກູໂຕ ອັນ ກາ ເຍືາ ອີ ເບີນ. ເຈີ່ ເຍືາ ໂກບ ອັນ ກັອຍ ແຕິ່! ເຍືາ ຢຸມ ໂອນ ກຣັ່ກ, ເຈີ່ ເດີງ ອັນ ແຕ ອຶນຕຸ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ເຈີ່ ຢູດາ ແຕີ່ອ໌ ແຕິ່ ປໍ ເຢຊູ ກະ ປາຍ ນ່ະໄນ່: \"ອາຈານ ເອີຍ!\" ເຈີ່ ອັນ ໂຮນ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ນ່ະກັອຍ ເນົ່າ ແຕີ່ອ໌ ຢຸມ ກະ ໂກບ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ມານະ ແຕ ໄລ່ ກາ ຕາຢຶ່ງ ແຈ່ະ ກັອຍ ທອດ ດາວ ແຕ ຊອຣ, ເຈີ່ ອັນ ກັຣໄປຮ ມານະ ຊູລ ອັນ ກາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ, ປຍາຍ໌ ກູຕູຣ, ເຈີ່ ຕາອັອຮ ມວຍ ກັ່ຮ ກູຕູຣ. ");
INSERT INTO ncq_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ມາ ເຢຊູ ຕາແບີບ ໄລ່ ກັອຍ ປາຍ: \"ນານ່ະ ເຍືາ ແຕີ່ອ໌ ປໍ ໄນ່ ມາ ເດີງ ດາວ ກະ ຣາກັລ ອີ ໂກບ ເກົາ? ເຍືາ ຄຶ່ດ ປາຍ ເກົາ ລາ ກວາຍ ຊາແວງ ບໍ? ");
INSERT INTO ncq_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ກູ່ ຣາໄງ ເກົາ ອາຕີ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ, ມາ ເຍືາ ຕາ ເບີນ ໂກບ ເກົາ. ມາ ຣານະ ໄນ່ ຕະ ໂອນ ແກີດ ຣາປຍາຍ໌ ມັຮ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ແຕ ອຶມແບິ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ນ່ະກັອຍ ອຶນແຍ່ະ ມັຮ ໄລ່ ກາ ແອີດ ກະ ເຢຊູ ຕາລຸ່ຮ ອາຕັຮ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ເບີນ ມານະ ກວາຍ ນຸ່ມ ຣາປວາຍ ເຢຊູ. ອັນ ອຶງກວາມ ແອີງ ເປຣ່ ຕຶ່ງ ຈະ ອັນ. ເນົ່າ ກາຕັ່ອງ ເປຣ່ ອັນ, ອີ ໂກບ ກາ ອັນ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ເຈີ່ ອັນ ຕວດ ຕັຮ ຊັອງ ເປຣ່ ກັອຍ, ຕາລຸ່ຮ ມູລາໂລ່ະ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ພໍກາ ກັອຍ ໄລ່ ເດີງ ເຢຊູ ແຕີ່ອ໌ ປໍ ອັນ ກາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ. ອຶນແຍ່ະ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ກວາຍ ຊົດ ອຶນແຍ່ະ ຈຸ່ມເຈືອ, ກະ ກວາຍ ອາຕີ ຄານອດ ເປາະ ໂຣ່ມ ປໍ ກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ເປໂຕ ຣາປວາຍ ເຢີ່ງໆ ອຶນຕູ່ນ ກຣັອງ ເຢຊູ, ເຈີ່ ອັນ ມູ່ດ ຕຶ່ງ ຊັງອາຣ ດຸງ ອັນ ກາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ. ອັນ ຕາກູ ມັນຕຸ ກະ ກວາຍ ກາ ກຍາອ໌ ດຸງ ຊາງ, ໄລ່ ແອີດ ອຶງແຮງ ອູ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ກະ ຈຸ່ມ ກວາຍ ຊົດ ອິດຊະຣາເອລ ກາ ຊັຣຮົງ ຕັດຊີ່ນ ຈໍ່ອ໌ ຣາລິ່ຮ ແຕ ເຢຊູ, ອີ ກາຈີດ ອັນ. ມາ ໄລ່ ຕາ ເບີນ ຣາມົຮ ມວຍ ຣາມຶ່ຮ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ເບີນ ຊາອຶ່ຍ ກວາຍ ຕູນ ເຢຊູ ມາ ຕາ ເບີນ ປຍາຍ໌. ໄລ່ ຕູນ ມາ ຕາ ເບີນ ມວຍ ປັຣນາຍ. ");
INSERT INTO ncq_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ເບີນ ໄລ່ ກາ ຢວຣ ຕາຢຶ່ງ ຕູນ ເຢຊູ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","\"ຮິ ຊັອງ ອັນ ກັອຍ ປາຍ ເຈີ່ ນ່ະໄນ່: 'ເກົາ ອີ ຕາລຸຮ ດຸງ ຊາງ ເຢືາງ ເຈົາຣາຊີ ກາ ອາຕີ ກວາຍ ຕະ. ມາ ແວັດ ໄປ ຕາໄງ ເກົາ ຕະ ດຸງ ຕາໄມ ແອັນ ຕາ ແກີນ ແຕ ອາຕີ ກວາຍ ຕະ.'\" ");
INSERT INTO ncq_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ມາ ປັຣນາຍ ໄລ່ ຕູນ ຕາ ເບີນ ຊັງໄກຣ. ");
INSERT INTO ncq_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ພໍກາ ກັອຍ ອັນ ກາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ ຢວຣ ຕາຢຶ່ງ ແອີດ ອຶນດີ ໄລ່. ອັນ ຕາແບີບ ເຢຊູ ປາຍ: \"ໄມ່ ອີ ຕາແອີຍ ມາ ຕາ ເບີນ? ນານ່ະ ໄມ່ ຊັອງ ໄລ່ ກັອຍ ອາຕີ ແຕ ໄມ່?\" ");
INSERT INTO ncq_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ມາ ເຢຊູ ແອີດ ອາວື່ລ ຊັອງ. ອັນ ຕາ ເບີນ ປາຍ ອຶນເຕົ່າ. ອັນ ກາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ ຕາແບີບ ລັ່ຮ ເຢຊູ ປາຍ: \"ໄມ່ ເມ່ນ ກຣີດ, ກອນ ອັນ ກາ ຮິ ຍ່ອງ, ມາ ຕາ ເບີນ?\" ");
INSERT INTO ncq_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ເຢຊູ ຕາແອີຍ ປາຍ: \"ເມ່ນ! ເຈີ່ ປໍ ເມືາງ ເຍືາ ເຮີມ ກອນ ເຢືາງ ແກີດ ກວາຍ ຕາກູ ຢັ່ຮ ອາຕ່ຳ ເຢືາງ ເຈົາຣາຊີ ກາ ເບີນ ອຳນາດ ລາລື່, ກະ ອັນ ແຕີ່ອ໌ ອຶນດີ ຣາມິ່ລ ແຕ ມັນລັ່ອງ.\" ");
INSERT INTO ncq_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ເຈີ່ ອັນ ກາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ ແຈອ໌ ເກຣີ່ງ ອັນ ເບີມ, ຕະ ໂອນ ເນົ່າ ດັງ ປາຍ ອັນ ຊັອງ ຕຸ່ຮ ລາລື່. ກະ ອັນ ປາຍ ນ່ະໄນ່: \"ຕາ ຈ່ຳ ໄຮ ອີ ຕາແບີບ ນັ່ອງ ກວາຍ ການໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ເຍືາ ຊັອງ ເຈີ່ ອັນ ປາຍ ປັຣນາຍ ກັອຍ ລາ ມາຮ ອັນ ພາມາດ ເຢືາງ ເຈົາຣາຊີ. ນານ່ະ ເຍືາ ຄຶ່ດ ແຕ ປັຣນາຍ ກັອຍ?\" ອຶນແຍ່ະ ມັຮ ໄລ່ ກັອຍ ປຣ່ອມ ມວຍ ຣາງຶ່ຮ ມ່ອບ ເຢຊູ ອຶງເຄາະ ຈີວ໌ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ເບີນ ກວາຍ ກູຈົຮ ໂຈະ ເຢຊູ. ໄລ່ ຕັນ ມັ່ດ ອັນ, ເຈີ່ ໄລ່ ຈົ່ກ ອັນ ກະ ຕາແບີບ ອັນ ປາຍ: \"ເນົ່າ ກາ ຈົ່ກ ໄມ່? ເອົາ ໄມ່ ປາຍ ແມະ!\" ກະ ມັຮ ກວາຍ ກາ ກຍາອ໌ ຕຶ່ງ ດຸງ ຊາງ ກັອຍ ຕະ ອັນ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ບັອງ ກາ ກັອຍ ເປໂຕ ອຶນນັ່ອງ ແອີດ ຕຶ່ງ ຊັງອາຣ. ເບີນ ມານະ ມັນແຊມ ກາ ຕະ ຣານະ ໂອນ ອັນ ກາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ ແຕີ່ອ໌ ປໍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ພໍກາ ອັນ ເຮີມ ເປໂຕ ແອີດ ອຶງແຮງ ອູ່ຍຮ ອຶງກັອຍ, ອັນ ເນ່ ຊັຣກຼັ່ອງ ປໍ ມັ່ດ ເປໂຕ ກະ ອັນ ປາຍ ໂຈະ ເປໂຕ ນ່ະໄນ່: \"ໄມ່ ລາ ກວາຍ ແອີດ ກະ ເຢຊູ, ກວາຍ ແຕ ວີ່ລ ນາຊາເຣັດ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ມາ ເປໂຕ ຕາ ເບີນ ງີ່ນ, ອັນ ປາຍ: \"ຕາ ເບີນ! ເກົາ ຕາ ດັງ ອຶນເຕົ່າ ໄມ່ ປາຍ! ກາ ເກົາ ຕາ ເບີນ ຊາປຸ່ຮ ເລີ່ຍ!\" ເຈີ່ ເປໂຕ ລັ່ອຮ ແຕ ອຶນຕຸ ກັອຍ ຕາຢັຮ ເປາະ ປໍ ງັ່ຮ ຕົ່ງ, ກະ ບັອງ ກັອຍ ແຕິ່ ອຶນຕຣວຍ ຕາກາຣ. ");
INSERT INTO ncq_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ມາ ມັນແຊມ ກັອຍ ເຮີມ ລັ່ຮ ຊາ ເປໂຕ, ກະ ອັນ ອາຕີ ກວາຍ ການໍ່ອ໌ ກາ ແອີດ ຕາຢຶ່ງ ອຶນຕຸ ກັອຍ ປາຍ: \"ອັນ ໄນ່ ລາ ແຕ ມູ່ ກັອຍ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ມາ ເປໂຕ ຕາ ເບີນ ງີ່ນ ຊາ. ມາໂຮຍ ແອັນ ມັຮ ກວາຍ ກາ ຕາຢຶ່ງ ອຶງກັອຍ ປາຍ ໂຈະ ເປໂຕ: \"ເມ່ນ ລາລື່ ໄມ່ ລາ ແຕ ມູ່ ໄລ່ ກັອຍ ເຕ່, ຍ່ອນ ໄມ່ ລາ ກວາຍ ຄາລີເລ.\" ");
INSERT INTO ncq_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ເປໂຕ, ອັນ ຄີນ ມາງ ກຼໍອ໌ ແປຼີ ກຼໍອ໌ ໂຊະ ກະ ໄລ່ ກັອຍ. ອັນ ຕາແອີຍ ຣາຊວນ ເລືອຍໆ ປາຍ: \"ເຍືາ ຕູນ ເກົາ ແຕ ມູ່ ອັນ ກັອຍ, ມາ ເກົາ ຕາ ດັງ ນານ່ະ ຣູ່ບເຣືາງ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ບັອງ ກາ ກັອຍ ແຕິ່ ອຶນຕຣວຍ ຕາກາຣ ເຮີບ ກາ ບາຣ. ເຈີ່ ເປໂຕ ຊາແຍີ ປັຣນາຍ ເຢຊູ ອາຕີ ອັນ ແຕ ອຶນໂຍ່ງ ປາຍ: \"ແຕ ອຶນໂຍ່ງ ອຶນຕຣວຍ ຕາ ຢວາຮ ຕາກາຣ ບາຣ ເຮີບ, ໄມ່ ກາແລີຍຮ ເກົາ ໄປ ເຮີບ.\" ພໍກາ ເປໂຕ ຄຶ່ດ ຊາແຍີ ລັ່ຮ ປັຣນາຍ ກັອຍ, ເຈີ່ ອັນ ເຍືາມ. ");
INSERT INTO ncq_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ແຕີ່ອ໌ ປັ່ງ ຕາຣື່ບ ປັຣແນີ, ອຶນນັ່ອງ ຍາຍຶ່ມໆ, ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ມັຮ ກວາຍ ເທົາແກ ຈຸ່ມເຈືອ, ກະ ມັຮ ກວາຍ ອາຕີ ຄານອດ ໂຣ່ມ ຊັຣຮົງ ມັນຕຸ ກະ ມັຮ ກວາຍ ຊົດ ການໍ່ອ໌ ຕຶ່ງ ຈຸ່ມ ໄລ່. ແວັດ ໄລ່ ກັອຍ ຊັຣຮົງ, ໄລ່ ຊັດ ເຢຊູ ກະ ເດີງ ອາຊວຍ ອັນ ແຕີ່ອ໌ ປໍ ປີລາດ. ");
INSERT INTO ncq_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ປີລາດ ຕາແບີບ ເຢຊູ: \"ໄມ່ ລາ ເມ່ນ ເຕືາວ ປັຣເຍືາ ອິດຊະຣາເອລ ບໍ?\" ເຢຊູ ຕາແອີຍ ປາຍ: \"ເມ່ນ, ປຍາຍ໌ ເຈີ່ ໄມ່ ປາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ໄລ່ ຕູນ ເຢຊູ, ປາຍ ອັນ ຕະ ຊາອຶ່ຍ ຣານະ ຕາ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ເຈີ່ ປີລາດ ຕາແບີບ ລັ່ຮ ເຢຊູ: \"ນານ່ະ ໄມ່ ຕາ ເບີນ ຕາແອີຍ ອຶນເຕົ່າ? ໄມ່ ຊັອງ ເຈີ່ ເນົ່າ ຕິ ໄມ່ ຊາອຶ່ຍ ຣາມຶ່ຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ມາ ເຢຊູ ຕາ ເບີນ ຕາແອີຍ ອຶນເຕົ່າ ເລີ່ຍ. ນ່ະກັອຍ ປີລາດ ຊັອງ ງຶ່ດ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ແຕີ່ອ໌ ຕາໄງ ກວາຍ ອິດຊະຣາເອລ ໂຣ່ມ ຈາ ຊາແຍີ ຕາໄງ ອາກຼັຮ, ໄລ່ ເບີນ ຣີ່ດ ໂອນ ກວາຍ ຊົດ ກຣວາງ ກັອຍ ອາໂຣຍຮ ມານະ ກວາຍ ໂຕ່ດ ແຕ ກໍ່ອ໌, ຕາມ ຣາງຶ່ຮ ກອນແຊມ ຣຽຮ ຢໍອ໌ ອີ ອາໂຣຍຮ. ");
INSERT INTO ncq_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ຕາໄງ ກັອຍ ຕຶ່ງ ກໍ່ອ໌ ກັອຍ ເບີນ ມານະ ຣາມຶ່ຮ ບາຣາບາ. ອັນ ກັອຍ ມານະ ແຕ ມູ່ ກາ ຕຳໂປຣ ຊົດ. ກະ ອັນ ກາຈີດ ກວາຍ ການໍ່ອ໌ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ກຼຶ່ງ ລາລື່ ກວາຍ ແຕີ່ອ໌ ປໍ ປີລາດ, ແຊອ໌ ໂອນ ປີລາດ ຕະ ຣີ່ດ ນ່ະ ກູມໍ ອຶນໂຍ່ງ ຊາ. ");
INSERT INTO ncq_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ປີລາດ ຕາແບີບ ໄລ່ ກັອຍ ປາຍ: \"ເຍືາ ໂອນ ເກົາ ອາໂຣຍຮ ເຕືາວ ປັຣເຍືາ ອິດຊະຣາເອລ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ປີລາດ ດັງ ເຈີ່ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ຊັອງ ອວານ ກະ ເຢຊູ ຍ່ອນ ກອນແຊມ ໄລ່ ຢໍອ໌ ອີ ຕາປູ່ນ ເຢຊູ. ນ່ະກັອຍ ໄລ່ ເດີງ ເຢຊູ ແຕີ່ອ໌ ປໍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ມາ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ, ໄລ່ ແປຣີ ກວາຍ ກຼຶ່ງ ກັອຍ ແຊອ໌ ໂອນ ປີລາດ ອາໂຣຍຮ ບາຣາບາ, ຕາ ແກີນ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ປີລາດ ຕາແບີບ ລັ່ຮ ໄລ່ ກັອຍ ປາຍ: \"ອຶນເຕົ່າ ເຍືາ ໂອນ ເກົາ ຕະ ກະ ກວາຍ ໄນ່, ກາ ເຍືາ ດໍອ໌ ເຕືາວ ປັຣເຍືາ ອິດຊະຣາເອລ?\" ");
INSERT INTO ncq_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ໄລ່ ກັອຍ ຕາແອີຍ ເຣ່ງ ລາລື່ ປາຍ: \"ແຕັຮ ອັນ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ!\" ");
INSERT INTO ncq_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ປີລາດ ຕາແບີບ ລັ່ຮ ໄລ່ ກັອຍ ປາຍ: \"ນານ່ະ? ຣາມຶ່ຮ ອຶນເຕົ່າ ອັນ ຕະ ຕາ ອໍ?\" ມາ ໄລ່ ກັອຍ ຕາແອີຍ ເຣ່ງ ລາລື່ ກາເລີຍ ແຕ ອຶນໂຍ່ງ ແອັນ: \"ແຕັຮ ອັນ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ!\" ");
INSERT INTO ncq_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ປີລາດ ອີ ໂອນ ປຍາຍ໌ ຣາງຶ່ຮ ກອນແຊມ. ນ່ະກັອຍ ອັນ ອາໂຣຍຮ ບາຣາບາ ໂອນ ໄລ່, ກະ ອັນ ແປຣີ ໂອນ ເນົ່າ ວັ່ດ ເຢຊູ ແຕ ອຶນໄຊ ອຶງກັຣ ເນົ່າ ໂທດ ໂຈະ ຕາອ໌. ແວັດ ກັອຍ ອັນ ມ່ອບ ເຢຊູ ໂອນ ໄລ່ ເດີງ ແຕັຮ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ. ");
INSERT INTO ncq_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ເຈີ່ ຕາຮານ ເດີງ ອາຊວຍ ເຢຊູ ແຕີ່ອ໌ ປໍ ຊັງອາຣ ດຸງ ເນົ່າ ເກີ່ຍ ຕັດຊີ່ນ ກວາຍ. ໄລ່ ກັອຍ ກູອ໌ ປາໂຣມ ອຶນແຍ່ະ ມັຮ ຕາຮານ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ໄລ່ ກັອຍ ອາແຊິບ ເຢຊູ ອາຢັ່ອຮ ຕີ່ ຊີ່ ອາອູຍ. ໄລ່ ຕະ ກຸນຕຣວາອ໌ ຊັຣເລືາ ອາປື່ງ ໂຈະ ຕຶ່ງ ແປຼີ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ເຈີ່ ໄລ່ ຕະ ອຶນຕີ ຣາຢອຍ໌ ອັນ ປາຍ: \"ກູກຸຮ ເຍືາ ກາ ເຕືາວ ປັຣເຍືາ ອິດຊະຣາເອລ. ແຊອ໌ ໂອນ ເຍືາ ເບີນ ບັນ ເຣ່ງ ກາແຕງ ຄາຍັງ.\" ");
INSERT INTO ncq_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ໄລ່ ກັອຍ ໄປຣ່ຮ ອີດ, ໄປຣ່ຮ ອີດ ແຕ ກ່ອນ ຕຶ່ງ ແປຼີ ອັນ, ກະ ໄລ່ ກູຈົຮ ໂຈະ ຕຶ່ງ ຈະ ອັນ. ໄລ່ ກຼຸ່ ຣາໂກລ ຕະ ນ່ະ ຊາງ ອັນ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ແວັດ ໄລ່ ອາເຢ່ ພາມາດ ອັນ ນ່ະກັອຍ, ໄລ່ ຕວດ ລັ່ຮ ອາຢັ່ອຮ ຕີ່ ຊີ່ ອາອູຍ. ກະ ໄລ່ ອາແຊິບ ລັ່ຮ ເກຣີ່ງ ອັນ ເບີມ. ເຈີ່ ໄລ່ ເດີງ ອາລັ່ອຮ ອີ ແຕັຮ ອັນ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ. ");
INSERT INTO ncq_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ບັອງ ກາ ກັອຍ ເບີນ ມານະ ຣາມຶ່ຮ ຊີໂມນ ແຕ ເມືອງ ກີເຣເນ, ອຶມປໍ່ ອາເລັກຊັນເດີ ກະ ຣູໂພ ເປາະ ພາ ຣານາ ກັອຍ. ຊີໂມນ ເຈົາ ແຕ ຢັ່ຮ ນໍ່ອ໌ ວີ່ລ. ຕາຮານ ກັອຍ ໂກບ ອັນ ໂອນ ໂດລ ອາລ່ອງ ຊັງກັງ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ໄລ່ ເດີງ ເຢຊູ ແຕີ່ອ໌ ອຶນຕຸ ເນົ່າ ດໍອ໌ ໂຄລະໂຄທາ. ປັຣນາຍ ໄນ່ ອາຕີ ລັ່ຮ ລາ 'ອຶນຕຸ ອຶງຮາງ ຕາຕາຣ ແປຼີ.' ");
INSERT INTO ncq_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ເຈີ່ ໄລ່ ກັອຍ ໂອນ ເຢຊູ ງ່ອຍ໌ ບຼັອງ ເນົ່າ ກັຣຈຸ ກະ ຊຽດ ອາລ່ອງ ປາຮວມ. ມາ ອັນ ຕາ ເບີນ ງ່ອຍ໌. ");
INSERT INTO ncq_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ໄລ່ ແຕັຮ ອັນ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ. ກະ ໄລ່ ອີດ ເກຣີ່ງ ຕຳປັອກ ອັນ, ເຈີ່ ໄລ່ ອຶມແປອ໌ ຣານາ ມັນຕັດ ອາຍຸ່, ອາແລ່ະ ເບີນ ລາ ໂທຍ. ");
INSERT INTO ncq_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ແຕີ່ອ໌ ມານາງ ຊາລຍາ, ໄລ່ ແຕັຮ ອັນ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ. ");
INSERT INTO ncq_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ກະ ໄລ່ ຄຽນ ດໍອ໌ ແປີງ ແປຼີ ເຢຊູ ປັຣນາຍ ອາຕີ ແຕ ອັນ ປາຍ: \"ໄນ່ ລາ ເຕືາວ ປັຣເຍືາ ອິດຊະຣາເອລ.\" ");
INSERT INTO ncq_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ໄລ່ ແຕັຮ ບາຣ ນະ ກວາຍ ຊາແວງ ມັນຕຸ ກະ ເຢຊູ, ມານະ ຢັ່ຮ ອາຕ່ຳ, ມານະ ຢັ່ຮ ອາເວ່ຣ. ");
INSERT INTO ncq_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ນ່ະກັອຍ ແກີດ ຣາປຍາຍ໌ ກະ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ ປາຍ ນ່ະໄນ່: \"ກວາຍ ເກີ່ຍ ນັ່ບ ອັນ ລາ ກວາຍ ໂລ່ຍຮ ນ່ະ ເນົ່າ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ກວາຍ ກາ ເປາະ ພາ ອຶນຕຸ ເນົ່າ ກາຈີດ ເຢຊູ ໄລ່ ອາວິ່ດ ແປຼີ ງູງິ່ຣ ກະ ອາເຢ່ ພາມາດ ອັນ, ປາຍ: \"ໄມ່ ໄນ່ ກາ ປາຍ ບັອງ ກັອຍ ໄມ່ ຕາລຸຮ ດຸງ ຊາງ ເຢືາງ ເຈົາຣາຊີ, ເຈີ່ ໄມ່ ຕະ ລັ່ຮ ໄປ ຕາໄງ ເຈີ່ ແຕິ່. ");
INSERT INTO ncq_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ເອົາ ໄມ່ ແຊງ ແຕ ອາລ່ອງ ຊັງກັງ ກັອຍ, ຈ່ອຍ ອາມົ່ງ ຈະ ໄມ່ ເບີມ!\" ");
INSERT INTO ncq_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ກະ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ກະ ອຶນແຍ່ະ ມັຮ ກວາຍ ອາຕີ ຄານອດ ອາເຢ່ ພາມາດ ເຕ່ ເຢຊູ. ໄລ່ ກັອຍ ປາຍ: \"ກວາຍ ການໍ່ອ໌ ເຕ່ອ໌ ອັນ ຈ່ອຍ ອາມົ່ງ, ມາ ຈະ ອັນ ເບີມ, ຕາ ເຮີມ ເຕ່ອ໌ ອັນ ຈ່ອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ຄັນ ອັນ ເມ່ນ ກຣີດ, ເຕືາວ ປັຣເຍືາ ອິດຊະຣາເອລ, ໂອນ ອັນ ແຊງ ແຕ ອາລ່ອງ ຊັງກັງ ໂອນ ໄຮ ເຮີມ. ນ່ະກັອຍ ແຕ ເຕ່ອ໌ ໄຮ ຊາອຳ ເຕ່ ອັນ.\" ກະ ໄລ່ ບາຣ ນະ ກາ ເນົ່າ ແຕັຮ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ ມັນຕຸ ກະ ເຢຊູ, ໄລ່ ອາເຢ່ ພາມາດ ເຢຊູ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ແຕ ມັ່ດ ມານາງ ຕີລມູ່ລ ເຕົ່າ ແຕີ່ອ໌ ມານາງ ວີ່ຮ, ແກີດ ການຳ ອຶນແຍ່ະ ຕຶ່ງ ກຣວາງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ແຕີ່ອ໌ ມານາງ ກູແວີ ອີ ວີ່ຮ ເຢຊູ ກູອ໌ ເຣ່ງ ລາລື່ ປາຍ: \"ເອໂລອີ, ເອໂລອີ, ແລມາ ຊາບັກທານີ?\" ປັຣນາຍ ໄນ່ ອາຕີ ລັ່ຮ ລາ, \"ເຢືາງ ເຈົາຣາຊີ ເກົາ ເອີຍ, ເຢືາງ ເຈົາຣາຊີ ເກົາ ເອີຍ, ນານ່ະ ໄມ່ ຕັຮ ເກົາ?\" ");
INSERT INTO ncq_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ເບີນ ກວາຍ ແອີດ ຕາຢຶ່ງ ແຈ່ະ ກັອຍ, ໄລ່ ຊັອງ ອັນ ກູອ໌ ນ່ະກັອຍ. ເຈີ່ ໄລ່ ປາຍ: \"ກັ່ອຍ! ອັນ ກູອ໌ ເອລີຢາ.\" ");
INSERT INTO ncq_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ກະ ເບີນ ມານະ ແຕ ໄລ່ ກັອຍ ຕາລຸ່ຮ ອີດ ມວຍ ປານຍາລ ອາຣິ. ອັນ ອາລຸ ອາຣິ ກັອຍ ຕຶ່ງ ບຼັອງ ອຶນເຍາະ, ກະ ໂຈະ ຕຶ່ງ ຊັຣນວາຍຮ. ເຈີ່ ອັນ ອາແວີຍ ໂອນ ເຢຊູ ກາຢັບ ງ່ອຍ໌. ອັນ ປາຍ: \"ໄຮ ເກຣາະ ເວືາຍ. ໄຮ ເນ່ ເອລີຢາ ແຕີ່ອ໌ ອາລິ່ຮ ອາແຊງ ອັນ, ມາ ຕາ ເບີນ.\" ");
INSERT INTO ncq_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ມາ ເຢຊູ ອູໂອຍ ເຣ່ງ ລາລື່, ເຈີ່ ອັນ ຕາອັອຮ ຣາງຶ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ເບີນ ອາຣິ ກາ ເນົ່າ ກາຕັງ ກຼຸງ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ ແກີດ ຣາແຮອ໌ ແຕ ຕີ່ ແຕີ່ອ໌ ເຕືາບ, ແກີດ ບາຣ ຊັນແຕຣອ໌. ");
INSERT INTO ncq_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ບັອງ ກາ ກັອຍ ເບີນ ມານະ ຕາຮານ ກາ ຊົດ ມວຍ ຣ່ອຍ ຕາຮານ ການໍ່ອ໌, ອັນ ຕາຢຶ່ງ ຢັ່ຮ ເມືາງ ເຢຊູ. ພໍກາ ອັນ ເຮີມ ເຢຊູ ຕາອັອຮ ຣາງຶ່ຮ, ອັນ ປາຍ: \"ເມ່ນ ລາລື່ ໄນ່ ລາ ກອນ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ເບີນ ມັຮ ກວາຍ ມັນແຊມ ແອີດ ເຢີ່ງໆ ຕາງ່ອນ ເນ່ ປໍ ກັອຍ ເຕ່. ໄປ ນະ ແຕ ມູ່ ໄລ່ ກັອຍ ລາ ມາຣີ ແຕ ວີ່ລ ມັກດາລາ, ມາຣີ ລາ ອຶມເປ່ອ໌ ບາຣ ນະ ແຊມອາຍ ໂຢເຊ ກະ ຢາໂກໂບ ແກດ, ກະ ຊາໂລເມ. ");
INSERT INTO ncq_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ແຕ ອຶນໂຍ່ງ, ບັອງ ກາ ເຢຊູ ແອີດ ຕຶ່ງ ແຄງ ຄາລີເລ, ໄລ່ ໄປ ນະ ມັນແຊມ ໄນ່ ເກີ່ຍ ຕາປູ່ນ ເຢຊູ ກະ ເນ່ ຊາລີອ໌ ຈ່ອຍ ອັນ. ກະ ເບີນ ເຕ່ ປໍ ກັອຍ ຊາອຶ່ຍ ມັນແຊມ ການໍ່ອ໌ ກາ ເປາະ ມັນຕຸ ກະ ເຢຊູ ບັອງ ກາ ອັນ ຊັອຮ ປໍ ເມືອງ ເຢຣູຊາເລັມ. ");
INSERT INTO ncq_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ຕາໄງ ກັອຍ ລາ ຕາໄງ ເນົ່າ ກຽມ ດໍອ໌ ອຶນໂຍ່ງ ຕາໄງ ຣາລູ່. ແຕີ່ອ໌ ມານາງ ຕາບື່ ແຈ່ະ ອຶນຕຣວຍ ອີ ມູ່ດ ລົ່ກ, ");
INSERT INTO ncq_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ໂຢເຊັບ ແຕ ເມືອງ ອາຣີມາທາຍ ແຕີ່ອ໌ ປໍ ປີລາດ. ອັນ ລາ ມານະ ແຕ ມູ່ ກວາຍ ຊົດ ກາ ເນົ່າ ຊາງັດ ລາລື່, ກະ ອັນ ອຶງກ່ອງ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ. ອັນ ຍັ່ນ ແຊອ໌ ກູມູ່ຍ໌ ເຢຊູ ແຕ ປີລາດ. ");
INSERT INTO ncq_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ປີລາດ ຊັອງ ງຶ່ດ ລາລື່ ເນົ່າ ປາຍ ເຢຊູ ກູຈີດ ເຈີ່. ນ່ະກັອຍ ອັນ ກູອ໌ ຕາຮານ ກາ ຊົດ ມວຍ ຣ່ອຍ ຕາຮານ ກັອຍ ຢໍອ໌ ອີ ຕາແບີບ ອັນ ປາຍ ເຢຊູ ກູຈີດ, ມາ ຕາ ຢວາຮ. ");
INSERT INTO ncq_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ແຕີ່ອ໌ ປີລາດ ດັງ ແຕ ຕາຮານ ກັອຍ ປາຍ ເຢຊູ ກູຈີດ ເຈີ່, ອັນ ໂອນ ກູມູ່ຍ໌ ເຢຊູ ປໍ ໂຢເຊັບ. ");
INSERT INTO ncq_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ນ່ະກັອຍ ໂຢເຊັບ ແຈີງ ມວຍ ປຼັ່ຮ ອາຣິ ກຼໍອ໌ ແຈບ ອໍ. ເຈີ່ ອັນ ອາລິ່ຮ ເຢຊູ ອາແຊງ ແຕ ອາລ່ອງ ຊັງກັງ, ອັນ ຕວມ ແຕ ອາຣິ ກັອຍ, ກະ ອັນ ດໍອ໌ ກູມູ່ຍ໌ ເຢຊູ ຕຶ່ງ ປີ່ງ ເນົ່າ ໄປອ໌ ຕຶ່ງ ຕາເມົາ. ເຈີ່ ອັນ ວິ່ລ ຕາເມົາ ໂກ່ລ ກາຕັງ ງັ່ຮ ປີ່ງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ມາຣີ ແຕ ວີ່ລ ມັກດາລາ ກະ ມາຣີ ອຶມເປ່ອ໌ ໂຢເຊ, ໄລ່ ບາຣ ນະ ເຮີມ ອຶນຕຸ ເນົ່າ ດໍອ໌ ກູມູ່ຍ໌ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ແວັດ ຕາໄງ ຣາລູ່, ເຈີ່ ມາຣີ ແຕ ວີ່ລ ມັກດາລາ, ມາຣີ ອຶມເປ່ອ໌ ຢາໂກໂບ, ກະ ຊາໂລເມ, ໄລ່ ໄປ ນະ ເດີງ ເກຣີ່ງ ປາຮວມ ອີ ເຕືາ ຕຶ່ງ ກູມູ່ຍ໌ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ຕາໄງ ມວຍ ຕຶ່ງ ອາທິດ ກັອຍ, ປັ່ງ ຕາຣື່ບ ມັ່ດ ມານາງ ຕາແບິ ລັ່ອຮ, ໄລ່ ແຕີ່ອ໌ ປໍ ປີ່ງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ໄລ່ ມານະ ຕາແບີບ ມານະ ປາຍ: \"ເນົ່າ ເຕ່ອ໌ ວິ່ລ ຕາເມົາ ໂອນ ໄຮ ແຕ ງັ່ຮ ປີ່ງ ກັອຍ?\" ");
INSERT INTO ncq_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ຕາເມົາ ກັອຍ ລາ ປື່ດ ລາລື່. ມາ ພໍກາ ໄລ່ ຕາງ່ອນ ອາຊັອຮ, ໄລ່ ເຮີມ ເນົ່າ ວິ່ລ ເຈີ່ ຕາເມົາ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ພໍກາ ໄລ່ ມູ່ດ ຕຶ່ງ ປີ່ງ, ໄລ່ ເຮີມ ມານະ ກວາຍ ຣາເລົາ ກາ ແຊິບ ອາຢັ່ອຮ ຕີ່ ກຼໍອ໌, ຕາກູ ແອີດ ຢັ່ຮ ອາຕ່ຳ ອຶນຕຸ ກັອຍ. ເຈີ່ ໄລ່ ກັອຍ ຊັອງ ອຶງກັອຮ. ");
INSERT INTO ncq_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ມາ ກວາຍ ຣາເລົາ ກັອຍ ອາຕີ ໄລ່ ປາຍ: \"ເຍືາ ອຶນໂຈຍ ອຶງກັອຮ ອຶນເຕົ່າ. ເກົາ ດັງ ເຍືາ ຈໍ່ອ໌ ເຢຊູ, ກວາຍ ແຕ ວີ່ລ ນາຊາເຣັດ, ອັນ ກາ ເນົ່າ ແຕັຮ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ. ມາ ອັນ ຕາ ເບີນ ແອີດ ອຶນໄນ່ ນັ່ອງ. ອັນ ອາມົ່ງ ລັ່ຮ ເຈີ່. ເຍືາ ເນ່ ປໍ ອຶນຕຸ ເນົ່າ ດໍອ໌ ກູມູ່ຍ໌ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ເຈີ່ ເຍືາ ເປາະ ອາຕີ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ, ກະ ເປໂຕ ປາຍ: 'ເຢຊູ ເປາະ ອຶນໂຍ່ງ ເຍືາ ປໍ ແຄງ ຄາລີເລ. ເຍືາ ເປາະ ປໍ ກັອຍ, ເຍືາ ຣາມົຮ ອັນ ນ່ະ ອັນ ອາຕີ ເຍືາ ແຕ ອຶນໂຍ່ງ ເຈີ່.'\" ");
INSERT INTO ncq_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ນ່ະກັອຍ ໄລ່ ມັນແຊມ ກັອຍ ຕາລຸ່ຮ ລັ່ອຮ ແວັດ ແຕ ປີ່ງ ກັອຍ. ໄລ່ ຊັອງ ງຶ່ດ ລາລື່, ກະ ໄລ່ ກາໄກ່ຮ ຍ່ອນ ໄລ່ ຊັອງ ອຶງກັອຮ ລາລື່. ໄລ່ ຕາ ຍັ່ນ ຕະ ອຶນຕີ ອຶນເຕົ່າ ໂອນ ກວາຍ ດັງ, ຍ່ອນ ໄລ່ ເກຣ່າະ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ຕາໄງ ມວຍ ຕຶ່ງ ອາທິດ ກັອຍ, ເຢຊູ ໂມ່ຍຮ ລັ່ຮ ແຕ ປີ່ງ. ແຕ ປຼື່ ລາລື່ ຕາຣື່ບ ກັອຍ ອັນ ເປາະ ອາປັຮ ຈະ ອັນ ໂອນ ມາຣີ ແຕ ວີ່ລ ມັກດາລາ ເຮີມ ອັນ. ມາຣີ ໄນ່ ລາ ອັນ ກາ ເຢຊູ ຕູ່ຍຮ ອາລັ່ອຮ ຕາປູ່ລ ລຳ ເຢືາງ ຕາ ອໍ ກາ ຕຣວບ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ເຈີ່ ມັນແຊມ ກັອຍ ເປາະ ອາຕີ ໂອນ ເຢົ່າ ເຢຊູ ດັງ ມັຮ ຣານະ ອັນ ເຮີມ. ມາ ເຢົ່າ ເຢຊູ ກັອຍ, ໄລ່ ອຶນນັ່ອງ ເຍືາມ ຊາແຍີ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ພໍກາ ເຢົ່າ ເຢຊູ ຊັອງ ມັນແຊມ ກັອຍ ປາຍ ເຢຊູ ອາມົ່ງ ລັ່ຮ, ກະ ມັນແຊມ ກັອຍ ເຮີມ ອັນ ເຈີ່, ໄລ່ ອຶນນັ່ອງ ຕາ ເບີນ ຕາປູ່ນ ປັຣນາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ເຈີ່ ເບີນ ກວາຍ ຣາເລົາ ບາຣ ນະ ແອັນ ລັ່ອຮ ແຕ ເມືອງ ເຢຣູຊາເລັມ. ກະ ເຢຊູ ອາປັຮ ຈະ ອັນ ແກີດ ຣູ່ບເຣືາງ ອຶມພາ ແອັນ ໂອນ ບາຣ ນະ ກັອຍ ເຮີມ. ");
INSERT INTO ncq_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ບາຣ ນະ ກັອຍ ເຈົາ ອາຕີ ໂອນ ເຢົ່າ ເຢຊູ ປາຍ ໄລ່ ເຮີມ ເຢຊູ, ມາ ເຢົ່າ ກັອຍ ຕາ ເບີນ ຕາປູ່ນ ຊາ ປັຣນາຍ ກວາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ອຶນຕູ່ນ ແອັນ ເຢຊູ ອາປັຮ ຈະ ອັນ ໂອນ ມູ່ ກາ ມວຍ ຈິ່ດ ລາ ມານະ ເຮີມ ເຕ່. ເຢຊູ ຕະ ນ່ະກັອຍ ບັອງ ກາ ມູ່ ມວຍ ຈິ່ດ ລາ ມານະ ກັອຍ ຕາກູ ຈີຈາ. ກະ ເຢຊູ ຕິ ໄລ່ ກັອຍ ຍ່ອນ ໄລ່ ເບີນ ຣາງຶ່ຮ ກັ່ອງ ລາລື່, ຕາ ຢໍອ໌ ອີ ຊາອຳ ປາຍ ອັນ ອາມົ່ງ ລັ່ຮ ນ່ະ ມັຮ ກວາຍ ການໍ່ອ໌ ອາຕີ ໄລ່ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ເຢຊູ ອາຕີ ໄລ່ ກັອຍ ປາຍ: \"ເຍືາ ເປາະ ອຶນແຍ່ະ ກູ່ ກຣວາງ ປື່ນ ມັນລັ່ອງ ກຣຸ່ ໄນ່ ກະ ອາຕີ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ ດັງ ປັຣນາຍ ອໍ ແຕ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ກວາຍ ອາແລ່ະ ມາ ຊາອຳ ເກົາ, ເຈີ່ ຣັ່ບ ຣີ່ດ ຕຶ່ງ ແດີອ໌, ເກົາ ຈ່ອຍ ອາມົ່ງ ກວາຍ ກັອຍ. ມາ ກວາຍ ອາແລ່ະ ຕາ ເບີນ ຊາອຳ ເກົາ, ກວາຍ ກັອຍ ຈີວ໌ ໂຕ່ດ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","18","ອາແລ່ະ ກາ ຊາອຳ ເກົາ, ໄລ່ ເຕ່ອ໌ ຕະ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ນ່ະໄນ່: ຍ່ອນ ຣາມຶ່ຮ ເກົາ ເຕ່ອ໌ ໄລ່ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ; ເຕ່ອ໌ ໄລ່ ອາຕີ ປັຣນາຍ ການໍ່ອ໌ ກາ ໄລ່ ຕາ ເກີ່ຍ ຊັອງ; ເຕ່ອ໌ ໄລ່ ຢຸມ ກູຊັນ ມາ ຕາ ເບີນ ແກີດ ອຶນເຕົ່າ; ເຕ່ອ໌ ໄລ່ ງ່ອຍ໌ ເກຣີ່ງ ບູລ ມາ ໄລ່ ຕາ ເບີນ ບູລ; ກະ ເຕ່ອ໌ ໄລ່ ຊາປ່ະ ອາຕີ ຕຶ່ງ ກວາຍ ອາອີ່ ໂອນ ກວາຍ ອາອີ່ ກັອຍ ແກີດ ແບຣັຮ.\" ");
INSERT INTO ncq_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ເຈີ່ ອັນ ຊັອຮ ປໍ ມັນລັ່ອງ, ກະ ອັນ ຕາກູ ຢັ່ຮ ອາຕ່ຳ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ເຈີ່ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ລັ່ອຮ ເປາະ ປໍ ໄນ່ ເປາະ ປໍ ກັອຍ ອາຕີ ເລືອຍໆ ປັຣນາຍ ອໍ ແຕ ເຢຊູ. ກະ ເຢືາງ ເຈົາຣາຊີ ຈ່ອຍ ໄລ່, ໂອນ ໄລ່ ເບີນ ອຳນາດ ເຕ່ອ໌ ຕະ ຣານະ ຕາ ເກີ່ຍ ເຮີມ. ຍ່ອນ ນ່ະກັອຍ ກວາຍ ເຕ່ອ໌ ດັງ ປັຣນາຍ ໄລ່ ອາຕີ ລາ ປຍາຍ໌ ລາລື່.");
INSERT INTO ncq_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ອາຈວາຍຮ ເທໂອພີໂລ ເອີຍ! ເບີນ ກຼຶ່ງ ກວາຍ ຕະ ອຶນແຍ່ະ ແຕ ຣາງຶ່ຮ ໄລ່ ຄຽນ ແຕ ຣານະ ເຢຊູ. ມັຮ ປັຣນາຍ ກາ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ແຕ ເຢຊູ ແກີດ ແມິ່ມ ເຈີ່ ປໍ ໄຮ. ");
INSERT INTO ncq_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ມັຮ ກວາຍ ກັອຍ ເບີນ ດັງ ແຕ ຣານະ ເຢຊູ ຕະ, ຍ່ອນ ໄລ່ ເບີນ ຊັອງ ແຕ ກວາຍ ກາ ເຮີມ ອັນ ອາຕີ ແຕ ຕາແບິ. ກວາຍ ກັອຍ ຕະ ອຶນຕີ ແຕ ອຶນແຍ່ະ ປັຣນາຍ ອໍ ກັອຍ ໂອນ ໄຮ ດັງ. ");
INSERT INTO ncq_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ນ່ະກັອຍ, ແຕ ຕາແບິ, ເກົາ ຣຍານ ດັງ ແຈງ ລາລື່ ເຈີ່ ອຶນແຍ່ະ ປັຣນາຍ ມັຮ ກວາຍ ກັອຍ ຕະ ອຶນຕີ, ຍ່ອນ ເກົາ ຄຶ່ດ ອີ ຄຽນ ອຶນແຍ່ະ ຣາມຶ່ຮ ໄນ່ ໂອນ ໄມ່ ເບີນ ດັງ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ເກົາ ຕະ ນ່ະກັອຍ ຢໍອ໌ ອີ ໂອນ ໄມ່ ດັງ ແຈງ ລາລື່ ກູ່ ຣາມຶ່ຮ ປຍາຍ໌ ແຕ ປັຣນາຍ ກາ ເນົ່າ ອາຕີ ໄມ່ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ບັອງ ກາ ເຮໂຣດ ແກີດ ເຕືາວ ປັຣເຍືາ ຕຶ່ງ ແຄງ ຢູດາຍ, ເບີນ ມານະ ແຕ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ຣາມຶ່ຮ ເຊກາຣີຢາ. ອັນ ລາ ແຕ ຈຸ່ມເຈືອ ອາບີຢາ, ມານະ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ. ລາກວຍ ເຊກາຣີຢາ ລາ ຣາມຶ່ຮ ເອລີຊາເບັດ ແຕ ຈຸ່ມເຈືອ ອາໂຣນ. ");
INSERT INTO ncq_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ໄລ່ ບາຣ ນະ ໄນ່ ລາ ກວາຍ ມັນຕັ່ດ ອໍ ຢັ່ຮ ເມືາງ ເຢືາງ ເຈົາຣາຊີ. ໄລ່ ຊາງັດ ກຣັ່ກ ລາລື່ ຄານອດ ມັຮ ເຢືາງ ເຈົາຣາຊີ ປາຕັບ, ກະ ຕາ ເບີນ ເນົ່າ ເຕ່ອ໌ ຕິ ປາຍ ໄລ່ ຕະ ໂລ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ໄລ່ ບາຣ ນະ ໄນ່ ຕາ ເບີນ ເບີນ ກອນ, ຍ່ອນ ເອລີຊາເບັດ ລາ ກວາຍ ກາແດງ, ກະ ໄລ່ ບາຣ ນະ ລາ ກວາຍ ເທົາ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ໄລ່ ເບີນ ຣີ່ດ ຣາຊິງ ດໍອ໌ ອຶມແປອ໌ ຣານະ ຕະ. ເບີນ ມວຍ ຕາໄງ ໄລ່ ຣາຊິງ, ໄກຣ ເຊກາຣີຢາ ແອີດ ຊາງ ຣີ່ດ ຢັ່ຮ ເມືາງ ເຢືາງ ເຈົາຣາຊີ. ໄລ່ ໂອນ ອັນ ມູ່ດ ບຸຮ ເກຣີ່ງ ປາຮວມ ຕຶ່ງ ຊັນເຕຣືາງ ຣີ່ດ ຕຶ່ງ ກູນົງ ດຸງ ຊາງ ປື່ດ. ");
INSERT INTO ncq_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ບັອງ ກາ ເຊກາຣີຢາ ມູ່ດ ບຸຮ ເກຣີ່ງ ປາຮວມ ກັອຍ, ເບີນ ກຼຶ່ງ ກວາຍ ແອີດ ໂຣ່ມ ເກົາແຊອ໌ ຢັ່ຮ ນໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ເບີນ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ແຕີ່ອ໌ ປໍ ເຊກາຣີຢາ. ເທວາດາ ກັອຍ ແອີດ ຕາຢຶ່ງ ຢັ່ຮ ອາຕ່ຳ ຊັນເຕຣືາງ ຣີ່ດ ກາ ເນົ່າ ບຸຮ ເກຣີ່ງ ປາຮວມ. ");
INSERT INTO ncq_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ພໍກາ ເຊກາຣີຢາ ເຮີມ ເທວາດາ ກັອຍ, ອັນ ຊັອງ ງຶ່ດ ກະ ອັນ ອຶງກັອຮ. ");
INSERT INTO ncq_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ມາ ເທວາດາ ກັອຍ ອາຕີ ອັນ ປາຍ: \"ເຊກາຣີຢາ ເອີຍ! ໄມ່ ອຶນໂຈຍ ອຶງກັອຮ, ຍ່ອນ ເຢືາງ ເຈົາຣາຊີ ຊັອງ ແຕ ປັຣນາຍ ໄມ່ ເກົາແຊອ໌. ເອລີຊາເບັດ, ລາກວຍ ໄມ່, ປັຣແນີ ມັນເຕຣືາ ອັນ ຣັ່ຮ ກອນ ຣາເລົາ ມານະ. ອຶງເຄາະ ເຍືາ ດໍອ໌ ຣາມຶ່ຮ ອັນ ໂຢຮັນ. ");
INSERT INTO ncq_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ປັຣແນີ ມັນເຕຣືາ ຣາງຶ່ຮ ໄມ່ ຊັອງ ຣໍ່ອ໌ ບູຍ ຍ່ອນ ໄມ່ ເບີນ ກອນ ຣາເລົາ. ກະ ກຼຶ່ງ ກວາຍ ການໍ່ອ໌ ແຮີ, ໄລ່ ຊັອງ ຣໍ່ອ໌ ເຕ່ ແຕີ່ອ໌ ຕາໄງ ກອນ ຣາເລົາ ໄມ່ ແກີດ, ");
INSERT INTO ncq_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ຍ່ອນ ເຈີ່ ປໍ ເມືາງ ອັນ ແກີດ ປື່ດ ຢັ່ຮ ເມືາງ ເຢືາງ ເຈົາຣາຊີ. ອຶງເຄາະ ອັນ ອຶນໂຈຍ ງ່ອຍ໌ ບຼັອງ ອຶນເຕົ່າ. ກະ ອັນ ເບີນ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ຊົດ ລາລື່ ຕຶ່ງ ຣາງຶ່ຮ ອັນ ແຕ ຕາໄງ ອຶນນັ່ອງ ຕຶ່ງ ປຸ່ງ ອຶມເປ່ອ໌ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ປັຣແນີ ມັນເຕຣືາ ອັນ ຕະ ໂອນ ກຼຶ່ງ ກວາຍ ອິດຊະຣາເອລ ລົ່ບ ລັ່ຮ ປໍ ເຢືາງ ເຈົາຣາຊີ, ອຶນເຈົາ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ອັນ ເບີນ ຣາງຶ່ຮ ກະ ອຳນາດ ມູເຈິງ ນ່ະ ເອລີຢາ, ອັນ ກາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ. ອັນ ເປາະ ອຶນໂຍ່ງ ແຕ ມານະ ກາ ເຢືາງ ເຈົາຣາຊີ ຣຽຮ ດໍອ໌ ຈ່ອຍ ອາມົ່ງ ກວາຍ. ອັນ ຕະ ໂອນ ອຶມປໍ່ ແກີດ ລັ່ຮ ມວຍ ຣາງຶ່ຮ ກະ ກອນ. ກະ ອັນ ຕະ ໂອນ ໄລ່ ກາ ຕາ ເບີນ ຊາງັດ ຣານະ ເຢືາງ ເຈົາຣາຊີ ໂອນ ໄລ່ ຄຶ່ດ ລັ່ຮ ຕະ ຣານະ ຕານັ່ອງ ອໍ ແອັນ. ອັນ ຈ່ອຍ ໂອນ ມັຮ ກວາຍ ການໍ່ອ໌ ອາຕຶ່ ລັ່ຮ ຣາງຶ່ຮ ໄລ່ ໂອນ ອຶນເຈົາ ຕະ ຊົດ.\" ");
INSERT INTO ncq_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ເຊກາຣີຢາ ຕາແບີບ ລັ່ຮ ເທວາດາ ກັອຍ ປາຍ: \"ນານ່ະ ເກົາ ເຕ່ອ໌ ດັງ ປັຣນາຍ ໄມ່ ລາ ປຍາຍ໌? ເກົາ ກະ ລາກວຍ ເກົາ ເທົາ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ມາ ເທວາດາ ກັອຍ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ເກົາ ລາ ຣາມຶ່ຮ ຄັບຣີເອລ. ເກົາ ລາ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ກາ ເກີ່ຍ ຕາຢຶ່ງ ຢັ່ຮ ເມືາງ ອັນ. ອັນ ແປຣີ ເກົາ ແຕີ່ອ໌ ອາຕີ ໄມ່ ໂອນ ໄມ່ ດັງ ແຕ ປັຣນາຍ ອໍ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ຊານໍ່ ໄມ່ ແກີດ ເກີອ໌ ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ອຶນແຍ່ະ ຣາມຶ່ຮ ໄນ່ ແຕີ່ອ໌, ຍ່ອນ ໄມ່ ຕາ ເບີນ ຊາອຳ ປັຣນາຍ ເກົາ. ເຢືາງ ເຈົາຣາຊີ ອີ ຕະ ກູ່ ຣາມຶ່ຮ ກາ ເກົາ ອາຕີ ໄນ່ ໂອນ ແກີດ ປຍາຍ໌ ກະ ປາເນ່ນ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ບັອງ ກັອຍ ເບີນ ກຼຶ່ງ ກວາຍ ແອີດ ເກຣາະ ເຊກາຣີຢາ ຢັ່ຮ ນໍ່ອ໌. ໄລ່ ຊັອງ ງຶ່ດ ຍ່ອນ ເຊກາຣີຢາ ແອີດ ດູ່ນ ຕຶ່ງ ກູນົງ ດຸງ ຊາງ ປື່ດ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ພໍກາ ອັນ ລັ່ອຮ, ອັນ ຕາ ເຕ່ອ໌ ປາຍ ມວຍ ຣາມຶ່ຮ ອຶນເຕົ່າ ໂຈະ ໄລ່. ນ່ະກັອຍ ໄລ່ ດັງ ອັນ ເຮີມ ເຢືາງ ເຈົາຣາຊີ ອາປັຮ ເລືາຍ ຕຶ່ງ ກູນົງ ດຸງ ຊາງ ປື່ດ ກັອຍ. ກະ ເຊກາຣີຢາ, ອັນ ຕະ ອຶນຕີ ໂຈະ ໄລ່ ແຕ ອາຕີ ຊັອງ, ຍ່ອນ ແບອ໌ ອັນ ຕາ ເຕ່ອ໌ ຕະ ອຶນຕີ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ແວັດ ເຊກາຣີຢາ ຕະ ແມິ່ມ ຣານະ ອັນ ຕຶ່ງ ດຸງ ຊາງ, ອັນ ເຈົາ ລັ່ຮ ປໍ ດຸງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ອຶນຕູ່ນ ກັອຍ ເອລີຊາເບັດ, ລາກວຍ ເຊກາຣີຢາ, ແອີດ ຕຶ່ງ ຈະ. ເອລີຊາເບັດ ແອີດ ຕຶ່ງ ດຸງ ອັນ, ຕາ ເບີນ ເປາະ ປໍ ແລ່ະ ເບີນ ເຊີງ ກາໄຊ. ");
INSERT INTO ncq_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ກະ ອັນ ປາຍ: \"ຊານໍ່ ເກົາ ຣໍ່ອ໌ ບູຍ ເຢືາງ ເຈົາຣາຊີ ຈ່ອຍ ໂອນ ເກົາ ແອີດ ຕຶ່ງ ຈະ ໂອນ ເກົາ ຕາ ເບີນ ຊັອງ ກູມາລ ນັ່ອງ ຢັ່ຮ ເມືາງ ກວາຍ ການໍ່ອ໌ ຍ່ອນ ເກົາ ແອິ ກອນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ພໍກາ ເອລີຊາເບັດ ແອີດ ຕຶ່ງ ຈະ ຕາປັ່ດ ກາໄຊ ເຈີ່. ເຢືາງ ເຈົາຣາຊີ ແປຣີ ເທວາດາ ອັນ, ຄັບຣີເອລ, ເປາະ ປໍ ວີ່ລ ນາຊາເຣັດ ຕຶ່ງ ແຄງ ຄາລີເລ. ");
INSERT INTO ncq_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ອັນ ເດີງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ເປາະ ປໍ ມານະ ກູໂມຣ ກາ ຕາ ເກີ່ຍ ບິ ມັນຕຸ ກະ ກວາຍ ຣາເລົາ. ຣາມຶ່ຮ ກູໂມຣ ກັອຍ ລາ ມາຣີ. ອຶມເປ່ອ໌ ອຶມປໍ່ ອັນ ປຣ່ອມ ໂອນ ອັນ ຣາໄກ່ອ໌໌ ກະ ມານະ ຣາເລົາ ຣາມຶ່ຮ ໂຢເຊັບ. ໂຢເຊັບ ໄນ່ ແຕ ຈຸ່ມເຈືອ ເຕືາວ ປັຣເຍືາ ດາວິດ. ");
INSERT INTO ncq_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ກັອຍ ເປາະ ປໍ ອາມໍອ໌ ມາຣີ, ກະ ອັນ ປາຍ: \"ບັນ ເຕ່ ມາຣີ. ບຸ່ນ ລາລື່ ເຢືາງ ເຈົາຣາຊີ ແອີດ ກະ ໄມ່, ກະ ອັນ ຊັອງ ຣໍ່ອ໌ ກະ ໄມ່!\" ");
INSERT INTO ncq_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ພໍກາ ມາຣີ ຊັອງ ປັຣນາຍ ເທວາດາ ກັອຍ, ອັນ ຊັອງ ງຶ່ດ ກະ ເກຣ່າະ. ອັນ ຕາ ດັງ ອຶນເຕົ່າ ເທວາດາ ກັອຍ ປາຍ ໂຈະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ເທວາດາ ກັອຍ ອາຕີ ລັ່ຮ ປາຍ: \"ມາຣີ ເອີຍ, ໄມ່ ອຶນໂຈຍ ອຶງກັອຮ ອຶນເຕົ່າ, ຍ່ອນ ເຢືາງ ເຈົາຣາຊີ ຣຽຮ ໄມ່ ໂອນ ເບີນ ບຸ່ນ. ");
INSERT INTO ncq_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ອຶນຕູ່ນ ໄມ່ ແອີດ ຕຶ່ງ ຈະ; ເຈີ່ ໄມ່ ຣັ່ຮ ກອນ ຣາເລົາ. ອຶງເຄາະ ໄມ່ ດໍອ໌ ຣາມຶ່ຮ ອັນ ລາ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ປັຣແນີ ມັນເຕຣືາ ອັນ ແກີດ ຊົດ, ກະ ເນົ່າ ດໍອ໌ ອັນ ລາ ກອນ ເຢືາງ ເຈົາຣາຊີ ກາ ປື່ດ ກາເລີຍ ອຶນແຍ່ະ ແຕ ການໍ່ອ໌. ເຢືາງ ເຈົາຣາຊີ, ອຶນເຈົາ ໄຮ, ໂອນ ອັນ ເບີນ ອຳນາດ ຕະ ຊົດ ອຶນແຍ່ະ ມູເຈິງ ອາຈວາຍຮ ອາເຈ່ຮ ອັນ ດາວິດ ແຕ ອຶມແບິ. ");
INSERT INTO ncq_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ອັນ ແກີດ ຊົດ ອຶນແຍ່ະ ມັຮ ກວາຍ ອິດຊະຣາເອລ ຊົດ ແດີຍ ເລີ່ຍ ກູມໍ. ອັນ ແກີດ ເຕືາວ ປັຣເຍືາ ເຕົ່າ ຊົດ ອຶນແຍ່ະ ມັຮ ແດີຍ!\" ");
INSERT INTO ncq_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ມາຣີ ຕາແອີຍ ເທວາດາ ກັອຍ ປາຍ: \"ເກົາ ຕາ ເກີ່ຍ ບິ ມັນຕຸ ກະ ກວາຍ ຣາເລົາ ອາແລ່ະ. ນານ່ະ ຣາມຶ່ຮ ໄນ່ ເຕ່ອ໌ ແຕີ່ອ໌ ປໍ ເກົາ?\" ");
INSERT INTO ncq_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ມາ ເທວາດາ ກັອຍ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ອຶນຕູ່ນ ແນະ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ແອີດ ກະ ໄມ່. ກະ ອຳນາດ ເຢືາງ ເຈົາຣາຊີ ກາ ປື່ດ ກາເລີຍ ອຶນແຍ່ະ ແຕ ການໍ່ອ໌ ເນ່ ຊາລີອ໌ ໄມ່. ນ່ະກັອຍ ເນົ່າ ດໍອ໌ ກອນ ໄມ່ ລາ ກອນ ເຢືາງ ເຈົາຣາຊີ. ອັນ ຕາ ເບີນ ເບີນ ໂລ່ຍຮ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ໄມ່ ຊາແຍີ ແຕ ແອີຍ ໄມ່ ເອລີຊາເບັດ. ອັນ ລາ ກວາຍ ເທົາ ເຈີ່. ກະ ເນົ່າ ປາຍ ອັນ ລາ ກວາຍ ກາແດງ. ມາ ຊານໍ່ ອັນ ແອີດ ຕຶ່ງ ຈະ ເບີນ ຕາປັ່ດ ກາໄຊ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ຕາ ເບີນ ຣານະ ອຶນເຕົ່າ ເຢືາງ ເຈົາຣາຊີ ຕາ ເຕ່ອ໌ ຕະ.\" ");
INSERT INTO ncq_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ມາຣີ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ເກົາ ລາ ກວາຍ ຕະ ຣານະ ເຢືາງ ເຈົາຣາຊີ. ເກົາ ແຊອ໌ ມັຮ ຣາມຶ່ຮ ກາ ໄມ່ ປາຍ ໂອນ ແຕີ່ອ໌ ປໍ ເກົາ.\" ແວັດ ກັອຍ ເທວາດາ ກັອຍ ເປາະ ແຕ ມາຣີ. ");
INSERT INTO ncq_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ແວັດ ກັອຍ ຕາ ເບີນ ດູ່ນ, ມາຣີ ກຽມ ອີ ເປາະ ປໍ ມວຍ ເມືອງ ແອີດ ຕຶ່ງ ກົຮ ແຄງ ຢູດາຍ. ອັນ ເປາະ ໄວ່ ລາລື່, ກຸນເຕົາ ອັນ ອີ ເປາະ ປໍ ເມືອງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ອັນ ມູ່ດ ຕຶ່ງ ດຸງ ເຊກາຣີຢາ, ກະ ອັນ ກັຣບັນ ເອລີຊາເບັດ. ");
INSERT INTO ncq_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ບັອງ ກາ ເອລີຊາເບັດ ຊັອງ ປັຣນາຍ ມາຣີ ກັຣບັນ ອັນ, ກອນ ເອລີຊາເບັດ ຕຣຸ່ຮ ເຕຣີ່ລ ຕຶ່ງ ປຸ່ງ. ກະ ເບີນ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ແກີດ ຊົດ ຕຶ່ງ ຣາງຶ່ຮ ເອລີຊາເບັດ, ");
INSERT INTO ncq_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ເຈີ່ ອັນ ປາຍ ເຣ່ງ ລາລື່: \"ເຢືາງ ເຈົາຣາຊີ ໂອນ ໄມ່ ເບີນ ບຸ່ນ ກາເລີຍ ແຕ ມັນແຊມ ການໍ່ອ໌! ກະ ກອນ ກາ ແອີດ ຕຶ່ງ ປຸ່ງ ໄມ່ ເບີນ ບຸ່ນ ເຕ່! ");
INSERT INTO ncq_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ນານ່ະ ເບີນ ຣານະ ໄນ່ ແຕີ່ອ໌ ປໍ ເກົາ? ອຶມເປ່ອ໌ ອຶນເຈົາ ເກົາ ເປາະ ຊາອົຮ ເກົາ. ຣານະ ໄນ່ ລາ ປື່ດ ລາລື່! ");
INSERT INTO ncq_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ບັອງ ກາ ເກົາ ຊັອງ ປັຣນາຍ ໄມ່ ກັຣບັນ ເກົາ, ກອນ ຕຶ່ງ ປຸ່ງ ເກົາ, ອັນ ຕຣຸ່ຮ ເຕຣີ່ລ ເຕ່, ຍ່ອນ ອັນ ຊັອງ ຣໍ່ອ໌ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ໄມ່ ເບີນ ບຸ່ນ, ຍ່ອນ ໄມ່ ຊາອຳ ມັຮ ປັຣນາຍ ກາ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ໄມ່ ແກີດ ປຍາຍ໌!\" ");
INSERT INTO ncq_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ມາຣີ ປາຍ: \"ເກົາ ຍ່ອງ ອຶນເຈົາ ເກົາ ອຶນແຍ່ະ ຣາງຶ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ກະ ຣາເວືາຍ ເກົາ ຊັອງ ຣໍ່ອ໌ ບູຍ, ຍ່ອນ ເຢືາງ ເຈົາຣາຊີ ລາ ເຢືາງ ກາ ຈ່ອຍ ອາມົ່ງ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ເກົາ ລາ ກວາຍ ແກດໆ ຕະ ຣານະ ອັນ, ມາ ອັນ ອຶນນັ່ອງ ເຈີ ກະ ຈ່ອຍ ເກົາ. ກະ ແຕ ຊານໍ່ ເຕົ່າ ແຕີ່ອ໌ ອຶນຕູ່ນ, ກູ່ ແດີຍ ກວາຍ ດໍອ໌ ເກົາ ລາ ກວາຍ ເບີນ ບຸ່ນ, ");
INSERT INTO ncq_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ຍ່ອນ ເຢືາງ ເຈົາຣາຊີ, ອັນ ກາ ເບີນ ອຳນາດ ປື່ດ ລາລື່, ຕະ ຣານະ ອໍ ໂອນ ເກົາ. ອັນ ຕາ ເບີນ ເບີນ ໂລ່ຍຮ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ອັນ ຊັອງ ອາໂຢ່ະ ຕະ ອຶນແຍ່ະ ມັຮ ກວາຍ ກາ ອຶງກັອຮ ອັນ, ແຕ ແດີຍ ໄນ່ ເຕົ່າ ແຕີ່ອ໌ ແດີຍ ອຶນຕູ່ນ. ");
INSERT INTO ncq_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ອັນ ຕະ ຣານະ ປື່ດ ແຕ ອາຕີ ອັນ ເບີມ. ກະ ອັນ ຕູ່ຍຮ ມັຮ ກວາຍ ກາ ຄຶ່ດ ປາຍ ໄລ່ ປື່ດ ກະ ອໍ ກາເລີຍ ແຕ ກວາຍ ການໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ໄລ່ ກາ ຊົດ ປື່ດ, ເຢືາງ ເຈົາຣາຊີ ຕະ ໂອນ ໄລ່ ຕາ ເບີນ ຊົດ ນັ່ອງ. ມາ ໄລ່ ກາ ແກດໆ ຊັອງ, ອັນ ອາຊັອຮ ໄລ່ ໂອນ ແກີດ ປື່ດ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ມັຮ ກວາຍ ກາ ຕຸ່ຮ ກາດີດ, ອັນ ໂອນ ໄລ່ ເບີນ ກູ່ ເກຣີ່ງ ອໍ. ມາ ໄລ່ ກາ ຊຸ ເບີນ, ອັນ ໂອນ ໄລ່ ເຈົາ ແອີງ ອາຕີ ເມືາດ. ");
INSERT INTO ncq_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ອັນ ຈ່ອຍ ມັຮ ກວາຍ ອິດຊະຣາເອລ, ໄລ່ ກາ ຕະ ຣານະ ອັນ. ກະ ອັນ ຕາ ເບີນ ຊາລີຣ ອາໂຢ່ະ ຕະ ");
INSERT INTO ncq_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ອັບຣາຮາມ ກະ ອຶນແຍ່ະ ຈຸ່ມເຈືອ ອັນ ຊົດ ແດີຍ! ນ່ະ ກາ ເຢືາງ ເຈົາຣາຊີ ເອີອ໌ ດໍອ໌ ກະ ອາຈວາຍຮ ອາເຈ່ຮ ໄຮ ແຕ ອຶມແບິ.\" ");
INSERT INTO ncq_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ມາຣີ ແອີດ ກະ ເອລີຊາເບັດ ເບີນ ໄປ ກາໄຊ. ແວັດ ກັອຍ ອັນ ເຈົາ ລັ່ຮ ປໍ ດຸງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ແຕີ່ອ໌ ປາເນ່ນ ເອລີຊາເບັດ ຣັ່ຮ ກອນ, ອັນ ຣັ່ຮ ມານຳ ກອນ ຣາເລົາ. ");
INSERT INTO ncq_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ມັຮ ກວາຍ ກາ ແອີດ ຕຶ່ງ ວີ່ລ ກັອຍ, ກະ ມັຮ ແຊມອາຍ ອັນ ຊັອງ ເຢືາງ ເຈົາຣາຊີ ອາໂຢ່ະ ຕະ ລາລື່ ເອລີຊາເບັດ. ນ່ະກັອຍ, ອຶນແຍ່ະ ນະ ໄລ່ ຊັອງ ຣໍ່ອ໌ ກະ ເອລີຊາເບັດ. ");
INSERT INTO ncq_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ພໍກາ ກອນ ກັອຍ ເບີນ ຕາກ່ອລ ຕາໄງ, ໄລ່ ເປາະ ຕະ ຣີ່ດ ກິດ ໂອນ ກອນ. ໄລ່ ຢໍອ໌ ອີ ຈົຮ ຣາມຶ່ຮ ກອນ ກັອຍ ລາ 'ເຊກາຣີຢາ,' ດວຍ໌ ຣາມຶ່ຮ ອຶມປໍ່ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ມາ ອຶມເປ່ອ໌ ອັນ ປາຍ: \"ຕາ ເບີນ! ໄຮ ດໍອ໌ ຣາມຶ່ຮ ອັນ ລາ 'ໂຢຮັນ.'\" ");
INSERT INTO ncq_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ມາ ກວາຍ ການໍ່ອ໌ ກັອຍ ປາຍ: \"ຕຶ່ງ ແຊມອາຍ ໄມ່ ຕາ ເບີນ ເນົ່າ ເບີນ ຣາມຶ່ຮ ນ່ະກັອຍ!\" ");
INSERT INTO ncq_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ໄລ່ ຕາແບີບ ລັ່ຮ ອຶມປໍ່ ກັຣແນນ ກັອຍ ຕະ ປັຣນາຍ ເກີອ໌ ແຕ ອາຕີ ໄລ່. ໄລ່ ຕາແບີບ ປາຍ: \"ນານ່ະ ໄມ່ ຢໍອ໌ ອີ ຈົຮ ຣາມຶ່ຮ ກອນ ໄມ່?\" ");
INSERT INTO ncq_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ເຊກາຣີຢາ ແຊອ໌ ມວຍ ແພນ ກາດານ ແກດ; ອັນ ຄຽນ ຕຶ່ງ ກາດານ ກັອຍ ປາຍ: \"ຣາມຶ່ຮ ອັນ ລາ ໂຢຮັນ.\" ອຶນແຍ່ະ ກວາຍ ອຶງກັອຍ ຊັອງ ງຶ່ດ ຕຶ່ງ ຣາງຶ່ຮ! ");
INSERT INTO ncq_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ບັອງ ກາ ກັອຍ ແຕິ່ ເຕ່ອ໌ ເຊກາຣີຢາ ຕະ ອຶນຕີ ລັ່ຮ, ກະ ອັນ ຍ່ອງ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ອຶນແຍ່ະ ກວາຍ ຕຶ່ງ ວີ່ລ ກັອຍ ຊັອງ ອຶງກັອຮ ລາລື່. ກະ ປັຣນາຍ ກັອຍ ດັອຮແດີນ ກູ່ ອຶນຕຸ ຕຶ່ງ ກົຮ ແຄງ ຢູດາຍ. ");
INSERT INTO ncq_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ອຶນແຍ່ະ ກູ່ ນະ ກວາຍ ກາ ຊັອງ ແຕ ຣານະ ໄນ່, ໄລ່ ຄຶ່ດ ແຕ ຣານະ ໄນ່, ກະ ໄລ່ ມານະ ຕາແບີບ ມານະ ປາຍ: \"ກອນ ໄນ່ ອີ ແກີດ ນານ່ະ?\" ຍ່ອນ ເຢືາງ ເຈົາຣາຊີ ແອີດ ກະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ເຊກາຣີຢາ, ອຶມປໍ່ ກັຣແນນ ກັອຍ, ອັນ ເບີນ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ແກີດ ຊົດ ຕຶ່ງ ຣາງຶ່ຮ ອັນ. ນ່ະກັອຍ ອັນ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","\"ອຶງເຄາະ ໄຮ ຍ່ອງ ອຶນເຈົາ ໄຮ, ລາ ເຢືາງ ເຈົາຣາຊີ ກາ ກວາຍ ອິດຊະຣາເອລ ຊາງ. ອັນ ແຕີ່ອ໌ ຈ່ອຍ ມັຮ ກອນແຊມ ອັນ, ກະ ອັນ ໄທ ລັ່ຮ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ອັນ ໂອນ ມານະ ກາ ເບີນ ອຳນາດ ລາລື່ ແຕີ່ອ໌ ຈ່ອຍ ອາມົ່ງ ໄຮ. ມານະ ໄນ່ ແຕີ່ອ໌ ແຕ ຈຸ່ມເຈືອ ເຕືາວ ປັຣເຍືາ ດາວິດ, ອັນ ກາ ຕະ ຣານະ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ປັຣນາຍ ໄນ່ ເຢືາງ ເຈົາຣາຊີ ໂອນ ກວາຍ ອາຕີ ແຕ ອຶມແບິ. ກວາຍ ກັອຍ ລາ ຕານັ່ອງ ລາລື່ ກະ ອາຕີ ຕາງ ປັຣນາຍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ອັນ ເອີອ໌ ຈ່ອຍ ອາມົ່ງ ໄຮ ແຕ ກວາຍ ກາ ຢໍອ໌ ອີ ຕະ ໄຮ, ກະ ແຕ ອາຕີ ກວາຍ ກາ ຊາອັຣ ໄຮ. ");
INSERT INTO ncq_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ອັນ ອາປັຮ ໂອນ ໄຮ ດັງ ປາຍ ອັນ ຊັອງ ອາໂຢ່ະ ຕະ ອຶນແຍ່ະ ຈຸ່ມເຈືອ ໄຮ. ກະ ອັນ ຕາ ເກີ່ຍ ຊາລີຣ ມັຮ ປັຣນາຍ ອໍ ກາ ອັນ ປັຣຄັນ ແຕ ອຶນໂຍ່ງ. ");
INSERT INTO ncq_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ອັນ ປັຣຄັນ ກະ ອັບຣາຮາມ, ລາ ອາຈວາຍຮ ອາເຈ່ຮ ໄຮ, ");
INSERT INTO ncq_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ກະ ອັນ ເອີອ໌ ອີ ຈ່ອຍ ອາມົ່ງ ໄຮ ແຕ ອາຕີ ກວາຍ ກາ ອີ ຕະ ໄຮ. ອັນ ໂອນ ໄຮ ຕະ ຣານະ ອັນ ອຶນໂຈຍ ອຶງກັອຮ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ນ່ະກັອຍ ເຕ່ອ໌ ໄຮ ຕະ ຣານະ ອໍ, ອຶນໂຈຍ ຕະ ໂລ່ຍຮ ອຶນເຕົ່າ ຢັ່ຮ ເມືາງ ອັນ ເຕົ່າ ອຶນແຍ່ະ ແດີຍ ອາມົ່ງ ໄຮ. ");
INSERT INTO ncq_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","\"ກອນ ເອີຍ! ປັຣແນີ ມັນເຕຣືາ ເນົ່າ ດໍອ໌ ໄມ່ ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ອັນ ກາ ປື່ດ ກາເລີຍ ອຶນແຍ່ະ ແຕ ການໍ່ອ໌. ໄມ່ ເປາະ ອຶນໂຍ່ງ ອຶນເຈົາ ໄຮ, ຈັຮ ຣານາ ໂອນ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ກະ ໄມ່ ອາຕີ ມັຮ ກອນແຊມ ອັນ, ໂອນ ໄລ່ ດັງ ເຢືາງ ເຈົາຣາຊີ ຕັຮ ໂລ່ຍຮ ໄລ່, ໂອນ ອັນ ເຕ່ອ໌ ຈ່ອຍ ອາມົ່ງ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ຍ່ອນ ເຢືາງ ເຈົາຣາຊີ ໄຮ ຊັອງ ອາໂຢ່ະ ຕະ ໄຮ, ນ່ະກັອຍ ອັນ ໂອນ ມານະ ແຕີ່ອ໌ ປໍ ໄຮ, ນ່ະ ແຊງ ມັ່ດ ມານາງ ລັ່ອຮ ປຼື່. ");
INSERT INTO ncq_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ກວາຍ ກັອຍ ນ່ະ ແຊງ ແຕ ມັນລັ່ອງ, ປາເລືາງ ໂຈະ ກວາຍ ຕຶ່ງ ການຳ. ອັນ ຕະ ໂອນ ກວາຍ ຕາ ເບີນ ອຶງກັອຮ ກູຈີດ ນັ່ອງ. ກະ ອັນ ອາໂຢ່ງ ໄຮ ໂອນ ເປາະ ຕຶ່ງ ຣານາ ອຽນ ອໍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ກັຣແນນ ກັອຍ ຈະ ອັນ ປື່ດ ອາຊັອຮ, ກະ ຣາງຶ່ຮ ອັນ ແກີດ ເຣ່ງ ອາຊັອຮ ເຕ່. ອັນ ແອີດ ຕຶ່ງ ຕຍາຮ ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ອັນ ຕາແບິ ຕະ ຣານະ ອາປັຮ ໂອນ ມັຮ ກວາຍ ອິດຊະຣາເອລ ເຮີມ. ");
INSERT INTO ncq_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ຕຶ່ງ ມັຮ ຕາໄງ ກັອຍ ໂອຄຸໂຕ, ລາ ເຕືາວ ປັຣເຍືາ ໂຣມ ກາ ກຣິ່ຮ, ອັນ ອາຕີ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ ອຶງເຄາະ ເປາະ ຄຽນ ຣາມຶ່ຮ ໂອນ ອັນ ດັງ ມາແລ່ະ ກຼຶ່ງ ກອນແຊມ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ໄນ່ ລາ ຕາແບິ ເນົ່າ ນັ່ບ ກວາຍ, ບັອງ ກາ ກີເຣນີໂອ ຕະ ຊົດ ເຕ່ດ ເຕືາວ ປັຣເຍືາ ໂອຄຸໂຕ ຕຶ່ງ ກຣວາງ ຊີເຣຍ. ");
INSERT INTO ncq_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ອຶນແຍ່ະ ກູ່ ນະ ມັຮ ກວາຍ ເຈົາ ລັ່ຮ ປໍ ວີ່ລ ອາຈວາຍຮ ອາເຈ່ຮ ໄລ່, ຄຽນ ດໍອ໌ ຣາມຶ່ຮ ຕຶ່ງ ວີ່ລ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ນ່ະກັອຍ ໂຢເຊັບ ລັ່ອຮ ແຕ ແຄງ ຄາລີເລ, ວີ່ລ ນາຊາເຣັດ. ອັນ ມູ່ດ ຕຶ່ງ ແຄງ ຢູດາຍ, ເມືອງ ເບັດເລເຮັມ, ລາ ເມືອງ ດາວິດ. ອັນ ມູ່ດ ເມືອງ ໄນ່, ຍ່ອນ ອັນ ລາ ແຕ ຈຸ່ມເຈືອ ດາວິດ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ອັນ ອີ ຄຽນ ຣາມຶ່ຮ ປໍ ກັອຍ. ກະ ອັນ ເດີງ ກາ ມາຣີ, ລາ ມັນແຊມ ກາ ເນົ່າ ເອີອ໌ ໂອນ ອັນ ຕະ ລາກວຍ. ມາຣີ ແອີດ ຕຶ່ງ ຈະ. ");
INSERT INTO ncq_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ບັອງ ກາ ໄລ່ ບາຣ ນະ ແອີດ ປໍ ເມືອງ ເບັດເລເຮັມ ກັອຍ, ແຕີ່ອ໌ ປາເນ່ນ ມາຣີ ອີ ຣັ່ຮ ກອນ. ");
INSERT INTO ncq_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ອັນ ຣັ່ຮ ກອນ ຣາເລົາ ກັ່ລ. ອັນ ອາກວາມ ອາຣິ ໂຈະ ກອນ ອັນ, ເຈີ່ ອັນ ອາຈຸຮ ຕຶ່ງ ຕາປ່ອງ ບັດ, ຍ່ອນ ດຸງ ກວາຍ ຕຶ່ງ ເມືອງ ກັອຍ ກູທັດ ອຶນແຍ່ະ, ຕາ ເບີນ ນັ່ອງ ອຶນຕຸ ໂອນ ໄລ່ ແອີດ. ");
INSERT INTO ncq_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ບັອງ ກາ ກັອຍ ເບີນ ກວາຍ ແອີດ ກຍາອ໌ ແກະ ຕຶ່ງ ກຣວາງ ກັອຍ. ຊາເດົາ ກັອຍ ໄລ່ ແອີດ ກຍາອ໌ ແກະ ໄລ່ ຕຶ່ງ ຕຍາຮ ກາ ເບີນ ບັດ. ");
INSERT INTO ncq_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ເບີນ ມານະ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ແຕ ມັນລັ່ອງ ແຕີ່ອ໌ ປໍ ໄລ່. ກະ ປັ່ງ ແຕ ເຢືາງ ເຈົາຣາຊີ ປາເລືາງ ອຶມແປຣ ໄລ່; ໄລ່ ຊັອງ ອຶງກັອຮ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ເທວາດາ ກັອຍ ປາຍ ໂຈະ ໄລ່ ນ່ະໄນ່: \"ອຶນໂຈຍ ອຶງກັອຮ! ເກົາ ອີ ອາຕີ ເຍືາ ມວຍ ປັຣນາຍ ຣໍ່ອ໌ ອໍ ໂອນ ອຶນແຍ່ະ ກູ່ ນະ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ຕາໄງ ໄນ່ ຕຶ່ງ ເມືອງ ດາວິດ, ເບີນ ມານະ ແກີດ ໂອນ ຈ່ອຍ ອາມົ່ງ ເຍືາ. ອັນ ກັອຍ ລາ ກຣີດ, ອັນ ລາ ອຶນເຈົາ ໄຮ. ");
INSERT INTO ncq_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ໄນ່ ລາ ໂອນ ເຍືາ ດັງ: ເຍືາ ເບີນ ຣາມົຮ ກອນ ເຊົາໆ ເນົ່າ ອາກວາມ ໂຈະ ອາຣິ. ເນົ່າ ອາບິ ຕຶ່ງ ຕາປ່ອງ ບັດ.\" ");
INSERT INTO ncq_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ບັອງ ກາ ກັອຍ ແຕິ່ ເບີນ ກຼຶ່ງ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ແອີດ ມັນຕຸ ກະ ເທວາດາ ອຶນໂຍ່ງ ກັອຍ. ອຶນແຍ່ະ ໄລ່ ຍ່ອງ ເຢືາງ ເຈົາຣາຊີ ກະ ໄລ່ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","\"ແຊອ໌ ໂອນ ອຳນາດ ອາງອື່ຣ ແອີດ ກະ ເຢືາງ ເຈົາຣາຊີ ຕຶ່ງ ມັນລັ່ອງ ກາ ປື່ດ ກາເລີຍ ອຶນແຍ່ະ ແຕ ການໍ່ອ໌, ໂອນ ແຕີ່ອ໌ ອຽນ ອໍ ປໍ ກວາຍ ກາ ແອີດ ມັນຕັ່ດ ອໍ ຕຶ່ງ ກູແຕອ໌ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ພໍກາ ອຶນແຍ່ະ ມັຮ ເທວາດາ ກັອຍ ລັ່ອຮ ແຕ ກວາຍ ກຍາອ໌ ແກະ, ໄລ່ ເຈົາ ລັ່ຮ ປໍ ມັນລັ່ອງ. ກວາຍ ກຍາອ໌ ແກະ ມານະ ປັຣຕຶ່ ມານະ ປາຍ: \"ໄຮ ເປາະ ປໍ ເມືອງ ເບັດເລເຮັມ. ໄຮ ເຮີມ ຣານະ ກາ ແຕີ່ອ໌ ມັຮ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ໄຮ.\" ");
INSERT INTO ncq_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ໄລ່ ກັອຍ ເປາະ ໄວ່ ລາລື່. ໄລ່ ຣາມົຮ ມາຣີ ກະ ໂຢເຊັບ ກະ ໄລ່ ເຮີມ ກອນ ແກດ ກັອຍ, ເນົ່າ ອາບິ ຕຶ່ງ ຕາປ່ອງ ບັດ. ");
INSERT INTO ncq_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ແວັດ ໄລ່ ເຮີມ, ໄລ່ ເປາະ ອາຕີ ປໍ ໄນ່ ປໍ ກັອຍ. ໄລ່ ອາຕີ ລັ່ຮ ໂອນ ກວາຍ ການໍ່ອ໌ ດັງ ມັຮ ປັຣນາຍ ໄລ່ ຊັອງ ແຕ ກັຣແນນ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ອຶນແຍ່ະ ກວາຍ ກາ ຊາງັດ ປັຣນາຍ ມູ່ ກາ ກຍາອ໌ ແກະ ອາຕີ, ໄລ່ ຊັອງ ງຶ່ດ ລາລື່ ແຕ ຣານະ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ມາ ມາຣີ ເຈີ ດໍອ໌ ຕຶ່ງ ຣາງຶ່ຮ ອັນ ອຶນແຍ່ະ ມັຮ ຣານະ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ເຈີ່ ກວາຍ ກຍາອ໌ ແກະ, ບັອງ ກາ ໄລ່ ເຈົາ, ໄລ່ ຢຳນັ່ບ ກະ ຍ່ອງ ລາລື່ ເຢືາງ ເຈົາຣາຊີ, ຍ່ອນ ໄລ່ ເຮີມ ຣານະ ໄນ່ ນ່ະ ເນົ່າ ອາຕີ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ນັ່ບ ແຕ ຕາໄງ ກັຣແນນ ກັອຍ ແກີດ ເບີນ ຕາກ່ອລ ຕາໄງ, ໄລ່ ຕະ ຣີ່ດ ກິດ ໂອນ ກອນ ໄລ່ ປວາຍ ຄານອດ ອິດຊະຣາເອລ. ຕາໄງ ກັອຍ ໄລ່ ຈົຮ ຣາມຶ່ຮ ກອນ ກັອຍ ລາ ເຢຊູ. ໄລ່ ອີດ ຣາມຶ່ຮ ນ່ະ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ໄລ່ ແຕ ຕາໄງ ມາຣີ ຕາ ຢວາຮ ແອີດ ຕຶ່ງ ຈະ. ");
INSERT INTO ncq_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ແວັດ ກັອຍ ໂຢເຊັບ ກະ ມາຣີ ປວາຍ ຣີ່ດ ຕະ ບຣັຮ ຈະ ນ່ະ ຄານອດ ໂມເຊ ອາຕີ. ໄລ່ ເດີງ ກອນ ໄລ່ ເປາະ ປໍ ເມືອງ ເຢຣູຊາເລັມ ຊາງ ມ່ອບ ກອນ ໄລ່ ໂອນ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ຍ່ອນ ຄານອດ ເຢືາງ ເຈົາຣາຊີ ປາຕັບ ກວາຍ ອິດຊະຣາເອລ ແຕ ອຶມແບິ ປາຍ: \"ກູ່ ນະ ກອນ ຣາເລົາ ກັ່ລ ອຶງເຄາະ ມ່ອບ ຊາງ ໂອນ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ກະ ໄລ່ ຢໍອ໌ ອີ ມ່ອບ ເຕ່ ເກຣີ່ງ ຊາງ ໂອນ ເຢືາງ ເຈົາຣາຊີ, ຍ່ອນ ຄານອດ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ກວາຍ ອິດຊະຣາເອລ ປາຍ: \"ແວັດ ມັນແຊມ ແອີດ ອູ່ຍຮ ອຶງເຄາະ ອັນ ເດີງ ປໍ ດຸງ ຊາງ ມວຍ ກູ່ ແຈມ ປາເຣືາດ ແຕີລາ ບາຣ ລໍາ ແຈມ ຕາປັຣ ກອນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ເບີນ ມານະ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ ຣາມຶ່ຮ ຊີເມໂອນ. ອັນ ລາ ກວາຍ ຕະ ຣານະ ອໍ, ກະ ອັນ ຊາງັດ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ກຣັ່ກ ລາລື່. ອັນ ອຶງກ່ອງ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ຣຽຮ ມານະ ດໍອ໌ ຈ່ອຍ ອາມົ່ງ ກວາຍ ອິດຊະຣາເອລ. ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ແອີດ ກະ ຊີເມໂອນ. ");
INSERT INTO ncq_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ກະ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ອັນ ປາຍ ອັນ ຕາ ຢວາຮ ກູຈີດ ເຕົ່າ ອັນ ເບີນ ເຮີມ ມານະ ກຣີດ, ອັນ ກາ ເຢືາງ ເຈົາຣາຊີ ຣຽຮ ດໍອ໌ ຈ່ອຍ ອາມົ່ງ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ຕາໄງ ກັອຍ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ເດີງ ຊີເມໂອນ ມູ່ດ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ. ບັອງ ກາ ກັອຍ ອຶມເປ່ອ໌ ອຶມປໍ່ ເຢຊູ ເດີງ ກອນ ໄລ່ ມູ່ດ ດຸງ ຊາງ ປື່ດ ຢໍອ໌ ອີ ປວາຍ ຄານອດ ອິດຊະຣາເອລ. ");
INSERT INTO ncq_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ນ່ະກັອຍ ຊີເມໂອນ ອີດ ກາອື່ ກັຣແນນ ກັອຍ, ກະ ອັນ ຊາແອີນ ເຢືາງ ເຈົາຣາຊີ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","\"ເຢືາງ ເຈົາຣາຊີ ເອີຍ! ແຕີ່ອ໌ ເຈີ່ ຣານະ ເຍືາ ເອີອ໌ ກະ ເກົາ. ຊານໍ່ ຄັນ ເຍືາ ໂອນ ເກົາ ກາ ຕະ ຣານະ ເຍືາ ກູຈີດ, ເກົາ ຊັອງ ອຽນ ອໍ ລາລື່, ");
INSERT INTO ncq_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ຍ່ອນ ມັ່ດ ເກົາ ເຮີມ ອັນ ກາ ເຍືາ ຣຽຮ ໂອນ ຈ່ອຍ ອາມົ່ງ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ຣານະ ໄນ່ ເຍືາ ກຽມ ດໍອ໌ ຢັ່ຮ ເມືາງ ອຶນແຍ່ະ ກູ່ ນະ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ອັນ ລາ ນ່ະ ອາຣ່ຳ ປາເລືາງ ຣານາ ໂອນ ກວາຍ ຕາ ແກີນ ກວາຍ ອິດຊະຣາເອລ. ຍ່ອນ ແຕ ອັນ, ເບີນ ເນົ່າ ຢຳນັ່ບ ກວາຍ ອິດຊະຣາເອລ.\" ");
INSERT INTO ncq_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ອຶມເປ່ອ໌ ອຶມປໍ່ ເຢຊູ ຊັອງ ງຶ່ດ ລາລື່ ປັຣນາຍ ຊີເມໂອນ ປາຍ ແຕ ກອນ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ຊີເມໂອນ ເກົາແຊອ໌ ໂອນ ໄລ່ ເບີນ ບຸ່ນ, ກະ ອັນ ອາຕີ ມາຣີ, ອຶມເປ່ອ໌ ເຢຊູ, ປາຍ: \"ໄມ່ ເນ່ ໄນ່, ເຢືາງ ເຈົາຣາຊີ ຣຽຮ ດໍອ໌ ກອນ ໄມ່ ຕະ ໂອນ ກຼຶ່ງ ກວາຍ ອິດຊະຣາເອລ ເຕ່ອ໌ ຢວຣ ຍ່ອນ ອັນ, ກະ ໂອນ ກຼຶ່ງ ກວາຍ ອິດຊະຣາເອລ ການໍ່ອ໌ ແດິມ ລາ ຍ່ອນ ແຕ ອັນ ເຕ່. ກະ ອັນ ອີ ອາປັຮ ຣານະ ເຢືາງ ເຈົາຣາຊີ ໂອນ ກວາຍ ດັງ. ມາ ໄລ່ ກາແລີຍຮ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ນ່ະກັອຍ ມັຮ ຣາມຶ່ຮ ກາ ກວາຍ ຄຶ່ດ ປາໂຕ່ະ ຕຶ່ງ ຣາງຶ່ຮ ໄລ່, ມັຮ ຣາມຶ່ຮ ກັອຍ ແກີດ ອຶມປັຮ ອຶນແຍ່ະ. ກະ ປັຣແນີ ມັນເຕຣືາ ໄມ່ ເບີນ ຣາມຶ່ຮ ຕຸ່ຮ ກັ່ດ ແຕີ່ອ໌ ປໍ ໄມ່ ນ່ະ ປຼາ ຮໍອ໌ ຈັ່ດ ຕຶ່ງ ມິ່ດ ປາແຮີມ ໄມ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ເບີນ ມານະ ອາຢ່ະ ເທົາ ແອີດ ປໍ ກັອຍ ຣາມຶ່ຮ ອານາ, ກອນ ພານູເອລ, ມູ່ ອາເຊຣ. ອັນ ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ. ແຕ ອຶນໂຍ່ງ ອັນ ເບີນ ກາຢາອ໌ ອຶນແຍ່ະ ຕາປູ່ລ ກູມໍ. ");
INSERT INTO ncq_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ແວັດ ກັອຍ ອັນ ແອີດ ກູມາຍ ເຕົ່າ ແຕີ່ອ໌ ອາຍຸ່ ອັນ ຕາກ່ອລ ຈິ່ດ ລາ ປູນ ກູມໍ. ອັນ ຕາ ເກີ່ຍ ລັ່ອຮ ແຕ ດຸງ ຊາງ ປື່ດ. ຕາໄງ ກະ ຊາເດົາ ອັນ ແອີດ ຊາງ ເຢືາງ ເຈົາຣາຊີ. ແຕີ່ອ໌ ອັນ ເກົາແຊອ໌, ອັນ ອົດ ຕາ ເບີນ ຈາ ຊັຣນາ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ບັອງ ກາ ກັອຍ ແຕິ່ ອາຢ່ະ ໄນ່ ມູ່ດ ປໍ ອຶນຕຸ ອຶມເປ່ອ໌ ອຶມປໍ່ ເຢຊູ ແອີດ. ອັນ ຊາແອີນ ເຢືາງ ເຈົາຣາຊີ. ກະ ອັນ ອາຕີ ແຕ ກັຣແນນ ໄນ່ ໂຈະ ອຶນແຍ່ະ ໄລ່ ກາ ອຶງກ່ອງ ມານະ ກາ ເຢືາງ ເຈົາຣາຊີ ຣຽຮ ໂອນ ອາກຼັຮ ເມືອງ ເຢຣູຊາເລັມ. ");
INSERT INTO ncq_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ແວັດ ອຶມເປ່ອ໌ ອຶມປໍ່ ເຢຊູ ຕະ ອຶນແຍ່ະ ມັຮ ຣີ່ດ ປວາຍ ຄານອດ ເຢືາງ ເຈົາຣາຊີ ປາຕັບ ກວາຍ ອິດຊະຣາເອລ, ໄລ່ ເຈົາ ລັ່ຮ ປໍ ດຸງ ໄລ່ ປໍ ວີ່ລ ນາຊາເຣັດ, ແຄງ ຄາລີເລ. ");
INSERT INTO ncq_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ເຢຊູ ປື່ດ ອາຊັອຮ ແກີດ ບັນ ເຣ່ງ. ອັນ ດັງ ຊາອຶ່ຍ ກະ ເຢືາງ ເຈົາຣາຊີ ຊັອງ ຣໍ່ອ໌ ລາລື່ ກະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ກູ່ ກູມໍ ອຶມເປ່ອ໌ ອຶມປໍ່ ເຢຊູ ເປາະ ປໍ ເມືອງ ເຢຣູຊາເລັມ ຈາ ຣໍ່ອ໌ ຊາແຍີ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ອາກຼັຮ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ແຕີ່ອ໌ ເຢຊູ ເບີນ ມວຍ ຈິ່ດ ລາ ບາຣ ກູມໍ, ໄລ່ ເປາະ ລັ່ຮ ປວາຍ ຣີ່ດ ຈາ ຣໍ່ອ໌ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ. ");
INSERT INTO ncq_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ແວັດ ຕາໄງ ຈາ ຣໍ່ອ໌, ໄລ່ ເຈົາ ລັ່ຮ ປໍ ດຸງ. ມາ ເຢຊູ ອຶນນັ່ອງ ແອີດ ລັ່ຮ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ. ອຶມເປ່ອ໌ ອຶມປໍ່ ອັນ ຕາ ເບີນ ດັງ ເຢຊູ ແອີດ ລັ່ຮ ຊາ. ");
INSERT INTO ncq_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ໄລ່ ຄຶ່ດ ເຢຊູ ເຈົາ ເຕ່ ກະ ເຢົ່າ ກາ ເປາະ ມັນຕຸ. ນ່ະກັອຍ ໄລ່ ເປາະ ອຶນແຍ່ະ ມວຍ ຕາໄງ. ແຕີ່ອ໌ ຊາເດົາ ໄລ່ ຈໍ່ອ໌ ຕາແບີບ ແຊມອາຍ ກະ ເຢົ່າ ການໍ່ອ໌ ຕຶ່ງ ວີ່ລ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ມາ ໄລ່ ຕາ ເບີນ ຣາມົຮ ເຢຊູ. ນ່ະກັອຍ ໄລ່ ລົ່ບ ລັ່ຮ ປໍ ເມືອງ ເຢຣູຊາເລັມ, ຈໍ່ອ໌ ອັນ ຕຶ່ງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ແວັດ ໄປ ຕາໄງ ໄລ່ ຣາມົຮ ອັນ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ. ອັນ ຕາກູ ມັນຕຸ ກະ ມັຮ ອາຈານ ກາ ອາຕີ ຄານອດ ອິດຊະຣາເອລ. ອັນ ຊາງັດ ກະ ຕາແບີບ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ອຶນແຍ່ະ ໄລ່ ກາ ຊາງັດ ຊັອງ ງຶ່ດ ອັນ ຕາແອີຍ ໄລ່ ແຄວ໌ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ແຕີ່ອ໌ ອຶມເປ່ອ໌ ອຶມປໍ່ ເຢຊູ ເຮີມ ອັນ ປໍ ກັອຍ, ໄລ່ ງຶ່ດ ລາລື່. ອຶມເປ່ອ໌ ອັນ ປາຍ ໂຈະ ອັນ: \"ນານ່ະ ກອນ ຕະ ນ່ະໄນ່ ກະ ຮິ? ອຶມປໍ່ ໄມ່ ກະ ເກົາ ຕັລ ຕວາລ ຈໍ່ອ໌ ໄມ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ນ່ະ ແຕ ເຍືາ ຈໍ່ອ໌ ເກົາ? ນ່ະ ເຍືາ ຕາ ເບີນ ດັງ ເກົາ ອຶງເຄາະ ແອີດ ຕຶ່ງ ດຸງ ອຶມປໍ່ ເກົາ?\" ");
INSERT INTO ncq_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ມາ ໄລ່ ຕາ ເບີນ ດັງ ປັຣນາຍ ກອນ ໄລ່ ປາຍ. ");
INSERT INTO ncq_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ເຢຊູ ເຈົາ ກະ ອຶມເປ່ອ໌ ອຶມປໍ່ ອັນ ປໍ ວີ່ລ ນາຊາເຣັດ. ກະ ອັນ ຊາງັດ ອຶນແຍ່ະ ປັຣນາຍ ອຶມເປ່ອ໌ ອຶມປໍ່ ອັນ. ມາ ອຶມເປ່ອ໌ ອັນ ເຈີ ດໍອ໌ ຕຶ່ງ ຣາງຶ່ຮ ອຶນແຍ່ະ ມັຮ ຣາມຶ່ຮ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ພໍກາ ເຢຊູ ປື່ດ ອາຊັອຮ, ອັນ ແກີດ ດັງ ຊາອຶ່ຍ ອາຊັອຮ ແອັນ. ເຢືາງ ເຈົາຣາຊີ ກະ ມັຮ ກວາຍ ອາໂຢ່ະ ກະ ຊັອງ ຣໍ່ອ໌ ລາລື່ ກະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ບັອງ ກາ ກັອຍ ກວາຍ ຣາມຶ່ຮ ຕີເບຣີໂອ ແກີດ ເຕືາວ ປັຣເຍືາ ໂຣມ ກາ ກຣິ່ຮ ຕະ ຊົດ ມວຍ ຈິ່ດ ລາ ເຊີງ ກູມໍ ເຈີ່. ປົນທຽວ ປີລາດ ຕະ ຊົດ ເຕ່ດ ເນືາຍ ຕີເບຣີໂອ ຕຶ່ງ ແຄງ ຢູດາຍ; ກະ ເຮໂຣດ ຕະ ຊົດ ຕຶ່ງ ແຄງ ຄາລີເລ. ພີລິບ, ອາແອມ ເຮໂຣດ, ຕະ ຊົດ ຕຶ່ງ ກຣວາງ ອີຕູຣາຍ ກະ ກຣວາງ ທາໂຄນິດ; ກະ ລີຊາເນຍ ຕະ ຊົດ ຕຶ່ງ ແຄງ ອາບີເລັນ. ");
INSERT INTO ncq_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ອັນນາ ກະ ກາຢະພາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ. ບັອງ ກາ ກັອຍ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕີ່ອ໌ ປໍ ໂຢຮັນ, ກອນ ເຊກາຣີຢາ, ແອີດ ຕຶ່ງ ຕຍາຮ. ");
INSERT INTO ncq_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ໂຢຮັນ ເປາະ ຕະ ອຶນຕີ ອຶນແຍ່ະ ຕຶ່ງ ກຣວາງ ອຶມແປຣ ຕາເລ່ ຈໍແດນ ປາຍ: \"ໂອນ ເຍືາ ຕັຮ ຣາງຶ່ຮ ຕຍາ ກະ ຣັ່ບ ຣີ່ດ ຕຶ່ງ ແດີອ໌, ໄນ່ ລາ ຕະ ໂອນ ເນົ່າ ດັງ ປາຍ ເຍືາ ປຽນ ອີດ ຣາງຶ່ຮ ຕາໄມ ແອັນ, ໂອນ ເຢືາງ ເຈົາຣາຊີ ຕັຮ ໂລ່ຍຮ ເຍືາ.\" ");
INSERT INTO ncq_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ອັນ ຕະ ມູເຈິງ ເອຊາຢາ, ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ຄຽນ ແຕ ອຶມແບິ: \"ເບີນ ຊຽງ ຊາບາວ ອາຕີ ເຣ່ງ ລາລື່ ແຕ ຕຍາຮ. ອັນ ຊາບາວ ປາຍ: 'ເຍືາ ອຶງເຄາະ ອາຕຶ່ ຣານາ ໂອນ ອຶນເຈົາ ໄຮ. ຈັຮ ໂອນ ຕານັ່ອງ ຣານາ ອັນ ອີ ເປາະ. ");
INSERT INTO ncq_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ມັຮ ປຣຸ່ງ ຕຶ່ງ ຣານາ, ອຶງເຄາະ ກູບິລ ໂອນ ປັ່ນ. ກະ ອຶນແຍ່ະ ກົຮ ອຶນແຍ່ະ ແລັ່ຮ ອຶງເຄາະ ຕະ ໂອນ ເປືາຣ. ມັຮ ຣານາ ໂກ່ະ, ອຶງເຄາະ ຈັຮ ໂອນ ຕານັ່ອງ. ກະ ມັຮ ຣານາ ຣາຮຸ ຣາໂດຍຮ, ອຶງເຄາະ ປວນ ໂອນ ລີ່ ລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ນ່ະກັອຍ, ກູ່ ນະ ກວາຍ ເຕ່ອ໌ ເຮີມ ກະ ດັງ ເຢືາງ ເຈົາຣາຊີ ຈ່ອຍ ອາມົ່ງ ກວາຍ!'\" ");
INSERT INTO ncq_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ເບີນ ກຼຶ່ງ ກວາຍ ແຕີ່ອ໌ ປໍ ໂຢຮັນ ຢໍອ໌ ອັນ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ໄລ່. ອັນ ປາຍ ໂຈະ ໄລ່ ກັອຍ: \"ເຍືາ ລາ ນ່ະ ກູຊັນ ຕູ່ຣ. ເນົ່າ ກາ ອາຕີ ເຍືາ ໂອນ ແວັດ ແຕ ເຢືາງ ເຈົາຣາຊີ ຕະ ເຍືາ, ແຕີ່ອ໌ ອັນ ຕະ ກວາຍ ໂລ່ຍຮ ຕຶ່ງ ຕາໄງ ປັຣຊົດ. ");
INSERT INTO ncq_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ອຶງເຄາະ ເຍືາ ຕະ ຣານະ ອໍ, ໂອນ ແກີດ ປາໄລ ເຕ່ອ໌ ອາປັຮ ໂອນ ເນົ່າ ດັງ ປາຍ ເຍືາ ຕັຮ ຣາງຶ່ຮ ຕຍາ ປຽນ ແກີດ ຣາງຶ່ຮ ຕາໄມ ແອັນ. ເຍືາ ອຶນໂຈຍ ຄຶ່ດ ປາຍ ເຍືາ ເຕ່ອ໌ ວຍາຣ ແວັດ ໂຕ່ດ, ຍ່ອນ ເຍືາ ປາຍ: 'ອັບຣາຮາມ ລາ ອາຈວາຍຮ ອາເຈ່ຮ ຮິ.' ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ຄັນ ເຢືາງ ເຈົາຣາຊີ ຢໍອ໌, ເຕ່ອ໌ ອັນ ອີດ ຕາເມົາ, ແຕງ ແກີດ ຈຸ່ມເຈືອ ອັບຣາຮາມ ແຕ ຕາເມົາ ກັອຍ! ");
INSERT INTO ncq_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ຊານໍ່ ຊາກຳ ເບີນ ຈວາງ ປຼາ ດໍອ໌ ແຈ່ະ ກັ່ລ ອາລ່ອງ. ກັ່ລ ອາແລ່ະ ມາ ຕາ ເບີນ ແກີດ ປາໄລ ອໍ, ເນົ່າ ຕາມື່່, ແກຼງ ຕັຮ ຕຶ່ງ ອູ່ຍຮ.\" ");
INSERT INTO ncq_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ມັຮ ກວາຍ ກັອຍ ຕາແບີບ ໂຢຮັນ ປາຍ: \"ຄັນ ນ່ະກັອຍ, ນານ່ະ ຮິ ອີ ຕະ?\" ");
INSERT INTO ncq_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ໂຢຮັນ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ອາແລ່ະ ກາ ເບີນ ບາຣ ປຼັ່ຮ ອາຢັ່ອຮ, ອຶງເຄາະ ອັນ ໂອນ ກວາຍ ກາ ແອິ ອາຢັ່ອຮ ແຊິບ. ກະ ອາແລ່ະ ກາ ເບີນ ເກຣີ່ງ ຊັຣນາ ຈາ, ອຶງເຄາະ ອັນ ຕະ ມູເຈິງ ກັອຍ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ເບີນ ກວາຍ ກາ ປາໂຣມ ປຣະ ປາຊີ ແຕີ່ອ໌ ປໍ ໂຢຮັນ ຢໍອ໌ ອັນ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ໄລ່. ໄລ່ ກັອຍ ຕາແບີບ ປາຍ: \"ອາຈານ ເອີຍ! ຮິ ອຶງເຄາະ ຕະ ນານ່ະ?\" ");
INSERT INTO ncq_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ໂຢຮັນ ອາຕີ ລັ່ຮ ໄລ່ ປາຍ: \"ເຍືາ ອຶນໂຈຍ ອີດ ປຣະ ປາຊີ ກາເລີຍ ແຕ ເນົ່າ ໂອນ ເຍືາ ອີດ.\" ");
INSERT INTO ncq_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ກະ ກວາຍ ຕາຮານ, ໄລ່ ຕາແບີບ ເຕ່: \"ມາ ຮິ, ອຶງເຄາະ ຮິ ຕະ ນານ່ະ?\" ໂຢຮັນ ອາຕີ ລັ່ຮ ໄລ່ ປາຍ: \"ເຍືາ ອຶນໂຈຍ ໂລ່ບ ກວາຍ, ກະ ອຶນໂຈຍ ຕູນ ອາແປັດ ກວາຍ ການໍ່ອ໌. ກະ ເຍືາ ອຶນໂຈຍ ຄຶ່ດ ອີ ເບີນ ປຣະ ກາເລີຍ ແຕ ປຣະ ກາໄຊ ເຍືາ.\" ");
INSERT INTO ncq_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ກວາຍ ກຼຶ່ງ ກັອຍ ຊັອງ ມັຮ ປັຣນາຍ ໂຢຮັນ ອາຕີ, ກະ ໄລ່ ແອີດ ອຶງກ່ອງ ຄຶ່ດ ຕຶ່ງ ຣາງຶ່ຮ ໄລ່, ຕາ ດັງ ໂຢຮັນ ລາ ເມ່ນ ກຣີດ ມາ ຕາ ເບີນ. ");
INSERT INTO ncq_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ນ່ະກັອຍ ໂຢຮັນ ອາຕີ ໂຈະ ໄລ່ ປາຍ: \"ເກົາ ຕະ ຣີ່ດ ໄນ່ ໂອນ ເຍືາ ຕຶ່ງ ແດີອ໌. ມາ ອັນ ກາ ແຕີ່ອ໌ ອຶນຕູ່ນ ເກົາ, ອັນ ກັອຍ ຊົດ ກາເລີຍ ແຕ ເກົາ. ເກົາ ລາ ຕາ ເບີນ ປຍາຍ໌ ອາແລັ່ຮ ອຶນໄຊ ແກີບ ແຕ ອາເຢີງ ອັນ, ຍ່ອນ ອຳນາດ ເກົາ ລາ ແກດ ກາເລີຍ ແຕ ອັນ. ອັນ ອີ ຕະ ຣີ່ດ ໄນ່ ໂອນ ເຍືາ ເບີນ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ກະ ອູ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ອາຕີ ອັນ ຢຸມ ຕາວີ່ງ ດໍອ໌ ອູມ ອຶນແຍ່ະ ມັຮ ທຣໍ. ອາແລ່ະ ກາ ຈອງ, ອັນ ດໍອ໌ ຕຶ່ງ ຊູ. ອາແລ່ະ ກາ ຊາກາມ, ອັນ ອາປັອງ ຕັຮ ຕຶ່ງ ອູ່ຍຮ ກາ ຕາ ເກີ່ຍ ປັດ.\" ");
INSERT INTO ncq_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ໂຢຮັນ ອາຕີ ຊາອຶ່ຍ ປັຣນາຍ ການໍ່ອ໌ ແຮີ ໂອນ ກວາຍ ກັອຍ ດັງ ປັຣນາຍ ອໍ ແຕ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ມາ ໂຢຮັນ ຕິ ເຕືາວ ປັຣເຍືາ ເຮໂຣດ, ຍ່ອນ ອັນ ອີດ ເຮໂຣເດຍ, ລາກວຍ ອາແອມ ອັນ, ກະ ຍ່ອນ ອັນ ຕະ ຊາອຶ່ຍ ຣານະ ຕາ ອໍ ການໍ່ອ໌ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ແວັດ ກັອຍ ອັນ ຕະ ຣານະ ຕາ ອໍ ຊາອຶ່ຍ ອາຊັອຮ ແອັນ, ເຈີ່ ອັນ ໂຈະ ໂຢຮັນ ຕຶ່ງ ກໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ເບີນ ມວຍ ຕາໄງ ແອັນ ໂຢຮັນ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ມັຮ ກວາຍ ກັອຍ, ກະ ອັນ ຕະ ໂອນ ເຢຊູ ແຮີ. ພໍກາ ເຢຊູ ເກົາແຊອ໌, ມັນລັ່ອງ ແກີດ ນ່ະ ເນົ່າ ເປິຮ, ");
INSERT INTO ncq_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ກະ ເບີນ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ແຊງ ແຕ ມັນລັ່ອງ ນ່ະ ແຈມ ປາເຣືາດ, ປົກ ຕຶ່ງ ຈະ ເຢຊູ. ກະ ເບີນ ຊຽງ ເຢືາງ ເຈົາຣາຊີ ຊາບາວ ອາຕີ ແຕ ມັນລັ່ອງ ປາຍ: \"ໄມ່ ລາ ກອນ ເກົາ, ອັນ ກາ ເກົາ ອາໂຢ່ະ ລາລື່. ອຶນເຕົ່າ ໄມ່ ຕະ, ເກົາ ຣໍ່ອ໌ ລາລື່.\" ");
INSERT INTO ncq_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ບັອງ ກາ ເຢຊູ ຕາແບິ ຕະ ຣານະ ອັນ, ອັນ ເບີນ ມາຮ ໄປ ຈິ່ດ ກູມໍ. ປວາຍ ນ່ະ ຣາງຶ່ຮ ກວາຍ ຄຶ່ດ, ເຢຊູ ລາ ກອນ ໂຢເຊັບ. ກະ ໂຢເຊັບ ລາ ກອນ ເຮລີ. ");
INSERT INTO ncq_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ເຮລີ ລາ ກອນ ມັດທາດ. ມັດທາດ ລາ ກອນ ເລວີ. ເລວີ ລາ ກອນ ເມລະຄີ. ເມລະຄີ ລາ ກອນ ຢັນນາ. ຢັນນາ ລາ ກອນ ໂຢເຊັບ. ");
INSERT INTO ncq_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ໂຢເຊັບ ລາ ກອນ ມັດຕາເທຍ. ມັດຕາເທຍ ລາ ກອນ ອາໂມ. ອາໂມ ລາ ກອນ ນາຮູມ. ນາຮູມ ລາ ກອນ ເອຊະລີ. ເອຊະລີ ລາ ກອນ ນາຄາຍ. ");
INSERT INTO ncq_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ນາຄາຍ ລາ ກອນ ມາອາດ. ມາອາດ ລາ ກອນ ມັດຕາເທຍ. ມັດຕາເທຍ ລາ ກອນ ເຊເມອີນ. ເຊເມອີນ ລາ ກອນ ໂຢເຊັກ. ໂຢເຊັກ ລາ ກອນ ໂຢດາ. ");
INSERT INTO ncq_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ໂຢດາ ລາ ກອນ ໂຢຮານັນ. ໂຢຮານັນ ລາ ກອນ ເຣຊາ. ເຣຊາ ລາ ກອນ ເຊຣຸບບາເບລ. ເຊຣຸບບາເບລ ລາ ກອນ ເຊອານຕີເອລ. ເຊອານຕີເອລ ລາ ກອນ ເນຣີ. ");
INSERT INTO ncq_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ເນຣີ ລາ ກອນ ເມລະຄີ. ເມລະຄີ ລາ ກອນ ອັດດີ. ອັດດີ ລາ ກອນ ໂກຊາມ. ໂກຊາມ ລາ ກອນ ເອັລມາດາມ. ເອັລມາດາມ ລາ ກອນ ເອຣະ. ");
INSERT INTO ncq_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ເອຣະ ລາ ກອນ ໂຢຊວຍ. ໂຢຊວຍ ລາ ກອນ ເອລີເອເຊ. ເອລີເອເຊ ລາ ກອນ ໂຢຣີມ. ໂຢຣີມ ລາ ກອນ ມັດທາດ. ມັດທາດ ລາ ກອນ ເລວີ. ");
INSERT INTO ncq_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ເລວີ ລາ ກອນ ຊີເມໂອນ. ຊີເມໂອນ ລາ ກອນ ຢູດາ. ຢູດາ ລາ ກອນ ໂຢເຊັບ. ໂຢເຊັບ ລາ ກອນ ໂຢນາມ. ໂຢນາມ ລາ ກອນ ເອລີອາກິມ. ເອລີອາກິມ ລາ ກອນ ເມເລອາ. ");
INSERT INTO ncq_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ເມເລອາ ລາ ກອນ ເມັນນາ. ເມັນນາ ລາ ກອນ ມັດຕາທາ. ມັດຕາທາ ລາ ກອນ ນາທານ. ນາທານ ລາ ກອນ ດາວິດ. ");
INSERT INTO ncq_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ດາວິດ ລາ ກອນ ເຢຊີ. ເຢຊີ ລາ ກອນ ໂອເບັດ. ໂອເບັດ ລາ ກອນ ໂບອາດ. ໂບອາດ ລາ ກອນ ຊັລໂມນ. ຊັລໂມນ ລາ ກອນ ນາໂຊນ. ນາໂຊນ ລາ ກອນ ອຳມີນາດາບ. ");
INSERT INTO ncq_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ອຳມີນາດາບ ລາ ກອນ ອັດມີນ. ອັດມີນ ລາ ກອນ ອານີ. ອານີ ລາ ກອນ ເຮຊະໂຣນ. ເຮຊະໂຣນ ລາ ກອນ ເປເຣັດ. ເປເຣັດ ລາ ກອນ ຢູດາ. ");
INSERT INTO ncq_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ຢູດາ ລາ ກອນ ຢາໂຄບ. ຢາໂຄບ ລາ ກອນ ອີຊາກ. ອີຊາກ ລາ ກອນ ອັບຣາຮາມ. ອັບຣາຮາມ ລາ ກອນ ເຕຣາ. ເຕຣາ ລາ ກອນ ນາໂຮ. ");
INSERT INTO ncq_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ນາໂຮ ລາ ກອນ ເຊຣຸກ. ເຊຣຸກ ລາ ກອນ ເຣອູ. ເຣອູ ລາ ກອນ ເປເລັກ. ເປເລັກ ລາ ກອນ ເອເບີຣ. ເອເບີຣ ລາ ກອນ ເຊລາ. ");
INSERT INTO ncq_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ເຊລາ ລາ ກອນ ກາຍນານ. ກາຍນານ ລາ ກອນ ອາຣປັກຊາດ. ອາຣປັກຊາດ ລາ ກອນ ເຊມ. ເຊມ ລາ ກອນ ໂນອາ. ໂນອາ ລາ ກອນ ລາເມັກ. ");
INSERT INTO ncq_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ລາເມັກ ລາ ກອນ ມາທຸເຊລາ. ມາທຸເຊລາ ລາ ກອນ ເອນົກ. ເອນົກ ລາ ກອນ ຢາເຣັດ. ຢາເຣັດ ລາ ກອນ ມະຮາລາເລລ. ມະຮາລາເລລ ລາ ກອນ ເກນານ. ");
INSERT INTO ncq_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ເກນານ ລາ ກອນ ເອໂນດ. ເອໂນດ ລາ ກອນ ເຊດ. ເຊດ ລາ ກອນ ອາດາມ. ກະ ອາດາມ ລາ ກອນ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ພໍກາ ເຢຊູ ເຈົາ ແຕ ຕາເລ່ ຈໍແດນ, ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ຕຶ່ງ ຣາງຶ່ຮ ອັນ. ຣາເວືາຍ ກັອຍ ເດີງ ອັນ ເປາະ ປໍ ຕຍາຮ. ");
INSERT INTO ncq_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ນ່ະກັອຍ ເຢືາງ ຊາຕານ, ອັນ ກາ ຊົດ ອຶນແຍ່ະ ເຢືາງ ຕາ ອໍ, ລ່ອງ ເຢຊູ ອຶນແຍ່ະ ປູນ ຈິ່ດ ຕາໄງ ປູນ ຈິ່ດ ຊາເດົາ ຢໍອ໌ ອີ ເດີງ ອັນ ຕະ ໂລ່ຍຮ. ອຶນແຍ່ະ ມັຮ ຕາໄງ ກັອຍ ເຢຊູ ຕາ ເບີນ ຈາ ອຶນເຕົ່າ. ນ່ະກັອຍ ແວັດ ມັຮ ຕາໄງ ກັອຍ, ອັນ ຊັອງ ມາເຍືາຍຮ. ");
INSERT INTO ncq_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ເຢືາງ ຊາຕານ ປາຍ ໂຈະ ເຢຊູ: \"ຄັນ ໄມ່ ກອນ ເຢືາງ ເຈົາຣາຊີ, ເອົາ ໄມ່ ຕະ ໂອນ ຕາເມົາ ໄນ່ ແກີດ ຊັຣນາ ຈາ.\" ");
INSERT INTO ncq_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ມາ ເຢຊູ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ຄຽນ ປາຍ: 'ກວາຍ ຕາ ເບີນ ອາມົ່ງ ແຕ ແອີງ ຊັຣນາ ຈາ ຊັອງ.'\" ");
INSERT INTO ncq_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ເຈີ່ ເຢືາງ ຊາຕານ ເດີງ ເຢຊູ ຊັອຮ ຕຶ່ງ ກົຮ. ອັນ ອາປັຮ ໂອນ ເຢຊູ ເຮີມ ມູ ກັຣແບັຮ ມັ່ດ ມັຮ ກຣວາງ ຕຶ່ງ ກູແຕອ໌ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ເຢືາງ ຊາຕານ ປາຍ ແອັນ ໂຈະ ເຢຊູ: \"ເກົາ ໂອນ ໄມ່ ຊົດ ອຶນແຍ່ະ ມັຮ ກຣວາງ ໄນ່, ກະ ເກົາ ໂອນ ໄມ່ ເບີນ ມັຮ ອຳນາດ ອາງອື່ຣ, ຍ່ອນ ເນົ່າ ໂອນ ເກົາ ຕະ ຊົດ ອຶນແຍ່ະ ກູ່ ກຣວາງ ໄນ່. ອາແລ່ະ ເກົາ ຢໍອ໌ ອີ ໂອນ, ລາ ເຕ່ອ໌ ເກົາ ໂອນ. ");
INSERT INTO ncq_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ຄັນ ໄມ່ ກຼຸ່ ຣາໂກລ ຊາງ ເກົາ, ເກົາ ມ່ອບ ໂອນ ໄມ່ ຕາລາ ອຶນແຍ່ະ.\" ");
INSERT INTO ncq_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ມາ ເຢຊູ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ຄຽນ ປາຍ: 'ອຶງເຄາະ ເຍືາ ຊາງ ເຢືາງ ເຈົາຣາຊີ ລາ ອຶນເຈົາ ເຍືາ, ກະ ຕະ ຣານະ ໂອນ ມານະ ອັນ ຊັອງ.'\" ");
INSERT INTO ncq_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ເຈີ່ ເຢືາງ ຊາຕານ ເດີງ ເຢຊູ ມູ່ດ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ. ອັນ ໂອນ ເຢຊູ ຕາຢຶ່ງ ຕຶ່ງ ອານວລ ດຸງ ຊາງ ປື່ດ. ກະ ອັນ ປາຍ: \"ຄັນ ໄມ່ ກອນ ເຢືາງ ເຈົາຣາຊີ, ເອົາ ໄມ່ ປັອງ ອາແຊງ, ");
INSERT INTO ncq_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ຍ່ອນ ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ຄຽນ ດໍອ໌ ປາຍ: 'ເຢືາງ ເຈົາຣາຊີ ແປຣີ ເທວາດາ ອັນ ກຍາອ໌ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ໄລ່ ຕາແດີງ ຣັ່ບ ໄມ່ ແຕ ອາຕີ ໄລ່, ໂອນ ຕາ ເບີນ ເບິ ອຶນເຕົ່າ ອາເຢີງ ໄມ່ ແຕ ຕາເມົາ.'\" ");
INSERT INTO ncq_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ມາ ເຢຊູ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ອັນ ປາຍ ເຕ່: 'ເຍືາ ອຶນໂຈຍ ລ່ອງ ເຢືາງ ເຈົາຣາຊີ, ອຶນເຈົາ ເຍືາ.'\" ");
INSERT INTO ncq_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ແວັດ ເຢືາງ ຊາຕານ ລ່ອງ ເຢຊູ ກູ່ ຣານະ, ເຈີ່ ອັນ ລັ່ອຮ ແຕ ເຢຊູ ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ອຶນຕູ່ນ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ເຈີ່ ເຢຊູ ເຈົາ ປໍ ແຄງ ຄາລີເລ ແອັນ ເບີນ ອຳນາດ ແຕ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ. ກະ ກູ່ ອຶນຕຸ ອຶມແປຣ ກັອຍ ເນົ່າ ຊັອງ ຮານ ແຕ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ເຢຊູ ອາຕີ ຕຶ່ງ ດຸງ ຊາງ ກວາຍ ອິດຊະຣາເອລ ຕຶ່ງ ກຣວາງ ກັອຍ, ກະ ກູ່ ນະ ກວາຍ ແອີດ ອຶງກັອຍ ຍ່ອງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ເຈີ່ ເຢຊູ ເປາະ ປໍ ວີ່ລ ນາຊາເຣັດ ແອັນ, ລາ ວີ່ລ ອັນ ແອີດ ແຕ ບັອງ ອັນ ກັຣແນນ. ຕຶ່ງ ຕາໄງ ຣາລູ່ ອັນ ມູ່ດ ຕຶ່ງ ດຸງ ຊາງ ອິດຊະຣາເອລ, ນ່ະ ອັນ ເກີ່ຍ ຕະ ແຕ ອຶນລີ່ງ. ອັນ ຕາຢຶ່ງ ອີ ອານ ແຕ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ຢັ່ຮ ເມືາງ ກວາຍ ກາ ແອີດ ອຶງກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ເບີນ ກວາຍ ອາແວີຍ ໂອນ ອັນ ປຶ່ງ ກາ ເອຊາຢາ, ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ຄຽນ ແຕ ອຶມແບິ. ເຢຊູ ເປິຮ ປຶ່ງ ກັອຍ, ກະ ຣາມົຮ ອຶນຕຸ ເອຊາຢາ ຄຽນ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","\"ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ແອີດ ກະ ເກົາ, ຍ່ອນ ອັນ ໂອນ ເກົາ ເບີນ ອຳນາດ ອາຕີ ປັຣນາຍ ອໍ ແຕ ອັນ ໂອນ ກວາຍ ກາດີດ ດັງ. ອັນ ແປຣີ ເກົາ ເປາະ ອາຕີ ຈ່ອຍ ມັຮ ກວາຍ ກາ ເນົ່າ ໂກບ ດໍອ໌ ຕຶ່ງ ກໍ່ອ໌, ໂອນ ໄລ່ ເຕ່ອ໌ ຣາກຼັຮ; ກະ ມັຮ ກວາຍ ກາ ຊູດ ມັ່ດ, ໂອນ ໄລ່ ແກີດ ບຣາງ ລັ່ຮ. ອັນ ແປຣີ ເກົາ ຈ່ອຍ ກວາຍ ກາ ຈີວ໌ ເນົ່າ ຕະ ຕຸ່ຮ, ກະ ອາໂຣຍຮ ໂອນ ໄລ່ ແມິ່ມ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ກະ ອັນ ໂອນ ເກົາ ຊາບາວ ອາຕີ ອຶນແຍ່ະ ແຕ ກູມໍ ກາ ເຢືາງ ເຈົາຣາຊີ ອາໂຢ່ະ ຕະ ກະ ຈ່ອຍ ອາມົ່ງ ກວາຍ!\" ");
INSERT INTO ncq_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ແວັດ ເຢຊູ ອານ ມັຮ ປັຣນາຍ ກັອຍ, ອັນ ກາແຕິບ ປຶ່ງ ກັອຍ, ອາແວີຍ ລັ່ຮ ໂອນ ກວາຍ ກາ ຕະ ຣານະ ຕຶ່ງ ດຸງ ຊາງ ກັອຍ, ເຈີ່ ຕາກູ. ກູ່ ນະ ກວາຍ ຕຶ່ງ ດຸງ ຊາງ ກັອຍ, ໄລ່ ເນ່ ຊັຣກຼັ່ອງ ປໍ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ອັນ ອາຕີ ໄລ່ ປາຍ: \"ມັຮ ປັຣນາຍ ກາ ເຍືາ ຊັອງ ເກົາ ອານ ແຕ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ປັຣນາຍ ກັອຍ ແກີດ ຣາປຍາຍ໌ ຕຶ່ງ ຕາໄງ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ກູ່ ນະ ໄລ່ ລາ ຕະ ອຶນຕີ ອໍ ແຕ ເຢຊູ, ກະ ໄລ່ ງຶ່ດ ລາລື່ ມັຮ ປັຣນາຍ ອັນ ປາຍ ລາ ລາເມ່ນ ອໍ ລາລື່. ໄລ່ ມານະ ຕາແບີບ ມານະ ປາຍ: \"ກວາຍ ໄນ່ ລາ ກອນ ຣາເລົາ ໂຢເຊັບ, ມາ ຕາ ເບີນ?\" ");
INSERT INTO ncq_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ເຢຊູ ອາຕີ ລັ່ຮ ໂຈະ ໄລ່ ປາຍ: \"ອຶງກັອຮ ເຍືາ ອີດ ປັຣນາຍ ປາຕັບ ອີ ປາຍ ກະ ເກົາ ນ່ະໄນ່: 'ກວາຍ ກາ ເກີ່ຍ ປົວ ອາອີ່ ເອີຍ! ເອົາ ໄມ່ ປົວ ອາອີ່ ຈະ ໄມ່ ເບີມ.' ອຶງກັອຮ ເຍືາ ຄຶ່ດ ຢໍອ໌ ອີ ປາຍ ເກົາ ນ່ະໄນ່: 'ຮິ ຊັອງ ເຈີ່ ແຕ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ໄມ່ ຕະ ຕຶ່ງ ເມືອງ ກາເປນາອູມ. ຊານໍ່ ຮິ ແຊອ໌ ໄມ່ ຕະ ມູເຈິງ ກັອຍ ເຕ່ ຕຶ່ງ ວີ່ລ ໄມ່.'\" ");
INSERT INTO ncq_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ເຢຊູ ອາຕີ ແອັນ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ມັຮ ກວາຍ ແອີດ ຕຶ່ງ ວີ່ລ ກາ ເບີນ ມານະ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ກວາຍ ວີ່ລ ກັອຍ ຕາ ເບີນ ຢຳນັ່ບ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ກະ ເກົາ ອາຕີ ໂອນ ເຍືາ ໄກຣ ລາລື່ ປາຍ: ຕຶ່ງ ແດີຍ ເອລີຢາ ເບີນ ຊາອຶ່ຍ ອຶມເປ່ອ໌ ກູມາຍ ແອີດ ຕຶ່ງ ກຣວາງ ອິດຊະຣາເອລ. ບັອງ ກາ ກັອຍ ຕາ ເບີນ ເມືາ ອຶນແຍ່ະ ໄປ ກູມໍ ຕາປັ່ດ ກາໄຊ. ນ່ະກັອຍ, ຕຶ່ງ ກຣວາງ ກັອຍ ມັຮ ກວາຍ ມາເຍືາຍຮ ຊາອຶ່ຍ ລາລື່ ແອິ ຊັຣນາ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ມາ ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ແປຣີ ເອລີຢາ ເປາະ ປໍ ອຶມເປ່ອ໌ ກູມາຍ ຕຶ່ງ ກຣວາງ ອິດຊະຣາເອລ. ອັນ ແປຣີ ເອລີຢາ ເປາະ ປໍ ມານະ ອຶມເປ່ອ໌ ກູມາຍ ຕຶ່ງ ວີ່ລ ຊາເຣພັດ ກຣວາງ ຊີໂດນ. ");
INSERT INTO ncq_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ເອລີຊາ ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ເຕ່. ຕຶ່ງ ແດີຍ ອັນ, ເບີນ ຊາອຶ່ຍ ນະ ກວາຍ ອາອີ່ ຕູ່ດ ແອີດ ຕຶ່ງ ກຣວາງ ອິດຊະຣາເອລ. ມາ ເບີນ ມານະ ຊັອງ ກວາຍ ອາອີ່ ຕູ່ດ ແຕ ແຄງ ຊີເຣຍ, ຣາມຶ່ຮ ນາອາມານ, ມາ ແກີດ ແບຣັຮ.\" ");
INSERT INTO ncq_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ແວັດ ອຶນແຍ່ະ ມັຮ ກວາຍ ຕຶ່ງ ດຸງ ຊາງ ກັອຍ ຊັອງ ເຢຊູ ປາຍ ມັຮ ຣາມຶ່ຮ ກັອຍ, ໄລ່ ຊັອງ ອຶງຄື່ນ ລາລື່ ໂຈະ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ໄລ່ ຢວຣ ຕາຢຶ່ງ ອຶນແຍ່ະ, ເຈີ່ ກາຕັ່ອງ ເຢຊູ ແຕ ດຸງ ຊາງ ກະ ເດີງ ອາລັ່ອຮ ອັນ ແຕ ວີ່ລ. ວີ່ລ ໄລ່ ແອີດ ຕຶ່ງ ກົຮ. ໄລ່ ເດີງ ເຢຊູ ປໍ ແລັ່ຮ ທັຣຮັຣ ຢໍອ໌ ອີ ກູແຕັລ ອາປັອງ ຕັຮ ເຢຊູ ແຕ ປັຣແລີ ແລັ່ຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ມາ ເຢຊູ ເປາະ ອຶນດີ ກວາຍ ກຼຶ່ງ ກັອຍ, ລັ່ອຮ ແວັດ ແຕ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ເຈີ່ ເຢຊູ ມູ່ດ ຕຶ່ງ ເມືອງ ກາເປນາອູມ, ແຄງ ຄາລີເລ. ຕຶ່ງ ຕາໄງ ຣາລູ່ ອັນ ອາຕີ ກວາຍ ຕຶ່ງ ເມືອງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ມັຮ ກວາຍ ກັອຍ ຊັອງ ງຶ່ດ ລາລື່ ແຕ ປັຣນາຍ ອັນ ອາຕີ, ຍ່ອນ ປັຣນາຍ ອັນ ເບີນ ອຳນາດ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ຕຶ່ງ ດຸງ ຊາງ ກັອຍ ເບີນ ມານະ ກວາຍ ຣາເລົາ ເຢືາງ ຕາ ອໍ ຕຣວບ. ກວາຍ ກັອຍ ແຮຣ ເຣ່ງ ລາລື່ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","\"ເຢຊູ ແຕ ວີ່ລ ນາຊາເຣັດ ເອີຍ, ນານ່ະ ເຍືາ ຢໍອ໌ ອີ ຕະ ກະ ຮິ? ເຍືາ ເປາະ ປໍ ໄນ່ ອີ ກາຈີດ ຮິ ບໍ? ເກົາ ຊາກັ່ລ ເຍືາ ລາ ແຕີ່ອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ, ກະ ເຍືາ ລາ ຕາ ເບີນ ໂລ່ຍຮ ອຶນເຕົ່າ.\" ");
INSERT INTO ncq_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ເຢຊູ ກາແອັຮ ເຢືາງ ຕາ ອໍ ປາຍ: \"ອຶນໂຈຍ ຕະ ແບອ໌! ໄມ່ ລັ່ອຮ ແຕິ່ ແຕ ຈະ ກວາຍ ໄນ່!\" ເຢືາງ ຕາ ອໍ ຕະ ໂອນ ກວາຍ ຣາເລົາ ກັອຍ ແດິມ ຢັ່ຮ ເມືາງ ມັຮ ກວາຍ ແອີດ ອຶງກັອຍ, ເຈີ່ ອັນ ລັ່ອຮ ຕາ ເບີນ ຕະ ເບິ ອຶນເຕົ່າ ກວາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ອາແລ່ະ ອາກັອຍ ຊັອງ ງຶ່ດ ລາລື່, ເຈີ່ ມານະ ຕາແບີບ ມານະ ປາຍ: \"ນານ່ະ ອັນ ປາຍ? ອັນ ເບີນ ອຳນາດ ເຕ່ອ໌ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ແຕ ຈະ ກວາຍ, ກະ ເຢືາງ ຕາ ອໍ ກັອຍ ຊາງັດ ອັນ!\" ");
INSERT INTO ncq_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ເຈີ່ ປັຣນາຍ ເນົ່າ ຕະ ອຶນຕີ ແຕ ເຢຊູ ເປາະ ຕົວ ກູ່ ອຶນຕຸ ອຶມແປຣ ແຄງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ເຢຊູ ລັ່ອຮ ແຕ ດຸງ ຊາງ ກັອຍ, ເຈີ່ ມູ່ດ ຕຶ່ງ ດຸງ ຊີໂມນ ແອັນ. ກູຢາກັນ ຊີໂມນ ເບີນ ອາອີ່ ກູເຕົາ ຈະ ຮັບ ລາລື່. ເຈີ່ ໄລ່ ແຊອ໌ ແຕ ເຢຊູ ໂອນ ອັນ ປົວ ອາຢ່ະ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ເຢຊູ ເປາະ ຕາຢຶ່ງ ແຈ່ະ ອາຢ່ະ ກາ ອາອີ່ ກັອຍ, ກະ ອັນ ກາແອັຮ ອາອີ່ ກັອຍ. ເຈີ່ ອາຢ່ະ ກັອຍ ແກີດ ແບຣັຮ ລັ່ຮ, ເຕ່ອ໌ ລັ່ຮ ອັນ ຢວຣ ຕະ ຊັຣນາ ໂອນ ຕາມອຍ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ພໍກາ ມານາງ ປັດ ເຈີ່, ເນົ່າ ເດີງ ແຕີ່ອ໌ ປໍ ເຢຊູ ກຼຶ່ງ ກວາຍ ກາ ເບີນ ຊາອຶ່ຍ ຣາມຶ່ຮ ອາອີ່. ອັນ ຊາປ່ະ ອາຕີ ຕຶ່ງ ຈະ ອຶນແຍ່ະ ມັຮ ກວາຍ ກັອຍ ໂອນ ໄລ່ ແກີດ ແບຣັຮ. ");
INSERT INTO ncq_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ເບີນ ກາ ເຢືາງ ຕາ ອໍ ແຮີ ລັ່ອຮ ແຕ ຈະ ຊາອຶ່ຍ ນະ ກວາຍ ອາອີ່ ກັອຍ. ເຢືາງ ຕາ ອໍ ກັອຍ ແຮຣ ກະ ໄລ່ ປາຍ: \"ເຍືາ ລາ ກອນ ເຢືາງ ເຈົາຣາຊີ!\" ເຈີ່ ເຢຊູ ກາແອັຮ ເຢືາງ ຕາ ອໍ ກັອຍ ຕາ ໂອນ ຕະ ແບອ໌ ນັ່ອງ, ຍ່ອນ ໄລ່ ດັງ ເຈີ່ ອັນ ລາ ກຣີດ, ອັນ ກາ ເຢືາງ ເຈົາຣາຊີ ຣຽຮ ດໍອ໌ ຈ່ອຍ ອາມົ່ງ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ປັ່ງ ຕາຣື່ບ ແຕ ຍາຍຶ່ມໆ ເຢຊູ ລັ່ອຮ ແຕ ອຶນຕຸ ກັອຍ. ເຈີ່ ອັນ ມູ່ດ ຕຶ່ງ ຕຍາຮ ແອັນ. ເບີນ ກຼຶ່ງ ກວາຍ ການໍ່ອ໌ ຈໍ່ອ໌ ອັນ. ພໍກາ ໄລ່ ຣາມົຮ ອັນ, ໄລ່ ຕາ ຢໍອ໌ ອີ ໂອນ ອັນ ລັ່ອຮ ແຕ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ມາ ເຢຊູ ອາຕີ ໄລ່ ປາຍ: \"ອຶງເຄາະ ເກົາ ເປາະ ອາຕີ ປັຣນາຍ ອໍ ແຕ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ, ໂອນ ວີ່ລ ການໍ່ອ໌ ດັງ ເຕ່, ຍ່ອນ ນ່ະກັອຍ ອຶມປໍ່ ເກົາ ແປຣີ ເກົາ ເປາະ ປໍ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ນ່ະກັອຍ ເຢຊູ ອາຕີ ຕຶ່ງ ມັຮ ດຸງ ຊາງ ຈວບ ກຣວາງ ອິດຊະຣາເອລ. ");
INSERT INTO ncq_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ເບີນ ມວຍ ຕາໄງ ເຢຊູ ຕາຢຶ່ງ ແຈ່ະ ປຶ່ຮ ທາເລ ຣາປັ່ງ ເຄັນເນຊາເຣັດ. ເບີນ ກຼຶ່ງ ກວາຍ, ໄລ່ ຣາເນ່ດ ເຢຊູ, ກະ ຢໍອ໌ ອີ ຊາງັດ ອັນ ອາຕີ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ເຢຊູ ເຮີມ ບາຣ ລໍາ ຕົວະ ແຈ່ະ ປຶ່ຮ ແດີອ໌. ກວາຍ ກາ ຕະ ຣານະ ຈໍ່ອ໌ ອາກາ, ໄລ່ ດໍອ໌ ຕົວະ ອຶງກັອຍ. ເຈີ່ ໄລ່ ເປາະ ປົ່ຮ ມ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ເຢຊູ ຊັອຮ ຕຶ່ງ ຕົວະ ຊີໂມນ. ກະ ອັນ ໂອນ ຊີໂມນ ອາລັ່ອຮ ບີ່ອ໌ ໂອນ ແວັດ ແຕ ປຶ່ຮ. ເຢຊູ ຕາກູ ຕຶ່ງ ຕົວະ, ເຈີ່ ອັນ ອາຕີ ກວາຍ ກຼຶ່ງ ກາ ແອີດ ຕຶ່ງ ປຶ່ຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ແວັດ ອັນ ອາຕີ ກວາຍ ກຼຶ່ງ ກັອຍ, ອັນ ແປຣີ ຊີໂມນ ປາຍ: \"ເອົາ ໄມ່ ເປືາຍ ອາລັ່ອຮ ຕົວະ ໄມ່ ເປາະ ປໍ ແດີອ໌ ອຶນຕຣູ່, ເຈີ່ ເຣືາຍ ມ່ອງ.\" ");
INSERT INTO ncq_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ຊີໂມນ ຕາແອີຍ ປາຍ: \"ອາຈານ ເອີຍ! ຮິ ຕະ ອຶນແຍ່ະ ຊາເດົາ ມາ ອຶມໄປຣ່ ເບີນ ມານຳ. ມາ ຄັນ ອາຈານ ແປຣີ ຮິ ເຣືາຍ, ເຕ່ອ໌ ຮິ ເຣືາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ເຈີ່ ໄລ່ ເຣືາຍ ມ່ອງ, ກະ ອາກາ ໄກຣ ຊາອຶ່ຍ ລາລື່, ຈົນ ອີ ຣາແຮອ໌ ກາ ມ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ໄລ່ ກູວອຍ໌ ກະ ຊາບາວ ເຢົ່າ ແຕ ຕົວະ ການໍ່ອ໌, ໂອນ ໄລ່ ໂລ່ຍ໌ ຈ່ອຍ, ເຈີ່ ເຢົ່າ ແຕີ່ອ໌ ຈ່ອຍ. ກະ ໄລ່ ໂຈະ ອາກາ ປັ່ນ ອຶນແຍ່ະ ບາຣ ແລັ່ມ ຕົວະ ກັອຍ, ຈົນ ຕົວະ ອີ ຕຣ່ຳ. ");
INSERT INTO ncq_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ພໍກາ ຊີໂມນ ເປໂຕ ເຮີມ ຣານະ ກັອຍ, ອັນ ກຼຸ່ ຣາໂກລ ຢັ່ຮ ເມືາງ ເຢຊູ, ກະ ອັນ ປາຍ: \"ອຶນເຈົາ ເອີຍ, ແຊອ໌ ເປາະ ເຢີ່ງ ແຕ ເກົາ, ຍ່ອນ ເກົາ ລາ ກວາຍ ເບີນ ໂລ່ຍຮ!\" ");
INSERT INTO ncq_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ຊີໂມນ ກະ ເຢົ່າ ອັນ, ໄລ່ ຊັນຕັຣ ເບີນ ອາກາ ຊາອຶ່ຍ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ຢາໂກໂບ ກະ ໂຢຮັນ, ກອນ ເຊເບດາຍ, ຊັນຕັຣ ເຮີມ ອາກາ ຊາອຶ່ຍ ເຕ່. ໄລ່ ບາຣ ນະ ກັອຍ ຕະ ມັນຕຸ ກະ ຊີໂມນ. ເຢຊູ ອາຕີ ຊີໂມນ ປາຍ: \"ອຶນໂຈຍ ອຶງກັອຮ ອຶນເຕົ່າ. ແຕ ໄນ່ ເຈີ່ ປໍ ເມືາງ ໄມ່ ເຕ່ອ໌ ຈໍ່ອ໌ ກວາຍ ນ່ະ ໄມ່ ຈໍ່ອ໌ ອາກາ ຊານໍ່ ໄນ່ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ໄລ່ ໄປ ນະ ກັອຍ ຮອຣ ອາຊັອຮ ຕົວະ ໄລ່ ຕຶ່ງ ກົຮ. ໄລ່ ຕັຮ ອຶນແຍ່ະ, ເຈີ່ ໄລ່ ເປາະ ກະ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ບັອງ ກາ ເຢຊູ ແອີດ ຕຶ່ງ ມວຍ ວີ່ລ ກັອຍ, ອັນ ຣາມົຮ ກວາຍ ຣາເລົາ ອາອີ່ ຕູ່ດ ຮັບ ລາລື່. ພໍກາ ກວາຍ ກັອຍ ເຮີມ ເຢຊູ, ອັນ ກູກຸຮ ຄຣາບ ຕຶ່ງ ກູແຕອ໌ ຢັ່ຮ ເມືາງ ເຢຊູ. ອັນ ແຊອ໌ ແຕ ເຢຊູ ປາຍ: \"ອຶນເຈົາ ເອີຍ, ຄັນ ອຶນເຈົາ ຢໍອ໌ ອີ ຕະ ໂອນ ເກົາ ແກີດ ບຣັຮ ອໍ, ເຕ່ອ໌ ອຶນເຈົາ ຕະ.\" ");
INSERT INTO ncq_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ເຢຊູ ອາລັ່ອຮ ອາຕີ ຊາປ່ະ ຕຶ່ງ ຈະ ກວາຍ ອາອີ່ ກັອຍ. ອັນ ປາຍ: \"ເກົາ ຢໍອ໌. ໂອນ ໄມ່ ແກີດ ບຣັຮ ອໍ!\" ບັອງ ກາ ກັອຍ ແຕິ່ ກວາຍ ກັອຍ ແກີດ ແບຣັຮ ເລີ່ຍ ອາອີ່ ຕູ່ດ. ");
INSERT INTO ncq_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ເຢຊູ ປາຕັບ ກວາຍ ກັອຍ ປາຍ: \"ອຶນໂຈຍ ຕະ ອຶນຕີ ໂອນ ກວາຍ ອາແລ່ະ ດັງ. ໄມ່ ເປາະ ອາປັຮ ຈະ ໄມ່ ໂອນ ກວາຍ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ເນ່. ເຈີ່ ໄມ່ ມ່ອບ ຊາງ ໂອນ ເຢືາງ ເຈົາຣາຊີ ມັຮ ຣາມຶ່ຮ ໂມເຊ ປາຕັບ ແຕ ອຶມແບິ ອາໄຣ່. ໄນ່ ລາ ອາປັຮ ໂອນ ກວາຍ ການໍ່ອ໌ ດັງ ໄມ່ ແກີດ ແບຣັຮ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ມາ ຣານະ ເຢຊູ ຕະ ໂອນ ກວາຍ ກັອຍ ແກີດ ດັອຮແດີນ. ກຼຶ່ງ ກວາຍ ແຕີ່ອ໌ ຊາງັດ ປັຣນາຍ ອັນ ອາຕີ, ກະ ໄລ່ ແຊອ໌ ອັນ ປົວ ອຶນແຍ່ະ ຣາມຶ່ຮ ໄລ່ ອາອີ່. ");
INSERT INTO ncq_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ມາ ເຢຊູ ລັ່ອຮ ແຕ ອຶນຕຸ ກວາຍ ແອີດ, ເປາະ ເກົາແຊອ໌ ປໍ ອຶນຕຸ ຕາ ເບີນ ເນົ່າ ແອີດ. ");
INSERT INTO ncq_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ເບີນ ມວຍ ຕາໄງ ເຢຊູ ແອີດ ອາຕີ. ຕາໄງ ກັອຍ ເບີນ ມັຮ ກວາຍ ພາຣີຊາຍ ກະ ກວາຍ ອາຕີ ຄານອດ, ໄລ່ ຕາກູ ອຶນຕຸ ກັອຍ ເຕ່. ໄລ່ ແຕີ່ອ໌ ແຕ ກູ່ ວີ່ລ ຕຶ່ງ ແຄງ ຄາລີເລ ກະ ແຄງ ຢູດາຍ. ໄລ່ ແຕີ່ອ໌ ແຕ ເມືອງ ເຢຣູຊາເລັມ ແຮີ. ເຢຊູ ເບີນ ອຳນາດ ແຕ ເຢືາງ ເຈົາຣາຊີ ເຕ່ອ໌ ປົວ ມັຮ ກວາຍ ອາອີ່ ແອີດ ອຶງກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ເບີນ ເນົ່າ ກຣາງ ມານະ ກວາຍ ຣາເລົາ ອາອີ່ ລ່ອຍ ຕຶ່ງ ຈຸ່ງຈາງ. ໄລ່ ຢໍອ໌ ອີ ມູ່ດ ຕຶ່ງ ດຸງ ດໍອ໌ ອັນ ຢັ່ຮ ເມືາງ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ມາ ກວາຍ ກຼຶ່ງ ກູທັດ ດຸງ; ເຈີ່ ໄລ່ ຕາ ດັງ ຣານາ ແລ່ະ ອີ ມູ່ດ ນັ່ອງ. ໄລ່ ກຣາງ ອາຊັອຮ ອັນ ຕຶ່ງ ຕຳປວລ ດຸງ. ເຈີ່ ໄລ່ ເປິຮ ຣານາ ຕຳປວລ ໂຢ່ລ ອາແຊງ ກວາຍ ອາອີ່ ຕຶ່ງ ຈຸ່ງຈາງ ອຶນດີ ກວາຍ ກຼຶ່ງ ຢັ່ຮ ເມືາງ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ພໍກາ ເຢຊູ ເຮີມ ຣາງຶ່ຮ ໄລ່ ຊາອຳ, ເຈີ່ ອັນ ອາຕີ ໂຈະ ກວາຍ ລ່ອຍ ກັອຍ ປາຍ: \"ອາຍ ເອີຍ! ໂລ່ຍຮ ໄມ່ ເກົາ ຕັຮ ໂອນ ເຈີ່!\" ");
INSERT INTO ncq_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ກວາຍ ອາຕີ ຄານອດ ກະ ກວາຍ ພາຣີຊາຍ, ໄລ່ ຄຶ່ດ ຕຶ່ງ ຣາງຶ່ຮ ໄລ່ ປາຍ: \"ກວາຍ ໄນ່ ລາ ເນົ່າ? ອັນ ຢໍອ໌ ອີ ເບີນ ອຳນາດ ຣາລີ ກະ ເຢືາງ ເຈົາຣາຊີ ເຕ່ ບໍ? ຕາ ເບີນ ກວາຍ ອາແລ່ະ ເຕ່ອ໌ ຕັຮ ໂລ່ຍຮ ກວາຍ. ແອີງ ມານະ ເຢືາງ ເຈົາຣາຊີ ຊັອງ ເຕ່ອ໌ ຕັຮ ໂລ່ຍຮ ກວາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ມາ ເຢຊູ ດັງ ໄລ່ ຄຶ່ດ ນ່ະກັອຍ; ເຈີ່ ອັນ ຕາແບີບ ໄລ່ ກັອຍ ປາຍ: \"ນານ່ະ ເຍືາ ຄຶ່ດ ນ່ະກັອຍ ຕຶ່ງ ຣາງຶ່ຮ ເຍືາ? ");
INSERT INTO ncq_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ປັຣນາຍ ອາແລ່ະ ກາ ເຍືາ ຊັອງ ອຽນ ກາເລີຍ ເກົາ ອາຕີ ກວາຍ ລ່ອຍ ກັອຍ ປາຍ: 'ໂລ່ຍຮ ໄມ່ ເກົາ ຕັຮ ໂອນ ເຈີ່,' ແຕີລາ 'ໄມ່ ຢວຣ ຕາຢຶ່ງ, ເຈີ່ ໄມ່ ເປາະ.' ");
INSERT INTO ncq_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ມາ ຊານໍ່ ເກົາ ອີ ຕະ ໂອນ ກວາຍ ລ່ອຍ ໄນ່ ແກີດ ແບຣັຮ, ໂອນ ເຍືາ ດັງ ແຈງ ລາລື່, ເກົາ ລາ ກອນ ເຢືາງ ແກີດ ກວາຍ, ເບີນ ອຳນາດ ຕຶ່ງ ກູແຕອ໌ ໄນ່ ກະ ເຕ່ອ໌ ຕັຮ ໂລ່ຍຮ ກວາຍ.\" ແວັດ ກັອຍ ເຢຊູ ອາຕີ ກວາຍ ລ່ອຍ ປາຍ: \"ເກົາ ໂອນ ໄມ່ ຢວຣ ຕາຢຶ່ງ! ໄມ່ ໂດລ ອີດ ຈຸ່ງຈາງ ໄມ່; ເຈີ່ ໄມ່ ເຈົາ ລັ່ຮ ປໍ ດຸງ ໄມ່!\" ");
INSERT INTO ncq_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ບັອງ ກາ ກັອຍ ແຕິ່ ກວາຍ ລ່ອຍ ກັອຍ ຢວຣ ຕາຢຶ່ງ ຢັ່ຮ ເມືາງ ກວາຍ ກຼຶ່ງ ກັອຍ. ອັນ ອີດ ໂດລ ຈຸ່ງຈາງ ອັນ; ເຈີ່ ອັນ ເຈົາ ປໍ ດຸງ ອັນ, ເຈີ່ ອັນ ຍ່ອງ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ກຼຶ່ງ ກວາຍ ກັອຍ ຊັອງ ງຶ່ດ ກະ ຊັນຕັຣ. ໄລ່ ຍ່ອງ ເຢືາງ ເຈົາຣາຊີ. ໄລ່ ປາຍ: \"ຕາໄງ ໄນ່ ໄຮ ເຮີມ ຣານະ ຕາ ເກີ່ຍ ເຮີມ!\" ");
INSERT INTO ncq_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ແວັດ ກັອຍ ເຢຊູ ລັ່ອຮ ແຕ ອຶນຕຸ ກັອຍ. ບັອງ ກາ ອັນ ເປາະ ຕຶ່ງ ຣານາ, ອັນ ເຮີມ ກວາຍ ມານະ, ຣາມຶ່ຮ ເລວີ, ແອີດ ຕາກູ ຕຶ່ງ ດຸງ ປາໂຣມ ປຣະ ປາຊີ. ອັນ ລາ ກວາຍ ເກີ່ຍ ອີດ ປຣະ ປາຊີ. ເຢຊູ ກູອ໌ ອັນ ປາຍ: \"ໄມ່ ເປາະ ອາລຶ່ງ ເກົາ!\" ");
INSERT INTO ncq_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ເຈີ່ ເລວີ ຕັຮ ອຶນແຍ່ະ ມັຮ ເກຣີ່ງ ອັນ, ຢວຣ ຕາຢຶ່ງ, ກະ ເປາະ ອາລຶ່ງ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ແວັດ ກັອຍ ເລວີ ຕະ ເປ່ລ ບູຍ ປື່ດ ລາລື່ ຣັ່ບ ເຢຊູ. ເບີນ ກຼຶ່ງ ກວາຍ, ກາ ກວາຍ ປາໂຣມ ປຣະ ປາຊີ ການໍ່ອ໌ ແຮີ, ຈາ ມັນຕຸ ກະ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ມາ ມັຮ ກວາຍ ພາຣີຊາຍ ກະ ກວາຍ ອາຕີ ຄານອດ, ໄລ່ ຕິ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ປາຍ: \"ນານ່ະ ເຍືາ ຈາ ມັນຕຸ ກະ ໄລ່ ກາ ປາໂຣມ ປຣະ ປາຊີ ກະ ກວາຍ ໂລ່ຍຮ ການໍ່ອ໌ ແຮີ?\" ");
INSERT INTO ncq_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ກວາຍ ບັນ ເຣ່ງ ອໍ ຕາ ເບີນ ເປາະ ແຊອ໌ ໂອນ ເນົ່າ ປົວ. ມາ ແອີງ ກວາຍ ອາອີ່ ຊັອງ ເປາະ ແຊອ໌ ໂອນ ເນົ່າ ປົວ. ");
INSERT INTO ncq_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່, ເກົາ ຕາ ເບີນ ກູອ໌ ກວາຍ ກາ ຕານັ່ອງ ອໍ, ມາ ເກົາ ກູອ໌ ກວາຍ ກາ ເບີນ ໂລ່ຍຮ ໂອນ ໄລ່ ຕັຮ ຣາງຶ່ຮ ຕຍາ ປຽນ ແກີດ ຣາງຶ່ຮ ຕາໄມ ແອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ມັຮ ກວາຍ ພາຣີຊາຍ ກະ ກວາຍ ອາຕີ ຄານອດ, ໄລ່ ອາຕີ ເຢຊູ ປາຍ: \"ມັຮ ມູ່ ກາ ຣຍານ ແຕ ໂຢຮັນ, ຊາອຶ່ຍ ເປ່ລ ໄລ່ ຕະ ຣີ່ດ ອົດ ຊັຣນາ, ກະ ໄລ່ ອີ ເກົາແຊອ໌ ຊັອງ. ໄລ່ ກາ ຣຍານ ແຕ ຈຸ່ມ ພາຣີຊາຍ, ໄລ່ ຕະ ມູເຈິງ ກັອຍ ເຕ່. ມາ ມູ່ ກາ ຣຍານ ແຕ ອາຈານ, ໄລ່ ງ່ອຍ໌ ຈາ ທໍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ເຢຊູ ອາຕີ ລັ່ຮ ໄລ່ ແຕ ປັຣນາຍ ຊາກຳ ປາຍ: \"ບັອງ ກາ ປັຣລົວະ ອີ ອີດ ລາກວຍ, ມັຮ ເຢົ່າ ກາ ແອີດ ກະ ອັນ ໄລ່ ຕາ ເຕ່ອ໌ ອົດ ຊັຣນາ. ");
INSERT INTO ncq_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ມາ ພໍກາ ຕາໄງ ປັຣລົວະ ກັອຍ ຕາ ເບີນ ແອີດ ນັ່ອງ ກະ ເຢົ່າ ອັນ, ຕາໄງ ກັອຍ ໄລ່ ອີ ອົດ ເຕ່ ຊັຣນາ ຈາ.\" ");
INSERT INTO ncq_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ເຢຊູ ອາຕີ ແອັນ ແຕ ປັຣນາຍ ຊາກຳ ປາຍ: \"ຕາ ເບີນ ກວາຍ ອາແລ່ະ ແຈອ໌ ອາຣົ່ຮ ແຕ ອາຢັ່ອຮ ຕາໄມ ເຈີ່ ທາບ ໂຈະ ອາຢັ່ອຮ ຕຍາ. ຄັນ ອັນ ຕະ ນ່ະກັອຍ ອັນ ຕະ ໂລ່ ເມືາດ ອາຢັ່ອຮ ຕາໄມ ກັອຍ, ກະ ອາຣົ່ຮ ຕາໄມ ກາ ອັນ ທາບ ກັອຍ ຕາ ເບີນ ຊັງໄກຣ ກະ ອາຢັ່ອຮ ຕຍາ. ");
INSERT INTO ncq_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ກະ ຕາ ເບີນ ກວາຍ ອາແລ່ະ ອີດ ບຼັອງ ຕາໄມ ມາ ຕຣອງ ໂຈະ ຕຶ່ງ ຕູຍ ອຶງກັຣ ຕຍາ. ຄັນ ເນົ່າ ຕະ ນ່ະກັອຍ, ບຼັອງ ຕາໄມ ອັນ ອີ ຕະ ໂອນ ຕູຍ ອຶງກັຣ ຕຍາ ປັຣອາອ໌. ");
INSERT INTO ncq_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ອຶງເຄາະ ອີດ ບຼັອງ ຕາໄມ ໂຈະ ຕຶ່ງ ຕູຍ ອຶງກັຣ ຕາໄມ.\" ");
INSERT INTO ncq_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ກະ ຕາ ເບີນ ເນົ່າ ອີ ງ່ອຍ໌ ບຼັອງ ຕາໄມ ຄັນ ອັນ ງ່ອຍ໌ ບຼັອງ ຕຍາ ເຈີ່, ຍ່ອນ ອັນ ປາຍ: 'ບຼັອງ ຕຍາ ແອມ ກາເລີຍ ບຼັອງ ຕາໄມ.'\" ");
INSERT INTO ncq_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ຕຶ່ງ ມວຍ ຕາໄງ ຣາລູ່, ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ມູ່ດ ຕຶ່ງ ໄທຣ ເນົ່າ ຈົຮ ຊາປໍ່. ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ກິດ ອີດ ຣາກົ່ງ ໂດຍ ກັອຍ, ໄລ່ ກູຕອຣ ແຕ ອາຕີ ເຈີ່ ໄລ່ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ເບີນ ກວາຍ ແຕ ຈຸ່ມ ພາຣີຊາຍ ຕາແບີບ ໄລ່ ປາຍ: \"ນານ່ະ ເຍືາ ຕາ ເບີນ ຊາງັດ ຄານອດ ກາ ຕາ ໂອນ ຕະ ຣານະ ຕຶ່ງ ຕາໄງ ຣາລູ່?\" ");
INSERT INTO ncq_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ເຍືາ ຕາ ເກີ່ຍ ອານ ບໍ ຣານະ ດາວິດ ກະ ຈຸ່ມ ອັນ ຕະ, ບັອງ ໄລ່ ມາເຍືາຍຮ ໂດຍ? ");
INSERT INTO ncq_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ດາວິດ ມູ່ດ ຕຶ່ງ ດຸງ ຊາງ ເຢືາງ ເຈົາຣາຊີ. ອັນ ຈາ ໂດຍ ບຸຮ ກາ ກວາຍ ມ່ອບ ໂອນ ເຢືາງ ເຈົາຣາຊີ, ກະ ອັນ ໂອນ ຈຸ່ມ ອັນ ຈາ ເຕ່. ຕາປູ່ນ ຕາມ ຄານອດ ໄຮ ລາ ແອີງ ກວາຍ ຊາງ ຣີ່ດ ຊັອງ ເຕ່ອ໌ ຈາ ໂດຍ ບຸຮ ກັອຍ (ມາ ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ຕິ ອັນ).\" ");
INSERT INTO ncq_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ກະ ເຢຊູ ປາຍ ແອັນ ນ່ະໄນ່: \"ເກົາ, ກອນ ເຢືາງ ແກີດ ກວາຍ, ລາ ອຶນເຈົາ ຕາໄງ ຣາລູ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ເບີນ ມວຍ ຕາໄງ ຣາລູ່ ການໍ່ອ໌ ແອັນ, ເຢຊູ ມູ່ດ ອາຕີ ກວາຍ ຕຶ່ງ ດຸງ ຊາງ ກວາຍ ອິດຊະຣາເອລ. ແອີດ ອຶງກັອຍ ເບີນ ມານະ ຣາເລົາ ຣາກຸ ອາຕີ ຢັ່ຮ ອາຕ່ຳ. ");
INSERT INTO ncq_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ມັຮ ກວາຍ ອາຕີ ຄານອດ ກະ ມັຮ ກວາຍ ພາຣີຊາຍ, ໄລ່ ຈໍ່ອ໌ ຣານະ ໂລ່ຍຮ ແຕ ເຢຊູ ໂອນ ເຕ່ອ໌ ໄລ່ ປ່ອງ. ໄລ່ ເນ່ ລາລື່ ເຢຊູ, ຢໍອ໌ ອີ ດັງ ອັນ ປົວ ກວາຍ ອາອີ່ ຕຶ່ງ ຕາໄງ ຣາລູ່, ມາ ຕາ ເບີນ. ");
INSERT INTO ncq_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ມາ ເຢຊູ ດັງ ໄລ່ ຄຶ່ດ ນ່ະກັອຍ. ເຈີ່ ອັນ ອາຕີ ໂຈະ ກວາຍ ຣາກຸ ອາຕີ ກັອຍ ປາຍ: \"ໄມ່ ຢວຣ ຕາຢຶ່ງ ຢັ່ຮ ເມືາງ ກວາຍ ໄນ່.\" ເຈີ່ ກວາຍ ກັອຍ ຢວຣ ແຕິ່ ກະ ອັນ ຕາຢຶ່ງ ອຶງກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ເຈີ່ ເຢຊູ ອາຕີ ກວາຍ ການໍ່ອ໌ ອຶມແປຣ ກັອຍ ປາຍ: \"ເກົາ ແຊອ໌ ຕາແບີບ ເຍືາ: ຕຶ່ງ ຕາໄງ ຣາລູ່, ປວາຍ ຄານອດ ໄຮ, ອຶງເຄາະ ໄຮ ຕະ ອໍ, ແຕີລາ ໄຮ ຕະ ຕາ ອໍ? ໄຮ ອີ ຈ່ອຍ ໂອນ ກວາຍ ອາມົ່ງ, ມາ ໄຮ ອີ ກາຈີດ ກວາຍ?\" ");
INSERT INTO ncq_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ແວັດ ກັອຍ ເຢຊູ ກູລຍານ ເນ່ ປໍ ມັຮ ກວາຍ ກັອຍ, ກະ ອັນ ປາຕັບ ກວາຍ ອາອີ່ ກັອຍ ປາຍ: \"ໄມ່ ອາລັ່ອຮ ອາຕີ ໄມ່!\" ພໍກາ ກວາຍ ກັອຍ ອາລັ່ອຮ ອາຕີ ອັນ, ເຈີ່ ອາຕີ ອັນ ແກີດ ແບຣັຮ. ");
INSERT INTO ncq_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ນ່ະກັອຍ ມັຮ ກວາຍ ກັອຍ ຊັອງ ປັ່ນ ຕຶ່ງ ຣາງຶ່ຮ ໄລ່ ອຶງຄື່ນ, ກະ ໄລ່ ຊັຣຮົງ ນານ່ະ ອີ ຕະ ໂຈະ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ແວັດ ກັອຍ, ເຢຊູ ຊັອຮ ຕຶ່ງ ກົຮ ຢໍອ໌ ອີ ເກົາແຊອ໌ ປໍ ກັອຍ. ອຶນແຍ່ະ ຊາເດົາ ກັອຍ ອັນ ເກົາແຊອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ປັ່ງ ຕາຣື່ບ ແອັນ, ອັນ ກູອ໌ ໄລ່ ກາ ຣຍານ ແຕ ອັນ, ກະ ອັນ ຣຽຮ ມວຍ ຈິ່ດ ລາ ບາຣ ນະ ແຕ ໄລ່ ກັອຍ. ອັນ ດໍອ໌ ໄລ່ ກັອຍ ລາ ກວາຍ ກາ ອັນ ປາຈຸ່ຮ ໂອນ ເປາະ ຕະ ຣານະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ມັຮ ໄລ່ ກາ ອັນ ຣຽຮ ເບີນ ຣາມຶ່ຮ ນ່ະໄນ່: ຊີໂມນ, ອັນ ກາ ເຢຊູ ຈົຮ ຣາມຶ່ຮ ເປໂຕ ແຮີ, ກະ ອັນເດອາ, ລາ ອາແອມ ຊີໂມນ. ເບີນ ຢາໂກໂບ, ໂຢຮັນ, ພີລິບ ກະ ບາຣໂທໂລມາຍ, ");
INSERT INTO ncq_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ມັດທາຍ, ໂທມາ, ຢາໂກໂບ ກອນ ອາລະພາຍ, ກະ ຊີໂມນ ເຊໂລເຕ, ");
INSERT INTO ncq_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ຢູດາ ກອນ ຢາໂກໂບ, ກະ ຢູດາ ອິດຊະກາຣີອົດ, ອັນ ກາ ມ່ອບ ເຢຊູ ໂອນ ເນົ່າ ກາຈີດ. ");
INSERT INTO ncq_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ແວັດ ກັອຍ, ເຢຊູ ແຊງ ແຕ ກົຮ ມັນຕຸ ກະ ກຼຶ່ງ ກວາຍ ກາ ຣຍານ ແຕ ອັນ. ໄລ່ ຕາຢຶ່ງ ຕຶ່ງ ອຶນຕຸ ເປືາຣ ກັອຍ. ແອີດ ອຶງກັອຍ ເບີນ ກຼຶ່ງ ກວາຍ ການໍ່ອ໌ ແຮີ ແຕີ່ອ໌ ແຕ ແຄງ ຢູດາຍ, ແຕ ເມືອງ ເຢຣູຊາເລັມ, ກະ ແຕ ປຶ່ຮ ທາເລ ແຈ່ະ ກະ ເມືອງ ຕີເຣ ກະ ແຕ ເມືອງ ຊີໂດນ. ");
INSERT INTO ncq_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ອຶນແຍ່ະ ມັຮ ກວາຍ ກັອຍ ແຕີ່ອ໌ ອີ ຊາງັດ ປັຣນາຍ ເຢຊູ, ກະ ໄລ່ ຢໍອ໌ ອັນ ປົວ ມັຮ ຣາມຶ່ຮ ໄລ່ ອາອີ່. ໄລ່ ກາ ເບີນ ເຢືາງ ຕາ ອໍ ຕຣວບ ແກີດ ບັນ ເຣ່ງ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ອຶນແຍ່ະ ມັຮ ກຼຶ່ງ ກວາຍ ອາອີ່ ກັອຍ ຈໍ່ອ໌ ຢໍອ໌ ອີ ຊາປ່ະ ເຢຊູ, ຍ່ອນ ເຢຊູ ເບີນ ອຳນາດ ປົວ ອຶນແຍ່ະ ມັຮ ກວາຍ ອາອີ່. ");
INSERT INTO ncq_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ເຢຊູ ເນ່ ປໍ ໄລ່ ກາ ຣຍານ ແຕ ອັນ, ກະ ປາຍ: \"ບຸ່ນ ລາລື່ ເຍືາ ກາ ກາດີດ, ຍ່ອນ ເຍືາ ເບີນ ຈຸງ ເຕ່ ມັຮ ກາ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ! ");
INSERT INTO ncq_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ບຸ່ນ ລາລື່ ເຍືາ ກາ ມາເຍືາຍຮ ຊານໍ່, ຍ່ອນ ປັຣແນີ ມັນເຕຣືາ ເຍືາ ແກີດ ປາໄຊ ແອັນ! ບຸ່ນ ລາລື່ ເຍືາ ກາ ເຍືາມ ຊານໍ່, ຍ່ອນ ປັຣແນີ ມັນເຕຣືາ ເຍືາ ກາຈັງ ແອັນ! ");
INSERT INTO ncq_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ບຸ່ນ ລາລື່ ເຍືາ ບັອງ ກວາຍ ການໍ່ອ໌ ຊາອັຣ ເຍືາ, ກາແລີຍຮ ເຍືາ, ອາເຢ່ ພາມາດ ເຍືາ, ກະ ປາຍ ເຍືາ ລາ ຕາ ອໍ ຍ່ອນ ເຍືາ ປວາຍ ກອນ ເຢືາງ ແກີດ ກວາຍ! ");
INSERT INTO ncq_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","\"ຕຶ່ງ ຕາໄງ ກັອຍ, ອຶງເຄາະ ເຍືາ ຊັອງ ຣໍ່ອ໌, ກະ ອຶງເຄາະ ເຍືາ ແອີນ ຕຳໂປກ, ຍ່ອນ ເຢືາງ ເຈົາຣາຊີ ດໍອ໌ ໂອນ ເຍືາ ເບີນ ເກືາ ຊາອຶ່ຍ ຕຶ່ງ ມັນລັ່ອງ. ອາຈວາຍຮ ອາເຈ່ຮ ມັຮ ກວາຍ ກັອຍ ຕະ ມູເຈິງ ກັອຍ ເຕ່ ໂຈະ ໄລ່ ກາ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ມາ ບາບ ລາລື່ ເຍືາ ກາ ຊຸ ເບີນ ຊານໍ່, ຍ່ອນ ເຍືາ ເບີນ ອາມົ່ງ ຣໍ່ອ໌ ຕຶ່ງ ແດີຍ ໄນ່ ຊັອງ! ");
INSERT INTO ncq_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ກະ ບາບ ລາລື່ ເຍືາ ກາ ເບີນ ປາໄຊ ຊານໍ່, ຍ່ອນ ປັຣແນີ ມັນເຕຣືາ ເຍືາ ແກີດ ມາເຍືາຍຮ ແອັນ! ກະ ບາບ ລາລື່ ເຍືາ ກາ ກາຈັງ ຊານໍ່, ຍ່ອນ ປັຣແນີ ມັນເຕຣືາ ເຍືາ ເຍືາມ ກູໂກຼຍ໌ ແອັນ! ");
INSERT INTO ncq_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","\"ບາບ ລາລື່ ເຍືາ, ຄັນ ອຶນແຍ່ະ ມັຮ ກວາຍ ຍ່ອງ ປາຍ ເຍືາ ລາ ອໍ. ຍ່ອນ ແຕ ອຶມແບິ, ອາຈວາຍຮ ອາເຈ່ຮ ໄລ່ ກັອຍ ຕະ ມູເຈິງ ກັອຍ ເຕ່ ໂຈະ ກວາຍ ກາ ຕະ ອຶນຕີ ອາໂລກ ປາຍ ໄລ່ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","\"ເກົາ ອາຕີ ເຍືາ ກາ ຢໍອ໌ ອີ ຊາງັດ ເກົາ ປາຍ: ອຶງເຄາະ ເຍືາ ອາໂຢ່ະ ມັຮ ກວາຍ ກາ ອວານ ເຍືາ. ອຶງເຄາະ ເຍືາ ຕະ ອໍ ໂຈະ ໄລ່ ກາ ຊາອັຣ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ອຶງເຄາະ ເຍືາ ແຊອ໌ ບຸ່ນ ໂອນ ໄລ່ ກາ ເວ່ນ ເຍືາ. ກະ ອຶງເຄາະ ເຍືາ ເກົາແຊອ໌ ໂອນ ເຢືາງ ເຈົາຣາຊີ ຈ່ອຍ ໄລ່ ກາ ຕະ ຕາ ອໍ ໂຈະ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ຄັນ ເນົ່າ ຕັ່ຮ ກາແລງ ບັງ ເຍືາ ມັງກັ່ຮ, ເຍືາ ຕໍ ໂອນ ໄລ່ ຕັ່ຮ ຢັ່ຮ ມັງກັ່ຮ ແອັນ. ກະ ຄັນ ເນົ່າ ຢໍອ໌ ອີ ອີດ ອາຢັ່ອຮ ຕຶ່ງ ແປີງ ເຍືາ, ອຶງເຄາະ ເຍືາ ຕວດ ກາ ອາຢັ່ອຮ ຕຶ່ງ ປື່ນ ແຮີ ໂອນ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ຄັນ ກວາຍ ອາແລ່ະ ແຊອ໌ ອຶນເຕົ່າ ແຕ ເຍືາ, ເຍືາ ໂອນ ອັນ. ກະ ຄັນ ກວາຍ ອາແລ່ະ ອີດ ເກຣີ່ງ ອຶນເຕົ່າ ແຕ ເຍືາ, ເຍືາ ອຶນໂຈຍ ແຊອ໌ ລັ່ຮ ເກຣີ່ງ ກັອຍ ແຕ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ອຶນເຕົ່າ ເຍືາ ຢໍອ໌ ກວາຍ ການໍ່ອ໌ ຕະ ໂຈະ ເຍືາ, ອຶງເຄາະ ເຍືາ ຕະ ໂຈະ ກວາຍ ການໍ່ອ໌ ນ່ະກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","\"ຄັນ ເຍືາ ມາ ອາໂຢ່ະ ແອີງ ກວາຍ ກາ ອາໂຢ່ະ ເຍືາ ຊັອງ, ອຶນເຕົ່າ ເຢືາງ ເຈົາຣາຊີ ໂອນ ເຍືາ ເບີນ ເກືາ? ໄລ່ ກາ ຕາ ເບີນ ຊາອຳ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ໄລ່ ອາໂຢ່ະ ລັ່ຮ ກວາຍ ກາ ອາໂຢ່ະ ໄລ່ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ກະ ຄັນ ເຍືາ ມາ ຕະ ອໍ ໂຈະ ໄລ່ ກາ ຕະ ອໍ ໂຈະ ເຍືາ ຊັອງ, ອຶນເຕົ່າ ເຢືາງ ເຈົາຣາຊີ ໂອນ ເຍືາ ເບີນ ເກືາ? ກວາຍ ກາ ຕາ ເບີນ ຊາອຳ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ໄລ່ ຕະ ນ່ະກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ຄັນ ເຍືາ ມາ ໂອນ ກວາຍ ການໍ່ອ໌ ລັບ ປຣະ ເຍືາ, ມາ ເຍືາ ອຶງກ່ອງ ອີ ເບີນ ລັ່ຮ ປຣະ ເຍືາ ແຕ ກວາຍ ກັອຍ, ອຶນເຕົ່າ ເຢືາງ ເຈົາຣາຊີ ໂອນ ເຍືາ ເບີນ ເກືາ? ກວາຍ ກາ ຕາ ເບີນ ຊາອຳ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ໄລ່ ໂອນ ກວາຍ ການໍ່ອ໌ ລັບ ເຕ່ ປຣະ ໄລ່, ຄັນ ໄລ່ ອຶງກ່ອງ ເບີນ ລັ່ຮ ປຣະ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ມາ ອຶງເຄາະ ເຍືາ ອາໂຢ່ະ ກວາຍ ກາ ອວານ ເຍືາ. ອຶງເຄາະ ເຍືາ ຕະ ອໍ ໂຈະ ໄລ່. ກະ ອຶງເຄາະ ເຍືາ ໂອນ ໄລ່ ລັບ ປຣະ ແຕ ເຍືາ, ມາ ເຍືາ ອຶນໂຈຍ ອຶງກ່ອງ ອີ ເບີນ ລັ່ຮ ປຣະ ແຕ ໄລ່. ນ່ະກັອຍ, ປັຣແນີ ມັນເຕຣືາ ເຍືາ ເບີນ ເກືາ ອໍ ລາລື່, ກະ ເຍືາ ແກີດ ກອນ ອາໄກ ເຢືາງ ເຈົາຣາຊີ, ອັນ ກາ ປື່ດ ກາເລີຍ ອຶນແຍ່ະ ແຕ ການໍ່ອ໌. ອັນ ຕະ ອໍ ໂຈະ ໄລ່ ກາ ຕາ ອໍ ລາລື່ ກະ ໄລ່ ກາ ຕາ ດັງ ຊາແອີນ. ");
INSERT INTO ncq_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ອຶງເຄາະ ເຍືາ ອາໂຢ່ະ ຕະ ກວາຍ ການໍ່ອ໌ ມູເຈິງ ອຶມປໍ່ ເຍືາ ຕຶ່ງ ມັນລັ່ອງ ອາໂຢ່ະ ຕະ ເຍືາ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","ເຢຊູ ປາຍ ແອັນ ນ່ະໄນ່: \"ເຍືາ ອຶນໂຈຍ ຕິ ກວາຍ ການໍ່ອ໌; ນ່ະກັອຍ ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ຕິ ເຕ່ ເຍືາ. ກະ ເຍືາ ອຶນໂຈຍ ຕະ ໂຕ່ດ ກວາຍ ການໍ່ອ໌; ນ່ະກັອຍ ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ຕະ ໂຕ່ດ ເຕ່ ເຍືາ. ອຶງເຄາະ ເຍືາ ຕັຮ ໂລ່ຍຮ ກວາຍ ການໍ່ອ໌ ຕະ ໂຈະ ເຍືາ; ນ່ະກັອຍ ເຢືາງ ເຈົາຣາຊີ ຕັຮ ໂລ່ຍຮ ເຕ່ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ຄັນ ເຍືາ ໂອນ ມວຍ ກາເຣຍ ເກຣີ່ງ ອຶນເຕົ່າ ໂອນ ກວາຍ ການໍ່ອ໌, ເຢືາງ ເຈົາຣາຊີ ກູລັຮ ລັ່ຮ ເຍືາ ກາເລີຍ ແຕ ກັອຍ ແອັນ. ມັຮ ກາເຣຍ ອັນ ຈ່ອຍ ເຍືາ, ອັນ ກັຣຢິຮ, ກະ ອັນ ພອງ; ກະ ອັນ ຍັ່ດ ປັ່ນ ບູບົງ ໂອນ ເຍືາ. ຍ່ອນ ເກຣີ່ງ ອຶນເຕົ່າ ເຍືາ ຈ່ອຍ ໂອນ ເຢົ່າ ມູ ກາເຣຍ, ເຢືາງ ເຈົາຣາຊີ ຈ່ອຍ ລັ່ຮ ເຍືາ ມູເຈິງ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ເຢຊູ ອາຕີ ປັຣນາຍ ຊາກຳ ໄນ່: \"ກວາຍ ຊູດ ມັ່ດ ຕາ ເຕ່ອ໌ ເຕິ ກວາຍ ຊູດ ມັ່ດ ການໍ່ອ໌. ຄັນ ອັນ ເຕິ, ເຈີ່ ໄລ່ ບາຣ ນະ ຊາປິ່ລ ມັນຕຸ ຕຶ່ງ ປຣຸ່ງ ");
INSERT INTO ncq_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ອັນ ກາ ຣຍານ ຕາ ເບີນ ປື່ດ ກາເລີຍ ແຕ ອາຈານ ອັນ. ມາ ກູ່ ນະ ກາ ຣຍານ, ພໍກາ ອັນ ຣຍານ ແມິ່ມ ອຶນແຍ່ະ, ເຈີ່ ອັນ ແກີດ ນ່ະ ອາຈານ ອັນ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","\"ນານ່ະ ເຍືາ ເຮີມ ບຣິຮ ຕຶ່ງ ມັ່ດ ເຢົ່າ, ມາ ເຍືາ ຕາ ເບີນ ດັງ ປາລິຮ ອາລ່ອງ ກາ ກາຕັງ ມັ່ດ ເຍືາ? ");
INSERT INTO ncq_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ກະ ນານ່ະ ເຍືາ ຍັ່ນ ປາຍ ກະ ເຢົ່າ ນ່ະໄນ່: 'ໂອນ ເກົາ ອີດ ຕັຮ ບຣິຮ ແຕ ມັ່ດ ໄມ່,' ມາ ເຍືາ ຕາ ເບີນ ດັງ ປາລິຮ ອາລ່ອງ ກາ ກາຕັງ ມັ່ດ ເຍືາ? ເຍືາ ລາ ກວາຍ ມາມ ອໍ ມາ ຣາງຶ່ຮ ໂກ່ະ! ອຶງເຄາະ ເຍືາ ອີດ ຕັຮ ປາລິຮ ອາລ່ອງ ແຕ ມັ່ດ ເຍືາ ເວືາຍ. ນ່ະກັອຍ ເຕ່ອ໌ ເຍືາ ເຮີມ ແຈງ, ເຈີ່ ເຕ່ອ໌ ເຍືາ ອີດ ຕັຮ ບຣິຮ ແຕ ມັ່ດ ເຢົ່າ.\" ");
INSERT INTO ncq_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","\"ຕາ ເກີ່ຍ ເບີນ ອາລ່ອງ ອໍ ມາ ແກີດ ປາໄລ ຕາ ອໍ, ກະ ຕາ ເກີ່ຍ ເບີນ ອາລ່ອງ ຕາ ອໍ ມາ ແກີດ ປາໄລ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ຄັນ ເຍືາ ເຮີມ ປາໄລ, ເຍືາ ດັງ ກາ ກັ່ລ. ເຍືາ ຕາ ເກີ່ຍ ໂປຍ໌ ປາໄລ ລາວັ່ຮ ແຕ ກັ່ລ ຊັຣເລືາ ຕາແກີງ. ກະ ເຍືາ ຕາ ເກີ່ຍ ໂປຍ໌ ປາໄລ ອາງຸ່ນ ແຕ ກັ່ລ ຊັຣເລືາ ຈົງ. ");
INSERT INTO ncq_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ກວາຍ ມັນຕັ່ດ ອໍ ອັນ ເບີນ ຣານະ ອໍ ແອີດ ຕຶ່ງ ຣາງຶ່ຮ ອັນ. ນ່ະກັອຍ ຣານະ ອໍ ລັ່ອຮ ແຕ ຣາງຶ່ຮ ກວາຍ ກັອຍ. ກະ ກວາຍ ຕາ ອໍ ອັນ ເບີນ ຣານະ ຕາ ອໍ ແອີດ ຕຶ່ງ ຣາງຶ່ຮ ອັນ. ນ່ະກັອຍ ຣານະ ຕາ ອໍ ລັ່ອຮ ແຕ ຣາງຶ່ຮ ກວາຍ ກັອຍ. ຣານະ ອຶນເຕົ່າ ກາ ເບີນ ຕຶ່ງ ຣາງຶ່ຮ ກວາຍ, ແບອ໌ ກວາຍ ກັອຍ ປາຍ ອາລັ່ອຮ ຣານະ ກັອຍ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","\"ນານ່ະ ເຍືາ ກູອ໌ ເກົາ ປາຍ: 'ອຶນເຈົາ ເອີຍ! ອຶນເຈົາ ເອີຍ!' ມາ ເຍືາ ຕາ ເບີນ ຊາງັດ ມັຮ ປັຣນາຍ ເກົາ ອາຕີ? ");
INSERT INTO ncq_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ກວາຍ ອາແລ່ະ ມາ ແຕີ່ອ໌ ປໍ ເກົາ, ເຈີ່ ຊັອງ ປັຣນາຍ ເກົາ, ກະ ຕະ ປວາຍ ມັຮ ປັຣນາຍ ເກົາ, ກວາຍ ກັອຍ ລາ ນ່ະ ອຶນເຕົ່າ? ");
INSERT INTO ncq_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ກວາຍ ກັອຍ ລາ ນ່ະ ກວາຍ ຕະ ດຸງ. ອັນ ປິ່ ປຣຸ່ງ ໂອນ ອຶນຕຣູ່ ກະ ໂຈະ ຕາເມົາ ຕຶ່ງ ກັອຍ ໂອນ ຕາໂນລ ແກີດ ຈັບ. ພໍກາ ແຕີ່ອ໌ ແດີອ໌ ປື່ດ, ແດີອ໌ ກັອຍ ກຼຸ່ຮ ດຸງ ກັອຍ, ມາ ດຸງ ກັອຍ ຕາ ເບີນ ຣາໄມ່, ຍ່ອນ ກວາຍ ກັອຍ ໂຈະ ຕາເມົາ ຕະ ໂອນ ຈັບ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ມາ ອັນ ກາ ຊັອງ ປັຣນາຍ ເກົາ, ມາ ອັນ ຕາ ເບີນ ຕະ ປວາຍ, ກວາຍ ກັອຍ ລາ ນ່ະ ມານະ ກາ ຕະ ດຸງ ຕຶ່ງ ກູແຕອ໌ ເມືາດ. ອັນ ປິ່ ປຣຸ່ງ ມາ ອຶນເຕີ່ລ, ກະ ອັນ ຕາ ເບີນ ໂຈະ ຕາເມົາ ຕຶ່ງ ປຣຸ່ງ ກັອຍ. ພໍກາ ແຕີ່ອ໌ ແດີອ໌ ປື່ດ, ແດີອ໌ ກັອຍ ກຼຸ່ຮ ດຸງ ກັອຍ ຮັບ ລາລື່, ເຈີ່ ດຸງ ກັອຍ ແດິມ ກະ ຣາລຸຮ ອຶນແຍ່ະ ເລີ່ຍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ແວັດ ເຢຊູ ປາຍ ອຶນແຍ່ະ ປັຣນາຍ ກັອຍ ໂຈະ ມັຮ ກວາຍ, ອັນ ມູ່ດ ຕຶ່ງ ເມືອງ ກາເປນາອູມ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ແອີດ ຕຶ່ງ ເມືອງ ກັອຍ ເບີນ ມານະ ກວາຍ ໂຣມ ກາ ຕະ ຊົດ ມວຍ ຣ່ອຍ ນະ ຕາຮານ. ເນືາຍ ຕາຮານ ກັອຍ, ເບີນ ກວາຍ ຕະ ຣານະ ກາ ອັນ ອາໂຢ່ະ ລາລື່. ມາ ກວາຍ ກັອຍ ອາອີ່ ຊາປັ່ລ, ແຈ່ະ ອີ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ພໍກາ ເນືາຍ ຕາຮານ ກັອຍ ຊັອງ ເນົ່າ ປາຍ ແຕ ເຢຊູ, ອັນ ແປຣີ ກວາຍ ເທົາແກ ຈຸ່ມ ອິດຊະຣາເອລ ເປາະ ປໍ ເຢຊູ ກະ ແຊອ໌ ເຢຊູ ເປາະ ປົວ ກວາຍ ກາ ຕະ ຣານະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ໄລ່ ກັອຍ ເປາະ ປໍ ເຢຊູ, ເຈີ່ ແຊອ໌ ອຶນແຍ່ະ ຣາງຶ່ຮ ຣາແຮີ ໄລ່ ປາຍ: \"ອັນ ກາ ເນືາຍ ຕາຮານ ຮິ ກັອຍ, ແຊອ໌ ໂອນ ອາຈານ ຈ່ອຍ ອັນ, ຍ່ອນ ອັນ ລາ ກວາຍ ມັນຕັ່ດ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ອັນ ອາໂຢ່ະ ລາລື່ ໄຮ ກວາຍ ອິດຊະຣາເອລ, ກະ ອັນ ຕະ ດຸງ ຊາງ ໂອນ ຮິ ແຮີ.\" ");
INSERT INTO ncq_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ເຈີ່ ເຢຊູ ເປາະ ກະ ໄລ່. ແຈ່ະ ອີ ແຕີ່ອ໌ ປໍ ດຸງ, ກວາຍ ເນືາຍ ຕາຮານ ກັອຍ ແປຣີ ເຢົ່າ ອັນ ເປາະ ປໍ ເຢຊູ ປາຍ: \"ອຶນເຈົາ ເອີຍ, ເກົາ ຕາ ຍັ່ນ ເປາະ ອີດ ອຶນເຈົາ ໂອນ ມູ່ດ ປໍ ດຸງ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ກະ ເກົາ ຄຶ່ດ ເກົາ ຕາ ເບີນ ປຍາຍ໌ ເປາະ ປໍ ອຶນເຈົາ. ມາ ເກົາ ແຊອ໌ ອຶນເຈົາ ປາຍ ຊັອງ, ເຈີ່ ກວາຍ ຕະ ຣານະ ເກົາ ແກີດ ແບຣັຮ. ");
INSERT INTO ncq_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ຍ່ອນ ເກົາ ເບີນ ກວາຍ ກາ ຊົດ ເກົາ, ກະ ເກົາ ລາ ຕະ ຊົດ ເຕ່ ກວາຍ ການໍ່ອ໌. ຄັນ ເກົາ ແປຣີ ກວາຍ ໄນ່: 'ເປາະ!' ອັນ ເປາະ. ຄັນ ເກົາ ແປຣີ ກວາຍ ກັອຍ: 'ແຕີ່ອ໌ ປໍ ໄນ່!' ອັນ ແຕີ່ອ໌. ຄັນ ເກົາ ແປຣີ ກວາຍ ກາ ຕະ ຣານະ ເກົາ: 'ຕະ ນ່ະໄນ່!' ອັນ ຕະ.\" ");
INSERT INTO ncq_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ພໍກາ ເຢຊູ ຊັອງ ປັຣນາຍ ກັອຍ, ອັນ ຊັອງ ງຶ່ດ ລາລື່ ຕຶ່ງ ຣາງຶ່ຮ ອັນ. ກະ ອັນ ປາຍ ໂຈະ ໄລ່ ກວາຍ ການໍ່ອ໌ ກາ ແອີດ ອຶມແປຣ ອັນ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ເກົາ ຕາ ເກີ່ຍ ເຮີມ ອາແລ່ະ ແຕ ກວາຍ ອິດຊະຣາເອລ ມາ ຊາອຳ ເຣ່ງ ນ່ະ ກວາຍ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ມັຮ ກວາຍ ເນືາຍ ຕາຮານ ກັອຍ ແປຣີ ເປາະ ປໍ ເຢຊູ, ໄລ່ ເຈົາ ລັ່ຮ ປໍ ດຸງ ກວາຍ ເນືາຍ ຕາຮານ. ເຈີ່ ໄລ່ ເຮີມ ອັນ ກາ ຕະ ຣານະ ເນືາຍ ຕາຮານ ແກີດ ແບຣັຮ. ");
INSERT INTO ncq_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ແວັດ ກັອຍ ຕາ ເບີນ ດູ່ນ, ເຢຊູ ມູ່ດ ຕຶ່ງ ວີ່ລ ນາອິນ. ມູ່ ກາ ຣຍານ ແຕ ອັນ ກະ ກຼຶ່ງ ກວາຍ ການໍ່ອ໌ ແຮີ ເປາະ ກະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ພໍກາ ເຢຊູ ແຕີ່ອ໌ ປໍ ປັຣລັອຮ ກູຕົ່ງ ວຍາງ ວີ່ລ ກັອຍ, ປຍາຍ໌ ເນົ່າ ກຣາງ ອາລັ່ອຮ ກວາຍ ກູຈີດ. ກວາຍ ກາ ກູຈີດ ກັອຍ ລາ ກອນ ອຶມເປ່ອ໌ ກູມາຍ. ອັນ ເບີນ ມານຳ ກອນ ຣາເລົາ ກັອຍ ແຕິ່. ເບີນ ກຼຶ່ງ ກວາຍ ການໍ່ອ໌ ແຕ ວີ່ລ ກັອຍ ເປາະ ມັນຕຸ ກະ ອຶມເປ່ອ໌ ກູມາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ພໍກາ ເຢຊູ ເຮີມ ອຶມເປ່ອ໌ ກູມາຍ ກັອຍ, ອັນ ຊັອງ ອາໂຢ່ະ ຕະ, ກະ ອັນ ປາຍ: \"ໄມ່ ອຶນໂຈຍ ເຍືາມ.\" ");
INSERT INTO ncq_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ອັນ ແຕີ່ອ໌ ຊາປ່ະ ຈຸ່ງຈາງ ກູມູ່ຍ໌ ກັອຍ; ເຈີ່ ກວາຍ ກາ ກຣາງ ຈຸ່ງຈາງ ກັອຍ ຕາງິ່ດ. ເຢຊູ ປາຍ: \"ອາແອມ ເອີຍ! ເກົາ ໂອນ ໄມ່ ຢວຣ!\" ");
INSERT INTO ncq_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ອັນ ກາ ກູຈີດ ກັອຍ ຢວຣ ຕາກູ ກະ ຕາແບິ ຕະ ອຶນຕີ ລັ່ຮ. ເຈີ່ ເຢຊູ ມ່ອບ ອັນ ໂອນ ລັ່ຮ ປໍ ອຶມເປ່ອ໌ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ອຶນແຍ່ະ ມັຮ ກວາຍ ກັອຍ ຊັອງ ອຶງກັອຮ ລາລື່ ກະ ໄລ່ ຍ່ອງ ເຢືາງ ເຈົາຣາຊີ. ໄລ່ ປາຍ: \"ເບີນ ມານະ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ກາ ປື່ດ ລາລື່ ແຕີ່ອ໌ ປໍ ໄຮ ເຈີ່!\" ກະ ໄລ່ ປາຍ ແອັນ: \"ເຢືາງ ເຈົາຣາຊີ ແຕີ່ອ໌ ຈ່ອຍ ອາມົ່ງ ມັຮ ກອນແຊມ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ຣານະ ເຢຊູ ຕະ ໄນ່ ດັອຮແດີນ ກູ່ ອຶນຕຸ ຕຶ່ງ ແຄງ ຢູດາຍ ກະ ກູ່ ອຶນຕຸ ແອີດ ອຶມແປຣ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ມູ່ ກາ ຣຍານ ແຕ ໂຢຮັນ ເປາະ ອາຕີ ໂຢຮັນ ອຶນແຍ່ະ ມັຮ ຣານະ ໄລ່ ເຮີມ ເຢຊູ ຕະ. ໂຢຮັນ ກູອ໌ ບາຣ ນະ ແຕ ມູ່ ກາ ຣຍານ ແຕ ອັນ, ");
INSERT INTO ncq_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ກະ ອັນ ແປຣີ ໄລ່ ເປາະ ຕາແບີບ ເຢຊູ ປາຍ: \"ອາຈານ ເອີຍ! ປຍາຍ໌ ມາ ຕາ ເບີນ, ອາຈານ ລາ ມານະ ກາ ເຢືາງ ເຈົາຣາຊີ ຣຽຮ ໂອນ ຈ່ອຍ ອາມົ່ງ ອຶນແຍ່ະ ມັຮ ກວາຍ? ແຕີລາ ອຶງເຄາະ ຮິ ອຶງກ່ອງ ກວາຍ ການໍ່ອ໌ ແອັນ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ພໍກາ ໄລ່ ບາຣ ນະ ແຕີ່ອ໌ ປໍ ເຢຊູ, ໄລ່ ປາຍ: \"ໂຢຮັນ ກາ ເກີ່ຍ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ແປຣີ ຮິ ແຕີ່ອ໌ ຕາແບີບ ອາຈານ ປາຍ: 'ເມ່ນ ມາ ຕາ ເບີນ, ອາຈານ ລາ ມານະ ກາ ເຢືາງ ເຈົາຣາຊີ ຣຽຮ ໂອນ ຈ່ອຍ ອາມົ່ງ ອຶນແຍ່ະ ມັຮ ກວາຍ? ແຕີລາ ອຶງເຄາະ ຮິ ອຶງກ່ອງ ກວາຍ ການໍ່ອ໌ ແອັນ ບໍ?'\" ");
INSERT INTO ncq_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ບັອງ ກາ ໄລ່ ອຶນນັ່ອງ ແອີດ ປໍ ກັອຍ, ເຢຊູ ປົວ ຊາອຶ່ຍ ຣາມຶ່ຮ ກວາຍ ອາອີ່, ກວາຍ ເບີນ ອາອີ່ ຊາຣີ່, ກະ ກວາຍ ກາ ເບີນ ເຢືາງ ຕາ ອໍ ແຮີ. ກະ ມັຮ ກວາຍ ກາ ຊູດ ມັ່ດ, ອັນ ຕະ ໂອນ ໄລ່ ແກີດ ບຣາງ ລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ເຈີ່ ເຢຊູ ຕາແອີຍ ລັ່ຮ ບາຣ ນະ ມູ່ ກາ ຣຍານ ແຕ ໂຢຮັນ ປາຍ: \"ເຍືາ ເຈົາ ອາຕີ ໂອນ ໂຢຮັນ ມັຮ ຣານະ ກາ ເຍືາ ຊັອງ ກະ ເຍືາ ເຮີມ ເຈີ່. ກວາຍ ຊູດ ມັ່ດ ແກີດ ບຣາງ ລັ່ຮ. ກວາຍ ໂຢດ ເຕ່ອ໌ ເປາະ ລັ່ຮ. ກວາຍ ອາອີ່ ຕູ່ດ ແກີດ ແບຣັຮ ອຶນແຍ່ະ. ກວາຍ ຕຸ່ງ ແກີດ ຊັອງ ລັ່ຮ. ກວາຍ ກາ ກູຈີດ ເຈີ່, ຢວຣ ອາມົ່ງ ລັ່ຮ. ກະ ກວາຍ ກາດີດ ເບີນ ຊັອງ ເຕ່ ປັຣນາຍ ອໍ ແຕ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ບຸ່ນ ລາລື່ ກວາຍ ກາ ຕາ ເບີນ ຕັຮ ຊາອຳ ເກົາ!\" ");
INSERT INTO ncq_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ແວັດ ມູ່ ກາ ຣຍານ ແຕ ໂຢຮັນ ເຈົາ ລັ່ຮ ປໍ ອັນ, ເຢຊູ ອາຕີ ແຕ ໂຢຮັນ ໂອນ ກວາຍ ກຼຶ່ງ ກັອຍ ຊັອງ. ອັນ ຕາແບີບ ໄລ່ ປາຍ: \"ພໍກາ ເຍືາ ເປາະ ຣາມົຮ ໂຢຮັນ ຕຶ່ງ ຕຍາຮ, ອຶນເຕົ່າ ເຍືາ ຢໍອ໌ ອີ ເຮີມ ຕຶ່ງ ອຶນຕຸ ກັອຍ? ເຍືາ ຢໍອ໌ ອີ ເຮີມ ກູຢາລ ແປຼິ່ ບັດ ຕາຕຶ່ງ ຕາໂຕະ ບໍ? ");
INSERT INTO ncq_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ມາ ເຍືາ ເປາະ, ເຍືາ ຢໍອ໌ ອີ ເຮີມ ອຶນເຕົ່າ? ເຍືາ ຢໍອ໌ ອີ ເຮີມ ມານະ ແຊິບ ອາຢັ່ອຮ ອໍ ບໍ? ໄລ່ ກາ ແຊິບ ອາຢັ່ອຮ ອໍ ກະ ຕັອກ ຈາ ປຣຍາອ໌, ໄລ່ ກັອຍ ແອີດ ຕຶ່ງ ດຸງ ເຕືາວ ປັຣເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ມາ ອຶນເຕົ່າ ເຍືາ ຢໍອ໌ ອີ ເຮີມ ຕຶ່ງ ອຶນຕຸ ກັອຍ? ເຍືາ ຄຶ່ດ ຢໍອ໌ ອີ ເຮີມ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ບໍ? ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ໂຢຮັນ ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ເຕ່, ມາ ອັນ ເບີນ ອຳນາດ ປື່ດ ກາເລີຍ ອຶນແຍ່ະ ແຕ ກວາຍ ການໍ່ອ໌ ກາ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ, ກວາຍ ຄຽນ ເຈີ່ ມັຮ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ອຶນໂຍ່ງ ແຕ ໂຢຮັນ ປາຍ: 'ເກົາ ອີ ແປຣີ ກວາຍ ກາ ເດີງ ປັຣນາຍ ເກົາ ແຕີ່ອ໌ ອຶນໂຍ່ງ ໄມ່. ອັນ ອີ ຈັຮ ຣານາ ໂອນ ໄມ່.' ");
INSERT INTO ncq_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ເກົາ ອາຕີ ເຍືາ, ມັຮ ກູ່ ນະ ກວາຍ ກາ ມັນແຊມ ຣັ່ຮ ຕຶ່ງ ກູແຕອ໌ ໄນ່, ຕາ ເບີນ ເນົ່າ ປື່ດ ກາເລີຍ ແຕ ໂຢຮັນ, ອັນ ກາ ເກີ່ຍ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌. ມາ ເກົາ ອາຕີ ເຍືາ ແອັນ: ກວາຍ ອາແລ່ະ ມາ ຕາ ເບີນ ປື່ດ ອຶນເຕົ່າ ຕຶ່ງ ມູ່ ກາ ເຢືາງ ເຈົາຣາຊີ ຊົດ, ເຢືາງ ເຈົາຣາຊີ ໂອນ ກວາຍ ກັອຍ ເບີນ ອຳນາດ ກາເລີຍ ແຕ ໂຢຮັນ ເບີນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ອຶນແຍ່ະ ມັຮ ກວາຍ ກາ ຊັອງ ປັຣນາຍ ກັອຍ, ກາ ກວາຍ ປາໂຣມ ປຣະ ປາຊີ, ອຶນແຍ່ະ ໄລ່ ກັອຍ ງີ່ນ ເຢືາງ ເຈົາຣາຊີ ລາ ຕານັ່ອງ ອໍ, ຍ່ອນ ແຕ ອຶນໂຍ່ງ ໂຢຮັນ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ມາ ມັຮ ກວາຍ ພາຣີຊາຍ ກະ ກວາຍ ອາຕີ ຄານອດ ໂມເຊ, ໄລ່ ຕາ ຢໍອ໌ ອີ ອີດ ຣານະ ອໍ ກາ ເຢືາງ ເຈົາຣາຊີ ອີ ໂອນ ປໍ ໄລ່. ຍ່ອນ ນ່ະກັອຍ ແຕ ໄລ່ ຕາ ໂອນ ໂຢຮັນ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ເຢຊູ ປາຍ ແອັນ: \"ອຶນເຕົ່າ ເກົາ ເຕ່ອ໌ ຊາກຳ ມັຮ ກວາຍ ແອີດ ຕຶ່ງ ແດີຍ ໄນ່? ໄລ່ ລາ ນ່ະ ອຶນເຕົ່າ? ");
INSERT INTO ncq_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ໄກຣ ລາລື່ ມັຮ ກວາຍ ແອີດ ຕຶ່ງ ແດີຍ ໄນ່ ລາ ນ່ະ ກັຣແນນ ແອີດ ຣາເຈ່າະ ຕຶ່ງ ຕາລາດ. ມູ ຈຸ່ມ ກັຣແນນ ກັອຍ ກູອ໌ ເຢົ່າ ໄລ່, ປາຍ: 'ຮິ ປຼົງ ຕາຣີລ ເຈີ່ ຣາເຈ່າະ ຕະ ເຊີບ ດົນຕີ. ມາ ເຍືາ ຕາ ເບີນ ມູ່ດ ອາເຢີນ ກະ ອຶມປ່ອນ ບຼະໆ ກະ ຮິ! ກະ ຮິ ຣາເຈ່າະ ຕະ ຣາເປີບ, ມາ ເຍືາ ຕາ ເບີນ ປຣ່ອມ ມູ່ດ ເຍືາມ ກູໂກຼຍ໌ ກະ ຮິ!' ");
INSERT INTO ncq_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ໂຢຮັນ ກາ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ແຕີ່ອ໌ ປໍ ໄນ່ ຕາ ເບີນ ງ່ອຍ໌ ຈາ ນ່ະ ກວາຍ ການໍ່ອ໌, ເຈີ່ ເຍືາ ປາຍ ອັນ ລາ ກວາຍ ຢຸ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ມາ ເກົາ, ລາ ກອນ ເຢືາງ ແກີດ ກວາຍ, ແຕີ່ອ໌ ງ່ອຍ໌ ຈາ ມູເຈິງ ກວາຍ ການໍ່ອ໌ ເຕ່, ເຈີ່ ເຍືາ ປາຍ ເກົາ ນ່ະໄນ່: 'ຕິຮ! ອັນ ກັອຍ ຢໍອ໌ ອີ ງ່ອຍ໌ ຈາ ກຸມປູ່ຣ ຊັອງ! ກະ ອັນ ແກີດ ເຢົ່າ ກະ ກວາຍ ກາ ປາໂຣມ ປຣະ ປາຊີ ກະ ກວາຍ ໂລ່ຍຮ ການໍ່ອ໌ ແຮີ!' ");
INSERT INTO ncq_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ມາ ກວາຍ ອາແລ່ະ ກາ ຣັ່ນ ຣາໄງ່ອ໌, ປັຣແນີ ມັນເຕຣືາ ກວາຍ ການໍ່ອ໌ ງີ່ນ ປາຍ ກວາຍ ກັອຍ ລາ ປຍາຍ໌, ຍ່ອນ ໄລ່ ເຮີມ ຣານະ ກວາຍ ກັອຍ ຕະ.\" ");
INSERT INTO ncq_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ເບີນ ມານະ ແຕ ຈຸ່ມ ພາຣີຊາຍ ການື່ຍ ເຢຊູ ແຕີ່ອ໌ ຈາ ມວຍ ເປ່ລ ຕຶ່ງ ດຸງ ອັນ. ເຈີ່ ເຢຊູ ເປາະ ກະ ຕາກູ ຈາ ຊາຢວາງປຣວາງ ມູ ກາແກງ. ");
INSERT INTO ncq_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ແອີດ ຕຶ່ງ ເມືອງ ກັອຍ ເບີນ ມານະ ມັນແຊມ ກາ ຕະ ຊາອຶ່ຍ ຣານະ ໂລ່ຍຮ. ອັນ ຊັອງ ເນົ່າ ປາຍ ເຢຊູ ຈາ ຕຶ່ງ ດຸງ ກວາຍ ພາຣີຊາຍ ກັອຍ, ເຈີ່ ອັນ ເດີງ ມວຍ ກອງ ແດີອ໌ ປາຮວມ. ກອງ ກັອຍ ເນົ່າ ຕະ ແຕ ຕາເມົາ ກາ ເບີນ ຣາມຶ່ຮ 'ອາລາບາດ.' ");
INSERT INTO ncq_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ມັນແຊມ ກັອຍ ແຕີ່ອ໌ ຕາຢຶ່ງ ແຈ່ະ ອາເຢີງ ເຢຊູ. ອັນ ເຍືາມ, ກະ ຊັຣລັ່ງ ມັ່ດ ອັນ ຮອຍ ລາຢັບ ອຶນແຍ່ະ ອາເຢີງ ເຢຊູ. ເຈີ່ ອັນ ຈູ່ດ ອາເຢີງ ເຢຊູ ແຕ ໂຊະ ອັນ. ອັນ ໂຮນ ອາເຢີງ ເຢຊູ, ເຈີ່ ອັນ ທໍອ໌ ແດີອ໌ ປາຮວມ ຕຶ່ງ ອາເຢີງ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ພໍກາ ກວາຍ ພາຣີຊາຍ ກາ ການື່ຍ ເຢຊູ ເຮີມ ຣານະ ກັອຍ, ອັນ ຄຶ່ດ ຕຶ່ງ ຣາງຶ່ຮ ອັນ ປາຍ: \"ຄັນ ກວາຍ ໄນ່ ມາ ມານະ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ອັນ ດັງ ມັນແຊມ ກາ ຊາປ່ະ ອັນ ລາ ກວາຍ ອຶນເຕົ່າ. ອັນ ລາ ມັນແຊມ ກາ ຕະ ຊາອຶ່ຍ ຣານະ ໂລ່ຍຮ.\" ");
INSERT INTO ncq_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ເຢຊູ ອາຕີ ນ່ະໄນ່ ໂຈະ ກວາຍ ກັອຍ: \"ຊີໂມນ ເອີຍ! ເກົາ ເບີນ ມວຍ ປັຣນາຍ ຢໍອ໌ ອີ ອາຕີ ໄມ່.\" ຊີໂມນ ຕາແອີຍ: \"ເອີອ໌, ອາຈານ. ແຊອ໌ ອາຈານ ອາຕີ ເລີ່ຍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ເຈີ່ ເຢຊູ ປາຍ: \"ເບີນ ບາຣ ນະ ລັບ ປຣະ ແຕ ກວາຍ ກາ ອຶນເຈົາ ປຣະ. ມານະ ຕູ່ ເຊີງ ຣ່ອຍ ກຼອງ ປຣະ ອານາມ. ມານະ ຕູ່ ເຊີງ ຈິ່ດ. ");
INSERT INTO ncq_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ບາຣ ນະ ກັອຍ, ໄລ່ ຕາ ເບີນ ອຶນເຕົ່າ ອີ ກູລັຮ ລັ່ຮ ປຣະ ອັນ ກາ ອຶນເຈົາ ກັອຍ. ນ່ະກັອຍ ອັນ ຕັຮ ອຶນແຍ່ະ ປຣະ ໄລ່ ຕູ່ ອັນ. ມາ ແຕ ບາຣ ນະ ໄລ່ ກັອຍ, ອາແລ່ະ ອາໂຢ່ະ ກາເລີຍ ອັນ ກາ ອຶນເຈົາ ປຣະ?\" ");
INSERT INTO ncq_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ຊີໂມນ ຕາແອີຍ ປາຍ: \"ເກົາ ຄຶ່ດ ອັນ ກາ ຕູ່ ຊາອຶ່ຍ ກັອຍ, ອາໂຢ່ະ ກາເລີຍ.\" ເຢຊູ ປາຍ: \"ປຍາຍ໌ ໄມ່ ຄຶ່ດ ນ່ະກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ເຈີ່ ເຢຊູ ກູເລືານ ເນ່ ປໍ ມັນແຊມ ກັອຍ ກະ ອັນ ອາຕີ ຊີໂມນ ປາຍ: \"ໄມ່ ເຮີມ, ມາ ຕາ ເບີນ, ມັນແຊມ ໄນ່? ພໍກາ ເກົາ ແຕີ່ອ໌ ປໍ ດຸງ ໄມ່, ໄມ່ ຕາ ເບີນ ໂອນ ແດີອ໌ ອາເຣືາວ ອາເຢີງ. ມາ ມັນແຊມ ໄນ່, ອັນ ອາເຣືາວ ອາເຢີງ ເກົາ ແຕ ຊັຣລັ່ງ ມັ່ດ ອັນ. ກະ ອັນ ອີດ ໂຊະ ອັນ ຈູ່ດ ອາເຢີງ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ພໍກາ ເກົາ ແຕີ່ອ໌ ປໍ ດຸງ ໄມ່, ໄມ່ ຕາ ເບີນ ໂຮນ ເກົາ ປວາຍ ຕຶ່ງ ຣີ່ດ ຊາອົຮ ຕາມອຍ. ມາ ມັນແຊມ ໄນ່, ອັນ ໂຮນ ອາເຢີງ ເກົາ ແຕ ເກົາ ມູ່ດ ຕຶ່ງ ດຸງ ເຕົ່າ ແຕີ່ອ໌ ຊານໍ່. ");
INSERT INTO ncq_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ໄມ່ ຕາ ເບີນ ອີດ ອຶນຊີ່ງ ອາໂປ່ນ ເຕືາ ຕຶ່ງ ແປຼີ ເກົາ ປວາຍ ຕຶ່ງ ຣີ່ດ ຣັ່ບ ຕາມອຍ. ມາ ມັນແຊມ ໄນ່, ອັນ ທໍອ໌ ແດີອ໌ ປາຮວມ ລາເກືາ ເປ່ງ ລາລື່ ຕຶ່ງ ອາເຢີງ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ນ່ະກັອຍ ເກົາ ອາຕີ ໄມ່: ໂລ່ຍຮ ມັນແຊມ ໄນ່ ລາ ຊາອຶ່ຍ ລາລື່, ມາ ເກົາ ຕັຮ ເຈີ່, ຍ່ອນ ອັນ ອາໂຢ່ະ ລາລື່ ເກົາ. ມາ ອັນ ກາ ຄຶ່ດ ອັນ ເບີນ ໂລ່ຍຮ ບີ່ອ໌ ຊັອງ ໂອນ ເກົາ ຕັຮ, ກວາຍ ກັອຍ ອາໂຢ່ະ ເກົາ ບີ່ອ໌ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ເຈີ່ ເຢຊູ ອາຕີ ໂຈະ ມັນແຊມ ກັອຍ ປາຍ: \"ໂລ່ຍຮ ໄມ່ ເກົາ ຕັຮ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ມັຮ ກວາຍ ກາ ແອີດ ຈາ ກະ ເຢຊູ, ໄລ່ ມານະ ຕາແບີບ ມານະ ປາຍ: \"ກວາຍ ໄນ່ ລາ ເນົ່າ, ມາ ຍັ່ນ ອັນ ປາຍ ເຕ່ອ໌ ອັນ ຕັຮ ໂລ່ຍຮ ກວາຍ?\" ");
INSERT INTO ncq_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ມາ ເຢຊູ ອາຕີ ລັ່ຮ ໂຈະ ມັນແຊມ ກັອຍ ປາຍ: \"ຍ່ອນ ໄມ່ ຊາອຳ, ເຢືາງ ເຈົາຣາຊີ ຈ່ອຍ ອາມົ່ງ ໄມ່ ເຈີ່. ໄມ່ ເປາະ ໂອນ ບັນຊວານ ອຽນ ອໍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ແວັດ ກັອຍ, ເຢຊູ ມູ່ດ ຊາອຶ່ຍ ວີ່ລ ຊາອຶ່ຍ ເມືອງ ອາຕີ ປັຣນາຍ ອໍ ແຕ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ຕຶ່ງ ຣາງຶ່ຮ ກວາຍ. ມວຍ ຈິ່ດ ລາ ບາຣ ນະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ເປາະ ມັນຕຸ ກະ ອັນ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ກະ ເບີນ ມັຮ ກວາຍ ມັນແຊມ ແຮີ ເປາະ ມັນຕຸ ກະ ເຢຊູ. ແຕ ມັນແຊມ ກັອຍ ເບີນ ໄລ່ ກາ ເຢຊູ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ແຕ ອຶນໂຍ່ງ, ກະ ເບີນ ໄລ່ ກາ ອັນ ປົວ ແຕ ຊາອຶ່ຍ ຣາມຶ່ຮ ອາອີ່ ການໍ່ອ໌ ແຮີ. ແຕ ມັນແຊມ ກັອຍ ເບີນ ມານະ ຣາມຶ່ຮ ມາຣີ ແຕ ວີ່ລ ມັກດາລາ. ເບີນ ຕາປູ່ລ ເຢືາງ ຕາ ອໍ ລັ່ອຮ ແຕ ຈະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ບາຣ ລາ ໂຢຮັນນາ, ລາກວຍ ຈູຊາ. ຈູຊາ ລາ ກວາຍ ກາ ກຍາອ໌ ເກຣີ່ງ ດຸງ ເຕືາວ ປັຣເຍືາ ເຮໂຣດ. ໄປ ລາ ຊູຊັນນາ. ກະ ເບີນ ກຼຶ່ງ ກວາຍ ມັນແຊມ ການໍ່ອ໌ ແຮີ. ອຶນແຍ່ະ ໄລ່ ກັອຍ ອີດ ປຣະ ໄລ່ ເບີມ ຈ່ອຍ ໂອນ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ເບີນ ເກຣີ່ງ ຊັຣນາ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ກຼຶ່ງ ລາລື່ ກວາຍ ແຕີ່ອ໌ ປໍ ເຢຊູ ແຕ ຊາອຶ່ຍ ເມືອງ. ເຈີ່ ເຢຊູ ອາຕີ ໄລ່ ກັອຍ ປັຣນາຍ ຊາກຳ ນ່ະໄນ່: ");
INSERT INTO ncq_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","\"ເບີນ ມານະ ກວາຍ ເປາະ ຕຣຶ່ຮ ກູປຼູອ໌. ພໍກາ ອັນ ຕຣຶ່ຮ, ເບີນ ກຼອງ ກາ ຊາແລັຮ ຕຶ່ງ ຣານາ. ກວາຍ ຊາເຕືາຍ໌ ກຼອງ ກັອຍ ກະ ແຈມ ຕອດ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ເບີນ ກຼອງ ກາ ຊາແລັຮ ຕຶ່ງ ກູແຕອ໌ ກາດາ ເບີນ ຕາຕາຣ ປື່ນ ກູແຕອ໌. ພໍກາ ກຼອງ ກັອຍ ດັຮ, ອັນ ແກີດ ຣັ່ອຮ ກູຈີດ, ຍ່ອນ ແອິ ແດີອ໌. ");
INSERT INTO ncq_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ເບີນ ກຼອງ ກາ ຊາແລັຮ ຕຶ່ງ ກູແຕອ໌ ກາ ເບີນ ເຣ່ຮ ຊັຣເລືາ. ພໍກາ ຊັຣເລືາ ກັອຍ ດັຮ, ອັນ ຣິ່ ດໍອ໌ ຊັຣນົຮ ກາ ຕາແບິ ດັຮ ແຕ ກຼອງ ກວາຍ ກັອຍ ຕຣຶ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ກະ ເບີນ ກຼອງ ການໍ່ອ໌ ແອັນ ຊາແລັຮ ຕຶ່ງ ກູແຕອ໌ ອໍ. ກຼອງ ກັອຍ ດັຮ ອາຊັອຮ ແກີດ ປາໄລ ອໍ. ມວຍ ກຼອງ ເບີນ ລັ່ຮ ມວຍ ຣ່ອຍ ກຼອງ.\" ເຢຊູ ປາຍ ແອັນ ນ່ະໄນ່: \"ອາແລ່ະ ກາ ເບີນ ກູຕູຣ, ໂອນ ອັນ ຊາງັດ ເບີມ.\" ");
INSERT INTO ncq_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ມັຮ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ຕາແບີບ ລັ່ຮ ອັນ ປັຣນາຍ ໄນ່ ລາ ຊາກຳ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ອຶນແຍ່ະ ມັຮ ປັຣນາຍ ປາໂຕ່ະ ແຕ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ຕຶ່ງ ຣາງຶ່ຮ ກວາຍ, ເຢືາງ ເຈົາຣາຊີ ໂອນ ເຍືາ ດັງ. ມາ ກວາຍ ການໍ່ອ໌ ຊັອງ ແອີງ ປັຣນາຍ ຊາກຳ ຊັອງ. ນ່ະກັອຍ 'ໄລ່ ເນ່ ມາ ຕາ ເບີນ ເຮີມ, ກະ ໄລ່ ຊາງັດ ມາ ຕາ ເບີນ ຊາປຸ່ຮ.'\" ");
INSERT INTO ncq_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","\"ປັຣນາຍ ຊາກຳ ໄນ່ ລາ ນ່ະໄນ່: ກູປຼູອ໌ ກາ ກວາຍ ຕຣຶ່ຮ ລາ ຊາກຳ ແຕ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ກຼອງ ຊາແລັຮ ຕຶ່ງ ຣານາ ລາ ຊາກຳ ແຕ ກວາຍ ກາ ຊັອງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ມາ ເຢືາງ ຊາຕານ ແຕີ່ອ໌ ເຣືາດ ອີດ ປັຣນາຍ ກັອຍ ແຕ ຣາງຶ່ຮ ກວາຍ ກັອຍ ໂອນ ໄລ່ ຕາ ເຕ່ອ໌ ຊາອຳ, ກະ ໂອນ ເຢືາງ ເຈົາຣາຊີ ຕາ ເຕ່ອ໌ ຈ່ອຍ ອາມົ່ງ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ກຼອງ ກາ ຊາແລັຮ ຕຶ່ງ ກູແຕອ໌ ກາດາ ເບີນ ຕາຕາຣ ປື່ນ ກູແຕອ໌ ລາ ຊາກຳ ແຕ ກວາຍ ກາ ຊັອງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ກະ ປຣ່ອມ ຊາອຳ ປັຣນາຍ ກັອຍ ຣໍ່ອ໌ ອໍ. ມາ ໄລ່ ແອິ ເຣ່ຮ ອຶນຕຣູ່. ໄລ່ ຊາອຳ ມາໂຮຍ ຊັອງ. ແຕີ່ອ໌ ໄລ່ ຣາມົຮ ຕຸ່ຮ ກັ່ດ, ເຈີ່ ໄລ່ ຕັຮ ຕາ ແອອ໌ ອີ ຊາອຳ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ກຼອງ ກາ ຊາແລັຮ ຕຶ່ງ ກູແຕອ໌ ກາ ເບີນ ຊັຣເລືາ ຊາກຳ ແຕ ກວາຍ ກາ ຊັອງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ມາ ຣາບູລ ຣານະ ຕຶ່ງ ແດີຍ ໄນ່, ຢໍອ໌ ອີ ຊຸ, ກະ ຢໍອ໌ ອີ ປຣຍາອ໌, ມູ່ດ ຕຶ່ງ ຣາງຶ່ຮ ໄລ່. ມັຮ ກາ ຣາມຶ່ຮ ກັອຍ ຣິ່ ດໍອ໌ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ຕະ ໂອນ ປາໄລ ໄລ່ ຕາ ເບີນ ແກີດ ຈີນ. ");
INSERT INTO ncq_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ມາ ກຼອງ ກາ ຊາແລັຮ ຕຶ່ງ ກູແຕອ໌ ອໍ ຊາກຳ ແຕ ກວາຍ ກາ ຊັອງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ກະ ໄລ່ ເບີນ ຣາງຶ່ຮ ຕານັ່ອງ ອໍ, ຢໍອ໌ ອີ ຊາງັດ ປວາຍ ຣານະ ເຢືາງ ເຈົາຣາຊີ. ໄລ່ ເຈີ ດໍອ໌ ປັຣນາຍ ກັອຍ, ເຈີ່ ແຕີ່ອ໌ ປາເນ່ນ ໄລ່ ແກີດ ປາໄລ ຊາອຶ່ຍ ລາລື່.\" ");
INSERT INTO ncq_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","\"ຕາ ເບີນ ເນົ່າ ຕາກັດ ຕາກຍາງ, ເຈີ່ ອີດ ແຈັຮ ກຣວາອ໌ ແຕີລາ ດໍອ໌ ປື່ນ ກາເຈີ່ງ. ມາ ເນົ່າ ດໍອ໌ ຕາກຍາງ ກັອຍ ຕຶ່ງ ໂຣ່ງ ໂອນ ກູ່ ນະ ກວາຍ ກາ ມູ່ດ ເຕ່ອ໌ ເຮີມ ປັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ມູເຈິງ ກັອຍ ເຕ່, ປັຣນາຍ ອຶນເຕົ່າ ເນົ່າ ປູ່ລ ປາໂຕ່ະ ຊານໍ່, ເຈີ່ ປໍ ເມືາງ ປັຣນາຍ ກັອຍ ເນົ່າ ຕາ ເຕ່ອ໌ ປູ່ລ ປາໂຕ່ະ ນັ່ອງ. ກະ ຣານະ ອຶນເຕົ່າ ເນົ່າ ຕະ ແກຣ່ະ ຊານໍ່, ເຈີ່ ປໍ ເມືາງ ຣານະ ກັອຍ ເນົ່າ ຕາ ເຕ່ອ໌ ຕະ ແກຣ່ະ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","\"ປັຣນາຍ ອຶນເຕົ່າ ເຍືາ ຊັອງ ເກົາ ອາຕີ, ອຶງເຄາະ ເຍືາ ຊາງັດ ໂອນ ອໍ ລາລື່ ປັຣນາຍ ກັອຍ. ກວາຍ ອາແລ່ະ ກາ ເບີນ ເຈີ່, ເກົາ ຈ່ອຍ ກວາຍ ກັອຍ ເບີນ ຊາອຶ່ຍ ລາລື່ ແອັນ. ມາ ກວາຍ ອາແລ່ະ ກາ ຕາ ເບີນ ເບີນ, ມັຮ ຣາມຶ່ຮ ກວາຍ ກັອຍ ຄຶ່ດ ເບີນ ເຈີ່, ແກີດ ປິ່ດ ລັ່ຮ ອຶນແຍ່ະ.\" ");
INSERT INTO ncq_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ເບີນ ມວຍ ຕາໄງ ອຶມເປ່ອ໌ ກະ ແຊມອາຍ ເຢຊູ ແຕີ່ອ໌ ຢໍອ໌ ອີ ຣາມົຮ ອັນ, ມາ ໄລ່ ຕາ ເຕ່ອ໌ ແຕີ່ອ໌ ປໍ ອັນ, ຍ່ອນ ກູທັດ ລາລື່ ກວາຍ ຕຶ່ງ ດຸງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ເບີນ ກວາຍ ອາຕີ ເຢຊູ ປາຍ: \"ອຶມເປ່ອ໌ ກະ ແຊມອາຍ ອາຈານ ແອີດ ຢັ່ຮ ນໍ່ອ໌. ໄລ່ ຢໍອ໌ ອີ ຣາມົຮ ອາຈານ.\" ");
INSERT INTO ncq_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ມາ ເຢຊູ ອາຕີ ລັ່ຮ ໄລ່ ປາຍ: \"ອຶມເປ່ອ໌ ກະ ແຊມອາຍ ເກົາ ລາ ອຶນແຍ່ະ ມັຮ ກວາຍ ກາ ຊາງັດ ກະ ຕະ ປວາຍ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ເບີນ ມວຍ ຕາໄງ, ເຢຊູ ຊັອຮ ຕຶ່ງ ຕົວະ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ. ເຢຊູ ປາຍ ໂຈະ ໄລ່: \"ໄຮ ໄກ່ອ໌໌ ຢັ່ຮ ອຶນຕົ່ຮ ທາເລ ຣາປັ່ງ ແອັນ.\" ເຈີ່ ໄລ່ ໄກ່ອ໌໌. ");
INSERT INTO ncq_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ແຕີ່ອ໌ ອຶນດີ ແດີອ໌, ເຢຊູ ບິ. ມາ ເບີນ ກູຢາລ ຣາປູ່ອ໌ ແຕີ່ອ໌ ກຼຸ່ຮ ແດີອ໌ ກັອຍ, ກະ ແດີອ໌ ກັຣຊາຍ໌ ອາມູ່ດ ຕຶ່ງ ຕົວະ ກັອຍ ແຈ່ະ ອີ ລັ່ອງ. ໄລ່ ແຈ່ະ ອີ ເຕຣົາ ເອີຍ໌. ");
INSERT INTO ncq_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ແຕີ່ອ໌ ປໍ ອັນ ກະ ອາໄມ່ຮ ອັນ. ໄລ່ ປາຍ: \"ອາຈານ ເອີຍ, ອາຈານ! ໄຮ ແຈ່ະ ອີ ກູຈີດ ເອີຍ໌.\" ເຢຊູ ຢວຣ ຕາຢຶ່ງ. ອັນ ກາແອັຮ ກູຢາລ ກະ ແດີອ໌ ປ່ອງ ກັອຍ. ເຈີ່ ກູຢາລ ກະ ແດີອ໌ ກັອຍ ຕາງິ່ດ; ເຈີ່ ໄລ່ ເຮີມ ອຽນ ອໍ ລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ເຢຊູ ຕາແບີບ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ນານ່ະ ເລີ່ ເຍືາ ຕາ ເບີນ ຊາອຳ?\" ມາ ໄລ່ ກັອຍ ງຶ່ດ ລາລື່ ກະ ໄລ່ ອຶງກັອຮ. ມານະ ປາຍ ໂຈະ ມານະ: \"ກວາຍ ໄນ່ ລາ ເນົ່າ? ອັນ ກາແອັຮ ກູຢາລ ກະ ແດີອ໌. ເຈີ່ ກູຢາລ ກະ ແດີອ໌ ຊາງັດ ອັນ!\" ");
INSERT INTO ncq_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ໄລ່ ໄກ່ອ໌໌ ທາເລ ຣາປັ່ງ ແຕີ່ອ໌ ປໍ ກຣວາງ ເຄຣາຊາ ແອັນ. ກຣວາງ ເຄຣາຊາ ໄນ່ ແອີດ ຢັ່ຮ ອຶນຕົ່ຮ ທາເລ ຣາປັ່ງ ກັອຍ ກະ ແຄງ ຄາລີເລ. ");
INSERT INTO ncq_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ບັອງ ກາ ເຢຊູ ແຊງ ແຕ ຕົວະ, ເບີນ ມານະ ກວາຍ ຣາເລົາ ແຕ ວີ່ລ ກັອຍ ກາ ເບີນ ເຢືາງ ຕາ ອໍ ຕຣວບ ແຕີ່ອ໌ ຣາມົຮ ອັນ. ດູ່ນ ເຈີ່ ກວາຍ ກັອຍ ແອີດ ອາຈ່ອງ. ອັນ ຕາ ເບີນ ແອີດ ຕຶ່ງ ດຸງ, ອັນ ເປາະ ແອີດ ປໍ ປີ່ງ ກູມູ່ຍ໌. ");
INSERT INTO ncq_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ພໍກາ ອັນ ເຮີມ ເຢຊູ, ອັນ ແຮຣ ເຣ່ງ ລາລື່, ກຼຸ່ ຣາໂກລ, ກະ ອັນ ປາຍ ເຣ່ງ ລາລື່: \"ເຢຊູ ເອີຍ! ອຶນເຕົ່າ ເຍືາ ຢໍອ໌ ອີ ຕະ ໂຈະ ເກົາ? ເຍືາ ລາ ກອນ ເຢືາງ ເຈົາຣາຊີ, ອັນ ກາ ປື່ດ ກາເລີຍ ອຶນແຍ່ະ ແຕ ການໍ່ອ໌. ເກົາ ແຊອ໌ ເຍືາ ອຶນໂຈຍ ຕະ ຕຸ່ຮ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ອັນ ປາຍ ນ່ະກັອຍ, ຍ່ອນ ເຢຊູ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ເຈີ່ ແຕ ຈະ ກວາຍ ກັອຍ. ຊາອຶ່ຍ ຕໍ່ ເຈີ່ ເຢືາງ ຕາ ອໍ ຕະ ກວາຍ ກັອຍ. ກະ ຄັນ ກວາຍ ການໍ່ອ໌ ໂກບ ອັນ ກະ ຊາກັບ ອຶນໄຊ ໂຊ, ແຕີລາ ຊັດ ກາດາຍ ອາຕີ ອັນ ແຕ ອຶນໄຊ ເກຣືາວ, ອັນ ຕະ ຕາອັອຮ ອຶນແຍ່ະ. ກະ ເຢືາງ ຕາ ອໍ ເກີ່ຍ ເດີງ ອັນ ເປາະ ປໍ ຕຍາຮ. ");
INSERT INTO ncq_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ເຢຊູ ຕາແບີບ ກວາຍ ກັອຍ ປາຍ: \"ນານ່ະ ຣາມຶ່ຮ ໄມ່?\" ກວາຍ ກັອຍ ຕາແອີຍ ປາຍ: \"ຣາມຶ່ຮ ເກົາ ລາ ກອງທັບ.\" ອັນ ປາຍ ນ່ະກັອຍ, ຍ່ອນ ເບີນ ຊາອຶ່ຍ ເຢືາງ ຕາ ອໍ ແອີດ ຕຶ່ງ ຈະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ອຶນແຍ່ະ ມັຮ ເຢືາງ ຕາ ອໍ ກັອຍ ແຊອ໌ ແຕ ເຢຊູ ອຶນໂຈຍ ຕູ່ຍຮ ໄລ່ ເປາະ ປໍ ປຣຸ່ງ ອູ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ຕຶ່ງ ກົຮ ກັອຍ ເບີນ ອາລີ່ອ໌ ມວຍ ຈຸ່ມ ຊາອຶ່ຍ ລາລື່ ໄລ່ ບັອງ ຈໍ່ອ໌ ຈາ. ອຶນແຍ່ະ ມັຮ ເຢືາງ ຕາ ອໍ ກັອຍ ກູກຸຮ ແຊອ໌ ແຕ ເຢຊູ ໂອນ ໄລ່ ມູ່ດ ຕຶ່ງ ມັຮ ອາລີ່ອ໌ ກັອຍ. ເຈີ່ ເຢຊູ ໂອນ ໄລ່ ມູ່ດ. ");
INSERT INTO ncq_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ນ່ະກັອຍ ມັຮ ເຢືາງ ຕາ ອໍ ລັ່ອຮ ແຕ ຈະ ກວາຍ ກັອຍ, ມູ່ດ ຕຶ່ງ ຈຸ່ມ ອາລີ່ອ໌ ແອັນ. ເຈີ່ ອຶນແຍ່ະ ມັຮ ອາລີ່ອ໌ ກັອຍ ຕາລຸ່ຮ ໄວ່ ລາລື່ ແຕ ແລັ່ຮ ຕາຣວາລ ອາປັອງ ປໍ ທາເລ ຣາປັ່ງ, ເຈີ່ ກູຈີດ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ກວາຍ ກາ ກຍາອ໌ ຈຸ່ມ ອາລີ່ອ໌ ກັອຍ, ໄລ່ ເຮີມ ອຶນແຍ່ະ ຣານະ ກັອຍ. ເຈີ່ ໄລ່ ຕາລຸ່ຮ ເຈົາ ອາຕີ ມັຮ ກວາຍ ແອີດ ຕຶ່ງ ວີ່ລ ກະ ແອີດ ປໍ ນໍ່ອ໌ ວີ່ລ ດັງ. ");
INSERT INTO ncq_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ກຼຶ່ງ ກວາຍ ແຕີ່ອ໌ ຢໍອ໌ ອີ ເນ່ ຣານະ ກາ ຕາແບິ ແຕີ່ອ໌. ໄລ່ ກັອຍ ແຕີ່ອ໌ ປໍ ເຢຊູ, ກະ ໄລ່ ເຮີມ ກວາຍ ກາ ບັອງ ກັອຍ ເບີນ ເຢືາງ ຕາ ອໍ ຕຣວບ. ອັນ ກັອຍ ຕາກູ ແຈ່ະ ອາເຢີງ ເຢຊູ. ອັນ ຕັອກ ເກຣີ່ງ, ກະ ອັນ ຕາ ເບີນ ແກີດ ຢຸ່ຮ ນັ່ອງ. ເຈີ່ ອຶນແຍ່ະ ກວາຍ ກັອຍ ຊັອງ ອຶງກັອຮ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ມັຮ ໄລ່ ກາ ເຮີມ ເຢຊູ ຕະ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ກັອຍ, ໄລ່ ອາຕີ ລັ່ຮ ໂອນ ກວາຍ ກາ ຕາ ເບີນ ເຮີມ, ໂອນ ໄລ່ ດັງ ເຕ່ ອຶນເຕົ່າ ເຢຊູ ຕະ ໂອນ ກວາຍ ກັອຍ ແກີດ ແບຣັຮ. ");
INSERT INTO ncq_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ມັຮ ກວາຍ ກຼຶ່ງ ແຕ ກຣວາງ ເຄຣາຊາ ແຊອ໌ ເຢຊູ ລັ່ອຮ ແຕ ກຣວາງ ໄລ່, ຍ່ອນ ໄລ່ ອຶງກັອຮ ລາລື່. ເຈີ່ ເຢຊູ ຊັອຮ ຕຶ່ງ ຕົວະ ລັ່ຮ, ລັ່ອຮ ແຕ ອຶນຕຸ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ກວາຍ ກາ ເຢືາງ ຕາ ອໍ ລັ່ອຮ ແຕ ຈະ ອັນ ແຊອ໌ ອີ ເປາະ ອາລຶ່ງ ເຢຊູ ເຕ່. ມາ ເຢຊູ ອາຕີ ໂອນ ອັນ ເຈົາ, ກະ ເຢຊູ ປາຕັບ ອັນ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","\"ໄມ່ ເຈົາ ປໍ ດຸງ ໄມ່. ເຈີ່ ໄມ່ ອາຕີ ລັ່ຮ ແຕ ກູ່ ຣານະ ເຢືາງ ເຈົາຣາຊີ ຈ່ອຍ ໂອນ ໄມ່.\" ນ່ະກັອຍ ກວາຍ ກັອຍ ເປາະ ກູ່ ອຶນຕຸ ຕຶ່ງ ເມືອງ ອັນ, ອັນ ອາຕີ ລັ່ຮ ແຕ ກູ່ ຣານະ ເຢຊູ ຈ່ອຍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ພໍກາ ເຢຊູ ເຈົາ ລັ່ຮ ຢັ່ຮ ກັອຍ ທາເລ ຣາປັ່ງ, ກວາຍ ກຼຶ່ງ ຣາບັນ ອັນ ຣໍ່ອ໌ ອໍ, ຍ່ອນ ໄລ່ ເກຣາະ ອັນ ຕຶ່ງ ອຶນຕຸ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ມາ ເບີນ ມານະ ຣາມຶ່ຮ ຢາອີຣໂຣ ແຕີ່ອ໌ ປໍ ກັອຍ. ອັນ ລາ ກວາຍ ຕາລາ ດຸງ ຊາງ ອິດຊະຣາເອລ ຕຶ່ງ ເມືອງ ກັອຍ. ອັນ ກຼຸ່ ຣາໂກລ ປູບ ແຈ່ະ ອາເຢີງ ເຢຊູ, ກະ ອັນ ແຊອ໌ ໂອນ ເຢຊູ ແຕີ່ອ໌ ປໍ ດຸງ ອັນ, ");
INSERT INTO ncq_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ຍ່ອນ ກອນ ມັນແຊມ ອັນ ອາອີ່ ຮັບ ລາລື່. ກອນ ອັນ ມານຳ ກັອຍ ແຕິ່. ອາຍຸ່ ອັນ ຕາແບິ ມວຍ ຈິ່ດ ລາ ບາຣ ກູມໍ, ມາ ອັນ ອາອີ່ ແຈ່ະ ອີ ກູຈີດ. ບັອງ ກາ ເຢຊູ ເປາະ ຕຶ່ງ ຣານາ, ກຼຶ່ງ ລາລື່ ກວາຍ ເນ່ດ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ກະ ເບີນ ມານະ ມັນແຊມ ແອີດ ຕຶ່ງ ກັອຍ ກາ ເບີນ ອາອີ່ ແກີດ ຮື່. ອຶນແຍ່ະ ມວຍ ຈິ່ດ ລາ ບາຣ ກູມໍ ມາ ຕາ ແກີດ ປຣາຍ ອາຮາມ ກັອຍ. ປຣະ ອັນ ອຶນແຍ່ະ ປິ່ດ ໂອນ ກວາຍ ກາ ປົວ, ມາ ຕາ ເບີນ ແບຣັຮ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ອັນ ປາລັອງ ອາມູ່ດ ຢັ່ຮ ກຣັອງ ເຢຊູ, ເຈີ່ ອາຕີ ອັນ ຕາແວີ ຊາປ່ະ ເປິບ ອາຢັ່ອຮ ເຢຊູ. ບັອງ ກາ ກັອຍ ແຕິ່ ອາຮາມ ຕາ ເບີນ ລັ່ອຮ ນັ່ອງ ແຕ ຈະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ເຢຊູ ຕາແບີບ ປາຍ: \"ເນົ່າ ກາ ຊາປ່ະ ເກົາ?\" ມາ ອາແລ່ະ ລາ ຕາ ເບີນ ງີ່ນ. ກະ ເປໂຕ ປາຍ: \"ອາຈານ ເອີຍ! ກຼຶ່ງ ລາລື່ ກວາຍ ແອີດ ກູທັດ, ກະ ໄລ່ ເນ່ດ ຈະ ອາຈານ.\" ");
INSERT INTO ncq_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ມາ ເຢຊູ ປາຍ ລັ່ຮ ນ່ະໄນ່: \"ເບີນ ກວາຍ ຊາປ່ະ ເກົາ, ຍ່ອນ ເກົາ ຊັອງ ເຣ່ງ ເກົາ ລັ່ອຮ ຈ່ອຍ ກວາຍ ການໍ່ອ໌.\" ");
INSERT INTO ncq_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ນ່ະກັອຍ ມັນແຊມ ກາ ຊາປ່ະ ອາຢັ່ອຮ ກັອຍ, ອັນ ຄຶ່ດ ຕາ ເບີນ ແກຣ່ະ ນັ່ອງ. ອັນ ກາໄກ່ຮ ອຶງກັອຮ ລາລື່, ກະ ອັນ ປູບ ອາແຊງ ຈະ ອັນ ແຈ່ະ ອາເຢີງ ເຢຊູ. ຢັ່ຮ ເມືາງ ກວາຍ ກຼຶ່ງ ກັອຍ, ມັນແຊມ ກັອຍ ງີ່ນ ປໍ ເຢຊູ. ອັນ ອາຕີ ຕານັ່ອງ ໂອນ ເຢຊູ ດັງ ຍ່ອນ ນານ່ະ ແຕ ອັນ ແຕີ່ອ໌ ຊາປ່ະ ອາຢັ່ອຮ ເຢຊູ ກະ ອາອີ່ ອັນ ແກີດ ແບຣັຮ ເລີ່ຍ. ");
INSERT INTO ncq_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ເຢຊູ ຕາແອີຍ ມັນແຊມ ກັອຍ ປາຍ: \"ອາມໍອ໌ ເອີຍ! ຍ່ອນ ໄມ່ ຊາອຳ, ອາອີ່ ໄມ່ ແກີດ ແບຣັຮ. ໄມ່ ເຈົາ ອຽນ ອໍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ບັອງ ກາ ເຢຊູ ອຶນນັ່ອງ ຕະ ອຶນຕີ ກະ ມັນແຊມ ກັອຍ, ແຕີ່ອ໌ ມານະ ກວາຍ ແຕ ດຸງ ຢາອີຣໂຣ, ອັນ ກາ ຕະ ຊົດ ດຸງ ຊາງ ກັອຍ. ອັນ ອາຕີ ຢາອີຣໂຣ ປາຍ: \"ກອນ ມັນແຊມ ໄມ່ ກູຈີດ ເຈີ່. ໄມ່ ອຶນໂຈຍ ປາຕຸ່ຮ ອາຈານ ນັ່ອງ.\" ");
INSERT INTO ncq_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ເຢຊູ ຊັອງ ກວາຍ ກັອຍ ປາຍ ນ່ະກັອຍ, ເຈີ່ ອັນ ອາຕີ ຢາອີຣໂຣ ປາຍ: \"ອຶນໂຈຍ ອຶງກັອຮ, ໄມ່ ຊາອຳ ຊັອງ. ອຶນຕູ່ນ ກອນ ໄມ່ ແກີດ ແບຣັຮ ອໍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ພໍກາ ອັນ ແຕີ່ອ໌ ປໍ ດຸງ ຢາອີຣໂຣ, ເຢຊູ ໂອນ ເປໂຕ, ຢາໂກໂບ, ໂຢຮັນ, ກະ ອຶມເປ່ອ໌ ອຶມປໍ່ ກອນ ມັນແຊມ ກັອຍ ມູ່ດ ຕຶ່ງ ດຸງ. ກວາຍ ການໍ່ອ໌ ອັນ ຕາ ໂອນ ມູ່ດ. ");
INSERT INTO ncq_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ອຶນແຍ່ະ ມັຮ ກວາຍ ກັອຍ ເຍືາມ ກອນ ມັນແຊມ ກູຈີດ ກັອຍ. ເຢຊູ ປາຍ: \"ອຶນໂຈຍ ເຍືາມ. ກວາຍ ໄນ່ ຕາ ເບີນ ກູຈີດ. ອັນ ບິ ຊັອງ.\" ");
INSERT INTO ncq_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ໄລ່ ກາ ຊັອງ ເຢຊູ ປາຍ ນ່ະກັອຍ, ໄລ່ ກັຣຈັງ ເຈືາດ ອັນ, ຍ່ອນ ໄລ່ ດັງ ປາຍ ກວາຍ ກັອຍ ກູຈີດ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ມາ ເຢຊູ ໂກບ ອາຕີ ມັນແຊມ ກາ ກູຈີດ ກັອຍ ກະ ອັນ ກູອ໌ ປາຍ: \"ອາມໍອ໌ ເອີຍ! ໄມ່ ຢວຣ!\" ");
INSERT INTO ncq_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ນ່ະກັອຍ ຣາເວືາຍ ກວາຍ ກັອຍ ເຈົາ ລັ່ຮ ປໍ ອັນ, ກະ ອັນ ຢວຣ ແຕິ່. ເຢຊູ ອາຕີ ໂອນ ເນົ່າ ຈໍ່ອ໌ ໂດຍ ຣາແວັ່ຮ ໂອນ ອາມໍອ໌ ກັອຍ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ອຶມເປ່ອ໌ ອຶມປໍ່ ມັນແຊມ ກັອຍ ຊັອງ ງຶ່ດ ລາລື່, ມາ ເຢຊູ ປາຕັບ ໄລ່ ອຶນໂຈຍ ໂອນ ອາແລ່ະ ດັງ ແຕ ຣານະ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ເຢຊູ ປາໂຣມ ມວຍ ຈິ່ດ ລາ ບາຣ ນະ ກາ ຣຍານ ແຕ ອັນ. ອັນ ໂອນ ໄລ່ ເບີນ ອຳນາດ ດໍອ໌ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ກາ ຕຣວບ ກວາຍ, ກະ ປົວ ມັຮ ກວາຍ ອາອີ່. ");
INSERT INTO ncq_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ເຈີ່ ອັນ ແປຣີ ໄລ່ ເປາະ ອາຕີ ແຕ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ, ກະ ອັນ ແປຣີ ໄລ່ ເປາະ ປົວ ມັຮ ກວາຍ ອາອີ່. ");
INSERT INTO ncq_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ອັນ ປາຕັບ ໄລ່ ປາຍ: \"ເຍືາ ອຶນໂຈຍ ເດີງ ອຶນເຕົ່າ ຕຶ່ງ ຈະ ເຍືາ. ອຶນໂຈຍ ເດີງ ຣາແລີງ. ອຶນໂຈຍ ປ່ະ ຕູຍ. ອຶນໂຈຍ ເດີງ ເກຣີ່ງ ຊັຣນາ ຈາ. ອຶນໂຈຍ ເດີງ ປຣະ. ກະ ອຶນໂຈຍ ເດີງ ບາຣ ປຼັ່ຮ ອາຢັ່ອຮ. ");
INSERT INTO ncq_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ພໍກາ ເຍືາ ມູ່ດ ຕຶ່ງ ວີ່ລ, ອຶງເຄາະ ເຍືາ ແອີດ ມວຍ ດຸງ ຊັອງ ເຕົ່າ ແຕີ່ອ໌ ເຍືາ ລັ່ອຮ ແຕ ວີ່ລ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ຄັນ ເຍືາ ມູ່ດ ຕຶ່ງ ວີ່ລ ແລ່ະ, ມາ ເນົ່າ ຕາ ເບີນ ຣັ່ບ ເຍືາ, ພໍກາ ເຍືາ ລັ່ອຮ ແຕ ວີ່ລ ກັອຍ, ອຶງເຄາະ ເຍືາ ກັນຕຣິ່ຮ ພຸ່ນ ກູແຕອ໌ ແຕ ອາເຢີງ. ໄນ່ ລາ ໂອນ ເນົ່າ ດັງ ກວາຍ ຕຶ່ງ ວີ່ລ ກັອຍ ຕາ ເບີນ ຣັ່ບ ເຍືາ.\" ");
INSERT INTO ncq_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ນ່ະກັອຍ ໄລ່ ກັອຍ ເປາະ ວີ່ລ ແກດ ວີ່ລ ປື່ດ ອາຕີ ປັຣນາຍ ອໍ ແຕ ເຢືາງ ເຈົາຣາຊີ. ກະ ໄລ່ ປົວ ມັຮ ກວາຍ ອາອີ່. ");
INSERT INTO ncq_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ເຮໂຣດ, ອັນ ກາ ຊົດ ຕຶ່ງ ແຄງ ຄາລີເລ, ອັນ ຊັອງ ແຕ ມັຮ ຣານະ ເຢຊູ ຕະ. ນ່ະກັອຍ ອັນ ຣານຸ່ຮ ຣາງຶ່ຮ, ຍ່ອນ ອັນ ຊັອງ ເນົ່າ ປາຍ ໂຢຮັນ ກາ ເກີ່ຍ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ອາມົ່ງ ລັ່ຮ ແຕ ປີ່ງ. ");
INSERT INTO ncq_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ເບີນ ກວາຍ ການໍ່ອ໌ ປາຍ ເອລີຢາ ແຕີ່ອ໌ ລັ່ຮ ເຈີ່. ກະ ເບີນ ກວາຍ ການໍ່ອ໌ ແອັນ ປາຍ ມານະ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ອາມົ່ງ ລັ່ຮ ແຕ ອັນ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ມາ ເຮໂຣດ ປາຍ: \"ເກົາ ກັອຮ ເຈີ່ ຕາກອງ ໂຢຮັນ, ມາ ກວາຍ ໄນ່ ລາ ເນົ່າ ກາ ເກົາ ຊັອງ ກວາຍ ປາຍ ອັນ ຕະ ຣານະ ນ່ະກັອຍ?\" ນ່ະກັອຍ ເຮໂຣດ ຈໍ່ອ໌ ອີ ຣາມົຮ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ມູ່ ກາ ເຢຊູ ແປຣີ ກັອຍ, ໄລ່ ເຈົາ ອາຕີ ລັ່ຮ ອັນ ມັຮ ຣານະ ໄລ່ ຕະ ເຈີ່. ອັນ ເດີງ ໄລ່ ກັອຍ ເປາະ ກະ ອັນ ແຕີ່ອ໌ ມວຍ ອຶນຕຸ ແຈ່ະ ເມືອງ ເບັດຊາອີດາ. ອຶນຕຸ ກັອຍ ຕາ ເບີນ ກວາຍ ແອີດ. ");
INSERT INTO ncq_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ມາ ພໍກາ ກຼຶ່ງ ກວາຍ ການໍ່ອ໌ ດັງ ເຢຊູ ເປາະ ປໍ ອຶນຕຸ ກັອຍ, ໄລ່ ເປາະ ຕາປູ່ນ ອັນ ເຕ່. ເຢຊູ ຣັ່ບ ຣໍ່ອ໌ ບູຍ ໄລ່ ກັອຍ, ກະ ອັນ ອາຕີ ໄລ່ ແຕ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ. ກະ ອັນ ປົວ ກວາຍ ອາແລ່ະ ກາ ເບີນ ອາອີ່. ");
INSERT INTO ncq_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ແຈ່ະ ມານາງ ອີ ຕາບື່, ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ແຕີ່ອ໌ ປໍ ອັນ ກະ ປາຍ: \"ແຊອ໌ ອາຈານ ອາຕີ ມັຮ ກວາຍ ກຼຶ່ງ ໄນ່ ເຈົາ ປໍ ເມືອງ ແກດ ເມືອງ ປື່ດ ອຶມແປຣ ໄນ່ ໂອນ ໄລ່ ຈໍ່ອ໌ ອຶນຕຸ ແອີດ, ກະ ໂອນ ໄລ່ ແຈີງ ເບີມ ເກຣີ່ງ ຊັຣນາ ຈາ, ຍ່ອນ ອຶນໄນ່ ເຢີ່ງ ແຕ ກວາຍ ແອີດ.\" ");
INSERT INTO ncq_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ມາ ເຢຊູ ອາຕີ ລັ່ຮ ໄລ່ ປາຍ: \"ເຍືາ ແຕິ່ ໂອນ ໄລ່ ເບີນ ເກຣີ່ງ ຊັຣນາ ຈາ.\" ໄລ່ ກັອຍ ປາຍ ລັ່ຮ ນ່ະໄນ່: \"ຮິ ເບີນ ແອີງ ເຊີງ ລໍາ ໂດຍ ບຸຮ ກະ ບາຣ ລໍາ ອາກາ ຊັອງ. ອາຈານ ຢໍອ໌ ຮິ ເປາະ ແຈີງ ເກຣີ່ງ ຊັຣນາ ໂອນ ກວາຍ ກຼຶ່ງ ໄນ່ ຈາ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ແອີດ ອຶນຕຸ ກັອຍ ເບີນ ມາຮ ເຊີງ ປັ່ນ ນະ ກວາຍ ຊາຊາຍ ຣາເລົາ, ມາ ຕາ ເບີນ ນັ່ບ ມັນແຊມ ກະ ກັຣແນນ. ເຈີ່ ເຢຊູ ອາຕີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ ກຼຶ່ງ ໄນ່ ຕາກູ, ມວຍ ອຶນຕຸ ເຊີງ ຈິ່ດ ນະ.\" ");
INSERT INTO ncq_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ເຈີ່ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ໂອນ ກວາຍ ກຼຶ່ງ ຕາກູ. ");
INSERT INTO ncq_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ເຢຊູ ອີດ ເຊີງ ລໍາ ໂດຍ ບຸຮ ກະ ບາຣ ລໍາ ອາກາ ກັອຍ. ອັນ ຕາເງີ່ອ໌ ອາຊັອຮ ປໍ ມັນລັ່ອງ ກະ ຊາແອີນ ເຢືາງ ເຈົາຣາຊີ ເບີນ ເກຣີ່ງ ຊັຣນາ ຈາ ໄນ່. ແວັດ ກັອຍ, ອັນ ປີຮ ໂດຍ ບຸຮ ກະ ມ່ອບ ໂອນ ມູ່ ກາ ຣຍານ ແຕ ອັນ ອຶມແປອ໌ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ໄລ່ ກັອຍ ຈາ ປາໄຊ ກູ່ ນະ. ແວັດ ໄລ່ ຈາ, ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ປາໂຣມ ລັ່ຮ ມັຮ ອຶງກັຮ ແກຼີຍ ໄລ່ ຈາ, ເບີນ ມວຍ ຈິ່ດ ລາ ບາຣ ກາເຣຍ. ");
INSERT INTO ncq_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ເບີນ ມວຍ ຕາໄງ ບັອງ ກາ ເຢຊູ ແອີດ ເກົາແຊອ໌ ມານະ ອັນ, ເຈີ່ ມູ່ ກາ ຣຍານ ແຕ ອັນ ແຕີ່ອ໌. ເຢຊູ ຕາແບີບ ໄລ່ ປາຍ: \"ມັຮ ກວາຍ ກຼຶ່ງ ກັອຍ, ໄລ່ ປາຍ ເກົາ ລາ ເນົ່າ?\" ");
INSERT INTO ncq_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ໄລ່ ຕາແອີຍ ປາຍ: \"ເບີນ ອັນ ກາ ປາຍ ອາຈານ ລາ ໂຢຮັນ, ອັນ ກາ ເກີ່ຍ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌. ເບີນ ອັນ ກາ ປາຍ ອາຈານ ລາ ເອລີຢາ. ກະ ເບີນ ອັນ ກາ ປາຍ ອາຈານ ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ອາມົ່ງ ລັ່ຮ ແຕ ກູຈີດ.\" ");
INSERT INTO ncq_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ເຢຊູ ຕາແບີບ ລັ່ຮ ໄລ່ ປາຍ: \"ມາ ເຍືາ ແອັນ ປາຍ ເກົາ ລາ ເນົ່າ?\" ເປໂຕ ຕາແອີຍ ປາຍ: \"ອາຈານ ລາ ກຣີດ, ອັນ ກາ ເຢືາງ ເຈົາຣາຊີ ຣຽຮ ດໍອ໌ ໂອນ ຈ່ອຍ ອາມົ່ງ ກວາຍ!\" ");
INSERT INTO ncq_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ເຢຊູ ປາຕັບ ໄລ່ ອຶນໂຈຍ ອາຕີ ໂອນ ກວາຍ ການໍ່ອ໌ ດັງ ແຕ ຣາມຶ່ຮ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ກະ ອັນ ອາຕີ ແອັນ ປາຍ: \"ເຈີ່ ປໍ ເມືາງ ເກົາ, ກອນ ເຢືາງ ແກີດ ກວາຍ, ອຶງເຄາະ ຈີວ໌ ຊາອຶ່ຍ ຣາມຶ່ຮ ຕຸ່ຮ ກັ່ດ ແຕີ່ອ໌ ປໍ ເກົາ. ມັຮ ກວາຍ ເທົາແກ ຈຸ່ມເຈືອ, ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ກະ ມັຮ ກວາຍ ອາຕີ ຄານອດ, ອຶນແຍ່ະ ໄລ່ ກັອຍ ຊາອັຣ ກະ ອວານ ເກົາ, ເຈີ່ ກາຈີດ ເກົາ. ມາ ແຕີ່ອ໌ ຕາໄງ ໄປ ເກົາ ອາມົ່ງ ລັ່ຮ.\" ");
INSERT INTO ncq_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ແວັດ ກັອຍ, ເຢຊູ ອາຕີ ອຶນແຍ່ະ ມັຮ ໄລ່ ກັອຍ ນ່ະໄນ່: \"ຄັນ ເບີນ ກວາຍ ອາແລ່ະ ມາ ຢໍອ໌ ອີ ປວາຍ ເກົາ, ອຶງເຄາະ ອັນ ຕັຮ ຣານະ ອັນ ເບີມ. ອຶງເຄາະ ກູ່ ຣາໄງ ອັນ ອີດ ໂດລ ອາລ່ອງ ຊັງກັງ ອັນ ເບີມ, ກະ ອຶງເຄາະ ອັນ ປວາຍ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ກວາຍ ອາແລ່ະ ມາ ປາຊິ ຣາງຶ່ຮ ອັນ ຕຶ່ງ ແດີຍ ໄນ່, ຣາງຶ່ຮ ກວາຍ ກັອຍ ປິ່ດ. ມາ ກວາຍ ອາແລ່ະ ມາ ຈີວ໌ ປິ່ດ ຣາງຶ່ຮ ອັນ ຍ່ອນ ອັນ ປວາຍ ເກົາ, ຣາງຶ່ຮ ກວາຍ ກັອຍ ຕາ ແກີດ ປິ່ດ. ");
INSERT INTO ncq_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ຄັນ ກວາຍ ອາແລ່ະ ມາ ເບີນ ຕຸ່ກ ມາເລ່ກ ແຊກ ມາການ ເກຣີ່ງ ເກຣົ່າ ຕຶ່ງ ແດີຍ ໄນ່ ຕາ ເບີນ ແອິ ອຶນເຕົ່າ, ມາ ອັນ ແກີດ ປິ່ດ ເມືາດ ຊັອງ, ອຶນເຕົ່າ ລະ ເກືາ ໂອນ ອັນ? ");
INSERT INTO ncq_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ຄັນ ກວາຍ ອາແລ່ະ ມາ ກູມາລ ຕະ ແຕ ເກົາ ກະ ກູມາລ ຕະ ແຕ ປັຣນາຍ ເກົາ ຢັ່ຮ ເມືາງ ກວາຍ ຕຶ່ງ ແດີຍ ໄນ່, ປັຣແນີ ມັນເຕຣືາ ເກົາ, ກອນ ເຢືາງ ແກີດ ກວາຍ, ກູມາລ ຕະ ລັ່ຮ ເຕ່ ອັນ ຕຶ່ງ ຕາໄງ ເກົາ ແຕີ່ອ໌ ລັ່ຮ ປໍ ກູແຕອ໌ ໄນ່. ຕາໄງ ກັອຍ ເກົາ ເບີນ ອາງອື່ຣ ແຕ ອຶມປໍ່ ເກົາ, ກະ ອຶມປຣ່ອມ ເປາະ ກະ ມັຮ ກາ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ກາ ຕາ ເບີນ ໂລ່ຍຮ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ເບີນ ກວາຍ ກາ ຕາຢຶ່ງ ແອີດ ອຶນໄນ່ ຊານໍ່, ໄລ່ ຕາ ເບີນ ກູຈີດ ຢວາຮ ເຕົ່າ ແຕີ່ອ໌ ໄລ່ ເບີນ ເຮີມ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ.\" ");
INSERT INTO ncq_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ແວັດ ເຢຊູ ປາຍ ມັຮ ປັຣນາຍ ກັອຍ, ເບີນ ມາຮ ຕາກ່ອລ ຕາໄງ ແອັນ, ເຈີ່ ເຢຊູ ເດີງ ເປໂຕ, ໂຢຮັນ, ກະ ຢາໂກໂບ ຊັອຮ ກະ ອັນ ຕຶ່ງ ກົຮ, ອີ ເກົາແຊອ໌ ອຶງກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ບັອງ ກາ ເຢຊູ ເກົາແຊອ໌, ອັນ ຊຳບຼີນ ຕຶ່ງ ມັ່ດ ໄລ່ ແກີດ ຣູ່ບເຣືາງ ອຶມພາ ແອັນ, ກະ ເກຣີ່ງ ອັນ ແກີດ ກຼໍອ໌ ຊັຣມຍາລ ມັ່ດ. ");
INSERT INTO ncq_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ເບີນ ບາຣ ນະ ຕະ ອຶນຕີ ກະ ເຢຊູ. ໄລ່ ບາຣ ນະ ລາ ໂມເຊ ກະ ເອລີຢາ. ");
INSERT INTO ncq_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ຣູ່ບເຣືາງ ໄລ່ ອາງອື່ຣ, ກະ ໄລ່ ອາຕີ ແຕ ເຢຊູ ຈີວ໌ ກູຈີດ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ. ");
INSERT INTO ncq_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ມາ ເປໂຕ ກະ ເຢົ່າ ອັນ, ໄລ່ ຊັອງ ຢໍອ໌ ອີ ບິ ລາລື່. ມາ ພໍກາ ເປໂຕ ກະ ເຢົ່າ ອັນ ຕາແມີ, ໄລ່ ເຮີມ ອາງອື່ຣ ຣູ່ບເຣືາງ ເຢຊູ, ກະ ໄລ່ ບາຣ ນະ ກວາຍ ການໍ່ອ໌ ກັອຍ ແອີດ ຕາຢຶ່ງ ກະ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ພໍກາ ໄລ່ ບາຣ ນະ ກັອຍ ລັ່ອຮ ແຕ ເຢຊູ, ເປໂຕ ອາຕີ ເຢຊູ ປາຍ: \"ອາຈານ ເອີຍ! ຮິ ແອີດ ອຶນໄນ່ ລາ ອໍ ລາລື່. ຮິ ອີ ຕະ ໄປ ລໍາ ຊູ, ມານຳ ລາ ຕະ ໂອນ ອາຈານ, ມານຳ ລາ ຕະ ໂອນ ໂມເຊ, ກະ ມານຳ ລາ ຕະ ໂອນ ເອລີຢາ.\" ມາ ເປໂຕ ປາຍ ນ່ະກັອຍ ລາ ອັນ ຕາ ເບີນ ດັງ ອັນ ປາຍ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ບັອງ ກາ ເປໂຕ ອຶນນັ່ອງ ຕະ ອຶນຕີ, ເບີນ ຣາມິ່ລ ແຕີ່ອ໌ ປໍ ກັອຍ ເຈີ່ ຕວມ ດໍອ໌ ຈະ ໄລ່. ນ່ະກັອຍ ໄລ່ ຊັອງ ອຶງກັອຮ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ກະ ເບີນ ຊຽງ ຊາບາວ ອາຕີ ແຕ ຣາມິ່ລ ກັອຍ ປາຍ: \"ໄນ່ ລາ ກອນ ເກົາ ກາ ເກົາ ຣຽຮ. ອຶນເຕົ່າ ອັນ ອາຕີ, ອຶງເຄາະ ເຍືາ ຊາງັດ ອັນ ນໍ!\" ");
INSERT INTO ncq_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ແວັດ ຊຽງ ກັອຍ ຣາງຍາອ໌, ໄລ່ ເຮີມ ແອີງ ເຢຊູ ຊັອງ ແອີດ ອຶນຕຸ ກັອຍ. ເຈີ່ ໄລ່ ໄປ ນະ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ, ໄລ່ ເຈີ ດໍອ໌ ມັຮ ຣາມຶ່ຮ ກັອຍ ຕຶ່ງ ຣາງຶ່ຮ ໄລ່ ມາ ໄລ່ ຕາ ເບີນ ອາຕີ ຢວາຮ ໂອນ ກວາຍ ການໍ່ອ໌ ດັງ ແຕ ຣາມຶ່ຮ ກາ ໄລ່ ເຮີມ. ");
INSERT INTO ncq_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ມາຮ ຕາໄງ ປັຣແນີ ແອັນ, ແຕີ່ອ໌ ໄລ່ ແຊງ ແຕ ກົຮ, ເບີນ ກຼຶ່ງ ກວາຍ ຣາມົຮ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ເບີນ ມານະ ແຕ ກວາຍ ກຼຶ່ງ ກັອຍ ຊາບາວ ເຣ່ງ ລາລື່ ປາຍ: \"ອາຈານ ເອີຍ! ເກົາ ແຊອ໌ ອາຈານ ເປາະ ເນ່ ກອນ ຣາເລົາ ເກົາ. ເກົາ ເບີນ ກອນ ຣາເລົາ ມານຳ ໄນ່ ແຕິ່. ");
INSERT INTO ncq_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ກະ ເຢືາງ ຕາ ອໍ ຕຣວບ ອັນ. ພໍກາ ອັນ ຕະ, ຊັນຕັຣ ອັນ ແຮຣ ຊັອງ, ກະ ເຢືາງ ຕາ ອໍ ກັອຍ ແດັຮ ອັນ, ເຈີ່ ລັ່ອຮ ປູປົ່ຮ ແຕ ແບອ໌. ອັນ ແດັຮ ປຸງໆ ກອນ ເກົາ, ເຈີ່ ອັນ ຕາງິ່ດ, ມາ ອັນ ຕາ ເບີນ ຕັຮ ແຕ ຈະ ກອນ ເກົາ! ");
INSERT INTO ncq_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ເກົາ ແຊອ໌ ເຈີ່ ມູ່ ກາ ຣຍານ ແຕ ອາຈານ ໂອນ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ແຕ ຈະ ກອນ ເກົາ, ມາ ໄລ່ ຕູ່ຍຮ ອັນ ຕາ ເຣືາບ.\" ");
INSERT INTO ncq_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ເຢຊູ ຕາແອີຍ ປາຍ: \"ເຍືາ ກາ ແອີດ ຕຶ່ງ ແດີຍ ໄນ່ ເອີຍ! ເຍືາ ຕາ ເບີນ ຊາອຳ ກະ ເຍືາ ລາ ກວາຍ ກາ ເງືານ ລາລື່! ອຶນນັ່ອງ ດູ່ນ ມາແລ່ະ ເກົາ ແອີດ ກະ ເຍືາ ກະ ຈີວ໌ ເຍືາ ຕາ ເບີນ ຊາອຳ? ເດີງ ໂອນ ກອນ ໄມ່ ແຕີ່ອ໌ ປໍ ເກົາ ແມຮ!\" ");
INSERT INTO ncq_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ບັອງ ກາ ຣາເລົາ ກັອຍ ແຕີ່ອ໌, ເຢືາງ ຕາ ອໍ ກັອຍ ແດັຮ ອັນ, ເຈີ່ ອາໄຕຮ ອັນ ຕຶ່ງ ກູແຕອ໌. ເຢຊູ ກາແອັຮ ເຢືາງ ຕາ ອໍ ໂອນ ອັນ ລັ່ອຮ ແຕ ຈະ ກັຣແນນ ກັອຍ. ເຈີ່ ກັຣແນນ ກັອຍ ແກີດ ແບຣັຮ. ເຢຊູ ມ່ອບ ລັ່ຮ ກັຣແນນ ກັອຍ ປໍ ອຶມປໍ່ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ອຶນແຍ່ະ ມັຮ ກວາຍ ກັອຍ ຊັອງ ງຶ່ດ ລາລື່ ຍ່ອນ ໄລ່ ເຮີມ ເຢືາງ ເຈົາຣາຊີ ເບີນ ອຳນາດ ປື່ດ ລາລື່ ນ່ະກັອຍ. ບັອງ ກາ ອຶນແຍ່ະ ມັຮ ກວາຍ ກັອຍ ອຶນນັ່ອງ ຊັອງ ງຶ່ດ ແຕ ຣານະ ເຢຊູ ຕະ ນ່ະກັອຍ, ເຢຊູ ອາຕີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","\"ເຍືາ ຊາງັດ ອໍ ປັຣນາຍ ເກົາ ອາຕີ ເຍືາ ໄນ່! ແຈ່ະ ເຈີ່ ເນົ່າ ອີ ມ່ອບ ເກົາ, ກອນ ເຢືາງ ແກີດ ກວາຍ, ປໍ ອາຕີ ກວາຍ ຊົດ!\" ");
INSERT INTO ncq_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ມາ ໄລ່ ກັອຍ ຕາ ເບີນ ຊາປຸ່ຮ ປັຣນາຍ ກັອຍ. ເຢືາງ ເຈົາຣາຊີ ປາໂຕ່ະ ຣາມຶ່ຮ ປັຣນາຍ ກັອຍ ໂອນ ໄລ່ ຕາ ເບີນ ດັງ. ກະ ໄລ່ ຕາ ຍັ່ນ ຕາແບີບ ເຢຊູ ແຕ ຣາມຶ່ຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ມັຮ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ, ໄລ່ ຣາຈຽນ ປາຍ ເນົ່າ ກາ ປື່ດ ກາເລີຍ ແຕ ເຢົ່າ ຕຶ່ງ ມູ່ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ເຢຊູ ດັງ ໄລ່ ຕະ ອຶນຕີ ນ່ະກັອຍ. ເຈີ່ ເຢຊູ ເຕິ ອາຕີ ມານະ ກັຣແນນ, ໂອນ ກັຣແນນ ກັອຍ ຕາຢຶ່ງ ແຈ່ະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ອັນ ອາຕີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ກວາຍ ອາແລ່ະ ມາ ຣັ່ບ ອໍ ກັຣແນນ ນ່ະໄນ່ ຍ່ອນ ອັນ ຊາອຳ ເກົາ, ກວາຍ ກັອຍ ຣັ່ບ ອໍ ກາ ເກົາ ແຮີ. ກະ ກວາຍ ອາແລ່ະ ກາ ຣັ່ບ ອໍ ເກົາ, ມູເຈິງ ກວາຍ ກັອຍ ຣັ່ບ ອໍ ອັນ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່ ເຕ່. ກວາຍ ອາແລ່ະ ກາ ອາແຊງ ຈະ ແກີດ ແກດ ກາເລີຍ ອຶນແຍ່ະ ແຕ ເຢົ່າ ຕຶ່ງ ມູ່ ເຍືາ, ກວາຍ ກັອຍ ແກີດ ປື່ດ ກາເລີຍ ແຕ ເຢົ່າ.\" ");
INSERT INTO ncq_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ໂຢຮັນ ອາຕີ ເຢຊູ ປາຍ: \"ອາຈານ ເອີຍ! ຮິ ເຮີມ ເຈີ່ ມານະ ກວາຍ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ກະ ອັນ ກູອ໌ ຣາມຶ່ຮ ອາຈານ. ມາ ຮິ ຕາ ໂອນ ອັນ ຕະ ນັ່ອງ ຣານະ ກັອຍ, ຍ່ອນ ອັນ ລາ ຕາ ແກີນ ກວາຍ ໄຮ.\" ");
INSERT INTO ncq_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ມາ ເຢຊູ ອາຕີ ລັ່ຮ ໂຢຮັນ ປາຍ: \"ເຍືາ ອຶນໂຈຍ ກາຕັງ ອັນ. ກວາຍ ອາແລ່ະ ກາ ຕາ ເບີນ ດໍອ໌ ມັ່ດ ກະ ເຍືາ, ໄນ່ ລາ ມູເຈິງ ກວາຍ ກັອຍ ແອີດ ກະ ເຍືາ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ແຈ່ະ ອີ ແຕີ່ອ໌ ເຈີ່ ຕາໄງ ເຢຊູ ຊັອຮ ລັ່ຮ ປໍ ມັນລັ່ອງ; ນ່ະກັອຍ ເຢຊູ ຄຶ່ດ ອີ ເປາະ ປໍ ເມືອງ ເຢຣູຊາເລັມ. ");
INSERT INTO ncq_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ອັນ ແປຣີ ມັຮ ກວາຍ ເດີງ ປັຣນາຍ ເປາະ ອຶນໂຍ່ງ. ກວາຍ ກັອຍ ມູ່ດ ຕຶ່ງ ມວຍ ວີ່ລ ກວາຍ ຊາມາເຣຍ. ໄລ່ ກຽມ ດໍອ໌ ໂອນ ເຢຊູ ແຕີ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ມາ ກວາຍ ແອີດ ຕຶ່ງ ວີ່ລ ກັອຍ ຕາ ເບີນ ຣັ່ບ ເຢຊູ, ຍ່ອນ ໄລ່ ດັງ ອັນ ຢໍອ໌ ອີ ເປາະ ປໍ ເມືອງ ເຢຣູຊາເລັມ. ");
INSERT INTO ncq_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ພໍກາ ຢາໂກໂບ ກະ ໂຢຮັນ, ໄລ່ ບາຣ ນະ ແຕ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ, ເຮີມ ຣານະ ກັອຍ, ໄລ່ ຕາແບີບ ເຢຊູ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ອຶນເຈົາ ຢໍອ໌ ຮິ ກູອ໌ ອູ່ຍຮ ແຕ ມັນລັ່ອງ ແຊງ ຈັອງ ໄລ່ ກັອຍ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ມາ ເຢຊູ ກູລຽວ, ກະ ອັນ ກາແອັຮ ໄລ່ ອຶນໂຈຍ ຄຶ່ດ ນ່ະກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ເຈີ່ ໄລ່ ເປາະ ປໍ ວີ່ລ ການໍ່ອ໌ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ບັອງ ກາ ໄລ່ ເປາະ ຕຶ່ງ ຣານາ, ເບີນ ມານະ ຣາເລົາ ແຕີ່ອ໌ ປໍ ເຢຊູ ກະ ອັນ ປາຍ: \"ອາຈານ ເອີຍ! ປໍ ແລ່ະ ອາຈານ ເປາະ, ເກົາ ປວາຍ ອາຈານ ປໍ ກັອຍ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ເຢຊູ ອາຕີ ລັ່ຮ ອັນ ປາຍ: \"ຕາຈໍອ໌ ອຶນນັ່ອງ ເບີນ ກື່ບ, ແຈມ ອຶນນັ່ອງ ເບີນ ຊານົຮ, ມາ ກອນ ເຢືາງ ແກີດ ກວາຍ ຕາ ເບີນ ອຶນຕຸ ແລ່ະ ໂອນ ອັນ ບິ.\" ");
INSERT INTO ncq_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ເຢຊູ ແປຣີ ມານະ ກວາຍ ການໍ່ອ໌: \"ໄມ່ ປວາຍ ເກົາ.\" ມາ ກວາຍ ກັອຍ ປາຍ ລັ່ຮ ນ່ະໄນ່: \"ອຶນເຈົາ ເອີຍ! ເກຣາະ ອຶມປໍ່ ເກົາ ກູຈີດ ເວືາຍ. ແວັດ ເກົາ ແຕິບ ອຶມປໍ່ ເກົາ, ເຈີ່ ເກົາ ປວາຍ ອຶນເຈົາ.\" ");
INSERT INTO ncq_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ເຢຊູ ອາຕີ ລັ່ຮ ອັນ ປາຍ: \"ດໍອ໌ ໂອນ ກວາຍ ກູຈີດ ແຕິບ ກວາຍ ກູຈີດ. ມາ ໄມ່, ອຶງເຄາະ ໄມ່ ເປາະ ອາຕີ ແຕ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ.\" ");
INSERT INTO ncq_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ເບີນ ກວາຍ ການໍ່ອ໌ ແອັນ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ເກົາ ຢໍອ໌ ອີ ປວາຍ ອຶນເຈົາ ເຕ່, ມາ ເກົາ ແຊອ໌ ເຈົາ ກ່ອບ ກວາຍ ຕຶ່ງ ດຸງ ເກົາ ເວືາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ເຢຊູ ອາຕີ ກວາຍ ກັອຍ ປາຍ: \"ກວາຍ ອາແລ່ະ ມາ ຢຸມ ອຶງກັ່ລ ໄທ ຊວນ ອັນ, ອຶງເຄາະ ກວາຍ ກັອຍ ອຶນໂຈຍ ກູລຍານ ປໍ ກຣັອງ. ອັນ ກາ ຕະ ຣານະ ເຢືາງ ເຈົາຣາຊີ ລາ ມູເຈິງ ກັອຍ ເຕ່. ຄັນ ອັນ ເບີນ ບາຣ ຣາງຶ່ຮ, ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ຕະ ຊົດ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ແວັດ ກັອຍ ແອັນ ເຢຊູ ຣຽຮ ກວາຍ ຕາປູ່ລ ຈິ່ດ ລາ ບາຣ ນະ. ອັນ ແປຣີ ໄລ່ ກັອຍ ເປາະ ອຶນໂຍ່ງ ອັນ, ມັນຕຸ ບາຣ ນະ, ມູ່ດ ອຶນແຍ່ະ ກູ່ ເມືອງ ກູ່ ອຶນຕຸ ອັນ ຄຶ່ດ ອີ ເປາະ. ");
INSERT INTO ncq_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ອັນ ອາຕີ ໄລ່ ກັອຍ ປາຍ: \"ທຣໍ ຕຶ່ງ ໄທຣ ຕາວັ່ຮ ລາລື່ ຈີນ ເຈີ່, ມາ ເບີນ ບີ່ອ໌ ນະ ກວາຍ ເປາະ ຊອດ ທຣໍ ກັອຍ. ອຶງເຄາະ ເຍືາ ແຊອ໌ ແຕ ອຶນເຈົາ ໄທຣ ໂອນ ອັນ ແປຣີ ເບີນ ຊາອຶ່ຍ ນະ ແອັນ ເປາະ ຊອດ ທຣໍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ເຍືາ ເປາະ! ເກົາ ແປຣີ ເຍືາ ເປາະ ນ່ະ ແກະ ກອນ ແອີດ ອຶນດີ ຊັນຕຣັ່ນ ຊາກັອງ. ");
INSERT INTO ncq_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ເຍືາ ອຶນໂຈຍ ເດີງ ປຣະ. ອຶນໂຈຍ ປ່ະ ຕູຍ ນ່ະ ກວາຍ ຊູແຊອ໌. ອຶນໂຈຍ ເດີງ ບາຣ ກູ່ ແກີບ. ກະ ແຕີ່ອ໌ ເຍືາ ຣາມົຮ ເຢົ່າ ຕຶ່ງ ຣານາ, ເຍືາ ອຶນໂຈຍ ຕາກູ ຕະ ອຶນຕີ ກະ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ແຕີ່ອ໌ ເຍືາ ມູ່ດ ຕຶ່ງ ດຸງ ອາແລ່ະ, ແຕ ຕາແບິ ລາລື່ ເຍືາ ປາຍ: 'ແຊອ໌ ເຢືາງ ເຈົາຣາຊີ ຈ່ອຍ ໂອນ ດຸງຊູ ໄນ່ ເບີນ ບັນຊວານ ອຽນ ອໍ ເລືອຍໆ.' ");
INSERT INTO ncq_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ຄັນ ກວາຍ ແອີດ ຕຶ່ງ ດຸງ ກັອຍ ເບີນ ຣາງຶ່ຮ ຢໍອ໌ ອີ ຣັ່ບ ບຸ່ນ ກັອຍ, ເຢືາງ ເຈົາຣາຊີ ໂອນ ໄລ່ ເບີນ. ມາ ຄັນ ໄລ່ ຕາ ເບີນ ຢໍອ໌ ອີ ຣັ່ບ, ເຢືາງ ເຈົາຣາຊີ ໂອນ ເຍືາ ແອັນ ເບີນ ບຸ່ນ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ອຶງເຄາະ ເຍືາ ແອີດ ມວຍ ດຸງ ຊັອງ. ເຍືາ ອຶນໂຈຍ ເປາະ ແອີດ ດຸງ ອາໄນ່ ດຸງ ອາກັອຍ ແຮີ. ກະ ຊັຣນາ ຈາ ອຶນເຕົ່າ ກວາຍ ດຸງ ກັອຍ ໂອນ ເຍືາ ຈາ, ເຍືາ ຈາ ຊັຣນາ ກັອຍ. ກວາຍ ກາ ຕະ ຣານະ ຈ່ອຍ ກວາຍ ການໍ່ອ໌, ອຶງເຄາະ ກວາຍ ການໍ່ອ໌ ກັອຍ ຈ່ອຍ ລັ່ຮ ໂອນ ອັນ ກາ ຕະ ກັອຍ ເບີນ ເກຣີ່ງ ຊັຣນາ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ແຕີ່ອ໌ ເຍືາ ມູ່ດ ຕຶ່ງ ເມືອງ, ຄັນ ກວາຍ ກັອຍ ຣັ່ບ ຣາບັນ ອໍ ໂຈະ ເຍືາ, ອຶງເຄາະ ເຍືາ ຈາ ມັຮ ເກຣີ່ງ ຊັຣນາ ຈາ ໄລ່ ໂອນ. ");
INSERT INTO ncq_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ຕຶ່ງ ເມືອງ ກັອຍ ອຶງເຄາະ ເຍືາ ປົວ ມັຮ ກວາຍ ອາອີ່. ກະ ອຶງເຄາະ ເຍືາ ອາຕີ ໄລ່ ປາຍ: 'ແຈ່ະ ອີ ແຕີ່ອ໌ ປາເນ່ນ ເຈີ່ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ.' ");
INSERT INTO ncq_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ແຕີ່ອ໌ ເຍືາ ມູ່ດ ຕຶ່ງ ວີ່ລ ກວາຍ, ມາ ກວາຍ ຕຶ່ງ ວີ່ລ ກັອຍ ຕາ ເບີນ ຣັ່ບ ຣາບັນ ອໍ ໂຈະ ເຍືາ, ອຶງເຄາະ ເຍືາ ລັ່ອຮ ລັ່ຮ ປໍ ຣານາ ກະ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","'ພຸ່ນ ກູແຕອ໌ ແຕ ວີ່ລ ເຍືາ ກາ ແຕັດ ອາເຢີງ ຮິ; ຮິ ອີ ກັນຕຣິ່ຮ ຕັຮ. ນ່ະກັອຍ ລາ ຕະ ໂອນ ເນົ່າ ດັງ ເຍືາ ຕາ ເບີນ ຣັ່ບ ຮິ.' ມາ ອຶງເຄາະ ເຍືາ ດັງ ເຕ່ ປາຍ, ແຈ່ະ ອີ ແຕີ່ອ໌ ປາເນ່ນ ເຈີ່ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ!\" ");
INSERT INTO ncq_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ເຈີ່ ເຢຊູ ອາຕີ ແອັນ ປາຍ: \"ເກົາ ອາຕີ ເຍືາ ລາ ແຕີ່ອ໌ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ອາເບຼິຮ ອຶນແຍ່ະ ມັຮ ກວາຍ, ອັນ ຕະ ໂອນ ໄລ່ ກາ ແອີດ ຕຶ່ງ ວີ່ລ ກັອຍ ເບີນ ຕຸ່ຮ ກັ່ດ ກາເລີຍ ແຕ ໄລ່ ກາ ແອີດ ຕຶ່ງ ເມືອງ ໂຊໂດມ ແຕ ອຶມແບິ.\" ");
INSERT INTO ncq_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","\"ບາບ ລາລື່ ແຕີ່ອ໌ ປໍ ເຍືາ ກາ ແອີດ ຕຶ່ງ ເມືອງ ໂຄຣາຊິນ! ກະ ບາບ ລາລື່ ໂອນ ເຍືາ ກາ ແອີດ ຕຶ່ງ ເມືອງ ເບັດຊາອີດາ! ຄັນ ເກົາ ມາ ຕະ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ຕຶ່ງ ເມືອງ ຕີເຣ ກະ ເມືອງ ຊີໂດນ ມູເຈິງ ເກົາ ຕະ ເຈີ່ ຕຶ່ງ ເມືອງ ເຍືາ, ດູ່ນ ເຈີ່ ກວາຍ ຕຶ່ງ ເມືອງ ກັອຍ ຕັຮ ຣາງຶ່ຮ ຕຍາ ປຽນ ແກີດ ຣາງຶ່ຮ ຕາໄມ ແອັນ. ກະ ດູ່ນ ເຈີ່ ໄລ່ ກັອຍ ຕັອກ ຕຳປັອກ ເຍືາມ ຕຸ່ຮ, ກະ ອາປຶ່ ໂຈະ ບັອຮ ຕຶ່ງ ຈະ ໄລ່, ຕະ ໂອນ ເນົ່າ ດັງ ປາຍ ໄລ່ ຊັອງ ຕຸ່ຮ ຍ່ອນ ໄລ່ ເບີນ ໂລ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ແຕີ່ອ໌ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ອາເບຼິຮ ອຶນແຍ່ະ ມັຮ ກວາຍ, ຕາໄງ ກັອຍ ອັນ ຊັອງ ອາໂຢ່ະ ຕະ ກວາຍ ກາ ແອີດ ຕຶ່ງ ເມືອງ ຕີເຣ ກະ ເມືອງ ຊີໂດນ ກາເລີຍ ແຕ ອັນ ຊັອງ ອາໂຢ່ະ ຕະ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ກະ ເຍືາ ກາ ແອີດ ຕຶ່ງ ເມືອງ ກາເປນາອູມ ເອີຍ! ເຍືາ ຄຶ່ດ ປາຍ ເຍືາ ເຕ່ອ໌ ຊັອຮ ປໍ ມັນລັ່ອງ ບໍ? ໄກຣ ລາລື່, ປັຣແນີ ມັນເຕຣືາ ເຢືາງ ເຈົາຣາຊີ ອາປັອງ ຕັຮ ເຍືາ ຕຶ່ງ ປຣຸ່ງ ອູ່ຍຮ!\" ");
INSERT INTO ncq_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ເຈີ່ ເຢຊູ ອາຕີ ໂຈະ ຕາປູ່ລ ຈິ່ດ ລາ ບາຣ ນະ ກັອຍ ປາຍ: \"ກວາຍ ອາແລ່ະ ມາ ຊາງັດ ປັຣນາຍ ເຍືາ, ໄນ່ ລາ ມູເຈິງ ອັນ ຊາງັດ ປັຣນາຍ ເກົາ ເຕ່. ກະ ກວາຍ ອາແລ່ະ ມາ ຕາ ເບີນ ອີ ຊາງັດ ປັຣນາຍ ເຍືາ, ໄນ່ ລາ ມູເຈິງ ອັນ ຕາ ເບີນ ອີ ຊາງັດ ປັຣນາຍ ເກົາ ເຕ່. ກະ ກວາຍ ອາແລ່ະ ມາ ຕາ ເບີນ ອີ ຊາງັດ ປັຣນາຍ ເກົາ, ໄນ່ ລາ ມູເຈິງ ອັນ ຕາ ເບີນ ອີ ຊາງັດ ປັຣນາຍ ອັນ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ມູ່ ຕາປູ່ລ ຈິ່ດ ລາ ບາຣ ນະ ກັອຍ ເຈົາ ລັ່ຮ, ກະ ໄລ່ ຊັອງ ຣໍ່ອ໌ ລາລື່. ໄລ່ ອາຕີ ເຢຊູ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ກາ ມັຮ ເຢືາງ ຕາ ອໍ ຊາງັດ ປັຣນາຍ ຮິ ບັອງ ກາ ຮິ ຕູ່ຍຮ ໄລ່ ກະ ຮິ ກູອ໌ ຣາມຶ່ຮ ອຶນເຈົາ!\" ");
INSERT INTO ncq_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ເຢຊູ ອາຕີ ລັ່ຮ ໄລ່ ກັອຍ ປາຍ: \"ເກົາ ເຮີມ ເຢືາງ ຊາຕານ ຊາແລັຮ ແຕ ມັນລັ່ອງ ນ່ະ ຕາລຍາຣ. ");
INSERT INTO ncq_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ເຍືາ ຊາງັດ! ເກົາ ໂອນ ເຍືາ ເບີນ ອຳນາດ ໂອນ ເຍືາ ເຕ່ອ໌ ຊາເຕືາຍ໌ ກູຊັນ ກະ ຕຸ່ງເຕືາງ, ກະ ໂອນ ເຍືາ ເຣືາບ ຣາຊູ່ ລັ່ຮ ເຢືາງ ຊາຕານ. ກະ ຕາ ເບີນ ຣາມຶ່ຮ ອຶນເຕົ່າ ເຕ່ອ໌ ຕະ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ມາ ເຍືາ ອຶນໂຈຍ ແອີນ ຍ່ອນ ເຢືາງ ຕາ ອໍ ຊາງັດ ເຍືາ. ອຶງເຄາະ ເຍືາ ແອີນ ຍ່ອນ ເຢືາງ ເຈົາຣາຊີ ຄຽນ ຣາມຶ່ຮ ເຍືາ ຕຶ່ງ ມັນລັ່ອງ.\" ");
INSERT INTO ncq_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ບັອງ ກາ ກັອຍ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ໂອນ ເຢຊູ ຊັອງ ຣໍ່ອ໌ ລາລື່. ນ່ະກັອຍ ອັນ ປາຍ ນ່ະໄນ່ ກະ ເຢືາງ ເຈົາຣາຊີ: \"ອຶມປໍ່ ເອີຍ! ໄມ່ ລາ ອຶນເຈົາ ມັນລັ່ອງ ກະ ກູແຕອ໌ ໄນ່! ເກົາ ຊາແອີນ ໄມ່ ອາປັຮ ເຈີ່ ຣານະ ໄມ່ ໂອນ ກວາຍ ກາ ນ່ະ ກັຣແນນ ແກດໆ, ໄລ່ ກາ ຕາ ເບີນ ດັງ ອຶນເຕົ່າ. ມາ ໄມ່ ປາໂຕ່ະ ຣານະ ໄນ່ ແຕ ກວາຍ ກາ ຣາໄງ່ອ໌ ຣາລັ່ງ, ໄລ່ ກາ ຣຍານ ຊາອຶ່ຍ ເຈີ່. ປຍາຍ໌, ອຶມປໍ່ ເອີຍ, ເກົາ ຍ່ອງ ໄມ່, ຍ່ອນ ຣານະ ກັອຍ ອໍ ຢັ່ຮ ເມືາງ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","\"ກູ່ ຣາມຶ່ຮ ອຶມປໍ່ ເກົາ ມ່ອບ ໂອນ ເກົາ ເບີນ. ຕາ ເບີນ ກວາຍ ອາແລ່ະ ດັງ ຣາງຶ່ຮ ກອນ ເຢືາງ ເຈົາຣາຊີ. ແອີງ ອຶມປໍ່ ອັນ ແຕິ່ ດັງ ຣາງຶ່ຮ ກອນ ອັນ. ກະ ຕາ ເບີນ ກວາຍ ອາແລ່ະ ດັງ ຣາງຶ່ຮ ອຶມປໍ່ ຕຶ່ງ ມັນລັ່ອງ. ແອີງ ກອນ ອັນ ແຕິ່ ດັງ ຣາງຶ່ຮ ອຶມປໍ່ ອັນ. ກະ ກວາຍ ອາແລ່ະ ກາ ກອນ ເຢືາງ ເຈົາຣາຊີ ຣຽຮ, ອັນ ອາປັຮ ໂອນ ກວາຍ ກັອຍ ດັງ ເຕ່ ແຕ ຣາງຶ່ຮ ອຶມປໍ່ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ແວັດ ກັອຍ ເຢຊູ ກູລຽວ ລົ່ບ ລັ່ຮ ປໍ ມູ່ ກາ ຣຍານ ແຕ ອັນ. ອັນ ອາຕີ ແອີງ ໄລ່ ກັອຍ ຊັອງ ປາຍ: \"ບຸ່ນ ລາລື່ ກວາຍ ອາແລ່ະ ມາ ເບີນ ເຮີມ ມັຮ ຣາມຶ່ຮ ເຍືາ ເຮີມ. ");
INSERT INTO ncq_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ເບີນ ຊາອຶ່ຍ ນະ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ກະ ເບີນ ຊາອຶ່ຍ ນະ ເຕືາວ ປັຣເຍືາ, ກາ ຢໍອ໌ ອີ ເຮີມ ມັຮ ຣານະ ເຍືາ ເຮີມ ຊານໍ່, ມາ ໄລ່ ຕາ ດັງ ເບີນ ເຮີມ. ກະ ໄລ່ ກັອຍ ຢໍອ໌ ອີ ຊັອງ ມັຮ ປັຣນາຍ ເຍືາ ຊັອງ ຊານໍ່, ມາ ໄລ່ ຕາ ດັງ ເບີນ ຊັອງ.\" ");
INSERT INTO ncq_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ມານະ ກວາຍ ອາຈານ ອາຕີ ຄານອດ ອິດຊະຣາເອລ ແຕີ່ອ໌ ປໍ ເຢຊູ. ອັນ ຕາແບີບ ອີ ລ່ອງ ເຢຊູ ປາຍ: \"ອາຈານ ເອີຍ! ນານ່ະ ເກົາ ອີ ຕະ ໂອນ ເກົາ ເບີນ ອາມົ່ງ ເລືອຍໆ?\" ");
INSERT INTO ncq_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ເຢຊູ ຕາແອີຍ ປາຍ: \"ຕຶ່ງ ຄານອດ ເຢືາງ ເຈົາຣາຊີ ຄຽນ ອຶນເຕົ່າ? ແຕີ່ອ໌ ເຍືາ ອານ, ອຶນເຕົ່າ ເຍືາ ຊັອງ ແຕ ປັຣນາຍ ກັອຍ?\" ");
INSERT INTO ncq_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ກວາຍ ກັອຍ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ປາຍ: 'ອຶງເຄາະ ເຍືາ ອາໂຢ່ະ ເຢືາງ ເຈົາຣາຊີ, ອຶນເຈົາ ເຍືາ, ອຶນແຍ່ະ ຣາງຶ່ຮ ເຍືາ, ອຶນແຍ່ະ ຣາແຮີ ເຍືາ, ອຶນແຍ່ະ ບັນ ເຣ່ງ ເຍືາ, ກະ ອຶນແຍ່ະ ການິ່ດ ເຍືາ.' ກະ ອັນ ປາຍ ແອັນ ນ່ະໄນ່: 'ອຶງເຄາະ ເຍືາ ອາໂຢ່ະ ເຢົ່າ ມູເຈິງ ເຍືາ ອາໂຢ່ະ ຈະ ເຍືາ ເບີມ ເຕ່.'\" ");
INSERT INTO ncq_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ເຢຊູ ຕາແອີຍ ກວາຍ ກັອຍ ປາຍ: \"ປຍາຍ໌ ໄມ່ ປາຍ. ຄັນ ໄມ່ ຕະ ນ່ະກັອຍ, ໄມ່ ເບີນ ອາມົ່ງ ເລືອຍໆ.\" ");
INSERT INTO ncq_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ມາ ກວາຍ ກັອຍ, ອັນ ຢໍອ໌ ອີ ອາປັຮ ຣາງຶ່ຮ ອັນ, ໂອນ ເຢຊູ ຍ່ອງ ປາຍ ອັນ ລາ ກວາຍ ຕານັ່ອງ ອໍ. ນ່ະກັອຍ ອັນ ຕາແບີບ ແອັນ ເຢຊູ ປາຍ: \"ເນົ່າ ລາ ເຢົ່າ ເກົາ?\" ");
INSERT INTO ncq_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ເຢຊູ ຕາແອີຍ ປັຣນາຍ ຊາກຳ ປາຍ: \"ເບີນ ມານະ ກວາຍ ຣາເລົາ ເປາະ ຕຶ່ງ ຣານາ ແຊງ ແຕ ເມືອງ ເຢຣູຊາເລັມ ເປາະ ປໍ ເມືອງ ເຢຣີໂກ. ບັອງ ກາ ອັນ ເປາະ ຕຶ່ງ ຣານາ ກັອຍ, ເບີນ ກວາຍ ຊາແວງ ປາລັອງ ປົນ ເກຣີ່ງ ອັນ. ກະ ໄລ່ ປຍາຍຮ ອັນ ແຮີ, ອຶນຈົນ ອັນ ອີ ກູຈີດ. ເຈີ່ ໄລ່ ຕາລຸ່ຮ ຕັຮ ແຕ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ຕຶ່ງ ຕາໄງ ກັອຍ ເບີນ ມານະ ແຕ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ເປາະ ຣານາ ກັອຍ ເຕ່, ເຈີ່ ອັນ ເຮີມ ກວາຍ ກາ ເນົ່າ ປົນ ກັອຍ ແຈ່ະ ອີ ກູຈີດ, ມາ ອັນ ເປາະ ວຍາຣ ຕັຮ. ");
INSERT INTO ncq_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ພໍກາ ກັອຍ ແຕີ່ອ໌ ກວາຍ ກາ ຕະ ຣານະ ຕຶ່ງ ດຸງ ຊາງ ລາ ຕະ ມູເຈິງ ກັອຍ ເຕ່. ອັນ ເຮີມ ກວາຍ ເບິ ກັອຍ. ກະ ອັນ ແຕີ່ອ໌ ຕາງ່ອນ ເນ່ ມາໂຮຍ, ເຈີ່ ອັນ ເປາະ ວຍາຣ ຊັອງ ແຕ ກວາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ມາ ເບີນ ມານະ ແຕ ກຣວາງ ຊາມາເຣຍ ເປາະ ຕຶ່ງ ຣານາ ກັອຍ ເຕ່. ອັນ ເຮີມ ກວາຍ ເບິ ກັອຍ, ກະ ອັນ ຄຶ່ດ ອາໂຢ່ະ ຕະ ກວາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ອັນ ແຕີ່ອ໌ ປໍ ກວາຍ ເບິ ກັອຍ, ອັນ ທໍອ໌ ແດີອ໌ ຣາເຮົາ ກະ ບຼັອງ ຕຶ່ງ ເບິ, ເຈີ່ ອັນ ຕວມ ໂຈະ ອາຣິ. ແວັດ ກັອຍ ອັນ ອາແຣິ່ ກວາຍ ເບິ ກັອຍ ອາຊັອຮ ຕຶ່ງ ກຣັອງ ອາແຊັຮ ແຈລ ອັນ, ເຈີ່ ອັນ ເດີງ ກວາຍ ກັອຍ ແຕີ່ອ໌ ປໍ ດຸງ ກວາຍ ຕາມອຍ ຣາລູ່. ແອີດ ອຶງກັອຍ ກວາຍ ຊາມາເຣຍ ເນ່ ຊາລີອ໌ ກວາຍ ເບິ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ແຕີ່ອ໌ ຕາໄງ ປັຣແນີ ອັນ ອີດ ບາຣ ກຼອງ ປຣະ ອານາມ ແຕ ຕູຍ ອັນ ໂອນ ປໍ ກວາຍ ອຶນເຈົາ ດຸງ. ກະ ອັນ ປາຕັບ ອຶນເຈົາ ດຸງ ກັອຍ ປາຍ: 'ເກົາ ແຊອ໌ ເຍືາ ເນ່ ຈ່ອຍ ກວາຍ ໄນ່. ກະ ປັຣແນີ ມັນເຕຣືາ ເກົາ ເຈົາ ລັ່ຮ ຣານາ ໄນ່, ມາແລ່ະ ຊາອຶ່ຍ ປຣະ ເຍືາ ປິ່ດ ໂອນ ອັນ ຈາ, ເກົາ ກູລັຮ ລັ່ຮ ໂອນ ເຍືາ ມາຮ ກັອຍ.'\" ");
INSERT INTO ncq_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ແວັດ ເຢຊູ ອາຕີ ປັຣນາຍ ຊາກຳ ໄນ່, ອັນ ຕາແບີບ ກວາຍ ກາ ລ່ອງ ອັນ ປາຍ: \"ແຕ ກວາຍ ໄປ ນະ ກາ ເປາະ ຕຶ່ງ ຣານາ ກັອຍ, ກວາຍ ອາແລ່ະ ລາ ເຢົ່າ ກວາຍ ກາ ຊາແວງ ປົນ ກັອຍ?\" ");
INSERT INTO ncq_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ອັນ ກາ ອາຕີ ຄານອດ ອິດຊະຣາເອລ ກັອຍ ຕາແອີຍ ລັ່ຮ ເຢຊູ ປາຍ: \"ກວາຍ ກາ ຈ່ອຍ ອັນ ກາ ຊາແວງ ປົນ ກັອຍ ແກີດ ເຢົ່າ ອັນ.\" ນ່ະກັອຍ ເຢຊູ ອາຕີ ລັ່ຮ ອັນ ປາຍ: \"ອຶງເຄາະ ໄມ່ ຕະ ມູເຈິງ ກວາຍ ກັອຍ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ບັອງ ກາ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ເປາະ ຕຶ່ງ ຣານາ, ໄລ່ ມູ່ດ ຕຶ່ງ ມວຍ ວີ່ລ. ຕຶ່ງ ວີ່ລ ກັອຍ ເບີນ ມັນແຊມ ມານະ, ຣາມຶ່ຮ ລາ ມາທາ. ມາທາ ໄນ່ ຣັ່ບ ຣາບັນ ອໍ ໂຈະ ເຢຊູ, ໂອນ ເຢຊູ ມູ່ດ ຕຶ່ງ ດຸງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ມາທາ ໄນ່ ເບີນ ອາແອມ ມັນແຊມ, ຣາມຶ່ຮ ມາຣີ. ມາຣີ ໄນ່, ອັນ ຕາກູ ແຈ່ະ ອາເຢີງ ເຢຊູ ກະ ຊາງັດ ປັຣນາຍ ເຢຊູ ອາຕີ. ");
INSERT INTO ncq_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ມາ ມາທາ, ອັນ ເມືາອ໌ ຕັລ ຊາອຶ່ຍ ຣານະ. ນ່ະກັອຍ ອັນ ແຕີ່ອ໌ ປໍ ເຢຊູ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ອາແອມ ເກົາ ໂອນ ມານະ ເກົາ ຊັອງ ຕະ ຣານະ. ນານ່ະ ອຶນເຈົາ ຄຶ່ດ ແຕ ຣານະ ໄນ່? ເກົາ ແຊອ໌ ອຶນເຈົາ ແປຣີ ອາແອມ ເກົາ ແຕີ່ອ໌ ຈ່ອຍ ເກົາ ແຮີ.\" ");
INSERT INTO ncq_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ມາ ເຢຊູ ຕາແອີຍ ອັນ ປາຍ: \"ເອີ ມາທາ, ມາທາ ເອີຍ! ກັ່ດ ລາລື່ ໂອນ ໄມ່; ໄມ່ ເກຣ່າະ ກະ ຕັລ ຊາອຶ່ຍ ຣານະ. ");
INSERT INTO ncq_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ມາ ເບີນ ມວຍ ຣາມຶ່ຮ ຊັອງ ອຶງເຄາະ ໄມ່ ຣຽຮ. ມາຣີ ຣຽຮ ເຈີ່ ຣາມຶ່ຮ ກັອຍ, ກະ ຣາມຶ່ຮ ກັອຍ ເນົ່າ ຕາ ເຕ່ອ໌ ອີດ ລັ່ຮ ແຕ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ເບີນ ມວຍ ຕາໄງ ເຢຊູ ແອີດ ເກົາແຊອ໌ ຕຶ່ງ ມວຍ ອຶນຕຸ. ແວັດ ອັນ ເກົາແຊອ໌, ເບີນ ມານະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ແຊອ໌ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ແຊອ໌ ອຶນເຈົາ ອາຕີ ໂອນ ຮິ ດັງ ເກົາແຊອ໌, ມູເຈິງ ໂຢຮັນ ອາຕີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ນ່ະກັອຍ, ເຢຊູ ອາຕີ ໄລ່ ກັອຍ ປາຍ: \"ແຕີ່ອ໌ ເຍືາ ເກົາແຊອ໌, ເຍືາ ເກົາແຊອ໌ ປາຍ: 'ກູກຸຮ ອຶມປໍ່ ຮິ ເອີຍ! ແຊອ໌ ເຍືາ ຈ່ອຍ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ ຢຳນັ່ບ ຣາມຶ່ຮ ເຍືາ. ແຊອ໌ ເຍືາ ແກີດ ຊົດ ກູ່ ຣາງຶ່ຮ ກວາຍ ຕຶ່ງ ກູແຕອ໌ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ແຊອ໌ ເຍືາ ຈ່ອຍ ໂອນ ຮິ ເບີນ ຄຳ ຈາ ກູ່ ຣາໄງ. ");
INSERT INTO ncq_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ແຊອ໌ ເຍືາ ຕັຮ ໂລ່ຍຮ ກາ ຮິ ຕະ ເຈີ່, ມູເຈິງ ຮິ ຕັຮ ໂລ່ຍຮ ເນົ່າ ຕະ ໂຈະ ຮິ. ແຊອ໌ ເຍືາ ອຶນໂຈຍ ໂອນ ເນົ່າ ລ່ອງ ຮິ ຕະ ຣານະ ຕາ ອໍ.'\" ");
INSERT INTO ncq_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ເຢຊູ ອາຕີ ແອັນ ໂຈະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ເກົາ ຊາກຳ ນ່ະໄນ່: ນານ່ະ ເຍືາ ຄຶ່ດ ຄັນ ເຍືາ ເບີນ ເຢົ່າ, ກະ ເຍືາ ເປາະ ປໍ ດຸງ ເຢົ່າ ດີດຶ່ກ, ເຈີ່ ປາຍ: 'ອາຍ ເອີຍ! ເກົາ ແຊອ໌ ລັບ ໄປ ລອງ ອາແຊິ ໄມ່, ");
INSERT INTO ncq_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ຍ່ອນ ເບີນ ກວາຍ ຕາມອຍ ແຕີ່ອ໌ ປໍ ດຸງ ເກົາ, ມາ ເກົາ ຕາ ເບີນ ອຶນເຕົ່າ ອີ ອາລັ່ອຮ ໂອນ ຕາມອຍ ກັອຍ ຈາ.' ");
INSERT INTO ncq_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ອຶງກັອຮ ປຍາຍ໌ ເຢົ່າ ກັອຍ ຕາແອີຍ ລັ່ຮ ເຍືາ ປາຍ: 'ໄມ່ ອຶນໂຈຍ ກູອ໌ ປາຕຸ່ຮ ເກົາ ຊານໍ່, ຍ່ອນ ເກົາ ກາໄຕ່ຮ ຕົ່ງ ເຈີ່. ເກົາ ກະ ກອນ ອາໄກ ເກົາ ບິ ເຈີ່. ເກົາ ຕາ ເຕ່ອ໌ ຢວຣ ອີດ ໂອນ ໄມ່.' ");
INSERT INTO ncq_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ມາ ເກົາ ອາຕີ ເຍືາ ປາຍ: ອຶມປຶ່ ເຍືາ ແກີດ ເຢົ່າ ກະ ອັນ ລາ ອັນ ຕາ ເບີນ ໂອນ ເຍືາ ອາແຊິ. ມາ ຄັນ ເຍືາ ແຊອ໌ ມາຍິ່ຮ ມາຍີ່ດ ແຕ ອັນ, ລາ ອັນ ໂອນ ມາຮ ແລ່ະ ເຍືາ ອີ ເບີນ. ");
INSERT INTO ncq_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ກະ ເກົາ ປາຍ ແອັນ ໂຈະ ເຍືາ: ຄັນ ເຍືາ ແຊອ໌ ມາຍິ່ຮ ມາຍີ່ດ, ເຍືາ ເບີນ. ຄັນ ເຈຍ ເຍືາ ຈໍ່ອ໌, ເຍືາ ຣາມົຮ. ຄັນ ເຍືາ ກູໂຕຍຮ ຕົ່ງ ຊາໂກຼຮ ຊາກຼວານ, ເນົ່າ ເປິຮ ໂອນ. ");
INSERT INTO ncq_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ຍ່ອນ ກູ່ ນະ ອາແລ່ະ ກາ ແຊອ໌, ອັນ ເບີນ. ອາແລ່ະ ກາ ຈໍ່ອ໌, ອັນ ຣາມົຮ. ອາແລ່ະ ກາ ກູໂຕຍຮ ຕົ່ງ, ເນົ່າ ເປິຮ ໂອນ. ");
INSERT INTO ncq_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ມັຮ ເຍືາ ກາ ເບີນ ກອນ ເຈີ່, ນານ່ະ ຄັນ ກອນ ເຍືາ ແຊອ໌ ອາກາ, ເຍືາ ໂອນ ອັນ ກູຊັນ ບໍ? ");
INSERT INTO ncq_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ກະ ຄັນ ອັນ ແຊອ໌ ອຶນເຕຣ່ລ ອຶນຕຣວຍ, ເຍືາ ໂອນ ອັນ ຕຸ່ງເຕືາງ ບໍ? ");
INSERT INTO ncq_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ເຍືາ ລາ ອຶນແຍ່ະ ກວາຍ ໂລ່ຍຮ, ມາ ອຶນນັ່ອງ ເຍືາ ດັງ ໂອນ ເກຣີ່ງ ອໍ ປໍ ກອນ ເຍືາ. ກາເລີຍ ແຕ ກັອຍ ແອັນ ອຶມປໍ່ ເຍືາ ຕຶ່ງ ມັນລັ່ອງ ໂອນ ເຍືາ ເບີນ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ຄັນ ເຍືາ ແຊອ໌ ແຕ ອັນ!\" ");
INSERT INTO ncq_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ບັອງ ກາ ກັອຍ ເຢຊູ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ກາ ຕະ ໂອນ ກວາຍ ກັອຍ ແກີດ ເກີອ໌. ແວັດ ເຢືາງ ຕາ ອໍ ກັອຍ ລັ່ອຮ ແຕ ຈະ ກວາຍ ກັອຍ, ເຈີ່ ກວາຍ ກັອຍ ເຕ່ອ໌ ລັ່ຮ ຕະ ອຶນຕີ. ກວາຍ ກຼຶ່ງ ກັອຍ, ໄລ່ ຊັອງ ງຶ່ດ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ມາ ເບີນ ກວາຍ ແຕ ໄລ່ ກັອຍ ປາຍ: \"ອັນ ໄນ່ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ຍ່ອນ ເຢືາງ ເບເອລເຊບູລ ໂອນ ອັນ ເບີນ ອຳນາດ ຕະ ຣານະ ກັອຍ. ເຢືາງ ເບເອລເຊບູລ ໄນ່ ລາ ຊົດ ອຶນແຍ່ະ ເຢືາງ ຕາ ອໍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ກະ ເບີນ ກວາຍ ການໍ່ອ໌ ຢໍອ໌ ອີ ລ່ອງ ເຢຊູ; ເຈີ່ ໄລ່ ແຊອ໌ ແຕ ເຢຊູ ໂອນ ອັນ ຕະ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ອາປັຮ ໂອນ ໄລ່ ດັງ ອຳນາດ ອັນ ແຕີ່ອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ມາ ເຢຊູ ດັງ ການິ່ດ ໄລ່ ຄຶ່ດ ນ່ະກັອຍ, ເຈີ່ ອັນ ອາຕີ ໄລ່ ກັອຍ ປາຍ: \"ຄັນ ເບີນ ມວຍ ກຣວາງ ມາ ຣາຕັຮ ແກີດ ຊາອຶ່ຍ ຈຸ່ມ ມານະ ຣາຕະ ໂຈະ ມານະ, ເຈີ່ ກຣວາງ ກັອຍ ຕາ ເບີນ ແກີດ ນັ່ອງ ກຣວາງ. ກະ ຄັນ ແອີດ ມູ່ ດຸງ ມາ ມານະ ຣາຕະ ໂຈະ ມານະ, ເຈີ່ ດຸງ ກັອຍ ຕາ ເບີນ ແກີດ ນັ່ອງ ດຸງ. ");
INSERT INTO ncq_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ຄັນ ຈຸ່ມ ເຢືາງ ຊາຕານ, ມານະ ຣາຕະ ໂຈະ ມານະ, ເຈີ່ ຈຸ່ມ ເຢືາງ ຊາຕານ ກັອຍ ຕາ ເບີນ ແກີດ ນັ່ອງ ຈຸ່ມ. ມາ ເຍືາ ປາຍ ເກົາ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ຍ່ອນ ເຢືາງ ເບເອລເຊບູລ ໂອນ ເກົາ ເບີນ ອຳນາດ ຕະ ຣານະ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ມາ ຄັນ ກວາຍ ແຕ ມູ່ ເຍືາ ຕະ ຣານະ ມູເຈິງ ກັອຍ ເຕ່, ເຍືາ ຕາ ເບີນ ປາຍ ໄລ່ ເບີນ ອຳນາດ ແຕ ເຢືາງ ເບເອລເຊບູລ. ນ່ະກັອຍ, ກວາຍ ແຕ ມູ່ ເຍືາ ແຕິ່ ກາ ເຕ່ອ໌ ຕັດຊີ່ນ ເຍືາ ແຕ ຣານະ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ມາ ຄັນ ເກົາ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ຍ່ອນ ແຕ ອຳນາດ ເຢືາງ ເຈົາຣາຊີ ໂອນ ເກົາ ຕະ, ຣານະ ໄນ່ ອາປັຮ ໂອນ ເຍືາ ດັງ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ແຕີ່ອ໌ ເຈີ່ ປໍ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","\"ຄັນ ເບີນ ກວາຍ ບັນ ເຣ່ງ ລາລື່, ກະ ອັນ ເບີນ ຊາອຶ່ຍ ເກຣີ່ງ ປຼາ ດໍອ໌ ກຍາອ໌ ເກຣີ່ງ ອັນ, ເກຣີ່ງ ອັນ ຕາ ເບີນ ປິ່ດ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ມາ ຄັນ ເບີນ ກວາຍ ບັນ ເຣ່ງ ກາເລີຍ ແຕ ອັນ ແອັນ, ກວາຍ ກັອຍ ຣາຕະ ກະ ເຣືາບ ອັນ, ເຈີ່ ອີດ ອຶນແຍ່ະ ເກຣີ່ງ ປຼາ ແຕ ດຸງ ອັນ. ເຈີ່ ກວາຍ ກາ ເຣືາບ ກັອຍ ອຶມແປອ໌ ອຶນແຍ່ະ ເກຣີ່ງ ກັອຍ, ໂອນ ໄລ່ ກາ ເປາະ ກະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","\"ກວາຍ ອາແລ່ະ ມາ ຕາ ເບີນ ປຣ່ອມ ມວຍ ຣາງຶ່ຮ ກະ ເກົາ, ກວາຍ ກັອຍ ຕາ ແອອ໌ ເກົາ. ກະ ກວາຍ ອາແລ່ະ ມາ ຕາ ເບີນ ຕະ ຣານະ ຈ່ອຍ ໂອນ ກວາຍ ການໍ່ອ໌ ແຕີ່ອ໌ ປໍ ເກົາ, ໄນ່ ລາ ມູເຈິງ ກວາຍ ກັອຍ ຕາ ຢໍອ໌ ອີ ໂອນ ກວາຍ ການໍ່ອ໌ ປວາຍ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","\"ພໍກາ ເຢືາງ ຕາ ອໍ ລັ່ອຮ ແວັດ ແຕ ຈະ ກວາຍ, ເຈີ່ ເຢືາງ ຕາ ອໍ ກັອຍ ເປາະ ຕຶ່ງ ອຶນຕຸ ຊາແອີດ. ອັນ ຈໍ່ອ໌ ອຶນຕຸ ອີ ຣາລູ່, ມາ ອັນ ຕາ ເບີນ ຣາມົຮ. ເຈີ່ ອັນ ຄຶ່ດ ປາຍ: 'ເກົາ ເຈົາ ລັ່ຮ ປໍ ອຶນຕຸ ກາ ເກົາ ລັ່ອຮ ແຕ ອຶນໂຍ່ງ ຊາ.' ");
INSERT INTO ncq_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ພໍກາ ອັນ ເຈົາ ປໍ ອຶນຕຸ ກັອຍ, ອັນ ເຮີມ ແອີງ ອຶນຕຸ ເມືາດ ຊັອງ. ອຶນຕຸ ກັອຍ ຊຽລ ອໍ, ກະ ເກຣີ່ງ ອຶນເຕົ່າ ຕຶ່ງ ອຶນຕຸ ກັອຍ ອາຕຶ່ ອໍ ອຶນແຍ່ະ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ເຈີ່ ອັນ ເປາະ ອີດ ເດີງ ອາເຈົາ ຕາປູ່ລ ນະ ເຢືາງ ຕາ ອໍ ການໍ່ອ໌ ແອັນ ໂອນ ແອີດ ກະ ອັນ ຕຶ່ງ ອຶນຕຸ ກັອຍ. ໄລ່ ລາ ຕາ ອໍ ກາເລີຍ ແຕ ອັນ ແອັນ. ນ່ະກັອຍ ແດີຍ ອາມົ່ງ ກວາຍ ກັອຍ ຕາ ອໍ ກາເລີຍ ແຕ ອຶນໂຍ່ງ ແອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ບັອງ ກາ ເຢຊູ ອາຕີ ປັຣນາຍ ກັອຍ, ເບີນ ມັນແຊມ ມານະ ແຕ ກວາຍ ກຼຶ່ງ ກັອຍ ປາຍ ເຣ່ງ ລາລື່ ໂຈະ ອັນ: \"ບຸ່ນ ລາລື່ ມັນແຊມ ກາ ກາແນີດ ອາຈານ, ກະ ໂອນ ອາຈານ ອູອ໌ ຕົຮ!\" ");
INSERT INTO ncq_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ມາ ເຢຊູ ອາຕີ ລັ່ຮ ປາຍ: \"ຣາມຶ່ຮ ກັອຍ ລາ ປຍາຍ໌ ເຕ່, ມາ ບຸ່ນ ກາເລີຍ ແຕ ກັອຍ ແອັນ ລາ ກວາຍ ກາ ຊັອງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ກະ ຕະ ປວາຍ ອຶນແຍ່ະ ປັຣນາຍ ກັອຍ!\" ");
INSERT INTO ncq_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ບັອງ ກາ ກຼຶ່ງ ກວາຍ ແອີດ ໂຣ່ມ ອຶມແປຣ ເຢຊູ, ອັນ ອາຕີ ໄລ່ ກັອຍ ປາຍ: \"ມັຮ ກວາຍ ກາ ແອີດ ຕຶ່ງ ແດີຍ ໄນ່ ລາ ຕາ ອໍ ລາລື່! ໄລ່ ແຊອ໌ ແຕ ເກົາ ມວຍ ຣາມຶ່ຮ ຕາ ເກີ່ຍ ເຮີມ, ມາ ເກົາ ຕາ ເບີນ ຕະ ໂອນ ໄລ່. ເກົາ ອີ ອາປັຮ ໄລ່ ແອີງ ຣາມຶ່ຮ ຕາ ເກີ່ຍ ເຮີມ ແຕ ໂຢນາ, ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ. ");
INSERT INTO ncq_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ໂຢນາ ແກີດ ມວຍ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ໂອນ ກວາຍ ກາ ແອີດ ຕຶ່ງ ເມືອງ ນີນາເວ. ມູເຈິງ ກັອຍ ເຕ່ ເກົາ ກອນ ເຢືາງ ແກີດ ກວາຍ ແກີດ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ໂອນ ກວາຍ ກາ ແອີດ ຕຶ່ງ ແດີຍ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ແຕີ່ອ໌ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ອາເບຼິຮ ອຶນແຍ່ະ ມັຮ ກວາຍ, ເບີນ ມັນແຊມ ກາ ແກີດ ເຕືາວ ປັຣເຍືາ ແຕ ອຶມແບິ, ຕຶ່ງ ກຣວາງ ເຊບາ, ອັນ ຕິ ກວາຍ ແອີດ ຕຶ່ງ ແດີຍ ໄນ່. ອັນ ເຕ່ອ໌ ຕິ ນ່ະກັອຍ, ຍ່ອນ ອັນ ແຕີ່ອ໌ ແຕ ກຣວາງ ເຢີ່ງ ລາລື່ ຢໍອ໌ ອີ ຊາງັດ ປັຣນາຍ ແຄວ໌ ແຕ ເຕືາວ ປັຣເຍືາ ໂຊໂລໂມນ ອາຕີ. ມາ ຊານໍ່, ແອີດ ອຶນໄນ່ ເບີນ ມານະ ແຄວ໌ ກາເລີຍ ແຕ ໂຊໂລໂມນ ແອັນ! ");
INSERT INTO ncq_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ແຕີ່ອ໌ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ອາເບຼິຮ ອຶນແຍ່ະ ມັຮ ກວາຍ, ກວາຍ ແຕ ເມືອງ ນີນາເວ ແຕ ອຶມແບິ ລາລື່ ຕິ ກວາຍ ແອີດ ຕຶ່ງ ແດີຍ ໄນ່. ໄລ່ ເຕ່ອ໌ ຕິ ນ່ະກັອຍ, ລາ ຍ່ອນ ບັອງ ກາ ໄລ່ ຊັອງ ປັຣນາຍ ໂຢນາ ອາຕີ, ໄລ່ ຕັຮ ຣາງຶ່ຮ ຕຍາ ເຈີ່ ອີດ ຣາງຶ່ຮ ຕາໄມ ແອັນ. ມາ ຊານໍ່, ແອີດ ອຶນໄນ່ ເບີນ ມານະ ປື່ດ ກາເລີຍ ແຕ ໂຢນາ!\" ");
INSERT INTO ncq_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ເຢຊູ ອາຕີ ແອັນ ປາຍ: \"ຕາ ເບີນ ເນົ່າ ຕາກັດ ຕາກຍາງ, ເຈີ່ ປາໂຕ່ະ ດໍອ໌, ແຕີລາ ກຣວາອ໌ ໂຈະ ກາເຣຍ. ມາ ເນົ່າ ດໍອ໌ ຕຶ່ງ ໂຣ່ງ ໂອນ ກູ່ ນະ ກວາຍ ກາ ມູ່ດ ເຕ່ອ໌ ເຮີມ ປັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ມັ່ດ ກວາຍ ລາ ນ່ະ ຕາບອງ ໂອນ ຈະ ກວາຍ. ຄັນ ມັ່ດ ເຍືາ ມາ ເຮີມ, ອຶນແຍ່ະ ຈະ ເຍືາ ແກີດ ປັ່ງ ເຕ່. ມາ ຄັນ ມັ່ດ ເຍືາ ຕາ ເບີນ ເຮີມ, ອຶນແຍ່ະ ຈະ ເຍືາ ແກີດ ການຳ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ນ່ະກັອຍ ອຶງເຄາະ ເຍືາ ເນ່ ອໍ, ອຶງກັອຮ ປຍາຍ໌ ຣານະ ກາ ເຍືາ ຄຶ່ດ ປາຍ ປັ່ງ, ມາ ຕາ ເບີນ ປັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ຄັນ ເຍືາ ມາ ປວາຍ ອຶນແຍ່ະ ຣາມຶ່ຮ ປັ່ງ, ຕາ ເບີນ ປວາຍ ຣາມຶ່ຮ ການຳ ອຶນເຕົ່າ, ນ່ະກັອຍ ອຶນແຍ່ະ ຣາງຶ່ຮ ເຍືາ ແກີດ ປັ່ງ. ໄນ່ ລາ ນ່ະ ຕາກຍາງ ປາເລືາງ ໂອນ ເຍືາ ເຕ່ອ໌ ເຮີມ ປັ່ງ.\" ");
INSERT INTO ncq_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ບັອງ ກາ ເຢຊູ ອຶນນັ່ອງ ອາຕີ, ເບີນ ມານະ ແຕ ຈຸ່ມ ພາຣີຊາຍ ການື່ຍ ເຢຊູ ແຕີ່ອ໌ ຈາ ມວຍ ເປ່ລ ປໍ ດຸງ ອັນ. ເຈີ່ ເຢຊູ ເປາະ ຈາ ປໍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ກວາຍ ພາຣີຊາຍ ກັອຍ ຊັອງ ງຶ່ດ ລາລື່ ອັນ ເຮີມ ເຢຊູ ຕາ ເບີນ ກູໂຊຍ໌ ອາຕີ ປວາຍ ຣີ່ດ ແຕ ອຶນໂຍ່ງ ອັນ ອີ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ນ່ະກັອຍ ເຢຊູ ອາຕີ ໂຈະ ກວາຍ ກັອຍ ປາຍ: \"ເຍືາ ກວາຍ ພາຣີຊາຍ ລາ ນ່ະ ຕາງານ ກະ ກູໂຕອ໌ ເນົ່າ ອາເຣືາວ ໂອນ ຊຽລ ອໍ ແອີງ ຢັ່ຮ ປື່ນ ໂກຼະ ຊັອງ, ມາ ຕຶ່ງ ແປີງ ງັ່ຮ ກັອຍ ແອີງ ແປຣິ່. ແປຣິ່ ກັອຍ ລາ ເຍືາ ກຸມປູ່ຣ ອີ ເບີນ ຊາອຶ່ຍ ຣາມຶ່ຮ ກະ ເຍືາ ລາ ຕາ ອໍ ລາລື່! ");
INSERT INTO ncq_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ເຍືາ ລາ ກວາຍ ຊາກູລ ລາລື່! ອັນ ກາ ແຕງ ຈະ ກວາຍ, ອັນ ແຕງ ກາ ຣາງຶ່ຮ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ມາ ອຶງເຄາະ ເຍືາ ເບີນ ຣາງຶ່ຮ ອີ ຈ່ອຍ ກວາຍ ກາດີດ. ຄັນ ນ່ະກັອຍ, ເຍືາ ແກີດ ຊຽລ ອໍ ຢັ່ຮ ກຼຸງ ກະ ຢັ່ຮ ນໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","\"ບາບ ລາລື່ ແຕີ່ອ໌ ປໍ ເຍືາ ກວາຍ ພາຣີຊາຍ ເອີຍ! ເຍືາ ມ່ອບ ຊາງ ໂອນ ເຢືາງ ເຈົາຣາຊີ ມວຍ ປຸ່ນ ມັນຈິ່ດ ແຕ ບັດ ບາຍ ອາຊາຍ ປາຕຽມ ເຍືາ. ມາ ເຍືາ ຕາ ແອອ໌ ອີ ຕະ ປວາຍ ປັຣນາຍ ປາຕັບ ໂອນ ຕະ ຊັງໄກຣ ອໍ ກະ ອາໂຢ່ະ ເຢືາງ ເຈົາຣາຊີ. ເກົາ ຕາ ເບີນ ໂອນ ເຍືາ ຕັຮ ຣີ່ດ ມ່ອບ ຊາງ ກັອຍ, ມາ ບາຣ ຣາມຶ່ຮ ການໍ່ອ໌ ກັອຍ ອຶງເຄາະ ເຍືາ ຕະ ປວາຍ. ");
INSERT INTO ncq_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","\"ບາບ ລາລື່ ແຕີ່ອ໌ ປໍ ເຍືາ ກວາຍ ພາຣີຊາຍ ເອີຍ! ເຍືາ ຢໍອ໌ ອີ ເບີນ ກາເຈີ່ງ ຕາກູ ອໍ ກາເລີຍ ອຶນແຍ່ະ ແຕ ການໍ່ອ໌ ຕຶ່ງ ດຸງ ຊາງ. ກະ ເຍືາ ຢໍອ໌ ກວາຍ ການໍ່ອ໌ ຣາບັນ ອໍ ເຍືາ ບັອງ ກາ ເຍືາ ແອີດ ກະ ກວາຍ ກຼຶ່ງ. ");
INSERT INTO ncq_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ບາບ ລາລື່ ແຕີ່ອ໌ ປໍ ເຍືາ ກວາຍ ພາຣີຊາຍ ເອີຍ! ເຍືາ ລາ ນ່ະ ປີ່ງ ກູມູ່ຍ໌ ຕາ ເບີນ ຕະ ໂອນ ເນົ່າ ດັງ. ນ່ະກັອຍ ກວາຍ ການໍ່ອ໌ ເປາະ ຊາເຕືາຍ໌ ປີ່ງ ກັອຍ, ມາ ໄລ່ ຕາ ເບີນ ດັງ ອຶນຕຸ ກັອຍ ລາ ແປຣິ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ເບີນ ມານະ ກວາຍ ອາຕີ ຄານອດ ປາຍ ໂຈະ ເຢຊູ: \"ອາຈານ ເອີຍ! ອາຈານ ປາຍ ນ່ະກັອຍ, ລາ ມູເຈິງ ອາຈານ ຕິ ຮິ ກາ ກວາຍ ອາຕີ ຄານອດ ເຕ່!\" ");
INSERT INTO ncq_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ເຢຊູ ອາຕີ ອັນ ປາຍ: \"ບາບ ລາລື່ ເຕ່ ແຕີ່ອ໌ ປໍ ເຍືາ ກາ ກວາຍ ອາຕີ ຄານອດ! ເຍືາ ອາຕີ ໂອນ ກວາຍ ການໍ່ອ໌ ປວາຍ ຄານອດ ກັ່ດ ລາລື່ ນ່ະ ເຍືາ ໂອນ ໄລ່ ໂດລ ເກຣີ່ງ ອຶນຕັອງ. ມາ ອາຕີ ເຍືາ ຕາ ເບີນ ອີດ ຈ່ອຍ ອຶນເຕົ່າ ເກຣີ່ງ ອຶນຕັອງ ແຕ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ບາບ ລາລື່ ແຕີ່ອ໌ ປໍ ເຍືາ! ເຍືາ ຕະ ປີ່ງ ອໍ ໂອນ ກວາຍ ກາ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ມາ ອາຈວາຍຮ ອາເຈ່ຮ ເຍືາ ແຕິ່ ກາຈີດ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ນ່ະກັອຍ, ໄນ່ ລາ ມູເຈິງ ເຍືາ ງີ່ນ ເຍືາ ປຣ່ອມ ເຕ່ ກະ ຣານະ ອາຈວາຍຮ ອາເຈ່ຮ ເຍືາ ຕະ, ຍ່ອນ ໄລ່ ກາຈີດ ມັຮ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ກະ ເຍືາ ຕະ ປີ່ງ ໂອນ ກວາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ມາ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ແຄວ໌ ລາລື່ ປາຍ: 'ປັຣແນີ ມັນເຕຣືາ ເກົາ ແປຣີ ມັຮ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເກົາ ກະ ມັຮ ກວາຍ ເປາະ ອາຕີ ປັຣນາຍ ເກົາ ແຕີ່ອ໌ ປໍ ໄລ່. ເບີນ ກວາຍ ແຕ ມູ່ ກັອຍ, ອັນ ກາ ໄລ່ ກາຈີດ, ອັນ ກາ ໄລ່ ປຍາຍຮ.' ");
INSERT INTO ncq_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ນ່ະກັອຍ ມັຮ ໄລ່ ກາ ກາຈີດ ຕັຮ ອຶນແຍ່ະ ມັຮ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ກັອຍ, ໂຕ່ດ ໄລ່ ກັອຍ ເຢືາງ ເຈົາຣາຊີ ໂອນ ແຕີ່ອ໌ ປໍ ກວາຍ ແອີດ ຕຶ່ງ ແດີຍ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ໂຕ່ດ ກັອຍ ເບີນ ແຕ ຕາໄງ ໄລ່ ກາຈີດ ອາເບລ, ເຕົ່າ ໂອນ ແຕີ່ອ໌ ໄລ່ ກາຈີດ ເຊກາຣີຢາ ແອັນ. ໄລ່ ກາຈີດ ຕັຮ ເຊກາຣີຢາ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ ແຈ່ະ ຊັນເຕຣືາງ ກາ ໄລ່ ຊາງ ຣີ່ດ. ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ກູ່ ຣາມຶ່ຮ ໂຕ່ດ ກັອຍ ແຕີ່ອ໌ ປໍ ກວາຍ ກາ ແອີດ ຕຶ່ງ ແດີຍ ໄນ່! ");
INSERT INTO ncq_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","\"ບາບ ລາລື່ ແຕີ່ອ໌ ປໍ ເຍືາ ກາ ກວາຍ ອາຕີ ຄານອດ, ຍ່ອນ ເຍືາ ຕາ ແອອ໌ ອີ ປວາຍ ຣານະ ເຢືາງ ເຈົາຣາຊີ ໂອນ ເຍືາ ປວາຍ. ກະ ກວາຍ ການໍ່ອ໌ ກາ ຢໍອ໌ ອີ ປວາຍ, ເຈີ່ ເຍືາ ຕາ ໂອນ ປວາຍ ເຕ່! ໄນ່ ລາ ນ່ະ ເຍືາ ໄກຼ່ຮ ດໍອ໌ ງັ່ຮ ຕົ່ງ ກາ ເຍືາ ຕາ ແອອ໌ ອີ ມູ່ດ, ໂອນ ກວາຍ ການໍ່ອ໌ ຕາ ເຕ່ອ໌ ມູ່ດ ເຕ່!\" ");
INSERT INTO ncq_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ບັອງ ກາ ເຢຊູ ລັ່ອຮ ແຕ ດຸງ ກັອຍ, ມັຮ ກວາຍ ອາຕີ ຄານອດ ກະ ມັຮ ກວາຍ ພາຣີຊາຍ, ໄລ່ ຕາແບິ ຈໍ່ອ໌ ຣານາ ອີ ຕະ ອັນ ກະ ໄລ່ ຕາແບີບ ເຢຊູ ແຕ ຊາອຶ່ຍ ຣາມຶ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ໄລ່ ຊາງັດ ທໍ ຢໍອ໌ ອີ ດັງ ແຕ ປັຣນາຍ ເຢຊູ ປາຍ, ໂອນ ໄລ່ ເຕ່ອ໌ ຕູນ ປາຍ ອັນ ຕະ ອຶນຕີ ໂລ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ບັອງ ກາ ກັອຍ ຕາ ດັງ ອຶນຊິ ປັ່ນ ນະ ກວາຍ ແອີດ ໂຣ່ມ ອຶງກັອຍ. ກຼຶ່ງ ລາລື່ ກວາຍ, ມານະ ຊາເຕືາຍ໌ ອາເຢີງ ມານະ. ອຶນໂຍ່ງ ເຢຊູ ອາຕີ ກວາຍ ການໍ່ອ໌, ອັນ ອາຕີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ໂອນ ເຍືາ ລາວັ່ງ ບວຮ ຊື່ອ໌ ແຕ ຈຸ່ມ ພາຣີຊາຍ. ບວຮ ຊື່ອ໌ ກັອຍ ລາ ຊາກຳ ແຕ ໄລ່ ອາຕີ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ມາ ໄລ່ ຕາ ເບີນ ຕະ ປວາຍ. ");
INSERT INTO ncq_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ຄັນ ເບີນ ຣາມຶ່ຮ ອຶນເຕົ່າ ເນົ່າ ປູ່ລ ປາໂຕ່ະ ຊານໍ່, ເຈີ່ ປໍ ເມືາງ ຣາມຶ່ຮ ກັອຍ ເນົ່າ ຕາ ເຕ່ອ໌ ປູ່ລ ປາໂຕ່ະ ນັ່ອງ. ກະ ຣານະ ອຶນເຕົ່າ ເນົ່າ ຕະ ແກຣ່ະ ຊານໍ່, ເຈີ່ ປໍ ເມືາງ ຣານະ ກັອຍ ເນົ່າ ຕາ ເຕ່ອ໌ ຕະ ແກຣ່ະ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ນ່ະກັອຍ, ປັຣນາຍ ອຶນເຕົ່າ ເຍືາ ອາຕີ ຕຶ່ງ ການຳ, ປັຣແນີ ມັນເຕຣືາ ກວາຍ ຊັອງ ຕຶ່ງ ປັ່ງ ແອັນ ປັຣນາຍ ກັອຍ. ກະ ປັຣນາຍ ອຶນເຕົ່າ ເຍືາ ຣາຮາຍ໌ ຕຶ່ງ ກູຕູຣ ກວາຍ ຕຶ່ງ ກຼຸງ ແກຣ່ະ, ປັຣແນີ ມັນເຕຣືາ ເນົ່າ ອາຕີ ເຣ່ງ ລາລື່ ແຕ ຕຳປວລ ດຸງ. ");
INSERT INTO ncq_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","\"ເຢົ່າ ເອີຍ! ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ ປາຍ: ອຶນໂຈຍ ອຶງກັອຮ ໄລ່ ກາ ເຕ່ອ໌ ກາຈີດ ແອີງ ຈະ ເຍືາ ຊັອງ, ມາ ແວັດ ໄລ່ ກາຈີດ ຈະ ເຍືາ, ໄລ່ ຕາ ເຕ່ອ໌ ຕະ ອຶນເຕົ່າ ນັ່ອງ ໂຈະ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ເກົາ ອາຕີ ໂອນ ເຍືາ ດັງ ເຍືາ ອຶງເຄາະ ອຶງກັອຮ ເນົ່າ. ເຍືາ ອຶງເຄາະ ອຶງກັອຮ ເຢືາງ ເຈົາຣາຊີ, ຍ່ອນ ເຢືາງ ເຈົາຣາຊີ ເຕ່ອ໌ ກາຈີດ ຈະ ເຍືາ, ກະ ຣາເວືາຍ ເຍືາ ເຕ່ອ໌ ອັນ ອາປັອງ ຕຶ່ງ ປຣຸ່ງ ອູ່ຍຮ. ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ອຶງເຄາະ ເຍືາ ອຶງກັອຮ ເຢືາງ ເຈົາຣາຊີ! ");
INSERT INTO ncq_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","\"ເຊີງ ລໍາ ແຈມ ຈາບ ເນົ່າ ຈິ, ມາ ເກືາ ອັນ ບາຣ ຢາດ ຊັອງ. ມາ ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ຊາລີຣ ມານຳ ແຕ ແຈມ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ມາ ກູ່ ເຊັນ ໂຊະ ຕຶ່ງ ແປຼີ ເຍືາ, ເຢືາງ ເຈົາຣາຊີ ນັ່ບ ເຈີ່. ນ່ະກັອຍ ເຍືາ ອຶນໂຈຍ ອຶງກັອຮ ອຶນເຕົ່າ ນັ່ອງ, ຍ່ອນ ຣາງຶ່ຮ ເຍືາ ລາ ເຢືາງ ເຈົາຣາຊີ ປາຊິ ກາເລີຍ ແຕ ຊາອຶ່ຍ ລໍາ ແຈມ ຈາບ. ");
INSERT INTO ncq_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","\"ເກົາ ອາຕີ ເຍືາ ປາຍ: ກວາຍ ອາແລ່ະ ມາ ງີ່ນ ຢັ່ຮ ເມືາງ ກວາຍ ການໍ່ອ໌, ປາຍ ອັນ ເບີນ ມວຍ ຣາງຶ່ຮ ກະ ເກົາ, ມູເຈິງ ກັອຍ ເຕ່ ເກົາ, ກອນ ເຢືາງ ແກີດ ກວາຍ, ງີ່ນ ລັ່ຮ ອັນ ຢັ່ຮ ເມືາງ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ມາ ຄັນ ກວາຍ ອາແລ່ະ ມາ ກາແລີຍຮ ເກົາ ຢັ່ຮ ເມືາງ ກວາຍ ການໍ່ອ໌, ມູເຈິງ ກັອຍ ເຕ່ ເກົາ ກາແລີຍຮ ລັ່ຮ ອັນ ຢັ່ຮ ເມືາງ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","\"ກວາຍ ອາແລ່ະ ມາ ພາມາດ ເກົາ, ກອນ ເຢືາງ ແກີດ ກວາຍ, ເຢືາງ ເຈົາຣາຊີ ເຕ່ອ໌ ຕັຮ ໂລ່ຍຮ ກັອຍ. ມາ ຄັນ ກວາຍ ອາແລ່ະ ມາ ພາມາດ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ, ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ຕັຮ ນັ່ອງ ໂລ່ຍຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","\"ແຕີ່ອ໌ ເນົ່າ ຕູນ ເຍືາ ປໍ ດຸງ ຊາງ, ແຕີລາ ຢັ່ຮ ເມືາງ ກວາຍ ຊົດ, ເຍືາ ອຶນໂຈຍ ອຸກ ດໍອ໌ ອຶນເຕົ່າ ເຍືາ ຢໍອ໌ ອີ ຕາແອີຍ ໂຈະ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ບັອງ ກາ ກັອຍ ເບີນ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ອີ ອາຕີ ເຍືາ ມັຮ ປັຣນາຍ ອຶນເຕົ່າ ເຍືາ ຢໍອ໌ ອີ ປາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ເບີນ ມານະ ຕຶ່ງ ກວາຍ ກຼຶ່ງ ກັອຍ ປາຍ ກະ ເຢຊູ ນ່ະໄນ່: \"ອາຈານ ເອີຍ! ແຊອ໌ ອາຈານ ແປຣີ ອາຍ ເກົາ ອຶມແປອ໌ ໂອນ ເກົາ ມູ່ນ ອຶມປໍ່ ຮິ.\" ");
INSERT INTO ncq_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ເຢຊູ ຕາແບີບ ລັ່ຮ ກວາຍ ກັອຍ ປາຍ: \"ເນົ່າ ກາ ໂອນ ເກົາ ເບີນ ອຳນາດ ດໍອ໌ ຕັດຊີ່ນ ອຶມແປອ໌ ມູ່ນ ເຍືາ ບາຣ ນະ?\" ");
INSERT INTO ncq_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ເຈີ່ ເຢຊູ ອາຕີ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ ອຶມແປຣ ກັອຍ ປາຍ: \"ເຍືາ ລາວັ່ງ ອໍ, ອຶງກັອຮ ຣາງຶ່ຮ ເຍືາ ແກີດ ຮາຣ ຢໍອ໌ ອີ ຊຸ ເບີນ, ມາ ກວາຍ ຕາ ເບີນ ອາມົ່ງ ຍ່ອນ ເບີນ ເກຣີ່ງ ຊາອຶ່ຍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ເຢຊູ ອາຕີ ປັຣນາຍ ຊາກຳ ປາຍ: \"ເບີນ ມານະ ກວາຍ ຊຸ, ປາໄລ ຊັຣນົຮ ຕຶ່ງ ໄທຣ ອັນ ແກີດ ຊາອຶ່ຍ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ກວາຍ ກັອຍ ຄຶ່ດ ຕຶ່ງ ຣາງຶ່ຮ ອັນ ປາຍ: 'ຕາ ເບີນ ນັ່ອງ ອຶນຕຸ ອີ ດໍອ໌ ປາໄລ ແຕ ໄທຣ ເກົາ. ນານ່ະ ເກົາ ອີ ຕະ?' ");
INSERT INTO ncq_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ເຈີ່ ອັນ ຄຶ່ດ ແອັນ: 'ເກົາ ອີ ຕະ ນ່ະໄນ່: ເກົາ ອີ ມາງ ດຸງ ຕຍາ, ຕະ ລັ່ຮ ດຸງ ຕາໄມ ປື່ດ ກາເລີຍ ແອັນ; ກະ ເກົາ ອີ ປາໂຣມ ດໍອ໌ ຕຶ່ງ ກັອຍ ອຶນແຍ່ະ ທຣໍ ເກົາ ກະ ອຶນແຍ່ະ ເກຣີ່ງ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ເຈີ່ ເກົາ ຄຶ່ດ ນ່ະໄນ່: ເກົາ ເບີນ ຊາອຶ່ຍ ລາລື່. ຊາອຶ່ຍ ກູມໍ ເກົາ ຕາ ເບີນ ຕັລ ອີ ຕະ ນັ່ອງ, ມາ ເກົາ ເບີນ ຈາ ເລືອຍໆ. ນ່ະກັອຍ ເກົາ ແອີດ ອຽນ, ຕັອກ ຊັອງ, ງ່ອຍ໌ ຈາ ຊັອງ.' ນ່ະກັອຍ ກວາຍ ຊຸ ກັອຍ ຄຶ່ດ. ");
INSERT INTO ncq_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ມາ ເຢືາງ ເຈົາຣາຊີ ປາຍ ໂຈະ ກວາຍ ຊຸ ກັອຍ ນ່ະໄນ່: 'ໄມ່ ລາ ກວາຍ ຊາກູລ ລາລື່. ຊາເດົາ ໄນ່ ແຕິ່ ອຶນແຍ່ະ ແດີຍ ອາມົ່ງ ໄມ່. ເຈີ່ ອຶນແຍ່ະ ມັຮ ຊານົກ ໄມ່ ປາໂຣມ, ເນົ່າ ແອັນ ເບີນ ຕາລາ?'\" ");
INSERT INTO ncq_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ເຈີ່ ເຢຊູ ປາຍ: \"ມູເຈິງ ກັອຍ ເຕ່ ກວາຍ ກາ ຢໍອ໌ ອີ ປາໂຣມ ຊາອຶ່ຍ ເກຣີ່ງ, ມາ ອັນ ຕາ ເບີນ ຊຸ ອຶນເຕົ່າ ຢັ່ຮ ເມືາງ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ເຈີ່ ເຢຊູ ອາຕີ ແອັນ ໂຈະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ນ່ະກັອຍ ເກົາ ອາຕີ ເຍືາ, ເຍືາ ອຶນໂຈຍ ອຸກ ແຕ ແດີຍ ອາມົ່ງ ເຍືາ ຊານໍ່, ຊັຣນາ ເຍືາ ຈາ, ແດີອ໌ ເຍືາ ງ່ອຍ໌, ກະ ຕຳປັອກ ເຍືາ ຕັອກ. ");
INSERT INTO ncq_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ໄຮ ເບີນ ອາມົ່ງ ລາ ປື່ດ ກາເລີຍ ແຕ ໄຮ ເບີນ ເກຣີ່ງ ຊັຣນາ ຈາ. ກະ ໄຮ ເບີນ ຈະຈັ່ນ ລາ ປື່ດ ກາເລີຍ ແຕ ໄຮ ເບີນ ຕຳປັອກ ຕັອກ. ");
INSERT INTO ncq_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ເຍືາ ເນ່ ປໍ ແຈມ ກາອາອ໌. ແຈມ ກັອຍ ຕາ ເບີນ ຈັ່ດ ຈອຍ, ຕາ ເບີນ ຊອດ, ກະ ຕາ ເບີນ ດໍອ໌ ຊັຣນາ ອຶນເຕົ່າ ຕຶ່ງ ຊູ. ມາ ເຢືາງ ເຈົາຣາຊີ ແຈມ ກຍາອ໌ ໂອນ ແຈມ ກັອຍ. ເຍືາ ລາ ເຢືາງ ເຈົາຣາຊີ ປາຊິ ກາເລີຍ ແຕ ແຈມ ກັອຍ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ຕາ ເບີນ ກວາຍ ອາແລ່ະ ມາ ເຕ່ອ໌ ຕໍ ອາຍຸ່ ອັນ ໂອນ ອຶນຕຣື່ງ ບີ່ອ໌ ແອັນ ຍ່ອນ ອັນ ອຸກ ຊາອຶ່ຍ. ");
INSERT INTO ncq_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ຄັນ ເຍືາ ມາ ຕາ ເຕ່ອ໌ ຕະ ມວຍ ຣານະ ແກດ ນ່ະກັອຍ, ນານ່ະ ແຕ ເຍືາ ຢໍອ໌ ອີ ອຸກ ແຕີ່ອ໌ ຣານະ ການໍ່ອ໌ ແອັນ? ");
INSERT INTO ncq_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","\"ເຍືາ ເນ່ ປໍ ປຍາຣ ບັດ. ປຍາຣ ກັອຍ ຕາ ເບີນ ຕຸ່ຮ ຕະ ຣານະ ແຕີລາ ຕານ ຕຳປັອກ ຕັອກ. ມາ ເກົາ ອາຕີ ເຍືາ, ເຕືາວ ປັຣເຍືາ ໂຊໂລໂມນ, ອັນ ລາ ກວາຍ ຊຸ ລາລື່, ມາ ອັນ ຕາ ເບີນ ຕັອກ ຕຳປັອກ ອໍ ນ່ະ ປຍາຣ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ເຢືາງ ເຈົາຣາຊີ ແຕິ່ ໂອນ ປຍາຣ ບັດ ກັອຍ ແກີດ ອໍ. ມາ ປຍາຣ ກັອຍ ອາມົ່ງ ມາໂຮຍ ຊັອງ. ຕາໄງ ໄນ່ ອັນ ຈັຮ, ມາ ຕາໄງ ປັຣແນີ ເນົ່າ ອາປັອງ ຕັຮ ຕຶ່ງ ອູ່ຍຮ. ມາ ເຢືາງ ເຈົາຣາຊີ ຈ່ອຍ ເຍືາ ໂອນ ເບີນ ຕຳປັອກ ຕັອກ ກາເລີຍ ແຕ ບັດ ກັອຍ ແອັນ. ມາ ນານ່ະ ແຕ ເຍືາ ຊາອຳ ບີ່ອ໌ ລາລື່? ");
INSERT INTO ncq_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ນ່ະກັອຍ ເຍືາ ອຶນໂຈຍ ອຸກ ປາຍ, ອຶນເຕົ່າ ອີ ຈາ ກະ ອຶນເຕົ່າ ອີ ງ່ອຍ໌. ");
INSERT INTO ncq_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ອຶນແຍ່ະ ມັຮ ຣາມຶ່ຮ ໄນ່ ກວາຍ ກາ ຕາ ເບີນ ດັງ ເຢືາງ ເຈົາຣາຊີ ໄລ່ ຊັອງ ອຸກ ລາລື່. ມາ ອຶມປໍ່ ເຍືາ ຕຶ່ງ ມັນລັ່ອງ ດັງ ເຈີ່ ເຍືາ ອຶງເຄາະ ເບີນ ມັຮ ຣາມຶ່ຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ມາ ອຶງເຄາະ ເຍືາ ຈໍ່ອ໌ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ເຍືາ. ຄັນ ເຍືາ ຕະ ນ່ະກັອຍ, ອັນ ຈ່ອຍ ເຕ່ ມັຮ ຣາມຶ່ຮ ກາ ເຍືາ ອຶງເຄາະ ເບີນ. ");
INSERT INTO ncq_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","\"ເຍືາ ກາ ຈຸ່ມ ແກະ ເກົາ ເອີຍ! ເຍືາ ບີ່ອ໌ ນະ ຊັອງ, ມາ ອຶນໂຈຍ ອຶງກັອຮ ອຶນເຕົ່າ, ຍ່ອນ ອຶມປໍ່ ເຍືາ ຕຶ່ງ ມັນລັ່ອງ ຊັອງ ຣໍ່ອ໌ ຣາງຶ່ຮ ໂອນ ເຍືາ ເບີນ ອຳນາດ ຕຶ່ງ ອຶນຕຸ ອັນ ຊົດ. ");
INSERT INTO ncq_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ອຶງເຄາະ ເຍືາ ຈິ ມູ່ນ ເຍືາ, ເຈີ່ ຈ່ອຍ ໂອນ ກວາຍ ກາດີດ. ນ່ະກັອຍ ເຍືາ ດໍອ໌ ມັຮ ກາ ມູ່ນ ເຍືາ ຕຶ່ງ ມັນລັ່ອງ. ກະ ອຶງກັອຍ ເຍືາ ເບີນ ຕູຍ ປຣະ ກາ ຕາ ແກີດ ຣຸ່ງ. ມູ່ນ ຕຶ່ງ ມັນລັ່ອງ ຕາ ເບີນ ແກີດ ປິ່ດ; ຊາແວງ ຕາ ເຕ່ອ໌ ມູ່ດ ຕວຍ໌, ກະ ອຶນຕຣູ່ນ ເລືານ ຕາ ເບີນ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ຍ່ອນ ອຶນຕຸ ແລ່ະ ເຍືາ ດໍອ໌ ມັຮ ມູ່ນ ເຍືາ, ຣາງຶ່ຮ ເຍືາ ແອີດ ຄຶ່ດ ເລືອຍໆ ແຕ ອຶນຕຸ ກັອຍ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","\"ອຶງເຄາະ ເຍືາ ກຽມ ດໍອ໌ ອຶນໂຍ່ງ ກະ ອຶງເຄາະ ເຍືາ ຕາແມີ ກະ ຕາກັດ ຕາກຍາງ ເລືອຍໆ. ");
INSERT INTO ncq_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ເຍືາ ຕະ ມູເຈິງ ກວາຍ ກາ ຕະ ຣານະ ເກຣາະ ເນືາຍ ໄລ່ ເຈົາ ແຕ ຈາ ຣໍ່ອ໌ ບູຍ. ແຕີ່ອ໌ ເນືາຍ ກັອຍ ເຈົາ, ອັນ ກູໂຕຍຮ ງັ່ຮ ຕົ່ງ. ເຈີ່ ໄລ່ ເປິຮ ແຕິ່ ໂອນ ອຶນເຈົາ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ແຕີ່ອ໌ ອັນ ເຈົາ, ອັນ ເຮີມ ອໍ ກວາຍ ກາ ຕະ ຣານະ ອັນ, ໄລ່ ແອີດ ເກຣາະ ກະ ຕາ ເບີນ ບິ. ບຸ່ນ ລາລື່ ແຕີ່ອ໌ ປໍ ໄລ່ ກາ ຕະ ຣານະ ກັອຍ, ຍ່ອນ ເນືາຍ ໄລ່ ເຮີມ ໄລ່ ຕະ ເລືອຍໆ. ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ເນືາຍ ກັອຍ, ອັນ ກຽມ ດໍອ໌, ເຈີ່ ອັນ ໂອນ ມັຮ ກວາຍ ກາ ຕະ ຣານະ ອັນ ຕາກູ, ກະ ອັນ ອາລັ່ອຮ ເກຣີ່ງ ຊັຣນາ ໂອນ ໄລ່ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ປຍາຍ໌ ເນືາຍ ກັອຍ ເຈົາ ດີດຶ່ກ ແຕີລາ ແຈ່ະ ອີ ປັ່ງ ລາ ເບີນ. ມາ ອຶນແຍ່ະ ກວາຍ ກາ ຕະ ຣານະ ອັນ ອຶນນັ່ອງ ເບີນ ບຸ່ນ ລາລື່, ຍ່ອນ ໄລ່ ແອີດ ຕາງວຍ ເນ່ ເລືອຍໆ. ");
INSERT INTO ncq_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ອຶງເຄາະ ເຍືາ ດັງ ເຕ່, ຄັນ ຕາລາ ດຸງ ດັງ ບັອງ ແລ່ະ ກວາຍ ຊາແວງ ອີ ມູ່ດ ຕູຕວຍ໌ ຕຶ່ງ ດຸງ ອັນ, ອັນ ຕາງວຍ ເລືອຍໆ ຕາ ເບີນ ໂອນ ກວາຍ ຊາແວງ ເຕ່ອ໌ ມູ່ດ ຕູຕວຍ໌ ຕຶ່ງ ດຸງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ນ່ະກັອຍ ເຕ່, ອຶງເຄາະ ເຍືາ ກຽມ ດໍອ໌ ເລືອຍໆ ເຕ່, ຍ່ອນ ເຍືາ ຕາ ເບີນ ດັງ ຕາໄງ ແລ່ະ ເກົາ, ກອນ ເຢືາງ ແກີດ ກວາຍ, ແຕີ່ອ໌ ລັ່ຮ. ເກົາ ແຕີ່ອ໌ ບັອງ ກາ ຕາໄງ ເຍືາ ຕາ ເບີນ ຄຶ່ດ ອຶນເຕົ່າ ປາຍ ເກົາ ອີ ແຕີ່ອ໌.\" ");
INSERT INTO ncq_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ເຈີ່ ເປໂຕ ຕາແບີບ ເຢຊູ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ອຶນເຈົາ ອາຕີ ປັຣນາຍ ຊາກຳ ໄນ່ ໂອນ ແອີງ ຮິ ຊັອງ, ແຕີລາ ອຶນເຈົາ ອາຕີ ໂອນ ກູ່ ນະ ກວາຍ?\" ");
INSERT INTO ncq_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ເຢຊູ ຕາແອີຍ ປາຍ: \"ຄັນ ເບີນ ກວາຍ ຊູລ ກາ ມັນຕັ່ດ ກະ ຣາໄງ່ອ໌ ຣາລັ່ງ, ເນືາຍ ອັນ ຈົຮ ໂອນ ອັນ ຕະ ຊົດ ເນ່ ມັຮ ກວາຍ ການໍ່ອ໌ ກາ ຕະ ຣານະ ອັນ. ອຶນເຕົ່າ ເນືາຍ ແປຣີ ໂອນ ອຶມແປອ໌, ອັນ ອຶມແປອ໌ ຣາມຶ່ຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ຄັນ ຊູລ ກັອຍ ຕະ ປຍາຍ໌ ອຶນແຍ່ະ ມັຮ ຣານະ ເນືາຍ ອັນ ແປຣີ, ອັນ ເບີນ ແອີດ ຣໍ່ອ໌ ບູຍ ບັອງ ກາ ເນືາຍ ອັນ ເຈົາ ລັ່ຮ ປໍ ດຸງ. ");
INSERT INTO ncq_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ປັຣແນີ ມັນເຕຣືາ ເນືາຍ ກັອຍ ໂອນ ຊູລ ກັອຍ ເນ່ ຊາລີອ໌ ອຶນແຍ່ະ ມັຮ ມູ່ນ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ມາ ຄັນ ກວາຍ ຊູລ ກັອຍ ຕາ ເບີນ ມັນຕັ່ດ ອໍ, ອັນ ຄຶ່ດ ຕຶ່ງ ຣາງຶ່ຮ ອັນ ປາຍ: 'ອຶນນັ່ອງ ດູ່ນ ເນືາຍ ເກົາ ອີ ເຈົາ.' ນ່ະກັອຍ, ອັນ ປຍາຍຮ ມັຮ ກວາຍ ມັນແຊມ ກະ ຣາເລົາ ກາ ຕະ ຣານະ ເນືາຍ ອັນ, ກະ ອັນ ເປາະ ຈາ ງ່ອຍ໌ ບູລ ລຳແປ່ະ ລັງຮຍາ. ");
INSERT INTO ncq_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ເຈີ່ ເນືາຍ ຊູລ ກັອຍ ເຈົາ, ມາ ຊູລ ກັອຍ ຕາ ເບີນ ດັງ ຕາໄງ ກັອຍ, ກະ ອັນ ຕາ ເບີນ ຄຶ່ດ ອຶນເຕົ່າ ເລີ່ຍ ແຕ ຣານະ ກັອຍ. ນ່ະກັອຍ ເນືາຍ ກັອຍ ໄປ່ອ໌ ຕັຮ ຈະ ກວາຍ ຊູລ ກັອຍ. ກະ ເນືາຍ ໂອນ ຊູລ ກັອຍ ແອີດ ມັນຕຸ ກະ ໄລ່ ກາ ຕາ ເບີນ ຕະ ປວາຍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","\"ຊູລ ກາ ດັງ ແຕ ຣາງຶ່ຮ ເນືາຍ ອັນ, ມາ ອັນ ຕາ ເບີນ ກຽມ ກະ ອັນ ຕາ ເບີນ ຕະ ປວາຍ, ເນືາຍ ໂອນ ເນົ່າ ປຍາຍຮ ຊູລ ກັອຍ ຮັບ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ມາ ຊູລ ກາ ຕາ ເບີນ ດັງ ແຕ ຣາງຶ່ຮ ເນືາຍ ອັນ, ກະ ອັນ ຕະ ຣານະ ໂລ່ຍຮ, ເນືາຍ ໂອນ ເນົ່າ ປຍາຍຮ ອັນ ບີ່ອ໌ ຊັອງ. ກວາຍ ອາແລ່ະ ມາ ເນົ່າ ໂອນ ຊາອຶ່ຍ, ເນົ່າ ອຶງກ່ອງ ລັ່ຮ ແຕ ກວາຍ ກັອຍ ຊາອຶ່ຍ ເຕ່. ກະ ກວາຍ ອາແລ່ະ ມາ ເນົ່າ ພາອ໌ ຊາອຶ່ຍ, ເນົ່າ ອຶງກ່ອງ ກວາຍ ກັອຍ ກູລັຮ ລັ່ຮ ກາເລີຍ ແຕ ກັອຍ ແອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","\"ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່ ລາ ເກົາ ເດີງ ອູ່ຍຮ ອາປັອງ ປໍ ກູແຕອ໌ ໄນ່. ເກົາ ຢໍອ໌ ລາລື່ ຄັນ ອູ່ຍຮ ໄນ່ ເບຼີ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ອຶງເຄາະ ເກົາ ຈີວ໌ ຊາອຶ່ຍ ຣາມຶ່ຮ ຕຸ່ຮ ກັ່ດ; ກະ ຣາງຶ່ຮ ເກົາ ຕຸ່ຮ ອາຣຶ່ກ ລາລື່ ເຕົ່າ ໂອນ ແຕີ່ອ໌ ຣານະ ກັອຍ ແກີດ ແມິ່ມ! ");
INSERT INTO ncq_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ເຍືາ ຄຶ່ດ ປາຍ ເກົາ ແຕີ່ອ໌ ປໍ ກູແຕອ໌ ໄນ່ ເດີງ ໂອນ ກວາຍ ແອີດ ອຽນ ອໍ ບໍ? ຕາ ແກີນ! ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່, ເກົາ ອີ ຕະ ໂອນ ກວາຍ ແກີດ ມານະ ຕາ ເບີນ ຊັງໄກຣ ໂຈະ ມານະ. ");
INSERT INTO ncq_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ແຕ ຕາໄງ ໄນ່ ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ອຶນຕູ່ນ, ຄັນ ເບີນ ມວຍ ດຸງ ກາ ເບີນ ກວາຍ ເຊີງ ນະ, ໄປ ນະ ຕາ ເບີນ ຊັງໄກຣ ໂຈະ ບາຣ ນະ, ກະ ບາຣ ນະ ຕາ ເບີນ ຊັງໄກຣ ລັ່ຮ ໂຈະ ໄປ ນະ. ");
INSERT INTO ncq_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ອຶມປໍ່ ຕາ ເບີນ ຊັງໄກຣ ກະ ກອນ ຣາເລົາ; ກະ ກອນ ຣາເລົາ ຕາ ເບີນ ຊັງໄກຣ ກະ ອຶມປໍ່. ອຶມເປ່ອ໌ ຕາ ເບີນ ຊັງໄກຣ ກະ ກອນ ມັນແຊມ; ກະ ກອນ ມັນແຊມ ຕາ ເບີນ ຊັງໄກຣ ກະ ອຶມເປ່ອ໌. ກູຢາກັນ ຕາ ເບີນ ຊັງໄກຣ ກະ ກູມັນ; ກະ ກູມັນ ຕາ ເບີນ ຊັງໄກຣ ກະ ກູຢາກັນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ເຢຊູ ອາຕີ ໂຈະ ມັຮ ກວາຍ ກັອຍ ແອັນ ປາຍ: \"ແຕີ່ອ໌ ເຍືາ ເຮີມ ຣາມິ່ລ ກູມ ແຕີ່ອ໌ ແຕ ຢັ່ຮ ມັ່ດ ມານາງ ປັດ, ເຍືາ ປາຍ ກຣວາງ ອີ ເມືາ. ລື່ ອັນ ເມືາ. ");
INSERT INTO ncq_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ແຕີ່ອ໌ ເຍືາ ຊັອງ ກູຢາລ ແປຼິ່ ແຕ ຢັ່ຮ ກຣວາງ ພວາອ໌, ເຍືາ ປາຍ ກຣວາງ ເຍືາ ອີ ພວາອ໌. ລື່ ອັນ ພວາອ໌. ");
INSERT INTO ncq_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ເຍືາ ລາ ກວາຍ ມາມ ອໍ ມາ ຣາງຶ່ຮ ໂກ່ະ! ເຍືາ ດັງ ຊາກັ່ລ ອຶນແຍ່ະ ຕຶ່ງ ກູແຕອ໌ ໄນ່ ກະ ຕຶ່ງ ມັນລັ່ອງ, ມາ ເຍືາ ຕາ ເບີນ ດັງ ອຶນເຕົ່າ ແຕ ຣານະ ເຢືາງ ເຈົາຣາຊີ ໂອນ ເຍືາ ດັງ ຕຶ່ງ ແດີຍ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","\"ນານ່ະ ເຍືາ ຕາ ເບີນ ດັງ ຣຽຮ ອີດ ເບີມ ຣານະ ອາແລ່ະ ກາ ປຍາຍ໌? ");
INSERT INTO ncq_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ແຕີ່ອ໌ ເຍືາ ຣາໂລຍຮ ກະ ກວາຍ ການໍ່ອ໌, ກວາຍ ກັອຍ ເດີງ ເຍືາ ເປາະ ຣາມົຮ ກວາຍ ຊົດ. ອຶງເຄາະ ເຍືາ ປຣ່ອມ ຣາຕອຍ ລັ່ຮ ບັອງ ກາ ເຍືາ ຕາ ຢວາຮ ຣາມົຮ ກວາຍ ຊົດ. ຄັນ ເຍືາ ຕາ ເບີນ ປຣ່ອມ ຣາຕອຍ ໄວ່, ອຶງກັອຮ ປຍາຍ໌ ກວາຍ ກັອຍ ເດີງ ເຍືາ ແຕີ່ອ໌ ປໍ ກວາຍ ກາ ຕັດຊີ່ນ ແອັນ. ເຈີ່ ກວາຍ ກັອຍ ມ່ອບ ໂອນ ເນົ່າ ໂຈະ ເຍືາ ຕຶ່ງ ກໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ເຍືາ ຕາ ເຕ່ອ໌ ລັ່ອຮ ແຕ ກໍ່ອ໌ ກັອຍ ເຕົ່າ ແຕີ່ອ໌ ເຍືາ ຈີວ໌ ກູລັຮ ອຶນແຍ່ະ ມັຮ ປຣະ ກວາຍ ຊົດ ກັອຍ ປາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ບັອງ ກາ ກັອຍ ເບີນ ກວາຍ ແອີດ ອຶງກັອຍ ອາຕີ ໂອນ ເຢຊູ ດັງ ແຕ ຣານະ ປີລາດ ຕະ ກາຈີດ ມັຮ ກວາຍ ຄາລີເລ ບັອງ ກາ ໄລ່ ກຍາກ ຊັນຕຣັ່ນ ຊາງ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ເຢຊູ ອາຕີ ໄລ່ ກັອຍ ປາຍ: \"ນານ່ະ ເຍືາ ຄຶ່ດ? ມັຮ ກວາຍ ຄາລີເລ ກາ ຈີວ໌ ກູຈີດ ນ່ະກັອຍ, ໄລ່ ເບີນ ໂລ່ຍຮ ກາເລີຍ ແຕ ກວາຍ ຄາລີເລ ການໍ່ອ໌ ບໍ? ");
INSERT INTO ncq_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ຕາ ແກີນ! ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ຄັນ ເຍືາ ມາ ຕາ ເບີນ ຕັຮ ຣາງຶ່ຮ ຕຍາ ປຽນ ແກີດ ຣາງຶ່ຮ ຕາໄມ ແອັນ, ເຍືາ ອຶງເຄາະ ກູຈີດ ເຕ່, ມູເຈິງ ໄລ່ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ກະ ອຶນເຕົ່າ ເຍືາ ຄຶ່ດ ແຕ ມວຍ ຈິ່ດ ຕາກ່ອລ ນະ ກາ ແອີດ ຕຶ່ງ ຊີໂລອາມ ບັອງ ກາ ດຸງ ຍາມ ຕີ່ ຣາລິ່ຮ ກາແຕດ ກາຈີດ ໄລ່? ເຍືາ ຄຶ່ດ ໄລ່ ມວຍ ຈິ່ດ ຕາກ່ອລ ນະ ກັອຍ ເບີນ ໂລ່ຍຮ ກາເລີຍ ແຕ ກວາຍ ການໍ່ອ໌ ແອີດ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ ບໍ? ");
INSERT INTO ncq_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ຕາ ແກີນ! ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ຄັນ ເຍືາ ມາ ຕາ ເບີນ ຕັຮ ຣາງຶ່ຮ ຕຍາ ປຽນ ແກີດ ຣາງຶ່ຮ ຕາໄມ ແອັນ, ເຍືາ ຈີວ໌ ກູຈີດ ມູເຈິງ ໄລ່ ກັອຍ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ເຈີ່ ເຢຊູ ອາຕີ ໄລ່ ປັຣນາຍ ຊາກຳ ປາຍ: \"ເບີນ ມານະ ກວາຍ ເບີນ ມວຍ ກັ່ລ ລາວັ່ຮ ດັຮ ຕຶ່ງ ຊວນ ອັນ. ອັນ ເປາະ ຈໍ່ອ໌ ປາໄລ ແຕ ກັ່ລ ກັອຍ, ມາ ອັນ ເຮີມ ຕາ ເບີນ ປາໄລ. ");
INSERT INTO ncq_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ນ່ະກັອຍ ອັນ ອາຕີ ໂຈະ ກວາຍ ກາ ກຍາອ໌ ຊວນ ກັອຍ ປາຍ: 'ເນ່ ໄນ່! ໄປ ກູມໍ ໄນ່ ເຈີ່ ເກົາ ແຕີ່ອ໌ ຈໍ່ອ໌ ປາໄລ ແຕ ກັ່ລ ໄນ່, ມາ ເກົາ ຕາ ເບີນ ເຮີມ ອັນ ເບີນ ປາໄລ ອຶນເຕົ່າ. ເຈີ່ ໄມ່ ຕາມື່່ ຕັຮ ຊັອງ ກັ່ລ ໄນ່. ອຶນໂຈຍ ໂອນ ອັນ ດັຮ ນັ່ອງ ຕຶ່ງ ກູແຕອ໌ ອໍ ໄນ່.' ");
INSERT INTO ncq_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ມາ ອັນ ກາ ກຍາອ໌ ຊວນ ກັອຍ ຕາແອີຍ ປາຍ: 'ອຶນເຈົາ ເອີຍ! ແຊອ໌ ໄມ່ ດໍອ໌ ກັ່ລ ໄນ່ ໂອນ ອາມົ່ງ ມວຍ ກູມໍ ເວືາຍ. ເກົາ ອີ ປິ່ ປຣຸ່ງ ອຶມແປຣ ກັ່ລ ໄນ່. ເຈີ່ ເກົາ ອີ ໂຈະ ພົນ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ແຕີ່ອ໌ ກູມໍ ອຶນຕູ່ນ, ຄັນ ກັ່ລ ໄນ່ ມາ ແກີດ ປາໄລ, ໄຮ ເບີນ ຈາ. ມາ ຄັນ ອັນ ຕາ ເບີນ ແກີດ ປາໄລ, ໄຮ ຕາມື່່ ຕັຮ ກັ່ລ ອາລ່ອງ ໄນ່.'\" ");
INSERT INTO ncq_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ເບີນ ມວຍ ຕາໄງ ຣາລູ່, ເຢຊູ ອາຕີ ຕຶ່ງ ດຸງ ຊາງ ກວາຍ ອິດຊະຣາເອລ. ");
INSERT INTO ncq_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ແອີດ ອຶງກັອຍ ເບີນ ມານະ ມັນແຊມ ກາ ກຣັອງ ຊາໂກ່ ມວຍ ຈິ່ດ ຕາກ່ອລ ກູມໍ ເຈີ່. ເບີນ ເຢືາງ ຕາ ອໍ ຕະ ໂອນ ອັນ ຕາ ເຕ່ອ໌ ຕາຢຶ່ງ ຕານັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ພໍກາ ເຢຊູ ເຮີມ ມັນແຊມ ກັອຍ, ອັນ ກູອ໌ ກະ ປາຍ: \"ອາຢ່ະ ເອີຍ! ຊານໍ່, ອາຢ່ະ ຕາ ເບີນ ອາອີ່ ນ່ະກັອຍ ນັ່ອງ!\" ");
INSERT INTO ncq_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ແວັດ ກັອຍ, ເຢຊູ ຊາປ່ະ ອາຕີ ອັນ ຕຶ່ງ ຈະ ມັນແຊມ ກັອຍ. ບັອງ ກາ ກັອຍ ແຕິ່ ກຣັອງ ມັນແຊມ ກັອຍ ແກີດ ຕານັ່ອງ ລັ່ຮ, ກະ ອັນ ຍ່ອງ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ມາ ອັນ ກາ ຕະ ຊົດ ດຸງ ຊາງ ກັອຍ, ອັນ ຊັອງ ອວານ ລາລື່ ເຢຊູ ປົວ ກວາຍ ອາອີ່ ຕຶ່ງ ຕາໄງ ຣາລູ່. ນ່ະກັອຍ ກວາຍ ຕະ ຊົດ ດຸງ ຊາງ ກັອຍ ປາຍ ໂຈະ ມັຮ ກວາຍ ກາ ແອີດ ອຶງກັອຍ: \"ເບີນ ຕາປັ່ດ ຕາໄງ ໄຮ ເຕ່ອ໌ ຕະ ຣານະ. ນ່ະກັອຍ ແອີງ ຕາປັ່ດ ຕາໄງ ກັອຍ ຊັອງ ເຍືາ ເຕ່ອ໌ ແຕີ່ອ໌ ໂອນ ເນົ່າ ປົວ ຈະ ເຍືາ. ເຍືາ ອຶນໂຈຍ ແຕີ່ອ໌ ໂອນ ເນົ່າ ປົວ ຈະ ເຍືາ ຕຶ່ງ ຕາໄງ ຣາລູ່!\" ");
INSERT INTO ncq_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ມາ ເຢຊູ ອາຕີ ລັ່ຮ ໂຈະ ກວາຍ ກາ ຕະ ຊົດ ດຸງ ຊາງ ກັອຍ ປາຍ: \"ເຍືາ ລາ ກວາຍ ມາມ ອໍ ມາ ຣາງຶ່ຮ ໂກ່ະ! ອຶນແຍ່ະ ນະ ເຍືາ, ຄັນ ເຍືາ ເບີນ ຕາແກງ ແຕີລາ ອາແຊັຮ ແຈລ ຕຶ່ງ ກໍ່ອ໌, ເຍືາ ເປິຮ ໂອນ ອັນ ເຕ່ອ໌ ລັ່ອຮ ງ່ອຍ໌ ແດີອ໌ ຕຶ່ງ ຕາໄງ ຣາລູ່. ");
INSERT INTO ncq_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ມັນແຊມ ໄນ່ ລາ ແຕ ຈຸ່ມເຈືອ ອັບຣາຮາມ ມູເຈິງ ເຍືາ ເຕ່, ມາ ເຢືາງ ຊາຕານ ຕະ ອັນ ອຶນແຍ່ະ ມວຍ ຈິ່ດ ຕາກ່ອລ ກູມໍ ເຈີ່. ນານ່ະ ຕາ ເຕ່ອ໌ ຈ່ອຍ ອັນ ຕຶ່ງ ຕາໄງ ຣາລູ່?\" ");
INSERT INTO ncq_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ບັອງ ກາ ເຢຊູ ປາຍ ນ່ະກັອຍ, ອຶນແຍ່ະ ໄລ່ ກາ ອວານ ກະ ອັນ, ໄລ່ ຊັອງ ກູມາລ ລາລື່. ມາ ກວາຍ ກຼຶ່ງ ການໍ່ອ໌ ກາ ແອີດ ອຶງກັອຍ ເຕ່, ໄລ່ ຊັອງ ຣໍ່ອ໌ ລາລື່ ແຕ ອຶນແຍ່ະ ຣານະ ອໍ ເຢຊູ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ເຢຊູ ອາຕີ ແອັນ ປາຍ: \"ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ຕຶ່ງ ຣາງຶ່ຮ ກວາຍ ລາ ນ່ະ ອຶນເຕົ່າ? ກະ ຣາມຶ່ຮ ອຶນເຕົ່າ ເຕ່ອ໌ ເກົາ ຊາກຳ ແຕ ຊົດ ກັອຍ? ");
INSERT INTO ncq_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ຊົດ ກັອຍ ລາ ນ່ະ ມວຍ ກຼອງ ປາກາດ. ເບີນ ມານະ ອີດ ກຼອງ ກູປຼູອ໌ ກັອຍ ກະ ຕຣຶ່ຮ ຕຶ່ງ ໄທຣ ອັນ. ເຈີ່ ກຼອງ ກັອຍ ດັຮ ແກີດ ປື່ດ ນ່ະ ອາລ່ອງ. ເຕ່ອ໌ ແຈມ ຕະ ຊານົຮ ຕຶ່ງ ອາແບງ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ເຢຊູ ປາຍ ແອັນ: \"ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ລາ ເກົາ ອີ ຊາກຳ ນ່ະ ອຶນເຕົ່າ? ");
INSERT INTO ncq_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ຊົດ ກັອຍ ນ່ະ ບວຮ ຊື່ອ໌ ກາ ມັນແຊມ ອີດ ບີ່ອ໌ ເຈີ່ ເປຍ ໂຈະ ແປງ ຕຶ່ງ ອາແດັຮ ປື່ດ. ເຈີ່ ແປງ ກັອຍ ແກີດ ປຣຸ່ຮ ອາຊັອຮ ອຶນແຍ່ະ.\" ");
INSERT INTO ncq_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ບັອງ ກາ ເຢຊູ ເປາະ ຕຶ່ງ ຣານາ ອີ ເປາະ ປໍ ເມືອງ ເຢຣູຊາເລັມ, ອັນ ແວັ່ຮ ຕຶ່ງ ວີ່ລ ແກດ ວີ່ລ ປື່ດ ອາຕີ ກວາຍ ຕຶ່ງ ມັຮ ວີ່ລ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ເບີນ ມານະ ຕາແບີບ ອັນ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ເຢືາງ ເຈົາຣາຊີ ຈ່ອຍ ອາມົ່ງ ແອີງ ບີ່ອ໌ ນະ ກວາຍ ຊັອງ ບໍ?\" ເຈີ່ ເຢຊູ ອາຕີ ອຶນແຍ່ະ ມັຮ ກວາຍ ກັອຍ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","\"ອຶງເຄາະ ເຍືາ ປາຍາອ໌ ອີ ມູ່ດ ຕຶ່ງ ງັ່ຮ ຕົ່ງ ເກ່ບ. ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ເບີນ ກຼຶ່ງ ກວາຍ ຢໍອ໌ ອີ ມູ່ດ ຕຶ່ງ ງັ່ຮ ຕົ່ງ ເກ່ບ ກັອຍ, ມາ ໄລ່ ຕາ ດັງ ເບີນ ມູ່ດ. ");
INSERT INTO ncq_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","\"ແຕີ່ອ໌ ອຶນເຈົາ ດຸງ ຢວຣ ກາໄຕ່ຮ ງັ່ຮ ຕົ່ງ, ອຶນແຍ່ະ ມັຮ ເຍືາ ແອີດ ຢັ່ຮ ນໍ່ອ໌ ກູໂຕຍຮ ຕົ່ງ ກັອຍ ກະ ກູອ໌ ປາຍ: 'ອຶນເຈົາ ເອີຍ! ແຊອ໌ ອຶນເຈົາ ເປິຮ ຕົ່ງ ໂອນ ຮິ ມູ່ດ!' ມາ ອຶນເຈົາ ກັອຍ ຕາແອີຍ ເຍືາ ປາຍ: 'ເກົາ ຕາ ເບີນ ດັງ ແຕ ແລ່ະ ເຍືາ ແຕີ່ອ໌!' ");
INSERT INTO ncq_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ເຈີ່ ເຍືາ ອາຕີ ລັ່ຮ ປາຍ: 'ຮິ ງ່ອຍ໌ ຈາ ມັນຕຸ ກະ ອຶນເຈົາ ເຈີ່, ກະ ອຶນເຈົາ ອາຕີ ເຈີ່ ຕຶ່ງ ວີ່ລ ຮິ!' ");
INSERT INTO ncq_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ມາ ອຶນເຈົາ ກັອຍ ຕາແອີຍ ລັ່ຮ ປາຍ: 'ເກົາ ຕາ ດັງ ແຕ ແລ່ະ ເຍືາ ແຕີ່ອ໌. ເຍືາ ເປາະ ເຢີ່ງ ແຕ ເກົາ, ເຍືາ ລາ ແອີງ ກວາຍ ໂລ່ຍຮ ຊັອງ!' ");
INSERT INTO ncq_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ໄກຣ ລາລື່, ປັຣແນີ ມັນເຕຣືາ ເຍືາ ເຍືາມ ເລືອຍໆ, ກະ ເຍືາ ກາຕັດ ກາແນງ ກາບາງ ຊັອງ ຕຸ່ຮ ກັ່ດ ລາລື່, ບັອງ ກາ ເຍືາ ເຮີມ ຕຶ່ງ ອຶນຕຸ ເຢືາງ ເຈົາຣາຊີ ຊົດ ລາ ອັບຣາຮາມ, ອີຊາກ, ກະ ຢາໂຄບ, ກະ ມັຮ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ມາ ເຍືາ ເນົ່າ ຕູ່ຍຮ ອາລັ່ອຮ ຕາ ເບີນ ໂອນ ມູ່ດ. ");
INSERT INTO ncq_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ເບີນ ມັຮ ກວາຍ ການໍ່ອ໌ ແຮີ ແຕີ່ອ໌ ແຕ ຢັ່ຮ ມານາງ ລັ່ອຮ, ຢັ່ຮ ມານາງ ປັດ, ຢັ່ຮ ແປີງ ກະ ຢັ່ຮ ກາແດີບ. ໄລ່ ກັອຍ ເບີນ ແອີດ ຈາ ຕຶ່ງ ອຶນຕຸ ເຢືາງ ເຈົາຣາຊີ ຊົດ ຕຶ່ງ ມັນລັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ນ່ະກັອຍ, ໄລ່ ກາ ແກີດ ອຶນຕູ່ນ ຊານໍ່, ເຈີ່ ປໍ ເມືາງ ໄລ່ ແກີດ ອຶນໂຍ່ງ ແອັນ. ກະ ໄລ່ ກາ ແກີດ ອຶນໂຍ່ງ ຊານໍ່, ເຈີ່ ປໍ ເມືາງ ໄລ່ ກັອຍ ແກີດ ອຶນຕູ່ນ ແອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ບັອງ ກາ ກັອຍ ເບີນ ກວາຍ ແຕ ຈຸ່ມ ພາຣີຊາຍ ແຕີ່ອ໌ ປໍ ເຢຊູ ອາຕີ ອັນ ປາຍ: \"ອຶງເຄາະ ອາຈານ ລັ່ອຮ ແຕ ອຶນໄນ່, ເປາະ ປໍ ອຶນຕຸ ການໍ່ອ໌ ແອັນ, ຍ່ອນ ເຕືາວ ປັຣເຍືາ ເຮໂຣດ ອີ ກາຈີດ ອາຈານ.\" ");
INSERT INTO ncq_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ເຍືາ ເປາະ ອາຕີ ຕາຈໍອ໌ ກັອຍ ປາຍ: 'ຕາໄງ ໄນ່ ກະ ປັຣແນີ ເກົາ ອີ ຕູ່ຍຮ ອາລັ່ອຮ ເຢືາງ ຕາ ອໍ ກະ ປົວ ອຶນແຍ່ະ ມັຮ ຣາມຶ່ຮ ກວາຍ ຕິ່ ອາອີ່. ເຈີ່ ແຕີ່ອ໌ ຕາໄງ ມັນເຕຣືາ ເກົາ ຕະ ໂອນ ແມິ່ມ ອຶນແຍ່ະ.' ");
INSERT INTO ncq_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ມາ ຊານໍ່ ກະ ປັຣແນີ ມັນເຕຣືາ, ອຶງເຄາະ ເກົາ ປວາຍ ຣານະ ເຢືາງ ເຈົາຣາຊີ ເຈົາ ປໍ ເມືອງ ເຢຣູຊາເລັມ, ຍ່ອນ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ຕາ ເຕ່ອ໌ ກູຈີດ ຢັ່ຮ ນໍ່ອ໌ ເມືອງ ເຢຣູຊາເລັມ. ");
INSERT INTO ncq_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","\"ເອີ ເຢຣູຊາເລັມ, ເຍືາ ກາ ແອີດ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ ເອີຍ! ເຍືາ ລາ ກວາຍ ກາ ເກີ່ຍ ກາຈີດ ກວາຍ ກາ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ກະ ເຍືາ ແກຼງ ຕາເມົາ ໂຈະ ມັຮ ກວາຍ ກາ ເຢືາງ ເຈົາຣາຊີ ແປຣີ ແຕີ່ອ໌ ປໍ ເຍືາ. ເບີນ ຊາອຶ່ຍ ຕໍ່ ເຈີ່ ເກົາ ຢໍອ໌ ອີ ປາໂຣມ ອຶນແຍ່ະ ມັຮ ເຍືາ ນ່ະ ອຶນຕຣວຍ ອາກັນ ກູຕຣຸກ ກູອ໌ ກອນ ອັນ ໂອນ ແອີດ ປື່ນ ຊານັງ. ມາ ເຍືາ ຕາ ປຣ່ອມ! ");
INSERT INTO ncq_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ຈ່ອຍ ນັ່ອງ ເມືອງ ເຍືາ. ນ່ະກັອຍ ເກົາ ອາຕີ ເຍືາ ປາຍ: ປັຣແນີ ມັນເຕຣືາ ເຍືາ ຕາ ເບີນ ເຮີມ ນັ່ອງ ເກົາ, ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ເຍືາ ປາຍ: 'ບຸ່ນ ລາລື່ ອັນ ກາ ແຕີ່ອ໌ ຕະ ຣານະ ຍ່ອນ ຣາມຶ່ຮ ອຶນເຈົາ ໄຮ.'\" ");
INSERT INTO ncq_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ເບີນ ມວຍ ຕາໄງ ຣາລູ່, ເຢຊູ ເປາະ ຈາ ມວຍ ເປ່ລ ຕຶ່ງ ດຸງ ມານະ ກວາຍ ຊົດ ຕຶ່ງ ຈຸ່ມ ພາຣີຊາຍ. ອຶນແຍ່ະ ນະ ໄລ່ ແອີດ ອຶງກັອຍ ເນ່ ເລືອຍໆ ປໍ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ເບີນ ມານະ ຣາເລົາ ແຕີ່ອ໌ ປໍ ເຢຊູ ເບີນ ອາອີ່ ອູໄອຮ. ");
INSERT INTO ncq_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ເຢຊູ ຕາແບີບ ມັຮ ກວາຍ ອາຕີ ຄານອດ ກະ ມັຮ ກວາຍ ພາຣີຊາຍ ກັອຍ ປາຍ: \"ປວາຍ ຄານອດ ໄຮ, ເຕ່ອ໌ ບໍ ໄຮ ປົວ ກວາຍ ອາອີ່ ຕຶ່ງ ຕາໄງ ຣາລູ່?\" ");
INSERT INTO ncq_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ມາ ໄລ່ ກັອຍ ຣາວື່ລ ຊັອງ ຕາ ເບີນ ຕາແອີຍ ອຶນເຕົ່າ. ນ່ະກັອຍ ເຢຊູ ເຕິ ອາຕີ ກວາຍ ອາອີ່ ກັອຍ, ກະ ອັນ ປົວ ກວາຍ ກັອຍ. ເຈີ່ ເຢຊູ ໂອນ ອັນ ເຈົາ. ");
INSERT INTO ncq_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ແວັດ ກັອຍ ເຢຊູ ອາຕີ ປາຍ: \"ຄັນ ເບີນ ມານະ ແຕ ເຍືາ ມາ ເບີນ ກອນ ຣາເລົາ ແຕີລາ ຕາແກງ ມາ ຊາປິ່ລ ຕຶ່ງ ແດີອ໌ ກັອຮ ຕຶ່ງ ຕາໄງ ຣາລູ່, ເຍືາ ອາແຣິ່ ອາຊັອຮ ບັອງ ກາ ກັອຍ ແຕິ່, ມາ ຕາ ເບີນ?\" ");
INSERT INTO ncq_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ມາ ໄລ່ ກັອຍ ຕາ ເຕ່ອ໌ ຕາແອີຍ ເຢຊູ ອຶນເຕົ່າ ແຕ ປັຣນາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ເຢຊູ ເຮີມ ມັຮ ກວາຍ ຕາມອຍ ກັອຍ ຣຽຮ ຕາກູ ຢັ່ຮ ຕີ່. ນ່ະກັອຍ ອັນ ອາຕີ ໂຈະ ໄລ່ ປັຣນາຍ ຊາກຳ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","\"ແຕີ່ອ໌ ເນົ່າ ການື່ຍ ເຍືາ ເປາະ ຈາ ຣໍ່ອ໌ ບູຍ, ເຍືາ ອຶນໂຈຍ ຈໍ່ອ໌ ອີ ຕາກູ ອຶງເຄາະ ຢັ່ຮ ຕີ່. ອຶງກັອຮ ປຍາຍ໌ ເບີນ ມານະ ປື່ດ ກາເລີຍ ແຕ ເຍືາ ແອັນ ແຕີ່ອ໌ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ນ່ະກັອຍ ອັນ ກາ ການື່ຍ ແຕີ່ອ໌ ປໍ ເຍືາ ປາຍ: 'ເຍືາ ປາງ ໂອນ ກວາຍ ຊົດ ໄນ່ ຕາກູ ອຶນຕຸ ກັອຍ.' ນ່ະກັອຍ ເຍືາ ຊັອງ ກູມາລ ກະ ອຶງເຄາະ ເຍືາ ແອີດ ຕາກູ ຢັ່ຮ ເຕືາບ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ມາ ຄັນ ເນົ່າ ການື່ຍ ເຍືາ, ອໍ ກາເລີຍ ເຍືາ ແອີດ ຢັ່ຮ ເຕືາບ. ນ່ະກັອຍ ອັນ ກາ ການື່ຍ ເຍືາ ແຕີ່ອ໌ ປໍ ເຍືາ ກະ ປາຍ: 'ອາຍ ເອີຍ! ແຊອ໌ ອາຍ ຊັອຮ ຕາກູ ຢັ່ຮ ຕີ່.' ນ່ະກັອຍ ອັນ ກາ ການື່ຍ ເຍືາ, ອັນ ຢຳນັ່ບ ເຍືາ ຢັ່ຮ ເມືາງ ມັຮ ກວາຍ ຕາມອຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ຍ່ອນ ກວາຍ ອາແລ່ະ ມາ ອາຊັອຮ ຈະ ອັນ ເບີມ, ປັຣແນີ ມັນເຕຣືາ ກວາຍ ກັອຍ ແກີດ ແກດ. ກະ ກວາຍ ອາແລ່ະ ມາ ອາແຊງ ຈະ ອັນ ເບີມ, ປັຣແນີ ມັນເຕຣືາ ກວາຍ ກັອຍ ແກີດ ປື່ດ.\" ");
INSERT INTO ncq_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ແວັດ ກັອຍ ເຢຊູ ອາຕີ ໂຈະ ກວາຍ ກາ ການື່ຍ ອັນ ປາຍ: \"ຄັນ ໄມ່ ຕະ ເປ່ລ ບູຍ ປື່ດ ແຕີລາ ແກດ, ໄມ່ ອຶນໂຈຍ ການື່ຍ ເຢົ່າ, ແຕີລາ ແຊມອາຍ, ແຕີລາ ກວາຍ ກາ ຊຸ ຕຶ່ງ ເມືອງ ໄມ່. ອຶງກັອຮ ປຍາຍ໌ ໄລ່ ກູລັຮ ແດີອ໌ ໂຈະ ໄມ່ ນ່ະ ໄມ່ ການື່ຍ ໄລ່ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ມາ ແຕີ່ອ໌ ໄມ່ ຕະ ເປ່ລ ບູຍ, ອຶງເຄາະ ໄມ່ ການື່ຍ ມັຮ ກວາຍ ກາດີດ, ມັຮ ກວາຍ ໂຢດ, ມັຮ ກວາຍ ຕາລິ່ດ ອາເຢີງ, ກະ ມັຮ ກວາຍ ຊູດ ມັ່ດ. ");
INSERT INTO ncq_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ນ່ະກັອຍ ໄມ່ ເບີນ ບຸ່ນ ຊາອຶ່ຍ, ຍ່ອນ ກວາຍ ກັອຍ ຕາ ເຕ່ອ໌ ກູລັຮ ແດີອ໌ ລັ່ຮ ໂອນ ໄມ່. ເຢືາງ ເຈົາຣາຊີ ແຕິ່ ກູລັຮ ລັ່ຮ ເກືາ ໄມ່ ຕາງ ໄລ່ ກັອຍ, ບັອງ ກາ ກວາຍ ຕານັ່ອງ ອໍ ອາມົ່ງ ລັ່ຮ ແຕ ໄລ່ ກູຈີດ.\" ");
INSERT INTO ncq_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ເບີນ ມານະ ຕາກູ ຈາ ອຶງກັອຍ ຊັອງ ເຢຊູ ອາຕີ ປັຣນາຍ ກັອຍ, ກະ ອັນ ປາຍ ໂຈະ ເຢຊູ: \"ບຸ່ນ ລາລື່ ໄລ່ ກາ ຈາ ເປ່ລ ບູຍ ຕຶ່ງ ອຶນຕຸ ເຢືາງ ເຈົາຣາຊີ ຊົດ!\" ");
INSERT INTO ncq_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ມາ ເຢຊູ ອາຕີ ລັ່ຮ ອັນ ປາຍ: \"ເບີນ ມານະ ກວາຍ ຕະ ເປ່ລ ບູຍ, ກະ ອັນ ການື່ຍ ກຼຶ່ງ ກວາຍ ແຕີ່ອ໌ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ແຕີ່ອ໌ ປາເນ່ນ ຈາ ເປ່ລ ກັອຍ, ອັນ ແປຣີ ກວາຍ ຕະ ຣານະ ອັນ ເປາະ ອີດ ມັຮ ກວາຍ ກາ ອັນ ການື່ຍ, ເຈີ່ ອັນ ປາຍ: 'ເຍືາ ແຕີ່ອ໌ ເດິຮໆ! ຮິ ແຕງ ແມິ່ມ ເຈີ່!' ");
INSERT INTO ncq_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ມາ ມັຮ ກວາຍ ກາ ອັນ ການື່ຍ ກັອຍ, ໄລ່ ເບີນ ມວຍ ຣາງຶ່ຮ ຕາ ແອອ໌ ອີ ເປາະ ຈາ. ເບີນ ມານະ ແຕ ໄລ່ ກັອຍ ປາຍ: 'ເກົາ ແຈີງ ມູ ເລືາງ ກູແຕອ໌ ໄທຣ ເຈີ່. ເກົາ ແຊອ໌ ໂລ່ຍຮ ໄມ່, ອຶງເຄາະ ເກົາ ເປາະ ເນ່ ກູແຕອ໌ ກັອຍ!' ");
INSERT INTO ncq_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ເບີນ ມານະ ແອັນ ປາຍ: 'ເກົາ ແຈີງ ຕາແກງ ເຊີງ ກູ່. ເກົາ ແຊອ໌ ໂລ່ຍຮ ໄມ່, ອຶງເຄາະ ເກົາ ເປາະ ເນ່ ຕາແກງ.' ");
INSERT INTO ncq_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ກະ ເບີນ ມານະ ແອັນ ປາຍ: 'ເກົາ ຕາແບິ ອີດ ລາກວຍ. ນ່ະກັອຍ ເກົາ ເປາະ ຕາ ເບີນ.' ");
INSERT INTO ncq_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ເຈີ່ ກວາຍ ຕະ ຣານະ ກັອຍ ເຈົາ ອາຕີ ລັ່ຮ ອຶນເຈົາ ອັນ ມັຮ ປັຣນາຍ ກັອຍ. ອຶນເຈົາ ກັອຍ ຊັອງ ອວານ ລາລື່, ກະ ອັນ ແປຣີ ກວາຍ ຕະ ຣານະ ອັນ ປາຍ: 'ໄມ່ ເປາະ ໄວ່ ກູ່ ຣານາ ກູ່ ປັຣແວັຮ ຕຶ່ງ ເມືອງ, ກະ ເປາະ ອີດ ມັຮ ກວາຍ ກາດີດ, ມັຮ ກວາຍ ໂຢດ, ມັຮ ກວາຍ ຊູດ ມັ່ດ, ກະ ມັຮ ກວາຍ ຕາລິ່ດ ອາເຢີງ ໂອນ ໄລ່ ເປາະ ປໍ ໄນ່.' ");
INSERT INTO ncq_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ແຕີ່ອ໌ ກວາຍ ຕະ ຣານະ ກັອຍ ເຈົາ, ອັນ ປາຍ: 'ອຶນເຈົາ ເອີຍ! ມັຮ ປັຣນາຍ ອຶນເຈົາ ແປຣີ, ເກົາ ຕະ ເຈີ່, ມາ ຕຶ່ງ ດຸງ ອຶນເຈົາ ອຶນນັ່ອງ ຕາ ເບີນ ປັ່ນ.' ");
INSERT INTO ncq_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ເຈີ່ ອຶນເຈົາ ກັອຍ ແປຣີ ລັ່ຮ ກວາຍ ຕະ ຣານະ ອັນ ປາຍ: 'ໄມ່ ລັ່ອຮ ແຕ ເມືອງ, ເປາະ ປໍ ຣານາ ປື່ດ ກະ ກູ່ ປັຣແວັຮ ແກດ ແຮີ. ກວາຍ ອາແລ່ະ ໄມ່ ຣາມົຮ, ໄມ່ ການື່ຍ ກູກຸຮ ກູກວຍ ໂອນ ກວາຍ ກັອຍ ເປາະ ລື່, ໂອນ ກູທັດ ດຸງ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ມາ ມັຮ ກວາຍ ກາ ເກົາ ການື່ຍ ແຕ ອຶນໂຍ່ງ, ຕາ ເບີນ ມານະ ແຕ ໄລ່ ເຕ່ອ໌ ແຕີ່ອ໌ ຈາ ຣໍ່ອ໌ ຕຶ່ງ ດຸງ ເກົາ.'\" ");
INSERT INTO ncq_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ເບີນ ກຼຶ່ງ ກວາຍ ເປາະ ມັນຕຸ ກະ ເຢຊູ. ອັນ ລົ່ບ ເນ່ ປໍ ໄລ່ ກັອຍ ກະ ອາຕີ ໂຈະ ໄລ່ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","\"ຄັນ ກວາຍ ອາແລ່ະ ຢໍອ໌ ອີ ປວາຍ ເກົາ, ມາ ອັນ ອາໂຢ່ະ ອຶມເປ່ອ໌ ອຶມປໍ່ ອັນ, ກອນ ລາກວຍ ອັນ, ແຊມອາຍ ແຊມແອີຍ ອັນ, ແຕີລາ ອັນ ອາໂຢ່ະ ຣາງຶ່ຮ ອັນ ເບີມ ກາເລີຍ ແຕ ອັນ ອາໂຢ່ະ ເກົາ, ກວາຍ ກັອຍ ຕາ ເຕ່ອ໌ ແກີດ ກວາຍ ກາ ຣຍານ ແຕ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ກວາຍ ອາແລ່ະ ມາ ຕາ ເບີນ ອີດ ໂດລ ອາລ່ອງ ຊັງກັງ ອັນ ເບີມ ກະ ຕາ ເບີນ ປວາຍ ເກົາ, ໄກຣ ລາລື່ ກວາຍ ກັອຍ ຕາ ເຕ່ອ໌ ແກີດ ກວາຍ ຣຍານ ແຕ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","29","ຄັນ ເບີນ ມານະ ແຕ ເຍືາ ຢໍອ໌ ອີ ຕະ ມານຳ ດຸງ ຕີ່, ແຕ ຕາແບິ ລາລື່ ອຶງເຄາະ ອັນ ຄຶ່ດ ອຶນແຍ່ະ ມັຮ ອາລ່ອງ ອາໄລ່ ກາໄຣ ລຳປື່ອ໌ ເວືາຍ. ຄັນ ກວາຍ ກັອຍ ຕາ ເບີນ ຕະ ນ່ະກັອຍ, ອຶງກັອຮ ປຍາຍ໌ ອັນ ປາຕຶ່ງ ເຈີ່ ດຸງ ກັອຍ, ມາ ອັນ ຕາ ເບີນ ຄຳ ເກຣີ່ງ ອີ ຕະ ໂອນ ເຈີ່. ນ່ະກັອຍ ກູ່ ນະ ກວາຍ ເຮີມ ດຸງ ກັອຍ ຕາ ເບີນ ເຈີ່, ກະ ໄລ່ ກາຈັງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ໄລ່ ປາຍ: 'ກວາຍ ໄນ່ ຕະ ດຸງ, ມາ ຕາ ເບີນ ແກີດ ເຈີ່ ນັ່ອງ!' ");
INSERT INTO ncq_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","\"ຄັນ ເບີນ ເຕືາວ ປັຣເຍືາ ກາ ເບີນ ຕາຮານ ມວຍ ຈິ່ດ ປັ່ນ, ມາ ອັນ ອີ ເປາະ ຣາຕະ ກະ ເຕືາວ ປັຣເຍືາ ການໍ່ອ໌ ກາ ເບີນ ຕາຮານ ບາຣ ຈິ່ດ ປັ່ນ, ແຕ ຕາແບິ ລາລື່ ເຕືາວ ປັຣເຍືາ ກັອຍ ອຶງເຄາະ ຄຶ່ດ ຕະ ນານ່ະ ມາ ເຕ່ອ໌ ເຣືາບ. ");
INSERT INTO ncq_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ຄັນ ອັນ ຕາ ເຣືາບ, ບັອງ ກາ ເຕືາວ ປັຣເຍືາ ການໍ່ອ໌ ກັອຍ ອຶນນັ່ອງ ແອີດ ເຢີ່ງ, ອຶງເຄາະ ອັນ ແປຣີ ມັຮ ກວາຍ ຕະ ຣານະ ອັນ ເປາະ ແຊອ໌ ແຕ ເຕືາວ ປັຣເຍືາ ກັອຍ ອຶນໂຈຍ ຣາຕະ ນັ່ອງ ໂອນ ເຕ່ອ໌ ແອີດ ອຽນ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ມູເຈິງ ກັອຍ ເຕ່, ຄັນ ເບີນ ກວາຍ ອາແລ່ະ ແຕ ເຍືາ ມາ ຕາ ເບີນ ຕັຮ ກູ່ ຣາມຶ່ຮ ອັນ ເບີນ, ອັນ ຕາ ເຕ່ອ໌ ແກີດ ກວາຍ ຣຍານ ແຕ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","\"ບອຍ ລາ ເກຣີ່ງ ອໍ. ມາ ຄັນ ບອຍ ແກີດ ອຶນຕຍາຮ, ນານ່ະ ອີ ຕະ ໂອນ ອັນ ແກີດ ບະ ລັ່ຮ? ");
INSERT INTO ncq_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ຕາ ເຕ່ອ໌ ຕະ ອຶນເຕົ່າ ນັ່ອງ ກະ ບອຍ ກັອຍ. ໄຮ ແກຼງ ຕັຮ ປໍ ກູແຕອ໌. ກວາຍ ອາແລ່ະ ເບີນ ກູຕູຣ, ໂອນ ອັນ ຊາງັດ ເບີມ!\" ");
INSERT INTO ncq_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ເບີນ ມັຮ ກວາຍ ປາໂຣມ ປຣະ ປາຊີ ກະ ກວາຍ ໂລ່ຍຮ ການໍ່ອ໌ ແຮີ ແຕີ່ອ໌ ຢໍອ໌ ອີ ຊາງັດ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ມັຮ ກວາຍ ພາຣີຊາຍ ກະ ມັຮ ກວາຍ ອາຕີ ຄານອດ, ອຶນແຍ່ະ ໄລ່ ກັອຍ ຕິ ເຢຊູ, ປາຍ: \"ກວາຍ ໄນ່ ແອີດ ມັນຕຸ ກະ ກວາຍ ໂລ່ຍຮ, ກະ ອັນ ຈາ ມັນຕຸ ກະ ໄລ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ເຢຊູ ອາຕີ ໄລ່ ແຕ ປັຣນາຍ ຊາກຳ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","\"ຄັນ ມານະ ແຕ ເຍືາ ເບີນ ມວຍ ຣ່ອຍ ລໍາ ແກະ ມາ ປິ່ດ ມານຳ, ອັນ ດໍອ໌ ຕາເກ່ຮ ຈິ່ດ ຕາເກ່ຮ ລໍາ ແກະ ກັອຍ ຕຶ່ງ ຕົ່ງ ບັດ ເວືາຍ. ເຈີ່ ອັນ ເປາະ ຈໍ່ອ໌ ແຕິ່ ແກະ ມານຳ ກັອຍ ເຕົ່າ ອັນ ຣາມົຮ ລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ແຕີ່ອ໌ ອັນ ຣາມົຮ ລັ່ຮ ແກະ ກັອຍ, ເຈີ່ ຣາງຶ່ຮ ອັນ ຊັອງ ຣໍ່ອ໌ ລາລື່. ນ່ະກັອຍ ອັນ ອີດ ຕຳໂປຼງ ແກະ ກັອຍ ຕຶ່ງ ປາລ ອັນ ເດີງ ອາເຈົາ ປໍ ດຸງ. ");
INSERT INTO ncq_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ແວັດ ກັອຍ ອັນ ປາໂຣມ ເຢົ່າ ອາຕີ ໄລ່ ປາຍ: 'ເຍືາ ແຕີ່ອ໌ ຣໍ່ອ໌ ກະ ເກົາ! ເກົາ ຣາມົຮ ລັ່ຮ ແກະ ເກົາ ກາ ປິ່ດ ກັອຍ.' ");
INSERT INTO ncq_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ມູເຈິງ ປັຣນາຍ ຊາກຳ ໄນ່ ເຕ່, ເກົາ ອາຕີ ເຍືາ ເຢືາງ ເຈົາຣາຊີ ຊັອງ ຣໍ່ອ໌ ແຕ ມານະ ກັອຍ ກາເລີຍ ແຕ ອັນ ຊັອງ ຣໍ່ອ໌ ແຕ ຕາເກ່ຮ ຈິ່ດ ຕາເກ່ຮ ນະ ກວາຍ ການໍ່ອ໌ ໄລ່ ກາ ຄຶ່ດ ຕານັ່ອງ ອໍ ກະ ຕາ ເບີນ ອຶງເຄາະ ຕັຮ ຣາງຶ່ຮ ຕຍາ ປຽນ ແກີດ ຣາງຶ່ຮ ຕາໄມ ແອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","\"ແຕີລາ ຄັນ ເບີນ ມານະ ມັນແຊມ ກາ ເບີນ ມວຍ ຈິ່ດ ກຼອງ ປຣະ ມາ ປິ່ດ ມວຍ ກຼອງ. ນານ່ະ ອັນ ອີ ຕະ? ອັນ ຕາກັດ ຕາກຍາງ, ແປຮ ດຸງ, ກະ ເນ່ ຈໍ່ອ໌ ອຶນແຍ່ະ ຕຶ່ງ ກາຈົ່ກ ດຸງ ເຕົ່າ ອັນ ຣາມົຮ ລັ່ຮ ກຼອງ ປຣະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ແຕີ່ອ໌ ຣາມົຮ ເຈີ່, ນ່ະກັອຍ ອັນ ປາໂຣມ ເຢົ່າ ອາຕີ ໄລ່ ກັອຍ ປາຍ: 'ເຍືາ ແຕີ່ອ໌ ຣໍ່ອ໌ ກະ ເກົາ! ຍ່ອນ ເກົາ ຣາມົຮ ລັ່ຮ ປຣະ ເກົາ ກາ ປິ່ດ ກັອຍ.' ");
INSERT INTO ncq_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ມູເຈິງ ປັຣນາຍ ຊາກຳ ໄນ່, ເກົາ ອາຕີ ເຍືາ, ມັຮ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ, ໄລ່ ຊັອງ ຣໍ່ອ໌ ລາລື່ ເບີນ ມານະ ກວາຍ ໂລ່ຍຮ ມາ ຕັຮ ຣາງຶ່ຮ ຕຍາ ປຽນ ແກີດ ຣາງຶ່ຮ ຕາໄມ ແອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ເຢຊູ ຊາກຳ ແອັນ ປາຍ: \"ເບີນ ມານະ ກວາຍ ກາ ເບີນ ບາຣ ລໍາ ກອນ ຣາເລົາ. ");
INSERT INTO ncq_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ກອນ ອາລັອຮ ກັອຍ ແຊອ໌ ແຕ ອຶມປໍ່ ອັນ ປາຍ: 'ອຶມປໍ່ ເອີຍ! ເກົາ ແຊອ໌ ໄມ່ ອຶມແປອ໌ ເກຣີ່ງ ເກຣົ່າ ມູ່ນ ໄມ່. ເກົາ ອີ ເບີນ ປູ່ດ ເກົາ ຊານໍ່ ແຕິ່.' ນ່ະກັອຍ ອຶມປໍ່ ໄລ່ ອຶມແປອ໌ ມູ່ນ ອັນ ໂອນ ໄລ່ ບາຣ ນະ ແຊມອາຍ. ");
INSERT INTO ncq_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ຕາ ເບີນ ດູ່ນ ນັ່ອງ ກອນ ອາລັອຮ ກັອຍ ອີດ ເກຣີ່ງ ເກຣົ່າ ອັນ, ເຈີ່ ອັນ ເປາະ. ອັນ ລັ່ອຮ ແຕ ກຣວາງ ອັນ, ເປາະ ກູເກືາງ ປໍ ກຣວາງ ເຢີ່ງ. ແອີດ ອຶງກັອຍ ອັນ ແຈີງ ຊະຊາຍ ອຶນແຍ່ະ ປຣະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ອັນ ຕັອກ ຈາ ອຶນແຍ່ະ ເກຣີ່ງ ອັນ. ເຈີ່, ຕຶ່ງ ກຣວາງ ກັອຍ ແກີດ ມາເຍືາຍຮ ລາລື່. ກອນ ອາລັອຮ ກັອຍ ອັນ ແກີດ ແອິ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ນ່ະກັອຍ ອັນ ເປາະ ແຊອ໌ ທູແທ ແຕ ມານະ ກວາຍ ຕຶ່ງ ກຣວາງ ກັອຍ, ກະ ອຶນເຈົາ ກັອຍ ແປຣີ ອັນ ລັ່ອຮ ເປາະ ກຍາອ໌ ອາລີ່ອ໌ ປໍ ຕົ່ງ ເນືາ. ");
INSERT INTO ncq_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ອັນ ຊັອງ ມາເຍືາຍຮ ລາລື່. ອັນ ຢໍອ໌ ອີ ຈາ ໂອນ ປາໄຊ ອາລຶ່ ຊັຣນາ ຈາ ອາລີ່ອ໌ ກັອຍ, ມາ ເນົ່າ ຕາ ເບີນ ໂອນ ອັນ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ນ່ະກັອຍ ອັນ ຄຶ່ດ ຊາແຍີ ລັ່ຮ ປາຍ: 'ເອີ ປໍ ດຸງ ອຶມປໍ່ ເກົາ ເບີນ ກຼຶ່ງ ກວາຍ ທູແທ. ໄລ່ ກັອຍ ຈາ ໂດຍ ລາ ປາໄຊ, ເຕົ່າ ປາອັດ ປຸ່ງ. ມາ ເກົາ ໄນ່ ແຈ່ະ ອີ ກູຈີດ ຊາລາອ໌ ຕຶ່ງ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ເຈີ່ ເກົາ ອີ ເຈົາ ລັ່ຮ ປໍ ອຶມປໍ່ ເກົາ, ກະ ເກົາ ອີ ອາຕີ ອັນ ປາຍ: \"ອຶມປໍ່ ເອີຍ! ເກົາ ຕະ ໂລ່ຍຮ ໂຈະ ເຢືາງ ເຈົາຣາຊີ ກະ ເກົາ ຕະ ໂລ່ຍຮ ໂຈະ ໄມ່ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ເກົາ ລາ ໄມ່ ຕາ ເຕ່ອ໌ ດໍອ໌ ນັ່ອງ ກອນ. ມາ ເກົາ ແຊອ໌ ໄມ່ ໂອນ ເກົາ ທູແທ ໂອນ ໄມ່ ມູເຈິງ ເນົ່າ ເຕ່.\"' ");
INSERT INTO ncq_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ບັອງ ກາ ກັອຍ ແຕິ່ ອັນ ຢວຣ ຕາຢຶ່ງ ລົ່ບ ເຈົາ ປໍ ອຶມປໍ່ ອັນ. \"ອັນ ເຈົາ ອຶນນັ່ອງ ແຕ ເຢີ່ງ, ອຶມປໍ່ ອັນ ເຮີມ ອຶມປັຮ ຕາປັ່ອງ. ອັນ ຊັອງ ອາໂຢ່ະ ຕະ ກອນ ອັນ. ອັນ ປາລັອງ ແຕິ່ ປໍ ກອນ ອັນ; ເຈີ່ ຊາອູບ ກະ ໂຮນ ຮິດ ກອນ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ກອນ ອັນ ປາຍ ກະ ອຶມປໍ່ ອັນ: 'ອຶມປໍ່ ເອີຍ! ເກົາ ຕະ ໂລ່ຍຮ ໂຈະ ເຢືາງ ເຈົາຣາຊີ ກະ ຕະ ໂລ່ຍຮ ໂຈະ ໄມ່ ແຮີ. ເກົາ ລາ ຕາ ເບີນ ປຍາຍ໌ ໄມ່ ດໍອ໌ ກອນ ນັ່ອງ.' ");
INSERT INTO ncq_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ມາ ອຶມປໍ່ ກັອຍ ອາຕີ ກວາຍ ຊູລ ປາຍ: 'ເອົາ ຕະ ໄວ່! ເດີງ ອາຢັ່ອຮ ກາ ອໍ ລາລື່ ກາເລີຍ ອຶນແຍ່ະ ແຕ ການໍ່ອ໌; ເຈີ່ ອາແຊິບ ຕຶ່ງ ຈະ. ອີດ ພູມື່ ອາຊົບ ຕຶ່ງ ອາຕີ ອັນ, ກະ ອີດ ແກີບ ອາແຊິບ ຕຶ່ງ ອາເຢີງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ເຍືາ ອີດ ກອນ ຕາແກງ ກາ ປຼຶ່ມ ອໍ ເຍືາ ກຍາກ ໄຮ ຈາ ເປ່ລ ຣໍ່ອ໌ ບູຍ, ");
INSERT INTO ncq_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ຍ່ອນ ກອນ ເກົາ ໄນ່ ນ່ະ ອັນ ກູຈີດ, ມາ ຊານໍ່ ນ່ະ ອັນ ອາມົ່ງ ລັ່ຮ. ແຕ ອຶນໂຍ່ງ ອັນ ປິ່ດ, ມາ ຊານໍ່ ເກົາ ຣາມົຮ ລັ່ຮ!' ອຶນແຍ່ະ ນະ ໄລ່ ຕຶ່ງ ກັອຍ ແກີດ ຣໍ່ອ໌ ບູຍ. ");
INSERT INTO ncq_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","\"ບັອງ ກາ ກັອຍ ອັນ ກາ ອາຍ ອຶນນັ່ອງ ຕະ ໄທຣ. ແຕີ່ອ໌ ອັນ ເຈົາ ປໍ ດຸງ, ແຈ່ະ ອີ ແຕີ່ອ໌ ດຸງ, ອັນ ຊັອງ ຊຽງ ກອງ ເນົ່າ ລ່ຳ, ເນົ່າ ອຶມປ່ອນ. ");
INSERT INTO ncq_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ອັນ ກູອ໌ ມານະ ກວາຍ ທູແທ, ເຈີ່ ຕາແບີບ ປາຍ: 'ອຶນເຕົ່າ ເນົ່າ ຕະ ນ່ະກັອຍ?' ");
INSERT INTO ncq_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ກວາຍ ທູແທ ຕາແອີຍ ປາຍ: 'ອາແອມ ໄມ່ ເຈົາ. ອຶມປໍ່ ໄມ່ ກຍາກ ຕາແກງ ກອນ ກາ ປຼຶ່ມ, ອັນ ຣັ່ບ ກອນ ອັນ ເຈົາ ລັ່ຮ ເບີນ ບັນ ເຣ່ງ ອໍ.' ");
INSERT INTO ncq_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","\"ອັນ ກາ ອາຍ ກັອຍ ຊັອງ ອຶງຄື່ນ ລາລື່ ຕຶ່ງ ຣາງຶ່ຮ ອັນ. ອັນ ຕາ ຢໍອ໌ ອີ ມູ່ດ ນັ່ອງ ປໍ ດຸງ. ເຈີ່ ອຶມປໍ່ ອັນ ລັ່ອຮ ປ່ອຍ ຣາງຶ່ຮ ກອນ ອັນ ໂອນ ມູ່ດ ລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ກອນ ກັອຍ ປາຍ: 'ຕາ ດັງ ອຶນຊິ ກູມໍ ໄນ່ ເຈີ່ ເກົາ ຕະ ຣານະ ໂອນ ໄມ່ ນ່ະ ຊູລ. ອຶນເຕົ່າ ໄມ່ ແປຣີ ເກົາ ຕະ, ເກົາ ຕະ ອາກັອຍ. ມາ ໄມ່ ຕາ ເກີ່ຍ ໂອນ ເກົາ ມານຳ ກອນ ອຶມແບອ໌ ໂອນ ເກົາ ຈາ ຣໍ່ອ໌ ກະ ເຢົ່າ. ");
INSERT INTO ncq_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ມາ ຊານໍ່ ກອນ ອາລັອຮ ໄມ່ ເຈົາ ເຈີ່. ອັນ ຈາຍ ຕັຮ ອຶນແຍ່ະ ປຣະ ມັຮ ກາ ມູ່ນ ໄມ່ ໂອນ ປໍ ມັນແຊມ ກາ ຈິ ຈະ. ມາ ອຶນນັ່ອງ ໄມ່ ກຍາກ ຕາແກງ ກອນ ກາ ປຼຶ່ມ ໂອນ ອັນ.' ");
INSERT INTO ncq_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","\"ອຶມປໍ່ ຕາແອີຍ ປາຍ: 'ກອນ ເອີຍ! ໄມ່ ເບີນ ແອີດ ເລືອຍໆ ກະ ເກົາ. ອຶນແຍ່ະ ມັຮ ເກຣີ່ງ ເກຣົ່າ ເກົາ ເບີນ ລາ ແກີດ ຄອງ ໄມ່ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ມາ ໄຮ ອຶງເຄາະ ຕະ ໂອນ ຣໍ່ອ໌ ອໍ, ຍ່ອນ ອາແອມ ໄມ່ ນ່ະ ອັນ ກູຈີດ, ມາ ຊານໍ່ ນ່ະ ອັນ ອາມົ່ງ ລັ່ຮ. ອັນ ປິ່ດ ເຈີ່, ມາ ຊານໍ່ ໄຮ ອຶນນັ່ອງ ຣາມົຮ ລັ່ຮ.'\" ");
INSERT INTO ncq_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ເຢຊູ ອາຕີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ເບີນ ມານະ ກວາຍ ຊຸ ກະ ເບີນ ມານະ ເນ່ ຊາລີອ໌ ມູ່ນ ອັນ. ມາ ເນົ່າ ຕິ ກວາຍ ກັອຍ, ປາຍ ອັນ ຕາອຽຣ ມູ່ນ ອຶນເຈົາ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ນ່ະກັອຍ ອຶນເຈົາ ກັອຍ ກູອ໌ ກວາຍ ກັອຍ, ກະ ອັນ ຕາແບີບ ປາຍ: 'ອຶນເຕົ່າ ເນົ່າ ປາຍ ໄມ່ ຕະ ຕາ ປຍາຍ໌ ໂຈະ ເກົາ? ໄມ່ ອາຕີ ລັ່ຮ ໂອນ ເກົາ ມາຮ ແລ່ະ ໄມ່ ອີດ, ກະ ມາຮ ແລ່ະ ໄມ່ ໂອນ ເນົ່າ. ໄມ່ ຕາ ເຕ່ອ໌ ແກີດ ນັ່ອງ ກວາຍ ເນ່ ຊາລີອ໌ ມູ່ນ ເກົາ.' ");
INSERT INTO ncq_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ນ່ະກັອຍ ກວາຍ ກັອຍ ຄຶ່ດ ຕຶ່ງ ຣາງຶ່ຮ ອັນ ປາຍ: 'ເກົາ ອີ ຕະ ນານ່ະ? ອຶນເຈົາ ຕາ ເບີນ ໂອນ ເກົາ ເນ່ ຊາລີອ໌ ນັ່ອງ ມູ່ນ ອັນ. ຄັນ ເກົາ ອີ ປິ່ ກູແຕອ໌ ລາ ເກົາ ຕາ ເບີນ ບັນ ເຣ່ງ. ມາ ຄັນ ເກົາ ເປາະ ຊູແຊອ໌, ລາ ເກົາ ກູມາລ ຕະ ເນົ່າ. ");
INSERT INTO ncq_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ເກົາ ດັງ ເຈີ່ ນານ່ະ ເກົາ ອີ ຕະ. ເຈີ່ ແຕີ່ອ໌ ຕາໄງ ເກົາ ຕາ ເບີນ ເນ່ ຊາລີອ໌ ນັ່ອງ ມູ່ນ ອຶນເຈົາ, ຕາໄງ ກັອຍ ເບີນ ເຢົ່າ ເກົາ ກາ ຣັ່ບ ດໍອ໌ ອໍ ປໍ ດຸງ ໄລ່.' ");
INSERT INTO ncq_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","\"ອັນ ກູອ໌ ມັຮ ກວາຍ ກາ ຕູ່ ອຶນເຈົາ ອັນ. ອັນ ຕາແບີບ ກວາຍ ກາ ແຕີ່ອ໌ ອານໍ່ ປາຍ: 'ມາແລ່ະ ໄມ່ ຕູ່ ອຶນເຈົາ ເກົາ?' ");
INSERT INTO ncq_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ກວາຍ ກັອຍ ຕາແອີຍ ປາຍ: 'ເກົາ ຕູ່ ມວຍ ຣ່ອຍ ກູຕຸ່ກ ອຶນຊີ່ງ.' ເຈີ່ ກວາຍ ກາ ເນ່ ຊາລີອ໌ ອາຕີ ປາຍ: 'ໄມ່ ອາລັ່ອຮ ບັນຊີ ໄມ່ ຕາກູ ຄຽນ ໂຈະ ເຊີງ ຈິ່ດ ກູຕຸ່ກ ຊັອງ.' ");
INSERT INTO ncq_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ເຈີ່ ອັນ ຕາແບີບ ກວາຍ ການໍ່ອ໌ ແອັນ ປາຍ: 'ມາ ໄມ່, ມາແລ່ະ ໄມ່ ຕູ່?' ກວາຍ ກັອຍ ຕາແອີຍ ປາຍ: 'ເກົາ ຕູ່ ມວຍ ຣ່ອຍ ອາປໍອ໌ ທຣໍ.' ກວາຍ ກັອຍ ປາຍ ລັ່ຮ: 'ເກົາ ໂອນ ໄມ່ ກູລັຮ ລັ່ຮ ຕາກ່ອລ ຈິ່ດ ອາປໍອ໌ ຊັອງ.' ");
INSERT INTO ncq_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","\"ແວັດ ກັອຍ, ອຶນເຈົາ ຍ່ອງ ກວາຍ ກາ ຕາ ເບີນ ຕານັ່ອງ ກາ ເນ່ ຊາລີອ໌ ກັອຍ, ຍ່ອນ ອັນ ຕະ ແຄວ໌. ໄກຣ ລາລື່ ກວາຍ ກາ ຕາ ເບີນ ປວາຍ ຣານະ ເຢືາງ ເຈົາຣາຊີ, ໄລ່ ຕະ ໂຈະ ເຢົ່າ ໄລ່ ແຄວ໌ ກາເລີຍ ແຕ ກວາຍ ກາ ປວາຍ ຣານະ ເຢືາງ ເຈົາຣາຊີ ຕະ ໂຈະ ເຢົ່າ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","\"ເກົາ ອາຕີ ແອັນ ເຍືາ ປາຍ: ເກຣີ່ງ ອຶນເຕົ່າ ກາ ເຍືາ ເບີນ, ອຶງເຄາະ ເຍືາ ຈ່ອຍ ໂອນ ເຢົ່າ ແຮີ, ນ່ະກັອຍ ຊານົກ ເຍືາ ຕະ ໂອນ ກຼຶ່ງ ກວາຍ ແກີດ ເຢົ່າ ເຍືາ. ເຈີ່ ແຕີ່ອ໌ ຕາໄງ ຊານົກ ເຍືາ ປິ່ດ ອຶນແຍ່ະ, ຕາໄງ ກັອຍ ເຢືາງ ເຈົາຣາຊີ ໂອນ ເຍືາ ແອີດ ຕຶ່ງ ອຶນຕຸ ເຕ່ອ໌ ອາມົ່ງ ຊົດ ແດີຍ. ");
INSERT INTO ncq_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","\"ຄັນ ເຍືາ ຕະ ອໍ ຣານະ ກາ ແກດ ຊານໍ່, ປັຣແນີ ມັນເຕຣືາ ເຍືາ ຕະ ອໍ ເຕ່ ຣານະ ກາ ປື່ດ. ກະ ຄັນ ເຍືາ ມາ ຕາ ເບີນ ຕະ ອໍ ຣານະ ກາ ແກດ ຊານໍ່, ປັຣແນີ ມັນເຕຣືາ ເຍືາ ຕາ ເບີນ ຕະ ອໍ ເຕ່ ຣານະ ກາ ປື່ດ. ");
INSERT INTO ncq_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ນ່ະກັອຍ, ຄັນ ເຍືາ ຕາ ເບີນ ຕະ ອໍ ກະ ເກຣີ່ງ ຊານົກ ເຍືາ ຕຶ່ງ ແດີຍ ໄນ່, ນານ່ະ ເຕ່ອ໌ ເຢືາງ ເຈົາຣາຊີ ອີ ໂອນ ເຍືາ ເບີນ ມູ່ນ ກາ ຕາ ແກີດ ປິ່ດ ຕຶ່ງ ມັນລັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ກະ ຄັນ ເຍືາ ຕາ ເບີນ ຕະ ອໍ ກະ ເກຣີ່ງ ກວາຍ ການໍ່ອ໌ ໂອນ ເຍືາ ກຍາອ໌, ຕາ ເບີນ ອາແລ່ະ ມ່ອບ ໂອນ ເຍືາ ເບີນ ເກຣີ່ງ ເຍືາ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","\"ຕາ ເບີນ ອາແລ່ະ ມາ ເຕ່ອ໌ ແກີດ ຊູລ ໂອນ ບາຣ ນະ ອຶນເຈົາ. ປຍາຍ໌ ອັນ ຊາອັຣ ອຶນເຈົາ ໄນ່, ມາ ອາໂຢ່ະ ອຶນເຈົາ ກັອຍ. ແຕີລາ ອັນ ຊາງັດ ອຶນເຈົາ ໄນ່, ມາ ຕາ ເບີນ ຊາງັດ ອຶນເຈົາ ກັອຍ. ມູເຈິງ ກັອຍ ເຕ່ ເຍືາ ຕາ ເຕ່ອ໌ ປວາຍ ຣານະ ເຢືາງ ເຈົາຣາຊີ ມວຍ ເປຣິຮ ກະ ປວາຍ ຣານະ ຢໍອ໌ ອີ ເບີນ ເກຣີ່ງ ຊານົກ ຕຶ່ງ ແດີຍ ໄນ່ ແຮີ.\" ");
INSERT INTO ncq_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ມັຮ ກວາຍ ພາຣີຊາຍ ຊັອງ ເຢຊູ ອາຕີ ນ່ະກັອຍ. ມາ ໄລ່ ພາມາດ ເຢຊູ, ຍ່ອນ ໄລ່ ປາຊິ ລາລື່ ມັຮ ເກຣີ່ງ ຊານົກ ຕຶ່ງ ແດີຍ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ເຢຊູ ອາຕີ ໂຈະ ໄລ່ ປາຍ: \"ເຍືາ ລາ ກວາຍ ກາ ຕະ ຣານະ ອໍ ຢໍອ໌ ອີ ໂອນ ກວາຍ ປາຍ ເຍືາ ຕານັ່ອງ ອໍ, ມາ ເຢືາງ ເຈົາຣາຊີ ດັງ ຣາງຶ່ຮ ເຍືາ. ອຶນເຕົ່າ ກວາຍ ເກີ່ຍ ຄຶ່ດ ປາຍ ອໍ ລາລື່, ຣາມຶ່ຮ ກັອຍ ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ປາຊິ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","\"ຄານອດ ເຢືາງ ເຈົາຣາຊີ ປາຕັບ ຣານາ ໂມເຊ, ກະ ມັຮ ປັຣນາຍ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ແຕ ອຶມແບິ, ລາ ເມ່ນ ຣານາ ກັອຍ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ເຕົ່າ ແຕີ່ອ໌ ແດີຍ ໂຢຮັນ, ອັນ ກາ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌. ແຕ ຕາໄງ ໂຢຮັນ ແຕີ່ອ໌, ເນົ່າ ອາຕີ ປັຣນາຍ ອໍ ແຕ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ. ກະ ກູ່ ນະ ກວາຍ ຢໍອ໌ ອີ ມູ່ດ ລາລື່ ຕຶ່ງ ຈຸ່ມ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ, ມາ ໄລ່ ຄຶ່ດ ໄລ່ ເຕ່ອ໌ ມູ່ດ ຍ່ອນ ຣາງຶ່ຮ ໄລ່ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ມັນລັ່ອງ ກະ ກູແຕອ໌ ໄນ່ ແກີດ ປິ່ດ ມາໂຮຍ, ມາ ມວຍ ຣາມຶ່ຮ ເນົ່າ ຄຽນ ດໍອ໌ ຕຶ່ງ ຄານອດ ເຢືາງ ເຈົາຣາຊີ ຕາ ເກີ່ຍ ແກີດ ປິ່ດ. ");
INSERT INTO ncq_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","\"ກວາຍ ອາແລ່ະ ມາ ຕັຮ ລາກວຍ ອັນ ເຈີ່ ອີດ ມັນແຊມ ຕາໄມ ແອັນ, ກວາຍ ກັອຍ ຕະ ໂລ່ຍຮ ໂຈະ ລາກວຍ ຕຍາ ອັນ ມູເຈິງ ອັນ ເປາະ ປັຣລື່ຍ. ກະ ກວາຍ ອາແລ່ະ ມາ ອີດ ລາກວຍ ກາ ເນົ່າ ຕັຮ, ຣານະ ກັອຍ ລາ ໂລ່ຍຮ ເຕ່ ນ່ະ ກວາຍ ກັອຍ ປັຣລື່ຍ ລາກວຍ ເນົ່າ.\" ");
INSERT INTO ncq_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","\"ເບີນ ມານະ ກວາຍ ຊຸ ເບີນ. ອັນ ແຊິບ ອາຢັ່ອຮ ເປ່ງ ກາ ແຈບ ອໍ ລາລື່, ກະ ກູ່ ຣາໄງ ອັນ ຕັອກ ຈາ ປຣຍາອ໌ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ກະ ເບີນ ມານະ ກວາຍ ກາດີດ, ຣາມຶ່ຮ ລາຊາໂຣ. ເນົ່າ ເດີງ ດໍອ໌ ອັນ ແອີດ ຢັ່ຮ ນໍ່ອ໌ ແຈ່ະ ງັ່ຮ ຕົ່ງ ດຸງ ກວາຍ ຊຸ ກັອຍ. ຕຶ່ງ ຈະ ອັນ ແອີງ ອຶມປີຮ. ");
INSERT INTO ncq_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ອັນ ອຶງກ່ອງ ຢໍອ໌ ອີ ຈາ ອຶງກັຮ ແຕ ກວາຍ ຊຸ ກັອຍ ຈາ. ກະ ເບີນ ອາຈໍ ແຕີ່ອ໌ ແຢລ ອຶມປີຮ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ເຈີ່ ແວັດ ກັອຍ, ກວາຍ ກາດີດ ກັອຍ ກູຈີດ, ກະ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ເດີງ ອັນ ແອີດ ມັນຕຸ ກະ ອັບຣາຮາມ. ກວາຍ ຊຸ ກັອຍ ກູຈີດ ເຕ່, ເຈີ່ ເນົ່າ ເດີງ ແຕິບ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ກວາຍ ຊຸ ກັອຍ ແອີດ ຕຶ່ງ ປຣຸ່ງ ອູ່ຍຮ ຊັອງ ຕຸ່ຮ ກັ່ດ ລາລື່. ອັນ ຕາງ່ອນ ອາຊັອຮ, ເຈີ່ ອັນ ເຮີມ ອັບຣາຮາມ ແອີດ ເຢີ່ງ ລາລື່ ແຕ ອັນ. ກະ ອັນ ເຮີມ ລາຊາໂຣ ແອີດ ມັນຕຸ ກະ ອັບຣາຮາມ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ນ່ະກັອຍ ກວາຍ ຊຸ ກັອຍ ກູອ໌ ເຣ່ງ ລາລື່ ປາຍ: 'ເອີ ອັບຣາຮາມ, ລາ ອາຈວາຍຮ ອາເຈ່ຮ ເກົາ ເອີຍ! ແຊອ໌ ເຍືາ ອາໂຢ່ະ ຕະ ເກົາ ແຮີ. ແຊອ໌ ເຍືາ ແປຣີ ລາຊາໂຣ ແຕີ່ອ໌ ປໍ ເກົາ, ກະ ໂອນ ອັນ ອາລຸ ອາຕີ ອັນ ຕຶ່ງ ແດີອ໌; ເຈີ່ ອາເຢາະ ຕຶ່ງ ເລືາຍຮ ເກົາ, ຍ່ອນ ເກົາ ຊັອງ ອາອີ່ ຕຸ່ຮ ກັ່ດ ລາລື່ ຕຶ່ງ ອູ່ຍຮ ໄນ່!' ");
INSERT INTO ncq_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","\"ມາ ອັບຣາຮາມ ຕາແອີຍ ອັນ ປາຍ: 'ກອນ ເອີຍ! ໄມ່ ຊາແຍີ ລັ່ຮ ແຕ ບັອງ ໄມ່ ອຶນນັ່ອງ ອາມົ່ງ, ໄມ່ ເບີນ ແອີງ ເກຣີ່ງ ຊານົກ ອໍ ເຈີ່, ມາ ລາຊາໂຣ ເບີນ ຕຸ່ຮ ກັ່ດ ກະ ກາດີດ ລາລື່. ມາ ຊານໍ່ ອຶນໄນ່ ອັນ ເບີນ ຕາລື່ນ ຣາງຶ່ຮ ອັນ, ມາ ໄມ່ ແອີດ ອຶນຕຸ ກັອຍ ເບີນ ຕຸ່ຮ ກັ່ດ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ກະ ມວຍ ຣາມຶ່ຮ ແອັນ, ເບີນ ຊາຮິງ ປຣຸ່ງ ອຶນຕຣູ່ ກະ ຕາວັ່ຮ ລາລື່ ອຶນດີ ໄຮ. ກວາຍ ອາແລ່ະ ມາ ຢໍອ໌ ອີ ຢາງ ແຕ ອຶນຕຸ ຮິ ເປາະ ປໍ ໄມ່, ລາ ຕາ ເຕ່ອ໌. ກະ ກວາຍ ອາແລ່ະ ມາ ຢໍອ໌ ອີ ຢາງ ແຕ ອຶນຕຸ ໄມ່ ອີ ເປາະ ປໍ ຮິ, ລາ ຕາ ເຕ່ອ໌.' ");
INSERT INTO ncq_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","\"ເຈີ່ ກວາຍ ຊຸ ກັອຍ ປາຍ ແອັນ: 'ຄັນ ນ່ະກັອຍ, ເກົາ ແຊອ໌ ເຍືາ ແປຣີ ລາຊາໂຣ ເປາະ ປໍ ດຸງ ອຶມປໍ່ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ເກົາ ອຶນນັ່ອງ ເບີນ ເຊີງ ນະ ແຊມອາຍ ແອີດ ປໍ ດຸງ. ໂອນ ລາຊາໂຣ ເປາະ ອາຕີ ໄລ່ ກັອຍ ອຶງກັອຮ ໄລ່ ຣາມົຮ ຕຸ່ຮ ກັ່ດ ນ່ະ ເກົາ ເຕ່.' ");
INSERT INTO ncq_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","\"ມາ ອັບຣາຮາມ ປາຍ: 'ແຊມອາຍ ໄມ່ ເບີນ ເຈີ່ ປັຣນາຍ ໂມເຊ ອາຕີ ກະ ປັຣນາຍ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ. ອຶງເຄາະ ແຊມອາຍ ໄມ່ ຊາງັດ ກະ ປວາຍ ປັຣນາຍ ໄລ່.' ");
INSERT INTO ncq_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","\"ກວາຍ ຊຸ ກັອຍ ປາຍ ແອັນ: 'ເອີ ອັບຣາຮາມ, ລາ ອາຈວາຍຮ ອາເຈ່ຮ ເກົາ ເອີຍ! ໄລ່ ຕາ ເບີນ ຊາງັດ ປັຣນາຍ ໄລ່ ກັອຍ. ມາ ຄັນ ເບີນ ກວາຍ ກູຈີດ ມາ ອາມົ່ງ ລັ່ຮ ເປາະ ອາຕີ ແຊມອາຍ ເກົາ, ໄລ່ ຕັຮ ຣາງຶ່ຮ ຕຍາ ປຽນ ແກີດ ຣາງຶ່ຮ ຕາໄມ ແອັນ.' ");
INSERT INTO ncq_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","\"ມາ ອັບຣາຮາມ ຕາແອີຍ ລັ່ຮ ປາຍ: 'ຄັນ ແຊມອາຍ ໄມ່ ມາ ຕາ ເບີນ ຊາງັດ ປັຣນາຍ ໂມເຊ ກະ ມັຮ ກວາຍ ກາ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ໄລ່ ຕາ ເບີນ ຊາງັດ ເຕ່ ຄັນ ເບີນ ກວາຍ ກູຈີດ ມາ ອາມົ່ງ ລັ່ຮ.'\" ");
INSERT INTO ncq_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ເຢຊູ ອາຕີ ໂຈະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ໄກຣ ລາລື່ ຕາ ເບີນ ແອິ ຣາມຶ່ຮ ກາ ຢໍອ໌ ອີ ປັຣຕຶ່ ກວາຍ ຕະ ໂລ່ຍຮ, ມາ ບາບ ລາລື່ ແຕີ່ອ໌ ປໍ ກວາຍ ກາ ປັຣຕຶ່ ກວາຍ ການໍ່ອ໌ ເດີງ ຕະ ໂລ່ຍຮ. ");
INSERT INTO ncq_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ຄັນ ກວາຍ ອາແລ່ະ ມາ ປັຣຕຶ່ ມານະ ກາ ນ່ະ ກັຣແນນ ໄນ່ ໂອນ ອັນ ຕະ ໂລ່ຍຮ, ຄາອ໌ ອີດ ຕາເມົາ ປື່ດ ຊັດ ໂຈະ ຕຶ່ງ ຕາກອງ ອັນ ກັອຍ ເຈີ່ ອາປັອງ ຕັຮ ອັນ ຕຶ່ງ ທາເລ. ");
INSERT INTO ncq_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ເຍືາ ເນ່ ອໍ ຣາງຶ່ຮ ເຍືາ ເບີມ! ຄັນ ເບີນ ເຢົ່າ ເຍືາ ມາ ຕະ ໂລ່ຍຮ ໂຈະ ເຍືາ, ອຶງເຄາະ ເຍືາ ກາແອັຮ ອັນ. ກະ ຄັນ ອັນ ງີ່ນ ໂລ່ຍຮ, ອຶງເຄາະ ເຍືາ ຕັຮ ໂລ່ຍຮ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ຄັນ ເຢົ່າ ເຍືາ ຕະ ໂລ່ຍຮ ໂຈະ ເຍືາ ມູ ຕາໄງ ຕາປູ່ລ ເຮີບ, ມາ ຄັນ ອັນ ແຕີ່ອ໌ ປໍ ເຍືາ ງີ່ນ ລັ່ຮ ອຶນແຍ່ະ ຕາປູ່ລ ເຮີບ ກັອຍ, ເຈີ່ ປາຍ: 'ແຊອ໌ ໄມ່ ຕັຮ ໂລ່ຍຮ ເກົາ,' ອຶງເຄາະ ເຍືາ ຕັຮ ໂລ່ຍຮ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ແຊອ໌ ແຕ ອັນ ປາຍ: \"ແຊອ໌ ອຶນເຈົາ ຕະ ໂອນ ຮິ ຊາອຳ ຊາອຶ່ຍ ລາລື່ ແອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ເຢຊູ ອາຕີ ລັ່ຮ ໄລ່ ປາຍ: \"ຄັນ ເຍືາ ຊາອຳ, ອຶມປຶ່ ເບີນ ມາຮ ມູ ກຼອງ ປາກາດ ຊັອງ, ເຕ່ອ໌ ເຍືາ ແປຣີ ກັ່ລ ອາລ່ອງ ໄນ່ ປາຍ: 'ອາລ່ອງ ເອີຍ, ເອົາ ໄມ່ ເຣີ່ອ໌ ກັ່ລ ໄມ່ ເບີມ, ເຈີ່ ໄມ່ ຈົຮ ລັ່ຮ ກັ່ລ ໄມ່ ຕຶ່ງ ທາເລ ແອັນ,' ເຈີ່ ກັ່ລ ອາລ່ອງ ກັອຍ ອັນ ຊາງັດ ປັຣນາຍ ເຍືາ.\" ");
INSERT INTO ncq_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","\"ຄັນ ມານະ ແຕ ມູ່ ເຍືາ ມາ ເບີນ ຊູລ ຕະ ຣານະ ຕາລ ໄທຣ ແຕີລາ ກຍາອ໌ ແກະ, ແຕີ່ອ໌ ຊູລ ກັອຍ ເຈົາ ຕາບື່, ອຶນເຈົາ ກັອຍ ຕາ ເບີນ ອາຕີ ໂຈະ ອັນ ປາຍ: 'ເອົາ ໄມ່ ມູ່ດ ຈາ ຊານໍ່ ແຕິ່.' ");
INSERT INTO ncq_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ອັນ ຕາ ເບີນ ປາຍ ນ່ະກັອຍ! ມາ ອຶນເຈົາ ເກີ່ຍ ປາຍ ນ່ະໄນ່ ໂຈະ ຊູລ ກັອຍ: 'ເອົາ ໄມ່ ອາລັ່ອຮ ເກຣີ່ງ ຊັຣນາ ໂອນ ເກົາ ຈາ. ກະ ໄມ່ ທຣາວ ເກຣີ່ງ; ເຈີ່ ໄມ່ ແອີດ ເນ່ ເຕົ່າ ເຈີ່ ເກົາ ຈາ. ແວັດ ກັອຍ, ເຕ່ອ໌ ໄມ່ ຈາ.' ");
INSERT INTO ncq_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ມາ ອຶນເຈົາ ກັອຍ ຕາ ເບີນ ຊາແອີນ ຊູລ ກັອຍ ຕະ ຣານະ ປວາຍ ປັຣນາຍ ອັນ ແປຣີ. ");
INSERT INTO ncq_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ເຍືາ ລາ ມູເຈິງ ຊູລ ກັອຍ ເຕ່. ແຕີ່ອ໌ ເຍືາ ຕະ ເຈີ່ ມັຮ ກູ່ ຣານະ ເຢືາງ ເຈົາຣາຊີ ແປຣີ ເຍືາ ຕະ, ອຶງເຄາະ ເຍືາ ປາຍ: 'ຮິ ລາ ຊູລ ເຢືາງ ເຈົາຣາຊີ. ຮິ ຕາ ເບີນ ຄຶ່ດ ປາຍ ເຢືາງ ເຈົາຣາຊີ ອຶງເຄາະ ຍ່ອງ ຮິ, ຍ່ອນ ຮິ ຕະ ແອີງ ຣານະ ເຢືາງ ເຈົາຣາຊີ ແປຣີ ຊັອງ.'\" ");
INSERT INTO ncq_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ບັອງ ກາ ເຢຊູ ເປາະ ອຶນດີ ປໍ ເມືອງ ເຢຣູຊາເລັມ, ອັນ ເປາະ ພາ ຣາລັ່ນ ແຄງ ຊາມາເຣຍ ກະ ຄາລີເລ. ");
INSERT INTO ncq_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ແຈ່ະ ອັນ ອີ ມູ່ດ ວີ່ລ, ອັນ ຣາມົຮ ມວຍ ຈິ່ດ ນະ ກວາຍ ອາອີ່ ຕູ່ດ. ໄລ່ ແອີດ ເຢີ່ງ ແຕ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ໄລ່ ກູອ໌ ອັນ ປາຍ: \"ອຶນເຈົາ ເຢຊູ ເອີຍ! ແຊອ໌ ໄມ່ ອາໂຢ່ະ ຕະ ຈ່ອຍ ຮິ ແຮີ!\" ");
INSERT INTO ncq_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ເຢຊູ ເຮີມ ໄລ່, ເຈີ່ ອັນ ປາຍ: \"ເຍືາ ເປາະ ອາປັຮ ຈະ ເຍືາ ໂອນ ກວາຍ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ເຮີມ.\" ບັອງ ກາ ໄລ່ ເປາະ, ໄລ່ ແກີດ ແບຣັຮ ອາອີ່ ຕູ່ດ. ");
INSERT INTO ncq_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ມານະ ແຕ ໄລ່ ມວຍ ຈິ່ດ ນະ ກັອຍ, ພໍກາ ອັນ ເຮີມ ອັນ ແບຣັຮ, ເຈີ່ ອັນ ລົ່ບ ລັ່ຮ ປໍ ເຢຊູ, ກະ ອັນ ຊາແອີນ ເຢືາງ ເຈົາຣາຊີ ເຣ່ງ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ອັນ ກູກຸຮ ຄຣາບ ຢັ່ຮ ເມືາງ ເຢຊູ ກະ ຊາແອີນ ອັນ. ກວາຍ ກັອຍ ລາ ກວາຍ ຊາມາເຣຍ. ");
INSERT INTO ncq_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ເຢຊູ ປາຍ: \"ເບີນ ມວຍ ຈິ່ດ ນະ ແກີດ ແບຣັຮ. ປໍ ແລ່ະ ໄລ່ ຕາເກ່ຮ ນະ ແອັນ? ");
INSERT INTO ncq_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ແອີງ ມານະ ໄນ່ ແຕິ່ ຊາແອີນ ເຢືາງ ເຈົາຣາຊີ. ກະ ອັນ ລາ ກວາຍ ແຕ ກຣວາງ ການໍ່ອ໌.\" ");
INSERT INTO ncq_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ເຈີ່ ເຢຊູ ອາຕີ ກວາຍ ກັອຍ: \"ໄມ່ ຢວຣ ຕາຢຶ່ງ, ເຈີ່ ໄມ່ ເປາະ. ຍ່ອນ ໄມ່ ຊາອຳ, ໄມ່ ແກີດ ແບຣັຮ ອໍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ເບີນ ມັຮ ກວາຍ ແຕ ຈຸ່ມ ພາຣີຊາຍ ຕາແບີບ ເຢຊູ ອຶນນັ່ອງ ມາແລ່ະ ດູ່ນ ແຕ ເຢືາງ ເຈົາຣາຊີ ອີ ຕະ ຊົດ ຕຶ່ງ ກຣວາງ ກູແຕອ໌ ໄນ່. ເຢຊູ ຕາແອີຍ ໄລ່ ກັອຍ ປາຍ: \"ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ອັນ ຕາ ເບີນ ອາປັຮ ໂອນ ກວາຍ ເຕ່ອ໌ ເຮີມ ກະ ດັງ. ");
INSERT INTO ncq_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ຕາ ເບີນ ເນົ່າ ເຕ່ອ໌ ປາຍ: 'ໄນ່! ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ລາ ອຶນໄນ່, ແຕີລາ ອຶນຕຸ ກັອຍ!' ເນົ່າ ຕາ ເຕ່ອ໌ ປາຍ ນ່ະກັອຍ, ຍ່ອນ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ລາ ແອີດ ອຶນດີ ມູ່ລ ມູ່ ເຍືາ.\" ");
INSERT INTO ncq_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ເຈີ່ ເຢຊູ ອາຕີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ປັຣແນີ ມັນເຕຣືາ ແຕີ່ອ໌ ຕາໄງ ເຍືາ ຊັອງ ຢໍອ໌ ອີ ເຮີມ ລາລື່ ກອນ ເຢືາງ ແກີດ ກວາຍ ແອີດ ລັ່ຮ ປໍ ກູແຕອ໌ ໄນ່ ແອີງ ມວຍ ຕາໄງ ຊັອງ ລາ ໂທຍ, ມາ ເຍືາ ຕາ ດັງ ເບີນ ເຮີມ. ");
INSERT INTO ncq_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ເບີນ ກວາຍ ການໍ່ອ໌ ອີ ປາຍ ໂຈະ ເຍືາ ນ່ະໄນ່: 'ກອນ ເຢືາງ ແກີດ ກວາຍ ແອີດ ອຶນໄນ່' ແຕີລາ 'ແອີດ ອຶນຕຸ ກັອຍ.' ມາ ເຍືາ ອຶນໂຈຍ ເປາະ, ກະ ອຶນໂຈຍ ຊາງັດ ປັຣນາຍ ໄລ່ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ຕາໄງ ເກົາ, ກອນ ເຢືາງ ແກີດ ກວາຍ, ແຕີ່ອ໌ ລັ່ຮ ລາ ນ່ະ ຕາລຍາຣ ກັລກາງ ແຕ ເປິບ ໄນ່ ແຕີ່ອ໌ ເປິບ ກັອຍ ຕຶ່ງ ມັນລັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ມາ ແຕ ອຶນໂຍ່ງ ຕາໄງ ກັອຍ, ເກົາ ອຶງເຄາະ ຈີວ໌ ຊາອຶ່ຍ ຣາມຶ່ຮ ຕຸ່ຮ ກັ່ດ ກະ ມັຮ ກວາຍ ແອີດ ຕຶ່ງ ແດີຍ ໄນ່ ກາແລີຍຮ ຕັຮ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ພໍກາ ເກົາ, ກອນ ເຢືາງ ແກີດ ກວາຍ, ເຈົາ ລັ່ຮ ປໍ ກູແຕອ໌ ໄນ່ ລາ ນ່ະ ແດີຍ ໂນອາ ແຕ ອຶມແບິ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ຕຶ່ງ ແດີຍ ໂນອາ, ກູ່ ນະ ກວາຍ ຈາ ງ່ອຍ໌ ຣໍ່ອ໌ ບູຍ ລາລື່, ກະ ໄລ່ ອີດ ກອນ ລາກວຍ ມັນຕັ່ດ ແຕ ອຶນລີ່ງ ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ໂນອາ ຊັອຮ ຕຶ່ງ ຕົວະ. ເຈີ່ ແດີອ໌ ຣາເລືາບ ແຕີ່ອ໌, ຕະ ໂອນ ກູ່ ນະ ກວາຍ ຕຶ່ງ ແດີຍ ກັອຍ ກູຈີດ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ກະ ປາເນ່ນ ເກົາ, ກອນ ເຢືາງ ແກີດ ກວາຍ, ເຈົາ ລັ່ຮ ລາ ນ່ະ ແດີຍ ໂລດ ແຕ ອຶມແບິ ເຕ່. ມັຮ ກວາຍ ຕຶ່ງ ແດີຍ ກັອຍ ຈາ ງ່ອຍ໌ ຣໍ່ອ໌ ບູຍ ລາລື່, ໄລ່ ຈິແຈີງ, ໄລ່ ຈັ່ດ ຈອຍ, ກະ ໄລ່ ຕະ ດຸງ. ");
INSERT INTO ncq_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ມາ ຕາໄງ ໂລດ ກັອຍ ລັ່ອຮ ແຕ ເມືອງ ໂຊໂດມ, ເຢືາງ ເຈົາຣາຊີ ອາປັອງ ໂຈະ ກາເຈຍ ກະ ປັຣລາ ອູ່ຍຮ ນ່ະ ເມືາ ຊາແລັຮ ແຕ ມັນລັ່ອງ, ກະ ກູ່ ນະ ກວາຍ ຕຶ່ງ ເມືອງ ກັອຍ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ຕາໄງ ເກົາ, ກອນ ເຢືາງ ແກີດ ກວາຍ, ແຕີ່ອ໌ ອາປັຮ ລັ່ຮ ລາ ມູເຈິງ ກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","\"ຕຶ່ງ ຕາໄງ ກັອຍ, ຄັນ ເບີນ ກວາຍ ອາແລ່ະ ມາ ແອີດ ຕຶ່ງ ຕຳປວລ ດຸງ ເປືາຣ, ອຶງເຄາະ ອັນ ອຶນໂຈຍ ແຊງ ອີດ ນັ່ອງ ເກຣີ່ງ ຕຶ່ງ ປື່ນ ດຸງ ອັນ. ມູເຈິງ ກັອຍ ເຕ່, ອັນ ກາ ຕະ ໄທຣ, ອຶງເຄາະ ອັນ ອຶນໂຈຍ ເຈົາ ປໍ ດຸງ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ອຶງເຄາະ ເຍືາ ຊາແຍີ ລັ່ຮ ແຕ ລາກວຍ ໂລດ ແຕ ອຶມແບິ! ");
INSERT INTO ncq_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ກວາຍ ອາແລ່ະ ມາ ປາຊິ ຣາງຶ່ຮ ອັນ ຕຶ່ງ ແດີຍ ໄນ່, ຣາງຶ່ຮ ກວາຍ ກັອຍ ປິ່ດ. ມາ ກວາຍ ອາແລ່ະ ມາ ຈີວ໌ ປິ່ດ ຣາງຶ່ຮ ອັນ ຕຶ່ງ ແດີຍ ໄນ່, ຣາງຶ່ຮ ກວາຍ ກັອຍ ຕາ ເບີນ ແກີດ ປິ່ດ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ຕຶ່ງ ຊາເດົາ ກັອຍ ເບີນ ບາຣ ນະ ບິ ມວຍ ອຶນຕຸ. ມານະ, ເຢືາງ ເຈົາຣາຊີ ເດີງ ເປາະ ກະ ອັນ; ມາ ມານະ ແອັນ, ເຢືາງ ເຈົາຣາຊີ ດໍອ໌ ລັ່ຮ ອຶງກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ບັອງ ກາ ກັອຍ ເບີນ ບາຣ ນະ ມັນແຊມ ແອີດ ກູກຼົຮ ທຣໍ. ເຢືາງ ເຈົາຣາຊີ ເດີງ ມານະ ເປາະ ກະ ອັນ, ມາ ມານະ ແອັນ, ເຢືາງ ເຈົາຣາຊີ ດໍອ໌ ລັ່ຮ ອຶງກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ກະ ບັອງ ກາ ກັອຍ ເບີນ ບາຣ ນະ ຣາເລົາ ແອີດ ຕຶ່ງ ໄທຣ. ເຢືາງ ເຈົາຣາຊີ ເດີງ ມານະ ເປາະ ກະ ອັນ, ມາ ມານະ ແອັນ, ເຢືາງ ເຈົາຣາຊີ ດໍອ໌ ລັ່ຮ ອຶງກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ມູ່ ກາ ຣຍານ ແຕ ອັນ ຕາແບີບ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ປໍ ແລ່ະ ຣານະ ໄນ່ ແກີດ?\" ເຢຊູ ຕາແອີຍ ໄລ່ ແຕ ປັຣນາຍ ຕຳແປຼອ໌ ປາຍ: \"ອຶນຕຸ ແລ່ະ ເບີນ ກວາຍ ກູຈີດ, ອຶນຕຸ ກັອຍ ເບີນ ແຈມ ກາລາງ ແຊງ ໂຣ່ມ ຈາ ກູມັບ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ເຈີ່ ເຢຊູ ອາຕີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ມວຍ ປັຣນາຍ ຊາກຳ ຢໍອ໌ ອີ ໂອນ ໄລ່ ດັງ ອຶງເຄາະ ໄລ່ ເກົາແຊອ໌ ເລືອຍໆ, ອຶນໂຈຍ ລາແກັຮ ລາເກືາຍ. ");
INSERT INTO ncq_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ອັນ ປາຍ: \"ເບີນ ມານະ ກວາຍ ຊົດ ກາ ຕັດຊີ່ນ ກວາຍ ຕຶ່ງ ເມືອງ. ອັນ ຕາ ເບີນ ອຶງກັອຮ ອຶນເຕົ່າ ເຢືາງ ເຈົາຣາຊີ, ກະ ອັນ ຕາ ເບີນ ຊາງັດ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ຕຶ່ງ ເມືອງ ກັອຍ ເບີນ ມານະ ອຶມເປ່ອ໌ ກູມາຍ. ອັນ ແຕີ່ອ໌ ດຸໆ ປໍ ກວາຍ ຊົດ ກັອຍ, ກະ ອັນ ປາຍ: 'ແຊອ໌ ອາຈວາຍຮ ຕັດຊີ່ນ ໂອນ ປຍາຍ໌, ເຈີ່ ເຕ່ອ໌ ເກົາ ແມິ່ມ ແຕ ກວາຍ ກາ ຕະ ເກົາ!' ");
INSERT INTO ncq_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","\"ດູ່ນ ເຈີ່ ກວາຍ ຊົດ ກັອຍ ຕາ ຢໍອ໌ ອີ ຊາງັດ ປັຣນາຍ ອຶມເປ່ອ໌ ກູມາຍ ກັອຍ. ມາ ແຕີ່ອ໌ ຕາໄງ ອັນ ຄຶ່ດ ຕຶ່ງ ຣາງຶ່ຮ ອັນ ປາຍ: 'ເກົາ ຕາ ເບີນ ອຶງກັອຮ ເຢືາງ ເຈົາຣາຊີ, ກະ ເກົາ ຕາ ເບີນ ຊາງັດ ກາ ກວາຍ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ມາ ຍ່ອນ ອຶມເປ່ອ໌ ກູມາຍ ໄນ່ ແຕີ່ອ໌ ແຊອ໌ ດຸໆ ແຕ ເກົາ, ຍ່ອນ ນ່ະກັອຍ ເກົາ ຈ່ອຍ ກະ ຕະ ປຍາຍ໌ ໂອນ ອັນ. ຄັນ ເກົາ ຕາ ເບີນ ຈ່ອຍ, ອັນ ແຕີ່ອ໌ ປາຕຸ່ຮ ເກົາ ເລືອຍໆ, ກະ ອັນ ຕະ ໂອນ ເກົາ ແກີດ ຊາອີຣ!'\" ");
INSERT INTO ncq_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ເຈີ່ ເຢຊູ ປາຍ ແອັນ: \"ໂອນ ເຍືາ ຊາງັດ ແຕ ປັຣນາຍ ກວາຍ ກາ ຕາ ເບີນ ຕານັ່ອງ ອໍ ກາ ຕັດຊີ່ນ ໂອນ ອຶມເປ່ອ໌ ກູມາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ມາ ເຢືາງ ເຈົາຣາຊີ, ອັນ ຕັດຊີ່ນ ປຍາຍ໌ ລາລື່ ຈ່ອຍ ໄລ່ ກາ ປວາຍ ຣານະ ອັນ, ໄລ່ ກາ ກູອ໌ ອັນ ກູ່ ຣາໄງ ກູ່ ຊາເດົາ. ມາໂຮຍ ລາລື່ ອັນ ຈ່ອຍ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ເກົາ ອີ ອາຕີ ໂອນ ເຍືາ ດັງ, ເຢືາງ ເຈົາຣາຊີ ຕັດຊີ່ນ ປຍາຍ໌ ໂອນ ໄລ່ ກາ ປວາຍ ຣານະ ອັນ, ກະ ອັນ ຕະ ຣານະ ກັອຍ ໄວ່ ລາລື່. ມາ ແຕີ່ອ໌ ເກົາ, ກອນ ເຢືາງ ແກີດ ກວາຍ, ເຈົາ ລັ່ຮ ປໍ ກູແຕອ໌ ໄນ່, ເກົາ ຣາມົຮ ກວາຍ ກາ ອຶນນັ່ອງ ຊາອຳ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ເຢຊູ ອາຕີ ປັຣນາຍ ຊາກຳ ແອັນ ໂຈະ ກວາຍ ກາ ຄຶ່ດ ປາຍ ໄລ່ ຕານັ່ອງ ອໍ ມາ ກວາຍ ການໍ່ອ໌ ຕາ ເບີນ ອໍ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ອັນ ປາຍ: \"ເບີນ ບາຣ ນະ ຣາເລົາ ມູ່ດ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ ຢໍອ໌ ອີ ເກົາແຊອ໌. ມານະ ລາ ກວາຍ ພາຣີຊາຍ, ກະ ມານະ ລາ ກວາຍ ອີດ ປຣະ ປາຊີ. ");
INSERT INTO ncq_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ອັນ ກາ ກວາຍ ພາຣີຊາຍ, ອັນ ຕາຢຶ່ງ ມານະ ອັນ ເກົາແຊອ໌ ປາຍ: 'ກູກຸຮ ເຢືາງ ເຈົາຣາຊີ, ເກົາ ຊາແອີນ ເຍືາ ຍ່ອນ ເກົາ ຕາ ເບີນ ຕະ ໂລ່ຍຮ ນ່ະ ກວາຍ ການໍ່ອ໌. ເກົາ ຕາ ເບີນ ຢໍອ໌ ອີ ເບີນ ເກຣີ່ງ ເນົ່າ. ເກົາ ຕາ ເບີນ ອາໂລກ ເນົ່າ. ເກົາ ຕາ ເບີນ ໂກ່ະ ລາກວຍ ເນົ່າ. ເກົາ ຊາແອີນ ເຍືາ, ເກົາ ຕາ ເບີນ ນ່ະ ກວາຍ ກາ ອີດ ປຣະ ປາຊີ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ເກົາ ອົດ ຕາ ເບີນ ຈາ ຊັຣນາ ມວຍ ອາທິດ ບາຣ ຕາໄງ. ກະ ອຶນແຍ່ະ ມູ່ນ ເກົາ, ຄັນ ເບີນ ມວຍ ຈິ່ດ ປູ່ດ, ເກົາ ມ່ອບ ຊາງ ມວຍ ປູ່ດ ໂອນ ເຍືາ.' ");
INSERT INTO ncq_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ມາ ກວາຍ ກາ ອີດ ປຣະ ປາຊີ ກັອຍ, ອັນ ແອີດ ເຢີ່ງ ແຕ ກວາຍ ພາຣີຊາຍ. ອັນ ຕາ ຍັ່ນ ຕາເງີ່ອ໌ ອາຊັອຮ ປໍ ມັນລັ່ອງ. ອັນ ແກິ່ ອາເປີ່ມ ອັນ ເບີມ ຍ່ອນ ອັນ ຊັອງ ຕຸ່ຮ. ກະ ອັນ ປາຍ: 'ເອີ ເຢືາງ ເຈົາຣາຊີ ເອີຍ! ແຊອ໌ ເຍືາ ອາໂຢ່ະ ຕະ ເກົາ ແຮີ, ຍ່ອນ ເກົາ ລາ ກວາຍ ໂລ່ຍຮ!'\" ");
INSERT INTO ncq_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ເຈີ່ ເຢຊູ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ກວາຍ ກາ ອີດ ປຣະ ປາຊີ ໄນ່, ອັນ ເຈົາ ປໍ ດຸງ, ອັນ ຕານັ່ອງ ອໍ ຢັ່ຮ ເມືາງ ເຢືາງ ເຈົາຣາຊີ. ມາ ກວາຍ ພາຣີຊາຍ ກັອຍ ຕາ ເບີນ ຕານັ່ອງ ອໍ ອຶນເຕົ່າ ຢັ່ຮ ເມືາງ ເຢືາງ ເຈົາຣາຊີ. ຄັນ ກວາຍ ອາແລ່ະ ມາ ອາຊັອຮ ຈະ ເບີມ ຢໍອ໌ ອີ ແກີດ ປື່ດ, ປັຣແນີ ມັນເຕຣືາ ກວາຍ ກັອຍ ແກີດ ແກດ ແອັນ. ກະ ກວາຍ ອາແລ່ະ ກາ ອາແຊງ ຈະ ອັນ ໂອນ ແກດ ຊານໍ່, ປັຣແນີ ມັນເຕຣືາ ອັນ ແກີດ ປື່ດ ແອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ເບີນ ກວາຍ ເດີງ ກັຣແນນ ແກດໆ ແຕີ່ອ໌ ປໍ ເຢຊູ, ຢໍອ໌ ອີ ໂອນ ເຢຊູ ຊາປ່ະ ອາຕີ ຕຶ່ງ ກັຣແນນ ກັອຍ. ມາ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ເຮີມ ໄລ່ ແຕີ່ອ໌; ເຈີ່ ໄລ່ ກາແອັຮ ມັຮ ກວາຍ ກາ ເດີງ ກັຣແນນ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ມາ ເຢຊູ ກູອ໌ ກັຣແນນ ກັອຍ ໂອນ ແຕີ່ອ໌ ປໍ ອັນ; ເຈີ່ ອັນ ປາຍ: \"ເຍືາ ໂອນ ກັຣແນນ ແຕີ່ອ໌ ປໍ ເກົາ. ອຶນໂຈຍ ກາຕັງ ໄລ່, ຍ່ອນ ຕຶ່ງ ຈຸ່ມ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ເບີນ ແອີງ ກວາຍ ກາ ເບີນ ຣາງຶ່ຮ ນ່ະ ກັຣແນນ ໄນ່ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ຄັນ ກວາຍ ອາແລ່ະ ມາ ຕາ ເບີນ ປຣ່ອມ ໂອນ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ນ່ະ ກັຣແນນ ປຣ່ອມ, ກວາຍ ກັອຍ ຕາ ເຕ່ອ໌ ມູ່ດ ຕຶ່ງ ຈຸ່ມ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ.\" ");
INSERT INTO ncq_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ເບີນ ມານະ ກວາຍ ຊົດ ຕຶ່ງ ຈຸ່ມ ອິດຊະຣາເອລ ແຕີ່ອ໌ ຕາແບີບ ເຢຊູ ປາຍ: \"ອາຈານ ກາ ອໍ ເອີຍ! ເກົາ ອຶງເຄາະ ຕະ ນານ່ະ ໂອນ ເຕ່ອ໌ ເກົາ ເບີນ ອາມົ່ງ ເລືອຍໆ?\" ");
INSERT INTO ncq_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ເຢຊູ ຕາແອີຍ ລັ່ຮ ອັນ ປາຍ: \"ນານ່ະ ໄມ່ ດໍອ໌ ເກົາ ອໍ? ແອີງ ເຢືາງ ເຈົາຣາຊີ ຊັອງ ກາ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ໄມ່ ດັງ ເຈີ່ ເຢືາງ ເຈົາຣາຊີ ປາຕັບ: 'ອຶນໂຈຍ ໂກ່ະ ລາກວຍ ກາຢາອ໌ ເນົ່າ; ອຶນໂຈຍ ກາຈີດ ກວາຍ ການໍ່ອ໌; ອຶນໂຈຍ ຕູຕວຍ໌; ອຶນໂຈຍ ຕະ ອຶນຕີ ອາໂລກ; ກະ ຢຳນັ່ບ ອຶມເປ່ອ໌ ອຶມປໍ່ ໄມ່.'\" ");
INSERT INTO ncq_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ກວາຍ ກັອຍ ປາຍ ລັ່ຮ ນ່ະໄນ່: \"ກູ່ ປັຣນາຍ ປາຕັບ ກັອຍ ເກົາ ຕະ ຕາປູ່ນ ແຕ ເກົາ ອຶນນັ່ອງ ແກດ.\" ");
INSERT INTO ncq_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ພໍກາ ເຢຊູ ຊັອງ ອັນ ປາຍ ນ່ະກັອຍ, ເຢຊູ ອາຕີ ລັ່ຮ ອັນ ປາຍ: \"ໄມ່ ອຶນນັ່ອງ ແອິ ມວຍ ຣາມຶ່ຮ. ໂອນ ໄມ່ ເປາະ ຈິ ອຶນແຍ່ະ ມັຮ ມູ່ນ ໄມ່; ເຈີ່ ອີດ ປຣະ ກັອຍ ຈ່ອຍ ໂອນ ກວາຍ ກາດີດ. ຄັນ ໄມ່ ຕະ ນ່ະກັອຍ, ໄມ່ ເບີນ ມູ່ນ ອໍ ຕຶ່ງ ມັນລັ່ອງ. ເຈີ່ ໄມ່ ແຕີ່ອ໌ ປວາຍ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ບັອງ ກາ ກວາຍ ກັອຍ ຊັອງ ປັຣນາຍ ເຢຊູ ປາຍ ນ່ະກັອຍ, ອັນ ຊັອງ ຕຸ່ຮ ຕຶ່ງ ຣາງຶ່ຮ ອັນ, ຍ່ອນ ອັນ ລາ ກວາຍ ຊຸ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ເຢຊູ ເຮີມ ກວາຍ ກັອຍ ຊັອງ ຕຸ່ຮ. ເຈີ່ ອັນ ອາຕີ ແອັນ ປາຍ: \"ມັຮ ກາ ກວາຍ ຊຸ ເບີນ, ກັ່ດ ລາລື່ ໂອນ ໄລ່ ກັອຍ ມູ່ດ ຕຶ່ງ ຈຸ່ມ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ! ");
INSERT INTO ncq_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ຊັນຕຣັ່ນ ອູ່ດ ລວາຍ໌ ຕາຣົ່ງ ມັນຈິ່ລ ອຶນເນີ່ມ ອຽນ ກາເລີຍ ແຕ ກວາຍ ຊຸ ເບີນ ອີ ມູ່ດ ຕຶ່ງ ຈຸ່ມ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ.\" ");
INSERT INTO ncq_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ໄລ່ ກາ ຊັອງ ເຢຊູ ປາຍ ນ່ະກັອຍ, ໄລ່ ຕາແບີບ ອັນ ປາຍ: \"ຄັນ ນ່ະກັອຍ, ເນົ່າ ເຕ່ອ໌ ເບີນ ອາມົ່ງ ເລືອຍໆ?\" ");
INSERT INTO ncq_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ເຢຊູ ຕາແອີຍ ປາຍ: \"ກວາຍ ຕາ ເຕ່ອ໌ ຕະ ເບີມ ຣານະ ກັອຍ, ມາ ເຢືາງ ເຈົາຣາຊີ ເຕ່ອ໌ ຕະ ກູ່ ຣາມຶ່ຮ.\" ");
INSERT INTO ncq_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ເຈີ່ ເປໂຕ ປາຍ ກະ ເຢຊູ: \"ໄນ່! ຮິ ຕັຮ ອຶນແຍ່ະ ກູ່ ຣາມຶ່ຮ ຮິ ເບີນ, ຍ່ອນ ຮິ ອີ ເປາະ ກະ ອາຈານ.\" ");
INSERT INTO ncq_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ກວາຍ ອາແລ່ະ ກາ ຕັຮ ດຸງຊູ, ຕັຮ ອຶມເປ່ອ໌ ອຶມປໍ່, ຕັຮ ແຊມອາຍ, ກະ ຕັຮ ກອນ ລາກວຍ, ຍ່ອນ ອັນ ຢໍອ໌ ອີ ໂອນ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ, ");
INSERT INTO ncq_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ກວາຍ ກັອຍ ເບີນ ລັ່ຮ ກາເລີຍ ແຕ ຣາມຶ່ຮ ກາ ອັນ ຕັຮ ແຕ ອຶນໂຍ່ງ. ກະ ເຈີ່ ປໍ ເມືາງ ກວາຍ ກັອຍ ເບີນ ອາມົ່ງ ເລືອຍໆ.\" ");
INSERT INTO ncq_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ເຢຊູ ເດີງ ແອີງ ມູ່ ກາ ຣຍານ ແຕ ອັນ ເປາະ ກະ ອັນ; ເຈີ່ ອັນ ອາຕີ ໄລ່ ປາຍ: \"ໂອນ ເຍືາ ຊາງັດ! ໄຮ ຊັອຮ ປໍ ເມືອງ ເຢຣູຊາເລັມ. ແອີດ ຕຶ່ງ ເມືອງ ກັອຍ ແກີດ ຣາປຍາຍ໌ ກູ່ ຣາມຶ່ຮ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ ຄຽນ ເຈີ່ ແຕ ກອນ ເຢືາງ ແກີດ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ເນົ່າ ມ່ອບ ອັນ ແຕີ່ອ໌ ປໍ ອາຕີ ກວາຍ ຕາ ແກີນ ກວາຍ ອິດຊະຣາເອລ. ໄລ່ ກັອຍ ອາເຢ່ ພາມາດ ອັນ, ເວ່ນ ອັນ, ກະ ກູຈົຮ ໂຈະ ຕຶ່ງ ຈະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ໄລ່ ໄປຣ່ຮ ອັນ, ກະ ກາຈີດ ຕັຮ ອັນ. ມາ ແຕີ່ອ໌ ຕາໄງ ໄປ ອັນ ເບີນ ອາມົ່ງ ລັ່ຮ.\" ");
INSERT INTO ncq_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ມາ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ຕາ ເບີນ ຊາປຸ່ຮ ອຶນເຕົ່າ ແຕ ປັຣນາຍ ໄນ່, ຍ່ອນ ປັຣນາຍ ກັອຍ ປາໂຕ່ະ ແກຣ່ະ ລາລື່. ນ່ະກັອຍ ໄລ່ ຕາ ເບີນ ດັງ ແຈງ ແຕ ເຢຊູ ອາຕີ ນ່ະກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ພໍກາ ເຢຊູ ແຕີ່ອ໌ ແຈ່ະ ເມືອງ ເຢຣີໂກ, ເບີນ ມານະ ກວາຍ ຊູດ ມັ່ດ ແອີດ ຊູແຊອ໌ ຕຶ່ງ ປຶ່ຮ ຣານາ. ");
INSERT INTO ncq_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ບັອງ ກາ ອັນ ຊັອງ ກວາຍ ກຼຶ່ງ ເປາະ ຊາລັຮ ແຈ່ະ ອັນ, ອັນ ຕາແບີບ ປາຍ: \"ອຶນເຕົ່າ ເຍືາ ຕະ ໂຮຮີວ?\" ");
INSERT INTO ncq_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ມັຮ ກວາຍ ກັອຍ ຕາແອີຍ ອັນ ປາຍ: \"ເບີນ ເຢຊູ ແຕີ່ອ໌ ແຕ ວີ່ລ ນາຊາເຣັດ ເປາະ ຊາລັຮ ແຈ່ະ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ນ່ະກັອຍ ກວາຍ ຊູດ ມັ່ດ ກັອຍ ກູອ໌ ເຣ່ງ ລາລື່ ປາຍ: \"ເອີ ເຢຊູ ແຕ ຈຸ່ມເຈືອ ດາວິດ ເອີຍ! ແຊອ໌ ໄມ່ ອາໂຢ່ະ ຕະ ເກົາ ແຮີ.\" ");
INSERT INTO ncq_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ກວາຍ ກາ ເປາະ ຕຶ່ງ ຣານາ ກັອຍ ກາແອັຮ ອັນ ປາຍ: \"ໄມ່ ອຶນໂຈຍ ຕະ ແບອ໌!\" ມາ ອັນ ປາຍ ເຣ່ງ ລາລື່ ແອັນ: \"ເອີ ເຍືາ ແຕ ຈຸ່ມເຈືອ ດາວິດ ເອີຍ! ແຊອ໌ ໄມ່ ອາໂຢ່ະ ຕະ ເກົາ ແຮີ.\" ");
INSERT INTO ncq_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ເຢຊູ ຕາງິ່ດ, ກະ ອັນ ແປຣີ ໂອນ ເນົ່າ ເດີງ ກວາຍ ຊູດ ມັ່ດ ກັອຍ ແຕີ່ອ໌ ປໍ ອັນ. ພໍກາ ອັນ ແຕີ່ອ໌, ເຢຊູ ຕາແບີບ ອັນ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","\"ອຶນເຕົ່າ ໄມ່ ໂອນ ເກົາ ຈ່ອຍ?\" ກວາຍ ຊູດ ມັ່ດ ກັອຍ ຕາແອີຍ ລັ່ຮ: \"ອຶນເຈົາ ເອີຍ! ເກົາ ຢໍອ໌ ອີ ບຣາງ ເຮີມ ເຕ່!\" ");
INSERT INTO ncq_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ເຈີ່ ເຢຊູ ອາຕີ ລັ່ຮ ອັນ ປາຍ: \"ມັ່ດ ໄມ່ ແກີດ ບຣາງ! ຍ່ອນ ໄມ່ ຊາອຳ ມັ່ດ ໄມ່ ເຕ່ອ໌ ບຣາງ ລັ່ຮ.\" ");
INSERT INTO ncq_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ບັອງ ກາ ກັອຍ ແຕິ່ ມັ່ດ ກວາຍ ກັອຍ ແກີດ ປັ່ງ. ເຈີ່ ອັນ ປວາຍ ເຢຊູ ກະ ຍ່ອງ ເຢືາງ ເຈົາຣາຊີ. ພໍກາ ກວາຍ ກຼຶ່ງ ເຮີມ ຣານະ ກັອຍ, ໄລ່ ຍ່ອງ ເຕ່ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ເຢຊູ ເປາະ ຕຶ່ງ ຣານາ ມູ່ດ ຕຶ່ງ ເມືອງ ເຢຣີໂກ. ");
INSERT INTO ncq_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ແອີດ ຕຶ່ງ ເມືອງ ກັອຍ ເບີນ ມານະ, ຣາມຶ່ຮ ຊັກຄາຍ. ອັນ ແກີດ ຊົດ ກວາຍ ອີດ ປຣະ ປາຊີ, ກະ ອັນ ລາ ຊຸ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ອັນ ຢໍອ໌ ອີ ເຮີມ ເຢຊູ ລາ ເນົ່າ. ມາ ອັນ ລາ ກວາຍ ແຈລ. ອັນ ຕາ ເຕ່ອ໌ ເຮີມ ເຢຊູ, ຍ່ອນ ກວາຍ ກຼຶ່ງ ກັອຍ ກາຕັງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ນ່ະກັອຍ ອັນ ຕາລຸ່ຮ ເປາະ ອຶນໂຍ່ງ ກວາຍ ກຼຶ່ງ ກັອຍ. ເຈີ່ ອັນ ຊັອຮ ຕຶ່ງ ກັ່ລ ລາວັ່ຮ ຢໍອ໌ ອີ ເຮີມ ເຢຊູ ເປາະ ຊາລັຮ ແຈ່ະ ອາລ່ອງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ບັອງ ກາ ເຢຊູ ແຕີ່ອ໌ ປໍ ກັ່ລ ອາລ່ອງ ກັອຍ, ອັນ ຕາງ່ອນ ອາຊັອຮ ປໍ ອາລ່ອງ, ກະ ອັນ ກູອ໌ ຊັກຄາຍ ປາຍ: \"ຊັກຄາຍ ເອີຍ! ໄມ່ ແຊງ ໄວ່, ຍ່ອນ ຕາໄງ ໄນ່ ເກົາ ອີ ເປາະ ປໍ ດຸງ ໄມ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ນ່ະກັອຍ ຊັກຄາຍ ແຊງ ແຕິ່, ກະ ອັນ ຣັ່ບ ເຢຊູ ຣໍ່ອ໌ ບູຍ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ມັຮ ກວາຍ ການໍ່ອ໌ ກັອຍ ເຮີມ ນ່ະກັອຍ, ກູ່ ນະ ໄລ່ ບູແບະ ບູບື່ບ ປາຍ: \"ກວາຍ ໄນ່ ເປາະ ຈີຈາ ປໍ ດຸງ ກວາຍ ໂລ່ຍຮ.\" ");
INSERT INTO ncq_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ມາ ຊັກຄາຍ, ອັນ ຕາຢຶ່ງ ຢັ່ຮ ເມືາງ ມັຮ ກວາຍ ກະ ອາຕີ ເຢຊູ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ມັຮ ມູ່ນ ເກົາ, ເກົາ ອີດ ຕາດີ່ ຈ່ອຍ ມັຮ ກວາຍ ກາດີດ. ກະ ຄັນ ເບີນ ກວາຍ ອາແລ່ະ ມາ ເກົາ ໂລ່ບ ອັນ ມວຍ ປູ່ດ, ຊານໍ່ ເກົາ ກູລັຮ ລັ່ຮ ອັນ ປູນ ປູ່ດ ແອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ເຢຊູ ອາຕີ ລັ່ຮ ອັນ ປາຍ: \"ຕາໄງ ໄນ່ ເຢືາງ ເຈົາຣາຊີ ຈ່ອຍ ອາມົ່ງ ດຸງຊູ ໄນ່, ຍ່ອນ ກວາຍ ໄນ່ ແຕ ຈຸ່ມເຈືອ ອັບຣາຮາມ ມູເຈິງ ໄຮ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ໄກຣ ລາລື່ ເກົາ, ກອນ ເຢືາງ ແກີດ ກວາຍ, ແຕີ່ອ໌ ປໍ ໄນ່ ຢໍອ໌ ອີ ຈໍ່ອ໌ ກະ ຈ່ອຍ ອາມົ່ງ ໄລ່ ກາ ແກຼິ ຣານາ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ແວັດ ກັອຍ, ເຢຊູ ອາຕີ ປັຣນາຍ ຊາກຳ ໂຈະ ກວາຍ ກາ ຊັອງ ອັນ ປາຍ ນ່ະກັອຍ. ອັນ ແຕີ່ອ໌ ແຈ່ະ ເມືອງ ເຢຣູຊາເລັມ ເຈີ່, ກະ ກວາຍ ການໍ່ອ໌ ຄຶ່ດ ຕຶ່ງ ຣາງຶ່ຮ ໄລ່ ແຈ່ະ ອີ ແຕີ່ອ໌ ເຈີ່ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ ຕຶ່ງ ກຣວາງ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ເຈີ່ ເຢຊູ ປາຍ: \"ເບີນ ມານະ ກວາຍ ປື່ດ ເປາະ ປໍ ກຣວາງ ການໍ່ອ໌ ໂອນ ມັຮ ກວາຍ ຊົດ ຕຶ່ງ ກຣວາງ ກັອຍ ຈົຮ ໂອນ ອັນ ແກີດ ເຕືາວ ປັຣເຍືາ ຕຶ່ງ ກຣວາງ ອັນ ເບີມ. ແວັດ ກັອຍ ອັນ ອີ ເຈົາ ລັ່ຮ ປໍ ກຣວາງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ແຕ ອຶນໂຍ່ງ ອັນ ເປາະ, ອັນ ກູອ໌ ມວຍ ຈິ່ດ ນະ ກວາຍ ກາ ຕະ ຣານະ ໂອນ ອັນ. ອັນ ໂອນ ມານະ ມູ ແນນ ປຣະ, ກະ ອັນ ປາຕັບ ປາຍ: 'ເຍືາ ຕະ ນານ່ະ ໂອນ ປຣະ ໄນ່ ແກີດ ເບີນ ກຳໄລ ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ເກົາ ເຈົາ ລັ່ຮ.' ");
INSERT INTO ncq_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ມັຮ ກອນແຊມ ແອີດ ຕຶ່ງ ກຣວາງ ອັນ, ໄລ່ ຊາອັຣ ອັນ ກະ ຕາ ແອອ໌ ອີ ໂອນ ອັນ ແກີດ ເຕືາວ ປັຣເຍືາ ໄລ່. ນ່ະກັອຍ ໄລ່ ແປຣີ ເນົ່າ ເປາະ ອາຕີ ລັ່ຮ ກວາຍ ຊົດ ປື່ດ ລາລື່ ກາ ອີ ຈົຮ ອັນ ປາຍ: 'ຮິ ຕາ ແອອ໌ ອີ ໂອນ ອັນ ໄນ່ ແກີດ ຊົດ ຮິ.' ");
INSERT INTO ncq_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","ມາ ກວາຍ ກັອຍ ແກີດ ເຕືາວ ປັຣເຍືາ, ກະ ອັນ ເຈົາ ລັ່ຮ ປໍ ກຣວາງ ອັນ. ອັນ ກູອ໌ ລັ່ຮ ມັຮ ກວາຍ ກາ ຕະ ຣານະ ອັນ, ໄລ່ ກາ ຣັ່ບ ປຣະ ແຕ ອັນ, ຢໍອ໌ ອີ ດັງ ມາແລ່ະ ໄລ່ ເບີນ ກຳໄລ ແຕ ປຣະ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ອັນ ກາ ອຶນໂຍ່ງ ແຕີ່ອ໌ ປາຍ: 'ອຶນເຈົາ ເອີຍ! ເກົາ ເບີນ ກຳໄລ ມວຍ ຈິ່ດ ແນນ ແອັນ ແຕ ມວຍ ແນນ ອຶນເຈົາ ໂອນ ເກົາ.' ");
INSERT INTO ncq_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ອັນ ກາ ຊົດ ກັອຍ ປາຍ: 'ອໍ ລາລື່ ໄມ່ ຕະ! ໄມ່ ລາ ກວາຍ ອໍ ຕະ ຣານະ ເກົາ! ຍ່ອນ ໄມ່ ຕະ ອໍ ກະ ບີ່ອ໌ ປຣະ ໄນ່, ນ່ະກັອຍ ເກົາ ຈົຮ ໄມ່ ຕະ ຊົດ ຕຶ່ງ ມວຍ ຈິ່ດ ເມືອງ.' ");
INSERT INTO ncq_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ເບີນ ມານະ ແອັນ ແຕີ່ອ໌ ປໍ ກວາຍ ຊົດ ກະ ປາຍ: 'ອຶນເຈົາ ເອີຍ! ເກົາ ເບີນ ກຳໄລ ເຊີງ ແນນ ແອັນ ແຕ ມວຍ ແນນ ອຶນເຈົາ ໂອນ ເກົາ.' ");
INSERT INTO ncq_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ກວາຍ ຊົດ ກັອຍ ປາຍ ໂຈະ ກວາຍ ກັອຍ: ເກົາ ຈົຮ ໄມ່ ໂອນ ຕະ ຊົດ ຕຶ່ງ ເຊີງ ເມືອງ.' ");
INSERT INTO ncq_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ກະ ມານະ ແອັນ ແຕີ່ອ໌ ປໍ ກວາຍ ຊົດ, ອັນ ປາຍ: 'ອຶນເຈົາ ເອີຍ! ໄນ່ ລາ ປຣະ ແນນ ອຶນເຈົາ ໂອນ ເກົາ. ເກົາ ປຸ່ງ ດໍອ໌ ປຣະ ໄນ່ ຕຶ່ງ ອາຣິ. ");
INSERT INTO ncq_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ເກົາ ອຶງກັອຮ, ຍ່ອນ ເກົາ ດັງ ໄມ່ ລາ ກວາຍ ກັ່ອງ ຣາງຶ່ຮ. ໄມ່ ຕາ ເບີນ ດໍອ໌, ມາ ໄມ່ ອີ ເບີນ. ໄມ່ ຕາ ເບີນ ຈັ່ດ, ມາ ໄມ່ ອີ ຊອດ ເຕ່.' ");
INSERT INTO ncq_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ກວາຍ ຊົດ ກັອຍ ປາຍ ໂຈະ ກວາຍ ກັອຍ: 'ໄມ່ ລາ ກວາຍ ກາ ຕະ ຣານະ ເກົາ ໄລ່ ລາລື່! ປັຣນາຍ ໄມ່ ຕິ ລັ່ຮ ໄມ່ ເບີມ. ໄມ່ ດັງ ເຈີ່ ເກົາ ລາ ກວາຍ ກັ່ອງ. ກະ ໄມ່ ດັງ ເຈີ່ ເກົາ ຕາ ເບີນ ດໍອ໌, ມາ ເກົາ ອີ ເບີນ. ກະ ເກົາ ຕາ ເບີນ ຈັ່ດ, ມາ ເກົາ ອີ ຊອດ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ຄັນ ນ່ະກັອຍ, ຄາອ໌ ໄມ່ ດໍອ໌ ປຣະ ເກົາ ຕຶ່ງ ທະນາຄານ. ເຈີ່ ແຕີ່ອ໌ ຕາໄງ ເກົາ ເຈົາ ລັ່ຮ, ເກົາ ເບີນ ປຣະ ກັອຍ ກະ ເບີນ ກຳໄລ ແຮີ.' ");
INSERT INTO ncq_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ແວັດ ກັອຍ, ກວາຍ ຊົດ ກັອຍ ອາຕີ ມັຮ ກວາຍ ກາ ແອີດ ອຶມແປຣ ກັອຍ ປາຍ: 'ອີດ ລັ່ຮ ມວຍ ແນນ ປຣະ ກັອຍ ແຕ ກວາຍ ໄນ່. ເຈີ່ ໂອນ ປໍ ອັນ ກາ ເບີນ ມວຍ ຈິ່ດ ແນນ ກັອຍ ແອັນ.' ");
INSERT INTO ncq_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ມາ ມັຮ ກວາຍ ກັອຍ ອາຕີ ກວາຍ ຊົດ ກັອຍ ປາຍ: 'ອຶນເຈົາ ເອີຍ! ກວາຍ ກັອຍ ເບີນ ມວຍ ຈິ່ດ ແນນ ເຈີ່!' ");
INSERT INTO ncq_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ມາ ກວາຍ ຊົດ ກັອຍ ຕາແອີຍ ປາຍ: 'ອັນ ກາ ເບີນ ຊາອຶ່ຍ, ແຮງ ເກົາ ໂອນ ອັນ ເບີນ ຊາອຶ່ຍ ລາລື່ ແອັນ. ມາ ກວາຍ ກາ ຕາ ເບີນ ເບີນ, ແຮງ ເກົາ ອີດ ລັ່ຮ ອຶນແຍ່ະ ແຕ ກວາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ມາ ມັຮ ໄລ່ ກາ ຕາ ແອອ໌ ອີ ໂອນ ເກົາ ແກີດ ເຕືາວ ປັຣເຍືາ ໄລ່, ເດີງ ໄລ່ ໂອນ ແຕີ່ອ໌ ປໍ ໄນ່ ກະ ກາຈີດ ຕັຮ ຊັອງ ໄລ່ ຢັ່ຮ ເມືາງ ເກົາ!'\" ");
INSERT INTO ncq_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ອັນ ຣາໄລ່ອ໌ ເປາະ ອຶນໂຍ່ງ ມັຮ ກວາຍ ກາ ເປາະ ປໍ ເມືອງ ເຢຣູຊາເລັມ. ");
INSERT INTO ncq_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ແຈ່ະ ອັນ ອີ ແຕີ່ອ໌ ປໍ ວີ່ລ ເບັດພາເຄ ກະ ວີ່ລ ເບັດທານີ, ປໍ ອຶນຕຸ ກົຮ ອາໂປ່ນ, ອັນ ແປຣີ ບາຣ ນະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ເປາະ ອຶນໂຍ່ງ. ");
INSERT INTO ncq_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ອັນ ປາຕັບ ໄລ່ ບາຣ ນະ ກັອຍ ປາຍ: \"ເຍືາ ເປາະ ປໍ ວີ່ລ ໄນ່. ພໍກາ ເຍືາ ມູ່ດ ປໍ ກັອຍ, ເຍືາ ຣາມົຮ ມານຳ ອາແຊັຮ ແຈລ ກາ ເນົ່າ ຊັດ ດໍອ໌ ປໍ ກັອຍ. ອາແຊັຮ ແຈລ ກັອຍ ຕາ ເບີນ ອາແລ່ະ ຈິ່ຮ ຢວາຮ. ເຍືາ ອາແລັ່ຮ ອັນ ແຕ ກັອຍ; ເຈີ່ ເດີງ ປໍ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ຄັນ ເບີນ ອາແລ່ະ ຕາແບີບ ເຍືາ ປາຍ: 'ອຶນເຕົ່າ ເຍືາ ອາແລັ່ຮ ຕະ ອາແຊັຮ ໄນ່?' ໂອນ ເຍືາ ຕາແອີຍ ໂຈະ ໄລ່ ປາຍ: 'ອຶນເຈົາ ໄຮ ອີ ເມືານ ອາແຊັຮ ໄນ່.'\" ");
INSERT INTO ncq_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ເຈີ່ ໄລ່ ບາຣ ນະ ກັອຍ ເປາະ, ກະ ໄລ່ ເຮີມ ປຍາຍ໌ ມັຮ ປັຣນາຍ ເຢຊູ ອາຕີ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ບັອງ ກາ ໄລ່ ອາແລັ່ຮ ອາແຊັຮ ແຈລ ກັອຍ, ກວາຍ ຕາລາ ອາແຊັຮ ກັອຍ ຕາແບີບ ໄລ່ ປາຍ: \"ອຶນເຕົ່າ ເຍືາ ອາແລັ່ຮ ຕະ ອາແຊັຮ ໄນ່?\" ");
INSERT INTO ncq_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ໄລ່ ບາຣ ນະ ຕາແອີຍ ປາຍ: \"ອຶນເຈົາ ໄຮ ອີ ເມືານ ອາແຊັຮ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ເຈີ່ ໄລ່ ເດີງ ອາແຊັຮ ແຈລ ກັອຍ ໂອນ ປໍ ເຢຊູ. ແວັດ ກັອຍ ໄລ່ ອີດ ຕຳປັອກ; ເຈີ່ ໄລ່ ເຊີນ ຕຶ່ງ ກຣັອງ ອາແຊັຮ ກັອຍ. ເຈີ່ ໄລ່ ໂຕຣງ ອາຊັອຮ ເຢຊູ ໂອນ ຈິ່ຮ ຕຶ່ງ ກຣັອງ ອາແຊັຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ບັອງ ກາ ອັນ ເປາະ, ກວາຍ ເຊີນ ຕຳປັອກ ຕຶ່ງ ຣານາ ໂອນ ອັນ ຊາເຕືາຍ໌. ");
INSERT INTO ncq_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ພໍກາ ອັນ ແຕີ່ອ໌ ແຈ່ະ ເມືອງ ເຢຣູຊາເລັມ, ປໍ ອຶນຕຸ ຣານາ ແຊງ ແຕ ກົຮ ອາໂປ່ນ, ກຼຶ່ງ ລາລື່ ກວາຍ ກາ ຕາປູ່ນ ອັນ ໄລ່ ຕຣັ່ອຮ ຕຣຍາວ. ເຣ່ງ ລາລື່ ໄລ່ ຊາແອີນ ກະ ຍ່ອງ ເຢືາງ ເຈົາຣາຊີ ມັຮ ຣາມຶ່ຮ ຕາ ເກີ່ຍ ເຮີມ ກາ ໄລ່ ເຮີມ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ໄລ່ ປາຍ: \"ແຊອ໌ ເຢືາງ ເຈົາຣາຊີ ອາປັອງ ບຸ່ນ ໂອນ ເຕືາວ ປັຣເຍືາ ກາ ແຕີ່ອ໌ ປໍ ໄນ່ ຍ່ອນ ເຢືາງ ເຈົາຣາຊີ ແປຣີ. ແຊອ໌ ອຽນ ອໍ ແຕີ່ອ໌ ປໍ ມັນລັ່ອງ ກະ ອຳນາດ ອາງອື່ຣ ແຕີ່ອ໌ ປໍ ເຢືາງ ເຈົາຣາຊີ ກາ ປື່ດ ກາເລີຍ ອຶນແຍ່ະ ແຕ ການໍ່ອ໌.\" ");
INSERT INTO ncq_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ຕຶ່ງ ຈຸ່ມ ກວາຍ ກຼຶ່ງ ກັອຍ ເບີນ ກວາຍ ພາຣີຊາຍ ແຮີ. ໄລ່ ກັອຍ ປາຍ ໂຈະ ເຢຊູ: \"ອາຈານ ເອີຍ! ອຶງເຄາະ ອາຈານ ກາແອັຮ ກວາຍ ກາ ຕາປູ່ນ ອາຈານ ອຶນໂຈຍ ໂອນ ໄລ່ ຕຣຍາວ ນັ່ອງ.\" ");
INSERT INTO ncq_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ມາ ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ຄັນ ໄລ່ ໄນ່ ຕາ ເບີນ ຕຣຍາວ ນ່ະກັອຍ, ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ເຢືາງ ເຈົາຣາຊີ ໂອນ ຕາເມົາ ແອັນ ຕຣຍາວ.\" ");
INSERT INTO ncq_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ພໍກາ ເຢຊູ ແຈ່ະ ອີ ແຕີ່ອ໌ ປໍ ເມືອງ ເຢຣູຊາເລັມ, ອັນ ຕາງ່ອນ ປໍ ເມືອງ ກັອຍ, ເຈີ່ ອັນ ເຍືາມ. ");
INSERT INTO ncq_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ກະ ອັນ ປາຍ: \"ຕາໄງ ໄນ່ ເກົາ ຢໍອ໌ ລາລື່ ມັຮ ເຍືາ ກາ ແອີດ ຕຶ່ງ ເມືອງ ໄນ່ ດັງ ອຶງເຄາະ ເຍືາ ຕະ ນານ່ະ ໂອນ ເຕ່ອ໌ ເຍືາ ແອີດ ອຽນ ອໍ. ມາ ຊານໍ່ ເຍືາ ຕາ ເຕ່ອ໌ ຊາປຸ່ຮ ແຕ ປັຣນາຍ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ປັຣແນີ ມັນເຕຣືາ ແຕີ່ອ໌ ຕາໄງ ໄລ່ ກາ ອີ ກາຈີດ ເຍືາ, ໄລ່ ປິ່ ປຣຸ່ງ ຕະ ຄັນ ຈວບ ອຶນແຍ່ະ ອຶມແປຣ ເມືອງ ເຍືາ, ກະ ໄລ່ ຕາ ໂອນ ເຍືາ ລັ່ອຮ ແຕ ເມືອງ. ໄລ່ ກາຕັງ ດໍອ໌ ກູ່ ຣານາ. ");
INSERT INTO ncq_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ໄລ່ ກາຈີດ ຕັຮ ກູ່ ນະ ເຍືາ ກະ ຕາລຸຮ ອຶນແຍ່ະ ເມືອງ ເຍືາ. ໄລ່ ຕະ ໂອນ ຕາ ເບີນ ຣາກຼັຮ ມວຍ ຣາມຶ່ຮ ອຶນເຕົ່າ ຕຶ່ງ ເມືອງ ເຍືາ, ຍ່ອນ ເຍືາ ຕາ ເບີນ ຣາບູລ ແຕ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ແຕີ່ອ໌ ຈ່ອຍ ອາມົ່ງ ເຍືາ!\" ");
INSERT INTO ncq_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ເຢຊູ ມູ່ດ ຕຶ່ງ ຊັງອາຣ ດຸງ ຊາງ ປື່ດ, ເຈີ່ ອັນ ຕູ່ຍຮ ອາລັ່ອຮ ໄລ່ ກາ ຈິແຈີງ ຕຶ່ງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ອັນ ອາຕີ ໄລ່ ປາຍ: \"ຕຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ຄຽນ ປາຕັບ ດໍອ໌ ປາຍ: 'ເນົ່າ ດໍອ໌ ດຸງ ເກົາ ລາ ດຸງ ໂອນ ເກົາແຊອ໌.' ມາ ເຍືາ ຕະ ດຸງ ໄນ່ ແກີດ ນ່ະ ກື່ບ ໂອນ ກວາຍ ຊາແວງ ມູ່ດ ໂຕ່ະ!\" ");
INSERT INTO ncq_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ກູ່ ຣາໄງ ເຢຊູ ອາຕີ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ ກັອຍ. ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ກວາຍ ອາຕີ ຄານອດ, ກະ ກວາຍ ຊົດ ການໍ່ອ໌ ແຮີ, ອຶນແຍ່ະ ນະ ໄລ່ ກັອຍ ຈໍ່ອ໌ ຣານາ ອີ ກາຈີດ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ມາ ໄລ່ ຕາ ດັງ ອີ ຕະ ນານ່ະ ອີ ກາຈີດ ອັນ, ຍ່ອນ ມັຮ ກວາຍ ການໍ່ອ໌ ໄລ່ ຢໍອ໌ ອີ ຊາງັດ ລາລື່ ປັຣນາຍ ເຢຊູ ອາຕີ. ");
INSERT INTO ncq_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ເບີນ ມວຍ ຕາໄງ ເຢຊູ ອາຕີ ປັຣນາຍ ອໍ ແຕ ເຢືາງ ເຈົາຣາຊີ ໂອນ ກອນແຊມ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ. ບັອງ ກາ ກັອຍ ເບີນ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ກວາຍ ອາຕີ ຄານອດ, ກະ ກວາຍ ເທົາແກ ຈຸ່ມເຈືອ, ອຶນແຍ່ະ ໄລ່ ກັອຍ ແຕີ່ອ໌ ປໍ ອັນ ກະ ຕາແບີບ ອັນ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","\"ໄມ່ ເບີນ ອຳນາດ ແຕ ແລ່ະ ກາ ໄມ່ ຕະ ຣານະ ໄນ່? ເນົ່າ ໂອນ ໄມ່ ເບີນ ອຳນາດ ກັອຍ?\" ");
INSERT INTO ncq_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ເກົາ ຢໍອ໌ ອີ ຕາແບີບ ເຍືາ ມວຍ ຣາມຶ່ຮ ອຶນໂຍ່ງ. ແຊອ໌ ເຍືາ ຕາແອີຍ ໂອນ ເກົາ: ");
INSERT INTO ncq_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ເນົ່າ ໂອນ ອຳນາດ ປໍ ໂຢຮັນ ກາ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌? ອຳນາດ ກັອຍ ແຕີ່ອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ ມາ ແຕີ່ອ໌ ແຕ ກວາຍ ຊັອງ?\" ");
INSERT INTO ncq_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ໄລ່ ມານະ ຊັຣຮົງ ມານະ ປາຍ: \"ຄັນ ໄຮ ຕາແອີຍ ອັນ ປາຍ: 'ຣານະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໄນ່ ແຕີ່ອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ,' ອຶງກັອຮ ອັນ ຕາແບີບ ລັ່ຮ ໄຮ ປາຍ: 'ຄັນ ນ່ະກັອຍ, ນານ່ະ ເຍືາ ຕາ ເບີນ ຊາອຳ ໂຢຮັນ?' ");
INSERT INTO ncq_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ມາ ຄັນ ໄຮ ຕາແອີຍ ອັນ ປາຍ: 'ຣານະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໄນ່ ຈຸງ ແຕີ່ອ໌ ແຕ ກວາຍ ຊັອງ,' ໄຮ ອຶງກັອຮ ກອນແຊມ ແກຼງ ຕາເມົາ ໂຈະ ໄຮ, ຍ່ອນ ໄລ່ ຊາອຳ ໂຢຮັນ ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ນ່ະກັອຍ ໄລ່ ຕາແອີຍ ເຢຊູ ປາຍ: \"ຮິ ຕາ ດັງ.\" ");
INSERT INTO ncq_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ເຈີ່ ເຢຊູ ຕາແອີຍ ລັ່ຮ ໄລ່ ປາຍ: \"ເຈີ່ ເກົາ ຕາ ເບີນ ອາຕີ ເຕ່ ໂອນ ເຍືາ ດັງ ເນົ່າ ກາ ໂອນ ເກົາ ເບີນ ອຳນາດ ຕະ ມັຮ ຣານະ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ເຢຊູ ອາຕີ ມັຮ ກວາຍ ກຼຶ່ງ ກັອຍ ແຕ ປັຣນາຍ ຊາກຳ ປາຍ: \"ເບີນ ຣາເລົາ ມານະ ຈົຮ ວັ່ຣ ອາງຸ່ນ ຕຶ່ງ ຊວນ. ອັນ ໂອນ ກວາຍ ການໍ່ອ໌ ເມືານ ຕະ ຊວນ ກັອຍ. ໄລ່ ປຣ່ອມ ຕາລາ ປຣ່ອມ ອຶມແປອ໌ ປາໄລ ກັອຍ. ເຈີ່ ອັນ ເປາະ ກຣວາງ ການໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ແຕີ່ອ໌ ປາເນ່ນ ປາໄລ ກັອຍ ຈີນ, ອຶນເຈົາ ກັອຍ ແປຣີ ກວາຍ ຊູລ ແຕີ່ອ໌ ປໍ ໄລ່ ກາ ເມືານ ຕະ ຊວນ ອັນ. ອັນ ໂອນ ຊູລ ກັອຍ ອີດ ປູ່ດ ອັນ ແຕ ຊວນ ກັອຍ. ມາ ໄລ່ ກາ ຕູຕະ ຣານະ ຕຶ່ງ ຊວນ ກັອຍ, ໄລ່ ປຍາຍຮ ກວາຍ ຊູລ ກັອຍ, ກະ ໄລ່ ຕູ່ຍຮ ໂອນ ອັນ ເຈົາ ລັ່ຮ ແອີງ ຈະ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ນ່ະກັອຍ ອຶນເຈົາ ກັອຍ ແປຣີ ຊູລ ການໍ່ອ໌ ແອັນ ເປາະ ປໍ ຊວນ ກັອຍ. ມາ ກວາຍ ກາ ເມືານ ຕະ ຊວນ ກັອຍ, ໄລ່ ປຍາຍຮ ຊາ ກວາຍ ຊູລ ກັອຍ, ກະ ໄລ່ ເວ່ນ ພາມາດ ອັນ; ເຈີ່ ໄລ່ ຕູ່ຍຮ ໂອນ ອັນ ເຈົາ ແອີງ ຈະ ຊາ. ");
INSERT INTO ncq_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ແວັດ ກັອຍ ອຶນເຈົາ ແປຣີ ຊູລ ມານະ ແອັນ ເປາະ. ມາ ກວາຍ ກາ ເມືານ ຕະ ຊວນ ກັອຍ, ໄລ່ ຕະ ເບິ ອຶນແຍ່ະ ຊູລ ກັອຍ, ກະ ໄລ່ ຕູ່ຍຮ ອາລັ່ອຮ ອັນ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ເຈີ່ ອຶນເຈົາ ຊວນ ກັອຍ ຄຶ່ດ ປາຍ: 'ນານ່ະ ແອັນ ເກົາ ອີ ຕະ? ເກົາ ແປຣີ ໂອນ ກອນ ຣາເລົາ ກາ ເກົາ ປາຊິ ລາລື່ ແອັນ ໂອນ ເປາະ. ໄກຣ ລາລື່ ໄລ່ ກັອຍ ຢຳນັ່ບ ອັນ.' ");
INSERT INTO ncq_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ມາ ແຕີ່ອ໌ ໄລ່ ກາ ເມືານ ຕະ ຊວນ ກັອຍ ເຮີມ ກອນ ຣາເລົາ ອຶນເຈົາ ຊວນ, ໄລ່ ມານະ ອາຕີ ມານະ ປາຍ: 'ໄນ່ ລາ ກອນ ອຶນເຈົາ ກາ ຕາລາ ຊວນ. ໄຮ! ໄຮ ກາຈີດ ຕັຮ ອັນ! ເຈີ່ ອຶນແຍ່ະ ມູ່ນ ອັນ ໄຮ ແອັນ ເບີນ ຕາລາ!' ");
INSERT INTO ncq_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ເຈີ່ ໄລ່ ກາຕັ່ອງ ອາລັ່ອຮ ກອນ ອຶນເຈົາ ກັອຍ ແຕ ຊວນ, ກະ ໄລ່ ກາຈີດ ຕັຮ ອັນ. ເຈີ່! ນານ່ະ ອຶນເຈົາ ຊວນ ອີ ຕະ ໂຈະ ກວາຍ ກາ ເມືານ ຕະ ຊວນ ອັນ? ");
INSERT INTO ncq_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ອັນ ອີ ເປາະ ກາຈີດ ຕັຮ ອຶນແຍ່ະ ກວາຍ ກັອຍ, ກະ ອັນ ໂອນ ກວາຍ ການໍ່ອ໌ ແອັນ ເມືານ ຕະ ຊວນ ອັນ.\" ມັຮ ກວາຍ ກາ ຊັອງ ປັຣນາຍ ກັອຍ, ໄລ່ ປາຍ: \"ອຶນໂຈຍ ໂອນ ແກີດ ນ່ະກັອຍ!\" ");
INSERT INTO ncq_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ມາ ເຢຊູ ເນ່ ປໍ ໄລ່ ກະ ຕາແບີບ ປາຍ: \"ຄັນ ຕາ ເບີນ ນ່ະກັອຍ, ອຶນເຕົ່າ ຣານະ ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ປາຍ ແຕ ອຶມແບິ: 'ຕາເມົາ ກາ ກວາຍ ເຈືາງ ຕະ ດຸງ ຕາເວ່ງ ຕັຮ ເຈີ່, ມາ ເຢືາງ ເຈົາຣາຊີ ອີດ ຕາເມົາ ກັອຍ ດໍອ໌ ຕຶ່ງ ກູຈົ່ກ ຕະ ໂອນ ດຸງ ແກີດ ຈັບ.' ");
INSERT INTO ncq_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ກວາຍ ອາແລ່ະ ມາ ແດິມ ຕຶ່ງ ຕາເມົາ ກັອຍ, ອັນ ກູຈີດ ເລີ່ຍ. ມາ ຄັນ ຕາເມົາ ໄນ່ ຊາແລັຮ ໄກຣ ຕຶ່ງ ຈະ ກວາຍ, ກວາຍ ກັອຍ ເປຣັຍ ເລີ່ຍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ກະ ມູ່ ກາ ອາຕີ ຄານອດ ຈໍ່ອ໌ ຣານາ ອີ ໂກບ ແຕິ່ ເຢຊູ, ຍ່ອນ ໄລ່ ດັງ ເຢຊູ ອາຕີ ປັຣນາຍ ຊາກຳ ກັອຍ ແຕ ໄລ່. ມາ ໄລ່ ຕາ ຍັ່ນ, ຍ່ອນ ໄລ່ ອຶງກັອຮ ກອນແຊມ. ");
INSERT INTO ncq_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ມາ ໄລ່ ຕາຕ່ອຍ໌ ເລືອຍໆ ແຕ ເຢຊູ. ໄລ່ ແປຣີ ກວາຍ ການໍ່ອ໌ ເປາະ ຈໍ່ອ໌ ເນ່ ແຕ ອັນ. ກວາຍ ກັອຍ ຕະ ອຶນຕີ ອາໂລກ ປາຍ ໄລ່ ລາ ກວາຍ ມັນຕັ່ດ ອໍ, ມາ ໄລ່ ແຕີ່ອ໌ ປໍ ເຢຊູ ຢໍອ໌ ອີ ຈໍ່ອ໌ ຣາລິ່ຮ ແຕ ອັນ. ໄລ່ ຢໍອ໌ ອີ ໂກບ ອັນ ກະ ມ່ອບ ໂອນ ປໍ ອາຕີ ກວາຍ ຊົດ. ");
INSERT INTO ncq_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ມັຮ ກວາຍ ກາ ຈໍ່ອ໌ ເນ່ ກັອຍ ໄລ່ ຕາແບີບ ເຢຊູ ປາຍ: \"ອາຈານ ເອີຍ! ຮິ ດັງ ເຈີ່ ອາຈານ ອາຕີ ປັຣນາຍ ປຍາຍ໌ ຊັງໄກຣ ອໍ. ກະ ຢັ່ຮ ເມືາງ ອາຈານ, ອຶນແຍ່ະ ມັຮ ກວາຍ ແກີດ ລີ ຣາລີ ອຶນແຍ່ະ. ອາຈານ ອາຕີ ຣານະ ເຢືາງ ເຈົາຣາຊີ ປຍາຍ໌ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ນ່ະກັອຍ ຮິ ແຊອ໌ ອາຈານ ອາຕີ ໂອນ ຮິ, ອຶນເຕົ່າ ອາຈານ ຄຶ່ດ, ປຍາຍ໌ ມາ ຕາ ເບີນ ໄຮ ອຶງເຄາະ ມ່ອບ ປຣະ ປາຊີ ໂອນ ເຕືາວ ປັຣເຍືາ ໂຣມ?\" ");
INSERT INTO ncq_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ມາ ເຢຊູ ດັງ ເຈີ່ ໄລ່ ເບີນ ຣາງຶ່ຮ ໂກ່ະ; ເຈີ່ ອັນ ປາຍ ໂຈະ ໄລ່: ");
INSERT INTO ncq_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","\"ເຍືາ ໂອນ ເກົາ ເນ່ ມວຍ ກຼອງ ປຣະ! ກຼອງ ປຣະ ໄນ່ ເບີນ ຣູ່ບ ເນົ່າ ກະ ຣາມຶ່ຮ ເນົ່າ ຄຽນ ດໍອ໌ ຕຶ່ງ ປຣະ ໄນ່?\" ");
INSERT INTO ncq_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ໄລ່ ກັອຍ ຕາແອີຍ ປາຍ: \"ເຕືາວ ປັຣເຍືາ ໂຣມ.\" ນ່ະກັອຍ ເຢຊູ ອາຕີ ລັ່ຮ ໄລ່ ປາຍ: \"ເກຣີ່ງ ເຕືາວ ປັຣເຍືາ ໂຣມ, ອຶງເຄາະ ເຍືາ ກູລັຮ ລັ່ຮ ໂອນ ເຕືາວ ປັຣເຍືາ ໂຣມ, ກະ ເກຣີ່ງ ເຢືາງ ເຈົາຣາຊີ, ອຶງເຄາະ ເຍືາ ກູລັຮ ລັ່ຮ ໂອນ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ບັອງ ກາ ເຢຊູ ອາຕີ ຢັ່ຮ ເມືາງ ກວາຍ ກຼຶ່ງ ກັອຍ, ໄລ່ ກາ ລ່ອງ ເຢຊູ ຕາ ເບີນ ເຮີມ ໂລ່ຍຮ ອຶນເຕົ່າ ແຕ ປັຣນາຍ ເຢຊູ ອາຕີ. ກະ ໄລ່ ຊັອງ ງຶ່ດ ເຢຊູ ຕາແອີຍ ນ່ະກັອຍ. ເຈີ່ ໄລ່ ຕາ ເບີນ ຕະ ແບອ໌ ອຶນເຕົ່າ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ເບີນ ກວາຍ ແຕ ຈຸ່ມ ຊາດູກາຍ ແຕີ່ອ໌ ປໍ ເຢຊູ. ໄລ່ ກັອຍ ປາຍ ກວາຍ ກາ ກູຈີດ ເຈີ່ ຕາ ເຕ່ອ໌ ອາມົ່ງ ລັ່ຮ. ໄລ່ ອາຕີ ເຢຊູ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","\"ອາຈານ ເອີຍ! ໂມເຊ ຄຽນ ໂອນ ໄຮ ດັງ ປາຍ: 'ຄັນ ອາຍ ກູຈີດ ເຈີ່, ມາ ລາກວຍ ອັນ ອຶນນັ່ອງ ອາມົ່ງ, ກະ ໄລ່ ຕາ ເກີ່ຍ ເບີນ ກອນ, ນ່ະກັອຍ ອາແອມ ອັນ ແອັນ ອຶງເຄາະ ເຊີບ ລາກວຍ ອາຍ, ໂອນ ອັນ ເບີນ ກອນ ດໍອ໌ ແກີດ ກອນ ຈຸ່ມເຈືອ ອາຍ ອັນ.' ");
INSERT INTO ncq_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ອຶມແບິ ອາໄຣ່ ເບີນ ຕາປູ່ລ ນະ ແຊມອາຍ. ອາຍ ກັ່ລ ໄລ່ ອີດ ລາກວຍ. ເຈີ່ ອັນ ກູຈີດ ແຕ ຕາ ຢວາຮ ເບີນ ກອນ. ");
INSERT INTO ncq_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ເຈີ່ ອາແອມ ກາ ເຕ່ດ ອັນ ແອັນ ເຊີບ ລາກວຍ ອາຍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ກະ ມູເຈິງ ກັອຍ ເຕ່ ແຕ ອາແອມ ອຶນດີ ເຕົ່າ ແຕີ່ອ໌ ອາແອມ ອາລັອຮ. ຕາປູ່ລ ນະ ໄລ່ ລາ ມູເຈິງ ອຶນແຍ່ະ. ໄລ່ ກັອຍ ກູຈີດ ມາ ຕາ ຢວາຮ ເບີນ ກອນ. ");
INSERT INTO ncq_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ປັຣຊົດ ເລີ່ຍ ມັນແຊມ ກັອຍ ກູຈີດ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ພໍກາ ມັຮ ກວາຍ ກູຈີດ ອາມົ່ງ ລັ່ຮ, ມັນແຊມ ກັອຍ ແກີດ ລາກວຍ ເນົ່າ? ຍ່ອນ ໄລ່ ຕາປູ່ລ ນະ ຕາລາ ອຶນແຍ່ະ ມັນແຊມ ກັອຍ!\" ");
INSERT INTO ncq_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ເຢຊູ ຕາແອີຍ ໄລ່ ກັອຍ ປາຍ: \"ມັນແຊມ ຣາເລົາ ອີດ ລາກວຍ ກາຢາອ໌ ລາ ແອີງ ຕຶ່ງ ແດີຍ ໄນ່ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ມາ ໄລ່ ກາ ເຢືາງ ເຈົາຣາຊີ ຊັອງ ໄກຣ, ເຢືາງ ເຈົາຣາຊີ ໂອນ ໄລ່ ກັອຍ ອາມົ່ງ ລັ່ຮ ແຕ ກູຈີດ, ກະ ອັນ ໂອນ ໄລ່ ອາມົ່ງ ຊົດ ແດີຍ ຕຶ່ງ ອຶນຕຸ ອັນ ຊົດ. ກວາຍ ກັອຍ ຕາ ເບີນ ຣາອີດ ນັ່ອງ ແກີດ ລາກວຍ ກາຢາອ໌. ");
INSERT INTO ncq_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ໄລ່ ກັອຍ ລາ ນ່ະ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ; ໄລ່ ຕາ ເບີນ ກູຈີດ ນັ່ອງ. ໄລ່ ແກີດ ກອນ ອາໄກ ເຢືາງ ເຈົາຣາຊີ, ແຕ ຕາໄງ ໄລ່ ອາມົ່ງ ລັ່ຮ ແຕ ກູຈີດ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ແຕ ຣາມຶ່ຮ ກວາຍ ກູຈີດ ມາ ອາມົ່ງ ລັ່ຮ ໄນ່, ໂມເຊ ໂອນ ໄຮ ດັງ ແຈງ ແຕ ຣາມຶ່ຮ ກັອຍ ເຈີ່, ບັອງ ກາ ອັນ ຄຽນ ອາຕີ ແຕ ປູ່ລ ອູ່ຍຮ ເບຼີ ມາ ຕາ ເບີນ ກາດ. ອຶນຕຸ ກັອຍ ອັນ ດໍອ໌ ເຢືາງ ເຈົາຣາຊີ ລາ 'ເຢືາງ ເຈົາຣາຊີ ກາ ອັບຣາຮາມ, ອີຊາກ, ກະ ຢາໂຄບ ອຶນນັ່ອງ ຊາງ ຕຶ່ງ ມັນລັ່ອງ.' ");
INSERT INTO ncq_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ເຕ່ອ໌ ໄຮ ດັງ ໄລ່ ກັອຍ ອາມົ່ງ ລັ່ຮ ແຕ ກູຈີດ, ຍ່ອນ ກວາຍ ກູຈີດ ຕາ ເຕ່ອ໌ ຊາງ ເຢືາງ ເຈົາຣາຊີ. ແອີງ ໄລ່ ກາ ອາມົ່ງ ຊັອງ ເຕ່ອ໌ ຊາງ ອັນ, ກະ ຢັ່ຮ ເມືາງ ເຢືາງ ເຈົາຣາຊີ ມັຮ ກວາຍ ແກີດ ອາມົ່ງ ອຶນແຍ່ະ.\" ");
INSERT INTO ncq_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ເຈີ່ ເຢຊູ ປາຍ ນ່ະກັອຍ, ເບີນ ມັຮ ກວາຍ ອາຕີ ຄານອດ ປາຍ ໂຈະ ອັນ: \"ອາຈານ ເອີຍ! ປຍາຍ໌ ມັຮ ປັຣນາຍ ອາຈານ ປາຍ!\" ");
INSERT INTO ncq_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ແວັດ ກັອຍ, ໄລ່ ຕາ ຍັ່ນ ຕາແບີບ ນັ່ອງ ເຢຊູ ມູ ປັຣນາຍ ອຶນເຕົ່າ ແຕ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ເຢຊູ ຕາແບີບ ມັຮ ກວາຍ ກັອຍ ປາຍ: \"ຍ່ອນ ນານ່ະ ກວາຍ ເຕ່ອ໌ ປາຍ ກຣີດ ແຕີ່ອ໌ ແຕ ຈຸ່ມເຈືອ ດາວິດ? ");
INSERT INTO ncq_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ກູໂຕ ດາວິດ ແຕິ່ ອາຕີ ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ລ່ຳ ຍ່ອງ ເຢືາງ ເຈົາຣາຊີ ປາຍ: 'ເຢືາງ ເຈົາຣາຊີ ອາຕີ ໂຈະ ອຶນເຈົາ ເກົາ ປາຍ: \"ໄມ່ ຕາກູ ແອີດ ຢັ່ຮ ອາຕ່ຳ ເກົາ ");
INSERT INTO ncq_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ແລ່ະ ເກົາ ໂອນ ໄລ່ ກາ ຢໍອ໌ ອີ ກາຈີດ ໄມ່ ແອີດ ປື່ນ ຕາລາງ ອາເຢີງ ໄມ່, ຕະ ຊູລ ໄມ່.\"' ");
INSERT INTO ncq_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ກູໂຕ ດາວິດ ແຕິ່ ດໍອ໌ ກຣີດ ໄນ່ ລາ 'ອຶນເຈົາ.' ນານ່ະ ເຕ່ອ໌ ດາວິດ ດໍອ໌ ກວາຍ ແຕ ຈຸ່ມເຈືອ ອັນ ເບີມ ລາ 'ອຶນເຈົາ'?\" ");
INSERT INTO ncq_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ບັອງ ກາ ກວາຍ ກຼຶ່ງ ແອີດ ຊາງັດ ປັຣນາຍ ເຢຊູ, ອັນ ອາຕີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","\"ເຍືາ ອຶນໂຈຍ ຕະ ມູເຈິງ ກວາຍ ອາຕີ ຄານອດ. ໄລ່ ກັອຍ ຢໍອ໌ ລາລື່ ອີ ແຊິບ ອາຢັ່ອຮ ຕ່ອງ. ກະ ໄລ່ ຢໍອ໌ ລາລື່ ໂອນ ກວາຍ ການໍ່ອ໌ ຣາບັນ ອໍ ໄລ່ ບັອງ ກາ ໄລ່ ແອີດ ກະ ກວາຍ ກຼຶ່ງ. ກະ ໄລ່ ຢໍອ໌ ອີ ເບີນ ກາເຈີ່ງ ຕາກູ ອໍ ລາລື່ ກາເລີຍ ອຶນແຍ່ະ ແຕ ການໍ່ອ໌ ແອີດ ຕຶ່ງ ດຸງ ຊາງ ກວາຍ ອິດຊະຣາເອລ. ກະ ໄລ່ ຢໍອ໌ ອີ ຕາກູ ຢັ່ຮ ຕີ່ ແຕີ່ອ໌ ເນົ່າ ການື່ຍ ໄລ່ ແຕີ່ອ໌ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ໄລ່ ໂລ່ບ ອຶນແຍ່ະ ມູ່ນ ອຶມເປ່ອ໌ ກູມາຍ. ກະ ໄລ່ ເກົາແຊອ໌ ຕີ່ ຢໍອ໌ ອີ ໂອນ ເນົ່າ ປາຍ ໄລ່ ຕານັ່ອງ ອໍ. ນ່ະກັອຍ ເຈີ່ ປໍ ເມືາງ ໂຕ່ດ ໄລ່ ກັອຍ ລາ ອຶນຕັອງ ກາເລີຍ ແຕ ກວາຍ ການໍ່ອ໌!\" ");
INSERT INTO ncq_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ເຢຊູ ເນ່ ປໍ ອຶນຕຸ ກວາຍ ໂຈະ ປຣະ ຊາງ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ. ອັນ ເຮີມ ກວາຍ ຊຸ ເບີນ ໂຈະ ປຣະ ຕຶ່ງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ກະ ອັນ ເຮີມ ມານະ ອຶມເປ່ອ໌ ກູມາຍ ກາ ກາດີດ ລາລື່ ໂຈະ ບາຣ ກຼອງ ປຣະ ຊັອງ. ເກືາ ບາຣ ກຼອງ ປຣະ ໄນ່ ບີ່ອ໌ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ເຢຊູ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ອຶມເປ່ອ໌ ກູມາຍ ໄນ່, ອັນ ກາດີດ ລາລື່, ມາ ອັນ ໂຈະ ປຣະ ຊາງ ຊາອຶ່ຍ ກາເລີຍ ອຶນແຍ່ະ ແຕ ກວາຍ ການໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ອຶນແຍ່ະ ມັຮ ກວາຍ ການໍ່ອ໌ ກັອຍ ໂຈະ ປຣະ ແກຼີຍ ໄລ່ ຕັອກ ຈາ, ມາ ອຶມເປ່ອ໌ ກູມາຍ ໄນ່ ແອິ ລາລື່. ມາແລ່ະ ອັນ ເບີນ, ອັນ ໂຈະ ອຶນແຍ່ະ ມາຮ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ເບີນ ກວາຍ ຕະ ອຶນຕີ ແຕ ດຸງ ຊາງ ປື່ດ. ໄລ່ ປາຍ ອໍ ລາລື່ ດຸງ ຊາງ ກັອຍ, ຍ່ອນ ເນົ່າ ອີດ ຕາເມົາ ອໍ ຕະ. ກະ ຕຶ່ງ ດຸງ ຊາງ ກັອຍ ເບີນ ຊາອຶ່ຍ ເກຣີ່ງ ອໍ ເນົ່າ ຊາງ ໂອນ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ມາ ເຢຊູ ອາຕີ ກວາຍ ກັອຍ ປາຍ: \"ດຸງ ປື່ດ ເຍືາ ເຮີມ ອຶນໄນ່, ເຈີ່ ປໍ ເມືາງ ຕາເມົາ ເນົ່າ ຕະ ດຸງ ໄນ່ ຕາ ເບີນ ຣາແຕັດ ນັ່ອງ ມັນຕຸ. ອັນ ຣາຕັຮ ອຶນແຍ່ະ.\" ");
INSERT INTO ncq_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ໄລ່ ຕາແບີບ ເຢຊູ ປາຍ: \"ອາຈານ ເອີຍ! ແຊອ໌ ອາຈານ ອາຕີ ໂອນ ຮິ ດັງ, ອຶນນັ່ອງ ມາແລ່ະ ດູ່ນ ຣານະ ໄນ່ ແຕີ່ອ໌? ອຶນເຕົ່າ ກາ ແຕີ່ອ໌ ອາປັຮ ອຶນໂຍ່ງ ໂອນ ເນົ່າ ດັງ ຣານະ ໄນ່ ອີ ແຕີ່ອ໌?\" ");
INSERT INTO ncq_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ອຶງເຄາະ ເຍືາ ລາວັ່ງ ໂອນ ອໍ; ອຶນໂຈຍ ໂອນ ເນົ່າ ຣາພິ ເຍືາ. ເຈີ່ ປໍ ເມືາງ ເບີນ ຊາອຶ່ຍ ນະ ແຕີ່ອ໌ ອາງ ຣາມຶ່ຮ ເກົາ, ໄລ່ ປາຍ: 'ກູໂຕ ເກົາ ໄນ່ ແຕິ່ ລາ ກຣີດ!' ກະ ໄລ່ ປາຍ ນ່ະໄນ່ ແຮີ: 'ຕາໄງ ປັຣຊົດ ອີ ແຕີ່ອ໌ ເຈີ່!' ມາ ເຍືາ ອຶນໂຈຍ ປວາຍ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ພໍກາ ເຍືາ ຊັອງ ຮານ ເນົ່າ ຣາຕະ ກະ ເນົ່າ ຕຳໂປຣ ອີ ແກີດ ຊົດ ແຈ່ະໆ ເຢີ່ງໆ, ເຍືາ ອຶນໂຈຍ ເກຣ່າະ ອຶນເຕົ່າ. ຣານະ ໄນ່ ອຶງເຄາະ ແຕີ່ອ໌ ອຶນໂຍ່ງ ເວືາຍ. ມາ ຕາ ຢວາຮ ແຕີ່ອ໌ ຕາໄງ ປັຣຊົດ.\" ");
INSERT INTO ncq_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ເຢຊູ ອາຕີ ແອັນ ປາຍ: \"ຕາໄງ ກັອຍ ເບີນ ມູ່ ໄນ່ ຣາຕະ ກະ ມູ່ ກັອຍ, ກະ ກຣວາງ ໄນ່ ຣາຕະ ກະ ກຣວາງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ເບີນ ຊາອຶ່ຍ ອຶນຕຸ ກູແຕອ໌ ຕັນດື່ຣ ກະ ກູກື່ດ. ເບີນ ຊາອຶ່ຍ ອຶນຕຸ ແອິ ຊັຣນາ ຈາ. ກະ ເບີນ ຊາອຶ່ຍ ຣາມຶ່ຮ ອາອີ່, ມານະ ແຕັດ ແຕ ມານະ. ເບີນ ຊາອຶ່ຍ ຣາມຶ່ຮ ຕຸ່ຮ ກັ່ດ ແຕີ່ອ໌, ກະ ຊາອຶ່ຍ ຣາມຶ່ຮ ກາ ຕາ ເກີ່ຍ ເຮີມ ແຕີ່ອ໌ ແຕ ມັນລັ່ອງ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","\"ມາ ອຶນໂຍ່ງ ມັຮ ຣາມຶ່ຮ ກັອຍ ອີ ແຕີ່ອ໌, ເບີນ ເນົ່າ ໂກບ ເຍືາ ກະ ຕະ ຕຸ່ຮ ກັ່ດ ເຍືາ. ໄລ່ ເດີງ ຕັດຊີ່ນ ເຍືາ ປໍ ດຸງ ຊາງ ກວາຍ ອິດຊະຣາເອລ, ກະ ໄລ່ ໂຈະ ເຍືາ ຕຶ່ງ ກໍ່ອ໌. ໄລ່ ເດີງ ເຍືາ ຢັ່ຮ ເມືາງ ມັຮ ກວາຍ ເຕືາວ ປັຣເຍືາ ກະ ຢັ່ຮ ເມືາງ ມັຮ ກວາຍ ຊົດ ການໍ່ອ໌ ແຮີ ຍ່ອນ ເຍືາ ປວາຍ ຣາມຶ່ຮ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ມັຮ ຣາມຶ່ຮ ກັອຍ ຕະ ໂອນ ເຍືາ ເຕ່ອ໌ ອາຕີ ແຕ ຣານະ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ອຶງເຄາະ ເຍືາ ອຶນໂຈຍ ອຸກ ດໍອ໌ ອຶນເຕົ່າ ເຍືາ ຢໍອ໌ ອີ ປາຍ ໂຈະ ກວາຍ ຊົດ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ບັອງ ກາ ກັອຍ, ເກົາ ແຕິ່ ອາຕີ ໂອນ ເຍືາ ເບີນ ປັຣນາຍ ແຄວ໌ ໂອນ ເຍືາ ເຕ່ອ໌ ຕະ ອຶນຕີ ໂຈະ ໄລ່ ກາ ອີ ຕະ ເຍືາ. ເຈີ່ ໄລ່ ຕາ ເຕ່ອ໌ ຣາຈຽນ ອຶນເຕົ່າ ນັ່ອງ ໂຈະ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ອຶມເປ່ອ໌ ອຶມປໍ່, ແຊມອາຍ, ແຄີຍ ກູຢາ, ກະ ເຢົ່າ ເຍືາ, ອຶນແຍ່ະ ໄລ່ ກັອຍ ມ່ອບ ເຍືາ ປໍ ອາຕີ ກວາຍ ກາ ອີ ຕະ ເຍືາ. ກະ ເບີນ ກວາຍ ແຕ ມູ່ ເຍືາ, ເນົ່າ ກາຈີດ ຕັຮ. ");
INSERT INTO ncq_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ອຶນແຍ່ະ ມັຮ ກວາຍ ຊາອັຣ ເຍືາ ຍ່ອນ ເຍືາ ປວາຍ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ມາ ໂຊະ ຕຶ່ງ ແປຼີ ເຍືາ ຕາ ເບີນ ປິ່ດ ມວຍ ເຊັນ ອຶນເຕົ່າ ເລີ່ຍ. ");
INSERT INTO ncq_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ຍ່ອນ ເຍືາ ຈີວ໌ ເລືອຍໆ, ນ່ະກັອຍ ເຍືາ ເບີນ ອາມົ່ງ ຊົດ ແດີຍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","\"ແຕີ່ອ໌ ເຍືາ ເຮີມ ກຼຶ່ງ ຕາຮານ ແອີດ ອຶມແປຣ ເມືອງ ເຢຣູຊາເລັມ, ນ່ະກັອຍ ເຍືາ ດັງ ແຈ່ະ ເຈີ່ ເນົ່າ ອີ ຕາລຸຮ ຕັຮ ເມືອງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ບັອງ ກາ ກັອຍ, ໄລ່ ກາ ແອີດ ຕຶ່ງ ແຄງ ຢູດາຍ, ອຶງເຄາະ ໄລ່ ຕາລຸ່ຮ ຊັອຮ ແອີດ ປໍ ກົຮ ແອັນ. ໄລ່ ກາ ແອີດ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ, ອຶງເຄາະ ໄລ່ ລັ່ອຮ ແຕ ເມືອງ ກັອຍ. ໄລ່ ກາ ແອີດ ຢັ່ຮ ນໍ່ອ໌ ເມືອງ ເຢຣູຊາເລັມ, ອຶງເຄາະ ໄລ່ ອຶນໂຈຍ ມູ່ດ ຕຶ່ງ ເມືອງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ຕາໄງ ກັອຍ ລາ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ຕະ ມັຮ ຈຸ່ມ ອິດຊະຣາເອລ ຍ່ອນ ໄລ່ ຕາ ເບີນ ຊາງັດ, ໂອນ ແກີດ ຊັງໄກຣ ມັຮ ປັຣນາຍ ເນົ່າ ຄຽນ ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ. ");
INSERT INTO ncq_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ຕຶ່ງ ຕາໄງ ກັອຍ ໂຕຍ໌ ບາບ ລາລື່ ໄລ່ ກາ ແອີດ ຕຶ່ງ ຈະ ກະ ໄລ່ ກາ ອາອູອ໌ ກອນ. ຍ່ອນ ຕາໄງ ກັອຍ ເບີນ ຕຸ່ຮ ກັ່ດ ລາລື່ ແຕີ່ອ໌ ປໍ ກຣວາງ ໄນ່, ກະ ເຢືາງ ເຈົາຣາຊີ ຕະ ມັຮ ກວາຍ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ອັນ ກາ ເນົ່າ ໄປ່ອ໌ ແຕ ດາວ. ອັນ ກາ ເນົ່າ ໂກບ, ເດີງ ຕະ ຊູລ ປໍ ກຣວາງ ການໍ່ອ໌ ແອັນ. ກະ ມັຮ ກວາຍ ກາ ຕາ ແກີນ ກວາຍ ອິດຊະຣາເອລ, ໄລ່ ຕາລຸຮ ອຶນແຍ່ະ ເມືອງ ເຢຣູຊາເລັມ ເຕົ່າ ຊົດ ແດີຍ ໄລ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","\"ແວັດ ກັອຍ, ແກີດ ຄານະ ຕຶ່ງ ມັ່ດ ມານາງ, ຕຶ່ງ ຣາລັ່ງ ກາໄຊ, ກະ ຕຶ່ງ ມັນໂຕຣ ແຮີ. ກະ ຕຶ່ງ ກູແຕອ໌ ໄນ່ ເບີນ ຊາອຶ່ຍ ກຣວາງ ກວາຍ ຊັອງ ງຶ່ດ ກະ ອຶງກັອຮ ລາລື່. ທາເລ ແກີດ ປ່ອງ ໂຮ ເຣ່ງ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ກວາຍ ປິ່ດ ຣາງຶ່ຮ ຍ່ອນ ໄລ່ ອຶງກັອຮ ກະ ໄລ່ ເກຣ່າະ ລາລື່ ຣາມຶ່ຮ ຕຸ່ຮ ກັ່ດ ແຕີ່ອ໌ ປໍ ກູ່ ກຣວາງ. ກະ ມັຮ ຣາມຶ່ຮ ອຶນເຕົ່າ ເບີນ ອຳນາດ ຕຶ່ງ ມັນລັ່ອງ, ເຢືາງ ເຈົາຣາຊີ ຕະ ໂອນ ຣາໄມ່ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ແວັດ ກັອຍ ເນົ່າ ເຮີມ ກອນ ເຢືາງ ແກີດ ກວາຍ ແຕີ່ອ໌ ອຶນດີ ຣາມິ່ລ, ອັນ ເບີນ ອຳນາດ ປື່ດ ລາລື່ ກະ ຣູ່ບເຣືາງ ອັນ ອາງອື່ຣ. ");
INSERT INTO ncq_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ບັອງ ກາ ເຍືາ ເຮີມ ຣາມຶ່ຮ ໄນ່ ແຕີ່ອ໌, ເຍືາ ຕາຢຶ່ງ ຕາງ່ອນ ອາຊັອຮ, ຍ່ອນ ແຈ່ະ ອີ ແຕີ່ອ໌ ເຈີ່ ປາເນ່ນ ເຢືາງ ເຈົາຣາຊີ ຈ່ອຍ ອາມົ່ງ ເຍືາ.\" ");
INSERT INTO ncq_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ເຈີ່ ເຢຊູ ອາຕີ ໄລ່ ແຕ ປັຣນາຍ ຊາກຳ ປາຍ: \"ເຍືາ ເນ່ ປໍ ກັ່ລ ລາວັ່ຮ ກະ ປໍ ກັ່ລ ອາລ່ອງ ການໍ່ອ໌ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ແຕີ່ອ໌ ເຍືາ ເຮີມ ອາລ່ອງ ກັອຍ ໄບອ໌ ຊາລາ, ນ່ະກັອຍ ເຍືາ ດັງ ແຈ່ະ ອີ ແຕີ່ອ໌ ກາໄຊ ພວາອ໌. ");
INSERT INTO ncq_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ມູເຈິງ ກັອຍ ເຕ່, ແຕີ່ອ໌ ເຍືາ ເຮີມ ມັຮ ຣາມຶ່ຮ ເກົາ ອາຕີ ເຍືາ, ເຍືາ ດັງ ປາຍ ແຈ່ະ ເຈີ່ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ. ");
INSERT INTO ncq_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ກວາຍ ແອີດ ຕຶ່ງ ແດີຍ ໄນ່ ຕາ ເບີນ ກູຈີດ ອຶນແຍ່ະ, ອຶນໂຍ່ງ ແຕ ອຶນແຍ່ະ ຣາມຶ່ຮ ໄນ່ ແຕີ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ມັນລັ່ອງ ກະ ກູແຕອ໌ ແກີດ ປິ່ດ ອຶນແຍ່ະ, ມາ ປັຣນາຍ ເກົາ ອາຕີ ເຍືາ ຕາ ເບີນ ແກີດ ປິ່ດ.\" ");
INSERT INTO ncq_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","\"ອຶງເຄາະ ເຍືາ ລາວັ່ງ ອໍ ຈະ ເຍືາ ເບີມ. ອຶນໂຈຍ ໂອນ ຣາງຶ່ຮ ເຍືາ ຄຶ່ດ ຢໍອ໌ ອີ ງ່ອຍ໌ ຈາ ຊາອຶ່ຍ ແຕີລາ ບູລ ລຳແປ່ະ ລັງຮຍາ; ກະ ອຶນໂຈຍ ອຸກ ອຶງກັອຮ ແອິ ເກຣີ່ງ ຕັອກ ຈາ ຕຶ່ງ ແດີຍ ອາມົ່ງ ເຍືາ. ຄັນ ນ່ະກັອຍ, ແຕີ່ອ໌ ຕາໄງ ເກົາ ເຈົາ ລັ່ຮ ປໍ ກູແຕອ໌ ໄນ່, ຕາໄງ ກັອຍ ເກົາ ແຕີ່ອ໌ ໄວ່ ລາລື່, ມາ ອຶງກັອຮ ປຍາຍ໌ ເຍືາ ຕາ ເບີນ ຄຶ່ດ ອຶນເຕົ່າ ແຕ ເກົາ ອີ ແຕີ່ອ໌ ລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ຕາໄງ ກັອຍ ແຕີ່ອ໌ ປໍ ກູ່ ນະ ກວາຍ ແອີດ ຕຶ່ງ ກູແຕອ໌ ໄນ່, ລາ ໄວ່ ລາລື່ ນ່ະ ຕາຮໍ ໄລ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ນ່ະກັອຍ ອຶງເຄາະ ເຍືາ ຄຶ່ດ ເລືອຍໆ ກະ ເກຣາະ ເລືອຍໆ ຕາໄງ ກັອຍ. ອຶງເຄາະ ເຍືາ ເກົາແຊອ໌ ໂອນ ເຕ່ອ໌ ເຍືາ ວຍາຣ ແວັດ ແຕ ຣາມຶ່ຮ ຕຸ່ຮ ກັ່ດ ກັອຍ, ກະ ໂອນ ເຕ່ອ໌ ເຍືາ ຕາຢຶ່ງ ຢັ່ຮ ເມືາງ ອັນ, ແຕີ່ອ໌ ຕາໄງ ກອນ ເຢືາງ ແກີດ ກວາຍ ອາເບຼິຮ ອຶນແຍ່ະ ມັຮ ກວາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ກູ່ ຣາໄງ ເຢຊູ ອາຕີ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ, ມາ ແຕີ່ອ໌ ຊາເດົາ ອັນ ເປາະ ບິ ປໍ ກົຮ ອາໂປ່ນ. ");
INSERT INTO ncq_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ແຕີ່ອ໌ ປັ່ງ ຕາຣື່ບ ແຕ ປຼື່ ເບີນ ກຼຶ່ງ ກວາຍ ແຕີ່ອ໌ ອຶນແຍ່ະ ປໍ ດຸງ ຊາງ ປື່ດ ອີ ຊາງັດ ເຢຊູ ອາຕີ. ");
INSERT INTO ncq_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ແຈ່ະ ອີ ແຕີ່ອ໌ ຕາໄງ ຈຸ່ມ ອິດຊະຣາເອລ ຕະ ຣີ່ດ ຈາ ໂດຍ ບຸຮ ແອິ ບວຮ ຊື່ອ໌ ຕາປູ່ລ ຕາໄງ. ມາ ຕາໄງ ມວຍ ຕຶ່ງ ຕາປູ່ລ ຕາໄງ ກັອຍ ໄລ່ ຕະ ຣີ່ດ ຊາແຍີ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ອາກຼັຮ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ກະ ມັຮ ກາ ກວາຍ ອາຕີ ຄານອດ, ໄລ່ ຈໍ່ອ໌ ຣານາ ຢໍອ໌ ອີ ກາຈີດ ເຢຊູ. ມາ ໄລ່ ອຶງກັອຮ ກອນແຊມ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ບັອງ ກາ ກັອຍ ເຢືາງ ຊາຕານ ມູ່ດ ຕຶ່ງ ຣາງຶ່ຮ ຢູດາ ອິດຊະກາຣີອົດ. ຢູດາ ໄນ່ ລາ ແຕ ໄລ່ ມວຍ ຈິ່ດ ລາ ບາຣ ນະ ກາ ຣຍານ ແຕ ເຢຊູ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ນ່ະກັອຍ ຢູດາ ເປາະ ຣາມົຮ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ກະ ໄລ່ ກາ ກຍາອ໌ ດຸງ ຊາງ ປື່ດ. ອັນ ຊັຣຮົງ ກະ ໄລ່ ນານ່ະ ອີ ຕະ ໂອນ ເຕ່ອ໌ ເບີນ ໂກບ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ໄລ່ ກັອຍ ຊັອງ ແອີນ ລາລື່, ກະ ໄລ່ ປຣ່ອມ ອີ ໂອນ ຢູດາ ປຣະ. ");
INSERT INTO ncq_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ຢູດາ ປຣ່ອມ, ເຈີ່ ອັນ ຈໍ່ອ໌ ຕາໄງ ແລ່ະ ກາ ອໍ ມ່ອບ ເຢຊູ ໂອນ ໄລ່, ລາ ຕາໄງ ກາ ຕາ ເບີນ ກຼຶ່ງ ກວາຍ ແອີດ ແຈ່ະ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ແຕີ່ອ໌ ເຈີ່ ຕາໄງ ກວາຍ ອິດຊະຣາເອລ ຕະ ຣີ່ດ ຈາ ໂດຍ ບຸຮ ແອິ ບວຮ ຊື່ອ໌. ຕາໄງ ກັອຍ ອຶງເຄາະ ໄລ່ ກຍາກ ແກະ ນຸ່ມ ປວາຍ ຄານອດ ຊາແຍີ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ອາກຼັຮ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ນ່ະກັອຍ ເຢຊູ ແປຣີ ເປໂຕ ກະ ໂຢຮັນ ປາຍ: \"ເຍືາ ເປາະ ແຕງ ຊັຣນາ ຈາ ໂອນ ໄຮ ຈາ ຊາແຍີ ລັ່ຮ ຕາໄງ ອາກຼັຮ.\" ");
INSERT INTO ncq_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ມາ ໄລ່ ຕາແບີບ ລັ່ຮ ເຢຊູ: \"ອຶນຕຸ ແລ່ະ ອາຈານ ໂອນ ຮິ ກຽມ?\" ");
INSERT INTO ncq_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ເຈີ່ ເຢຊູ ອາຕີ ໄລ່ ປາຍ: \"ເຍືາ ຊາງັດ ໂອນ ອໍ. ບັອງ ກາ ເຍືາ ມູ່ດ ຕຶ່ງ ວີ່ລ, ເຍືາ ເບີນ ຣາມົຮ ມານະ ຣາເລົາ ຕາແຢອ໌ ແຈັຮ ແດີອ໌. ເຍືາ ປວາຍ ອຶນຕູ່ນ ກຣັອງ ກວາຍ ກັອຍ. ດຸງ ອາແລ່ະ ອັນ ມູ່ດ, ເຍືາ ມູ່ດ ດຸງ ກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ເຈີ່ ເຍືາ ອາຕີ ກວາຍ ອຶນເຈົາ ດຸງ ກັອຍ, ປາຍ: 'ອາຈານ ຢໍອ໌ ອີ ຕາແບີບ ໄມ່ ປາຍ: \"ອຶນແລ່ະ ກຼຸງ ຕາມອຍ? ຕຶ່ງ ກຼຸງ ກັອຍ ເກົາ ຢໍອ໌ ອີ ຈາ ເປ່ລ ບູຍ ຊາແຍີ ຕາໄງ ອາກຼັຮ ກະ ມູ່ ກາ ຣຍານ ແຕ ເກົາ.\"' ");
INSERT INTO ncq_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ແວັດ ເຍືາ ຕາແບີບ ນ່ະກັອຍ, ເຈີ່ ອັນ ຊາດອຍ ໂອນ ເຍືາ ມວຍ ກຼຸງ ປື່ດ ຕຶ່ງ ຣານ ແປີງ. ກຼຸງ ກັອຍ ເບີນ ເຈີ່ ກູ່ ຣາມຶ່ຮ ມັຮ ເກຣີ່ງ ຕັອກ. ເຍືາ ກຽມ ຕຶ່ງ ກຼຸງ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ເຈີ່ ໄລ່ ບາຣ ນະ ເປໂຕ ກະ ໂຢຮັນ ເປາະ, ກະ ໄລ່ ຣາມົຮ ນ່ະ ເຢຊູ ອາຕີ ດໍອ໌ ແຕ ອຶນໂຍ່ງ. ເຈີ່ ໄລ່ ກຽມ ຊັຣນາ ຈາ ມວຍ ເປ່ລ ຊາແຍີ ຕາໄງ ອາກຼັຮ ອຶງກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ແຕີ່ອ໌ ປາເນ່ນ ຈາ, ເຢຊູ ຕາກູ ຈາ ມັນຕຸ ກະ ໄລ່ ມວຍ ຈິ່ດ ລາ ບາຣ ນະ ກາ ອັນ ຣຽຮ. ");
INSERT INTO ncq_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ເຈີ່ ເຢຊູ ອາຕີ ໄລ່ ປາຍ: \"ເກົາ ຊັອງ ຢໍອ໌ ອີ ຈາ ງ່ອຍ໌ ລາລື່ ກະ ເຍືາ ຊາແຍີ ຕາໄງ ອາກຼັຮ ແຕ ອຶນໂຍ່ງ ເກົາ ຕາ ຢວາຮ ຣາມົຮ ຕຸ່ຮ ກັ່ດ. ");
INSERT INTO ncq_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ເກົາ ອາຕີ ເຍືາ, ເກົາ ຕາ ເບີນ ຈາ ງ່ອຍ໌ ນັ່ອງ ກະ ເຍືາ ນ່ະ ເປ່ລ ໄນ່ ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ແກີດ ຣາປຍາຍ໌ ມັຮ ຣາມຶ່ຮ ເນົ່າ ຊາແຍີ ຈາ ງ່ອຍ໌ ເປ່ລ ໄນ່. ຕາໄງ ກັອຍ ລາ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ.\" ");
INSERT INTO ncq_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ອັນ ອີດ ຈອກ ແດີອ໌ ກະ ຊາແອີນ ເຢືາງ ເຈົາຣາຊີ. ເຈີ່ ອັນ ປາຍ \"ເຍືາ ອີດ ອຶມແປອ໌ ແດີອ໌ ໄນ່ ໂອນ ເຍືາ ງ່ອຍ໌. ");
INSERT INTO ncq_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ເກົາ ອາຕີ ເຍືາ, ເກົາ ຕາ ເບີນ ງ່ອຍ໌ ນັ່ອງ ແດີອ໌ ແຕ ປາໄລ ອາງຸ່ນ ໄນ່ ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ.\" ");
INSERT INTO ncq_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ເຈີ່ ອັນ ອີດ ໂດຍ ບຸຮ ແອັນ ກະ ຊາແອີນ ເຢືາງ ເຈົາຣາຊີ. ເຈີ່ ອັນ ປີຮ ອາແວີຍ ໂອນ ໄລ່. ອັນ ປາຍ \"ໂດຍ ບຸຮ ໄນ່ ລາ ຈະ ເກົາ ກາ ເກົາ ມ່ອບ ໂອນ ເຍືາ. ໂອນ ເຍືາ ຈາ ດຸ ໂດຍ ບຸຮ ໄນ່ ດໍອ໌ ຊາແຍີ ລັ່ຮ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ແມິ່ມ ໄລ່ ຈາ ໂດຍ ບຸຮ ອັນ ຕະ ມູເຈິງ ກັອຍ ເຕ່. ເຢຊູ ອີດ ຈອກ ແດີອ໌, ເຈີ່ ອັນ ປາຍ: \"ແດີອ໌ ໄນ່ ລາ ອາຮາມ ເກົາ. ອາຮາມ ໄນ່ ຕາໂຮະ ລາ ຕະ ໂອນ ເຍືາ ດັງ ປາຍ ເຢືາງ ເຈົາຣາຊີ ປັຣຄັນ ປັຣນາຍ ຕາໄມ ກະ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","\"ມາ ໄກຣ ລາລື່, ແຕ ເຍືາ ກາ ຈາ ມັນຕຸ ກະ ເກົາ ຊານໍ່, ເບີນ ມານະ ກາ ອີ ມ່ອບ ເກົາ ໂອນ ເນົ່າ ກາຈີດ. ");
INSERT INTO ncq_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ກອນ ເຢືາງ ແກີດ ກວາຍ ອຶງເຄາະ ກູຈີດ ນ່ະ ເຢືາງ ເຈົາຣາຊີ ປາຍ ດໍອ໌ ເຈີ່. ມາ ບາບ ລາລື່ ໂອນ ກວາຍ ກາ ມ່ອບ ອັນ ໂອນ ເນົ່າ ກາຈີດ.\" ");
INSERT INTO ncq_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ເຈີ່ ໄລ່ ມານະ ຕາແບີບ ມານະ ປາຍ: \"ເນົ່າ ແຕ ມູ່ ໄຮ ກາ ອີ ຕະ ຣານະ ໄນ່?\" ");
INSERT INTO ncq_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ມັຮ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ຣາຈຽນ ຣາຕວາອ໌ ຢໍອ໌ ອີ ດັງ ເນົ່າ ຕຶ່ງ ມູ່ ໄລ່ ກາ ປື່ດ ກາເລີຍ ແຕ ການໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ເຢຊູ ອາຕີ ໄລ່ ປາຍ: \"ໄລ່ ກາ ແກີດ ເຕືາວ ປັຣເຍືາ ຕຶ່ງ ແດີຍ ໄນ່ ໄລ່ ຕະ ໂອນ ກອນແຊມ ອຶງກັອຮ ໄລ່; ກະ ມັຮ ກວາຍ ເບີນ ອຳນາດ ຢໍອ໌ ອີ ໂອນ ກວາຍ ການໍ່ອ໌ ຍ່ອງ ປາຍ ໄລ່ ລາ ກວາຍ ເກີ່ຍ ຈ່ອຍ ເຢົ່າ. ");
INSERT INTO ncq_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ມາ ເຍືາ ອຶນໂຈຍ ຕະ ນ່ະກັອຍ. ຄັນ ອາແລ່ະ ແຕ ມູ່ ເຍືາ ມາ ປື່ດ ກາເລີຍ, ໂອນ ອັນ ຕະ ນ່ະ ກວາຍ ແກດ. ກະ ອັນ ກາ ແກີດ ອາຣຍາຍຮ, ໂອນ ອັນ ແກີດ ນ່ະ ກວາຍ ຕະ ຣານະ. ");
INSERT INTO ncq_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ກວາຍ ອາແລ່ະ ເຍືາ ເຮີມ ປື່ດ ກາເລີຍ, ອັນ ກາ ຕາກູ ຈາ ຊັອງ, ແຕີລາ ອັນ ກາ ຕະ ຣານະ ແຕງ ຊັຣນາ ໂອນ ເນົ່າ ຈາ? ອັນ ກາ ຕາກູ ຈາ, ລາ ປື່ດ ກາເລີຍ. ມາ ເກົາ ແອີດ ກະ ເຍືາ ລາ ນ່ະ ກວາຍ ຕະ ຣານະ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","\"ເຍືາ ລາ ມູ່ ກາ ແອີດ ກະ ເກົາ; ເຍືາ ຕາ ເບີນ ຕັຮ ເກົາ ບັອງ ກາ ເກົາ ຣາມົຮ ຊາອຶ່ຍ ຕຸ່ຮ ກັ່ດ. ");
INSERT INTO ncq_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ອຶມປໍ່ ເກົາ ມ່ອບ ໂອນ ເກົາ ເບີນ ອຳນາດ. ມູເຈິງ ກັອຍ ເຕ່ ເກົາ ມ່ອບ ໂອນ ເຍືາ ເບີນ ອຳນາດ. ");
INSERT INTO ncq_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ເກົາ ໂອນ ເຍືາ ຈາ ງ່ອຍ໌ ມັນຕຸ ກະ ເກົາ ບັອງ ກາ ເກົາ ຕະ ຊົດ. ກະ ເກົາ ໂອນ ເຍືາ ຕາກູ ຕັດຊີ່ນ ອຶນແຍ່ະ ມວຍ ຈິ່ດ ລາ ບາຣ ຈຸ່ມ ກວາຍ ອິດຊະຣາເອລ.\" ");
INSERT INTO ncq_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","\"ຊີໂມນ, ຊີໂມນ ເອີຍ! ເຢືາງ ຊາຕານ ແຊອ໌ ເຈີ່ ອີ ເບີນ ເຍືາ. ອັນ ຢໍອ໌ ອີ ຕະ ຕຸ່ຮ ກັ່ດ ເຍືາ ນ່ະ ເນົ່າ ອູມ ອຶງກຣອຍ ທຣໍ. ");
INSERT INTO ncq_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ມາ ເກົາ ເກົາແຊອ໌ ໂອນ ຣາງຶ່ຮ ໄມ່ ຊາອຳ ຕາ ເບີນ ແກີດ ຣຸ່ງ. ແຕີ່ອ໌ ໄມ່ ລົ່ບ ຊາອຳ ລັ່ຮ ເກົາ, ອຶງເຄາະ ໄມ່ ຈ່ອຍ ມັຮ ກາ ແຊມອາຍ ໄມ່ ກາ ເກົາ ຣຽຮ ເຈີ່, ໂອນ ຣາງຶ່ຮ ໄລ່ ຊາອຳ ເຣ່ງ ອາຊັອຮ ແອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ມາ ເປໂຕ ຕາແອີຍ ລັ່ຮ ເຢຊູ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ເກົາ ປຣ່ອມ ເຈີ່ ອີ ເປາະ ກະ ອຶນເຈົາ. ຄັນ ເນົ່າ ໂກບ ອຶນເຈົາ ໂຈະ ຕຶ່ງ ກໍ່ອ໌, ແຕີລາ ເນົ່າ ກາຈີດ, ລາ ເກົາ ປຣ່ອມ ເປາະ ກະ ອຶນເຈົາ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ມາ ເຢຊູ ອາຕີ ລັ່ຮ ເປໂຕ ປາຍ: \"ເປໂຕ ເອີຍ! ອຶນໂຍ່ງ ອຶນຕຣວຍ ຕາກາຣ, ໄມ່ ກາແລີຍຮ ປາຍ ຕາ ເບີນ ດັງ ເກົາ ໄປ ເຮີບ.\" ");
INSERT INTO ncq_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ເຢຊູ ຕາແບີບ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ບັອງ ກາ ເກົາ ແປຣີ ເຍືາ ເປາະ ມາ ເກົາ ຕາ ເບີນ ໂອນ ເຍືາ ເດີງ ຕູຍ ປຣະ, ແຕີລາ ຕູຍ ເກຣີ່ງ, ແຕີລາ ແກີບ, ບັອງ ກາ ກັອຍ ເຍືາ ແອິ ອຶນເຕົ່າ ບໍ?\" ໄລ່ ຕາແອີຍ: \"ຮິ ຕາ ເບີນ ແອິ ອຶນເຕົ່າ.\" ");
INSERT INTO ncq_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ເຈີ່ ເຢຊູ ປາຍ ແອັນ ໂຈະ ໄລ່: \"ມາ ຊານໍ່ ເກົາ ອາຕີ ເຍືາ ປາຍ: ອາແລ່ະ ກາ ເບີນ ຕູຍ ປຣະ, ໂອນ ອັນ ກາຕັ່ນ. ອາແລ່ະ ກາ ເບີນ ຕູຍ ເກຣີ່ງ, ໂອນ ອັນ ເດີງ. ອາແລ່ະ ກາ ແອິ ດາວ, ໂອນ ອັນ ຈິ ອາຢັ່ອຮ ຕ່ອງ, ເຈີ່ ແຈີງ ດາວ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ຍ່ອນ ເກົາ ອາຕີ ເຍືາ, ຊານໍ່ ອຶງເຄາະ ແກີດ ຣາປຍາຍ໌ ແຕ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ນ່ະໄນ່ ແຕ ເກົາ: 'ເນົ່າ ປາຍ ອັນ ລາ ກວາຍ ໂລ່ຍຮ ຄານອດ ມູເຈິງ ເນົ່າ ເຕ່.' ກະ ປັຣນາຍ ການໍ່ອ໌ ເນົ່າ ປາຍ ແຕ ເກົາ ລາ ແກີດ ຣາປຍາຍ໌ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ອາຕີ ອັນ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ໄນ່! ເບີນ ເຈີ່ ບາຣ ປຼາ ດາວ.\" ເຈີ່ ເຢຊູ ຕາແອີຍ: \"ເອີ. ແປະ ເອີຍ໌.\" ");
INSERT INTO ncq_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ເຢຊູ ລັ່ອຮ ແຕ ອຶນຕຸ ກັອຍ ເປາະ ປໍ ກົຮ ອາໂປ່ນ, ລາ ອຶນຕຸ ອັນ ເກີ່ຍ ເປາະ ແຕ ອຶນໂຍ່ງ. ມັຮ ມູ່ ກາ ຣຍານ ແຕ ອັນ ເປາະ ເຕ່ ກະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ແຕີ່ອ໌ ປໍ ອຶນຕຸ ກັອຍ ອັນ ອາຕີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ອຶງເຄາະ ເຍືາ ເກົາແຊອ໌ ອຶນໂຈຍ ໂອນ ເນົ່າ ປັຣຕຶ່ ເຍືາ ຕະ ໂລ່ຍຮ.\" ");
INSERT INTO ncq_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ເຢຊູ ລັ່ອຮ ແຕ ໄລ່ ເບີນ ມາຮ ມວຍ ຈິ່ດ ອາຈັ່ອງ. ເຈີ່ ອັນ ກຼຸ່ ຣາໂກລ, ກະ ອັນ ເກົາແຊອ໌. ");
INSERT INTO ncq_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ອັນ ເກົາແຊອ໌ ປາຍ: \"ອຶມປໍ່ ເອີຍ! ຄັນ ໄມ່ ປຣ່ອມ, ເກົາ ແຊອ໌ ໄມ່ ອາຢິ່ ຈອກ ຕຸ່ຮ ກັ່ດ ໄນ່ ໂອນ ແວັດ ແຕ ເກົາ. ມາ ອຶມປໍ່ ອຶນໂຈຍ ປວາຍ ນ່ະ ຣາງຶ່ຮ ເກົາ ອີ ເບີນ, ມາ ປວາຍ ນ່ະ ຣາງຶ່ຮ ອຶມປໍ່ ຢໍອ໌ ຊັອງ.\" ");
INSERT INTO ncq_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ເຈີ່ ເບີນ ມານະ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ແຕ ມັນລັ່ອງ ແຕີ່ອ໌ ປໍ ເຢຊູ ຈ່ອຍ ໂອນ ຣາງຶ່ຮ ອັນ ເຣືາບ ຈີວ໌ ຣາມຶ່ຮ ຕຸ່ຮ ກັ່ດ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ເຢຊູ ຊັອງ ຕຸ່ຮ ກັ່ດ ອາຣຶ່ກ ລາລື່ ຕຶ່ງ ຣາງຶ່ຮ ອັນ. ເຈີ່ ອັນ ເກົາແຊອ໌ ອຶນແຍ່ະ ຣາງຶ່ຮ ຣາແຮີ. ເບີນ ປາຮູຣ ລັ່ອຮ ແຕ ຈະ ອັນ ນ່ະ ອາຮາມ ຕາເຢາະ ຕຶ່ງ ກູແຕອ໌. ");
INSERT INTO ncq_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ພໍກາ ເຢຊູ ຢວຣ ແຕ ອັນ ເກົາແຊອ໌, ອັນ ເຈົາ ລັ່ຮ ປໍ ມູ່ ກາ ຣຍານ ແຕ ອັນ. ອັນ ເຮີມ ໄລ່ ບິ, ຍ່ອນ ໄລ່ ຊັອງ ລາແກັຮ ຄຶ່ດ ຊາອຶ່ຍ ຣາມຶ່ຮ ຕຸ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ເຢຊູ ຕາແບີບ ໄລ່: \"ນານ່ະ ເຍືາ ບິ? ເຍືາ ຕາແມີ! ກະ ອຶງເຄາະ ເຍືາ ເກົາແຊອ໌ ອຶນໂຈຍ ໂອນ ເນົ່າ ປັຣຕຶ່ ເຍືາ ຕະ ໂລ່ຍຮ.\" ");
INSERT INTO ncq_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ບັອງ ກາ ເຢຊູ ອຶນນັ່ອງ ອາຕີ ມູ່ ກາ ຣຍານ ແຕ ອັນ, ເບີນ ກຼຶ່ງ ກວາຍ ແຕີ່ອ໌ ປໍ ໄລ່. ກະ ຢູດາ, ອັນ ກາ ແຕ ມວຍ ຈິ່ດ ລາ ບາຣ ນະ ກາ ຣຍານ ແຕ ເຢຊູ ເຕ່, ອັນ ເດີງ ກວາຍ ກຼຶ່ງ ກັອຍ ແຕີ່ອ໌ ແຈ່ະ ເຢຊູ. ເຈີ່ ອັນ ໂຮນ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ມາ ເຢຊູ ຕາແບີບ ຢູດາ ປາຍ: \"ຢູດາ ເອີຍ, ໄມ່ ໂຮນ ເກົາ ກອນ ເຢືາງ ແກີດ ກວາຍ, ຍ່ອນ ໄມ່ ມ່ອບ ໂອນ ເນົ່າ ກາຈີດ ເກົາ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ພໍກາ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ເຮີມ ຣານະ ກາ ອີ ແຕີ່ອ໌ ກັອຍ, ໄລ່ ຕາແບີບ ເຢຊູ: \"ອຶນເຈົາ ເອີຍ! ປຍາຍ໌ ບໍ, ໄຮ ໄປ່ອ໌ ໄລ່ ແຕ ດາວ?\" ");
INSERT INTO ncq_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ກະ ມານະ ແຕ ໄລ່ ກັອຍ ໄປ່ອ໌ ມານະ ກວາຍ ຊູລ ອັນ ກາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ, ຕາອັອຮ ກູຕູຣ ຢັ່ຮ ອາຕ່ຳ. ");
INSERT INTO ncq_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ເຢຊູ ປາຍ ກະ ໄລ່ ນ່ະໄນ່: \"ອຶນໂຈຍ! ໂອນ ໄລ່ ຕະ.\" ເຈີ່ ອັນ ອາແຕັດ ລັ່ຮ ກູຕູຣ ກວາຍ ກັອຍ ໂອນ ອັນ ແກີດ ແບຣັຮ. ");
INSERT INTO ncq_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ເຈີ່ ເຢຊູ ປາຍ ໂຈະ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ມັຮ ຕາຮານ ກາ ກຍາອ໌ ດຸງ ຊາງ ປື່ດ, ກະ ມັຮ ກວາຍ ເທົາແກ ຈຸ່ມເຈືອ, ໄລ່ ກາ ແຕີ່ອ໌ ໂກບ ອັນ ປາຍ: \"ນານ່ະ ເຍືາ ເດີງ ດາວ ກະ ຣາກັລ ແຕີ່ອ໌ ໂກບ ເກົາ? ເຍືາ ຄຶ່ດ ເກົາ ລາ ກວາຍ ຊາແວງ ບໍ? ");
INSERT INTO ncq_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ກູ່ ຣາໄງ ເກົາ ແອີດ ກະ ເຍືາ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ ມາ ເຍືາ ຕາ ເບີນ ຕະ ອຶນເຕົ່າ ກະ ເກົາ. ມາ ຕາໄງ ໄນ່ ເຍືາ ເຕ່ອ໌ ປວາຍ ຣາງຶ່ຮ ເຍືາ ເບີມ, ປວາຍ ຣານະ ການຳ.\" ");
INSERT INTO ncq_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ເຈີ່ ໄລ່ ໂກບ ເຢຊູ, ກະ ໄລ່ ເດີງ ອັນ ແຕີ່ອ໌ ປໍ ດຸງ ອັນ ກາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ. ເປໂຕ ຣາປວາຍ ເຢີ່ງໆ ອຶນຕູ່ນ ກຣັອງ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ແຕີ່ອ໌ ໄລ່ ມູ່ດ ຕຶ່ງ ຊັງອາຣ ດຸງ ກວາຍ ກັອຍ, ໄລ່ ຍຸ່ ອູ່ຍຮ. ເຈີ່ ໄລ່ ຕາກູ ອຶງແຮງ ອູ່ຍຮ ມັນຕຸ. ກະ ເປໂຕ ລາ ອຶງແຮງ ກະ ໄລ່ ກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ມາ ເບີນ ມານະ ມັນແຊມ ກາ ຕະ ຣານະ ຕຶ່ງ ດຸງ ກັອຍ ເຮີມ ເປໂຕ ຕາກູ ອຶງແຮງ ອູ່ຍຮ ອຶງກັອຍ. ອັນ ເນ່ ຊັຣກຼັ່ອງ ປໍ ເປໂຕ; ເຈີ່ ອັນ ປາຍ: \"ອັນ ໄນ່ ລາ ແອີດ ກະ ເຢຊູ ກັອຍ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ມາ ເປໂຕ ຕາ ເບີນ ງີ່ນ. ອັນ ປາຍ: \"ໄມ່ ອຶນໂຈຍ ລາ ອາມໍອ໌! ເກົາ ຕາ ເບີນ ດັງ ອັນ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ເຈີ່ ມາໂຮຍ ແຕີ່ອ໌ ກວາຍ ການໍ່ອ໌ ແອັນ ເຮີມ ເປໂຕ, ກະ ກວາຍ ກັອຍ ປາຍ: \"ໄມ່ ລາ ແຕ ມູ່ ກັອຍ ເຕ່.\" ມາ ເປໂຕ ຕາແອີຍ: \"ເກົາ ຕາ ແກີນ ແຕ ມູ່ ກັອຍ ແດັຮ!\" ");
INSERT INTO ncq_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ແວັດ ແຕ ກັອຍ ເບີນ ມັຮ ມວຍ ໂມງ ແອັນ, ແຕີ່ອ໌ ມານະ ຣາເລົາ ການໍ່ອ໌ ຊາກັ່ລ ເປໂຕ. ອັນ ປາຍ: \"ໄກຣ ລາລື່ ກວາຍ ໄນ່ ແອີດ ກະ ເຢຊູ, ຍ່ອນ ອັນ ລາ ກວາຍ ຄາລີເລ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ມາ ເປໂຕ ຕາແອີຍ: \"ເກົາ ຕາ ດັງ ອຶນເຕົ່າ ໄມ່ ປາຍ.\" ບັອງ ກາ ເປໂຕ ປາຍ ນ່ະກັອຍ, ອຶນຕຣວຍ ຕາກາຣ ແຕິ່. ");
INSERT INTO ncq_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ເຈີ່ ເຢຊູ ກູລຽວ ເນ່ ປໍ ເປໂຕ. ກະ ເປໂຕ ຊາແຍີ ລັ່ຮ ເຢຊູ ປາຍ ກະ ອັນ ນ່ະໄນ່: \"ແຕ ອຶນໂຍ່ງ ອຶນຕຣວຍ ຕາ ຢວາຮ ຕາກາຣ, ໄມ່ ກາແລີຍຮ ເກົາ ເບີນ ໄປ ເຮີບ.\" ");
INSERT INTO ncq_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ເຈີ່ ເປໂຕ ລັ່ອຮ ແຕ ກັອຍ ກະ ອັນ ເຍືາມ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ກວາຍ ກາ ກຍາອ໌ ເຢຊູ ໄລ່ ອາເຢ່ ພາມາດ ອັນ ກະ ປຍາຍຮ ອັນ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ໄລ່ ຕັນ ມັ່ດ ອັນ; ເຈີ່ ໄລ່ ປາຍ: \"ເອົາ ໄມ່ ປາຍ, ໄມ່ ກາ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ເນົ່າ ກາ ຈົ່ກ ໄມ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ກະ ຊາອຶ່ຍ ຣາມຶ່ຮ ການໍ່ອ໌ ໄລ່ ພາມາດ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ແຕີ່ອ໌ ປັ່ງ ຕາຣື່ບ ປັຣແນີ ແອັນ ມັຮ ກວາຍ ເທົາແກ ຈຸ່ມເຈືອ, ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ກະ ມັຮ ໄລ່ ກາ ອາຕີ ຄານອດ, ໄລ່ ໂຣ່ມ ມັນຕຸ. ເນົ່າ ເດີງ ເຢຊູ ແຕີ່ອ໌ ປໍ ໄລ່. ເຈີ່ ໄລ່ ຕາແບີບ ອັນ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","\"ໄມ່ ລາ ກຣີດ, ມາ ຕາ ເບີນ? ໂອນ ໄມ່ ອາຕີ ຮິ.\" ມາ ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ຄັນ ເກົາ ອາຕີ ເຍືາ, ລາ ເຍືາ ຕາ ເບີນ ຊາງັດ. ");
INSERT INTO ncq_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ກະ ຄັນ ເກົາ ຕາແບີບ ເຍືາ, ລາ ເຍືາ ຕາ ເບີນ ຕາແອີຍ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ມາ ແຕ ໄນ່ ເຈີ່ ປໍ ເມືາງ, ເກົາ ກອນ ເຢືາງ ແກີດ ກວາຍ, ຕາກູ ຢັ່ຮ ອາຕ່ຳ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ເຈີ່ ອຶນແຍ່ະ ມັຮ ໄລ່ ຕາແບີບ ອັນ: \"ໄມ່ ລາ ກອນ ເຢືາງ ເຈົາຣາຊີ ມາ ຕາ ເບີນ?\" ເຢຊູ ຕາແອີຍ ປາຍ: \"ປຍາຍ໌ ມັຮ ເຍືາ ປາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ເຈີ່ ໄລ່ ປາຍ: \"ຕາຈໍ່າ ໄຮ ອີ ຕາແບີບ ນັ່ອງ ກວາຍ ການໍ່ອ໌. ໄຮ ຊັອງ ແຕ ແບອ໌ ອັນ ເບີມ ປາຍ ລາ ແປະ.\" ");
INSERT INTO ncq_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ບັອງ ກາ ກັອຍ ອຶນແຍ່ະ ມູ່ ໄລ່ ຊັຣຮົງ ເດີງ ອາຊວຍ ເຢຊູ ແຕີ່ອ໌ ປໍ ປີລາດ. ");
INSERT INTO ncq_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ແອີດ ປໍ ກັອຍ ໄລ່ ຕູນ ເຢຊູ, ປາຍ: \"ຮິ ຣາມົຮ ກວາຍ ໄນ່, ອັນ ອີ ຕະ ໂອນ ກຣວາງ ໄຮ ແກີດ ຕາ ເບີນ ຊັງໄກຣ. ອັນ ປາຍ: 'ເຍືາ ອຶນໂຈຍ ມ່ອບ ປຣະ ປາຊີ ປໍ ເຕືາວ ປັຣເຍືາ ກວາຍ ໂຣມ.' ກະ ອັນ ປາຍ ອັນ ລາ ກຣີດ, ເຕືາວ ປັຣເຍືາ ກວາຍ ອິດຊະຣາເອລ.\" ");
INSERT INTO ncq_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ປີລາດ ຕາແບີບ ເຢຊູ: \"ເມ່ນ ມາ ຕາ ເບີນ ໄມ່ ລາ ເຕືາວ ປັຣເຍືາ ກວາຍ ອິດຊະຣາເອລ?\" ເຢຊູ ຕາແອີຍ ອັນ: \"ເມ່ນ, ປຍາຍ໌ ໄມ່ ປາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ເຈີ່ ປີລາດ ອາຕີ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ກະ ມັຮ ກອນແຊມ ປາຍ: \"ເກົາ ຕາ ເບີນ ຣາມົຮ ມວຍ ຣາມຶ່ຮ ອຶນເຕົ່າ ໂລ່ຍຮ ແຕ ກວາຍ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ມາ ໄລ່ ແປຣີ ເລືອຍໆ ໂອນ ປີລາດ ຕະ ເຢຊູ. ໄລ່ ປາຍ: \"ແຕ ຕາແບິ ລາລື່ ກວາຍ ໄນ່ ເປາະ ກູຈຸ່ກ ຕຶ່ງ ແຄງ ຄາລີເລ. ແວັດ ກັອຍ ອັນ ເປາະ ກູຈຸ່ກ ຕົວ ແຄງ ຢູດາຍ. ຊານໍ່ ອັນ ແຕີ່ອ໌ ກູຈຸ່ກ ປໍ ໄນ່ ແອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ພໍກາ ປີລາດ ຊັອງ ໄລ່ ປາຍ ແຕ ແຄງ ຄາລີເລ, ອັນ ຕາແບີບ ໄລ່ ກັອຍ, ເຢຊູ ລາ ກວາຍ ຄາລີເລ, ມາ ຕາ ເບີນ. ");
INSERT INTO ncq_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ເຈີ່ ແຕີ່ອ໌ ປີລາດ ດັງ ເຢຊູ ລາ ກວາຍ ຄາລີເລ, ອັນ ດັງ ຊົດ ເຢຊູ ລາ ປໍ ເຕືາວ ປັຣເຍືາ ເຮໂຣດ. ເຈີ່ ອັນ ແປຣີ ເນົ່າ ເດີງ ເຢຊູ ເປາະ ປໍ ເຮໂຣດ ແອັນ. ຕາໄງ ກັອຍ ເຮໂຣດ ແອີດ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ພໍກາ ເຮໂຣດ ເຮີມ ເຢຊູ, ອັນ ແອີນ ລາລື່. ດູ່ນ ເຈີ່ ອັນ ຢໍອ໌ ອີ ຣາມົຮ ເຢຊູ, ຍ່ອນ ອັນ ຊັອງ ຊາອຶ່ຍ ຣາມຶ່ຮ ເນົ່າ ອາຕີ ແຕ ເຢຊູ. ກະ ອັນ ຢໍອ໌ ອີ ເຮີມ ເຢຊູ ຕະ ຣານະ ຕາ ເກີ່ຍ ເຮີມ. ");
INSERT INTO ncq_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ເຈີ່ ອັນ ຕາແບີບ ເຢຊູ ຊາອຶ່ຍ ຣາມຶ່ຮ. ມາ ເຢຊູ ຕາ ເບີນ ຕາແອີຍ ອັນ ມວຍ ຣາມຶ່ຮ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ກະ ມັຮ ກວາຍ ອາຕີ ຄານອດ, ໄລ່ ແອີດ ຕາຢຶ່ງ ຕູນ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ເຈີ່ ເຮໂຣດ ກະ ຕາຮານ ອັນ ປາຍ ເຢຊູ ນ່ະ ອຶມປູຣ ຊາແນຮ. ກະ ໄລ່ ຣາຢອຍ໌ ອັນ. ໄລ່ ອາແຊິບ ເຢຊູ ອາຢັ່ອຮ ຕ່ອງ ນ່ະ ເຕືາວ ປັຣເຍືາ ເກີ່ຍ ແຊິບ. ເຈີ່ ໄລ່ ໂອນ ເນົ່າ ເປາະ ອາຊວຍ ລັ່ຮ ອັນ ປໍ ປີລາດ. ");
INSERT INTO ncq_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ພໍກາ ຕາໄງ ກັອຍ ເຮໂຣດ ກະ ປີລາດ ແກີດ ຣາຕອຍ ລັ່ຮ, ຍ່ອນ ແຕ ອຶນໂຍ່ງ ໄລ່ ມານະ ອວານ ມານະ. ");
INSERT INTO ncq_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ເຈີ່ ປີລາດ ປາໂຣມ ລັ່ຮ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ມັຮ ກວາຍ ຊົດ ການໍ່ອ໌, ກະ ມັຮ ກອນແຊມ; ");
INSERT INTO ncq_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ເຈີ່ ອັນ ປາຍ ໂຈະ ໄລ່ ນ່ະໄນ່: \"ເຍືາ ເດີງ ກວາຍ ໄນ່ ແຕີ່ອ໌ ປໍ ເກົາ, ເຍືາ ປາຍ ອັນ ປັຣຕຶ່ ກວາຍ ການໍ່ອ໌ ຕະ ຕາ ປຍາຍ໌. ມາ ເກົາ ຕາແບີບ ອັນ ເຈີ່ ຢັ່ຮ ເມືາງ ເຍືາ, ກະ ເກົາ ຕາ ເບີນ ຣາມົຮ ມວຍ ຣາມຶ່ຮ ອຶນເຕົ່າ ໂລ່ຍຮ ອັນ ຕະ ມັຮ ປັຣນາຍ ເຍືາ ຕູນ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ກະ ເຮໂຣດ ຕາ ເບີນ ຣາມົຮ ໂລ່ຍຮ ອຶນເຕົ່າ ເຕ່, ຍ່ອນ ອັນ ເດີງ ລັ່ຮ ກວາຍ ໄນ່ ແຕີ່ອ໌ ປໍ ເກົາ. ຕາ ເບີນ ຣາມຶ່ຮ ອຶນເຕົ່າ ອັນ ຕະ ມາ ເຕ່ອ໌ ກາຈີດ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ນ່ະກັອຍ ເກົາ ໂອນ ເນົ່າ ປຍາຍຮ ຊັອງ, ເຈີ່ ເກົາ ໂອນ ອາໂຣຍຮ.\" ");
INSERT INTO ncq_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ຍ່ອນ ຕາໄງ ກັອຍ ລາ ເນົ່າ ຕະ ຣີ່ດ ອາກຼັຮ, ອຶງເຄາະ ປີລາດ ອາໂຣຍຮ ມານະ ກວາຍ ເນົ່າ ໂກບ ດໍອ໌ ຕຶ່ງ ກໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ມາ ກວາຍ ກຼຶ່ງ ກັອຍ ປາຍ ມວຍ ເປຣິຮ ເຣ່ງ ລາລື່ ປາຍ: \"ອີດ ເດີງ ຊັອງ ອັນ ໄນ່! ອາໂຣຍຮ ໂອນ ຮິ ບາຣາບາ!\" ");
INSERT INTO ncq_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ບາຣາບາ ໄນ່ ລາ ອຶນນັ່ອງ ໂຕ່ດ ຕຶ່ງ ກໍ່ອ໌, ຍ່ອນ ອັນ ລາ ກວາຍ ກາ ກູຈຸ່ກ ຕຶ່ງ ເມືອງ ກັອຍ, ກະ ອັນ ກາຈີດ ກວາຍ ການໍ່ອ໌ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ປີລາດ ຢໍອ໌ ອີ ອາໂຣຍຮ ເຢຊູ; ເຈີ່ ອັນ ປາຍ ລັ່ຮ ໂຈະ ມັຮ ກວາຍ ກຼຶ່ງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ມາ ໄລ່ ກັອຍ ປາຍ ເຣ່ງ ລາລື່ ແອັນ: \"ແຕັຮ ອັນ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ! ແຕັຮ ອັນ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ!\" ");
INSERT INTO ncq_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ເຈີ່ ປີລາດ ຕາແບີບ ລັ່ຮ ໄລ່ ແຕີ່ອ໌ ໄປ ເຮີບ: \"ອຶນເຕົ່າ ໂລ່ຍຮ ເຍືາ ເຮີມ ອັນ ຕະ? ເກົາ ຕາ ເບີນ ຣາມົຮ ມວຍ ຣາມຶ່ຮ ອຶນເຕົ່າ ມາ ເຕ່ອ໌ ກາຈີດ ອັນ. ນ່ະກັອຍ ເກົາ ໂອນ ປຍາຍຮ ຊັອງ ອັນ, ເຈີ່ ເກົາ ໂອນ ອາໂຣຍຮ.\" ");
INSERT INTO ncq_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ມາ ໄລ່ ແປຣີ ເລືອຍໆ ປີລາດ, ກະ ໄລ່ ປາຍ ເຣ່ງ ລາລື່ ໂອນ ປີລາດ ແຕັຮ ເຢຊູ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ. ເຈີ່ ປີລາດ ຊາງັດ ປັຣນາຍ ໄລ່ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ນ່ະກັອຍ ປີລາດ ແປຣີ ເນົ່າ ຕະ ມັຮ ປັຣນາຍ ໄລ່ ກູຈຸ່ກ. ");
INSERT INTO ncq_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ກະ ອັນ ອາໂຣຍຮ ໂອນ ໄລ່ ບາຣາບາ, ອັນ ກາ ໄລ່ ແຊອ໌ ແຕ ອານໍ່. ກວາຍ ກັອຍ ເນົ່າ ໂກບ ດໍອ໌ ຕຶ່ງ ກໍ່ອ໌ ຍ່ອນ ອັນ ກູຈຸ່ກ ກວາຍ ຕຶ່ງ ເມືອງ ກັອຍ, ກະ ອັນ ກາຈີດ ກວາຍ ການໍ່ອ໌ ແຮີ. ມາ ປີລາດ ມ່ອບ ເຢຊູ ໂອນ ໄລ່. ໄລ່ ອີ ຕະ ນານ່ະ, ຕາມ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ບັອງ ກາ ໄລ່ ເດີງ ເຢຊູ ລັ່ອຮ, ໄລ່ ຣາມົຮ ມານະ ຣາມຶ່ຮ ຊີໂມນ ແຕ ກຣວາງ ກີເຣເນ ເຈົາ ແຕ ຢັ່ຮ ນໍ່ອ໌ ເມືອງ. ເຈີ່ ໄລ່ ໂກບ ອັນ, ກະ ແປຣີ ອັນ ໂອນ ໂດລ ອາລ່ອງ ຊັງກັງ ເຢຊູ. ເຈີ່ ອັນ ປວາຍ ຢັ່ຮ ກຣັອງ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ເບີນ ກຼຶ່ງ ລາລື່ ກວາຍ ປວາຍ ເຢຊູ. ກາ ມັນແຊມ ແຮີ ປວາຍ ອັນ, ກະ ໄລ່ ເຍືາມ. ");
INSERT INTO ncq_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ມາ ເຢຊູ ກູລຽວ ປໍ ກຣັອງ; ເຈີ່ ອັນ ປາຍ ກະ ໄລ່ ກັອຍ ນ່ະໄນ່: \"ມັນແຊມ ແຕ ເມືອງ ເຢຣູຊາເລັມ ເອີຍ! ເຍືາ ອຶນໂຈຍ ເຍືາມ ໂອນ ເກົາ. ເຍືາ ເຍືາມ ໂອນ ຈະ ເຍືາ ເບີມ ກະ ກອນ ອາໄກ ເຍືາ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ໄກຣ ລາລື່ ປັຣແນີ ມັນເຕຣືາ ແຕີ່ອ໌ ຕາໄງ ເນົ່າ ປາຍ: 'ບຸ່ນ ລາລື່ ໄລ່ ກາ ກວາຍ ກາແດງ, ໄລ່ ກາ ຕາ ເກີ່ຍ ເບີນ ກອນ. ກະ ບຸ່ນ ເຕ່ ໄລ່ ກາ ເບີນ ຕົຮ ມາ ຕາ ເກີ່ຍ ອາອູອ໌ ກອນ. ");
INSERT INTO ncq_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ຕຶ່ງ ຕາໄງ ກັອຍ ໄລ່ ແຊອ໌ ໂອນ ກົຮ ຣາລິ່ຮ ກາແຕດ ໄລ່ ກະ ໄລ່ ແຊອ໌ ໂອນ ແລັ່ຮ ກາແຕິບ ຕັຮ ໄລ່.'\" ");
INSERT INTO ncq_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ເຈີ່ ເຢຊູ ຊາກຳ ແອັນ ປາຍ: \"ຄັນ ອາລ່ອງ ອາມົ່ງ ມາ ເນົ່າ ໄປ່ອ໌ ຕັຮ, ແຮງ ກາຕິກ ອາລ່ອງ ຣັ່ອຮ ເນົ່າ ໄປ່ອ໌ ກາເລີຍ ແຕ ກັອຍ ແອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ກະ ເນົ່າ ເດີງ ບາຣ ນະ ກວາຍ ໂຕ່ດ ແອັນ, ອີ ກາຈີດ ມັນຕຸ ກະ ເຢຊູ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ພໍກາ ໄລ່ ແຕີ່ອ໌ ປໍ ອຶນຕຸ ເນົ່າ ດໍອ໌ 'ອຶນຕຸ ອຶງຮາງ ຕາຕາຣ ແປຼີ', ອຶນຕຸ ກັອຍ ແຕິ່ ເນົ່າ ກາຈີດ ໄລ່ ໄປ ນະ ກັອຍ, ກະ ແຕັຮ ໄລ່ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ. ເຢຊູ ເນົ່າ ແຕັຮ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ ອຶນດີ. ບາຣ ນະ ກວາຍ ໂຕ່ດ ກັອຍ ເນົ່າ ແຕັຮ ມານະ ຢັ່ຮ ອາຕ່ຳ, ມານະ ຢັ່ຮ ອາເວ່ຣ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ເຈີ່ ເຢຊູ ປາຍ: \"ອຶມປໍ່ ເອີຍ! ແຊອ໌ ອຶມປໍ່ ຕັຮ ໂລ່ຍຮ ໄລ່ ກາ ຕະ ເກົາ, ຍ່ອນ ໄລ່ ຕາ ເບີນ ດັງ ໄລ່ ຕະ ອຶນເຕົ່າ.\" ເຈີ່ ຕາຮານ ກັອຍ ອຶມແປອ໌ ເກຣີ່ງ ຕຳປັອກ ເຢຊູ ຣານາ ມັນຕັດ ອາຍຸ່, ອາແລ່ະ ເບີນ ລາ ໂທຍ. ");
INSERT INTO ncq_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ເບີນ ກວາຍ ຊົດ ແອີດ ຕາຢຶ່ງ ມັນຕຸ ກະ ກອນແຊມ ຢໍອ໌ ອີ ເນ່ ເຢຊູ. ມັຮ ກວາຍ ຊົດ ກັອຍ ອາເຢ່ ພາມາດ ເຢຊູ ປາຍ: \"ກວາຍ ການໍ່ອ໌ ເຕ່ອ໌ ອັນ ຈ່ອຍ ອາມົ່ງ. ຄັນ ອັນ ເມ່ນ ກຣີດ, ອັນ ກາ ເຢືາງ ເຈົາຣາຊີ ຣຽຮ, ໂອນ ອັນ ຈ່ອຍ ອາມົ່ງ ຈະ ອັນ ເບີມ.\" ");
INSERT INTO ncq_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ກະ ກວາຍ ຕາຮານ ແຮີ ອາເຢ່ ພາມາດ ອັນ ເຕ່. ໄລ່ ອາແວີຍ ໂອນ ອັນ ກາຢັບ ງ່ອຍ໌ ບຼັອງ ອຶນເຍາະ. ");
INSERT INTO ncq_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ໄລ່ ປາຍ: \"ຄັນ ໄມ່ ລາ ເຕືາວ ປັຣເຍືາ ກວາຍ ອິດຊະຣາເອລ, ເອົາ ໄມ່ ຈ່ອຍ ອາມົ່ງ ຈະ ໄມ່ ເບີມ.\" ");
INSERT INTO ncq_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ເຈີ່ ເນົ່າ ຄຽນ ດໍອ໌ ປັຣນາຍ ໄນ່ ແປີງ ແປຼີ ເຢຊູ ປາຍ: \"ກວາຍ ໄນ່ ລາ ເຕືາວ ປັຣເຍືາ ກວາຍ ອິດຊະຣາເອລ.\" ");
INSERT INTO ncq_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ໄລ່ ບາຣ ນະ ກວາຍ ກາ ເນົ່າ ແຕັຮ ມັນຕຸ ກະ ເຢຊູ, ອັນ ກາ ມານະ ພາມາດ ເຢຊູ ປາຍ: \"ຄັນ ໄມ່ ເມ່ນ ກຣີດ, ເອົາ ໄມ່ ຈ່ອຍ ຈະ ໄມ່ ເບີມ, ກະ ໄມ່ ຈ່ອຍ ຮິ ແຮີ.\" ");
INSERT INTO ncq_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ມາ ອັນ ກາ ມານະ ກັອຍ ກາແອັຮ ອັນ ກາ ປາຍ ນ່ະກັອຍ. ອັນ ປາຍ: \"ນານ່ະ ໄມ່ ຕາ ເບີນ ອຶງກັອຮ ເຢືາງ ເຈົາຣາຊີ ຕະ ໄມ່? ໄມ່ ກະ ອັນ ລາ ເນົ່າ ຕະ ມູເຈິງ ກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ໄຮ, ໄກຣ ເນົ່າ ຕະ, ຍ່ອນ ໄຮ ລາ ເນົ່າ ກູລັຮ ແດີອ໌ ມັຮ ຣານະ ໄຮ ຕະ. ມາ ກວາຍ ໄນ່ ຕາ ເບີນ ຕະ ໂລ່ຍຮ ອຶນເຕົ່າ.\" ");
INSERT INTO ncq_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ເຈີ່ ກວາຍ ກາ ກາແອັຮ ກັອຍ ປາຍ ແອັນ ໂຈະ ເຢຊູ ນ່ະໄນ່: \"ເຢຊູ ເອີຍ! ແຕີ່ອ໌ ໄມ່ ແກີດ ຊົດ ປັຣແນີ ມັນເຕຣືາ, ແຊອ໌ ໄມ່ ອຶນໂຈຍ ຊາລີຣ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ເຈີ່ ເຢຊູ ຕາແອີຍ ອັນ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ໄມ່, ຕາໄງ ໄນ່ ແຕິ່ ໄມ່ ແອີດ ກະ ເກົາ ຕຶ່ງ ກຣວາງ ອໍ ຕຶ່ງ ມັນລັ່ອງ.\" ");
INSERT INTO ncq_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ບັອງ ກາ ມານາງ ອີ ຕາແວີ ຕີລມູ່ລ, ແກີດ ການຳ ອຶນແຍ່ະ ຕຶ່ງ ກຣວາງ ກັອຍ ເຕົ່າ ແຕີ່ອ໌ ມານາງ ວີ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ມານາງ ແກີດ ຕາ ເບີນ ປັ່ງ ນັ່ອງ, ກະ ອາຣິ ກາ ເນົ່າ ກາງ ກຼັນ ກຼຸງ ຮີ່ບ ປັຣນາຍ ປັຣຄັນ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ ຣາແຮອ໌ ແກີດ ບາຣ ຊັນແຕຣອ໌. ");
INSERT INTO ncq_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ເຢຊູ ອູໂອຍ ເຣ່ງ ລາລື່, ປາຍ: \"ອຶມປໍ່ ເອີຍ! ເກົາ ແຊອ໌ ມ່ອບ ຣາເວືາຍ ເກົາ ປໍ ອາຕີ ໄມ່.\" ພໍກາ ຕາງິ່ດ ຊຽງ ອັນ ປາຍ, ຊາໄຕອ໌ ແຕິ່ ຣາງຶ່ຮ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ເບີນ ມານະ ກາ ຊົດ ມວຍ ຣ່ອຍ ນະ ຕາຮານ, ອັນ ເຮີມ ມັຮ ຣານະ ກາ ແກີດ ກັອຍ. ອັນ ຍ່ອງ ເຢືາງ ເຈົາຣາຊີ, ກະ ອັນ ປາຍ: \"ເມ່ນ ລາລື່ ກວາຍ ໄນ່ ລາ ຕານັ່ອງ ອໍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ກະ ອຶນແຍ່ະ ມັຮ ໄລ່ ກາ ໂຣ່ມ ແຈ່ະ ກັອຍ, ໄລ່ ຊັອງ ອຶງກັອຮ ລາລື່. ກະ ໄລ່ ແກິ່ ອາເປີ່ມ, ເຈີ່ ໄລ່ ເຈົາ ອຶນແຍ່ະ ປໍ ດຸງ. ");
INSERT INTO ncq_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ມັຮ ຊັຣກັ່ລ ເຢຊູ ກະ ມັນແຊມ ກາ ປວາຍ ອັນ ແຕ ແຄງ ຄາລີເລ, ໄລ່ ແອີດ ເຢີ່ງໆ ຕາງ່ອນ ເນ່ ມັຮ ຣານະ ກາ ເນົ່າ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ເບີນ ມານະ ຣາມຶ່ຮ ໂຢເຊັບ ແຕ ມູ່ ກາ ຊົດ ກວາຍ ອິດຊະຣາເອລ. ອັນ ລາ ກວາຍ ອໍ ກະ ຕານັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ອັນ ຕາ ເບີນ ປຣ່ອມ ກະ ມູ່ ກາ ຊົດ ກັອຍ ພໍກາ ໄລ່ ອີ ຕະ ເຢຊູ. ອັນ ລາ ແຕ ແຄງ ຢູດາຍ, ວີ່ລ ອາຣີມາທາຍ. ກະ ອັນ ອຶງກ່ອງ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ. ");
INSERT INTO ncq_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ໂຢເຊັບ ໄນ່ ເປາະ ແຕີ່ອ໌ ປໍ ປີລາດ ແຊອ໌ ກູມູ່ຍ໌ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ເຈີ່ ອັນ ແຕີ່ອ໌ ອາລິ່ຮ ກູມູ່ຍ໌ ເຢຊູ ແຕ ອາລ່ອງ ຊັງກັງ. ອັນ ຕວມ ແຕ ອາຣິ ກຼໍອ໌ ແຈບ ອໍ, ກະ ອັນ ດໍອ໌ ຕຶ່ງ ປີ່ງ ເນົ່າ ໄປອ໌ ຕຶ່ງ ຕາເມົາ. ປີ່ງ ກັອຍ ເນົ່າ ຕາ ເກີ່ຍ ດໍອ໌ ກວາຍ ຢວາຮ. ");
INSERT INTO ncq_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ຕາໄງ ກັອຍ ລາ ເນົ່າ ກຽມ ແຈ່ະ ອີ ແຕີ່ອ໌ ຕາໄງ ຣາລູ່. ");
INSERT INTO ncq_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ກວາຍ ມັນແຊມ ກາ ປວາຍ ເຢຊູ ແຕ ແຄງ ຄາລີເລ, ໄລ່ ເປາະ ເນ່ ເຈີ່ ປໍ ປີ່ງ ເຢຊູ. ກະ ໄລ່ ເຮີມ ກວາຍ ກັອຍ ດໍອ໌ ກູມູ່ຍ໌ ເຢຊູ ຕຶ່ງ ປີ່ງ. ");
INSERT INTO ncq_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ແວັດ ກັອຍ ໄລ່ ເຈົາ ປໍ ດຸງ. ໄລ່ ກຽມ ເກຣີ່ງ ປາຮວມ ໂຈະ ຕຶ່ງ ກູມູ່ຍ໌ ເຢຊູ. ກະ ຕຶ່ງ ຕາໄງ ຣາລູ່, ໄລ່ ຣາລູ່ ປວາຍ ແຕ ຄານອດ ປາຕັບ. ");
INSERT INTO ncq_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ເຈີ່ ຕາໄງ ມວຍ ຕຶ່ງ ອາທິດ ອຶນຕູ່ນ, ແຕ ປຼື່ ລາລື່ ມັຮ ມັນແຊມ ແຕີ່ອ໌ ປໍ ປີ່ງ ເຢຊູ. ໄລ່ ເດີງ ມັຮ ເກຣີ່ງ ປາຮວມ ກາ ໄລ່ ກຽມ ດໍອ໌ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ໄລ່ ເຮີມ ຕາເມົາ ກາ ກາຕັງ ງັ່ຮ ປີ່ງ ກັອຍ ເນົ່າ ວິ່ລ ອາລັ່ອຮ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ເຈີ່ ໄລ່ ມູ່ດ ຕຶ່ງ ປີ່ງ ກັອຍ, ມາ ໄລ່ ຕາ ເບີນ ເຮີມ ນັ່ອງ ກູມູ່ຍ໌ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ໄລ່ ແອີດ ຕາຢຶ່ງ ອຶງກັອຍ ຊັອງ ງຶ່ດ ລາລື່. ບັອງ ກາ ກັອຍ ໄລ່ ເຮີມ ບາຣ ນະ ຣາເລົາ ແຊິບ ອາຢັ່ອຮ ກຼໍອ໌ ລາລື່ ປາເລືາງ ໂຈະ ມັ່ດ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ມັຮ ມັນແຊມ ກັອຍ ຊັອງ ອຶງກັອຮ ລາລື່, ເຈີ່ ໄລ່ ປູບ ມັ່ດ ໄລ່ ປໍ ກູແຕອ໌. ມາ ກວາຍ ຣາເລົາ ກັອຍ ປາຍ ໂຈະ ໄລ່: \"ນານ່ະ ເຍືາ ຈໍ່ອ໌ ກວາຍ ອາມົ່ງ ອຶນໄນ່? ອຶນໄນ່ ລາ ເນົ່າ ດໍອ໌ ກວາຍ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ອັນ ກາ ເຍືາ ຈໍ່ອ໌, ອັນ ຕາ ເບີນ ແອີດ ອຶນໄນ່ ນັ່ອງ; ອັນ ອາມົ່ງ ລັ່ຮ ເຈີ່. ເຍືາ ຊາແຍີ ມັຮ ກາ ອັນ ຕະ ອຶນຕີ ກະ ເຍືາ ບັອງ ກາ ອຶນນັ່ອງ ອັນ ແອີດ ກະ ເຍືາ ຕຶ່ງ ແຄງ ຄາລີເລ. ");
INSERT INTO ncq_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ອັນ ປາຍ: 'ກອນ ເຢືາງ ແກີດ ກວາຍ ອຶງເຄາະ ເນົ່າ ມ່ອບ ປໍ ອາຕີ ກວາຍ ຕາ ອໍ. ເຈີ່ ໄລ່ ກາຈີດ ອັນ, ແຕັຮ ອັນ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ. ມາ ແຕີ່ອ໌ ຕາໄງ ໄປ ອັນ ອາມົ່ງ ລັ່ຮ.'\" ");
INSERT INTO ncq_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ເຈີ່ ມັຮ ມັນແຊມ ກັອຍ ຊາແຍີ ລັ່ຮ ມັຮ ປັຣນາຍ ເຢຊູ ອາຕີ. ");
INSERT INTO ncq_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ແວັດ ກັອຍ ໄລ່ ເຈົາ ແຕ ປີ່ງ ກັອຍ. ໄລ່ ອາຕີ ອຶນແຍ່ະ ມັຮ ຣາມຶ່ຮ ໄນ່ ໂອນ ໄລ່ ມັນຈິ່ດ ລາ ມານະ ກາ ຣຍານ ແຕ ເຢຊູ ດັງ. ກະ ໄລ່ ອາຕີ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ ການໍ່ອ໌ ດັງ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ມັນແຊມ ກາ ອາຕີ ຣາມຶ່ຮ ໄນ່ ໂອນ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ລາ ມາຣີ ແຕ ວີ່ລ ມັກດາລາ, ໂຢຮັນນາ, ກະ ມາຣີ ອຶມເປ່ອ໌ ຢາໂກໂບ. ເບີນ ມັນແຊມ ການໍ່ອ໌ ແຮີ ເປາະ ກະ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ມາ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ຕາ ເບີນ ຊາງັດ ປັຣນາຍ ມັນແຊມ ກັອຍ ປາຍ. ໄລ່ ຄຶ່ດ ປາຍ ມັຮ ມັນແຊມ ກັອຍ ອາຕີ ເມືາດ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ມາ ເປໂຕ ຢວຣ ຕາຢຶ່ງ. ອັນ ຕາລຸ່ຮ ເປາະ ແຕີ່ອ໌ ປໍ ປີ່ງ ເຢຊູ. ອັນ ປູບ ຕາແລນ ປໍ ປີ່ງ ກັອຍ, ເຈີ່ ອັນ ເຮີມ ແອີງ ອາຣິ ເມືາດ ຕຶ່ງ ປີ່ງ ກັອຍ. ເຈີ່ ອັນ ເຈົາ, ກະ ຣາງຶ່ຮ ອັນ ຊັອງ ງຶ່ດ ລາລື່ ພໍກາ ອັນ ເຮີມ ຣານະ ໄນ່ ແກີດ. ");
INSERT INTO ncq_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ຕຶ່ງ ຕາໄງ ກັອຍ ເບີນ ບາຣ ນະ ກວາຍ ກາ ຣຍານ ແຕ ເຢຊູ ເປາະ ຕຶ່ງ ຣານາ ເຈົາ ປໍ ເມືອງ ເອມາອູດ. ເມືອງ ກັອຍ ເຢີ່ງ ແຕ ເມືອງ ເຢຣູຊາເລັມ ເບີນ ມາຮ ມວຍ ຈິ່ດ ລາ ມວຍ ລັກ. ");
INSERT INTO ncq_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ບັອງ ກາ ໄລ່ ເປາະ, ໄລ່ ມານະ ຕະ ອຶນຕີ ກະ ມານະ ແຕ ມັຮ ຣາມຶ່ຮ ກາ ແກີດ ແຕ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ບັອງ ກາ ໄລ່ ຕະ ອຶນຕີ ນ່ະກັອຍ, ເຢຊູ ແຕີ່ອ໌ ປໍ ໄລ່ ກະ ອັນ ເປາະ ມັນຕຸ ກະ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ໄລ່ ເຮີມ ເຢຊູ, ມາ ມັ່ດ ໄລ່ ຕາ ເຕ່ອ໌ ຊາກັ່ລ ອັນ ຢວາຮ. ");
INSERT INTO ncq_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ເຢຊູ ຕາແບີບ ໄລ່: \"ຣາມຶ່ຮ ອຶນເຕົ່າ ເຍືາ ຕະ ອຶນຕີ ແຕ ອານໍ່, ບັອງ ກາ ເຍືາ ຕາຢັຮ ຕຶ່ງ ຣານາ?\" ເຈີ່ ໄລ່ ຕາງິ່ດ ກະ ມັ່ດ ມຸ່ຮ ໄລ່ ຕຸ່ຮ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ມານະ ແຕ ໄລ່ ບາຣ ນະ ກັອຍ, ຣາມຶ່ຮ ກະໂລປາ, ຕາແບີບ ປາຍ: \"ນານ່ະ ໄມ່ ລາ ຕາມອຍ ບໍ, ແຕ ໄມ່ ຕາ ເບີນ ດັງ ເນົ່າ ຕະ ອຶນເຕົ່າ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ ບາຣ ໄປ ຕາໄງ ໄນ່?\" ");
INSERT INTO ncq_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ເຢຊູ ຕາແບີບ ໄລ່: \"ຣານະ ອຶນເຕົ່າ ເນົ່າ ຕະ?\" ເຈີ່ ໄລ່ ອາຕີ ອັນ ປາຍ: \"ມັຮ ຣານະ ແຕ ເຢຊູ, ກວາຍ ແຕ ວີ່ລ ນາຊາເຣັດ. ອັນ ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ. ຄານະ ລາລື່ ຣານະ ອັນ ຕະ, ກະ ແບຼງ ລາລື່ ປັຣນາຍ ອັນ ປາຍ, ຢັ່ຮ ເມືາງ ເຢືາງ ເຈົາຣາຊີ ກະ ອຶນແຍ່ະ ມັຮ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ມາ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ກະ ມັຮ ກວາຍ ການໍ່ອ໌ ກາ ຊົດ ຮິ ແຮີ, ໄລ່ ມ່ອບ ໂອນ ເນົ່າ ກາຈີດ ຕັຮ ອັນ, ແຕັຮ ອັນ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ. ");
INSERT INTO ncq_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ມາ ບັອງ ກັອຍ ຮິ ຄຶ່ດ ອັນ ລາ ກວາຍ ເຢືາງ ເຈົາຣາຊີ ຣຽຮ ດໍອ໌ ຈ່ອຍ ອາມົ່ງ ກວາຍ ອິດຊະຣາເອລ. ຊານໍ່ ເບີນ ໄປ ຕາໄງ ເຈີ່ ແຕ ເນົ່າ ຕະ ມັຮ ຣານະ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ກະ ເບີນ ກວາຍ ມັນແຊມ ຕຶ່ງ ມູ່ ຮິ ຕະ ອຶນຕີ ໂອນ ຮິ ຊັອງ ງຶ່ດ ລາລື່. ໄລ່ ກັອຍ ເປາະ ແຕ ປຼື່ ລາລື່ ແຕີ່ອ໌ ປໍ ປີ່ງ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ໄລ່ ຕາ ເບີນ ຣາມົຮ ກູມູ່ຍ໌ ເຢຊູ; ເຈີ່ ໄລ່ ເຈົາ ລັ່ຮ. ໄລ່ ປາຍ ໄລ່ ເຮີມ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ, ກະ ເທວາດາ ກັອຍ ອາຕີ ໄລ່ ປາຍ ເຢຊູ ອາມົ່ງ ລັ່ຮ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ກະ ເບີນ ກວາຍ ການໍ່ອ໌ ແຕ ມູ່ ຮິ ເປາະ ປໍ ປີ່ງ ກັອຍ ເຕ່. ໄລ່ ເຮີມ ນ່ະ ມັນແຊມ ກັອຍ ອາຕີ. ມາ ໄລ່ ຕາ ເບີນ ເຮີມ ເຢຊູ.\" ");
INSERT INTO ncq_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ເຈີ່ ເຢຊູ ອາຕີ ໄລ່ ບາຣ ນະ ກັອຍ ປາຍ: \"ເຍືາ ລາ ເຈຍ ຊາກູລ, ກະ ກຣໍ ລາລື່ ເຍືາ ຊາອຳ ມັຮ ກາ ປັຣນາຍ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ປາຍ ແຕ ອຶມແບິ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ນານ່ະ ເຍືາ ຕາ ເບີນ ດັງ ກຣີດ ອຶງເຄາະ ຈີວ໌ ຕຸ່ຮ ກັ່ດ ໄນ່, ໂອນ ເຕ່ອ໌ ອັນ ເບີນ ອຳນາດ ອາງອື່ຣ ລາລື່?\" ");
INSERT INTO ncq_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ເຈີ່ ເຢຊູ ຕະ ອຶນຕີ ລັ່ຮ ໂອນ ໄລ່ ດັງ ອຶນແຍ່ະ ແຕ ມັຮ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ປາຍ ແຕ ອັນ, ແຕ ປັຣນາຍ ໂມເຊ ຄຽນ ໂອນ ເຕົ່າ ແຕີ່ອ໌ ອຶນແຍ່ະ ປັຣນາຍ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ອາຕີ. ");
INSERT INTO ncq_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ແຈ່ະ ໄລ່ ອີ ແຕີ່ອ໌ ເມືອງ ກາ ໄລ່ ບາຣ ນະ ກັອຍ ຢໍອ໌ ອີ ແອີດ, ເຢຊູ ຕະ ນ່ະ ອັນ ອີ ເປາະ ເປຼີຍ ເມືອງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ມາ ໄລ່ ບາຣ ນະ ກັອຍ ກາຕັ່ອງ ດໍອ໌ ອັນ ກະ ປາຍ: \"ແຊອ໌ ໄມ່ ແອີດ ກະ ຮິ ເວືາຍ. ຕາບື່ ເຈີ່, ແຈ່ະ ອີ ຊາເດົາ.\" ເຈີ່ ເຢຊູ ມູ່ດ ແອີດ ກະ ໄລ່ ອຶງກັອຍ ເວືາຍ. ");
INSERT INTO ncq_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ແຕີ່ອ໌ ໄລ່ ຕາກູ ຈາ, ເຢຊູ ອີດ ໂດຍ ບຸຮ. ອັນ ຊາແອີນ ເຢືາງ ເຈົາຣາຊີ. ເຈີ່ ອັນ ປີຮ ໂດຍ ບຸຮ ກັອຍ ອາແວີຍ ໂອນ ໄລ່ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ເຈີ່ ມັ່ດ ໄລ່ ເບີນ ຊາກັ່ລ ອັນ. ມາ ບັອງ ກາ ກັອຍ ແຕິ່ ປາຢຶ່ຮ ເຢຊູ, ໄລ່ ຕາ ເບີນ ເຮີມ ນັ່ອງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ກະ ໄລ່ ມານະ ຕາແບີບ ມານະ ປາຍ: \"ເມ່ນ ມາ ຕາ ເບີນ, ຣາງຶ່ຮ ໄຮ ຊັອງ ຣໍ່ອ໌ ອໍ ລາລື່ ບັອງ ກາ ອັນ ຕະ ອຶນຕີ ກະ ໄຮ ຕາໄງ ໄນ່ ຕຶ່ງ ຣານາ, ກະ ບັອງ ກາ ອັນ ອາຕີ ໂອນ ໄຮ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ?\" ");
INSERT INTO ncq_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ເຈີ່ ໄລ່ ບາຣ ນະ ກັອຍ ຢວຣ ແຕິ່; ໄລ່ ລົ່ບ ເຈົາ ລັ່ຮ ປໍ ເມືອງ ເຢຣູຊາເລັມ ແອັນ. ໄລ່ ຣາມົຮ ມູ່ ໄລ່ ມັນຈິ່ດ ລາ ມານະ ກາ ຣຍານ ແຕ ເຢຊູ ແອີດ ໂຣ່ມ ມັນຕຸ ກະ ກວາຍ ການໍ່ອ໌ ແຮີ. ນ່ະກັອຍ ໄລ່ ບາຣ ນະ ກັອຍ ເບີນ ຊັອງ ເຈີ່ ມັຮ ມູ່ ກາ ໂຣ່ມ ກັອຍ ຕະ ອຶນຕີ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","\"ໄກຣ ລາລື່ ອຶນເຈົາ ໄຮ ອາມົ່ງ ລັ່ຮ! ຊີໂມນ ຣາມົຮ ເຈີ່ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ເຈີ່ ໄລ່ ບາຣ ນະ ກັອຍ ແອັນ ອາຕີ ໂອນ ໄລ່ ກາ ໂຣ່ມ ກັອຍ ແຕ ຣານະ ໄລ່ ເຮີມ ຕຶ່ງ ຣານາ, ກະ ອາຕີ ແຕ ໄລ່ ຊາກັ່ລ ເຢຊູ ບັອງ ກາ ອັນ ປີຮ ໂດຍ ບຸຮ. ");
INSERT INTO ncq_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ໄລ່ ອຶນນັ່ອງ ຕະ ອຶນຕີ ນ່ະກັອຍ, ກູໂຕ ເຢຊູ ແຕິ່ ປາລົ່ຮ ອຶນດີ ໄລ່. ກະ ອັນ ປາຍ ໂຈະ ໄລ່ ນ່ະໄນ່: \"ເຍືາ ແອີດ ອຽນ ອໍ.\" ");
INSERT INTO ncq_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ມາ ໄລ່ ອຶງກັອຮ ລາລື່ ກະ ກາໄກ່ຮ, ຍ່ອນ ໄລ່ ຄຶ່ດ ປາຍ ກູມູ່ຍ໌ ເຢຊູ ລື່ດ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ເຈີ່ ເຢຊູ ຕາແບີບ ໄລ່ ປາຍ: \"ນານ່ະ ເຍືາ ອຶງກັອຮ? ກະ ນານ່ະ ເຍືາ ອຶນນັ່ອງ ກູຄຶ່ດ ຕາມມັຮ ຕຶ່ງ ຣາງຶ່ຮ ເຍືາ? ");
INSERT INTO ncq_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ເຍືາ ເນ່ ປໍ ອາເຢີງ ອາຕີ ເກົາ. ກູໂຕ ຈະ ເກົາ ແຕິ່ ອາໄນ່. ເຍືາ ແຕີ່ອ໌ ຊາປ່ະ ຊາລີອ໌ ເນ່ ເກົາ. ເຈີ່ ເຍືາ ດັງ ເກົາ ລາ ເມ່ນ ຈະ ກວາຍ, ຍ່ອນ ກູມູ່ຍ໌ ຕາ ເບີນ ເບີນ ໄຊອ໌ ກະ ອຶງຮາງ ນ່ະ ເກົາ ເບີນ.\" ");
INSERT INTO ncq_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ອັນ ອາປັຮ ໂອນ ໄລ່ ເຮີມ ອາເຢີງ ອາຕີ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ໄລ່ ຕາ ເບີນ ຊາງັດ ຢວາຮ ຍ່ອນ ໄລ່ ຊັອງ ຣໍ່ອ໌ ລາລື່ ກະ ໄລ່ ງຶ່ດ. ນ່ະກັອຍ ເຢຊູ ປາຍ ໂຈະ ໄລ່: \"ເຍືາ ເບີນ ເກຣີ່ງ ຊັຣນາ ຈາ ຕຶ່ງ ໄນ່ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ໄລ່ ໂອນ ປໍ ອັນ ມວຍ ແບະ ອາກາ ອັງ. ");
INSERT INTO ncq_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ເຈີ່ ອັນ ອີດ ຈາ ຢັ່ຮ ເມືາງ ໄລ່ ແຕິ່. ");
INSERT INTO ncq_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ກະ ເຢຊູ ປາຍ ນ່ະໄນ່ ໂຈະ ໄລ່: \"ອຶນແຍ່ະ ມັຮ ປັຣນາຍ ໄນ່ ເກົາ ອາຕີ ປໍ ເຍືາ ບັອງ ກາ ອຶນນັ່ອງ ເກົາ ແອີດ ກະ ເຍືາ. ເກົາ ອາຕີ ເຍືາ ອຶງເຄາະ ແຕີ່ອ໌ ມັຮ ຣາມຶ່ຮ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ແຕ ເກົາ ແຕ ອຶມແບິ ເຈີ່ ຕຶ່ງ ຄານອດ ໂມເຊ ໂອນ, ຕຶ່ງ ປັຣນາຍ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ປາຍ, ກະ ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ລ່ຳ ຍ່ອງ ເຢືາງ ເຈົາຣາຊີ ແຮີ.\" ");
INSERT INTO ncq_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ເຈີ່ ເຢຊູ ເປິຮ ຣາງຶ່ຮ ໄລ່ ໂອນ ໄລ່ ດັງ ແຈງ ມັຮ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ອັນ ອາຕີ ໄລ່ ປາຍ: \"ເນົ່າ ຄຽນ ເຈີ່ ແຕ ກຣີດ ອຶງເຄາະ ອັນ ຈີວ໌ ຊາອຶ່ຍ ຣາມຶ່ຮ ຕຸ່ຮ ກັ່ດ, ກະ ເນົ່າ ກາຈີດ ອັນ, ມາ ແຕີ່ອ໌ ຕາໄງ ໄປ ອັນ ຢວຣ ອາມົ່ງ ລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ກະ ຍ່ອນ ແຕ ຣາມຶ່ຮ ອັນ, ອຶງເຄາະ ເນົ່າ ອາຕີ ໂອນ ກູ່ ກຣວາງ ດັງ, ກວາຍ ອຶງເຄາະ ຕັຮ ຣາງຶ່ຮ ຕຍາ ປຽນ ແກີດ ຣາງຶ່ຮ ຕາໄມ ແອັນ, ໂອນ ເຕ່ອ໌ ເຢືາງ ເຈົາຣາຊີ ຕັຮ ໂລ່ຍຮ ໄລ່. ແຕ ຕາແບິ ລາລື່ ອຶງເຄາະ ເນົ່າ ອາຕີ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ. ");
INSERT INTO ncq_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ເຍືາ ແຕິ່ ເກົາ ໂອນ ເດີງ ອາຕີ ປັຣນາຍ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ໄກຣ ລາລື່ ເກົາ ອີ ໂອນ ເຍືາ ເບີນ ຣາມຶ່ຮ ກາ ອຶມປໍ່ ເກົາ ເອີອ໌ ເຈີ່ ອີ ໂອນ ເຍືາ. ມາ ອຶງເຄາະ ເຍືາ ເກຣາະ ເວືາຍ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ ເຕົ່າ ແຕີ່ອ໌ ເຍືາ ເບີນ ອຳນາດ ແຕ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ແຊງ ແອີດ ກະ ເຍືາ.\" ");
INSERT INTO ncq_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ເຈີ່ ເຢຊູ ເດີງ ໄລ່ ລັ່ອຮ ແຕ ເມືອງ ກັອຍ ເປາະ ແຈ່ະ ປໍ ວີ່ລ ເບັດທານີ ແອັນ. ອັນ ອາແຣິ່ ບາຣ ກັ່ຮ ອາຕີ; ເຈີ່ ເກົາແຊອ໌ ເຢືາງ ເຈົາຣາຊີ ໂອນ ບຸ່ນ ປໍ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ບັອງ ກາ ອັນ ອຶນນັ່ອງ ເກົາແຊອ໌ ບຸ່ນ ໂອນ ໄລ່, ບັອງ ກັອຍ ແຕິ່ ອັນ ລັ່ອຮ ແຕ ໄລ່ ຊັອຮ ປໍ ມັນລັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ໄລ່ ຊາງ ເຢຊູ; ເຈີ່ ເຈົາ ລັ່ຮ ປໍ ເມືອງ ເຢຣູຊາເລັມ, ຊັອງ ຣໍ່ອ໌ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ໄລ່ ເປາະ ເລືອຍໆ ປໍ ດຸງ ຊາງ ປື່ດ, ຍ່ອງ ກະ ຊາແອີນ ເຢືາງ ເຈົາຣາຊີ.");
INSERT INTO ncq_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ແຕ ອຶມແບິ, ອຶນໂຍ່ງ ແຕ ເຢືາງ ເຈົາຣາຊີ ຕາ ຢວາຮ ແຕງ ມວຍ ຣາມຶ່ຮ ອຶນເຕົ່າ, ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ເບີນ ເຈີ່. ອັນ ແອີດ ເລືອຍໆ ກະ ເຢືາງ ເຈົາຣາຊີ. ອັນ ລາ ເມ່ນ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ອັນ ແອີດ ກະ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ຍ່ອນ ແຕ ປັຣນາຍ ອັນ, ເຢືາງ ເຈົາຣາຊີ ແຕງ ຕຸ່ກ ຣາມຶ່ຮ ຕຶ່ງ ປື່ນ ກະ ຕຶ່ງ ແປີງ. ຕາ ເບີນ ມວຍ ຣາມຶ່ຮ ອຶນເຕົ່າ ເຢືາງ ເຈົາຣາຊີ ແຕງ ມາ ຕາ ເບີນ ຍ່ອນ ແຕ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ຍ່ອນ ແຕ ປັຣນາຍ ອັນ, ກູ່ ຣາມຶ່ຮ ເຕ່ອ໌ ອາມົ່ງ, ກະ ປັຣນາຍ ອາມົ່ງ ກັອຍ ລາ ກັ່ລ ປັ່ງ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ກັ່ລ ປັ່ງ ກັອຍ ປາເລືາງ ຕຶ່ງ ອຶນຕຸ ການຳ, ກະ ການຳ ຕາ ເຣືາບ ອາປິ່ດ ປັ່ງ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","ເບີນ ມານະ ກາ ເຢືາງ ເຈົາຣາຊີ ແປຣີ ແຕີ່ອ໌ ອາຕີ ໂອນ ກວາຍ ດັງ ແຕ ກັ່ລ ປັ່ງ ໄນ່. ຣາມຶ່ຮ ອັນ ລາ ໂຢຮັນ. ອັນ ຢໍອ໌ ກູ່ ນະ ກວາຍ ເຕ່ອ໌ ຊາອຳ ຍ່ອນ ແຕ ອັນ ອາຕີ. ");
INSERT INTO ncq_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ໂຢຮັນ ລາ ຕາ ແກີນ ກັ່ລ ປັ່ງ, ມາ ໂຢຮັນ ແຕີ່ອ໌ ອາຕີ ແຕ ກັ່ລ ປັ່ງ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ກັ່ລ ປັ່ງ ໄນ່ ລາ ເຢຊູ ກຣີດ. ອັນ ເດີງ ປັ່ງ ກາ ປຍາຍ໌ ລາລື່. ອັນ ແຕີ່ອ໌ ປໍ ກູແຕອ໌ ໄນ່ ກະ ອັນ ປາເລືາງ ກູ່ ຣາງຶ່ຮ ກວາຍ ຕຶ່ງ ກູແຕອ໌ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ອັນ ແອີດ ຕຶ່ງ ກູແຕອ໌ ໄນ່. ກູແຕອ໌ ໄນ່ ລາ ອັນ ແຕິ່ ແຕງ, ມາ ກວາຍ ແອີດ ຕຶ່ງ ກູແຕອ໌ ໄນ່, ໄລ່ ຕາ ເບີນ ຊາກັ່ລ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ອັນ ແຕີ່ອ໌ ປໍ ກຣວາງ ອັນ ເບີມ, ມາ ກວາຍ ກັອຍ ຕາ ເບີນ ຣັ່ບ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ຄັນ ກວາຍ ອາແລ່ະ ກາ ຣັ່ບ ກະ ຊາອຳ ອັນ, ອັນ ໂອນ ມັຮ ກວາຍ ກັອຍ ເບີນ ຊິດ ແກີດ ກອນ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ຕາ ແກີນ ໄລ່ ແກີດ ກອນ ເຢືາງ ເຈົາຣາຊີ ນ່ະ ມັນແຊມ ຣັ່ຮ ກອນ, ແຕີລາ ຍ່ອນ ແຕ ແກີດ ລາກວຍ ກາຢາອ໌, ແຕີລາ ຕາປູ່ນ ຣາງຶ່ຮ ກາຢາອ໌ ຢໍອ໌. ມາ ໄລ່ ແກີດ ກອນ ເຢືາງ ເຈົາຣາຊີ ຍ່ອນ ເຢືາງ ເຈົາຣາຊີ ແຕງ. ");
INSERT INTO ncq_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ນ່ະກັອຍ, ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແກີດ ຈະຈັ່ນ ມູເຈິງ ໄຮ ກວາຍ ເຕ່. ອັນ ແອີດ ມັນຕຸ ກະ ໄຮ. ໄຮ ເຮີມ ເຈີ່ ອັນ ເບີນ ອາງອື່ຣ ປື່ດ ລາລື່. ແອີງ ກອນ ເຢືາງ ເຈົາຣາຊີ ຊັອງ ເຕ່ອ໌ ເບີນ ອາງອື່ຣ ໄນ່. ອັນ ເບີນ ຣາງຶ່ຮ ຢໍອ໌ ອີ ຈ່ອຍ ເມືາດ ມັຮ ກວາຍ, ກະ ອັນ ອາປັຮ ໂອນ ໄຮ ດັງ ຣານະ ປຍາຍ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ໂຢຮັນ ເປາະ ຕະ ອຶນຕີ ແຕ ເຢຊູ ປາຍ: \"ມານະ ໄນ່, ເກົາ ອາຕີ ເຈີ່ ແຕ ອັນ: 'ອັນ ແຕີ່ອ໌ ອຶນຕູ່ນ ເກົາ, ມາ ອັນ ເບີນ ອຳນາດ ປື່ດ ກາເລີຍ ແຕ ເກົາ. ແຕ ອຶນໂຍ່ງ ເກົາ ຕາ ຢວາຮ ແກີດ, ອັນ ເບີນ ເຈີ່ ຕຶ່ງ ມັນລັ່ອງ.' ");
INSERT INTO ncq_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ອຶນແຍ່ະ ກູ່ ນະ ໄຮ ເບີນ ບຸ່ນ ຊາອຶ່ຍ ເຈີ່, ຍ່ອນ ອັນ ຈ່ອຍ ເມືາດ ເລືອຍໆ ໄຮ. ");
INSERT INTO ncq_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ເຢືາງ ເຈົາຣາຊີ ໂອນ ຈຸ່ມ ອິດຊະຣາເອລ ເບີນ ຄານອດ ອັນ ຣານາ ໂມເຊ, ມາ ຣານະ ຈ່ອຍ ເມືາດ ກະ ຣານະ ປຍາຍ໌ ແຕີ່ອ໌ ແຕ ເຢຊູ ກຣີດ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ຕາ ເບີນ ກວາຍ ອາແລ່ະ ເບີນ ເຮີມ ເຢືາງ ເຈົາຣາຊີ. ເຢືາງ ເຈົາຣາຊີ ເບີນ ແອີງ ມານຳ ກອນ ຊັອງ. ອັນ ລາ ຣາລີ ກະ ເຢືາງ ເຈົາຣາຊີ, ກະ ອັນ ເບີນ ມູ ຣາງຶ່ຮ ກະ ອຶມປໍ່ ອັນ. ອັນ ອາຕີ ໂອນ ກວາຍ ດັງ ແຕ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ໄນ່ ລາ ປັຣນາຍ ໂຢຮັນ ອາຕີ ບັອງ ກາ ກວາຍ ຊົດ ອິດຊະຣາເອລ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ ແປຣີ ກວາຍ ແຕ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ກະ ແຕ ມູ່ ເລວີ ແຕີ່ອ໌ ຕາແບີບ ໂຢຮັນ ປາຍ: \"ໄມ່ ລາ ເນົ່າ?\" ");
INSERT INTO ncq_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ໂຢຮັນ ງີ່ນ ມັຮ ຣານະ ອັນ ຕະ. ອັນ ຕາ ເບີນ ແກອ໌ ອຶນເຕົ່າ. ອັນ ຕາແອີຍ ລັ່ຮ ໄລ່ ກັອຍ ປາຍ: \"ເກົາ ລາ ຕາ ແກີນ ກຣີດ.\" ");
INSERT INTO ncq_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ໄລ່ ກັອຍ ຕາແບີບ ລັ່ຮ ຊາ ໂຢຮັນ ປາຍ: \"ຄັນ ນ່ະກັອຍ, ໄມ່ ລາ ເນົ່າ? ໄມ່ ລາ ເອລີຢາ ບໍ?\" ໂຢຮັນ ຕາແອີຍ ລັ່ຮ: \"ເກົາ ລາ ຕາ ແກີນ ເອລີຢາ.\" ໄລ່ ຕາແບີບ ລັ່ຮ ອັນ: \"ໄມ່ ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ກາ ຮິ ອຶງກ່ອງ ບໍ?\" ໂຢຮັນ ຕາແອີຍ ລັ່ຮ: \"ຕາ ແກີນ.\" ");
INSERT INTO ncq_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ໄລ່ ຕາແບີບ ລັ່ຮ ຊາ: \"ຄັນ ນ່ະກັອຍ, ໄມ່ ລາ ເນົ່າ? ແຊອ໌ ໄມ່ ອາຕີ ຮິ ໂອນ ຮິ ເດີງ ປັຣນາຍ ໄມ່ ເຈົາ ປໍ ກວາຍ ກາ ແປຣີ ຮິ ແຕີ່ອ໌ ປໍ ໄນ່. ແຊອ໌ ໄມ່ ງີ່ນ ໄມ່ ລາ ເນົ່າ?\" ");
INSERT INTO ncq_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ໂຢຮັນ ຕາແອີຍ ລັ່ຮ ມູເຈິງ ປັຣນາຍ ເອຊາຢາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ປາຍ: \"ເກົາ ລາ 'ຊຽງ ຊາບາວ ອາຕີ ເຣ່ງ ລາລື່ ແຕ ຕຍາຮ ປາຍ: ເຍືາ ຕະ ໂອນ ຕານັ່ອງ ຣານາ ອຶນເຈົາ ໄຮ.'\" ");
INSERT INTO ncq_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ເບີນ ກວາຍ ແຕ ຈຸ່ມ ພາຣີຊາຍ ແຕີ່ອ໌ ");
INSERT INTO ncq_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ຕາແບີບ ລັ່ຮ ໂຢຮັນ: \"ຄັນ ໄມ່ ຕາ ແກີນ ກຣີດ, ແຕີລາ ເອລີຢາ, ແຕີລາ ມານະ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ນານ່ະ ໄມ່ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ກວາຍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","ໂຢຮັນ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ເກົາ ຕະ ຣີ່ດ ໄນ່ ໂອນ ເຍືາ ຕຶ່ງ ແດີອ໌, ມາ ເບີນ ມານະ ແຕີ່ອ໌ ອຶນຕູ່ນ ເກົາ. ຊານໍ່ ອັນ ແອີດ ຕາຢຶ່ງ ອຶນດີ ເຍືາ, ມາ ເຍືາ ຕາ ເບີນ ຊາກັ່ລ ອັນ. ເກົາ ລາ ຕາ ເບີນ ປຍາຍ໌ ໂອນ ອາແລັ່ຮ ອຶນໄຊ ແກີບ ແຕ ອາເຢີງ ອັນ, ຍ່ອນ ເກົາ ລາ ອຳນາດ ກາ ແກດ ລາລື່.\" ");
INSERT INTO ncq_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ອຶນແຍ່ະ ຣານະ ໄນ່ ແກີດ ຕຶ່ງ ວີ່ລ ເບັດທານີ, ຢັ່ຮ ອຶນຕົ່ຮ ຕາເລ່ ຈໍແດນ ກັ່ຮ ມານາງ ລັ່ອຮ ປໍ ອຶນຕຸ ໂຢຮັນ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌. ");
INSERT INTO ncq_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ມາຮ ຕາໄງ ປັຣແນີ ແອັນ, ໂຢຮັນ ເຮີມ ເຢຊູ ແຕີ່ອ໌ ປໍ ອັນ, ເຈີ່ ອັນ ປາຍ: \"ຕິຮ! ເຍືາ ເນ່! ອັນ ລາ ແກະ ກອນ ແຕ ເຢືາງ ເຈົາຣາຊີ. ອັນ ລາ ນ່ະ ຊັນຕຣັ່ນ ເນົ່າ ກຍາກ ຊາງ ໂອນ ເຢືາງ ເຈົາຣາຊີ, ໂອນ ເຢືາງ ເຈົາຣາຊີ ຕັຮ ໂລ່ຍຮ ອຶນແຍ່ະ ມັຮ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ເກົາ ອາຕີ ເຈີ່ ແຕ ອັນ ປາຍ: 'ເບີນ ມານະ ແຕີ່ອ໌ ອຶນຕູ່ນ ເກົາ, ມາ ອຳນາດ ອັນ ປື່ດ ກາເລີຍ ແຕ ເກົາ. ແຕ ອຶນໂຍ່ງ ເກົາ ຕາ ຢວາຮ ແກີດ, ລາ ອັນ ເບີນ ເຈີ່ ຕຶ່ງ ມັນລັ່ອງ.' ");
INSERT INTO ncq_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ແຕ ອຶນໂຍ່ງ, ເກົາ ຕາ ເບີນ ດັງ ເຕ່ ອັນ. ມາ ເກົາ ແຕີ່ອ໌ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ຈຸ່ມ ອິດຊະຣາເອລ ເຕ່ອ໌ ດັງ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ໂຢຮັນ ອາຕີ ລັ່ຮ ມັຮ ຣານະ ອັນ ເຮີມ ເຈີ່ ປາຍ: \"ເກົາ ເຮີມ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ແຊງ ແຕ ມັນລັ່ອງ ນ່ະ ແຈມ ປາເຣືາດ. ເຈີ່ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ແອີດ ເລີ່ຍ ກະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ຕາໄງ ກັອຍ ເກົາ ຕາ ຢວາຮ ດັງ ເຕ່ ມັຮ ຣານະ ເຢຊູ ຢໍອ໌ ອີ ຕະ, ມາ ເຢືາງ ເຈົາຣາຊີ, ອັນ ກາ ແປຣີ ເກົາ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌, ອາຕີ ເກົາ ປາຍ: 'ແຕີ່ອ໌ ໄມ່ ເຮີມ ເບີນ ມານະ ກາ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ແຊງ ແອີດ, ມານະ ໄນ່ ລາ ກວາຍ ກາ ຕະ ຣີ່ດ ໄນ່ ຣານາ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ.' ");
INSERT INTO ncq_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ເກົາ ເຮີມ ເຈີ່ ຣານະ ໄນ່, ກະ ເກົາ ອາຕີ ເຍືາ ຕານັ່ອງ ລາລື່, ເຢຊູ ໄນ່ ລາ ເມ່ນ ກອນ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ຕາໄງ ປັຣແນີ ໂຢຮັນ ກາ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ແອີດ ອຶງກັອຍ ຊາ ມັນຕຸ ກະ ກວາຍ ກາ ຣຍານ ແຕ ອັນ ບາຣ ນະ. ");
INSERT INTO ncq_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ພໍກາ ອັນ ເຮີມ ເຢຊູ ເປາະ ພາ, ໂຢຮັນ ເນ່ ປໍ ເຢຊູ, ກະ ອັນ ປາຍ: \"ຕິຮ! ເຍືາ ເນ່! ອັນ ໄນ່ ແຕິ່ ລາ ແກະ ກອນ ແຕ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ພໍກາ ໄລ່ ບາຣ ນະ ຣຍານ ແຕ ໂຢຮັນ ຊັອງ ອັນ ປາຍ ນ່ະກັອຍ, ໄລ່ ປວາຍ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ເຢຊູ ກູລຽວ ເຮີມ ໄລ່ ບາຣ ນະ ກັອຍ ຣາປວາຍ ຢັ່ຮ ກຣັອງ ອັນ, ເຈີ່ ອັນ ຕາແບີບ ໄລ່ ກັອຍ ປາຍ: \"ອຶນເຕົ່າ ເຍືາ ອີ ເບີນ ເຍືາ ປວາຍ ເກົາ?\" ໄລ່ ບາຣ ນະ ຕາແອີຍ ປາຍ: \"ອາຈານ ເອີຍ, ອຶນແລ່ະ ອາຈານ ແອີດ?\" ");
INSERT INTO ncq_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ເຍືາ ແຕີ່ອ໌ ເນ່.\" ນ່ະກັອຍ ບາຣ ນະ ກັອຍ ປວາຍ ເຢຊູ ກະ ເຮີມ ອຶນຕຸ ເຢຊູ ແອີດ. ເຈີ່ ໄລ່ ແອີດ ກະ ເຢຊູ ອຶນແຍ່ະ ມູ ຕາໄງ ກັອຍ; ແຈ່ະ ມານາງ ຕາບື່ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ອັນເດອາ, ອາແອມ ຊີໂມນ ເປໂຕ, ລາ ມານະ ແຕ ໄລ່ ບາຣ ນະ ກາ ຊັອງ ໂຢຮັນ ອາຕີ, ເຈີ່ ໄລ່ ປວາຍ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ອັນເດອາ ເປາະ ຣາມົຮ ແຕິ່ ຊີໂມນ, ອາຍ ອັນ; ເຈີ່ ອາຕີ ອັນ ປາຍ: \"ຮິ ຣາມົຮ ເຈີ່ ເມຊີອາ, ອັນ ກາ ເຢືາງ ເຈົາຣາຊີ ຣຽຮ ໂອນ ຈ່ອຍ ອາມົ່ງ ກວາຍ.\" (ຕຶ່ງ ປັຣນາຍ ກຣີກ ເນົ່າ ດໍອ໌ ອັນ ລາ ກຣີດ.) ");
INSERT INTO ncq_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ອັນເດອາ ເດີງ ຊີໂມນ ແຕີ່ອ໌ ປໍ ເຢຊູ. ເຢຊູ ເນ່ ປໍ ຊີໂມນ ກະ ອາຕີ ອັນ ປາຍ: \"ໄມ່ ເບີນ ຣາມຶ່ຮ ຊີໂມນ, ກອນ ໂຢຮັນ. ມາ ຊານໍ່ ເກົາ ໂອນ ໄມ່ ເບີນ ຣາມຶ່ຮ ຕາໄມ ແອັນ ລາ ເກພາ.\" (ຣາມຶ່ຮ 'ເກພາ' ໄນ່ ປັຣນາຍ ກຣີກ ດໍອ໌ ລາ 'ເປໂຕ.') ");
INSERT INTO ncq_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ມາຮ ຕາໄງ ປັຣແນີ ແອັນ ເຢຊູ ຄຶ່ດ ອີ ເປາະ ປໍ ແຄງ ຄາລີເລ. ພໍກາ ອັນ ເປາະ, ອັນ ຣາມົຮ ພີລິບ ກະ ອາຕີ ພີລິບ ປາຍ: \"ອຶງເຄາະ ໄມ່ ເປາະ ກະ ເກົາ!\" ");
INSERT INTO ncq_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ພີລິບ ໄນ່ ແອີດ ມູ ວີ່ລ ກະ ອັນເດອາ ກະ ເປໂຕ. ຣາມຶ່ຮ ວີ່ລ ກັອຍ ລາ ເບັດຊາອີດາ. ");
INSERT INTO ncq_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ເຈີ່ ພີລິບ ຣາມົຮ ນະທານາເອັລ ກະ ອາຕີ ອັນ ປາຍ: \"ຮິ ຣາມົຮ ເຈີ່ ອັນ ກາ ໂມເຊ ຄຽນ ຕຶ່ງ ປຶ່ງ ຄານອດ ຈຸ່ມ ອິດຊະຣາເອລ. ກະ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ ອາຕີ ແຕ ມານະ ໄນ່ ເຕ່. ຣາມຶ່ຮ ກວາຍ ໄນ່ ລາ ເຢຊູ, ກອນ ໂຢເຊັບ ແຕ ວີ່ລ ນາຊາເຣັດ.\" ");
INSERT INTO ncq_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ມາ ນະທານາເອັລ ຕາແບີບ ປາຍ: \"ເບີນ ອໍ ອຶນເຕົ່າ ກາ ແຕີ່ອ໌ ແຕ ວີ່ລ ນາຊາເຣັດ?\" ພີລິບ ຕາແອີຍ: \"ເອົາ ໄມ່ ເປາະ ຊາລີອ໌ ເນ່!\" ");
INSERT INTO ncq_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ພໍກາ ເຢຊູ ເຮີມ ນະທານາເອັລ ແຕີ່ອ໌ ປໍ ອັນ, ເຢຊູ ອາຕີ ແຕ ນະທານາເອັລ ປາຍ: \"ອັນ ໄນ່ ລາ ເຈຍ ກວາຍ ອິດຊະຣາເອລ. ອັນ ຕາ ເບີນ ຣາພິ ອຶນເຕົ່າ.\" ");
INSERT INTO ncq_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ນະທານາເອັລ ຕາແບີບ ເຢຊູ: \"ນານ່ະ ອາຈານ ດັງ ແຕ ຣາງຶ່ຮ ເກົາ?\" ເຢຊູ ຕາແອີຍ ອັນ ປາຍ: \"ແຕ ອຶນໂຍ່ງ ພີລິບ ຕາ ຢວາຮ ກູອ໌ ໄມ່, ບັອງ ກາ ໄມ່ ແອີດ ປື່ນ ກັ່ລ ລາວັ່ຮ, ເກົາ ດັງ ເຈີ່ ໄມ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ນະທານາເອັລ ປາຍ: \"ອາຈານ ເອີຍ! ໄກຣ ລາລື່ ອາຈານ ລາ ກອນ ເຢືາງ ເຈົາຣາຊີ. ກະ ໄກຣ ລາລື່ ອາຈານ ລາ ເຕືາວ ປັຣເຍືາ ຈຸ່ມ ອິດຊະຣາເອລ.\" ");
INSERT INTO ncq_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ເຢຊູ ປາຍ: \"ເກົາ ຕາແບິ ປາຍ, 'ເກົາ ດັງ ເຈີ່ ໄມ່ ບັອງ ກາ ໄມ່ ແອີດ ປື່ນ ອາລ່ອງ ກັອຍ,' ມາ ນານ່ະ ໄມ່ ຊາອຳ ແຕິ່? ປັຣແນີ ມັນເຕຣືາ ໄມ່ ເບີນ ເຮີມ ຣານະ ປື່ດ ແກຼີຍ ແຕ ໄນ່ ແອັນ!\" ");
INSERT INTO ncq_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ເຢຊູ ປາຍ ແອັນ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ປັຣແນີ ມັນເຕຣືາ ເຍືາ ເບີນ ເຮີມ ມັນລັ່ອງ ເປິຮ ກະ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ຊັອຮໆ ແຊງໆ ແຕ ມັນລັ່ອງ ຍ່ອນ ແຕ ກອນ ເຢືາງ ແກີດ ກວາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ແວັດ ບາຣ ຕາໄງ ແອັນ ເບີນ ກວາຍ ເປາະ ຈາ ປັຣຊວຍ ຕຶ່ງ ວີ່ລ ການາ, ແຄງ ຄາລີເລ. ອຶມເປ່ອ໌ ເຢຊູ ແອີດ ຕຶ່ງ ກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ເນົ່າ ການື່ຍ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ເປາະ ໂຣ່ມ ຈາ ປໍ ກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ແຕີ່ອ໌ ບຼັອງ ອາງຸ່ນ ອຶນແຍ່ະ ເຈີ່, ອຶມເປ່ອ໌ ເຢຊູ ປາຍ ໂຈະ ເຢຊູ: \"ຊານໍ່ ບຼັອງ ໄລ່ ອຶນແຍ່ະ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ເຢຊູ ຕາແອີຍ ລັ່ຮ ອຶມເປ່ອ໌ ອັນ ປາຍ: \"ຕາ ເບີນ ອຶນເຕົ່າ, ອຶມເປ່ອ໌. ໄນ່ ລາ ຕາ ແກີນ ຣານະ ໄມ່. ປາເນ່ນ ຣານະ ເກົາ ຕາ ຢວາຮ ແຕີ່ອ໌.\" ");
INSERT INTO ncq_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ອຶມເປ່ອ໌ ເຢຊູ ອາຕີ ກວາຍ ຕະ ຣານະ ຕຶ່ງ ດຸງ ກັອຍ ປາຍ: \"ອຶນເຕົ່າ ອັນ ແປຣີ ເຍືາ ຕະ, ເຍືາ ຕະ ອາກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ຈຸ່ມ ອິດຊະຣາເອລ ເບີນ ຣີ່ດ ອຶງເຄາະ ອາເຣືາວ ອາຕີ ອຶນໂຍ່ງ ອີ ຈີຈາ. ນ່ະກັອຍ ອຶນຕຸ ກັອຍ ເບີນ ຕາປັ່ດ ລຳ ແອງ ຕາເມົາ ດໍອ໌ ຕາປູ່ນ ຣີ່ດ ກັອຍ. ມານຳ ແອງ ກັອຍ ຕາແດີງ ເບີນ ມາຮ ມວຍ ຣ່ອຍ ລິ່ດ ແດີອ໌ ແຕ ປັ່ນ. ");
INSERT INTO ncq_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ເຢຊູ ແປຣີ ກວາຍ ກາ ຕະ ຣານະ ກັອຍ ປາຍ: \"ຊານໍ່ ເຍືາ ໂຈະ ປັ່ນ ມັຮ ແດີອ໌ ຕຶ່ງ ແອງ ກັອຍ.\" ເຈີ່ ກວາຍ ກັອຍ ໂຈະ ແດີອ໌ ລີ່ ງັ່ຮ ແອງ. ");
INSERT INTO ncq_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ແວັດ ກັອຍ ເຢຊູ ແປຣີ ໄລ່ ກັອຍ ແອັນ: \"ຊານໍ່ ເຍືາ ຕາກອຍ໌ ແດີອ໌ ແຕ ແອງ ໄນ່; ເຈີ່ ອາລັ່ອຮ ໂອນ ເທົາແກ ງ່ອຍ໌.\" ກວາຍ ຕະ ຣານະ ເດີງ ແດີອ໌ ກັອຍ ອາແຕີ່ອ໌ ໂອນ ເທົາແກ. ");
INSERT INTO ncq_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ເຈີ່ ເທົາແກ ຈີ່ມ ແດີອ໌ ກັອຍ, ມາ ແດີອ໌ ກັອຍ ແກີດ ບຼັອງ ອາງຸ່ນ. ເທົາແກ ກັອຍ ຕາ ດັງ ແຕ ແລ່ະ ບຼັອງ ໄນ່ ແຕີ່ອ໌, ມາ ໄລ່ ກາ ຕະ ຣານະ ກັອຍ, ໄລ່ ກາ ຕາກອຍ໌ ແດີອ໌ ກັອຍ, ໄລ່ ດັງ ເຈີ່. ນ່ະກັອຍ ເທົາແກ ກູອ໌ ປັຣລົວະ ກາ ອີດ ລາກວຍ. ");
INSERT INTO ncq_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ອັນ ອາຕີ ປາຍ: \"ແຕີ່ອ໌ ເນົ່າ ການື່ຍ ກວາຍ ການໍ່ອ໌, ເກີ່ຍ ເນົ່າ ໂອນ ງ່ອຍ໌ ບຼັອງ ແອມ ອຶນໂຍ່ງ ເວືາຍ. ແວັດ ຕາມອຍ ງ່ອຍ໌ ບູລ ອຶນແຍ່ະ ເຈີ່, ເນົ່າ ອາລັ່ອຮ ບຼັອງ ອຶນເຍາະ. ມາ ເຮີບ ໄນ່ ເຍືາ ອາລັ່ອຮ ບຼັອງ ແອມ ອຶນຕູ່ນ ແອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ເຢຊູ ຕະ ໂອນ ແດີອ໌ ແກີດ ບຼັອງ ຕຶ່ງ ເມືອງ ການາ ແຄງ ຄາລີເລ. ໄນ່ ລາ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ແຕ ຕາແບິ ລາລື່ ອັນ ຕະ. ອັນ ຕະ ນ່ະໄນ່ ດໍອ໌ ອາປັຮ ອຳນາດ ອາງອື່ຣ ແຕ ອັນ, ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ຊາອຳ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ແວັດ ກັອຍ ເຢຊູ ກະ ອຶມເປ່ອ໌ ອັນ, ອາແອມ ຣາເລົາ ອັນ, ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ, ອຶນແຍ່ະ ມັຮ ໄລ່ ແຊງ ເຈົາ ປໍ ເມືອງ ກາເປນາອູມ. ໄລ່ ແອີດ ອຶງກັອຍ ຕາ ເບີນ ດູ່ນ ບາຣ ໄປ ຕາໄງ. ");
INSERT INTO ncq_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ແຈ່ະ ອີ ແຕີ່ອ໌ ຕາໄງ ຈຸ່ມ ອິດຊະຣາເອລ ຈາ ຊາແຍີ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ອາກຼັຮ ໄລ່, ນ່ະກັອຍ ເຢຊູ ຊັອຮ ປໍ ເມືອງ ເຢຣູຊາເລັມ. ");
INSERT INTO ncq_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ຕຶ່ງ ຊັງອາຣ ດຸງ ຊາງ ປື່ດ ຈຸ່ມ ອິດຊະຣາເອລ, ເຢຊູ ຣາມົຮ ກວາຍ ຈິແຈີງ ຕາແກງ, ແກະ, ກະ ແຈມ ປາເຣືາດ. ກະ ເບີນ ກວາຍ ປຽນ ປຣະ ແຮີ ຕຶ່ງ ອຶນຕຸ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ນ່ະກັອຍ ເຢຊູ ຕະ ມວຍ ອຶນແຕຣັ່ຮ ອຶນໄຊ ໄປຣ່ຮ, ເຈີ່ ອັນ ຕູ່ຍຮ ອາລັ່ອຮ ອຶນແຍ່ະ ຊັນຕຣັ່ນ ແຕ ຊັງອາຣ ດຸງ ຊາງ ກັອຍ, ກາ ແກະ, ກາ ຕາແກງ. ກະ ອັນ ກູແຕັລ ຕັຮ ກາເຈີ່ງ ກວາຍ ປຽນ ປຣະ ໂອນ ມັຮ ປຣະ ກັອຍ ຊາແລັຮ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ເຈີ່ ເຢຊູ ແປຣີ ກວາຍ ກາ ຈິ ແຈມ ປາເຣືາດ ກັອຍ ປາຍ: \"ເຍືາ ອາລັ່ອຮ ປາເຣືາດ ແຕ ອຶນໄນ່! ເຍືາ ອຶນໂຈຍ ຕະ ຕາລາດ ຕຶ່ງ ດຸງ ອຶມປໍ່ ເກົາ!\" ");
INSERT INTO ncq_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ຊາແຍີ ລັ່ຮ ເນົ່າ ຄຽນ ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ ປາຍ: \"ເກົາ ອູອຍາຣ ອູໄອອ໌ ຢໍອ໌ ອີ ຕະ ຣານະ ຈ່ອຍ ດຸງ ຊາງ ເຢືາງ ເຈົາຣາຊີ ອຶນແຍ່ະ ຣາງຶ່ຮ ຣາແຮີ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ແວັດ ກັອຍ ກວາຍ ຊົດ ອິດຊະຣາເອລ ຕາແບີບ ເຢຊູ ປາຍ: \"ຣານະ ຕາ ເກີ່ຍ ເຮີມ ອຶນເຕົ່າ ອາຈານ ອາປັຮ ໂອນ ຮິ ດັງ ອາຈານ ເບີນ ອຳນາດ ຕະ ຣານະ ໄນ່?\" ");
INSERT INTO ncq_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ເຢຊູ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ຄັນ ຕາລຸຮ ດຸງ ຊາງ ໄນ່, ເຈີ່ ເກົາ ຕະ ລັ່ຮ ໄປ ຕາໄງ ລາ ເຈີ່ ແຕິ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ກວາຍ ຊົດ ອິດຊະຣາເອລ ຕາແບີບ ລັ່ຮ ເຢຊູ: \"ນານ່ະ ອາຈານ ປາຍ ອາຈານ ມາ ຕະ ເບີນ ດຸງ ຊາງ ໄນ່ ລາ ໄປ ຕາໄງ ຊັອງ? ຮິ ຕະ ດຸງ ຊາງ ໄນ່ ດູ່ນ ເບີນ ປູນ ຈິ່ດ ຕາປັ່ດ ກູມໍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ມາ ປັຣນາຍ ກັອຍ ເຢຊູ ຊາກຳ ແຕ ຈະ ອັນ ເບີມ ລາ ນ່ະ ດຸງ ຊາງ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ແຕີ່ອ໌ ແວັດ ເຢຊູ ກູຈີດ, ເຈີ່ ອັນ ອາມົ່ງ ລັ່ຮ, ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ຊາແຍີ ລັ່ຮ ປັຣນາຍ ເຢຊູ ປາຍ ໄນ່. ເຈີ່ ໄລ່ ຊາງັດ ລາລື່ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ກະ ອຶນແຍ່ະ ປັຣນາຍ ເຢຊູ ປາຍ. ");
INSERT INTO ncq_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ເຢຊູ ແອີດ ລັ່ຮ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ ມັຮ ຕາໄງ ຈຸ່ມ ອິດຊະຣາເອລ ຈາ ຊາແຍີ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ອາກຼັຮ ໄລ່. ບັອງ ກາ ເຢຊູ ແອີດ ອຶນຕຸ ກັອຍ, ເບີນ ກຼຶ່ງ ກວາຍ ຊາອຳ ອັນ, ຍ່ອນ ໄລ່ ເຮີມ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ອັນ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ມາ ເຢຊູ ຕາ ເບີນ ຊາອຳ ໄລ່, ຍ່ອນ ອັນ ດັງ ອຶນແຍ່ະ ຕຶ່ງ ຣາງຶ່ຮ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ອັນ ຕາ ເບີນ ຕຸ່ຮ ເນົ່າ ອາຕີ ອັນ ແຕ ຣາງຶ່ຮ ກວາຍ, ຍ່ອນ ອັນ ດັງ ແຈງ ລາລື່ ເຈີ່ ອຶນແຍ່ະ ແຕ ຣາງຶ່ຮ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ເບີນ ມານະ ແຕ ຈຸ່ມ ພາຣີຊາຍ ລາ ຣາມຶ່ຮ ນີໂກເດມ. ອັນ ກັອຍ ແຕ ຈຸ່ມ ໄລ່ ກາ ຊົດ ກວາຍ ອິດຊະຣາເອລ. ");
INSERT INTO ncq_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ເບີນ ມວຍ ຊາເດົາ ອັນ ແຕີ່ອ໌ ປໍ ເຢຊູ ກະ ປາຍ: \"ອາຈານ ເອີຍ! ຮິ ດັງ ເຈີ່ ອາຈານ ແຕີ່ອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ. ຕາ ເບີນ ເນົ່າ ເຕ່ອ໌ ຕະ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ມູເຈິງ ອາຈານ ຕະ, ຄັນ ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ແອີດ ກະ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ມາ ເຢຊູ ຕາແອີຍ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ໄມ່, ຄັນ ກວາຍ ອາແລ່ະ ມາ ຕາ ເບີນ ຣັ່ຮ ລັ່ຮ, ອັນ ກັອຍ ຕາ ເຕ່ອ໌ ເຮີມ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ.\" ");
INSERT INTO ncq_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ເຈີ່ ນີໂກເດມ ຕາແບີບ ລັ່ຮ ປາຍ: \"ນານ່ະ ກວາຍ ເທົາ ເຈີ່ ມາ ເຕ່ອ໌ ຣັ່ຮ ລັ່ຮ? ອາແລ່ະ ລາ ຕາ ເຕ່ອ໌ ມູ່ດ ນັ່ອງ ຕຶ່ງ ປຸ່ງ ອຶມເປ່ອ໌ ກະ ຣັ່ຮ ລັ່ຮ ມູ ເຮີບ ແອັນ!\" ");
INSERT INTO ncq_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ເຢຊູ ຕາແອີຍ ລັ່ຮ ແອັນ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ໄມ່, ຄັນ ເບີນ ກວາຍ ອາແລ່ະ ມາ ຕາ ເບີນ ຣັ່ຮ ຣານາ ແດີອ໌ ກະ ຣານາ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ, ກວາຍ ກັອຍ ຕາ ເຕ່ອ໌ ມູ່ດ ຕຶ່ງ ອຶນຕຸ ເຢືາງ ເຈົາຣາຊີ ຊົດ. ");
INSERT INTO ncq_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ຄັນ ແກີດ ແຕ ກວາຍ ລາ ກວາຍ ເມືາດ ຊັອງ, ມາ ຄັນ ແກີດ ແຕ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ລາ ເບີນ ຣາເວືາຍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ໄມ່ ອຶນໂຈຍ ງຶ່ດ ປັຣນາຍ ເກົາ ປາຍ, ເຍືາ ອຶງເຄາະ ຣັ່ຮ ລັ່ຮ ຕາໄມ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ມູເຈິງ ກູຢາລ ແປຼິ່ ເຕ່, ປໍ ແລ່ະ ອັນ ຢໍອ໌ ອີ ແປຼິ່ ລາ ອັນ ແປຼິ່ ປໍ ກັອຍ. ໄມ່ ເຕ່ອ໌ ຊັອງ ໂຮ ກູຢາລ ກັອຍ, ມາ ໄມ່ ຕາ ດັງ ແຕ ແລ່ະ ອັນ ແຕີ່ອ໌, ກະ ຕາ ດັງ ປໍ ແລ່ະ ອັນ ເປາະ. ມູເຈິງ ກັອຍ ເຕ່ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ ກາ ຣັ່ຮ ລັ່ຮ ແຕ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ນີໂກເດມ ຕາແບີບ ລັ່ຮ ຊາ: \"ງຶ່ດ ເອີຍ໌! ນານ່ະ ເຕ່ອ໌ ກວາຍ ຣັ່ຮ ລັ່ຮ ແອັນ?\" ");
INSERT INTO ncq_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ເຢຊູ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ໄມ່ ລາ ອາຈານ ອາຕີ ກວາຍ ອິດຊະຣາເອລ, ມາ ໄມ່ ຕາ ເບີນ ຊາປຸ່ຮ ຣາມຶ່ຮ ໄນ່ ບໍ? ");
INSERT INTO ncq_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ໄມ່, ຮິ ອາຕີ ແຕ ຣາມຶ່ຮ ຮິ ດັງ ເຈີ່, ກະ ຮິ ອາຕີ ແຕ ຣາມຶ່ຮ ຮິ ເຮີມ ເຈີ່, ມາ ຕາ ເບີນ ເນົ່າ ແຕ ເຍືາ ຢໍອ໌ ອີ ຊາງັດ ປັຣນາຍ ຮິ. ");
INSERT INTO ncq_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ຄັນ ເກົາ ອາຕີ ເຍືາ ແຕ ຣາມຶ່ຮ ຕຶ່ງ ກູແຕອ໌ ໄນ່, ມາ ເຍືາ ຕາ ເບີນ ຊາອຳ ເກົາ, ແຮງ ກາຕິກ ເກົາ ອາຕີ ມັຮ ຣາມຶ່ຮ ແຕ ມັນລັ່ອງ ແອັນ, ນານ່ະ ເຕ່ອ໌ ເຍືາ ຊາອຳ? ");
INSERT INTO ncq_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ເບີນ ແອີງ ມານະ ຊັອງ ຊັອຮ ປໍ ມັນລັ່ອງ. ມານະ ໄນ່ ລາ ກອນ ເຢືາງ ແກີດ ກວາຍ, ອັນ ກາ ແຊງ ເຈີ່ ແຕ ມັນລັ່ອງ. ມາ ມັຮ ກວາຍ ການໍ່ອ໌, ຕາ ເບີນ ເນົ່າ ຊັອຮ ປໍ ມັນລັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","\"ແຕ ອຶມແບິ ໂມເຊ ຕາຢັອງ ກູຊັນ ຕຶ່ງ ຕຍາຮ. ປັຣແນີ ມັນເຕຣືາ ເນົ່າ ຕາຢັອງ ກອນ ເຢືາງ ແກີດ ກວາຍ ມູເຈິງ ກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ຄັນ ກວາຍ ອາແລ່ະ ມາ ຊາອຳ ອັນ, ກວາຍ ກັອຍ ຕາ ເບີນ ກູຈີດ ປິ່ດ, ມາ ອັນ ເບີນ ອາມົ່ງ ຊົດ ແດີຍ. ");
INSERT INTO ncq_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ຍ່ອນ ເຢືາງ ເຈົາຣາຊີ ອາໂຢ່ະ ອຶນແຍ່ະ ມັຮ ກວາຍ, ນ່ະກັອຍ ອັນ ໂອນ ກອນ ອັນ ມານຳ ແຊງ ແອີດ ຕຶ່ງ ກູແຕອ໌ ໄນ່. ກວາຍ ອາແລ່ະ ກາ ຊາອຳ ກອນ ໄນ່, ຣາເວືາຍ ກວາຍ ກັອຍ ຕາ ເບີນ ກູຈີດ ປິ່ດ, ມາ ອັນ ເບີນ ອາມົ່ງ ເລືອຍໆ. ");
INSERT INTO ncq_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ແປຣີ ກອນ ອັນ ແຊງ ປໍ ກູແຕອ໌ ໄນ່ ໂອນ ຕະ ໂຕ່ດ ກວາຍ, ມາ ເຢືາງ ເຈົາຣາຊີ ຢໍອ໌ ອີ ຈ່ອຍ ອາມົ່ງ ອຶນແຍ່ະ ມັຮ ກວາຍ ຍ່ອນ ກອນ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","\"ກວາຍ ອາແລ່ະ ກາ ຊາອຳ ກອນ ເຢືາງ ເຈົາຣາຊີ, ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ຕະ ໂຕ່ດ ກວາຍ ກັອຍ. ມາ ກວາຍ ອາແລ່ະ ກາ ຕາ ເບີນ ຊາອຳ, ເຢືາງ ເຈົາຣາຊີ ຕະ ໂຕ່ດ ກວາຍ ກັອຍ ເຈີ່, ຍ່ອນ ກວາຍ ກັອຍ ຕາ ເບີນ ຊາອຳ ກອນ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ເຢືາງ ເຈົາຣາຊີ ຕະ ໂຕ່ດ ກວາຍ ນ່ະໄນ່: ຍ່ອນ ຣານະ ປັ່ງ ແຕີ່ອ໌ ເຈີ່ ປໍ ກູແຕອ໌ ໄນ່, ມາ ກວາຍ ປາຊິ ຣານະ ການຳ ກາເລີຍ ແຕ ຣານະ ປັ່ງ, ຍ່ອນ ຣານະ ໄລ່ ຕະ ຕາມມັຮ. ");
INSERT INTO ncq_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ອຶນແຍ່ະ ມັຮ ກວາຍ ກາ ຕະ ຣານະ ຕາມມັຮ, ໄລ່ ຊາອັຣ ລາລື່ ຣານະ ປັ່ງ. ກະ ໄລ່ ຕາ ຢໍອ໌ ອີ ແຕີ່ອ໌ ປໍ ອຶນຕຸ ປັ່ງ, ຍ່ອນ ໄລ່ ອຶງກັອຮ ເນົ່າ ດັງ ຣານະ ໄລ່ ຕະ ຕາ ເບີນ ອໍ. ");
INSERT INTO ncq_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ມາ ກວາຍ ອາແລ່ະ ກາ ຕະ ຣານະ ປຍາຍ໌, ກວາຍ ໄນ່ ຢໍອ໌ ອີ ແຕີ່ອ໌ ປໍ ອຶນຕຸ ປັ່ງ. ອັນ ຢໍອ໌ ອີ ໂອນ ປັ່ງ ອາປັຮ ອຶນແຍ່ະ ຣານະ ອັນ ຕະ ລາ ອັນ ຊາງັດ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ອັນ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ມູ່ດ ຕຶ່ງ ແຄງ ຢູດາຍ. ໄລ່ ແອີດ ປໍ ກັອຍ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ບັອງ ກາ ກັອຍ ໂຢຮັນ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ຕຶ່ງ ອຶນຕຸ ໄອນົນ ແຈ່ະ ວີ່ລ ຊາລິມ, ຍ່ອນ ອຶນຕຸ ກັອຍ ເບີນ ແດີອ໌ ຊາອຶ່ຍ. ກະ ກວາຍ ແຕີ່ອ໌ ເລືອຍໆ ປໍ ໂຢຮັນ ຢໍອ໌ ອັນ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(ບັອງ ກາ ກັອຍ, ເນົ່າ ຕາ ຢວາຮ ໂກບ ໂຢຮັນ ໂຈະ ຕຶ່ງ ກໍ່ອ໌.) ");
INSERT INTO ncq_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ແວັດ ກັອຍ ມູ່ ກາ ຣຍານ ແຕ ໂຢຮັນ ຣາຈຽນ ກະ ມານະ ກວາຍ ອິດຊະຣາເອລ ແຕ ຣີ່ດ ຕະ ບຣັຮ. ");
INSERT INTO ncq_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ເຈີ່ ມູ່ ກາ ຣຍານ ແຕ ໂຢຮັນ ແຕີ່ອ໌ ປໍ ອັນ ກະ ອາຕີ ປາຍ: \"ອາຈານ ເອີຍ! ອັນ ກາ ແອີດ ກະ ອາຈານ ບັອງ ກາ ອາຈານ ແອີດ ຢັ່ຮ ຕາເລ່ ຈໍແດນ, ອັນ ກາ ອາຈານ ອາຕີ ເຈີ່ ໂອນ ຮິ ດັງ ແຕ ອັນ, ຊານໍ່ ອັນ ກັອຍ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ກວາຍ ເຕ່. ກະ ອຶນແຍ່ະ ມັຮ ກວາຍ ແຕີ່ອ໌ ປໍ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ໂຢຮັນ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ກວາຍ ຕາ ເຕ່ອ໌ ເບີນ ມວຍ ຣາມຶ່ຮ ອຶນເຕົ່າ, ຄັນ ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ໂອນ ອັນ ເບີນ. ");
INSERT INTO ncq_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ເຍືາ ດັງ ເຈີ່ ເກົາ ປາຍ: 'ເກົາ ລາ ຕາ ແກີນ ກຣີດ. ມາ ເຢືາງ ເຈົາຣາຊີ ແປຣີ ເກົາ ແຕີ່ອ໌ ອຶນໂຍ່ງ ກຣີດ.' ");
INSERT INTO ncq_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ຣານະ ໄນ່ ລາ ນ່ະ ປັຣນາຍ ຊາກຳ ປາຍ: ເບີນ ມານະ ເປາະ ອີດ ລາກວຍ, ກະ ເຢົ່າ ອັນ ຕາຢຶ່ງ ຊາງັດ ອັນ ຕະ ອຶນຕີ. ເຢົ່າ ອັນ ໄລ່ ຊັອງ ຣໍ່ອ໌ ພໍກາ ໄລ່ ຊັອງ ຊຽງ ປັຣລົວະ ກັອຍ. ເກົາ ລາ ມູເຈິງ ເຢົ່າ ອັນ ເຕ່. ຊານໍ່ ເກົາ ຊັອງ ຣໍ່ອ໌ ຕຶ່ງ ຣາງຶ່ຮ ເກົາ, ຍ່ອນ ອັນ ແຕີ່ອ໌ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ອັນ ກັອຍ ອຶງເຄາະ ແກີດ ປື່ດ ອາຊັອຮ, ມາ ເກົາ ອຶງເຄາະ ແກີດ ແກດ ອາແຊງ. ");
INSERT INTO ncq_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","\"ອັນ ກາ ແຕີ່ອ໌ ແຕ ແປີງ, ອັນ ປື່ດ ແກຼີຍ ອຶນແຍ່ະ. ອັນ ກາ ແຕີ່ອ໌ ແຕ ກູແຕອ໌, ອັນ ແອີດ ຕຶ່ງ ກູແຕອ໌, ກະ ອັນ ອາຕີ ແຕ ຣາມຶ່ຮ ຕຶ່ງ ກູແຕອ໌ ຊັອງ. ມາ ອັນ ກາ ແຕີ່ອ໌ ແຕ ມັນລັ່ອງ, ອັນ ປື່ດ ແກຼີຍ ອຶນແຍ່ະ ແຕ ກູ່ ຣາມຶ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ອັນ ກັອຍ ອາຕີ ມັຮ ຣາມຶ່ຮ ອັນ ເຮີມ ກະ ອັນ ຊັອງ, ມາ ຕາ ເບີນ ເນົ່າ ຢໍອ໌ ອີ ຊາງັດ ປັຣນາຍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ອາແລ່ະ ກາ ຣັ່ບ ປັຣນາຍ ອັນ ປາຍ, ກວາຍ ກັອຍ ງີ່ນ ປາຍ ເຢືາງ ເຈົາຣາຊີ ລາ ປຍາຍ໌ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ເຢືາງ ເຈົາຣາຊີ ແປຣີ ເຢຊູ ແຕີ່ອ໌ ອາຕີ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ. ຍ່ອນ ນ່ະກັອຍ ເຢືາງ ເຈົາຣາຊີ ໂອນ ເຢຊູ ເບີນ ແອີງ ຣາເວືາຍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ອຶມປໍ່ ອາໂຢ່ະ ກອນ, ກະ ມ່ອບ ອຶນແຍ່ະ ຕຸ່ກ ຣາມຶ່ຮ ໂອນ ອັນ ຕະ ຊົດ. ");
INSERT INTO ncq_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ກວາຍ ອາແລ່ະ ກາ ຊາອຳ ກອນ ເຢືາງ ເຈົາຣາຊີ, ກວາຍ ກັອຍ ເບີນ ອາມົ່ງ ເລືອຍໆ. ມາ ກວາຍ ອາແລ່ະ ກາ ຕາ ເບີນ ຊາອຳ ກອນ ອັນ, ກວາຍ ກັອຍ ຕາ ເບີນ ອາມົ່ງ ເລີ່ຍ, ມາ ເຢືາງ ເຈົາຣາຊີ ຕະ ໂຕ່ດ ອັນ ເລືອຍໆ.\" ");
INSERT INTO ncq_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ຈຸ່ມ ພາຣີຊາຍ ຊັອງ ເນົ່າ ປາຍ ເຢຊູ ເບີນ ຊາອຶ່ຍ ກວາຍ ຣຍານ ແຕ ອັນ, ກະ ອັນ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ກວາຍ ຊາອຶ່ຍ ກາເລີຍ ແຕ ໂຢຮັນ. ");
INSERT INTO ncq_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ມາ ຕາ ແກີນ ເຢຊູ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ໄລ່, ແອີງ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ຊັອງ ຕະ ຣີ່ດ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ພໍກາ ເຢຊູ ດັງ ຈຸ່ມ ພາຣີຊາຍ ຊັອງ ເນົ່າ ປາຍ ນ່ະກັອຍ, ອັນ ລັ່ອຮ ແຕິ່ ແຕ ແຄງ ຢູດາຍ. ເຈີ່ ອັນ ລົ່ບ ເຈົາ ລັ່ຮ ປໍ ແຄງ ຄາລີເລ. ");
INSERT INTO ncq_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ຣານາ ເຢຊູ ເປາະ ອຶງເຄາະ ອັນ ຊາລັຮ ແຄງ ຊາມາເຣຍ ເວືາຍ. ");
INSERT INTO ncq_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ຕຶ່ງ ແຄງ ຊາມາເຣຍ ອັນ ແຕີ່ອ໌ ປໍ ວີ່ລ ຊີຄາ. ວີ່ລ ກັອຍ ແຈ່ະ ກູແຕອ໌ ກາ ຢາໂຄບ ໂອນ ໂຢເຊັບ ກອນ ຣາເລົາ ອັນ ແຕ ອຶມແບິ. ");
INSERT INTO ncq_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ກະ ເບີນ ແດີອ໌ ກັອຮ ກາ ຢາໂຄບ ປິ່ ແຕ ອຶມແບິ ປໍ ອຶນຕຸ ກັອຍ. ເຢຊູ ຊັອງ ລາແກັຮ ລາລື່, ຍ່ອນ ອັນ ຕາຢັຮ ເລືອຍໆ ຕຶ່ງ ຣານາ. ນ່ະກັອຍ ເຢຊູ ຕາກູ ແຈ່ະ ແດີອ໌ ກັອຮ ກັອຍ; ແຈ່ະ ອີ ແຕີ່ອ໌ ມານາງ ຕີລມູ່ລ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ເບີນ ມານະ ມັນແຊມ ຊາມາເຣຍ ແຕີ່ອ໌ ຢິດ ແດີອ໌. ເຈີ່ ເຢຊູ ປາຍ ໂຈະ ມັນແຊມ ກັອຍ: \"ແອີຍ ເອີຍ! ເກົາ ແຊອ໌ ງ່ອຍ໌ ແດີອ໌ ໄມ່ ແຮີ.\" ");
INSERT INTO ncq_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(ບັອງ ກາ ກັອຍ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ມູ່ດ ປໍ ເມືອງ ອີ ແຈີງ ຣາແວັ່ຮ ຈາ.) ");
INSERT INTO ncq_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ມັນແຊມ ຊາມາເຣຍ ກັອຍ ຕາແອີຍ ເຢຊູ ປາຍ: \"ເອົາ! ນານ່ະ ໄມ່ ລາ ກວາຍ ອິດຊະຣາເອລ, ມາ ແຊອ໌ ງ່ອຍ໌ ແດີອ໌ ແຕ ເກົາ? ເກົາ ລາ ກວາຍ ຊາມາເຣຍ.\" ອັນ ປາຍ ນ່ະກັອຍ ຍ່ອນ ຈຸ່ມ ອິດຊະຣາເອລ ຕາ ເບີນ ຣາຕອຍ ກະ ຈຸ່ມ ຊາມາເຣຍ. ");
INSERT INTO ncq_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ເຢຊູ ປາຍ ລັ່ຮ ກະ ມັນແຊມ ກັອຍ: \"ຄັນ ໄມ່ ມາ ດັງ ອຶນເຕົ່າ ເຢືາງ ເຈົາຣາຊີ ອີ ຈ່ອຍ ເມືາດ ກວາຍ, ກະ ຄັນ ໄມ່ ດັງ ອັນ ກາ ປາຍ: 'ແອີຍ ເອີຍ! ເກົາ ແຊອ໌ ງ່ອຍ໌ ແດີອ໌ ໄມ່ ແຮີ.' ນ່ະກັອຍ ໄມ່ ອີ ແຊອ໌ ແຕ ອັນ, ເຈີ່ ອັນ ໂອນ ໄມ່ ເບີນ ແດີອ໌ ກາ ໂອນ ອາມົ່ງ.\" ");
INSERT INTO ncq_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ມັນແຊມ ກັອຍ ຕາແອີຍ ລັ່ຮ ເຢຊູ ປາຍ: \"ອາຈານ ເອີຍ! ອາຈານ ແອິ ເກຣີ່ງ ຢິດ ແດີອ໌, ກະ ແດີອ໌ ກັອຮ ໄນ່ ອຶນຕຣູ່ ລາລື່. ນານ່ະ ອາຈານ ອີ ເບີນ ແດີອ໌ ກາ ໂອນ ອາມົ່ງ? ");
INSERT INTO ncq_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ອາຈວາຍຮ ອາເຈ່ຮ ໄຮ, ຢາໂຄບ, ຕະ ດໍອ໌ ໂອນ ໄຮ ແດີອ໌ ກັອຮ ໄນ່. ອັນ ກະ ອຶນແຍ່ະ ກອນ ຣາເລົາ ອັນ, ກາ ຊັນຕຣັ່ນ ດຸງ ອັນ, ແຕ ອຶມແບິ ອຶນແຍ່ະ ມັຮ ໄລ່ ງ່ອຍ໌ ເຕ່ ແດີອ໌ ກັອຮ ໄນ່. ນານ່ະ ອາຈານ ປື່ດ ກາເລີຍ ແຕ ຢາໂຄບ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ເຢຊູ ຕາແອີຍ ອັນ ປາຍ: \"ກວາຍ ອາແລ່ະ ກາ ງ່ອຍ໌ ແຕ ແດີອ໌ ກັອຮ ໄນ່, ອຶນນັ່ອງ ອັນ ອາເຣືາງ ລັ່ຮ ຊາ. ");
INSERT INTO ncq_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ມາ ກວາຍ ອາແລ່ະ ມາ ງ່ອຍ໌ ແດີອ໌ ກາ ເກົາ ໂອນ ອັນ ເບີນ, ອັນ ຕາ ເບີນ ອາເຣືາງ ນັ່ອງ. ມາ ແດີອ໌ ກາ ເກົາ ໂອນ ກັອຍ ແກີດ ນ່ະ ແດີອ໌ ປັຣໂລ່ຍ໌ ລັ່ອຮ ເລືອຍໆ ຕຶ່ງ ຣາງຶ່ຮ ອັນ. ກະ ແດີອ໌ ໄນ່ ໂອນ ອັນ ເບີນ ອາມົ່ງ ເລືອຍໆ.\" ");
INSERT INTO ncq_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ມັນແຊມ ກັອຍ ປາຍ: \"ອາຈານ ເອີຍ! ແຊອ໌ ອາຈານ ໂອນ ເກົາ ແຮີ ແດີອ໌ ກັອຍ, ອຽນ ເກົາ ຕາ ເບີນ ອາເຣືາງ ນັ່ອງ, ກະ ເກົາ ຕາ ເບີນ ຕຸ່ຮ ເປາະ ຢິດ ນັ່ອງ ແຕ ແດີອ໌ ກັອຮ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ເຢຊູ ຕາແອີຍ ປາຍ: \"ໄມ່ ເປາະ ກູອ໌ ກາຢາອ໌ ໄມ່ ແຕ ດຸງ. ເຈີ່ ໄມ່ ລົ່ບ ລັ່ຮ ປໍ ໄນ່ ນໍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ມັນແຊມ ກັອຍ ປາຍ: \"ເກົາ ຕາ ເບີນ ເບີນ ກາຢາອ໌.\" ເຢຊູ ຕາແອີຍ ປາຍ: \"ປຍາຍ໌ ໄມ່ ປາຍ ໄມ່ ຕາ ເບີນ ເບີນ ກາຢາອ໌. ");
INSERT INTO ncq_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ມາ ໄມ່ ເບີນ ກາຢາອ໌ ເຊີງ ລຳ ເຈີ່. ກະ ຣາເລົາ ກາ ແອີດ ກະ ໄມ່ ຊານໍ່, ລາ ຕາ ແກີນ ກາຢາອ໌ ໄມ່. ປຍາຍ໌ ນ່ະ ໄມ່ ປາຍ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ມັນແຊມ ກັອຍ ປາຍ ລັ່ຮ: \"ອາຈານ ເອີຍ! ເກົາ ຕາແບິ ດັງ ອາຈານ ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ອາຈວາຍຮ ອາເຈ່ຮ ຮິ ຊາງ ເຢືາງ ເຈົາຣາຊີ ດູ່ນ ເຈີ່ ຕຶ່ງ ກົຮ ໄນ່, ມາ ເຍືາ ຈຸ່ມ ອິດຊະຣາເອລ ປາຍ ອຶນຕຸ ຊາງ ເຢືາງ ເຈົາຣາຊີ ລາ ອຶງເຄາະ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ ຊັອງ.\" ");
INSERT INTO ncq_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ເຢຊູ ປາຍ: \"ແອີຍ ເອີຍ! ໄມ່ ຊາງັດ ປັຣນາຍ ເກົາ. ແຈ່ະ ອີ ແຕີ່ອ໌ ຕາໄງ ກວາຍ ກາ ຢໍອ໌ ອີ ຊາງ ອຶມປໍ່ ໄຮ ຕຶ່ງ ມັນລັ່ອງ, ໄລ່ ຕາ ເບີນ ອຶງເຄາະ ຊາງ ອັນ ຕຶ່ງ ກົຮ ໄນ່ ແຕີລາ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ. ");
INSERT INTO ncq_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ເຍືາ ຈຸ່ມ ຊາມາເຣຍ ຕາ ຢວາຮ ດັງ ແຈງ ເຍືາ ຊາງ ເນົ່າ. ມາ ຮິ ຈຸ່ມ ອິດຊະຣາເອລ ດັງ ແຈງ ເຈີ່ ຮິ ຊາງ ເນົ່າ, ຍ່ອນ ເຢືາງ ເຈົາຣາຊີ ຈ່ອຍ ອາມົ່ງ ກວາຍ ລາ ຍ່ອນ ແຕ ຈຸ່ມ ອິດຊະຣາເອລ. ");
INSERT INTO ncq_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ມາ ແຈ່ະ ອີ ແຕີ່ອ໌ ກະ ແຕີ່ອ໌ ເຈີ່ ຕາໄງ ກວາຍ ກາ ອີ ຊາງ ປຍາຍ໌, ໄລ່ ກັອຍ ຊາງ ອຶມປໍ່ ໄຮ ຕຶ່ງ ມັນລັ່ອງ ປວາຍ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ກະ ຊາງ ໂອນ ປຍາຍ໌. ອຶມປໍ່ ໄຮ ຢໍອ໌ ລາລື່ ກວາຍ ກາ ຊາງ ອັນ ນ່ະໄນ່. ");
INSERT INTO ncq_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ເຢືາງ ເຈົາຣາຊີ ລາ ເຢືາງ ຣາເວືາຍ. ນ່ະກັອຍ, ກວາຍ ອາແລ່ະ ກາ ຢໍອ໌ ອີ ຊາງ ອັນ ອຶງເຄາະ ຊາງ ປວາຍ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ກະ ຊາງ ໂອນ ປຍາຍ໌.\" ");
INSERT INTO ncq_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ມັນແຊມ ກັອຍ ປາຍ ແອັນ: \"ເກົາ ດັງ ເຈີ່ ປັຣແນີ ມັນເຕຣືາ ເມຊີອາ ອີ ແຕີ່ອ໌, ອັນ ກາ ເນົ່າ ດໍອ໌ ຣາມຶ່ຮ ກຣີດ. ພໍກາ ອັນ ແຕີ່ອ໌, ອັນ ອີ ອາຕີ ໂອນ ໄຮ ດັງ ກູ່ ຣາມຶ່ຮ.\" ");
INSERT INTO ncq_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ເຢຊູ ປາຍ ໂຈະ ມັນແຊມ ກັອຍ: \"ເກົາ ກາ ຕະ ອຶນຕີ ກະ ໄມ່ ຊານໍ່, ລາ ອັນ ກັອຍ ເອີຍ໌.\" ");
INSERT INTO ncq_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ບັອງ ກາ ກັອຍ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ເຈົາ ແຕ ວີ່ລ. ໄລ່ ຊັອງ ງຶ່ດ ລາລື່ ເຢຊູ ຕະ ອຶນຕີ ກະ ມັນແຊມ ກັອຍ. ມາ ຕາ ເບີນ ເນົ່າ ຕາແບີບ ມັນແຊມ ປາຍ: \"ອຶນເຕົ່າ ໄມ່ ອີ ເບີນ?\" ກະ ຕາ ເບີນ ເນົ່າ ຕາແບີບ ເຢຊູ ປາຍ: \"ນານ່ະ ອາຈານ ຕະ ອຶນຕີ ກະ ອັນ?\" ");
INSERT INTO ncq_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ມັນແຊມ ກັອຍ ຕັຮ ດໍອ໌ ອາລວຍ ແດີອ໌ ອັນ; ເຈີ່ ອັນ ເຈົາ ຕະ ອຶນຕີ ກະ ກວາຍ ຕຶ່ງ ເມືອງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","ມັນແຊມ ກັອຍ ປາຍ: \"ເອົາ! ເຍືາ ເປາະ ເນ່ ມານະ ກວາຍ ກາ ອາຕີ ເກົາ ອຶນແຍ່ະ ມັຮ ຣານະ ເກົາ ຕະ. ກວາຍ ໄນ່ ລາ ເມ່ນ ກຣີດ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ນ່ະກັອຍ ມັຮ ກວາຍ ແຕ ວີ່ລ ກັອຍ ລັ່ອຮ ເປາະ ແຕີ່ອ໌ ປໍ ອຶນຕຸ ເຢຊູ ແອີດ. ");
INSERT INTO ncq_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ບັອງ ກາ ກວາຍ ລັ່ອຮ ແຕ ວີ່ລ ອຶນນັ່ອງ ອຶນດີ ຣານາ, ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ອາຕີ ອັນ ປາຍ: \"ອາຈານ ເອີຍ, ມູ່ດ ຈາ ໂດຍ ເວືາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ມາ ເຢຊູ ຕາແອີຍ ລັ່ຮ ໄລ່ ປາຍ: \"ເກົາ ເບີນ ຊັຣນາ ຈາ ເຈີ່, ມາ ເຍືາ ຕາ ຢວາຮ ດັງ ຣາແວັ່ຮ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ນ່ະກັອຍ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ, ມານະ ຕາແບີບ ມານະ ປາຍ: \"ເບີນ ກວາຍ ເດີງ ຊັຣນາ ໂອນ ອັນ ຈາ ເຈີ່ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ມາ ເຢຊູ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ຊັຣນາ ເກົາ ຈາ ລາ ເກົາ ຕາປູ່ນ ຣາງຶ່ຮ ອັນ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌, ກະ ຕະ ໂອນ ເຈີ່ ມັຮ ຣານະ ອັນ ໂອນ ເກົາ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ເຍືາ ດຸ ອີ ປາຍ: 'ອຶນນັ່ອງ ປູນ ກາໄຊ ແອັນ ແຕີ່ອ໌ ຍາມ ຊູຊອດ.' ມາ ເກົາ ອາຕີ ເຍືາ ປາຍ: ເຍືາ ຕາງ່ອນ ເນ່ ອາຊັອຮ ປໍ ໄທຣ. ທຣໍ ກັອຍ ຈີນ ເຈີ່, ແຕີ່ອ໌ ປາເນ່ນ ຊອດ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ກວາຍ ກາ ຊອດ ຕຶ່ງ ໄທຣ ກັອຍ, ອັນ ເບີນ ກົງ ເກືາ ອັນ. ກະ ຣານະ ອັນ ຕະ ແກີດ ປາໄລ ນ່ະໄນ່: ກວາຍ ເບີນ ອາມົ່ງ ເລືອຍໆ. ນ່ະກັອຍ ກວາຍ ກາ ຈັ່ດ ກະ ກວາຍ ກາ ຊອດ ໄລ່ ຊັອງ ອຶມປຣ່ອມ ຣໍ່ອ໌ ບູຍ. ");
INSERT INTO ncq_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ເນົ່າ ດຸ ປາຍ ນ່ະໄນ່: 'ອັນ ໄນ່ ຈັ່ດ. ອັນ ກັອຍ ຊອດ.' ປັຣນາຍ ໄນ່ ລາ ປຍາຍ໌ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ເກົາ ແປຣີ ເຍືາ ຊອດ ຕຶ່ງ ໄທຣ ກາ ເຍືາ ຕາ ເບີນ ຕະ. ກວາຍ ການໍ່ອ໌ ຕະ ຕຶ່ງ ກັອຍ ເຈີ່, ມາ ເຍືາ ອີດ ປາໄລ ແຕ ເກືາ ເຣ່ງ ໄລ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ຊາອຶ່ຍ ນະ ກວາຍ ຊາມາເຣຍ ແຕ ວີ່ລ ກັອຍ ຊາອຳ ເຢຊູ ຍ່ອນ ມັນແຊມ ກັອຍ ອາຕີ ໄລ່ ປາຍ: \"ອັນ ກັອຍ ອາຕີ ເກົາ ອຶນແຍ່ະ ມັຮ ຣາມຶ່ຮ ເກົາ ຕະ.\" ");
INSERT INTO ncq_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ນ່ະກັອຍ, ພໍກາ ກວາຍ ຊາມາເຣຍ ແຕີ່ອ໌ ປໍ ເຢຊູ, ໄລ່ ກາຕັ່ອງ ອັນ ໂອນ ແອີດ ກະ ໄລ່. ເຈີ່ ເຢຊູ ແອີດ ກະ ໄລ່ ອຶນແຍ່ະ ບາຣ ຕາໄງ. ");
INSERT INTO ncq_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ຊາອຶ່ຍ ນະ ແອັນ ຊາອຳ ພໍກາ ໄລ່ ຊັອງ ປັຣນາຍ ເຢຊູ ອາຕີ. ");
INSERT INTO ncq_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ກວາຍ ກາ ຊາອຳ ກັອຍ ອາຕີ ມັນແຊມ ກັອຍ ປາຍ: \"ແຕ ອຶນໂຍ່ງ ຮິ ຊາອຳ ເຢຊູ ລາ ຍ່ອນ ແຕ ໄມ່ ອາຕີ ຮິ, ມາ ຊານໍ່ ຮິ ຊັອງ ປັຣນາຍ ອັນ ອາຕີ ເຈີ່. ນ່ະກັອຍ ຮິ ດັງ ແຈງ ລາລື່ ອັນ ໄນ່ ລາ ກວາຍ ກາ ຈ່ອຍ ອາມົ່ງ ອຶນແຍ່ະ ມັຮ ກວາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ແວັດ ບາຣ ຕາໄງ ກັອຍ, ເຢຊູ ເປາະ ຊາ ປໍ ແຄງ ຄາລີເລ. ");
INSERT INTO ncq_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ແຕ ອຶນໂຍ່ງ ເຢຊູ ປາຍ ເຈີ່: \"ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ຕາ ເບີນ ເນົ່າ ຢຳນັ່ບ ອັນ ຕຶ່ງ ກຣວາງ ອັນ ເບີມ.\" ");
INSERT INTO ncq_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ພໍກາ ເຢຊູ ແຕີ່ອ໌ ປໍ ແຄງ ຄາລີເລ, ກວາຍ ຄາລີເລ ຣັ່ບ ອັນ ຣໍ່ອ໌ ອໍ, ຍ່ອນ ໄລ່ ເຮີມ ເຈີ່ ອຶນແຍ່ະ ຣານະ ອັນ ຕະ ປໍ ເມືອງ ເຢຣູຊາເລັມ ຕາໄງ ຈຸ່ມ ອິດຊະຣາເອລ ຈາ ຣໍ່ອ໌ ຕາປູ່ນ ຣີ່ດ ຕາໄງ ເຢືາງ ເຈົາຣາຊີ ອາກຼັຮ ໄລ່. ບັອງ ກາ ກັອຍ ເບີນ ກວາຍ ຄາລີເລ ເປາະ ເຕ່ ປໍ ເມືອງ ເຢຣູຊາເລັມ. ");
INSERT INTO ncq_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ເຈີ່ ເຢຊູ ແຕີ່ອ໌ ລັ່ຮ ປໍ ວີ່ລ ການາ ຕຶ່ງ ແຄງ ຄາລີເລ. ຕຶ່ງ ວີ່ລ ກັອຍ ເຢຊູ ຕະ ເຈີ່ ໂອນ ແດີອ໌ ມາ ແກີດ ບຼັອງ ອາງຸ່ນ. ປໍ ວີ່ລ ກັອຍ ເບີນ ມານະ ກວາຍ ຊົດ ກາ ເບີນ ກອນ ຣາເລົາ ບິ ອາອີ່ ປໍ ເມືອງ ກາເປນາອູມ. ");
INSERT INTO ncq_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ພໍກາ ກວາຍ ຊົດ ໄນ່ ຊັອງ ເຢຊູ ລັ່ອຮ ແຕ ແຄງ ຢູດາຍ ແຕີ່ອ໌ ປໍ ແຄງ ຄາລີເລ, ອັນ ແຕີ່ອ໌ ປໍ ເຢຊູ, ກະ ອັນ ແຊອ໌ ເຢຊູ ເປາະ ກະ ອັນ ໂອນ ປົວ ກອນ ຣາເລົາ ອັນ. ກອນ ອັນ ແຈ່ະ ອີ ກູຈີດ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ເຢຊູ ອາຕີ ອັນ ປາຍ: \"ຄັນ ເຍືາ ຕາ ເບີນ ເຮີມ ຣານະ ກາ ເຍືາ ຕາ ເກີ່ຍ ເຮີມ, ເຍືາ ຕາ ເບີນ ຊາອຳ.\" ");
INSERT INTO ncq_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ກວາຍ ຊົດ ກັອຍ ຕາແອີຍ ລັ່ຮ: \"ອຶນເຈົາ ເອີຍ! ແຊອ໌ ອຶນເຈົາ ເປາະ ກະ ເກົາ, ໂອນ ຊາແຕີມ ບັອງ ກາ ກອນ ເກົາ ອຶນນັ່ອງ ອາມົ່ງ.\" ");
INSERT INTO ncq_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ເຢຊູ ຕາແອີຍ ອັນ ປາຍ: \"ເປາະ! ໄມ່ ເຈົາ. ຊານໍ່ ກອນ ຣາເລົາ ໄມ່ ເຢືາອ໌ ເຈີ່.\" ນ່ະກັອຍ ກວາຍ ຊົດ ກັອຍ ຊາອຳ ປັຣນາຍ ເຢຊູ; ເຈີ່ ອັນ ເຈົາ. ");
INSERT INTO ncq_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ອັນ ເປາະ ອຶນນັ່ອງ ອຶນດີ ຣານາ; ອັນ ຣາມົຮ ກວາຍ ກາ ຕະ ຣານະ ອັນ. ກວາຍ ກັອຍ ອາຕີ ອັນ ປາຍ: \"ກອນ ຣາເລົາ ອຶນເຈົາ ປຣາຍ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ກວາຍ ຊົດ ກັອຍ ຕາແບີບ ໄລ່ ປາຍ: \"ບັອງ ກາ ແລ່ະ ກອນ ຣາເລົາ ເກົາ ປຣາຍ ລັ່ຮ?\" ໄລ່ ຕາແອີຍ ອັນ ປາຍ: \"ກອນ ອຶນເຈົາ ປິ່ດ ກູເຕົາ ຈະ ຕາໄງ ປາໄຮ ບັອງ ກາ ມານາງ ວີ່ຮ.\" ");
INSERT INTO ncq_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ເຈີ່ ກວາຍ ຊົດ ກັອຍ ຊາແຍີ ລັ່ຮ ບັອງ ກາ ເຢຊູ ອາຕີ ກະ ອັນ ປາຍ: \"ຊານໍ່ ກອນ ຣາເລົາ ໄມ່ ເຢືາອ໌ ເຈີ່.\" ນ່ະກັອຍ ກວາຍ ຊົດ ກັອຍ ກະ ອຶນແຍ່ະ ດຸງຊູ ອັນ ຊາອຳ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ຣານະ ໄນ່ ລາ ເຮີບ ກາ ບາຣ ເຢຊູ ຕະ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ພໍກາ ແວັດ ອັນ ລັ່ອຮ ແຕ ແຄງ ຢູດາຍ ແຕີ່ອ໌ ປໍ ແຄງ ຄາລີເລ. ");
INSERT INTO ncq_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ແວັດ ກັອຍ ເຢຊູ ເປາະ ປໍ ເມືອງ ເຢຣູຊາເລັມ. ຕາໄງ ກັອຍ ຈຸ່ມ ອິດຊະຣາເອລ ຈາ ຣໍ່ອ໌ ຕາປູ່ນ ຣີ່ດ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ ກັອຍ, ແຈ່ະ ກູຕົ່ງ ກາ ເບີນ ຣາມຶ່ຮ ງັ່ຮ ຕົ່ງ ແກະ, ເບີນ ແດີອ໌ ພາຍ ມວຍ ອຶນຕຸ. ຕຶ່ງ ປັຣນາຍ ອິດຊະຣາເອລ ແດີອ໌ ພາຍ ໄນ່ ເນົ່າ ດໍອ໌ ເບັດຊະທາ. ອຶມແປຣ ແດີອ໌ ພາຍ ໄນ່ ເບີນ ຊູ ເຊີງ ລຳ. ");
INSERT INTO ncq_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ກຼຶ່ງ ລາລື່ ກວາຍ ອາອີ່ ບິ ຕຶ່ງ ຊູ ກັອຍ: ກວາຍ ຊູດ ມັ່ດ, ກວາຍ ໂຢດ, ກະ ກວາຍ ອາອີ່ ລ່ອຍ. (ກວາຍ ອາອີ່ ກັອຍ ເກຣາະ ແດີອ໌ ຕຶ່ງ ພາຍ ກັອຍ ປ່ອງ, ");
INSERT INTO ncq_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ຍ່ອນ ເບີນ ມານະ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ແຊງ ຕະ ໂອນ ແດີອ໌ ກັອຍ ແກີດ ປ່ອງ. ແຕີ່ອ໌ ແດີອ໌ ກັອຍ ປ່ອງ, ອາແລ່ະ ກາ ແຊງ ອຶນໂຍ່ງ ຕຶ່ງ ແດີອ໌ ກັອຍ, ອາອີ່ ອຶນເຕົ່າ ລາ ແກີດ ແບຣັຮ ອຶນແຍ່ະ). ");
INSERT INTO ncq_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ອຶນຕຸ ກັອຍ ເບີນ ມານະ ຣາເລົາ ອາອີ່ ໄປ ຈິ່ດ ຕາກ່ອລ ກູມໍ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ເຢຊູ ເຮີມ ອັນ ບິ ແອີດ ອຶງກັອຍ, ກະ ເຢຊູ ດັງ ກວາຍ ໄນ່ ອາອີ່ ດູ່ນ ເຈີ່. ນ່ະກັອຍ ເຢຊູ ຕາແບີບ ອັນ ປາຍ: \"ໄມ່ ຢໍອ໌ ອີ ແກີດ ແບຣັຮ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ກວາຍ ອາອີ່ ກັອຍ ຕາແອີຍ: \"ອຶນເຈົາ ເອີຍ! ເກົາ ຕາ ເບີນ ເນົ່າ ຈ່ອຍ ເກົາ ແຊງ ຕຶ່ງ ແດີອ໌ ພາຍ ພໍກາ ແດີອ໌ ກັອຍ ປ່ອງ. ບັອງ ກາ ກັອຍ ເກົາ ຢໍອ໌ ອີ ແຊງ ເຕ່, ມາ ເບີນ ກວາຍ ການໍ່ອ໌ ແຊງ ອຶນໂຍ່ງ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ເຢຊູ ອາຕີ ລັ່ຮ ອັນ ປາຍ: \"ໄມ່ ຢວຣ ຕາຢຶ່ງ! ອີດ ຣາຈາອ໌ ໄມ່! ເຈີ່ ໄມ່ ເປາະ!\" ");
INSERT INTO ncq_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ບັອງ ກາ ກັອຍ ແຕິ່ ກວາຍ ອາອີ່ ກັອຍ ແກີດ ແບຣັຮ ເລີ່ຍ. ອັນ ອີດ ຣາຈາອ໌, ເຈີ່ ອັນ ເປາະ. ຕາໄງ ກັອຍ ລາ ຕາໄງ ຣາລູ່. ");
INSERT INTO ncq_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ນ່ະກັອຍ ເບີນ ກວາຍ ຊົດ ອິດຊະຣາເອລ ອາຕີ ກວາຍ ແກີດ ແບຣັຮ ກັອຍ ປາຍ: \"ຕາໄງ ໄນ່ ລາ ຕາໄງ ຣາລູ່. ຕາປູ່ນ ຣີ່ດ ໄຮ ໄມ່ ຕາ ເຕ່ອ໌ ເດີງ ຣາຈາອ໌ ໄມ່ ຕຶ່ງ ຕາໄງ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ມາ ກວາຍ ກັອຍ ຕາແອີຍ ປາຍ: \"ອັນ ກາ ປົວ ເກົາ ອາຕີ ເກົາ ປາຍ: 'ໄມ່ ອີດ ຣາຈາອ໌ ໄມ່, ເຈີ່ ໄມ່ ເປາະ.'\" ");
INSERT INTO ncq_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ກວາຍ ຊົດ ອິດຊະຣາເອລ ຕາແບີບ ລັ່ຮ ອັນ ປາຍ: \"ເນົ່າ ກາ ອາຕີ ໄມ່ ອີດ ຣາຈາອ໌ ໄມ່, ເຈີ່ ໄມ່ ເປາະ?\" ");
INSERT INTO ncq_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ມາ ກວາຍ ແກີດ ແບຣັຮ ກັອຍ ຕາ ເບີນ ດັງ ເນົ່າ ກາ ປົວ ອັນ, ຍ່ອນ ເຢຊູ ແກີດ ປິ່ດ ຕຶ່ງ ກວາຍ ກຼຶ່ງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ແຕີ່ອ໌ ອຶນຕູ່ນ ແອັນ, ເຢຊູ ຣາມົຮ ລັ່ຮ ກວາຍ ກາ ແກີດ ແບຣັຮ ກັອຍ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ. ເຈີ່ ເຢຊູ ອາຕີ ອັນ ປາຍ: \"ຊານໍ່ ໄມ່ ແບຣັຮ ເຈີ່. ໄມ່ ອຶນໂຈຍ ຕະ ນັ່ອງ ຣານະ ໂລ່ຍຮ. ຄັນ ໄມ່ ຕະ ໂລ່ຍຮ, ອຶງກັອຮ ໄມ່ ຣາມົຮ ຕຸ່ຮ ກັ່ດ ແກຼີຍ ແຕ ອຶນໂຍ່ງ ແອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ກວາຍ ກັອຍ ລັ່ອຮ ແຕ ອຶນຕຸ ກັອຍ, ກະ ອັນ ອາຕີ ໂອນ ກວາຍ ຊົດ ອິດຊະຣາເອລ ດັງ ປາຍ ເຢຊູ ຕະ ໂອນ ອັນ ແກີດ ແບຣັຮ. ");
INSERT INTO ncq_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ຍ່ອນ ເຢຊູ ຕະ ຣານະ ກັອຍ ຕຶ່ງ ຕາໄງ ຣາລູ່, ນ່ະກັອຍ ກວາຍ ຊົດ ອິດຊະຣາເອລ ຕະ ຕຸ່ຮ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ມາ ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ອຶມປໍ່ ເກົາ ຕະ ຣານະ ເຕົ່າ ຊານໍ່, ກະ ເກົາ ລາ ຕະ ມູເຈິງ ກັອຍ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ຍ່ອນ ເຢຊູ ປາຍ ນ່ະກັອຍ, ກວາຍ ຊົດ ອິດຊະຣາເອລ ຈໍ່ອ໌ ຊາອຶ່ຍ ຣານາ ແອັນ ຢໍອ໌ ອີ ກາຈີດ ອັນ. ໄລ່ ປາຍ ເຢຊູ ຕະ ບາຣ ຣາມຶ່ຮ ຕາ ເບີນ ປຍາຍ໌. ມວຍ ລາ ອັນ ຕັຮ ຄານອດ ຕາໄງ ຣາລູ່; ບາຣ ລາ ອັນ ດໍອ໌ ເຢືາງ ເຈົາຣາຊີ ລາ ອຶມປໍ່ ອັນ. ຕະ ນ່ະກັອຍ ລາ ມູເຈິງ ອັນ ປາຍ ອັນ ລາ ຣາລີ ກະ ເຢືາງ ເຈົາຣາຊີ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ນ່ະກັອຍ ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ເກົາ ກອນ ເຢືາງ ເຈົາຣາຊີ ຕາ ເຕ່ອ໌ ຕະ ມວຍ ຣານະ ອຶນເຕົ່າ ປວາຍ ຣາງຶ່ຮ ເກົາ ເບີມ. ກອນ ຕະ ມັຮ ກອນ ເຮີມ ອຶມປໍ່ ຕະ. ຣານະ ອຶນເຕົ່າ ອຶມປໍ່ ຕະ, ກອນ ຕະ ມູເຈິງ ກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ຍ່ອນ ອຶມປໍ່ ອາໂຢ່ະ ກອນ, ນ່ະກັອຍ ອຶມປໍ່ ອາປັຮ ກອນ ອຶນແຍ່ະ ຕຸ່ກ ຣາມຶ່ຮ ອັນ ຕະ. ປັຣແນີ ມັນເຕຣືາ ອຶມປໍ່ ອາປັຮ ກອນ ຕະ ຣານະ ປື່ດ ແກຼີຍ ແຕ ຣານະ ໄນ່, ໂອນ ເຍືາ ງຶ່ດ ລາລື່ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ນ່ະ ອຶມປໍ່ ໂອນ ກວາຍ ກາ ກູຈີດ ເຈີ່ ມາ ເບີນ ອາມົ່ງ ລັ່ຮ, ນ່ະກັອຍ ເຕ່ ກອນ ໂອນ ເບີນ ອາມົ່ງ ປໍ ອຶນແຍ່ະ ມັຮ ກວາຍ ອັນ ຢໍອ໌ ອີ ໂອນ. ");
INSERT INTO ncq_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ອຶມປໍ່ ຕາ ເບີນ ຕັດຊີ່ນ ອາແລ່ະ, ມາ ອັນ ໂອນ ກອນ ອັນ ຕັດຊີ່ນ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ນ່ະກັອຍ, ກວາຍ ອາແລ່ະ ຢໍອ໌ ອີ ຢຳນັ່ບ ອຶມປໍ່, ກວາຍ ກັອຍ ອຶງເຄາະ ຢຳນັ່ບ ກອນ ມູເຈິງ ກັອຍ ເຕ່. ກວາຍ ອາແລ່ະ ມາ ຕາ ເບີນ ຢຳນັ່ບ ກອນ, ກວາຍ ກັອຍ ຕາ ເບີນ ຢຳນັ່ບ ເຕ່ ອຶມປໍ່, ອັນ ກາ ແປຣີ ກອນ ແຕີ່ອ໌ ປໍ ກູແຕອ໌ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","\"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ກວາຍ ອາແລ່ະ ກາ ຊາງັດ ປັຣນາຍ ເກົາ, ກະ ຊາອຳ ອັນ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌, ກວາຍ ກັອຍ ເບີນ ອາມົ່ງ ເລືອຍໆ. ຕາ ເບີນ ເນົ່າ ຕັດຊີ່ນ ອັນ ນັ່ອງ. ນ່ະກັອຍ ອັນ ແວັດ ແຕ ກູຈີດ ເຈີ່; ມາ ອັນ ເບີນ ອາມົ່ງ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ແຈ່ະ ອີ ແຕີ່ອ໌ ກະ ແຕີ່ອ໌ ເຈີ່ ຕາໄງ ມັຮ ກວາຍ ກາ ກູຈີດ ເບີນ ຊັອງ ຊຽງ ກອນ ເຢືາງ ເຈົາຣາຊີ; ເຈີ່ ໄລ່ ກາ ຊັອງ ຊຽງ ກັອຍ ເບີນ ອາມົ່ງ. ");
INSERT INTO ncq_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ຍ່ອນ ອຶມປໍ່ ເຕ່ອ໌ ໂອນ ກວາຍ ອາມົ່ງ, ນ່ະກັອຍ ເຕ່ ອັນ ໂອນ ກອນ ເຕ່ອ໌ ຈ່ອຍ ກວາຍ ເບີນ ອາມົ່ງ. ");
INSERT INTO ncq_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ກະ ອຶມປໍ່ ໂອນ ກອນ ເບີນ ອຳນາດ ດໍອ໌ ຕັດຊີ່ນ ກວາຍ, ຍ່ອນ ອັນ ລາ ກອນ ເຢືາງ ແກີດ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ເຍືາ ອຶນໂຈຍ ງຶ່ດ ແຕ ປັຣນາຍ ໄນ່, ຍ່ອນ ອີ ແຕີ່ອ໌ ຕາໄງ ກວາຍ ກູຈີດ ແອີດ ຕຶ່ງ ປີ່ງ, ໄລ່ ຊັອງ ຊຽງ ກອນ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ເຈີ່ ໄລ່ ລັ່ອຮ ແຕ ປີ່ງ ໄລ່, ກວາຍ ອາແລ່ະ ກາ ຕະ ຣານະ ອໍ, ກວາຍ ກັອຍ ລັ່ອຮ ກະ ເບີນ ອາມົ່ງ. ມາ ກວາຍ ອາແລ່ະ ກາ ຕະ ຣານະ ຕາ ອໍ, ກວາຍ ກັອຍ ລັ່ອຮ ມາ ອຶນນັ່ອງ ເບີນ ເນົ່າ ຕັດຊີ່ນ ໂຈະ ໂຕ່ດ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ເກົາ ຕາ ເຕ່ອ໌ ຕະ ອຶນເຕົ່າ ຕາປູ່ນ ຣາງຶ່ຮ ເກົາ ເບີມ. ມາ ປັຣນາຍ ອຶນເຕົ່າ ເກົາ ຊັອງ ແຕ ອຶມປໍ່ ເກົາ, ເກົາ ຕັດຊີ່ນ ກວາຍ ຕາປູ່ນ ປັຣນາຍ ກັອຍ. ນ່ະກັອຍ ປັຣນາຍ ເກົາ ຕັດຊີ່ນ ລາ ຕານັ່ອງ ລາລື່, ຍ່ອນ ເກົາ ຕາ ເບີນ ຕາປູ່ນ ຣາງຶ່ຮ ເກົາ ເບີມ, ມາ ເກົາ ຕາປູ່ນ ຣາງຶ່ຮ ອັນ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","\"ຄັນ ເກົາ ອາຕີ ແຕ ຣາງຶ່ຮ ເກົາ ເບີມ, ປັຣນາຍ ໄນ່ ຕາ ເບີນ ຊັງໄກຣ. ");
INSERT INTO ncq_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ມາ ເບີນ ມານະ ອາຕີ ແຕ ເກົາ ເຕ່, ກະ ເກົາ ດັງ ປັຣນາຍ ອັນ ອາຕີ ແຕ ເກົາ ລາ ປຍາຍ໌ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ເຍືາ ແປຣີ ກວາຍ ແຕີ່ອ໌ ປໍ ໂຢຮັນ ເຈີ່, ກະ ອັນ ອາຕີ ປັຣນາຍ ປຍາຍ໌. ");
INSERT INTO ncq_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ມາ ເກົາ ຕາ ເບີນ ຕຸ່ຮ ອຶງເຄາະ ເບີນ ກວາຍ ອາຕີ ແຕ ເກົາ. ເກົາ ອາຕີ ຣານະ ໄນ່ ໂອນ ເຍືາ ເບີນ ອາມົ່ງ. ");
INSERT INTO ncq_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ໂຢຮັນ ລາ ນ່ະ ຕາບອງ ເບຼີ ປາເລືາງ ໂອນ ປັ່ງ. ເຍືາ ຣໍ່ອ໌ ມາໂຮຍ ຊັອງ ຣານະ ປັ່ງ ແຕ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ມາ ເກົາ ເບີນ ປັຣນາຍ ກາ ປື່ດ ກາເລີຍ ແຕ ປັຣນາຍ ໂຢຮັນ ອາຕີ ແຕ ເກົາ. ອຶນແຍ່ະ ຣານະ ເກົາ ຕະ ລາ ຣານະ ອຶມປໍ່ ເກົາ ມ່ອບ ໂອນ ເກົາ ຕະ. ອຶນແຍ່ະ ຣານະ ໄນ່ ອາປັຮ ໂອນ ກວາຍ ດັງ ເກົາ ແຕີ່ອ໌ ແຕ ອຶມປໍ່ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ກະ ອຶມປໍ່ ເກົາ, ອັນ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌, ອັນ ກັອຍ ອາຕີ ແຕ ເກົາ ເຕ່. ເຍືາ ຕາ ເກີ່ຍ ຊັອງ ຊຽງ ອັນ, ແຕີລາ ເຮີມ ຣູ່ບເຣືາງ ອັນ, ");
INSERT INTO ncq_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ກະ ປັຣນາຍ ອັນ ຕາ ເບີນ ແອີດ ຕຶ່ງ ຣາງຶ່ຮ ເຍືາ, ຍ່ອນ ເຍືາ ຕາ ເບີນ ຊາອຳ ອັນ ກາ ອຶມປໍ່ ແປຣີ ແຕີ່ອ໌ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ເຍືາ ແທຣິງ ຣຍານ ຊາອຶ່ຍ ແຕ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ຍ່ອນ ເຍືາ ຄຶ່ດ ປາຍ ປັຣນາຍ ກັອຍ ເຕ່ອ໌ ໂອນ ອາມົ່ງ ເລືອຍໆ. ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ໄນ່ ອາຕີ ແຕ ເກົາ, ");
INSERT INTO ncq_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ມາ ອຶນນັ່ອງ ເຍືາ ຕາ ແອອ໌ ອີ ແຕີ່ອ໌ ປໍ ເກົາ ໂອນ ເບີນ ອາມົ່ງ ເລືອຍໆ. ");
INSERT INTO ncq_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","\"ເກົາ ຕາ ເບີນ ຈໍ່ອ໌ ໂອນ ກວາຍ ຍ່ອງ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ມາ ເກົາ ດັງ ເຍືາ ເຈີ່. ຕຶ່ງ ຣາງຶ່ຮ ເຍືາ ຕາ ເບີນ ອາໂຢ່ະ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່ ຍ່ອນ ອຳນາດ ແຕ ອຶມປໍ່ ເກົາ, ມາ ອຶນນັ່ອງ ເຍືາ ຕາ ແອອ໌ ຣັ່ບ ເກົາ. ມາ ຄັນ ເບີນ ກວາຍ ການໍ່ອ໌ ແຕີ່ອ໌ ອາງ ອຳນາດ ອັນ ເບີມ, ເຍືາ ຣັ່ບ ອັນ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ນານ່ະ ເຕ່ອ໌ ເຍືາ ຊາອຳ ເກົາ, ເຍືາ ຢໍອ໌ ລາລື່ ກວາຍ ການໍ່ອ໌ ຍ່ອງ ເຍືາ, ມາ ເຍືາ ຕາ ເບີນ ຈໍ່ອ໌ ໂອນ ເຢືາງ ເຈົາຣາຊີ ຍ່ອງ ເຍືາ? ແອີງ ອັນ ແຕິ່ ລາ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ມາ ເຍືາ ອຶນໂຈຍ ຄຶ່ດ ອຶນເຕົ່າ ອຶງກັອຮ ເກົາ ປ່ອງ ເຍືາ ໂຈະ ອຶມປໍ່ ເກົາ. ໂມເຊ ກາ ເຍືາ ອຶງກ່ອງ ຈ່ອຍ ເຍືາ, ອັນ ແຕິ່ ອີ ປ່ອງ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ມາ ຄັນ ເຍືາ ຊາອຳ ໂມເຊ, ລາ ເຍືາ ຊາອຳ ເກົາ ເຕ່, ຍ່ອນ ໂມເຊ ຄຽນ ແຕ ເກົາ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ມາ ຄັນ ເຍືາ ຕາ ເບີນ ຊາອຳ ປັຣນາຍ ໂມເຊ ຄຽນ, ນານ່ະ ເຍືາ ເຕ່ອ໌ ຊາອຳ ປັຣນາຍ ເກົາ ອາຕີ ຊານໍ່?\" ");
INSERT INTO ncq_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ແວັດ ກັອຍ, ເຢຊູ ໄກ່ອ໌໌ ທາເລ ຣາປັ່ງ ຄາລີເລ. ແດີອ໌ ໄນ່ ເນົ່າ ດໍອ໌ ທາເລ ຣາປັ່ງ ຕີເບເຣຍ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ກຼຶ່ງ ລາລື່ ກວາຍ ປວາຍ ເຢຊູ, ຍ່ອນ ໄລ່ ເຮີມ ເຈີ່ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ອັນ ປົວ ກວາຍ ອາອີ່. ");
INSERT INTO ncq_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ເຢຊູ ຊັອຮ ຕຶ່ງ ກົຮ, ຕາກູ ອຶນຕຸ ກັອຍ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ແຈ່ະ ອີ ແຕີ່ອ໌ ຕາໄງ ຈຸ່ມ ອິດຊະຣາເອລ ຈາ ຊາແຍີ ຕາໄງ ອາກຼັຮ. ");
INSERT INTO ncq_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ພໍກາ ເຢຊູ ຕາເງີ່ອ໌ ອາຊັອຮ, ອັນ ເຮີມ ກຼຶ່ງ ກວາຍ ແຕີ່ອ໌ ປໍ ອັນ; ເຈີ່ ອັນ ປາຍ ໂຈະ ພີລິບ: \"ປໍ ແລ່ະ ໄຮ ອີ ແຈີງ ຊັຣນາ ໂອນ ຄຳ ອຶນແຍ່ະ ມັຮ ກວາຍ ໄນ່ ຈາ?\" ");
INSERT INTO ncq_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ເຢຊູ ຕາແບີບ ນ່ະກັອຍ ຢໍອ໌ ອີ ລ່ອງ ຣາງຶ່ຮ ພີລິບ ຊັອງ, ຍ່ອນ ອັນ ດັງ ເຈີ່ ຣານະ ອັນ ຢໍອ໌ ອີ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ພີລິບ ຕາແອີຍ ເຢຊູ ປາຍ: \"ຄັນ ເນົ່າ ອີດ ປຣະ ທູແທ ຕາກ່ອລ ກາໄຊ ເປາະ ແຈີງ ຊັຣນາ ໂອນ ມັຮ ກວາຍ ໄນ່ ຈາ ມານະ ມູ ເມ່ງ ລາ ຕາ ຄຳ.\" ");
INSERT INTO ncq_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ເບີນ ມານະ ແອັນ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ຣາມຶ່ຮ ອັນເດອາ, ອາແອມ ຊີໂມນ ເປໂຕ. ");
INSERT INTO ncq_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","ອັນເດອາ ປາຍ: \"ເບີນ ມານະ ກັຣແນນ ຣາເລົາ ແອີດ ອຶນໄນ່. ອັນ ເບີນ ເຊີງ ລຳ ໂດຍ ບຸຮ ກະ ບາຣ ລຳ ອາກາ. ມາ ນານ່ະ ເຕ່ອ໌ ຄຳ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ ໄນ່ ຈາ?\" ");
INSERT INTO ncq_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ເຢຊູ ຕາແອີຍ ປາຍ: \"ໂອນ ກວາຍ ກຼຶ່ງ ໄນ່ ຕາກູ.\" ຕຶ່ງ ອຶນຕຸ ກັອຍ ເບີນ ບັດ ຊາອຶ່ຍ; ເຈີ່ ໄລ່ ຕາກູ ອຶງກັອຍ. ອຶນແຍ່ະ ນະ ໄລ່ ນັ່ບ ແອີງ ກວາຍ ຊາຊາຍ ຣາເລົາ ລາ ເບີນ ມາຮ ເຊີງ ປັ່ນ ນະ. ");
INSERT INTO ncq_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ເຢຊູ ອີດ ໂດຍ ບຸຮ ກັອຍ, ກະ ຊາແອີນ ເຢືາງ ເຈົາຣາຊີ. ແວັດ ກັອຍ ອັນ ອຶມແປອ໌ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ ກາ ຕາກູ ອຶງກັອຍ. ອັນ ຕະ ມູເຈິງ ກັອຍ ເຕ່ ກະ ອາກາ, ມາແລ່ະ ໄລ່ ຢໍອ໌ ອີ ຈາ, ໄລ່ ຕຶ່ງ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ແວັດ ອຶນແຍ່ະ ມັຮ ກວາຍ ຈາ ປາໄຊ ເຈີ່, ເຢຊູ ແປຣີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ເຍືາ ປາໂຣມ ລັ່ຮ ມັຮ ອຶງກັຮ ແກຼີຍ ແຕ ໄລ່ ຈາ. ອຶນໂຈຍ ໂອນ ຊາໄລອ໌ ມວຍ ແບະ ອຶນເຕົ່າ.\" ");
INSERT INTO ncq_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ນ່ະກັອຍ ໄລ່ ປາໂຣມ ລັ່ຮ ມັຮ ອຶງກັຮ ເບີນ ມວຍ ຈິ່ດ ລາ ບາຣ ກາເຣຍ ແກຼີຍ ເນົ່າ ຈາ ແຕ ເຊີງ ລຳ ໂດຍ ບຸຮ. ");
INSERT INTO ncq_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ອຶນແຍ່ະ ມັຮ ກວາຍ ກາ ເຮີມ ເຢຊູ ຕະ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ໄນ່, ໄລ່ ກັອຍ ປາຍ: \"ກວາຍ ໄນ່ ລາ ເມ່ນ ມານະ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ອັນ ກາ ເຢືາງ ເຈົາຣາຊີ ເອີອ໌ ໂອນ ແຕີ່ອ໌ ປໍ ກູແຕອ໌ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ພໍກາ ເຢຊູ ດັງ ມັຮ ກວາຍ ກັອຍ ແຕີ່ອ໌ ມັນຕຣຸ່ ໂອນ ອັນ ແກີດ ເຕືາວ ປັຣເຍືາ, ເຈີ່ ເຢຊູ ລັ່ອຮ ແຕ ອຶນຕຸ ກັອຍ. ອັນ ຊັອຮ ລັ່ຮ ຕຶ່ງ ກົຮ ມານະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ແຕີ່ອ໌ ຕາບື່, ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ແຊງ ປໍ ປຶ່ຮ ທາເລ ຣາປັ່ງ. ");
INSERT INTO ncq_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ອຶນຕຸ ກັອຍ ໄລ່ ຈິ່ຮ ຕົວະ ຢໍອ໌ ອີ ໄກ່ອ໌໌ ຢັ່ຮ ອຶນຕົ່ຮ ທາເລ ຣາປັ່ງ, ເປາະ ປໍ ເມືອງ ກາເປນາອູມ. ມັນລັ່ອງ ການຳ, ມາ ເຢຊູ ຕາ ຢວາຮ ແຕີ່ອ໌ ປໍ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ກູຢາລ ແປຼິ່ ເຣ່ງ ລາລື່, ກະ ແດີອ໌ ປ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ເປືາຍ ຕົວະ ມາຮ ເຊີງ ຕາປັ່ດ ລັກ ເຈີ່. ໄລ່ ເຮີມ ເຢຊູ ຕາຢັຮ ຕຶ່ງ ແປີງ ກຣັອງ ແດີອ໌ ແຈ່ະ ອີ ແຕີ່ອ໌ ຕົວະ ໄລ່. ເຈີ່ ໄລ່ ຊັອງ ອຶງກັອຮ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ມາ ເຢຊູ ອາຕີ ໄລ່ ປາຍ: \"ໄນ່ ລາ ຈະ ເກົາ. ເຍືາ ອຶນໂຈຍ ອຶງກັອຮ ອຶນເຕົ່າ.\" ");
INSERT INTO ncq_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ແວັດ ກັອຍ, ໄລ່ ໂອນ ເຢຊູ ຊັອຮ ຕຶ່ງ ຕົວະ ໄລ່; ເຈີ່ ບັອງ ກາ ກັອຍ ແຕິ່ ຕົວະ ໄລ່ ແຕີ່ອ໌ ປໍ ປຶ່ຮ ອຶນຕຸ ໄລ່ ອີ ເປາະ. ");
INSERT INTO ncq_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ປັ່ງ ຕາຣື່ບ ແອັນ ກວາຍ ກຼຶ່ງ ກັອຍ ອຶນນັ່ອງ ແອີດ ຕຶ່ງ ປຶ່ຮ ທາເລ ຣາປັ່ງ ຢັ່ຮ ໄນ່. ໄລ່ ກັອຍ ດັງ ຊາເດົາ ໄຮ ອຶນໄນ່ ເບີນ ແອີງ ມານຳ ຊັອງ ຕົວະ. ກະ ໄລ່ ດັງ ເຕ່ ເຢຊູ ຕາ ເບີນ ຈິ່ຮ ຕຶ່ງ ຕົວະ ກັອຍ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ. ມາ ແອີງ ມູ່ ກາ ຣຍານ ແຕ ອັນ ຊັອງ ເປາະ ຕຶ່ງ ຕົວະ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ມາ ຕາໄງ ກັອຍ ເບີນ ຕົວະ ການໍ່ອ໌ ແອັນ ແຕີ່ອ໌ ແຕ ເມືອງ ຕີເບເຣຍ. ຕົວະ ໄນ່ ແອີດ ຕຶ່ງ ປຶ່ຮ ແຈ່ະ ອຶນຕຸ ເຢຊູ ຊາແອີນ ໂດຍ ບຸຮ ໂອນ ກວາຍ ກຼຶ່ງ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ພໍກາ ກວາຍ ກຼຶ່ງ ເຮີມ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ຕາ ເບີນ ແອີດ ນັ່ອງ ອຶນຕຸ ກັອຍ, ໄລ່ ຈິ່ຮ ຕຶ່ງ ຕົວະ ເຕ່, ກະ ໄລ່ ເປາະ ປໍ ເມືອງ ກາເປນາອູມ ຈໍ່ອ໌ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ພໍກາ ກວາຍ ກຼຶ່ງ ຣາມົຮ ເຢຊູ ຢັ່ຮ ອຶນຕົ່ຮ ທາເລ ຣາປັ່ງ, ໄລ່ ຕາແບີບ ອັນ ປາຍ: \"ອາຈານ ເອີຍ! ບັອງ ກາ ແລ່ະ ອາຈານ ແຕີ່ອ໌ ປໍ ໄນ່?\" ");
INSERT INTO ncq_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ມາ ເຢຊູ ຕາແອີຍ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ມັຮ ເຍືາ ຈໍ່ອ໌ ເກົາ, ຕາ ແກີນ ຍ່ອນ ເຍືາ ເຮີມ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ເກົາ ຕະ, ມາ ເຍືາ ຈໍ່ອ໌ ເກົາ ຊານໍ່, ຍ່ອນ ປາໄຮ ເຍືາ ຈາ ປາໄຊ ຊັຣນາ ແຕ ເກົາ. ນ່ະກັອຍ ຊານໍ່ ເຍືາ ຈໍ່ອ໌ ຢໍອ໌ ອີ ຈາ ຊາ. ");
INSERT INTO ncq_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ອຶງເຄາະ ເຍືາ ອຶນໂຈຍ ຕະ ຣານະ ຈໍ່ອ໌ ອີ ເບີນ ຊັຣນາ ຕຶ່ງ ແດີຍ ໄນ່ ຊັອງ. ຊັຣນາ ໄນ່ ຕາ ເຕ່ອ໌ ແອີດ ດູ່ນ. ມາ ອຶງເຄາະ ເຍືາ ຕະ ຣານະ ຈໍ່ອ໌ ຊັຣນາ ໂອນ ເຍືາ ເຕ່ອ໌ ອາມົ່ງ ເລືອຍໆ. ຊັຣນາ ໄນ່ ກອນ ເຢືາງ ແກີດ ກວາຍ ໂອນ ເຍືາ ເບີນ, ຍ່ອນ ເຢືາງ ເຈົາຣາຊີ ອຶມປໍ່ ອັນ, ກາຕິຮ ຕາ ເຈີ່ ໂອນ ກອນ ອັນ ຕະ ຣານະ ຕາງ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ເຈີ່ ກວາຍ ກຼຶ່ງ ຕາແບີບ ເຢຊູ ປາຍ: \"ຮິ ອຶງເຄາະ ຕະ ຣານະ ອຶນເຕົ່າ ໂອນ ຕະ ໄກຣ ຣາງຶ່ຮ ເຢືາງ ເຈົາຣາຊີ ຢໍອ໌?\" ");
INSERT INTO ncq_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ໄນ່ ລາ ຣານະ ເຢືາງ ເຈົາຣາຊີ ໂອນ ເຍືາ ຕະ: ອຶງເຄາະ ເຍືາ ຊາອຳ ອັນ ກາ ເຢືາງ ເຈົາຣາຊີ ແປຣີ ແຕີ່ອ໌ ປໍ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ໄລ່ ກັອຍ ຕາແບີບ ອັນ ປາຍ: \"ໄມ່ ອີ ຕະ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ອຶນເຕົ່າ ໂອນ ເຕ່ອ໌ ຮິ ເຮີມ ກະ ຊາອຳ ໄມ່? ນານ່ະ ໄມ່ ຕະ? ");
INSERT INTO ncq_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ອາຈວາຍຮ ອາເຈ່ຮ ໄຮ ແຕ ອຶມແບິ ຈາ ມານາ ແຕ ມັນລັ່ອງ ຕຶ່ງ ຕຍາຮ. ຣານະ ໄນ່ ເນົ່າ ຄຽນ ເຈີ່ ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ປາຍ: 'ອັນ ໂອນ ໄລ່ ຈາ ຊັຣນາ ແຕ ມັນລັ່ອງ.'\" ");
INSERT INTO ncq_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ເຢຊູ ປາຍ ໂຈະ ໄລ່: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ຕາ ແກີນ ໂມເຊ ໂອນ ເຍືາ ຈາ ຊັຣນາ ແຕ ມັນລັ່ອງ. ມາ ແອີງ ອຶມປໍ່ ເກົາ ແຕິ່ ໂອນ ເຍືາ ຈາ ຊັຣນາ ກາ ກຣັ່ກ ອໍ, ຊັຣນາ ໄນ່ ອັນ ອາແຊງ ແຕ ມັນລັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ຊັຣນາ ເຢືາງ ເຈົາຣາຊີ ລາ ອັນ ກາ ແຊງ ແຕ ມັນລັ່ອງ, ກະ ຊັຣນາ ໄນ່ ໂອນ ກວາຍ ຕຶ່ງ ກູແຕອ໌ ໄນ່ ເບີນ ອາມົ່ງ.\" ");
INSERT INTO ncq_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ໄລ່ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ແຊອ໌ ອຶນເຈົາ ໂອນ ຮິ ເບີນ ເລືອຍໆ ຊັຣນາ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ເຢຊູ ອາຕີ ໄລ່ ປາຍ: \"ເກົາ ໄນ່ ແຕິ່ ລາ ຊັຣນາ ໂອນ ເຍືາ ອາມົ່ງ. ກວາຍ ອາແລ່ະ ກາ ແຕີ່ອ໌ ປໍ ເກົາ, ກວາຍ ກັອຍ ຕາ ເບີນ ຊັອງ ມາເຍືາຍຮ ນັ່ອງ. ກະ ກວາຍ ອາແລ່ະ ກາ ຊາອຳ ເກົາ, ກວາຍ ກັອຍ ຕາ ເບີນ ຊາລາອ໌ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","\"ມາ ເກົາ ອາຕີ ເຍືາ ເຈີ່, ເຍືາ ເຮີມ ເກົາ, ມາ ອຶນນັ່ອງ ເຍືາ ຕາ ເບີນ ຊາອຳ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ມັຮ ກວາຍ ກາ ອຶມປໍ່ ເກົາ ໂອນ ແຕີ່ອ໌ ປໍ ເກົາ, ອຶນແຍ່ະ ມັຮ ກວາຍ ກັອຍ ແຕີ່ອ໌ ປໍ ເກົາ. ກະ ອຶນແຍ່ະ ມັຮ ກວາຍ ກາ ແຕີ່ອ໌ ປໍ ເກົາ, ເກົາ ຕາ ເກີ່ຍ ຕູ່ຍຮ ໄລ່ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ຍ່ອນ ເກົາ ແຊງ ແຕ ມັນລັ່ອງ ຕາ ແກີນ ເກົາ ອີ ຕາປູ່ນ ຣາງຶ່ຮ ເກົາ ເບີມ, ມາ ເກົາ ອີ ຕາປູ່ນ ຣາງຶ່ຮ ອັນ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ໄນ່ ລາ ຣາງຶ່ຮ ອັນ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌: ອັນ ຕາ ໂອນ ເກົາ ປິ່ດ ມານະ ແຕ ອຶນແຍ່ະ ມັຮ ກວາຍ ກາ ອັນ ໂອນ ເກົາ ເບີນ. ກະ ແຕີ່ອ໌ ຕາໄງ ປັຣຊົດ ອັນ ຢໍອ໌ ເກົາ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ ກັອຍ ອາມົ່ງ ລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ໄນ່ ລາ ຣາງຶ່ຮ ອຶມປໍ່ ເກົາ: ອຶນແຍ່ະ ມັຮ ກວາຍ ກາ ເຮີມ ກອນ ອັນ ກະ ຊາອຳ ກອນ ກັອຍ, ອຶນແຍ່ະ ໄລ່ ກັອຍ ເບີນ ອາມົ່ງ ເລືອຍໆ. ກະ ແຕີ່ອ໌ ຕາໄງ ປັຣຊົດ ເກົາ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ ກັອຍ ອາມົ່ງ ລັ່ຮ.\" ");
INSERT INTO ncq_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ຈຸ່ມ ອິດຊະຣາເອລ ກັອຍ ໂຍ່ບ ບູແບະ ບູບື່ບ ແຕ ເຢຊູ, ຍ່ອນ ອັນ ປາຍ: \"ເກົາ ລາ ຊັຣນາ ກາ ແຊງ ແຕ ມັນລັ່ອງ.\" ");
INSERT INTO ncq_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ຈຸ່ມ ອິດຊະຣາເອລ ປາຍ: \"ປຍາຍ໌ ມາ ຕາ ເບີນ, ກວາຍ ໄນ່ ລາ ເຢຊູ, ກອນ ໂຢເຊັບ? ໄຮ ດັງ ເຈີ່ ອຶມເປ່ອ໌ ອຶມປໍ່ ອັນ. ນານ່ະ ເຕ່ອ໌ ອັນ ປາຍ ອັນ ແຊງ ແຕ ມັນລັ່ອງ?\" ");
INSERT INTO ncq_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ເຢຊູ ຕາແອີຍ ໄລ່ ກັອຍ ປາຍ: \"ເຍືາ ອຶນໂຈຍ ບູແບະ ນັ່ອງ ຕາ ແກີດ ຣາມຶ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ຄັນ ອຶມປໍ່ ເກົາ ຕຶ່ງ ມັນລັ່ອງ, ອັນ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່, ມາ ຕາ ເບີນ ເດີງ ກວາຍ ແຕີ່ອ໌ ປໍ ເກົາ, ຕາ ເບີນ ເນົ່າ ເຕ່ອ໌ ແຕີ່ອ໌ ປໍ ເກົາ. ກະ ແຕີ່ອ໌ ຕາໄງ ປັຣຊົດ, ກວາຍ ອາແລ່ະ ກາ ແຕີ່ອ໌ ປໍ ເກົາ, ເກົາ ໂອນ ກວາຍ ກັອຍ ເບີນ ອາມົ່ງ ລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ເບີນ ເນົ່າ ຄຽນ ເຈີ່ ຕຶ່ງ ປຶ່ງ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ປາຍ: 'ເຢືາງ ເຈົາຣາຊີ ອາຕີ ອຶນແຍ່ະ ມັຮ ກວາຍ.' ອາແລ່ະ ກາ ຊາງັດ ປັຣນາຍ ອຶມປໍ່ ຕຶ່ງ ມັນລັ່ອງ ກະ ຣຍານ ແຕ ອັນ, ມັຮ ກວາຍ ກັອຍ ແຕີ່ອ໌ ປໍ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ຕາ ເບີນ ກວາຍ ອາແລ່ະ ເຮີມ ອຶມປໍ່ ເກົາ ຕຶ່ງ ມັນລັ່ອງ, ມາ ອັນ ກາ ແຕີ່ອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ, ແອີງ ອັນ ແຕິ່ ເບີນ ເຮີມ ອຶມປໍ່. ");
INSERT INTO ncq_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ກວາຍ ອາແລ່ະ ກາ ຊາອຳ ເກົາ, ກວາຍ ກັອຍ ເບີນ ອາມົ່ງ ເລືອຍໆ. ");
INSERT INTO ncq_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ເກົາ ລາ ຊັຣນາ ກາ ໂອນ ກວາຍ ເບີນ ອາມົ່ງ. ");
INSERT INTO ncq_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ອາຈວາຍຮ ອາເຈ່ຮ ເຍືາ ຈາ ມານາ ແຕ ມັນລັ່ອງ ຕຶ່ງ ຕຍາຮ, ມາ ອຶນນັ່ອງ ໄລ່ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ມາ ໄນ່ ລາ ຊັຣນາ ກາ ແຊງ ແຕ ມັນລັ່ອງ; ຄັນ ກວາຍ ອາແລ່ະ ຈາ ຊັຣນາ ໄນ່, ກວາຍ ກັອຍ ຕາ ເບີນ ກູຈີດ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ເກົາ ລາ ຊັຣນາ ອາມົ່ງ ກາ ແຊງ ແຕ ມັນລັ່ອງ. ຄັນ ອາແລ່ະ ຈາ ຊັຣນາ ໄນ່, ກວາຍ ກັອຍ ເບີນ ອາມົ່ງ ເລືອຍໆ. ມາ ຊັຣນາ ໄນ່ ລາ ໄຊອ໌ ເກົາ, ກາ ເກົາ ອີ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ ດໍອ໌ ເຕ່ອ໌ ອາມົ່ງ ເລືອຍໆ.\" ");
INSERT INTO ncq_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ກວາຍ ແຕ ຈຸ່ມ ອິດຊະຣາເອລ ໄລ່ ຣາຈຽນ ຣາຕວາອ໌; ເຈີ່ ຕາແບີບ ປາຍ: \"ນານ່ະ ອັນ ໄນ່ ໂອນ ໄຮ ຈາ ໄຊອ໌ ອັນ ແອັນ?\" ");
INSERT INTO ncq_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ເຢຊູ ອາຕີ ລັ່ຮ ໄລ່ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ຄັນ ເຍືາ ຕາ ເບີນ ຈາ ໄຊອ໌ ກອນ ເຢືາງ ແກີດ ກວາຍ ກະ ຕາ ເບີນ ງ່ອຍ໌ ອາຮາມ ອັນ, ເຍືາ ຕາ ເບີນ ອາມົ່ງ. ");
INSERT INTO ncq_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ກວາຍ ອາແລ່ະ ຈາ ໄຊອ໌ ເກົາ ກະ ງ່ອຍ໌ ອາຮາມ ເກົາ, ກວາຍ ກັອຍ ເບີນ ອາມົ່ງ ເລືອຍໆ; ກະ ແຕີ່ອ໌ ຕາໄງ ປັຣຊົດ, ເກົາ ໂອນ ອັນ ອາມົ່ງ ລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ຍ່ອນ ໄຊອ໌ ເກົາ ລາ ຊັຣນາ ປຍາຍ໌ ລາລື່, ກະ ອາຮາມ ເກົາ ລາ ເກຣີ່ງ ງ່ອຍ໌ ປຍາຍ໌ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ກວາຍ ອາແລ່ະ ກາ ຈາ ໄຊອ໌ ເກົາ ກະ ງ່ອຍ໌ ອາຮາມ ເກົາ, ກວາຍ ກັອຍ ແອີດ ມູ ຣາງຶ່ຮ ກະ ເກົາ, ກະ ເກົາ ແອີດ ມູ ຣາງຶ່ຮ ກະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ອຶມປໍ່ ເກົາ ກາ ອາມົ່ງ ເລືອຍໆ, ອັນ ກັອຍ ແປຣີ ເກົາ ແຕີ່ອ໌. ເກົາ ອາມົ່ງ ຍ່ອນ ອຶມປໍ່ ເກົາ ໂອນ ເກົາ ອາມົ່ງ. ມູເຈິງ ກັອຍ ເຕ່, ກວາຍ ອາແລ່ະ ກາ ຈາ ໄຊອ໌ ເກົາ, ກວາຍ ກັອຍ ເບີນ ອາມົ່ງ ຍ່ອນ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ໄນ່ ລາ ຊັຣນາ ກາ ແຊງ ແຕ ມັນລັ່ອງ. ຊັຣນາ ໄນ່ ອຶມພາ ແຕ ຊັຣນາ ແຕ ມັນລັ່ອງ ກາ ອາຈວາຍຮ ອາເຈ່ຮ ໄຮ ຈາ ແຕ ອຶມແບິ. ໄລ່ ຈາ ຊັຣນາ ກັອຍ, ມາ ອຶນນັ່ອງ ໄລ່ ກູຈີດ. ກວາຍ ອາແລ່ະ ກາ ຈາ ຊັຣນາ ເກົາ, ກວາຍ ກັອຍ ເບີນ ອາມົ່ງ ເລືອຍໆ.\" ");
INSERT INTO ncq_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ມັຮ ປັຣນາຍ ໄນ່ ເຢຊູ ອາຕີ ຕຶ່ງ ດຸງ ຊາງ ກວາຍ ອິດຊະຣາເອລ ຕຶ່ງ ເມືອງ ກາເປນາອູມ. ");
INSERT INTO ncq_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ແຕີ່ອ໌ ກຼຶ່ງ ກວາຍ ກາ ປວາຍ ເຢຊູ ຊາງັດ ອັນ ອາຕີ ປັຣນາຍ ກັອຍ, ໄລ່ ປາຍ: \"ກັ່ດ ລາລື່ ຣາມຶ່ຮ ອັນ ອາຕີ ໄນ່. ເນົ່າ ເຕ່ອ໌ ດັງ ຣາມຶ່ຮ ກັອຍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ເຢຊູ ດັງ ມັຮ ມູ່ ກາ ປວາຍ ອັນ, ໄລ່ ບູແບະ ບູບື່ບ ນ່ະກັອຍ; ເຈີ່ ອັນ ອາຕີ ໄລ່ ປາຍ: \"ຣາມຶ່ຮ ໄນ່ ຕະ ໂອນ ເຍືາ ຊັອງ ຕາ ແອອ໌ ອີ ປວາຍ ນັ່ອງ ບໍ? ");
INSERT INTO ncq_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ຄັນ ນ່ະກັອຍ, ນານ່ະ ເຍືາ ຄຶ່ດ ຄັນ ເຍືາ ເຮີມ ກອນ ເຢືາງ ແກີດ ກວາຍ ຊັອຮ ລັ່ຮ ປໍ ອຶນຕຸ ອັນ ແອີດ ແຕ ອຶນໂຍ່ງ? ");
INSERT INTO ncq_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ໄກຣ ເຈີ່, ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ຕະ ໂອນ ກວາຍ ເບີນ ອາມົ່ງ, ມາ ໄຊອ໌ ກວາຍ ຕາ ເຕ່ອ໌ ຕະ ນ່ະກັອຍ. ມັຮ ປັຣນາຍ ເກົາ ອາຕີ ເຍືາ ເຈີ່, ປັຣນາຍ ໄນ່ ແຕີ່ອ໌ ແຕ ຣາເວືາຍ, ກະ ປັຣນາຍ ໄນ່ ເຕ່ອ໌ ໂອນ ອາມົ່ງ. ");
INSERT INTO ncq_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ມາ ອຶນນັ່ອງ ເບີນ ເນົ່າ ແຕ ເຍືາ ຕາ ເບີນ ຊາອຳ ເກົາ.\" ເຢຊູ ປາຍ ນ່ະກັອຍ, ອັນ ດັງ ແຕ ອຶນໂຍ່ງ ເຈີ່ ມັຮ ກວາຍ ຕາ ເບີນ ຊາອຳ ອັນ, ກະ ອັນ ດັງ ເຈີ່ ຕຶ່ງ ມູ່ ອັນ ເບີນ ມານະ ອີ ມ່ອບ ອັນ ໂອນ ເນົ່າ ກາຈີດ. ");
INSERT INTO ncq_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ກະ ເຢຊູ ປາຍ ແອັນ: \"ນ່ະກັອຍ ເກົາ ອາຕີ ເຍືາ ແຕ ອຶນໂຍ່ງ ເຈີ່, ຄັນ ອຶມປໍ່ ເກົາ ຕຶ່ງ ມັນລັ່ອງ ຕາ ເບີນ ໂອນ ເນົ່າ ແຕີ່ອ໌ ປໍ ເກົາ, ຕາ ເບີນ ອາແລ່ະ ເຕ່ອ໌ ແຕີ່ອ໌ ປໍ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ພໍກາ ເຢຊູ ປາຍ ອຶນແຍ່ະ ມັຮ ປັຣນາຍ ກັອຍ, ເບີນ ຊາອຶ່ຍ ນະ ແຕ ມູ່ ກາ ປວາຍ ອັນ ຕັຮ ຕາ ແອອ໌ ອີ ປວາຍ ນັ່ອງ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ເຢຊູ ຕາແບີບ ໄລ່ ມວຍ ຈິ່ດ ລາ ບາຣ ນະ ແອັນ: \"ເຍືາ ຢໍອ໌ ອີ ລັ່ອຮ ເຕ່ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ຊີໂມນ ເປໂຕ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ຕາ ເບີນ ເນົ່າ ຮິ ອີ ປວາຍ ນັ່ອງ. ແອີງ ອຶນເຈົາ ຊັອງ ເບີນ ປັຣນາຍ ກາ ໂອນ ກວາຍ ເບີນ ອາມົ່ງ ເລືອຍໆ. ");
INSERT INTO ncq_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ຮິ ຊາອຳ ເຈີ່ ກະ ດັງ ແຈງ ລາລື່ ອຶນເຈົາ ລາ ອັນ ກາ ຕານັ່ອງ ອໍ ກາ ແຕີ່ອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ເຈີ່ ເຢຊູ ຕາແອີຍ ປາຍ: \"ເກົາ ຣຽຮ ເຍືາ ມວຍ ຈິ່ດ ລາ ບາຣ ນະ ເຈີ່. ມາ ເບີນ ມານະ ແຕ ເຍືາ ອີ ແກີດ ເຢືາງ ຕາ ອໍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ປັຣນາຍ ໄນ່ ເຢຊູ ອາຕີ ແຕ ຢູດາ, ກອນ ຊີໂມນ ອິດຊະກາຣີອົດ. ຢູດາ ລາ ມານະ ແຕ ມູ່ ໄລ່ ມັນຈິ່ດ ລາ ບາຣ ນະ, ມາ ປັຣແນີ ມັນເຕຣືາ ອັນ ອີ ມ່ອບ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ແວັດ ກັອຍ ເຢຊູ ເປາະ ປຼັຮ ອຶນແຍ່ະ ຕຶ່ງ ແຄງ ຄາລີເລ. ອັນ ຕາ ແອອ໌ ອີ ມູ່ດ ຕຶ່ງ ແຄງ ຢູດາຍ, ຍ່ອນ ກວາຍ ຊົດ ອິດຊະຣາເອລ ປໍ ກັອຍ ຢໍອ໌ ອີ ກາຈີດ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ແຈ່ະ ອີ ແຕີ່ອ໌ ຈຸ່ມ ອິດຊະຣາເອລ ຈາ ຣໍ່ອ໌ ຕາໄງ ຈົຮ ຕຣັ່ບ. ");
INSERT INTO ncq_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ແຊມອາຍ ເຢຊູ ອາຕີ ອັນ ປາຍ: \"ອໍ ໄມ່ ລັ່ອຮ ແຕ ອຶນໄນ່, ເປາະ ປໍ ແຄງ ຢູດາຍ ແອັນ. ນ່ະກັອຍ ອຶນແຍ່ະ ກວາຍ ກາ ປວາຍ ໄມ່ ເຕ່ອ໌ ເຮີມ ມັຮ ຣານະ ໄມ່ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ຄັນ ກວາຍ ອາແລ່ະ ຢໍອ໌ ກວາຍ ການໍ່ອ໌ ດັງ ຣາມຶ່ຮ ອັນ, ອັນ ຕາ ເບີນ ຕະ ຣານະ ປາໂຕ່ະ. ມັຮ ຣານະ ອຶນເຕົ່າ ໄມ່ ຕະ, ອຶງເຄາະ ໄມ່ ອາປັຮ ໂອນ ກູ່ ນະ ເບີນ ເຮີມ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ມາ ແຊມອາຍ ເຢຊູ ລາ ຕາ ເບີນ ຊາອຳ ເຕ່ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ນ່ະກັອຍ ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ຕາ ຢວາຮ ແຕີ່ອ໌ ປາເນ່ນ ເກົາ ອາປັຮ ໂອນ ກູ່ ນະ ດັງ. ມາ ປາເນ່ນ ເຍືາ, ເປາະ ບັອງ ແລ່ະ ລາ ເຕ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ກວາຍ ຕຶ່ງ ແດີຍ ໄນ່ ຕາ ເຕ່ອ໌ ຊາອັຣ ເຍືາ, ມາ ໄລ່ ຊາອັຣ ເກົາ ຍ່ອນ ເກົາ ອາຕີ ອຶນແຍ່ະ ຣານະ ໄລ່ ຕະ ລາ ຕາ ອໍ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ແອີງ ເຍືາ ຊັອງ ເປາະ ຈາ ຣໍ່ອ໌ ຊາແຍີ ຕາໄງ ຈົຮ ຕຣັ່ບ. ເກົາ ຕາ ຢວາຮ ເປາະ ປໍ ກັອຍ, ຍ່ອນ ຕາ ຢວາຮ ແຕີ່ອ໌ ປາເນ່ນ ເກົາ ເປາະ.\" ");
INSERT INTO ncq_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ອັນ ອຶນນັ່ອງ ແອີດ ຕຶ່ງ ແຄງ ຄາລີເລ. ");
INSERT INTO ncq_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ແວັດ ແຊມອາຍ ອັນ ເປາະ, ເຈີ່ ເຢຊູ ເປາະ ເຕ່, ມາ ອັນ ເປາະ ໂຕ່ະ ຕວຍ໌. ");
INSERT INTO ncq_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ພໍກາ ໄລ່ ຈາ ຣໍ່ອ໌ ກັອຍ, ກວາຍ ຊົດ ອິດຊະຣາເອລ ຈໍ່ອ໌ ເຢຊູ ກະ ໄລ່ ຕາແບີບ ປາຍ: \"ປໍ ແລ່ະ ອັນ ກັອຍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ກະ ກຼຶ່ງ ກວາຍ ກັອຍ ຣາຮາຍ໌ ແຕ ເຢຊູ ເຕ່. ເບີນ ອັນ ກາ ປາຍ: \"ເຢຊູ ໄນ່ ລາ ກວາຍ ອໍ.\" ມາ ເບີນ ອັນ ກາ ປາຍ: \"ຕາ ແກີນ! ເຢຊູ ໄນ່, ອັນ ບູບວກ ກວາຍ ການໍ່ອ໌.\" ");
INSERT INTO ncq_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ມາ ຕາ ເບີນ ເນົ່າ ຍັ່ນ ຕະ ອຶນຕີ ແຕ ເຢຊູ ໂອນ ກວາຍ ການໍ່ອ໌ ດັງ, ຍ່ອນ ໄລ່ ອຶງກັອຮ ກວາຍ ຊົດ ອິດຊະຣາເອລ. ");
INSERT INTO ncq_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ຕາປູ່ລ ຕາໄງ ເນົ່າ ເກີ່ຍ ຈາ ຣໍ່ອ໌ ຊາແຍີ ຕາໄງ ຈົຮ ຕຣັ່ບ. ມາ ແຕີ່ອ໌ ຕາໄງ ປູນ ເຢຊູ ມູ່ດ ຕຶ່ງ ຊັງອາຣ ດຸງ ຊາງ ປື່ດ. ອັນ ຕາແບິ ອາຕີ ຕຶ່ງ ອຶນຕຸ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ກວາຍ ຊົດ ອິດຊະຣາເອລ ຊັອງ ງຶ່ດ ລາລື່, ກະ ໄລ່ ຕາແບີບ ປາຍ: \"ນານ່ະ ອັນ ໄນ່ ຕາ ຢວາຮ ຣຍານ, ມາ ອັນ ດັງ ຊາອຶ່ຍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ເຢຊູ ຕາແອີຍ ໄລ່ ກັອຍ ປາຍ: \"ປັຣນາຍ ເກົາ ອາຕີ ຕາ ເບີນ ແຕີ່ອ໌ ແຕ ເກົາ ເບີມ, ມາ ປັຣນາຍ ໄນ່ ແຕີ່ອ໌ ແຕ ອັນ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ຄັນ ກວາຍ ອາແລ່ະ ຢໍອ໌ ອີ ຕາປູ່ນ ຣາງຶ່ຮ ເຢືາງ ເຈົາຣາຊີ, ກວາຍ ກັອຍ ດັງ ປັຣນາຍ ເກົາ ອາຕີ ແຕີ່ອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ, ແຕີລາ ແຕີ່ອ໌ ແຕ ເກົາ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ກວາຍ ອາແລ່ະ ກາ ອາຕີ ປັຣນາຍ ແຕ ອັນ ເບີມ, ກວາຍ ກັອຍ ຢໍອ໌ ອີ ໂອນ ກວາຍ ການໍ່ອ໌ ຍ່ອງ ອັນ. ມາ ກວາຍ ອາແລ່ະ ກາ ຕະ ຣານະ ໂອນ ເນົ່າ ຍ່ອງ ອັນ ກາ ແປຣີ ອັນ ແຕີ່ອ໌, ກວາຍ ກັອຍ ລາ ກວາຍ ກຣັ່ກ ລາລື່, ກະ ອັນ ຕາ ເບີນ ເບີນ ມວຍ ຣາມຶ່ຮ ອຶນເຕົ່າ ຕາ ອໍ ຕຶ່ງ ຣາງຶ່ຮ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ໂມເຊ ໂອນ ເຍືາ ເບີນ ຄານອດ ເຢືາງ ເຈົາຣາຊີ ເຈີ່. ມາ ຕາ ເບີນ ເນົ່າ ແຕ ເຍືາ ຕະ ປວາຍ ຄານອດ ກັອຍ. ຍ່ອນ ນານ່ະ ເຍືາ ຈໍ່ອ໌ ຣາລິ່ຮ ອີ ກາຈີດ ເກົາ?\" ");
INSERT INTO ncq_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ກວາຍ ກຼຶ່ງ ກັອຍ ຕາແອີຍ ເຢຊູ ປາຍ: \"ໄມ່ ລາ ນ່ະ ກວາຍ ເຢືາງ ຕາ ອໍ ຕຣວບ. ເນົ່າ ກາ ຢໍອ໌ ອີ ກາຈີດ ໄມ່?\" ");
INSERT INTO ncq_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ເຢຊູ ຕາແອີຍ ລັ່ຮ ໄລ່ ກັອຍ: \"ເກົາ ຕະ ມວຍ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ຕາແບິ ມູ່ ເຮີບ ຊັອງ; ເຈີ່ ເຍືາ ງຶ່ດ. ");
INSERT INTO ncq_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ໂມເຊ ໂອນ ເຍືາ ຕະ ຣີ່ດ ກິດ. ມາ ຄັນ ປຍາຍ໌ ຕຶ່ງ ຕາໄງ ຣາລູ່, ລາ ເຍືາ ຕະ ເຕ່. (ມາ ໄກຣ ລາລື່ ຣີ່ດ ໄນ່ ຕາ ເບີນ ແຕີ່ອ໌ ແຕ ໂມເຊ, ມາ ຣີ່ດ ໄນ່ ແຕີ່ອ໌ ແຕ ອາຈວາຍຮ ອາເຈ່ຮ ເຍືາ.) ");
INSERT INTO ncq_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ຄັນ ເຍືາ ເຕ່ອ໌ ຕະ ຣີ່ດ ກິດ ໂອນ ກອນ ຣາເລົາ ຕຶ່ງ ຕາໄງ ຣາລູ່ ຕາ ຢໍອ໌ ອີ ຕັຮ ຄານອດ ໂມເຊ, ນານ່ະ ເຍືາ ອວານ ກະ ເກົາ ຍ່ອນ ເກົາ ປົວ ກວາຍ ອາອີ່ ຕຶ່ງ ຕາໄງ ຣາລູ່? ");
INSERT INTO ncq_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ຄັນ ເຍືາ ເຮີມ ກວາຍ ຕະ ອຶນເຕົ່າ, ເຍືາ ອຶນໂຈຍ ກຸນເຕົາ ຕັດຊີ່ນ ຢວາຮ. ມາ ຄັນ ເຍືາ ອີ ຕັດຊີ່ນ ອຶນເຕົ່າ, ອຶງເຄາະ ເຍືາ ຕາຕ່ອຍ໌ ໂອນ ກຣັ່ກ ເວືາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ເບີນ ມັຮ ກວາຍ ແຕ ເມືອງ ເຢຣູຊາເລັມ ຕາແບີບ ປາຍ: \"ປຍາຍ໌ ບໍ, ອັນ ໄນ່ ກາ ເນົ່າ ຢໍອ໌ ອີ ກາຈີດ? ");
INSERT INTO ncq_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ຊານໍ່ ອັນ ແອີດ ອາຕີ ໂອນ ກູ່ ນະ ຊັອງ ປັຣນາຍ ອັນ, ມາ ຕາ ເບີນ ເນົ່າ ປາຍ ອຶນເຕົ່າ ແຕ ອັນ. ມາ ກວາຍ ຊົດ ດັງ ແຈງ ອັນ ໄນ່ ລາ ກຣີດ ບໍ? ");
INSERT INTO ncq_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ນານ່ະ ເຕ່ອ໌ ແກີດ? ຍ່ອນ ພໍກາ ກຣີດ ແຕີ່ອ໌, ຕາ ເບີນ ເນົ່າ ດັງ ແຕ ແລ່ະ ອັນ ແຕີ່ອ໌. ມາ ເຢຊູ ໄນ່, ໄຮ ດັງ ເຈີ່ ແຕ ແລ່ະ ອັນ ແຕີ່ອ໌.\" ");
INSERT INTO ncq_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ນ່ະກັອຍ ເຢຊູ ອາຕີ ເຣ່ງ ລາລື່ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ ປາຍ: \"ເຍືາ ດັງ ເກົາ ບໍ? ກະ ເຍືາ ດັງ ແຕ ແລ່ະ ເກົາ ແຕີ່ອ໌ ບໍ? ຕາ ແກີນ ເກົາ ຈຸງ ອີ ແຕີ່ອ໌. ມາ ເບີນ ອັນ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌, ອັນ ກັອຍ ລາ ປຍາຍ໌. ມາ ໄກຣ ເຈີ່ ເຍືາ ຕາ ເບີນ ດັງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ມາ ເກົາ ດັງ ອັນ, ຍ່ອນ ເກົາ ແຕີ່ອ໌ ແຕ ອັນ, ກະ ອັນ ແປຣີ ເກົາ ແຕີ່ອ໌.\" ");
INSERT INTO ncq_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ເບີນ ກວາຍ ຢໍອ໌ ອີ ໂກບ ອັນ, ມາ ຕາ ເບີນ ອາແລ່ະ ກູແວີ ອາຕີ ໂກບ ອັນ, ຍ່ອນ ຕາ ຢວາຮ ແຕີ່ອ໌ ປາເນ່ນ ອັນ ຈີວ໌ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ມາ ແຕ ກວາຍ ກຼຶ່ງ ກັອຍ ເບີນ ຊາອຶ່ຍ ນະ ຊາອຳ ເຢຊູ. ໄລ່ ຕາແບີບ ປາຍ: \"ຄັນ ກຣີດ ແຕີ່ອ໌, ອັນ ຕະ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ອໍ ແກຼີຍ ແຕ ອັນ ໄນ່ ຕະ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ກວາຍ ພາຣີຊາຍ ຊັອງ ກວາຍ ກຼຶ່ງ ກັອຍ ຣາຮາຍ໌ ນ່ະກັອຍ ແຕ ເຢຊູ. ເຈີ່ ມັຮ ກວາຍ ພາຣີຊາຍ ກະ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ໄລ່ ແປຣີ ກວາຍ ກາ ກຍາອ໌ ຕຶ່ງ ດຸງ ຊາງ ເປາະ ໂກບ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ເຢຊູ ປາຍ: \"ອຶນນັ່ອງ ບີ່ອ໌ ຕາໄງ ຊັອງ ເກົາ ແອີດ ກະ ເຍືາ. ແວັດ ກັອຍ ເກົາ ເຈົາ ປໍ ອັນ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ຕາໄງ ກັອຍ ເຍືາ ຈໍ່ອ໌ ເກົາ, ມາ ເຍືາ ຕາ ເບີນ ຣາມົຮ ເກົາ. ກະ ອຶນຕຸ ເກົາ ແອີດ, ເຍືາ ຕາ ເຕ່ອ໌ ເປາະ ອຶນຕຸ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ນ່ະກັອຍ ກວາຍ ຊົດ ອິດຊະຣາເອລ ກັອຍ ມານະ ຕາແບີບ ມານະ: \"ອຶນຕຸ ແລ່ະ ກວາຍ ໄນ່ ອີ ເປາະ, ມາ ໄຮ ຕາ ເຕ່ອ໌ ຈໍ່ອ໌ ຣາມົຮ ອັນ? ອຶນນັ່ອງ ອັນ ອີ ເປາະ ປໍ ກວາຍ ອິດຊະຣາເອລ ກາ ແອີດ ກຣວາງ ເຢີ່ງ, ດໍອ໌ ອາຕີ ໄລ່ ກາ ຕາ ແກີນ ກວາຍ ອິດຊະຣາເອລ ຕຶ່ງ ກຣວາງ ກັອຍ ບໍ? ");
INSERT INTO ncq_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ອຶນນໍ່ ອັນ ປາຍ: 'ເຍືາ ຈໍ່ອ໌ ເກົາ, ມາ ເຍືາ ຕາ ເບີນ ຣາມົຮ ເກົາ.' ກະ ອັນ ປາຍ ນ່ະໄນ່ ແຮີ: 'ອຶນຕຸ ເກົາ ແອີດ, ເຍືາ ຕາ ເຕ່ອ໌ ເປາະ ອຶນຕຸ ກັອຍ.' ປັຣນາຍ ອຶນເຕົ່າ ກາ ອັນ ປາຍ ນ່ະໄນ່?\" ");
INSERT INTO ncq_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ຕາໄງ ປັຣຊົດ ເນົ່າ ຈາ ຣໍ່ອ໌ ກັອຍ ລາ ຕາໄງ ປື່ດ ແກຼີຍ ແຕ ຕາໄງ ອຶນໂຍ່ງ. ຕາໄງ ກັອຍ ເຢຊູ ຢວຣ ຕາຢຶ່ງ ກະ ອາຕີ ເຣ່ງ ປາຍ: \"ຄັນ ກວາຍ ອາແລ່ະ ຊັອງ ຊາລາອ໌, ອຶງເຄາະ ກວາຍ ກັອຍ ແຕີ່ອ໌ ປໍ ເກົາ; ເຈີ່ ໂອນ ອັນ ງ່ອຍ໌. ");
INSERT INTO ncq_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ກວາຍ ອາແລ່ະ ກາ ຊາອຳ ເກົາ, ກວາຍ ກັອຍ ລາ ນ່ະ ອັນ ເບີນ ແດີອ໌ ກາ ໂອນ ອາມົ່ງ ຮອຍ ເລືອຍໆ ແຕ ຣາງຶ່ຮ ອັນ. ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ ປາຍ ນ່ະກັອຍ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ເຢຊູ ປາຍ ນ່ະກັອຍ, ອັນ ອາຕີ ແຕ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ. ກວາຍ ອາແລ່ະ ກາ ຊາອຳ ເຢຊູ, ປັຣແນີ ມັນເຕຣືາ ກວາຍ ກັອຍ ເບີນ ຣັ່ບ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ. ຕຶ່ງ ຕາໄງ ກັອຍ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ຕາ ຢວາຮ ແຕີ່ອ໌, ຍ່ອນ ເຢຊູ ຕາ ຢວາຮ ກູຈີດ ກະ ຣັ່ບ ອາງອື່ຣ ແຕ ມັນລັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ຊາອຶ່ຍ ນະ ແຕ ກວາຍ ກຼຶ່ງ ກັອຍ ຊັອງ ເຢຊູ ປາຍ ນ່ະກັອຍ, ກະ ໄລ່ ກັອຍ ປາຍ: \"ໄກຣ ລາລື່ ກວາຍ ໄນ່ ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ກາ ຮິ ອຶງກ່ອງ.\" ");
INSERT INTO ncq_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ກວາຍ ການໍ່ອ໌ ປາຍ: \"ໄກຣ ລາລື່ ອັນ ໄນ່ ລາ ກຣີດ.\" ມາ ເບີນ ກວາຍ ການໍ່ອ໌ ແອັນ ປາຍ: \"ກຣີດ ຕາ ເບີນ ແຕີ່ອ໌ ແຕ ແຄງ ຄາລີເລ. ");
INSERT INTO ncq_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ ປາຍ ກຣີດ ລາ ແຕ ຈຸ່ມເຈືອ ດາວິດ. ກະ ກຣີດ ອຶງເຄາະ ແກີດ ຕຶ່ງ ເມືອງ ເບັດເລເຮັມ ລາ ເມືອງ ດາວິດ ແອີດ.\" ");
INSERT INTO ncq_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ນ່ະກັອຍ ກວາຍ ກຼຶ່ງ ກັອຍ ມານະ ປາຍ ນ່ະໄນ່, ມານະ ປາຍ ນ່ະກັອຍ, ແຕ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ຕຶ່ງ ກວາຍ ກຼຶ່ງ ກັອຍ ເບີນ ກວາຍ ຢໍອ໌ ອີ ໂກບ ອັນ, ມາ ຕາ ເບີນ ເນົ່າ ອາລັ່ອຮ ອາຕີ ໂກບ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ແວັດ ກັອຍ ກວາຍ ກຍາອ໌ ດຸງ ຊາງ ປື່ດ ເຈົາ ລັ່ຮ ປໍ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ກະ ປໍ ຈຸ່ມ ພາຣີຊາຍ ແຮີ. ມັຮ ກວາຍ ຊົດ ກັອຍ ຕາແບີບ ກວາຍ ກຍາອ໌ ປາຍ: \"ນານ່ະ ເຍືາ ຕາ ເບີນ ໂກບ ກວາຍ ກັອຍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ກວາຍ ກຍາອ໌ ກັອຍ ຕາແອີຍ ປາຍ: \"ຮິ ຕາ ເກີ່ຍ ຊັອງ ກວາຍ ຕະ ອຶນຕີ ນ່ະ ອັນ ໄນ່ ຕະ ອຶນຕີ.\" ");
INSERT INTO ncq_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ຈຸ່ມ ພາຣີຊາຍ ຕາແບີບ ລັ່ຮ ປາຍ: \"ກາ ເຍືາ ຊາງັດ ເຕ່ ມັຮ ປັຣນາຍ ອັນ ຕະ ອຶນຕີ ອາໂລກ ກັອຍ ບໍ? ");
INSERT INTO ncq_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ເບີນ ອາແລ່ະ ເຍືາ ເຮີມ ກວາຍ ຊົດ ແຕີລາ ກວາຍ ແຕ ຈຸ່ມ ພາຣີຊາຍ ຊາອຳ ອັນ? ");
INSERT INTO ncq_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ມາ ມັຮ ກອນແຊມ ໄນ່, ໄລ່ ຕາ ດັງ ອຶນເຕົ່າ ເລີ່ຍ ແຕ ຄານອດ ໂມເຊ. ນ່ະກັອຍ ເຢືາງ ເຈົາຣາຊີ ເວ່ນ ໄລ່ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ເບີນ ມານະ ແຕ ມູ່ ກວາຍ ຊົດ ກັອຍ, ຣາມຶ່ຮ ອັນ ລາ ນີໂກເດມ. ບັອງ ອາໄຣ່ ອັນ ແຕີ່ອ໌ ປໍ ເຢຊູ ເຈີ່. ອັນ ຕາແບີບ ກວາຍ ຊົດ ການໍ່ອ໌ ກັອຍ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","\"ຄັນ ປວາຍ ຄານອດ ໄຮ, ເຕ່ອ໌ ບໍ ໄຮ ຕັດຊີ່ນ ປັຣນາຍ ກວາຍ ຄັນ ໄຮ ຕາ ຢວາຮ ຊັອງ ກະ ຕາ ຢວາຮ ດັງ ອຶນເຕົ່າ ອັນ ໂລ່ຍຮ?\" ");
INSERT INTO ncq_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ຈຸ່ມ ກວາຍ ຊົດ ຕາແອີຍ ນີໂກເດມ ປາຍ: \"ໄມ່ ລາ ກວາຍ ແຕ ແຄງ ຄາລີເລ ເຕ່ ບໍ? ຄັນ ໄມ່ ຈໍ່ອ໌ ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ໄມ່ ຕາ ເບີນ ຣາມົຮ ອຶນຕຸ ອາແລ່ະ ປັຣນາຍ ກັອຍ ອາຕີ ແຕ ມານະ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕີ່ອ໌ ແຕ ແຄງ ຄາລີເລ.\" ");
INSERT INTO ncq_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ແວັດ ກັອຍ ອຶນແຍ່ະ ມັຮ ໄລ່ ກັອຍ ລົ່ບ ເຈົາ ລັ່ຮ ປໍ ດຸງ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ມາ ເຢຊູ ຊັອຮ ປໍ ກົຮ ອາໂປ່ນ. ");
INSERT INTO ncq_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ແຕີ່ອ໌ ປັ່ງ ຕາຣື່ບ ເຢຊູ ເປາະ ລັ່ຮ ປໍ ຊັງອາຣ ດຸງ ຊາງ ປື່ດ. ເບີນ ກຼຶ່ງ ກວາຍ ໂຣ່ມ ອຶມແປຣ ອັນ. ນ່ະກັອຍ ອັນ ຕາກູ ອາຕີ ໄລ່ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ຈຸ່ມ ກາ ອາຕີ ຄານອດ ກະ ຈຸ່ມ ພາຣີຊາຍ, ໄລ່ ເດີງ ອາຊວຍ ມັນແຊມ ກາ ປັຣລື່ຍ ກະ ຣາເລົາ. ໄລ່ ໂອນ ມັນແຊມ ກັອຍ ຕາຢຶ່ງ ອຶນດີ ມູ່ ກາ ແອີດ ອຶມແປຣ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ກະ ໄລ່ ອາຕີ ເຢຊູ ປາຍ: \"ອາຈານ ເອີຍ! ເບີນ ກວາຍ ຣາມົຮ ມັນແຊມ ໄນ່ ປັຣລື່ຍ ກະ ຣາເລົາ. ");
INSERT INTO ncq_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ຕຶ່ງ ຄານອດ ໄຮ, ໂມເຊ ອາຕີ ເຈີ່ ປາຍ: ຄັນ ກວາຍ ອາແລ່ະ ຕະ ຕາ ອໍ ນ່ະໄນ່, ອຶງເຄາະ ແກຼງ ຕາເມົາ ໂຈະ ອັນ ເຕົ່າ ອັນ ກູຈີດ. ມາ ນານ່ະ ອາຈານ ປາຍ ແຕ ຣານະ ໄນ່?\" ");
INSERT INTO ncq_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ໄລ່ ຕາແບີບ ນ່ະກັອຍ ຢໍອ໌ ອີ ລ່ອງ ເຢຊູ. ໄລ່ ຈໍ່ອ໌ ຣານະ ອີ ປ່ອງ ເຢຊູ. ມາ ເຢຊູ ປູບ ອາແຊງ ອີດ ກັລດອຍ ອາຕີ ຄຽນ ຕຶ່ງ ກູແຕອ໌. ");
INSERT INTO ncq_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ພໍກາ ໄລ່ ກາ ເດີງ ມັນແຊມ ກັອຍ ຕາແບີບ ເລືອຍໆ ອັນ, ເຢຊູ ຢວຣ ກະ ອາຕີ ໄລ່ ປາຍ: \"ຄັນ ເບີນ ມານະ ແຕ ເຍືາ ມາ ຕາ ເບີນ ໂລ່ຍຮ ອຶນເຕົ່າ, ໂອນ ກວາຍ ກັອຍ ແກຼງ ອຶນໂຍ່ງ ຕາເມົາ ໂຈະ ມັນແຊມ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ເຈີ່ ເຢຊູ ຄຽນ ຕຶ່ງ ກູແຕອ໌ ຊາ. ");
INSERT INTO ncq_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ພໍກາ ກວາຍ ກັອຍ ຊັອງ ປັຣນາຍ ເຢຊູ ປາຍ ນ່ະໄນ່, ອຶນແຍ່ະ ມັຮ ໄລ່ ລັ່ອຮ ແຕ ອຶນຕຸ ກັອຍ, ມັຮ ກວາຍ ເທົາ ລັ່ອຮ ອຶນໂຍ່ງ, ເຕົ່າ ກາ ອຶນນັ່ອງ ແອີງ ເຢຊູ ກະ ມັນແຊມ ກັອຍ ຊັອງ ແອີດ ອຶນຕຸ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ເຢຊູ ຢວຣ ລັ່ຮ ກະ ຕາແບີບ ມັນແຊມ ກັອຍ ປາຍ: \"ອາມໍອ໌ ເອີຍ! ປໍ ແລ່ະ ກວາຍ ກາ ຕິ ໄມ່? ໄລ່ ອຶນນັ່ອງ ອີ ຕິ ໄມ່ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ມັນແຊມ ກັອຍ ຕາແອີຍ ປາຍ: \"ຕາ ເບີນ ເນົ່າ ນັ່ອງ, ອຶນເຈົາ ເອີຍ.\" ເຢຊູ ຕາແອີຍ ລັ່ຮ: \"ເກົາ ຕາ ເບີນ ຕິ ໄມ່ ເຕ່. ເຕ່ອ໌ ໄມ່ ເປາະ, ມາ ໄມ່ ອຶນໂຈຍ ຕະ ໂລ່ຍຮ ນັ່ອງ.\" ");
INSERT INTO ncq_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ເຢຊູ ອາຕີ ລັ່ຮ ກວາຍ ອິດຊະຣາເອລ ປາຍ: \"ເກົາ ລາ ກັ່ລ ປັ່ງ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ. ກວາຍ ອາແລ່ະ ກາ ປວາຍ ເກົາ ຕາ ເບີນ ເປາະ ຕຶ່ງ ອຶນຕຸ ການຳ, ມາ ອັນ ເບີນ ແອີງ ປັ່ງ ກາ ໂອນ ອັນ ອາມົ່ງ.\" ");
INSERT INTO ncq_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ຈຸ່ມ ພາຣີຊາຍ ອາຕີ ເຢຊູ ປາຍ: \"ຊານໍ່ ໄມ່ ອາຕີ ແຕ ຈະ ໄມ່ ເບີມ. ນ່ະກັອຍ ປັຣນາຍ ໄມ່, ຮິ ຕາ ເຕ່ອ໌ ອີດ.\" ");
INSERT INTO ncq_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ຕາ ເບີນ ອຶນເຕົ່າ ເກົາ ອາຕີ ແຕ ເກົາ ເບີມ; ອຶນແຍ່ະ ປັຣນາຍ ເກົາ ລາ ປຍາຍ໌, ຍ່ອນ ເກົາ ດັງ ເຈີ່ ແຕ ແລ່ະ ເກົາ ແຕີ່ອ໌ ກະ ປໍ ແລ່ະ ເກົາ ອີ ເປາະ. ມາ ເຍືາ ຕາ ເບີນ ດັງ ແຕ ແລ່ະ ເກົາ ແຕີ່ອ໌ ກະ ປໍ ແລ່ະ ເກົາ ອີ ເປາະ. ");
INSERT INTO ncq_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ເຍືາ ຕັດຊີ່ນ ກວາຍ ການໍ່ອ໌, ລາ ຕາປູ່ນ ຣານະ ກວາຍ ຊັອງ, ມາ ເກົາ ຕາ ເບີນ ຕັດຊີ່ນ ກວາຍ ອາແລ່ະ. ");
INSERT INTO ncq_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ມາ ຄັນ ເກົາ ຕັດຊີ່ນ, ມັຮ ປັຣນາຍ ເກົາ ປາຍ ລາ ປຍາຍ໌ ລາລື່, ຍ່ອນ ອຶມປໍ່ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌, ອັນ ແອີດ ກະ ເກົາ ເຕ່; ຕາ ແກີນ ເກົາ ແອີດ ມານະ ເກົາ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ເບີນ ກວາຍ ຄຽນ ເຈີ່ ຕຶ່ງ ຄານອດ ເຍືາ ປາຍ: ຄັນ ບາຣ ນະ ມາ ປາຍ ມູ່ ປັຣນາຍ, ເຕ່ອ໌ ອີດ ປັຣນາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ເກົາ ອາຕີ ແຕ ເກົາ ເບີມ, ກະ ອຶມປໍ່ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌, ອັນ ອາຕີ ແຕ ເກົາ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ເຈີ່ ຈຸ່ມ ພາຣີຊາຍ ຕາແບີບ ເຢຊູ ປາຍ: \"ອຶມປໍ່ ໄມ່ ແອີດ ອຶນແລ່ະ?\" ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ເຍືາ ຕາ ເບີນ ດັງ ເກົາ ແຕີລາ ອຶມປໍ່ ເກົາ. ຄັນ ເຍືາ ມາ ດັງ ເກົາ, ເຍືາ ດັງ ເຕ່ ອຶມປໍ່ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ເຢຊູ ອາຕີ ອຶນແຍ່ະ ປັຣນາຍ ໄນ່ ຕຶ່ງ ຊັງອາຣ ດຸງ ຊາງ ປື່ດ ແຈ່ະ ອຶນຕຸ ໄລ່ ໂຈະ ປຣະ ຊາງ. ມາ ອຶນນັ່ອງ ເນົ່າ ຕາ ຢວາຮ ເບີນ ໂກບ ອັນ, ຍ່ອນ ປາເນ່ນ ອັນ ຈີວ໌ ກູຈີດ ຕາ ຢວາຮ ແຕີ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ແວັດ ກັອຍ ເຢຊູ ອາຕີ ລັ່ຮ ໄລ່ ປາຍ: \"ປັຣແນີ ມັນເຕຣືາ ເກົາ ເປາະ ອຶນຕຸ ການໍ່ອ໌. ເຍືາ ຈໍ່ອ໌ ເກົາ, ມາ ເຍືາ ກູຈີດ ຍ່ອນ ໂລ່ຍຮ ເຍືາ ເບີມ. ອຶນຕຸ ເກົາ ເປາະ, ເຍືາ ຕາ ເຕ່ອ໌ ເປາະ ອຶນຕຸ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ເຈີ່ ກວາຍ ຊົດ ອິດຊະຣາເອລ ຕາແບີບ ປາຍ: \"ນານ່ະ ອັນ ໄນ່ ປາຍ ໄຮ ຕາ ເຕ່ອ໌ ເປາະ ປໍ ອຶນຕຸ ອັນ ເປາະ? ອຶນນັ່ອງ ອັນ ອີ ຢະ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ມາ ເຢຊູ ປາຍ ແອັນ: \"ເຍືາ ແຕີ່ອ໌ ແຕ ປື່ນ, ມາ ເກົາ ແຕີ່ອ໌ ແຕ ແປີງ. ເຍືາ ລາ ແຕ ກູແຕອ໌ ໄນ່, ມາ ເກົາ ລາ ຕາ ແກີນ ແຕ ກູແຕອ໌ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ນ່ະກັອຍ ເກົາ ອາຕີ ເຍືາ ເຈີ່, ເຍືາ ກູຈີດ ຍ່ອນ ມັຮ ໂລ່ຍຮ ເຍືາ ເບີມ. ຄັນ ເຍືາ ຕາ ເບີນ ຊາອຳ ເກົາ ກາ ເຕ່ອ໌ ຈ່ອຍ ອາມົ່ງ ເຍືາ, ເຍືາ ກູຈີດ ມາ ເຍືາ ອຶນນັ່ອງ ເບີນ ໂລ່ຍຮ.\" ");
INSERT INTO ncq_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ໄລ່ ຕາແບີບ ລັ່ຮ ເຢຊູ ປາຍ: \"ໄມ່ ລາ ເນົ່າ?\" ເຢຊູ ຕາແອີຍ ປາຍ: \"ນ່ະ ເກົາ ປາຍ ກະ ເຍືາ ແຕ ອຶນໂຍ່ງ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ເກົາ ອຶນນັ່ອງ ເບີນ ຊາອຶ່ຍ ປັຣນາຍ ຕັດຊີ່ນ ເຍືາ. ມາ ອັນ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌ ລາ ຊາເບິງ ອໍ ລາລື່. ອຶນເຕົ່າ ກາ ເກົາ ຊັອງ ແຕ ອັນ, ເກົາ ອາຕີ ອຶນແຍ່ະ ໂອນ ກວາຍ ຕຶ່ງ ກູແຕອ໌ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ມາ ກວາຍ ຊົດ ອິດຊະຣາເອລ ຕາ ເບີນ ດັງ ອຶນເຕົ່າ ມັຮ ປັຣນາຍ ເຢຊູ ອາຕີ ແຕ ອຶມປໍ່ ອັນ ຕຶ່ງ ມັນລັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ນ່ະກັອຍ ເຢຊູ ອາຕີ ໄລ່ ປາຍ: \"ແຕີ່ອ໌ ຕາໄງ ເຍືາ ຕາຢັອງ ກອນ ເຢືາງ ແກີດ ກວາຍ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ, ບັອງ ກາ ກັອຍ ເຍືາ ເບີນ ດັງ ເກົາ ລາ ເນົ່າ. ກະ ບັອງ ກາ ກັອຍ ເຍືາ ດັງ ແຈງ, ເກົາ ຕາ ເບີນ ຕະ ຣານະ ແຕ ຣາງຶ່ຮ ເກົາ ເບີມ, ມາ ມັຮ ປັຣນາຍ ເກົາ ອາຕີ ລາ ປັຣນາຍ ອຶມປໍ່ ເກົາ ອາຕີ ເກົາ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ອັນ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌, ອັນ ກັອຍ ແອີດ ເລືອຍໆ ກະ ເກົາ. ອັນ ຕາ ເບີນ ຕັຮ ໂອນ ເກົາ ແອີດ ມານະ, ຍ່ອນ ຣານະ ເກົາ ຕະ, ເກົາ ຕະ ໂອນ ຣໍ່ອ໌ ຣາງຶ່ຮ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ພໍກາ ເນົ່າ ຊັອງ ເຢຊູ ປາຍ ນ່ະກັອຍ, ຊາອຶ່ຍ ນະ ກວາຍ ຊາອຳ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ເຢຊູ ອາຕີ ກວາຍ ອິດຊະຣາເອລ ກາ ຊາອຳ ອັນ ປາຍ: \"ຄັນ ເຍືາ ຊາງັດ ປັຣນາຍ ເກົາ ອາຕີ, ເຍືາ ລາ ກວາຍ ຣຍານ ແຕ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ຄັນ ນ່ະກັອຍ ເຍືາ ດັງ ປັຣນາຍ ປຍາຍ໌ ລາ ອຶນເຕົ່າ, ກະ ປັຣນາຍ ປຍາຍ໌ ໄນ່ ອາໂຣຍຮ ເຍືາ ແຕ ແກີດ ຊູລ.\" ");
INSERT INTO ncq_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ມາ ກວາຍ ກັອຍ ຕາແອີຍ ເຢຊູ ປາຍ: \"ຮິ ລາ ຈຸ່ມເຈືອ ອັບຣາຮາມ. ຮິ ຕາ ເກີ່ຍ ແກີດ ຊູລ ເນົ່າ. ນານ່ະ ອາຈານ ປາຍ ອາໂຣຍຮ ຮິ ແຕ ແກີດ ຊູລ?\" ");
INSERT INTO ncq_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ເຢຊູ ອາຕີ ລັ່ຮ ໄລ່ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ກວາຍ ອາແລ່ະ ກາ ຕະ ໂລ່ຍຮ ອຶນເຕົ່າ, ກວາຍ ກັອຍ ແກີດ ຊູລ ໂລ່ຍຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ຄັນ ກວາຍ ອາແລ່ະ ຢໍອ໌ ອີ ຕັຮ ກວາຍ ຊູລ ອັນ, ເຕ່ອ໌ ອັນ ຕັຮ, ມາ ກອນ ຣາເລົາ ອັນ ເບີມ ເຕ່ອ໌ ແອີດ ເລືອຍໆ ຕຶ່ງ ດຸງຊູ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ນ່ະກັອຍ ຄັນ ກອນ ເຢືາງ ເຈົາຣາຊີ ອາໂຣຍຮ ເຍືາ, ເຈີ່ ເຍືາ ຕາ ເບີນ ແກີດ ຊູລ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ເກົາ ດັງ ເຈີ່ ເຍືາ ລາ ແຕ ຈຸ່ມເຈືອ ອັບຣາຮາມ. ມາ ເຍືາ ອຶນນັ່ອງ ອີ ກາຈີດ ເກົາ, ຍ່ອນ ປັຣນາຍ ເກົາ ອາຕີ ຕາ ເບີນ ມູ່ດ ຕຶ່ງ ຣາງຶ່ຮ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ເກົາ ອາຕີ ມັຮ ຣານະ ອຶມປໍ່ ເກົາ ອາປັຮ ໂອນ ເກົາ ເຮີມ, ມາ ເຍືາ ປວາຍ ມັຮ ກາ ເຍືາ ຊັອງ ແຕ ອຶມປໍ່ ເຍືາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ໄລ່ ຕາແອີຍ ເຢຊູ ປາຍ: \"ອັບຣາຮາມ ລາ ອຶມປໍ່ ຮິ.\" ມາ ເຢຊູ ປາຍ ລັ່ຮ: \"ຄັນ ເຍືາ ແກີດ ກອນ ອັບຣາຮາມ, ເຍືາ ຕະ ຣານະ ມູເຈິງ ອັບຣາຮາມ ຕະ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ເກົາ ອາຕີ ມັຮ ປັຣນາຍ ເກົາ ຊັອງ ເຈີ່ ແຕ ເຢືາງ ເຈົາຣາຊີ, ມາ ເຍືາ ຄຶ່ດ ອີ ກາຈີດ ເກົາ. ອັບຣາຮາມ ຕາ ເບີນ ຕະ ນ່ະ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ຊານໍ່ ເຍືາ ຕະ ປວາຍ ຣານະ ອຶມປໍ່ ເຍືາ, ມາ ອຶມປໍ່ ເຍືາ ຕາ ແກີນ ອັບຣາຮາມ.\" ມາ ໄລ່ ຕາແອີຍ ເຢຊູ ປາຍ: \"ຮິ ລາ ຕາ ແກີນ ກອນ ຕຸງ. ຮິ ເບີນ ມານຳ ອຶມປໍ່ ຊັອງ. ເຢືາງ ເຈົາຣາຊີ ລາ ອຶມປໍ່ ຮິ.\" ");
INSERT INTO ncq_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ມາ ເຢຊູ ອາຕີ ລັ່ຮ ໄລ່ ປາຍ: \"ຄັນ ເຢືາງ ເຈົາຣາຊີ ລາ ອຶມປໍ່ ເຍືາ, ນ່ະກັອຍ ເຍືາ ອາໂຢ່ະ ເກົາ ເຕ່, ຍ່ອນ ເກົາ ແຕີ່ອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ. ຊານໍ່ ເກົາ ແອີດ ອຶນໄນ່, ເກົາ ຕາ ເບີນ ແຕີ່ອ໌ ປໍ ໄນ່ ປວາຍ ຣາງຶ່ຮ ເກົາ ເບີມ, ມາ ເຢືາງ ເຈົາຣາຊີ ແປຣີ ໂອນ ເກົາ ແຕີ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ນານ່ະ ເຍືາ ຊັອງ ປັຣນາຍ ເກົາ ອາຕີ ຕາ ເບີນ ແຈງ ບໍ? ເຍືາ ຕາ ເບີນ ຊັອງ, ຍ່ອນ ເຍືາ ຕາ ຢໍອ໌ ອີ ຊາງັດ ປັຣນາຍ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ເຍືາ ລາ ກອນ ເຢືາງ ຊາຕານ. ອັນ ກັອຍ ລາ ອຶມປໍ່ ເຍືາ. ກະ ເຍືາ ຢໍອ໌ ອີ ປວາຍ ຣານະ ອຶມປໍ່ ເຍືາ. ແຕ ອຶມແບິ, ເຢືາງ ຊາຕານ ໄນ່ ອັນ ເກີ່ຍ ກາຈີດ ກວາຍ. ອັນ ຕາ ເບີນ ຢຸມ ປັຣນາຍ ປຍາຍ໌, ຍ່ອນ ຕາ ເບີນ ມູ ປັຣນາຍ ປຍາຍ໌ ອຶນເຕົ່າ ຕຶ່ງ ຣາງຶ່ຮ ອັນ. ພໍກາ ອັນ ປາຍ ປັຣນາຍ ອາໂລກ ອັນ ປວາຍ ປັຣນາຍ ອັນ ເບີມ, ຍ່ອນ ອັນ ເກີ່ຍ ອາໂລກ ເລືອຍໆ ກະ ອັນ ລາ ອຶມປໍ່ ປັຣນາຍ ອາໂລກ. ");
INSERT INTO ncq_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ມາ ຍ່ອນ ເກົາ ອາຕີ ເຍືາ ປັຣນາຍ ປຍາຍ໌, ນ່ະກັອຍ ເຍືາ ຕາ ເບີນ ຊາອຳ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ກວາຍ ອາແລ່ະ ແຕ ເຍືາ ແກີດ ພາເຍືານ ປາຍ ເກົາ ຕະ ຣານະ ໂລ່ຍຮ? ຄັນ ເກົາ ອາຕີ ປຍາຍ໌, ນານ່ະ ເຍືາ ຕາ ເບີນ ຊາອຳ ເກົາ? ");
INSERT INTO ncq_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ກວາຍ ອາແລ່ະ ກາ ແກີດ ກອນ ເຢືາງ ເຈົາຣາຊີ, ກວາຍ ກັອຍ ຊາງັດ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ. ມາ ເຍືາ ຕາ ຢໍອ໌ ອີ ຊາງັດ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ຍ່ອນ ເຍືາ ຕາ ແກີນ ກອນ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ກວາຍ ອິດຊະຣາເອລ ພາມາດ ເຢຊູ ກະ ປາຍ: \"ປຍາຍ໌ ມາ ຕາ ເບີນ ຮິ ປາຍ ໄມ່ ລາ ກອນ ຕຸງ ມູເຈິງ ກວາຍ ຊາມາເຣຍ ເຕ່, ກະ ເບີນ ເຢືາງ ຕາ ອໍ ແຮີ ຕຣວບ ໄມ່?\" ");
INSERT INTO ncq_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ເຢືາງ ຕາ ອໍ ຕາ ເບີນ ຕຣວບ ເກົາ. ເກົາ ຢຳນັ່ບ ອຶມປໍ່ ເກົາ, ມາ ເຍືາ ຕາ ເບີນ ຢຳນັ່ບ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ເກົາ ຕາ ເບີນ ຈໍ່ອ໌ ໂອນ ເນົ່າ ຍ່ອງ ເກົາ. ມາ ເບີນ ມານະ ກາ ຈໍ່ອ໌ ຣານະ ກັອຍ ໂອນ ເກົາ. ອັນ ກັອຍ ຕັດຊີ່ນ ເຍືາ ກະ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ຄັນ ເບີນ ກວາຍ ອີດ ປັຣນາຍ ເກົາ, ກວາຍ ກັອຍ ຕາ ເບີນ ກູຈີດ.\" ");
INSERT INTO ncq_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ແຕີ່ອ໌ ເຢຊູ ປາຍ ນ່ະກັອຍ, ກວາຍ ອິດຊະຣາເອລ ປາຍ: \"ຊານໍ່ ຮິ ດັງ ກຣັ່ກ ລາລື່ ເບີນ ເຢືາງ ຕາ ອໍ ຕຣວບ ໄມ່. ອັບຣາຮາມ ກູຈີດ ເຈີ່. ກະ ອຶນແຍ່ະ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ລາ ກູຈີດ ເຕ່. ມາ ຊານໍ່ ໄມ່ ປາຍ ຄັນ ເບີນ ກວາຍ ອີດ ປັຣນາຍ ໄມ່, ກວາຍ ກັອຍ ຕາ ເບີນ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ໄມ່ ປື່ດ ກາເລີຍ ແຕ ອັບຣາຮາມ ອາຈວາຍຮ ອາເຈ່ຮ ຮິ ບໍ? ອັບຣາຮາມ ກູຈີດ ເຈີ່, ກະ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ລາ ກູຈີດ ເຕ່. ໄມ່ ຄຶ່ດ ໄມ່ ລາ ເນົ່າ?\" ");
INSERT INTO ncq_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ນ່ະກັອຍ ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ຄັນ ເກົາ ມາ ຍ່ອງ ຈະ ເກົາ ເບີມ, ລາ ຕາ ເບີນ ແກີດ ເກືາ ອຶນເຕົ່າ. ອັນ ກາ ຍ່ອງ ເກົາ ລາ ອຶມປໍ່ ເກົາ, ລາ ອັນ ກາ ເຍືາ ປາຍ ເຢືາງ ກາ ເຍືາ ຊາງ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ເຍືາ ຕາ ເບີນ ດັງ ອັນ, ມາ ເກົາ ດັງ ອັນ. ຄັນ ເກົາ ປາຍ ເກົາ ຕາ ເບີນ ດັງ ອັນ, ລາ ເກົາ ຕະ ອຶນຕີ ອາໂລກ ມູເຈິງ ເຍືາ ເຕ່. ມາ ເກົາ ດັງ ອັນ, ກະ ເກົາ ຊາງັດ ປັຣນາຍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ອັບຣາຮາມ, ລາ ອາຈວາຍຮ ອາເຈ່ຮ ເຍືາ, ອັນ ອູອຍາຣ ອູໄອອ໌ ລາລື່ ຢໍອ໌ ອີ ເຮີມ ເກົາ ແຕີ່ອ໌ ປໍ ກູແຕອ໌ ໄນ່. ອັນ ເຮີມ ຣານະ ໄນ່ ກຣັ່ກ ເຈີ່; ນ່ະກັອຍ ອັນ ແອີນ ລາລື່.\" ");
INSERT INTO ncq_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ກວາຍ ອິດຊະຣາເອລ ກັອຍ ປາຍ ລັ່ຮ: \"ອາຍຸ່ ໄມ່ ຕາ ຢວາຮ ແຕີ່ອ໌ ເຊີງ ຈິ່ດ ກູມໍ. ມາ ນານ່ະ ໄມ່ ປາຍ ໄມ່ ເຮີມ ເຈີ່ ອັບຣາຮາມ?\" ");
INSERT INTO ncq_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ເຢຊູ ຕາແອີຍ ລັ່ຮ ໄລ່ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ອຶນໂຍ່ງ ອັບຣາຮາມ ຕາ ຢວາຮ ແກີດ, ມາ ເກົາ ເບີນ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ກວາຍ ອິດຊະຣາເອລ ອີດ ຕາເມົາ ອີ ແກຼງ ໂຈະ ອັນ. ມາ ເຢຊູ ມູ່ດ ກັຣຈຸ ຕຶ່ງ ກວາຍ ກຼຶ່ງ ກັອຍ; ເຈີ່ ອັນ ລັ່ອຮ ແຕ ດຸງ ຊາງ ປື່ດ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ພໍກາ ເຢຊູ ຕາຢັຮ ເປາະ ຕຶ່ງ ຣານາ, ອັນ ເຮີມ ມານະ ກວາຍ ຣາເລົາ ກາ ຊູດ ມັ່ດ ແຕ ອຶມເປ່ອ໌ ອັນ ຣັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ໄລ່ ຕາແບີບ ອັນ ປາຍ: \"ອາຈານ ເອີຍ! ເນົ່າ ຕະ ໂລ່ຍຮ ໂອນ ກວາຍ ໄນ່ ຊູດ ມັ່ດ ແຕ ອຶມເປ່ອ໌ ອັນ ຣັ່ຮ? ອັນ ເບີມ, ແຕີລາ ອຶມເປ່ອ໌ ອຶມປໍ່ ອັນ ຕະ ໂລ່ຍຮ?\" ");
INSERT INTO ncq_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ເຢຊູ ຕາແອີຍ ໄລ່ ກັອຍ ປາຍ: \"ຣານະ ກັອຍ ຕາ ເບີນ ຍ່ອນ ໂລ່ຍຮ ອັນ, ແຕີລາ ໂລ່ຍຮ ອຶມເປ່ອ໌ ອຶມປໍ່ ອັນ. ມາ ເມ່ນ ເຢືາງ ເຈົາຣາຊີ ອີ ອາປັຮ ຣານະ ອັນ ຍ່ອນ ແຕ ກວາຍ ຊູດ ມັ່ດ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ບັອງ ກາ ອຶນນັ່ອງ ຕາໄງ, ໄຮ ອຶງເຄາະ ຕະ ອຶນແຍ່ະ ຣານະ ອັນ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌. ແຕີ່ອ໌ ຊາເດົາ, ໄຮ ຕາ ເຕ່ອ໌ ຕະ ຣານະ ອຶນເຕົ່າ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ບັອງ ກາ ເກົາ ແອີດ ຕຶ່ງ ກູແຕອ໌, ລາ ເກົາ ເດີງ ປັ່ງ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ ຕຶ່ງ ກູແຕອ໌ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ອັນ ກູຈົຮ ຕຶ່ງ ກູແຕອ໌. ອັນ ກັຣຈຸ ແດີອ໌ ວຍາ ກະ ກູແຕອ໌ ແກີດ ຣາໂລ່ອ໌. ເຈີ່ ອັນ ອາເຕືາ ຣາໂລ່ອ໌ ຕຶ່ງ ມັ່ດ ກວາຍ ຊູດ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ເຢຊູ ແປຣີ ກວາຍ ຊູດ ມັ່ດ ກັອຍ ປາຍ: \"ເປາະ! ໄມ່ ເປາະ ກູລຍາ ມັ່ດ ຕຶ່ງ ແດີອ໌ ພາຍ ຊີໂລອາມ.\" (ປັຣນາຍ ຊີໂລອາມ ໄນ່, ຄັນ ອຶນຕີ ລັ່ຮ ລາ 'ແປຣີ.') ເຈີ່ ກວາຍ ຊູດ ມັ່ດ ກັອຍ ເປາະ ກູລຍາ ມັ່ດ ອັນ, ກະ ອັນ ລົ່ບ ລັ່ຮ ປໍ ດຸງ. ມັ່ດ ອັນ ແກີດ ບຣາງ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ກວາຍ ກາ ແອີດ ມູ່ ວີ່ລ ກະ ອັນ, ກະ ກວາຍ ກາ ເຮີມ ອັນ ແອີດ ຊູແຊອ໌ ແຕ ອຶນໂຍ່ງ, ອຶນແຍ່ະ ນະ ໄລ່ ກັອຍ ຕາແບີບ ປາຍ: \"ປຍາຍ໌ ມາ ຕາ ເບີນ ອັນ ໄນ່ ລາ ກວາຍ ຊູດ ມັ່ດ ກາ ເກີ່ຍ ຕາກູ ຊູແຊອ໌?\" ");
INSERT INTO ncq_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ເບີນ ກວາຍ ຕາແອີຍ ປາຍ: \"ປຍາຍ໌ ອັນ.\" ມາ ກວາຍ ການໍ່ອ໌ ປາຍ: \"ຕາ ແກີນ ອັນ. ມາ ຣູ່ບເຣືາງ ກວາຍ ໄນ່ ນ່ະ ກວາຍ ຊູດ ກັອຍ ເຕ່.\" ມາ ກວາຍ ກັອຍ ປາຍ ລັ່ຮ ນ່ະໄນ່: \"ກູໂຕ ເກົາ ໄນ່ ແຕິ່ ກວາຍ ຊູດ ມັ່ດ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ນ່ະກັອຍ ກວາຍ ການໍ່ອ໌ ຕາແບີບ ອັນ: \"ຄັນ ເມ່ນ ໄມ່ ກວາຍ ກັອຍ, ຍ່ອນ ນານ່ະ ແຕ ມັ່ດ ໄມ່ ແກີດ ບຣາງ ແອັນ?\" ");
INSERT INTO ncq_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ອັນ ຕາແອີຍ ໄລ່ ປາຍ: \"ເບີນ ມານະ ຣາເລົາ ຣາມຶ່ຮ ເຢຊູ, ອັນ ຕາລຸ ຣາໂລ່ອ໌; ເຈີ່ ອັນ ອາເຕືາ ຕຶ່ງ ມັ່ດ ເກົາ, ກະ ອັນ ແປຣີ ເກົາ ເປາະ ກູລຍາ ມັ່ດ ຕຶ່ງ ແດີອ໌ ພາຍ ຊີໂລອາມ. ເກົາ ເປາະ ປໍ ແດີອ໌ ພາຍ ກັອຍ ກູລຍາ ມັ່ດ ເກົາ. ເຈີ່ ມັ່ດ ເກົາ ແກີດ ບຣາງ ແຕິ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ໄລ່ ຕາແບີບ ລັ່ຮ ປາຍ: \"ປໍ ແລ່ະ ອັນ ຊານໍ່?\" ມາ ອັນ ຕາແອີຍ ປາຍ: \"ເກົາ ຕາ ດັງ, ນັງ ປໍ ແລ່ະ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ແວັດ ກັອຍ ເນົ່າ ເດີງ ອາຊວຍ ກວາຍ ຣາເລົາ ກາ ຊູດ ມັ່ດ ແກີດ ບຣາງ ແຕີ່ອ໌ ປໍ ຈຸ່ມ ພາຣີຊາຍ. ");
INSERT INTO ncq_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ຕາໄງ ເຢຊູ ຕາລຸ ຣາໂລ່ອ໌ ກະ ຕະ ໂອນ ມັ່ດ ກວາຍ ຊູດ ແກີດ ບຣາງ, ຕາໄງ ກັອຍ ລາ ຕາໄງ ຣາລູ່. ");
INSERT INTO ncq_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ນ່ະກັອຍ ຈຸ່ມ ພາຣີຊາຍ ຕາແບີບ ລັ່ຮ ກວາຍ ຊູດ ມັ່ດ ກັອຍ ປາຍ: \"ນານ່ະ ແຕ ມັ່ດ ໄມ່ ແກີດ ບຣາງ ແອັນ?\" ກວາຍ ຊູດ ມັ່ດ ຕາແອີຍ ໄລ່ ກັອຍ ປາຍ: \"ອັນ ກັອຍ ອາເຕືາ ຣາໂລ່ອ໌ ຕຶ່ງ ມັ່ດ ເກົາ. ເຈີ່ ເກົາ ກູລຍາ ມັ່ດ; ນ່ະກັອຍ ຊານໍ່ ເກົາ ແກີດ ບຣາງ.\" ");
INSERT INTO ncq_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ເບີນ ກວາຍ ແຕ ຈຸ່ມ ພາຣີຊາຍ ປາຍ: \"ກວາຍ ໄນ່ ຕາ ເບີນ ແຕີ່ອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ, ຍ່ອນ ກວາຍ ໄນ່ ຕັຮ ຄານອດ ຕາໄງ ຣາລູ່.\" ມາ ເບີນ ກວາຍ ການໍ່ອ໌ ປາຍ: \"ນານ່ະ ກວາຍ ໂລ່ຍຮ ມາ ເຕ່ອ໌ ຕະ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ໄນ່?\" ເຈີ່ ຈຸ່ມ ພາຣີຊາຍ ກັອຍ ແກີດ ບາຣ ປັຣນາຍ, ອັນ ກາ ປາຍ ນ່ະໄນ່, ອັນ ກາ ປາຍ ນ່ະກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ເຈີ່ ຈຸ່ມ ພາຣີຊາຍ ຕາແບີບ ລັ່ຮ ກວາຍ ຊູດ ມັ່ດ ກັອຍ ປາຍ: \"ອັນ ກາ ຕະ ໂອນ ມັ່ດ ໄມ່ ແກີດ ບຣາງ, ອັນ ກັອຍ ລາ ເນົ່າ?\" ກວາຍ ຊູດ ມັ່ດ ກັອຍ ຕາແອີຍ ປາຍ: \"ອັນ ກັອຍ ລາ ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ມາ ກວາຍ ຊົດ ອິດຊະຣາເອລ ອຶນນັ່ອງ ຕາ ເບີນ ຊາອຳ ຊາ ປາຍ ກວາຍ ກັອຍ ຊູດ ມັ່ດ ແຕ ອຶນໂຍ່ງ ມາ ແກີດ ບຣາງ ແອັນ. ນ່ະກັອຍ ໄລ່ ເປາະ ອີດ ອຶມເປ່ອ໌ ອຶມປໍ່ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ເຈີ່ ໄລ່ ຕາແບີບ ອຶມເປ່ອ໌ ອຶມປໍ່ ອັນ ປາຍ: \"ປຍາຍ໌ ມາ ຕາ ເບີນ, ອັນ ໄນ່ ລາ ກອນ ຣາເລົາ ເຍືາ? ອັນ ຊູດ ມັ່ດ ແຕ ຕາໄງ ເຍືາ ຣັ່ຮ ອັນ ບໍ? ຍ່ອນ ນານ່ະ ແຕ ຊານໍ່ ອັນ ແກີດ ບຣາງ ແອັນ?\" ");
INSERT INTO ncq_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ອຶມເປ່ອ໌ ອຶມປໍ່ ອັນ ຕາແອີຍ ປາຍ: \"ເມ່ນ ເຈີ່, ໄນ່ ລາ ກອນ ຣາເລົາ ຮິ. ກະ ຮິ ເຮີມ ອັນ ຊູດ ມັ່ດ ແຕ ຕາໄງ ຮິ ຣັ່ຮ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ມາ ນານ່ະ ອັນ ເບີນ ບຣາງ ແອັນ ຊານໍ່, ຮິ ຕາ ດັງ ເຕ່. ກະ ຮິ ຕາ ດັງ, ນັງ ເນົ່າ ຕະ ໂອນ ອັນ ແກີດ ບຣາງ. ເຍືາ ຕາແບີບ ອັນ. ອັນ ລາ ກວາຍ ຊາຊາຍ ເຈີ່. ເຕ່ອ໌ ອັນ ຕາແອີຍ ເບີມ.\" ");
INSERT INTO ncq_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ອຶມເປ່ອ໌ ອຶມປໍ່ ກວາຍ ຊູດ ມັ່ດ ປາຍ ນ່ະກັອຍ, ຍ່ອນ ໄລ່ ອຶງກັອຮ ກວາຍ ຊົດ ອິດຊະຣາເອລ. ກວາຍ ຊົດ ອິດຊະຣາເອລ ຊັຣຮົງ ເຈີ່, ຄັນ ກວາຍ ອາແລ່ະ ມາ ປາຍ ເຢຊູ ລາ ກຣີດ, ອັນ ກາ ເຢືາງ ເຈົາຣາຊີ ຣຽຮ ໂອນ ຈ່ອຍ ອາມົ່ງ ກວາຍ, ອຶງເຄາະ ຕູ່ຍຮ ອາລັ່ອຮ ກວາຍ ກັອຍ ແຕ ດຸງ ຊາງ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ຍ່ອນ ນ່ະກັອຍ ອຶມເປ່ອ໌ ອຶມປໍ່ ກວາຍ ຊູດ ມັ່ດ ກັອຍ ປາຍ: \"ອັນ ລາ ກວາຍ ຊາຊາຍ ເຈີ່. ເຍືາ ຕາແບີບ ອັນ ເບີມ.\" ");
INSERT INTO ncq_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ມູ່ ເຮີບ ແອັນ ກວາຍ ຊົດ ອິດຊະຣາເອລ ກູອ໌ ກວາຍ ຊູດ ມັ່ດ ກັອຍ ກະ ປາຍ ນ່ະໄນ່ ໂຈະ ອັນ: \"ອຶງເຄາະ ໄມ່ ຍ່ອງ ແອີງ ເຢືາງ ເຈົາຣາຊີ ຊັອງ. ຮິ ດັງ ເຈີ່ ປາຍ ກວາຍ ກັອຍ ລາ ກວາຍ ໂລ່ຍຮ.\" ");
INSERT INTO ncq_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ມາ ກວາຍ ຊູດ ມັ່ດ ກັອຍ ປາຍ ລັ່ຮ ນ່ະໄນ່: \"ເກົາ ຕາ ດັງ ກວາຍ ກັອຍ ເບີນ ໂລ່ຍຮ, ແຕີລາ ຕາ ເບີນ ໂລ່ຍຮ. ເກົາ ດັງ ບີ່ອ໌ ມູ ຣາມຶ່ຮ ຊັອງ. ບັອງ ອາໄຣ່ ມັ່ດ ເກົາ ຊູດ, ມາ ຊານໍ່ ມັ່ດ ເກົາ ແກີດ ບຣາງ!\" ");
INSERT INTO ncq_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ເຈີ່ ກວາຍ ຊົດ ກັອຍ ຕາແບີບ ລັ່ຮ ອັນ ປາຍ: \"ກວາຍ ກັອຍ ຕະ ຣານະ ອຶນເຕົ່າ ໂອນ ໄມ່? ນານ່ະ ແຕິ່ ອັນ ຕະ ມັ່ດ ໄມ່ ເບີນ ແກີດ ບຣາງ?\" ");
INSERT INTO ncq_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ກວາຍ ຊູດ ມັ່ດ ກັອຍ ຕາແອີຍ ປາຍ: \"ເກົາ ອາຕີ ເຍືາ ເຈີ່, ມາ ເຍືາ ຕາ ຢໍອ໌ ຊາງັດ. ນານ່ະ ອຶນນັ່ອງ ເຍືາ ໂອນ ເກົາ ອາຕີ ລັ່ຮ ຊາ? ເຍືາ ອີ ປວາຍ ຣານະ ອັນ ເຕ່ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ເຈີ່ ມັຮ ກວາຍ ຊົດ ປາຍ ພາມາດ ອັນ; ເຈີ່ ໄລ່ ປາຍ: \"ປຍາຍ໌ ໄມ່ ລາ ປວາຍ ຣານະ ກວາຍ ກັອຍ! ມາ ຮິ ປວາຍ ຣານະ ໂມເຊ! ");
INSERT INTO ncq_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ຮິ ດັງ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ຣານາ ໂມເຊ. ມາ ກວາຍ ກັອຍ, ຮິ ຕາ ດັງ ແຕ ແລ່ະ ອັນ ແຕີ່ອ໌.\" ");
INSERT INTO ncq_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ເຈີ່ ກວາຍ ຊູດ ມັ່ດ ກັອຍ ຕາແອີຍ ປາຍ: \"ເກົາ ງຶ່ດ ເອີຍ໌! ເຍືາ ຕາ ດັງ ແຕ ແລ່ະ ກວາຍ ກັອຍ ແຕີ່ອ໌, ມາ ອັນ ຕະ ໂອນ ມັ່ດ ເກົາ ແກີດ ບຣາງ! ");
INSERT INTO ncq_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ໄຮ ດັງ ເຈີ່ ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ຊາງັດ ກວາຍ ໂລ່ຍຮ, ມາ ອັນ ຊາງັດ ກວາຍ ກາ ຢຳນັ່ບ ອັນ ກະ ປວາຍ ຣານະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ແຕ ຕາແບິ ເຢືາງ ເຈົາຣາຊີ ແຕງ ກູແຕອ໌ ໄນ່, ຕາ ເກີ່ຍ ຊັອງ ເບີນ ກວາຍ ເຕ່ອ໌ ປົວ ກວາຍ ຊູດ ມັ່ດ ແຕ ຕາໄງ ອຶມເປ່ອ໌ ອັນ ຣັ່ຮ ມາ ແກີດ ບຣາງ. ");
INSERT INTO ncq_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ຄັນ ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ຈ່ອຍ ກວາຍ ກັອຍ, ກວາຍ ກັອຍ ຕາ ເຕ່ອ໌ ຕະ ມູ ຣານະ ອຶນເຕົ່າ ຕາ ເກີ່ຍ ເຮີມ.\" ");
INSERT INTO ncq_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ມາ ມັຮ ກວາຍ ຊົດ ປາຍ ຊາ ນ່ະໄນ່: \"ໄມ່ ລາ ກວາຍ ໂລ່ຍຮ ແຕ ຕາໄງ ອຶມເປ່ອ໌ ໄມ່ ຣັ່ຮ! ນານ່ະ ໄມ່ ຍັ່ນ ອີ ອາຕີ ຮິ?\" ແວັດ ກັອຍ ໄລ່ ຕູ່ຍຮ ອາລັ່ອຮ ກວາຍ ຊູດ ມັ່ດ ກັອຍ ແຕ ດຸງ ຊາງ. ");
INSERT INTO ncq_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ເຢຊູ ຊັອງ ເນົ່າ ປາຍ ໄລ່ ຕູ່ຍຮ ກວາຍ ຊູດ ມັ່ດ ກັອຍ. ເຈີ່ ອັນ ຈໍ່ອ໌ ຣາມົຮ ກວາຍ ກັອຍ ກະ ຕາແບີບ ອັນ ປາຍ: \"ໄມ່ ຊາອຳ ກອນ ເຢືາງ ແກີດ ກວາຍ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ກວາຍ ຊູດ ມັ່ດ ຕາແອີຍ ລັ່ຮ: \"ອາຈວາຍຮ ເອີຍ, ອັນ ກັອຍ ລາ ເນົ່າ? ແຊອ໌ ອາຈວາຍຮ ອາຕີ ເກົາ ໂອນ ເກົາ ດັງ. ເກົາ ຢໍອ໌ ອີ ຊາອຳ ອັນ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ເຢຊູ ປາຍ ລັ່ຮ: \"ໄມ່ ເຮີມ ເຈີ່ ອັນ, ກະ ອັນ ກາ ອາຕີ ໄມ່ ຊານໍ່ ລາ ເມ່ນ ອັນ ກັອຍ ແຕິ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ນ່ະກັອຍ ກວາຍ ຊູດ ມັ່ດ ກັອຍ ຕາແອີຍ: \"ອຶນເຈົາ ເອີຍ! ເມ່ນ, ເກົາ ຊາອຳ!\" ເຈີ່ ອັນ ກຼຸ່ ຣາໂກລ ຊາງ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ເຢຊູ ປາຍ ຊາ: \"ເກົາ ແຕີ່ອ໌ ປໍ ກູແຕອ໌ ໄນ່ ດໍອ໌ ຕັດຊີ່ນ ກວາຍ. ເກົາ ຕະ ໂອນ ກວາຍ ຊູດ ມັ່ດ ແກີດ ບຣາງ, ມາ ກວາຍ ມັ່ດ ປັ່ງ ອໍ ແກີດ ຊູດ ແອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ເບີນ ກວາຍ ແຕ ຈຸ່ມ ພາຣີຊາຍ ຊັອງ ເຢຊູ ປາຍ ນ່ະກັອຍ. ໄລ່ ຕາແບີບ ເຢຊູ ປາຍ: \"ໄມ່ ປາຍ ຮິ ລາ ກວາຍ ຊູດ ມັ່ດ ເຕ່ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ຄັນ ເຍືາ ງີ່ນ ເຍືາ ລາ ນ່ະ ກວາຍ ຊູດ ມັ່ດ, ເຍືາ ຕາ ເບີນ ເບີນ ໂລ່ຍຮ ອຶນເຕົ່າ. ມາ ຊານໍ່ ເຍືາ ປາຍ ມັ່ດ ເຍືາ ປັ່ງ ອໍ, ນ່ະກັອຍ ໂລ່ຍຮ ເຍືາ ອຶນນັ່ອງ ແອີດ ເລືອຍໆ ກະ ເຍືາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ເຢຊູ ປາຍ ແອັນ ນ່ະໄນ່: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ກວາຍ ອາແລ່ະ ກາ ຕາ ເບີນ ມູ່ດ ຕຶ່ງ ກໍ່ອ໌ ແກະ ຣານາ ງັ່ຮ ຕົ່ງ, ມາ ຊັອຮ ຣານາ ການໍ່ອ໌, ກວາຍ ກັອຍ ລາ ກວາຍ ຊາແວງ ກະ ກວາຍ ຣາປົນ. ");
INSERT INTO ncq_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ອັນ ກາ ມູ່ດ ຣານາ ງັ່ຮ ຕົ່ງ, ກວາຍ ກັອຍ ລາ ເມ່ນ ກວາຍ ກຍາອ໌ ແກະ. ");
INSERT INTO ncq_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ກວາຍ ກາ ກຍາອ໌ ງັ່ຮ ຕົ່ງ ກໍ່ອ໌, ເປິຮ ກູຕົ່ງ ໂອນ ກວາຍ ກຍາອ໌ ແກະ ເຕ່ອ໌ ມູ່ດ, ກະ ແກະ ອັນ ຊາງັດ ຊຽງ ອັນ ກູອ໌. ອັນ ກູອ໌ ຣາມຶ່ຮ ແກະ ອັນ; ເຈີ່ ອັນ ອາໂຣຍຮ ຈຸ່ມ ແກະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ແຕີ່ອ໌ ອັນ ອາລັ່ອຮ ອຶນແຍ່ະ ແກະ ອັນ, ອັນ ເປາະ ອຶນໂຍ່ງ. ກະ ຈຸ່ມ ແກະ ເປາະ ຕາປູ່ນ ກຣັອງ ອັນ, ຍ່ອນ ແກະ ກັອຍ ຊາກັ່ລ ຊຽງ ອັນ ກາ ກຍາອ໌. ");
INSERT INTO ncq_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ມາ ແກະ ຕາ ເບີນ ປວາຍ ກວາຍ ການໍ່ອ໌. ໄລ່ ຕາລຸ່ຮ ແຕ ກວາຍ ກັອຍ, ຍ່ອນ ໄລ່ ຕາ ເບີນ ຊາກັ່ລ ຊຽງ ກວາຍ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ເຢຊູ ອາຕີ ແຕ ປັຣນາຍ ຊາກຳ ໄນ່, ມາ ໄລ່ ກັອຍ ຕາ ເບີນ ຊາປຸ່ຮ ປັຣນາຍ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ນ່ະກັອຍ ເຢຊູ ອາຕີ ລັ່ຮ ໄລ່ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ເກົາ ລາ ງັ່ຮ ຕົ່ງ ກໍ່ອ໌ ແກະ ມູ່ດ ລັ່ອຮ. ");
INSERT INTO ncq_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ອຶນແຍ່ະ ກວາຍ ການໍ່ອ໌ ກາ ແຕີ່ອ໌ ອຶນໂຍ່ງ ເກົາ, ມັຮ ກວາຍ ກັອຍ ລາ ກວາຍ ຊາແວງ ກະ ກວາຍ ຕູຕວຍ໌. ມາ ແກະ ຕາ ເບີນ ຊາງັດ ຊຽງ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ເກົາ ລາ ງັ່ຮ ຕົ່ງ ກໍ່ອ໌. ກວາຍ ອາແລ່ະ ກາ ມູ່ດ ຣານາ ເກົາ, ກວາຍ ກັອຍ ເບີນ ອາມົ່ງ. ເຕ່ອ໌ ອັນ ມູ່ດ ລັ່ອຮ, ກະ ຣາມົຮ ຊັຣນາ ຈາ. ");
INSERT INTO ncq_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ກວາຍ ຊາແວງ ມູ່ດ ຢໍອ໌ ອີ ຕູຕວຍ໌, ຢໍອ໌ ອີ ກາຈີດ, ກະ ຢໍອ໌ ອີ ຕາລຸຮ ຊັອງ. ມາ ເກົາ ແຕີ່ອ໌ ໂອນ ແກະ ເບີນ ອາມົ່ງ, ຕາ ເບີນ ແອິ ມູ ຣາມຶ່ຮ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","\"ເກົາ ລາ ກວາຍ ກຍາອ໌ ແກະ ອໍ. ກວາຍ ກຍາອ໌ ແກະ ອໍ ເຣືາບ ກູຈີດ ຕາງ ໂອນ ແກະ ອັນ ອາມົ່ງ. ");
INSERT INTO ncq_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ກວາຍ ກາ ທູແທ ກຍາອ໌ ແກະ, ອັນ ຕາ ເບີນ ຕາລາ ແກະ. ຄັນ ອັນ ເຮີມ ຊາກັອງ ແຕີ່ອ໌, ອັນ ຕາລຸ່ຮ ຕັຮ ແກະ ກັອຍ. ນ່ະກັອຍ ຊາກັອງ ປາລັອງ ກັບ ແກະ; ເຈີ່ ມັຮ ແກະ ກັອຍ ອຶມປຣາຍຮ ອຶມປຣັງ. ");
INSERT INTO ncq_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ກວາຍ ທູແທ ຕາລຸ່ຮ ຕັຮ ແກະ ຍ່ອນ ອັນ ລາ ກວາຍ ກຍາອ໌ ເນົ່າ ຈາງ ຊັອງ. ອັນ ຕາ ເບີນ ປາຊິ ອຶນເຕົ່າ ແຕ ແກະ. ");
INSERT INTO ncq_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","ເກົາ ລາ ກວາຍ ກຍາອ໌ ແກະ ອໍ. ນ່ະ ອຶມປໍ່ ຕຶ່ງ ມັນລັ່ອງ ດັງ ເກົາ, ກະ ເກົາ ດັງ ອຶມປໍ່ ຕຶ່ງ ມັນລັ່ອງ, ມູເຈິງ ກັອຍ ເຕ່ ເກົາ ດັງ ແກະ ເກົາ, ກະ ແກະ ເກົາ ດັງ ເກົາ. ເກົາ ເຣືາບ ກູຈີດ ຕາງ ໂອນ ມັຮ ແກະ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ເບີນ ແກະ ການໍ່ອ໌ ລາ ຄອງ ເກົາ ເຕ່, ມາ ຕາ ເບີນ ແອີດ ຕຶ່ງ ກໍ່ອ໌ ໄນ່. ເກົາ ອຶງເຄາະ ເປາະ ອີດ ເຕ່ ມັຮ ແກະ ກັອຍ. ປັຣແນີ ມັນເຕຣືາ ແກະ ກັອຍ ຊາງັດ ຊຽງ ເກົາ. ເຈີ່ ແກີດ ມູ ຈຸ່ມ ຊັອງ, ກະ ເບີນ ມານະ ກວາຍ ກຍາອ໌ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ອຶມປໍ່ ຕຶ່ງ ມັນລັ່ອງ ອາໂຢ່ະ ລາລື່ ເກົາ, ຍ່ອນ ເກົາ ປຣ່ອມ ຈີວ໌ ກູຈີດ ຕາງ ອຶນແຍ່ະ ມັຮ ກວາຍ. ເກົາ ຈີວ໌ ກູຈີດ ນ່ະກັອຍ ລາ ຍ່ອນ ເກົາ ອຶງກ່ອງ ເບີນ ອາມົ່ງ ລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ເນົ່າ ຕາ ເຕ່ອ໌ ກາຈີດ ຣາງຶ່ຮ ເກົາ, ມາ ເກົາ ຈຸງ ປຣ່ອມ ອີ ຈີວ໌ ກູຈີດ. ເກົາ ເບີນ ອຳນາດ ກູຈີດ. ກະ ເກົາ ເບີນ ອຳນາດ ເຕ່ອ໌ ອາມົ່ງ ລັ່ຮ. ຣານະ ໄນ່ ລາ ອຶມປໍ່ ເກົາ ແປຣີ ໂອນ ເກົາ ຕະ.\" ");
INSERT INTO ncq_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ຈຸ່ມ ອິດຊະຣາເອລ ຣາຕັຮ ແກີດ ບາຣ ຈຸ່ມ. ");
INSERT INTO ncq_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ເບີນ ຊາອຶ່ຍ ນະ ຕຶ່ງ ຈຸ່ມ ໄລ່ ປາຍ: \"ອັນ ກັອຍ ເບີນ ເຢືາງ ຕາ ອໍ ຕຣວບ ເຈີ່. ອັນ ລາ ກວາຍ ຢຸ່ຮ. ນານ່ະ ເຍືາ ຊາງັດ ປັຣນາຍ ອັນ?\" ");
INSERT INTO ncq_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ມາ ຈຸ່ມ ການໍ່ອ໌ ປາຍ: \"ຄັນ ອັນ ໄນ່ ມາ ເຢືາງ ຕາ ອໍ ຕຣວບ, ນານ່ະ ເຕ່ອ໌ ອັນ ອາຕີ ມັຮ ປັຣນາຍ ອັນ ອາຕີ. ເຢືາງ ຕາ ອໍ ຕະ ບຣາງ ມັ່ດ ກວາຍ ຊູດ ເຕ່ອ໌ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ແຕີ່ອ໌ ກາໄຊ ຊາແງດ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ, ຈຸ່ມ ອິດຊະຣາເອລ ຈາ ຣໍ່ອ໌ ຊາແຍີ ຕາໄງ ເບີນ ລັ່ຮ ດຸງ ຊາງ ແຕ ອຶມແບິ. ");
INSERT INTO ncq_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ເຢຊູ ມູ່ດ ຕຶ່ງ ຊັງອາຣ ດຸງ ຊາງ ປື່ດ, ກະ ອັນ ຕາຢັຮ ເປາະ ຕຶ່ງ ລາບຍາງ ໂຊໂລໂມນ. ");
INSERT INTO ncq_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ຈຸ່ມ ອິດຊະຣາເອລ ໂຣ່ມ ອຶມແປຣ ເຢຊູ, ກະ ໄລ່ ຕາແບີບ ອັນ ປາຍ: \"ອຶນນັ່ອງ ມາແລ່ະ ດູ່ນ ໄມ່ ໂອນ ຮິ ແອີດ ເກຣາະ? ຄັນ ໄມ່ ລາ ກຣີດ, ແຊອ໌ ໄມ່ ອາຕີ ໂອນ ຮິ ດັງ ແຈງ.\" ");
INSERT INTO ncq_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ເກົາ ອາຕີ ເຍືາ ເຈີ່, ມາ ເຍືາ ຕາ ຢໍອ໌ ອີ ຊາອຳ ເກົາ. ຣານະ ເກົາ ຕະ ຍ່ອນ ແຕ ຣາມຶ່ຮ ອຶມປໍ່ ເກົາ, ຣານະ ໄນ່ ອາປັຮ ເກົາ ແຕີ່ອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ມາ ເຍືາ ຕາ ເບີນ ຊາອຳ ເກົາ, ຍ່ອນ ເຍືາ ຕາ ແກີນ ແກະ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ຈຸ່ມ ແກະ ເກົາ ຊາງັດ ຊຽງ ເກົາ. ເກົາ ດັງ ໄລ່, ກະ ໄລ່ ປວາຍ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ເກົາ ໂອນ ໄລ່ ອາມົ່ງ ເລືອຍໆ; ນ່ະກັອຍ ອັນ ຕາ ເກີ່ຍ ກູຈີດ. ກວາຍ ອາແລ່ະ ລາ ຕາ ເຕ່ອ໌ ກາຕັ່ອງ ໄລ່ ແຕ ອາຕີ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ອຶມປໍ່ ເກົາ ລາ ປື່ດ ແກຼີຍ ອຶນແຍ່ະ ແຕ ການໍ່ອ໌. ອັນ ໂອນ ເກົາ ເບີນ ຈຸ່ມ ແກະ ກັອຍ. ກວາຍ ອາແລ່ະ ລາ ຕາ ເຕ່ອ໌ ກາຕັ່ອງ ແກະ ກັອຍ ແຕ ອາຕີ ອຶມປໍ່ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ເກົາ ກະ ອຶມປໍ່ ເກົາ ລາ ມາຮ ມານະ ຊັອງ.\" ");
INSERT INTO ncq_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ຈຸ່ມ ອິດຊະຣາເອລ ກັອຍ ອີດ ຕາເມົາ ຢໍອ໌ ອີ ແກຼງ ໂຈະ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ມາ ອັນ ອາຕີ ໄລ່ ປາຍ: \"ເກົາ ຕະ ຊາອຶ່ຍ ຣານະ ອໍ ມັຮ ອຶມປໍ່ ເກົາ ໂອນ ເກົາ ຕະ. ຍ່ອນ ແຕ ຣານະ ອາແລ່ະ ເກົາ ຕະ ກາ ເຍືາ ອີ ແກຼງ ຕາເມົາ ໂຈະ ເກົາ?\" ");
INSERT INTO ncq_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ຈຸ່ມ ອິດຊະຣາເອລ ກັອຍ ຕາແອີຍ ລັ່ຮ: \"ຮິ ຕາ ເບີນ ແກຼງ ຍ່ອນ ໄມ່ ຕະ ຣານະ ອໍ. ມາ ຮິ ຕະ ໄມ່ ຍ່ອນ ໄມ່ ພາມາດ ຣາມຶ່ຮ ເຢືາງ ເຈົາຣາຊີ. ໄມ່ ລາ ກວາຍ ຊັອງ, ມາ ໄມ່ ຢໍອ໌ ກວາຍ ການໍ່ອ໌ ດໍອ໌ ໄມ່ ລາ ເຢືາງ ເຈົາຣາຊີ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ເຢຊູ ຕາແອີຍ ລັ່ຮ ໄລ່ ປາຍ: \"ຕຶ່ງ ຄານອດ ເຍືາ, ເບີນ ກວາຍ ຄຽນ ເຈີ່ ເຢືາງ ເຈົາຣາຊີ ປາຍ: 'ເຍືາ ແກີດ ນ່ະ ເຢືາງ ເຕ່.' ");
INSERT INTO ncq_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ໄຮ ດັງ ເຈີ່ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ລາ ຕາ ເບີນ ປິ່ດ. ກະ ເຢືາງ ເຈົາຣາຊີ ດໍອ໌ ໄລ່ ກາ ຣັ່ບ ປັຣນາຍ ອັນ ລາ ນ່ະ 'ເຢືາງ' ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ມາ ເກົາ ໄນ່, ອຶມປໍ່ ເກົາ ຣຽຮ ເກົາ, ກະ ອັນ ແປຣີ ເກົາ ແຕີ່ອ໌ ປໍ ກູແຕອ໌ ໄນ່. ນານ່ະ ເຍືາ ປາຍ ເກົາ ພາມາດ ຣາມຶ່ຮ ເຢືາງ ເຈົາຣາຊີ ຍ່ອນ ເກົາ ປາຍ ເກົາ ລາ ກອນ ເຢືາງ ເຈົາຣາຊີ? ");
INSERT INTO ncq_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ຄັນ ເກົາ ຕາ ເບີນ ຕະ ຣານະ ອຶມປໍ່ ເກົາ, ເຍືາ ອຶນໂຈຍ ຊາອຳ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ມາ ຄັນ ເກົາ ຕະ ຣານະ ເຢືາງ ເຈົາຣາຊີ, ມາ ເຍືາ ຕາ ແອອ໌ ຊາອຳ ເກົາ, ອຶງເຄາະ ເຍືາ ຊາອຳ ມັຮ ຣານະ ເກົາ ຕະ. ນ່ະກັອຍ ເຍືາ ເຕ່ອ໌ ດັງ ແຈງ ລາລື່ ລາ ອຶມປໍ່ ເກົາ ແອີດ ມູ ຣາງຶ່ຮ ກະ ເກົາ, ກະ ເກົາ ແອີດ ມູ ຣາງຶ່ຮ ກະ ອຶມປໍ່ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ຈຸ່ມ ອິດຊະຣາເອລ ໄລ່ ຈໍ່ອ໌ ຣານາ ຊາ ອີ ໂກບ ເຢຊູ. ມາ ເຢຊູ ນີ່ອ໌ ແຕ ອາຕີ ໄລ່ ກັອຍ; ເຈີ່ ໄລ່ ຕາ ດັງ ເບີນ ໂກບ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ເຢຊູ ເຈົາ ລັ່ຮ ເຈີ່ ໄກ່ອ໌໌ ຕາເລ່ ຈໍແດນ ແຕີ່ອ໌ ປໍ ອຶນຕຸ ໂຢຮັນ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ແຕ ບັອງ ອາໄຣ່. ເຢຊູ ແອີດ ອຶນຕຸ ກັອຍ ເວືາຍ. ");
INSERT INTO ncq_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ກຼຶ່ງ ກວາຍ ແຕີ່ອ໌ ປໍ ອັນ; ເຈີ່ ໄລ່ ປາຍ: \"ໂຢຮັນ ຕາ ເບີນ ຕະ ມວຍ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ອຶນເຕົ່າ, ມາ ມັຮ ປັຣນາຍ ອັນ ອາຕີ ແຕ ກວາຍ ໄນ່ ລາ ປຍາຍ໌ ອຶນແຍ່ະ.\" ");
INSERT INTO ncq_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ອຶນຕຸ ກັອຍ ຊາອຶ່ຍ ນະ ກວາຍ ຊາອຳ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ເບີນ ກວາຍ ຣາເລົາ ມານະ ຣາມຶ່ຮ ລາຊາໂຣ, ແກີດ ອາອີ່. ອັນ ແອີດ ຕຶ່ງ ວີ່ລ ເບັດທານີ. ມາຣີ ລາ ແອີດ ຕຶ່ງ ເມືອງ ກັອຍ ເຕ່ ກະ ແອີຍ ອັນ, ຣາມຶ່ຮ ມາທາ. ");
INSERT INTO ncq_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ມາຣີ ໄນ່ ລາ ມັນແຊມ ກາ ທໍອ໌ ແດີອ໌ ປາຮວມ ຕຶ່ງ ອາເຢີງ ເຢຊູ, ກະ ຈູ່ດ ອາເຢີງ ເຢຊູ ແຕ ໂຊະ ແປຼີ ອັນ. ລາຊາໂຣ, ກາ ອາອີ່ ກັອຍ, ລາ ອາເມືາງ ມາຣີ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ບາຣ ນະ ແຊມແອີຍ ກັອຍ ແປຣີ ກວາຍ ເປາະ ອາຕີ ເຢຊູ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ອັນ ກາ ອຶນເຈົາ ອາໂຢ່ະ ລາລື່, ຊານໍ່ ອັນ ອາອີ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ພໍກາ ເຢຊູ ຊັອງ ປັຣນາຍ ກັອຍ, ອັນ ປາຍ: \"ລາຊາໂຣ ອາອີ່, ມາ ອັນ ຕາ ເບີນ ກູຈີດ ເລີ່. ຍ່ອນ ອັນ ເບີນ ອາອີ່ ໄນ່, ນ່ະກັອຍ ກວາຍ ເບີນ ຍ່ອງ ເຢືາງ ເຈົາຣາຊີ ກະ ກອນ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ເຢຊູ ອາໂຢ່ະ ມາທາ, ມາຣີ, ກະ ລາຊາໂຣ. ");
INSERT INTO ncq_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ພໍກາ ເຢຊູ ຊັອງ ຮານ ປາຍ ລາຊາໂຣ ອາອີ່, ມາ ອັນ ອຶນນັ່ອງ ແອີດ ຕຶ່ງ ອຶນຕຸ ຕຍາ ບາຣ ຕາໄງ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ແວັດ ບາຣ ຕາໄງ, ເຢຊູ ອາຕີ ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ໄຮ ລົ່ບ ເຈົາ ລັ່ຮ ປໍ ແຄງ ຢູດາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ມາ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ອາຕີ ລັ່ຮ ອັນ ປາຍ: \"ອາຈານ ເອີຍ! ຕາ ເບີນ ດູ່ນ ຢວາຮ ຈຸ່ມ ອິດຊະຣາເອລ ປໍ ກັອຍ ຢໍອ໌ ອີ ແກຼງ ຕາເມົາ ໂຈະ ອາຈານ. ມາ ນານ່ະ ຊານໍ່ ອາຈານ ຢໍອ໌ ລົ່ບ ລັ່ຮ ປໍ ກັອຍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ມວຍ ຕາໄງ ຕຶ່ງ ກູແຕອ໌ ໄນ່ ເບີນ ປັ່ງ ມັນຈິ່ດ ລາ ບາຣ ໂມງ ມາ ຕາ ເບີນ? ຄັນ ເບີນ ກວາຍ ເປາະ ຕຶ່ງ ຕາໄງ, ອັນ ຕາ ເບີນ ແດິມ; ຍ່ອນ ປັ່ງ, ເຕ່ອ໌ ອັນ ເຮີມ. ");
INSERT INTO ncq_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ມາ ຄັນ ອັນ ເປາະ ຕຶ່ງ ຊາເດົາ, ອັນ ແດິມ; ຍ່ອນ ການຳ ອັນ ຕາ ບຣາງ ເຮີມ.\" ");
INSERT INTO ncq_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ອັນ ປາຍ ແອັນ: \"ເຢົ່າ ໄຮ, ລາຊາໂຣ, ອັນ ບິ, ມາ ຊານໍ່ ເກົາ ອີ ເປາະ ອາໄມ່ຮ ໂອນ ອັນ ຕາແມີ.\" ");
INSERT INTO ncq_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ຕາແອີຍ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ຄັນ ອັນ ບິ, ລາ ອັນ ປຣາຍ ໄວ່ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ເຢຊູ ອາຕີ ແຕ ລາຊາໂຣ ກູຈີດ ເຈີ່, ມາ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ຄຶ່ດ ລາ ເຢຊູ ປາຍ ລາຊາໂຣ ບິ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ນ່ະກັອຍ ເຢຊູ ອາຕີ ໄລ່ ແຈງ ລາລື່ ປາຍ: \"ລາຊາໂຣ ກູຈີດ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ເກົາ ຣໍ່ອ໌ ເຕ່ ເກົາ ຕາ ເບີນ ແຕີ່ອ໌ ບັອງ ກາ ອັນ ອາອີ່. ມາ ຊານໍ່ ເກົາ ເປາະ ໂອນ ເຍືາ ເຕ່ອ໌ ຊາອຳ ເຣ່ງ ລາລື່. ເຈີ່ ຊານໍ່ ໄຮ ເປາະ ປໍ ລາຊາໂຣ.\" ");
INSERT INTO ncq_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ແວັດ ກັອຍ ໂທມາ, ກາ ເນົ່າ ດໍອ໌ ດີດີມ ແຮີ, ອັນ ປາຍ ໂຈະ ເຢົ່າ ອັນ, ໄລ່ ກາ ຣຍານ ມັນຕຸ ແຕ ເຢຊູ ປາຍ: \"ໄຮ ເປາະ ເຕ່. ໄຮ ປຣ່ອມ ກູຈີດ ມັນຕຸ ກະ ອາຈານ.\" ");
INSERT INTO ncq_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ພໍກາ ເຢຊູ ແຕີ່ອ໌ ປໍ ອຶນຕຸ ກັອຍ, ອັນ ຊັອງ ປາຍ ເນົ່າ ແຕິບ ລາຊາໂຣ ປູນ ຕາໄງ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ວີ່ລ ເບັດທານີ ຣາເຢີ່ງ ເບີນ ໄປ ລັກ ແຕ ເມືອງ ເຢຣູຊາເລັມ. ");
INSERT INTO ncq_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ນ່ະກັອຍ ຊາອຶ່ຍ ນະ ຈຸ່ມ ອິດຊະຣາເອລ ເປາະ ອາລື່ນ ມາທາ ກະ ມາຣີ, ຍ່ອນ ອາເມືາງ ໄລ່ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ພໍກາ ມາທາ ຊັອງ ເຢຊູ ແຈ່ະ ອີ ແຕີ່ອ໌ ກາຕຣໍ່ ວີ່ລ, ເຈີ່ ອັນ ເປາະ ເກຣາະ ເຢຊູ. ມາ ມາຣີ, ອັນ ອຶນນັ່ອງ ແອີດ ອຶນດຸງ. ");
INSERT INTO ncq_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ມາທາ ປາຍ ໂຈະ ເຢຊູ: \"ອຶນເຈົາ ເອີຍ! ຄັນ ອຶນເຈົາ ແອີດ ອຶນໄນ່ ບັອງ ກາ ກັອຍ, ອາເມືາງ ເກົາ ຕາ ເບີນ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ມາ ເກົາ ດັງ ຊານໍ່ ຣາມຶ່ຮ ອຶນເຕົ່າ ອຶນເຈົາ ແຊອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ ລາ ເຢືາງ ເຈົາຣາຊີ ໂອນ.\" ");
INSERT INTO ncq_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ເຢຊູ ອາຕີ ມາທາ ປາຍ: \"ອາເມືາງ ໄມ່ ເບີນ ອາມົ່ງ ລັ່ຮ.\" ");
INSERT INTO ncq_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ເຈີ່ ມາທາ ປາຍ: \"ເກົາ ດັງ ເຈີ່ ອາເມືາງ ເກົາ ອາມົ່ງ ລັ່ຮ ແຕີ່ອ໌ ຕາໄງ ປັຣຊົດ. ຕາໄງ ກັອຍ ອຶນແຍ່ະ ມັຮ ກວາຍ ກາ ກູຈີດ ເບີນ ອາມົ່ງ.\" ");
INSERT INTO ncq_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ເຢຊູ ອາຕີ ລັ່ຮ ມາທາ ປາຍ: \"ເກົາ ໄນ່ ແຕິ່ ເຕ່ອ໌ ໂອນ ກວາຍ ກູຈີດ ຢວຣ ລັ່ຮ ແຕ ປີ່ງ, ກະ ເກົາ ໂອນ ໄລ່ ເບີນ ອາມົ່ງ. ອາແລ່ະ ກາ ຊາອຳ ເກົາ, ແຕີ່ອ໌ ອັນ ກູຈີດ, ລາ ນັ່ອງ ອັນ ອາມົ່ງ. ");
INSERT INTO ncq_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ກວາຍ ອາແລ່ະ ກາ ອຶນນັ່ອງ ອາມົ່ງ ກະ ອັນ ຊາອຳ ເກົາ, ອັນ ກັອຍ ຕາ ເບີນ ກູຈີດ. ໄມ່ ຊາອຳ ປັຣນາຍ ໄນ່ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ມາທາ ຕາແອີຍ ປາຍ: \"ອຶນເຈົາ ເອີຍ, ເກົາ ຊາອຳ! ເກົາ ຊາອຳ ອຶນເຈົາ ລາ ກຣີດ, ກອນ ເຢືາງ ເຈົາຣາຊີ, ອັນ ກາ ເຢືາງ ເຈົາຣາຊີ ແປຣີ ແຕີ່ອ໌ ປໍ ກູແຕອ໌ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ແວັດ ມາທາ ປາຍ ນ່ະກັອຍ, ອັນ ເຈົາ ປໍ ດຸງ, ເຈີ່ ອັນ ຣາຮາຍ໌ ກະ ມາຣີ, ອາແອມ ອັນ, ປາຍ: \"ອາຈານ ແຕີ່ອ໌ ເຈີ່. ອັນ ຢໍອ໌ ອີ ຣາມົຮ ໄມ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ພໍກາ ມາຣີ ຊັອງ ນ່ະກັອຍ, ຢຸ່ກຢັ່ກ ແຕິ່ ອັນ ຢວຣ ເປາະ ປໍ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ເຢຊູ ຕາ ຢວາຮ ມູ່ດ ຕຶ່ງ ວີ່ລ. ອຶນນັ່ອງ ອັນ ແອີດ ຕຶ່ງ ອຶນຕຸ ມາທາ ຣາມົຮ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ກວາຍ ອິດຊະຣາເອລ, ໄລ່ ກາ ເປາະ ອາລື່ນ ຕຶ່ງ ດຸງ ມາຣີ, ໄລ່ ເຮີມ ມາຣີ ຢວຣ ໄວ່ ລາລື່ ລັ່ອຮ ແຕ ດຸງ; ເຈີ່ ໄລ່ ເປາະ ຕາປູ່ນ ອັນ. ໄລ່ ຄຶ່ດ ປາຍ ອັນ ເປາະ ເຍືາມ ປໍ ປີ່ງ ອາເມືາງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ພໍກາ ມາຣີ ແຕີ່ອ໌ ປໍ ເຢຊູ ກະ ເຮີມ ອັນ, ມາຣີ ຄຣາບ ແຈ່ະ ອາເຢີງ ເຢຊູ, ປາຍ: \"ອຶນເຈົາ ເອີຍ! ຄັນ ອຶນເຈົາ ແອີດ ອຶນໄນ່ ບັອງ ກາ ກັອຍ, ອາເມືາງ ເກົາ ຕາ ເບີນ ກູຈີດ.\" ");
INSERT INTO ncq_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ພໍກາ ເຢຊູ ເຮີມ ມາຣີ ເຍືາມ, ກະ ມັຮ ກວາຍ ອິດຊະຣາເອລ ກາ ປວາຍ ມາຣີ ເຍືາມ ເຕ່, ເຢຊູ ຊັອງ ອາໂຢ່ະ ກະ ຕຸ່ຮ ລາລື່ ຕຶ່ງ ຣາງຶ່ຮ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ອັນ ຕາແບີບ ປາຍ: \"ອຶນຕຸ ແລ່ະ ເຍືາ ແຕິບ ອັນ?\" ໄລ່ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ຊານໍ່ ໄຮ ເປາະ ເນ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ເຢຊູ ເຍືາມ. ");
INSERT INTO ncq_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ນ່ະກັອຍ ກວາຍ ອິດຊະຣາເອລ ປາຍ: \"ເອົາ! ເຮີມ! ອັນ ອາໂຢ່ະ ລາລື່ ລາຊາໂຣ!\" ");
INSERT INTO ncq_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ມາ ເບີນ ກວາຍ ປາຍ: \"ອັນ ໄນ່ ຕະ ເຈີ່ ມັ່ດ ກວາຍ ຊູດ ແກີດ ບຣາງ. ບັອງ ກາ ລາຊາໂຣ ຕາ ຢວາຮ ກູຈີດ, ເຕ່ອ໌ ບໍ ອັນ ຕະ ໂອນ ລາຊາໂຣ ຕາ ເບີນ ກູຈີດ?\" ");
INSERT INTO ncq_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ເຢຊູ ແຕີ່ອ໌ ປໍ ປີ່ງ. ຣາງຶ່ຮ ອັນ ຊັອງ ຕຸ່ຮ ລາລື່ ຊາ. ປີ່ງ ໄນ່ ລາ ຕຶ່ງ ກື່ບ, ເບີນ ຕາເມົາ ປື່ດ ກາຕັງ ງັ່ຮ ກື່ບ. ");
INSERT INTO ncq_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ເຢຊູ ແປຣີ ປາຍ: \"ອຶງເຄາະ ເຍືາ ວິ່ລ ອາລັ່ອຮ ຕາເມົາ ແຕ ງັ່ຮ ໄນ່.\" ມາ ມາທາ, ອາມໍ່ອ໌ ອັນ ກາ ກູຈີດ ກັອຍ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ອຶນໂຊະ ເຈີ່, ຍ່ອນ ເນົ່າ ແຕິບ ອັນ ຕຶ່ງ ໄນ່ ປູນ ຕາໄງ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ເຢຊູ ຕາແບີບ ແອັນ ປາຍ: \"ເກົາ ອາຕີ ເຍືາ ເຈີ່ ມາ ຕາ ເບີນ, ຄັນ ເຍືາ ຊາອຳ, ເຍືາ ເບີນ ເຮີມ ອຳນາດ ອາງອື່ຣ ແຕ ເຢືາງ ເຈົາຣາຊີ?\" ");
INSERT INTO ncq_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ນ່ະກັອຍ ໄລ່ ວິ່ລ ຕາເມົາ ກັອຍ. ເຈີ່ ເຢຊູ ຕາເງີ່ອ໌ ອາຊັອຮ ປໍ ມັນລັ່ອງ ກະ ອັນ ປາຍ: \"ອຶມປໍ່ ເກົາ ເອີຍ! ເກົາ ຊາແອີນ ໄມ່, ຍ່ອນ ໄມ່ ຊາງັດ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ເກົາ ດັງ ອຶມປໍ່ ຊາງັດ ເກົາ ເລືອຍໆ, ມາ ເກົາ ປາຍ ນ່ະໄນ່ ໂອນ ກວາຍ ກາ ແອີດ ແຈ່ະ ເກົາ ໄນ່, ເຕ່ອ໌ ໄລ່ ຊາອຳ ເຣ່ງ ລາລື່ ອຶມປໍ່ ແປຣີ ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ອັນ ກູອ໌ ເຣ່ງ ລາລື່: \"ລາຊາໂຣ ເອີຍ! ໄມ່ ລັ່ອຮ ແຕ ປີ່ງ!\" ");
INSERT INTO ncq_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ເຈີ່ ກວາຍ ກູຈີດ ກັອຍ ລັ່ອຮ ແຕ ປີ່ງ. ອາຕີ ກະ ອາເຢີງ ອັນ ອຶນແຍ່ະ ເນົ່າ ຕວມ ອາຣິ. ກະ ອັນ ເບີນ ອາຣິ ການໍ່ອ໌ ຕວມ ມາມ ກະ ແປຼີ ອັນ. ເຢຊູ ແປຣີ ກວາຍ ການໍ່ອ໌ ກັອຍ ປາຍ: \"ອາແລັ່ຮ ຕັຮ ອາຣິ ກາ ເນົ່າ ຕວມ ແຕ ຈະ ອັນ ໂອນ ອັນ ເຈົາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ຊາອຶ່ຍ ນະ ກວາຍ ອິດຊະຣາເອລ, ໄລ່ ກາ ເປາະ ອາລື່ນ ມາຣີ, ໄລ່ ເຮີມ ຣານະ ເຢຊູ ຕະ. ນ່ະກັອຍ ໄລ່ ຊາອຳ ອັນ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ມາ ເບີນ ກວາຍ ການໍ່ອ໌ ແຕ ຈຸ່ມ ອິດຊະຣາເອລ, ໄລ່ ເປາະ ປໍ ຈຸ່ມ ພາຣີຊາຍ ອາຕີ ໄລ່ ມັຮ ຣານະ ເຢຊູ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ນ່ະກັອຍ ຈຸ່ມ ພາຣີຊາຍ ກະ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ໄລ່ ກູອ໌ ອຶນແຍ່ະ ມັຮ ກວາຍ ຊົດ ອິດຊະຣາເອລ; ເຈີ່ ໄລ່ ຊັຣຮົງ. ໄລ່ ປາຍ: \"ກວາຍ ໄນ່ ຕະ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ຊາອຶ່ຍ ລາລື່ ເຈີ່. ນານ່ະ ໄຮ ອີ ຕະ ຊານໍ່? ");
INSERT INTO ncq_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ຄັນ ໄຮ ໂອນ ອັນ ຕະ ນ່ະກັອຍ ເລືອຍໆ, ອຶນແຍ່ະ ມັຮ ກວາຍ ຊາອຳ ອຶນແຍ່ະ ອັນ. ເຈີ່ ກວາຍ ໂຣມ ແຕີ່ອ໌ ຕາລຸຮ ດຸງ ຊາງ ປື່ດ ໄຮ ກະ ອຶນແຍ່ະ ກຣວາງ ໄຮ ແຮີ.\" ");
INSERT INTO ncq_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ຕຶ່ງ ຈຸ່ມ ໄລ່ ເບີນ ມານະ ຣາມຶ່ຮ ກາຢະພາ. ກູມໍ ກັອຍ ອັນ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ. ອັນ ປາຍ: \"ເຍືາ ຕາ ດັງ ອຶນເຕົ່າ ເລີ່ຍ. ");
INSERT INTO ncq_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ເຍືາ ຕາ ເບີນ ຕາຕ່ອຍ໌ ບໍ? ຄັນ ໄຮ ດໍອ໌ ມານະ ໄນ່ ອາມົ່ງ, ກອນແຊມ ໄຮ ອຶນແຍ່ະ ກູຈີດ, ກະ ກຣວາງ ໄຮ ລາ ຣາລຸຮ ອຶນແຍ່ະ ເຕ່. ມາ ຄາອ໌ ໄຮ ໂອນ ມານະ ອັນ ຊັອງ ກູຈີດ ແຕ ອຶນແຍ່ະ ນະ ກວາຍ ໄຮ ກູຈີດ.\" ");
INSERT INTO ncq_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ມາ ອັນ ຕາ ເບີນ ຈຸງ ອີ ປາຍ ແຕ ຣາງຶ່ຮ ອັນ ຊັອງ. ມັຮ ຣານະ ກາຢະພາ ອາຕີ ແຕ ເຢຊູ ກູຈີດ ຕາງ ໂອນ ອຶນແຍ່ະ ກວາຍ ອິດຊະຣາເອລ, ເຢືາງ ເຈົາຣາຊີ ໂອນ ອັນ ອາຕີ ອຶນໂຍ່ງ ຣານະ ກັອຍ, ຍ່ອນ ບັອງ ກາ ກັອຍ ກາຢະພາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ເຢຊູ ຕາ ເບີນ ກູຈີດ ຕາງ ໂອນ ແອີງ ກວາຍ ອິດຊະຣາເອລ ຊັອງ, ມາ ອັນ ກູຈີດ ຕາງ ໂອນ ກູ່ ນະ ກອນ ອາໄກ ເຢືາງ ເຈົາຣາຊີ. ຊານໍ່ ກວາຍ ໄນ່ ຣາຕັຮ ຣາຕາຍ໌ ຊາອຶ່ຍ ອຶນຕຸ, ມາ ປັຣແນີ ມັນເຕຣືາ ໄລ່ ໂຣ່ມ ລັ່ຮ ແກີດ ມວຍ ຈຸ່ມ. ");
INSERT INTO ncq_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ນ່ະກັອຍ ແຕ ຕາໄງ ກັອຍ ກວາຍ ຊົດ ອິດຊະຣາເອລ ຈໍ່ອ໌ ຣານາ ອີ ກາຈີດ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ແວັດ ກັອຍ ເຢຊູ ຕາ ເບີນ ແອີດ ມັນຕຸ ກະ ກວາຍ ກຼຶ່ງ ຈຸ່ມ ອິດຊະຣາເອລ. ມາ ອັນ ເປາະ ປໍ ຕຍາຮ ແຈ່ະ ເມືອງ ເອພຣາອິມ. ອັນ ແອີດ ອຶນຕຸ ກັອຍ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ແຈ່ະ ອີ ແຕີ່ອ໌ ຕາໄງ ກວາຍ ອິດຊະຣາເອລ ຈາ ຊາແຍີ ຕາໄງ ອາກຼັຮ. ນ່ະກັອຍ ກຼຶ່ງ ກວາຍ ກາ ແອີດ ນໍ່ອ໌ ເມືອງ ມູ່ດ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ, ຢໍອ໌ ອີ ປວາຍ ຣີ່ດ ຕະ ບຣັຮ ແຕ ອຶນໂຍ່ງ ໄລ່ ຈາ ຣໍ່ອ໌ ຕາໄງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ຈຸ່ມ ໄລ່ ຈໍ່ອ໌ ເລືອຍໆ ເຢຊູ. ໄລ່ ແອີດ ຕາຢຶ່ງ ຕຶ່ງ ຊັງອາຣ ດຸງ ຊາງ ປື່ດ, ກະ ໄລ່ ມານະ ຕາແບີບ ມານະ: \"ນານ່ະ ໄມ່ ຄຶ່ດ? ອັນ ກັອຍ ແຕີ່ອ໌ ຈາ ຣໍ່ອ໌ ຊາແຍີ ຕາໄງ ກັອຍ ເຕ່, ມາ ຕາ ເບີນ?\" ");
INSERT INTO ncq_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ອຶນແຍ່ະ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ກະ ຈຸ່ມ ພາຣີຊາຍ, ໄລ່ ປາຕັບ ປາຍ, ຄັນ ກວາຍ ອາແລ່ະ ດັງ ອຶນຕຸ ເຢຊູ ແອີດ, ອຶງເຄາະ ອັນ ເປາະ ອາຕີ ໂອນ ໄລ່ ດັງ, ຍ່ອນ ໄລ່ ຢໍອ໌ ອີ ໂກບ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ອຶນນັ່ອງ ຕາປັ່ດ ຕາໄງ ແອັນ ຈຸ່ມ ອິດຊະຣາເອລ ຈາ ຊາແຍີ ຕາໄງ ອາກຼັຮ. ຕາໄງ ກັອຍ ເຢຊູ ເປາະ ປໍ ວີ່ລ ເບັດທານີ, ລາ ອຶນຕຸ ລາຊາໂຣ ແອີດ. ລາຊາໂຣ ລາ ອັນ ກາ ເຢຊູ ອາໂມ່ຍຮ ລັ່ຮ ແຕ ປີ່ງ. ");
INSERT INTO ncq_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ແອີດ ອຶນຕຸ ກັອຍ ໄລ່ ຣັ່ບໂຈມ ເຢຊູ. ມາທາ ອາລັ່ອຮ ຊັຣນາ ໂອນ ໄລ່ ຈາ, ກະ ລາຊາໂຣ ຕາກູ ຈາ ມັນຕຸ ກະ ໄລ່ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ບັອງ ກາ ກັອຍ ມາຣີ ອີດ ແດີອ໌ ປາຮວມ ຕາດີ່ ລິ່ດ. ແດີອ໌ ປາຮວມ ກັອຍ ເບີນ ເກືາ ເປ່ງ ລາລື່. ມາຣີ ທໍອ໌ ແດີອ໌ ປາຮວມ ກັອຍ ຕຶ່ງ ອາເຢີງ ເຢຊູ, ເຈີ່ ອັນ ອີດ ໂຊະ ແປຼີ ອັນ ຈູ່ດ ອາເຢີງ ເຢຊູ. ອຶນແຍ່ະ ດຸງ ກັອຍ ຊັອງ ປາຮວມ ຈັນຈຶ່. ");
INSERT INTO ncq_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ເບີນ ມານະ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ, ຣາມຶ່ຮ ຢູດາ ອິດຊະກາຣີອົດ, ອັນ ກາ ປັຣແນີ ມັນເຕຣືາ ອີ ມ່ອບ ເຢຊູ, ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","\"ນານ່ະ ອັນ ຕາ ເບີນ ຈິ ແດີອ໌ ປາຮວມ, ເຈີ່ ອີດ ປຣະ ເກືາ ກັອຍ ຈ່ອຍ ກວາຍ ກາດີດ? ເກືາ ແດີອ໌ ປາຮວມ ໄນ່ ລີ່ ກະ ປຣະ ເກືາ ເນົ່າ ທູແທ ໄປ ຣ່ອຍ ຕາໄງ.\" ");
INSERT INTO ncq_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ຢູດາ ປາຍ ນ່ະໄນ່, ຕາ ແກີນ ອັນ ຢໍອ໌ ອີ ຈ່ອຍ ກວາຍ ກາດີດ, ມາ ອັນ ຢໍອ໌ ອີ ເປຼິບ ປຣະ ກັອຍ, ຍ່ອນ ອັນ ລາ ກວາຍ ຢຸມ ປຣະ ຈຸງ ຕຶ່ງ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ. ອັນ ເກີ່ຍ ອີດ ຕັອກ ຈາ ແອີງ ອັນ, ແຕ ປຣະ ຈຸງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ມາ ເຢຊູ ຕາແອີຍ ຢູດາ ປາຍ: \"ອຶນໂຈຍ ໄຄອ໌ ມັນແຊມ ໄນ່. ຍ່ອນ ອັນ ກຽມ ດໍອ໌ ແດີອ໌ ປາຮວມ ໄນ່ ໂອນ ແຕີ່ອ໌ ຕາໄງ ເນົ່າ ອີ ແຕິບ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ກວາຍ ກາດີດ ແອີດ ເລືອຍໆ ກະ ເຍືາ. ມາ ຈະ ເກົາ ຕາ ເບີນ ແອີດ ຊົດ ແດີຍ ກະ ເຍືາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ກຼຶ່ງ ກວາຍ ອິດຊະຣາເອລ ຊັອງ ເນົ່າ ປາຍ ເຢຊູ ແອີດ ຕຶ່ງ ວີ່ລ ເບັດທານີ. ນ່ະກັອຍ ໄລ່ ເປາະ ປໍ ກັອຍ ເຕ່. ໄລ່ ຕາ ເບີນ ເປາະ ຢໍອ໌ ອີ ຣາມົຮ ແອີງ ເຢຊູ ຊັອງ, ມາ ໄລ່ ຢໍອ໌ ອີ ເຮີມ ລາຊາໂຣ ແຮີ, ອັນ ກາ ເຢຊູ ອາໂມ່ຍຮ ລັ່ຮ ແຕ ປີ່ງ. ");
INSERT INTO ncq_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ນ່ະກັອຍ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ຊັຣຮົງ ອີ ກາຈີດ ກາ ລາຊາໂຣ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ຍ່ອນ ແຕ ລາຊາໂຣ, ເບີນ ກຼຶ່ງ ກວາຍ ອິດຊະຣາເອລ ຕັຮ ຣີ່ດ ຕຍາ, ເຈີ່ ໄລ່ ຊາອຳ ເຢຊູ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ມາຮ ຕາໄງ ປັຣແນີ ແອັນ ກຼຶ່ງ ກວາຍ ກາ ແຕີ່ອ໌ ຈາ ຣໍ່ອ໌ ຊາແຍີ ຕາໄງ ອາກຼັຮ, ໄລ່ ຊັອງ ເນົ່າ ປາຍ ເຢຊູ ແຈ່ະ ອີ ມູ່ດ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ນ່ະກັອຍ ໄລ່ ອີດ ອຶງກວາງ ຕາວາອ໌ ເຈີ່ ໄລ່ ເປາະ ເກຣາະ ເຢຊູ ແຕີ່ອ໌. ໄລ່ ຕຣຍາວ ເຣ່ງ ລາລື່ ປາຍ: \"ໂຮຊັນນາ! ຍ່ອງ ອັນ ກາ ເຢືາງ ເຈົາຣາຊີ ຣຽຮ ແຕີ່ອ໌ ຈ່ອຍ ອາມົ່ງ ກວາຍ. ຍ່ອງ ເຕືາວ ປັຣເຍືາ ກວາຍ ອິດຊະຣາເອລ.\" ");
INSERT INTO ncq_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ເຢຊູ ຣາມົຮ ມານຳ ກອນ ອາແຊັຮ ແຈລ. ອັນ ຕາກູ ຕຶ່ງ ກຣັອງ ອາແຊັຮ ກັອຍ ມູເຈິງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ ອາຕີ ເຈີ່ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","\"ເມືອງ ເຢຣູຊາເລັມ ເອີຍ! ອຶນໂຈຍ ອຶງກັອຮ ອຶນເຕົ່າ. ຊານໍ່ ເຕືາວ ປັຣເຍືາ ເຍືາ ແຕີ່ອ໌ ເຈີ່. ອັນ ຕາກູ ຕຶ່ງ ກຣັອງ ອາແຊັຮ ແຈລ ກອນ.\" ");
INSERT INTO ncq_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ຕາໄງ ກັອຍ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ຕາ ຢວາຮ ຊາປຸ່ຮ ຣານະ ໄນ່. ມາ ແວັດ ເຢຊູ ຢວຣ ອາມົ່ງ ລັ່ຮ, ໄລ່ ຊາແຍີ ລັ່ຮ ມັຮ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ເນົ່າ ຄຽນ ອາຕີ ແຕ ເຢຊູ. ກະ ໄລ່ ຊາແຍີ ລັ່ຮ ໄລ່ ຕະ ໄກຣ ເຈີ່ ແຕ ມັຮ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ປາຍ ແຕ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ກຼຶ່ງ ກວາຍ ກາ ເຮີມ ເຢຊູ ກູອ໌ ລາຊາໂຣ ລັ່ອຮ ແຕ ປີ່ງ ກະ ອາມົ່ງ ລັ່ຮ, ມັຮ ກວາຍ ກັອຍ ເປາະ ອາຕີ ໂອນ ຕົວ ມັຮ ຣານະ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ເຈີ່ ກຼຶ່ງ ກວາຍ ການໍ່ອ໌ ເປາະ ຣາມົຮ ເຢຊູ ເຕ່, ຍ່ອນ ໄລ່ ຊັອງ ເຢຊູ ຕະ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ນ່ະກັອຍ ຈຸ່ມ ພາຣີຊາຍ, ມານະ ຕະ ອຶນຕີ ໂຈະ ມານະ ປາຍ: \"ຕິຮ! ເຍືາ ເຮີມ ບໍ? ອຶນແຍ່ະ ມັຮ ກວາຍ ຕຶ່ງ ກູແຕອ໌ ປວາຍ ອຶນແຍ່ະ ອັນ. ຕະ ນານ່ະ ລາ ໄຮ ຕາ ເຣືາບ ແຕ ອັນ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ຕາໄງ ໄລ່ ຈາ ຊາແຍີ ກັອຍ ເບີນ ຈຸ່ມ ກວາຍ ກຣີກ ເປາະ ປໍ ເມືອງ ເຢຣູຊາເລັມ ຢໍອ໌ ອີ ໂຣ່ມ ປໍ ກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ຈຸ່ມ ກວາຍ ກຣີກ ກັອຍ ແຕີ່ອ໌ ປໍ ພີລິບ, ລາ ກວາຍ ແຕ ເມືອງ ເບັດຊາອີດາ ຕຶ່ງ ແຄງ ຄາລີເລ. ໄລ່ ກັອຍ ແຊອ໌ ແຕ ພີລິບ ປາຍ: \"ອາຈວາຍຮ ເອີຍ! ຮິ ຢໍອ໌ ອີ ຣາມົຮ ເຢຊູ.\" ");
INSERT INTO ncq_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ນ່ະກັອຍ ພີລິບ ເປາະ ອາຕີ ອັນເດອາ; ເຈີ່ ອັນເດອາ ກະ ພີລິບ ແຕີ່ອ໌ ອາຕີ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ເຢຊູ ອາຕີ ໄລ່ ປາຍ: \"ແຈ່ະ ອີ ແຕີ່ອ໌ ປາເນ່ນ ເຢືາງ ເຈົາຣາຊີ ອາປັຮ ອຳນາດ ອາງອື່ຣ ແຕ ກອນ ເຢືາງ ແກີດ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ຄັນ ເບີນ ມວຍ ກຼອງ ທຣໍ ຊາແລັຮ ຕຶ່ງ ກູແຕອ໌, ອັນ ດັຮ ແກີດ ກັ່ລ; ເຈີ່ ກຼອງ ກັອຍ ແກີດ ປິ່ດ. ຄັນ ເນົ່າ ຕາ ເບີນ ຈົຮ ກຼອງ ກັອຍ, ອັນ ອຶນນັ່ອງ ແກີດ ກຼອງ ນ່ະ ຕຍາ. ມາ ຄັນ ເນົ່າ ຈົຮ ກຼອງ ກັອຍ, ອັນ ແກີດ ຊາອຶ່ຍ ປາໄລ. ");
INSERT INTO ncq_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ກວາຍ ອາແລ່ະ ກາ ປາຊິ ຣາງຶ່ຮ ອັນ ຕຶ່ງ ແດີຍ ໄນ່, ຣາງຶ່ຮ ກວາຍ ກັອຍ ແກີດ ປິ່ດ ຊັອງ. ມາ ກວາຍ ອາແລ່ະ ກາ ຕາ ເບີນ ປາຊິ ຣາງຶ່ຮ ອັນ ຕຶ່ງ ແດີຍ ໄນ່, ກວາຍ ກັອຍ ເບີນ ອາມົ່ງ ຊົດ ແດີຍ. ");
INSERT INTO ncq_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ກວາຍ ອາແລ່ະ ຢໍອ໌ ອີ ຕະ ຣານະ ເກົາ, ອຶງເຄາະ ກວາຍ ກັອຍ ປວາຍ ເກົາ. ອຶນຕຸ ແລ່ະ ເກົາ ແອີດ, ກວາຍ ກາ ຕະ ຣານະ ເກົາ ແອີດ ອຶນຕຸ ກັອຍ ເຕ່. ກະ ກວາຍ ກາ ຕະ ຣານະ ເກົາ, ອຶມປໍ່ ເກົາ ຢຳນັ່ບ ເຕ່ ກວາຍ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","\"ຊານໍ່ ຣາງຶ່ຮ ເກົາ ຊັອງ ຕຸ່ຮ ອາຣຶ່ກ ລາລື່. ນານ່ະ ເກົາ ອີ ປາຍ? ເກົາ ອີ ປາຍ ນ່ະໄນ່: 'ອຶມປໍ່ ເອີຍ! ຈ່ອຍ ໂອນ ເກົາ ເຕ່ອ໌ ວຍາຣ ແຕ ກູຈີດ ໄນ່.' ມາ ເກົາ ຕາ ເຕ່ອ໌ ປາຍ ນ່ະກັອຍ, ຍ່ອນ ເກົາ ແຕີ່ອ໌ ປໍ ກູແຕອ໌ ໄນ່ ໂອນ ເຕ່ອ໌ ຈີວ໌ ຣານະ ກູຈີດ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ອຶມປໍ່ ເອີຍ, ແຊອ໌ ໄມ່ ຕະ ໂອນ ກວາຍ ຍ່ອງ ຣາມຶ່ຮ ອາງອື່ຣ ໄມ່!\" ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ຊຽງ ເຢືາງ ເຈົາຣາຊີ ປາຍ ແຕ ມັນລັ່ອງ ນ່ະໄນ່: \"ເກົາ ຕະ ເຈີ່ ໂອນ ກວາຍ ຍ່ອງ ຣາມຶ່ຮ ອາງອື່ຣ ເກົາ, ກະ ປັຣແນີ ມັນເຕຣືາ ເກົາ ຕະ ລັ່ຮ ມູເຈິງ ກັອຍ ຊາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ກຼຶ່ງ ກວາຍ ກາ ແອີດ ອຶນຕຸ ກັອຍ, ໄລ່ ຊັອງ ຊຽງ ກັອຍ ນ່ະ ຊຽງ ກຣຶ່ມ. ເບີນ ອັນ ກາ ປາຍ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ຕະ ອຶນຕີ ກະ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ມາ ເຢຊູ ປາຍ: \"ຊຽງ ໄນ່ ຕາ ເບີນ ອາຕີ ໂອນ ເກົາ, ມາ ອັນ ອາຕີ ໂອນ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ຊານໍ່ ແຕີ່ອ໌ ປາເນ່ນ ເກົາ ອາເບຼິຮ ອຶນແຍ່ະ ມັຮ ກວາຍ. ກະ ຊານໍ່ ເຢືາງ ກາ ຊົດ ຕຶ່ງ ກູແຕອ໌ ໄນ່, ເກົາ ຕູ່ຍຮ ຕັຮ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ພໍກາ ເນົ່າ ອາແຣິ່ ອາຊັອຮ ເກົາ ແຕ ກູແຕອ໌, ເກົາ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ ແຕີ່ອ໌ ປໍ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ເຢຊູ ປາຍ ນ່ະກັອຍ, ອັນ ຢໍອ໌ ອີ ອາຕີ ໂອນ ກວາຍ ດັງ ຣານາ ອຶນເຕົ່າ ອັນ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ມາ ກຼຶ່ງ ກວາຍ ກັອຍ ອາຕີ ລັ່ຮ ປາຍ: \"ຄານອດ ຮິ ອາຕີ ຮິ ປາຍ ກຣີດ ອາມົ່ງ ເລືອຍໆ. ນ່ະກັອຍ ນານ່ະ ອາຈານ ປາຍ ກອນ ເຢືາງ ແກີດ ກວາຍ ອຶງເຄາະ ເນົ່າ ອາແຣິ່ ອາຊັອຮ? ເນົ່າ ແຕິ່ ກາ ແກີດ ກອນ ເຢືາງ ແກີດ ກວາຍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ເຍືາ ເບີນ ປັ່ງ ອຶນນັ່ອງ ບີ່ອ໌ ຕາໄງ ຊັອງ. ຊານໍ່ ອຶງເຄາະ ເຍືາ ເປາະ ຕຶ່ງ ຣານາ ປັ່ງ ໄນ່, ຍ່ອນ ເຍືາ ຕາ ເບີນ ດັງ ບັອງ ກາ ແລ່ະ ຊັຣບຼິ່ນ ການຳ ແຕີ່ອ໌. ບັອງ ກາ ກັອຍ ເຍືາ ຕາ ດັງ ອີ ເປາະ ປໍ ແລ່ະ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ເຍືາ ອຶນນັ່ອງ ເບີນ ປັ່ງ. ນ່ະກັອຍ ອຶງເຄາະ ເຍືາ ຊາອຳ ອັນ ກາ ເດີງ ປັ່ງ ປໍ ເຍືາ, ເຈີ່ ເຍືາ ແກີດ ກອນ ອາໄກ ອັນ ກາ ເດີງ ປັ່ງ.\" ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ອັນ ລັ່ອຮ ແຕ ໄລ່ ກັອຍ, ກະ ອັນ ເປາະ ຕວຍ໌ ແຕ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ເຢຊູ ຕະ ຊາອຶ່ຍ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ຢັ່ຮ ມັ່ດ ເມືາງ ໄລ່ ເຈີ່, ມາ ອຶນນັ່ອງ ໄລ່ ຕາ ເບີນ ຊາອຳ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ນ່ະກັອຍ ຣາປຍາຍ໌ ກະ ປັຣນາຍ ເອຊາຢາ, ກວາຍ ອາຕີ ຕາງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ, ຄຽນ ແຕ ອຶມແບິ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ເນົ່າ ກາ ຊາອຳ ປັຣນາຍ ຮິ ອາຕີ? ອຶນເຈົາ ອາປັຮ ອຳນາດ ອຶນເຈົາ ໂຈະ ເນົ່າ?\" ");
INSERT INTO ncq_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ນ່ະກັອຍ ຈຸ່ມ ອິດຊະຣາເອລ ຕາ ເຣືາບ ຊາອຳ, ນ່ະ ເອຊາຢາ ຄຽນ ປາຍ ແອັນ: ");
INSERT INTO ncq_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","\"ເຢືາງ ເຈົາຣາຊີ ຕະ ໂອນ ມັ່ດ ໄລ່ ແກີດ ຊູດ, ກະ ຣາງຶ່ຮ ໄລ່ ແກີດ ກັ່ອງ. ນ່ະກັອຍ ມັ່ດ ໄລ່ ຕາ ເຕ່ອ໌ ເຮີມ. ກະ ຣາງຶ່ຮ ໄລ່ ຕາ ເຕ່ອ໌ ດັງ. ໄລ່ ຕາ ຢໍອ໌ ອີ ແຕີ່ອ໌ ປໍ ເກົາ; ໂອນ ເຕ່ອ໌ ເກົາ ປົວ ໂອນ ໄລ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ເອຊາຢາ ປາຍ ນ່ະກັອຍ, ຍ່ອນ ອັນ ເຮີມ ອຳນາດ ອາງອື່ຣ ແຕ ເຢຊູ ເຈີ່. ນ່ະກັອຍ ແຕ ອັນ ເຕ່ອ໌ ຕະ ອຶນຕີ ປັຣນາຍ ໄນ່ ແຕ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ມາ ອຶນນັ່ອງ ເບີນ ຊາອຶ່ຍ ນະ ແຕ ກວາຍ ຊົດ ຊາອຳ ເຢຊູ. ມາ ໄລ່ ກາ ຊາອຳ ກັອຍ, ໄລ່ ຕາ ເບີນ ອາຕີ ໂອນ ກວາຍ ການໍ່ອ໌ ດັງ ປາຍ ໄລ່ ຊາອຳ, ຍ່ອນ ໄລ່ ອຶງກັອຮ ຈຸ່ມ ພາຣີຊາຍ ຕູ່ຍຮ ໄລ່ ແຕ ດຸງ ຊາງ. ");
INSERT INTO ncq_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ນ່ະກັອຍ ໄລ່ ຢໍອ໌ ອີ ໂອນ ກວາຍ ການໍ່ອ໌ ຍ່ອງ ໄລ່ ແກຼີຍ ແຕ ໄລ່ ຢໍອ໌ ອີ ໂອນ ເຢືາງ ເຈົາຣາຊີ ຍ່ອງ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ແວັດ ແຕ ກັອຍ ເຢຊູ ອາຕີ ເຣ່ງ ລາລື່ ປາຍ: \"ກວາຍ ອາແລ່ະ ກາ ຊາອຳ ເກົາ, ກວາຍ ກັອຍ ຕາ ເບີນ ຊາອຳ ແອີງ ເກົາ ຊັອງ, ມາ ອັນ ຊາອຳ ກາ ອັນ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ກວາຍ ອາແລ່ະ ເຮີມ ເກົາ, ກວາຍ ກັອຍ ເຮີມ ກາ ອັນ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ເກົາ ລາ ເດີງ ປັ່ງ ແຕີ່ອ໌ ປໍ ກູແຕອ໌ ໄນ່. ນ່ະກັອຍ ກວາຍ ອາແລ່ະ ກາ ຊາອຳ ເກົາ, ກວາຍ ກັອຍ ຕາ ເບີນ ແອີດ ນັ່ອງ ຕຶ່ງ ການຳ. ");
INSERT INTO ncq_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ກວາຍ ອາແລ່ະ ກາ ຊາງັດ ປັຣນາຍ ເກົາ, ມາ ອັນ ຕາ ເບີນ ຕະ ຕາປູ່ນ ປັຣນາຍ ກັອຍ, ເກົາ ຕາ ເບີນ ຕິ ກວາຍ ກັອຍ. ເກົາ ຕາ ເບີນ ແຕີ່ອ໌ ອີ ຕິ ກວາຍ, ມາ ເກົາ ແຕີ່ອ໌ ອີ ຈ່ອຍ ອາມົ່ງ ອຶນແຍ່ະ ມັຮ ກວາຍ. ");
INSERT INTO ncq_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ເບີນ ອັນ ກາ ຕັດຊີ່ນ ກວາຍ ກາ ຕາ ແອອ໌ ເກົາ, ກະ ກວາຍ ກາ ຕາ ເບີນ ອີດ ປັຣນາຍ ເກົາ. ແຕີ່ອ໌ ຕາໄງ ປັຣຊົດ, ມັຮ ປັຣນາຍ ເກົາ ອາຕີ ເຈີ່, ປັຣນາຍ ກັອຍ ແຕິ່ ກາ ຕິ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ເກົາ ຕາ ເບີນ ອາຕີ ແຕ ຣາງຶ່ຮ ເກົາ ເບີມ. ມາ ອຶມປໍ່ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່, ອັນ ແຕິ່ ອາຕີ ເກົາ ມັຮ ປັຣນາຍ ເກົາ ປາຍ. ");
INSERT INTO ncq_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ມັຮ ປັຣນາຍ ອັນ ປາຕັບ, ເກົາ ດັງ ປັຣນາຍ ກັອຍ ໂອນ ກວາຍ ເບີນ ອາມົ່ງ ເລືອຍໆ. ນ່ະກັອຍ, ປັຣນາຍ ອຶນເຕົ່າ ເກົາ ປາຍ ລາ ມູເຈິງ ປັຣນາຍ ອຶມປໍ່ ປາຕັບ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ອຶນນັ່ອງ ມວຍ ຕາໄງ ແອັນ, ກວາຍ ອິດຊະຣາເອລ ອີ ຈາ ຊາແຍີ ຕາໄງ ອາກຼັຮ. ຕາໄງ ກັອຍ ເຢຊູ ດັງ ແຈ່ະ ເຈີ່ ຕາໄງ ອັນ ແວັດ ແຕ ກູແຕອ໌ ໄນ່ ເຈົາ ລັ່ຮ ປໍ ອຶມປໍ່ ອັນ. ອັນ ອາໂຢ່ະ ອຶນແຍ່ະ ມັຮ ກວາຍ ຕຶ່ງ ກູແຕອ໌ ໄນ່ ກາ ເບີນ ມູ ຣາງຶ່ຮ ກະ ອັນ. ອັນ ອາໂຢ່ະ ລາລື່ ໄລ່ ເຕົ່າ ອັນ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ອຶນໂຍ່ງ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ໂຣ່ມ ຈາ ເປ່ລ ຕາບື່, ເຢືາງ ຊາຕານ ຕະ ຕຶ່ງ ຣາງຶ່ຮ ຢູດາ, ກອນ ຊີໂມນ ອິດຊະກາຣີອົດ, ໂອນ ອັນ ມ່ອບ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ເຢຊູ ດັງ ອຶມປໍ່ ອັນ ໂອນ ອັນ ເບີນ ອຳນາດ ໂອນ ອັນ ຊົດ ກູ່ ຣາມຶ່ຮ. ກະ ອັນ ດັງ ອັນ ແຕີ່ອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ, ກະ ແຈ່ະ ອັນ ອີ ເຈົາ ລັ່ຮ ປໍ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ນ່ະກັອຍ ເຢຊູ ຢວຣ ຕາຢຶ່ງ ແຕ ອຶນຕຸ ອັນ ຈາ. ອັນ ຕວດ ດໍອ໌ ອາຢັ່ອຮ ຕີ່ ອັນ; ເຈີ່ ອັນ ອີດ ອາຣິ ຕີ່ ກາຕັ່ນ ຕຶ່ງ ອຶງກີງ. ");
INSERT INTO ncq_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ແວັດ ກັອຍ ເຢຊູ ໂຈະ ແດີອ໌ ຕຶ່ງ ກູບານ, ເຈີ່ ຕາແບິ ອາເຣືາວ ອາເຢີງ ມູ່ ກາ ຣຍານ ແຕ ອັນ. ກະ ອັນ ອີດ ອາຣິ ຕີ່ ແຕ ອຶງກີງ ອັນ; ເຈີ່ ຈູ່ດ ອາເຢີງ ໄລ່ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ພໍກາ ອັນ ແຕີ່ອ໌ ປໍ ຊີໂມນ ເປໂຕ, ເຈີ່ ເປໂຕ ຕາແບີບ ອັນ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ອຶນເຈົາ ອີ ອາເຣືາວ ອາເຢີງ ເກົາ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ເຢຊູ ຕາແອີຍ ອັນ ປາຍ: \"ໄມ່ ຕາ ເບີນ ຊາປຸ່ຮ ຣານະ ເກົາ ຕະ ຊານໍ່, ມາ ອຶນຕູ່ນ ແອັນ ໄມ່ ດັງ.\" ");
INSERT INTO ncq_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ເປໂຕ ປາຍ ແອັນ ໂຈະ ເຢຊູ: \"ຕາ ປຍາຍ໌ ເລີ່ ອຶນເຈົາ ມາ ອາເຣືາວ ອາເຢີງ ເກົາ.\" ມາ ເຢຊູ ຕາແອີຍ ອັນ ປາຍ: \"ຄັນ ເກົາ ຕາ ເບີນ ອາເຣືາວ ອາເຢີງ ໄມ່, ໄມ່ ຕາ ເບີນ ແກີດ ມູ ຣາງຶ່ຮ ກະ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ເຈີ່ ຊີໂມນ ເປໂຕ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ຄັນ ນ່ະກັອຍ, ແຊອ໌ ອຶນເຈົາ ອຶນໂຈຍ ອາເຣືາວ ແອີງ ອາເຢີງ ຊັອງ. ມາ ອາເຣືາວ ອາຕີ ກະ ແປຼີ ເກົາ ແຮີ!\" ");
INSERT INTO ncq_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ເຢຊູ ປາຍ ແອັນ ໂຈະ ອັນ: \"ກວາຍ ອາແລ່ະ ກາ ເຈີ່ ອຶມເປີ່ຍ ແດີອ໌, ອຶນແຍ່ະ ຈະ ກວາຍ ກັອຍ ບຣັຮ ເຈີ່. ແວັດ ອັນ ອຶມເປີ່ຍ ແດີອ໌, ອຶງເຄາະ ອາເຣືາວ ລັ່ຮ ແອີງ ອາເຢີງ ຊັອງ. ຊານໍ່ ເຍືາ ບຣັຮ ເຈີ່, ມາ ອຶນນັ່ອງ ມານະ ແຕ ເຍືາ ຕາ ເບີນ ບຣັຮ.\" ");
INSERT INTO ncq_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ເຢຊູ ປາຍ ມານະ ແຕ ໄລ່ ຕາ ເບີນ ບຣັຮ, ຍ່ອນ ອັນ ດັງ ເຈີ່ ມານະ ກາ ຢໍອ໌ ອີ ມ່ອບ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ແວັດ ເຢຊູ ອາເຣືາວ ອາເຢີງ ໄລ່, ອັນ ແຊິບ ລັ່ຮ ອາຢັ່ອຮ ຕີ່ ອັນ, ກະ ອັນ ຕາກູ ລັ່ຮ ອຶນຕຸ ອັນ ຈາ ຊາ. ອັນ ຕາແບີບ ໄລ່ ປາຍ: \"ເຍືາ ຊາປຸ່ຮ ມາ ຕາ ເບີນ, ຣານະ ເກົາ ຕະ ກະ ເຍືາ ໄນ່? ");
INSERT INTO ncq_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ເຍືາ ດໍອ໌ ເກົາ ລາ ອາຈານ ກະ ອຶນເຈົາ. ປຍາຍ໌ ເຍືາ ປາຍ ນ່ະກັອຍ. ໄກຣ ລາລື່ ເກົາ ລາ ບາຣ ຣາມຶ່ຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ເກົາ ລາ ອຶນເຈົາ ເຍືາ ກະ ອາຈານ ເຍືາ, ມາ ເກົາ ອາເຣືາວ ອາເຢີງ ເຍືາ. ນ່ະກັອຍ ເຍືາ ອຶງເຄາະ ຕະ ມູເຈິງ ກັອຍ ເຕ່, ມານະ ອາເຣືາວ ອາເຢີງ ມານະ. ");
INSERT INTO ncq_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ເກົາ ຕະ ອາໂຢ່ງ ໂອນ ເຍືາ ເຮີມ, ເຈີ່ ເຕ່ອ໌ ເຍືາ ຕະ ມູເຈິງ ເກົາ ຕະ ໂອນ ເຍືາ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ກວາຍ ຊູລ ຕາ ເບີນ ປື່ດ ແກຼີຍ ແຕ ອຶນເຈົາ ອັນ, ກະ ກວາຍ ກາ ເດີງ ປັຣນາຍ ຕາ ເບີນ ປື່ດ ກາເລີຍ ແຕ ອັນ ກາ ແປຣີ ອັນ ເປາະ. ");
INSERT INTO ncq_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ຄັນ ເຍືາ ດັງ ອຶນແຍ່ະ ຣາມຶ່ຮ ໄນ່, ກະ ເຍືາ ຕາປູ່ນ ກຣັ່ກ ລາລື່, ນ່ະກັອຍ ເຍືາ ເບີນ ບຸ່ນ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ມາ ເກົາ ຕາ ເບີນ ອາຕີ ແຕ ອຶນແຍ່ະ ມັຮ ເຍືາ. ເກົາ ດັງ ມັຮ ກວາຍ ກາ ເກົາ ຣຽຮ ເຈີ່. ມາ ຣາປຍາຍ໌ ກະ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ ປາຍ: 'ເບີນ ມານະ ກາ ຈາ ໂດຍ ກະ ເກົາ; ອັນ ກັອຍ ເບີນ ຣາງຶ່ຮ ອີ ກາຈີດ ເກົາ.' ");
INSERT INTO ncq_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","\"ຊານໍ່ ເກົາ ອາຕີ ເຍືາ ບັອງ ກາ ຣານະ ໄນ່ ຕາ ຢວາຮ ແຕີ່ອ໌. ມາ ພໍກາ ຣານະ ໄນ່ ແຕີ່ອ໌, ເຍືາ ເຕ່ອ໌ ຊາອຳ ເກົາ ລາ ມານະ ກາ ເກົາ ປາຍ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ກວາຍ ອາແລ່ະ ຊາງັດ ປັຣນາຍ ກວາຍ ກາ ເກົາ ແປຣີ ໂອນ ເປາະ ອາຕີ, ໄນ່ ລາ ມູເຈິງ ອັນ ຊາງັດ ປັຣນາຍ ເກົາ ເຕ່. ກະ ກວາຍ ອາແລ່ະ ຊາງັດ ປັຣນາຍ ເກົາ, ໄນ່ ລາ ມູເຈິງ ອັນ ຊາງັດ ປັຣນາຍ ອັນ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ຣາງຶ່ຮ ອັນ ຊັອງ ຕຸ່ຮ ອາຣຶ່ກ ລາລື່. ອັນ ປາຍ: \"ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ເບີນ ມານະ ແຕ ເຍືາ ອີ ມ່ອບ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ, ໄລ່ ມານະ ເນ່ ຊັຣກຼັ່ອງ ໂຈະ ມານະ. ໄລ່ ຊັອງ ງຶ່ດ ເຕ່, ຕາ ດັງ ເນົ່າ ເຢຊູ ປາຍ. ");
INSERT INTO ncq_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ເບີນ ມານະ ແຕ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ກາ ຣາຕອຍ ລາລື່ ກະ ອັນ, ອັນ ກັອຍ ແອີດ ແຈ່ະ ເຢຊູ ບັອງ ກາ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ຊີໂມນ ເປໂຕ ກູວອຍ໌ ກະ ແປຣີ ອັນ ປາຍ: \"ໄມ່ ຕາແບີບ ເຢຊູ, ອັນ ອາຕີ ແຕ ເນົ່າ.\" ");
INSERT INTO ncq_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ເຈີ່ ອັນ ຊີອ໌ ແຈ່ະ ເຢຊູ ກະ ປາຍ: \"ແຊອ໌ ອຶນເຈົາ ອາຕີ ໂອນ ເກົາ ດັງ ເນົ່າ ກາ ຈິ ໄມ່?\" ");
INSERT INTO ncq_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ເຢຊູ ຕາແອີຍ ປາຍ: \"ຊານໍ່ ເກົາ ຕຸ ມວຍ ເມ່ງ ໂດຍ ບຸຮ ຕຶ່ງ ຕາງານ. ເຈີ່ ເກົາ ອາແວີຍ ໂອນ ປໍ ອັນ ກາ ອີ ຈິ ເກົາ.\" ນ່ະກັອຍ ເຢຊູ ອີດ ມວຍ ເມ່ງ ໂດຍ ບຸຮ. ອັນ ຕຸ ໂດຍ ບຸຮ ກັອຍ ຕຶ່ງ ຕາງານ. ເຈີ່ ອັນ ອາແວີຍ ໂອນ ຢູດາ, ກອນ ຊີໂມນ ອິດຊະກາຣີອົດ. ");
INSERT INTO ncq_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ພໍກາ ຢູດາ ຣັ່ບ ໂດຍ ບຸຮ ກັອຍ, ບັອງ ກາ ກັອຍ ແຕິ່ ເຢືາງ ຊາຕານ ມູ່ດ ຕຶ່ງ ຣາງຶ່ຮ ອັນ. ເຈີ່ ເຢຊູ ອາຕີ ຢູດາ ປາຍ: \"ຣານະ ອຶນເຕົ່າ ໄມ່ ອີ ຕະ, ໄມ່ ຕະ ໄວ່!\" ");
INSERT INTO ncq_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ກວາຍ ການໍ່ອ໌ ກາ ຕາກູ ຈາ ອຶນຕຸ ກັອຍ, ໄລ່ ຕາ ເບີນ ຊາປຸ່ຮ ປັຣນາຍ ເຢຊູ ປາຍ ກະ ຢູດາ. ");
INSERT INTO ncq_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ກວາຍ ການໍ່ອ໌ ກັອຍ ຄຶ່ດ ປາຍ ເຢຊູ ແປຣີ ຢູດາ ໂອນ ເປາະ ແຈີງ ເກຣີ່ງ ກຽມ ດໍອ໌ ຕຶ່ງ ຕາໄງ ຈາ ຣໍ່ອ໌, ແຕີລາ ຈ່ອຍ ກວາຍ ກາດີດ, ຍ່ອນ ຢູດາ ຢຸມ ປຣະ ຈຸງ ແຕ ມູ່ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ແວັດ ຢູດາ ຣັ່ບ ໂດຍ ບຸຮ ກັອຍ, ເຈີ່ ອັນ ລັ່ອຮ ແຕິ່. ບັອງ ກາ ກັອຍ ມັນລັ່ອງ ຊາເດົາ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ແວັດ ຢູດາ ລັ່ອຮ, ເຢຊູ ປາຍ: \"ຊານໍ່ ເນົ່າ ເບີນ ເຮີມ ອຳນາດ ອາງອື່ຣ ກອນ ເຢືາງ ແກີດ ກວາຍ. ກະ ເນົ່າ ຍ່ອງ ເຢືາງ ເຈົາຣາຊີ ແຮີ ຍ່ອນ ແຕ ກອນ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ຄັນ ເນົ່າ ຍ່ອງ ອຳນາດ ອາງອື່ຣ ເຢືາງ ເຈົາຣາຊີ ຍ່ອນ ແຕ ກອນ ອັນ, ມູເຈິງ ກັອຍ ເຕ່ ເຢືາງ ເຈົາຣາຊີ ຕະ ໂອນ ເນົ່າ ຍ່ອງ ອຳນາດ ອາງອື່ຣ ກອນ ອັນ ຍ່ອນ ແຕ ເຢືາງ ເຈົາຣາຊີ. ກະ ອັນ ຕະ ໂອນ ເນົ່າ ຍ່ອງ ແຕິ່ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ມັຮ ກອນ ເກົາ ເອີຍ! ເກົາ ແອີດ ກະ ເຍືາ ອຶນນັ່ອງ ບີ່ອ໌ ຕາໄງ ຊັອງ. ເຍືາ ຈໍ່ອ໌ ເກົາ, ມາ ເກົາ ອາຕີ ເຍືາ ມູເຈິງ ເກົາ ອາຕີ ມັຮ ກວາຍ ຊົດ ອິດຊະຣາເອລ ເຈີ່: 'ເຍືາ ຕາ ເຕ່ອ໌ ເປາະ ປໍ ອຶນຕຸ ເກົາ ເປາະ.' ");
INSERT INTO ncq_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ຊານໍ່ ເກົາ ປາຕັບ ໂອນ ເຍືາ ມວຍ ປັຣນາຍ ຕາໄມ ແອັນ: ອຶງເຄາະ ເຍືາ ມານະ ອາໂຢ່ະ ມານະ. ມູເຈິງ ເກົາ ອາໂຢ່ະ ເຍືາ ເຈີ່, ນ່ະກັອຍ ເຕ່ ເຍືາ ອຶງເຄາະ ມານະ ອາໂຢ່ະ ມານະ. ");
INSERT INTO ncq_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ຄັນ ເຍືາ ມານະ ອາໂຢ່ະ ມານະ, ອຶນແຍ່ະ ມັຮ ກວາຍ ດັງ ປາຍ ເຍືາ ຕາປູ່ນ ຣານະ ເກົາ ກຣັ່ກ ລາລື່.\" ");
INSERT INTO ncq_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ຊີໂມນ ເປໂຕ ຕາແບີບ ເຢຊູ: \"ອຶນເຈົາ ເອີຍ! ປໍ ແລ່ະ ອຶນເຈົາ ອີ ເປາະ?\" ເຢຊູ ຕາແອີຍ ອັນ ປາຍ: \"ອຶນຕຸ ເກົາ ເປາະ, ຊານໍ່ ໄມ່ ຕາ ເຕ່ອ໌ ປວາຍ ເກົາ. ມາ ປັຣແນີ ມັນເຕຣືາ ເຕ່ອ໌ ໄມ່ ປວາຍ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ເປໂຕ ຕາແບີບ ແອັນ: \"ອຶນເຈົາ ເອີຍ! ນານ່ະ ແຕ ເກົາ ຕາ ເຕ່ອ໌ ປວາຍ ອຶນເຈົາ ຊານໍ່? ເກົາ ເຣືາບ ຈີວ໌ ກູຈີດ ກະ ອຶນເຈົາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ມາ ເຢຊູ ອາເບຼິຮ ລັ່ຮ ອັນ ປາຍ: \"ເມ່ນ ບໍ? ໄມ່ ເຣືາບ ຈີວ໌ ກູຈີດ ກະ ເກົາ ບໍ? ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ໄມ່: ອຶນໂຍ່ງ ອຶນຕຣວຍ ຕາ ຢວາຮ ຕາກາຣ, ໄມ່ ກາແລີຍຮ ເກົາ ເບີນ ໄປ ເຮີບ.\" ");
INSERT INTO ncq_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ເຢຊູ ອາຕີ ແອັນ ປາຍ: \"ອຶນໂຈຍ ໂອນ ຣາງຶ່ຮ ເຍືາ ແກີດ ຕຸ່ຮ ອາຣຶ່ກ. ນານ່ະ ເຍືາ ຊາອຳ ເຢືາງ ເຈົາຣາຊີ, ອຶງເຄາະ ເຍືາ ຊາອຳ ເກົາ ນ່ະກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ຕຶ່ງ ດຸງ ອຶມປໍ່ ເກົາ ເບີນ ຊາອຶ່ຍ ອຶນຕຸ ແອີດ. ຊານໍ່ ເກົາ ເປາະ ກຽມ ດໍອ໌ ອຶນຕຸ ໂອນ ເຍືາ ແອີດ. ຄັນ ຣານະ ໄນ່ ມາ ຕາ ເບີນ ປຍາຍ໌, ເກົາ ຕາ ເບີນ ອາຕີ ຣານະ ໄນ່ ໂອນ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ແວັດ ເກົາ ເປາະ ກຽມ ດໍອ໌ ອຶນຕຸ ໂອນ ເຍືາ ແອີດ, ເກົາ ແຕີ່ອ໌ ລັ່ຮ ເດີງ ເຍືາ ເປາະ ກະ ເກົາ. ປໍ ແລ່ະ ເກົາ ແອີດ, ເຍືາ ແອີດ ປໍ ກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ກະ ເຍືາ ດັງ ເຈີ່ ຣານາ ເກົາ ອີ ເປາະ ປໍ ອຶນຕຸ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ມາ ໂທມາ ຕາແບີບ ເຢຊູ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ຮິ ຕາ ດັງ ປໍ ແລ່ະ ອຶນເຈົາ ອີ ເປາະ. ນານ່ະ ເຕ່ອ໌ ຮິ ດັງ ຣານາ ເປາະ ປໍ ກັອຍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ເຢຊູ ຕາແອີຍ ອັນ ປາຍ: \"ເກົາ ລາ ຣານາ ເປາະ; ເກົາ ລາ ຣານາ ປຍາຍ໌; ກະ ເກົາ ລາ ຣານາ ອາມົ່ງ. ຕາ ເບີນ ເນົ່າ ເຕ່ອ໌ ແຕີ່ອ໌ ປໍ ອຶມປໍ່ ເກົາ, ຄັນ ຕາ ເບີນ ເປາະ ຣານາ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ຄັນ ເຍືາ ດັງ ເກົາ, ເຍືາ ດັງ ອຶມປໍ່ ເກົາ ເຕ່. ມາ ແຕ ໄນ່ ເຈີ່ ປໍ ເມືາງ ເຍືາ ດັງ ອັນ, ກະ ເຍືາ ເຮີມ ອັນ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ພີລິບ ປາຍ ກະ ເຢຊູ: \"ແຊອ໌ ອຶນເຈົາ ອາປັຮ ອຶມປໍ່ ອຶນເຈົາ ໂອນ ຮິ ດັງ ອັນ, ລາ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ເຢຊູ ຕາແອີຍ ອັນ ປາຍ: \"ພີລິບ ເອີຍ! ເກົາ ແອີດ ກະ ເຍືາ ດູ່ນ ເຈີ່, ມາ ນານ່ະ ອຶນນັ່ອງ ໄມ່ ຕາ ຢວາຮ ດັງ ເກົາ? ກວາຍ ອາແລ່ະ ກາ ເຮີມ ເກົາ ເຈີ່, ມູເຈິງ ອັນ ເຮີມ ອຶມປໍ່ ເກົາ ເຕ່. ນານ່ະ ໄມ່ ແຊອ໌ ໂອນ ເກົາ ອາປັຮ ອຶມປໍ່ ເກົາ ໂອນ ເຍືາ ດັງ ອັນ? ");
INSERT INTO ncq_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ນານ່ະ ເຍືາ ຕາ ເບີນ ຊາອຳ ເກົາ ແອີດ ມູ ຣາງຶ່ຮ ກະ ອຶມປໍ່, ກະ ອຶມປໍ່ ແອີດ ມູ ຣາງຶ່ຮ ກະ ເກົາ? ປັຣນາຍ ເກົາ ອາຕີ ເຍືາ ຕາ ແກີນ ປັຣນາຍ ແຕ ເກົາ ເບີມ, ມາ ໄກຣ ລາລື່ ອຶມປໍ່ ກາ ແອີດ ມູ ຣາງຶ່ຮ ກະ ເກົາ, ອັນ ຕະ ອຶນແຍ່ະ ມັຮ ຣານະ ໄນ່ ລາ ຣານະ ອັນ ເບີມ. ");
INSERT INTO ncq_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ອຶງເຄາະ ເຍືາ ຊາອຳ ເກົາ ບັອງ ກາ ເກົາ ປາຍ ເກົາ ແອີດ ມູ ຣາງຶ່ຮ ກະ ອຶມປໍ່, ກະ ອຶມປໍ່ ແອີດ ມູ ຣາງຶ່ຮ ກະ ເກົາ. ມາ ຄັນ ເຍືາ ຕາ ຢໍອ໌ ອີ ຊາອຳ, ອຶງເຄາະ ເຍືາ ຊາອຳ ເກົາ ຍ່ອນ ແຕ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ເກົາ ຕະ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ກວາຍ ອາແລ່ະ ກາ ຊາອຳ ເກົາ, ກວາຍ ກັອຍ ຕະ ຣານະ ມູເຈິງ ເກົາ ເຕ່. ມາ ອັນ ຕະ ຣານະ ປື່ດ ແກຼີຍ ແຕ ກັອຍ ແອັນ, ຍ່ອນ ຊານໍ່ ເກົາ ເຈົາ ປໍ ອຶມປໍ່ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ຣານະ ອຶນເຕົ່າ ເຍືາ ແຊອ໌ ຍ່ອນ ແຕ ຣາມຶ່ຮ ເກົາ, ເກົາ ໂອນ ເຍືາ ເບີນ ຣາມຶ່ຮ ກາ ເຍືາ ແຊອ໌. ເກົາ ຕະ ນ່ະກັອຍ ໂອນ ເນົ່າ ຍ່ອງ ອຳນາດ ອາງອື່ຣ ອຶມປໍ່ ເກົາ ຕຶ່ງ ມັນລັ່ອງ ຍ່ອນ ແຕ ກອນ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ຄັນ ເຍືາ ແຊອ໌ ອຶນເຕົ່າ ຍ່ອນ ແຕ ຣາມຶ່ຮ ເກົາ, ເກົາ ໂອນ ເຍືາ ເບີນ ອາກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","\"ຄັນ ເຍືາ ອາໂຢ່ະ ເກົາ, ນ່ະກັອຍ ອຶງເຄາະ ເຍືາ ຕະ ຕາປູ່ນ ອຶນແຍ່ະ ປັຣນາຍ ເກົາ ປາຕັບ. ");
INSERT INTO ncq_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","ເຈີ່ ເກົາ ແຊອ໌ ແຕ ອຶມປໍ່ ເກົາ, ກະ ອັນ ໂອນ ເຍືາ ເບີນ ຣາເວືາຍ ປຍາຍ໌ ເລືອຍໆ. ຣາເວືາຍ ກັອຍ ເຕ່ນ ເກົາ ຈ່ອຍ ເຍືາ, ກະ ແອີດ ເລືອຍໆ ກະ ເຍືາ. ມາ ກວາຍ ການໍ່ອ໌, ໄລ່ ກາ ຕາ ເບີນ ຊາອຳ, ໄລ່ ກັອຍ ຕາ ເຕ່ອ໌ ເບີນ ຣາເວືາຍ ໄນ່, ຍ່ອນ ໄລ່ ຕາ ເບີນ ຊາກັ່ລ ກະ ຕາ ເບີນ ດັງ ອັນ. ມາ ເຍືາ ດັງ ອັນ, ຍ່ອນ ອັນ ແອີດ ເລືອຍໆ ກະ ເຍືາ, ກະ ອັນ ແອີດ ຕຶ່ງ ຣາງຶ່ຮ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ເກົາ ຕາ ເບີນ ຕັຮ ເຍືາ ໂອນ ເຍືາ ແກີດ ນ່ະ ກອນ ກູມູ່ຍ໌. ເກົາ ອຶນນັ່ອງ ອີ ແຕີ່ອ໌ ລັ່ຮ ປໍ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ນັ່ອງ ບີ່ອ໌ ຕາໄງ ຊັອງ, ມັຮ ກວາຍ ຕຶ່ງ ແດີຍ ໄນ່ ຕາ ເບີນ ເຮີມ ນັ່ອງ ເກົາ, ມາ ເຍືາ ອຶນນັ່ອງ ເຮີມ ເກົາ. ຍ່ອນ ເກົາ ອາມົ່ງ, ນ່ະກັອຍ ປັຣແນີ ມັນເຕຣືາ ເຍືາ ອາມົ່ງ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ຕຶ່ງ ຕາໄງ ກັອຍ ເຍືາ ດັງ ແຈງ ເກົາ ແອີດ ມູ ຣາງຶ່ຮ ກະ ອຶມປໍ່ ເກົາ, ກະ ເຍືາ ແອີດ ມູ ຣາງຶ່ຮ ກະ ເກົາ ມູເຈິງ ເກົາ ແອີດ ມູ ຣາງຶ່ຮ ກະ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","\"ກວາຍ ອາແລ່ະ ຣັ່ບ ອຶນແຍ່ະ ປັຣນາຍ ເກົາ ປາຕັບ, ກະ ຕະ ຕາປູ່ນ ອຶນແຍ່ະ ປັຣນາຍ ກັອຍ, ກວາຍ ກັອຍ ອາໂຢ່ະ ເກົາ. ອຶມປໍ່ ເກົາ ອາໂຢ່ະ ອັນ ກາ ອາໂຢ່ະ ເກົາ. ເກົາ ອາໂຢ່ະ ເຕ່ ອັນ ກັອຍ, ກະ ເກົາ ອາປັຮ ຣານະ ເກົາ ໂອນ ອັນ ກັອຍ ດັງ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ຢູດາ (ຢູດາ ໄນ່ ຕາ ແກີນ ຢູດາ ອິດຊະກາຣີອົດ) ຕາແບີບ ເຢຊູ: \"ອຶນເຈົາ ເອີຍ, ນານ່ະ ແຕ ອຶນເຈົາ ອາປັຮ ຣານະ ອຶນເຈົາ ໂອນ ແອີງ ຮິ ຊັອງ, ມາ ອຶນເຈົາ ຕາ ເບີນ ອາປັຮ ໂອນ ມັຮ ກວາຍ ຕຶ່ງ ແດີຍ ໄນ່?\" ");
INSERT INTO ncq_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ເຢຊູ ຕາແອີຍ ອັນ ປາຍ: \"ກວາຍ ອາແລ່ະ ກາ ອາໂຢ່ະ ເກົາ, ກວາຍ ກັອຍ ຕະ ຕາປູ່ນ ອຶນແຍ່ະ ປັຣນາຍ ເກົາ. ອຶມປໍ່ ເກົາ ອາໂຢ່ະ ກວາຍ ກັອຍ. ເກົາ ກະ ອຶມປໍ່ ເກົາ ແຕີ່ອ໌ ປໍ ກວາຍ ກັອຍ; ເຈີ່ ແອີດ ເລືອຍໆ ກະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ມາ ກວາຍ ອາແລ່ະ ກາ ຕາ ເບີນ ອາໂຢ່ະ ເກົາ, ກວາຍ ກັອຍ ຕາ ເບີນ ຕະ ຕາປູ່ນ ປັຣນາຍ ເກົາ. ປັຣນາຍ ເຍືາ ຊັອງ ຊານໍ່, ປັຣນາຍ ໄນ່ ລາ ຕາ ແກີນ ປັຣນາຍ ເກົາ, ມາ ປັຣນາຍ ໄນ່ ລາ ປັຣນາຍ ອຶມປໍ່ ເກົາ ກາ ແປຣີ ໂອນ ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","\"ເກົາ ອາຕີ ອຶນແຍ່ະ ປັຣນາຍ ໄນ່ ບັອງ ກາ ເກົາ ອຶນນັ່ອງ ແອີດ ກະ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ມາ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ, ອັນ ກາ ອຶມປໍ່ ເກົາ ແປຣີ ຈ່ອຍ ເຍືາ ເຕ່ນ ເກົາ, ຣາເວືາຍ ກັອຍ ອາຕີ ເຍືາ ຕຸ່ກ ຣາມຶ່ຮ; ກະ ອັນ ຈ່ອຍ ໂອນ ເຍືາ ຊາແຍີ ອຶນແຍ່ະ ປັຣນາຍ ເກົາ ອາຕີ ເຍືາ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ເກົາ ໂອນ ຣາງຶ່ຮ ເຍືາ ເບີນ ອຽນ ອໍ. ເກົາ ໂອນ ເຍືາ ເບີນ ຣາງຶ່ຮ ອຽນ ອໍ ແຕ ເກົາ ເບີມ. ເກົາ ຕາ ເບີນ ໂອນ ມູເຈິງ ກວາຍ ຕຶ່ງ ແດີຍ ໄນ່ ໂອນ. ເຍືາ ອຶນໂຈຍ ໂອນ ຣາງຶ່ຮ ເຍືາ ຊັອງ ຕຸ່ຮ ອາຣຶ່ກ. ກະ ເຍືາ ອຶນໂຈຍ ອຶງກັອຮ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ເຍືາ ຊັອງ ເຈີ່ ເກົາ ປາຍ ເກົາ ອີ ເປາະ ແຕ ເຍືາ ມາ ປັຣແນີ ມັນເຕຣືາ ເກົາ ແຕີ່ອ໌ ລັ່ຮ ປໍ ເຍືາ ຊາ. ຄັນ ເຍືາ ມາ ອາໂຢ່ະ ເກົາ, ເຍືາ ຊັອງ ຣໍ່ອ໌ ເຕ່ ເກົາ ເບີນ ເຈົາ ປໍ ອຶມປໍ່ ເກົາ, ຍ່ອນ ອຶມປໍ່ ເກົາ ລາ ປື່ດ ແກຼີຍ ແຕ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ເກົາ ອາຕີ ເຍືາ ອຶນໂຍ່ງ ແຕ ຣານະ ໄນ່ ຕາ ຢວາຮ ແຕີ່ອ໌. ນ່ະກັອຍ ຕາໄງ ແລ່ະ ອັນ ແຕີ່ອ໌, ກັອຍ ແຕ ເຍືາ ຊາອຳ ປັຣນາຍ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ເກົາ ຕາ ເຕ່ອ໌ ອາຕີ ຊາອຶ່ຍ ນັ່ອງ ກະ ເຍືາ, ຍ່ອນ ເຢືາງ ກາ ຊົດ ຕຶ່ງ ກູແຕອ໌ ໄນ່, ອັນ ແຈ່ະ ອີ ແຕີ່ອ໌ ເຈີ່. ອັນ ກັອຍ ຕາ ເຕ່ອ໌ ຕາລາ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ມາ ເກົາ ຕະ ມັຮ ຣານະ ໄນ່ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ ດັງ ແຈງ ລາລື່ ປາຍ ເກົາ ອາໂຢ່ະ ອຶມປໍ່ ເກົາ. ກະ ເກົາ ຕະ ຕາປູ່ນ ອຶນແຍ່ະ ມັຮ ຣານະ ອຶມປໍ່ ເກົາ ປາຕັບ ເກົາ ເຈີ່. ຊານໍ່ ເຍືາ ຢວຣ ຕາຢຶ່ງ! ໄຮ ລັ່ອຮ ແຕ ອຶນໄນ່!\" ");
INSERT INTO ncq_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ເຢຊູ ປາຍ ແອັນ ນ່ະໄນ່: \"ເກົາ ລາ ວັ່ຣ ອາງຸ່ນ ກາ ປຍາຍ໌ ລາລື່. ກະ ອຶມປໍ່ ເກົາ ລາ ອັນ ກາ ຊາມາ ວັ່ຣ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ອາແບງ ອາແລ່ະ ກາ ຕາ ເບີນ ແກີດ ປາໄລ, ອັນ ກັຣໄປຮ ຕັຮ. ກະ ອາແບງ ອາແລ່ະ ມາ ແກີດ ປາໄລ, ອັນ ກິດ ໂອນ ປາດັອຮ ແກີດ ຊາອຶ່ຍ ແອັນ ອາແບງ ກັອຍ. ນ່ະກັອຍ ອາແບງ ກັອຍ ແກີດ ປາໄລ ຊາອຶ່ຍ ລາລື່ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ເຍືາ ລາ ນ່ະ ອາແບງ ກາ ເນົ່າ ກິດ ເຈີ່ ຍ່ອນ ແຕ ປັຣນາຍ ເກົາ ອາຕີ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ອຶງເຄາະ ເຍືາ ແອີດ ມູ ຣາງຶ່ຮ ເລືອຍໆ ກະ ເກົາ, ກະ ເກົາ ແອີດ ມູ ຣາງຶ່ຮ ເລືອຍໆ ກະ ເຍືາ. ຄັນ ອາແບງ ມາ ຕາ ເບີນ ຣາແຕັດ ກະ ວັ່ຣ ອັນ, ອັນ ຕາ ເຕ່ອ໌ ແກີດ ປາໄລ. ມູເຈິງ ກັອຍ ເຕ່, ຄັນ ເຍືາ ຕາ ເບີນ ແອີດ ມູ ຣາງຶ່ຮ ເລືອຍໆ ກະ ເກົາ, ເຍືາ ຕາ ເຕ່ອ໌ ແກີດ ປາໄລ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ເກົາ ລາ ວັ່ຣ ອາງຸ່ນ ມາ ເຍືາ ລາ ອາແບງ. ຄັນ ກວາຍ ອາແລ່ະ ມາ ແອີດ ມູ ຣາງຶ່ຮ ເລືອຍໆ ກະ ເກົາ, ກະ ເກົາ ແອີດ ມູ ຣາງຶ່ຮ ເລືອຍໆ ກະ ອັນ, ກວາຍ ກັອຍ ແກີດ ຊາອຶ່ຍ ປາໄລ. ຄັນ ເຍືາ ມາ ຊາກັຮ ແຕ ເກົາ, ເຍືາ ຕາ ເຕ່ອ໌ ຕະ ອຶນເຕົ່າ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ກວາຍ ອາແລ່ະ ກາ ຕາ ເບີນ ແອີດ ມູ ຣາງຶ່ຮ ເລືອຍໆ ກະ ເກົາ, ກວາຍ ກັອຍ ເນົ່າ ແກຼງ ຕັຮ ນ່ະ ເນົ່າ ແກຼງ ຕັຮ ອາແບງ ວັ່ຣ ເຕ່. ນ່ະກັອຍ ອາແບງ ກັອຍ ແກີດ ຣັ່ອຮ. ເຈີ່ ເນົ່າ ອີດ ອາແບງ ກັອຍ ແກຼງ ໂຈະ ຕຶ່ງ ອູ່ຍຮ ໂອນ ກາດ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ຄັນ ເຍືາ ແອີດ ມູ ຣາງຶ່ຮ ເລືອຍໆ ກະ ເກົາ, ກະ ປັຣນາຍ ເກົາ ແອີດ ເລືອຍໆ ຕຶ່ງ ຣາງຶ່ຮ ເຍືາ, ນ່ະກັອຍ ຣານະ ອຶນເຕົ່າ ເຍືາ ແຊອ໌, ເຍືາ ເບີນ ຣານະ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ຄັນ ເຍືາ ແກີດ ຊາອຶ່ຍ ປາໄລ, ເຍືາ ໂອນ ກວາຍ ການໍ່ອ໌ ດັງ ເຍືາ ຕາປູ່ນ ປັຣນາຍ ເກົາ, ກະ ເຍືາ ອາປັຮ ອຳນາດ ອາງອື່ຣ ແຕ ອຶມປໍ່ ເກົາ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","\"ເກົາ ອາໂຢ່ະ ເຍືາ ມູເຈິງ ອຶມປໍ່ ເກົາ ອາໂຢ່ະ ເກົາ ເຕ່. ອຶງເຄາະ ເຍືາ ຊາແຍີ ເລືອຍໆ ມັຮ ເກົາ ອາໂຢ່ະ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ຄັນ ເຍືາ ຕະ ຕາປູ່ນ ປັຣນາຍ ເກົາ ປາຕັບ, ເກົາ ອາໂຢ່ະ ເລືອຍໆ ເຍືາ, ມູເຈິງ ເກົາ ຕະ ຕາປູ່ນ ອຶນແຍ່ະ ມັຮ ປັຣນາຍ ອຶມປໍ່ ເກົາ ປາຕັບ ກະ ອຶມປໍ່ ອາໂຢ່ະ ເກົາ ເລືອຍໆ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ເກົາ ອາຕີ ໂອນ ເຍືາ ອຶນແຍ່ະ ມັຮ ຣາມຶ່ຮ ໄນ່ ໂອນ ເຍືາ ເບີນ ຣາງຶ່ຮ ຣໍ່ອ໌ ແຕ ເກົາ, ກະ ໂອນ ເຍືາ ເບີນ ແອີງ ຣາງຶ່ຮ ຣໍ່ອ໌ ໄນ່ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","\"ປັຣນາຍ ເກົາ ປາຕັບ ລາ ນ່ະໄນ່: ອຶງເຄາະ ເຍືາ ມານະ ອາໂຢ່ະ ມານະ ມູເຈິງ ເກົາ ອາໂຢ່ະ ເຍືາ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ຣານະ ອາໂຢ່ະ ປື່ດ ແກຼີຍ ອຶນແຍ່ະ ແຕ ການໍ່ອ໌ ລາ ເບີນ ມານະ ກູຈີດ ຕາງ ເຢົ່າ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ເຍືາ ລາ ເຢົ່າ ເກົາ, ຄັນ ເຍືາ ຕະ ຕາປູ່ນ ປັຣນາຍ ເກົາ ປາຕັບ. ");
INSERT INTO ncq_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ເກົາ ຕາ ເບີນ ດໍອ໌ ນັ່ອງ ເຍືາ ລາ ກວາຍ ທູແທ, ຍ່ອນ ກວາຍ ທູແທ ຕາ ເບີນ ດັງ ອຶນເຕົ່າ ອຶນເຈົາ ອັນ ອີ ຕະ. ມາ ເກົາ ດໍອ໌ ເຍືາ ລາ ເຢົ່າ ເກົາ, ຍ່ອນ ເກົາ ໂອນ ເຍືາ ດັງ ອຶນແຍ່ະ ມັຮ ຣາມຶ່ຮ ກາ ເກົາ ຊັອງ ແຕ ອຶມປໍ່ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ເຍືາ ຕາ ເບີນ ຣຽຮ ເກົາ, ມາ ເກົາ ຣຽຮ ເຍືາ. ກະ ເກົາ ຈົຮ ເຍືາ, ດໍອ໌ ໂອນ ເຍືາ ເປາະ ກະ ແກີດ ປາໄລ, ລາ ປາໄລ ຈອງ ກະ ອໍ ລາລື່. ນ່ະກັອຍ ອຶນເຕົ່າ ເຍືາ ແຊອ໌ ຍ່ອນ ຣາມຶ່ຮ ເກົາ, ອຶມປໍ່ ເກົາ ໂອນ ເຍືາ ເບີນ ອາກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ໄນ່ ລາ ປັຣນາຍ ເກົາ ປາຕັບ ເຍືາ: ອຶງເຄາະ ເຍືາ ມານະ ອາໂຢ່ະ ມານະ.\" ");
INSERT INTO ncq_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","\"ຄັນ ກວາຍ ຕຶ່ງ ແດີຍ ໄນ່ ມາ ຊາອັຣ ເຍືາ, ໂອນ ເຍືາ ດັງ ປາຍ ໄລ່ ຊາອັຣ ເກົາ ອຶນໂຍ່ງ ແຕ ເຍືາ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ຄັນ ເຍືາ ປຣ່ອມ ມູ ຣາງຶ່ຮ ກະ ກວາຍ ຕຶ່ງ ແດີຍ ໄນ່, ໄລ່ ກັອຍ ອາໂຢ່ະ ເຍືາ ນ່ະ ແຊມອາຍ ໄລ່ ເຕ່. ມາ ເກົາ ຣຽຮ ເຍືາ ເຈີ່ ແຕ ກວາຍ ກັອຍ. ກະ ເຍືາ ຕາ ເບີນ ປຣ່ອມ ມູ ຣາງຶ່ຮ ນັ່ອງ ກະ ໄລ່. ຍ່ອນ ນ່ະກັອຍ ແຕ ກວາຍ ກັອຍ ຊາອັຣ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ອຶງເຄາະ ເຍືາ ຊາແຍີ ປັຣນາຍ ເກົາ ອາຕີ ເຍືາ ປາຍ: 'ກວາຍ ຊູລ ຕາ ເບີນ ປື່ດ ກາເລີຍ ແຕ ອຶນເຈົາ ອັນ.' ຄັນ ເນົ່າ ມາ ຕະ ເກົາ, ປັຣແນີ ມັນເຕຣືາ ເນົ່າ ຕະ ເຕ່ ເຍືາ. ຄັນ ເນົ່າ ຊາງັດ ປັຣນາຍ ເກົາ, ປັຣແນີ ມັນເຕຣືາ ເນົ່າ ຊາງັດ ເຕ່ ປັຣນາຍ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ໄລ່ ຕະ ມັຮ ຣານະ ໄນ່ ໂຈະ ເຍືາ ລາ ຍ່ອນ ແຕ ເຍືາ ຊາອຳ ຣາມຶ່ຮ ເກົາ, ຍ່ອນ ໄລ່ ຕາ ເບີນ ດັງ ອັນ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ຄັນ ເກົາ ຕາ ເບີນ ເປາະ ອາຕີ ໄລ່, ໄລ່ ຕາ ເບີນ ເບີນ ໂລ່ຍຮ. ມາ ຊານໍ່ ໄລ່ ຕາ ເຕ່ອ໌ ຣາຈຽນ ປາຍ ໄລ່ ຕາ ເບີນ ໂລ່ຍຮ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ກວາຍ ອາແລ່ະ ກາ ຊາອັຣ ເກົາ, ລາ ອັນ ຊາອັຣ ກາ ອຶມປໍ່ ເກົາ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ຄັນ ເກົາ ຕາ ເບີນ ຕະ ຊາອຶ່ຍ ຣານະ ມັຮ ກວາຍ ການໍ່ອ໌ ຕາ ເຕ່ອ໌ ຕະ, ໄລ່ ຕາ ເບີນ ເບີນ ໂລ່ຍຮ. ມາ ຊານໍ່ ໄລ່ ເຮີມ ເຈີ່ ມັຮ ຣານະ ກັອຍ, ມາ ອຶນນັ່ອງ ໄລ່ ຊາອັຣ ເກົາ ກາ ອຶມປໍ່ ເກົາ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ມາ ຣານະ ໄນ່ ຣາປຍາຍ໌ ມັຮ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ປາຍ ແຕ ອຶມແບິ ນ່ະໄນ່: 'ເກົາ ຕາ ເບີນ ຕະ ໂລ່ຍຮ ອຶນເຕົ່າ, ມາ ໄລ່ ຈຸງ ຊາອັຣ ເກົາ.' ");
INSERT INTO ncq_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","\"ປັຣແນີ ມັນເຕຣືາ ອັນ ກາ ເກົາ ແປຣີ ແຕີ່ອ໌ ຈ່ອຍ ເຍືາ, ອັນ ແຕີ່ອ໌ ແຕ ອຶມປໍ່ ເກົາ. ອັນ ລາ ຣາເວືາຍ ປຍາຍ໌ ເລືອຍໆ, ກະ ອັນ ອາຕີ ແຕ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ມາ ເຍືາ ອຶງເຄາະ ອາຕີ ແຕ ເກົາ ເຕ່, ຍ່ອນ ເຍືາ ແອີດ ກະ ເກົາ ແຕ ຕາແບິ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","\"ເກົາ ອາຕີ ເຍືາ ອຶນແຍ່ະ ຣາມຶ່ຮ ໄນ່ ໂອນ ເຍືາ ຕາ ເບີນ ຊາປິ່ລ. ");
INSERT INTO ncq_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ປັຣແນີ ມັນເຕຣືາ ກວາຍ ອິດຊະຣາເອລ ຕູ່ຍຮ ອາລັ່ອຮ ເຍືາ ແຕ ດຸງ ຊາງ ໄລ່. ກະ ແຕີ່ອ໌ ຕາໄງ ກັອຍ ກວາຍ ກາ ກາຈີດ ເຍືາ, ໄລ່ ຄຶ່ດ ປາຍ ໄລ່ ຕະ ຣານະ ເຢືາງ ເຈົາຣາຊີ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ໄລ່ ຕະ ຣານະ ກັອຍ ຍ່ອນ ໄລ່ ຕາ ດັງ ອຶມປໍ່ ເກົາ, ກະ ຕາ ດັງ ເກົາ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ເກົາ ອາຕີ ເຍືາ ມັຮ ຣາມຶ່ຮ ໄນ່ ໂອນ ແຕີ່ອ໌ ຕາໄງ ຣາມຶ່ຮ ໄນ່ ແຕີ່ອ໌, ເຍືາ ຊາແຍີ ເກົາ ອາຕີ ເຈີ່ ເຍືາ. ແຕ ອຶນໂຍ່ງ ເກົາ ຕາ ເບີນ ຕຸ່ຮ ອາຕີ ເຍືາ ແຕ ມັຮ ຣາມຶ່ຮ ໄນ່, ຍ່ອນ ເກົາ ອຶນນັ່ອງ ແອີດ ກະ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","\"ມາ ຊານໍ່ ເກົາ ອີ ເຈົາ ລັ່ຮ ປໍ ອັນ ກາ ແປຣີ ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່. ມາ ອຶນນັ່ອງ ຕາ ເບີນ ເນົ່າ ແຕ ເຍືາ ຕາແບີບ ເກົາ ປາຍ: 'ປໍ ແລ່ະ ອາຈານ ອີ ເປາະ?' ");
INSERT INTO ncq_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ມາ ຍ່ອນ ເກົາ ອາຕີ ເຍືາ ມັຮ ຣາມຶ່ຮ ໄນ່, ເຍືາ ຊັອງ ຕຸ່ຮ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ມາ ຊານໍ່ ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ເກົາ ເປາະ ແຕ ເຍືາ, ລາ ແກີດ ເກືາ ໂອນ ເຍືາ. ຄັນ ເກົາ ຕາ ເບີນ ລັ່ອຮ ແຕ ເຍືາ, ອັນ ກາ ຈ່ອຍ ເຍືາ ຕາ ເຕ່ອ໌ ແຕີ່ອ໌ ປໍ ເຍືາ. ມາ ຄັນ ເກົາ ເປາະ, ເກົາ ອີ ແປຣີ ອັນ ໂອນ ແຕີ່ອ໌ ປໍ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ພໍກາ ອັນ ແຕີ່ອ໌, ອັນ ອາຕີ ອຶນແຍ່ະ ມັຮ ກວາຍ ໂອນ ໄລ່ ດັງ ແຈງ ລາລື່ ແຕ ຣານະ ໂລ່ຍຮ, ແຕ ຣານະ ຕານັ່ອງ ອໍ, ກະ ແຕ ຣານະ ຕັດຊີ່ນ. ");
INSERT INTO ncq_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ອັນ ອາຕີ ແຕ ຣານະ ໂລ່ຍຮ ໄນ່ ຍ່ອນ ກວາຍ ຕາ ເບີນ ຊາອຳ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ອັນ ອາຕີ ແຕ ຣານະ ຕານັ່ອງ ອໍ ຍ່ອນ ເກົາ ເຈົາ ປໍ ອຶມປໍ່ ເກົາ, ກະ ເຍືາ ຕາ ເບີນ ເຮີມ ເກົາ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ອັນ ອາຕີ ແຕ ຣານະ ຕັດຊີ່ນ ຍ່ອນ ເຢືາງ ເຈົາຣາຊີ ຕັດຊີ່ນ ເຈີ່ ເຢືາງ ກາ ຊົດ ຕຶ່ງ ກູແຕອ໌ ໄນ່, ກະ ເຢືາງ ກັອຍ ເປ່. ");
INSERT INTO ncq_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","\"ອຶນນັ່ອງ ເບີນ ຊາອຶ່ຍ ຣານະ ເກົາ ອີ ອາຕີ ເຍືາ, ມາ ຣານະ ກັອຍ ອຶນຕັອງ ລາລື່; ເຍືາ ຕາ ເຣືາບ ນັ່ອງ. ");
INSERT INTO ncq_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ມາ ພໍກາ ແຕີ່ອ໌ ຣາເວືາຍ ກາ ປຍາຍ໌ ລາລື່, ອັນ ອາໂຢ່ງ ເຍືາ ໂອນ ເຍືາ ດັງ ອຶນແຍ່ະ ຣານະ ປຍາຍ໌. ອັນ ຕາ ເບີນ ອາຕີ ແຕ ຣານະ ອັນ ເບີມ, ມາ ອັນ ອາຕີ ເຍືາ ມັຮ ຣານະ ອັນ ຊັອງ ເຈີ່. ກະ ອັນ ອາຕີ ເຍືາ ແຕ ຣານະ ຕາ ຢວາຮ ແຕີ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ອັນ ກັອຍ ອາປັຮ ອຳນາດ ອາງອື່ຣ ແຕ ເກົາ, ຍ່ອນ ອັນ ອີດ ປັຣນາຍ ແຕ ເກົາ, ກະ ອັນ ອາຕີ ລັ່ຮ ປັຣນາຍ ກັອຍ ໂອນ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ອຶນແຍ່ະ ມູ່ນ ອຶມປໍ່ ເກົາ ລາ ຄອງ ເກົາ ເຕ່. ນ່ະກັອຍ ເຕ່ອ໌ ເກົາ ປາຍ ລາ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ອີດ ປັຣນາຍ ເກົາ ກະ ອາຕີ ລັ່ຮ ໂອນ ເຍືາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","\"ຕາ ເບີນ ດູ່ນ ນັ່ອງ, ເຍືາ ຕາ ເບີນ ເຮີມ ນັ່ອງ ເກົາ. ເຈີ່ ແຕ ຕາໄງ ກັອຍ ຕາ ເບີນ ດູ່ນ ນັ່ອງ, ເຍືາ ເຮີມ ລັ່ຮ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ, ໄລ່ ມານະ ຕາແບີບ ມານະ ປາຍ: \"ອຶນເຕົ່າ ກາ ອັນ ປາຍ ກະ ໄຮ? ອັນ ປາຍ: 'ຕາ ເບີນ ດູ່ນ ນັ່ອງ ເຍືາ ຕາ ເບີນ ເຮີມ ນັ່ອງ ເກົາ. ເຈີ່ ແຕ ຕາໄງ ກັອຍ ຕາ ເບີນ ດູ່ນ ນັ່ອງ, ເຍືາ ເຮີມ ລັ່ຮ ເກົາ.' ກະ ອັນ ປາຍ: 'ຍ່ອນ ເກົາ ເຈົາ ປໍ ອຶມປໍ່ ເກົາ.' ");
INSERT INTO ncq_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ອຶນເຕົ່າ ອັນ ອີ ປາຍ ແຕ ປັຣນາຍ ໄນ່: 'ຕາ ເບີນ ດູ່ນ ນັ່ອງ'? ໄຮ ຕາ ເບີນ ດັງ ອຶນເຕົ່າ ເລີ່ຍ ອັນ ປາຍ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ເຢຊູ ດັງ ຣາງຶ່ຮ ໄລ່ ຢໍອ໌ ອີ ຕາແບີບ ອັນ. ນ່ະກັອຍ ອັນ ອາຕີ ໄລ່ ປາຍ: \"ເກົາ ອາຕີ ເຍືາ ເຈີ່: ຕາ ເບີນ ດູ່ນ ນັ່ອງ ເຍືາ ຕາ ເບີນ ເຮີມ ນັ່ອງ ເກົາ. ເຈີ່ ແຕ ຕາໄງ ກັອຍ ຕາ ເບີນ ດູ່ນ ນັ່ອງ ເຍືາ ເຮີມ ລັ່ຮ ເກົາ. ນານ່ະ ແຕ ເຍືາ ມານະ ຕາແບີບ ມານະ ແຕ ຣານະ ໄນ່? ");
INSERT INTO ncq_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ປັຣແນີ ມັນເຕຣືາ ເຍືາ ເຍືາມ ກະ ຣາງຶ່ຮ ເຍືາ ຊັອງ ຕຸ່ຮ, ມາ ກວາຍ ຕຶ່ງ ແດີຍ ໄນ່, ໄລ່ ຊັອງ ຣໍ່ອ໌ ບູຍ ລາລື່. ເຍືາ ຊັອງ ຕຸ່ຮ, ມາ ຣານະ ຕຸ່ຮ ກັອຍ ປຽນ ລັ່ຮ ໂອນ ເຍືາ ແກີດ ຣໍ່ອ໌ ບູຍ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ໄນ່ ລາ ນ່ະ ມັນແຊມ ຣັ່ຮ ກອນ ເຕ່. ບັອງ ກາ ກັອຍ ອັນ ຊັອງ ຕິ່ ລາລື່, ຍ່ອນ ແຕີ່ອ໌ ຄວບ ກູມໍ ເຈີ່. ມາ ແວັດ ອັນ ຣັ່ຮ ກອນ, ອັນ ຕາ ເບີນ ຊາແຍີ ນັ່ອງ ມັຮ ອັນ ຈີວ໌ ຕຸ່ຮ ກັ່ດ ກັອຍ. ອັນ ຊັອງ ຣໍ່ອ໌ ລາລື່ ຍ່ອນ ເບີນ ມານະ ແກີດ ຕຶ່ງ ກູແຕອ໌ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ເຍືາ ລາ ມູເຈິງ ກັອຍ ເຕ່. ຊານໍ່ ເຍືາ ຊັອງ ຕຸ່ຮ ລາລື່, ມາ ປັຣແນີ ມັນເຕຣືາ ເກົາ ເຮີມ ລັ່ຮ ເຍືາ. ຕາໄງ ກັອຍ ເຍືາ ຊັອງ ຣໍ່ອ໌ ບູຍ ລັ່ຮ, ກະ ຕາ ເບີນ ເນົ່າ ເຕ່ອ໌ ອີດ ຣານະ ຣໍ່ອ໌ ກັອຍ ແຕ ເຍືາ. ");
INSERT INTO ncq_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ຕຶ່ງ ຕາໄງ ກັອຍ, ເຍືາ ຕາ ເບີນ ຕາແບີບ ມວຍ ຣາມຶ່ຮ ອຶນເຕົ່າ ນັ່ອງ ແຕ ເກົາ. ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ເຍືາ, ອຶມປໍ່ ເກົາ ໂອນ ເຍືາ ເບີນ ຣາມຶ່ຮ ອຶນເຕົ່າ ເຍືາ ແຊອ໌ ຍ່ອນ ແຕ ຣາມຶ່ຮ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ເຕົ່າ ຊານໍ່ ເຍືາ ຕາ ເບີນ ແຊອ໌ ອຶນເຕົ່າ ຢວາຮ ຍ່ອນ ແຕ ຣາມຶ່ຮ ເກົາ. ອຶງເຄາະ ເຍືາ ແຊອ໌, ເຈີ່ ເຍືາ ເບີນ, ໂອນ ຣາງຶ່ຮ ເຍືາ ເບີນ ແອີງ ຣາມຶ່ຮ ຣໍ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","\"ເກົາ ອາຕີ ເຍືາ ມັຮ ຣານະ ໄນ່ ຣານາ ປັຣນາຍ ຊາກຳ. ມາ ປັຣແນີ ມັນເຕຣືາ ເກົາ ຕາ ເບີນ ອາຕີ ນັ່ອງ ຣານາ ປັຣນາຍ ຊາກຳ. ຕາໄງ ກັອຍ ເກົາ ອາຕີ ແຈງ ແອັນ ໂອນ ເຍືາ ດັງ ແຕ ອຶມປໍ່ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ຕຶ່ງ ຕາໄງ ກັອຍ ຣາມຶ່ຮ ອຶນເຕົ່າ ເຍືາ ແຊອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ, ເຍືາ ແຊອ໌ ຍ່ອນ ແຕ ຣາມຶ່ຮ ເກົາ. ເກົາ ຕາ ເບີນ ຕຸ່ຮ ແຊອ໌ ອຶນເຕົ່າ ນັ່ອງ ແຕ ອຶມປໍ່ ເກົາ ໂອນ ເຍືາ, ");
INSERT INTO ncq_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ຍ່ອນ ອຶມປໍ່ ເກົາ ອາໂຢ່ະ ເຕ່ ເຍືາ. ອຶມປໍ່ ເກົາ ອາໂຢ່ະ ເຍືາ ຍ່ອນ ເຍືາ ອາໂຢ່ະ ເກົາ ເຈີ່, ກະ ຍ່ອນ ເຍືາ ຊາອຳ ເກົາ ແຕີ່ອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ເກົາ ລັ່ອຮ ແຕ ອຶມປໍ່ ເກົາ ແຕ ຕາໄງ ເກົາ ແຕີ່ອ໌ ປໍ ກູແຕອ໌ ໄນ່. ເຈີ່ ຊານໍ່ ເກົາ ລັ່ອຮ ແຕ ກູແຕອ໌ ໄນ່ ເຈົາ ລັ່ຮ ປໍ ອຶມປໍ່ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ມູ່ ກາ ຣຍານ ແຕ ອັນ ປາຍ: \"ຊານໍ່ ອາຈານ ອາຕີ ແຈງ ລາລື່ ເຈີ່. ອາຈານ ຕາ ເບີນ ອາຕີ ນັ່ອງ ຕຶ່ງ ປັຣນາຍ ຊາກຳ. ");
INSERT INTO ncq_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ຊານໍ່ ຮິ ດັງ ເຈີ່ ອາຈານ ຊາປຸ່ຮ ກູ່ ຣາມຶ່ຮ. ກະ ຕາ ເບີນ ຕຸ່ຮ ເນົ່າ ຕາແບີບ ອຶນເຕົ່າ ນັ່ອງ ແຕ ອາຈານ. ຍ່ອນ ນ່ະກັອຍ, ຮິ ຊາອຳ ລາລື່ ອາຈານ ແຕີ່ອ໌ ແຕ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ເຢຊູ ຕາແບີບ ໄລ່ ປາຍ: \"ເມ່ນ ບໍ! ຊານໍ່ ເຍືາ ຊາອຳ ລາລື່ ບໍ? ");
INSERT INTO ncq_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ແຈ່ະ ອີ ແຕີ່ອ໌ ເຈີ່ ປາເນ່ນ ເຍືາ ອຶມປຣາຍຮ ອຶມປຣັງ ແກີດ ຣາຕັຮ ຣາຕາຍ໌ ແອີດ ດຸງ ອາແລ່ະ ດຸງ ອັນ. ເຈີ່ ເຍືາ ຕັຮ ດໍອ໌ ແອີງ ມານະ ເກົາ ຊັອງ. ມາ ເກົາ ຕາ ເບີນ ແອີດ ແອີງ ເກົາ ຊັອງ, ຍ່ອນ ອຶມປໍ່ ເກົາ ແອີດ ເລືອຍໆ ກະ ເກົາ. ມາ ປາເນ່ນ ກັອຍ ແຕີ່ອ໌ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ເກົາ ອາຕີ ເຍືາ ມັຮ ຣາມຶ່ຮ ໄນ່ ໂອນ ເຍືາ ເບີນ ອຽນ ອໍ ຍ່ອນ ເຍືາ ແອີດ ມູ ຣາງຶ່ຮ ກະ ເກົາ. ຕຶ່ງ ແດີຍ ໄນ່ ເຍືາ ຣາມົຮ ຊາອຶ່ຍ ຕຸ່ຮ ກັ່ດ. ມາ ອຶງເຄາະ ເຍືາ ແອີດ ໂອນ ຊາເບິງ ອໍ! ເກົາ ເຣືາບ ເຈີ່ ຕຶ່ງ ແດີຍ ໄນ່!\" ");
INSERT INTO ncq_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ອັນ ຕາເງີ່ອ໌ ອາຊັອຮ ປໍ ມັນລັ່ອງ ກະ ອັນ ປາຍ: \"ອຶມປໍ່ ເອີຍ! ປາເນ່ນ ເກົາ ແຕີ່ອ໌ ເຈີ່. ຊານໍ່ ເກົາ ແຊອ໌ ໄມ່ ອາປັຮ ອຳນາດ ອາງອື່ຣ ເກົາ ໂອນ ກວາຍ ການໍ່ອ໌ ດັງ, ໂອນ ເກົາ ເຕ່ອ໌ ອາປັຮ ລັ່ຮ ອຳນາດ ອາງອື່ຣ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ໄມ່ ໂອນ ເກົາ ເບີນ ຊົດ ກູ່ ນະ ກວາຍ ເຈີ່. ນ່ະກັອຍ ເຕ່ອ໌ ເກົາ ໂອນ ອາມົ່ງ ເລືອຍໆ ອຶນແຍ່ະ ມັຮ ກວາຍ ກາ ໄມ່ ມ່ອບ ໂອນ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ໄນ່ ລາ ແດີຍ ອາມົ່ງ ເລືອຍໆ: ກວາຍ ເບີນ ດັງ ໄມ່. ແອີງ ໄມ່ ແຕິ່ ລາ ເຢືາງ ກາ ປຍາຍ໌ ລາລື່. ກະ ໄລ່ ເບີນ ດັງ ເຢຊູ ກຣີດ, ອັນ ກາ ໄມ່ ແປຣີ ແຕີ່ອ໌ ປໍ ກູແຕອ໌ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ເກົາ ອາປັຮ ເຈີ່ ອຳນາດ ອາງອື່ຣ ໄມ່ ຕຶ່ງ ກູແຕອ໌ ໄນ່. ກະ ເກົາ ຕະ ອຶນແຍ່ະ ເຈີ່ ມັຮ ຣານະ ໄມ່ ແປຣີ ໂອນ ເກົາ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ອຶມປໍ່ ເອີຍ, ຊານໍ່ ເກົາ ອີ ເຈົາ ແອີດ ລັ່ຮ ປໍ ໄມ່. ເກົາ ແຊອ໌ ໄມ່ ໂອນ ເກົາ ເບີນ ອຳນາດ ອາງອື່ຣ ແອີດ ກະ ໄມ່, ມູເຈິງ ເກົາ ເບີນ ແຕ ໄມ່ ຕາ ຢວາຮ ແຕງ ກູແຕອ໌ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","\"ມັຮ ກວາຍ ກາ ໄມ່ ມ່ອບ ໂອນ ເກົາ ເບີນ ຕຶ່ງ ແດີຍ ໄນ່, ເກົາ ອາຕີ ເຈີ່ ໄລ່ ກັອຍ ແຕ ໄມ່. ໄລ່ ກັອຍ ລາ ກວາຍ ໄມ່; ໄມ່ ມ່ອບ ໄລ່ ກັອຍ ໂອນ ເກົາ. ກະ ໄລ່ ຕະ ຕາປູ່ນ ເຈີ່ ປັຣນາຍ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ຊານໍ່ ໄລ່ ກັອຍ ດັງ ແຈງ ເຈີ່ ມັຮ ຣາມຶ່ຮ ກາ ໄມ່ ໂອນ ປໍ ເກົາ ລາ ແຕີ່ອ໌ ແຕ ໄມ່ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ຍ່ອນ ເກົາ ອາຕີ ໂອນ ໄລ່ ເຈີ່ ມັຮ ປັຣນາຍ ໄມ່ ອາຕີ ໂອນ ເກົາ; ກະ ໄລ່ ຣັ່ບ ອຶນແຍ່ະ ປັຣນາຍ ກັອຍ. ໄລ່ ດັງ ແຈງ ລາລື່ ເຈີ່ ປາຍ ເກົາ ແຕີ່ອ໌ ແຕ ໄມ່, ກະ ໄລ່ ຊາອຳ ເຈີ່ ປາຍ ໄມ່ ກາ ແປຣີ ໂອນ ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","\"ເກົາ ເກົາແຊອ໌ ໂອນ ໄລ່ ກັອຍ; ຊານໍ່ ເກົາ ຕາ ເບີນ ເກົາແຊອ໌ ໂອນ ກວາຍ ຕຶ່ງ ແດີຍ ໄນ່, ມາ ເກົາ ເກົາແຊອ໌ ໂອນ ໄລ່ ກາ ໄມ່ ມ່ອບ ໂອນ ເກົາ, ຍ່ອນ ໄລ່ ກັອຍ ລາ ກວາຍ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ອຶນແຍ່ະ ມັຮ ມູ່ນ ເກົາ ລາ ມູ່ນ ໄມ່ ເຕ່, ກະ ອຶນແຍ່ະ ມັຮ ມູ່ນ ໄມ່ ລາ ມູ່ນ ເກົາ ເຕ່. ກວາຍ ການໍ່ອ໌ ເບີນ ຍ່ອງ ອຳນາດ ອາງອື່ຣ ເກົາ ຍ່ອນ ແຕ ໄລ່ ກັອຍ ຕາປູ່ນ ເກົາ. ");
INSERT INTO ncq_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ເກົາ ຕາ ເບີນ ແອີດ ນັ່ອງ ຕຶ່ງ ກູແຕອ໌ ໄນ່. ມາ ໄລ່ ກັອຍ ອຶນນັ່ອງ ແອີດ ຕຶ່ງ ກູແຕອ໌ ໄນ່. ກະ ເກົາ ອີ ເຈົາ ລັ່ຮ ປໍ ໄມ່. ອຶມປໍ່ ເອີຍ, ໄມ່ ລາ ແອິ ໂລ່ຍຮ! ເກົາ ແຊອ໌ ໄມ່ ກຍາອ໌ ປາຊິ ໄລ່ ຍ່ອນ ອຳນາດ ແຕ ຣາມຶ່ຮ ໄມ່. ຣາມຶ່ຮ ໄນ່ ລາ ຣາມຶ່ຮ ໄມ່ ໂອນ ປໍ ເກົາ ເຈີ່. ນ່ະກັອຍ ໄລ່ ເຕ່ອ໌ ແອີດ ມູ ຣາງຶ່ຮ, ມູເຈິງ ໄຮ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ບັອງ ເກົາ ອຶນນັ່ອງ ແອີດ ກະ ໄລ່, ເກົາ ກຍາອ໌ ປາຊິ ໄລ່ ຍ່ອນ ອຳນາດ ແຕ ຣາມຶ່ຮ ໄມ່, ລາ ຣາມຶ່ຮ ກາ ໄມ່ ໂອນ ປໍ ເກົາ. ເກົາ ກຍາອ໌ ໄລ່, ມາ ປິ່ດ ແອີງ ມານະ ຊັອງ. ກວາຍ ການໍ່ອ໌ ຕາ ເບີນ ອາແລ່ະ ປິ່ດ. ອັນ ກາ ປິ່ດ ໄນ່ ລາ ອັນ ກາ ເນົ່າ ນັ່ດ ດໍອ໌ ອຶງເຄາະ ເປາະ ປໍ ປຣຸ່ງ ອູ່ຍຮ ໂອນ ຣາປຍາຍ໌ ກະ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ແຕ ອຶມແບິ. ");
INSERT INTO ncq_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","\"ຊານໍ່ ເກົາ ເຈົາ ປໍ ໄມ່. ມາ ເກົາ ອາຕີ ອຶນແຍ່ະ ຣາມຶ່ຮ ໄນ່ ບັອງ ກາ ເກົາ ອຶນນັ່ອງ ແອີດ ຕຶ່ງ ແດີຍ ໄນ່, ໂອນ ມັຮ ກວາຍ ເບີນ ແອີງ ຣາງຶ່ຮ ຣໍ່ອ໌ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ເກົາ ອາຕີ ເຈີ່ ປັຣນາຍ ໄມ່ ໂອນ ໄລ່. ນ່ະກັອຍ ກວາຍ ຕຶ່ງ ແດີຍ ໄນ່ ຊາອັຣ ໄລ່, ຍ່ອນ ໄລ່ ຕາ ເບີນ ຕາປູ່ນ ຣານະ ຕຶ່ງ ແດີຍ ໄນ່, ມູເຈິງ ເກົາ ຕາ ເບີນ ຕາປູ່ນ ຣານະ ຕຶ່ງ ແດີຍ ໄນ່ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ເກົາ ຕາ ເບີນ ແຊອ໌ ໂອນ ໄມ່ ເດີງ ໄລ່ ລັ່ອຮ ແຕ ແດີຍ ໄນ່, ມາ ເກົາ ແຊອ໌ ໂອນ ໄມ່ ກຍາອ໌ ປາຊິ ໄລ່ ໂອນ ໄລ່ ແວັດ ແຕ ອາຕີ ເຢືາງ ຊາຕານ. ");
INSERT INTO ncq_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ໄລ່ ກັອຍ ຕາ ເບີນ ຕາປູ່ນ ຣານະ ຕຶ່ງ ແດີຍ ໄນ່ ມູເຈິງ ເກົາ ຕາ ເບີນ ຕາປູ່ນ ຣານະ ຕຶ່ງ ແດີຍ ໄນ່ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ປັຣນາຍ ໄມ່ ລາ ປັຣນາຍ ປຍາຍ໌ ລາລື່. ເກົາ ແຊອ໌ ໄມ່ ກາຢັ່ຮ ໄລ່ ແຕ ກວາຍ ຕຶ່ງ ແດີຍ ໄນ່ ຍ່ອນ ປັຣນາຍ ປຍາຍ໌ ແຕ ໄມ່. ");
INSERT INTO ncq_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ນ່ະ ໄມ່ ແປຣີ ເກົາ ແຕີ່ອ໌ ປໍ ກວາຍ ຕຶ່ງ ແດີຍ ໄນ່, ມູເຈິງ ກັອຍ ເຕ່ ເກົາ ແປຣີ ໄລ່ ກາ ຕາປູ່ນ ເກົາ ເປາະ ປໍ ກວາຍ ຕຶ່ງ ແດີຍ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ຍ່ອນ ແຕ ປັຣນາຍ ປຍາຍ໌ ໄມ່, ເກົາ ກາຢັ່ຮ ເບີມ ແຕ ມັຮ ຣານະ ຕຶ່ງ ແດີຍ ໄນ່. ເກົາ ຕະ ນ່ະກັອຍ ໂອນ ໄລ່ ກາ ຕາປູ່ນ ເກົາ ເຕ່ອ໌ ກາຢັ່ຮ ແຕ ມັຮ ຣານະ ຕຶ່ງ ແດີຍ ໄນ່, ກະ ເບີນ ມູ ຣາງຶ່ຮ ກະ ໄມ່ ມູເຈິງ ເກົາ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","\"ເກົາ ຕາ ເບີນ ເກົາແຊອ໌ ໂອນ ແອີງ ໄລ່ ໄນ່ ຊັອງ. ມາ ເກົາ ເກົາແຊອ໌ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ ກາ ຊາອຳ ເກົາ ຍ່ອນ ປັຣນາຍ ໄລ່ ໄນ່ ອາຕີ. ");
INSERT INTO ncq_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ເກົາ ແຊອ໌ ໂອນ ອຶນແຍ່ະ ນະ ໄລ່ ແອີດ ມູ ຣາງຶ່ຮ ຊັອງ, ມູເຈິງ ໄມ່ ແອີດ ມູ ຣາງຶ່ຮ ກະ ເກົາ, ກະ ເກົາ ແອີດ ມູ ຣາງຶ່ຮ ກະ ໄມ່. ກະ ເກົາ ແຊອ໌ ໂອນ ໄລ່ ແອີດ ມູ ຣາງຶ່ຮ ກະ ໄຮ ເຕ່. ນ່ະກັອຍ ກວາຍ ການໍ່ອ໌ ຕຶ່ງ ແດີຍ ໄນ່ ເຕ່ອ໌ ຊາອຳ ປາຍ ໄມ່ ແປຣີ ເກົາ ແຕີ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ເກົາ ໂອນ ໄລ່ ກັອຍ ເບີນ ອຳນາດ ອາງອື່ຣ ມູເຈິງ ໄມ່ ໂອນ ເກົາ ເບີນ ເຈີ່, ໂອນ ໄລ່ ເຕ່ອ໌ ແອີດ ມູ ຣາງຶ່ຮ ມູເຈິງ ໄຮ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ເກົາ ແອີດ ມູ ຣາງຶ່ຮ ກະ ໄລ່, ກະ ໄມ່ ແອີດ ມູ ຣາງຶ່ຮ ກະ ເກົາ. ນ່ະກັອຍ ໂອນ ອຶນແຍ່ະ ມັຮ ໄລ່ ແກີດ ມູ ຣາງຶ່ຮ ຊັອງ, ໂອນ ກວາຍ ຕຶ່ງ ແດີຍ ໄນ່ ດັງ ປາຍ ໄມ່ ແປຣີ ເກົາ ແຕີ່ອ໌ ປໍ ໄນ່, ກະ ໂອນ ໄລ່ ກັອຍ ດັງ ປາຍ ໄມ່ ອາໂຢ່ະ ໄລ່ ມູເຈິງ ໄມ່ ອາໂຢ່ະ ເກົາ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","\"ອຶມປໍ່ ເອີຍ! ມັຮ ໄລ່ ກາ ໄມ່ ມ່ອບ ໂອນ ເກົາ ເຈີ່, ອຶນຕຸ ແລ່ະ ເກົາ ແອີດ, ເກົາ ຢໍອ໌ ໄລ່ ກັອຍ ແອີດ ອຶນຕຸ ກັອຍ ເຕ່. ນ່ະກັອຍ ໄລ່ ເຕ່ອ໌ ເຮີມ ອຳນາດ ອາງອື່ຣ ແຕ ເກົາ, ລາ ອຳນາດ ໄມ່ ໂອນ ເກົາ ເບີນ ຍ່ອນ ໄມ່ ອາໂຢ່ະ ເກົາ ແຕ ໄມ່ ຕາ ຢວາຮ ແຕງ ມັນລັ່ອງ ກູແຕອ໌ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ອຶມປໍ່ ເອີຍ! ໄມ່ ລາ ຕານັ່ອງ ອໍ. ມັຮ ກວາຍ ຕຶ່ງ ແດີຍ ໄນ່ ໄລ່ ຕາ ເບີນ ດັງ ໄມ່. ມາ ເກົາ ດັງ ໄມ່, ກະ ໄລ່ ກາ ຕາປູ່ນ ເກົາ ດັງ ປາຍ ໄມ່ ແປຣີ ເກົາ ແຕີ່ອ໌. ");
INSERT INTO ncq_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ເກົາ ອາຕີ ໄລ່ ໂອນ ໄລ່ ດັງ ເຕ່ ໄມ່. ກະ ແຕ ໄນ່ ເຈີ່ ປໍ ເມືາງ, ເກົາ ອາຕີ ແອັນ ຣານະ ໄນ່ ໂອນ ໄມ່ ເຕ່ອ໌ ອາໂຢ່ະ ໄລ່ ກັອຍ ມູເຈິງ ໄມ່ ອາໂຢ່ະ ເກົາ ເຕ່, ກະ ໂອນ ເກົາ ເຕ່ອ໌ ແອີດ ມູ ຣາງຶ່ຮ ເລືອຍໆ ກະ ໄລ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ແວັດ ເຢຊູ ເກົາແຊອ໌ ນ່ະກັອຍ, ເຈີ່ ອັນ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ລັ່ອຮ ແຕ ອຶນຕຸ ກັອຍ. ເຈີ່ ໄລ່ ໄກ່ອ໌໌ ຢັ່ຮ ອຶນຕົ່ຮ ແດີອ໌ ຕູມ ກິດໂຣນ. ອຶນຕຸ ກັອຍ ເບີນ ຊວນ ອາໂປ່ນ. ເຈີ່ ເຢຊູ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ມູ່ດ ຕຶ່ງ ຊວນ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ຢູດາ, ອັນ ກາ ອີ ຈິ ເຢຊູ, ອັນ ດັງ ເຕ່ ອຶນຕຸ ກັອຍ, ຍ່ອນ ເຢຊູ ເກີ່ຍ ໂຣ່ມ ອຶນຕຸ ກັອຍ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ນ່ະກັອຍ ຢູດາ ອາໂຢ່ງ ມວຍ ຈຸ່ມ ຕາຮານ, ກະ ແລງ ແຕ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ກະ ກວາຍ ພາຣີຊາຍ ແຮີ, ເດີງ ໄລ່ ເປາະ ປໍ ຊວນ ກັອຍ. ໄລ່ ກັອຍ ຕາແຢອ໌ ເກຣີ່ງ ປຼາ, ຕາກຍາງ, ກະ ອາຣ່ຳ. ");
INSERT INTO ncq_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ເຢຊູ ດັງ ເຈີ່ ມັຮ ຣາມຶ່ຮ ກາ ອີ ແຕີ່ອ໌ ປໍ ອັນ. ນ່ະກັອຍ ອັນ ລັ່ອຮ ຕາແບີບ ໄລ່ ກັອຍ: \"ເນົ່າ ເຍືາ ຈໍ່ອ໌ ໄນ່?\" ");
INSERT INTO ncq_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ໄລ່ ຕາແອີຍ: \"ຮິ ຈໍ່ອ໌ ເຢຊູ, ອັນ ກາ ແຕ ວີ່ລ ນາຊາເຣັດ.\" ເຢຊູ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ເກົາ ໄນ່ ແຕິ່ ລາ ອັນ.\" ຢູດາ, ອັນ ກາ ມ່ອບ ເຢຊູ, ອັນ ຕາຢຶ່ງ ມັນຕຸ ກະ ໄລ່ ກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ພໍກາ ເຢຊູ ຕາແອີຍ: \"ເກົາ ໄນ່ ແຕິ່ ລາ ອັນ,\" ນ່ະກັອຍ ໄລ່ ກັອຍ ຕາລຸ່ຮ ປູພຣາອ໌; ເຈີ່ ຣາລຍາກ ໄລ່ ແດິມ ເລີ່ຍ ຕຶ່ງ ກູແຕອ໌. ");
INSERT INTO ncq_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ເຈີ່ ເຢຊູ ຕາແບີບ ລັ່ຮ ໄລ່ ປາຍ: \"ເນົ່າ ເຍືາ ຈໍ່ອ໌ ໄນ່?\" ໄລ່ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ຮິ ຈໍ່ອ໌ ເຢຊູ, ອັນ ກາ ແຕ ວີ່ລ ນາຊາເຣັດ.\" ");
INSERT INTO ncq_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ເຢຊູ ຕາແອີຍ ລັ່ຮ ໄລ່ ປາຍ: \"ເກົາ ອາຕີ ເຍືາ ເຈີ່, ເກົາ ໄນ່ ແຕິ່ ລາ ອັນ. ຄັນ ເຍືາ ຈໍ່ອ໌ ເກົາ, ເຍືາ ໂອນ ມູ່ ກາ ຣຍານ ແຕ ເກົາ ເປາະ ເວືາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ເຢຊູ ປາຍ ນ່ະກັອຍ ໂອນ ຣາປຍາຍ໌ ກະ ປັຣນາຍ ອັນ ປາຍ ແຕ ອຶນໂຍ່ງ ເຈີ່. ແຕ ອຶນໂຍ່ງ ອັນ ປາຍ: \"ອຶມປໍ່ ເອີຍ! ເກົາ ຕາ ເບີນ ໂອນ ປິ່ດ ອາແລ່ະ ແຕ ໄລ່ ກາ ໄມ່ ມ່ອບ ໂອນ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ຊີໂມນ ເປໂຕ ເບີນ ມວຍ ປຼາ ດາວ. ອັນ ທອດ ດາວ ແຕ ຊອຣ; ເຈີ່ ກັຣໄປຮ ຊູລ ອັນ ກາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ, ຕາອັອຮ ກູຕູຣ ຢັ່ຮ ອາຕ່ຳ. ຣາມຶ່ຮ ກວາຍ ຊູລ ກັອຍ ລາ ມາລະໂຄ. ");
INSERT INTO ncq_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ເຢຊູ ແປຣີ ເປໂຕ ປາຍ: \"ໄມ່ ໂຈະ ລັ່ຮ ດາວ ໄມ່ ຕຶ່ງ ຊອຣ! ໄກຣ ລາລື່ ເກົາ ອຶງເຄາະ ງ່ອຍ໌ ແຕ ຈອກ ກາ ອຶມປໍ່ ເກົາ ໂອນ ເກົາ ງ່ອຍ໌.\" ");
INSERT INTO ncq_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ບັອງ ກາ ກັອຍ ມູ່ ຕາຮານ ກະ ອັນ ກາ ຊົດ ໄລ່, ກະ ມັຮ ກາ ແລງ ກວາຍ ຊົດ ແຕ ຈຸ່ມ ອິດຊະຣາເອລ, ອຶນແຍ່ະ ໄລ່ ກັອຍ ໂກບ ເຢຊູ; ເຈີ່ ໄລ່ ຊັດ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ໄລ່ ເດີງ ເຢຊູ ແຕີ່ອ໌ ປໍ ອັນນາ, ກູຢາກູນ ກາຢະພາ. ຕຶ່ງ ກູມໍ ກັອຍ ກາຢະພາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ກາຢະພາ ໄນ່ ລາ ມານະ ກາ ອາຕີ ຈຸ່ມ ອິດຊະຣາເອລ ແຕ ອຶນໂຍ່ງ ປາຍ: \"ຄາອ໌ ໄຮ ໂອນ ມານະ ໄນ່ ຊັອງ ກູຈີດ ແຕ ອຶນແຍ່ະ ກວາຍ ໄຮ ກູຈີດ.\" ");
INSERT INTO ncq_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ຊີໂມນ ເປໂຕ ກະ ມານະ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ, ໄລ່ ບາຣ ນະ ປວາຍ ຕາປູ່ນ ກຣັອງ ເຢຊູ. ອັນ ກາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ, ອັນ ຊາກັ່ລ ມານະ ກັອຍ. ນ່ະກັອຍ ອັນ ໂອນ ມານະ ກາ ຣຍານ ກັອຍ ມູ່ດ ມັນຕຸ ກະ ເຢຊູ ຕຶ່ງ ຊັງອາຣ ອຶມແປຣ ດຸງ ອັນ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ມາ ເປໂຕ ແອີດ ຢັ່ຮ ນໍ່ອ໌ ງັ່ຮ ຕົ່ງ. ນ່ະກັອຍ ມານະ ກັອຍ ລົ່ບ ລັ່ຮ ປໍ ງັ່ຮ ຕົ່ງ, ກະ ອັນ ແຊອ໌ ແຕ ມັນແຊມ ກາ ກຍາອ໌ ງັ່ຮ ຕົ່ງ ໂອນ ເປໂຕ ມູ່ດ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ມັນແຊມ ກາ ກຍາອ໌ ກູຕົ່ງ ກັອຍ ຕາແບີບ ເປໂຕ: \"ໄມ່ ລາ ມູ່ ກາ ຣຍານ ແຕ ກວາຍ ກັອຍ ບໍ?\" ເປໂຕ ຕາແອີຍ: \"ເກົາ ຕາ ເບີນ ແຕ ມູ່ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ມັຮ ກວາຍ ຕະ ຣານະ ກະ ກວາຍ ຕາຮານ ແອີດ ອຶນຕຸ ກັອຍ, ໄລ່ ຊັອງ ຊາແງດ. ນ່ະກັອຍ ໄລ່ ຍຸ່ ອູ່ຍຮ; ເຈີ່ ໄລ່ ອຶງແຮງ. ເປໂຕ ຕາຢຶ່ງ ອຶງແຮງ ອູ່ຍຮ ກະ ໄລ່ ກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ອັນ ກາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ ຕາແບີບ ເຢຊູ ແຕ ມູ່ ກາ ຣຍານ ແຕ ອັນ, ກະ ແຕ ປັຣນາຍ ອັນ ອາຕີ. ");
INSERT INTO ncq_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ເຢຊູ ຕາແອີຍ ປາຍ: \"ເກົາ ອາຕີ ແຈງ ເຈີ່ ໂອນ ອຶນແຍ່ະ ມັຮ ກວາຍ ດັງ. ເກົາ ອາຕີ ເລືອຍໆ ຕຶ່ງ ດຸງ ຊາງ ແກດ ກະ ຕຶ່ງ ດຸງ ຊາງ ປື່ດ ປໍ ອຶນຕຸ ອຶນແຍ່ະ ມັຮ ກວາຍ ອິດຊະຣາເອລ ໂຣ່ມ. ເກົາ ຕາ ເບີນ ປາໂຕ່ະ ມູ ຣາມຶ່ຮ ອຶນເຕົ່າ ມັຮ ປັຣນາຍ ເກົາ ອາຕີ. ");
INSERT INTO ncq_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ນ່ະກັອຍ ນານ່ະ ແຕ ເຍືາ ຕາແບີບ ເກົາ? ຄາອ໌ ເຍືາ ຕາແບີບ ໄລ່ ກາ ຊັອງ ປັຣນາຍ ເກົາ ອາຕີ. ໄລ່ ດັງ ອຶນແຍ່ະ ມັຮ ກາ ເກົາ ປາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ເບີນ ແລງ ກວາຍ ຊົດ ກັອຍ ຕັ່ຮ ເຢຊູ ກະ ປາຍ: \"ອຶນເຕົ່າ ໄມ່ ປາຍ ຕະ ນ່ະກັອຍ ຢັ່ຮ ເມືາງ ອັນ ກາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ?\" ");
INSERT INTO ncq_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ເຢຊູ ຕາແອີຍ ອັນ ກັອຍ ປາຍ: \"ຄັນ ເກົາ ປາຍ ຕາ ປຍາຍ໌, ອໍ ໄມ່ ອາຕີ ເກົາ. ມາ ຄັນ ເກົາ ປາຍ ປຍາຍ໌, ນານ່ະ ແຕ ໄມ່ ຕັ່ຮ ເກົາ?\" ");
INSERT INTO ncq_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ແວັດ ກັອຍ ອັນນາ ແປຣີ ເນົ່າ ເດີງ ເຢຊູ ມ່ອບ ປໍ ກາຢະພາ, ອັນ ກາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ. ມາ ເຢຊູ, ອຶນນັ່ອງ ໄລ່ ຊັດ ດໍອ໌ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ເປໂຕ ອຶນນັ່ອງ ຕາຢຶ່ງ ອຶງແຮງ ອູ່ຍຮ. ກວາຍ ການໍ່ອ໌ ກັອຍ ຕາແບີບ ເປໂຕ: \"ໄມ່ ລາ ມູ່ ກາ ຣຍານ ແຕ ອັນ ກັອຍ ບໍ?\" ເປໂຕ ກາແລີຍຮ ເຢຊູ, ປາຍ: \"ເກົາ ຕາ ແກີນ ແຕ ມູ່ ກັອຍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ເບີນ ມານະ ກວາຍ ຊູລ ອັນ ກາ ຕາລາ ອຶນແຍ່ະ ແຕ ຣີ່ດ ຊາງ ເຢືາງ ເຈົາຣາຊີ ແອີດ ອຶນຕຸ ກັອຍ ເຕ່. ກວາຍ ຊູລ ກັອຍ ລາ ແຊມອາຍ ກະ ກວາຍ ກາ ເປໂຕ ກັຣໄປຮ ກູຕູຣ. ກວາຍ ຊູລ ກັອຍ ຕາແບີບ ເປໂຕ ປາຍ: \"ປຍາຍ໌ ມາ ຕາ ເບີນ, ເກົາ ເຮີມ ໄມ່ ແອີດ ຕຶ່ງ ຊວນ ກະ ອັນ ກັອຍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ມາ ເປໂຕ ກາແລີຍຮ ຊາ ເຢຊູ. ບັອງ ກາ ກັອຍ ແຕິ່ ອຶນຕຣວຍ ຕາກາຣ. ");
INSERT INTO ncq_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ແວັດ ກັອຍ, ແຕ ປຼື່ ຕາຣື່ບ ກັອຍ, ໄລ່ ເດີງ ເຢຊູ ແຕ ດຸງ ກາຢະພາ ເປາະ ປໍ ອຶນຕຸ ເນົ່າ ຕັດຊີ່ນ ກວາຍ. ມາ ກວາຍ ອິດຊະຣາເອລ ຕາ ແອອ໌ ອີ ມູ່ດ ຕຶ່ງ ອຶນຕຸ ເນົ່າ ຕັດຊີ່ນ, ຍ່ອນ ໄລ່ ຕັນ ຄັນ ໄລ່ ມູ່ດ ຕຶ່ງ ກັອຍ ແຕ ອຶນໂຍ່ງ ໄລ່ ຕາ ຢວາຮ ຈາ ຊາແຍີ ຕາໄງ ອາກຼັຮ. ");
INSERT INTO ncq_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ຍ່ອນ ຈຸ່ມ ອິດຊະຣາເອລ ຕາ ແອອ໌ ອີ ມູ່ດ ອຶນຕຸ ເນົ່າ ຕັດຊີ່ນ ກັອຍ, ນ່ະກັອຍ ປີລາດ, ອັນ ກາ ແກີດ ຊົດ, ລັ່ອຮ ປໍ ໄລ່. ອັນ ຕາແບີບ ໄລ່ ກັອຍ ປາຍ: \"ຍ່ອນ ຣານະ ອຶນເຕົ່າ ແຕ ເຍືາ ປ່ອງ ອັນ ໄນ່?\" ");
INSERT INTO ncq_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ໄລ່ ຕາແອີຍ ປາຍ: \"ຄັນ ອັນ ໄນ່ ຕາ ເບີນ ກູເກາະ ອຶນເຕົ່າ, ຮິ ຕາ ເບີນ ເດີງ ອັນ ແຕີ່ອ໌ ປໍ ອາຈວາຍຮ.\" ");
INSERT INTO ncq_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ປີລາດ ອາຕີ ລັ່ຮ ໄລ່ ປາຍ: \"ອຶງເຄາະ ເຍືາ ເດີງ ລັ່ຮ ອັນ; ເຈີ່ ເຍືາ ຕັດຊີ່ນ ອັນ ຕາປູ່ນ ຣີ່ດ ເຍືາ ເບີມ.\" ມາ ກວາຍ ອິດຊະຣາເອລ ກັອຍ ຕາແອີຍ ປາຍ: \"ຮິ ເນົ່າ ຕາ ໂອນ ກາຈີດ ກວາຍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ນ່ະກັອຍ ແກີດ ຣາປຍາຍ໌ ກະ ປັຣນາຍ ເຢຊູ ອາຕີ ແຕ ອຶນໂຍ່ງ ເຈີ່. ອັນ ອາຕີ ແຕ ຣານາ ອັນ ອຶງເຄາະ ຈີວ໌ ກູຈີດ. ");
INSERT INTO ncq_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ແວັດ ກັອຍ ປີລາດ ມູ່ດ ລັ່ຮ ປໍ ດຸງ, ກະ ອັນ ກູອ໌ ເຢຊູ. ອັນ ຕາແບີບ ເຢຊູ ປາຍ: \"ໄມ່ ລາ ເຕືາວ ປັຣເຍືາ ຈຸ່ມ ອິດຊະຣາເອລ ເມ່ນ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ເຈີ່ ເຢຊູ ຕາແບີບ ລັ່ຮ ອັນ ປາຍ: \"ຣານະ ໄນ່ ໄມ່ ອຶນຈຸງ ອີ ປາຍ, ແຕີລາ ກວາຍ ການໍ່ອ໌ ອາຕີ ໂອນ ໄມ່ ດັງ ແຕ ເກົາ?\" ");
INSERT INTO ncq_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ປີລາດ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ເກົາ ຕາ ເບີນ ດັງ! ເກົາ ລາ ຕາ ແກີນ ກວາຍ ອິດຊະຣາເອລ. ກວາຍ ໄມ່ ກະ ກວາຍ ຊົດ ກາ ຊາງ ຣີ່ດ ຕຶ່ງ ກຣວາງ ໄມ່, ໄລ່ ກັອຍ ເດີງ ໄມ່ ແຕີ່ອ໌ ປໍ ເກົາ. ອຶນເຕົ່າ ໄມ່ ຕະ ໂລ່ຍຮ?\" ");
INSERT INTO ncq_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ເຢຊູ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ເກົາ ຕະ ຊົດ ລາ ຕາ ແກີນ ຕຶ່ງ ແດີຍ ໄນ່. ຄັນ ເກົາ ຕະ ຊົດ ຕຶ່ງ ແດີຍ ໄນ່, ກອນແຊມ ເກົາ ຣາຊູ່ ເຕ່ ກະ ມັຮ ກວາຍ ຊົດ ອິດຊະຣາເອລ ໂອນ ໄລ່ ຕາ ເຕ່ອ໌ ເບີນ ໂກບ ເກົາ. ມາ ອຳນາດ ເກົາ ເບີນ ຊານໍ່ ລາ ຕາ ແກີນ ຕຶ່ງ ແດີຍ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ປີລາດ ຕາແບີບ ລັ່ຮ: \"ນ່ະກັອຍ ໄມ່ ລາ ເຕືາວ ປັຣເຍືາ ບໍ?\" ເຢຊູ ຕາແອີຍ ປາຍ: \"ປຍາຍ໌ ນ່ະ ໄມ່ ປາຍ, ເກົາ ລາ ເຕືາວ ປັຣເຍືາ. ເກົາ ແກີດ ກວາຍ ຕຶ່ງ ແດີຍ ໄນ່ ລາ ອີ ອາຕີ ແຕ ຣານະ ປຍາຍ໌. ກວາຍ ອາແລ່ະ ກາ ເບີນ ມູ ຣາງຶ່ຮ ກະ ຣານະ ປຍາຍ໌, ກວາຍ ກັອຍ ຊາງັດ ປັຣນາຍ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ປີລາດ ຕາແບີບ ລັ່ຮ: \"ອຶນເຕົ່າ ຣານະ ປຍາຍ໌ ກັອຍ?\" ແວັດ ປີລາດ ປາຍ ນ່ະກັອຍ, ອັນ ລັ່ອຮ ແຕ ດຸງ ເປາະ ລັ່ຮ ປໍ ກວາຍ ອິດຊະຣາເອລ. ອັນ ອາຕີ ໄລ່ ປາຍ: \"ເກົາ ຕາ ເບີນ ຣາມົຮ ມວຍ ຣາມຶ່ຮ ໂລ່ຍຮ ອຶນເຕົ່າ ແຕ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ມາ ແຕີ່ອ໌ ຕາໄງ ເຍືາ ຈາ ຊາແຍີ ກັອຍ, ເຍືາ ເບີນ ຣີ່ດ ຣຽຮ ມານະ ກວາຍ ເນົ່າ ໂກບ ດໍອ໌ ຕຶ່ງ ກໍ່ອ໌ ໂອນ ເກົາ ອາໂຣຍຮ. ນ່ະກັອຍ ເຍືາ ໂອນ ເກົາ ອາໂຣຍຮ ເຕືາວ ປັຣເຍືາ ຈຸ່ມ ອິດຊະຣາເອລ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ໄລ່ ຣັ່ບ ແບອ໌ ປີລາດ ເຣ່ງ ລາລື່: \"ອຶນໂຈຍ ອາໂຣຍຮ ອັນ! ອາໂຣຍຮ ບາຣາບາ!\" ບາຣາບາ ໄນ່ ລາ ມານະ ແຕ ມູ່ ກາ ຕຳໂປຣ ອີ ຕະ ຊົດ. ");
INSERT INTO ncq_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ແວັດ ກັອຍ ປີລາດ ກູອ໌ ລັ່ຮ ເຢຊູ, ເຈີ່ ອັນ ແປຣີ ໂອນ ເນົ່າ ໄປຣ່ຮ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ກວາຍ ຕາຮານ ຕະ ກຸນຕຣວາອ໌ ຊັຣເລືາ ອາປື່ງ ຕຶ່ງ ແປຼີ ເຢຊູ. ກະ ໄລ່ ອາແຊິບ ເຢຊູ ອາຢັ່ອຮ ຕີ່ ຊີ່ ອາອູຍ. ");
INSERT INTO ncq_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ເຈີ່ ໄລ່ ແຕີ່ອ໌ ແຈ່ະ ເຢຊູ ປາຍ ອັນ ນ່ະໄນ່: \"ກູກຸຮ ເນົ່າ ຊາຊາຍ ເຕືາວ ປັຣເຍືາ ອິດຊະຣາເອລ!\" ກະ ໄລ່ ຕັ່ຮ ມາມ ອັນ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ປີລາດ ລັ່ອຮ ລັ່ຮ ຊາ ປໍ ກວາຍ ອິດຊະຣາເອລ, ກະ ອັນ ອາຕີ ໄລ່ ປາຍ: \"ເນ່ ໄນ່! ເກົາ ເດີງ ອາລັ່ອຮ ອັນ ໄນ່ ແຕີ່ອ໌ ປໍ ເຍືາ, ໂອນ ເຍືາ ດັງ ປາຍ ເກົາ ຕາ ເບີນ ຣາມົຮ ມວຍ ຣາມຶ່ຮ ໂລ່ຍຮ ອຶນເຕົ່າ ແຕ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ພໍກາ ເຢຊູ ລັ່ອຮ, ອັນ ອຶນນັ່ອງ ຕາປື່ງ ກຸນຕຣວາອ໌ ຊັຣເລືາ, ກະ ແຊິບ ອາຢັ່ອຮ ຕີ່ ຊີ່ ອາອູຍ. ປີລາດ ອາຕີ ໂຈະ ກວາຍ ກຼຶ່ງ ກັອຍ ປາຍ: \"ເຍືາ ເນ່ ກວາຍ ໄນ່!\" ");
INSERT INTO ncq_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ພໍກາ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ, ກະ ມັຮ ກາ ແລງ ແຕ ດຸງ ຊາງ ປື່ດ ເຮີມ ເຢຊູ, ອຶນແຍ່ະ ມັຮ ໄລ່ ປາຍ ເຣ່ງ ລາລື່: \"ແຕັຮ ອັນ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ! ແຕັຮ ອັນ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ!\" ມາ ປີລາດ ປາຍ ໂຈະ ໄລ່: \"ເອົາ ເຍືາ ເດີງ ແຕັຮ ອັນ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ! ມາ ເກົາ ຕາ ເບີນ ຣາມົຮ ມວຍ ຣາມຶ່ຮ ໂລ່ຍຮ ອຶນເຕົ່າ ແຕ ອັນ!\" ");
INSERT INTO ncq_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ມັຮ ກວາຍ ຊົດ ອິດຊະຣາເອລ ກັອຍ ຕາແອີຍ ລັ່ຮ ປາຍ: \"ຕາປູ່ນ ຄານອດ ຮິ, ອັນ ກັອຍ ອຶງເຄາະ ກູຈີດ, ຍ່ອນ ອັນ ປາຍ ອັນ ລາ ກອນ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ພໍກາ ປີລາດ ຊັອງ ປັຣນາຍ ກັອຍ, ຣາງຶ່ຮ ອັນ ເກຣ່າະ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ອັນ ມູ່ດ ລັ່ຮ ຕຶ່ງ ດຸງ ຕັດຊີ່ນ ກັອຍ, ເຈີ່ ອັນ ຕາແບີບ ເຢຊູ ປາຍ: \"ແຕ ແລ່ະ ໄມ່ ແຕີ່ອ໌?\" ມາ ເຢຊູ ຕາ ເບີນ ຕາແອີຍ ອຶນເຕົ່າ. ");
INSERT INTO ncq_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ປີລາດ ປາຍ: \"ນານ່ະ ໄມ່ ຕາ ເບີນ ຕາແອີຍ ເກົາ? ໄມ່ ດັງ ມາ ຕາ ເບີນ, ເກົາ ເບີນ ອຳນາດ ອາໂຣຍຮ ໄມ່, ແຕີລາ ແຕັຮ ໄມ່ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ?\" ");
INSERT INTO ncq_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ເຢຊູ ຕາແອີຍ ອັນ ປາຍ: \"ຄັນ ເຢືາງ ເຈົາຣາຊີ ຕາ ເບີນ ໂອນ, ໄມ່ ຕາ ເຕ່ອ໌ ຕະ ອຶນເຕົ່າ ໂຈະ ເກົາ. ນ່ະກັອຍ, ອັນ ກາ ມ່ອບ ເກົາ ແຕີ່ອ໌ ປໍ ໄມ່, ອັນ ກັອຍ ເບີນ ໂລ່ຍຮ ກາເລີຍ ແຕ ໄມ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ແວັດ ປີລາດ ຊັອງ ນ່ະກັອຍ, ອັນ ຈໍ່ອ໌ ຣານາ ຢໍອ໌ ອີ ອາໂຣຍຮ ເຢຊູ. ມາ ມັຮ ກວາຍ ຊົດ ອິດຊະຣາເອລ, ໄລ່ ປາຍ ເຣ່ງ ລາລື່ ລັ່ຮ: \"ຄັນ ອາຈວາຍຮ ອາໂຣຍຮ ກວາຍ ໄນ່, ອາຈວາຍຮ ຕາ ເບີນ ຣາຕອຍ ນັ່ອງ ກະ ເຕືາວ ປັຣເຍືາ ໂຣມ ກາ ກຣິ່ຮ. ກວາຍ ອາແລ່ະ ກາ ປາຍ ອັນ ລາ ເຕືາວ ປັຣເຍືາ, ມາຮ ອັນ ຣາຊູ່ ກະ ເຕືາວ ປັຣເຍືາ ໂຣມ ກາ ກຣິ່ຮ ເຈີ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ພໍກາ ປີລາດ ຊັອງ ປັຣນາຍ ກັອຍ, ອັນ ເດີງ ອາລັ່ອຮ ເຢຊູ ກະ ອັນ ຕາກູ ຕຶ່ງ ກາເຈີ່ງ ເນົ່າ ຕັດຊີ່ນ. ກາເຈີ່ງ ກັອຍ ລາ ແອີດ ຕຶ່ງ ອຶນຕຸ ເນົ່າ ດໍອ໌ 'ຊັງອາຣ ຕາເມົາ', ມາ ຕຶ່ງ ປັຣນາຍ ອິດຊະຣາເອລ ໄລ່ ດໍອ໌ ອຶນຕຸ ກັອຍ ລາ 'ຄັບບາທາ.' ");
INSERT INTO ncq_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ບັອງ ກາ ກັອຍ ມານາງ ແຈ່ະ ຕີລມູ່ລ ຕຶ່ງ ຕາໄງ ກວາຍ ອິດຊະຣາເອລ ກຽມ ດໍອ໌ ຈາ ຊາແຍີ ຕາໄງ ອາກຼັຮ. ປີລາດ ອາຕີ ກວາຍ ອິດຊະຣາເອລ: \"ໄນ່ ລາ ເຕືາວ ປັຣເຍືາ ເຍືາ!\" ");
INSERT INTO ncq_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ມາ ມັຮ ກວາຍ ກັອຍ ປາຍ ລັ່ຮ ເຣ່ງ ລາລື່: \"ເດີງ ອັນ ເປາະ! ເດີງ ອັນ ເປາະ! ແຕັຮ ອັນ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ!\" ປີລາດ ຕາແບີບ ລັ່ຮ ໄລ່: \"ເຍືາ ໂອນ ເກົາ ແຕັຮ ເຕືາວ ປັຣເຍືາ ເຍືາ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ ບໍ?\" ມາ ໄລ່ ກາ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ຕາແອີຍ ປາຍ: \"ອັນ ຕາ ແກີນ ເຕືາວ ປັຣເຍືາ ຮິ! ເຕືາວ ປັຣເຍືາ ຮິ ລາ ແອີງ ເຕືາວ ປັຣເຍືາ ໂຣມ ກາ ກຣິ່ຮ ຊັອງ!\" ");
INSERT INTO ncq_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ແວັດ ກັອຍ ປີລາດ ມ່ອບ ເຢຊູ ປໍ ອາຕີ ໄລ່ ກັອຍ ໂອນ ໄລ່ ແຕັຮ ອັນ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ. ເຈີ່ ຕາຮານ ເດີງ ເຢຊູ ລັ່ອຮ ແຕ ອຶນຕຸ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ເຢຊູ ລັ່ອຮ ແຕ ກັອຍ, ເຈີ່ ອັນ ໂດລ ເບີມ ອາລ່ອງ ຊັງກັງ ອັນ. ອັນ ແຕີ່ອ໌ ປໍ ອຶນຕຸ ເນົ່າ ດໍອ໌ \"ອຶນຕຸ ອຶງຮາງ ຕາຕາຣ ແປຼີ.\" ຕຶ່ງ ປັຣນາຍ ອິດຊະຣາເອລ ເນົ່າ ດໍອ໌ ອຶນຕຸ ກັອຍ ລາ \"ໂຄລະໂຄທາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ຕຶ່ງ ອຶນຕຸ ກັອຍ ເນົ່າ ແຕັຮ ເຢຊູ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ. ເບີນ ບາຣ ນະ ການໍ່ອ໌ ແຮີ ເນົ່າ ແຕັຮ ອຶງກັອຍ ເຕ່, ມານະ ຢັ່ຮ ອາເວ່ຣ ມານະ ຢັ່ຮ ອາຕ່ຳ ເຢຊູ. ເຢຊູ ແອີດ ອຶນດີ ໄລ່ ບາຣ ນະ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ປີລາດ ຄຽນ ຕຶ່ງ ມວຍ ແພນ ກາດານ, ເຈີ່ ແຕັຮ ຕາຢັອງ ດໍອ໌ ແພນ ກັອຍ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ ເຢຊູ. ອັນ ຄຽນ ປາຍ ຕຶ່ງ ແພນ ກັອຍ: \"ເຢຊູ, ກວາຍ ແຕ ວີ່ລ ນາຊາເຣັດ. ອັນ ລາ ເຕືາວ ປັຣເຍືາ ກວາຍ ອິດຊະຣາເອລ.\" ");
INSERT INTO ncq_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ກຼຶ່ງ ກວາຍ ອິດຊະຣາເອລ ອານ ແພນ ໄນ່, ຍ່ອນ ອຶນຕຸ ໄລ່ ກາຈີດ ເຢຊູ ລາ ແຈ່ະ ກະ ເມືອງ. ກະ ເນົ່າ ຄຽນ ຕຶ່ງ ແພນ ໄນ່ ໄປ ປັຣນາຍ: ປັຣນາຍ ອິດຊະຣາເອລ, ປັຣນາຍ ໂຣມ, ກະ ປັຣນາຍ ກຣີກ. ");
INSERT INTO ncq_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ມາ ມັຮ ກວາຍ ຊົດ ມູ່ ກາ ຊາງ ຣີ່ດ ເຢືາງ ເຈົາຣາຊີ ແຕ ຈຸ່ມ ອິດຊະຣາເອລ, ໄລ່ ອາຕີ ປີລາດ ປາຍ: \"ອຶນໂຈຍ ຄຽນ ປາຍ 'ອັນ ລາ ເຕືາວ ປັຣເຍືາ ກວາຍ ອິດຊະຣາເອລ.' ປຍາຍ໌ ລາລື່ ໄມ່ ຄຽນ ປາຍ 'ອັນ ກັອຍ ປາຍ ອັນ ລາ ເຕືາວ ປັຣເຍືາ ກວາຍ ອິດຊະຣາເອລ.'\" ");
INSERT INTO ncq_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ມາ ປີລາດ ປາຍ ລັ່ຮ ໂຈະ ໄລ່ ກັອຍ: \"ເກົາ ຄຽນ ແວັດ ເຈີ່ ປັຣນາຍ ໄນ່. ຈ່ຳ ອີ ອາຕຶ່ ນັ່ອງ.\" ");
INSERT INTO ncq_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ແວັດ ກວາຍ ຕາຮານ ແຕັຮ ເຢຊູ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ, ໄລ່ ອີດ ຕຳປັອກ ອັນ, ກະ ໄລ່ ອຶມແປອ໌ ປູນ ປູ່ດ, ມານະ ມວຍ ປູ່ດ. ກະ ໄລ່ ອີດ ອາຢັ່ອຮ ຕີ່ ເຢຊູ ແຮີ. ອາຢັ່ອຮ ໄນ່ ເນົ່າ ຕານ ມວຍ ໄຊອ໌ ຊັອງ, ຕາ ເບີນ ຊັນຕີ່ຮ ອຶນເຕົ່າ ແຕ ແປີງ ແຕີ່ອ໌ ປື່ນ. ");
INSERT INTO ncq_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ນ່ະກັອຍ ຕາຮານ ກັອຍ, ມານະ ອາຕີ ມານະ: \"ໄຮ ອຶນໂຈຍ ແຈອ໌ ອາຢັ່ອຮ ຕີ່ ໄນ່. ໄຮ ມັນຕັດ ອາຍຸ່ ອາຢັ່ອຮ ໄນ່. ອາແລ່ະ ເບີນ ລາ ໂທຍ.\" ນ່ະກັອຍ ຣາປຍາຍ໌ ກະ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ປາຍ ແຕ ອຶມແບິ ເຈີ່: \"ໄລ່ ອຶມແປອ໌ ອາຣົ່ຮ ກາ ເກົາ ເກີ່ຍ ຕັອກ, ກະ ມັນຕັດ ອາຍຸ່ ຕຳປັອກ ເກົາ.\" ນ່ະກັອຍ ມັຮ ຕາຮານ ກັອຍ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ເບີນ ກວາຍ ກາ ຕາຢຶ່ງ ແຈ່ະ ອາລ່ອງ ຊັງກັງ ເຢຊູ. ໄລ່ ກັອຍ ລາ ອຶມເປ່ອ໌ ເຢຊູ, ອາເວືາ ເຢຊູ, ມາຣີ ລາກວຍ ກະໂລປາ, ກະ ມາຣີ ແຕ ວີ່ລ ມັກດາລາ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ພໍກາ ເຢຊູ ເຮີມ ອຶມເປ່ອ໌ ອັນ ກະ ເກົາ ກາ ຣາຕອຍ ລາລື່ ກະ ອັນ ແອີດ ຕາຢຶ່ງ ແຈ່ະ ກັອຍ, ເຢຊູ ປາຍ ກະ ອຶມເປ່ອ໌ ອັນ: \"ອຶມເປ່ອ໌ ເອີຍ! ຕິຮ ລາ ກອນ ໄມ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ແວັດ ກັອຍ ເຢຊູ ອາຕີ ເກົາ ປາຍ: \"ໄນ່ ລາ ອຶມເປ່ອ໌ ໄມ່.\" ພໍກາ ກັອຍ, ເກົາ ເດີງ ອຶມເປ່ອ໌ ເຢຊູ ເຈົາ ແອີດ ຕຶ່ງ ດຸງ ເກົາ ແອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ເຈີ່ ເຢຊູ ປາຍ: \"ເກົາ ຊັອງ ອາເຣືາງ ແດີອ໌.\" ອັນ ປາຍ ນ່ະກັອຍ ໂອນ ແກີດ ຣາປຍາຍ໌ ກະ ປຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ. ແວັດ ກັອຍ, ອັນ ດັງ ອັນ ຕະ ອຶນແຍ່ະ ເຈີ່ ມັຮ ຣາມຶ່ຮ ເນົ່າ ຄຽນ ອາຕີ ແຕ ອັນ ຕຶ່ງ ປຶ່ງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ຕຶ່ງ ອຶນຕຸ ກັອຍ ເບີນ ມານຳ ແຈັຮ ບຼັອງ ອຶນເຍາະ. ໄລ່ ກັອຍ ອາລຸ ມວຍ ໂກກ ອາຣິ ຕຶ່ງ ບຼັອງ ກັອຍ, ເຈີ່ ໄລ່ ຊັດ ຕຶ່ງ ຊັຣນວາຍຮ. ໄລ່ ອາແວີຍ ອາຣິ ກັອຍ ປໍ ແບອ໌ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ແວັດ ເຢຊູ ຢູບ ແຕ ອາຣິ ກັອຍ, ອັນ ປາຍ: \"ແມິ່ມ ເຈີ່ ມັຮ ຣານະ ເກົາ!\" ແວັດ ກັອຍ ເຢຊູ ງຸ່ ອາແຊງ ແປຼີ, ເຈີ່ ອັນ ຕາອັອຮ ຣາງຶ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ຕາໄງ ກັອຍ ຈຸ່ມ ອິດຊະຣາເອລ ກຽມ ດໍອ໌ ອີ ຈາ ຣໍ່ອ໌ ຕາໄງ ປັຣແນີ, ຕຶ່ງ ຕາໄງ ຣາລູ່. ມັຮ ກວາຍ ຊົດ ອິດຊະຣາເອລ ຕາ ແອອ໌ ອີ ດໍອ໌ ກູມູ່ຍ໌ ຕຶ່ງ ອາລ່ອງ ຊັງກັງ ຕຶ່ງ ຕາໄງ ຣາລູ່. ນ່ະກັອຍ ໄລ່ ກັອຍ ແຊອ໌ ແຕ ປີລາດ ໂອນ ອັນ ແປຣີ ເນົ່າ ປຍາຍຮ ໂອນ ຕາແກັ່ຮ ອາເຢີງ ກວາຍ ກາ ເນົ່າ ແຕັຮ ກັອຍ, ກະ ໂອນ ໄລ່ ອາແຊງ ກູມູ່ຍ໌ ແຕ ອາລ່ອງ ຊັງກັງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ເຈີ່ ຕາຮານ ແຕີ່ອ໌ ປຍາຍຮ ໂອນ ຕາແກັ່ຮ ອາເຢີງ ບາຣ ນະ ກວາຍ ກາ ເນົ່າ ແຕັຮ ມັນຕຸ ກະ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ມາ ພໍກາ ຕາຮານ ກັອຍ ແຕີ່ອ໌ ປໍ ເຢຊູ, ໄລ່ ເຮີມ ເຢຊູ ກູຈີດ ເຈີ່. ນ່ະກັອຍ ໄລ່ ຕາ ເບີນ ປຍາຍຮ ນັ່ອງ ອາເຢີງ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ມາ ເບີນ ມານະ ຕາຮານ ອີດ ຮໍອ໌ ຈັ່ດ ມວຍ ກັ່ຮ ຈະ ເຢຊູ. ເຈີ່ ອາຮາມ ກະ ແດີອ໌ ລັ່ອຮ ແຕ ຈະ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ເກົາ ເຮີມ ອຶນແຍ່ະ ຣາມຶ່ຮ ໄນ່. ເກົາ ແຕີ່ອ໌ ອາຕີ ແຕ ຣາມຶ່ຮ ໄນ່, ກະ ປັຣນາຍ ເກົາ ອາຕີ ລາ ປຍາຍ໌ ລາລື່. ເກົາ ດັງ ເບີມ ເກົາ ປາຍ ປຍາຍ໌, ກະ ເກົາ ອາຕີ ນ່ະກັອຍ ໂອນ ເຍືາ ເຕ່ອ໌ ຊາອຳ. ");
INSERT INTO ncq_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ອຶນແຍ່ະ ຣາມຶ່ຮ ໄນ່ ຕະ ໂອນ ຣາປຍາຍ໌ ກະ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ແຕ ອຶມແບິ ປາຍ: \"ອຶງຮາງ ອັນ ມວຍ ອຶນແຕຣັ່ຮ ລາ ຕາ ເບີນ ຕາແກັ່ຮ.\" ");
INSERT INTO ncq_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ກະ ອຶນຕຸ ການໍ່ອ໌ ແອັນ ຕຶ່ງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ປາຍ: \"ໄລ່ ກາ ຈັ່ດ ອັນ ເນ່ ລັ່ຮ ອັນ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ແວັດ ກັອຍ ໂຢເຊັບ ແຕ ເມືອງ ອາຣີມາທາຍ ແຊອ໌ ກູມູ່ຍ໌ ເຢຊູ ແຕ ປີລາດ. ໂຢເຊັບ ລາ ກວາຍ ກາ ຕາປູ່ນ ເຢຊູ ເຕ່, ມາ ອັນ ຕາປູ່ນ ແກຣ່ະ, ຍ່ອນ ອັນ ອຶງກັອຮ ກວາຍ ຊົດ ອິດຊະຣາເອລ. ປີລາດ ໂອນ ອັນ ອີດ, ເຈີ່ ໂຢເຊັບ ເປາະ ອີດ ກູມູ່ຍ໌ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ເບີນ ກາ ນີໂກເດມ ເປາະ ກະ ໂຢເຊັບ ເຕ່. ນີໂກເດມ ລາ ອັນ ກາ ເປາະ ຊາອົຮ ເຢຊູ ມູ ຊາເດົາ ແຕ ອຶນໂຍ່ງ. ອັນ ເດີງ ເກຣີ່ງ ປາຮວມ ກາ ອັນ ກູຈຸ ແຕ ບາຣ ຣາມຶ່ຮ ອາລ່ອງ, ລາ ຊຽດ ອາລ່ອງ ປາຮວມ ກະ ອາໂຣເອ. ເກຣີ່ງ ປາຮວມ ກັອຍ ອຶນຕັອງ ໄປ ຈິ່ດ ລາ ປູນ ໂລ. ");
INSERT INTO ncq_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ໄລ່ ບາຣ ນະ ອີດ ກູມູ່ຍ໌ ເຢຊູ ເຈີ່ ຕວມ ໂຈະ ອາຣິ. ໄລ່ ໂຈະ ເກຣີ່ງ ປາຮວມ ຕຶ່ງ ອາຣິ ກັອຍ ແຮີ. ຕະ ນ່ະກັອຍ ໄລ່ ຕາປູ່ນ ຣີ່ດ ຈຸ່ມ ອິດຊະຣາເອລ ກຽມ ດໍອ໌ ເກີ່ຍ ແຕິບ ກູມູ່ຍ໌. ");
INSERT INTO ncq_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ແຈ່ະ ອຶນຕຸ ເນົ່າ ກາຈີດ ເຢຊູ ເບີນ ຊວນ. ຕຶ່ງ ຊວນ ກັອຍ ເບີນ ປີ່ງ ຕາໄມ ເນົ່າ ຕະ ດໍອ໌, ອຽນ ເນົ່າ ອີ ແຕິບ ກູມູ່ຍ໌. ");
INSERT INTO ncq_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ຍ່ອນ ຕາໄງ ກັອຍ ລາ ຕາໄງ ຈຸ່ມ ອິດຊະຣາເອລ ກຽມ ດໍອ໌ ອີ ຈາ ຣໍ່ອ໌, ກະ ຍ່ອນ ປີ່ງ ກັອຍ ແຈ່ະ ອຶນຕຸ ເນົ່າ ກາຈີດ ອັນ, ເຈີ່ ໄລ່ ບາຣ ນະ ແຕິບ ເຢຊູ ຕຶ່ງ ປີ່ງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ຕາໄງ ມວຍ ຕຶ່ງ ອາທິດ ກັອຍ, ອຶນນັ່ອງ ຍາຍຶ່ມ ລາລື່, ມາຣີ ແຕ ວີ່ລ ມັກດາລາ ແຕີ່ອ໌ ປໍ ປີ່ງ ກັອຍ. ອັນ ເຮີມ ເນົ່າ ວິ່ລ ເຈີ່ ຕາເມົາ ປື່ດ ແຕ ງັ່ຮ ປີ່ງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ນ່ະກັອຍ ອັນ ຕາລຸ່ຮ ເຈົາ ປໍ ຊີໂມນ ເປໂຕ ກະ ມານະ ກາ ຣຍານ ແຕ ເຢຊູ. ມາຣີ ປາຍ ໂຈະ ໄລ່ ບາຣ ນະ: \"ເນົ່າ ອີດ ເຈີ່ ອຶນເຈົາ ໄຮ ແຕ ປີ່ງ, ກະ ຮິ ຕາ ດັງ ປໍ ແລ່ະ ເນົ່າ ດໍອ໌ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ນ່ະກັອຍ ເປໂຕ ກະ ມານະ ກັອຍ ເປາະ ປໍ ປີ່ງ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ໄລ່ ບາຣ ນະ ຕາລຸ່ຮ, ມາ ມານະ ກັອຍ ຣາໄລ່ອ໌ ເປໂຕ. ນ່ະກັອຍ ອັນ ແຕີ່ອ໌ ອຶນໂຍ່ງ ປໍ ປີ່ງ. ");
INSERT INTO ncq_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ເຈີ່ ອັນ ປູບ ເນ່ ກະ ເຮີມ ແອີງ ອາຣິ ເມືາດ ຕຶ່ງ ປີ່ງ. ມາ ອັນ ຕາ ເບີນ ມູ່ດ ຕຶ່ງ ກຼຸງ ປີ່ງ. ");
INSERT INTO ncq_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ເຈີ່ ຊີໂມນ ເປໂຕ ແຕີ່ອ໌ ເຕ່, ກະ ອັນ ມູ່ດ ແຕິ່ ຕຶ່ງ ກຼຸງ ປີ່ງ. ອັນ ເຮີມ ແອີງ ອາຣິ ເມືາດ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ກະ ອັນ ເຮີມ ອາຣິ ກາ ເນົ່າ ປູ່ລ ແປຼີ ເຢຊູ. ອາຣິ ໄນ່ ນ່ະ ເນົ່າ ດົບ, ເຈີ່ ເນົ່າ ດໍອ໌ ອຶມພາ ກະ ອາຣິ ກາ ເນົ່າ ຕວມ ຈະ. ");
INSERT INTO ncq_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ແວັດ ກັອຍ, ມານະ ກາ ແຕີ່ອ໌ ອຶນໂຍ່ງ ກັອຍ ມູ່ດ ເຕ່. ອັນ ເຮີມ ກະ ອັນ ຊາອຳ. ");
INSERT INTO ncq_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ບັອງ ກັອຍ ໄລ່ ຕາ ຢວາຮ ດັງ ແຈງ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ແຕ ເຢຊູ ອຶງເຄາະ ກູຈີດ ມາ ຢວຣ ອາມົ່ງ ລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ແວັດ ກັອຍ ໄລ່ ບາຣ ນະ ເຈົາ ລັ່ຮ ປໍ ດຸງ. ");
INSERT INTO ncq_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ມາ ມາຣີ ອຶນນັ່ອງ ຕາຢຶ່ງ ເຍືາມ ຢັ່ຮ ນໍ່ອ໌ ປີ່ງ ກັອຍ. ບັອງ ກາ ອັນ ເຍືາມ ອັນ ຕາແລນ ຕຶ່ງ ປີ່ງ. ");
INSERT INTO ncq_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ອັນ ເຮີມ ບາຣ ນະ ເທວາດາ ເຢືາງ ເຈົາຣາຊີ ແຊິບ ອາຢັ່ອຮ ກຼໍອ໌ ກະ ຕາກູ ປໍ ອຶນຕຸ ເນົ່າ ດໍອ໌ ກູມູ່ຍ໌ ເຢຊູ ແຕ ອຶນໂຍ່ງ. ມານະ ຕາກູ ຢັ່ຮ ແປຼີ, ມານະ ຕາກູ ຢັ່ຮ ອາເຢີງ. ");
INSERT INTO ncq_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ໄລ່ ຕາແບີບ ມາຣີ ປາຍ: \"ອາເວືາ ເອີຍ! ນ່ະ ແຕ ໄມ່ ເຍືາມ?\" ມາຣີ ຕາແອີຍ ປາຍ: \"ເນົ່າ ອີດ ອຶນເຈົາ ເກົາ, ກະ ເກົາ ຕາ ດັງ ປໍ ແລ່ະ ເນົ່າ ເດີງ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ແວັດ ກັອຍ ມາຣີ ກູລຽວ ເຮີມ ເຢຊູ ຕາຢຶ່ງ ອຶນຕຸ ກັອຍ, ມາ ອັນ ຕາ ເບີນ ຊາກັ່ລ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ເຢຊູ ປາຍ ນ່ະໄນ່ ກະ ອັນ: \"ອາເວືາ ເອີຍ! ນ່ະ ແຕ ໄມ່ ເຍືາມ? ເນົ່າ ໄມ່ ຈໍ່ອ໌?\" ມາຣີ ຄຶ່ດ ປາຍ ອັນ ລາ ກວາຍ ຕະ ຕຶ່ງ ຊວນ ອຶງກັອຍ. ນ່ະກັອຍ ອັນ ຕາແອີຍ ປາຍ: \"ອາຈວາຍຮ ເອີຍ! ຄັນ ອາຈວາຍຮ ກາ ເດີງ ອາລັ່ອຮ ອັນ ກັອຍ, ແຊອ໌ ໂອນ ອາຈວາຍຮ ອາຕີ ອຶນຕຸ ແລ່ະ ອາຈວາຍຮ ດໍອ໌. ເຈີ່ ເກົາ ອີ ເປາະ ອີດ ອັນ.\" ");
INSERT INTO ncq_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ເຈີ່ ເຢຊູ ປາຍ ໂຈະ ອັນ: \"ມາຣີ.\" ມາຣີ ກູລຽວ ລັ່ຮ ປໍ ເຢຊູ ກະ ປາຍ: \"ຣັບໂບນີ ເອີຍ!\" (ປັຣນາຍ 'ຣັບໂບນີ' ອາຕີ ລັ່ຮ ລາ 'ອາຈານ.') ");
INSERT INTO ncq_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ເຢຊູ ອາຕີ ມາຣີ ປາຍ: \"ອຶນໂຈຍ ຢຸມ ດໍອ໌ ເກົາ, ຍ່ອນ ເກົາ ຕາ ຢວາຮ ຊັອຮ ປໍ ອຶມປໍ່ ເກົາ. ມາ ຊານໍ່ ໄມ່ ເຈົາ ປໍ ແຊມອາຍ ເກົາ, ກະ ອາຕີ ໄລ່ ປາຍ: 'ເກົາ ຊັອຮ ປໍ ອຶມປໍ່ ເກົາ ກະ ອຶມປໍ່ ເຍືາ. ເກົາ ຊັອຮ ປໍ ເຢືາງ ເຈົາຣາຊີ ເກົາ ກະ ເຢືາງ ເຈົາຣາຊີ ເຍືາ.'\" ");
INSERT INTO ncq_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ນ່ະກັອຍ, ມາຣີ ແຕ ວີ່ລ ມັກດາລາ ເຈົາ ປໍ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ. ອັນ ອາຕີ ໄລ່ ປາຍ: \"ເກົາ ເຮີມ ເຈີ່ ອຶນເຈົາ ໄຮ.\" ກະ ອັນ ອາຕີ ໄລ່ ມັຮ ປັຣນາຍ ເຢຊູ ປາຕັບ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ຕາໄງ ມວຍ ຕຶ່ງ ອາທິດ ກັອຍ, ແຕີ່ອ໌ ຕາບື່ ເຈີ່, ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ໂຣ່ມ ມັນຕຸ. ກະ ໄລ່ ໄກຼ່ຮ ກູຕົ່ງ, ຍ່ອນ ໄລ່ ອຶງກັອຮ ກວາຍ ຊົດ ອິດຊະຣາເອລ. ເຈີ່ ເຢຊູ ແຕີ່ອ໌ ຕາຢຶ່ງ ອຶນດີ ໄລ່. ອັນ ປາຍ: \"ເຍືາ ແອີດ ອຽນ ອໍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ແວັດ ອັນ ປາຍ ນ່ະກັອຍ, ເຢຊູ ອາປັຮ ໂອນ ໄລ່ ກັອຍ ເນ່ ຕາລາງ ອາຕີ ກະ ກັ່ຮ ຈະ ອັນ. ອຶນແຍ່ະ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ຊັອງ ຣໍ່ອ໌ ລາລື່ ຍ່ອນ ໄລ່ ເບີນ ເຮີມ ລັ່ຮ ອຶນເຈົາ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ເຢຊູ ອາຕີ ລັ່ຮ ຊາ: \"ເຍືາ ແອີດ ອຽນ ອໍ. ນ່ະ ອຶມປໍ່ ເກົາ ແປຣີ ເກົາ ໂອນ ເປາະ, ມູເຈິງ ກັອຍ ເຕ່, ເກົາ ແປຣີ ເຍືາ ໂອນ ເປາະ.\" ");
INSERT INTO ncq_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ອັນ ຕາງຶ່ຮ ໂຈະ ໄລ່ ກະ ປາຍ: \"ເຍືາ ຣັ່ບ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ. ");
INSERT INTO ncq_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ຄັນ ເຍືາ ຕັຮ ໂລ່ຍຮ ເນົ່າ, ໂລ່ຍຮ ກັອຍ ແກີດ ປິ່ດ. ມາ ຄັນ ເຍືາ ຕາ ເບີນ ຕັຮ ໂລ່ຍຮ ເນົ່າ, ໂລ່ຍຮ ກັອຍ ຕາ ເບີນ ແກີດ ປິ່ດ.\" ");
INSERT INTO ncq_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ໂທມາ, ອັນ ກາ ເນົ່າ ດໍອ໌ ດີດີມ ແຮີ, ອັນ ລາ ແຕ ມູ່ ມວຍ ຈິ່ດ ລາ ບາຣ ນະ ເຕ່, ມາ ອັນ ຕາ ເບີນ ແອີດ ກະ ມູ່ ກັອຍ ຕຶ່ງ ຕາໄງ ເຢຊູ ແຕີ່ອ໌ ເຮີບ ອຶນໂຍ່ງ. ");
INSERT INTO ncq_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ພໍກາ ໄລ່ ອາຕີ ໂທມາ ໄລ່ ເຮີມ ອຶນເຈົາ ໄລ່ ເຈີ່, ໂທມາ ຕາແອີຍ ໄລ່ ປາຍ: \"ຄັນ ເກົາ ຕາ ເບີນ ເຮີມ ຣາປີ່ດ ຕຶ່ງ ຕາລາງ ອາຕີ ອັນ, ກະ ຄັນ ເກົາ ຕາ ເບີນ ຊາປ່ະ ຣາດອຍ ອາຕີ ເກົາ ຕຶ່ງ ຣາປີ່ດ ກັອຍ, ກະ ຄັນ ເກົາ ຕາ ເບີນ ຊາປ່ະ ອາຕີ ເກົາ ຕຶ່ງ ກັ່ຮ ຈະ ອັນ, ເກົາ ຕາ ເບີນ ຊາອຳ.\" ");
INSERT INTO ncq_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ແວັດ ຕາກ່ອລ ຕາໄງ ແອັນ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ແອີດ ຕຶ່ງ ດຸງ ກັອຍ ຊາ, ກະ ໂທມາ ແອີດ ກະ ໄລ່ ກັອຍ ເຕ່. ເຈີ່ ໄລ່ ໄກຼ່ຮ ລັ່ຮ ຊາ ງັ່ຮ ຕົ່ງ ກັອຍ. ມາ ເຢຊູ ແຕີ່ອ໌ ລັ່ຮ ຕາຢຶ່ງ ອຶນດີ ໄລ່. ເຢຊູ ປາຍ: \"ເຍືາ ແອີດ ອຽນ ອໍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ແວັດ ກັອຍ ອັນ ປາຍ ໂຈະ ໂທມາ: \"ໄນ່ ລາ ຕາລາງ ອາຕີ ເກົາ. ໄມ່ ອາລັ່ອຮ ຣາດອຍ ອາຕີ ໄມ່ ປູເປີ່ຣ ຊາງັດ ຕາລາງ ອາຕີ ເກົາ. ກະ ໄມ່ ອາລັ່ອຮ ອາຕີ ໄມ່ ປູເປີ່ຣ ຊາງັດ ກັ່ຮ ຈະ ເກົາ. ໄມ່ ອຶນໂຈຍ ເງືານ ນັ່ອງ. ມາ ອຶງເຄາະ ໄມ່ ຊາອຳ!\" ");
INSERT INTO ncq_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ໂທມາ ຕາແອີຍ ແຕິ່: \"ອຶນເຈົາ ເກົາ, ກະ ເຢືາງ ເຈົາຣາຊີ ເກົາ!\" ");
INSERT INTO ncq_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ເຢຊູ ປາຍ ລັ່ຮ ໂຈະ ໂທມາ: \"ຍ່ອນ ໄມ່ ເຮີມ ຈະ ເກົາ ເຈີ່, ກັອຍ ແຕ ໄມ່ ຊາອຳ. ມາ ບຸ່ນ ລາລື່ ໄລ່ ກາ ຊາອຳ ເກົາ, ມາ ຕາ ເກີ່ຍ ເຮີມ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ເຢຊູ ຕະ ຊາອຶ່ຍ ຣານະ ຕາ ເກີ່ຍ ເຮີມ ການໍ່ອ໌ ຢັ່ຮ ເມືາງ ມູ່ ກາ ຣຍານ ແຕ ອັນ, ມາ ຕາ ເບີນ ຄຽນ ອຶນແຍ່ະ ຕຶ່ງ ປຶ່ງ ໄນ່. ");
INSERT INTO ncq_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ມາ ມັຮ ຣາມຶ່ຮ ກາ ຄຽນ ຕຶ່ງ ປຶ່ງ ໄນ່ ເຈີ່, ລາ ໂອນ ເຍືາ ຊາອຳ ເຢຊູ ລາ ກຣີດ, ກອນ ເຢືາງ ເຈົາຣາຊີ. ຄັນ ເຍືາ ຊາອຳ ນ່ະກັອຍ, ເຍືາ ເບີນ ອາມົ່ງ ເລືອຍໆ ຍ່ອນ ແຕ ຣາມຶ່ຮ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ແວັດ ແຕ ກັອຍ ເຢຊູ ແຕີ່ອ໌ ປໍ ມູ່ ກາ ຣຍານ ແຕ ອັນ ມວຍ ເຮີບ ແອັນ ຕຶ່ງ ປຶ່ຮ ທາເລ ຣາປັ່ງ ຄາລີເລ. ຣານະ ໄນ່ ແກີດ ນ່ະໄນ່: ");
INSERT INTO ncq_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ໄລ່ ກາ ແອີດ ມັນຕຸ ກັອຍ ລາ ຊີໂມນ ເປໂຕ, ໂທມາ (ອັນ ກາ ເນົ່າ ດໍອ໌ ດີດີມ ແຮີ), ນະທານາເອັລ ແຕ ເມືອງ ການາ ຕຶ່ງ ແຄງ ຄາລີເລ, ບາຣ ນະ ກອນ ຣາເລົາ ເຊເບດາຍ, ກະ ບາຣ ນະ ການໍ່ອ໌ ແຕ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ຊີໂມນ ເປໂຕ ປາຍ: \"ເກົາ ເປາະ ຕິງ ມ່ອງ ຈໍ່ອ໌ ອາກາ.\" ເຈີ່ ມັຮ ກວາຍ ການໍ່ອ໌ ກັອຍ ປາຍ: \"ຮິ ອີ ເປາະ ເຕ່ ກະ ໄມ່.\" ນ່ະກັອຍ ອຶນແຍ່ະ ມັຮ ໄລ່ ຊັອຮ ຕຶ່ງ ຕົວະ. ມາ ອຶນແຍ່ະ ມູ ຊາເດົາ ກັອຍ ໄລ່ ຕາ ເບີນ ເບີນ ມານຳ ອາກາ. ");
INSERT INTO ncq_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ປັ່ງ ຕາຣື່ບ ອຶນນັ່ອງ ຍາຍຶ່ມ ເຢຊູ ແອີດ ຕຶ່ງ ປຶ່ຮ ທາເລ ຣາປັ່ງ ກັອຍ, ມາ ໄລ່ ມູ່ ກາ ຣຍານ ແຕ ອັນ ຕາ ເບີນ ດັງ ປາຍ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ເຢຊູ ຊາບາວ ປາຍ: \"ເຢົ່າ ເອີຍ! ເຍືາ ເບີນ ອາກາ ບໍ?\" ໄລ່ ຕາແອີຍ ລັ່ຮ: \"ຕາ ເບີນ!\" ");
INSERT INTO ncq_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ເຢຊູ ປາຍ ແອັນ: \"ເຍືາ ຕິງ ມ່ອງ ເຍືາ ຢັ່ຮ ອາຕ່ຳ ແອັນ. ເຈີ່ ເຍືາ ເບີນ ອາກາ.\" ພໍກາ ໄລ່ ຕະ ນ່ະກັອຍ, ມ່ອງ ໄລ່ ໄກຣ ອາກາ ຊາອຶ່ຍ ລາລື່. ໄລ່ ຕາ ເຣືາບ ກາຕັ່ອງ ອາຊັອຮ ນັ່ອງ ມ່ອງ ຕຶ່ງ ຕົວະ. ");
INSERT INTO ncq_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ເຈີ່ ມານະ ແຕ ມູ່ ກາ ຣຍານ ກາ ຣາຕອຍ ລາລື່ ກະ ເຢຊູ ອາຕີ ເປໂຕ ປາຍ: \"ອັນ ກັອຍ ລາ ອຶນເຈົາ ໄຮ!\" ແວັດ ຊີໂມນ ເປໂຕ ຊັອງ ອັນ ປາຍ: \"ອັນ ກັອຍ ລາ ອຶນເຈົາ ໄຮ,\" ນ່ະກັອຍ ເປໂຕ ແຊິບ ແຕິ່ ອາຢັ່ອຮ, ຍ່ອນ ແຕ ອຶນໂຍ່ງ ອັນ ຕວດ ດໍອ໌ ເຈີ່. ແວັດ ກັອຍ ອັນ ປັອງ ຕຶ່ງ ແດີອ໌. ");
INSERT INTO ncq_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ນ່ະກັອຍ ມັຮ ມູ່ ກາ ຣຍານ ການໍ່ອ໌ ຕາປູ່ນ ອຶນຕູ່ນ ອັນ ຣານາ ຕົວະ. ກະ ໄລ່ ຮອຣ ມ່ອງ ປັ່ນ ອາກາ ເຈີ່. ໄລ່ ແອີດ ເຢີ່ງ ແຕ ປຶ່ຮ ມາຮ ຕາເກ່ຮ ຈິ່ດ ແມັດ ຊັອງ. ");
INSERT INTO ncq_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ພໍກາ ໄລ່ ແຕີ່ອ໌ ປໍ ປຶ່ຮ, ໄລ່ ເຮີມ ອູ່ຍຮ ຣັງແຮິ, ກະ ເບີນ ອາກາ ກະ ໂດຍ ບຸຮ ຕຶ່ງ ຕາແປັຮ ກັອຍ. ");
INSERT INTO ncq_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ເຢຊູ ແປຣີ ໄລ່: \"ເຍືາ ເດີງ ປໍ ໄນ່ ອາກາ ກາ ຕາແບິ ໄກຣ.\" ");
INSERT INTO ncq_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ຊານໍ່ ແຕິ່ ຊີໂມນ ເປໂຕ ເປາະ ຮອຣ ມ່ອງ ເດີງ ປໍ ປຶ່ຮ. ມ່ອງ ກັອຍ ປັ່ນ ແອີງ ອາກາ; ເບີນ ມວຍ ຣ່ອຍ ເຊີງ ຈິ່ດ ລາ ໄປ ລຳ ອາກາ ປື່ດ, ມາ ມ່ອງ ກັອຍ ຕາ ເບີນ ປຣຸ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ເຢຊູ ອາຕີ ໄລ່ ປາຍ: \"ເຍືາ ແຕີ່ອ໌ ຈາ ເວືາຍ.\" ຕາ ເບີນ ອາແລ່ະ ແຕ ມູ່ ກາ ຣຍານ ແຕ ອັນ ຍັ່ນ ຕາແບີບ ອັນ: \"ອາຈານ ລາ ເນົ່າ?\" ຍ່ອນ ອຶນແຍ່ະ ມັຮ ໄລ່ ດັງ ເຈີ່ ໄນ່ ລາ ອຶນເຈົາ ໄລ່. ");
INSERT INTO ncq_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ນ່ະກັອຍ ເຢຊູ ເປາະ ອີດ ໂດຍ ບຸຮ; ເຈີ່ ອັນ ອາແວີຍ ໂອນ ໄລ່ ຈາ. ກະ ອັນ ອາແວີຍ ອາກາ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ໄປ ເຮີບ ເຈີ່ ຕຶ່ງ ໄນ່ ເຢຊູ ຣາມົຮ ກະ ມູ່ ກາ ຣຍານ ແຕ ອັນ ແວັດ ຕາໄງ ອັນ ຢວຣ ອາມົ່ງ ລັ່ຮ. ");
INSERT INTO ncq_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ແວັດ ໄລ່ ຈີຈາ ເຈີ່, ເຢຊູ ຕາແບີບ ຊີໂມນ ເປໂຕ ປາຍ: \"ຊີໂມນ, ກອນ ໂຢຮັນ ເອີຍ! ໄມ່ ອາໂຢ່ະ ເກົາ ກາເລີຍ ອຶນແຍ່ະ ແຕ ຣາມຶ່ຮ ການໍ່ອ໌ ບໍ?\" ເປໂຕ ຕາແອີຍ ປາຍ: \"ເອີອ໌. ອຶນເຈົາ ດັງ ເຈີ່ ເກົາ ອາໂຢ່ະ ອຶນເຈົາ.\" ເຈີ່ ເຢຊູ ອາຕີ ອັນ ປາຍ: \"ອຶງເຄາະ ໄມ່ ແຈມ ແກະ ກອນ ເກົາ ນໍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ມວຍ ເຮີບ ແອັນ ເຢຊູ ຕາແບີບ ເປໂຕ ປາຍ: \"ຊີໂມນ, ກອນ ໂຢຮັນ ເອີຍ! ໄມ່ ອາໂຢ່ະ ເກົາ ບໍ?\" ເປໂຕ ຕາແອີຍ ລັ່ຮ ຊາ: \"ເອີອ໌. ອຶນເຈົາ ດັງ ເຈີ່ ເກົາ ອາໂຢ່ະ ອຶນເຈົາ.\" ເຈີ່ ເຢຊູ ອາຕີ ລັ່ຮ ອັນ: \"ອຶງເຄາະ ໄມ່ ກຍາອ໌ ແກະ ເກົາ ນໍ.\" ");
INSERT INTO ncq_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ມວຍ ເຮີບ ແອັນ ເຢຊູ ຕາແບີບ ລັ່ຮ ເປໂຕ ປາຍ: \"ຊີໂມນ, ກອນ ໂຢຮັນ ເອີຍ! ໄກຣ ລາລື່ ໄມ່ ອາໂຢ່ະ ເກົາ ບໍ?\" ເປໂຕ ຊັອງ ຕຸ່ຮ ລາລື່ ຍ່ອນ ເຢຊູ ແອີດ ຕາແບີບ ເລືອຍໆ ອັນ ໄປ ເຮີບ ເຈີ່ ປາຍ: \"ໄກຣ ລາລື່ ໄມ່ ອາໂຢ່ະ ເກົາ ບໍ?\" ເຈີ່ ເປໂຕ ຕາແອີຍ ລັ່ຮ ຊາ: \"ອຶນເຈົາ ເອີຍ! ອຶນເຈົາ ດັງ ອຶນແຍ່ະ ກູ່ ຣາມຶ່ຮ ເຈີ່. ນ່ະກັອຍ ອຶນເຈົາ ດັງ ເກົາ ອາໂຢ່ະ ອຶນເຈົາ.\" ເຈີ່ ເຢຊູ ອາຕີ ລັ່ຮ ອັນ: \"ອຶງເຄາະ ໄມ່ ແຈມ ແກະ ເກົາ ນໍ. ");
INSERT INTO ncq_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ເກົາ ອາຕີ ຕານັ່ອງ ໂອນ ໄມ່, ແຕ ອຶນໂຍ່ງ ບັອງ ໄມ່ ອຶນນັ່ອງ ແກີດ ກວາຍ ນຸ່ມ, ເຕ່ອ໌ ໄມ່ ອີດ ຣາງຶ່ຮ ໄມ່ ເບີມ. ໄມ່ ຢໍອ໌ ອີ ເປາະ ປໍ ແລ່ະ, ໄມ່ ເປາະ. ມາ ປັຣແນີ ມັນເຕຣືາ ແຕີ່ອ໌ ໄມ່ ແກີດ ກວາຍ ເທົາ, ໄມ່ ຢັ່ງ ອາຕີ ໄມ່ ກະ ກວາຍ ການໍ່ອ໌ ຊັດ ໄມ່. ກະ ໄລ່ ເດີງ ໄມ່ ເປາະ ອຶນຕຸ ໄມ່ ຕາ ຢໍອ໌ ອີ ເປາະ.\" ");
INSERT INTO ncq_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ເຢຊູ ປາຍ ນ່ະກັອຍ, ອັນ ອາຕີ ຣານາ ອຶນເຕົ່າ ເປໂຕ ຈີວ໌ ກູຈີດ. ກະ ອັນ ເດີງ ກວາຍ ການໍ່ອ໌ ຍ່ອງ ເຢືາງ ເຈົາຣາຊີ ຍ່ອນ ແຕ ຣານະ ອັນ ຕະ. ແວັດ ກັອຍ ເຢຊູ ແປຣີ ເປໂຕ: \"ອຶງເຄາະ ໄມ່ ຕາປູ່ນ ເກົາ!\" ");
INSERT INTO ncq_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ເປໂຕ ກູລຽວ ປໍ ກຣັອງ. ອັນ ເຮີມ ມານະ ແຕ ມູ່ ກາ ຣຍານ ກາ ຣາຕອຍ ກະ ເຢຊູ ແອີດ ປໍ ກັອຍ ເຕ່. ມານະ ກັອຍ ລາ ອັນ ກາ ແອີດ ແຈ່ະ ເຢຊູ ບັອງ ກາ ໄລ່ ຈາ ໂດຍ ມັນຕຸ ເປ່ລ ຕາບື່ ກັອຍ. ອັນ ໄນ່ ແຕິ່ ຕາແບີບ ເຢຊູ ເນົ່າ ກາ ອີ ມ່ອບ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ພໍກາ ເປໂຕ ເຮີມ ອັນ, ອັນ ຕາແບີບ ເຢຊູ ປາຍ: \"ອຶນເຈົາ ເອີຍ! ອັນ ໄນ່ ກູຈີດ ຣານາ ອຶນເຕົ່າ?\" ");
INSERT INTO ncq_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ເຢຊູ ຕາແອີຍ ເປໂຕ ປາຍ: \"ຄັນ ເກົາ ໂອນ ອັນ ໄນ່ ແອີດ ເຕົ່າ ເກົາ ແຕີ່ອ໌ ລັ່ຮ ປໍ ໄນ່, ໄນ່ ລາ ຕາ ແກີນ ຣານະ ອຶງເຄາະ ໄມ່ ດັງ. ມາ ໄມ່, ອຶງເຄາະ ໄມ່ ຕາປູ່ນ ເກົາ.\" ");
INSERT INTO ncq_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ປັຣນາຍ ກັອຍ ເປາະ ຕົວ ປໍ ກວາຍ ກາ ຊາອຳ ເຢຊູ. ນ່ະກັອຍ ໄລ່ ຄຶ່ດ ປາຍ ມານະ ກັອຍ ຕາ ເບີນ ກູຈີດ ນັ່ອງ. ມາ ເຢຊູ ຕາ ເບີນ ປາຍ ມານະ ກັອຍ ຕາ ເບີນ ກູຈີດ. ເຢຊູ ປາຍ ນ່ະໄນ່: \"ຄັນ ເກົາ ໂອນ ອັນ ໄນ່ ແອີດ ເຕົ່າ ເກົາ ແຕີ່ອ໌ ລັ່ຮ ປໍ ໄນ່, ໄນ່ ລາ ຕາ ແກີນ ຣານະ ອຶງເຄາະ ໄມ່ ດັງ.\" ");
INSERT INTO ncq_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ອັນ ໄນ່ ແຕິ່ ລາ ກວາຍ ແຕ ມູ່ ກາ ຣຍານ ແຕ ເຢຊູ ກາ ອາຕີ ອຶນແຍ່ະ ຣາມຶ່ຮ ໄນ່, ກະ ອັນ ຄຽນ ອຶນແຍ່ະ ຣາມຶ່ຮ ໄນ່ ເຕ່. ເຕ່ອ໌ ເຍືາ ຊາອຳ ອຶນແຍ່ະ ປັຣນາຍ ໄນ່ ລາ ປຍາຍ໌ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ອຶນນັ່ອງ ເບີນ ຊາອຶ່ຍ ຣານະ ແອັນ ເຢຊູ ຕະ. ເກົາ ຄຶ່ດ, ຄັນ ເນົ່າ ຢໍອ໌ ອີ ຄຽນ ອຶນແຍ່ະ ຣາມຶ່ຮ ກັອຍ, ຕາ ເບີນ ອຶນແລ່ະ ອີ ດໍອ໌ ນັ່ອງ ປຶ່ງ ກັອຍ, ກູທັດ ອຶນແຍ່ະ ຕຶ່ງ ກູແຕອ໌ ໄນ່.");
INSERT INTO ncq_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ອາຈວາຍຮ ເທໂອພີໂລ ເອີຍ! ເກົາ ລາ ລູກາ ຄຽນ ແຕ ອຶນໂຍ່ງ ເຈີ່ ມວຍ ປຶ່ງ ໂອນ ໄມ່ ດັງ ແຈງ ລາລື່ ອຶນແຍ່ະ ຣານະ ເຢຊູ ຕະ ກະ ອຶນແຍ່ະ ຣາມຶ່ຮ ອັນ ອາຕີ, ");
INSERT INTO ncq_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ອັນ ຊັອຮ ປໍ ມັນລັ່ອງ. ອຶນໂຍ່ງ ອັນ ອີ ຊັອຮ, ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ໂອນ ອັນ ປາຕັບ ມູ່ ກາ ອັນ ຣຽຮ ປາຈຸ່ຮ ໂອນ ເປາະ ຕະ ຣານະ ອັນ, ໂອນ ໄລ່ ດັງ ແຕ ມັຮ ຣານະ ໄລ່ ອຶງເຄາະ ຕະ. ");
INSERT INTO ncq_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ເຢຊູ ຣາມົຮ ຕຸ່ຮ ກັ່ດ ຊາອຶ່ຍ ລາລື່ ເຈີ່. ແວັດ ອັນ ກູຈີດ ອັນ ອາມົ່ງ ລັ່ຮ, ກະ ອັນ ເຈົາ ລັ່ຮ ປໍ ມູ່ ກາ ອັນ ຣຽຮ. ອັນ ແອີດ ກະ ໄລ່ ອຶນແຍ່ະ ປູນ ຈິ່ດ ຕາໄງ ປູນ ຈິ່ດ ຊາເດົາ. ບັອງ ກາ ກັອຍ, ອັນ ຕະ ຊາອຶ່ຍ ຣານະ ໂອນ ໄລ່ ເຕ່ອ໌ ດັງ ແຈງ ລາລື່ ປາຍ ອັນ ອາມົ່ງ ລັ່ຮ, ກະ ອັນ ອາຕີ ໄລ່ ມັຮ ຣາມຶ່ຮ ແຕ ເຢືາງ ເຈົາຣາຊີ ຕະ ຊົດ. ");
INSERT INTO ncq_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ບັອງ ກາ ເຢຊູ ແອີດ ໂຣ່ມ ກະ ໄລ່ ກັອຍ, ອັນ ອາຕີ ໄລ່ ປາຍ: \"ເຍືາ ອຶນໂຈຍ ລັ່ອຮ ຢວາຮ ແຕ ເມືອງ ເຢຣູຊາເລັມ. ມາ ເຍືາ ເກຣາະ ເວືາຍ ໂອນ ແຕີ່ອ໌ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ມາຮ ອຶມປໍ່ ເກົາ ເອີອ໌ ໂອນ ເຍືາ, ນ່ະ ເກົາ ອາຕີ ເຍືາ ແຕ ອຶນໂຍ່ງ ເຈີ່. ");
INSERT INTO ncq_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ບັອງ ກັອຍ ໂຢຮັນ ຕະ ຣີ່ດ ໂອນ ເຍືາ ແຕ ແດີອ໌. ມາ ຕາ ເບີນ ດູ່ນ ນັ່ອງ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ອີ ແຕີ່ອ໌. ກະ ອັນ ອີ ມູ່ດ ແອີດ ຕຶ່ງ ຣາງຶ່ຮ ເຍືາ. ໄນ່ ລາ ນ່ະ ເຍືາ ຣັ່ບ ຣີ່ດ ແຕ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ.\" ");
INSERT INTO ncq_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ບັອງ ກາ ເຢຊູ ໂຣ່ມ ກະ ມູ່ ກາ ອັນ ຣຽຮ, ໄລ່ ຕາແບີບ ອັນ ປາຍ: \"ຊານໍ່ ອຶນເຈົາ ອີ ຕະ ໂອນ ກຣວາງ ອິດຊະຣາເອລ ຊົດ ເບີມ ລັ່ຮ ບໍ?\" ");
INSERT INTO ncq_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ເຢຊູ ຕາແອີຍ ໄລ່ ປາຍ: \"ເຍືາ ຕາ ເບີນ ຕຸ່ຮ ດັງ ຣາມຶ່ຮ ໄນ່. ມັຮ ຣາມຶ່ຮ ໄນ່ ແອີງ ເຢືາງ ເຈົາຣາຊີ ຊັອງ ດັງ, ຍ່ອນ ອັນ ແຕິ່ ກາ ຕະ ດໍອ໌ ພານັດ. ");
INSERT INTO ncq_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ມາ ພໍກາ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ມູ່ດ ແອີດ ຕຶ່ງ ຣາງຶ່ຮ ເຍືາ, ອັນ ໂອນ ເຍືາ ເບີນ ອຳນາດ ເຣືາບ ເປາະ ອາຕີ ປັຣນາຍ ແຕ ເກົາ. ປັຣແນີ ມັນເຕຣືາ ເຍືາ ເບີນ ອາຕີ ຣານະ ໄນ່ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ, ແຄງ ຢູດາຍ, ແຄງ ຊາມາເຣຍ, ກະ ປຼັຮ ອຶນແຍ່ະ ກຣວາງ ປື່ນ ມັນລັ່ອງ ກຣຸ່ ໄນ່.\" ");
INSERT INTO ncq_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ແວັດ ເຢຊູ ປາຍ ນ່ະກັອຍ, ເຢືາງ ເຈົາຣາຊີ ຣັ່ບ ອັນ ຊັອຮ ປໍ ມັນລັ່ອງ, ກະ ຣາມິ່ລ ກາຕັງ ຈະ ອັນ. ໄລ່ ກາ ແອີດ ຕຶ່ງ ກູແຕອ໌ ຕາ ເບີນ ເຮີມ ນັ່ອງ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ພໍກາ ເຢຊູ ຊັອຮ ປໍ ມັນລັ່ອງ, ໄລ່ ແອີດ ຕາງ່ອນ ເນ່ ເລືອຍໆ. ບັອງ ກາ ກັອຍ ແຕິ່ ເບີນ ບາຣ ນະ ກວາຍ ຣາເລົາ ແອີດ ແຈ່ະ ໄລ່. ບາຣ ນະ ໄນ່ ແຊິບ ອາຢັ່ອຮ ກຼໍອ໌, ");
INSERT INTO ncq_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ກະ ປາຍ: \"ກວາຍ ແຕ ແຄງ ຄາລີເລ ເອີຍ! ນານ່ະ ເຍືາ ແອີດ ຕາຢຶ່ງ ອຶນໄນ່ ກະ ອຶນເຕົ່າ ເຍືາ ເນ່ ອາຊັອຮ ປໍ ມັນລັ່ອງ? ເຢຊູ ໄນ່, ອັນ ກາ ເຢືາງ ເຈົາຣາຊີ ຣັ່ບ ຊັອຮ ປໍ ມັນລັ່ອງ, ປັຣແນີ ມັນເຕຣືາ ອັນ ແຊງ ລັ່ຮ ປໍ ກູແຕອ໌ ໄນ່ ມູເຈິງ ເຍືາ ເຮີມ ອັນ ຊັອຮ ປໍ ມັນລັ່ອງ ຊານໍ່ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ພໍກາ ໄລ່ ແຊງ ແຕ ກົຮ ອາໂປ່ນ, ເຈີ່ ໄລ່ ເຈົາ ລັ່ຮ ປໍ ເມືອງ ເຢຣູຊາເລັມ. ແຕ ກົຮ ໄນ່ ກະ ເມືອງ ເຢຣູຊາເລັມ ເຢີ່ງ ລາ ມັ່ນ ເບີນ ມວຍ ລັກ. ");
INSERT INTO ncq_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ແຕີ່ອ໌ ເມືອງ ກັອຍ ໄລ່ ເຈົາ ລັ່ຮ ປໍ ດຸງ ກາ ໄລ່ ເກີ່ຍ ແອີດ ແຕ ອຶນລີ່ງ. ຕຶ່ງ ດຸງ ກັອຍ, ໄລ່ ຊັອຮ ຕຶ່ງ ຣານ ແປີງ, ມູ່ດ ແອີດ ຕຶ່ງ ມວຍ ກຼຸງ. ມັຮ ກວາຍ ກາ ໂຣ່ມ ອຶງກັອຍ ລາ: ເປໂຕ, ໂຢຮັນ, ຢາໂກໂບ, ອັນເດອາ, ພີລິບ, ໂທມາ, ບາຣໂທໂລມາຍ, ມັດທາຍ, ຢາໂກໂບ ກອນ ອາລະພາຍ, ຊີໂມນ ຊີໂລດ, ກະ ຢູດາ ກອນ ຢາໂກໂບ. ");
INSERT INTO ncq_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ອຶນແຍ່ະ ມັຮ ໄລ່ ກາ ເກີ່ຍ ໂຣ່ມ ອຶມປຣ່ອມ ເກົາແຊອ໌ ມວຍ ຣາງຶ່ຮ ຕຶ່ງ ອຶນຕຸ ກັອຍ. ເບີນ ມັຮ ມັນແຊມ, ມາຣີ ອຶມເປ່ອ໌ ເຢຊູ, ກະ ມັຮ ອາແອມ ຣາເລົາ ເຢຊູ ລາ ໂຣ່ມ ອຶງກັອຍ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ເບີນ ມວຍ ຕາໄງ ອຶນຕູ່ນ ແອັນ ເປໂຕ ຢວຣ ຕາຢຶ່ງ ອາຕີ ມູ່ ກາ ຊາອຳ ເຢຊູ ແອີດ ໂຣ່ມ ປໍ ກັອຍ. ຈຸ່ມ ໄລ່ ກັອຍ ເບີນ ມາຮ ມວຍ ຣ່ອຍ ບາຣ ຈິ່ດ ນະ. ເປໂຕ ປາຍ: ");
INSERT INTO ncq_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","\"ແຊມອາຍ ເອີຍ! ມັຮ ປັຣນາຍ ເຢືາງ ເຈົາຣາຊີ ອາຕີ ແຕ ອຶມແບິ, ໄຮ ເຮີມ ເຈີ່ ແກີດ ຣາປຍາຍ໌ ແຕ ຣານະ ຢູດາ ອິດຊະກາຣີອົດ. ຢູດາ ຕະ ນ່ະ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ໂອນ ດາວິດ ອາຕີ ແຕ ອຶມແບິ, ອັນ ເດີງ ກວາຍ ເປາະ ໂກບ ເຢຊູ. ");
INSERT INTO ncq_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ຢູດາ ໄນ່ ລາ ແຕ ມູ່ ໄຮ ເຕ່, ຕະ ຣານະ ມູເຈິງ ໄຮ ເຕ່. ");
INSERT INTO ncq_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ມາ ຢູດາ ອີດ ປຣະ ເນົ່າ ຈາງ ໂອນ ຕະ ຣານະ ຕາ ອໍ, ອັນ ອາໂຢ່ງ ຣານາ ໂອນ ເນົ່າ ແຕີ່ອ໌ ໂກບ ເຢຊູ. ເຈີ່ ອັນ ເປາະ ແຈີງ ມວຍ ອຶນຕຸ ກູແຕອ໌. ແວັດ ກັອຍ ຢູດາ ຢະ. ປຸ່ງ ອັນ ແກີດ ຊື່ອ໌, ເຈີ່ ປາດັອຮ; ກະ ຣ່ອຍ໌ ອັນ ລັ່ອຮ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ພໍກາ ກວາຍ ກາ ແອີດ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ ຊັອງ ຣານະ ກັອຍ, ໄລ່ ອາມຶ່ຮ ອຶນຕຸ ກັອຍ ລາ ອະເກັນດາມາ. ປັຣນາຍ ກັອຍ ອຶນຕີ ລັ່ຮ ລາ 'ຕາລິງ ອາຮາມ.' ");
INSERT INTO ncq_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ອຶນແຍ່ະ ຣາມຶ່ຮ ໄນ່ ເຕືາວ ປັຣເຍືາ ດາວິດ ອາຕີ ເຈີ່ ຕຶ່ງ ປຶ່ງ ປັຣນາຍ ລ່ຳ ຍ່ອງ ເຢືາງ ເຈົາຣາຊີ ປາຍ: 'ໂອນ ດຸງ ອັນ ແກີດ ດຸງ ເມືາດ ຊັອງ. ຕາ ເບີນ ເນົ່າ ແອີດ ນັ່ອງ ຕຶ່ງ ດຸງ ກັອຍ.' ກະ ດາວິດ ອາຕີ ມວຍ ປັຣນາຍ ການໍ່ອ໌ ແອັນ ອຶນຕຸ ກັອຍ: 'ໂອນ ກວາຍ ການໍ່ອ໌ ໄປຼຮ ລັ່ຮ ຣານະ ອັນ ຕະ.' ");
INSERT INTO ncq_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","ມູ່ ຮິ ອຶງເຄາະ ເບີນ ລັ່ຮ ມານະ ແອັນ ຕະ ຣານະ ກະ ຮິ. ອຶງເຄາະ ໄຮ ຣຽຮ ມານະ ກາ ແອີດ ກະ ຮິ ແຕ ຕາໄງ ໂຢຮັນ ຕະ ຣີ່ດ ຕຶ່ງ ແດີອ໌ ໂອນ ເຢຊູ, ເຕົ່າ ແຕີ່ອ໌ ຕາໄງ ເຢຊູ ຊັອຮ ປໍ ມັນລັ່ອງ. ກວາຍ ໄນ່ ອຶງເຄາະ ອັນ ເບີນ ເຮີມ ເຢຊູ ກູຈີດ ເຈີ່ ອາມົ່ງ ລັ່ຮ. ນ່ະກັອຍ ເຕ່ອ໌ ອັນ ອາຕີ ມັນຕຸ ກະ ຮິ ໂອນ ກວາຍ ການໍ່ອ໌ ດັງ ເຕ່.\" ");
INSERT INTO ncq_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ນ່ະກັອຍ ໄລ່ ຣຽຮ ເບີນ ບາຣ ນະ, ມາ ໄລ່ ອີ ອີດ ມານະ ຊັອງ. ຣາມຶ່ຮ ບາຣ ນະ ກັອຍ ລາ ມັດເທຍ ກະ ໂຢເຊັບ. ໂຢເຊັບ ໄນ່, ເນົ່າ ດໍອ໌ ອັນ ບາຣຊັບບາ ແຕີລາ ຢູຊະໂຕ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","ເຈີ່ ອຶນແຍ່ະ ມູ່ ກັອຍ ເກົາແຊອ໌ ປາຍ: \"ອຶນເຈົາ ຮິ ເອີຍ! ເຍືາ ດັງ ອຶນແຍ່ະ ກູ່ ຣາມຶ່ຮ ຕຶ່ງ ຣາງຶ່ຮ ກວາຍ. ນ່ະກັອຍ ອຶນເຈົາ ເອີຍ, ແຊອ໌ ເຍືາ ອາປັຮ ຈະ ກວາຍ ອາແລ່ະ ແຕ ບາຣ ນະ ໄນ່ ກາ ເຍືາ ອີ ຣຽຮ ໂອນ ອັນ ຕະ ເຕ່ນ ລັ່ຮ ຣານະ ຢູດາ ຕະ. ຢູດາ ຕັຮ ຣານະ ໄນ່, ກະ ອັນ ເປາະ ແອີດ ຕຶ່ງ ອຶນຕຸ ກວາຍ ຕາ ອໍ ແອີດ.\" ");
INSERT INTO ncq_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ແວັດ ໄລ່ ເກົາແຊອ໌ ເຈີ່, ໄລ່ ມັນຕັດ ອີ ຣຽຮ ມານະ ແຕ ບາຣ ນະ ກັອຍ. ໄລ່ ຣຽຮ ປຍາຍ໌ ມັດເທຍ. ນ່ະກັອຍ ມັດເທຍ ມູ່ດ ຕະ ຣານະ ມັນຕຸ ກະ ໄລ່ ກາ ມັນຈິ່ດ ລາ ມານະ. ເຈີ່ ເນົ່າ ດໍອ໌ ໄລ່ ກາ ມວຍ ຈິ່ດ ລາ ບາຣ ນະ ກັອຍ ລາ ກວາຍ ກາ ເຢຊູ ຣຽຮ ໂອນ ເປາະ ຕະ ຣານະ ອັນ. ");
INSERT INTO ncq_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ພໍກາ ແຕີ່ອ໌ ຕາໄງ ຈຸ່ມ ອິດຊະຣາເອລ ຈາ ຣໍ່ອ໌ ຕາໄງ ຕັຮ ຊອດ, ມູ່ ກາ ຕາປູ່ນ ເຢຊູ ເປາະ ໂຣ່ມ ມັນຕຸ. ");
INSERT INTO ncq_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ບັອງ ກາ ໄລ່ ໂຣ່ມ, ໄລ່ ຊັນຕັຣ ຊັອງ ຊຽງ ແຕ ມັນລັ່ອງ ນ່ະ ຊຽງ ກູຢາລ ຣາປູ່ອ໌. ຊຽງ ໄນ່ ມູ່ດ ປຼັຮ ອຶນແຍ່ະ ຕຶ່ງ ກຼຸງ ດຸງ ໄລ່ ຕາກູ. ");
INSERT INTO ncq_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ໄລ່ ເຮີມ ປັຣລາ ອູ່ຍຮ ຣາຕັຮ ແກີດ ນ່ະ ຣູ່ບ ເລືາຍຮ ເຈີ່ ແຕັດ ແອີດ ຕຶ່ງ ຈະ ກວາຍ ກູ່ ນະ. ");
INSERT INTO ncq_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ພໍກາ ກັອຍ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ມູ່ດ ຕະ ຊົດ ຕຶ່ງ ຣາງຶ່ຮ ໄລ່. ກະ ມັຮ ກວາຍ ກັອຍ ຕາແບິ ຕະ ອຶນຕີ ຊາອຶ່ຍ ປັຣນາຍ ກວາຍ ການໍ່ອ໌ ແອັນ, ຍ່ອນ ຣາເວືາຍ ເຢືາງ ເຈົາຣາຊີ ໂອນ ໄລ່ ເຕ່ອ໌ ປາຍ. ");
INSERT INTO ncq_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ຕາໄງ ກັອຍ, ແອີດ ຕຶ່ງ ເມືອງ ເຢຣູຊາເລັມ ເບີນ ກວາຍ ອິດຊະຣາເອລ ແຕ ອຶນແຍ່ະ ມັຮ ກຣວາງ ປື່ນ ມັນລັ່ອງ ກຣຸ່ ເປາະ ໂຣ່ມ ປໍ ກັອຍ. ໄລ່ ກັອຍ ຕາປູ່ນ ຄານອດ ເຢືາງ ເຈົາຣາຊີ ກຣັ່ກ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ພໍກາ ໄລ່ ຊັອງ ຊຽງ ກັອຍ, ກຼຶ່ງ ກວາຍ ເປາະ ໂຣ່ມ ປໍ ດຸງ ມູ່ ກາ ຕາປູ່ນ ເຢຊູ ແອີດ. ກູ່ ນະ ກວາຍ ກັອຍ ຊັອງ ເນົ່າ ຕະ ອຶນຕີ ນ່ະ ປັຣນາຍ ໄລ່ ເບີມ; ເຈີ່ ໄລ່ ຊັອງ ງຶ່ດ ລາລື່. ");
INSERT INTO ncq_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ໄລ່ ຊັອງ ຊັນຕັຣ, ກະ ໄລ່ ປາຍ: \"ມັຮ ກວາຍ ກາ ອາຕີ ໄນ່, ໄລ່ ລາ ກວາຍ ຄາລີເລ ອຶນແຍ່ະ. ");
INSERT INTO ncq_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ມາ ນານ່ະ ແຕ ໄຮ ຊັອງ ໄລ່ ຕະ ອຶນຕີ ປັຣນາຍ ແຕ ອຶມເປ່ອ໌ ອຶມປໍ່ ໄຮ ເບີມ? ");
INSERT INTO ncq_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ໄຮ ລາ ກວາຍ ແຕ ຊາອຶ່ຍ ກຣວາງ. ເບີນ ກວາຍ ແຕ ກຣວາງ ປາເທຍ, ເມເດຍ, ເອລາມ, ເມໂຊໂປຕາເມຍ, ຢູດາຍ, ກາປາໂດເກຍ, ປົນໂຕ, ເອເຊຍ, ");
INSERT INTO ncq_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ພີເຄຍ, ປໍາພີເລຍ, ເອຢິບ, ກະ ລີເບຍ ແຈ່ະ ກີເຣເນ. ກະ ເບີນ ກວາຍ ຕາມອຍ ແຕ ເມືອງ ໂຣມ ແຮີ. ");
INSERT INTO ncq_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ມວຍ ຈຸ່ມ ລາ ໄຮ ກວາຍ ອິດຊະຣາເອລ, ມວຍ ຈຸ່ມ ລາ ກວາຍ ການໍ່ອ໌ ກາ ປຣ່ອມ ຕາປູ່ນ ຄານອດ ອິດຊະຣ