﻿USE sofia;
DROP TABLE IF EXISTS sofia.nclNT_vpl;
CREATE TABLE nclNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nclNT_vpl WRITE;
INSERT INTO nclNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Nican unca lajcuiluli itajtzitzían Jesucristo. Yihual yec imiahuil David hual yec imiahuil Abrahám. ");
INSERT INTO nclNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham yec itajtzin Isaac, Isaac yec itajtzin Jacob, Jacob yec inmintajtzin Judá huan icnían. ");
INSERT INTO nclNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá yec inmintajtzin Fares huan Zara, huan Tamar yec inminantzin. Fares yec itajtzin Esrom, Esrom yec itajtzin Aram. ");
INSERT INTO nclNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram yec itajtzin Aminadab, Aminadab yec itajtzin Naasón, Naasón yec itajtzin Salmón. ");
INSERT INTO nclNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón yec itajtzin Booz, huan inantzin Booz yec Rahab. Booz yec itajtzin Obed huan Obed inantzin yec Rut. Obed yec itajtzin Isaí. ");
INSERT INTO nclNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí yec itajtzin David in hué. David monamictic ca se sihual hual mocahuac ihuían pampa polehuic ilahuical itocaya Urías. Cuaquinon David huan in sihual quipialoaya se xolol hual quitocayaltic Salomón. ");
INSERT INTO nclNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón yec itajtzin Roboam, Roboam yec itajtzin Abías, Abías yec itajtzin Asa. ");
INSERT INTO nclNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa yec itajtzin Josafat, Josafat yec itajtzin Joram, Joram yec itajtzin Uzías. ");
INSERT INTO nclNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías yec itajtzin Jotam, Jotam yec itajtzin Acaz, Acaz yec itajtzin Ezequías. ");
INSERT INTO nclNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías yec itajtzin Manasés, Manasés yec itajtzin Amón, Amón yec itajtzin Josías. ");
INSERT INTO nclNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías yec inmintajtzin Jeconías huan icnían hual yulinijme quiman in babilontecos quinhuicaloaya in judíos lailpili pa in lali Babilonia. ");
INSERT INTO nclNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Quiman quinhuicaje pa Babilonia, Jeconías quipíac se ixolol motocaya Salatiel, Salatiel yec itajtzin Zorobabel. ");
INSERT INTO nclNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel yec itajtzin Abiud, Abiud yec itajtzin Eliaquim, Eliaquim yec itajtzin Azor. ");
INSERT INTO nclNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor yec itajtzin Sadoc, Sadoc yec itajtzin Aquim, Aquim yec itajtzin Eliud. ");
INSERT INTO nclNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud yec itajtzin Eleazar, Eleazar yec itajtzin Matán, Matán yec itajtzin Jacob. ");
INSERT INTO nclNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob yec itajtzin José hual yec ilahuical María. María yec inantzin Jesús in hual quitocayaltilo Cristo. ");
INSERT INTO nclNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yoje, quiman lacatic David, ca inon lacatijtihualaje catorce imiahuimes Abrahám. Cuaquín lacatijtihualaje catorce imiahuimes David quiman quinhuicaje pa Babilonia. Huan quiman lacatic Cristo yoje lacatijtihualaje oc sequin catorce imiahuimes David hual pehuaje lacatijtihualaje quiman quinhuicaje pa Babilonia. ");
INSERT INTO nclNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Axcan, yoje unca quinami lacatic Jesucristo. María, se sihual yancuic hual yahuiaya ye inantzin, yahuiaya monamicti ca José. Huan ayamo yuliloaya quinami ilahuical ca isihua quiman quitaje pampa yahuiaya quipía se xolol María pan ipampa in Espíritu Santo. ");
INSERT INTO nclNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José hual yahuiaya ye ilahuical yec se lacal cuali huan yultiahuiaya quichihuilijtataya moxtin in hual cuali. Huan amo quinequiaya pa moxtin quipinahuilijtinemilosquiaya María. Pampín quijtuc pa iyolo pampa yahuiaya quicahua huan amo yahuiaya quimachiltili inon amaqui. ");
INSERT INTO nclNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Huan quinami quijtutataya pa iyolo yihual in hual yahuiaya quichía, xiquita, cochic José. Cuaquín nesic capa yihual se ca ilanahuatinijmes Dios pin cielo (ilhuicac), quitac quitemictataya, quilijtataya: —José, tel imiahuil David, amo xiquijtu pa moyolo pampa amo unca cuali pa ticanas María pa yes mosihua, (pampa in Espíritu Santo quilalilic ca laijtic María in hual quilacatiltis). ");
INSERT INTO nclNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Huan yahui quipía se xolol lacal. Tictocayaltis Jesús, pampa yihual quinquixtilis inminlaijlaculisli yehuanten hual cate iyaxca. Yoje quilic ilanahuatini in cielo. ");
INSERT INTO nclNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Huan mochíac mochi inon pa yoje panusquiaya mochi hual quijtuc in Tata pan ipampa ilajtuni hual quijtuc, quil: ");
INSERT INTO nclNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Xiquitacan. Cayas se sihual yancuic hual amo quiman cataya ca se lacal. Ma yojque, quipías se ixolol. Quilacatiltis huan quitocayaltisqui Emanuel. In lajtol quinequi quijtúa: Dios unca ca tehuanten. ");
INSERT INTO nclNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ejsac José, quichíac quinami quilic in Tata ilanahuatini pin cielo. Canac María pa yes isihua. ");
INSERT INTO nclNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Yuliloaya pin se cali yehuanten omenten. Ma yoje, José amo yulic ca yihual quinami ilahuical pa innojen tonalijmes hual ayamo lacatic ixolol María. Quiman lacatic in xolol, José quitocayaltic Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Lacatic Jesús pin caltilan Belén pin lalticpan Judea. Lacatic pa innojen tonalijmes quiman Herodes yec inminhué in judíos. Huan ajsije pa in caltilan hué Jerusalén lacames hual quimatiloaya niman míac. Chantiloaya pa se lali huejca hual unca capa quisa in tonali. ");
INSERT INTO nclNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Quilajlanije: —¿Capa unca yihual hual lacatic, yihual hual inminhué in judíos? Ticmatilo pampa lacatic, pampa tiquitaje yihual ilucero (isilalin) nepa capa quisa in tonali. Ca in ticmatilo pampa lacatic, huan tihualaje pa ticmolancuacuetzilisi —quilije. ");
INSERT INTO nclNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Quiman quimatic Herodes in hué in hual quijtuloaya innojen lacames huejueyenten, yajmo huil mosehuiaya yihual huan noje yajmo huil mosehuiloaya niman míac ca yehuanten pa Jerusalén. ");
INSERT INTO nclNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Cuaquín quilic pa monechicusi moxtin in tiopistas huejué huan in lamaxtinijmes hual quimaxtiloaya in lajtol hual quinnextilo in judíos quinami quimolancuacuetzililo Dios. Monechicuje, quinlajlanic Herodes capa yahuiaya lacati in Cristo. (Cristo quinequi quijtúa in se hual unca laxahuilili pa itzontecon. Yoje quichihuililo se lacal quiman yahuilo quitemachilo pa yes inminhué yehuanten.) ");
INSERT INTO nclNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Yehuanten quinanquilije: —Lacatis pin caltilan Belén pin lalticpan Judea, yoje quijcuiluc Dios ilajtuni. Quijtúa, quil: ");
INSERT INTO nclNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Tehual, Belén, pin lali Judea, quimatisi momajtisi mopampa tehual. Mas que tiunca se caltilan tipichin, ma yoje yajmo mitzitasi quinami in niman tipichin, pampa quisas nepa pa tehual se hual yes mohué. Yihual huelitis ca yehuanten ilacames Israel hual cate noyaxca. Yoje quijtúa Dios ilajtol pan ipampa Dios ilajtuni. ");
INSERT INTO nclNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Cuaquinon Herodes latilanic pa hualalosquiaya in huéjueyenten, quinnahuatic pa yoje amaqui quimatisquiaya quiman hualaje. Huan quinlajlanic ca míac lajtomes jan quiman nesic in lucero (silalin), huan yehuanten quilije quiman nesic. ");
INSERT INTO nclNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Cuaquinon quinmilic: —Xiacan, xictemucan cuali pa anquitas in xolol. Xictemucan yoje quinami anquimati anlatemúa. Quiman anquitas, xinechmachiltican pa yojque nehual nías nicmolancuacuetzilis noje —quinmilic. Cuaquinon quintilanic pa Belén. ");
INSERT INTO nclNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Canaje ojli in huéjueyenten quiman quicaquije in hual quinmilic in hué. Cuaquinon nesic in lucero (silalin) hual quitaje quiman cataloaya pa inminlali hual unca capa quisa in tonali. Quinlaicanac in silalin, uyajtíac huan ajsic moquetzac ca pani pin cali capa cataya in xolol. ");
INSERT INTO nclNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Quiman quitaje in silalin, quipiaje niman míac paquilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Calaquije pin cali calijtic huan quinmitaje in xolol ca María inantzin. Cuaquinon quimolancuacuetzilije huan quimahuisuje in xolol. Huan quilapuje inminxotopajmes capa quihualicatihualaje len ipatiaya míac. Quimacaje oro huan ajuialisli huan je altzindi hual ajuíac, itoca mirra. ");
INSERT INTO nclNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Cuaquinon pan ipampa lajtemiquilisli Dios quinmilic pa camo mocuepasi capa Herodes. Pampín canaje oc se ojli pa mocuepasi pa inminlali. ");
INSERT INTO nclNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Huan quiman quisaje in huejueyenten, nesic ilanahuatini toTata pin cielo ca José. Nesic pan ipampa lajtemiquilisli, quilic: —Ximoquetza, xiquinhuica in xolol huan inantzin, xicholucan pa in lali Egipto. Xichantican umpa huan quiman panusi tonalijmes nimitzilis pa anmocuepas. Xicholucan, pampa Herodes axan yahui quitemúa in xolol pa quimictis. ");
INSERT INTO nclNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Cuaquinon pa in layúa moquetzac José, quinhuicac in xolol huan inantzin, quisaje cantiaje ojli pa in lali Egipto. ");
INSERT INTO nclNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Huan umpa cataloaya pa mochi tonalijmes hual yuliaya Herodes. Yojque panuc pa mochiasquiaya len quijtuc toTata pan ipampa ilajtuni. Quijtuc, quil: “Nicnotzac noxolol pa quisas nepa Egipto.” ");
INSERT INTO nclNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Cuaquinon, cualanic niman míac Herodes quiman quimatic quinami quihuitzquilije in huejueyenten. Pampín latilanic pa quinmictilosquiaya mochi in xolomes lacames hual cataloaya pa Belén huan mochi in calimes hual cataloaya itenco Belén. Quinmictije mochi in xolomes lacames hual lamije lacatije huan moxtin oc sequin xolomes hual lacatije huan ayamo ajsije quipiaje ome xixihuil huan moxtin hual lacatije huan axan ajsije quipiaje ome xixihuil. Latilanic pa quinmictilosquiaya jan innojen xolomes, pampa in huejueyenten quilije pampa pehuac nesic in silalin quipiaya quinami ome xixihuimes. ");
INSERT INTO nclNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Yoje lamic mochíac len quijtuc Dios ilajtol pan ipampa ilajtuni Jeremías, quijtuc, quil: ");
INSERT INTO nclNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Pin caltilan Rama icnotialoaya. Mocaquiaya lajtol ca niman míac icnotilisli, chocalisli, quincocuhuaya inminyolo, Raquél quinchoquilijtataya ixolomes, huan amo quinequiaya molacahualti, pampa polehuije ixolomes. ");
INSERT INTO nclNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Quiman miquic Herodes, xiquita, nesic capa José pin lali Egipto se ilanahuatini in Tata pin cielo. Nesic pan ipampa lajtemiquilisli, quilic: ");
INSERT INTO nclNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Ximoquetza, xiquinhuica in xolol huan inantzin huan ximocuepacan pa in lali Israel. Axan miquije yehuanten hual quinequiloaya quimictilo in xolol. ");
INSERT INTO nclNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yojque, moquetzac José, quinmanac in xolol huan inantzin in xolol huan mocuectiaje pa in lali Israel. ");
INSERT INTO nclNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pa ojli, quimatic pampa Arquelao huelitijtataya pin lalticpan Judea capa huelitini itajtzin Herodes. Pampín momajtic José pa mocuepas ca umpic. Cuaquín Dios quilic pan ipampa lajtemiquilisli pampa nepa cayasquiaya polehuilisli, huan pampín uyajtiaje José huan María ca ixolol pa in lalticpan Galilea. ");
INSERT INTO nclNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ajsije umpa, uyaje chantije pa se caltilan itoca Nazaret, pa yojque mochiasquiaya len quijtuc Dios pan ipampa ilajtuni. Quijtuc, quil: “Quitocayaltisi nazareteco.” ");
INSERT INTO nclNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Panuje míac xixihuimes. Huan ajsije in tonalijmes quiman hualac Juan Lacuayatequini quinnoztataya moxtin hual quisaje pa quicaquisi. Quinnotzaya quinmilijtataya Dios ilajtol. Quinnotzaya nepa pa se ilajco in lalticpan Judea capa in lali amo cataya cuali pa quitocasquiaya se icuajmili. ");
INSERT INTO nclNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Huan quinmiliaya: —Xicpalacan anmoyolo, ximolalilican pa anlaijnamiquis pa anmoyolo quinami Dios laijnamiquía, pampa amo huejcahuas ajsis in tonali quiman huelitía Dios. ");
INSERT INTO nclNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","In Juan Lacuayatequini yec in lacal hual aqui quijtuc inahuac yihual Isaías ilajtuni Dios. In Isaías quijcuiluc se amal pa yina, huan pa iamal yojque quijtuc: Mocaqui ilajtol se hual lanoztica nepa pa in lali capa amo unca cuali pa quitocasquiaya se icuajmili. Huan in se quijtutica, quil: “Xicchipahuacan anmoyolo pa calaquis in Tata, xiclapulican jan quinami anquilapulía ojlimes quiman hualas capa amhuanten se hual unca hué.” ");
INSERT INTO nclNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Huan quipiaya yihual Juan ilaquen lachihuali ca itojmiyo camello, huan ilacuejtiloni cataya lachihuali ca cuilaxli. Quincuaya chapulimes huan néculi hual moita pa cuajlan. ");
INSERT INTO nclNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Hualaloaya capa yihual pa quicaquilosquiaya yehuanten hual chantiloaya pa Jerusalén. Huan quistihualaloaya lacames huan sihuames mochi cajcapa pin lalticpan Judea. Huan quistihualaloaya mochi in lali hual cataya pa itejtenco in atenco hué itoca Jordán. ");
INSERT INTO nclNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Huan quincuayatequiaya Juan pin atenco hué Jordán, quiman moyolcuitije inminlaijlaculisli inminlaixpan moxtin, quijtuticate pampa yajmo yahuiloaya yulilo quichijticate laijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ma yoje, quinmitac Juan míac lacames hual quitocaloaya in ome lamaxtilisli calica quimolancuacuetzililoaya Dios in judíos, motocaloaya fariseos huan saduceos. Hualaloaya pa yihual quincuayatequisquiaya. Huan quinmilic: —¡Ah, amhuanten ixolomes Satanás! Anunca quinami cuhuames cholujticate pa se cuajmili chichinajtica. Huan ¿aqui anmitzilic pampa anunca pin ipolehuilisli icualanilisli Dios hual ajsitihuala? ¿Aquinojen anmitzilije pa ancholusquiaya? ");
INSERT INTO nclNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Amo annimitzcuayatequis sinda amo anyahui anpehua anyuli yoje pa lanextilis pampa anquipalac anmoyolo huan axan anlaijnamiquía quinami Dios quinequi. ");
INSERT INTO nclNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Huan amo xiquijtucan pa anmolaijtic amhuanten: “Tehuanten ticate imiahuimes totajtzin Abraham hual pa yina techpehualtic tehuanten in judíos. Pampín amo timomajtilo pampa Dios cualanía.” Amo xiquijtucan yoje, pampa annimitzilía Dios huil quinchía miahuimes pa Abraham lachihuali ca innojen tixcalimes nican. ");
INSERT INTO nclNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Axan unca quinami Dios quilalijtica in hacha pa ilalhuayol se cuahuil. Amhuanten anquinami cuahuimes hual amo laquilo cuali. Yoje, mochi cuahuil hual amo laqui cuali yes lamayahuili huan yes lalasali pin tixuxli. Yoje mochi lacal hual amo quichía cuali cayas quinami se ca innojen cuahuimes hual amo laquilo cuali. ");
INSERT INTO nclNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nehual neli annimitzcuayatequía ca al pa yoje lanextilis pampa anquinpalac anmoyolo pa anpehuas anlaijnamiquis quinami Dios. Ma yoje, yihual hual yahui huala quiman nilantica notequipanulisli unca niman hué. Nehual amo quiman niyes yoje hué. Pampín amo unca noyaxca pa niyes itequipanujquil niman tipichin. Yihual anmitztilanís in Espíritu Santo. Inon ilacuayatequilisli yihual. Yes quinami tixuxli hual amo lachichinus. Calaquis laijtic anmoyolo, anmitzpujpuhuas anmitzquixtilijtica len yes amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yihual cayas quinami se hual quitzejtzelujtica layoli pa yoje quisas chipác. Quema, quichipahuas niman cuali yehuanten hual Dios quinlajtultic. Cayas quinami se hual quinechicúa in layoli pa capa cajcoquilo, huan quichichinus in xiníul pin tixuxli hual amo quiman huil mosehuis. Yehuanten hual Dios quinlajtultic cate quinami in layoli, huan yehuanten hual amo quinlajtultic cate quinami in xiníul. ");
INSERT INTO nclNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Cuaquinon ajsitihualac Jesús, quisac pin lalticpan Galilea. Ajsiaya pa atenco hué Jordán capa cataya Juan. Quinequiaya pa Juan quicuayatequisquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juan pehuac quilic Jesús pampa amo canaya cuali pa yihual quicuayatequisquiaya Jesús, Juan quilic: —Monequi pa tehual tichcuayatequis nel. ¿Leca tihuác ca nel pa nimitzcuayatequisquiá? ");
INSERT INTO nclNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesús quinanquilic: —Ma ye jan yoje axan, pampa unca cuali pa yoje ticchihuasi mochi hual Dios techilía pa ticchihuasi. Cuaquinon Juan quimacahuiltic pa hualasquiaya pa yihual quicuayatequisquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Huan Jesús, quiman cataya lacuayatequili, quisac jan ajnaxcan nepa pin al. Huan jan ajnaxcan in cielo (ilhuicac) molapuc ca pani capa Jesús huan yihual quitac Dios iEspíritu (iIjyecal Cuali) temujtihualaya. Nestihualaya quinami se huilol. Ajsic huan moquetzac pani capa yihual Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Huan ca inon mocaquic se lajtol pin cielo hual quijtuc: —In unca noxolol hual niclasojla míac. Ca yihual nimopaquiltitica niman míac. ");
INSERT INTO nclNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Cuaquinon in Espíritu Santo quilaicanac Jesús pa panquisasquiaya ca capic amaqui chantiaya. Quilaicanac nepa pa yojque in lili quitilanilisquiaya Jesús iyolo. ");
INSERT INTO nclNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Mosahuac Jesús cuarenta tonalijmes huan cuarenta layuajmes, huan quiman panuc inon, yihual mayanaya. ");
INSERT INTO nclNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Hualac capa Jesús in lili hual quintilanilía lacames inminyolo, quilic: —Sinda tehual tiunca Dios ixolol, cuaquín xiquinmili in tixcalimes pa mochihuasi len huil tijcuas. ");
INSERT INTO nclNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesús quinanquilic: —Unca lajcuiluli: “Lacames amo yulisi jan pan ipampa in hual quicualo san. Yulisi pan ipampa mochi lajtol hual quijtúa Dios.” ");
INSERT INTO nclNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Cuaquinon in lili quihuicac Jesús pa Jerusalén hual unca Dios ilasojli caltilan hué, quilejcultic niman ca pani in tiopan hué. ");
INSERT INTO nclNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Huan quilía: —Sinda tiꞌixolol Dios, cuaquín ximolasa pa latzindan, pampa unca lajcuiluli: Yihual Dios quinmilis ilanahuatinijmes pin cielo pa mitzlachilisi. Huan ca inmajmajuan mitzpalehuisi tehual pa camo timotecuilis se mocxían pan se tixcali. ");
INSERT INTO nclNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","—Huan noje unca lajcuiluli —quilic Jesús—: “Amo timocalactis capa cuajnesi tipolehuis san pa tiquitas sinda Dios moTata mitzquixtilis pin polehuilisli.” ");
INSERT INTO nclNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Huan oc sejpa quihuicac Jesús in lili pa pani se loma (tepel) niman cuajtic. Quinextilic Jesús mochi in lalimes pin lalticpan capa huelitilo in huejueyenten, huan quinextilic mochi hual unca cuajcualtichin pin lalimes. ");
INSERT INTO nclNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Huan in lili quilic: —Mochi innojen nimitzmacas tehual sinda tichmolancuacuetzilis pa tichmahuisus ca lamajtilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Cuaquinon Jesús quilic: —Xiquisa, Satanás, pampa unca lajcuiluli inon: “Ticmolancuacuetzilis pa ticmahuisus ca lamajtilisli moTata Dios. Jan Yihual san ticchihuilis mochi hual monequi pa ticmolancuacuetzilis.” ");
INSERT INTO nclNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Cuaquinon in lili quicahuac Jesús. Huan axan hualaje ilanahuatinijmes in cielo, pehualoaya quichihuililo mochi hual monequiaya pa quipías Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Axan, quiman quimatic Jesús pampa quitzacuaje Juan Lacuayatequini pin calijtic, uyac pa ichan pin caltilan Nazaret hual unca pin lalticpan Galilea. ");
INSERT INTO nclNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Cuaquín ca je nadita quicahuac ichan nepa Nazaret, uyac chantic pin caltilan itocaya Capernaum hual cataya pa itenco in al huejcalan Galilea. Noje cataya inmintejtenco in lalimes itocaloaya Zabulón huan Neftalí. ");
INSERT INTO nclNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Uyac chantic Jesús nepa pa yoje mochías len quijcuiluc Isaías hual pa yina yec Dios ilajtuni. Quijtúa pa iamal: ");
INSERT INTO nclNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Pin lali itoca Zabulón, huan pin lali Neftalí, pan ojli hual laicana pa in al huejcalan, ca yojque itenco (analco) in atenco hué Jordán, unca pin lali Galilea capa chantilo yehuanten hual amo judíos. ");
INSERT INTO nclNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Yehuanten hual chantilo capa amaqui quimati quinami Dios quinequi pa yulis se, axan yehuanten quimatilo cuali quinami Dios quinequi pa yulisi, axan quipialo lahuilisli pa inminyolo laijtic. Quema, yehuanten hual chantilo capa amo quimatilo Dios ilajtol melahuac huan yoje mocahualo moxilujticate capa Dios, axan quimatilo aqui unca Dios huan quimatilo quinami huil quipialo in yulilisli hual yihual quinequi pa quipiasqui. ");
INSERT INTO nclNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Cuaquín pejtiahuiaya nahuati Jesús inminyampa yehuanten, quinmilijtinemiaya: —Xicpalacan anmoyolo huan xipehuacan xilaijnamiquican quinami Dios quinequi, pa yajmo anmoijlacus. Unca pampa axan ajsic in tonali quiman Dios ilahueliltilisli pin cielo yahui caya lanextili nican pan lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nejnemiaya Jesús inahuac in al huejcalan Galilea. Quinmitac ome lacames, se motocaya Simón hual noje quitocayaltiloaya Pedro. In oc se motocaya Andrés, yihual icni Simón. Yehuanten quilastataloaya se latzojuini palahuac pa in al huejcalan, pampa yehuanten yeje micheros. ");
INSERT INTO nclNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Huan Jesús quinmilic: —Anquinmantica michimes. Xichtocacan nehual pa anmochías nomonextilinijmes. Annimitznextilis quinami anquinmanas lacames pa nechneltocasi. ");
INSERT INTO nclNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Huan jan axcan quincajcahuaje inminlatzojuini huan quitocaje. ");
INSERT INTO nclNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Cuaquín uyac Jesús jan nadita huejquita capa cataya. Quinmitac oc sequin ome lacames. Se yec icni in oc se. Se motocaya Jacobo huan in oc se icni motocaya Juan, yehuanten ixolomes Zebedeo. Huan Zebedeo inmintajtzin cataloaya pan se barquito laijtic, quinchijchihualoaya inminlatzojuinijmes. Jesús quinnotzac Jacobo huan Juan. ");
INSERT INTO nclNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jan ajnaxcan yehuanten quincahuaje in barco huan inmintajtzin, huan quitocaje Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Uyajtíac Jesús pa mochi in lalticpan Galilea, lamaxtitataya pa inmintiopajmes yehuanten pa Galilea. Quimachiltitataya in lamachiltilisli cuali, in unca quinami Dios huelitía. Huan quinpajtitinemiaya mochi inmincocolisli yehuanten, huan mochi in hual quincocuhuaya. ");
INSERT INTO nclNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yoje quimatije in hual quichihuaya yihual moxtin yehuanten pin lali Siria hual unca pa quiahuac Jesús ilali. Huan yehuanten quihualiquilije moxtin in cocoxquimes hual quincocuhualoaya míac cocolisli, míac ca yehuanten mococuhualoaya niman míac. Quihualiquilije yehuanten hual quinpialoaya ijyecames hual quincocoltiloaya huan quihualiquilije yehuanten hual cataloaya laticocojquimes huan yehuanten hual amo huil moliniloaya. Huan quinpajtic Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Yoje quitocaje niman míac lacalera hual chantiloaya pin lalticpan Galilea huan pin lali capa cataloaya in diez (majlacli) caltilan hual quitocayaltiloaya Decápolis. Quitocaje míac hual chantiloaya pin caltilan hué Jerusalén huan pin lalticpan Judea huan pin lali pa yojque itenco (analco) in atenco hué Jordán. ");
INSERT INTO nclNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yoje, quiman quinmitac Jesús in niman míac lacalera, panquisac pan se loma (tepetzindi). Molalic nepa, huan hualaje capa yihual imonextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Pehuac quinmaxtic, quinmilic: ");
INSERT INTO nclNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Quipialo paquilisli yehuanten hual quimatilo pampa amo quipialo nindeno calica huil quipaquiltilo Dios. Quema, yulilo ca paquilisli, pampa lacames quinami yehuanten cayasi capa yes Dios huelitía. ");
INSERT INTO nclNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Quipialo paquilisli yehuanten hual quincocúa inminyolo pampa unca mochi amo cuali pin lalticpan. Quema, yulilo ca paquilisli, pampa yehuanten Dios quinlacahualtis. ");
INSERT INTO nclNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Quipialo paquilisli yehuanten hual amo motolinilo pa canasi inminyaxca, pampa yehuanten Dios quinmacas in lalticpan pa yes inminyaxca capa huelitisi. ");
INSERT INTO nclNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Quipialo paquilisli yehuanten hual quinequilo ca mochi inminyolo pa yesi cuali huan pa quichihuasi len unca cuali, pampa Dios quinhueliltis pa yoje yesi. ");
INSERT INTO nclNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Quipialo paquilisli yehuanten hual quimatilo laicnililo, pampa yehuanten quinmicnilis Dios. ");
INSERT INTO nclNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Quipialo paquilisli yehuanten hual cate chipahuac pa inminyolo, mochi ca se lajtulisli ca Dios huan ca mochi hual Yihual quinequi. Quema, yulilo ca paquilisli, pampa yehuanten quitasi Dios. ");
INSERT INTO nclNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Quipialo paquilisli yehuanten hual quinnextililo oc sequin quinami huil cayasi jan sejpa se ca oc se, yajmo moanticate. Quema, yulilo ca paquilisli, pampa Dios quinmilis pampa yehuanten Dios ixolomes, pampa quichihualo quinami Yihual quichía. ");
INSERT INTO nclNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Quipialo paquilisli yehuanten hual lacames quintojtocalo pa quinchihuilisi amo cuali pampa yulilo quichijticate in hual Dios quinequi. Quema, yulilo ca paquilisli pampa lacames hual yulilo quinami yehuanten cayasi capa yes Dios huelitía. ");
INSERT INTO nclNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Anquipía paquilisli quiman anmitzcocolilo huan anmitztojtocalo huan islacatilo quijtuticate míac amo cuali anmonahuac amhuanten pampa annechneltoca nehual. Quema, anyuli ca paquilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Xipaquican, xicpiacan niman míac paquilisli, pampa pin cielo anyahui ancana niman míac hual cuali. Anquimati pampa yoje quintojtocanijme Dios ilajtunijmes hual yulinijme pa yina quiman ayamo anlacatic amhuanten, huan unca neli yehuanten canaje laxlahuilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Amhuanten anunca quinami istal hual quilalilo pin nacal pa quitechcunis pa quitzacuilis pa camo moijlacus. Jan yoje amhuanten Dios anmitzlalic pa anquintechcunis pa ilacames pin lalticpan pa yoje anquintzacuilis pa camo moijlacusi. Huan sinda in istal mochías pataca, cuaquín ¿quinami mochías istal oc sejpa? Amo huil, yajmo unca cuali pa nindeno. Quilasalo pa quiahuac huan in lacames quitelicsalo. ");
INSERT INTO nclNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Jan amhuanten san anunca quinami in lahuilisli hual quilahuilía inminyolo yehuanten pin lalticpan. Jan yoje amhuanten anquinlahuilía inminyolo quinami anquinmaxtía Dios ilajtol. Huan anquinlahuilía inminyolo pampa yojque anyulis quinami Dios quinequi. Quinami se caltilan hual unca pani pan se loma (tepel) amo huil molatía, jan yoje in lahuilisli amo huil molatía. ");
INSERT INTO nclNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Huan amo quilalaltilo lacames se tapalquita huan cuaquinon quilalilo itzindan se chiquihuil hué. Quilalilo pa pani, huan quinlahuis moxtin hual cate calijtic. ");
INSERT INTO nclNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ximomacahuiltican pa quimatisi lacames pampa anyuli quinami Dios ilajtol quinextilía pa yulis se. Yoje anquinextilis pampa anmitzlahuilic Dios anmoyolo. Yoje quiman quitasi quinami anyuli anquichijtica len unca cuali, cuaquín laquetzasi cuali inahuac anmoTajtzin hual unca pin cielo (ilhuicac). ");
INSERT INTO nclNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Amo xiquijtucan pampa nihualaya pan lalticpan pa niclamis Dios ilajtol huan in hual quimaxtije Dios ilajtunijmes. No, amo nihualaya pa niclamis, nihualaya pa annimitznextilis neli len quinequilo quijtulo. ");
INSERT INTO nclNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Annimitzilía melahuac inon: Amo yes laquixtili se lajtol ca ilajtomes niman tijtipichin pa ilajtol Dios sinda ayamo mochíac mochi hual quijtúa pampa yahui mochía. Quema, cayas yoje pa mochi in xixihuimes hual huejcahuasi in cielo huan in lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yoje, aqui yes amo quinequis quichías len quijtúa se ilajtol Dios jan sinda unca se ilajtol niman tipichin, huan sinda quinmaxtis oc sequin pa camo quichihuasi len quijtúa in lajtol, cuaquín in se yes niman tipichin capa Dios huelitía. Huan aqui yes quichías len quijtúa mochi ilajtol Dios huan quinmaxtis oc sequin pa yoje quichihuasi, cuaquín in se yes hué capa Dios huelitía. ");
INSERT INTO nclNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Xicchihuacan yoje, pampa annimitzilía amhuanten amo quiman ancayas capa Dios huelitía sinda jan anyuli anquichijtica san quinami in fariseos huan yehuanten hual quimaxtilo in lajtol. Ca inminlachihualisli quijtulo pampa inon Dios quinmita amo quipixticate laijlaculisli. Huan inminlachihualisli amo quinpalehuis pa yoje Dios quinmitas. ");
INSERT INTO nclNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Anquicaqui quiman anmitzmomaxtililo quinami Dios pa yina quinmilic totajtzitzían: “Amo tilamictis. Huan aqui yes quimictis oc se, yihual quihuicasqui ilaixpan in laꞌajuani pa quitexpahuisi huan pa quitilanis pa yes lamictili.” ");
INSERT INTO nclNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ma yoje, nehual annimitzilía pampa aqui yes cualanis ca icni, cuaquín yihual quihuicasi ilaixpan in laꞌajuani hué pa quitexpahuisi huan pa quitilanis capa yes lamictili. Huan aqui yes quilis icni: “Amo timonotza nindeno”, yihual quihuicasi ilaixpan in laꞌajuani hué pa quitexpahuisi huan pa quitilanis pa yes lacocoltili. Huan aqui yes quilis icni: “Tehual tiꞌelehuis, ma Dios mitzpolehuilti”, yihual unca pa in ojli hual laicanas pa capa amo mocahua pa chichinahuis. ");
INSERT INTO nclNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Yoje, se tonali ticualicas mohuendi pa capa quilalilo ilaixpan Dios. Nepa jan axcan tiquijnamiquis quinami mocni amo mitziztica cuali pampa yihual quijtúa tel ticchihuilic o tiquilic len amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Pampín ayamo xiclalili Dios mohuendi. Xipehua xicchía inon: Xiajtiquisa pa anmochías jan sejpa huan mocni. Cuaquín ximocuepa, xiclali ilaixpan Dios mohuendi. ");
INSERT INTO nclNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Ximochijtiquisacan ca se lajtulisli ca aqui yes mitzhuicas ilaixpan in laꞌajuani pampa tiquihuiquilía len tomin. Quema, ximochijtiquisacan ca se lajtulisli quiman anunca ca yihual pan ojli. Ma camo ye pa yihual mitztemaca pa in laꞌajuani, huan in laꞌajuani mitztemacas in laquitzquini huan yihual mijtzacuas pin calijtic. ");
INSERT INTO nclNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Annimitzilía neli, amo quiman tiquisas umpa sinda ayamo tilamis ticlaxlahuis, mas que unca in tomin niman tipichin. ");
INSERT INTO nclNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Anquicaquic quiman anmitzmomaxtililo quinami Dios quinmilic totajtzitzían pa yina: “Amo ticanas oc se sihual hual ca yihual amo timonamictic.” ");
INSERT INTO nclNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ma yoje, nehual annimitzilía pampa aqui yes quiztías se sihual pa yoje pehuas quinequis míac pa monilus ca yihual, yoje yihual canac in sihual pa iyolo. ");
INSERT INTO nclNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Huan sinda quiztía moixtololon pa moma cuali len hual mitzlaijlacultía, cuaquín xijquixti huan xiclasa huejca. Sinda san polehuiaya se nadita mocuerpo, neli inon amo yesquiaya polehuilisli hué pa tehual quinami cataya sinda yesquiaya lalasali mochi mocuerpo (monacayo) pin tixuxli hual amo quiman mosehuis. ");
INSERT INTO nclNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Huan sinda mojmosta quichijtía momajma cuali len hual mitzlaijlacultía, cuaquín xijcotona huan xiclasa huejca. Sinda polehuiaya jan se nadita mocuerpo, neli inon amo yesquiaya polehuilisli hué pa tehual quinami cataya sinda yesquiaya lalasali mochi mocuerpo pa capa amo mocahua pa chichinahuis. ");
INSERT INTO nclNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Quijtulo pampa aqui yes quicajcahua isihua, cuaquín ma quimaca se amal hual lanextilis pampa in sihual unca lacajcahuali. ");
INSERT INTO nclNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ma yoje, nehual annimitzilía pampa sinda aqui yes quicajcahuas isihua, yoje yihual quichihualtis isihua pa monilus ca se lacal amo iyaxca sinda monamictis oc sejpa in sihual. Yoje, ma camo quijcuani se lacal isihua. Ma yoje, sinda isihua moniluc ca oc se lacal, cuaquinon unca iyaxca ilahuical pa quicajcahuas isihua. ");
INSERT INTO nclNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Noje, anquicaquic quiman anmitzmomaxtililo quinami Dios quinmilic totajtzitzían pa yina: “Amo tiquilis ilaixpan Dios len hual unca islacatilisli. Len yes tiquilis ilaixpan toTata pampa ticchihuilis, cuaquinon ticpías pa ticchihuilis.” ");
INSERT INTO nclNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ma yoje, nehual annimitzilía amo xiquili nindeno ca lajtol hual amo mopala ilaixpan Dios. Amo xiquili len tía ticchía pan ipampa in cielo, pampa in cielo unca capa Dios huelitía. ");
INSERT INTO nclNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Amo xiquili pan ipampa in lalticpan, pampa in lalticpan unca quinami se icpali capa Dios quinsehuía icxihuajmes. Amo xiquili pan ipampa in caltilan hué Jerusalén, pampa inon icaltilan hué in Niman Hué hual unca Dios. ");
INSERT INTO nclNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Amo xiquili pan ipampa motzontecon, pampa amo huil ticchías jan se motzondi iztac o liltic. ");
INSERT INTO nclNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","San quiman anlananquilía, jan monequi pa anquilis “quema” o “amo”. Xiquilican yoje, pampa len yes oc se lajtol pa in omenten unca lajtol hual anmitzilía in lili. ");
INSERT INTO nclNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Anquicaquic quinami quijtulo: “Sinda se quiquixtilis iixtololon oc se, cuaquín jan yoje quicocoltisi quiquixtilijtica iixtololon in se. Huan sinda se quihuitequis oc se pa icamac huan yoje quisas ilan in oc se, cuaquinon jan yoje quicocoltisi in se quiquixtilijtica noje ilan.” ");
INSERT INTO nclNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ma yoje, nehual annimitzilía inon: Amo xiquihuica pan lahueliltilisli se hual mijchihuilía amo cuali. Niquijtúa aqui yes mijchihuilis len amo cuali, xicmacahuilti pa mijchihuilis oc sejpa in amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Huan sinda se quinequi mitzhuicas ilaixpan in laꞌajuani pa mitzquixtís mocotón, cuaquín xicmacahuilti pa mitzquixtís molaquen noje. ");
INSERT INTO nclNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Huan aqui yes mijchihualtis len, cuaquín xicchihuili len mijchihualtía. Huan quema, amo xicchihuili jan inon san pa in hual mijchihualtis pa ticchihuís, xicchihuili oc sejpa yoje míac. ");
INSERT INTO nclNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Xicmaca yihual hual mitztemachía len. Huan amo xiquili pampa no yihual hual quinequi molanehuía len ticpía. ");
INSERT INTO nclNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Anquicaquic quinami quijtunijme: “Ticlasojlas molasojli huan tijcocolis molacocolini.” ");
INSERT INTO nclNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ma yoje, nehual annimitzilía inon: Xiquinlasojlacan anmolacocolinijmes. Xiquinmilican len cuali yehuanten hual anmitzililo len amo cuali, xiquinchihuilican cuali yehuanten hual amo anmitzixtocalo, huan xiclajlanican Dios pa yehuanten hual anmitztenehualo ca islacatilisli huan anmijchihuililo len amo cuali huan anmitztojtocalo. ");
INSERT INTO nclNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Xicchihuacan yoje pa yoje anyes ixolomes anmoTajtzin hual unca pin cielo. Unca pampa yihual quichía pa quisas itonali pa lacames amo cuajcuali huan pa lacames cuajcuali. Noje quinquiahuilía pani yehuanten hual quichihualo cuali huan yehuanten hual quichihualo amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Sinda anquinlasojla jan yehuanten hual anmitzlasojlalo, ¿len laxlahuilisli ancanas? Nindeno. Quichihualo yoje yehuanten in judíos hual quilajlanilo ilapixcalisli tomin pa in romanos hual huelitilo pan amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Huan sinda anquinchihuilía quinami lajlasojli jan yehuanten san hual cate ca amhuanten, cuaquín jan anquichijtica san quinami oc sequin lacames san. Noje yehuanten hual amo judíos quichihualo yoje. Quema, yehuanten hual amo quiximatilo Dios quichihualo yoje. ");
INSERT INTO nclNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yoje, amhuanten xiyén (xiyecan) quinami anmoTajtzin hual unca pin cielo. Yihual quinlasojla moxtin huan quinequi quinchihuilía cuali moxtin. ");
INSERT INTO nclNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Ximolachilijtiacan pa camo anquinchías innojen cuajcuali inminyampa in lacames jan pa yoje yehuanten anmitzitasi anquinchijtica. Sinda anquichía yoje, amo anmitzmacas laxlahuilisli anmoTajtzin hual unca pin cielo (pa ilhuicac). ");
INSERT INTO nclNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Yoje, quiman yes ticmacas len yehuanten hual amo quipialo míac, amo xilamachiltitinemi pa yoje moxtin quimatisi in cuali hual ticchijtica. Yoje quichihualo yehuanten hual quinequilo nesilo quinami lacames hual quimolancuacuetzililo pa quimahuisusi Dios míac. Ma yoje cate lacuajcuamananijmes. Nesilo yoje cuali huan neli cate amo cuali. Quema, lamachiltitinemilo pin tiopajmes huan pa ojlimes pa yoje lacames laquetzasi cuali pampa yehuanten quinchihualo in cuali. Annimitzilía neli, yehuanten amo quipiasi oc se laxlahuilisli pa in laquetzalisli cuali hual quijtusi lacames inminahuac yehuanten. Amo canasi Dios ilaxlahuilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Tehual quiman ticmacas len yehuanten hual amo quipialo míac, amo ximomacahuilti pa quimatis molasojli niman cuali. ");
INSERT INTO nclNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Xicchía yoje pa yoje amaqui quimatis pampa ticmacac len yehuanten hual amo quipialo. Huan moTajtzin pin cielo quita mochi hual amo quimatilo lacames, huan yihual mitzmacas molaxlahuilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Huan quiman ticlajlanis Dios, amo tiyes quinami yehuanten hual quinequilo nesilo quinami niman lamahuisujquimes ilaixpan Dios. Yehuanten quixtocalo míac pa quilajlanisi Dios moquezticate calijtic pin tiopajmes huan pa inmintenco in ojlimes, pa yoje lacames quinmitasi. Annimitzilía neli, yehuanten axan canaje inminlaxlahuilisli. Inminlaxlahuilisli unca in laquetzalisli cuali yehuanten hual quinmitalo quijtulo quiman quichihualo cuali. Amo canasi Dios ilaxlahuilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Tehual, quiman yes ticlajlanis Dios, xía ca capic ticayas mohuían. Xiclajlani moTajtzin pin cielo hual unca ca tehual quiman tiunca mohuían. Huan moTajtzin pin cielo quicaqui huan quita len ticchijtica, mas que lacames amo quicaquilo huan quitalo. Huan yihual mitzmacas molaxlahuilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Huan quiman yes anquilajlanis Dios, amo xiquijtutinemican oc sejpa huan oc sejpa lajtomes hual amo tiquinpalalo. Yoje quichihualo yehuanten hual amo quineltocalo Dios. Yehuanten quijtulo pampa inmindioses quincaquisi pampa quinmilijticate in lajtomes míac. ");
INSERT INTO nclNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Amo xiyén quinami yehuanten, pampa quimati Dios anmoTajtzin len monequi pa anquipías quiman ayamo anquilajlanic. ");
INSERT INTO nclNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yoje, monequi pa anquilajlanis Dios ca lajtomes quinami innojen: ToTajtzin hual tiunca pin cielo, ma momajtican moxtin pampa motoca unca hué. ");
INSERT INTO nclNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ma ajsi in tonali quiman tihuelitis pa mochi cajcapa, ma mochihua quinami ticnequi pin lalticpan, quinami yoje unca pin cielo. ");
INSERT INTO nclNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Xitechmaca pa tijcuasi hual monequi pa tijcuasi mojmosta. ");
INSERT INTO nclNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Huan xicpujpuhua len yes amo cuali timijchihuilije, quiman tehuanten ticpujpuhuaje yehuanten hual tejchihuilije len amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Huan amo xilamacahuilti pa techajsis len hual tejchihuilis pa timoijlacusi. Quema, xitechmacahuili pa camo techmatoca in se hual amo unca cuali, in lili, pampa unca moyaxca pa tihuelitis huan unca moyaxca mochi lahueliltilisli, huan unca moyaxca in laixpelalisli cualtichin huan in lahueyilisli. Amo mocahuas pa yes yoje. Yojque ma ye. ");
INSERT INTO nclNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Sinda anquinpujpuhuas in lacames hual anmijchihuilije amo cuali, cuaquín anmoTajtzin pin cielo noje anmitzpujpuhuas. ");
INSERT INTO nclNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Huan sinda amo anquinpujpuhuas in lacames hual anmijchihuilije amo cuali, cuaquín amo quinpujpuhuas anmoTajtzin pin cielo in amo cuali hual anquichíac. ");
INSERT INTO nclNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Huan amo inon san. Quiman yes anmosahuas, amo xiyén quinami yehuanten hual quinequilo nesilo niman lamahuisujquimes hual quimolancuacuetzililo Dios míac. Quichihualo pa nesisi inmixco ca míac icnotilisli. Nesilo quinami quincocojtica míac inminyolo, pa yoje monextilisi inminyampa in oc sequin pampa mosajticate. Annimitzilía neli, yehuanten inminlaxlahuilisli unca quiman lacames quinmitalo mosajticate, huan amo canasi Dios ilaxlahuilisli hual yihual temaca. ");
INSERT INTO nclNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Huan tehual, quiman timosajtica, ximotzicahuasti huan ximoixpaca quinami ticchía mojmosta. ");
INSERT INTO nclNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Yoje amo timonextilis ca oc sequin lacames pampa timosajtica. Ma yoje, quiman timosahuas, mas que amo mitzizticate lacames, Dios moTajtzin mitzitas. Huan Dios moTajtzin hual quita len ticchía quiman tiunca mohuían mitzmacas molaxlahuilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Amo xiyulican anmajcoquilijtica innojen hual ipatilo míac nican pan lalticpan. Nican pan lalticpan quinmijlaculo in ocuilimes, noje palanilo huan moaxixalo. Noje lahuajuanalo in laixtequinijmes pa calaquisi capa cate pa yoje quinmixtequilisi. ");
INSERT INTO nclNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Quema, ximajcoquilijtiacan pin cielo len Dios quijtúa pampa monotza míac. Mochi in cuali hual anquichía pan lalticpan Dios quijnamiquía huan anmitzajcoquilía anmolaxlahuilisli pin cielo. Nepa amo quinmijlaculisi in ocuilimes, amo palanisi, amo moaxixasi, huan amo lahuajuanasi pa calaquisi pa quinmixtequilisi. ");
INSERT INTO nclNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Quema, ximajcoquilican pin cielo len Dios quita ipati míac, pampa capa yes anquipías laꞌajcoquili len amhuanten anquijtúa pampa ipati míac, yoje anyulis anquijnamictica capa unca. ");
INSERT INTO nclNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Pan ipampa iixtololon se, yihual quita in lahuilisli, huan ca iixtololon huil lachía pa quichía mochi. Yoje, sinda unca cuali moixtololon, cuaquín huil ticchía cuali mochi pampa tiunca mochi pin lahuilisli. Huan jan yoje moyolo mitzlahuía molaijtic. Sinda unca cuali moyolo, ticmatis len yes Dios quita pampa monotza pa quichías se huan yoje ticchías. ");
INSERT INTO nclNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Huan sinda unca cocoxqui moixtololon, cuaquín unca quinami unca pin laticumac mocuerpo (monacayo). Huan jan yoje sinda moyolo amo mitzlahuilía molaijtic, amo ticmatis len yes Dios quita pampa monequi pa yulis quichijtica se. Cuaquín tiunca pin laticumactilisli hual unca niman amo cuali. Yojque, ¡niman amo cuali yes molaticumactilisli sinda amo unca cuali moixtololon! ");
INSERT INTO nclNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Se tequipanujquil amo huil quintequipanuilía ome itecojuan. Unca pampa yihual quicocolis in se huan quilasojlas in oc se, o quitequipanuilis cuali in se huan quixijxicus in oc se. Huan amhuanten jan yoje amo huil anquitequipanuilis Dios sinda anyuli anmotequipanuilijtica san pa yoje anmonechiculis míac tomin. ");
INSERT INTO nclNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Yoje, annimitzilía inon: Amo ximomajtican quiman anquijnamiquía quinami anyahui anyuli nican pan lalticpan. Amo ximomajtican inahuac quinami ancanas len anquicuas o ancunis. Noje amo ximomajtican inahuac len yes monequi pa anmocuerpo, quinami ancanas len calica anmolaquentis. Dios anmitzmacac anmoyulilisli. Pampín neli unca yihual anmitzmacas len anquicuas huan ancunis pa yoje anyultías. Huan yihual anmitzmacac anmocuerpo, huan unca neli yihual anmitzmacas tzotzomajli calica anmolaquentis. ");
INSERT INTO nclNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Xiquinmitacan in tutomes hual palanilo pin ijyecal. Amo latocalo, amo lapixcalo, amo quisajsacalo nindeno pa capic cajcoquilis. Ma yoje quinlacualtía anmoTajtzin hual unca pin cielo. Huan amhuanten anmonotza míac. Yehuanten amo yoje míac monotzalo. ");
INSERT INTO nclNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Huan amo unca se capa amhuanten hual huil huejcahua pa yultías oc sequin tonalijmes jan pampa lajtúa pa iyolo pampa yahui motolinía pa yultías oc se nadita. ");
INSERT INTO nclNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Huan ¿leca anmomajtía inahuac quinami ancanas anmotzotzomajli? Xiquinmitacan in xuchimes pin cuajlan quinami moscaltilo. Amo tequipanulo huan amo tzahualo. ");
INSERT INTO nclNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ma yoje, annimitzilía pampa in hué Salomón ca mochi itomin amo molaquentic cualtichin quinami nesilo in xuchimes. ");
INSERT INTO nclNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Pampín, sinda Dios quichía cualtichin in sacal hual moscaltitica pin cuajlan, huan mosta cuajnesi huaquis huan quilasasi pin tixuxli, cuaquín niman neli unca yihual anmitzlaquentis amhuanten, mas que amo anquilalía míac laneltocalisli ca yihual. ");
INSERT INTO nclNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","’Yoje, amo ximomajtican, amo xiquijtucan: “¿Len tijcuasi? Huan ¿len ticunisi? Huan ¿ca len timolaquentisi?” ");
INSERT INTO nclNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Yehuanten hual amo quineltocalo Dios yultialo quitemujticate quinami quipiasi mochi innojen. Amhuanten, amo ximomajtican, pampa anmoTajtzin hual unca pin cielo quimati pampa monequi pa anquipías mochi innojen. ");
INSERT INTO nclNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yoje, pampa anquimati Dios quimati len monequi pa anquipías, xicnequican pa Dios huelitis pan amhuanten. Quema, xicnequican inon, amo yoje míac xicnequican mochi innojen oc sequin. Huan noje, mas que anquinequi mochi innojen, monequi niman míac pa anyulis amo laijlaculi quinami yihual Dios quinequi huan quinami yihual anmitzhueliltía pa anyulis. Huan mochi innojen hual monequi pa anquipías, Dios anmitzmacas noje. ");
INSERT INTO nclNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yoje, amo ximomajtican inahuac len yahui panúa mosta, pampa quiman ajsis mosta, cuaquín cayas len amo cuali hual unca iyaxca in tonali san. Huan Dios quichías pa quisas quinami yihual quinequi. San in amo cuali hual panúa pan se tonali miactzini pa in tonali. ");
INSERT INTO nclNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Ximocahuacan pa anquinequis anlatenehuas inahuac in hual quijtulo huan quichihualo oc sequin. Yoje amhuanten amo anyes latenehuali. ");
INSERT INTO nclNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sinda anlatenejtías pampa in hual quijtulo huan quichihualo oc sequin, cuaquín anyes latenehuali jan quinami anquintenehuac oc sequin. Cayas ca amhuanten jan quinami lacames molamachihuililo. Ca in lamachihualoni calica anlamachihuilía, Dios anmitzlamachihuilis amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Huan ¿leca timoijnamiquiltía inahuac mocni ilaijlaculisli tipichin, huan amo timoijnamiquiltía inahuac molaijlaculisli niman hué? Tiunca quinami se hual quita se lalpotocli pa iixtololon oc se, huan amo tiquita in cuahuil niman hué hual unca pa tel moixtololon. ");
INSERT INTO nclNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Pampín, amo unca moyaxca pa tiquilis mocni: “Ma nimitzpalehui pa timocahuas pa ticchías molaijlaculisli.” ¡Xiquita! Tel ticchijtica se laijlaculisli niman tetzcuinuc. ");
INSERT INTO nclNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Lacuajcuamanani tehual! Ticnequi pa tinesis cuali inminlaixpan oc sequin, huan ma yoje amo tiunca cuali. Ximonextili pa tilajtus melahuac pa moyolo inminahuac oc sequin. Ximocahua pa ticchías molaijlaculisli hueyote, cuaquín ticmatis quinami huil ticpalehuis mocni pa mocahuas pa quichías ilaijlaculisli tipichin. ");
INSERT INTO nclNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Amo xilaqueztiacan ca ilajtol Dios inminlaixpan lacames hual motzacuililo pa camo quicaquisi pampa quixijxiculo Dios ilajtol. Yesquiaya quinami anquimaca pelojmes pa quicuasi len iyaxca Dios, huan yesquiaya quinami anquinlasa inminlaixpan in cuchis tixcalitos hual ipatilo míac. Quintelicsalosquiaya in yulijquimes huan momalinalosquiaya pa anmitzcotonalosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Xiyultiacan anquilajlantica Dios, huan yihual anmitzmacas len anquitemachis. Xiyultiacan anquitemujtica len Dios quipía pa anmitzmacas, huan anquitas. Xiyultiacan anquinoztica Dios huan yihual anmitzlapulis quinami in lalapujquimes pin cielo pa yoje anmitzcaquis len anquilajlantica. ");
INSERT INTO nclNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Unca pampa aqui yes yultías quitemachijtica Dios, yihual canas in hual quitemachis. Huan aqui yes hual yultías quitemujtica len Dios quipía pa quimacas yihual, yihual quitas. Huan aqui yes yultías quinoztica, Dios quilapulis. ");
INSERT INTO nclNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Amo unca se lacal ca amhuanten hual quimacas ixól se tixcali sinda ixól quitemachis len quicuas. ");
INSERT INTO nclNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Huan sinda ixól quitemachis se michin, itajtzin amo quimacas se cuhual. ");
INSERT INTO nclNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yoje, mas que amhuanten anunca amo cuali, ma yoje anquimati anquinmaca anmoxolomes innojen hual cuajcuali. Huan noje niman míac quimati quichía yoje anmoTajtzin hual unca pin cielo. Amhuanten amo quiman anquimati anquinmaca innojen cuajcuali quinami yihual quimati. Huan unca neli yihual quinmacas innojen cuajcuali yehuanten hual quitemachilo. ");
INSERT INTO nclNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Yoje, mochi len yes anquinequisquiaya pa anmijchihuililosquiaya lacames, jan yoje amhuanten xiquinchihuilican yehuanten. Sinda anquichía yoje, cuaquín yoje anquineltocatía mochi hual quijtúa Dios ilajtol huan mochi hual quijcuiluje Dios ilajtunijmes. ");
INSERT INTO nclNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Quiman ancanas Dios iojli, cuaquín unca quinami ancalactica pa se lalapujquil pitzahuac, pampa pan Dios iojli yihual anmijtzacuilía pa camo anyulis quinami yehuanten hual amo cate pan iojli. Ma yoje, xicalaquican pa in lalapujquil pitzác. Sinda ancanas in ojli hual anmitzlaicana pa quiahuac in ojli capa Dios unca, cuaquín in unca quinami se ojli palahuac. Unca palahuac capa calaquilo lacames pa canasi in ojli. Huan cate míac hual calaquilo umpa huan polehuisi, amo quiman quipiasi Dios iyulilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pampín, xicanacan Dios iojli. Se cana Dios iojli quinami calaqui se pa se lalapujquil pitzác, huan Dios iojli unca quinami pitzahuac pa canas. Ma yoje anmitzlaicana capa anquipías Dios iyulilisli. Huan amo cate míac hual quitalo Dios iojli pa canasi. ");
INSERT INTO nclNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Ximolachilican pa camo anmitzcuajcuamanasi coyomes hual molaquentilo quinami borregos. Quichihualo yoje pa huil calaquisi capa cate in borregos pa quinmictisi. Jan yoje cate sequin lacames. Nesilo capa amhuanten huan lajtulo quinami cataloaya Dios ilajtunijmes, huan amo cate ilajtunijmes mejmelahuac. Jan quinequilo anmijchihuililo amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Anquimatis pampa yehuanten cate islacatinijmes pampa quichihualo inon. Unca quinami anquimati len cuahuil pampa laqui ilaquilyo. Ma annimitzilía se lanextilisli: Amo quitequilo uvas pan huitzcuajtzitzindis huan amo quitequilo higos pan ipacholimes huizlimes. ");
INSERT INTO nclNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Jan yoje laqui mochi cuahuil cuali ilaquilyo cuali. Se cuahuil amo cuali laqui ilaquilyo amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Se cuahuil cuali amo huil laqui ca ilaquilyo amo cuali. Huan se cuahuil amo cuali amo huil laqui ca ilaquilyo cuali. ");
INSERT INTO nclNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Mochi cuahuil hual amo laqui ca ilaquilyo cuali quicotonalo pa quimayahuisi, huan quilasalo pan tixuxli. ");
INSERT INTO nclNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yoje, anquimatis quinami cate lacames pan ipampa inon hual quichihualo, jan quinami anquimatis calía cuahuil unca pan ipampa ilaquilyo. ");
INSERT INTO nclNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Amo cate yehuanten hual jan yultialo nechilijticate: “Tata, Tata”, hual quipiasi inmintequipanulisli ca Dios capa huelitía. Amo cate noyaxca san pampa nechnotzalo. Quema, quipiasi inmintequipanulisli capa Dios huelitía jan yehuanten san hual quichihualo len quinequi noTajtzin hual unca pin cielo. ");
INSERT INTO nclNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Pa in tonali quiman Dios latexpahuía, cuaquín nechilisi míac, quil: “Tata, Tata, ¿amo tiquinlaquetzilije lacames molajtol, tiquinmilijtataloaya pampa ticpialoaya molahueliltilisli pa tiquinlaquetzililosquiaya? Huan ¿amo tiquinquixtililoaya in ijyecames amo cuajcuali yehuanten? ¿Amo timijtzajtzililoaya ca motoca pa yoje tiquinquixtililosquiaya? Huan ¿amo tiquinchihuaje míac lachihualisli hual quinlachialtije lacames ca lamajtilisli? Tiquinchihuaje pan ipampa ilahueliltilisli motoca.” ");
INSERT INTO nclNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Cuaquinon niquinmilis ca lajtol hual quicaquisi cuali, niquinmilis: “Amo quiman annimitziximatic. Xiquisacan nolaixpan nehual, amhuanten hual mojmosta amo anquichía quinami quijtúa nolajtol.” ");
INSERT INTO nclNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Yoje, niquilis len hual lanextilis quinami unca se lacal hual quicaquis in hual niquijtúa huan quichías quinami niquijtúa. Unca quinami se lacal hual quimati, se lacal hual quichíac icali pani in tel hué. ");
INSERT INTO nclNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Huan huetziaya chicahuac in quiahuil huan lejcuc míac in al pin atenco hué. Toyajtataya, huan ijyecaya chicahuac. Quihuitequiaya in cali in ijyecal, huan ma yoje amo xitinic in cali, pampa in lacal quichíac pani in tel hué. ");
INSERT INTO nclNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Huan aqui yes quicaquis in nolamaxtilisli huan ma yoje amo quichía quinami quijtúa unca quinami se lacal hual amo quimati. In lacal quichíac icali pan xalipan. ");
INSERT INTO nclNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Huetziaya chicahuac in quiahuil huan lejcuc in al pin atenco hué. Toyajtataya, huan ijyecaya chicahuac. Quihuitequiaya in cali in ijyecal huan xitinic in cali huan ¡cataya xitinilisli tetzcuinuc quiman huetzic! ");
INSERT INTO nclNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Huan quiman laquisac quijtuc Jesús in lamaxtilisli, moitaje ca lamajtilisli niman míac in lacalera pampa quinmaxtiaya innojen. ");
INSERT INTO nclNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Cataya pampa yihual quinmaxtiaya quinami se hual quipía lahueliltilisli pa lamaxtis yoje. Yehuanten amo quijtuloaya pampa yahuiaya lamaxti yoje. Amo lamaxtiaya quinami yehuanten hual quimaxtiloaya inminlajtol in judíos. Yihual quinmaxtiaya ca lahueliltilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Temuc Jesús nepa pin tepetzindi (loma), quitocaloaya niman míac lacames huan sihuames. ");
INSERT INTO nclNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Huan hualac ca yihual se lacal quipiaya se cocolisli pan icuilaxli, in cocolisli itoca lepra. Hualac capa Jesús in lacal ca in lepra huan quimolancuacuetzilic, quilic: —Tata, sinda jan ticnequis, huil tichpajtis. ");
INSERT INTO nclNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Huan quixilanic Jesús imajma, quimatocac, quilic: —Nicnequi nimitzpajtía, xipajti. Huan jan ajnaxcan pajtic in lepra. ");
INSERT INTO nclNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Cuaquín Jesús quilic: —Ximoiztía pa camo tiquilis amaqui. San xía ximonextili in tiopista, huan xicuica ca tehual in huendi hual Moisés quijtuc pin lajtol pa ticmacas. In huendi quinnextilis moxtin pampa tipajtic. ");
INSERT INTO nclNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesús calaquic pin caltilan Capernaum. Cuaquinon hualac capa yihual se ilaicanani in guaches romanos. In laicanani quilajlanic Jesús ca icnotilisli, quilic: ");
INSERT INTO nclNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Tata, unca pa nochan se xól hual unca notequipanujquil, yihual lastica pan lapexli. Amo huil molini, unca niman cocoxqui. ");
INSERT INTO nclNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Cuaquín Jesús quilic: —Nihualas pa nicpajtis. ");
INSERT INTO nclNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Quinanquilic in laicanani: —Tata, amo nimonotza pa tehual tihuás pa nochan. Jan xiquili in lajtol san, huan pajtis notequipanujquil. ");
INSERT INTO nclNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nehual noje nilacal hual nictequipanuilía oc se hué hual nechilía len monequi pa nicchías. Huan nehual niquinpía guaches hual quipialo pa quichihuasi len niquinmilía. Niquilía se: “Xía”, huan yahui. Niquilía oc se: “Xihuá”, huan huala. Niquilía notequipanujquil: “Xicchía inon”, huan quichía. Pampín nicmati yihual pajtis pampa tel ticpía lahueliltilisli pa lapajtis jan ca molajtol san. ");
INSERT INTO nclNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Quicaquic inon Jesús, mocahuac quinmiztica yehuanten nepa, lachíac molapolultitataya, cuaquín quinmilic yehuanten hual quitocatihualaloaya: —Annimitzilía neli, amo quiman niquitac jan se ca moxtin amhuanten israelitos hual laneltoca quinami in lacal romano. ");
INSERT INTO nclNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Huan annimitzilía inon: Cayasi pa mochi in lalticpan míac quinami in laicanani hual hualasi huan cayasi ca Dios quiman huelitía. Quipiasi míac paquilisli. Quema, quinxiluilis Dios in cuali hual quinmacas yehuanten huan Abraham huan Isaac huan Jacob. ");
INSERT INTO nclNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ma yoje, Abraham imiahuimes hual amo laneltocalo amo quipiasi inminlaxilulisli capa Dios huelitía. Quema, quijtulo pampa cayasi ca Abraham huan Isaac huan Jacob pampa unca inminyaxca Abraham imiahuimes. Ma yoje, amo cayasi nepa. Cayasi latzacuali pa quiahuac, hual amo cayas capa Dios huelitía. Mocahuasi capa laticumac. Nepa mocaquis chocalisli huan quincuajcuasi inminlames pampa moitasi capa unca lacocoltilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Cuaquinon Jesús quilic in laicanani: —Xía cuaquín. Huan quinami ticneltocac, cayas jan yoje. Huan pajtic itequipanujquil jan ajnaxcan in tonali. ");
INSERT INTO nclNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Hualac Jesús pa ichan Pedro. Nepa quitac Pedro isihua inantzin lastataya pan lapexli, totoniaya chicahuac. ");
INSERT INTO nclNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Cuaquín quimatocac imajma in sihual huan yajmo quipiaya totonalisli. Huan moquetzac in sihual, pehuac quinyucxiltilic len quicuasi. ");
INSERT INTO nclNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Quiman tiolactitiahuiaya, quihualiquilije Jesús míac hual quinpialoaya ijyecames amo cuajcuali hual quinmantiaje mojmosta. Jesús quinquixtilic in ijyecames jan quinmilijtica pa quisasi. Quema, quinpajtic moxtin hual cataloaya cocoxquimes. ");
INSERT INTO nclNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yojque mochíac len quijcuiluc pa yina Isaías ilajtuni Dios. In Isaías quijcuiluc quinami Cristo yahuiaya lapajti quiman hualaya pan lalticpan, quijtuc: “Yihual techijcuanilic tococolisli huan quinpajtic tococoxquimes.” ");
INSERT INTO nclNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Axan quiman quinmitac Jesús niman míac hual quiyahualujtataloaya inahuac yihual, quinmilic imonextilinijmes pa panulosquiaya ca yoje itenco (analco) in al huejcalan. ");
INSERT INTO nclNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Huan hualac capa Jesús se ilamaxtini in judíos inminlajtol lajcuiluli hual quineltocalo in judíos. Quilic: —Lamaxtini, nimitztocas ca capic yes tías, nicnequi nimochías se momonextilini tehual. ");
INSERT INTO nclNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Huan Jesús quilic: —Quipialo in zorras inmincojcoyunqui capa chantilo. Quipialo in tutomes capa mosehuilo. Ma yoje, nehual ilacal in cielo amo nicpía capa noyaxca pan lalticpan, huan yoje yes ca tel sinda tichtocas. ");
INSERT INTO nclNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Huan oc se imonextilini quilic: —Tata, xichmacahuilti pa nel nías pa niclaltocas notajtzin. Cuaquín nimitztocas. ");
INSERT INTO nclNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Huan Jesús quilic: —Xichtoca pa timochías nomonextilini. Oc sequin amo quitalo pampa unca len hué quinami Dios huelitía. Yehuanten quinami micticate pa inminyolo. Ma quinlaltocacan yehuanten innojen mijquimes. ");
INSERT INTO nclNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Cuaquín calaquic se barco huan quitocaje imonextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nejnentiyahuiaya in barco pa al, huan jan ajnaxcan hualajtiquisac je ijyecal chicahuac ca quiahuil pan in al huejcalan. Majcoctataya in al huan ca nadita yahuiaya moijsima in barco ca in al hual calaquiaya laijtic pin barco. Ma yoje, coxtataya Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Pampín uyajtiquisaje ca yihual imonextilinijmes, quejxiltije, quilije: —¡Tata! ¡Xitechquixtili pa topolehuilisli! ¡Tialo timoatoctilo! ");
INSERT INTO nclNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Huan quinmilic: —¿Leca anmomajtía? ¿Amo anquipía san se nadita laneltocalisli ca nehual? Cuaquinon moquetzac huan quinmilic chicahuac in ijyecal huan in al hué pa mosehuisi huan mosehuije jan ajnaxcan. ");
INSERT INTO nclNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Huan moitaje ca lamajtilisli in lacames, quijtuje: —¿Len lacal inon? ¡Quineltocalo in ijyecal huan in al huejcalan! ");
INSERT INTO nclNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Huan ajsije ca yoje itenco (analco) capa cataya inminlali yehuanten itocaloaya gadaratecos. Nepa pin lali quinamiquije ome lacames hual quinpialoaya ijyecames amo cuajcuali hual amo mocahualoaya pa quinmanalosquiaya. Quisaloaya in omenten capa quinlalpachulo mijquimes, cataloaya niman ejꞌelehuis. Pampín moxtin momajtije pa panusquiaya ca umpic. ");
INSERT INTO nclNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Huan jan axcan tzajtzije chicahuac, quilije: —¡Jesús, tehual Dios ixolol! ¿Len ticpía pa tiquitas ca tehuanten? ¿Tihualac ca níc pa titechcocoltisquiaya? ¡Ayamo ajsic in tonali pa ticayasi lacocoltili! ");
INSERT INTO nclNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Huejquita capa yehuanten moitilije míac cuchis (coyamimes) lacuajtinemiloaya. ");
INSERT INTO nclNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Yoje in ijyecames quilajlanije Jesús ca mochi inminyolo, quilije: —Sinda titechtojtoquilis, xitechmacahuilti pa ticalaquisi laijtic innojen míac coyamimes. ");
INSERT INTO nclNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Huan Jesús quinmilic: —Xiquisacan pa laijtic innojen lacames huan xiacan. Cuaquín quisaje pa laijtic yehuanten, calactiaje pa innojen coyamimes laijtic. Huan ¡xiquitacan! Mochi in coyamilera molalujtiquisaje pa se temuán (temuayan) huan molasaje pin al huejcalan, moatoctije. ");
INSERT INTO nclNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Huan yehuanten hual quinlachililoaya in coyamilera choluje. Uyaje pa in caltilan, quinpuhuilije mochi in hual quinpanuc in omenten hual in ijyecames amo cuajcuali quinmananijme. ");
INSERT INTO nclNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Huan quisaje moxtin yehuanten pin caltilan pa monamiquilosquiaya ca Jesús. Nepa quitaje huan quitemachije ca mochi inminyolo pa quisasquiaya pa inminlali. ");
INSERT INTO nclNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Cuaquín calaquic Jesús pan in barco, quipanajtíac in al huejcalan, ajsic pa icali yihual. ");
INSERT INTO nclNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Huan quita, sequin lacames quihualiquilije se lacal cocoxquil, amo huil moliniaya. Quimantihualaje lastataya pan len quinami lapipixtiloni. Huan Jesús quitac quinami quineltocaloaya pampa yihual huil quipajtic in lacal. Yoje, quilic in lacal hual amo huil moliniaya, quilic: —Amo ximomajti, Nito, nicpujpúa molaijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Huan xiquita, sequin ilamaxtinijmes inminlajtol in judíos hual quinnextilía quinami quimolancuacuetzililo Dios quijtuje laijtic yehuanten inminyolo: —In lacal quihuejuecaltitica Dios. Mochía quinami Dios pampa quijtúa inon. ");
INSERT INTO nclNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesús quimatic len quijtuloaya laijtic inminyolo huan quinmilic: —¿Pa len anquijtutica in amo cuali laijtic anmoyolo? ");
INSERT INTO nclNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Sinda san niquilía in lacal pampa nicpujpuhua ilaijlaculisli, amaqui yoje quimatisquiaya sinda neli nicpía Dios ilahueliltilisli. Ma yoje, sinda niquilía pa moquetzas pa nejnemis, cuaquín moxtin quimatilosquiaya pampa nicpía Dios ilahueliltilisli sinda in lacal moquetzasquiaya huan nejnemisquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Yoje, axan anyahui anquimati pampa nehual ilacal in cielo nicpía lahueliltilisli pan lalticpan pa nicpujpuhuilis se ilaijlaculisli. Cuaquinon mocuepac quitac Jesús in lacal hual amo huil moliniaya, quilic: —Ximoquetza, xicana molapipixtiloni huan xía pa mochan. ");
INSERT INTO nclNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Cuaquín moquetzac huan uyac pa ichan. ");
INSERT INTO nclNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Huan quiman quitaje inon in lacalera, momajtije huan quijtuje lajtomes huejué pa Dios hual quinmacac lacames lahueliltilisli hué quinami in hual quipiaya Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Cuaquín yajtíac Jesús pa iojli in caltilan capa cataya, quitac se lacal motocaya Mateo. Molaliaya tequipanujtataya pin cali capa laxlahuiloaya ilapixcalisli tomin pa in lahueliltilisli romano. Jesús quilic: —Xichtoca pa timochías nomonextilini. Huan moquetzac Mateo, quitocac. ");
INSERT INTO nclNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Cataya se tonali molalijtataya Jesús pin cali pa lacuas, huan quita, hualaje huan molalije ca yihual huan imonextilinijmes míac lacames hual cantiahuiloaya ilapixcalisli tomin pa in lahueliltilisli romano. Noje hualaje míac judíos hual amo quineltocaloaya cuali in lajtol hual quijtúa quinami monequi pa quimolancuacuetzilisi Dios in judíos. ");
INSERT INTO nclNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Quiman quitaje inon yehuanten hual quineltocaloaya inminlamaxtilisli in fariseos, quinmilije Jesús imonextilinijmes: —¿Leca lacua anmolamaxtini ca yehuanten hual techanililo ilapixcalisli tomin huan ca yehuanten hual amo quineltocalo cuali in lajtol hual technextilía quinami ticmolancuacuetzililo Dios? ");
INSERT INTO nclNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Quiman quicaquic Jesús inon, quinmilic: —Yehuanten hual amo cate cocoxqui amo quinequilo lapajtini. Quema, quinequilo lapajtini pa quinpalehuis yehuanten hual cate cocoxqui. Huan jan yoje cate yehuanten hual quijtulo laijtic inminyolo pampa amo cate laijlaculi. Amo quinequilo pa niquinpalehuis. Cate quinami lacames hual quijtulo pampa amo cocoxqui. Amo quinequilo pa quinpalehuis se lapajtini. Huan lacames hual laijlaculi cate quinami yehuanten hual cocoxqui, quinequilo pa niquinpalehuis. ");
INSERT INTO nclNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ma yoje, amhuanten, xiacan ximonextilican len quinequi quijtúa Dios quiman quijtúa: “Nicnequi pa quimatisi laicnilisi yehuanten hual nechneltocalo. Amo nicnequi pa jan nechlalilisi huendis nolaixpan san.” Nehual nihualaya pa niquinnotzas in lacames laijlaculi pa quipalasi inminyolo pa pehuasi laijnamiquisi quinami Dios laijnamiquía. Amo nihualaya pa niquinnotzas yehuanten hual pa inminyolo amo cate laijlaculi. ");
INSERT INTO nclNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Cuaquinon hualaje capa Jesús in lacames hual quitocaloaya Juan Lacuayatequini, quilije: —¿Leca timosahualo míac tehuanten huan yehuanten hual quitocalo inminlamaxtilisli in fariseos? Tehual momonextilinijmes amo quiman mosahualo. ");
INSERT INTO nclNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Huan Jesús quinmilic: —Amo huil mosahualo ilasojlimes se lacal hual monamictía quiman cate ca yihual. Huan nehual niunca quinami in lacal hual monamictía. Ma yoje, ajsisi tonalijmes quiman quinquixtilisi in lacal hual monamictía hual nel niunca quinami yihual. Quinquixtilisi ilasojlimes, huan cuaquín yehuanten mosahuasi. ");
INSERT INTO nclNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Amaqui quilalía se tzotzomajli yancuic pan se tzotzomajli hual unca cacaxlito pa quitzomas ca in yancuic, pampa in tzotzomajli yancuic hual quilalía ipan mocololúa huan quitzayana in tzotzomajli hual cacaxlito. ");
INSERT INTO nclNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Huan lacames amo quiman quilalilo iayo uva yancuic pa cuilaxlimes hual cate cacaxli. Sinda yoje quichihualo, xopunis in cuilaxlimes, tzayanisi huan toyahuis iayo uva huan moijlacusi in cuilaxlimes. Quilalilo iayo uva yancuic pa cuilaxlimes yajyancuic, huan iayo uva huan in cuilaxlimes amo moijlaculo. Huan jan yoje nolamaxtilisli yancuic amo moajxiltía cuali ca in lamaxtilisli hual mochi ichicahualisli umpa quicahuac. Yoje unca inminlamaxtilisli in fariseos. ");
INSERT INTO nclNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ayamo laquisac quinmilic Jesús innojen lajtomes, huan xiquita, hualac se ipiscal in tiopan, quimolancuacuetzilic, quilic: —Noxól sihual san quipía nadita lamic polehuic. Ma yoje xihuala xiclalili moma ipan huan yulis oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Cuaquín moquetzac Jesús, pehuac quitocac, huan noje quitocaje imonextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Huan xiquita, hualac itepotzcon Jesús se sihual, ajsitihualaya pa Jesús pampa quinpíac doce xixihuil cataya cocoxquil ca esli hual quisaya pa icuerpo. Quimatocac ilatemijmiluli Jesús inahuas. ");
INSERT INTO nclNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Quimatocac pampa quijtutataya laijtic yihual: “Sinda jan nicmatocas inahuas, yoje nipajtis.” ");
INSERT INTO nclNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Huan momalinac Jesús huan quitac in sihual, quilic: —Xicaya ca paquilisli, Tuinon. Tipajtic pampa tilaneltocac. Huan in sihual mochi pajtic jan ajnaxcan. ");
INSERT INTO nclNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Cuaquín ajsic Jesús, calaquic calijtic ichan ipiscal in tiopan. Quinmitac in latzotzonanijmes huan in lacalera xahuantataloaya. ");
INSERT INTO nclNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Huan quinmilic: —Ximohuicacan, pampa amo polehuic in xól, jan coxtica san. Yehuanten quihuitzquilije. ");
INSERT INTO nclNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ma yoje Jesús quinquixtic in lacalera, calaquic, quiquitzquic ima in xolol sihual huan yihual yulic oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Cuaquín mosemanac ilamachiltilisli in hual quipanuc in xolol sihual, huan yoje quimatic moxtin pa mochi in lali itenco. ");
INSERT INTO nclNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Quisac umpa Jesús, quitocaje ome pachacames, quitzajtzilijtataloaya, quililoaya: —Tehual David imiahuil, ¡xitechicnili! ");
INSERT INTO nclNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Huan quiman calaquic calijtic, hualaje capa yihual in pachacames, huan Jesús quinmilic: —¿Anquineltoca pampa nehual huil annimijchihuilía in hual annechtemachijtica? Quilije: —Quema, Tata. ");
INSERT INTO nclNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Cuaquinon quinmatoquilic inmixtololojmes, quinmilijtataya: —Quinami anquineltoca, yoje ma ye pa amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yoje pajtije inmixtololojmes, huil lachialoaya. Huan Jesús quinmilic chicahuac: —Amo xiquilican inon amaqui. ");
INSERT INTO nclNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ma yoje, yehuanten, quiman quisaje, quimachiltitinemiloaya in hual quinchihuilic Jesús. Lamachiltiloaya pa mochi in lali hual cataya itenco nepa. ");
INSERT INTO nclNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Quiman quistataloaya in lacames hual axan huil lachialoaya, quihualiquilije Jesús oc sequin lacames se lacal hual amo huil lajtuaya. Se ijyecal elehuis quijlacuhuaya ilajtol, amo quimacahuiltiaya pa lajtusquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Huan quiman Jesús quiquixtilic in ijyecal in lacal, cuaquinon huil lajtuaya. Yoje moitaloaya ca lamajtilisli in lacames, quililoaya: —Amo quiman panuje lachihualisli quinami innojen pin tolali Israel. ");
INSERT INTO nclNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ma yoje, yehuanten hual quineltocaloaya inminlamaxtilisli in fariseos quijtutinemiloaya: —Yihual quinquixtilía in ijyecames pan ipampa ilapalehuilisli Satanás hual huelitía ca in ijyecames amo cuajcuali. ");
INSERT INTO nclNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Huan Jesús yajtinemiaya pa mochi caltilan huejué huan mochi caltilan tijtipichin. Lamaxtitataya pa inmintiopajmes huan quimachiltitataya in lamachiltilisli cuali pa quimatilosquiaya quinami Dios huelitía. Huan noje yajtiahuiaya quinpajtitataya moxtin hual quipialoaya cocolisli huan len yes hual quincocojtataya. ");
INSERT INTO nclNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Huan quiman quinmitaya in lacames, nesiloaya siajtataloaya pampa quipialoaya míac cocolisli huan lastataloaya pan lali pampa niman siahuiloaya. Huan quinmicniliaya Jesús niman míac pampa cataloaya quinami borregos hual amo quipialoaya aqui quinlachilisquiaya. Quema, nesiloaya quinami lacames hual amo huil canaloaya len monequiaya pa quipialosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Cuaquinon Jesús quinmilic yehuanten hual quinmaxtiaya, quinmilic: —Cate míac pin lalticpan hual quinequilosquiaya monechiculo capa Dios huelitía. Yehuanten cate quinami se lapixcalisli hué capa amo cate míac tequipanujquimes pa lapixcasi. ");
INSERT INTO nclNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Dios Yihual iteco in lapixcalisli. Xictemachican Dios pa quintilanis lapixcanijmes pa quinnechicusi yehuanten pa in lapixcalisli, niquijtutica yehuanten hual quinequisi yesi lanechiculi capa Dios huelitía. ");
INSERT INTO nclNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Huan quinnotzac Jesús pa hualalosquiaya capa yihual doce imonextilinijmes, quinmacac lahueliltilisli pa quinquixtilisi ijyecames amo cuajcuali in lacames. Quinmacac lahueliltilisli pa quinpajtililosquiaya len yes cocolisli huan len yes hual quincocoltiaya yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Huan nican unca quinami motocaloaya in doce ilanahuatinijmes: Pehua ca in se hual motocaya Simón hual unca Pedro, oc se motocaya Andrés, yihual icni Pedro. Cuaquinon cataya se motocaya Jacobo ixolol Zebedeo huan oc se motocaya Juan, yihual icni Jacobo. ");
INSERT INTO nclNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Cuaquinon cataloaya Felipe huan Bartolomé huan Tomás huan Mateo. Yihual Mateo yec se hual laꞌanilini ilapixcalisli tomin pa in lahueliltilisli romano. Huan cataya Jacobo ixolol Alfeo, cataya Lebeo hual noje motocaya Tadeo, ");
INSERT INTO nclNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","cataya Simón hual catani ca in cananistas hual quinequiloaya huelitilo pa Israel, huan cataya Judas Iscariote hual quitemacac Jesús pa yehuanten hual yahuiloaya quimictilo. ");
INSERT INTO nclNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Innojen doce lacames Jesús quintilanic quinami ilanahuatinijmes. Quinpehualtilic inmintequipanulisli quinmilijtica: —Amo xiacan capa chantilo yehuanten hual amo judíos. Huan amo xicalaquican pa se inmincaltilan samaritecos. ");
INSERT INTO nclNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","San nicnequi pa anyas capa cate yehuanten pa ilali Israel, in judíos hual monequi pa yesi laquixtili pin polehuilisli ca capic quinhuica inminlaijlaculisli. Yehuanten cate quinami borregos mopolujticate. ");
INSERT INTO nclNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Xilamachiltitiacan capa yes anyajtía, xiquinmilican: “Ajsitihuala in tonali quiman Dios lanextilis pampa yihual huelitía”, xiquinmilican. ");
INSERT INTO nclNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Xiquinpajtitiacan in cocoxquimes, xiquinyuliltitiacan in mijquimes, xiquinpajtitiacan yehuanten hual mococulo ca in cocolisli lepra, xiquinquixtilijtiacan yehuanten hual ijyecames amo cuajcuali quincocoltiticate. Annimitzmaca in lahueliltilisli pa anquichías mochi inon, huan amo annimitzlajlaniaya laxlahuilisli nindeno. Pampín ma camo anmitzlaxlahuican nindeno yehuanten hual anquinpalehuis. ");
INSERT INTO nclNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Xiacan jan quinami anunca axan, amo xihuejcahuacan anquichixtica pa huil ancanas tomin pa anquihuicas. ");
INSERT INTO nclNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Amo xiquinhuicacan anmoxotopajmes, xicuicacan jan se cotón mochi sejse ca amhuanten, xiquinhuicacan san ome anmolacsames, huan amo xiquihuicacan se cuál pa anmopalehuis quiman annejnemi. Amo monequi pa anquinpías innojen. Anmitzmacasi len anquinequi capa yes anajsis, pampa se tequipanujquil monotza pa canas inon hual quicua. ");
INSERT INTO nclNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Huan quiman ancalaquis calía yes caltilan hué o caltilan tipichin, xilajlanican sinda unca se nepa hual moxtin lachialo ca lasojlalisli, hual quinequis pa anmitzmosehuiltis pa ichan. Quiman anquimati aqui yes anmitzmosehuiltis, cuaquín xiacan pa ichan nepa. Ximocahuacan pa anchantis nepa mochi tonalijmes hual anunca pa in caltilan. ");
INSERT INTO nclNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Huan quiman ancalaquis se cali calijtic, xiquinpialtican yehuanten hual nepa chantilo. ");
INSERT INTO nclNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Sinda yehuanten pa in cali quinequisi anmitzmosehuiltisi amhuanten huan quineltocasi anmolamachiltilisli, cuaquín ma mocahua ca yehuanten anmomosehuilisli calica anquinpialtic. Huan sinda yehuanten pa in cali amo quinequisi anmitzmosehuiltisi amhuanten huan amo quineltocasi anmolamachiltilisli, cuaquín ma mocuepa pa amhuanten anmomosehuilisli calica anquinpialtic yehuanten. Yoje huil anquinmacas oc sequin anmomosehuilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Huan aqui yes amo quinequis anmitzmosehuiltis huan amo quinequis quicaquis anmolamachiltilisli, cuaquín quiman anquisas pa in cali o in caltilan, xiquintzejtzeluilican capa yehuanten in lalmoluncal hual salijtica pa anmolacsames. In yes lanextilisli pa yehuanten. Yoje quimatisi pampa Dios quinmita quinami lacames hual amo quinequilo quineltocalo ilamachiltilisli. Pampín Dios amo quinmanilis pa yesi ilacames. ");
INSERT INTO nclNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Annimitzilía neli pampa yehuanten hual chantilo pa in caltilan panusi míac lacocoltilisli. Yehuanten hual chantinijme pin caltilan hué itocani Sodoma huan pin caltilan Gomorra, amo panusi yoje míac lacocoltilisli pan tonali quiman quinmotexpahuilis Dios yehuanten hual chantilo pin lalticpan hual amo quineltocalo. ");
INSERT INTO nclNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’¡Xiquitacan! Nehual annimitztilantica, huan amhuanten lacames hual amo huil anmonapatía. Anunca quinami borregos hual in coyomes quinyahualujticate pa quinmictisi. Pampín, xiyén (xiyecan) lacames hual quimatilo motzacuililo pa camo mocahuasi capa lacames hual cate quinami in coyomes hual anmijchihuilisi len amo cuali. Quema, xiyén quinami in cuhuames hual quimatilo moixcuepalo pa moquixtisi pin miquilisli. Noje xiyén quinami in huilomes hual amo quiman quichihuililosquiaya amaqui len amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ma yoje, ximolachilican pampa lacames molalisi anmopan. Anmitztemacasi ca in laꞌajuanijmes pa anmitzlajlanisi chicahuac. Anmitzhuitequisi pa inmintiopajmes. ");
INSERT INTO nclNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Anmijchihuilisi inon pampa annechneltoca. Noje pampa inon anmitzhuilanasi inminlaixpan hueyenten huan lacames niman hué hual huelitilo. Quiman anunca inminyampa yehuanten anquinlaquetzilis pa quicaquisi nolamaxtilisli. Huan inminyampa yehuanten hual amo judíos anquinlaquetzilis pa quicaquisi nolamaxtilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Huan quiman anmitztemacasi pa anmitzlajlanisi in laꞌajuanijmes, cuaquín amo ximomajtican pampa amo anquimati quinami anlananquilis huan ca len lajtol anquijtus, pampa Dios anmitzmacas jan ajnaxcan lajtomes hual anquinmilis. ");
INSERT INTO nclNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Amo cayas amhuanten hual anlajtus. Cayas iEspíritu anmoTajtzin pin cielo hual lajtúa pan anmopampa. ");
INSERT INTO nclNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Se lacal quitemacas icni pa quimictisi, pampa icni nechneltoca. Pampa inon noje itajtzin se xól quitemacas ixól pa quimictisi pampa ixól nechneltoca. Huan in xolomes molalisi inminpan inmintajtzitzían huan inminantzitzían, huan in xolomes latilanisi pa quinmictisi. ");
INSERT INTO nclNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Huan moxtin lacames anmitzcocolisi pampa anmotocayaltis ca notoca. Ma yoje, aqui yes mopepenialtis pa mochicahualtis pa panus innojen pa mochi tonalijmes hual huejcahuas huan mojmosta yultía nechneltocatica, cuaquín yihual cayas laquixtili capa unca pin polehuilisli. Huan quipías ichan capa Dios huelitía. ");
INSERT INTO nclNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Quiman anmitztojtocalo pa se caltilan, cuaquín xicholucan pa anajsis pa oc se caltilan. Yoje anpanujtinemis pa mochi caltilan pin lali Israel, anquinmilijtica Dios ilamachiltilisli cuali. Ma yoje, annimitzilía neli, ayamo anlaquisas anpanujtinemis pa mochi innojen caltilan quiman nehual ilacal in cielo nihualas oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Se monextilini amo ajsis yes hué sinda ilamaxtini amo unca yoje hué. Huan se tequipanujquil amo ajsis yes hué sinda amo unca yoje hué iteco. ");
INSERT INTO nclNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ma mocahua ca paquilisli se monextilini sinda ajsis yes jan quinami ilamaxtini. Noje ma mocahua ca paquilisli se tequipanujquil sinda ajsis yes jan quinami iteco. Nel nechtocayaltilo Beelzebul (in itoca inminteco in ijyecames amo cuajcuali, yihual in lili). Sinda nechtocayaltilo Beelzebul, cuaquín neli yalo quintocayaltilo niman tetzcuinuc amhuanten hual anchanti ca nehual. ");
INSERT INTO nclNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Ma yoje, amo ximomajtican inminpampa yehuanten, pampa len yes amo cuali hual anmijchihuililo, Dios quimati, huan moxtin pin lalticpan quimatisi. Amo unca nindeno lalatili hual amo moitas, huan amo unca nindeno hual amo quimatilo hual amo yes lamachiltili. ");
INSERT INTO nclNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yoje, len annimitzilis quiman ticate tohuían, inon xiquinlaquetzilican inminyampa in oc sequin lacames. Quema, len yes anquicaquis annimitzilis nel ixtacayito, inon xiquinmachiltitinemican moxtin pa yoje huil quimatisi pa mochi lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Amo ximomajtican pampa yehuanten huil quimictilo se icuerpo huan ma yoje amo huil quimictilo se iyulilisli. Monequi pa anmomajtis niman míac ilaixpan Dios hual huil quijlacúa se icuerpo huan iyulilisli capa amo mocahuas pa quincocoltis yehuanten hual amo quineltocalo. In unca in coyunquil capa chichinahuía. ");
INSERT INTO nclNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Anquimati pampa jan quilaxlahuilo se naditita san pa ome tutotzitzindis. Huan mas que amo ipatilo, ma yoje amo unca se capa yehuanten hual huetzis pan lali huan miquis sinda amo quimacahuiltis anmoTajtzin pin cielo. ");
INSERT INTO nclNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Huan amhuanten anmitzpuhuilía Dios mochi in tzondis pa anmotzontecon. ");
INSERT INTO nclNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Pampín, amo ximomajtican. Dios anmitzita quinami anmonotza niman míac. Amo yoje míac monotzalo míac tutotzitzindis. ");
INSERT INTO nclNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Aqui yes hual quijtus neli inminyampa lacames pampa yihual nechneltoca, cuaquín nehual noje niquijtus iyampa noTajtzin hual unca pin cielo pampa nehual niquiximati in se. ");
INSERT INTO nclNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ma yoje, aqui yes quijtus inminyampa lacames pampa amo nechneltoca, cuaquín nehual noje niquijtus iyampa noTajtzin hual unca pin cielo pampa in se amo unca noyaxca. ");
INSERT INTO nclNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Amo xiquijtucan laijtic amhuanten pampa quiman nel nihualaya pan lalticpan yahuiaya caya mosehuilisli pan lalticpan pan nopampa. Amo nihualaya pa nicchías mosehuilisli. Amo nicualicatihualaya mosehuilisli, pampa pan nehual nopampa yehuanten hual amo nechneltocalo majcoquisi pa moanasi. ");
INSERT INTO nclNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Quema, nihualaya pa nicchihuilis pa se lacal yes lacocolini ca itajtzin, in xól sihual pa yes lacocolini ca inantzin huan isihua ixól pa yes lacocolini ca inantzin ilahuical. ");
INSERT INTO nclNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Yoje, se lacal ilacocolinijmes yesi yehuanten hual chantilo ca yihual pa se cali. ");
INSERT INTO nclNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Se lacal quinlasojlas itajtzin huan inantzin. Ma yoje, monequi pa nechlasojlas nel niman míac, amo san yoje quinami quinlasojlas itajtzin huan inantzin. Sinda amo yoje, cuaquín amo monotza pa yes nomonextilini. Huan se lacal neli quilasojlas ixól lacal huan ixól sihual. Ma yoje, monequi pa nechlasojlas niman míac, amo san yoje quinami quinlasojlas yehuanten. Sinda amo yoje, amo monotza pa yes nomonextilini. ");
INSERT INTO nclNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Huan aqui yes amo quineltocas nolamaxtilisli amo monotza pa yes nomonextilini. Huan aqui yes amo quinequis mopepenialtis pa mochicahualtis pa panus mochi lacocoltilisli hual Dios quimacahuiltía pa panus, cuaquín yihual amo monotza pa yes nomonextilini. Quema, quipías pa mochicahualtis pa panus in hual quicocoltía mas que cuajnesi Dios quimacahuiltis pa miquis pan se cuahuil quinami nel. ");
INSERT INTO nclNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Aqui yes quinequi niman míac pa yultías pan lalticpan huan amo san yoje quinequi quineltoca Dios, cuaquín yihual amo quiman yulis capa Dios. Huan sinda Dios quinequi pa se quipolus iyulilisli pa yoje Dios canas lahueyilisli pampa inon, huan sinda in se amo motzacuilis pa miquis yoje, cuaquín yihual quipías yulilisli capa unca Dios. ");
INSERT INTO nclNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Aqui yes anmitzitas quinami ilasojlimes huan anmitzixtocas pampa anquipía nolamaxtilisli, cuaquín yihual noje nechiztica nel quinami ilasojli pampa quixtoca nolamaxtilisli. Huan aqui yes nechiztica quinami ilasojli noje quiztica quinami ilasojli yihual hual nechtilanic. ");
INSERT INTO nclNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Aqui yes quitas quinami se ilasojli se ilajtuni Dios jan pampa unca Dios ilajtuni, cuaquín Dios quimacas in laxlahuilisli hual yes quinami inon hual canas Dios ilajtuni. Huan aqui quitas quinami ilasojli se lacal hual amo mocahua pa yultías quinami Dios quinequi pa yulis, huan quitas quinami ilasojli jan pampa yuli quinami Dios quinequi pa yulis, cuaquinon Dios quimacas yihual se laxlahuilisli jan quinami in laxlahuilisli hual canas in lacal hual yultía quinami Dios quinequi pa yulis. ");
INSERT INTO nclNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Cuajnesi cayas se hual quichihuilis se nomonextilini niman tipichin jan len lachihualisli tipichin. Cuajnesi jan quimacas se tecomal al iztic san, huan jan quimacas pampa yihual hual cuni in al unca nomonextilini. Annimitzilía neli, yihual neli quipías ilaxlahuilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Quiman laquisac quintilanic Jesús in doce imonextilinijmes, uyac yihual cajcapa pa lamaxtis huan pa lamachiltis pa inmincaltilan huejué yehuanten pin lalticpan Galilea. ");
INSERT INTO nclNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Huan cataya latzacuali calijtic Juan Lacuayatequini. Nepa yihual quimachiltilije in hual quichijtataya Cristo. Pampín quintilanic Juan ome imonextilinijmes pa yehuanten quilajlanilosquiaya Cristo pa yoje yihual Juan quimatisquiaya mochi inahuac yihual. ");
INSERT INTO nclNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Huan imonextilinijmes quilije: —Juan Lacuayatequini quinnotzaya quinmilijtataya lacames pampa Dios yahuiaya quitilani se pan lalticpan. Axan quinequi quimati Juan sinda tehual tiunca in se. Sinda amo, cuaquín quinequi quimati da monequi pa ticchiasi pa hualas oc se. ");
INSERT INTO nclNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús quinnanquilic: —Xiacan huan xicmachiltican Juan oc sejpa innojen hual anquinmiztica huan anquincactica. ");
INSERT INTO nclNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Anquita huan anquicaqui quinami lachialo in pachacames. Nejnemilo yehuanten hual amo huil nejnemiloaya. Pajtilo yehuanten hual quipialo in cocolisli lepra, huan lacaquilo in panatames. Yulilo oc sejpa yehuanten hual miquije. Huan yehuanten hual amo quipialo nindeno quicaquilo in lamachiltilisli cuali pampa axan quinlamachiltiticate. ");
INSERT INTO nclNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Huan yulis ca míac paquilisli yihual aqui yes amo mocahuas pa quixtocas pa iyolo huan quineltocas in hual nicmaxtía. ");
INSERT INTO nclNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Cuaquín, quiman mohuicaloaya in omenten imonextilinijmes Juan, Cristo pehuac quinlaquetzilic in míac lacalera inahuac Juan, quinmilic: —In tonalijmes hual anyahuini ca capic amaqui chantiaya pa anquicaquis huan anquitas Juan, ¿quinami len lacal anquijtuaya pampa anyahuiaya anquita? ¿Anquijtuaya pampa in Juan yesquiaya quinami lacal hual quipala in hual quijtúa quinami quihuixujtica se lajtol pa oc se lajtol, quinami se acal hual in ijyecal quihuixúa? No, yíal Juan amo lacal quinami inon. ");
INSERT INTO nclNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Cuaquinon, ¿quinami len lacal anquijtuaya pampa anyahuiaya anquita? ¿Anquijtuaya pampa Juan yesquiaya lacal hual molaquentiaya ca tzotzomajli cualtichin? No, yíal amo lacal quinami inon. Xiquitacan, yehuanten hual molaquentilo ca tzotzomajli cualtichin chantilo pa inmincalimes cuajcualtichin in huejueyenten. ");
INSERT INTO nclNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Axan, ¿pa len anyahuini ca umpic pa anquitasquiaya? ¿Anyahuini pa anquitasquiaya se ilajtuni Dios? Quema, annimitzilía yihual se ilajtuni Dios. Huan annimitzilía yihual amo unca jan Dios ilajtuni san. ");
INSERT INTO nclNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Noje yihual unca in se hual aqui lajtúa Dios pan ipampa ilajtol lajcuiluli capa quijtúa, quil: Xiquitacan, nictilantica nolanahuatini pa anmitzlaicanas, huan yihual quinnahuatilis lacames pa quimatisi pampa tihualas. Yihual yes quinami se hual quichijchías moꞌojli quiman tehual ayamo tiajsiaya. ");
INSERT INTO nclNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Annimitzilía neli, ca moxtin hual lacatije pan lalticpan, amo quiman cataya lacal hual yec yoje hué quinami Juan Lacuayatequini. Ma yoje, Juan Lacuayatequini amo ajsi pa yes yoje hué quinami yihual hual unca in niman tipichin capa Dios huelitía. ");
INSERT INTO nclNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Pa innojen tonalijmes quiman Juan Lacuayatequini pehuac lamachiltilic, huan pan tonalijmes hual ajsitihualaloaya pa axan, lacames hual latequihuilo motolinilo pa cayasi capa Dios huelitía. ");
INSERT INTO nclNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Pa in tonalijmes quiman nesic Juan lamachiltitica, cataloaya ilamaxtilisli Dios ilajtunijmes huan in lajtol hual Dios quilajcuilultilic Moisés. Innojen lajtomes quijtunijme len yahuiaya panu. ");
INSERT INTO nclNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Axan, sinda anquinequi anquineltoca inminlamaxtilisli, cuaquinon Juan Lacuayatequini unca in Elías hual Dios ilajtol quijtúa pampa yahuiaya huala pa anmitznextilis aqui yes in Cristo. ");
INSERT INTO nclNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Aqui yes quipía inacas pa lacaquis, ma quicaqui inon ca mochi ilacaquilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Yehuanten hual yulticate axan amo quixtocaloaya Juan ilamaxtilisli huan amo quixtocalo nolamaxtilisli nehual. Amo unca nindeno calica mopaquiltisi. Cate quinami xolomes yehuaticate nepa pin lajcotiyan capa lanamacalo huan capa monechiculo xolomes pa mahuiltisi. Sequin xolomes quinnotzalo in oc sequin, quinmililo: ");
INSERT INTO nclNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Antimitzmahuiltilije quinami cataya monamictilisli huan amhuanten amo anquinequic anmahuiltic ca tehuanten. Huan antimitzmahuiltilije quinami cataya latzotzonalisli pa se mijquil huan amo anquinequic anmahuiltic.” ");
INSERT INTO nclNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jesús quinmilijtíac: —Juan hualac capa amhuanten amo lacuajtataya quinami anlacua amhuanten, huan amo cunic alcohol huan iayo uva coc. Huan amhuanten anquijtúa pampa quipía se ijyecal amo cuali hual huelitía laijtic yihual. ");
INSERT INTO nclNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nehual ilacal in cielo nihualac capa lacames nilacuajtica huan nicuntica jan quinami in oc sequin, huan amhuanten anquijtúa: “Xiquitacan in lacal lacuani huan lahuanani, inminlasojli yehuanten hual anmitzanililo ilapixcalisli tomin pa in lahueliltilisli romano. Huan noje yihual inminlasojli yehuanten hual amo quichihualo quinami monequi pa se quimolancuacuetzilis Dios, quinami quijtúa tolajtol.” Anquinami in xolomes hual amo quinequilo mahuiltilo. Ma yoje tiyulilo Juan huan nehual quinami inon pampa ticpialo Dios ilajmatilisli. Huan yehuanten hual quineltocalo tolamaxtilisli quimatilo pampa neli unca Dios ilajmatilisli calica tiyulilo. Huan yehuanten quichihualo quinami tiquinnextililo. ");
INSERT INTO nclNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Cuaquinon pehuac Jesús quinmajua yehuanten pa sequin caltilan huejué. Yehuanten cataloaya capa yihual quinchíac innojen míac ilachihualisli hual lanextilije pampa Dios neli quitilanic yihual pa in lalticpan. Laquetzac yoje pampa yehuanten amo mopalaje inminyolo pa pehualosquiaya laijnamiquilo quinami Dios, quilic: ");
INSERT INTO nclNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Dios anmitztilanis pa anpanus lacocoltilisli, amhuanten pa Corazín huan Betsaida! Unca pampa niquinchíac míac lachihualisli huejué capa amhuanten. Huan sinda innojen lachihualisli cataloaya lachihuali ca yehuanten hual yulinijme pa yina pa innojen caltilan huejué Tiro huan Sidón, quipiaya míac tonalijmes yehuanten mopalaloaya inminyolo pa laijnamiquilosquiaya quinami laijnamiquía Dios. Huan pa lanextililosquiaya quinami mopalaloaya inminyolo, molaquentiloaya ca tzotzomajli huahuastic huan molaliloaya pan tinextilan. ");
INSERT INTO nclNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Noje annimitzilía pampa yehuanten pa Tiro huan Sidón Dios amo quintilanis pa panusi míac lacocoltilisli quinami anyahui anpanúa amhuanten. Anmitztilanis pa anpanus lacocoltilisli pan tonali quiman yihual quintojtocas ilaixpan yihual yehuanten pin lalticpan hual amo quineltocalo. ");
INSERT INTO nclNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","’Huan amhuanten pa Capernaúm, anquijtúa pampa anyahui anquichía pa anmocaltilan yes hué quinami oc sequin caltilan huejué. Ma yoje, amo yahui caya yoje. Anmocaltilan xitinis huan yajmo nesis. In quipanus pampa anunca niman elehuis, amo yoje elehuis catanijme yehuanten pa Sodoma. Sinda yehuanten pa Sodoma hual yulinijme pa yina quinmitaloaya in lachihualisli huejué hual amhuanten anquinmitac, cuaquín Sodoma mocajtihualaya axan, pampa ilacames quipalaloaya inminyolo pa pehualosquiaya lajtulo pa inminyolo quinami Dios quinequi. ");
INSERT INTO nclNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Huan annimitzilía pampa yehuanten pa Sodoma Dios amo quintilanis pa panusi lacocoltilisli chicahuac quinami anpanus amhuanten pa in tonali quiman quintojtocas ilaixpan yihual moxtin pin lalticpan hual amo quineltocalo. ");
INSERT INTO nclNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Quinami pa in tonali, Jesús laquetzac ca Dios, quilic: —Nimijsehuía, Tata, tehual iTeco in cielo huan in lalticpan. Nimijsehuía pampa tiquintzacuilic pa camo quimatisi innojen yehuanten hual quijtulo pampa quimatilo míac monahuac tehual huan ma yoje amo quimatilo. Jan quipialo in ilajmatilisli in lalticpan. Quema, tiquintzacuilic pa camo quimatisi yehuanten. Ma yoje, tiquinnextilic yehuanten hual amo quipialo ilajmatilisli in lalticpan, huan cate yehuanten hual quinequilo míac pa monextilisi pan nopampa nehual. ");
INSERT INTO nclNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Quema, Tata, pampa yoje tiquitac cuali pa camo quimatisi len quinequi quijtúa molajtol yehuanten hual quijtulo pampa quimatilo. Huan quema, tiquitac cuali pa quimatisi len quinequi quijtúa molajtol yehuanten hual amo quimatilo. ");
INSERT INTO nclNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Cuaquinon Jesús quinmilic: —NoTajtzin nechlalic nehual pa niquinnextilisquiaya yehuanten pin lalticpan mochi quinami yihual unca. Nehual niunca ixól huan amaqui pin lalticpan quimati quinami niunca, amo quimati pa len nihualaya pan lalticpan. Jan noTajtzin san quimati inon. Noje amaqui pan lalticpan quimati quinami unca noTajtzin, huan amo quiximati. Jan nehual hual niunca ixól nicmati mochi quinami yihual unca, huan jan nehual san niquiximati yihual. Huan yihual san quiximatis noTajtzin aqui yes nehual nicnequis nicnextilis. ");
INSERT INTO nclNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Xihualacan ca nehual anmoxtin hual anmitzmacalo tequil huan anunca anlamantica ca mochi in lajtomes hual amo anmitzpalehuilo anmitzquixtililo anmolaijlaculisli huan anmoicnotilisli. Quema, xihualacan ca nehual, annimitzmosehuiltis. ");
INSERT INTO nclNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ximonextilican quinami anmochías nomonextilinijmes. Yes quinami ancataya lailpili ca nehual pa yoje tiomenten quinami tilamantiasi, quinami lamantialo yulijquimes. Anmoitas ca mosehuilisli pa anmoyulilisli pampa nehual amo nilamaxtía chicahuac. Nehual amo nilatequihuía chicahuac, jan sejpa niunca. ");
INSERT INTO nclNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Xihualacan ca nehual, pampa notequipanulisli amo quiman anmitzlamilis anmochicahualisli huan nolamaxtilisli unca quinami lamamani hual amo etic. ");
INSERT INTO nclNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Panuc inon, cataya pan in tonali quiman amo tequipanulo judíos, uyac Jesús panujtataya capa cataloaya in cuajmilimes ca trigo. Huan mayantataloaya imonextilinijmes. Pampín pehuaje quincapehuaje imiahuimes trigo huan quicuaje in trigo. ");
INSERT INTO nclNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Quitaje inon sequin fariseos, huan quilije: —Xiquita. Quichijticate momonextilinijmes len amo cuali. Tolajtol hual technextilía quinami ticmolancuacuetzililo Dios amo quimacahuiltía pa quichihuasi pan tonalijmes quiman amo titequipanulo. ");
INSERT INTO nclNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Huan Jesús quinmilic: —¿Amo quiman anmomaxtic pin iamal Dios ilajtol capa quijtúa in hual quichíac David? Mayantataloaya yihual huan yehuanten hual cataloaya ca yihual. ");
INSERT INTO nclNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","¿Amo anmomaxtic quinami calaquic pin tiopan huan quicuac in pan hual quilalilo in tiopistas ilaixpan Dios? Huan in lajtol quijtúa pampa jan unca inminyaxca in tiopistas san pa quicuasi in pan. Ma yoje quicuaje David huan yehuanten hual cataloaya ca yihual. ");
INSERT INTO nclNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Huan amo inon san. ¿Amo anmomaxtic pa iamal ilajtol hual anmitznextilía quinami anquimolancuacuetzilía Dios? Pan tonali siete (chicome) quiman monequi pa camo antequipanus, ma yoje tequipanulo pin tiopan in tiopistas huan amo quipialo laijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pampín, nehual annimitzilía pampa nel niunca nican huan nicpía lahueliltilisli hual amo quipialo yehuanten hual tequipanulo pin tiopan. Huan sinda ilajtol in tonali chicome amo quintzacuilía pa tequipanusi pin tiopan in tiopistas, cuaquín amo nejtzacuilía nel. ");
INSERT INTO nclNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Dios quijtúa, quil: “Nicnequi niman míac pa quimatisi laicnilisi lacames. Amo yoje míac nicnequi pa nechmacasi huendis.” Sinda anquimatiaya len quinequi quijtúa Dios quiman quijtúa inon, cuaquinon amo anejsehuiaya anquinmotexpahuili yehuanten hual amo quichihualoaya nindeno amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nehual ilacal in cielo nicpía lahueliltilisli niman hué hual amo quipía ilajtol in tiopan. Pampín noje nicpía mochi lahueliltilisli pa niquilis len huil quichía se pan tonali quiman amo antequipanúa. ");
INSERT INTO nclNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Huan quiman mohuicaya, calaquic pa inmintiopan capa momaxtiloaya Dios ilajtol. ");
INSERT INTO nclNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nepa quitac se lacal ca se imajma patzajquil. Quilajlanije Jesús len quijtuaya inahuac yihual, quilije: —¿Tolajtol hual techilía quinami ticmolancuacuetzililo Dios quimacahuiltía pa quipajtis se pan tonali quiman amo titequipanulo? Inon quilajlanije pa yoje huil quimotexpahuililosquiaya ca se laijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Huan Jesús quinmilic: —Mochi lacal ca amhuanten sinda quipiaya se borrego hual huetzic pa se coyunquil pan tonali quiman amo antequipanúa, jan axcan quiquixtiaya in borrego. ");
INSERT INTO nclNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Huan se lacal monotza niman míac, amo monotza yoje míac se borrego. Pampín, quema, in lajtol quimacahuiltía pa se quichías len cuali pan tonali quiman amo antequipanúa. ");
INSERT INTO nclNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Cuaquinon Jesús quilic in lacal: —Xicxilani momajma. Huan quixilanic imajma in lacal huan jan ajnaxcan pajtic mochi, jan quinami in oc se imajma. ");
INSERT INTO nclNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Cuaquinon quisaje yehuanten in fariseos, monechicuje pa molaquetzililosquiaya quinami huil quimictilosquiaya Jesús. Quinequiloaya quimictilo pampa Jesús amo quineltocaya inminlajtol hual quijtuaya quinami yehuanten quinequiloaya pa lacames quimolancuacuetzililosquiaya Dios. ");
INSERT INTO nclNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ma yoje, quimatic Jesús inon, huan mohuicac, amo mocahuac nepa. Niman míac lacames quitocaloaya huan quinpajtic moxtin. ");
INSERT INTO nclNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Huan Jesús quinmilic chicahuac pa camo quilaquetzilijtinemilosquiaya quinami yihual quinpajtiaya pa yoje amo quimatilosquiaya moxtin in hual yihual quichijtataya. ");
INSERT INTO nclNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Inon Jesús quinmilic pa yoje mochiasquiaya len quijtuc Dios inahuac yihual pa yina pan ipampa ilajtuni Isaías. Yihual Isaías quijcuiluc quijtutataya pa iamal, quil: ");
INSERT INTO nclNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Xiquitacan notequipanujquil. Niclajtultic pa yesquiaya notequipanujquil. Niclasojla huan pa noyolo nicpía míac paquilisli ca yihual. Niclalis noEspíritu (noIjyecal Cuali) laijtic yihual, huan yihual quihueliltis. Huan notequipanujquil quinmachiltis yehuanten hual amo judíos quinami huil quipiasi Dios ilapujpuhualisli pa inminlaijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Yihual amo mochihualtis pa lacames quicaquisi. Yihual amo lanojnotzas chicahuac pin ojlimes capa cate in niman míac lacalera. ");
INSERT INTO nclNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Yihual quinpajtis huan quinmanas pa yesi ilacames yehuanten hual quimatilo pampa amo quipialo nindeno calica mopalehuisi. Jan yihual notequipanujquil san huil quinpalehuía yehuanten hual quimonextililo yoje. In lacames cate quinami acal laxamanili, quinami se icpal tomahuac hual pupucatica se nadita pan se tapalquita pa lahuis. Quema, lacames quinami innojen yihual notequipanujquil quinmanas pa yesi iyaxca huan yihual quinsulahuas moxtin ilacocolinijmes. Quichías inon quiman quintojtocas ilaixpan yihual yehuanten hual amo quineltocalo huan cuaquín quilalis ilahueliltilisli pan lalticpan calica quichihuilis sejse jan yoje quinami quichihuilía oc se. ");
INSERT INTO nclNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Huan quiman yehuanten hual amo judíos quicaquisi itoca, quimatisi len huil quinchihuilía yehuanten. Pampa inon quilalisi inminlaneltocalisli ca yihual notequipanujquil. ");
INSERT INTO nclNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Cuaquinon quihualiquilije se hual se ijyecal amo cuali quichihualtiaya. In ijyecal quipachacaltic in lacal, noje quichihuilic pa camo huil lajtuc. Jesús quipajtic huan yoje in lacal huil lachiaya huan lajtuaya. ");
INSERT INTO nclNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Moxtin moitaloaya ca lamajtilisli huan moililoaya: —¿Cuajnesi yihual yes David imiahuil hual Dios techilic pampa yahuiaya huala pan lalticpan? ");
INSERT INTO nclNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Quiman quicaquije inon in fariseos, quilije: —In se quinquixtilía in ijyecames amo cuajcuali hual quinchihualtiticate jan pan ipampa ilahueliltilisli Beelzebú. Yihual Satanás hual huelitía pan mochi in ijyecames amo cuajcuali. ");
INSERT INTO nclNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús quimatic len quijtutataloaya laijtic inminyolo huan quinmilic: —Sinda se lahueliltilisli moana ca yihual ihuían, cuaquín moijlacus in lahueliltilisli. Huan sinda yehuanten pa se caltilan o yehuanten hual chantilo pa se cali moanalo ca yehuanten inminhuían, cuaquín yajmo yahuilo huejcahualo. ");
INSERT INTO nclNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Huan sinda Satanás moquixtis yihual ihuían pa capa huelitijtica, yihual moana ipan yihual ihuían. Yoje, yajmo huejcahuas ilahueliltilisli sinda yoje quichías. ");
INSERT INTO nclNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Huan sinda pan ipampa Beelzebú ilahueliltilisli nehual niquinquixtilía lacames in ijyecames, cuaquín ¿pan ipampa aqui ilahueliltilisli quinquixtililo ijyecames anmomonextilinijmes? Noje yes pan ipampa ilahueliltilisli Beelzebú. Huan sinda amhuanten anquijtúa inon, cuaquín anmomonextilinijmes yalo anmitzmotexpahuililo, pampa anquijtutica yehuanten quinquixtililo ijyecames pan ipampa Beelzebú. ");
INSERT INTO nclNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Axan, sinda nehual niquinquixtilía in ijyecames lacames pan ipampa Dios iEspíritu ilahueliltilisli, huan yoje nicchía, cuaquinon axan hualac Dios ca amhuanten pa huelitis. ");
INSERT INTO nclNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Sinda se quinequi calaqui pa calijtic icali se lacal chicahuac pa quixtequilis len quipía, monequi pa quipehualtis quilpilijtica in lacal chicahuac. Cuaquín huil quixtequilis len quipía pa icali. Huan jan yoje niunca quinami niquilpic Satanás huan iijyecames amo cuajcuali hual pan yehuanten yihual huelitía. Axan huil niquinquixtilía moxtin lacames innojen ijyecames. ");
INSERT INTO nclNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Aqui yes amo unca ca se lajtulisli ca nehual, cuaquín yihual unca nolacocolini. Huan aqui yes amo nechpalehuis pa niquinnechicus lacames pa yoje momacahuiltisi pa Dios huelitis pan yehuanten, cuaquín yihual quinsemana in lacames pa camo monechicusi pa yesi ca nehual. ");
INSERT INTO nclNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Pampín, annimitzilía Dios quinpujpuhuas mochi inminlaijlaculisli hual quichihualo lacames. Ma yoje, Dios amo quiman quinpujpuhuas yehuanten hual quihuejuecaltilo in Espíritu Santo. ");
INSERT INTO nclNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Huan aqui yes quijtúa len amo cuali nonahuac nehual ilacal in cielo, Dios huil quipujpuhuas. Ma yoje, aqui yes quijtúa len amo cuali inahuac in Espíritu Santo, cuaquín Dios amo quiman quipujpuhuas pa mochi in tonalijmes huejcahuas in lalticpan, huan amo quipujpuhuas quiman lamis in lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Quiximatilo se cuahuil pan ipampa ilaquilyo. Anquijtúa se cuahuil unca cuali quiman ilaquilyo unca cuali. Anquijtúa se cuahuil amo unca cuali sinda ilaquilyo amo unca cuali. Quiman nel niquinquixtilía in ijyecames amo cuajcuali, nicchijtica len cuali huan yoje monequi pa anquimatis pampa nel nicuali. ");
INSERT INTO nclNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Amhuanten Satanás ilacames! Amo anquijtúa len cuali pampa amhuanten amo anunca cuali. Lajtúa se lacal pampa in míac lajtulisli cate pa iyolo. ");
INSERT INTO nclNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Se lacal cuali lajtúa pampa in míac cuali unca pa iyolo. Huan se lacal amo cuali lajtúa pampa in míac amo cuali unca pa iyolo. ");
INSERT INTO nclNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Huan annimitzilía pampa quinmixcomacas Dios in lacames ca mochi lajtol laijlaculi hual quijtulo. Quema, pa in tonali quiman Dios quintojtocas ilaixpan yihual yehuanten pin lalticpan hual amo quineltocalo, yehuanten quimachiltisi mochi hual quichihuaje. ");
INSERT INTO nclNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Dios anmitztojtocas ilaixpan yihual pampa anlajtúa elehuis. Sinda cataloaya cuajcuali anmolajtomes anmitzquixtís anmolaijlaculisli huan sinda amo cuajcuali anmolajtomes, anmitzcahuilis anmolaijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Cuaquinon sequin ilamaxtinijmes ilajtol hual quinnextilía quinami quimolancuacuetzililo Dios in judíos huan sequin fariseos quilije: —Lamaxtini, ticnequilo timitzitalo ticchías len hual lanextilis pampa neli ticpía Dios ilahueliltilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús quinnanquilic: —Yehuanten hual yulticate axan cate amo cuali huan quicajcahualo Dios. Jan lacames quinami yehuanten quitemulo pa quitasi len hual lanextilía pampa se quipía Dios ilahueliltilisli. Huan Dios amo quinmacas lacames quinami innojen se lanextilisli. San quinmacas ilanextilisli Jonás, hual yec Dios ilajtuni. ");
INSERT INTO nclNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yihual Jonás cataya laijtic iyolo in michin niman hué pa ye tonalijmes huan ye layuajmes. Huan len quinami inon nechpanus nehual ilacal in cielo. Nehual nicayas lalalili laijtic in lali quiman nimiquis. Nimocahuas nepa ye tonalijmes huan ye layuajmes. ");
INSERT INTO nclNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Pan tonali hual Dios quintojtocas ilaixpan yihual yehuanten hual amo quineltocalo, cuaquín moquetzasi in lacames hual yulinijme pin caltilan hué Nínive quiman Dios quinlatexpahuilis yehuanten hual yulticate axcan. Huan yehuanten hual yulinijme pa Nínive quinmotexpahuilisi yehuanten hual yulticate axan. Quinmotexpahuilisi pampa yehuanten pa Nínive quipalaje inminyolo pa pehualosquiaya lajtulo pa inminyolo quinami Dios. Cataya quiman quinnotzac Jonás quinmilijtataya ilajtol Dios. Huan xiquitacan. Nican unca se niman hué. Jonás amo yec hué quinami in se. Ma yoje yehuanten hual yulticate axan amo quinequilo nechcaquilo. ");
INSERT INTO nclNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Huan pan tonali hual Dios quintojtocas ilaixpan yihual yehuanten hual yulticate axan, cuaquín moquetzas in hué sihual hual yulini pin lali Sebá hual unca pin sur. Huan yihual quinmotexpahuilis yehuanten hual yulticate axan. Quinmotexpahuilis pampa yihual hualac niman huejca pa quicaquis nican in hué Salomón ilajmatilisli. Huan xiquitacan, unca nican se niman hué. Salomón amo yec hué quinami in se. Ma yoje amo quinequilo nechcaquilo yehuanten hual yulticate axan. ");
INSERT INTO nclNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Quisa se ijyecal amo cuali hual quichihualtía laijtic se lacal, cuaquín nejnentinemis pa capa unca lali huaqui. Quitemujtinemi capa huil mosehuis, huan amo quita capa mosehuis. ");
INSERT INTO nclNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Cuaquín quilía: “Nehual nimocuepas pa nochan hual unca icuerpo in se pa capa niquisac.” Huan quiman ajsi, quita icuerpo in se axan quinami se cali capa amo unca nindeno huan unca quinami laxpanali huan lachijchihuali jan cuali. ");
INSERT INTO nclNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Cuaquín yahui yihual huan quinmana oc sequin chicome ijyecames niman ejꞌelehuis. Yihual amo ajsic yec elehuis quinami yehuanten. Cuaquinon hualalo, calaquilo icuerpo in se huan nepa chantilo. Yoje in se capa calaquije moita niman temajquil. Amo yoje temajquil cataya quiman jan cataya se ijyecal san laijtic icuerpo. Jan yoje quinpanus in lacames ejꞌelehuis hual yulticate axan. ");
INSERT INTO nclNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ayamo mocahuac quinlaquetzilic yehuanten quiman hualaje inantzin huan icnían huan mocahuaje moqueztataloaya pa itenco in lacalera, quinectataloaya laquetzalo ca yihual. ");
INSERT INTO nclNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Cuaquinon se quilic: —Quita. Moquezticate pa quiahuac monantzin huan mocnían, quinecticate laquetzalo ca tehual. ");
INSERT INTO nclNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Huan Jesús quinanquilic yihual hual quilic inon, quilic: —Ma nimitzili aquinojen yehuanten hual niquijtúa cate nonantzin huan nocnían. ");
INSERT INTO nclNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Huan quixilanic imajma ca imonextilinijmes huan quilic: —Quita. Innojen nonantzin huan nocnían. ");
INSERT INTO nclNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Aqui yes quichías len quinequi noTajtzin hual unca pin cielo, in se unca nocni lacal huan nocni sihual huan nonantzin. ");
INSERT INTO nclNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Pa in tonali quisac Jesús pin cali huan molalic pa itenco in al huejcalan. ");
INSERT INTO nclNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Huan monechicuje capa yihual niman míac lacalera. Pampa inon lejcuc pan se barquito, molaliaya, huan mochi in míac lacames mocahuaje moquezticate pa itenco in al huejcalan. ");
INSERT INTO nclNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Huan Jesús quinlaquetzilic míac pan ipampa sequin lapuhualisli calica quinextiliaya ilamaxtilisli. Quinmilic: —Quisac se lacal latocani pa latocas. ");
INSERT INTO nclNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Huan quiman latocatiahuiaya, sequin in latocli quixintiahuiaya pa itenco in ojlito. Huan temujtihualaje in tutomes, quincuaje. ");
INSERT INTO nclNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Xintiahuiaya in lacal, sequin in latocli calaquije pin lali canahuac capa quipiaya tel itzindan. Jan ajnaxcan ixuaje pampa amo cataya telahuac in lali. ");
INSERT INTO nclNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Quisac in tonali laixpelatataya chicahuac. Quinchichinuc in pacholimes huan huaquije pampa amo quipialoaya lalhuayojmes. ");
INSERT INTO nclNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Quixintiahuiaya sequin in latocli pin huiztilan, huan moscaltitiquisaje in huizlimes, quintzacuilije in pacholimes hual ixuaje capa xiniaya in latocli. ");
INSERT INTO nclNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Cuaquinon, quixintiahuiaya oc sequin latocli pan lali cuali, huan quiman ixuaje, laquije cien pa sejse latocli, ca oc sequin laquije sesenta, ca oc sequin laquije treinta pa sejse latocli hual yec latocali. ");
INSERT INTO nclNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Aqui yes quipía inacas pa lacaquis, ma caya jan sejpa pa quicaquis. ");
INSERT INTO nclNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ajsije capa yihual imonextilinijmes, quilije: —¿Leca tiquinlaquetzilía ca lapuhualisli pa tiquinmaxtis? Quinnanquilic: ");
INSERT INTO nclNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","—Niquinlaquetzilía yoje pampa amo quimacahuiltía Dios pa yehuanten quimatisi ilajtulisli iyolo huan ilachihualisli hual quiman pehuac in lalticpan huan pa axan quinlatilic moxtin. Axan quinlamachiltilijtica jan sequin san. Huan amhuanten anunca yehuanten hual Dios quinlamachiltilijtica ilachihualisli huan ilajtulisli hual anmitznextilis quinami yahui huelitía. ");
INSERT INTO nclNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Unca pampa aqui yes quipía lajmatilisli hual lanextilía quinami Dios huelitía, yihual yajtía quipixtica mojmosta oc se nadita in lajmatilisli. Huan aqui yes amo quipía lajmatilisli hual quinextilía quinami Dios huelitía, yoje Dios quichihuilis pa yajmo huil quimatis quinami Dios huelitía. ");
INSERT INTO nclNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Pampín niquinlaquetzilía pan ipampa lapuhualisli hual quinlatililo nolamaxtilisli, pampa yehuanten, mas que huil lachía, amo quinequilo monextililo len quinequi quijtúa nel nolamaxtilisli. Huan mas que lacaquilo amo quinequilo quimatilo nolamaxtilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Huan pan inminpampa yehuanten, yoje mochijtica len Dios ilajtuni Isaías quijtuc inminahuac yehuanten. Quijtuc quinami yahuiloaya yelo, quijtuc, quil: Mas que anlacaqui, amo anquimati len quinequi quijtúa. Huan mas que anlachía ca anmoixtololojmes, ma yoje amo anquimatis pa anmoyolo len quinequi quijtúa. ");
INSERT INTO nclNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Unca pampa inminlajmatilisli inminyolo yehuanten yajmo quinpalehuía pa quimatisi len quinequi quijtúa. Huan inminacajmes yajmo lacaquilo cuali pa quimatisi pa inminyolo len quinequilo quijtulo nolajtomes. Unca quinami motzacuilijque inmixtololojmes pa yoje amo quitalosquiaya pa quimatilosquiaya. Quema, quichihualo mochi len huil quichihualo pa yoje amo quimatisi pa inminyolo len quinequi quijtúa nolajtol. Quichihualo yoje pa camo yelosquiaya lapatili pa inminyolo, huan pa yoje nehual amo niquinpajtilisquiaya inminlaijlaculisli. Yoje quijtuc Isaías quiman quijcuiluc ilajtol Dios. ");
INSERT INTO nclNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Ma yoje, ¡quinami anquipías paquilisli pampa anquita innojen hual niquinchía huan anquimati len nicnequi niquijtúa! Huan anquicaqui innojen lajtomes hual niquinmijtúa huan anquimati len quinequilo quijtulo. ");
INSERT INTO nclNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Neli annimitzilía inon. Catanijme míac ilajtunijmes Dios huan míac oc sequin ilacames Dios hual quinequinijme míac quitalo innojen hual amhuanten anquinmiztica. Ma yoje, amo quiman quinmitaje. Quinequinijme míac quincaquilo innojen lajtomes hual amhuanten anquincactica, huan amo quiman quincaquije. ");
INSERT INTO nclNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Xilacaquican axan, huan annimitznextilis len quinequi quijtúa ilapuhualisli in latocani. ");
INSERT INTO nclNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Quiman yes quicaquis se in lajtol hual lanextilía quinami Dios huelitía, huan amo quimati len quinequi quijtúa, cuaquín hualas in lili huan quilcahualtía in lajtol hual quicaquic. In lacal unca quinami in lali pa itenco in ojlito capa quixintiahuiaya in latocli. ");
INSERT INTO nclNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Huan in lali canahuac capa quixintiahuiaya capa cataya tel itzindan, in quinami se hual quicaqui ilajtol Dios huan quineltoca ca paquilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ma yoje, yihual quinami in latocli hual amo quipía lali telahuac pampa unca tel itzindan. Amo calaqui pin lali míac, huan ca in se amo calaqui in lajtol míac laijtic iyolo. Yoje, yihual quineltoca ilajtol Dios pa se nadita. Huan quiman péa panúa len lacocoltilisli pampa quineltoca ilajtol Dios, quiman quitojtocalo pampa quineltoca, cuaquín jan axcan mocahua pa quineltocas. ");
INSERT INTO nclNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Huan in lali capa catá huiztilan capa quixintiahuiaya in latocli unca quinami se hual quicaqui ilajtol Dios, huan ma yoje momaca míac tequil inahuac quinami yahui yuli pan lalticpan. Noje amo mocahua pa quijnamiquis quinami huil monechiculis míac tomin. Huan jan quinami in huizli quintzacuilía in pacholimes yajyancuic, jan yoje in se ilaijnamiquilisli quitzacuilía Dios ilajtol pa camo mocahuas laijtic iyolo. Yoje yajmo quipalehuía ilajtol Dios. ");
INSERT INTO nclNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Huan in lali cuali capa quixintiahuiaya in latocli unca quinami se hual quicaqui Dios ilajtol huan quimati len quinequi quijtúa. Huan Dios ilajtol yajtía quijnamiquiltijtica míac. Quichihuilis quinami pacholi hual quilaquiltía cien ilaquilyo ca se latocli. O quichihuilis quinami pacholi hual quilaquiltía sesenta ilaquilyo ca se latocli o quinami se pacholi hual quilaquiltía treinta ilaquilyo ca se latocli. Quema, Dios quichía míac pan ipampa in se. ");
INSERT INTO nclNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Quinpuhuilic oc se lapuhualisli calica yahuiaya quinnextili ilamaxtilisli, quinmilic: —Dios huelitía yoje pan lalticpan. Unca quinami se lacal hual quitocac trigo ca latocli cuali pa icuajmili. ");
INSERT INTO nclNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Huan coxtataloaya itequipanujquimes, hualac ilacocolini, quitocac latocli amo cuali ca in trigo latocali, cuaquín uyac. ");
INSERT INTO nclNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Quiman ixuaje inminpacholimes in trigo huan quilalilije miahuil, noje nesije inminpacholimes in latocli amo cuali, hual nesiloaya quinami trigo huan ma yoje amo quipialoaya imiahuil trigo. ");
INSERT INTO nclNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Cuaquín hualaje itequipanujquimes in teco capa yihual, quilije: “Xiquita, Tata, ¿amo tictocac latocli cuali pa mocuajmili? ¿Leca quipía in pacholimes amo cuali?” ");
INSERT INTO nclNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Quinmilic: “Quichíac inon se nolacocolini.” Quilije itequipanujquimes: “¿Ticnequi pa tiasi pin cuajmili pa tiquincapunasi in pacholimes amo cuajcuali?” ");
INSERT INTO nclNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Yihual quinmilic: “No, amo xicchihuacan yoje, amo sangá anquincapunas noje inminpacholimes in trigo quiman anquincapuntica inminpacholijmes in latocli amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ma moscaltitiacan in omenten huan quiman ajsis in lapixcalisli, cuaquinon niquinmilis in lapixcanijmes pa pehuasi quitequisi in pacholimes amo cuajcuali. Quinmontusi huan quilpisi ca míac pa quichichinusi. Huan inminpacholimes in trigo quinmontusi huan quilpisi ca míac huan quilalisi pa nochan.” ");
INSERT INTO nclNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Quinmilic oc se lapuhualisli calica quinnextilic ilamaxtilisli, quinmilic: —In unca quinami panúa capa Dios huelitía. Unca quinami se lacal hual canac se ilatocli in mostaza huan quitocac pa icuajmili. ");
INSERT INTO nclNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","In latocli unca niman tipichin, amo yoje mochi oc sequin latoclimes hual quitocalo lacames. Ma yoje, quiman moscaltis, unca niman hué, amo yoje hué mochi in oc sequin pacholimes. Mochías hué quinami se cuahuil, huan hualalo in tutomes hual palanilo, mosehuilo pani iramas (iitzmolinquimes). ");
INSERT INTO nclNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Quinlaquetzilic oc se lapuhualisli calica quinnextilic ilamaxtilisli, quinmilic: —Yoje unca quinami panúa capa Dios huelitía. Unca quinami se sihual hual canac laxocoyajquil huan quilalic pa se lamachihualoni harina, huan cuaquín moteposahuac mochi in texli. ");
INSERT INTO nclNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Mochi innojen lajtomes quinmilic Jesús in míac lacalera pan inminpampa lapuhualisli calica quinnextilic ilamaxtilisli. Quema, jan ca lapuhualisli quinami innojen Jesús quinlaquetzilic yehuanten, amo quinlaquetzilic ca oc se laquetzalisli. ");
INSERT INTO nclNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yoje quinlaquetziliaya pa mochías len Dios ilajtuni quijcuiluc, quijtuc, quil: Niclapus nocamac pa nilaquetzas pan ipampa lapuhualisli calica nilamaxtis. Niquinmilis innojen hual quiman nicchíac in lalticpan pa axan, amo nicmacahuiltiaya pa quimatisi lacames. Yoje quijtúa pin amal hual quijcuiluc Dios ilajtuni. ");
INSERT INTO nclNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Cuaquinon Jesús quinmilic in míac lacames pa mohuicalosquiaya huan yihual calaquic pa calijtic. Huan hualaje capa yihual imonextilinijmes, quilije: —Xitechili len quinequi quijtúa ilapuhualisli molamaxtilisli in latocli amo cuali hual nesic quinami trigo mas que amo yec trigo. ");
INSERT INTO nclNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Quinnanquilic: —Yihual hual quixinic in latocli unca nehual ilacal in cielo. ");
INSERT INTO nclNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","In cuajmili pin lapuhualisli unca quinami in lalticpan. In latocli cuali unca quinami in lacames hual pan yehuanten Dios huelitijtica. Huan in latocli amo cuali hual nesi quinami trigo quiman ixua, huan ma yoje amo unca, in unca quinami yehuanten capa Satanás huelitijtica. ");
INSERT INTO nclNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","In lacocolini hual quixinic in latocli amo cuali unca quinami in lili Satanás. In lapixcalisli unca quinami quiman lamis in lalticpan hual axan unca. Innojen lapixcanijmes cate quinami Dios ilanahuatinijmes pin cielo. ");
INSERT INTO nclNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Huan quinami yehuanten quinnechiculo inminpacholimes in latocli amo cuali huan quichichinulo pin tixuxli, inon unca quinami quiman lamis in lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nel ilacal in cielo niquintilanis pa temuán nolanahuatinijmes pin cielo. Huan yehuanten quinnechicusi moxtin hual cate capa Dios huelitía, moxtin hual quinmijlaculo oc sequin ilaixpan Dios. Quema, huan quinnechicusi yehuanten hual yulilo quichijticate amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Quinlasasi ca capic panusi lacocoltilisli hual quincocoltis quinami tixuxli. Nepa choca huan lacuajcualo ca inminlames pampa quincocúa niman míac. ");
INSERT INTO nclNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Cuaquín quinpanus len niman cuali Dios ilacames hual yihual quinmitas amo quipixticate laijlaculisli nindeno. Quema, Dios ilacames nesisi ca mochi Dios ilaixpelalisli cualtichin capa Dios inminTajtzin huelitía. ¡Ma quicaqui inon aqui yes huil lacaqui! ");
INSERT INTO nclNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Dios ilahueliltilisli unca quinami len hual ipati niman míac huan unca lalatili pin se cuajmili. Quiman se lacal quita capa unca lalalpachuli, mocuepa quilatía. Cuaquín yahui pa quinamacas mochi hual quipía pa yoje huil mocuhuilis in cuajmili. Mocuhuilis quipixtica míac paquilisli pampa quitac in hual ipati niman míac. ");
INSERT INTO nclNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Noje, sinda se quinequi caya capa huelitía Dios, yihual unca quinami se lanamacani hual yajtinemi quintemujtica tixcalitos hual ipatilo míac pa mocuhuilis. ");
INSERT INTO nclNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Huan quiman in lanamacani quita se tixcalito hual ipati niman míac, cuaquín yahui, quinamaca mochi hual quipía huan mocuhuilía in tixcalito ca in tomin hual quilaxlahuiloaya pa mochi hual quinnamaquiltic. ");
INSERT INTO nclNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Ca oc se lapuhualisli, Dios ilahueliltilisli huil moita quinami se latzojuini niman hué pa michimes hual quilasalo pan al huéjcalan huan quinmana michimes huejué huan tijtipichin. ");
INSERT INTO nclNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tentica in latzojuini ca michimes, quitilanalo pa itenco in al huejcalan. Molalilo, quinnechiculo in michimes cuajcuali, quinlalijticate pa chiquihuimes. Huan quinlasalo in michimes amo cuajcuali. ");
INSERT INTO nclNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Inon unca quinami yes quiman lamis in lalticpan. Hualasi Dios ilanahuatinijmes pin cielo huan quinxilusi yehuanten hual amo yulilo cuali pa camo cayasi ca yehuanten hual yulilo quinami Dios quinequi. ");
INSERT INTO nclNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Huan quinlasasi yehuanten hual yulilo amo cuali ca capic amo quiman laquisasi panusi lacocoltilisli, quincocoltis quinami tixuxli. Nepa moxtin chocasi huan lacuajcuasi inminlames pampa quincocúa niman míac. ");
INSERT INTO nclNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesús quinmilic: —¿Axan anquimati len quinequije quijtuje mochi innojen? Quilijque: —Quema, Tata. ");
INSERT INTO nclNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Cuaquinon quinmilic: —Dios ilajtol hual quijtuc pa yina unca Dios ilajtol hual moviejojtic. Huan in lajtol hual lanextilía quinami Dios huelitía unca ilajtol yancuic. Sinda anquimati len quinequilo quijtulo mochi innojen, yoje huil anquimatis quinami unca ca se hual quimaxtía ilajtol Dios huan noje unca lamaxtili pa quimatis quinami Dios huelitía axan. Se hual unca quinami in lacal quimati lamaxtía ca lajtol hual quijtuje pa yina huan ca lajtol yancuic. Yihual quinami se hual quipía cali hué capa quipía laꞌajcoquili innojen lachihuali pa yina huan innojen hual yajyancuic hual ipatilo míac. Huan in lacal quimati quinquixtía innojen quiman quinequi quintequipanúa. Huan jan yoje yihual hual quimati Dios ilajtol hual quijtuc pa yina huan ilajtol yancuic quimati quitequipanúa quiman quinequi lamaxtía. ");
INSERT INTO nclNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Quiman panuc inon huan lamic quinlaquetzilic Jesús innojen lapuhualisli calica lamaxtitataya, mohuicac, canac ojli. ");
INSERT INTO nclNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ajsic pa yihual ilali capa moscaltic quiman yec xolol. Pehuac quinmaxtic pa inmintiopan capa momaxtilo in judíos. Huan moitaloaya ca lamajtilisli pampa in hual quimaxtiaya, quililoaya: —¿Capa canac in lacal in lajmatilisli? ¿Quinami huil quinchía mochi innojen hual techlachialtilo ca lamajtilisli? ");
INSERT INTO nclNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Yihual jan ixól in carpintero san. Huan inantzin itoca María, huan motocalo icnían Santiago huan José huan Simón huan Judas. ");
INSERT INTO nclNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Huan icnían sihuames chantilo moxtin ca tehuanten. ¿Capa quinmanac in lacal mochi innojen hual huil quinchía? ");
INSERT INTO nclNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Huan amo quixtocaloaya, quixijxiculoaya Jesús. Pampín yihual quinmilic: —Ca capic yes yahuis se ilajtuni Dios, quimatilo momajtilo ilaixpan yihual. Ma yoje, quiman unca capa yehuanten pa icaltilan huan pin cali capa chantilo icnían, amo quimatilo momajtilo ilaixpan. ");
INSERT INTO nclNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Huan pampa yehuanten amo quineltocaloaya, Jesús amo quinchíac míac lachihualisli huejué nepa. ");
INSERT INTO nclNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Pa innojen tonalijmes, quicaquic Herodes quinami molaquetzililoaya moxtin inahuac mochi hual quichihuaya Jesús. In Herodes huelitiaya pin lalticpan Galilea. ");
INSERT INTO nclNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Quinmilic yehuanten hual quitequipanuililoaya, quil: —Niquijtúa in Jesús neli yes Juan Lacuayatequini. Mas que miquic Juan, axan yultica oc sejpa. Huan pampa yultica oc sejpa, quipía lahueliltilisli pa quinchías mochi innojen hual quinmolachialtilo lacames ca lamajtilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Yojque quijtuc Herodes, pampa quiman ayamo quimatic Herodes in hual Jesús quinchihuaya, latilanic pa quiquitzquilosquiaya Juan pa quilpililosquiaya ca teposli huan pa quitzacualosquiaya pin calijtic. Herodes quichihuilic yojque pa quipaquiltisquiaya Herodías. In Herodías yec isihua Felipe hual yec icni Herodes. ");
INSERT INTO nclNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Huan Herodes latilanic pa Juan yes latzacuali pin calijtic pampa Juan quilic: —Amo unca moyaxca pa anyulis huan yihual, pampa yihual isihua mocni. ");
INSERT INTO nclNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Yoje, mas que Herodes quinequiaya latilani pa quimictilosquiaya Juan, yihual momajtic pampa cualanilosquiaya in lacalera. Yehuanten quimatiloaya Juan yec ilajtuni Dios. ");
INSERT INTO nclNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ma yoje, pa in tonali quiman quipialoaya fiesta (ilhuil) pa Herodes pa quijnamiquilosquiaya quiman lacatic, cuaquín Herodías ixolol sihual mijtotic inminlaixpan yehuanten hual quinnotzaje pa hualasi pa in fiesta. Huan Herodes quixtocac quinami mijtotic. ");
INSERT INTO nclNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Pampa inon quimacac ilajtol pampa quimacasquiaya len yes quilajlanisquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Herodías inantzin in xolol sihual quilic ixolol quiman lamic mijtotic pa quilajlanisquiaya Herodes pa quimacasquiaya itzontecon Juan Lacuayatequini pan se xicali. Yojque quichíac in muachita quinami quilic inantzin. ");
INSERT INTO nclNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Cuaquín in hué Herodes icnotic míac. Ma yoje latilanic pa quihualiquililosquiaya. Quichíac yojque pampa quimacac ilajtol. Huan yehuanten hual quinnotzaje pa in fiesta quicaquije quiman quimacac ilajtol. ");
INSERT INTO nclNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Yoje, quitilanic se guache pa quicotonilisquiaya iquixlan Juan capa cataya latzacuali calijtic. ");
INSERT INTO nclNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Huan quihualiquilic itzontecon pan se xicali, huan quimacac in muachita huan yihual quihuiquilic inantzin. ");
INSERT INTO nclNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Cuaquín hualaje pin calijtic Juan imonextilinijmes, canaje in mijquil huan quilaltocaje. Cuaquinon uyaje quipuhuilije Jesús len panuc. ");
INSERT INTO nclNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Quiman Jesús quimatic inon, yihual mohuicac pan se barquito, uyajtíac pa capa amaqui chantiaya. Huan quiman quimatije in lacalera ca capic uyac Jesús, cuaquín quitocaje nejnentiyahuiloaya pa ojli. ");
INSERT INTO nclNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Huan quisac Jesús pin barquito, quinmitac lacalera, je lanechiculisli hué. Quinmicnilic yehuanten huan quinpajtic in cocoxquimes hual ca yehuanten cataloaya. ");
INSERT INTO nclNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Hualaje pin barquito ca Jesús imonextilinijmes. Quiman tiolactic, yehuanten hualaje ca yihual, quilije: —Nican ticate capa amaqui chanti, huan axan panuc in semilhuil, monequi pa tilacuasi. Xiquinmili in lacalera pa mohuicasi, yoje huil yasi pa in calimes pa mocuhuilisi len quicuasi. ");
INSERT INTO nclNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús quinmilic: —Amo monequi pa mohuicasi. Amhuanten xiquinmacacan len quicuasi. ");
INSERT INTO nclNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Quilije: —Nican ticpialo jan macuili panes pa quincuasi huan ome michimes san. ");
INSERT INTO nclNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Quinmilic: —Xichualiquilican nican. ");
INSERT INTO nclNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Cuaquinon quinmilic in lacalera pa molalilosquiaya pani pin ixlán (ixlahuayan) capa cataya míac sacal. Quinmanac innojen macuili panes chicuenta tzopimes huan innojen ome michimes, lachíac pa in cielo (ilhuicac), quisehuic Dios. Cuaquín quinlapanac in panes, quinmacac imonextilinijmes, huan yehuanten quinxiluilije mochi sejse innojen míac lacames. ");
INSERT INTO nclNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Moxtin lacuaje huan pachihuije. Quinpejpenaje mochi in lajlajco hual mocahuaje huan quintemiltije doce (majlaclihuanome) chiquihuimes. ");
INSERT INTO nclNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Cataloaya cinco (macuili) mil lacames hual lacuaje huan amo quinpuhuaje in sihuames huan xolotzitzindis hual noje lacuaje huan pachihuije. ");
INSERT INTO nclNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jan ajnaxcan, Jesús quinmilic imonextilinijmes pa lejculosquiaya pan in barquito pa quipanahuisi quilaicanticate yihual ca yoje itenco (analco) in al huejcalan. Huan yihual yahuiaya mocahua pa quinmilisquiaya in míac lacames pa mohuicalosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Quiman quinmilic pa mohuicalosquiaya, yihual panquisac se loma (tepetzindi) ihuían pa quilajlanisquiaya Dios. Huan quiman layuajtic, nepa mocahuac ihuían. ");
INSERT INTO nclNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","In barquito axan cataya lajco pin al huejcalan, majcoquiaya in al huan quihuixuaya in barquito, pampa ijyecatataya inminpan yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Huan pa cualcan, uyac Jesús capa yehuanten cataloaya, nejnentiahuiaya pani in al. ");
INSERT INTO nclNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Quiman quitaje imonextilinijmes Jesús nejnentiahuiaya pani pin al, momajtije niman míac, tzajtzije: —¡Unca se temajquil! —huan tzajtzije ca momajtilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jan axcan Jesús quinnotzac, quinmilic: —¡Amo xicmacajsican! ¡Nehual niunca, amo ximomajtican! ");
INSERT INTO nclNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Cuaquín Pedro quinanquilic: —Tata, sinda tehual tiunca, xichili pa nehual nihuala capa tehual pani pin al. ");
INSERT INTO nclNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Huan Jesús quilic: —Xihuala. Cuaquinon quisac Pedro pin barquito, nejnemic pani pin al pa yasquiaya capa Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ma yoje, pehuaya quita quinami chicahuac ijyecatataya, huan quimacajsic, pehuac moijsimac. Jan axcan quitzajtzilic Jesús, quilic: —¡Tata, xichquixti, nipolejtica! ");
INSERT INTO nclNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Huan jan axcan quixilanic Jesús imajma, quiquitzquic huan quilic: —¡Amo tichneltoca jan nadita san! ¿Leca ticmahuiliaya pampa tiahuiaya timoatocti? ");
INSERT INTO nclNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Quiman lejcuje pin barquito laijtic, mosehuic in ijyecal. ");
INSERT INTO nclNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Huan yehuanten hual cataloaya pin barquito quimolancuacuetzilije Jesús, quilije: —Neli tehual tiDios iXól. ");
INSERT INTO nclNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Quiman quipanahuije in al huejcalan, ajsije pa in lali itoca Genesaret. ");
INSERT INTO nclNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Huan quiman quitaje yehuanten hual yuliloaya nepa, quiximatije, huan lanahuatije pa mochi itenco in lali pampa axan cataya nepa Jesús. Huan quihualiquilije moxtin in cocoxquimes. ");
INSERT INTO nclNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Quilajlanije pa quinmacahuiltisquiaya pa in cocoxquimes jan quimatocalosquiaya ilatemijmiluli inahuas. Huan pajtije moxtin hual quimatocaje. ");
INSERT INTO nclNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Cuaquinon hualaje capa Jesús sequin ilamaxtinijmes in lajtol hual quinnextía quinami quimolancuacuetzililo Dios in judíos. Hualaje ca in fariseos, chantiloaya pa Jerusalén, quilije: ");
INSERT INTO nclNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Leca tiquinmaxtía momonextilinijmes pa camo quineltocasi in lajtomes hual techmacaje totajtzitzían? In lajtol hual techmacaje yehuanten pa yina quijtúa pa se quinpacas imajmajuan pa yoje quinquixtilisi imajmajuan ilaijlaculisli. Monequi pa quinpacas quiman yalo lacualo. Huan momonextilinijmes amo quichihualo yoje. ");
INSERT INTO nclNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús quinnanquilic: —Huan amhuanten, ¿leca anyultía amo anquineltocatica len Dios anmitzilic pa anquichías? Yihual amo anquineltoca, huan ma yoje, anquineltoca in lajtomes hual anmitzmacaje anmotajtzitzían pa yina. ");
INSERT INTO nclNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dios anmitzilic: “Xicmatican ximomajtican inminlaixpan motajtzin huan monantzin.” Huan: “Aqui yes quilis amo cuali itajtzin o inantzin, cuaquinon ma quitilanican pa yehuanten hual quipialo lahueliltilisli pa yes lamictili.” ");
INSERT INTO nclNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Huan amhuanten anquijtúa pampa se lacal amo quipía pa quinpalehuis itajtzin huan inantzin, mas que yoje quimati momajtía se inminlaixpan yehuanten. No, in lajtol hual anmitzmacaje pa yina anmotajtzitzían quijtúa pampa sinda se lacal quichías huendi ca mochi hual quipía pa yoje yes iyaxca in tiopan quiman miquis in lacal, cuaquín amo huil quinpalehuis itajtzin huan inantzin ca itomin pampa axcan unca huendi. Ma yoje in lacal huil mopalehuía ca itomin hual monechiculía yoje. San amo huil quimaca oc se hual quinequi pa se quipalehuis, mas que cuajnesi yesi itajtzitzían. Yoje, quiman anquineltoca inminlajtomes anmotajtzitzían pa yina, anquijlacúa len Dios quijtuc pa anquichías. ");
INSERT INTO nclNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Amhuanten anyuli anislacatijtica. Anquinequi pa annesis cuali inminlaixpan oc sequin, huan pa anmoyolo anquijtúa len amo cuali. Isaías ilajtuni Dios quijtuc melahuac anmonahuac amhuanten. Pa yina quijcuiluc quinami ancayas amhuanten hual anyuli axan, quijtuc, quil: ");
INSERT INTO nclNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","In lacames lajtulo quinami neli nechlasojlalo, mas que amo nechlasojlalo. Nejchihuilía lamajtilisli jan ca len quijtulo. Ma yoje, pa inminyolo amo nechlasojlalo huan amo nejchihuililo lamajtilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Quiman nechmolancuacuetzililo, yoje islacatilo. Amo quinpalehuía inminyolo pa yesi cuali. Yehuanten inminlamaxtilisli unca len jan lacames san quijtulo mas que yehuanten quijtulo pampa unca len quijtúa Dios. Yoje quijtuc Isaías. ");
INSERT INTO nclNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Cuaquinon Jesús quinnotzac in lacalera pa hualalosquiaya capa yihual huan quinmilic: —Xijcaquican inon huan xicmatican len quinequi quijtúa. ");
INSERT INTO nclNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Dios amo quita se lacal amo cuali pampa calaqui len pa icamac se. Quita amo cuali se lacal pampa in hual quisa pa icamac. ");
INSERT INTO nclNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Cuaquinon hualaje imonextilinijmes, quilije: —¿Ticmati pampa niman amo quixtocaje in fariseos quiman quicaquije in hual tiquijtuc? ");
INSERT INTO nclNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesús quinnanquilic: —Yes lacapunali mochi pacholi hual amo quitocac noTajtzin hual unca pin cielo. In fariseos ca inminlamaxtilisli cate quinami pacholimes hual amo quintocac noTajtzin. ");
INSERT INTO nclNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Xiquincahuacan. Yehuanten cate quinami pachacames hual quinlaicanalo oc sequin pachacames. Huan sinda se pachacal quilaicana oc se pachacal, in omenten huetzisi pin coyunquil. ");
INSERT INTO nclNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Cuaquinon Pedro quilic: —Xitechili tehuanten len quinequi quijtúa in lamaxtilisli hual unca pin lapuhualisli. ");
INSERT INTO nclNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Huan Jesús quinmilic: —¿Amhuanten noje ayamo anquipía lajmatilisli pa anquimatis len quinequi quijtúa nolapuhualisli? ");
INSERT INTO nclNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Ayamo anquimati pampa len yes hual quilalía se pa icamac pa quicuas panúa pa iyolo huan cuaquín quisa quiman yas pa sacatilan? ");
INSERT INTO nclNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ma yoje, innojen hual quisalo pa se icamac, niquijtúa, in lajtomes hual quijtúa se, innojen quisalo pa iyolo. Huan unca pampa inon hual quijtúa se lacal hual Dios quita amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Unca pampa pa se iyolo quisalo lajtulisli amo cuajcuali. In lajtulisli quichías pa se canas isihua oc se. Quichías pa se quinmanas sihuames amo pa monamictis. Quichías pa laixtequis. Quichías pa quijtus len amo unca melahuac inahuac oc se quiman quilajlanilo. Quichías pa quinlatilis in hual unca melahuac pa camo quimatisi yehuanten hual lalajlanilo. Quinchías pa quinhuejuecaltis Dios huan lacames. ");
INSERT INTO nclNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Innojen cate hual Dios amo quitas cuali ca se lacal hual quinchía. Quijlacusi sinda quichía innojen se lacal. Dios amo yahui quijtúa pampa se lacal amo unca cuali sinda amo mopaquilis imajmajuan yoje quinami quijtúa anmolajtol. Amo moijlacus sinda amo quichía inon. ");
INSERT INTO nclNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Cuaquinon mohuicaya Jesús, uyac pa in lali itenco in caltilan hué motocaya Tiro huan in caltilan hué Sidón. ");
INSERT INTO nclNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Huan cataya se sihual cananita quistihualac umpa, pehuac quitzajtzilic, quilic: —¡Tata, tehual tiꞌimiahuil David, xinechicnili! Noxolol sihual niman mococúa pampa se ijyecal amo cuali quichihualtitica. ");
INSERT INTO nclNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesús amo quinanquilic ca se lajtol. Huan hualaje imonextilinijmes, quitemachije Jesús, quilije: —Xicchihuili len mitztemachijtica huan xiquili ma mohuica, pampa techtocatihuala. ");
INSERT INTO nclNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Huan yihual quinanquilic: —NoTajtzin Dios jan nechtilanic san pa niquinlaquetzilis ilajtol yehuanten hual cate judíos hual amo quipialo nolajtol. Pampín moxiluje pa camo mocahuasi pan iojli Dios. ");
INSERT INTO nclNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Cuaquinon hualac in sihual ca yihual huan quimolancuacuetzilic, quilic: —¡Tata, xinechpalehui! ");
INSERT INTO nclNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesús quinanquilic: —Nihualaya pan lalticpan pa niquinpalehuis yehuanten pa Israel san, huan amo yesquiaya cuali sinda nicpalehuisquiaya se hual amo unca judío. Inon yesquiaya quinami nel niquinmanilisquiaya in xolomes in hual yalo quicualo huan niquinmacasquiaya in pelotzitzindis pa quicualosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Cuaquín in sihual quilic: —Tiquijtúa neli, Tata. Ma yoje quincualo in pelotzitzindis in lajquitos tipichitos hual huetzilo capa lacuajticate inmintecojuan, huan sinda unca yoje ca in pelotzitzindis, ¿amo huil tinechpalehuis jan nadita san? ");
INSERT INTO nclNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Cuaquín Jesús quinanquilic: —¡Ah, tuincito, ticmati tilaneltoca niman míac! Jan quinami tichtemachic ma caya ca tehual. Huan ixolol in sihual pajtic jan ajnaxcan. ");
INSERT INTO nclNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Mohuicac Jesús, quisac pa umpa, panujtíac pa itenco in al huejcalan Galilea, cuaquín panquisac pan se loma (tepetzindi), nepa molaliaya. ");
INSERT INTO nclNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Huan hualaje capa yihual niman míac lacalera, quinhuicatataloaya ca yehuanten lacames hual quinlacoculoaya inmicxihuajmes huan amo huil nejnemiloaya, lacames laculululi hual amo huil nejnemiloaya, huan pachacames huan yehuanten hual amo huil lajtuloaya huan míac oc sequin hual mococuloaya. Quinhualicaloaya, quinlalije ilaixpan Jesús, huan yihual quinpajtic. ");
INSERT INTO nclNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Yoje moitaloaya ca lamajtilisli in míac lacalera, pampa quinmitaloaya lajtuticate yehuanten hual amo huil lajtuloaya quiman ajsije. Quinmitaloaya yehuanten hual ajsije laculululi huan axan mohuicaloaya ca inminmajmajuan huan inmicxihuajmes jan cuali san. Quinmitaloaya nejnenticate yehuanten hual ajsije quinlacocujtataloaya inmicxihuajmes. Quinmitaloaya axan lachixticate yehuanten hual ajsije pachacal. Pampín moililoaya yehuanten quinami unca hué iDios Israel huan moililoaya pampa quipiaya in lahueliltilisli hué. ");
INSERT INTO nclNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Cuaquinon quinnotzac imonextilinijmes pa hualasi ca yihual, quinmilic inminhuían: —Nechcocúa noyolo míac pampa in lacalera axan cate ca nehual ye tonalijmes huan amo quipialo len quicuasi. Huan amo nicnequi niquintilanía pa mohuicasi ca mayandi, amo san gá huetzisi pan ojli. ");
INSERT INTO nclNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Quilije imonextilinijmes: —Huan ¿capa tiquinmanasi yoje míac pa quicuasi pa yoje tiquinpachihuiltisi se lanechiculisli hué quinami inon? ");
INSERT INTO nclNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús quinlajlanic: —¿Quichi innojen panes chicuenta tzopimes anquipía pa quicuasi? Quilijque: —Chicome. Huan ticpialo nadita michimes. ");
INSERT INTO nclNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Cuaquín Jesús quinmilic in lacalera pa molalisi pan lali. ");
INSERT INTO nclNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Quinmanac in chicome panes chicuenta tzopimes huan in michimes, quisehuic Dios huan quinlapanac, quinmacac imonextilinijmes, huan imonextilinijmes quinhuiquilije in lacalera. ");
INSERT INTO nclNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Yojque quicuaje moxtin huan pachihuije. Huan imonextilinijmes quintemiltije chicome (siete) chiquihuimes huejué ca in lajlajco hual amo quincuaje. ");
INSERT INTO nclNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Huan yehuanten hual lacuaje cataloaya nahui mil lacames huan ma yoje amo quinpuhuaje in sihuames ca inminxolotzitzindis hual noje lacuaje. ");
INSERT INTO nclNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Cuaquinon Jesús quinmilic yehuanten pa mohuicasi. Huan umpa canac se barquito huan yihual huan imonextilinijmes quipanahuije in al huejcalan, ajsije pa in lali capa cataya in caltilan motocaya Magadán. ");
INSERT INTO nclNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Hualaje capa yihual yehuanten hual quitocaje inminlamaxtilisli in fariseos huan inminlamaxtilisli in saduceos. Quitemujtataloaya quinami quichihuililosquiaya Jesús pa quinnextilis quinami yihual quipiaya Dios ilahueliltilisli. Quitemachije pa quinchihuilis se ilanextilisli in lahueliltilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Huan Jesús quinnanquilic: —Quiman tiolactía, anquijtúa: “Mosta lapuhuis, pampa in cielo unca chichiltic quinami in tixuxli.” ");
INSERT INTO nclNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Lanesi, huan anquijtúa: “Axan quiahuis pampa chichiltic unca in cielo, laticumactía.” ¡Lacuajcuamananijmes amhuanten! Anquimati len quinequi quijtúa quinami nesilo in cielos (ilhuicac), huan amo huil anquimati len quinequilo quijtulo innojen hual panujticate nican pan lalticpan quiman nehual niunca nican. Innojen cate ilanextilisli innojen tonalijmes. ");
INSERT INTO nclNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Lacames amo cuajcuali hual amo cate cuajcuali pa inminyolo ca Dios, yehuanten quitemulo se lanextilisli. Ma yoje, quipiasi san ilanextilisli Jonás ilajtuni Dios. Cuaquín quincahuac, uyac. ");
INSERT INTO nclNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Quiman uyaje imonextilinijmes pa yojque itenco (analco) in al huejcalan, quilcahuaje quihuicaje pan. ");
INSERT INTO nclNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Huan quinmilic Jesús: —Xicpiacan ca laitalisli in laxocoyajquil hual quipialo in fariseos huan saduceos. ");
INSERT INTO nclNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Cuaquín molaquetzilije yehuanten, quijtuje: —Unca pampa amo ticualicaje len pa tijcuasi. Pampín techilijtica inon. ");
INSERT INTO nclNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Quiman quimatic Jesús len quijtuloaya, quinmilic: —¿Leca anmolaquetzilijtica amhuanten? ¿Amo anlaneltoca nadita san? ¿Leca anmolaquetzilijtica ca amhuanten pampa amo anquipía pan? ");
INSERT INTO nclNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ayamo anquimati huan ayamo anquijnamiquía in macuili panes calica niquinlacualtic in macuili mil lacames? ¿Quichi chiquihuimes anquintemiltic ca in lajquitos hual quincahuaje? ");
INSERT INTO nclNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Huan ¿amo anquijnamiquía in chicome panes calica niquinlacualtic in nahui mil lacames huan quichi chiquihuimes huejué anquintemiltic ca in lajquitos? ");
INSERT INTO nclNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Quinami amo anquimati pampa amo annimitzlaquetzilic de len tijcuasi? Nicnequiaya niquijtu xicpiacan laitalisli inahuac inminlaxocoyajquil in fariseos huan in saduceos. ");
INSERT INTO nclNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Cuaquinon quimatije len quinequiaya quijtu. Amo quinmilic pa quipialosquiaya laitalisli pa ilaxocuyajquil in pan. Quinmilic pa quipialosquiaya laitalisli pa inminlamaxtilisli amo cuali in fariseos huan in saduceos. ");
INSERT INTO nclNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Quiman ajsic Jesús pa itenco in caltilan Cesarea de Filipo, quinlajlanic imonextilinijmes, quinmilic: —¿Aqui quijtulo lacames pampa nehual ilacal in cielo niunca? ");
INSERT INTO nclNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Huan quilije: —Sequin quijtulo pampa tiJuan Lacuayatequini, oc sequin quijtulo tehual Elías, oc sequin quijtulo pampa tehual tiJeremías o se ca ilajtunijmes Dios hual yultica oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Quinmilic: —Huan amhuanten, ¿aqui anquijtúa pampa nehual niunca? ");
INSERT INTO nclNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Quinanquilic Pedro, quilic: —Tehual tiunca in Cristo ixolol Dios hual yuli. ");
INSERT INTO nclNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Quinanquilic Jesús quilic: —Dios mijchihuilic cuali tehual, Simón ixól Jonás, pampa amo mitzlamachiltije inon lacames hual jan lacatije nacal huan esli. Cataya noTajtzin hual unca pin cielo hual mitzlamachiltic. ");
INSERT INTO nclNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Huan nimitzilía pampa tehual tiPedro hual tiunca quinami se tixcali hué. Huan pan ipampa in tixcali hué, nehual niquinmiactis yehuanten hual nechneltocalo pa yesi nolacames. Huan mas que miquisi, ma yoje in miquilisli amo quiman huil quinsulahua yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Huan nimitzmacas pa yes moyaxca pa tiquinlapulis pa calaquisi capa unca ilahueliltilisli in cielo nican pan lalticpan. Len yes amo ticmacahuiltis pan lalticpan, in amo unca lamacahuiltili pin cielo. Huan len yes ticmacahuiltis pan lalticpan, in unca lamacahuiltili pin cielo. ");
INSERT INTO nclNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Cuaquinon quinmilic chicahuac in monextilinijmes pa camo quilisi amaqui pampa yihual in Cristo. ");
INSERT INTO nclNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Cuaquinon pehuac quinmilic Jesús quinami quipiaya pa yahuis pa Jerusalén pa panus míac lacocoltilisli hual yahuiloaya quichihuililo in abuelojmes huan in tiopistas huejué huan in lamaxtinijmes. Cuaquinon yahuiloaya quimictilo. Huan quiman panuloaya ye tonalijmes, quil, yihual yahuiaya yuli oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Cuaquín Pedro canac, quihuicac ca yihual inahuac, pehuac laꞌajuac, quilic: —Ma camo quimacahuilti inon Dios, Tata. Ma camo quiman mitzpanu inon. ");
INSERT INTO nclNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Huan momalinac Jesús, quilic Pedro: —¡Xiquisa nonác nehual ca yoje, Satanás!, pampa tichcuejsutica. Amo tilajtutica pa moyolo quinami Dios lajtúa. Jan tilajtúa pa moyolo quinami lacames san. ");
INSERT INTO nclNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Cuaquinon Jesús quinmilic imonextilinijmes: —Sinda se quinequi nechtoca pa yes nomonextilini, ma mocahua pa quichías san in hual quinequi quichía. Ma nechtoca nehual, huan ma momacahuilti pa miquis quinami nehual nimiquis. ");
INSERT INTO nclNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yihual polehuis aqui yes quinequi mopilía iyulilisli. Huan aqui yes quipolus iyulilisli pampa unca se nolacal quinami moxtin nolacames, yihual mopilis iyulilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Len quipías se lacal cantica mochi hual unca pin lalticpan sinda yoje quipolus iyulilisli? Huan sinda quipolus iyulilisli, amo huil canas oc sejpa mas que quilaxlahuis míac pa canas. ");
INSERT INTO nclNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nehual ilacal in cielo nihualas ca ilaixpelalisli cualtichin huan ichicahualisli hué noTajtzin, ca ilanahuatinijmes pin cielo nihualas. Cuaquín niclaxlahuis mochi sejse pa mochi quichihualoaya pan lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Neli annimitzilía pampa sequin hual nican moquezticate yulisi pa nechitasi nehual ilacal in cielo nihualajtica ca nolahueliltilisli cualtichin, yoje ninesis quiman nihuelitis. Quema, ayamo miquisi, huan nechitasi yoje nihualajtica. ");
INSERT INTO nclNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Huan quiman panuje seis (chicuase) tonalijmes, Jesús quinhuicac Pedro huan Jacobo huan Juan icni Jacobo, uyaje inminhuían. Panquisaje se loma (tepel) niman cuajtic. ");
INSERT INTO nclNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Huan nepa mopalac inminlaixpan, pehuaya nesi ca oc se lanextilisli. Laixpelaya iixco quinami in tonali, huan inahuas mochíac iztac laixpelatataya. ");
INSERT INTO nclNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Huan ¡xiquita!, moitilije ca yihual Moisés huan Elías laqueztataloaya ca yihual. ");
INSERT INTO nclNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Cuaquinon Pedro quilic Jesús, quil: —Tata, ¡unca cuali pampa ticate nican! Sinda ticnequi, ma tiquinchihuacan ye calitos ca cuahuimes huan isacayo, se pa tehual huan se pa Moisés huan se pa Elías. ");
INSERT INTO nclNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ayamo lamiaya laquetza Pedro huan quitaloaya quinpachujtataya se mextemil laixpelajquil huan quicaquije se lajtol quistataya pin mextemil hual quijtuaya: —In noxolol nolasojli, hual ca yihual nicpía paquilisli. Xijcaquican yihual. ");
INSERT INTO nclNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Quicaquije inon in monextilinijmes, huan huetzije pa inmixco pan lali huan quimacajsiloaya míac. ");
INSERT INTO nclNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Cuaquinon ajsic Jesús, huan quinmatocac, quinmilijtataya: —Ximoquetzacan huan amo xicmacajsican. ");
INSERT INTO nclNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Quinlapuje inmixtololojmes, amo quitaje amaqui, jan Jesús ihuían san. ");
INSERT INTO nclNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Quiman temujtiahuiloaya pan in loma cuajtic, quinmilic Jesús, quil: —Amo xiquilican amaqui hual Dios anmitzitaltic nepa. Quiman niyulis oc sejpa, nehual ilacal in cielo, cuaquín xiquinmilican. ");
INSERT INTO nclNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Cuaquinon imonextilinijmes quilajlanije Jesús, quilije: —¿Leca quijtulo in lamaxtinijmes pampa quipías pa hualas Elías, huan cuaquín hualas in Cristo? ");
INSERT INTO nclNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús quinnanquilic: —Neli hualas Elías quilaicantica huan quimelahuas mochi. ");
INSERT INTO nclNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ma yoje, annimitzilía pampa hualac Elías huan amo quinequije quislacuje. San quichihuilije len quinequije. Huan noje nejchihuilisi yojque nehual ilacal in cielo. Nejchihuilisi pa nipanus lacocoltilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Cuaquinon quimatije imonextilinijmes pampa quinmiliaya Jesús pampa in Elías hual yihual quinlaquetziliaya yec Juan Lacuayatequini. ");
INSERT INTO nclNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Quiman ajsije ca capic cataloaya in míac lacames, ajsic se lacal ca Jesús, quimolancuacuetzilic huan quilic: ");
INSERT INTO nclNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Tata, xichicnilili noxól. Mococúa míac pampa in ijyecal quiquitzquía. Itequi quiquitzquía huan sejpa huan oc sejpa míac huetzic pin tixuxli huan pa al. ");
INSERT INTO nclNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Niquihualiquilic momonextilinijmes huan amo huil quipajtije. ");
INSERT INTO nclNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús lananquilic: —¡Ay, lacames hual amo laneltocalo huan lacuilmatilo! ¿Quiman yajmo nicayas ca amhuanten? ¿Quiman yajmo monequi pa nimopepenialtis pa huil niyultías ca amhuanten? Xichualiquilican nican in xolol. ");
INSERT INTO nclNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Cuaquinon Jesús cajuac huan quitojtocac in ijyecal, quinahuatilic pa quisasquiaya. Yoje quisac huan mocahuac lapajtili in xolol jan axcan. ");
INSERT INTO nclNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Quiman panuc inon, hualaje ca Jesús ihuían imonextilinijmes, quilajlanije: —¿Leca amo huil tijquixtilije tehuanten in ijyecal amo cuali? ");
INSERT INTO nclNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Quinnanquilic: —Cataya pampa amo anquilalía míac laneltocalisli ca Dios. Annimitzilía neli, sinda anquipiaya laneltocalisli nadita quinami unca tipichin se ilatocli mostaza, cuaquín anquiliaya in loma (tepel) hué: “Ximijcuani capa tiunca nepa huan xía ca umpic”, cuaquín mijcuaniaya in loma. Yoje amo unca nindeno hual amo huil anquichía sinda anquilalía anmolaneltocalisli ca Dios. ");
INSERT INTO nclNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ma yoje, ijyecames amo cuajcuali quinami innojen huil quiquixtilía se jan sinda se quitemachía Dios huan mosahua. ");
INSERT INTO nclNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yajtiahuiloaya inminhuían pa in lalticpan Galilea. Huan Jesús quinmilic quinami lacames yahuiloaya quitemacalo yihual ilacal in cielo, yahuiloaya quitemacalo ca lacames hual yahuiloaya quimictilo. ");
INSERT INTO nclNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Huan quiman panuje ye tonalijmes quiman lamije quimictije, quil, yihual yahuiaya yuli oc sejpa. Quicaquije inon, icnotiaje niman míac imonextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ajsije Jesús huan imonextilinijmes pa Capernaum, hualaje yehuanten hual quitemachiloaya ilapixcalisli in tomin pa in tiopan. Hualaje quitaje Pedro, quilajlanije: —¿Amo quilaxlahuía molamaxtini in tomin pa in tiopan? ");
INSERT INTO nclNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro quilic: —Jo quema. Cuaquinon quiman calaquic Pedro calijtic, Jesús pehuac quilaquetzilic, quilic: —¿Quinami tiquijtúa, Simón? ¿Aquinojen quinlajlanilo ilapixcalisli in tomin in huejueyenten pin lalticpan? ¿Inminxolomes o yehuanten hual amo chantilo pa inmincali? ");
INSERT INTO nclNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro quinanquilic: —Yehuanten hual amo chantilo pa inmincali. Huan Jesús quilic: —Cuaquinon, inminxolomes amo quipialo pa laxlahuisi. ");
INSERT INTO nclNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ma yoje, amo ticnequilo tijcualantilo amaqui. Pampín, xía pa in al huejcalan huan xiclasa se laquixtini. In michin hual jan ajnaxcan lejcus, inon xijquixti. Xiclapu icamac huan nepa laijtic tiquitas se tomin hual yes pa quichi monequis pa ilapixcalisli in tomin. Xicuica huan xiquinmaca pa titechlaxlahuilis tehual huan nehual. ");
INSERT INTO nclNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Pa nepa in tonali hualaje imonextilinijmes capa Jesús quilijticate: —¿Aqui cayas in hué pa ilahueliltilisli in cielos hual quinlaicanas moxtin in oc sequin? ");
INSERT INTO nclNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Cuaquín Jesús quinotzac pa hualas se xolol, quilalic lajco capa yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Quinmilic: —Annimitzilía neli, sinda amo anquipala anmoyolo huan anmochía quinami xolomes, amo quiman ancayas capa unca ilahueliltilisli in cielo. ");
INSERT INTO nclNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Aqui yes hual mochía tipichin pa ilaijnamiquilisli quinami in xól, yoje in se yes hué. Huan in oc sequin hual amo mochihualo tijtipichin amo cayasi yoje hué pa ilahueliltilisli in cielos. ");
INSERT INTO nclNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Huan aqui yes quinamiquía ca lasojlalisli se xól quinami in xól huan quinamiquía pampa quimati momajtía pampa nicpía lahueliltilisli, cuaquín yoje nechnamiquía nehual. ");
INSERT INTO nclNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Huan sinda se quilaicanas pa quichías laijlaculisli se xolol hual nechneltoca, cuaquín cataya cuali sinda cataya lapiluli pa iquixlan se melapili hué huan cataya laꞌatoctili lajco pin al huejcalan. ");
INSERT INTO nclNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Cayas míac lacocoltilisli pa yehuanten hual quinlaicana oc sequin pa quichihuasi laijlaculisli! Amo quiman mocahuas pa cayasi lacames quinami yehuanten. Ma yoje, ¡quichi yahui panúa lacocoltilisli in se hual quilaicanas oc se pa quichías laijlaculisli! ");
INSERT INTO nclNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Pampín, sinda mijchihualtía amo cuali momajma o mocxían, ximocotonili, xiclasa pa camo cayas capa tehual. Sinda tipehuaya ticpía in yulilisli hual amo quiman lamis ca jan se momajma san o jan se mocxían san, ma yoje, cuali cataya pa tehual. Sinda Dios mitzlasaya pin coyunquil milintica ca tixuxli hual amo quiman sehuis, inon neli cataya niman amo cuali pa tehual, mas que tiquinpiaya ome momajmajuan huan ome mocxían. ");
INSERT INTO nclNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Huan sinda mijchihualtía laijlaculisli moixtololon, ximoquixtili huan xiclasa pa camo cayas capa tehual. Sinda tipehuaya ticpía in yulilisli hual amo quiman lamis ca jan se moixtololon san, ma yoje, pa tehual inon cataya niman cuali. Cataya niman amo cuali sinda ca ome moixtololojmes Dios mitzlasaya pin coyunquil milintica ca tixuxli hual amo quiman sehuis. ");
INSERT INTO nclNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Ximolachilican cuali pa camo quiman anquiztías se ca in tijtipichin quinami se hual amo monotza, pampa annimitzilía Dios noTajtzin quinlalic míac ilanahuatinijmes pin cielo pa quinmiztialo. Huan yehuanten in lanahuatinijmes mochi tonali quizticate iixco Dios pin cielo pa quimachiltisi mochi in amo cuali hual quinpanus innojen xolomes. ");
INSERT INTO nclNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nehual ilacal in cielo, nihualaya pan lalticpan pa nijquixtis pin polehuilisli aqui yes hual mopoluc. ");
INSERT INTO nclNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Len anquijtúa inahuac inon? Sinda se lacal quinpía cien borregos huan se ca innojen mopolúa, cuaquín ¿amo quincahuas in noventainueve pin latzacuali huan yas quitemus in se hual mopoluc? Quema. ");
INSERT INTO nclNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Huan sinda quipanúa quita in borrego, annimitzilía neli yihual cayas ca míac paquilisli ca in borrego. Amo yoje míac paquilisli quipías ca in noventainueve hual amo mopoluje. ");
INSERT INTO nclNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Yoje anmoTajtzin pin cielo noje amo quinequi pa se ca in tijtipichin quipolus iojli Dios. ");
INSERT INTO nclNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Sinda mijchihuilía len amo cuali mocni, xía ca yihual mohuían huan xicmachilti quinami mijchihuilic amo cuali. Sinda mitzcaqui, yoje ticpatilic iyolo mocni. ");
INSERT INTO nclNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Huan sinda amo quinequi mitzcaqui, xiquinhuica ca tehual oc se o cuajnesi ome oc sequin, pa yoje pan ipampa inminlajtol ome o ye lacames mocahuas neli in hual ticmotexpahuilía. ");
INSERT INTO nclNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Huan sinda amo quinequi quincaqui yehuanten, cuaquín xiquinmili moxtin capa monechiculo moxtin in laneltocanijmes. Huan sinda noje amo quinequi quincaqui in laneltocanijmes, ma ye ca tehual quinami se hual amo quineltoca Dios o quinami se ca yehuanten hual canalo ilapixcalisli in tomin pa in lahueliltilisli romano. ");
INSERT INTO nclNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Annimitzilía neli, len yes amo anquimacahuiltis pa mochihuas pin lalticpan, inon amo unca lamacahuiltili pin cielo. Huan len yes anquimacahuiltis pin lalticpan unca lamacahuiltili pin cielo. ");
INSERT INTO nclNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Oc sejpa, annimitzilía neli pampa sinda ome ca amhuanten pin lalticpan anajsis ca se lajtulisli ca len yes anquinequi anquilajlanis noTajtzin pin cielo, cuaquín yihual anmitzmacas. ");
INSERT INTO nclNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Inon quichías, pampa capa ome o ye cate lanechiculi pampa nechtemacaje ca nehual quilalijticate ca nehual inminlaneltocalisli, cuaquín nepa niunca lajco capa yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Cuaquinon hualac Pedro, quilic: —Tata, sinda nocni nejchihuilía amo cuali sejpa huan oc sejpa, ¿pa quichi innojen lachihualisli amo cuajcuali monequi pa nicpujpuhuas, pa chicome (siete)? Huan sinda nejchihuilis len amo cuali oc sejpa, cuaquín ¿amo nicpujpuhuas? ");
INSERT INTO nclNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Quilic Jesús: —Amo nimitzilía pa chicome. Nimitzilía sinda pa chicome setenta huala, xicpujpuhua. Nicnequi niquijtúa, amo xiquijnamiqui quichi lapujpuhualisli ticpujpuhuac. ");
INSERT INTO nclNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Pampa inon, ilahueliltilisli in cielo unca quinami se lacal hué hual quinequiaya quimati quichi quihuiquililoaya itequipanujquimes. ");
INSERT INTO nclNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Yoje, pehuac quitemuc huan canac se hual quihuiquilic míac millones. ");
INSERT INTO nclNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Huan amo quipíac len calica quilaxlahuiaya. Cuaquinon latilanic iteco pa quinamacasi isihua huan ixolomes huan mochi hual quipiaya. Pan ipampa inon quilaxlahuiaya. ");
INSERT INTO nclNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Cuaquín itequipanujquil huetzic lancuacueztataya, quitemachic: “Xicpía laicnililisli ca nehual, xijchía huan nimitzlaxlahuis mochi.” ");
INSERT INTO nclNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Huan quicnilic iteco in tequipanujquil, quipujpuhuac inon hual quihuiquilijtataya. ");
INSERT INTO nclNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Cuaquín quisac in tequipanujquil huan ca se nadita quitac oc se itequipanujquil iteco hual quihuiquilic in tequipanujquil dos cientos. Cuaquín quiquitzquic, quitolpatzcac, quilic: “¡Xichlaxlahui len tichhuiquilía!” ");
INSERT INTO nclNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Molancuacuetzac inahuac icni tequipanujquil, quitemachic ca mochi iyolo, quilic: “¡Xichicnili, huan nimitzlaxlahuis!” ");
INSERT INTO nclNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ma yoje, amo quinequic in se, san quihuicac quitzacuac pin calijtic pa mocahuasquiaya nepa sinda amo quilaxlahuisquiaya len quihuiquiliaya. ");
INSERT INTO nclNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Cuaquín, quiman quitaje inon, in oc sequin tequipanujquimes icnotiloaya míac, quincocuc inminyolo. Pampín quimachiltije in teco mochi hual panuc. ");
INSERT INTO nclNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Cuaquín latilanic in teco pa hualas in tequipanujquil, quilic: “¡Tequipanujquil elehuis! Nimitzpujpuhuac ca mochi in hual tichhuiquilic pampa tichtemachic ca mochi moyolo. ");
INSERT INTO nclNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Amo monequiaya pa tehual tiquicniliaya mocni tequipanujquil quinami nehual nimitzicnilic?” ");
INSERT INTO nclNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Huan cualanic míac iteco, quitemacac ca in lacames pin calijtic hual quincocoltilo yehuanten hual cate latzacuali. Nepa mocahuasquiaya in tequipanujquil sinda amo lamiaya quilaxlahui mochi hual quihuiquiliaya. ");
INSERT INTO nclNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Huan Jesús lamic quinmilic: —Yoje anmijchihuilis noje noTajtzin pin cielo sinda se amo quipujpuhuas icni ca mochi iyolo. ");
INSERT INTO nclNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Lamic quijtuc Jesús innojen lajtomes, quisac pa Galilea huan mohuicac pa itenco in lalticpan Judea hual unca ca yojque (analco) in atenco hué Jordán. ");
INSERT INTO nclNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Quitocaje míac lacalera huan nepa quinpajtiaya. ");
INSERT INTO nclNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Huan hualaje capa yihual sequin fariseos pa quilalilisi se lajtol calica huil quimotexpahuililoaya, quilije: —¿Quimacahuiltía tolajtol pa moxilus se lacal ca isihua pampa amo quixtoca len yes ca isihua? ");
INSERT INTO nclNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús quinnanquilic: —¿Amo quiman anmomaxtic pa Dios ilajtol lajcuiluli pampa quiman Dios lamic quipehualtic mochi (pa ipehuayan), quijtúa “quinchíac lacal huan sihual”? ");
INSERT INTO nclNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Noje quijtúa: “Pampa inon, quincajcahua se lacal itajtzin huan inantzin huan cayas ca isihua huan in omenten cayasi se san.” ");
INSERT INTO nclNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yoje yajmo cate ome, jan se san. Pampín, in omenten hual Dios quinchíac se san ma camo quinxilucan lacames. ");
INSERT INTO nclNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Cuaquinon quilajlanije: —Cuaquín ¿leca quinmilic Moisés pa quinmacasi se amal pa monextilis pampa cate laxiluli inminsihuahuan? ");
INSERT INTO nclNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús quinmilic: —Cataya pampa amo anquinequi anmonextilía anquichía in hual unca cuali. Pampín Moisés anmitzmacahuiltic pa anmoxilusquiaya ca anmosihuahuan. Ma yoje amo cataya yoje quiman Dios quipehualtic mochi. ");
INSERT INTO nclNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Annimitzilía sinda se lacal moxilúa ca isihua pampa isihua quichíac len yes hual ilahuical amo quixtocac, huan sinda monamictía ca oc se sihual, cuaquín in lacal moijlacúa pampa canac oc se sihual. Ma yoje, sinda isihua uyac moniluc ca oc se lacal, cuaquín in lajtol quimacahuiltía pa moxilus ca yihual. Huan se lacal hual monamictía ca se sihual laxiluli, yoje in lacal cana se sihual hual amo iyaxca. ");
INSERT INTO nclNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Cuaquinon imonextilinijmes quilije: —Sinda unca yoje in hual huil quipanúa se lacal ca isihua, cuaquín cuali unca pa camo monamictis se. ");
INSERT INTO nclNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Quinmilic Jesús: —Amo cate moxtin hual huil quineltocalo in lajtol, jan yehuanten san hual Dios quinpalehuía pa quineltocasi. ");
INSERT INTO nclNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Sequin lacames amo quiman huil quinpialo inminsihuahuan, pampa yoje lacatije. Ca oc sequin, cataloaya lacames hual quinchihuilije yoje. Ca oc sequin, mochihuaje yoje pampa quinequiloaya quitequipanuililo Dios ca ilahueliltilisli in cielo. Aqui yes huil quineltoca in lajtol, ma quineltoca. ");
INSERT INTO nclNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Cuaquinon sequin quihualiquilije xolomes pa quinlalilis imajmajuan inminpan huan quintemachilis Dios. Ma yoje, pehuaje quinmajuaje imonextilinijmes yehuanten hual quinhualicaje in xolomes. ");
INSERT INTO nclNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Cuaquín Jesús quinmilic: —Xiquinmacahuiltican pa hualasi ca nehual in xolomes huan amo xiquintzacuilican, pampa ilahueliltilisli in cielos unca pan ipampa yehuanten hual cate quinami xolomes. ");
INSERT INTO nclNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Huan quinlalilic imajmajuan inminpan, cuaquinon uyac, canac ojli. ");
INSERT INTO nclNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Huan xiquita, hualac se capa yihual cataya, quilic: —Lamaxtini cuali, ¿len cuali nicchías pa nicpías yulilisli hual amo quiman lamis? ");
INSERT INTO nclNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Quilic Jesús: —¿Leca tichtocayaltía cuali? Se san unca in cuali. Yihual unca Dios. Ma yoje, sinda ticnequi ticpía in yulilisli, xiquinneltoca ilajtomes Dios. ");
INSERT INTO nclNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Quilic in se: —¿Calía? Quilic Jesús: —Sequin cate: Amo tilamictis, amo ticanas sihual hual amo moyaxca, amo tilaxtequis. ");
INSERT INTO nclNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Amo tiquilis len islacatilisli inahuac oc se, xicmati ximomajti inminlaixpan motajtzin huan monantzin, huan ticlasojlas yihual hual unca monahuac quinami timolasojla. ");
INSERT INTO nclNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","In lacal yancuic quilic: —Mochi innojen niyulic niquinneltocatica. ¿Len ayamo nicchíac? ");
INSERT INTO nclNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús quilic: —Sinda ticnequis tiyes se hual quimati quichía mochi hual Dios quinequi, cuaquín xía xicnamaca len ticpía huan xiquinmaca yehuanten hual amo quipialo. Yoje ticpías len hual ipati pin cielo. Cuaquín xichtocatihuala. ");
INSERT INTO nclNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Quicaquic in lajtol in lacal yancuic, quicocuc iyolo. Icnotitíac, pampa yec se lacal hual quipiaya míac hual iyaxca. ");
INSERT INTO nclNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Cuaquinon Jesús quinmilic imonextilinijmes: —Annimitzilía neli pampa san ca niman míac chicahualisli huil calaquisi capa unca ilahueliltilisli in cielo yehuanten hual quipialo míac. ");
INSERT INTO nclNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Oc sejpa annimitzilía pampa amo cataya lachihualisli hué pa se camello quipanahuis iixtololon se lajtzomaloni quinami cataya pa calaquis capa Dios huelitía se lacal hual quipía míac hual iyaxca. ");
INSERT INTO nclNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Quicaquije inon imonextilinijmes, moitaloaya ca míac lamajtilisli, quilije: —Sinda unca yoje ca se lacal hual quipía míac, cuaquín ¿aqui huil yes laquixtili pa ipolehuilisli ilaijlaculisli? ");
INSERT INTO nclNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús quinmitaya huan quinmilic: —Quinami quitalo lacames, in amo huil panúa. Ma yoje, ca Dios mochi huil panúa. ");
INSERT INTO nclNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Cuaquinon quinanquilic Pedro, quilic: —Xiquita. Tehuanten tijcajcahuaje mochi huan timitztocaje. ¿Len ticpiasi pampa ticchihuaje inon? ");
INSERT INTO nclNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús quinnanquilic: —Neli annimitzilía inon amhuanten hual annechtocac. Pan in tonali quiman nihuelitis pan lalticpan nehual ilacal in cielo, nimolalis pan noicpali capa nihuelitis, noicpali hué huan cualtichin, huan amhuanten anmolalis pan doce icpalimes cuajcualtichin pa anquinmilis len quipiasi inminmiahuimes in doce lacames hual quipehualtije moxtin yehuanten hual iyaxca in lali Israel. ");
INSERT INTO nclNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Huan moxtin hual quincajcahuaje inminchan, o inmicnían lacames huan sihuames o inmintajtzitzían o inminantzitzían o inminxolomes o inminlalimes, yehuanten quipiasi míac. Quema, Dios quinmacas niman míac moxtin hual quincajcahuaje innojen pampa nechlasojlaloaya míac. Huan amo yoje míac quinlasojlaloaya innojen hual quincajcahuac. Huan innojen hual quincajcahuaje amo quiman huil ajsiloaya cayalo yoje míac quinami in míac hual Dios quinmacas. Huan noje quipiasi in yulilisli hual amo quiman lamis. Quipiasi quinami inminlaxilulisli inon hual iyaxca Dios. ");
INSERT INTO nclNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ma yoje, míac ca yehuanten hual axan monotzalo niman míac yajmo monotzasi míac. Huan míac hual axan amo monotzalo cayasi yehuanten hual monotzasi niman míac. ");
INSERT INTO nclNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Ilahueliltilisli in cielo unca quinami se lacal quipiaya cuajmili huejué. Quisac cualcan pa quinlaquehuasi tequipanujquimes pa tequipanulosquiaya pa iuvatilan. ");
INSERT INTO nclNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mochihuaje ca se lajtulisli pa quichi yahuiaya quinlaxlahui. Cataya je denario tomin pa se tonali. Cuaquín quintilanic pa iuvatilan. ");
INSERT INTO nclNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Uyac pa chicnahui horas pa huajtzinco, quinmitac oc sequin lacames moqueztataloaya pin lajcotiyan, amo quichijtataloaya nindeno. ");
INSERT INTO nclNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Quinmilic yehuanten: “Xiacan amhuanten noje pa nouvatilan, huan len yes cuali annimitzlaxlahuis.” Huan uyaje yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Huan oc sejpa quisac pa lacualispan huan oc sejpa pa ye horas pa tiolac in teco huan yoje quinlaquehuac lacames. ");
INSERT INTO nclNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Huan quinami macuili horas pa tiolac uyac pa in lajcotiyan huan oc sejpa quinmitac lacames moqueztataloaya huan quinmilic: “¿Leca anmoqueztica nican pa mochi in semilhuil anlatzejtica?” ");
INSERT INTO nclNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Quilije: “Unca pampa amaqui techlaquehuac.” Quinmilic: “Xiacan amhuanten noje pa nouvatilan.” ");
INSERT INTO nclNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Pehuac layuajtic, huan quilic iteco in uvatilan ilaicanani itequipanujquimes: “Xiquinnotza pa hualasi in tequipanujquimes huan xiquinlaxlahui inmintomin. Xipehua ca yehuanten hual hualaje pa macuili horas pa tiolac huan xilami ca aquinojen hualaje quiman pehuaya in semilhuil.” ");
INSERT INTO nclNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Hualaje yehuanten hual pehualoaya tequipanulo pa macuili horas pa tiolac, quinmacaje mochi sejse je tomin denario. ");
INSERT INTO nclNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Hualaje yehuanten hual tequipanuloaya de quiman pehuaya in semilhuil quijtuticate pampa yahuiaya quinlaxlahui oc se tomin ca in denario. Ma yoje, yehuanten noje quinmacac mochi sejse itomin denario. ");
INSERT INTO nclNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Huan quiman canaje, cualanije pampa quinlaxlahuic yoje in teco. ");
INSERT INTO nclNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Quijtuloaya: “Innojen hual hualaje niman pa tiolac jan tequipanuje se hora san huan tiquinlaxlahuic se denario quinami tehuanten. Huan xiquita. Tehuanten titequipanuloaya mochi semilhuil quiman tonaya.” ");
INSERT INTO nclNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Huan in teco quinanquilic se hual cataya ca innojen, quilic: “Nito, amo nimijchihuilijtica len hual amo cuali. ¿Amo timochihuaje ca se lajtulisli pa nimitzlaxlahuisquiaya se tomin denario? ");
INSERT INTO nclNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Xicana in hual moyaxca huan ximohuica. Nicnequi niclaxlahui aqui hual hualac pa macuili pa tiolac jan quinami nimitzlaxlahuía tehual. ");
INSERT INTO nclNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Amo unca noyaxca pa nicchías quinami nicnequi ca len unca noyaxca? O ¿amo tiquita cuali pampa nehual nicchijtica len cuali?” ");
INSERT INTO nclNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yoje aquinojen hual huejcahualo hualalo yesi quinami yehuanten hual pehualo huan yehuanten hual pehualo yesi quinami yehuanten hual huejcahualo hualalo, jan quinami yehuanten hual huejué cayasi quinami yehuanten hual tijtipichin. Unca pampa cate míac yehuanten hual cate lanotzali pa tequipanusi, huan cate naditas hual cate lajtultili. ");
INSERT INTO nclNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Quiman canaya Jesús ojli pa Jerusalén, quinnotzac quinhuicac inhuían in doce imonextilinijmes nepa pan ojli huan quinmilic: ");
INSERT INTO nclNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Xiquitacan. Tialo pa Jerusalén huan nehual ilacal in cielo nechtemacasi in tiopistas huejué huan in lamaxtinijmes, nechtilanisi pa nechmictisi. ");
INSERT INTO nclNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nechtemacasi ca yehuanten hual amo judíos, huan nechhuejuecaltisi huan nechpilusi pan se cuahuil. Huan quiman panusi ye tonalijmes niyulis oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Cuaquinon hualac capa yihual inantzin ixolomes Zebedeo, hualac ca ixolomes. In sihual quimolancuacuetzilic quitemachic pa quinchihuilisquiaya len cuali. ");
INSERT INTO nclNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Huan Jesús quilic: —Huan ¿len ticnectica? Quilic yihual: —Quiman tipehuas tihuelitis, xicmacahuilti pa innojen omenten noxolomes molalisi se pa momajma cuali huan se pa momajma amo cuali pa huelitisi ca tehual. ");
INSERT INTO nclNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesús quinanquilic: —Amo anquimati len anquitemachijtica. ¿Huil anmopepenialtía pa anpanus inon hual nehual nicpías pa nipanus? Yes quinami ancunisquiaya len niman chichic pa míac tonalijmes. Huan pa amhuanten anyes nolanahuatinijmes anquipías pa anpanus lacocoltilisli hual cayasi quinami se lacuayatequilisli ca tixuxli. ¿Huil anmopepenialtía pa anpanus inon? Quinanquilije: —Huil timochicahualtilo pa tipanusi inon, timopepenialtisi. ");
INSERT INTO nclNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Quinmilic Jesús: —Neli anpanus lacocoltilisli quinami launilisli chichic huan quinami lacuayatequilisli pa tixuxli. Ma yoje, pa anmolalis pa noma cuali huan pa noma amo cuali, inon amo unca noyaxca pa annimitzmacas. NoTajtzin quichijchíac innojen pa sequin hual yihual quinlajtultic pa quipiasi, huan quinlalis yehuanten nepa. ");
INSERT INTO nclNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Quiman quicaquije inon innojen diez (majlacli) imonextilinijmes, cualanije ca in omenten icnían. ");
INSERT INTO nclNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ma yoje, Jesús quinnotzac moxtin, quinmilic: —Anquimati quinami in huejueyenten hual huelitilo pan yehuanten pa mochi lalimes, huelitilo chicahuac. Huan yehuanten hual huelitilo mojmosta quinequilo quinnextililo in lacames quinami quipialo lahueliltilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Amo cayas yoje ca amhuanten, cayas quinami inon: Aqui yes quinequi mochía hué ca amhuanten, monequi pa yihual quintequipanuilis moxtin oc sequin. ");
INSERT INTO nclNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Huan aqui yes quinequi caya in hué ca amhuanten pa anmitzlaicanas, yihual quipías pa yes in se hual mochías quinami tequipanujquil lailpili pa moxtin. Yihual amo motzacuilis pa quichías in tequipanulisli hual moxtin quixijxiculo pa quichihuasi. ");
INSERT INTO nclNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Quipías pa mochías jan quinami nehual ilacal in cielo. Amo nihualaya pan lalticpan pa nechtequipanuilisi nehual lacames. Nihualaya pa niquintequipanuilis yehuanten huan pa nimotemacas pa nimiquis. Yoje niclaxlahuis pa inminlamacahualisli míac lacames pa camo polehuisi pampa quinchihuaya laijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Quistiahuiloaya yehuanten pin caltilan Jericó, quitocaloaya Jesús míac lacalera. ");
INSERT INTO nclNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Huan xiquitacan, pa itenco in ojli cataloaya yehuatataloaya ome pachacames, quicaquiloaya pampa panuaya Jesús. Pampín tzajtzije, quilije: —¡Tata, tiꞌixól David, xitechicnili! ");
INSERT INTO nclNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Huan in lacalera quinmajuac pa camo nahuatisi. Ma yoje, yehuanten quitzajtzilije chicahuac, quilije: —¡Tata, tiꞌixól David, xitechicnili! ");
INSERT INTO nclNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Pampín, moquetzac Jesús, quinnotzac, quinmilic: —¿Len anquinequi pa annimijchihuilis? ");
INSERT INTO nclNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Quilije: —Tata, xiquinpajti toixtololojmes pa huil tilachiasi. ");
INSERT INTO nclNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Quipíac Jesús laicnililisli pa yehuanten, huan quinmatoquilic inmixtololojmes. Jan ajnaxcan lachiaje huan pehualoaya quitocalo Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ajsitihualaloaya yehuanten pa Jerusalén huan hualaloaya pa Betfagé pa in tepetzindi (loma) itoca Olivos. Cuaquinon quintilanic Jesús ome imonextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Quinmilic: —Xiacan pin caltilan hual anmolaixpan, huan jan ajnaxcan anquitas se burra ilpitica huan ixól ca yihual. Xictomacan huan xichhualiquilican. ");
INSERT INTO nclNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Huan sinda se anmitzilía len, xiquilican: “Monequi pa in Tata quinpías yehuanten huan ca nadita yahui quincuepa.” ");
INSERT INTO nclNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Inon panuc pa mochías len quijtúa ilajtol Dios ilajtuni hual quijcuiluc: ");
INSERT INTO nclNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Xiquilican yehuanten pin caltilan Sión: “Xiquitacan, huala anmoHué capa amhuanten, yihual hual momacahuiltía, yihual lejcutica pan se burra, pani ixolol se burra hual quilamamiltilo.” ");
INSERT INTO nclNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Cuaquinon uyaje imonextilinijmes, quichihuaje quinami Jesús quinmilic. ");
INSERT INTO nclNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Quinhuicaje in burra ca ixolol, huan quilalije inminpan inminlaquemes, huan quilejcultije Jesús huan ipan molalic. ");
INSERT INTO nclNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Huan in lacalera quinsuhuaje inminlaquemes pan in ojli. Oc sequin quincotonaje inminitzmolinquijmes (ramas) cuahuimes, quinxintiaje pan ojli. ");
INSERT INTO nclNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Quilaicanaje huan quitocaje in míac lacalera tzajtzitiahuiloaya huan quijtutiahuiloaya: —¡Ma yuli pa techquixtis pin polehuilisli yihual ixolol David! ¡Ma quilican lajtomes hué inahuac yihual hual hualaya ca ilahueliltilisli Dios! ¡Ma techquixti pin polehuilisli yihual hual hualac, quisac pin niman cuajtic pin cielo! ");
INSERT INTO nclNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yoje calaquic Jesús pin Jerusalén, huan moxtin yehuanten pin caltilan hué molinije huan majcoquije, quilije: —¿Aqui in se? ");
INSERT INTO nclNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Huan in lacalera quinmililoaya: —In se ilajtuni Dios itoca Jesús hual moscaltic pin caltilan Nazaret pin lalticpan Galilea. ");
INSERT INTO nclNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Calaquic Jesús pin tiopan hué huan quinquixtic pa quiahuac moxtin hual lanamactataloaya huan lacujtataloaya pin tiopan hué calijtic. Quintzincuepac innojen capa lacames quipatililoaya in tomin. Noje quintzincuepilic inmicpalimes yehuanten hual quinnamacaloaya huilomes. ");
INSERT INTO nclNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Quinmiliaya: —Unca lajcuiluli pa ilajtol Dios: “Quitocayaltisqui nocali se cali capa quilajlanilo Dios.” Huan amhuanten anquichihuac quinami se cueva (ostul) capa chantilo laxtequinijmes. ");
INSERT INTO nclNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nepa pin tiopan hué hualaloaya capa yihual pachacames huan yehuanten hual amo huil nejnemiloaya, huan yihual quinpajtic. ");
INSERT INTO nclNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Yoje quitaloaya in tiopistas huan in lamaxtinijmes innojen hual quinlachialtiloaya moxtin ca lamajtilisli. Noje quicaquiloaya quinami in xolomes tzajtziloaya calijtic in tiopan hué, quijtutataloaya: “¡Ma yuli pa techquixtis pin polehuilisli ixól in Hué David!” Pampín cualanije in tiopistas huan in lamaxtinijmes. ");
INSERT INTO nclNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Quilije Jesús: —¿Tijcaquía len quijtuticate innojen? Huan Jesús quinmilic: —Jo quema. ¿Amo quiman anmomaxtic in hual unca lajcuiluli pa ilajtol Dios hual quijtúa inon? Yoje quijtúa: Quisalo lajtomes huejué pa tehual pa inmincamac xolomes tipichinchitos huan xolomes hual ayamo mocahuajque pa chichisi. Huan inminlajtomes yehuanten amo quipialo laijlaculisli. O Dios, tiquinhueliltic pa quichihuasqui inon. ");
INSERT INTO nclNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Cuaquinon quincahuac Jesús huan quisac nepa Jerusalén, uyac pa in caltilan Betania, nepa panuc in layúa. ");
INSERT INTO nclNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Huan niman pa huajtzinco, mocuepaya pa Jerusalén huan mayantataya. ");
INSERT INTO nclNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Quitac se amacual tipichin inahuac in ojli huan uyac capa cataya. Huan amo quitac ilaquilyo nindeno ipan, jan quitac isacayo san. Cuaquinon quilic in cuahuil: —Ma yajmo quiman caya laquilyo mopan. Huan jan ajnaxcan huaquic in amacual tipichin nepa capa cataya. ");
INSERT INTO nclNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Quitaje inon imonextilinijmes huan moitaje ca lamajtilisli, quilije: —¿Quinami huaquic jan axcan in amacual tipichin nican capa cataya? ");
INSERT INTO nclNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Quinnanquilic Jesús, quinmilic: —Neli annimitzilía, sinda anquineltoca huan sinda amo anquimahuilía pa anmoyolo cuajnesi amo panus in hual anquitemachis pa Dios anmitzmacas, cuaquín anquichihuís in amacual tipichin inon jan quinami nel nicchihuíc. Huan amo in san. Noje huil anquilis in loma: “Ximoejua, ximolasa pa al huejcalan”, huan yoje quipanus. ");
INSERT INTO nclNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Huan mochi hual anquitemachis Dios anquipías sinda anquitemachía anquineltocatica pampa yihual anmitzmacas. ");
INSERT INTO nclNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Cuaquinon calaquic Jesús pin tiopan hué, hualaje capa yihual quiman lamaxtitataya in tiopistas huejué huan inminabuelojmes hueyenten in judíos, quilije: —¿Ca aqui ilahueliltilisli tiquinchijtica innojen? Huan ¿aqui mitzmacac in lahueliltilisli? ");
INSERT INTO nclNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús quinnanquilic: —Annimitzlajlanis nehual noje se lajtol, huan sinda annechnanquilis, cuaquín nehual noje annimitzilía ca aqui ilahueliltilisli niquinchijtica innojen. ");
INSERT INTO nclNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Aqui quitilanic Juan Lacuayatequini pa yihual lacuayatequisquiaya? ¿Quitilanic Dios, o quitilanije lacames? Cuaquinon molaquetzilije yehuanten, moilijtataloaya: —Sinda tiquijtulo cataya Dios, cuaquín techilis: “Cuaquín ¿leca amo anquineltocac?” ");
INSERT INTO nclNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Huan sinda tiquijtusi cataloaya lacames, timomajtía inminlaixpan in míac lacames, pampa moxtin quineltocalo pampa Juan yec se ilajtuni Dios. ");
INSERT INTO nclNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yoje quinanquilije Jesús: —Amo ticmatilo. Huan Jesús quinmilic: —Huan nehual noje amo annimitzilis ca aqui ilahueliltilisli niquinchijtica innojen. ");
INSERT INTO nclNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Huan quinmilic: —¿Quinami anquita inon? Quimpiaya se lacal ome ixolomes huan quilic se: “Noxól, xía xitequipanu axan pin uvatilan.” ");
INSERT INTO nclNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Huan ixól quinanquilic: “Amo nicnequi.” Ma yoje, ca nadita mopatilic iyolo, uyac tequipanuc. ");
INSERT INTO nclNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Cuaquín uyac quitac in oc se ixól huan quilic pa yas tequipanus, huan yihual quinanquilic: “Jo quema, Tata, nías.” Ma yoje, amo uyac. ");
INSERT INTO nclNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Calía ca in omenten quichihuaya quinami quinequiaya itajtzin? Quilije: —In xól hual quipatilic iyolo huan uyac tequipanuc. Cuaquinon Jesús quinmilic: —Annimitzilía neli pampa yehuanten hual canalo ilapixcalisli tomin pa in lahueliltilisli romano, huan in sihuames amo cuajcuali calaquisi capa Dios huelitía huan amhuanten amo. ");
INSERT INTO nclNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yoje cayas, pampa hualac Juan pa anmitznextilisquiaya amhuanten quinami ancanas se ojli melahuac huan cuali. Huan amhuanten amo anquineltocac. Ma yoje, quineltocaje yehuanten hual canalo ilapixcalisli tomin huan in sihuames amo cuajcuali. Huan amhuanten, mas que anquitac in, ma yoje amo anmopatilic anmoyolo pa anquineltocasquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Xijcaquican oc se lapuhualisli hual annimitzmaxtis. Cataya se lacal hué hual quipiaya míac, quitocac se uvatilan. Quitzacuac itenco, quihuajuanac coyunquil pin tel capa quitelicsalo in uvas, huan quichíac se caltzindi cuajtic capa huil quitalo sinda calaquilo yulijquimes putzames. Cuaquín quilaquehualtilic sequin tequipanujquimes lachianijmes huan uyac pa oc se lali. ");
INSERT INTO nclNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ajsic in tonalijmes quiman yucsiaya in laquilyo. Quintilanic sequin itequipanujquimes pa canalosquiaya in hual iyaxca in laquilyo. ");
INSERT INTO nclNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Cuaquín in tequipanujquimes lachianijmes quinquitzquije itequipanujquimes in teco, huan se quihuitequije, oc se quimictije huan oc se quilaxilije tixcalimes. ");
INSERT INTO nclNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Oc sejpa quintilanic in teco oc sequin míac itequipanujquimes, amo ajsiloaya cayalo yoje míac yehuanten hual yihual pehuac quintilanic. Ma yoje, quinchihuilije in tequipanujquimes jan yoje quinami ca yehuanten hual pehuac quintilanic. ");
INSERT INTO nclNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Cuaquín quintilanilic ixól, ca yihual laquisac, quijtuc: “Quimatisi momajtisi ilaixpan noxól.” ");
INSERT INTO nclNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ma yoje, quiman quitaje ixól in tequipanujquimes lachianijmes, moilije: “In se unca hual canas in hual iyaxca in teco. Ma tián, ma ticmictican. Yoje cayas toyaxca in uvatilan.” ");
INSERT INTO nclNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Yoje quihuicaje, quilasaje pa quiahuac in uvatilan, quimictije. ");
INSERT INTO nclNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Cuaquinon Jesús quinlajlanic: —Quiman hualas iteco in uvatilan, ¿len quinchihuilis innojen tequipanujquimes lachianijmes? ");
INSERT INTO nclNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Quilije: —Quinmictis in lacames ejꞌelehuis yoje tetzcuinuc huan quintemacas in uvatilan oc sequin tequipanujquimes lachianijmes hual quitemacasi in laquilyo pa in tonalijmes quiman yucsis. ");
INSERT INTO nclNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesús quinmilic: —Huan ¿amo quiman anmomaxtic pa Dios ilajtol lajcuiluli? Quijtúa: In tel hual quijtuje amo monotza nindeno yehuanten hual quichijtataloaya in cali, axan mochíac pa in cali itel niman cuali, in tel capa quipehualtijque mochi in cali. Panuc yoje pampa toTeco quichíac, huan quiman tiquitajque, timoitajque ca lamajtilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Pampín, annimitzilía pampa anmitzquixtilis Dios ilahueliltilisli amhuanten huan quintemacas yehuanten hual yulisi quichijticate quinami Dios quinequi. ");
INSERT INTO nclNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Aqui huetzis ipan in tel quilajlapanas yihual. Huan sinda in tel huetzis ipan aqui yes, yoje quitesis huan yihual mochías lalpotocli. Nehual niquinami in tel. Ca inon niquijtúa pampa sinda se quinequi quijlacúa nolahueliltilisli, in se polehuis. ");
INSERT INTO nclNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Quicaquije in tiopistas huejué huan in fariseos innojen lapuhualisli hual quinmilic Jesús. Quimatiloaya pampa Jesús quinmiliaya pampa yehuanten cataloaya quinami innojen lacames ejꞌelehuis pa innojen lapuhualisli. ");
INSERT INTO nclNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Pampín quitemuje quinami quiquitzquilosquiaya. Ma yoje, momajtiloaya quiquitzquilo pampa in míac lacalera nepa cataloaya. yehuanten quineltocaloaya pampa Jesús yec se ilajtuni Dios, huan pampín amo quinmacahuiltilosquiaya pa quiquitzquilosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Huan Jesús pehuac quinlaquetzilic oc sejpa, quinlaquetzilic ca lapuhualisli calica quinmaxtiaya, quinmilic: ");
INSERT INTO nclNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Ilahueliltilisli in cielo unca quinami se hué hual quichíac se lacualisli pampa ixól monamictiaya. ");
INSERT INTO nclNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Huan quintilanic itequipanujquimes pa quinnotzalosquiaya pa hualasi yehuanten hual quinnotzac pan lacualisli. Huan amo quinequiloaya. ");
INSERT INTO nclNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Oc sejpa quintilanic oc sequin tequipanujquimes, quinmilic: “Xiquinmilican yehuanten yoje: Axan nicpía lachijchihuali mochi pa anquicuas. Nilatilanic pa quinmictisi notoros huan noborregos tojtomahuac. Mochi unca lachijchihuali. Xihualacan pa in lacualisli.” ");
INSERT INTO nclNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ma yoje, yehuanten hual quinnotzac amo quinequiloaya quincaquilo huan uyaje se pa icuajmili, oc se pa ilanamacaloyan pa lanamaquiltis. ");
INSERT INTO nclNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Huan in oc sequin quinquitzquije itequipanujquimes in hué, quinchihuilije amo cuali huan noje quinmictije. ");
INSERT INTO nclNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Cuaquín cualanic míac in hué huan quintilanic iguaches hual quinmictije innojen lamictinijmes huan quichichinuje inmincaltilan yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Cuaquinon quinmilic itequipanujquimes: “In lacualisli unca lachijchihuali. Ma yoje, yehuanten hual niquinnotzac pa hualasi amo monotzaloaya. ");
INSERT INTO nclNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Xiacan pa in lajcotiyan capa quisalo in ojlimes huan xiquinnotzacan moxtin hual anquinmitas pa hualasi pan lacualisli.” ");
INSERT INTO nclNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Quisaje in tequipanujquimes pan ojlimes, quinechicuje moxtin hual quinmitaje, yehuanten hual amo cuajcuali huan hual cuajcuali. Yoje tentataya in cali ca yehuanten hual quinnotzaje pa hualasi. ");
INSERT INTO nclNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Cuaquinon calaquic in hué, quinmitac moxtin yehuanten huan nepa quitac se hual amo molaquentic ca inahuas in monamictilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Quilic: “Nito, ¿quinami ticalaquic nican huan amo ticpiaya in nahuas pa in monamictilisli?” Huan amo huil quinanquiliaya. ");
INSERT INTO nclNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Cuaquín in hué quinmilic itequipanujquimes: “Xiquilpilican imajmajuan huan icxihuajmes, xiclasacan pa quiahuac capa laticumac. Nepa moxtin chocasi chicahuac huan quincuajcuasi inminlames.” ");
INSERT INTO nclNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Pampa míac cate lanotzali huan jan naditas san cate lalajtultili pa cayasi Dios ilacames. ");
INSERT INTO nclNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Cuaquinon uyaje in fariseos huan molaquetzilije pa quimatilosquiaya quinami huil quicuajcuamanalosquiaya Jesús pa quijtusquiaya len lajtol calica huil quimotexpahuililosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Yoje quintilanije sequin hual quintocaloaya yehuanten huan sequin hual cataloaya ca in herodistas, quilije: —Lamaxtini, ticmatilo pampa tehual tiquijtúa len unca melahuac huan ticmaxtía iojli Dios ca melahualisli. Ticmatilo pampa amo tictemúa quinami ticpaquiltis amaqui ca len tiquilía, huan inon unca pampa tiquita se lacal jan quinami tiquita oc se. ");
INSERT INTO nclNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Axcan, xitechili quinami tiquita inon. ¿Unca cuali ilaixpan Dios pa ticlaxlahuisi ilapixcalisli in tomin pa in hué romano César? ");
INSERT INTO nclNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Quimatic Jesús quinami yehuanten quinequiloaya quimotexpahuililo huan quinmilic: —Amhuanten lacuajcuamananijmes, anquinequi annesi quinami lacames cuajcuali, huan ma yoje nicmati pampa anquijtutica amo cuali laijtic amhuanten. ¿Leca annechlalilía in calica anquinequi annechmotexpahuilía? ");
INSERT INTO nclNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Xichnextili in tomin pa lapixcalisli. Quihualiquilije in tomin. ");
INSERT INTO nclNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesús quitaya huan quinmilic: —¿Aqui iyaxca in layapali huan in lajcuilulisli? ");
INSERT INTO nclNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Quinanquilije: —Iyaxca César in hué. Cuaquinon quinmilic: —Xicmacacan César in hual iyaxca, huan xicmacacan Dios in hual iyaxca yihual. ");
INSERT INTO nclNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Quicaquije inon, mocahuaje moiztataloaya ca lamajtilisli. Cuaquinon quicahuaje huan uyaje. ");
INSERT INTO nclNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Cataya in tonali hualaje capa Jesús sequin saduceos. yehuanten quijtulo pampa amo yulilo oc sejpa yehuanten hual miquije. Pampa inon, quilajlanije: ");
INSERT INTO nclNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Lamaxtini, quijtuc Moisés sinda miqui se huan amo quinpiaya xolomes, cuaquín monequi pa monamictis icni ca isihua ihuían icni pa yoje quinpiasi xolomes hual quihuicasi itoca in se hual miquic. ");
INSERT INTO nclNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Axcan, cataloaya siete (chicome) icnían hual yuliloaya capa tehuanten. Monamictic inmicni hué huan miquic amo quinpixtataya xolomes. Pampín icni canac isihua ihuían icni. ");
INSERT INTO nclNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Quimpanuc yehuanten jan quinami ca in se, amo quinpiaje xolomes. Huan noje quinpanuc ca in oc sequin icnían, ca moxtin in chicome, huan amo quinpiaje xolomes. ");
INSERT INTO nclNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Huan quiman lamije miquije moxtin in chicome, cuaquín miquic noje in sihual. ");
INSERT INTO nclNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Axcan, quiman yulisi oc sejpa, ¿aqui ca in chicome icnían yes ilahuical in sihual? Pampa moxtin canaje. ");
INSERT INTO nclNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús quinnanquilic: —Anmoixpolúa pampa amo anquimati ilajtol Dios hual unca lajcuiluli, huan amo anquimati ilahueliltilisli Dios. ");
INSERT INTO nclNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Quiman yulisi oc sejpa yehuanten hual miquije, amo monamictilo huan amo temacasi pa monamictisi. ");
INSERT INTO nclNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Cayasi quinami Dios ilanahuatinijmes hual cate pin cielo. ");
INSERT INTO nclNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Huan inon hual quinmatoca yehuanten hual miquije, neli unca pampa yulisi oc sejpa. ¿Amo quiman anmomaxtic len yihual Dios anmitzilic? Yoje quijtuc: “Nehual niunca iDios Abrahám huan iDios Isaac huan iDios Jacob.” Dios amo inminDios in mijquimes. Yihual inminDios yehuanten hual yulticate. Pampín yulticate mas que miquije. ");
INSERT INTO nclNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Quicaquije inon in míac lacames, huan molapolultije ca Jesús ilamaxtilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Quimatije in fariseos quinami Jesús quinsulahuac in saduceos pa yajmo huil monapatisi ca inminlajtomes. Pampín monechicuje capa yihual. ");
INSERT INTO nclNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Huan se ca yehuanten hual yec ilamaxtini in lajtol quilajlanic len pa quimatis sinda neli quinanquilisquiaya quinami quijtúa Dios ilajtol, quilic: ");
INSERT INTO nclNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Lamaxtini, ¿calía unca ilajtol Dios niman hué? ");
INSERT INTO nclNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús quilic: —“Ticlasojlas in Tata moDios ca mochi moyolo huan ca mochi moyulilisli huan ca mochi molaijnamiquilisli.” ");
INSERT INTO nclNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","In unca in lajtol niman hué huan quipehualtía mochi Dios ilajtomes. ");
INSERT INTO nclNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","In oc se unca quinami in calica quipehualtic: “Ticlasojlas mochi oc se hual unca monahuac quinami timolasojla tehual.” ");
INSERT INTO nclNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Aqui hual quichía in ome lajtomes, noje quichijtica mochi hual quijtulo Dios ilajtomes huan Dios ilajtunijmes. ");
INSERT INTO nclNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","In fariseos ayamo mohuicaje. ");
INSERT INTO nclNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Cuaquín Jesús quinlajlanic: —¿Quinami anquita inon hual quijtúa quinami unca in Cristo? ¿Aqui ixól yihual? Yehuanten quilije: —Yihual ixól David. ");
INSERT INTO nclNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Cuaquinon quinmilic Jesús: —Cuaquinon, ¿quinami unca yoje sinda David quitocayaltic Tata quiman quijcuiluc pan ipampa in Espíritu Santo innojen lajtomes? Quijtúa: ");
INSERT INTO nclNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","In Tata quilic noTata: “Ximolali inahuac noma cuali, huan niquinsulahuas molacocolinijmes huan yesi quinami se icpali pa itzindan mocxihuajmes.” ");
INSERT INTO nclNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Axan, sinda David quitocayaltic “noTata”, cuaquín ¿quinami huil yes ixolol David? ");
INSERT INTO nclNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Huan amaqui huil quinanquilic se lajtol. Huan pa in tonali huan pa mochi tonalijmes hual ajsitiahuiloaya, momajtiloaya moxtin pa quilajlanilosquiaya len. ");
INSERT INTO nclNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Cuaquinon quinlaquetzilic Jesús in lacalera huan imonextilinijmes, quinmilic: ");
INSERT INTO nclNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Huelitilo in lamaxtinijmes huan in fariseos ca Moisés ilahueliltilisli huan ca in hual iyaxca Moisés. ");
INSERT INTO nclNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Pampín, mochi hual anmitzililo, in xicchihuacan huan xiquinneltocacan. Ma yoje, amo xilachihuacan quinami yehuanten lachihualo, pampa quijtulo len quipía pa quichías se, mas que yehuanten amo quichihualo. ");
INSERT INTO nclNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Huelitilo quinami quinmilpilijticate lamamanijquimes ejꞌetic huan unca quinami quinlamamiltilo pani inminhuajcomes lacames. Huan yehuanten amo quinequilo quinmijcuanilía nadita in lamamanijquimes ejꞌetic, amo quinmatocalosquiaya ca se ixerixa yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Huan mochi in hual quichihualo, san quichihualo pa quinmitasi cuali lacames. Yoje quinchihualo palahuac in latzacualinijmes tijtipichin hual quipixticate laijtic ilajcuilulisli Dios ilajtol, huan quinpilulo pa pani inminlaixpan huan pa inminmajmajuan. Huan quihuejcanaltilo niman xilanquil inminicpalmes inminahuas calica molaquentilo, amo cate yoje xilanquil innojen hual in oc sequin quipialo. ");
INSERT INTO nclNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Huan quixtocalo molalilo capa lacualo pin fiestas pani in icpalimes hual cate pa in huejueyenten. Huan quixtocalo in icpalimes pa in huejueyenten pin tiopajmes. ");
INSERT INTO nclNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Quixtocalo pa moxtin quinpialtisi ca míac lamajtilisli quinnozticate “Rabí” pan ojlimes huan pin lajcotiyan hué lajco pin caltilan. ");
INSERT INTO nclNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Axan, amhuanten, amo xiquinmacahuiltican pa lacames anmitznotzasi Rabí Lamaxtini, pampa anquipía se anmolamaxtini hual nehual niunca, Cristo. Huan amhuanten anmoxtin anunca anmocnían se ca oc se. ");
INSERT INTO nclNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Huan amo xicnotzacan amaqui pan lalticpan anmotajtzin, pampa se san unca anmoTajtzin, yihual pin cielo. ");
INSERT INTO nclNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Huan monequi pa camo anquimacahuiltis pa amaqui anmitznotzas “noteco”, pampa se san unca anmoteco, yihual Cristo. ");
INSERT INTO nclNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yihual hual quitequipanuilía in oc sequin yes in hué capa amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Pampín, aqui yes quijtúa pa iyolo pampa yihual hué, yihual yes lachihuali tipichin. Huan aqui yes quijtúa pa iyolo pampa unca tipichin yes lachihuali hué. ");
INSERT INTO nclNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Quichi anpanus lacocoltilisli amhuanten ilamaxtinijmes in lajtol huan fariseos hual anyuli anquincuajcuamantica lacames! Anquichihuilía pa quijtusi pa inminyolo pampa amhuanten anunca lacames niman cuali, huan neli anunca lacuajcuamananijmes. Unca pampa anquitzacuilía lacames hual canticate in ojli capa quitasi ilahueliltilisli in cielo. Amhuanten amo anquinequi ancana in ojli huan amo anquinmacahuiltía pa canasi yehuanten hual quinequilo canalo. ");
INSERT INTO nclNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Quichi anpanus lacocoltilisli amhuanten, ilamaxtinijmes in lajtol huan fariseos, amhuanten lacuajcuamananijmes! Unca pampa anquinquixtilía in calimes in sihuames hual inminlahuicalhuan polehuije. Cuaquín anquichía oración ca míac lajtomes pa anquinmonextilis lacames pampa anunca niman cuali, huan ma yoje anunca lacuajcuamananijmes. Pampín, Dios anmitzmacas lacocoltilisli niman chicahuac hual amo yoje quinmacas oc sequin. ");
INSERT INTO nclNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Quichi anpanus lacocoltilisli amhuanten, ilamaxtinijmes in lajtol huan fariseos, lacuajcuamananijmes! Unca pampa anquipanahuía in al huejcalan huan anyahui pa míac lalimes pa anquitemus se pa anquineltocaltis anmolamaxtilisli. Huan quiman anquitas se hual quinequi, cuaquín anquijlacúa ca anmolamaxtilisli. Huan yoje anquichía pa monequis pa panus in lacocoltilisli hual ome ca amhuanten anpanus. ");
INSERT INTO nclNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Quichi anpanus lacocoltilisli amhuanten, telaicana nijmes pachacames! Amhuanten anquijtúa: “Aqui yes quilis ilaixpan Dios len yahui quichía, huan quijtúa ca lajtol hual amo mopala pan ipampa in tiopan hué, cuaquín amo quipía pa quichías in hual quilic. Ma yoje, aqui yes quilis ilaixpan Dios ca lajtol hual amo mopala pampa yahui quichía len, huan quilía pan ipampa in oro calijtic in tiopan hué, cuaquín yihual quipías pa quichías.” ");
INSERT INTO nclNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Amo anquimati anlaijnamiquía, anunca pachacames, amhuanten! ¿Calía ca innojen monotza ca Dios? ¿Unca in oro, o unca in tiopan hué capa Dios mochihuilía lachipahuali in oro pa huil quitas quinami iyaxca? ¡Anquimati unca in tiopan hué hual monotza ca Dios! ");
INSERT INTO nclNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Huan noje amhuanten anquijtúa: “Aqui yes quijtúa ilaixpan Dios pampa yahui quichía len, huan ca lajtol hual amo mopala quijtúa pan ipampa inon capa quilalilo in huendi, cuaquín amo quipías pa quichías. Ma yoje, sinda se quijtúa ilaixpan Dios ca lajtol hual amo mopala pampa yahui quichía len, huan quilía pan ipampa in huendi pa pani capa quilalilo, cuaquín yihual quipía pa quichías.” ");
INSERT INTO nclNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Amo anquimati anlaijnamiquía, anunca pachacames, amhuanten! ¿Calía ca innojen monotza ca Dios? ¿Unca in huendi, o unca inon capa quilalilo capa Dios mochihuilía lachipahuali in huendi pa huil quitas quinami iyaxca? ¡Anquimati unca in capa quilalilo hual monotza ca Dios! ");
INSERT INTO nclNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yoje, aqui yes quijtus len ilaixpan Dios ca lajtol hual amo mopala, huan quijtúa pan ipampa inon capa quilalilo in huendi, cuaquín amo jan quijtutica pan ipampa inon capa quilalilo in huendi san. Quijtutica pan ipampa capa quilalilo huan pa mochi huendi hual unca pa pani inon. ");
INSERT INTO nclNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Huan aqui yes quijtúa len ilaixpan Dios ca lajtol hual amo mopala, huan quijtúa pan ipampa in tiopan hué, yihual amo quijtutica jan pan ipampa in tiopan hué san. Noje quijtutica pan ipampa Dios hual yuli calijtic in tiopan hué. ");
INSERT INTO nclNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Noje aqui yes quijtúa len ca lajtol hual amo mopala pan ipampa in cielo, yoje yihual quijtutica pan ipampa in icpali cualtichin capa Dios huelitía huan jan yoje quijtutica pan ipampa Dios hual molalía ipan. ");
INSERT INTO nclNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Quichi anpanus lacocoltilisli amhuanten, ilamaxtinijmes in lajtol huan fariseos, amhuanten lacuajcuamananijmes! Amhuanten anquimaca Dios se ca mochi diez inminlajlajco menta huan eneldo huan cominos hual anquipixca, huan amo anquinequi anquinmijnamiquía in lajtomes hual niman monotzalo ca Dios. Cate innojen lajtomes hual anmitznextililo quinami monequi pa anyuli anquichijtica len hual Dios quita cuali pa moxtin. Huan cate innojen lajtomes hual anmitznextililo quinami monequi pa anquimatis anlaicnilía huan quinami monequi pa anquimatis anquilalía anmolaneltocalisli ca Dios. Cate innojen hual monequi pa anquimatis anquichías. Huan noje monequi pa camo anmocahuas pa anquichías len quililo in oc sequin lajtomes tijtipichin. ");
INSERT INTO nclNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Amhuanten telaicananijmes pachacames! Anunca quinami se hual quitzejtzelúa pa quisas se muyol pin al huan quitolúa se camello, pampa ca míac lachialisli anlaquisa anquichijtica in lajtomes tijtipichin huan amo anquinequi anquijnamiquía in lajtomes huejué. ");
INSERT INTO nclNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Quichi anpanus lacocoltilisli amhuanten, ilamaxtinijmes in lajtol huan fariseos, lacuajcuamananijmes! Unca quinami ancaltía pa quiahuac in tecomal huan in nixcumil. Ma yoje, pa laijtic cate catzahuac, quinami amhuanten laijtic anmoyolo anunca catzahuac. Anunca catzahuac pampa ancanac mochi hual anquinequic míac. Amo cataya anmoyaxca huan ma yoje anquinmixtequilic oc sequin pa ancanas. ");
INSERT INTO nclNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseo pachacal, monequi pa tipehuas timochipajtica molaijtic quinami quichipahualo ilaijtic in tecomal huan in nixcumil huan cuaquín ancayas chipahuac pa quiahuac. ");
INSERT INTO nclNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Quichi anpanus lacocoltilisli amhuanten ilamaxtinijmes in lajtol huan fariseos lacuajcuamananijmes!, pampa amhuanten anquinami in caltzindis layapali iztac hual quichihualo capa quinlalpachulo in mijquimes. Nesilo cualtichin pa quiahuac, huan ma yoje laijtic tenticate ca inminumimes mijquimes huan ca mochi catzahualisli. ");
INSERT INTO nclNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Yoje nuso annesi amhuanten noje quinami cuali huan cualtichin huan melahuac pa anmoquiahuac. Ma yoje, laijtic amhuanten antentica ca ilacuajcuamanalisli anmoyolo huan amo anquinequi anquineltoca Dios ilajtol, amhuanten ejꞌelehuis. ");
INSERT INTO nclNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Quichi anpanus lacocoltilisli amhuanten ilamaxtinijmes in lajtol huan fariseos lacuajcuamananijmes! Pampa anquinchía in caltzindis capa quinlalpachuje Dios ilajtunijmes, huan anquichijchía cuajcualtichin inminlaijnamiquiltinijmes in lacames cuajcuali. ");
INSERT INTO nclNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Cuaquín anquijtúa: “Sinda tiyuliloaya quiman yuliloaya totajtzitzían, amo tiquinpalehuiloaya quiman quinmictinijme Dios ilajtunijmes.” ");
INSERT INTO nclNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ca inon anquijtutica nuso pampa amhuanten nojen anunca inminmiahuimes yehuanten hual quinmictije Dios ilajtunijmes. ");
INSERT INTO nclNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Axan ¡xilaquistiacan anquichijtica len pehuaje quichihuaje anmotajtzitzían! ");
INSERT INTO nclNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Cuhuames! ¡Amhuanten inminxolomes cuhuames! ¡Quinami huil anmoquixtis pin lacocoltilisli capa cayasi yehuanten hual amo iyaxca Dios! ");
INSERT INTO nclNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Pampín, xiquitacan. Annimitztilanilis Dios ilajtunijmes huan lacames hual quimatilo huan lamaxtinijmes. Sequin anquinmictis, sequin anquinpilus pan cuahuimes. Oc sequin anquinhuitequis pa anmotiopames huan oc sequin anquintojtocas pa quisasi pa se caltilan huan pa oc se. ");
INSERT INTO nclNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","In anmitzpanus pa yoje Dios anmitzmotexpahuilis amhuanten. Anmitzmotexpahuilis pa mochi lacames inminesli latoyahuili, quema, inminesli moxtin lacames cuajcuali hual cataloaya lamictili pan mochi in lalticpan quiman pehuac in lalticpan huan pa axan. Inon unca quiman Abel yec lamictili pa quiman anquimictic Zacarías hual yec ixolol Baraquías. Yihual anquimictic lajco pin tiopan hué huan inon capa quilalilo in huendis. ");
INSERT INTO nclNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Neli annimitzilía, Dios quinmotexpahuilis inminpampa moxtin yehuanten hual cate lamictili. Quema, Dios anmitzmotexpahuilis amhuanten hual anyultica axan. ");
INSERT INTO nclNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Jerusalén, Jerusalén! Yehuanten laijtic tehual, Jerusalén, yehuanten quinmictilo Dios ilajtunijmes huan quinlaxililo tixcalimes yehuanten hual Dios quintilanilía. ¡Quichi míac nicnequic niquinnechicuc yehuanten pa Jerusalén quinami quinnechicúa se lapachuani iparachitos itzindan inastacapajmes huan amo quinequije! ");
INSERT INTO nclNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Xiquitacan. Cayasi lacajcahuali chantiticate yehuanten pin caltilan huan Dios amo cayas ca yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Pampa annimitzilía neli, yajmo annechitas axan pa quiman. San annechitas quiman ajsis in tonali quiman anquijtus: “Ma Dios quipía yihual hual huala ca ilahueliltilisli, ichicahualisli in Tata.” ");
INSERT INTO nclNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Quisac Jesús pin tiopan hué, uyajtíac huan ajsitiaje capa yihual imonextilinijmes. Pehuaje quilaquetzilije quinami cataloaya lachijchihuali cualtichin mochi icalimes in tiopan hué. ");
INSERT INTO nclNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Huan Jesús quinnanquilic: —¿Anquinmita mochi innojen? Neli annimitzilía, amo mocahuas nican se tel pan oc se tel hual amo quimayahuisi, mochi quixitinisi. ");
INSERT INTO nclNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Cuaquín uyaje pani in loma (tepetzindi) itoca Olivos. Nepa molalic Jesús, hualaje capa yihual imonextilinijmes inminhuían, quilije: —Xitechili, ¿quiman cayasi innojen? Huan ¿len yes in lanextilisli calica ticmatisi quiman tihualas pa tihuelitis, in lanextilisli calica ticmatisi quiman lamis in lalticpan hual unca axan? ");
INSERT INTO nclNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús quinnanquilic: —Ximolachilican pa camo anmitzcuajcuamanas amaqui. ");
INSERT INTO nclNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Hualasi míac quijtuticate pampa quipialo nolahueliltilisli, huan quijtusi: “Nehual niCristo”, huan quincuajcuamanasi míac lacames. ");
INSERT INTO nclNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Anmitzlamachiltisi lacames pampa cate moanalisli cajcapa pin lalticpan, moanalisli hual panujticate huan moanalisli hual yalo pehualo. Amo ximomajtican, innojen quipialo pa panusi huan ayamo lamis in lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Se lahueliltilisli moanas ca oc se lahueliltilisli. Yehuanten pa se lali moanasi ca yehuanten pa oc se lali. Cayas mayandi cajcapa huan miquisi míac. Cayas cocolisli, huan laulinis chicahuac cajcapa. ");
INSERT INTO nclNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mochi innojen yesi jan quinami pehuasi in miác cocolisli hual yalo panulo lacames. Unca quinami mococúa se sihual quiman pehua lacati ixól. ");
INSERT INTO nclNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Cuaquinon anmitztemacasi pa anmitzhuejuecaltisi huan anmitzmictisi. Huan moxtin anmitzcocolisi pampa annechneltoca. ");
INSERT INTO nclNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Pan innojen tonalijmes míac lacames mijcuanisi pa yajmo quitocasi iojli Dios, yajmo quineltocasi. Huan motemacasi se huan oc se pa yesi latojtocali. Mococolisi se huan oc se. ");
INSERT INTO nclNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Huan nesilo cajcapa míac hual quijtusi pampa yehuanten cate Dios ilajtunijmes. Ma yoje, islacatisi, huan yehuanten quincuajcuamanasi míac lacames. ");
INSERT INTO nclNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Huan cayasi yoje míac lacames hual yultialo quichijticate amo cuali. Pampín, míac mocahuasi pa quinlasojlasi oc sequin quinami lalasojlanijme. ");
INSERT INTO nclNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ma yoje, aqui yes mopepenialtis huan mochicahualtis pa panus mochi in amo cuali, yihual Dios quiquixtilis pin polehuilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Huan momachiltisi ilamachiltilisli cuali nolahueliltilisli pa capa yes chantilo lacames pin lalticpan, pa quimatisi pa mochi lalimes. Cuaquín lantihualas mochi pan lalticpan. Dios laquisas ca in hual quichijtica ca in lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Pa yina, Daniel ilajtuni Dios quijcuiluc pa iamal, quijcuiluc pampa yahuiaya nesi in hual niman tetzcuinuc hual lacatzahua huan laijlacúa. (Ma quimati len quinequi quijtúa inon mochi sejse hual momaxtitica.) Huan quiman anquitas inon yehuatica pin tiopan hué capa jan unca iyaxca Dios pa cayas, capa in niman chipahuac pin tiopan hué, ");
INSERT INTO nclNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","cuaquín ma cholu aqui cayas pa Judea, ma cholu pan lomas (tepemes). ");
INSERT INTO nclNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Huan aqui cayas pani pa icali, ma camo temu pa quiquixtis len pa icalijtic. ");
INSERT INTO nclNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Huan aqui cayas pa icuajmili, ma camo mocuepa pa canas inahuas. ");
INSERT INTO nclNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Quichi panusi lacocoltilisli yehuanten hual yalo quipialo xolomes huan yehuanten hual lachichiltijticate innojen tonalijmes! ");
INSERT INTO nclNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Xictemachican Dios pa camo anquipías pa ancholus quiman cayasi tonalijmes hual sehua, o pa camo panus pan tonali quiman anmosehuía. ");
INSERT INTO nclNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Unca pampa lacames yalo panulo lacocoltilisli pa in tonalijmes quinami amo quiman panunijme quiman pehuac in lalticpan niman pa yina huan pa mochi in tonalijmes hual lantihualaje ca axan. Huan amo quiman cayas yoje oc sejpa quiman panusi innojen tonalijmes. ");
INSERT INTO nclNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Huan sinda Dios amo quilaliaya pa camo huejcahualosquiaya innojen tonalijmes, cuaquín amaqui mocahuaya yultica. Ma yoje, amo cayas yoje. Dios quilalic pa camo huejcahualosquiaya innojen tonalijmes pampa quinlasojla yehuanten hual quinlajtultic pa yesi ilacames. ");
INSERT INTO nclNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Cuaquín, sinda se anmitzilía: “Xiquitacan, nican unca in Cristo”, o “Xiquitacan, nepa unca”, amo xicneltocacan. ");
INSERT INTO nclNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Pampa nesisi lacuajcuamananijmes hual quijtusi islacatijticate pampa cate cristos yehuanten huan nesisi lajtunijmes hual quijtusi pampa anmitzilijticate ilajtomes Dios, huan ma yoje islacatijticate. Quinchihuasi hual pampa innojen in lacames moitasi momajtiticate. Quinchihuasi pampa quinequisi quincuajcuamanasi, sinda huil, yehuanten hual Dios quinlajtultic pa yesi ilacames. ");
INSERT INTO nclNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Xiquitacan. Axan annimitzilic inon quiman ayamo panuc. Pampín sinda anmitzilisi: ");
INSERT INTO nclNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Xiquitacan. Cristo unca nepa capa amaqui chanti”, cuaquín amo xiquisacan amhuanten ca umpic. O sinda anmitzilis: “Xiquitacan. Cristo unca nican niman calijtic”, amo xiquinneltocacan. ");
INSERT INTO nclNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Pampa jan quinami pelanía pejtica capa quisa in tonali huan lami capa calaqui in tonali, yoje yes quiman nel nihualas, nel ilacal in cielo. ");
INSERT INTO nclNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Capa cayas in mijquil, nepa monechicusi in tzopilojmes. ");
INSERT INTO nclNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Jan axcan quiman lamisi panusi innojen tonalijmes capa panulo míac lacocoltilisli, cuaquín laticumactis in tonali huan in mesli amo quinequis lahuis. Hueztiasi in luceros (silalimes) pin cielo huan molinisi in ijyecames amo cuajcuali pin ijyecal hual huelitilo ca lacames amo cuajcuali pan lalticpan, quipolusi inminchicahualisli. ");
INSERT INTO nclNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Cuaquinon moitas pin cielo in lanextilisli hual lamachiltis pampa huala nel ilacal in cielo. Pampín moxtin pin lalticpan chocasi quiman quitasi hualajtica ca lahueliltilisli chicahuac huan laixpelalisli cualtichin, hualajtica pin mextemimes. ");
INSERT INTO nclNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Quintilanis ilanahuatinijmes pin cielo ca lancaquetzalisli chicahuac, xahuantica chicahuac ca ilancaquetzaloni. Quinnechicusi yehuanten hual Dios quinlajtultic pa yesi iyaxca. Quinnechicusi quinquixtilijticate pa mochi cajcapa pin lalticpan, pa se itenco in lalticpan capa pehua in cielo ca capic unca in oc se itenco in lalticpan capa lami in cielo. ");
INSERT INTO nclNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Ximonextilican in lajtol inahuac in amacuál tipichin calica annimitznextilis len nicnequi niquijtúa: Quiman mochía sejselic iramitas (iitzmolinquimes) huan ixua isacayo, cuaquín anquimatis pampa amo huejcahuas pa ajsis xupanda. ");
INSERT INTO nclNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Yoje, amhuanten noje quiman anquitas mochi innojen, cuaquín anquimatis pampa ajsitihuala inon hual yahui panúa, quinami se hual tijcaquía jan pa quiahuac in lalapujquil. ");
INSERT INTO nclNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Annimitzilía neli, mochi inon panus quiman ayamo lamisi yehuanten pin lali hual yulticate nepa. ");
INSERT INTO nclNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mocahuasi pa yesi in cielo huan in lalticpan. Ma yoje, nolajtomes amo quiman mocahuasi pa yesi, amo quiman motzacuasi pa camo mochihuasi. ");
INSERT INTO nclNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Ma yoje, amaqui quimati calía tonali huan hora quiman mochihuasi innojen. Amo quimatilo in lanahuatinijmes pin cielo, amo nicmati nehual hual Dios ixól. San Dios noTajtzin quimati. ");
INSERT INTO nclNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Jan quinami cataya quiman yulini Noé pan lalticpan pa yina, yoje cayas quiman nía nihuala nehual ilacal in cielo. ");
INSERT INTO nclNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Pa innojen tonalijmes quiman Dios ayamo quinmatoctic moxtin, lacames yulinijme lacuajtataloaya huan launtataloaya huan monamictitataloaya huan quinmacatataloaya inminxolomes sihuames pa monamictilosquiaya, yoje yulinijme. Cuaquín ajsic in tonali capa calaquic Noé pin arca. ");
INSERT INTO nclNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Huan amo moijnamiquiltije len yahuiaya panu. Cuaquín huetzic in al hual catani pa pani pin cielo huan lejcuc in al hual catani itzindan in lali huan quinhuicac quinmatoctitataya moxtin. Yoje cayas noje quiman nihualas nehual, ilacal in cielo. ");
INSERT INTO nclNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Pa in tonali, cayasi ome lacames pan cuajmili, se yes lahuicali huan in oc se yes lacahuali. ");
INSERT INTO nclNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ome sihuames cayasi in omenten testicate pan melal, se yes lahuicali, oc se lacahuali. ");
INSERT INTO nclNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Pampín, ximolachilican pa mojmosta anmoijnamiquiltitías, pampa amo anquimati calía tonali yahui huala in Tata. ");
INSERT INTO nclNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Xicmatican inon: Sinda quimatiaya iteco in cali quiman yahuiaya huala in laxtequini, cuaquín lachiaya huan amo quimacahuiltiaya quichía coyunquil pa calaquisquiaya quixtequili len iyaxca hual cataya calijtic. ");
INSERT INTO nclNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Pampín, amhuanten noje xicayacan xilachixtiacan, pampa nehual ilacal in cielo nía nihuala quiman amo anquijnamictica inon hual annimitzilic. ");
INSERT INTO nclNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Sinda se teco quipía se tequipanujquil hual quimati huan quineltoca, cuaquín quicahuilis pa quilachilis pan mochi icali huan pa quinmacas moxtin len quicuasi pa quiman monequi pa lacuasi. ");
INSERT INTO nclNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Quipías paquilisli in tequipanujquil hual quichijtica yoje quiman mocuepa iteco pa ichan huan quita itequipanujquil quitequipanuilijtica yoje. ");
INSERT INTO nclNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Neli annimitzilía in teco quicahuilis itequipanujquil pa quilachilis pan mochi hual quipía pampa iteco yoje quimati yihual itequipanujquil quimati quitequipanuilía cuali. ");
INSERT INTO nclNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Huan sinda itequipanujquil mochías amo cuali, yihual pehua quijtúa laijtic yihual: “Huejcahua pa hualas noteco.” ");
INSERT INTO nclNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Yoje pehua quinhuitequía icnían tequipanujquimes huan pehua lacua huan lahuana ca in lahuanquimes. ");
INSERT INTO nclNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Cuaquín hualas iteco pan se tonali quiman amo cayas quichixtica, se tonali hual amo quimatiaya. ");
INSERT INTO nclNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Huan iteco quimacas lacocoltilisli chicahuac. Quitilanis pa quipías in hual quipiasi yehuanten hual yuliloaya lacuajcuamantataya inminlaixpan moxtin. Cuaquín chocas huan quincuajcuas ilames. ");
INSERT INTO nclNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Cuaquín huil quijtúa se pampa ilahueliltilisli in cielo unca quinami diez sihuames yajyancuic hual quinhuicaje chahuac huan inmintapalquitas pa lalahuisi huan uyaje pa se monamictilisli pa quisalosquiaya quinamiquilo in lacal hual monamictiaya. ");
INSERT INTO nclNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cinco (macuili) ca in sihuames yajyancuic amo quimatiloaya huan in oc sequin macuili quimatiloaya. ");
INSERT INTO nclNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Yehuanten hual amo quimatiloaya amo quihuicaje ca yehuanten oc sequin tapalquitas ca chahuac, san in hual cataya laijtic inmintapalquitas. ");
INSERT INTO nclNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Yehuanten hual quimatiloaya quihuicaloaya chahuac pa inmintapalquitas pa quiman quinequiaya. ");
INSERT INTO nclNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Huan quinami huejcahuac hualac in lacal hual monamictiaya, quipiaje cochilisli in sihuames yajyancuic huan cochije. ");
INSERT INTO nclNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Cuaquín quinami pa lajco layúa mocaquic tzajtzije, quijtuje: “¡Axan huala in lacal! ¡Xiquisacan xicnamiquican!” ");
INSERT INTO nclNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Moxtin in sihuames ejsaje huan moquetzaje pa quichijchihuasi inmintapalquitas. ");
INSERT INTO nclNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Huan yehuanten hual amo quimatiloaya quinmilije yehuanten hual quimatiloaya, quil: “Xitechmacacan nadita anmochahuac pampa mosejticate totapalquitas”, quil. ");
INSERT INTO nclNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Huan in sihuames hual quimatiloaya quinnanquilije: “Amo huil, pampa cuaquín amo techajsis tehuanten huan amhuanten. Monequi pa anyahuis capa in lanamacanijmes huan ximocuhuilican chahuac.” ");
INSERT INTO nclNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Quiman uyaje in macuili hual amo quimatiloaya pa quimocuhuilisi, cuaquín ajsic yihual hual monamictiaya. Calaquije ca yihual yehuanten hual quipialoaya chahuac, calaquije pan monamictilisli, cuaquinon cataya latzacuali in lalapujquil. ");
INSERT INTO nclNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Panuc nadita, ajsije innojen oc sequin sihuames yajyancuic pan lalapujquil quinoztataloaya: “¡Tata, Tata, xitechlapuli!” ");
INSERT INTO nclNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Huan yihual quinnanquilic: “Neli, annimitzilía da amo annimitziximati.” ");
INSERT INTO nclNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Cuaquinon Jesús quinmilic: —Xilachixtiacan, pampa amo anquimati in tonali huan in hora quiman nihualas nehual ilacal in cielo. ");
INSERT INTO nclNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Ilahueliltilisli in cielo unca jan quinami se lacal hual yahui pa oc se lali, huan quiman ayamo quisac, quinnotza itequipanujquimes, quintemacac itomin pa quilachilisi. ");
INSERT INTO nclNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Se ca yehuanten yihual quimacac quinami macuili mil tomin, ca oc se quimacac ome mil, huan ca oc se quimacac se mil. Cuaquín mohuicac pa oc se lali. ");
INSERT INTO nclNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","In tequipanujquil hual quipíac macuili mil lacuhuac huan lanamacac ca in tomin, huan monechiculic oc sequin macuili mil. ");
INSERT INTO nclNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Jan yoje monechiculic oc sequin ome mil in se hual quipíac ome mil tomin. ");
INSERT INTO nclNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Huan in se hual quipíac se mil uyac lahuajuanac huan quilatic itomin iteco pin lali. ");
INSERT INTO nclNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Cuaquín, quiman panuje míac tonalijmes, mocuepac inminteco innojen tequipanujquimes huan ca yehuanten pehuac laquetzac inahuac itomin. ");
INSERT INTO nclNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Hualac ca yihual in se hual quipíac in macuili mil tomin, quihualicac ca yihual oc sequin macuili mil tomin, quilic: “Tata, tichtemacac macuili mil tomin huan xiquita, nimitznechiculic oc sequin macuili.” ");
INSERT INTO nclNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Quinanquilic iteco: “Ticchíac cuali, tel tiunca se tequipanujquil cuali hual nicmati huil ticchía mochi cuali. Ticchihuac cuali ca nadita. Pampín nimitzmacas lahueliltilisli ca míac. Axan tía tiquitas quichi paquilisli huil nimitzmaca. Xicalaqui capa nehual.” ");
INSERT INTO nclNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Cuaquín hualac in se hual quipíac in ome mil tomin, quilic: “Tata, tichtemacac ome mil tomin. Xiquita, nimitznechiculic oc sequin ome mil.” ");
INSERT INTO nclNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Iteco quinanquilic: “Ticchíac cuali, tel tiunca se tequipanujquil hual nicmati huil ticchía mochi cuali. Ticchíac cuali ca nadita. Pampín nimitzmacas lahueliltilisli ca míac. Axan tía tiquita quichi paquilisli huil nimitzmaca. Xicalaqui capa nehual.” ");
INSERT INTO nclNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Quiman hualac pa iteco in se hual quipíac in se mil tomin, quilic: “Tata, nimitziximati quinami tiunca se lacal chicahuac pa moyolo. Tilapixca capa amo tilatocac huan tilapejpena capa amo tilaxinic. ");
INSERT INTO nclNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Huan nimomajtic, pampín niclatic pin lali motomin. Xiquita, nican ticpía len moyaxca.” ");
INSERT INTO nclNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Iteco quinanquilic: “Elehuis tequipanujquil tehual, tilatzehui. ¿Ticmati nuso pampa nilapixca capa amo nilatocac huan nilapejpena capa amo nilaxinic? ");
INSERT INTO nclNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Pampín ticpiaya pa tictemacasquiaya notomin yehuanten hual quilanehuilo tomin. Cuaquín quiman nihualaya, nicpiaya notomin ca imiactilisli.” ");
INSERT INTO nclNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Cuaquín quinmilic yehuanten hual nepa cataloaya: “Xijquixtilican in mil tomin huan xicmacacan yihual hual quipía in diez mil tomin.” ");
INSERT INTO nclNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Pampa aqui quipía, yihual quimacasi noje oc sequin huan quipías niman míac pa cajcoquis. Aqui hual amo quipía, quiquixtilisi in nadita hual quipía. ");
INSERT INTO nclNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Huan in tequipanujquil hual amo monotza, xiclasacan pa quiahuac capa laticumac. Nepa chocasi huan quincuajcuasi inminlames. ");
INSERT INTO nclNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Quiman nihualas nehual ilacal in cielo, nihualas quinami se hué, huan Dios ilanahuatinijmes pin cielo nechyahualusi. Cuaquín nimolalis pan noicpali hual laixpelas cualtichin. ");
INSERT INTO nclNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Umpa quinnechicusi nolaixpan moxtin yehuanten hual yulinijme pa mochi inminlalimes. Niquinxiluilis sequin huan oc sequin quinami in lachiani quinxiluilía iborregos pa camo cayasi ca ichivos. ");
INSERT INTO nclNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Quinlalía in borregos pa ima cuali huan quinlalía in chivos pan ima amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Cuaquín niquinmilis yehuanten hual cate pan noma cuali: “Xihualacan nican amhuanten hual anquipaquiltía noTajtzin, xicpiacan pa anmoyaxca in hual anmijchijchihuilic Dios quiman quipehualtic mochi. ");
INSERT INTO nclNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Inon anquipías pampa quiman nimayantataya, annechlacualtic, niamictataya huan annechlauniltic, nicataya se hual amo annechiximatiaya huan annechnamiquic quinami se ca amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nicataya nacatil huan annechlaquentic, nicataya cocoxquil huan annechpaxaluilic, nicataya latzacuali pin calijtic, huan anhualac capa nehual pa annechpalehuis.” ");
INSERT INTO nclNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Cuaquín quinanquilisi yehuanten hual quipialo cuali inminyolo, quilisi: “Tata, ¿quiman timitzitaje timayantataya huan timitzlacualtije? ¿Quiman timitzitaje tiamictataya huan timitzlauniltije? ");
INSERT INTO nclNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Quiman timitzitaje quinami se hual amo timitziximatiloaya huan timitznamiquije quinami ticataya se ca tehuanten, o nacatil huan timitzlaquentije? ");
INSERT INTO nclNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Huan ¿quiman ticataya cocoxquil, o latzacuali pin calijtic huan timitzpaxaluilije?” ");
INSERT INTO nclNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","’Niquinnanquilis huan niquinmilis: “Neli annimitzilía pampa mochi hual anquichihuilic se ca innojen nocnían, mas que yec in niman tipichin ca yehuanten, yoje cataya quinami annejchihuilijtataya nehual.” ");
INSERT INTO nclNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Cuaquín niquinmilis yehuanten hual cate pa noma amo cuali: “Xiquisacan capa nehual ca yoje, amhuanten ejꞌelehuis, ximijcuanican pa yajmo ancayas nican, pa anyas pin tixuxli hual amo quiman sehuis, tixuxli lalalaltili pa in lili huan ilanahuatinijmes. ");
INSERT INTO nclNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Pampa nimayantataya huan amo annechlacualtic, niamictataya huan amo annechlauniltic. ");
INSERT INTO nclNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nicataya se hual amo annechiximatiaya huan amo annechnamiquic quinami se ca amhuanten. Nicataya nacatil, huan amo annechlaquentic. Nicataya cocoxquil huan latzacuali pin calijtic huan amo annechpaxaluilic.” ");
INSERT INTO nclNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Cuaquín nechnanquilisi yehuanten noje, quilisi: “Tata, ¿quiman timitzitaje timayantataya o tiamictataya o quinami se hual amo timitziximatiloaya o nacatil o cocoxqui o latzacuali pin calijtic huan amo timitzpalehuije?” ");
INSERT INTO nclNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Huan nehual quinami hué niquinmilis: “Neli annimitzilía pampa mochi hual amo anquichihuilic se ca innojen nocnían, mas que yec in niman tipichin, yoje amo annejchihuilic nehual.” ");
INSERT INTO nclNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Cuaquín innojen yasi pa in lacocoltilisli hual amo quiman lamis, huan yehuanten hual quipiaje inminyolo cuali yasi capa amo quiman mocahuasi pa yulisi cuali. ");
INSERT INTO nclNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yoje, quiman Jesús lamic quinmilic mochi inon, quinmilic imonextilinijmes: ");
INSERT INTO nclNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Anquimati pampa ajsis in ilacualisli pascuas axan ca ome tonalijmes. Cuaquín nechtemacasi pa nechpilusi pan se cuahuil nehual ilacal in cielo. ");
INSERT INTO nclNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Cuaquinon pan innojen tonalijmes monechicuje in tiopistas huejué huan abuelojmes inminhueyenten in judíos huan ilamaxtinijmes in lajtol. Monechicuje pa ilajcotiyan icali cualtichin Caifás, yihual ihué in tiopistas. ");
INSERT INTO nclNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nepa molaquetzililoaya quinami yahuiloaya quiquitzquilo Jesús ca lacuajcuamanalisli pa quitilanisi pa quimictisi. ");
INSERT INTO nclNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ma yoje, quijtuloaya: —Ma camo ticchihuacan quiman panujtica in fiesta pa camo majcoquisi in lacalera pa moanasi ca tehuanten. ");
INSERT INTO nclNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús cataya pa icali Simón hual quipiani in cocolisli itoca lepra huan pampín quitocayaltinijme in Leproso. ");
INSERT INTO nclNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Huan ajsic capa Jesús se sihual quihualicatataya se tapalcal lachihuali ca alabastro. In tapalcal tentataya ca chahuac hual ajuíac huan ipatiaya míac. Jesús cataya pan lacualisli huan in sihual quitoyahuac in chahuac pa itzontecon Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Quitaje inon imonextilinijmes, cualaniloaya, pehualoaya quijtulo: —¿Pa len quipoluc yoje in chahuac? ");
INSERT INTO nclNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Pampa huil quinamacaloaya in chahuac pa míac tomin huan huil quinmacaloaya yehuanten hual amo quipialo míac, yoje pa quinpalehuilosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Quiman Jesús quimatic len quijtuloaya, quinmilic: —¿Leca anquimaca tequil in sihual? Nejchihuilic len cuali nehual. ");
INSERT INTO nclNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mojmosta anquinpía ca amhuanten yehuanten hual amo quipialo míac. Nehual amo anyahui annechpía mojmosta. ");
INSERT INTO nclNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Quiman yihual nechtoyahuilic in chahuac hual ajuíac pan nocuerpo, yoje nejchijchihuilic nocuerpo pa quiman nechlalpachusi. ");
INSERT INTO nclNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Annimitzilía neli, capa yes quinnahuatilo in nolamachiltilisli cuali pa mochi in lalticpan, cuaquín quinnahuatisi noje inon hual nejchihuilic yihual nehual, pa yoje moxtin quijnamiquisi inon hual nejchihuilic. ");
INSERT INTO nclNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Cuaquinon uyac in se imonextilini hual motocaya Judas Iscariote, uyac capa in tiopistas huejué. ");
INSERT INTO nclNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Quinmilic: —¿Quichi annechlaxlahuis sinda annimitztemaca yihual? Huan mocahuaje pa quilaxlahuisi ca plata, ca treinta (sempuhualihuanmajlacli) tomin. ");
INSERT INTO nclNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Huan jan axcan quitemujtinemiaya quiman cuali huil quintemacas Jesús ca yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pan tonali quiman pehuac in fiesta (ilhuil) quiman quicualo in pan hual amo quipía laxocoyajquil, hualaje capa Jesús imonextilinijmes, quilije: —¿Capa ticnequi pa ticyucxiltisi in nacal pa huil tijcuas iborreguito in pascua? ");
INSERT INTO nclNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Quinmilic: —Xiajtiacan pin caltilan pa icali in lacal huan xiquilican: “Quijtúa in Lamaxtini: Amo huejcahua pa nechajsis quiman nipanus nolacocoltilisli. Pampín nía nijcua iborreguito in pascua ca nomonextilinijmes pa mochan.” ");
INSERT INTO nclNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Quichihuaje quinami quinmilic Jesús, huan quiyucxiltije iborreguito in pascua. ");
INSERT INTO nclNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Quiman layuajtic, Jesús cataya pan lacualisli ca in doce (majlaclihuanome) imonextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Huan quiman lacuajtataloaya, quinmilic: —Annimitzilía neli pampa se ca amhuanten yahui nechtemaca ca nolacocolinijmes. ");
INSERT INTO nclNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Huan icnotiloaya niman míac, pehualoaya quililo mochi sejse: —¿Amo unca nehual, Tata? ");
INSERT INTO nclNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Huan quinnanquilic Jesús: —Yihual hual huan nehual tijcalactilo tomajma pin xicali ca altzindi chichic, yihual in se hual nechtemacas. ");
INSERT INTO nclNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nehual ilacal in cielo, nía nicana in ojli hual Dios nechlalilic quinami unca lajcuiluli pin iamal ilajtol. Ma yoje, ¡quichi panus lacocoltilisli in lacal hual nechtemaca ca nolacocolinijmes nehual ilacal in cielo! Cataya cuali pa in lacal sinda amo lacatiaya. ");
INSERT INTO nclNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Quinanquilic Judas in hual quitemacasquiaya, quilic: —¿Amo unca nehual, Lamaxtini? Jesús quinanquilic: —Tehual tiquijtuc. ");
INSERT INTO nclNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Lacuajtataloaya yehuanten, Jesús canac in pan pa imajmajuan, quisehuic Dios, huan quilapanac. Cuaquinon quinmacac imonextilinijmes, quinmilic: —Xicanacan huan xijcuacan. In nocuerpo. ");
INSERT INTO nclNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Cuaquinon canac in tapalquita pa imajmajuan, quisehuic Dios, cuaquín quinmacac, quinmilijtica: —Xicunican anmoxtin iayo uva coc pin tapalquita. ");
INSERT INTO nclNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Inon noesli hual quichía pa yes cuali Dios ilajtulisli yancuic ca amhuanten. Amo lamis in lajtulisli. Noesli toyahuis pa míac pa quinquixtilis yehuanten inminlaijlaculisli, Dios quinpujpuhuas. ");
INSERT INTO nclNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Huan annimitzilía pampa yajmo nicunis in iayo uva coc. Ma yoje, quiman noTajtzin ilahueliltilisli pin cielo pehua monextía pan lalticpan, cuaquín pa in tonali nicunis yancuic ca amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Cuaquín quicantaruje (quicuicaje) innojen lajtomes huejué pa Dios, huan umpa uyaje pa in loma (tepetzindi) hual itoca Olivos. ");
INSERT INTO nclNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Cuaquinon Jesús quinmilic: —Anmoxtin anyahui annechcajcahua axan in layúa, pampa anpinahuas pa annechpías nehual pa anmolamaxtini. Yahui caya yoje pampa Dios ilajtol lajcuiluli quijtúa: “Nicmictis in lachiani hual quinmita in borregos, huan in borregos yesi lasemanali ca capic yes.” ");
INSERT INTO nclNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ma yoje, quiman niyultica oc sejpa, nía annimitzlaicana amhuanten pa Galilea. ");
INSERT INTO nclNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Cuaquinon Pedro quilic: —Mas que moxtin mitzcajcahualo pampa pinahuasi mitzpiasi pa inminlamaxtini, nehual amo quiman nimitzcajcahuas. ");
INSERT INTO nclNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Huan Jesús quilic Pedro: —Nimitzilía neli pampa axan pan in layúa ayamo xahuanis in gallo, huan tehual tiquijtus pampa amo tichiximati, tiquijtus sejpa huan oc sejpa, quema, tiquijtus ca ye lajtulisli. ");
INSERT INTO nclNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro quilic: —Mas que nicpiaya pa nimiquis ca tehual, damo niquiliaya pampa amo nimitziximati. Huan yojque quijtuje moxtin imonextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Cuaquinon hualaje ca imonextilinijmes pan se lajcotiyan itoca Getsemaní, huan Jesús quinmilic: —Ximolalican nican huan nehual nías ca umpic pa niclajlanis Dios. ");
INSERT INTO nclNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Huan quinhuicac ca yihual Pedro huan in ome ixolomes Zebedeo huan pehuaya icnoti niman míac, mococujtiahuiaya niman míac pa iyolo. ");
INSERT INTO nclNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Cuaquinon quinmilic: —Nechcocojtica noyolo míac, huan nilamati quinami nimictica. Ximocahuacan nican amhuanten huan xilachiacan ca nehual. ");
INSERT INTO nclNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Cuaquinon Jesús uyac nadita huejquita, huetzic pa iixco, quilajlanic Dios, quilic: —NoTajtzin, sinda huil, ma camo nechpanu in hual yahui nechpanúa. Ma yoje, ma camo mochía quinami nicnequi, ma mochía quinami tehual ticnequi, inon ma ye. ");
INSERT INTO nclNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Cuaquinon mocuepac pa capa cataloaya yehuanten, quinmitac coxtataloaya, huan yihual quilic Pedro: —¿Amo huil anlachía jan se hora san ca nehual? ");
INSERT INTO nclNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ximocahuacan anejsatica huan xiclajlanican Dios, pa yoje amo anmitztilanilis anmoyolo Satanás. Neli pa anmoyolo anquinequi anquichía cuali. Ma yoje, anmocuerpo (anmonacayo) amo quipía chicahualisli pa quichías. ");
INSERT INTO nclNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Oc sejpa uyac huan yojque quilajlanic Dios, quilic: —NoTajtzin, sinda inon hual yahui nechpanúa amo huil yes lapatili, cuaquín ma mochía quinami ticnequi. ");
INSERT INTO nclNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Huan oc sejpa quiman mocuepac capa cataloaya imonextilinijmes, quinmitac coxtataloaya pampa quinyamantataya in cochilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Quincahuac yehuanten huan oc sejpa uyac, quilajlanic Dios quilijtataya oc sejpa in lajtomes hual lamic quijtuc. Yoje quilajlanic ca ye lajlanilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Cuaquinon hualac capa cataloaya imonextilinijmes huan quinmilic: —Ancochi huan anmosehuía pa in nadita hual anmitzcahuilía. Xiquitacan, axan ajsic ilajco in layúa quiman nehual ilacal in cielo nicayas latemacali pa nechquitzquisi in lacames laijlaculi. ");
INSERT INTO nclNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ximoquetzacan, ma tiacan. Xiquitacan, axan yihual hual nechtemaca huala. ");
INSERT INTO nclNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Huan ayamo lamiaya laqueztataya Jesús, xiquitacan, hualaya Judas, in se imonextilini ca in doce. Ca yihual hualaloaya se lanechiculisli hual yeje lacames hual in tiopistas huejué huan inminhuejueyenten in judíos quintilanije. Quimpixtihualaloaya cuahuimes huan teposli calica moanalo guaches. ");
INSERT INTO nclNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Huan Judas hual quitemacaya Jesús quinmacac in míac lacalera se lanextilisli, quinmilic: —Aqui yes nictenamiquis, yihual in se, xijquitzquican. ");
INSERT INTO nclNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Huan jan axcan hualaya ca Jesús, quilic: —¡Ma Dios mitzpía, Lamaxtini! Huan quitenamiquic. ");
INSERT INTO nclNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús quinanquilic: —Nito, ¿pa inon tiunca nican? Cuaquinon hualaje, molaxilije inmajmajuan pani Jesús huan quiquitzquijtiquisaje. ");
INSERT INTO nclNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ca inon, xiquitacan, se hual cataya ca Jesús quixilanic imajma huan quiquixtitiquisac iteposli pa moanalisli, quimacac se latzontequilisli itequipanujquil in tiopista hué, quicotonilic se inacas. ");
INSERT INTO nclNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesús quilic: —Ximopili moteposli capa monequi mocahuas. Moxtin hual moanalo ca teposli pa moanalisli noje miquisi pan ipampa in teposli. ");
INSERT INTO nclNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Amo ticmati nehual huil niclajlanía noTajtzin huan Yihual nechtilanilis jan ajnaxcan doce batallones ca ilanahuatinijmes guaches hual cate pin cielo? Quema, huan oc se sinda nicnequiaya. ");
INSERT INTO nclNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ma yoje, sinda yoje nicchihuaya, ¿quinami lamiaya mochía Dios ilajtol lajcuiluli hual quijtúa pampa monequi pa nechpanus inon? ");
INSERT INTO nclNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Cuaquinon Jesús quinmilic in míac lacalera, quinmilic: —¿Anquisac ca teposlimes huan cuahuimes quinami anquisaya anquiquitzqui je laxtequini? Itequi nimolaliaya pin tiopan nilamaxtitataya huan amo annechquitzquic. ");
INSERT INTO nclNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ma yoje, mochi inon panujtica pa yoje lamis mochías len quijcuiluje ilajtunijmes Dios. Cuaquinon moxtin imonextilinijmes quicajcahuaje, choluje. ");
INSERT INTO nclNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yehuanten hual quiquitzquije Jesús quihuicaje ca ilaixpan Caifás in tiopista hué, capa cataloaya lanechiculi ilamaxtinijmes in lajtol huan inminhuejueyenten in judíos. ");
INSERT INTO nclNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro quitocac nejnentataya huejca. Ajsic pa ilajcotiyan icali in tiopista hué. Nepa calaquic huan molalic ca in guaches pa quitasquiaya quinami yahuiaya laquisa mochi inon. ");
INSERT INTO nclNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","In tiopistas huan in oc sequin ca in Lanechiculisli Hué quintemuloaya lacames hual quijtulosquiaya latexpahuilisli ilaixpan Dios ca lajtomes hual amo mopalalo. Yojque huil quitilanilosquiaya Jesús pa yesquiaya lamictili. Huan quema, quintemuloaya lacames hual islacatilosquiaya quijtutataloaya ilaixpan Dios pampa quijtuloaya melahuac. ");
INSERT INTO nclNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ma yoje, amo quitaje lacames hual huil quijtuloaya len ca lajtol melahuac, mas que míac lacames islacatije inahuac yihual. Cuaquín lamije hualaje inminlaixpan ome lacames islacatinijmes. ");
INSERT INTO nclNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Quimotexpahuilije, quijtuje: —In se quijtuc: “Nehual huil nicxitinía Dios itiopan hué huan quiman panusi ye tonalijmes huil nicchías oc sejpa.” ");
INSERT INTO nclNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Cuaquinon moquetzac in tiopista hué, quilic Jesús: —¿Amo ticnanquilía nindeno inahuac in hual yehuanten mitzmotexpahuilijticate? ");
INSERT INTO nclNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Huan Jesús amo nahuatic. Cuaquinon in tiopista hué quilic: —¡Nimitzilía pa titechilis ilaixpan Dios hual yuli, xitechili sinda tehual tiCristo, Dios ixolol! ");
INSERT INTO nclNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús quilic: —Nehual niunca, quinami tiquijtúa. Ma yoje, annimitzilía neli, annechitas nehual ilacal in cielo nimolalijtica pa ima cuali Dios hual quipía in chicahualisli niman hué. Annechitas nihualajtía pan imextemimes in cielo. ");
INSERT INTO nclNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Cuaquinon quitzayanic inahuas in tiopista hué. In quichihuaya pa lanextilisquiaya quinami cualanic míac pampa quijtuc inon Jesús, huan quijtuc: —¡Quihuejuecaltic Dios! ¡Yajmo monequi pa tiquintemusi oc sequin lacames pa quimotexpahuilisi! ¡Axcan, xiquitacan! ¡Anquicaquic in lahuejuecaltilisli! ¿Quinami anquita? ");
INSERT INTO nclNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Yehuanten quinanquilije, quilije: —Quipías pa miquis. ");
INSERT INTO nclNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Cuaquinon quichijchaje pa iixco huan quitecuaje chicahuac ca inminmajmajuan. Oc sequin quitecuaje ca se ojlal, quilije: ");
INSERT INTO nclNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","—Tehual tiCristo, pampín, ¡xilajmati aqui mitztecuac! ");
INSERT INTO nclNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Panujtataya Jesús inon, nepa pa quiahuac pin lajcotiyan cataya Pedro molalijtataya. Hualac capa yihual se tequipanujquil sihual yancuic, quilic: —Tehual noje ticataya ca Jesús in galileteco. ");
INSERT INTO nclNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Huan yihual Pedro quilic pampa no inminlaixpan moxtin, quilic: —Amo nicmati in hual tiquijtutica. ");
INSERT INTO nclNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Cuaquín quisac Pedro pa in lalapujquil huan nepa oc se tequipanujquil sihual yancuic quitac huan quinmilic yehuanten hual nepa cataloaya: —In se noje cataya ca Jesús in nazareteco. ");
INSERT INTO nclNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Huan oc sejpa quijtuc Pedro pampa no, quilijtataya quinami ilaixpan Dios, quijtuc: —Amo niquiximati in lacal. ");
INSERT INTO nclNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Quiman panuc se nadita, hualaje capa yihual yehuanten hual moqueztataloaya nepa, quilije Pedro: —Tehual nuso tiunca ca yehuanten noje pampa tilajtúa quinami yehuanten in galiletecos. Molajtol technextilía inon. ");
INSERT INTO nclNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Cuaquinon pehuac quinotzac Dios pa quilalilis ilaꞌajualisli ipan sinda in hual yehuanten quijtutataloaya inahuac yihual cataya melahuac. Huan quijtuc ilaixpan Dios ca lajtomes hual amo mopalalo, quinmilic: —Amo niquiximati in lacal. Huan jan ajnaxcan xahuanic in gallo. ");
INSERT INTO nclNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Cuaquinon Pedro quijnamiquic len Jesús quilic: “Ayamo xahuanis in gallo, huan tiquijtus ca ye lajtulisli pampa amo tichiximati.” Huan Pedro quisac pa quiahuac huan pehuac chocac míac. ");
INSERT INTO nclNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Cuaquín huajtzinco quiman lanesic mochihuilije se lajtulisli in tiopistas huejué huan inminhuejueyenten in judíos. Moilije quinami huil latilanilosquiaya pa yesquiaya lamictili Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Quihuicaje ilpitataya huan quitemacaje Poncio Pilato in gobernador (lahuelitini) romano. ");
INSERT INTO nclNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Cuaquinon Judas in se hual quitemacac Jesús ca ilacocolinijmes quitac quinami quitilanije Jesús pa miquis, huan pampín mococuhuaya iyolo pampa quichíac inon. Quincuepilic in plata, in treinta (sempuhualihuanmajlacli) tomin, quinmacac in tiopistas huejué huan in huejueyenten. ");
INSERT INTO nclNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Quinmilic: —Nicchíac laijlaculisli pampa annimitztemacac se hual amo quipiaya len laijlaculisli. Yehuanten quinanquilije: —¿Len inon pa tehuanten? Tehual mohuían ticpías pa ticchías in hual monequi pa timoquixtís in laijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Cuaquinon quilasac Judás in tomin pa in lali pin tiopan huan quisac, uyac, huan mopiluc pan se cuahuil, miquic. ");
INSERT INTO nclNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Cuaquín canaje in tomin in tiopistas, moilije: —In tolajtol amo techmacahuiltía pa ticlasasi in tomin capa quipialo itomin in tiopan hué pampa unca tomin hual quilaxlahuije pa yojque quimictisi se lacal. ");
INSERT INTO nclNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Molaquetzilije, huan ca nadita molalije pa quicuhuaje ca in tomin icuajmili in tapalquero. In cuajmili yesquiaya pa capa quilalpachulosquiaya yehuanten hual amo yuliloaya pa inminlali. ");
INSERT INTO nclNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Pampa inon quitocayaltije in cuajmili iCuajmili Esli, huan yoje motocatihuala axcan. ");
INSERT INTO nclNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Huan yojque lamic mochíac inon hual quijcuiluc Dios ilajtuni itocac Jeremías, quijtúa: “Huan quinmanaje in plata, in treinta tomin (cataya ilaxlahuilisli hual yehuanten pa Israel quilalilije yihual). ");
INSERT INTO nclNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Huan ca in tomin quicuhuaje icuajmili in tapalquero, jan quinami nechilic in Tata pa nicchías.” ");
INSERT INTO nclNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Huan Jesús quihuicaje pa moquetzas iyampa in gobernador romano, huan in gobernador quilajlanic: —Tehual, ¿tiunca inminhué in judíos? Huan Jesús quilic: —Quema, unca quinami tiquijtuc. ");
INSERT INTO nclNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Huan quimotexpahuililoaya in tiopistas huejué huan in huejueyenten. Ma yoje, Jesús amo quinnanquilic nindeno. ");
INSERT INTO nclNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Cuaquinon Pilato quilic: —¿Amo tijcaqui mochi in calica mitzmotexpahuililo? ");
INSERT INTO nclNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Huan amo quinanquilic ca se lajtol. Pampa inon in gobernador molapolultic huan amo quimatic len quijtusquiaya pa iyolo. ");
INSERT INTO nclNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Axcan, pan in fiesta (ilhuil) quipiani in huelitini (gobernador) in lachihualisli pa quinmacahuilisquiaya in judíos se hual cataya latzacuali pin calijtic, aqui yes quilajlanije. ");
INSERT INTO nclNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Quipiaje se latzacuali niman laiximatili hual motocaya Barrabás. ");
INSERT INTO nclNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pampa inon quiman monechicuje, Pilato quinlajlanic: —¿Aqui, nuso, anquinequi pa annimitzmacahuilis: Barrabás, o Jesús hual quitocayaltilo Cristo? ");
INSERT INTO nclNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Yojque quinlajlanic, pampa yihual quimatic pampa cataya pampa moxiculoaya pampa moxtin quixtocaloaya Jesús huan pampa inon quitemacaje yihual. ");
INSERT INTO nclNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Huan quiman molalijtataya Pilato pa iicpali capa molaliaya quiman quichíac ilachihualisli se laꞌajuani, quinahuatilic lajtol isihua, quilic: “Amo xicpía nindeno pa tiquitas ca in lacal cuali, pampa pa layúa nipanuaya lacocolisli pampa nilajtemiquic inahuac yihual.” ");
INSERT INTO nclNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ma yoje, quinchihualtije in tiopistas huejué huan in huejueyenten pa in míac lacalera molajlanilisi pa quinmacahuilis Barrabás huan pa latilanis pa quimictisi Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Oc sejpa quinnotzac Pilato in gobernador, quinlajlanic: —¿Calía innojen omenten anquinequi pa annimitzmacahuilis? Quilije: —Barrabás. ");
INSERT INTO nclNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Cuaquín Pilato quinlajlanic: —Huan ¿len nicchihuilis Jesús hual quitocayaltilo Cristo? Moxtin quinanquilije: —¡Xicpilu pan se cuahuil! ");
INSERT INTO nclNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato quinmilic: —Axan, ¿len amo cuali quichíac? Ma yoje, yehuanten oc sejpa quitzajtzilije: —¡Xicpilu pan se cuahuil! ");
INSERT INTO nclNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Yoje Pilato quitac pampa amo mopaquiltilosquiaya in míac lacalera, huan neli quinequiloaya majcoquilo pa moanalosquiaya. Pampa inon latilanic pa quihualiquililosquiaya al huan mopaquilic imajmajuan inminyampa in míac lacalera, quijtuc: —Ma camo nechtexpahuili amaqui quiman quimictisi in lacal. Xiquijnamiquican inon amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Huan moxtin quinanquilije: —¡Ma techtexpahuilican iesli tehuanten huan toxolomes pampa ticmictic! ");
INSERT INTO nclNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Cuaquinon Pilato quinmacahuilic Barrabás, huan latilanic pa iguaches quihuijuitequisi Jesús. Cuaquinon quitemacac pa quipilusi pan se cuahuil. ");
INSERT INTO nclNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Huan iguaches in gobernador quihuicaje Jesús calijtic icali cualtichin Pilato, icali itocaya Pretorio. Quinnechicuje mochi in míac guaches pa quiyahualusi Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Quiquixtilije itzotzomajli huan quilaquentije ca se nahuas morado. ");
INSERT INTO nclNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Quijquitequije se yahuali lachihuali ca huizli huan quilajlalilije ipan itzontecon, huan quilalije se ojlal pa imajma cuali. Cuaquinon quimolancuacuetzilije ilaixpan huan quihuitzquilije quijtutataloaya: —¡Ma yuli inminhué in judíos! ");
INSERT INTO nclNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Noje quichijchaje, huan quiquitzquilije in ojlal huan quitecuaje pa itzontecon. ");
INSERT INTO nclNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Lamije quihuitzquilije yoje, quiquijquixtilije in nahuas huan quilaquentije ca itzotzomajli yihual, cuaquinon quihuicaje pa quipilulosquiaya pan in cuahuil. ");
INSERT INTO nclNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Huan quiman quisaje, quitaje se lacal cireneteco itocaya Simón. In se quilamamiltiloaya ca in cuahuil calica yahuiloaya quipilulo Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Yojque ajsije pa se lajcotiyan itoca Golgotá. Quinequi quijtúa in lajtol “Cuajtecomal”. ");
INSERT INTO nclNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nepa quinequije cuniltije iayo uva lanipanuli ca se altzindi chichic. Quiman quichichinac Jesús amo quinequic cunic. ");
INSERT INTO nclNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Quiman lamije quipiluje pan in cuahuil, moxiluilije in guaches ca yehuanten itzotzomajli Jesús, quilastataloaya cuajtzindis cuixtitos. Huan quiman in guache moquixtilic se cuajtzindi capa quilasaje, sinda in cuajtzindi cataya iyaxca hual quilalic pa in se itzotzomajli, yoje yihual canac in se itzotzomajli Jesús. Yojque lamic mochíac len quijcuiluc Dios ilajtuni pin iamal Dios, quijtuc: “Moxiluilije notzotzomajli ca yehuanten quinlastataloaya cuajtzindis cuijcuixtic.” ");
INSERT INTO nclNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Cuaquinon molalije huan mocahuaje quiztataloaya. ");
INSERT INTO nclNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Huan quisaluje ca pani pa itzontecon se amal capa quijcuiluje pa len yihual cataya lapiluli pan in cuahuil. Quijtuc: “IN UNCA JESÚS INMINHUÉ IN JUDÍOS.” ");
INSERT INTO nclNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Noje cataloaya ome laxtequinijmes hual quinpiluje ca Jesús, se cataya pa ima cuali huan in oc se pa ima amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Huan yehuanten hual panujtataloaya quihuejuecaltiloaya, quinhuixujtataloaya inmintzontecon. ");
INSERT INTO nclNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Quilije: —Tel hual ticxitinis in tiopan hué huan quiman lamisi panusi ye tonalijmes ticchías oc sejpa, ximoquixti pan mopolehuilisli. Sinda tehual tiunca ixól Dios, xitemu capa tiunca pan in cuahuil. ");
INSERT INTO nclNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Yojque quihuitzquilije noje in tiopistas huejué huan inminhuejueyenten in judíos huan ilamaxtinijmes in lajtol huan in fariseos, moilije: ");
INSERT INTO nclNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Oc sequin quinquixtic pan inminpolehuilisli. Ma yoje, yihual ihuían amo huil moquixtía pan ipolehuilisli. Sinda yihual ihué Israel, ma temu axan capa unca pan in cuahuil huan ticneltocasi. ");
INSERT INTO nclNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Quilalic ilaneltocalisli ca Dios. Axcan, ma Dios quiquixti de ipolehuilisli sinda neli quinequi, pampa techilic pampa yihual ixól Dios. ");
INSERT INTO nclNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Huan yojque quihuejuecaltije innojen laxtequinijmes noje hual ca yihual cataloaya lapiluli pan cuahuimes. ");
INSERT INTO nclNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Cuaquín lacualispan laticumactic pa mochi in lalticpan, huan mocajtiahuiaya laticumac pa quiman ajsic in ye horas pa tiolac. ");
INSERT INTO nclNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Huan quinami pa ye horas pa tiolac Jesús tzajtzic ca lajtol chicahuac, quijtuc: —¡Elí, Elí! ¿Lama sabactani? —hual quinequi quijtúa: ¡NoDios, noDios! ¿Leca tichcajcahuac? ");
INSERT INTO nclNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Quiman quicaquije inon sequin hual nepa moqueztataloaya, quijtuje: —In se quinoztica Elías ilajtuni Dios. ");
INSERT INTO nclNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jan ajnaxcan molaluc se ca yehuanten huan canac se pochinquil hual quiquixtilo pin al huejcalan, quitechcuniltic ca iayo uva xocuc, quilalic pan se acal huan quilalic pa icamac Jesús pa quilauniltisquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Huan quijtuje in oc sequin: —Xijcahua, ma tiquitacan sinda hualas Elías pa quiquixtis pin polehuilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Cuaquín tzajtzic Jesús oc sejpa ca lajtol chicahuac, huan miquic, quitemacatica iyulilisli. ");
INSERT INTO nclNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Huan ca inon, xiquita, tzayanic in tzotzomajli telahuac hual pilujtataya pin tiopan hué lajco pin lasojli calijtic huan in niman lasojli calijtic. Tzayanic pa pani mochi pa latzindan, mocahuac ome lajcomes. Laulinic huan lapanije in teles. ");
INSERT INTO nclNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Huan cataloaya lalapuli in coyunquimes capa Dios ilacames huejueyenten hual miquije pa yina. Pehualoaya yulilo oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Huan quiman Jesús yulic oc sejpa, yehuanten quisaje pa inmincoyunquimes huan calaquije Jerusalén in lasojli caltilan. Nepa míac quinmitaje. ");
INSERT INTO nclNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Inminlaicanani in guaches huan yehuanten hual mocahualoaya quiztataloaya Jesús pan in cuahuil, quiman quitaje in laulinilisli huan innojen oc sequin hual panujtataloaya, cuaquín momajtije míac, huan quijtuje: —Neli in se yec ixolol Dios. ");
INSERT INTO nclNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Huan nepa cataloaya míac sihuames quilachixtataloaya huejca. Yehuanten quitocaje Jesús quitequipanuilijtiahuiloaya quiman quisaya pa Galilea. ");
INSERT INTO nclNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Cataloaya ca in sihuames María Magdalena huan María inminantzin Jacobo huan José, huan noje cataya nepa inminantzin ixolomes Zebedeo. ");
INSERT INTO nclNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Quiman yahuiaya layuajti, hualac se lacal hual quipiaya míac hual iyaxca, motocaya José, yuliaya pin caltilan Arimatea. In José noje yec se imonextilini Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yihual uyac quitac Pilato, quilajlanic pa quitemacasquiaya icuerpo (inacayo) imijquil Jesús. Cuaquinon Pilato latilanic pa quitemacasi. ");
INSERT INTO nclNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","José canac in cuerpo, quiliaruc ca se tzotzomajli chipahuac. ");
INSERT INTO nclNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Cuaquín quilalic pa se coyunquil yancuic quinami se cueva (ostul) hual yihual pa quimaniyan latilanic pa quihuajuanililosquiaya pin tel. Cuaquinon quitzacuac in lalapulisli ca se tel niman hué quinami se yahualujquil, cuaquín uyac. ");
INSERT INTO nclNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Huan cataloaya nepa María Magdalena huan in oc se María yehuatataloaya ilaixpan in ostul. ");
INSERT INTO nclNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mostatica hual cataya in tonali hual quitocac itonali in lachijchihualisli pa in fiesta (ilhuil), monechicultije in tiopistas huejué huan in fariseos huan uyaje quitaje Pilato. ");
INSERT INTO nclNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Quilije: —Tata Lahuelitini, tiquijnamiquilo quinami in islacatini quijtuc quiman ayamo miquic, quil, “Panusi ye tonalijmes, huan niyulis oc sejpa.” ");
INSERT INTO nclNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Pampín, xilatilani pa quilachiasi in cueva capa unca in mijquil pa quiman lamisi panusi ye tonalijmes. Inon xicchía pa camo cuajnesi hualasi imonextilinijmes huan quixtequisi in mijquil huan cuaquín quinmilisi lacames: “Yulic oc sejpa, axan yajmo mictica.” Yojque, in lacuajcuamanalisli calica laquisasi cayas niman hué, huan yajmo cayas yoje hué in lacuajcuamanalisli hual quijtuc yihual quiman pehuac lacuajcuamanac. ");
INSERT INTO nclNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Quinmilic Pilato: —Nepa anquipía guaches pa lachiasi. Xiacan, xinapachican quinami cuali anquimati anquichía pa mocahuas latzacuali. ");
INSERT INTO nclNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Yoje uyaje yehuanten huan quitzacuaje cuali in cueva (ostul) quilalijticate se latzacualoni lachihuali ca cera pani in tel capa quitzactataya ilalapulisli in ostul. In latzacualoni cataya iyaxca ilahueliltilisli romano. Cuaquinon uyaje quincajtataloaya nepa in guaches pa lachialosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Cuaquín quiman panuc in tonali quiman mosehuilo in judíos huan lanesiaya pan tonali hual quinpehualtía in chicome tonalijmes yajyancuic, uyaje María Magdalena huan in oc se María pa quitasi in ostul (cueva). ");
INSERT INTO nclNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Huan jan ajnaxcan laulinic chicahuac. In panuc pampa temujtihualac se ilanahuatini in Tata pin cielo. Ajsic pa in cueva, quijcuanic in tel hual quitzacuac ilalapulisli in cueva huan molalic ipan. ");
INSERT INTO nclNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Laixpelaya in lanahuatini quinami se lapelanilisli huan itzotzomajli laixpelaya iztatataya quinami tesihuil. ");
INSERT INTO nclNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Quitaje in guaches, niman momajtije, yuyucaje huan mocahuaje quinami mijquimes, yoje míac quimacajsije. ");
INSERT INTO nclNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Cuaquinon quinmilic in sihuames in ilanahuatini in cielo: —Amo ximomajtican. Nicmati pampa anquitemujtica Jesús hual quipiluje pani in cuahuil. ");
INSERT INTO nclNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Amo unca nican pampa yulic oc sejpa, jan quinami anmitzilic. Xihualacan pa anquitas capa quilalije, capa lastataya. ");
INSERT INTO nclNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Axcan, xiajtiquisacan, xiquinmilican imonextilinijmes pampa yultica oc sejpa, mas que quimictije. Axan quisac capa cate in mijquimes. Huan xiquitacan. Yahui anmitzlaicana amhuanten pa Galilea, nepa anquitas. Axan annimitzilic inon. ");
INSERT INTO nclNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Cuaquinon quicajtiquisaje in cueva (ostul) in sihuames momajtitataloaya, huan ma yoje quipialoaya míac paquilisli. Molalujtiaje pa quinlamachiltilosquiaya in monextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Huan quiman molalujtiahuiloaya, xiquitacan, quinnamiquic Jesús pan ojli huan yihual quinpialtic. Cuaquín yehuanten in sihuames hualaje ca yihual, quimolancuacuetzilije quinquitzquitataloaya icxihuajmes huan quinnapalujtataloaya icxihuajmes. ");
INSERT INTO nclNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Huan Jesús quinmilic: —Amo ximomajtican. Ximohuicacan xiquinlamachiltican nocnían pa yasi pa Galilea, huan umpa nechitasi. ");
INSERT INTO nclNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Yajtiahuiloaya in sihuames, sequin innojen guaches uyaje pa Jerusalén, quinlamachiltije in tiopistas huejué mochi in hual quinpanuc. ");
INSERT INTO nclNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Cuaquín in tiopistas quinmonechicultije inminhuejueyenten in judíos pa mochihuilisi se lajtulisli. Molaquetzililoaya huan quiman molalilije ca se lajtulisli, quinmacaje míac tomin in guaches. ");
INSERT INTO nclNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Quinmilije: —Amhuanten xiquinmilican moxtin pampa quema, hualaje imonextilinijmes pa layúa, quixtequije in mijquil quiman tehuanten ticoxtataloaya. ");
INSERT INTO nclNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Huan sinda quicaquis inon in gobernador, cuaquín tehuanten ticyonlalisi pa quineltocas len tiquilisi, huan amhuanten amo anmitztexpahuilis. ");
INSERT INTO nclNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Cuaquinon canaje in guaches in tomin huan quichihuaje quinami in tiopistas quinmilic. Huan yoje quijtutihualaje axan in judíos jan quinami quinlaquetzilije inon in guaches huan in tiopistas. ");
INSERT INTO nclNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Uyaje in once monextilinijmes pa Galilea pa in loma (tepetzindi) capa quinnahuatic Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Huan quiman quitaje, quimolancuacuetzilije. Ma yoje, sequin quimahuililoaya da amo neli cataya yihual. ");
INSERT INTO nclNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Cuaquinon ajsic Jesús capa yehuanten, quinmilic: —Nehual nechtemacac Dios mochi lahueliltilisli pin cielo huan pan lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Pampín, xiacan capa moxtin in lacames pa mochi in lalimes pin lalticpan, xiquinchihuilican pa mochihuasi nomonextilinijmes. Xiquincuayatequican ca inminlahueliltilisli Dios in Tajtzin huan Dios in Xolol huan Dios in Espíritu Santo. ");
INSERT INTO nclNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Huan xiquinmaxtican pa quineltocasi mochi in hual annimitzmaxtic amhuanten. Huan xiquitacan. Nehual nicayas ca amhuanten mojmosta pa quiman ajsis in tonali hual lamis in lalticpan ca ilahueliltilisli hual axan huelitía. Yoje ma ye.");
INSERT INTO nclNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yoje pehuac ilamachiltilisli cuali Jesucristo iXolol Dios. ");
INSERT INTO nclNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Pehuac quinami quijcuiluc Isaías ilajtuni Dios, quijcuiluc inon hual Dios quilic Jesucristo quiman ayamo cataya pan lalticpan, quilic: Xiquita, nehual nictilanía nolanahuatini pa mitzlaicanas pa mijchijchihuilis moꞌojli. ");
INSERT INTO nclNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mocaquis nolanahuatini itzajtzilisli tzajtzitica nepa capa amaqui chanti, quijtutica: “Huala toTata. Xicchijchihuacan anmoyolo anquiquixtilijtica mochi hual quijlacujtica. Xicchijchihuacan quinami anquichijchihuilía ojli quiman huala se hué. Xicmelahuacan anmoyolo quinami quimelahualosquiaya iojli se hué.” ");
INSERT INTO nclNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Huan yoje hualac Juan Lacuayatequini, hualac capa amaqui chantiaya, quijtuaya Dios ilanahuatilisli. Quinmiliaya lacames huan sihuames pa mocuayatequilosquiaya pa yoje lanextililosquiaya quinami axan quipalaje inminyolo pa pehualosquiaya laijnamiqui quinami Dios quinequi. Yoje Dios quinpujpuhuilisquiaya yehuanten inminlaijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Quisaloaya moxtin pin lalticpan motocaya Judea pa quicaquisi. Quisaloaya noje yehuanten pin caltilan (pueblo) hué itoca Jerusalén. Quincuayatequiaya Juan pin atenco hué itoca Jordán quiman moyolcuitiloaya ca Dios inminlaijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Huan quipiaya Juan itzotzomajli lachihuali ca itojmiyo camello. Quipiaya ilacuejtiloni de cuilaxli. Inon hual quicuaya cataya chapulimes huan néculi hual canalo pa cuajlan. ");
INSERT INTO nclNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Quinnotzaya in lacames huan sihuames, quinmilijtataya Dios ilanahuatilisli. Quinmiliaya: —Nilaquisas nehual ca nolanotzalisli, cuaquín hualas se hual quipías niman míac chicahualisli hual nehual amo nicpía. Pampín amo nimonotza pa nimopachus pa nictomilis ilacsames huan pa nictequipanuilis jan nadita. ");
INSERT INTO nclNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nehual annimitzcuayatequía ca al. Yihual anmitzcuayatequis ca in Espíritu Santo. ");
INSERT INTO nclNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","In tonalijmes quisac Jesús pin cali itoca Nazaret hual unca pin lalticpan Galilea. Uyac pa atenco hué itoca Jordán, huan nepa Juan quicuayatequic pin atenco hué. ");
INSERT INTO nclNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Quisac Jesús pin al, huan jan ajnaxcan quitac molapuc chicahuac in cielo (ilhuicac), quitac temujtihualaya in Espíritu Santo chicuenta se huilol huan moquetzac pani yihual. ");
INSERT INTO nclNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Huan mocaquic ilajtol Dios lajtutica pin cielo (ilhuicac), quijtuaya: —Tehual tinoxolol. Nimitzlasojla huan nicpía míac paquilisli ca tehual. ");
INSERT INTO nclNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Cuaquinon jan ajnaxcan in Espíritu quichihualtic pa yahuisquiaya Jesús ca capic amaqui chantiaya. ");
INSERT INTO nclNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Huan nepa mocahuac cuarenta (ompuhuali) tonalijmes. Nepa cataya Satanás, quinequiaya quitilanilía Jesús iyolo pa quichiasquiaya Jesús len hual quitzacuasquiaya Dios. Noje umpa ca Jesús cataloaya in yulijquimes hual yulilo pa cuajlan. Huan hualaje Dios ilanahuatinijmes in cielo (ilhuicac) huan quitequipanuililoaya. ");
INSERT INTO nclNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Se tonali quitzacuaje Juan Lacuayatequini pin calijtic. In tonali hual quichihuilije inon Juan, Jesús uyac pan lalticpan motocaya Galilea. Quinnotzaya in lacalera, quinmilijtataya Dios ilanahuatilisli hual unca in lamachiltilisli cuali inahuac quinami Dios huelitía. ");
INSERT INTO nclNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Quijtuaya: —Axan ajsic in tonali, amo huejcahuas in tonali quiman Dios yahui huelitía. Xicpalacan anmoyolo pa anpehuas anyultías anlaijnamictica quinami Dios quinequi. Xicneltocacan Dios ilamachiltilisli cuali. ");
INSERT INTO nclNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Umpa panuaya Jesús inahuac in al huejcalan itoca Lago de Galilea. Nepa quinmitac Simón huan icni Andrés, quilastataloaya inminlatzojuini lajco pin al huejcalan. Quintemuloaya michimes pampa yehuanten micheros. ");
INSERT INTO nclNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Quinmilic Jesús: —Xichtocacan nehual. Annimitznextilis quinami huil anquintemus lacames quinami axan anquintemúa michimes. ");
INSERT INTO nclNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Jan ajnaxcan quincahuaje inminlatzojuinijmes, quitocatiaje Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Panuc Jesús nadita huejquita de umpa huan quinmitac Jacobo huan icni Juan, yehuanten ixolomes Zebedeo. Ca oc sequin cataloaya yehuanten pin barquito, quinpantitataloaya inminlatzojuinijmes yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jan ajnaxcan quinnotzac Jesús. Cuaquín yehuanten quincajcahuaje pin barquito laijtic inmintajtzin huan ilapalehuinijmes huan quitocatiaje Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ajsije pin cali motocaya Capernaum. Cuaquinon pin tonali hual mosehuilo yehuanten in israelitos hual noje motocalo in judíos, calaquic Jesús pa inmintiopan in judíos, nepa lamaxtiaya. ");
INSERT INTO nclNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Lamaxtiaya ca chicahualisli quinami se hué. Amo lamaxtiaya yihual quinami yehuanten in ilamaxtinijmes in lajtol. Quimaxtiaya in lajtol hual quineltocalo in judíos quinami quipialo pa quimolancuacuetzilisi Dios. Pampín molapolultiloaya pampa lamaxtiaya yoje Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Huan jan axcan cataya pin tiopan se lacal quipiaya se ijyecal hual quichijtataya catzahuac in lacal pa iyolo. ");
INSERT INTO nclNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Tzajtzic in se, quilic: —¿Len ticpía pa tiquitas ca tehuanten, Jesús hual tiquisac pin caltilan Nazaret? ¿Tihualac pa titechlamis? Nicmati aqui tehual. Tehual Dios ilacal chipahuac, Dios mitzlalic pa ticnextis Dios ichipahualisli. ");
INSERT INTO nclNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Cuaquín Jesús quinotzac chicahuac in ijyecal, quilic: —¡Amo xinahuati huan xiquisa capa yihual! ");
INSERT INTO nclNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Cuaquín in ijyecal catzahuac quiyuyucaltic chicahuac in lacal, tzajtzic chicahuac huan quisac pin lacal. ");
INSERT INTO nclNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Huan umpa moxtin molapolultiloaya míac, moililoaya: —¿Len inon? ¡Se lamaxtilisli yancuic! ¡Yihual quinnotza in ijyecames, quichía quinami se hué hual quipía chicahualisli! ¡Huan quineltocalo! ");
INSERT INTO nclNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jan ajnaxcan moxtin quipuhualoaya pa mochi in lali Galilea in hual quichihuilic Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Cuaquín quisaje pin tiopan. Umpa mohuicac Jesús, huan ca yihual uyaje Jacobo huan Juan. Uyaje pa inminchan Simón huan Andrés. ");
INSERT INTO nclNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Huan inantzin isihua Simón lastataya pa ilapexli, quipiaya totonalisli. Jan ajnaxcan quilamachiltije Jesús pampa cataya cocoxqui yihual. ");
INSERT INTO nclNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Cuaquín ajsitíac capa yihual Jesús, quiquitzquic imajma, cajcoquic pin lapexli, quiquetzac. Yoje pajtic in sihual, yajmo quipiaya totonalisli. Cuaquín quinlacualtiaya. ");
INSERT INTO nclNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Calaquic in tonali, huan layuajtitataya. Quihualiquilije Jesús moxtin in cocoxquimes huan yehuanten hual quinpialoaya ijyecames amo cuajcuali. ");
INSERT INTO nclNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Huan moxtin motojpehuaje pa in cali ilalapujquil. ");
INSERT INTO nclNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Quinpajtic Jesús míac hual mococuloaya ca míac cocolisli. Quinquixtiliaya yehuanten míac ijyecames amo cuajcuali. Ma yoje, amo quinmacahuiltic Jesús pa lajtulosquiaya in ijyecames pampa quimatiloaya aqui yihual. ");
INSERT INTO nclNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pa cualcan quiman ayamo lanestihualaya huan cataya laticumac, moquetzac Jesús. Quisac pa quiahuac in caltilan, uyac capa amaqui cataya, nepa huan Dios lajtuloaya. ");
INSERT INTO nclNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón ca oc sequin hual cataloaya ca yihual uyaje quitemuje. ");
INSERT INTO nclNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Quitaje, quinmilije: —Moxtin mitztemujticate. ");
INSERT INTO nclNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesús quinmilic: —Ma tiacan pa oc sequin caltilan pa nilanoztinemis. Umpa noje niquinmilis Dios ilamachiltilisli. Pampa inon niquisac pin cali. ");
INSERT INTO nclNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yoje quinmilijtinemiaya Dios ilamachiltilisli pa in judíos inmintiopajmes pa mochi in lalticpan Galilea. Noje quinquixtiliaya ijyecames amo cuajcuali hual quinquitzquiloaya lacames. ");
INSERT INTO nclNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ajsic capa Jesús se lacal, quilajlanic pa quicnilisquiaya huan pa quipajtisquiaya. Quipiaya in icocolisli icuilaxli itoca lepra. Quimolancuacuetzilic Jesús, quilic: —Sinda ticnequi, huil tichpajtis. ");
INSERT INTO nclNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús quicnilic cualantica pampa quipiaya in cocolisli huan quimatocac ca imajma, quilic: —Nicnequi pa tipajtis. Xipajti. ");
INSERT INTO nclNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jan ajnaxcan yajmo nesic icocolisli in lacal, yoje pajtic. ");
INSERT INTO nclNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Cuaquinon Jesús quinahuatic ca míac chicahualisli huan quitilanic pa iojli yihual, quilijtataya: ");
INSERT INTO nclNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Xiquita. Ximoiztía pa camo tiquilis amaqui nindeno. Jan xía ximonextili in tiopista. Axcan tichipahuac. Xiquihuica pa in tiopan in huendi hual quinahuatic Moisés pa quimacas aqui yes hual quipiaya in cocolisli huan pajtic. Yoje lacames quimatisi pampa tipajtic tel. ");
INSERT INTO nclNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ma yoje, quisac in lacal huan pehuac quinpuhuilic moxtin len quipanuc yihual. Pampín Jesús yajmo huil calaquiaya pan se caltilan sinda lacames quimatiloaya yihual cataya nepa. Yoje mocahuaya pa quiahuac capa amaqui chantiaya. Huan yahuiloaya quitalo lacames, quisaloaya pa mochi caltilan cajcapa. ");
INSERT INTO nclNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Panuje sequin tonalijmes, huan mocuepac Jesús oc sejpa pin caltilan Capernaum. Momachiltije in lacalera pampa yihual cataya pa ichan. ");
INSERT INTO nclNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Pampín monechiculoaya míac huan yoje yajmo quinmajsiaya ilalapujquil in cali capa Jesús quinmaxtiaya ilajtol Dios. ");
INSERT INTO nclNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Cuaquinon hualaje sequin quihualicatataloaya se lacal cocoxqui, amo huil moliniaya. Quimantihualaloaya pan ipelal telahuac nahui lacames. ");
INSERT INTO nclNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Huan amo huil cajxiltiloaya in lacal calijtic capa Jesús pampa cataloaya míac pin cali calijtic huan pa quiahuac. Cuaquín quilapuje ca pani in cali capa cataya Jesús. Quitemuhuije in cocoxqui pan ipelal pa calijtic capa in coyunquil. ");
INSERT INTO nclNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesús quitac quinami quineltocaloaya pampa yihual huil quipajtisquiaya, quilic in cocoxqui: —Nito, axan lapujpuhuali unca molaijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Huan sequin lacames lamaxtinijmes hual quimaxtiloaya in lajtol inahuac quinami quimolancuacuetzililo Dios in judíos nepa molalijtataloaya. Moilije ca inminyolo: ");
INSERT INTO nclNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Leca lajtúa yojque in se? Quihuejuecaltitica Dios. ¿Aqui huil quipujpuhuilía se lacal ilaijlaculisli? Dios yihual san huil quichihuilía inon.” ");
INSERT INTO nclNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Quimatic Jesús ca iyolo in hual yehuanten quijtuloaya ca inminyolo in lamaxtinijmes huan quinmilic: —¿Leca anlajtúa yoje ca anmoyolo? ");
INSERT INTO nclNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Neli unca anquita quinami amo quinextilía nochicahualisli sinda niquilía in cocoxqui: “Axan unca lapujpuhuali molaijlaculisli.” Ma yoje, sinda niquiliaya: “Ximoquetza, xicajcoqui mocochiyan huan xinejnemi”, huan yihual pajtiaya, cuaquín anquimatiaya pampa quinextiliaya nochicahualisli. Huan sinda niquiliaya inon huan yihual amo pajtiaya, cuaquín anquimatiaya pampa amo nicpía ilahueliltilisli Dios. ");
INSERT INTO nclNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Axan, nicnequi pa anquimatis pampa nehual ilacal in cielo, quema, nicpía ilahueliltilisli Dios pa niquinpujpuhuilis lacames inminlaijlaculisli. Cuaquinon Jesús quiztataya in lacal hual amo huil moliniaya, quilic: ");
INSERT INTO nclNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Ximoquetza, xicajcoqui mocochiyan huan xía pa mochan. ");
INSERT INTO nclNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Huan moquetzac in lacal jan ajnaxcan huan cajcoquic icochiyan huan quisac inminlaixpan moxtin. Pampín moxtin moitaloaya ca lamajtilisli huan quinmijtuloaya lajtomes huejué pa Dios. Quililoaya: —Amo quiman tiquitaje len quinami inon. ");
INSERT INTO nclNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Quisac Jesús oc sejpa pa itenco in al huejcalan. Moxtin hualaje capa yihual huan yihual quinmaxtiaya. ");
INSERT INTO nclNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Umpa je nadita quiman panujtataya pa iojli, quitac ixolol Alfeo motocaya Leví. Molaliaya pin cali capa quilajlaniloaya lapixcalisli hual yec pa tomin, quinlaxlahuiloaya ca in tomin in romanos hual huelitiloaya. Jesús quilic: —Xichtoca nehual. Yoje, moquetzac Leví, huan Jesús uyaje. ");
INSERT INTO nclNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Quiman panuc inon lacuajtataya Jesús pa ichan Leví. Ca Jesús huan imonextilinijmes lacuajtataloaya míac oc sequin hual quitocaje Jesús. Sequin yeje lacames hual quilajlaniloaya lapixcalisli hual yec ca tomin (contribuciones). Oc sequin yeje lacames hual amo quineltocaloaya cuali inminlajtol in judíos hual quijtúa quinami monequi pa se quimolancuacuetzilis Dios. ");
INSERT INTO nclNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Huan quitaloaya Jesús ilamaxtinijmes in lajtol huan sequin hual quineltocaloaya inminlamaxtilisli in fariseos. Quitaloaya quinami lacuajtataloaya ca Jesús moxtin yehuanten. Huan in lamaxtinijmes quinnotzaje Jesús imonextilinijmes, quinmilije: —¿Leca molalía anmolamaxtini pa lacuas huan pa launis ca lacames amo cuajcuali huan ca yehuanten hual quilajlanilo lapixcalisli hual unca tomin pa in romanos? ");
INSERT INTO nclNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Quicaquic inon, Jesús quinmilic: —Amo quinnequilo lapajtinijmes yehuanten hual amo cojcocoxqui. In cojcocoxqui, quema, quinnequilo. Yojque nehual amo nihualaya pa niquinnotzas yehuanten hual quijtulo pa inminyolo: “Nel nicuali.” Nihualaya pa niquinnotzas pa nechtocasi yehuanten hual quimatilo pampa cate laijlaculi. ");
INSERT INTO nclNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Se tonali mosajtataloaya imonextilinijmes Juan Lacuayatequini huan inminmonextilinijmes in fariseos. Sequin lacames hualaje capa Jesús, quilajlanije inahuac inon, quilije: —¿Leca mosahualo inminmonextilinijmes Juan huan in fariseos? Tehual momonextilinijmes amo mosahualo. ");
INSERT INTO nclNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús quinnanquilic: —Amo monequi pa mosahuasi ilajlasojli se lacal hual yahui monamictía sinda cate ca yihual in tonalijmes quiman monamictitica. Huan yoje amo mosahualo nomonextilinijmes innojen tonalijmes hual cate ca nehual. ");
INSERT INTO nclNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ma yoje, ajsilo tonalijmes capa quinquixtilisi nehual hual niunca quinami in se hual yahui monamictía. Cuaquín mosahuasi. ");
INSERT INTO nclNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Umpa pehuaya quinmaxti quinami inon hual yihual quinmaxtitataya cataya lamaxtilisli yancuic. Quinmilic: —Amaqui quipantía je tzotzomajli hual moviejojtic ca se dango yancuic. Sinda quipantía yoje, cuaquín in dango yancuic quicololúa ca in tzotzomajli hual moviejojtic huan quitzayana oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Noje amaqui quilalía iayo uva yancuic laijtic pin pocuinijmes lachihuali ca cuilaxli hual itequi quitequipanuje. Sinda yoje quichía, cuaquín iayo uva yancuic quitzayanaltis in cuilaxli pampa amo huil motilana. Toyahuis iayo uva, moijlacus in cuilaxli. Pampín monequi pa quilalis iayo uva yancuic pin pocuinijmes lachihuali ca cuilaxli yancuic. ");
INSERT INTO nclNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Se tonali nejnentiyahuiaya Jesús capa moscaltitataya trigo. Cataya in tonali hual mosehuilo in judíos. Pehuaje quincopintiaje imiahuimes trigo imonextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Cuaquinon in fariseos quilije: —Xiquita. ¿Leca quichihualo momonextilinijmes inon? Tolajtol hual techilía quinami monequi pa se quimolancuacuetzilis Dios amo quimacahuiltía pa quichías se inon pan tonali quiman timosehuilo tehuanten. ");
INSERT INTO nclNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesús quinmilic: —¿Amo quiman anmomaxtic len quichíac David in hué pan se tonali pa yina? Yihual huan yehuanten hual quitocaloaya mayanaloaya. ");
INSERT INTO nclNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Yoje calaquic pin tiopan hué calijtic, cataya nepa Abiatar in tiopista hué. Quincuac David in panes hual quilalilo in tiopistas ilaixpan Dios. Huan in lajtol quimacahuiltía pa quincuasi in panes jan in tiopistas san. Ma yoje, David quinmacac pa quincuasi in lacames hual cataloaya ca yihual. Huan amo quichihuaya David laijlaculisli mas que quichíac inon. ");
INSERT INTO nclNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Huan noje quinmilic: —Dios quilalic pa cayas se tonali capa huil anmosehuis. Quichíac inon pa anmijchihuilis len cuali amhuanten. Dios amo quinchíac lacames pa yoje quinchihualtis pa mosehuisi pan in tonali quiman mosehuilo. ");
INSERT INTO nclNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Pampín, nehual ilacal in cielo nicpía lahueliltilisli pa nicnahuatis len huil quichihuasi lacames pan in tonali capa mosehuilo. ");
INSERT INTO nclNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Oc sejpa calaquic Jesús calijtic pa inmintiopan in judíos. Nepa cataya se lacal quipiaya se ima huaquic. ");
INSERT INTO nclNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Quinapachiloaya Jesús in lacames nepa pa quitasi sinda lapajtisquiaya pan tonali quiman mosehuilo pampa quinequiloaya motexpahuilo ca yihual. ");
INSERT INTO nclNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Cuaquín Jesús quinotzac in lacal, quilic: —Xihuá, ximoquetza lajco ca tehuanten capa ticate. ");
INSERT INTO nclNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jesús quinlajlanic, quinmilic: —¿Calía unca cuali? ¿Unca cuali sinda ticchihualo cuali pan in tonali capa timosehuilo? ¿Unca cuali sinda ticchihualo amo cuali? ¿Unca cuali sinda quipalehuilo pa yulis se lacal? ¿Unca cuali sinda quimictilo? Yehuanten amo nahuatije. ");
INSERT INTO nclNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Quicocuc iyolo Jesús, quinmitac cualantataya pampa amo quinequiloaya quimatilo. Cuaquín quilic in lacal: —Xicxilani momajma. Quixilanic huan pajtic imajma. ");
INSERT INTO nclNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Cuaquín quisaje in fariseos huan jan ajnaxcan ca yehuanten hual quitocaloaya Herodes laquetzaje. Quinequiloaya quimatilo quinami huil quimomictiluililosquiaya Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Quisac Jesús pa in al huejcalan pin lalticpan Galilea. Quitocaje míac yehuanten hual chantiloaya pa Galilea. ");
INSERT INTO nclNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Noje hualaje míac hual chantiloaya pin lalticpan Judea huan pin caltilan hué Jerusalén huan pin lalticpan Idumea. Noje hualaje quistataloaya pa yoje itenco (analco) in atenco hué Jordán huan pa in lali itejtenco in caltilan hué Tiro huan in caltilan hué Sidón. Yaje quitaje Jesús quiman quimatije pampa quinchihuaya innojen lachihualisli. ");
INSERT INTO nclNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Pampa inon Jesús quinmilic imonextilinijmes pa quipiasi lalalili se barquito capa yihual pa huil calaquis, pampa cuajnesi in míac lacalera yahuiloaya quitojpehualo. ");
INSERT INTO nclNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Quinpajtic míac hual cataloaya ca yehuanten. Pampín mochi cocoxquimes motojpejtiahuiloaya pa quimatocalosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Huan quiman in ijyecames amo cuajcuali quitaloaya Jesús, cuaquín quinmayahuiloaya ilaixpan yihual in lacames hual quinpiaje laijtic yehuanten, tzajtziloaya, quilije: —¡Tehual tiꞌixolol Dios! ");
INSERT INTO nclNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Huan yihual quinmajuac chicahuac pa camo quijtusi aqui yihual. ");
INSERT INTO nclNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Panuc inon, Jesús panquisac pin pani, quinnotzac yehuanten hual quinequiaya quinlajtulti. Yehuanten moxiluje ca in lacalera, ajsitihualaje capa yihual. ");
INSERT INTO nclNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Quinlajtultic doce (majlaclihuanome) ca yehuanten pa cayasi ca yihual. Yahuiaya quintilani pa quinmilijtinemisi lacames ilamachiltilisli. ");
INSERT INTO nclNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Noje quinmacac lahueliltilisli pa huil quinpajtisi yehuanten huan pa huil quinquixtilisi ijyecames amo cuajcuali. ");
INSERT INTO nclNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Quinlajtultic doce lacames. Se yec Simón hual noje quitocayaltic Pedro. ");
INSERT INTO nclNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Oc sequin yeje Jacobo huan icni Juan, yehuanten ixolomes Zebedeo. Jesús quintocayaltic yehuanten Boanerges. Inon quinequi quijtúa pampa yehuanten cataloaya lacames quinami comunilisli. ");
INSERT INTO nclNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","In oc sequin cataloaya Andrés huan Felipe huan Bartolomé huan Mateo huan Tomás huan Jacobo ixolol Alfeo, huan Tadeo huan Simón hual yec se ca in lanechiculisli motocaya cananistas. ");
INSERT INTO nclNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Huan noje quilajtultic Judas Iscariote hual se tonali yahuiaya quitemaca Jesús ca yehuanten hual yahuiloaya quimictilo. Cuaquinon ca imonextilinijmes calaquije pan se cali. ");
INSERT INTO nclNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Oc sejpa monechicuje míac lacalera huan pampín amo huil quicualoaya nadita Jesús huan imonextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Huan quiman quicaquije yehuanten hual iyaxca Jesús, quisaje pa quisehuiltisi, pampa quijtuloaya: —Axan mopoluc ilaijnamiquilisli. ");
INSERT INTO nclNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Sequin ca in lamaxtinijmes hualaje, quisaje pin caltilan hué Jerusalén, quijtuloaya: —Quipía laijtic yihual in ijyecal itoca Beelzebú. Yihual inminhué in ijyecames amo cuajcuali. Ca ilahueliltilisli Beelzebú quinquixtilía lacames in ijyecames hual quinpialo laijtic yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Cuaquinon Jesús quinnotzac, quinlaquetzilic se lapuhualisli calica yehuanten quimatilosquiaya cuali len quinequiaya quijtu, quinmilic: —¿Quinami huil yihual Satanás moquixtía pa quiahuac sinda unca laijtic se? ");
INSERT INTO nclNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Sinda momijmictitinemilo in lacames pa se lali, cuaquín ilahueliltilisli in lali amo huejcahuas. ");
INSERT INTO nclNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Huan sinda yehuanten hual chantilo pan se cali moxilulo cualanticate huan mocualantitinemilo, cuaquín yajmo quiman monechicusi pa chantisi pan in se cali. ");
INSERT INTO nclNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Huan jan yoje, sinda Satanás huan iijyecames mocualantitinemilo huan yoje moxilulo, cuaquín yajmo huil huejcahuas Satanás, lamis ilahueliltilisli. ");
INSERT INTO nclNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Amaqui huil calaqui icali se lacal chicác pa quixtequilis len quipía sinda ayamo quilpic in lacal chicác. Cuaquín, quiman unca lailpili, huil calaqui pa quiquixtilis mochi hual cayas calijtic. ");
INSERT INTO nclNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Annimitzilía neli, Dios quinpujpuhuilis in lacames mochi in laijlaculisli huan mochi inminlahuejuecaltilisli hual quijtulo. ");
INSERT INTO nclNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ma yoje, Dios amo quiman quipujpuhuas aqui hual quihuejuecaltía in Espíritu Santo. Huejcahuas pa yes in laijlaculisli, amo quiman lamis. ");
INSERT INTO nclNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Quinmilic Jesús inon pampa in lamaxtinijmes quijtuloaya: —Yihual quipía ijyecal catzahuac. ");
INSERT INTO nclNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Cuaquinon hualaje inantzin huan icnían, mocahuaje pa quiahuac, quitilanije lajtol pa quilisi Jesús pampa quinequiloaya quitalo yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yehuanten hual molalijtataloaya inahuac Jesús quilije: —Monantzin huan mocnían umpa cate pa quiahuac mitztemujticate pa mitzitasi. ");
INSERT INTO nclNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesús quinnanquilic: —¿Aqui nonantzin? ¿Aquinojen nocnían? ");
INSERT INTO nclNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Quinmitac yehuanten hual molaliloaya quiyahualujtataloaya, quijtuc: —Nican cate nonantzin huan nocnían. ");
INSERT INTO nclNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Aqui hual quichías quinami quinequi Dios, yihual nocni lacal huan nocni sihual huan nonantzin. ");
INSERT INTO nclNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Oc sejpa pehuac lamaxtic Jesús pa itenco in al huejcalan, huan hualaje quitaje míac lacalera. Pampín calaquic pan se barquito pani pin al huejcalan. Nepa molalic, huan mocahuaje in lacalera pa itenco in al huejcalan. ");
INSERT INTO nclNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Quinmaxtiaya míac pan ipampa lapuhualisli hual quinlatiliaya ilamaxtilisli, huan amo ca lajtol calica huil quimatiloaya len quinequiaya quijtu. Quinmaxtiaya quinmilijtataya: ");
INSERT INTO nclNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Xilacaquican: Se lacal quisac pa quixinis latocli. ");
INSERT INTO nclNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Laxintíac, laxintíac huan sequin latocli huetzije ipan itenco in ojli. Hualaje in tutomes, quicuaje. ");
INSERT INTO nclNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Oc sequin latocli huetzije pan tixcaltilan capa amo cataya lali telahuac. Innojen huejcahuac jan nadita huan ixuaje pampa amo cataya lali telahuac. ");
INSERT INTO nclNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Quisac in tonali, quinhuactic in pacholimes pampa amo quipialoaya lalhuayol. ");
INSERT INTO nclNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Oc sequin pan huiztilan huetzije. Moscaltije in huizli, quinmictije in pacholimes, yoje amo laquije in latocli. ");
INSERT INTO nclNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Oc sequin latocli huetzije ipan lali cuali. Ixuaje, moscaltije, quilalije ilaquilyo. Sequin latocli quilalije treinta (sempuhualihuanmajlacli) ca mochi sejse latocli, oc sequin sesenta (yepuhuali) ca mochi sejse latocli, oc sequin cien (macuilipuhuali). ");
INSERT INTO nclNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Cuaquinon Jesús quinmilic: —Aqui quipía inacas, ma quicaqui. ");
INSERT INTO nclNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Lamic quinmaxtic yoje, mocahuac Jesús ihuían. Cuaquinon yehuanten hual mocahuaje capa yihual quilajlanije, quilije: —¿Len quinequi quijtúa in lapuhualisli calica tilamaxtiaya? ");
INSERT INTO nclNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Quinmilic: —Amhuanten anmitzmachiltitica Dios len oc sequin amo quimatilo. Anmitzmachiltitica quinami yihual huelitía pan mochi lalticpan. Huan yehuanten hual amo cate ca tehuanten, yihual quinmachiltía mochi pan ipampa lapuhualisli hual quinlatilía ilamaxtilisli, pa yoje ");
INSERT INTO nclNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","mas que lachiasi, amo quitasi. Huan yoje, mas que lacaquisi, amo quimatisi len quinequi quijtúa. Inon quinpanúa pa yoje amo mopalasi yehuanten pa inminyolo huan pa yoje Dios amo quinpujpuhuilis inminlaijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Huan quinmilic: —¿Amo anquimati len quinequi quijtúa in lapuhualisli? Cuaquín ¿quinami anquimatis len quinequilo quijtulo mochi lapuhualisli? ");
INSERT INTO nclNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","In lacal hual laxintíac, yihual quinami se hual quinmilía Dios ilamachiltilisli. ");
INSERT INTO nclNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Sequin lacames cate quinami in latocli hual huetzije inahuac in ojli. Quicaquilo Dios ilamachiltilisli, jan ajnaxcan huala Satanás, quinmijcuanilía in lacames Dios ilamachiltilisli hual quixinic in lacal pa inminyolo yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Oc sequin cate quinami in latocli hual quixintíac pin tixcaltilan. Quicaquilo in lajtol, pehualo quineltocalo ca paquilisli. ");
INSERT INTO nclNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ma yoje, Dios ilajtol amo calaquic cuali pa inminyolo yehuanten huan pampín amo huejcahualo pa quineltocasi. Huan yojque jan ajnaxcan in tonali hual quinpanulo lacocoltilisli huan quiman quintojtocalo in lacames pampa quineltocalo Dios ilamachiltilisli cuali, cuaquín yajmo quinequilo quineltocalo. Cate quinami in pacholimes hual amo quipialo lalhuayol, huejcahualo je nadita san. ");
INSERT INTO nclNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","In latocli hual cataya laxinili pin huiztilan, in quinami aquinojen noje quicaquilo Dios ilanahuatilisli. ");
INSERT INTO nclNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ma yoje, amo mocahualo pa quijnamiquisi in míac hual cate pin lalticpan hual quinequilo canalo. Canalo tomin calica mocuajcuamanalo, mocuhuilijticate inon hual quinchihuilía amo cuali. Quinequilo míac len yes huan yoje mochi inon quinmijlacúa lacames pa inminyolo. Quinequilo quilcahualo Dios ilajtol, huan mochihualo quinami cuahuimes hual amo laquilo. Dios ilajtol amo quinpalehuía. ");
INSERT INTO nclNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Huan in latocli hual cataya laxinili pan lali cuali, inon quinami yehuanten hual quicaquilo in lamachiltilisli cuali huan quineltocalo. Cuaquinon Dios ilamachiltilisli quinchihualtía cuali. Yulilo quichijticate quinami Dios quinequi, sequin niman míac, oc sequin amo yoje míac, cate quinami latocli, sequin quilaquiltilo treinta latocli pan se miahuil, sequin sesenta pan se miahuil huan sequin cien latocli pan se miahuil. ");
INSERT INTO nclNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Noje quinmilic: —¿Cuajnesi quihualicalo se tapalquita calica lahuilo pa quilalisi itzindan se tapalcal o itzindan se lapexli? ¿Amo quilalilo capa quinlahuis moxtin? ");
INSERT INTO nclNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yoje, len yes hual unca lalatili, unca yoje pa moitilis se tonali. Huan len yes hual amaqui quimati, unca yoje pa yoje se tonali quimatisi. ");
INSERT INTO nclNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Aqui quipía inacas pa lacaquis, ma lacaqui. ");
INSERT INTO nclNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Noje quinmilic: —Xiquijnamictiacan inon hual anquicaqui. San quinami anlaijnamictía, yoje anquimatis inon hual quinequi quijtúa. Huan yoje, jan quinami anquimaca, san yoje anyahui anquipía. Huan anyahui anquipía míac hual amo anpehuac anquipíac amhuanten hual anlacaqui cuali. ");
INSERT INTO nclNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Aqui quipía, yihual yahui cana míac hual ayamo quipiaya. Aqui amo quipía, yihual quiquixtilisi in nadita hual quipía. ");
INSERT INTO nclNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Noje quijtuaya: —Yoje unca quinami huelitía Dios. Unca quinami se lacal hual quixini latocli. ");
INSERT INTO nclNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Quiman unca laxinili, in lacal cochi pa layúa, moqueztinemi semilhuil. Ixuatía in latocli huan moscaltitía huan amo quimati in lacal quinami mochía. ");
INSERT INTO nclNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mochía pan ipampa in lali ihuían. Pehua ca nesi isacayo, cuaquín in miahuil, huan umpa monextilo in latocli pin miahuil. ");
INSERT INTO nclNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Cuaquín cate yujyucsic in latocli, huan quisalo in lacames pa quitequisi, pampa ajsic in tonali pa lapixcasi. ");
INSERT INTO nclNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Noje Jesús quijtuc: —¿Quinami len huil tiquijtulo in unca quinami Dios huelitía? ¿Len lajtomes tiquijtusi pa ticnextilisi quinami unca? ");
INSERT INTO nclNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Unca quinami se latocli mostaza. Quitocalo pin lali in niman tipichin ca mochi latocli hual quitocalo pin lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ma yoje, quiman unca latocali, ixua huan moscaltía hué quinami amo cate yoje huejué in oc sequin pacholimes. Itzmolinía, itzmolinía huan in tutomes huil quinchihualo inminchan pa ilasehuán (ilasehuayan) in laitzmolinilisli. ");
INSERT INTO nclNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Huan quinmilic Jesús ilamaxtilisli ca míac lapuhualisli quinami innojen. Quinmilic ilamaxtilisli quinami huil quicaquije. ");
INSERT INTO nclNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Amo quinmilic nindeno sinda amo quinmilic ca lapuhualisli calica quinlatilic ilamaxtilisli, jan yoje quinmilic. Ma yoje quiman cataya ihuían ca imonextilinijmes, quinmilic len quinequiloaya quijtulo mochi ilapuhualisli. ");
INSERT INTO nclNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","In tonali nepa quiman layuajtitataya, Jesús quinmilic: —Ma ticpanahuican in al huejcalan ca yoje itenco. ");
INSERT INTO nclNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Cuaquinon yehuanten quinmilije pa mohuicasi in míac lacalera huan imonextilinijmes Jesús quihuicaje pin barquito capa cataya. Noje ca yehuanten inminbarquito uyaje oc sequin barquitos. ");
INSERT INTO nclNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Umpa ca se nadita pehuac ijyecac chicahuac. Majcoquiaya in al huan calaquiaya pin barquito, huan yoje tentataya ca al. ");
INSERT INTO nclNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Huan Jesús coxtataya pin barquito itenco, mocuajtontitataya ca se xotopa yamanquil. Yehuanten quejxiltije, quitzajtzilije: —¡Lamaxtini! ¿Amo timomajtía pampa tipolejticate? ");
INSERT INTO nclNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Cuaquinon ejsac, moquetzac, cajuac in ijyecal huan quilic in al huejcalan: —¡Ximocahua, ximosehui! Huan mosehuic in ijyecal, in al yajmo majcoquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Cuaquín Jesús quinmilic: —¿Leca anquimacajsía? ¿Ayamo anquilalía laneltocalisli ca nehual? ");
INSERT INTO nclNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Momajtiloaya yehuanten míac, moilijtataloaya se huan oc se: —¿Aqui yes in lacal hual quineltocalo in ijyecal huan in al huejcalan? ");
INSERT INTO nclNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ajsije ca yoje itenco (analco) in al huejcalan pa in lali itocac Gadara. ");
INSERT INTO nclNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Quisac Jesús pin barquito laijtic. Hualac capa yihual quistihualaya se lacal capa quinlalpachulo mijquimes, quinamictihualac Jesús in lacal quipixtataya ijyecal amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Chantiaya in lacal pin ostumes (cuevas) capa quinlalpachulo mijquimes. Amaqui huil quilpiaya, quema, amo huil quilpiloaya ca teposli. ");
INSERT INTO nclNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Pan míac tonalijmes quilpinijme ca teposli pa icxihuajmes huan ca teposli pa imajmajuan. Ma yoje yihual quipostequini sequin teposlimes huan quicojcotonani oc sequin teposlimes huan moxtin momajtiloaya pa quiquitzquilosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Amo mocahuaya pa tzajtzitinemisquiaya ca semilhuil huan ca layúa pin tepetzindis (lomas) huan capa quinlalpachuje in mijquimes. Noje motecuatinemiaya ca tixcalimes. ");
INSERT INTO nclNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Quitac pa huejquita Jesús, molalujtihualac, quimolancuacuetzilic, tzajtzic chicahuac. ");
INSERT INTO nclNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Huan quilic: —¿Len ticpía ca nehual, Jesús, tel ixól Dios in niman hué? ¡Nimitzilía pa tichilis ilaixpan Dios pampa amo tichcocoltis! ");
INSERT INTO nclNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Quilic inon pampa Jesús quilic: —¡Ijyecal, xiquisa laijtic in lacal! ");
INSERT INTO nclNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesús quilajlanic, quilic: —¿Quinami timotoca? Quinanquilic: —Cate míac notocajmes pampa ticate míac ijyecames. ");
INSERT INTO nclNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","In lacal quitemachic Jesús míac pa camo quitilanis pa quiahuac in lali. ");
INSERT INTO nclNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Umpa cataya se lanechiculisli ca míac coyamimes (cuchis) lacuajtataloaya pa itepotzcon se loma (tepetzindi). ");
INSERT INTO nclNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Huan quitemachije in ijyecames Jesús, quilije: —Xitechtilani pin coyamimes, ma ticalaquican laijtic yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Cuaquinon Jesús quinmacahuiltic huan quistiaje in ijyecames laijtic in lacal. Calaquije ca laijtic in coyamimes, cataloaya quinami dos mil (macuilitzondi). Cuaquín yehuanten molasaje pa temuán (temuayan) pa itepotzcon in loma, molasaje pin al huejcalan, moatoctije. ");
INSERT INTO nclNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Yehuanten hual quinmitaloaya in coyamimes choluje huan quinlamachiltije yehuanten pin caltilan huan pa itenco in caltilan len panuc. Pampín quistihualaje moxtin pa quitasi len panuc. ");
INSERT INTO nclNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ajsije capa Jesús, quitaje in lacal hual quiquitzquinijme in ijyecames. Nepa molalijtataya huan axan cataya lalaquentili. Quipiaya noje mochi ilaijnamiquilisli cuali. Pampín yehuanten hual chantiloaya pin caltilan momajmajtije. ");
INSERT INTO nclNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Huan aquinojen quitaje len quipanuc in lacal hual quiquitzquinijme in ijyecames quinpuhuilije yehuanten quinami cataya, quinpuhuilije len quinpanuc in coyamimes. ");
INSERT INTO nclNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Cuaquinon pehuaje quitemachije Jesús míac pa yihual mohuicas pa inminlali. ");
INSERT INTO nclNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yoje calaquic Jesús pin barquito. Huan in lacal hual quiquitzquinijme in ijyecames quitemachic ca iyolo pa Jesús quihuicasquiaya ca yihual. ");
INSERT INTO nclNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ma yoje, Jesús amo quimacahuiltic. Quilic: —Xía pa mochan huan mocnían pa oc sequin calimes, xiquinpuhuili quinami in Tata mijchihuilic míac hual huejué, huan quinami yihual mitzicnilic. ");
INSERT INTO nclNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Cuaquín uyac in lacal, pehuac lapuhuac pin lali capa cataloaya in Majlacli Cajcaltilan (Diez Pueblos). Quinlaquetziliaya moxtin lacames mochi hual Jesús quichihuilic. Huan moxtin molapolultije. ");
INSERT INTO nclNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Huan Jesús mocuepac oc sejpa pin barquito ca yoje (analco) in al huejcalan, ca imonextilinijmes mocuepac. Ajsije umpa, monechicuje míac lacames huan sihuames capa yihual cataya pa itenco in al huejcalan. ");
INSERT INTO nclNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Cuaquinon hualac ca yihual se lacal motocaya Jairo, yihual se hué pa in tiopan. Quitac Jesús, quimolancuacuetzilic capa icxían. ");
INSERT INTO nclNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Quitemachiaya míac, quilic: —Noxól muachita axan mictía. Xihuá, xiquinlali momajma pan capa yihual pa pajtis huan yulis. ");
INSERT INTO nclNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ca Jairo uyac, huan quitocaloaya Jesús míac lacalera, quitojpejtiahuiloaya. ");
INSERT INTO nclNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Huan cataya nepa se sihual cocoxqui, mococuni ca eslera hual quisaya pa icuerpo, quipiaya doce xixihuil. ");
INSERT INTO nclNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Panuc míac lacocoltilisli ca len quichihuilije míac lapajtinijmes. Quilamic mochi itomin huan amo quipalehuic nindeno, amo pajtic san nadita. Jan yoje mococujtiahuiaya míac, amo yoje cataya quiman pehuac mococuc. ");
INSERT INTO nclNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Huan quimatic len quijtutinemiloaya quinami huil lapajtiaya Jesús. Pampín hualac ca in lacalera, ajsic itepotzcon Jesús, quimatoquilic inahuas. ");
INSERT INTO nclNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Inon quichíac pampa quijtuaya laijtic yihual: “Sinda nicmatoquilis jan inahuas san, cuaquín nipajtis.” ");
INSERT INTO nclNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Huan jan ajnaxcan mosehuic iquisalisli eslera. Quimatic laijtic icuerpo pampa axan pajtic. ");
INSERT INTO nclNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesús jan ajnaxcan quimatic laijtic yihual pampa quisac pa yihual oc sejpa ilahueliltilisli pa lapajtis. Momalinac, quinmitac in míac lacalera, quinmilic: —¿Aqui nechmatocac? ");
INSERT INTO nclNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Imonextilinijmes quilije: —¿Leca tilajlanic: “Aqui nechmatocac”? Tiquiztica quinami in míac lacalera ajsitialo monahuac. ");
INSERT INTO nclNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ma yoje, yihual mocahuac lachixtataya cajcapa pa quitas aqui quichihuilic inon. ");
INSERT INTO nclNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Cuaquín in sihual momajtic yuyucatataya. Huan quinami quimatic len panuc laijtic icuerpo, hualac, quimolancuacuetzilic ilaixpan Jesús, quilic mochi in hual quipanuc. ");
INSERT INTO nclNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Huan Jesús quilic: —Nito, axan tipajtic pampa ticlalic molaneltocalisli ca nehual. Ximohuica axan ca paquilisli huan ma yajmo mitzcocúa mococolisli. ");
INSERT INTO nclNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ayamo lamiaya lajtu Jesús, huan hualaje yehuanten hual cataloaya pa ichan ihué in tiopan. Quilije: —Lamic polehuic moxolol, ¿pa len ticmaca tequil in lamaxtini? ");
INSERT INTO nclNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Quicaquic Jesús in hual quilije, huan quilic ihué in tiopan: —Amo ximomajti, xiclali laneltocalisli ca nehual san. ");
INSERT INTO nclNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Huan amo quinmacahuiltic moxtin pa yalosquiaya ca yihual, jan Pedro huan Jacobo huan Juan icni Jacobo, yehuanten san. ");
INSERT INTO nclNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ajsije pa ichan in hué lacal. Quitac Jesús quinami quichihualoaya míac xahuanilisli, chocatataloaya huan tzajtzitataloaya. ");
INSERT INTO nclNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Calaquic huan quinmilic: —¿Leca anchocatica? Huan ¿leca anxahuantica? Amo polehuic in muachita, jan coxtica. ");
INSERT INTO nclNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yehuanten quihuitzquilije san. Cuaquinon Jesús quinquixtic moxtin pa quiahuac. Quinhuicac itajtzin huan inantzin huan yehuanten hual ca yihual hualaloaya, calaquije capa cataya in muachita (ichpocal o piltondi). ");
INSERT INTO nclNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Quiquitzquic imajma in muachita, quilic ca ilajtol: —Talita, cumi —hual quinequi quijtúa: Muachita, nimitzilía, ximoquetza. ");
INSERT INTO nclNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jan ajnaxcan in muachita hual quipiaya doce xixihuil moquetzac, huan pehuac nejnemic. Pampa inon molapolultiloaya míac yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ma yoje, quinmilic Jesús chicahuac: —Amo xicmachiltican amaqui len panuc. Quinmilic noje pa quilacualtilosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Mohuicac Jesús umpa, mocuepac pa ilali capa moscaltic, uyac ca imonextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","In tonali hual mosehuilo in judíos pehuac lamaxtic pa inmintiopan, huan in míac hual quicactataloaya mocahualoaya moizticate, moilije: —¿Capa monextilic in se mochi in hual techilijtica? ¿Len in lajmatilisli hual quipía? Huan quinchía innojen hual techlapolultilo. ");
INSERT INTO nclNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Amo in se in carpintero, amo yihual ixól María, huan amo icnían Jacobo huan José huan Judas huan Simón? Quema, yihual. Huan icnían sihuames, yehuanten cate nican ca tehuanten. Huan quixijxicuje, cualanije ca yihual. ");
INSERT INTO nclNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Huan Jesús quinmilic: —Lacames quimatilo momajtilo ilaixpan se ilajtuni Dios. Jan yehuanten san pa ilali huan icnían pa oc sequin calimes huan yehuanten pa ichan, innojen amo quipililo lamajtilisli ilaixpan. ");
INSERT INTO nclNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Huan nepa amo huil quichíac len hual lanextilisquiaya quinami yihual quipía Dios ilahueliltilisli. Jan quinlalilic imajmajuan pan sequin naditas cocoxquimes huan quinpajtic. ");
INSERT INTO nclNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Huan molapolultiaya Jesús pampa yehuanten amo quinequiloaya quineltocalo yihual. Huan quisac nepa Nazaret, yajtiahuiaya pan sequin caltilan tijtipichin amo huejca, nejnepa lamaxtiaya. ");
INSERT INTO nclNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Cuaquín quinnotzac in doce imonextilinijmes ca yihual huan pehuac quintilanic pa yahuilosquiaya ojꞌome. Quinmacac lahueliltilisli pa quinquixtilisi lacames huan sihuames ijyecames amo cuajcuali. ");
INSERT INTO nclNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Quinnahuatic pa camo quihuicalosquiaya nindeno pa ojli, jan se cuajtzindi san pa mopalehuisi pa nejnemisi. Huan amo quinmacahuiltic pa quihuicalosquiaya xotopa huan len quicualosquiaya huan tomin pa inminpaxajmes. ");
INSERT INTO nclNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Noje quinmilic pa molalililosquiaya jan lacsames san, huan quinmilic pa molaquentilosquiaya ca in tzotzomajli calica mojmosta molaquentiloaya huan ca se cotón san. ");
INSERT INTO nclNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Quinmilic: —Capa yes ancalaquis se cali, nepa xicayacan pa mochi tonalijmes ancayas pin caltilan. ");
INSERT INTO nclNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Sinda yehuanten pin caltilan amo anmitznamiquisi huan amo quinequisi anmitzcaquisi, cuaquín in tonali anquisas umpa, ximotzejtzeluilican in lalpotocli hual unca pa anmolacsames. Yoje quimatisi quinami quichihuilijticate Dios len amo cuali. Annimitzilía neli, pa in tonali Dios quintilanis iyampa yihual yehuanten pin lalticpan, yehuanten pa in caltilan yalo panulo míac lacocoltilisli. Amo yoje míac panusi lacocoltilisli yehuanten de in caltilan Sodoma huan in caltilan Gomorra. ");
INSERT INTO nclNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yoje quisaje in doce imonextilinijmes quinmililoaya in judíos Jesús ilamachiltilisli pa quipalasi inminyolo pa yulisi quinami Dios quinequi. ");
INSERT INTO nclNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Noje quinquixtililoaya yehuanten míac ijyecames amo cuajcuali, quinxahuililoaya míac cocoxquimes ca chahuac huan quinpajtiloaya. ");
INSERT INTO nclNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","In hué itocac Herodes quimatic len quichihuaya Jesús, pampa moxtin molaquetzililoaya inahuac yihual. Sequin quijtuloaya Jesús cataya Juan Lacuayatequini hual mocuepac yulic mas que quimictije. ");
INSERT INTO nclNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Oc sequin quijtuloaya: —Yihual Elías, hual yec ilajtuni Dios pa yina. Huan oc sequin quijtuloaya: —Yihual se ca ilajtunijmes Dios hual yulinijme pa yina. ");
INSERT INTO nclNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Quiman quicaquiaya inon Herodes, quijtuc: —In se unca Juan. Nilatilanic pa quicotonilisi iquixlan. Unca yihual hual axan yuli oc sejpa, quisac pa capa cate in mijquimes. ");
INSERT INTO nclNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Yoje quijtuc Herodes pampa quinpíac sequin mesli, yihual latilanic pa quiquitzquilosquiaya Juan pa quicalactilosquiaya pin calijtic. ");
INSERT INTO nclNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Inon cataya pampa Juan sejpa huan oc sejpa quilic Herodes: —Dios ilajtol quijtúa pampa amo unca moyaxca pa ticanas isihua mocni. Juan quilic inon pampa Herodes canac Herodías hual yec isihua Felipe huan Felipe yec icni Herodes. ");
INSERT INTO nclNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Huan Herodías amo mocahuac cualanic ca Juan. Quinequiaya quimicti, huan amo huil. ");
INSERT INTO nclNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Amo huil quimictic pampa Herodes quimatiaya momajti ilaixpan Juan. Quimatiaya pampa Juan yec lacal cuali hual quipiaya iyolo chipahuac. Pampa inon Herodes amo quimacahuiltiaya pa Herodías quichihuilisquiaya nindeno Juan. Herodes quicaquic quilaquetzilic Juan Dios ilajtol, huan mas que quimacajsiaya in hual quiliaya Juan, ma yoje quixtocaya quicaqui. ");
INSERT INTO nclNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Cuaquinon, ajsic se tonali quiman Herodías quitac quinami quimomictiluilisquiaya Juan. Pan in tonali quichijtataloaya ilhuil (fiesta) pampa in tonali monamiquic ca in tonali hual lacatic Herodes. Herodes quinnotzac pa lacuasi in huejueyenten huan in laicananijmes huan mochi yehuanten huejueyenten pin lalticpan Galilea. ");
INSERT INTO nclNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Lacuajtataloaya, calaquic Herodías ixolol sihual, pehuac mijtotic. Yoje quinmacac paquilisli Herodes huan yehuanten hual ca yihual cataloaya. Pampa in, Herodes quilic in sihual: —Xichtemachi len ticnequis huan nel nimitzmacas. ");
INSERT INTO nclNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Quilic inon ca lajtol hual amo mopala, quilic: —Len yes tichtemachis nimitzmacas, quema, sinda tichtemachis lajco in lali capa nihuelitía. ");
INSERT INTO nclNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Quisac in sihual yancuic, quilic inantzin: —¿Len nictemachis? Huan inantzin quinanquilic: —Itzontecon Juan Lacuayatequini. ");
INSERT INTO nclNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mocuectiquisac in sihual yancuic capa cataya Herodes, quilic: —Nicnequi pa tichmacas jan ajnaxcan itzontecon Juan Lacuayatequini pan se tapalcal xalapa. ");
INSERT INTO nclNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Cuaquinon quicocuc iyolo in hué. Ma yoje, amo quinequiaya quipala in lajtol hual yihual quilic, pampa quijtuc ca lajtol hual amo mopala, huan quicaquije yehuanten hual nepa cataloaya ca yihual. ");
INSERT INTO nclNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Yoje, quitilanic se guache quilijtataya pa quihualiquilis Juan itzontecon. ");
INSERT INTO nclNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Uyac in guache pa in calijtic capa cataya Juan, quicotonilic iquixlan, quihualicac itzontecon Juan pan se tapalcal xalapa. Quimacac in sihual yancuic, huan yihual quihuiquilic inantzin. ");
INSERT INTO nclNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Quimatije inon imonextilinijmes Juan, uyaje canaje icuerpo (inacayo), quilalpachuje. ");
INSERT INTO nclNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yehuanten doce imonextilinijmes Jesús monechicuje oc sejpa capa cataya Jesús, quilije mochi hual quichihuaje. Quilije noje len quinmaxtije yehuanten pa innojen míac caltilan. ");
INSERT INTO nclNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Cuaquín Jesús quinmilic: —Ma tiacan tohuían pa lajcotiyan capa amaqui unca, nepa timosehuisi je tipichin. Inon quinmilic pampa yahuiloaya huan hualaloaya míac lacames huan sihuames. Pampín amo huil lacuaje Jesús huan imonextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Yoje uyaje ca se barquito ca capic amaqui cataya. ");
INSERT INTO nclNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ma yoje, míac quinmitaje quiman uyaje yehuanten, huan quinmiximatije Jesús huan in doce imonextilinijmes. Pampín quisaje pa mochi caltilan, molalujtiaje ca umpic, ajsije quiman ayamo ajsic Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Cuaquinon, ajsic Jesús, quisac laijtic in barquito, quinmitac míac lacalera. Huan quinpiliaya laicnililisli yehuanten pampa cataloaya quinami borregos hual amaqui quinmiztataya. Cuaquín pehuaya quinmaxti míac. ");
INSERT INTO nclNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Quiman tiolactic, hualaje imonextilinijmes capa yihual, quilije: —Axan tiolactic, ca niquic amaqui chanti. ");
INSERT INTO nclNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Xiquintilani pa yasi pa innojen caltilan itenco nican huan pin caltilan tijtipichin pa mocuhuilisi len quicuasi. ");
INSERT INTO nclNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yihual quinnanquilic: —Amhuanten xiquinlacualtican. Quinanquilije: —¿Tiasi tijcuhuasi pan ca ome cientos denarios tomin pa tiquinlacualtisi? ");
INSERT INTO nclNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús quinlajlanic: —¿Quichi panes anquinpía? Xiacan xiquitacan. Quimatije quichi, cuaquín quilije: —Macuili, huan ome michimes. ");
INSERT INTO nclNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Cuaquinon quinmilic in lacalera pa mosehuisi sejsequin nican, sejsequin nepa pani pin sacal xuxuctic. ");
INSERT INTO nclNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Yoje moxiluje yehuanten huan molalije ca míac lanechiculisli, sequin ca cien, oc sequin ca cincuenta lacames. ");
INSERT INTO nclNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Huan Jesús quinmanac in macuili panes huan in ome michimes, lachíac pa pani pin cielo, quisehuic Dios pampa in hual yahuiloaya quicualo. Cuaquinon quinxiluilic in panes, quinmacac imonextilinijmes pa quinlalilisi inminlaixpan moxtin. Noje quinxiluilic in ome michimes pa moxtin. ");
INSERT INTO nclNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Yoje moxtin lacuaje huan pachihuije. ");
INSERT INTO nclNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Cuaquín quinpejpenaje mochi in pan lapanali huan in michimes hual amo quicuaje, quintemiltije doce chiquihuimes ca innojen. ");
INSERT INTO nclNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Cataloaya macuili mil lacames hual quicuaje in panes. ");
INSERT INTO nclNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jan axcan Jesús quinmilic imonextilinijmes pa lejcusi pin barquito, quinmilic pa quilaicanasi yihual pa Betsaida hual cataya pa yoje (analco) in al huejcalan. Huan yihual mocahuaya pa quinmilis in lacalera huan sihualera pa mohuicasi pa inminchan, quinchicahuaya. ");
INSERT INTO nclNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Quiman quintilanic moxtin, uyac Jesús pin lomas (tepetzindis), umpa quilajlaniaya Dios. ");
INSERT INTO nclNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Cuaquín layuajtic, huan cataya in barquito lajco pin al huejcalan huan mocahuaya Jesús ihuían pan lali. ");
INSERT INTO nclNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Pa cualcan quinmitac Jesús imonextilinijmes siahuiloaya quilanilultitataloaya in barquito ca cuahuimes, pampa quinlaixnamiquiaya in ijyecal chicahuac. Cuaquín ajsitihualaya Jesús nejnentataya pani pin al, yahuiaya quinpanahui. ");
INSERT INTO nclNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Quitaje yihual nejnentihualaya pani pin al, quijtuloaya Jesús yec se lamajtini. ");
INSERT INTO nclNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Pampín tzajtziloaya pampa quitaje moxtin huan quimacajsije. Ma yoje, quinnotzac Jesús, quinmilic: —¡Xicchicahualtican anmoyolo, amo ximomajtican! ¡Nehual niunca! ");
INSERT INTO nclNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Lejcuc pin barquito ca yehuanten, mosehuic in ijyecal. Huan molapolultije imonextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Molapolultije pampa ayamo quimatiloaya quinami panuc nepa capa quinxiluilic Jesús in panes huan in michimes. Amo huil quimatiloaya san quinami míac unca ilahueliltilisli hual quipía Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Quipanahuije in al huejcalan, ajsije pin lali itocaya Genesaret. Quilpije in barquito pa itenco in al huejcalan. ");
INSERT INTO nclNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Quisaje pin barquito huan jan ajnaxcan in lacalera quiximatije, quislacuje Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Cuaquín molalujtinemiloaya moxtin yehuanten umpa, pehuaje quihualicaje in cocoxquimes pan lapexlimes quiman quimatije capa cataya Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Cajcapa yes calaquiaya yihual, sinda pa sequin caltilan tijtipichin o sinda pa sequin caltilan huejué o sinda pa sequin caltilan niman tijtipichin, quinlalije in cojcocoxquimes pin lajcotiyan. Quitemachiloaya Jesús pa yihual quinmacahuiltis pa quimatocasi jan itenco icotón huejcanic san. Huan moxtin hual quimatocaje, yehuanten pajtije. ");
INSERT INTO nclNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Huan quistihualaje Jerusalén fariseos huan sequin inminlamaxtinijmes in judíos, quimaxtiloaya inminlajtol hual quinmilía quinami monequi pa quimolancuacuetzilisi Dios. Yehuanten monechicuje capa cataya Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Quitaje quinami sequin imonextilinijmes lacualoaya ca inminmajmajuan catzahuac, quinequi quijtúa amo lapacali. Huan inminlajtol in judíos quijtúa pampa quema, quipialo pa mochipahuililo inminmajmajuan jan yojque quinami quijtúa in lajtol. Pampín motexpahuiloaya ca Jesús imonextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Motexpahuiloaya pampa in fariseos quichihualo quinami mochi in oc sequin judíos. Amo lacualo sinda amo pehualo ca lapacalisli pan inmajmajuan. Yojque quinmajcoquilo in lachihualisli hual quitemacaje pa yina míac xixihuil inmintajtzitzían. ");
INSERT INTO nclNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Huan sinda yalo pa in lajcotiyan (tianquisli) capa lacuhualo huan lanamacalo, cuaquín quiman mocuepalo, amo lacualo sinda amo pehualo ca lapacalisli pan ipampa lajuichulisli hual quipialo pa quichihuasi jan yoje. Huan cate oc sequin míac lajtomes hual quintemacaje inmintajtzitzían, hual in judíos quipialo pa quineltocasi, quinami innojen: Quipialo pa quinpacasi quinami lacuayatequilisli tapalcames tijtipichin huan tapalcames huejué huan nixcumimes jan yoje quinami quijtúa inminlajtol.) ");
INSERT INTO nclNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Pampín yehuanten in fariseos huan in lamaxtinijmes quilajlanije Jesús, quilije: —¿Leca amo quineltocalo momonextilinijmes inminlajtomes totajtzitzían? Lacualo ca inminmajmajuan amo lachipahuali jan yoje, huan inon amo unca quinami quijtúa tolajtol hual techilía quinami ticmolancuacuetzililo Dios. ");
INSERT INTO nclNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Huan Jesús quinnanquilic: —Isaías ilajtuni Dios quijtuc melahuac anmonahuac amhuanten hual anlajtúa yoje. Ma yoje, amo anquichía yoje quinami anlajtúa. Yihual Isaías quijcuiluc len Dios quijtuc, quilic: Innojen lacames quimatilo nechpililo lamajtilisli san ca inmincamac, huan ca inminyolo amo quiman nechijnamiquilo. ");
INSERT INTO nclNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Jan lapic (de in balde) nechmolancuacuetzililo pampa quinmaxtilo san inminlajtomes lacames. Amo monotza len in lancuacuetzalisli hual nejchihuililo, pampa quinmaxtilo san lacames inminlajtomes. ");
INSERT INTO nclNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Amhuanten anquicahua Dios ilamachiltilisli huan amo quiman anmocahua pa anquichías len anmitznahuatinijme in hual quijcuiluje lacames pa yina, pampa amo anquilcahua pa anquincuayatequis tapalcames huejué huan tijtipichin huan xicalimes. Huan anquinchía oc sequin míac hual anmitztemacanijme lacames. ");
INSERT INTO nclNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Noje quinmilic: —¿Cuajnesi anquichijtica cuali quiman yes anquitojpehua Dios ilamaxtilisli? Anquitojpehua quiman anquichijtías anmolamaxtilisli hual anmitztemacanijme pa yina lacames. ");
INSERT INTO nclNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Amo anquichijtica cuali, pampa Moisés quijtuc: “Xiquinlasojla motajtzin huan monantzin.” Noje quijtuc: “Aqui quihuejuecaltía itajtzin o inantzin, ma ye lamictili.” ");
INSERT INTO nclNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ma yoje, amhuanten anquijtúa pampa sinda se lacal quinmilía itajtzin huan inantzin: “Amo huil annimitzpalehuía ca notomin huan len yes noyaxca, pampa mochi hual noyaxca unca Corbán.” (Corbán quinequi quijtúa pampa quitemacaje Dios.) ");
INSERT INTO nclNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Huan sinda quinmilía yoje, cuaquín amhuanten yajmo anquimacahuiltía pa quinpalehuis itajtzin huan inantzin. ");
INSERT INTO nclNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yoje anquichía. Huan yoje ca amhuanten yajmo monotzas nindeno Dios ilajtol pan ipampa anmolamaxtilisli. In lamaxtilisli anmitztemacanijme pa yina in huejueyenten. Huan amhuanten anquintemacas anmoxolomes in lamaxtilisli. Noje cate míac oc sequin lamaxtilisli quinami innojen hual anquinchía. ");
INSERT INTO nclNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Oc sejpa Jesús quinnotzac in lacames huan sihuames, quinmilic: —Xichcaquican anmoxtin huan xicmatican inon hual nicnequi niquijtúa. ");
INSERT INTO nclNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Amo unca nindeno hual quicuas se hual quijlacus iyolo. Unca inon hual quisa capa iyolo se, quema, in quijlacúa. ");
INSERT INTO nclNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Aqui yes quipía inacas, ma quicaqui inon. ");
INSERT INTO nclNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesús moxilujtíac capa cataloaya in míac lacalera, calaquic pa icali. Quilajlanije imonextilinijmes len quinequiaya quijtu in lapuhualisli calica lamaxtiaya, yojque quinlatilijtataya in lacalera ilamaxtilisli. ");
INSERT INTO nclNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yihual quinmilic: —¿Noje amo anquimati amhuanten len quinequi quijtúa? ¿Amo anquimati pampa mochi hual quicua se amo quijlacus iyolo? ");
INSERT INTO nclNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Amo calaqui pa iyolo, calaqui pa laijtic icuerpo (inacayo), cuaquinon quisa quiman yes yahui sacatilan. Yojque quinequiaya quijtu Jesús pampa mochi pin lalticpan hual quicualo lacames unca cuali pa tijcuasi. ");
INSERT INTO nclNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Noje quinmilic: —Unca in hual quisa capa iyolo se, inon quijlacúa. ");
INSERT INTO nclNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Unca pampa laijtic iyolo se quijtúa len amo cuali. Huan quinami yoje quijtulo lacames pa laijtic inminyolo, monilulo lacames huan sihuames mas que amo monamictije. ");
INSERT INTO nclNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Laxtequilo, lamictilo, canalo oc sequin sihuames hual amo inminsihuahuan, quinequilo hual amo inminyaxca. Quichihualo in amo cuali, lacuajcuamanalo, amo quimatilo pinahualo, quixiculilo oc sequin. Lahuejuecaltilo, amo lalasojlalo, amo quinequilo quimatilo len unca amo cuali pa motzacuilisi pa camo quichihuasi. ");
INSERT INTO nclNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mochi inon quisalo pa laijtic iyolo se huan quijlacúa iyolo. ");
INSERT INTO nclNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Cuaquinon quisac Jesús umpa, uyac capa cataloaya in caltilan hué Tiro huan in caltilan hué Sidón. Nepa pehuac chantic pa se cali. Quinequiaya pa amaqui quimatisquiaya pampa umpa cataya. Ma yoje, amo huil quinmolatiliaya. ");
INSERT INTO nclNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nepa cataya se sihual quipiaya se muachita (ichpocal). In muachita quipiaya se ijyecal amo cuali. Quicaquic in sihual quilaquetzilije quinami huil lapajtía Jesús, huan jan ajnaxcan hualac quitac, quimolancuacuetzilic capa icxían. ");
INSERT INTO nclNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Cataya ilali in sihual in lali Sirofenicia huan lajtuaya griego. Quitemachiaya Jesús pa quiquixtilis in ijyecal imuachita. ");
INSERT INTO nclNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesús quilic: —Ma mopehualti pa in xolomes pachihuisi. Amo unca cuali sinda quiquixtililo in hual quicualo in xolomes pa quilasasi pa quicuasi in pelotzitzindis. ");
INSERT INTO nclNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Huan in sihual quilic: —Jo quema, Tata. Ma yojque itzindan capa lacualo in xolomes in pelotzitzindis quicualo inminlapanajquimes tijtipichin in xolomes hual quinmayahuilo pan lali. ");
INSERT INTO nclNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesús quilic: —Unca cuali in hual tiquijtuc. Pampín, huil timohuica, axan quisac in ijyecal capa moxolol. ");
INSERT INTO nclNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Huan ajsic in sihual pa ichan, quitac in muachita pa ilapexli, quisac capa yihual in ijyecal. ");
INSERT INTO nclNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Quisac Jesús pin lali inahuac Tiro, quipanahuic Sidón, quipanajtíac in lali capa cataloaya in Diez Pueblos (Majlacli Cajcaltilan), huan ajsic pa in al huejcalan itoca Galilea. ");
INSERT INTO nclNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Quihualicaje se lacal panata hual amo huil lajtuaya cuali. Quilije: —Xicnequi xiquinlali momajmajuan capa yihual pa pajtis. ");
INSERT INTO nclNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Cuaquín Jesús huan in lacal panata moxiluje ca capic cataloaya inminhuían. Quinlalic Jesús ixerixajmes pa inacajmes in lacal, lachijchac, quimatocac inejnepil in lacal. ");
INSERT INTO nclNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Cuaquinon lachíac pa pani pin cielo, ijyulantic, quilic: —¡Efata! —hual quinequi quijtúa: ¡Ma molapucan! ");
INSERT INTO nclNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jan ajnaxcan molapuje inacajmes, molinic cuali inejnepil, lajtuc cuali. ");
INSERT INTO nclNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Quinnahuatic Jesús pa camo quilisi amaqui. Ma yoje, mas que míac quinmilic inon oc sejpa huan oc sejpa, jan yoje yehuanten míac, míac quinmilijtinemiloaya oc sequin. ");
INSERT INTO nclNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Huan in lacalera molapolultiloaya niman míac. Quema, amo quiman molapolultije yoje, quijtuloaya: —Yihual quichía cuali mochi. Yehuanten hual panatas quinlacaquiltía, huan aquinojen hual amo lajtulo, yihual quinchihuilía pa lajtusi. ");
INSERT INTO nclNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Innojen tonalijmes monechicuje oc sejpa míac lacames, huan amo quipialoaya len quicualosquiaya. Quinnotzac Jesús imonextilinijmes quinmilic: ");
INSERT INTO nclNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Niquinmicnilía in míac lacalera pampa quipía ye tonali yehuanten cate ca nehual huan axan amo quipialo len quicuasi. ");
INSERT INTO nclNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Sequin hualaje huejca. Sinda niquintilanis ca mayandi pa inminchan, amo quipiasi chicahualisli pa in ojli. ");
INSERT INTO nclNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Quijtuje imonextilinijmes: —¿Quinami huil quinlacualtía se nican? Amaqui chanti ca níc. ");
INSERT INTO nclNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Quilajlanic, quinmilic: —¿Quichi panes anquinpía? Quijtuje: —Chicome. ");
INSERT INTO nclNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Cuaquín Jesús quinmilic pa molalilosquiaya pan lali. Quinmanac in chicome panes, quisehuic Dios. Cuaquinon quinxiluilic, quinmacac imonextilinijmes pa quinlalililosquiaya inminlaixpan yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Quimpialoaya noje sequin michimes tijtipichin. Quisehuic Dios, huan quinmilic noje imonextilinijmes pa quinlalilisi inminlaixpan pa quicualosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Lacuaje huan pachihuije. Cuaquinon quinpejpenaje chicome chiquihuimes tenticate ca lajquitos ca in pan lalapanali hual mocahuaje. ");
INSERT INTO nclNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Yehuanten hual lacuaje cataloaya quinami nahui mil lacames. Cuaquinon quinmilic Jesús pa mohuicalosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Cuaquín, Jesús huan imonextilinijmes calaquije se barquito, uyaje pa in lali motocaya Dalmanuta. ");
INSERT INTO nclNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Hualaje quitaje Jesús sequin fariseos, pehuaje quinlaxilije Jesús lajtomes, quilije: —Timitztemachilo, xicchía len hual technextilis pampa unca iyaxca Dios molahueliltilisli. Cataya pampa yehuanten amo neli quineltocaloaya pampa Dios quitilanic Jesús. Pampín quinequiloaya quichihualtilo se lanextilisli. ");
INSERT INTO nclNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Cuaquín ijyulantic Jesús ca mochi iyolo pampa amo quineltocaloaya huan quinmilic: —¿Leca quitemachilo lacames pa quitasi je lanextilisli pin cielo? Annimitzilía neli, amo nesis se lanextilisli pin cielo pa yehuanten hual yulticate axan. ");
INSERT INTO nclNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Huan quiman quinmilic inon, quincajcahuac, mocuepac calaquic in barquito oc sejpa. Quipanahuiaya ca imonextilinijmes ca yoje (analco) in al huejcalan. ");
INSERT INTO nclNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Huan imonextilinijmes quilcahuaje quihuicaje len pa quicualosquiaya, quipialoaya jan se pan ca yehuanten pin barquito. ");
INSERT INTO nclNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Cuaquín quinmaxtic Jesús ca lajtomes niman pa inminyolo, quinmilic: —Xiquitacan. Ximoitacan pa camo anmocuajcuamanas ca inminlaxocoyajquil in fariseos huan Herodes. ");
INSERT INTO nclNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pehualoaya moililo: —Yihual techilic inon pampa amo ticualicaje len tijcuasi. ");
INSERT INTO nclNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Quimatic Jesús len moililoaya, quinmilic: —¿Leca anmoilía pampa amo anquipía len pa tijcuasi? ¿Ayamo anquilalía pa anmotzontecon huan amo ancajsi pa anmoyolo inon hual nicnequi annimitzmaxtía? ¿Amo anquinequi anquimati len quinequilo quijtulo nolajtomes? ");
INSERT INTO nclNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Anquinpía anmoixtololojmes. ¿Amo anlachía? Anquinpía anmonacajmes. ¿Amo anlacaqui? ¿Amo anquijnamiquía? ");
INSERT INTO nclNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Niquinxiluíc in macuili panes ca in macuili mil lacames. Axan, ¿quichi chiquihuimes ca lajquitos lalapanali anquinnechicuc huan anquintemiltic? Yehuanten quinanquilije: —Doce. ");
INSERT INTO nclNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Huan niquinxiluíc in chicome panes ca in nahui mil lacames. ¿Quichi chiquihuimes anquinnechicuc huan anquintemiltic ca lajquitos lalapanali hual anquinpejpenac? Yehuanten lananquilije: —Chicome. ");
INSERT INTO nclNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Cuaquinon quinlajlanic: —¿Ayamo anquimati len annimitzmaxtitica? Da amo nilaqueztataya inahuac in hual tijcuasi. ");
INSERT INTO nclNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ajsije pin caltilan motocaya Betsaida. Nepa sequin lacames quihualicaje capa Jesús se lacal pachacal, quilajlanije pa quimatocasquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Cuaquín Jesús quiquitzquic ca imajma, quiquixtic in pachacal pa quiahuac in caltilan. Nepa lachijchac capa iixtololojmes pa quinxahuilis ca ilachijchal, quilalilic imajmajuan pani yihual huan quilajlanic: —¿Huil tiquita len? ");
INSERT INTO nclNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Lachíac in pachacal huan quilic: —Niquinmita lacames quinami cuahuimes, huan nejnemilo. ");
INSERT INTO nclNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Cuaquinon Jesús quinlalic oc sejpa imajmajuan capa iixtololojmes in pachacal. Cuaquín momelahuac lachíac, huan axan, quema, lachíac cuali. Pajtije iixtololojmes, mochi huil quitaya. ");
INSERT INTO nclNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Huan Jesús quitilanic pa ichan, quilic: —Amo xicalaqui pin caltilan axan huan amo xiquili amaqui. ");
INSERT INTO nclNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Mohuicaje Jesús huan imonextilinijmes, uyaje pa innojen caltilan hual amo cataya huejca se caltilan motocaya Cesarea Filipo. Huan pa ojli quinlajlanic imonextilinijmes, quinmilic: —¿Len quijtulo lacames pampa aqui nehual? ");
INSERT INTO nclNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Yehuanten quinanquilije: —Sequin quijtulo tel tiJuan Lacuayatequini. Oc sequin quijtulo tel tiElías. Huan oc sequin quijtulo tel tiunca se ilajtunijmes Dios. ");
INSERT INTO nclNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Oc sejpa yihual quinlajlanic: —Amhuanten, ¿len anquijtúa pampa aqui nehual? Pedro quinanquilic: —Tehual tiunca in Cristo hual Dios quitilanic. ");
INSERT INTO nclNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Huan Jesús quinmilic chicahuac pa camo quilisi amaqui inon. ");
INSERT INTO nclNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Pehuac quinmaxtic, quinmilic: —Nehual ilacal in cielo nicpía pa nipanus míac lacocoltilisli. In abuelojmes huan tiopistas huejué huan in lamaxtinijmes nechilisi pampa amo quinequilo pa nicayas ca yehuanten, huan nechmictisi. Huan quiman panusi ye tonalijmes, niyulis oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Inon quinmilic ca lajtol hual quimatije len quinequiaya quijtu. Cuaquinon Pedro quihuicac ca yihual ihuían, pehuac quilic chicahuac pa camo quijtusquiaya pampa yahuiaya miqui. ");
INSERT INTO nclNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ma yoje, momalinac Jesús, quinmitaya imonextilinijmes, cajuac Pedro huan quilic: —¡Ximijcuani nolaixpan! Tilajtutica quinami Satanás. Amo tiquijtúa in hual unca iyaxca Dios, tiquijtúa san in hual quijtulosquiaya lacames. ");
INSERT INTO nclNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Cuaquinon quinnotzac Jesús imonextilinijmes huan in lacalera, quinmilic: —Aqui quinequi nechtocatía pa monextilis quinami nicnequi pa yulis, amo huil quichía quinami yihual quinequi. Quipía pa canas ojli capa yahui panúa lacocoltilisli quinami nehual nipanus lacocoltilisli huan cuaquín nechmictisi pan se cuahuil. ");
INSERT INTO nclNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Monequi pa yes yoje, pampa aqui yes quinequi cajcoquía iyulilisli icuerpo san, yoje yihual quipolus iyulilisli huan mochi. Quema, yihual miquis. Huan aqui momacahuiltis pa quipolus iyulilisli icuerpo pampa unca nomonextilini huan pampa quineltoca in lamachiltilisli cuali, yoje yihual neli cajcoquis iyulilisli. ");
INSERT INTO nclNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Cuajnesi moyaxcajtía se lacal ca mochi in lalticpan. Ma yoje, miquis, quipolus iyulilisli. Cuaquinon, ¿len quipías? ");
INSERT INTO nclNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Len huil quilaxlahuía se lacal pa quipías oc sejpa iyulilisli? Nindeno. ");
INSERT INTO nclNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yehuanten hual axan yulticate quicajcahualo Dios, quintocalo oc sequin dioses, quichihualo laijlaculisli. Huan aqui pinahuas pampa nehual huan nolajtomes, cuaquín nehual ilacal in cielo, nehual noje nipinahuas pampa yihual pa in tonali hual nihualas pa nihuelitis pan lalticpan. Nihualas ca ichicahualisli hué huan ilaixpelalisli cualtichin noTajtzin huan ilanahuatinijmes chijchipahuac pin cielo hual quinpía pa quitequipanuilisi. ");
INSERT INTO nclNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Noje Jesús quinmilic: —Neli annimitzilía, sequin ca yehuanten hual nican cate axan quitasi quinami hualas ilahueliltilisli Dios ca chicahualisli. Quema, yehuanten quitasi mas que ayamo miquije. ");
INSERT INTO nclNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Panuje chicuase tonalijmes. Cuaquín Jesús quinhuicac Pedro huan Jacobo huan Juan, mohuicaje inminhuían, panquisaje se loma (tepel) cuajtic. Nepa mopalac Jesús inminlaixpan. ");
INSERT INTO nclNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Pehuac laixpelac inahuas, iztatataya míac quinami tisihuil. Se lapacani pan lalticpan amo huil quichipahuasquiaya iztac quinami in. ");
INSERT INTO nclNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Huan nesije Elías huan Moisés, ca Jesús laqueztataloaya. Yehuanten in omenten yulinijme niman pa yina pa tonalijmes hual ayamo lacatic Jesús nican pan lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Cuaquín Pedro quinotzac Jesús, quilic: —¡Lamaxtini! Cuali unca pampa ticate nican. Ma ticchihuacan ye calimes lachihuali ca isacayo cuahuimes, se pa tehual huan se pa Moisés huan se pa Elías. ");
INSERT INTO nclNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Inon quilic Pedro pampa momajtitataloaya in ye monextilinijmes huan pampín Pedro amo quimatiaya len quijtusquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Huan hualac se mextemil, quinlaquentic huan quicaquije in monextilinijmes se lajtol quistataya pin mextemil, quijtuc: —In noxolol, yihual niclasojla. Xijcaquican yihual. ");
INSERT INTO nclNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Huan jan ajnaxcan, lachiaje inmintenco, yajmo quitaje amaqui ca yehuanten, jan yihual Jesús san. ");
INSERT INTO nclNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Cuaquín temujtiahuiloaya in loma (tepel) cuajtic, huan Jesús quinmilic chicahuac: —Amo xiquilican amaqui len anquitac. San quiman nehual ilacal in cielo nimiquis huan cuaquinon niyulis oc sejpa, pa in tonali, xiquinmilican moxtin. ");
INSERT INTO nclNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Cuaquín yehuanten molajlaniloaya len quinequiaya quijtu in hual Jesús quinmilic, in quinami yahuiaya miqui huan umpa yahuiaya yuli oc sejpa. Huan mas que quijnamiquije pa inminyolo, ma yoje amo molaquetzilije inahuac inon. ");
INSERT INTO nclNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Cuaquín quilajlanije Jesús, quilije: —¿Leca techmaxtilo ilamaxtinijmes Dios ilajtol, quil, monequi pa hualas Elías, cuaquinon hualas Cristo? ");
INSERT INTO nclNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesús quinnanquilije: —Neli monequi pa hualas Elías pa quipehualtis imelahualisli mochi. Ma yoje, nehual ilacal in cielo, ¿quinami unca lajcuiluli ca Dios ilajtol pampa nehual nicpías pa nipanus míac lacocoltilisli hual nejchihuilisi in lacames, huan yehuanten nejxijxicusi? ");
INSERT INTO nclNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Huan annimitzilía pampa hualac se hual quichihuaya quinami Elías, huan sequin quichihuilije quinami quinequiloaya. Quimictije jan quinami unca lajcuiluli inahuac yihual. ");
INSERT INTO nclNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Cuaquín ajsije capa cataloaya in oc sequin imonextilinijmes. Quinmitaje míac lacalera quinyahualujtataloaya yehuanten. Noje cataloaya ilamaxtinijmes inminlajtol in judíos. Quinlaxilijtataloaya lajtomes ca yehuanten imonextilinijmes Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Quitaje Jesús in lacames, molapolultije, molaluje quipialtije. ");
INSERT INTO nclNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Huan Jesús quinlajlanic, quinmilic: —¿Len anquilaxilijtica lajtomes ca in lamaxtinijmes? ");
INSERT INTO nclNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Huan quinanquilic se ca in lacames, quilic: —¡Lamaxtini! Nicualicac noxól, quipía se ijyecal, pampín amo huil lajtúa. ");
INSERT INTO nclNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Capa yes quiquitzquía in ijyecal, cuaquín quimayahuía pan lali, nepa pan lali posuni icamac huan choca ilames. Cuaquín mocahua huapistic. Huan niquinlajlanic momonextilinijmes pa quiquixtilisi, huan amo huil yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Cuaquinon quinnanquilic Jesús, quinmilic: —¡Ah, lacames hual amo anquineltoca Dios, hual amo anquilalía anmolaneltocalisli ca Dios! ¿Quichi tonalijmes monequi pa nicayas ca amhuanten? ¿Quichi tonalijmes nicpías pa nicchixtías pa anpehuas annechneltocas? ¡Xichhualiquilican in muachito! ");
INSERT INTO nclNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Quihualiquilije. Huan quiman in ijyecal hual cataya laijtic in muachito quitac Jesús, jan ajnaxcan quitzejtzejtzeluc in muachito, quimayahuic huan huetzic in muachito pan lali momijmilujtataya, posuntataya pa icamac. ");
INSERT INTO nclNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Huan Jesús quilajlanic itajtzin, quilic: —¿Quichi xixíl quipía quiman pehuac quiquitzquic? Huan itajtzin quinanquilic: —Quiman yec xól. ");
INSERT INTO nclNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Huan ca míac tonalijmes quiman quiquitzquic, quimayahuini pan tixuxli huan quimayahuini pa al pa quimictisquiaya. Sinda huil titejchihuilía len, cuaquín xitejchihuili, xitechpalehui. ");
INSERT INTO nclNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús quilic: —¿Leca tiquijtúa “Sinda huil”? Mochi huil panúa ca aqui yes quilalis ilaneltocalisli ca nehual. ");
INSERT INTO nclNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Huan jan ajnaxcan tzajtzic itajtzin in muachito, quilic: —¡Tata, niclalía nolaneltocalisli ca tel! ¡Xichpalehui pa camo nicmahuilis da amo huil ticpajtis! ");
INSERT INTO nclNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Quitac Jesús quinami monechicujtataloaya míac lacames. Pampín cajuac in ijyecal elehuis, quilic: —¡Tel, ijyecal, pan mopampa amo huil lajtúa huan amo huil lacaqui in muachito! ¡Axan nimitzilía xiquisa pa yihual huan amo quiman xicalaqui oc sejpa capa yihual! ");
INSERT INTO nclNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tzajtzic in ijyecal, quitzejtzeluc chicahuac in muachito huan quisac. Cuaquinon mocahuac chicuenta mijquil in muachito. Pampín quijtuloaya míac ca in lacames pampa axan miquic. ");
INSERT INTO nclNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ma yoje, quiquitzquic Jesús imajma, cajcoquic huan moquetzac in muachito. ");
INSERT INTO nclNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Cuaquinon calaquic Jesús pan cali. Nepa cataya, hualaje capa yihual imonextilinijmes quilajlanije inminhuían, quilije: —¿Leca tehuanten amo huil tijquixtilije in ijyecal? ");
INSERT INTO nclNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Huan Jesús quinnanquilic: —Monequi pa quilajlanisi Dios huan pa mosahuasi pa huil quinquixtilisi ijyecames quinami innojen. Jan yoje huil yesi laquixtili yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Quisaje yehuanten nepa, quipanajtiahuiloaya in lalticpan Galilea, huan Jesús quinequiaya pa amaqui quimatisquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Cataya pampa quinmaxtiaya imonextilinijmes, quinmiliaya: —Nehual ilacal in cielo nechtemacasi ca lacames hual nechquitzquisi. Nechmictisi huan quiman nimiquis, panusi ye tonalijmes, cuaquín niyulis oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ma yoje, yehuanten amo quimatiloaya len quinlaquetzilijtataya huan momajtiloaya quilajlanilo len quinequiaya quijtu. ");
INSERT INTO nclNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Huan ajsije Capernaum. Cataloaya calijtic capa chantiloaya, Jesús quinlajlanic, quinmilic: —¿Len anmolaquetzilijtihualaya pa ojli? ");
INSERT INTO nclNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yehuanten amo nahuatije, pampa pa ojli molaquetzililoaya inahuac aqui ca yehuanten yesquiaya in hué hual quinlaicanasquiaya in oc sequin. ");
INSERT INTO nclNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Cuaquinon molalic Jesús, quinnotzac in doce imonextilinijmes, quinmilic: —Sinda se quinequi mochía in hué pa anmitzlaicanas amhuanten, cuaquín yihual quipías pa mochías in niman tipichin ca moxtin in oc sequin, huan quipías pa quintequipanuilis moxtin. ");
INSERT INTO nclNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Canac se xolol, quilalic lajco capa yehuanten, quinapaluc in xolol, quinmilic: ");
INSERT INTO nclNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Sinda se quilalía ilaneltocalisli ca nehual huan notoca, huan pampín quinamiquía ca lasojlalisli se xól quinami inon, cuaquín yoje in se quichijtica quinami yihual nechnamiquía nehual ca lasojlalisli. Huan aqui hual nechnamiquía nehual, yihual amo nechnamictica nehual san. Noje quinamictica ca lasojlalisli yihual Dios hual nechtilanic pan lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Cuaquín Juan quilic: —Lamaxtini, tiquitaje se lacal quinquixtitataya ijyecames, quinquixtiliaya quijtutataya motoca, mitznoztica. Huan tehuanten tiquilije pa camo quichías inon, pampa yihual amo techtocatica. ");
INSERT INTO nclNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús quilic: —Amo xictzacuilican. Quiman yes quichía se len hual lalapolultía pan ipampa nochicahualisli hual quipalehuía pampa quijtúa notoca, yoje amo huil panus pa in se jan axcan nechhuejuecaltis. ");
INSERT INTO nclNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Inon annimitzilía pampa aqui yes amo tejtzacuilía, yoje yihual techpalehuía. ");
INSERT INTO nclNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Huan aqui yes anmitzmacas pa ancunis jan se tecomal ca al san, huan anmijchihuilía inon pampa amhuanten ilacames in Cristo, yoje annimitzilía neli, yihual yahui quipía ilaxlahuilisli. ");
INSERT INTO nclNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Huan aqui yes quichihualtis laijlaculisli se ca in xolomes tijtipichin hual quilalilo inminlaneltocalisli ca nehual, yesquiaya cuali pa quipiluilisi se melal hué pa iquixlan in se huan quilasasi lajco pa al huejcalan pa moatoctis. ");
INSERT INTO nclNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Huan sinda momajma mijchihualtía laijlaculisli, cuaquín xijcotona. Cuali, cuali yes pa tehual ticalaquis pan cielo capa unca Dios ca se momajma san huan amo ca ome momajmajuan tías capa amo huil sehuis in tixuxli. ");
INSERT INTO nclNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Nepa amo miquilo in ocuilimes hual quicualo icuerpo se, huan noje nepa amo quiman sehuis in tixuxli. ");
INSERT INTO nclNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Huan sinda mocxían mijchihualtis laijlaculisli, cuaquín xijcotona. Cuali, cuali unca pa tehual pa tipehuas ticpías in yulilisli hual Dios quimaca ticpixtica jan se mocxían san. Amo yesquiaya cuali pa tehual sinda Dios mitzlasas ca ome mocxihuajmes pa in tixuxli hual amo mosehuis. ");
INSERT INTO nclNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Nepa amo miquisi in ocuilimes hual quicualo icuerpo se, noje amo quiman sehuis in tixuxli. ");
INSERT INTO nclNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Huan sinda mijchihualtis laijlaculisli moixtololon, xijquixti. Cuali pa tehual tías capa huelitía Dios ca se moixtololon san. Amo yesquiaya cuali pa tehual sinda mitzlasas Dios ca ome moixtololojmes capa chichinahuía. ");
INSERT INTO nclNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Nepa amo miquilo in ocuilimes hual quicualo icuerpo se huan nepa amo quiman sehuía in tixuxli. ");
INSERT INTO nclNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Amhuanten nomonextilinijmes anquipía pa anpanus lacocoltilisli capa anyultica, huan yojque anmochipahuas quinami lachipahua tixuxli. Yojque amo anmochías laijlaculi. Inon unca quinami quilalilo istal pan nacal hual unca pa huendi. Yoje amo moijlacúa. ");
INSERT INTO nclNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Unca cuali in istal pa camo moijlacus nacal. Quema, in istal unca cuali pa len yes ticlalisi. Ma yoje, sinda pataquías in istal, cuaquín ¿quinami quichihuasi pa mochías istal oc sejpa? Dios ilajtol cuali unca quinami istal, pampa sinda anquipía pa anmoyolo, amo anmochías laijlaculi. Xicpiacan iistal Dios laijtic amhuanten. Yoje anyulis ca sehuilisli pa anmoyolo huan anpanus cuali ca moxtin. ");
INSERT INTO nclNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Quisac Jesús de Capernaum, uyac pa in lali Judea. Cuaquín uyac ca yojque (analco) in atenco hué Jordán. Huan oc sejpa monechicujtihualaloaya míac lacames huan sihuames capa yihual, huan oc sejpa quinmaxtiaya quinami quichihuani ca mochi cajcapa. ");
INSERT INTO nclNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Cuaquinon ajsije sequin fariseos capa yihual. Quinequiloaya quicaquilo sinda Jesús quijtusquiaya se lajtol calica yehuanten huil quimotexpahuililosquiaya. Pampín quilajlanije, quilije: —¿Tolajtol hual technextilía quinami ticmolancuacuetzililo Dios quimacahuiltía pa quincajcahuasi lacames inminsihuahuan? ");
INSERT INTO nclNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesús quinnanquilic: —¿Len anmitzilic Moisés quinami lajtol inahuac inon? ");
INSERT INTO nclNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yehuanten quinanquilije: —Moisés quijcuiluc pin lajtol pa quimacahuiltisi se lacal quimacas isihua se amal hual quijtúa pampa yajmo isihua yihual. ");
INSERT INTO nclNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesús quinnanquilic: —Moisés quijcuiluc in lajtol pampa amhuanten amo anquinequi ancana pa anquichías len yes cuali. ");
INSERT INTO nclNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ma yoje, quiman pehuac mochi, pa innojen tonalijmes quiman quichíac Dios in lalticpan, Dios quinchíac lacal huan sihual. ");
INSERT INTO nclNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Pampín se lacal yajmo yuli ca itajtzin huan inantzin, yuli ca isihua. ");
INSERT INTO nclNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Yoje in omenten mochihualo se, yajmo cate ome yehuanten, mochihuaje se san.” ");
INSERT INTO nclNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Dios quinchíac pa yesi se san. Pampín ma camo quinxilucan in lacames. ");
INSERT INTO nclNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Quiman mocuepaje pin cali, quilajlaniloaya Jesús imonextilinijmes oc sejpa inahuac in hual yihual quinmilic in fariseos. ");
INSERT INTO nclNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús quinmilic: —Aqui yes quicajcahuas isihua huan monamictis ca oc se sihual, yoje yihual cana oc se sihual hual amo iyaxca pa yes isihua huan yoje quichihuilía amo cuali isihua hual quicajcahuac. ");
INSERT INTO nclNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Huan sinda se sihual quicajcahuas ilahuical huan yulis ca oc se lacal, yoje yihual cana oc se lacal hual amo iyaxca huan yoje quichihuilía amo cuali ilahuical hual quicajcahuac. ");
INSERT INTO nclNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Quinhualiquililoaya Jesús xolomes pa yihual quinmatoquilis, huan imonextilinijmes quinmajualoaya yehuanten hual quinhualicatataloaya. ");
INSERT INTO nclNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesús quinmitac quinami quichijtataloaya, huan pampín yihual cualanic huan quinmilic: —Xiquinmacahuiltican in xolomes pa hualasi ca nehual, amo xiquintzacuilican. Yehuanten hual cayasi capa Dios huelitía quipiasi pa yesi quinami xolomes. ");
INSERT INTO nclNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Se xolol quipía paquilisli quiman yes Dios quineltocaltía. Huan neli annimitzilía, sinda se amo quilalía ilaneltocalisli ca ilahueliltilisli Dios quinami se xól quilalilía ilaneltocalisli yihual, cuaquín in se amo quiman cayas capa Dios huelitía. ");
INSERT INTO nclNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Cuaquinon quinnapaluaya mochi in xolomes, huan quinlalilic imajmajuan capa yehuanten huan quintuchíac, quinmilic pampa Dios quinchihuilisquiaya cuali. ");
INSERT INTO nclNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Cuaquinon Jesús canac ojli. Huan molalujtihualac se lacal, quimolancuacuetzilic, quilajlanic: —Lamaxtini cuali, ¿len nicpías pa nicchías pa yojque Dios nechmacas pa camo quiman nilamis niyulis capa yihual quiman niyulis oc sejpa? ");
INSERT INTO nclNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús quinanquilic: —¿Leca tichilía pampa nehual nicuali? Amo unca amaqui hual cuali, jan Dios san unca cuali. ");
INSERT INTO nclNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tel, ticmati innojen lajtomes hual Dios quinmilic lacames pa quichihuasi: “Amo xicana je sihual hual quipía ilahuical, amo xicmicti oc se, amo xilaixtequi, amo xicmotexpahuili se tislacatijtica, xiquinlasojla motajtzin huan monantzin.” ");
INSERT INTO nclNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","In lacal yancuic quinanquilic, quilic: —Lamaxtini, mochi inon niyulic nicneltocatihualac quiman niyec xól pa axan. ");
INSERT INTO nclNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Cuaquín quiztataya in lacal yancuic Jesús, quilasojlac, quilic: —Unca oc se lachihualisli hual monequi pa ticchías. Xía, xicnamaca len ticpía. Cuaquín in tomin hual ticanac ca mochi hual ticnamacac xiquinmaca yehuanten hual amo quipialo. Yoje ticpías len hual ipati míac pin cielo capa unca Dios. Cuaquín xicana noꞌojli capa panulo lacocoltilisli huan xichtoca nehual. ");
INSERT INTO nclNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Quilic Jesús inon, iixco in lacal yancuic sulahuac, uyac quicocujtíac iyolo pampa quipiaya míac hual iyaxca. ");
INSERT INTO nclNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Huan quinmiztataya Jesús imonextilinijmes hual cataloaya itenco, quinmilic: —¡Quinami quipía pa motolinis niman míac pa calaquis capa huelitía Dios se lacal hual quipía míac tomin! ");
INSERT INTO nclNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Molapolultije imonextilinijmes quicactataloaya len quinmilic Jesús. Cuaquín Jesús oc sejpa quinmilic: —Nitos, quipiasi pa motolinisi niman míac pa calaquisi capa huelitía Dios yehuanten hual quilalilo inminlachialisli ca in míac hual inminyaxca. ");
INSERT INTO nclNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Quema, sinda se camello huil quipanahuiaya iixtololon se lajtzomaloni, amo quipiaya pa motolinisquiaya yoje quinami se hual quipía míac tomin quipiaya pa motolinisquiaya pa calaquis capa huelitía Dios. ");
INSERT INTO nclNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Huan molapolultije míac míac imonextilinijmes, molajlanije se huan oc se, moilije: —Cuaquín ¿aqui huil quipías Dios iyulilisli hual amo quiman lamis sinda yoje unca? ");
INSERT INTO nclNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús quinmitac huan quinmilic: —Lacames amo quiman huil quichihualo pa panus inon. Ma yoje, Dios, quema, yihual huil, pampa ca Dios mochi huil panúa. ");
INSERT INTO nclNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Cuaquinon Pedro pehuac quilic: —Xiquita. Tehuanten tijcajcahuaje mochi hual ticpiaje pa timitztocasi tehual. ");
INSERT INTO nclNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús quinnanquilic: —Annimitzilía melahuac. Cate yehuanten hual quincajcahualo inminchan huan inmicnían lacames huan inmicnían sihuames huan inminnantzitzían huan inmintajtzitzían huan inminxolomes huan inmincuajmilimes. Quema, mochi quincajcahualo pa nechtequipanuilis huan pa quilamachiltisi capa yes in lamachiltilisli cuali. ");
INSERT INTO nclNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Ma yoje, mas que quincajcahualo, pa mochi in xixihuimes hual huejcahuas in lalticpan hual axan unca, mochi sejse ca yehuanten quinpías cien ca mochi sejse calimes huan icnían lacames huan icnían sihuames huan inantzitzían huan ixolomes huan cuajmilimes. Huan noje quiman huejcajtica in lalticpan, quitojtocalo huan quicocoltilo yehuanten hual amo nechneltocalo. Huan pa in lalticpan hual yahui caya, quipías capa unca Dios in yulilisli hual amo quiman lamis. ");
INSERT INTO nclNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ma yoje, míac hual axan cate huejueyenten cayasi itzinderos, huan in itzinderos cayasi huejueyenten. ");
INSERT INTO nclNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Cataloaya pa ojli, panquisaloaya pa Jerusalén, quinlaicanaya Jesús. Huan molapolultiloaya imonextilinijmes pampa Jesús amo momajtiaya yahui ca ompic. Yehuanten hual quintocaloaya Jesús huan imonextilinijmes, quema, momajtiloaya. Huan quinmanac Jesús ca yihual ihuían in doce imonextilinijmes, pehuac quinmilic len yahuiaya quipanu. ");
INSERT INTO nclNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Quinmilic: —Xiquitacan. Tipanquisticate pa Jerusalén, huan nehual ilacal in cielo nechtemacasi ca in tiopistas huejué huan ca in lamaxtinijmes hual quimaxtilo inminlajtol inahuac quinami quimolancuacuetzililo Dios. Huan nechmotexpahuilisi pa yoje nicayas lamictili. Cuaquín nechtemacasi ca yehuanten hual amo judíos. ");
INSERT INTO nclNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Yehuanten nechhuitzquilisi huan nejchijchasi huan nechhuitequisi huan nechmictisi. Huan quiman panusi ye tonalijmes, niyulis oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ajsije capa Jesús yehuanten Jacobo huan Juan, ixolomes Zebedeo, quilije: —Lamaxtini, ticnequilo pa titejchihuilis len yes tialo timitztemachilo. ");
INSERT INTO nclNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesús quinmilic: —¿Len anquinequi pa annimijchihuilis? ");
INSERT INTO nclNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Huan quilije: —Xitechmacahuilti pa timolalisi se ca moma cuali huan se ca moma amo cuali pa in tonali hual timochías tohué ca míac laixpelalisli hué. Yoje timitzpalehuisi pa tihuelitis. ");
INSERT INTO nclNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús quinmilic: —Amo anquimati len anquitemachijtica. ¿Huil anpanúa lacocoltilisli quinami nehual nipanus lacocoltilisli? Yes quinami ancuniaya se tecomal chichic. ¿Huil anmopepenialtis in lacuayatequilisli quinami lacocoltilisli quinami nehual nimopepenialtis? ");
INSERT INTO nclNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Huan quilije: —Tehuanten huil ticchihualo. Jesús quinmilic: —Quema, anpanus lacocoltilisli quinami nehual nipanus lacocoltilisli. Huan pampa nehual anquipías pa anmopepenialtis quinami se lacuayatequilisli hual lacocoltía quinami nehual nicpías pa nimopepenialtis. ");
INSERT INTO nclNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ma yoje, amo unca noyaxca pa annimitzmacahuiltis pa anmolalis ca noma cuali huan pa noma amo cuali. Dios quinmacahuiltis pa molalisi nepa yehuanten hual quinlajtultic pa molalisi nepa. ");
INSERT INTO nclNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Quicaquije inon in oc sequin diez (majlacli) monextilinijmes, pehuaje cualanije ca Jacobo huan Juan. ");
INSERT INTO nclNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Cuaquinon quinnotzac Jesús pa hualasi capa yihual, huan quinmilic: —Amhuanten anquimati quinami huelitilo yehuanten hual amo judíos pa mochi lalimes. Moxtin hual huelitilo capa yehuanten quinnextilo moxtin pampa quipialo lahueliltilisli pa quinchihualtisi lacames. Huan in huejueyenten ca yehuanten yulilo quinmilijticate len quipiasi pa quichihuasi. ");
INSERT INTO nclNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","’Amo cayas yoje ca amhuanten. Nican unca quinami cayas: Aqui hual quinequisquiaya pa mochías quinami in hué pa anmitzlaicanas amhuanten, yihual quipías pa anmitztequipanuilis. ");
INSERT INTO nclNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Huan aqui yes quinequisquiaya mochías in se hual monotza míac ca amhuanten, cuaquín yihual quipías pa yes anmotequipanujquil. ");
INSERT INTO nclNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Monequi pa yes yoje, pampa noje nehual ilacal in cielo amo nihualac pan lalticpan pa nechtequipanuilisi lacames. Nihualaya pa niquintequipanuilis huan noje nihualaya pa nimiquis pa yoje niquinmacahuas pa camo panusi in miquilisli hual amo quiman lamis. ");
INSERT INTO nclNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Cuaquinon ajsije pa in caltilan Jericó. Huan quiman quistiahuiloaya pa Jericó Jesús huan imonextilinijmes huan míac lacames huan sihuames, nepa molaliaya pa itenco in ojli Bartimeo, yihual Timeo ixolol. Yihual yuliaya motemachilijtataya tomin pampa yec pachacal. ");
INSERT INTO nclNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Quilije pampa panujtataya Jesús in nazareteco, huan pampín pehuac tzajtzic, quijtuaya: —¡Jesús, tel ixolol David, xichicnili! ");
INSERT INTO nclNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Cajualoaya míac ca yehuanten, quililoaya pa mocahuasquiaya. Ma yoje, yihual tzajtziaya niman chicahuac, quilic: —¡Tehual tiꞌixolol David, xichicnili! ");
INSERT INTO nclNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Cuaquín moquetzac Jesús, quinmilic: —Xicnotzacan pa hualas. Huan quinotzaje in pachacal, quilije: —Amo ximomajti, ximoquetza, mitznoztica. ");
INSERT INTO nclNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yoje jan ajnaxcan moquixtilic ilaquen moqueztiquisac, uyac ca Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús quilic: —Axan, ¿len ticnequi pa nimijchihuilis? Quilic in pachacal: —Nolamaxtini, nicnequi nilachía. ");
INSERT INTO nclNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Huan Jesús quilic: —Cuaquín ximohuica. Ticlalic molaneltocalisli ca nehual, pampín tipajtic. Huan jan ajnaxcan huil lachíac Bartimeo huan quitocatiahuiaya Jesús pan ojli. ");
INSERT INTO nclNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Hualatataloaya pa Jerusalén, ajsije pa in ome caltilan tijtipichin Betfagé huan Betania. Innojen caltilan tijtipichin cataloaya pa quiahuac Jerusalén amo huejca, cataloaya pa iixlán in tepetzindi (loma) itoca Olivos. Quintilanic Jesús ome imonextilinijmes, ");
INSERT INTO nclNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","quinmilic: —Xiacan in caltilan anmolaixpan, huan jan axcan ancalactica, anquitas ilpitica se ixól je burra. Ayamo quiman lejcuc amaqui in burrito. Xictomacan, xicualicacan ca niquic. ");
INSERT INTO nclNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Sinda se anmitzilis: “¿Leca anquichijtica inon?”, cuaquín xiquilican: “In Tata quinequi pa nadita, huan jan axcan quicuepas.” ");
INSERT INTO nclNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","Yoje uyaje huan quitaje ilpitataya se ixolol se burra. Cataya inahuac se ilalapujquil pa quiahuac se cali inahuac in ojli. Quitomaje, huan sequin ca yehuanten hual umpa moquetzaloaya quinmilije: —¿Leca anquichijtica inon, anquitontica in burro? ");
INSERT INTO nclNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yehuanten quinnanquilije quinami Jesús quinmilic, huan in lacames quinmacahuiltije pa yahuisi. ");
INSERT INTO nclNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Quihualiquilije Jesús in burro, quinlalilije inminlaquemes pani in burro, cuaquinon lejcuc Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Huan míac quinsuhualoaya inminlaquemes pan ojli, oc sequin quinpipixtiloaya ca iramas (iitzmolinquimes) ca inminsacayo cuahuimes hual quincotonaje. ");
INSERT INTO nclNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yehuanten hual quinlaicanaloaya huan yehuanten hual quitocaloaya tzajtzitiahuiloaya, quijtuloaya: —¡Hosana! ¡Ma quichihuili niman cuali Dios yihual hual quitilanic pa huelitis! ");
INSERT INTO nclNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Ma quituchía yihual hual huelitis capa huelitini totajtzin David! ¡Ma quijtucan “¡Hosana!” yehuanten hual yulilo pin cielo! ");
INSERT INTO nclNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Calaquic Jerusalén Jesús, uyac calijtic pin tiopan hué, huan nepa quinmiztinemic mochi hual nepa cataya. Cuaquín tiolactitíac, huan pampín quisac Jerusalén, uyaje yihual huan imonextilinijmes pa Betania. ");
INSERT INTO nclNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mostatica quisaje Betania huan Jesús mayantiahuiaya. ");
INSERT INTO nclNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Quitac pa huejquita se amacuál tipichin hual quipiaya isacayo hué, huan uyac quitac sinda sulajtataya. Quiman ajsic, amo quitac nindeno ilaquilyo. Quipiaya jan isacayo san, ayamo cataya itonali pa quipiasquiaya ilaquilyo. ");
INSERT INTO nclNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Cuaquinon Jesús quilic in amacuál tipichin ca isacayo hué: —Ma camo quiman quicua amaqui molaquilyo axan huan pa quiman. Quicaquije imonextilinijmes inon hual quilic. ");
INSERT INTO nclNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Cuaquín ajsije pa Jerusalén huan umpa calaquic Jesús pin tiopan hué. Pehuac quinquixtic pa quiahuac aquinojen lanamactataloaya huan lacujtataloaya pin tiopan hué. Quintzincuepilic innojen capa yehuanten hual quinpatililoaya tomin quinpatililoaya inmintomin yehuanten hual mocuhuililoaya huendis, noje quintzincuepilic inmicpalijmes yehuanten hual quinnamacaloaya huilomes. ");
INSERT INTO nclNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Huan amo quimacahuiltic amaqui pa panusquiaya pa ilajcotían in tiopan hué sinda quimantiahuiaya len. ");
INSERT INTO nclNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Huan quinmaxtiaya, quinmiliaya: —¿Amo unca lajcuiluli inon hual quijtúa: “Quitocayaltisi nocali se cali capa quilajlanilo Dios, huan cayas cali pa moxtin capa huil quilajlanilo Dios”? Ma yoje, amhuanten anquichihuilijtica in tiopan hué quinami cataya se cueva capa molatilo laxtequinijmes. ");
INSERT INTO nclNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Inminhuejueyenten in tiopistas huan in lamaxtinijmes quicaquije inon, huan pehuaje quitemuje quinami huil quimictilosquiaya. Ma yoje, momajtiloaya pa quichihuilisi len pampa moxtin in lacames quixtocaloaya quicaquilo huan yehuanten molapolultiloaya pampa inon hual quinmaxtiaya Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Cuaquín ca tiolac quisaje Jerusalén Jesús huan imonextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mosta pa huajtzinco panuloaya huan quitaje in amacuál tipichin (cuahuil higuero), huaquic pa ilalhuayojmes huan mochi. ");
INSERT INTO nclNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Cuaquinon quijnamiquic Pedro huan quilic Jesús, quilic: —Lamaxtini, xiquita, in amacuál tipichin hual ticajuac, axan huáic. ");
INSERT INTO nclNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús quinanquilic: —Xiclalican anmolaneltocalisli ca Dios, anquimaztica pampa yihual huil quichía mochi. ");
INSERT INTO nclNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Annimitzilía neli, amhuanten huil anquilía in loma nican, “Ximijcuani ximolasa pin al huejcalan”, huan quema, quichías quinami tiquilis sinda amo ticmahuilis pampa amo yahui quichía quinami tiquilis. ");
INSERT INTO nclNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Pampa inon annimitzilía inon: Quiman yes anlajtúa ca Dios, huil anquitemachía pa yihual anmijchihuilis len yes. Xicneltocacan quinami axan anquipíac inon hual anquitemachic, huan yoje anquipías. ");
INSERT INTO nclNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Huan sinda anmoqueztica anlajtutica ca Dios, huan jan axcan anquijnamiquía pampa anmitzcualantic se, cuaquín xicpujpuhuacan. Yoje quinpujpuhuas anmolaijlaculisli anmoTajtzin hual unca pin cielo. ");
INSERT INTO nclNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Annimitzilía inon, pampa sinda amo anquinpujpuhuas, cuaquín noje anmoTajtzin hué hual unca pin cielo amo quinpujpuhuas anmolaijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Huan oc sejpa ajsije Jerusalén. Huan quiman Jesús nejnentinemiaya calijtic pin tiopan hué, hualaje capa yihual inminhuejueyenten in tiopistas, noje hualaje in lamaxtinijmes huan in abuelojmes. ");
INSERT INTO nclNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Quilajlanije, quilije: —¿Ca aqui ilahueliltilisli ticchía innojen hual tiquinchijtica? ¿Aqui mitzhueliltic pa tiquinchías innojen? ");
INSERT INTO nclNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús quinnanquilic: —Ma annimitzlajlani noje se lajtol, huan xichnanquilican. Cuaquín annimitzilis aqui nechueliltic pa niquinchías innojen hual niquinchijtica. ");
INSERT INTO nclNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Cataya Dios hual quitilanic Juan Lacuayatequini ca lahueliltilisli pa lacuayatequis o quitilanije lacames pa lacuayatequis? Xichnanquilican. ");
INSERT INTO nclNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Cuaquinon yehuanten quijtuloaya laijtic yehuanten huan molaquetzililoaya, moilije: —Sinda tiquilisi pampa quihueliltic Dios, yihual techilis: “¿Leca amo anquineltocac?” ");
INSERT INTO nclNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma yoje, amo huil tiquilisi pampa lacames quihueliltije. Sinda quililoaya pampa lacames quihueliltije, cuaquín momajtiloaya inminyampa in lacames. Moxtin yehuanten quimatiloaya pampa Juan yec se ilajtuni Dios. ");
INSERT INTO nclNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yoje, quinanquilije Jesús, quilije: —Amo ticmatilo. Cuaquinon Jesús quinmilic: —Nehual noje amo annimitzilis aqui nechueliltic pa niquinchías innojen hual niquinchijtica. ");
INSERT INTO nclNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Cuaquinon Jesús pehuac quinmaxtic ca se lapuhualisli hual quinmijnamiquiltisquiaya. Quinmilic: —Se lacal quitocac se cuajmili ca uva. Quitzacuac quiyahualujtataya itenco ca tixcalimes lachijchihuali cuajtic (se tepandi), quihuajuanac se huejcalito pa quintelicsalosquiaya in uvas pa quisasquiaya iayo. Noje quichíac se cali cuajtic capa huil lachiasquiaya pan mochi iuvatilan pa pani. Cuaquín quinmanac sequin lacames tequipanujquimes pa quitalosquiaya icuajmili, huan umpa quisac pa ichan, uyac huejca. ");
INSERT INTO nclNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ajsic in tonali hual yucsitataloaya in uvas. Quitilanic se tequipanujquil pa yasquiaya cana hual yihual iyaxca ilaquilyo. ");
INSERT INTO nclNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Huan yehuanten hual tequipanuloaya lajlajco quiquitzquije in tequipanujquil. Quihuitequije, quitilanije huan amo quimacaje nindeno. ");
INSERT INTO nclNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Iteco mocuepac quitilanic oc se tequipanujquil, huan tixcalazos quimacaje, quicocoltije pa itzontecon huan quihuejuecaltije. ");
INSERT INTO nclNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Cuaquín iteco quitilanic oc se, huan yihual quimictije. Umpa in lacal quintilanic míac oc sequin itequipanujquimes huan in lacames hual tequipanuloaya lajlajco quinhuitequije sequin huan quinmictije oc sequin. ");
INSERT INTO nclNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Quicahuilía in lacal oc se san pa quitilanis, in yec yihual ixól hual quilasojlaya míac. Yoje quitilanic, pampa yihual quijtuc: “Yehuanten quimatisi momajtisi ilaixpan noxól.” ");
INSERT INTO nclNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ma yoje, in tequipanujquimes ejꞌelehuis molaquetzilije se ca oc se, moilije: “In yihual hual canas icuajmili itajtzin, cayas iyaxca. Ma tián, ma ticmictican pa yes toyaxca tehuanten in cuajmili.” ");
INSERT INTO nclNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Cuaquinon quiquitzquije, quimictije, quilasaje imijquil pa quiahuac in cuajmili. ");
INSERT INTO nclNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’Axan, ¿len quichías iteco in cuajmili? Mocuepas huan quinmictis in tequipanujquimes ejꞌelehuis. Cuaquín quinmacas oc sequin tequipanujquimes in cuajmili. ");
INSERT INTO nclNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Amo quiman anmomaxtic in hual unca lajcuiluli? Quijtúa: Quilasaje in tel yehuanten hual quichihuaje in cali, quijtuje in tel amo unca cuali. Ma yoje, in tel mochíac in tel calica quipehualtije mochi in cali. ");
INSERT INTO nclNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ToTata quilalic pan cali quiman pehuaya quichía, huan timocahuaje timolapolultiticate pampa tiquitaje inon hual quichíac yihual. ");
INSERT INTO nclNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yoje, in huejueyenten quinequiloaya quiquitzquilo Jesús. Quimatiloaya Jesús quinmilic in lapuhualisli pa yoje laquetzasquiaya inminahuac yehuanten. Yehuanten cataloaya quinami in tequipanujquimes ejꞌelehuis. Ma yoje, amo quiquitzquije pampa momajtije inminyampa in lacalera. Pampín quicajcahuaje huan uyaje. ");
INSERT INTO nclNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Panuc inon, yehuanten quintilanije capa Jesús sequin ca in fariseos huan oc sequin hual yeje ca in lanechiculisli hual quitocaloaya Herodes. Quinequiloaya pa Jesús quijtusquiaya se lajtol calica quitalosquiaya quinami huil quiquitzquisi. ");
INSERT INTO nclNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Hualaje quilije: —Lamaxtini, ticmatilo pampa tehual tiquijtúa len melác. Tiquita je lacal jan quinami tiquita oc se, ticlasojla se lacal hué jan quinami se lacal tipichin san. Huan ticnextía melahuac len quinequi Dios pa quichihuasi in lacames. Axan timitzlajlanilo, ¿monequi pa ticlaxlahuilisi in niman hué César ilapixcalisli tomin, o amo? ¿Ticlaxlahuisi, o amo ticlaxlahuisi? ");
INSERT INTO nclNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Quimatic Jesús quinami quinequiloaya quicuajcuamanalo, huan quinmilic: —¿Leca anquitemúa quinami huil annechmotexpahuilis pa nechquitzquisi? Xichualiquilican se tomin denario pa niquitas. ");
INSERT INTO nclNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Yehuanten quihualiquilije huan Jesús quinlajlanic: —¿Aqui iixco inon? Huan ¿aqui ilajcuilulisli? Yehuanten quinanquilije: —In niman hué César iyaxca. ");
INSERT INTO nclNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Cuaquinon quinmilic Jesús: —Xicmacacan César hual iyaxca yihual, huan xicmacacan Dios hual iyaxca yihual. Yoje, mocahuaje molapolultiticate pampa yojque quinnanquilic. ");
INSERT INTO nclNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Cuaquinon hualaje sequin hual quineltocaloaya inminlamaxtilisli in saduceos. Yehuanten quijtulo pampa aquinojen miquilo amo yulisi oc sejpa. Quilije: ");
INSERT INTO nclNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Lamaxtini, Moisés techcahuilic in lajcuilulisli hual unca lajtol pa tehuanten. Huan in lajtol quijtúa sinda se lacal miqui huan quicahua isihua ihuían huan amo quinpialoaya xolomes, cuaquín icni in lacal hual miquic quipías pa monamictis ca isihua ihuían icni. Inon quichías pa yoje quinpiasi xolomes hual motocasi quinami in se hual polehuic. ");
INSERT INTO nclNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Axan, cataloaya chicome (siete) icnían. Se monamictic, huan amo huejcahuaya míac huan polehuic, amo quicahuac se xolol. ");
INSERT INTO nclNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Pampín, oc se icni canac in sihual, yihual noje miquic, amo quincahuac xolomes. Yoje quipanuc oc se icni. ");
INSERT INTO nclNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Huan yoje quinpanuc in chicome, monamictije ca in sihual. Amaqui ca moxtin innojen quincahuac xolomes. Cuaquín, polehuic in sihual noje. ");
INSERT INTO nclNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Axan, quiman yulisi oc sejpa innojen hual miquije, ¿calía lacal yes ilahuical in sihual? Pampa mochi in chicome monamictije ca in sihual. ");
INSERT INTO nclNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Cuaquinon Jesús quinnanquilic: —Amhuanten anmoixpolúa, pampa amo anquimati ilajcuilulisli Dios ilajtol huan ichicahualisli. ");
INSERT INTO nclNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","In tonali hual yulisi oc sejpa yehuanten hual miquije, cuaquín amo monamictisi lacames huan sihuames. Yulisi quinami Dios ilanahuatinijmes hual cate pin cielo. ");
INSERT INTO nclNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Huan inon hual anquijtúa inminahuac yehuanten hual miquilo, quema, yulisi oc sejpa. ¿Amo anmomaxtic capa quijtúa iamal hual quijcuiluc Moisés? Pin cuajtzindi hual lalatataya capa Dios quinotzac Moisés, yoje quilic: “Nehual niunca iDios Abraham huan iDios Isaac huan iDios Jacob.” Yehuanten, quema, miquije. Ma yoje, yulticate, pampa quijtuc Dios: “Nehual inminDios yehuanten.” ");
INSERT INTO nclNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Huan Dios amo inminDios mijquimes. Yihual inminDios yehuanten hual yulilo. Yoje amhuanten anmoixpolujtica míac. ");
INSERT INTO nclNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ajsic se lamaxtini ca in lamaxtinijmes. Yihual quincaquiaya quiman laquetzaloaya, quimatic pampa Jesús quinnanquilic cuali. Huan quilajlanic: —¿Calía in niman hué ca mochi in lajtomes? ");
INSERT INTO nclNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Quinanquilic Jesús: —Inon in lajtol niman hué: “Xijcaqui, Israel. In Tata toDios, yihual se san, amo unca oc se. ");
INSERT INTO nclNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Huan ticlasojlas in Tata moDios ca mochi moyolo huan ca mochi moyulilisli huan ca mochi moijnamiquilisli huan ca mochi mochicahualisli.” Inon in lajtol niman hué. ");
INSERT INTO nclNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Huan in oc se lajtol unca quinami inon hual nilamic niquijtuc: “Ticlasojlas aqui yes unca ca tehual quinami tehual timolasojla.” Amo unca oc sequin lajtomes hual monotzalo yoje míac quinami innojen. ");
INSERT INTO nclNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Cuaquinon in lamaxtini quilic: —Cuali tiquijtuc, Lamaxtini. Unca melahuac len tiquijtúa quinami Dios yihual se san. Amo unca oc se, jan yihual san. ");
INSERT INTO nclNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Huan sinda se quilasojla Dios ca mochi iyolo huan ca mochi ilaijnamiquilisli huan ca mochi iyulilisli huan ca mochi ichicahualisli, huan sinda quilasojla mochi sejse hual unca ca yihual quinami yihual molasojla, quema, in monotza niman míac. Amo quiman monotzalo yoje mochi in huendis huan mochi in huejuendi hual cate borregos huan bueyes hual quilalililo pani capa quichichinuilisi ilaixpan Dios. ");
INSERT INTO nclNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesús quicaquic quinami quinanquilic ca laijnamiquilisli huan quilic: —Jan nadita san huan huil timoita ca Dios mitzlaicantica laijtic moyolo. Cuaquinon moxtin momajtiloaya quilajlanilo oc sequin lajtomes pa quitasi quinami huil quimotexpahuililosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús lamaxtiaya pin tiopan hué, quinmilic: —¿Quinami huil quijtulo in lamaxtinijmes pampa yihual ixolol David in Cristo hual Dios quitilanía? ");
INSERT INTO nclNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","In Espíritu Santo quijtúa pan ipampa yihual David, quijtúa: In Tata quilic noTata: “Ximolali pa noma cuali pa tichpalehuis pa nihuelitis. Xicaya nican pa quiman ajsis in tonali hual niquinlalis inmintzindan mocxihuajmes yehuanten hual mitzcocolilo.” ");
INSERT INTO nclNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Yihual David quitocayaltía in Cristo noTata. Yoje, ¿quinami yes yihual ixolol David? Huan in míac hual cataloaya nepa quixtocaloaya míac quicaquilo. ");
INSERT INTO nclNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Lamaxtiaya Jesús, quijtuc: —Xilachixtiacan pa camo anmitzcuajcuamanasi ilamaxtinijmes in lajtol hual quimaxtilo, pampa yoje quichihualo yehuanten. Quixtocalo nejnentinemilo ca inminahuas huejuejcanic. Quixtocalo pa moxtin quinpialtilo ca míac lamajtilisli. ");
INSERT INTO nclNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Quixtocalo molalilo pin icpalimes huejué pin tiopan calijtic pa moxtin quitasi quinami yehuanten cate lacames huejueyenten. Noje quixtocalo cayasi capa in huejueyenten cate lacuajticate pin fiestas. ");
INSERT INTO nclNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Quinquixtililo inmincalimes in sihuames inminhuían huan amo quinmicnililo. Cuaquín quilajlanilo Dios ca míac lajtomes pa quincuajcuamanasi in lacames huan sihuames pa yoje quijtusi pampa yehuanten lacames cuajcuali. Yehuanten Dios quinmacas míac lacocoltilisli hual niman ticocu. ");
INSERT INTO nclNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesús yehuatataya laixpan capa quilasaloaya tomin laijtic pa in tiopan hué, quiztataya quinami yehuanten quilaxilijtiahuiloaya laijtic. Míac ca yehuanten hual quipialoaya míac tomin quilasaje míac laijtic. ");
INSERT INTO nclNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Huan panuc se sihual ihuían hual amo quipiaya. Quilaxilic ome tomin hual cataloaya niman tipichin. ");
INSERT INTO nclNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Cuaquín Jesús quinmilic pa quitasi imonextilinijmes huan quinmilic: —Neli annimitzilía, in sihual ihuían amo quipía pa molacualtis. Ma yoje, Dios quita quinami yihual quilaxilic laijtic míac. Amo yoje míac quilaxilije moxtin in oc sequin hual quilaxilijtataloaya tomin nepa. ");
INSERT INTO nclNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Moxtin yehuanten quilasaje tomin hual amo quinequije, cataya pampa quipialoaya míac. Huan in sihual ihuían quipiaya jan se nadita. Quilasac nepa mochi hual quipiaya calica quicuhuasquiaya len pa quicuasquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús quisaya pa quiahuac in tiopan hué, huan se ca imonextilinijmes quilic: —Xiquita, Lamaxtini, in tixcalimes huan in calimes, ¡xiquita quinami cate hué huan cualtichin! ");
INSERT INTO nclNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Huan Jesús quinanquilic: —¿Tiquinmita in calimes huejué? Amo mocahuas se tixcali inahuac oc se tixcali pan in calimes, mochi yesi lamayahuili. ");
INSERT INTO nclNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Uyaje panquisaje in tepetzindi (loma) itoca iLoma in Olivos hual cataya ilaixpan in tiopan hué. Nepa molalic Jesús huan Pedro huan Jacobo huan Juan huan Andrés quilajlanije inminhuijuían, quilije: ");
INSERT INTO nclNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Xitechili. ¿Quiman panus inon? ¿Len lanextilisli cayas pa ticmatisi quiman yahui panúa mochi innojen? ");
INSERT INTO nclNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Huan Jesús pehuac quinmilic: —Xilachiacan pa amaqui anmitzcuajcuamanas. ");
INSERT INTO nclNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Hualasi míac lacames hual quijtusi quipialo nolahueliltilisli, quijtusi: “Nehual niCristo.” Huan quincuajcuamanasi míac lacames huan sihuames. ");
INSERT INTO nclNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Anquicaquis anmitzilisi quinami moanalo cajcapa huan quinami yalo moanalo cajcapa. Innojen tonalijmes hual anmitzlamachiltisi pampa panujticate in, amo ximomajtican. Yoje quipialo pa panusi, huan ayamo lamis in lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Lacames pa se lali moanasi ca lacames pa oc se lali. Huan aquinojen hual huelitilo pa se lali moanasi ca inminlalimes yehuanten hual lahueliltilo nepa. Huan laulinis cajcapa pin lalticpan. Noje cajcapa miquisi pan ipampa mayandi. Lacames cualantinemisi huan majcoctinemisi pa moanasi. Ma yoje, lacames jan pehuasi mococusi san ca innojen, san unca ipehualisli in lacocoltilisli. ");
INSERT INTO nclNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Amhuanten xilachixtiacan pa camo anmocahuas pa annechneltocas. Sequin anmitztemacasi pa ilahueliltilisli inminlanechiculisli in huejueyenten. Sequin anmitzhuitequisi pin tiopajmes. Anmitzhuicasi inminlaixpan gobernadores huan in oc sequin niman hueyenten, yehuanten hual quipialo lahueliltilisli. Inon anmijchihuilisi pampa annechneltoca. Cuaquín anquijtus lamachiltilisli nonahuac nehual inminyampa yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ayamo lamis in lalticpan sinda in cuali lamachiltilisli ayamo yes lamachiltili capa chantilo moxtin yehuanten pin lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Huan quiman anmitzquitzquilo pa anmitztemacasi ca yehuanten hual quipialo lahueliltilisli, amo ximomajtican pampa amo anquimati len anquijtus. Xiquijtucan san inon hual jan axcan anmitzijnamiquiltis in Espíritu Santo pa in tonali. Xiquijtucan inon pampa amo yes amhuanten hual anlajtus, cayas in Espíritu Santo hual lajtus pan anmopampa amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Cayasi icnían hual quitemacasi icnían pa quimictisi. Cayasi inmintajtzitzían hual quintemacasi inminxolomes pa quinmictisi. Huan cayasi xolomes hual cualanisi ca inmintajtzitzían huan quintemacasi pa quinmictisi. ");
INSERT INTO nclNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Huan moxtin anmitzcocolisi pampa annechneltoca. Ma yoje, aqui hual mopepenialtis mas que quipías pa miquis, yihual yes laquixtili pin polehuilisli, quipías yulilisli hual amo quiman lamis. ");
INSERT INTO nclNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Daniel ilajtuni Dios quijcuiluc pin amal de in hual elehuis hual quijlacúa. Inon noje quijlacúa mochi capa quimolancuacuetzililo Dios. Quiman anquitas inon lalalili capa amo unca iyaxca pa cayas (ma monextía len quinequi quijtúa inon aqui yes hual momaxtitica inon), cuaquín ma cholucan pan lomas yehuanten hual cayasi pin lalticpan Judea. ");
INSERT INTO nclNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Huan pa in tonali, aqui cayas pa pani icali ma camo temu pa calaquis pa calijtic pa quiquixtis len pa calijtic. ");
INSERT INTO nclNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Huan aqui cayas pin cuajmili ma camo mocuepa pa canas ilaquen. ");
INSERT INTO nclNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Huan ¡eh, quinami yalo cayalo lacocoltili yehuanten hual yalo quipialo xolotzitzindis huan yehuanten hual lachichiltitiasi pan innojen tonalijmes! ");
INSERT INTO nclNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","19","Huan xictemachican Dios pa camo anquipías pa ancholus in tonalijmes quiman sehua, pampa pan innojen tonalijmes, quema, yalo panulo míac lacocoltilisli quinami ayamo quiman quinpanuaya lacames. In tonalijmes quiman pehuac quichíac Dios mochi, huan pa mochi in tonalijmes hual ajsitihualaloaya umpa pa axan, amo quiman cataloaya tonalijmes capa quinpanuaya lacames lacocoltilisli quinami inon hual quinpanus pa innojen tonalijmes hual ajsisi. Huan yajmo quinpanus yoje oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Sinda toTata amo quilalic pa camo huejcahualosquiaya innojen tonalijmes, cuaquín amaqui mocahuasquiaya yultataya. Ma yoje, Dios quinlasojla innojen hual quinlajtultic pa yesi yihual iyaxca. Pampín quilalic pa camo huejcahualosquiaya in tonalijmes. ");
INSERT INTO nclNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Cuaquinon innojen tonalijmes cuajnesi se anmitzilis: “Xiquitacan, nican unca in Cristo.” Huan cuajnesi anmitzilis: “Xiquitacan, umpunca yihual.” Amo xicneltocacan. ");
INSERT INTO nclNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Hualasi cristos hual amo yesi Cristo. Hualasi noje innojen hual quijtusi pampa yehuanten ilajtunijmes Dios, huan yesi islacatinijmes. Quinchihuasi innojen lachihualisli hual quinmolapolultisi lacames. Yoje, sinda huil quichihuasi, motolinisi pa quincuajcuamanasi yehuanten nojen hual Dios quinlajtultic pa yesi iyaxca. ");
INSERT INTO nclNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Amhuanten xicayacan amo anmomajtitica pampa inon, pampa axan annimitzilic pampa mochi in yahui panúa. ");
INSERT INTO nclNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Quiman lamisi panusi innojen tonalijmes capa yalo panulo lacocoltilisli yehuanten pin lalticpan, cuaquín mochías laticumac in tonali. In mesli yajmo lahuis. ");
INSERT INTO nclNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Luceros (silalimes) hueztiasi pin cielo huan mochi hual unca pin cielo motzejtzelus. ");
INSERT INTO nclNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Cuaquinon moxtin nechitasi nehual ilacal in cielo. Nechitasi nihualajtihuala pani pin mextemimes nicpixtica chicahualisli hué huan laixpelalisli cualtichin. ");
INSERT INTO nclNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Huan niquintilanis nolanahuatinijmes pin cielo pa quinnechicusi innojen hual Dios quinlajtultic pa yesi iyaxca. Quinnechicusi quinquixtiticate cajcapa lami in lalticpan huan cajcapa lami in cielo. ");
INSERT INTO nclNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Xijcaquican in laijnamiquilisli inahuac in amacuál tipichin. Itzmolinía sejselic huan selistitica isacayo. Cuaquín anquimati amo huejcahua pa ajsis xupanda. ");
INSERT INTO nclNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Yoje, in tonalijmes hual anquitas panujtica mochi inon hual axan annimitzilic, cuaquín anquimatis ajsitihualalo in tonalijmes. Quema, yalo ajsilo jan ajnaxcan. ");
INSERT INTO nclNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Neli annimitzilía inon: Panusi mochi innojen quiman yulticate yehuanten hual cayasi nepa pa innojen tonalijmes, ayamo lamisi quiman panusi mochi innojen, quema, quinmitasi. ");
INSERT INTO nclNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","In cielo huan in lalticpan lamisi. Ma yoje, nolajtomes amo lamisi. ");
INSERT INTO nclNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Amaqui quimati in tonali huan in hora quiman panus inon. Dios ilanahuatinijmes pin cielo amo quimatilo, Dios ixolol amo quimati. Jan Dios noTajtzin san quimati. ");
INSERT INTO nclNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Xilachiacan, xicayacan laejxiltili, pampa amo anquimati calía tonali yes. ");
INSERT INTO nclNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Unca quinami se lacal hual yahui huejca. Quicahua icali, quinmilía chicahuac itequipanujquimes pa quiztiasi in cali. Mochi sejse quipía itequipanulisli, huan quilía in lalapuni pa lachías. ");
INSERT INTO nclNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yoje, xilachixtiacan amhuanten mojmosta, pampa amo anquimati quiman hualas anmoTata. Amo anquimati da hualas pa layúa o pa lajco layúa o pa cualcan o pa laxpoyahua nepa quiman xahuanía in gallo o pa huajtzinco. ");
INSERT INTO nclNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Xilachixtiacan pa camo hualas jan ajnaxcan huan anmitzajsis ancoxtica. ");
INSERT INTO nclNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Huan niquinmilía moxtin inon hual annimitzilía amhuanten. Xilachixtiacan. ");
INSERT INTO nclNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mocahuaje ome tonalijmes huan cuaquín yahuiaya ajsi in ilhuil (fiesta) itoca ipascua in judíos. Noje cataloaya itonalijmes in fiesta quiman quicualo in pan hual amo quipía laxocoyajquil. Axcan inminhuejueyenten in tiopistas huan in lamaxtinijmes quitemuloaya quinami huil quiquitzquilosquiaya Jesús ca lacuajcuamanalisli pa quimictisi. ");
INSERT INTO nclNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Yoje quitemuloaya pampa quijtuloaya: —Amo huil tijquitzquisi pin fiesta pampa cualantiquisasi in lacalera. ");
INSERT INTO nclNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Cataya Jesús pa Betania pa ichan Simón hual quipiani in cocolisli lepra hual quixacualuilía se icuilaxli icuerpo (inacayo). Umpa lacuaya huan ajsic se sihual capa yihual, quipiaya se tapalquita yancuic lachihuali ca se tixcali itoca alabastro. Quipiaya laijtic in tapalquita se chahuac hual ajuíac itoca nardo, ipatiaya míac. Cuaquín quilapanac in tapalquita, huan umpa quitoyahuac in chahuac hual ajuíac ipan itzontecon Jesús pa quixahuilis. ");
INSERT INTO nclNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Sequin hual umpa cataloaya cualanije, moilije: —¿Leca amo quichíac cuali ca in chahuac hual ajuíac? ");
INSERT INTO nclNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Huil quinamacaloaya pa ye cientos denario tomin huan in tomin huil quinxiluililoaya ca yehuanten hual amo quipialo len. Huan cajuaje in sihual. ");
INSERT INTO nclNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesús quinmilic: —Xijcahuacan, ¿leca anquimaca tequil? Nejchihuilic len cuali in sihual. ");
INSERT INTO nclNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Cate itequi ca amhuanten yehuanten hual amo quipialo. Huil anquinchihuilía cuali quijquiman yes anquinequis. Huan nehual jan nadita huan amo nicayas ca amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","In sihual quichíac hual huil quichíac. Axan nejxahuilic ca in chahuac hual ajuíac pa nejchijchihuilisquiaya pa in tonali hual yalo nechlalpachulo. ");
INSERT INTO nclNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Neli annimitzilía, capa yes pa mochi lalticpan quilaquetzilisi in lamachiltilisli cuali, noje quipuhuasi in hual yihual nejchihuilic. Yoje moxtin quijnamiquisi yihual. ");
INSERT INTO nclNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Cuaquinon Judas Iscariote hual yec se ca in doce (majlaclihuanome) monextilinijmes uyac quinmitac inminhueyenten in tiopistas. Yahuiaya quitemaca Jesús pa yehuanten inminlahueliltilisli. ");
INSERT INTO nclNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Quicaquije yehuanten len yahuiaya quinchihuili, quipialoaya paquilisli huan quilije pampa neli yahuiloaya quilaxlahuilo. Cuaquinon quitemuaya Judas quinami yahuiaya quitemaca. ");
INSERT INTO nclNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Cataya in tonali quiman pehuaya in ilhuil (fiesta) quiman quicualoaya in pan hual amo quipía laxocoyajquil. Pan in tonali quimictilo quinami huendi in borrego itoca pascua. Pampín imonextilinijmes quilajlanije Jesús, quilije: —¿Capa ticnequi pa tiasi pa ticyucxiltisi pa tijcuasi ilacualisli in pascua? ");
INSERT INTO nclNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Cuaquinon quintilanic ome imonextilinijmes, quinmilic: —Xiacan pa in caltilan, nepa anquitas se lacal quimantía je tapalcal ca al. Xictocacan. ");
INSERT INTO nclNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Capa calaquis yihual, xiquilican iteco in cali: “Quijtúa in Lamaxtini: ¿Capa unca in calijtic capa tialo tijcualo nehual huan nomonextilinijmes ilacualisli in pascua?” ");
INSERT INTO nclNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Yihual anmitznextilis je calijtic hué nepa pin cali pa pani. Umpa cayasi mochi hual ticnequilo. Xicyucxiltican umpa in lacualisli pa tehuanten. ");
INSERT INTO nclNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Uyaje in monextilinijmes, ajsije pin caltilan, quitaje san quinami quinmilic Jesús. Huan nepa quiyucxiltije ilacualisli in pascua. ");
INSERT INTO nclNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Calaquic in tonali, hualaje Jesús huan in doce imonextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Cataloaya nepa capa lacuajtataloaya, Jesús quinmilic: —Neli annimitzilía, se ca amhuanten hual ca nehual lacuajtica, yihual yahui nechtemaca ca yehuanten hual yalo nechmictilo. ");
INSERT INTO nclNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Pehuac quincocuc inminyolo, molajlanije se ca oc se: —¿Yes nehual? Huan oc se noje quilajlanic: —¿Yes nehual? ");
INSERT INTO nclNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Huan Jesús quinnanquilic: —Yes se ca amhuanten doce hual huan nehual ticpaltililo tolajcomes pan pin tapalquita xalapa. ");
INSERT INTO nclNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nehual ilacal in cielo nía nimiqui. In yes quinami quijcuiluje nonahuac nel Dios ilajtunijmes. Huan ¡eh, quinami yahui panu lacocoltilisli in lacal hual nechtemaca pa nechmictisi yehuanten! Cuali cataya ca in lacal sinda amo lacatic. ");
INSERT INTO nclNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Lacualoaya yehuanten, Jesús canac pan, quisehuic Dios, quilapanac huan quinxiluilic pa quicualosquiaya, quinmilic: —Xijcuacan, in nocuerpo. ");
INSERT INTO nclNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Canac se tapalquita calica launilo, quisehuic Dios. Cuaquinon quinmacac yehuanten huan moxtin cunije. ");
INSERT INTO nclNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Quinmilic: —In noesli hual yahui toyahuía quiman nimiquis. Ca inon nicchías pa mocahuas cuali in lajtulisli hual Dios quichía pa lacames. Toyahuis noesli pa míac. ");
INSERT INTO nclNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Neli annimitzilía pampa amo nicunis oc sejpa iayo uva coc. Quiman ajsis in tonali nepa capa huelitía Dios, cuaquinon nicunis yancuic. ");
INSERT INTO nclNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Cuaquinon quicantaruilije (quicuiquilije) Dios ilahueyilisli huan umpa quisaje. Uyaje panquisaje pin loma (tepetzindi) itoca Olivos. ");
INSERT INTO nclNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Huan Jesús quinmilic: —Anmoxtin anyahui annechcajcahua axan layúa, pampa Dios ilajcuilulisli yoje quijtúa: “Nehual Dios nicmictis yihual hual quinmiztía in borregos huan in borregos mosemantinemisi.” Amhuanten in borregos. Yoje quijtúa in lajcuilulisli. ");
INSERT INTO nclNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ma yoje, nel niyulis oc sejpa. Cuaquín nías annimitzlaicanas amhuanten pa in lalticpan Galilea. ");
INSERT INTO nclNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Cuaquinon Pedro quilic: —Mas que moxtin oc sequin mitzcajcahuas, nel amo nimitzcajcahuas. ");
INSERT INTO nclNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús quilic: —Neli nimitzilía, axan layúa ayamo xahuanis ome xahuanilisli in gallo, huan tehual timocuepas tiquijtus ca ye lajtulisli pampa amo tichiximati. ");
INSERT INTO nclNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ma yoje, Pedro quilic niman chicahuac: —Sinda nicpiaya pa nimiquisquiaya ca tehual, amo quiman niquijtusquiaya pampa amo nimitziximati. Huan yojque quijtuje moxtin. ");
INSERT INTO nclNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Cuaquinon ajsije pan se cuajtilan itoca Getsemaní huan quinmilic Jesús imonextilinijmes: —Ximolalican nican huan nel nías pa niclajlanis Dios. ");
INSERT INTO nclNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Quinhuicac Pedro huan Jacobo huan Juan, ca yihual uyaje. Pehuaya quicocu míac iyolo huan momajtiaya. ");
INSERT INTO nclNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Huan quinmilic: —Nechcocúa noyolo, quema, ca nadita nicnequi nimiqui pampa yoje míac nechcocúa. Nican ximocahuacan huan xilachiacan. ");
INSERT INTO nclNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Huan uyac Jesús oc se nadita huejquita, molasac pan lali pa icamac. Quitemachic Dios sinda huil cayasquiaya pa yihual amo quipiasquiaya pa quipanusquiaya in lacocoltilisli hual yahuiaya quipanu nepa in tonali. ");
INSERT INTO nclNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Quijtuaya: —Abba, noTajtzin, tehual huil ticchía mochi, xichnapati pa camo nipanus in hual yahui nechpanúa. Ma yoje, amo xicchía in hual nicnequi nel, xicchía in hual ticnequi tel. ");
INSERT INTO nclNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Cuaquinon mocuepac capa cataloaya imonextilinijmes, quinmitac coxtataloaya. Quilic Pedro: —Simón, ¿ticoxtica? ¿Amo huil tilachía se nadita san? ");
INSERT INTO nclNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Xiejsacan, xiclajlanican Dios pa camo anmitztilanilis anmoyolo Satanás pa anquichías len amo cuali. Anquinequi anquichías pa anmoyolo. Ma yoje, amo anquipía chicahualisli pa anmocuerpo. ");
INSERT INTO nclNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Cuaquinon oc sejpa uyac quilajlanic Dios, quijtuc quinami pehuac quilajlanic. ");
INSERT INTO nclNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Oc sejpa mocuepac capa cataloaya, quinmitac coxtataloaya. Quipialoaya míac cochilisli, amo quimatiloaya quinami quinanquililosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Mocuepac oc sejpa, ca in cataya ye latemachilisli hual quilic Dios. Cuaquín mocuepac capa cataloaya, quinmilic: —Ayamo anlaquisa ancoxtica huan anmosejtica. Jan yoje. Axan nilamic nictemachic Dios, axan ajsic inon hual ticchialoaya. Xiquitacan. Nehual ilacal in cielo nía nipanúa pa inminlahueliltilisli lacames laijlaculi. ");
INSERT INTO nclNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ximoquetzacan, ma tiajtiacan. Xiquitacan, axan yihual hual yahui nechtemaca ajsitihuala. ");
INSERT INTO nclNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ayamo lamic lajtuc Jesús huan ajsic Judas, yihual se ca in doce monextilinijmes. Ca yihual hualaloaya míac lacames quinpialoaya teposlimes lajlatequi pa moanalisli, huan quinpialoaya cuahuimes. Quintilanije inminhueyenten in tiopistas huan in lamaxtinijmes huan oc sequin huejueyenten. ");
INSERT INTO nclNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Huan Judas hual yahuiaya quitemaca quinnahuatic, quinmilic: —Annimitzmacas je lanextilisli: Aqui nictenamiquis, yihual yes, xijquitzquican pa camo anmitzcajcahuas huan pa camo cholus. ");
INSERT INTO nclNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Cuaquín ajsitihualac Judas capa Jesús, quilic: —Lamaxtini, Lamaxtini —quipialtic, huan quitenamiquic. ");
INSERT INTO nclNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Cuaquinon ajsitihualaje huan quiquitzquije Jesús, quihuicaje. ");
INSERT INTO nclNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Huan se ca yehuanten imonextilinijmes hual nepa cataya quiquitzquic iteposli pa moanalisli, quicotonilic se inacas itequipanujquil in tiopista hué. ");
INSERT INTO nclNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Cuaquinon quinmilic Jesús: —¿Anquisac pa annechquitzquis quinami nehual nicataya je laixtequini? ");
INSERT INTO nclNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mojmosta nicataya ca amhuanten nilamaxtitataya pin tiopan hué huan nepa amo annechquitzquic. Ma yoje, inon panujtica yoje pa lamis mochías in hual quijtúa Dios ilajcuilulisli. ");
INSERT INTO nclNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Cuaquinon quicajcahuaje moxtin imonextilinijmes, choluje. ");
INSERT INTO nclNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Huan se oquixli hual quitocaya, yec lalaquentili ca se tzotzomajli iliarujtataya pan icuerpo, in san. Quiquitzquije in lacames. ");
INSERT INTO nclNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Jan axcan yihual itzotzomajli copinic huan yoje choluc nacatil. ");
INSERT INTO nclNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Quihuicaje Jesús capa in tiopista hué. Axan monechicuje inminhueyenten in tiopistas huan oc sequin huejueyenten huan in lamaxtinijmes hual quinmaxtiloaya in lajtol hual quinnextilo in judíos quinami quimolancuacuetzililo Dios. ");
INSERT INTO nclNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro quitocaya Jesús de huejca, ajsic huan calaquic ilajcotiyan ichan in tiopista hué. Umpa molaliaya ca in guaches moutzcutataloaya ilaixpan se tixuxli. ");
INSERT INTO nclNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Moxtin in huejueyenten hual huelitiloaya huan inminhueyenten in tiopistas quitemuloaya lacames hual quimotexpahuililosquiaya Jesús. Yojque huil quitilanilosquiaya pa miquisquiaya. Huan amaqui quitaje. ");
INSERT INTO nclNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Míac quimotexpahuililoaya islacatijtataloaya. Ma yoje, in hual quijtuloaya sequin amo cataya yoje quinami oc sequin quijtuloaya. ");
INSERT INTO nclNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Cuaquinon sequin moquetzaje pa quimotexpahuililosquiaya, huan islacatije, quijtuje: ");
INSERT INTO nclNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Tehuanten tijcaquije yihual quijtuc: “Nicxitinis in tiopan hual quichihuaje in lacames, huan quiman panusi ye tonalijmes nicchías oc se tiopan hual lacames amo quichihuaje.” ");
INSERT INTO nclNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ma yoje, yehuanten noje amo cataloaya ca se lajtulisli pa quimotexpahuililosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Cuaquín moquetzac inminyampa moxtin in tiopista hué, quilajlanic Jesús, quilic: —¿Amo huil tilananquilía? ¿Len inon hual mitzmotexpahuilijticate? ");
INSERT INTO nclNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús mocahuac, amo quinanquilic se lajtol. Cuaquinon mocuepac quilajlanic in tiopista hué, quilic: —¿Tehual tiunca in Cristo? ¿Tehual ixolol Dios in latuchihuali hual ticmolancuacuetzililo? ");
INSERT INTO nclNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús quinanquilic: —Quema, nehual. Huan amhuanten annechitas nehual ilacal in cielo. Annechitas niyehuatica inahuac ima cuali Dios hual quipía mochi chicahualisli huan lahueliltilisli. Annechitas nihualajtica pan mextemimes pin cielo. ");
INSERT INTO nclNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Cuaquín quitzayanic itzotzomajli in tiopista hué pa quinnextilis moxtin quinami yihual quijtuaya Jesús quihuejuecaltitataya Dios. Quinmilic moxtin: —¿Leca ticnequilo oc sequin lacames pa quimotexpahuilisi yihual? ");
INSERT INTO nclNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Axcan anquicaquic quinami yihual quihuejuecaltic Dios. ¿Len anquijtúa? Huan moxtin quijtuje pampa quipiaya pa miquis. ");
INSERT INTO nclNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Cuaquinon sequin pehuaje quichijchaje. Quitzacuilije iixco ca se tzotzomajli, cuaquín quitecualoaya ca inmajmajuan, quilije: —¡Xitechili aqui mitztecuac! Huan in guaches canaje yihual huan quitecuaje niman chicahuac. ");
INSERT INTO nclNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro cataya pa latzindan pin lajcotiyan. Panuc se sihual, itequipanujquil in tiopista hué. ");
INSERT INTO nclNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Quiztíac Pedro moutzcutataya, cuaquín quitac oc sejpa huan quilic: —Tehual noje ticataya ca Jesús in nazareteco. ");
INSERT INTO nclNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro islacatic, quilic pampa no, quilic: —Amo niquiximati huan amo nicmati len ticnequi tiquijtúa. Huan quisac pa quiahuac ilalapujquil in lajcotiyan. Cuaquinon xahuanic in gallo. ");
INSERT INTO nclNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Huan in sihual quitac oc sejpa, pehuac quinmilic yehuanten hual nepa moqueztataloaya: —In lacal se de yehuanten hual cataya ca Jesús nazareteco. ");
INSERT INTO nclNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Huan Pedro oc sejpa quijtuc pampa no. Huan ca je nadita, yehuanten hual nepa moqueztataloaya quilije: —Tehual neli se ca yehuanten. Tehual tigalileteco pampa tilajtúa quinami se galileteco. ");
INSERT INTO nclNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Cuaquinon Pedro pehuaya quinotza Dios pa cajuas chicahuac sinda amo lajtuaya melahuac, huan quinmilic quinami iyampa Dios: —Niclalía nolaixpan Dios damo niquijtúa neli, amo niquiximati in lacal hual annechlajlantica. ");
INSERT INTO nclNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Huan jan ajnaxcan xahuanic in gallo oc sejpa. Cuaquinon quijnamiquic Pedro quinami Jesús quilic: “Ayamo xahuanis ome xahuanilisli in gallo, huan tehual timocuepas tiquijtus ca ye lajtulisli pampa amo tichiximati.” Quijnamiquic in, jan axcan pejtiquisac chocac. ");
INSERT INTO nclNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Quiman lanesic, monechicuje inminhueyenten in tiopistas ca in oc sequin huejueyenten huan in lamaxtinijmes huan moxtin in oc sequin ca yehuanten hual quipialoaya lahueliltilisli. Quilpije Jesús huan quihuicaje pa quitemacasi ca Pilato in gobernador (huelitini) romano. ");
INSERT INTO nclNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato quilajlanic, quilic: —Tehual ¿tiunca inminhué in judíos? Quinanquilic: —Tehual tiquijtúa. ");
INSERT INTO nclNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Quimotexpahuililoaya yihual ca míac lachihualisli amo cuajcuali inminhueyenten in tiopistas. ");
INSERT INTO nclNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Cuaquín Pilato quilajlanic oc sejpa, quilic: —¿Amo len ticnanquilía? Xiquita in míac monahuac tehual hual mitzmotexpahuililo. ");
INSERT INTO nclNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Huan Jesús yajmo quinanquilic nindeno, huan pampín molapolultiaya Pilato. ");
INSERT INTO nclNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pan mochi fiesta (ilhuil) Pilato quinmacahuilini in judíos se lailpili hual catani latzacuali pa calijtic hual quimotemachilinijme. ");
INSERT INTO nclNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Huan nepa cataya se lailpili motocaya Barrabás. Yihual se ca yehuanten hual quinequije quichihuaje moanalisli pa quinsulahualosquiaya in romanos, noje yehuanten quinmictije lacames. ");
INSERT INTO nclNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Pampín hualaje in judíos capa Pilato, pehuaje quitemachije pa quinchihuililosquiaya in lachihualisli cuali quinami quinchihuilini yehuanten pan mochi ilhuil (fiesta). ");
INSERT INTO nclNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Yoje quinnanquilic Pilato: —¿Anquinequi pa annimitzmacahuilis inminhué in judíos? ");
INSERT INTO nclNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Quimatiaya Pilato leca inminhueyenten in tiopistas quitemacaje Jesús. Moxicuje pampa quixtocaje Jesús moxtin lacames hual tijtipichin. ");
INSERT INTO nclNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Huan inminhueyenten in tiopistas quinmacaje lajtol in lacalera pa quitemachisi Pilato pa quinmacahuilisquiaya Barrabás. ");
INSERT INTO nclNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Cuaquinon oc sejpa Pilato quinmilic: —Axan, ¿len nicchihuilis yihual hual itoca inminhué in judíos? ");
INSERT INTO nclNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tzajtzije huan quinanquilije: —¡Xicpilu pan se cuahuil! ");
INSERT INTO nclNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Quinmilic Pilato: —¿Leca? ¿Len amo cuali quichíac? Ma yoje, yehuanten tzajtziloaya míac ca chicahualisli: —¡Xicpilu pan se cuahuil! ");
INSERT INTO nclNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Cuaquinon Pilato quinmacahuilic Barrabás pa quinpaquiltisquiaya in lacalera huan latilanic pa iguaches quihuijuitequisi Jesús. Cuaquín quitemacac pa quipilusi pan se cuahuil. ");
INSERT INTO nclNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Iguaches Pilato quihuicaje pa laijtic ilajcotiyan icali in gobernador (huelitini). In cali motocaya Pretorio. Quinnechicuje mochi iguaches in lanechiculisli pa moanalisli. ");
INSERT INTO nclNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Cuaquinon quilaquentije Jesús ca se nahuas morado huan cahuanquil. Huan quijquetije se yahuali ca huizli. Quilalilije chicahuac pan itzontecon quinami yihual cataya se hué. ");
INSERT INTO nclNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Pehuaje quipialtije quinami quipialtiloaya se hué, quihuitzquilijtataloaya. Quitzajtzilije quilijtataloaya: —¡Ma yuli inminhué in judíos! ");
INSERT INTO nclNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Quitecualoaya oc sejpa itzontecon ca se ojlal, quichijchaloaya yihual. Quimolancuacuetzililoaya quinami quinextililoaya lamajtilisli iyampa se hué. ");
INSERT INTO nclNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Yoje lamije quihuitzquilije, huan cuaquinon quiquixtilije in nahuas morado, quilaquentije ca yihual itzotzomajli huan quiquixtije pa quipilulosquiaya pan se cuahuil. ");
INSERT INTO nclNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Panuc se lacal hual lacatic pin lali Cirene, motocaya Simón, mocuectataya pa ichan pin caltilan, tequipanuaya pa icuajmili. Yihual inmintajtzin yehuanten Alejandro huan Rufo. Innojen guaches quilamamiltije icuahuil Jesús pa ihuajcol Simón pa quimamilijtíac. ");
INSERT INTO nclNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Cajxiltije Jesús ca capic itoca Golgotá, in quinequi quijtúa Itzontecomal in mijquil. ");
INSERT INTO nclNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Quimacaje pa cunisquiaya iayo uva coc calica quinipanuje len altzindi chichic itoca mirra, huan Jesús amo cunic. ");
INSERT INTO nclNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Cuaquín quipiluje pan in cuahuil, huan moxiluilije yehuanten itzotzomajli, mahuiltitataloaya pa itzotzomajli pa quimatilosquiaya aqui yahuiaya moyaxcajti ca mochi sejse ilajco itzotzomajli. ");
INSERT INTO nclNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Cataya nueve (chicnahui) horas pa huajtzinco quipiluje pan in cuahuil. ");
INSERT INTO nclNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Huan quijcuiluje se amal calica quimotexpahuilije ilachihualisli hual pampa inon quimictiloaya. Quisaluje pa pani icuahuil, huan in lajcuilulisli quijtuaya: “INMINHUÉ IN JUDÍOS”. ");
INSERT INTO nclNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Huan ca yihual in guaches quinpiluje ome laixtequinijmes pan cuahuimes, se cataya pa ima cuali huan oc se pa ima amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Yoje lamic mochíac Dios ilajcuilulisli hual quijtúa: “Quijtujque pampa yihual yec se ca yehuanten hual quichihualo amo cuali.” ");
INSERT INTO nclNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Innojen hual panuloaya pa quitasi quixijxiculoaya quihuixujtataloaya inmintzontecon, quilije: —¡Jo! Tel tiunca in lacal hual quijtuc: “Nicxitinis in tiopan hué huan cuaquín quiman panusi ye tonalijmes nicchías oc sejpa.” ");
INSERT INTO nclNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Axan, ximoquixti capa tía timiquis sinda huil, xitemu pin cuahuil. ");
INSERT INTO nclNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Yoje inminhueyenten in tiopistas huan in lamaxtinijmes noje quihuitzquilije, moilije se ca oc se: —Quinquixtilic oc sequin pa camo miquilosquiaya. Ma yoje, amo huil moquixtilía yihual ihuían pa camo miquis. ");
INSERT INTO nclNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Axan, ma temu Cristo ihué Israel, ma quisa pin cuahuil. Cuaquín tiquitasi huan ticneltocasi yihual. Huan quihuejuecaltije yehuanten noje hual ca yihual pilujtataloaya. ");
INSERT INTO nclNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pa lacualispan laticumactic pan in lalticpan huan mocahuac yoje pa ye horas. ");
INSERT INTO nclNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Huan pa ye horas pa tiolac Jesús tzajtzic chicahuac, quijtuc: —¡Eloí, Eloí! ¿Lama sabactani? —hual quinequi quijtúa: ¡NoDios, noDios! ¿Leca tichcajcahuac? ");
INSERT INTO nclNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Sequin hual nepa moqueztataloaya quijtuje: —Xijcaquican, quinoztica Elías. ");
INSERT INTO nclNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Molalujtihualac se, quipaltilic ca iayo uva xocuc se latechcunijquil hual moita pin al huejcalan, se pochinquil. Quilalic pan se ojlal, quilejcultic pa quipachichinasquiaya Jesús, quijtuc: —Xilachiacan. Ma tiquitacan sinda Elías hualas quitemuhuis. ");
INSERT INTO nclNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Cuaquinon tzajtzic chicahuac Jesús huan miquic. ");
INSERT INTO nclNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Huan calijtic in tiopan hué cataya pilujtataya se tzotzomajli huejcanic huan telahuac hual quitzacuilic yehuanten pin lasojli calijtic pa camo calaquilosquiaya pin niman lasojli icalijtic in tiopan. Huan in tzotzomajli tzayanic, pejtataya ca pani huan tzayanic mochi pa latzindan, mochijtataya ome lajlajco nepa quiman miquic Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Huan inminlaicanani in guaches hual moqueztataya ilaixpan Jesús quitac quinami yoje tzajtzic Jesús quiman miquic huan quijtuc: —Neli in lacal yec Dios ixolol. ");
INSERT INTO nclNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nepa noje cataloaya sequin sihuames lachixtataloaya huejca. Ca yehuanten cataloaya María hual lacatic pin caltilan Magdala, huan María inminnantzin Jacobo in Tipichin huan Josés, huan Salome. ");
INSERT INTO nclNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Innojen sihuames yahuiloaya cajcapa ca Jesús, quipalehuiloaya nepa capa cataya pa Galilea. Huan míac oc sequin sihuames hual hualaje ca yihual pa Jerusalén umpa cataloaya. ");
INSERT INTO nclNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tiolactiaya pan in tonali hual quijtulo in tonali quiman mochijchihualo pa in ilhuil (fiesta) pa mostatica. ");
INSERT INTO nclNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Huan José hual lacatic pin caltilan Arimatea, yihual se ca in hueyenten huan moxtin quimatiloaya momajtilo iyampa yihual. Yihual noje quichixtataya in tonali quiman Dios san huelitis. Uyac amo momajtitataya capa Pilato pa motemachilis imijquil Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato molapolultic quiman quimatic Jesús miquic. Quitilanic se guache pa quinotzac pa hualas inminlaicanani in guaches. Ajsic in laicanani, Pilato quilajlanic sinda miquic Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Quinanquilic in laicanani pampa quema, axan miquic. Cuaquinon Pilato quimacahuiltic José pa quihuicasquiaya imijquil Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Huan quicuhuac José se tzotzomajli cuali huan iztac, quitemuhuije imijquil Jesús, quiliaruje pin tzotzomajli huan quilalije laijtic pan se cueva (ostul). In cueva yec lahuajuanali pin se xaltel hué. De umpa quimijmiluje se tel pa quitzacuas in ostul. ");
INSERT INTO nclNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Huan María hual lacatic pa Magdala huan María inantzin Josés quitaloaya capa quilalije imijquil Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Axan panuc in tonali hual mosehuilo in judíos, huan María hual lacatic pa Magdala huan Salome huan María inantzin Jacobo quicuhuaje len hual ajuíac. Ca innojen yahuiloaya quixahuililo imijquil Jesús. ");
INSERT INTO nclNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Cataya in tonali hual quipehualtía in siete (chicome) tonalijmes huan uyaje yehuanten pa cualcan. Ajsije capa in cueva (ostul), quiman quistataya in tonali. ");
INSERT INTO nclNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Yehuanten moililoaya: —¿Aqui techmijmiluilis in tixcali capa calaqui se pin ostul capa unca imijquil? ");
INSERT INTO nclNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ma yoje, lachiaje, quitaje in tixcali hual niman hué cataya, quitaje pampa mijcuanic in tixcali ilaixpan in ostul (cueva). ");
INSERT INTO nclNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Calaquije, quitaje se lacal yancuic molalijtataya pan ima cuali in cueva. Cataya lalaquentili ca se nahuas huejcanic hual iztatataya, huan quimacajsije in sihuames. ");
INSERT INTO nclNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ma yoje, in lacal quinmilic: —Amo ximomajtican. Anquitemujtica Jesús in nazareteco hual quipiluje pan in cuahuil huan quimictije. Xiquitacan. Yulic oc sejpa, amo unca nican. Xiquitacan capa quilalije. ");
INSERT INTO nclNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Axan, xiacan, xiquinmilican Pedro huan in oc sequin imonextilinijmes: “Yihual anmitzlaicantía amhuanten pa Galilea. Umpa anquitas, umpa cayas jan quinami anmitzilic.” ");
INSERT INTO nclNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Cuaquín yehuanten in sihuames quisaje pin cueva (ostul), choluje pampa momajtitataloaya huan yuyucatataloaya. Amo quipuhuilije amaqui inon hual quitaje pampa momajtiloaya. ");
INSERT INTO nclNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesús yulic oc sejpa. Huan quiman lanesiaya in tonali hual quipehualtía in chicome tonalijmes, pehuac monextic yultataya ca María hual lacatic pa Magdala. Quiman ayamo quimictije Jesús huan yihual nejnentinemiaya pa in lali Israel, yihual quiquixtilic María siete (chicome) ijyecames amo cuajcuali. ");
INSERT INTO nclNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Huan in sihual uyac quinlamachiltic yehuanten hual cayanijme ca Jesús, quinlamachiltic pampa axan yuliaya oc sejpa. Yehuanten quicocuhuaya inminyolo huan chocaloaya. ");
INSERT INTO nclNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Huan quiman quicaquije pampa yuliaya oc sejpa Jesús, quil, huan yihual María quitac, quil, yehuanten amo quineltocaje. ");
INSERT INTO nclNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Quiman panuc inon, ome imonextilinijmes nejnentiaje pin ojli hual uyac pa se caltilan amo huejca. Hualac Jesús, ajsic ca yehuanten, nesiaya quinami se lacal hual amo quiximatiloaya yehuanten. Ma yoje, ca nadita quislacuje. ");
INSERT INTO nclNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Cuaquín mocuepaje pa Jerusalén, quinlamachiltije in oc sequin imonextilinijmes, huan amo quineltocaje yehuanten noje. ");
INSERT INTO nclNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Panuc inon, monextic Jesús ca in once imonextilinijmes capa lacuajtataloaya. Quinmajuac nadita pampa amo quinequiloaya quinneltocalo yehuanten hual quinmilije quinami quitaje yultataya oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Huan quinmilic: —Xiacan pa mochi in lalticpan, xiquinmilican moxtin nejnepa in lamachiltilisli cuali. ");
INSERT INTO nclNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Aqui hual quineltoca huan yes lacuayatequili, yoje yihual yes laquixtili pa camo polehuis huan quipías yulilisli hual amo quiman lamis. Huan aqui hual amo quineltocas in lajtol yahui panúa polehuilisli hual amo quiman lamis. ");
INSERT INTO nclNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Huan yehuanten hual quineltocasi nolajtol huil quinchihuasi lanextilisli hual quinnextililo quinami quipialo nolahueliltilisli. Ca in nolahueliltilisli quinquixtilisi lacames ijyecames amo cuajcuali. Huil lajtusi ca oc sequin lajtomes yajyancuic. ");
INSERT INTO nclNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Huil quinquitzquisi cuhuames ca inminmajmajuan huan sinda cunisi len hual quinpajuía, amo quincocoltis, amo miquisi. Huan quinlalilisi inminmajmajuan pani pin cocoxquimes huan innojen cocoxquimes pajtisi. ");
INSERT INTO nclNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Huan quiman toTata Jesús lamic quinlaquetzilic mochi innojen, cuaquín Dios quilejcultic. Quihuicac pa ilhuicac (pin cielo), nepa molalic pa ima cuali Dios pa huelitisi huan yihual. ");
INSERT INTO nclNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Huan pa mochi cajcapa yehuanten imonextilinijmes quinlaquetzilijtinemiloaya moxtin in lamachiltilisli cuali quinami Dios techmaca in yulilisli hual amo quiman lamis. Yihual toTata quinpalehuiaya, quinhueliltiaya pa quichihuasi itequipanulisli. Huan yoje quinextiliaya quinami ilajtol unca melahuac pan inminpampa míac lanextilisli hual quinmitaltiloaya lacames ca lamajtilisli quiman quinchihuaje inminyampa. Yoje ma ye.");
INSERT INTO nclNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Lasojli Teófilo, cate míac lacames hual molalilijque pa quijcuilulosquiaya se lapuhualisli hual quilamachiltisquiaya quinami panujque innojen hual quinchíac Jesucristo hual neli ticmatilo. ");
INSERT INTO nclNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Inon techlamachiltijque yehuanten hual quincaquijque ilajtomes hual quijtuc. Huan quitajque ca inmixtololojmes len quichíac Jesucristo quiman yuliaya pan lalticpan huan quiman uyac pin cielo (ilhuicac). Yehuanten cate hual quilamachiltitinemiloaya ilajtol Jesucristo. ");
INSERT INTO nclNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Huan nehual noje nimomachiltilic cuali mochi in hual panuc, huan noje inon hual panuc pin tonalijmes quiman ayamo lacatic Jesucristo. Pampín niquixtocaya nimitzijcuiluili tehual, Teófilo, pa nimitzmachiltisquiaya sejse ca sejse innojen hual panujque quiman pehuac huan hual quinchijtíac pa quiman laquisac. Inon nimitzijcuiluilía pa ticmatisquiaya jan quinami panuc. ");
INSERT INTO nclNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nicchijtica inon pa ticmatis cuali pampa unca melahuac huan neli in hual mitzmaxtijque pampa quinchíac Jesucristo innojen. ");
INSERT INTO nclNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Pa innojen tonalijmes quiman Herodes yec in hué pin lalticpan Judea, cataya se tiopista motocaya Zacarías. Yihual yec se ca inminlanechiculisli in tiopistas hual quintocayaltiloaya quinami motocaya Abías. In Abías yulini pa yina huan imiahuimes tiopistas tequipanunijme pin tiopan hué in tonalijmes hual quinlalilinijme. Huan Zacarías quipiaya isihua motocaya Elisabet. In Elisabet, yihual noje yec imiahuil in tiopista motocani Aarón hual yec in tiopista pa yina hual ca yihual Dios quinpehualtic inmintiopistas in israelitos pin lali Israel. ");
INSERT INTO nclNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","In omenten, Zacarías huan Elisabet, Dios quinmitaya cuali pampa quineltocaloaya ilajtulisli huan ilajtomes Dios toTata. Amaqui huil quinmotexpahuiliaya ca nindeno hual amo cataya cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ma yoje, amo quiman quipiajque se xolol pampa amo huil quinpiaya xolomes Elisabet. Huan in omenten Zacarías huan Elisabet axcan moviejojtijque. ");
INSERT INTO nclNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Cuaquinon se tonali, Zacarías huan icnían inmintiopistas inechiculisli Abías quipialoaya pa quichihualosquiaya inmintequipanulisli tiopistas ilaixpan Dios pin tiopan hué. ");
INSERT INTO nclNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Quinami quichihuanijme yehuanten in tiopistas quiman quinequiloaya quimatilo aqui yahuiaya quichía se huan oc se tequipanulisli pa itiopan hué Dios, quijcuilunijme (quescribirunijme) quinami motocaloaya moxtin in tiopistas sejse itoca pan se cuajtzindi, quinlasaje mochi innojen pan se tapalcal. Cuaquinon quiquixtijque pin tapalcal se cuajtzindi. Pa in tonali, quiquixtije inon capa quijcuilujque quinami itocaya Zacarías. Yoje, in tonali quipiaya yihual pa calaquisquiaya pin ilasojli calijtic in tiopan hué pa lapopochuisquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Calaquic Zacarías, lapopochuiaya ca in ajuíac, huan moxtin in lacames huan sihuames cataloaya pa quiahuac in tiopan hué, quilajlantataloaya Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Cuaquinon nesic se ilanahuatini toTata pin cielo (ilhuicac). Nesic capa Zacarías, moqueztataya in lanahuatini pa ima cuali inon capa lapopochuilo. ");
INSERT INTO nclNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Quitac Zacarías in lanahuatini huan mocahuaya lachixtica, momajtic míac. ");
INSERT INTO nclNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Cuaquín in lanahuatini quilic: —Amo ximomajti, Zacarías, pampa quicaquic Dios in hual ticlajlanic. Mitzlacatiltilis mosihua Elisabet se xolol, huan tictocayaltis Juan. ");
INSERT INTO nclNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tehual ticayas paquintzudo, ticpías paquilisli, huan quipiasqui paquilisli míac lacames pampa yihual lacatic. ");
INSERT INTO nclNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","’Huan Dios quitas in xolol quinami se lacal hué. Dios quilía pa camo quiman cunis iayo uva coc, huan nindeno hual quipía alcohol. Huan in Espíritu Santo canas in xolol quiman ayamo lacatis. ");
INSERT INTO nclNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","In xolol quichías pa míac yehuanten pa Israel mocuepasqui quitequipanuilisqui cuali in Tata Dios. Quincuepaltis pa quitequipanuilisqui oc sejpa quinami quichihuanijme pa yina, quinami Dios quinnextilic. ");
INSERT INTO nclNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Huan Dios quitilanis in Juan moxolol hual quipixtías ilajtol Dios, quitilanis quinami quitilanic ilajtuni Elías hual yulini pa yina. Quema, Juan yes quinami Elías ca iyolo huan ilahueliltilisli. Quinchihuilis inminyolo in tajtzitzían pa yesi jan sejpa ca mosehuilisli ca inminyolo inminxolomes. Huan yehuanten hual aqui lacuilmatilo, yihual quinlaneltocaltis. Yojque yahui quichijchihuilis toTata lacames hual aqui cayasqui lachijchihuali pa quinamiquisqui Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Cuaquín Zacarías quilajlanic in lanahuatini, quilic: —¿Quinami nicmatis da in cayas jan quinami tiquijtutica? Pampa nehual nimoviejojtic huan nosihua moviejojtic. ");
INSERT INTO nclNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ilanahuatini in cielo quinanquilic: —Nehual niGabriel, nictequipanuilía Dios. Cataya yihual hual nechtilanic pa nimitznotzas huan pa nimitzilis in cuali lamachiltilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Huan axcan, pampa amo tichneltocac, tía timocahua, amo huil tilajtus. Quiman lacatis moxolol, cuaquín tilajtus oc sejpa. Huan moxolol, quema, lacatis pan in tonali hual quipías pa mochías in hual nimitzilic. ");
INSERT INTO nclNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Huan pa quiahuac in tiopan hué yehuanten quichixtataloaya Zacarías huan moililoaya: —¿Leca huejcajtica pa quisas pin tiopan hué? ");
INSERT INTO nclNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Cuaquinon quisac Zacarías, huan amo huil quinnotzaya. Cuaquinon quimatiloaya yehuanten pampa yihual quitac len ilanextilisli in cielo nepa capa cataya pa icalijtic in tiopan hué. Huan Zacarías quinlaquetzilic ca imajmajuan pampa axcan mocahuac, amo huil lajtuaya. ");
INSERT INTO nclNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ajsic in tonali hual laquisac tequipanuc Zacarías ca ilachihualisli se tiopista pin tiopan hué, cuaquinon uyac pa ichan. ");
INSERT INTO nclNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Quiman panuc inon, pehuac pilhuac Elisabet isihua Zacarías, yahuiaya quilacatilti se xolol, huan amo quisac pa icali pa macuili mesli. Quijtuaya laijtic yihual: ");
INSERT INTO nclNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Yojque nejchihuilic in Tata, nechitac quinami nipinahuaya pampa amo nicpiaya se xolol. Axcan yajmo nipinahuas ca lacames pampa quema, nicpías se xolol.” ");
INSERT INTO nclNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Pa in mesli chicuase quiman pilhuaya Elisabet, quitilanic Dios in lanahuatini Gabriel pa se caltilan itoca Nazaret pin lalticpan Galilea. ");
INSERT INTO nclNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Quitilanic pa quitas se sihual yancuic motocaya María. Yahuiaya monamicti María ca se lacal motocaya José. Yihual José yec imiahuil in hué David hual yulini pa yina. ");
INSERT INTO nclNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Calaquic in lanahuatini capa María, quilic: —Nimitzpialtía, tehual hual Dios yahui mijchihuilía len niman cuali. In Tata unca ca tehual, yahui mijchihuilía len hual unca hué. Mochi in lachihualisli hual quinchihuilía moxtin oc sequin sihuames amo quiman cataya yojque hué. ");
INSERT INTO nclNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mocahuac quiztataya María quiman quinotzac in lanahuatini, moilic laijtic pa iyolo: —Axcan, ¿leca yojque nechpialtitihuala in se? ");
INSERT INTO nclNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Cuaquinon in ilanahuatini in cielo (ilhuicac) quilic: —María, amo ximomajti, pampa tehual tía ticpía len niman cuali hual mitzmacas Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Axcan, tipilhuas huan ticpías se xolol huan tictocayaltis Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yihual yes hué, quitocayaltisqui ixolol in niman hué hual chanti niman míac pa pani pin cielo. Huan Dios in Tata quimacas ilahueliltilisli pa huelitis ca yehuanten pa Israel. Cayas yojque quinami quipiani in lahueliltilisli pa yina in hué David hual yec itajtzin motajtzitzían, yihual yulini niman pa yina. ");
INSERT INTO nclNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Huan tehual moxolol huelitis ca yehuanten ilacames Jacobo, cate yehuanten pa Israel, huan amo quiman lamis ilahueliltilisli yihual. ");
INSERT INTO nclNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Cuaquinon María quilajlanic in lanahuatini, quilic: —¿Quinami huil nechpanus inon? Pampa amo nicpía nolahuical. ");
INSERT INTO nclNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Quinanquilic in lanahuatini, quilic: —Hualas in Espíritu Santo mopan, huan ilahueliltilisli yihual hual chanti niman pa pani pin cielo mitzyahualus quinami ilasehuán se mextemil. Yojque mitzhueliltis pa ticlacatiltis. Pampín, in se hual lacatis pa tehual cayas lalalili pa quichías Dios ilachihualisli niman hué, quilalilic pa cayas pa yihual pan lalticpan. Pampín, quitocayaltisqui ixolol Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Huan noje Elisabet mocni pa oc se cali yahui quipía se xolol lacal, mas que axcan moviejojtic. Quema, huan axcan quipía chicuase mesli pilhuatica. Huan lacames quijtunijme yihual amo quiman yahuiaya quipía se xolol. ");
INSERT INTO nclNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ma yoje, ca Dios amo unca nindeno hual amo huil quichía. ");
INSERT INTO nclNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Cuaquinon María quilic: —Xiquita, nehual itequipanujquil in Tata. Ma nejchihuili quinami tichilic. Cuaquinon quisac capa María ilanahuatini in cielo. ");
INSERT INTO nclNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Pa in tonalijmes ejsehuic uyac María pa se caltilan pin lalticpan Judea, pin lali pani. ");
INSERT INTO nclNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Calaquic pa ichan Zacarías huan quipialtic Elisabet. ");
INSERT INTO nclNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Huan yojque panuc quiman Elisabet quicaquic quipialtic María, cuaquín tzicuinic in xolol laijtic capa iyolo Elisabet, quitemiltic Elisabet in Espíritu Santo. ");
INSERT INTO nclNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Cuaquinon ca se lajtol chicahuac, quitzajtzilic: —Dios mijchihuilic míac hual niman cuali. Yoje míac amo quiman quinchihuilic moxtin oc sequin sihuames. Huan Dios quichihuilis moxolol lachihualisli hué, hual amo quinchihuilis oc sequin, pampa quipías mochi lasojlalisli pa in lalticpan huan pin cielo. ");
INSERT INTO nclNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Huan ¿len yes nechpanujtica? ¡Inantzin noTata nechpaxaluilijtica! ");
INSERT INTO nclNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Xiquita, jan ajnaxcan nimitzcaquic tinechpialtic, cuaquín tzicuinic ca paquilisli in xolol laijtic capa nehual. ");
INSERT INTO nclNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tiyuli niman ca paquilisli pampa ticneltocac in hual mitzilic in Tata, huan yahui mochía in lajtol hual quijtuc. ");
INSERT INTO nclNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Cuaquinon María quilic: Laijtic capa nehual niquijtúa lajtomes huejué pa in Tata, ");
INSERT INTO nclNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","huan quipía paquilisli noyolo pampa Dios nechquixtía pin polehuilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Unca pampa Dios nechitac cuali nehual hual itequipanujquil, nehual hual amo nilapía. Huan xiquita, pejtica axcan pa mochi xixihuil, moxtin lacames huan yehuanten hual lacatisqui laquetzasqui hué nonahuac nehual. Quijtusqui pampa nehual nicanac ilachihualisli cuali Dios, quijtusqui quinami Dios nechtuchíac. ");
INSERT INTO nclNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","In Dios hual quipía mochi lahueliltilisli, yihual nejchihuilic len hué. Huan yihual unca niman hué huan amo quimacahuiltía pa cayas laijlaculisli capa yihual. Pampín tehuanten tohuían amo huil tiajsilo ca yihual. ");
INSERT INTO nclNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Quinmicnilía yehuanten hual yulinijme pa yina huan yehuanten hual yulilo axcan huan pa mochi xixihuimes hual ajsitihualalo. Quema, quinmicnilía yehuanten hual quimatilo momajtilo ilaixpan yihual. ");
INSERT INTO nclNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ca ilahueliltilisli imajma quinchihuac innojen hual niman huejué: quincholultic yehuanten hual quijtuloaya pa inminyolo pampa yehuanten huejueyenten. ");
INSERT INTO nclNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Quinquixtic lacames chijchicahuac pa capa huelitiloaya, huan yehuanten hual tijtipichin quinlalic capa huil canaloaya lasojlalisli. ");
INSERT INTO nclNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Quinmacac míac yehuanten hual quimatiloaya pampa monequi pa Dios quinpalehuis. Huan quincholultic iyampa yihual amo quipixtataloaya nindeno yehuanten hual quijtuloaya pampa amo monequiaya pa Dios quinpalehuisquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Quinpalehuía yehuanten pa Israel, yehuanten hual cate itequipanujquimes, quijnamiquic quinmicnilic. ");
INSERT INTO nclNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Quinchihuilic jan quinami quinmilic totajtzitzían, quinami quinmilic Abraham huan imiahuimes pa yina huan pa axcan huan pa quiman. ");
INSERT INTO nclNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María mocahuac chantitataya ye mesli ca Elisabet, cuaquinon uyac pa ichan. ");
INSERT INTO nclNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Cuaquinon, ajsic in tonali capa yahuiaya quipía ixolol Elisabet huan quilacatiltic se xolol lacal. ");
INSERT INTO nclNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Quimatijque ichantinijmes huan icnían quinami in Tata quichihuilic len cuali niman hué. Pampín hualajque quipaxaluilijque yehuanten, quipilijtataloaya yihual paquilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Cuaquinon, panuc in chicue tonalijmes, huan quipialoaya pa quitequililosquiaya nadita icuilaxli in xolol, quinami monequi pa quichihuasqui in judíos ca inminxolomes lacames, huan yahuiloaya quitocayaltilo in xolol Zacarías, yojque quinami motocaya itajtzin. ");
INSERT INTO nclNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Huan inantzin Elisabet quinmilic: —Amo tictocayaltisqui yoje, tictocayaltisqui Juan. ");
INSERT INTO nclNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Huan quilijque: —Amo unca se anmocnían hual motoca yoje. ");
INSERT INTO nclNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Pampín quilajlaniloaya Zacarías ca inminmajmajuan quinami yihual quinequiaya pa motocasquiaya ixolol. ");
INSERT INTO nclNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Huan Zacarías molajlanilic se amal huan quijcuiluc: “Juan itoca.” Huan moxtin mocahualoaya moiztataloaya. ");
INSERT INTO nclNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Cuaquinon quilapuc icamac Zacarías huan jan ajnaxcan inejnepil huil lajtuaya, pehuac quijtuc lajtomes huejué pa Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Huan pehualoaya momajtilo moxtin in chantinijmes. Pa mochi in lali pa pani ilomera (itepetilan) in lalticpan Judea, moxtin pehualoaya moililo inahuac in hual panuc. ");
INSERT INTO nclNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Huan moxtin yehuanten hual quimatijque quinami panujque innojen quijnamictiahuiloaya laijtic inminyolo, quijtuloaya: —Axan, ¿len yahui caya ca in xolol? Pampa cataya neli Dios ilahueliltilisli cataya ca yihual. ");
INSERT INTO nclNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Huan in Espíritu Santo quitemiltic Zacarías itajtzin in xolol Juan, quilaquetzaltic ilajtomes in Espíritu Santo, huan quilic: ");
INSERT INTO nclNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ma cayacan lajtuli lajtomes huejué pa in Tata, iDios Israel, pampa techitac pa techpalehuis huan pa laxlahuis pa tiyelosquiaya lamacahuali tehuanten ilacames. ");
INSERT INTO nclNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Quitilanía se hual quipía mochi lahueliltilisli pa techquixtis pin polehuilisli. In se unca imiahuil in hué David hual yec itequipanujquil Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Unca jan quinami Dios lajtuc pan inminpampa ilajtunijmes hual lajtujque pa yina, yehuanten quinlalilic pa quijtus ilajtol. ");
INSERT INTO nclNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Quijtuc pampa in se yahuiaya techquixti pin itemajquil tomocualantinijmes huan pin ilahueliltilisli moxtin hual amo techixtocalo. ");
INSERT INTO nclNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Quijtuc pampa yojque yahuiaya quinmicnili totajtzitzían. Yoje quijnamiquic in lajtol hual quijtuc pampa yahuiaya tejchihuili yihual ihuían. ");
INSERT INTO nclNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Dios quimacac Abraham totajtzin in lajtulisli ca lajtomes hual amo quinpalas. ");
INSERT INTO nclNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Quimacac pa yoje techquixtisquiaya pa inminlahueliltilisli tomocualantinijmes. Yojque yajmo ticpialosquiaya pa timomajtilosquiaya inminpampa yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Quimacac in lajtol hual techilía quinami yahuiaya tejchihuili pa huil tictequipanuililosquiaya Dios ca toyolo lachipahuali, pa huil ticchihualosquiaya in hual Dios quixtoca pa ticchihuasi mochi in tonalijmes hual tiyulilo. ");
INSERT INTO nclNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Huan tehual, noxolol, mitztocayaltisqui ilajtuni in Dios hual chanti niman pa pani pin cielo, pampa ticlaicanas in Tata pa ticchijchihuilis iojli. ");
INSERT INTO nclNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","In quinequi quijtúa tehual tía tiquinlamachiltía ilacames Dios quinami Dios yahui quinquixtía pin polehuilisli. Huan yoje quinquixtía, cayas pampa quinpujpuhuilía inminlaijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","In unca pampa toDios quixtoca laicnilía. Pampín Dios techita capa unca pa niman pani pin cielo, unca quinami ilaixpelalisli in huajtzinquito. ");
INSERT INTO nclNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Techixpela tehuanten hual ticate pin laticumac, tehuanten hual tichantilo capa unca quinami ilaticumactilisli in miquilisli, quinequi quijtúa, capa tiyulilo timomajtiticate pampa timiquisi. Axcan huil tilachialo cuali pa in ojli hual techhuicas capa ticayasi jan yoje ca Dios ca ilaijnamiquilisli huan imosehuilisli pa toyolo. Ticpiasqui mochi hual unca cuali pa tehuanten, mochi hual Dios quipía pa tehuanten huan quinequi techmaca. Techixpela pa techmelahuilis tocxihuajmes pan in ojli capa ticayasi jan yojque tilaijnamicticate quinami Dios huan capa ticayasi ticpixticate imosehuilisli pa toyolo. Umpa laquisac lajtuc Zacarías. ");
INSERT INTO nclNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Huan moscaltitiyahuiaya in xolol, cantiyahuiaya chicahualisli pa iyolo huan chantiaya capa amaqui oc se chantiaya. Panuje xixihuimes huan cuaquinon ajsic in tonali quiman Dios quitilanic pa quinnotzasquiaya quinmilijtataya yehuanten pa Israel ilajtol Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Cataya pa innojen tonalijmes in hué niman hué hual motocaya César Agosto quichijchihuac se lajtol pa quichihualosquiaya se ilapuhualisli moxtin hual umpa chantiloaya pa mochi in lali. ");
INSERT INTO nclNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","In lapuhualisli quichihuajque pa innojen tonalijmes hual Quirinio yec huelitini (gobernador) pin lali itoca Siria. In lapuhualisli cataya in calica yahuiloaya quipehualtilo ilapixcalisli tomin pa in hueyenten hual huelitiloaya. ");
INSERT INTO nclNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Huan yahuiloaya moxtin pa cayalosquiaya lasaluli pa in lasalulisli. Mochi sejse uyac pa in caltilan capa moxtin itajtzitzían lacatijque huan yulinijme. ");
INSERT INTO nclNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Huan José noje uyac pa inmincaltilan itajtzitzían hual cataya pin ilomera (itepetilan) in lalticpan Judea. Quisac pin caltilan tipichin Nazaret pin lalticpan Galilea, huan panquisac pa Judea pa icaltilan tipichin David, in caltilan itoca Belén. José yec imiahuil David, pampín uyac pa Belén. ");
INSERT INTO nclNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Huan lamiaya monamicti ca María hual pilhuatataya, amo huejcahuasquiaya pa lacatis ixolol. Huan José uyaje pa yesi lasaluli pin lasalulisli. ");
INSERT INTO nclNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Cataloaya pa Belén, huan ajsic in tonali pa lacatis ixolol María. ");
INSERT INTO nclNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Huan lacatic pan yihual se xolol lacal, ca yihual quipehualtic in xolomes hual quilacatiltic María. Quiliaruc ca se tzotzomajli huan quitecac pan se sacalera lanechiculi laijtic se lacomultic capa lacualoaya in burros. Yojque quichíac María pampa amo cataya capa huil mosehuilosquiaya pin cali. ");
INSERT INTO nclNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Huan cataloaya lacames hual quinmiztataloaya inminborregos pa layúa pin ixlahuitos itejtenco Belén. ");
INSERT INTO nclNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Huan nestiquisac inminlaixpan yehuanten ilanahuatini in Tata, quisac pin cielo (ilhuicac). Huan laixpelatiquisac ilaixpelalisli chicahuac in Tata quinyahualujtataya, huan momajmajtijque míac. ");
INSERT INTO nclNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Huan in lanahuatini quinmilic: —Amo ximomajtican. Xiquitacan, nehual nihuala pa annimitzlamachiltis se lamachiltilisli cuali hual anmitzmacas míac paquilisli, huan in lamachiltilisli cayas pa moxtin. ");
INSERT INTO nclNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Axcan anmitzlacatilic axcan se hual anmitzquixtis pin polehuilisli. Unca CRISTO in Tata, lacatic pa icaltilan David. ");
INSERT INTO nclNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Axcan annimitzilía quinami anquitas. Anquitemus huan anquitas se xolol iliarujtica ca se tzotzomajli huan lastica pan se sacalera pan se lacomultic calijtic capa lacualo in burros. ");
INSERT INTO nclNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Jan ajnaxcan ca in lanahuatini nestiquisajque míac oc sequin ilanahuatinijmes in cielo, quijtutataloaya lajtomes huejué pa Dios, quijtuje: ");
INSERT INTO nclNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Xiquijtucan lajtomes huejué huan cuajcualtichin pa Dios hual chanti niman pa pani pin cielos, huan pan in lalticpan ma yulican ca mosehuilisli quipixticate in hual Dios quinmacasquiaya yehuanten hual yihual quinpilía paquilisli! ");
INSERT INTO nclNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Cuaquín in lanahuatinijmes quincahuajque innojen lacames hual quinmitaloaya inminborregos, uyaje pin cielo. Huan moilijque in lacames se ca oc se, quilijque: —Ma tiacan pa Belén pa tiquitasqui in hual axcan panuc, hual in Tata techlamachiltic. ");
INSERT INTO nclNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Cuaquín uyaje ejsejtataloaya, latemujque huan quinmitajque María huan José huan in xolol lastataya pan se sacalera capa lacuanijme in burros. ");
INSERT INTO nclNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Quinmitajque in yeyenten, quinlamachiltijque in hual ilanahuatini in cielo (ilhuicac) quinmilic inahuac in xolol. ");
INSERT INTO nclNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Huan moxtin hual quicaquijque, mocahualoaya moiztataloaya ca lamajtilisli pampa quinmajtic inon hual quinmililoaya inminlaitanijmes in borregos. ");
INSERT INTO nclNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ma yoje, María cajcoquiaya mochi innojen laijtic capa iyolo, mojmosta quijnamiquiaya mochi hual panuc. ");
INSERT INTO nclNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Huan mocuepaje pa inminborregos in laitanijmes quijtutataloaya lajtomes huejué pa Dios. Quijtutataloaya mochi hual cuali inahuac yihual, pampa quicaquijque huan quitajque mochi jan quinami quinmilic ilanahuatini in cielo (ilhuicac). ");
INSERT INTO nclNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Cuaquinon, quiman quinpiaya chicue tonalijmes quiman lacatic Jesús, quitequilijque nadita icuilaxli huan quitocayaltijque JESÚS, quinami ilanahuatini in cielo quilic María pa quitocayaltilosquiaya pa in tonali hual ayamo pehuaya moscalti in xolol laijtic María inantzin. ");
INSERT INTO nclNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ajsic in tonali hual María quipiaya pa yes lachipahuali, quinami quijtúa ilajtol Moisés: Quijtúa pampa moxtin sihuames hual quilacatiltic se xolol quipialo pa mochipahuasi. Pampín, panquisajque pa Jerusalén itajtzitzían pa quinextilisqui in xolol Jesús ilaixpan in Tata Dios nepa pin tiopan hué. ");
INSERT INTO nclNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Quichihuajque inon pampa yojque unca lajcuiluli pa ilajtol in Tata: “Sinda unca lacal se xolol calica se sihual quinpehualtía ixolomes hual quinlacatiltía, cuaquín yihual unca lalalili pa yes iyaxca in Tata.” ");
INSERT INTO nclNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Huan itajtzin huan inantzin noje quilalilijque Dios in huendi pa María ilachipahualisli, quinami quijtúa ilajtol in Tata: In huendi yes ome huilomes o ome pichones sejselic. ");
INSERT INTO nclNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Huan xiquitacan. Cataya se lacal pa Jerusalén itocaya Simeón, yihual se lacal cuali, quilasojlaya in Tata huan cataya in Espíritu Santo laijtic capa yihual iyolo. Axcan quipiaya míac yihual mochixtataya pa quiman yahuiaya ajsi in Cristo hual Dios yahuiaya quitilani pa quinquixtisquiaya yehuanten pa Israel pin polehuilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Huan in Espíritu Santo quilamachiltic Simeón pampa yahuiaya quita in Tata Dios iCristo hual in Tata Dios quilalilic pa hualasquiaya pa in lalticpan. Quilic pampa yahuiaya quita iCristo huan amo miquisquiaya sinda ayamo quitac. ");
INSERT INTO nclNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Huan in Espíritu Santo quichihuilic Simeón pa quimatis pa iyolo pampa monequiaya pa yas pa in tiopan hué. Huan nepa ajsije José huan María pa quichihuililosquiaya ca in xolol Jesús quinami in lajtol quijtuc pa quichihuililosquiaya yihual. ");
INSERT INTO nclNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Cuaquinon Simeón canac huan quimacuic in xolol, quijtuc lajtomes huejué pa Dios huan quilic: ");
INSERT INTO nclNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Axcan, Tata Hué, xinechtilani pa nimiquis ca paquilisli quinami tinechilic. ");
INSERT INTO nclNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Axcan niquitac ca noixtololojmes yihual hual tictilanic pa techquixtilis in miquilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ticchijchíac inminlaixpan moxtin pa Israel. ");
INSERT INTO nclNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yihual yes quinami lahuilisli pa mitznextis tehual, Dios, ca yehuanten hual amo lacatijque israelitos, pa mitziximatisqui yehuanten. Huan yes quinami laixpelalisli chicahuac pa quinnextilis yehuanten pa mochi in lalticpan in míac lachihualisli cuali, hual tehual, Dios, tiquinchihuilic in israelitos hual moyaxca yehuanten. Yojque quijtuc Simeón. ");
INSERT INTO nclNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Huan itajtzin huan inantzin in xolol Jesús mocahualoaya moizticate pampa quijtuaya Simeón innojen lajtomes inahuac in xolol Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Cuaquinon quinlaquetzilic cuali Simeón, quintuchihuaya, huan yihual quilic inantzin María, quilic: —Xiquita. In xolol Dios quilalía ca tehuanten pa Israel huan yihual quinchihuilis pa míac ca yehuanten miquisqui amo lachipahuali ipampa inminlaijlaculisli, huan míac yesi laquixtili pin ipolehuilisli inminlaijlaculisli. Noje Simeón quilic: —Yihual in xolol yes se hual míac amo quinequisqui quineltocasqui pampa Dios quitilanic. Pampa inon, amo quinequisqui quineltocasqui inon hual quinmilis. ");
INSERT INTO nclNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Yojque momatis quinami yehuanten laijnamiquilo laijtic inminyolo. Huan tehual, María, yahui mitzcocúa moyolo pampa panus mochi inon. ");
INSERT INTO nclNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nepa noje cataya Ana, ixolol sihual Fanuel. Yihual Fanuel imiahuil se hual motocaya Aser. In Aser yulini pa yina, yihual yec se ca Israel ixolomes hual imiahuimes huan inminmiahuimes in oc sequin ixolomes Israel mochihuaje yehuanten ilacames Israel, yehuanten in judíos. Huan in sihual Ana yec se ilajtuni Dios, cataya niman ilamantzita. ");
INSERT INTO nclNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Huan ilahuical chantije chicome xixihuil, cuaquín ilahuical polehuic. Huan mocahuac Ana ihuían pa nahuipuhualihuanahui (ochentaicuatro) xixihuil. In Ana mojmosta pa semilhuil cataya pin tiopan hué, amo quiman quisac huejca nepa, mosajtataya míac huan quilajlaniaya Dios mochi tonali, quimolancuacuetzilic yihualitonali, pa semilhuil huan pa layúa. ");
INSERT INTO nclNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Huan lamic laquetzac Simeón, jan ajnaxcan hualac capa yehuanten Ana, quisehuiaya Dios quijtutataya lajtomes huejué huan cuajcualtichin pa yihual, quinlaquetziliaya inahuac in xolol, quinlaquetziliaya moxtin hual quichixtataloaya in tonali hual Dios yahuiaya quilaxlahui inminlamacahualisli yehuanten in israelitos. ");
INSERT INTO nclNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Cuaquinon laquisajque quichihuajque José huan María mochi quinami quijtúa ilajtol in Tata, mocuepaje pa in lalticpan Galilea pa Nazaret inmincali yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Huan moscaltiaya in xolol Jesús, mochicahualtitiahuiaya ca míac lajmatilisli huan Dios quichihuilijtiahuiaya cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Itajtzitzían Jesús yahuiloaya xijxixihuil pa Jerusalén pa cayalosquiaya pin fiesta (ilhuil) capa quicualo in judíos inacal borrego pa quijnamiquisqui quinami Dios quinquixtic in israelitos pin Egipto. Quinquixtic pa yina capa yehuanten pin lali Egipto hual quinchihuaje tequipanujquimes hual amo quinlaxlahuilinijme. ");
INSERT INTO nclNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Cuaquinon, quiman Jesús moscaltic huan quinpiaya doce xixihuimes, yehuanten yeyenten panquisajque pa Jerusalén pa cayalosquiaya pa in fiesta, quinami quichihuanijme mochi xixihuil. ");
INSERT INTO nclNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Huan quiman laquisajque inmintonalijmes in fiesta (ilhuil), mocuepaloaya itajtzitzían. Ma yoje, mocahuac Jesús in xolol pa Jerusalén, huan amo quimatiloaya itajtzitzían. ");
INSERT INTO nclNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Quijtuloaya pampa yihual cataya ca in oc sequin míac hualca yehuanten canaloaya ojli. Yoje cataloaya pan ojli se tonali huan pehuajque quitemujque ca inmicnían huan inminchantinijmes hualca yehuanten cataloaya pa ojli. ");
INSERT INTO nclNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Huan pampa amo quitajque, mocuepajque pa Jerusalén quitemujtiajque. ");
INSERT INTO nclNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Cuaquinon, quiman panuje ye tonalijmes quiman mocahuac Jesús pa Jerusalén, itajtzitzían quitajque pin tiopan hué, molalijtataya lajco pa in lamaxtinijmes, quincactataya huan quinlajlantataya. ");
INSERT INTO nclNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Huan mocahualoaya moizticate moxtin hual quicaquiloaya, mocahualoaya yoje pampa quicaquiloaya quinami yihual quimatiaya huan quinami quinnanquiliaya. ");
INSERT INTO nclNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Huan quipolujque inminlajtol itajtzitzían nepa capa quitajque. Cuaquín inantzin quilic: —Noxól, ¿leca yoje titejchihuilic? Xiquita. Motajtzin huan nehual timitztemujtinemiloaya, techcocojtinemiaya toyolo. ");
INSERT INTO nclNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Huan Jesús quinmilic: —¿Len inon? ¿Annechtemujtinemiaya? ¿Amo anquimatiaya pampa nehual nicpía pa nicayas capa cate lachihuali innojen hual cate iyaxca noTajtzin? ");
INSERT INTO nclNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Amo quimatiloaya yehuanten len quinequiaya quijtu inon hual quinmilic. ");
INSERT INTO nclNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Cuaquín temujtíac ca yehuanten pa Nazaret huan yihual yuliaya quinneltocatataya itajtzitzían. Ma yoje, inantzin sejpa huan oc sejpa quinmijnamictiahuiaya mochi innojen laijtic pa iyolo. ");
INSERT INTO nclNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Huan cantiyahuiaya Jesús míac lajmatilisli huan moscaltitiyahuiaya hué. Huan yultiahuiaya quinami Dios quinequi huan moxtin quixtocaloaya míac. ");
INSERT INTO nclNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Quipiaya quince xixihuil yihual huelitijtiahuiaya in hué niman hué motocaya César Tiberias pa Roma. Huan Poncio Pilato yec huelitini romano pin lalticpan Judea, Herodes huelitiaya pin lalticpan Galilea, huan icni Felipe huelitiaya pin lali capa cataloaya in lalticpan Iturea huan in lalticpan Traconite. Lisanias huelitiaya pin lalticpan Abilinia. ");
INSERT INTO nclNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás huan Caifás yeje in tiopistas huejué. Pan in tonalijmes, Dios quitilanic Juan ixolol Zacarías pa quinnotzas in lacalera. Chantiaya Juan capa amaqui oc sequin chantiloaya. ");
INSERT INTO nclNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yoje uyac Juan lanojnoztinemiaya pa mochi in lali itenco in atenco hué itoca Jordán, quinmilijtinemiaya yehuanten pa mopatililosquiaya inminyolo pa pehualosquiaya laijnamiquilo quinami Dios quinequi. Yoje huil cayalosquiaya lacuayatequili, yoje yelosquiaya lapujpuhuali inminlaijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Cataya quinami yec lajcuiluli pa in amal hual quijcuiluc Isaías ilajtuni Dios pa yina, quijtuc: Mocaqui se hual tzajtzitica pin lali capa amaqui chanti, quilía: “Xicchijchihuilican iojli in Tata, xiquinchihuacan melahuac iojlitos. ");
INSERT INTO nclNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mochi lali hual unca pa temuán cayas latemiltili ca lali, huan mochi loma (tepel) huan lomita (tepetzindi) mochihuasqui ixlán. Ojlimes pandera mochihuasqui ojlimes mejmelahuac. Ojlimes huajuahuastic mochihuasqui ojlimes ajꞌalastic. ");
INSERT INTO nclNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Cuaquinon moxtin quitasqui yihual hual Dios quitilanía pa quinquixtilis ipolehuilisli inminlaijlaculisli.” Yojque unca lajcuiluli pin iamal Isaías. ");
INSERT INTO nclNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yoje, míac quisajque pa míac caltilan pa quincuayatequis Juan nepa pa in atenco hué Jordán. Cuaquín Juan quinmilic: —¡Amhuanten quinami cuhuames hual lapajuilo! ¿Anquijtúa sinda annimitzcuayatequis, cuaquín ancayas laquixtili pin polehuilisli quiman cualani Dios? No, amo yoje. Anquipía pa anyulis anquichijtías len unca cuali, pa yoje anquinnextilis Dios huan lacames pampa ca melahualisli anquipalac anmoyolo pa anpehuas anlaijnamiquis quinami Dios quinequi. ");
INSERT INTO nclNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Huan amo xipehuacan ximoilican laijtic pa anmoyolo pampa amhuanten anunca imiahuimes Abraham totajtzin huan pampín Dios amo anmitztojtocas ilaixpan yihual. Nehual annimitzilía pampa Dios huil quinchía lacames ca in tixcalimes nican hual yelosquiaya imiahuimes Abraham. ");
INSERT INTO nclNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Axcan unca lalalili Dios pa anmijxitinis anmonapatilisli. Unca quinami se hacha hual quilalilo pa ilalhuayol se cuahuil. Sinda amo quipía laquilyo cuali in cuahuil, cuaquín quimayahuisqui huan quilasasqui pin tixuxli. Huan jan yoje sinda amo quipala iyolo se pa laijnamiquis quinami Dios quinequi, cuaquín Dios quichihuilis quinami quichihuililo in cuahuil hual amo quipía laquilyo cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Huan quilajlanijque Juan innojen míac lacames, quilije: —¿Len ticchihuasqui tehuanten? ");
INSERT INTO nclNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Quinnanquilic Juan: —Sinda se quipía ome cotones, ma quimaca se pa yihual hual amo quipía se cotón. Huan sinda se quipía len quicua hual mocajtica, ma quimaca yihual hual mayana. ");
INSERT INTO nclNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Hualajque noje lacames hual canaloaya ilapixcalisli in tomin pa in hueyenten romanos. Hualajque pa yelosquiaya lacuayatequili, quilajlanijque: —Lamaxtini, ¿len ticchihuasqui pa tilanextilisqui pampa ticpalaje toyolo pa tipehuasi tilaijnamiquisqui quinami Dios quinequi? ");
INSERT INTO nclNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan quinmilic: —Jan xicpixcacan in tomin san hual anmitzlalililo yehuanten hual huelitilo. ");
INSERT INTO nclNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Noje quilajlanije in guaches hual quinlaquehuajque in lacames hual huelitiloaya, quilije: —¿Len ticchihuasqui tehuanten noje? Huan quinmilic: —Amo xijquixtilican nindeno amaqui, amo pan ipampa quinami anquinmacajsía ca in lacocoltilisli hual huil anquinchihuilía sinda amo quichihualo quinami anquinequi. Huan amo xiquinmacajsican pan ipampa quinami cuajnesi anquinmotexpahuilía inahuac len amo quichihuaje. Huan ximopaquiltican san ca in hual anmitzlaxlahuilo anmotecojuan. ");
INSERT INTO nclNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Quijtuloaya moxtin yehuanten pampa Dios yahuiaya quitilani iCristo huan pampín quichialoaya. Quinequiloaya quimatilo da cuajnesi yesquiaya Juan in Cristo, pampa quijnamictinemiloaya laijtic pa inminyolo mochi hual quitaje hual quichihuaya Juan. ");
INSERT INTO nclNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Huan Juan quinnanquilic moxtin, quinmilic: —Nehual annimitzcuayatequía ca al. Ma yoje, hualas se hual quipía niman míac lahueliltilisli hual nel amo nicpía. Huan nehual amo nimonotza pa yes noyaxca pa nictomilis ilailpili ilacsames pa icxihuajmes. Yihual anmitzcuayatequis ca in Espíritu Santo, unca quinami tixuxli hual lachipahua. ");
INSERT INTO nclNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Huan yihual quinxilus yehuanten hual quineltocalo Dios pa camo cayasi ca yehuanten hual amo quineltocalo. Yes quinami yihual quipiasquiaya se latzejtzeluloni pa imajma calica quichipahuililo in trigo pa quisas in xiníul. Quimontus in trigo pa capa cajcoquilo huan in xiníul quilasas huan quichichinus pin tixuxli hual amo quiman sehuis. ");
INSERT INTO nclNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yojque Juan quinnoztinemiaya yehuanten pa quinmilisquiaya len quipialoaya pa quichihualosquiaya. Yihual quinlaquetzilijtinemiaya míac huan ca oc sequin lajtomes pa quinchicahualtisquiaya yehuanten. Yojque quinlaquetziliaya in lacames ca in lamachiltilisli cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Huan Herodes in hué cualanic ca Juan. Cataya pampa Juan cajuac inminlaixpan moxtin in lacames, cajuac pampa Herodes canac Herodías. In Herodías yec isihua Felipe huan Felipe yec icni Herodes in hué. Juan noje cajuac Herodes pampa quinchihuaya míac oc sequin lachihualisli amo cuajcuali. ");
INSERT INTO nclNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Cuaquinon mocuepac quichíac Herodes oc se lachihualisli amo cuali. Latilanic pa quitzacualosquiaya Juan pin calijtic. ");
INSERT INTO nclNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ayamo latilanic pa quitzacualosquiaya Juan pin calijtic, huan pampín, Juan ayamo mocahuaya pa quincuayatequisquiaya lacames. Juan noje quicuayatequic Jesús. Quiman laquisac cayac lacuayatequili, yihual Jesús quilajlantataya Dios, huan molapuc in cielo (ilhuicac). ");
INSERT INTO nclNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Temujtihualac in Espíritu Santo nestihualaya quinami se huilol. Moquetzac ipan capa yihual, huan quicaquiloaya moxtin se lajtol pin cielo (ilhuicac), quijtuc: —Tehual noxolol hual nimitzlasojla, ca tehual nicpía míac paquilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús axcan moscaltic huan pehuaya quinpía quinami treinta xixihuil. Moxtin quijtujque pampa yihual yec ixolol José. ");
INSERT INTO nclNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Huan José yec ixolol Elí. Elí yec ixolol Matat, Matat yec ixolol Leví, Leví yec ixolol Melqui, Melqui yec ixolol Jana, Jana yec ixolol José. ");
INSERT INTO nclNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José yec ixolol Matatías, Matatías yec ixolol Amós, Amós yec ixolol Nahum, Nahum yec ixolol Esli, Esli yec ixolol Nagai. ");
INSERT INTO nclNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai yec ixolol Maat, Maat yec ixolol Matatías, Matatías yec ixolol Semei, Semei yec ixolol José, José yec ixolol Judá. ");
INSERT INTO nclNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá yec ixolol Joana, Joana yec ixolol Resa, Resa yec ixolol Zorobabel, Zorobabel yec ixolol Salatiel, Salatiel yec ixolol Neri. ");
INSERT INTO nclNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri yec ixolol Melqui, Melqui yec ixolol Adi, Adi yec ixolol Cosam, Cosam yec ixolol Elmodam, Elmodam yec ixolol Er. ");
INSERT INTO nclNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er yec ixolol Josué, Josué yec ixolol Eliezer, Eliezer yec ixolol Jorim, Jorim yec ixolol Matat, Matat yec ixolol Leví. ");
INSERT INTO nclNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leví yec ixolol Simeon, Simeon yec ixolol Judá, Judá yec ixolol José, José yec ixolol Jonán, Jonán yec ixolol Eliaquim. ");
INSERT INTO nclNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim yec ixolol Melea, Melea yec ixolol Mainán, Mainán yec ixolol Matata, Matata yec ixolol Natán, Natán yec ixolol David. ");
INSERT INTO nclNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David yec ixolol Isaí, Isaí yec ixolol Obed, Obed yec ixolol Booz, Booz yec ixolol Salmon, Salmon yec ixolol Naasón. ");
INSERT INTO nclNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón yec ixolol Aminadab, Aminadab yec ixolol Aram, Aram yec ixolol Esrom, Esrom yec ixolol Fares, Fares yec ixolol Judá, Judá yec ixolol Jacob. ");
INSERT INTO nclNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jacob yec ixolol Isaac, Isaac yec ixolol Abraham, Abraham yec ixolol Taré, Taré yec ixolol Nacor. ");
INSERT INTO nclNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor yec ixolol Serug, Serug yec ixolol Ragau, Ragau yec ixolol Peleg, Peleg yec ixolol Heber, Heber yec ixolol Sala. ");
INSERT INTO nclNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala yec ixolol Cainán Cainán yec ixolol Arfacsad, Arfacsad yec ixolol Sem, Sem yec ixolol Noé, Noé yec ixolol Lamec. ");
INSERT INTO nclNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec yec ixolol Matusalén, Matusalén yec ixolol Enoc, Enoc yec ixolol Jared, Jared yec ixolol Mahalaleel, Mahalaleel yec ixolol Cainán. ");
INSERT INTO nclNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán yec ixolol Enos, Enos yec ixolol Set, Set yec ixolol Adán, Adán yec ixolol Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Huan in Espíritu Santo quinejnemiltiaya Jesús nepa quiman quisac pin atenco hué Jordán pa mocuepasquiaya, huan quitilanic capa amaqui chantiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nepa in lili quitilanilic iyolo pa quichihuasquiaya len Dios amo quinequi, quitilaniliaya iyolo pa ompuhuali (cuarenta) tonalijmes. In tonalijmes amo quicuaya Jesús nindeno, huan quiman panuje in tonalijmes, yihual mayanaya. ");
INSERT INTO nclNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Cuaquín in lili quilic: —Sinda tehual tiunca ixolol Dios, axan xiquili in tixcalimes pa mochihuasi len tijcuas. ");
INSERT INTO nclNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Cuaquinon quinanquilic Jesús, quilic: —Yojque unca lajcuiluli pa ilajtol Dios, quijtúa: “Amo yulis se pan ipampa len quicua san, pampa in hual quicua se amo quichihuilía nindeno pa yulis se iyolo. No, se lacal yulis pan ipampa mochi lajtol hual Dios quijtúa.” ");
INSERT INTO nclNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Cuaquinon in lili quihuicac Jesús pa pani huan quinextilic ca jan se nadita san mochi in lalimes pin lalticpan ca inminlacalera huan inmintomin. ");
INSERT INTO nclNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Huan in lili quilic: —Tehual nimitzmacas mochi inon pa tiquinchihuilis quinami tehual ticnequis tiquinchihuilis, huan ticpías mochi len cuali hual moitas pa yehuanten. Huil nimitzmaca inon pampa unca noyaxca pa nicmacas aqui yes nicnequis nicmacas. ");
INSERT INTO nclNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Huan nimitzmacas mochi inon sinda tehual tinechmolancuacuetzilis. ");
INSERT INTO nclNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Huan Jesús quinanquilic: —Yojque unca lajcuiluli, quijtúa: “Ticmolancuacuetzilis jan in Tata moDios san, huan jan yihual san tictequipanuilis.” ");
INSERT INTO nclNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Cuaquinon in lili quihuicac Jesús pa Jerusalén huan quilalic pa pani pin tiopan hué huan quilic: —Sinda tehual tiunca Dios ixolol, ximolasa nican pan lali pa latzindan, ");
INSERT INTO nclNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","pampa yojque unca lajcuiluli ilajtol Dios, quijtúa: Dios quintilanis ilanahuatinijmes pin cielo pa mitziztiasi cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ca inminmajmajuan mitzajcoquisi pa camo timotecuas pan len tixcali mocxían. ");
INSERT INTO nclNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Huan quinanquilic Jesús, quilic: —Huan yojque unca lajtuli: “Amo timolalis capa cuajnesi tipolehuis jan pa yoje ticmatis sinda in Tata moDios mitzquixtis pin polehuilisli.” ");
INSERT INTO nclNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Cuaquinon in lili lamic quitilanilic Jesús iyolo, mijcuanic nepa capa Jesús, yahuiaya quichía pa se tonali quiman huil quitilanilisquiaya iyolo oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Cuaquinon mocuepac Jesús pa in lalticpan Galilea, quipixtataya ilahueliltilisli in Espíritu Santo. Huan momachiltijque pampa yihual panujtataya cajcapa pa mochi itenco in lali capa yes nejnentinemiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yihual lamaxtitinemiaya pa mochi inmintiopajmes, huan moxtin quijtuloaya lajtomes huejué pa yihual. ");
INSERT INTO nclNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Huan uyac Jesús pa Nazaret capa itajtzitzían quiscaltijque, calaquic pa inmintiopan quinami quichihuaya pan mochi in tonalijmes hual mosehuilo in judíos huan yalo pa tiopan. Huan nepa Jesús moquetzac pa momaxtis. ");
INSERT INTO nclNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Quimacajque in amal hual quipía laijtic len quijcuiluc pa yina Isaías ilajtuni Dios. Quilapuc Jesús in amal, quitac capa yec lajcuiluli yojque: ");
INSERT INTO nclNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","In Tata iEspíritu unca ca nehual pampa nechlalic yihual pa niquinmilis lamachiltilisli cuali yehuanten hual quimatilo pampa monequi pa Dios quinpalehuis. Nechtilanic pa niquinnahuatis pampa cate lamacahuali yehuanten hual Satanás quinpía lailpili. Nechtilanic pa niquinnahuatis in pachacames pampa yalo lachialo oc sejpa. Nechtilanic pa niquinmacahuas yehuanten hual inminlaijlaculisli quinxacualuilijque inminyolo, nechtilanic pa yojque yesi lachijchihuali yancuic. ");
INSERT INTO nclNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nechtilanic pa nilanahuatis pa quimatisqui pampa axcan in xihuil unca quiman Dios ca míac paquilisli quinequi quinchihuilía moxtin ilachihualisli cuali niman hué hual san yihual huil quinchihuilía. ");
INSERT INTO nclNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Cuaquinon quitzacuac Jesús in amal, quimacac in se hual cajcoquiaya in amal, cuaquinon molalic, huan mocahuajque quiztataloaya moxtin hual cataloaya pin tiopan calijtic. ");
INSERT INTO nclNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Cuaquinon pehuac quinlaquetzilic Jesús, quinmilic: —Axcan lamic mochíac in lajcuilulisli hual anquicaquic nimomaxtic. ");
INSERT INTO nclNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Huan moxtin quijtuloaya neli pampa cataloaya cuali ilajtomes, mocahualoaya moiztataloaya pampa quinlaquetzilijtataya in lajtomes. Cuaquinon pehualoaya quijtulo: —¿Amo in se ixolol José? ");
INSERT INTO nclNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Cuaquinon Jesús quinmilic: —Neli amhuanten annechilis in lajtol hual quijtulo míac, annechilis: “Lapajtini, ximopajti tehual.” Huan annechilis: “Ticmatijque in hual ticchíac pin caltilan Capernaúm. Axan xicchía jan yoje nican pa mocaltilan capa timoscaltic.” Yoje annechilis. ");
INSERT INTO nclNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Huan quinmilic: —Annimitzilía neli pampa yehuanten pin caltilan capa moscaltic se ilajtuni Dios amo quineltocalo in lajtuni sinda yihual quinmilía ilajtol Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Huan annimitzilía len melahuac: Cataloaya pin lali Israel míac sihuames inminhuían nepa capa yulini Elías ilajtuni Dios, cataya pin tonalijmes hual amo quiahuiaya pa ye xixihuil huan lajco. Huan cataya se mayandi pa mochi in lali. ");
INSERT INTO nclNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ma yoje, Dios amo quitilanic Elías pa se ca innojen sihuames inminhuían pin lali Israel. Jan quitilanic pa se sihual ihuían hual amo yulini nican. Quitilanic pa se hual chantiaya pin caltilan tipichin itoca Sarepta, umpa amo huejca cataya in caltilan hué Sidón. ");
INSERT INTO nclNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Huan cataloaya míac lacames pin lali Israel hual mococuloaya ca in cocolisli lepra pin tonalijmes quiman yulini Eliseo ilajtuni Dios. Ma yoje, Eliseo amo quipajtic se ca yehuanten. San quipajtic in lacal itocaya Naamán, yihual yulini pin lali Siria. ");
INSERT INTO nclNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Pampín cualanije míac moxtin pa in tiopan pampa quinmilic Jesús innojen lajtomes. ");
INSERT INTO nclNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Moqueztiquisajque, quiquixtijque Jesús pa quiahuac in caltilan, quihuicajque pa itenco in loma (tepel) capa cataya in caltilan. Yahuiloaya quilasalo pa in cuajtic nepa pa miquisquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ma yoje, yihual panuc lajco capa yehuanten huan uyac. ");
INSERT INTO nclNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Cuaquinon temuc pa Capernaum, se caltilan pin lalticpan Galilea, nepa lamaxtiaya mochi in tonalijmes hual mosehuilo in judíos. ");
INSERT INTO nclNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mocahualoaya moiztataloaya míac pampa ilajtomes hual quinmaxtiaya yehuanten quipialoaya ilahueliltilisli Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Huan pin tiopan cataya se lacal quipiaya se ijyecal amo cuali huan catzahuac, huan quitzajtzilic ca lajtol chicahuac, quilic: ");
INSERT INTO nclNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Ah tel! ¿Len ticpía ca tehuanten, Jesús in nazareteco? ¿Tihualaya pa titechlamisquiaya? Nicmati aqui tiunca tehual, tiunca in lacal lajtultili hual Dios quitilanic pa in lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús cajuac, quilic: —Amo xinahuati huan xiquisa pa quiahuac yihual. Jan axcan in ijyecal amo cuali quilasac in lacal lajco capa yehuanten, quisac pa yihual, amo quicocoltic nindeno. ");
INSERT INTO nclNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Huan momajtijque moxtin, moililoaya: —¿Len yes in lajtol hual quijtúa? Pampa ca ichicahualisli quinami quipía se lacal ca lahueliltilisli, yihual quinmilía in ijyecames amo cuajcuali huan quisalo pa laijtic yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Huan pa mochi cajcapa pa itejtenco in caltilan quilamachiltije inon hual quichíac Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Cuaquinon quisac pin tiopan, uyac pa ichan Simón, calaquic. Nepa quitac totontataya míac inantzin isihua Simón huan quilajlanijque Jesús pa quichihuilis len pa yihual. ");
INSERT INTO nclNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yoje hualac Jesús, moquetzac inahuac huan cajuac in totonalisli. Pampín mosejtiquisac in totonalisli huan jan ajnaxcan moquetzac in sihual huan quinyucxiltilic len pa quicuasi. ");
INSERT INTO nclNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Calaquiaya in tonali pa tiolac huan moxtin hual quipialoaya pa inminchan cocoxquimes ca len yes cocolisli quihualiquililoaya Jesús. Huan yihual quilalilic imajmajuan pan mochi sejse in cocoxquimes, huan quinpajtic. ");
INSERT INTO nclNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Quisaje ijyecames pa míac yehuanten, tzajtzitataloaya, quilijtataloaya: —Tehual tiꞌixolol Dios. Huan Jesús quinmajuaya, amo quinequiaya pa lajtulosquiaya, pampa yehuanten quimatiloaya yihual yec iCristo Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Lanesic, quisac Jesús pin caltilan, uyac capa amaqui cataya. Quitemujtihualaloaya in míac lacames capa cataya huan quinequiloaya quitzacuililo pa camo mohuicasquiaya, quinequiloaya pa mocahuas ca yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ma yoje, yihual quinmilic: —Cate noje oc sequin caltilan capa nicpía pa niquinlaquetzilis ilamachiltilisli cuali Dios huan quinami huelitía. Unca pampa inon nechtilanic Dios pa nicchías. ");
INSERT INTO nclNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Huan yahuiaya quinahuatijtinemi ilajtol Dios pa inmintiopajmes in judíos. ");
INSERT INTO nclNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Cataya se tonali in míac lacalera monechiculoaya inahuac Jesús pa quicaquilosquiaya ilajtol Dios. Yihual noje moquetzaya pa itenco in al huejcalan itoca Genesaret. ");
INSERT INTO nclNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Quinmitac ome canoas cataloaya itenquito in al huejcalan. Quincahuajque in micheros, axcan quinchipajtataloaya inminlatzojuinijmes calica quinquitzquiloaya michimes. ");
INSERT INTO nclNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Calaquic Jesús pa in se canoa hual iyaxca Simón, huan quilajlanic pa quinejnemiltis in canoa pa quijcuanis nadita pin al huejcalan pa camo cayas pa itenco in al. Cuaquinon molalic huan pa in canoa quinmaxtiaya in míac lacalera. ");
INSERT INTO nclNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Cuaquín quiman mocahuac laquetzac, Jesús quilic Simón, quilic: —Xicnejnemilti in canoa, ma ajsi capa cayas huejcalan huan xiquinlasacan anmolatzojuinijmes huejué pa anquinquitzquis michimes. ");
INSERT INTO nclNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón quilic: —Lamaxtini, pa mochi layúa titequipanuloaya huan amo tijquitzquije nindeno. Ma yoje, pampa tel tichilic, niquinlasas in latzojuinijmes. ");
INSERT INTO nclNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Quichíac inon, huan quinnejnechicujque michera, míac, huan pehuajque tzayanijque inminlatzojuinijmes. ");
INSERT INTO nclNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Cuaquín quinculiniloaya inminmajmajuan pa hualasqui yehuanten pan in oc se canoa pa quinpalehuilosquiaya. Huan hualajque, quintemiltijque in ome canoas ca michimes, pampín pejtiajque moatoctijque. ");
INSERT INTO nclNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Huan quitaya mochi inon Simón Pedro, huetzic quimolancuacuetzilijtica capa ilaixpan Jesús, molaquitzquic pa ilancuajmes Jesús, quilic: —Ximijcuani capa nehual, Tata, pampa nehual nilaijlaculi. ");
INSERT INTO nclNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Quilic inon pampa momajtiaya pampa quinquitzquijque innojen míac michimes. ");
INSERT INTO nclNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yojque mocahualoaya moizticate ca lamajtilisli moxtin hual cataloaya ca yihual. Quema, yoje mocahualoaya moizticate Jacobo huan Juan ixolomes Zebedeo, hual tequipanuloaya ca Simón. Huan Jesús quilic Simón: —Amo ximomajti. Tiquinquitzquini michimes hual miquinijme. Pejtica ca axcan huan pa quiman tiquinquitzquis lacames hual yulisqui pampa yesi nolaneltocanijmes. ");
INSERT INTO nclNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Cuaquinon quinquixtijque pin al huejcalan in canoas pa quinlalilosquiaya pa itenco in al, huan jan axcan quincajcahuajque mochi huan quitocajque Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Se tonali cataya Jesús pa se innojen caltilan, huan moitac se lacal, quipiaya in cocolisli itoca lepra pa mochi icuerpo. Huan quitac Jesús in lacal, mopachujtiquisac pan lali, huan quitemachic Jesús, quilic ca icnotilisli, quilic: —Tata, sinda ticnequi, huil tijchipahuilis in lepra. ");
INSERT INTO nclNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Huan Jesús quixilanic imajma, quimatocac, quilic: —Nicnequi nicchía. Xicaya lachipahuali. Jan ajnaxcan pajtic in lepra pan in lacal. ");
INSERT INTO nclNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Cuaquinon Jesús quilic in lacal pa camo quilisquiaya amaqui, quilic: —Axcan quiman timohuicas, ximonexti ca in tiopista huan xicuica se huendi hual quimaca se pa lachipahualisli, quinami moijcuiluc ilajtol Moisés. In huendi quinnextilis in tiopistas pampa axcan tichipahuac. ");
INSERT INTO nclNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ma yoje, ilamachiltilisli in lapajtilisli mosemanaya míac huan míac huan mojmosta momiactitihualaloaya in lacames pa quicaquilosquiaya Jesús huan pa yihual quinpajtilisquiaya inmincocolisli. ");
INSERT INTO nclNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Huan yihual yahuiaya ihuían capa amaqui chantiaya, yahuiaya pa nepa quilajlanis Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Cataya se tonali yihual lamaxtiaya huan molalijtataloaya nepa sequin hual quineltocaloaya inminlamaxtilisli yehuanten hual itocaloaya fariseos, huan sequin ilamaxtinijmes inminlajtol hual quinextilía quinami quimolancuacuetzililo Dios in judíos. Yehuanten quisajque pa mochi caltilan pin lalticpan Galilea huan pin lalticpan Judea huan pin caltilan hué Jerusalén. Huan in Tata ilahueliltilisli cataya ca yihual pa lapajtisquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Huan xiquitacan, quihualicatihualaloaya sequin lacames se lacal pan se lapejtzindi. In lacal amo huil moquetzaya, amo huil nejnemiaya. Yehuanten motolinijque pa quihualicalosquiaya pa calijtic pa quilalilosquiaya ilaixpan Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Huan amo quitaloaya quinami quihualicalosquiaya pa calijtic pampa quintzacuililoaya in míac lacalera itenco in cali. Pampín, lejcujque pani in cali, quixitinijque ca pani pa quichihuasi se coyunquil pa in tapanco capa quitemuhuijque in lacal lastataya pan in lapejtzindi. Quitemuhuijque lajco capa in lacalera, capa ilaixpan Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Huan yoje quitac Jesús quinami yehuanten quineltocaloaya yihual yahuiaya quipajti in cocoxqui. Pampín quilic: —Lacal, axcan cate lapujpuhuali molaijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Cuaquinon pehualoaya quijtulo laijtic yehuanten in lamaxtinijmes huan in fariseos, quijtuloaya: “Huan ¿aqui in se hual quihuejuecaltitica Dios? Amo unca amaqui hual quipía lahueliltilisli pan in lalticpan pa quinpujpuhuas lacames inminlaijlaculisli. Jan Dios san, unca iyaxca yihual.” ");
INSERT INTO nclNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Quimatic Jesús len quijtuloaya pa inminyolo huan quinmilic: —Anquijtutica laijtic pa anmoyolo pampa nicuejuecaltitica Dios pampa niquilic: “Cate lapujpuhuali molaijlaculisli.” ");
INSERT INTO nclNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Axan, annimitznextilis len. Huil niquilis pampa cate lapujpuhuali ilaijlaculisli. Noje huil niquilis pa moquetzas huan nejnemis. Sinda moquetzas huan nejnemis anquimatis pampa nicpía lahueliltilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yojque nehual ilacal in cielo nía annimitznextilía pampa unca noyaxca pan in lalticpan pa niquinpujpuhuilis lacames inminlaijlaculisli, quinami unca iyaxca Dios pa quichías yoje. Huan neli annimitznextilis inon, pampa nía nicpajtía in lacal. Cuaquín, quimalinac iixco huan quitac in cocoxqui, quilic: —Nimitzilía, ximoquetza, xicmama molapejtzindi huan xía pa mochan. ");
INSERT INTO nclNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jan ajnaxcan moquetzac in lacal inminlaixpan moxtin, quimamac in lapejtzindi capa lastataya, uyac pa ichan quijtutica lajtomes huejué pa Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Huan mocahualoaya moizticate ca lamajtilisli moxtin. Pehualoaya quijtulo lajtomes huejué huan neli pa Dios. Pehualoaya momajtilo míac huan quilijtinemiloaya: —Axan tiquinmitaje lejlen hual amo quiman moitaje pan lalticpan huan techmajtilo innojen. ");
INSERT INTO nclNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Panujque innojen, quisac Jesús huan quitac se motocaya Leví molalijtataya pin cali capa quilaxlahuiloaya pa ilapixcalisli tomin pa in hueyenten romanos. Huan Jesús quilic: —Xihuala xichtoca, xiye se nomonextilini ca in oc sequin. ");
INSERT INTO nclNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Cuaquinon moquetzac Leví, quincahuac mochi, huan yihual uyaje. ");
INSERT INTO nclNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Huan quichihuilic Leví se lacualisli pa Jesús, quihuicac pa ichan. Noje quinhuicac Leví oc sequin míac lacames, cataloaya oc sequin hual canaloaya ilapixcalisli tomin huan oc sequin lacames hual cataloaya ca yehuanten pa in lacualisli. ");
INSERT INTO nclNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Amo quixtocaloaya inon yehuanten in fariseos huan inminlamaxtinijmes. Pampín yehuanten quinlajlanije imonextilinijmes Jesús, quinmilije: —¿Leca amhuanten anlacua huan anlauni ca in ilapixcanijmes tomin pa in romanos huan in oc sequin lacames hual amo yulilo cuali? ");
INSERT INTO nclNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús quinnanquilic: —Amo monequi pa quitasi se lapajtini yehuanten hual amo cocoxquimes. Yehuanten hual, quema, cate cocoxquimes quipialo pa quitasi se lapajtini. ");
INSERT INTO nclNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Huan nehual nihualaya pa niquinnotzas yehuanten hual quimatilo pampa quipialo laijlaculisli. Niquinmilis pa quinpalasi inminyolo pa pehuasi laijnamiquisqui quinami Dios quinequi. Amo nihualaya pa niquinnotzas yehuanten hual quijtulo laijtic inminyolo pampa quipialo inminyolo chipahuac. Yehuanten quijtulo pampa amo quipialo pa quipalasi inminyolo pa pehuasi laijnamiquisi quinami Dios quinequi. ");
INSERT INTO nclNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Sequin quilijque: —Mosahualo míac imonextilinijmes Juan Lacuayatequini huan quilajlanilo Dios. Noje quichihualo yojque yehuanten in fariseos. Huan tehual momonextilinijmes mojmosta lacualo huan launilo, amo quiman mosahualo. ");
INSERT INTO nclNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Huan Jesús quinmilic: —Nomonextilinijmes cate quinami yehuanten hual cate lahuicali pa se lanamictilisli huan nehual niunca quinami hual yahui monamictía. Amo huil anquinmilis pa mosahuasi yehuanten hual quinnotza se pa hualasi pa se lanamictilisli sinda cate ca in lacal hual monamictitica. ");
INSERT INTO nclNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ma yoje, ajsisi in tonalijmes quiman quinquixtilisi yehuanten in se hual monamictitica hual quinnotzac pa hualasi pa in lanamictilisli. Cuaquinon pa in tonalijmes mosahuasi. ");
INSERT INTO nclNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Huan quinmilic yehuanten noje se lapuhualisli pa lamaxtisquiaya, se laijnamiquiltilisli, quinmilic: —Amaqui quitzayana se ilajco se nahuas yancuic pa quilalilis pan se tzayanquil pan se nahuas cacaxli. Sinda quichías in, yoje quijlacus in yancuic huan amo cayas iyaxca in lajco yancuic ca in nahuas cacaxli. ");
INSERT INTO nclNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Noje amaqui quintemiltía cuilaxlimes cajcacaxli ca iayo uva yancuic. Sinda quichía yoje, iayo uva yancuic quixopunis in cuilaxlimes. ");
INSERT INTO nclNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pampín, quilalilo iayo uva yancuic pin cuilaxlimes yajyancuic. Huan jan yoje nolamaxtilisli amo unca iyaxca ilamaxtilisli in fariseos. ");
INSERT INTO nclNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Huan sinda se cunic iayo uva hual axan quipía míac tonalijmes quiman quilalijque pin cuilaxlimes, cuaquín yihual amo quinequi cuni jan ajnaxcan iayo uva yancuic, pampa quijtúa: “Unca cuali in hual axan quipía míac tonalijmes quiman quichihuajque.” ");
INSERT INTO nclNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Cataya pan se tonali quiman mosehuilo in judíos, panujtiahuiaya Jesús pan se cuajmili capa cataya trigo, huan pehuajque quincapehuajque miahuimes imonextilinijmes, quinxacualujque ca inminmajmajuan pa quisasquiaya in caliyo, cuaquinon quicuajque in trigo. ");
INSERT INTO nclNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Sequin fariseos quilijque: —¿Leca anquichijtica len amo quimacahuiltía tolajtol pa quichías se pan tonalijmes hual timosehuilo? ");
INSERT INTO nclNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Huan quinnanquilic Jesús, quinmilic: —¿Amo quiman anmomaxtic in hual quichíac David quiman mayanaya, yihual huan moxtin yehuanten hual cataloaya ca yihual? ");
INSERT INTO nclNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Yihual calaquic pa itiopan hué Dios, quinmanac in panes hual in tiopistas quinlalilo ilaixpan Dios. Quincuac huan quinmacac yehuanten hual cataloaya ca yihual. Huan tolajtol lamacahuiltía pa quincuasi jan in tiopistas san. ");
INSERT INTO nclNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Cuaquinon quinmilic: —Nehual ilacal in cielo niunca in Tata hual unca noyaxca pa niquijtus len huil quichía se pan in tonali chicome quiman mosehuilo. ");
INSERT INTO nclNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Cataya pan oc se tonali chicome quiman mosehuilo in judíos, huan calaquic Jesús pa se tiopan calijtic huan lamaxtiaya. Nepa cataya se lacal ca imajma cuali huaqui. ");
INSERT INTO nclNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Huan quinapachijtataloaya in lamaxtinijmes huan fariseos pa quimatilosquiaya sinda cuajnesi yahuiaya quipajti Jesús pan in tonali chicome. Yoje quipialosquiaya quinami quimotexpahuililosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ma yoje, quimatiaya Jesús len quijtuloaya pa inminyolo, huan quilic in lacal hual quipiaya imajma huaqui, quilic: —Ximoquetza huan xihuala ximoquetza lajco capa ticate tehuanten. Huan yojque quichíac in lacal. ");
INSERT INTO nclNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Cuaquinon Jesús quinmilic: —Ma annimitzlajlani, ¿len quijtúa tolajtol? ¿Techmacahuiltía pa ticchihuasi len cuali o len amo cuali pan tonali chicome quiman timosehuilo? ¿Techmacahuiltía pa tijquixtisi se pin polehuilisli o pa tijcahuasi pa miquis? ");
INSERT INTO nclNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Quinmitac moxtin pa itenco, cuaquín quimalinac iixco ca in lacal hual quipiaya imajma huaqui, quilic: —Xicxilani momajma. Huan quixilanic imajma in lacal huan mocuepac yulic imajma quinami cuali cataya quiman ayamo huaquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Cuaquín cualaniloaya míac in fariseos huan lamaxtinijmes, pehuajque molajlanijque len huil quichihuililosquiaya Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Huan cataya pan innojen tonalijmes quisac in caltilan Jesús. Uyac pa in loma (tepel) pa quilajlanis Dios, panuc mochi in layúa quilajlantataya Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Quiman lanesic, quinnotzac pa hualalosquiaya ca yihual imonextilinijmes. Ca yehuanten cataloaya majlaclihuanome (doce) hual quinlajtultic. Yihual noje quintocayaltic ilanahuatinijmes. ");
INSERT INTO nclNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Cataya Simón hual noje quitocayaltic Pedro, cataya Andrés, yihual icni Simón, cataloaya Jacobo huan Juan, cataya Felipe, cataya Bartolomé, ");
INSERT INTO nclNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","cataya Mateo, cataya Tomás, cataya Judás ixolol Alfeo, cataya Simón hual cataya ca innojen hual quinequiloaya molalilo inminpan in romanos, motocaloaya in Zelotes, ");
INSERT INTO nclNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","cataya Judás ixolol Jacobo, huan cataya Judás Iscariote. Yihual in se hual quitemacac Jesús ca yehuanten hual yahuiloaya quimictilo. ");
INSERT INTO nclNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Temuc Jesús ca yehuanten, moquetzac pan se ixlán. Nepa hualaje míac imonextilinijmes, huan hualaje noje míac yehuanten pa mochi in lalticpan Judea huan Jerusalén huan pin caltilan hué Tiro huan in caltilan hué Sidón hual cataloaya pa itenco in al niman huejcalan. ");
INSERT INTO nclNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Hualajque yehuanten pa quicaquilosquiaya Jesús huan pa yihual quinpajtisquiaya inmincocolisli. Noje quinpajtiaya Jesús yehuanten hual quincocoltiloaya noje ijyecames amo cuajcuali. ");
INSERT INTO nclNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Huan motoliniloaya moxtin pa quimatocalosquiaya Jesús. Cataya pampa quistataya pa yihual ilahueliltilisli pa lapajtisquiaya huan yoje pajtije moxtin hual quimatocaloaya. ");
INSERT INTO nclNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Huan cajcoquic itzontecon Jesús pa quinmitasquiaya imonextilinijmes, pehuac quinmilic: —Ma quipiacan paquilisli yehuanten hual quimatilo pampa monequi niman míac pa canasi len Dios quipía pa quinmacas. Quema, ma quipiacan paquilisli, pampa Dios huelitis pa inminyolo. ");
INSERT INTO nclNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Ma quipiacan paquilisli yehuanten hual aqui mayanalo pa len Dios quinequi quinmaca. Quema, ma quipiacan paquilisli, pampa yehuanten pachihuisi. ’Ma quipiacan paquilisli yehuanten hual chocalo pampa quincocujtica inminyolo de mochi in amo cuali hual quichihualo. Quema, ma quipiacan paquilisli, pampa Dios quinchihuilis pa paquisi. ");
INSERT INTO nclNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Ma quipiacan paquilisli sinda amo quinmixtocalo in lacames, sinda amo quinmacahuiltilo pa calaquisi pa calijtic inmintiopajmes, sinda quincocolijtialo huan sinda quinhuejuecaltilo. Jo quema, ma quipiacan paquilisli sinda yehuanten quinchihuililo yoje pampa nechneltocalo nehual ilacal in cielo. ");
INSERT INTO nclNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ma paquican pa in tonali quiman yoje quinpanus, ma tzicuinican ca paquilisli, pampa pin cielo quipiasi se laxlahuilisli hué. Quema, pampa inmintajtzitzían yehuanten hual anmijchihuililo yoje quinchihuilinijme yoje Dios ilajtunijmes pa yina. ");
INSERT INTO nclNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Ma yoje, quichi cocolisli quipiasi pan inminyolo yehuanten hual quijtulo pampa quipialo mochi huan pampín amo monequi pa quipiasi in hual Dios quinequi quinmaca. Quema, quichi cocolisli quipiasi pampa axcan pan in lalticpan quipiajque inminlalacahualtilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Huan quichi cocolisli quipiasqui pan inminyolo yehuanten hual axcan quijtulo pampa amo unca nindeno hual Dios quipía pa quinmacas hual monequi pa quipiasi. Jo quema, ¡quichi cocolisli quipiasi pan inminyolo, pampa ajsis se tonali huan quinequisi quipiasi len huil quinmaca Dios huan yajmo quinmacas! ’Huan quichi cocolisli pa inminyolo quipiasi yehuanten hual canalo mochi inminpaquilisli ca in hual quipialo nican pin lalticpan. Jo quema, quichi cocolisli quipiasi. Pampa ajsis se tonali huan quincocus inminyolo, chocasi huan ijyulantitiasi pampa yajmo quipiasi len calica mopactilisi. ");
INSERT INTO nclNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Huan quichi cocolisli quipiasi pa inminyolo yehuanten hual moxtin laquetzalo cuali pampa quixtocalo in hual quichihualo yehuanten. Unca pampa yoje inmintajtzitzían laquetzanijme pampa quixtocanijme in lajtunijmes hual islacatinijme, quijtutataloaya pampa laqueztataloaya ilajtomes Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Ma yojque, amhuanten hual annechcactica huan annechneltocatica, annimitzilía xiquinlasojlacan yehuanten hual molalilo anmopan, xiquinchihuilican cuali yehuanten hual amo anmitzitalo cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Xiquinlaquetzilican cuali yehuanten hual anmitzlaquetzililo amo cuali amhuanten, huan xiclajlanican Dios pa yehuanten hual anmijchihuililo amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Sinda se mitztecua pa moixco, xicmalina ca yihual oc se moixco pa mitztecuas oc sejpa. Huan sinda se mitzquixtilía monahuas, amo xictzacuili pa camo mitzquixtilis noje molaquen. Unca cuali pa timopepenialtis in amo cuali hual mijchihuililo yehuanten. Amo unca yojque cuali pa tiquincuepilis. ");
INSERT INTO nclNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","’Sinda se mitzmolajlanilis len tehual, xicmaca. Huan sinda se mitzquixtilía len, cuaquín amo xiclajlani sejpa pa mitzcuepilis. ");
INSERT INTO nclNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","’Xiquinchihuilican cuali in lacames quinami anquinequi pa yehuanten anmijchihuilisi cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Sinda anquinnequi yehuanten hual anmitznequilo, Dios amo yahui anmijsehuía pampa inon. Yehuanten hual amo mocahualo pa quichihuasi laijlaculisli jan yoje quinnequilo oc sequin hual noje quinnequilo yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Huan sinda anquichihuilía cuali san innojen hual aqui anmijchihuililo cuali, cuaquín ¿anquijtúa pampa yahui anmijsehuía Dios pampa inon? Xiquitacan. Yehuanten hual itequi quichihualo laijlaculisli quinchihuililo cuali innojen hual aqui quinchihuililo cuali yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Huan sinda anquinlanehuía anmotomin anquichixtica pampa yehuanten yalo anmitzcuepililo anmotomin, yoje amo yahui anmijsehuía Dios pampa inon. Jan yoje quichihualo yehuanten hual yulilo quichijticate laijlaculisli. Quilanehuilo oc sequin quichixticate pa yehuanten quincuepilisi inmintomin. ");
INSERT INTO nclNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Yoje, xiquinnequican yehuanten hual molalilo anmopan, xiquinchihuilican cuali huan xilalanehuican, amo xicchiacan lacuepilisli nindeno. Yoje Dios anmitzcuepilis míac huan anyes ixolomes Dios hual chanti niman pa pani pin cielo. Yihual quinchihuilía cuali yehuanten hual amo cuali huan yehuanten hual amo quisehuilo. ");
INSERT INTO nclNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Xilaicnilican quinami anmoTajtzin pin cielo laicnilía. ");
INSERT INTO nclNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Amo xiejsehuican pa anquinmotexpahuilis laijlaculisli oc sequin huan amo quiman anmitzmotexpahuilis laijlaculisli Dios. Xicpujpuhuacan in amo cuali hual oc sequin quichihualo, huan Dios anmitzpujpuhuilis in amo cuali hual anquichía. ");
INSERT INTO nclNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Xitemacacan huan Dios anmitzmacas, anmitzlamachihuilijtica ca ilamachihualisli iyaxca hual unca niman míac, amo quinami inminlamachihualisli lacames. Jo quema, Dios quilamachihuilía anmitztemiltilijtica huan anmijtzejtzeluilijtica huan anmitzpachihuiltitica, huan cuaquín anmitztemiltilis pa xinis pa in lali. Pampín, quinami amhuanten anlalamachihuilía, yoje Dios anmitzlamachihuilis. ");
INSERT INTO nclNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Cuaquinon quinmilic se laijnamiquiltilisli calica quinmaxtiaya, quinmilic: —Se pachacal amo huil quilaicana oc se pachacal. Huetzilosquiaya in omenten pa je lali lacomultic. ");
INSERT INTO nclNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Imonextilini se amo ajsis yes hué sinda ilamaxtini amo unca jan yojque hué. Laquisa monextilía in monextilini mochi len quimaxtía ilamaxtini, cuaquinon in monextilini yes jan quinami ilamaxtini san. ");
INSERT INTO nclNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Leca tiquita mocni ilaijlaculisli tipichin huan amo tiquita tehual molaijlaculisli hué? Unca quinami tiquiztica se bagazo tipichichito pa iixtololon mocni, huan ma yoje amo timoitilía in cuahuil hual unca pa tehual moixtololon. ");
INSERT INTO nclNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Quinami huil tehual tiquilis mocni: “Nito”, tiquilis, “ma nimitzquixtili in bagacito moixtololon”? Huan ¡amo tiquita in cuahuil hual unca pa moixtololon tehual! ¡Timochijtica quinami se niman cuali huan mocni amo yojque cuali quinami tel! ¡Lacuajcuamanani! Xipehua timoquixtilijtica in cuahuil hual ticpía pa moixtololon tehual. Cuaquinon tilachías cuali pa tijquixtilis in bagacito mocni iixtololon. ");
INSERT INTO nclNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Amo unca se cuahuil cuali hual quimati laqui ca laquilyo hual amo huil quicualo. Huan se cuahuil amo cuali hual amo monotza amo temaca laquilyo cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ticmatilo se cuahuil huan oc se cuahuil pan ipampa ilaquilyo iyaxca. Amo huil canililo se ajual ilaquilyo se amacuajtzindi. Huan amo quinmanililo uvas se huitzcuajtzindi. ");
INSERT INTO nclNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Yoje quichía len cuali se lacal cuali pampa iyolo cuali unca, huan amo quichía len cuali se lacal amo cuali pampa quipía iyolo amo cuali. Quinami lajtúa se lacal laijtic pa iyolo, yojque lajtus ca icamac. ");
INSERT INTO nclNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’Huan ¿leca annechnotza “Tata, Tata”, huan ma yoje amo anquinchía innojen hual annimitzilía? ");
INSERT INTO nclNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Annimitzilía quinami unca se lacal hual ca nehual hualas huan quichías len niquilis. ");
INSERT INTO nclNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Unca quinami se lacal hual quichihuaya se cali. Lahuajuana laijtic huejcalan. Huan quiman cajsic in xaltel, nepa pehua quilalía in tixcalimes pa quiquetzas icali. Huejcalantíac in atenco hué huan quihuitequía in al pan in cali. Ma yojque amo huil quiculinía in cali pampa in lacal quichíac pani in xaltel. ");
INSERT INTO nclNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Huan sinda nechcaqui se huan amo quichía quinami niquilía, cuaquín yihual unca quinami se lacal hual quichihuaya icali pan in lali, amo quitoctic in cali. Huejcalantíac in atenco hué, quihuitequic in al pan in cali, huan jan ajnaxcan quimayajtiquisac, mocahuac laxitinili mochi. ");
INSERT INTO nclNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Cuaquinon, quiman laquisac quinnotzac yehuanten ca mochi in lajtomes pa quicaquilosquiaya, uyac Jesús pa in caltilan Capernaúm. ");
INSERT INTO nclNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Huan cataya se inminlaicanani guaches, yec romano. Quipiaya in laicanani se itequipanujquil niman cocoxqui, yahuiaya miqui. Huan in laicanani quinequiaya míac itequipanujquil. ");
INSERT INTO nclNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Quimatic in laicanani quinami Jesús huil tepajtiaya, quintilanic sequin inminhueyenten in judíos pa yasi quinahuatisi Jesús pa hualas quipajtis itequipanujquil in laicanani. ");
INSERT INTO nclNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ajsijque in hueyenten capa cataya Jesús, pehualoaya quitemachilo ca míac lasojlalisli, quilijque: ");
INSERT INTO nclNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","—Monequi pa ticpalehuis in laicanani pampa yihual technequi tehuanten in judíos huan techlaxlahuilic totiopan. ");
INSERT INTO nclNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Cuaquín uyac Jesús ca yehuanten. Ma yoje, amo cataya Jesús huejca pa ichan in laicanani huan quinamiquijque sequin hual cataloaya ca in laicanani, quintilanic in laicanani pa quinahuatilosquiaya Jesús, huan ca ilajtomes in laicanani quilijque: —Tata, amo ximomaca tequil pa tihualas pa nochan pampa amo nimonotza pa ticalaquis nocali. ");
INSERT INTO nclNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Pampín niquijtuc amo cataya noyaxca pa nihualas ca tehual pa nimitzlajlanis pa tinechpalehuis. Jan xiquijtu se lajtol san huan pajtis notequipanujquil. ");
INSERT INTO nclNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nicmati yihual pajtis pan ipampa molajtol, pampa nehual nicpía pa nicneltocas nolaicanani ilajtol. Noje niquinpía guaches hual quipialo pa nechneltocasi. Niquilía in se “¡Xía!” huan yahui, niquilía oc se “¡Xihuala!” huan huala. Niquilía notequipanujquil “¡Xicchía inon!” huan quichía. Huan sinda yehuanten nechneltocalo pampa niquinmilía inon, cuaquín ¡quinami amo yahui pajtía notequipanujquil pan ipampa molajtol tehual! ");
INSERT INTO nclNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Quicaquic Jesús inon, lajtuaya pa iyolo pampa quineltocaya chicahuac in laicanani mas que amo yec judío. Cuaquín, momalinac capa yehuanten hual quitocatiahuiloaya, quinmilic: —Annimitzilía inon. Ayamo niquitac ca amhuanten israelitos jan se hual laneltoca yojque chicahuac quinami laneltoca in laicanani romano. ");
INSERT INTO nclNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Cuaquín, mocuepajque yehuanten hual quintilanic ca Jesús in laicanani. Ajsijque pa ichan, quitajque pajtic in tequipanujquil. ");
INSERT INTO nclNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Panuc inon, yahuiaya Jesús pa se caltilan tipichin itoca Naín, quitocaloaya imonextilinijmes huan míac lacalera. ");
INSERT INTO nclNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ajsic capa calaquilo pin caltilan, quitac se mijquil, quihuicatiahuiloaya pa quilalpachulosquiaya. Se sihual ihuían yec inantzin in mijquil, huan yihual yec ja in se xolol san hual quipiaya. Ca in sihual cataloaya míac hual chantiloaya pa in caltilan. ");
INSERT INTO nclNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Quitaya in sihual, in Tata Jesús quipiaya laicnililisli pa yihual, quilic: —Amo xichoca. ");
INSERT INTO nclNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ajsic Jesús capa cataya ilacomultic in mijquil, quimatocac, huan moquetzaje yehuanten hual quimamaloaya. Cuaquinon Jesús quilic in mijquil: —Oquixli, nimitzilía ximoquetza. ");
INSERT INTO nclNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Cuaquinon moquetzac molalic in hual miquic, axcan yuliaya oc sejpa, pehuac lajtuc. Huan Jesús quitemacac inantzin yihual hual cataya mijquil. ");
INSERT INTO nclNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Huan momajtijque moxtin huan pehualoaya quijtulo lajtomes huejué pa Dios, quililoaya: —Axcan nesic ca tehuanten se ilajtuni hué Dios. Noje quijtuloaya: —Axcan hualac Dios techpaxaluilic tehuanten hual techlajtultic. ");
INSERT INTO nclNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Huan quimatijque quinami panuc inon yehuanten pa mochi in lali Judea. Huan pa mochi in lali itejtenco Judea quimatijque len quichihuac Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Huan Juan Lacuayatequini imonextilinijmes quimachiltijque Juan mochi inon. Pampín quinnotzac Juan ome imonextilinijmes, quintilanic ca in Tata Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Quintilanic pa quilajlanilosquiaya: —¿Tehual tiunca in se hual Dios quijtuc yahuiaya techtilanili? O ¿ticchiasi oc se? ");
INSERT INTO nclNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Yojque hualajque capa Jesús in lacames imonextilinijmes Juan huan quilije: —Techtilanic Juan Lacuayatequini ca tehual pa timitzlajlanisi sinda tel tiunca in se hual Dios quijtuc yahuiaya huala pin lalticpan. ¿Tiunca tehual o ticchiasi oc se? ");
INSERT INTO nclNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Huan pa in nadita hual nepa cataloaya in omenten hual Juan quintilanic, quitajque Jesús tepajtic. Quinpajtic míac cocoxquimes hual quinpialoaya míac cocolisli. Quinpajtic míac hual quincocoltiloaya ijyecames amo cuajcuali laijtic yehuanten, huan quinlachialtic míac pachacames. ");
INSERT INTO nclNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Cuaquinon Jesús quinnanquilic in omenten imonextilinijmes Juan, quinmilic: —Xiacan xicmachiltican Juan in hual anquitac huan in hual anquicaquic: Lachialo in pachacames, nejnemilo yehuanten hual amo huil nejneminijme. Pajtilo cuali yehuanten hual quipialo in cocolisli lepra. Lacaquilo hual cataloaya panatas. Yulticate oc sejpa in mijquimes. Huan quicacticate nolamachiltilisli cuali yehuanten hual quimatilo pampa monequi pa quipiasi ilapalehuilisli Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Quipías paquilisli aqui hual quilalía ilaneltocalisli ca nehual. ");
INSERT INTO nclNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yojque uyaje in omenten pa quinahuatilosquiaya Juan inon hual Jesús quinmilic. Cuaquinon inminyampa in míac lacames pehuaya Jesús quinlaquetzili quinami Juan quichijchihuilic Jesús iojli, quinmilic: —Nepa in tonalijmes anquisani ca capic amaqui chantiaya. ¿Aqui anquijtuni pampa anyahuiaya anquita? ¿Anquisani pa anquitasquiaya se lacal hual momajtic quijtuc len Dios quinequiaya pa quijtusquiaya, se lacal hual quijtuc len quinequiloaya lacames? No, Juan amo quinami inon, yihual amo quinami se acal hual in ijyecal quiculinía. ");
INSERT INTO nclNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Cuaquín ¿len anquisani anquita? ¿Anquisani pa anquitasquiaya se lacal lalaquentili ca tzotzomajli cualtichin? Xiquitacan. Yehuanten hual molaquentilo ca tzotzomajli cualtichin cate capa chantilo in huejueyenten huan in huejueyenten quinchihuililo cuali huan quipialo míac hual cuajcuali. Juan amo quinami inon. ");
INSERT INTO nclNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Cuaquinon ¿len anquisani anquita? ¿Anquisani pa anquitasquiaya se ilajtuni Dios? Jo quema, annimitzilía. Huan yihual amo yec jan se ilajtuni Dios san. ");
INSERT INTO nclNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Unca pampa yoje unca lajcuiluli in hual Dios quijtuc pampa yihual Juan yahuiaya nejchihuilía, quil: Xiquita, nimitzlaicanaltilía nolanahuatini pa yihual mijchijchihuilis moꞌojli moixpan, pa mitziximatisqui yehuanten hual niquinlajtultic. ");
INSERT INTO nclNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Annimitzilía inon. Ca moxtin lacames hual quinlacatiltije lacames huan sihuames, amo unca se hual ajsic yec hué quinami Juan Lacuayatequini unca hué. Ma yoje, yihual Juan amo niman hué quinami unca hué in niman tipichin hual unca ca yehuanten hual cate capa Dios huelitía. ");
INSERT INTO nclNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Huan pa innojen tonalijmes quiman moxtin quicaquiloaya Juan, jo quema, quicaquiloaya in yehuanten hual quipixcalo tomin pa yehuanten hual huelitilo, cuaquín yehuanten quimacahuiltijque pa quincuayatequis Juan. Quipalajque inminyolo pa laijnamiquilosquiaya quinami Dios quinequi. Yoje lanextilijque pampa Dios quinchihuilía sejse jan yoje quinami quinchihuilía in oc sequin. Huan yehuanten quineltocajque Juan ilamaxtilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ma yoje, in fariseos huan yehuanten hual quimaxtilo in lajtol amo quimacahuiltijque pa quincuayatequis Juan. Yoje lanextilijque pampa amo quineltocajque Dios. Quichihuilijque pa camo quinpalehuisquiaya ilajtol Dios, amo quipalajque inminyolo pa laijnamiquilosquiaya quinami Dios quinequi. ");
INSERT INTO nclNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesús quilic: —¿Quinami cate yehuanten hual yulticate axan? ");
INSERT INTO nclNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Lachihualo quinami xolomes hual molalilo pa mahuiltisi. Quintzajtzilijticate yehuanten hual mahuiltilo ca yehuanten, quinmilijticate: “Ticnequiloaya timahuiltilo quinami quiman monamictilo. Antimijtzotzonilije huan amo anmijtotic. Cuaquín ticnequiloaya timahuiltilo quinami quilalpachulo se mijquil, titzajtzije quinami techcocujtataya toyolo huan amo anchocac.” ");
INSERT INTO nclNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yehuanten hual yulticate axan cate quinami in xolomes pampa amo quimatilo len quinequilo. Amo quixtocalo len yes hual Dios quinequi quinmaca. Juan amo lacuani huan amo cunini iayo uva coc quinami amhuanten anlacualo huan ancuni huan anquijtuni: “Yihual quipía se ijyecal amo cuali.” ");
INSERT INTO nclNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Huan nehual ilacal in cielo, nel niunca nican, nilacua huan nilauni quinami moxtin, huan anquijtúa: “Xiquitacan. Nepa unca se lacuani, unca se launini. Quinequi pa cayasi ca yihual yehuanten hual quipixcalo tomin pa yehuanten hual huelitilo. Quinequi pa cayasi ca yihual yehuanten hual laijlaculi.” ");
INSERT INTO nclNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ma yoje —quinmilic Jesús—, moxtin hual quimatilo, yehuanten quimatilo ilajmatilisli Dios, in hual tiquinlaquetzililo yehuanten Juan huan nehual. Yehuanten quineltocalo huan quilasojlalo in lajmatilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Huan cataya se fariseo quihuicac Jesús pa ichan pa lacuas ca yihual. Calaquic Jesús icali in fariseo, molalic pa in lacualisli. ");
INSERT INTO nclNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Cataya se sihual yuliaya pin caltilan, se sihual laijlaculi. Yihual quimatic pampa lacuaya Jesús pa ichan in fariseo. Huan in sihual quihualicac se tapalquita lachijchihuali ca tixcali itoca alabastro. In tapalquita cataya tentica ca len hual ajuíac, itoca mirra. ");
INSERT INTO nclNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Huan in sihual ajsic moquetzac pa icxihuajmes Jesús, chocaya huan ixicac ichoquis pani icxihuajmes Jesús, pehuac quinpaltilic icxihuajmes. Cuaquín in sihual quinhuactic icxihuajmes Jesús ca itzondi, huan pehuaya quintenamiqui icxihuajmes, quinxahuiliaya ca in mirra. ");
INSERT INTO nclNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Quitac inon in fariseo hual quihuicac Jesús pa ichan, huan quijtuc laijtic yihual, moilic: “Sinda in se yec se ilajtuni Dios, yoje quimatiaya aqui unca in sihual hual quimatoctica. Quimatiaya quinami yihual unca, yihual se sihual laijlaculi.” ");
INSERT INTO nclNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Huan Jesús quilic in fariseo: —Simón —quilic—, nicpía len pa nimitzilis. Huan Simón quilic: —Xichili, Lamaxtini. ");
INSERT INTO nclNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús quilic: —Cataloaya ome lacames quihuiquililoaya tomin se telanehuini. Se quihuiquiliaya quinientos denarios tomin, in oc se quihuiquiliaya cincuenta. ");
INSERT INTO nclNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pampa amo quipiaje in omenten nindeno calica quilaxlahuilosquiaya in telanehuini quinpujpuhuac pa camo quipialosquiaya pa quilaxlahuilosquiaya in tomin hual quihuiquililoaya. ¿Calía in omenten tehuiquilinijmes tiquijtúa yahuiaya quilasojla niman míac in telanehuini huan calía amo yoje míac? ");
INSERT INTO nclNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","In fariseo quinanquilic: —Niquijtúa in se hual quipujpuhuac hual quihuiquiliaya in míac tomin, yihual yahuiaya quilasojla niman míac. Jesús quinanquilic: —Tilananquilic cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Cuaquinon momalinac Jesús ca in sihual huan quilic Simón: —¿Tiquita in sihual, Simón? Nicalaquic mochan huan tehual amo tichmacac al pa niquinpacasquiaya nocxihuajmes. Huan yihual nechpaltilic nocxihuajmes ca ichoquis iixtololojmes huan quinhuactic ca itzondi. ");
INSERT INTO nclNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Amo tichtenamiquic pa tichpialtisquiaya, huan yihual quiman calaquic pehuaya quintenamiqui nocxihuajmes huan amo mocahuac quichíac. ");
INSERT INTO nclNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Amo tijxahuilic notzontecon ca chahuac, huan yihual quinxahuilía nocxihuajmes ca mirra. ");
INSERT INTO nclNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Pampín nimitzilía, Dios quipujpuhua ilaijlaculisli hual unca míac. Quipujpuhua pampa yihual nechlasojlac míac. Yihual hual Dios quipujpuhua hual amo quipía míac laijlaculisli, yihual quilasojla Dios jan nadita san. ");
INSERT INTO nclNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Cuaquinon Jesús quilic in sihual, quilic: —Nicpujpúa molaijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Cuaquinon pehualoaya moililo laijtic inminyolo yehuanten hual cataloaya pa in lacualisli ca yihual, moilije: “¿Aqui inon hual quijtúa unca iyaxca pa quipujpuhuas laijlaculisli?” ");
INSERT INTO nclNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesús quilic in sihual: —Tiunca laquixtili pin ipolehuilisli molaijlaculisli pampa tilaneltocac. Ximohuica cuali, xicmati pampa Dios mijchihuilic cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Panuc inon, cantiahuiaya ojli Jesús pa se caltilan huan pa oc se caltilan huan pa se calería pa yasquiaya pa oc se calería. Lanahuatijtinemiaya ca Dios ilanahuatilisli, quinlamachiltitinemiaya moxtin ilamachiltilisli cuali hual unca quinami Dios huelitía. Uyaje ca yihual in doce imonextilinijmes ");
INSERT INTO nclNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","huan sequin sihuames. In sihuames Jesús quinpajtilic inmincocolisli huan quinquixtilic ijyecames amo cuajcuali. Cataya María hual yulini pa in caltilan Magdala, quisaje pa yihual chicome ijyecames amo cuajcuali. ");
INSERT INTO nclNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Noje cataya ca yehuanten Juana isihua Chuza. In Chuza yec se itequipanujquil hué in hué Herodes. Noje cataya Susana huan cataloaya míac oc sequin sihuames. In sihuames quinpalehuiloaya moxtin ca inmintomin huan ca in hual quicuaje. ");
INSERT INTO nclNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Huan monechiculoaya míac, quistihualaloaya pa mochi caltilan ca capic yihual cataya. Huan yihual quinlaquetzilic ca se lapuhualisli quinami laijnamiquiltilisli pa quinmaxtisquiaya, quinmilic: ");
INSERT INTO nclNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Quisac se latocani pa quitocasquiaya ilatocli. Quixintiahuiaya, sequin latocli huetzije pa itenco in ojlito huan cataloaya latelicsali huan in tutomes quincuaje. ");
INSERT INTO nclNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Huetziaya oc sequin latocli pan in xaltel, ixuaje in latocli huan jan ajnaxcan pilinije pampa amo cataya lapaltijcal. ");
INSERT INTO nclNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Huetzije oc sequin latocli lajco pin huiztilan, moscaltiloaya in huizli capa ixualoaya in ipacholimes in latocli huan in pacholimes mosaluje pin huiztilan huan miquije. ");
INSERT INTO nclNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Huetzije oc sequin latocli pan lali cuali huan moscaltije huan temacaje míac laquilyo, cien pa se latocli hual quixinic in latocani. Lamic quinmilic Jesús in laijnamiquiltilisli, quintzajtzilic: —Aqui yes hual quinpía inacajmes pa lacaquis, ma lacaqui pampa etic pa quimatis se len quinequi quijtúa. ");
INSERT INTO nclNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Cuaquinon pehuaje quilajlanije imonextilinijmes len quinequiaya quijtu in laijnamiquiltilisli, in lapuhualisli calica yihual quinmaxtiaya, cataya lamaxtilisli lalatili. ");
INSERT INTO nclNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Huan Jesús quinmilic: —Amhuanten anmitzmacahuiltía Dios pa anquimatis innojen lajtomes hual anmitznextilía quinami yihual huelitía, innojen hual jan tehuanten ticmatilo san. Huan in oc sequin niquinlaquetzilía ilajtol Dios ca laijnamiquiltilisli ca lamaxtilisli lalatili. Yoje, mas que quizticate, Dios quinchihuilía pa camo quitasi len quinequi quijtúa. Noje, mas que quicacticate, Dios quinchihuilía pa camo ajsisi quimatisi len quinequi quijtúa. ");
INSERT INTO nclNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Inon unca hual quinequi quijtúa in laijnamiquiltilisli: ");
INSERT INTO nclNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","In latocli unca ilajtol Dios. In latocli pa itenco in ojlito cate quinami aquinojen hual quicaquilo ilajtol Dios, cuaquín huala in lili, quinquixtilía in lajtol pa laijtic inminyolo capa ayamo quineltocaje. In lili quichíac inon pa camo yelosquiaya laquixtili pin ipolehuilisli inminlaijlaculisli sinda quinequiloaya quineltocalo. ");
INSERT INTO nclNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","In latocli pin lali amo telahuac pan ipampa in xaltel cate quinami yehuanten hual quicaquilo ilajtol huan quineltocalo ca paquilisli. Ma yoje, amo quilalilo in lajtol pa inminyolo quinami se ilalhuayol se cuahuil. Quineltocalo san se nadita, huan sinda quipialo pa panusi lacocoltilisli pampa quineltocalo in lajtol, cuaquinon mijcuanilo, yajmo quixtocalo in lajtol. ");
INSERT INTO nclNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","In latocli hual huetzije pin huiztilan, yehuanten cate quinami lacames hual quicaquije in lajtol huan quijnamiquilo niman míac in quinami yalo yulilo ca paquilisli. Yoje ca yehuanten ilajtol Dios amo moscaltía pa inminyolo, unca quinami se pacholi tzinlalajquil hual moscaltía pin lali, amo quiman yucsi. ");
INSERT INTO nclNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Huan in latocli hual huetzije pin lali cuali, yehuanten cate quinami lacames hual quicaquilo ilajtol Dios huan monextililo cuali pa camo quilcahuasi. Huan in lajtol quinchihuilía pa quichijtiasi len cuali, amo siahuilo pa yulisi quichijticate yoje. ");
INSERT INTO nclNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Huan amaqui quitzacua se tapalquita calica lahuilo ca oc se tapalcal sinda quilalaltía. Huan amo quilalía itzindan se lapexli. Quema, quilalía capa mocahuas nestica pa quinlahuis yehuanten hual calacticate pin cali. ");
INSERT INTO nclNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Annimitzilía inon pampa amo unca nindeno lalatili hual amo yes laitali. Jo quema, mochi hual amo quimatilo, inon quimatisi se tonali. ");
INSERT INTO nclNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Pampín xilaiztiacan quinami annechcaqui, xichcaquican cuali. Sinda annechcaqui cuali, anmonextilis niman míac in hual unca pa ilajtol Dios. Huan sinda amo annechcaqui cuali, Dios anmitzquixtilis in hual anquijtúa pampa anmonextilic pan ipampa ilajtol. ");
INSERT INTO nclNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Cuaquinon hualaje inantzin huan icnían Jesús ca yihual, huan amo huil ajsije capa yihual pampa cataloaya míac hual quiyahualuloaya Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Pampín quilamachiltijque Jesús, quilijque: —Moquezticate pa quiahuac monantzin huan mocnían quinecticate mitzitalo. ");
INSERT INTO nclNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Huan yihual quinnanquilic yehuanten, quinmilic: —Nonantzin huan nocnían cate yehuanten hual quicaquilo ilajtol Dios huan quichihualo in hual quijtúa. ");
INSERT INTO nclNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Cataya pan se tonali quiman panuloaya mochi innojen, calaquiaya Jesús pa lajco in al huejcalan ca se barquito. Huan imonextilinijmes cataloaya ca yihual. Yihual quinmilic: —Ma ticpanahuican in al huejcalan ca yoje itenco (pa analco). Yoje quipanajtiaje. ");
INSERT INTO nclNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Huan uyajtiaje ca in barquito, cochic Jesús. Cuaquín quinmajsic se ijyecal chicahuac lajco capa yahuiloaya pin al huejcalan. Pehuaya calaqui al pin barquito, pejtiahuiaya temi huan ca nadita yahuiaya moatocti. ");
INSERT INTO nclNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Quejxiltitiquisajque Jesús, quitzajtzilijtataloaya: —¡Lamaxtini, Lamaxtini! ¡Tipolehuisi! Ejsac Jesús, cajuac in ijyecal huan in al hual majcoctataya, yojque mosehuic, mocahuac jan sejpa in al huejcalan. ");
INSERT INTO nclNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Cuaquinon Jesús quinmilic: —¿Leca anmomajtic? ¿Leca amo anquimati anquilalía anmolaneltocalisli ca nehual? Cuaquín momajtiloaya yehuanten, amo huil mocahualoaya pa quijtulosquiaya pa inminyolo pampa quipiaya Jesús lahueliltilisli hué. Huan moililoaya se ca oc se: —¿Len yes in lacal? Yihual quinmajua in ijyecal huan in al, huan quineltocalo. ");
INSERT INTO nclNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Cuaquinon ajsijque pa yoje itenco (analco) in al huejcalan. Nepa cataya inminlali in lacames gerasatecos. Nepa pa itenco in al huejcalan huil moitaya in lalticpan Galilea ca yoje itenco (analco) umpa capa hualajque. ");
INSERT INTO nclNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Quisac Jesús pin barquito pan itenco in al. Cuaquinon quinamiquic se lacal hual yulini pin caltilan, quinpiaya ijyecames amo cuajcuali. Quipiaya míac xixihuil amo molaquentiaya ca inahuas, huan amo quinequiaya chanti pa se cali. Chantiaya pin cuevas (ostumes) hual quinchihuajque pa lajlaijtic. Nepa quinlalilosquiaya inminmijquimes. ");
INSERT INTO nclNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Huan jan axcan yihual quitac Jesús, quitzajtzilic, huetzic quimolancuacuetzilijtataya, huan ca lajtol chicahuac quilic: —¡Xiquisa huan xichcahua, Jesús, tehual tiꞌixolol in Dios hual chanti niman pa pani pin cielo! ¡Nimitzilía ca noyolo, amo xichcocolti! ");
INSERT INTO nclNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Tzajtzic yoje in ijyecal amo cuali, pampa Jesús quinmiliaya in ijyecalera pa quisalosquiaya ilaijtic in lacal. Quimpiaya míac xixihuimes in ijyecal pehuac quiquitzquic chicahuac in lacal. Lacames quilpililoaya imajmajuan huan icxihuajmes ca teposli, yojque quipialoaya. Ma yoje, yihual quincotonaya in teposli huan in ijyecal amo cuali quilaluxtiaya ca capic amaqui chantiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Huan Jesús quilajlanic: —¿Quinami timotoca? Huan in ijyecal quinanquilic: —Nimotoca Legión. Legión quinequi quijtúa míac, pampa calaquijque míac ijyecames amo cuajcuali pa laijtic in lacal. ");
INSERT INTO nclNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Huan innojen ijyecames pehuaje quitemachijque Jesús ca mochi inminyolo pa camo quintilanisquiaya pa capa Dios yahui quintzacua, capa amo quiman huil quisalosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Huan nepa cataya niman míac coyamimes (cuchis), lacuajtataloaya pan in loma (tepel). In ijyecames quitemachijque Jesús pa quinmacahuiltisquiaya calaquilo ca laijtic innojen coyamimes. ");
INSERT INTO nclNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Yojque quinmacahuiltic. Cuaquín quisajque in ijyecames pin lacal, calaquijque ca laijtic innojen coyamimes. Molalujtiquisajque in coyamimes pa iixlán in loma pa temuán (temuayan), molasajque pa in al huejcalan huan moatoctijque. ");
INSERT INTO nclNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Quitajque len panuc yehuanten hual quinmiztataloaya in coyamimes. Pampín cholujque huan quilamachiltijque pin caltilan huan pin calerías itenco in caltilan inon hual panuc. ");
INSERT INTO nclNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Cuaquinon quisajque yehuanten pa quitalosquiaya len panuc, hualajque capa cataya Jesús huan in lacal huan nepa quitaje molalijtataya in lacal. Axcan quisajque pa yihual in ijyecames, axcan cataya lalaquentili ca inahuas. Yajmo tzajtzitinemiaya quinami se hual amo quijnamiquía, huan yajmo cualantinemiaya, nepa cataya molalijtataya pa icxihuajmes Jesús. Pampín momajtiloaya in lacames. ");
INSERT INTO nclNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Huan yehuanten hual quitajque len panuc quinlamachiltijque quinami cataya lapajtili in lacal hual in ijyecames quiquitzquinijme. ");
INSERT INTO nclNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Cuaquinon moxtin yehuanten pa inminlali in gerasatecos quitemachijque Jesús pa mohuicasquiaya quistataya pa inminlali yehuanten, pampa momajtiloaya. Yojque uyac pa calaquisquiaya Jesús pin barquito pa mocuepas. ");
INSERT INTO nclNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Huan in lacal hual capa yihual quisajque in ijyecames quitemachic Jesús pa quimacahuiltis pa cayasquiaya ca yihual. Ma yoje, Jesús quitilanic pa yasquiaya, quilic: ");
INSERT INTO nclNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Ximocuepa pa mochan huan xiquinpuhuili mochi hual mijchihuilic Dios. Huan yihual mohuicaya pa mochi caltilan lamachiltitinemiaya mochi hual quichihuilic Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Cuaquinon Jesús mocuepac pa yoje itenco (analco) in al huejcalan pin lalticpan Galilea. Nepa quinamiquijque míac lacalera, pampa moxtin quichialoaya. ");
INSERT INTO nclNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Huan umpa, xiquitacan, hualac se lacal itocaya Jairo, yihual yec se ihué in tiopan. Yihual molasac ilaixpan Jesús pa icxihuajmes, quitemachiaya pa yasquiaya pa ichan. ");
INSERT INTO nclNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Quipiaya se xolol sihual, quil, quinpiaya majlaclihuanome (doce) xixihuil, huan yahuiaya polehui, quil, huan in Jairo amo quipiaya oc se xolol. Huan yahuiloaya in míac lacalera cajsitiahuiloaya inahuac Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Yahuiaya ca yehuanten se sihual hual quinpiaya doce xixihuil pehuaya quicocu se cocolisli hual iesli quisaya. Quinlaxlahuiaya sejpa huan oc sejpa in lapajtinijmes huan axan yajmo quicahuilic se tomin. Amo huil quipajtijque in lapajtinijmes, amo jan se ca yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Yoje ajsic pa Jesús itepotzcon, quimatocac itenco inahuas. Huan jan ajnaxcan mocahuac iesli in sihual, yajmo quisaya. ");
INSERT INTO nclNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Cuaquinon Jesús quijtuc: —¿Aqui nechmatocac? Quilijque moxtin pampa no, amo quimatocajque. Huan Pedro quilic: —Lamaxtini, mitzajsitialo monahuac in lacalera, yehuanten mijchihuíc. ¿Leca tilajlanía: “Aqui nechmatocac”? ");
INSERT INTO nclNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesús quilic: —Nechmatocac se. Nicmati inon, pampa quisac pa nehual nolahueliltilisli calica nitepajtía. ");
INSERT INTO nclNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yojque quimatic in sihual amo huil quimolatilic Jesús. Yuyucatihualac, huetzic ilaixpan, quilamachiltic Jesús inminlaixpan moxtin leca yihual quimatocac huan quilic quinami pajtic jan ajnaxcan. ");
INSERT INTO nclNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Cuaquín Jesús quilic: —Nito, tipajtic pampa tilaneltocac. Ximohuica, xicaya jan cuali ca Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ayamo laquisac lajtuc Jesús huan hualac se hual cataya pa icali Jairo, quilic: —Axcan polehuic moxolol sihual. Yajmo xicmaca tequil in lamaxtini. ");
INSERT INTO nclNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ma yoje, inon quicaquic Jesús, huan quilic: —Amo ximomajti, Jairo, jan xilaneltoca san, huan moxolol yes lapajtili. ");
INSERT INTO nclNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Cuaquinon uyac pa ichan Jairo, huan amo quimacahuiltic pa calaquilosquiaya ca yihual oc sequin, jan Pedro huan Juan huan Jacobo huan itajtzin in xolol sihual huan inantzin san. ");
INSERT INTO nclNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Chocaloaya huan tzajtziloaya moxtin, motecuililoaya inminlaixpan itzindan in huajcol pampa polehuic in xolol, quincocuhuaya inminyolo. Ma yoje, Jesús quinmilic: ");
INSERT INTO nclNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","—Amo xichocacan. Amo polehuic in xól, jan coxtica san. Yehuanten quihuitzquilijque Jesús pampa quimatiloaya in xolol yajmo yultataya. ");
INSERT INTO nclNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ma yoje, Jesús quinquitzquic imajmajuan in xolol, quilic ca lajtol chicahuac: —Muachita, ximoquetza. ");
INSERT INTO nclNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Jan ajnaxcan mocuepac iyulilisli laijtic yihual iyolo huan moquetzac. Cuaquín Jesús quinmilic pa quilacualtilosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Yoje mocahualoaya moizticate ca lamajtilisli itajtzitzían. Ma yoje, Jesús quinmilic pa camo quililosquiaya amaqui len panuc. ");
INSERT INTO nclNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Cuaquinon quinahuatic Jesús pa monechiculosquiaya capa yihual in doce imonextilinijmes. Quinmacac lahueliltilisli pa yes inminyaxca pa quinquixtilisi lacames ijyecames amo cuajcuali. Quinmacac in lahueliltilisli pa quinpajtilosquiaya aquinojen hual quipialoaya len yes cocolisli. ");
INSERT INTO nclNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Cuaquinon quintilanic pa quilamachiltilosquiaya cajcapa yes inminlaixpan lacames quinami Dios huelitía, huan quinmilic pa quinpajtilosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Quinmilic: —Amo xiquihuicacan nindeno pa anmoꞌojli, amo xiquihuicacan cuahuil pa anmopalehuis annejnemis, amo xiquihuicacan xotopa huan len pa anquicuas huan tomin. Huan xiquihuicacan jan se laquen san, sejse huan sejse ca amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Huan ancalaquis pa ichan se hual anmitznotzas pa anmocahuas, cuaquín nepa xichantican anquistía mojmosta pa nepa pa anquilamachiltitinemis quinami Dios huelitía. ");
INSERT INTO nclNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Huan sinda yehuanten anmiztojtocasi pampa amo quixtocalo nolamachiltilisli cuali, cuaquín quiman anquisas pa in caltilan, xictzejtzeluilican in lalpotocli hual salijtica pan anmolacsames. Yoje momatis pampa in lacames anmijchihuilic len niman amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Cuaquinon mohuicajque Jesús ilanahuatinijmes, yahuiloaya pa míac caltilan tijtipichin sejse huan sejse, quinlamachiltitinemiloaya ilamachiltilisli cuali Jesús huan quinpajtitinemiloaya cocoxquimes. ");
INSERT INTO nclNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Huan quicaquic Herodes in hué quinami molaquetzilijtinemiloaya lacames, molaquetzilijtinemiloaya mochi hual quichihuaya Jesús. Pampín amo quimatiaya len quijtusquiaya Herodes pampa quijtuloaya sequin pampa Juan Lacuayatequini axcan yuliaya oc sejpa, quisac pa capa in mijquimes. ");
INSERT INTO nclNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Huan quijtuloaya oc sequin pampa Elías ilajtuni Dios, ilajtuni hual yulini pa yina, axcan mocuepac pan lalticpan. Oc sequin quijtuloaya pampa yuliaya oc sejpa oc se ilajtuni Dios hual yulini pa yina quinami yulinijme innojen ilajtunijmes Dios hual quitequipanuilinijme pa yina. ");
INSERT INTO nclNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Huan Herodes quilic: —Nehual nilatilanic pa quicotonilisqui Juan iquixlan. Axcan, ¿aqui in se hual mojmosta nicmaztica len quichijtica? Huan pehuaya quitemu Herodes quinami quitasquiaya Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ajsic in tonali quiman mocuepajque ilanahuatinijmes Jesús, quipuhuilijque mochi sejse lachihualisli hual quichihuajque. Cuaquín quinhuicac Jesús ca yihual, huan mohuicajque. Uyajque ajsijque capa cataloaya inminhuían capa amo huejca cataya se caltilan itocaya Betsaida. ");
INSERT INTO nclNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ma yoje, quimatijque in míac lacames ca capic uyac Jesús, pampín quitocajque. Ajsijque yehuanten, quinpialtic cuali Jesús huan pehuac quinlaquetzilic pa quimatilosquiaya quinami Dios huelitía. Huan quinpajtic yehuanten hual quipialoaya cocolisli. ");
INSERT INTO nclNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Cuaquinon pehuac tiolactic, huan hualajque in doce ilanahuatinijmes, quinmilic: —Xiquintilani in lacalera pa yasi pa innojen caltilan tijtipichin huan in calerías pa totenco. Yojque quitasi capa huil cochisi pa layúa huan quitasi len quicuasi. Amo unca nindeno nican pampa ticate nican capa amaqui chantitica. ");
INSERT INTO nclNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Huan Jesús quinmilic: —Amhuanten xiquinmacacan len quicuasi. Huan yehuanten quilijque: —Amo ticpialo nindeno, jan ticpialo macuili panes huan ome michimes. Sinda ticnequilo ticanalo oc sequin, cuaquín ticpiasi pa tiasi tiquincuhuilisi len pa quicuasi moxtin. ");
INSERT INTO nclNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Cataya quinami macuili mil lacames. Cuaquín Jesús quinmilic ilanahuatinijmes, quinmilic: —Xiquinmilican pa molalisi monechicujticate quinami cincuenta huan cincuenta lacames. ");
INSERT INTO nclNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yojque quichihuajque, quinchihuilijque pa molalilosquiaya, quinmolaliltijque moxtin. ");
INSERT INTO nclNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Cuaquinon quinmanac Jesús in macuili panes huan in ome michimes, lachíac pa in cielo (ilhuicac), quisehuic Dios, pehuac quincapehuac ca lajlajco in panes huan in michimes, quinmacatinemiaya imonextilinijmes pa yehuanten quinhuiquilijtinemilosquiaya in lacalera. ");
INSERT INTO nclNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Yojque lacualoaya in lacalera, pachihuijque moxtin. Huan quinpejpenajque imonextilinijmes in lajlajco lacapehuali hual quincahuajque, cataloaya doce chiquihuimes tentataloaya ca innojen pa yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Cataya se tonali Jesús quilajlaniaya Dios, huan umpa cataloaya ca yihual jan imonextilinijmes san. Huan Jesús quinlajlanic: —Molaquetzilijticate lacames nonahuac nehual, ¿aqui quijtulo pampa nehual niunca? ");
INSERT INTO nclNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Quinanquilijque: —Sequin quijtulo pampa tehual tiunca Juan Lacuayatequini. Oc sequin quijtulo pampa tehual tiElías ilajtuni Dios. Huan oc sequin quijtulo tehual tiunca se ilajtuni Dios hual yulini pa yina huan axan yultica oc sejpa. Cuaquinon Jesús quinmilic: —Huan amhuanten, ¿aqui anquijtúa pampa nehual niunca? ");
INSERT INTO nclNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Huan Pedro quinanquilic: —Tehual tiunca iCristo Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Cuaquinon quinmilic chicahuac Jesús pa camo quililosquiaya amaqui inon, quinmilic: ");
INSERT INTO nclNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","—Nehual ilacal in cielo nicpías pa nipanus míac lacocoltilisli. In hueyenten huan in tiopistas huejué huan in lamaxtinijmes nejchihuilisi pa nipanus inon, nechtojpehuasqui. Yehuanten quilalisi pa quichihuasi se lajtulisli pa nechquitzquisi, cuaquinon nechmictisi. Ma yoje, quiman panusi ye tonalijmes, cuaquín niyulis oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Cuaquinon quinnotzac Jesús mochi in lacames, quinmilic: —Sinda se quinequi ye nomonextilini, ma camo yuli quichijtica len yihual quinequi. Quipía pa yulis quichijtica len quinequi Dios. Huan ma quimati mojmosta pampa quipía pa panus lacocoltilisli sinda nechtocatías, quinami nehual nipanus lacocoltilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","In annimitzilía pampa sinda yuli se quitemujtinemi quinami canas mochi len calica huil mopaquiltis nican capa yultica pan lalticpan, cuaquín Dios amo quimacas in se in yulilisli hual jan quipía Dios san pa quimacas yihual. Huan sinda se yuli quitemujtinemi quinami quichías mochi quinami nehual nicnequi, huan sinda amo quimonotzilía nindeno inon hual unca pin lalticpan calica huil mopaquiltía, cuaquín Dios quimacas in se in yulilisli hual amo quiman lamis. ");
INSERT INTO nclNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Quinami quipalehuis se lacal sinda canas mochi hual unca pin lalticpan calica mopaquiltis huan cuaquín polehuis? Amo quipalehuis nindeno sinda amo quipías in yulilisli calica Dios quinequi quiyuliltía. ");
INSERT INTO nclNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Pampín, aqui yes hual pinahua nonahuac nehual huan len niquijtúa, yoje nehual ilacal in cielo nipinahuas inahuac in se. Quema, nehual nipinahuas inahuac in se pa in tonali quiman nihualas ca laixpelalisli cualtichin pan lalticpan ca míac nochicahualisli nehual huan ichicahualisli noTajtzin huan inminchicahualisli in lanahuatinijmes pin cielo hual techtequipanuililo yihual huan nehual. ");
INSERT INTO nclNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Huan neli annimitzilía. Sequin hual nican moquezticate neli yulisi pa quitasi quinami cayas pa in tonali hual Dios huelitía pan lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Quiman lamic quinmilic Jesús in lajtomes, panuje quinami chicué tonalijmes, huan quinhuicac Pedro huan Juan huan Jacobo, panquisaje pan se loma (tepel) pa nepa Jesús quilajlanisquiaya Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Huan quiman lajlantataya yihual, mopalac iixco ca oc se lanextilisli. Itzotzomajli nesiaya iztatataya, laixpelatataya chicahuac. ");
INSERT INTO nclNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Huan moitilijque ome lacames laqueztataloaya ca yihual. Yehuanten cataloaya Moisés huan Elías ilajtunijmes Dios hual yulinijme pa yina. ");
INSERT INTO nclNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Yehuanten noje moitaloaya laixpelatataloaya, ca Jesús molaquetzililoaya quinami quipiaya pa miquisquiaya Jesús pa Jerusalén. ");
INSERT INTO nclNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Quipialoaya míac cochilisli Pedro huan in oc sequin imonextilinijmes. Ma yoje, ejsatiquisajque huan quitajque ilaixpelalisli chicahuac Jesús. Noje quinmitaje in omenten hual moqueztataloaya ca yihual. ");
INSERT INTO nclNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Cataloaya mijcuantataloaya in omenten capa Jesús moqueztataya, huan Pedro quilic: —Lamaxtini, unca cuali pampa ticate nican. Ma tiquinchihuacan ye calitos, se pa tehual huan se pa Moisés huan se pa Elías. Amo quimatiaya Pedro len quiliaya. ");
INSERT INTO nclNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ma yoje, quijtutataya inon, hualac se mextemil, quintzacuac. Huan momajtijque quiman quintzacuac in mextemil. ");
INSERT INTO nclNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Cuaquinon mocaquic se lajtol quistataya pin mextemil, quijtuc: —In noxolol hual niclasojla míac. Xicayacan anquicactica len yes quijtúa. ");
INSERT INTO nclNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Quiman lamic mocaquic in lajtol, jan moitilic Jesús ihuían san. Huan yehuanten amo nahuatijque nindeno pa innojen tonalijmes, amo quilamachiltijque amaqui in hual quitaje. ");
INSERT INTO nclNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Cataya mostatica quiman temujque pani in loma (tepel), quinamiquijque Jesús se lacalera. ");
INSERT INTO nclNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Huan se lacal ca yehuanten quinotzac Jesús chicahuac, quilic: —Lamaxtini, nicnequi pa tijchihuilis se cuali. Xichitili noxól, pampa jan in se san nicpía. ");
INSERT INTO nclNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Huan ¡xiquita! Se ijyecal cana huan jan ajnaxcan quilatzajtziltía, quitzejtzelúa, cuaquín quisa posunquil pa icamac huan quicahuilía aniles, quixacualúa, amo quinequi quimacahua. ");
INSERT INTO nclNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Huan niquintemachic momonextilinijmes pa quiquixtililosquiaya, huan amo huil quiquixtilije. ");
INSERT INTO nclNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús quinanquilic: —¡Amhuanten hual anyultica axan! ¡Amo anlaneltoca, anmitzmalinilic in lili anmoyolo pa se ojli amo cuali! ¿Quichi tonalijmes nicpías pa nicayas ca amhuanten? ¿Quichi tonalijmes nicpías pa niquitas cocolisli pa noyolo pampa amo annechneltoca? Xichualiquili moxól nican. ");
INSERT INTO nclNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Huan quihualiquilijtataya itajtzin, in ijyecal canac in xolol, quitzejtzeluc niman chicahuac, quimayajtiquisac. Jan axcan Jesús cajcajuac in ijyecal amo cuali huan quipajtic in xolol, cuaquinon quicuepilic in xolol itajtzin. ");
INSERT INTO nclNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Pampín mocahualoaya moiztataloaya in lacames ca lamajtilisli pampa quitajque Dios ilahueliltilisli hué. Huan quiman moiztataloaya ca lamajtilisli moxtin mochi innojen huejué hual quinchijtataya Jesús, yihual quinmilic imonextilinijmes: ");
INSERT INTO nclNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Xiclalican inon pa anmotzontecon hual annimitzilía: Amo huejcahuas ajsis in tonali quiman nehual ilacal in cielo nechtemacasi ca lacames hual cate Dios ilacocolinijmes. ");
INSERT INTO nclNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ma yoje, yehuanten amo quimatiloaya len quinequiloaya quijtulo in lajtomes, quinmolatililoaya len quinequiloaya quijtulo in lajtomes pa yoje amo quimatilosquiaya yehuanten. Huan momajtiloaya pa quilajlanilosquiaya len quinequiloaya quijtulo in lajtomes. ");
INSERT INTO nclNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Huan pehualoaya quinmolaxililo lajtomes yehuanten, laquetzaloaya pa quimatisi calía ca yehuanten yahuiaya ye in lacal hué. ");
INSERT INTO nclNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Huan Jesús momachiltic inon hual quijtuloaya laijtic inminyolo. Cuaquinon canac se xolotzindi, quiquetzac inahuac ");
INSERT INTO nclNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","huan quinmilic: —Se hual quimosehuiltía se xól tipichin pa quichihuilis mochi hual monequi, huan quichía inon pampa quineltoca pampa Dios nechtilanic pin lalticpan, cuaquín yoje in se nechmosehuiltía nehual. Huan aqui yes hual nechmosehuiltía, yoje quimosehuiltía yihual hual nechtilanic pin lalticpan. Yoje, yihual hual unca in niman tipichin ca anmoxtin cayas in niman hué. ");
INSERT INTO nclNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Cuaquinon Juan quilic: —Lamaxtini, tiquitaje se hual quinquixtiliaya ijyecames in lacames pan ipampa molahueliltilisli. Huan tiquilije pa camo quichihuasquiaya pampa yihual amo techtoca. ");
INSERT INTO nclNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús quilic: —Amo xiclatzacuilican, pampa aqui yes hual amo tejtzacuilía yoje techpalehuía. ");
INSERT INTO nclNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ajsitihualaya in tonali hual Dios yahuiaya quilejculti Jesús pin cielo, huan molalilic Jesús pa yas pa Jerusalén huan amaqui huil quitzacuiliaya. ");
INSERT INTO nclNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Quintilanic lanahuatinijmes pa lamachiltitialosquiaya pampa yihual yahuiaya huala. Cuaquín uyaje in lanahuatinijmes, ajsijque pa se icaltilan in samaritecos pa quilajlanilosquiaya sinda quipialoaya calijtic capa mocahuasquiaya Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Huan in samaritecos amo quinequiloaya pa ajsis capa yehuanten, pampa yihual yec se judío hual yahuiaya pa Jerusalén. ");
INSERT INTO nclNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Huan quimatijque inon imonextilinijmes Jacobo huan Juan, yoje quilijque: —Lamaxtini, ¿ticnequi pa tiquilisi pa temus itixuxli in cielo pa lamis quinchichinus yehuanten? Yoje pa yina quinchihuilic Elías in guaches. ");
INSERT INTO nclNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Momalinac Jesús, quinmiztataya Juan huan Jacobo, quinmajuac, quinmilic: —Ayamo anquimati quinami niquijtúa laijtic nehual. Nehual ilacal in cielo amo nihualaya pa niquinmictisquiaya lacames. Nihualaya pa niquinquixtilisquiaya pin ipolehuilisli inminlaijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Cuaquinon uyaje pa oc se caltilan. ");
INSERT INTO nclNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Huan nejnentiyahuiloaya pa ojli, se lacal quilic Jesús: —Tata, nicnequi nimitztoca ca capic yes tías tel. ");
INSERT INTO nclNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús quilic: —Quipialo in zorras inmincojcoyunqui, huan quinpialo inminchan in tutomes. Huan pa nehual ilacal in cielo amo unca capa nicpía nochan. ");
INSERT INTO nclNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús quilic oc se lacal: —Xichtoca nehual. Huan yihual quilic: —Xichmacahuilti pa nías niclaltocas notajtzin. Cuaquín nimitztocas. ");
INSERT INTO nclNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús quilic: —Ma quinlaltocacan inminmijquimes yehuanten hual yulticate mas que pa inminyolo miquije. Huan tehual, xía xiquinlamachilti lacames quinami huelitía Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Oc se lacal quilic Jesús: —Nimitztocas, Tata. Ma yoje, xinechmacahuilti pa nimochicahuas ca yehuanten pa nochan. Cuaquinon nimitztocas. ");
INSERT INTO nclNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Huan Jesús quilic: —Sinda se pehua laxahua huan sejpa huan oc sejpa lachixtía pa itepotzcon, yihual amo monotza pa laxahuas. Noje, sinda se pehua nechtoca huan sejpa huan oc sejpa quijnamictica in hual quixtocaya pin tonalijmes quiman ayamo pehuac nechtocac, cuaquín yihual amo monotza pa cayas capa Dios huelitía. ");
INSERT INTO nclNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Panujque innojen, quinsaluc in Tata Jesús oc sequin setenta, quintilanic ojꞌome huan ojꞌome pa yalosquiaya pa mochi caltilan capa yihual yahuiaya quinpaxaluili. ");
INSERT INTO nclNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Huan quinmilic: —Cate míac hual yalo nechneltocalo huan ticpialo pa tiquinnechicusi pa pehuas huelitis Dios pa inminyolo. Yoje yes quinami se quipía se cuajmili hué pa lapixcas huan amo quipía míac lacames pa quipalehuisi pa lapixcas. Pampín xictemachican in Teco hual unca Dios pa yihual quintijtilantiquisas míac oc sequin lacames pa techpalehuisi ca in lapixcalisli. ");
INSERT INTO nclNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ximohuicacan axan, huan xiquitacan: Annimitztilantica amhuanten huan anunca quinami borreguitos lajco capa cate coyomes. ");
INSERT INTO nclNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Amo xiquihuicacan xotopa pa tomin, amo xiquihuicacan xiquipili pa anquihuictías len anquicuas, amo xiquihuicacan oc sequin ome lacsames. Huan amo xiquinpialtitiacan in lacames hual anquinnamictías pa ojli. ");
INSERT INTO nclNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Quiman ancalaquis pan aqui yes icali, xipehuacan ca anquilis: “Xicayacan ca Dios imosehuilisli amhuanten pa in cali.” ");
INSERT INTO nclNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Huan sinda nepa iteco in cali unca se lacal hual quinequi pa cayas ca Dios imosehuilisli, cuaquinon amhuanten anquimatis, huan yihual cayas ca Dios imosehuilisli. Huan sinda iteco in cali amo quinequi caya ca Dios imosehuilisli, amhuanten anquimatis, huan yihual amo cayas ca Dios imosehuilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Huan xichantitiacan san pin cali capa anmitzajxiltisi. Xijcuacan huan xicunican len yes anmitzmacasi, pampa unca iyaxca in tequipanujquil ilaxlahuilisli. Amo ximopalacan pa anchantis pa oc se cali pa in cali capa anpehuac anchantic. ");
INSERT INTO nclNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Huan calía yes caltilan ancalaquis huan anmitzajxiltis, xijcuacan len yes hual anmitzmacasi pa anquicuas. ");
INSERT INTO nclNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Xiquinpajtican in cocoxquimes, huan xiquinmilican: “Nican ca amhuanten axcan ajsitihualac in tonali quiman Dios huelitía.” ");
INSERT INTO nclNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Huan pin calía yes caltilan ancalaquis huan amo anmitzajxiltisi xiquisacan pa iojlimes in caltilan, xiquinmilican: ");
INSERT INTO nclNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Quema, ilalmoluncal anmocaltilan hual salijtica capa tehuanten antimijtzejtzeluililo amhuanten. Yoje anquimatis pampa anquichíac len niman amo cuali pampa amo antechajxiltic tehuanten huan amo anquineltocac Dios ilamachiltilisli cuali. Jan yoje, xicmatican pampa ajsitihualac in tonali quiman Dios huelitía.” Yoje xiquinmilican. ");
INSERT INTO nclNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Annimitzilía inon: In tonali hual Dios quintojtocas ilaixpan yihual ipampa inminlaijlaculisli yehuanten pin lalticpan pa panusi polehuilisli hual amo quiman lamis, nepa yesi lacocoltili niman míac yehuanten hual yuliloaya pa in caltilan hual amo anmitzajxiltisi. Amo yoje míac yesi lacocoltili yehuanten hual yulinijme pin caltilan hué Sodoma, yehuanten in lacames ejꞌelehuis hual yulinijme pa yina. ");
INSERT INTO nclNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’Huan ¡quichi anyahui ancaya lacocoltili, amhuanten hual anyuli pin caltilan Corazín! Huan ¡quichi anyahui ancaya lacocoltili amhuanten pa Betsaida! Pa amhuanten niquinchíac míac hual anmitzlapolultije huan anmocahuac anmoiztica ca lamajtilisli pampa anquitac Dios ilahueliltilisli. Ma yoje, amhuanten amo anquipalac anmoyolo pa anpehuasquiaya anlaijnamiquía quinami Dios quinequi. Huan pa yina cataloaya in caltilan hué motocaya Tiro huan in caltilan hué Sidón. Huan sinda cataloaya lachihuali innojen huejué capa yehuanten, quipalaloaya inminyolo yehuanten pa laijnamiquilosquiaya quinami Dios quinequi. Jo quema, molaquentiloaya ca tzotzomajli xinqui huan molaliloaya pin tinextilan pa lanextilosquiaya quichi icnotiloaya pampa quichihuajque míac hual amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ma yoje, amo míac panusi lacocoltilisli yehuanten hual yulinijme pa Tiro huan Sidón quinami anpanus amhuanten hual anchanti pa Corazín huan Betsaida pa in tonali hual Dios quintojtocas ilaixpan yihual pa camo lamisi pa yesi lacocoltili yehuanten pin lalticpan hual amo quineltocalo. ");
INSERT INTO nclNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Huan amhuanten hual anchanti pa Capernaum, ¿cuajnesi anquijtúa ancayas se caltilan hual yehuanten pin cielo anmitzlasojlasi míac? Amo quiman. Amhuanten antemus capa cate in mijquimes, yajmo annesis. ");
INSERT INTO nclNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Aqui hual quicaqui len anquijtúa amhuanten nomonextilinijmes yoje quicaquía inon hual niquijtúa nehual. Huan aqui hual amo anmitzcaquía, yoje amo nechcaquía nel. Huan aqui hual amo nechcaquía, yoje amo quicaquía Dios hual nechtilanic. Yojque quinmilic Jesús imonextilinijmes. Cuaquinon mohuicajque. ");
INSERT INTO nclNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Panuje tonalijmes, mocuepajque ca niman míac paquilisli in setenta ca Jesús, niman pactataloaya, quilijque: —Tata, yehuanten in ijyecames amo cuajcuali techneltocalo pampa titechmacac tehual molahueliltilisli hual ticpía pampa tel iCristo de Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús quinmilic: —Nolacocolini Satanás quipiani ilahueliltilisli hué calica quinequini mopalehuiaya pa ajsisquiaya pin cielo. Ma yoje, axcan unca lasulahuali. Unca quinami niquitac hueztihualaya pin cielo quinami lapelanilisli, jan ajnaxcan yihual cataya lasulahuali. ");
INSERT INTO nclNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Xiquitacan. Annimitzmacac lajtol chicahuac calica anquipías lahueliltilisli pa anquinsulahuas nolacocolinijmes hual cate quinami cuhuames huan culomes. Yes quinami anquintelicsa nolacocolinijmes. Quema, huan annimitzmacac nolajtol chicahuac calica anquipías lahueliltilisli pa anquisulahuas huan anquixijxicus mochi ichicahualisli in lacocolini. Huan amo huil anmijchihuilisi nindeno pa anmijtzacuilis. ");
INSERT INTO nclNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ma yoje, amo xicayacan anpactica jan pampa anmitzneltocalo in ijyecames amo cuajcuali. Quema, xicayacan anpactica pampa quinmijcuiluc Dios anmotocajmes nepa pin cielo. ");
INSERT INTO nclNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Axcan in Espíritu Santo quimacac Jesús míac paquilisli, pampín ca paquilisli quilic: —Tehual noTajtzin, tel iTeco in cielo huan in lalticpan, nimitzilía inminlaixpan moxtin quinami timonotza pa timitzilisi quinami ticpía mochi lahueyilisli. Timonotza pa ticpías in, pampa tiquintzacuilic pa camo quimatisi innojen lachihualisli hual lanextilía quinami tihuelitía, tiquintzacuilic yehuanten hual quijtulo pampa quimatilo. Quijtulo pampa amo monequi pa tiquinpalehuis tehual. Jo quema, tiquintzacuilic yehuanten huan ma yoje tiquinnextilic yehuanten hual quimatilo pampa monequi pa tiquinpalehuis tehual. Quema, noTajtzin, inon ticchihuac pampa tiquitac cuali pa ticchihuasquiaya yoje. ");
INSERT INTO nclNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Cuaquinon Jesús quinmilic imonextilinijmes: —Nechmacac noTajtzin nehual mochi lahueliltilisli huan nechmacac mochi len quichíac. Huan amo unca oc se, jan Dios in Tajtzin san hual quimati aqui niunca nehual ixól. Huan amo unca oc se, jan nehual san hual quimati aqui unca in Tajtzin Dios. No, amo unca oc se, jan nehual san huan aqui yes hual nicnequi nicnextili aqui unca noTajtzin. ");
INSERT INTO nclNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Cuaquinon momalinac quinmiztataya imonextilinijmes, quinmilic pa jan yehuanten san quicaquilosquiaya, quinmilic: —Xicayacan ca niman míac paquilisli amhuanten pampa anquinmiztica innojen hual panujticate anmoyampa. ");
INSERT INTO nclNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","In annimitzilía pampa cataloaya míac ilajtunijmes Dios huan míac huejueyenten hual quinequiloaya quinmitalo innojen hual amhuanten anquinmita, huan ma yoje amo quinmitaje. Huan quinequiloaya quicaquilo innojen hual anquincaqui, huan amo quicaquije. ");
INSERT INTO nclNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Cuaquinon moquetzac se ilamaxtini inminlajtol in judíos, quinequiaya quichihuili pa quijtusquiaya Jesús len lajtol calica huil quimotexpahuilisquiaya, quilajlanic: —Lamaxtini, ¿len nicchías pa nicanas yulilisli hual amo quiman lamis? ");
INSERT INTO nclNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús quinanquilic: —¿Len unca lajcuiluli pa ilajtol Dios? ¿Len anmitznextilía pin lajtol? ");
INSERT INTO nclNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Quinanquilic ilamaxtini in lajtol, quilic: —In lajtol quijtúa: “Ticlasojlas in Tata moDios ca mochi quinami huil ticlasojla pa moyolo huan ca mochi quinami huil ticlasojla pa moyulilisli huan ca mochi mochicahualisli huan ca mochi molaijnamiquilisli. Huan ticlasojlas in oc se hual unca ca tehual san quinami tehual timolasojla.” ");
INSERT INTO nclNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús quilic: —Cuali tilananquilic. Xicchía inon huan amo tilamis tiyulis. ");
INSERT INTO nclNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ma yoje, in lamaxtini quinequiaya monapati pampa Jesús quilic inon. Pampín quilajlanic: —Huan ¿aqui tiquijtúa unca in oc se hual nicpía pa niclasojlas? ");
INSERT INTO nclNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Canac Jesús in lajtol, quilic: —Cataya se lacal quisac pa Jerusalén, temujtiahuiaya pa in caltilan Jérico. Quinnamiquic sequin laxtequinijmes hual quitecuaje huan quixtequilije mochi, quiquixtilije itzotzomajli, cuaquín uyaje, quicahuaje lastataya in lacal, ca je nadita miquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Huan quinami panuc, yajtihualac se tiopista pa in ojli, quitac in lacal, panuc ca yoje pa in ojli. ");
INSERT INTO nclNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Cuaquín hualac se levita (se de yehuanten hual tequipanulo pin tiopan hué), huan quitac. Yihual noje panuc ca yoje pa in ojli, quinami in tiopista. ");
INSERT INTO nclNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Cuaquinon umpa panujtihualaya se lacal samariteco hual amo anquixtoca. Quipanajtihualaya tolali. Quitac in lacal huan quicniliaya yihual. ");
INSERT INTO nclNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Hualac ca yihual, quinlalilic dangos pin sahuames capa quitecuaje, quinxahuilic ca chahuac huan iayo uva coc. Cuaquinon quilejcultic pan yihual iburro, quihuicac pan se cali, nepa quitaya pa quipajtis. ");
INSERT INTO nclNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mostatica pa huajtzinco quimacac tomin iteco in cali, quilic: “Xiquita yihual huan mochi hual ticpías pa ticlaxlahuis pa in hual monequi pa quipías yihual, nehual nimitzcuepilis in tonali nimocuepas ca níc.” ");
INSERT INTO nclNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Axan —quilic Jesús—, ye lacames quitaje in lacal hual laixtequinijmes quitecuaje. ¿Calía ca in yeyenten quichihuilic in lacal quinami quijtúa in lajtol pa ticchihuilisi mochi oc se hual moita ca tehuanten? ");
INSERT INTO nclNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","In lamaxtini quinanquilic Jesús, quilic: —Yihual hual quipiliaya laicnililisli in lacal hual quitecuaje, yihual quichihuilic quinami quijtúa in lajtol. Cuaquín Jesús quilic: —Xía huan xicchía quinami yihual quichíac. ");
INSERT INTO nclNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yajtiahuiloaya yehuanten pan ojli, Jesús ihuían calaquic pan se caltilan tipichin, nepa cataya se sihual motocaya Marta, yehuanten moiximatiloaya. Yihual quinotzac Jesús pa quipaxaluilisquiaya pa ichan. ");
INSERT INTO nclNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Huan Marta quipiaya se icni sihual motocaya María. Yihual molalic pa icxihuajmes in Tata Jesús huan pehuaya quicaqui quinami quimaxtiaya ilajtol Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ma yoje, icni Marta laijnamiquiaya siajtataya pampa quiyucxiltiaya mochi pa quicuasquiaya Jesús. Cuaquín hualac capa cataya Jesús, quilic: —Tata, ¿amo tiquita quinami nocni nechcahuac pa nitequipanusquiaya nohuían? Xiquili pa hualas nechpalehuis. ");
INSERT INTO nclNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Huan in Tata Jesús quinanquilic: —Marta, Marta, timomaca míac tequil huan amo huil timosehuía. ");
INSERT INTO nclNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Jan inon san monequi pa ticchías quinami María quichijtica. Quinequiaya quichía in cuali, quinequiaya quicaqui ilajtol Dios. Amaqui quiquixtilis María in hual yihual cana quicactica ilajtol Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Cataya se tonali cataya Jesús pan se lajcotiyan capa quilajlantataya Dios. Nepa noje cataloaya imonextilinijmes. Lamic quilajlanic, se imonextilini quilic: —Tata, xitechnextili pa ticmatisi quinami ticlajlanisi Dios, quinami Juan Lacuayatequini quinnextilic imonextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Huan Jesús quinmilic: —Quiman anquilajlanía Dios, xiquilican yoje: ToTajtzin Dios hual tiunca pin cielo, ma quijtucan moxtin motoca ca mochi inminlasojlalisli huan inminlajtomes huejué huan cuajcualtichin. Ma ajsi in tonali hual tihuelitía capa tehuanten. Ma mochía len ticnequi pan lalticpan jan quinami mochía pin cielo. ");
INSERT INTO nclNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Xitechmaca mojmosta pa tijcuasi in hual monequi. ");
INSERT INTO nclNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Huan xiquinpujpuhua tolaijlaculisli, pampa yoje tiquinpujpuhualo moxtin yehuanten hual tejchihuililo amo cuali. Huan amo xitechlaicana ca capic Satanás huil techtilanilía toyolo pa ticchihuasi len amo cuali, quema, huan xitechmacahuili pa camo techana yihual hual elehuis. ");
INSERT INTO nclNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Cuaquinon quinmilic: —Cuajnesi se ca amhuanten ticpía se mocni hual chanti pa oc se cali huan tiajsi pa ichan yihual pa lajco layúa huan tiquilía: “Eh, Nito, ¿amo ticpía se ome laxcali pa tichlanehuis? ");
INSERT INTO nclNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ajsic pa nochan se tocni pa oc se cali panujtihualaya pa ojli, huan amo nicpía nindeno pa nicmacas pa lacuas” tiquilía. ");
INSERT INTO nclNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Huan pa calijtic yihual quinanquilía: “Amo xichyantitihuala. Nictzacuac nochan, axan tilasticate pa tolapexlimes nehual huan noxolomes. Amo huil nimoquetzas pa nimitzmacas nindeno” quilía. ");
INSERT INTO nclNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Annimitzilía —quilic Jesús—, cuajnesi in se pa icalijtic amo moquetzas pa mitzmacas tehual ome laxcali mas que tiunca icni pa oc se cali. Ma yoje, tehual hual tiunca icni pa quiahuac amo tipinahuac timotemachilic in se ome laxcali. Pampín, mocni pa calijtic neli moquetzas mitzmacas mochi in hual monequi pa ticpías. ");
INSERT INTO nclNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Huan annimitzilía: Ximotemachilican, huan Dios anmitzmacas. Xictemucan len Dios quipía pa amhuanten, huan anquitas. Quema, xiclajlanican Dios, unca quinami anquitecuilijtica pa ilalapujquil Dios. Huan anmitzlapulis. ");
INSERT INTO nclNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Xicchihuacan yoje pampa ancanas mochi hual len anmotemachilía Dios pa anmitzmacas. Huan moxtin hual len quitemulo in hual Dios quipía pa quinmacas, quema, yehuanten quitalo. Huan moxtin hual quinami quitecuililo ilalapujquil Dios, yoje Dios quinlapulis. ");
INSERT INTO nclNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Amo unca se itajtzin ca amhuanten hual quimacas se tixcali ixól sinda ixól motemachilía len quicuas. Noje amo unca se tata hual quimacas se cuhual sinda motemachilis se michin. ");
INSERT INTO nclNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Huan amo unca se tata hual quimacas se culol ixól sinda motemachilis se blanquillo. ");
INSERT INTO nclNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pampín, mas que amhuanten anunca amo cuajcuali huan ma yoje anquimati anquinmaca anmoxolomes len unca cuali, cuaquinon anmoTajtzin pin cielo quimati niman cuali quinmaca in Espíritu Santo yehuanten hual quimotemachililo. ");
INSERT INTO nclNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Cataya se tonali quiquixtiliaya Jesús se ijyecal amo cuali se lacal. In ijyecal amo cuali quichihuilini pa camo huil lajtusquiaya in lacal. Huan quisac pa yihual in ijyecal amo cuali, yoje pehuac lajtuc in lacal. Mocahuajque moizticate huan moilijticate in míac lacalera. ");
INSERT INTO nclNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ma yoje, sequin quilijque: —Yihual quinquixtilía in ijyecames hual amo cuajcuali pan ipampa ilahueliltilisli Beelzebú hual unca Satanás. Yihual huelitía ca moxtin in ijyecames hual amo cuajcuali. ");
INSERT INTO nclNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Oc sequin quimahuililoaya huan quijtuloaya pampa cuajnesi amo unca neli yihual Jesús yes in Cristo hual Dios quitilanic. Pampín quiyantiloaya pa yihual quinnextilisquiaya len pin cielo (ilhuicac) calica momahuisultilosquiaya ca lamajtilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Huan quimatic Jesús len quijtuloaya laijtic capa inminyolo, pampín quinmilic: —Sinda amo cate ca se lajtulisli yehuanten hual huelitilo pa se lali, cuaquín amo huejcahuas inminlahueliltilisli, yajmo cayas. Huan sinda amo cate ca se lajtulisli yehuanten pa se cali huan mocualantitialo yehuanten, cuaquín yajmo huil huejcahuasi pa chantisi pa in se cali, yajmo cayas inminchan. ");
INSERT INTO nclNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Huan sinda Satanás huan yehuanten hual huelitilo ca yihual amo cate ca se lajtulisli, cuaquín amo huejcahuas Satanás pa huelitis. Inon anquimati. ");
INSERT INTO nclNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ma yoje, sinda anquijtutica pampa nehual niquinquixtilía ijyecames amo cuajcuali ca ilahueliltilisli Beelzebú, cuaquinon ¿ca aqui ilahueliltilisli quinquixtililo yehuanten anmolacames hual quimatilo quinquixtililo? ¿Anquijtutica pampa yehuanten quinquixtililo noje ca ilahueliltilisli Beelzebú? Sinda yoje anquijtutica, cuaquinon yehuanten anmitzmotexpahuilisi ilaixpan Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Axan annimitzilía pampa niquinquixtilía ca Dios ilahueliltilisli. Pampín, axan ajsic Dios huelitijtica capa amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Unca quinami se lacal chicahuac hual quiztica ca teposli pa moanalisli ilajcotiyan capa quinpía mochi hual iyaxca, huan amo unca nindeno hual quimacas tequil. ");
INSERT INTO nclNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ma yoje, sinda hualas se niman chicahuac huan quisulahuas, cuaquín quiquixtilis mochi calica monapatiaya, huan cuaquín in lacal niman chicahuac laxiluilis mochi len quinpiaya in lacal hual amo yoje chicahuac. Huan yoje cayas ca Satanás sinda ajsis capa yihual ilahueliltilisli Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Aqui hual amo nechtoca unca nolacocolini. Huan aqui hual amo nechpalehuía nehual, yoje yihual quipalejtica Satanás. ");
INSERT INTO nclNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Quisa in ijyecal amo cuali pa se lacal, panujtía pa cajcapa amo unca al, mochi unca huaqui. Nepa panujtía pa quitas capa huil mosehuis. Sinda amo quita capa huil, cuaquín quijtúa: “Nimocuepas pa nochan hual cataya laijtic capa in lacal capa niquisac.” ");
INSERT INTO nclNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Cuaquinon huala, huan quita quinami unca laijtic capa in lacal. Unca quinami se cali laxpanali huan lachijchihuali cualtichin, amo chantitica nepa se ijyecal amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Cuaquín yahui quinmana oc sequin chicome ijyecames niman amo cuajcuali, yihual amo quiman cataya yojque amo cuali. Calaquilo yehuanten moxtin laijtic capa in lacal pa nepa chantisi. Yoje mococúa in lacal niman míac axan. Quema, amo yoje míac mococuni quiman quipiani jan in se ijyecal amo cuali laijtic capa yihual. ");
INSERT INTO nclNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Huan quijtutataya Jesús innojen lajtomes, cataya se sihual ca in míac lacames huan sihuames, quinotzac ca lajtol chicahuac, quilic: —¡Niman míac paquilisli quipía in sihual hual mitzlacatiltic huan mijchichiltic! ");
INSERT INTO nclNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Huan Jesús quilic: —Ma yoje, niquijtúa in paquilisli amo unca yoje hué quinami inon hual quipialo yehuanten hual quicaquilo ilajtol Dios huan quichihualo len quinmilía, yehuanten hual quipixticate ilajtol pa inminyolo. ");
INSERT INTO nclNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Se tonali ajsitihualaloaya míac míac lacames inahuac Jesús, huan yihual pehuaya quinmili: —Amhuanten hual anyultica axan anunca lacames anquipixtica anmoyolo amo cuajcuali. Mojmosta annechyantitica pa annimitznextilis pa in cielo len hual ayamo quiman anquitaya. Anquinequi anquita pa yoje anquineltocasquiaya pampa Dios nechtilanic nican pa in lalticpan. Ma yoje, amo annimitznextilis nindeno hual anquinectica anquita. Jan annimitznextilis inon san hual Jonás ilajtuni Dios quinnextilic yehuanten hual chantinijme pa yina pin caltilan hué motocani Nínive. ");
INSERT INTO nclNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonás quinnextilic yehuanten pa Nínive pampa Dios quitilanic yihual. Huan nehual ilacal in cielo annimitznextilis amhuanten pampa Dios neli nechtilanic nehual pin lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Cayas in tonali hual Dios quintojtocas ilaixpan yihual yehuanten pa in lalticpan hual amo quineltocalo, quintojtocas pa panusi lacocoltilisli hual amo quiman lamis. Cuaquín in hué sihual hual huelitini pin lali huejca pa in sur nesis ilaixpan Dios ca amhuanten. Huan in sihual noje quijtus quinami Dios, pampa yihual hualac niman huejca pa quicaquisquiaya ilajmatilisli in hué Salomón hual yulini pa yina. Huan xiquitacan. Unca se hué nican hual yoje hué amo cataya Salomón. ");
INSERT INTO nclNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Yehuanten hual yulinijme pa Nínive nesisi ilaixpan Dios ca amhuanten huan quijtusi quinami Dios. Yehuanten quipalaje inminyolo pa pehualosquiaya laijnamiquilo quinami Dios quiman Jonás quinnotzac quinmilijtataya ilajtol Dios. Huan xiquitacan. Unca se hué nican hual Jonás amo cataya yoje hué. ");
INSERT INTO nclNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesús laqueztiahuiaya, quinmilic: —Amaqui quilalaltía se tapalquita hual lahuía huan cuaquín quilalía capa amaqui unca o quilalía itzindan se chiquihuil. No, quilalía pa pani capa nestías pa quinlahuis yehuanten hual calacticate. ");
INSERT INTO nclNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Iixtololon se unca quinami se tapalquita hual quilahuilía, yoje huil lachía se. Sinda amo unca len hual quitzacuilía iixtololon se, cuaquinon quita in lahuilisli. Huan sinda unca len amo cuali hual quitzacuilía se iixtololon, cuaquinon amo lachía, jan unca laticumac san. Unca yoje ca iyolo se. Sinda unca amo cuali iyolo se, cuaquín in se unca laticumac. ");
INSERT INTO nclNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Pampín xictemujtiacan quinami anquimatis da anmoyolo quipía lahuilisli o laticumactitica. ");
INSERT INTO nclNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Yojque, sinda quimacahuiltía se pa calaquis pa iyolo ilajtol Dios pa huelitis ca yihual pa yulis quinami Dios quinequi, cuaquinon yajmo laticumactis pa iyolo. Huan yihual yes quinami se ca iixtololon cuali. Cayas quinami icalijtic se capa lajtica cuali se tapalquita hual lahuía. Yihual yulis quimaztica len quinequi quijtúa ilajtol Dios hual quilahuilijtica pa iyolo. ");
INSERT INTO nclNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Mocahuac Jesús pa quinlaquetzilic, quihuicac se lacal fariseo pa lacuasquiaya Jesús pa ichan. Yoje calaquic Jesús, molalic pa lacuas. ");
INSERT INTO nclNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Huan mocahuac quiztica in fariseo pampa quitac Jesús amo pehuac ca in lapacalisli imajmajuan pa lacuasquiaya, quinami quijtúa in lajtol hual quimaxtilo in judíos. ");
INSERT INTO nclNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","In Tata Jesús quilic: —Axan, quema, amhuanten in fariseos anquijtúa pampa da anmopaquilía, cuaquín yoje anmitzita chipahuac Dios. Ma yoje, pa laijtic amhuanten capa anmoyolo anunca niman amo cuali ca mochi hual anquijtúa huan anquichía. Anunca quinami se hual quipaquilía pa quiahuac se tapalcal o se tapalquita xalapa, huan pa laijtic quicahua tetzcuinuc. Yoje anunca tetzcuinuc laijtic anmoyolo. ");
INSERT INTO nclNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Amo anlaijnamiquía! Dios quichíac ilaijtic se iyolo, amo quichíac jan iquiahuac se. ");
INSERT INTO nclNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Huan amo xicpiacan len laijnamiquilisli inahuac len yes anmolajtol quijtúa inahuac quinami anmopaquilis. Xicmacahuiltican pa ilajtol Dios anmijchipahuilis anmoyolo, cuaquinon xiquinmijnamiquican yehuanten hual amo quipialo míac pa yoje anquinmacas sequin ilajlajco in hual anquipías. Yoje anquitas pampa mochi unca chipahuac pa amhuanten sinda unca chipahuac anmoyolo. ");
INSERT INTO nclNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Amhuanten fariseos, ¡quichi lacocoltilisli anyahui anpanu! Anquimaca Dios se ilajco in majlacli inminlajlajco mochi anmocominos huan anmoyerbabuena huan in oc sequin anmoajuíac, quinami quijtúa ilajtol Dios. Ma yoje, ilajtol Dios noje quijtúa pampa anquipía pa anquilasojla oc sequin, huan amo anquinlasojla. Noje quijtúa in lajtol pampa anquipía pa anquintemus inon hual cuali pa anquinchihuilis oc sequin hual panulo lacocoltilisli hual oc sequin quinchihuililo. Huan amo anquinchihuilía, amo anquinmotexpahuililo yehuanten hual quinchihuililo in amo cuali. Monequiaya pa anquichihuasquiaya innojen hual quijtúa in lajtol. Quema, monequiaya pa camo anquicahuas pa anquimacas in se ilajco inminmajlacli innojen hual ajuíac. Ma yoje, monequi pa anpehuas anquijnamiquis anquichías in hual monotza in niman míac pa ilajtol Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Quichi lacocoltilisli anyahui anpanúa amhuanten fariseos! Anquixtoca anmolalía pin tiopajmes capa moxtin anmitzitasi. Anquixtoca pa moxtin anmitzpialtisi ca míac momajtilisli pa ilajcotiyan in caltilan. Quema, anyahui anpanúa lacocoltilisli pampa inon. ");
INSERT INTO nclNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Huan ¡quichi lacocoltilisli anyahui anpanúa! Anunca quinami cajcapa quinlalpachuje mijquimes, capa yajmo quitalo lacames capa cate. Amo quimatilo sinda nejnentialo inminpan, huan in lajtol quijtúa pampa lacames yajmo cate chipahuac sinda nejnemilo inminpan. Jan yoje unca ca lacames hual quineltocalo len anquimaxtía. Amo quimatilo pampa anmolamaxtilisli amo unca quinami quijtúa ilajtol Dios. Yoje inminyolo amo unca chipahuac, unca jan quinami anmoyolo amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Quinanquilic se ilamaxtini inminlajtol in judíos, quilic: —Lamaxtini, tiquijtúa innojen lajtomes, yoje titechuejuecaltitica tehuanten noje. ");
INSERT INTO nclNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Huan Jesús quilic: —Amhuanten noje ilamaxtinijmes in lajtol, ¡quichi lacocoltilisli anyahui anpanúa! Unca pampa anquinchía niman míac lajtomes hual cate niman ejꞌetic pa quinneltocasi lacames. Cate lajtomes quinami se lamamalisli niman etic, huan amhuanten amo je nadita anquinneltoca in lajtomes hual anquinmilía oc sequin pampa quipialo pa quinneltocasi. ");
INSERT INTO nclNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Quichi lacocoltilisli anyahui anpanúa! Unca pampa amhuanten anquinchíac in calitos hual anquinlalía pa pani capa quinlalpachuje Dios ilajtunijmes. Huan cataloaya anmotajtzitzían hual quinmictije ilajtunijmes Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yoje anquimati cuali len quichihuaje anmotajtzitzían, huan anquixtoca len quichihuaje, pampa yehuanten quinmictije huan amhuanten anquinchía in caltzindis hual anquinlalía pa pani capa quinlalpachuje Dios ilajtunijmes. ");
INSERT INTO nclNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Pampín noje Dios ca ilajmatilisli hué quijtuc: “Annimitztilanilis nolajtunijmes huan nolanahuatinijmes. Sequin anquinmictis, oc sequin anquintojtocas.” ");
INSERT INTO nclNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Yoje, Dios anmitzmotexpahuilis pampa cataloaya lamictili moxtin ilanahuatinijmes, yehuanten hual yulinijme quiman pehuac in lalticpan huan yehuanten hual yultihualalo pa axan. ");
INSERT INTO nclNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Jo quema, anmitzmotexpahuilis pa yoje anmitztojtocas ilaixpan yihual pampa cataya lamictili Abel inminxól Adán huan Eva. Huan anmitztojtocas ilaixpan yihual pampa cataloaya lamictili moxtin in oc sequin ilajtunijmes hual yultihualaloaya quiman miquic Abel, pa quiman cataya lamictili Dios ilajtuni Zacarías. Yihual quimictije lajco pin ilasojli calijtic in tiopan hué huan inon capa quichichinulo in huendis, nepa quimictije. Jo quema —quinmilic Jesús—, annimitzilía inon, anmitzmotexpahuilis Dios pa anmitztojtocas ilaixpan yihual pampa quichihuajque mochi in lamictilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Quichi lacocoltilisli amhuanten ilamaxtinijmes in lajtol anyahui anpanúa! Unca pampa amo anquinmaxtic lacames in hual quinequi quijtúa ilajtol Dios. Amhuanten amo anquinequic anquimatic len quinequi quijtúa, huan anquintzacuilic pa camo quimatilosquiaya yehuanten hual motoliniloaya pa quimatilosquiaya len quinequi quijtúa. ");
INSERT INTO nclNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Cuaquinon, quisac Jesús nepa. Huan in lamaxtinijmes huan in fariseos pehualoaya moanalo chicahuac ca lajtomes ca Jesús. Motoliniloaya pa quilaquetzaltilosquiaya Jesús niman míac. ");
INSERT INTO nclNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Yojque quinapachiloaya Jesús, quinequiloaya quicaquilo pa yihual quijtus len calica huil quimotexpahuililosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jan pan tonali hual panuloaya innojen, monechiculoaya míac lacames huan sihuames, niman míac míac hualaloaya huan pampín motelicsilijtihualaloaya. Huan Jesús pehuac quinlaquetzilic imonextilinijmes, quinmilic: —Xiquiztiacan amhuanten pa camo anquimacahuiltis pa anmitztechcunilis pa anmoyolo in lacuajcuamanalisli quinami quintechcunilía inminyolo in fariseos. Unca quinami itexli in harina quitechcunía in laxocoyajquil. ");
INSERT INTO nclNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Amo unca nindeno hual unca latzacuali hual amo yes lalapuli. Huan amo unca nindeno lalatili hual amo yes lamatili. ");
INSERT INTO nclNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yoje, len yes hual anquilic capa cataya laticumac hual amo anquinequic pa oc sequin quicaquilosquiaya, jan yoje inon quicaquisi capa amo huil quimolatilis nindeno, quinami capa lajtica. Huan len yes hual anquilis pa se calijtic pa camo quicaquilosquiaya oc sequin, jan yoje in quinahuatisi moxtin. ");
INSERT INTO nclNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Huan annimitzilía inon, nocnían lajlasojli. Amo ximomajtican pampa lachames huil quimictilo icuerpo se huan cuaquinon yajmo huil quichihuilisi nindeno. ");
INSERT INTO nclNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ma yoje, annimitznextilía aqui monequi pa anmomajtis. Ximomajtican pampa Dios quipía lahueliltilisli pa quilasas se pin capa lalatica huan milintica quiman quimictía. Quema, annimitzilía, ximomajtican pampa yihual huil quichía. ");
INSERT INTO nclNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Quinnamacalo macuili tutotzindis pa macuili tomin tijtipichin. Ma yoje, Dios amo quilcahua se tutol hual moitilía ca yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Jo quema, huan mochi sejse itzondi anmotzontecon unca lapuhuali. Yoje, amo ximomajtican. Amhuanten anmonotza niman míac, amo yoje míac monotzalo míac tutotzindis. ");
INSERT INTO nclNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Huan annimitzilía inon. Aqui yes hual nechneltoca huan quijtus pampa nehual niunca iCristo Dios, huan quijtus inon inminlaixpan moxtin, cuaquín nehual ilacal in cielo niquislacus inminyampa Dios ilanahuatinijmes pin cielo. ");
INSERT INTO nclNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Aqui yes hual quijtus pampa nehual amo niunca iCristo Dios, cuaquín yihual amo niquislacus inminyampa Dios ilanahuatinijmes pin cielo. ");
INSERT INTO nclNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Huan aqui yes hual nechuejuecaltis nehual ilacal in cielo, yihual Dios quipujpuhuas ilaijlaculisli. Ma yoje, sinda se quihuejuecaltis in Espíritu Santo, inon Dios amo quipujpuhuas. ");
INSERT INTO nclNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Huan cuajnesi anmitzhuicalo inminlaixpan yehuanten hual huelitilo o yehuanten hual quipialo lahueliltilisli. In tonali hual anmijchihuililo inon, amo ximotolinican pa anquijnamiquis lajtol calica anyahui anmonapatía o calica anyahui anquinmilía. ");
INSERT INTO nclNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Anmitznextilis in Espíritu Santo len anquipías pa anquinmilis jan axcan quiman yes anlajtus. ");
INSERT INTO nclNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Se lacal hual cataya nepa ca in míac lacames quilic: —Lamaxtini, xiquili nocni pa yihual nejxiluilis nehual len techcahuilic totajtzin in tonali polehuic. ");
INSERT INTO nclNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús quilic: —Lacal, ¿aqui nechlajtultic pa niyesquiaya ilaxiluni in hual iyaxca motajtzin? ");
INSERT INTO nclNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Cuaquín Jesús quinmilic in lacalera: —Xiquitacan. Ximotzacuilican pa camo anquinectías míac huan míac. Niquilía inon pampa mas que quipía se míac hual iyaxca, ma yoje in míac hual quipía amo quiyuliltía. ");
INSERT INTO nclNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Cuaquinon quinpuhuilic len pa quinmijnamiquiltisquiaya in hual quinmaxtiaya. Quinmilic: —Cataya se lacal hual quipiaya míac tomin huan pa icuajmilimes lapixcaya niman cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Cuaquinon pehuaya moili: “¿Len nicchías pampa yajmo nicpías calijtic capa nicajcoquis nolapixcalisli?” ");
INSERT INTO nclNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Cuaquinon quilic: “Inon nicchías. Niquinxitinis nocalijtic capa nicajcoquis huan niquinmiscaltis nocalimes pa yesi niman huejué. Cuaquinon nicnechicus mochi hual len nicpixcas, nolayoli huan mochi oc sequin innojen hual noyaxca huan niquintemiltis nocalimes. ");
INSERT INTO nclNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Cuaquinon nimoilis: Axcan nehual nicpía míac laꞌajcoquili hual nechuejcahualtis míac xixíl. Nimosejtías, huan mojmosta nía nilacua huan nía nilauni huan nía nipaqui.” Yoje quilic in lacal. ");
INSERT INTO nclNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ma yoje, Dios quilic: “¡Amo ticmati tilaijnamiquía! Axan layúa tía timiqui. Cuaquín ¿aqui moyaxcajtis ca mochi inon hual timoajcoquilic?” Yoje quilic Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Cuaquinon, Jesús quinmilic: —Yoje yes ca se hual yuli moajcoquilijtica míac pa yihual nican pan lalticpan huan ma yoje amo moajcoquilía míac in hual Dios quipía pa quimacas. ");
INSERT INTO nclNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Huan Jesús quinmilic imonextilinijmes: —Pampín annimitzilía amo xicpiacan lamajtilisli inahuac quinami amhuanten anyulis huan len anquicuas. Huan amo xicpiacan lamajtilisli inahuac quinami anmolaquentis. ");
INSERT INTO nclNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","No, amo xilaijnamiquican ca lamajtilisli pampa inon. Dios anmitzmacac anmoyulilisli, huan anmoyulilisli monotza míac. Amo yoje míac monotza in hual anmitzmaca pa anquicuas. Huan Dios quichíac anmocuerpo, huan anmocuerpo monotza míac, amo yoje míac monotza inon hual anmitzmaca pa anmolaquentis. ");
INSERT INTO nclNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Xiquinmitacan in cuervos (cacalomes). Amo latocalo, amo lapixcalo, amo quipialo capa huil moajcoquililo nindeno. Ma yoje, Dios quinlacualtía. Huan amhuanten anmonotza míac. In tutomes amo yoje míac monotzalo. ");
INSERT INTO nclNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Huan cuajnesi anquinequi pa huejcahuas anmoyulilisli nican pan lalticpan. Ma yoje amo huil anquihuejcahualtis se nadita, mas que míac anmomajtía anlajtutica pa anmoyolo pa anhuejcahuas anyulis. ");
INSERT INTO nclNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Pampín, sinda amo huil anquichía jan in nadita san, cuaquinon ¿leca anlaijnamiquía ca momajtilisli pa anquimatis quinami ancanas mochi inon hual monequi pa anquipías? ");
INSERT INTO nclNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Xiquinmitacan in xuchimes quinami moscaltilo. Amo tequipanulo, amo latzahualo, amo lajquetilo. Ma yoje, annimitzilía pampa Salomón ca mochi itomin huan innojen oc sequin hual quipiani amo quiman molaquentini cualtichin quinami se xuchil quinami innojen. ");
INSERT INTO nclNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Huan sinda Dios quichijchía se xuchil quinami tzotzomajli cualtichin, se xuchil hual unca axan pin cuajlan huan mosta quichichinulo inmincuajlan in cuajmilunijmes, cuaquín neli unca pampa Dios yahui anmitzlaquentía amhuanten hual amo míac anquilalilía Dios anmolaneltocalisli. Pampín, xicpiacan míac laneltocalisli ca Dios. Huan mas que amo anquipía míac laneltocalisli ca Dios, ma yoje anmijchihuilis innojen. ");
INSERT INTO nclNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Huan amhuanten, amo xictemujtinemican len anquicuas huan len ancunis, amo xiclaijnamiquican ca lamajtilisli inminahuac innojen. ");
INSERT INTO nclNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Moxtin pin lalticpan quintemulo innojen, quijnamicticate ca lamajtilisli quinami quinmanas. Huan anmoTajtzin pin cielo quimati pampa monequi pa anquipías innojen. ");
INSERT INTO nclNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","No, xictemucan mojmosta pa anquipías Dios huelitijtica pa anmoyolo, huan yihual anmitzmacas mochi in hual monequi pa anquipías. ");
INSERT INTO nclNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Amo ximomajtican, amhuanten niman miactzindi hual annechneltoca, pampa Dios huelitía pa anmoyolo axcan huan amhuanten anhuelitis pan mochi in lalticpan. Jo quema, Dios quipía paquilisli pa anmitzmacas pa yes anmoyaxca inon pa anhuelitis. ");
INSERT INTO nclNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Xiquinnamacacan len anquipía huan xiquinmacacan yehuanten hual amo quipialo nindeno. Sinda anquinchihuilía cuali ca anmotomin, cuaquín amo anquipolúa, pampa Dios quita len anquinchihuilía huan anmitzajcoquilis míac hual cuali pin cielo. Yes quinami anmochihuiliaya xotopas hual amo quiman mochihualoaya dangochita ca cojcoyunquimes capa quisasquiaya anmotomin huan yoje mopolusquiaya. Pin cielo amaqui huil anmitzixtequilía in hual Dios anmitzajcoquilía, huan in laxinaxli amo anmitzcualilo. ");
INSERT INTO nclNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sinda anquixtoca in hual Dios huil anmitzajcoquilía pin cielo, cuaquín mojmosta anquijnamictías inon. Huan sinda anquixtoca in míac hual cate pin lalticpan, cuaquín mojmosta anquijnamictías inon. ");
INSERT INTO nclNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Yoje, xiyén quinami lacames tequipanujquimes hual cate lacuejtili pa latequipanuilisi. Quimpiasi lalalaltili mochi in tapalquitos pa lahuilisli pin cali. ");
INSERT INTO nclNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Quichixtiasi inminteco hual yahui mocuepa pa ichan pampa uyac pa se lanamictilisli. Huan quiman ajsis in teco huan lanotzas pa in lalapujquil, yehuanten hual quichixticate quilapulisi jan ajnaxcan. ");
INSERT INTO nclNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Quichi paquilisli quipiasi in lacames pa in tonali ajsis inminteco huan quinmita quichixticate yihual. Jo quema, annimitzilía, mochijchías inminteco, quinmilis pa molalisi pa lacuasi huan yihual quinlacualtis. ");
INSERT INTO nclNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Huan sinda hualas inminteco pa chicnahui, diez, once, o lajco layúa o lajco yihuali o pa cualcan o cualquita o laxpoyahua huan yoje quinmitas quichixticate, cuaquin ¡quinami amo paquisi innojen lacames itequipanujquimes! ");
INSERT INTO nclNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Huan xicmatican inon. Sinda quimatiaya iteco se cali quiman yahuiaya huala in laxtequini, cuaquinon amo quimacahuiltiaya pa quixitinisquiaya icali pa quixtequilisquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Huan amhuanten ximochijchijtiacan pampa nehual ilacal in cielo jan niajsitiquisas, amo anquimatis quiman niajsis. ");
INSERT INTO nclNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Cuaquinon Pedro quilic: —Tata, ¿titechilijtica in laijnamiquiltilisli pa titechmaxtis tehuanten san o pa moxtin? ");
INSERT INTO nclNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Huan in Tata Jesús quilic: —Niquilijtica aqui yes hual nechtequipanuilía. Unca quinami inon: Sinda unca se hué hual quipía se tequipanujquil hual quimati, yoje in hué quimati yihual in tequipanujquil quimati quichía mochi quinami quinequi iteco. Pampín quilalis pa quinmiztías oc sequin itequipanujquimes. Cuaquinon yihual in tequipanujquil quinxiluilis in oc sequin tequipanujquimes len quilis iteco pa quinxiluilis. ");
INSERT INTO nclNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","¡Quinami amo paquis in tequipanujquil pa in tonali hual hualas iteco huan quitas itequipanujquil quichijtica yoje! ");
INSERT INTO nclNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Neli annimitzilía, quimacas lahueliltilisli niman hué pa quiztías mochi hual unca iyaxca iteco. ");
INSERT INTO nclNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ma yoje, cuajnesi in teco quilalía se itequipanujquil pa quinmiztias in oc sequin tequipanujquimes. Cuaquín cuajnesi in tequipanujquil quijtus laijtic yihual, quil: “Huejcahua pa hualas noteco”, huan pehuas lacuas mojmosta huan launis huan mojmosta lahuantinemis. ");
INSERT INTO nclNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Cuaquinon hualas iteco in tequipanujquil pan se tonali hual amo quichixtica, amo momati quiman. Huan latilanis iteco pa yes lamictili itequipanujquil. Yihual yes lacocoltili ca in lacocoltilisli hual panusi yehuanten hual amo laneltocalo. ");
INSERT INTO nclNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","In tequipanujquil hual quimati in hual iteco quinequi pa quichías huan ma yoje amo mochijchías pa quichías len quinequi, yojque yihual yes lahuitequili míac. ");
INSERT INTO nclNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Huan yihual in tequipanujquil hual amo quimati len quinequi iteco pa quichías, huan quichía in hual cahuilúa pa quimacasi lacocoltilisli, ma yoje, yihual amo míac yes lahuitequili. Aqui yes hual quipía míac hual iteco quimacac, yoje yihual iteco quichías pa quicuepilis míac. Huan aqui yes hual iteco quimacas míac pa quiztías, yoje yihual quipías pa quicuepilis míac. ");
INSERT INTO nclNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Nihualac pa nicualicasquiaya ilahueliltilisli Dios pan lalticpan, yes quinami niclasasquiaya tixuxli pan lalticpan. Huan ¡quichi nicnequi pa axan yesquiaya laꞌaniltili in lalticpan ca in tixuxli! ");
INSERT INTO nclNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ma yoje, monequi pa nipanus lacocoltilisli, in yahui ye quinami se lacuayatequilisli hual nechcocus. ¡Quichi nicnequi pa lamis mochías! ");
INSERT INTO nclNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Anquijtúa pampa nihualaya pa nicchihuilisquiaya pa cayalosquiaya ca mosehuilisli yehuanten pan lalticpan? No, annimitzilía, nihualaya pa yajmo cayalosquiaya ca se laijnamiquilisli yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ma annimitznextili len nicnequi niquijtúa: Axan huan pa quiman lamis in lalticpan hual axan anquiximati, cayasi macuili pin se cali hual amo cayasi ca se laijnamiquilisli. Yeyenten amo quixtocasi quinami laijnamiquilo omenten, huan omenten amo quixtocasi quinami laijnamiquilo yeyenten. ");
INSERT INTO nclNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Itajtzin amo mocahuas ca se laijnamiquilisli ca ixól, huan ixól amo mocahuas ca se laijnamiquilisli ca itajtzin. Inantzin amo mocahuas ca se laijnamiquilisli ca ixól sihual huan ixól sihual amo cayas ca se laijnamiquilisli ca inantzin. Inantzin amo cayas ca se laijnamiquilisli ca isihua ixól lacal huan isihua se lacal amo cayas ca se laijnamiquilisli ca inantzin ilahuical. ");
INSERT INTO nclNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Cuaquinon Jesús quinmilic yehuanten in míac lacalera: —Anquita se mextemil pani pin laiztijcal, jan ajnaxcan anquijtúa: “Yahui quiahui”, huan yoje panúa. ");
INSERT INTO nclNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Huan lanesi lapuhuitica, anquijtúa: “Yahui tona”, huan yoje panúa. ");
INSERT INTO nclNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Lacuajcuamananijmes hual anunca! Anmochía quinami lacames cuali huan amo anunca yoje. Anquimati len quinequilo quijtulo in lanextilisli hual anquinmita pan in lalticpan huan pin cielo. Huan amo anquimati len quinequilo anmitznextilo innojen hual panujticate axan capa amhuanten, innojen lachihualisli hual niquinchijtica. Yoje annimitznextilijtica pampa Dios nechtilanic. ");
INSERT INTO nclNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Leca amo anquimati inon ca anmolajmatilisli? ");
INSERT INTO nclNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","’Cuajnesi mitzmotexpahuilía se hual molalía mopan, huan yihual mitzhuica pan lajco. Cuaquín ximotolini pa ticayas jan sejpa ca yihual capa ayamo anajsis pan lajco. Sinda amo ticchías yoje, yihual mitzhuicas ilaixpan in laꞌajuani huan in laꞌajuani mitztemacas in policía huan in policía mijtzacuas pa calijtic. ");
INSERT INTO nclNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nimitzilía tehual, amo quiman tiquisas nepa sinda ayamo ticlaxlahuic mochi tomin tipichin hual titehuiquilía. ");
INSERT INTO nclNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Pa in tonalijmes hualajque yehuanten hual quimachiltijque Jesús quinami Pilato quinmictic sequin lacames pin lalticpan Galilea huan quinipanuc inminesli ca iesli inminhuendis hual yeje borregos. ");
INSERT INTO nclNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús quinnanquilic: —¿Anquijtutica innojen lacames pa Galilea catanijme niman laijlaculi huan moxtin in oc sequin galiletecos amo yoje laijlaculi? ¿Anquijtutica pampa inon panuje lacocoltilisli yoje pampa quichihuaje míac hual amo cuali? ");
INSERT INTO nclNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Annimitzilía pampa no. Huan sinda amo anquipalas anmoyolo pa anpehuas anlaijnamiquis quinami Dios quinequi, amhuanten anmoxtin quinami yehuanten anpolehuis huan yoje amo cayas quinami huil anmoquixtis pin polehuilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Huan nepa pin Jerusalén, innojen dieciocho (caxtulihuanye) lacames hual quinmictic in cali cuajtic Siloé in tonali hual huetzic inminpan, ¿anquijtutica pampa yehuanten cataloaya niman laijlaculi huan moxtin in oc sequin hual chantilo pa Jerusalén amo yoje laijlaculi? ");
INSERT INTO nclNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","No, annimitzilía, huan sinda amo anquipalas anmoyolo pa anpehuas anlaijnamiquis quinami Dios quinequi, anmoxtin amhuanten anpolehuis quinami yehuanten, huan amo cayas quinami huil anmoquixtis pin miquilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Cuaquinon quinmiliaya in laijnamiquiltilisli pa quinmaxtisquiaya, quinmilic: —Cataya se lacal quipiaya se amacuál tipichin hual ilaquilyo quicualo. Cataya latocali pa se cuajmili capa quintocac uvas. Hualac quintemujtataya laquilyo, huan amo quitac nindeno. ");
INSERT INTO nclNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Quilic itequipanujquil hual quiztataya in cuajmili latocali ca uvas, quil quilic: “Quita. Axcan quipía ye xixíl nihualaya nictemujtica laquilyo pan in amacuál tipichin huan amo niquitilía nindeno. Xictzontequi pa huetzis huan pa yajmo mocahuas nepa, neli amo unca cuali pa laquis. ¿Leca mocahua pin lali sinda amo laquis?” ");
INSERT INTO nclNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Huan yihual hual quiztíac quinanquilic: “Tata, xijcahua noje pa oc se xíl, amo xicmayahui huan niclalmolunis itenco huan niclalis cuilal capa niclalmolunis. ");
INSERT INTO nclNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Cuajnesi ca inon laquis. Huan sinda amo laquis, cuaquinon ticmayahuis pa huetzis, pa yajmo mocahuas nepa.” ");
INSERT INTO nclNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Cataya pan se tonali hual motequihuilo mosehuilo in judíos, huan Jesús lamaxtiaya pin se tiopan. ");
INSERT INTO nclNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nepa cataya se sihual, quipiaya se ijyecal amo cuali hual quiquixtiliaya ichicahualisli pa dieciocho xixíl. Yoje quipiaya pa nejnemisquiaya tepotzita, amo huil nadita momelahuaya. ");
INSERT INTO nclNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesús quitac, quinotzac pa hualasquiaya, quilic: —Nito, yahui mitzmacahua in ijyecal hual mitzquixtilía mochicahualisli. ");
INSERT INTO nclNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Huan quinlalic imajmajuan ipan. Jan ajnaxcan yec lamelahuali, huan pehuac quijtuc lajtomes huejué pa Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Huan ihué in tiopan cualanic pampa Jesús quipajtic pan in tonali hual mosehuilo in judíos. Pehuac quinmilic yehuanten hual nepa cataloaya pin tiopan, quinmiliaya: —Cate chicuase tonalijmes, pan innojen monequi pa tequipanus se. Pan in tonalijmes xihualacan huan xicayacan lapajtili, amo xihualacan pan in tonali hual timosehuilo. ");
INSERT INTO nclNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Huan in Tata Jesús quinanquilic: —Lacuajcuamananijmes amhuanten hual anquijtúa anunca niman cuajcuali. Mochi sejse ca amhuanten pan mochi tonalijmes hual anmosehuía quitoma ibuey o iburro capa ilpiticate huan quihuica pa cunis al. ");
INSERT INTO nclNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Huan in sihual unca se imiahuil Abraham. Satanás quipiaya quinami lailpili pa dieciocho xixíl. Quichihuilic ca in ijyecal hual quiquixtilic ichicahualisli. Huan ¿amo monequiaya pa yihual yesquiaya latomali pan se tonali quiman timosehuilo? ");
INSERT INTO nclNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Quinmilic Jesús in lajtomes, yoje inminlaixpan moxtin quinpinahualtic yehuanten hual yeje ilacocolinijmes yihual. Huan in oc sequin pehualoaya quipialo míac paquilisli pampa Jesús quichihuaya míac hual pampa inon mocahualoaya moiztataloaya yehuanten ca lamajtilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesús laqueztíac, quinmilic: —¿Quinami len annimitzmaxtis pa anquimatis quinami huelitía Dios? ¿Ca len lamaxtilisli annimitzilis? ");
INSERT INTO nclNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Unca quinami se latocli cuixtito hual canac se lacal huan quilasac pa icuajmili. Ixuac, moscaltic huan mochíac se cuahuil huan in tutomes pehualoaya chantilo nepa. ");
INSERT INTO nclNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Oc sejpa quilic: —¿Ca len lajtomes annimitznextilis quinami huelitía Dios? ");
INSERT INTO nclNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Unca quinami laxocoyajquil hual canac se sihual huan quiyamanic pa ye lamachihualonijmes itexli harina, cuaquín quiteposahualtic mochi itexli in harina. ");
INSERT INTO nclNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Huan panujtiahuiaya Jesús pa mochi in cajcaltilan huan in cajcaltilan tijtipichin. Lamaxtitinemiaya, huan mojmosta cantiyahuiaya iojli pa Jerusalén. ");
INSERT INTO nclNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Huan se lacal quilic Jesús: —Tata, ¿cate jan nadita lacames san hual yahuilo yelo laquixtili pin ipolehuilisli inminlaijlaculisli? ");
INSERT INTO nclNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Huan Jesús quinmilic: —Capa Dios huelitía unca quinami se cali hué hual quipía se lalapujquil san hual unca pitzahuac. Ximotolinican pa ancalaquis ca in lalapujquil pitzahuac, pampa annimitzilía cayasi míac hual quitemujticate quinami calaquisi capa Dios huelitía, huan amo quipiasi in lahueliltilisli pa calaquisi nepa. ");
INSERT INTO nclNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Quiman moquetzac iTeco in cali huan quitzacuac in lalapujquil, cuaquinon amhuanten hual anunca pa quiahuac anpehuas anquinotzas pa in lalapujquil, anquilis: “¡Tata, xitechlapuli!” Huan yihual anmitznanquilis: “Amo annimitziximati, ¿capa anquisac pa anhualasquiaya nican?” ");
INSERT INTO nclNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Cuaquinon anpehuas anquilis: “Tilacuanijme huan tilaunijme capa tehual ticatani. Huan tehual tilamaxtini pa toꞌojlimes huejué pa mochi innojen tocaltilan.” ");
INSERT INTO nclNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Huan in Teco anmitzilis: “Amo nicmati capa anquisac pa anhualasquiaya nican. Xiquisacan nican huejca ca capic amo niunca nehual, amhuanten anmoxtin hual anyuli anquichijtica in hual amo cuali.” ");
INSERT INTO nclNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nepa cayasi chocalisli huan anquinchoctis anmolames quiman anquinmitas Abraham huan Isaac huan Jacob huan moxtin ilajtunijmes Dios hual cayasi capa Dios huelitijtica, huan amhuanten ancayas laquixtili pa quiahuac. ");
INSERT INTO nclNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Quema, hualasi lacames hual quisaje capa quisa in tonali huan capa calaquía in tonali huan hual quisaje pin norte huan pin sur. Huan molalisi inahuac pa capa Dios huelitía. ");
INSERT INTO nclNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Huan xiquitacan. Cate yehuanten hual ma yoje amo cayasi capa Dios huelitía, pampa amo quinequije quineltocaje, mas que quimatije ilajtol Dios pin xixihuimes quiman ayamo quimatiloaya moxtin oc sequin. Huan cate yehuanten noje hual mas que ayamo quimatiloaya ilajtol Dios, ma yoje, pin tonali hual quimatije, cuaquín quineltocaje. Yehuanten cayasi capa huelitía Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Cuaquinon noje ajsitihualajque sequin fariseos capa cataya Jesús, quilijque: —Xiquisa, ximohuica ca yoje, pampa quinequi mitzmictía Herodes. ");
INSERT INTO nclNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesús quinmilic: —Ximohuicacan huan quiman anquita in se hual quimati lacuajcuamana quinami se zorra, xiquilican: “Xiquita. Axan huan mosta nican ninicaya niquinquixtilijtía ijyecames amo cuajcuali huan nilapajtitías. Huan pa in ye tonali niajsis capa niajtía.” ");
INSERT INTO nclNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ma yoje monequi pa nicanas ojli axan huan mosta huan huipla, pampa amo momacahuiltía pa miquis se ilajtuni Dios pa quiahuac Jerusalén. ");
INSERT INTO nclNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡Jerusalén, amhuanten pa Jerusalén, anquinmictía ilajtunijmes Dios, anquinlaxilía ca tixcalimes yehuanten hual Dios anmitztilanilía! Huan ¡quichi míac nicnequic annimitznechicuc pa annechneltocasquiaya! Nicnequic annimitznechicuc quinami se lapachuani quinnechicúa iparachitos itzindan inastacapajmes, huan amo anquinequic. ");
INSERT INTO nclNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Xiquitacan. Dios yajmo unca nepa pa anmitziztías anmolacames. Axan anmitzcahuac pa anmoiztías amhuanten anmohuían, jan yoje anquinequi. Huan annimitzilía inon, lacames pa Jerusalén: Yajmo annechitas. San annechitas oc sejpa pan tonali quiman anquijtus: “Ma lajtucan moxtin, ma lajtucan ca lajtomes huejué pa yihual hual huala pampa Dios quitilanic ca ilahueliltilisli.” ");
INSERT INTO nclNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Cataya pan se tonali hual calaquic Jesús pa icali se hué fariseo pa lacuasquiaya, cataya in tonali hual mosehuilo in judíos. Huan yehuanten amo mocahualoaya pa quinapachilosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Cataya nepa ilaixpan Jesús se lacal, quipiaya se cocolisli hual quiposahualtitataya. ");
INSERT INTO nclNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Huan Jesús quinmilic in fariseos huan ilamaxtinijmes inminlajtol in judíos, quinmilic: —¿Quimacahuiltía tolajtol pa titepajtisi pan tonali hual timosehuilo, o amo quimacahuiltía? ");
INSERT INTO nclNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Yehuanten amo nahuatije. Cuaquinon Jesús quiquitzquic in lacal huan quipajtic huan quilic pa mohuicasquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Cuaquinon quinmilic: —Amo unca se ca amhuanten hual amo quiquixtisquiaya jan ajnaxcan ixól o ibuey sinda huetzisquiaya laijtic se coyunquil pan tonali hual timosehuilo. ");
INSERT INTO nclNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Huan momajtiloaya pa quinanquililosquiaya Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Huan quitaya Jesús quinami yehuanten hual cataloaya lanotzali pa lacualosquiaya itequi molajtultilijque pa yehuanten in icpalimes pa capa molalilosquiaya in huejueyenten pa lacualosquiaya. Pampín quinmilic in laijnamiquiltilisli pa quinmaxtisquiaya, quinmilic: ");
INSERT INTO nclNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Sinda mitznotza se pa tihualas pa se monamictilisli, amo ximoyaxcajtili se icpali hual unca pa in huejueyenten. ");
INSERT INTO nclNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Cuajnesi yihual hual mitznotzac noje quinotzac se hual tehual amo tiunca yoje hué quinami yihual. Cuaquín quihualicas huan mitzilis: “Xicmacahuilti pa molalis in lacal capa timolalijtica.” Cuaquinon tipehuas tipinahuas huan tías timolalis pan se icpali hual cayas pa yehuanten hual cate tijtipichin. ");
INSERT INTO nclNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","No, xicchía inon sinda tiunca lanotzali: Quiman tiajsis nepa, ximolali pan se icpali hual cayas pa yehuanten hual tijtipichinchito. Yoje, quiman hualas yihual hual mitznotzac pa in monamictilisli cuajnesi mitzilis: “Nito, ximolali pa in icpali hual unca pa se hué.” Cuaquinon, ticanas lasojlalisli inminlaixpan moxtin hual cayasi ca tehual pa lacuasi. ");
INSERT INTO nclNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Mochi sejse hual mochías hué inminlaixpan oc sequin, yihual quichihuasi tipichinchito. Huan aqui yes hual mochías tipichinchito, yihual quichihuasi hué. ");
INSERT INTO nclNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Noje Jesús quiliaya yihual hual quinotzac, quilic: —Sinda tía ticchía se fiesta hué capa tilalacualtía, amo xiquinnoztinemi itequi jan mocnían hual chantilo pa oc sequin calimes huan mocnían huan mochantinijmes san hual quipialo míac tomin. Sinda ticchijtías yoje, cuaquinon yehuanten mitznotzasi tehual huan yoje mitzcuepilisi in lachihualisli cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","No, sinda tiquinnotzas lacames pa lacuasi pa mochan, xiquinmana yehuanten hual amo quipialo nindeno huan hual tungo huan hual amo huil nejnentialo huan hual pachacal. ");
INSERT INTO nclNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Yoje tipactías pampa yehuanten amo quipialo quinami mitzcuepilisi in lachihualisli cuali. Ma yoje, Dios mitzcuepilis niman míac lachihualisli cuali pan in tonali tiyulis oc sejpa. In panus pan in tonali hual yulisi oc sejpa yehuanten hual iyaxca Dios hual ca yehuanten yihual amo quita nindeno amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Quicaquic in lajtomes se ca yehuanten hual cataloaya lacuajtataya ca yihual, quilic: —Míac paquilisli cayas pa yihual hual quicuas ilacualisli capa Dios huelitía. ");
INSERT INTO nclNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesús quilic: —Cataya se lacal yahuiaya quiyucxilti se lacualisli hué. Latilanic pa hualalosquiaya míac. ");
INSERT INTO nclNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","In tonali hual mochi cataya layucxiltili, quitilanic itequipanujquil pa quinnahuatisquiaya yehuanten hual quinnotzac, quinmilic: “Xihualacan pampa axcan unca layucxiltili.” ");
INSERT INTO nclNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Cuaquín ca se laijnamiquilisli moxtin pehuaje quilije pampa amo yahuiloaya yalo. In se hual in tequipanujquil pehuac quinotzac pa hualas quilic: “Nilamic nimocuhuilic se cuajmili huan nicpía pa nías niquitas. Nimitzilía xichpujpuhua, amo huil nía.” ");
INSERT INTO nclNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Oc se quil quilic: “Nilamic nimocuhuilic macuili omenten bueyes huan niajtía pa niquinlaxahualtis pa nicmatis sinda cate cuali. Nimitzilía xichpujpuhua, amo huil nía.” ");
INSERT INTO nclNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Huan oc se quilic: “Nilamic nimonamictic, pampín amo huil nía.” ");
INSERT INTO nclNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Yoje mocuepac in tequipanujquil, quilamachiltic iteco innojen lajtomes. Cuaquinon cualanic yihual hual quinnotzac pa hualalosquiaya, quilic itequipanujquil: “Xiejsehui xiquisa pa in ojlimes huejué pin caltilan huan in ojlimes tipichitos, huan xiquinmana xiquinhualica ca níc hual amo quipialo huan in tungos huan in pachacames huan yehuanten hual amo huil nejnemilo cuali.” ");
INSERT INTO nclNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Huan itequipanujquil quichíac hual quilic iteco. Cuaquín mocuepac quilic: “Tata, nilamic nicchíac len tichilic huan jan yoje unca capa huil cayasi míac lacames.” ");
INSERT INTO nclNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Huan in Tata quilic itequipanujquil: “Xiquisa pa quiahuac in caltilan, xiquintemu yehuanten hual nejnentinemilo pan ojlimes, huan yehuanten hual mocahualo pin cuajlan pampa amo quipialo inminchan. Xiquinmana pa hualasi pa nochan pa yoje temis ca lacames nocali. ");
INSERT INTO nclNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nimitzilía, amo jan se ca yehuanten in lacames hual niquinnotzac pa hualalosquiaya yahui quicua nolacualisli.” ");
INSERT INTO nclNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ca Jesús yajtiahuiloaya míac míac lacames. Cuaquín momalinac Jesús, quinmilic: ");
INSERT INTO nclNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Sinda se quinequi ye nomonextilini, quipías pa nechlasojlas niman míac, amo yoje quinami quinlasojla oc sequin. Quema, quipías pa nechlasojlas míac huan yoje nesis quinami yihual amo quinlasojla itajtzin huan inantzin huan isihua huan ixolomes huan icnían lacames huan sihuames. Quema, quipías pa nechlasojlas yoje míac, huan yoje nesis quinami yihual ihuían amo moixtoca. Sinda amo yoje, cuaquín amo huil yes nomonextilini. ");
INSERT INTO nclNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Monequi pa nehual nimiquis. Yoje, aqui yes hual amo quinequi nechtoca huan amo quinequi miqui pa nehual, sinda cuajnesi monequi pa miquis pa nehual, cuaquín yihual amo huil ye nomonextilini. ");
INSERT INTO nclNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Amo xipehuacan xiyén nomonextilinijmes sinda ayamo anquijnamiquic cuali in míac hual nía nicnequi pa anquichías pa nehual. Mochi sejse ca amhuanten hual yahui quichía se cali hué, quipehualtía molalijtica pa ajsis quimatis quichi quijtúa pampa yahui quipía pa quilaxlahuis. Yoje quitas da cajsis itomin pa laxlahuis in cali hual yahui quichía. ");
INSERT INTO nclNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Sinda amo ajsi quimati se yoje, cuajnesi in tonali pehua quichía in cali hué, quita pampa itomin amo cajsis pa laxlahuis, amo huil lamis quichías. Cuaquinon moxtin hual quitalo pehuasi quihuitzquilisi in lacal. ");
INSERT INTO nclNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Quilisi: “In lacal pehuac quichíac huan axan amo huil lamis quichías.” ");
INSERT INTO nclNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Huan sinda se hué quinequi quichía moanalisli ca oc se hué, quipehualtía molalijtica pa ajsis quimatis sinda huil quisulahua in hué ca diez mil guaches hual quinpía, sinda in oc se hué quinpía veinte mil guaches hual hualalo pa quinamiquisi pa moanasi. ");
INSERT INTO nclNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Huan sinda quijtúa pampa amo huil quisulahua, cuaquín quiman ayamo ajsiaya huan unca huéjca in hué ca veinte mil guaches, in hué ca san diez mil guaches quinahuatía in oc se hué pampa amo quinequi moana ca yihual. ");
INSERT INTO nclNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yoje, amaqui huil ye nomonextilini sinda amo nechmacahuiltía pa nicchías ca yihual len yes hual nicnequis nicchías ca yihual, quema, huan ca mochi hual unca iyaxca. ");
INSERT INTO nclNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Unca cuali in istal. Ma yoje, sinda in istal yajmo latechcunía quinami istal, cuaquín amaqui yahui quilalilía pan len yes quiyucxiltitica pa quicuas. ");
INSERT INTO nclNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","No, in istal hual yajmo latechcunía quinami istal yajmo unca cuali pa nindeno, yajmo unca cuali pa in lali huan pa in cuilal hual quimontulo. Jan quilasalo pa quiahuac san. Huan sinda se nomonextilini yajmo yuli quinami nehual, cuaquín noje yajmo unca cuali pa nehual. Ma lacaqui yihual hual quipía inacas pa lacaquis. ");
INSERT INTO nclNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Huan ajsitihualaloaya moxtin in laꞌananijmes hual quipixcaloaya tomin pa in romanos hual huelitiloaya. Noje ajsiloaya yehuanten hual yuliloaya amo cuali, hualaloaya pa quicaquilosquiaya Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pampa inon quimotexpahuililoaya in fariseos huan ilamaxtinijmes inminlajtol hual quineltocalo in judíos, quilije: —In se quinnamiquía quinami icnían in lacames hual amo yulilo cuali, quema, lacualo huan yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Cuaquinon Jesús quinmilic in laijnamiquiltilisli pa quinmaxtisquiaya, quinmilic: ");
INSERT INTO nclNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Sinda se lacal ca amhuanten quinpía cien borregos capa amaqui chanti, huan se iborrego mopolúa, cuaquín ¿amo quincahuas in noventa y nueve (nahuipuhualicaxtulihuanahui) borregos capa cataloaya huan yas latemus pa quitas in se hual mopoluc? Quema, yoje quichías. ");
INSERT INTO nclNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Huan quiman quitas in borrego, quilalis ca paquilisli pa ihuajcol. ");
INSERT INTO nclNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Huan quiman ajsis quimantica pa ichan, quinnotzas pa monechicusi yehuanten hual icnían pa oc sequin calimes huan yehuanten hual chantilo itenco, quinmilis: “Xicpiacan paquilisli ca nehual, pampa axan niquitac in borrego hual mopoluc.” ");
INSERT INTO nclNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Annimitzilía pampa cayasi niman míac paquilisli pin cielo quiman se lacal o se sihual hual amo yuli cuali quipalas iyolo pa pehuas laijnamiquis quinami Dios quinequi. Quema, cayas míac paquilisli pin cielo inahuac in se, amo cayas yoje míac paquilisli inminahuac noventainueve hual amo monequi pa quipalasi inminyolo pa pehuasi laijnamiquisi quinami Dios quinequi. ");
INSERT INTO nclNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’O, sinda se sihual quinpía diez tomimes, mochi sejse ipati míac, huan sinda quipolúa se ca innojen tomimes, cuaquinon ¿amo quilalaltía se tapalcal pa lahuilisli huan quixpana in cali, huan ca melahualisli quitemúa pa quitas in tomin? ");
INSERT INTO nclNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Quema, yoje quichía. Huan quiman quita in tomin, quinnotza pa monechicusi icnían sihuames pa oc sequin calimes huan yehuanten hual chantilo itenco, quinmilía: “Xicpiacan paquilisli ca nehual, pampa axan niquitac in tomin hual nicpolujtataya.” ");
INSERT INTO nclNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yoje annimitzilía, unca paquilisli ca Dios ilanahuatinijmes pin cielo sinda se hual unca laijlaculi quipala iyolo pa pehuas laijnamiquis quinami Dios quinequi. ");
INSERT INTO nclNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Huan quinmilic: —Cataya se lacal quinpiaya ome ixolomes lacames. ");
INSERT INTO nclNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Huan in xól xocuyol quilic itajtzin: “Tata, xijxiluili axan ilajco motomin hual cayas pa nehual.” Cuaquinon itajtzin quinxiluilic itomin ca in omenten ixolomes. ");
INSERT INTO nclNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Huan amo panuje míac tonalijmes, huan ixól xocuyol monechiculic mochi itomin hual quixiluilic itajtzin, cuaquinon quisac pa quiahuac ilali. Uyac pa se lali huejca, huan nepa quilantinemiaya mochi itomin. Amo cajcoquiaya tomin nindeno, yultataya yoje amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Quiman quilamic mochi hual quipiaya, hualac se mayandi chicahuac pin lali capa cataya, huan yihual pehuac panuc mayanalisli. ");
INSERT INTO nclNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Uyac, quiyantic se lacal pin lali pa quimacasquiaya tequipanulisli. Yihual in lacal quitilanic pa icuajmili pa quilachilisquiaya icoyamimes (icuchis). ");
INSERT INTO nclNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Huan quinequiaya pachihui ca len quicuajtataloaya in coyamimes. Ma yoje, amaqui quimacaya nindeno pa quicuasquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Pampín, quijnamiquic in amo cuali hual quichíac, quipalac iyolo pa laijnamiquisquiaya cuali, moilic: “Quichi tequipanujquimes quinpía notajtzin huan yehuanten quipialo míac pa quicuasi, amo quicualo mochi. Huan nehual nican niunca huan nimiqui pampa nimayantinemi. ");
INSERT INTO nclNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nimochijchías axan huan nías ca notajtzin huan niquilis: Tata, nicchíac len unca amo cuali ilaixpan Dios huan molaixpan tehual. ");
INSERT INTO nclNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Yajmo nimonotza pa niquijtus pampa niunca moxól. Xijchihuili axan pa nicayas se ca motequipanujquimes.” ");
INSERT INTO nclNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Yoje in xól mochijchíac, uyac ca itajtzin. ’Huan ayamo ajsic, quema, cataya huejca huan itajtzin pa ichan quitac ajsitihualac. Huan ca paquilisli niman hué molalujtíac ca ixól, quinapaluc quitenamictataya. ");
INSERT INTO nclNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Pehuac in xól quilic: “Tata, nicchíac len amo cuali ilaixpan Dios huan molaixpan tehual. Yoje amo nimonotza pa niquijtus pampa niunca moxól.” ");
INSERT INTO nclNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ma yoje, itajtzin quinmilic itequipanujquimes: “Xiejsehuican xijquixtican se nahuas niman cualtichin huan xiclaquentican noxól, xicualicacan se anillo pa ixerixa huan lacsames pa icxihuajmes. ");
INSERT INTO nclNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Huan xicualicacan in becerro tomahuac hual ticajcoctataloaya pa se fiesta. ¡Xicmictican, ma tilacuacan, ma tipaquican! ");
INSERT INTO nclNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Pampa in noxól cataya quinami miquic huan yulic oc sejpa, cataya lapoluli huan axan tiquitaje.” Huan pehualoaya mijtotilo ca paquilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’In xól hué cataya pin cuajmili. Huan ajsic pa in cali, quincaquic latzotzontataloaya huan mijtotijtataloaya. ");
INSERT INTO nclNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Quinotzac pa hualasquiaya se ca in tequipanujquimes tipichinchitos, quilajlanic len panujtataya calijtic. ");
INSERT INTO nclNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Huan in tequipanujquil quilic: “Axan hualac mocni huan latilanic motajtzin pa quimictisi in becerro tomahuac hual ticajcoctataloaya pa fiesta, pampa mocni hualac. Yajmo unca quinami miquiaya, axan yultica.” ");
INSERT INTO nclNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Quicaquic inon, cualanic icni hué, amo quinequic calaquic. Huan quisac itajtzin, quiyantic ca lasojlalisli pa calaquisquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ma yoje, yihual quinanquilic itajtzin: “Xiquita. Quichi xixíl nimitztequipanuilía huan amo quiman nimocahuac pa nimitzneltocas. Huan amo quiman tichmacac se chivito calica ticchihualosquiaya se fiesta nehual huan yehuanten hual niquinlasojla. ");
INSERT INTO nclNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Huan in tonali in se moxól hualac, in se hual quilamic motomin ca sihuames amo cuajcuali. Huan ¡ticmictilic yihual in becerro tomahuac!” ");
INSERT INTO nclNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Itajtzin quilic: “Noxól, mojmosta tehual tiunca ca nehual huan mochi hual nicpía unca moyaxca. ");
INSERT INTO nclNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Huan amo cataya yoje ca mocni. Pampín, monequiaya pa ticpialosquiaya in fiesta huan pa ticpialosquiaya niman míac paquilisli. Unca pampa in mocni tehual cataya quinami miquic huan yulic oc sejpa. Quema, unca pampa cataya lapoluli huan axan tiquitaje.” ");
INSERT INTO nclNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Cuaquinon Jesús quinlaquetzilic noje imonextilinijmes, quinmilic: —Cataya se lacal quipiaya niman míac calica yuliaya huan quipiaya se laicanani. Huan sequin quilije in lacal quinami ilaicanani quilantinemiaya len iyaxca in lacal. ");
INSERT INTO nclNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Pampín in lacal latilanic pa hualasquiaya ca yihual in laicanani huan quilic: “¿Leca nechililo pampa tehual itequi tichlaixtequilijtica? Axan, xilami xiquijcuilu mochi hual nechuiquilijticate moxtin, pampa yajmo tiyes laicanani.” ");
INSERT INTO nclNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Cuaquín moilic in laicanani: “Axcan, ¿len nía nicchía pampa yajmo niyes ilaicanani noteco? Amo nicpía chicahualisli pa nitequipanus quinami se hual quimati cuajmilúa, huan nipinahuas pa niquinlajlanilis tomin oc sequin. ");
INSERT INTO nclNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¡Ah! Axan nicmati len nicchías”, quil quilic, “pa nechajxiltisi oc sequin pa inminchan in tonali hual yajmo niyes laicanani.” ");
INSERT INTO nclNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Cuaquinon quinnahuatic pa hualalosquiaya ca yihual moxtin yehuanten hual quihuiquilijtataloaya len in lacal iteco. Ajsije sejse huan sejse huan in laicanani quipehualtic ilajlanilisli ca se hual hualac, quilajlanic: “¿Quichi tiquihuiquilía noteco?” Quinanquilic: “Tres cientos sesenta lamachihualoni ichahuac olivos”, quilic. ");
INSERT INTO nclNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Quilic in laicanani: “Xiquixtili moamal, xicana oc se amal, ximolali huan xiejsehui xiquijcuilu pampa tiquihuiquilía ciento ochenta san”, quilic. ");
INSERT INTO nclNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Cuaquinon in laicanani quilajlanic oc se, quil quilic: “Huan tehual, ¿quichi titehuiquilijtica?”, quilic. Huan quinanquilic: “Cien hanegas trigo”, quil quilic. In laicanani quilic: “Xicana in oc se amal huan xiquijcuilu ochenta.” ");
INSERT INTO nclNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Quimatic iteco in hual quichíac ilaicanani, huan yihual lajtuc ca lajtomes huejué pa in laicanani, mas que quicajcayahuilic in lacal itomin. Lajtuc hué pa yihual pampa in laicanani lanextilic quinami quimatiaya quinami molachilisquiaya mas que quichíac ca lacajcayahualisli. Yajmo yahuiaya ye ilaicanani in lacal iteco. Ma yoje, yehuanten hual quihuiquililoaya iteco axan yahuiloaya quimacalo iyulilisli in laicanani. Yoje —quilic Jesús—, lacames pin lalticpan hual amo quineltocalo Dios, yehuanten quimatilo lachihualo ca oc sequin lacames hual amo quineltocalo Dios. Quema, lachihualo ca míac lajmatilisli, amo yoje míac lajmatilisli quipialo yehuanten hual quineltocalo Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Huan annimitzilía inon: Mas que lacames laijlaculi pin mochi in lalticpan lacuhualo huan lanamacalo ca míac tomin pa quichihuasi in hual amo unca cuali, ma yoje, amhuanten xilachihuacan ca in tomin pa anmochías lajlasojli ca lacames pa yoje pan tonali quiman lamis in tomin, cuaquín ancayas laꞌajxiltili pin calimes hual amo quiman lamisi. ");
INSERT INTO nclNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Noje Jesús quinmilic: —Aqui yes hual quilachilía cuali len tipichin hual quililo pa quilachilis, yoje quilachilis cuali len hué hual quililo pa quilachilis. Huan aqui yes hual amo quilachilía cuali len tipichin hual quililo pa quilachilis, yoje yíal amo quilachilis cuali len hué hual quililo pa quilachilis. ");
INSERT INTO nclNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yoje cayas sinda amo anquilachilía cuali innojen hual monotzalo pin lalticpan hual Dios anmitzilía pa anquinlachilis. Dios amo anmitzilis pa anquinlachilis innojen hual yihual iyaxca. Innojen amo quiman lamisi huan monotzalo niman míac hual amo yoje monotzalo innojen pin lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Huan sinda amo anquilachilía cuali in hual unca iyaxca oc se, nicnequi niquijtúa, in hual iyaxca Dios, cuaquinon Dios amo anmitzmacas len iyaxca pa yes anmoyaxca pa anquilachilis. ");
INSERT INTO nclNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Amaqui huil quintequipanuilía ome itecojuan, pampa amo quixtocas in se huan quixtocas in oc se, o quineltocas in se huan amo quineltocas in oc se. Huan noje amo huil anquitequipanuilía Dios sinda itequi antequipanúa san pa anquinmanas innojen hual iyaxca in lalticpan hual anquijtúa monotzalo. ");
INSERT INTO nclNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Quincaquiloaya mochi innojen lajtomes in fariseos, huan yehuanten quilasojlaloaya tomin míac. Pampín quilaxocuyililoaya Jesús pa quixijxiculosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Pampín Jesús quinmilic: —Amhuanten amo anmocahua pa anmonextilis inminlaixpan moxtin pampa anunca lacames niman cuajcuali. Ma yoje, Dios quimati len anquijtúa pa anmoyolo. Cate innojen, quema, hual lacames quijtulo pampa monotzalo míac, huan Dios amo quijtúa monotzalo míac. Innojen quicualantilo Dios, niman amo quinmixtoca. ");
INSERT INTO nclNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Dios quimacac Moisés ilajtol huan Moisés quijcuiluc. Huan Dios quinmilic ilajtunijmes ilajtol huan yehuanten quijcuiluje. Huan mochi hual quijcuiluje Moisés huan ilajtunijmes Dios, inon anmitzmaxtic mochi hual Dios quinequiaya pa anquimatisquiaya quinami yihual unca. Cuaquinon hualac Juan Lacuayatequini, huan Dios pehuac quimaxtic lajtol yancuic. Axan moxtin quicacticate ilamachiltilisli cuali Dios huan quinami huelitía. Huan motolinilo ca chicahualisli pa quipiasi Dios huelitijtica pa inminyolo. Ma yoje, amo quinequilo quipialo quinami Dios quilalic pa quipialosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Monequiaya pa cayasquiaya len ca míac chicahualisli pa quinlamis in cielo huan in lalticpan. Ma yoje, ca in míac chicahualisli, amo quiman huil quitzacuiliaya pa camo mochías jan se lajtol niman tipichin hual quijtúa Dios ilajtol. ");
INSERT INTO nclNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Se lacal hual yajmo quinequi isihua huan quicajcahua, huan cuaquinon monamictía ca oc se sihual yoje cantica se sihual hual amo iyaxca. Huan jan yoje se lacal cana se sihual hual amo iyaxca sinda monamictía ca se sihual lacajcahuali hual ilahuical yajmo quinequiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Cataya, quil, se lacal hual quipiani niman míac. Molaquentini ca tzotzomajli cualtichin huan mojmosta quichihuani fiesta, quilamini míac tomin mojmosta. ");
INSERT INTO nclNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Huan cataya se hual amo quipiani nindeno, yihual itocani Lázaro, lastataya cocoxqui pa ilalapujquil icali in lacal hual quipiani míac. Huan in Lázaro quipiaya sahualera pa mochi icuerpo. ");
INSERT INTO nclNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Huan mojmosta quinequiaya míac pa pachihuisquiaya ca in lacualisli hual quimayahuiloaya itzindan capa lacuani in lacal hual quipiani míac. Ma yoje hualaloaya in pelojmes huan quipaluililoaya isahuames Lázaro. ");
INSERT INTO nclNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Cuaquinon se tonali polehuic in lacal Lázaro huan Dios ilanahuatinijmes pin cielo quihuicaje pin cielo (ilhuicac) capa unca Abraham, yihual hual quinpehualtic yehuanten in judíos. Huan polehuic in lacal hual quipiani míac huan quilalpachuje. ");
INSERT INTO nclNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Huan cuaquín moitac capa yalo yehuanten hual miquilo amo quineltocaticate Dios, huan nepa panuaya míac lacocoltilisli. Cuaquín lachíac huan quitac huejca Abrahám, huan yihual cataloaya Lázaro. ");
INSERT INTO nclNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Huan in lacal hual quipiani míac quitzajtzilic, quilic: “Tata Abrahám, xichicnili, huan xictilani Lázaro pa quipaltilis pa al ilamili ixerixa pa nechiztialtilis nonejnepil, pampa nipanujtica míac lacocoltilisli pa in milinilisli.” ");
INSERT INTO nclNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Huan Abraham quilic: “Nito, xiquijnamiqui quinami tiquinpiani len niman cuajcuali nepa capa tiyulini pin lalticpan, huan Lázaro quipiani len amo cuali. Huan axan nican yihual quipía len cuali pin cielo huan tehual tipanujtica lacocoltilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Huan ca mochi inon, unca se huejcalan niman palahuac lajco capa tehuanten huan amhuanten. Pampín yehuanten nican hual cuajnesi quinequiloaya panulo pa amhuanten amo huil. Noje nepa amo huil panulo pa tehuanten nican.” ");
INSERT INTO nclNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Cuaquín in lacal hual quipiani míac quilic: “Nimitztemachía cuaquín, Tata Abraham, xictilani Lázaro pa quinnahuatis yehuanten pa ichan notajtzin, ");
INSERT INTO nclNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","pampa niquinpía macuili nocnían. Ma quinnahuati pa yehuanten noje amo hualasi ca niquic capa panusi in lacocoltilisli.” ");
INSERT INTO nclNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham quilic: “Yehuanten quipialo ilajtol Dios hual Moisés quijcuiluc, huan quipialo in hual quijcuiluje Dios ilajtunijmes. Ma momaxtican len unca lajcuiluli huan ma quineltocacan.” ");
INSERT INTO nclNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Huan in lacal hual quipiani míac tomin quilic: “Nocnían amo quineltocasi Moisés huan Dios ilajtunijmes, Tata Abrahám. Ma yoje, sinda yahuiaya pa nocnían se hual miquic, cuaquinon, quema, quipalalosquiaya inminyolo pa pehualosquiaya laijnamiquilo quinami Dios quinequi.” ");
INSERT INTO nclNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham quilic: “Sinda mocnían amo quineltocalo in hual quijcuiluje Moisés huan Dios ilajtunijmes, cuaquinon amo huil quinlaneltocaltía se hual miquic huan yulic oc sejpa, mas que mocuepac capa yehuanten pa quinmilisquiaya.” ");
INSERT INTO nclNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Cuaquinon quinmilic Jesús imonextilinijmes: —Amo mocahuas pa cayasi lacames hual quichihuasi len pa quitilanilis inminyolo oc sequin lacames pa yehuanten quichihuasi laijlaculisli. Pampín, ¡quichi yahui panúa lacocoltilisli in se hual quichías len quinami inon! ");
INSERT INTO nclNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yesquiaya cuali pa quipililosquiaya se melapili etic pa iquixlan in se huan quilasalosquiaya pa in al huejcalan. Jo quema, cuali in quipanusquiaya, amo san gá yihual cuajnesi quitilanilis iyolo pa quichías laijlaculisli se ca yehuanten hual amo quipialo míac tonalijmes pehuaje nechneltocaje, yehuanten hual nechneltocalo quinami xolomes. ");
INSERT INTO nclNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ximolachilican pa camo panus inon. Sinda mocni quichía se laijlaculisli, cuaquín xicajua. Sinda quipala iyolo pa pehuas laijnamiquis quinami Dios quinequi, xicpujpuhua huan yajmo xiquijnamiqui len quichíac. ");
INSERT INTO nclNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Huan cuajnesi mijchihuilis laijlaculisli tehual ca chicome lachihualisli pa se tonali huan pa in tonali hualas ca tehual quiman mijchihuilic sejse ca in chicome lachihualisli, huan mitzilis ca mochi iyolo: “Nechcocúa noyolo pampa nimijchihuíc in huan axcan yajmo quiman nimijchihuís.” Cuaquín sinda yoje mitzís, xicpujpuhua huan amo xiquijnamictía in laijlaculisli hual mijchihuíc. ");
INSERT INTO nclNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ilanahuatinijmes quilije in Tata Jesús, quilije: —Xitechmaca míac lahueliltilisli pa tilaneltocasi niman cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","In Tata Jesús quinmilic: —Se ilatocli mostaza ixua huan moscaltía huan mochías se cuahuil. Sinda anquipía laneltocalisli hual moscaltía quinami se ilatocli mostaza, cuaquín huil anquilisquiaya in xocol cuahuil nican, quil: “Ximocapuna huan ximoatoca lajco pin al huejcalan.” Cuaquín anmitzneltocasquiaya, quichiasquiaya jan quinami tiquilic. ");
INSERT INTO nclNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Huan sinda se ca amhuanten ticpiasquiaya se latequipanujquil laxajtica o je lacal quinlachilijtica borregos, huan quisas pin cuajmili pa hualas pa in cali, amo tiquilis: “Xihuala ximolali pa tilacuas.” ");
INSERT INTO nclNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","No, tiquilisquiaya: “Xiclali pan tixuxli pa yucsis pa tichmacas pa nilacuas, ximochijchía pa tichtequipanuilis. Quiman nilamis nilacuas huan nilaunis, cuaquín huil tilacuas huan tilaunis tehual.” ");
INSERT INTO nclNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Cuaquinon, ¿ticsehuisquiaya in tequipanujquil pampa quichíac len tiquilic? No, amo ticsehuisquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Yoje amhuanten, quiman yes anquichíac mochi in hual Dios anmitzilic, cuaquín xiquijtucan: “Tehuanten titequipanujquimes hual amo timonotzalo, jan ticchihuaje inon hual ticpiaje pa ticchihuasi.” ");
INSERT INTO nclNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Huan cataya in Tata Jesús yajtiahuiaya pa Jerusalén, panujtiahuiaya lajco pa in ome lalimes Samaria huan Galilea pa inmintenco. ");
INSERT INTO nclNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Huan nican ajsitihualaya pa se caltilan tipichin capa quinnamiquic majlacli (diez) lacames quipialoaya in cocolisli itoca lepra. Yehuanten mocahuajque huejquita capa yihual cataya huan quinotzajque chicahuac, quilijque: ");
INSERT INTO nclNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","—¡Jesús, Lamaxtini, xitechicnili! ");
INSERT INTO nclNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesús quinmitac huan quinmilic: —Ximohuicacan huan ximonextican ca in tiopistas. Huan cuaquinon quinpanuc quiman mohuicatiyahuiloaya, yehuanten pajtijque. ");
INSERT INTO nclNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Se ca yehuanten quiztataya pampa pajtic, mocuepac quinmijtutica lajtomes huejué huan cuajcuali pa Dios ca lajtol chicahuac. ");
INSERT INTO nclNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Hualac huan huetzic pa icxihuajmes Jesús huan quisehuic. In se yec lacal samariteco huan in judíos amo quinmixtocalo in samaritecos. ");
INSERT INTO nclNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yehuanten hual cataloaya ca Jesús quicaquijque Jesús quijtuc: —¿Amo cataloaya diez lacames hual niquinpajtic? Huan in chicnahui lacames, ¿capa cate? ");
INSERT INTO nclNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Unca jan in se san hual mocuepasquiaya pa quinmijtusquiaya lajtomes huejué huan cuajcuali pa Dios, in se lacal hual amo lacatic pa tolali tehuanten? ");
INSERT INTO nclNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Cuaquinon Jesús quilic in lacal samariteco: —Ximoquetza huan ximohuica. Tichneltocac, pampín tipajtic, tiunca laquixtili pin amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Quilajlanijque Jesús in fariseos, quilijque: —¿Quiman ajsis in tonali hual huelitía Dios pan lalticpan? Quinnanquilic Jesús: —Mas que quitas se mochi in lanextilisli hual nesisi nican pin lalticpan, ma yoje amo huil quimatis calía cayas ilanextilisli calica quimatis quinami ajsis inon quiman Dios huelitía pan lalticpan. Amo ajsis ca len lanextilisli hual quita se. ");
INSERT INTO nclNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Amo yalo quijtulo: “¡Quita, nican unca!”, o “¡Quita, nepa unca!” No, amo yalo quijtulo yoje. Xiquitacan. Inon quinami Dios huelitía axan unca capa amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Cuaquinon Jesús quinmilic imonextilinijmes, quilic: —Ajsisi tonalijmes huan anquinectías pa ajsis jan ajnaxcan jan se tonali ca in tonalijmes capa nehual ilacal in cielo nihuelitis pan lalticpan. Anquinectías inon quiman ayamo nicpías pa nipehuas nihuelitis. Huan mas que anquinectías, ayamo ajsis. ");
INSERT INTO nclNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Anmitzilisi: “¡Quita, unca nepa! ¡Quita, unca nican!”, quil quilisi. Amo xijcahuacan anmotequipanulisli pa anquintocas in lacames, yehuanten islacatilo. ");
INSERT INTO nclNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Quinami in lapelanilisli lapelanía pa se ilajco pa in oc se ilajco in cielo, yoje yes in tonali hual nihualas nehual ilacal in cielo. Moxtin quimatis quiman inon panúa. ");
INSERT INTO nclNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ma yoje, amo ajsis in tonali quiman ayamo nipanuc in lacocoltilisli hual monequi pa nipanus huan pa nechilisi: “Amo ticnequilo pa ticayas nican.” Yoje nechilisi yehuanten hual yulticate axan. ");
INSERT INTO nclNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Huan jan quinami catani innojen tonalijmes hual yulini Noé pan lalticpan, yoje cayas pa innojen tonalijmes quiman nehual ilacal in cielo nimocuepas pan lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nepa capa yulini Noé, lacames jan lacuanijme, launijme, monamictinijme huan quinmacanijme inminxolomes pa monamictilosquiaya. Jan quijnamiquinijme innojen san. Yoje lachihuanijme, huan cuaquín ajsic in tonali hual calaquic Noé calijtic in arca. Cuaquinon hualac mochi in al huan quinmatoctic moxtin in oc sequin. ");
INSERT INTO nclNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Jan yoje catani quinami inon pa innojen tonalijmes hual yulini in lacal itocaya Lot. Moxtin lacuanijme, launijme, lacuhuanijme, lanamacanijme, latocanijme, quinchihuanijme calimes. ");
INSERT INTO nclNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Huan in tonali hual quisac Lot pa quiahuac in caltilan Sodoma, huetzije tixuxli huan azufre, quisac pin cielo, huan moxtin in oc sequin polehuije. ");
INSERT INTO nclNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Quinami cataya ca yehuanten, yoje cayas pan in tonali nehual ilacal in cielo nimonextis ca moxtin in lacames pin lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Pan in tonali, ma camo quijnamiqui amaqui len iyaxca hual quipías, ma camo laijnamiqui quinami yahui quinquixtía pa camo xitinis in hual quipía. Sinda unca pa quiahuac icali, ma camo calaqui. Huan noje sinda unca pin cuajmili, ma camo momalina pa canas len cayas pa itepotzcon. ");
INSERT INTO nclNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Xiquijnamiquican len quipanuc isihua Lot. ");
INSERT INTO nclNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Aqui yes hual jan quitemus san quinami huil quipías mochi hual quinequis pa iyulilisli nican pan lalticpan, yoje yihual quipolus iyulilisli. Dios quitilanis pa polehuilisli hual amo quiman lamis. Huan aqui yes hual amo quitemujtías jan quinami quipías mochi in hual quinequis pa iyulilisli, yoje yihual quipías iyulilisli. Quema, quipías iyulilisli aqui yes hual momacahuiltis pa miquis pampa yihual quilasojla Dios huan ilahueliltilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Annimitzilía pa in layúa, cayasi ome lacames pan se lapexli. Se cayas laquixtili pin polehuilisli, huan in oc se yes lacahuali. ");
INSERT INTO nclNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Cayasi ome sihuames testicate, in se cayas laquixtili huan in oc se yes lacahuali. ");
INSERT INTO nclNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Cayasi ome pin cuajmili. Se yes laquixtili huan in oc se yes lacahuali. ");
INSERT INTO nclNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Huan yehuanten quilajlanijque, quilijque: —¿Ca capic, Tata? Jesús quinmilic: —Jan quinami capa unca se mijquil, nepa monechicusi in tzopilojmes. ");
INSERT INTO nclNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Cuaquinon quinmilic Jesús se laijnamiquiltilisli pa quinmaxtisquiaya quinami monequi pa moxtin amo mocahuasqui pa quilajlanisqui Dios huan amo siahuisqui, ");
INSERT INTO nclNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","quinmilic: —Cataya se laꞌajuani pa se caltilan amo momajtiaya ilaixpan Dios, huan amo quimacajsiaya hual quijtuloaya lacames. ");
INSERT INTO nclNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Huan cataya se sihual ihuían pin caltilan amo mocahuaya pa hualas capa yihual, quilijtataya: “Xichnapati pa camo nechcajcayahuas in nolacocolini.” Huan pa míac tonalijmes amo quinequiaya quinapati in laꞌajuani. ");
INSERT INTO nclNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ma yoje, panuje tonalijmes, quijtuc laijtic yihual, quil: “Amo nimomajtía ilaixpan Dios, huan amo nicmacajsía hual quijtulo lacames. ");
INSERT INTO nclNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ma yoje, nía nicnapatía in sihual ihuían jan pampa nechmacatica tequil. Sinda amo nicnapatis, yihual amo mocahuas pa hualas capa nehual huan nejsiahuiltis huan ca nadita amo huil nipanujtías in tequil.” ");
INSERT INTO nclNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Cuaquinon in Tata Jesús quilic: —Xijcaquican len quijtúa in laꞌajuani amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Huan Dios, ¿len quichías? ¿Amo quinnapatis yehuanten hual yihual quinlajtultic pa yelosquiaya iyaxca? Huan ¿huejcahuas pa quinnapatis? ");
INSERT INTO nclNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Neli annimitzilía, Dios quinnapatijtiquisas. Ma yoje, nehual ilacal in cielo, pa in tonali hual nihualas oc sejpa, ¿nía niquinmita míac lacames pan lalticpan hual quineltocalo Dios ilamachiltilisli cuali? ");
INSERT INTO nclNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Cuaquinon quinmilic Jesús se laijnamiquiltilisli pa yehuanten hual quijtuloaya laijtic yehuanten pampa cataloaya lacames cuajcuali huan quinxijxiculoaya moxtin oc sequin. Quinmilic: ");
INSERT INTO nclNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Cataloaya ome lacames panquisaje pa in tiopan hué pa quilajlanilosquiaya Dios. Se yec fariseo, in oc se yec se laꞌanani hual quipixcaya tomin pa in lahueliltilisli romano. ");
INSERT INTO nclNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Moquetzac in fariseo, quilic Dios in lajtomes pa lanextilisquiaya quinami yihual in fariseo cataya cuali, quilic: “Dios, nimijsehuía pampa amo niunca quinami moxtin in oc sequin lacames. Yehuanten laxtequinijmes, lacames hual amo quiman quineltocalo mochi in lajtol, lacames hual quinmanalo oc sequin sihuames. Quema, yehuanten quinami in laꞌanani hual quipixca tomin pa in romanos. ");
INSERT INTO nclNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nel nimosahua ome lasahualisli mochi chicué tonalijmes, nimitzmaca se hual unca ca mochi diez tomin hual nechlaxlahuilo huan se hual moita ca mochi diez hual nicpixca.” Yoje quilic in fariseo. ");
INSERT INTO nclNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Huan in se hual quipixcaya tomin mocahuac huejca, amo quinequiaya lachía pa in cielo. Motecuaya pa itzindan iquixlan pampa icnotiaya pampa quinchíac laijlaculisli, quilijtataya: “O Dios, xichicnili, xichquixtili nolaijlaculisli pampa nel in se hual nicchía laijlaculisli molaixpan tehual.” Yoje quilic in lacal hual quipixcaya tomin. ");
INSERT INTO nclNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Cuaquinon Jesús quinmilic yehuanten hual quicactataloaya: —Annimitzilía inon. Temuc pa ichan in se hual quipixcaya tomin, Dios quiztataya quinami yajmo quipixtataya ilaijlaculisli, pampa Dios quicaquic ilatemachilisli. Huan in fariseo temuc pa ichan quipixtataya ilaijlaculisli. Cataya yoje pampa aqui yes hual mochías hué ilaixpan Dios, yihual Dios quichías tipichin. Huan aqui yes hual mochías tipichin ilaixpan Dios, yihual Dios quichías hué. ");
INSERT INTO nclNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Huan quinhualiquililoaya Jesús in xolotzitzindis noje pa yihual quinmatocasquiaya. Quitajque inon imonextilinijmes, pehuajque quinmajuajque yehuanten hual quinhualiquililoaya. ");
INSERT INTO nclNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ma yoje, quinnotzac Jesús in xolotzitzindis pa hualalosquiaya capa yihual, quinmilic imonextilinijmes: —Xiquinmacahuiltican pa hualasi capa nehual in xolotzitzindis. Amo xiquintzacuilican, pampa capa huelitía Dios jan moitasi yehuanten san hual quineltocalo ilajtol Dios quinami quineltocalo xolotzitzindis. ");
INSERT INTO nclNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Quema, annimitzilía neli, aqui yes hual amo quimacahuiltía pa Dios huelitis laijtic yihual quinami se xolotzindi quimacahuiltía huelitía, yihual amo quiman quipías Dios huelitijtica laijtic yihual. Unca pampa se xolotzindi quineltoca mochi ilajtol Dios huan quineltoca ca mochi iyolo. ");
INSERT INTO nclNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Huan se hué hual yec lacal yancuic quilajlanic Jesús, quilic: —Lamaxtini ticuali, ¿len nicchías pa nicanas in hual iyaxca Dios pa techmacas, iyulilisli hual amo quiman lamis? ");
INSERT INTO nclNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús quilic: —¿Leca tichilic pampa nicuali? Jan se san unca cuali, in unca Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tiquinmati Dios ilajtomes hual ticpías pa tiquinneltocas: Amo xicana sihual hual amo mosihua, amo xilamicti, amo xilaixtequi, amo xiquili islacatilisli inahuac amaqui, xiquinlasojla ca momajtilisli motajtzin huan monantzin. ");
INSERT INTO nclNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","In lacal yancuic quilic: —Mochi innojen niquinneltocaya quiman niyec xolol huan quiman nimochíac lacal. ");
INSERT INTO nclNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Quicaquic Jesús inon, yihual quilic: —Unca se lachihualisli hual ayamo ticchíac. Mochi hual ticpía xicnamaca huan xiquinxiluili yehuanten hual amo quipialo. Yoje ticpías nepa pa in cielo len hual monotza niman míac. Huan xihuala, xichtoca pa tiyes nomonextilini. ");
INSERT INTO nclNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Quincaquic innojen lajtomes in lacal yancuic, pehuac quicocuc iyolo míac, pampa quipiaya míac tomin. ");
INSERT INTO nclNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Quitac Jesús quinami in lacal yancuic icnotijtiahuiaya, huan quijtuc: —¡Neli unca etic pa yehuanten hual quipialo míac pa quimacahuiltisi pa Dios huelitis pa inminyolo! ");
INSERT INTO nclNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Quema, unca niman etic pa se hual quipía míac pa quipías Dios huelitijtica pa iyolo. Amo unca yoje etic pa se camello calaquis huan quipanahuis pa iixtololon se lajtzomaloni. ");
INSERT INTO nclNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Yoje yehuanten hual quicaquijque inon quilijque: —Cuaquín amo unca amaqui hual huil yes laquixtili pin ipolehuilisli ilaijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús quinnanquilic: —Dios huil quichía len yes hual amo huil quichihualo lacames. ");
INSERT INTO nclNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Cuaquinon Pedro quilic: —Xiquita. Tijcajcahuaje mochi hual toyaxca pa timitztocalosquiaya pa tiyelosquiaya momonextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesús quinmilic: —Neli annimitzilía inon: Cuajnesi quincajcahuas se icali o isihua o icnían o itajtzin huan inantzin o ixolomes. Quincajcahuas pa quipías Dios huelitijtica pa iyolo. ");
INSERT INTO nclNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Se hual quichías yoje canas niman míac, huan quitas quinami amo cate míac innojen hual quincajcahuac. Quema, huan panus yoje ca moxtin, pampa quinpías innojen axan capa yultica pin lalticpan. Huan pin lalticpan yancuic hual yahui caya, quipías yulilisli hual amo quiman lamis. ");
INSERT INTO nclNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Cuaquinon Jesús quinhuicac in doce ilanahuatinijmes capa cataloaya inminhuían, quinmilic: —Xiquitacan. Tipanquisticate pa Jerusalén huan lamis mochías mochi hual quijcuiluje Dios ilajtunijmes hual nehual ilacal in cielo nicpías pa nipanus. ");
INSERT INTO nclNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Quijcuiluje pampa nehual nechtemacasi ca yehuanten hual amo judíos. Yehuanten nechuitzquilisi, nechuejuecaltisi, nejchijchasi. ");
INSERT INTO nclNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Cuaquinon nechuitequisi huan nechmictisi. Huan quiman nechpanus inon, panusi ye tonalijmes huan niyulis oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yehuanten amo quimatiloaya nindeno len quinequiaya quijtu in lajtol hual Jesús quinmilic. Cataya quinami laticumac inminyolo. ");
INSERT INTO nclNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ajsitihualaya Jesús pa Jericó, huan cataya se lacal pachacal molalijtataya pa itenco in ojli, motemachilijtataya tomin. ");
INSERT INTO nclNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Huan quicaquic in míac lacalera panujtataloaya, quilajlanic pa quimatisquiaya len panujtataya. ");
INSERT INTO nclNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Quimachiltijque pampa Jesús in nazareteco panujtataya. ");
INSERT INTO nclNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Pampín tzajtzic, quilic: —¡Jesús, tehual ixól David, xichicnili nehual! ");
INSERT INTO nclNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Yehuanten hual nejnemiloaya quilaicantataloaya Jesús cajuajque pa mocahuasquiaya. Ma yoje, yihual jan yoje amo mocahuaya pa tzajtzisquiaya chicahuac, quilic: —¡Tehual ixól David, xichicnili nehual! ");
INSERT INTO nclNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Moquetzac Jesús, latilanic pa quihuicalosquiaya in pachacal capa yihual. ");
INSERT INTO nclNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Ajsic yihual capa Jesús cataya, Jesús quilic: —¿Len ticnequi pa nimijchihuilis tehual? Huan yihual quilic: —Tata, nicnequi nilachía. ");
INSERT INTO nclNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Huan Jesús quilic: —¡Xilachía, cuaquín! Pampa ticneltocac, yoje tipajtic. ");
INSERT INTO nclNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jan ajnaxcan lachiaya huan pehuaya quitoca Jesús pa in ojli, quinmijtutataya lajtomes huejué huan cuajcuali pa Dios. Huan moxtin in oc sequin quijtuloaya lajtomes huejué pa Dios pampa quitajque len panuc. ");
INSERT INTO nclNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Cuaquín Jesús calaquic in caltilan Jericó, ");
INSERT INTO nclNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","huan pejtiahuiaya quipanahui in caltilan. Huan cataya se lacal motocaya Zaqueo, yihual yec in hué ca in laꞌananijmes hual quipixcaloaya tomin pa in romanos hual huelitiloaya. Yec lacal hual quipiaya míac tomin. ");
INSERT INTO nclNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yihual quitemuaya quinami quitasquiaya Jesús pa quimatisquiaya aqui cataya. Huan amo huil quitaya pampa in lacalera quitzacuilijtataloaya. Yojque amo huil quitasquiaya pampa yihual yec lacal cuixtic huan amo huil lachiaya pa pani yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Pampín molalujtíac ca capic yahuiloaya panulo moxtin. Lejcuc pan se cuahuil hual itoca sicómoro, lejcuc pa huil quitasquiaya Jesús, pampa yahuiaya panu pa in ojli nepa. ");
INSERT INTO nclNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Huan panuc Jesús ca ompic, lachíac pa pani huan quilic: —Zaqueo, xitemujtiquisa, pampa monequi pa nimitzpaxaluilis axan pa mochan. ");
INSERT INTO nclNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Yoje temujtiquisac Zaqueo, huan paquiaya niman míac pa yoje quinamiquisquiaya Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Quitajque inon in lacalera, moxtin pehualoaya cualanilo pampa Jesús quichíac inon, quijtuloaya: —Yihual uyac pa paxalus pa ichan se lacal laijlaculi. ");
INSERT INTO nclNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Cuaquinon moquetzac Zaqueo, quilic in Tata Jesús: —Xiquita, Tata. Nía nicmaca yehuanten hual amo quipialo nindeno ilajco mochi in hual nicpía. Huan mochi sejse hual nijquixtilic tomin ca lacajcayahualisli, axan nía niclaxlahuía nahui tomin pa sejse tomin hual nijquixtilic yihual. ");
INSERT INTO nclNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Huan Jesús quilic: —Axan in tonali moxtin pa icali Zaqueo cate laquixtili pin ipolehuilisli inminlaijlaculisli, pampa yihual neli unca se imiahuil Abrahám. Axan quineltoca Dios quinami Abraham quineltocani. ");
INSERT INTO nclNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Unca laquixtili pin polehuilisli pampa nehual ilacal in cielo nihualaya pa nictemus huan pa nijquixtis pin polehuilisli aqui hual polejtataya. ");
INSERT INTO nclNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Quincaquiloaya yehuanten innojen lajtomes, cuaquinon Jesús quinmilic oc se laijnamiquiltilisli pa quinmaxtisquiaya. Quinmilic inon pampa amo cataloaya huejca pa quiahuac Jerusalén, huan quijtuloaya yehuanten pampa jan ajnaxcan yahuiaya ajsi pan lalticpan in tonali hual Dios pehuaya hueliti. ");
INSERT INTO nclNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Huan Jesús quinmilic: —Cataya se lacal lacatic pan huejueyenten, itajtzin yec se hué. Yahuiaya yahui in lacal pa se lali huejca, nepa yahuiloaya quichihuililo pa yesquiaya inminhué, cuaquinon yahuiaya mocuepa pa ilali. ");
INSERT INTO nclNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ayamo uyac, huan latilanic pa hualalosquiaya capa yihual majlacli (diez) itequipanujquimes hual quitequipanuililoaya yihual ihuían. Quimacac tomin mochi sejse, quinmilic: “Xilacuhuacan huan xilanamacacan ca in tomin pa quiman nimocuepas.” Cuaquinon uyac. ");
INSERT INTO nclNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ma yoje, yehuanten pa ilali amo quixtocaloaya, huan quinahuatije pa quililosquiaya: “Amo ticnequilo in se pa huelitis ca tehuanten.” ");
INSERT INTO nclNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Panuje tonalijmes, mochíac inminhué yehuanten nepa pin lali huejca. Cuaquinon, mocuepac pa ilali, quinnotzac pa hualalosquiaya capa yihual in diez tequipanujquimes hual quinmacac in tomin. Quinnotzac pa quimatisquiaya quinami lacuhuaje huan lanamacaje huan quichi canaje ca in tomin. ");
INSERT INTO nclNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Hualac capa yihual in se calica pehuaya quilajlani quinami quichíac ca itomin, quilic: “Tata, motomin momiactic huan axan cate diez tomin pa mochi sejse tomin hual tichmacac.” ");
INSERT INTO nclNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Huan in Tata quilic: “Ticchíac cuali, tehual titequipanujquil cuali. Ticchíac cuali ca in nadita hual nimitzilic pa ticchihuasquiaya. Pampín, nicmati pampa tehual ticmati ticchía cuali ca mochi hual ticchías. Xihueliti pa innojen diez cajcaltilan.” ");
INSERT INTO nclNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Hualac oc se tequipanujquil, quilic: “Tata, motomin momiactic huan axan cate macuili tomin pa sejse tomin hual tichmacac.” ");
INSERT INTO nclNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Huan in hué quilic noje in se, quil: “Xihueliti tehual pa innojen macuili cajcaltilan.” ");
INSERT INTO nclNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Hualac oc se, quilic: “Tata, nican unca motomin, nicajcoquiaya pa se dango. ");
INSERT INTO nclNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nicchíac yoje pampa nimomajtiaya molaixpan tehual pampa tehual tiunca se lacal chicahuac quinami se hual amo quipía pachihuilisli. Tiquihuica len amo ticlalic, ticpixca len hual amo tictocac.” ");
INSERT INTO nclNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","In hué quilic: “Nimitzmotexpahuilía tehual pampa in hual tiquijtuc, titequipanujquil elehuis. Ticmatiaya pampa niunca se lacal chicahuac hual nicuica len amo niclalic. Huan ticmatiaya nel se lacal hual nicpixca len amo nictocac. ");
INSERT INTO nclNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Leca, nuso, amo ticlalic notomin ca yehuanten hual quilanehuilo? Cuaquinon nehual nijquixtiaya ca míac quiman nihualaya.” ");
INSERT INTO nclNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Cuaquín quinmilic yehuanten hual nepa moqueztataloaya, quil: “Xijquixtilican in tomin huan xicmacacan in se hual canac diez tomin pa mochi sejse tomin hual nicmacac.” ");
INSERT INTO nclNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Huan quilije: “Tata, quipía diez tomin pa mochi sejse tomin hual ticmacac.” ");
INSERT INTO nclNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","In hué quilic: “Annimitzilía inon. Aqui yes hual quipía, yihual quimacasi oc sequin míac. Huan aqui yes hual amo quipía, yihual quiquixtilisi in nadita hual quipía. ");
INSERT INTO nclNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Huan innojen nolacocolinijmes hual amo quinequiloaya pa niyesquiaya inminhué, xiquinhualicacan nican, xiquinmictican nolaixpan.” ");
INSERT INTO nclNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Lamic Jesús quinmilic innojen lajtomes, uyac laicantiahuiaya huan ja umpa quitocatiahuiloaya yehuanten moxtin, panquistiahuiloaya pa Jerusalén. ");
INSERT INTO nclNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ajsijque ilaixpan in lomita (tepetzindi) itoca Olivos, amo cataloaya huejca Betfagé huan Betania. Nepa Jesús quintilanic ome imonextilinijmes, ");
INSERT INTO nclNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","quinmilic: —Xicalaquican in caltilan tipichin hual unca anmolaixpan. Nepa capa ancalaquis, anquitas se burra ixól ilpitica, ayamo quiman lejcuaya amaqui. Xictomacan huan xicualicacan. ");
INSERT INTO nclNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Huan sinda se anmitzlajlanis: “Huan ¿leca anquitontica?” cuaquín yoje anquilis: “Monequi pa in Tata quipías yihual pa lejcus.” ");
INSERT INTO nclNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yoje uyaje yehuanten hual Jesús quintilanic, quitajque in burrito jan quinami Jesús quinmilic. ");
INSERT INTO nclNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Huan quitontataloaya in burrito, itecojuan quinmilijque: —¿Leca anquitontica in burrito? ");
INSERT INTO nclNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Quinmilijque: —Monequi pa in Tata quipías yihual pa lejcus. ");
INSERT INTO nclNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Quihualicajque in burrito capa cataya Jesús. Cuaquinon quinlasajque inminlaquemes pani in burrito, quilejcultijque Jesús ipan. ");
INSERT INTO nclNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Cuaquinon yajtiahuiaya in burrito, imonextilinijmes Jesús quilaicantiahuiloaya lapipixtitataloaya ca inminlaquemes pa ojli pa yoje in burro nejnemisquiaya inminpan in laquemes. ");
INSERT INTO nclNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yojque ajsitiahuiaya Jesús ca capic pehualosquiaya temulo pin lomita (tepetzindi) itoca Olivos pa Jerusalén. Huan moxtin in míac monextilinijmes pehualoaya quijtulo lajtomes huejué huan cuajcuali pa Dios ca míac paquilisli huan ca lajtol chicahuac. In quichihualoaya pampa quinmitajque in míac hual Jesús quinchíac, yojque quinnextililoaya pampa yihual quipiaya ilahueliltilisli Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Quililoaya: —¡Dios quituchía huan quichihuilijtía cuali in hué hual quitilanic pan lalticpan! ¡Dios quijtuni pampa yahuiaya huala ca ilahueliltilisli Dios! ¡Pin cielo Dios mocahua ca mosehuilisli ca in lacames! ¡Huan nepa capa niman pa pani moxtin quijtulo lajtol hué huan cuali pa Dios pampa inon! ");
INSERT INTO nclNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Sequin fariseos hual cataloaya ca in míac lacalera quilijque Jesús: —Lamaxtini, xiquinmili momonextilinijmes pa mocahuasi. ");
INSERT INTO nclNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Quinnanquilic Jesús, quil: —Annimitzilía amhuanten pampa sinda amo nahuatilosquiaya yehuanten, cuaquinon tzajtzilosquiaya in tixcalimes. ");
INSERT INTO nclNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Huan quiman ajsitiajque pa Jerusalén, chocac Jesús quiman quitac in caltilan hué, quilic: ");
INSERT INTO nclNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","—¡Sinda amhuanten pa Jerusalén anquimatiaya inon hual Dios anmitzmacasquiaya amhuanten pa yoje anquipiasquiaya yihual imosehuilisli pan anmoyolo! Huan axan Dios anmijtzacuilic pa camo anquimatisquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ajsitihualasi tonalijmes huan yehuanten hual moanasi ca amhuanten quimontusi lali huan teles pa itenco anmocaltilan Jerusalen pa anmijtzacuilisi pa mochi laijtic, huan amo huil anmoquixtis. ");
INSERT INTO nclNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Cuaquinon yehuanten hual anmitzcocolisi anmitzlalhuitequisi pan lali, amhuanten huan anmoxolomes, huan amo quicahuasi se tixcali pa icalimes anmocaltilan, pampa yalo quinmayahuilo mochi. Yoje anmitzcuepilis Dios. Unca pampa amo anquimatiaya Dios hualac ca amhuanten pa innojen tonalijmes. Hualac pa anmitzquixtis pin polehuilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Cuaquín calaquic Jesús calijtic in tiopan hué, pehuac quinquixtic pa quiahuac yehuanten hual lanamacaloaya nepa. ");
INSERT INTO nclNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Quinmilic: —Yoje unca lajcuiluli pa iamal ilajtol Dios, quijtúa: “Nocali yes se cali capa lacames quilajlanilo Dios.” Yoje quijtúa. Huan amhuanten anquichíac in tiopan hué quinami inminchan laixtequinijmes. ");
INSERT INTO nclNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Lamaxtiaya mojmosta Jesús pin tiopan hué. Huan in tiopistas huejué huan ilamaxtinijmes inminlajtol in judíos quitemuloaya quinami quimictilosquiaya. Noje quinequiloaya quimictilo inminhuejueyenten in judíos. ");
INSERT INTO nclNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ma yoje, amo huil quitaloaya quinami huil quichihualosquiaya, pampa mojmosta moxtin quinequiloaya quicaquilo, huan amo quiman quicahualoaya Jesús ihuían. ");
INSERT INTO nclNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Cataya pan se ca innojen tonalijmes lamaxtitataya Jesús pin tiopan hué, quinlaquetzilijtataya in lacames in lamachiltilisli cuali. Hualajque capa yihual in tiopistas huejué huan ilamaxtinijmes inminlajtol in judíos, huan noje hualajque oc sequin hueyenten. ");
INSERT INTO nclNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Quilijque: —Xitechili ca aqui ilahueliltilisli anquichijtica innojen hual anquinchía. O ¿aqui unca in hual mitzmacac in lahueliltilisli? ");
INSERT INTO nclNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Huan Jesús quinnanquilic: —Nehual noje annimitzlajlanis len huan amhuanten xichnanquilican. ");
INSERT INTO nclNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Juan Lacuayatequini quincuayatequini lacames pa yehuanten lanextilosquiaya pampa quipalaje inminyolo pa pehualosquiaya laijnamiquilo quinami Dios quinequi. ¿Ca aqui ilahueliltilisli quinchihuilini Juan inon? ¿Cataya ilahueliltilisli Dios o lacames? ");
INSERT INTO nclNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Yehuanten molaquetzilijque ca yehuanten inminhuían, moilijque: —Sinda tiquilisi pampa cataya ilahueliltilisli Dios, cuaquinon techlajlanis: “¿Leca amo anquineltocac?” ");
INSERT INTO nclNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Sinda tiquilisi pampa cataya inminlahueliltilisli lacames, cuaquinon moxtin techlaxilisi tixcalimes, pampa yehuanten neli quijtulo pampa Juan yec ilajtuni Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Pampín quinanquilijque Jesús: —Amo ticmatilo aqui ilahueliltilisli quipiaya Juan. ");
INSERT INTO nclNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Cuaquinon Jesús quinmilic: —Huan nehual noje amo annimitzilis ca aqui ilahueliltilisli niquinchía innojen. ");
INSERT INTO nclNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Cuaquinon pehuaya quinmili in lacames in laijnamiquiltilisli pa quinmaxtisquiaya, quinmilic: —Cataya se lacal quilaltocac pan se cuajmili ipacholimes uva huan temacac lajlajco iuvatilan ca oc sequin lacames pa quitequipanuilisi. Cuaquín in lacal quisac pa ichan huan uyac huejca huan nepa mocahuac míac tonalijmes, huan in oc sequin lacames quilachililoaya iuvatilan. ");
INSERT INTO nclNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Yucsije in uvas, huan in lacal quitilanic se tequipanujquil pa yasquiaya pa in lacames hual quilachililoaya iuvatilan. Quintilanilic pa yehuanten quimacalosquiaya se ilajco in uvas hual quitequije. Huan in lacames quihuitequije chicahuac, huan quicholultije huejca, amo quimacaje uvas nindeno. ");
INSERT INTO nclNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Oc sejpa in lacal quitilanic oc se itequipanujquil. Huan yihual noje quihuitequije chicahuac huan quihuejuecaltije, cuaquín quicholultije, amo quimacaje nindeno. ");
INSERT INTO nclNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Oc sejpa quitilanic oc se tequipanujquil, huan in se quitecuaje huan quisaya esli, cuaquín quilasaje pa quiahuac. ");
INSERT INTO nclNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Cuaquinon quijtuc iteco in uvatilan, quil: “¿Len nicchías? Axcan nictilanis noxól, yihual hual nicnequi míac. Cuajnesi ca yihual quimatisi momajtisi.” ");
INSERT INTO nclNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ma yoje, in tonali in tequipanujquimes ejꞌelehuis quitaje ixól, molaquetzilije, moilije: “In se yahui quipía in uvatilan pampa unca iyaxca itajtzin. Ma ticmictican pa timoyaxcajtisi tehuanten in uvatilan pa yes toyaxca.” ");
INSERT INTO nclNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Cuaquinon quilasaje pa quiahuac in uvatilan, nepa quimictije. ¿Len, axan, quinchihuilis in lacames iteco in uvatilan? ");
INSERT INTO nclNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yihual hualas huan quinmictis in lacames ejꞌelehuis. Cuaquinon temacas ca lajlajco iuvatilan ca oc sequin lacames pa quitequipanuilisi. Ja in san. Yehuanten hual quicaquijque in laijnamiquiltilisli quilijque: —Ma camo quimacahuilti Dios pa panus inon. ");
INSERT INTO nclNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Huan Jesús lachíac capa yehuanten huan quinmilic: —Cuaquinon, ¿len quinejquijtu in hual unca lajcuiluli pa Dios ilajtol? Yoje quijtúa: Cataya se tixcali hual amo quinequiloaya quilalilo yehuanten hual quichihualoaya in cali. Ma yoje iteco in cali quilalic in tixcali capa yehuanten hual quichihualoaya in cali yahuiloaya quipehualtilo in cali. Pampín quipialoaya pa quinlalilosquiaya in oc sequin tixcalimes pejticate capa quilalic in tixcali iteco in cali. Yoje quijtúa ilajtol Dios huan quinejquijtu inon: ");
INSERT INTO nclNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Sinda se mochías nolacocolini cuaquinon yes quinami momañajtis huan huetzis pan in tixcali. Cayas quinami latecuali chicahuac. Huan sinda se mocahua amo quinectica nechneltoca, yes quinami in tixcali huetzisquiaya pani yihual huan quitesisquiaya pa mochihuasquiaya lalmoluncal hual in ijyecal quihuicasquiaya. Quinami yoje cayas pan tonali Dios quitojtocas ilaixpan yihual se lacal. Yoje mocahuas laijcuanili, yajmo huil ajsi capa Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Cuaquinon ca nadita quitemujque quinami huil quiquitzquilosquiaya Jesús in tiopistas huejué huan ilamaxtinijmes inminlajtol in judíos. Ma yoje momajtiloaya pampa in lacames quicaquiloaya. Quimatiloaya in huejueyenten pampa Jesús quinequiaya quijtu pampa yehuanten cataloaya quinami innojen lacames ejꞌelehuis quiman quinmiliaya in laijnamiquiltilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ma yoje, mocahualoaya laijcuanili nadita, quichialoaya pa quiman huil ajsilosquiaya ca yihual. Cuaquinon quinlaquehuajque lanapachinijmes, mochihuaje quinami cataloaya lacames cuali mas que lacuajcuamanaloaya. Yoje quinequiloaya quichihuililo pa quijtusquiaya Jesús len lajtol calica huil quimotexpahuililosquiaya. Yoje quitemacalosquiaya pa in gobernador romano. Cataya jan yihual san hual quipiaya lahueliltilisli pa latilanisquiaya pa quimictilsquiaya Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Huan in lanapachinijmes quilajlanijque Jesús, quilijque: —Lamaxtini, ticmatilo pampa tehual tiquijtúa len unca cuali huan ticmaxtía len unca cuali. Ticmatilo noje pampa amo tiquita se quinami yihual cuali huan oc se amo yoje cuali. Huan ticmaxtía iojli Dios hual yihual quilalic pa canasi moxtin. Ticmaxtía melahuac, amo quiman ticmaxtía len hual amo unca quinami Dios quijtúa. ");
INSERT INTO nclNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Axan, xitechili, ¿quimacahuiltía tolajtol pa ticlaxlahuisi in hué César in tomin pa ilahueliltilisli, o amo quimacahuiltía? ");
INSERT INTO nclNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesús quimatiaya quinami yehuanten quichihualoaya pa quimoixpolultilosquiaya ca ilajtomes. Cuaquinon huil quimotexpahuililoaya inminlaixpan in hueyenten ihuelitinijmes in hué César. Yoje Jesús quinmilic: —Xichnextili se tomin. ");
INSERT INTO nclNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Quinextilijque. Cuaquinon quinmilic: —¿Aqui unca in itzontecon huan itoca pan in tomin? Yehuanten quilijque: —Unca iyaxca in hué César. ");
INSERT INTO nclNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Cuaquinon Jesús quinmilic: —Pampín, anquipía pa anquilaxlahuis in tomin pa in hué César ilahueliltilisli, huan anquipía pa anquimacas César mochi hual unca iyaxca César. Huan jan yoje anquipía pa anquimacas Dios mochi hual unca iyaxca Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yojque amo huil quijtuloaya nindeno amo cuali ca quinami quinnanquilic Jesús, pampa moxtin yehuanten hual nepa moqueztataloaya quicaquiloaya Jesús huan quimatiloaya pampa amo moixpoluc ca innojen lajtomes hual quinnanquilic. Huan mocahualoaya moizticate lapolultili in lacames hual quilajlanijque inon. Mocahualoaya yoje pampa quinnanquilic Jesús ca ilajmatilisli hué. ");
INSERT INTO nclNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Cuaquinon hualajque capa Jesús sequin saduceos, yehuanten quimaxtilo pampa amo yulisqui oc sejpa yehuanten hual miquilo. Huan quilajlanijque Jesús, quilijque: ");
INSERT INTO nclNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Lamaxtini, Moisés hual yulini pa yina techijcuiluilic inon: Sinda se lacal miqui, quipía isihua huan amo quinpialo xolomes, cuaquinon icni in lacal hual miquic canas isihua icni hual miquic. Cuaquinon yehuanten quinpiasi xolomes huan quintocayaltisi quinami motocaya icni hual miquic. ");
INSERT INTO nclNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Axan, cataloaya chicome icnían. Canac se sihual se inmicni, amo quinpiaje xolomes, cuaquín miquic in lacal. ");
INSERT INTO nclNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Canac isihua ihuían oc se icni, cuaquinon miquic, amo quinpiaje xolomes. ");
INSERT INTO nclNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Huan umpa canac in sihual ihuían oc se icni, miquic. Yojque panuc ca moxtin in chicome, amo quinpialoaya xolomes ca in sihual, moxtin miquije. ");
INSERT INTO nclNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Huan cuaquín miquic in sihual noje. ");
INSERT INTO nclNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Axcan, sinda yulisi oc sejpa yehuanten hual miquilo, ¿pa calía innojen chicome yes in sihual? Pampa moxtin in chicome lacames quipialoaya in sihual. ");
INSERT INTO nclNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesús quinnanquilic: —Jan yehuanten hual yulilo pin lalticpan monamictilo. ");
INSERT INTO nclNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ma yoje, quiman lamis in lalticpan hual axan unca, amo monamictilo yehuanten hual Dios quinlajtultic pa yulisi oc sejpa capa yihual unca pin cielo. ");
INSERT INTO nclNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Noje yajmo huil miquilo, cayasi quinami in lanahuatinijmes pin cielo. Yehuanten amo monamictilo huan amo miquilo. Quema, cate ixolomes Dios yehuanten hual yulisi capa yihual quiman miquisi. ");
INSERT INTO nclNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Huan neli unca pampa yehuanten hual miquilo yulisi oc sejpa. Moisés anmitzmachiltía inon, pampa quijcuiluc len in Tata Dios quilic nepa quilaquetzilijtataya ca ilajtol quistataya pin huitzcuajtzindi. Quilic: “Nehual iDios Abraham huan iDios Isaac huan iDios Jacob”, quilic. ");
INSERT INTO nclNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Dios amo unca inminDios in mijquimes, yihual inminDios yehuanten hual yulticate, pampa Dios quinmita moxtin quinami yulticate. ");
INSERT INTO nclNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Cuaquinon sequin ca ilamaxtinijmes inminlajtol in judíos quilijque: —Lamaxtini, tilajtuc cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Inon quilijque pampa axan momajtiloaya pa quilajlanilosquiaya oc se lajtol. ");
INSERT INTO nclNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Cuaquinon Jesús quinmilic: —¿Quinami huil quijtulo pampa in Cristo ja unca san imiahuil David? ");
INSERT INTO nclNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Yihual David quijtúa pa iamal in Salmos yoje: In Tata Dios quilic noTata, quilic: “Xihueliti ca nehual timolalijtica pa noma cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Huan ajsis in tonali hual niquinchihuilis moxtin molacocolinijmes pa mitzneltocasqui.” ");
INSERT INTO nclNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Yoje, David quitocayaltic “noTata.” Pampín, in Cristo unca niman hué huan David amo unca hué quinami yihual. Cuaquín, ¿quinami unca in Cristo imiahuil? ");
INSERT INTO nclNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Cuaquinon Jesús quinlaquetzilic imonextilinijmes huan moxtin in oc sequin noje quicaquiloaya len quinmilijtataya, quinmilic: ");
INSERT INTO nclNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Ximijmaztiacan inminpampa ilamaxtinijmes in lajtol. Yehuanten quinequilo molaquentitinemilo ca nahuajmes cuajcualtichin. Quixtocalo pa moxtin quinpialtilo ca mochi momajtilisli pin lajcotiyan. Quixtocalo molalilo pin tiopajmes capa cate in icpalimes pa in huejueyenten. Huan quiman molalilo pa lacuasi, quixtocalo molalilo pan icpalimes hual cate pa in huejueyenten. ");
INSERT INTO nclNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Quinequilo pa moxtin quinmomajtilisi míac, huan ma yoje, quincajcayahualo sihuames hual cate inminhuían, quinmoyaxcajtililo inmincalimes. Huan pa nesisi quinami cate lacames cuajcuali, mas que quinmixtequililo, huejcahualo míac mochijticate quinami quilajlanticate Dios, quijtuticate míac lajtomes. Yehuanten Dios quincocoltis niman míac, amo yoje míac quincocoltis oc sequin. ");
INSERT INTO nclNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Cuaquinon lachíac Jesús, quinmitac yehuanten in lacames hual quipialoaya míac tomin quilalijtataloaya inmintomin pin capa quilasaloaya tomin nepa pin tiopan hué. ");
INSERT INTO nclNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Huan quitac se sihual ihuían amo quipiaya ca len yulis. Yihual quilalic nepa ome tomin hual cataloaya tijtipichin, amo cataloaya oc sequin tomin yoje tipichin. ");
INSERT INTO nclNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Cuaquín Jesús quinmilic in lacames: —Neli annimitzilía, Dios quita quinami in sihual ihuían quilalic nepa míac tomin. Amo yoje míac inon hual in oc sequin quilalije, mas que yehuanten quilasaje nepa míac tomin. ");
INSERT INTO nclNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Unca pampa yehuanten quimacaje nadita inmintomin hual quipialoaya míac. Huan mas que in sihual ihuían amo quipiaya calica molacualtis, quilalic mochi in tomin hual quipiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Sequin laquetzaloaya quinami in tiopan hué cataya lachihuali ca teles cuajcualtichin, noje cataloaya cajcapa míac hual ijꞌipati hual lacames hual quipialoaya míac tomin quimacajque Dios. Huan Jesús quinmilic: ");
INSERT INTO nclNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Xitinisi innojen hual anquinmiztica. Ajsisi in tonalijmes huan amo mocahuas se tel ipan oc se tel, mochi yesi lamayahuili. ");
INSERT INTO nclNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Quilajlanijque Jesús, quilijque: —Lamaxtini, ¿quiman yahui panúa inon? Huan ¿quinami ticmatisi quiman mochi inon yahui pehua panúa? ");
INSERT INTO nclNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús quinanquilic: —Ximolachilijtiacan pa camo anmocahuas pa anquineltocas nolajtomes, pampa hualasi míac hual motocasi ca notoca pa yoje quipías lahueliltilisli inon hual anmitzilisi. Anmitzilisi: “Nehual niCristo.” Huan quilisi: “Axcan ajsic in tonali hual Dios anmitzilic.” Amo xiquintocatiacan. ");
INSERT INTO nclNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Huan quiman yes anmitzmachiltisi pampa cate moanalisli huan quinami lacames cualantinemisi pa quichihuasi moanalisli, amo ximomajtitiacan pampa mochi innojen quipialo pa panusi pa quinpehualtis itonalijmes in lacocoltilisli. Ma yoje, ayamo lamis in lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Cuaquinon quinmilic Jesús: —Moanasi yehuanten pa se lali ca yehuanten pa oc se lali, huan amo mosehuisi pa moanasi. Quema, cajcapa yes moantiasi, huan in huejueyenten pa se lali quichihuilijtiasi pa inminguaches pa inminlali moanasi ca oc se lali iguaches. Yoje panus ca míac lalimes. ");
INSERT INTO nclNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Cayasi míac laulinilisli chijchicahuac cajcapa pa mochi in lalticpan. Huan cayasi cajcapa pin lalticpan mayandi huan míac cocolisli hual mosemanas ca míac lacames cajcapa cayasi. Cayasi lanextilisli hual quinmajmajtisi moxtin. Huan nesisi pin cielo oc sequin lanextilisli hual quinmahuisultisi lacames ca lamajtilisli hué. ");
INSERT INTO nclNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Ma yoje, mochi innojen panusi quiman panuje tonalijmes capa anmitzquitzquisi pa anmijtzacuasi pa calijtic. Anmitztojtocasi, anmitztemacasi inminlaixpan inminhuejueyenten in tiopajmes pa anmitzlajlajlanisi amhuanten. Anmijtzacuasi pa calijtic quinami anyesquiaya lacames niman amo cuajcuali. Anmitzhuicasi inminlaixpan in huejueyenten huan huelitinijmes pampa annechneltoca. ");
INSERT INTO nclNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Pa innojen tonalijmes quiman anmitzpanus innojen, yoje anmitzmacas quinami huil anquinlaquetzilis quinami nehual huil niquinquixtía pin polehuilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Yoje, xiclalican in pa anmoyolo: Amo xilajtucan pa anmoyolo quinami anyahui anquinnanquilía quiman yes ayamo ancayas inminlaixpan yehuanten pa anmonapatis, ");
INSERT INTO nclNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","pampa nehual annimitzpalehuis. Nehual annimitzhueliltis pa anlajtus huan annimitzmacas noje lajmatilisli ca lajtomes huan annimitznextilis jan yoje quinami anquinmilis in lajtomes. Yoje moxtin anmolacocolinijmes amo quimatisi quinami monanquilisi in lajmatilisli hual annimitzmacas, huan yehuanten amo huil anmitznanquilisi len pa monapatisi pampa annimitzmacas in lajtomes. ");
INSERT INTO nclNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Huan anmitztemacasi anmotajtzitzían huan anmocnían huan anmocnían pa oc sequin calimes, anmitztemacasi ca in huejueyenten huan sequin ca amhuanten anmitzmictisi in huejueyenten. ");
INSERT INTO nclNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Quema, moxtin amo anmitzixtocasi, anmitzcocolisi pampa annechneltoca nehual. ");
INSERT INTO nclNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ma yoje, mas que anpanus in lacocoltilisli, Dios amo quiman quinmacahuiltis pa anmitzquixtisi capa yihual unca, no, amo jan se anmotzondi. ");
INSERT INTO nclNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ximopepenialtican mochi inon ca chicahualisli, pampa yoje anquipías anmoyulilisli, mas que cuajnesi anmitzmictisi. ");
INSERT INTO nclNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Huan in tonali hual anquitas in caltilan hué Jerusalén ca míac míac guachaje itenco, cuaquinon xicmatican pampa in guachaje amo huejcahuasi pa quixitinisi. ");
INSERT INTO nclNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Cuaquinon yehuanten hual cate pin mochi in lalticpan Judea ma cholucan pa in lomas huejca. Huan yehuanten hual cayasi pa Jerusalén ma quistiquisacan. Huan yehuanten hual cayasi pa quiahuac Jerusalén, yehuanten hual chantilo pa caltilan tijtipichin huan pin cuajlan itenco Jerusalén, ma camo calaquican pa Jerusalén. ");
INSERT INTO nclNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","No —quilic Jesús—, ma camo calaquican, pampa in tonalijmes cayasi tonalijmes hual Dios quincocoltis in judíos pampa amo quineltocalo. Quincocoltis pampa quichihuaje míac pa quintzacuilisi lacames pa camo quineltocasi ilamachiltilisli cuali. Mochías mochi hual unca lajcuiluli inminahuac in lacocoltilisli hual yalo panulo. ");
INSERT INTO nclNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Huan ¡quichi panusi lacocoltilisli in sihuames hual yalo quilacatiltilo xolomes, huan yehuanten hual lachichiltitiasi innojen tonalijmes! Quema, pampa moxtin in lacames hual mocahualo pin lali panusi lacocoltilisli. Dios icualanilisli cayas pan yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","In guaches quinmictisi ca inminteposlimes calica moanalo, huan quinhuicasi lailpili pa yesi tequipanujquimes hual amo quinlaxlahuilo pa mochi inminlalimes yehuanten hual amo judíos, amo mocuepasi ca caniquic. Huan mocahuas Jerusalén se caltilan capa lacames hual amo judíos huelitisi. Nican huelitisi pa míac xixihuil. Cuaquín ajsis in tonali quiman lamisi in xixihuimes hual Dios quinlalic pa huelitisi. ");
INSERT INTO nclNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Cayasi quinami lanextilisli pa in tonali huan in mesli huan in luceros (silalimes), pampín momajtisi lacames. Huan nican pan in lalticpan comuntías huan majcoctías chicahuac in al huejcalan, huan pampín momajtitiasi in lacames pampa amo quimatisi leca yoje quichías. ");
INSERT INTO nclNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Quema, lacames miquisi ca momajtilisli pampa quiztiasi innojen hual yahui quipanúa in lalticpan capa yulilo. Momajtisi pampa motzejtzelusi ichicahualisli mochi in cielo huan in lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Cuaquinon, moxtin nechitasi nehual ilacal in cielo. Nechitasi nihualas pan se mextemil, nihualas ca chicahualisli hué huan laixpelalisli niman cualtichin. ");
INSERT INTO nclNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Pampín, in tonali quiman pehuasi panusi innojen, ximochijchijtiacan huan xilachixtiacan. Xicayacan quinami anyahui anquita in hual anquinequiaya anquita pa quiman, pampa quema, ajsitihualas in tonali hual annimitzquixtis pin mochi lacocoltilisli hual anpanujtías. ");
INSERT INTO nclNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Cuaquinon Jesús quinmilic se laijnamiquiltilisli pa quinnextilisquiaya inon hual quinmilijtataya, quinmilic: —Xiquitacan in amacuál tipichin huan mochi in cuahuimes. ");
INSERT INTO nclNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Xuchujtiasi huan selistitiasi, cuaquinon anquimatis axan ajsitihuala in xupanda. ");
INSERT INTO nclNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Yoje, amhuanten, quiman anquitas innojen panujtiasi, cuaquín xicmatican pampa ajsitihualas Dios pa huelitis pan lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Neli annimitzilía inon: Panus inon hual annimitzilijtica quiman ayamo miquisi moxtin hual yulticate pa innojen tonalijmes. ");
INSERT INTO nclNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Lamisi in cielo huan in lalticpan. Ma yoje, nolajtomes amo quiman lamisi, amo quiman mocahuasi pa mocaquisi. ");
INSERT INTO nclNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Ximolachilican pa camo amhuanten cuajnesi anquimacahuiltis pa mochihuasi chicahuac anmoyolo ca lahuanalisli huan oc sequin laijlaculisli. Ximolachilican pa camo ancayas quinami yehuanten hual mojmosta motolinilo san pa canasi len quinequilo. San quijnamiquilo in hual panúa pan in lalticpan hual axan unca. Sinda anunca yoje, cuaquinon in tonali hual nimocuepas pan lalticpan anmitzajsis jan ajnaxcan huan amo ancayas anquichixtica. ");
INSERT INTO nclNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Quema, pampa quinmajsis moxtin yehuanten hual chantiticate pan mochi in lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Xiyén, cuaquín, quinami yehuanten hual ejsaticate, xiclajlanican Dios pa amhuanten huil ancayas laquixtili pin mochi innojen hual yalo panulo. Yoje anmoquetzas amo anmomajtitica noyampa nehual ilacal in cielo, huan amo annimitztilanis pa lacocoltilisli hual amo quiman lamis. Yoje quinmilic Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Huan mojmosta cataya Jesús pin tiopan hué lamaxtitataya. Pa layúa quisaya pa Jerusalén, panuaya lajlayúa pin lomita (tepetzindi) itoca Olivos. ");
INSERT INTO nclNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Huan hualaloaya moxtin pa laxpoyahua pa in tiopan hué pa quicaquilosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Cuaquinon ajsitihualaya itonali in fiesta (ilhuil) capa quicualo in judíos in pan hual amo quipía laxocoyajquil, in ilhuil itoca Pascua. ");
INSERT INTO nclNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Quitemuloaya in tiopistas huejué huan innojen ilamaxtinijmes inminlajtol in judíos quinami quiquitzquilosquiaya Jesús pa quimictilosquiaya. Huan amo huil quiquitzquiloaya pampa momajtiloaya laixpan in lacames hual quitocaloaya. ");
INSERT INTO nclNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Cuaquinon Satanás moyaxcajtilic iyolo Judás, in se hual quitocayaltijque Iscariote. Yihual yec se ca in doce lanahuatinijmes. Satanás moyaxcajtilic yihual pa quinextilisquiaya quinami yihual Judás huil quitemacasquiaya Jesús ca yehuanten hual quinequiloaya quimictilo. ");
INSERT INTO nclNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Cuaquinon uyac Judás pa laquetzasquiaya ca in tiopistas huejué huan in piscales, quinmilic quinami yahuiaya quintemaquili Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yoje yehuanten paquiloaya niman míac huan quichihuajque se laquetzalisli ca Judás pa quilaxlahuisqui ca tomin huan quimacajque. ");
INSERT INTO nclNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Cuaquinon yihual quinmilic neli pampa quintemaquilisquiaya Jesús, huan pehuac quitemuc quinami huil quitemaquilisquiaya Jesús ca yehuanten. Quinequiaya quichía capa amo cayasquiaya míac lacames ca Jesús hual quinapatilosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ajsic in tonali quiman quicualo judíos in pan hual amo quipía laxocoyajquil. Pa in tonali quipialoaya pa quimictilosquiaya in borreguito pa in fiesta (ilhuil) itoca Pascua. ");
INSERT INTO nclNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesús quintilanic Pedro huan Juan, quinmilic: —Xiacan xitechyucxiltilican in borreguito pa tijcuasi pa in fiesta. ");
INSERT INTO nclNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Huan quilijque: —¿Capa ticnequi pa ticyucxiltisi? ");
INSERT INTO nclNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Quinmilic: —Xiquitacan. Ancalaquis pa in caltilan, anmitznamiquis se lacal quimantihuala se tapalcal ca al. Xictocacan pa in cali capa calaquis. ");
INSERT INTO nclNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Cuaquín xiquilican iteco in cali: “In Lamaxtini mitzilía: ¿Capa unca in calijtic capa nehual nijcuas iborreguito Pascua ca nomonextilinijmes?”, quil. Yoje anquilis —quinmilic Jesús—, ");
INSERT INTO nclNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","huan yihual anmitznextilis se calijtic hué pa pani calijtic in cali capa moitasi mochi hual monequi pa ticpiasi. Nepa xicyucxiltican. ");
INSERT INTO nclNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Uyaje Pedro huan Juan, quitajque jan quinami Jesús quinmilic, huan quiyucxiltijque in borreguito. ");
INSERT INTO nclNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ajsic in layúa pa lacualosquiaya, molalijque pa lacuasqui Jesús huan imonextilinijmes ca yihual. ");
INSERT INTO nclNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Cuaquinon Jesús quinmilic: —¡Nehual nicnequiaya míac nijcua in borreguito pa pascua ca amhuanten! Cuaquín nías pa nipanus nolacocoltilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Inon annimitzilía pampa yajmo nijcuas in lacualisli pan lalticpan. Ma yoje, quiman ajsis in tonali quiman moitas Dios huelitijtica, nepa nijcuas, pampa nepa lamis mochías mochi lachihualisli hual ayamo panuc hual pampa innojen ticpialo in fiesta Pascua. ");
INSERT INTO nclNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Quimacajque Jesús se tapalcatzindi huan yihual quisehuic Dios, cuaquinon quinmilic: —Xicanacan inon huan ximoxiluilican ca amhuanten pa ancunis. ");
INSERT INTO nclNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Annimitzilía inon pampa yajmo quiman nicunis len lachihuali ca ilaquilyo uvas. Ma yoje, quiman ajsis in tonali hual Dios huelitis pan lalticpan, cuaquín nicunis. ");
INSERT INTO nclNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Cuaquinon canac pan huan quisehuic Dios, quilapanac huan quinmacac, quinmilic: —In nonacal, mochi nehual nimotemacas pa nimiquis pa amhuanten. Xijcuacan in, yoje pa annechijnamiquis. ");
INSERT INTO nclNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Huan quiman lamijque lacuajque, canac Jesús in tapalcatzindi yoje quinami canac in pan, quinmilic: —In hual ancunis pa in tapalcatzindi unca in lajtulisli yancuic ca nehual huan amhuanten. Nicchijtica in lajtulisli ca noesli hual toyahuis pa amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ma yoje, xiquitacan. Yihual hual nechtemaca ca yehuanten hual nechcocolilo unca nican lacuajtica ca nehual. ");
INSERT INTO nclNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yalo nechmictilo nehual ilacal in cielo jan quinami Dios quilalic. Ma yoje ¡quichi yahui panu lacocoltilisli in lacal hual nechtemaca! ");
INSERT INTO nclNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Cuaquinon pehualoaya molajlanilo huan molaxililo lajtomes yehuanten pa lajmatisi aqui yesquiaya hual yahuiaya quitemaca Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pehualoaya molaxililo lajtomes in monextilinijmes, laqueztataloaya pa lajmatisqui aqui ca yehuanten cataya in hué hual quinlaicanasquiaya moxtin. ");
INSERT INTO nclNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Huan Jesús quinmilic: —In huejueyenten ca yehuanten hual amo cate judíos huelitilo ca yehuanten ca chicahualisli quinami tecojuan. Huelitilo pa yoje quinnextilisi yehuanten inminlahueliltilisli huan pa yoje quinnextilisi pampa cate niman huejué, huan pa yoje quinnextilisi yehuanten hual quinneltocaltisi pampa amo cate huejué yehuanten. Yehuanten in laicananijmes, quema, motocayaltilo ca tocajmes hual quinequilo quijtulo pampa yehuanten cate lacames hual yulilo quinchihuilijticate cuali yehuanten hual quinneltocaltilo. ");
INSERT INTO nclNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Amhuanten amo anyes yoje. Monequi pa yes quinami in tipichin yihual hual unca in hué capa amhuanten. Huan yihual hual quinlaicana oc sequin ma ye se hual quintequipanuilía in oc sequin. ");
INSERT INTO nclNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ma annimitzili len nicnequi niquijtúa. ¿Aqui in hué? ¿Unca yihual hual molalía pa lacuas, o yihual hual quitequipanuilijtica? ¿Amo unca in hué yihual hual molalijtica pa lacuas? Quema, unca yihual. Ma yoje, nehual niunca ca amhuanten quinami in se hual latequipanuilijtica. ");
INSERT INTO nclNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Huan amhuanten anunca aquinojen hual anmocahuaya ca nehual quiman quitilanaloaya noyolo pa nicchiasquiaya in hual amo cuali, quiman niquitaya míac icnotilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Huan nehual annimitzmaca lahueliltilisli pa anhuelitis. Yoje noTajtzin nechmacac lahueliltilisli pa nihuelitis. ");
INSERT INTO nclNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Pampín yes anmoyaxca pa anmolalis pa anlacuas huan anlaunis ca nehual pan tonali hual nihuelitis. Yoje anquipías paquilisli ca nehual. Huan yes anmoyaxca pa anyes laꞌajuanijmes pa anquinmotexpahuilis huan pa anquinmacahuas yehuanten hual cate iyaxca in lali Israel, yehuanten inminmiahuimes mochi sejse ca in doce ixolomes Israel. ");
INSERT INTO nclNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesús quilic Pedro: —Simón, Simón, xiquita. Satanás latemachic pa anmitzanas amhuanten. Quinequi pa yajmo annechneltocas. Pampín quitemachic pa quimacahuiltisquiaya pa anmitzpanultisquiaya lacocoltilisli. Yoje Satanás quijtúa pampa inon yajmo annechneltocas. ");
INSERT INTO nclNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ma yoje, nehual nictemachic Dios pa tehual, Pedro, pa camo mitzmacahuiltisquiaya pa timocahuas pa tichneltocas. Huan tehual, in tonali hual mocuepa moyolo ca Dios, xiquinpalehui mocnían innojen oc sequin monextilinijmes pa nechneltocasi ca míac chicahualisli. ");
INSERT INTO nclNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pedro quilic: —Tata, sinda monequis, huan tehual tiasi pa ticayasi latzacuali ca calijtic, pa tehual nimiquis. Niunca nimochijchijtica pa nipanus inon. ");
INSERT INTO nclNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Huan Jesús quilic: —Pedro, nimitzilía inon: Axan in layúa, ayamo xahuanis se gallo huan tiquijtus sejpa huan oc sejpa ca ye lajtulisli pampa amo tichiximati. ");
INSERT INTO nclNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Cuaquinon Jesús quinmilic: —In tonali hual annimitztilanic huan amo anquipiaya xotopa huan len pa tomin, huan san in ome lacsames, ¿monequiaya pa anquipiasquiaya len? Quinanquilijque: —Nindeno. ");
INSERT INTO nclNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Cuaquín quinmilic: —Axan, aqui hual quipía xotopa, ma quihuica, huan ma quihuica len pa tomin noje. Huan aqui hual amo quipía teposli pa moanalisli, ma quinamaca inahuas huan ma mocuhuili se. ");
INSERT INTO nclNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Quema, ma quichía yoje pampa annimitzilía monequi pa nejchihuilisi inon hual unca lajcuiluli nonahuac nehual pa iamal Dios ilajtuni. Huan yoje quijtúa hual unca lajcuiluli: “Quijtujque pampa yihual yec se lacal elehuis.” Quema, pampa ajsitihuala ilajco in tonali capa lamis mochías in lajtol hual quijtúa in hual yahui nechpanúa nehual. ");
INSERT INTO nclNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Huan in lanahuatinijmes quilijque: —Tata, nican cate ome teposlimes pa moanalisli. Jesús quinnanquilic: —Yajmo tilaquetzasi inahuac inon. ");
INSERT INTO nclNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Cuaquinon quisac Jesús pa Jerusalén, mohuicac pa in loma itoca Olivos, quinami quichihuaya lajlayúa. Huan quitocaloaya yihual imonextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ajsijque ca umpic, Jesús quinmilic: —Xiclajlanican Dios pa camo anmitztilanilis anmoyolo Satanás. Yihual quinequi pa yajmo annechneltocas. ");
INSERT INTO nclNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Mijcuanic Jesús capa yehuanten pa cayas huejquita quinami se tixcali lalasali. ");
INSERT INTO nclNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Nepa molancuacuetzac, quilajlaniaya Dios, quilic: —Tata, sinda ticnequi, xichquixti pa camo nipanus inon hual nía nipanu. Ma yoje, ma camo mochía quinami niquijtúa nel, jan ma mochía quinami tiquijtúa tehual. ");
INSERT INTO nclNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nesic ca yihual se ilanahuatini in cielo pa quichicahualtisquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Huan cataya panujtataya lacocoltilisli niman míac. Yojque quilajlaniaya Dios ca míac chicahualisli, huan ixicaya imijtonil chicuenta esli ixicatataya pan in lali. ");
INSERT INTO nclNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Cuaquinon moquetzac capa quilajlaniaya Dios, hualac capa cataloaya imonextilinijmes, quinmitac coxtataloaya pampa quincocujtataya inminyolo. ");
INSERT INTO nclNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Huan quinmilic: —¿Leca ancoxtica? Ximoquetzacan huan xiclajlanican Dios pa camo anmitztilanilis anmoyolo Satanás. ");
INSERT INTO nclNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ayamo lamic quinmilic inon, ajsiloaya lacalera huan in se imonextilini motocaya Judas, yihual se ca in doce, quinlaicanaya. Yihual ajsiaya pa quitenamiquisquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Huan Jesús quilic: —Judas, ¿tichtenamiquic nehual ilacal in cielo, pa yoje tiquinnextilisquiaya nolacocolinijmes capa nel? ");
INSERT INTO nclNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Quitajque imonextilinijmes len yahuiaya panu, quilijque: —Tata, ¿amo timoanasi ca in teposli pa moanalisli? ");
INSERT INTO nclNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Huan se ca yehuanten quitecuac ca iteposli itequipanujquil in tiopista hué, yojque quicotonilic se inacas pa ima cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesús calactiquisac capa moantataya, quilic: —Xijcahua, yajmo xicchía inon. Huan quisaluc inacas oc sejpa pa itzontecon, quipajtic. ");
INSERT INTO nclNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Cuaquín Jesús quinmilic yehuanten hual hualajque pa quiquitzquilosquiaya, cataloaya tiopistas huejué huan in piscales huan in oc sequin hueyente, quinmilic: —¿Anhualaya pa annechquitzquisquiaya ca teposlimes pa moanalisli huan cuahuimes yoje quinami nicataya se laxtequini? ");
INSERT INTO nclNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mojmosta nicataya ca amhuanten pin tiopan hué, huan amo annechquitzquic. Ma yoje, in unca quiman Dios anmitzmacahuiltitica pa anquichías hual len anquinequi. Noje Dios quimacac Satanás in lahueliltilisli pa axan in layúa, yihual Satanás huelitía capa laticumac. ");
INSERT INTO nclNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Yoje quiquitzquijque Jesús, quihuicatiajque, quihuicajque pa ichan in tiopista hué. Huan quintocaya Pedro huejca inmintepotzcon. ");
INSERT INTO nclNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nepa pa ilajcotiyan ichan in tiopista hué quipitzajque se tixuxli. Molalijque pa itenco in tixuxli, huan Pedro moqueztataya ca yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nepa cataya se tequipanujquil sihual, quitac Pedro moqueztataya, quilahuiaya in tixuxli. Huan yihual mocahuac quiztica jan sejpa, quinmilic: —In se noje cataya ca Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedro quijtuc pampa no, quilic: —Sihual, amo niquiximati aqui yihual. ");
INSERT INTO nclNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Panuc nadita huan oc se lacal quitac Pedro, quilic: —Tehual noje tiunca se ca yehuanten. Huan Pedro quinanquilic: —Lacal, amo niunca se ca yihual ilacames. ");
INSERT INTO nclNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Panuc quinami se hora quiman quijtuc inon, huan oc se lacal pehuac quijtuc pampa neli, quilic: —Neli in se noje cataya ca yihual, pampa yihual noje unca se galileteco. ");
INSERT INTO nclNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Huan Pedro quinanquilic: —Lacal, amo nicmati len tiquijtutica. Huan jan ajnaxcan, ayamo laquisac lajtutataya Pedro, xahuanic se gallo. ");
INSERT INTO nclNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Huan momalinac in Tata Jesús, quitac Pedro. Cuaquinon Pedro quijnamiquic len quilic in Tata Jesús, quinami yihual quilic: “Axan layúa ayamo xahuanis se gallo huan tiquijtus ca ye lajtulisli pampa amo tichiximati nehual.” ");
INSERT INTO nclNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pampín quisac Pedro pa quiahuac, pehuac chocac chicahuac. ");
INSERT INTO nclNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Huan in lacames hual quiquitzquijque Jesús quihuitzquilijtinemiloaya, quihuitectinemiloaya. ");
INSERT INTO nclNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Quilpijque se dango pa iixtololojmes huan quilajlantinemiloaya, quililoaya: —¡Xilajtu ca Dios ilahueliltilisli, xitechili aqui mitztecuac! ");
INSERT INTO nclNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Huan ca míac oc sequin lajtomes quihuejuecaltitinemiloaya. ");
INSERT INTO nclNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Quiman lanesic, monechicujque inminhueyente in judíos. Yehuanten cataloaya in tiopistas huejué huan ilamaxtinijmes inminlajtol in judíos. Quihuicajque Jesús capa cataloaya lanechiculi yehuanten inminLanechiculisli Hué in tiopistas huan in lamaxtinijmes. ");
INSERT INTO nclNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nepa quilijque: —Sinda tehual tiunca in Cristo hual Dios mitztilanic, cuaquín xitechili. ");
INSERT INTO nclNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Huan Jesús quinmilic: —Sinda annimitzilía, neli amo anquineltocas. Huan sinda annimitzlajlanis len anquinequi anquijtúa quiman annechlajlanía sinda niunca in Cristo, neli unca da amo annechnanquilis. ");
INSERT INTO nclNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ma yoje, axan huan pa mosta nehual ilacal in cielo nicayas nihuelitijtica ca Dios ilahueliltilisli, nepa nimolalis pa ima cuali Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Cuaquín moxtin quilajlanijque: —Tehual nuso, ¿tiunca ixolol Dios? Jesús quinnanquilic: —Jo quema, nehual niunca quinami anquijtúa. ");
INSERT INTO nclNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Yehuanten quijtujque: —¡Yajmo monequi pa tilajlajlantinemisi, pampa tehuanten nojen tijcaquije quinami quijtuc ca icamac! ");
INSERT INTO nclNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Cuaquinon moquetzajque moxtin hual cataloaya nepa pin Lanechiculisli Hué, quihuicajque Jesús capa cataya in gobernador romano itocaya Pilato. ");
INSERT INTO nclNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nepa pehualoaya quipitzililo tixuxli, quimotexpahuililoaya, quilijque: —Tilajlanije huan ticmatije pampa in se quinequiaya quipehualti moanalisli ca in lacames pa tolali. Quinequiaya quitzacuili pa camo quilaxlahuilosquiaya ilapixcalisli in tomin pa in hué César. Noje quijtúa pampa yihual ihuían unca se hué hual itoca Cristo. ");
INSERT INTO nclNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Cuaquín Pilato quilajlanic Jesús, quilic: —¿Tehual tiunca inminhué in judíos? Jesús quinanquilic: —Jo quema, unca tehual hual tiquijtúa. ");
INSERT INTO nclNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Huan quinmilic Pilato in tiopistas huejué huan in lacalera, quinmilic: —Amo niquitilía nindeno amo cuali ca in lacal. ");
INSERT INTO nclNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ma yoje, yehuanten quijtuloaya pampa neli cataya yojque, quipitzililoaya tixuxli, quilijque: —Techmocualantilía tehuanten in judíos pa cuajnesi timoanasi. Yihual lamaxtitinemi pa mochi in lalticpan Judea, pehuaya pin lalticpan Galilea, lamaxtitihualaya ca niquic. ");
INSERT INTO nclNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Quicaquic inon Pilato, quilajlanic sinda Jesús yec galileteco. ");
INSERT INTO nclNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Huan quimatic pampa quema, yuliaya Jesús pa Galilea capa in hué Herodes huelitiaya. Cuaquín quitilanic Jesús capa Herodes, yihual quipiaya lahueliltilisli ca galiletecos. Huan pa innojen tonalijmes, Herodes cataya pa Jerusalén pa in fiesta (ilhuil). ");
INSERT INTO nclNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Yoje, quiman Herodes quitac Jesús, quipiaya míac paquilisli, pampa quipiaya míac tonalijmes quinequiaya quita. Cataya pampa yihual quincaquiaya moxtin laquetzaloaya inahuac mochi hual quichihuaya yihual. Huan quichiaya pa quitasquiaya len hual Jesús quichiasquiaya, quinequiaya quita len lanextilisli hual quimahuisultisquiaya Herodes ca lamajtilisli. ");
INSERT INTO nclNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Pampín Herodes quilajlaniaya Jesús ca míac lajtomes. Ma yoje, Jesús amo quinanquilic nindeno. ");
INSERT INTO nclNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Moquetzaloaya in tiopistas huejué huan ilamaxtinijmes inminlajtol hual quinnextililo in judíos quinami quimolancuacuetzililo Dios, huan quimotexpahuililoaya Jesús chicahuac. ");
INSERT INTO nclNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Jan yojque, quixijxicujque Herodes huan moxtin yehuanten hual cataloaya ca yihual, quihuitzquililoaya. Cuaquinon Herodes quilaquentic Jesús ca se nahuas cahuanquil calica molaquentilo huejueyenten. Cuaquín quitilanic oc sejpa capa cataya Pilato. ");
INSERT INTO nclNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Huan pampín pa in tonali pehualoaya moixtocalo Herodes huan Pilato, mas que amo moixtocanijme quiman ayamo panuc inon. ");
INSERT INTO nclNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Cuaquinon quinahuatic Pilato pa monechiculosquiaya in tiopistas huejué huan yehuanten hual quipialoaya lahueliltilisli huan in lacalera. ");
INSERT INTO nclNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Quinmilic: —Annechualiquilic in lacal, annechilijtataya pampa yihual quinmocualantiliaya in judíos pa quipehualtilosquiaya moanalisli ca in romanos. Huan xiquitacan, niclajlanic anmolaixpan huan amo niquitilic nindeno amo cuali ca in lacal quinami inon hual anquimotexpahuilijtica. ");
INSERT INTO nclNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Huan Herodes noje amo quitilic nindeno ca yihual pampa nechtilanilic oc sejpa. Huan xiquitacan, yihual amo quichíac nindeno. Pampín, quinami quijtúa in lajtol, amo huil tilatilanilo pa yes lamictili. ");
INSERT INTO nclNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Yoje, nilatilanis pa quihuitequisi noguaches ca in lahuitequiloni ca teposli, cuaquín nicmacahuas. ");
INSERT INTO nclNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Inon quinmilic Pilato pampa mochi xihuil cataya ilachihualisli in huelitinijmes romanos pa quinmacahuililosquiaya in lacalera pa nepa in fiesta (ilhuil) se hual cataya latzacuali ca in lacames lailpili. ");
INSERT INTO nclNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Huan tzajtzijque yehuanten moxtin, quilijque: —¡Xicmicti in se, huan xitechmacahuili Barrabás! ");
INSERT INTO nclNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","In Barrabás yec se hual quincualantic in judíos pin caltilan hué. Quinequiaya quipehualti se moanalisli. Yihual noje quimictic se lacal, pampín quitzacuajque pa calijtic. ");
INSERT INTO nclNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Oc sejpa quinnotzac Pilato yehuanten, quinmilic pampa quinequiaya quimacahua Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ma yoje, yehuanten quitzajtzilijtinemiloaya yihual, quililoaya: —¡Xicpilu pan se cuahuil, xicpilu pan se cuahuil! ");
INSERT INTO nclNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Axan, huan ca inon cataya ye lanotzalisli, Pilato quinmilic: —¿Leca? ¿Len amo cuali quichíac in lacal? Amo niquitilic nindeno yihual hual monotza pa yes lamictili, huan amo huil nilatilanía pa quimictisi. Pampín, nilatilanis pa quihuitequisi, cuaquinon nicmacahuas. ");
INSERT INTO nclNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ma yoje, yehuanten amo mocahualoaya pa quililosquiaya ca lajtomes chijchicahuac pa quipilulosquiaya pan se cuahuil, huan ca in míac tzajtzilisli, yojque quisulahuajque Pilato. ");
INSERT INTO nclNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pampín yihual latilanic pa Jesús yesquiaya lamictili quinami quitemachiloaya yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Cuaquinon, Pilato latilanic pa quimacahualosquiaya yihual hual quitzacuajque pin calijtic, yihual hual quinequiaya quipehualti moanalisli huan hual quimictic se lacal. Quema, yihual quimacahuajque quinami in judíos quitemachiloaya. Huan Jesús, yihual Pilato temacac ca yehuanten pa quichihuililosquiaya quinami quinequiloaya. ");
INSERT INTO nclNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Huan nepa capa quihuicatiahuiloaya Jesús, quiquitzquijque Simón, yihual se lacal hual lacatic pin lali itoca Cirene. Cataya in Simón pa icuajmili huan axan mocuectataya pa Jerusalén. Quimamiltijque in Simón ca icuahuil Jesús pa quihuicatiasquiaya itepotzcon Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Huan quitocaloaya lacalera, cataloaya yehuanten hual chantiloaya pa Jerusalén. Ca yehuanten cataloaya sihuames hual motecuilijtiahuiloaya itzindan inminquixlan huan quichoquilijtiahuiloaya Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Momalinac Jesús ca yehuanten, quinmilic: —Amhuanten sihuames hual anchanti nican Jerusalén, ximocahuacan pa annejchoquilis. Monequi pa anmochoquilis amhuanten. Huan xiquinchoquilican anmoxolomes, pampa xiquitacan: ");
INSERT INTO nclNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ajsitihualasi in tonalijmes hual moxtin quilisi: “Cate ca niman míac paquilisli yehuanten hual amo yalo quinpialo xolomes, huan hual amo quiman quilacatiltije xolomes, yehuanten hual amo quiman quinchichiltije xolomes”, quilisi. ");
INSERT INTO nclNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Cuaquín pehuasi quijtusi: “¡Ma huetzican topan in lomas! ¡Ma techpachucan in lomitas pa timiquisi!”, quijtusi. ");
INSERT INTO nclNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Quema, pampa sinda nejchihuililo yoje in romanos nehual hual amo nicpía laijlaculisli, cuaquín ¡quinami amo yalo anmitzpitzililo tixuxli amhuanten hual anquinpía míac laijlaculisli! In cuahuil huaquic chichinahuía ca míac milinilisli, amo yoje chichinahuía in cuahuil xuxuhuic. ");
INSERT INTO nclNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Quinhuicaloaya noje oc sequin ome lacames pa quinpilulosquiaya ca Jesús, in omenten yeje laixtequinijmes huan lamictinijmes. ");
INSERT INTO nclNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Huan ajsijque pa capa itoca Tzontecomal, nepa quipilujque Jesús pan in cuahuil huan noje quinpilujque in oc sequin omenten pan inmincuahuimes, se pa ima cuali Jesús huan in oc se pa ima amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Huan Jesús quilic: —Tata, xiquinpujpuhua yehuanten hual nechmictiticate, pampa amo quimatilo len quichijticate. In guaches moxiluilijque itzotzomajli Jesús huan pa quichihualosquiaya inon, quicuixtijque cuajtzindis, huan quinlasajque in cuajtzindis quinami yoje pa quimatilosquiaya aqui yahuiaya cana in tzotzomajli hual nepa quilalijque pa quipiasquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Huan mocahuajque lachixtataloaya in lacalera. In huejueyenten quihuitzquililoaya Jesús, quilijque: —Oc sequin yihual quinquixtic pin miquilisli. Axcan, ma moquixti yihual pin imiquilisli sinda in se unca iCristo Dios hual Dios quitilanic. ");
INSERT INTO nclNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Huan quihuitzquilijque in guaches noje, ajsijque, quichihuajque quinami quinequiloaya quicuniltilo iayo uva xocuc. ");
INSERT INTO nclNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Quilijque: —Sinda tiunca inminhué in judíos, cuaquín ximoquixti pin momiquilisli tehual. ");
INSERT INTO nclNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Huan cataya se amal ca lajcuilulisli pani pin cuahuil, quijtuc: “IN UNCA INMINHUÉ IN JUDÍOS.” Huan cataya lajcuiluli ca lajtol latín huan ca lajtol griego huan ca lajtol hebreo. ");
INSERT INTO nclNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Cuaquinon, se laxtequini hual pilujtataya ca Jesús, quihuejuecaltic Jesús, quilic: —¿Amo tiunca in Cristo? Ximoquixti pin momiquilisli huan xitechquixti pin tomiquilisli tehuanten. ");
INSERT INTO nclNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Quinanquilic in oc se laxtequini, cajuac, quilic: —¿Amo timomajtía je nadita ilaixpan Dios, mas que ticmati tía timiqui tehual noje? ");
INSERT INTO nclNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tehuanten tialo timiquilo pampa techahuilúa, ticchihuaje len amo cuajcuali huan tipanulo in lacocoltilisli. Huan in se amo quiman quichíac len amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Cuaquinon quilic: —Jesús, xichijnamiqui pan in tonali tihualas oc sejpa pa tihuelitis. ");
INSERT INTO nclNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Huan Jesús quilic: —Neli nimitzilía, axan ticayas ca nehual pa iparaiso Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Cataya quinami lacualispan huan laticumactic pa mochi in lalticpan, mocahuac laticumac pa ye pa tiolac, ");
INSERT INTO nclNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","amo lahuiaya in tonali. Huan in tzotzomajli telahuazo hual pilujtataya lajco pa in lasojli calijtic huan in niman lasojli calijtic pin tiopan hué, tzayanic pa lajco, mochíac ome. ");
INSERT INTO nclNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Huan tzajtzic Jesús ca lajtol chicahuac, quilic: —Tata, nimotemaca ca noyulilisli pa tichlachilis. Quiman quijtuc Jesús inon, jan yoje miquic. ");
INSERT INTO nclNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nepa cataya in laicanani romano hual yec inminteco cien guaches. Quitac yihual len panuc, quijtuc lajtomes huejué huan cuajcuali pa Dios, quilic: —Neli in lacal yec se lacal cuali, amo quichíac len amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Huan moxtin in lacalera hual hualajque pa quitalosquiaya in lamictilisli, quitajque len panuc, pehualoaya motecuililo pa itzindan inminquixlan huan pehualoaya mocuepalo pa Jerusalén. ");
INSERT INTO nclNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ma yoje, mocahuajque nepa moqueztataloaya huejquita yehuanten hual quiximatiloaya Jesús. Innojen sihuames noje hual quitocaloaya Jesús quiman quisaya pin lalticpan Galilea cataloaya quiztataloaya mochi inon hual panuc. ");
INSERT INTO nclNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Huan nepa cataya se lacal itoca José. Yihual yec se hué ca in Lanechiculisli Hué, yec se lacal cuali. Dios quitilic cuali iyolo José, pampa José yuliaya quinami Dios quinequi pa moxtin yulisi. ");
INSERT INTO nclNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Yihual amo cataya ca in lajtulisli hual quichihuajque in oc sequin hual yeje in Lanechiculisli Hué hual quimotexpahuililoaya Jesús pa quimictilosquiaya. Yihual yuliaya pa se caltilan itoca Arimatea, unca pa Judea inminlalticpan in judíos. In José quichiaya in tonali quiman huelitisquiaya Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yihual uyac ilaixpan Pilato, quitemachic pa yihual quimacahuiltisquiaya quihuica imijquil Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Cuaquinon uyac quitemuhuilic, quiquixtic pin cuahuil, quiliaruc ca se tzotzomajli yancuic, huan quilalic pan se coyunquil lahuajuanali pin tel, nepa ayamo quilalijque se mijquil. ");
INSERT INTO nclNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","In tonali cataya se hué tonali pa in inminilhuil (fiesta), itocac in tonali pa lachijchihualisli pampa mostatica yahuiaya ye itonali niman hué inminfiesta in judíos. Axcan pejtihualaya ajsi in itonali in ilhuil. ");
INSERT INTO nclNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Huan quitocatiahuiloaya José in sihuames huejquita, yehuanten hual quisajque pa Galilea ca Jesús. Quitajque in coyunquil (ostul) huan quitajque quinami quilalijque ca laijtic imijquil Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Cuaquinon mocuepajque pa inminchan huan quichijchihuajque len ca chahuac hual ajuíac calica quixahuililosquiaya in mijquil. Cuaquín ajsic in tonali hual mosehuilo in judíos huan mosehuiloaya in sihuames quinami quijtúa inminlajtol in judíos. ");
INSERT INTO nclNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Huan mostatica, cataya pa laxpoyahuita pa in tonali hual quipehualtía in chicome, hualajque in sihuames pa in coyunquil (ostul) capa quilalijque imijquil Jesús. Quihualicaloaya inon hual ajuíac hual quichijchihuajque. ");
INSERT INTO nclNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ajsijque, huan quitajque in tixcali hual cataya chicuenta se layahualujquil, quitajque laijcuanili in tixcali capa quitzactataya in coyunquil (ostul). ");
INSERT INTO nclNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Calaquijque, huan amo quitajque imijquil in Tata Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Yojque, nepa cataloaya, amo quimatiloaya len quijtulosquiaya. Cuaquinon nestiquisajque ome lacames, cataloaya lalaquentili ca nahuajmes hual niman laixpelaloaya. ");
INSERT INTO nclNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Huan momajtijque in sihuames lachixtataloaya pan lali pampa in laixpelalisli quinmixpelaya pa inmixtololojmes. Innojen lacames quinlajlanijque in sihuames, quinmilijque: —¿Leca anquitemujtica nican pin mijquimes yihual hual yultica? ");
INSERT INTO nclNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Amo unca nican, axcan yultica oc sejpa. Xiquijnamiquican quinami anmitzilic inon pa innojen tonalijmes quiman ayamo anquisaya pa Galilea. ");
INSERT INTO nclNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Anmitzilic pampa monequiaya pa yihual ilacal in cielo yesquiaya latemacali ca lacames ejꞌelehuis. Yehuanten yahuiloaya quipilulo pan se cuahuil, huan quiman panuje ye tonalijmes, yihual yahuiaya yuli oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Cuaquinon quijnamiquijque len quinmilic Jesús. ");
INSERT INTO nclNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Quisaje pin coyunquil (ostul), uyajtiquisajque pa quimachiltilosquiaya in once lanahuatinijmes huan moxtin in oc sequin monextilinijmes mochi innojen hual panujque. ");
INSERT INTO nclNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Cataloaya María Magdalena, huan Juana huan María inantzin Jacobo huan in oc sequin sihuames ca yehuanten hual quinmilijque in lanahuatinijmes innojen lajtomes. ");
INSERT INTO nclNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Huan ca yehuanten in lanahuatinijmes nesiaya quinami in sihuames amo quimatiloaya len quijtutataloaya, pampa inon amo quineltocaloaya. ");
INSERT INTO nclNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ma yoje, moquetzac Pedro, molaluc pa in coyunquil, mopachuc quinmitac quinami in tzotzomajli cataya ihuían. Cuaquinon uyac Pedro ihuían, laijnamiquiaya pa quimatisquiaya len quinequiaya quijtu inon. ");
INSERT INTO nclNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Huan noje pan in tonali yahuiloaya ome imonextilinijmes Jesús pa se caltilan tipichin itoca Emaús. Pa ajsilosquiaya nepa, nejnemilosquiaya quinami once kilómetros pan in ojli hual quisac nepa Jerusalén. ");
INSERT INTO nclNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Yehuanten molaquetzilijtataloaya ca mochi innojen hual panujque. ");
INSERT INTO nclNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Huan cataloaya laqueztataloaya huan quijnamictataloaya mochi hual panuc, jan axcan hualaya inminahuac yihual Jesús capa yehuanten nejnentataloaya, pehuaya nejnemi ca yehuanten. Ma yoje, yehuanten amo quiximatiloaya Jesús, ");
INSERT INTO nclNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Dios quinchihuilic inmixtololojmes pa camo quislaculosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Huan Jesús quinmilic: —¿Len inon hual anmolaquetzilijtía capa annejnentía? Cuaquín yehuanten moquetzajque, lachixtataloaya quinami quincocujtataya inminyolo. ");
INSERT INTO nclNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Se ca in omenten motocaya Cleopas quinanquilic, quilajlanic: —¿Tehual tiunca se ca in míac judíos hual amo lacatije nican hual chantiticate pa Jerusalén pa ticayas pa in fiesta huan amo ticmati innojen lachihualisli hual panuje pa Jerusalén pan in tonalijmes? Sinda amo ticmati, cuaquín tiunca in se san hual amo quimati. ");
INSERT INTO nclNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Huan Jesús quinmilic: —Cuaquín, ¿len panuc? Yehuanten quilijque: —Unca in hual quipanuc Jesús in nazareteco. Yihual yec lacal hual lanextiliaya pampa yihual yec ilajtuni Dios. Yec se lajtuni hual quipiaya míac lahueliltilisli ca mochi len quichihuaya huan quijtuaya. Yoje quinextiliaya ilahueliltilisli ilaixpan Dios huan inminlaixpan moxtin lacames. ");
INSERT INTO nclNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ma yoje, totiopistas huejué huan yehuanten hual huelitilo ca tehuanten quitemacaje pa in huelitini romano pa yihual latilanisquiaya pa yesquiaya lamictili, huan quipiluje pan se cuahuil. ");
INSERT INTO nclNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Huan tehuanten ticchixtataloaya pampa cataya yihual hual yesquiaya in se hual yahuiaya laxlahui pa techquixtisquiaya moxtin tehuanten in israelitos pin topolehuilisli. Huan axan, ca mochi inon, quipía ye tonalijmes quiman quipanuc yihual inon. ");
INSERT INTO nclNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Huan unca oc se lajtol ca inon. Sequin sihuames ca tehuanten techmacajsije. Uyaje laxpoyahuita pa in coyunquil capa quilalije in mijquil. ");
INSERT INTO nclNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Amo quitaje in mijquil, quil. Ma yoje, techlamachiltitihualaje pampa quinmitaje chicuenta lanahuatinijmes hual quisaje pin cielo hual quinmilije pampa yuliaya oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Cuaquinon yaje sequin lacames ca tehuanten pa in coyunquil, quitaje mochi jan quinami techilije in sihuames. Ma yoje, yihual amo quitaje. ");
INSERT INTO nclNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Cuaquín Jesús quinmilic: —Amhuanten, ¡quinami amo anquimati! Anhuejcahua pa anquineltocas mochi inon hual quijtunijme Dios ilajtunijmes. ");
INSERT INTO nclNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Monequiaya pa panusquiaya in Cristo mochi inon, yoje laxlahuic pa mochi inminlaijlaculisli in lacames pin lalticpan. Cuaquinon pampa inon Dios quichíac niman hué, yahui quipía in Cristo pa imajma cuali pa huelitis. ");
INSERT INTO nclNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Huan pehuac quinmilic in hual quijcuiluc Moisés. Cuaquín quinmiliaya len quijtujque mochi oc sequin ilajtunijmes Dios. Quinmilic len quinequiaya quijtu mochi hual quijcuilujque pa quinmachiltilosquiaya in hual yahuiaya quipanu Cristo. ");
INSERT INTO nclNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Huan quiman ajsijque pa in cali ca capic yajtiahuiloaya, yihual Jesús quichíac quinami yahuiaya nejnentía pa ca yojque. ");
INSERT INTO nclNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Cuaquín yehuanten quilijque ca mochi inminyolo, quilijque: —Ximosehui ca tehuanten, axan unca tiolac huan layuajtitihuala. Yoje calaquic ca yehuanten pa mocahuasquiaya. ");
INSERT INTO nclNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Huan cataya nepa molalijtataya pa lacuasquiaya ca yehuanten, yihual canac in pan, quisehuic Dios, quilapanac in pan huan quinmacaya. ");
INSERT INTO nclNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Cuaquinon Dios quinlapulic in omenten inmixtololojmes huan quiximatijque Jesús. Huan jan axcan yajmo nesiaya Jesús ca yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Cuaquinon moilijque: —¿Amo ticpiaje míac paquilisli pa toyolo nepa pan ojli quiman yihual techmachiltitihualaya len quinequi quijtúa in hual unca lajcuiluli pa ilajtol Dios? ");
INSERT INTO nclNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Cuaquinon moquetzajque jan ajnaxcan, mocuectiquisaje pa Jerusalén huan quinmitajque in once lanahuatinijmes, cataloaya lanechiculi ca in oc sequin monextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Huan yehuanten quinmilijque in omenten: —Neli yultica oc sejpa in Tata huan Simón quitac. ");
INSERT INTO nclNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Cuaquinon in omenten quinlamachiltijque len quinpanuaya pan in ojli pa Emaús, quinmachiltijque quinami quiximatijque Jesús quiman quilapanac in pan. ");
INSERT INTO nclNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Molaquetzilijtataloaya pa momachiltilosquiaya mochi inon huan yihual Jesús nestiquisac lajco ca yehuanten capa cataloaya, quinmilic: —Ma mosehui anmoyolo. ");
INSERT INTO nclNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Yehuanten momajtitiquisajque huan mocahuajque momajtiticate, quijtujque pampa quiztataloaya se lamajtini. ");
INSERT INTO nclNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Huan Jesús quinmilic: —¿Leca anyuyucatica? Huan ¿pa len anlajtutica yoje pa anmoyolo? ");
INSERT INTO nclNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Xichitilican nomajmajuan huan nocxihuajmes, huan xicmatican pampa nehual niyultica. Xichquitzquican huan xiquitacan, pampa anquimati se lamajtini amo quinpía nacal huan umimes quinami anquita pampa nehual niquinpía. ");
INSERT INTO nclNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Quinmilic inon, quinnextilic icxihuajmes huan imajmajuan. ");
INSERT INTO nclNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Huan ayamo quineltocaloaya cataya Jesús pampa quipialoaya niman míac paquilisli huan pampa mocahualoaya quiztataloaya Jesús ca lamajtilisli. Huan Jesús quinmilic: —¿Amo anquipía nican len pa nijcuas? ");
INSERT INTO nclNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Cuaquinon quimacajque se lajco michin lahuatzali huan se xuchiyo néculi. ");
INSERT INTO nclNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yihual canac huan quicuac inminlaixpan. ");
INSERT INTO nclNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Cuaquinon quinmilic: —Ayamo annimitzcahuac quiman annimitzlaquetziliaya in lajtomes pa annimitznextilisquiaya quinami monequiaya pa mochihuasquiaya mochi innojen lajtomes hual cate lajcuiluli pa ilajtol Dios hual quijtuc pan ipampa Moisés. Huan yoje quijtuc pa inminamames ilajtunijmes Dios huan pa iamal in cantaditas (cuicames) Salmos. Annimitzilic mochi in lajtomes hual cate lajcuiluli pa ilajtol Dios nonahuac nehual. ");
INSERT INTO nclNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Cuaquinon quinmachiltic len quinequilo quijtulo innojen lajtomes hual cate lajcuiluli pa ilajtol Dios. ");
INSERT INTO nclNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Huan quinmilic: —Yoje unca lajcuiluli. Monequiaya pa nipanusquiaya míac lacocoltilisli nehual in Cristo, huan monequiaya pa nimiquis huan pa niyulis oc sejpa quiman panuje ye tonalijmes. ");
INSERT INTO nclNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Axan, pampa nicchíac mochi inon, in unca ilahueliltilisli notoca. Ca in lahueliltilisli, monequi pa anquinlamachiltis moxtin pin lalticpan pampa quipialo pa quipalasi inminyolo pa laijnamiquisi quinami Dios quinequi. Yoje Dios huil quinpujpuhuilis inminlaijlaculisli. Xipehuacan xicchihuacan inon pa Jerusalén. ");
INSERT INTO nclNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Amhuanten anunca aquinojen hual anquitac panuje mochi inon hual nechpanuc. ");
INSERT INTO nclNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Huan xiquitacan. Nehual nía annimitztilanilía in se hual noTajtzin neli quijtuc pampa yahuiaya anmitzmaca. Huan amhuanten, ximocahuacan nican pa Jerusalén. Amo huejcahuas ajsis in tonali quiman yihual anmitzmacas ilahueliltilisli yihual hual quisas pin cielo pa hualas ca amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Cuaquín quinhuicac Jesús yehuanten capa cataloaya amo huejca pa quiahuac Betania. Cuaquinon quinmajcoquic imajmajuan huan quitemachic Dios pa quinchihuilisquiaya cuali. ");
INSERT INTO nclNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Huan quiman cataya quilajlantataya Dios pa yehuanten, mohuicac lejcutataya pa pani pin cielo (ilhuicac). ");
INSERT INTO nclNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Yehuanten quimolancuacuetzilijque, cuaquinon mocuepajque pa Jerusalén ca paquilisli niman hué. ");
INSERT INTO nclNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Huan cataloaya mojmosta pin tiopan hué, quijtutataloaya lajtomes niman huejué huan cuajcuali pa Dios. Yojque ma ye.");
INSERT INTO nclNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Niman pa yina Dios quipehualtic mochi hual unca. Huan noje pa yina yuliaya in Se hual quijtuc in lajtol calica quipehualtic mochi. Yihual cataya umpa capa ayamo pehuac mochi. Huan cataya yihual hual technextilic quinami unca Dios, yihual hual quijtuc Dios ilajtol. Cataloaya huan Dios in Se, huan in Se yec Dios. ");
INSERT INTO nclNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Quema, huan Dios cataloaya in Se hual quijtuc Dios ilajtol, huan Dios cataloaya umpa capa ayamo pehuac mochi. ");
INSERT INTO nclNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Yihual quinchíac mochi, amo yec lachihuali nindeno sinda amo yeje innojen hual yihual quinchíac. ");
INSERT INTO nclNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yihual yec aqui hual quiyuliltía in hual quichíac. Huan in yulilisli calica yihual quiyuliltía unca in hual technextilía neli quinami huil tiquiximatilo, unca quinami techlahuilía toyolo timoxtin. ");
INSERT INTO nclNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","In yulilisli calica techyuliltía unca quinami lahuilisli hual lahui capa laticumac. Huan in laticumactilisli amo quiman huil quisehuía in lahuilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Cataya se lacal hual Dios quitilanic pa lajtus. Yihual motocaya Juan Lacuayatequini. ");
INSERT INTO nclNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Hualac in Juan pa lamachiltis neli quinami se hual amo lacuajcuamana inahuac Dios ilajtol. Hualac pa lajtus neli inahuac Jesucristo, in Se hual techlahuía toyolo pa technextilis quinami neli huil tiquiximatilo Dios. Dios quitilanic Juan pa yojque moxtin quilalilisi inminlaneltocalisli ca in Se huan pa quineltocasi pan ipampa len quinmilic Juan. ");
INSERT INTO nclNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","In Juan amo yec yihual hual techyuliltía. Juan yec hual hualac pa lajtus neli inahuac in se hual hualaya pa techyuliltis. ");
INSERT INTO nclNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Huan in se yec yihual hual neli quiyuliltía mochi lacal pa quipías lahuilisli melahuac pa iyolo. Huan hualaya pin lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yihual cataya pin lalticpan, huan pan ipampa yihual in lalticpan yec lachihuali. Ma yoje, yehuanten pin lalticpan amo quimatije pampa cataya yihual hual quichíac mochi. ");
INSERT INTO nclNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Hualac pa ilali hual yihual quichíac huan in míac ca yehuanten hual chantiloaya pa ilali amo quinequije quinamiquije. ");
INSERT INTO nclNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ma yoje, cataloaya sequin hual quema, quinequije quinamiquije pa mochihualosquiaya icnían. Huan yehuanten yihual quinmacac pa yes inminyaxca pa mochihuasi Dios ixolomes. Quema, yehuanten yeje hual aqui quineltocaloaya yihual pampa quimatije yihual quisac capa Dios. ");
INSERT INTO nclNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Yoje lacatije quinami Dios ixolomes. Huan mas que lacatije quinami Dios ixolomes, amo cataya yoje quinami lacatilo pan lalticpan. Amo cataya quinami lacati se quipixtica itajtzin iesli huan inantzin iesli. Huan amo cataya quinami lacati se pampa oc se icuerpo quinequi monipanúa ca oc se pa lacatis se pan ipampa se lacal huan se sihual. Huan amo cataya quinami lacati se pampa in lacames quinequije pa lacatis in se. No, cataya quinami lacati se pampa Dios, yoje quinami san yihual Dios quimati. ");
INSERT INTO nclNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Huan yihual hual technextilic quinami unca Dios mochíac lacal quinami tehuanten huan chantini capa tehuanten. Huan tehuanten tiquitaloaya quinami quipiaya Dios ichicahualisli hué huan ilaixpelalisli hué huan cualtichin hual techlamahuisultiaya ca lamajtilisli. Yihual quipiaya in chicahualisli hué quinami monequi pa quipías se hual unca ixolol in Tata Dios, hual unca in se xolol san hual quipía Dios. Huan ca in míac chicahualisli hual quipía, tehuanten tiquitaloaya quinami yihual quinchihuiliaya moxtin míac lachihualisli cuali huan amo mocahua pa quijtus in hual unca melahuac huan neli. ");
INSERT INTO nclNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan Lacuayatequini lajtuc neli inahuac yihual, huan unca quinami axan tijcactialo ilajtol hual quijtuaya chicahuac: —Annimitzlaquetzilic inahuac quiman yes nel nicayas niclantías notequipanulisli. Hualas se hual monotza niman míac huan nehual amo nimonotza nindeno. Unca pampa yihual yulini quiman nehual ayamo nipehuac niyulic. Yihual unca niman hué huan nehual amo nihué —yoje quijtuc Juan Lacuayatequini. ");
INSERT INTO nclNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tehuanten imonextilinijmes Jesucristo ticanilije yihual se ilajquito in niman míac lachihualisli cuali hual quipía. Quema, huan amo timocahuasi pa ticanilisi inon. ");
INSERT INTO nclNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisés pa yina quinmilic Dios ilajtol inahuac mochi hual ticpialoaya pa ticchihuasi tehuanten in israelitos. In cataya se lapalehuilisli. Ma yoje, hualac Jesucristo, yihual technextilic in cuali niman hué hual san Dios huil tejchihuilía. Huan technextilic inon hual unca melahuac inahuac Dios, technextilic quinami Dios technequi niman míac. ");
INSERT INTO nclNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Huan mas que amaqui amo quiman quitac Dios, ma yoje Dios ixolol unca yihual hual techlamachiltic quinami unca Dios. Yihual in se xolol hual Dios quipía huan yihual quinami Dios. Yihual unca inahuac totajtzin Dios, huan quiximati mochi inahuac yihual huan quilasojla mochi inahuac yihual. ");
INSERT INTO nclNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yojque inminhuejueyenten in judíos quintilanilije capa Juan tiopistas huan inminlapalehuinijmes in levitas. Quintilanije quistataloaya pa Jerusalén pa quilajlanisi, quilije: —¿Len lahueliltilisli ticanac? ");
INSERT INTO nclNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Huan inon unca len Juan quijtuc neli, quinmilic len quimatic pa iyolo. Amo quinmilic da amo quimatic, jan quinmilic len quimatic san, quinmilic: —Nehual amo in Cristo hual Dios techtilanilía. ");
INSERT INTO nclNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Cuaquinon quilajlanije: —Axcan, ¿len lahueliltilisli ticpía? ¿Ilahueliltilisli Elías? ¿Tehual Elías? Huan quinmilic: —Amo niunca. Tel ¿tiunca in se hual yes Dios ilajtuni hual yahui huala? Huan Juan quinnanquilic: —Nehual amo niunca. ");
INSERT INTO nclNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Cuaquinon quilije: —¿Aqui tehual, nuso? Pa yoje tiquinmachiltisi yehuanten hual techtilanije ca tehual. ¿Len tía titechili monahuac? ");
INSERT INTO nclNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Quinmilic: —Dios ilajtuni hual motocani Isaías quijtuc pa yina inahuac se hual ilajtol mocaquis tzajtzitica capa amaqui chanti, huan in lajtol quijtúa: “Xicchijchihuacan in ojli capa yahui panúa in Tata.” Inon unca hual quijtuc pa yina Isaías. Huan nehual jan yoje annimitzilijtica pa anmochijchías pampa yahui panúa capa amhuanten in Tata. Annimitzilijtica inon jan quinami Isaías quijtuc pa yina pampa nehual niahuiaya annimitzili. ");
INSERT INTO nclNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Yehuanten in tiopistas huan inminlapalehuinijmes in levitas hual cataloaya latilanili capa Juan, yehuanten yeje ca in lacames judíos hual quineltocaloaya inminlamaxtilisli in lacames hual motocaloaya fariseos. ");
INSERT INTO nclNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Huan quilajlanije quilijticate: —Cuaquinon, ¿leca tilacuayatequía sinda tehual amo in Cristo huan tel amo Elías huan tel amo in lajtuni? ");
INSERT INTO nclNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan quinnanquilic: —Nehual nilacuayatequía ca al. Ma yoje, ca amhuanten moqueztica se hual amo anquiximati. Yihual pehuas quichías in hual Dios quitilanic pa quichías quiman yes nilaquisas ca in hual Dios nechtilanic pa nicchías nehual. Yihual anmitzlacuayatequis ca in Espíritu Santo hual ilacuayatequilisli unca quinami tixuxli. ");
INSERT INTO nclNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Huan nehual amo nimonotza pa nictequipanuilis jan se nadita, ma niquijtu, amo nimonotza pa nictequipanuilis quinami se itequipanujquil quitomilía ilacsames iteco. ");
INSERT INTO nclNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Inon panuc pin caltilan itoca Betábara hual unca ca yojque itenco (analco) in atenco hué Jordán capa Juan Lacuayatequini lacuayatectataya. ");
INSERT INTO nclNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mostatica quitaya Juan Jesús hualatataya capa yihual, huan Juan quijtuc: —Xiquitacan. Nepa unca in se hual Dios quilalía quinami huendi, yihual unca Dios iBorrego. Pan ipampa yihual Dios quinquixtilis in lacames mochi inminlaijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","In se unca yihual hual annimitzlaquetziliaya nepa capa niquijtuc: “Monotza niman hué yihual hual hualas pin tonalijmes quiman nilantica ca notequipanulisli. Huan nehual amo nimonotza len pampa yihual yultataya quiman nehual ayamo niyuliaya.” ");
INSERT INTO nclNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Huan nehual amo nicmatiaya yihual yec hual aqui ticchixtataloaya pa hualas. Ma yoje monequi pa yehuanten in israelitos quimatisi pampa axan hualac. Pampa inon nilacuayatectihualaya ca al pa quiximatilosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Huan oc sejpa Juan lajtuc neli, quijtutica: —Niquitac temujtica pin ilhuicac (in cielo) in Espíritu Santo, nesic quinami se huilol. Temuaya huan ajsic pani capa yihual, nepa mocahuac. ");
INSERT INTO nclNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Huan quiman ayamo niquitac panuc inon, nehual amo nicmatic yihual yec hual aqui ticchialoaya. Ma yoje, Dios nechtilanic pa nilacuayatequis ca al huan yihual nechilic: “Ca yihual capa tiquitas temujtihualas in Espíritu Santo huan ca in se mocajtica, cuaquín in se yes hual aqui lacuayatequía ca in Espíritu Santo.” ");
INSERT INTO nclNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Huan niquitac huan axan niquijtúa neli in se unca Dios iXolol. ");
INSERT INTO nclNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mostatica oc sejpa moqueztataya Juan ca ome imonextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nepa Juan quitac Jesús panujtiahuiaya. Mocahuac quiztataya Juan, cuaquín quinmilic: —Xiquitacan. Umpa unca Dios iBorreguito. ");
INSERT INTO nclNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Quicaquije len quinmilic Juan in omenten imonextilinijmes huan quitocaje Jesús. ");
INSERT INTO nclNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Momalinac Jesús, quinmitac quitocatihualaloaya, quinmilic: —¿Len anquitemujtihuala? Yehuanten quilije: —Rabí, ¿capa tichanti pa yoje timitzpaxaluilisi? (Rabí quinequi quijtúa Lamaxtini.) ");
INSERT INTO nclNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Quinmilic: —Xihualacan huan anquitas. Cuaquinon uyaje huan quitaje capa chantiaya, mocahuaje ca yihual in semilhuil, cataya quinami nahui horas pa tiolac. ");
INSERT INTO nclNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Huan Andrés cataya se ca in omenten hual quicaquije len quijtuc Juan Lacuayatequini huan cuaquín quitocaje Jesús. Andrés yec icni Simón Pedro. ");
INSERT INTO nclNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Cuaquín, in Andrés amo huejcahuac uyac quitemuc icni Simón huan umpa capa quitac, quilic: —Tilamije ticmatije pampa axan unca in Mesías pin lalticpan, tilamije tiquitaje. (Mesías quinequi quijtúa Cristo, yihual hual Dios quilajtultic pa huelitis.) ");
INSERT INTO nclNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andrés quihualicac Simón capa cataya Jesús. Huan umpa capa Jesús quitac Simón, mocahuac quiztica, quilic: —Tel timotoca Simón tiꞌixól Jonás. Mitztocayaltisi Cefas. (Cefas quinequi quijtúa Pedro o tixcali.) ");
INSERT INTO nclNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mostatica quinequiaya quisa Jesús capa chantiaya, quinequiaya yahui pa in lalticpan Galilea. Quitac Felipe huan quilic: —Xichtoca. ");
INSERT INTO nclNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Chantiaya Felipe pin caltilan Betsaida, capa chantiloaya noje Andrés huan Pedro. ");
INSERT INTO nclNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Uyac Felipe, quitemuc huan quitac Natanaél, quilic: —Tiquitaje yihual hual aqui quijcuiluc Moisés pa iamal in lajtol pa tehuanten in israelitos, noje quijcuiluje inahuac yihual Dios ilajtunijmes. Yihual Jesús ixolol José, yihual quisac pin caltilan Nazaret. ");
INSERT INTO nclNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaél quilic: —Da amo unca len cuali hual quisac pa Nazaret. Felipe quilic: —Xihuala xiquita. ");
INSERT INTO nclNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesús quitac Natanaél hualac capa yihual, huan quijtuc, quilic: —Xiquita. Nepa unca se israelito melác. Amo quimati lacuajcuamana, amo unca se nadita lacuajcuamanalisli ca yihual. ");
INSERT INTO nclNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaél quilic: —¿Quinami tichiximati? ¿Capa tichiximatic? Quinanquilic Jesús: —Ayamo mitznotzac Felipe huan nicmatic timolalijtataya itzindan in amacuál tipichin. Unca jan quinami nimitzitac nepa. ");
INSERT INTO nclNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaél quinanquilic: —Rabí, tehual Dios iXolol, tehual ihué Israel. ");
INSERT INTO nclNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Quinanquilic Jesús quilijtica: —Nimitzilic quinami nimitzitac itzindan in amacuál tipichin, huan ¿pampa inon tichneltoca? Inon amo lachihualisli hué quinami innojen míac huéjue hual tiquinmitas pa tonalijmes hual yalo ajsilo. ");
INSERT INTO nclNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Huan quilic: —Annimitzilía neli inon. Anquitas lapujtica in cielo huan anquinmitas Dios ilanahuatinijmes pin cielo (ilhuicac) lejcuticate huan temujticate nopan nehual ilacal in cielo. ");
INSERT INTO nclNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Mostatica yupan Jesús cataya capa yahuiloaya monamictilo omenten pin caltilan Caná pin lalticpan Galilea. Huan cataya nepa Jesús inantzin. ");
INSERT INTO nclNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Quinnotzaje Jesús noje huan imonextilinijmes pa hualalosquiaya capa yahuiloaya monamictilo. ");
INSERT INTO nclNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Quitaje pampa yajmo cataya iayo uva coc. Pampín inantzin quilic Jesús: —Yajmo quipialo iayo uva coc. ");
INSERT INTO nclNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Huan Jesús quilic: —Nana, ¿len nicpías pa niquitas ca tehual? Ayamo ajsic in tonali pa nipehuas nicchías len quinnextilis lacames capa nihualac. ");
INSERT INTO nclNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Quinmilic inantzin in tequipanujquimes: —Xicchihuacan len yes anmitzilis. ");
INSERT INTO nclNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Cataloaya nepa seis (chicuase) tapalcames lachihuali ca tixcali hual quilalililoaya al. In al quinequiloaya pa lachipahuasi quinami quijtúa ilajtol Dios hual quimaxtilo in judíos. Cajsiloaya mochi sejse ca in chicuase tapalcames quinami ochenta o cien litros. ");
INSERT INTO nclNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Quinmilic Jesús: —Xiquintemiltican ca al in tapalcames. Huan quintemiltije, ca nadita quinequiloaya toyahuilo. ");
INSERT INTO nclNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Cuaquinon Jesús quinmilic: —Axan, xicanacan, xiquihuiquilican inminlaicanani yehuanten hual quinmacaticate iayo uva coc yehuanten hual quinhualicaje pa in monamictilisli. Yojque quichihuaje. ");
INSERT INTO nclNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Huan cunic in laicanani in al hual mochíac iayo uva coc. Yihual amo quimatiaya capa canaje. Ma yoje, in tequipanujquimes quimatije, pampa cataloaya yehuanten hual canaje in al. Cuaquín quinotzac in laicanani yihual hual monamictiaya. ");
INSERT INTO nclNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Quilic: —Mochi lacal pehua quinmacatica iayo uva coc cuali pa cunisi yehuanten hual quinhualicac pa ichan pa len fiesta. Cuaquinon quiman cuniloaya míac, yihual quinmaca pa cunisi iayo uva coc hual amo niman cuali. Ma yoje, tehual ticajcoquic in cuali pa cunisi axan. ");
INSERT INTO nclNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ca inon pehuaya quinchía Jesús innojen hual quinmahuisultiloaya ca lamajtilisli lacames. Cataya pin caltilan Caná pin lalticpan Galilea. Yoje quinextic quinami yihual quipía Dios ilahueliltilisli hué, huan quilalililoaya inminlaneltocalisli ca yihual imonextilinijmes pampa quimatiloaya yihual yec in Cristo. ");
INSERT INTO nclNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Panuc inon, temuc Jesús pa in caltilan Capernaum, yihual huan inantzin huan icnían huan imonextilinijmes. Umpa chantiloaya jan se ome tonalijmes san. ");
INSERT INTO nclNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ajsitihualaya inminfiesta (ilhuil) in judíos, in fiesta itoca pascua, huan panquisac Jesús pa Jerusalén. ");
INSERT INTO nclNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nepa pin tiopan hué quinmitac yehuanten hual quinnamacaloaya toros huan borregos huan huilomes. Noje quinmitac yehuanten hual yehualoaya quinpatilijtataloaya in lacames inmintomin. ");
INSERT INTO nclNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Cuaquinon mochihuilic se lahuitequiloni ca mecames, quinquixtic moxtin pa quiahuac in tiopan hué, in borregos huan in toros huan in lanamacanijmes. Quilasac pan lali inmintomin yehuanten hual quinpatililoaya, huan quintzincuepac innojen capa molaliloaya pa lanamacasi. ");
INSERT INTO nclNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Quinmilic yehuanten hual quinnamacaloaya huilomes, quinmilic: —¡Xiquinquixtican innojen nican pa quiahuac, amo xicchihuacan pa anlanamacas pa ichan noTajtzin! ");
INSERT INTO nclNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Quijnamiquije imonextilinijmes quinami unca lajcuiluli pa Dios iamal, yojque quijtúa inahuac yihual: “Ca lanequilisli niman hué hual nechyantía chicahuac nicnequi pa quichihuasi quinami ticnequi, Tata, quiman yes niunca calijtic mocali.” Yojque unca lajcuiluli. ");
INSERT INTO nclNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Cuaquinon quinanquilije in huejueyenten in judíos, quilije: —¿Len ilanextilisli ilahueliltilisli Dios tía titechnextilía, pa yojque ticmatisi unca tel moyaxca pa ticchías inon, huan da ticpía lahueliltilisli pa ticchías inon? ");
INSERT INTO nclNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús quinnanquilic: —Xicxitinican in tiopan huan quiman panusi ye tonalijmes, nijquetzas. ");
INSERT INTO nclNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Cuaquinon quilije in judíos: —Cuarenta y seis (Ompuhualihuanchicuase) xixihuil quichijtataloaya in tiopan hué, huan ¿tehual tijquetzas jan pan ye tonalijmes san? Tislacati. ");
INSERT INTO nclNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Amo quimatiloaya pampa Jesús quinequiaya quijtu icuerpo quiman quijtutataya “in tiopan”, pampa Dios chantiaya laijtic Jesús icuerpo quinami cataya se tiopan. ");
INSERT INTO nclNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yoje, quiman quimictije Jesús huan umpa panuje ye tonalijmes, cuaquín ajsic in tonali quiman mocuepac yulic Jesús. Cuaquinon quijnamiquije imonextilinijmes quinami yihual quijtuc inon. Quineltocaje len cataya lajcuiluli inahuac Jesús huan quijnamiquije in lajtol hual yihual quinmilic. ");
INSERT INTO nclNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ma yoje, mochi in tonalijmes capa cataya Jesús pa Jerusalén pa in ilhuil (fiesta) pascua, cataloaya míac lacames nepa hual quineltocaje pampa Dios quitilanic pin lalticpan pa huelitis capa yehuanten, jan quinami quinequi quijtúa itoca. Quineltocaje quiman quitaloaya innojen huejué hual quinchíac calica quinnextiliaya quinami yihual quipiaya Dios ilahueliltilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ma yoje, Jesús amo quilaliaya laneltocalisli ca yehuanten. Yihual quinmiximatiaya moxtin. ");
INSERT INTO nclNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Amo monequiaya pa se quilis yihual len neli unca laijtic inminyolo lacames, pampa yihual ihuían quimatiaya cuali quinami jan axcan in lacames huil quipalalo inminyolo pa mochihuasi ilacocolinijmes yihual. ");
INSERT INTO nclNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ma yoje, cataya se lacal ca in lacames fariseos, motocaya Nicodemo. Yihual se hué lacal ca in judíos. ");
INSERT INTO nclNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","In se hualac capa Jesús pa layúa, quilic: —Rabí, ticmatilo tehual tiunca lamaxtini hual tihualac pampa Dios mitztilanic. Ticmatilo inon, pampa amaqui huil quinchihuaya innojen huejué hual tehual tiquinchía sinda amo cataya Dios ca yihual. ");
INSERT INTO nclNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús quinanquilic: —Neli nimitzilía, sinda amo mocuepa lacati se pa pani pin cielo, yihual amo huil quimatis nindeno quinami Dios lahueliltía. ");
INSERT INTO nclNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Quilic Nicodemo: —¿Quinami huil lacati se sinda axan unca hué? Amo huil calaqui oc sejpa laijtic inantzin pa yoje mocuepas lacatis. ");
INSERT INTO nclNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Quinanquilic Jesús: —Nimitzilía neli, sinda amo lacati se pan ipampa al huan in Espíritu Santo, cuaquín yihual amo huil cayas capa lahueliltía Dios. ");
INSERT INTO nclNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Lacames cate nacal huan umil huan esli. Huan quinlacatiltilo oc sequin hual cate nacal huan umil huan esli. In Espíritu quilacatiltía espíritu. ");
INSERT INTO nclNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Amo ximolapolulti pampa nimitzilic anquipías pa anlacatis pa pani pin cielo (ilhuicac). ");
INSERT INTO nclNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","In ijyecal unca quinami in Espíritu, ijyecatía ca capic quinequi huan tijcaqui. Ma yoje, amo ticmati capa hualac huan ca capic yahui. Jan yoje unca ca sejse sinda lacati pan ipampa in Espíritu. Amo quita capa huala in Espíritu, amo quita tequipanujtica, amo quita ca capic yahui. ");
INSERT INTO nclNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo quinanquilic: —¿Quinami huil panúa inon? ");
INSERT INTO nclNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Quinanquilic Jesús: —Tehual tiunca inminlamaxtini niman hué in israelitos, huan ¿amo ticmati len quinequilo quijtulo innojen? ");
INSERT INTO nclNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nimitzilía neli, tehuanten tiquijtulo len ticmatilo, huan tiquijtulo neli len tiquitaje. Huan amo ancana len tiquijtulo neli. ");
INSERT INTO nclNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Annimitzlaquetzilic inminahuac innojen hual panulo pan lalticpan. Huan amo anquineltoca in hual nicnequi annimitzmaxtía. Axan, ¿quinami anquineltocas sinda annimitzlaquetzilis inahuac in hual panúa pin cielo (ilhuicac)? Amo huil. ");
INSERT INTO nclNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Amo unca amaqui hual lejcuc pin cielo. Pampín amaqui huil anmitzilis len panúa pin cielo. Jan in Se hual temuc quistataya pin cielo, nehual ilacal in cielo, nehual huil. ");
INSERT INTO nclNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Huan jan yoje quinami Moisés cajcoquic in teposcuhual nepa capa amaqui cuajmiluni, jan yoje nehual ilacal in cielo nicpías pa niyes laꞌajcoquili, pa yoje moxtin hual quilalisi inminlaneltocalisli ca nehual canasi Dios iyulilisli hual amo quiman lamis. ");
INSERT INTO nclNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Unca pampa Dios quinnequic míac moxtin yehuanten pin lalticpan. Huan yoje unca quinami quinnequic: Quitemacac ixolol, in se san hual quipía, quitemacac pa miquis, pa yoje aqui yes quilalía ilaneltocalisli ca yihual, yoje in se amo polehuis pa yajmo yulis ca yihual. Huan amo inon san. Noje canas Dios iyulilisli hual amo quiman lamis. ");
INSERT INTO nclNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Unca pampa Dios amo quitilanic iXolol pin lalticpan pa quinpolehuiltis yehuanten pin lalticpan. Quitilanic iXolol pa yoje pan ipampa yihual yehuanten yesi lamacahuali pa camo polehuisi pampa yeje laijlaculi. ");
INSERT INTO nclNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Aqui yes hual quineltoca Dios iXolol yihual Dios amo quipolehuiltis. Amo quipías pa miquis laxiluli pa yajmo quitas Dios pampa yec laijlaculi. Aqui yes amo quineltoca, in se Dios axan quijtuc pampa quipía pa miquis laxiluli ilaixpan Dios pampa amo quineltoca Dios iXolol hual unca in se iXolol hual quipía. ");
INSERT INTO nclNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Huan ¿leca cate yoje lapolehuiltili innojen lacames hual amo quineltocalo Dios iXolol? Unca pampa Dios ilajtol ajsic pin lalticpan, unca quinami lahuilisli pa lacames inminyolo. Ma yoje, in lacames amo quixtocaje Dios ilahuilisli pa inminyolo. Quixtocaje yulije quichijticate amo cuali. Yehuanten hual quixtocalo quichihualo amo cuali quixtocalo quichihualo capa laticumac. Yoje, in lacames quixtocalo in laticumac huan in lahuilisli amo quixtocalo. ");
INSERT INTO nclNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Unca pampa mochi se hual quichía len amo cuali, yihual amo quixtoca Dios ilajtol hual unca quinami lahuilisli. In se amo moajxiltía pa quicaquis Dios ilajtol, pampa amo quinequi pa momatis quinami amo unca cuali in hual quichijtica. ");
INSERT INTO nclNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Huan se hual yuli quichijtica len unca melahuac quinami quijtúa Dios ilajtol, yihual moajxiltía capa huil quicaqui Dios ilajtol hual unca quinami lahuilisli. Quichía yoje pa yoje mochi in hual quichijtica cayas quinami quichía se hual quineltoca Dios. ");
INSERT INTO nclNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Panuc inon, uyaje Jesús huan imonextilinijmes pa in lalticpan Judea, nepa mocahuaya huan lacuayatequiaya. ");
INSERT INTO nclNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Juan noje cataya pin caltilan Enon capa amo cataya huejca Salim. Nepa lacuayatectataya pampa cataya míac al. Hualaloaya lacames huan quincuayatequiaya Juan pampa Juan ayamo cataya latzacuali pa calijtic. ");
INSERT INTO nclNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yoje, pehuaje molaxilije lajtomes Juan imonextilinijmes ca se judío, molaxililoaya lajtomes inahuac quinami mochipahuas se pa yoje Dios quitas chipahuac in se. ");
INSERT INTO nclNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Cuaquinon hualaje Juan imonextilinijmes capa yihual, quilije: —Rabí, yihual hual cataya ca tehual ca yoje (analco) in atenco hué Jordán, tiquijtuc neli pampa yihual unca Dios iBorrego, huan xiquita. In se lacuayatectica huan moxtin quitocalo yihual. ");
INSERT INTO nclNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Quinnanquilic Juan, quinmilic: —Se lacal amo huil cana Dios ilahueliltilisli sinda Dios pin cielo amo quimacac. ");
INSERT INTO nclNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Amhuanten nojen anquimati neli quinami annechcaquic niquijtuc ca lajtol melahuac pampa nehual amo in Cristo. Ma yoje, niunca latilanili, Dios nechtilanic pa nicayasquiaya nican in tonalijmes capa ayamo hualaya Cristo pa yoje niquinmilis in lacames pampa yahuiaya huala. ");
INSERT INTO nclNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Unca quinami in lacames hual yalo monamictilo. In lacal quipía in sihual hualca monamictis. Ma yoje, in lacal ilasojli moquetza pa cayas inahuac in lacal hual monamictía pa quipalehuis. Huan quiman yes ilasojli quicaqui lajtujtica in lacal hual monamictis, cuaquinon ilasojli quipía míac paquilisli pampa quicaqui. Huan nehual niquinami in lacal ilasojli. Nicpía míac paquilisli pampa in lacal hual monamictía, nicpía yoje niman míac paquilisli hual yajmo huil momiactía. ");
INSERT INTO nclNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Lacames quipiasi pa quimatisi mojmosta quinami yihual unca niman hué. Huan quipiasi pa quimatisi quinami nehual nitipichin. ");
INSERT INTO nclNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yihual hual hualac quistataya pa pani unca niman hué. Moxtin oc sequin amo quiman ajsisi yesi yoje hué. Yihual hual unca pin lalticpan hualac pin lalticpan huan lajtúa quinami quimatilo len unca pin lalticpan. Yihual hual hualac quistataya pin cielo unca niman hué. Moxtin oc sequin amo quiman ajsisi yesi yoje hué. ");
INSERT INTO nclNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yihual quijtúa neli len quitac huan quicaquic nepa pin cielo. Huan mas que amo unca se hual quineltoca len yihual Cristo quijtúa, ma yoje Cristo quimati huan quijtúa neli pampa Dios unca melahuac, huan unca neli in hual yihual quijtúa. ");
INSERT INTO nclNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Aqui yes quineltoca len yihual Cristo quijtúa neli, cuaquín yihual quimati huan quijtúa neli pampa Dios unca melahuac, quinami se temulol lanextilía neli quinami se amal quijtúa len hual unca neli. ");
INSERT INTO nclNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yihual Cristo hual Dios quitilanic quijtúa Dios ilajtomes, pampa yihual Dios quimaca mochi in Espíritu Santo. Amo quimaca quinami se hual lalamachihuilijtinemi. ");
INSERT INTO nclNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dios in Tata quinequi Jesús iXolol, huan quitemacac mochi ca Jesús iXolol pa yes iyaxca. Yoje mochi hual iyaxca Dios unca iyaxca Jesucristo. ");
INSERT INTO nclNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Aqui yes quineltoca Dios iXolol quipía Dios iyulilisli hual amo quiman lamis. Huan aqui yes amo quineltoca Dios iXolol amo quitas iyulilisli. Dios amo mocahua pa cualanis ca in se hual amo quineltoca. ");
INSERT INTO nclNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Cuaquinon, quisac in Tata pin lalticpan Judea. Quisac pampa quimatic quinami yehuanten hual quineltocaloaya inminlamaxtilisli in fariseos quicaquije quinami yihual Jesús quinmanaya huan quincuayatequiaya míac monextilinijmes huan Juan yajmo míac. ");
INSERT INTO nclNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ma yoje, amo cataya Jesús hual lacuayatequiaya, cataloaya imonextilinijmes hual lacuayatequiloaya. ");
INSERT INTO nclNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Pampín, quisac in lalticpan Judea, uyac pa in lalticpan Galilea. ");
INSERT INTO nclNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Huan quipiaya pa quipanahuis in lalticpan Samaria. ");
INSERT INTO nclNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Quipanajtataya ca ompic, uyac capa amo huejca cataya se caltilan pa Samaria itocac Sicar. Ajsic capa in lali hual Jacob quimacac ixolol José pa yina. ");
INSERT INTO nclNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Noje cataya nepa Jacob icoyunquil huejcalan pa al. Huan quinami siajtihualaya Jesús ca in míac nejnemilisli, molalic inahuac in coyunquil, cataya quinami lacualispan. ");
INSERT INTO nclNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Cuaquín hualac se sihual samariteca pa canas al. Jesús quilic: —Xichmaca al pa nicunis. ");
INSERT INTO nclNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Cataloaya inminhuían pampa uyaje imonextilinijmes pa in caltilan pa quicuhualosquiaya len quicualosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","In sihual samariteca quilic: —Tehual tijudío. ¿Leca tinechmotemachilía nehual len ticunis? Nel niunca samariteca. (Quilic yoje, pampa in judíos amo motemachilo ca in samaritecos, amo quinmixtocalo yehuanten.) ");
INSERT INTO nclNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesús quinanquilic, quilic: —Sinda ticmatiaya len Dios quinequi mitzmaca, huan sinda tiquiximatiaya aqui nehual niunca hual nimitzmotemachilic al pa nicunis, cuaquín tichmotemachiliaya huan nimitzmacaya al hual totoca pa layuliltilis. ");
INSERT INTO nclNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","In sihual quilic: —Tata, tehual amo ticpía len calica ticanas al, huan in coyunquil unca huejcalan. ¿Capa ticpía in al hual totoca pa layuliltilis? ");
INSERT INTO nclNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Tehual tihué huan totajtzin Jacob amo yoje hué? Yihual quihuajuanac in coyunquil huan techcahuilic. Cuninijme al hual quisac nican, yihual huan ixolomes huan iyulijquimes cuninijme al hual canaje pin huejcalan nican. Huan tehual, ¿tinechmacas al? ");
INSERT INTO nclNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús quinanquilic: —Moxtin hual cunilo in al nican amiquisi oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ma yoje, aqui yes cunis in al hual nicmacas nehual, yihual amo quiman amiquis. Quema, in al hual nicmacas yes quinami se ilajuichuilisli al laijtic yihual huan in al quinami lajuichus lejcutica pa pani pa quiyuliltis ca Dios iyulilisli hual amo quiman lamis. ");
INSERT INTO nclNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","In sihual quilic: —Tata, xinechmaca in al pa camo niamiquis huan pa camo nicpías pa nihualas nicanas al ca niquic. ");
INSERT INTO nclNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús quilic: —Xía xicnotza pa hualas molahuical huan xihualacan ca niquic. ");
INSERT INTO nclNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Quinanquilic in sihual: —Amo nicpía nolahuical. Jesús quilic: —Neli tiquijtúa tichilijtica pampa amo ticpía molahuical. ");
INSERT INTO nclNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Unca pampa tiquinpíac macuili molahuicalhuan. Huan amo san inon, yihual hual ticpía axan amo molahuical. Neli tiquijtuc tichilijtataya inon. ");
INSERT INTO nclNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","In sihual quilic: —Tata, nicmati pampa inon pampa tehual tiunca se ilajtuni Dios. ");
INSERT INTO nclNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Quimolancuacuetzilinijme Dios totajtzitzían pan in loma nican. Huan amhuanten anquijtúa unca pin Jerusalén capa monequi pa lacames quimolancuacuetzilisi Dios. ");
INSERT INTO nclNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús quilic: —Nito, xicneltoca len nía nimitzilía. Ajsiticate tonalijmes huan pa innojen tonalijmes yajmo monotzas capa anquimolancuacuetzilis toTajtzin Dios. Amo anquipías pa anquimolancuacuetzilis nican, amo anquipías pa anquimolancuacuetzilis pa Jerusalén. ");
INSERT INTO nclNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Amhuanten anquimolancuacuetzilía len amo anquimati. Tehuanten ticmolancuacuetzililo len ticmatilo. Unca pan topampa tehuanten in judíos huala Dios ilajtol hual lamaxtilía quinami in lacames moquixtilisi pin ipolehuilisli inminlaijlaculisli. Huan lamaxtilía quinami quipiasi Dios iyulilisli hual amo quiman lamis. ");
INSERT INTO nclNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ma yoje, ajsitica in tonali, quema, axan ajsic in tonali, huan yehuanten hual neli quimolancuacuetzililo Dios quimolancuacuetzilisi pan ipampa inminyolo huan quimolancuacuetzilisi pan ipampa mochi melahualisli. Lacames quinami innojen toTajtzin Dios quintemujtía pa quimolancuacuetzilisi. ");
INSERT INTO nclNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios unca Espíritu, huan yehuanten hual quimolancuacuetzililo quipialo pa quimolancuacuetzilisi pan ipampa espíritu huan pan ipampa melahualisli. In espíritu unca pa iyolo se. Dios toTajtzin quintemúa lacames huan sihuames quinami yehuanten pa quimolancuacuetzilisi yoje. ");
INSERT INTO nclNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","In sihual quilic: —Nicmati pampa yahui huala in Mesías hual quitocayaltilo Cristo. In tonali yihual hualas, yihual technextilis mochi. ");
INSERT INTO nclNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús quilic: —Nehual niunca in Cristo, nehual hual nimitzlaquetzilijtica tehual. ");
INSERT INTO nclNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jan nican mocuectihualaloaya imonextilinijmes, mocahualoaya moizticate pampa Jesús laqueztataya ca se sihual. Ma yojque amaqui quilic: “¿Len ticnequi ca in se?”, o “¿Leca tilaqueztica ca yihual?” ");
INSERT INTO nclNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Cuaquinon quicajcahuac in sihual itapalcal, uyac, yajtíac pa in caltilan, quinmilic in lacames: ");
INSERT INTO nclNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Xihualacan xiquitacan se lacal hual nechilic mochi len nicchihuaya. ¿Amo yes in Cristo in se? ");
INSERT INTO nclNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Jan axcan quisaje pin caltilan, pehuaje hualaje ca capic cataya Jesús. ");
INSERT INTO nclNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Hualajtataloaya in samaritecos, quilije Jesús imonextilinijmes: —Rabí, xilacua. ");
INSERT INTO nclNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Huan Jesús quinmilic: —Nehual nicpía len nijcuas hual amhuanten amo anquimati. ");
INSERT INTO nclNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Pampín moilije imonextilinijmes se ca oc se, moilije: —¿Unca se hual quihualiquilic len pa quicuas? ");
INSERT INTO nclNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesús quinmilic: —Nicnequi míac pa nicchías len quinequi Dios hual nechtilanic, amo yoje míac nicnequi nilacua. Yoje nilamis nicchías Dios itequipanulisli. ");
INSERT INTO nclNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","¿Amo anquijtúa: “Quipías nahui mesli, cuaquinon ajsis in lapixcalisli”? Huan nehual niquinnechicujtica lacames hual nechneltocalo, inon unca quinami se lapixcalisli. Huan xiquitacan, annimitzilía xiquinlapucan anmoixtololojmes huan xiquinmiztiacan in cuajmilimes. Unca quinami lacames huan sihuames hual nechneltocasi axan hualajticate nepa pin cuajmilimes. Unca quinami cuajmilimes axan chicajticate pa in lapixcalisli, pampa lacames yalo nechneltocalo. ");
INSERT INTO nclNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Unca quinami axan cantica in lapixcani ilaquehualisli, huan lapejpentica huan lamontutica. Yoje lanechicujtica pa in lapixcalisli. In lapixcalisli unca quinami se hual quinnotzas oc sequin lacames pa nechneltocasi, huan yehuanten canasi Dios iyulilisli hual amo quiman lamis. Yoje moxtin hual pehuaje quinlamachiltije nonahuac nehual quipiasi paquilisli ca yehuanten hual quinpalehuije pa nechneltocasi. Unca jan quinami in paquilisli hual quipialo yehuanten hual latocalo huan yehuanten hual lapixcalo. ");
INSERT INTO nclNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Unca neli in hual tiquijtulo: “Unca se hual latoca, huan oc se hual lapixca.” ");
INSERT INTO nclNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Unca quinami annimitztilanic pa anlapixca capa amo antequipanuaya. Oc sequin tequipanuloaya nepa, huan axan unca quinami amhuanten anpejtica anlapixca capa yehuanten latocanijme. ");
INSERT INTO nclNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Huan míac ca innojen lacames samaritecos hual chantiloaya pa in caltilan quineltocaje pan ipampa len quinmilic in sihual. Yihual quinmilic neli: “Yihual nechilic mochi hual nicchíac pa noyulilisli.” ");
INSERT INTO nclNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Yoje, hualaje capa yihual Jesús in samaritecos, quitemachije pa mocahuas ca yehuanten pin caltilan Sicar. Cuaquín mocahuac Jesús umpa ome tonalijmes. ");
INSERT INTO nclNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Huan míac oc sequin ca yehuanten quineltocaje Jesús pan ipampa len yihual quinmilic. ");
INSERT INTO nclNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Pehuaje quilije in sihual: —Axan ticneltocalo amo pan ipampa len titechilic, pampa axan tijcaquije tehuanten tohuían, huan neli ticmatilo in lacal unca in Cristo hual quinquixtilía inminlaijlaculisli in lacames pin lalticpan pa camo polehuisi. ");
INSERT INTO nclNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Panuje in ome tonalijmes, quisac Jesús umpa huan uyac pa in lalticpan Galilea. ");
INSERT INTO nclNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Uyac umpa ca imonextilinijmes. Huan yihual Jesús neli quijtuc pampa amo quimatilo momajtilo iyampa se ilajtuni Dios yehuanten pa ilali capa moscaltic. ");
INSERT INTO nclNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ma yoje, yehuanten pa Galilea quinamiquije ca paquilisli, pampa quitaje mochi innojen hual quinchíac nepa Jerusalén pin fiesta (ilhuil), yehuanten noje nepa cataloaya. ");
INSERT INTO nclNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Cuaquinon uyac oc sejpa pa in caltilan Caná pin lalticpan Galilea. In caltilan cataya capa quipiaya je quesqui tonalijmes quipalac in al pa mochíasquiaya iayo uva coc. Huan cataya se huelitini ca yehuanten hual huelitiloaya. Quipiaya ixolol mococujtataya pin caltilan Capernaum. ");
INSERT INTO nclNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Quicaquic lajtuloaya quinami quisac Jesús in lalticpan Judea huan axan ajsic pa Galilea. Pampín uyac capa Jesús, quiyantic pa temus Jesús pa Capernaum pa quipajtis ixolol, pampa yahuiaya miqui ixolol. ");
INSERT INTO nclNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesús quilic: —Sinda amo anquita panúa len pin cielo (ilhuicac) o pan lalticpan hual anmitzmahuisultía ca lamajtilisli, amo quiman anquinequi anquineltoca nehual niquistihualac capa unca Dios. ");
INSERT INTO nclNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","In huelitini quilic: —Tata, xihuala ca nehual pa camo miquis noxól. ");
INSERT INTO nclNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesús quilic: —Xía pa mochan, yuli moxól, amo miquis. Quineltocac in lacal in hual quilic Jesús, uyac. ");
INSERT INTO nclNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Huan cataya pan ojli, ayamo ajsiaya pa ichan huan quinamictihualaje itequipanujquimes, quilije pampa pajtic ixolol, quilije: —Pajtic moxól, yultica. ");
INSERT INTO nclNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Quilajlanic quiman pehuac pajtic huan quilije: —Yalhua pa se hora pa tiolac mosehuic totoníac. ");
INSERT INTO nclNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Pampín quimatic itajtzin cataya in hora quiman quilic Jesús: “Yultica moxól.” Yoje yihual quineltocac pampa Jesús quistihualac capa unca Dios huan noje quineltocaje moxtin pa ichan. ");
INSERT INTO nclNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ca inon, axan cataloaya ome lachihualisli hual Jesús quinchíac hual pampa innojen quinmahuisultije ca lamajtilisli moxtin. Inon panuc pin tonalijmes quiman quisac in lalticpan Judea pa hualas pa Galilea. ");
INSERT INTO nclNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Panuje innojen tonalijmes, cataya se fiesta (ilhuil) pa in judíos, huan panquisac Jesús pa Jerusalén. ");
INSERT INTO nclNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Cataya se lahuajuanali amo huejcalan capa maltinijme. Amo cataya huejca in lalapujquil capa calaquinijme in borregos pa in cali cuajtic (tepandi) hual quiyahualuaya in caltilan. In lahuajuanali motocaya ca lajtol hebreo Betzata, huan pa itenco catanijme macuili caltzindis mochi lalapuli san ca chicuenta cuajmaxalimes lachihuali ca tixcalimes. ");
INSERT INTO nclNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Pa in caltzindis lastataloaya míac hual cojcocoxqui, pachacames huan yehuanten hual amo huil nejnemiloaya huan yehuanten hual mocololojtataloaya. Quichialoaya pa quiman molinisquiaya in al. ");
INSERT INTO nclNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Se ilanahuatini in Tata temuni quistataya pin cielo (ilhuicac) huan quiculinini in al, yoje panuc sejpa huan oc sejpa mochi xihuil. Huan quiman mosehuiaya molini in al, cuaquín aqui cayasquiaya hual laicaniaya calaqui pa al, yojque yihual pajtiaya. ");
INSERT INTO nclNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nepa lastataya se lacal cocoxqui, axan quipiaya treinta y ocho (sempuhualicaxtulihuanye) xixihuil amo huil moliniaya. ");
INSERT INTO nclNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Quitac Jesús in lacal lastataya, quimatic pampa quipiaya míac xixihuil yoje cocoxqui. Huan quilic: —¿Ticnequi tipajtía? ");
INSERT INTO nclNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","In cocoxqui quinanquilic: —Tata, amo nicpía je lacal ca nel pa nechlasas pa al quiman yes mosehuía molinía. Huan nimotolinía pa nitemus pa al, umpa nechpanahuía oc se. ");
INSERT INTO nclNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús quilic: —Ximoquetza, xicana mopelal huan xinejnemi. ");
INSERT INTO nclNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Huan jan ajnaxcan pajtic in lacal, canac ipelal huan pehuac nejnemic. Cataya in tonali siete (chicome) huan pa in tonali mosehuilo in judíos. ");
INSERT INTO nclNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Pampín quilije in judíos yihual hual pajtic, quil: —Axan in tonali timosehuilo, huan tolajtol amo mitzmacahuiltía pa ticmantías mopelal. ");
INSERT INTO nclNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Yihual quinnanquilic: —Yihual hual nechpajtic nechilic: “Xicana mopelal huan xinejnentía.” ");
INSERT INTO nclNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Quilajlanije: —¿Aqui in lacal hual mitzilic: “Xicana huan xinejnentía”? ");
INSERT INTO nclNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Yihual hual Jesús quipajtic amo huil quinmiliaya aqui cataya, pampa mohuicac Jesús, yajmo huil moitiliaya pampa tentataya ca lacames in lajcotiyan. ");
INSERT INTO nclNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mochíac je nadita huan Jesús quitac in lacal hual quipajtic, cataya calijtic pin tiopan hué, huan quilic: —Xiquita. Axan tipajtic. Yajmo xicchía laijlaculisli amo san gá mitzpanus oc se cocolisli hual mitzcocoltis míac, hual amo mitzcocoltic yoje míac mococolisli hual tilamic tipajtic. ");
INSERT INTO nclNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Uyac in lacal, quinmilic in judíos huejué cataya Jesús hual quipajtic. ");
INSERT INTO nclNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Pampa inon in judíos huejué quitemujtinemiloaya quinami quitojtocasi Jesús pampa amo quineltocaya inminlajtol. Quichihualoaya yoje pampa Jesús quichíac inon pan in tonali hual mosehuilo in judíos. ");
INSERT INTO nclNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ma yoje, Jesús quinnanquilic: —NoTajtzin amo mocahua pa quichías mochi hual unca cuali. Quinami pa yina, jan yoje axan. Huan nehual nicchijtica noje quinami yihual. ");
INSERT INTO nclNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Cuaquín pampa inon, quitejtemuje in judíos niman míac quinami quimictilosquiaya. Amo cataya jan pampa quichihuaya len amo quixtocaloaya pan tonali chicome san. Noje yihual quinmilic pampa Dios yec yihual iTajtzin. Huan pampa quijtuaya inon, yoje yihual mochihuaya jan quinami Dios. ");
INSERT INTO nclNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Cuaquinon, Jesús pehuac monapatic ca ilajtomes, quinmilic: —Neli annimitzilía, nehual iXolol Dios amo huil nicchía nindeno pan nopampa. Jan huil nicchía len niquita quichijtica noTajtzin. Unca pampa len yes yihual quichía, cuaquinon jan yoje inon nicchía nehual iXolol. ");
INSERT INTO nclNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Inon unca pampa noTajtzin nechlasojla nehual iXolol, huan nechnextilía mochi innojen hual yihual quinchía. Quema, huan nechnextilis lachihualisli niman huejué. Amo cate yoje huejué innojen hual annechitac niquinchíac. Nechnextilis pa yoje niquinchías huan pa yoje anmomajtis pampa anquitas quinami quipía lahueliltilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yoje, quinami noTajtzin quinyuliltía in mijquimes, jan yoje nehual iXolol niquinyuliltía aquinojen yesi nicnequi niquinyuliltía. ");
INSERT INTO nclNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Huan amo inon san. NoTajtzin Dios amo quitojtoca amaqui ilaixpan pa polehuis capa amo huil mocuepas. Ma yoje, quimacac pa nehual iXolol niquintojtocas nolaixpan yehuanten hual quipialo laijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Yoje, moxtin quimatisi momajtisi nolaixpan nehual Dios iXolol jan quinami quimatilo momajtilo ilaixpan noTajtzin Dios. Aqui yes amo quimati momajtía nolaixpan nehual Dios iXolol, cuaquín jan yoje amo quimati momajtía ilaixpan noTajtzin hual nechtilanic nican pan lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Neli, neli annimitzilía, aqui yes quicaqui len niquijtúa huan quineltoca yihual Dios hual nechtilanic, yihual quipía Dios iyulilisli hual amo quiman lamis. Huan amo nictojtocas nolaixpan nehual pampa yec laijlaculi. Quema, axan yihual quisac capa in miquilisli lahueliltiaya huan quimajtic, axan quipía Dios iyulilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Neli, neli annimitzilía, ajsitica in tonali, quema, axan ajsic in tonali hual yehuanten hual miquije quicaquisi nolajtol nehual Dios iXolol, huan yehuanten hual quicaquisi yulisi oc sejpa. Moquetzasi, quisasi pin miquilisli, yajmo quiman miquisi. ");
INSERT INTO nclNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Unca pampa jan quinami Dios noTajtzin quipía yulilisli pan ipampa yihual ihuían, jan yoje nechmacac nehual iXolol noje pa nicpías yulilisli pan nopampa. ");
INSERT INTO nclNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Huan Dios nechmacac lahueliltilisli pa niquinmilis pampa quipiasi pa polehuisi laxiluli pa camo cayasi ca Dios pampa nehual niunca ilacal in cielo. ");
INSERT INTO nclNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Amo ximolapolultican pampa inon, pampa ajsis in tonali hual moxtin in mijquimes hual cataloaya lalalpachuli quicaquisi nolajtol. ");
INSERT INTO nclNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Pampín, quisasi capa cataloaya lalalpachuli. Yehuanten hual yulinijme pan lalticpan quichijtataloaya inon hual unca cuali canasi Dios iyulilisli hual amo quiman lamis. Yehuanten hual yulinijme pan lalticpan quichijtataloaya in hual amo unca cuali yulisi oc sejpa pa niquijtus pampa quipiasi pa polehuisi pa camo quiman cayasi ca Dios. ");
INSERT INTO nclNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Amo huil nicchía nindeno sinda nicnequi nicchía pan ipampa nolahueliltilisli. Ca Dios ilahueliltilisli nicpía pa nicchías mochi. Huan quinami nijcaqui Dios quijtúa, niquintojtoca nolaixpan nehual pa polehuisi o niquinmacahua pa yulisi. Huan unca melahuac len yes niquijtúa inahuac aqui yes. Unca melahuac pampa amo nictemúa quinami nicchías len nehual nicnequi. Nictemúa quinami nicchías len yihual quinequi hual nechtilanic pan lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Sinda nilajtuaya neli nonahuac nehual nohuían, in lajtulisli amo anmitzajsiaya pa yoje anquipías pa anquineltocas pampa unca melahuac in hual niquijtúa. ");
INSERT INTO nclNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Unca oc se hual quijtúa neli nonahuac nehual, huan nicmati inon hual yihual quijtúa unca melahuac. ");
INSERT INTO nclNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Amhuanten anquintilanic lacames pa quilajlanisi Juan Lacuayatequini sinda yihual yec in Cristo, huan yihual anmitzilic inon hual unca melahuac nonahuac nehual. ");
INSERT INTO nclNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Huan ca nehual amo monotza nindeno in hual lacames quijtulo neli nonahuac nehual. Unca oc se hual lajtúa neli nonahuac nehual, yihual Dios. Ma yoje, annimitzilijtica inon hual Juan quijtuc nonahuac nehual, pa huejtica annechneltocas huan yoje anyes laquixtili pin ipolehuilisli anmolaijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan Lacuayatequini anmitzilic nadita inahuac Dios ilajtol. Yoje yihual cataya quinami lahuilisli laixpelatataya hual Dios quilalaltic. Huan ancataya niman ca paquilisli pa je nadita pa anquicaquis len inahuac Dios ilajtol hual yihual anmitziliaya. Ancataya quinami lacames hual quipialo paquilisli ca se lahuilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","In hual Juan Lacuayatequini anmitzilic nonahuac nehual cataya melahuac. Ma yoje, innojen hual niquinchijtica neli quinextilía quinami noTajtzin nechtilanic pa niquinchías. Quema, lanextililo niman míac. Amo yoje míac lanextilía in lajtol hual Juan quijtuc nonahuac nehual. Yihual Dios noTajtzin nechilic pa nicchías mochi innojen hual anquinmita anmomajtitica ipampa Dios ilahueliltilisli. Nechilic pa nilamis niquinchías, huan innojen lachihualisli quinextililo pampa nihualac niquistataya capa unca Dios noTajtzin. ");
INSERT INTO nclNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Quema, noTajtzin Dios nechtilanic pa nihualas ca niquic, huan quilamachiltic lajtomes nonahuac nehual hual neli cate. Ma yoje, amhuanten amo quiman anquicaquic ilajtol huan amo quiman anquitac. ");
INSERT INTO nclNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Huan amhuanten amo anquipía Dios ilajtol mocajtica laijtic anmoyolo. Inon nicmati, pampa mas que Dios nechtilanic pa nihualas, ma yoje amo annechneltoca. ");
INSERT INTO nclNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Anquitejtemujtía len unca lajcuiluli pin amames hual Dios ilajtunijmes quijcuiluje. Anquichía yoje pampa anquijtúa jan monequi pa anmomaxtía pa yoje ancanas Dios iyulilisli hual amo quiman lamis. Huan inon hual unca lajcuiluli neli anmitznextilía pampa nehual niunca aqui hual annimitzilía. ");
INSERT INTO nclNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ma yoje, amo anquinequi anhuala ca nehual pa yoje anmitzmacas Dios iyulilisli hual amo quiman lamis. ");
INSERT INTO nclNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Amo nimotolinía pa niquitas quinami niquinlaquetzaltis hué nonahuac nehual lacames. ");
INSERT INTO nclNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ma yoje, annimitziximati amhuanten, nicmati pampa laijtic amhuanten anmoyolo amo anquilasojla Dios. ");
INSERT INTO nclNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nihualaya quinami Dios noTajtzin ilanahuatini, huan nicpía ilahueliltilisli hual unca ca quinami itoca. Huan amhuanten amo annechneltoca. Sinda huala oc se ca ilahueliltilisli yihual ihuían, cuaquín yihual anquineltocas. ");
INSERT INTO nclNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Quinami huil annechneltoca? Amo huil, sinda mochi sejse ca amhuanten amo anmocahua pa anquitemus pa oc sequin anmitzitasi cuali huan amo anquitemúa pa Dios anmitzitas cuali. ");
INSERT INTO nclNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Amo xiquijtucan pampa nehual nía annimitzmotexpahuilía ilaixpan Dios noTajtzin. Unca se hual anmitzmotexpahuilía. Yihual Moisés hual anquijtúa pampa anquineltoca. ");
INSERT INTO nclNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Yihual anmitzmotexpahuilis pampa sinda anquineltocaya len yihual quijtuc, cuaquinon annechneltocaya, pampa yihual quijcuiluc lajtomes nonahuac nehual. ");
INSERT INTO nclNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ma yoje, sinda amo anquineltoca in hual yihual quijcuiluc, cuaquinon amo anyahui anquineltoca in hual niquijtúa nehual. ");
INSERT INTO nclNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Panuc inon, Jesús quipanahuic in al huejcalan itoca Galilea, noje itoca Tiberias. Quipanahuic ca barquito ca yoje itenco (analco). ");
INSERT INTO nclNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Huan quitocaloaya niman míac lacames huan sihuames pampa quitaloaya quinami quinpajtiaya in cocoxquimes. Inon quinextiliaya quinami yihual quipiaya Dios ilahueliltilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Huan panquisac Jesús pa pani pin loma (tepetzindi), nepa molalic ca imonextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ajsitihualaya in fiesta (ilhuil) itoca pascua, in judíos inminilhuil. ");
INSERT INTO nclNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Momelahuac Jesús, quinmitac niman míac lacames huan sihuames hualajticate capa yihual, huan quilic Felipe: —¿Capa tijcuhuasi len pa quicuasi in lacalera? ");
INSERT INTO nclNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesús quimatiaya len yahuiaya quichía pa canas in lacuali. Ma yoje, quilajlanic Felipe inon pa yoje quijnamiquiltisquiaya Felipe quinami yihual Felipe quipiaya pa monextilisquiaya míac pa quimatisquiaya quinami cataya hué Jesús ilahueliltilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe quinanquilic: —In tomin hual canaloaya ome cientos (majlaclipuhuali) lacames tequipanujticate pan se tonali, in cataya tipichin, amo quinmajsisquiaya pa mochi sejse quipiasquiaya je nadita pan pa quicuasquiaya. ");
INSERT INTO nclNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Se ca Jesús imonextilinijmes hual yec icni Simón Pedro, huan motocaya Andrés, quilic: ");
INSERT INTO nclNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Nican unca se muachito, quinpía macuili panes lachihuali ca cebada huan ome michimes. Unca san naditita. ¿Quinami quinmajsisi innojen in míac lacames? ");
INSERT INTO nclNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesús quilic: —Xiquinmilican in lacames pa molalisi. Cataya nepa míac sacal. Huan molalije pani pin sacal in lacames, cataloaya quinami cinco (macuili) mil. ");
INSERT INTO nclNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Cuaquín quinmanac Jesús in panes huan quisehuic Dios. Cuaquinon quinxiluilic yehuanten hual molalijtataloaya. Jan yoje quinxiluilic in michimes huan quicuaje moxtin quinami quinequiloaya quicualo. ");
INSERT INTO nclNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Quiman pachihuije, quinmilic imonextilinijmes: —Xiquinpejpenacan in lajquitos lalapanali hual quincahuaje, pa camo ticpolusi nindeno. ");
INSERT INTO nclNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Quimpejpenaje huan quintemiltije doce chiquihuimes ca inminlajquitos in macuili panes lalapanali. Cataloaya in hual quicahuaje yehuanten hual lacualoaya. ");
INSERT INTO nclNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Yoje, quiman quitaje in míac lacames huan sihuames in hual Jesús quichíac, inon hual lanextilic quinami yihual quipiaya Dios ilahueliltilisli, cuaquín quilije: —Neli in se ilajtuni Dios hual yahuiaya huala pin lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pampín, Jesús quimatic yehuanten yahuiloaya hualalo canalo pa quichihualtije pa yes inminhué. Yoje mijcuanic ihuían oc sejpa pa pani pin loma (tepetzindi). ");
INSERT INTO nclNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Axan tiolactitiahuiaya, huan temuje imonextilinijmes pa in al huejcalan. ");
INSERT INTO nclNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Calaquije pan se barquito, yahuiloaya quipanahuilo in al huejcalan pa ajsisi pa Capernaum. ");
INSERT INTO nclNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Pehuac majcoquic in al hué pampa pehuac ijyecac se ijyecal chicahuac. ");
INSERT INTO nclNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Quilanilultitiahuiloaya in barquito quinami macuili o chicuase huejcani (cinco o seis kilometros), cuaquín quitaje Jesús pani pin al, nejnemiaya ajsitihualaya capa in barquito, huan momajtiloaya míac. ");
INSERT INTO nclNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Huan jan axcan yihual quinmilic: —¡Nehual niunca, amo ximomajtican! ");
INSERT INTO nclNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Cuaquinon quinequiloaya pa calaquis pin barquito. Calaquic cuaquín, huan jan ajnaxcan ajsic in barquito pa itenco in lali ca capic yajtiahuiloaya. ");
INSERT INTO nclNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mostatica ayamo mohuicaloaya in míac lacalera hual cataloaya ca yoje (analco) in al huejcalan, capa Jesús quinlacualtic. Quitaloaya quinami yalhua pa tiolac amo cataya oc se barquito, jan se san, huan pa in se barquito jan calaquije in monextilinijmes san, huan mohuicaje inminhuían. Quitaloaya quinami Jesús amo calaquic pin barquito ca yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ma yoje ajsitihualaje barquitos hual cayaje pa Tiberias, ajsije capa amo huejca cataloaya in lacalera, capa in Tata Jesús quisehuic Dios pa in pan hual yehuanten quicuaje. ");
INSERT INTO nclNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Yoje, quitaje in lacalera quinami yajmo cataya Jesús ca yehuanten, huan noje yajmo cataloaya imonextilinijmes. Cuaquín yehuanten noje calaquije pin barquitos hual ajsije, quipanahuije in al huejcalan, ajsije pa Capernaum, pehuaje quitemuje Jesús. ");
INSERT INTO nclNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Huan quitaje Jesús nepa pa ca yoje (analco) in al huejcalan, quilajlanije: —Rabí, ¿quiman tihualac ca niquic? ");
INSERT INTO nclNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús quinnanquilic: —Neli, neli annimitzilía inon: Amo annechtemujtica pampa anquitac len nicchía hual lanextilía quinami nehual nicpía Dios ilahueliltilisli. Jan annechtemujtica san pampa anpachihuic pan ipampa in pan hual anquicuac. ");
INSERT INTO nclNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Anquijnamictica san inon hual anquicua. Huan inon moijlacúa, amo huejcahua, amo anmitzyuliltis pa yajmo anmiquis. Pampín, amo ximotolinican pa ancanas inon hual amo anmitzyuliltis. Monequi pa anquichías inon hual nía annimitzilía. Ximotolinican pa ancanas pa anquicuas in hual huejcahua pa yes, hual anmitzmacas iyulilisli cuali hual amo quiman lamis. Inon nehual annimitzmacas, nehual ilacal in cielo. Huan Dios noTajtzin neli nechilic pa annimitzmacas inon. Huan amo quiman quipalas len quijtúa. Unca quinami se layapani pan se amal, quiyapa in hual unca lajcuiluli pan in amal pa camo mopalas. ");
INSERT INTO nclNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Yoje in lacalera quilije: —Huan ¿len monequi pa ticchihuasi pa tictequipanuilisi Dios quinami yihual quinequi? ");
INSERT INTO nclNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús quinnanquilic: —Inon unca hual Dios quinequi pa anquichías, huan neli, amo unca tequipanulisli. Dios quinequi pa anquineltocas yihual hual yihual Dios quitilanic pan lalticpan, niquijtúa, xichneltocacan nehual. ");
INSERT INTO nclNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Yoje quilije: —Huan ¿len tía ticchía pa titechnextilis da Dios neli mitztilanic? Yoje timitzneltocasi. ¿Len tía ticchía? ");
INSERT INTO nclNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Totajtzitzían quicuanijme pa yina in maná umpa quiman yultataloaya capa oc sequin amo chantinijme. Quinami unca lajcuiluli pa Dios iamal, quijtúa: “Yihual quinmacac pan hual cataya pin cielo (ilhuicac) pa quicuasi.” ");
INSERT INTO nclNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús quinmilic: —Neli, neli annimitzilía, amo cataya Moisés hual anmitzmacaya in pan hual cataya pin cielo huan temuc capa amhuanten, quinami anquijtúa. No, cataya Dios noTajtzin hual anmitzmaca in pan melahuac pin cielo hual neli anmitzyuliltía. ");
INSERT INTO nclNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Sinda annimitzlaquetzilía inahuac in pan pin cielo hual Dios quimaca, nicnequi niquijtúa pampa nehual niunca in pan hual Dios quimaca, nehual in lacal hual niquisac pin cielo pa nitemus ca niquic. Nehual in lacal hual niquinmaca yulilisli yehuanten pin lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Cuaquinon quilije: —Tata, xitechmaca mojmosta in pan hual titechlaquetzilijtica. ");
INSERT INTO nclNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús quinmilic: —Nehual niquinami pan hual quimaca yulilisli. Aqui yes hualas ca nehual pa motemacas, cuaquín in se amo quiman mayanas. Huan aqui yes nechneltocas, in se amo quiman amiquis. ");
INSERT INTO nclNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Annimitzilic pampa mas que amhuanten annechitac, amo annechneltocac. ");
INSERT INTO nclNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ma yoje, sequin nechneltocalo. Yehuanten cate innojen hual nechmacac Dios noTajtzin, huan yehuanten hualasi ca nehual. Huan aqui yes hualas ca nehual, amo quiman nijquixtis in se capa niunca. ");
INSERT INTO nclNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Amo niquinquixtis, pampa niquisac pin cielo pa nitemus ca niquic amo pa nicchías len nehual nicnequi. Nitemuc pa nicchías quinami quinequi yihual hual nechtilanic. ");
INSERT INTO nclNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Huan yihual hual nechtilanic quinequi pa camo nicpolus amaqui ca yehuanten hual yihual nechmaca pa cayasi ca nehual. Yihual quinequi pa niquinyuliltis pan in tonali quiman lamis in lalticpan hual axan unca. ");
INSERT INTO nclNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Quema, in unca hual quinequi noTajtzin. Quinequi pa quipías iyulilisli hual amo quiman lamis mochi sejse hual nechita huan nechneltoca nehual iXolol. Huan nehual nicyuliltis mochi sejse pan in tonali quiman lamis in lalticpan hual axan unca. ");
INSERT INTO nclNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Cuaquinon pehuaje laquetzaje in hueyenten judíos pampa amo quixtocaloaya len quinmiliaya Jesús, pampa quinmiliaya yihual yec in pan hual quisac pin cielo huan temuc pan lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Quililoaya: —In se unca Jesús ixolol José, yihual itajtzin huan inantzin tiquinmiximatilo. Huan techilijtica yihual quisac pin cielo huan temuc ca niquic. Amo ticneltocalo len techilijtica tehuanten. ");
INSERT INTO nclNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Quinnanquilic Jesús, quinmilic: —Amo ximolaquetzilican yoje pampa amo anquixtoca len annimitzilic. ");
INSERT INTO nclNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Amaqui huil huala ca nehual sinda Dios noTajtzin amo quinequiltía pa hualas ca nehual. Huan nicyuliltis pan in tonali quiman lamis in lalticpan hual axan unca. ");
INSERT INTO nclNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Dios ilajtunijmes quijcuiluje inon, huan yoje mocahua melahuac. Quijcuiluje: “Dios quinmaxtis yehuanten moxtin.” Pampín annimitzilía pampa hualasi ca nehual moxtin hual quicaquilo len quijtúa Dios noTajtzin. Quema, monextililo pan ipampa ilajtol pampa yihual quinmaxtilía ilajtol. ");
INSERT INTO nclNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Amo unca se ca amhuanten hual quitac Dios noTajtzin. Jan nehual san niquitac Dios noTajtzin, nehual hual niquisac pin cielo pa nitemus ca niquic. ");
INSERT INTO nclNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Neli, neli annimitzilía, aqui yes nechneltoca quipía Dios iyulilisli cuali hual amo quiman lamis. ");
INSERT INTO nclNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nehual niunca in pan hual layuliltía. ");
INSERT INTO nclNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Anmotajtzitzían quicuanijme in maná pa yina nepa capa amaqui cuajmiluni. Ma yoje, yehuanten miquije. ");
INSERT INTO nclNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nehual annimitzlaquetzilijtica inahuac in pan hual quisac pin cielo huan temuc, pa yoje, sinda se lacal quicuas, yoje amo miquis. ");
INSERT INTO nclNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nehual niunca in pan hual layuliltía, nehual in pan hual quisac pin cielo huan temuc. Sinda se lacal quicua in pan, cuaquín amo mocahua pa yulis. Quema, huan in pan hual nehual nía nicmaca, in unca nocuerpo inacal, pa yoje moxtin pin lalticpan quipiasi Dios iyulilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Inminhueyenten in judíos molaxilije lajtomes se ca oc se, moilijticate: —¿Quinami huil in lacal techmaca inacal icuerpo pa tijcuasi? ");
INSERT INTO nclNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Cuaquín Jesús quinmilic: —Neli, neli annimitzilía, sinda amo anquicua inacal nocuerpo nehual ilacal in cielo, huan sinda amo ancuni noesli, cuaquín amo anquipías Dios iyulilisli laijtic amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yihual hual quicua nocuerpo inacal huan cuni noesli, unca yihual hual quipía Dios iyulilisli hual amo quiman lamis. Huan nehual nicyuliltis pa in tonali quiman lamis in lalticpan hual axan unca. ");
INSERT INTO nclNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nocuerpo inacal neli unca quinami len quicua huan noesli neli unca quinami len cuni se. ");
INSERT INTO nclNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Unca quinami yuli laijtic nehual yihual hual quicua nocuerpo inacal huan cuni noesli. Nicnequi niquijtúa yihual yuli pan ipampa noyulilisli huan nehual niyuli laijtic yihual. ");
INSERT INTO nclNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nechtilanic Dios noTajtzin hual yuli, huan nehual niyuli pan ipampa Dios noTajtzin. Pampín yoje yulis pan nopampa nehual aqui yes hual nechcuas. ");
INSERT INTO nclNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nehual niunca in pan hual quisac pin cielo huan temuc ca niquic. In pan amo unca quinami in pan hual quisac pin cielo hual quicuaje anmotajtzitzían huan miquije. Aqui hual quicua in pan hual niquijtutica amo quiman mocahuas pa yulis. ");
INSERT INTO nclNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Innojen lajtomes quinmilic pin tiopan nepa Capernaum capa lamaxtiaya. ");
INSERT INTO nclNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Quicaquije inon míac ca imonextilinijmes huan quijtuje: —Innojen lajtomes lacualantilo huan ejꞌetiaxticate pa ticmatisi len quinequilo quijtulo. Amaqui quinequis quicaquis, amo huil quimati se len quinequilo quijtulo. ");
INSERT INTO nclNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Quimatic Jesús laijtic yihual quinami molaquetzililoaya imonextilinijmes inahuac len quinmiliaya huan amo quixtocaloaya len quilic. Pampín quinmilic: —¿Amo anquixtoca in hual annimitzilic? ");
INSERT INTO nclNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Cuaquinon, ¿len anyahui anquijtúa pin tonali annechitas nehual ilacal in cielo nilejcutica ca capic nicatani nepa pin cielo quiman ayamo nihualac pan lalticpan? ");
INSERT INTO nclNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Xicmatican pampa unca in Espíritu hual layuliltía. Se inacal icuerpo amo lapalehuía nindeno pa layuliltis. In lajtomes hual annimitzilic quiyuliltilo se iyolo huan in yulilisli huejcahuas, amo quiman lamis. ");
INSERT INTO nclNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ma yoje, sequin ca amhuanten amo annechneltoca. Quinmilic Jesús inon, pampa yihual quinmiximatic quiman pehuac itequipanulisli yehuanten hual amo quineltocaje. Huan quimatic aqui yahuiaya quitemaca ca yehuanten hual quinequiloaya quimictilo. ");
INSERT INTO nclNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Huan quinmilic: —Pampa inon annimitzilic amaqui huil huala ca nehual sinda Dios noTajtzin amo quimacahuiltía. ");
INSERT INTO nclNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Quinmilic inon, mocuepaje míac ca imonextilinijmes, yajmo quitocaje. ");
INSERT INTO nclNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Cuaquinon Jesús quinmilic in doce imonextilinijmes hual mocahualoaya, quinmilic: —¿Amhuanten noje anquinequi anmohuica? ");
INSERT INTO nclNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Quinanquilic Simón Pedro, quilic: —Tata, ¿ca aqui tiasi? Tehual tiquinpía lajtomes hual layuliltilo ca Dios iyulilisli hual amo quiman lamis. ");
INSERT INTO nclNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Huan tehuanten timitzneltocaje huan ticmatilo pampa tehual tiunca in se hual Dios quilajtultic pa technextilis quinami lajtúa Dios pa iyolo. ");
INSERT INTO nclNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús quinanquilic: —Annimitzlajtultic amhuanten doce huan se ca amhuanten unca iyaxca in lili, quitequipanuilía in lili. ");
INSERT INTO nclNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ca in lajtomes yihual quinequiaya quijtu pampa Judas ixolol Simón Iscariote yec iyaxca in lili. Yihual se ca in doce imonextilinijmes, huan yihual in se hual yahuiaya quitemaca Jesús ca yehuanten hual yahuiloaya quimictilo. ");
INSERT INTO nclNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Panuc inon, panujtiahuiaya Jesús pa míac caltilan pin lalticpan Galilea. Yajmo quinequiaya panu pin lalticpan Judea pampa quitemuloaya quinami huil quimictilosquiaya inminhuejueyenten in judíos. ");
INSERT INTO nclNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ma yoje, ajsitihualaya inminfiesta (ilhuil) in judíos itoca in fiesta quiman chantilo pin caltzindis. ");
INSERT INTO nclNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yoje, Jesús icnían quilije: —Ximohuica, amo ximocahua nican, xía pa Judea, pa yoje quitasi momonextilinijmes hual cate nepa innojen hual tiquinchía, hual pampa innojen mahuisulo momajtiticate moxtin. ");
INSERT INTO nclNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Xicchía yoje, pampa sinda se quitemúa quinami huil quinmachiltía moxtin inahuac yihual, yihual amo quiman yahui quinlatilía in hual quichía. Tiquinchía innojen hual quinlamahuisultilo momajtiticate in lacames. Axan, xiquinchía inminlaixpan moxtin. ");
INSERT INTO nclNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yojque quilije icnían pampa yehuanten noje amo quineltocaloaya pampa Dios quilajtultic pa temus pa in lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Cuaquinon Jesús quinmilic: —Ayamo monequi pa nehual nías nipanquisas ca ompic, pampa ayamo ajsic in tonali. Pa amhuanten mojmosta unca in tonali. ");
INSERT INTO nclNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Yehuanten pin lalticpan amo huil quinequilo anmitzmictilo. Ma yoje, nehual quinequilo nechmictilo, pampa niquinmilía neli quinami amo unca cuali in hual yehuanten quichihualo. ");
INSERT INTO nclNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Amhuanten xiacan pa in fiesta (ilhuil). Nehual ayamo nías pa in fiesta pampa ayamo ajsic notonali. ");
INSERT INTO nclNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yoje, lamic quinmilic inon, yihual mocahuac nepa Galilea. ");
INSERT INTO nclNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Quiman uyaje icnían pa in fiesta (ilhuil), yihual quichiaya je nadita, cuaquinon noje uyac. Ma yoje, amo quimacahuiltic pa oc sequin quitasi yihual yajtataya pan tonali hual uyac, quinami quinmolatilijtiahuiaya. ");
INSERT INTO nclNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Huan quitemuloaya Jesús in huejueyenten judíos nepa pin fiesta (ilhuil), quililoaya: —¿Capa unca in se? ");
INSERT INTO nclNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Huan quitenehualoaya in míac lacalera inahuac yihual, molaxilijtinemiloaya lajtomes. Sequin inminhuían moililoaya, quijtuloaya: “Cuali in lacal.” Oc sequin quijtuloaya: “Amo unca cuali. Yihual neli quincuajcuamana moxtin.” ");
INSERT INTO nclNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ma yoje, amaqui quipiaya iyolo chicahuac pa laquetzas yoje inminlaixpan moxtin. Momajtiloaya, amo quinequiloaya pa quincaquisi in huejueyenten judíos. ");
INSERT INTO nclNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Cuaquinon quiman panuje ilajco inmintonalijmes in fiesta, panquisac Jesús pa in tiopan hué huan lamaxtiaya. ");
INSERT INTO nclNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Pampa inon, mahuisuloaya momajtitataloaya in huejueyenten judiós, quilije: —¿Quinami quimati lanextilía in se? Amo quiman cataya ca tolamaxtinijmes huejué. ");
INSERT INTO nclNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Quinnanquilic Jesús, quinmilic: —In hual nicmaxtitica amo unca nolajtomes nehual, unca ilajtomes yihual hual nechtilanic. ");
INSERT INTO nclNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Sinda se quinequi quichía len Dios quinequi, yihual quimatis sinda unca Dios ilamaxtilisli in hual nicmaxtitica, o sinda nehual nilajtutica ca nolajtomes nehual nohuían. ");
INSERT INTO nclNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Se quinmilía lacames yihual ilajtomes, sinda yihual quitemuá pa lacames lajtusi niman cuali inahuac yihual. Amo yoje se lacal melahuac. Yihual quitemúa quinami huil quinlaquetzaltis cuali lacames inahuac yihual hual quitilanic pa hualasquiaya lajtu. Amo unca nindeno calica se quijlacultis se lacal melahuac quinami yihual. ");
INSERT INTO nclNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Pa yina Moisés quinmacac anmotajtzitzían Dios ilajtol. Ma yoje amo unca se ca amhuanten hual quineltoca. ¿Leca anquitemujtica quinami annechmictis? ");
INSERT INTO nclNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Quinanquilije innojen míac lacames, quilije: —Tehual ticpía se ijyecal hual mitzijlacúa. ¿Aqui quitemujtica quinami huil mitzmictis? ");
INSERT INTO nclNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Lananquilic Jesús, quinmilic: —Nicchíac se lachihualisli huan pampa inon anmoxtin anmahuisuaya anmomajtitataya. ");
INSERT INTO nclNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés anmitzijcuiluilic in lajtol hual quijtúa pa anquitzontequía nadita inmincuilaxli anmoxolomes lacames quiman yes lacatilo. Moisés amo anmitzmacac in lajtol. Cataloaya anmotajtzitzían hual yulinijme pa yina míac xixihuimes quiman ayamo lacatic Moisés, yehuanten anmitzmacaje in lajtol. Huan pan tonali hual in lajtol quijtúa pa anmosehuis, ma yoje anquinchihuilía anmoxolomes quinami quijtúa in lajtol. ");
INSERT INTO nclNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Axan, inon anquichihuilía se pan tonali chicome (siete) quiman anmosehuía pa yoje anquineltocas cuali Moisés ilajtol. Ma yoje, nehual, nicpajtic se lacal mochi icocolisli pan tonali chicome, huan pampín ancualantica ca nehual. ");
INSERT INTO nclNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Monequi pa anlaijnamiquis quinami Dios laijnamiquía pa anquimatis sinda len unca cuali o amo cuali. Amo xiquijtucan unca cuali o amo cuali pan ipampa quinami amhuanten anmohuían anquijtúa unca cuali o amo cuali se lachihualisli. ");
INSERT INTO nclNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Cuaquinon sequin ca yehuanten hual yuliloaya pa Jerusalén molajlanije: —¿Amo unca in se yihual hual quitemujticate quinami huil quimictisi? ");
INSERT INTO nclNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Huan ¡xiquitacan! Nepa laqueztica inminlaixpan moxtin huan amo unca se lacal hual quijtúa len pa quitzacuasi yihual. ¿Yes quimatisi in huejueyenten pampa in lacal in Cristo? ");
INSERT INTO nclNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ma yoje, tehuanten ticmatilo in caltilan capa quisac in lacal. Nesis in Cristo, amaqui, quil, quimatis capa quisas. ");
INSERT INTO nclNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yoje, tzajtzic Jesús pin tiopan hué capa lamaxtitataya, quinmilic: —¡Annechiximati huan anquimati noje capa niquisac! Huan amo nihualaya pan ipampa nel nolahueliltilisli huan nolajtol. Unca yihual Dios in melahuac hual nechtilanic, huan yihual amo anquiximati. ");
INSERT INTO nclNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nehual, quema, niquiximati, pampa niquisaya capa yihual unca. Unca yihual hual nechtilanic. ");
INSERT INTO nclNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yoje, pehuaje ajsije pa quiquitzquilosquiaya. Ma yoje, amo cataya se lacal hual quilalic ima ipan, pampa ayamo ajsic itonali pa miquis. ");
INSERT INTO nclNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ma yoje, ca in lacalera cataloaya míac hual pehuaje quineltocaje pampa yihual in Cristo, quilije: —Neli in se in Cristo. Amaqui quinchías in míac quinami yihual quinchía. Innojen technextililo quinami yihual quipía Dios ichicahualisli. ");
INSERT INTO nclNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Quicaquije in fariseos quinami in lacames laqueztataloaya ixtacayito innojen lajtomes inahuac Jesús. Pampín innojen fariseos huan tiopistas huejué quintilanije ipiscales in tiopan hué pa quiquitzquilosquiaya Jesús. ");
INSERT INTO nclNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ma yoje, Jesús laquetzaya inminlaixpan moxtin, quinmilic: —Nicayas jan nadita ca amhuanten, cuaquín nías capa aqui nechtilanic. ");
INSERT INTO nclNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Annechtemus, huan amo annechitas. Huan capa nicayas, amhuanten amo huil anajsis. ");
INSERT INTO nclNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","In judíos moilije se ca oc se: —¿Ca capic yas in lacal pa camo tiquitasi? ¿Yas ca capic cate in judíos hual mosemananijme cajcapa ca yehuanten hual lajtulo griego? ¿Yahui quinmaxtía in griegos? ");
INSERT INTO nclNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Len quinejquijtu in lajtol hual yíal quilic: “Annechtemus, huan amo annechitas. Huan capa nicayas, amhuanten amo huil anajsis”? ");
INSERT INTO nclNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Cuaquinon ajsic in tonali hual lamiaya in ilhuil (fiesta), cataya itonali niman hué in fiesta. Pa in tonali moquetzac Jesús, quintzajtzilic in lacames, quinmilic: —Sinda se quinami amiqui pa iyolo, ma huala ca nehual, huan ma caya quinami launtica. ");
INSERT INTO nclNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Aqui yes nechneltoca, ca yihual yes quinami quisas pa iyolo in se míac ajꞌatenco ca al hual quimacas yulilisli, quinami quijtúa Dios ilajtol lajcuiluli. ");
INSERT INTO nclNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesús quijtuaya inon inahuac in Espíritu Santo hual yahuiaya calaqui pa inminyolo yehuanten hual yahuiloaya quineltocalo Jesús. Ma yoje, ayamo hualaya in Espíritu Santo, pampa Jesús ayamo yec lalalili capa yahuiaya cana in niman míac lasojlalisli hual amo lami. Dios ayamo quilalic Jesús nepa. ");
INSERT INTO nclNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Axcan, sequin ca in lacalera, quiman quicaquije inon hual quijtuc Jesús, quijtuje: —Neli in se Dios ilajtuni hual yahuiaya huala pan lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Oc sequin quijtuje: —In se in Cristo. Ma yoje, sequin quijtuje: —Amo yoje, pampa amo yes galileteco in Cristo. ");
INSERT INTO nclNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Amo quijtúa Dios ilajtol lajcuiluli pampa in Cristo yes imiahuil David huan lacatis pa Belén, in caltilan hual yec iyaxca David? Quema, yoje quijtúa. ");
INSERT INTO nclNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Pampa inon in míac ca yehuanten amo molaliloaya innahuac ca in hual quijtuloaya inahuac Jesús. ");
INSERT INTO nclNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Huan sequin quinequiloaya quiquitzquilo. Ma yoje, amo cataya se lacal hual quilalic ima ipan pa quiquitzquis. ");
INSERT INTO nclNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Cuaquinon mocuepaje in piscales ca in tiopistas huejué huan in fariseos. Huan in tiopistas huejué huan in fariseos quinmilije: —¿Leca amo anquiquitzquic pa anquihualicasquiaya? ");
INSERT INTO nclNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Quinnanquilije in piscales, quinmilije: —¡Amo quiman cataya se lacal hual yoje lajtuc quinami in lacal! ");
INSERT INTO nclNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Quinnanquilije in fariseos: —¿Amhuanten noje anunca lacuajcuamanali? ");
INSERT INTO nclNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Amo unca amaqui ca in huejueyenten huan ca in fariseos hual quineltocalo. ");
INSERT INTO nclNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Quema, in míac lacalera quineltocalo. Ma yoje, yehuanten in lacalera amo quimatilo nindeno inahuac in lajtol. Ejꞌelehuis cate. ");
INSERT INTO nclNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Cataya nepa Nicodemo, yihual yec se ca in huejueyenten. Cataya yihual hual hualac capa Jesús pa layúa. Yihual quinmilic: ");
INSERT INTO nclNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Quinami quijtúa tolajtol, amo tictilanilo se lacal pa yes lacocoltili pampa quichíac in amo cuali sinda ayamo tijcaquije len yihual quijtúa inahuac in hual quichijtica. ¿Amo unca yoje? ");
INSERT INTO nclNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Quinanquilije: —¿Tehual noje, tigalileteco elehuis? Xictemu huan ticmatis pampa amo unca se ca Dios ilajtunijmes hual lacatic huan yuliaya pa Galilea. ");
INSERT INTO nclNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Huan moxtin yehuanten uyaje sejse huan sejse pa ichan. ");
INSERT INTO nclNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Huan uyac Jesús pa iLoma (tepetzindi) in Olivos. ");
INSERT INTO nclNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Mostatica ca huajtzinco, calaquic oc sejpa pin tiopan hué. Moxtin in lacames hualaje capa yihual, huan molalic Jesús, quinmaxtiaya. ");
INSERT INTO nclNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","4","Huan inminlamaxtinijmes in lajtol hual quineltocalo judíos huan in fariseos quihualicaloaya se sihual capa Jesús. Quiquitzquije in sihual monilujtataya ca se lacal hual amo ilahuical. Quilalije in sihual lajco ca yehuanten, huan quilije Jesús: —Lamaxtini, in sihual ticajsije monilujtataya ca se lacal amo ilahuical. ");
INSERT INTO nclNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Axcan, pa ilajtol, Moisés quijtuc pa ticlaxililosquiaya ca tixcalazos yehuanten quinami in se. Axan, tehual ¿len tiquijtúa pa ticchihuilisi in sihual? ¿Ticmictisi ca tixcalazos? ");
INSERT INTO nclNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Inon quilije pa quichihuasi pa Jesús quipías pa quichías o quilis len calica huil quimotexpahuililosquiaya. Cuaquín mopachuc Jesús, lajcuiluc ca ixerixa pan lali. ");
INSERT INTO nclNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Huan quinami quilajlaniloaya huan mocuepaloaya quilajlanilo, Jesús moquetzac, quinmilic: —Aqui yes ca amhuanten hual unca chipahuac pa iyolo huan amo unca laijlaculi, ma pehua quilaxili se tixcali. ");
INSERT INTO nclNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Huan oc sejpa mopachuc, huan ca ixerixa lajcuiluaya pan lali. ");
INSERT INTO nclNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Yehuanten, quiman quicaquije inon, pehualoaya quisalo sejse huan sejse. Pehualoaya quisalo lacames hual quipiaje míac xixihuil quiman lacatije, cuaquinon quisaloaya yehuanten hual yajyancuic. Quimatiloaya laijtic yehuanten moxtin quinami cataloaya laijlaculi pa inminyolo. Cuaquinon, mocahuac Jesús ihuían huan in sihual nepa capa cataya lajco ca yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Cuaquinon Jesús moquetzac, quilic in sihual: —Nito, ¿capa cate? ¿Amaqui quijtuc pampa ticpía pa tiyes lamictili? ");
INSERT INTO nclNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Huan in sihual quilic: —Amaqui, Tata. Cuaquín Jesús quilic: —Nehual noje amo niquijtus pampa ticpía pa timiquis. Axan, xía huan yajmo xiyuli ticchijtica laijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Oc sejpa quinlaquetzilic yehuanten Jesús, quinmilic: —Nehual niquinlahuía yehuanten pin lalticpan. Niquijtúa, unca pampa niquinmaca lahuilisli pa iyolo aqui yes hual nechtoca. In se amo yulis quinami se hual nejnemi capa laticumac pan se ojli hual amo quiximati. Yihual quimatis canas Dios iojli. Yihual yulis ca Dios iyulilisli hual unca quinami lahuilisli hual quiyuliltía se iyolo huan iyulilisli hual cate quinami micticate. ");
INSERT INTO nclNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Cuaquinon quilije in fariseos: —Inon hual tiquijtutica amo unca melahuac, pampa tehual mohuían tiquilic. Amo ticpía se hual mitzpalehuis quijtutica len unca neli monahuac tehual. ");
INSERT INTO nclNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Quinnanquilic Jesús, quinmilic: —Mas que san nehual niquijtúa neli nonahuac nel nohuían, ma yoje in hual niquijtúa unca melahuac. Nicmati capa nihualaya huan ca capic nía. Yoje, unca melác in hual niquijtúa. Amhuanten amo anquimati capa nihualaya huan ca capic nía. ");
INSERT INTO nclNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Amhuanten anlajlanía pa anquimatis huan anquimaca iojli se yoje jan quinami laijtic amhuanten anquita san. Huan nel amo nicmaca iojli amaqui. ");
INSERT INTO nclNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Quema, huan sinda nicmaca iojli, ma yoje unca melahuac quinami nicmaca iojli. Unca melahuac pampa amo nicmaca iojli nohuían. Dios noTajtzin hual nechtilanic, huan yihual ticmacalo iojli tiomenten. ");
INSERT INTO nclNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Huan mocahua lajcuiluli pa anmolajtol sinda omenten quijtulo pampa unca neli len yes, cuaquín moxtin quipialo pa quineltocasi quinami neli. ");
INSERT INTO nclNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nehual nilajtúa neli nonahuac nehual huan inahuac noTajtzin hual nechtilanic, yihual lajtúa neli nonahuac nehual. ");
INSERT INTO nclNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Cuaquinon quilije: —¿Capa unca moTajtzin? Jesús quinnanquilic: —Amo annechiximati nehual huan amo anquiximati noTajtzin. Sinda annechiximatiaya nel, cuaquín noje anquiximatiaya noTajtzin. ");
INSERT INTO nclNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Innojen lajtomes quijtuc Jesús calijtic capa cajcoquiloaya in tomin pin tiopan hué, cataya nepa capa lamaxtiaya. Huan amaqui quiquitzquic, pampa ayamo ajsic in tonali pa yes laquitzquili. ");
INSERT INTO nclNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Cuaquinon oc sejpa laquetzac inminlaixpan, quinmilic: —Nía nimohuica huan amhuanten annechtemus. Ma yoje, anmiquis anquinpixtica anmolaijlaculisli hual anmitzijlacúa, anmiquis laijlaculi. Amhuanten amo huil anajsis capa nehual nías. ");
INSERT INTO nclNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Pampa inon, moilije in judíos: —¿Yahui momictía huan pampín techilijtica: “Amo huil anajsis capa nehual nías”? ");
INSERT INTO nclNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Huan Jesús quinmilic: —Amhuanten anunca iyaxca in lalticpan nican hual unca itzindan in cielo (ilhuicac). Huan nehual niunca iyaxca in cielo hual pa pani. Amhuanten anunca iyaxca in lalticpan capa mochi unca laijlaculi. Nehual amo niunca iyaxca in lalticpan nican. ");
INSERT INTO nclNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yoje, annimitzilic amhuanten anmiquis laijlaculi, Dios amo anmitzanas. Unca pampa sinda amo annechneltoca nehual in se hual niunca quinami Dios hual nechtilanic pa nihualas nican, cuaquinon anmiquis laijlaculi, anyahui anmiqui anquipixtica anmolaijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Cuaquinon quilije: —¿Aqui tehual, nuso? Jesús quinmilic: —Nehual niaqui hual annimitzilic quiman nipehuaya annimitzlaquetzili. ");
INSERT INTO nclNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nicpía míac pa niquijtus huan míac calica annimitzmacas anmoꞌojli amhuanten pampa anunca laijlaculi. Huan yihual hual nechtilanic unca melahuac, huan nehual niquinmilía yehuanten pin lalticpan innojen lajtomes hual nijcaqui yihual nechilía. ");
INSERT INTO nclNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Amo quimatije pampa Jesús quinlaquetziliaya inahuac Dios iTajtzin. ");
INSERT INTO nclNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Pampín Jesús quinmilic: —In tonali quiman yes annechajcoquis nehual ilacal in cielo pa annechmictis, yoje pampa inon Dios nejchías hué. Cuaquín anquimatis pampa neli niunca yihual hual Dios quitilanic. Nehual niunca, huan anquimatis quinami amo nicchía nindeno pan nopampa nehual nohuían. No, jan quinami nechmaxtía Dios noTajtzin, yoje inon niquijtúa. ");
INSERT INTO nclNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Unca ca nehual yihual hual nechtilanic pa nicmachiltis ilajtol. Huan amo nechcahuas, pampín amo nicayas nohuían. In unca pampa nehual amo nimocahua pa niquinchías innojen hual quipaquiltilo. ");
INSERT INTO nclNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Quinmilic Jesús innojen lajtomes, cataloaya míac ca inminhuejueyenten in judíos pehuaje quineltocaje pampa yihual yec in lacal hual mojmosta quinmiliaya pampa yec. ");
INSERT INTO nclNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yoje, Jesús quinmilic inminhuejueyenten in judíos hual axan quineltocatataloaya, quinmilic: —Sinda ancayas anquineltocatías in hual niquijtúa, cuaquinon neli anunca amhuanten nomonextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Huan anquimatis len unca melahuac inahuac Dios. Huan inon hual unca melahuac anmitzmacahuas pa camo anquineltocas Satanás iislacatilisli huan anmitzmacahuas pa camo anpolehuis pampa anyec laijlaculi. ");
INSERT INTO nclNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Quinanquilije: —Tehuanten imiahuimes Abraham, huan ayamo quiman tiyeje itequipanujquimes se toteco hual amo techlaxlahuiaya. Axan, ¿quinami titechilía ticayasi lamacahuali? ");
INSERT INTO nclNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Quinnanquilic Jesús: —Neli, neli annimitzilía, mochi sejse hual cayas quichijtica len hual quijlacúa, yoje yihual unca itequipanujquil se teco hual quichihualtía laijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Huan se tequipanujquil amo mocahuas yes iyaxca iteco quinami unca ixól iteco. Ma yoje, se ixól, quema, mocahuas yes ixól itajtzin. ");
INSERT INTO nclNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Yoje, sinda ixól in se anmitzilis pampa yihual anmitzmacahua, cuaquín neli unca pampa anunca lamacahuali quinami ixól in se. Yajmo anunca tequipanujquimes amo lalaxlahuili. ");
INSERT INTO nclNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nicmati pampa amhuanten anunca imiahuimes Abraham. Ma yoje, anquitemujtica quinami annechmictis. Inon anquichía pampa pa anmoyolo amo anquinequi anquineltoca inon hual niquijtúa anmonahuac amhuanten. Ma yoje, unca melahuac. ");
INSERT INTO nclNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nehual annimitzlaquetzilía inminahuac innojen hual niquinmitac nepa capa nicataya ca Dios noTajtzin nehual, huan amhuanten noje anquinchía innojen hual anquincaquic inahuac anmotajtzin amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Quinanquilije yihual, quilije: —Totajtzin yihual Abraham. Jesús quinmilic: —Sinda Abraham cataya anmotajtzin, cuaquín anquichihuaya len quichihuani Abraham. ");
INSERT INTO nclNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Axan anquitemujtica quinami annechmictis nehual hual niunca lacal hual annimitzilic len unca melahuac, inon hual nijcaquic nechilic Dios. Abraham amo lachihuani quinami amhuanten. Yihual quineltocani Dios huan quipilini lasojlalisli yehuanten hual quilije Dios ilajtol. ");
INSERT INTO nclNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Amhuanten anquichía quinami quichía anmotajtzin. Quilije: —Amo tilacatije inminpampa lacames hual amo monamictije huan hual amo quimolancuacuetzilije Dios. Ticpialo se toTajtzin, yihual Dios. ");
INSERT INTO nclNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Quinmilic Jesús: —Sinda Dios cataya anmoTajtzin, cuaquín annechlasojlaya, pampa niquisac capa unca Dios huan nihualac pan lalticpan. Amo nihualaya pan nopampa nehual, nihualaya pampa Dios nechtilanic pa nihualas. ");
INSERT INTO nclNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Leca amo anquimati len quinejquijtu in hual annimitzilía? Annimitzilía leca. Unca pampa amo anquinequi anquimacahuiltía pa anmitzpatilis anmoyolo in hual niquijtúa. ");
INSERT INTO nclNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Amhuanten anunca ixolomes in lili, yihual anmotajtzin, huan in amo cuali hual yihual quinequi quichía, noje amhuanten anquinequi anquichía. Quiman pehuac mochi pa axan, in lili yec lamictini. Yihual amo quiman quixtoca len unca melahuac, pampa ca yihual amo moitilía len unca melahuac. Sinda islacati, yoje unca san pampa yihual quinami inon. Quema, yihual quipehualtic islacatilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Huan amhuanten amo annechneltoca pampa annimitzilía len unca melahuac. ");
INSERT INTO nclNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Amo unca se ca amhuanten hual huil lanextilía pampa nel nicchía laijlaculisli. Sinda niquijtúa len unca melahuac, ¿leca amo annechneltoca? ");
INSERT INTO nclNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Aqui hual quipía Dios quinami iTajtzin, yoje yihual quinequi quincaqui Dios ilajtomes. Pampa inon amo anquinequi anquicaqui Dios ilajtomes, pampa amo anquipía Dios quinami anmoTajtzin. ");
INSERT INTO nclNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Innojen huejueyenten ca in judíos quinanquilije: —Unca yoje quinami tiquijtuloaya, tel tisamariteco huan ticpía ijyecal amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús quinnanquilic: —Amo nicpía ijyecal amo cuali. Quema, nicpía lasojlalisli pa Dios noTajtzin, huan amhuanten amo annechlasojla. ");
INSERT INTO nclNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nehual amo nictemujtica quinami nimochías hué nohuían. Unca Se hual quichía inon, huan yihual anmitzmacas anmoꞌojli. ");
INSERT INTO nclNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Neli, neli annimitzilía, sinda se lacal yuli cantica cuali len niquijtúa, cuaquín yihual amo quiman quimatis miquis. ");
INSERT INTO nclNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","In huejueyenten judíos quilije: —Axan ticmatilo pampa tehual ticpía se ijyecal amo cuali laijtic moyolo. Miquic Abraham, huan miquije Dios ilajtunijmes, huan tehual titechilía sinda se lacal yuli cantica cuali len tiquijtúa, amo quiman quimatis len yes pa miquis se. ");
INSERT INTO nclNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Tiquijtúa tiunca niman hué huan totajtzin Abraham hual miquic amo yec yoje hué? ¿Huan Dios ilajtunijmes hual miquije amo yeje yoje huejué? ¿Len timochijtica ca tehual mohuían? ");
INSERT INTO nclNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús quinnanquilic: —Sinda nehual niahuiaya nimochía hué, cuaquín nolahueyilisli amo monotzaya nindeno. Unca noTajtzin hual nejchía hué. Amhuanten anquijtúa yihual anmoDios. ");
INSERT INTO nclNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ma yoje, amo quiman anquiximatiaya huan ayamo anquiximati axan. Nehual, quema, niquiximati. Huan sinda niquijtuaya: “Amo niquiximati”, cuaquín nicataya quinami amhuanten, nislacatiaya. Ma yoje, niquiximati huan niyuli nicantica cuali in hual quijtúa. ");
INSERT INTO nclNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Quipiaya niman míac paquilisli anmotajtzin Abraham, pampa in tonalijmes quiman yulini pan lalticpan, quimatic pampa yahuiaya quita quinami cayasquiaya in tonali hual niahuiaya nicaya nican pan lalticpan. Huan neli quitac, huan pampín quipiaya míac paquilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Cuaquinon in huejueyenten judíos quilije: —Ayamo tiyulic cincuenta xixíl huan ¿tehual tiquitac Abraham? ");
INSERT INTO nclNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús quinmilic: —Neli, neli annimitzilía, nehual niyultataya quiman ayamo lacatic Abraham. ");
INSERT INTO nclNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Cuaquinon quinquitzquije tixcalimes pa quilaxililosquiaya, huan Jesús quinmolatilic, quisac pin tiopan hué huan yoje mohuicac ");
INSERT INTO nclNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Panujtataya Jesús, quitac se lacal pachacal, yoje lacatic. ");
INSERT INTO nclNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Huan Jesús imonextilinijmes quilajlanije, quilije: —Lamaxtini, ¿aqui quichíac laijlaculisli huan pampín lacatic pachacal in lacal? ¿Cataya yihual in se ihuían, o cataloaya itajtzin huan inantzin? ");
INSERT INTO nclNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús quinnanquilic: —Amo cataya in lacal hual quichíac laijlaculisli, huan amo cataloaya inantzin huan itajtzin hual quichihuaje. Jan quipanuc pa yoje pan ipampa yihual moitilisi innojen lachihualisli huejué hual Dios huil quinchía. ");
INSERT INTO nclNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Monequi pa nicayas nicchijtica itequipanulisli Dios hual nechtilanic huan monequi pa nicchijtías quiman unca semilhuil. Ajsitihuala in layúa, cuaquín amaqui huil tequipanúa. Nicnequi niquijtúa, ajsitihualalo tonalijmes hual yajmo nicayas nican. ");
INSERT INTO nclNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Pan mochi in tonalijmes hual niunca nican pan lalticpan, niunca quinami lahuilisli pa yehuanten pin lalticpan. Unca quinami niquinlahuilijtica Dios iojli. ");
INSERT INTO nclNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Lamic quijtuc inon, lachijchac pan lali, quichíac sucuil ca ilachijchal huan ca in sucuil quixahuilic iixtololojmes in pachacal. ");
INSERT INTO nclNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Cuaquín quilic: —Xía ximoixpaca ca al nepa pin lahuajuanali hual itoca Siloé. (Siloé quinequi quijtúa Latilanili.) Yoje uyac in pachacal, moixpacac huan lachixtihualac. ");
INSERT INTO nclNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Cuaquinon, quitaje yehuanten hual chantiloaya inahuac huan yehuanten hual quitanijme quinami molajlanilijtinemini tomin, huan moililoaya: —¿Amo in se yihual hual molalini huan molajlanini tomin? ");
INSERT INTO nclNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Sequin quililoaya: —Unca yihual. Oc sequin quililoaya: —Amo yihual, san nesi quinami yihual. Ma yoje, yihual hual catani pachacal quinmiliaya: —Nehual niunca hual nicataya pachacal. ");
INSERT INTO nclNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Pampa inon quililoaya: —¿Quinami tipajtic pa yoje huil tilachía axan? ");
INSERT INTO nclNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Quinnanquilic in lacal, quinmilic: —In lacal itoca Jesús quichíac sucuil calica quinxahuic noixtololojmes huan nechilic: “Xía ximoixpaca ca al nepa pin lahuajuanali itoca Siloé.” Pampín, níac huan nimoixpacac, yoje nilachixtihualac. ");
INSERT INTO nclNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Huan quilije: —¿Capa unca in se? Quinmilic: —Amo nicmati. ");
INSERT INTO nclNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Quihuicaje inminlaixpan in fariseos in se hual catani pachacal. ");
INSERT INTO nclNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Huan cataya pan tonali chicome (siete) quiman mosehuilo in judíos hual Jesús quichíac in sucuil huan quipajtic in pachacal pa huil lachías. ");
INSERT INTO nclNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Pampín in fariseos noje quilajlanije in lacal oc sejpa quinami pehuac lachíac, huan quinmilic: —Quilalic sucuil pan noixtololojmes huan nimoixpacac huan nilachixtihualac. ");
INSERT INTO nclNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Cuaquinon quilije sequin ca in fariseos: —In lacal amo unca se ilacal Dios pampa amo quimati momajtía tequipanúa pan tonali hual timosehuilo. Oc sequin quinmililoaya: —¿Quinami huil se lacal laijlaculi quinchía innojen hual cate lachihuali hual techlamahuisultilo timomajtiticate? Huan amo cataloaya ca se lajtulisli yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Cuaquinon quilije oc sejpa in lacal hual yajmo yec pachacal, quilije: —¿Len tiquijtúa tehual inahuac yihual? Pampa tehual tiunca hual mitzlachialtic. Quinmilic: —Niquijtúa yihual unca se ilajtuni Dios. ");
INSERT INTO nclNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","In huejueyenten judíos amo quineltocaje inon hual quinmilije inahuac in lacal, amo quineltocaje pampa yec pachacal huan axan lachiaya. Pampín, quinnotzajque itajtzin huan inantzin. ");
INSERT INTO nclNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Quinlajlanije: —¿In se anmoxól huan anquijtúa lacatic pachacal? Axcan, ¿quinami huil lachía nuso? ");
INSERT INTO nclNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Huan lananquilije itajtzin huan inantzin, quinmilije: —Ticmatilo in se toxól huan lacatic pachacal. ");
INSERT INTO nclNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ma yoje, amo ticmatilo axan quinami huil lachía, huan amo ticmatilo aqui quilachialtic. Xiclajlanican yihual, yihual lacal hué, yíal motilanía, yihual huil lajtúa inahuac yihual ihuían. ");
INSERT INTO nclNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Quilije inon itajtzin huan inantzin pampa momajtiloaya inminlaixpan in huejueyenten judíos. Cataya pampa axan quilalije in huejueyenten pa quiquixtilisi pa quiahuac in tiopan aqui yes hual quijtusquiaya Jesús unca in Cristo. ");
INSERT INTO nclNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Pampa inon itajtzin huan inantzin in pachacal quinmilije: “Yihual motilanía, xiclajlanican yihual.” ");
INSERT INTO nclNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Yoje, quinotzaje oc sejpa in lacal hual yajmo yec pachacal, quilije: —Amo xitechcuajcuamana, san ilaixpan Dios xitechili melahuac. Tehuanten ticmatilo in lacal se lacal laijlaculi. ");
INSERT INTO nclNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Huan yihual quinnanquilic: —Sinda yihual se lacal laijlaculi, amo nicmati. In san nicmati: Niyec pachacal huan axan nilachía. ");
INSERT INTO nclNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Quilije: —Cuaquín ¿len mijchihuilic? ¿Quinami mitzlachialtic nuso? ");
INSERT INTO nclNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Quinnanquilic: —Annimitzilic huan amo anquinequiaya anquicaqui. ¿Leca anquinequi anquicaqui oc sejpa? Unca neli amo anquinequi anmochía imonextilinijmes. O ¿cuajnesi quema anquinequi? ¿Pampín anquinequi anquicaqui oc sejpa? ");
INSERT INTO nclNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Cuaquín yehuanten quixijxiculoaya, quilije: —Tehual imonextilini in se. Tehuanten tiꞌimonextilinijmes Moisés. ");
INSERT INTO nclNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ticmatilo Dios laquetzac ca Moisés. In se amo ticmatilo capa pehuac nesic. ");
INSERT INTO nclNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Lananquilic in lacal, quinmilic: —¡Jo, cuaquín, nimolapolultía ca inon! ¡Anquijtúa da amo anquimati capa pehuac nesic huan ma yoje nechlachialtic! ");
INSERT INTO nclNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ticmatilo Dios amo quicaqui yehuanten hual cate laijlaculi sinda molajlanililo len ca yihual. Quema, sinda se quimolancuacuetzilía Dios ca mochi iyolo huan quichía quinami quinequi Dios, cuaquín Dios quicaqui quiman yes quilajlanía. ");
INSERT INTO nclNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Quiman yes pehuac in lalticpan amo quiman cayani lacal hual quilachialtic se lacal hual lacatic pachacal. ");
INSERT INTO nclNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Sinda in lacal amo cataya iyaxca Dios, amo huil quichihuaya nindeno. ");
INSERT INTO nclNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Lananquilije yehuanten, quilije: —Tehual tilacatic jan mochi laijlaculi. Huan tehual ¿tiquijtúa huil titechmaxtía tehuanten? Huan quiquixtije pa quiahuac in tiopan. ");
INSERT INTO nclNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús quicaquic quinami quiquixtije pa quiahuac in tiopan, huan quiman quitac, quilajlanic: —Tehual, ¿ticneltoca yihual hual ilacal in cielo? ");
INSERT INTO nclNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Quinanquilic in lacal: —Huan ¿aqui yihual, Tata, pa yoje nicneltocas? ");
INSERT INTO nclNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús quilic: —Axan tiquitac yihual. Nehual in se hual nilaqueztica ca tehual. ");
INSERT INTO nclNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","In lacal quilic: —Nicneltoca, Tata. Huan quimolancuacuetzilic. ");
INSERT INTO nclNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Cuaquín Jesús quilic: —Nihualaya pin lalticpan pa niquinxilus in lacames pan ipampa quinami niquinmacas inminojli. Cate yehuanten hual quimatilo pampa amo lachialo pa inminyolo. Nihualaya pa niquinlachialtis. Yoje niquinxilúa pa camo cayasi ca yehuanten hual quijtulo laijtic yehuanten pampa lachialo cuali pa inminyolo huan ma yoje amo neli lachialo nepa. Nihualaya pa niquinchihuilis yehuanten quinami pachacames pa inminyolo. ");
INSERT INTO nclNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Quicaquije inon sequin fariseos hual nepa moqueztataloaya, quilije: —Huan tehuanten, ¿tipachacames noje? ");
INSERT INTO nclNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús quinmilic: —Sinda amhuanten ancataya pachacames, cuaquín amo anquipiaya laijlaculisli. Ma yoje, anquijtúa pampa anlachía pa anmoyolo huan amo neli inon. Yoje anmocahua laijlaculi. ");
INSERT INTO nclNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Neli, neli annimitzilía, aqui yes amo calaqui ca ilalapujquil in borregos inminlaijtic, huan ma yoje calaqui ca yoje, cuaquín yihual quinami se hual laꞌanilía, unca quinami laxtequini. ");
INSERT INTO nclNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Huan aqui hual calaqui ca in lalapujquil, yihual in teco, yíal quinmiztía in borregos. ");
INSERT INTO nclNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Yihual hual quiztía in lalapujquil quilapulía in teco. Quitencaquilo in borregos inminteco huan yihual quinnotza iborregos, mochi sejse quinami itoca, huan quinlaicana pa quiahuac. ");
INSERT INTO nclNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Quiman mochi iborregos pa quiahuac cate, cuaquinon laicantía inminteco huan iborregos quitocatialo pampa quiximatilo yihual quinami quinnotza. ");
INSERT INTO nclNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Huan amo quitocasi se hual amo quiximatilo. San cholusi ilaixpan yihual pampa amo quiximatilo yihual quinami quinnotza. ");
INSERT INTO nclNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Quinlaquetzilic Jesús ca in lapuhualisli hual quipiaya se lamaxtilisli lalatili. Ma yoje, yehuanten amo quimatiloaya len quinequiaya quijtu in hual quinmiliaya. ");
INSERT INTO nclNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Cuaquinon, Jesús quinmilic oc sejpa: —Neli, neli annimitzilía nehual niquinami in lalapujquil pa in borregos. ");
INSERT INTO nclNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Pa yina pin tonalijmes hual ayamo niajsiaya pan lalticpan cataloaya yehuanten hual quinmililoaya lacames pampa yehuanten Cristo. Annimitzilía pampa moxtin yehuanten cataloaya quinami laxtequinijmes, yehuanten lacames hual laꞌanililo. Ma yoje, in borregos amo quicaquiloaya pa quintocalosquiaya. Nicnequi niquijtúa, yehuanten hual hualaloaya nechneltocalo amo quicaquiloaya. ");
INSERT INTO nclNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yoje, nehual niquinami in lalapujquil. Pan nopampa, sinda se calaquía, nicnequi niquijtúa, sinda nechneltoca, yoje moitas capa Dios hual cana pa huelitis pan yihual huan yoje yes laquixtili pin polehuilisli ca capic quihuicaya ilaijlaculisli. Yes quinami se borrego huil panúa ca calijtic huan pa quiahuac huan quitas sacal pa quicuas. ");
INSERT INTO nclNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Huala in laxtequini jan pa laxtequis huan pa lamictis huan pa laijlacus. Nehual nihualaya pa yoje lacames quipiasi niman míac in hual Dios quita monequi pa quipías se pa yoje yulis ca paquilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nehual in teco cuali. In teco cuali motemaca pa miquis pa yoje quinpías laquixtili pin polehuilisli iborregos. ");
INSERT INTO nclNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Aqui hual amo unca in teco huan jan unca se hual in teco quilaquehua, yoje yihual amo inminteco in borregos. Pampín, sinda quita hualajtica in coyol, quincajcahua in laquejquil in borregos huan cholúa. Huan in coyol quinhuilantía in borregos huan quinmacajsía pa mosemanasi. ");
INSERT INTO nclNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Yoje quichía aqui yes hual unca lalaquehuali, pampa amo motolinía pa in borregos. ");
INSERT INTO nclNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nehual in teco cuali, huan niquinmiximati yehuanten hual noyaxca. Huan yehuanten hual noyaxca nechiximati nehual. ");
INSERT INTO nclNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Unca jan quinami nechiximati noTajtzin huan nehual niquiximati noTajtzin. Nimotemacas pa nimiquis pa in borregos hual cate in lacames hual nechneltocalo. ");
INSERT INTO nclNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Niquinpía oc sequin borregos hual amo cate ca in laijtic latzacuali, yehuanten hual amo iyaxca Israel. Nicpía pa niquinhualicas pa cayasi ca nehual. Quicaquisi nolajtol huan monechicusi huan mochihuasi jan se ca yehuanten hual ilacames Israel, huan nechpiasi nehual pa inminteco. ");
INSERT INTO nclNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Pampa inon noTajtzin nechlasojla pampa nimotemaca pa nimiquis, pa yoje niyulis oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Amaqui nejchihuilis pa nimiquis. Nehual nohuían nimotemaca pa nimiquis. Nicpía lahueliltilisli pa nimotemacas pa nimiquis, huan nicpía lahueliltilisli pa nicanas noyulilisli oc sejpa. In nicchías pampa yoje noTajtzin nechilic pa nicchías. ");
INSERT INTO nclNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Oc sejpa in huejueyenten judíos amo moililoaya ca se lajtulisli inahuac in hual Jesús quinmilic. ");
INSERT INTO nclNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Huan míac ca yehuanten quililoaya: —Yihual quipía se ijyecal amo cuali laijtic iyolo. Yihual amo quimati in hual quijtutica, yihual quinami yes quichía. ¿Leca anquicactica? ");
INSERT INTO nclNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Oc sequin quililoaya: —Se hual quipía ijyecal amo cuali amo lajtúa ca lajtomes quinami innojen. ¿Huil quilachialtía se pachacal se hual quipía ijyecal amo cuali? ¡Amo quiman huil! ");
INSERT INTO nclNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Cataya cuaquinon in fiesta (ilhuil) quiman quijnamiquiloaya ilayancuiluilisli in tiopan hué pa Jerusalén, huan pa quiahuac cataya sehua. ");
INSERT INTO nclNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Huan nejnentinemiaya Jesús pin tiopan hué, cataya pa se lanejnemijquil hual itocaya Salomón ilanejnemijquil. ");
INSERT INTO nclNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yoje, quiyahualujtihualaloaya in huejueyenten judíos, pehualoaya quililo: —Axan, ¿quichi tonalijmes tía titechcahua amo ticmazticate aqui tehual? Sinda tehual tiunca in Cristo, xitechili ca lajtol calica amo timoixpolulo. ");
INSERT INTO nclNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús quinnanquilic: —Annimitzilic sejpa huan oc sejpa huan amo anquineltocac. Innojen hual niquinchía pan ipampa noTajtzin ilahueliltilisli, innojen anmitznextilía neli pampa nicpía Dios ilahueliltilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ma yoje, amhuanten amo annechneltoca pampa amhuanten amo ca noborregos. ");
INSERT INTO nclNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nechtencaquilo noborregos, huan nehual niquinmiximati, huan nechtocalo. ");
INSERT INTO nclNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Huan nehual niquinmaca Dios iyulilisli hual amo quiman lamis huan yehuanten amo quiman polehuisi. Huan amaqui huil nechquixtilía yehuanten. Unca quinami yehuanten cate pa noma. ");
INSERT INTO nclNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Dios noTajtzin nechmacac yehuanten hual nechneltocalo hual niquijtúa yehuanten noborregos. Huan Dios noTajtzin, yihual in niman hué, amo unca oc se yoje hué. Huan amaqui huil quinquixtilía noTajtzin, unca quinami cate pa ima. ");
INSERT INTO nclNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nehual huan noTajtzin, tehuanten ticate jan se san. ");
INSERT INTO nclNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Oc sejpa quinquitzquije tixcalimes in judíos pa quilaxilisi. ");
INSERT INTO nclNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesús quinmilic: —Cate míac lachihualisli cuajcuali hual annimitznextilic. Huan niquinchíac pampa noTajtzin nechilic pa niquinchíac. ¿Calía ca innojen amo anmitzanac cuali pa yoje anquinequi annechlaxili tixcalimes? ");
INSERT INTO nclNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","In judíos quinanquilije: —Amo timitzmacalo tixcalazos pampa ticchíac len cuali. Unca pampa ticuejuecaltitica Dios. Unca pampa tehual, mas que tilacal san, tiquijtutica pampa tehual Dios. ");
INSERT INTO nclNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesús quinnanquilic: —Unca lajcuiluli pa iamal anmolajtol hual noje unca Dios ilajtol, quijtúa: “Niquijtuc: Amhuanten anunca dioses.” ");
INSERT INTO nclNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Capa Dios quijtuc inon, yoje quinmiliaya ilajtol yehuanten hual quintilanic pa quinmilisi lacames inon. Huan quema, Dios quinmilic yehuanten yeje dioses mas que yehuanten lacames san. Huan monequi pa anquineltocas inon, pampa unca Dios ilajtol lajcuiluli huan amaqui huil quijtúa pampa amo unca melahuac. ");
INSERT INTO nclNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Axan, pa in tonali hual noTajtzin nechtilanic pin lalticpan, nechlalic quinami ilanahuatini. Pampa inon amo unca anmoyaxca pa annechilis niquihuejuecaltitica Dios pampa annimitzilic nehual niunca Dios iXolol. ");
INSERT INTO nclNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Sinda amo niquinchía innojen hual Dios noTajtzin nechtilanic pa niquinchías, cuaquín amo xichneltocacan. ");
INSERT INTO nclNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Huan sinda quema niquinchía innojen, cuaquinon, mas que amo annechneltoca nehual, xicneltocacan innojen cate hual noTajtzin nechmacac pa niquinchías. Xicneltocacan pa yoje anquimatis huan pa ancayas anquimaztica quinami Dios noTajtzin unca nonahuac, huan yihual tiyulticate, nehual niunca inahuac. Yihual laijtic nehual huan nehual laijtic yihual. ");
INSERT INTO nclNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Cuaquinon motolinije pa quiquitzquilosquiaya oc sejpa, huan yihual mijcuantiquisac inminlaixpan yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Uyac oc sejpa ca yoje (analco) in atenco hué Jordán, cataya capa Juan pehuaya lacuayatequi. Nepa Jesús mocahuaya chantitataya. ");
INSERT INTO nclNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Huan ca ompic míac lacames uyaje ca yihual, huan quililoaya: —Neli amo quichíac Juan nindeno hual techmahuisultiaya ca lamajtilisli. Ma yoje, mochi in hual Juan quijtuc inahuac in lacal cataya melahuac. ");
INSERT INTO nclNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Huan míac pehuaje quineltocaje nepa. ");
INSERT INTO nclNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Cataya se lacal cocoxqui, yihual Lázaro hual yulic pin caltilan Betania, in caltilan capa chantiloaya María huan icni sihual Marta. ");
INSERT INTO nclNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Cataya in se María hual quixahuilic in Tata Jesús ca chahuac hual ajuíac, huan quinhuactic icxihuajmes ca itzondi. Quichihuilic inon pin tonalijmes quiman ayamo quimictije Jesús in judíos. Yihual Lázaro in cocoxquil, yihual inmicni María huan Marta. ");
INSERT INTO nclNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Yoje, icnían sihuames quitilanilije Jesús lajtol, quilije: —Tata, quita, yihual cocoxqui, yihual hual ticnequi. ");
INSERT INTO nclNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ma yoje, in tonali Jesús quicaquic in lamachiltilisli hual quitilanilije, quinmilic imonextilinijmes: —In cocolisli amo unca pa yihual miquis. Unca pa quitasi moxtin quinami unca niman hué Dios ilahueliltilisli, pa yoje nehual hual Dios iXól nejchías hué Dios pan ipampa in cocolisli. ");
INSERT INTO nclNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús quinnequic Marta huan icni sihual huan Lázaro. ");
INSERT INTO nclNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ma yoje, pa in tonali hual quicaquic pampa Lázaro cataya cocoxqui, mocahuaya ome tonalijmes nepa capa cataya. ");
INSERT INTO nclNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Cuaquinon, quiman panuje innojen tonalijmes, quinmilic imonextilinijmes: —Ma tiacan oc sejpa pa Judea. ");
INSERT INTO nclNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Quilije imonextilinijmes: —Lamaxtini, in huejueyenten judíos san huipla quinequiloaya mitzmictilo ca tixcalazos. ¿Leca tías ca ompic oc sejpa? ");
INSERT INTO nclNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús quinnanquilic: —Cate doce lajlajco pa se semilhuil, ¿amo yoje? Huan jan yoje Dios quilalic quichi lachihualisli monequi pa nicchías pa se semilhuil. Amo nejtzacuilis nindeno pa camo nicchías mochi hual Dios nechilic pa nicchías. Sinda se nejnemi pa semilhuil, amo motecuas icxían ca se tixcali, pampa lachía pan ipampa in lahuilisli hual quilahuía mochi in lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Huan sinda se nejnemi pa layúa, yoje yahui momañajtía, pampa amo unca lahuilisli pa yihual lachías. Huan sinda unca laticumac laijtic iyolo se, momañajtis pampa ilahuilisli Dios amo quinextilis Dios iojli. ");
INSERT INTO nclNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Lamic quijtuc inon, yihual quinmilic: —Tocni Lázaro cochic axan. Huan nehual nía pa niquejxiltis. ");
INSERT INTO nclNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Cuaquín imonextilinijmes quilije: —Tata, sinda coxtica, cuaquín pajtis. ");
INSERT INTO nclNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesús quinequiaya quijtu pampa miquic Lázaro. Huan quijtuje imonextilinijmes pampa yihual quinlaquetziliaya quinami cochiaya. ");
INSERT INTO nclNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Pampín, quinmilic Jesús ca lajtol calica amo moixpolulosquiaya: —Lázaro miquic. ");
INSERT INTO nclNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Huan unca paquilisli pa noyolo pampa amo nicataya nepa, pampa yoje cataya cuali pa amhuanten. Pampa inon, anyahui anquilalía míac laneltocalisli ca nehual. Ma yoje, ma tiacan capa yihual. ");
INSERT INTO nclNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Cuaquinon Tomás hual noje itocaya Seinomenten quinmilic in oc sequin monextilinijmes, quinmilic: —Ma tiacan noje ca yihual, pa yoje timiquisi ca yihual. ");
INSERT INTO nclNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yoje, ajsiaya Jesús, quilije quinami axan quinpiaya nahui tonalijmes hual Lázaro cataya pin cueva (ostul) capa quilalpachuje. ");
INSERT INTO nclNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania huan Jerusalén amo cate huejca se ca in oc se, quinami cinco (macuili) kilometros. ");
INSERT INTO nclNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Huan míac ca in huejueyenten judíos hualaje ca Marta huan María pa quinlacahualtilisi inmicni Lázaro. ");
INSERT INTO nclNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Huan quiman quimatic Marta pampa ajsitihualaya Jesús, uyac quinamiquic. Ma yoje, mocahuac María molalijtataya pin cali. ");
INSERT INTO nclNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Huan Marta quilic Jesús: —Tata, amo miquiaya nocni sinda ticataya nican. ");
INSERT INTO nclNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ma yoje, axan nicmati len yes ticlajlanis Dios, yihual mitzmacas. ");
INSERT INTO nclNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús quilic: —Mocni yulis oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta quilic: —Nicmati yihual yulis oc sejpa pan tonali quiman lamis in lalticpan hual axan unca. Yulis nepa ca moxtin hual yulisi oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesús quilic: —Nehual in inminlayuliltilisli in mijquimes, nehual in yulilisli. Nehual pan nopampa huil nicyuliltía aqui yes huan quiman yes nicnequi, pampa nicpía yulilisli calica nilayuliltía. Aqui nechneltoca, mas que miquis, ma yoje yihual yulis. ");
INSERT INTO nclNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Huan aqui yes yuli nechneltocatica, yihual amo quiman miquis pa moxilus ilaixpan Dios. ¿Ticneltoca inon hual nimitzilijtica? ");
INSERT INTO nclNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta quinanquilic: —Jo quema, Tata, nehual nicneltoca quinami tehual tiunca in Cristo, tiunca iXolol Dios hual ticchialoaya pa hualas pin lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Huan quiman quilic inon, mohuicac, uyac quinotzac ixtacayito icni María, quilic: —Axan unca in Lamaxtini huan mitznoztica. ");
INSERT INTO nclNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Huan quicaquic inon María, moqueztiquisac, uyac capa Jesús. ");
INSERT INTO nclNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Axan ayamo calaquic Jesús pin caltilan, ayamo mijcuanic capa Marta quinamiquic. ");
INSERT INTO nclNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Pin cali cataloaya ca María sequin huejueyenten judíos hual quilacahualtitataloaya. Cuaquinon, quitaje moqueztiquisac huan quisac. Yehuanten quitocaje, quijtutataloaya yihual yahuiaya pa in cueva (ostul) capa quilalije in mijquil. Quijtuloaya yahuiaya quichoquili umpa. ");
INSERT INTO nclNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Yoje, ajsic capa cataya Jesús quimolancuacuetzilijtiquisac, quilijtica: —Tata, sinda tehual ticataya nican, nocni amo miquiaya. ");
INSERT INTO nclNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Huan Jesús quitaya chocatataya huan quinmitaya in judíos hual hualaloaya ca yihual María, yehuanten noje chocatataloaya. Cuaquín quicocuc iyolo huan laijtic yihual motoliniaya. ");
INSERT INTO nclNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Quinmilic: —¿Capa anquilalic? Quinmilije: —Xihuala huan xiquita. ");
INSERT INTO nclNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Chocac Jesús. ");
INSERT INTO nclNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Cuaquín moilije in judíos: —Xiquitacan quinami yihual quinequic. ");
INSERT INTO nclNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Huan sequin ca yehuanten quilije: —In lacal quilachialtic se pachacal. ¿Leca amo huil quitzacuilic pa camo miquisquiaya in lacal? ");
INSERT INTO nclNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Huan Jesús iyolo quicocujtataya ca icnotilisli, ijyulantic laijtic yihual quiman ajsiaya capa quilalije. Cataya se cueva (ostul) huan se tel quilalilije inahuac pa quitzacuas. ");
INSERT INTO nclNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Quinmilic: —Xiquijcuanican in tel. Marta icni in mijquil quilic: —Tata, axan quisas ijyul. Quipía nahui tonalijmes quiman polehuic. ");
INSERT INTO nclNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús quilic: —Nimitzilic sinda ticneltocas, tiquitas quinami unca hué Dios ilahueliltilisli. ¿Amo tiquijnamiquía? ");
INSERT INTO nclNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Cuaquín quijcuanije in tel. Huan Jesús lachíac pa in cielo (ilhuicac) huan quilic: —Tata, nimijsehuía pampa tichcaquic. ");
INSERT INTO nclNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Huan nicmati tehual amo quiman timocahua pa tichcaquis. Ma yoje, nimitzilic inon pampa yehuanten in míac moquezticate notenco, huan yoje quineltocasi tehual tichtilanic nican pan lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Huan quiman lamic lajtuc yoje, tzajtzic ca lajtol chicahuac, quilic: —¡Lázaro, xihuala pa quiahuac! ");
INSERT INTO nclNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Huan hualac pa quiahuac Lázaro, yihual hual cataya mijquil, ilpitataya ca in tzotzomajli calica quiliarulo in mijquimes, huan pa iixco ilpitataya oc se tzotzomajli. Jesús quinmilic: —Xictomilican pa huil yas. ");
INSERT INTO nclNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yoje, míac ca innojen huejueyenten judíos pehuaje quineltocaje Jesús unca in Cristo, pampa nepa ca María cataloaya huan quitaje in hual quichíac Jesús. ");
INSERT INTO nclNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ma yoje, sequin ca yehuanten uyaje capa in fariseos, quinpuhuilije inon hual Jesús lamic quichíac. ");
INSERT INTO nclNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Pampín, lanahuatije in tiopistas huejué huan in fariseos pa monechicusi moxtin yehuanten, moilije: ¿Len tialo ticchihualo? Pampa in lacal quinchía míac hual quinmahuisultilo ca lamajtilisli moxtin. ");
INSERT INTO nclNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Sinda ticmacahuiltilo pa yahuis yoje, moxtin quineltocasi yihual unca in Cristo. Cuaquín hualasi in romanos huan techquixtilisi tolahueliltilisli huan tolali. ");
INSERT INTO nclNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","50","Cuaquín se ca yehuanten motocaya Caifás, yihual in tiopista hué pa in xihuil, quinmilic: —Amo anquimati nindeno, huan amo anmoijnamiquiltía quinami unca cuali pa amhuanten pa san se lacal miquis pa moxtin, yoje pa camo lamisi moxtin huan tolali. ");
INSERT INTO nclNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Yihual Caifás amo quinmilic inon pan ipampa yihual ihuían. Cataya pampa yihual yec tiopista hué pa in xihuil, pampín yihual quijtutataya Dios ilajtol inahuac Jesús. Ma yoje, amo quimatiaya pampa yihual quijtutataya pampa Jesús yahuiaya miqui pa camo quipíasi pa polehuisi yehuanten pin lali Israel. ");
INSERT INTO nclNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Huan Jesús amo yahuiaya miqui jan pa yehuanten hual iyaxca Israel san. Noje pan ipampa imiquilisli, Dios yahuiaya quinnechicu Dios ixolomes hual mosemanticate pa mochi in lalticpan, pa yoje ixolomes yesi jan se cali san. ");
INSERT INTO nclNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Yoje, pejtataloaya ca in tonali huan pa mochi in tonalijmes hual ajsitihualaloaya, yehuanten molaquetzililoaya quinami yahuiloaya quimictiluililo. ");
INSERT INTO nclNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Pampín yajmo mocahuaya Jesús chantitataya capa huil quitaloaya in huejueyenten judíos. Jan mohuicac pa quiahuac nepa pa se caltilan capa amo cataya huejca in lali capa amaqui chantiaya. In caltilan itocaya Efraín. Nepa mocahuac ca imonextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ajsitihualaya in fiesta (ilhuil) ipascua in judíos, huan míac lacames pa mochi in lalticpan panquisaloaya pa Jerusalén, quinequiloaya ajsilo pin tonalijmes quiman ayamo pehuac in fiesta (ilhuil) pa huil mochipahuasi quinami quijtúa in lajtol hual lamaxtilía quinami monequi pa mochijchihuililo pa huil quimolancuacuetzilisi Dios. ");
INSERT INTO nclNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Innojen lacames quitemuloaya Jesús, moililoaya moqueztataloaya pin tiopan hué, quililoaya: —¿Anquijtúa yihual amo hualas pa in ilhuil? ");
INSERT INTO nclNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Quiman ajsitihualaya in fiesta (ilhuil), lanahuatije in tiopistas huejué huan fariseos sinda calía lacal yes quimatic capa cataya Jesús, quipiaya pa quinlamachiltis in huejueyenten pa yoje huil quiquitzquisi. ");
INSERT INTO nclNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Yoje, ca chicuase tonalijmes yahuiaya ajsi in fiesta (ilhuil) itoca pascua, huan Jesús hualac pa Betania capa cataya Lázaro hual miquic hual Jesús quiyuliltic. ");
INSERT INTO nclNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Huan quichihualoaya nepa se lacualisli. Marta quinlacualtiaya yehuanten pan capa lacualoaya, huan Lázaro cataya se ca yehuanten hual cataloaya ca Jesús lacuajtataloaya. ");
INSERT INTO nclNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Cuaquín María canac se altzindi tetzahuac lachihuali ca nardo puro, quinami lajco kilo, niman ipati. Huan ca inon quixahuilic Jesús icxihuajmes, de umpa quinhuactic icxihuajmes ca itzondi. Yoje, pa mochi in cali quijnecuije quinami ajuíac in altzindi. ");
INSERT INTO nclNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Huan nepa cataya Judas Iscariote. Yihual imonextilini Jesús hual yahuiaya quitemaca Jesús ca yehuanten hual yahuiloaya latilanilo pa quimictisi. Quilic: ");
INSERT INTO nclNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Leca amo quinamacaje in altzindi huan quinmacaje in tomin yehuanten hual amo quipialo? Xiquitacan. In altzindi ipati quinami in tomin hual canalo ye cientos lacames tequipanujticate se tonali. ");
INSERT INTO nclNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas quilic inon pampa yihual yec laxtequini. Amo quilic pampa quinmicniliaya yehuanten hual amo quipialoaya nindeno. Cataya pampa yihual mojmosta quihuicani in xotopa capa quipixtiahuiloaya inmintomin yehuanten. Huan yihual sejpa huan oc sejpa caniliaya tomin pin xotopa hual yehuanten quilalilije laijtic. ");
INSERT INTO nclNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Cuaquín Jesús quilic: —Amo xicmaca tequil. Cataya pampa quinequiaya cajcoqui pa nejxahuilis pin tonalijmes capa ayamo nechlalpachuje. ");
INSERT INTO nclNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Mojmosta anquinpías ca amhuanten yehuanten hual amo quipialo. Ma yoje, nehual amo annechpías ca amhuanten míac tonalijmes. ");
INSERT INTO nclNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Axan, míac lacames judíos amo huejué quimatije Jesús cataya nepa Betania. Pampín hualaje, huan amo jan pa huil quitasi Jesús san. Noje quinequiloaya quitalo Lázaro hual Jesús quiyuliltic oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Pampín, in tiopistas huejué molaquetzililoaya quinami quimictilosquiaya Lázaro noje. Axan míac judíos mocahuaje pa quinneltocasi quinami quinequiloaya in huejueyenten judíos. Axan quineltocaloaya Jesús pampa yihual quiyuliltic Lázaro. ");
INSERT INTO nclNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mostatica monechicuje míac ca yehuanten hual quipialoaya sequin tonalijmes ajsije pa Jerusalén pa in fiesta (ilhuil). Quimatije quinami Jesús ajsitihualaya noje pa Jerusalén. ");
INSERT INTO nclNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Pampín quinmanaje isacayo in palmas huan quisaje pa quinamiquisi, huan tzajtziloaya, quijtutataloaya: —¡Hosana! (In lajtol quinequi quijtúa: “¡Xitejchihuili cuali axcan!”) ¡Ma lajtucan cuali moxtin inahuac yihual hual huala ca in Tata ilahueliltilisli! ¡Yihual ihué Israel! ");
INSERT INTO nclNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Quitac Jesús se burro yancuic, molalic ipan, jan quinami Dios ilajtol quijtuc pa yina inahuac yihual, yoje unca lajcuiluli: ");
INSERT INTO nclNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Amo ximomajtican amhuanten hual anchanti pa Sión. Xiquitacan, huala anmohué capa amhuanten, molalijtica pani ixolol se burra. ");
INSERT INTO nclNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Amo quimatije imonextilinijmes len quinequije quijtuje mochi innojen pa in tonali hual panujtataloaya. Ma yoje, in tonali hual Jesús yuliaya oc sejpa, cuaquinon quimatije. Quijnamiquiloaya quinami cataya lajcuiluli pa Dios ilajtol pampa lacames yahuiloaya quichihuililo innojen lachihualisli. Huan imonextilinijmes quinmitaje yehuanten capa quichihuilije mochi innojen. ");
INSERT INTO nclNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Huan nepa noje cataloaya in míac hual cataloaya ca Jesús in tonali hual yihual quinotzac Lázaro pa quisasquiaya pa quiahuac capa quilalije imijquil, in tonali hual yihual quiyuliltic oc sejpa. Axcan yehuanten quinlaquetzilijtinemiloaya neli inahuac míac oc sequin innojen lachihualisli hual quitaje panuje. ");
INSERT INTO nclNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Pampa inon uyaje pa quinamiquisi Jesús in míac oc sequin, pampa quimatije inon hual Jesús quichihuilic Lázaro. Yoje quimahuisujtiahuiloaya ca lamajtilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pampín, moililoaya in fariseos, quijtuloaya: —Xiquitacan. Yajmo huil ticchihualo nindeno. Quitocaticate moxtin in lacalera pin lali. ");
INSERT INTO nclNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Huan cataloaya sequin lacames griegos ca yehuanten hual panquisaje pa Jerusalén pa quimolancuacuetzilisi Dios nepa pin fiesta (ilhuil). ");
INSERT INTO nclNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Hualaje in griegos capa Felipe, yihual cataya se hual chantiaya pin caltilan Betsaida pin lalticpan Galilea. Quilajlanije quilije: —Tata, ticnequilo tiquitalo Jesús. ");
INSERT INTO nclNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Uyac Felipe, quilic Andrés, huan Andrés uyac ca Felipe huan yehuanten quilije Jesús. ");
INSERT INTO nclNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesús quinnanquilic, quinmilic: —Axan ajsic in tonali hual nel nicanas lahueyilisli hual nejchihuilis niman hué nehual ilacal in cielo. ");
INSERT INTO nclNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Neli, neli annimitzilía inon: Se latocli mocahua jan se san sinda amo huetzis pin lali huan polehuis. Huan sinda quema polehuis, cuaquín ixuas huan quilalis míac. ");
INSERT INTO nclNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Aqui hual quinequi yultía pa yoje canas mochi hual huil cana pa yulis pan lalticpan quinami yihual quinequi, yoje yihual polehuis amo quipixtica in yulilisli hual amo quiman lamis. Huan aqui hual motzacua pa camo yulis yoje, cuaquín yihual quimajcoquilis iyulilisli huan amo quiman quipolus. ");
INSERT INTO nclNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Sinda se lacal, aqui yes, quinequi nechtequipanuilía, ma nechtoca. Huan capa niunca, nepa noje cayas yihual hual nechtequipanuilía. Sinda se lacal aqui yes nechtequipanuilía, cuaquín Dios noTajtzin quichihuilía hué in se. ");
INSERT INTO nclNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Axan nimoita nietiaxtica laijtic noyolo, huan nehual, ¿len nía niquijtúa inahuac inon? ¿Niclajlanis Dios noTajtzin pa yihual nechquixtis pa camo nipanus in miquilisli hual yahui nechpanúa? No, inon amo niclajlanis, pampa nihualac pan lalticpan pa yoje nechpanus, pampín nechajsitihuala in tonali. ");
INSERT INTO nclNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tata, xicchía niman hué motoca tehual. Ximochía niman hué inminlaixpan moxtin, pa quilasojlasi niman míac motoca. Mocactihualac se lajtol pin cielo, quilic: —Nimochíac niman hué, huan oc sejpa nimochías niman hué pa moxtin quilasojlasi notoca. ");
INSERT INTO nclNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Quijtuje pampa comunic in míac ca yehuanten hual nepa moquetzaloaya huan quicaquije. Oc sequin quijtuje: —Lajtuc ca yihual se ilanahuatini in cielo. ");
INSERT INTO nclNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesús quinnanquilic: —Amo mocactihualac in lajtol pa nehual nijcaquis. Mocactihualac pa amhuanten anquicaquis. ");
INSERT INTO nclNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Axan Dios yahui quinmaca ojli yehuanten pin lalticpan, axan Satanás yahui caya laquixtili capa quipía ilahueliltilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Huan nehual niyes lachihuali hué pa in tonali hual nechajcoquisi. Yoje niquinchihuilis pa moxtin hualasi ca nehual, yehuanten pa mochi lali niquinlaneltocaltis pa nechtocasi. ");
INSERT INTO nclNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Inon Jesús quilic, pa yoje quimatisi quinami yahuiaya miqui. ");
INSERT INTO nclNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Pampín, innojen míac lacames quinanquilije: —Quinami techmomaxtililo len quijtúa ilajtol Dios hual quilic Moisés, tijcaquilo quinami quijtúa pampa in Cristo mocahua yultica huan amo quiman miquis. ¿Quinami huil titechilía monequi pa yes laꞌajcoquili pa quimictisi yihual hual cataya inahuac Dios, hual Dios quitilanic pin lalticpan? ¿Aqui unca in ilacal in cielo? ");
INSERT INTO nclNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesús quinmilic: —Jan nadita san nicayas ca amhuanten, nehual hual niquinami lahuilisli pa annimitzlahuis pan Dios iojli. Xiyén quinami yehuanten hual quimatilo nejnemilo pan se ojli mopalejticate ca in lahuilisli. Xicchihuacan inon pa yoje amo anmitzajsis in laticumactilisli. Pampa yihual hual nejnemía capa laticumac amo quimati ca capic yahui. ");
INSERT INTO nclNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Axan anquipía Dios ilahuilisli, inon hual annimitzilía. Xicneltocacan, pa yoje anmochías Dios ixolomes anquipixtica Dios ilahuilisli laijtic amhuanten anmoyolo. Quinmilic Jesús innojen lajtomes, huan cuaquinon moxiluc inminlaixpan yehuanten, quinmolatilic. ");
INSERT INTO nclNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Huan mas que yihual quinchíac inminlaixpan míac lachihualisli hual lanextiloaya quinami yihual neli quipiaya in hual iyaxca Dios, ma yoje amo quineltocaloaya. ");
INSERT INTO nclNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Amo quineltocaloaya pa yoje panus quinami quijtuc inminahuac yehuanten Dios ilajtuni itocac Isaías. Yoje unca lajcuiluli quinami yihual quijtuc: Tata, amaqui quineltocac len ticlamachiltijque. Huan amo unca amaqui hual cataya lanextili quinami unca hué Dios ilahueliltilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Pampa inon amo huil quineltocaloaya, pampa ca oc se lajtol pa iamal Isaías quijtuc: ");
INSERT INTO nclNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Unca quinami Dios quinpachacaruc inmixtololojmes huan quinchihuilic pa camo huil quimatisi len Dios quinequi. Dios quinchihuilic yoje pa yoje yes quinami amo quitasi ca inmixtololojmes, quinchihuilic pa yoje amo quimatisi pa inminyolo, quinchihuilic pa yoje amo quimatisi len quinequi quijtúa pa inminyolo, quinchihuilic pa yoje amo mopalasi quinami amo quineltocaloaya, pampa sinda mopalaloaya, cuaquinon niquinquixtiaya, quilía in Tata, pa inminpolehuilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Innojen lajtomes quijtuc Isaías pampa yihual quitac Cristo ca mochi ilaixpelalisli chicahuac, huan pampa inon Isaías quijtuc quinami quitac Cristo. ");
INSERT INTO nclNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Huan quema, míac ca in huejueyenten judios quineltocaje Cristo. Ma yoje, momajtije inminlaixpan in fariseos, huan pampín amo quililoaya pampa quema, quineltocaje. Sinda quililoaya yoje, cuaquín in fariseos quinquixtiloaya mochi hual inminyaxca pa quichihualosquiaya pin tiopan hué. Yoje yajmo huil calaquiloaya pa se tiopan, huan yoje in míac judíos molaliloaya inminpan. ");
INSERT INTO nclNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Amo quinequiloaya cayalo laquixtili pa camo huil calaquilosquiaya in tiopan hué, pampa quixtocaloaya míac pa lacames lajtulosquiaya cuali inminahuac yehuanten. Pa yehuanten, amo monotzaya pa Dios lajtusquiaya cuali inminahuac. ");
INSERT INTO nclNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Latzajtzilic Jesús, quilic: —Aqui hual nechneltoca amo nechneltoca nehual. Quema, quineltoca yihual hual nechtilanic. ");
INSERT INTO nclNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Huan aqui hual nechita, yihual quiztica aqui hual nechtilanic. ");
INSERT INTO nclNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nihualaya quinami se lahuilisli pin lalticpan, pa yoje aqui yes nechneltoca amo yulis quinami se hual nejnemía capa laticumac. ");
INSERT INTO nclNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Huan sinda aqui lacal yes quicaquía len niquijtúa, huan amo quineltoca, cuaquín nel amo nicmacas iojli. Amo nihualaya pa niquinmacas ojli yehuanten pin lalticpan. Nihualaya pa niquinquixtis pa inminpolehuilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Aqui hual nejxicúa huan amo quineltoca in hual niquijtúa, yihual quipía in hual quimotexpahuilis. Yes in lajtol hual niquijtuc. Pan ipampa in, yihual yes latojtocali pa camo cayas ilaixpan Dios. Polehuis pan tonali quiman lamis in lalticpan hual axan unca, huan amo quiman mocuepas. ");
INSERT INTO nclNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Yoje yes latojtocali pa camo cayas iyampa Dios pampa amo niquijtuc nindeno hual nehual nohuían niquijtuc pa noyolo. Cataya Dios noTajtzin hual nechtilanic, yihual nechmacac lajtol. Ca in niquijtúa huan ca in annimitzilía. ");
INSERT INTO nclNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Huan nicmati ilajtol unca pa nel annimitzlamachiltis huan pa annimitznextilis quinami huil anquipía iyulilisli hual amo quiman lamis. Huan innojen lajtomes hual niquijtúa cate innojen jan quinami Dios in Tata nechilic, huan jan yoje niquinmilía. ");
INSERT INTO nclNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ayamo ajsiaya itonali in fiesta (ilhuil) pascua huan Jesús quimatiaya pampa cataya in tonali capa yes lamictili. Quimatic pampa yahuiaya quisa pa in lalticpan pa mocuepas capa Dios iTajtzin. Amo mocahuaya pa quinnequis yehuanten hual iyaxca huan quinnequiaya ca mochi iyolo. Yoje, quiman calaquic in tonali, mochijchihualoaya pa lacualosquiaya. ");
INSERT INTO nclNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Satanás calaquic pa iyolo Judas Iscariote, ixolol Simón. Yoje yihual yahuiaya quitemaca Jesús ca yehuanten hual yahuiloaya quitilanilo pa quimictilosquiaya. Jesús quimatiaya quinami Dios iTajtzin quimacac yihual Jesús lahueliltilisli pa mochi. Quimatic quinami yihual cayac capa Dios huan umpa hualac pan lalticpan. Huan axan yahuiaya mocuepa capa Dios. Yoje, quiman lamije quicuaje ilacualisli in pascua, moquetzac Jesús, moquixtilic inahuas huan canac se tzotzomajli calica mohuactía se, huan ca inon mocuejtic. ");
INSERT INTO nclNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Cuaquinon quitoyahuac al pa se xicali hué huan pehuac quinpaquilic icxihuajmes imonextilinijmes huan quinhuactic ca in tzotzomajli calica mocuejtic. ");
INSERT INTO nclNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ajsic capa Simón Pedro, hual quilic: —Tata, ¿tía tichpaquilía nehual nocxihuajmes? ");
INSERT INTO nclNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús quinanquilic: —Ayamo ticmati leca nehual nimijchihuilijtica inon. Ma yoje, ca jan nadita ticmatis. ");
INSERT INTO nclNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro quilic: —Amo quiman tichpaquilis nocxihuajmes. Jesús quinanquilic: —Sinda amo nimitzpaquilis, cuaquín amo huil tiyes nomonextilini. ");
INSERT INTO nclNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simón Pedro quilic: —Tata, amo jan nocxihuajmes san. Noje xichpaquili nomajmajuan huan notzontecon. ");
INSERT INTO nclNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesús quilic: —Aqui hual unca laꞌaltili amo monequi pa maltis pa mochi icuerpo, jan pa icxihuajmes san, pampa axan yihual unca mochi chipahuac. Amhuanten anunca chipahuac, ma yoje amo anmoxtin. ");
INSERT INTO nclNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesús quimatic aqui yahuiaya quitemaca ca yehuanten hual yahuiloaya quimictilo. Pampín quinmilic: “Amo anunca chipahuac anmoxtin.” ");
INSERT INTO nclNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Quimpaquilic inmicxihuajmes huan umpa molaquentic ca inahuas. Cuaquín molalic huan quinmilic: —¿Anquimati in hual nilamic annimijchihuilic? ");
INSERT INTO nclNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Annechtocayaltía Lamaxtini huan Tata. Huan yoje annechtocayaltía cuali, pampa nehual, quema, nilamaxtini huan niTata. ");
INSERT INTO nclNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Huan mas que nehual niunca Tata huan Lamaxtini, ma yoje annimitzpaquilic anmocxihuajmes. Pampín, sinda annimijchihuilic yoje, monequi pa amhuanten anquinpaquilis anmocxihuajmes se huan oc se. Nicnequi niquijtúa, monequi pa amhuanten anmotequipanuilis quinami tequipanujquimes moxtin oc sequin ca amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Unca pampa axan annimitznextilic ca in lachihualisli quinami monequi pa anquichías yoje jan quinami nel annimijchihuilic. ");
INSERT INTO nclNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Neli, neli annimitzilía inon: Se tequipanujquil amo unca hué quinami iteco unca hué. Huan aqui hual unca latilanili amo unca hué quinami unca hué aqui quitilanic. ");
INSERT INTO nclNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Anquimati inon. Sinda anyulis quinami quijtulo in lajtomes, yoje anyulis ca paquilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Amo nilaqueztica anmonahuac anmoxtin. Nehual nicmati aquinojen niquinlajtultic. Huan unca se hual niclajtultic hual unca ca tehuanten pa yoje panus quinami quijtúa Dios ilajtol lajcuiluli, quijtúa: “Yihual hual huan nehual tilacuaje, unca quinami nechlaxilic mas que tiyeje quinami icnían.” ");
INSERT INTO nclNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ca nican mosta annimitzilijtica in hual yahui panúa mas que ayamo panuc, pa yoje pa in tonali quiman panus, cuaquín anquineltocas nehual in se hual Dios quitilanic. ");
INSERT INTO nclNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Neli, neli annimitzilía, aqui hual quimosehuilía aqui yes nictilanis, unca quinami yihual nechnamiqui cuali nehual. Huan aqui hual nechnamiqui cuali, neli unca quinami quinamictica cuali yihual hual nechtilanic. ");
INSERT INTO nclNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Lamic lajtuc Jesús yoje, quitzintecuac pa iyolo huan lajtuc pa huil quicaquisi cuali, quinmilijtica: —Neli, neli annimitzilía, se ca amhuanten yahui nechtemaca ca yehuanten hual yalo nechmictilo. ");
INSERT INTO nclNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Moitaloaya imonextilinijmes se ca oc se, quimahuilijtataloaya de aqui quilaquetziliaya. ");
INSERT INTO nclNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Cataya inahuac Jesús se imonextilini huilantataya pa Jesús ilaixpan ihuajcol. (Pa yina yoje lacuanijme huilantataloaya yehuanten inahuac inon capa lacuanijme.) Huan Jesús quinequiaya in monextilini. ");
INSERT INTO nclNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Cuaquín Simón Pedro quilamachiltic ca ima in monextilini pa quilajlanisquiaya Jesús aqui yahuiaya quitemaca. ");
INSERT INTO nclNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Huan huilantiquisac in monextilini pani Jesús ilaixpan huan quilic: —Tata, ¿aqui yihual hual yahui mitztemaca? ");
INSERT INTO nclNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús quinanquilic: —Yihual unca hual nía nicpulactilía in pan huan nía nicmaca. Quipulactic ilajco in pan pin tapalquita, quimacac Judas ixolol Simón Iscariote. ");
INSERT INTO nclNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Canac Judas in pan, cuaquinon Satanás calaquic pa iyolo, quiquitzquic. Cuaquín Jesús quilic Judas: —Xicchía jan ajnaxcan in hual tía ticchía. ");
INSERT INTO nclNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ca yehuanten hual cataloaya nepa lacuajtataloaya, amo cataya se hual quimatiaya leca Jesús quilic inon. ");
INSERT INTO nclNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Sequin quijtuje cataya pampa quipiaya Judas in tomin, huan pampín Jesús quilijtataya pa quincuhuas innojen hual yahuiloaya quinequilo pa in fiesta (ilhuil). O quijtuje pampa quilijtataya pa quimacas len yehuanten hual amo quipialoaya nindeno. ");
INSERT INTO nclNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yoje, canac Judas ilajco in pan, uyajtiquisac. Cataya layúa. ");
INSERT INTO nclNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Quiman quisac Judas, Jesús quinmilic: —Axan, nehual ilacal in cielo niyes lachihuali niman hué. Huan Dios yes lachihuali hué pan nopampa. ");
INSERT INTO nclNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Huan pampa Dios yes lachihuali niman hué pan nopampa, noje yihual nejchías nel niman hué pan ipampa yihual. Nicayas jan quinami yihual Dios. ");
INSERT INTO nclNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nitos, jan nadita nicayas ca amhuanten. Annechtemus, huan ma yoje, quinami niquinmilic in huejueyenten judíos, yoje axan annimitzilijtica, ca capic nías, amo huil anyas amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Annimitzilijtica se lajtol yancuic, unca inon: Ximolasojlacan se huan oc se. Jan quinami nehual annimitzlasojlac, noje amhuanten ximolasojlacan. ");
INSERT INTO nclNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Pan ipampa inon, moxtin quimatisi amhuanten anunca nomonextilinijmes, sinda anmolasojlas se huan oc se. ");
INSERT INTO nclNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro quilic: —Tata, ¿ca capic tía? Jesús quinanquilic: —Amo huil tichtoca axan ca capic nía. Ma yoje, tichtocas innojen tonalijmes hual ajsitihualalo. ");
INSERT INTO nclNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro quilic: —Tata, ¿leca amo huil nimitztoca axan in layúa? Nimiquisquiaya ca tehual. ");
INSERT INTO nclNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Quinanquilic Jesús: —¿Timiquisquiaya ca nehual? Neli, neli annimitzilía, tehual axan in layúa tía tiquilía ca ye lajtulisli pampa amo tichiximati, huan inon tía tiquilía quiman ayamo xahuanis in gallo. ");
INSERT INTO nclNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Ma camo anmitzcocu anmoyolo. Anquineltoca Dios, xichneltocacan nehual noje. ");
INSERT INTO nclNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Pin cielo capa chanti noTajtzin cate míac calimes capa chantisi yehuanten hual nechlasojlalo. Sinda amo cataya yoje pin cielo, cuaquín amo annimitziliaya quinami nía ca ompic pa annimijchijchihuilis capa ancayas. ");
INSERT INTO nclNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Huan sinda nías pa annimijchijchihuilis capa ancayas, cuaquín nihualas oc sejpa pa annimitzanas, pa yoje ancayas amhuanten capa nehual niunca. ");
INSERT INTO nclNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Huan anquimati ca capic nía huan in ojli anquimati. ");
INSERT INTO nclNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás quilic: —Tata, amo ticmatilo ca capic tía. ¿Quinami ticmatisi in ojli? ");
INSERT INTO nclNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Quinanquilic Jesús: —Nehual in ojli hual lahuica capa Dios, amo unca oc se. Nehual niaqui hual niquijtúa mochi hual unca melahuac inahuac Dios. Huan nehual niunca in yulilisli, nicnequi niquijtúa nehual nicmaca moxtin Dios iyulilisli. Amaqui huil ajsis capa Dios sinda amo ajsis pan nopampa nel. ");
INSERT INTO nclNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Sinda annechiximatiaya nehual, noje anquiximatiaya Dios noTajtzin. Quiman anpehuac annechtocac pa axan, annechiximatijtica. Yoje anquiximatis Dios noTajtzin noje. Ca nican mosta anquiximati huan yihual anquitac. ");
INSERT INTO nclNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Felipe quilic: —Tata, xitechnextili Dios toTajtzin, ja in san ticnequilo. ");
INSERT INTO nclNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús quilic: —Míac tonalijmes niunca ca amhuanten huan ma yoje ¿ayamo tichiximati, Felipe? Aqui hual nechitac nel, yihual noje quitac Dios noTajtzin. ¿Quinami tichilía pa annimitznextilis Dios noTajtzin? ");
INSERT INTO nclNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Amo ticlalijtica molaneltocalisli ca in lajtol hual mitznextilía quinami nehual niunca ca Dios noTajtzin huan Dios noTajtzin unca laijtic nehual? Innojen lajtomes hual annimitzilijtica amo niquijtutica ca nolaijnamiquilis nehual nohuían. Unca Dios noTajtzin hual unca laijtic nehual, huan yihual tequipanujtica pan nopampa. ");
INSERT INTO nclNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Xichneltocacan quiman annimitzilía quinami nehual niunca ca Dios noTajtzin huan Dios noTajtzin unca laijtic nehual. O, sinda amo anquineltoca inon, xichneltocacan pan ipampa innojen hual niquinchíac hual quinextiliaya quinami nehual nicpía Dios ilahueliltilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Neli, neli annimitzilía inon: Aqui hual nechneltoca, yihual quinchías noje innojen huejué hual nehual niquinchía. Quema, huan quinchías lachihualisli hual cayasi niman huejué hual innojen hual niquinchíac amo yeje yoje huejué. Huil quinchías pampa nehual nías capa unca Dios noTajtzin. ");
INSERT INTO nclNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Huan len yes pan ipampa notoca ilahueliltilisli anquilajlanis hual nel niquita cuali, cuaquinon annimijchihuilis, pa yoje pan nopampa nel lacames quitasi Dios noTajtzin niman hué. ");
INSERT INTO nclNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Quema, sinda anquilajlanis len yes pan ipampa notoca ilahueliltilisli, cuaquín annimijchihuilis inon. ");
INSERT INTO nclNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Sinda annechlasojla, anquinchías quinami quijtulo nolajtomes. ");
INSERT INTO nclNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Huan niclajlanis Dios noTajtzin huan yihual anmitztilanilis oc se, pa yihual amo quiman anmitzcajcahuas amhuanten. Anmijchicahualtis huan anmitzlaicanas, yihual yes anmolapalehuini. ");
INSERT INTO nclNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Yihual in Espíritu Santo. Mochi hual yihual quijtúa unca melahuac. Yehuanten pin lalticpan quixtocalo yulilo quinami Satanás quinnextilía. Yoje amo huil canalo in Espíritu Santo, pampa amo quitalo huan amo huil quiximatilo. Ma yoje, amhuanten anquiximatis, pampa yihual mocahuas chantitica ca amhuanten huan cayas laijtic amhuanten anmoyolo. ");
INSERT INTO nclNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","No, amo nía annimitzcajcahua quinami xolomes hual amo quipialo inmintajtzitzían. Nimocuepas nihualas ca amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Jan nadita san huan yehuanten pin lalticpan yajmo nechitasi. Ma yoje, amhuanten annechitas pampa niyulis. Huan pampa niyuli, amhuanten noje anyulis. ");
INSERT INTO nclNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Pa in tonali quiman niyulis oc sejpa, anquimatis quinami nehual niunca ca laijtic Dios noTajtzin huan amhuanten anunca ca laijtic nehual huan nehual niunca ca laijtic amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Aqui hual quimati nolajtomes huan yas yultica quinami quijtulo, yoje yihual unca se hual yas nechlasojlatica. Huan aqui hual nechlasojla, yoje noTajtzin quilasojlas, huan nehual niclasojlas huan nicmonextilis yihual. ");
INSERT INTO nclNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Cataya oc se imonextilini itocaya Judas, yihual amo Judas Iscariote, quilic: —Tata, ¿quinami panúa pa tehual titechmonextilis tehuanten huan amo tía tiquinmonextilía yehuanten oc sequin pin lalticpan? ");
INSERT INTO nclNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús quinanquilic: —Sinda se lacal nechlasojla, yihual yulis ca se lajtulisli ca nehual nolajtol hual niquijtúa. Huan Dios noTajtzin quilasojlas yihual huan tehuanten tihualasi capa yihual huan tichantisi laijtic iyolo. ");
INSERT INTO nclNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Aqui hual amo nechlasojla amo yuli ca se lajtulisli ca nel nolajtol hual niquijtúa. Huan in lajtol hual anquicaquic quiman nehual annimitzilic amo unca nehual nolajtol. Unca ilajtol Dios noTajtzin hual nechtilanic ca niquic. ");
INSERT INTO nclNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Innojen lajtomes annimitzilic pin tonalijmes quiman nicataya niyultataya ca amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ma yoje, hualas in Lalacahualtini hual anmijchicahualtis huan anmitzlaicanas, yihual in Espíritu Santo. Huan Dios noTajtzin quitilanis pan ipampa ilahueliltilisli notoca nehual. Yihual in Espíritu Santo anmitzmaxtis mochi, huan anmitzlaijnamiquiltis mochi hual annimitzilic. ");
INSERT INTO nclNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Annimitzcahua anquinpixtica mosehuilisli huan laneltocalisli, huan inon amo cayas quinami in mosehuilisli huan laneltocalisli hual anquinpías sinda anyuliaya quinami quijtulo yehuanten pin lalticpan. Amo huejcahua in mosehuilisli huan laneltocalisli hual iyaxca in lalticpan. Pampín, ma camo anmitzcocu anmoyolo, noje ma camo momajti. ");
INSERT INTO nclNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Annechcaquic annimitzilic nía nimohuica huan nimocuepas nihualas ca amhuanten. Sinda annechlasojlaya, anquipiaya paquilisli, pampa nía ca capic Dios noTajtzin, pampa Dios noTajtzin yihual unca niman hué huan nehual amo yoje hué. ");
INSERT INTO nclNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Axan annimitzilic quiman ayamo panúa, pa yoje quiman panus, amhuanten anquineltocas. ");
INSERT INTO nclNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Yajmo nilaquetzas míac ca amhuanten, pampa huala Satanás, yihual aqui lahueliltía pa moxtin hual amo Dios ilacames. Ma yoje, amo quipía lahueliltilisli nindeno ca nehual. ");
INSERT INTO nclNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Inon nechpanujtica pa yoje quimatisi yehuanten pin lalticpan quinami nehual niclasojla Dios noTajtzin. Huan quinami yihual noTajtzin nechmacac lajtol, jan yoje nicchía. Ximoquetzacan, ma tiquisacan pa quiahuac nican. ");
INSERT INTO nclNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Nehual niquinami icuajmecal uva neli hual Dios quitocac. Huan Dios noTajtzin, yihual quinami iteco icuajmecal uva hual quiztía pa quichijchías. ");
INSERT INTO nclNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Mochi hual itzmolinía ca nehual in icuajmecal uva, Dios quicotona sinda amo quilalía laquilyo. Huan mochi hual itzmolinía hual quema quilalía laquilyo, iteco quichipahua, quipujpuhua pa yoje quilalis míac laquilyo. ");
INSERT INTO nclNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Axan amhuanten anunca chipahuac pan ipampa in lajtol hual annimitzilic. ");
INSERT INTO nclNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Xicayacan anyultica ca nehual annimitzlanextilijtica amhuanten. Huan xichmacahuiltican pa nehual nicayas niyultica laijtic amhuanten. Se itzmolinquil amo huil quilalía laquilyo ihuían sinda amo mocahua ca in icuajmecal uva. Huan jan yoje, amhuanten amo huil anquichía nindeno hual Dios quita cuali sinda amo ancayas anyultica ca nehual annimitzlanextilijtica. ");
INSERT INTO nclNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Nehual niquinami in icuajmecal uva, huan amhuanten in itzmolinquimes. Aqui hual caya yultica ca nehual niclanextilijtica huan jan yoje nechmacahuiltía pa niyulis laijtic yihual, yoje yihual quichías míac hual Dios quita cuali, yes quinami in icuajmecal uva hual quilalía míac laquilyo. Pampa sinda nehual amo niyultica laijtic amhuanten annimitzlanextilijtica, amhuanten amo huil anquichía nindeno hual Dios quita cuali. ");
INSERT INTO nclNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Huan sinda se lacal amo yuli ca nehual niclanextilijtica, yihual yes quinami se itzmolinquil hual huaqui. Quicotonalo huan quilasalo. Quema, quinechiculo huan quilasalo pin tixuxli huan quichichinulo. ");
INSERT INTO nclNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Sinda anyuli ca nehual annimitzlanextilijtica huan sinda anyultía ca nel nolajtomes, cuaquín xiclajlanican Dios len yes anquinequi, huan yihual anmijchihuilis. ");
INSERT INTO nclNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Sinda anquichía míac hual quita cuali Dios noTajtzin, cuaquín ancayas quinami se icuajmecal uva hual laqui míac. Huan yoje yesi lajtuli lajtomes niman hué inahuac Dios noTajtzin. Yoje anyes nomonextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Jan quinami Dios noTajtzin nechlasojlaya, jan yoje annimitzlasojlaya. Xiyulican annechlasojlatica. ");
INSERT INTO nclNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Sinda ancayas anyultica ca nehual nolajtomes, yoje anyulis annechlasojlatica. Ancayas jan quinami nehual. Niyuli ca yihual Dios noTajtzin ilajtomes huan niyuli niclasojlatica. ");
INSERT INTO nclNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Innojen lajtomes annimitzilic pa yoje anquipías in paquilisli hual nel nicpía huan pa yoje anmopaquilisli yes míac huan pa anyulis antentica ca niman míac paquilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Inon nolajtol: Nicnequi pa amhuanten anmolasojlas jan quinami nehual amo nimocahua pa annimitzlasojlas. ");
INSERT INTO nclNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Sinda se miqui pa yehuanten hual quinlasojla pa yoje yehuanten mocahuasi yulticate, cuaquín amo unca oc se lasojlalisli hué quinami inon. ");
INSERT INTO nclNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Amhuanten anunca yehuanten hual niquinlasojla sinda anyuli anquichijtica quinami quijtulo innojen lajtomes hual annimitzilía. ");
INSERT INTO nclNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Yajmo annimitzilía amhuanten anunca notequipanujquimes, pampa amo quimati je tequipanujquil leca quichía iteco len yes quichía. Axcan, annimitzilía amhuanten anunca hual annimitzlasojla pampa annimitzlamachiltic mochi hual nijcaquic nechilic Dios noTajtzin. ");
INSERT INTO nclNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Amhuanten amo anquilalic pa anmochías nomonextilinijmes. Cataya pampa nehual annimitzlajtultic amhuanten. Huan annimitzlajtultic pa anyulis anquinmantica lacames pa nechneltocasi huan pa anquitequipanuilis Dios ca mochi hual unca quinami yihual quita cuali. Yoje anyes quinami icuajmecal uva hual quilalía ilaquilyo hual amo lamis huejcahuas, pampa yehuanten hual nechneltocalo yalo yulilo ca nehual. Noje annimitzlajtultic pa yoje Dios noTajtzin anmitzmacas len yes anquilajlanis pan ipampa notoca ilahueliltilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Inon annimitzilijtica pa anquichías, pa yoje anmolasojlas se huan oc se. ");
INSERT INTO nclNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Sinda yehuanten pin lalticpan amo quinequilo anmitzitalo, cuaquinon anquimati pampa yehuanten amo quinequiloaya nechitalo nehual nepa capa ayamo pehuaje anmitzcocolije amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Sinda ancataya quinami yehuanten pin lalticpan hual amo nechneltocalo, cuaquín yehuanten anmitzitaloaya lajlasojli lacames ca yehuanten, pampa anyesquiaya quinami yehuanten. Ma yoje, amhuanten amo inminyaxca yehuanten pin lalticpan hual amo nechneltocalo. Nehual annimitzlajtultic pa anquincahuas yehuanten. Yoje amo quinequilo anmitzitalo. ");
INSERT INTO nclNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Xiquijnamiquican in hual annimitzilic: “Se tequipanujquil san huil ajsis yes hué quinami iteco unca hué. Amo huil quipanahuía yoje in hué hual unca iteco.” Pampín, quinami nejchihuilije nehual anmoteco, yoje anmijchihuilisi. Nechtojtocaje pa nejchihuililosquiaya tetzcuinuc. Noje anmitztojtocasi pa anmijchihuilisi tetzcuinuc. Sinda yuliloaya ca nel nolajtol hual niquijtúa, cuaquín yulisi ca amhuanten anmolajtol hual anquijtúa, pampa anquijtúa jan quinami nehual. ");
INSERT INTO nclNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Huan mochi inon anmijchihuilisi pampa annechneltoca, pampa amo quiximatilo Dios hual nechtilanic. ");
INSERT INTO nclNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Sinda amo nihualaya pa nilajtusquiaya ca yehuanten, yoje amo quipialoaya laijlaculisli. Huan axan amo huil mocahualo amo quipixticate laijlaculisli pampa nihualac huan ma yoje amo nechneltocalo. Inon inminlaijlaculisli. ");
INSERT INTO nclNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Aqui hual nechcocolía, yihual noje quicocolía Dios noTajtzin. ");
INSERT INTO nclNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Sinda nehual amo niquinchihuaya capa yehuanten innojen hual amo quiman quinchihuaya oc se, cuaquín yehuanten amo quipialoaya laijlaculisli. Axan quinmitaje len niquinchíac, huan yoje quimatije pampa neli nicpía ilahueliltilisli noTajtzin. Yihual quinchía innojen pan nopampa. Ma yoje amo mocahualo pa nechcocolisi nehual huan amo mocahualo pa quicocolisi Dios noTajtzin. ");
INSERT INTO nclNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Huan inon panujtica pa yoje panus mochi quinami unca lajcuiluli pa yehuanten inminlajtol hual noje unca Dios ilajtol, quijtúa: “Yehuanten amo mocahuaje pa nechcocolisi, mas que amo cataya nindeno calica huil nechmotexpahuilije.” ");
INSERT INTO nclNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Ma yoje, amo huejcahuas pa hualas in Lalacahualtini hual anmitzlaicanas huan anmijchicahualtis. Yihual annimitztilanis pa quisas capa unca Dios noTajtzin. Yihual in Espíritu hual jan quijtúa len melahuac san. Yihual quisa capa unca noTajtzin Dios. In tonali hual yihual hualas, yihual lajtus neli nonahuac nehual. ");
INSERT INTO nclNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Huan amhuanten anlajtus neli nonahuac nehual pampa ca nehual anunca amhuanten quiman nipehuaya nicchía Dios itequipanulisli huan pa axan. ");
INSERT INTO nclNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Innojen lajtomes annimitzilic pa yoje amo anmocahuas pa annechneltocas pa in tonalijmes hual anmijchihuilisi amo cuali pampa annechneltoca. ");
INSERT INTO nclNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Anmitzquixtisi pin tiopajmes. Quema, huan ajsis in tonali hual aqui yes anmitzmictis quijtus yihual quichijtica len lachihualisli pa Dios. ");
INSERT INTO nclNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Huan quinchihuasi innojen pampa amo quiman quiximatic Dios noTajtzin huan amo quiman nechiximatic nehual. ");
INSERT INTO nclNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ma yoje, annimitzilic innojen lajtomes, pa yoje pa in tonalijmes hual ajsisi, huan anmitzpanus inon, cuaquín anquinmijnamiquis quinami annimitzilic. Unca inon hual quichía in Espíritu Santo. ’Quipía míac tonalijmes quiman nipehuac annimitzilic nolajtomes. Annimitzmaxtitihualac, axan nican ticate, huan ayamo annimitzilic innojen lajtomes hual axan annimitzilijtica. Amo annimitzilic pampa mojmosta nicataya ca amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Axan nía ca capic unca yihual hual nechtilanic, huan ma yoje, amo unca se ca amhuanten hual nechlajlanía, quil, ¿ca capic tía? ");
INSERT INTO nclNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Huan anmitzcocúa míac anmoyolo pampa annimitzilic innojen lajtomes. ");
INSERT INTO nclNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ma yoje, annimitzilía neli pampa unca cuali pa amhuanten pa nimohuicas. Sinda amo nimohuicas, cuaquinon amo hualas ca amhuanten in Lalacahualtini. Yoje, in tonali hual nimohuicas, nictilanis in Lalacahualtini pa amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Huan yihual, in tonali hual hualas, quinnextilis chicahuac yehuanten pin lalticpan quinami yehuanten cate laijlaculi, quinnextilis chicahuac yehuanten inahuac nomelahualisli, huan quinnextilis chicahuac quinami Dios neli yahui quintojtoca ilaixpan yihual yehuanten hual yulilo quichijtica in hual amo cuali. ");
INSERT INTO nclNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Quinnextilis yehuanten cate laijlaculi pan ipampa quinami amo nechneltocalo. ");
INSERT INTO nclNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Quinnextilis pampa nehual nimelahuac pan ipampa quinami nehual nías ca Dios noTajtzin huan yajmo annechitas, mas que nehual nicayas nicchijtica mochi quinami Dios noTajtzin quixtoca. ");
INSERT INTO nclNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Quinnextilis quinami Dios neli yahui quintojtoca ilaixpan yihual yehuanten hual amo yulilo cuali, pan ipampa quinami axan quitojtocac ilaixpan yihual Satanás in lili. Yihual in hué pin lalticpan hual huelitía pan yehuanten hual amo Dios ilacames. ");
INSERT INTO nclNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Niquinpía míac lajtomes pa annimitzilis hual ayamo huil anquimati len quinequilo quijtulo pampa cate lajtomes ejꞌetic. ");
INSERT INTO nclNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ma yoje, in tonali hual hualas yihual in Espíritu hual quijtúa mochi hual unca melahuac, cuaquín yihual anmitznextilis mochi hual unca melahuac inahuac Dios. Huil quichía inon, pampa amo yahui lajtúa pan ipampa yihual ihuían. Cayas len yes quicaquis Dios quijtus, inon yihual quijtus. Huan anmitzlaquetzilis ca lajtol hual moxtin quimatisi len quinequi quijtúa, anmitzlaquetzilis inminahuac mochi innojen hual yahuilo panulo. ");
INSERT INTO nclNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Annejchías niman hué pampa yihual canas len niquijtúa huan anmitznextilis len quinequi quijtúa. ");
INSERT INTO nclNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Mochi hual Dios noTajtzin quipía, xicmatican pampa in noyaxca. Yoje, annimitzilic pampa yihual in Espíritu Santo cana in hual niquijtúa huan yihual anmitzilis len quinequi quijtúa. ");
INSERT INTO nclNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Jan nadita san huan yajmo annechitas. Huan cuaquín jan nadita san huan oc sejpa annechitas, pampa nías ca capic unca in Tajtzin. ");
INSERT INTO nclNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Sequin ca imonextilinijmes moilije se ca oc se: —¿Len quinequi quijtúa inon hual techilijtica? Techilía: “Jan nadita san huan amo annechitas. Huan cuaquín annechitas oc sejpa quiman panus jan nadita san.” Huan noje techilía unca pampa yihual yahui ca capic Dios in Tajtzin. ");
INSERT INTO nclNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Len inon hual techilía: “Jan nadita san?” Amo ticmatilo len quinequi quijtúa. ");
INSERT INTO nclNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús quimatic laijtic yihual quinami yehuanten quinequiloaya quilajlanilo inahuac inon hual quinmilijtataya, huan quinmilic: —¿Anmolajlantica amhuanten inahuac inon hual annimitzilic: “Jan nadita san huan yajmo annechitas huan cuaquín jan nadita san huan annechitas oc sejpa”? ");
INSERT INTO nclNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Neli, neli annimitzilía, anchocas huan anlaquetzas inahuac quinami anmitzcocúa anmoyolo. Huan yehuanten hual yulilo pin lalticpan huan amo quineltocalo Dios, jan quinami quinequi Satanás hual huelitía pin lalticpan, yehuanten quipiasi paquilisli. Quema, amhuanten anmitzcocus anmoyolo. Ma yoje, amo anmocahuas yoje. Anmopalas huan anquipías míac paquilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Quiman yes se sihual lalacatiltía, mococúa pampa ajsic in tonali pa lalacatiltis. Ma yoje, quiman lacatic in xól, cuaquín in sihual yajmo quijnamiquía mochi in lacocoltilisli. Axan paqui míac pa iyolo pampa lacatic se xól pin lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Huan amhuanten axan anquipía icnotilisli. Ma yoje, annimitzitas oc sejpa huan ancayas anquipixtica míac paquilisli pa anmoyolo. Huan amaqui huil anmitzquixtilía anmopaquilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Pan in tonali amo anquipías pa annechlajlanis nindeno inahuac ca capic nía, quinami axan annechlajlanic, pampa pan in tonali anquimatis. Neli, neli annimitzilía, sinda anquilajlanis Dios noTajtzin len yes, yihual anmitzmacas pan ipampa notoca ilahueliltilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Pa mochi tonalijmes hual nicayac ca amhuanten, ayamo anquilajlanic nindeno pan ipampa notoca ilahueliltilisli. Axan xiclajlanican huan anquipías pa yoje ancayas ca niman míac paquilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Innojen lajtomes annimitzilic ca lajtol hual amo anquimati len quinequi quijtúa. Ajsis in tonali hual yajmo annimitzilis len ca lajtol hual amo anquimati. San annimitzlaquetzilis inahuac Dios noTajtzin ca lajtol hual anquimatis neli len quinequi quijtúa. ");
INSERT INTO nclNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","In tonali anlajlanis pan ipampa notoca ilahueliltilisli. Huan amo annimitzilijtica pampa nía niclajlanía Dios noTajtzin pa yihual anmitzmacas len anquilajlanis. Amo monequis pa nicchías yoje. ");
INSERT INTO nclNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Inon unca pampa yihual Dios noTajtzin anmitzlasojla. Anmitzlasojla pampa amhuanten annechlasojla huan amo anmocahua pa anquineltocas quinami nehual niquisac nepa capa unca Dios noTajtzin. ");
INSERT INTO nclNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Niquisac pa in cielo capa ticataloaya huan Dios noTajtzin, huan nihualac pin lalticpan, nican niunca. Axan nijcahua in lalticpan huan nimocuepas ca capic Dios noTajtzin. ");
INSERT INTO nclNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Imonextilinijmes quilije: —Xiquita, axan tilaqueztica ca lajtol hual ticmatilo len quinequi quijtúa. Amo tilajtutica ca lajtol hual amo ticmatilo. ");
INSERT INTO nclNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Axan ticmatilo tehual ticmati mochi, huan amo monequi pa se mitzlajlanis len, pampa ticmati len yes quinequi mitzlajlanía quiman ayamo mitzlajlanic. Pan ipampa inon, ticneltocalo tehual tiquisac pin cielo nepa capa mitztilanic Dios. ");
INSERT INTO nclNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús quinnanquilic: —¿Axan anlaneltoca? ");
INSERT INTO nclNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Xiquitacan. Ajsitica, quema, axan ajsic in tonali hual ancayas lasemanali mochi sejse pa ichan, annechcahuas nohuían. Ma yoje amo niunca nohuían, pampa unca ca nehual Dios noTajtzin. ");
INSERT INTO nclNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Innojen lajtomes annimitzilic, huan mocahualo ca amhuanten, pa yoje pan nopampa amo anquipías pa anmomajtis. Nican pin lalticpan anpanus mochi hual anmitzcocoltis. Ma yoje xicpiacan míac paquilisli. Nehual niquinsulahuac yehuanten hual iyaxca in lalticpan hual quinequilosquiaya anmitzlamilo. Quema, axan niquinsulahuac yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ca innojen lajtomes, Jesús laquisac laquetzac ca imonextilinijmes. Cuaquinon lachíac pa in cielo (ilhuicac) huan quilic: —Tata, axan ajsitihualac in hual yahuiaya huala. Xijchía niman hué nehual moxolol, pa yoje nehual moxolol huil nimijchía niman hué. Nicnextic quinami tiunca niman hué pan ipampa quinami niquinmacas moyulilisli hual amo quiman lamis. ");
INSERT INTO nclNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Niquinmacas moxtin yehuanten hual tichmacac pa yesi nomonextilinijmes. In nicchías pan ipampa quinami tichmacac lahueliltilisli ca moxtin pin lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Huan sinda mitziximatilo tehual in se Dios, amo unca oc se, tehual in Dios melahuac, huan sinda nechiximatilo nehual Jesucristo hual tichtilanic pan lalticpan, cuaquinon yoje quipialo moyulilisli hual amo quiman lamis. ");
INSERT INTO nclNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Niclamachiltic nican pan lalticpan quinami tehual tiunca niman hué pan ipampa quinami niclamic nicchíac in motequipanulisli hual tichmacac pa nicchías. ");
INSERT INTO nclNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Huan axan, Tata, xiclamachilti quinami niunca niman hué quiman nicayas oc sejpa monahuac, pa yoje nicayas lachihuali niman hué, jan quinami nicatani quiman huan tehual ticatanijme huan ayamo pehuac in lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Niquinnextilic quinami tehual tiunca noTajtzin, inon niquinnextilic yehuanten hual tichmacac pa yesi nomonextilinijmes. Tiquinlajtultic, cataloaya ca yehuanten pin lalticpan. Yehuanten yeje moyaxca tehual, huan tichmacac yehuanten huan yalo yultialo lachijticate quinami tiquijtúa. ");
INSERT INTO nclNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Axan quimatilo mochi len yes tichmacac nehual, huan inon moyaxca tehual. ");
INSERT INTO nclNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Inon quimatilo, pampa in lajtol hual tichmacac, inon niquinmilic. Huan quineltocaje in hual niquinmilic, huan quimatije neli pampa nehual nihualac niquistataya capa tehual. Huan quineltocaje pampa tehual tichtilanic. ");
INSERT INTO nclNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Nimitzlajlanía pa tehual tiquinlachilis. Amo nimitzlajlantica in pa yehuanten pin lalticpan axan. San nimitzlajlantica inon pa yehuanten hual tichmacac pa yesi tolacames, pampa yehuanten cate molacames tehual. ");
INSERT INTO nclNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Huan mochi hual noyaxca, noje unca moyaxca, huan mochi hual unca moyaxca, noje in noyaxca. Huan yehuanten quinlamachiltije nochicahualisli niman hué huan nolaixpelalisli cualtichin. Huan yalo quinlamachiltitialo, huil moita inon pan ipampa quinami yulilo. ");
INSERT INTO nclNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Nehual yajmo nicayas pin lalticpan. Yehuanten cate pin lalticpan, huan nía nihuala capa tehual. Tata, ma ye lamachiltili quinami unca niman hué motoca. Xiquinmiztía yehuanten pa cayasi quinami tehual motoca quinnextilía quinami monequi pa yulisi yehuanten hual moyaxca. Huan tehual tichtocayaltic quinami tehual timotoca. Yoje, pampa inon yehuanten yesi se san, jan quinami tehual huan nehual ticate se. ");
INSERT INTO nclNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Innojen tonalijmes hual nicataya ca yehuanten, niquintzacuiliaya pa camo mopolulosquiaya. Niquintzacuiliaya pan ipampa motoca ilahueliltilisli, yehuanten hual tichmacac pa yesi nolacames. Niquinlachiliaya pa camo mopolulosquiaya, huan yehuanten amo nicmacahuiltic pa Satanás quinpolehuiltis. Jan in se hual quipiaya pa polehuis pa camo quiman quisas pin ipolehuilisli, yihual nicmacahuiltic pa quipolehuiltis Satanás. Inon quipanuc pa yoje panus quinami unca lajcuiluli molajtol. ");
INSERT INTO nclNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Huan axan nía nihuala capa tehual. Huan innojen lajtomes nimitzilijtica nican quiman ayamo niquisac pin lalticpan, pa yoje yehuanten mocahuasi ca niman míac paquilisli pa inminyolo, quipixticate nopaquilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Niquinmacac molajtol. Huan yehuanten hual yulilo quichijticate quinami quixtoca Satanás hual huelitía pin lalticpan, yehuanten quincocolilo nomonextilinijmes. Unca pampa nomonextilinijmes amo yulilo quinecticate lachihualo quinami yehuanten pin lalticpan, jan quinami nehual amo nilachía quinami yehuanten pin lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Amo nimitzlajlantica pa tehual tiquinquixtis pa camo cayasi ca yehuanten hual amo quinequilo yulilo quinami quijtúa molajtol. Nimitzlajlantica pa tiquinmitas pa camo quinsulahuas Satanás. ");
INSERT INTO nclNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Yehuanten amo iyaxca in lalticpan capa Satanás huelitía inminpan moxtin, jan quinami nehual amo niunca iyaxca in lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Xiclali pa yulisi quinecticate yulilo quinami tiquita cuali tehual, amo quinami quijtusi yehuanten pin lalticpan. Huan xiquinchihuili inon pan ipampa in hual unca melahuac. Tehual molajtol, in hual unca melahuac. ");
INSERT INTO nclNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Huan jan quinami tehual tichtilanic nehual nican pin lalticpan, jan yoje nehual niquintilanic yehuanten pa yasi pa mochi in lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Huan pa mochi quisas cuali pa yehuanten, nehual nimolalía pa nimiquis, inon nicchía pampa unca quinami ticnequi tehual. Inon nicchía pa jan yoje yehuanten yesi lalalili pa yulisi quichijticate quinami tehual ticnequi. Quichihuasi inon pan ipampa molajtol melahuac. ");
INSERT INTO nclNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Ma yoje, amo nimitzlajlantica pa tiquinchihuilis mochi inon jan pa innojen nomonextilinijmes san. Nimitzlajlantica noje pa tiquinchihuilis inon yehuanten hual yalo nechneltocalo pan ipampa quinami innojen nomonextilinijmes quinmilisi yehuanten nonahuac nehual. ");
INSERT INTO nclNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nimitzlajlantica pa tiquinchihuilis inon pa yoje yehuanten moxtin cayasi ca se laijnamiquilisli. Cayasi jan quinami tehual, Tata, tiunca ca nehual huan nehual niunca ca tehual, huan ticate ca se laijnamiquilisli. Yoje yehuanten cayasi ca tehuanten ca se laijnamiquilisli. Yoje quineltocasi yehuanten pin lalticpan pampa tehual tichtilanic. ");
INSERT INTO nclNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Huan jan quinami tehual ca jan nadita san tía tilanextía quinami nehual niunca niman hué, jan yoje nehual nía niquinchía yehuanten niman hué ca inon calica tía tijchía nehual niman hué. Inon pa yoje cayasi ca se laijnamiquilisli, jan quinami tehual huan nehual ticate ca se laijnamiquilisli. ");
INSERT INTO nclNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nehual niyultica laijtic ca yehuanten, huan tehual tiyultica laijtic ca nehual, pa yoje yehuanten cayasi yulticate moxtin ca se laijnamiquilisli quinami tehual ticnequi pa yulisi. Yoje quimatisi yehuanten pin lalticpan pampa tehual tichtilanic ca niquic. Quimatisi pampa tehual tiquinlasojlac jan quinami tehual tichlasojla nehual. ");
INSERT INTO nclNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Tata, nicnequi pa yehuanten noje hual tehual tichmacac cayasi capa nehual nicayas, pa yoje quitasi quinami tehual tijchíac nehual niman hué ca mochicahualisli huan molaixpelalisli niman cualtichin. Inon tichmacac pampa amo timocahua pa tichlasojlas quinami tichlasojlaya quiman ayamo yec lachihuali in lalticpan huan pa axan. ");
INSERT INTO nclNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ah, Tata, tehual ticchía mochi cuali huan melahuac. Yehuanten pin lalticpan amo mitziximatije. Ma yoje, nehual nimitziximatic. Huan innojen nican quimatilo pampa tehual tichtilanic. ");
INSERT INTO nclNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Huan nehual niquinnextilic quinami tiunca pa yoje mitziximatisi. Huan amo nimocahuas pa niquinlamachiltis inon, pa yoje yehuanten quimatisi lalasojlasi jan quinami tehual tichlasojla, huan pa yoje nehual nicayas pa laijtic yehuanten inminyolo. ");
INSERT INTO nclNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Quiman Jesús lamic quilic Dios inon, uyajtíac ca imonextilinijmes, quipanahuije in atenco itoca Cedrón. Ca yoje (analco) in atenco cataya se cuajtilan ca cuahuimes hual ilaquilyo yec olivos. Nepa calaquic Jesús ca imonextilinijmes. ");
INSERT INTO nclNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas yahuiaya quitemaca Jesús ca yehuanten hual yahuiloaya latilanilo pa yesquiaya lamictili. Yihual noje quimatiaya capa cataya in cuajtilan. Sejpa huan oc sejpa Jesús huan imonextilinijmes monechiculoaya umpa. Pampín Judas quimatiaya capa cataya. ");
INSERT INTO nclNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yoje yihual quinmanac míac guaches huan piscales hual in tiopistas huejué huan in fariseos quintilanije, quinlaicantiahuiaya ca umpic. Moxtin quinpialoaya calica molahuilosquiaya huan cuajtzitzindis lalatiahuiloaya huan ca cuahuimes huan teposlimes hual latequilo. Innojen quintequipanulo guaches pa moanalisli. ");
INSERT INTO nclNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Huan pampa Jesús quimatiaya mochi hual yahuiaya quipanu, uyac ca yehuanten, quinmilic: —¿Aqui anquitemujtica? ");
INSERT INTO nclNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Quinanquilije: —Jesús in nazareteco. Quinmilic Jesús: —Nehual niunca. Huan Judas hual quitemacac Jesús ca yehuanten nepa noje huan yehuanten moqueztataloaya. ");
INSERT INTO nclNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yoje, quiman quinmilic Jesús: “Nehual niunca”, yehuanten molasaje pa inmintepotzcon huan huetzije pan lali. ");
INSERT INTO nclNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Oc sejpa Jesús quinlajlanic: —¿Aqui anquitemujtica? Huan quilije: —Jesús in nazareteco. ");
INSERT INTO nclNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesús quinnanquilic: —Annimitzilic nehual niunca. Sinda nehual annechtemujtica, cuaquín xiquinmacahuiltican pa yasi innojen lacames hual cate ca nehual. ");
INSERT INTO nclNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Inon quinmilic Jesús pa yoje panus jan quinami yihual quilic Dios: “Amo niquinpoluc amaqui ca yehuanten hual tichmacac pa nechneltocasi. Quema, amo nicpoluc se.” ");
INSERT INTO nclNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Cuaquinon Simón Pedro hual quipíac se teposli latequi quiquixtic huan quitecuac se itequipanujquil in tiopista hué, quicotonilic inacas, cataya inacas pa ima cuali. In tequipanujquil itocaya Malco. ");
INSERT INTO nclNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesús quilic Pedro: —Xicajcoqui moteposli pa capa tijquixtic. Inon hual nechpanujtica unca in hual quinequi Dios noTajtzin pa nechpanus. ¿Tiquijtúa nehual amo nía nicmacahuiltía pa nechpanus mas que yes quinami chichic pa nehual? ");
INSERT INTO nclNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Cuaquinon quiquitzquije Jesús in guaches huan inminlaicanani huan inminpiscales in judíos huejué, quilpije. ");
INSERT INTO nclNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Pehuaje quihuicaje jan axcan capa cataya Anás, yihual itajtzin isihua Caifás huan Caifás yec in tiopista hué pa in xihuil. ");
INSERT INTO nclNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Huan cataya yihual in Caifás hual quinmacac lajtol inminhuejueyenten in judíos pa canas se lacal san pa miquis pa moxtin yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Huan Simón Pedro quitocac Jesús huan noje oc se imonextilini quitocac. In tiopista hué quiximatiaya in oc se monextilini. Pampa inon yihual calaquic pa ilajcotiyan in tiopista hué ichan, capa cataya Jesús. ");
INSERT INTO nclNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Mocahuac Pedro moqueztataya pa in lalapujquil pa quiahuac. Cuaquín quisac in oc se monextilini hual quiximatiaya in tiopista hué, huan quilic in tequipanujquil sihual hual quilachiliaya in lalapujquil pa quimacahuiltis pa calaquis Pedro. Cuaquinon in monextilini quihuicac Pedro pa calijtic. ");
INSERT INTO nclNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","In sihual hual quilachilijtataya in lalapujquil quilic Pedro: —Tehual noje, ¿tiunca se imonextilini in lacal Jesús? Yihual quilic: —Amo niunca imonextilini. ");
INSERT INTO nclNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nepa moqueztataloaya itequipanujquimes in tiopista hué huan in piscales. Quipitzaje se tixuxli pampa quitaloaya sehua huan quiyahualuloaya itenco moutzcutataloaya. Huan noje moqueztataya Pedro nepa moutzcutataya. ");
INSERT INTO nclNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Cuaquinon in tiopista hué quilajlanic Jesús pa quinpuhuilisquiaya inminahuac imonextilinijmes huan len quimaxtiaya. ");
INSERT INTO nclNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús quinanquilic: —Nehual nilajtuaya mojmosta inminlaixpan moxtin. Mojmosta nilamaxtiaya pin tiopajmes huan in tiopan hué huan capa yes monechiculo mochi in judíos, huan amo niquijtuc nindeno ixtacayito. ");
INSERT INTO nclNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Leca tichlajlantica inon? Xiquinlajlani aquinojen nechcaquiloaya in hual niquinmiliaya. Xiquita, innojen quimatilo len niquinmiliaya. ");
INSERT INTO nclNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Quilic Jesús inon, se piscal nepa moqueztataya inahuac quitecuac Jesús pa iixco, quilic: —¿Yoje ticnanquilía in tiopista hué? ");
INSERT INTO nclNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús quinanquilic: —Sinda niquijtuc len amo cuali, xitechnextili quinami cataya amo cuali. Huan sinda nilajtuc cuali, ¿leca tichtecuac? ");
INSERT INTO nclNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Cuaquinon Anás quitilanic Jesús lailpili capa cataya Caifás in tiopista hué. ");
INSERT INTO nclNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Huan mocahuac Pedro moqueztataya huan moutzcutataya. In lacames nepa quilije: —¿Tehual noje tiunca se ca imonextilinijmes in Jesús? Pedro islacatijtataya quinmilic: —Amo niunca. ");
INSERT INTO nclNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nepa cataya se icni pa oc se cali in se hual Pedro quicotonilic inacas, in se icni pa oc se cali noje yec se itequipanujquil in tiopista hué, quilic: —¿Amo nimitzitac nepa ca yihual pin cuajtilan capa laquilo olivos? ");
INSERT INTO nclNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Oc sejpa islacatic Pedro quilijtataya pampa no. Jan ajnaxcan xahuanic se gallo. ");
INSERT INTO nclNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Cuaquinon quiquixtije Jesús ilaixpan Caifás, quihuicaje ca se cali hué itocaya in Pretorio capa chantiaya in gobernador (huelitini) romano. Ca ompic quihuicaje pa yihual in gobernador quitilanisquiaya pa quimictisi Jesús. Yahuiaya lanesi in tonali. Yehuanten in judíos amo calaquiloaya pin Pretorio, pampa inminlajtol hual quinmaxtía quinami monequi pa quimolancuacuetzilisi Dios quijtúa pa yehuanten amo cayasi ca yehuanten hual amo judíos. Sinda yoje quichihualoaya, cuaquinon amo huil quicualoaya iborrego in fiesta (ilhuil) pascua. In lajtol lajcuiluli quijtúa pampa cayalosquiaya laijlaculi sinda yoje quichihualoaya. ");
INSERT INTO nclNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pampín, quisac Pilato in gobernador (huelitini) ca yehuanten, quinmilic: —¿Leca anmotexpahuía? ¿Len anmijchihuilic in lacal? ");
INSERT INTO nclNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Quinanquilije: —Sinda in lacal amo quichihuaya len niman amo cuali, cuaquín amo timitztemacaloaya. ");
INSERT INTO nclNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Huan Pilato quinmilic: —Xiquihuicacan amhuanten anmohuían huan xictilani pa iojli quinami quijtúa anmolajtol. In huejueyenten judíos quilije: —In lajtol amo techmacahuiltía pa tehuanten tilatilanisi pa yes lamictili se. ");
INSERT INTO nclNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Inon quijtuje pa yoje panus in hual yihual Jesús quijtuc inahuac quinami yahuiaya miqui. ");
INSERT INTO nclNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Cuaquín Pilato calaquic oc sejpa pin Pretorio calijtic, lanotzac pa hualas Jesús ilaixpan, quilic: —¿Tehual inminhué in judíos? ");
INSERT INTO nclNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús quinanquilic: —¿Tichlajlantica inon pampa tiquijtúa yoje? O ¿tehual mitzilije inon nonahuac nehual oc sequin lacames? ");
INSERT INTO nclNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato quinanquilic: —¿Quinami huil nicmati inon nehual? Nehual amo nijudío. Cataloaya in lacames pa molali tehual huan in tiopistas huejué hual nechtemacaje tehual. ¿Len ticchíac? ¿Leca mitztemacaje ca nehual? ");
INSERT INTO nclNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús quinanquilic: —Amo nilahueliltía quinami huelitilo in huejueyenten pin lalticpan pampa nehual amo nihué yoje quinami yehuanten inminhuejueyenten. Sinda yoje cataya, cuaquín moanaloaya nolapalehuinijmes ca yehuanten pa camo nechtemacalosquiaya ca in judíos. Huan jan yoje, amo nechnapatiloaya pampa amo niunca se hué quinami in huejueyenten pin lalticpan. ");
INSERT INTO nclNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato quilic: —Cuaquín, tehual tiunca se hué, ¿quema? Jesús quinanquilic: —Quema, tehual tiquijtuc pampa nehual niunca se hué. Nicpía pa nilajtus neli inahuac in hual unca melahuac. Pampa inon nilacatic, pampa inon nihualac pin lalticpan. Mochi lacal hual quinequi yuli quichijtica huan quilijtica in hual melahuac, yihual yuli quinami quijtulo nolajtomes. ");
INSERT INTO nclNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato quilic: —Neli amo huil quimati se len quinequi quijtúa in lajtol “melahuac”. Cuaquinon, quijtuc inon Pilato, quisac oc sejpa pa quiahuac capa cataloaya in judíos, quinmilic: —Amo niquitilía amo cuali nindeno hual quichíac in lacal. ");
INSERT INTO nclNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Axcan, mochi xíl pan in fiestas unca lamacahuali pa amhuanten se lacal hual unca laquitzquili, aqui yes anquinequi. ¿Anquinequi pa annimitzmacahuilis anmohué amhuanten in judíos? ");
INSERT INTO nclNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Cuaquinon oc sejpa tzajtzije, quilijtataloaya: —¡Amo in se! ¡Xitechmacahuili Barrabás! In Barrabás yec laxtequini. ");
INSERT INTO nclNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Cuaquinon, Pilato canac Jesús, latilanic pa quihuitequisi chicahuac ca mecames hual quitejtequije icuilaxli huan inacal. ");
INSERT INTO nclNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Huan in guaches quijquetije len chicuenta se layahuali ca huizlimes xijxilanqui huan quilajlalije pani itzontecon, huan quilaquentije ca se nahuas morado. ");
INSERT INTO nclNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Cuaquín yajtiahuiloaya ilaixpan yihual Jesús quilijtataloaya: —¡Ma yuli inminhué in judíos! —quilije quitecuatataloaya pa iixco. ");
INSERT INTO nclNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Huan quisac Pilato oc sejpa pa quiahuac ca yehuanten huan quinmilic: —Xiquitacan, nijquixtis pa quiahuac ca amhuanten pa yoje anquimatis amo niquitilía ca yihual laijlaculisli nindeno hual quichíac yihual. ");
INSERT INTO nclNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Hualac pa quiahuac Jesús quipixtataya pani itzontecon in layahuali lachihuali ca huizlimes huan cataya lalaquentili ca in nahuas morado. Cuaquín Pilato quinmilic: —¡Xiquitacan in lacal! ");
INSERT INTO nclNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Quitaje Jesús in tiopistas huejué huan innojen hual quintequipanuilije, quitzajtzilije: —¡Xicpilu pan se cuahuil! ¡Xicpilu pan se cuahuil! Quinmilic Pilato: —¡Xicanacan amhuanten huan xicpilucan pan se cuahuil! Pampa nehual amo niquitilía nindeno amo cuali ca yihual. ");
INSERT INTO nclNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Quinanquilije in judíos: —Tehuanten ticpialo se lajtol, huan quinami quijtúa in lajtol monequi pa miquis, pampa yihual quilic yihual Dios iXolol. ");
INSERT INTO nclNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Quicaquic inon, Pilato momajtic míac. ");
INSERT INTO nclNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Calaquic oc sejpa pin Pretorio itenencia, huan quilic Jesús: —¿Capa cataya molali quiman tipejtihualaya ca niquic? Jesús amo quinanquilic nindeno. ");
INSERT INTO nclNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Cuaquinon Pilato quilic: —¿Quinami amo tilaquetza ca nehual? ¿Amo ticmati nehual nicpía lahueliltilisli pa nimitzmacahuas, huan nicpía lahueliltilisli pa nilatilanis pa mitzpilusi pan se cuahuil? ");
INSERT INTO nclNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesús quinanquilic: —Amo ticpiaya lahueliltilisli nindeno pa tijchihuilis len, sinda Dios amo mitzmacaya nepa pin cielo pa pani. Yoje, yihual hual nechtemacac ca tehual quichíac in laijlaculisli hué. Tel molaijlaculisli amo unca yoje hué. ");
INSERT INTO nclNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pampa inon Pilato quitemuc quinami huil quimacahuac Jesús. Ma yoje, tzajtzije in judíos quilijtataloaya: —¡Sinda ticmacahuas in se, cuaquín tehual amo tiyes inahuac César in hué romano! ¡Mochi lacal hual mochía se hué quinequi quiquixtilía ilahueliltilisli César in hué niman hué! ");
INSERT INTO nclNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Quicaquic Pilato len quilije, cuaquín quihualicac Jesús pa quiahuac huan molalic pa in icpali hué capa quimacani ojli yehuanten hual quinmotexpahuilinijme. Cataya pan se tixcaltilan itocaya Tixcaltilan Ajꞌalastic. Ca lajtol hebreo moijtúa Gabata. ");
INSERT INTO nclNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","In tonali itocaya In Tonali Capa Mochijchihualo, cataya se itonali hué in fiesta (ilhuil) pascua. Cataya quinami lacualispan huan quinmilic Pilato in judíos: —¡Xiquitacan anmohué! ");
INSERT INTO nclNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Yehuanten quitzajtzilije: —¡Xiquijcuani, xiquijcuani, xicpilu pan cuahuil! Quinlajlanic Pilato, quinmilic: —¿Nicpilus anmohué pan cuahuil? Quinanquilije in tiopistas huejué: —¡Amo ticpialo oc se hué, jan César san! ");
INSERT INTO nclNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Cuaquinon, quintemacac Pilato Jesús ca yehuanten pa yes lapiluli pan cuahuil. ");
INSERT INTO nclNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Canaje Jesús, huan yihual quisac quimantiahuiaya icuahuil, uyaje pa se ixlahuito itocac Itzontecomal in Mijquil, in moijtúa ca hebreo Golgotá. ");
INSERT INTO nclNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Cataya nepa capa quipiluje pani in cuahuil, huan ca yihual quinpiluje oc sequin ome pan cuahuimes, quinpiluje in yeyenten huan Jesús lajco capa yehuanten omenten. ");
INSERT INTO nclNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Huan noje quijcuiluc Pilato se amal pa quimatisi moxtin leca quipiluje pani in cuahuil, huan quisaluc pan in cuahuil in amal hual quijtuc: “JESÚS IN NAZARETECO, INMINHUÉ IN JUDÍOS.” ");
INSERT INTO nclNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yoje, momaxtije in amal míac judíos, pampa amo cataya huejca pa quiahuac Jerusalén capa quipiluje Jesús pani in cuahuil. Huan in amal quijcuiluc ca lajtol hebreo huan ca lajtol latín huan ca lajtol griego. ");
INSERT INTO nclNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Quitaje in amal in judíos inmintiopistas huejué, huan quilije Pilato: —Amo xiquijcuilu “Inminhué in judíos”. Xiquijcuilu pampa in se quijtuc: “Nehual niunca inminhué in judíos.” ");
INSERT INTO nclNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Quinnanquilic Pilato: —Inon hual niquijcuiluc mocahua lajcuiluli yoje. ");
INSERT INTO nclNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Huan in guaches nepa capa quipiluje Jesús pan in cuahuil, canaje itzotzomajli huan moxiluilije pa yehuanten nahuenten, se tzotzomajli pa se guache. Noje canaje ilaquen. Huan ilaquen cataya lajquetili mochi pa pani, amo quipiaya lajtzomali. ");
INSERT INTO nclNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Yoje, moilije se ca oc se: —Ma camo tictzayanacan. Ma tiquinlasacan nahui lajquitos cuajtzindi cuixtito pin lasehualoni (sombrero), cuaquín sejse ca tehuanten tijquixtisi se lajquito amo tiquizticate quiman tijquixtisi. Huan aqui hual canas in lajquito xilanqui ca in nahuenten, yihual quipías pa iyaxca in laquen. Yoje quichihuaje pa panus quinami unca lajcuiluli pa Dios ilajtol, in Amal itoca Salmos, yoje quijtúa: “Moxiluilije ca yehuanten notzotzomajli huan quinlasaje lajcomes de cuahuil pa se quipías nolaquen pa iyaxca.” ");
INSERT INTO nclNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","In guaches quichihuaje quinami quijtulo in lajtomes. Nepa amo huejca capa cataya Jesús icuahuil moqueztataloaya inantzin, huan icni sihual inantzin huan María isihua Cleofas, huan María hual quisac pin caltilan Magdala. ");
INSERT INTO nclNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesús quitac inantzin huan quitac imonextilini hual quilasojlac nepa moqueztataya. Cuaquín quilic inantzin: —Nana, xiquita. Axan yihual moxól. ");
INSERT INTO nclNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Cuaquín quilic imonextilini: —Xiquita. Axan yihual monantzin. Huan pa in tonali in monextilini quihuicac Jesús inantzin pa ichan pa mocahuas chantitica ca yihual. ");
INSERT INTO nclNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Panuc inon, cuaquín Jesús quimatiaya quinami mochi panuc quinami unca lajcuiluli Dios ilajtol hual quijtúa quinami yahuiaya panu. Huan quilic: —Niamictica. ");
INSERT INTO nclNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nepa cataya se tapalcal tentataya ca iayo uva xocuc. Yoje quitechcuniltije se pochinquil ca in iayo uva xuc, quilalije pan se acal itoca hisopo, cajcoquije huan quilalije pa icamac pa quipachichinasquiaya. ");
INSERT INTO nclNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Cunic in iayo uva xocuc, Jesús quijtuc: —Axan nilamic nicchíac mochi hual nicpiaya pa nicchías. Huan quipiluc itzontecon huan quimacahuiltic pa quisasquiaya iyulilisli, yoje polehuic. ");
INSERT INTO nclNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Mostatica yahuiaya caya itonali in pascua. Pampín, in tonali hual quipiluje Jesús pani in cuahuil cataya in tonali capa in judíos mochijchihualoaya pa in pascua. Huan in huejueyenten judíos amo quinequiloaya pa mocahualosquiaya in lacames pilujtataloaya pani in cuahuimes pan in tonali pascua quiman mosehuilo, pampa in tonali yec se tonali hué. Pampa inon, in huejueyenten judíos quilajlanije Pilato pa yihual latilanisquiaya pa in guaches quinpostequililosquiaya inmicxihuajmes yehuanten pan in cuahuimes, pa yoje miquilosquiaya huan yoje huil quinmijcuanilosquiaya in mijquimes. ");
INSERT INTO nclNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Cuaquín uyaje in guaches quinpostequilije inmicxihuajmes in se hual pilujtataya pa Jesús ima cuali huan in oc se pa ima amo cuali hual ca yihual pilujtataloaya. Yoje amo huil motzanuije huan pampín polehuiloaya. ");
INSERT INTO nclNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Cuaquinon, ajsije capa Jesús, huan quinami quitaje pampa yihual polehuic, pampín amo quipostequilije icxihuajmes. ");
INSERT INTO nclNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ma yoje, se ca in guaches quicoyunic ilanasticali Jesús ca se latzopinijquil, huan jan ajnaxcan quisac esli huan al. ");
INSERT INTO nclNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Huan yihual hual quitac inon quiman panuc quijtúa neli pampa inon panuc, huan in hual yihual quijtúa unca melahuac, huan yihual quimati pampa neli quijtúa, pa yoje amhuanten noje anquineltocas. ");
INSERT INTO nclNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Panuje innojen pa yoje panusi quinami Dios ilajtol lajcuiluli quijtúa: “Amo quipostequisi se iumil in huendi.” ");
INSERT INTO nclNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Huan amo inon san. Pa oc se iamal Dios ilajtol lajcuiluli quijtúa: “Mocahuasi quizticate yihual hual quitzopinije ca in teposli.” ");
INSERT INTO nclNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Panuje mochi inon, hualaya José hual yuliaya pin caltilan Arimatéa. Yihual yec se imonextilini Jesús. Ma yoje, momajtiaya inminlaixpan in judíos, huan pampa inon amo quimacahuiltiaya pa quimatisquiaya inon amaqui. Huan in José quilajlanic Pilato pa quimacahuiltis pa quihuicas Jesús imijquil. Yoje Pilato quimacahuiltic. Cuaquinon José uyac quihuicac. ");
INSERT INTO nclNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Huan yihual hualaje noje Nicodemo, yihual in se hual quimaniyan hualac quitac Jesús pa layúa. In Nicodemo quihualicac ca yihual len laniluli lachihuali ca mirra huan áloes hual ajuíac, cataya quinami treinta kilos. ");
INSERT INTO nclNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Canaje Jesús imijquil, quiliaruje ca tzotzomajli lachihuali ca lino, quitechcuniltilijtataloaya ca in altzindi lachihuali ca mirra huan áloes. Yoje unca quinami quichijchihuililo in judíos se mijquil quiman yes yalo quilalilo pin cueva (ostul) capa quilalpachulo. ");
INSERT INTO nclNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Huan cataya nepa amo huejca capa quipiluje pan in cuahuil se lajcotiyan latzacuali, huan pin lajcotiyan cataya se cueva (ostul) yancuic capa ayamo quiman quilalije se mijquil. ");
INSERT INTO nclNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Huan pampa cataya in tonali hual mochijchihualo in judíos pa in oc se tonali quiman quipialoaya pa mosehuisi, nepa quilalije in mijquil Jesús pampa amo cataya huejca in cueva (ostul). ");
INSERT INTO nclNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Cuaquinon, panuje in tonalijmes. Cataya laxpoyahuita pa in tonali hual quipehualtía in ocho tonalijmes. Laticumac, ayamo lanesiaya, huan hualaya pa in cueva (ostul) María hual chantini pa Magdala, huan quitac quinami cataya laijcuanili in tel hual quitzactataya in cueva. ");
INSERT INTO nclNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Jan axcan molalujtíac capa cataloaya Simón Pedro huan in oc se monextilini hual Jesús quinequiaya, quinmilic: —Quiquixtilije in Tata pin cueva capa quilalpachuje, huan amo ticmatilo capa quilalije. ");
INSERT INTO nclNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Cuaquín quisaje Pedro huan in oc se monextilini, uyajtiquisaje pa in cueva (ostul). ");
INSERT INTO nclNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Molalujtiahuiloaya in omenten, huan in oc se monextilini molaluaya ca mochi ichicahualisli. Amo molalujtiahuiaya Pedro quinami yihual. Pampín, yihual ajsic ihuían capa cataya in cueva (ostul). ");
INSERT INTO nclNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ajsic yihual, mopachuc, quitac in tzotzomajli lastataya, ma yoje amo calaquic laijtic. ");
INSERT INTO nclNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Cuaquín ajsic noje Simón Pedro quitocatihualaya huan calaquic laijtic in cueva (ostul). Quitac in tzotzomajli lastataya iliarujtataya. ");
INSERT INTO nclNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Huan in tzotzomajli hual quiliaruje pa Jesús itzontecon amo lastataya ca in oc sequin tzotzomajli, lastataya iliarujtataya ihuían. ");
INSERT INTO nclNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Cuaquinon, calaquic in oc se monextilini hual ajsic quilaicantataya Pedro. Yihual calaquic in ostul (cueva) laijtic huan quitac mochi huan quineltocac pampa Jesús yajmo cataya nepa. ");
INSERT INTO nclNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Yoje quineltocac pampa ayamo quimatiloaya len quinequiaya quijtu Dios ilajtol lajcuiluli hual quijtúa pampa Jesús quipiaya pa yulisquiaya oc sejpa mas que miquic huan cataya ca in mijquimes. ");
INSERT INTO nclNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Yoje, mohuicaje in monextilinijmes ca capic chantitataloaya. ");
INSERT INTO nclNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Huan María moquetzaya pa in cueva (ostul) pa quiahuac, chocatataya. Huan quinami chocaya, mopachuc pa quitasquiaya pa in ostul laijtic. ");
INSERT INTO nclNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Huan nepa quinmitac ome ilanahuatinijmes in cielo lalaquentili ca tzotzomajli iztatataya, molalijtataloaya se pa capa catani Jesús itzontecon huan se capa catanijme icxihuajmes, pani capa catani lastataya Jesús imijquil. ");
INSERT INTO nclNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Huan yehuanten quilije: —Nito, ¿leca tichocatica? Quinmilic: —Pampa quijcuanije noTeco huan amo nicmati capa quilalije. ");
INSERT INTO nclNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Quinmilic inon, momalinac huan pa itepotzcon quitac Jesús moqueztataya. Ma yoje, amo quimatiaya cataya Jesús. ");
INSERT INTO nclNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Huan Jesús quilic: —Nito, ¿leca tichocatica? ¿Aqui tictemujtica? María quijtuaya pampa yihual yec in lacal hual quiztinemiaya in lajcotiyan, huan quilic: —Tata, sinda tel tiquihuicac, xichili capa ticlalic huan nehual nicuicatías. ");
INSERT INTO nclNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Huan Jesús quilic: —María. Huan yihual momalinac, quilic ca lajtol hebreo: —¡Rabboni! —hual quinequi quijtúa ¡Lamaxtini! ");
INSERT INTO nclNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús quilic: —Amo xicaya tichquitzquitica, pampa ayamo nilejcuc capa unca noTajtzin. Axcan, xía capa cate nocnían, xiquinmili pampa nilejcus pan cielo capa unca noTajtzin huan anmoTajtzin huan capa unca noDios huan anmoDios. ");
INSERT INTO nclNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Cuaquinon uyajtiquisac María in magdalena pa quinlamachiltis in monextilinijmes, quinmilic: —¡Nel niquitac in Tata! —huan quinmilic pampa yihual quilic innojen lajtomes. ");
INSERT INTO nclNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Huan cataya tiolac pa in tonali, in tonali hual quinpehualtía in chicue tonalijmes, huan in monextilinijmes quipialoaya tzactataya in calijtic capa cataloaya pampa momajtiloaya. Quijtuloaya cuajnesi in judíos quinmitalosquiaya. Jesús nesic huan moquetzac lajco capa yehuanten, quinmilic: —Ma Dios anmitzmaca mochi hual cuali huan ma anmijchihuili mochi hual cuali. ");
INSERT INTO nclNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Huan quinmilic inon, quinnextilic imajmajuan huan ilanasticali. Yoje quipialoaya míac paquilisli in monextilinijmes pampa quitaloaya Jesús. ");
INSERT INTO nclNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Huan quinmilic yehuanten Jesús oc sejpa: —Ma Dios anmitzmaca mochi hual cuali huan ma anmijchihuili mochi hual cuali. Quinami in Tata Dios nechtilanic, jan yoje nehual annimitztilanía amhuanten. ");
INSERT INTO nclNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Quiman quinmilic inon, quimacahuiltic pa iijyul quisac inminpan, quinmilijtataya: —Xicpiacan yoje in Espíritu Santo. ");
INSERT INTO nclNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Sinda anquinmilía aquinojen yesi pampa cate lapujpuhuali inminlaijlaculisli, unca pampa Dios quijtuc pampa cate lapujpuhuali. Huan sinda anquinmilía aquinojen yesi pampa amo cate lapujpuhuali inminlaijlaculisli, unca pampa Dios quijtuc pampa amo cate lapujpuhuali. ");
INSERT INTO nclNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ma yoje, Tomás, se ca in doce monextilinijmes (yihual yec in se ca yehuanten hual quintocayaltije “Seinomenten”), amo cataya ca yehuanten nepa quiman hualac Jesús. ");
INSERT INTO nclNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Pampín, in oc sequin monextilinijmes quilije: —Tiquitaje in Tata. Huan Tomás quinmilic: —Sinda amo niquita pa imajmajuan capa quicoyunilije in teposli huan sinda amo niclalis noma capa quitzopinic pa ilanasticali, cuaquín amo quiman nicneltocas yihual yultica oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Cuaquinon panuje chicue tonalijmes. Cataloaya in monextilinijmes oc sejpa calijtic, huan ca yehuanten Tomás cataya. Calaquic Jesús calijtic mas que tzactataloaya in calijtic capa cataloaya, huan moqueztiquisac lajco capa yehuanten, quinmilic: —Ma Dios anmitzmaca mochi hual cuali huan anmijchihuili mochi hual cuali. ");
INSERT INTO nclNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Cuaquín yihual quilic Tomás: —Xiclali moxerixa nican huan xiquinmita nomajmajuan, huan xijcalacti moma pin nolanasticali. Huan amo xiye se hual amo quineltoca, xiye se hual quineltoca. ");
INSERT INTO nclNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomás quinanquilic: —¡NoTata huan noDios! ");
INSERT INTO nclNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús quilic: —Tomás, ticneltocaya pampa tichitac. Ma quipiacan paquilisli yehuanten hual amo nechitac huan ma yoje quineltocalo nehual niyulic oc sejpa. ");
INSERT INTO nclNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Quinchíac Jesús míac oc sequin lachihualisli inminlaixpan imonextilinijmes hual quinlamahuisultije ca lamajtilisli. Cate lachihualisli hual amo cate lajcuiluli pa in amal. ");
INSERT INTO nclNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ma yoje, innojen hual quema, cate lajcuiluli nican, cate lajcuiluli pa yoje anquineltocas Jesús unca in Cristo hual Dios quilajtultic pa quipías Dios ilahueliltilisli. Huan cate lajcuiluli pa anquineltocas yihual Dios iXolol, cate lajcuiluli pa yoje anquipías yulilisli pan ipampa quinami anquilalilis anmolaneltocalisli ca itoca. ");
INSERT INTO nclNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Panuje innojen lachihualisli. Cuaquín Jesús monextilic imonextilinijmes oc sejpa, cataya pa in al huejcalan itoca Tiberias. Huan yojque unca quinami quinmonextilic. ");
INSERT INTO nclNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Cataloaya lanechiculi nepa Simón Pedro huan Tomás hual noje quitocayaltiloaya “Seinomenten”. Noje cataya Natanael hual yulini pin caltilan Cana pin lalticpan Galilea, huan cataloaya ixolomes Zebedeo huan oc sequin omenten imonextilinijmes Jesús. ");
INSERT INTO nclNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Huan Simón Pedro quinmilic: —Nehual nía niquinquitzquía michin. Yehuanten quilije: —Tehuanten noje tiasi timitztocasi. Quisaje huan calaquije pin barquito huan pa in layúa amo quiquitzquiloaya nindeno. ");
INSERT INTO nclNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Yahuiaya quisa in tonali, huan nepa xalipan cataya Jesús. Ma yoje in monextilinijmes amo quimatiloaya yihual cataya. ");
INSERT INTO nclNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Cuaquinon Jesús quinnotzac: —Nitos, ¿amo anquipía michin pa quicuas se? Quinanquilije pampa amo quipialoaya. ");
INSERT INTO nclNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Huan yihual quinmilic: —Xiclasacan xictzojuican ca ima cuali in barquito huan anquinquitzquis. Cuaquín quitzojuije huan jan axcan etíac ca míac michimes, amo huil quejuaje pa quilalilosquiaya in xiquipili hué pin barquito pampa quinmanaje niman míac michimes. ");
INSERT INTO nclNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Cuaquinon lajtuc in monextilini hual Jesús quinequiaya, yihual quilic Pedro: —¡Unca in Tata! Quicaquic Simón Pedro pampa cataya in Tata, molaquentic pampa quiquixtic ilaquen pa tequipanus. Cuaquín molasac pa al. ");
INSERT INTO nclNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","In oc sequin monextilinijmes ajsije pa xalipan pin barquito quitilantihualaloaya in xiquipili tentataya ca michimes. Amo cataya huejca in xalipan itenco, jan cien metros san. ");
INSERT INTO nclNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ajsije pin xalipan, quitaje tixuxli ca ticahuandera huan michin lalalili ipan, huan noje cataya pan. ");
INSERT INTO nclNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús quinmilic: —Xiquinhualicacan sequin michimes hual anlamic anquinquitzquic. ");
INSERT INTO nclNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Huan uyac Simón Pedro, quitilanac pa xalipan in xiquipili hué tentataya ca michimes huejué, cataloaya ciento cincuenta y tres (chicomepuhualimajlaclihuanye). Huan mas que cataloaya innojen míac, ma yoje amo cotonic in xiquipili. ");
INSERT INTO nclNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Cuaquín Jesús quinmilic: —Xihualacan xilacuacan. Huan amaqui ca in monextilinijmes laicanac pa quilajlanis: “¿Aqui tehual?”, pampa momajtiloaya, quimatiloaya pampa yihual Jesús. ");
INSERT INTO nclNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Huan hualac Jesús, canac in pan huan quinmacac, huan in michin jan yoje quinmacac. ");
INSERT INTO nclNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ca in, cataya sejpa huan oc sejpa ca ye lanextilisli hual Jesús monextic yultataya oc sejpa ca imonextilinijmes quiman moquetzac huan quisac capa mictataya ca in mijquimes. ");
INSERT INTO nclNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Yoje, quiman lamije lacuaje, Jesús quilic Simón Pedro: —Simón, tiꞌixól Juan, ¿tilaicana tichlasojla ca innojen oc sequin quinami nechlasojlalo? Pedro quilic: —Quema, Tata, ticmati nimitznequi. Jesús quilic: —Xiquinmita huan xiquinlacualti noborreguitos. ");
INSERT INTO nclNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesús quilic oc sejpa: —Simón, tiꞌixól Jonás, ¿tichlasojla nehual? Pedro quilic: —Quema, Tata, ticmati nimitznequi. Jesús quilic: —Xiquinlachili huan xiquinlacualti noborregos. ");
INSERT INTO nclNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jesús quilic oc sejpa, huan ca in cataya ca ye lajlanilisli, quilic: —Simón, tiꞌixól Jonás, ¿tichnequi nehual? Huan quicocuc Pedro iyolo pampa Jesús quilic ca in ye lajlanilisli: “¿Tichnequi nehual?” Huan quilic: —Tata, ticmati mochi, ticmati nimitznequi. Jesús quilic: —Xiquinlachili huan xiquinlacualti noborreguitos. ");
INSERT INTO nclNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Neli, nimitzilía inon: Ticatani yancuic, timolalilini molacuejtiloni, timocuejtini tehual huan tinejnemini ca capic catani ticnequini. Huan quiman tiviejojtis, tiquinxilanis momajmajuan huan oc se mitzlalilis molacuejtiloni huan mitzhuicas ca capic amo ticnequis tías. ");
INSERT INTO nclNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Inon quilic pa quimachiltis Pedro quinami yahuiaya miqui huan pan ipampa imiquilisli quinami yahuiaya quichihuili hué Dios. Huan lamic Jesús quilic inon, cuaquín quilic: —Xichtoca pa tiyes nomonextilini. ");
INSERT INTO nclNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedro momalinac, quitac in monextilini hual Jesús quilasojlaya, quintocatataya. Yihual in monextilini hual mohuilaniaya pa ilaixpan ihuajcol Jesús nepa capa lacuajtataloaya, yihual hual quilajlanic: “Tata, ¿aqui yihual hual yahui mitztemaca ca yehuanten hual yalo mitzmictilo?” ");
INSERT INTO nclNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Huan quiman Pedro quitac in monextilini, quilajlanic Jesús: —Tata, huan ¿len yahui quichía nepa unca? ");
INSERT INTO nclNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús quilic: —Sinda nehual nicnequi pa yihual mocahuas nican pan lalticpan pa quiman ajsis in tonali hual nihualas oc sejpa pan lalticpan, cuaquín ¿len ticpías tehual pa tiquitas ca inon? Tehual xichtoca pa timochías nomonextilini. ");
INSERT INTO nclNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yoje, ca moxtin tocnían hual quineltocalo in Tata, mosemanac in lajtol, huan pampa inon yehuanten quijtuloaya in se monextilini amo quiman yahuiaya miqui. Ma yoje, Jesús amo quilic pampa amo quiman yahuiaya miqui. San quilic: “Sinda nehual nicnequi pa yihual mocahuas nican pan lalticpan pa quiman ajsis in tonali hual nihualas oc sejpa pan lalticpan, cuaquín ¿len ticpías tehual pa tiquitas ca inon?” ");
INSERT INTO nclNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Huan in monextilini nehual niunca. Huan neli niquilía innojen lajtomes. Noje niunca in monextilini hual niquinmijcuiluc mochi innojen lajtomes. Huan ticmatilo pampa unca melahuac in lajtol hual nehual neli niquijtúa. ");
INSERT INTO nclNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Cate noje míac oc sequin lachihualisli hual Jesús quinchíac. Huan sinda quinmijcuiluloaya (quinmescribiruloaya) mochi sejse, niquijtúa pampa mochi in lalticpan amo huil cajxiltiaya mochi in amames hual quipialoaya pa moijcuilulosquiaya (moescribirulosquiaya). Yoje ma ye.");
INSERT INTO nclNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, tehual hual moxtin quimatilo mitzpililo lamajtilisli, nimitzijcuiluilía in amal nican. Pa in oc se noamal calica nicpehualtic nolapuhualisli, nimitzijcuiluilic inahuac mochi inon hual pehuac quichíac huan quimaxtic Jesús. Nicpuhuac in hual mitzmachiltic quiman pehuac huan quinami lachijtiahuiaya innojen xixihuil pa quiman ajsic in tonali hual cataya laꞌajcoquili pin cielo. ");
INSERT INTO nclNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Ma yojque, pan tonalijmes quiman ayamo cataya laꞌajcoquili pin cielo, quinmachiltic pan ipampa in Espíritu Santo yehuanten hual quinlajtultic pa yelosquiaya ilanahuatinijmes, quinmachiltic mochi hual quipialoaya pa quichihualosquiaya yehuanten. ");
INSERT INTO nclNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Quiman panuc Jesús ilacocoltilisli huan miquic, yihual yulic oc sejpa. Monextic neli yultataya ca míac nesilisli ca yehuanten ilanahuatinijmes huan yehuanten neli quimatiloaya pampa yuliaya. Huan pan cuarenta tonalijmes yojque monextitinemiaya ca yehuanten huan quinmiliaya quinami Dios huelitía. ");
INSERT INTO nclNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Pan tonalijmes quiman ayamo quisac Jesús capa yehuanten, quinmilic pa mocahuasi pa Jerusalén, quinmilic: —Amo ximohuicacan pa quiahuac Jerusalén. Nepa xicchiacan yihual hual anmitztilanilía noTajtzin. Nehual noje annimitzilic sejpa huan oc sejpa pampa yihual hualas. ");
INSERT INTO nclNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juan Lacuayatequini neli lacuayatequiaya ca al. 