﻿USE sofia;
DROP TABLE IF EXISTS sofia.ncjNT_vpl;
CREATE TABLE ncjNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ncjNT_vpl WRITE;
INSERT INTO ncjNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ica inin tlahcuilolamatl techmatiltiyahque in ichichicacoluan in Totecohtzin Jesucristo, quen Yehhuatzin in ichichicaixuiu in David huan noyojqui den Abraham. ");
INSERT INTO ncjNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","In Abraham iconeu in Isaac huan in Isaac iconeu in Jacob, huan in Jacob iconehuan in Judá huan oc sequin icnihuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","In Judá iconehuan in Fares huan in Zara, huan in inana itoca Tamar. Huan in Fares iconeu in Esrom, huan in Esrom iconeu in Aram. ");
INSERT INTO ncjNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","In Aram iconeu in Aminadab, huan in Aminadab iconeu in Naasón, huan in Naasón iconeu in Salmón. ");
INSERT INTO ncjNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","In Salmón iconeu in Booz huan in inana itoca Rahab. In Booz iconeu in Obed huan in inana itoca Rut. Huan in Obed iconeu in Isaí. ");
INSERT INTO ncjNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","In Isaí iconeu in hueyixtoc David, huan in David iconeu in Salomón ica in inana aquin achto inamic in Urías. ");
INSERT INTO ncjNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","In Salomón iconeu in Roboam, huan in Roboam iconeu in Abías, huan in Abías iconeu in Asa. ");
INSERT INTO ncjNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","In Asa iconeu in Josafat, huan in Josafat iconeu in Joram, huan in Joram iconeu in Uzías. ");
INSERT INTO ncjNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","In Uzías iconeu in Jotam, huan in Jotam iconeu in Acaz, huan in Acaz iconeu in Ezequías. ");
INSERT INTO ncjNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","In Ezequías iconeu in Manasés, huan in Manasés iconeu in Amón, huan in Amón iconeu in Josías. ");
INSERT INTO ncjNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","In Josías iconehuan in Jeconías huan oc sequin icnihuan, ipan inon tonalten queman oquinuicaque tlatemactilten ipan in tlali Babilonia. ");
INSERT INTO ncjNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Satepa de inon, in Jeconías iconeu in Salatiel, huan in Salatiel iconeu in Zorobabel. ");
INSERT INTO ncjNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","In Zorobabel iconeu in Abiud, huan in Abiud iconeu in Eliaquim, huan in Eliaquim iconeu in Azor. ");
INSERT INTO ncjNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","In Azor iconeu in Sadoc, huan in Sadoc iconeu in Aquim, huan in Aquim iconeu in Eliud. ");
INSERT INTO ncjNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","In Eliud iconeu in Eleazar, huan in Eleazar iconeu in Matán, huan in Matán iconeu in Jacob. ");
INSERT INTO ncjNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","In Jacob iconeu in José, inamic in María, huan yehhua in inana in Jesús, yehhua in tetoca Cristo. ");
INSERT INTO ncjNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ijcon opanoc mahtlactli huan nahui ololten omopatlaque den Abraham hasta in David, huan oc mahtlactli huan nahui ihcuac oquinuicaque in israeltecos ipan in tlali Babilonia, huan oc mahtlactli huan nahui ihcuac yotlacatihuac in Cristo. ");
INSERT INTO ncjNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","In tenetlacatilis in Totecohtzin Jesucristo ijquin ocatca. In María yomotemacatoya ihuan motlalis in José. Huan ic yesquiyanihque sansecnin, yehhua yoquipixtoya in iconeu ica in ichicahualis in Itiotonaltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","In José se tlacatl molui tlamelajcan. Ahmo oquinec quitemactis maquinmiyacamatican ica in María. Oquinec quicahua san ichtaca, ahmo maquimatican in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Huan ic oquinehnehuili inon, se ángel oquimocochnextili huan oquiluic: ―José, ixuiu in David, ahmo ijcon xicchiconehnehuili ic ticselis quen mosihuau in María, tleca in conetl tehuaxca in Itiotonaltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","In María quiitas se iconeu, huan tictocahhuis Jesús, tleca Yehhuatzin quinmaquixtilos in techantlacahuan ica intlahtlacol. ");
INSERT INTO ncjNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Inin opanoc ic matzonquisa quen Totecohtzin oquitlahtoltiloc in tlayolchicauqui itoca Isaías: ");
INSERT INTO ncjNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","In ichpochtli quipiyas se iconeu, huan quitocahhuisque Emanuel, tlen quihtosnequi: Dios tohuan ilohuas. ");
INSERT INTO ncjNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ihcuac in José ocochihsac, oquichiu quen in ángel oquitequiuti, huan ocuicac in María quen isihuau. ");
INSERT INTO ncjNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Huan oquipiyaya san quen itetlaihtla huan ahmo ihuan omotlali hasta otlacat in achto iconeu, huan oquitocahhui Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","In Jesús otlacatihuac ipan in altepetl Belén, ipan in tlali Judea, ihcuac in Herodes in hueyixtoc ipan inon tlali. Ihcuac inon oahsitohque ipan in altepetl Jerusalén sequin tlacamen de canic hualpanquixohua in tonaltzintli, huan inon inquisca ixtlamatcamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Huan otlahtlanque: ―Tel, ¿canin otlacat in hueyixtoc den judeahtecos? Tleca otiquitaque in isitlal canic hualpanquixohua in tonaltzintli, huan ic inon otihualahque ic ticmahuestilisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ihcuac in hueyixtoc Herodes oquimat inon, yehhuatl omomouti, ihuan nochin tlacamen den Jerusalén. ");
INSERT INTO ncjNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Oncan in hueyixtoc oquinnotz in achtohque tiopixcamen huan in aquin otlanextiliyayahque ica in itlanahuatil in Moisés ica in tlacamen, huan oquintlahtlani canin tlacatis in Cristo. ");
INSERT INTO ncjNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Yehhuan oquihtohque: ―Ipan Belén, tlali Judea; tleca in tlayolchicauqui Isaías ijcon oquihcuilo in tlen omihto in Dios: ");
INSERT INTO ncjNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Huan namehhuan den Belén, tlali den Judá, ocachi hueyi iquisca namoaltepeu de nochin inon tlali Judá, tleca de ompa quisas se hueyixtoc, aquin quinitas nopiluan israeltecos. ");
INSERT INTO ncjNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Oncan in Herodes oquinnotz ichtaca inon ixtlamatcamen, huan oquintlahtlani yec tlen tonali ones inon sitlali. ");
INSERT INTO ncjNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Huan oquintitlan Belén, ic oquiniluic: ―Xiyacan ompa huan xitlahtlanican yec ica inon conetl. Huan ihcuac nancahsisque, no xinechnahuatican, huan noyojqui niyas nicmahuestilis. ");
INSERT INTO ncjNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Yehhuan oquicajque in hueyixtoc in tlen oquiniluic, huan oyahque. Huan inon sitlali tlen oquitayayahque canic hualpanquixohua in tonaltzintli oquinyecan hasta omotzecoto pani in cali canin ocatca inon conetl. ");
INSERT INTO ncjNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ihcuac in ixtlamatcamen ijcon oquitaque inon sitlali, yehhuan molui opajque. ");
INSERT INTO ncjNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Huan ic ocalajque ipan in cali, oquitaque in conetl ihuan inana María. Huan omotlancuaquetzque ic oquimahuestilihque inon conetl. Huan niman oquitlapohque intlamamal molui patiyo huan oquitlocolihque in itetlocolil in oro, huan in popochtli ahhueyac, huan in pahtli molui patiyo, itoca mirra. ");
INSERT INTO ncjNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Huan quen oquinnahuatiloc in Dios ica temictli inon ixtlamatcamen, ahmo maquinahuatican in Herodes, omocuepque in inchan ic oc se lado. ");
INSERT INTO ncjNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Huan ihcuac oyahque inon ixtlamatcamen, se ángel den Dios oquimocochnextili in José huan oquiluic: ―Ximehua huan xicuicacan in conetl ihuan in inana hasta in tlali Egipto, huan ompa ximocahuacan hasta nimitznahuatis. Tleca in Herodes quitemos inon conetl ic quimictis. ");
INSERT INTO ncjNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Oncan omeu in José, huan ica yohuali oquihuicaque in conetl ihuan inana hasta Egipto. ");
INSERT INTO ncjNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Huan ompa ocatcahque hasta omic in Herodes. Inin opanoc quen matzonquisa in quen Totecohtzin oquitlahtoltiloc in tlayolchicauqui itoca Oseas: “De Egipto onicnotz in noconeu.” ");
INSERT INTO ncjNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ihcuac in Herodes oquimat quen oquicahcayauque inon ixtlamatcamen, molui ocualan, huan oquinnahuati in soldados maquinmictican in telpocamen de ome xihuitl huan in ocachi cocone aquin chantihque Belén huan ipan in oc sequin altepetoton tlanahuac. Ijcon quen oquimatiltihque ica in tonali ica in sitlali de inon ixtlamatcamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ijcon otzonquis in tlen oquihcuilo in tlayolchicauqui Jeremías: ");
INSERT INTO ncjNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Omocac chicahuac tenalisten huan tzahtzilisten ipan in altepetl Ramá, huan yehhua in Raquel otzahtzitoya ica in ipiluan, huan ahmo oquinequiyaya moyolsehuis, tleca yomictoyahque. ");
INSERT INTO ncjNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Huan ihcuac yomic in Herodes, se ángel den Totecohtzin oquimocochnextili in José nepa Egipto, huan oquiluic: ");
INSERT INTO ncjNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―José, axan cuali xicuica in conetl ihuan inana, huan ximocuepacan ipan in tlali Israel, tleca yomijqui in aquin oquinequiyayahque quimictisque in conetl. ");
INSERT INTO ncjNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Oncan in José omeu, huan niman omocuepque ihuan in conetl huan in inana, ipan in tlali Israel. ");
INSERT INTO ncjNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Huan queman oquimat in José quen in Arquelao yehhua in hueyixtoc ipan in tlali Judea, ipatlaca in itata, omomouti yas ompa. Huan quen oquinahuatiloc ica temictli, oyahque ipan in tlali Galilea. ");
INSERT INTO ncjNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ic oahsitohque ompa, oyahque mochantiyahque ipan in altepetl Nazaret, ic matzonquisa quen oquihtohque in tlayolchicaucamen, quen in Jesús tetocahhuisque nazarenohteco. ");
INSERT INTO ncjNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ipan inon tonalten in Juan Tlacuatequiyani otlanonotztinemiyaya ipan in acahualtlahtli den Judea, ");
INSERT INTO ncjNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","huan oquiniluic: ―Ximoyolcuepacan, tleca ayacmo huehca hualahxihuas in tetlatequiutilistzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yeh inin in aquin ica otlahto in tlayolchicauqui Isaías, ihcuac oquihto: Quicaquisque quen quihtohtas inon tlanahuatili ipan in acahualtlahtli: “Hualuilohuas Totecohtzin. Ximoyectlalican ica namoyolo ic nanteselisque, ijcon quen nanquiyectlalisque in ohtli ic hualahxihuas in Totequihuatzin.” ");
INSERT INTO ncjNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","In itlaquen in Juan tlachihchiutli ica in itohmiyo in camello, huan in itlahcoilpica den cuitlaxtli, huan oquicuaya se chopili ixnesi quen tzicatl ihuan in inecyo in panatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Huan ohualahque quicaquihque in tlacamen den altepetl Jerusalén, huan nochin den tlali Judea huan nochin itlatilanal tlen caten den atlatentli Jordán. ");
INSERT INTO ncjNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Huan oquincuatequi ipan in atentli Jordán, ic omoyoluitihque intlahtlacol. ");
INSERT INTO ncjNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Huan ihcuac in Juan oquinitac miyacten in fariseos huan in saduceos ohualayahque mocuatequiyahque, ic inon oquiniluic: ―¡Tlacahcayaucamen san ome namoxayac! Tel, ¿aquin onamechnahuati ic nanmaquisasque ipan in hueyi tlapanolistli den Dios tlen mechualahsis? ");
INSERT INTO ncjNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Xicchihuacan in tlen cuali huan ijcon maquitacan quen onanmoyolcuepque. ");
INSERT INTO ncjNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Huan ahmo ximoyolchicahuacan namehhuan ic nanquihtosque: “Tehhuanten tiixuihuan in Abraham.” Tleca namechiluiya, hasta inin temen in Dios cuali mochihuasque ixuiuten den Abraham. ");
INSERT INTO ncjNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","In tetzahuitl ayacmo huehca. Quen aquin yau coutequi ipan in tlamiloli ica in tlen ahmo quitemacas cuali itlaquilyo, ijconon quitohuetzosque ipan in tletl. ");
INSERT INTO ncjNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nehhuatl, ic nele namechcuatequiya ica atl, quen ixmatcayotl ic yonanmoyolcuepque. Huan in aquin hualas satepa de nehhuatl mechmacalos in ichicahualistzin Itiotonaltzin Dios. Tleca Yehhuatzin ocachi mopiya in chicahualistli quen nehhuatl. Huan quinequis aquin ocachi tlamelajcan quen nehhua ic tepalehuis. ");
INSERT INTO ncjNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Huan tetequiu ica in tlacamen quen seya aquin yiquipixtica in tequitiyantli tlen ic mochipahuas in trigo. Huan quiehuas in trigo ihtech in coxtal ic quitlehcahuis tlapanco, huan in itlahsolyo quitlatis ipan in tletl canin ahyic sehui. Ijcon mocahuas chipahuac in lugar canin oquihuitec inon trigo. ");
INSERT INTO ncjNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Oncan in Jesús ohualuilohuac den tlali Galilea, huan oahxihuac hasta in atentli itoca Jordán canin ocatca in Juan Tlacuatequiyani, ic matecuatequi. ");
INSERT INTO ncjNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","In Juan ahmo oquinec tecuatequis, huan oteiluic in Jesús: ―Nehhuatl nicnequi manechcuatequilo. Tel, ¿ocachi hualuilohuas ica nehhua manitecuatequi? ");
INSERT INTO ncjNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","In Jesús omoluic: ―Axan xicahua san ijcon, tleca maticchihuacan huelica nochin tlen Dios mihtohua. Oncan in Juan Tlacuatequiyani ijcon oquichiu. ");
INSERT INTO ncjNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ihcuac in Jesús yomocuatequiloc, ohualquixohuac ipan in atl. Niman omotac in neluicactli quen omotlapo, huan in Jesús omotac in Itiotonaltzin Dios quen ohualtemoc quen se huilotl tepan Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Huan omocac in Jesús se tlahtoli den neluicac, tlen oquihto: ―Inin noconeu nictlasohtla huan nipaqui ica yehhua. ");
INSERT INTO ncjNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Niman in Itiotonaltzin Dios otehuicac ipan in acahualtlahtli in Jesús, ic mateyoltilana in ahmo cuali tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Omoxico ahmo otlacualoc ompohuali tonali huan ompohuali yohuali, huan satepa oapismicohuac. ");
INSERT INTO ncjNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Oncan in ahmo cuali tlacatl omopacho tenahuac in Jesús ic oteyoltilan, huan oteiluic: ―Tla nele ticoneu Dios, xictequiuti inin temen mamocuepacan in pantzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","In Jesús omonanquilic: ―¡Huelis ahmo! In Itlahcuiloltzin quihtohua: “Ica in pantzin ahhuel ica motecpanos in tlacatl. Ahmo pachihuis. Fuerza tetlacamatis ica itlahtoltzin Dios.” ");
INSERT INTO ncjNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Oncan in ahmo cuali tlacatl otehuicac ipan in altepetl Jerusalén, huan otetlehcahui itzoncuac in hueyi tiopantli, ");
INSERT INTO ncjNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","huan oteiluic: ―Tla nele ticoneu Dios, xipatlani; tleca in Itlahcuiloltzin quihtohua: In Dios motequiutisque in ángeles ic mitzitasque. Mitztzacuilisque ica inman, ic ahmo mamitzxococo niyan se tetl. ");
INSERT INTO ncjNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","In Jesús omonanquilic: ―Noyojqui in Itlahcuiloltzin quihtohua: “Ahmo teca ximahuilti in Motecohtzin Dios.” ");
INSERT INTO ncjNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Niman in ahmo cuali tlacatl otehuicac ipan se tepetl hueyi, huan quen tel oteixpatlatehuac ica nochin altepemen den tlalticpac huan ica inueyilis yehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Huan oteiluic: ―Nehhuatl nimitzmacas nochin inin tla timotlancuaquetzas ic tinechmahuestilis. ");
INSERT INTO ncjNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Oncan in Jesús omoluic: ―Xitzinquisa nonahuac, Satanás, tleca in Itlahcuiloltzin quihtohua: “Xitemahuestili in Dios huan san Yehhuatzin xitetlacamati.” ");
INSERT INTO ncjNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Oncan in ahmo cuali tlacatl otzinquis den Jesús, huan ohualahque sequin ángeles huan otepalehuihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ihcuac in Jesús omomat quen in Juan otzactoya ipan in telpiloyan, ohuilohuac ipan in tlali Galilea. ");
INSERT INTO ncjNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Huan ahmo omocahualoc Nazaret, tlahmo ohuilohuac mochantilo Capernaum. Inon altepetl ocatca itentla in atl, den tlalten den Zabulón huan den Neftalí. ");
INSERT INTO ncjNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Inin opanoc ic matzonquisa quen oquihcuilo in tlayolchicauqui Isaías: ");
INSERT INTO ncjNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Tlali den Zabulón huan Neftalí, in ohtli inahuac in mar, ic isentlapal in Jordán; Galilea, canin chantihque in aquin ahmo judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","In tlacamen aquin ixpoliutoque ipan in tlayohuilotl den miquilistli oquitaque in hueyi tlanextli. Oyahticatcahque miquihque queman oquintlanextili inon tlanextli, maquinehnehuilican ic mamaquisacan. ");
INSERT INTO ncjNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","De inon tonalten in Jesús opehualoc tlanonotzalo huan moluiyahque: ―Ximoyolcuepacan, tleca in tetlatequiutilistzin Dios ayacmo huehcahuis. ");
INSERT INTO ncjNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ihcuac opanolotaya in Jesús inahuac in atl Galilea, omotaque inehuan icnimen; inon itoca Simón, aquin noyojqui itoca Pedro, huan in oc seya itoca Andrés. Yehhuan in michtemohuanimen huan oquitlastinemiyayahque inmatlau ipan in atl. ");
INSERT INTO ncjNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Oncan Jesús oquiniluiloc: ―Xinechcuitlapanuican huan nanquinyolchicahuasque in tlacamen ic manechneltocacan. ");
INSERT INTO ncjNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yehhuan niman oquicauque inmatlau huan otecuitlapanuihque Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ic ohuilohuaticatca in Jesús omotzteuque oc ome icnimen, in Jacobo huan Juan, ipiluan in Zebedeo. Ocatcahque ihuan intata ipan se barco oquitlatlamanihtoyahque inmatlau. In Jesús oquinnotzaloc, ");
INSERT INTO ncjNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","huan yehhuan niman oquicauteuque in barco huan intata, huan otecuitlapanuihque Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","In Jesús oixnemohuac nohuiyan ipan in tlali Galilea, otlamachtilotinemiyaya ipan in tiopanten de inon altepemen. Oquinnonotzaloc ica inon cuali tlahtoli ica tetlatequiutilistzin in Dios huan omopahtihque ica nochin cocolisten tlen oquinahsiyaya inon tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Oquimatque nohuiyan ipan in tlali Siria in tetenehualoca in Jesús, huan otehualiquilihque nochin cocoxcamen, yehhuan in aquin oquipiyayahque in ahmo cuali yehyecatl, huan in aquin mimiquini, huan in aquin mocoupitzquetztiyesque. Huan Yehhuatzin in Jesús omopahtihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Huan otecuitlapanuihque miyac tlacamen den Galilea, huan den Decápolis, huan den Jerusalén, huan den tlali Judea, huan den isentlapal in Jordán. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ihcuac in Jesús omotaque in miyac tlacamen, otlehcoloc ipan in tepetl huan ompa omotlaliloc. Oncan oteyehualuihque in tetlamachticahuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Huan in Jesús opehualoc quinmachtilo ijquin: ");
INSERT INTO ncjNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Quinyolpaquilismacalo yehhuan aquin quinehnehuiliyahque ahhuel maquisasque san insel, tleca poutoque yehhuan ipan tetlatequiutilistzin in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Quinyolpaquilismacalo in aquin tlocoxtoque, tleca Yehhuatzin in Dios quinyolsehuilos. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Quinyolpaquilismacalo in aquin ahmo mohueyiliyahque, tleca yehhuan quiselisque nochin tlen cualtzin ipan oc se innemilis. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Quinyolpaquilismacalo in aquin quitemohuahque nochipa in tlen tlamelajcan, tleca Yehhuatzin in Dios quimpalehuilos ijcon quiahsisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Quinyolpaquilismacalo in aquin tetlapohpoluiyahque, tleca Dios no quintlapohpoluilos yehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Quinyolpaquilismacalo in aquin quinyolchipahualos in Dios, tleca yehhuan no teitasque. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Quinyolpaquilismacalo in aquin tetlacahualtiyahque tlamach, tleca Dios quintocahhuilos tepiluan. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Quinyolpaquilismacalo in aquin quinmohsihuiyahque tleca tetlacamatisque in Dios, tleca poutoque yehhuan ipan in tetlatequiutilistzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Mechyolpaquilismacalo namehhuan, ihcuac mechistlacahuisque huan ihcuac mechuihhuitequisque huan ihcuac mechcamanaluisque, tleca nampoutoque ica nehhua. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Xipactocan, tleca nanquiselisque hueyi namotlatlan neluicac. Huan xiquilnamiquican quen ijcon oquinmohsihuihque in tlayolchicaucamen achtohque de namehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Namehhuan quen in istatl de inin tlalticpactli. Quenin in istatl quitzacuiliya ic ahmo ihtlacahuis in michi, ijcon namehhuan ica tlamelajcan namonemilis nanquintzacuiliya in ahmo cualten ipan namoaltepeu, huan ijcon ahmo ihtlacahuis. Huan tla in istatl quisas ic poyec, tel, ¿quen cuali motequiutis? ¿Tlahmo yes tlixtohuetzoli ic maquixopechican in tlacamen? Huan ijcon noyojqui ica namehhuan in tlahmo nanquixicosque ipan namonemilis tlamelajcan. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Namehhuan ica namonemilis tlamelajcan quen in tlanextli de inin tlalticpactli. Nanmonextiyahque quen se altepetl tlen ca ipan se tlachquili ahhuel motlatisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Huan niyan ahmo moxotlaltis se tlanextli huan motlalis tlatlatiyan, tlahmo motlalis canin huehcapa ic maquintlanextili nochten in aquin yesque ipan in cali. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ijcon quen namehhuan, ximoteixmatiltican inixpa in tlacamen quen in tlanextli, huan ic quitasque ica in tlen cuali nanquichihuahque, yehhuan no matemahuestilican in Totahtzin aquin ilohuac neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Ahmo xicnehnehuilican nehhua onihuala nictlali tonali ica in itlanahuatil in Moisés, niyan ica in tlen omechnextilihque in tlayolchicaucamen. Ahmo onihuala nictlali tonali, tlahmo namechmatiltis in tlen melahuac quihtosnequi inon itlanahuatil. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ic nele namechiluiya, ic huehcahuis in neluicactli huan in tlalticpactli, ahmo polihui niyan se tlahtoli den tlanahuatili, hasta ic matzonquisa nochin. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ic inon, in aquin quixpanahuis san tlen tlahtoli den tlanahuatili, masque in ocachi quitzinin, huan quinnextiliya in tlacamen ijcon, yehhua mochihuas ocachi ahmo tlen iquisca ipan in tetlatequiutilistzin Dios. Huan in aquin quitlacamati, huan quinnextiliya in oc sequin ijcon, mochihuas ocachi hueyi iquisca ipan in tetlatequiutilistzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Tleca namechiluiya namehhuan, tla ahmo ocachi cuali namotlamachilis quen in tlamachtiyanimen den tlanahuatili huan in fariseos, ahyic nancalaquisque ipan in tetlatequiutilistzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Nanquicactoque tlen oquiniluihque in namochichicacoluan: “Ahmo xitemicti, tleca in aquin temictiya quipiya tlen quitlaxtlahuas ica inemilis.” ");
INSERT INTO ncjNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Huan nehhua namechiluiya, in aquin ihuan mocualantis in itlacaicniu quipiya tlen quixcomacalos. Huan in aquin quixiluiya itlahtlen in itlacaicniu, quiteluis ic maquixcomaca inahuac in tequihua. Huan in aquin quipacteca in itlacaicniu quitlapanoltisque ipan in mictlan. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Ic inon, ihcuac seya de namehhuan yau temahuestiliya, huan quilnamiquis quen quicocoliya se itlacaicniu, ");
INSERT INTO ncjNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","mayau motlahtolcaquican ihuan aquin mococoliya. Oncan cuali mocuepas ic temahuestilis. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’In tla aquin mitzteluiya, ocachi cuali ihuan ximotlahtolnamiqui ic ahmo mamitztemacti iixpa in tlixcomacani, tleca in tlixcomacani mitztemactis ihuan in topili, huan yehhuatl mitzuicas telpiloyan. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ic nele nimitziluiya, tla ompa tiyes, ahmo tiquisas hasta tictlaxtlahuas nochin tlen ticuiquiliya. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Nanquicactoque tlen oquiniluihque in namochichicacoluan: “Ahmo xisihuaahuilti.” ");
INSERT INTO ncjNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nehhua namechiluiya, in aquin quiita se sihuatl huan quichiconehnehuilis ahmo cuali ica yehhua, tlahtlacoltihtoc ijcon quen tla yosihuaahuilti. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Ic inon, ocachi cuali xiquilcahuacan in tlen mechixtilana ica in ahmo cuali huan in tlen mechtlahtlacolanaltiya. Huan ijcon nancalaquisque ipan in nemilistli nochipa. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tleca in aquin san tlen quichihua tlahtlacoli, masque pactoc ica inemilis axan, ijcon quitlapanoltisque nochipa mictlan. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’No oquihtohque tochichicacoluan de achto: “In aquin mosihuacahua ihuan isihuau, in tequihua quipiya tlen quimacas in sihuatl in amatl den mosihuacahualistli.” ");
INSERT INTO ncjNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Huan nehhua namechiluiya tla se tlacatl mosihuacahua san tlaluis, ijcon quinehnehuilisque in oc sequinten san tlacaahuiltiyani. Huan in aquin ihuan motlalis se sihuatl tlacacauqui, noyojqui mochihua sihuaahuiltiyani. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Noyojqui nanquicactoque tlen oquiniluihque in tochichicacoluan: “Ahmo xiquilcahua ica in tlen titemactihtoc ica motlanehnehuilis teixpa in Totecohtzin.” ");
INSERT INTO ncjNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nehhua namechiluiya, ahmo san tlaluis teca xitlahtocan, niyan ica in neluicactli, tleca inon in canin ilohuac in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Noyojqui ahmo san tlaluis xitlahtocan ica in tlalticpactli, tleca ompa noyojqui tlatequiutilo Yehhuatzin, niyan ica in Jerusalén, tleca inon tealtepeu in Dios Hueyicatzintli. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ahmo xicamanaltican ica namonemilis tleca san Yehhuatzin Dios cuali mechtequiutilo. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ahyic ximohueyilican ic xitlahtocan san tlaluis. Ihcuac nantlahtosque, xiquihtocan “queme” noso “ahmo”, tleca ica in tlen ocachi quihueyilis inin tlahtoli, inon huitz den ahmo cuali tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Yinanquicactoque in tlen omihto de achto: “In aquin oquiixcopin itlacaicniu, noyojqui maquiixcopina in tequihua. Huan in aquin quitlanmayahui se itlacaicniu, satepa noyojqui maquitlanmayahui in tequihua.” ");
INSERT INTO ncjNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Huan nehhua namechiluiya, ahmo xiquilnamiquican ic nanmomacuepasque in aquin ahmo cuali mechchihuilihtoc. Tla san aquin mechcocos, xictlapohpoluican. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Huan tla aquin mitzteluiya huan quinequi mitzcuilis nochin tlen ticpiya hasta mocamixa, xicahuili noyojqui in mocoton. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tla mitztequiutiyahque in tequihua ica se tequitl, xicchihua ome tanto ica se tonali. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ahmo xiquintlatzohtzocahui. San aquin mitztlahtlanilis itlahtlen, xicmaca, huan ahmo xiquixtlasa in aquin mitztlanehuilis. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Noyojqui nanquicactoque in tlen omihto achto: “Xictlasohtla in motenonotzcau huan xicocoli in motecocolihcau.” ");
INSERT INTO ncjNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Huan nehhua namechiluiya, xiquintlasohtlacan namotecocolihcahuan, huan xicselican in aquin mechcamanaliluis, huan xiquinchihuilican in tlen cuali in aquin mechixtlasa. Noyojqui xiquintlaihtlanican in aquin mechpactecas huan mechmohsihuis tequin. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ijcon namehhuan nanmonextiyahque tepiluan Tohueyitahtzin aquin ilohuac neluicac, tleca Yehhuatzin quintlanextililos ica in cualten huan in ahmo cualten huan mohualtitlanilisque in quiyahuitl in tlamelajcanten huan in ahmo. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ahmo tequiyo tla nanmotemachiyahque ica in aquin mechtlasohtla, huan ica in aquin mechcocoliya, ahmo. Ahmo aquin mechmahuestiliya ica inon, tleca no ijcon quichihuahque hasta in renderos. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Huan tla nanquintlahpalohuahque san yehhuan in namotlasohicnihuan, noyojqui ahmo tlen tequiyo. No ijcon quichihuahque in aquin ahmo teixmatihque in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Huan namehhuan tel, xiyecan tlamelajcanten, ijcon quen Namohueyitahtzin aquin ilohuac neluicac no Tlamelajcatzintli. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Ximomaluican ic ahmo nanquichihuasque in tlen cuali inixpa in tlacamen san ma ic mechitacan huan mechmahuestilisque. Tla ijcon nanquichihuahque, Namohueyitahtzin aquin ilohuac neluicac ahmo mechmacalos ocachi namotlatlan. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ic inon, ihcuac nanquimpalehuisque in aquin quimpolohua, ahmo aquin xiquiluican, quen quichihuahque in san ome inxayac ipan in tiopanten huan ipan in ohtli. Inin quichihuahque ic maquinuelitacan in tlacamen. Nehhua melahuac namechiluiya, ic inon yiquipiyahque intlatlan, ayacmo quinmacasque in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Huan namehhuan, ihcuac nanquimpalehuisque in aquin quimpolohua, xicchihuacan ijquin ahmo aquin maquimati, niyan in namotenonotzcau. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ocachi cuali tla nanquichihuasque san ichtaca, huan in Namohueyitahtzin, aquin mota nochin tlen ichtaca nanquichihuahque, mechmacalos in namotlatlan. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Ihcuac namehhuan nanmoyolmachtisque, ahmo xicchihuacan quen inohque ome inxayac, quimpactiya moyolmachtisque san ihcatiyesque ipan in tiopanten huan ipan in ohtli, ic maquinitacan in tlacamen. Ic nele namechiluiya, ic inon yiquipiyahque intlatlan. Ayacmo quinmacasque in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ihcuac se de namehhuan moyolmachtis, xicalaqui mochan, huan xitlatzacua huan ximoyolmachti ica in Motahtzin aquin mohuan ilohuas. Oncan Motahtzin, aquin mota nochin tlen ticchihuas, Tehhuatzin mitzmacalos motlatlan. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Huan ic timoyolmachtis, ahmo san xicueyili motlahtol, quen quichihuahque inohque aquin ahmo teixmatihque in Dios. Yehhuan quinehnehuiliyahque quen Dios quincaquilos ocachi ic motlatlautiyahque ocachi huehcau. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ahmo ximochihuacan quen yehhuan, tleca Tohueyitahtzin yimomautica tlen mechpolohua, masque ayamo nantetlahtlanilisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ic inon ximoyolmachtican ijquin: Tohueyitahtzin aquin ilohuac neluicac, mahuesticatzintli Tehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Huan maquintequiutilo nican tlalticpac, ijcon quen mochiutoc neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Matechmacalo axan in tlacuali tlen techpolohua. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Matechtlapohpoluilo totlahtlacoluan, ijcon quen tehhuanten otiquintlapohpoluihque in aquin techchihuilihtoque in ahmo cuali. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Huan ahmo matechcahualo tlen techyoltilanas, huan matechmaquixtilo den ahmo cuali. Tleca tehuaxca in tequihuahyotl, huan in chicahualistli, huan in mahuestilistli para nochipa. Ijcon mayeto. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Tleca in tla namehhuan nanquintlapohpoluihtoque in oc sequin aquin mechchihuilihtoque in ahmo cuali, Namotahtzin aquin ilohuac neluicac no mechtlapohpoluilos namehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Huan tla ahmo nanquintlapohpoluiyahque in oc sequin, Namotahtzin no ahmo mechtlapohpoluilos namotlahtlacoluan. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Huan namehhuan ihcuac nanquixicosque in apistli ic nanmoyolmachtisque, ahmo xicchihuacan quen inohque san ome inxayac. Yehhuan san tlixcahcayahuasque ihcuac quixicohque in apistli ic moyolmachtisque, maquichihuacan cuenta in oc sequinten. Ic nele, namechiluiya, inohque yiquipixtoque intlatlan huan ahmo tlen quiselisque ica in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Huan namehhuan ihcuac nanquixicosque in apistli, ximoihxamican huan ximoxitlatzocan ijcon quen mostli, ");
INSERT INTO ncjNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","huan ahmo maquimatican tla nanmosauticaten. Huan Yehhuatzin Namohueyitatzin aquin ilohuas namohuan, san Yehhuatzin mochihuas cuenta, huan mechmacalos namotlatlan. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Ahmo xicsentlalican in ricohyotl nican tlalticpac canin tlamicuacualohua huan nochin polihui, huan canin in ichtejcamen cuali quiichtequisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ocachi cuali xicsentlalican in ricohyotl neluicac canin ahmo tlacuacualohua, huan niyan tlen quipanos. Huan niyan in ichtejcamen cuali calaquisque ic tlachtequisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Huan canin eutoc inon ricohyo, ompa mechyolquitzquihtos. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’In itlanehnehuilis in tlacatl, yeh in quen tlanextli ipan inemilis. Huan tla tlamelajcan itlanehnehuilis, ahmo nemis ipan in tlayohuilotl. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Huan tla ahmo cuali itlanehnehuilis, ijcon nemis ipan in tlayohuilotl huan ahmo ipan tlanextli. Ijcon nemis ipan in tlayohuilotl huehca den Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Niyan aquin cuali quitlacamatis ome itecohhuan. Tleca quixtlasas in seya huan quitlasohtlas in oc seya. In seya quitlacamatis huan in oc seya ahmo quichihuas cuenta ihuan. In aquin quichihuas cuenta san ica in tomin ahhuel tetlacamatis in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Tel, namechiluiya, ahmo xiahcomanican ica tlen nantlacuasque noso ic nanatlisque, niyan quen nanmotlaquentisque. In Dios nele otechmacalo in nemilistli, huan cuali techtlamacalo. No ijcon oquimochihuilili in totlacayo huan cuali techtlaquentilo. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Xiquitacan quen in totomen patlanihque ipan in yehyecatl. Huan ahmo tlen quimilohuahque, niyan quiehuahque intlacual. Masque ijcon ca, Namotahtzin aquin ilohuac neluicac quintlamacalo. Tel, ¿ahmo ocachi namopatiu quen in totomen? ");
INSERT INTO ncjNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Tel, ¿aquin de namehhuan, ic quiahcomana, cuali yolis oc tlahco metro? ");
INSERT INTO ncjNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Tel, ¿tleca nanahcomani namehhuan quen nanmotlaquentisque? Xicyequitacan quen yolihque in xochicouten den mila, huan ahmo tequitihque quen tehhuan, niyan ahmo quiahcomanihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Huan masque tequin cualtzin itlaquen in hueyixtoc Salomón, icualnexca ahmo ahsi icualnexca quen se de inin xochitl. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","¿Huan tla in Dios ijcon cualtzihto mochihua inon xochicohuitl, tlen axan ompaca ic mila huan mostla motlatis ipan in tlecuili, tleca in tlahmo ocachi mechtlaquentilos namehhuan san chihton namotlaneltoquilis? ");
INSERT INTO ncjNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ic inon, ahmo xiahcomanican ic nanquihtosque: “Tel, ¿tlen ticuasque? noso tel, ¿tlen ticonisque? noso tel, ¿tlen tiquemisque?” ");
INSERT INTO ncjNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tleca in tlalticpac tlacamen quichihuahque cuenta san ica inon. Huan namehhuan nanquipiyahque se Namotatzin den neluicac aquin yimomati tlen mechpolohua. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ijcon tel, xicchihuacan cuenta achto quen nantetlacamatisque in Dios huan quen nanmochihuasque tlamelajcan ijcon quen Yehhuatzin, huan nanquiselisque noyojqui nochin tlen mechpolohua. ");
INSERT INTO ncjNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ahmo xiahcomanican ica tlen panos mostla. Ahmo ijcon nanmopalehuisque ica inon. Nochin tonali quipiya in tlen tequiyo. ");
INSERT INTO ncjNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Ahmo ica xitlahtocan in oc sequin, in tlahmo ijconon mechtlahtlacoltilos in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Quen ica nantlahtohuahque in oc sequin, no ijcon namoca tlahtohuahque yehhuan. In aquin tequin teca tlahtohua, no ijcon tequin ica tlahtohuahque. ");
INSERT INTO ncjNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Tel, ¿tleca ticchihuas cuenta ica quitzinin itlahtlacol motlacaicniu, tlen nesi quen teutli ipan iixtelolo, huan ahmo ticchihuas cuenta ica ocachi hueyi motlahtlacol tlen nesi quen se cohuitl ipan tehhua moixtelolo? ");
INSERT INTO ncjNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Huan tla tehhua ticpiya quen se cohuitl ipan moixtelolo, tel, ¿quen cuali tiquiluis in motlacaicniu: “Xinechcahuili nimitzquixtilis in teutli ipan moixtelolo”? ");
INSERT INTO ncjNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","San timohueyiliya. Ximoyolcuepa achto ica motlahtlacol huan ijcon cuali tictlalnamictis in motlacaicniu ica itlahtlacol. ");
INSERT INTO ncjNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Nanquimatihque oncan tlacamen ahmo quichihuasque cuenta ica itlahtoltzin Dios, huan ocachi cuali ahmo xiquinnonotzacan tleca yehhuan quen chichimen noso pitzomen. In tlen cualtzin ahmo quinmacasque, tleca in pitzomen san quixoxacualohua huan in chichimen tecuasnequihque masque nanquimacasque tlen cualtzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Xitetlahtlanilican huan mechmacalos quen seya aquin quitemohua hasta quiahsis in tlen quinequi, huan quen seya aquin quixcalanis in puerta hasta quinanquilisque huan quitlapoluisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tleca in aquin ijcon quitlahtlanis, yehhua quiselis in tlen quinequis. ");
INSERT INTO ncjNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Tel, ¿oncan seya de namehhuan ixcohyehui quimacas in iconeu se tetl ihcuac quitlahtlanis in pantzin? ");
INSERT INTO ncjNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Noso tel, ¿quimacas se cohuatl ihcuac quitlahtlanilis in michi? ");
INSERT INTO ncjNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Huan queme nanquimatihque quen nanquinmacasque in tlen cuali in namopiluan, masque ahmo nancualten. Huan ocachi in Tohueyitahtzin aquin ilohuac neluicac quinmacalos tlen cuali in aquin tetlahtlanilisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Ijcon tel, xicchihuacan ica in oc sequin quen nanquinequisque in oc sequin no ijcon maquichihuacan ica namehhuan. Tleca yeh in tlen techtequiutiya ica itlanahuatil Moisés huan ipan in amahuan in tlayolchicaucamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Oncan ome tlanehnehuilisten den innemilis in tlacamen. Xicneltocacan ica in tlanehnehuilistli tlamelajcan, masque ocachi tequiyo. In oc se tlanehnehuilistli nesi molui cualtzin huan ahmo tequiyo. Huan inon tlanehnehuilistli ahmo cuali tehuica mictlan huan miyacten quihuicatinemihque sajcon. ");
INSERT INTO ncjNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Inon tlanehnehuilistli tlamelajcan molui tequiyo huan san yeh in tlen tehuica ica nemilistli nochipa, huan molui quesqui ijcon quihuicatinemihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Ximomaluican ica inohque tlacahcayaucamen aquin quihtosque tlanonotzahque teca in Dios. Inohque huitzen san tlamachten quen in calnelo, huan tlahmo san quen lobos aquin quinxinisque ica in ahmo cuali tlanextilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Namehhuan nanquinixmatihque ica tlen quichiutoque. Ahmo moahsis in uvas ipan in huetztli, niyan in higos ipan in xihuitl. ");
INSERT INTO ncjNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ijcon tel, quen in cuali cohuitl quitemaca itlaquilyo cuali, ijcon noyojqui in cuali tlacatl quichihuas in tlen cuali. Huan ijconon ca ica in ahmo cuali, masque in cohuitl noso in tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","In cohuitl tlen cuali ahhuel quitemacas in tlen ahmo cuali itlaquilyo, niyan in ahmo cuali cohuitl quitemacas cuali itlaquilyo. ");
INSERT INTO ncjNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ijcon quen nochin cohuitl tlen ahmo quitemaca cuali itlaquilyo motehtequi huan motlatiya ipan in tletl, noyojqui in tlacatl aquin ahmo quichihuas in tlen cuali quixtohuetzosque mictlan. ");
INSERT INTO ncjNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ijcon, namehhuan nanquinixmatisque inohque tlacahcayaucamen ica tlen yehhuan quichihuahque. ");
INSERT INTO ncjNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Ahmo nochten in aquin nechnotzahque: “Notecohtzin”, calaquisque ipan tetlatequiutilistzin in Dios. Tlahmo san inohque aquin quichihuasque in itlanequilistzin Nohueyitahtzin aquin ilohuac neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ihcuac ahsiquiu inon tonali, miyacten nechiluisque: “Totecohtzin, tehhuanten otitlanonotzque ica in Motocahtzin, huan ica in Motocahtzin otiquinixtohuetzohque in ahmo cuali yehyecamen, huan ica in Motocahtzin oticchiuque miyac tlachiuten mahuestic.” ");
INSERT INTO ncjNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Huan niquiniluis: “Masque ijcon ca nochin melahuac, ahyic onanmotemactihque ica nehhuatl. Ximoxelocan de nehhua, tleca san onannechixtlasque ica nochin tlen onanquichiuque.” ");
INSERT INTO ncjNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Ijcon tel, in aquin nechcaquis huan quichihuas in tlen niquihtohua, yehhua in quen se tlacatl tlamati aquin oquichihchiu in ical ipan in tepetlatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ohuala in quiyahuitl, huan ohueyix in atentli, huan tequin ipan oyehyecac, huan ahmo ohuetz inon cali tleca yec icxitihtoc ipan inon tepetlatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Huan in aquin nechcaquis huan ahmo quichihuas in tlen niquihtohua, yehhua quen in tlacatl xoxo. Oquitelquetz in ical ipan in xali. ");
INSERT INTO ncjNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ohuala in quiyahuitl huan ohueyix in atentli, huan ipan oyehyecac inon cali, huan ohuetz, huan ijcon omocau tlatepehxiuyo. ");
INSERT INTO ncjNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ihcuac in Jesús otlan tlanonotzalo, in tlacamen quen tel oquimatque ica tlen oquinnonotzaloc. ");
INSERT INTO ncjNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Tleca oquinnextililoc quen seya aquin nele oquimat, ahmo quen in tlamachtiyanimen den itlanahuatil in Moisés. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ihcuac in Jesús ohualtemoloc ipan in tepetl, miyac tlacamen otecuitlapanuihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Huan omopacho se tlacatl cocoxqui ica inon pahpalanilistli, huan omotlancuaquetz teixpa in Jesús, huan oteiluic: ―Notecohtzin, cuali nechpahtilos in tla monequis. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Oncan Jesús omomachilic ica in teman huan omoluic: ―Tleca in tlahmo. Xipahti. Ic omihto inon in Jesús, niman in cocoxqui opahtic. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Huan Jesús omoluic: ―Xicchihua cuenta, huan ahmo aquin xiquilui. In tlahmo xiyau ximotemacti inahuac in tiopixqui quen omihto in Dios. Huan ompa xitemacti quen motetlocolil in tlen Moisés otlatequiuti ica inon mococolis. In tiopixqui sajcon quinmatiltiya in tlacamen quen yotipahtic ica inon mococolis. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ic ocalacohuac in Jesús ipan in altepetl Capernaum, se tlayecanqui romanohteco omopacho tenahuac huan otetlatlauti. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Oquihto ijquin: ―Tlacatzintli, se telpocatl ompaca calihtec ipan tlapechtli, huan tlapanotica ica in coupitzahuilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","In Jesús omoluic inon romanohteco: ―Nehhua niyas nicpahtis inon telpocatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","In tlayecanqui romanohteco otenanquilic: ―Tlacatzintli, nehhuatl ahmo tlen noquisca ic calacohuas nochan. San matlatequiutilo huan mapahti in telpocatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Masque nehhua noyojqui nechtequiutiya in oc sequin hueyixtoque, noyojqui nechpiyaltihtoque sequin soldados maniquintequiuti. Ihcuac niquiluis se de inohque mayau, quipiya tlen yas. Huan ihcuac niquiluis oc seya mahualau, quipiya tlen hualas. Huan ihcuac nictequiutis in notlaquehual, quipiya tlen quichihuas. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ihcuac Jesús omocac inon, quen tel omomat, huan omoluihque in oc sequin aquin otecuitlapanuiyayahque: ―Ic nele, namechiluiya, ica nochin tlacamen israelteco ahmo aquin nicahsitoc ica in miyac itlaneltoquilis quen inin tlacatl romanohteco. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Namechiluiya quen hualasque miyac tlacamen den nohuiyan ipan in tlalticpactli, huan motlalisque tlacuasque ihuan in Abraham, huan Isaac, huan Jacob ipan tetlatequiutilistzin in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Huan inohque aquin yesquiyanihque ipan tetlatequiutilistzin in Dios, inohque quinixtohuetzosque ipan in tlayohuilotl canin chocasque huan tlantzahtzisque ica in tlatlalistli. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Oncan Jesús omoluic in tlayecanqui romanohteco: ―Mahuilohua techan huan mayeto ica tetlanequilis quen omoneltocac. Huan inon telpocatl opahtic inon rato. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","In Jesús ohuilohuac ichan in Pedro, huan ompa omotac in imonantzin ohuetztoya ipan in tlapechtli ica in totonqui. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","In Jesús omomaquitzqui, huan oquis inon totonqui. Oncan omeu huan oquintlamacac. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Inon tlapoyaucan otehuiquilihque in Jesús miyacten aquin oquipiyayahque in ahmo cuali yehyecamen. Huan san ica se tlahtoli omoixtohuetzohque inon ahmo cuali yehyecamen, huan noyojqui omopahtihque in miyacten cocoxcamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Inin opanoc ic matzonquisa in tlen oquinmatilti in tlayolchicauqui Isaías, ihcuac oquihto: “Yehhuatzin otechpahtiloc ica tococolis huan otechpalehuiloc ica totlocol.” ");
INSERT INTO ncjNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ihcuac in Jesús omotac miyac tlacamen oteyehualohtoyahque, omotequiutihque mapanocan isentlapal in atl. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Huan se tlamachtiyani den itlanahuatil Moisés omopachoc tenahuac in Jesús huan oteiluic: ―Tlamachtiyani, nitecuitlapanuisnequi san canic huilohuas. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","In Jesús omonanquilic: ―In tanchau quipiya in itlacoyoc huan in totomen quipiyahque intlapehpech, huan nehhuatl aquin Nitetiachicau ica nochin tlacatl ahmo nicpiya niyan canin nimocuatecas. Quihtosnequi se yolcatl ocachi quipiya quen in aquin nechcuitlapanuis nican tlalticpac. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Huan oc se de inon momachtiyanimen oteiluic: ―Notecohtzin, ma oc nechchiyalo tleca nicpiya tlen nicchihuas ic miquis notatzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","In Jesús oquinanquililoc: ―Xinechcuitlapanui, huan xiquincahuacan in aquin ayamo quineltocahque maquintocacan inmijcahuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Oncan Jesús ocalacohuac ipan in barco, huan in tetlamachticahuan otecuitlapanuihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Huan omahcoc in atl ica in chicahuac yehyecatl hasta oquitlapachohuaya in barco. Huan Jesús ocochihuatoya. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Oncan in tetlamachticahuan oteihxitihque huan oteiluihque: ―¡Totecohtzin, matechmaquixtilo, tleca timoatocahticaten! ");
INSERT INTO ncjNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Huan Yehhuatzin oquinnanquililoc: ―Tel, ¿tleca tequin nanmomoutiyahque? ¡Namehhuan san chihton namotlaneltoquilis! Oncan omoquetzaloc Yehhuatzin huan oquitlacahualtiloc in yehyecatl huan in hueyi atl huan ic inon omocau tlamach. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Huan in tetlamachticahuan quen tel oquimatque huan omoluihque: ―Tel, ¿tlen tequisca inin tlacatzintli, hasta in yehyecatl huan in hueyi atl tetlacamatihque? ");
INSERT INTO ncjNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ihcuac Jesús oahxihuato isentlapal in atl, ipan in tlali Gadara, ome tlacamen ohualchocoquisque in canin motocahque in mijcamen, huan omopachohque tenahuac in Jesús. In inehuan oquipiyayahque in ahmo cuali yehyecatl huan molui tlamohmoutiyahque. Huan ic inon niyan aquin ahhuel panohua ipan inon ohtli. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Huan opeu tzahtzihque: ―Tel, ¿tleca timocalactiya ica tehhuan, Jesús, ticoneu Dios? Tel, ¿otihuala ic titechtlapanoltis achto den totonal? ");
INSERT INTO ncjNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Huan ahmo tequin huehca de ompa miyacten pitzomen otlahtlacuahtinemiyayahque. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Huan in ahmo cuali yehyecamen otetlatlautihque in Jesús: ―Quen titechixtohuetzos, xitechcahua maticalaquican ipan inon pitzomen. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Oncan Jesús oquiniluic: ―Cuali xicalaquican. Huan in ahmo cuali yehyecamen oquisque ipan inon tlacamen huan ocalajque ipan in pitzomen. Niman inon pitzomen otzecuinque ic tlatepehxiucan huan ohuetzque ipan in atl huan omelsinque. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Huan in tlixpiyanimen ica in pitzomen ocholohque ica moucayotl, huan oahsitohque ipan in altepetl. Otlanonotzque ica nochin tlen opanoc ica inon tlacamen aquin oquipiyayahque in ahmo cuali yehyecamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Oncan nochin tlacamen den altepetl oyahque canin oilohuaya in Jesús, huan ic oteahsitohque, otetlatlautihque maquixohua ipan inon intlal. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Oncan Jesús opanoloc ipan in barco ic oc se lado den atl, huan oahxihuato ipan tealtepeu. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Huan ompa otehuiquilihque se tlacatl cocoxqui ica inon coupitzahuilistli ipan itlahpech. Ihcuac Jesús omotac in intlaneltoquilis yehhuan, omoluic in cocoxqui: ―Ximoyolchicahua notlasohicniu, tleca motlahtlacoluan mitztlapohpoluihtoque. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Oncan sequin de inon tlamachtiyanimen den itlanahuatil Moisés oquinehnehuilihque oc noncua: “Inin tlacatl ahmo quihtoni quen tla yehhua in Dios.” ");
INSERT INTO ncjNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Huan quen Jesús omomat quen oquinehnehuilihque, omoluihque: ―Tel, ¿tleca ahmo cuali namotlanehnehuilis? ");
INSERT INTO ncjNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Quen nanquimatihque in tlahmo nicpiya tequihuahyotl ic nictlapohpoluis itlahtlacol? In tla nicpahtis inin cocoxqui queman niquiluis: “Ximehua, huan xiyau”, ");
INSERT INTO ncjNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ijcon nanquimatisque in tla nehhua aquin Nitetiachicau ica nochin tlacatl cuali nictlapohpoluis itlahtlacol. Ic inon oquiluiloc in cocoxqui: ―Ximehua, xicana motlapech huan xiyau mochan. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Oncan in cocoxqui omoquetz huan oya ichan. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ihcuac in tlacamen oquitaque in tlen opanoc, nochten omomoutihque huan otemahuestilihque in Dios ic omomacaque in tequin cuali chicahualistli in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","In Jesús ohuilohuac de ompa, huan onechitaloc nehhuatl notoca Mateo. Onitequiutoya in canin quitlaxtlahuahque in renta. Huan onechiluiloc: ―Xinechcuitlapanui. Huan onimoquetz huan onitecuitlapanui. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Opanoc quen in Jesús ohuilohuac tlacualo nochan, huan miyacten inon renderos ihuan oc sequin tlahtlacolyohque oahsitohque ompa. Huan tinochten san secnin oticatcahque iixpa in mesa, tehuan in Jesús huan in oc sequin tetlamachticahuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Huan sequin in fariseos ic oquitaque inin, otechiluihque tehhuan titetlamachticahuan: ―Tla nele se cuali tlacatl in namotemachticau, ahmo tlacuani ihuan in renderos huan in tlahtlacolyohque. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","In Jesús omocac inon, huan omoluihque: ―San yehhuan in cocoxcamen yahue quita in tepahtiyani, huan yehhuan aquin quinehnehuiliyahque chicahuac, ahmo. Ijcon noyojqui, nechualahsisque nehhuatl san yehhuan aquin quinehnehuiliyahque cuali niquimpalehuis. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Huan axan xicchihuacan cuenta tlen quihtosnequi in tlen omihto in Dios ipan in Itlahcuiloltzin: “In tla nele nannechmahuestilisque, huan ahmo san ica in tlaolichtilistli den tiopan, tel, xiquintlapohpoluican in oc sequinten.” Ahmo niquimpalehuis yehhuan aquin quihtohuahque mach yitlamelajcanten. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Oncan in itlamachticahuan in Juan Tlacuatequiyani omopachohque tenahuac in Jesús, huan otetlahtlanihque: ―Tel, ¿tleca ahmo nanmosahuahque quen tehhuan huan in fariseos? ");
INSERT INTO ncjNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","In Jesús omonanquilihque: ―Nehhua quen se mosihuautiyani huan in notlamachticahun quen itetlatlautiluan. Tel, ¿cuali mosautiyesque in itetlatlautiluan ipan in mosihuautilistli ic ihuan ompayes in mosihuautiyani? Hualahsis in tonali queman in mosihuautiyani quincuilisque. Oncan ihcuac mosahuasque yehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ijcon omihto in Jesús ica in yancuic tetlanehnehuilis. Huan ocachi omihto: ―Niyan aquin ijcon quichihuas quitlatlamanis se tlaquemitl tlen yihuehcau ica in yancuic tatapahtli. Tla ijcon quichihuas, in tlatlamanilistli ihsiu tzomonis ic cototzahuis in yancuic tatapahtli. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Noyojqui niyan aquin quitlaxilis in vino ayamo chicahuac ihtech in cuitlaxtli yihuehcau. Tla ijcon quichihuas, inon vino quitzomonis in cuitlaxtli, huan ijcon polihuis in vino huan in cuitlaxtli. In vino ayamo chicahuac quiehuasquiyani ihtech in yancuic cuitlaxtli. Ijcon cuali moehua nochin ome. Ijcon noyojqui notlanehnehuilis yancuic ahmo quinamiquis ica intlamachilis yihuehcau. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Huan ic oquinnonotzaloticatca in Jesús inin tlahtoli, se hueyixtoc den judeahtecos oahsito, huan omotlancuaquetz teixpa, huan oquihto: ―In nochpocau hueloc omic, huan tla hualuilohuas Tehhuatzin huan motlalis teman ipan noconeu, oc sepa yolis. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","In Jesús omoquetzaloc huan omocuitlapanui inuan tehhuan titetlamachticahuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Huan ocatca se sihuatl oxitiniyaya ica in iyes mahtlactli huan ome xihuitl. Huan omopacho ic tecuitlapa in Jesús, huan otequitzquilic tetatapa. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tleca oquiyolnehnehuilic: “Tla nitequitzquilis san yeh tetlaquen, niman nipahtis.” ");
INSERT INTO ncjNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Huan Jesús omocuepaloc huan omotac inon sihuatl huan omoluic: ―Ximoyolchicahua, notlasohicniu; yotipahtic tleca otinechneltocac. Huan niman inon rato opahtic. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ihcuac in Jesús oahxihuato ichan in hueyixtoc, niman omotaque in tlatzotzoncamen ica in motlalpacholistli huan in tlacamen otzahtzitoyahque chicahuac. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Huan in Jesús oquiniluiloc: ―Xiquisacan de nican, tleca in ichpocatl ahmo mictoc, tlahmo cochtoc. In tlacamen teca ohuetzcahque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Huan in Jesús omoquixtihque inon tlacamen, huan ocalacohuac huan omomaquitzqui in ichpocatl huan yehhua omeu. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Huan ipan nochin inon tlali omomat in tehueyiloca ica tlen opanoc. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ic oquixohuac de ompa in Jesús, inehuan in ixpatzacten otetzahtzilihticatcahque: ―¡Toca xitlocoya quen Tehhuatzin in Ichichicaixuiutzin in hueyixtoc David! ");
INSERT INTO ncjNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ihcuac in Jesús ocalacohuac ipan in cali, inehuan inon ixpatzacten omopachohque tenahuac, huan Yehhuatzin omotlahtlanihque: ―Tel, ¿nanquineltocahque namehhuan cuali namechpahtis? Yehhuan oquihtohque: ―Queme, Totecohtzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Oncan in Jesús omomachilic in inixtelolo huan oquiniluiloc: ―Mayeto ijcon quen namotlaneltoquilis nanquipiyahque. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Huan ijcon niman otlachixque. Oncan Jesús tequin oquintequiutiloc: ―Ahmo aquin maquimati. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Huan niman ic oquisque de ompa, otlanonotzque nohuiyan ipan inon tlali ica tlen oquinchihuililoc in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ihcuac oquisque inon ixpatzacten, sequin tlacamen otehualiquilihque in Jesús se tlacatl mudo, aquin oquipiyaya se ahmo cuali yehyecatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ihcuac in Jesús omoixtohuetzalui in ahmo cuali yehyecatl, inon mudo niman opeu tlahtohua. In tlacamen quen tel oquimatque huan oquihtohque: ―Ahyic motztoc ipan in altepetl Israel se quen inin tlachiutli. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Huan in fariseos oquihtohque: ―Inin tlacatl quinixtohuetzohua in ahmo cuali yehyecamen ica in ichicahualis in tlayecanqui de yehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","In Jesús oixnemohuac nohuiyan ipan in altepemen, otlanonotzalohuaya ipan in tiopanten. Omomatiltiyayahque ica in tetlatequiutilistzin Dios. Huan otlapahtilohuaya ica nochin cocolisten. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Huan ic omotaque inon tlacamen, inca otlocoyaloc, tleca ahmo quipiyahque aquin quinnonotzas ica in Dios, huan ic inon nesihque tlocoyahque quen in calnelohten ahmo quipiyahque impaxtol ic maquinita. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Oncan otechiluiloc tehhuan titetlamachticahuan: ―Xiquinitacan quesqui oncan yiquinecticaten quineltocasque itlahtoltzin Dios, huan molui quesqui in tequitcamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ic inon tequin xitetlatlautihtiyecan in Dios maquinualtitlanilo in tequitcamen ic maquineltoctican ica Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Oncan Jesús otechnotzaloc tehhuan in mahtlactli huan ome titetlamachticahuan huan otechmacaque tequihuahyotl ic tiquinixtohuetzosque in ahmo cuali yehyecamen huan ic titlapahtisque ica nochin cocolisten. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yehhua inin in intoca in mahtlactli huan ome tetiotlatitlaniluan: in achto, yeh in Simón, noyojqui oquitocahhuiyayahque Pedro, ihuan icniu Andrés; in Jacobo huan icniu Juan, ipiluan in Zebedeo; in oc sequin ");
INSERT INTO ncjNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","in Felipe, in Bartolomé, in Tomás, huan nehhuatl in Mateo, aquin onicatca in rendero; huan in Jacobo iconeu in Alfeo; Lebeo, aquin noyojqui oquihtocahhuiyayahque Tadeo; ");
INSERT INTO ncjNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","in Simón, inon opoutoya ipan in ololi canaanteco; huan in Judas Iscariote, yehhua in aquin satepa otetemacti in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","In Jesús otechtitlaniloc tehhuan in mahtlactli huan ome ica tlen Yehhuatzin otechtequiutiloc huan otechiluihque: ―Ahmo xiyacan ipan inon intlal in aquin ahmo judeahtecos huan ahmo xicalaquican ipan in altepemen den Samaria. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ocachi cuali xiyacan ica in israeltecos aquin chayautoque quen in calnelohten. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Xiquinnonotzacan ica in tetlatequiutilistzin Dios, quen yoahsico in itonaltzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Xiquimpahtican in cocoxcamen, huan in aquin pahpalanticaten. Xiquinihxitican in mijcamen, huan xiquinixtohuetzocan in ahmo cuali yehyecamen. Namehhuan san onamechtlocolihque inin chicahualistli. Ahmo xiquincobrarocan ic nanquitequiutisque inin chicahualistli. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Ahmo xicuicacan in tomin, niyan tlen, ");
INSERT INTO ncjNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","niyan in mantahcostal ipan in ohtli. Xicuicacan san yeh in se namotetepa. Ahmo xicuicacan namocoutopil niyan namotecac. Quen in tequitqui quipiya tlen quimacasque itlacual, no ijcon mechmacasque campa nantlanonotzasque. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Ihcuac nanahsitihue ipan se altepetl, noso tlachicoyan, ompa xictemocan se aquin cuali tlacatl huan ompa ximocahuacan ichan hasta ic nanyasque. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ic nancalaquisque in techan, xiquintlahpalocan ica mahuestilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tla inon chanimen mechuelitasque, nele mocahuas inon namotlasohtlalis, huan in tlahmo, xiquinixtohuetzaluican. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Huan in tlahmo mechseliyahque, niyan mechcaquisque ica tlen nanquinnotzasque, xiquisacan ipan inon cali noso ipan inon altepetl huan ximoxotzetzelocan ica in teutli den namocxihuan, maquichihuacan cuenta quen omechixtlasque. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ic nele, namechiluiya, quen ipan inon tonali den tlixcomacalistli, in itlapanolis inon tlacamen ocachi chicahuac yes quen den inohque tlacamen sodomahtecos huan gomorrahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’¡Maquichihuacan cuenta! Namechtitlani namehhuan inepanco in ahmo cuali tlacamen ijcon quen in calnelohten ahhuel mopalehuiyahque ica in tecuanyolcamen. Ic inon mayecan tlamatihque quen in cohuatl, huan san tlamach quen in huilotl. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ximomaluican, tleca inon tlacamen mechtemactisque inixpa in tequihuahmen, huan mechuihhuitequisque ipan in tiopanten. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Huan mechuicasque inixpa in hueyixtoque nopampa, huan ijcon cuali nantlahtosque ica nehhuatl inixpa, huan ica inohque ahmo judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Huan ihcuac mechtemactisque inixpa in tequihuahmen, ahmo xiahcomanican ica tlen nanquihtosque noso quen nanquiniluisque, tleca ic nantlahtosque, in Dios mechmacalos in tlahtoli. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tleca ahmo namehhuan namotlahtol, tlahmo mechmacalos namotlahtol in Itiotonaltzin in Namohueyitahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’In tlacamen quinichtacateluisque in icnihuan ic maquinmictican huan in tetatahmen quinichtacateluisque impiluan, huan impiluan momacuepasque ica intatahhuan, huan quinmictisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nochin tlalticpac tlacamen mechixtohuetzosque nopampa, huan in aquin quixicos in tlamohsihuilistli, inon maquistos. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ihcuac mechmohsihuisque ipan se altepetl, xicholocan ipan oc seya. Ic nele namechiluiya, ayamo nantlamiixnentosque ipan inaltepeu in israeltecos in tlahmo achto nihualas nehhua aquin Nitetiachicau ica nochin tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Niyan se momachtiyani ocachi hueyi quen in tlamachtiyani. Huan niyan se tlaquehuali ocachi hueyi quen iteco. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","In momachtiyani ahmo ocachi hueyi iquisca quen in tlamachtiyani, niyan in tlaquehuali ocachi quen in iteco. In tla nechtocahhuiyahque Beelzebú, huan nehhuatl quen in tetata den cali, cox, ¿ahmo ijcon quihtosque ica in nochanihcahuan? ");
INSERT INTO ncjNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Ic inon, ahmo xiquinmoucaitacan ica yehhuan. Tleca ahyac niyan tlen ichtaca in tlahmo manestiye, huan ahmo oncan tlen tlatiutoc in tlahmo motematiltis. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","In tlen namechmachtihtoc san namehhuan, inon xitlanonotzacan inixpa nochten. Huan in tlen san namehhuan nanquicactoque den notlahtol, inon nohuiyan xiquintlamimatiltican. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ahmo xiquinmoucaitacan in aquin quimictiya in tetlacayo huan ahhuel quimictiya in tetonal. Ocachi xicmoucaitacan in aquin cuali quipolos tetlacayo huan noyojqui tetonal ipan in mictlan. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Tel, yinanquimauticaten quen in totomen ahmo tequin tlen ipatiu. Huan niyan se de inohque huetzis tlalpa in tlahmo mocahuas Namohueyitahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","In tlahmo hasta namotzon de namehhuan tlapoutli nochin. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ahmo ximomoutican, tleca namehhuan ocachi miyac namopatiu quen miyac in totomen. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Nochten aquin motemactiyahque ica nehhua inixpa in tlacamen, neh noyojqui nimotemactis ica yehhuan teixpa Nohueyitahtzin aquin ilohuac neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Huan in aquin nechixtlatiyahque inixpa in tlacamen, neh noyojqui niquinixtlatis teixpa Nohueyitahtzin aquin ilohuac neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Ahmo xicneltocacan quen nehhuatl onihuala maniquinyolsehui in tlalticpac tlacamen. Ahmo onihuala niquinyolsehui; in tlahmo niquinixnamictis. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Onihuala ic niquixnamictis in tlacatl ica in itata, huan in ichpochtli quixnamiquis in inana, huan in sihuamontli quixnamiquis in imonantzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Huan ijcon yetos ic mococolilos cada seya ica inon chanimen. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’In aquin quitlasohtlas itata noso inana ocachi quen nehhuatl, ahmo tlen iquisca mochihuas nohuaxca. Niyan in tla quitlasohtlas itelpoch noso ichpoch ocachi quen nehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Huan in aquin ahmo quinequis quen quixicos ic tlapanos, masque ipan in cruz, yeh ahhuel mochihua notlamachticau. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","In aquin quinequi momaquixtis, san yehhuatl mopolos, huan in aquin quipolos inemilis nopampa, yehhuatl quiahsis in inemilis tlen ocachi cuali. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’In aquin mechselis namehhuan no nechseliya nehhua, huan in aquin ijcon nechseliya nehhua no teseliya in aquin onechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","In aquin quiseliya se tlayolchicauqui tleca huitz tepampa in Dios quiselis ijconon in itlatlan quen quimacasque in tlayolchicauqui. Huan in aquin quiselis se cuali tlacatl tleca cuali tlacatl, yehhua quiselis in tlatlantli quen quimacasque in cuali tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Huan san aquin quiamacas se de inin cocone san se vaso in itztic atl, tleca nechneltoca, ic nele ijcon quiselis in itlatlan. ");
INSERT INTO ncjNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ihcuac in Jesús otlan technonotzahque tehhuan in mahtlactli huan ome tetlamachticahuan, oquixohuac de ompa huan ohuilohuac tlanonotzalo ipan in oc sequin altepemen de inon tlalten. ");
INSERT INTO ncjNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ihcuac in Juan ocatca telpiloyan, oquicaquiltihque ica tlen omochiutinemiyaya in Jesús. Yehhua oquintitlan sequin itlamachticahuan mayacan teitacan in Jesús, ");
INSERT INTO ncjNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","huan otetlahtlanihque: ―Tel, ¿Tehhuatzin in Cristo, aquin hualuilohuasquiyani, noso ticchiyasque in oc seya? ");
INSERT INTO ncjNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","In Jesús omonanquilihque: ―Xiyacan huan xiquiluican in Juan in tlen nanquitzticaten huan nanquicacticaten. ");
INSERT INTO ncjNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Xicnonotzacan quen in ixpatzacten tlachiyahque, huan in xonecuilten nehnemihque, huan in aquin pahpalanticaten pahtihque ica inon incocolis, huan in nacastemen tlacaquihque, huan in mijcamen ihsahque, huan in prohues quinmatiltiyahque in itlahtoltzin in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Huan mapacto in aquin ahmo moxihxicohua ica nehhua. ");
INSERT INTO ncjNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ihcuac omocuepque inon itlatitlaniluan in Juan, in Jesús opehualoc quinnonotzalo in tlacamen ica in Juan: ―Nele ahmo onanyahque nanquitahque ipan in acahualtlahtli se tlacatl aquin san motlahtolpatla. ");
INSERT INTO ncjNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Huan in tlahmo, tel, ¿tlen onanyahque nanquitahque? ¿Quen se tlacatl cuahcuali itlaquen? ¿Tlahmo nanquimatihque in aquin ijcon tlaquentihtoc ompa yesque ichan in hueyixtoque? ");
INSERT INTO ncjNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","In tlahmo ijcon, tel, ¿tleca onanchicoquisque? Tel, ¿omechmatilti ica se tlayolchicauqui? Inon melahuac, huan inon Juan ocachi achto de nochin tlayolchicaucamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Inon Juan yehhuatl in aquin ica mihtohua in Dios ipan in Itlahcuiloltzin: Nehhua nictitlani in notlanonotzcau matlicana ica tehhua, ic mamitzchihuacan cuenta ic mitzselisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ic nele namechiluiya, hasta axan ahmo oncan oc se tlacatl ocachi hueyi iquisca quen in Juan Tlacuatequiyani. Masque ijcon ca, in aquin ocachi ahmo tlen iquisca huan temajco in Dios, yehhuatl ocachi quihuelitaque quen Juan. ");
INSERT INTO ncjNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Ic opeu tlanonotza in Juan Tlacuatequiyani hasta axan, in miyacten quinequihque mocalactisque ipan inon tetlatequiutilistzin Dios hasta ixtomamiquihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tleca nochin tlayolchicaucamen huan in Moisés noyojqui oquihcuilohque ica in tetlatequiutilistzin in Dios hasta ic ohuala in Juan Tlacuatequiyani. ");
INSERT INTO ncjNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Huan tla nanquineltocasque, ijcon nanquinehnehuilisque quen inon Juan, yehhuatl in tlayolchicauqui iquisca quen in tlayolchicauqui Elías. Huan ic inin yeh in Juan in aquin oquihtohque oquipix tlen hualas. ");
INSERT INTO ncjNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","In aquin quinequihque quicaquisque, maquichihuacan cuenta. ");
INSERT INTO ncjNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Axan namechiluiya ica tlen niquinixnamiquis in tlacamen de inin tonali. Ixnesihque quen in cocone san mahuiltiyahque huan quinnotzahque in oc sequin: ");
INSERT INTO ncjNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Tamechtlatlapitziliyahque ica in flauta quen ipan in mosihuautilistli huan ahmo onanmihtohtihque. Huan otitlocoxtoyahque quen ica in mijqui huan namehhuan nanyolchicahuahque.” ");
INSERT INTO ncjNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ijcon niquihtohua tleca in Juan omosautoya huan niyan ahmo otlayic, huan nanquihtohuahque quipiya in ahmo cuali yehyecatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Niman onihuala, nehhuatl aquin Nitetiachicau ica nochin tlacatl, nitlacua huan nitlayi, huan namehhuan nanquihtohuahque san nimotema huan nihuintihtinemi, huan niintenonotzcau in tlahtlacolyohque huan in renderos. Huan in tlamatilistli den Dios quinextiliyahque in aquin nele tlamatihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Oncan in Jesús opehualoc moixtohuetzohuahque sequin altepemen canin omochiu miyac tlachiuten, tleca inon tlacamen ahmo omoyolcueptoyahque. Oquiniluihque: ");
INSERT INTO ncjNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Prohues namehhuan den altepetl Corazín! ¡Prohues namehhuan den altepetl Betsaida! Namoixpa yonicchiu miyac tlachiuten huan ahmo nanmoyolcuepahque. Tla yehhuan den altepemen Tiro huan Sidón quitanihque inon tlachiuten, ihcuac inon moyolcuepanihque ica pinaucayotl, huan quincuatlaxilinihque in tleconextli ica intlocol. ");
INSERT INTO ncjNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Huan namechiluiya quen ipan inon tonali den tlixcomacalistli mechtlapanoltisque ocachi quen in tlacamen den inon altepemen. ");
INSERT INTO ncjNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Huan namehhuan den altepetl Capernaum, ¿nanquinehnehuiliyahque nanyasque neluicac? Huan nele mechixtlasasque in mictlan. Tleca in tla yehhuan den altepetl Sodoma quitanihque in tlachiuten tlen onicchiu namoixpa, inon altepetl yesquiyani hasta axan. ");
INSERT INTO ncjNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Huan namechiluiya ipan in tonali den tlixcomacalistli namehhuan mechtlapanoltisque ocachi chicahuac quen in tlacamen den tlali Sodoma. ");
INSERT INTO ncjNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Huan ic omonehnehuilihtehuac, in Jesús omihto: ―Nohueyitahtzin, huan Itecohtzin in neluicactli huan in tlalticpactli, nitemahuestiliya tleca motlatihtoc inin tlamatilistli ica in ixtlamatcamen, huan monextilihtoque ica in aquin ahmo machtihtoque. ");
INSERT INTO ncjNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Queme, Nohueyitahtzin, tleca ijconon tequin monectoc. ");
INSERT INTO ncjNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Notahtzin nechmactilohtoc nochin tlen oncan. Niyan aquin nechixmati nehhuatl aquin niteconetzin, in tlahmo san Yehhuatzin in Notahtzin. Huan niyan aquin teixmati yec in Notahtzin in tlahmo nehhuatl, huan niquinixmatiltis yehhuan aquin nicnequis. ");
INSERT INTO ncjNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Xihualacan ica nehhuatl, namochten aquin nansiautoque ic onanquitlacamatiyayahque ica itlanahuatil san tlen tlacatl, tleca inon quen se tequitl chicahuac noso se tlamamali molui yetec. Huan nehhuatl namechsehuis huan ayacmo ijcon mechmohsihuisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Xicselican notlanehnehuilis tlen namechtlaliliya huan ximotemactican ica nehhuatl, tleca ahmo nimohsiuqui huan niyolyemanqui; huan nancahsisque nesehuilistli ipan namoyolo. ");
INSERT INTO ncjNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tleca ahmo tequiyo notlanehnehuilis ic nanmomachtisque, huan ahmo yetec in notlanahuatil tlen ic namechtequiutiya. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ipan oc se tonali in Jesús opanolotaya ipan inon tlamilolten, huan yeh in tonali den nesehuilistli. Huan tehhuan titetlamachticahuan otiapismijque huan otictejque in trigo huan oticuahque. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ihcuac otechitaque in fariseos, yehhuan oteiluihque in Jesús: ―Mamota in motlamachticahuan, tlen quichiuticaten tlen ahmo techcahuilihtoque ticchihuasque tehhuan judeahtecos ipan in tonali den nesehuilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Huan Yehhuatzin oquiniluiloc: ―Tel, ¿tlahmo nanquipoutoque in Itlahcuilolamau tlen quihtos in tlen oquichiu in David queman oapismijque yehhua inuan in itenonotzcahuan? ");
INSERT INTO ncjNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ocalac ipan inon tiopantli den Dios huan oquicua inon pantzin mahuestic, tlen ahmo quicahuilihtoyahque quicuani, niyan in itenonotzcahuan, tlahmo san in tiopixcamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Noso in tlahmo nanquipoutoque ipan itlanahuatil in Moisés quen in tiopixcamen ipan in tiopantli ahmo mosehuiyahque ipan in tonali den nesehuilistli? Huan masque ijcon, inon ahmo tlahtlacoli. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Huan axan namechiluiya quen nican oncan seya ocachi hueyi iquisca quen in tiopantli. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Namehhuan ahmo nanquinehnehuiliyahque in tlen quihtosnequi in tlen omihto in Dios ipan Itlahcuiloltzin: “In tla nele nannechmahuestilisque, huan ahmo san ica in tlaolichtilistli den tiopan, tel, xiquintlapohpoluican in oc sequinten.” In tla nanquinehnehuilinihque inon, ahmo nanquintlahtlacoltinihque inin tlacamen aquin ahmo quichiutoque in ahmo cuali. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Huan nehhuatl aquin Nitetiachicau ica nochin tlacatl noyojqui nicpiya tequihuahyotl ica in tonali den nesehuilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Oncan in Jesús ohuilohuac de ompa huan ocalacohuac ipan in tiopantli. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Huan ompa ocatca se tlacatl aquin oquipiyaya iman huajqui. Huan inon fariseos oquinequiyayahque teahxilisque itlahtlen tlahtoli ic teteluisque in Jesús, huan otetlahtlanihque: ―Tel, ¿tecahuilihtoque mopahtis se cocoxqui ipan in tonali den nesehuilistli? ");
INSERT INTO ncjNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","In Jesús oquinnanquililoc: ―Cana se de namehhuan quipiya san se calnelo, huan tla huetzis ipan se tlacoyoctli ipan in tonali den nesehuilistli, ¿tlahmo yas quiquixtis? ");
INSERT INTO ncjNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tel, ¿ahmo ocachi miyac ipatiu se tlacatl quen in calnelo? Ijcon tel, cuali ticchihuasque in tlen cuali ipan in tonali den nesehuilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Oncan omoluic inon tlacatl: ―¡Ximasohua! Huan ihcuac omasou, niman opahtic huan omocau quen oc se iman. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Oncan ohualquisque inon fariseos, huan opeuque quitemohuahque tlahtoli quen temictisque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ihcuac Jesús omomat inon tlahtoli, oquixohuac de ompa. Huan miyac tlacamen otecuitlapanuihque. Huan in Jesús omopahtiyahque in cocoxcamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Huan omotequiutiyayahque quen ahmo maquihtocan tla Yehhuatzin aquin oquimpahtiloc. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ijcon omihto ic matzonquisa in tlen teca Yehhuatzin yihuehcau omihto in Dios. Huan oquihcuilui in tlayolchicauqui Isaías nochin inon tlahtoli tlen omihto Yehhuatzin: ");
INSERT INTO ncjNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Inin in notlaquehual aquin onictlapehpeni. Nictlasohtla huan ica yehhuatl nipactoc. Nicmacas in notiotonal huan quinmatiltis nochin tlacamen ipan in tlalticpactli ica notlamaquixtilis. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ahmo tlahtolchiuqui, niyan tzahtzitinemis, huan niyan aquin quicaquis in itlahtol ipan ohtli. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Quimpalehuis in aquin nochin innemilis molui mohsiuqui, huan quinyolchicahuas in aquin innemilis quen in tletl tlen yau sehui, hasta quitlanis ica nochin ahmo cuali. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Huan nochin tlalticpac tlacamen ica yehhuatl quineltocasque. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Oncan otehuiquilihque in Jesús se tlacatl ixpatzac huan mudo tleca oquipiya se ahmo cuali yehyecatl. In Jesús omopahti, huan inon tlacatl cuali otlachix huan otlahto. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nochin tlacatl quen tel oquimatque huan omoluihque: ―Tel, ¿inin cana yes in Ichichicaixuiutzin in David? ");
INSERT INTO ncjNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Huan ihcuac oquicajque inon tlahtoli, in fariseos oquihtohque: ―Inin tlacatl quinixtohuetzohua in ahmo cuali yehyecamen san ica in ichicahualis in Beelzebú, in hueyixtoc de yehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","In Jesús omomat in tlen oquinehnehuilihque huan oquiniluiloc: ―Tla xexeliutosque in tequihuahmen, huan motehuiyahque ic motlahtolchihuiyahque, ijconon ihsiu tlamis inchicahualis. Huan tla cana ipan se altepetl noso ipan se cali xexeliutos, ahhuel huehcahuisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ijcon tel, tla nele in tlen nanquihtohuahque, mach in ahmo cuali tlacatl quixtohuetzos in ahmo cuali yehyeca, quihtosnequi yehhuatl ichanihcahuan no xexeliutoque huan ic inon ahhuel huehcahuis in ichicahualis. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Namehhuan nanquihtohuahque nehhuatl niquinixtohuetzohua in ahmo cuali yehyecamen ica in ichicahualis in Beelzebú, yeh in ahmo cuali tlacatl. Yehhuan aquin mechcuitlapanuisque noyojqui quinixtohuetzohuahque in ahmo cuali yehyecamen. Huan in tla melahuac in tlen nanquihtohuahque ica nehhuatl, quihtosnequi yehhuan noyojqui quinixtohuetzohuahque ica ichicahualis in ahmo cuali tlacatl. Ijquin ihsiu nesi quen nanmotlapolochtiyahque. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tleca melahuac nehhuatl niquinixtohuetzohua in ahmo cuali yehyecamen ica in ichicahualis Itiotonaltzin Dios, huan inin quihtosnequi quen in tetlatequiutilistzin Dios yomechahsico. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Niyan aquin cuali calaquis ihtech in cali den se tlacatl chicahuac huan quicuilis in tlen quipiyas, in tlahmo achto quicouilpis. San ijcon ahhuel niquinquixtiliya in tlacamen aquin caten imajco in ahmo cuali tlacatl in tlahmo achto nicahualtis ichicahualis. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’In aquin ahmo nechpalehuiya, yehhuatl nechixnamiqui, huan in aquin ahmo nohuan quinsentlalis in tlacamen, yehhua quinxiniya. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Ic inon namechiluiya, cuali quintlapohpoluilos nochin intlahtlacol den tlacamen huan ica nochin tlen ahmo cuali tlen quihtosque, huan se tlahtoli, ahmo. In tla quicamanaluisque ica in Itiotonaltzin Dios, ic inon ahhuel quintlapohpoluilos. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Huan cuali quitlapohpoluis in aquin tlen nechixnamiquis nehhuatl aquin Nitetiachicau ica nochin tlacatl. Huan in aquin camanaltis ica in Itiotonaltzin in Dios, yehhuatl ahyic quitlapohpoluilos. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’In tla in cohuitl cuali, quitemaca in itlaquilyo cuali. Huan tla inon cohuitl ahmo cuali, quitemaca san in itlaquilyo ahmo cuali. Quen in cohuitl moixmati ica in itlaquilyo, ijcon noyojqui ica namehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Namehhuan tlacahcayaucamen ahhuel nanquihtohuahque in tlen cuali, tleca ahmo nancualten. ¡Namoquisca quen in cohuamen huan nanquihtohuahque in tlen nanquinehnehuiliyahque ipan namoyolo! ");
INSERT INTO ncjNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","In cuali tlacatl quihtohua nochin tlen cuali, tleca nochin cuali ca ipan iyolo. Huan in tlacatl ahmo cuali yehhua quihtohua in tlen ahmo cuali tleca in ahmo cuali quipiya ipan iyolo. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Huan namechiluiya quen ipan in tonali den tlixcomacalistli nochin tlacatl quitlapanoltilos ica nochin ahmo cuali tlahtoli tlen oquihto. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tleca ica inon namotlahtol mechtemactisque huan mechixcomacasque in tla namotlahtlacol noso ahmo. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Oncan oteiluihque in Jesús sequin in fariseos huan in tlamachtiyanimen den itlanahuatil in Moisés: ―Tlamachtiyani, matechnextili se tlachiutli mahuestic. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","In Jesús oquinnanquililoc: ―In tlacamen de inin tonali ahmo yolcualten niyan tlaneltocahque, yehhuan quitlahtlanihque se tlachiutli mahuestic. Huan ayacmo niquinnextilis oc se tlachiutli. San niquinilnamiqui ica tlen opanoc ica in tlayolchicauqui Jonás. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ijcon tel, quen Jonás ocatca iihtectla in hueyi michi yiyi tonali huan yiyi yohuali, ijcon noyojqui nehhuatl aquin Nitetiachicau ica nochin tlacatl niyetos nitlaltoctos yiyi tonali huan yiyi yohuali. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","In tlacamen den Nínive omoyolcuepque ihcuac in Jonás oquinnonotz ica itlahtoltzin Dios. Huan ipan in tonali den tlixcomacalistli yehhuan quinteluisque in tlacamen de inin tonali, tleca ahmo omoyolcuepque, masque oniquinnonotz huan nehhua ocachi hueyi noquisca quen in Jonás. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Huan in sihuahhueyixtoc den Sur ohuala ocachi huehca den tlalticpac maquicaqui in itlamachilis in hueyixtoc Salomón. Huan ipan in tonali den tlixcomacalistli yeh noyojqui quinteluis in tlacamen de inin tonali, tleca ahmo onechcaquihque, masque ocachi cuali notlamachilis quen inon den Salomón. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Ihcuac se ahmo cuali yehyecatl quisas ipan in tlacatl, nemis canin ahmo oncan tlen. Quitemos canin mosehuis, huan in tlahmo cahsis, quinehnehuilis: ");
INSERT INTO ncjNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Nimocuepas oc se viaje nochan canin onihualquis.” Huan ihcuac mocuepas, cahsitiu inon tlacatl quen se cali iyoca, tlachpantli, huan tlayectlalili. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Oncan yas quinanas oc chicome ahmo cuali yehyecamen ocachi ahmo cuali quen yehhuatl, huan nochten ompa mochantisque ipan inon tlacatl. Oncan inon tlacatl mochihuas ocachi ahmo cuali quen in achto. Noyojqui ijcon mechpanos ica namehhuan ahmo cualten tlacamen tleca ahmo onannechselihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","In Jesús oc oquinnonotzaloticatca in tlacamen ihcuac oahsito in inanatzin huan tecnihuan. Omocauque caltenco huan oquinequiyayahque tehuan monohnotzasque. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Huan se tlacatl otenahuati in Jesús: ―In monana huan mocnihuan nican caten quiahuac huan quinequihque mitznohnotzasque. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Huan Yehhuatzin omoluic in aquin otenahuati: ―Tel, ¿aquin in nonana, huan aquihque in nocnihuan? ");
INSERT INTO ncjNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Oncan otechmahpiluihque tehhuan titetlamachticahuan huan omihto: ―Inihque quen nonana huan nocnihuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tleca san aquin quichihuas in itlanequilistzin in Notatzin aquin ilohuac neluicac, timoyolohmatihque quen tla ticnimen huan ijcon yes quen nocniu noso nohueltiu noso nonana. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Inon tonali in Jesús oquixohuac den cali huan ohuilohuac itentla in atl huan ompa omotlalilo. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Huan quen omosentlalihque miyac tlacamen canin oilohuaya, in Jesús ocalacohuac ipan in barco huan ompa omotlaliloc. Huan nochin tlacamen omocauque atlatentli. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Oncan oquinnextililoc ica miyac tlalnamictilisten. Oquiniluiloc: ―Se tlacatl oquis quichayahua in xinachtli. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Huan ic oquichayautaya, sequin xinachtli ohuetz ipan in ohtli, huan ohualahque in totomen, huan oquicuahque. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Huan oc sequin ohuetz ipan in tetlahtli canin ahmo tilahuac in tlali. Huan inon xinachtli oixuac ihsiu tleca in tlali ahmo huehcatla. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Huan queman otlatotonix, opilin, huan quen ahmo hueyac in ineluayo, ohuac. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Huan oc sequin xinachtli ohuetz ipan in huetztlahtli, huan inon huetztlahtli oyol ocachi huan otlan quixolonaltiya. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Huan oc sequin xinachtli ohuetz ipan in cuali tlali huan oquitemacac cuali tlamiloli. Sequin de inon tlatoctli oquitemacac se ciento den itlaquilyo ica se xinachtli, huan oc sequin yehpohuali itlaquilyo, huan oc sequin sempohuali huan mahtlactli. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Huan xicnehnehuilican ica tlen quihtosnequi in tlen nanquicactoque. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Oncan tehhuan titetlamachticahuan otimopachohque tenahuac in Jesús huan otitetlahtlanihque: ―Tel, ¿tleca quinnonotzalo in tlacamen ica in tlalnamictilisten? ");
INSERT INTO ncjNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yehhuatzin otechnanquililoc: ―In Dios mechmatiltilo ic namehhuan in tlen tlatiutoc den tetlanahuatil in tetlatequiutilistzin Dios, huan yehhuan, ahmo. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tel, in aquin quineltocas tlen quicaquis, ocachi quinextilisque, huan ocachi quinehnehuilis. Huan in aquin ahmo quineltocas, in Dios moilcahualtis inon chihton tlen oquimatiyaya. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ic inon niquinnonotza ica in tlalnamictilisten, tleca yehhuan quitahque tlen nicchihua huan quicaquihque in tlen niquiniluiya huan ahmo quinequihque maquimatican tla quinehnehuiliyahque. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ica yehhuan tzonquisa ica in tlen oquihcuilui in tlayolchicauqui Isaías in tlen omihto in Dios: Namehhuan melahuac nanquicaquisque huan ahhuel nanquinehnehuilisque. Melahuac nanquitasque huan ahmo nanquichihuasque cuenta. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tleca inin tlacamen yoltepitzautoque huan san quicaquihque, huan quitzacuahque in ixtelolo. Ijcon ahmo maquinehnehuilican, niyan ahmo mamoyolcuepacan ica nehhuatl, ¿huan ijcon quen niquinmaquixtis? ");
INSERT INTO ncjNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Huan xipactocan namehhuan, tleca nanquinehnehuiliyahque in tlen nanquitahque huan in tlen nanquicaquihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ic nele namechiluiya, miyacten tetlayolchicaucahuan huan tlacamen cualten oquinequiyayahque quitasque huan quicaquisque in tlen axan namehhuan nanquitahque huan nanquicaquihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Xicchihuacan cuenta yec in tlen quihtosnequi in tlalnamictilistli ica in tlamilohuani. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","In aquin quicaquihque in itlahtoltzin ica in tetlatequiutilistzin Dios huan ahmo quinehnehuiliyahque, inohque quen in xinachtli tlen ohuetz ipan in ohtli. Huitz in ahmo cuali tlacatl huan quintlailcahuatiya in itlahtoltzin tlen quicaquihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Huan in xinachtli tlen ohuetz ipan in tetlahtli quixnextiya in tlacamen aquin quicaquihque in itlahtoltzin huan quiseliyahque ica paquilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Huan quen ahmo neluayotihtoc huehcatla, ahmo huehcahui. Huan ihcuac quinmohsihuiyahque ipampa in itlahtoltzin, ic inon moxihxicohuahque huan ahmo nele quineltocahque. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","In xinachtli tlen ohuetz ipan in huetztlahtli quixnextiya quen in aquin quicaquihque in itlahtoltzin huan ocachi quichihuahque cuenta ica in tlalticpac nemilistli, huan ica in ricohyotl mocahcayahuahque. Huan ic inon ahmo quitlacamatihque inon itlahtoltzin Dios, niyan ahmo moyolcuepahque. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Huan in xinachtli tlen ohuetz ipan in cuali tlali quixnextiya quen in aquin quicaquihque in itlahtoltzin Dios huan quinehnehuiliyahque, huan nele quineltocahque. Huan nesi quen yancuic intlanehnehuilis huan cuali innemilis quen inon tlamiloli tlen quitemaca cuali itlaquilyo. Sequin quitemaca se ciento ica se xinachtli, huan oc sequin yehpohuali, huan oc sequin sempohuali huan mahtlactli. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","In Jesús omononotzque ica oc se tlalnamictilistli: ―In tetlatequiutilistzin Dios quen in se tlacatl oquitocac in cuali xinachtli ipan itlal. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Huan ihcuac nochten ocochtoyahque, oquinahsito in aquin nexicoltic ica in iteco huan oquitocac in ahmo cuali xihuitl inepanco in trigohmili huan oya. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ihcuac oyol inon trigo huan oxochiyohuac, ompa ohualnes noyojqui in ahmo cuali xihuitl. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Oncan inon tlaquehualten oquiluihque in iteco inon tlamiloli: “Toteco, in xinachtli tlen otictocaque nochin cuali. Tel, ¿de canin ohuala inin ahmo cuali xihuitl?” ");
INSERT INTO ncjNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","In iteco oquiniluic: “Se nexicolyo oquichiu inin.” Oncan in tlaquehualten oquiluihque: “Tel, ¿monequi matiyacan ticuihuitlacan in ahmo cuali xihuitl?” ");
INSERT INTO ncjNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Huan yehhuatl oquiniluic: “Ahmo, tla ic nanquihuihuitlasque in ahmo cuali xihuitl, cana molehuis noyojqui in trigo. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ocachi cuali mayoli san secnin hasta mochihuas. Oncan niquintitlanis sequin tequitcamen maquisentlalican achto in ahmo cuali xihuitl, huan maquimanojohchihchihuacan ic tlatlas. Huan satepa nechehuilisque in trigo.” ");
INSERT INTO ncjNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","In Jesús noyojqui oquinnonotzaloc ica oc se tlalnamictilistli: ―In tetlatequiutilistzin Dios quen in iachyo in mostaza, tlen quitoca in tlacatl ipan itlal. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ic nele yehhuatl in ocachi quitzinin de nochin iachyo huan ihcuac yoli, yehhuatl ocachi hueyi de nochin tlatoctli huan mochihua quen se cohuitl hueyi huan in totomen cuali ipan mochantiyahque. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Noyojqui oquinnonotzaloc ica inin oc se tlalnamictilistli: ―In tetlatequiutilistzin Dios quen in sihuatl aquin quitlalis in tlen ic semahuis in pantzin ihtech in yiyi medida den harina, ic semahuis nochin inon textli. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","In Jesús oquinnonotzaloc in tlacamen ica in tlalnamictilisten, huan ahmo tlen oquiniluilohuaya ocachi san ic inon tlalnamictilisten. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Inin omochiu ic matzonquisa quen in tlayolchicauqui oquihcuilo in tlen omihto in Dios: Nitlanonotzas ica inin tlalnamictilisten ica nochin tlen tlatiutoc hasta queman Dios omochiu in tlalticpactli. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Oncan in Jesús omonahuatihque in tlacamen huan ocalacohuac ipan in cali. Huan ompa otiteahsitohque tehhuan titetlamachticahuan huan otiteiluihque: ―Matechiluilo tlen quihtosnequi in tlalnamictilistli ica in ahmo cuali xihuitl ipan inon tlamiloli. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Oncan in Jesús otechiluiloc: ―In aquin quitocas in cuali xinachtli yeh nehhuatl aquin Nitetiachicau ica nochin tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Huan in tlamiloli yeh in tlalticpactli. In cuali xinachtli quixnextiya quen in tlacamen den tetlatequiutilistzin Dios, huan in ahmo cuali xihuitl quixnextiya quen in tlacamen ahmo cualten. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Huan in nexicolyo aquin oquitocac in ahmo cuali xihuitl, yehhua in ahmo cuali tlacatl. In tlen tlasentlalili in tlamiloli quihtosnequi in itlamiloca den tlalticpactli, huan in aquin quisentlalisque inon tlamiloli, yehhuan in ángeles. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","In ahmo cuali xihuitl quisentlaliyahque huan quitohuetzohuahque ipan in tletl. Ijcon yes in tlamiloli ihcuac itlamiyan in tlalticpactli. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Huan nehhuatl aquin Nitetiachicau ica nochin tlacatl niquintitlanis in noángeles maquinualsentlalican nochin in tlen tetlahtlacolanaltiya huan in aquin quichihuahque in ahmo cuali. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Inohque quintlasasque ipan in tletl canin chocasque huan tlantzahtzisque ica in tlatlalistli. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Oncan yehhuan aquin poutoque ica in tetlatequiutilistzin Dios monextiyahque molui chipahuac quen petlanis in tonaltzintli. In aquin quinehnehuiliyahque inin tlalnamictilistli, xicchihuacan cuenta. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’In tetlatequiutilistzin Dios molui tlasohtli, quen in tomin tlatiutoc ipan in tlali. Se tlacatl quiahsis inon tomin huan oc sepa quitlatis ompa. Huan ica paquilistli yas huan quinemacas nochin tlen quipiya huan quicohuas inon tlali. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Noyojqui in aquin calaquis ipan in tetlatequiutilistzin Dios, yehhuatl in quen se tlasemanqui quitemohtinemi in pipiloltetl cuahcuali. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Huan ihcuac quiahsis seya in tlen miyac ipatiu, yas huan quinemacas nochin tlen quipiya huan quicohuas inon pipiloltetl. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’In tetlatequiutilistzin Dios noyojqui quen se matlatl tlen quitohuetzohuahque ipan in mar huan quisentlaliya nochin quesqui michten. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ihcuac temi inon matlatl, in michtemohuanimen quiquixtiyahque atlatentli huan ompa quintlapehpeniyahque in michten. Quiehuahque in tlen cuali huan quitohuetzohuahque in tlen ahmo cuali. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ijcon yes ic tlamis in tlalticpactli. Quisasque in ángeles huan quinxelosque in ahmo cualten huan in cualten. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Huan quintohuetzosque in ahmo cualten ipan in tletl canin chocasque huan tlantzahtzisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Oncan in Jesús otechtlahtlaniloc: ―Tel, ¿nanquinehnehuiliyahque nochin inin? Tehhuan otiquihtohque: ―Queme, Totecohtzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Oncan otechiluiloc: ―Ihcuac se tlamachtiyani yimomachtihtoc ica in tetlatequiutilistzin Dios, yas mochihuas quen tetata den cali. Ica in tlahtoli tlen quieutos, quimati quiquixtis in tlen quinamiquis, maye in yancuic noso maye in tlen yihuehcau. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ihcuac in Jesús otlan mononotzahque inon tlalnamictilisten, ohuilohuac de ompa. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Huan oahxihuato ipan tealtepeu huan ompa otlamachtiloc ipan in tiopantli. Huan in tlacamen quen tel oquimatque huan oquihtohque: ―Tel, ¿canin ocahsic inin tlanehnehuilistli, huan quen cuali quichihuas inin tlachiuten mahuestic? ");
INSERT INTO ncjNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Tlahmo yehhuatl in iconeu san in couxinqui, huan inana san yehhuatl in María? Huan in icnihuan yehhuan in Jacobo, huan José, huan Simón, huan Judas. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Huan in ihueltihuan noyojqui chantihque tohuan nican. Tel, ¿de canin quimati nochin inin? ");
INSERT INTO ncjNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ic inon ahmo oquinejque techihuasque cuenta huan in Jesús oquiniluiloc: ―Nochten quihuelitahque se tlayolchicauqui huan ahyic quihuelitasque in ichantlacahuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Huan ahmo omochiu miyac tlachiuten mahuestic ompa, tleca yehhuan ahmo oteneltocaque ica Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ipan inon tonalten in Herodes, yehhua in hueyixtoc den Galilea, huan oquinonotzque ica in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Huan oquiniluic in aquin inuan ocahcatca: ―Yehhuatl in Juan Tlacuatequiyani oihsac den mijcamen, huan ic inon quipiya in chicahualistli mahuestic. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","In Herodes ijcon oquihto tleca otlatequiuti maquihuicac in Juan tlalpili ipan in telpiloyan. Ijcon oquichiu ipampa in Herodías, yeh in aquin achto isihuau in Felipe, icniu in Herodes. Huan oquisihuacuili inon Herodes. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","In Juan oquiluihtoya in Herodes: ―Ahmo mitzcahuilihtoque ticpiyas quen mosihuau. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","In Herodes quimictisquiyani in Juan, huan omomouti ica in tlacamen. Tleca nochten oquinehnehuilihque in Juan noyojqui se tetlayolchicaucau in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Huan ihcuac in itonal isanto in Herodes, in ichpocau inon sihuatl Herodías oya mihtohtiya inixpa in itetlatlautiluan, huan tequin oquipacti in Herodes. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Huan in ichpocatl oquicaquilti quimacas quen itetlocolil in tlen quitlahtlanilis. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Huan quen oquitequiuti in inana, oquiluic in Herodes: ―Nicnequi matlatequiutilo maquimictican in Juan Tlacuatequiyani. Nicmatis tla nele oquimictihque, nechualiquilisque itzonteco ipan se plato. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Oncan otlocox in Herodes, huan quen yoquicaquiltihtoya inon ichpocatl huan noyojqui oquicajque itetlatlautiluan in hueyixtoc, oncan otlatequiuti maquimacacan. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Otlatequiuti in hueyixtoc maquiquechtzontequican in Juan ipan in telpiloyan. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Niman ocualiquilihque inon itzonteco Juan ipan se plato huan oquimacaque in ichpocatl. Huan yehhuatl oquimacti in inana. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Oncan oahsitohque in itlamachticahuan in Juan huan oquihuicaque in itlacayo huan oquitlaltocaque. Huan satepa otenahuatihque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ihcuac in Jesús omomat in tlen oquinehnehuili in Herodes ica Yehhuatzin, oquixohuac de ompa huan ohuilohuac ipan se barco. Huan oahxihuac ipan in acahualtlahtli. Huan in tlacamen niman oquimatque huan ohualquisque den altepemen huan ohualnehnenque teixnamiquitohque canin oahxihuato. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Huan ic oquixohuac in Jesús ipan in barco, omotac miyac tlacamen huan inca otlocoyaloc. Huan omopahtihque in cocoxcamen tlen otehualiquilihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Huan quen yotlapoyautaya, tehhuan titetlamachticahuan otitenahuatihque in Jesús: ―Yitiotlac huan ahmo aquin chanti nican. Xiquinnahuati in tlacamen mayacan ipan in altepemen huan maquicohuacan tlen quicuasque. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","In Jesús otechiluiloc: ―Ahmo mayacan. Xiquintlamacacan namehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tehhuan otiteiluihque: ―Ahmo ocachi tlen ticpiyahque san macuili pantzin huan ome michten. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","In Jesús otechiluiloc: ―Xinechualiquilican nican. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Oncan omonahuatihque in tlacamen mamotlalican ipan sacatl. Niman omoan in macuili pantzin huan in ome michten. Huan oahcotlachiyaloc huan omotlasohcamatiloc ica in Dios huan omoxeluihque tehhuan titetlamachticahuan matiquinxeluican ica nochin tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nochten otlacuahque huan opachiuque huan satepa otiquintemiltihque in mahtlactli huan ome canastas ihuan in cohcotonque tlen omocau. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","In aquin otlacuahque ocatcahque cana macuili mil tlacatl, huan ahmo pohuihque in sihuamen huan in cocone. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Niman in Jesús otechtequiutiloc tehhuan titetlamachticahuan matitlehcocan ipan in barco huan matiteyecanacan ic sentlapal, huan Yehhuatzin monahuatiyahque in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Huan queman omonahuatihque in tlacamen, in Jesús otlehcoloc ipan in tepetl ic moyolmachtilo tesel. Ic otlayohuac in Jesús ompa omocahualoc tesel. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Huan ic oyahtaya inon barco inepanco in atl, ipan ohualmixuitecticatca in atl ipan in barco, tleca in yehyecatl oquixnamicticatca. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Inon huehca sancuel, in Jesús omohualpacholoc inahuac, nehnemohuatihuitz iixco in atl. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Huan ihcuac tehhuan titetlamachticahuan otiteitaque nehnemohuatiu iixco in atl, otitzahtzihque ica moucayotl: ―Inon san se nemohmoutilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Huan Jesús otechnotzalo huan otechiluiloc: ―¡Ximoyolchichuacan huan ahmo ximomoutican! Nehhuatl niJesús. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Oncan in Pedro otenotz huan oteiluic: ―Notecohtzin, in tla Tehhuatzin, manechtequiutilo niyas iixco in atl hasta canin ilohuac. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Huan Jesús omoluic: ―Tel, xihualau. Oncan Pedro otemoc ipan in barco huan opeu nehnemi iixco in atl ic oteahsitaya in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Huan ic oquichiu cuenta ica in chicahualoca in yehyecatl, omomouti, huan quen yopeu moatoca, otzahtzic: ―¡Manechmaquixtilo, Notecohtzin! ");
INSERT INTO ncjNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Niman in Jesús omomaquitzqui huan omoluic: ―¡Tequin chihton motlaneltoquilis ticpiya! ¿Tleca ahmo otinechneltocac? ");
INSERT INTO ncjNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ihcuac yehhuan otlehcohque ipan in barco niman omosehui in yehyecatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Oncan tehhuan aquin oticatcahque ipan in barco otimotlancuaquetzque teixpa in Jesús huan otiteiluihque: ―Ic nele Tehhuatzin tiTeconetzin in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Oticcholuihque in atl huan otiahsitohque ipan in tlali Genesaret. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ihcuac in tlacamen de inon tlali oteixmatque in Jesús, oquinnahuatihque in tlacamen nohuiyan, huan oquinualicaque nochin cocoxcamen canin oilohuaya. ");
INSERT INTO ncjNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Otetlatlautihque mamocahuilican quimachilisque tetlaquen. Huan opahtihque nochten in aquin oquimachilihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Oncan omopachohque tenahuac in Jesús sequin fariseos huan sequin tlamachtiyanimen den itlanahuatil in Moisés. Ohualahque den altepetl Jerusalén huan otetlahtlanihque: ");
INSERT INTO ncjNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―Tel, ¿tleca in tetlamachticahuan ahmo quitlacamatihque in tlanahuatili den tochichicacoluan? Yehhuan ahmo omomahtequihque quen quihta in tlanahuatili den tochichicacoluan huan sajcon tlacuahque huan cana ijcon moyolihtlacosque. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Huan in Jesús oquintlahtlaniloc: ―Tel, ¿tleca noyojqui ahmo nanquitlacamatihque in itlanahuatiltzin Dios? San nanquichihuahque cuenta ica in tlen nanquiyolmatque. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tleca in Dios omihto: “Xicmahuestilican namotata huan namonana”, huan “In aquin quipactecas itata huan inana maquitlahtlacoltican maquimictican.” ");
INSERT INTO ncjNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Huan namehhuan nanquihtohuahque quen se tlacatl cuali quiluis itata huan inana: “Ahhuel nimitzpaleluis tleca nochin nitemactihtoc in Dios.” ");
INSERT INTO ncjNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Huan san aquin quihtos ijcon, ayacmo maquipalehui itata noso inana. Ijconon nanquichiutoque san tlaluis in itlanahuatiltzin Dios ic nanquichiutiyesque san inon tlen nanquiyolnehnehuiliyahque. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Namehhuan san ome namoxayac. Melahuac omihto Yehhuatzin Dios quen oquihcuilui in tlayolchicauqui Isaías: ");
INSERT INTO ncjNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Inin tlacamen nechmahuestiliyahque san ica incamac, huan ahmo moyolcuepasque ica nehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","San tlaluis nechmahuestiliyahque. Huan quinextiliyahque itlanehnehuilis tlacatl, huan quihtosque mach tetlanahuatil Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Oncan oquinnotzaloc in tlacamen huan oquiniluiloc: ―Xicaquican huan xicnehnehuilican. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","In tlen quicuas se tlacatl, huan ahmo omomahtequi quen tlatequiutiyahque in tlamachtiyanimen ica in ome inxayac, ahmo inon quiyolihtlacohua. Ocachi in tlahtoli ahmo cuali tlen quihtohua, yeh in ica quiyolihtlacohua. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Oncan tehhuan titetlamachticahuan otimopachohque tenahuac in Jesús huan otiteiluihque: ―Tel, ¿momati quen in fariseos ocualanque ic oquicajque in tlen omihto? ");
INSERT INTO ncjNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Huan Yehhuatzin otechnanquililoc: ―Nochin tlatoctli in tlen Notahtzin den neluicac ahmo momilohtoc, inon tlamoleutli yes, quihtosnequi inon fariseos quen tlatoctli in oc seya. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Xiquincahua yehhuan. San quen ixpatzacten tlayecancamen quen quinuicas oc sequin ixpatzacten. Huan in tla se ixpatzac quiyecana in oc se ixpatzac, nochten in inehuan motepehxihuisque ipan in tlacoyoctli. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Oncan in Pedro oteiluic in Jesús: ―Matechyequiluilo inin tlalnamictilistli, ica tlen quiyolihtlacohua. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","In Jesús omihto: ―Tel, ¿niyan namehhuan ahmo nanquinehnehuiliyahque? ");
INSERT INTO ncjNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tel, ¿ahmo nanquinehnehuiliyahque nochin tlen calaqui ipan tocamac ahsi ipan topox, huan satepa quisa ipan totlacayo? ");
INSERT INTO ncjNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Huan in tlahtoli ahmo cuali tlen quihtohua in icamac seya huitz den iyolo, huan inon quiyolihtlacohua. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tleca ipan iyolo quisa nochin in ahmo cuali tlanehnehuilisten ica in temictiyani huan in sihuaahuiltiyani. Huan ompa quisas in ixpoliucayotl huan in ichtejcayotl, huan in istlacatcayotl huan in tlapactecalistli. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yehhuatl inin tlanehnehuilisten tlen quihtlacohua in tlacatl. Huan ahmo yeh in ic tlacuas huan ahmo momahtequis. Inon ahmo quihtlacohua in tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","In Jesús oquixohuac de ompa huan ohuilohuac ipan in tlali inahuac in altepemen Tiro huan Sidón. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Huan se sihuatl canaanteco aquin ochantiyaya ipan inon tlali ohuala huan tetzahtzilihtiu in Jesús: ―¡Notecohtzin, Ichichicaixuiutzin in hueyixtoc David, matoca tlocoyalo! Nochpocau quipiya se ahmo cuali yehyecatl huan tequin quitlapanoltiya. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","In Jesús ahmo tlen oquinanquililoc. Oncan tehhuan titetlamachticahuan otitetlatlautihque: ―Mamonahuati, tleca tzahtzitihuitz tocuitlapa. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Oncan Jesús omihto: ―Dios onechualtitlanilo ic maniquimpalehui san nochantlacaicnihuan in judeahtecos. Yehhuan quen in calnelohten poliutoque. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Huan in sihuatl ic omopacho tenahuac in Jesús, omotlancuaquetz teixpa huan oteiluic: ―¡Notecohtzin, manechpalehuilo! ");
INSERT INTO ncjNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Huan Yehhuatzin oquinanquililoc: ―Ahmo cuali in tla niquinmacas in sentlapalchanimen in tlen inuaxca in judeahtecos. Inon yesquiyani quen in aquin quicuilis itlacual in conetl huan quimacas in chichi. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Masque ijcon oquinanquililoc, yehhua oquihto: ―Queme Notecohtzin; huan in chichimen itzintla in mesa quicuahque in tlahtlacoton den conemen huan ahmo tlen polihui. Niyan tlen polihui tla techpalehuilos, masque tisentlapalchanimen. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Oncan in Jesús omihto: ―¡Quemach, tequin hueyi motlaneltoquilis, sihuatl! Matzonquisa quen ticnequi. Huan niman inon rato opahtic in ichpocau. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","In Jesús oquixohuac de ompa huan opanoloc itentla in atl den Galilea. Huan niman otlehcoloc ipan se tepetl huan ompa omotlaliloc. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Miyac tlacamen oahsitohque canin oilohuaya huan oquinualicaque in xonecuilten, huan in ixpatzacten, huan in mudos, huan in manecuilten, huan oc sequin miyac cocoxcamen. Oquintlalihque teicxitla in Jesús huan oquimpahtiloc. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ijcon quen tel oquimatque in tlacamen ic otlahtohque in mudos huan in xonecuilten onehnenque, huan in ixpatzacten otlachixque. Huan otemahuestilihque in Dios aquin oquimpehpeniloc in judeahtecos mayecan tetlacahuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Oncan in Jesús otechnonotzaloc tehhuan titetlamachticahuan huan otechiluihque: ―Inca nitlocoya inin tlacamen tleca yiyi tonali nican caten nohuan huan ahmo quipiyahque tlen quicuasque. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Huan tehhuan otiteiluihque: ―Ahhuel ticahsisque in tlacuali nican ica in miyac tlacamen huan ahmo aquin chanti nis. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","In Jesús otechtlahtlaniloc: ―Tel, ¿quesqui pantzin nanquipiyahque? Tehhuan otiteiluihque: ―Ticpiyahque chicome pantzin, huan quesqui in michtoton. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Oncan omotequiutihque in tlacamen mamotlalican. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Omoan in chicome pantzin huan in michten, huan omotlasohcamatiloc ica in Dios. Huan niman omoxehxelo huan otechmacaque tehhuan titetlamachticahuan matiquinxeluican in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nochten otlacuahque huan opachiuque. Huan satepa, oten chicome canasta ihuan in cohcotonque tlen omocau. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Huan in aquin otlacuahque ocatcahque nahue mil tlacatl, ahmo inuan pohuihque in sihuamen niyan in cocone. ");
INSERT INTO ncjNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","In Jesús omonahuatihque in tlacamen huan otiyahque ipan in barco ipan in tlali Magdala. ");
INSERT INTO ncjNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","In fariseos huan in saduceos oyahque teitahque in Jesús. Huan ic teichtacaahsisque, otetlahtlanilihque mamochihua se tlachiutli mahuestic den neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Huan Yehhuatzin omonanquilihque: ―In ic tiotlac nanquihtohuaque: “Mostla yau mochihua cuali tonali, tleca in neluicactli chichiltic ca.” ");
INSERT INTO ncjNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Huan ic sancuel nanquihtosque: “Axan yau mochihua ahmo cuali tonali, tleca in neluicactli tlacocoxcatixtica huan mextemi.” Nanquinehnehuiliyahque quen yes in tonali huan ahmo nanquixnehnehuiliyahque tlen quihtosnequi in tlen panohtica ipan inin tonalten. ");
INSERT INTO ncjNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Inin tlacamen aquin ahmo yolcualten quitlahtlanihque oc se tlachiutli mahuestic. Huan ahmo ocachi quinnextilisque. San maquinehnehuilican ica tlen opanoc in Jonás. Quen oquis in Jonás iihtectla in michi, ijcon niquisas nehhuatl iihtectla in tlaltecochtli. Huan ijcon oquincahualoc. ");
INSERT INTO ncjNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ihcuac tehhuan titetlamachticahuan otipanoque ic sentlapal den atl, otiquilcauque ticuicasque in pantzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Oncan Jesús otechiluiloc: ―Ximomaluican ica in pahtli tlen ic semahuis in pantzin tlen quipiyahque in fariseos huan in saduceos. ");
INSERT INTO ncjNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Huan otipeuque timoluiyahque ic tehhuan: ―Ijcon omihto tleca ahmo oticualicaque in pantzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","In Jesús omomat tlen oticnehnehuilihque huan otechiluiloc: ―Tel, ¿tleca nanquihtohuahque ahmo nanquipiyahque in pantzin? Molui chihton namotlaneltoquilis. ");
INSERT INTO ncjNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tel, nesi quen ayamo nanquinehnehuiliyahque niyan nanquilnamiquihque ica in macuili pantzin tlen onicxehxelo ica in macuili mil tlacamen. Tel, ¿huan quesqui canasta onanquisentlalihque? ");
INSERT INTO ncjNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Tel, ¿niyan nanquilnamiquihque ica in chicome pantzin tlen onicxehxelo ica in nahue mil tlacamen, huan quesqui canasta onanquisentlalihque? ");
INSERT INTO ncjNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Tel, ¿tleca ahmo nanquinehnehuiliyahque quen nehhuatl ahmo onitlanonotzticatca ica in pantzin ihcuac oniquihto ximomaluican ica in tlen ic semahuis in pantzin tlen quipiyahque in fariseos huan in saduceos? ");
INSERT INTO ncjNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Oncan oticnehnehuilihque quen in Jesús ahmo otechiluiloc matimomaluican ica tlen ic semahuis in pantzin, tlahmo ica in intlanextilis in fariseos huan saduceos. ");
INSERT INTO ncjNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ihcuac in Jesús oahxihuac ipan in tlali Cesarea den Filipo, otechtlahtlaniloc tehhuan titetlamachticahuan: ―Tel, ¿tlen quihtohuahque in tlacamen ica nehhuatl aquin Nitetiachicau ica nochin tlacatl? ");
INSERT INTO ncjNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tehhuan otiquihtohque: ―Sequin quihtohuahque Tehhuatzin in Juan Tlacuatequiyani, huan oc sequin quihtohuahque Tehhuatzin in Elías, huan oc sequin quihtohuahque Tehhuatzin in Jeremías noso oc se tlayolchicauqui. ");
INSERT INTO ncjNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Oncan otechiluiloc: ―Huan namehhuan, tel, ¿tlen nanquihtohuahque ica nehhuatl? ");
INSERT INTO ncjNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Oncan oquihto in Simón Pedro: ―Tehhuatzin in Cristo, in Iconetzin in Dios tlamelajcan. ");
INSERT INTO ncjNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","In Jesús oquinanquililoc: ―Omitzuelitaloc tehhuatl Simón, ticoneu in Jonás, tleca niyan se tlacatl mitznextilihtoc inin, tlahmo san Yehhuatzin Notahtzin aquin ilohuac neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Huan noyojqui nimitztocahhuiya in Pedro, tlen quihtosnequi tetl, huan inon tlahtoli tlen hueloc otiquihto, yehhua quen tepetlatl. Huan inon ipehualoca ipan tlen nicchihchihuas notlayehualol. Huan ichicahualoca in miquilistli ahhuel quixitinis, tleca ahhuel quintzacuiliya in tlaneltocanimen ic ihsasque den mijcamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nimitzpanoltilis in tequihuahyotl maquinnonotza quen nemisque in aquin poutoque ica notiotlayehualoltzin. Tiquinnonotzas ica tlen ahhuel quichihuasque huan ica tlen cuali quichihuasque nican tlalticpac. Huan ijconon motlalihtos ica Yehhuatzin ompa neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Oncan in Jesús otechtequiutiloc ahmo aquin matiquiluican quen Yehhuatzin in Cristo. ");
INSERT INTO ncjNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ipan inon tonali in Jesús opehualoc technextililos quen Yehhuatzin mopiya tlen huilohuas Jerusalén. Huan in tetecten huan in tlayecancamen den tiopixcamen huan in tlamachtiyanimen den itlanahuatil Moisés quipiya tlen tetlapanoltisque tequin. Otechiluiloc quen yehhuan temictisque huan ipan yiyi tonali ihxohuas. ");
INSERT INTO ncjNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Oncan in Pedro omohuicac oc secnin huan oteixahhuac: ―¡Notecohtzin, ocachi cuali ahmo ijcon tlahtolos! ¡Ahyic ijcon matepano! ");
INSERT INTO ncjNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Huan Jesús omocuepaloc huan omoluic in Pedro: ―¡Xitzinquisa de nehhuatl tleca titlahtohua quen Satanás! Yeh in ahmo cuali tlacatl, aquin nechtlapolochtisnequi ica in tlen nicpiya tlen nicchihuas. ");
INSERT INTO ncjNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Oncan in Jesús otechiluihque tehhuan titetlamachticahuan: ―Aquin quinequi mochihua notlamachticau ayacuel quichihuas quen yeh quinequis. Huan quipiya tlen quixicos ic tlapanos, masque miquis quen nehhua nimiquis, huan ijcon mochihua notlamachticau. ");
INSERT INTO ncjNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Mopolos in aquin ahmo quinequi miquis nopampa, huan maquisas in aquin motemacas ica inemilis nopampa. ");
INSERT INTO ncjNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Huelis se tlacatl cuali quitlanis nochin tlen quinequis nican tlalticpac. Huan tla quipolos inemilis nochipa ic quitlanis nochin inon, ahmo ipahtiu. Tleca ocachi patiyo inemilis nochipa quen nochin tlen oncan. ");
INSERT INTO ncjNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tleca nehhuatl aquin Nitetiachicau ica nochin tlacatl nihualas ica nochin chicahualistli den Notahtzin ihuan teángeles. Huan ijcon nictlaxtlahuas cada seya ica tlen quichiutoc. ");
INSERT INTO ncjNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ic nele namechiluiya, caten sequin nican ahmo miquisque hasta ic nechitasque nehhuatl aquin Nitetiachicau ica nochin tlacatl nihualas quen hueyixtoc. ");
INSERT INTO ncjNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Satepa den chicuasin tonali in Jesús omohuicac in Pedro huan in Jacobo huan in Juan, icniu in Jacobo, huan san yehhuan inuan oilohuac ipan se tepetl molui huehcapa. ");
INSERT INTO ncjNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Huan ompa omoixpatlaloc inixpa yehhuan. In texayac opetlan quen in tonaltzintli huan in tetlaquen omocuep chipahuac quen in tlanextli. ");
INSERT INTO ncjNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Huan niman yehhuan oquitaque in Moisés huan Elías omonohnotzalohticatca tehuan in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Oncan Pedro oteiluic in Jesús: ―Notecohtzin, tequin cuali quen nican ticaten. Tla monequis, ticchihchihuasque yiyi xahcali; seya para Tehhuatzin, huan seya para in Moisés, huan seya para in Elías. ");
INSERT INTO ncjNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ic otlahtohticatca in Pedro, oquinualtlapacho in mextli chipahuac huan ipan inon mextli oquicajque se tlahtoli tlen oquihto: ―Inin in noconeu tlasohtli ica aquin nipactoc. Xicaquican yehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ic oquicajque inin, in tetlamachticahuan omotlaluitejque ica moucayotl. ");
INSERT INTO ncjNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Oncan Jesús omopacholoc innahuac huan oquinmachililoc huan oquinnotzaloc: ―Ximoquetzacan; ahmo ximomoutican. ");
INSERT INTO ncjNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Huan ihcuac otlachixque, ayacmo aquin oquitaque, tlahmo san tesel in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Huan ihcuac otemoloc ipan in tepetl in Jesús oquinnahuatiloc inon yiyinten: ―Ahmo aquin xicnonotzacan in tlen omechmonextili hasta nehhuatl aquin Nitetiachicau ica nochin tlacatl maniihsa den mijcamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Oncan in tetlamachticahuan otetlahtlanihque in Jesús: ―Tel, ¿tleca quihtohuahque in tlamachtiyanimen den itlanahuatil in Moisés mach Elías quipiya tlen hualas achto ic hualuilohuas in Cristo? ");
INSERT INTO ncjNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","In Jesús oquinnanquililoc: ―Ic nele, in Elías quipiya tlen hualas achto huan quiyectlalis nochin. ");
INSERT INTO ncjNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Huan neh namechiluiya quen Elías yohuala, huan yehhuan ahmo oquiselihque, in tlahmo oquichiuque in ahmo cuali ica yehhua, in tlen oquinejque. Ijcon noyojqui ica nehhuatl aquin Nitetiachicau ica nochin tlacatl, nitlapanos inmajco yehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Oncan in tetlamachticahuan oquinehnehuilihque quen in Jesús oquinnonotzalohticatca ica in Juan Tlacuatequiyani. ");
INSERT INTO ncjNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Huan ihcuac oahxihuato canin ocatcahque in tlacamen, omopacho tenahuac in Jesús se tlacatl huan omotlancuaquetz teixpa Yehhuatzin huan oteiluic: ");
INSERT INTO ncjNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Notecohtzin, ma ica tlocoyalo notelpocau, quen mimiqui huan tlapanohua tequin. Miyacpa huetztoc ipan tletl noso ipan atl. ");
INSERT INTO ncjNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nican oniquinualiquili in tetlamachticahuan huan ahhuel quipahtiyahque. ");
INSERT INTO ncjNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","In Jesús oquinanquililoc: ―¡Tlen nanyoltepitztihque huan ahmo nantlacaquihque! Tel, ¿hasta quesqui tonali nimocahuas namohuan ic nanquineltocasque? Xicualicacan nican in telpocatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Oncan in Jesús omoixtohuetzalui in ahmo cuali yehyecatl inon telpocatl huan niman opahtic. ");
INSERT INTO ncjNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Satepa tehhuan titetlamachticahuan otimonohnotzque tehuan in Jesús oc secnin huan otitetlahtlanihque: ―Tel, ¿tleca ahhuel otiquixtohuetzohque inon ahmo cuali yehyecatl? ");
INSERT INTO ncjNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","In Jesús otechiluiloc: ―Namehhuan ahhueli tleca san chihton namotlaneltoquilis. Ic nele namechiluiya, in tla nanquipiyanihque namotlaneltoquilis san quitzinin quen se xinachtli den mostaza, cuali nanquihtosque inin tepetl: “Mamoihcuani de nican huan mayau oc se lado”; huan inon tepetl moihcuanis. Nochin tlen nanquinequihque, cuali mechchihuililos in Dios. Huan tla nele nanquineltocasque, ijcon nanquiahsisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Huan inon ahmo cuali yehyecatl molui chicahuac. Cuali quixtohuetzos san yehhua aquin nele quineltocas. Huan ica inon quipiya tlen moyolmachtiya huan mosahua. ");
INSERT INTO ncjNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ihcuac onemohuayaya tohuan san secnin ipan in tlali Galilea, in Jesús otechiluiloc quen Yehhuatzin aquin in Tetiachicau ica nochin tlacatl ilohuas tlatemactili inmajco in tlacamen ahmo cualten. ");
INSERT INTO ncjNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Huan temictisque huan ipan yiyi tonali ihxohuas. Huan molui otitlocoxque tehhuan titetlamachticahuan ihcuac ijquin otechmatiltiloc. ");
INSERT INTO ncjNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","In Jesús tehuan otiahsitoque ipan in altepetl Capernaum. Huan inohque aquin oquisentlaliyayahque in cuota para in tiopantli oyahque quitahque in Pedro huan oquitlahtlanihque: ―Tel, ¿ahmo quitemacas in tlamachtiyani noyojqui in tomin para in tiopantli? ");
INSERT INTO ncjNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","In Pedro oquinnanquilic: ―Queme. Oncan ic ocalac in Pedro ipan in cali, in Jesús omonotz achto huan oquitlahtlaniloc: ―Tel, ¿tlen ticnehnehuiliya, Pedro? ¿Aquin quitemacasque in tomin den cuota ica in tequihuahmen nican tlalticpac? ¿In ichanihcahuan noso in sentlapalchanimen? ");
INSERT INTO ncjNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","In Pedro otenanquilic: ―In sentlapalchanimen quitemacasque. In Jesús omoluic: ―Tel, in chanimen ahmo quitemacasque. ");
INSERT INTO ncjNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Huan masque tehhuan quen inon chanimen, ic ahmo tlen maye tlahtoli, xiyau ipan in atl, huan xictlasa in tepostli tlen ic moquitzquiya in michi. Huan tlen achto tiquitzquis, ipan in icamac ticahsis se tomin tlen ahsis ic tictemacasque. Xicuica huan xiquinmaca. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ic inon tehhuan titetlamachticahuan otimopachohque tenahuac in Jesús huan otitetlahtlanihque: ―Tel, ¿aquin de tehhuan ocachi hueyi iquisca ipan in tetlatequiutilistzin Dios? ");
INSERT INTO ncjNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Oncan in Jesús omonotz se telpocatl quitzinin huan omotlali inepanco yehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Huan omihto: ―Ic nele namechiluiya, tla namehhuan ahmo nanmoyolcuepahque huan nanmocahuasque quen cocone, ahmo nampohuisque ipan tetlatequiutilistzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ijcon tel, in aquin ocachi hueyi iquisca ipan in tetlatequiutilistzin Dios, yehhua ahmo mohueyiliya huan mochihua quen inin telpocatl quitzinin. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Huan in aquin quitlasohtla nopampa se telpocatl quitzinin quen inin, no nechtlasohtla nehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’San aquin quitlahtlacolanaltiya ica seya quen inin telpocatl quitzinin aquin nechneltocas, ocachi cuali tla quiquechilpisque ica se metlatetl huan quitohuetzosque canin ocachi ahuehcatla ipan in mar. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Molui ahmo cuali ica in tlalticpac tlacamen quen oncan itlahtlen ic tetlahtlacolanaltiya ica seya! Nochipa yes, huan ¡lastima den tlacatl aquin tetlahtlacolanaltiya! ");
INSERT INTO ncjNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Ic inon, tla in moman noso in mocxi mitztlahtlacolanaltiya, ocachi cuali tla tictzontequis, huan tictohuetzos huehca, huan ijcon ticalaquis timacotoc noso tixocotoc ipan in nemilistli nochipa, huan ahmo mamitztohuetzocan ipan in tletl canin ahyic sehui ica nochin momahuan huan mocxihuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Huan tla in moixtelolo mitztlahtlacolanaltiya, ocachi cuali tla tiquixtis huan tictohuetzos huehca. Huan ijcon ticalaquis san ica se moixtelolo ipan in nemilistli nochipa huan ahmo mamitztohuetzocan ica in ome moixtelolo ipan in tletl den mictlan. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Ahmo xiquixtohuetzocan niyan seya de inin cocone. Namechiluiya quen ipan neluicac in ángeles de yehhuan nochipa caten temajco Notatzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tleca nehhuatl aquin Nitetiachicau ica nochin tlacatl onihuala niquinmaquixtiya in aquin poliutoque. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’Tel, ¿tlen nanquinehnehuiliyahque? Tla se tlacatl quimpiya se ciento in calnelohten huan quipolos seya de inohque, tel, ¿tlen quichihuas? Quincautehuas in oc sequin naupohuali huan caxtoli huan nahue ipan in tepetl, huan yas quitemos in seya tlen oquipolo. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Huan tla quiahsis, ic nele paquis ocachi ica inon quen ica inon naupohuali huan caxtoli huan nahue tlen ahmo opoliuque. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","No ijconon Namohueyitatzin aquin ilohuac neluicac ahmo monequi mapolihui niyan se de inihque cocone. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Tla se motlasohicniu mitzchihuilis tlen ahmo cuali, ihuan ximonohnotza isel huan xicmatilti ica tlen omitzchihuili. Huan tla mitzcaquis, ijcon yonanmotlahtolcajque huan yoticyolcuep. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Huan tla ahmo mitzcaquis, xicuica seya noso ome tlacatl maquicaquican inon tlahtoli huan yehhuan cuali mitzchipahuilisque iixco in tequihua. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Huan tla ahmo quincaquis yehhuan, oncan xiquinnonotza ipan in itiotlayehualoltzin, huan tla ahmo quincaquis yehhuan ipan in itiotlayehualoltzin, oncan maye quen seya aquin ahmo tlaneltocani ica in Dios noso quen se aquin ahyic tlacaqui. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Ic nele namechiluiya, in aquin nanquihtosque ahmo motlapohpoluihtoc nican tlalticpac no ijcon ahmo quitlapohpoluihtoque ompa neluicac. Huan in aquin nanquihtosque motlapohpoluihtoc nican tlalticpac, no ijcon quitlapohpoluihtoque ompa neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Noyojqui namechiluiya, tla nanmosetilisque namonehuan ica tlen nanquitlahtlanisque ica in yolmachtilistli nican tlalticpac, Notahtzin aquin ilohuac neluicac mechmacalos. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tleca canin inehuan noso yiyi mosetilihtoque ic moyolmachtisque, ompa niyetos inepanco yehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Oncan Pedro otetlahtlani in Jesús: ―Notecohtzin, tel, ¿quesqui viaje nictlapohpoluis in notlacaicniu in aquin nechchihuilis ahmo cuali? Tel, ¿hasta chicome viaje nictlapohpoluis? ");
INSERT INTO ncjNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Huan oquinanquililoc: ―Ahmo nimitziluiya hasta chicome viaje, tlahmo hasta yeupohuali huan mahtlactli ica chicome. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Campa tlatequiutilos in Dios ijquin quinchihualos in tlacamen. Yehhuatzin quen se hueyixtoc aquin oquinec quinchihuililos cuenta ica in itlaquehualuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Hueloc opeu ijcon quichihua ihcuac ocualiquilihque seya aquin oquihuiquiliyaya molui miyac in tomin. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Quen inon tlaquehuali ahmo oquipiyaya ica tlen quitlaxtlahuilis, in iteco otlatequiuti maquinemacacan quen maya temajco san secnin ihuan isihuau huan ipiluan huan nochin tlen quipiya, ic mamotlaxtlahua in tlen quitehuiquiliya. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Oncan in tlaquehuali omotlancuaquetz iixpa in iteco huan oquitlatlautic: “Noteco, xinechtlapohpolui huan nimitztlaxtlahuilis nochin.” ");
INSERT INTO ncjNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Huan in iteco ica otlocox huan oquitlapohpolui ica tlen oquihuiquiliyaya. Huan ijcon oquicau. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Huan ic oquis inon tlaquehuali, oquinamic oc se tlaquehuali quen yehhua, aquin oquihuiquiliyaya molui chihton. Oquiquechquitzqui huan opeu quiquechpitziniya huan oquiluic: “¡Xinechtlaxtlahuili tlen nechuiquiliya!” ");
INSERT INTO ncjNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Oncan in itenonotzcau omotlancuaquetz iixpa huan oquitlatlauti: “Xinechtlapohpolui huan nimitztlaxtlahuilis nochin.” ");
INSERT INTO ncjNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Huan in oc seya ahmo oquinec, tlahmo oya inahuac in tequihua huan oquitlasque telpiloyan in itenonotzcau hasta quitlaxtlahuas tlen quihuiquiliya. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ihcuac in oc sequin tlaquehualten oquitaque tlen opanoc, molui otlocoxque huan oyahque quinonotzahque in inteco nochin tlen opanoc. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Oncan in iteco otlatequiuti maquinotzacan inon itaquehual, huan oquiluic: “¡Tlaquehuali ahmo cuali! Nehhuatl onimitztlapohpolui ica nochin tlen otinechuiquiliyaya, tleca otinechtlatlauti. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Teh noyojqui tictlapohpoluini in motenonotzcau ijcon quen nehhuatl onimitztlapohpolui.” ");
INSERT INTO ncjNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Huan in iteco molui ocualan, huan otlatequiuti maquitlapanoltican hasta quitlaxtlahuilis nochin tlen quihuiquiliya. ");
INSERT INTO ncjNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Huan in Jesús ic otlan omihto: ―Ijcon noyojqui Nohueyitahtzin aquin ilohuac neluicac mochihuas ica namehhuan cada seya tla ahmo quitlapohpoluiya ica iyolo in itlacaicniu. ");
INSERT INTO ncjNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Queman in Jesús otlan tlanonotzalo ica inon tlahtoli, oquixohuac den Galilea huan oahxihuato ipan in tlali Judea ic sentlapal in atentli Jordán. ");
INSERT INTO ncjNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Huan otecuitlapanuihque miyac tlacamen huan ompa omopahtihque in cocoxcamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Oncan sequin fariseos omopachohque tenahuac in Jesús teistlacaahsisque, huan otetlahtlanihque: ―Tel, ¿mihtohtoc cuali mosihuacahuas ica san tlen tlahtoli? ");
INSERT INTO ncjNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Huan oquinnanquililoc: ―¿Tlahmo nanquipoutoque ipan in Itlahcuiloltzin quen ic achto in Dios oquinmochihuili tlacatl huan sihuatl? ");
INSERT INTO ncjNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Huan omihto: “Ic inin in tlacatl quicahuas in itata huan inana para ihuan yes isihuau, huan inon inehuan mochihuatihue quen tla san se intlacayo.” ");
INSERT INTO ncjNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Huan ijcon ayacmo ome yesque, in tlahmo san seya. Huan ic inon ahmo mocahuiliyahque in Dios niyan aquin maquinxelo yehhuan aquin omosetili Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Oncan otetlahtlanihque: ―Tel, ¿tla ijcon, tleca otlatequiuti in Moisés maquimaca in amatl den sihuacahuilistli inon sihuatl huan ijcon maquicahua in itlacau? ");
INSERT INTO ncjNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","In Jesús oquinanquililoc: ―Ijcon oquichiu in Moisés tleca ahhuel mechtlacaquiltilos. Omechcahuili ximosihuacahuacan, huan den achto ahmo ijcon ocatca. ");
INSERT INTO ncjNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Huan nehhuatl namechiluiya in aquin mosihuacahua, huan ahmo tlen itlahtlacol, ahmo cuali quichihuas inon tlacatl. Huan tla mosihuautis ica oc seya, ijcon san sihuaahuiltiya. Huan in aquin mosihuautis ica se sihuatl tlacacauqui, yeh noyojqui san sihuaahuiltiya. ");
INSERT INTO ncjNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Oncan otiteiluihque tehhuan titetlamachticahuan: ―In tla ijcon in tlahtoli ica in tlacatl ihuan isihuau, huelis ocachi cuali ahmo mamosihuautis. ");
INSERT INTO ncjNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Huan in Jesús otechiluihque: ―Huelis queme, huan nochin tlacatl ahhuel quinehnehuilis inon tlahtoli. Quinehnehuilisque san yehhuan in aquin Dios oquinnextililoc. ");
INSERT INTO ncjNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Oncan quesqui intlamachilis in tlacamen ica tlen ahhuel mosihuautisque. Oncan sequin ic otlacatque ahhuel omosihuautihque. Huan oncan oc sequin ica tlen oquichihuilihque in tlacamen huan ahhuel mosihuautiyahque. Huan oncan oc sequin ahmo mosihuautiyahque ic mosecnintlaliyahque ipan in tequitl ica in tetlatequiutilistzin Dios. Huan in aquin cuali mocahua ijcon, mamocahua. ");
INSERT INTO ncjNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Oncan, otehualiquilihque sequin cocone in Jesús mamotlalilican tema ic maquintlaihtanilo ica in Dios. Huan tehhuan titetlamachticahuan otipejque tiquintlacahualtiyahque ica yehhuan aquin oquinualicayayahque. ");
INSERT INTO ncjNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Huan in Jesús omihto: ―Xiquincahuacan in cocone mahualacan ica nehhua huan ahmo xiquintzecocan. Yehhuan aquin tlapoutoc ica tetlatequiutilistzin Dios intlamachilis ijcon quen inin cocone. ");
INSERT INTO ncjNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Huan omotlali in teman ipan in cocone, huan ic inon ohuilohuac de ompa. ");
INSERT INTO ncjNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Se telpochtli omopacho tenahuac in Jesús huan otetlahtlani: ―Tlamachtiyani, ¿tlen cuali tequitl nicpiya nicchihuas ic nicahsis in nemilistli nochipa? ");
INSERT INTO ncjNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Huan Yehhuatzin oquinanquililoc: ―Tel, ¿tleca tinechtlahtlani ica tlen cuali? Tlen, ¿ahmo ticmati san Yehhuatzin Dios in aquin cuali? Huan tla ticnequi ticahsis in nemilistli nochipa, xictlacamati in tetlanahuatil in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Huan oc sepa otetlahtlani in telpochtli: ―¿Huan tlen yehhua cuali? Huan Jesús omonanquilic: ―Ahmo xitemicti; ahmo xisihuaahuilti; ahmo xiichtequi; ahmo xitlacahcayahua; ");
INSERT INTO ncjNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","xiquinmahuestili in motata huan monana; huan xictlasohtla in motlacaicniu ijcon quen tehhua tictlasohtla monemilis. ");
INSERT INTO ncjNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Huan in telpochtli oteiluic: ―Nochin inon nitlatlacamautoc de ihcuac niquitzinin. ¿Axan tlen ocachi nechpolohua? ");
INSERT INTO ncjNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Huan omoluic in Jesús: ―Tla ticnequi timochihuas tlamelajcan, xiyau huan xicnemaca in tlen ticpiya huan xiquintlocoli in prohues. Huan ic inon ocachi hueyi yes motlatlan ompa neluicac, huan oncan xinechcuitlapanui. ");
INSERT INTO ncjNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Huan ihcuac oquicac inon, in telpochtli oya tlocoxtiu, tleca oquipiyaya miyac tomin. ");
INSERT INTO ncjNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Oncan in Jesús otechiluihque tehhuan titetlamachticahuan: ―Ic nele, namechiluiya, molui tequiyo se rico ic calaquis ipan tetlatequiutilistzin in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Huan oc sepa namechiluiya, ocachi ahmo tequiyo ic panos se camello ipan iixtelolo se acoxa quen se rico ic calaquis ipan tetlatequiutilistzin in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ic oticajque inon, tequin quen tel oticmatque huan otimotlahtlanihque san tehhuanten: ―¿Aquin tel cuali maquisas? ");
INSERT INTO ncjNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","In Jesús otechitaque huan otechiluihque: ―In tlacamen ahhuel momaquixtisque san ic yehhuan, huan Dios cuali mochihuas nochin. ");
INSERT INTO ncjNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Oncan in Pedro oteiluic: ―Totecohtzin, tehhuanten oticauque nochin tlen oticpiyayahque, huan otitecuitlapanuihque Tehhuatzin. ¿Huan tlen, tel, ticahsisque? ");
INSERT INTO ncjNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","In Jesús otechnanquililoc: ―Ic nele, namechiluiya, ipan in tonali queman mochihua yancuic in tlalticpactli, huan nehhuatl aquin Nitetiachicau ica nochin tlacatl nicalaquis campa nicahsis nohueyilistzin, ic inon namehhuan aquin onannechcuitlapanuihque noyojqui nohuan nancalaquisque huan nanquintequiutiyahque in mahtlactli huan ome ololi den israeltecos. ");
INSERT INTO ncjNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Huan nochin aquin nopampa oquincauteuque in ichan, noso icnihuan, noso itatahhuan, noso isihuau, noso ipiluan, noso itlaluan, quiselisque molui miyac ocachi huan noyojqui quiselisque in nemilistli nochipa. ");
INSERT INTO ncjNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Huan miyacten aquin axan achtohque ipan inon tonali mochihuasque quen ahmo tlen inquisca, huan miyacten aquin axan nesi ahmo tlen inquisca, ipan inon tonali mochihuasque quen yehhuan achtohque. ");
INSERT INTO ncjNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","In tetlatequiutilistzin Dios yehhuatl quen quinmochihuilis in tlacamen. Yehhuatzin quen se tlacatl iteco se uvahmili. Oquis sancuel quintemohua tlaquehuali matequitican ipan in uvahmili. ");
INSERT INTO ncjNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Huan omocauque tequitisque huan quintlaxtlahuis tonali. Huan oquintitlan in mila matequitican. ");
INSERT INTO ncjNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Huan satepa oya in tiyanquisco yitlahca huan oquinahsic oc sequin tlacamen ahmo quipiyahque tequitl. ");
INSERT INTO ncjNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Huan oquiniluic: “Xiyacan noyojqui xitequitican nomila, huan namechtlaxtlahuis ica tlen quinamiquis.” Huan oyahque tequitihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Huan in iteco oya oc sepa ic nepantla huan noyojqui ic yiyi horahtiotlac huan ijcon oquichiu quen ipan in sancuel. ");
INSERT INTO ncjNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Huan oc sepa oya cana macuili horahtiotlac huan oquinahsic oc sequin aquin ahmo quipiyahque tequitl huan oquintlahtlani: “¿Tleca nican nancaten semiluitl, niyan ahmo nantequitihque?” ");
INSERT INTO ncjNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Huan oquiluihque: “Niyan aquin ahmo techtlaqueutoc.” Oncan oquiniluic: “Xiyacan noyojqui xitequitican ipan nomila, huan namechtlaxtlahuis ica tlen quinamiquis.” ");
INSERT INTO ncjNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Huan ihcuac yitiotlac in iteco oquiluic in aquin quintequiutiya ica in tequitl: “Xiquinnotza in tequitcamen huan xiquintlaxtlahui. Huan xiquintlaxtlahui achto yehhuan aquin satepa omocuenanque, huan ic tlamis tiquintlaxtlahuis in aquin omocuenanque achto.” ");
INSERT INTO ncjNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Oncan omopachohque in aquin satepa omocuenanque ipan in tequitl huan sehsen oquiselihque intlaxtlahual. Huan ahsitoc nochin intlatlan, masque yitiotlac omocuenanque. ");
INSERT INTO ncjNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Huan satepa oquiselihque intlatlan in aquin sancuel omocuenanque ipan in tequitl. Oquimatiyayahque quiselisque ocachi, huan no san yehhua oquiselihque in intonal. ");
INSERT INTO ncjNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Huan ic oquiselihque, opeuque cualanihque ica in iteco, ");
INSERT INTO ncjNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","huan oquihtohque: “Inihque oahsihque yitiotlac huan otequitque cana se hora huan oquintlaxtlahuihque san quen tehhuan otictlanque, huan tehhuan oticxicohque in tequitl huan in tlatotonilotl semiluitl.” ");
INSERT INTO ncjNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Huan in iteco oquinanquilic se de yehhuan: “Ahmo tlen namechchihuilihtica tlen ahmo cuali. ¿Tlahmo otimocauque ica se tanto? ");
INSERT INTO ncjNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Xicuica motlatlan huan xiyau. Nicnequi niquinmacas nochten aquin omocuenanque satepa noyojqui quen tehhua onimitzmacac. ");
INSERT INTO ncjNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Tleca in tlahhuel nicchihuas tlen nicnequi ica notomin? O tel, ¿timoxicohua quen nehhuatl molui inca nitlocoya?” ");
INSERT INTO ncjNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ijcon tel, in aquin ahmo tlen inquisca, yehhuan mochihuasque ocachi hueyi. Huan in aquin axan ocachi hueyi mochihuasque ahmo tlen inquisca. Tleca miyacten aquin axan nesi ahmo tlen inquisca, yehhuan mochihuasque in achtohque. Huan yehhuan aquin axan achtohque mochihuasque quen ahmo tlen inquisca. ");
INSERT INTO ncjNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Huan ihcuac in Jesús omoan in ohtli ic Jerusalén, otechuicaque secnin tehhuan in mahtlactli huan ome titetlamachticahuan huan otechiluihque: ");
INSERT INTO ncjNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Quen nanquitahque namehhuan, titlehcoticaten Jerusalén, huan ompa in aquin nechcocoliya nechtemactis nehhuatl in aquin Nitetiachicau ica nochin tlacatl ica in achtohque tiopixcamen huan tlamachtiyanimen den itlanahuatil Moisés. Huan nechtlahtlacoltisque ica miquilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Huan yehhuan nechtemactisque inmajco in tequihuahmen romanohteco. Huan mahuiltisque ica nehhuatl huan nechuihhuitequisque huan nechmictisque. Huan ipan yiyi tonali niihsas. ");
INSERT INTO ncjNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Oncan omopacho tenahuac in Jesús innana Jacobo huan Juan, yeh in isihuau in Zebedeo. Ohuala inuan ipiluan huan omotlancuaquetz teixpa huan otetlatlauti ica se tlahtoli. ");
INSERT INTO ncjNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Huan Yehhuatzin oquitlahtlanilo: ―Tel, ¿tlen ticnequi? Yehhua otenanquilic: ―Nitetlatlautiya ihcuac mohueyililos, matlatequiutilo ica inihque nopiluan mamotlali seya ipan teyecman huan in oc seya ipan oc se lado. ");
INSERT INTO ncjNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Huan Jesús oquinnanquililoc: ―Namehhuan ahmo nanquinehnehuiliyahque in tlen nanquitlahtlanihque. Tel, ¿cuali nanquixicosque tlen nantlapanosque quen nehhua nitlapanos? Huan yehhuan otenanquilihque: ―Tehhuan noyojqui ticxicosque. ");
INSERT INTO ncjNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Huan Yehhuatzin omoluihque: ―Ijcon nele nantlapanosque quen nehhua nitlapanos. Huan ahmo nechcahualotoc ic niquihtos aquin mosentlalisque nonahuac, tlahmo quinmacalos inon lugar in aquin yomihto in Nohueyitahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Queman oticajque tehhuan in oc mahtlactli, inca oticualanque inon icnimen. ");
INSERT INTO ncjNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Huan in Jesús otechnnotzalo huan otechiluihque: ―Namehhuan nanquimatihque quen in tlacamen den tlalticpac mohueyiliyahque seya ica in oc seya, masque tlatequiutihtoque noyojqui. ");
INSERT INTO ncjNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Huan ahmo xicchihuacan ijcon namehhuan. Huan ica namehhuan in aquin quinequi mochihuas ocachi hueyi quipiya tlen quimpalehuis in oc sequinten. ");
INSERT INTO ncjNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Huan san aquin de namehhuan quinequi mochihuas in achto quipiya tlen motlaliya inmajco in oc sequinten. ");
INSERT INTO ncjNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Maye ijcon quen nehhua. Masque Nitetiachicau ica nochin tlacatl, ahmo onihuala ic nechpalehuisque, tlahmo onihuala niquimpalehuiya huan nimonemictiltis ica nochin tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Huan ihcuac otiquisque ipan in altepetl Jericó, miyac tlacamen otecuitlapanuihque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Huan omahsiteuque ome ixpatzacten yehuaticaten ipan ohtli. Huan oquincaquiltihque quen ompa huilohua in Jesús, huan otetzahtzilihque: ―¡Totecotzin, Tiixuiutzin den David! ¡Toca matlocoyalo! ");
INSERT INTO ncjNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","In tlacamen oquintlacahualtihque mamocahuacan. Huan yehhuan ocachi tetzahtziliyahque: ―¡Totecohtzin, Tiixuiutzin den David! ¡Toca matlocoyalo! ");
INSERT INTO ncjNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Oncan Jesús omotzecolo huan oquinnotzaloc in ixpatzacten huan omotlahtlanihque: ―¿Tlen nanquinequihque manamechchihuilis? ");
INSERT INTO ncjNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Huan yehhuan otenanquilihque: ―¡Totecohtzin, matechtlachiyaltican! ");
INSERT INTO ncjNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Oncan in Jesús inca otlocoyaloc huan omoixmachilihque. Huan saniman otlachixque, huan otecuitlapanuihque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ihcuac ayacmo huehca den Jerusalén, in Jesús oahxihuac ipan in altepetl Betfagé, tlen inahuac ca in Olivostepetl, huan Jesús otechnotzque tonehuan, ");
INSERT INTO ncjNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","huan otechiluiloc: ―Xiyacan ipan inon altepetl toixpa. Ompa nancahsisque se burra ilpihtoc ihuan iconeu. Xictohtomacan huan xinechualiquilican. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Huan tla aquin mechtlahtlanis tleca ijcon nanquichiuticaten, xiquiluican in Totecohtzin monequi huan niman mohualtitlanis. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ijcon opanoc ic matzonquisa quen yihuehcau oquihto se tlayolchicauqui den Dios: ");
INSERT INTO ncjNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Xiquinilui in tlacamen den Jerusalén: “Xiquitacan hualuilohua ica namehhuan in Hueyicatzintli, san tlamach, huan mohualtlalilohtoc ipan se iconeu in burra.” ");
INSERT INTO ncjNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Oncan oyahque in inehuan tetlamachticahuan huan oquichiuque quen Jesús omotequiutihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ocualicahque in burra ihuan iconeu huan oquipehpechtihque ica intatapa, huan ipan omotlaliloc in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Huan in tlacamen tequin miyacten huan ica hueyi mahuestilistli oquisoutayahque intatapa ipan in ohtli ic temahuestilihtihue. Huan oc sequin oquitejque inmaxiuyo in cohuitl huan oquitlalihque ipan in ohtli. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","In tlacamen aquin teyecanahque huan noyojqui in aquin tehualcuitlapanuiyahque opeuque coutzahtzi: ―¡Matemahuestilican Tehhuatzin Tiixuiutzin in David! ¡Matehuelitalo Tehhuatzin aquin hualuilohuas ica in techichualis in Tohueyitahtzin Dios! ¡Titemahuestilisque in Dios! ");
INSERT INTO ncjNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ihcuac in Jesús ocalacohuac ipan in altepetl Jerusalén, nochin tlacatl quen tel oquimatque huan miyacten otlahtlanque: ―Tel, ¿aquin inin tlacatl? ");
INSERT INTO ncjNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Huan in oc sequinten oquihtohque: ―Yeh in tlayolchicauqui Jesús ialtepeu Nazaret, ipan in tlali Galilea. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Huan ic mostla, in Jesús ocalacohuac ipan in hueyi tiopantli huan oquintotocaloc nochten aquin otlanemacatoyahque huan in tlacoucamen de ompa. Omoixcuepque in mesas in tlen ihtech oquipatlayayahque in tomin ica in tlacamen huan canin oquinemacaque in huilomen, ");
INSERT INTO ncjNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","huan omoluihque: ―Ipan in Tetlahcuiloltzin quihtohua: “Nochan quitocahhuisque cali den yolmachtilistli”; huan namehhuan nanquichiutoque cali den ichtejcamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Huan ompa ipan tiopantli omopachohque tenahuac in Jesús sequin ixpatzacten huan xocuehcuelten huan Yehhuatzin omopahtihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Huan ihcuac in hueyixtoque den tiopixcamen huan in tlamachtiyanimen den itlanahuatil Moisés oquitaque inon tlachiuten mahuestic tlen omochihuayaya, yehhuan ocualanque. Huan oquicajque in telpocamen quen oquihtohque chicahuac ipan in tiopan: “¡Matemahuestilican in Ixuiutzin in hueyixtoc David!” Huan ic inon tlen oquicajque, ocachi ocualanque inohque tequihuahten. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Huan oteiluihque in Jesús: ―Tel, ¿tleca ahmo tiquinahhua ica inon ahmo melahuac tlen quihtohticaten? Huan oquinnanquililoc in Jesús: ―¿Tleca niquinahhuas? ¿Tlahmo nanquipoutoque ipan in Tetlahcuiloltzin Dios quen quihtohua? Ijquin quihtohua: Oquimpehualtiloc in coconen huan in aquin oc chichihticaten macuihcuicacan yec ic temahuestiliyahque, masque in hueyi tlacatl ahmo quinequis. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Huan oncan omocauque, huan oquixohuac ipan in Jerusalén hasta in altepetl Betania, huan ompa ocochihuato. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ic sancuel huilohuatica ipan in altepetl Jerusalén, huan oapismicohuac. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Huan omotac se higoscohuitl itentla in ohtli, huan omopacholoc inahuac. Huan ahmo tlen omoahxili itlaquilyo, san nochin ixiuyo. Oncan omihto ica in higoscohuitl: ―¡Ayacmo queman tictlalis motlaquilyo! Huan saniman ohuac in cohuitl. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Queman otiquitaque inon, tehhuan titetlamachticahuan quen tel oticmatque, huan otitetlahtlanihque in Jesús: ―¿Tleca ohuactihuitz ihsiu in higoscohuitl? ");
INSERT INTO ncjNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Huan in Jesús otechnanquililoc: ―Ic nele namechiluiya, tla nanquineltocahque huan ahmo xiahcomanican, ahmo san ijcon nanquichihuasque, in tlahmo noyojqui nanquiluisque inin tepetl: “Ximoihcuani de nican, huan ximototoxohtiu ipan in mar”, huan ijcon panos. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Huan nochin tlen ic nantetlatlautisque ica namoyolmachtilis, in tla nanquineltocasque, inon nanquiselisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Oncan in Jesús ocalacohuac ipan in tiopantli huan omomachtihtoyahque ompa. Huan omopachohque in hueyixtoque den tiopixcamen huan in tequihuahten ipan in tiopantli, huan otetlahtlanihque: ―Tel, ¿ica tlen tequihuahyotl ticchiutica nochin motequiu ijcon quen yalua, huan aquin omitzmacac inon tequihuahyotl? ");
INSERT INTO ncjNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Huan Jesús oquinnanquililoc: ―Neh noyojqui namechtlahtlani ica se tlahtoli. Tla nannechnanquilisque, oncan namechiluis ica tlen notequihuahyou. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Tel, ¿aquin oquititlan in Juan matlacuatequi? Tel, ¿yeh in Dios noso in tlacamen? Huan opeuque moluiyahque san ic yehhuan, huan omoluihque: ―Tla tiquihtosque yehhua in Dios omohualtitlan in Juan, niman techtlahtlanis, “¿Tleca ahmo nanquineltocahque ica yehhua?” ");
INSERT INTO ncjNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Huan tla tiquihtosque san yeh in tlacamen ocualtitlanque, timomoutiyahque ica in tlacamen, cana techtemacasque, tleca nochten quineltocahque in Juan se tetlayolchicaucau in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ijcon oteiluihque in Jesús: ―Ahmo ticmatihque. Oncan omoluihque Yehhuatzin: ―Tel, neh no ijcon ahmo namechiluis canin onicahsi in tequihuahyotl ic tlen nitequiti. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","In Jesús omoluihque: ―Tel, ¿tlen nanquinehnehuiliyahque ica inin? Se tlacatl oquipiyaya ome itelpocahuan, huan oquitequiuti seya de yehhuan: “Xiyau tehhua, huan xitequiti axan ipan touvahmil.” ");
INSERT INTO ncjNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Huan inon itelpocau oquinanquilic: “¡Ahmo niyas!” Huan satepa omonehnehuili, huan oya tequiti. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Oncan in tetata oquitequiuti in oc se itelpocau huan yehhua oquinanquilic: “Queme, niyas.” Huan ahmo oya. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Tel, ¿tlen yehhua den inehuan oquichiu tlen oquintequiuti intata? Oquihtohque inon tequihuahten: ―Yehhua in aquin oya tequiti, masque achto oquihto ahmo yas. Oncan Jesús omoluihque: ―Ic nele namechiluiya, in tlahtlacolyohque quen in renderos huan in sihualocas calaquisque ipan in tetlatequiutilistzin Dios achto quen namehhuan, tleca san nantepacmacahque. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tleca in Juan Tlacuatequiyani ohuala mechnextiliya quen nanquipiyahque tlen nanmoyolcuepasque huan ahmo onanquineltocaque. Huan ic oc seya, in renderos huan in sihualocas oquineltocaque. Huan masque onanquitaque inon, ahmo onanmoyolcuepque ic nanquineltocasque. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Xicaquican in oc se tlalnamictilistli. In iteco se tlali oquimilo se uvasmili, huan oquicorraltzac. Oquichihchiu canin quipatzcasque in uvas, huan noyojqui se torre campa yes in tlachixqui. ’Niman oquintemo in tercieros matequitican ompa, huan yehhua oya huehca. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Huan ihcuac yotlachicau, oquintitlan sequin itlaquehualuan mayacan quintlahtlanilican in tercieros tlen quiselini in iteco. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Huan in tercieros oquinquitzquihque in tlaquehualten huan oquihuihhuitejque seya, huan in oc seya oquitemictihque, huan in oc seya oquitemacaque. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","In iteco in tlali oc sepa oquintitlan sequin tlaquehualten huan ijcon oquinchiuque nochten. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Oncan oquititlan se itelpoch. Oquimatiyaya: “Quipiya tlen quimahuestilisque noconeu.” ");
INSERT INTO ncjNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Huan queman oquitaque in telpochtli, in tercieros omoluihque ic yehhuan: “Inin aquin quiselis in tlali. Tiyohue ticmicti huan ticmocahuisque in tlali.” ");
INSERT INTO ncjNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Huan ijconon oquiquitzquihque huan oquiquixtihque den mila huan oquimictihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Oncan Jesús otlahtlanihuac: ―Tel, ¿ihcuac hualas iteco in tlali, tlen quinchihuilis inon tercieros? ");
INSERT INTO ncjNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Huan oteiluihque: ―Quinmictis inon ahmo cualten, niyan ahmo inca tlocoyas. Huan quintemos oc sequin tercieros matlatequican ica in tlamiloli, in aquin quimacasque in iteco in tlen yehhua quiselini. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Oncan in Jesús omoluihque: ―Tel, tlahmo nanquipoutoque ipan in Itlahcuilotzin canin quihtohua ijquin: In tetl tlen oquitohuetzohque in tequitcamen, inon oquis ocachi cuali para in travesaño itzoncuac in puerta. Huan nehhuatl quen inon tetl. Inin omochiu in Totecohtzin huan yeh in se tlahtoli molui cualtzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ic inon namechiluiya, nanquipolosque in tlen mechmacanihque ipan in tetlatequiutilistzin Dios, huan quinmacasque in tlacamen aquin temactisque in itlaquilyo, tlen quihtosnequi tetlacamatisque ica mahuesyotl. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","In aquin ahmo quineltocas quen nehhuatl inon tetl, yehhua mococos, tla cana omotepehxihui pani ipan in tetl. Ahhuel mohuelmati in tlahmo moyolcuepas. Huan in aquin nechixnamiquis huan ahmo moyolcuepas, yehhuatl quixitinilos quen in aquin oquipechi in hueyi tetl. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Queman oquicajque inon tlalnamictilisten tlen Jesús omihto, inon tequihuahmen oquichiuque cuenta inca otlahtolohuaya. ");
INSERT INTO ncjNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ic inon oquinequiyayahque tetzacuasque huan omomoutihque ica in tlacamen tleca yehhuan otetlamachiliyayahque in Jesús tetlayolchicaucau in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","In Jesús oc sepa oquinnonotzaloc ica in tlalnamictilisten huan oquiniluiloc: ");
INSERT INTO ncjNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Ocachi nanquinehnehuilisque ica in tetlatequiutilistzin Dios tla nanquicaquihque quen oquichiu se hueyixtoc. Oquichiu se iluitl ihcuac omosihuauti in itelpoch. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Oquintitlan in tlaquehualten mayacan quinnotzacan in tetlatlautilten, huan yehhuan ahmo oquinejque yasque. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Oc sepa oquintitlan oc sequin tlaquehualten huan oquiniluic: “Xiquiniluican in tetlatlautilten yica tlachihchiutli in tlacuali. Yonitlatequiuti maquinmictican in cuacuehten huan oc sequin tlatomahualten, huan nochin yica in tlacuali. Mahualacan ipan in mosihuautilistli.” ");
INSERT INTO ncjNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Huan in tetlatlautilten ahmo oquichiuque cuenta. Seya oya tequiti imila, huan oc seya oya ica itlaseman. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Huan in oc sequinten oquinquitzquihque in itlaquehualuan in hueyixtoc huan oquinuihhuitejque huan oquinmictihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Oncan in hueyixtoc tequin ocualan huan oncan oquintitlan in soldados maquinmictican inon temictiyanimen huan maquitlatican inaltepeu. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Oncan oquiniluic in itlaquehualuan: “Nochin yica in tlacuali ica in mosihuautilistli, huan inon tetlatlautilten ahmo quinamiqui mahualacan tleca tequin ahmo cualten. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mayacan ipan ohtli huan xiquintlatlautican nochin aquin nanquinahsisque mahualacan ica in mosihuautilistli.” ");
INSERT INTO ncjNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Oncan in tlaquehualten oyahque ohohtli huan oquinnechicohque san aquin oquiahsique, cualten huan masque ahmo cualten. Huan ijcon ipan in cali otemohuac ica tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Oncan in hueyixtoc oya tlahtec quinita in itetlatlautiluan. Huan oquitac se tlacatl ompa, ahmo tlaquentihtoc quen nochin oc sequinten ica in tlaquemitl den mosihuautilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Huan in hueyixtoc oquitlahtlani: “Tlacatzintli, ¿quenin otiquixcohyehui ticalaquis nica huan ahmo titlaquentihtoc quen in oc sequinten?” Huan yehhua ahmo tlen onahuat. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Oncan in hueyixtoc oquiniluic in aquin tetlahtlamacanimen: “Xiquilpican icxihuan huan imahuan huan xictohuetzocan quiahuac ipan tlayohuilotl, campa nochin tzahtzisque huan hasta tlantzahtzisque.” ");
INSERT INTO ncjNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tleca miyacten omonechicohque, huan san quesqui tlapehpenilten. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Oncan oyahque in fariseos huan omononotzque quen teichtacaahsisque ica in Jesús, huan ijcon cuali teteluisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Yeh in ica oquintitlanque sequin aquin inuan mosechiutoque, san secnin ihuan sequin aquin ihuan pohuihque in Herodes. Yehhuan oteiluihque in Jesús: ―Tlamachtiyani, ticmatihque mach mihtohua tlen melahuac, huan monextiliyahque in tlen melahuac ica in Dios. Ahmo ticchihua cuenta tlen iquisca niyan se tlacatl, in tla hueyi noso ahmo. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","¿Tlen ticnehnehuiliya? ¿Cuali in tla tictlaxtlahualisque in renta in hueyixtoc César noso ahmo? ");
INSERT INTO ncjNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Huan Jesús omonehnehuili quen oquinequiyayahque teichtacaahsisque, huan oquiniluiloc: ―Namehhuan san ome namoxayac. ¿Tleca nannechpihpiyahque? ");
INSERT INTO ncjNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Xinechnextilican in tomin ica tlen quitlaxtlahuahque in renta. Huan otehualiquilihque in tomin. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ic omotac Jesús, omotlahtlanihque: ―¿De aquin ixayac quipiya inin tomin, huan aquin yehhua itoca tlahcuilohtoc nica? ");
INSERT INTO ncjNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Otenanquilihque: ―Yeh in ixayac huan itoca in hueyixtoc. Oncan Jesús omoluihque: ―In tlen ihuaxca in hueyixtoc, xicmacacan, huan ahmo xiquilcahuacan in tlen nanmotemactisque ica in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ihcuac oquicajque inon, san quen tel oquimatque huan otecauteuque. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Saniman inon tonali oyahque teita in Jesús sequin saduceos. Yehhuan quiluiyahque mach ahmo ihsasque in mijcamen. Huan ic inon otetlahtlanihque ica inon tlahtoli. Huan oteiluihque: ");
INSERT INTO ncjNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Tlamachtiyani, in Moisés oquihto mach in tla miquis se tlacatl sihuahua, huan ahmo oquipix niyan se iconeu, oncan iicniu quipiya tlen ihuan motlalis ihuehpol huan quinitasque impiluan huan quihtosque ipiluan aquin omic. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ica tehhuan ocatcahque chicome icnimen. Omosihuauti in tetiachicau huan omic. Huan quen ahmo oquipix niyan se iconeu, oncan in sihuatl ihuan omotlali in icniu icuitlapa in inamic. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Huan ijcon oquipanoc ica yehhua, huan noyojqui ica nochin chicome. Niyan seya ahmo oquipix iconeu. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Huan satepa no omic in sihuatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Oncan tel, ihcuac ihsas den mijcamen, ¿aquin yehhua in isihuau de inon chicome icnimen, quen inuan omotlali nochten? ");
INSERT INTO ncjNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Huan Jesús oquinnanquililoc: ―Namehhuan nanmotlapolochtiyahque, tleca ahmo nanquinehnehuiliyahque tlen quihtohua ipan in Itlahcuiloltzin, niyan in tlen cuali mochihua in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Huan queman ihsasque in mijcamen, ayacmo mosihuautisque tleca ayacmo aquin miquis huan ayacmo aquin tlacatis. Mochihuasque quen in ángeles den Dios tlen caten in neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Tlahmo nanquiamapoutoque ipan in Itlahcuiloltzin in tlen omihto Yehhuatzin Dios ica in ihxohualistli? ");
INSERT INTO ncjNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ijcon omihto: “Nehhuatl niDios aquin temahuestiliyahque in Abraham huan Isaac huan Jacob.” In mijqui ahhuel temahuestiliya in Dios huan in aquin yolticaten, queme. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Huan ic oquicajque in tlen omihto, quen tel oquimatque ica tlen oquinnextililoc. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ihcuac in fariseos oquicajque mach in Jesús oquintentzacualoc in saduceos, oc sepa omopachohque tenahuac. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Huan sequin de yehhuan tlamachtiyanimen den itlanahuatil Moisés. Huan seya oquinequiyaya teichtacaahsis in Jesús, huan otetlahtlani: ");
INSERT INTO ncjNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Tlamachtiyani, ¿cahtli yeh in tetlanahuatil ocachi hueyi? ");
INSERT INTO ncjNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Huan Jesús omoluic: ―“Xitetlasohtla Totecohtzin Dios ica nochin moyolo, huan ica nochin monemilis, huan ica nochin motlanehnehuilis.” ");
INSERT INTO ncjNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yeh in achto tetlanahuatil huan yehhua ocachi hueyi. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Huan ic ome ixnesi in tlen achto tlanahuatili, huan quihtohua: “Xictlasohtla motlacaicniu quenin tehhua timotlasohtla.” ");
INSERT INTO ncjNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Inon ome tetlanahuatil quen ipehualoca de nochin itlanahuatil Moisés huan in tlen oquinextilihque in tlayolchicaucamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","In fariseos ayamo otecauteuque, ");
INSERT INTO ncjNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","huan Jesús oquintlahtlaniloc: ―¿Tlen nanquinehnehuiliyahque ica in Cristo? ¿De aquin ichichicaixuiu? Huan oteiluihque: ―Yehhua ichichicaixuiu in David, in aquin ocatca hueyixtoc yihuehcau. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Oncan in Jesús oquintlahtlaniloc: ―Huan tla ijcon melahuac, ¿tleca inon David otenotz iteco? Huan quen oquiyolchicau in Itiotonaltzin Dios, ijquin oquihcuilo in David: ");
INSERT INTO ncjNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","In Totecohtzin Dios omoluic Notecohtzin Cristo: “Ximotlali ic noyejcan hasta niquimpinautis in motecocolihcahuan.” ");
INSERT INTO ncjNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tel, ¿quen cuali yes in Cristo ichichicaixuiu in David, huan in David, yehhua tenotza Itecohtzin? Quihtosnequi in Cristo ocachi hueyi iquisca quen in hueyixtoc David. ");
INSERT INTO ncjNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Huan niyan aquin ahhuel otenanquili niyan se tlahtoli, huan de inon tonali niyan aquin oixcohyeu ic tetlahtlanis ocachi. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Oncan in Jesús omoluihque in tlacamen ihuan tehhuan titetlamachticahuan: ");
INSERT INTO ncjNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―In tlamachtiyanimen den itlanahuatil Moisés huan in fariseos quipiyahque tequihuahyotl ic tlanonotzasque tlen quihtosnequi in itlanahuatil Moisés. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ijcon tel, xiquintlacamatican huan xicchihuacan nochin tlen mechtequiutiyahque, huan ahmo xicchihuacan quen yehhuan quichihuahque, tleca yehhuan quihtohuahque cuali huan ahmo ijcon quichihuahque. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Quintequimacahque in tlacamen hasta quixpanahuiyahque in tlen nele itlanahuatil Moisés, huan niyan aquin cuali quitlacamatis intlahtol, quen molui tequiyo. Huan yehhuan ahmo quinequihque quitlacamatisque inon tlanahuatili. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nochin tlen quichihuahque san ic maquinuelitacan in tlacamen. Quen mihtos quihuicatinemisque ic ixcuailpitosque huan ic mailpitosque intlacuilolamahuan den itlanahuatil Moisés ihtech in cajitas den cuitlaxtli tlen ocachi hueyi den oc sequinten. Huan quichihuasque ocachi patlahuac den oc sequinten in tlapostectli cualtzihto den intlaquen. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Quinequihque motlalisque canin ocachi cualtzin ipan in iluitlacuali huan canin ocachi mahuestic ipan in tiopanten. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Huan quinequihque maquinmahuestilican nochin tlacatl huan maquintocahhuican “Tlamachtiyani.” ");
INSERT INTO ncjNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Huan namehhuan ahmo nanmocahuasquiyanihque mamechtocahhuican tlamachtiyanimen, tleca namochten nanicnimen huan nanquipiyahque san se tlamachtiyani, quihtosnequi nehhuatl in Cristo. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Huan ahmo xiquiluican niyan aquin “notahtzin” ipan tlalticpac, tleca nanquipiyahque san se Namotatzin, huan Yehhuatzin ilohuac in neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Huan ahmo nanmocahuasquiyanihque mamechnotzacan “tlatequiutiyani”, tleca san nehhuatl in Cristo namotlatequiuticau. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","In aquin quimpalehuiya in oc sequinten, yehhuatl in aquin ocachi mohueyilis ica namehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tleca quipinahuisque in aquin mohueyiliya san isel, huan in aquin ahmo mohueyiliya san isel, yehhua ocachi quimahuestilisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Lastima ica namehhuan, tlamachtiyanimen den itlanahuatil Moisés huan fariseos, san ome namoxayac! Nanquintzacuilihque yehhuan aquin quinequihque calaquisque ipan in tetlatequiutilistzin Dios. Niyan namehhuan ahmo nancalaquisque, huan ahmo nanquincahuahque macalaquican oc sequin. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Lastima ica namehhuan, tlamachtiyanimen den itlanahuatil Moisés huan namehhuan fariseos, san ome namoxayac! Nanquincuiliyahque inchan in viudas huan nanmoyolmachtiyahque huehcau ic nanquincahcayahuasquiyanihque in oc sequinten. Ic inon ocachi chicahuac mechtlapanoltisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Lastima ica namehhuan, tlamachtiyanimen den itlanahuatil Moisés huan namehhuan fariseos, san ome namoxayac! Nanquitemohuahque nohuiyan in aquin cuali nanquitlaneltoctisque ica namotlanehnehuilis. Huan ihcuac nancahsisque, nanquixpehualtisque ipan ohtli mictlan, ic mechyecanas. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Lastima ica namehhuan, san quen nantlayecancamen ixpatzacten! Tleca nanquihtohuahque: “In tla seya camanalti ica in tiopantli queman quitlahtolcaquiltis, ahmo quipiya tlen quitlamiltis. Huan tla camanalti ica in tequitiyantli den oro ipan in tiopantli, ic inon quipiya tlen quitlamiltis.” ");
INSERT INTO ncjNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Nanxoxos huan nanixpatzacten! ¿Tlahmo nanquichihuasquiyanihque cuenta ocachi ica in tiopantli ipan tlen tioxeliutoc inon tequitiyantli den oro? ");
INSERT INTO ncjNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Huan noyojqui nanquihtohuahque: “In tla seya camanalti ica in altar queman quitlahtolcaquiltis, yehhua ahmo quipiya tlen quitlamiltis. Huan tla camanalti ica in tetlocolil ipan in altar, ic inon quipiya tlen quitlamiltis.” ");
INSERT INTO ncjNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Nanxoxos! ¿Tlahmo nanquichihuasquiyanihque cuenta ocachi ica in altar ipan tlen tioxeliutoc inon tetlocolil? ");
INSERT INTO ncjNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Huan in aquin ijcon camanalti ica in altar, ahmo camanalti san ica in altar, in tlahmo noyojqui ica nochin tlen oncan pani. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Huan in aquin camanalti ica in tiopantli, yehhua ahmo camanalti san ica in tiopantli, in tlahmo noyojqui ica in Dios, aquin ompa mocahualo. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Noyojqui in aquin camanalti ica in neluicac, yehhua camanalti noyojqui ica tetequihuahyou in Dios aquin ompa ilohuac. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Lastima ica namehhuan, tlamachtiyanimen den itlanahuatil Moisés huan namehhuan fariseos, san ome namoxayac! Nanquitemactisque seya ica mahtlactli den atochiatl huan oc sequin xiutoton itoca comino huan anís. Huan ahmo nanquichihuahque cuenta ica tlen ocachi hueyi ipan itlanahuatil Moisés. Quihtosnequi nanquichihuanihque in tlen tlamelajcan huan nantetlapohpoluinihque huan nanteneltocanihque. Nanquichihuanihque cuenta ica tlen ocachi hueyi, masque ahmo xiquilcahuacan ica in oc sequin. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Namehhuan quen tlayecancamen ixpatzacten! Nanquichihuahque cuenta ica inon ahmo tlen iquisca huan nanquicholuisque ica tlen ocachi hueyi iquisca. Nannesihque quen in tlacatl aquin quitzehtzelos in atl tlen conis huan motzecos in tzayoli huan quitolos in camello. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Lastima ica namehhuan, tlamachtiyanimen den itlanahuatil Moisés huan namehhuan fariseos, san ome namoxayac! Namehhuan quen in aquin quichipahuas san ilomo in vaso huan in plato, huan iihtec tenticaten ica nochin ahmo cuali. Quihtosnequi namonemilis nesi molui chipahuac, huan tlahmo san nantlachtejcamen huan nanapipisten. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Fariseos ixpatzacten! Ximoyolcuepacan ica nochin ahmo cuali huan ijcon cuali mocahuas chipahuac nochin namonemilis. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Lastima ica namehhuan, tlamachtiyanimen den itlanahuatil Moisés, huan namehhuan fariseos, san ome namoxayac! Namehhuan quen tlaltecochten tlachipautli ic pani huan nannesihque cualtzihto. Huan tlahtec tentiyes ica iohmiyo mijcamen huan nochin tlen palanqui. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","San ijconon namehhuanten. Mechitahque cuali namoxayac iixpa in tlacamen, huan ipan namoyolo ahmo cuali nanquinehnehuilihticaten. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Lastima ica namehhuan, tlamachtiyanimen den itlanahuatil Moisés, huan namehhuan fariseos, san ome namoxayac! Namehhuan nanquichihchihuahque cualtzin intlaltecochuan inohque tetlayolchicaucahuan huan quinxochihuiyahque tla cana nanquinmahuestiliyahque inon tlacamen tlamelajcan. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Huan niman nanquiluiyahque: “In tla otiyehyeni inon tonali den tochichicacoluan, ahmo tiquimpalehuinihque ihcuac oquinmictihque inon tetlayolchicaucahuan.” ");
INSERT INTO ncjNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Huan ic inon tlahtoli onanmocuitihque namehhuan nanquichihuasque ijcon quen yehhuan namochichicacoluan aquin oquinmictihque inon tlayolchicaucanimen. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Xictlamiltican tel, ica in tlen ahmo cuali oquipehualtihque inon namochichicacoluan. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Nantlacahcayaucamen, quen cohuamen! ¿Tlahmo tequin nantlapanosque ipan mictlan? ");
INSERT INTO ncjNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ic inon namechtitlanilis in tlayolchicaucanimen huan tlamatcamen huan tlamachtiyanimen. Huan sequin de yehhuan namehhuan nanquinmasohualtisque ic nanquinmictisque. Huan oc sequin nanquinuihhuitequisque ipan in tiopanten huan nanquinchololtisque altepetl por altepetl. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Huan ijcon namopan huetzi quen namotlahtlacol nochin mijcamen, quihtosnequi inohque cualten tlacamen aquin oquinmictihque. In achto yeh in Abel huan hasta in Zacarías iconeu in Berequías, aquin oquimictihque ipan in tiopantli iixco in altar. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ic nele namechiluiya, intlahtlacol ica nochin inon impan huetzi in tlacamen aquin axan nemihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’Tequin nimotlocoltiya ica namehhuan nanchanimen den Jerusalén. Namehhuan aquin nanquinmictiyahque in tlayolchicaucanimen huan nanquintemacahque in tetlatitlaniluan Dios. Miyacpa namechpalehuini quen in cuanaca quinsentlalis ipiluan, huan ahmo onannechcahuilihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Xiquitacan namehhuan. Axan namechcahua xicchihuacan quen nanquinequisque, tla nanmopalehuisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Huan namechiluiya ocachi, ayacmo nannechitasque hasta ahsiquiu in tonali queman nanquihtosque: “Molui Tlasohtzintli in aquin hualuilohuas ica techicahualis Totecohtzin.” ");
INSERT INTO ncjNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Oquixohuac in Jesús ipan in tiopantli, huan yohuilohuayaya queman tehhuan titetlamachticahuan otimopachOhque tenahuac huan oticteiluihque mamota quen cualtzin nesihque in calten den tiopantli. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Huan in Jesús otechnanquililoc: ―Queme, molui cualtzihto axan nesihque, huan cuali in tla nanquitahque nochin inon. Ic nele namechiluiya, nican ahmo mocahuas niyan se tetl iixpa in oc seya, tlahmo nochin tlaxitinilten yesque. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Oncan otiyahque ipan in Olivostepetl, huan ihcuac in Jesús omotlaliloc ompa, otimopachohque tenahuac, huan ihcuac tosel otimocauque, otitetlahtlanihque: ―Ticnequihque matechiluilo queman motzonquixtis inin, huan quen ticmatisque tlen tonali hualuilohuas, huan queman yau tlalpolihui. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Oncan in Jesús otechiluihque: ―Xicchihuacan cuenta ahmo aquin mechcahcayahua. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tleca chicoquisasque miyacten aquin tlanonotzasque ica notoca huan mechiluisque: “Nehhuatl in Cristo”, huan quincahcayahuasque miyacten. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Huan mechnonotzasque quen oncan nemictilistli huan nanquicaquisque ica san tlahtoli den nemictilistli. Huan ahmo ximomoutican tleca inin quipiya tlen panos huan ayamo yehhua ic tlalpolihui. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tleca moixnamiquisque se altepetl ica in oc seya, huan hualas in hueyi apistli huan cocolistli, huan tlaluehueyocas miyajcan ipan altepemen. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nochin inon san ipehualoca ica in tlapanolistli. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Oncan mechtemactisque ic mechuihhuitequisque huan mechmictisque, huan nochin tlacamen mechixtlasasque nopampa. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ipan inon tonali miyacten moxihxicosque ica nehhuatl huan motlahuelitasque huan motemactisque se huan oc seya. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Monextisque miyacten ixtlamatcamen, huan quihtosque mach tlahtohuahque ica tetlahtoltzin huan ijcon quincahcayahuasque huan quinuicatinemisque miyacten. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nohuiyan san tlen quichihuasque in ahmo cualten, huan ic inon miyacten ayacmo motlasohtlasque. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Huan in aquin ahmo moxihxicohua, yehhua maquisas. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Huan inin cuali itlahtoltzin ica in tetlatequiutilistzin Dios quinonotzasque in tlayolchicaucamen nohuiyan ipan in tlalticpactli, maquicaquican nochin tlacatl. Huan satepa inon tlalpolihuis. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’In tlayolchicauqui Daniel oquihcuilo ica inon tlen tlayolihtlacohua hasta quitlasohchihuas. In aquin quiamapohua, maquinehnehuilui tlen quihtosnequi inin. Ihcuac nanquitasque quen ompaca motlalihtoc ipan in tiopantli, ");
INSERT INTO ncjNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","in aquin nemisque ipan tlali Judea, maquisacan den inaltepehuan huan xicholocan ipan coutlahtli. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Huan in aquin masque ipan quiahuactli, ahmo macalaqui calihtec cana quiquixtis itlahtlen yes tlahtec. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Huan in aquin yes ipan in tlamiloli, ahmo mamocuepa ichan cana quinequis itlaquen. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Lastima ica in sihuamen yipiluahque noso yitlachihchitihtiyesque ipan inon tonali! ");
INSERT INTO ncjNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Xitetlatlautican in Dios ahmo maye ipan in tonali itztic ihcuac nanquipiyahque tlen nancholosque, niyan ipan in tonali den nesehuilistli, tleca yeh in tonali mechcahuilisque san chihton nannehnemisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Huan yes chicahuac tlapanolistli, quen ahyic mochiutoc de ihcuac ones in tlalticpactli, niyan ahmo mochihuas satepa. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Huan tla huehcahuis inon tonali, ahmo maquisanihque niyan aquin. Huan ahmo huehcahuis inon tonali tleca in Dios quintlasohtlalo yehhuan aquin yoquimpehpenaloc. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Oncan ahmo xicneltocacan in tla aquin mechiluiya: “Xiquitacan, nicanca in Cristo”, noso “Xiquitacan, ompaca.” ");
INSERT INTO ncjNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tleca hualasque in tlacahcayaucamen aquin mochihuanihque Cristos noso in aquin quihtohuahque mach, tlahtohuahque ica tetlahtoltzin in Dios. Huan quinnextilisque hueyi tlachiuten mahuestic tlamelajcan, huan in tla cuali quincahcayahuasque yehhuan aquin in Dios yoquintlapehpeniloc. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yonamechiluic nochin inin masque ayamo yeh in tonali. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Huan ic inon, tla mechiluisque: “Xiquitacan, ompaca ipan in acahualtlahtli”, ahmo xiyacan ompa. Noso in tla mechiluisque: “Xiquitacan, motlatihtoc ipan se cuarto”, ahmo xicneltocacan. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tleca ihcuac nihualas nehhuatl aquin Nitetiachicau ica nochin tlacatl, nesis quen tlapetlani tlen quitasque san sentetl ipan in neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Monechicosque in tzopilomen canin yes in mijcayolcatl, huan ahmo aquin quinnahuatis. Huan no ijcon nohuiyan quimautiyesque ihcuac nihualas. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Huan ihcuac otlan in tlapanolistli de inon tonalten, saniman polihuis in tonaltzintli huan ahmo metztonas. In sitlalten huetzisque den neluicac huan quintzehtzelos in chicautoque den neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Oncan nechitasque nehhuatl aquin Nitetiachicau ica nochin tlacatl ic nihualas ipan in mexten ica hueyi chicahuilistli huan cualtzin nohueyilistzin. Huan ic inon tlocoyasque nochin tlacatl den tlalticpactli. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Huan niquintitlanis noángeles huan ica chicahuac tlatzohtzonalistli ica in trompeta yehhuan quinsentlalisque notlapehpeniluan nohuiyan ipan tlalticpactli. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Ximomachtican ica in tlalnamictilistli den higoscohuitl. Ihcuac selic in itlaselyo, nanquimatihque ayacmo huehcau in tonali den tlatotonilotl ipan inin tlali. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Huan noyojqui ijconon, queman nanquitasque nochin inin in tlen namechiluihtoc, xicmatican ayacmo huehcau ic nihualahsis. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ic nele namechiluiya, nochin inin tzonquisas achto ic tlamisque in tlacamen de inin tlali. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Polihuis in neluicac huan in tlalticpactli, huan ahmo polihuis ic tzonquisas in tlen namechiluihtoc. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Niyan aquin quimati tlen tonali, niyan tlen horas, masque in ángeles, noso nehhuatl niteconetzin, in tlahmo san Yehhuatzin Tohueyitahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Ijcon quen onehnenque ipan in tonali den Noé, no ijcon nentiyesque ihcuac nihualas nehhuatl aquin Nitetiachicau ica nochin tlacatl. Ahmo oquichiuque cuenta ica in tlen oquinnonotz in Noé. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ipan inon tonali, achto den tetzahuitl ica in hueyatl, otlacuahticatcahque huan otlayihticatcahque huan omosihuautihticatcahque hasta in tonali ihcuac ocalac in Noé ipan in hueyi cajoncali tlen nemis ipan atl. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Huan ahmo oquinehnehuilihque in tlen quimpanos hasta oquinahsi in atl huan oquinuicac nochten. Huan no ijcon yes ihcuac nihualas nehhuatl aquin Nitetiachicau ica nochin tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Oncan yesque ome tlacatl ipan in tlamiloli. Seya quihuicasque in ángeles huan in oc seya quicahuasque. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Testiyesque ome sihuamen ipan se cali. Seya quihuicasque in ángeles huan in oc seya quicahuasque. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Xiyectlamautiyecan namehhuan, tleca ahmo nanquimatihque tlen horas hualuilohuas in Tecohtzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Xicmatican inin. In tla iteco se cali quimatisquiyani tlen horas ahsitiu in ichtejqui, ihsatiyes huan ahmo mocahuas maquicaltlapo ic quitlachtequis. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ic inon, ximoyectlalican namehhuan tleca nihualas nehhuatl aquin Nitetiachicau ica nochin tlacatl huan niyan ic nanquimatisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Yeh in tlaquehuali yolcuali aquin quinehnehuiliya itequiu, aquin quicahua iteco maquinita ica in oc sequin tlaquehualten, maquintlamaca ipan in hora in tlen oquihto. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Huan pactoc inon tlaquehuali queman quiahsis iteco huan tequiutoc cuali. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ic nele namechiluiya, in iteco quitemactis imajco nochin tlen quipiya. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Huan cana yes inon tlaquehuali ahmo cuali, huan quinehnehuiliya mach huehcahuis iteco ic hualas, ");
INSERT INTO ncjNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","huan pehuas quinuitequis in oc sequin tlaquehualten huan yehhua yau tlacua huan pehua tlayi ihuan aquin huintitinemisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ic inon mocuepas in iteco ipan se tonali queman ahmo quichixtiyes inon tlaquehuali, niyan quen ic quimati tlen horas ahsiquiu in iteco. ");
INSERT INTO ncjNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Huan quitlapanoltis in ahmo cuali tlaquehuali, maye inuan yehhuan in san ome inxayac. Oncan chocasque huan tlantzahtzisque quen motlocoltisque ihcuac quilnamiquihque tlen quichihuanihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ihcuac nimocuepas quen hueyixtoc ipan tetlatequiutilistzin Dios ijcon yes quen oquimpanoc ica in mahtlactli ichpocamen aquin oquihuicaque in tlanexten huan oyahque quinamiquihque in mosihuautiyani. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Macuili san yolmijcamen huan in oc macuili tlanehnehuiliyahque. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","In yolmijcamen oquihuicayayahque intlanexten huan ahmo oquihuicayayahque tlen ic quitemitisque intlanex ihcuac sehuisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Huan in macuili aquin tlanehnehuiliyahque oquihuicayayahque intlanex ihuan tlen ic quitemitisque intlanex ihcuac sehuisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Huan ohuehcau ic oahsico in mosihuautiyani, huan ocochmijque in ichpocamen, huan ocochque. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Oncan cana tlacoyohuac, oquicajque quen ocoutzahtzihque: “¡Ompahuitz in mosihuautiyani. Xiquisacan ic nanquiselisque!” ");
INSERT INTO ncjNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nochtehque inon ichpocamen omejque huan oquiyectlalihque intlanex. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Niman in macuili yolmijcamen oquiniluihque in oc macuili aquin tlanehnehuiliyahque: “Xitechmacacan chihton in aceite, tleca yau sehuihque totlanexuan.” ");
INSERT INTO ncjNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Huan inon ichpocamen aquin tlanehnehuiliyahque oquinnanquilihque: “Ahmo, cana ahmo ahsis ica tehhuan huan ica namehhuan noyojqui. Ocachi cuali xiyacan canin quinemacahque, huan xicohuacan tla mechpolohua.” ");
INSERT INTO ncjNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Huan ihcuac oyahyaya quicohua aceite inon macuili ichpocamen yolmijcamen, yoahsito in mosihuautiyani. In ichpocamen aquin quipixticaten intlanex ocalajque ihuan ipan in mosihuautilistli, huan hualtlatzajque. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Satepa oahsique in oc sequin ichpocamen, huan oquiluihque: “¡Tlacatzintli, matechtlatlapoluican!” ");
INSERT INTO ncjNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Huan yehhua oquinnanquilic: “Ic nele ahmo namechixmati.” ");
INSERT INTO ncjNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Oncan in Jesús omoluihque: ―Xitlamautiyecan namehhuan, tleca ahmo nanquimatihque in tonali niyan in horas queman nihualas nehhuatl aquin Nitetiachicau ica nochin tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Ihcuac nimocuepas quen hueyixtoc ipan tetlatequiutilistzin Dios, yes quen oquimpanoc in itlaquehualuan se tlacatl aquin quinequi yas ipan oc se altepetl. Oquinnotz in itlaquehualuan huan oquinmacac in tomin ic matequitican. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Se de inohque oquimacac cana macuili mil den tomin, huan oc seya oquimacac cana ome mil, huan oc seya oquimacac san se mil. Oquinmacac sehseya quen cuali tequitisque. Oncan oquian ohtli yehhua. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","In tlaquehuali aquin oquiseli in macuili mil ic otlaseman, ijcon oquitlan oc macuili mil. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Huan noyojqui ijcon ica in aquin oquiseli in ome mil. Yehhua oquitlan oc ome. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Huan in aquin oquiselic se mil, yehhua oquitlaltocac in tomin den iteco. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Huan satepa ipan miyac tonali omocuep inon inteco, huan opeu quichihua cuenta inuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Achto oahsito in aquin quiselihtoc in macuili mil, huan oquitemacti in oc se macuili mil. Huan oquiluic: “Noteco, onechmacaque macuili mil huan nicanca in oc se macuili mil tlen onictlan.” ");
INSERT INTO ncjNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Huan iteco oquinanquilic: “Cuali tel, tehhuatl tequin cuali tlaquehuali. Quen cuali otictlatequiuti ica chihton, ic inon nimitztlalis titlatequiutis ica ocachi miyac. Xipehua ica motequiu ica paquilistli.” ");
INSERT INTO ncjNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Oncan oahsito in oc se tlaquehuali aquin quiselihtoc in ome mil, huan oquiluic: “Noteco, onechmacaque in ome mil, huan nicanca oc ome mil tlen onictlan.” ");
INSERT INTO ncjNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Huan iteco oquinanquilic: “Cuali tel, tehhuatl tequin cuali tlaquehuali. Quen cuali otitlatequiuti ica chihton, ic inon nimitztlalis titlatequiutis ica ocachi miyac. Xipehua ica motequiu ica paquilistli.” ");
INSERT INTO ncjNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Huan ihcuac oahsito in tlaquehuali aquin quiselihtoc in se mil, oquiluic in iteco: “Noteco, nehhua onicmat quen tehhuatzin tequin chicahuac tetlahtol, huan masque ayacmo tequitihua ipan tlamiloli, pixcohua miyac, huan mosentlaliya canin ahmo tequitihuahtoc. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ic inon onimomouti cana nicpolos, huan ic inon onictlaltocac tetomin. Huan nicanca in tlen tehuaxca.” ");
INSERT INTO ncjNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Huan oquinanquilic in iteco: “¡Ahmo cuali titlaquehuali tlahtziuqui! Tla nele oticmat quen nipixca huan nicsentlaliya canin ahmo nitequiutoc, ");
INSERT INTO ncjNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","tel, ¿tleca ahmo otican inon tomin ipan banco, huan ijcon nicselini notomin huan iconeu?” ");
INSERT INTO ncjNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Huan oquiluihque in aquin ompa ocahcatca: “Xicuili inon mil huan xicmaca in aquin quipiya in mahtlactli mil. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tleca ijcon ca; in aquin tequiti ica tlen quipiya, quiahsis ocachi hasta quipiya temoute. Huan in aquin ahmo tequiti ica tlen quipiya, quicuilisque in chihton tlen quipiya. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Huan inon tlaquehuali aquin ahmo otequit, xiquixtohuetzocan quiahuac ipan in tlayohuilotl. Ompa chocasque huan tlantzahtzisque, quen tlocoltiyesque ihcuac quilnamiquisque tlen quichihuanihque.” ");
INSERT INTO ncjNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Ihcuac nihualas nehhuatl aquin Nitetiachicau ica nochin tlacatl, huan nohuan hualasque nochin in ángeles, nimotlalis inahuac tehueyilistzin campa nitlixcomacas. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mosentlalisque nochin tlacamen den tlalticpac noixpa, huan niquinxexelos quen in tlahpixqui quinxexelohua in calnelohten huan in chivos. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Niquintecpanas ipan noyecman in calnelohten, huan in chivos ic noalrevez. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ijcon nehhuatl in hueyixtoc niquiniluis aquin caten ipan noyecman: “Xihualacan namehhuan in aquin mechuelitalohtoc ica Notahtzin. Axan Yehhuatzin mechsehuilos ipan tetlatequiutilistzin quen omechyectlalilo queman omochiu in tlalticpactli. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tleca oniapismic huan onannechtlamacaque. Oniamic huan onannechatliltihque. Oniahantinemiyaya huan onannechsehuihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Onechpolo notlaquen huan onannechtlaquentihque. Huan onimococo huan onannechitahque. Onechtzajque huan onannechpalehuihque.” ");
INSERT INTO ncjNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Huan nechiluisque inon tlamelajcanten: “Totecohtzin, ahmo tiquilnamiquihque in tla otiteahsique apismicohuatica huan otitetlamacaque. Niyan ahmo tiquilnamiquihque in tla otiteahsique amicohuatica huan otiteatliltihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Huan ahmo tiquilnamiquihque in tla otiteahsique ahantinemilohuaya huan otitesehuihque. Huan ahmo tiquilnamiquihque in tla otiteahsique xipetzin huan otitetlaquentihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Huan ahmo tiquilnamiquihque in tla otiteahsique mococolo noso ipan telpiloyan, huan otitepalehuihque.” ");
INSERT INTO ncjNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Huan nehhuatl in hueyixtoc niquinnanquilis: “Ic nele namechiluiya, nochin tlen onanquichihuilihque ica seya de inohque notlasohicnihuan, aquin ahmo tlen iquisca, no ijcon onechchihuilihque.” ");
INSERT INTO ncjNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Oncan nehhuatl in hueyixtoc niquiniluis yehhuan aquin caten ipan nomaalreves: “Ximoihcuanican nonahuac, namehhuan aquin tlahtlacolyohque. Mamechtohuetzocan ipan in tletl den mictlan, in tlen tlayectlalili ica in ahmo cuali tlacatl ihuan iángeles. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tleca oniapismic, huan namehhuan ahmo onechtlamacaque. Oniamic huan ahmo onannechatliltihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Oniahantinemiyaya, huan ahmo onannechsehuihque. Onechpolohuaya notlaquen huan ahmo onannechtlaquentihque. Huan onimococohuaya huan nechtzactoyahque huan ahmo onannechpalehuihque.” ");
INSERT INTO ncjNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Oncan nechiluisque yehhuan: “Totecohtzin, ahmo tiquilnamiquihque in tla otiteahsique apismicohuatica noso amicohuatica, noso ahantinemilohuaya, noso ihcuac otepolohuaya tetlaquen, noso omococolohuaya, noso otzacuihuatoya, huan ahmo otitepalehuihque.” ");
INSERT INTO ncjNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Huan nehhuatl in hueyixtoc niquinnanquilis: “Ic nele, namechiluiya, nochin tlen ahmo onanquichiuque ica seya den inihque aquin ahmo tlen iquisca, no ijcon ahmo onanquichiuque ica nehhuatl.” ");
INSERT INTO ncjNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Niman in inohque quinuicasque campa tlapanosque nochipa huan in tlamelajcanten calaquisque ipan in nemilistli nochipa. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ihcuac in Jesús otlan tlanonotzalo ica inon tlahtoli, otechiluihque tehhuan titetlamachticahuan: ");
INSERT INTO ncjNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Nanquimatihque san ome tonali polihui in pascuahiluitl. Huan nechtemactisque nehhuatl aquin Nitetiachicau ica nochin tlacatl, huan nechmasohualtisque ic nechmictisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Oncan omosentlalihque in achtohque den tiopixcamen, huan in tlamachtiyanimen den itlanahuatil Moisés, huan in tequihuahmen den judeatecos. Huan canin omosentlalihque, yeh in icaltenco in ical Caifás, yeh in hueyixtoc den tiopixcamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ompa omononotzque quen teichtacaquitzquisque in Jesús ic temictisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Huan oquihtohuayahque: ―Ahmo ipan iluitl, cana yes tlamohsihuilistli ica in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Oilohuaya in Jesús ipan in altepetl Betania, ichan Simón aquin opapalanticatca itlacayo. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Huan omopacho tenahuac se sihuatl ocualicac se tehuilotl cualtzin ica pahtli ahhueyac huan molui patiyo. Ihcuac otlacualoticatca in Jesús, inon sihuatl otecuacuepili in pahtli. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ihcuac otiquitaque inon, oticualanque huan otipeuque timononotzahque: ―¿Tleca ijcon oquitlasohchiu inon pahtli? ");
INSERT INTO ncjNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Cuali quinemacani patiyo, huan ijcon quimpalehuini in prohues. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Huan omocac in Jesús, huan otechiluiloc: ―Tel, ¿tleca nanquimohsihuiyahque inin sihuatl? Inin tlen onechchihuilic molui cuali. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","In prohues nochipa namohuan yesque, huan nehhuatl ahmo. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Huan yehhuatl onechcuacuepili inon pahtli, quen quihtosnequi quiyectlalis notlacayo ic nechtocasque. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ic nele namechiluiya, san canin quinonotzahque ica in tlahtoli den tlamaquixtilistli ipan nochin tlalticpac, mononotzasque noyojqui ica tlen oquichiu inin sihuatl, ic maquilnamiquican ica yehhua. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Oncan seya de tehhuan mahtlactli huan ome tetlamachticahuan, yeh in itoca Judas Iscariote, oya quinita in achtohque den tiopixcamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Huan oquintlahtlani: ―Tel, ¿quesqui nechmacasque tla namechtemactilis in Jesús? Oncan oquicocoltihque sempohuali huan mahtlactli tomin den plata. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ihcuac inon oquichix ocachi cuali queman tetemactis in Jesús inmajco yehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ipan ipeuyan in iluitl queman quicuasque in pantzin tlen ahmo semautoc, tehhuan titetlamachticahuan otimopachohque tenahuac in Jesús huan otitetlahtlanihque: ―¿Canin monequi ticchihuasque in tlacuali den pascua? ");
INSERT INTO ncjNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Huan otechiluiloc Yehhuatzin: ―Xiyacan ipan in hueyi altepetl, quihtosnequi Jerusalén, huan nancahsisque ichan se tlacatl canin techchixticaten. Huan xiquiluican: “Yiahsitiu in tonali tlen nicchixtica, huan ipan mochan titlacuasque ica in pascuatlacuali.” ");
INSERT INTO ncjNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Huan oticchiuque quen otechtequiutiloc in Jesús, huan oticyectlalihque in pascuatlacuali. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ihcuac tlapoyautica, oilohuaya in Jesús inahuac in mesa tohuan tehhuan in mahtlactli huan ome titetlamachticahuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ihcuac titlacuahticaten, otechiluihque: ―Ic nele namechiluiya, seya de namehhuan nechtemactis. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Oncan tequin otitlocoxque, huan otipeuque timotlahtlaniyahque se huan oc seya: ―Totecohtzin, ¿cana nehhua nitetemactis? ");
INSERT INTO ncjNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Huan otechnanquilihque in Jesús: ―Aquin nohuan tlacuahtica, yeh in aquin nechtemactis. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nehhuatl aquin Nitetiachicau ica nochin tlacatl nimiquis quen omihto in Dios ipan in Tetlahcuiloltzin. Huan lastima ica in tlacatl aquin nechtemactis. Ocachi cuali ahmo tlacatini inon tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Oncan otetlahtlani in Judas, yeh in aquin tetemactis: ―Tlamachtiyani, ¿cana nehhua nitetemactis? Huan oquinanquililoc in Jesús: ―Ticmautica tehhua. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ihcuac otitlacuaticatcahque, in Jesús omoan in pantzin, huan omotlasohcamatiloc ica in Dios. Omoxehxelo, huan otechmacaloc. Huan otechiluiloc: ―Xicuacan; inin yeh in notlacayo. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Niman omoan se vaso ica vino huan omotlasohcamatiloc, huan otechmacaloc. Huan otechiluiloc: ―Xiconican namochten inin tlayili, ");
INSERT INTO ncjNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","tleca yeh in noyes ica tlen nanquilnamiquisque ica in yancuic mononotzalistli tlen mochihua Notahtzin Dios ica nochin aquin tehuaxca. Yehhuatzin quintlapohpoluilos intlahtlacol tleca impampa nimiquis. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Huan namechiluiya ayacmo queman niconis inin uvahtlayili hasta in tonali niconis namohuan ihcuac mochihuas yancuic in tlalticpactli huan in neluicac ipan tetlatequiutilistzin Notahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Huan ihcuac oticuihcuicaque se tlamahuestilistli, otiquisque ipan cali huan otiyahque ipan in Olivostepetl. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Oncan in Jesús otechiluiloc: ―Inin tlayohua namochten nanmopinautisque ica nehhua. Tleca ijcon omihto in Dios ihtech Itlahcuiloltzin: “Nicmictis in paxtol huan in ololi den calnelohten mochayahuasque.” ");
INSERT INTO ncjNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Huan queman yoniihsac namechyecanas ic Galilea. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Oncan in Pedro otenanquilic: ―Masque nochten mopinautisque ica Tehhuatzin, nehhua ahmo. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Huan in Jesús omoluic: ―Ic nele nimitziluiya, achto ic tzahtzis in pachilel, teh tinechixtlatis yexpa. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Huan in Pedro oc sepa oteiluic: ―Masque nicpiya tlen tehuan nimiquis, ahmo niteixtlatis. Huan ijcon otiquihtohque tinochten. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Oncan in Jesús oahxihuato ipan in huerta itoca Getsemaní tohuan tehhuan titetlamachticahuan. Huan otechiluiloc: ―Ximosehuican nican ic niyau ompa nimoyolmachtis. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Huan oquinuicalo in Pedro, huan in ome ipiluan in Zebedeo, huan opehualoc motlocoltilo molui, huan omomohsihuiloc. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Oncan oquiniluiloc: ―Tlahuel nimotlocotihtica huan nicmachilihtica ayacmo nicxicos. Ximocahuacn nican huan xiihsatiyecan. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Oncan in Jesús onehnemohuac oc chihton huan otlaltenamiquiloc ic omoyolmachtiloc. Huan omihto: ―Notahtzin, in tla cuali oc noncua, manechpalehuican ahmo nitlapanos. Huan ahmo maye san quen nicnequi nehhua, in tlahmo quen ticmonequiltiya. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Oncan omocuepaloc canin omocauteuque inon yiyinten, huan oquinahsiloto cocochtoque. Huan omoluic in Pedro: ―Tel, ¿ahhuel nanihsatiyesque niyan chihton? ");
INSERT INTO ncjNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Xiihsatiyecan huan ximoyolmachtican huan ijcon ahmo tlen mamechyoltilana. Ic nele ijcon quinequis seya ipan iyolo huan yeh in itlacayo ahhuel. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ipan oupa ohuilohuac huan ijquin omoyolmachtiloc: ―Notahtzin, in tla ahhuel nimaquisa ica tlen nitlapanos quen omihto, ijcon maye quen ticmonequitiya. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Niman omocuepaloc, huan oc sepa oquinahsiloto cocochtoque, tleca tequin cochmicticaten huan moixtentzacticaten ica cochistli. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Oquincahualoc huan ohuilohuac moyolmachtilo ipan yexpa, huan sajcon mihtohtiu quen achto. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Oncan omocuepaloc canin otechcauteuque tehhuan in oc sequinten titetlamachticahuan huan otechiluiloc: ―Tel, ¿oc nancochticaten huan oc nanmosehuihticaten? Yoahsic in horas queman inmajco in tlahtlacolyohque nechtemactisque nehhuatl aquin Nitetiachicau ica nochin tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ximehuacan huan tiyohue. Ompahuitz in aquin nechtemactiya. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Oc otlahtohticatca in Jesús ihcuac oahsic in Judas, yeh in seya de tehhuan mahtlactli huan ome titetlamachticahuan. Huan ihuan ohualahque miyac tlacamen ica in espadas huan cohuitl. Oquinualtitlanque in achtohque den tiopixcamen huan in tequihuahmen den judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Huan in Judas, yeh in aquin otetemacti in Jesús, yoquiniluic: ―In aquin nicpipitzos, yeh inon huan xiquitzquican. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Oncan omopacho tenahuac in Jesús huan oteiluic: ―¡Tiotlaquiltitzino, Tlamachtiyani! Huan otepipitzo. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Huan in Jesús oquinanquililoc: ―Notenonotzcau, ¿ica tlen otihuala? Oncan omopachohque huan otequitzquihque in Jesús huan otehuicaque tlamactili. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Huan ic inon oquiquixti iespada se de tehhuan titetlamachticahuan huan oquinacastzontec in itlaquehual in hueyixtoc den tiopixcamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Oncan in Jesús oquiluiloc: ―Xiquehua in moespada. Nochin aquin motehuiyahque ica in espada, no ijcon miquisque ica in espada. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Tlen nanquinehnehuiliyahque? ¿Ahhuel nitetlahtlanilis Notahtzin huan Yehhuatzin axan niman nechualtitlanililos quesqui miles den ángeles? ");
INSERT INTO ncjNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Huan tla ijcon nicchihuas, tel ¿quenin tzonquisas in tlen tlahcuiloli, quen oquihto ica tlen nechtlapanoltisque? ");
INSERT INTO ncjNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Oncan in Jesús oquiniluiloc in tlacamen: ―¿Tleca nanchicoquisque ica in espadas huan tlacuahcuili ic nannechquitzquisque, quen niyesquiyani tlachtejqui? Nochin tonali ipan in tiopantli onamechnextiliyaya huan ahyic onannechquitzquihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Huan nochin ijcon panohua, matzonquisa in tlen oquihtohque in tlayolchicaucamen ipan Itlahcuiloltzin. Oncan otitecauque tesel tinochten titetlamachticahuan huan oticholohque. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Huan otehuicaque in Jesús iixpa in Caifás, yeh in hueyixtoc den tiopixcamen. Yeh in ichan canin mosentlalihtoque in tlamachtiyanimen den itlanahuatil Moisés huan in tequihuahmen den tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Huan in Pedro oquinuehcacuitlapanui hasta icaltenco ichan in hueyixtoc. Huan ocalac huan omotlali inuan in topilihten, maquita quen quisas nochin inon. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","In achtohque den tiopixcamen huan in tequihuahmen den tiopantli otetemoliyayahque tlen ica teteluisque in Jesús, masque ahmo tlen melahuac. Ijcon tetlahtlacoltisnequihque ic temictisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Huan ahmo ocahsique tlen ic tetlahtlacoltisque, masque miyacten omonechicohque huan teca oteistlacahuihque. Satepa de nochin omonechicohque in inehuan istlacatcamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Huan oquihtohque: ―Inin tlacatl oquihto: “Nehhuatl cuali nicxitini in tiopantli den Dios huan ipan yiyi tonali nicchihchihuas oc sepa.” ");
INSERT INTO ncjNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Oncan omoquetz in hueyixtoc den tiopixcamen, huan oteiluic in Jesús: ―¿Tleca ahmo titechnanquiliya? Tel, ¿melahuac inin tlen mitzihtaluihticaten? ");
INSERT INTO ncjNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Huan in Jesús san tlamach omocahualoc. Oncan oteiluic in hueyixtoc den tiopixcamen: ―Quen nis teixpa ticaten in Dios, nimitzyoluitis xitechilui tlen melahuac. In tla tehhuatl in Cristo, teconeu in Dios, xitechilui. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Huan in Jesús oquinanquililoc: ―Nehhuatl queme, quen tiquihtohua. Huan noyojqui namechiluiya, nannechitasque nehhuatl aquin Nitetiachicau ica nochin tlacatl ihcuac nimotlalihtos ipan teyecman in Dios Chicahuactzin, huan ihcuac nihualas ipan in mextli den neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Oncan in hueyixtoc den tiopixcamen omotlaquentzomoni ica icualan huan oquihto: ―¡Otecamanaluic in Dios! Ayacmo ticnequihque in tlachipaucamen. Yonanquicajque quen yoistlacat. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Tlen nanquinehnehuiliyahque? Huan yehhuan oquihtohque: ―Tlahtlacolyo yehhua. Quipiya tlen miquis. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Oncan oteixchihchahuihque huan otehuihhuitejque. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Huan oc sequin oteixtecapanihque huan oteiluihque: ―¡Tehhuatl aquin in Cristo! Xitechilui aquin omitzixtecapani. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ihcuac inon, oyehuatoya quiyahuac in Pedro. Huan se tepaltesqui omopacho inahuac huan oquiluic: ―Tehhuatl noyojqui otinemiyaya ihuan Jesús, yeh den Galilea. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Huan in Pedro oteixtlati inixpa nochten, huan oquihto: ―Ahmo nicaqui tlen tiquihtohtica. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Huan yoquistaya ihcuac oc seya oquitac, huan oquiniluic in aquin ompa ocatcahque: ―Inin tlacatl noyojqui onemiyaya ihuan in Jesús, aquin chani de Nazaret. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Huan oc sepa oteixtlati in Pedro, huan oquihto: ―Ahmo niquixmati inon tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Huan san ic chihton, in aquin ompacaten omopachohque inahuac in Pedro huan oquiluihque: ―Ic nele, tehhuatl noyojqui se de yehhuan. Tleca ijcon titlahtohua tictenuica quen se galileahteco. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Oncan in Pedro opeu tlapacteca huan oquihto: ―Nele Dios ahmo niquixmati inon tlacatl. Huan inon rato otzahtzic in pachilel. ");
INSERT INTO ncjNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Huan oquilnamic in Pedro in tlen omoiluihtoya in Jesús: “Achto ic tzahtzis in pachilel, tehhuatl tinechixtlatis yexpa.” Huan Pedro oquis de ompa huan tequin otlocoltzatzic. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ihcuac otlatuic, nochin in achtohque den tiopixcamen huan in tequihuahten den judeahtecos omosechiuque quen temictisque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Otehuicaque ilpihuatiu huan otetemactihque imajco in Pilato, yeh in tequihua den tlali Judea. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ihcuac inon, in Judas oquimat quen otetlahtlacoltihque mamicohua in Jesús. Yeh in aquin achto otetemacti. Ic inon omoyolcuep ica tlen oquichiu huan oquincuepili in tomin in tlen oquitlaxtlahuihtoyahque inon achtohque den tiopixcamen huan in tequihuahten den judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Huan oquiniluic: ―Nehhua nitlahtlacolantoc ic onitetemacti mamicohua inon tlacatzintli huan ahmo tlen mochiutoc. Huan yehhuan oquinanquilihque: ―Inon ahmo ticpiyahque tlen tiquitasque tehhuan. ¡Inon tehhua motlahtlacol! ");
INSERT INTO ncjNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Oncan Judas oquitohuetzo in tomin tlalpa ipan in tiopantli, huan oya moquechmecaniya. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","In achtohque den tiopixcamen oquipehpenque in tomin huan oquihtohque: ―Ahmo techcahuilihtoc maticnelocan ihuan in tetlocoliltomin, tleca yeh in ipatiu inemilis in tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Oncan omononotzque ic quicohuasque se tlali ica inon tomin. Huan ompa quintocasque in sentlapalchanimen. Inon tlali ocatca ihuaxca se conchiuqui. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Huan ic inon, hasta axan quitocahhuiyahque Tlali den Yestli. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Huan ijcon otzonquis in tlen oquihto yihuehcau in tlayolchicauqui Jeremías: “In tequihuahten den judeahtecos omononotzque ica ipatiu tenemilis yeh in sempohuali huan mahtlactli tomin den plata. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Huan yeh in tlen oquimacaque ica in tlali den conchiuqui, quen onechtequiutilo in Totecohtzin Dios.” ");
INSERT INTO ncjNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Otehuicaque in Jesús iixpa in romanohtequihua itoca Pilato, huan yehhua otetlahtlani: ―¿Mach nele, tehhuatl in hueyixtoc den judeahtecos? Huan in Jesús oquinanquililoc: ―Ijcon quen tehhua otiquihto. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Huan ayacmo tlen omonanquilic, masque tequin oteteluihque inohque achtohque den tiopixcamen huan in tequihuahmen den judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Oncan oteiluic in Pilato: ―¿Tlahmo ticaqui ica nochin tlen quihtohuahque ica tehhuatl? ");
INSERT INTO ncjNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Huan ahmo tlen oquinanquililoc in Jesús. Ijcon quen tel oquimat in romanohtequihua huan ahmo oquimat tlen quihtos. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Huan ipan se tonali de inon pascuahiluitl, in romanohtequihua nochipa quicahcahuas se motzacuani. In tlacamen quihtohuahque aquin yehhua maquiquixtican. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Huan ompa otzactoya seya itoca Barrabás, aquin hueyi itenehualoca. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Huan ihcuac omosentlalihque in tlacamen, oquintlahtlani in Pilato: ―¿Aquinon nanquinequihque nicahcahuas? ¿Maye Barrabás noso yehhua Jesús, aquin quiluiyahque Cristo? ");
INSERT INTO ncjNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ijcon oquintlahtlani in Pilato tleca oquinehnehuili san ica nexicoli inon tiopixcamen otetemactihque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Huan achto de inon, ihcuac ayamo otlantoya inon tlahtoli, in isihuau in Pilato oquititlan seya maquinahuati in Pilato, huan maquiluitiu: “Ahmo ximocalacti ica inon tlacatl tlamelajcan, tleca in tlayohua onimococochtemic ica yehhua. Tequin onechmohmouti cana titlahtlacolanas ica tlen ticchihuilis.” ");
INSERT INTO ncjNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Huan in achtohque den tiopixcamen huan in tequihuahten oquinnetehuiltihque in tlacamen maquitlahtlanican in tla quicahcahuasque in Barrabás huan tla temictisque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","In romanohtequihua oc sepa oquinnotz, huan oquintlahtlani: ―¿Aquin yehhua den inon inehuan nanquinequihque manicahcahua? Huan yehhuan oquinanquilihque: ―Mamocahcahua in Barrabás. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Huan oc sepa oquintlahtlani in Pilato: ―¿Huan tlen nicchihuas ica in Jesús, quiluiyahque in Cristo? Nochten oquinanquilihque: ―¡Maquimictican ipan in cruz! ");
INSERT INTO ncjNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Oncan ocachi oquintlahtlani: ―Tel, ¿tlen ahmo cuali quichiutoc? Huan yehhuan oc sepa ocoutzahtzihque: ―¡Maquimictican ipan in cruz! ");
INSERT INTO ncjNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","In Pilato oquinehnehuili ahhuel quinyolcuepa, tlahmo ocachi quimohsihuiyahque. Ic inon otlatequiuti macuiquilican atl huan yehhua omomahtequi inixpa in tlacamen, quihtohtica: ―Ijquin namechnextiliya ahmo tlen notlahtlacol ic miquis inin cuali tlacatl. Huan nanquimamasque in tlahtlacoli. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Huan nochin tlacamen oquinanquilihque: ―¡Tehhuan huan topiluan ticmamasque inon tlahtlacoli ica in temiquilis! ");
INSERT INTO ncjNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Oncan Pilato oquicahcau in Barrabás huan oquintequiuti in soldados matehuitequican in Jesús huan maquimictican ipan in cruz. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Oncan in soldados romanohtecos otehuicaque in Jesús ipan in cali den tequihuahten, huan oteyehualohque nochin in soldados. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Otetlaquenquixtihque huan otetlaliltihque se ipampijca den hueyixtoc. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Huan otetlaliltihque ipan tetzonteco se corona tlachihchiutli nochin huetztli, huan otemahuiltihque ipan teyecman se tlacotl quixnextiya den hueyixtoc. Oncan omotlancuaquetzque teixpa huan otecamanaluihque, quihtohtihue: ―¡Mahuehcahui tehhua tihueyixtoc den judeahtecos! ");
INSERT INTO ncjNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Noyojqui otechihchahuihque, huan otecuilihque in tlacotl huan otecuahuitejque ica. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Huan ihcuac otlan teca mahuiltiyahque, otequixtilihque inon ipampijca hueyixtoc huan otetlaquentihque. Huan ic inon otehuicahque ic temictisque ipan in cruz. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Huan ihcuac yahtihue ipan ohtli, oquiahsitejque se tlacatl ialtepeu Cirene, huan in itoca Simón. Huan oquitequiutihque maquihuica in cruz den Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Huan ijcon oahsique in itocahyan Gólgota, tlen quihtosnequi Tzontecontlan. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Huan ic ahmo tequin momachilis, otemacaque in vino tlaneloli ihuan chichic pahtli. Huan queman omomachili, in Jesús ahmo omonec monis. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Huan otemasohualtihque ihtech in cruz huan oquieuque in cruz ihtech in tlacoyoctli. Huan in soldados omoxehxeluihque in tetlaquen huan omahuiltihque ica in dados aquin quitlanis sehsen tetlaquen. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Huan omotlahtlalihque tenahuac mateitacan. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Huan oquihcuilohque ipan se cohuitl in tlen ic otemictihque huan oquitlalihque itzoncuac in cruz. Huan oquihto: “Inin tlacatl, yeh in Jesús in hueyixtoc den judeahtecos.” ");
INSERT INTO ncjNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Noyojqui tehuan oquinmasohualtihque ipan in cruz mamiquican in inehuan ichtejcamen, seya ic teyejcan huan in oc seya ic oc se lado. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Huan aquin opanohuayahque ompa otepactecayayahque, huan omocuatzehtzelohque ic teca huetzcahque. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Huan oquihtohque: ―Tehhuatl otiquihto mach cuali ticxitinis in hueyi tiopan huan cuali ticchihchihuas oc sepa ipan yiyi tonali. Tla nele ijconon, cuali timomaquixtiya. Tla nele tehhuatl ticoneu Dios, xitemo ipan in cruz. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ijcon noyojqui teca omahuiltihque in achtohque den tiopixcamen huan in tlamachtiyanimen den itlanahuatil Moisés huan in tequihuahmen den judeahtecos. Omoluihque ic yehhuan: ");
INSERT INTO ncjNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Tla nele oquinmaquixti in oc sequinten, no ijcon cuali momaquixtini. Tla nele yeh in hueyixtoc den tehhuan israeltecos, matemo ipan in cruz huan ijcon nele ticneltocasque. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Omomachiti ica in Dios. Maquimaquixtilo tla nele motlasohtla. Tleca yehhua oquihto mach Iconetzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Huan ijcon noyojqui otecamanaluihque inon ichtejcamen aquin omicticatcahque tehuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Huan ic nepantla otlayohuac ipan in tlali Judea hasta ic yiyi horahtiotlac. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Huan ipan inon hora ocoutzahtzihuac in Jesús ica tetlahtol: ―¡Elí, Elí! ¿lamá sabactani? ―tlen quihtosnequi: Dios nohuaxca, ¿tleca otinechmocahuili? ");
INSERT INTO ncjNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Huan sequin aquin ocatcahque tenahuac otecajque huan oquihtohque: ―Inin tlacatl quinotztica in tlayolchicauqui Elías. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Huan saniman otzecuin seya de yehhuan huan ocualicac se esponja. Yeh in tlen quichichina atl quen tatapahtli. Huan ihcuac oquiasiyau ihtech in chichic vino, oquitlali ipan se acatl. Huan omopacho tenahuac in Jesús huan oquiahcoc in esponja mamochichina. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Huan in oc sequinten oquiluihque: ―Xicahua. Tiquitasque in tla in Elías hualas quimaquixtis. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Oc sepa ocoutzatzihuac chicahuac huan ic inon omicohuac. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Huan ipan inon hora in tatapahtli tlen ic otlahcoxeliutoya in hueyi tiopantli otzomon de tlacpac huan hasta tlatzintla huan ijcon ohomequis. Huan otlaluehueyocac huan otlapanque in tepemen. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Huan omotlapohque sequin tlaltecochten huan oihsaque sequin mijcamen aquin tlaneltocanimen ica in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yehhuan oquisque ihtech in tlaltecochten satepa ihcuac oihxohuac in Jesús. Ocalajque ipan Jerusalén, in altepetl tioxeliutoc, huan omonextihque ica miyacten. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tlatequiutihtoc ica temictilis in Jesús se tlayecanqui romanohteco ihuan in soldados. Ihcuac oquimachilihque queman otlaluehueyocac huan oc sequin tlen opanoc, yehhuan molui omomoutihque huan omoluihque: ―Nele inin tlacatl se iconeu in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Otlachixticatcahque de huehca miyac sihuamen, yehhuan aquin otecuitlapanuiyayahque ihcuac oquixohuac den Galilea huan otetecpanohque. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Inuan yehhuan ocahcatca in María in magdalahteco, huan in María innana in Jacobo huan José, huan noyojqui isihuau in Zebedeo. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ic otlapoyau, oahsico se tlacatl rico itoca José, chani den altepetl Arimatea. Yehhua noyojqui otecuitlapanui in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Huan oya quita in Pilato huan oquitlatlauti maquicahuili quihuicas tetlacayo in Jesús. Ic inon oquintequiuti in Pilato maquimacacan. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","In José oquitemohui tetlacayo ipan cruz huan otepihpiqui ica se tatapahtli yancuic. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Huan otecalaqui ihtech itlaltecoch yehhuatl tlen yiquipiya ipoxtla in tepetl. Oquixtzac ica se hueyi tetl huan oya. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Huan ompa yehyehuatoque iixpa in tlaltecochtli in María in magdalahteco huan in oc se María. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ic mostla, ipan tonali den nesehuilistli, oyahque quitahque in Pilato in achtohque den tiopixcamen huan in fariseos. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Huan oquiluihque: ―Tequihuahtzin, tiquilnamiquisque in tlen oquihto inon tlacahcayauqui Jesús mach ipan yiyi tonali ihsas den mijcamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ic inon mamotequiutican quesqui soldados ic maquixpiyecan inon tlaltecochtli mapano in yiyi tonali. In tlahmo, cana hualasque tlayohua in itlamachticahuan huan quichtequisque in itlacayo. Huan satepa quiniluisque in tlacamen mach: “Oihsac den mijcamen.” Huan tla ijcon, quisas ocachi ahmo cuali inin istlacatilistli quen in achto. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Huan oquiniluic in Pilato: ―Namechuicaltiya se ololi den soldados. Xiyacan namehhuan huan xicyequixtzacuacan in tlaltecochtli quen cuali nanquichihuasque. ");
INSERT INTO ncjNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Oncan oyahque huan oquiyectlalihque in tlaltecochtli. Oquisalohque ica tepalcatl in tetl ic oquitentzajque, manesi tla aquin quitentlapos. Huan omocauque ompa in soldados. ");
INSERT INTO ncjNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ihcuac yopanoc in tonali den nesehuilistli, in María in magdalahteco huan in oc se María oyahque quitahque in tlaltecochtli. Huan ic tlatuihtiu in achto tonali den semana. ");
INSERT INTO ncjNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Huan ohualtemo den neluicac se ángel den Totecohtzin. Huan niman chicahuac otlaluehueyocac tleca ijcon oquiquixti inon tetl ic otentzactoya in tlaltecochtli. Huan in ángel ipan omotlali in tetl. ");
INSERT INTO ncjNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Opetlan chicahuac quen tlapetlantli, huan itlaquen istac quen setl. ");
INSERT INTO ncjNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ic oquitaque in ángel, in soldados ohuehueyocaque ica moucayotl huan omocauque quen mijcamen. ");
INSERT INTO ncjNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Oncan in ángel oquiniluic in sihuamen: ―Ahmo ximomoutican. Nicmati nantetemohuahque in Jesús aquin otemictihque ipan cruz. ");
INSERT INTO ncjNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ayacmo nis ilohuac, tleca oihxohuac, quen omihto. Xihualacan xiquitacan canin otetlalihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Xiyacan niman huan xiquiniluican in tetlamachticahuan yoihxohuac den mijcamen. Huan mechyecanalos ic nanyasque namochten Galilea. Huan ompa nanteitasque. Yeh in tlen nicpiya tlen namechiluiya. ");
INSERT INTO ncjNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Oncan oyahque ihsiu den tlaltecochtli ica moucayotl huan molui pactihue. Ohualtzecuinque technahuatiya tehhuan titetlamachticahuan. ");
INSERT INTO ncjNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Huan ic hualahticaten, omonextiloc in Jesús ica yehhuan huan omotlapalohque. Omopachohque tenahuac huan omotlancuaquetzque huan otexonahuatejque ic otemahuestilihque. ");
INSERT INTO ncjNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Oncan oquiniluiloc: ―Ahmo ximomoutican. Xiyacan xiquinnahuatican notlasohicnihuan mayacan Galilea huan ompa nechitasque. ");
INSERT INTO ncjNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ihcuac yoyahque in sihuamen, sequin den soldados aquin oquixpixticatcahque in tlaltecochtli oyahque ipan in altepetl huan oquinnonotzque in achtohque den tiopixcamen ica nochin tlen opanoc. ");
INSERT INTO ncjNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Inon tiopixcamen oyahque quinitahque in tequihuahmen den judeahtecos huan omosechiuque ica tlen quichihuasque. Ic inon oquinmacaque miyac tomin in soldados. ");
INSERT INTO ncjNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Huan oquiniluihque: ―Namehhuan nanquihtosque mach: “Ohualahque tlayohua in tetlamachticahuan ihcuac ticochtoque huan oquichtejque in itlacayo in Jesús.” ");
INSERT INTO ncjNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Huan tla quicaquis in romanohtequihua quen ijcon onancochtoyahque, tehhuan tictlapolochtisque ic ahmo mechtlapanoltisque. ");
INSERT INTO ncjNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Oncan oquiselihque in tomin inon soldados huan oquichiuque ijcon quen oquintequiutihque. Huan hasta inin tonalten ijcon tlanonotzahque in judeahtecos ica tlen opanoc. ");
INSERT INTO ncjNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ijcon tel, tehhuan in mahtlactli huan se titetlamachticahuan otiyahque Galilea, ipan in tepetl canin in Jesús techiluilohtoc. ");
INSERT INTO ncjNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Huan ihcuac otiteitaque in Jesús, otitemahuestilihque, masque sequin ahcomantihuitzen. Oquinehnehuiliyayahque cana ahmo nele Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Oncan omopacholo in Jesús huan otechiluihque: ―Nechmacalohtoc nochin tequihuahyotl manitlatequiuti ipan in neluicac huan ipan in tlalticpac. ");
INSERT INTO ncjNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Xiyacan tel, huan xiquinnonotzacan nochin tlacamen den tlalticpac mamochihuacan notlamachticahuan. Huan xiquincuatequican ica in tequihuahyotl den Tohueyitahtzin huan nehhuatl in Iconetzin huan in Itiotonaltzin. ");
INSERT INTO ncjNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Huan xiquinnextilican quen tetlacamatisque nochin tlen namechtequiutihtoc. Huan ahmo xiquilcahuacan nehhua namohuan niyes nochin tonali, hasta ic tlamis in tlalticpactli.");
INSERT INTO ncjNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ojcon opeu in yancuic tlahtoli ica Jesucristo, teconeu in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Opeu quen oquihcuiloc se tlayolchicauqui ica in Itlahcuiloltzin Dios itoca Isaías. Molui achto oquihcuiloc ihtech in Itlahcuiloltzin Dios tlen omihto in Dios ica inin tonali: Xicmocaquiti; neh nictitlanis notlanahuatil matlicana de tehhuatl. Yeh in aquin quinnahuatis in tlacamen mamitzselican. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Quicaquisque quen quihtohtas inon tlanahuatili ipan in acahualtlahtli: “Hualuilohuas Totecohtzin. Ximoyectlalican ica namoyolo ic nanteselisque, ijcon quen nanquiyectlalisque in ohtli ic hualahxihuas in Totequihuatzin.” ");
INSERT INTO ncjNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ijcon inon tlanahuatiyani itoca Juan ohualtlacuatequihtaya ipan in acahualtlahtli, huan ohualtlanonotztaya: ―Ximoyolcuepacan ica Dios mamechtlapohpoluican namotlahtlacol huan namechcuatequis. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Huan oyahque quitahque inon Juan de nochin altepemen den tlali Judea huan in hueyi altepetl Jerusalén. Huan yehhuan omoyoluitihque ica intlahtlacol huan Juan oquincuatequi ihtech in atentli itoca Jordán. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Huan in Juan oquipiyaya itlaquen tlachihchiutli den itohmiyo in hueyi yolcatl itoca camello, huan se itlahcolpica den cuitlaxtli. Huan oquicuaya se chopili quen nesi tzicatl ica in nectli den panatl. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Huan otlanonotzayaya: ―Satepa de nehhuatl hualuilohuas seya aquin ocachi mopiya tequihuahyotl quen nehhuatl. Neh ahmo tlen noquisca ic nimochihua nitlapalehuiyani. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nehhuatl san onamechcuatequi ica atl, huan Yehhuatzin mechmacalos in Itiotonaltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ojcon opanoc inon tonalten, ihcuac ohualuilohuac in Jesús den tealtepeu Nazaret den tlali Galilea, huan in Juan otecuatequi in Jesús ipan in atentli itoca Jordán. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Huan queman oquixohuac den atl, niman omotac quen mihcuaniya in mextli huan ohualtemoc den neluicac in Itiotonaltzin in Dios quen huilotl, huan oteahsico in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Huan omocac in Jesús se tlahtoli den neluicac tlen otlanahuatic: ―Tehhuatl tinoconeu nimitztlasohtla huan nipaqui ica tehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ihcuac inon in Itiotonaltzin in Dios otetitlan in Jesús ipan in acahualtlahtli, ");
INSERT INTO ncjNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","huan oilohuaya nepa ompohuali tonali. Huan omopacho tenahuac in ahmo cuali tlacatl huan nochin inon ompohuali tonali oteyoltilanticatca ic tecuepani ahmo cuali in Jesús. Oilohuaya ihuan in tecuanyolcamen huan in ángeles otetequipanohque. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Satepa de ihcuac oquitzajque in Juan, ohualuilohuac in Jesús ipan in tlali Galilea, tlanonotzalohtiu in itlahtoltzin in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Huan oquinmoluilic: ―Ayacmo huehcau queman Dios pehualo quintequiutilo in tlacamen. Ximoyolcuepacan huan xicneltocacan in yancuic tlahtoli. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Huan queman Jesús opanoloc inahuac in hueyi atl itoca Galilea, oquinitaloc Simón ihuan icniu Andrés. Quitlastinemihque in matlatl ihtech in hueyi atl, tleca yehhuan michtemohuanimen. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Huan Jesús oquiniluiloc: ―Nancanahtohque in michten huan axan xinechcuitlapanuican huan nanquinanatihue in tlacamen manechneltocacan. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Saniman oquicauque inmatlau huan otecuitlapanuihque. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Huan queman Jesús opanoloc de ompa, oquinitaloc in Jacobo ihuan icniu Juan, iconehuan Zebedeo. Ocatcahque ihuan oc sequinten ihtech in barco huan oquitlahtlamanilihtoyahque inmatlau. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Huan saniman in Jesús oquinnotzaloc, oquicauque intata ipan in barco ihuan in tlaquehualten, huan otecuitlapanuihque Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Huan oahsitohque tehuan Jesús ipan in altepetl Capernaum ipan in tonali den nesehuilistli den judeahtecos. Inuan ocalacohuac ihtech in tiopantli huan oquinnextililohuaya in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Huan otehuelitaque ica tlen oquinnextililoc, tleca oquinnextililoc quen aquin quipiya tequihuahyotl huan ahmo quen in tlamachtiyanimen ica itlanahuatil in Moisés. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Huan ocatca ipan in tiopantli se tlacatl aquin quiquitzquihtoc se ahmo cuali yehyecatl. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Yehhuatl otzahtzic: ―¿Tlen ticpiya tiquitas ica tehhuan, Jesús de Nazaret? Cox, ¿otihuala ic titechpolos? Nimitzixmati aquin tehhuatl. Tehhuatl titetlapehpenil in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Huan in Jesús omotlacahualti: ―¡Ximocahua huan xiquisa de yehhuatl! ");
INSERT INTO ncjNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Huan in ahmo cuali yehyecatl oquicuehcuelo chicahuac in tlacatl, huan otzahtzic huan oquis de yehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Huan nochten quen tel oquimatque huan ic yehhuan omotlahtlanihque: ―¿Tlen inin? ¡Se yancuic tlanehnehuilistli! Ica tequihuahyotl quintequiutiya masque in ahmo cuali yehyecamen huan tetlacamatihque. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Huan molui ihsiucan oquimatque ica tetenehualoca in Jesús ipan nochin tlali den Galilea. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Huan queman oquixohuac ihtech in tiopantli, otehuicaque ichan Simón huan Andrés. Tehuan oyahque in Jacobo huan Juan. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Huan imonantzin Simón ohuetztoya ica totonqui huan niman otenahuatihque in Jesús ica yehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Huan ohuilohuac mota huan omomaquitzqui ic omeu, huan saniman oquis in totonqui huan in sihuatl oquintlamacac. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ihcuac yomotocaloc in tonaltzintli, otehualiquilihque nochten in cocoxcamen huan in aquin quipiyahque in ahmo cuali yehyecatl. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Huan nochten den altepetl omosentlalihque caltenco. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Huan omopahtihque inohque cocoxcamen ica miyac cocolisten, huan omoquixtilihque in ahmo cuali yehyecatl. Huan ahmo oquincahualoc matlahtocan, tleca oteixmatiyayahque huan Yehhuatzin ahmo omonec tlen maquiniluican in tlacamen ica Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ic mostla huehca sancuel, in Jesús omehualoc huan ohuilohuac ipan in acahualtlahtli huan ompa omoyolmachtiloc. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón ihuan oc sequinten oyahque tetemohuahque. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Huan queman oteahsique, oteiluihque: ―Nochten tetemohuahque. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesús omoluihque: ―Tiohue ipan oc sequin altepemen huan ompa nitlanonotzas noyojqui, tleca ic inon onihuala. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Huan quinonotzalohtiu ihtech in tiopanten den judeahtecos ipan nochin tlali Galilea, huan quinquixtililo in ahmo cuali yehyecamen. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ohuala teita Jesús se tlacatl aquin opalanticatca inacayo. Yehhua omotlancuaquetz ic otetlatlautic: ―¿Tlen, ahmo ticmonequiltis nechpahtilos? ");
INSERT INTO ncjNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús ica otlocoyaloc huan omotlalili teman, huan omoluic: ―Tleca in tlahmo. Xipahti. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Huan queman omoluic inon, oquis icocolis in tlacatl huan cuali omocau. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Huan oquitequiutiloc: ");
INSERT INTO ncjNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Ahmo xitlanonotza tlen onimitzchihuilic, huan xiyau xicmonextili in tiopixqui huan xictlocoli itetlocolil in tlen Moisés oquitequiuti, tleca yotipahtic. Ic inon quimatiltis in tlacamen yotipahtic. Huan ic inon oquititlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Huan ihcuac oquis in tlacatl, opeu tlahuel tlanonotza, huan oquiniluic nochin tlen opanoc. Ijcon in Jesús ayacuel ocalacohuayaya ipan niyan se altepetl tlahmo san ichtaca. Huan onemohuayaya ipan in acahualtlahtli huan oyahque teitahque de nochin altepemen. ");
INSERT INTO ncjNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Satepa de sequin tonali in Jesús oc sepa omocuepaloc ihtech in altepetl Capernaum, huan in tlacamen oquimatque Yehhuatzin oilohuaya techan. ");
INSERT INTO ncjNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Huan omosentlalihque miyacten, hasta ayacmo oyehuiyayahque niyan caltenco, huan oquinnonotzaloc ica itlahtoltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nahue tlacamen ocualmamahque seya aquin omocoupitzquetzticatca. ");
INSERT INTO ncjNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Huan quen ahhuel otehuiquilihque in Jesús tleca ocatcahque miyac tlacamen, oquicuatlapohque in cali ic tetzoncuac in Jesús canin oilohuaya. Huan ompic oquitemohuihque inon cocoxqui. ");
INSERT INTO ncjNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesús omonehnehuilic quen oteneltocaque huan omoluic inon cocoxqui: ―Notlasohicniu, nochin motlahtlacol nimitztlapohpoluihtoc. ");
INSERT INTO ncjNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Huan sequin tlamachtiyanimen ica itlanahuatil in Moisés ompa oyehuatoyahque, huan oquiyolnehnehuilihque: ");
INSERT INTO ncjNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ahmo quihtosquiyani ijconon. San istlacati ica in Dios. Tleca niyan aquin cuali quitlahtlapoluis itlahtlacol in tlahmo san Yehhuatzin in Dios.” ");
INSERT INTO ncjNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Huan in Jesús omoyolnehnehuili tlen oquiyolnehnehuilihque inon tlamachtiyanimen, huan oquintlahtlaniloc: ―¿Tleca nanquiyolnehnehuiliyahque nehhua niistlacatqui ica in Dios? ");
INSERT INTO ncjNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Quen nanquimatihque in tlahmo nicpiya tequihuahyotl ic nictlapohpoluis itlahtlacol? In tla nicpahtis inin cocoxqui queman niquiluis: “Ximehua, xicana motlapech, huan xiyau mochan”, ");
INSERT INTO ncjNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ijcon nanquimatisque in tla nehhuatl aquin Nitetiachicau ica nochin tlacatl cuali nictlapohpoluis itlahtlacol. Ijcon oquiluiloc in cocoxqui: ");
INSERT INTO ncjNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Ximehua, xicana motlapech, huan xiyau mochan. ");
INSERT INTO ncjNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ihcuac omihto inon, omeu in cocoxqui, huan oquian itlapech, huan oquis inixpa nochten. Huan ic inon quen tel oquimatque huan otemahuestilihque in Dios, huan oquihtohque: ―Ahyic queman tiquitztoque ijcon mochihua. ");
INSERT INTO ncjNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesús ohuilohuac oc sepa itentla in hueyi atl, huan nochten in tlacamen omosentlalihque tenahuac huan oquinnextililoc. ");
INSERT INTO ncjNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ihcuac panolohtiu, in Jesús oquitaloc in Leví, iconeu in Alfeo, yehuatica inahuac imesa campa quitlaxtlahuahque in renta. Huan Jesús omoluic: ―¡Xinechcuitlapanui! Ijcon omoquetz huan otecuitlapanuic. ");
INSERT INTO ncjNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Satepa ichan in Leví ocatcahque miyac renderos huan oc sequinten tlahtlacolyohque. Tehuan otlacuahtoyahque in Jesús ihuan in tetlamachticahuan. Tleca ocatcahque miyac yehhuan aquin otecuitlapanuihtinemiyayahque. ");
INSERT INTO ncjNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Queman oteitaque in tlamachtiyanimen den itlanahuatil in Moisés, yehhuan in fariseos, quen otlacualotoya in Jesús ihuan inon tlahtlacolyohque, oquintlahtlanihque in tetlamachticahuan: ―¿Tleca tlacuatoc ihuan in renderos huan in tlahtlacolyohque? ");
INSERT INTO ncjNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Oquincaquiloc in Jesús, huan oquiniluiloc: ―Nehhua quen se tlapahtiyani. In aquin quinehnehuili chicahuac ahmo quinequis in tlapahtiyani, tlahmo san yeh in cocoxqui. Ic inon ahmo onihuala niquimpalehuis in yolcualten, in tlahmo san ica in tlahtlacolyohque. ");
INSERT INTO ncjNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Huan in itlamachticahuan in Juan Tlacuatequiyani huan intlamachticahuan den fariseos omosautoyahque ihcuac moyolmachtiyayahque quemaniyan semiluitl. Huan ohualahque sequin huan otetlahtlanihque in Jesús: ―¿Tleca in itlamachticahuan in Juan huan yehhuan den fariseos mosautohque, huan in tehuaxcahuan ahmo? ");
INSERT INTO ncjNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Huan Jesús oquinnanquililoc: ―Nehhuatl quen se mosihuautiyani. ¿Tlen, in itlatlautiluan in mosihuautiyani cuali mosahuasque ihcuac inuan yes? Nele ahhuel mosahuasque tleca pacticaten ihcuac ompayesque san secnin. Ijcon quen ica nehhuatl huan inin notlamachticahuan. ");
INSERT INTO ncjNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Huan hualas tonali queman quincuilisque in mosihuautiyani. Ihcuac inon mosahuasque. ");
INSERT INTO ncjNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ijcon omihto Jesús ica yancuic tetlanehnehuilis: ―Niyan aquin ijcon quitlatlamanis se tlaquemitl tlen yihuehcau ica in yancuic tatapahtli. Tla ijcon quichihuas, in tlatlamanilistli ihsiu tzomonis ic cocotzahuis in yancuic tatapahtli. ");
INSERT INTO ncjNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Noyojqui niyan aquin quitlaxilis in vino ayamo chicahuac ihtech in cuitlaxtli yihuehcau. Tla ijcon quichihuas, inon vino quitzomonis in cuitlaxtli, huan ijcon polihuis in vino huan in cuitlaxtli. Huan in vino ayamo chicahuac quiehuasquiyani ihtech in yancuic cuitlaxtli. Ijcon noyojqui notlanehnehuilis yancuic ahmo quinamiquis ica intlamachilis yihuehcau. ");
INSERT INTO ncjNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Se tonali den nesehuilistli den judeahtecos quipanahuiticaten Jesús ihuan in tetlamachticahuan ihtech se trigohmili. Huan in tetlamachticahuan quitectihue in trigo. ");
INSERT INTO ncjNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Huan inon fariseos otetlahtlanihque in Jesús: ―Xiquita, ¿tleca quichihuahque tequitl ahmo quincahuilihtoc ipan tonali den nesehuilistli? ");
INSERT INTO ncjNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","In Jesús oquintlahtlaniloc: ―Cox, ¿ahmo nanquipoutoque tlen oquichiu in hueyixtoc David? Inon tonali oapismic huan noyojqui oapismique yehhuan icompañeros. ");
INSERT INTO ncjNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Huan in David ocalac ihtech in tiopantli queman ocatca achto tiopixqui in Abiatar. Oquian in pantzin tlen itlalnamictiltzin Dios, huan oquicua ihuan aquin oyahyaya, masque ahmo oquincahuilihque niyan aquin maquicuacan, in tlahmo san in tiopixcamen quicuasque. Huan ahmo oquitlahtlacoltiloc in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Noyojqui namechiluiya in tonali den nesehuilistli quipalehuisquiyani in tlacamen. Ahmo maye molui tequiyo maquitlacamatican in tlanahuatili den tonali den nesehuilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ijcon, nehhuatl aquin Nitetiachicau ica nochin tlacatl noyojqui nicpiya tequihuahyotl ic niquihtos tlen cuali quichihuasque ipan tonali den nesehuilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Oc sepa Jesús ocalacohuac ipan in tiopantli den judeahtecos. Huan ocatca se tlacatl oquipiyaya se iman huajqui. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Huan in tlacamen nepa oquichixtoyahque tla quipahtilos ipan in tonali den nesehuilistli, ijcon teteluisquiyanihque. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Huan Jesús omoluic in tlacatl aquin oquipiyaya iman huajqui: ―¡Xihualau nisic! ");
INSERT INTO ncjNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Huan Jesús oquintlahtlaniloc: ―¿Tlen cox ocachi cuali; mochihuas cuali ipan in tonali den nesehuilistli, noso mochihuas ahmo cuali? Cox, ¿ticchihuasque nochin tlen cuali mapahti, noso ticahuasque mamiqui? Huan omocauque san tlamach inon tequihuahmen. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesús oquincualanitaloc, otlocoxticatca tleca oyoltepitzauque, huan oquiluiloc in tlacatl: ―Ximasohua. Ihcuac omasou, in iman opahtic. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Oquisque in fariseos huan saniman ocualsematque ihuan in aquin omoquetzayayahque ihuan in tequihua Herodes quen temictisque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Oncan Jesús ohuilohuac itentla in hueyi atl inuan in tetlamachticahuan. Huan otecuitlapanuihque miyac tlacatl den tlali Galilea. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Noyojqui ohualahque teitahque miyacten den tlali Judea, huan den hueyi altepetl Jerusalén, huan den tlali Idumea den oc se itentla den atentli Jordán, huan itlatilanal den altepemen Tiro huan Sidón. Oyahque teitahque queman oquicajque tlen tequin cualtzin omochihuayaya. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Huan Jesús omonehnehuili cana tepitzinisquiyanihque huan ic inon oquintequiutiloc in tetlamachticahuan maquiyectlalican se barquito. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Tleca miyac yomopahtihque ijcon quen sequin cocoxcamen moixtopeutihue ic temachilisque. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Huan queman oteitayayahque in Jesús, yehhuan aquin oquipiyayahque in ahmo cuali yehyecamen ohuetziyayahque teixpa huan otzahtziyayahque, quihtohtihue: ―Tehhuatl ticoneu Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Huan Yehhuatzin oquintlacahualtiloc ahmo maquiniluican aquin Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Huan otlehcoloc Jesús ipan se tepetl huan oquinnotzaloc yehhuan aquin oquinnequiloc huan oteahsitohque. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Huan oquintlapehpeniloc in mahtlactli huan ome ic tehuan nemisquiyanihque, huan yehhuan quintitlanilos matlanonotzacan. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Huan oquinmacaloc tequihuahyotl ic quixtohuetzosque in ahmo cuali yehyecamen. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Inihque aquin oquintocahhuiloc Simón aquin noyojqui oquitocahhuiloc Pedro, ");
INSERT INTO ncjNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","huan Jacobo huan icniu Juan, iconehuan in Zebedeo. Yehhuan oquintocahhuiloc Boanerges, tlen quihtosnequi tlacamen chihchicahuahque quen tlatecuinilotl. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Noyojqui oquintlapehpeniloc Andrés huan Felipe huan Bartolomé huan Mateo huan Tomás huan Jacobo iconeu in Alfeo. Noyojqui oquintlapehpeniloc Tadeo huan Simón in aquin ihuan omoquetz in cananistas, ");
INSERT INTO ncjNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","huan Judas Iscariote, yehhuatl aquin otetemacti. Huan queman otlan quintlapehpenilo, ohuilohuac ichantzin. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Huan oc sepa omosentlalihque in tlacamen, huan ahmo otecauque matlacualo in Jesús ihuan in tetlamachticahuan. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Huan queman techanihcahuan oquicajque inon, ohualahque tehuicasquiyanihque, tleca oquihtohuayahque: ―Yoixpoliu. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Huan in tlamachtiyanimen den itlanahuatil Moisés aquin oahsicohque den hueyi altepetl Jerusalén oquihtohuayahque: ―Tequiti ica in ahmo cuali yehyecatl itoca Beelzebú, huan ica in ichicahualis inon tiachicau den ahmo cuali yehyecamen quinixtohuetzohua in oc sequin ahmo cuali yehyecamen. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Huan Jesús oquinnotzaloc huan oquinnextililoc ahmo cuali intlahtol. Oquinmoluilic: ―In Satanás ahhuel quinixtohuetzohua in ihuaxcahuan yehyecamen. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tla in tlacamen den hueyi tlali motehuiyahque se huan oc seya, inon tlacamen ahhuel tlaixnamiquisque ica in oc sequinten. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Huan tla aquin chantitoque ihtech se cali tlahco xeliutoc, inon ichanihcahuan ahhuel huehcahuisque. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Huan tla Satanás quitehuiya ica ichanihcahuan huan motlahcoxelos, ahhuel yetos, tleca ayacuel quintlacamatiltis quen ayacmo chicahuac. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Nanquihtohuahque nicpalehuis in Satanás, huan nele onictlan, tleca yehhua molui chicahuac huan niyan aquin cuali calaquis ichan maquipolos in tlahmo achto quitlanis. Huan queman yoquitlan, cuali quintlacamatiltis nochin aquin ompacaten. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Ic nele namechiluiya, nochin tlahtlacolten huan camanalten ica Dios quintlapohpoluisque in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Huan san aquin quicamanaliluis in Itiotonaltzin Dios ayacmo queman quitlapohpoluisque. Inon tlahtlacolantoc nochipa. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ojcon omihto in Jesús tleca oquihtohuayahque: ―Tequiti ica ichicahualis in ahmo cuali yehyecatl, huan ahmo ica techicahualis den Itiotonaltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ohualahque tecnihuan in Jesús huan tenana, huan omoquetzque caltenco huan oquititlanque tlanahuatili ic mahualquixohua. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Huan in tlacamen aquin oyehuatoyahque tenahuac in Jesús oteiluihque: ―Xiquita, monantzin ihuan mocnihuan ompacaten caltenco tlahtlanticaten ica Tehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Huan oquinitaloc aquin oyehuatoyahque tenahuac huan oquinnanquililoc: ―Nele yehhuan nonana huan nocnihuan. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Huan inihque noyojqui quen nonana huan nocnihuan. ");
INSERT INTO ncjNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","San aquin quichihuas in tlen monequis in Dios, yehhuan quen nocnihuan, huan nohueltihuan, huan nonana. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Oc sepa opehualoc in Jesús quinnextililo ipan itentla in hueyi atl, huan ohualahque teitahque molui miyac tlacamen. Jesús ocalacohuac ipan se barco huan omotlaliloc ihtech in barco chihton huehca den itentla in hueyi atl, huan nochin tlacamen ocatcahque atlatentli. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Huan oquinnextililohuaya miyac tlamantli san ica in tlalnamictilistli, huan oquiniluiloc: ");
INSERT INTO ncjNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Xicaquican, se tlacatl oquis quichayahua in xinachtli. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Huan sajcon oquichayautinemiyaya, sequin xinachtli ohuetz ipan in ohtli huan ohualahque in totomen huan oquicuahque. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Huan oc sequin ohuetz ipan tepetlatl huan niman oixuac, tleca ahmo oquipiyaya tlali huehcatla. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Huan ihcuac chicahuac otonac, ohuac inon tlatoctli, tleca ahmo oquipix hueyac ineluayo. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Oc sequin ohuetz canin ocatca in huetztli, huan oyol in huetztli huan oquixolonalti, huan ahmo oquitlali itlaquilyo. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Oc sequin ohuetz ipan cuali tlali, huan oyol huan oquitlali itlaquilyo. Huan oquitemacac se lado ipan se acali oquis sempohuali huan mahtlactli, huan in oc se lado oquitemacac yehpohuali, huan oc se lado oquitemacac se carga ipan se acali. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Huan ocachi oquiniluiloc in Jesús: ―Aquin quipiya inacas ic quicaquis, maquicaqui. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Huan ihcuac omocahualoc inuan aquin ocatcahque tenahuac huan in mahtlactli huan ome tetlamachticahuan, otetlahtlanihque ica in tlalnamictilistli: ―Axan matechiluican tlen quihtosnequi inon tlalnamictilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Huan oquiniluiloc: ―Dios omechmacaloc quen nanquinehnehuilisque tlen ocatca tlatiutoc ica tetlatequiutilistzin Dios, huan in oc sequinten quicaquisque nochin tlamantli ica tlalnamictilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ijcon ca ihcuac quitzticaten huan quicacticaten, ahmo maquinehnehuilican. Ic inon ahmo mamoyolpatlacan huan Dios quintlapohpoluilos. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Huan ocachi oquiniluiloc: ―Namechyequiluiya tlen quihtosnequi inin tlalnamictilistli tleca in tlahmo nanquinehnehuilisque axan, ahhuel nanquinehnehuilisque in oc sequin tlalnamictilisten. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","In xinachtli tlen quichayahua in tlacatl yeh in quen in itlahtoltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ica sequin tlacamen quimpanotica quen in xinachtli tlen ohuetz ipan inon ohtli. Queman quicaquihque itlahtoltzin Dios niman huitz in Satanás, yeh in ahmo cuali tlacatl, huan quincuiliya in itlahtoltzin Dios tlen oquicajque. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ica in oc sequin tlacamen quimpanotica quen in xinachtli tlen oquitocaque ipan in tetlahtli. Inohque quicaquihque huan quiseliyahque in itlahtoltzin Dios ica paquilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Inohque quimpanohua quen ihcuac huitz in tetzahuitl noso tlamohsihuilistli ipampa itlahtoltzin Dios. Yehhuan motzecohuahque tleca caten quen in toctli tlen ahmo hueyi ineluayo huan niman huaqui. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Huan in xinachtli tlen oquitocaque ipan huetztli, inon quen yehhuan aquin quicaquihque in itlahtoltzin Dios, ");
INSERT INTO ncjNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","huan oquichiuque cuenta ica in miyac tlamantli de inin tonali huan in ricohyotl quincahcayahua huan opeu quinequihque oc sequin tlamanten. Huan nochipa inon tlamantli calaqui huan quixpanahuiya in itlahtoltzin Dios, huan quisa san tlaluis. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Huan in xinachtli tlen oquitocaque ipan cuali tlali, inohque quen yehhuan aquin quicaquihque in itlahtoltzin Dios huan quiseliyahque, huan mochihuahque molui cuali. Yehhuan quisahque quen inon tlatocten tlen seya quitlaliya sempohuali huan mahtlactli, huan oc seya quitlaliya yehpohuali, huan oc seya se carga. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Huan oquiniluiloc in Jesús: ―Niyan aquin quitlalis in candil itzintla in comitl noso itzintla in tlapechtli. In tlahmo quitlalis ipan in mesa matlanexti ipan in cali. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Satepa quinehnehuilisque in tlen axan motlatitoc ica tlalnamictilistli, huan in tlen ahmo quimatihque axan, inon tonali quimatisque nochin. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Aquin quicaquis, maquinehnehuili. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Noyojqui oquiniluilohuaya: ―Xicchihuacan cuenta tlen nanquicaquisque. In tlahmo nanquichihuaque cuenta, san chihton nanquinehnehuilisque, huan tla nanquicaquisque yec, nanquinehnehuilisque ocachi, hasta nochin. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tleca in aquin nele quicaquis, ocachi quinehnehuilis, huan in aquin ayacmo quinequi quicaquis, quilcahuas in chihton tlen oquinehnehuilic. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","In tlatequiutilistzin Dios quen se tlacatl aquin quitoca in xinachtli ipan in tlali. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Huan cochis tlayohua huan mehuas sancuel huan in xinachtli ixua huan yoli quen yehhua ahmo quinehnehuiliya. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tleca in xinachtli ixuas isel ipan in tlali, achto quitlalis ixiuyo, oncan ixochiyo, huan satepa itlaquilyo tentica ipan icacauyo. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Queman yichicahuac, yehhuatl quitzintequi, tleca yoahsico in tlatequilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Huan omihto: ―Nicnequi namechnextilis quen ca tetlatequiutilistzin in Dios, huan ic inon namechiluis ica se tlalnamictilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Pehuas quen in xinachtli den mostaza. Queman motocas ipan in tlali, yehhua in ocachi quitzinihto den nochin xinachtli tlen ca ipan in tlalticpactli. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Huan queman ixua, yolis huan mochihuas ocachi hueyi de nochin sahsal, huan momahxalyotiya hueyac, huan ijcon in totomen cuali mochantiyahque ihtech imaxiuyo. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Huan Jesús oquinnotzalohuaya in tlacamen ica miyac tlalnamictilistli quen inon, ojcon quen cuali quinehnehuilisque. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","In tlahmo ica tlalnamictilistli, ahmo oquinnotzalohuaya. Huan queman inuan omocahualoc in tetlamachticahuan, oquinyequiluiloc nochin in tlalnamictilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Huan inon tiotlactli Jesús oquiniluiloc in tetlamachticahuan: ―Tiyohue tipano ic sentlapal den hueyi atl. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Huan oquincauque in miyac tlacamen huan in tetlamachticahuan otehuicaque Jesús ihtech inon barco ijcon quen yohuilohuaya, huan noyojqui otecuitlapanuihque oc sequin barcos. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Huan opeu yehyeca chicahuac, huan in atl ocalac ihtech in barco, huan ijcon atemisquiyani. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Huan Jesús ocochihuatoya ic inacastla in barco ipan tecuapehpech. Huan oteihxitihque in tetlamachticahuan huan oteiluihque: ―¡Tlamachtiyani! ¿Tlen cox, ahmo mochihuas cuenta tla tipolihuisque? ");
INSERT INTO ncjNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Huan oihxohuac huan oquitlacahualtiloc in yehyecatl, huan omoluic in hueyi atl: ―¡Ximocahua huan ximosehui! Huan in yehyecatl omosehuic huan tlamach omocau in atl. ");
INSERT INTO ncjNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Huan Jesús oquintlahtlaniloc: ―¿Tleca onanmomoutihque? ¿Tlen, ayamo nanquineltocahque quen techuelitalos in Dios? ");
INSERT INTO ncjNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Huan temoute omomoutihque huan omoluihque se huan oc seya: ―¿Tlenon tequisca inin tlacatl, masque in yehyecatl huan in hueyi atl tetlacamatihque? ");
INSERT INTO ncjNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Oahsitohque ic oc se itentla in hueyi atl, ipan in tlali canin chantitoque in gadarenos. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Huan queman Jesús oquixohuac ipan in barco, ohuala tenamiqui se tlacatl aquin ochantiyaya ipan in camposanto. Huan quiquitzquihtoc in ahmo cuali yehyecatl. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Huan ic inon ayacuel aquin oquilpiyaya niyan ica cadenas. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tleca miyacpa oquilpihque ica in cadena, huan yehhuatl oquicohcotonayaya in cadena huan ayacmo otetlacamatiyaya. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Quen tlahca huan quen tlayohua ocatca ihtech in camposanto huan ihtech in coutlahtli, otzahtzitinemiyaya huan omococohtinemiyaya ica tetl san isel. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Queman oteitac Jesús de huehca, ohualtzecuin huan omotlancuaquetz teicxitla. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ocoutzahtzic chicahuac: ―¿Tlen ticpiya tiquitas nohuan, Jesús titeconetzin Dios tlen ilohuac huehcapa? Nele Dios nimitztlatlautiya ahmo xinechmohsihui. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ijcon oquiluic tleca Jesús yomoluihtoya: ―¡Ahmo cuali yehyecatl, xiquisa de ipan inin tlacatl! ");
INSERT INTO ncjNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Huan Jesús oquitlahtlaniloc: ―¿Tlen motoca? Huan yehhua otenanquilic: ―Notoca Ololi, tleca tlahuel timiyacten yehyecamen. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Huan in yehyecatl otetlatlautic molui: ―Ahmo xitechtitlani huehca de inin tlali. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Huan ocatca ompa se hueyi ololi de pitzomen, tlacuahtinemihque ipan in tlachquili. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Huan in ahmo cuali yehyecamen otetlatlautihque in Jesús, teiluitihue: ―Xitechualtitlanili ica in pitzomen; xitechcahuili maticalaquican ihtech yehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yehhuatzin oquincahuililoc, huan oquisque in ahmo cuali yehyecamen, huan ocalajque ihtech in pitzomen. Huan in ololi den pitzomen cana de ome mil, oquinmohmoutihque huan ixtomamictihue ipan in hueyi atl huan omelsinque. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Inon tlixpiyanimen ocholohque huan otlanahuatihque ihtech in altepetl huan nohuiyan. Huan ohualahque inon tlacamen ic quitasque tlen opanoc. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Huan oteahsicohque in Jesús, huan oquitaque in aquin oquipiyaya in miyac ahmo cuali yehyecatl. Oyehuatoya huan otlaquentitoya, huan yoquipiyaya itlanehnehuilis. Ic inon temoute omomoutihque. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Huan inohque tlixpiyanimen aquin oquitaque, otlanonotzque in tlen oquipanoc in aquin oquiquitzquihtoya in ahmo cuali yehyecatl, huan noyojqui ica tlen opanoc ica in pitzomen. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ihcuac inon otetlatlautihque in Jesús mahuilohua huehca de nepa. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Huan queman Jesús ocalacohuac ipan in barco, inon aquin oquiquitzquihtoya in ahmo cuali yehyecamen otetlatlauti mamohuica. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Huan in Jesús ahmo omonec, huan omoluic: ―Xiyau mochan, huan xiquinnonotza motenonotzcahuan nochin tlen omitzchihuilihque in Dios mopampa, huan quen moca otlocoyaloc. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Huan yehhuatl oya huan opeu tlanonotza ipan in tlali canin ocatcahque mahtlactli altepemen, nochin tlen Jesús oquichihuililoc ica yehhuatl, huan nochten quen tel oquimatque. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Huan queman Jesús opanoloc oc sepa ipan barco ic oc se itentla in hueyi atl, omosentlalihque miyac tlacamen atlatentli. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ihcuac inon oteitaco in Jesús se tequihua den tiopantli den judeahtecos, itoca Jairo. Huan queman oteitac in Jesús, omotlancuaquetz teicxitla. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Huan temoute otetlatlautic: ―Nochpocau tlahuel mococohua. Mahualuilohua huan mamotlali teman ipan yehhua, huan mapahti. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Huan Jesús ihuan ohuilohuac. Huan otecuitlapanuihque miyac tlacamen huan otepitzinihtayahque ipan in ohtli. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Huan ocatca se sihuatl yimahtlactli huan ome xihuitl oxitiniyaya ica in iyes. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Huan opanoc imajco miyac tlapahtiyanimen, hasta yoquitlamic nochin tlen oquipiyaya. Huan ahmo tlen oquinamic, huan ocachi molui ocatca. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Oquimat tlen cuali omochihuayaya in Jesús huan omopachoc tecuitlapa campa otentoyahque miyac tlacamen maquiquitzqui tetatapa. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Tleca oquiyolnehnehuilic: “Tla nitequitzquilis san yeh tetlaquen, nipahtis.” ");
INSERT INTO ncjNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Huan otequitzquilic tetatapa huan saniman omosehui ic oxitiniyaya ica iyes, huan yehhuatl oquimachilic in itlacayo yopahtic. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Queman ojcon oquichiu in sihuatl, in Jesús omomat quen seya oquicuic techicahualis. Omocuitlapantlachiyaliloc huan oquintlahtlaniloc: ―Tel, ¿aquin oquimachilic notlaquen? ");
INSERT INTO ncjNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","In tetlamachticahuan oteiluihque: ―¿Tleca techtlahtlanilo aquin otemachilic? Cuali mota quen in miyac tlacamen tepitzinihtihue. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Huan Yehhuatzin tlachiyalohtica nohuiyan ic momatis aquin oquichiu inon. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Huan omomoutic in sihuatl huan ohuehueyocatoya tleca oquimat tlen opanoc ihtech yehhuatl. Huan omotlancuaquetz teixpa in Jesús, huan oteiluic nochin tlen opanoc. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Huan Jesús oquiluiloc: ―Notlasohicniu, otipahtic tleca oticneltocac. Xiyau huan ximoyolsehui, tleca otimocau chicahuac ica mococolis. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ihcuac oc tlahtoloticatca, ohualahque sequin den inon tequihua den tiopantli den judeahtecos, quiluihtihue: ―Moconeu yomic. Ocachi cuali ayacmo matemohsihuilo in Tlamachtiyani. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Huan Jesús ahmo omochiu cuenta tlen oquihtohuayahque huan oquiluiloc in tequihua: ―Ahmo ximomouti. San xicneltoca. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Huan ahmo aquin oquicahualoc tehuan yas, tlahmo Pedro huan Jacobo huan icniu Juan. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Huan ohualahque ichan in tequihua, huan Jesús omotac quen miyac tlacamen omoxinihque huan ochocatoyahque huan otenatoyahque chicahuac quen oquichiuque inon tlacamen queman miquis seya. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ocalacohuac huan oquiniluiloc: ―Ayacmo ximoxinican huan ahmo xicchoquilican. In ichpocatl ahmo mijqui, tlahmo san cochtoc. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Queman omihto inon, teca ohuetzcahque huan Jesús oquincalquixtiloc nochten. Huan oquinanaloc itata huan inana in ichpocatl, huan aquin tehuan oyayahque, huan ocalacohuac campa ocatca in ichpocatl. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Huan oquiquitzquiloc in iman huan omoluic ica tetlahtol: ―Talita cumi; tlen quihtosnequi, Ichpocatontli, nehhuatl nimitziluiya, ximehua. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Huan saniman omeu in ichpocatl, huan onehnen, tleca yiquipiya mahtlactli huan ome xihuitl. Huan ic inon quen tel oquimautoyahque in oc sequinten. ");
INSERT INTO ncjNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Huan Jesús omotequiutihque quen ahmo aquin maquiluican tlen opanoc, huan oquiniluiloc maquitlamacacan in ichpocatl. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Oquixohuac in Jesús de ompa huan ohuilohuac techantzin, huan otecuitlapanuiyayahque in tetlamachticahuan. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Huan ipan in tonali den nesehuilistli den judeahtecos opehualoc tlamachtilo ipan in tiopantli de yehhuan. Huan miyac otecajque huan quen tel oquimatque. Huan oquihtohque: ―Anquimati campa oquiahsic inin tlanehnehuilistli. Mamota quen cuali tlapahtiya tlen ahyic aquin quiitztoc. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Huan yehhuatl san in couxinqui, iconeu in María huan icniu Jacobo huan José huan Judas huan Simón. Noyojqui nicancaten ihueltihuan tohuan. Ic inon otenexicaluihque. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Huan ic inon Jesús oquiniluiloc: ―In tlayolchicahuani quipiya mahuesyotl san canin, huan ihtech itlal huan ihuan ichanihcahuan, ahmo. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Huan quen ahmo oteneltocaque, omochihuayaya san quesqui tlachiuten mahuestic. San inon oquitlalililoc teman pani san quesqui cocoxcamen huan oquimpahtiloc. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Huan Jesús quen tel omomautoya quen yehhuan ahmo oteneltocayayahque. Huan onehnemohuayaya ipan in altepetohton tlahtlatentli in Nazaret, huan oquinnextililoc. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Huan oquinsentlaliloc in mahtlactli huan ome tetiotlatitlaniluan huan oquintitlaniloc inehnehuan matlanonotzacan. Huan oquinmacaloc tequihuahyotl ic maquinquixtican in ahmo cuali yehyecamen. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Huan oquintequiutiloc: ―Ipan namoohtli xicuicacan san yeh in coutopili, huan ahmo xicuicacan in pantzin, niyan in bolsa, niyan tomin. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Huan cuali nanquitlalisque namotecac, huan san se namotlaquen. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Canin nancahsisque ipan se cali, ompa ximotepaluican hasta nanquisasque de inon altepetl. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Huan tla ahmo mechselisque in tlacamen de se altpetl, niyan ahmo mechcaquisque, queman nanquisasque de ompa ximoxotzehtzelocan ica in teutli de namotecac ic maquichihuacan cuenta quen omechixtlasque. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nochten in mahtlactli huan ome tetiotlatitlaniluan oquisque, huan otlannonotztinemiyayahque in tlacamen mamoyolcuepacan ica in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Noyojqui oquinixtohuetzayahque miyac in ahmo cuali yehyecamen, huan oquintohtoxomayayahque miyaquin in cocoxcamen ica in aceite huan oquimpahtihque. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","In hueyixtoc Herodes oquitecaquili tetenehualoca in Jesús, tleca omoteixmatiltilohuaya nohuiyan. Huan Herodes oquihto: ―Inin Jesús cana yes in Juan aquin otlacuatequiyaya. Omeu den mijcamen huan ic inon quipiya in chicahualistli ic quichihuas in tlachiuten mahuestic. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Huan oc sequin oquihtohuayahque: ―Yehhuatl in tlayolchicahuani Elías. Huan oc sequin oquihtohuayahque: ―Yehhuatl se tlayolchicahuani, quen de yihuehcau. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Huan queman oquicac in hueyixtoc Herodes, oquihtoc: ―Yehhuatl in Juan, aquin oniquihto maquiquechtzontequican, huan oquiehualo in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Oquihtoc ijcon in Herodes ica tlen opanoc tleca oquisihuacuilic in iicniu Felipe. Huan oquicaquiltic in Herodes in Juan ica tlen oquichiu huan ic inon oquicocolic in Juan inon sihuatl itoca Herodías. Oncan Herodes oquitzactoya in Juan, ahmo maquiahsi in sihuatl. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Tleca in Juan oquiluic in Herodes: ―Ahmo cuali ticpiyas isihuau mocniu. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Huan ic inon in sihuatl Herodías ocualan huan quimictiyani in Juan, huan ahhuel quiahsis. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Huan Herodes oquimoucaitac in Juan tleca oquimatiyaya yehhuatl se molui cuali tlacatl huan se iconeu in Dios. Huan ic inon oquitzactoya in Herodes ic ahmo tlen maquipano. Miyacpa in Herodes oquitlahtolcaquiyaya in Juan, huan masque ahmo oquinehnehuiliyaya tlen oquiluic, oquipactiyaya quicaquis. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","In Herodes oquitlaolichti in itonal inetlacatilis huan oquintlamacac nochin huehhueyi tequihuahmen huan in tlicancamen den tlali Galilea. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Huan ocalac ichpocau inon Herodías huan opeu mihtohtiya, huan oquipacti Herodes huan aquin ihuan ocatcahque. Huan in hueyixtoc oquiluic in ichpochtontli: ―Xinechtlahtlanili tlen ticnequis, huan nehhuatl nimitzmacas. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Huan oquicaquiltic in Herodes: ―In tlen tinechtlahtlanilis, nimitzmacas hasta in tlahcopa campa nihueyixtoc. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Huan oquis in ichpochtontli huan oquitlahtlanito in inana: ―¿Tlen nictlahtlanis? Huan inana oquinanquilic: ―Xictlahtlanili itzonteco den Juan Tlacuatequiyani. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Huan saniman in ichpochtontli omocuep canin ocatca in hueyixtoc huan oquiluic: ―Nicnequi saniman xinechmaca iitzonteco Juan Tlacuatequiyani ihtech se plato. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ic inon in hueyixtoc Herodes molui otlocox, huan ipampa itlahtol huan in aquin ihuan ocahcatca, ic inon ahmo oquinec motlahtolpatlas. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Saniman in hueyixtoc oquititlan se topili macualica itzonteco in Juan. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","In topili oya huan oquiquechtzontec in Juan ompa telpiloyan, huan ocualicac itzonteco ihtech se plato. Huan oquimacac in ichpochtontli, huan yehhuatl oquimacato inana. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Queman in itlamachticahuan den Juan oquimatque inon, oyahque quianahque itlacayo, huan oquitocaque ihtech se tlaltecochtli. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Omocuepque in tetiotlatitlaniluan in Jesús canin oquinchiyaloc huan oteiluihque nochin tlen oquinchiuque huan tlen oquinextilihque in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Huan Yehhuatzin oquiniluiloc: ―Matimoxelocan san tehhuan ipan se tlali huehca huan ompa timosehuisque chihton. Ijcon omihto tleca miyacten oteahsiyayahque huan oquisticatcahque. Huan ic inon niyan ahhuel otlacuahque. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Huan oyahque ihtech se barco huan oahsitohque ipan se sacatlahtli canin ahmo aquin ocatca. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Huan miyacten oquinitaque quen oyahque, huan oquinixmatque. Huan oquisque in tlacamen den nochin altepemen inahuac, huan otzecuinque itentla in atl huan otetlanque. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Queman Jesús oquixohuac den barco huan oquinitaloc in miyac tlacamen, inca otlocoyaloc. Tleca ocatcahque quen calnelohten ahmo quipiyahque in paxtol, huan opehualoc quinnextililo miyac tlahtoli. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ihcuac molui yitiotlac, in tetlamachticahuan omopachohque tenahuac, huan teiluihtihue: ―Nican ahmo aquin chanti huan yitiotlac. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Xiquintitlani ic mayacan ipan in altepemen huan maquicohuacan tlen quicuasque. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yehhuatzin oquinnanquililoc: ―Xiquintlamacacan namehhuan. Huan otenanquilihque: ―¿Tlen cox, tiyasque ticohuasque pantzin ica ome mil pesos para tiquintlamacasque? Panos tlahco xihuitl ic quitlanis seya inon tanto. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","In Jesús oquintlahtlaniloc: ―Tel, ¿quesqui pantzin nanquipiyahque? Xiyacan xiquitacan. Queman yoquitaque, oteiluihque: ―Ompacaten macuili pantzin huan ome michten. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Huan oquintequiutiloc in tlacamen mamosehuican ipan quesqui ololi ipan in pasto. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Omosentlalihque ipan miyac ololi de se ciento huan de tlahco ciento. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","In Jesús omoan in macuili pantzin huan in ome michten, huan oahcotlachiyaloc neluicac huan omotlasohcamatiloc ica in Dios ica inon tlacuali. Huan ihcuac omoxehxelo, in pantzin omomiyaquilic. Huan oquinmacaloc in tetlamachticahuan, maquitlalican iixpa in tlacamen. Huan ihcuac omoxehxelo in ome michten, omomiyaquilic. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Huan nochten otlacuahque huan opachiuque. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Huan oquipehpenque mahtlactli huan ome canasta tenticatca ica in cohcotonque pantzin, huan tlen omocau den michten. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Huan in aquin otlacuahque cana macuili mil tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Huan saniman in Jesús oquintequiutiloc in tetlamachticahuan matlehcocan ihtech in barco huan mateyecanacan ipan in altepetl Betsaida tlen ca isentlapal in atl. Huan Yehhuatzin oquinnahuatiloc in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ihcuac otlan quinnahuatilo, ohuilohuac ipan in tepetl moyolmachtilo. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ihcuac yitlayohua, in barco ocatca inepantla in hueyi atl, huan Jesús tesel omocahualoc ipan in tlali. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Huan oquinitaloc quen yosiyauque ic tlaatilantihue, tleca tlahuel chicahuac in yehyecatl ic quixnamictihue. Huan ic tlatuihtica, Jesús oquinahsiloto nehnemohuatiu iixco in atl. Huan onesiyaya quen Yehhuatzin omonequiyaya quimpanahuilos. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Huan ihcuac yehhuan oteitaque in Jesús nehnemohuatiu iixco in atl, oquinehnehuilihque yeh se nemohmoutilistli, huan oquitzahtzilihque. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tleca nochten oteitaque huan omomoutihque. Huan saniman Jesús otlahtoloc huan oquiniluiloc: ―¡Ximoyolchicahuacan huan ahmo ximomoutican! Nehhuatl niJesús. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Huan otlehcoloc ihtech in barco huan in yehyecatl omosehuic. Huan yehhuan molui quen tel oquimautoyahque. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Tleca ayamo oquinehnehuilihque aquin Yehhuatzin, huan masque oquitaque tlen opanoc ica in pantzin, oyoltepitzautoyahque. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ic oquipanahuihque in atl, oahsique ipan in tlali Genesaret, huan oquilpihtoyahque in barco atlatentli. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Huan oquisque ihtech in barco huan saniman in tlacamen oteixmatque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Huan otzecuinque nochten in tlacamen de ompa macualican in cocoxcamen canin oilohuaya in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Huan san canin oahxihuayaya Yehhuatzin ihtech in altepemen, oquintlaliyayahque in cocoxcamen ic tlalpan ipan in tiyanquistli huan otetlatlautiyayahque in Jesús maquincahuililo maquiquitzquican masque san yeh in tlapostectli den tetlaquen. Huan opahtihque nochin aquin otequitzquihque. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","In fariseos huan sequin tlamachtiyanimen den itlanahuatil in Moisés oahsitohque den hueyi altepetl Jerusalén, huan omosentlalihque tenahuac in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yehhuan oquinitaque quen sequin tetlamachticahuan in Jesús otlacuahque masque ahmo omomahtequihque quen quihtohua in itlanahuatil inchichicacoluan. Huan oquinehnehuilihque sajcon quimahualtihtoc. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tleca in fariseos huan nochten in judeahtecos oquieuque in tlanahuatili den inchichicacoluan huan tlahmo momahtequisque quen quihtohua in tlanahuatili, ahmo tlacuasque. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Huan queman mocuepasque den tiyanquisco, tlahmo mopahpacasque quen quihtohua in tlanahuatili, ahmo tlacuasque. Huan oc sequin tlanahuatilten maquiehuacan, huan ijcon quipacasque nochin vasos tlen ic tlaonihque, huan in caxitl, huan in teposxalo. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yehhuan in fariseos huan in tlamachtiyanimen den tlanahuatili otetlahtlanihtoyahque in Jesús: ―Tel, ¿tleca in tetlamachticahuan ahmo quitlacamatihque in tlanahuatilten den tochichicacoluan, huan tlacuahque san ijcon ahmo momahtequiyahque? ");
INSERT INTO ncjNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Huan Jesús oquiniluiloc: ―Inon melahuac tlen yihuehcau oquihcuilo in tlayolchicahuani Isaías ihtech Itlahcuiloltzin Dios ica namehhuan den ome namoxayac: Inin tlacamen temahuestiliyahque in Dios san ica incamac, huan ahmo quinehnehuiliyahque. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Huan san tlaluis temahuestiliyahque tleca quinnextiliyahque intlanahuatil inchichicacoluan huan quiluisque yeh in itlahtoltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Namehhuan ayacmo nanquichihuahque cuenta ica itlanahuatiltzin Dios huan axan san nanquitlacamatihque in itlanahuatil in tlacatl. Yeh in tlapahpacalistli den xalos huan in vasos tlen ic tlaonihque huan oc sequin miyac tlamantli ijcon nanquichihuahque. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","’Ayacmo nanquichihuahque cuenta ica itlanahuatiltzin Dios. San nanquichihuahque cuenta ica namotlamachilis. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tleca in Moisés oquihcuilo: “Xicmahuestilican namotata huan namonana”, huan “Aquin quipactecas itata noso inana, maquimictican in tlacamen.” Ijcon oquihto in Moisés. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Huan namehhuan den tiopan nanquihtohuahque se tlacatl cuali quiluis itata noso inana; “Nochin nohuaxca ica tlen cuali nimitzpalehuini, yonitetlocoli in Dios.” ");
INSERT INTO ncjNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ayacmo nanquicahuahque maquichihua ocachi para itata huan inana. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ijcon quen nanquichiuticaten san tlaluis itlahtoltzin Dios ipampa namotlanahuatil tlen namehhuan nanquitenextiliyahque. Huan miyac tlamantli yojqui nanquichihuahque. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Huan Jesús oquinnotzaloc oc sepa in tlacamen, huan oquiniluiloc: ―Xinechcaquican namochten, huan xicnehnehuilican. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","In tlen quicuas in tlacatl ahhuel quitlaihtlacahuiya, huan in tlen quisa ipan iyolo in tlacatl, yeh in tlen quitlaihtlacahuiya. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","In aquin quicaqui inin, maquinehnehuili. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Queman Jesús omocauteuque in miyac tlacamen huan ocalacohuac ihtech in cali, in tetlamachticahuan otetlahtlanihque ica inon tlalnamictilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Huan oquintlahtlaniloc: ―Ojcon tel, ¿niyan namehhuan ayamo nanquinehnehuiliyahque? Nanquimatinihque inin tlahtoli. In tlen calaquis iihtech ahhuel quitlaihtlacahuis iyolo in tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tleca ahmo calaqui ihtech iyolo, tlahmo ihtech iihte, huan quisa quiahuac. Ijcon Jesús otechnextililo quen nochin tlacuali cuali. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Noyojqui omihto: ―Inon tlen quisas ihtech in icamac in tlacatl, inon quitlaihtlacahuis. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tleca iyolihtec in tlacatl quinehnehuiliya in ahmo cuali tlahtoli huan ic inon sihuaahuiltiya huan tlacaahuiltiya huan temictiya huan tlachtequi. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Noyojqui ijcon iyolihtec quipiya molui apistli, huan quichihua molui ahmo cuali, huan tlacahcayahua huan ixpoliucatinemi huan nexicaluiya huan tlapacteca huan mohueyiliya huan ahmo quichihua cuenta tlen quichiutinemis. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nochin inin tlahtoli ahmo cualten quisa iihtech huan quitlaihtlacahuiya in tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ihcuac inon in Jesús oquixohuac de ompa huan ohuilohuac inahuac in altepemen Tiro huan Sidón. Huan ocalacohuac ihtech se cali huan ahmo omonec aquin maquimati tla ompa oilohuaya, huan ahhuel omotlatiloc. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Huan ichpocau se sihuatl oquipiyaya in ahmo cuali yehyecatl. Inon sihuatl oquitecaquilic tetenehualoca in Jesús. Huan ic inon ohuala teita in Jesús huan otexotenamic. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Inon sihuatl den tlali Sirofenicia huan ahmo temasehualicniu in Jesús. Huan otetlatlautic maquiquixtililo in ahmo cuali yehyecatl tlen oquipiyaya in ichpocau. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Huan Jesús oquiluiloc: ―Achto maniquimpalehui in notlacaicnihuan, tleca in tla niquimpalehuiya achto in sentlapalchanimen, inon quen tla seya quincuilisque in pantzin den cocone huan quintlaxilisque in chichimen. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Huan yehhuatl otenanquilic: ―Ic nele Notecohtzin, huan in chichimen itzintla in mesa quicuahque intlahtlacoton den conemen huan ahmo tlen polihui. Niyan ahmo tlen polihui tla nechpalehuilos, masque nisentlapalchani. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Huan Jesús omoluic: ―Ica inon cuali tlahtoli nimitzpalehuis. Xiyau; in ahmo cuali yehyecatl yoquis ipan mochpocau. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Queman oya ichan ocahsito in ichpocau huetztoc ipan ipehpech huan in ahmo cuali yehyecatl yoquis ipan yehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Huan Jesús oquixohuac den itlatilanal in altpetl Tiro, huan omoyehualo in altepetl Sidón huan oahxihuac itentla in hueyi atl den Galilea. De nepa otlanecuiltequiloc ipan in tlalten den mahtlactli altepemen. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Huan otehualiquilihque se mudo, huan otetlatlautihque mamotlali teman ipan yehhuatl, mapahti. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Huan Jesús oquihuicaloc oc se lado ahmo maquitacan in tlacamen. Huan omonacascalaquili temahpil huan omomachihchahuiloc huan omomachilic inenepil in mudo. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Huan oahcotlachiyaloc neluicac, huan oyelsihsihuihuac huan omoluic: ―¡Efata!, tlen quihtosnequi, ximonacastlapo. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Huan saniman omotlapohque inacasuan huan cuali omocau inenepil, huan cualtzin tlacactoc huan tlahtohtoc. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Huan oquinnahuatiloc Jesús: ―¡Ahmo xitlanonotza! Huan quen ocachi oquintlacahualtiloc, ocachi huan ocachi oquihtohque. ");
INSERT INTO ncjNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Huan molui quen tel oquimauteuque huan oquihtohuayahque: ―Oquichiu nochin cuali; in nacastemen cuali omotlacaquiltihque huan oquintlahtoltiloc in mudos. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ipan inon tonalten oc sepa omosentlalihque miyac tlacamen, huan ahmo oquipiyayahque tlen quicuasque. Jesús oquinnotzaloc in tetlamachticahuan huan oquiniluiloc: ");
INSERT INTO ncjNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Nimotlocoltiya ica inin tlacamen tleca yiquipiya yiyi tonali nohuan caten huan ayacmo quipiyahque tlen quicuasque. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tla niquintitlanis inchan maapismicticacan, sotlahuitihue ihtech in ohtli, huan sequin de yehhuan ohualahque de huehca. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Huan in tetlamachticahuan otetlahtlanihque: ―¿Quen cuali tiquintlamacasque inin tlacamen nican canin ahmo tlen oncan? ");
INSERT INTO ncjNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús oquintlahtlaniloc: ―¿Quesqui pantzin nanquipiyahque? Yehhuan otenanquilihque: ―Ticpiyahque chicome. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Huan oquintequiutiloc in tlacamen mamotlalican huan omoan in chicome pantzin huan omotlasohcamatiloc, huan ihcuac omocohcoton, omiyaquilic. Huan oquinmacaloc in tetlamachticahuan maquinixpantilican in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Oquipiyayahque noyojqui sequin michtoton, huan queman omotlasohcamatiloc ica in Dios, oquintequiutiloc noyojqui maquinixpantilican. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Otlacuahque huan opachiuque nochten. Huan oquipehpenque in tetlamachticahuan chicome canasta san tlen omocau cohcotonque pantzin. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Inohque aquin otlacuahque cana nahue mil ocatcahque. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Huan Jesús oquinnahuatiloc in tlacamen huan saniman otlehcoloc ihtech in barco ihuan in tetlamachticahuan huan ohuilohuac ipan in tlali Dalmanuta. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Huan sequin fariseos ohualahque teitahque in Jesús huan opeuque tehuan motlahtolchihuiyahque. Teichtacaahsisnequihque ica Yehhuatzin huan ic inon otetlahtlanihque mamochihua itlahtlen mahuestic ic quitasque tla nele tequitis ica techicahualis den Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Huan chicahuac oyelsihsihuihuac in Jesús huan omihto: ―Huelis ahmo. Ahmo nanquitlahtlanisquiyanihque oc se tlachiutli mahuestic. Ic nele namechiluiya, ahmo nanquitasque oc sequin. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Huan oquincautehualoc, huan otlehcoloc ihtech in barco huan ohuilohuac oc se lado. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Huan in tetlamachticahuan oquilcauque cualicasque in pantzin, huan ahmo oquipiyayahque ocachi de se pantzin ihtech in barco. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Huan oquiniluiloc in tetlamachticahuan ica se tlalnamictilistli: ―Xicchihuacan cuenta ahmo maquiselican in pahtli tlen ic semahuis in pantzin den fariseos huan den tlacamen den Herodes. Quihtosnequi ahmo maquiselican in ahmo cuali tlanehnehuilistli de yehhuan tlen quitlaihtlacahuis inemilis ijcon quen quichihuas inon pahtli ica in pantzin. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Huan ahmo oquinehnehuiliyayahque in tetlamachticahuan huan ic inon omononotztoyahque ic yehhuan, huan omoluihque: ―Ahmo ticpiyahque in pantzin, huan ic inon ijcon otechnonotzaloc. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús omomat quen oquichiuticatcahque cuenta ica in pantzin, huan oquintlahtlaniloc: ―Tel, ¿tleca namononotzahque ic ahmo nanquipiyahque pantzin? Tel, ¿ayamo onanquinehnehuiliyayahque tlen namechiluiya? Tel, ¿oc nanyoltepitzautoque? ");
INSERT INTO ncjNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tel, ¿ahmo nantlachiyahque ica namoixtelolo, huan ahmo nantlacaquihque ica namonacas? ¿Huan ahmo nanquilnamiquihque tlen onicchiu queman oticnejque in pantzin? ");
INSERT INTO ncjNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tel, ¿quesqui canasta onanquipehpenque in cohcotonque pantzin queman onicxehxelo in macuili pantzin ica in macuili mil tlacamen? Yehhuan otenanquilihque: ―Oticpehpenque mahtlactli huan ome canasta. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Huan oc sepa oquintlahtlaniloc: ―Tel, ¿quesqui canasta onanquipehpenque den cohcotonque pantzin queman onicxehxelo in chicome pantzin ica in nahue mil tlacamen? Huan otenanquilihque: ―Oticpehpenque chicome canasta. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ihcuac inon oquintlahtlaniloc: ―Tel, ¿tleca ahmo onanquinehnehuiliyayahque ahmo onicchiuticatca cuenta ica in pahtli tlen ic semahuis in pantzin, tlahmo onicchiuticatca cuenta ica in ahmo cuali tlanextilistli? ");
INSERT INTO ncjNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Huan oahxihuato ipan in altepetl Betsaida in Jesús inuan in tetlamachticahuan, huan otehualiquilihque se ixpatzac. Huan otetlatlautihque maquipahtilo. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Huan Jesús oquiquixtiloc den altepetl momatilantiu, huan omixtlalili techihchac huan omotlalili teman ipan yehhuatl. Huan oquitlahtlaniloc: ―¿Yititlachiya chihton? ");
INSERT INTO ncjNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Yehhuatl oahcotlachix huan otenanquilic: ―Niquinita in tlacamen quen couten nehnenticaten. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Huan oc sepa in Jesús omotlalili temahuan ipan iixtelolo den ixpatzac huan otlachix huan nochin cuali oquitac. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesús oquititlaniloc ichan huan oquiluiloc: ―Ahmo xicalaqui ipan in altepetl, huan ahmo aquin xiquilui. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ohuilohuayaya in Jesús inuan in tetlamachticahuan ipan in altepemen den tlali Cesarea de Filipo. Huan ihtech in ohtli oquintlahtlanilohuaya: ―¿Tlen quihtohuahque in tlacamen ica nehhuatl? ");
INSERT INTO ncjNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Otenanquilihque in tetlamachticahuan: ―Sequin quihtohuahque Tehhuatzin in Juan Tlacuatequiyani. Oc sequin quihtohuahque Tehhuatzin in tlayolchicahuani Elías, huan oc sequin quihtohuahque Tehhuatzin oc se tlayolchicahuani de yihuehcau. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Oc sepa oquintlahtlaniloc Yehhuatzin. ―¿Huan namehhuan, tlen nanquihtohuahque ica nehhuatl? Otenanquilic in Pedro: ―Tehhuatzin in Cristo, Tetlapehpeniltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Huan oquintequiutiloc in Jesús ahmo aquin maquiluican. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Opeu quinextililo quen Yehhuatzin aquin Tetiachicau ica nochin tlacatl quipiya tlen tlapanolos. Huan teixtohuetzosque in tequihuahmen huan in achtohque tiopixcamen den judeahtecos huan in tlamachtiyanimen den itlanahuatil Moisés. Huan temictisque, huan ipan yiyi tonali ihxohuas den mijcamen. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Inin oquinyequiluiloc. Ihcuac inon otesecninquixti in Pedro huan opeu tetlacahualtiya. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Huan omocuepaloc in Jesús huan oquinitaloc inon tetlamachticahuan, huan oquiahhualoc in Pedro, ic omoluic: ―¡Ximoihcuani noixpa! ¡Titlahtohua quen Satanás! Ahmo ticnehnehuiliya tetlamachilis in Dios, tlahmo san yeh den tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Oquinnotzaloc in tlacamen huan in tetlamachticahuan huan oquiniluiloc: ―Aquin quinequi mochihua notlamachticau ayacuel quichihuas quen yeh quinequis. Tlahmo quipiya tlen quixicos ic tlapanos, masque miquis ipan in cruz, huan ijcon mochihua notlamachticau. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mopolos in aquin ahmo quinequi miquis nopampa, huan maquisas in aquin motemacas ica inemilis nopampa huan ipampa in cuali itlahtoltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Huelis se tlacatl cuali quitlanis nochin tlen quinequis nican tlalticpac. Huan tla quipolos inemilis ic quitlantica nochin inon, ahmo ipahtiu. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tleca ocachi patiyo inemilis quen nochin tlen oncan. ");
INSERT INTO ncjNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Huelis ompayes axan aquin nechixtlatis huan quipinahuiya ic quitlacamatis notlahtol inixpa in miyacatlacatl tlahtlacolyohque aquin ahmo nechneltocahque. Noyojqui nehhuatl aquin in Tetiachicau ica nochin tlacatl niquixtlatis inon tlacatl queman nihualas ica tehueyilistzin den Tohueyitahtzin ihuan in ángeles. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Noyojqui oquiniluiloc in Jesús: ―Ic nele namechiluiya, hualahsis in tonali queman quintequiutilos in tlalticpac tlacamen in Dios ica techicahualis. Huan namohtech oncan quesqui ahmo miquisque hasta queman ahsiquiu inon tonali ic nanquitasque. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ihcuac yipanotoc chicuasin tonali, Jesús oquinuicaloc in Pedro huan Jacobo huan Juan ipan se hueyi tepetl, huan omonextiloc molui cualtzin inixpa. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tetlaquen opeu petlani istac quen setl. Ones istac quen ahhuel quichipahuas se tlahtlapacani nican tlalticpac. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Huan onesque den neluicac in ichichicacoluan Elías huan in Moisés, huan tehuan omonohnotztoyahque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Huan Pedro oteiluic in Jesús: ―¡Tlamachtiyani, tequin cuali nis ticaten! Maticchihchihuacan yiyi xahcali, seya ica Tehhuatzin, huan oc seya ica Moisés, huan oc seya ica Elías. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tleca omomoutihtoyahque inon yiyi tetlamachticahuan huan ic inon in Pedro ahmo oquimatiyaya tlen quihtos. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Huan omohualpacho se mextli impan yehhuan. Ipan in mextli oquicajque se tlahtoli den Dios tlen omihto: ―Inin noconetzin aquin nictlasohtlato. Xitecaquican Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Huan ihcuac otlachixteuque, ayacmo aquin oquitaque, tlahmo san Yehhuatzin in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ihcuac temotihue den tepetl, in Jesús oquintequiutiloc: ―Ahmo aquin xiquiluican ica tlen axan onanquitaque hasta queman nehhuatl aquin Nitetiachicau ica nochin tlacatl niihsas den mijcamen. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Huan oquixtlapachohque inon tlahtoli ic yehhuan, huan ic inon omonohnotztoyahque ica tlen quihtosnequi inon, mach ihxohuas den mijcamen. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Huan oquihto se de inon tetlamachticahuan: ―In tlamachtiyanimen den itlanahuatil Moisés quiluiyahque mach quipiya tlen mocuepas achto in tlayolchicahuani Elías huan hualuilohuas satepa in Totemaquixticahtzin. ¿Tleca ijcon quihtohuahque? ");
INSERT INTO ncjNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Huan oquinnanquililoc Yehhuatzin: ―Ic nele, ihcuiliutoc ihtech Itlahcuiloltzin Dios quen achto hualas seya quen in tlayolchicahuani Elías. Quinnonotzas in tlacamen mamoyolcuepacan ica in Dios huan satepa hualuilohuas in Totemaquixticahtzin. Tel, ¿tleca quihtohuahque ipan in Tlahcuiloltzin ica nehhuatl aquin Nitetiachicau ica nochin tlacatl nicpiya tlen nitlapanos huan nechixtlasasque? ");
INSERT INTO ncjNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Huan namechiluiya, yohuala seya quen in Elías huan oquichihuilihque nochin in ahmo cuali quen oquinejque, quen tlahcuilohtoc ica yehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Queman oahxihuato canin ocatcahque in oc sequin tetlamachticahuan, oquinitaloc miyac tlacamen innahuac. Huan sequin tlamachtiyanimen den itlanahuatil Moisés omotlahtolchihuihtoyahque inuan. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Queman in tlacamen oteitaque in Jesús, saniman quen tel oquimauteuque, huan otzecuinque tetlahpalohuahque. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Huan Yehhuatzin oquintlahtlaniloc in tetlamachticahuan: ―¿Tleca nanmotlahtolchihuiyahque inuan? ");
INSERT INTO ncjNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Huan se de inon tlacamen otenanquilic: ―Tlamachtiyani, onicualicac noconeu maquipahtilo, tleca quipiya se ahmo cuali yehyecatl huan ic inon ahhuel tlahtohua. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Huan queman quinequi, quitlaluitequis, huan in telpocatl hualtemposonis huan tlahtlancuitzohuas huan hualcoupitzahuis. Huan oniquintlatlautic in tetlamachticahuan maquixtohuetzaluican, huan yehhuan ahhuel. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Huan Jesús oquitlahtlaniloc: ―Tel, ¿hasta queman nantlaneltocasque? Yihuehcau yonamechnextilic huan ayamo nannechneltocahque. Xinechualiquilican. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Huan otehualiquilihque in telpocatl. Queman in ahmo cuali yehyecatl oteitac in Jesús, oquitzetzelo in telpocatl, huan oquimayau tlalpa. Huan opeu momimilohua huan temposoni. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús oquitlahtlaniloc itata: ―Tel, ¿quesqui tonali quiahsitinemi inon? Huan yehhuatl oteiluic: ―De conetl. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Miyacpa oquimayau ihtech tletl huan ihtech atl ic quimictini. Huan tla cuali mochihuas itlahtlen topampa, matlocoyalo huan matechpalehuilo. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Huan Jesús omoluic: ―¿Tleca tiquihtos tla cuali? Aquin tlaneltoca, nochin cuali quichihua. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Saniman inon tetata otzahtzic huan oquihto: ―¡Nicneltoca, huan manechpalehuilo ic ocachi manicneltoca! ");
INSERT INTO ncjNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Huan queman Jesús omotac omohualsentlalihque miyac tlacamen, niman omotlacahualti in ahmo cuali yehyecatl ipampa ahhuel tlahtohua niyan tlacaqui inon telpocatl, huan omoluic: ―Ahmo cuali yehyecatl, nimitztequiutiya, xiquisa de yehhua huan ayacmo ihtech xicalaqui. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Huan in ahmo cuali yehyecatl otzahtzic huan oquitzetzelo in telpocatl oc sepa, huan oquis. Huan in telpocatl oquitaque quen mijqui. Ic inon oquihtohque: ―Mictoc. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Huan Jesús omomaquitzqui huan oquiehualoc. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Huan queman Jesús ocalacohuac ihtech in cali, in tetlamachticahuan otetlahtlanihque: ―Tel, ¿tleca tehhuanten ahhuel otiquixtohuetzohque inon ahmo cuali yehyecatl? ");
INSERT INTO ncjNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Huan Yehhuatzin oquinnanquililoc: ―Ahhuel nanquixtohuetzosque in ahmo cuali yehyecatl quen inon in tlahmo ica tlayolmachtilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Oncan oquixohuac in Jesús de nepa huan opanoloc ic Galilea. Huan ahmo omonec aquin maquimati tla ompic opanoloc. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Tleca omonextiliyayahque in tetlamachticahuan huan oquiniluiloc: ―Nehhuatl aquin Nitetiachicau ica nochin tlacatl nechtemactisque inmajco in tlacamen huan nechmictisque. Huan satepa ihcuac nimiquis, ipan yiyi tonali niihsas. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Huan in tetlamachticahuan ahmo oquinehnehuilihque inon tlahtoli, huan ahmo otetlahtlanihque tleca omomoutihque. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Oahsitohque Capernaum huan queman oilohuaya calihtec, in Jesús oquintlahtlaniloc: ―¿Tlen ic onanmotlahtolchihuihque ihtech in ohtli? ");
INSERT INTO ncjNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Huan yehhuan omopinautihque huan ahmo tlen otenanquilihque, tleca ic yehhuan omohualtlahtolchihuihtayahque ihtech in ohtli aquin ocachi hueyi iquisca. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesús omotlaliloc huan oquinnotzaloc in mahtlactli huan ome tetlamachticahuan huan oquiniluiloc: ―In aquin quinequi mochihuas achto, nochipa quipiya tetlacamatis huan san tepalehuiya ica nochten. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Huan niman oquianaloc in Jesús se conetl huan oquitlaliloc inepantla yehhuanten. Huan omonapaloc huan oquiniluiloc: ");
INSERT INTO ncjNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Aquin quiselis se conetl quen inin ica notoca, ijcon quisa quen nechselis nehhuatl. Huan aquin nechselis, ahmo san nehhuatl nechselis, in tlahmo noyojqui teselis in Dios aquin onechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Oncan Juan oteiluic: ―Tlamachtiyani, tiquitztoque seya aquin oquiquixtiyaya in ahmo cuali yehyecatl ica tetoca, huan otictlacahualtihque tleca ahmo tohuan onemiyaya. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Huan Jesús omihto: ―Xicahuilican, tleca ahmo oncan aquin quichihuas tlachiuten ica notoca huan niman nechpactecas. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tleca aquin ahmo techcocoliya, yeh in aquin techpalehuiya masque ahmo tohuan nemi. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","In aquin san mechatliltis quiahsis itlaxtlahuil, tleca quichiutica cuenta quen namehhuan tehuan nemi in Cristo. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’In aquin quitlahtlacolanaltis seya de inin conemen aquin nechneltoca, ocachi cuali tla inon tlacatl mamoquechilpi ipan metlatetl huan maquitohuetzocan ihtech in hueyi atl, ijcon mamelsima. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tla titlahtlacolanasnequi ica moman, ocachi cuali tla tictzontequis, huan timacotoc ticalaquis neluicac huan ahmo ica ome moman huan tiyas mictlan canin ahyic sehuis in tletl. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Huan ompa tequin quitlapanoltisque tleca ahhuel quisehuis in tletl. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Huan tla titlahtlacolanasnequi ica mocxi, ocachi cuali tla tictzontequis huan tixocotoc ticalaquis neluicac huan ahmo ica ome mocxihuan huan mitztlasasque mictlan. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Huan ompa tequin quitlapanoltisque tleca ahhuel quisehuis in tletl. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Huan tla titlahtlacolanasnequi ica moixtelolo, ocachi cuali tla timoixcopinas. Huan ticalaquis tiixpitzic ipan tetlatequiutilistzin Dios huan ahmo ica ome moixtelolo huan mitztlasasque mictlan. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Huan ompa tequin quitlapanoltisque tleca ahhuel quisehuis in tletl. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Quinmohsihuisque nochin aquin nechcuitlapanuisque, ic matetlacamatican. ");
INSERT INTO ncjNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Cuali in istatl, huan in tla yitlantica ichicahualoca, ayacuel tlapoyelis. Xinehnemican quen cuali istatl huan ximoyolsehuican se huan oc seya. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús oquixohuac de ompa huan ohuilohuac ipan in tlali Judea huan ic oc se lado den atentli itoca Jordán. Huan oc sepa oyahque teitahque miyac tlacatl, huan oquinnextililoc quen nochipa. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Huan sequin fariseos oteahsitohque in Jesús, huan oquitemohque ica tlen cuali teteluisque, huan otetlahtlanihque: ―¿Tlen tiquihtos; quicahuilihtoque in tlacatl quicahuas isihuau? ");
INSERT INTO ncjNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yehhuatzin oquinnanquililoc: ―Tel, ¿tlen omechtequiuti itlahcuilol in Moisés? ");
INSERT INTO ncjNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yehhuan otenanquilihque: ―Moisés oquincahuili maquimaca in sihuatl in amatl den mosihuacahualistli huan ijcon quicahuas. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesús oquinnanquililoc: ―Moisés omechihcuilui inon tlanahuatili tleca tepitzautoc namoyolo. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Huan ahmo ijcon omonec in Dios queman omochiu in tlalticpactli huan omochiu in tlacatl huan in sihuatl. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Omonec in tlacatl maquicahua itata huan inana huan mamosechihua ihuan isihuau. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Huan in ome mochihuasque san seya. Ijcon ayacmo ome, omochiuque san seya. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ic inon in tlen Dios omosechiu, ahmo aquin maquinxelo. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Satepa ihtech in cali in tetlamachticahuan otetlahtlanihque oc sepa ica inon tlahtoli. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Huan Yehhuatzin oquiniluiloc: ―In aquin quicahuas isihuau huan motlalis ihuan oc se sihuatl, oquiahuilti isihuau. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Huan tla in sihuatl quicahuas inamic huan motlalis ihuan oc seya, oquiahuilti itlacau. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Huan oteixpantilihque in conemen maquinmachililo in Jesús ica teman, huan in tetlamachticahuan oquintlacahualtihque in aquin otehualiquilihque. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Queman Jesús oquinitaloc, ocualanohuac huan oquiniluiloc: ―Xiquincahuacan in conemen mahualacan nechahsican huan ahmo xiquintzacuilican, tleca ipan tetlatequiutilistzin Dios nochin quineltocahque quen inin conemen. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ic nele namechiluiya, in aquin ahmo quineltocas quen se conetl ahhuel calaquis ipan tetlatequiutilistzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Huan Jesús oquinnapaloloc huan oquiniluiloc: ―Mamechuelitalo Tohueyitahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ihcuac inon Jesús omoan in ohtli, huan se telpochtli ohualtzecuintaya huan oteixnamic. Huan omotlancuaquetz teixpa, huan oteiluic: ―Cuali tlamachtiyani, tel, ¿tlen nicpiya nicchihuas ic nicahsis nochipa nemilistli? ");
INSERT INTO ncjNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús omonanquilic: ―¿Tleca tinechiluiya nicuali tlacatl? Niyan aquin oncan nele cuali, tlahmo san Yehhuatzin in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tiquixmati in tlanahuatilten: “Ahmo xitemicti, ahmo xisihuaahuilti, ahmo xitlachtequi, ahmo xitlatenehua, ahmo xitlacahcayahua, huan xiquinmahuestili motata huan monana.” ");
INSERT INTO ncjNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Huan inon telpochtli otenanquilic: ―Tlamachtiyani, nochin inon nictlacamautoc de ihcuac niquitzinin. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús oquiyolitaloc huan omotlasohtlac. Huan omoluic: ―Se tlamantli mitzpolohua. Xiyau, xicnemaca tlen ticpixtoc huan xiquintlocoli in prohues. Tla ticchihuas inon ticpiyas motlatlan neluicac. Huan xihuala huan xinechcuitlapanui. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Queman oquicac inon tlahtoli, yehhua omoixtocac, huan oya tlocoxtiu tleca quipixtoc miyac tlen iyaxca huan ahmo oquinec temactis. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ihcuac inon Jesús omoixitaque in tetlamachticahuan huan oquiniluiloc: ―Tlahuel tequiyo ic calaquis in rico ipan tetlatequiutilistzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","In tetlamachticahuan quen tel oquimauteuque ica inon tlahtoli, huan Jesús oc sepa oquiniluiloc: ―Nocnihuan, tlahuel tequiyo ic calaquisque ipan tetlatequiutilistzin Dios in aquin quichihuahque cuenta ica in ricohyo. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ahhuel panos in hueyi yolcatl itoca camello ihtech in itlacoyoc in acoxa. Masque in tla cuali, molui tequiyo yesquiyani. Huan ocachi tequiyo calaquis in rico ipan tetlatequiutilistzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ic oquicajque inon, ocachi quen tel quimauteuque huan omotlahtlanihque ic yehhuan: ―Tel, ¿aquin cuali maquisas? ");
INSERT INTO ncjNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","In Jesús oquintlachiyaliloc huan oquiniluiloc: ―In tlacatl isel ahhuel, huan ica in Dios cuali, tleca nochin tlamantli cuali mochihua in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","In Pedro oteiluic: ―Mamota, tehhuan oticauque nochin tlen oticpiyayahque huan axan titecuitlapanuihtinemihque. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús omihto: ―Ic nele namechiluiya, in aquin oquicau ichan, noso icnihuan, noso inana, noso itata, noso conemen, noso itlaluan nopampa huan ipampa in cuali itlahtoltzin Dios, yehhua quiselis itlaxtlahuil ipan inin nemilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Quiselis se ciento ocachi den calten, huan icnihuan, huan inanahhuan, huan conemen, huan in tlali, huan nochipa ica in tlamohsihuilistli. Huan ipan in yancuic tlalticpactli quiahsis in nemilistli nochipa. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Huan miyacten aquin nesi hueyi nican tlalticpac ahmo yes hueyi ipan tetlatequiutilistzin Dios. Huan in aquin ahmo hueyi axan ompayes hueyi. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ohuihhuilohuataya ipan ohtli Jerusalén, huan Jesús quinyecanalotiu in tetlamachticahuan. Huan yehhuan quen tel oquimauteuque tleca ahmo momoutilos ic tlehcolos ompa. Huan in oc sequin tlacamen otemoucacuitlapanuihque. Oncan Jesús oquinnotzaloc oc secnin in mahtlactli huan ome huan opehualoc quiniluiloc tlen tepanotiu. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Oquiniluiloc: ―Xiquitacan, titlehcohuahque Jerusalén, huan ompa tlatemactili yes nehhuatl aquin Nitetiachicau ica nochin tlacatl inmajco in achtohque tiopixcamen huan in tlamachtiyanimen den itlanahuatil in Moisés. Huan nechtlahtlacoltisque manimiqui huan nechtemactisque inmajco in tequihuahmen romanohteco. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Yehhuan nechtlayehyecaluisque, huan nechixchihchahuisque, huan nechuihhuitequisque huan nechmictisque. Huan ipan yiyi tonali niihsas. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","In Jacobo huan in Juan, ipiluan in Zebedeo, omopachohque tenahuac in Jesús huan oteiluihque: ―Tlamachtiyani, ticnequihque matechchihuililo tlen titetlahtlanisque. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Huan Jesús oquintlahtlaniloc: ―¿Tlen nanquinequihque namechchihuilis? ");
INSERT INTO ncjNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Yehhuan otenanquilihque: ―Techcahuililos timotlalisque seya ic teyejcan huan oc seya ic oc se lado queman mochihualo hueyixtoc. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Huan Jesús oquiniluiloc: ―Ahmo nanquinehnehuiliyahque tlen nannechtlahtlaniliyahque. Tel, ¿cuali nanquixicosque tla nantlapanosque quen nehhuatl nitlapanos? ");
INSERT INTO ncjNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Yehhuan otenanquilihque: ―Tehhuan cuali. Oncan Jesús oquiniluiloc: ―Ic nele, ic inon tlen nitlapanos, namehhuan nanquixicosque noyojqui. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Huan neh ahhuel niquihtos aquin motlalis nonahuac. Yimoluihtoc in Dios aquin motlalis ompa. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Queman in oc mahtlactli tetlamachticahuan oquicajque inon, ocualanque ica in Jacobo huan Juan. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Huan Jesús oquiniluiloc: ―Quen nanquimatihque namehhuan, yehhuan aquin quintequiutiyahque in tlacamen den tlalticpac mohueyiliyahque ica yehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Huan ahmo ojcon yesquiyanihque ica namehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","In aquin de namehhuan quinequi mochihuas in achto quipiya tlen san quimpalehuis nochten. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tleca nehhuatl aquin Nitetiachicau ica nochin tlacatl ahmo onihuala ic nechpalehuisque, tlahmo ic nitlapalehuis huan ic nictemactis nonemilis ic niquinmaquixtis miyacten. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Oahxihuato Jesús inuan in tetlamachticahuan ipan in altepetl Jericó. Huan oquixohuataya de inon altepetl inuan in tetlamachticahuan huan miyac tlacamen. Huan ihcuac se ixpatzac itoca Bartimeo iconeu Timeo oyehuatoya itentla in ohtli, quitlahtlanticatca limosna. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Queman oquimat omahsitaya in Jesús tealtepeu Nazaret, opeu tetzatziliya: ―¡Ixuiu in David, noca xitlocoya! ");
INSERT INTO ncjNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Miyacten oquiahhuaque ic mamocahua, huan yehhuatl ocachi otenotz: ―¡Ixuiu in David, noca xitlocoya! ");
INSERT INTO ncjNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesús omoquetzaloc huan oquintequiutiloc: ―Xinechanilican. Huan oquinotzque huan oquiluihque: ―Ximoyolchicahua huan ximoquetza. Mitznotzalo. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yehhuatl oquitohuetzoc ipampijca huan ohualtzecuin tenahuac in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Huan Jesús oquitlahtlaniloc: ―¿Tlen ticnequi manimitzchihuili? Huan in ixpatzac oquiteluic: ―Neh nicnequi nitlachiyas. ");
INSERT INTO ncjNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Huan Jesús oquiluiloc: ―Yixiyau, yotiteneltocac huan ic inon yomitzpahtiloc. Huan niman otlachix, huan otecuitlapanuic in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ihcuac ayacmo huehca den Jerusalén, oahxihuato inahuac in altepemen Betfagé huan Betania iixpa in tepetl Olivos. Huan Jesús oquinnotzaloc in inehuan tetlamachticahuan huan oquintitlanilo maquitlanehuican se burro. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Huan oquiniluiloc: ―Xiyacan ipan inon altepetl tlen nepaca namoixpa, huan niman nancahsisque se burro ilpihtoc, ayamo aquin ipan motlalihtoc. Xictohtomacan huan xicualicacan. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Huan tla aquin mechtlahtlanis tleca nanquichihuahque inon, xiquiluican in Totecohtzin monequi huan saniman mohualcuepas. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Oyahque huan ocahsitohque in burro ilpihtoc inahuac se puerta, ixcaltenco, huan oquitohtonque. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Huan sequin aquin ompa ocahcatca oquintlahtlanihque: ―¿Tlen nanquichiuticaten? ¿Tleca nanquitohtomahque in burro? ");
INSERT INTO ncjNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yehhuan otlananquilihque quen Jesús oquiniluiloc, huan oquincahuilihque. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ijcon otehualiquilihque in burro in Jesús huan oquipehpechtihque ica intetepa, huan Jesús ipan omotlaliloc. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Huan sequin oquisouque intlaquen ihtech in ohtli huan oc sequin oyahque mila huan oquitejque inmaxiuyo in cohuitl huan oquisouque ihtech in ohtli. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","In aquin tlicanahque huan in aquihque yahue tlacuitlapa coutzahtzitihue: ―¡Mahuestic in hueyixtoc aquin otehualtitlaniloc in Dios! ");
INSERT INTO ncjNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Matehuelitacan in aquin mochihuas hueyixtoc ijcon quen ocatca in tochichicacoltzin David. ¡Matitemahuestilican! ");
INSERT INTO ncjNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesús yoahxihuato in Jerusalén huan ohuilohuac ihtech in hueyi tiopantli den judeahtecos. Huan queman omotac nochin tlamantli tlen ompa ocatcayaya, ohuilohuac ic Betania ihuan in tetlamachticahuan, tleca yitiotlac. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Huan ic mostla, ihcuac oquixohuac den Betania, Jesús oapismicohuac. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Huan omotac de huehca se higoscohuitl, oxiuyohuatoya. Huan ohuilohuac mota tla quipiyas itlaquilyo, huan queman omahsito, ahmo tlen oquipiyaya itlaquilyo. San ixiuyo, tleca ayamo itonal in higos. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Huan omoluic in higoscohuitl: ―Ayacmo tictemacas motlaquilyo. Huan in tetlamachticahuan oquicajque inon. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Satepa de inon oahxihuac Jerusalén in Jesús. Ihcuac ocalacohuac ihtech in tiopantli, opehualoc quintotocalo in tlanemacanimen huan in aquin tlacoutinemihque. Huan oquintzincuepaloc in mesas den aquin quipatla in tomin huan in puestos den aquin quinemacahque huilomen. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Huan ahmo oquincahuililoc macuicacan niyan tlen tlamamali ihtech in tiopantli. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Huan oquinnextililoc ic oquiniluiloc: ―Ipan in Tlahcuiloltzin mihtohua in Dios: “Nochin tlacamen quitocahhuisque in tiopantli cali den tlayolmachtilistli para nochin tlalticpac”, huan namehhuan nanquichiutoque cali den ichtejcamen. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Huan in achtohque den tiopixcamen huan in tlamachtiyanimen den itlanahuatil Moisés oquicajque inon, huan ic inon opeuque quitemoliyahque quen temictisque. Tleca otemoucaitayayahque inon tequihuahmen quen in tlacamen otemahuestiliyayahque ican tetlanextilil. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Huan ic tlayohua Jesús inuan in tetlamachticahuan oquixohuac den altepetl. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ic mostla, queman ocualpanahuihque, oquitaque in higoscohuitl quen yohuac hasta ihuan ineluayo. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Huan Pedro oquilnamic huan oteiluic: ―Tlamachtiyani, mamota; in higoscohuitl tlen omoixtlas yohuac. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús oquinanquililoc: ―Xitlaneltocacan ihtech Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ic nele namechiluiya, aquin quiluis inin tepetl: “Ximoihcuani huan ximotlasa ihtech in hueyi atl”, ijcon panos in tlahmo quichiconehnehuiliya ipan iyolo. Maquineltoca ijcon yetos tlen oquihtoc, huan ijcon yes. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ic inon namechiluiya, nochin tlen nanquitlahtlanisque ic namoyolmachtisque, xicneltocacan nanquiselisque, huan ijcon yes. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Huan queman nanmoyolmachtisque, xictlapohpoluican aquin tlen mechchihuilihtoc. Ic inon Tohueyitahtzin aquin ilohuac neluicac mechtlapohpoluisque namotlahtlacol. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tla ahmo nanmotlapohpoluiyahque, noyojqui Tohueyitahtzin aquin ilohuac neluicac no ahmo mechtlapohpoluisque namotlahtlacol. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yomocuepaloc in Jesús inuan in tetlamachticahuan oc sepa Jerusalén. Huan ihcuac onehnemohuatinemiyaya ihtech in hueyi tiopantli, oteahsitohque in achtohque tiopixcamen huan in tlamachtiyanimen den itlanahuatil in Moisés huan in tetecten. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Huan otetlahtlanihque: ―¿Aquin mitztequiutiya ic ticchiutica ijcon quen yalua, noso aquin omitzmacac inin tequihuahyotl ic ticchihuas ijcon? ");
INSERT INTO ncjNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Oncan Jesús oquinnanquililoc: ―Niyau namechtlahtlanili se tlahtlanilistli noyojqui. Tla nannechnanquilisque, neh noyojqui namechiluis ica tlen tequihuahyotl onicchiu inon tlanextilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Tel, ¿queman otlacuatequiyaya in Juan, campa ocahsic in itequihuahyou? ¿Ocahsic den neluicac noso den tlacamen? ¡Xinechnanquilican! ");
INSERT INTO ncjNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Oncan opeuque motlahtlaniyahque ic yehhuan: ―Tla tiquiluisque inon Juan ocahsic itequihuahyou den neluicac, yeh techualiluis: “Tel, ¿tleca ahmo onanquineltocaque?” ");
INSERT INTO ncjNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Huan ahhuel tiquihtosque ocahsic itequihuahyou den tlacamen. Tleca omomoutihque ica in tlacamen, tleca nochten oquineltocaque Juan ic nele se tlayolchicauqui den Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ihcuac inon otenanquilihque in Jesús: ―Ahmo ticmatihque. Oncan Jesús oquiniluiloc: ―Neh noyojqui ahmo namechiluis ica tlen tequihuahyotl nicchihuas inin tlanextilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Huan Jesús opehualoc quiniluilo ica tlalnamictilistli: ―Ocatca se tlacatl oquitlali se uvahmili huan oquicorraltzac. Huan oquichcuac se tlacoyoctli canin quipatzcas in uvas, huan oquichihchiu se torre canin pantlachiyahque ipan in uvahmili. ’Huan oquitemo amedieros huan in iteco oya ipan oc se tlali huehca. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Huan ihcuac opeu mochihua in tlatoctli, ocualtitlan se itlaquehual maquiita in amedieros, ic maquiseli in tlen iyaxca. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Huan in amedieros oquiquitzquihque ic quihuihhuitequisque huan oquitotocaque huan sajcon oya. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Oc sepa ocualtitlan oc se itlaquehual, huan oquicuatlahtlapanque huan oquipactecaque. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ocualtitlan oc seya, huan inon oquimictihque huan ijcon oquinchiuque ica in oc sequinten. Oquincoumacaque sequin huan oquinmictihque oc sequin. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Huan oquipiyaya se iconeu tlahuel oquitlasohtlayaya, huan ocualtitlan noyojqui. Huan oquihto: “Quipiyahque tlen quimahuestilisque noconeu inon notlaquehualuan.” ");
INSERT INTO ncjNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Huan yehhuan omoluihque se huan oc seya: “Yeh aquin quiselis in tlali; tiyasque ticmictisque huan in tlali mochihuas tohuaxca.” ");
INSERT INTO ncjNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Huan oquiquitzquihque huan oquimictihque huan oquitohuetzohque tlatentli den itlal. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’¿Tlen quichihuas in iteco in tlamiloli? Mocuepas huan quimpolos in amedieros, huan quinmacas oc sequinten in itlamilol. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’Tel, ¿ahmo nanquipoutoque in Itlahcuiloltzin tlen quihtohua?: In tetl tlen oquixtohuetzohque achto, yeh oquis ocachi cuali in travesaño itzoncuac in puerta. Huan neh ijcon quen inon tetl. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Inin omochiu in Totecohtzin, huan yeh in se tlahtoli tiquitahque molui cualtzin. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Huan in fariseos oquinejque tequitzquisque in Jesús, tleca oquinehnehuiliyayahque oquinnexicaluiyaya ica inon tlalnamictilistli. Huan omomoutihque ica in tlacamen huan ic inon otecauque huan oyahque. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Satepa otehualahsique Jesús sequin den fariseos huan oc sequinten itepalehuihcahuan Herodes, ic teichtacaahsisque ica tetlahtol. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Huan queman oteahsicohque, oteiluihque: ―Tlamachtiyani, ticmatihque tehhua tiquihtohua tlen melahuac huan ahmo mochihua cuenta in tlen quihtohuahque in tlacamen, tleca ahmo ticchihua cuenta tlen iquisca niyan se tlacatl. Huan ic nele tiquinnextiliya in tlen monequis in Dios maquinehnehuilican. Tel, ¿techcahuilihtoque tictlaxtlahuilisque in renta in hueyixtoc itoca César, noso ahmo? ");
INSERT INTO ncjNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Huan Jesús omomat quen quichihuahque yehhuan de ome inxayac huan omoluihque: ―¿Tleca nannechchicopihpiyahque? Xinechualiquilican se tomin huan niquitas. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Yehhuan ocualicaque huan Jesús oquintlahtlaniloc: ―Tel, ¿aquin inin ixayac, huan in tlen tlahcuiloli? Huan yehhuan otenanquilihque: ―Inin ixayac huan itlahcuilol den hueyixtoc César. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesús oquinnanquililoc: ―Xicmacacan in hueyixtoc César tlen ihuaxca huan xitemacacan in Dios tlen tehuaxca. Huan quen tel oquimatque ica tlen oquinnanquililoc. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Huan oteahsicohque in Jesús sequin tequihuahmen den israeltecos intoca saduceos. Yehhuan aquin quihtohuahque in mijcamen ahmo yolisque oc sepa, huan otetlahtlanihque: ");
INSERT INTO ncjNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Tlamachtiyani, in Moisés otechtlahcuiluihtehuac tla se tlacatl miquis huan quicautehuas isihuau, huan tla niyan se iconeu, iicniu inon tlacatl quipiya ihuan motlalis inon sihuatl huan maquita iconeu ipampa icniu. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ocatcahque chicome icnimen. Huan in achto omosihuauti huan omic, huan ahmo oquitac niyan se iconeu. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Huan inon sihuatl ihuan omotlali in oc se icniu huan noyojqui omic, huan noyojqui ahmo oquitac niyan se iconeu. Huan ipan yiyi noyojqui ijcon opanoc. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Huan ijcon oquipanoc inon sihuatl ica in chicome icnimen huan ahmo oquitac niyan se iconeu. Huan satepa de ihcuac otlamimijque, noyojqui omic in sihuatl. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ihtech in ihxohualistli, ¿catli yehhuatl ihuaxca in sihuatl, tleca in chicome icnimen oquipixque? ");
INSERT INTO ncjNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Oncan Jesús oquinnanquililoc: ―Ijcon molui nanmotlapolochtiyahque. Ahmo nanquinehnehuiliyahque in Itlahcuiloltzin niyan in chicahualistli den Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tleca ihcuac ihsasque den mijcamen, ahmo mosihuautisque, tlahmo mochihuasque quen in ángeles tlen caten neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Huan nele ihsasque in mijcamen. Tel, ¿ahmo nanquipoutoque quen oquihcuilo in Moisés queman Dios oquinotzaloc ipan in hueyi xihuitl tlen oxotlatoya? Masque yomijque inon tochichicacoluan, oquiluiloc Moisés in Dios: “Nehhuatl niDios aquin nechmahuestilisque in Abraham, huan in Isaac huan in Jacobo.” ");
INSERT INTO ncjNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Masque yomijque, oc yolticaten teixpa in Dios. Ic inon molui nanmotlapolochtiyahque. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Omopacho seya den tlamachtiyanimen den itlanahuatil in Moisés aquin oquicac ihcuac omotlahtolchihuihtoyahque, huan quen oquinehnehuili in Jesús molui cuali oquinnanquililoc, ic inon otetlahtlanic: ―¿Tlen tlanahuatili in achto de nochin? ");
INSERT INTO ncjNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Huan Jesús oquinanquililoc: ―In achto yeh inin: “Xicaquican, tlacamen den Israel, in Totecohtzin Dios san se Totecohtzin. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Huan xitetlasohtla Totecohtzin Dios ica nochin moyolo huan ica nochin monemilis, huan ica nochin motlanehnehuilis huan ica nochin mochicahualis.” Inin in achto tlanahuatili. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Huan ic oupa: “Tictlasohtlas motlacaicniu ijcon quen tehhuatl timotlasohtla.” Ahmo oncan oc se tlanahuatili ocachi achto quen inihque. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ihcuac inon in tlamachtiyani den itlanahuatil Moisés oteiluic: ―Molui cuali, tlamachtiyani, huan ic nele quen omihtoc; Dios san seya; ahmo oncan oc seya. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Huan tla seya tetlasohtla ica nochin iyolo huan ica nochin itlanehnehuilis huan ica nochin inemilis huan ica nochin ichicahualis, huan tla quitlasohtla itlacaicniu quen yehhuatl motlasohtla, inin ocachi cuali de nochten tetlahpalol temacalotoc in Dios ipan tlen quitlaliyahque teixpa in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Huan queman Jesús omocac quen molui cuali otenanquilic inon tlamachtiyani, Yehhuatzin omoluic: ―Ic oc chihton ticnehnehuilis huan timotemactis ica tetequihuahyou in Dios. Huan niyan aquin ayacmo omixcohyanuic tetlahtlanis itlahtlen. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Huan ihcuac omotenextiliyaya itlahtoltzin ihtech in hueyi tiopantli, oquintlahtlaniloc in Jesús: ―In tlamachtiyanimen den itlanahuatil in Moisés quihtohuahque ichichicaixuiu in tochichicacoltzin David in Cristo aquin tetlapehpenil in Dios. ¿Tleca ijcon quihtohuahque? ");
INSERT INTO ncjNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tleca yeh in David aquin oquihcuiloc in tlen oquinextililoc in Itiotonaltzin Dios: In Tohueyitahtzin omoluic Totecohtzin: “Ximotlali ic noyejcan hasta niquimpinautis in motecocolihcahuan.” ");
INSERT INTO ncjNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Quen oquihto in David, Totecohtzin in Cristo itlapehpenil in Dios. ¿Quen tel, cuali mochihuas sa ichichicaixuiu in David? Huan in tlacamen otecajque ica paquilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Huan ihcuac omonextiliyaya, Jesús omihto: ―Ximomaluican den tlamachtiyanimen den itlanahuatil Moisés aquin quimpactiya nemisque ica hueyac intlaquen, maquinehnehuilican yehhuan tequihuahmen huan quimpactiya maquimahuestilican ipan in tianquistli. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Huan quimpactiya motlalisque campa ocachi cualcan ihtech in tiopan, huan canin ocachi quinmahuestilisque ihtech se iluitlacuali. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Inohque tlamachtiyanimen quincuiliyahque inchan in viudas huan ic manesi quen cualten tlaca, quincahcayahuahque nochten ica in hueyi tlayolmachtilistli. Yehhuan quiselisque tlahuel chicahuac intlahtlacol. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Huan Jesús omotlaliloc iixpa in tetlocolilcajon tlen ocatca tlahtec ihtech in hueyi tiopantli. Huan oquinitaloc quen in tlacamen oquitlaxilihticatcahque in tomin. Miyacten in ricos oquitlalilihque mimiyac. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Huan ohuala se prohue viuda huan oquitlaxilic ome mamacuili, oahsic mahtlactli centavo. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Huan Jesús oquinnotzaloc in tetlamachticahuan huan oquiniluiloc: ―Ic nele namechiluiya, inin prohue viuda oquitlaxilic ocachi miyac de nochten aquin oquitlaxilihticatcahque ihtech inin tetlocolilcajon. ");
INSERT INTO ncjNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tleca yehhuan oquitlalilihque tlen oquimocahuiyayahque, huan inin viuda masque ahmo oquipiyaya, oquitlaxilic nochin tlen oquipiyaya, ic tlacuas. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ihcuac Jesús oquixohuataya den hueyi tiopantli, oteiluic se den tetlamachticahuan: ―¡Tlamachtiyani, mamota tlen temen huan quen cualtzin inin calten! ");
INSERT INTO ncjNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Huan Jesús oquinanquililoc: ―¿Tiquita inin huehhueyi calten? Ahmo mocahuas niyan se tetl tlanepanoli, tlahmo xitinisque nochin. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Huan Jesús ohuilohuac ipan in tepetl Olivos tlen ocatca ic iixpa in hueyi tiopantli. Ihcuac omosehuiloc ipan inon tepetl, oteichtacatlahtlanihque in Pedro huan Jacobo huan Juan huan Andrés: ");
INSERT INTO ncjNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Xitechmoluili: ¿queman mochihuas inin ahmo cuali huan quen ticmatisque tlen tonali? ");
INSERT INTO ncjNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Huan Jesús opehualoc quiniluilo: ―Ximomaluican niyan aquin mamechcahcayahua. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Hualasque miyacten huan quihtosque: “Nehhuatl niCristo”, huan ijcon quincahcayahuasque miyacten. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Huan queman nanquicaquisque quen motehuiyahque san canic huan san tlahtoli den motehuilistli, ahmo ximomoutican. Ijcon quipiya tlen panos huan ayamo itlamiyan in tonali. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tleca motehuisque sequin huan oc sequin huan in hueyixtoc moixnamiquis ihuan oc seya, huan tlaluehueyocas san canic, huan yes apistli. Ipan inon tonali pehuas in tlapanolistli. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Huan xicchihuacan cuenta quen mechtemactisque iixpa in tequihuahmen tleca nannechneltocahque, huan mechuihhuitequisque in judeahtecos ihtech in tiopantli, huan mechtemactisque iixpa in hueyixtoque nopampa ic nanquichipahuasque inixpa yehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Huan ihcuac ayamo ahsi in tonali, in itlahtoltzin den temaquixtilistli quinonotzasque ipan nochin tlalticpactli. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Huan queman mechquitzquisque huan mechtemactisque iixpa in tequihuahmen, ahmo xicchihuacan cuenta tlen nanquihtosque. Tleca in Itiotonaltzin Dios mechmacalos tlen nanquihtosque ihtech inon tonali. Huan ijcon ahmo san namehhuanten nantlahtosque. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Huan seya quitemactis icniu ic maquimictican huan in tetata quitemactis iconeu. Huan in conemen quicocolisque in tetata huan quinemictiltisque. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Huan nochten mechixtlasasque nopampa, huan maquisas in aquin nechilnamiquis hasta miquis. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’In tlayolchicauqui Daniel oquihcuilo ihtech Itlahcuiloltzin Dios ica tlen tlayolihtlacohua. Queman nanquitasque inon tlamantli tecpantos canin ahmo yesquiyani, nochten in tlacamen den tlali Judea macholocan ic coutla. Maquichihuacan cuenta in aquin quiamapohua inin. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Huan aquin yes quiahuac den cali ahmo macalaqui ichan ic quiquixtis itlahtlen. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Huan aquin ompa yes ic mila ahmo mamocuepa ichan quiana itlaquen. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Huan tetlocolti in sihuamen aquin quinitzticaten impiluan huan yehhuan aquin tlascaltihticaten ipan inon tonalten. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Huan ximotlatlautican ic ahmo nancholosque ihcuac sehua. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tleca ihtech inon tonalten ompa yes tlamohsihuilistli tlen ahyic tiquitztoque ihcuac opeu in tlacticpactli tlen Dios omochiu hasta axan, huan ayacmo queman tiquitasque ijcon oc sepa. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Huan tla huehcahuis inon tlamohsihuihstli, niyan aquin maquisanihque. Huan impampa inon tetlapehpeniluan Dios ahmo huehcahuis inon tonalten huan cuali quixicosque. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Huan tla seya mechiluis namehhuan: “Xiquitacan, nicanca in Cristo”, noso “Xiquitacan, nepa ompaca”, ahmo xicneltocacan. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Hualasque aquin ahmo nele cristos huan tlayolchicaucamen san tlacahcayaucamen huan quichihuasque molui cualtzin quen Dios. Ijcon quincahcayahuasque hasta in tetlapehpeniluan Dios tla cuali. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Huan xicyecmautican namehhuan. Yinamechiluihtoc de achto. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Huan ipan inon tonalten satepa de inon tlamohsihuilistli, in tonaltzintli tlayohuas huan in metztli ahmo tlanextis. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","In sitlalten huetzisque den neluicac, huan Dios quinmayahui in tequihuahmen den neluicactli. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Huan ihcuac inon nochten nechitasque nehhuatl aquin Nitetiachicau ica nochin tlacatl hualuilohuatas ihtech in mextli ica hueyi tequihuahyotl huan molui cualtzin hasta tehuelitasque. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Huan ihcuac inon Dios mohualtitlanis in ángeles maquinsentlalican aquin tetlapehpeniluan de nohuiyan ihtech in tlalticpactli huan de nohuiyan ihtech in neluicactli. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Xicahxilican in tlalnamictilistli den higoscohuitl. Ihcuac pehua xotla nanquimatihque yimero ahsi in xopanilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ijcon noyojqui queman nanquitasque panotica inon tlamantli, nanquimatisque nele ayacmo huehca ic nimocuepas. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ic nele namechiluiya, in tlacamen axan yolticaten ahmo tlami miquisque hasta ihcuac panos nochin inin tlahtoli. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Polihuisque in neluicactli huan in tlalticpactli huan nochin tlen niquihtos ahhuel polihuis tlahmo nele tzonquisas. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Niyan aquin ahmo quimati niyan in tonali queman nimocuepas. Niyan in ángeles niyan nehhuatl Iconetzin Dios. In tlahmo momati san Yehhuatzin Tohueyitahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Ic inon xicyecmautiyecan huan xicchihuacan cuenta huan ximoyolmachtihtican, tleca ahmo nanquimatihque tlen tonali yes. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yes quen se tlacatl ihcuac yau huehca den ichan. Achto ic yas quincautehua matlachiyacan itlaquehualuan sehseya ica intequiu. Huan quitequiutiya in tlachiyani maquichihua cuenta. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Huan ahmo quimatihque queman mocuepas. Xicyecmautiyecan tel, tleca ijcon noyojqui ahmo nanquimatihque queman nihualas, tla cana tiotlajcan, noso cana tlayohua, noso cana ihcuac tzahtzis in pachilel, noso cana huehca sancuel. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ahmo yeh ihcuac nihualas huan namechahsiquiu ahmo nanmochiutosque cuenta. ");
INSERT INTO ncjNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","In tlen namechiluiya namehhuan, ijcon niquiniluiya nochten: Mamochihuacan cuenta ic manechchiyacan. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Opolihuiyaya ome tonali ic pehua in iluitl maquilnamiquican quen oquinmaquixtiloc in judeahtecos den tlali Egipto. Inon iluitl itoca pascua. Huan in achtohque tiopixcamen huan in tlamachtiyanimen den itlanahuatil in Moisés quitemohuahque quen teichtacaquitzquisque in Jesús ic matemictican. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Huan oquihtohuayahque: ―Ocachi cuali ahmo ticchihuasque ihtech in iluitl, huan ahmo mamochihua in netehuilistli den tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús oilohuaya ipan in altepetl Betania ichan Simón aquin opapalanticatca itlacayo. Ihcuac otlacualotoya, oahsito se sihuatl quihuica in pahtli molui patiyo itoca nardo, tlen quipiya iahhueyaca. Huan oquitlapan inon tehuilotl huan otetlalili in pahtli ipan tetzonteco in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Huan ocatcahque sequin ompa yehhuan ocualanque huan omoluihque: ―¿Tleca ijcon quitlasohchihua in pahtli? ");
INSERT INTO ncjNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Cuali quinemacani ica cana yiyi ciento denario huan quinmacani in prohues. Huan oquitlacahualtihque in sihuatl. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Huan Jesús oquiniluiloc: ―Xicahuacan. ¿Tleca nanquimohsihuihticaten? Se cualtzin tlamantli onechchihuili. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tleca nochipa ompayes namohuan in prohues, huan queman nanquinequisque, cuali nanquimpalehuisque. Huan nehhuatl ahmo nochipa nannechpiyasque. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yehhuatl oquichiu tlen cuali yeni. Masque ayamo nimijqui, onechtlalilic inon pahtli ihtech notlacayo quen quichihuasque ic tetocasque. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ic nele namechiluiya, san canic matlanonotzacan ica in cuali itlahtoltzin Dios ic nohuiyan ipan in tlalticpactli, noyojqui tlen oquichiu inin sihuatl quitematiltis ic maquilnamiquican. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Huan ihcuac inon, Judas Iscariote, seya den mahtlactli huan ome tetlamachticahuan, oya quinita in achtohque tiopixcamen ic tetemactis in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Queman yehhuan oquicajque tlen oquiniluihto, yehhuan opajque huan oquiluihque quimacasque tomin ic inon. Huan Judas oquitemoc quen cuali tetemactis. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Huan ocatca in achto tonali den iluitl queman in judeahtecos quicuahque in pantzin tlen ahmo semautoc, ihcuac quimictiyahque in calnelo den pascuahiluitl. Huan in tetlamachticahuan otetlahtlanihque in Jesús: ―¿Canin monequi matiyacan ticyectlalisque in tlacuali den pascua? ");
INSERT INTO ncjNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Oncan oquinnotzaloc inehuan tetlamachticahuan huan oquiniluiloc: ―Xiyacan ihtech in altepetl huan ompa nanquinamiquisque se tlacatl aquin quihuicatas se tzotzocoli den atl huan xicuitlapanuican. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Huan ipan tlen cali calaquis, xiquiluican iteco inon cali: “In tlamachtiyani otechualtitlaniloc matitlanahuatican: Nihualas ihuan in notlamachticahuan huan ticuasque in tlacuali den pascua. Huan axan matechnextililo in cuarto campa ticuasque.” ");
INSERT INTO ncjNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Huan yehhuatl mechnextilis se hueyi cuarto tlayectlalili ipan omepiso. Xicyectlalican in tlacuali ompa ica tehhuanten. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Huan in tetlamachticahuan oyahque ihtech in altepetl huan ocahsique quen oquiniluiloc, huan oquiyectlalihque in tlacuali den pascua. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Huan inon tiotlac in Jesús inuan ohualuilohuac in tetlamachticahuan. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ihcuac omotlalihque tlacuahque, Jesús oquiniluiloc: ―Ic nele namechiluiya, seya de namehhuanten aquin nohuan tlacuas, yeh in aquin nechtemactis. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yehhuan otlocoxque huan oquiteluihque se huan oc seya: ―Cox, ¿nehhua yes? ");
INSERT INTO ncjNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Huan Jesús oquinnanquililoc: ―Yeh in seya de inin mahtlactli huan ome aquin quipolactiya in pantzin nohuan. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tleca nehhuatl aquin Nitetiachicau ica nochin tlacatl nimiquis quen quihtohua ihtech Itlahcuiloltzin Dios, huan tetlocoltiya in tlacatl aquin yau nechtemactiya. Ocachi cuali inon tlacatl ahmo tlacatisquiyani tleca molui motlapanoltis. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ihcuac yehhuanten tlacuahticaten, Jesús omoan in pantzin huan omotlasohcamatiloc ica in Dios. Omocohcoton huan oquinmahmacaloc huan oquiniluiloc: ―Xicuacan, inin pantzin notlacayo. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Huan omoan noyojqui se vaso ica vino. Omotlasohcamatiloc ica in Dios, huan oquinxehxeluiloc huan omoyecoltihque nochten. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Huan oquiniluiloc: ―Inin noyes. Nechmictisque huan niyesquisas. Inin noyes tlen ic quilnamiquisque in yancuic mononotzalistli tlen mochihua Notahtzin Dios ica nochin aquin tehuaxca. Quintlapohpoluilos intlahtlacol in Dios tleca nimiquis impampa. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ic nele namechiluiya, ayacmo niconis den iyayo den uva hasta in tonali queman niconis in yancuic ipan in tetlatequiutilistzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Huan ocuihcuicaque se tlamahuestilistli huan oquisque den cali huan oyahque ipan in tepetl Olivos. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Oncan Jesús oquiniluiloc in tetlamachticahuan: ―Nochten namehhuan nanmopinautisque huan ic inon nanmochayahuahque ipan inin tlayohua. Tleca ijcon omihto in Dios ihtech Itlahcuiloltzin: “Queman nicmictis in paxtol, in icalnelohuan mochayahuasque.” Ijcon ca tlahcuiloli tlen panos queman nimiquis. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Huan satepa de inon niihsas, huan namechyecanas ipan in tlali Galilea. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Oncan Pedro oteiluic: ―Masque nochten mapinahuican, nehhuatl ahmo. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Huan Jesús omoluic: ―Ic nele nimitziluiya, inin tlayohua achto ic tzahtzis oupa in pachilel, tehhuatl tinechixtlatis yexpa. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Huan otlixnamic in Pedro huan oquiteluic: ―Masque nechmictisquiyanihque tehuan, ahmo niteixtlatis. Huan ijcon nochten oquihtohque. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Huan oahsique canin itocahyan Getsemaní huan oquiniluiloc in tetlamachticahuan in Jesús: ―Ximotlalican nican huan niyau nimoyolmachti. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Huan oquinuicaloc in Pedro huan Jacobo huan Juan. Huan opehualoc motlocoltilo, huan omomohsihuiloc. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Huan oquiniluiloc: ―Tlahuel nimotlocoltihtica nicmachilihtica ayacmo nicxicos. Ximocahuacan nican huan xitlamautiyecan. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Huan Jesús otlicanaloc oc chihton, huan otlaltenamiquiloc huan opehualoc moyolmachtilo huan otetlatlautiloc tla cuali, ahmo mopanoni inon tlapanolistli. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Huan omihtohuaya: ―Notahtzin, nochin tlamantli cuali mochihuas. Manechpanahui ahmo nictlapanoltis. Masque ahmo manechpano quen nicnequi, tlahmo quen Tehhuatzin ticmonequiltiya. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Huan omocuepaloc inahuac in yiyi tetlamachticahuan huan oquinahsiloto cochticaten. Huan oquiluiloc in Pedro: ―Simón, cox, ¿ticochtoc? ¿Ahhuel titlamautiyes niyan se hora? ");
INSERT INTO ncjNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Xitlamautiyecan huan ximoyolmachtican, ic ahmo mechyoltilanas. Ic nele iyolo in tlacatl quinequi quitlacamatis in Dios huan in itlacayo ahhuel quichihua. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Oc sepa ohuilohuac huan omoyolmachtiloc, huan omihto ijcon quen achto. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Oc sepa omocuepaloc huan oquinahsiloco cochticaten inon yiyinten, tleca molui ocochmicticatcahque, huan ahmo oquimatiyayahque tlen tenanquilisque queman oquinihxitiloc. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Queman omocuepaloc ic yexpa, oquiniluiloc: ―Axan queme, xicochican huan ximosehuican, huan ayacuel; yopanoc in hora para cochis. Xiquitacan, yoahsic in hora queman nechtemactisque nehhuatl aquin Nitetiachicau ica nochin tlacatl inmajco in tlahtlacolyohque. Xiquitacan in aquin nechtemactis yohualahsic. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ximehuacan huan tiyohue. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Huan ihcuac otlahtoloticatca in Jesús, oahsico in Judas, inon se den mahtlactli huan ome. Ihuan ohualaya miyac tlacatl ica espadas huan cohuitl. Oquinualtitlanque in achtohque tiopixcamen huan in tlamachtiyanimen den tlanahuatilten huan in tetecten. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","In Judas, yeh in aquin otetemacti, yoquinnahuati: ―In aquin nictlahpalos, yehhuatl yes. Xiquitzquican huan xicuicacan ahmo xicmaquixtican. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Huan queman Judas oteahsito, saniman omopacho tenahuac in Jesús huan oteiluic: ―¡Tlamachtiyani! Ijcon otetlahpaloc. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Huan in tlacamen otequitzquihque in Jesús huan otehuicaque yitlatemactili. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Huan seya den tetlamachticahuan oquiquixti in espada huan oquinacastzontec se itlaquehual in hueyixtoc den tiopixcamen. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Huan Jesús oquiniluiloc: ―Tel, ¿ijcon onanualahque nannechquitzquiyahque quen se tlachtejqui ica espadas huan ica cohuitl? ");
INSERT INTO ncjNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mostli onicatca namohuan onamechnonotztoya ihtech in hueyi tiopantli. ¿Tleca ahmo onannechquitzquihque ompa? Huan axan ijquin nannechchiuticaten ica tlen nanquilnamiquihque in tlen yihuehcau ihcuiliutoc ipan Itlahcuiloltzin Dios ica nochin tlen nechpanos. Huan ijcon nannechchihuilihticaten axan. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Oncan otecautejque huan ocholohque nochten in tetlamachticahuan. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Huan se telpochtli opanpictoya san ica se itatapa huan otecuitlapanui in Jesús. Huan oquiquitzquihque in soldados itatapa. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Huan yehhua oquicautehuac in itatapa huan ocholo xipetz. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Otehuicaque in Jesús iixpa in hueyixtoc den tiopixcamen huan omosentlalihque nochten in tiopixcamen huan in tetecten huan in tlamachtiyanimen den itlanahuatil in Moisés. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Huan Pedro otehuehcapantocayaya hasta ipan iquiahuac in hueyixtoc den tiopixcamen huan ompa oyehuatoya inuan in topilten omoscohtoyahque inahuac in tletl. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Huan in achtohque tiopixcamen huan nochin tequihuahmen den tiopantli oquitemohuayahque aquin quichipahuas tlenon ica tetlahtlacoltisque in Jesús ica tlen temictisque, huan ahmo tlen oteahxilihque. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tleca miyacten oteistlacahuihtoyahque huan san omotlatlaxiliyayahque tlen oquihtohuayahque se huan oc seya. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Huan ohualahque sequin aquin oteistlacahuihtoyahque huan ijcon oquihtohque: ");
INSERT INTO ncjNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Oticajque quen oquihto: “Nicxitinis inin hueyi tiopantli tlen tlamachihchiutli huan ipan yiyi tonali nicchihchihuas oc seya tlen ahmo tlamachihchiutli.” ");
INSERT INTO ncjNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Huan niyan ijcon omoixnamictitoya ica tlen oteistlacahuiyayahque. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Huan in hueyixtoc den tiopixcamen omotelquetz tlanepantla huan otetlahtlani in Jesús: ―Tel, ¿ahmo titlananquilis ica tlen mitzchipahuilisque tehhuatl? ");
INSERT INTO ncjNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Huan Jesús san omocahualoc huan ahmo tlen omonanquilic. In hueyixtoc den tiopixcamen oncan oc sepa otetlahtlani: ―Tel, ¿tehhuatl in Cristo, Iconetzin in aquin titemahuestiliyahque? ");
INSERT INTO ncjNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Huan Jesús omonanquilic: ―Queme, nehhuatl niCristo. Huan nannechitasque nehhuatl aquin Nitetiachicau ica nochin tlacatl nimoyectlalihtos ic teyejcan in Dios aquin mopiya nochin chicahualistli. Huan nannechitasque quen nihualtemos den neluicac ihtech in mextli. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Ihcuac oquicajque inon, in hueyixtoc den tiopixcamen oquitzomon itlaquen tlen ihuaxca tleca oquinehnehuili inon Jesús otecamanaluic in Dios. Huan ic inon oquihto: ―Tequin onechcualantic. Namehhuan noyojqui onanquicajque quen otecamanaluic in Dios. Ahmo ticnequisque oc sequin tlachipaucamen. ¿Axan tlen nanquinehnehuiliyahque? Huan nochten otetlahtlacoltihque in Jesús huan oquihtohque: ―Quipiya tlen ticmictisque. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Oncan sequin opeuque teixchihchahuiyahque, huan oc sequin oteixpiquiyayahque huan oteixtlatziniyayahque. Huan otetlahtlanihque: ―Tel, ¿cuali titechiluis aquin mitztehuiya? Huan in topilihten otehuihhuitequiyayahque. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ihcuac oteyoluihtihque in Jesús ipan in ome piso den cali, in Pedro omocau tlatzintla ihtech in quiahuactli, huan ohuala quiahsi seya den itescahuan in hueyixtoc den tiopixcamen. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Huan oquitztehuac in Pedro moscohtica huan oquiyequitac maquixmati. Huan oquiluic: ―Tehhuatl noyojqui otinemiyaya ihuan in Jesús den Nazaret. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Huan oteixtlatic in Pedro, huan oquihto: ―Ahmo niquixmati, niyan nicnehnehuiliya tlen tinechiluiya. Huan oquis quiahuac. Huan otzahtzic in pachilel. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Huan inon tesqui oc sepa oquitac in Pedro huan opeu quiniluiya in aquin ompa ocatcahque: ―Inin tlacatl seya de yehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Huan Pedro oc sepa oteixtlatic. Huan oc chihton yehhuanten aquin ompa ocatcahque oc sepa oquiluihque: ―Melahuac tehhuatl seya de yehhuanten, tleca tehhuatl de Galilea huan ijcon titlahtohua. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Huan oquinanquilic in Pedro ic quitlapachos itlahtol: ―Nele Dios ahmo niquixmati inon tlacatl aquin nanquihtohticaten. Manicuicatinemi nochipa in tlahmo melahuac. ");
INSERT INTO ncjNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Huan niman otzahtzic in pachilel ic oupa huan Pedro oquilnamic quen Jesús omoluic: “Achto ic tzahtzis oupa in pachilel tinechixtlatis yexpa.” Huan opeu tlocolchoca. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Saniman quen otlatuic omosentlalihque in achtohque tiopixcamen huan in tetecten huan in tlamachtiyanimen den itlanahuatil in Moisés huan oc sequinten tequihuahmen den tiopantli. Omonohnotzque ica tlen quichihuasque ica in Jesús. Huan oteilpihque in Jesús huan otehuicaque tetemactiyahque imajco in Pilato. Yeh in aquin tequihua de nochin tlali Judea. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Huan in Pilato otetlahtlanic: ―Tel, ¿tehhuatl in hueyixtoc den judeahtecos? Yehhuatzin omonanquilic: ―Queme. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Huan in achtohque tiopixcamen oteteluihque iixpa in Pilato ica miyac istlacatlahtoli. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Oncan Pilato oc sepa otetlahtlani: ―Tel, ¿ahmo tlen titlananquilis? Xiquita ica quesqui tlahtoli mitzteluiyahque. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Huan Jesús ayacmo omonanquilic, huan Pilato quen tel oquimatiyaya tleca ahmo oquinehnehuilic quen ayacmo omonanquilic in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Huan cada xihuitl ipan inon iluitl den pascua quicahcahua se preso in tequihua. Maye in aquin oquinequiyayahque in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Huan ocatca se preso itoca Barrabás. Yeh in seya de yehhuan aquin quitzacuilisnequihque in tequihua huan oquinmictihque sequin tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Huan in tlacamen ohualahque huan opeuque quiluiyahque in Pilato maquicahcahua in preso quen nochipa quinchihuiliya ipan inon iluitl. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Huan Pilato oquintlahtlani: ―Tel, ¿nanquinequihque manicahcahua in hueyixtoc de namehhuan judeahtecos? ");
INSERT INTO ncjNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tleca oquinehnehuiliyaya ica nexicoli quen otetemactihque in achtohque tiopixcamen. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Huan yehhuan oquintlahtolmacaque in miyac tlacamen maquihtocan ocachi cuali maquicahcahua in Barrabás. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato oc sepa oquintlahtlani: ―Tel, ¿tlen nanquinequihque manicchihua ihuan aquin nanquihtohuahque hueyixtoc den namehhuan nanjudeahtecos? ");
INSERT INTO ncjNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Huan in tlacamen otlananquilihque, coutzahtziticaten: ―¡Xicmictican ipan in cruz! ");
INSERT INTO ncjNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Huan Pilato oquintlahtlani: ―¿Tleca nicmictis? ¿Tlenon ic mechmohsihuiya? Huan yehhuan ocachi omotlahtolchicauque: ―¡Xicmictican ipan in cruz! ");
INSERT INTO ncjNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ihcuac inon in Pilato oquicahcau in Barrabás tleca oquinec quimpacmacas in tlacamen. Huan in Pilato oquintequiuti in soldados matehuihhuitequican in Jesús ica cuitlaxtli tlen quipiya teposcuechtli, huan matehuicacan huan matemictican ipan in cruz. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Huan in soldados otehuicaque tlahtec ihtech in hueyi quiahuactli den palacio huan omosentlalihque nochin soldados. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Huan otetlaquentihque in Jesús ica se impampijca morada quen motlali san yeh in hueyixtoc, huan oquixinapalohque in corona de huetztli, huan otetlalilihque ipan tetzonteco. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Huan opeuque tetlayehyelcaluiyahque huan oteiluihque: ―¡Tiquixmati tehhuatl tihueyixtoc den judeahtecos! Ijcon teca ohuetzcahque. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Huan otecuahuitejque ica se acatl. Huan oteixchihchahuiyayahque huan omotlancuaquetzque teixpa huan san otemahuestilihque ic otetlayehyecaluihque. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Huan queman otlan tetlayehyecaluiyahque, otequixtilihque tepampijca huan otetlalilihque in tlen tetlaquen. Huan niman otehuicaque temictisque ipan in cruz. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Opanotaya se tlacatl itoca Simón den tlali Cirene, yeh in ipiluan Alejandro huan Rufo. Mocueptica den mila huan oquitequiutihque in soldados maquihuica tecruz in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Huan otehuicaque Jesús in itocahyan Gólgota, tlen quihtosnequi Tzontecontlan. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Huan ic ahmo tequin momachilis, otemacaque in vino tlaneloli ihuan mirra, quihtosnequi chichic pahtli. Huan Jesús ahmo omonic. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Huan otemasohualtihque ihtech in cruz mamicohua, huan oquiejque in cruz ihtech in tlacoyoctli. Huan in soldados omoxehxeluihque in tetlaquen huan omahuiltihque ica in dados aquin quitlanis sehsen tetlaquen. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Cana chicnahue hora tlahca queman otemasohualtihque. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Oquihcuilohque ipan se tablón icuac in cruz tlen ic oteteluihque huan oquihtohuaya: “Yeh in hueyixtoc den judeahtecos.” ");
INSERT INTO ncjNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tehuan oquinmasohualtihque ihtech incruz mamiquican inehuan ichtejcamen. Huan oquineuque in ome cruz, huan oquintocahque seya ic teyejcan, huan in oc seya ic oc se lado. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Huan ijcon opanoc quen ca tlahcuilohtoc ihtech in Itlahcuiloltzin Dios: “Tlapanolos quen seya den tlahtlacolyohque.” ");
INSERT INTO ncjNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Huan opanohuayahque sequin aquin otepactecayayahque huan omocuatzetzelohque ic teca ohuetzcahque. Huan oteiluihque: ―Tel, tehhuatl otiquihto mach tictoyahuas in hueyi tiopantli huan ihtech yiyi tonali oc sepa ticchihchihuas. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Axan ximomaquixti mosel huan xitemo ipan in cruz. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","San ijcon noyojqui otetlayehyecaluihque in achtohque tiopixcamen huan in tlamachtiyanimen den itlanahuatil in Moisés. Huan omoluihque seya huan oc seya: ―Oquinmaquixtic oc sequin huan yehhua ahhuel momaquixtiya. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tla nele yeh in Cristo, in hueyixtoc de tehhuan israeltecos, tiquitasque matemo ipan in cruz huan ticneltocasque. Huan noyojqui otepactecayayahque ihuan in inehuan ichtejcamen ipan in oc ome cruz. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ic nepantla otlayohuac ipan in tlali Judea hasta ipan yiyi horahtiotlac. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Huan ipan inon hora ocoutzahtzihuac in Jesús ica tetlahtol: ―Eloi, Eloi, ¿lama sabactani? ―tlen quihtosnequi: Dios nohuaxca, ¿tleca otinechmocahuili? ");
INSERT INTO ncjNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Huan sequin aquin ocatcahque tenahuac otecajque huan oquihtohque: ―Xicaquican, quinotztica in Elías. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Huan otzecuin seya huan oquiasiyau se tatapahtli ihtech in xococ vino huan oquitlali ipan in acatl mateahsi mamochichina, huan oquihto: ―Ximocahuacan. Tiquitasque tla in Elías hualas quitemohuis. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Oncan ocoutzahtzihuac in Jesús huan omicohuac. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Huan niman ipan Jerusalén in hueyi tatapahtli tlen ic otlahcoxeliutoya in hueyi tiopantli otzomon de tlacpac hasta tlatzintla huan ijcon ohomequis. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Queman in tlayecanqui aquin ocatca teixpa in Jesús oteitac quen omicohuac, yeh oquihto: ―Nele inin tlacatl Iconetzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Noyojqui ocatcahque sequin sihuamen oteitzticatcahque de huehca. Inepanco de yehhuan ocatca in María den altepetl Magdala, huan Salomé, huan María ipiluan in Santiaguito huan José. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Queman Jesús oilohuaya ihtech in tlali Galilea yehhuan otecuitlapanuihtinemiyayahque huan otetequipanohuayahque. Noyojqui oteitzticatcahque de huehca oc sequin sihuamen aquin otehualpantocayayahque ihcuac ohualehcoloc Jerusalén. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Huan yopanoc nochin inon ipan in tonali achto den tonali den nesehuilistli. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Huan yitiotlac oya quiita in Pilato se tlacatl itoca José den altepetl Arimatea. Huan inon José ocatca se hueyi tequihua den tiopantli huan noyojqui oquichixticatca ic pehualos ica tetlatequiutilistzin in Dios. Yehhua omixcohyanuic yas quitas in Pilato huan oquitlahtlanili tetlacayo in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Huan in tequihua Pilato quen tel oquimat tla yomicohuatoya in Jesús, huan oquinotz in tlayecanqui huan oquitlahtlani tla yomicohuac. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Queman in tequihua Pilato oquitlahtlani in tlayecanqui huan yoquiyecmat, ijcon oquicahuili in José maquihuica tetlacayo in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","In José oquicou se cuali tatapahtli huan oquitemohui tetlacayo huan otepihpiqui ica inon tatapahtli. Huan otetlali ipan se tlaltecochtli icxitla in tepetl, huan oquixtzajque se patlahuac tetl inon tlaltecochtli. ");
INSERT INTO ncjNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Huan María den altepetl Magdala huan María inana in José oquitaque canin otetocaque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Queman yopanoc in tonali den nesehuilistli, María den altepetl Magdala huan Salomé huan María inana Santiaguito oquicouque in pahtli ahhuiyac ic quitlalilisque in tetlacayo in Jesús, quen oquichihuayayahque in judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Huan ipan sancuel den achto tonali den semana, ihcuac yoquixohuac in tonaltzintli, oahsitohque ipan in tlaltecochtli. ");
INSERT INTO ncjNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Huan ic yehhuan omoluihque: ―Tel, ¿aquin cuali quixcuepas in hueyi tetl tlen ic ixtzactoc in tlaltecochtli? ");
INSERT INTO ncjNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Huan queman oquitaque, in hueyi tetl yoixcueptoya. ");
INSERT INTO ncjNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Huan queman ocalajque ihtech in tlaltecochtli, oquitaque se telpochtli oyehuatoya ic iyejcan huan ipampijca hueyac huan istac. Huan yehhuan omomoutihque. ");
INSERT INTO ncjNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Huan yehhua oquiniluic: ―Ahmo ximomoutican. Nantetemohuahque in Jesús den Nazaret, yeh in aquin otemictihque ipan in cruz. Ayacmo nican ilohuac tleca yoihxohuac den mijcamen. Xiquitacan canin otetlalihque. ");
INSERT INTO ncjNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Xiyacan huan xiquiluican in Pedro huan in oc sequin tetlamachticahuan quen Yehhuatzin mechyecanalos hasta in tlali Galilea huan ompa nanteitasque quen mechiluiloc. ");
INSERT INTO ncjNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Huan inon sihuamen ihcuac omocuepatoque ipan in tlaltecochtli, ocholohque tleca molui omomoutihque. Huan ahmo aquin oquiluihque itlahtlen tleca omomoutihticatcahque. ");
INSERT INTO ncjNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Queman Jesús oihxohuac ipan sancuel den achto tonali den semana, achto oquimonextililoc in María den altepetl Magdala, in aquin oquixtohuetzaluiloc chicome ahmo cuali yehyecamen. ");
INSERT INTO ncjNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Yehhua oya quinnahuatiya in tetlamachticahuan in Jesús huan oquinahsito tlocoxtoque huan chocatoque. ");
INSERT INTO ncjNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Huan queman yehhuan oquicajque quen yolihuatoc in Jesús huan quen María oteitac, yehhuan ahmo oquineltocaque. ");
INSERT INTO ncjNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Huan satepa de inon, in Jesús oquinmonextililoc in inehuan tetlamachticahuan ipan ohtli. Yehhuan ahmo oteixmatiyayahque ic achto tleca omixpatlaloc. ");
INSERT INTO ncjNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Huan yehhuan oyahque quinnahuatiyahque in oc sequinten, huan ayamo oquineltocaque. ");
INSERT INTO ncjNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ocachi satepa in Jesús oquinmonextililoc in mahtlactli huan se tetlamachticahuan ic otlacuahtoyahque. Huan oquintlacahualtiloc quen oyoltepitzautoyahque huan ahmo oquinneltocaque yehhuan aquin oquinnahuatihque quen yoihxohuac. ");
INSERT INTO ncjNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Huan oquiniluiloc: ―Xiyacan ipan nochin tlalticpactli huan xiquinnonotzacan nochin tlacamen ica inin yancuic tlahtoli. ");
INSERT INTO ncjNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Aquin quineltocas huan tlacuatequili yes, quimaquixtilos in Dios. Huan aquin ahmo quineltoca, quitlahtlacoltisque. ");
INSERT INTO ncjNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","In aquin quineltocasque in yancuic tlahtoli niquinmacas chicahualistli maquichihuacan tlachiuten mahuestic. Quinixtohuetzosque in ahmo cuali yehyecamen huan tlahtosque ica oc sequin intlahtol. ");
INSERT INTO ncjNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Masque quincuas in cuamen ahmo quincocolisque. Huan tla mopahcualtisque, ahmo miquisque. Huan quitlalilisque inman ipan in cocoxcamen huan pahtisque. ");
INSERT INTO ncjNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Huan queman Totecohtzin otlan quinnotzalo, Dios otehuicaloc neluicac huan otetlalihque ipan teyejcan. ");
INSERT INTO ncjNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Huan in tetiotlatitlaniluan oyahque tlanonotzahque in yancuic tlahtoli ic nohuiyan. Huan in Totecohtzin oquimpalehuiloc. Oquinmacaloc chicahualistli maquichihuacan tlachiuten tlen niyan aquin oc seya cuali quichihua. Huan ic inon oquinnextililoc nochin tlacamen inon yancuic tlahtoli nochin melahuac. Huan ijcon opanoc.");
INSERT INTO ncjNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Molui tlamelajcan Teófilo, miyacten oquinejque quihcuilosque quen quimelahuanihque tlen opanoc ica tehhuanten huan Totecohtzin Jesucristo. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ijcon otechnextilihque inohque aquin oquitaque queman opeu huan otepalehuihque ica tetlahtoltzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nehhuatl nictemactiya yolic nochin inon ic opeu, huan ic inon nicnehnehuiliya ocachi cuali niteihcuiluis ");
INSERT INTO ncjNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ic momatis nele melahuac in tlen otemachtihque. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ihcuac in Herodes yehhuatl in hueyixtoc den tlali Judea, ocatca se tiopixqui itoca Zacarías, ichantlacahuan Abías. In isihuau itoca Elisabet, ichantlacahuan noyojqui inon tiopixcamen ixuiuten den Aarón. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Inon inehuan molui mahuestique teixpa in Dios huan oquitlacamatiyayahque nochin tlanahuatilten den Totecohtzin. Huan ijcon niyan aquin cuali quintlahtlacoltiya. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Huan ahmo oquipiyaya ipiluan in Elisabet tleca ahhuel oquitayaya quen yehhuan yichihchicahuahque ocatcahque. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Se tonali oquichiuticatca itequiu in Zacarías quen tiopixqui teixpa in Dios ihuan ichantlacahuan. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Quen intlamachilis, oquipanolti in Zacarías ic ocalac ipan in tiopantli den Totecohtzin ic maquitlati in popochtli. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ihcuac otlatlatoya inon popochtli, nochin tlacamen omoyolmachtihtoyahque caltenco. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Oncan in Zacarías oquimonextili se ángel den Totecohtzin ic iyejcan canin quitlatiyahque inon popochtli. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Huan in Zacarías ahmo oquimat tlen quichihuas ic oquitac inon ángel, huan tequin omomouti. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","In ángel oquiluic: ―Ahmo ximomouti, Zacarías. Tleca Dios omocac moyolmachtilis huan mosihuau Elisabet quiitas se iconeu huan tictocahhuis Juan. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Molui tipactos huan miyacten paquisque ica itlacatilis. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tleca mochihuas hueyixtoc teixpa in Dios. Ahmo quionis inon tlayili huan quitequiutilos Itiotonaltzin Dios de achto ic tlacatis. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Quinyolcuepaltiya ica Totecohtzin Dios miyacten den tlacamen den Israel. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Yehhua tlicanas den Totecohtzin huan quipiyas itlamachilis huan ichicahualis quen oquipiyaya in tlayolchicauqui Elías. Ic quinyolcuepa mocahuasque tlamach in tetatahmen inuan ipiluan huan matetlacamatican in retobados. Huan ijcon mayecan ic teselisque in Totecohtzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Oncan Zacarías oquitlahtlani in ángel: ―Tel, ¿quen cuali nicmatis ic inin? Tleca nehhua yinichicahuac huan noyojqui in nosihuau. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Oncan in ángel oquinanquilic: ―Nehhuatl niGabriel, huan nehhuatl in achto tepalehuihcau in Dios. Yehhuatzin onechualtitlaniloc ic manimitzilui inin tlahtoli. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Huan quen ahmo oticneltocac tlen onimitziluic, axan tinontiyas huan ahhuel titlahtos hasta ic tlacatis in moconeu. Huan inin mochihuas ic ahsis itonal. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ic oquichixtoyahque in Zacarías, inon tlacamen quen tel oquimatque tleca ohuehcau ipan inon tiopantli. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ihcuac oquis, in Zacarías ahhuel oquinnotz, huan ijcon oquichiuque cuenta quen oquixpatlac itlahtlen tlaixpa den tiopantli. Huan sa oquinchihuiliyaya senyas tleca onontix. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ic otlan in tonalten den itequiu ipan in tiopantli, in Zacarías oya ichan. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Satepa de inin in Elisabet oquipix iconeu huan ayacmo oquis ichan macuili metztli. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Huan oquihto: ―Huan onechchihualoc Notecohtzin ijquin, ic ayacmo manechixtlasacan in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ipan chicuasin metztli Dios omohualtitlan in ángel Gabriel ipan in altepetl Nazaret den tlali Galilea. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Oya quita se ichpochtli itoca María. Yehhua omotemacatoya ihuan motlalis se tlacatl itoca José, ichichicaixuiu den hueyixtoc David. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","In ángel ocahsito huan oquiluic: ―¡Nimitztlahpalohua quen molui mitzuelitalo in Totecohtzin, quen mohuan ilohuac! Huan Dios mitztiochihualotoc ocachi quen in oc sequin sihuamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ihcuac yehhua oquitac in ángel, quen tel oquimat ica itlahtol huan oquiyolnehnehuilic: ¿Tleca nechtlahpalohua ijquin? ");
INSERT INTO ncjNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Oc sepa oquiluic in ángel: ―Ahmo ximomouti, María, tleca mitzuelitalotoc in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Axan tiquitas moconeu huan tictocahhuis Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Huan yehhua mochihuas hueyixtoc, huan quiluisque Iconetzin Dios aquin huehcapa metztoc. Huan Dios Totecohtzin quichihualos hueyixtoc quen icoltzin David. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Huan quintequiutis in tlacamen den Israel nochipa, huan ahyic quisasque temajco. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Oncan in María oquitlahtlani in ángel: ―Tel, ¿quen niquitas inon conetl, huan ayamo nicpiya notlacau? ");
INSERT INTO ncjNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Inon ángel oquinanquilic: ―Mitzualahsis in Itiotonaltzin Dios huan mitzsehualos quen se mextli ica ichicahualistzin Dios aquin huehcapa metztoc. Huan ic inon, in conetl aquin tlacatis yes tetlapehpenil in Dios huan quitocahhuisque Iconetzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Noyojqui quitas iconeu in mopariente Elisabet, masque yichicahuac. Ijcon tel, aquin oquihtohuayahque ahyic quitas iconeu yiquipixtoc chicuasin metztli. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ica in Dios ahmo oncan tlen ahhuel mochihuas. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Oncan María oquihto: ―Nican nimocahua temajco Notecohtzin, huan mayeto quen onechiluiloc. Huan ijcon oya in ángel. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ipan inon tonalten María oya ihsiu ipan se altepetl ipan in tepetlahtli den Judea. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ihcuac oahsito ichan Zacarías oquitlahpalo in Elisabet. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ic oquicac in Elisabet, in iconeu omolini iihtectla, quen yehhuatl oquitequiutiloc ica Itiotonaltzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Huan ica paquilistli ocualnanquilic: ―In Dios mitztiochihualotoc quen omitztlapehpeniloc inepanco in oc sequin sihuamen huan noyojqui motiochiutoc moconetzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Tel, ¿aquin nehhuatl, ic otinechualitac huan tiinanahtzin Notecohtzin? ");
INSERT INTO ncjNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","San quen otinechtlahpaloc, in noconeu omolini ica paquilistli. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Molui cuali quen oticneltocac in tlen omitziluiloc tleca yau tzonquisa ica in tlen omihto Totecohtzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Oncan oquihto in María: ―Nele nitemahuestiliya Notecohtzin, ");
INSERT INTO ncjNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","huan niyolpaqui ica in Dios Notemaquixticahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Tleca Dios omochiu cuenta ica nehhua aquin temajco, huan quihtosque nochin tlacatl nitlatiochiutli nehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tleca in Dios Hueyicahtzintli onechchihualoc mahuestic; tleca in Itocahtzin tlamahuestilili. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nochipa inca tlocoyalo nochten aquin tetlacamatisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Omonextiloc ocachi chicahuac ica nochin. Ijcon yomotlanque inohque aquin mohueyiliyahque. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Oquinquixtilihque inueilis inon hueyixtoque huan inohque aquin san tlamachten oquinueyililoc. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","In aquin ahmo tlen oquipiyayahque, omomacaque in tlen cuali, huan omoquixtilihque inon ricos. Yehhuan omocauque inyoca. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Omopalehuihque in tetlacahuan den Israel huan ahmo oquinilnamiquilo quen inca tlocoyalo, ");
INSERT INTO ncjNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","quen oquincaquilti in itatahhuan Abraham huan ipiluan nochipa. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Huan María omocau yiyi metztli ihuan Elisabet huan satepa omocuep ichan. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ihcuac oahsic in tonali, otlacat iconeu in Elisabet. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","In ichantlacahuan huan oc sequinten oyahque quitahque queman oquimatque quen molui cuali oquichihuililoc in Totecohtzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Inon conetl oquisenyastihque ipan chicueyi tonali huan quitocahhuisquiyanihque quen itata Zacarías. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Huan inana oquihto: ―Ahmo. Tictocahhuisque Juan. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Huan oquitlahtlanihque: ―¿Tleca ijcon tictocahhuiya? Huan ahmo oncan niyan se mochanihcau ijcon itoca. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Oncan oquitlahtlanihque ica senyas in itata ic quimatisque tlen itoca inon conetl. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","In itata oquitlahtlan tlen ipan quihcuilos, huan oquinihcuiluic: “Itoca Juan.” Huan nochten quen tel oquimatque. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Huan niman oc sepa opeu tlahtohua in Zacarías huan opeu temahuestiliya in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ica inon tlen opanoc, nochten quen tel oquimatque huan nohuiyan omononotzque ipan in tepetlahtli den Judea. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nochten aquin oquimatiyayahque oquiyolnehnehuiliyayahque huan omotlahtlaniyayahque seya huan oc seya: ―¿Tlen iquisca mochihuas inin conetl? Tleca Totecohtzin omotiochiu melahuac. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","In tetata Zacarías oquitequiutiloc ica in Itiotonaltzin Dios huan oquitlahtoltiloc in Dios huan oquihto: ");
INSERT INTO ncjNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Xitemahuestilican in Totecohtzin Dios den Israel. Tleca hualuilohuas ica tehhuanten aquin techantlacahuan huan techmaquixtilos. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Huan techtlocolilos se chicahuac Totemaquixticahtzin. Se de inon ixuihuan David tetlaquehual. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ijcon otechcaquilti inon tetlapehpeniluan tetlayolchicaucahuan de yihuehcau. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Techmaquixtilos ica totecocolihcahuan huan nochin aquin technexicaluiyahque. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Huelica toca tlocoyalos quen oquincaquiltiloc tocoluan, huan ahmo molcahuas ica tlen omotlahtolnamijque. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ijcon oquicaquiltiloc in Dios in tochichicacoltzin Abraham. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Quen huelica techmaquixtilos ica in totecocolihcahuan, matitetlacamatican ahmo ica moucayotl. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Timocahuasque tlamelajcan teixpa huan san Yehhuatzin titetlacamatisque ipan nochin tonemilis. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Huan tehhuatl, noconeu tlasohtli, mitztocahhuisque tlayolchicauqui den Dios Hueyicatzintli. Tleca titlicanas den Totecohtzin huan tiquinnahuatis in tlacamen mateselican. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Tiquinmatiltis in tetlacaicnihuan in temaquixtilistli huan tlapohpoluilistli den intlahtlacoluan. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ijcon toca otlocoyalo huan ic inon axan techtlanextililos quen se yancuic tonali. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ijcon maquinualiquililo in tlanextli in aquin nenticaten ipan in tlayohuilotl huan ipan in ixpoliucayotl. Huan techuicalos ipan in ohtli tlamach. ");
INSERT INTO ncjNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Huan omoscaltihticatca in conetl huan onemiyaya ipan inon acahualtlahtli hasta ic omotenextili ica in tlacamen den Israel. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ipan inon tonalten in hueyixtoc Augusto oquintequiuti mamotocahtlalican de nochin tlalticpactli. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Inin achto tlacapohualistli oquichiuque ihcuac Cirenio hueyixtoc den tlali Siria. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nochten huelica chicoquisasque ic motocahtlalisque ipan inaltepeu. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Huan ic inon, José oquis ipan in altepetl Nazaret, itlatilanal Galilea, huan oya ipan in altepetl Belén, itlatilanal Judea, canin otlacat David, tleca de ompa ixuiutli in José. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Oya ihuan in María motocahtlaliyahque Belén. In María yomotemacatoya ihuan motlalis José, huan María yipilua. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Ompa oquitac in achto iconeu, huan oquipihpiqui ica in tatapahtli, huan oquitecac canin otlacuayahque in yolcamen. Tleca ahmo oquipiyaya canin yesque huan ic inon ipan se mesón. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ahmo huehca den Belén ocatcahque sequin paxtolten nochin yohuali ompa oquinixpiyayahque in icalnelohhuan. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Oquinmonextili se ángel den Totecohtzin, huan inahuac yehhuan opetlan se tlanextli den Totecohtzin. Huan yehhuan omomoutihque. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Huan in ángel oquiniluic: ―Ahmo ximomoutican. Namechualiquiliya se cuali tlahtoli, huan quimpacmacas nochten in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Axan ipan ialtepeu David otlacat se Namotemaquixticahtzin, Yehhuatzin in Cristo Totecohtzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Huan quen nanquineltocahque, nancahsitihue in conetl pihpictos ica in tatapahtli huan huetztos canin tlacuahque in yolcamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Huan niman inahuac inon ángel ohualnesque miyac in ángeles aquin temahuestiliyahque in Dios huan oquihtohuayahque: ");
INSERT INTO ncjNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Xitemahuestilican in Dios aquin ilohuac huehcapa, huan nican tlalticpac mayecan tlamach nochin tlacamen aquin quinuelitalo! ");
INSERT INTO ncjNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Oncan ihcuac oyahque neluicac in ángeles, in paxtolten opeuque moluiyahque se huan oc seya: ―Tiyasque in Belén. Tiquitasque tlen opanoc quen Totecohtzin otechmatiltiloc. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Huan oyahque ihsiu, ocahsitohque in María huan in José huan noyojqui in conetl ohuetztoya canin tlacuahque in yolcamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ihcuac oquitaque in conetl, otlanonotzque ica in tlen oquiniluic in ángel. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Huan nochten in aquin oquicajque quen tel oquimatque ica in tlen omononotzque. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Huan María oquieu ipan iyolo nochin tlen oquicac huan oquiyolnehnehuili ica yehhua. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Huan ijcon in paxtolten ic omocuepque, temahuestilihtihue in Dios ica nochin in tlen oquicajque huan oquitaque, tleca nele omochiu in tlen oquiniluic inon ángel. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ipan chicueyi tonali oquisenyastihque inon conetl huan oquitocahhuihque Jesús, ijcon quen in ángel oquiluic in María, masque ayamo oquipiyaya inon iconeu. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ihcuac yomohuelmat in María, quen oquihto itlanahuatil Moisés, ocuicaque in conetl ipan in altepetl Jerusalén ic tetemactiliyahque in Tohueyitahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Inin oquichiuque quen ca tlahcuiloli in itlanahuatiltzin Totecohtzin: “Nochin telpocatl aquin achto tlacatis yes tetlapehpenil ica Totecohtzin.” ");
INSERT INTO ncjNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ic inon oyahque quitlocoliyahque in ome huilotl, quen quihtohua itlanahuatiltzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ipan inon tonalten ocatca nepa Jerusalén se tlacatl itoca Simeón. Inon tlacatl molui cuali huan otemahuestiliyaya in Dios huan oquichixtoya in tlamaquixtilistli den tlacamen den Israel. Huan in Itiotonaltzin Dios ihuan oilohuac. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Huan oquimatiltihtoya quen ayamo miquis ic teitas in Cristo aquin Tohueyitahtzin mohualtitlanis. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Inon tlacatl oquititlaniloc in tiopan in Itiotonaltzin Dios, maquiita ihcuac in itatahhuan inon conetl Jesús ocualicahque maquichihuilican quen ca ipan in tlanahuatili. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Huan Simeón oquinapalo in conetl Jesús, huan otemahuestili in Dios, huan oquihto: ");
INSERT INTO ncjNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","―Notecohtzin, yicuali manechtlapohpoluilo ic manimiqui, tleca yotzonquis in tlen onechcaquiltihque nehhuatl nitetlaquehual. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Yoniquitac aquin yes Totemaquixticahtzin, ");
INSERT INTO ncjNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","in aquin omohualtemacti iixpa nochin tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yehhuatzin in quen se tlanextli ica inohque aquin ahmo tlacamen den Israel huan quinueyiquixtis ichantlacahuan. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José huan inana Jesús quen tel oquimatque ica in tlen quihtohua Simeón ica inconeu. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Inon Simeón oquintiochiu huan oquiluic María inana in Jesús: ―Ica inin moconeu miyac ichanihcahuan quixtlasasque huan mopolosque. Huan sequin quiselisque huan momaquixtisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Huan ica tlen quichihuilisque tehhuatl mitzyolpolos. Ijcon nesis in tlen sehse tlacatl quiyolnehnehuiliya ica in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Noyojqui ompa ocatca se sihuatl tlayolchicauqui itoca Ana, huan inon ichpoch in Fanuel, den ololi Aser. Inon Ana molui chicahuac. Huan ihcuac omonamicti oc ichpochtli huan chicome xiupa ihuan ocatca itlacau. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Huan axan viuda quipiya naupohuali huan nahue xihuitl. Ahyic oquisayaya den tiopan. Quen tlahca huan quen tlayohua otemahuestiliyaya in Totecohtzin ica in yolmachtilistli huan mosahua. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Inon Ana san ohualmonextihtehuac, huan ic tetlasohcamatis in Dios, opeu quinnonotza ica in conetl Jesús nochten in aquin oquichixtoyahque in temaquixtilistli den Jerusalén. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Oquichiuque nochin quen ca in itlanahuatiltzin Totecohtzin, huan omocuepque Galilea in José huan María ihuan iconeu ipan inaltepeu Nazaret. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Huan ic omoscaltihticatca, inon conetl Jesús ochicautaya huan ocachi oixtlamautaya, huan Dios omotiochihuayaya ocachi. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","In itatahhuan oyahyaya nochin xihuitl Jerusalén ipan in pascuahiluitl. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ihcuac Jesús oquiahxilti mahtlactli huan ome xihuitl nochten oyahque Jerusalén, quen nochipa oquichiuque ica intlamachilis. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ihcuac otlan inon iluitl, omocuepque inon itatahhuan. In telpocatl Jesús omocau Jerusalén, niyan ic oquimatque in itatahhuan. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","In itatahhuan oquinehnehuiliyayahque quen Jesús inuan ohualaya oc sequin tlacamen, huan ijcon oquichiuque se tonali onehnenque. Huan ic tiotlac oquintlahtlanihque in ichanihcahuan huan in oc sequin ichantlacahuan. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ahmo ocahsique inon telpocatl Jesús. Oncan omocuepque Jerusalén quitemohua. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ipan yiyi tonali ocahsitohque ipan in tiopantli inuan in tlamachtiyanimen den tlanahuatilten, huan ijcon oquincacticatca huan oquintlahtlanihtoya. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Huan nochten in aquin oquicaquiyayahque quen tel oquimatiyayahque ica itlanehnehuilis quen oquinnanquiliyaya. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ihcuac itatahhuan oquitaque, quen tel oquimatque, huan inana oquiluic: ―¿Tleca ijconon titechchihua? Tehhuanten tequin otimitztemohque. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Oncan inon telpocatl Jesús oquiniluic: ―¿Tleca nannechtemohuahque? ¿Tlen, ahmo nanquimatihque huelica nicchihuas in tequitl den Nohueyitahtzin? ");
INSERT INTO ncjNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Huan yehhuan ahmo oquinehnehuilihque tlen oquiniluic. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Oncan inuan omocuep ipan inaltepeu Nazaret, huan ijcon oquintlacamatiyaya. In inana nochin oquitlaliyaya ipan iyolo. ");
INSERT INTO ncjNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ic ocachi omoscaltihtaya in telpocatl Jesús, huan ic ocachi oixtlamautaya. Huan ocachi oquihuelitaloc in Dios huan nochin tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Ipan caxtoli xihuitl itequipa in Tiberio César, in Juan iconeu Zacarías oquicac in itlahtoltzin Dios nepa ipan in acahualtlahtli. Ihcuac Poncio Pilato tequihua den tlali Judea, huan Herodes yehhua hueyixtoc den tlali Galilea, huan icniu Felipe yehhua hueyixtoc den tlali Iturea huan Traconite, huan in Lisanias yehhua hueyixtoc den tlali Abilinia. In Anás huan Caifás, yehhuan in achtohque tiopixcamen ipan inon tonalten. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ic opanotaya in Juan inahuac in atentli Jordán, oquiniluihtaya: ―Ximoyolcuepacan ica Dios mamechtlapohpoluican namotlahtlacol huan namechcuatequis. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Inin opanoc quen in tlayolchicauqui Isaías oquihcuilo: Quicaquisque quen quihtohtas inon tlanahuatili ipan in acahualtlahtli: “Hualuilohuas Totecohtzin. Ximoyectlalican ica namoyolo ic nanteselisque, ijcon quen nanquiyectlalisque in ohtli ic hualahxihuas in Totequihuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Quitlaltemisque in tlacoyocten. Quinixmanasque in tepemen huan in tlachquilten. Quimelahuasque in tlen cueltic ohtli. Quixmanasque in ohtli ic maye parejo. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Huan nochin tlacamen quitasque in Totemaquixticahtzin tlen techualtitlanililos in Dios.” ");
INSERT INTO ncjNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ihcuac ochocoquisayayahque in tlacamen, maquincuatequi in Juan, yehhuan oquiniluiyaya: ―¡Namehhuan in ololi den ome inxayac! Tel, ¿aquin omechnahuati ic nanmaquisasque ipan in hueyi tlapanolistli den Dios tlen mechualahsis? ");
INSERT INTO ncjNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Xicchihuacan tlen cuali huan ijcon maquitacan quen onanmoyolcuepque. Huan ahmo ximoyolchicahuacan namehhuan ic nanquihtosque: “Tehhuanten tiixuihuan in Abraham”, tleca namechiluiya in Dios cuali mochihuas ixuihuan Abraham inin temen. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","In tetzahuitl ayacmo huehca. Quen aquin yau coutequi ipan in tlamiloli ica in tlen ahmo quitemacas cuali itlaquilyo. Ijconon quitohuetzosque ipan in tletl. Ijcon nampolihuisque in tlahmo nanmochihuasque cuenta. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Huan ijcon otlahtlanque: ―Tel, ¿tlen ticchihuasque? ");
INSERT INTO ncjNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan oquinnanquilic: ―In aquin quipiya ome itlaquen, quimacas seya in aquin ahmo tlen quipiya. Huan aquin quipiya itlacual quixeluis in aquin ahmo quipiya tlen. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Noyojqui ohualahque sequin renderos ic mocuatequinihque huan oquitlahtlanihque in Juan: ―Tlamachtiyani, tel, ¿tlen ticchihuasque tehhuanten? ");
INSERT INTO ncjNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","In Juan oquiniluic: ―Ahmo ocachi xiquincobrarocan quen in tlanahuatili quihtos. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Huan noyojqui sequin soldados otlahtlanque: ―Huan tehhuanten, tel, ¿tlen ticchihuasque? Huan oquinnanquilic: ―Ahmo aquin tlen xicuilican ic nanquinteluisque niyan ica istlacatilistli ica tlen ahmo quichiutoc, huan xipactocan ica namotlaxtlahuil. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","In tlacamen omochixticatcahque tla cana in Juan yehhuatl yesquiyani in Cristo. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","In Juan oquiniluic nochten: ―Nehhuatl melahuac namechcuatequis ica atl. Huan hualuilohuas seya aquin mechcuatequis ica in Itiotonaltzin huan ica tletl. Yehhuatzin mopiyas ocachi chicahualistli quen nehhuatl, huan nehhuatl ahmo tlen noquisca niyan ic nimochihua tlapalehuiyani. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Huan tla ilohuas quen in aquin quiquitzquihtoc in pala ic mochipahuas in trigo huan mosecnintlalis in itlahsolyo. Huan motlalis in trigo canin moehuas huan in itlahsolyo motlatis ipan in tletl tlen ahyic sehui. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Huan ica miyac tlahtolten ijcon oquinnextili in Juan, huan oquincaquiltiyaya in cuali tlahtoli ica tlen hualas. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Noyojqui oquicaquilti in hueyixtoc Herodes ica inon sihuatl Herodías quen oquisihuacuili in icniu Felipe. Huan noyojqui ica in oc sequin tlen ahmo cuali quichiutoc. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","In Herodes, ic quicaquisquiyani, oquichiu oc se ahmo cuali, quen oquitzacu in Juan ipan telpiloyan. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Achto de inin ic quitzacuasque, in Juan otlacuatequihtinemiyaya ica nochin tlacamen. Noyojqui in Jesús otecuatequi, huan ic omoyolmachtilohticatca in Jesús, ohualtemoc den neluicac in Itiotonaltzin. Nesi quen se huilotl ipan Yehhuatzin huan omocac se tlahtoli tlen oquihto: ―Tehhuatl notlasohconeu huan molui nipactoc ica tehhua. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","In Jesús omopiyaya cana sempohuali huan mahtlactli xihuitl ihcuac omopehualti tetequiu. Ijcon oquinehnehuilihque iconeu in José. Huan in José yehhua iconeu in Elí. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Huan in Elí yehhua iconeu in Matat, huan in Matat yehhua iconeu in Leví. Huan in Leví yehhua iconeu in Melqui. Huan in Melqui yehhua iconeu in Jana. Huan in Jana yehhua iconeu in José. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Huan in José yehhua iconeu in Matatías. Huan in Matatías yehhua iconeu in Amós. Huan in Amós yehhua iconeu in Nahum. Huan in Nahum yehhua in iconeu in Esli. Huan in Esli yehhua iconeu in Nagai. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Huan in Nagai yehhua iconeu in Maat. Huan Maat yehhua iconeu in Matatías. Huan in Matatías yehhua iconeu in Semei. Huan in Semei yehhua iconeu in José. Huan in José yehhua iconeu in Judá. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Huan in Judá yehhua iconeu in Joana. Huan in Joana yehhua iconeu in Resa. Huan in Resa yehhua iconeu in Zorobabel. Huan in Zorobabel yehhua iconeu in Salatiel. Huan in Salatiel yehhua iconeu in Neri. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Huan in Neri yehhua iconeu in Melqui. Huan in Melqui yehhua iconeu in Adi. Huan in Adi yehhua iconeu in Cosam. Huan in Cosam yehhua iconeu in Elmodam. Huan in Elmodam yehhua iconeu in Er. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Huan in Er yehhua iconeu in Josué. Huan in Josué yehhua iconeu in Eliezer. Huan in Eliezer yehhua iconeu in Jorim. Huan in Jorim yehhua iconeu in Matat. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Huan in Matat yehhua iconeu in Leví. Huan in Leví yehhua iconeu in Simeón. Huan in Simeón yehhua iconeu in Judá. Huan in Judá yehhua iconeu in José. Huan in José yehhua iconeu in Jonán. Huan in Jonán yehhua iconeu in Eliaquim. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Huan in Eliaquim yehhua iconeu in Melea. Huan in Melea yehhua iconeu in Mainán. Huan in Mainán yehhua iconeu in Matata. Huan in Matata yehhua iconeu in Natán. Huan in Natán yehhua iconeu in David. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Huan in David yehhua iconeu in Isaí. Huan in Isaí yehhua iconeu in Obed. Huan in Obed yehhua iconeu in Booz. Huan in Booz yehhua iconeu in Salmón. Huan in Salmón yehhua iconeu in Naasón. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Huan in Naasón yehhua iconeu in Aminadab. Huan in Aminadab yehhua iconeu in Aram. Huan in Aram yehhua iconeu in Esrom. Huan in Esrom yehhua iconeu in Fares. Huan in Fares yehhua iconeu in Judá. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Huan in Judá yehhua iconeu in Jacob. Huan in Jacob yehhua iconeu in Isaac. Huan in Isaac yehhua iconeu in Abraham. Huan in Abraham yehhua iconeu in Taré. Huan in Taré yehhua iconeu in Nacor. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Huan in Nacor yehhua iconeu in Serug. Huan in Serug yehhua iconeu in Ragau. Huan in Ragau yehhua iconeu in Peleg. Huan in Peleg yehhua iconeu in Heber. Huan in Heber yehhua iconeu in Sala. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Huan in Sala yehhua iconeu in Cainán. Huan in Cainán yehhua iconeu in Arfaxad. Huan in Arfaxad yehhua iconeu in Sem. Huan in Sem yehhua iconeu in Noé. Huan in Noé yehhua iconeu in Lamec. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Huan in Lamec yehhua iconeu in Matusalén. Huan in Matusalén yehhua iconeu in Enoc. Huan in Enoc iconeu in Jared. Huan in Jared yehhua iconeu in Mahalaleel. Huan in Mahalaleel yehhua iconeu in Cainán. ");
INSERT INTO ncjNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Huan in Cainán yehhua iconeu in Enós. Huan in Enós yehhua iconeu in Set. Huan in Set yehhua iconeu in Adán. Huan in Adán yehhua iconeu in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","In Jesús otetequiutiloc in Itiotonaltzin Dios huan otecuep ipan in atentli Jordán. Huan inon Itiotonaltzin otehuicac ipan in acahualtlahtli. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Huan ompa oilohuayaya ompohuali tonali huan in ahmo cuali tlacatl oteyoltilan ic tecuepani ahmo cuali. Huan ahmo tlen omocua ipan inon ompohuali tonali huan ijcon omayanilo. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Oncan in ahmo cuali tlacatl oteiluic in Jesús: ―Tla nele titeconeu Dios, xictequiuti inin tetl mamocuepa in pantzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús omonanquilic: ―In Itlahcuiloltzin quihtohua: “Ahmo san ica itlacual nemis in tlacatl, tlahmo noyojqui ica nochin tlahtoli tlen in Dios mihtohua.” ");
INSERT INTO ncjNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Niman in ahmo cuali tlacatl otehuicac ipan se tepetl huan quen tel oteixpatlatehuac ica nochin altepemen den tlalticpac. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Huan in ahmo cuali tlacatl oc sepa oquiteluic: ―Nimitzmacas nochin chicahualistli huan mahuestilistli de nochin altepemen den tlalticpactli. Cuali nicmacas in aquin nicnequis tleca nicselihtoc nochin. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Tla timotlancuaquetzas ic tinechmahuestilis, nochin mohuaxcan yes. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Huan Jesús omonanquilic: ―In Itlahcuiloltzin quihtohua: “Xitemahuestili in Dios huan san Yehhuatzin xitetlacamati.” ");
INSERT INTO ncjNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Satepa in Jesús queman omomat ipan in altepetl Jerusalén quen otehuicac in ahmo cuali tlacatl. Huan otetlehcahui itzoncuac in hueyi tiopantli huan oteiluic: ―Tla nele ticoneu Dios, xipatlani. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tleca in Itlahcuiloltzin quihtohua: In Dios motequiutisque in ángeles ic mitzitasque. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ica inman mitztzacuilisque, ic ahmo mitzxococos niyan se tetl. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús omonanquilic: ―Noyojqui quihtohua in Itlahcuiloltzin: “Ahmo teca ximahuilti in Motecohtzin Dios.” ");
INSERT INTO ncjNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Huan ihcuac in ahmo cuali tlacatl ayacmo ocahsic quen teyoltilanas in Jesús, otzinquis de Yehhuatzin se quesqui tonali. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","In Jesús omocuepaloc Galilea ica miyac ichicahualis in Itiotonaltzin Dios, huan oquimautoyahque ica Yehhuatzin ipan in altepemen den Galilea. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Otlamachtilohuaya ipan in tiopanten de inon altepemen, huan nochten otemahuestiliyayahque. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Oncan in Jesús oahxihuato ipan tealtepeu Nazaret canin oyolihuac. Ipan in tonali den nesehuilistli ocalacohuac ipan in tiopantli, ijcon oquimautoyahque, huan omoquetzaloc ic omopohuilihque in tlahcuilolten. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Otemacaque in itlahcuiloluan in tlayolchicauqui Isaías, huan ihcuac omixtlapo, omahsic canin oihcuiliutoya ica Yehhuatzin: ");
INSERT INTO ncjNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","In Itiotonaltzin Notecohtzin nopan ca, tleca nechtocahhuilotoc ic niquinnonotzas ica in cuali tlahtoli inon prohues. Huan ic niquinyolchicahuas in aquin tlamohsihuilten. Huan niquincaquiltis in tlahtoli de temaquixtilistli inon tlahtlacolyohque, huan niquintlachiyaltis in ixpatzacten. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Huan ic niquincaquiltis quen yoahsico in tonalten quen quintiochihualos in Totecohtzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Oncan Jesús omoixmimilo in amatl huan omomacac in tlachixqui den tiopan huan Yehhuatzin omotlaliloc. Huan nochten aquin ocatcahque ipan in tiopantli oteitzticatcahque. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yehhuatzin opehualoc tlahtolo huan omihto: ―Axan yotzonquis inin itlahtoltzin namoixpa. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nochten oyectlahtohuayahque ica in Jesús huan quen tel oquimautoyahque ica in cualtzin tlahtoli tlen omihtohuaya. Huan omotlahtlaniyayahque ic yehhuan: ―Tel, ¿ahmo yehhua inin iconeu in José? ");
INSERT INTO ncjNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","In Jesús omoluihque: ―Nele namehhuan nannechiluisque inin tlahtoli: “Tlapahtiyani, ximopahti san tehhua mosel”; tlen quihtosnequi: “Oticajque ica tlen oticchiu Capernaum. Noyojqui xicchihua nican ipan moaltepeu.” ");
INSERT INTO ncjNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Oncan ocachi omoluihque in Jesús: ―Ic nele namechiluiya, niyan se tlayolchicauqui quiselisque yec ipan ialtepeu. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Namechyequiluiya quen ipan in tonalten den tlayolchicauqui Elías ocatcahque miyac viudas ipan in altepemen den Israel. Inon tonalten ahmo oquiyau yiyi xihuitl huan tlahco, huan ocatca apistli de nochin altepemen. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Masque ijconon, in Dios ahmo omotitlan in Elías ica niyan seya de inon viudas ichantlacahuan ic quimpalehuini, tlahmo ica inon aquin ochantiyaya Sarepta, inahuac in altepetl Sidón. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Noyojqui ipan in altepemen den Israel ocatcahque miyac cocoxcamen ica in pahpalanilistli ipan in tonalten den tlayolchicauqui Eliseo. Huan niyan aquin opahtic de yehhuan, san in Naamán, inon chani den tlali Siria. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ic oquicajque tlen oquiniluiloc, nochten aquin ocatcahque ipan in tiopantli molui ocualanque. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ohualejque huan otequixtihque in Jesús den altepetl huan otehuicaque itentla in tepetl. Inon altepetl ca icuac inon tepetl huan ompa tetepehxihuinihque. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Huan Jesús opanoloc inepanco yehhuan huan ohuilohuac. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Oncan Jesús ohuilohuac Capernaum, se altepetl den Galilea, huan ompa opeu monextiliyahque in tlacamen ipan in tonali den nesehuilistli. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Quen tel oquimatiyayahque ica tlen omonextiliyayahque, tleca otlahtolohuaya ica in chicahualistli den tequihuahyotl. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ipan in tiopantli ocatca se tlacatl aquin oquiyolquitzquihtoya in ahmo cuali yehyecatl, huan oquihto: ");
INSERT INTO ncjNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―¡Xitechcahua! Tel, ¿tleca timocalactiya ica tehhuan, Jesús den Nazaret? Tel, ¿tihuitz ic titechpolos? Nehhua nimitzixmati huan nicmati titetlapehpenil in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","In Jesús omoixnamic in ahmo cuali yehyecatl huan omoluic: ―¡Ximocahua huan xicahua inin tlacatl! Oncan in ahmo cuali yehyecatl oquitlaluihtec in tlacatl inixpa in tlacamen. Huan ahmo tlen oquichihuili huan oquis de yehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Inon tlacamen omomoutihque huan omoluihque se huan oc seya: ―Tel, ¿tlen tlahtoli inin? ¡Inin tlacatl quintequiutiya in ahmo cuali yehyecamen ica tequihuahyotl huan chicahualistli, huan quisahque! ");
INSERT INTO ncjNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Huan omononotzayayahque ica Jesús nohuiyan ipan in altepemen. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Oncan Jesús oquixohuac den tiopantli huan ohuilohuac ichan Simón. In imonantzin Simón omococohtoya ica in totonque, huan otetlatlautihque in Jesús ic mamopahti. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","In Jesús omixpacholoc iixpa huan omixnamic in totonque huan oquis. Huan niman omeu huan oquintlamacac. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ic tlapoyaucan nochten in aquin quipiyahque in cocoxcahuan ica san tlen cocolisten otehualiquilihque in Jesús. Huan Yehhuatzin omomachilihque ica in teman huan ijcon omopahtihque. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Noyojqui oquinixtohuetzoloc in ahmo cuali yehyecamen ica miyacten, huan otzatziyayahque huan oquihtohuayahque: ―¡Tehhuatl ticonetzin in Dios! Huan Jesús omoixnamijque in ahmo cuali yehyecamen huan ahmo omocauque matlahtocan, tleca yehhuan oquimatiyayahque Yehhuatzin in Cristo. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ic otlatuic, in Jesús oquixohuac den altepetl huehca tlachicoyan. Huan in tlacamen otetemohque huan oteahsitohque canin oilohuaya. Huan oquinequiyayahque tetzecosque. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Huan Jesús omoluihque: ―Nicpiya tlen niquinnonotzas in cuali tlahtoli ica canin tlatequiutilo in Dios ipan oc sequin altepemen, tleca ijcon onechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Huan ijcon Jesús otlanonotzalohtinemiyaya ipan in tiopanten den tlali Galilea. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Se tonali in Jesús oilohuaya itentla in mar den Genesaret huan ompa oteahsitohque miyac tlacamen, hasta otepitzinihque, tleca oquinequiyayahque quicaquisque in itlahtoltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","In Jesús omotaque ome barcos inyoca atlatentli. In michtemohuanimen oquistoyahque ic quipacahque inmatlau. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Oncan Jesús otlehcoloc ipan seya, tlen iyaxca in Simón, huan omotlatlauti mayau chihton canin ahuehcatla. Ihcuac oquitzinquixti atlatentli, niman Jesús omotlaliloc huan opehualoc quinnextililo de ompa. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ihcuac otlan tlahtolo, omoluic in Simón: ―Xicnehnemiti in barco canin ocachi huehcatla huan xictlasacan namomatlau ic nanmichtemosque. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","In Simón otenanquilic: ―Tlamachtiyani, nochin yohuali tinemihque huan ahmo tlen ticahsitohque. Tla ijcon monequi, tiyasque oc sepa tictlasasque in matlatl. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ihcuac ijcon oquichiuque, Simón ihuan itlaquehualuan oquinquitzquihque miyac michten huan opeuca tzomoni in matlatl. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ic inon oquinnahuatihque in aquin ihuan tequitihque ic mahualacan quimpalehuican ica in oc se barco. Yehhuan ohualahque huan oquintemiltihque in ome barcos hasta omatocanihque. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ic oquitac inin, Simón Pedro omotlancuaquetz teixpa in Jesús huan oteiluic: ―Manechcahualo, Notecohtzin, tleca nitlahtlacolyo. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Huan Simón quen tel oquimat, huan noyojqui in oc sequinten aquin ihuan ocatcahque, ica in tlen oquimpanoc. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Noyojqui quen tel oquimatque in Jacobo huan Juan, ipiluan Zebedeo, aquin ihuan otequitiyayahque in Simón. Huan omoluic in Simón: ―Ahmo ximomouti. De axan tiquinyolchicahuas in tlacamen ic manechneltocacan. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ihcuac oquinquixtihque atlatentli in barcos, oquincauteuque huan otecuitlapanuihque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ihcuac in Jesús oilohuaya ipan se altepetl, oteahsito se cocoxqui ica in pahpalanilistli. Ic oteitac in Jesús, omixtocac ic omotlancuaquetz teixpa huan otetlatlautic: ―Notecohtzin, tla nechpahtilos. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Oncan Jesús omomachili ica in teman huan omoluic: ―Tleca in tlahmo. Xipahti. San ic omihto, oquis inon cocolistli. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Oncan Jesús omotequiuti ahmo maquilui niyan aquin. Huan omoluic: ―San tiyas iixpa in tiopixqui maquita tla nele otipahtic huan tictemactis quen motetlahpalol in tlen mitztequiutis in itlanahuatil Moisés, maquichihuacan cuenta in tlacamen quen otipahtic, huan ijcon timocahua chipahuac. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Huan in tetenehualoca in Jesús ocachi ohueyixtaya huan omosentlaliyayahque miyacten ic tecaquisque huan ic mamopahtican oc sequin cocoxcamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Huan Jesús omosecninuilohuaya canin ahyac aquin, huan ompa omoyolmachtilohuaya. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ipan se tonali Jesús otlamachtilohtoya, huan ompa ocatcahque sequin fariseos huan sequin tlamachtiyanimen den tlanahuatili, inohque aquin ohualahque ic nohuiyan den tlali Galilea huan Judea huan in hueyi altepetl Jerusalén. Huan ica techicahuilis in Dios oquimpahtiloc in cocoxcamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Oncan oahsitohque sequin tlacamen quimamahtihue ipan tlapechtli se tlacatl aquin omocoupitzquetzticatca, huan oquinequiyayahque quicalaquisque teixpantinihque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Huan ahmo ocahsique canic calaquisque tleca otentoyahque miyac tlacamen. Oncan otlehcohque itzoncuac in cali huan oquicuaxitinihque. Huan ompic oquitemohuihque in cocoxqui ijcon ica icoutlapech inepanco in tlacamen canin oilohuaya in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ihcuac in Jesús omoyolitaque quen oteneltocaque, oquiluiloc in cocoxqui: ―Tlacatl, motlahtlacoluan nimitztlapohpoluihtoc. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Oncan in tlamachtiyanimen den tlanahuatili huan in fariseos opeuque monehnehuiliyahque: “Tel, ¿aquin inin tlacatl opeu teixnamiqui in Dios ica itlahtol? Niyan aquin cuali tetlapohpoluis tlahmo san Yehhuatzin Dios.” ");
INSERT INTO ncjNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Huan Jesús omoyolnehnehuilihtoya ica yehhuan huan omoluihque: ―¿Tleca nanquiyolnehnehuiliyahque ijcon? ");
INSERT INTO ncjNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Quen nanquimatihque tla ahhuel nictlapohpoluis? Tla cuali nicpahtis, no cuali nictlapohpoluis. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Cuali tel, niyau namechnextili quen nehhua aquin Nitetiachicau ica nochin tlacatl nicpiya tequihuahyotl nican tlalticpac ic namechtlapohpoluis namotlahtlacoluan. Oncan omoluic in tlacatl aquin omocoupitzquetzticatca: ―Ximoquetza huan xicana motlapech huan xiyau mochan. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Niman inon tlacatl omoquetz huan oquian in itlapech huan oya ichan temahuestilihtiu in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nochten quen tel oquimatque huan otemahuestilihque in Dios. Huan ica moucayotl oquihtohque: ―Axan otiquitaque in tlen ahhuel quichihuas san aquin. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Satepa de inin, in Jesús oquixohuac huan omotac se rendero itoca Leví. Oyehuatoya canin otlacobrarohuaya, huan Jesús omoluic: ―Xinechcuitlapanui. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Oncan Leví omoquetz, huan otlacautehuac huan otecuitlapanuic in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Satepa in Leví oquichiu se iluitlacuali ichan ica in Jesús, huan ocatcahque miyac in renderos huan oc sequin tlacamen inuan oyehuatoyahque iixpa in mesa. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Huan sequin fariseos inuan in tlamachtiyanimen den tlanahuatili opeuque inca tlahtohuahque in tetlamachticahuan in Jesús huan oquintlahtlanihque: ―Tel, ¿tleca nanmonelohuahque huan nantlacuahque inuan in renderos huan in tlahtlacolyohque? ");
INSERT INTO ncjNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","In Jesús omonanquilihque: ―In aquin yichihchicahuaque huan cualten ahmo quinequihque in tlapahtiyani, tlahmo san in cocoxcamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ahmo onihuala ica inon cualten, tlahmo ica in tlahtlacolyohque, huan ijcon mamoyolcuepacan. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Oncan in fariseos otetlahtlanihque in Jesús: ―Tel, ¿tleca ahmo nanmosahuahque huan nanmoyolmachtiyahque quen in itlamachticahuan in Juan huan de tehhuan? ");
INSERT INTO ncjNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","In Jesús omonanquilihque: ―Nehhuatl quen se mosihuautiyani. Tel, ¿cuali mosahuasque ihcuac inuan yes in itetlatlautiluan in mosihuautiyani? Nele ahhuel, tleca pactoque ica inon mosihuautilistli. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ahsiquiu in tonali queman quincuilisque in mosihuautiyani. Oncan queme, cuali mosahuasque. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Noyojqui omotlalilihque tlen ic maquichihuacan cuenta: ―Notlahtol quen in yancuic tlaquemitl. Niyan aquin quitzomonis in yancuic tlaquemitl ic quitlatlamanis in yihuehcau tlaquemitl. Tla ijcon quichihuas, quitlasohchihuas in yancuic tlaquemitl. Huan noyojqui ahmo quicualnextiya in yihuehcau tlaquemitl. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Noyojqui notlahtol quen yancuic tlayili. Huan no ahmo quiehuasque in yancuic tlayili den uva ipan in yihuehcau cuitlaxtli. Tla ijconon quichihuasque, inon yancuic tlayili quitzomonis inon cuitlaxtli huan ijconon polihuis nochin. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Huan ic inon mamotlali in yancuic tlayili ipan in yancuic cuitlaxtli. Huan ijconon nochin in ome tlayequeutli yesque. ");
INSERT INTO ncjNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","In aquin quioni in chicahuac tlayili ahmo niman quinequis in yancuic, tleca quihtos: “In tlen chicahuac ocachi cuali.” ");
INSERT INTO ncjNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ipan se tonali den nesehuilistli opanolotaya in Jesús ipan in tlamilolten, huan in tetlamachticahuan oquimatoxontayahque in trigo. Huan niman oquimatlapantayahque huan oquicuahtayahque. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Oncan sequin fariseos oquintlahtlanihque: ―Tel, ¿tleca ijconon nanquichihuahque quen ahmo techcahualihtohque ticchihuasque ipan in tonali den nesehuilistli? ");
INSERT INTO ncjNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","In Jesús oquinnanquililoc: ―Tel, ¿ahmo nanquipoutoque in tlen oquichiu in David ipan se tonali queman yehhuatl ihuan itenonotzcahuan oapismijque? ");
INSERT INTO ncjNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ocalac ipan icaltzin Dios huan oquian in mahuestic pantzin. Huan oquicua huan noyojqui oquinmacac in tlacamen aquin ihuan ocatcahque, masque san yeh in tiopixcamen quicuasquiyanihque inon pantzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Noyojqui oquiniluiloc: ―Nehhuatl aquin Nitetiachicau ica nochin tlacatl noyojqui nicpiya tequihuahyotl ica in tonali den nesehuilistli. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ipan oc se tonali den nesehuilistli in Jesús ocalacohuac ipan in tiopantli huan opehualoc tlamachtilo. Huan ompa ocatca se tlacatl mapitzahuac. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Huan sequin tlamachtiyanimen den tlanahuatili huan sequin fariseos otepihpiyayayahque in Jesús in tla mopahtis ipan inon tonali den nesehuilistli. Huan ijconon oquitemohque tlen ic tetemactisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Huan Yehhuatzin omomautoya tlen oquinehnehuilihque, huan omoluic inon tlacatl aquin mapitzahuac: ―¡Ximoquetza! Huan inon tlacatl ijconon oquichiu. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Oncan Jesús oquiniluiloc in oc sequinten: ―Niyau namechtlahtlani se tlahtoli. Tel, ¿tlenon cuali ticchihuasque ipan in tonali den nesehuilistli? ¿In tlen cuali noso in tlen ahmo cuali? ¿Tiquinmaquixtisque noso tiquincahuasque mapolihuican? ");
INSERT INTO ncjNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Oncan Jesús oquinitaloc in aquin oteyehualohtoyahque, huan oquiluiloc inon tlacatl: ―Ximasohua. Huan ijcon oquichiu ic opahtic in iman. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Huan sequin tequin ocualanque, huan opeuque motlahtlaniyahque quen tecocolisque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ipan inon tonalten in Jesús ohuilohuac ipan se tepetl ic moyolmachtilo, huan se yohual omoyolmachtilotoya ica in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ihcuac otlatuic omonotzque in tetlamachticahuan huan omotlapehpenihque in mahtlactli huan ome de yehhuan aquin omotocahhuihque tetiotlatitlaniluan. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Huan yehhuan inihque; Simón, aquin noyojqui omotocahhui Pedro, huan Andrés in icniu Simón huan Jacobo huan Juan huan Felipe huan Bartolomé ");
INSERT INTO ncjNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","huan Mateo huan Tomás huan Jacobo in iconeu Alfeo huan Simón, aquin noyojqui ocatca ipan in ololi den cananista, ");
INSERT INTO ncjNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","huan Judas icniu in Jacobo huan Judas Iscariote, aquin satepa otetemacti in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","In Jesús ohualtemoloc ihuan in tetlamachticahuan ipan in tepetl huan omotzecoloc ipan se ixtlahuatlahtli huan ompa ocatcahque miyac tlacamen den tlali Judea huan den Jerusalén huan den atlatentli Tiro huan Sidón. Inihque aquin ohualahque otecajque in Jesús huan ic mopahtisque ica incocolis. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Huan aquin oquintlapanoltiyaya in ahmo cuali yehyecatl noyojqui omopahtihque. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nochin tlacatl oquinequiyayahque temachilisque in Jesús, tleca Yehhuatzin omopahtiyayahque ica in techicahualis. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Oncan Jesús omotaque in tetlamachticahuan huan omoluihque: ―Nantlatiochiuten namehhuan namprohues, ic nampoutoque temajco in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Nantlatiochiuten namehhuan aquin axan nanapismictoque, tleca nampachihuisque. ’Nantlatiochiuten namehhuan aquin axan nanchocatoque tleca nampaquisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Nantlatiochiuten namehhuan ihcuac mechtlahuelitasque huan ihcuac mechtotocasque huan ihcuac mechistlacahuisque huan ihcuac mechtocahhuiltisque, tleca nampoutoque nohuan nehhuatl aquin Nitetiachicau ica nochin tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Xipactocan molui ipan inon tonali tleca nanquipiyasque miyac namotlatlan neluicac. Quen axan mechmohsihuiyahque, ijconon quen inchichicacoluan oquinchihuilihque in tetlayolchicaucahuan Dios den yihuehcau. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Namprohues namehhuan nanricos. Yopanoc itonal namopaquilis. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Namprohues namehhuan aquin axan nampachiutoque. Satepa nanapismiquisque. ’Namprohues namehhuan aquin axan nanuetzca. Satepa nantlocoyasque huan nanchocasque. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Namprohues namehhuan ihcuac mechuelitasque nochin tlacamen. Ijcon oquichiuque inchichicacoluan inuan in tlayolchicaucamen san tlaluis. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Huan axan namechiluiya namehhuan aquin nannechcaquisque: Xiquintlasohtlacan nochin aquin mechcocoliya, huan xiquinchihuilican nochin cuali in aquin mechixtlasa. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Xicselican in aquin mechtenehuas, huan xiquintlaihtlanican ica in aquin mechcamanaliluis. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tla aquin mechixtecapanis secpa, xiquiluican: Oc sepa. Huan tla aquin mechcuilis namocoton, noyojqui xicahuilican namocamisa. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tlen mechtlahtlanilisque, xiquinmacacan; huan in aquin mechcuilis in tlen namoyaxca, ahyic ximomacuepacan. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Xiquinchihuilican tlen cuali quen quinequisque huan noyojqui maquichihuacan ica namehhuan quen nanquinequisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Tla namehhuan nanmotemachiya ica in aquin mechtlasohtla, tel, ¿tlen cuali onanquichiuque?, tleca in ahmo cualten no ijcon quichihuahque. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Huan tla nanquinchihuiliyahque in tlen cuali ica in aquin mechchihuiliya noyojqui, tel, ¿tlen cuali onanquichiuque?, tleca noyojqui ijcon quichihuahque in ahmo cualten. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Huan tla nanquintlaneutiye san inohque aquin nanquinehnehuiliya cana mechcuepilisque itlahtlen, tel, ¿tlen cuali onanquichiuque? Tleca noyojqui ijcon otetlaneutihque in ahmo cualten, cana noyojqui ijcon quiselisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Huan namehhuan xiquintlasohtlacan namotecocolihcahuan huan xiquinchihuilican tlen cuali huan xiquintlaneutican masque cana ahhuel mechcuepilisque itlahtlen. Huan ijconon ocachi miyac namotlatlan. Huan namehhuan nanmochihuasque teconehuan in Dios Hueyicatzintli, tleca Yehhuatzin noyojqui quinuelitalo masque in ahmo cualten. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Noyojqui namehhuan inca xitlocoyacan ijcon quen Tohueyitahtzin noyojqui toca tlocoyalo. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Ahmo ica xitlahtocan in oc sequinten huan Dios ahmo mechtlahtlacoltilos namehhuan. Huan ahmo xiquintlahtlacoltican in oc sequinten huan Dios ahmo mechtlahtlacoltilos namehhuan. Xiquintlapohpoluican huan Dios mechtlapohpoluisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Xiquinmacacan in oc sequinten huan Dios mechuelitalos huan mechmacalos molui miyac. Huan mechchihuilisque ijconon quen namehhuan nanquinchihuilisque in oc sequinten. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Huan Jesús ocachi oquinnextililoc ica inohque tlamachtiyanimen den itlanahuatil Moisés ic maquinehnehuilican: ―Tel, ¿cuali se ixpatzac quiyecana oc se ixpatzac? Nele ahhuel. Tla ijconon nochin ome ahhuel moyecanasque. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Niyan seya de inon momachtiyanimen quixpanahuisque den tlamachtiyani. Huan masque quitlanis inon momachtilistli, san ijconon quen in tlamachtiyani. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Quen cuali ticyolita in itlahtlacol in mocniu ixnesi quen in tlahsoli ihtech iixtelolo huan ahmo ticchihuas cuenta ica in motlahtlacol ixnesi quen in cohuitl hueyi ipan moixtelolo? Tla ticnequi ticchihuas ijconon, quipiya tlen timoyolcuepas achto ica motlahtlacol. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tel, ¿quen tiixcohyehui ticyolchicahuas in mocniu: “Nocniu, ximocahua, nimitzyolchicahuas ica in tlen ahmo cuali ticchiutica”; huan ahmo ticchihua cuenta ica tehhua motlahtlacol? ¡San ome moxayac! Xicchihua cuenta ica tehhua motlahtlacol huan ijconon cuali ticyolchicahuas in mocniu ica itlahtlacol. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Noyojqui in tlacatl quen in cohuitl. In tlen cuali cohuitl ahhuel quitemacas in itlaquilyo ahmo cuali. Huan niyan in cohuitl tlen ahmo cuali quitemacas in itlaquilyo cuali. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nochin cohuitl moixmati ica in itlaquilyo. Den huetzcohuitl ahhuel motequilis in higos, niyan in uva ipan in huetzxihuitl. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","In cuali tlacatl quihtohua in tlen cuali tleca cuali iyolo huan in tlacatl ahmo cuali quihtohua in tlen ahmo cuali tleca in iyolo ahmo cuali. Tleca in tlen quihtohua san aquin, ijcon quinehnehuiliya ipan iyolo. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’Tel, ¿tleca nannechtocahhuiya: “Notecohtzin, Notecohtzin”, huan ahmo nanquichihuahque in tlen namechtequiutiya? ");
INSERT INTO ncjNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Niyau namechiluiya quen ixnesi in aquin nechtemos huan nechcaquis huan quichihuas in tlen nictequiutis. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ixnesi quen in tlacatl aquin quichihchihuas in cali. Achto otlachcuac huehcatla ic oquiyectlali in cimiento iixco se tepatlactli. Ihcuac ohueyix in atl, omoixuitequito ihtech in cali huan ahmo oquixitini tleca yec icxihtitoc. ");
INSERT INTO ncjNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Huan in aquin nechcaquis huan ahmo quichihuas in tlen nictequiutis, ixnesi quen in tlacatl aquin oquichihchiu se cali san ipan in tlali. Huan ihcuac ohueyix in atentli, omoixuitequito ipan inon cali huan otlan quitoyahua. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ihcuac Jesús otlan mononotzahque in tlacamen, ohuilohuac Capernaum. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ompa ocatca se tlayecanqui romanohteco oquipiyaya se itlaquehual aquin tequin oquinequiyaya. Inon omococohuaya molui. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ihcuac inon tlayecanqui oquimat tetenehualoca in Jesús, oncan oquintitlan sequin tequihuahmen den judeahtecos ic matetlatlautican ic mahuilohua mopahti in itlaquehual. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Yehhuan omopachohque tenahuac in Jesús huan otetlatlautihque tequin: ―Inin tlayecanqui ica timotlatlautiyahque huan quinequi mamopalehui. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Tleca quitlasohtla toaltepeu huan yehhuatl otlatequiuti ic omochihchiu in totiopan. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Oncan Jesús inuan ohuilohuac. Ihcuac oahxihuataya ichan in tlayecanqui, oquintitlan sequin itenonotzcahuan mateiluican in Jesús: ―Notecohtzin, ahmo mamomohsihuilo noca, tleca ahmo tlen noquisca ic calacohuas nochan. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Huan ic inon ahmo nixcohyehui ic nitetemos. San matlatequiutilo ic mapahti notlaquehual huan nicmati pahtis. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tleca nehhuatl no nechtequiutiyahque oc sequin tequihuahmen huan noyojqui niquimpiya aquin niquintequiutiya. Huan ihcuac niquiluis seya de yehhuan: “Mayau”, yas; huan ihcuac niquiluis oc seya: “Mahualau”, hualas. Huan ihcuac nictequiutis notlaquehual mayau quichihua itlahtlen, quichihuas. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ic omocac inin, Jesús quen tel omomat ica inon tlacatl huan omocuepaloc ica inon tlacamen aquin otecuitlapanuiyayahque huan omihto: ―Ic nele, niyan ica namehhuan judeahtecos nicahsitoc in aquin quineltoca quen inin tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Huan ic omocuepque ichan, in itlatitlaniluan ocahsitohque inon tlaquehuali yipahtic. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Satepa de inin, in Jesús ohuilohuaticatca ipan se altepetl itoca Naín, huan otecuitlapanuiyayahque in tetlamachticahuan huan miyac tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ihcuac ahxihuatiu ipan in altepetl, omotac se mijqui ocuicatayahque ic quitocasque. Huan yehhuatl san inon se iconeu inon viuda. Huan miyac tlacamen oquicuitlapanuiyayahque. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ic omotac in Jesús, ica otlocoyaloc in viuda huan omoluic: ―Ahmo xichoca. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Oncan in Jesús omopacholoc inahuac in aquin ocuicatayahque in mijqui huan omomachili in tlapechtli huan ijcon omotzecohque. Huan Jesús omoluic in mijqui: ―Telpochtli, nehhua nimitziluiya; ¡Ximehua! ");
INSERT INTO ncjNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Oncan inon mijqui omotlali huan opeu tlahtohua. Huan in Jesús omomactili in inana. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ic oquitaque inin, nochten omomoutihque huan opeuque temahuestiliyahque in Dios huan oquihtohque: ―Se hueyi tlayolchicauqui otechmonextili. Huan noyojqui oquihtohque: ―Ic nele otiquitaque tetequiu in Dios axan. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nohuiyan ipan in tlali Judea oquimatque tlen omochiu in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","In itlamachticahuan in Juan oquiluihque nochin inin. Oncan oquinnotz ome de yehhuan, ");
INSERT INTO ncjNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","huan oquintitlan ic matetlahtlanican in Jesús tla nele Yehhuatzin in Cristo aquin hualasquiyani noso quichiyasque in oc seya. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","In itlatitlaniluan in Juan omopachohque tenahuac in Jesús huan oteiluihque: ―In Juan Tlacuatequiyani otechualtitlan matitetlahtlanican tla nele Tehhuatzin in Cristo aquin hualasquiyani, noso ticchiyasque in oc seya. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ihcuac yehhuan oahsitohque, in Jesús omopahtihque miyac tlacamen ica san tlen cocolisten, huan oc sequin ica in ahmo cuali yehyecatl. Huan noyojqui omotlachiyaltihque sequin ixpatzacten. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Huan ic inon in Jesús omonanquilihque: ―Xiyacan xiquiluican in Juan in tlen onanquitaque huan onanquicajque. Xiquiluican quen in ixpatzacten omotlachiyaltihque huan in xonecuilten omonehnemiltihque yec. Huan in aquin pahpalanihque opahtihque huan in nacastemen tlacaquihque. Huan in mijcamen no oihsahque huan in prohues no quincaquiltiyahque in tlahtoli den temaquixtilistli. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mapacto in aquin ahmo moxihxicohua ica nehhua. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ihcuac omocuepque in itlatitlaniluan in Juan, in Jesús opehualoc quinnonotzalo in tlacamen ica in Juan. Oquintlahtlaniloc: ―Tel, ¿tlenon onanyahque nanquitaque ipan in acahualtlahtli? ¿Cana se tlacatl sa huehueyoca quen in acatl ica in yehyecatl? ");
INSERT INTO ncjNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Huan tlahmo inon tel, ¿onanyahque nanquitaque se tlacatl cuahcuali itlaquen? Nanquimatihque in aquin ijcon motlaquentiya huan pactosque, yehhuan mochantiyahque ihuan in hueyixtoc. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ic nele, tel, ¿tlen onanyahque nanquitaque? ¿Se tlayolchicauqui? Queme ic nele, huan ocachi quen se tlayolchicauqui. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","In Juan yeh in aquin oquihcuiluihque ipan Itlahcuiloltzin tlen quihtohua: Nictitlanis notlanonotzcau moixpa. Yeh in aquin maquinnahuati mamitzselican. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ic nele, namechiluiya, ica nochin tlacamen ahmo oncan oc se tlayolchicauqui aquin ocachi hueyi quen inon Juan Tlacuatequiyani. Masque ijcon ca, in aquin ocachi ahmo tlen iquisca huan temajco in Dios, yehhua quisas ocachi hueyi quen inon Juan. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Huan ihcuac oquicajque inin tlahtoli, nochten in tlacamen ihuan in renderos aquin oquiselihque in icuatequilis in Juan ijcon oquisematque tehuan in Dios quen melahuac itlahtol in Juan. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Huan in fariseos huan in tlamachtiyanimen den itlanahuatil Moisés aquin ahmo oquincuatequi in Juan, yehhuan aquin san oteixtlasque in Dios ica tlen omonec ica yehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Huan in Totecohtzin omihto: ―Tel, ¿ica tlen niquinixnamiquis inin tlacamen huan quen ixnesihque? ");
INSERT INTO ncjNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ixnesihque quen in conemen san mahuiltiyahque huan quinnotzahque in oc sequin: “Tamechpipitziliyahque in flauta quen ipan mosihuautilistli huan ahmo onanmihtotihque. Huan otitlocoxtoyahque quen ica in mijqui huan namehhuan nanyolchicahuahque.” ");
INSERT INTO ncjNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tleca ohuala in Juan Tlacuatequiyani mosautica, niyan quioni in uvahtlayili, huan namehhuan onanquihtohque quipiya in ahmo cuali yehyecatl. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Niman onihuala nehhua aquin Nitetiachicau ica nochin tlacatl, ahmo nimosahua, nitlacua huan nitlaoni, huan nanquihtohuahque niapistli huan nitlayini, niitenonotzcau in tlahtlacolyohque huan renderos. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Huan in tlamatilistli den Dios quinextiliyahque in aquin nele tlamatihque. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Se de inon fariseos otetlamacac in Jesús, huan Jesús ohuilohua ichan ihuan. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Oncan se ixpoliucasihuatl den altepetl oquimat quen ompa ilohuaya in Jesús ichan inon fariseo. Huan ihcuac oahsito ocuicataya se tehuilotetl tentiu ica in aceite ahhueyac. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ic chocatiu omopacho teicxitla in Jesús huan ohuetz iixyayo ipan tecxi. Huan niman otexopohpou ica in itzon, huan otexotenamiquiyaya ica itlasohtlalis huan otexotlalili in aceite ahhueyac. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ihcuac inon fariseo aquin otehuicac in Jesús oquitac tlen opanoc, oquiyolnehnehuili: “Tla nele se tlayolchicauqui inin tlacatl, quitasquiyani tlen iquisca inon sihuatl aquin oquimacaticatca, tleca yehhua in ixpoliucasihuatl.” ");
INSERT INTO ncjNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Oncan Jesús omoluic in fariseo: ―Simón, niyau nimitztlahtlani. Oncan otenanquilic in Simón: ―Manechtlahtlanilo, tlamachtiyani. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","In Jesús omoluic: ―Ome tlacamen oquihuiquiliyayahque in tomin se tetlaneutiyani. In seya oquihuiquiliyaya macuili ciento huan in oc seya tlahco ciento. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Huan quen ahhuel oquicuepiliyayahque in tetlaneutiyani, oquintlapohpolui ica in tlen oquihuiquiliyayahque inon inehuan. Axan xinechilui tel, ¿aquin de yehhuan ocachi quitlasohtlas? ");
INSERT INTO ncjNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","In Simón otenanquilic: ―Nicmati yeh in aquin ocachi oquitlapohpolui. In Jesús omoluic: ―Cuali oticnehnehuili. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Oncan Jesús omotzticatca in sihuatl huan omotlahtlani in Simón: ―Tel, ¿tiquita inin sihuatl? Onicalac mochan huan ahmo otinechmacac in atl tlen ic nimoxopacas. Tlahmo inin sihuatl ocachi onechxopacac ica iixyayo, huan onechxopohpou ica itzon. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tehhua ahmo otinechpipitzo ic tinechtlahpaloni, huan yehhua, queman onicalac, ahmo quilcautoc quen onechxotenamic. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tehhua ahmo otinechcuatlalili in aceite huan yehhuatl onechxoquenti in aceite ahhueyac. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Huan ic inon nimitziluiya, ica inon itlahtlacoluan nictlapohpoluihtoc, tleca quinextiya quen itlasohtlalis. Huan aquin san chihton motlapohpoluiya no chihton itlasohtlalis quixnextiya. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Oncan omoluic inon sihuatl: ―In motlahtlacoluan nimitztlapohpoluihtoc. ");
INSERT INTO ncjNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Huan in aquin ompa oyehuatoyahque tehuan opeuque motlahtlaniyahque yehhuan: ―Tel, ¿tlen iquisca inin tlacatl, quintlapohpoluiya intlahtlacol? ");
INSERT INTO ncjNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Huan Jesús omoluic in sihuatl: ―Yinimitzmaquixtihtoc tleca oticneltocac huan xipactiu. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Huan satepa de inin, in Jesús otlanonotzalohtinemiyaya ipan miyac altepemen huan itlatilanaluan ica in cuali tlahtoli ica tetlatequiutilistzin in Dios. Huan otecuitlapanuihtinemiyayahque in mahtlactli huan ome tetiotlatitlaniluan. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Noyojqui otecuitlapanuihtinemiyayahque sequin sihuamen aquin oquimpahtiloc ica in ahmo cuali yehyecatl huan ica oc sequin cocolisten. Ica inohque oyaya María den altepetl Magdala aquin oquimpiyaya chicome ahmo cuali yehyecamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Noyojqui Juana isihuau in Chuza, in aquin itlachixcau in hueyixtoc Herodes, huan in Susana huan oc sequin aquin otepalehuiyayahque ica tlen otepolohuaya. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Miyacten ohualchocoquisque den altepemen ic teitasque in Jesús huan ihcuac yomosentlalihque, oquinnonotzaloc ica se tlalnamictilistli. Huan oquiniluiloc: ");
INSERT INTO ncjNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Se tlacatl oya quichayahua in xinachtli. Huan ic oquichayautaya, sequin ohuetz ihtech ohtli huan oquixopechihque huan niman oquicuahque in totomen. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Huan in oc sequin xinachtli ohuetz ipan in tepetlatl huan ihcuac oyol inon xinachtli niman ohuac, tleca ahmo oquipiyaya inon tlacamahuilotl. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Huan in oc sequin xinachtli ohuetz ipan in huetztlahtli, huan inon otlan xoloni tlen inahuac ohuetz inon huetztli. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Huan in oc sequin xinachtli ohuetz ipan in cuali tlali, huan ihcuac oyol, oquitemacac miyac inon tlamiloli, hasta se carga ipan se acali. Ic omihto inin, oquiniluiloc chicahuac in Jesús: ―In aquin quicaquis, maquichihua cuenta. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Oncan in tetlamachticahuan otetlahtlanihque ica inon tlalnamictilistli. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Huan oquiniluiloc: ―In Dios mechmatiltilo ica in tlen tlatiutoc den tetlatequiutilistzin, huan oc sequinten niquinnonotza ica in tlalnamictilistli. Huan ijcon in aquin quichihuas cuenta, maquinehnehuilican, huan in aquin ahmo, ahmo quinehnehuiliya. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’In tlalnamictilistli quihtosnequi in xinachtli, yehhua in itlahtoltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Huan inon xinachtli tlen ohuetz ipan in ohtli quihtosnequi quen in aquin quicaquihque huan niman huitz in ahmo cuali tlacatl huan quinyolcuiliya in itlahtoltzin huan ijcon ahmo maquineltocacan huan ijconon ahmo mamomaquixtican. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Huan in oc sequin xinachtli tlen ohuetz ipan tepetlatl quihtosnequi quen aquin quiseliyahque cualtzin in itlahtoltzin huan quen ahmo oquiyecneltocac, ijcon niman omoxihxico. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Huan in oc sequin xinachtli tlen ohuetz ipan in huetztlahtli quihtosnequi quen in aquin quicaquihque in itlahtoltzin huan ahhuel quilcahuahque ica in achto intlamachilis. Huan ijcon ahmo tlen quimpalehuis ipan innemilis. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Huan in xinachtli tlen ohuetz ipan in cuali tlali, inon quihtosnequi quen in aquin oquiselihque ica inyolo in itlahtoltzin, huan quen tetlacamautoque, ijcon quitemaca nochin tlen cuali. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Niyan aquin quitlalis in tlanextli itzintla in comitl noso itzintla in cama. Tlahmo maquitlali huehcapa huan ijconon quintlanextilis nochten aquin calaquisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nochin tlen axan ixtlapachiutoc satepa quinmactisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Ijcon tel, xicaquican yec, tleca in aquin quichihua cuenta ica tlen quinehnehuiliya, ocachi quinehnehuilis. Huan in aquin ahmo quichihua cuenta ica tlen quinehnehuilini, quilcahuas in chihton tlen oquinehnehuilic. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Oncan oahsitohque in inanahtzin huan icnihuan in Jesús canin oilohuaya huan quen otentoyahque miyac tlacamen, ahhuel omopachohque tenahuac. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Huan seya otenahuatic in Jesús: ―In monanahtzin huan in mocnihuan ompacaten caltenco huan mitztemohuahque. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Huan Jesús omoluihque: ―In aquin quicaquihque in itlahtoltzin Dios huan quinehnehuiliyahque, yehhuan in nonanahhuan huan nocnihuan. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ipan se tonali in Jesús otlehcolo ipan se barco inuan in tetlamachticahuan huan oquiniluiloc: ―Tiyohue tipano ic sentlapal den hueyi atl. Huan ohuihhuilohuac. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Huan ic opanolohticatca ipan in atl, Yehhuatzin ocochihuac. Huan san tlama opeu yehyeca chicahuac huan ijcon opeu atemi in barco huan ijcon moatocani. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Oncan oteihxitihque in Jesús huan oteiluihque: ―¡Tlamachtiyani! ¡Tlamachtiyani! ¡Tiyohue timatoca! Oncan in Jesús oihxohuac huan oquitlacahualtiloc in yehyecatl huan in atl, huan ijcon nochin tlamach omotlali. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Oncan oquiniluiloc in tetlamachticahuan: ―Tel, ¿ahmo nannechneltocahque? Huan yehhuan omomoutihque huan quen tel oquimatque. Huan omotlahtlanihque se huan oc seya: ―Tel, ¿tlen tequisca inin tlacatl, quen quitlacamatiltiya in yehyecatl huan in atl, huan nochin tetlacamatihque? ");
INSERT INTO ncjNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ihcuac oahxihuato ipan in tlali Gadara, tlen ca isentlapal Galilea. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ic otemoloc in Jesús ipan in barco, oteixnamiquito se gadarenohteco. Inon aquin huehcau oquimpixtoya in ahmo cuali yehyecamen. Huan ahmo omotlaquentiyaya niyan ocatca ipan cali, tlahmo san onemiyaya canin motocahque in mijcamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ihcuac oteitac in Jesús, niman omotlancuaquetz teixpa huan oquihto: ―Tel, ¿tlen ticpiya tiquitas ica nehhuatl, Jesús titeconetzin in Dios hueyicatzintli? Nimitztlatlautiya ahmo xinechtlapanolti. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ijcon oquiteluic in Jesús tleca omotequiutihticatca in ahmo cuali yehyecatl maquisa de yehhuatl. Quen oquiquitzquihtoya huehcau in ahmo cuali yehyecatl huan ijcon miyacpa oquimailpihque huan oquixoilpihque ica in cadena ic ahhuel macholo. Huan yehhuatl oquicohcotonayaya in cadenas huan inon ahmo cuali yehyecatl oquiquixtiyaya ipan in acahualtlahtli. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Huan in Jesús omotlahtlani: ―Tel, ¿tlen motoca? Huan oquiteluic: ―Nehhua notoca in Ololi. Ijcon oquihto tleca ocalactoyahque ipan yehhua miyac in ahmo cuali yehyecamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Huan inon ahmo cuali yehyecamen otetlatlautihque in Jesús ahmo mamotitlanican ipan inon tlacoyoctli tlen ahmo quipiya itlamiyan. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ocatcahque miyac in pitzomen tlacuahtinemihque ipan coutlahtli. Huan in ahmo cuali yehyecamen otetlatlautihque in Jesús mamocahuacan ipan yehhuan, huan in Jesús omocauque. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Oncan in ahmo cuali yehyecamen oquisque de inon tlacatl huan ocalajque ipan in pitzomen. Huan inohque omotepehxihuihque huan ohuetzihtohque ipan in atl huan omelsinque. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ihcuac oquitaque tlen opanoc in aquin oquinixpiyayahque inon pitzomen, omomoutihque huan oyahque tlanonotzahque nohuiyan ipan in altepetl. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Huan in tlacamen oyahque quitahque tlen opanoc. Ihcuac oahsihtoque canin oilohuaya in Jesús, ocahsitoque in tlacatl aquin oquimpiyaya in ahmo cuali yehyecamen. Oyehuatoya tecxitla in Jesús tlaquentihtoc huan yotlamautoya. Oncan yehhuan omomoutihque. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yehhuan aquin oquitaque tlen opanoc otlanonotzque quen omopahti inon tlacatl aquin oquimpiyaya inon ahmo cuali yehyecamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ic inon nochin tlacatl den tali Gadara opeuque tetlatlautiyahque in Jesús maquixohua de ompa, tleca tequin omomoutihtoyahque. Ijcon in Jesús otlehcoloc ipan in barco huan ohuilohuac. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Inon tlacatl aquin oquinixtohuetzaluiloc in ahmo cuali yehyecamen otetlatlautic in Jesús quen tehuan yasquiyani. Huan Jesús omotequiuti mamocahua huan omoluic: ");
INSERT INTO ncjNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Xiyau mochan huan xiquinilui nochin tlen Dios omochiu ica tehhua. Huan inon tlacatl oya huan otlanonotztaya ipan in altepetl in tlen Jesús omochiu ica yehhua. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ihcuac in Jesús oahxihuato oc sepa canin oilohuaya, in tlacamen oteselihque ica paquilistli tleca nochten otechixtoyahque. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Oncan oahsito se tlacatl itoca Jairo, tequihua den tiopan. Inon tlacatl omotlancuaquetz teicxitla in Jesús huan otetlatlautic mahuilohua ichan. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Tleca oyaya miqui in ichpocau quen san isel huan oquipiyaya mahtlactli huan ome xihuitl. Huan ic ohuilohuac in Jesús otecuitlapanuihque miyac tlacamen hasta otepitzinihtayahque. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","De inohque oyaya se sihuatl cocoxqui ica mahtlactli huan ome xihuitl otlapanohtoya ic oxitiniyaya ica in iyes. Huan miyac tomin oquitlaxtlau ica in tlapahtiyanimen huan niyan aquin oquipahti. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Yehhua omopacho tecuitlapa in Jesús huan oquimachili in tetlaquen huan saniman omosehui ic oxitiniyaya ica in yestli. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Oncan Jesús otlahtlanihuac: ―Tel, ¿aquin oquimachili notlaquen? Huan niyan aquin omocuiti huan ic inon Pedro huan in oc sequin oquihtohque: ―Tlamachtiyani, in tlacamen tepitziniyahque huan teixtopehuahque san canic, ¿huan ic inon tleca techtlahtlaniyahque: “Aquin onechmachili”? ");
INSERT INTO ncjNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Huan Jesús omihto: ―Onechmachili seya, tleca nicmati aquin opahtic ica nochicahualis. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Huan quen omomat ica inon sihuatl, yehhua ohuehueyocataya ic omotlancuaquetzato teicxitla in Jesús. Huan omoyoluiti temiyacaixpa ica tlen otemachili huan quen opahtic ica in icocolis. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Oncan Jesús omoluic: ―Notlasohicniu, otipahtic tleca otinechneltocac. Ximoquetza huan xiyau tlamach. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Oc otlanonotzalohticatca in Jesús, ihcuac oahsico itlatitlanil den ichanihcau in Jairo huan oquiluihque: ―In mochpocau yomic. Ahmo ocachi xitemohsihuihtiye in tlamachtiyani. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Huan Jesús omocac huan omoluic: ―Ahmo ximomouti. San xicneltoca huan moconeu pahtis. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ic oahsitohque ichan, ahmo aquin oquicahualoc macalaqui tehuan, san yehhuatl in Pedro huan Jacobo huan Juan huan itata huan inana in ichpocatl. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nochten ochocatoyahque huan otlocoxtoyahque ica in ichpocatl. Huan Jesús omoluihque: ―Ahmo xichocacan ica in ichpocatl. Ahmo mictoc, san cochtoc. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Huan san teca ohuetzcahque in Jesús tleca oquimautoyahque omic. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Oncan in Jesús omomaquitzqui huan omoluic chicahuac. ―Ichpocatl, ximehua. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Oncan yehhua oc sepa otlahtlachix, huan niman omeu. Huan omotequiuti in Jesús quen maquitlamaca. ");
INSERT INTO ncjNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","In itata huan in inana quen tel oquimautoyahque. Huan Jesús omotequiutihque quen ahmo aquin maquiluican tlen opanoc. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","In Jesús omosentlalihque in mahtlactli huan ome tetiotlatitlaniluan huan omomacaque in chicahualistli huan in tequihuahyotl ic quinixtohuetzosque in ahmo cuali yehyecamen huan quimpahtisque in cocoxcamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Huan omotitlanque matlanonotzacan in itlahtoltzin Dios huan maquimpahtican in cocoxcamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Huan oquiniluiloc: ―Ahmo tlen xicuicacan tlen ic nanmopalehuisque, niyan in coutopil, niyan in bolsa, niyan namotlacual, huan niyan in tomin. Xicuicacan san se namocamisa. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","San canin nanahsitihue, ompa ximocahuacan hasta nanquisasque de ompa. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Huan canin ahmo mechselisque, xiquisacan de inon altepetl huan ximoxotzetzelocan ica in teutli, quen senyas ic ahmo omechselihque yehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Huan oquisque yehhuan nohuiyan ipan inon altepemen tlanonotztinemihque in itlahtoltzin den tlamaquixtilistli. Huan oquimpahtihtayahque in cocoxcamen ic nohuiyan. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","In hueyixtoc Herodes oquimat nochin tlen omochihuayaya in Jesús huan ahmo oquinehnehuili aquin Yehhuatzin. Tleca sequin oquihtohuayahque in Juan oihsac den mijcamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Huan oc sequin oquihtohuayahque yehhua in tlayolchicauqui Elías aquin ohuitza. Huan oc sequin oquihtohuayahque se de inon yihuehcau tlayolchicaucamen oihsac. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Huan Herodes oquihto: ―Nehhuatl onitlatequiuti maquiquechtequican inon Juan. Tel, ¿aquinon yes inin nicaqui ica san tlen? Huan in Herodes oquinequiyaya quixmatis. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ihcuac omocuepque inon tetiotlatitlaniluan otenonotzque in Jesús nochin tlen oquichiuque. Oncan oquinuicaloc inahuac in altepetl Betsaida. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Huan ihcuac oquimatque inon tlacamen, oquincuitlapanuihque. Huan in Jesús oquinseliloc huan oquinnonotzaloc ica canin tlatequiutilo in Dios huan oquimpahtiloc sequin cocoxcamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ihcuac opeu tlatiotlaquiya, omopachohque tenahuac in Jesús in mahtlactli huan ome tetlamachticahuan aquin tetiotlatitlaniluan huan oteiluihque: ―Mamonahuatican in tlacamen mayacan mosehuican huan maquitemocan intlacual, tleca nican ahyac tlen. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Huan Jesús omoluihque tetiotlatitlaniluan: ―Namehhuan xiquintlamacacan. Yehhuan oteiluihque: ―Ahmo tlen ticpiyahque, san macuili pantzin huan ome michten. ¿Huan quen tiyasque ticohuasque intlacual inin tlacamen? ");
INSERT INTO ncjNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Huan ocatcahque cana macuili mil tlacamen. Huan in Jesús oquiniluiloc inon tetiotlatitlaniluan: ―Xiquinsecnintlalican sehsen ololi den tlahtlaco ciento. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ijcon oquichiuque huan nochten omotlalihque. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Oncan in Jesús omoan in macuili pantzin huan in ome michten. Huan oahcotlachiyaloc ic omotlasohcamatiloc ica yehhuan huan ic oquinxehxeluihque, omomacaque in tetiotlatitlaniluan ic maquinxehxeluican in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nochten otlacuahque huan opachiuque, huan satepa oten mahtlactli huan ome canasta ica in cohcotonqui tlen omocau. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Se tonali in Jesús omoyolmachtilohtoya secnin, huan tehuan ocatcahque in tetiotlatitlaniluan. Huan omotlahtlanihque: ―Tel, ¿tlen quihtohuahque inon tlacamen ica nehhuatl? ");
INSERT INTO ncjNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Huan yehhuan otenanquilihque: ―Sequin quihtohuahque Tehhuatzin in Juan Tlacuatequiyani huan oc sequin quihtohuahque Tehhuatzin in Elías, huan oc sequin quihtohuahque Tehhuatzin seya den yihuehcau tlayolchicaucamen aquin oihsac. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Oncan Yehhuatzin omotlahtlanihque in tetiotlatitlaniluan: ―¿Huan namehhuan, aquin nanquihtohuahque nehhua? Huan in Pedro oteiluic: ―Tehhuatzin in Cristo, Totemaquixticahtzin aquin otehualtitlaniloc in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Huan Jesús omonahuatihque ahmo aquin maquinnonotzacan. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Huan omoluihque: ―Nehhua aquin Nitetiachicau ica nochin tlacatl nicpiya tlen nitlapanos tequin, huan nechixtohuetzosque in tetecten, huan in achtohque den tiopixcamen huan in tlamachtiyanimen den itlanahuatil Moisés. Nechmictisque huan ipan yiyi tonali niihsas. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Satepa oquiniluiloc nochten: ―Tla seya quinequi mochihua notlamachticau, ayacuel quichihuas quen yeh quinequis. Quipiya tlen tlapanos, masque miquis ipan in cruz, huan ijcon mochihua notlamachticau. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mopolos in aquin ahmo quinequi miquis nopampa, huan maquisas in aquin motemacas ica nehhua. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tla se tlacatl quitlanis nochin nican tlalticpac huan tla san yehhua mopolos, ahmo tlen oquipalehui. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Huan tla seya mopinautiya ica nehhua huan ica notlanonotzalis, noyojqui nehhua aquin Nitetiachicau ica nochin tlacatl nimopinautis ica yehhua ihcuac nihualas quen hueyixtoc ipan tehueyilistzin Nohueyitahtzin inuan in tlamelajcanten ángeles. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ic nele namechiluiya ica sequin aquin caten nis ahmo miquisque achto, tlahmo quitasque in tetlatequiutilistzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Huan cana chicueyi tonali satepa ic oquihtohque inin, in Jesús otlehcoloc ipan se tepetl moyolmachtilo ihuan Pedro huan Jacobo huan Juan. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Huan ic omoyolmachtilohticatca in Jesús, in tetlachiyalis omopatlac huan in tetlaquen omocau molui chipahuac huan opetlanticatca. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Oncan san tlama omohualnextihque ome tlacamen tehuan omonohnotzque. Huan yehhuan in Moisés huan Elías. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Huan ijcon onesque huan omonohnotzque ica in miquilistli tlen tlapanolos in Jesús nepa Jerusalén. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Huan Pedro huan in inehuan ocochmicticatcahque, huan oquixicohque in cochistli. Huan oquitaque tehueyilistzin in Jesús ihuan in inehuan aquin tehuan ocatcahque. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ihcuac inon inehuan otzinquistayahque den Jesús, in Pedro oteiluic: ―Tlamachtiyani, tequin cuali quen nican ticaten. Tiquinchihuasque yiyi calten, seya ica Tehhuatzin huan oc seya ica Moisés huan in oc seya ica Elías. Huan Pedro ahmo oquinehnehuili tlen oquihto. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Huan ic otlahtoticatca omohualpacho se mextli huan oquintlapacho. Huan omomoutihque ihcuac ocatcahque inepanco in mextli. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Oncan oquicajque se tlahtoli tlen oquihto: ―Inin in noconeu tlasohtli. Xicaquican yehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Satepa ic oquicajque, oteitaque tesel in Jesús. Yehhuan omonontzauque ica tlen oquicajque, huan ica tlen oquitaque huan ahmo otlanonotzque. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ic mostla, ic ohualtehtemoloc ipan in tepetl, in Jesús otenamiquitohque miyac tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Oncan se de inon tlacamen oteiluic chicahuac: ―Tlamachtiyani, nimitztlatlautiya xiquita noconeu, tleca san isel nicpiya. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","In ahmo cuali yehyecatl quiquitzquiya huan quicoutzatziltiya huan mimiqui huan quitemposonaltiya. Huan quihuihhuitequi huan ahmo quinequi quicahcahuas. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Yoniquintlatlauti in tetlamachtihcahuan maquiquixtilican in ahmo cuali yehyecatl huan ahhuel ijcon oquichiuque. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","In Jesús omonanquilihque: ―Nele ahmo onantlaneltocaque huan ahmo onantlacajque. Yihuehcau yonamechnextilic huan ayamo nannechneltocahque. Xinechualiquilican. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Huan ihcuac inon telpocatl omopachohtaya, oquitohuetzo tlalpa inon ahmo cuali yehyecatl, huan oc sepa mamimiqui. Huan Jesús omoahhuac inon ahmo cuali yehyecatl huan ijcon omixtohuetzalui. Huan inon telpocatl omopahti huan omomacti in itata. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Huan nochten quen tel oquimatque ica in techicahualistzin Dios, huan ica nochin tlen omochihuayaya in Jesús. Huan Yehhuatzin omoluihque inon tetlamachticahuan: ");
INSERT INTO ncjNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Xicyecaquican inin tlahtoli huan ahmo xiquilcahuacan; quen nehhuatl aquin Nitetiachicau ica nochin tlacatl nechtemactisque inmajco inon tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Huan in tetlamachticahuan ahmo oquinehnehuilihque tlen omoluihque. Huan quen ahmo omocahuilihque maquinehnehuilican, omomoutihque tetlahtlanisque tlen quihtosnequi ica in tlen omoluihque. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Oncan in tetlamachticahuan opeuque motlahtlaniyahque ic yehhuan aquin ocachi hueyi iquisca. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Huan in Jesús omonehnehuili ica in tlen yehhuan oquinenehuilihque. Oncan omoan se conetl huan tenahuac omotlali Yehhuatzin, ");
INSERT INTO ncjNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","huan omoluihque: ―In aquin quiselis se conetl quen inin ica notoca, nehhua no nechseliya. Huan in aquin nechselis nehhuatl noyojqui teseliya in aquin onechualtitlaniloc. In aquin ahmo mohueyiliya ica namehhuan yeh in aquin ocachi hueyi iquisca. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Oncan in Juan oteiluic: ―Tlamachtiyani, otiquitaque seya aquin tlahtohua ica tetoca huan quinixtohuetzohua in ahmo cuali yehyecamen, huan otictlacahualtihque tleca ahmo tohuan nemi. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Huan in Jesús omoluic: ―Ahmo xictlacahualtican, tleca in aquin ahmo techcocoliya, inon techpalehuiya. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ihcuac ohualahsitaya in tonali queman Jesús huilohuas neluicac, omixcohyanuiloc huilohuas Jerusalén. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Omotitlanqui tetlatitlaniluan matlicanacan, huan yehhuan oyahque ipan se altepetl den itlatilanal Samaria ic quitemosque canin motepaluilos. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Huan inon samariahtecos ahmo oquinejque quinselisque tleca oquitaque quen oyahticatcahque Jerusalén. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ihcuac oquinehnehuilihque inon, in Juan huan Jacobo oteiluihque: ―Totecohtzin, tel, ¿monequi matictlahtlanican quen mahualtemo in tletl den neluicac ic tiquintlamisque yehhuan quen oquichiu in tlayolchicauqui Elías? ");
INSERT INTO ncjNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Huan in Jesús omixahhuaque inon Juan huan Jacobo: ―Namehhuan ahmo nannehnehuiliyahque ica tlen namoquisca. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Quen nehhua aquin Nitetiachicau ica nochin tlacatl ahmo onihuala niquimpolohua in tlacamen, tlahmo onihuala niquinmaquixtiya. Oncan oyahque ipan oc se altepetl. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ic oyahticatcahque ipan in ohtli, se tlacatl oteiluic in Jesús: ―Notecohtzin, nicnequi nitecuitlapanuis san canin huilohuas. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","In Jesús omonanquilic: ―In tanchau quipiya itlacoyoc huan in totomen quipiyahque impehpech, huan nehhuatl aquin Nitetiachicau ica nochin tlacatl ahmo nicpiya niyan canin nimocuatecas. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","In Jesús omoluic in oc seya: ―Xinechcuitlapanui. Huan yehhua oteiluic: ―Notecohtzin, manechcahuacan ic micohuas notata. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","In Jesús omonanquilic: ―Xiquincahuili in aquin ahmo quineltocahque ica nehhua maquintocacan inmijcahuan huan tehhua xiyau huan xiquinnonotza in itlahtoltzin den tetlatequiutilistzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Oncan oteiluic in oc seya: ―Notecohtzin, nicnequi nitecuitlapanuis, huan achto manechcahualo niyas niquinnahuatis nochanihcahuan. ");
INSERT INTO ncjNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Huan in Jesús omoluic: ―Yehhua aquin tequiti nohuan huan quichihuas cuenta ica tlen momatzecos, yehhua quen seya pehua tlaxotla huan niman pehua monehnequi, huan yehhua ahmo cuali iquisca ic tequiti ica in tetlatequiutilistzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Satepa de inin in Totecohtzin omotlapehpenihque inon yehpohuali huan mahtlactli, huan omotitlanque inehnehuan achto de Yehhuatzin, canin huilohuasquiyani. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Huan omoluihque: ―Ic nele, oncaten ocachi miyac in aquin quicaquisque in itlahtoltzin Dios. Yehhuan quen hueyi pixquistli huan in tequitcamen ocachi chihton. Huan ic inon ximoyolmachtican ica in Tohueyitahtzin quen mamechualtitlanililo oc sequin tequitcamen ic mechpalehuisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Xiyacan namehhuan, huan xicchihuacan cuenta quen neh namechtitlanis quen calnelohten inepanco inon lobos. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ahmo xicuicacan niyan tlen ic nanmopalehuisque, niyan bolsa, niyan tomin, niyan namotecac. Huan ahmo ximotzecocan ipan in ohtli niyan ic nanquitlahpalosque aquin. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ihcuac nanahsisque techan, xiquintlahpalocan ic nanquiniluisque: “Mamechtiochihualo ipan inin cali.” ");
INSERT INTO ncjNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Huan tla ompacaten tlacamen aquin mechselisque, inon tlatiochihualistli ica yehhuan, huan tlahmo, ahmo tlen yes den tlatiochihualistli. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Huan ximocahuacan ipan inon cali huan xitlacuacan huan xitlaonican ica in tlen quipiyasque, tleca in tequitqui quipiya tlen quitlanis. Huan ahmo xiixnemican. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ic nanahsitihue ipan se altepetl canin mechselisque, xicuacan in tlen mechmacasque. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Xiquimpahtican in cocoxcamen tlen ompa yesque huan xiquiniluican: “Quen ayacmo huehcau in tetlatequiutilistzin Dios.” ");
INSERT INTO ncjNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Huan tla nanahsisque ipan se altepetl canin ahmo mechselisque, xiquisacan ipan in ohtli huan xiquihtocan: ");
INSERT INTO ncjNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Hasta in teutli den namoaltepeu timoxohtzetzelohticaten, ic xicchihuacan cuenta quen onantechixnamijque. Huan xicmatican quen in tetlatequiutilistzin Dios ayacmo huehcau ic nanteitasque.” ");
INSERT INTO ncjNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Namechiluiya quen ipan in tonali den tlixcomacalistli, in tlapanolistli den yehhuan yes ocachi chicahuac quen den tlacamen sodomahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’Lástima in aquin den altepetl Corazín huan lástima aquin den altepetl Betsaida. Tla inon tlacamen den altepemen Tiro huan Sidón quitanihque in tlen onamechnextilihque, yimoyolcuepanihque ica pinaucayotl, huan quincuatlaxilinihque in tleconextli ica intlocol. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Huan ipan in tonali den tlixcomacalistli namehhuan nantlapanosque ocachi quen in tlacamen den Tiro huan Sidón. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Huan namehhuan tlacamen den Capernaum, tel, ¿onanquimatiyayahque nanyasque neluicac? Ocachi nantemosque ipan mictlan. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’In aquin mechcaquis, no nechcaquis nehhuatl, huan in aquin mechixtlasa no nechixtlasa. Huan in aquin nechixtlasa no teixtlasa in aquin onechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Omocuepque inon yehpohuali huan mahtlactli pactihuitzen. Huan quihtohtihuitzen: ―¡Totecohtzin, hasta in ahmo cuali yehyecamen otiquintlanque ica tetoca! ");
INSERT INTO ncjNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","In Jesús oquiniluiloc: ―Ijconon oniquitac in ahmo cuali tlacatl, yeh in Satanás, ic ohuetz den neluicac quen in tlapetlantli. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nehhua namechmacatoc chicahualistli ic nanquinxopechisque in cohuamen huan colomen, huan ic nanquitlanisque in namotecocolihcahuan, niyan mechtlapanoltisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Huan ahmo xipaquican tleca onanquintlanque in ahmo cuali yehyecamen, tlahmo xipaquican quen nampoutoque neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ipan inon rato in Jesús molui opaquiloc ica in Itiotonaltzin in Dios, huan omihto: ―Nitemahuestiliya, Notahtzin huan Notecohtzin den neluicac huan den tlalticpac, tleca motlatihtoc inin tlamatilistli ica in ixtlamatcamen huan monextilihtoque ica in aquin ahmo machtihtoque. Ijcon Notahtzin, tleca ijconon monectoc Tehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Notahtzin nechmactilohtoc nochin tlamanten. Huan niyan aquin nechixmati nehhuatl aquin Niteconetzin, tlahmo san Yehhuatzin in Notahtzin. Huan niyan aquin teixmati aquin Notahtzin tlahmo nehhuatl, huan inohque aquin neh nicnequi mateixmatican. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Oncan omotaqui in tetlamachticahuan huan omoluihque insel: ―Mapactocan in aquin quitahque ica in iixtelolo in tlen namehhuan nanquitzticaten. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Tleca namechiluiya miyac tlayolchicaucamen huan in hueyixtoqui oquinejque quitasque in tlen nanquitahque, huan ahhuel oquitaque. Noyojqui oquinejque quicaquisque in tlen namehhuan onanquicajque huan ahmo onanquicajque. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Oncan se tlamachtiyani den tlanahuatilten oya teita in Jesús ic teistlacaahsis huan otetlahtlani: ―Tlamachtiyani, tel, ¿tlen nicchihuas ic nicahsis in nemilistli nochipa? ");
INSERT INTO ncjNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","In Jesús omonanquilic: ―Tel, ¿tlenon ihcuiliutoc ipan in tlanahuatili? Huan tel, ¿quen tictlahtoltiya? ");
INSERT INTO ncjNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","In tlamachtiyani den tlanahuatili otenanquilic: ―Xitetlasohtla in Motecohtzin Dios ica nochin moyolo, huan ica nochin monemilis, huan ica nochin mochicahualis, huan ica nochin motlanehnehuilis. Huan xictlasohtla motlacaicniu ijcon quen tehhua timotlasohtla. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Oncan in Jesús omoluic: ―Otinechnanquilic cuali. In tla ijconon ticchihuas, ticpiyas inon nemilistli. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Huan in tlamachtiyani den tlanahuatili oquinequiyaya mopalehuis ica tlen otetlahtlanic, huan otetlahtlanic in Jesús: ―Tel, ¿aquinon notlacaicniu? ");
INSERT INTO ncjNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Oncan in Jesús omonanquilic: ―Se tlacatl otemohuaya ipan in ohtli Jerusalén hasta Jericó, huan oquitzacuilihque sequin ichtejcamen huan oquicuilihque itlaquen huan oquihuihhuitejque huan oyahque. Huan oquicauteuque yomictoya. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Huan san cana, opanotaya se tiopixqui, huan ic oquitac, oquitlacolui. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Huan noyojqui se levita, tlapalehuiyani ipan in tiopan, noyojqui opanoc ompic. Huan ihcuac oquitac, opanoc quen ahmo tlen oquitac. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Huan se tlacatl samariahteco onehnemiyaya ipan inon ohtli, huan ic oquitac inon cocoxqui, ica otlocox. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Oncan omopacho inahuac inon cocoxqui, huan oquitlalili pahtli den vino huan aceite canin tlacocoli huan oquiyalo ica in tatapahtli. Huan oquitlehcahui ipan icahuayo huan oquihuicac quitepaluiya huan ompa oquixpixtoya. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Huan ic mostla, ihcuac oya inon samariahteco, oquiquixti in tomin huan oquimacac iteco inon cali. Huan oquiluic: “Oncan xiquixpiya inin cocoxqui, huan tla ahmo ahsis inin tomin, nimitztlaxtlahuilis ihcuac nimocuepas.” ");
INSERT INTO ncjNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Tel, ¿catli yehhua de inin yiyinten oquis itlacaicniu in cocoxqui aquin oquitzacuilihque in ichtejcamen? ");
INSERT INTO ncjNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","In tlamachtiyani den tlanahuatili oquihto: ―Yehhuatl in aquin ica otlocox. Oncan in Jesús omoluic: ―Xiyau, huan no ijconon xicchihua. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Huan ic ohuilohuaticatca, in Jesús oahxihuac ipan se altepetl tlachicoyan, huan ompa oteseli ichan se sihuatl itoca Marta. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","In Marta oquipiyaya oc se icniu itoca María, huan yehhuatl omotlali tenahuac in Jesús maquicaqui in tlen mihtohua. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Huan Marta quen oquipiyaya miyac tlen quichihuas huan omopacho tenahuac in Jesús huan oteiluic: ―Notecohtzin, tel, ¿ahmo mochihuas cuenta ica in nocniu, quen nechcahuas nosel ica in tlen nicchihuas? Mamolui quen manechpalehui. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Huan Jesús omonanquilic: ―Marta, ticchihuas cuenta ica miyac tlen ticchihua, huan titequimiqui. ");
INSERT INTO ncjNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ahmo ijcon maye. Tlahmo san se tlahtoli oncan tlen monequi ticaquini. In María oquitlapehpeni in tlen ocachi cuali huan niyan aquin ahhuel quicuilis. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Se tonali queman Jesús omoyolmachtiloticatca, huan ihcuac otlan, otetlahtlani se tetlamachticau: ―Notecohtzin, matechnextililo quen timoyolmachtisque ijcon quen Juan Tlacuatequiyani oquinnextili in itemachticahuan. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","In Jesús oquiniluiloc: ―Ihcuac nanmoyolmachtisque, xiquihtocan: Tohueyitahtzin aquin ilohuac neluicac, mahuesticatzintli ica Tetocahtzin. Huan maquintequiutilo nican tlalticpac, ijcon quen mochiutoc neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Matechmacalo axan in tlacuali ipan inin tonali. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Matechtlapohpoluilo totlahtlacoluan, tleca noyojqui tehhuanten tiquintlapohpoluiyahque in aquin techchihuilihtoque in ahmo cuali. Huan ahmo matechcahualo tlen techyoltilana ic techcuepani ahmo cuali, in tlahmo matechmaquixtilo ipan in ahmo cuali. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","In Jesús noyojqui omoluihque: ―Tiquihtosque quen se de namehhuan quipiya se itenonotzcau, huan ipan tlahcoyohuac hualas ichan huan quiluis: “Notenonotzcau, xinechtlaneuti yiyi pantzin, ");
INSERT INTO ncjNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","tleca se notenonotzcau hueloc oahsico nochan huan ahmo nicpiya tlen nicmacas.” ");
INSERT INTO ncjNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Huan tiquihtosque quen in oc seya cualnanquilis tlahtec huan quiluis: “Ahmo xinechmohsihui, tleca yitlatzactoc huan tinochten ticochtoque. Ayacuel nimehuas ic nimitzmacas tlen.” ");
INSERT INTO ncjNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Namechiluiya, masque ahmo mehuas ic quimacas tlen quen itenonotzcau, ijcon quichihuas ic ayacmo maquimohsihuitiye huan quimacas nochin tlen quinequi. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ijcon tel, namechiluiya, xictlahtlanican huan Dios mechmacalos. Xictemocan, huan mechpalehuilos ic nancahsisque. Huan xitenotzacan huan mechnanquililos. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tleca in aquin ijcon quitlahtlanis, yehhua quiselis in tlen quinequis. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Tel, ¿oncan se de namehhuan quen tetata, huan ixcohyehuis quimacas se tetl in iconeu ihcuac quitlahtlanilis itlacual? ¿Noso quimacas se cohuatl ihcuac quitlahtlanis in michi? ");
INSERT INTO ncjNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Noso quimacas se colotl ihcuac quitlahtlanis in totoltetl? ");
INSERT INTO ncjNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tel, tla namehhuan ahmo nancualten, huan nanquimatihque nanquimacasque tlen cuali namopiluan, Totahtzin aquin ilohuac neluicac ocachi monequis quinmacalos in Itiotonaltzin Dios in aquin tetlahtlanilisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","In Jesús omixtohuetzohticatca se ahmo cuali yehyecatl quen oquimudohtili se tlacatl. Huan ihcuac in ahmo cuali yehyecatl oquis, in mudo cuali otlahto. In tlacamen quen tel oquimatque ica inin. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Huan sequin oquihtoque: ―Inin tlacatl quinixtohuetzohua in ahmo cuali yehyecamen ica ichicahualis Beelzebú; yehhua in aquin quintequiutiya. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Huan oc sequin oquinequiyayahque teichtacaahsihque, huan otetlahtlanilihque se tlachiutli den neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Huan Yehhuatzin omomautoya tlen oquinehnehuilihtoyahque huan omoluihque: ―San tlen altepetl tlen xeliutos ica in ixnamiquilistli huan sequin motehuiyahque ica in oc sequin, ijcon motlacaihtlacahuiyahque. Huan noyojqui ipan se cali xeliutos ic motlahtolchihuiyahque huan ijconon motlacaihtlacahuiyahque. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ijcon noyojqui in ahmo cuali tlacatl Satanás, tla xeliutosque ic yehhuan tel, ¿quen cuali huehcahuis in ichicahualis? Inin niquihtohua tleca namehhuan nanquihtohuahque niquinixtohuetzohua in ahmo cuali yehyecamen ica in ichicahualis Beelzebú. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Huan tla ijconon, ¿aquinon quinmacasque in chicahualistli inohque tecuitlapanuiyanimen, quen yehhuan quinixtohuetzohuahque in ahmo cuali yehyecamen? Huan ic inon yehhuan quinextiyahque quen namehhuan nanmotlapolochtihtoque. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Huan tla ica inon techicahualis in Dios niquinixtohuetzohua in ahmo cuali yehyecamen, inin quihtosnequi yomechmatiltiloc quen yoahsico in tetlatequiutilistzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Ihcuac se tlacatl moyequetztoc huan quipiya tlen ic mopalehuis huan ijcon quixpiya ichan huan nochin tlen quiehua ompa, ahhuel tlen polihuis. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Huan tla hualas oc seya aquin ocachi mohualyequetztas, huan quitlanis, oncan quicuilis nochin tlen ic mopalehuini huan quinxehxeluis nochin tlen otecuili. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’In aquin ahmo nechpalehuiya, yeh in aquin nechixnamiqui. Huan in aquin ahmo nechpalehuiya ica tlen nicnechicohua, yehhua in aquin quinxiniya. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Ihcuac in ahmo cuali yehyecatl quisa ipan se tlacatl, nemi canin ahyac tlen. Quitemohtinemi canin mosehuis, huan ihcuac ahmo cahsi, quinehnehuiliya mocuepas canin ocatca. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ihcuac mocuepas, cahsitiu inon tlacatl quen in cali tlayectlalili huan tlachpantli. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Oncan yas huan quinanatiu oc chicome yehyecamen ocachi ahmo cualten quen yehhua, huan nochten mochantisque ipan inon tlacatl huan ijconon inon tlacatl mochihuas ocachi ahmo cuali quen in achto. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ihcuac in Jesús omihtohticatca inin tlahtoli, se sihuatl inepanco inon tlacamen otlahtohtehuac: ―Pactoc in tenana aquin oteyoliti. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Huan Yehhuatzin omihto: ―Mapactocan ocachi in aquin quicaquihque tlen Dios mihtohua huan tetlacamatihque. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Inon tlacamen oteyehualohtinemiyayahque in Jesús, huan Yehhuatzin oquinnonotzaloc: ―In tlacamen de inin tonalten ahmo cualten, huan quitlahtlani se tlachiutli den neluicac. Huan ayacmo motenextilis oc sequin tlachiuten ocachi den tlen opanoc ica in tlayolchicauqui Jonás. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ijcon quen in tlen opanoc ica Jonás ocatca se tlanextili ica in altepetl den Nínive, noyojqui nehhuatl aquin Nitetiachicau ica nochin tlacatl yes quen se tlanextili ica in tlacamen de inin tonalten. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ipan in tonali den tlixcomacalistli, ihcuac quinixcomacasque in tlacamen de inin tonalten, in sihuahueyixtoc den tlali Seba quintlahtlacoltis. Tleca yehhua ohuala ocachi huehca den tlalticpactli ic quicaquis tlamatilistli den hueyixtoc Salomón, huan nican oncanca ocachi quen in hueyixtoc Salomón. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","In aquin ochantiyayahque ipan in altepetl Nínive moquetzasque ipan in tonali den tlixcomacalistli ihcuac quinixcomacasque in tlacamen de inin tonalten huan quintlahtlacoltisque, tleca in tlacamen den Nínive omoyolcuepque ihcuac Jonás oquincaquilti in itlahtoltzin Dios. Huan nicanca oc seya ocachi quen in Jonás. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Niyan aquin quitlatiya se tlanextli huan quitlalis canin tlatlatiyan, niyan quitlalis iihtejco se cajon, tlahmo quitlalis huehcapa huan ijcon in aquin calaquisque quipiyasque tlanextli. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Toixtelolo inon quen se tlanextli den totlacayo. Tla moixtelolo cuali, nochin motlacayo quipiya tlanextli. Huan tla moixtelolo ahmo cuali, nochin motlacayo yetoc ipan tlayohuilotl. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ximomalui ica in tlanextli tlen ticpiya ahmo mamocuepa tlayohuilotl. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tel, tla nochin motlacayo quipiya tlanextli, niyan chihton tlayohuilotl, nochin tiquitas chipahuac quen ihcuac mitztlanextilis se tlanextli. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ihcuac Jesús otlan quinnonotzalo, se fariseo otetlatlautic ica in tlacuali ichan. In Jesús ocalacohuac huan omotlaliloc iixpa in mesa. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","In fariseo quen tel oquimat ic oteitac quen ahmo omochiu quen ca intlamachilis ic omomahtequiloc ic tlacualos. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Huan in Totecohtzin omoluic: ―Namehhuan fariseos nanquipahpacahque in vasos huan platos iixco huan namehhuan namoyolihtec san nantlachtejcamen huan mechyolmautoc tlen ahmo cuali. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Nanxoxos! Tel, ¿ahmo nanquimatihque in Dios aquin omochiu in tlen iixco noyojqui omochiu iyolihtec huan monequi nochin chipahuac? ");
INSERT INTO ncjNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Huan ximoyolcuepacan huan xictemacacan namotetlocolil in tlen nanquipiyahque namoyolihtec huan ijcon mocahuas nochin chipahuac. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Tetlocolti ica namehhuan fariseos! Onantetlocolihque in diezma den menta huan in ruda huan oc sequin xihuitl huan nanquixpanahuiyahque in tlen tlamelajcan huan tetlasohtlalis in Dios. Nanquichihuanihque ijcon quen in achto namotetlocolil. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Tetlocolti ica namehhuan fariseos! Nanquinequihque nanmohueyilisque ipan in tiopanten huan nanquinequihque mamechmahuestilican san canin. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Tetlocolti ica namehhuan, tlamachtiyanimen den tlanahuatili huan fariseos, san ome namoxayac! Namehhuan quen tlaltecochten tlen ahmo nesi. San quimpanahuiyahque niyan ic quimatihque. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Oncan omonanquilic seya de inon tlamachtiyanimen den tlanahuatilten. Omoluic in Jesús: ―Tlamachtiyani, ic tiquihtos inon, noyojqui titechixtlasa tehhuanten. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Huan Jesús omihto: ―¡Tetlocolti ica namehhuan noyojqui, tlamachtiyanimen den tlanahuatili! Tleca onanquihueyilihque inon tlanahuatilten, huan quen molui tequiyo ic quitlacamatisque, mihtos ic tlacamatisque in oc sequin. Huan ica namehhuan, ahmo. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Tetlocolti ica namehhuan! Tleca nanquichihchihuahque in tlaltecochten den tlayolchicaucamen aquin oquinmictihque in namochichicacoluan. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Huan ic inon quinmatiltiyahque quen san se nanquimautoque ica tlen oquichiuque in namochichicacoluan. Yehhuan oquinmictihque huan namehhuan nanquichihchihuahque in tlaltecochten. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Huan ic inon omihto in Dios ica tetlanehnehuilis: “Namechtitlanilis tlayolchicaucamen huan notiotlatitlaniluan, huan quinmictisque sequin huan oc sequin quinmohsihuisque.” ");
INSERT INTO ncjNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Dios motlaxilisque in tlacamen de axan ica in temictilistli tlen oquichiuque queman omochiu in tlalticpactli. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Opeu ica in imiquilis Abel huan hasta Zacarías, aquin oquimictihque iixpa in tiopan. Huan ic inon namechiluiya quen Dios quintlaxilisque inin tlacamen de axan ica inohque mijcamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Tetlocolti ica namehhuan, tlamachtiyanimen den tlanahuatilten! Tleca nanquimatihque quen mopachosque in Dios huan niyan ijconon nanmopachohuahque huan niyan nanquincahuahque mamopachocan in oc sequin. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ihcuac in Jesús omoluihque inin, in tlamachtiyanimen den tlanahuatilten huan in fariseos molui ocualanque tehuan Yehhuatzin. Huan ijcon opeuque temohsihuiyahque ica san tlen tlahtlanilisten. ");
INSERT INTO ncjNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ic teistlacaahsisque in tla cuali teteluisque ica tlen ahmo cuali mihtos. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Huan ic inon omosentlalihque molui miyacten in tlacamen hasta omixtopeuticatcahque. Huan Jesús opeu quiniluilo achto in tetlamachticahuan: ―Huan ximomaluican ica in tlen quinextilisque in fariseos, quen tiquihtosque ica in ome inxayac. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","In tlen quichiuticaten ica ome inxayac ahhuel quitlatisque nochipa. Masque axan tlatiutoc, nochin motematiltis. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ic inon, tlen onanquihtohque ichtaca, huan satepa quicaquisque. Huan tlen omoluihque tlatlatiyan quincaquiltisque temiyacaixpa. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Namehhuan notenonotzcahuan ahmo xiquinmoucaitacan in aquin temictiyahque huan satepa ahhuel ocachi quichihuasque tlen. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Huan namechiluiya ica aquin nanquimoucaitasque. Xitemoucaitacan in Dios aquin cuali temictiya huan mopiya tequihuahyotl ic tetlasas in mictlan. Queme, xitemoucaitacan in Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Monemaca in totomen molui barato, huan Dios ahmo molcahua ica niyan se de yehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Noyojqui namotzon namehhuan motlamipoutoc. Ahmo ximomoutican tel. Ocachi mechchihuahque cuenta namehhuan quen in miyac totomen. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Namechiluiya, nochten aquin motemactiyahque ica nehhua inixpa in tlacamen, noyojqui nehhua aquin Nitetiachicau ica nochin tlacatl no nimotemactis ica yehhuan inixpa in ángeles den Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Huan in aquin ahmo motemactiyahque ica nehhua inixpa in tlacamen, no ahmo nimotemactis inixpa in ángeles den Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Huan in aquin teca tlahtohua ica nehhua aquin Nitetiachicau ica nochin tlacatl, cuali motlapohpoluis. Huan in aquin quitenehua in Itiotonaltzin Dios ahhuel quitlapohpoluisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Ihcuac mechuicasque iixpa in tequihuahmen ic mechixcomacasque, ahmo xiahcomanican quen nanquinnanquilisque noso ica tlen nanquihtosque. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tleca ihcuac nantlahtosque, in Itiotonaltzin Dios mechmatiltis tlen nanquihtosque. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Seya de inon tlacamen oteiluic in Jesús: ―Tlamachtiyani, mamolui in nocniu manechxelui in tlen onechtechtihque. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Huan in Jesús omoluic inon tlacatl: ―Tlacatl, tel, ¿aquin onechtlali nitlaxelohuani noso nitlixcomacani ica namehhuan? ");
INSERT INTO ncjNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Noyojqui omihto: ―Ximomaluican huan ahmo ximotlatzotzocahuican, tleca inemilis in tlacatl ahmo huelica quipiyas miyac tlen. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Oncan omoluihque se tlanonotzali tlen ic maquichihuacan cuenta: ―Ocatca se rico huan ipan itlaluan molui otlamochiu. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Oncan inon rico oahcomanticatca: “Tel, ¿axan tlen nicchihuas? Huan ahmo nicpiya canin niquehuas in tlen mochihuas ipan in tlamiloli.” ");
INSERT INTO ncjNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Huan satepa oquinehnehuili: “Niyau niquinxitini canin nimotlaehuiya huan niquinchihchihuas ocachi huehhueyi huan ompa nimotlaehuis ica nochin tlen nicpiya. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Oncan niquiluis in nonemilis: Ticpiyahque miyac tlen tiqueutoque huan techuehcahuas. Matimosehuican huan matitlacuacan, huan mitipaquican.” ");
INSERT INTO ncjNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Huan Dios omoluic inon rico: “Tlacatl, quemach titonto; inin tlayohua timiquis, huan ica in tlen tiqueutoc, tel, ¿aquin ihuaxca yes?” ");
INSERT INTO ncjNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Huan ijcon quipanohua in tlacatl aquin motlaehuiya nican tlalticpac huan teixpa in Dios ahmo tlen quipiyas. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Satepa in Jesús omoluihque in tetlamachticahuan: ―Huan namechiluiya tel, ahmo xiahcomanican ica tlen nanmotecpanosque huan niyan ica tlen nanquiquemisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","In Dios nele otechmacalo in nemilistli, huan cuali techtlamacalo. No ijcon oquimochihuili in totlacayo huan cuali techtlaquentilo. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Xicchihuacan cuenta ica in totomen, quen ahmo tlen quimilohuahque huan ahmo tlen quiehuahque, huan ijconon Dios quimpanoltilotica. Quemach, ¿namehhuan ahmo mechpanoltisque in Dios? ");
INSERT INTO ncjNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Tel, ¿aquin de namehhuan, ic ahcomana, cuali moscaltis oc tlahco metro? ");
INSERT INTO ncjNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Huan quen ahhuel nanquichihuasque niyan in tlen ocachi chihton, tel, ¿tleca ocachi nanyehyeltihque ic nanquichihuasque oc sequin itlahtlen? ");
INSERT INTO ncjNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Xicchihuacan cuenta quen yoli in xochitl, niyan ahmo tlen quichihua. Huan ic inon namechiluiya, niyan quen in hueyixtoc Salomón omotlaquenti cualtzin quen inon xochitl. Huan nele cualtzin omotlaquenti yehhua. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Huan tla ijconon in Dios omochiu cualtzin in xihuitl huan quen ca axan cualtzin huan mostla quitlatisque, tel, ¿tleca in tlahmo ocachi mechtlaquentilos cualtzin namehhuan san chihton namotlaneltoquilis? ");
INSERT INTO ncjNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Huan ic inon, ahmo xiahcomantinemican tequin ica tlen nanquicuasque huan ica tlen nampanosque. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tleca in tlalticpac tlacamen quitemohuahque san inon. Huan namehhuan nanquipiyahque Namotahtzin huan Yehhuatzin momati nochin tlen mechpolohtoc. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ocachi cuali xicchihuacan cuenta ica tlen monequis in Dios huan ijconon nanquiselisque nochin. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Ahmo ximomoutican, notlasohicnihuan. Ahmo nanmiyacten huan Namohueyitahtzin monequi mechtechtilos. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Xicnemacacan in tlen nanquipiyahque huan xiquinmacacan in aquin quimpolohtoc. Huan ijconon ompayes namotlaehual neluicac canin ahyic tlami huan canin ahhuel calaquis niyan in ichtejqui. Huan niyan teyinis ic cuahcualohuas. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Huan canin eutos namotlatlan, noyojqui ompa nanahcomanihque nanyesque. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Ximoyectlalican ica namotlaneltoquilis quen in tlanexten xotlatiyesque. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Xiyecan quen in tlaquehualten mochixtiyesque ic mocuepas in impatrón ipan in mosihuautilistli. Yehhuan quitlapoluisque niman ic ahsiquiu huan quinnotzas. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mapactocan in tlaquehualten in aquihque mochixtosque ihcuac ahsitiu in patrón. Ic nele, namechiluiya, inon patrón moyectlaliya ic mechtlalis inahuac in mesa huan mechtlamacas. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Masque yohuac noso ic tlatuihtas ahsitiu, tla quinahsitiu mochixtosque, mapactocan inon tlaquehualten. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Huan xicmatican inin, tla iteco se cali quimatisquiyani tlen horas ahsitiu in ichtejqui, mochixtos huan ahmo mocahuas maquitlachtequican. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Namehhuan noyojqui ximoyectlalican. Tleca san cana nihualas nehhua aquin Nitetiachicau ica nochin tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Oncan Pedro otetlahtlani: ―Notecohtzin, tel, ¿omotlali inin tlahtoli san para tehhuanten noso para nochten? ");
INSERT INTO ncjNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Omihto in Totecohtzin: ―Tel, ¿aquin tlahpixqui tlamelajcan huan tlamati? Yeh in aquin quicahuahque quen tlachixqui ipan ichan, ic quintlamacas ihsiu in oc sequin. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mapacto in tlaquehuali in aquin quiahsitiu in ipatrón quichiutiyes in tlen itequiu. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ic nele namechiluiya, in patrón quitlalis quen tlachixqui ica nochin in tlen quipiya. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Huan tla inon tlachixqui quinehnehuiliya huehcahuihtiu in ipatrón, huan cana pehuas quinmohsihuis in oc sequin tlaquehualten huan in tescamen, huan tla yehhuatl san tlacuas huan san huintitinemis, ");
INSERT INTO ncjNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","oncan san cana in ipatrón mocuepas ipan in tonali queman inon tlaquehuali ahmo mochixtos huan ijconon tequin quitlapanoltis. Huan quitlahtlacoltis ica in ihualal quen in oc sequin ahmo tlamelajcanten. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’In tlaquehuali aquin quimati tlen quinequi in ipatrón huan ahmo moyectlaliya niyan quitlacamatis, inon quitlapanoltis tequin. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Huan in tlaquehuali aquin ahmo quimati huan quichihuas ica tlen quitlapanoltis, inon ahmo yojqui quitlapanoltis. In aquin quiseliya ocachi miyac, quitlahtlanilisque ocachi. Huan in aquin motemachiya tequin, quitlahtlanilisque ocachi. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Nehhua onihuala nicxotlaltiya in tletl ipan in tlalticpactli huan nicnequisquiyani quen maye xotlatiyeni. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nicpiya tlen nicxicos ica tlen nitlapanos huan ijcon xotla in tletl. Huan ic nitlocoya hasta ic nictlamis inon. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Tel, ¿nanquinehnehuiliyahque namehhuan onihuala niquinsetiliya nican tlalticpac? Namechiluiya ahmo, tlahmo xeliutosque. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tleca de axan para nochipa, ica inon macuilten ipan se cali xeliutosque yiyi ica in ome, noso ome ica in yiyi moixnamiquisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","In itata quixnamiquis in iconeu, huan in iconeu quixnamiquis in itata, huan in inana quixnamiquis in ichpocau huan in ichpocau quixnamiquis in inana, huan imonantzin quixnamiquis in isihuamo, huan isihuamo quixnamiquis in imonantzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","In Jesús noyojqui omoluihque in tlacamen: ―Ihcuac namehhuan nanquitahque in mextli hualmahcocui, namehhuan nanquihtosque yau quiahui, huan ijcon panohua. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Huan ihcuac tonalyehyeca, nanquihtosque yau tlahuaqui, huan ijcon panohua. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Namehhuan ome namoxayac! Namehhuan nanquimatihque in tlen panohua neluicac huan tlalticpac. Tel, ¿tleca ahmo nanquimatihque in tlen nicchiutica inin tonalten tlen nampanoticaten? ");
INSERT INTO ncjNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’Tel, ¿tleca ahmo namoixcomaca san namehhuan? ");
INSERT INTO ncjNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","In tla aquin quiteluiya se de namehhuan, huan yas ihuan motemactis iixpa in tlixcomacani, maquinehnehuili mosetilis ihuan ipan in ohtli ic ahmo maquihuica iixpa in tlixcomacani. Tla ijconon in tlixcomacani quitemactis imajco in topili huan yehhuatl quihuicas telpiloyan. ");
INSERT INTO ncjNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Namechiluiya quen ahmo quisas de ompa ic quitlaxtlahuas ic quisas. ");
INSERT INTO ncjNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ipan inon tonali ohualahque sequin tlacamen tenonotztihuitzen in Jesús quen Pilato otlatequiuti ic oquinmictihque sequin tlacamen den Galilea. Huan oquimau in inyes ihuan in inyes in yolcamen tlen oquinmictihque quen intetlocolil. ");
INSERT INTO ncjNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Huan in Jesús oquiniluiloc: ―Tel, ¿nanquinehnehuiliyahque namehhuan ijcon oquimpanoc inon tlacamen den Galilea tleca ocachi tlahtlacolyohque quen den oc sequin altepemen? ");
INSERT INTO ncjNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Namechiluiya nele ahmo. Tla namehhuan ahmo nanmoyolcuepasque, noyojqui nantlapanosque. ");
INSERT INTO ncjNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Noso tel, ¿nanquinehnehuiliyahque ocachi tlahtlacolyohque inohque caxtoli huan yiyi aquin omijque ihcuac oquimpechi in torre den Siloé, quen in oc sequinten aquin ochantiyayahque Jerusalén? ");
INSERT INTO ncjNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Namechiluiya nele ahmo. Tla namehhuan ahmo nanmoyolcuepasque, noyojqui namehhuan nantlapanosque. ");
INSERT INTO ncjNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","In Jesús oquiniluiloc inin tlalnamictilistli: ―Se tlacatl oquipiyaya se higoscohuitl ipan itlal, huan oya quiita tla oquipiyaya in itlaquilyo, huan ahmo tlen ocahxili. ");
INSERT INTO ncjNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Oncan oquiluic in aquin tlixpixqui ipan inon itlal: “Xiquita, yiyi xiupa nihuitz nictemoliya in itlaquilyo in cohuitl, huan ahyic nicahxiliya. Xicmayahui. ¿Tleca tlasehualohua san tlaluis canin ca?” ");
INSERT INTO ncjNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Huan in aquin tlixpixqui ipan inon tlali oquinanquilic: “Oc mamocahua inin xihuitl. Niyau nicxocaxani ica in tlali, huan nictlaxilis in majada. ");
INSERT INTO ncjNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Huan ic inon cana quitemacas in itlaquilyo, huan tla ahmo, ihcuac inon, mamoxotequi.” ");
INSERT INTO ncjNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ipan se tonali den nesehuilistli in Jesús otlamachtilotoya ipan se tiopantli. ");
INSERT INTO ncjNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Huan ompa ocatca se sihuatl cocoxqui ica caxtoli huan yiyi xihuitl. Inon se ahmo cuali yehyecatl oquicuelo huan yehhua ahhuel omomelau niyan queman. ");
INSERT INTO ncjNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ihcuac Jesús omotac, omonotz huan omoluic: ―Sihuatl, axan yotipahtic ica in mococolis. ");
INSERT INTO ncjNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Oncan omomachilic ica teman, huan niman inon sihuatl omomelau huan opeu temahuestiliya in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Huan inon tlayecanqui den tiopantli ocualan, tleca in Jesús otlapahtiloc ipan in tonali den nesehuilistli. Huan oquiniluic in tlacamen: ―Oc oncan chicuasin tonali ic nantequitisque huan ipan inon tonalten nanualasque namopahtisque, huan ahmo ipan in tonali den nesehuilistli. ");
INSERT INTO ncjNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Oncan in Totecohtzin omonanquilic: ―San ome namoxayac, tel, ¿ahmo nanquintohtomahque namoyolcahuan, in cuacue noso in burro, ic nanquinatliltisque huan ahmo maquintlapanoltican ica amiquilistli ipan in tonali den nesehuilistli? ");
INSERT INTO ncjNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Huan inin sihuatl ichanihcau in Abraham aquin oquitlapanoltihticatca caxtoli huan yiyi xihuitl in ahmo cuali tlacatl, tel, ¿ahmo ticpahtisque, ayacmo matlapanotiye, masque ipan in tonali den nesehuilistli? ");
INSERT INTO ncjNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ihcuac in Jesús omihto inin, in tecocolihcahuan omopinautihque. Huan nochin in tlacamen molui opactoyahque ic oquitaque in tlen tlachiutli omochiu in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Oncan in Jesús omihto: ―Tel, ¿quen ixnesi in tetlatequiutilistzin Dios? ¿Huan ica tlen niteixnextis? ");
INSERT INTO ncjNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Inon quen se xinachtli den mostaza quen in aquin quitoca ipan itlal. Huan yolis inon xihuitl hasta quen se cohuitl hueyi mochihuas. Huan in totomen ompa motlapehpechtisque ipan in imahxal. ");
INSERT INTO ncjNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Noyojqui omihto in Jesús: ―Tel, ¿ica tlen cuali niquixnextis in tetlatequiutilistzin Dios? ");
INSERT INTO ncjNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Inin quen tlen ic semahui in pantzin quen in sihuatl quinelos ica yiyi medida den harina huan ica chihton semahuis nochin inon textli. ");
INSERT INTO ncjNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","In Jesús ic ohuilohuac Jerusalén, opanolotaya ipan in altepemen tlen caten inahuac canin otlamachtilohuaya. ");
INSERT INTO ncjNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Huan san aquin otetlahtlanihque: ―Notecohtzin, tel, ¿san quesqui in aquin maquisasque? Huan Yehhuatzin omonanquilihque: ");
INSERT INTO ncjNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Xicchihuacan cuenta ic nancalaquisque ipan puerta pitzahuac den temaquixtilistli, tleca namechiluiya, miyacten quinequihque calaquisque, huan ahhuelihtis. ");
INSERT INTO ncjNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Satepa in iteco in cali tlatzacuas huan namehhuan aquin nancaten quiahuac nanquixuitequisque in puerta huan nanquihtosque: “Notecohtzin, matechtlapoluilo.” Huan yehhua mechnanquilis: “Ahmo namechixmati namehhuan.” ");
INSERT INTO ncjNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Oncan namehhuan nampehuasque nanquihtosque: “Otitlacuahque huan otiatlihque mohuan. Huan tehhuatl otitechnextili canic tinehnemisque.” ");
INSERT INTO ncjNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Huan yehhua mechualnanquilis: “Yonamechiluic ahmo namechixmati. Xinechcahuacan namehhuan aquin san tlen nanquichihuahque.” ");
INSERT INTO ncjNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Huan ompa hasta nantzihtzicnosque ic nanchocasque ic nanquitasque in Abraham, huan Isaac, huan Jacob, huan nochten in oc sequin tlayolchicaucamen aquin caten canin tlatequiutilo in Dios, huan namehhuan omechixtlasque. ");
INSERT INTO ncjNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tleca hualasque in tlacamen de nohuiyan ic mosehuisque tlacuasque canin tlatequiutilo in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Oncan sequin aquin satepanten axan, yehhuan mochihuasque achtohque. Huan sequin aquin axan achtohque yehhuan mochihuasque satepanten. ");
INSERT INTO ncjNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ipan inon tonali oahsitohque sequin fariseos huan oteiluihque: ―Xiquisa de nican tleca Herodes quinequi mitzmictis. ");
INSERT INTO ncjNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Huan Yehhuatzin omonanquilihque: ―Xiyacan xiquiluican inon san ome ixayac: “Xiquita, axan huan mostla niquinixtohuetzos in ahmo cuali yehyecamen, huan niquimpahtis in cocoxcamen, huan huiptla nictlamis.” ");
INSERT INTO ncjNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Huan nicpiya tlen niyahtiyes ipan inin ohtli axan huan mostla huan huiptla, tleca ahmo ijcon tla se tlayolchicauqui miquis tlatentli den Jerusalén. ");
INSERT INTO ncjNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Tlacamen den Jerusalén, namehhuan aquin nanquinmictiyahque in tlayolchicaucamen huan nanquintemacahque in tetlatitlaniluan aquin Dios mechualtitlanililo! ¡Miyacpa onicnec namechsentlalis quen in cuanaca quinsentlaliya san secnin in ipiluan, huan ahmo onanquinejque! ");
INSERT INTO ncjNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Xiquitacan namehhuan, axan namechcahua xicchihuacan quen nanquinequisque. Huan namechiluiya, ayacmo nannechitasque hasta ahsiquiu in tonali queman nanquihtosque: “Tlatiochiutli Tehhuatzin in aquin hualuilohuas ica Itocahtzin Totecohtzin.” ");
INSERT INTO ncjNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Opanoc ipan se tonali den nesehuilistli in Jesús oilohuac tlacualo ichan se tlayecanqui fariseo. Huan in oc sequin fariseos otepihpixticatcahque. ");
INSERT INTO ncjNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Noyojqui ompa ocatca teixpa se tlacatl ica icocolis den semahuilistli. ");
INSERT INTO ncjNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Oncan in Jesús oquintlahtlaniloc in tlamachtiyanimen den tlanahuatili huan in fariseos: ―Tel, ¿cuali ticpahtisque se cocoxqui ipan in tonali den nesehuilistli, noso ahmo? ");
INSERT INTO ncjNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Huan yehhuan ahmo onahuatque. Oncan Yehhuatzin omomaquitzqui in cocoxqui huan omopahti huan omoluic mayau. ");
INSERT INTO ncjNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Huan in fariseos omoluihque: ―Tel, ¿aquin de namehhuan tla se iyolcau quen burro noso cuacue huetzis ipan se tlacoyoctli, ahmo nanquiquixtisque saniman, masque ipan in tonali den nesehuilistli? ");
INSERT INTO ncjNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Huan ahhuel tlen otenanquilihque. ");
INSERT INTO ncjNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","In Jesús omochiu cuenta ica inohque intetlatlautiluan oquitlapehpenihque canin ocachi cualtzin ipan mesa, huan omoluihque inon tlahtoli: ");
INSERT INTO ncjNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Ihcuac seya mitztlatlautis ipan in iluitl den mosihuautilistli, ahyic ximotlali canin ocachi tlayectlalili. Huelis hualas oc se itetlatlautil ocachi hueyi iquisca quen tehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Huan in aquin omitztlatlautic cana hualas mitziluis: “Ximihcuani huan mamotlali inin.” Oncan ticpiya tlen timihcuanis ica mopinahuilis huan ximotlali nepa tlatentli. ");
INSERT INTO ncjNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ocachi cuali ihcuac mitztlatlautisque, ximotlali sa tlatentli. Huan ihcuac hualas in aquin omitztlatlauti, mitziluis: “Notenonotzcau, xihualpano nican ocachi cuali.” Huan ijcon mitzmahuestilisque ocachi inixpa aquin inuan tiyehuatiyes. ");
INSERT INTO ncjNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tleca in aquin ocachi mohueyiliya, quixtohuetzosque, huan aquin ahmo mohueyiliya, ocachi quimahuestilisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","No omoluic inon tlacatl aquin otetlatlautic: ―Ihcuac ticchihuas se iluitl, ahmo xiquintlatlautic motenonotzcahuan, niyan mocnihuan, niyan moparientes, niyan in ricos. Tleca yehhuan mitztlatlautisque huan ijcon ticpiyas motlatlan. ");
INSERT INTO ncjNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ic oc noncua, ihcuac ticchihuas iluitl, xiquintlatlauti in prohues huan in cocoxcamen huan in nehnecuilten huan in ixpatzacten. ");
INSERT INTO ncjNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Huan tipactos, tleca yehhuan ahhuel mitztlaxtlahuilisque. Ijcon ticpiyas motlatlan ihcuac ihsasque in tlamelajcanten. ");
INSERT INTO ncjNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ic oquicac, seya aquin oyehuatoya iixpa in mesa, oteiluic in Jesús: ―Mapacto in aquin calaquisque canin tetlatequiutilistzin in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Oncan Jesús omoluic: ―Se tlacatl oquichiu se hueyi iluitlacuali, huan oquintlatlautic miyac tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Huan ihcuac yoquichihchiuque inon tlacuali, oquititlan in itlaquehual maquinnotza in tetlatlautilten mahualacan tleca yica nochin tlayectlalili. ");
INSERT INTO ncjNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Huan nochten opeuque monehnequihque. In aquin achto oquihto: “Hueloc onicou se tlali huan nicpiya tlen niyas niquitas. Nimitztlatlautiya xinechtlapohpolui.” ");
INSERT INTO ncjNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Huan in oc seya oquihto: “Onicou macuili yunta den cuacuehten huan niyau niquinita in tla cuali. Nimitztlatlautiya xinechtlapohpolui.” ");
INSERT INTO ncjNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Huan in oc seya oquihto: “Hueloc onimosihuauti huan ic inon ahhuel niyas.” ");
INSERT INTO ncjNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ihcuac in tlaquehuali omocuep, oquinonotz in ipatrón. Oncan yehhuatl ocualan huan oquiluic in itlaquehual: “Xiyau ihsiu ipan in ohtli huan in ohpitzactli ipan in altepetl, huan xiquinualica in prohues huan in cocoxcamen huan in nehnecuilten huan in ixpatzacten.” ");
INSERT INTO ncjNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Satepa oquihto in tlaquehuali: “Noteco, yonicchiu in quen otinechtequiuti huan oc oncan canin motlalisque oc sequin.” ");
INSERT INTO ncjNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","In patrón oquiluic oc sepa in itlaquehual: “Xiyau ipan in ohtli san canic huan xiquintequiuti in oc sequin mahualacan huan matemican in nochan. ");
INSERT INTO ncjNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tleca nimitziluiya ahmo niquincahuilis niyan seya de inohque aquin oniquintlatlautic achto quicuasque in notlacual.” ");
INSERT INTO ncjNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Miyac tlacamen otecuitlapanuiyayahque in Jesús, huan Yehhuatzin omocuitlapantlachiyaliloc huan omoluihque: ");
INSERT INTO ncjNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Tla seya huitz ica nehhua, huan ahmo nechtlasohtla ocachi quen itata huan inana huan isihuau huan ipiluan huan icnihuan huan ihueltihuan huan hasta inemilis, ahhuel mochihuas notemachticau. ");
INSERT INTO ncjNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Huan in aquin ahmo quinequis quen quixicos ic tlapanos, masque ipan in cruz, ahhuel mochihua notemachticau. ");
INSERT INTO ncjNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","In tla se de namehhuan quinequi quichihuas se tequitl, tel, ¿ahmo achto quichihuas cuenta ica in tomin tla cahxilis ic quitlamiltis? ");
INSERT INTO ncjNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","In tlahmo ijcon, quipehualtis inon tequitl, huan satepa ahhuel quitlamiltis, nochten pehuasque quitenehuasque yehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Huan quihtosque: “Inon tlacatl oquipehualti inon tequitl huan ahhuel oquitlamilti.” ");
INSERT INTO ncjNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Huan tla se hueyixtoc quinequi quichihuas se motehuilistli ihuan oc se hueyixtoc, tel, ¿ahmo achto quinehnehuilis tla ica mahtlactli mil soldados cuali quixnamiquis in oc seya in aquin hualas ica sempohuali mil? ");
INSERT INTO ncjNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Huan tla ahhuelitis, ihcuac in oc se hueyixtoc oc huehca yesque, quinahuatis maquitlapohpolui. ");
INSERT INTO ncjNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ijcon tel, san aquin de namehhuan ahmo quicahuas nochin tlen quipiya, ahhuel mochihuas notemachticau. ");
INSERT INTO ncjNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’In istatl cuali, huan tla quipolos in istatl in ichicahualoca, tel, ¿quen cuali motequiutis? ");
INSERT INTO ncjNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ahhuel motequiutis niyan ica in tlali, niyan ica in montón den majada, tlahmo sa tlaluis motohuetzos. In aquihque quicaquisque, maquinehnehuilican. ");
INSERT INTO ncjNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nochten in renderos huan in tlahtlacolyohque omopachohque tenahuac in Jesús ic tecaquisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Huan ic inon in fariseos huan in tlamachtiyanimen den tlanahuatilten teca otlahtohuayahque, huan oquihtohuayahque: ―Inin tlacatl quinseliya in tlahtlacolyohque huan inuan tlacua. ");
INSERT INTO ncjNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Oncan Jesús omotlalilihque se tlahtoli tlen ic maquichihuacan cuenta: ");
INSERT INTO ncjNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Tiquihtosque tla se de namehhuan quimpiya se ciento in calnelohten, huan quipolos in seya. Tel, ¿ahmo quincautehuas in oc sequin huan yas quitemos in tlen poliutoc? ");
INSERT INTO ncjNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Huan ihcuac quiahsis, quitlalis ipan iahcol huan pactos tleca oquiahsic. ");
INSERT INTO ncjNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Huan ihcuac ahsis ichan, quinsentlalis in itenonotzcahuan huan oc sequin tlacamen, huan quiniluis: “Xipaquican nohuan, tleca yonicahsic in calnelo tlen onicpolohtoya.” ");
INSERT INTO ncjNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Namechiluiya quen no ijconon oncan paquilistli in neluicac ica se tlahtlacolyo moyolcuepas, quen ica inon oc sequin naupohuali huan caxtoli huan nahue tlacamen cualten aquin ahmo quipiyahque tlen ic moyolcuepasque. ");
INSERT INTO ncjNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Tla tiquihtosque se sihuatl quipiya mahtlactli tomin tlen ocachi miyac ipatiu huan oquipolo seya. Tel, ¿ahmo quitlatis in tletl huan tlachpantas yolic ic quitemohtas hasta quiahsis? ");
INSERT INTO ncjNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Huan queman quiahsis, quinsentlalis itenonotzcahuan huan oc sequin huan quiniluis: “Xipaquican nohuan, tleca onicahsic in tomin tlen onicpolohtoya.” ");
INSERT INTO ncjNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","No ijcon namechiluiya oncan in paquilistli ica in ángeles den Dios tla se tlahtlacolyo moyolcuepas. ");
INSERT INTO ncjNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús noyojqui omihto: ―Se tlacatl oquimpiyaya ome ipiluan. ");
INSERT INTO ncjNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Huan in aquin ocachi xocoyotl oquiluic in itata: “Xinechmaca in notetlocolil in tlen tinechtechtiya.” Oncan in tetata oquintlaxelui. ");
INSERT INTO ncjNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Oncan satepa inon xocoyotl oquisentlali nochin tlen oquipiyaya huan oya huehca canin oquitlasohchiu nochin tlen oquipiyaya ica san tlen ahmo cuali oquichiu. ");
INSERT INTO ncjNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Huan ihcuac yotla quitlasohchihua in tlen oquipiyaya, ocatca se apistli in canin ocatca yehhuatl. Huan ijcon otlapanoc. ");
INSERT INTO ncjNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Oncan oya quitemohua tequitl inmajco se tlacatl de inon tlali. Huan inon oquititlan maquinixpiya in pitzomen. ");
INSERT INTO ncjNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Huan oquinequiyaya quicuasquiyani inon intlacual tlen oquicuayahque in pitzomen, huan niyan aquin oquimacac. ");
INSERT INTO ncjNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Oncan omonehnehuili: “¡Quesqui tequitcamen ichan notata quipiyahque intlacual miyac huan nehhuatl nican niyau nimiqui ica apistli! ");
INSERT INTO ncjNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Niyau nimocuepa canica notata huan niquiluis: Notata, nitlahtlacoltihtoc ica in Dios huan ica tehhuatl; ");
INSERT INTO ncjNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ayacmo xinechtocahhui quen moconeu. Xinechpohua quen se motlaquehual.” ");
INSERT INTO ncjNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Oncan omocuep ichan in itata. ’Ihcuac oc huehca, oquitac in itata huan ica otlocox in iconeu. Otzecuin quinamiqui huan oquitecocho ica paquilistli ic oquiseli. ");
INSERT INTO ncjNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Oncan in iconeu oquihto: “Tlasohtli notata, nitlahtlacolyo ica in Dios huan ica tehhuatl. Ayacmo tlen noquisca ic tinechtocahhuis moconeu.” ");
INSERT INTO ncjNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Huan in tetata oquiniluic in itlaquehualuan: “Xicualquixtican ihsiu in tlaquemitl tlen ocachi cuali huan xitlaquentican. Huan noyojqui xictlalilican in anillo ipan imahpil, huan xictecactican. ");
INSERT INTO ncjNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Xicanacan in cuacue in tlen tomahuac huan xicmictican. ¡Huan ticuasque huan ticchihuasque in iluitl! ");
INSERT INTO ncjNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tleca inin noconeu quen omictoya huan oc sepa oyol, huan opoliutoya huan axan oticahsique.” Huan ijcon oquichiuque in iluitl. ");
INSERT INTO ncjNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Ihcuac inon in tetiachicau ocatca ic mila. Huan ihcuac omocuep ic oahsitaya ichan, oquincac in tlatzohtzoncamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Oncan oquinotz se telpochtli huan oquitlahtlani tlen opanoc. ");
INSERT INTO ncjNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Huan inon telpochtli oquiluic: “Tleca ohuala in mocniu huan motata otlatequiuti maquimictican in cuacue tlen tomahuac, tleca oahsico in mocniu cuali.” ");
INSERT INTO ncjNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Huan quen oquicac in tetiachicau, ocualan huan ahmo oquinequiyaya calaquis. Ic inon in itata oquis quitlatlautiya macalaqui. ");
INSERT INTO ncjNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Huan yehhua oquiluic in itata: “Momati quesqui xihuitl nitepalehuihtoc huan nitetlacamautoc, huan ahyic nechmacatoque niyan se calnelo ic nicchihuas iluitl ihuan notenonotzcahuan. ");
INSERT INTO ncjNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Huan axan oahsico inin moconeu aquin oquitlasohchiu in tomin ica in sihuamen, huan ica yehhua ticmictis in cuacue tlen tomahuac.” ");
INSERT INTO ncjNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Oncan in itata oquiluic: “Notlasohconeu, tehhuatl nochipa nohuan tica, huan nochin tlen nicpiya mohuaxca. ");
INSERT INTO ncjNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Huan ic inon huelica ticchihuasque in iluitl huan tipaquisque, tleca in mocniu quen omictoya huan oc sepa oyol. Tleca opoliutoya huan axan oticahsique.” ");
INSERT INTO ncjNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","In Jesús noyojqui omoluihque in tetlamachticahuan: ―Ocatca se rico huan oquipiyaya se tlixpiyani huan oquinonotzque ica inon quen oquitlasohchiuticatca in tlen oquipiyaya. ");
INSERT INTO ncjNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Oncan in rico oquinotz huan oquiluic: “Tel, ¿tlen inin nechnonotzahque ica tehhuatl? Xinechmacti ica in motequiu, tleca ayacmo tiyes tlixpiyani ica nehhuatl.” ");
INSERT INTO ncjNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Oncan inon tlixpiyani opeu monehnehuiliya: “Axan tel, ¿tlen nicchihuas? In rico nechcuiliya in tequitl huan ahhuel nitequitis. Huan nipinahui nictlahtlanis limosna. ");
INSERT INTO ncjNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Neh nicmati tlen nicchihuas, huan nicmatis aquin nechselisque inchan ihcuac ahmo nicpiyas tequitl.” ");
INSERT INTO ncjNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Oncan oquinnotz sehsen aquin oquihuiquiliyayahque inon rico. In achto oquitlahtlani: “Tel, ¿quesqui ticuiquiliya in nopatrón?” ");
INSERT INTO ncjNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Huan yehhuatl oquinanquilic: “Nicuiquiliya se ciento barril den aceite.” Oncan in tlixpiyani oquiluic: “Nicanca mocuenta. Xicchihchihua oc seya san ica tlahco ciento.” ");
INSERT INTO ncjNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Satepa oquitlahtlani in oc seya: “Huan tehhuatl, tel, ¿quesqui ticuiquiliya?” Huan oquiluic: “Nicuiquiliya se mil anega den trigo.” Oncan oquiluic: “Nicanca mocuenta. Huan xicchihchihua oc seya san ica chicueyi ciento.” ");
INSERT INTO ncjNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Huan in rico oquichiu cuenta ica in itlamachilis in itlixpixcau quen oquichiu. Ica in tlalticpac tlacamen aquin ahmo teixmatihque in Dios ocachi tlamatihque ica tlen quichihuahque ica se huan oc seya quen in aquin teixmatihque in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Namechtequiutiya xicuican in tlatlantli de inin tlalticpac den tlahtlacolyotl san ic mamohuelitacan. Huan ihcuac tlamis inon tlatlanten onyes aquin mechselisque canin nanyesque nochipa. ");
INSERT INTO ncjNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’In aquin tlamelajcan ica chihton noyojqui inon tlamelajcan ica in ocachi. Huan in aquin ahmo tlamelajcan ica chihton niyan ica in ocachi. ");
INSERT INTO ncjNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Tla ahmo nanquitequiutisque cuali inon tlatlantli tlalticpac tlahtlacolyotl, tel, ¿aquin mechtemachisque ica in tlatlantli tlamelajcan? ");
INSERT INTO ncjNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Huan tlahmo nanquitequiutisque cuali in tlen mechmacalotoc Yehhuatzin, tel, ¿aquin mechmacas in tlen de namehhuan? ");
INSERT INTO ncjNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Niyan se tlaquehuali cuali quipiyas ome patrónes. Tleca quitlasohtlas in seya huan in oc seya ahmo. Noso tlamelajcan yes ica seya huan in oc seya quixtlasas. Ahhuel titepalehuisque in Dios tla san quitemachisque in tomin. ");
INSERT INTO ncjNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Inon fariseos, yehhuan in aquin oquitlasohtlayayahque san in tomin. Oquicajque nochin inin huan teca otlahtohque ica in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Oncan in Jesús oquiniluiloc: ―Namehhuan in aquin nanquinequihque nanmochihuasque cualten iixpa in tlacamen, huan Dios mechyoloixmatilo. Huan Dios quixtlasalo in tlen quimahuestiliyahque in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’De yihuehcau ocatca in tlanahuatili den Moisés hasta ihcuac onemiyaya in Juan Tlacuatequiyani. Huan noyojqui otlanextiliyayahque in tlayolchicaucamen. De inon tonalten oquinmatiltiyayahque in cuali tlahtoli ica in tetlatequiutilistzin Dios, huan molui yehyeltihque in aquin quinequihque calaquisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Huan inon tetlanahuatil ahmo mochihuas san tlaluis, masque motlamis in neluicactli huan in tlalticpactli. ");
INSERT INTO ncjNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Tla se tlacatl quicahuas isihuau huan ihuan motlalis oc seya, inon sihuaahuiltiya. Huan in aquin ihuan motlalis se sihuatl tlacacauqui noyojqui sihuaahuiltiya. ");
INSERT INTO ncjNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Ocatca se rico omotlaquentiyaya molui cuahcuali, huan mostli oquichihuayaya in iluitl molui cuahcuali. ");
INSERT INTO ncjNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Huan noyojqui ocatca se prohue itoca Lázaro, aquin molui oquipiyaya inon sahuatl chopoctli. Huan omotlaliyaya iixco ipuerta in rico. ");
INSERT INTO ncjNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Huan inon prohue oquinequiyaya in tlen huetzi ihtech imesa in rico. Huan hasta in chichimen oquipahpalohuayahque ica inon chopoctli. ");
INSERT INTO ncjNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Se tonali inon prohue omic, huan in ángeles ocuicaque canin ocatca in Abraham inuan in tlamelajcanten. Huan in rico noyojqui omic huan oquitlaltocaque. ");
INSERT INTO ncjNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ihcuac in rico otlapanotoya canin yahue in ahmo tlamelajcanten huan de huehca oquitac in Abraham ihuan in Lázaro. ");
INSERT INTO ncjNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Oncan oquinotz: “Totata Abraham, xitlocoya ica nehhua huan xictitlani in Lázaro mamomahpilpaltili ipan in atl huan mahualau nechtlalili ipan nonenepil, tleca tequin nitlapanotica ipan in tletl.” ");
INSERT INTO ncjNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Huan Abraham oquiluic: “Noconeu, xiquilnamiqui quen tehhua molui cuali oticpanoc monemilis, huan in Lázaro molui otlapanoc. Ica yehhuatl axan mapaqui nican huan tehhua titlapanohtiyes. ");
INSERT INTO ncjNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Huan ocachi oncan se hueyi tlatepehxiu ica tehhuanten huan ica namehhuan. Ijcon quen aquin quinequi yas ompa, ahhueli, niyan in aquin ompaca hualas nican.” ");
INSERT INTO ncjNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Oncan in rico oquihto: “Nimitznahuatiya tel, totata Abraham, xictitlani in Lázaro ichan notata. ");
INSERT INTO ncjNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ompa niquimpiya macuili nocnihuan, huan maquinnonotza ic ahmo mahualacan nis canin nitlapanotica.” ");
INSERT INTO ncjNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Huan Abraham oquiluic: “Yehhuan quipiyahque in tlen oquinihcuilui in Moisés huan in tlayolchicaucamen. ¡Yehhuan maquichihuacan cuenta!” ");
INSERT INTO ncjNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ijcon oquinanquilic in rico: “Inon melahuac, totata Abraham. Huan tla cana seya yas den inin mijcamen, quinyolcuepatiu.” ");
INSERT INTO ncjNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Huan Abraham oquiluic: “In tlahmo quinequihque quicaquisque intlahtol in Moisés huan in tlayolchicaucamen, no ahmo quineltocasque, masque seya maihsa den mijcamen.” ");
INSERT INTO ncjNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","In Jesús omoluihque in tetlamachticahuan: ―Nochipa oncan tlen ic quintlahtlacoltis in tlacamen. Huan ¡prohue inon tlacatl aquin ic tlahtlacolanaltis! ");
INSERT INTO ncjNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ocachi cuali tla quitohuetzonihque ihtech in hueyi atl ihuan in tetl ilpihtas quen quitlahtlacolanalti se de inon cocone. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ximomaluican. ’Tla se mocniu tlahtlacolana ica tehhua, xicahhua, huan tla moyolcuepas, xictlapohpolui. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Masque tlahtlacolyo ica tehhua chicomen viaje ipan in tonali, huan chicomen viaje mitziluis: “Ayacmo ijconon nicchihuas”, ticpiya tlen tictlapohpoluis. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","In tetiotlatitlaniluan oteiluihque in Totecohtzin: ―Matechmacalo ocachi totlaneltoquilis. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Oncan in Totecohtzin omoluihque: ―Tla nanquipiyanihque namotlaneltoquilis san quen ic hueyi in xinachtli den mostaza, cuali nanquiluisque inin sicómoro cohuitl: “Ximomolehua de nican huan xiyau ximotohuetzo ipan in hueyi atl”, huan inon cohuitl mechcaquis. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Tla se de namehhuan quipiya se itlaquehual ic mocuepas den mila ica in tlen tequitl oya quichihua, tlaxotla noso quinixpiya in yolcamen, tel, ¿tiquihtos: “Xipano, ximotlali, huan xitlacua”? ");
INSERT INTO ncjNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Huelis ahmo, tlahmo ocachi cuali tiquihtos: “Xinechchihchihuili in tlacuali huan xiyectlayectlali ic nitlamitlacua. Huan satepa cuali titlacuas tehhua.” ");
INSERT INTO ncjNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Tel, ¿ijcon motlasohcamatis in itlaquehual ica in tlen omotequiuti? Huelis ahmo. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ijcon tel, tla san tetlacamatisque ica in tlen mechtequiutilo in Dios, ahmo ijcon xicnehnehuilican cana mechtlasohcamatilos ica inon. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ic ohuilohuaticatca Jerusalén in Jesús, opanoloc ipan in tlalten den Samaria huan Galilea. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ic oahxihuato ipan se altepetl tlachicoyan, otenamiquitoque mahtlactli cocoxcamen ica in pahpalanilistli. Huan omocauque huehca de Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Huan otzahtzihque: ―¡Jesús, Tlamachtiyani, xitlocoya ica tehhuan! ");
INSERT INTO ncjNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ihcuac Jesús omotaque, omoluihque: ―Xiyacan, xicmonextilican in tiopixcamen. Huan ic oyahticatcahque, opahtihque. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Oncan se de yehhuan omotac yopahtic, huan omocuep temahuestilihtihuitz in Dios ica chicahuac itlahtol. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Omotlancuaquetz teixpa in Jesús, huan hasta otexotenamic, ic omotlasohcamat. Huan inin tlacatl yehhua den Samaria. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Oncan Jesús omihto: ―Tel, ¿ahmo opahtihque in mahtlactli? Tel, ¿canin caten in oc chicnahue? ");
INSERT INTO ncjNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tel, ¿yeh in sentlapalchani isel omocuep temahuestiliya in Dios? ");
INSERT INTO ncjNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Oncan omoluic in tlacatl: ―Ximoquetza huan xiyau tleca yotipahtic huan quen oticneltocac. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","In fariseos otetlahtlanihque in Jesús queman pehualos tlatequiutilo tlalticpac in Dios. Huan Yehhuatzin omonanquilihque: ―Ihcuac pehualo tlatequiutilos tlalticpac in Dios, ahmo oncan quen tlen cuali motas. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ahmo quihtosque: “Nicanca”, nos “Nepa ompaca”; tleca in tetlatequiutilistzin Dios yica ipan namehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Oncan omoluihque in tetlamachticahuan: ―Ahsiquiu in tonalten queman namehhuan nanquinequisque nannechitasque nehhuatl aquin Nitetiachicau ica nochin tlacatl masque ipan se tonali, huan ahhuel nannechitasque. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Huan mechiluisque: “Nicanca”, noso “Nepa ompaca.” Huan ahmo xiyacan, niyan ahmo xiquincuitlapanuican. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tleca ijcon yes in tonali ihcuac nihualas nehhuatl aquin Nitetiachicau ica nochin tlacatl. Yes quen ihcuac petlani in tlapetlantli nisic, nepic, ipan in neluicactli. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Huan achto nicpiya tlen nitlapanos tequin, huan nechixtlasasque in tlacamen den inin tonalten. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ijcon quen opanoc in tonalten queman onemiyaya in Noé, noyojqui ijcon panos ihcuac nihualas nehhua aquin Nitetiachicau ica nochin tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Otlacuayahque huan otlayitinemiyayahque, huan omosihuautiyayahque huan otlanamictiyayahque hasta ihcuac in Noé ocalac ipan in arca. Huan ohuala in tetzahuitl huan otlanque miquihque. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Noyojqui ijcon opanoc ipan in tonalten den Lot. Otlacuayahque huan otlayitinemiyayahque, huan otlacohuayayahque huan otlanemacayayahque, huan otocayayahque huan oquinchihchihuayayahque in calten. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Huan ihcuac in Lot oquis ipan in altepetl Sodoma, oquiyau ica tletl huan tetl azufre tlatiutoc huan otlan miquihque. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ijcon yes in tonali queman nehhuatl aquin Nitetiachicau ica nochin tlacatl ihcuac nimohualnextis. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Ipan inon tonali, tla aquin yes itzoncuac in cali huan quipiyas itlahtlen tlahtec, ahmo matemo tlaquixtis. Huan tla aquin yes ic mila, ahmo mamocuepa ichan. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Xiquilnamiquican ica in tlen opanoc ica isihuau in Lot. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mopolos in aquin ahmo quinequi miquis nopampa, huan maquisas in aquin motemacas ica inemilis nopampa. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Namechiluiya quen inon tlayohua yesque inehuan ipan se tlapechtli. Huan in seya quihuicasque in ángeles huan in seya quicautehuasque. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Inehuan sihuamen testiyesque san secnin huan seya quihuicasque in ángeles huan seya quicautehuasque. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ome tlacamen yesque ic mila. In seya quihuicasque in ángeles huan in oc seya quicautehuasque. ");
INSERT INTO ncjNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Huan ic oquicajque inon, otetlahtlanihque: ―Tel, ¿canin panos inon, Totecohtzin? Huan Yehhuatzin omonanquilihque: ―Canin yes in itlacayo mijqui, ompa mosentlalisque in tzopilomen. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","In Jesús omotlalilihque inin tlalnamictilistli ic quinmachtisque moyolmachtisque nochipa huan ahmo mamoxihxicocan. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Oquiniluiloc: ―Ocatca se tlixcomacani ipan se altepetl. Ahmo otemahuestiliyaya in Dios huan niyan aquin oquinmahuestiliyaya. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ipan inon altepetl ocatca se viuda huan mostli oyaya quiita in tlixcomacani ic maquitlixcomaquili ica in itecocolihcau. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Inon tlixcomacani ahyic oquichihuilic cuenta huan satepa oquinehnehuilic: “Masque ahmo nitemahuestiliya in Dios huan niyan aquin, ");
INSERT INTO ncjNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","huan quen inin viuda mostli nechmohsihuihtica, niyau nicpalehui. Huan ijcon ayacmo hualahtiyes huan ayacmo manechmohsihuihtiye.” ");
INSERT INTO ncjNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Huan in Totecohtzin omihto: ―Inin tlen oquihto se tlixcomacani ahmo cuali. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Tel, ¿huelis in Dios ahmo quimpalehuisque in tetlapehpeniluan aquin tetlatlautiyahque Yehhuatzin ijcon mostli? Tel, ¿huehcahuihuas ic mopalehuisque? ");
INSERT INTO ncjNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Namechiluiya quimpalehuilos ihsiu. Huan ihcuac nihualas nehhua aquin Nitetiachicau ica nochin tlacatl, tel, ¿oc nicahsiquiu in aquin quineltoca nican tlalticpac? ");
INSERT INTO ncjNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","In Jesús oquimpohuili oc se tlalnamictilistli ica sequin aquin oquinehnehuiliyayahque cualten huan oquinnexicaluiyayahque in oc sequin. Omihto in Jesús: ");
INSERT INTO ncjNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Ome tlacamen oyahque moyolmachtiyahque in tiopan. In seya fariseo huan in seya rendero. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","In fariseo otelicahtoya ic moyolmachtiya huan ijcon oquihto: “Oh Dios, nitetlasohcamati tleca nehhuatl ahmo quen in oc sequin tlacamen, tlachtejcamen, huan ahmo cualten, huan sihuaahuiltiyahque. Huan niyan ahmo noquisca quen inin rendero. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nehhuatl nimosahua oupa in semana huan nochin tlen nictlani, nitetlocolis se tanto ipan mahtlactli.” ");
INSERT INTO ncjNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Huan inon rendero omocau huehca huan ahmo omixcohyanui niyan ic mixahcocuis neluicac. San omoyoluitecticatca huan quihtohua: “¡O Dios, manechtlapohpoluilo tleca nitlahtlacolyo!” ");
INSERT INTO ncjNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Namechiluiya quen inin rendero ihcuac omocuep ichan yitlamelajcan ica in Dios, huan in fariseo ahmo. Tleca in aquin mohueyiliya quixtohuetzosque, huan in aquin ahmo mohueyiliya, yehhua mochihuas hueyi. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Noyojqui otehualiquiliyayahque in cocone in Jesús ic mamomachilican ica teman. Huan ihcuac oquitaque in tetlamachticahuan, opeuque quintlacahualtiyahque in aquin oquinualiquiliyayahque. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Huan Jesús omonotzque huan omoluihque: ―Xiquincahuacan in cocone manechualiquilican huan ahmo xiquintlacahualtican, tleca in tetlatequiutilistzin Dios inuaxca yehhuan quen inohque cocone. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ic nele namechiluiya, in aquin ahmo quiseliya in tetlatequiutilistzin Dios ipan iyolo quen se conetl quiseliya, ahyic calaquis ompa. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Se de inon tlayecancamen otetlahtlani in Jesús: ―Cuali tlamachtiyani, tel, ¿tlen nicchihuas ic nicahsis in nemilistli nochipa? ");
INSERT INTO ncjNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","In Jesús omoluic: ―Tel, ¿tleca tiquihtohua molui nicuali? Ahmo oncan ocachi quen seya aquin nele cuali. San Yehhuatzin in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tehhuatl tiquixmati in tlanahuatilten: “Ahmo xisihuaahuilti; ahmo xitemicti; ahmo xiichtequi; ahmo xiistlacati ica niyan aquin; xicmahuestili motata huan monana.” ");
INSERT INTO ncjNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Inon tlacatl oteiluic: ―Nochin inin nitlacamautoc de ihcuac niquitzinin. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ic omocac in Jesús, omoluic: ―Oc mitzpolohua oc se tlahtoli. Xicnemaca nochin tlen ticpiya huan xiquinmaca in prohues. Huan ijcon ticpiyas motlatlan neluicac, huan niman xihuala huan xinechcuitlapanui. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Huan ihcuac inon tlacatl oquicac inon, molui otlocox tleca tequin rico ocatca. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Quen omotac in Jesús quen otlocox, omoluic: ―Molui tequiyo in ricos calaquisque ipan tetlatequiutilistzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ahhuel panos in camello ipan itlacoyoc in acoxa. Huan tla cuali yesquiyani, molui tequiyo. Huan ocachi tequiyo in rico calaquis ipan tetlatequiutilistzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ic inin, in aquin oquicajque oquihtohque: ―Tel, ¿aquin cuali maquisas? ");
INSERT INTO ncjNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","In Jesús omoluihque: ―In tlen in tlacamen ahhuel quichihuasque, in Dios cuali mochihuas. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","In Pedro oteiluic: ―Notecohtzin, tehhuan ticautoque in tlen ticpiyahque ic titecuitlapanuisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Oncan Yehhuatzin oquinnanquililoc: ―Ic nele namechiluiya; in aquin quicahuas ichan, noso itata huan inana, noso icnihuan, noso isihuau, noso ipiluan, tepampa in tetlatequiutilistzin Dios, ");
INSERT INTO ncjNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","quiselis ocachi ipan inin tlalticpactli, huan ipan in tlalticpactli tlen hualas quiselis in nemilistli nochipa. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","In Jesús omonotzque secnin in mahtlactli huan ome tetlamachticahuan huan omoluihque: ―Axan tiyohue Jerusalén canin tzonquisas ica tlen oquihcuilohque in tlayolchicaucamen ica nehhuatl aquin Nitetiachicau ica nochin tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tleca nechtemactisque inmajco in tequihuahmen romanohteco aquin nechahuiltisque, huan nechpactecasque huan nechixchihchahuisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Huan nechuihhuitequisque, huan satepa nechmictisque. Huan ipan yiyi tonali niihsas den mijcamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Huan yehhuan ahmo tlen oquinnehnehuilihque ica inin, niyan oquimatque ica tlen oquinnonotzaloc, tleca inon tlahtoli ahhuel oquinehnehuilihque. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ihcuac in Jesús oahxihuataya ipan in altepetl Jericó, se ixpatzac oyehuatoya itentla in ohtli ic quitlahtlani in limosna. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Quen oquicacticatca quen opanoticatcahque miyac tlacamen, in ixpatzac otlahtlan tlen panotica. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Oquiluihque quen opanolotaya in Jesús den altepetl Nazaret. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Oncan otzahtzic: ―¡Jesús, ixuiu in David, xitlocoya ica nehhua! ");
INSERT INTO ncjNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","In aquin otlicanayayahque oquitlacahualtihque mamocahua. Huan yehhua ocachi otzahtzic: ―¡Ixuiu in David, xitlocoya ica nehhua! ");
INSERT INTO ncjNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Oncan in Jesús omoquetzaloc huan omoluihque matehuiquilican. Ihcuac yoteahxiltilihtayahque tenahuac, omotlahtlani: ");
INSERT INTO ncjNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―Tel, ¿tlen ticnequi manimitzchihuili? In ixpatzac otenanquilic: ―Notecotzin, nicnequi nicselis notlachiyalis, tla cuali nitlachiyas. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","In Jesús omoluic: ―¡Xitlachiya! Huan yotipahtic tleca oticneltocac. ");
INSERT INTO ncjNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Niman inon hora in ixpatzac cuali otlachix huan otecuitlapanui in Jesús temahuestilihtiu in Dios. Huan nochin tlacamen aquin oquitaque noyojqui otemahuestilihque in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Oncan in Jesús oahxihuac Jericó huan opanoloc ipan in altepetl. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Huan ompa ocatca se rico itoca Zaqueo, yehhuatl in tlayecanqui den renderos. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","In Zaqueo oquinequiyaya teixmatis in Jesús, huan ahhuel oteitac tleca ahmo coutic huan ocatcahque miyac tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Oncan otzecuin tlicantiu, huan ic teitas otlehcoc ihtech se cohuitl inahuac canic panolos in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ihcuac opanolohtaya ompa in Jesús, omotac huan omoluic: ―Zaqueo, xitemo ihsiu, tleca axan nimocahuas mochan. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Oncan Zaqueo otemoc ihsiu huan ica paquilistli oteseli in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ic oquitaque inin, opeuque teca tlahtohuahque in Jesús, tleca ohuilohuac ichan in tlahtlacolyo. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Oncan Zaqueo omoquetz huan oteiluic in Totecohtzin: ―Mamocaqui, Notecohtzin. Niyau niquinmaca in prohues tlahcopa in tlen nicpiya. Huan in tla onicuili in aquin onicahcayau, nicuepilis naupa ocachi. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","In Jesús omoluic: ―Axan maquistoque inin mochanihcahuan, quen inin tlacatl noyojqui ixuiu in Abraham. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tleca nehhua aquin Nitetiachicau ica nochin tlacatl onihuala niquintemohua ic niquinmaquixtis in aquin poliutoque. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ic otecacticatcahque in tlacamen in Jesús, omoluihque se tlalnamictilistli, tleca ayacmo huehca den Jerusalén, huan yehhuan oquinehnehuiliyayahque quenin in tetlatequiutilistzin Dios hualahsisquiyani saniman. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Oncan omoluihque: ―Ocatca se tlacatl cuali in ichanihcahuan, huan oya huehca ipan oc sequin altepemen ic quitocahhuisque hueyixtoc. Huan satepa mocuepas. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Achto ic quisas, oquinnotz mahtlactli itlaquehualuan, huan oquinmacti cada seya in tomin, huan oquiniluic: “Xictequitiltican hasta nihualas.” ");
INSERT INTO ncjNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Huan in tlacamen den ialtepeu oquihtohque: “Ahmo ticnequihque inin tlacatl maye hueyixtos ic techtequiutis.” ");
INSERT INTO ncjNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Masque oquitocahhuihque hueyixtoc huan omocuep ipan ialtepeu. Ihcuac oahsito, oquinnotz in itlaquehualuan aquin oquinmacac in tomin, ic quimatis quesqui yoquitlan cada seya. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","In achto omotemacti huan oquiiluic: “Noteco, ica onictlan mahtlactli tanto ica in motomin.” ");
INSERT INTO ncjNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","In hueyixtoc oquinanquilic: “Molui cuali; tehhuatl se cuali tlaquehuali huan quen titlamelajcan chihton, nimitzcahuilis xiquintequiuti mahtlactli altepemen.” ");
INSERT INTO ncjNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Omotemacti in oc seya huan oquiluic: “Noteco, yonictlan macuili tanto ica in motomin.” ");
INSERT INTO ncjNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Noyojqui inin oquinanquilic: “Tehhuatl tiquintequiutis macuili altepemen.” ");
INSERT INTO ncjNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Oncan omotemacti in oc seya huan oquiluic: “Noteco, nicanca in motomin. Oniqueu ica in payo. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Tleca onimomouti ica tehhua, quen tequin tiyolchicahuac huan ticsentlalis in tlen ahmo tictlalihtoc.” ");
INSERT INTO ncjNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Oncan in hueyixtoc oquiluic: “Tlaquehuali ahmo cuali, ica motlahtol nimitzixcomacas. Oticmat niyolchicahuac huan nicsentlalis in tlen ahmo nictocatoc. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Tel, ¿tleca ahmo otitetlaneuti in tomin huan nicselini in itlatlan ic onimocuep nochan?” ");
INSERT INTO ncjNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Huan oquiniluic in aquin ompa ocatcahque: “Xicuilican in tomin huan xicmacacan in aquin quipiya in mahtlactli tanto.” ");
INSERT INTO ncjNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Yehhuan oquiluihque: “Noteco, yehhuatl yiquipiya in mahtlactli tanto.” ");
INSERT INTO ncjNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Huan in hueyixtoc oquinnanquilic: “Namechiluiya quen in aquin quipiya, quimacasque ocachi, huan in aquin ahmo quipiya, quicuilisque hasta in chihton tlen quipiya. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Huan noyojqui notecocolihcahuan aquin ahmo oquinejque nechpiyasque quen hueyixtoc, xiquinualicacan nican huan xiquinmictican noixpa.” ");
INSERT INTO ncjNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Satepa ic omihto inin, in Jesús oc sepa omoan in ohtli hasta Jerusalén. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ihcuac yoahxihuataya ipan in altepemen Betfagé huan Betania, inahuac in tepetl itoca Olivos, omotequiutihque ome tetlamachticahuan. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Huan omoluihque: ―Xiyacan ipan in altepetontli tlachicoyan huan ic nanahsitihue, nancahsisque se burro ilpihtoc, quen niyan aquin ipan motlalihtoc. Xictohtomacan huan xicualicacan. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Huan tla aquin mechtlahtlaniya tleca nanquitohtoma, xiquiluican in Totecohtzin monequi. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","In tetlamachticahuan oyahque huan ocahsitohque ijcon quen omononotzque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Huan ihcuac oquitohtonticatcahque in burro, in itecohuan oquiniluihque: ―¿Tleca nanquitohtoma in burro? ");
INSERT INTO ncjNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Yehhuan oquinnanquilihque: ―Tleca in Totecohtzin monequi. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","In Jesús otehualiquilihque in burro, huan oquipehpechtihque huan ipan omotlaliloc in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Huan quen ohuilohuaticatca, in tlacamen oquisoutayahque intlaquen ipan in ohtli. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ic oahsitohque ipan in tlatemoli den Olivos tepetl, nochin tlaneltocanimen opeuque tzahtzihque ica paquilistli huan temahuestiliyahque in Dios ica nochin tlachiuten tlen oquitaque. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Oquihtohque: ―¡Mahuesticatzintli in hueyixtoc aquin huitz ica Itocahtzin Totecohtzin! Yolpaquilistli tehuan Yehhuatzin aquin ilohuac neluicac. ¡Xitemahuestilican Yehhuatzin! ");
INSERT INTO ncjNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Oncan sequin fariseos ocatcahque inepanco inon tlacamen huan oteiluihque: ―Tlamachtiyani, xiquintlacahualti in aquin mitzcuitlapanuihtinemihque. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Huan Jesús oquinnanquililoc: ―Namechiluiya, in tla inin mocahuasque, in temen tzahtzisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ihcuac ahxihuatiu, ic motas in altepetl Jerusalén, in Jesús ochocohuac ica yehhua. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Huan omihto: ―In tla nanquinehnehuilinihque motonal den temaquixtilistli. Huan axan inon tlatiutoc huan ahhuel nanquitasque. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Huan mechualahsis sequin tonali ahmo cuali, huan in namotecocolihcahuan mechyehualosque huan mechixnamiquisque ic nohuiyan. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Huan mechtlalmotlasque huan mechtlamisque, huan ahmo mechcahuilisque niyan se tetl tecpantos. Tleca ahmo onantechiuque cuenta ihcuac in Dios ohualuilohuaya mechitalo ic mechpalehuilos. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Oncan in Jesús ocalacohuac ipan in tiopantli huan oquintotocaloc caltenco in tlanemacanimen huan in tlacoucamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Huan omoluihque: ―Ipan in Tlahcuiloltzin quihtohua: “In nochan yehhua in cali den tlayolmachtilistli”; huan namehhuan nanquichiutoque cali den ichtejcamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Mostli in Jesús otlamachtilohuaya ipan in tiopantli, huan in tlayecancamen den tiopixcamen, huan in tlamachtiyanimen den tlanahuatilten, huan noyojqui in tlayecancamen den altepetl oquitemoticatcahque quen cuali temictisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Huan ahmo ocahsique quen quichihuasque tleca nochin tlacatl otechiuticatcahque cuenta. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Se tonali in Jesús oilohuaya ipan in tiopantli otlamachtilohtoya ica in tlacamen huan mocaquiltiyahque in tlahtoli den temaquixtilistli. Oahsitohque in tlayecancamen den tiopixcamen huan in tlamachtiyanimen den tlanahuatili san secnin ihuan in tetecten. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Huan oteiluihque: ―Xitechilui ica tlen tequihuahyotl ticchiutica inin. Tel, ¿aquin omitzmacac inin tequihuahyotl? ");
INSERT INTO ncjNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Oncan in Jesús omoluihque: ―Noyojqui niyau namechtlahtlani ica se tlahtoli, huan nannechnanquilisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Tel, ¿aquin ocualtitlan in Juan matlacuatequi; in Dios, noso in tlacamen? ");
INSERT INTO ncjNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Huan opeuque motlahtlaniyahque ic yehhuan: ―Tel, ¿tlen tiquihtosque? Tla tiquihtosque Dios omohualtitlan, technanquilis: “Tel, ¿tleca ahmo onanquineltocaque?” ");
INSERT INTO ncjNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Huan tla tiquihtosque ocualtitlanque in tlacamen, nochin in tlacamen techtemacasque, tleca quiyecmatihque in Juan otlahtohuaya ica in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Huan otenanquilihque in Jesús quen ahmo oquimatiyayahque aquin oquicualtitlan in Juan matlacuatequi. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Oncan in Jesús omoluihque: ―Tel, neh no ahmo namechiluis ica tlen tequihuahyotl nicchihua inin. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Niman in Jesús opehualoc quinnotzalo in tlacamen huan oquintlalililoc inin tlalnamictilistli: ―Ocatca se tlacatl oquitocac in uvasmili, huan satepa oquintemo in amedieros huan yehhuatl oya de ompa huan ohuehcahuito. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ihcuac oahsico in tonali ica inon tlamiloli, ocualtitlan se itlaquehual maquintlahtlanili in tlen yehhuatl ihuaxca, huan yehhuan san oquihuihhuitejque huan oquititlanque iyoca. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Oncan in iteco inon tlamiloli ocualtitlan oc se itlaquehual, huan ijcon noyojqui oquihuihhuitejque huan ahmo tlen oquimacaque. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Huan iteco inon tlamiloli oc sepa ocualtitlan oc seya, huan inon tequitcamen noyojqui oquicocohque huan oquitohuetzohque tlatentli den tlamiloli. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Huan ic inon iteco inon tlamiloli oquihto: “Tel, ¿tlen nicchihuas? Niyau nictitlani noconeu tlasohtli huan quitasque cana quimahuestilisque.” ");
INSERT INTO ncjNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Huan ihcuac inon tequitcamen oquitaque, omoluihque ic yehhuan: “Yehhuatl inin aquin quiselis in itetlocolil. Tiyohue ticmicti huan ijcon tehhuan timohuaxcatisque.” ");
INSERT INTO ncjNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Oncan oquiquixtihque den tlamiloli huan oquimictihque. Oncan in Jesús otlahtlanihuac: ―Tel, ¿tlen quichihuas ica yehhuan inon iteco in tlamiloli? ");
INSERT INTO ncjNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Hualas huan quinmictis inon tlaquehualten huan quimacas in tlamiloli in oc sequinten. Ihcuac oquicajque inon, oquihtohque: ―¡Ahmo maquimocahuili in Dios! ");
INSERT INTO ncjNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Huan Jesús oquinitaloc huan oquiniluiloc: ―Tel, ¿tlen quihtosnequi in tlen ca ipan Itlahcuiloltzin? Quihtohua ijquin: In tetl tlen oquixtohuetzohque in tequitcamen, axan yeh in tlen ocachi quinequisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","In aquin huetzis ipan inon tetl cocohtonis. Huan tla in tetl huetzis ipan seya, quipechitiu. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","In tlayecancamen den tiopixcamen huan in tlamachtiyanimen den tlanahuatilten oquinequiyayahque tequitzquisque saniman in Jesús, tleca oquinehnehuilihque ica yehhuan omoluihque inon tlalnamictilistli. Huan oquinmoucaitaque inon tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Oncan oquintitlanque tlapihpiyanimen maixnesican tlamelajcanten. Huan ic teichtacahsisque ica tlen mihtos huan ijconon cuali tetemactisque imajco in hueyixtoc romanohteco. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ic inin otetlahtlanihque: ―Tlamachtiyani, ticmatihque mihtohua huan monextiliyahque in tlen melahuac. Huan ahmo mixcomaca ica in tlacamen, tlahmo monextiliyahque ica in tlen melahuac teohtli in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Xitechilui tel, ¿cuali tictlaxtlahuilisque in renta in hueyixtoc romanohteco, noso ahmo? ");
INSERT INTO ncjNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Huan Jesús omomat quenin ica inon ahmo cuali intlanehnehuilis, huan omoluihque: ―Tel, ¿tleca nechichtacahuiyahque? ");
INSERT INTO ncjNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Xinechnextilican se tomin. Tel, ¿de aquin ixayac huan itoca quipiyas? Huan otenanquilihque: ―Den hueyixtoc romanohteco. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Oncan omoluihque: ―Tel, xicmacacan in hueyixtoc in tlen iyaxca huan xitemacacan in Dios in tlen teyaxca. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Huan ahhuel oteichtacaquitzquihque ica tlen omihto inixpa in tlacamen. Tlahmo oc noncua, oquimatque ica tlen omonanquilihque huan omocauque. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Huan satepa sequin saduceos ohualahque teitaque in Jesús. Inon saduceos quihtohuahque ahmo oncan in ihxohualistli den mijcamen. Ijcon oteiluihque in Jesús: ");
INSERT INTO ncjNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Tlamachtiyani, in Moisés otechihcuiluihtehuac tla se tlacatl miquis huan quicautehuas isihuau huan ahmo oquipix niyan se iconeu, in icniu quipiya ihuan motlalis inon viuda huan quipiyas ipiluan poutos ica in icniu mijqui. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Huan ijcon opanoc quen ocatcahque chicome icnimen. In achto omosihuauti huan omic, huan niyan se iconeu oquicau. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ipan inon ome icnimen ihuan omotlali inon viuda huan noyojqui omic huan ahmo oquicautehuac iconeu. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Huan ipan inon yiyi icnimen noyojqui ihuan omotlali inon viuda. Ijcon opanoc ica nochten inon chicomenten. Otlanque miquihque huan ahmo oquicautejque niyan se inconeu. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Huan satepa noyojqui omic inon viuda. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Huan ihcuac ihsasque den mijcamen tel, ¿aquin isihuau yes? Tleca nochten in chicomenten omotlalihque ihuan inon viuda. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Oncan Jesús oquinnanquililoc: ―Ipan inin tlalticpactli in tlacamen huan in sihuamen mosetiliyahque. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Huan in aquin ahsitihue ipan in oc se tlalticpactli quen quinihxitilos den mijcamen, yehhuan ayacmo mosetilisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Tleca ayacuel miquisque. Tleca mocahuasque quen ángeles, huan nele tepiluan in Dios quen oquinihxitiloc den mijcamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ipan in Itlahcuiloltzin ticahsihque tlen omoluic in Moisés iixpa inon xihuitl tlen oxotlac. Yehhua techmatiltiya quen in mijcamen ihsasque. Huan ompa quihtohua quen in Totecohtzin, yehhua in iDios den Abraham huan Isaac huan Jacob. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Masque yomijque, oc yolticaten teixpa in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Oncan sequin tlamachtiyanimen den tlanahuatili oquiluihque: ―Molui cuali tlen omihto, tlamachtiyani. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Huan ijcon ayacmo oixcohyeuque ic ocachi tetlahtlanisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","In Jesús oquintlahtlaniloc: ―Tel, ¿quen nanquihtohuahque in Cristo iconeu in David? ");
INSERT INTO ncjNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Yehhua in David quihtohua ipan iamau in Salmos: In Tohueyitahtzin omihto ica in Notecohtzin: “Ximotlali ic noyejcan, ");
INSERT INTO ncjNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hasta niquimpinautis in motecocolihcahuan.” ");
INSERT INTO ncjNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tel, ¿quen cuali yes in Cristo iconeu in David? Tleca noyojqui tetocahhuiya Notecohtzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nochin tlacatl oquicacticatca ihcuac in Jesús omoluihque in tetlamachticahuan: ");
INSERT INTO ncjNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Ximomaluican ica in tlamachtiyanimen den itlanahuatil Moisés, tleca san ome inxayac. Quimpactiya nemisque ica intlaquen den tlamachtiyani huan quinequihque maquinmahuestilican nohuiyan. Huan quinequihque yesque canin ocachi cualtzin ipan in tiopanten huan in canin yes ocachi mahuestic ica in iluitl. ");
INSERT INTO ncjNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Noyojqui quincuiliyahque inchan in viudas, huan ic manesi quen cualten tlaca, quichihuahque huehcau yolmachtilistli. Inohque in aquin ocachi quintlapanoltisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ipan in tiopantli in Jesús omotaque in ricos quen quitlaliyahque in tomin ihtech in caja den tetlocolili. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Noyojqui omotac se viuda prohue no oquitlali ome in tomin de mamacuili centavo den cobre. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Huan omihto in Jesús: ―Ic nele namechiluiya, inin viuda prohue ocachi oquitlali quen in oc sequinten. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nochin yehhuan otemacayayahque in tlen quimocahuiya, huan yehhua ica in iprohuehyo oquitemacac nochin tlen ic panotiyeni. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Sequin omonohnotzticatcahque ica in tiopantli huan quen cualtzin omotayaya ica in tetl huan oc sequin in tetlocolil. Oncan Jesús omihto: ");
INSERT INTO ncjNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Ahsiquiu in tonali queman quixitinisque nochin inin tlen namehhuan nanquitzticaten, huan ahmo mocahuas niyan se tetl nepaniutos. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Oncan otetlahtlanihque: ―Tlamachtiyani, tel, ¿queman panos inin? ¿Noso tlen tlachiutli mochihuas ica tlen yau panohua? ");
INSERT INTO ncjNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús omihto: ―Ximomaluican huan ahmo mamechcahcayahuacan. Tleca ahsiquihue miyacten ica notoca, huan mechiluisque: “Nehhuatl in Cristo”; huan “Axan in itonal.” Huan ahmo xiquincuitlapanuican. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ahmo ximomoutican ihcuac nanquicaquisque tlahtosque ica netehuilistli huan tlixnamiquilistli, tleca inin achto mochihuas huan ayamo hualahsi itlamiyan in tonali. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Oncan ijcon omoluihticatcahque: ―Se altepetl quixnamiquis in oc seya. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Huan tequin tlaluehueyocas, huan yes apistli huan san tlen cocolisten san canic. Huan ipan neluicactli motas san tlen temohmouti huan huehhueyi tlachiuten. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Huan achto de inin namehhuan mechquitzquisque huan mechmohsihuisque huan mechuicasque ic mechixcomacasque ipan in tiopanten. Huan nopampa mechtzacuasque ipan in telpiloyan huan mechuicasque inixpa in hueyixtoque tlixcomacanimen. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Huan inin mechpalehuis ic nantlahtosque nopampa. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ximotemacacan tel, huan ahmo xicchiconehnehuilican achto ica tlen nanmopalehuisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tleca nehhuatl namechmacas tlahtoli huan tlanehnehuilistli, huan niyan aquin namotecocolihcau quixicos ic mechixiluis. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Huan namehhuan mechichtacaquitzquisque ica namotatahhuan huan namocnihuan huan namochanihcahuan huan namotenonotzcahuan. Mechmictisque sequin de namehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Huan nochin tlacamen mechcocolisque nopampa. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Huan ahmo polihuis niyan se de namehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","In tla nanmoyequetzasque ica namotlaneltoquilis, nanquipiyasque in nemilistli nochipa. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Ihcuac nanquitasque quiyehualohtosque in soldados in altepetl Jerusalén, xicmatican quen ihsiu moxitinis. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Huan in aquin yesque Judea macholocan ipan in tepetl, huan in aquin yesque ipan in altepetl Jerusalén quipiya tlen quisasque de ompa. Huan in aquin yesque ic mila ahmo machicoquisacan ipan in altepetl. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tleca inon tonalten yes in tlapanolistli quen matzonquisa nochin in tlen quihtohua in Itlahcuiloltzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Yes tetlocolti ica in sihuamen aquin piluahque noso aquin tlachichihtihtiyesque. Tleca onyes miyac tetlocolti ipan in tlali huan tlapanolistli chicahuac ica in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Huan sequin miquisque ipan in motehuilistli huan oc sequin quinuicasque tlatemactilten nochin altepemen. Huan in tlacamen den Jerusalén yesque temajco in sentlapalchanimen hasta ic tlamis in tonalten quen motlalihtoc mochihuas. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Ica in tonaltzintli huan in metztli huan in sitlalten yes tlachiuten ica tlen quichihuasque cuenta. Huan in tlalticpac tlacamen ixpoliutosque huan momoutihtosque ic caquistitiyes chicahuac in mar. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Huan in tlacamen sotlahuisque ica moucayotl ic quinehnehuilisque tlen yau panohua ipan in tlalticpactli. Huan hasta in chicahualisten den neluicac huehueyocasque. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Oncan nechitasque nehhuatl aquin Nitetiachicau ica nochin tlacatl ic nihualas ipan se mextli ica chicahualistli huan hueyi tehueyilistzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ihcuac pehua mochihuas inin tlachiuten, ximoyolchicahuacan huan xiahcotlachiyacan, tleca molui ihsiu mechmaquixtisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Noyojqui omotlalilihque in tlahtoli tlen ic quichihuasque cuenta: ―Xiquitacan in higoscohuitl noso san tlen oc se cohuitl. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ihcuac nanquitahque yipehua seliya, yinanquimatihque quen yiahsitihuitz in tonalten den tlatotonilotl. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","No ijcon, ihcuac nanquitasque panos inin, xicmatican quen in tetlatequiutilistzin Dios ayacmo huehca ca. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Ic nele namechiluiya, nochin inin panos achto quen miquisque in tlacamen de inon tonalten. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","In neluicactli huan in tlalticpactli polihuisque, huan notlahtol ahmo polihuis hasta tzonquisas. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Ximomaluican, ahmo ximonencahuacan ic tlen mechpactiya ic nanuintihtiyesque huan ic nanquimaluisque inin namonemilis. Huan ijcon inon tonali ahmo nanahcopatlanisque quen in trampa motzacua, ");
INSERT INTO ncjNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","tleca ijcon panos in tonali tlen huitz ica nochin tlalticpac tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ximoyectlalican tel, huan ximoyolmachtican nochipa huan ijcon cuali nanmaquisasque ica nochin tlen panos. Huan ijcon cuali nanmotemactisque noixpa nehhuatl aquin Nitetiachicau ica nochin tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","In Jesús otlamachtilohuaya mostli ipan in tiopantli huan ipan tlayohua huilohua mocahualo ipan in tepetl itoca Olivos. ");
INSERT INTO ncjNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nochin tlacatl oahsiyayahque sancuel ipan in tiopantli ic tecaquisque. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yohualahsitaya in pascuahiluitl queman in judeahtecos quicuahque in pantzin ahmo semautoc. Quitosnequi yeh in tonali den tlacalpanolistli den ángel den miquilistli. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","In tlayecancamen den tiopixcamen huan in tlamachtiyanimen den tlanahuatilten quitemohuahque quen temictisque in Jesús, huan oquinmojcaitayayahque in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Oncan in ahmo cuali tlacatl oquiyolquitzqui in Judas, aquin noyojqui oquitocahhuiyayahque Iscariote. Inon se den mahtlactli huan ome tetlamachticahuan in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Huan yehhua oya quinita in tlayecancamen den tiopixcamen, huan in tlachixcamen den tiopantli, huan oquiniluic quen quinmactis in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yehhuan opajque huan oquicocoltihque in tomin in Judas. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yehhua oquiseli huan oquitemo quenin quinmactis in Jesús ihcuac ahmo mayecan in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yoahsico in tonali den pascuahiluitl queman quicuahque in pantzin ahmo semauqui ihuan in colelo tlen quimictiyahque ic quichihuahque cuenta den tlacalpanolistli den ángel den miquilistli. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Oncan Jesús oquintitlaniloc in Pedro huan Juan, huan oquiniluiloc: ―Xiyacan xicyectlalican in tlacuali den pascuahiluitl. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Yehhuan otetlahtlanihque: ―Tel, ¿canin monequi maticchihchihuacan? ");
INSERT INTO ncjNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","In Jesús oquinnanquililoc: ―Ihcuac nanahsitisque ipan in altepetl, mechahsis se tlacatl quihuicatas se tzotzocoli in atl. Huan inon xicuitlapanuican hasta canin ahsitiu. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Huan xiquiluican in iteco in cali: “In Tlamachtiyani mitzualiluiya: Tel, ¿catle yeh in cuarto canin cuali ticuasque in tlacuali den pascuahiluitl ihuan notemachticahuan?” ");
INSERT INTO ncjNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Oncan mechnextilis se hueyi cuarto tlayectlalili itzoncuac inon cali huan ompa xicyectlalican inon tlacuali. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Yehhuan oyahque huan ocahsique nochin in quen Jesús oquiniluiloc. Huan oquichihchiuque in iluitlacuali. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ihcuac oahsic in horas, in Jesús huan in tetiotlatitlaniluan omotlaliloc inahuac in mesa. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Oncan Jesús oquiniluiloc: ―Molui onicnec tictlaolichtisque inin iluitlacuali den pascua achto ic nimiquis. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Tleca namechiluiya ahmo oc sepa nicchihuas hasta ihcuac matzonquisa ipan tetlatequiutilistzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Oncan omoan inon vaso den uvahtlayili huan omotlasohcamatiloc huan omihto: ―Xicanacan inin huan ximoxehxeluican. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tleca namechiluiya ahmo oc sepa niconis de inin uvahtlayili hasta ic hualahsis in tetlatequiutilistzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Oncan omoan in pantzin huan omotlasohcamatiloc huan omoxehxeluihque huan omoluihque: ―Inin yeh notlacayo tlen namechmactiliyahque. Ijcon xictlaolichtican ica nehhua. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Noyojqui ijcon omochiu ica in vaso satepa den iluitlacuali. Huan omihto: ―Inin vaso den uvahtlayili yehhuatl in noyes tlen mochayahua ica namehhuan, huan yehhua in tlen ic moteixmatiltiya melahuac ica inin yancuic mononotzalistli. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Huan axan nica tohuan tlacua in aquin nechtemactis. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Huan nehhua aquin Nitetiachicau ica nochin tlacatl nimiquis quen ca tlahcuiloli. ¡Huan tetlocolti in aquin nechtemactiya! ");
INSERT INTO ncjNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Oncan opeuque motlahtlaniyahque ic yehhuan aquin inon yes in tlatemactiyani. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Huan niman opeuque motlatlaxiliyahque ica yehhuan aquin ocachi hueyixtoc mochihuas. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Huan Jesús oquiniluiloc: ―In hueyixtoque den tlalticpactli tlatequiutiyahque quen tetatahmen huan quinmahuestiliyahque in achtohque de yehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Huan namehhuan ahmo ijcon nanquichihuasque. Oc noncua in aquin ocachi nanquimahuestilisque ic namehhuan quipiya tlen mochihuas ocachi ahmo tlen iquisca. Huan in aquin tlatequiutiya quipiya tlen mochihuas quen in aquin tlapalehuiya. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tel, ¿aquin in ocachi quimahuestilisque? ¿In aquin motlalis tlacuas, noso in aquin tlapalehuiya? Tel, ¿ahmo ijcon melahuac quimahuestilisque in aquin ca iixpa in mesa? Huan nehhuatl no nica namohuan quen in aquin tlapalehuiya. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Namehhuan in aquin nochipa nohuan onancatcahque ic nanquitemactisque notequiu, masque onechmachilihque. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Huan ic inon namechchihua quen tequihua ijcon quen Nohueyitahtzin onechchihualo, ");
INSERT INTO ncjNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ic titlacuasque huan tiatlisque sansecnin ompa ihcuac nitlatequiutiya. Huan namechmacas in hueyilistli ic nantlixcomacasque ica in mahtlactli huan ome ololi den Israel. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Noyojqui omihto in Totecohtzin: ―Simón, Simón, xicchihua cuenta quen in ahmo cuali tlacatl mechtlahtlantoc ic mechyoltilanas ic xinechyolilcahuacan. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Huan nehhua nimotlaitlanihtoc ica tehhua ic ahmo mamitzpolo motlaneltoquilis. Huan tehhuatl, ihcuac timoyolcuepas ica nehhua, xiquinyolchicahua in mocnihuan. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","In Simón omoluic in Jesús: ―Notecohtzin, nimotemacatoc ic niyas tehuan in telpiloyan huan hasta canin micohuas noyojqui. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús oquiluiloc: ―Pedro; nimitziluiya yeh in axan achto ic tzahtzis in pachilel, tehhuatl tinechixtlatis yexpa. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Oncan Jesús oquiniluiloc in tetlamachticahuan: ―Ihcuac onamechtitlan iyoca, niyan bolsa, niyan in tlen ipan moehua in tomin, niyan tecactli; tel, ¿omechpolo itlahtlen? Yehhuan oquihtohque: ―Ahmo. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Oncan oquiniluiloc: ―Tel, axan in aquin quipiya bolsa maquihuica, noyojqui in aquin quipiya in tlen ipan quiehua in tomin. Huan in aquin ahmo quipiya in espada, maquinemaca icóton huan maquicohua. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tleca namechiluiya quipiya tlen tzonquisas ica nehhua, quen quihtohua in Itlahcuiloltzin: “Huan otetlahtlacoltihque ica in oc sequin ahmo cualten.” Tleca nochin in tlen ca tlahcuiloli ica nehhua quipiya tlen tzonquisas. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Oncan yehhuan oteiluihque: ―Totecohtzin, nicanca in ome espadas. Huan Yehhuatzin omonanquilihque: ―San ic inon. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Oncan Jesús oquixohuac huan ohuilohuac ipan in tepetl Olivos quen saniman mochihua. Huan otecuitlapanuihque in tetlamachticahuan. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ihcuac oahxihuato ompa, oquiniluiloc: ―Ximoyolmachtican ic ahmo mamechyolquitzqui in ahmo cuali. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Niman in Jesús ohuilohuac ocachi ompic de yehhuanten cana quen ic huehca motohuetzohua in tetl, huan ompa omotlancuaquetzaloc ic omoyolmachtiloc. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Huan omihto: ―Nohueyitahtzin, tla monequi, nechmaquixtilos ic nitlapanos; ahmo maye ica nehhua notlanequilis, tlahmo ica Tehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Oncan otemonextili se ángel den neluicac ic techicahuas. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Huan ic tequin otlapanoloticatca, omoyolmachtiloc ocachi chicahuac. Huan in teitonil ochopinticatca quen yestli tlalpa. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ihcuac otlan moyolmachtilo ohuilohuac moahsihque in tetlamachticahuan. Quen otlocoxque, omahsitohque cochtoque. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Oncan oquiniluiloc: ―Tel, ¿tleca nancochticaten? Ximehuacan huan ximoyolmachtican ic ahmo mamechyolquitzqui in ahmo cuali. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","In Jesús queman oc omononotzticatcahque ihcuac oahsicohque miyac tlacamen. Inon Judas, yehhuatl inon seya den mahtlactli huan ome tetlamachticahuan, huan yehhua oquis ihcuac ocatca in tlacuali den tlaolichtilistli. Yehhuatl inon in tlayecanqui huan omopacho ic otepipitzo in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Oncan Jesús omoluic: ―Judas, tel, ¿ic tinechpihpitzohua, tinechtemactiya nehhua aquin Nitetiachicau ica nochin tlacatl? ");
INSERT INTO ncjNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","In aquin tehuan ocatcahque in Jesús oquitaque tlen opanoticatca, huan otetlahtlanihque: ―Totecohtzin, tel, ¿tiquinmacasque ica in espada? ");
INSERT INTO ncjNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Huan se de yehhuan oquinacastehtec ic iyejcan in itlaquehual in hueyixtoc den tiopixcamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Huan Jesús omihto: ―Xiquincahuacan, san ic inon. Oncan Jesús omomachili inacas inon tlaquehuali huan omopahti. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Niman omoluihque in achtohque den tiopixcamen huan in tlixpiyanimen den tiopan huan in tetecten, inohque aquin tehuicanihque: ―Tel, ¿onanualejque namehhuan ica espadas huan cohuitl quen niyesquiyani niichtejqui? ");
INSERT INTO ncjNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ihcuac namohuan onicatca mostli ipan in tiopantli, niyan onannechquitzquihque. Huan axan inin namotonal, ihcuac mechtequiutiya in ichicahualis in ahmo cuali tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ihcuac otequitzquihque in Jesús, huan otehuicaque tlatemactili ichan in hueyixtoc den tiopixcamen. Huan Pedro otecuitlapanuiyaya san huehca. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Huan ompa oquitlalihque se tletl tlanepantla den quiahuactli. Huan ompa oquiyehualuihque inon tletl. Huan Pedro noyojqui ompa inuan omotlali. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Oncan se tesqui ic oquitac ompa oyehuatoya, oquitzticatca huan oquihto: ―Noyojqui inin tlacatl ihuan onemiyaya in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","In Pedro ahmo omocuiti huan oquihto: ―Sihuatl, nehhuatl ahmo niquixmati. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Satepa oquitac oc seya huan oquiluic: ―Tehhuatl noyojqui tipohui inuan. Huan Pedro oquihto: ―Ahmo nehhua, tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Huan cana se hora satepa, oquihtohtehuac oc seya: ―Ic nele, inin tlacatl ihuan ocatca, tleca noyojqui galileahteco. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Oncan Pedro oquihto: ―Tlacatl, ahmo nicmati ica tlen titlahtohtica. Huan ic oc otlahtohticatca in Pedro, otzahtzic in pachilel. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Huan in Totecohtzin omocuitlapantlachiyaliloc huan omotac in Pedro. Yehhua oquilnamic in tlen Totecohtzin omoluihtoya: “Achto ic tzahtzis in pachilel, tinechixtlatis yexpa.” ");
INSERT INTO ncjNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Oncan in Pedro oquis huan ochocac ica itlocol. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","In tlacamen aquin oteixpixtoyahque in Jesús teca omahuiltihque huan otehuihhuitejque. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Oteixpiquihque huan oteixtecapanihque, huan oteiluihque: ―¡Axan xiquihto aquin omitzixtecapani! ");
INSERT INTO ncjNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Huan oquihtohuayahque oc sequin tlahtoli ahmo cuali ic tepacteca. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ic otlatuic omosentlalihque in tetecten den judeahtecos huan in achtohque den tiopixcamen huan in tlamachtiyanimen den itlanahuatil Moisés. In Jesús otehuicaque inixpa inon tequihuahmen huan ompa otetlahtlanihque: ");
INSERT INTO ncjNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Xitechilui, tel, ¿tehhuatl in Cristo? Yehhuatzin oquinnanquililoc: ―Tla namechiluis queme, ahmo nannechneltocasque. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Huan tla namechtlahtlanis itlahtlen, ahmo nannechnanquilisque huan niyan nannechcahcahuasque. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Huan de axan nehhuatl aquin Nitetiachicau ica nochin tlacatl niyehuatos teyejcan in Dios Hueyicatzintli. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Niman otetlahtlanihque nochten: ―Tel, ¿tehhuatl Ticonetzin in Dios? Huan Jesús oquinnanquililoc: ―Queme, nehhuatl ijcon quen onanquihtohque. ");
INSERT INTO ncjNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Oncan oquihtohque yehhuan: ―Tel, ¿tlen ic ticnequisque oc sequin tlatemactiyanimen? Tehhuanten yoticajque ica tlen otiquihto. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Oncan nochten otehuicaque in Jesús iixpa in Pilato. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Huan ompa opeuque teteluiyahque: ―Otiquitaque inin tlacatl quinixpehualtiya in tomasehualtlacahuan. Huan quihtohua ahmo tictlaxtlahuilisque in renta in hueyixtoc romano. Huan noyojqui quihtohua yehhuatl in Cristo, quihtosnequi se hueyixtoc. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","In Pilato otetlahtlani: ―Tel, ¿tehhuatl in hueyixtoc den judeahtecos? In Jesús oquinanquililoc: ―Queme, ijcon quen tehhuatzin omihto. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","In Pilato oquiniluic in achtohque den tiopixcamen huan in tlacamen: ―Ahmo nicahxiliya ica niyan tlen quichiutoc inin tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Huan yehhuan ocachi chicahuac oquihtohque: ―Quintlapolochtihtoc nochin tlacamen den tlali Judea ica in itlamachtilis. Opeu den tlali Galilea hasta nican. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ihcuac Pilato oquicac inin, oquitlahtlani tla inon tlacatl den Galilea. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ihcuac oquiluihque queme, otetitlan iixpa in Herodes, in hueyixtoc den Galilea, aquin noyojqui ocatca Jerusalén ipan inon tonalten. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ic oteitac in Jesús, in Herodes molui opactoya. Tleca tequin oquinequiyaya teitas quen oquicaquiltihtoyahque ica Yehhuatzin huan oquinequiyaya quiitas se tlachiutli mahuestic. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Huan ica miyac tlahtoli otetlahtlani. In Jesús ahmo onahuatihuac. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Noyojqui ompa ocatcahque in achtohque den tiopixcamen huan in tlamachtiyanimen den itlanahuatil Moisés, quen oteteluiyayahque ica miyac tlahtoli. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","In Herodes inuan isoldados oteixtlasque huan teca omahuiltihque. Otetlaquentihque ica cuahcuali tlaquemitl quen hueyixtoc. Oc sepa in Herodes otetitlan iixpa in Pilato. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","In achto omococoliyayahque in Pilato huan Herodes huan ipan inon tonali omosechiuque. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","In Pilato oquinsentlali in achtoque den tiopixcamen huan in tequihuahmen huan in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Huan oquiniluic: ―Namehhuan onannechualiquilihque inin tlacatl aquin nanquihtohuahque quintlapolochtiya in tlacamen. Huan yonictlahtlani namoixpa huan ahmo nicahsi ica tlen tlahtlacoli nanquiteluiyahque. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Niyan in Herodes ahmo ocahsic ica tlen tlahtlacoltihtoc. Huan ic inon otechualcuepili. Yinanquimatihque ahmo oncan niyan tlen quitlapanoltis ica miquilistli. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Niyau nictlapanolti ic maquihuihhuitequican huan satepa nicahcahuas. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ipan inon tonali den iluitl in Pilato quipiya tlen quicahcahuas se preso quen saniman intlamachilis. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Huan nochten san secnin opeuque tzahtzihque: ―¡Mamiqui inin huan xicahcahua in Barrabás! ");
INSERT INTO ncjNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","In Barrabás otzactoya telpiloyan ica se tlamohsihuilistli ipan in altepetl huan ic otemicti. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","In Pilato oquinequiyaya tecahcahuas in Jesús huan oc sepa oquiniluic. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Huan yehhuan oquihtohque ocachi chicahuac: ―¡Xicmictican ipan cruz! ");
INSERT INTO ncjNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ic yexpa in Pilato oquihto: ―Tel, ¿tlen ahmo cuali quichiutoc? Ahmo nicahsi tlen itlahtlacol maquitlapanolti ica miquilistli. Niyau nictlapanolti ic maquihuihhuitequican huan satepa nicahcahuas. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Huan in tlacamen ocachi oquihtohque chicahuac mamiqui ipan in cruz, huan yehhuan huan in achtohque den tiopixcamen tequin chicahuac oquihtohque hasta ocahsique tlen oquinequiyayahque. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","In Pilato omotemacac quichihuas in tlen yehhuan oquihtohque. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Huan ijcon oquicau inon tlacatl aquin oquitlapehpenihtoya, inon aquin otzactoya ica in tlamohsihuilistli huan noyojqui in temictiyani. Huan Pilato oquinmacti in soldados in Jesús maquichihuacan quen oquinejque in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ihcuac otehuicaque in Jesús ic temictisque, in soldados oquiquitzquihque se tlacatl den tlali Cirene, itoca Simón. Yehhua ohualaya den mila huan yehhua oquimamaltihque in cruz tecuitlapanuihtiu in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Otecuitlapanuiyayahque miyac tlacamen huan sihuamen huan otzahtzihque ica intlocol ica Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Huan Jesús oquinitaloc huan oquiniluiloc: ―Sihuamen den Jerusalén, ahmo xichocacan ica nehhua, tlahmo ica namehhuan huan ica namopiluan. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tleca ahsiquiu in tonalten queman quihtosque: “Mapaquican in aquin ahhuel quitasque inconeu, huan in aquin ahyic oquitaque huan ahyic otlachichitihque.” ");
INSERT INTO ncjNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Oncan quihtosque in tlacamen: “Matechpechi in tepemen”; huan noyojqui quihtosque: “Matechtlapacho in tlachquilten.” ");
INSERT INTO ncjNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tleca tla ijcon quichihuasque ica nehhua in aquin ahmo tlahtlacolyo, tel, ¿quen quichihuasque ica in aquin tlahtlacolyo? ");
INSERT INTO ncjNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Noyojqui oquinuicayayahque inehuan tlahtlacolyohque ic quinmictisque tehuan Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ihcuac oahsitoque in canin itocahyan Tzontecontla huan ompa otemasohualtihque ipan in cruz. Noyojqui oquinmasohualtihque inehuan in ichtejcamen ipan sehsen cruz. Huan inuan oquintelquetzque in yiyi cruz, se ic teyejcan huan oc se ic oc se lado. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Huan ihcuac oquinmasohualtihticatcahque, in Jesús omihto: ―Nohueyitahtzin, xiquintlapohpolui tleca ahmo quimatihque tlen quichiuticaten. Huan in soldados omahuiltihque ica in dados ic quixehxelosque in tetlaquen in Jesús, aquin quitlanis. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","In tlacamen huan in tequihuahmen ompa oteitzticatcahque huan teca omahuiltihque ic oquihtohque: ―Oquimaquixti in oc sequinten; axan mamomaquixti isel in tla nele yeh in Cristo, itlapehpenil Dios. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","In soldados noyojqui teca omahuiltihque Yehhuatzin, huan omopachohtayahque temacahque in tlayili chichic. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Huan oteiluiyayahque: ―Tla tehhuatl in hueyixtoc den judeahtecos, ximomaquixti mosel. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Huan oquihcuilohque sequin tlahtoli tetzoncuac ica in tlahtoli griegohteco huan romanohteco huan hebreohteco, tlen quihtohua: “Yeh inin in hueyixtoc den judeahtecos.” ");
INSERT INTO ncjNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Se de inon ichtejcamen no ompa omasoutoya ihtech in cruz oteiluic: ―Tla tehhuatl Cristo, ximomaquixti huan noyojqui xitechmaquixti. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Huan in oc seya oquixiluic in icompañero: ―Tel, ¿ahmo titemoucaita in Dios? Teh noyojqui ijcon titlapanotica. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tehhuanten matechtlapanoltican tleca tictlaxtlahuasque in tlen melahuac totlahtlacol oticchiuque. Huan inin tlacatl ahmo quichiutoc in tlen ahmo cuali. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Oncan oteiluic: ―Jesús, xinechilnamiquis huan noca xitlocoya ihcuac ahxihuas tenahuac in tetlatequiutilistzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","In Jesús omonanquilic: ―Ic nele nimitziluiya, de axan nohuan tiyes nepa neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Cana nepantla otlayohuac ipan nochin tlali huan ohuehcau hasta cana yiyi horahtiotlac. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","In tonaltzintli otliliu huan in tatapahtli tlen ic quitlahcoxelohtoque in tiopantli otzomon inepanco. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Oncan Jesús otzahtzihuac: ―Nohueyitahtzin, temajco nictemactis notonal. Huan ic omihto inon, omicohuac. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ihcuac in tlayecanqui oquitac in tlen opanoc, otemahuestili in Dios huan oquihto: ―Ic nele inin tlacatl tlamelajcan. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nochin tlacatl aquin ompa ocatcahque huan oquitaque tlen opanoc, yehhuan oyahque nochten moyoluitectihue ica intlocol. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Huan nochten in aquin oteixmatiyayahque in Jesús, huan noyojqui in sihuamen aquin otecuitlapanuiyayahque den Galilea, otlachixticatcahque huehca ica tlen opanoc. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ocatca se tlacatl tlamelajcan itoca José den altepetl Arimatea den tlali Judea. Inon se tequihua den hueyixtoque judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Inin José oquichiyayaya in tetlatequiutilistzin Dios huan ahmo omosetili inuan in tequihuahmen ica tlen oquichiuque. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","In José oya quita in Pilato huan oquitlahtlanili in tetlacayo in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ihcuac oquitemohuihque in tetlacayo ipan in cruz, otepihpiqui ica se hueyi tatapahtli huan otetlalihque ipan in tlaltecochtli tlachihchiutli icxitlan se tepetl canin ayamo aquin omotocatoya. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Inon tonali quiyectlaliyahque ica in tonali den nesehuilistli quen yohualahsitaya. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Inon sihuamen aquin tehuan huitzen in Jesús den Galilea oyahque quitahque in tlaltecochtli huan oquitaque quen oquitlalihque in tetlacayo in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Huan ihcuac omocuepque inchan, oquiyecchihchiuque in pahtli ahhueyac huan aceite huan omosehuihque ipan in tonali den nesehuilistli ijcon quen ca ipan in tlanahuatili. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ipan in achto tonali den semana, in sihuamen omocuepque molui sancuel ipan in tlaltecochtli. Quihuicahque in pahtli ahhueyac tlen oquichihchiuque. Huan oquincuitlapanuihque oc sequin sihuamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ihcuac oahsitoque ompa, ocahsique in tetl tlen ica oquixtzajque in tlaltecochtli ayacmo yojqui ocatca. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Huan ihcuac ocalajque ompa, ayacmo ocahsique in tetlacayo in Totecohtzin Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Huan quen tel oquimatque ic omomoutihque. Ihcuac inon oquinitaque ome ángeles ihcaticaten inahuac tlaquentitoque hasta petlani. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Huan quen yehhuan omixtocaque ic tlalpa ica moucayotl, inon ángeles oquiniluihque: ―Tel, ¿tleca nanquitemohuahque in aquin yoltoc canin den mijcamen? ");
INSERT INTO ncjNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ahmo ilohuac nis. Yoihxohuac. Xiquilnamiquican quen omechnonotzaloc nepa Galilea. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Tel, ¿ahmo mechiluiloc quen Yehhuatzin aquin Tetiachicau ica nochin tlacatl oquipixque tlen tetemactisque inmajco in tlahtlacolyohque huan temictisque ipan in cruz, huan ipan yiyi tonali ihxohuas? ");
INSERT INTO ncjNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Yehhuan oquilnamijque in tlahtoli tlen oquiniluiloc in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Huan ic omocuepque den tlaltecochtli oquinnonotzque in mahtlactli huan se tetiotlatitlaniluan huan nochin oc sequinten. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Inohque aquin oquinnahuatihque yehhuan in María Magdalena huan Juana huan María inana in Jacobo huan oc sequin sihuamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Huan in tetiotlatitlaniluan oquihtohque san quipanehnehuiliyahque yehhuan. Huan ahmo oquineltocaque. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Masque ijcon oquinehnehuilihque, in Pedro oya tlachiya ipan in tlaltecochtli. Huan ic otlachix tlahtec oquitac in tatapahten caten ic oc se lado. Huan omocuep ichan quen tel oquimat ica tlen opanoc. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ipan inon tonali oyahtayahque ome tetlamachticahuan ipan in altepetl itoca Emaús, cana ome hora ic huehca den Jerusalén. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Huan omononotztayahque yehhuan ica nochin tlen opanoc ica in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ihcuac omononotztayahque, san tlama in Jesús omahsitohque huan inuan onehnemohuac. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Masque oteitaque, yehhuan omixpatlahque. Ahmo oteixmatque aquin Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Oncan Jesús oquintlahtlaniloc: ―Tel ¿tlenon nanmononotztihuitzen ic nannehnentihuitzen huan nantlocoya? Yehhuan omoquetzque quen tlocoyahque. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Huan se de yehhuan, itoca Cleofas, otenanquilic: ―Nochin tlacatl quimatihque tlen opanoc Jerusalén inin tonalten. Tel, ¿san tehhuatzin ahmo momati masque ompa motepaluilohtoc? ");
INSERT INTO ncjNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Oncan Yehhuatzin oquintlahtlaniloc: ―Tel, ¿tlen opanoc? Huan oteiluihque: ―Ica in Jesús den altepetl Nazaret, inon se tlayolchicauqui hueyixtoc ica in tlen oquichiu huan ica itlahtol teixpa in Dios, huan noyojqui inixpa in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Huan quen in achtohque den tiopixcamen huan totequihuahhuan otetemactihque matetlahtlacoltican ica temiquilis ipan in cruz. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tehhuanten oticnehnehuilihque quen Yehhuatzin momaquixtinihque in tochantlacahuan den Israel. Huan axan yipanotoc yiyi tonali ic otemictihque. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Huan axan quen tel oticmatque ica tlen otechiluihque sequin sihuamen de tehhuanten. Tleca yehhuan oyahque huehca sancuel ipan in tlaltecochtli. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Huan quen ahmo ocahsique in tetlacayo, ohualahque techiluiyahque yehhuan omixcahcayauque ica in ángeles quen oquiniluihque quen in Jesús yolihuahtoc. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Niman oyahque sequin de tehhuanten ipan in tlaltecochtli huan oquitaque ijcon quen oquihtohque inon sihuamen, huan ahmo oteitaque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Oncan Jesús oquiniluiloc inon inehuan: ―Tel, ¿tlemach ahhuel onanquinehnehuilihque? Huan ¿quemach nanuehcahuisque ic nanquineltocasque nochin in tlen oquihcuilohque in tlayolchicaucamen? ");
INSERT INTO ncjNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Tel, ¿ahmo ijcon tlapanoloni in Cristo achto ic mohueyililos? ");
INSERT INTO ncjNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Oncan opehualoc quinnonotzalo ica in Tlahcuilolten tlen oquihtohque ica Yehhuatzin. Omopehualtic ica in iamahuan in Moisés huan ijcon omochiu ica nochin inon tlayolchicaucamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ihcuac oahsitayahque ipan in altepetl canin oyahyaya, in Jesús omochiu quen san opanolotaya. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Huan yehhuan otetlatlautihque: ―Mamocahualo tohuan, tleca yitiotlac. Yitlapoyaucan. Oncan in Jesús inuan ocalacohuac huan omocahualoc. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Huan ihcuac omotlaliloc iixpa in mesa inuan, Yehhuatzin omoan in pantzin huan omotiochiu huan omoxehxeluihque. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ic inon tlen omochiu inixpa, ijcon oteixmatque Yehhuatzin in Jesús. Oncan Yehhuatzin san tlama oteixpolohque. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Huan yehhuan omoluihque se huan oc seya: ―Tel, ¿ahmo nele hasta otechyolpacti ihcuac otechualnonotzalotaya in Itlahcuiloltzin ipan in ohtli? ");
INSERT INTO ncjNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Oncan yehhuan ahmo ocachi omochixque. Niman omocuepque Jerusalén. Huan oquinahsitohque canin omosentlalihtoyahque in mahtlactli huan se tetiotlatitlaniluan ihuan oc sequinten. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","In tetiotlatitlaniluan oquiniluihque in inehuan: ―Ic nele in Totecohtzin oihxohuac den mijcamen, huan Simón oteitac. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Oncan inon inehuan oquinnonotzque quen opanoc ipan in ohtli, huan quen oteixmatque in Jesús ihcuac omoxehxelo in pantzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Huan ihcuac teca otlahtohticatcahque in Jesús, Yehhuatzin omonextiloc inepanco yehhuan. Oquintlahpaloloc huan oquiniluiloc: ―Xiyetocan cuali namehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Yehhuan tequin omomoutihque huan oquinehnehuilihque oquitzticatcahque se yehyecatl. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Huan Jesús oquiniluiloc: ―Tel, ¿tleca nanmomoutiyahque, huan tleca ijcon nanquiyolnehnehuiliyahque? ");
INSERT INTO ncjNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Xiquitacan nomahuan huan nocxihuan. Yiyeh nehhuatl. Xinechmachilican huan xinechitacan. Se yehyecatl ahmo quipiya itlacayo quen namehhuan nanquitahque nicpiya. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Huan ic oquiniluiloc inin, oquinnextililoc in teman huan tecxihuan. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Huan quen opactoyahque, ayamo oquineltocaque huan quen tel oquimatque. In Jesús oquiniluiloc: ―Tel, ¿nanquipiyahque tlen nanquicuasque? ");
INSERT INTO ncjNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Oncan otemacaque se pedazo michi tlapohpoxoli ihuan chihton nectli. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Huan Yehhuatzin omocuilihque huan omocua inixpa. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Huan niman oquiniluiloc: ―In tlen onechpanoc, yehhua in tlen onamechiluic ihcuac oc namohuan onicatca. Oquipiyaya tlen tzonquisas ica nehhua quen ca itlanahuatil Moisés huan ipan iamahuan in tlayolchicaucamen huan ihtech in salmos. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Oncan oquinmatiltiloc ica in Itlahcuiloltzin. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Huan oquiniluiloc: ―Ijcon ca tlahcuiloli quen in Cristo quipiya tlen micohuas huan ipan yiyi tonali mopiya tlen ihxohuas den mijcamen. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Huan tlanonotzasque ica Tetocahtzin nohuiyan ipan in tlalticpactli. Pehuasque de Jerusalén quiniluisque quen mamoyolcuepacan huan ijcon quintlapohpoluilos intlahtlacol. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Namehhuan in nantlachipahuanimen ica inin tlahtolten. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Xicmatican, namechtitlanis ica tlen Nohueyitahtzin otechcaquiltiloc. Ic inon ximocahuacan nican Jerusalén hasta ic nanquiselisque techicahualis tlen hualuilohuas den huehcapa. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Oncan Jesús oquinuicaloc huehca den altepetl hasta Betania, huan omasohualoc ic oquintiochihualoc. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Huan ic otlan quintiochihualo, omoxeloloc de yehhuanten huan otehuicaque neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Huan yehhuan omocuepque Jerusalén ica paquilistli. ");
INSERT INTO ncjNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Huan mostli ocatcahque tiopan temahuestilihtoyahque in Dios. Ijcon tlami.");
INSERT INTO ncjNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ihcuac omopehualti in tlalticpactli, onemiyaya in Tecualnextzin in Dios, huan inin Tecualnextzin oilohuac tehuan Dios, huan nele ilohuac in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Achto ic opeu in tlalticpactli, Yehhuatzin yiilohuac tehuan Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ica techicahualis Yehhuatzin omochiu nochin tlen oncan, huan in tlahmo ica Yehhuatzin, niyan tlen yesquiyani. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yehhuatzin in aquin quinmacalos yancuic nemilistli, huan Yehhuatzin quen in tlanextli. Yehhuatzin quinyolnehnehuiltis in tlacamen ica tlen melahuac. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Inin tlanextli petlani ipan in tlalticpactli, huan yehhuan aquin impan tlayohuatoc ahhuel quisehuiyahque. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ocatca se tlacatl aquin in Dios omohualtitlan, itoca Juan. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Omohualtitlan quen se tlachipauqui ic tlanonotzas teca Yehhuatzin. Omonec maquineltocacan teca Yehhuatzin aquin quinyolnehnehuiltilo in tlen melahuac. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","In Juan ahmo yehhua in aquin quinyolnehnehuiltiya; yehhua san quen se tlachipauqui ic tlanonotzas teca Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yehhuatzin ohualuilohuaya melahuac tlalticpac, huan quinyolnehnehuiltilo nochin tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Huan Yehhuatzin aquin in Iconetzin Dios oilohuac ipan in tlalticpactli. Huan masque Yehhuatzin omochiu in tlalticpactli ica techicahualis, in tlalticpac tlacamen ahmo oteixmatque tla Yehhuatzin nele in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ohualtemoloc ipan tetlalticpac, huan in tlalticpac tlacamen oteixtlasque. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Huan nochin aquin otesehuihque huan oteneltocaque quen Intemaquixticahtzin, inohque oquinmonencahuiloc mochihuasque teconehuan Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","In netlacatilis ic omochiuque teconehuan Dios ahmo quen in netlacatilis in tlalticpac tlacamen, quen panos ihcuac mononotzahque noso quen quiyectlaliyahque. Inon in netlacatilis quen oquiyectlaliloc in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Huan in Tecualnextzin Dios omochihualoc tlacatl huan onemohuayaya tohuan. Oquintlasohtlalo nochin tlalticpac tlacamen huan oquinmonextililoc tlen melahuac. Huan tiquitztoque tehueyilistzin tlen mopiya, quen Yehhuatzin tesel in Iconetzin Tohueyitahtzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","In Juan otlahto teca Yehhuatzin, huan oquihto: ―Inin yehhua aquin ica onitlahtohuaya ihcuac oniquihto Yehhuatzin in aquin nechcuitlapanuiya, yeh in aquin ocachi hueyi tequisca, tleca onemohuayaya achto quen ihcuac onitlacat. Yeh in tlen oquiniluic in Juan. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tinochten ticselihtoque miyac tetlatiochihualis ica tetlasohtlalis tlen ahyic tlamis. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","In tetlanahuatil in Dios otechpanolti in Moisés, huan in tetlahtoltzin tlen melahuac techtlahtlapoluis otechualiquilo in Jesucristo. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ahmo aquin teitztoc in Dios. Iconetzin san seya nochipa ilohuac tehuan Tohueyitahtzin, huan Yehhuatzin in aquin otechualtitlanililoc in Dios ic technotzalos teca Yehhuatzin in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","In tequihuahten den judeahtecos nepa Jerusalén oquintitlanque sequin tiopixcamen huan intlapalehuihcahuan, maquitlahtlanican in Juan aquin yehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Huan yehhua oquinyequiluic: ―Nehhua ahmo niCristo in aquin oquitetlaliloc matlatequiutilo. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Oncan oc sepa oquitlahtlanihque: ―Tel, ¿aquin tehhua? ¿Tehhua tel titlayolchicauqui Elías? Huan oquinnanquilic: ―Ahmo nehhua. Oc sepa oquitlahtlanihque: ―Tel, ¿tehhuatl in tlayolchicauqui aquin quipiya tlen hualas? Huan oquinnanquilic: ―Ahmo. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Oncan oquiluihque: ―¿Aquin tehhua, tel? Ticpiyahque tlen tiquinuiquilisque se tlahtoli in aquin otechualtitlanque. Tel, ¿tlen cuali titechiluis ica tehhua? ");
INSERT INTO ncjNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","In Juan oquinnanquilic: ―Otlahto ica nehhuatl in tlayolchicauqui Isaías ihcuac oquihto hualas seya aquin coutzahtzis ipan in acahualtlahtli huan quihtos: “Ximoyectlalican quen nanteselisque in Totecohtzin.” ");
INSERT INTO ncjNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","In aquin oyahque quinonotzahque ica in Juan intlatitlaniluan in fariseos. Yehhuan se ololi den tiopixcamen judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Huan oquitlahtlanihque: ―Tel, ¿in tlahmo tehhuatl in Cristo, niyan Elías, niyan inon tlayolchicauqui, tleca titlacuatequiya? ");
INSERT INTO ncjNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","In Juan oquiniluic: ―Masque nehhua nitlacuatequiya ica atl, yoahxihuaco Yehhuatzin ica aquin nannechtlahtlaniyahque, huan ahmo nanteixmatihque. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Huan ayacmo huehca pehualos ica tetequiu, huan ocachi mopiya tequihuahyotl quen nehhuatl. Nehhua ahmo tlen noquisca niyan ic nimochihua tetlapalehuiyani. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nochin inin opanoc ipan in tlali itocahyan Betábara, tlen ca ipan oc se lado den atentli Jordán, ic quixnamictica in Jerusalén canin in Juan otlacuatequiyaya. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Huan ic mostla in Juan oteitac in Jesús omopacholotaya inahuac, huan oquihto: ―Xiquitacan, ompa hualuilohua in aquin quen Tecolelo in Dios quen oc quitemactihticaten ipan in tiopan. Tleca in Dios otetitlaniloc maquixtlapacho intlahtlacol den tlalticpac tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nehhua onamechmatiltiyaya ica Yehhuatzin ihcuac oniquihto: “Satepa ica nehhua hualuilohuas oc seya ocachi hueyixtos quen nehhua, tleca onemohuayaya achto quen ihcuac onitlacat.” ");
INSERT INTO ncjNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nehhua noyojqui ahmo oniteixmatiyaya Yehhuatzin in Cristo, huan yeh in ica onihuala niquincuatequiya in tlacamen, in israeltecos aquin noyojqui intoca judeahtecos. Ijcon moyectlalisque ic teselisque Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Noyojqui oquihto in Juan: ―Nehhua oniquitac in Itiotonaltzin Dios ohualtemoloc ic neluicac quen se huilotl, huan omotlali tepa Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nehhua ayamo oniteixmatiyaya aquinon, huan in aquin onechualtitlaniloc manitlacuatequi ica atl onechiluiloc: “Ihcuac tiquitas in Itiotonaltzin hualtemolos quen huilotl huan motlalilos ihtech inon tlacatzintli, Yehhuatzin in aquin quinmacalos in Itiotonaltzin Dios.” ");
INSERT INTO ncjNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nehhua yiniquitztoc ihcuac opanoc ijcon quen onechiluiloc, huan neh niquihtohua nele Yehhuatzin Teconetzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Huan ic mostla, oc sepa ompa ocatca in Juan ihuan ome itlamachticahuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Huan ihcuac oteitac panolitiu in Jesús, in Juan oquihto: ―Xiquitacan, ompa hualuilohua Yehhuatzin aquin quen Tecolelo in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","In ome itlamachticahuan Juan oquicajque ihcuac oquihto inon, huan otecuitlapanuihque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Oncan Jesús omocuitlapantlachiyaliloc huan omotaque quen tecuitlapanuiyahque, huan omoluihque: ―¿Tlen nanquitemohuahque? Yehhuan otenanquilihque: ―Tlamachtiyani, ¿canin in techan? ");
INSERT INTO ncjNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesús omonanquilihque: ―Xihualacan xiquitacan. Oncan oyahque huan oquitaque canin chantilo huan ompa omocauque inon tonali tehuan, oahsique cana mahtlactli hora sancuel. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Se den inehuan aquin oquicajque in Juan huan otecuitlapanuihque in Jesús itoca Andrés, icniu in Simón Pedro. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","In Andrés oya achto quitemohua in icniu Simón huan oquiluic: ―Otiteahsique in Mesías, tlen quihtosnequi in Cristo, in aquin oquitetlaliloc matlatequiutilo. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Saniman in Andrés oquihualicac in Simón ic teixmatiltiya in Jesús, huan ihcuac Jesús omoixitztehuac, Yehhuatzin omoluic: ―Cahso, tehhuatl in tiSimón, ticoneu in Jonás, huan mitztocahhuisque Cefas. Huan ica intlahtol quihtosnequi tetl. Huan ica tlahtoli griegohteco quisa Pedro. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Huan ic mostla in Jesús omotemacaloc huilohuas ipan in tlalten den Galilea, huan omahsic in Felipe huan omoluic: ―Xinechcuitlapanui. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","In Felipe chani den altepetl itoca Betsaida, canin noyojqui chantihque in Andrés huan Pedro. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Oncan Felipe oya quitemohua in Natanael huan oquiluic: ―Otiteahsique in tlacatzintli ica aquin oquihcuiluihque in Moisés huan in tlayolchicaucamen ipan Intlahcuilolamau. Yehhuatzin in Jesús iconeu in José, tealtepeu Nazaret. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Oquihto in Natanael: ―Tlen cox, ¿cuali quisas se ixtlamatqui den Nazaret? In Felipe oquinanquilic: ―Xihualau xiteita. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Queman in Jesús omotac in Natanael yiteahsitiu, omihto: ―Ompa huitz se cuali judeahteco aquin ahmo tlacahcayauqui. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Oncan Natanael otetlahtlani: ―¿Quenin tla nechmatihque tlen noquisca? Huan Jesús omoluic: ―Nehhua onimitzitac achto ic omitznotz in Felipe, ihcuac oticatca itzintla in higoscohuitl, huan onicmat tlen moquisca. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Oncan oquihto in Natanael: ―Tlamachtiyani, Tehhuatzin Ticonetzin Dios; Tehhuatzin in aquin tlatequiutilosquiyani ipan in tlali Israel. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","In Jesús omonanquilic: ―Tel, ¿ticneltoca san tleca onimitziluic quen onicmat tlen moquisca ihcuac onimitzitac itzintla in higoscohuitl? Huan tiquitas ocachi huehhueyi tlachiuten mahuestic quen inon. ");
INSERT INTO ncjNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Huan ocachi omoluic in Jesús: ―Ic nele namechiluiya, quen ica in Jacob, in Dios oquinextiloc in ángeles temohuahque huan tlehcohuahque ipan se escalera tlen ahsitoc neluicac, ijcon ica nehhuatl aquin Nitetiachicau ica nochin tlacatl nanquitasque in ohtli tlen ahsitoc neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Hasta ic huiptla ocatca se mosihuautilistli ipan in altepetl Caná den tlali Galilea. In tenanahtzin Jesús ompa ocatca. ");
INSERT INTO ncjNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","In Jesús huan tetlamachticahuan noyojqui ompa oihilohuaya ica inon mosihuautilistli. ");
INSERT INTO ncjNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Huan otlan in vinohtlayili, huan in tenanahtzin Jesús oteiluic: ―Ayacmo quipiyahque in vinohtlayili. ");
INSERT INTO ncjNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Oncan Jesús omonanquilic: ―¿Tleca nechiluiyahque ic inon tlahtoli? Ayamo ahsi in tonali ic nimonextis ica tlen cuali nicchihuas. ");
INSERT INTO ncjNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Oncan tenanahtzin oquiniluic in aquin tlaxehxelohticaten: ―Xicchihuacan nochin tlen mechiluisque. ");
INSERT INTO ncjNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ocatcahque chicuasin tzotzocolten ihuan atl tlen ic in judeahtecos mamahtequiyahque. Huan se tzotzocoli quixicohua cana naupohuali noso se ciento litro den atl. ");
INSERT INTO ncjNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","In Jesús omoluihque in tlaxehxelohuanimen: ―Xiquintemitican ica atl inin tzotzocolten. Oncan oquinyectehtemitihque nochin, ");
INSERT INTO ncjNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","huan oncan Jesús oquiniluiloc: ―Axan xiquixtican chihton, huan xicuiquilican in iluichihuani. Huan ijcon oquichiuque. ");
INSERT INTO ncjNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","In iluichihuani oquimachili in atl yomocuep in vinohtlayili, niyan ahmo quimati de canin ocualicaque. San yeh in tlaxehxelohuanimen oquimauticatcahque, tleca yehhuan oquichicoquixtihque inon atl. Ijcon in iluichihuani oquinotz in mosihuautiyani ");
INSERT INTO ncjNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","huan oquiluic: ―Nochin tlacatl xiquinmahmaca achto in cuali vinohtlayili, huan ihcuac in tetlatlautilten tla tequin yoconihque, oncan ihcuac moxelos in moluihtic vinohtlayili. Huan tehhuatl, ¿tleca tiqueutoc in tlen cuali vinohtlayili hasta axan? ");
INSERT INTO ncjNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Inin tlen omochiu in Jesús ipan in altepetl Caná den tlali Galilea. Yeh in achto tlachiutli mahuestic ic tlen oquinnextiloc tehueyilistzin. Huan in tetlamachticahuan oteneltocaque. ");
INSERT INTO ncjNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Oncan satepa de inon ohuilohuac ipan in altepetl itoca Capernaum, inuan tenanahtzin huan tecnihuan huan in tetlamachticahuan. Huan ompa oihilohuaya se quesqui tonali. ");
INSERT INTO ncjNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Quenin yohualahsitaya in pascuahiluitl den judeahtecos, in Jesús ohuilohuac ipan in altepetl Jerusalén. ");
INSERT INTO ncjNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ompa oquinahsiloc ipan in tiopantli in aquihque quinemacahque in cuacuehten huan calnelos huan totomen, nochin tlen oquincohuilihque in judeahtecos quen ic quinmactisque. Huan oyehyehuatoya in aquin oquimpatiliyayahque in tomin in tlacamen aquin ohualahque ic huehca. ");
INSERT INTO ncjNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ic omotac inon, in Jesús omochiu se tlahuitequiloni den cuitlaxtli huan oquintotocaloc caltenco nochin yehhuan, sansecnin inuan in calnelos huan in cuacuehten. In aquin oquipatlaticatcahque in tomin, oquichayahualoc tlalpa in tomin huan oquinixcuepaloc in mesas. ");
INSERT INTO ncjNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","In tlanemacanimen ica in totomen oquiniluiloc: ―Xiquixtican nochin tlen nican nanquipiyahque. ¡Ahmo xicchihuacan tiyanquistli techan Notahtzin! ");
INSERT INTO ncjNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Oncan in tetlamachticahuan oquilnamijque ica in Itlahcuiloltzin tlen quihtohua: “Nicmahuestiliya techan masque ihcuac nictemactis nonemilis.” ");
INSERT INTO ncjNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Oncan in judeahtecos otetlahtlanihque: ―Tla titechnextilis se tlachiutli mahuestic, maticmatican tla nele ticpiya tequihuahyotl ic ticchihuas inin. ");
INSERT INTO ncjNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Huan Jesús omonanquilihque: ―Xicxitinican inin tiopantli huan ipan yiyi tonali nicchihchihuas oc sepa de yancuic. ");
INSERT INTO ncjNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Oncan in tequihuahten den judeahtecos oteiluihque: ―Ompohuali huan chicuasin xihuitl ic oquichihchiuque inin tiopantli, ¿huan tlemach, cuali ticchihchihuas ipan yiyi tonali? ");
INSERT INTO ncjNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Huan in tiopantli tlen ic otlahtolohuaya, yeh in tetlacayo. ");
INSERT INTO ncjNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Inon tetlamachticahuan oquimatque quen inon tlahtoli oquis den Itlahcuiloltzin, huan ayamo oquinehhnehuilihque tlen quihtosnequi. Huan satepa ic oihxohuac Yehhuatzin de mijcamen, oquinehnehuilihque inon tlahtoli tlen ic otlahtohuaya ica Yehhuatzin, huan ijcon otzonquis inon tlahtoli. ");
INSERT INTO ncjNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ihcuac Jesús oilohuaya Jerusalén, ipan in pascuahiluitl, miyacten oteneltocaque ic oquitaque in tlachiuten mahuestic tlen omochiu. ");
INSERT INTO ncjNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Huan Jesús ahmo oyolmatque ica yehhuan, tleca nochten oquinyolmatiloc ahmo nele teneltocahque. ");
INSERT INTO ncjNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ahmo omonequiyaya oc aquin mateilui quen quinehnehuiliyahque inon tlacamen, tleca Yehhuatzin quinyolmatilo quen quinehnehuiliya in tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ocatca se fariseo itoca Nicodemo, in aquin ocatca se tequihua den judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Inon Nicodemo oya teita in Jesús ihcuac tlayohua, huan oteiluic: ―Tlamachtiyani, ticmatihque mach otehualtitlan Dios ic techmachtisque, tleca niyan aquin ahhuel quichihua ica in tlachiuten mahuestic quenin Tehhuatzin mochihua tlahmo tehuan motequiutilo in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Oncan Jesús omoluic: ―Ic nele, nimitziluiya, in aquin ahmo tlacatis oc sepa ahhuel quinehnehuiliya quen motequiutilo in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","In Nicodemo otetlahtlani: ―¿Huan quenin tla se hueyi tlacatl oc sepa tlacatis? Tlen, ¿cuali calaquis oc sepa iihtectla inana, ic tlacatis oc sepa? ");
INSERT INTO ncjNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Huan Jesús omonanquilic: ―Ic nele nimitziluiya, in aquin mochihua teconeu in Dios quipiya tlen moyolcuepas ic mocuatequis, huan in Itiotonaltzin Dios quiyolchipahualos huan quimacalos in yancuic nemilistli. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nican tlalticpac tlacatihque san tlalticpac tlacamen quen intatahhuan, huan quipiyahque nemilistli den tlalticpac. San Yehhuatzin in Itiotonaltzin Dios cuali quinmacalos in nemilistli den neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ahmo ximoistlaco ica tlen nimitziluiya: “Nochten quipiyahque tlen tlacatisque de yancuic tla mochihuasque teconehuan Dios.” ");
INSERT INTO ncjNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","In yehyecatl yas san canic quinequi yas. Ticaqui quen xahuantas, huan ahmo ticmati canin huitz, niyan canin yau. Ijcon noyojqui ica in Itiotonaltzin Dios. Ahhuel titeita huan ahmo ticnehnehuiliya quen quinmacalos yancuic nemilistli yehhuan aquin mochihuasque teconehuan Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Oncan Nicodemo oc sepa otetlahtlani: ―Tel, ¿tlen quihtosnequi nochin inin? ");
INSERT INTO ncjNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","In Jesús omonanquilic: ―Tel, ¿tehhhua in tihueyi tlamachtiyani den israltecos, huan ahmo ticmati tlen quihtosnequi inin tlahtolten? ");
INSERT INTO ncjNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ic nele nimitziluiya, tehhuanten titlahtohuahque ica tlen ticmatihque, huan titlachipaucamen ica in tlen tiquitztoque, huan tehhuatl ahmo ticneltoca tlen nimitziluiya. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","In tlahmo tinechneltoca ihcuac nimitznonotza ica in tlahtoli den inin tlalticpactli, tel, ¿quenin nimitzneltoctis ica in tlahtoli den neluicac? ");
INSERT INTO ncjNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Niyan aquin ahsitoc in neluicac. San Yehhuatzin in Tetiachicau ica nochin tlacatl cuali tlahtolo ica inon tleca ompa chantilotoc. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nepa ipan in acahualtlahtli in Moisés oquiahcoc in cohuatl ipan se cohuitl maquitacan in israeltecos ic maquisasque. No ijcon quipiya tlen nechahcocuisque ipan in cruz nehhuatl aquin in Tetiachicau ica nochin tlacatl ic nechmictisque. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Huan nochin aquin nechneltocahque ahmo mapolihuican, ijcon quipiyasque in yancuic nemilistli nochipa. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’In Dios oquintlasohtlaloc tequin in tlalticpac tlacamen, onechualtitlaniloc nehhuatl aquin Tetlasohconetzin ic manechneltocacan nochten, ic ahmo mapolihuican, huan ijcon maquipiyacan in nemilistli nochipa. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dios ahmo onechualtitlaniloc ic niquimpohpolos in tlacamen, tlahmo ic niquinmaquixtilos. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’In aquin nechneltoca ica nehhuatl aquin Teconetzin Dios ahmo polihuis, huan in aquin ahmo nechneltoca yipoliutoc tleca ahmo nechneltoca ica nehhuatl aquin Tetlasohconetzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","In aquin ahmo nechneltocahque, yehhuan poliutoque ica intlahtlacol. Ijcon quen in tlanextli quintlanextiya nochin, yeh in quen niquinmatiltiya in tlalticpac tlacamen ica intlahtlacol. Huan in tlacamen ahmo quihuelitahque in aquin quinmatiltiya tlahtlacoli in ahmo cuali tlen quichiuticaten. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nochin aquin quichihuahque san tlen ahmo cuali, yehhuan ahmo quinequihque manesi tlen quichiuticaten. Huan ic inon ahmo nechuelitahque huan ica nehhuatl ahmo mohualpachohuahque. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Huan in aquin catehque tlamelajcanten mopachohuahque ica nehhuatl, manesi in tlen quichiuticaten, nochin quen tepactiya in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Satepa de inin, Jesús ohuilohuac inuan in tetlamachticahuan ipan in tlali Judea, huan ompa quesqui tonali inuan omocahualo huan otlacuatequilohtoya. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Noyojqui in Juan otlacuatequihtoya ipan itlatilanal Enón, inahuac in altepetl Salim, tleca ompa ocatca tequin miyac atl. Huan in tlacamen ohualayahque ica yehhuatl huan omocuatequiyayahque. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Inin opanoc achto de ihcuac ayamo quitzacuahque in Juan. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Oncan sequin in aquin quicuitlapanuiyahque in Juan opeuque motlahtolchihuiyahque ihuan se judeahteco ica tlen yeh ocachi cuali tlacuatequilistli. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Oyahque quiluiyahque in Juan: ―Tlamachtiyani, yehhuatl aquin ica otitechnonotz ihcuac mohuan ocatca ipan in oc se lado den atentli Jordán, axan tlacuatequihtoc huan nochin quicuitlapanuihticaten. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Oncan Juan oquiniluic: ―Niyan aquin cuali mohueyichihuas in tlahmo momacas in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Huan namehhuan onanquicajque ic oniquihto quen nehhua ahmo niCristo, tlahmo onihuala tetlamatiyan Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ipan se mosihuautilistli in aquin quipiyas in ichpochtli, yehhua in mosihuautiyani, huan in itetlatlautil tequin paquis ica nochin tlen panos. Nehhua quen itetlatlautil in mosihuautiyani, huan tequin nipaqui axan. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yehhuatzin mopiya tlen ilohuas ocachi quen hueyixtoc huan nehhua nicpiya tlen nimochihuas ocachi ahmo hueyi noquisca. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","In aquin ohualtemoloc den neluicac, Yehhuatzin ocachi hueyi quen nochin tlacatl. In aquin den tlalticpactli quipiya in itlanehnehuilis den tlalticpac, huan tlahtohua ica in tlen ca ihtech in tlalticpactli. Huan in aquin ohualtemoloc den neluicac ocachi hueyi quen nochin. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Huan Yehhuatzin tlanonotzalo ica tlen motztoc huan tlen mocactoc ompa neluicac, huan san quesqui oncan aquin quineltocahque in tlen mihtohua. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Huan tla seya quineltoca in tlen mihtohua, ijcon quinextiya quen Dios mihtohua in tlen melahuac. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tleca in aquin Dios otehualtitlanque, Yehhuatzin tlanonotzalo quen otenextililoc in Dios, huan Dios motemaca nochin in Itiotonaltzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","In Totahtzin Dios motlasohtla Teconetzin, huan quimomaquilihtoc temajco nochin tlen oncan. ");
INSERT INTO ncjNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","In aquin teneltoca in Iconetzin Dios quipiya in nemilistli nochipa, huan in aquin ahmo tetlacamatis in Iconetzin Dios ahmo ahsis ipan in nemilistli nochipa, tlahmo quiselis in chicahuac tlapanolistli den Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","In fariseos oquiahsicamatque ica in Jesús quen omopiyaya miyac in tecuitlapanuiyanimen huan oquincuatequilohuaya ocachi quen in Juan. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Masque ahmo Yehhuatzin Jesús omocuatequilohuaya, tlahmo yehhuan in tetlamachticahuan oquincuatequiyayahque. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Huan ihcuac Jesús ijcon omomat, oquixohuac den Judea ic mocuepalos Galilea. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ipan ohtli tlen ohuilohuac, omopix tlen tlanecuilanalos ic tlali Samaria. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Huan ijcon oahxihuac ipan se altepetl itlatilanal Samaria, itocahyan Sicar, inahuac in tlali tlen oquimacac Jacob in iconeu José. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ompa ocatca in ameli tlaltoctoc tlen quihtohuahque oquichcuac in Jacob. Quenin Jesús osiahuihuataya ic nehnemohua, oncan omotlaliloc inahuac in ameli. Huan yi cana chicuasin horahtiotlac. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ic inon se sihuatl den Samaria oahsito ipan in ameli ic quianas in atl, huan Jesús omoluic: ―Xinechmaca chihton moau. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Huan in teltamachticahuan oyahtoyahque ipan in altepetl quicohuahque tlen quicuasque. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Oncan in sihuatl samariahteca otenanquilic: ―Tehhua tijudeahteco, ¿huan quenin tinechtlahtlaniliya atl, huan nehhuatl nisamariahteca? Tleca in judeahtecos ahmo tlen quihtohuahque inca in samariahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Oncan Jesús omonanquilic: ―Tla ticmatini in tlen Dios mitzmacalos, huan tla tinechixmatini aquin nehhua, in aquin mitztlahtlanilihtica atl, ic nele tehhua tinechtlahtlanilini nehhuatl, huan nehhuatl nimitzmacani in atl tlen quitemaca nemilistli. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","In sihuatl oteiluic: ―Tlacatzintli, niyan ahmo mopiya tlen ic moquixtis atl, huan in ameli tequin huehcatla. ¿Quenin cuali nechmacasque in atl tlen quitemaca nemilistli? ");
INSERT INTO ncjNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","In tochichicacoltzin Jacob otechcahuilihteu inin ameli canin yehhua huan ipiluan oatliyayahque, huan canin oquinatliltiyaya iyolcahuan. Tel, ¿ocachi tihueyixtoc quen yehhua? ");
INSERT INTO ncjNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús omonanquilic: ―Nochten aquin quionihque inin atl, oc sepa amiquisque. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Huan in aquin quionis in atl tlen nehhua nicmacas, ayacmo queman amiquis. Huan inon tlen nicmacas mochihua quen se ameli iihtectla in aquin quionis huan quimacas nemilistli nochipa. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Oncan in sihuatl oteiluic: ―Tlacatzintli, manechmacalo inon atl, huan ayacmo queman niamiquis, niyan ayacmo nicpiya tlen nihualas niquixtis in atl ihtech inin ameli. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús omoluic: ―Xiyau xicnotza motlacau, huan oncan xihualacan nican. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","In sihuatl otenanquilic: ―Ahmo nicpiya nonamic. Oncan Jesús omoluic: ―Inon melahuac in tlen otiquihto, ahmo ticpiya monamic, ");
INSERT INTO ncjNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","tleca yotiquimpapatlac macuili tlacamen, huan in aquin ticpiya axan ahmo monamic. Ic inin oticyequihto in tlen nele. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ic oquicac inin, in sihuatl oteiluic: ―Tlacatzintli, nicnehnehuiliya tehhuatzin se tlayolchicauqui. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","In tochichicacoluan samariahtecos otemahuestilihque in Dios nican ipan inin tepetl, huan namehhuan nanjudeahtecos nanquihtohuahque mach yeh in Jerusalén canin titemahuestilisquiyanihque. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús omonanquilic: ―Sihuatl, tla xinechneltoca, tleca ompahuitz tonali queman nantemahuestilisque in Totecohtzin Dios huan ayacmo tlen nanquipiyasque nanyasque Jerusalén niyan ipan inin tepetl. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Namehhuan in samariahtecos ahmo nanteixmatihque in aquin nantemahuestiliyahque, huan tehhuanten tijudeahtecos queme. Tleca in Dios oquitlapehpeniloc seya inca in judeahtecos ic mochihuas in Temaquixticahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Huan hualahsi in tonali huan nele yohualahsic, queman aquin nele temahuestilisque in Tohueyitahtzin nele quipiyasque tlen quichihuasque ipan inyolo. In Tohueyitahtzin monequi ijcon maquichihuacan in aquin temahuestilisque. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios Yehhuatzin nohuiyan ilohuac masque ahhuel teitahque, huan yehhuan aquin quinequihque temahuestilisque nele quipiyahque tlen quichihuasque ipan inyolo melahuac. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","In sihuatl oteiluic: ―Nehhuatl nicmati hualuilohuas in Mesías, aquin quitocahhuiyahque in Cristo, huan ihcuac hualuilohuas Yehhuatzin, techyecnonotzalos quen titemahuestilisquiyanihque. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús omoluic: ―Inon nehhuatl in Cristo, in aquin ihuan timonohnotztica. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ic inon oahsitohque in tetlamachticahuan huan omoistlacohque quen in Jesús monohnotzalotica ihuan se sihuatl. Huan niyan aquin ahmo omoixcohyanui tetlahtlanis tlen oquinequiyaya, noso tlen ica ihuan omonohnotzaloticatca. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Oncan in sihuatl oquicauteu in itzotzocol huan oya ipan in altepetl, canin oquiniluito in tlacamen: ");
INSERT INTO ncjNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Xihualacan xiquitacan se tlacatl aquin onechiluic nochin tlen nicchiutoc. Cox, ¿ahmo yehhua yes in Cristo? ");
INSERT INTO ncjNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Oncan oquisque den altepetl huan oyahque canin ilohuac in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Huan in tetlamachticahuan otetlatlautiticatcahque in Jesús, huan oteiluiyayahque: ―Tlamachtiyani, matlacualo. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Huan Yehhuatzin omoluihque: ―Nehhuatl nicpiya tlen nicuas, in tlen namehhuan ahmo nanquimatihque. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Oncan in tetlamachticahuan opeuque motlahtlaniyahque ic yehhuan: ―Cox, ¿yes aquin cana yotehualiquili tlen ic tlacualos? ");
INSERT INTO ncjNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Huan Jesús omoluihque: ―Yeh in quen notlacual ic nicchihuas in tlen monequi in aquin onechualtitlanque, huan ijcon nictlamis in tequitl tlen onechmacaloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Namehhuan nanquihtohuahque: “Oc polihui nahue metztli in pixquistli.” Huan namechiluiya: Xiquitacan inin tlacamen tlen ompa huitzen. Ayacmo nanquipiyahque tlen nanquichixticaten ic nechneltocasque in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","In aquin tequiti ica in pixquistli quitlanis itlaxtlahuil, huan ijcon noyojqui in aquin quinneltoctis ica nehhuatl quiahsis in nemilistli nochipa. Huan ic inon in aquin quinnotzas in itlahtoltzin Dios huan in aquin quintlaneltoctis ica nehhuatl tequin paquihque san secnin. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ic nele quen quihtohuahque: “In aquin tlamilohua, yeh in seya, huan in aquin pixca, oc seya yehhua.” ");
INSERT INTO ncjNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nehhuatl onamechtitlan ic nanquintlaneltoctisque ica nehhuatl, huan yoquinnonotzque in oc sequin. Ijcon quen oc sequinten oquinnonotzque, namehhuan san nanquintlaneltoctisque. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Miyacten tlacamen de inon altepetl Sicar, den tlali Samaria, oteneltocaque ica in Jesús ica tlen oquincaquilti inon sihuatl, quen oquiniluic: “Onechiluic nochin tlen nicchiutoc.” ");
INSERT INTO ncjNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ijcon, queman in samariahtecos oteitaque, otetlatlautihque mamocahualo inuan. Jesús omocahualoc ompa ome tonali. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Huan miyacten oteneltocaque ic oquicajque tlen omihtohuaya. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Oncan oquiluihque in sihuatl: ―Axan ticneltocahque ahmo san tlen tehhua otitechiluic, tlahmo noyojqui tehhuan yotitecajque tlen otechnonotzaloc Yehhuatzin, huan ticmatihque ic nele Yehhuatzin in Cristo, in Temaquixticahtzin den tlalticpac. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ome tonali satepa, in Jesús oquixohuac den Samaria huan ohuilohuac ipan in tlali den Galilea. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Quenin omihto in Jesús, se tlamachtiyani ahmo quihuelitahque ipan ialtepeu. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ihcuac oahxihuac Galilea, in chanimen den ompa oteselihque ica paquilistli, tleca noyojqui ompa ocahcatca ipan in altepetl Jerusalén ica in pascuahiluitl, huan oquitaque nochin tlen omochiu ihtech inon iluitl. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Oncan Jesús omocuepaloc in altepetl Caná den tlali Galilea, canin omopatlac atl in vinohtlayili. Huan ipan in altepetl Capernaum ocatca se hueyi tequihua den hueyixtoc oquipiya se iconeu cocoxqui. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Queman in tequihua oquimat quen in Jesús omocuepaloc den tlali Judea huan oahxihuac ipan in tlali Galilea, oya teita. Huan otetlatlautihtaya mahuilohua ichan mamopahtili iconeu, tleca oyaya miqui. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Oncan Jesús omoluic: ―Namehhuanten ahmo nanquineltocasque in tlahmo nanquitasque tlachiuten mahuestic. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Huan inon tequihua oteiluic: ―Notecohtzin, tla tiyacan, ic oc ayamo miqui in noconeu. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Oncan Jesús omoluic: ―Ximocuepa mochan; moconeu yopahtic. In tlacatl oteneltocac tlen omoluic in Jesús, huan oya. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Queman yiahsitiu ichan, in itlaquehualuan oyahque quinamiquihque huan oquiluihque: ―In moconeu yopahtic. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Oncan oquintlahtlani cana tlen horas opeu mohuelmati in iconeu, huan oquiluihque: ―Yiyalua cana ic otlapoyauticatca, oquis in icocolis. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","In tetata omomacac cuenta cana inon horas quen Jesús omoluic: “Moconeu yopahtic”; huan yehhua huan ichanihcahuan oteneltocaque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Inin tlen Jesús omochiu ic oupa in tlachiutli mahuestic queman omocuepaloc den Judea ipan tlali Galilea. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Satepa den inin in Jesús omocuepaloc Jerusalén canin in judeahtecos oquitlaolichtiyayahque se iluitl. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ipan inon altepetl, inahuac in puerta den calnelohten, oncan se tanque tlen quitocahhuiyahque Betesda ica in tlahtoli hebreo, tlen quipiya macuili icalten. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ompa ohuehhuetztoyahque miyacten cocoxcamen san tlalpa: sequin ixpatzacten, sequin xonecuilten, huan oc sequin ica in coupitzahuistli. Ompa omochixticatcahque queman molinis in atl. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tleca san quequemanian se ángel ohualtemohuaya caninca in atl huan oquioliniyaya, huan in aquin achto ocalac ipan in atl satepa ic moliniya, inon yipahti ican icocolis tlen oquipiyaya. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ocatca ompa se tlacatl mach yoquichiu sempohuali huan caxtoli huan yiyi xihuitl ic mococohua. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Queman Jesús omotac quen huetztoc, huan omomacaloc cuenta quen yihuehcau ijconon, oncan omotlahtlani: ―¿Ticnequi tipahtis? ");
INSERT INTO ncjNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","In cocoxqui otenanquilic: ―Queme, tlacatzintli, huan ahmo nicpiya aquin nechcalaquis ihtech in atl queman moliniya. Queman nicnequi nicalaquis, oc seya achto calaqui. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús omoluic: ―Ximehua. Xicololo mopehpech, huan xiyau. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ihcuac omihto inon, niman inon tlacatl opahtic, huan oquiololo in ipehpech huan opeu nehnemi. Huan inon tonali yeh den nesehuilistli. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","In tequihuahten den judeahtecos oquiluihque in aquin opahtic: ―Axan tonali den nesehuilistli. Ahhuel ticmamas mopehpech. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","In tlacatl oquinnanquilic: ―In aquin onechpahti, onechiluic: “Xicololo mopehpech huan xiyau.” ");
INSERT INTO ncjNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Oncan oquitlahtlanihque: ―¿Aquinon omitziluic: “Xicololo mopehpech huan xiyau”? ");
INSERT INTO ncjNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Huan in tlacatl ahmo oteixmatiyaya aquinon oquipahtiloc, tleca in Jesús opolihuihuac canin ocahcatca in miyacatlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Satepa in Jesús oquinamiquiloc ipan in tiopantli, huan omoluic: ―Xiquita, axan yotipahtic. Ayacmo tlen xicchihua in ahmo cuali, tlahmo ocachi titlapanos. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Oncan in tlacatl oya quinnonotza in tequihuahten den judeahtecos quen mach Yehhuatzin in Jesús omopahti. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yeh in ica inon tequihuahten otepihpiyayayahque in Jesús. Oquinequiyayahque temictisque, tleca otlapahtilohuaya ipan in tonali den nesehuilistli. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Huan Jesús omoluihque: ―Nohueyitahtzin oc tequitihua, huan nehhua noyojqui nitequiti. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ic inon in tequihuahten den judeahtecos ocachi ocualanque huan oquinequiyayahque temictisque, ahmo san ica tlen omochiu ipan in tonali den nesehuilistli, tlahmo no ijcon omochihualohuaya quen in Dios, ic mihtohua Dios Yehhuatzin in Tehueyitahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Oncan Jesús omoluihque: ―Ic nele namechiluiya, nehhuatl aquin in Iconetzin Dios ahhuel nicchihuas tlen neh nicnequi. Cuali nicchihua san yeh in tlen niquita mochihua in Notahtzin. Nochin tlen mochihua in Nohueyitahtzin, noyojqui inon nicchihua nehhuatl aquin in Iconetzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tleca in Notahtzin nechtlasohtlalo nehhuatl aquin Iconetzin huan nechnextililo nochin tlen mochihua. Huan nechchihuililos oc sequin ocachi mahuestic tlachiuten ica tlen tequin nanmoistlacohtiyesque. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tleca ijcon quen in Nohueyitahtzin moihxitiyahque in mijcamen huan momacahque nemilistli, ijcon nehhuatl aquin Iconetzin no niquinmacas nemilistli in aquin nicnequi nicmacas. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Huan in Nohueyitahtzin ahmo moixcomaca niyan aquin, tlahmo nechmacatoque nochin in tequihuahyotl ic nitlixcomacas. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Huan ic inon, nochten manechmahuestilican nehhuatl aquin in Iconetzin Dios ijcon quen temahuestiliyahque in Nohueyitahtzin. Aquin ahmo nechmahuestiliya, noyojqui ahmo temahuestiliya Nohueyitahtzin aquin onechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Ic nele namechiluiya, in aquin quicaqui in tlen niquihtohua, huan quineltoca ica Yehhuatzin aquin onechualtitlaniloc, quipiya in nemilistli nochipa. Huan ahmo motlahtlacoltitos, tleca yipanotoc den miquilistli huan yocahsic in nemilistli. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ic nele in tlen namechiluiya. Ompahuitz in tonali queman panos quen namechiluihtiu, huan yohualahsic. In tlacamen aquin axan nenticaten, yehhuan quen mijcamen. Huan quen nehhuatl Iconetzin Dios, ihcuac nechcaquisque huan quineltocasque notlahtol, quinmacasque in yancuic nemilistli. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","San Yehhuatzin in Tohueyitahtzin mopiya chicahuilistli ic quinmacalos in yancuic nemilistli in tlacamen. Huan ijcon noyojqui onechmacalotoc nehhuatl aquin in Iconetzin in chicahuilistli ic niquinmacas in yancuic nemilistli. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Huan nechmacatoque tequihuahyotl ic nitlixcomacas ica intlahtlacol in tlacamen, tleca nehhuatl in Tetiachicau ica nochin tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ahmo ximotetzahuican ica inin, tleca ahsiquiu in tonali queman in mijcamen nochten quicaquisque notlahtol. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Huan panquisasque den tlaltecohtli. In aquin oquichiuque tlen cuali, ihsasque huan quipiyasque in yancuic nemilistli, huan in aquin oquichiuque in ahmo cuali ihsasque ic quintlahtlacoltisque. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Nehhuatl ahhuel nicchihua niyan tlen san noixcohyan. Nehhua niquinixcomaca quen nechtequiutiyahque huan tla san noixcohyan, ahhuel. Ahmo nicchihua tlen nehhua nicnequi, tlahmo tlen monequi in Nohueyitahtzin aquin onechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","In tla san nehhuatl onamechiluiyaya aquin nehhuatl, ahmo nannechneltocasquiyanihque. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Huan oncan in oc seya aquin noca tlahtohua huan nicmati yehhua noca tlahtohua ica in tlen melahuac. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Namehhuanten onantlatequiutihque maquitlahtlanican in Juan tla cana yehhuatl in Cristo, huan oquinnanquilic nele melahuac. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Masque ahmo huelica noca tlahtos niyan aquin, namechilnamiqui ica in tlen oquihto in Juan ica nehhuatl huan ic inon namehhuan cuali nanmaquisasque tla nanquineltocasque. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan ocatca quen se tlanextli tlen xotla huan tlanextiya, huan tlen quimpacmaca miyacten. Ijcon namehhuan onampactoyahque ica tlen omechnonotz san quesqui tonali. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","In tlachiuten mahuestic tlen nehhuatl nicchihua monextiya nele onechualtitlaniloc in Dios. Huan inin tlachiuten ica tlen onechtequiutilo Yehhuatzin, yehhuan ocachi tlachipajque ica nehhuatl quen itlahtol in Juan. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Noyojqui in Tohueyitahtzin aquin onechualtitlaniloc momatiltiyahque quen nehhuatl tetlatitlanil huan namehhuan ahyic nantetlahtolcactoque huan niyan ahmo nanteitztoque. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Huan ahmo nanquichihuahque cuenta ica itlahtoltzin tleca ahmo nanquineltocahque ica nehhuatl aquin in Tohueyitahtzin onechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Namehhuan molui nanmoyehyelcamachtiyahque ipan in Tlahcuilolamamen tleca onanquimatiyayahque ompa nanquiahsisque in nemilistli nochipa, huan nele inon Tlahcuilolamamen tlahtohua ica nehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Huan namehhuan ahmo nanquinequihque nannechneltocasque ic nanquipiyasque inon nemilistli. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Nehhua ahmo nicnequi nechmahuestilican in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Huan namechixyolohmati huan nicmati ahmo nantenequihque in Dios huan ic inon ahmo nannechmahuestiliyahque. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nehhua onihuala nitetlatitlanil in Nohueyitahtzin, huan namehhuan ahmo nanquineltocahque nele nitetlatitlanil. Huan tla hualas oc seya aquin san ica yeh itlanehnehuilis huan quihtos yehhua itetlatitlanil, inon huelis ocachi nanquineltocasque. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ahhuel nannechneltocahque tleca ahmo nanquitemohuahque quen nantepacmacasque Yehhuatzin aquin nele Dios. Tlahmo nanquitemohuahque san quen nanmopacmacasque se huan oc seya huan ijcon nanmomahuestilisque. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ahmo xiquihtocan cana namechteluis teixpa Nohueyitahtzin. In aquin mechteluis yeh in Moisés, in aquin namehhuan nanquitemachiyahque tla cana nanquitlacamatihque itlanahuatil. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","In tla namehhuan nanquineltocanihque in tlen oquihto in Moisés, noyojqui nannechneltocanihque nehhua, tleca in Moisés otlahcuilo ica nehhua. ");
INSERT INTO ncjNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","In tlahmo nanquineltocahque in tlen yehhua oquihcuilo, ¿quenin tel nanquineltocasque in tlen namechiluiya? ");
INSERT INTO ncjNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Satepa de inon, Jesús omocholui in mar den Galilea tlen noyojqui itoca mar de Tiberias. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Miyacatlacatl otecuitlapanuihtayahque, tleca oquitaque in tlachiuten mahuestic tlen omochihuayaya, ic omopahtiyayahque in cocoxcamen. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Oncan Jesús otlehcoloc ipan se tepetl huan omotlaliloc ompa inuan in tetlamachticahuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Yohualahsitaya in pascuahiluitl den judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Queman Jesús oixahcocuiloc huan omotaqui miyacatlacatl tehualahsihque, oncan omoluic in Felipe: ―¿Quenin ticohuasque in tlacuali para nochin inin tlacamen? ");
INSERT INTO ncjNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Inon san ic omoluic, tleca momatisnequi tlenon quihtos in Felipe, tleca Yehhuatzin yomomauticatca quen mochihuas. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Oncan in Felipe otenanquilic: ―Itlaxtlahuil ome ciento itonal den tlacatl ahmo ahsis tla ticohuasque pantzin, mihtosquiyani chihtoton matiquinmacacan cada seya. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Oncan Andrés, oc se tetlamachticau Yehhuatzin huan icniu in Simón Pedro, yeh oteiluic: ");
INSERT INTO ncjNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Nicanca se telpocatl quipiya macuili pantzin den cebada huan ome michtoton. ¿Huan campa ahsis ica tequin miyacatlacatl? ");
INSERT INTO ncjNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Oncan Jesús omihto: ―Xiquiniluican nochten mamotlalican. Ocatca sahsacatla canin ocahcatca, huan omotlahtlalihque inon cana macuili mil tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Oncan Jesús omoan in pantzin ica teman, huan ihcuac omotlasohcamatiloc ica in Dios, oncan oquinmacaloc in tetlamachticahuan. Oncan oquinxehxeluihque nochten aquin oyehyehuaticatcahque. Noyojqui ijconon omochiu ica in michtoton. Omomacaque nochin tlen oquinequiyayahque. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Queman nochten yopachiuque, Jesús omoluihque in tetlamachticahuan: ―Xicpehpenacan in cohcotonque tlen omocau ic ahmo mamotlasohchihua niyan tlen. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Oquipehpenque in cohcotonque tlen omocau ica in macuili pantzin den cebada huan oquitemitihque mahtlactli huan ome canasta. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Oncan in tlacamen, ic oquitaque inon tlachiutli mahuestic in tlen omochiu Jesús, oquihtohque: ―Ic nele inin yeh in tlayolchicauqui tlen quipiya hualas ipan in tlalticpac. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Huan Jesús omonehnehuili quen oquinequiyayahque tehuicasque ica tlahueli ic techihuasque hueyixtoc. Ic inon oquincautehualoc huan otlehcoloc oc sepa ipan coutlahtli, mailohua tesel. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ihcuac yitlayohua, in tetlamachticahuan Jesús otemoque caninca in atl. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Huan otlehcohque ipan se barco huan opeuque quitlahcotequihque in atl ic ahsisque Capernaum. Yitlayohuatoc, huan Jesús ahmo omocuepalotoya. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Opeu yehyeca chicahuac, huan in atl omahcocuiyaya ic moxahcalotiu. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Huan queman yoyahtayahque cana nahue noso macuili kilómetro, oteitaque quen Jesús omopacholotaya inahuac in barco. Nehnemohuatiu iixco in atl, huan yehhuan tequin omomoutihque. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Huan Yehhuatzin omoluihque: ―¡Nehhuatl niJesús, ahmo ximomoutican! ");
INSERT INTO ncjNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Oncan yehhuan ica paquilistli oteselihque ipan in barco huan san ic chihton oahsique ipan in tlali canin oyahticatcahque. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Huan ic mostla in tlacamen aquin omocauque isentlapal in atl omomacaque cuenta quen in tetlamachticahuan oyahticatcahque ipan inon se barco tlen ocatca ompa, huan Jesús ahmo ohuilohuatoya inuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Huan san ic chihton, oc sequin barcos oahsitohque den altepetl Tiberias inahuac canin oquintlamacaque ican pantzin satepa ic omotlasohcamatiloc in Jesús ica in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ijconon, queman in tlacamen ayacmo oteahsique ompa in Jesús, niyan tetlamachticahuan, oncan otlehcohque ipan inon barcos huan oyahque hasta Capernaum tetemohtihue. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ic oahsique isentlapal in atl, oteahsique in Jesús huan otetlahtlanihque: ―Tlamachtiyani, ¿queman oahxihuaco nican? ");
INSERT INTO ncjNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Oncan Jesús omonanquilihque: ―Ic nele namechiluia, namehhuan nannechtemohuahque tleca onantlacuahque hasta onanyecpachiuque. Huan ahmo nannechtemohticaten tleca onanquinehnehuilihque tlen quihtosnequi in tlachiuten mahuestic tlen onicchiu. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ahmo xitequitican san ica in pantzin tlen tlami, tlahmo xictemocan in pantzin tlen mechmaca in nemilistli nochipa. Inin tlen nehhuatl aquin in Tetiachicau ica nochin tlacatl namechmacalos, tleca in Dios Tohueyitahtzin nechmacalotoc in techicahualis huan monextililotoc quen onechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Oncan otetlahtlanihque: ―¿Tlenon ticchihuasque ic titetlacamatisque in Dios? ");
INSERT INTO ncjNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Huan Jesús omonanquilihque: ―In tlen Dios monequi xicchihuacan, san xinechneltocacan ica nehhuatl in aquin Yehhuatzin nechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Oncan otetlahtlanihque: ―¿Tlen tlachiutli mahuestic technextilisque, ic ticneltocasque in tla mitzualtitlanilotoc? ¿Tlen technextilisque? ");
INSERT INTO ncjNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","In tochichicacoluan oquicuahque in maná ipan in acahualtlahtli ihcuac oquicuitlapanuihtinemiyayahque in Moisés, quen quihtohua ipan in Tlahcuilolamatl: “Oquintlamaca in pantzin den neluicac.” ");
INSERT INTO ncjNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Huan Jesús omonanquilihque: ―Ic nele namechiluiya, ahmo yehhua in Moisés aquin oquinmacac in pantzin den neluicac, tlahmo Nohueyitahtzin. Yehhuatzin in Nohueyitahtzin Dios in aquin tlamacalo noyojqui in tlamelajcan pantzin den neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tleca in tlamelajcan pantzin tlen Dios tlamacalo, Yehhuatzin in aquin ohualtemoloc den neluicac huan quinmacalo yancuic nemilistli in tlalticpac tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Oncan oteiluihque: ―Totecohtzin, matechmacalo inon pantzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Huan omoluihque in Jesús: ―Nehhuatl in pantzin tlen quitemaca yancuic nemilistli. Aquin mosetilis nohuan ahyic apismiquis, huan aquin nechneltoca, ahyic amiquis. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Huan yonamechiluic namehhuanten ahmo nannechneltocahque masque yinechitztoque. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nochin in aquin Nohueyitahtzin nechmacalo, huitz nechahsi, huan in aquin huitz nechahsi, nele nicselis. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Tleca nehhuatl ahmo onihuala den neluicac ic nicchihuas tlen san noixcohyan, tlahmo ic nicchihuas in tetlamatiyan den aquin onechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Huan tetlamatiyan Nohueyitahtzin aquin onechualtitlaniloc ahmo maniquimpolo niyan aquin de yehhuan aquin nechmacalotoc, tlahmo maniquinihxiti den mijcamen ipan in sayohpa tonali. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","In tetlamatiyan in aquin onechualtitlaniloc maquipiyacan nemilistli nochipa nochten aquin nechixmatihque quen nehhuatl in Iconetzin Dios huan nechneltocahque. Huan nehhua niquinihxitis ihcuac in sayohpa tonali. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ihcuac oquiniluiloc inon, in judeahtecos opeuque tetenahuahque in Jesús, tleca omihto: “Nehhuatl in pantzin tlen ohualtemoc den neluicac.” ");
INSERT INTO ncjNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Huan oquihtohque: ―¿Ahmo yehhua inin Jesús, in iconeu José? Tehhuanten tiquixmatihque in itata huan inana. ¿Quenin quihtohua mach ohualtemoc den neluicac? ");
INSERT INTO ncjNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Oncan Jesús omoluihque: ―Ayacmo xinechtenehuacan. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Niyan aquin cuali mosetilis nohuan, in tlahmo nechmatiltilos in Nohueyitahtzin aquin onechualtitlaniloc, huan nehhuatl niquihxitis den mijcamen ipan in sayohpa tonali. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ipan in Tlahcuilolamamen den tetlayolchicaucahuan ijquin tlahcuiloli: “Dios quinnextililos nochten.” Ijcon nochten aquin tecaquihque in Tohueyitahtzin, huan momachtiyahque ica Yehhuatzin, huitzen nechahsique. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Ahmo san cana aquin teitztoc in Tohueyitahtzin, tlahmo san Yehhuatzin aquin ohualuilohuac den Dios. Yehhuatzin teitztoque in Tohueyitahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ic nele namechiluiya, in aquin nechneltoca quipiya in nemilistli nochipa. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nehhuatl in pantzin tlen quitemaca yancuic nemilistli. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","In namochichicacoluan oquicuahque in maná ipan in acahualtlahtli, huan masque oquicuahque, yehhuan omijque. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nehhuatl nitlahtohtica ica in pantzin tlen hualtemohua den neluicac. In tla se tlacatl quicuas inon pantzin, ahmo miquis. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yi nehhuatl in pantzin tlen nele den neluicac, huan in aquin quicuas inin pantzin nochipa nemis. Huan in pantzin tlen niquinmacas, yeh in notlacayo. Niquinmacas notlacayo maquipiyacan yancuic nemilistli in tlalticpac tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Oncan in judeahtecos opeuque tlahtolchihuahque san ic yehhuan, moluiyahque: ―¿Quenin cuali techmacas itlacayo maticuacan? ");
INSERT INTO ncjNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús omoluihque: ―Ic nele namechiluiya, tla namehhuan ahmo nanquicuahque in notlacayo nehhuatl aquin Tetiachicau ica nochin tlacatl, huan tlahmo nanquionihque noyes, ahmo nanquipiyasque nemilistli. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","In aquin quicua notlacayo huan quioni noyes quipiyas in nemilistli nochipa, huan nehhuatl niquihxitis ipan in sayohpa tonali. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tleca in notlacayo tlamelajcan tlacuali, huan noyes tlamelajcan tlen apachihuihua. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","In aquin quicua notlacayo huan quioni noyes mosetilihtoc nohuan huan nehhua ihuan yehhua. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","In Tohueyitahtzin yolihuatoc onechualtitlaniloc huan neh ninemi tepampa. No ijcon, in aquin mosetilihtoc nohuan, yehhua nopampa nemis. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nitlahtohtica ica in pantzin tlen ohualtemoc den neluicac. Inin pantzin ahmo quen in maná tlen oquicuahque in namochichicacoluan, huan masque oquicuahque, yehhuan omijque. In aquin quicuas inin pantzin, nemis nochipa. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús omonextilihque inin tlatolten ipan in tiopantli den Capernaum. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ic oquicajque inin tlanextilistli, miyacten aquin otecuitlapanuiyayahque in Jesús oteiluihque: ―Inin tlen tiquihtohua tequin tequiyo ic ticselisque. ¿Aquin cuali quicaquis? ");
INSERT INTO ncjNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Oncan Jesús omoyolnehnehuili tlen oteteneuticatcahque ica Yehhuatzin, huan oquintlahtlaniloc. ―Tel, ¿mechtlahiltiya inin? ");
INSERT INTO ncjNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Tlen nanquinehnehuilisque tla nanquitasque nehhuatl aquin in Tetiachicau ica nochin tlacatl ic nitlehcos canin onicatca achto? ");
INSERT INTO ncjNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","In itonal in tlacatl yeh in tlen quinemiltiya huan itlacayo ahhuel nemi isel. Huan in tlahtoli tlen yonamechiluic, inon ahmo quihtosnequi nannechcuasquiyanihque tla cana mechahsisquiyani nemilistli ica notlacayo. In Itiotonaltzin quinmacalo in yancuic nemilistli yehhuan aquin quineltocahque notlahtol. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Huan oncaten sequin den namehhuanten aquin ahmo nechneltocahque. In Jesús omomatiyaya den achto yehhuan aquin ahmo oteneltocayayahque, huan aquin yau tetemactiya ic temictisque. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Huan omihto: ―Huan quen sequin de namehhuan ahmo nechneltocahque, ic inin onamechiluic quen niyan aquin cuali mosetilis nohuan in tlahmo nechmatiltilos in Tohueyitahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ihcuac inon otetlamicauque miyacten aquihque otecuitlapanuiyayahque in Jesús, huan ayacmo onemiyayahque tehuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Oncan Jesús omotlahtlanihque in mahtlactli huan ome tetlamachticahuan: ―Tel, ¿namehhuan noyojqui nanquinequihque nannechcahuasque? ");
INSERT INTO ncjNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Huan Simón Pedro otenanquilic: ―Notecohtzin, ¿aquin cuali ihuan tiyasque? Tetlahtoltzin yeh in tlahtoli den nemilistli nochipa. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Tehhuanten yititeneltocatoque, huan ticmatihque quen Tehhuatzin in Cristo, in Iconetzin Dios yolihuatoc. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús omonanquilihque: ―Namechtlapehpenihto namehhuan mahtlactli huan ome. Huan masque ijcon ca, se den namehhuan quichihuas itlamatiyan in ahmo cuali tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ic omihto inon, Jesús otlahtolohuaya ica in Judas Iscariote, iconeu in Simón. Tleca in Judas oyaya teichtacatemactiya, masque ocatca seya den inon mahtlactli huan ome tetlamachticahuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Satepa den inon in Jesús onemohuayaya ipan in tlali Galilea. Ahmo omonequiya ilohuas Judea, tleca ompa in tequihuahmen den judeahtecos oquinequiyayahque temictisque. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Huan ohualahsitaya in iluitl queman mocahuahque ipan xahcalten. Yeh seya den iniluiu in judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","In tecnihuan oteiluihque: ―Ahmo ximocahua nican. Xiyau Judea, maquitacan noyojqui in motecuitlapanuicahuan aquin ompacaten ica tlen ticchihua. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","In tla seya quinequi quinextilis ica tlen quichiutica, ahmo tlen quichihua san ichtaca. Tla yiticchihuas in tlachiuten mahuestic, xicchihua miyacaixpa. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tleca niyan tecnihuan ahmo oteneltocayayahque. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Oncan Jesús omoluihque: ―Ayamo ahsi in notonal ic niquinmonextilis aquin nehhhuatl. Ica namehhuan san queman nanquinequihque, cuali nanyasque. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Namehhuan san tlalticpac tlacamen huan ic inon ahhuel mechcocoliyahque in oc sequin tlalticpac tlacamen. Nechcocoliyahque tleca niquintlalnamictiya in tlen quichihuahque ahmo cuali. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Xiyacan namehhuan ica in iluitl; nehhua ahmo niyas, tleca ayamo ahsi in tonali ic niyas. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Huan satepa ic omoluihque inon, omocahualoc ipan in tlali Galilea. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Satepa ihcuac yiyahtoque in tecnihuan, in Jesús noyojqui ohuilohuac ica in iluitl, masque ahmo temiyacaixpa, tlahmo san ichtaca. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","In tequihuahmen den judeahtecos otetemohuayahque ipan in iluitl, huan oquihtohuayahque: ―¿Caninon yes inon tlacatl? ");
INSERT INTO ncjNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Huan in tlacamen molui otetenehuayayahque. Sequin omoluiyayahque se huan oc seya: “Inon se cuali tlacatl”, huan oc sequinten oquihtohuayahque: “Ahmo cuali, quincahcayahua in tlacamen.” ");
INSERT INTO ncjNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Huan niyan aquin oteyequiluiya inmiyacaixpa ica Yehhuatzin, tleca omomoutihque ica in tequihuahten den judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","In iluitl yotlahcotixtaya queman Jesús ocalacohuac ipan in tiopantli, huan opehualoc tlamachtilo. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Huan in judeahtecos oteistlacoticatcahque huan oquihtohuayahque: ―¿Quenin quimati technextiliya nochin inon huan niyan ahmo momachtihtoc? ");
INSERT INTO ncjNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Huan Jesús omonanquilihque: ―Ahmo nitlanextiliya san ica notlanehnehuilis, tlahmo nitlanextiliya in tlen onechiluihque Yehhuatzin aquin onechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","In tla cana aquin motemaca quichihuas tetlamatiyan Dios, quistlacaahsis tla notlanextilis nele huitz den Dios noso tla nitlahtohua san noixcohyan. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","In aquin tlahtohua san iixcohyan, quitemohua ihueyilis, huan nehhuatl in aquin nictemo quen tehueyilistzin in aquin onechualtitlaniloc. Nehhuatl niquihtohua in tlen nele, huan ahmo nitlacahcayauqui. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Tlen, ahmo melahuac yeh in Moisés omechmacac in tlanahuatili? Huan masque ijcon melahuac, niyan aquin den namehhuan ahmo nanquitlacamatihque inon tlanahuatili. ¿Tleca nanquinequihque nannechmictisque? ");
INSERT INTO ncjNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","In tlacamen otenanquilihque: ―Ticpiya in ahmo cuali yehyecatl. ¿Aquinon quinequi mitzmictis? ");
INSERT INTO ncjNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús omoluihque: ―San se tlachiutli onicchiu ipan in tonali den nesehuilistli, huan namochtehque nanmotetzahuiyahque. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","In Moisés omechiluihtiu xictlalican inon ixmatcayotl den judeahteco ipan in telpocahuan maquinuelitalo in Dios. Nanquipiyahque tlen nanquichihuasque ihcuac quipiyahque chicueyi tonali in cocone, masque yeh in tonali den nesehuilistli. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Axan cuali, ic quihuelitalos in Dios, namehhuan nanquitlalisque ipan in telpocaconetl inon ixmatcayotl, masque ipan in tonali den nesehuilistli. Huan inon quihtosnequi nantequitihque ipan in tonali den nesehuilistli. ¿Huan axan, tleca nannechcocoliyahque tla onitequit ic onicpahti se tlacatl cocoxqui ipan in tonali den nesehuilistli? ");
INSERT INTO ncjNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ahmo xinechixcomacan san ica tlen onicchiu. Queman nannechixcomacasque, nanquinehnehuilisquiyanihque tlen quihtosnequi in tlen nicchihua. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Oncan sequin aquin ochantiyayahque in Jerusalén opeuque motlahtlaniyahque: ―Tel, ¿ahmo yehhuatl inin aquin quitemohtinemihque ic quimictisque? ");
INSERT INTO ncjNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pos ompa tlahtohtica inepanco in miyacatlacatl, huan ahmo tlen quiluiyahque. Cox, ¿ic nele quineltocahque in tequihuahten ica inin tlacatl cana yehhuatl in Cristo? ");
INSERT INTO ncjNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Tleca tehhuanten ticmatihque de canin huitz yehhua, huan queman hualas in Cristo, ahmo aquin quimatis de canin huitz. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesús otlamachtilotoya ipan in tiopantli, huan ic omocac inon, otlahtoloc chicahuac: ―Nanquinehnehuilihque nannechixmatihque huan nanquinehnehuilihque nanquimatihque de canin onihuala. Huan ahmo nele nanquimatihque. Ahmo onihuala san noixcohyan, tlahmo onihuala nitlatitlanil Yehhuatzin aquin tlamelajcan huan namehhuan ahmo nanteixmautoque. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nehhua niteixmati tleca onihuala de canin ilohuac Yehhuatzin, huan Yehhuatzin onechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Oncan oquinequiyayahque tehuicasque tetzacuasque, huan niyan aquin ahhuel otequitzqui, tleca ayamo oahsiyaya in tonali ic micohuas. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Huan miyacten oquineltocaque in Jesús Yehhuatzin in Cristo, huan oquihtohque: ―Inin tlacatl quinchiutoc miyac tlachiuten mahuestic quen quihtohuahque mochihuas in Cristo ihcuac hualuilohuas huan inon quihtosnequi nele yehhuatl in Cristo. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","In fariseos oquicajque in tlen oquihtohuayahque in tlacamen ica in Jesús, huan yehhuan huan in achtohque den tiopixcamen oquintitlanque topilihten den tiopan matehuicacan matetzacuacan. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Oncan Jesús omihto: ―Oncan niyes namohuan sa quesqui tonali, huan satepa nimocuepas tehuan aquin onechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Namehhuan nannechtemosque huan ahmo nannechahsisque, tleca ahhuel nanyasque canin nehhua niyes. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Oncan in judeahtecos opeuque motlahtlaniyahque san ic yehhuan: ―¿Canin yas inin tlacatl mach ahhuel ticahsisque tehhuanten? Cox, ¿yas mochantis inuan in judeahtecos aquihque chantihtoque ihuan in griegohtecos, ic quinmachtis in griegohtecos? ");
INSERT INTO ncjNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Tlen quihtosnequi inon tlen otechiluic: “Nannechtemosque huan ahmo nannechahsisque, tleca ahhuel nanahsisque canin niyes”? ");
INSERT INTO ncjNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ic tlantiu in iluitl ocachi oquihueyichiuque. Ipan inon tonali Jesús omoquetzaloc huan omihto ica chicahuac tetlahtol: ―In tla aquin amiqui, mahualau ica nehhuatl huan maatli. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Quenin quihtohua in Tlahcuilolamatl, in aquin nechneltocas, ipan iyolo panquisas quen ameli den atl tlen quitemaca yancuic nemilistli. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ic inon Jesús omihtosnequiyaya quen in aquin teneltocasque, yehhuan teselisque in Itiotonaltzin Dios. Ayamo ohualahtoya in Itiotonaltzin tleca in Jesús ayamo mocuepalo neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ihcuac oquicajque inon, sequin den inon miyacatlacatl oquihtohque: ―Ic nele inin tlacatl yehhua in tlayolchicauqui tlen hualasquiyani. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Huan oc sequinten oquihtohuayahque: ―Inin yehhuatl in Cristo. Huan oc sequinten oquihtohque: ―Huan ahmo quixohuani den Galilea in Cristo. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","In Itlahcuiloltzin quihtohua quen in Cristo quipiya tlen hualuilohuas quen ichichicaixuiu in hueyixtoc David, huan tealtepeu yeh in Belén, yiyehhua in altepetl canin ochantiyaya in David. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ijconon in tlacamen omoxehxelohque tepampa in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Sequin oquinequiyayahque tehuicasque tetzacuasque, huan niyan aquin otequitzqui. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","In topilihten den tiopan omocuepque canin ocahcatca in fariseos huan in achtohque den tiopixcamen, huan inohque oquintlahtlanihque: ―¿Tleca ahmo onanquihualicaque inon tlacatl? ");
INSERT INTO ncjNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Huan in topilihten oquinnanquilihque: ―¡Niyan aquin ahyic tlahtotoc ijconon mahuestic quen inon tlacatl tlahtohua! ");
INSERT INTO ncjNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Oncan in fariseos oquiniluihque: ―¿Tlen, noyojqui nanmocautoque mamechcahcayahua? ");
INSERT INTO ncjNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¡Xiquitacan tla quineltocatoc ica yehhua seya den tequihuahmen noso den tehhuan fariseos! ");
INSERT INTO ncjNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Huan inin tlacamen aquin quineltocahque ica yehhua ahmo quimatihque in tlanahuatili, huan yehhuan tlahtlacolyohque. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo, in aquin ohuiya tlayohua teita in Jesús, inon opoutoya inuan in fariseos, huan oquiniluic: ");
INSERT INTO ncjNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―In totlanahuatil quihtohua ahhuel tictlapanoltisque se tlacatl san tlaluis. Tlahmo ticpiyahque tlen ticaquisque achto quen mopalehuis ic ticmatisque tla quichiutoc in ahmo cuali. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Oncan oquinanquilihque: ―¿Tlen, tehhuatl noyojqui den Galilea? San yehhuan aquin pohuihque den Galilea quineltocahque ica yehhua. Ximomachti ipan in tlahcuiloli huan ticmatis niyan se tlayolchicauqui quisas den Galilea. ");
INSERT INTO ncjNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Oncan se seya oyahque inchan. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Huan in Jesús ohuilohuac ipan in tepetl Olivoscoutla. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Huan ic mostla sancuel, oc sepa ohuilohuac in tiopan. Nochin tlacamen omopachohque tenahuac, huan Yehhuatzin omotlaliloc huan opehualoc momachtiyahque. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Oncan in tlamachtiyanimen den tlanahuatili huan in fariseos otehualiquilihque se sihuatl namicyo aquin ocahsique tlacaahuiltihtoc. Oquitlalihque tlanepantla den tlacamen aquin ompa ocatcahque. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Huan oteiluihque in Jesús: ―Tlamachtiyani, inin sihuatl oticahsitohque tlacaahuiltihtoc. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","In tlanahuatili den Moisés techtequiutiya maticmictican ica tetl in aquin ijcon quichihua. ¿Huan tehhuatl, tlen tiquihtohua? ");
INSERT INTO ncjNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Otetlahtlanihque inon ic teahsicamati in tlahtoli tlen quixnamiquis itlanahuatil Moisés, huan ijconon cuali teteluisque. Oncan Jesús omocuelpacholoc huan opehualoc tlahcuilolo tlalpa ica temahpil. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Huan quenin san tetlahtlanihticatcahque, oncan omotelquetzaloc huan omoluihque: ―In aquin den namehhuan ahmo nanquipiyahque tlahtlacoli, maye yeh in achto aquin quitemacas in sihuatl. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Huan oc sepa omocuelpacholoc huan ocachi otlahcuiloloc ipan tlali. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Huan yehhuanten, ic oquicajque inon, tequin omoyolmoutihque quen ijcon oquinixpinautilo, huan opeuque ichtacacholohuahque se sehse. Otecauteuque achto in aquin ocachi tectli. Huan ihcuac nochten otecauteuque, in Jesús omocahualoc tesel ihuan in sihuatl. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Oncan Jesús omoixahcocuiloc, huan ahmo aquin omotac tlahmo san yeh in sihuatl. Huan ic inon omoluic: ―Sihuatl, ¿canin caten in aquihque mitzteluiyahque? ¿Ahmo aquin omitztlahtlacoltihque? ");
INSERT INTO ncjNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Yehhua otenanquilic: ―Notecohtzin, niyan aquin nechtlahtlacoltihtoc. Oncan Jesús omoluic: ―Niyan nehhuatl ahmo nimitztlahtlacoltihtoc. Axan xiyau huan ayacmo xicchihua inon tlahtlacoli. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús omonotzque oc sepa in tlacamen, huan omoluihque: ―Nehhua in aquin niquinyolnehnehuiltiya in tlalticpac tlacamen. Aquin nechcuitlapanuis quipiyas in yancuic nemilistli huan ayacmo nemis ipan in ahmo cuali. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Oncan in fariseos oteiluihque: ―Tehhua san tiquihtohtica san moixcohyan, huan inon ahmo quipiya tlachipahualistli. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","In Jesús omonanquilihque: ―Notlachipahualis quipiya chicahualistli masque san niquihtohtica san noixcohyan. Tleca nehhuatl nicmati den canin onihuala huan canin niyas, huan namehhuanten ahmo nanquimatihque den canin nihuitz huan canin niyas. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Namehhuan nantlahtlacoltiyahque san quen tlalticpac tlacamen. Nehhua ahmo aquin nictlahtlacoltiya. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Huan tla nitlixcomacas, inon tlamelajcan, tleca ahmo nitlixcomaca san nehhua, tlahmo tehuan in Nohueyitahtzin aquin onechualtitlaniloc, tehhuan titlixcomacasque. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ipan in namotlanahuatil ca tlahcuiloli queman ome tlachipaucamen quihtohuahque san parejo, inon mamoneltocacan. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Cuali tel, nehhuatl nitlachipauqui noixcohyan huan noca noyojqui tlachipahualo in Nohueyitahtzin aquin onechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Oncan otetlahtlanihque: ―¿Canin ilohuac Tetahtzin? In Jesús omonanquilihque: ―Namehhuan ahmo nannechixmatihque, niyan in Nohueyitahtzin ahmo nanteixmatihque. In tla nannechixmatinihque nehhuatl, noyojqui nanteixmatinihque in Nohueyitahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús omihto inin tlahtoli ihcuac otlamachtiloticatca ipan in tiopantli. Huan oihcatiloticatca canin ocatca in tlen ihtech quitlaliyahque in tomin tlen oquitetlocoliyahque. Huan niyan aquin ahmo otequitzqui tetzacuas, tleca ayamo oahsic in tonali ic micohuas. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús oc sepa omoluihque: ―Nehhuatl niyau, huan namehhuan nannechtemosque, huan ahmo nannechahsisque. Huan canin nehhuatl niyau, namehhuan ahhuel nanyasque. Huan nanmiquisque huan ahyic namechixtlapacholuis namotlahtlacol. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Oncan in judeahtecos oquihtoque: ―Tlen cox, ¿momictis, huan yeh in ica quihtohua ahhuel tiyasque canin yau? ");
INSERT INTO ncjNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Oncan Jesús omoluihque: ―Namehhuan nanquipiyahque namotlanehnehuilis nican tlalticpac, huan nehhuatl nicpiya notlanehnehuilis den neluicac. Namehhuan san tlalticpac tlacamen huan nehhuatl ahmo. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yeh in ica namechiluiya nanmiquisque huan ahmo namechixtlapacholuis namotlahtlacol, tleca in tlahmo nanquineltocahque in tlen namechiluihtoc ica nehhuatl, nanmiquisque, huan ahmo namechixtlapacholuis namotlahtlacol. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Oncan otetlahtlanihque: ―¿Aquinon tehhuatl? Huan Jesús oquinnanquililoc: ―Yonamechiluic den achto aquin nehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nicpiya tequin tlen cuali namechiluis, huan cuali namechtlahtlacoltis. Huan niquihtohua tlen melahuac, ijcon quen in aquin onechualtitlaniloc. Yehhuatzin tlahtolo tlen melahuac. Huan in tlen niquinnonotza in tlacamen, yeh in tlen nechiluilotoc Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Huan yehhuanten ahmo oquinehnehuilihque Yehhuatzin in Tohueyitahtzin in aquin otehualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yeh in ica oquiniluiloc: ―Queman namehhuanten yinannechtlalihtoque huehcapa nehhuatl aquin in Tetiachicau ica nochin tlacatl, ipan inon tonali nannechixmatisque aquin nehhuatl. Huan ahmo tlen nicchihua san noixcohyan; tlahmo niquihtohua in tlen Nohueyitahtzin nechnextilihtoque. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tleca ilohuac nohuan in aquin onechualtitlaniloc. Nohueyitahtzin ahmo nechcautoque nosel, tleca nehhuatl nochipa nicchihua in tlen tepactiya. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Queman Jesús omihto inin, miyacten oteneltocaque. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Oncan Jesús oquiniluiloc in judeahtecos aquin oteneltocaque: ―Tla namehhuan nanquichihuahque cuenta ica tlen namechnextiliya, ic nele notlamachticahuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Huan nanquixmatisque in tlahtoltzin melahuac huan inon tlahtoltzin melahuac mechmaquixtisque imajco in ahmo cuali. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Yehhuanten otenanquilihque: ―Tehhuanten tiixuihuan in Abraham, huan ahyic timotemacatoque imajco niyan aquin. Tel, ¿aquin yehhua imajco mihtohua mach tiyesque timaquistosque? ");
INSERT INTO ncjNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","In Jesús oquiniluiloc: ―Ic nele namechiluiya, nochten aquin tlahtlacolanahque mocahuahque imajco in tlahtlacoli. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nanquinehnehuiliyahque namehhuan techanihcahuan Dios, huan san nanitlaquehualuan in ahmo cuali. Huan ic inon ahhuel nanmocahuasque quen techanihcahuan. Huan quen nehhuatl niconeu iteco in cali, nimocahuas nochipa. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ijconon tel, tla in Iconetzin Dios mechmaquixtilos, nele nanmocahuasque nantlamaquixtilten. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yinicmautica namehhuanten nanixuihuan in Abraham, huan nanquinequihque nannechmictisque, tleca ahmo nanquiseliyahque tlen namechiluiya. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nehhuatl nitlanonotza in tlen Nohueyitahtzin nechnextilihtoque, huan namehhuanten nanquichiutehuahque in tlen namotata mechiluihtoc. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yehhuanten otenanquilihque: ―In totata yeh in Abraham. Huan Jesús omoluihque: ―Huan namehhuan ahmo quen Abraham. Namehhuan ahmo nanquinehnehuiliyahque quen Abraham oquinehnehuili. Huan ahmo nanquichihuahque quen yehhuatl oquichiu. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Masque namechiluihtoc in tlen melahuac, yeh in tlen Dios nechnextilihtoque, namehhuan nanquinequihque nannechmictisque. ¡Ahmo oquichiu ijcon in Abraham! ");
INSERT INTO ncjNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Namehhuanten nanquichihuahque quen quichihua namotata. Oncan yehhuan oteiluihque: ―Tehhuanten ahmo tiichtacaconemen, ticpiyahque san se Totatahtzin, Yehhuatzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Oncan Jesús omoluihque: ―In tla nele Dios yeni Namotatahtzin, nannechnequinihque, tleca nehhuatl onihuala den Dios ipan in tlalticpactli. Ahmo onihuala san noixcohyan, in tlahmo Dios onechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Tleca ahhuel nanquinehnehuiliyahque in tlen niquihtohua? Ahhuel nanquinehnehuilisque tleca ahmo nanquixicosque in tlen namechiluihtoc. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","In namotata yeh in ahmo cuali tlacatl. Namehhuan nanihuaxca, huan nanquichihuasnequihque tlen yehhuatl quinequi. Yehhua saniman temictiyani den achto. Ahmo tlen quita ica tlen melahuac, tleca san tlacahcayauqui. Queman istlacatlahtohua, quihtohua tlen yeh itlamachilis, tleca yehhua tlacahcayauqui, huan nochin istlacatilistli huitz de yehhua. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Huan quenin nehhuatl niquihtohua tlen melahuac, namehhuan ahmo nannechneltocahque. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Niyan aquin de namehhuan cuali nechtlahtlacoltis. Huan quen neh niquihtohua in tlen melahuac, ¿tleca ahmo nannechneltocahque? ");
INSERT INTO ncjNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","In aquin tehuaxca in Dios, quicaqui in tetlahtoltzin Dios, huan quenin namehhuanten ahmo nantehuaxcahuan Dios, yeh in ica ahmo nanquinequihque nantecaquisque. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Oncan in judeahtecos oteiluihque: ―Cuali quenin tiquihtohuahque queman tiquihtohuahque tehhuatl se samaritano huan ticpiya in ahmo cuali yehyecatl. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","In Jesús omonanquilihque: ―Ahmo nicpiya tlen ahmo cuali yehyecatl. Nitemahuestiliya Nohueyitahtzin ica tlen nicchihua, huan namehhuan nannechixtlasahque. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nehhuatl ahmo nictemohua manechmahuestilican, masque oncan aquin monequi manechmahuestilican in tlacamen. Huan Yehhuatzin quinixcomacalos yehhuan aquin ahmo nechmahuestilisque. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ic nele namechiluiya, in aquin quitlacamati notlahtol ahyic miquis. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Oncan in judeahtecos otenanquilihque: ―Axan yoticahsicamatque quen nele ticpiya in ahmo cuali yehyecatl. In Abraham huan nochin tetlayolchicaucahuan omijque, huan tehhuatl tiquihtohua: “Aquin quitlacamatis in tlen niquihtohua, ahyic miquis.” ");
INSERT INTO ncjNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Tlen, ocachi hueyi moquisca quen in totata Abraham? Yehhua omic huan in tetlayolchicaucahuan noyojqui omijque. ¿Tlen ticnehnehuiliya moquisca? ");
INSERT INTO ncjNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","In Jesús oquinnanquililoc: ―Tla nehhuatl nictemoni nohueyilis, inon ahmo quisas hueyilistli melahuac. In aquin nechmahuestiliya Yehhuatzin Nohueyitahtzin, in aquin nanquihtohuahque mach namoDios. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Huan namehhuan ahmo nanteixmatihque. Nehhuatl queme niteixmati, huan tla niquihtoni ahmo niteixmati, noyojqui niyeni nitlacahcayauqui quen namehhuanten. Huan nehhuatl nele niteixmati, huan nicchihua cuenta tlen mihtohua. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham, in aquin namochichicacoltzin, tequin opac tleca hualahsisquiyani notonal. Huan ihcuac oquimat quen nihualas, ic inon tequin opac. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Oncan in judeahtecos oteiluihque in Jesús: ―Ayamo mopiyas niyan ompohuali huan mahtlactli xihuitl. Huan mihtohua mach omotac in Abraham. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","In Jesús oquinnanquililoc: ―Ic nele namechiluiya, den achto ic otlacat in Abraham, yonicatca nehhuatl. Huan ica inon tlahtoli inon judeahtecos oquinehnehuilihque moixnextilo in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Oncan oquipehpenque tetl ic tetemacasque in Jesús; huan Yehhuatzin omotlatiloc huan oquixohuac den tiopantli. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ihcuac panolotiu, in Jesús omotac se tlacatl aquin otlacat ixpatzac. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Huan in tetlamachticahuan otetlahtlanihque: ―Tlamachtiyani, ¿tleca otlacat ixpatzac inin tlacatl? ¿Cana ica intlahtlacol itatahhuan, noso yehhuatl itlahtlacol? ");
INSERT INTO ncjNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Huan Jesús oquiniluiloc: ―Ahmo ica itlahtlacol, niyan ahmo intlahtlacol itatahhuan. Ocachi nele yes ic mamotenextili ica yehhuatl in tlen cuali mochihua in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ic oc ipan tonali, nehhuatl nicpiya tlen nicchihuas in tequitl den aquin onechualtitlaniloc, tleca ipan miquilistli, niyan aquin ayacuel tequitis. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ic oc nica nican ipan inin tlalticpactli, nehhuatl niquinyolmatiltis in tlalticpac tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Satepa ic omihto inin, Jesús ochihchaloc tlalpa, ic omochiu chihton soquitl ican techihchac, huan omixtlalili ipan iixtelolo in ixpatzac. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Oncan omoluic: ―Xiyau ximoixpaca ipan in atl nepa Siloé. Itocahyan Siloé quihtosnequi Tlatitlanili. In ixpatzac oya huan omoixpacac. Huan queman omocuep, yicuali otlachix. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Oncan in ichantlacahuan, huan in aquihque achto oquitayayahque ixpatzac, oquitohque: ―¿Ahmo yehhuatl inin in aquin omotlaliyaya quitlahtlani in limosnahtomin? ");
INSERT INTO ncjNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Sequin oquihtohuayahque: ―Queme, yehhuatl. Oc sequin oquihtohuayahque: ―Ahmo yehhua, san ixnesi yehhuatl. In tlacatl oquihto: ―Queme, nehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Oncan oquitlahtlanihque: ―¿Huan queni yicuali titlachiya? ");
INSERT INTO ncjNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yehhuatl oquinnanquilic: ―Inon tlacatl mach itoca Jesús oquichiu soquitl, huan onechixtlalili ipan noixtelolohhuan, huan onechiluic: “Xiyau ipan in atl den Siloé huan ximoihxami.” Oniya, tel, huan queman onimoihxami, cuali onitlachix. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Oncan oquitlahtlanihque: ―¿Caninca inon tlacatl? Huan yehhuatl oquiniluic: ―Ahmo nicmati. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Oncan oquihuicaque inixpa in fariseos in aquin ocatca ixpatzac. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Huan yeh in tonali den nesehuilistli ihcuac in Jesús omochiu in soquitl, huan omotlachiyalti in ixpatzac. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Huan ic inon noyojqui in fariseos oquitlahtlanihque in tlacatl quenin axan cuali tlachiya. Yehhuatl oquiniluic: ―Onechtlalili soquitl ipan noixtelolohhuan, huan onimoihxami huan axan nitlachiya. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Oncan sequin den fariseos oquihtoque: ―In tlacatl aquin oquichiu inin ahmo ohuala den Dios, tleca ahmo quichihuas cuenta ica in tonali den nesehuilistli. Huan oc sequin oquihtohuayahque: ―¿Quenin cuali quichihuas tlachiuten mahuestic quen inin in tla san tlahtlacolyo? ");
INSERT INTO ncjNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ic inon omoxexelohque ic yehhuanten, huan oc sepa oquitlahtlanihque in aquin ocatca ixpatzac: ―¿Huan tehhuatl, tlen tiquihtohua ica in tlacatl aquin omitztlachiyalti? Huan yehhuatl oquihto: ―Nehhuatl niquihtohua inon se tlayolchicahuani. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Huan in tequihuahten den judeahtecos ahmo oquineltocayayahque in tla ixpatzac ocatca. Huan ic inon oquinnotzque in itatahhuan in aquin ocatca ixpatzac. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Huan oquintlahtlanihque: ―¿Yeh inin in namoconeu in aquin nanquihtohuahque otlacat ixpatzac? ¿Quenin axan yicuali tlachiya? ");
INSERT INTO ncjNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","In itatahhuan oquinnanquilihque: ―Ticmatihque inin yehhuatl in toconeu, huan otlacat ixpatzac. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Huan ahmo ticmatihque quenin axan cuali tlachiya, niyan ahmo ticmatihque aquinon oquitlachiyalti. Xictlahtlanican yehhuatl; ayacmo semi in conetl, huan yehhuatl mechiluis quenin ocatca. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","In itatahhuan oquihtoque inon ica inmoucayo, tleca in tequihuahten den judeahtecos yoquisemauticatcahque ic quinquixtohuetzosque ipan tiopantli yehhuatl in aquin quihtosque in Jesús, yehhua in Cristo. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yeh in ica in itatahhuan oquihtoque: “Xictlahtlanican yehhuatl, tleca yitlacatl, ayacmo cana conetl.” ");
INSERT INTO ncjNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Oncan in tequihuahten den judeahtecos oc sepa oquinotzque in tlacatl in aquin achto ixpatzac ocatca, huan oquiluihque: ―Xiquihto nele Dios in tlahmo nele tlahtlacolyo inon tlacatl. Tehhuanten ticmatihque inon tlacatl tlahtlacolyo. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Oncan yehhuatl oquinnanquilic: ―Nehhuatl ahmo nicmati in tla yehhuatl in tlahtlacolyo noso ahmo. San nicmati quenin onicatca niixpatzac huan axan nitlachiya. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Huan oc sepa oquitlahtlanihque: ―¿Tlen omitzchihuilic? ¿Quenin oquichiu ic omitztlachiyalti? ");
INSERT INTO ncjNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Oquinnanquilic: ―Yonamechiluic, huan ahmo nantlacaquihque. ¿Tleca nanquinequihque oc sepa maniquihto? ¿Cana namehhuan noyojqui nanquinequihque nanquicuitlapanuisque? ");
INSERT INTO ncjNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Oncan oquipactecahque huan oquiluihque: ―¡Tehhuatl xicuitlapanui inon tlacatl! Tehhuanten ticuitlapanuisque itlanahuatil in Moisés. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tehhuanten ticmatihque quen Dios omonotz in Moisés, huan inin Jesús, niyan ahmo ticmatihque de canin. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Oncan in tlacatl oquinnanquilic: ―Ahmo nicnehnehuiliya tleca nannechtlahtlanihticaten ica inin tlahtoli. Nanquihtohuahque ahmo nanquimatihque de canin ohuala, huan nehhuatl onechtlachiyalti. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ticyecmatihque quenin Dios ahmo quincaquilos in tlahtlacolyohque. San quincaquilos in aquihque temahuestiliyahque huan quichihuahque tlen monequi. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ic opeu in tlalticpac ahyic ticmautoque tla oncan aquin yoquitlachiyalti in aquin otlacat ixpatzac. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","In tla inin tlacatl ahmo hualani den Dios, ahhuel tlen quichihuani. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Oncan oquiluihque in tequihuahten: ―Tehhuatl otitlacat titlahtlacolyo. Huan axan tel, ¿tehhuatl titlahtlacolyo tiixcohyehuis titechnextilis? Huan oquixtohuetzohque den tiopantli. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús omomat quen oquixtohuetzohque in ixpatzac, huan queman omoahsiloc, omoluic: ―¿Ticneltoca ica in Iconetzin Dios? ");
INSERT INTO ncjNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","In tlacatl oteiluic: ―Tlacatzintli, manechiluican aquinon, ic niteneltocas. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","In Jesús omonanquilic: ―Yitiquitztoc; yinehhuatl aquin ihuan timonohnotztica. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Oncan in tlacatl omotlancuaquetz teixpa in Jesús, huan oteiluic: ―Nicneltoca, Notecohtzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Saniman omihto in Jesús: ―Nehhuatl onihuala ipan inin tlalticpactli ic niquinixcomaca in tlalticpac tlacamen, huan ic in ixpatzacten maquinehnehuilican. Huan in aquin quihtohuahque mach tlachiyahque, mocahuasque quen ixpatzacten ica intlahtlacol. ");
INSERT INTO ncjNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Oncan sequin fariseos ocahcatca tehuan, huan ic oquicajque inon, otetlahtlanihque: ―Cox, ¿ticnehnehuiliya tehhuanten noyojqui tiixpatzaque? ");
INSERT INTO ncjNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","In Jesús oquinnaquililoc: ―In tla namehhuan nanquihtonihque nanixpatzacten, ahmo mechtlahtlacoltihtonihque. Huan quenin nanquihtohuahque mach nantlachiyahque, ahhuel mechixtlapacholuisque namotlahtlacol. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Ic nele namechiluiya, in paxtol calaqui ipan in puerta den itzacual den calnelohten, huan aquin calaquis icxitla in itzacual, yeh in ichtejqui. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Huan in aquin calaqui canin calaquihque in calnelohten, yehhua in paxtol, in aquin quinixpiya in calnelohten. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","In aquin tlachiya ipan in puerta quitlatlapoluiya ic macalaqui in paxtol, huan in calnelohten quitlahtolcaquihque. Quinnotza ica intoca in icalnelohhuan, huan quinquixtiya den intzacual. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Huan satepa ic quintlamiquixtiya in icalnelohhuan, oncan quinuica quinyecantas. Huan in calnelohten quicuitlapanuiyahque, tleca quitlahtolcaquihque. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Huan ahmo quicuitlapanuiyahque san aquin ahmo quixmatihque, tlahmo quichololiyahque, tleca ahmo quitlahtolcaquihque san aquin. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","In Jesús oquinnonotzaloc ica inin tlalnamictilistli, huan yehhuan aquin otecacticatcahque ahmo oquinehnehuilihque in tlen quihtosnequi. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Oncan Jesús oc sepa omoluihque: ―Ic nele namechiluiya, nehhuatl quen se puerta canic calaquihque in calnelohten. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nochten aquin ohualahque achto ic onihuala, inohque ichtejcamen, huan in calnelohten ahmo oquinchiuque cuenta ic oquinnotzque. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nehhuatl quen in puerta canin calaquisque tenahuac in Dios, huan in aquin nopa panos yes tlamaquixtili. Huan yes quen se calnelo tlen calaqui huan quisa ipan intzacual huan quiahsi itlacual. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’In ichtejqui huitz san tlachtequi. Yehhua quinmictiya in calnelohten huan quinixpolohua. Huan nehhuatl onihuala ic maquipiyacan in yancuic nemilistli, huan yeh in tepac nemilistli. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nehhuatl quen in cuali paxtol. In cuali paxtol motemactis inemilis ica in calnelohten. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Huan in aquin san tepaltequiti, queman quita huitz in lobo, quincahua in calnelohten huan cholohua, tleca yehhuatl ahmo nele paxtol huan in calnelohten ahmo ihuaxca. Oncan in lobo quinquitzquiya sequin den calnelohten huan in oc sequinten quinxixiniya. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Inon tlacatl ocholo tleca san tlaquehuali huan yeh in ica ahmo quinchihua cuenta in calnelohten. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","’Nehhuatl quen in cuali paxtol. Ijcon quen Nohueyitahtzin nechixmatihque nehhuatl, huan nehhuatl niteixmati in Nohueyitahtzin, no ijcon nehhuatl niquinixmati in nocalnelohhuan, huan yehhuan noyojqui nechixmatihque. Huan nehhuatl nimotemactis nonemilis ica in calnelohten. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Niquimpiya noyojqui oc sequin calnelohten tlen ahmo de inin ololi, huan nicpiya tlen niquinualicas noyojqui. Yehhuan nechcaquisque, huan yes san se ololi huan san se paxtol. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’In Nohueyitahtzin nechnequilo tleca nimotemactis nonemilis ic oc sepa manicahsis nonemilis. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Niyan aquin ahhuel nechmictis, tleca nehhuatl nimotemactis nonemilis ica notlamatiyan. Nicpiya techicahualis ic nimotemactis nonemilis, huan nicpiya techicahualis ic oc sepa nicahsis nonemilis. Inin in tlen onechtequiutihque in Nohueyitahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Queman in judeahtecos oquicajque inin tlahtoli, oc sepa omotlahtolchihuihque. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Miyacten de yehhuan oquihtohuayahque: ―¿Tleca nanquineltoquiliyahque tlen quihtohua, tla quipiya in ahmo cuali yehyecatl huan ixpoliutoc? ");
INSERT INTO ncjNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Huan oc sequin oquihtohuayahque: ―Niyan aquin cuali tlahtos ijquinin in tla quipiyas in ahmo cuali yehyecatl. In aquin quipiya se ahmo cuali yehyecatl ahhuel quintlachiyaltis in ixpatzacten. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ocatca in tonalten den itztic, huan ompa Jerusalén oquitlaolichtihque in iluitl ica iyancuilis den tiopantli. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","In Jesús onemohuayaya ipan in tiopantli ic Icaltenco in Salomón. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Huan in judeahtecos oteyehualuihque huan oteiluihque: ―¿Hasta queman ticahcomantiyesque ica Tehhuatzin? In tla Tehhuatzin in Cristo, mamihto semi. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","In Jesús oquinanquililoc: ―Yonamechiluic huan ahmo onannechneltocaque. In tlachiuten tlen nicchihua ica tetequihuahyo in Nohueyitahtzin moyectenextiliya quen nehhua niCristo. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Huan namehhuan ahmo nanquineltocahque ica nehhuatl tleca namehhuan ahmo nocalnelohhuan, quen onamechiluic achto. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nocalnelohhuan nechtlahtolcaquihque, huan nehhuatl niquinixmati huan yehhuan nechcuitlapanuiyahque. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nehhuatl niquinmaca in yancuic nemilistli nochipa, huan ahyic polihuisque. Huan niyan aquin ahhuel quinquixtis nomajco. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yeh in Nohueyitahtzin aquin nechmomaquilihtoc nocalnelohhuan huan Yehhuatzin ocachi chicahuac de nochten, huan niyan aquin ahhuel quinquixtis temajco. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nehhuatl nichicahuac ijcon quen Nohueyitahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Oncan in judeahtecos oc sepa oquipehpenque tetl ic tetemacasque. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Huan Jesús oquiniluiloc: ―Nicchiutoc miyac tlachiuten mahuestic nanmoixpa ica techicahualis Nohueyitahtzin. ¿Ica tlen tlachiutli nanyahue nannechtemacahque? ");
INSERT INTO ncjNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","In judeahtecos otenanquilihque: ―Ahmo cana tiohue timitztemacahque ica tlen cuali ticchiutoc, tlahmo tleca teca tiistlacatis in Dios. San noyojqui titlacatl, huan timochiutica Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Oncan Jesús oquiniluiloc: ―Ipan in tlanahuatili den namehhuanten ca tlahcuiloli in tlen Dios omoluihque in tlixcomacanimen: “Namehhuan nanquinixcomacahque quen nandioses.” ");
INSERT INTO ncjNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ticmatihque in tlen ca tlahcuiloli ipan in Tlahcuilolamamen nochin melahuac, huan Dios oquintocahhuiloc dioses inon tlacamen tleca oquimpanoltilihque tetlahtol. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Huan quen Dios oquinnotzalo dioses yehhuan aquin oquimpanoltilihque tetlahtol, ic inon ahmo nanquihtosquiyanihque teca nicamanalti tleca oniquihto Niconetzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","In tlahmo nicchihua in tlachiuten ica techicahualis Nohueyitahtzin, ahmo xinechneltocacan. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Huan in tla nele nicchihuas ica techicahualis, masque ahmo nanquineltocahque in tlen onamechiluic, xicneltocacan nele nehhuatl in Cristo, in aquin onechualtitlaniloc. Ic inon semi xicyecmatican nehhuatl huan Nohueyitahtzin san se totlamatilis. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Oc sepa oquinequiyayahque tehuicasque tetzacuasque, huan Jesús omaquixohuac oc sepa. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Oncan Jesús omocuepaloc ic in oc se lado den atentli Jordán ic quixnamictica in Jerusalén huan omocahualoc ompa, canin in Juan otlacuatequiyaya achto. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Miyac tlacatl oyahque teitahque, huan oquihtohuayahque: ―Ic nele, masque in Juan ahmo oquichiu niyan tlen tlachiutli mahuestic, nochin tlen oquihto ica inin tlacatl oquis ic nele. ");
INSERT INTO ncjNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Huan miyac oteneltocaque in Jesús ompa canin oilohuaya. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Huan omococohuaya se tlacatl itoca Lázaro, chani den Betania, in ialtepeu María huan in icniu Marta. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Inin María in aquin otexocuepili in aceite ahhueyac in Jesús huan otexohuatz ica itzon. Huan omococuaya in icniu Lázaro. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ijcon tel, in ome icnimen otlatequiutihque mateiluican in Jesús: ―Totecohtzin, mococohua in aquin ihuan monequilo. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Queman Jesús omocac inon, omihto: ―Ahmo ic miquis inin cocolistli. Tlahmo ic motenextilis ica in tehueyilistzin Dios. Huan ica inon cocolistli motenextilis noyojqui ica in nohueyilistzin nehhuatl aquin Niconetzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","In Jesús oquintlasohtlalohuaya tequin in Marta, huan in María, huan in Lázaro. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Masque oteiluihque quen in Lázaro mococohtoc, oc omocahualo ome tonali ompa canin oilohuaya. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Satepa oquiniluiloc in tetlamachticahuan: ―Tiyohue oc sepa in Judea. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Oncan in tetlamachticahuan oteiluihque: ―Tlamachtiyani, ayamo huehcau in judeahtecos temictisquiyanihque ica tetl. Huan axan tel, ¿oc sepa ixcohyehuihua huilohuas ompa? ");
INSERT INTO ncjNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","In Jesús oquintlalnamictiloc maquinehnehuilican ayamo ahsitoc in tonali ic micohuas. Huan oquiniluiloc: ―Tel, ¿tlahmo nele in tonali quipiya mahtlactli huan ome hora? In tla seya nemis tlahca, ahmo motecuiniya, tleca tlachiya ica in tlanextli tlen oncan nican tlalticpac. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Huan tla seya nemis in tlayohuilotl, motecuiniya tleca ipan in tlanextli den neluicac ahmo tlayolnehnehuilihtoc. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Satepa oquiniluiloc in Jesús: ―In totlanonotzcau Lázaro cochtoc, huan niyau niquihxiti. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Oncan in tetlamachticahuan oteiluihque: ―Totecohtzin, in tla cochtoc, huelis mohuelmatis. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Huan Jesús omonequiyaya mihtos quen in Lázaro yimictoc, huan in tetlamachticahuan oquinehnehuiliyayahque otlahtoloticatca ic nele ica in cochistli. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Oncan Jesús semi oquinyequiluiloc: ―In Lázaro yimictoc. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nipaqui tleca ahmo ompa onicatca, tleca axan ijcon ocachi nannechneltocasque. Huan tiyasque tiquitasque. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Oncan Tomás, in aquin oquitocahhuiyaya in Gemelo, oquiniluic in oc sequin tetlamachticahuan: ―Tiyohue noyojqui tehhuanten, huan timiquisque san secnin tehuan Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ic oahxihuac, in Jesús omoahsito in Lázaro yitoctoc nahue tonali. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania ocatca ic inahuac Jerusalén, cana ome kilómetro huan tlahco. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Huan miyacten judeahtecos oyahque quimpanitahque in Marta huan María ic quinyolchicahuahque in imiquilis in icniu. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Queman Marta oquimat quen Jesús yiahxihuatiu, oquis ic oteseli, huan María omocau ipan in cali. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Huan Marta oteiluic in Jesús: ―Notecohtzin, in tla oncan ilohuani, ahmo miquini in nocniu. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Huan nehhuatl nicmati quen Dios mitzmacalos nochin tlen titetlahtlanilis. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","In Jesús oquiluiloc: ―In mocniu oc sepa yolis. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta oteiluic: ―Queme, nehhua nicmati quen oc sepa yolis ihcuac in ihxohualistli den mijcamen ipan sayohpa tonali. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Oncan Jesús oquiluiloc: ―Nehhuatl in aquin niquinihxitis in mijcamen, huan niquinmacas in yancuic nemilistli. In aquin nechneltoca, masque miquis, oc sepa yolis. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Huan nochin in aquin oc yolticaten, huan nechneltocahque, ahyic miquisque niyan queman. ¿Ticneltoca inin? ");
INSERT INTO ncjNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Yehhuatl oteiluic: ―Queme, Notecohtzin, nehhuatl nicneltoca quen Tehhuatzin in Cristo, in Iconetzin Dios, in aquin oquipiyaya tlen hualas ipan inin tlalticpactli. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Satepa ic omihto inin, Marta oya quinotza icniu María, huan oquiluic san ichtaca: ―In Tlamachtiyanitzin oncan ilohuac huan mitzhualnotzalo. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Saniman quen oquicac inin, María omotelquetzteu huan oya teita in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Huan Jesús ayamo oahxihuatoya ipan in altepetl; oc oilohuaya canin ihuan omahsiloc in Marta. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","In judeahtecos aquin ompa ocahcatca ichan inuan oyolchicautoyahque oquitaque in María quen omotelquetzteu huan niman oquisteu. Ic inon yehhuan oquicuitlapanuihque. Oquinehnehuilihque cana yahtica inahuac in tlaltecochtli ic yau choca ompa. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Huan queman oahsito María canin oilohuaya in Jesús, omotlancuaquetz teixpa, huan teiluihtiu: ―Notecohtzin, in tla oncan ilohuani, ahmo miquini in nocniu. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Queman Jesús omotac quen chocaticaten in María huan in judeahtecos aquin ihuan ohualahque, inca otlocoyaloc hasta oyoluehueyocaloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Huan oquintlahtlaniloc: ―¿Canin onanquitocaque? Huan oteiluihque: ―Totecohtzin, mahualuilohua mota. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Huan Jesús ochocohuac. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Oncan in judeahtecos oquitohque: ―Xiquitacan tequin oquinequilohuaya. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Huan oc sequin de yehhuan oquitohque: ―Inin in aquin oquitlachiyalti in ixpatzac. Cox, ¿ahhuel mochihuani ic ahmo miquini in Lázaro? ");
INSERT INTO ncjNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Huan Jesús tequin tlocoyalo oc sepa, huan omopacholoc inahuac in tlaltecochtli. Yeh in se tlacoyoctli poxcoyoc in tepetl huan oquipiyaya se tetl tlen ica otentzactoya. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Oncan Jesús omihto: ―Xiquihcuanican in tetl. Marta, icniu in mijqui, oteiluic: ―Notecohtzin, yimolonqui yes, tleca yiquipiya nahue tonali mictoc. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Huan Jesús oquiluiloc: ―¿Tlahmo onimitziluic in tla ticneltoca, tiquitas in tehueyilistzin Dios? ");
INSERT INTO ncjNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Oncan oquihcuanihque in tetl. Huan Jesús oahcotlachiyaloc ic neluicac huan omihto: ―Nohueyitahtzin, nitetlasohcamati tleca nechcaquilotoc. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nehhuatl nicmati quen nochipa nechcaquilo, huan ijcon niquihtohua maquicaquican in tlacamen aquin nicancaten, maquineltocacan quen nele Tehhuatzin onechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Satepa ic omihto inin, ocoutzahtzihuac: ―¡Lázaro, xiquisa de ompa! ");
INSERT INTO ncjNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Huan in mijqui oquis yahyaliutoc in imahuan huan icxihuan ica in tatapahtli. Huan ixayac ixtlapachiutoc ica se payo. Oncan Jesús oquiniluiloc: ―Xictohtomacan huan xicahuacan mayau. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ic inin, oteneltocaque in Jesús miyacten den judeahtecos in aquin ihuan oyahque in María tleca oquitaque in tlen omochiu Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Huan oc sequinten de yehhuan oyahque quinitahque in fariseos huan oquinnonotzque in tlen omochiu in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Oncan in fariseos huan in tlayecancamen den tiopixcamen omosetilihque inuan in tequihuahten den judeahtecos huan oquihtohque: ―¿Tlen ticchihuilisque? Inin tlacatl quichiutica miyac tlachiuten mahuestic. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","In tla ticahuasque ijcon, nochten quineltocasque ica yehhuatl, huan in tequihuahten romanohtecos quintitlanisque soldados huan quixitinisque in totiopan huan in toaltepeu. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Huan se de yehhuan, itoca Caifás, yehhuatl ocatca in hueyixtoc den tiopixcamen inon xihuitl, huan oquiniluic: ―Tel, ¿semi ahmo nanquimatihque tlen ticchihuilisque? ");
INSERT INTO ncjNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Xicnehnehuilican in tlahmo ocachi cuali mamiqui se tlacatl impampa in tlacamen, huan ahmo mapano cana ayacmo techcahuilisque matitlatequiutican ipan totlal judeahteco. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Huan in Caifás ahmo oquihto inon san ica itlanehnehuilis, tlahmo quenon oquihualiluiloc in Dios. Huan quen ocatca in hueyixtoc den tiopixcamen inon xihuitl, ica itequiu oquihualiluic quen in Jesús micohuas impampa in judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Huan ahmo micohuas san ica in judeahtecos, tlahmo noyojqui ica in tlacamen nohuiyan ipan tlalticpac, mamosentlalican san secnin quen techanihcau nochin yehhuan aquin mochihuasque tepiluan Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","De ihcuac inon tonali in tequihuahten judeahtecos omononotzque quen quichihuasque ic temictisque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yeh in ica in Jesús ayacmo omonextilohuaya inmiyacaixpa in judeahtecos. Ijcon oquixohuac den tlali Judea huan ohuilohuac inahuac in acahualtlahtli, ipan se altepetl itoca Efraín. Ompa omocahualoc inuan in tetlamachticahuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ayacmo huehcau quitlaolichtisque in pascuahiluitl den judeahtecos. Yiahsitihuitzen in Jerusalén miyac tlacatl ic mochipahuasque ica tlatemactilten huan ic mopahpacahque achto den iluitl. ");
INSERT INTO ncjNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Otetemohtinemiyayahque in Jesús, huan ihcuac ocatcahque ipan in tiopantli, omotlahtlaniyayahque se huan oc seya: ―¿Tlen nanquinehnehuiliyahque? ¿Hualas ica in iluitl, noso ahmo? ");
INSERT INTO ncjNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","In fariseos huan in tlayecancamen den tiopixcamen oquinahuatihtoyahque in tla cana aquin quimati canin ilohuac in Jesús, maquihto ic cuali tequitzquisque tetzacuasque. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Chicuasin tonali achto den pascuahiluitl, in Jesús ohuilohuac in altepetl Betania, canin ochantiyaya in Lázaro, in aquin Jesús oquihxitiloc ihcuac mijqui. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ompa oquichiuque se tlacuali ica temahuestilis in Jesús. Marta otetlahtlamacayaya, huan in Lázaro ocatca inuan in aquin oyehyehuaticatcahque ipan in mesa ic otlacuahticatcahque. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Oncan María oquihualicac cana tlahco litro den aceite ahhueyac, itoca nardo, tlen molui patiyo. Huan otexoquenti in Jesús huan satepa otexohuahhuatz ica itzon. Nochin tlahtec omotzac ica in iahhueyaca. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Oncan ocatca in Judas Iscariote, iconeu in Simón, se den tetlamachticahuan Jesús, huan yehhuatl in aquin tetemactis. Huan oquihto: ");
INSERT INTO ncjNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Tleca ahmo oquinemacac inin aceite ahhueyac? Tleca ipatiu cana yiyi ciento itlaxtlahuil in tonali den tlacatl, huan quimpalehuini in prohues. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","In Judas ahmo nele inca tlocaya in prohues. Oquihto inon tleca yeh in tlachtejqui. Huan quen oquipiyaya in cajahtomin, oquiquixtihtaya in tlen oquimacayayahque. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Oncan Jesús oquiluiloc: ―Ahmo tlen xiquihtohtiye. Tlaeutli ocatca inon aceite manechquenti ihcuac nechtocasque. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nochipa yesque namohuan in prohues tla nanquimpalehuisque, huan nehhuatl ahmo nochipa namohuan niyes. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Miyacten den judeahtecos oquiahsicamatque quen oilohuaya in Jesús nepa Betania, huan oyahque ompa teitahque ahmo san Yehhuatzin in Jesús tlahmo noyojqui in Lázaro, in aquin Jesús omoihxiti ihcuac omictoya. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Oncan in tlayecancamen den tiopixcamen omononotzque ic quimictisque noyojqui in Lázaro. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Tleca ica inon tlen oquichihuililoc ica yehhuatl, miyacten in judeahtecos omoxelohticatcahque den tiopixcamen huan oteneltocaque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Huan ic mostla in miyac tlacamen aquin ocatcahque Jerusalén ica in pascuahiluitl oquiahsicamatque quen in Jesús ahxihuas ipan inon altepetl. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Oncan oquitejque imaxiuyo in papalma huan oquisque tenamiquihque in Jesús, coutzahtzitihue: ―¡Matemahuestilican in Dios! ¡Maye tlatiochihuilistli ica Yehhuatzin aquin hualuilohua quen itetitlanil in Dios! ¡Matitemahuestilican in Hueyixtoc den judeahtecos! ");
INSERT INTO ncjNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús omotlanehui se burro huan ipan omotlaliloc, quen quihtohua ipan in Itlahcuiloltzin: ");
INSERT INTO ncjNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ahmo ximomoutican namehhuan den altepetl Sión. Xiquitacan oncan hualuilohua namohueyixtoc, huan motlalilotoc ipan se burro. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ic achto, in tetlamachticahuan ahmo oquinehnehuilihque inon tlahtoli. Huan satepa ihcuac in Jesús omocuepaloc neluicac, oquilnamijque quen nochin inin ocatca tlahcuiloli ica Yehhuatzin. Huan ic nele ijcon otepanoc. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","In tlacamen aquin tehuan ocatcahque in Jesús queman omonotz in Lázaro ipan in tlaltecohtli huan omoihxiti den imiquilis, otlanonotzayayahque ica tlen opanoc. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Huan in tlacamen oquisque ic teixnamihque in Jesús, tleca oquimatque ica inon tlachiutli mahuestic tlen omochiu. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Oncan in fariseos omoluihque san ic yehhuan: ―Xiquitacan quen ahhuel tiquintzacuiliyahque ic ahmo maquicuitlapanuican. Xiquitacan, nochin tlacatl yahticaten ihuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ihuan in tlacamen aquin oyahque in Jerusalén ic temahuestilisque ipan in iluitl, ocahcatca sequin griegohtecos. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Inihque omopachohque inahuac in Felipe, den altepetl Betsaida den Galilea, huan oquitlatlautihque: ―Tlacatzintli, titeitasnequihque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipe oya huan oquiluic in Andrés, huan in inehuan oyahque tenonotzahque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Oncan Jesús oquiniluiloc: ―Yoahsico in horas queman nehhuatl aquin Nitetiachicau ica nochin tlacatl nimonextis ica nohueyilis. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ic nele namechiluiya, huelica nechmictisque huan ic inon miyacten quiahsisque in yancuic nemilistli. Ijcon ahmo miyaquilis in xinachtli in tlahmo motocas, ic miquis. Huan tla miquis huan ixuas, quitemaca miyac itlaolyo. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","In aquin ahmo motemacas inemilis nopampa, yehhua polihuis ihcuac miquis. Huan in aquin motemacas inemilis nopampa ipan inin tlalticpac, yehhua quiahsis nemilistli nochipa. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","In aquin quinequis nechpalehuis, manechcuitlapanui. Huan canin niyes, noyojqui ompa yes in aquin nechpalehuis. Tla aquin nechpalehuis, Nohueyitahtzin quihueyililos. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Axan nica tequin nimomohsihuihtica; ¿huan tlen inon niquihtos? Ahhuel niquitos: “Nohueyitahtzin, manechmaquixtilo ica tlen yau nechpanohua axan.” Tleca saniman ic inon onihuala. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nohueyitahtzin, mamochihua tlen ic monextis tehueyilistzin. Oncan omocac se tlahtoli den neluicac tlen oquihto: ―Yinicnextihtoc nohueyilis, huan niyau nicnextis oc sepa. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Huan in tlacamen aquin ocatcahque ompa oquicajque inon tlahtoli quen se tlatecuinilotl, huan oc sequin oquihtohuayahque: ―Se ángel oquinotz. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Oncan Jesús oquiniluiloc: ―Inon tlahtoli ahmo ica nehhuatl ohuala, tlahmo xicaquican namehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Axan in tonali ahsitihuitz queman inin tlalticpac tlacamen panosque ipan in tlaixcomacalistli, huan ihcuac inon tlantos itequihuahyo in ahmo cuali tlacatl aquin tlatequiutiya ipan inin tlalticpactli. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Huan queman nechmasohualtihtoc ipan in cruz, nechneltocasque se quesqui nohuiyan ipan in tlalticpactli. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ijcon oquinnextililoc quenin micohuas. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Huan in tlacamen otenanquilihque: ―Ticactoque quen quihtohua ipan in itlanahuatil Moisés quen in Cristo yolihuatos nochipa. Huan axan, mihtohua mach in Tetiachicau ica nochin tlacatl quipiya tlen quimasohualtisque ipan cruz. ¿Aquinon in Tetiachicau ica nochin tlacatl? ");
INSERT INTO ncjNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Oncan Jesús oquiniluiloc: ―Sahuelchihton nannechitasque nehhua in aquin namechyolnehnehuilti. Xinechneltocacan ic nanquinehnehuilisque in tlen namechiluihtoc huan mamechtequiutis inon tlahtoli. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Xicneltocacan in tlahtoli tlen mechyolmatiltis ic oc namechnonotztica. Huan inon tlahtoli nele mechyolnehnehuiltis. Satepa ic omotlamiihto inin tlahtolten, in Jesús ohuilohuac huan oquinmonetlatililoc. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Huan masque in Jesús omochiu miyac tlachiuten mahuestic inixpa, ahmo oteneltocayayahque in judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Oquipiyaya tlen tzonquisas inin quen in tlayolchicauqui Isaías oquihcuilo: Notecohtzin, ¿aquinon quineltocatoc in totlanonotzal? ¿Aquinon quinehnehuilihtoc in techicahualis Dios? ");
INSERT INTO ncjNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Huan ic inon ahhuel oquineltocaque in Jesús. Tleca noyojqui oquihcuilo in Isaías: ");
INSERT INTO ncjNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dios oquinchihualoc ixpatzacten huan yoltepitzten, ahmo maquinehnehuilican tlen oquitaque, niyan ahmo matlanehnehuilican ica inyolo in tlen oquiniluiloc. Huan niyan ahmo mamocuepacan ica nehhuatl maniquintlapohpolui. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías oquihto inin tleca oquitztoya in tehueyilistzin in Jesús, huan otlahtohuaya ica Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Huan ijcon, miyacten in judeahtecos oteneltocaque in Jesús, hasta sequin in tequihuahten, huan ahmo omocuitiyahque miyacaixpa tleca omomoutihque inca in fariseos, cana ayacmo quincahuanihque ic temahuestilisquiyanihque ipan in tiopantli. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ocachi oquimpactiyaya maquinmahuestilican in tlacamen huan ahmo oquichihuayayahque cuenta in tla quinuelitalos in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Huan Jesús omihto ica chicahuac tetlahtol: ―In aquin nechneltoca, ahmo san nehhuatl nechneltoca, tlahmo noyojqui teneltoca in aquin onechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Huan in aquin nechita, quihtosnequi noyojqui teitztoc in aquin onechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Huan nehhuatl quen in tlanextli quen niquinyolnehnehuiltiya in tlalticpac tlacamen. Onihuala ipan inin tlalticpactli manechneltocacan. Huan in aquin nechneltocasque ayacmo nentiyesque ipan in ahmo cuali. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Huan in tla seya quicaquis notlahtol huan ahmo quitlacamatis, ahmo nehhuatl nictlahtlacoltis, tlahmo yeh notlahtol. Tleca nehhuatl ahmo onihuala ic niquintlahtlacoltis in tlacamen. Onihuala ic niquinmaquixtis. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Masque ijcon ca, in aquin nechixtlasa, huan ahmo quichihua cuenta ica notlahtol, yiquipiya tlen quitlahtlacoltis. In tlahtoli tlen nehhuatl niquihtohtoc, yeh in tlen quitlahtlacoltis ipan in sayohpa tonali. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tleca nehhuatl ahmo nitlahtohua cana san noixcohyan. Nohueyitahtzin aquin onechualtitlaniloc, Yehhuatzin nechtequiutihtoque ica tlen maniquihto huan ica tlen niquinnextilis. ");
INSERT INTO ncjNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Huan nicmati in tetlatequiutil quitemaca nemilistli nochipa in aquin tetlacamatis. Ijcon tel, in tlen nehhuatl niquihtohua, yeh in tlahtoli tlen nechtequiutilohtoc in Nohueyitahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Huan oahsic se tonali achto den pascuahiluitl. Huan Jesús yomomauticatca quen yoahsic in tonali ic mocautehuas inin tlalticpactli huan huilohuas canin ilohuac in Tohueyitahtzin. Yehhuatzin nochipa oquintlasohtlalohuaya in tetlamachticahuan aquin ocatcahque ipan in tlalticpac, huan tlaluis oquintlasohtlalohuaya. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","In ahmo cuali tlacatl yoquiyolnehnehuiltihtoya in Judas Iscariote, iconeu in Simón, quenin teichtacatemactis in Jesús. Huan Jesús momautica quen ohualuilohuac den Dios, huan oc sepa mocuepalos tehuan, huan quen Yehhuatzin otehualmacaque nochin in tequihuahyotl. Ijcon, ihcuac oyehyehuaticatcahque ipan in mesa, omoquetzaloc in Jesús huan omoquixti tepampijca, huan omotlahcohuiltiloc in toalla. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Oncan omotlalili in atl se xicali huan opehualoc quinxopacalo in tetlamachticahuan. Huan ic oquinxohxohuatzaloc ica in toalla in tlen ic motlahcoyalolotoc. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ihcuac huilohuatica quixopacalo in Simón Pedro, yehhua oteiluic: ―Notecohtzin, tlen, ¿Tehhuatzin nechxopacalos? ");
INSERT INTO ncjNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Huan Jesús oquinanquililoc: ―Axan ahmo ticnehnehuiliya tleca ijcon nicchiutica, huan satepa ticnehnehuilis. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Huan Pedro oteiluic: ―Nehhuatl ahyic nechxopacalos. In Jesús oquiluiloc: ―In tlahmo nimitzxopacas, ayacmo tipohuis nohuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Oncan Simón Pedro oteiluic: ―Notecohtzin, tel, ahmo san yeh in nocxihuan, tlahmo noyojqui nomahuan manechpahpaquilican huan manechahmohuican notzonteco. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Huan Jesús oquiluiloc: ―In aquin hueloc motlamipacatoc ahmo quinequis sentetl mamopahpaca, tlahmo san yehhua in icxihuan, tleca ca sentetl tlapahpactli. Namehhuanten nancaten nantlapahpacten, masque ahmo namochten. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Omihto: “Ahmo nantlapahpacten namochtehque”, tleca momautica aquin yau teichtacahuis. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Satepa ihcuac yotlamohuac quinxopacalo, in Jesús omotlaquentiloc, huan omotlaliloc inahuac in mesa oc sepa. Huan oquiniluiloc: ―Tel, ¿nanquinehnehuiliyahque tleca ijcon onamechchihuili? ");
INSERT INTO ncjNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Namehhuanten nannechnotzahque Tlamachtiyani huan Notecohtzin, huan ic nele quen nanquihtohuahque, tleca nele nehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","In tla nehhuatl, in Tlamachtiyani huan Namotecohtzin namechxopacatoc, noyojqui ijconon nanquitequilisquiyanihque se huan oc seya ica nochin. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nehhuatl namechmacatoc inon tlalnamictilistli, ic namehhuan ijconon xicchihuacan quen nehhuatl nicchiutoc ic namechtequilihtoc masque ocachi hueyi noquisca. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ic nele namechiluiya, quen niyan se tlaquehuali ahhuel mochihua ocachi hueyi quen ipatron huan niyan se tlatitlanili ahhuel mochihuas ocachi hueyi quen in aquin oquihualtitlan. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","In tla nanquinehnehuiliyahque inin tlahtoli huan nanquichihuasque ijcon noyojqui, ic inon nampactosque. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Ahmo nitlahtohtica ica namochtehque; nehhuatl nicmati aquihque niquintlapehpenihtoc. Huan quipiya tlen tzonquisas in tlen quihtohua ipan Itlahcuiloltzin: “In aquin tlacua nohuan, omocuep notecocolihcau.” ");
INSERT INTO ncjNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Inin namechiluiya axan masque ayamo panotoc. Ijcon, ihcuac panos ahmo nanmoxihxicosque ic nanquineltocasque quen nele nehhuatl in Cristo. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ic nele namechiluiya, in aquin quiseliya se de namehhuan quen notlatitlanil, ijcon yes tla nechselis nehhuatl; huan in aquin ijcon nechselis nehhuatl, noyojqui teseliya in aquin onechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Satepa ihcuac omihto inin, in Jesús tequin omoyoltlocoltiloc, huan omoyequihto: ―Ic nele namechiluiya, seya den namehhuan nechichtacahuis. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Oncan in tetlamachticahuan opeuque moixitahque se huan oc seya, niyan ahmo quimatihque aquinon ica tlahtolotica. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Seya den inon tetlamachticahuan, tequin omotlasohtlayaya in Jesús, huan yehhuatl omocaltecho tepa Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Huan Simón Pedro otlamahpilui ic tetlahtlanis ica aquin otlahtoloticatca. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Oncan yehhuatl omopacho tenahuac in Jesús ic otetlahtlani: ―Notecohtzin, ¿aquinon yehhua? ");
INSERT INTO ncjNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Huan Jesús omonanquilic: ―Niyau nicasiyahua se tlacoton in pantzin, huan in aquin nicmacas, yehhua inon. Huan ijcon omochiu. Omoasiyau se tlacoton in pantzin huan oquimacaloc in Judas Iscariote, in iconeu Simón. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Huan san quen oquiseli in pantzin in Judas, in ahmo cuali tlacatl niman oquiyolquitzqui. Oncan Jesús oquiluiloc: ―In tlen tiyau ticchihua, xicchihua ihsiu. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Huan niyan seya den aquin otlacuahticatcahque ahmo oquinehnehuilic tleca omoluic inon. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Huan quen Judas yeh in aquin oquiehuayaya in tomin, sequin oquinehnehuilihque quen Jesús cana omonequiyaya moluis maquicohua itlahtlen para in iluitl, noso maquintlocolis chihton in prohues. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Satepa ihcuac yiquiselihtoc in pantzin, in Judas oquis. Huan yitlayohuatoc. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Satepa ihcuac in Judas yiquistoc, in Jesús omihto: ―Axan motenextilis in nohueyilis nehhuatl aquin Nitetiachicau ica nochin tlacatl, huan motenextilis in tehueyilistzin Dios ica tlen nicchihuas. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Huan tla ica nehhuatl monextilis in tehueyilistzin Dios, oncan Dios nechueyililos noyojqui ompa neluicac canin ilohuac, huan mochihuas ihsiu. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Notlasohconehuan, ayacmo nihuehcahuis namohuan. Namehhuanten nannechtemosque, huan quen yoniquiniluic in oc sequin judeahtecos, noyojqui axan namechiluiya: Ahhuel nanyasque in canin nehhuatl niyau. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Namechmaca inin tlatequiutilistli yancuic; ximotlasohtlacan se huan oc seya. Ijcon quen nehhuatl namechtlasohtla, namehhuanten noyojqui ximotlasohtlacan se huan oc seya. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","In tla nanmotlasohtlahque se huan oc seya, nochin tlacatl quinehnehuilisque quen nele namehhuan notemachticahuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","In Simón Pedro otetlahtlani in Jesús: ―Notecohtzin, ¿canin huilohua? Huan Jesús oquinanquililoc: ―Canin nehhuatl niyau, axan ahhuel tinechcuitlapanuis, huan tinechcuitlapanuis satepa. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Oncan Pedro oteiluic: ―Notecohtzin, ¿tleca tla ahhuel nitecuitlapanuis axan? Nimosentemacatoc nictemactis nonemilis ica Tehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Huan Jesús oquinanquililoc: ―Cox, ¿nele timotemacatoc tictemacas monemilis ica nehhuatl? Ic nele nimitziluiya, ic tzahtzis secpa in pachilel, ica momoucayo, yexpa ahmo tinechmocuitiliya. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Ahmo ximoyoluicatiyecan. Ximotetemachican teca in Dios huan ximotetemachican ica nehhuatl noyojqui. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Canin ilohuac Nohueyitahtzin oncan miyajcan canin nanmochantisque. In tlahmo ijcon yeni, yonamechiluihtoni. Axan niyau nitlayectlali ompa canin nanyesque. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Huan satepa ic niyas huan namechtlayectlalilis canin nanyesque, nihualas oc sepa huan namechuicas, huan namehhuanten nanyesque sansecnin canin nehhuatl niyes. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Namehhuanten nanquimatihque canin niyau, huan nanquimatihque in ohtli. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","In Tomás oteiluic: ―Totecohtzin, ahmo ticmatihque canin huilohua; ¿quenin ticmatisque in ohtli? ");
INSERT INTO ncjNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Oncan Jesús oquinanquililoc: ―Nopampa teahsisque campa ilohuac in Dios. Huan nehhuatl in Tlamelajcatzintli, huan in aquin nechneltocas quiahsis in yancuic nemilistli. San ica nehhuatl cuali teahsisque canin ilohuac in Tohueyitahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Huan quen namehhuanten ahmo nele nannechixmatihque, niyan ahmo onanteixmatihque in Nohueyitahtzin. Huan axan nanteixmatihque, tleca nanteitztoque. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Oncan Felipe oteiluic: ―Totecohtzin, matechcahualo titeitasque in Tohueyitahtzin huan ic inon timocahuasque cuali. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Huan Jesús oquinanquililoc: ―Felipe, yiquipiya tonali namohuan nica, ¿huan tlen, ayamo ticmati aquin nehhuatl? In aquin nechitztoc noyojqui yiteitztoc Tohueyitahtzin. ¿Tleca tinechiluiya manamechcahua nanteitasque in Tohueyitahtzin? ");
INSERT INTO ncjNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Tel, ¿ahmo ticneltoca in tla nehhuatl huan Nohueyitahtzin san se totlamatilis huan ijcon timosetilihtoque? In tlahtoli tlen namechiluihtoc ahmo san noixcohyan. In Tohueyitahtzin aquin notech ilohuac, Yehhuatzin nechmochihuilihtoc quen quimonequiltiya. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Xinechneltocacan quen nehhuatl huan Nohueyitahtzin san se totlamatilis. Huan tlahhuel nanquineltocasque tlen namechiluihtoc, xicneltocacan ica in tlen nicchiutoc. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ic nele namechiluiya, in aquin nechneltoca, cuali quichihuas ijcon quen nicchihua nehhuatl. Huan tlachiuten ocachi huehhueyi cuali quichihuas, tleca nehhuatl niyau canin ilohuac in Tohueyitahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Huan nochin tlen nanquitetlahtlanilisque nopampa, nehhuatl namechchihuilis. Huan ijcon monextilis in tehueyilistzin Tohueyitahtzin ica tlen namechchihuilis. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nehhuatl namechchihuilis nochin tlen nanquitetlahtlanilisque nopampa. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’In tla namehhuanten nannechtlasotlahque, xictlacamatican in notlanahuatiluan. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Huan nehhuatl nitetlatlautis in Tohueyitahtzin mamechualtitlanilican oc seya aquin mechpalehuilos huan mechyolchicahualos, huan nochipa mocahualos namohuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Yeh in Itiotonaltzin Tlamelajcatzintli. Huan in tlalticpac tlacamen ahhuel teselisque, tleca ahmo teitahque niyan ahmo teixmatihque. Huan namehhuanten nanteixmatihque, tleca nican ilohuac namohuan huan nochipa mocahualos namohuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ahmo namechcahuas namosel. Nimocuepas huan niyes namohuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Sa se chihton in tlalticpac tlacamen ayacmo nechitasque, huan namehhuanten nannechitasque. Huan nanquipiyasque yancuic nemilistli, tleca nehhuatl niyoltos. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ipan inon tonali nanquimatisque quen tehuan nimosetilihtoc Notahtzin. Huan nohuan nanmosetilihtoque huan nehhua namohuan nimosetilihtoc. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","In aquin quimati huan quitlacamati in notlatequiutil, yehhua quixnextiya quen nele nechtlasohtla. Huan Notahtzin motlasohtlas in aquin nechtlasohtla, huan nehhuatl noyojqui nictlasohtlas huan nimonextis ica yehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Huan otetlahtlani in oc se Judas, ahmo in Iscariote: ―Totecohtzin, ¿tleca techmonehnextilos ica tehhuanten, huan ahmo ica in tlalticpac tlacamen? ");
INSERT INTO ncjNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Huan Jesús oquinanquililoc: ―In aquin nechtlasohtla quichihuas cuenta in tlen niquihtohua. Huan Notahtzin quitlasohtlalos, huan timocahuasque iyolihtec. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","In aquin ahmo nechtlasohtla, ahmo quichihua cuenta in tlen niquihtohua. In tlahtoli tlen nanquicacticaten ahmo nohuaxca, tlahmo den Tohueyitahtzin aquin onechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Namechiluihtica nochin inin ic oc oncan nica namohuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Huan nitetlatlautis in Tohueyitahtzin mamechualtitlanilo Yehhuatzin in aquin mechtlahtolmacasque, yeh in Itiotonaltzin Dios. Yehhuatzin mechnextililos nochin tlahtoli tlen ayamo nanquinehnehuilihque, huan mechilnamictilos ica nochin tlen namechiluihtoc. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Namechcahuilis huan xicpiyacan in yolsehuilistli tlen namechmacatoc. Inin yolsehuilistli tlen namechmaca, ahmo cahsisque niyan canin nican tlalticpac. Ahmo ximomohsihuican niyan ahmo ximomoutican. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Yonannechcajque quen onamechiluic niyau, huan oc sepa nihualas niyes namohuan. In tla nele nannechtlasohtlanihque, nampactiyanihque tleca niyas canin ilohuac Tohueyitahtzin huan ompa nechueyililos, tleca Yehhuatzin ocachi Chicahuactzin quen nehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Namechiluiya inin achto queman tzonquisas. Huan queman tzonquisas quen niyahtos, ic inon nanquineltocasque nele niCristo. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Ayacmo nihuehcahuis namechnonotzas, tleca oncan huitz in ahmo cuali tlacatl, in aquin tlatequiutis ipan inin tlalticpactli. Huan ahhuel nechtequiutiya yehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Huan axan niyahtos quen nechtequiutilo Tohueyitahtzin, maquimatican in tlalticpac tlacamen quen nehhuatl nitetlasohtla in Tohueyitahtzin. Ximotelquetzacan. Tiyohue den nican. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Nehhuatl quen uvascomecatl huan Notahtzin quen in tequitqui ipan in uvasmili. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Quitlaquixtilos san tlen nomacouyo tlen ahmo quitemaca itlaquilyo. Huan in tlen quitemaca itlaquilyo quitlahtlaquixtilos ic maquitemaca ocachi itlaquilyo. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Namehhuanten quen nanimacouyohuan tlen quitemacahque intlaquilyo tleca nanquichiutoque cuenta ica tlen namechnextilihtoc. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Xiyecan nohuan quenin nehhuatl nochipa niyes namohuan. Se imacouyo ahhuel quitemacas itlaquilyo san isel. Quipiya tlen saliutos ihuan itacayo. No ijcon ca ica namehhuan. Ahhuel nannemisque cuali in tlahmo nanyesque nohuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Nehhuatl quen in uvascomecatl, huan namehhuan quen in imacouyo. In aquin yes nohuan huan nehhuatl niyes ihuan, yehhuatl nemis nochipa ocachi cuali teixpa. Huan in aquin ahmo yes nohuan, ahhuel nemis cuali teixpa. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","In aquin ahmo yesque nohuan, quinchihuilisque quen inmacouyo tlen ahmo quitemacahque itlaquilyo. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’In tla namehhuanten nochipa nanyesque nohuan, huan ahmo nanquilcahuahque in tlen onamechnextili, xictlahtlanican in tlen nanquinequihque, huan nochin mechchihuilisque. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Temahuestilisque Tohueyitahtzin ihcuac namehhuan nannemisque cuali teixpa huan ijcon monextis namehhuan nele notlamachticahuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nehhuatl namechtlasohtla, ijcon quen in Tohueyitahtzin nechtlasohtlalo. Xicchiutiyecan cuenta quen namechtlasohtla huan ic inon xicchiutiyecan in tlen nechpactiya. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","In tla nanquitlacamatihque in notlatequiutiluan, ijcon nanmonextilisque quen nannechtlasohtlahque, ijcon quen nictlacamautoc tetlatequiutil Notahtzin. Huan ijcon nimonextiya quen nitetlasohtla, ijcon quen Yehhuatzin nechtlasohtlalo. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Nehhuatl namechiluiya nochin inin ic xipaquican quen nehhua nipactoc, huan nanyesque ica paquilistli. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Notlatequiutil yeh inin: ximotlasohtlacan se huan oc seya, quen namechtlasohtlahtoc. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","In aquin nele quitlasohtla itenonotzcau ahmo moxihxicohua ic quitemactis inemilis ipampa. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Namehhuanten notenonotzcahuan in tla nanquichihuahque in tlen namechtequiutiya. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ayacmo namechnotzas tlaquehualten, tleca in tlaquehuali ahmo quimati tlen quichihua in ipatron. Namechnotza notenonotzcahuan, tleca namechmatiltihtoc nochin tlen nechiluihtoc Notahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Namehhuanten ahmo onannechtlapehpenihque nehhuatl, tlahmo nehhuatl onamechtlapehpeni. Huan namechmacatoc namotequiu xiyacan canin namechtitlani huan xinemican molui cuali teixpa. Ijcon nanquintlaneltoctisque ica nehhuatl. Huan tla nanquitlacamatisque inin tlahtoli, in Tohueyitahtzin mechmacalos nochin tlen nantetlahtlanilisque. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Inin in tlen namechtequiutiya; ximotlasohtlacan se huan oc seya. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Tla mechcocoliyahque in tlacamen, xicmatican quen achto onechcocolihque. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","In tla namehhuan nanquisematinihque inuan in tlalticpac tlacamen, mechtlasohtlanihque quen yehhuan motlasohtlahque. Huan nehhuatl onamechtlapehpeni den tlalticpac tlacamen, huan yeh in ica in tlacamen mechcocoliyahque, tleca ayacmo nampoutoque inuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Xiquilnamiquican in tlen onamechiluic: “Niyan se tlaquehuali ahhuel mochihuas ocachi hueyi quen ipatron.” Ijcon quen nechmohsihuiyahque, ijcon noyojqui mechmohsihuisque. Huan in tla quitlacamautoque in notlanextilil, noyojqui quitlacamatisque namotlanextilil. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nochin inin mechchihuilisque tleca nannotlamachticahuan, huan tleca ahmo teixmatihque in aquin onechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Yehhuanten ahmo tlahtlacoltihtonihque tla nehhuatl ahmo nihualani niquinmonextilini quen ilohuac Tohueyitahtzin. Huan axan tlahtlacoltihtoque tleca ahmo nechchihuiliyahque cuenta. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","In aquin nechcocoliyahque noyojqui tecocoliyahque in Notahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ahmo tlahtlacoltihtonihque in tla nehhuatl ahmo nicchihuani inixpa inohque tlachiuten tlen niyan aquin oc seya cuali quichihuas. Huan masque oquitaque inon tlachiuten, techcocoliyahque nehhuatl huan Notahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Inin panohua matzonquisas inin tlahtolten tlen ca tlahcuiloli ipan intlanahuatil: “Onechcocolihque san tlaluis.” ");
INSERT INTO ncjNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Huan ihcuac hualuilohuas Yehhuatzin in aquin quintlahtolmacalo, in aquin namechualtitlanilis ic Notahtzin, Yehhuatzin tlahtolos ica nehhua. Yeh in Itiotonaltzin tlen in Tlamelajcatzintli aquin quixohua teca Tohueyitahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Huan namehhuanten noyojqui noca nantlahtosque, tleca nanyetoque nohuan den achto. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Namechiluiya inin tlahtolten ic ahmo nanmoxihxicosque ica tlen mechpanos. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Mechquixtisque ipan in tiopanten, huan ahsis in tonali tla seya quimictis se de namehhuan, ic inon quinehnehuilis nele tehuan tequiutica in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Inin quichihuahque tleca ahyic teixmautoque in Tohueyitahtzin, niyan nehhuatl ahmo nechixmautoque. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Namechiluiya axan ica tlen panos. Huan ihcuac mechahsis inon tonali, xiquilnamiquican quen nehhuatl yinamechiluihtoc. ’Ahmo yonamechiluihtoc achto in tlen axan namechiluihtica, tleca namohuan onicatca. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Huan axan niyau ic tehuan niyes in aquin onechualtitlaniloc. Huan niyan seya den namehhuan ahmo nannechtlahtlaniyahque canin niyau. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Huelis onantlocoxque tleca onamechiluic inin tlahtoli. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Huan namechiluiya in tlen nele. Ocachi cuali para namehhuan maniyau. In tlahmo niyas, ahmo hualuilohuas Yehhuatzin aquin quintlahtolmacalos. Huan maniyau, neh nitehualtitlanis. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ihcuac hualuilohuas Yehhuatzin, quinmatiltilos in tlacamen quen nele tlahtlacolyohque. Huan quinmatiltilos quenin cuali quixtlapachosque intlahtlacol. Huan quinmatiltilos ica in tlixcomacalistli tlen hualas. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Quintlahtlacoltilos tleca ahmo nechneltocahque. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Huan quinmatiltilos quenin nitlapanotoc ica intlahtlacol huan monextis quen onictlamichiu tleca niyau canin ilohuac Tohueyitahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Huan quinmatiltilos ica in tlixcomacalistli tlen hualas, tleca yonictlan in ahmo cuali tlacatl aquin tlatequiutiya nican tlalticpac. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Nicpiya oc sequin tlahtoli tlen namechiluisnequi huan ahhuel nanquinehnehuilisque axan. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ihcuac hualuilohuas in Itiotonaltzin tlen Tlamelajcatzintli, Yehhuatzin mechnextililos nochin tlen melahuac. Tleca ahmo tlahtolos san teixcohyan, tlahmo mihtos nochin san tlen tecaquilos, huan mechmatiltilos ica in tlen panos. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yehhuatzin mechyecmatiltilos in tlen ayamo yec nanquinehnehuiliyahque ica notlamatilis, huan ijcon nechmohueyililos. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Huan notlamatilis ijcon quen tetlamatilis Tohueyitahtzin. Yeh in ic onamechiluic Yehhuatzin aquin quintlahtolmacalo mechyecmatiltilos ica notlamatilis. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Sa se chihton huan ayacmo nannechitasque, huan chihton satepa oc sepa nannechitasque. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Oncan sequin tetlamachticahuan omotlahtlanihque se huan oc seya: ―¿Tlen quihtosnequi inin tlen techiluilo; sa se chihton huan ayacmo nannechitasque, huan mach chihton satepa oc sepa nannechitasque? ¿Huan tlen quihtosnequi inon tlahtoli, mach, “tleca niyau canin ilohuac Tohueyitahtzin”? ");
INSERT INTO ncjNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Tel, ¿tlen quihtosnequi inon tlahtoli, “sa se chihton”? Ahmo ticnehnehuiliyahque ica tlenon quihtolohtica Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","In Jesús omonehnehuili quen oquinequiyayahque tetlahtlanisque, huan oquiniluiloc: ―Nehhuatl onamechiluic quen sa se chihton ayacmo nannechitasque, huan oc sepa se chihton nannechitasque. ¿Yeh in tlen ic nanmotlahtlaniticaten? ");
INSERT INTO ncjNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ic nele namechiluiya, quen namehhuan nanchocasque huan nantlocoxtiyesque, huan in tlalticpac tlacamen paquisque. Huan masque namehhuan nantlocoxtiyesque, ic oc chihton nampaquisque. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ihcuac se sihuatl yau moconetlaliya, mococohua tleca yoahsic in tonali den tlatlalistli. Satepa ihcuac yitlacati in iconeu, niyan ahmo quilnamiqui in tlatlalistli, tlahmo tequin paquis tleca yotlacat se conetl ipan in tlalticpactli. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ijconon noyojqui, namehhuanten nantlocoyahque axan. Huan ihcuac nehhuatl nihualas namechita oc sepa, ic inon nanyolpaquisque. Huan inon paquilistli niyan aquin ahhuel mechcuilis. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Ipan inon tonali ayacmo nanquipiyasque tlen nannechtlahtlanisque ica itlahtlen. Ic nele namechiluiya, quen in Tohueyitahtzin mechmacalos nochin tlen nantetlahtlanilisque tleca nannechneltocahque. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hasta axan ahmo tlen nantetlahtlanilihtoque tleca nannechneltocahque. Xictlahtlanican huan nanquiselisque, ic maahsito namopaquilis. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Namechiluihtoc inin tlahtoli ica tlanextilistli. Hualahsis in tonali queman ayacmo namechnonotzas ica in tlanextilisten, tlahmo namechyecnonotzas quen ilohuac in Tohueyitahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ipan inon tonali nantetlahtlanilisque tleca nannechneltocahque, huan ahmo huelica namechtlaihtlanis ica in Tohueyitahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Tleca in Tohueyitahtzin yimechtlasohtlaloc. Mechtlasohtlalo Yehhuatzin tleca namehhuan nannechtlasohtlahque, huan nanquineltocatoque quen onihuala den Tohueyitahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Onihualquis tetlamatiyan in Tohueyitahtzin ic onihuala ipan inin tlalticpac, huan axan nicautehua inin tlalticpac ic nimocuepas canin ilohuac in Tohueyitahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Oncan in tetlamachticahuan oquihtohque: ―Axan nele yec tlahtolohtica, huan ahmo ica tlanextilistli. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Axan ticnehnehuiliyahque quen momati nochin tlahtoli huan ic inon niyan aquin quipiya tlen tetlahtlanis ica tlen quimatisnequi, tleca yimomati tlen tetlahtlanini. Huan ic inin ticneltocahque quen ic nele ohualuilohuac den Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Huan Jesús omonanquilihque: ―Cuali in tla axan nanquineltocahque. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Huan yihualahsitihuitz in horas, huan ayacmo huehcau, queman namehhuanten namochachayahuasque nanyasque namochahchan, huan nannechcahuasque nosel. Huan ahmo nele niyes nosel, tleca nohuan ilohuas in Tohueyitahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Namechiluiya nochin inin ic xinechyecneltocacan huan ijcon nancahsisque in yolsehuilistli. Ipan in tlalticpac namehhuan nancahsisque in tlamohsihuilistli. Huan ximoyolchicahuacan, tleca yonicpanolti ica nochin tlen tlamohsihuiya ipan in tlalticpac. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Satepa ic omihto inin tlahtoli, in Jesús oahcotlachiyaloc ic neluicac huan omihto: ―Nohueyitahtzin, in hora yoahsico. Xiquinnextilili ica nohueyilistzin nehhuatl in aquin tetlasohconetzin ica tlen panos huan ijcon niquinnextilis mohueyilistzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tleca Tehhuatzin nechmomaquilihtoc tequihuahyotl ica nochin tlacamen, ic maniquinmaca nemilistli nochipa nochten aquin nechmacalotoc. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","In aquin quiahsis in nemilistli nochipa huelica teixmati Tehhuatzin aquin in san se Dios Tlamelajcatzintli, huan nechixmati nehhuatl Jesucristo, aquin Tehhuatzin onechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Nehhuatl niquinnextilihtoc mohueyilistzin ipan inin tlalticpac, huan yitlantiu in tlen onechtequiutiloc manicchihua. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Axan tel, Nohueyitahtzin, xinechmohueyili ompa tehuan quen onicatca den achto ic oquichihualo in tlalticpac. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’In tlacamen aquin Tehhuatzin otiquinmotlapehpenili ic otinechmomacaloc, niquinmatiltihtoc ica Tehhuatzin. Ocatcahque tehuaxcahuan, huan Tehhuatzin otinechmomaquilic, huan oquitlacamatque in tetlahtoltzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Axan quimatihque in nochin tlen niquihtohua san inon tlen Tehhuatzin onechiluiloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Huan niquinmatiltihtoc in tetlanextilil tlen onechmatiltiloc, huan yehhuanten oquiselihque. Yomomacaque cuenta quen ic nele onihuala den Tehhuatzin, huan quineltocatoque quen Tehhuatzin onechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Nehhuatl nitetlatlautiya xiquinmohuelitili yehhuanten, huan ahmo nitetlatlautiya ica in oc sequin tlacamen, tlahmo san ica yehhuan aquin otinechmomaquilic tleca yehhuan tehuaxcahuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nochin tlen nohuaxca noyojqui tehuaxca, huan in tlen tehuaxca noyojqui nohuaxca huan yehhuan nechmohueyiliyahque. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Nehhuatl ayacmo niyes ipan in tlalticpactli, huan yehhuanten mocahuasque ipan in tlalticpactli huan nehhuatl niyau ic tehuan niyes. Nohueyitahtzin, xiquinmoixpiyali ica techicahualis in aquin onechmomacaloc ic mayecan nochipa mosetilihtoque, quen Tehhuatzin huan nehhuatl timosetilihtoque. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ihcuac inuan onicatca inin notlamachticahuan, oniquinixpiyaya ica techicahualistzin inihque aquin otinechmomaquilic. Oniquinixpix ica in ahmo cuali, huan niyan seya ahmo opoliu, tlahmo san yeh in aquin opoliu ic matzonquisa in tlen quihtohua ipan in Itlahcuiloltzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Axan yiniyau canin Tehhuatzin ilohuac. Huan ic oc nican nica ipan inin tlalticpactli, niquihtohua inin tlahtoli maniquimpacmaca inihque notlamachticahuan quen nehhuatl nipactoc. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nehhuatl niquinmatiltihtoc in tetlahtoltzin huan in tlalticpac tlacamen oquinixtlasahque, tleca yehhuan ayacmo poutoque ica in tlalticpac tlacamen, quen nehhuatl noyojqui ahmo nipoutoc ica in tlalticpac tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ahmo nitetlatlautiya maquinquixtilo den tlalticpac, tlahmo maquinixpiyalo, ahmo maquintlapolochti in ahmo cuali tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ijconon quen nehhuatl ahmo nipoutoc inuan in tlalticpac tlacamen, yehhuanten noyojqui ahmo poutoque inuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Maquinsecnintlalilo ica Tehhuatzin, huan maquinnemiltilo ica in tlen melahuac. In tetlahtoltzin yeh in tlamelajcan. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Quen onechualtitlaniloc ica in tlalticpac tlacamen, ijcon noyojqui niquintitlani maquinnonotzacan ica tetlahtoltzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Huan nimosecnintlali ic nimiquis impampa, huan ic inon mamosecnintlalican ipan intequiu tlamelajcan. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Ahmo nitetlatlautiya san ica inihque, tlahmo noyojqui ica yehhuan aquin oc quineltocasque ica nehhuatl satepa ic quicaquisque intlahtol inohque notlamachticahuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nitetlahtlaniliya quen nochten yehhuan mayecan mosetilihtocan. Ijcon mayecan san se ololi mosetilihtosque tohuan, Nohueyitahtzin, ijcon quen Tehhuatzin ilohuac nohuan huan nehhuatl tehuan nica. Mayecan yec mamosetilihtocan huan ic inon in tlalticpac tlacamen maquineltocacan quen ic nele Tehhuatzin onechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Onechualtitlaniloc nican tlalticpac ica tetequihuahyo huan ijcon mahsitoc temahuestilis. Huan ijcon niquinmacatoc notequihuahyo ic maahsis temahuestilis ica yehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nehhuatl niquinyolmautoc ica yehhuan, huan Tehhuatzin moyolmatilotoc ica nehhuatl, mamoyecsechihuacan yehhuan notlamachticahuan. Huan ijcon in tlalticpac tlacamen quinehnehuilisque quen Tehhuatzin onechualtitlaniloc, huan tequin quintlasohtlalo ijcon quen nechtlasohtlalo. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Nohueyitahtzin, nicnequi mayecan nohuan canin niyetos yehhuan aquin nechmacalotoc. Ijcon maquitacan quen tinechmohueyilihtoc. Tleca tinechmotlasohtlalohtoc ic achto opeu in tlalticpac. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Nohueyitahtzin, in aquin Tlamelajcatzintli, in tlalticpac tlacamen ahmo teixmatihque. Nehhuatl queme niteixmati, huan inihque aquin tohuaxca yiquimauticaten quen Tehhuatzin onechualtitlaniloc. ");
INSERT INTO ncjNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Niquinmatiltihtoc tetlamatilis, huan oc ijcon niquinmatiltihtiyes ica Tehhuatzin, maquintequiutilo in tetlasohtlalis ica tlen nechtlasohtlalo huan manimosetilis inuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Satepa ihcuac omotlamiihto inin tlahtolten, in Jesús oquixohuac inuan tetlamachticahuan huan ohuilohuac ic sentlapal in atlautli itoca Cedrón. Ompa ocatca se tlamiloli canin Jesús ocalacohuac ihuan tetlamachticahuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Noyojqui in Judas, in aquin otetemactihticatca, yehhua oquixmatiyaya inon tlamiloli, tleca miyacpa in Jesús omosentlalilohuaya inuan tetlamachticahuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ijcon in Judas oahsito ompa ihuan se ololi den soldados huan oc sequin topilihten den tiopantli, intlatitlanil in hueyixtoque den tiopixcamen huan den fariseos. Oquihuicayayahque intepos huan intlahtlanex. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Huan quen Jesús yimomautica in tlen yau tepanohua, oquixohuac huan oquitlahtlaniloc: ―¿Aquin nanquitemohuahque? ");
INSERT INTO ncjNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Yehhuanten otenanquilihque: ―Tictemohuahque in Jesús ialtepeu Nazaret. Huan Jesús oquinnanquililoc: ―Nehhuatl niJesús. Huan ompa inuan ocatca in Judas, aquin oteichtacatemactihticatca. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Huan ihcuac Jesús oquiniluiloc: “Nehhuatl niJesús”, omotzinquisque huan ohuetzque tlalpa ica moucayotl. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Oncan Jesús oc sepa oquintlahtlaniloc: ―¿Aquin nanquitemohuahque? Huan yehhuan oquihtohque: ―Tictemohuahque in Jesús ialtepeu Nazaret. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Oncan Jesús oquiniluiloc: ―Yonamechiluic quen yinehhuatl in Jesús. In tla nehhuatl nannechtemohuahque, xiquincahuacan inin oc sequin mayacan. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Inin opanoc ic matzonquisa in tlen Jesús omihto: “Ica yehhuan aquin onechmacaloc, Nohueyitahtzin, ahmo opoliu niyan seya.” ");
INSERT INTO ncjNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Oncan Simón Pedro, quen oquipiyaya se espada, oquiquixtic huan oquinacastzontec se den tlacamen itoca Malco, itlaquehual in hueyixtoc den tiopixcamen. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Huan Jesús oquiluiloc in Pedro: ―Xiquehua in espada. Huelica nicselis inin tlapanolistli quen monequis Tohueyitahtzin, masque molui tequiyo. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Oncan in soldados den ololi, ihuan incomandante, huan in topilihten den judeahtecos otequitzquihque in Jesús huan oteilpihque. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Oncan niman otehuicaque ichan in Anás. Anás imonta in Caifás, in aquin ocatca in hueyixtoc den tiopixcamen inon xihuitl. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Inin Caifás yiyehhua aquin oquiniluic in judeahtecos mach ocachi cuali para yehhuanten mamiqui san se tlacatl impampa in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","In Simón Pedro huan oc se tetlamachticau otecuitlapanuihtayahque in Jesús. Huan moixmatihque inon oc se tetlamachticau huan in hueyixtoc den tiopixcamen. Huan ijcon yehhuatl ocalac tehuan in Jesús ipan in icaltenco den ical in hueyixtoc den tiopixcamen. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Huan in Pedro omocau quiahuac, ipan puerta. Huan ic inon oquis inon tetlamachticau, in aquin quixmati in hueyixtoc den tiopixcamen, huan ihcuac otlahto ica in ichpochtli aquin tlachiya ipan puerta, oquicalaqui in Pedro. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Oncan in tlachixqui den puerta oquitlahtlani in Pedro: ―¿Ahmo noyojqui tehhua se itlamachticau inon tlacatl? Huan Pedro oquinanquilic: ―Ahmo, nehhuatl ahmo. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Huan quen osehuayaya, in tlaquehualten huan in topilihten oquitlalihque se tlecuili huan ihihcaticaten moscohticaten. Pedro noyojqui ompa inuan ocatca, omoscohticatca itenco in tletl. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","In hueyixtoc den tiopixcamen opeu tetlahtlaniya in Jesús ica aquin yehhuan in tetlamachticahuan huan tlen inon omonextiliyayahque. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Huan Jesús oquiluiloc: ―Nehhuatl nitlanonotztoc in miyacaixpa. Nochipa oniquinnextiliyaya ipan in hueyi tiopantli huan ipan in tiopanten canin mosentlaliyayahque in judeahtecos. Ahyic queman tlen niquihtohtoc san ichtaca. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Tleca tinechtlahtlaniya? Maquintlahtlani in aquihque nechtlahtolcactoque, huan yehhuanten maquihtocan ica tlenon niquinnonotztoc. Yehhuanten quimatihque in tlen niquihtohtoc. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Queman Jesús omihto inin, se den topilihten den tiopantli aquin ompa ocatca, oteixtecapani huan otetlahtlani: ―Tel, ¿ijcon ticnanquilis in hueyixtoc den tiopixcamen? ");
INSERT INTO ncjNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Huan Jesús omonanquilic: ―In tla oniquihto itlahtlen ahmo cuali, xiquihto in tlen ahmo cuali oniquihto; huan tla oniquihto in tlen cuali, ¿tleca tinechtehuiya? ");
INSERT INTO ncjNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Oncan Anás oquintequiuti mateilpican in Jesús, huan otetitlan in Caifás, in hueyixtoc den tiopixcamen. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ic ocachi in Pedro san ijcon ihcatica moscohtica inahuac in tlecuili, huan oquitlahtlanihque: ―Tel, ¿ahmo tehhua se titlamachticau inon tlacatl? Huan Pedro ahmo otemocuitiyaya, huan oquihto: ―Ahmo, ahmo nehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Oncan oquitlahtlani se itlaquehual in hueyixtoc den tiopixcamen, inon ipariente in tlacatl aquin Pedro oquinacastzontec: ―¿Tlen, cana ahmo onimitzitac ihuan ipan in tlamiloli? ");
INSERT INTO ncjNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Huan Pedro oc sepa ahmo otemocuitiyaya, huan san ic inon chihton otzahtzic se pachilel. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Oncan otehuicaque in Jesús den ichan in Caifás hasta ipan in cali den tequihua, itoca Pilato. Yopeu tlatui ipan in tonali achto den pascuahiluitl. Huan in judeahtecos ahmo ocalajque ipan in palacio, tleca ahmo quincahuilihtoc macalaquican canin calaquihque in aquin ahmo judeahtecos tla quicuasque in tlacuali den pascuahiluitl. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yeh in ica in Pilato oquis ic quinnonotzas, huan oquiniluic: ―¿Tlen ica nanquiteluiyahque inin tlacatl? ");
INSERT INTO ncjNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Yehhuanten oquinanquilihque: ―In tlahmo oquichiu in ahmo cuali, ahmo timitzmactilihtonihque. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Oncan in Pilato oquiniluic: ―Xicuicacan namehhuanten, huan xiquixcomacacan quen ca ipan in namotlanahuatil. Huan in judeahtecos oquinanquilihque: ―Huan tehhuanten tijudeahtecos ahmo techcahuilihtoc ic ticmictisque niyan aquin. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ijconon otzonquis in tlen Jesús omihto ica quenin mopiya micohuas ipan cruz. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","In Pilato oc sepa ocalac ipan in ipalacio, huan otenotz in Jesús huan otetlahtlani: ―Tel, ¿tehhuatl in hueyixtoc den judeahtecos? ");
INSERT INTO ncjNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Huan Jesús oquinanquililoc: ―Tel, ¿ijcon tlahtlanilohtoc tehhuatzin ica motlanehnehuilis, noso tleca oc sequin yomitziluihque ica nehhuatl? ");
INSERT INTO ncjNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","In Pilato otenanquilic: ―¿Cana ticnehnehuiliya nehhuatl no nijudeahteco? Yehhuan den mochantlacahuan huan in achtohque den tiopixcamen, inohque in aquin omitztemactihque ica nehhuatl. ¿Tlen inon ticchiutoc? ");
INSERT INTO ncjNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Oncan Jesús oquinanquililoc: ―In campa nihueyixtoc ahmo ipan in tlalticpac. Tla de nican yeni, in aquin nechcuitlapanuiyahque motehuinihque, ahmo maniyeni nitlatemactili inmajco in judeahtecos. Huan in campa nihueyixtoc ahmo nican tlalticpac. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Oncan Pilato otetlahtlani: ―Ijcon tel, ¿tehhuatl in hueyixtoc? Huan Jesús omonanquilic: ―Nihueyixtoc, quen tehhuatzin mihtohua. Nehhuatl ic inon onitlacat huan onihuala ipan in tlalticpac manitlanonotza ica tlen melahuac. Nochten in aquin quimatisnequihque in tlen melahuac nechcaquisque in tlen neh niquihtohua. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","In Pilato otetlahtlani: ―¿Huan tlenon in melahuac? Satepa ic otlan tetlahtlaniya, in Pilato oquis oc sepa quinnotza in tequihuahten den judeahtecos huan oquiniluic: ―Nehhuatl ahmo nicahxiliya niyan tlen tlahtlacoli ica inin tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Huan namehhuanten nanmomautoque quen mach nehhua manicahcahua ica namehhuan se motzacuani ipan in pascuahiluitl. Tel, ¿nanquinequihque manicahcahuas in hueyixtoc den judeahtecos? ");
INSERT INTO ncjNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Oncan nochtehque opeuque coutzahtzihque: ―¡Inon ahmo! ¡Xicahcahua in Barrabás! Huan inon Barrabás ocatca tlachtejqui. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Oncan Pilato otequixtic in Jesús huan otetitlan ic matehuihhuitequican. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Huan satepa ic otehuihhuitejque, in soldados otecuahuiltihque in Jesús se corona tlachihchiutli nochin huetztli. Huan otetlaquentihque ica se tetlaquen chichilticatliltic. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Oncan omopachohque tenahuac ic teahuiltihque, huan teiluiltihque: ―¡Ocachi cuali in hueyixtoc den judeahtecos! Huan oteixuitequiyayahque ipan texayac. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Oncan Pilato oc sepa oquis, huan oquiniluic in tequihuahten: ―Xiquitacan, niquixtis nican ic xicmatican quen ahmo nicahxiliya niyan se tlahtlacoli. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Huan oquixohuac in Jesús, ihuan in corona den huetztli ipan tetzonteco huan in tetlaquen chichilticatliltic. Oncan in Pilato oquiniluic in judeahtecos: ―¡Nicanca in tlacatl! ");
INSERT INTO ncjNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ihcuac oteitaque, in achtohque den tiopixcamen opeuque coutzahtzihque: ―¡Xicmasohualtican; mamiqui ipan in cruz! In Pilato oquiniluic: ―Pos, xicuicacan san namehhuan huan xicmictican ipan in cruz, tleca nehhuatl ahmo tlen nicahxiliya itlahtlacol. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Huan in judeahtecos oquinanquilihque: ―Tehhuanten ticpiyahque se tlanahuatili, huan quen ca ipan in totlanahuatil, quipiya tlen miquis, tleca oquihto Iconetzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ic oquicac inin, in Pilato ocachi omomouti. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Huan ocalac oc sepa ipan in palacio, huan otetlahtlani in Jesús: ―Tel, ¿de canin tehhuatl? Huan in Jesús ahmo tlen omonanquilic. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Oncan Pilato oteiluic: ―¿Tlen tel, ahmo tinechnanquiliya? ¿Ahmo ticmati quen nehhuatl nicpiya tequihuahyotl ic nimitzmictis ipan in cruz huan nicpiya tequihuahyotl noyojqui ic nimitzcahcahuas? ");
INSERT INTO ncjNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Huan Jesús oquinanquililoc: ―Ahmo mopiyas niyan tlen tequihuahyotl ica nehhuatl in tlahmo tlen temacalotoc in Dios. Yeh in ica in aquin onechtemacti moixpa ocachi quipiya hueyi tlahtlacoli huan ahmo tehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ihcuac inon in Pilato oquitemohuaya quen quichihuas ic tecahcahuas in Jesús. Huan in tequihuahten den judeahtecos oquitzahtzilihque: ―¡In tla ticahcahuas inon tlacatl, ahmo titlasohcau in hueyixtoc romanohteco! San aquin mochihua hueyixtoc, inon itecocolihcau in hueyixtoc romanohteco. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ic oquicac inin, in Pilato otlatequiuti matequixtican in Jesús. Huan Pilato omotlali canin tlixcomaca huan ica in tlahtoli hebreo yeh canin itoca Gabata, tlen quihtosnequi mach, Tetehtla. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ocatca in tonali achto den pascuahiluitl, cana chicuasin hora sancuel. Oncan in Pilato oquiniluic in judeahtecos: ―¡Nicanca in hueyixtoc den namehhuan! ");
INSERT INTO ncjNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Huan yehhuanten ocoutzahtzihque: ―¡Mamiqui! ¡Mamiqui ipan in cruz! In Pilato oquiniluic: ―¿Tlen tel, cuali nicmictis in hueyixtoc den namehhuan? Huan in achtohque den tiopixcamen oquinanquilihque: ―Tehhuanten ahmo ticpiyahque oc se hueyixtoc, tlahmo san yeh in tequihua romanohteco. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ic inin, in Pilato otetemacti ic matemictican, huan yehhuanten otehuicaque. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesús oquixohuac momamahtiu in cruz, ic huilohuas in itocahyan Tzontecontla, tlen ica in tlahtoli hebreo itoca Gólgota. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ompa otemasohualtihque mamicohua ipan in cruz, huan inuan ome tlacamen noyojqui oquinmictihque, sehsen ic tenahnahuac oquintelquetzque incruz, huan Jesús tlanepantla omocahualoc. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","In Pilato otlatequiuti maquitlalican itzoncuac in cruz sequin tlahtoli tlen quihtohua: “Jesús den Nazaret, hueyixtoc den judeahtecos.” ");
INSERT INTO ncjNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Miyacten in judeahtecos oquipouque inon tlahcuiloli, tleca in canin otemictihque in Jesús ahmo huehca den altepetl. Huan in tlahcuiloli tlachihchiutli ica hebreo, itlahtol in judeahtecos, huan ica latín, itlahtol in romanohtecos, huan ica griego. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Huan ic inon in achtohque den tiopixcamen den judeahtecos oquiluihque in Pilato: ―Ahmo xiquihcuilo, “hueyixtoc den judeahtecos.” Ocachi cuali xiquihcuilo, “In aquin quihtohua nehhuatl nihueyixtoc den judeahtecos.” ");
INSERT INTO ncjNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Huan in Pilato oquinnanquilic: ―In tlen oniquihcuilo, ijcon mamocahua. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Satepa ihcuac in soldados otemasohualtihque in Jesús, oquiololohque in tetlaquen huan oquixelohque. Sehsen omoxeluihque ica in nahue soldados. Oquianque noyojqui in tepampijca huan quen ahmo tlahtzontli, tlachihchiutli san se hueyi tatapahtli, ");
INSERT INTO ncjNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","in soldados omoluihque se huan oc seya: ―Ahmo tictzomonisque. Ocachi cuali tictlasasque suertes huan ic inon tiquitasque aquinon quihuicas. Ijcon otzonquis in tlahcuiloli tlen quihtohua: “Omoxehxeluihque notlaquen, huan oquitlasque suertes ihtech.” Yeh in tlen oquichiuque in soldados. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Inahuac in cruz den Jesús ompa ocahcatca in tenana, huan in icniu in tenana, huan María isihuau in Cleofas, huan in María Magdalena. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Queman Jesús oquitaloc in tenana ihuan ihcatilotica in tetlamachticau in aquin tequin omotlasohtlayaya, oteiluic in tenana: ―Sihuatzintli, mamopiya inin tlacatl quen moconeu. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Niman oquiluiloc inon tetlamachticau: ―Axan mamopiya inin sihuatzintli quen monana. Huan ic inon oquihuicac ichan inon tetlamachticau. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Satepa de inin, quen Jesús momautica nochin yotzonquis, huan sa ic matzonquisa in tlen tlahcuiloli, Yehhuatzin omihto: ―Niamiqui. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ompa ocatca se xalo tentica den vino xococ. Oncan oquipaltilihque se esponja ipan in vino, huan oquitlalihque ihtech se acatl itoca hisopo huan otecamahuiltihque. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","In Jesús omonic in vino xococ, huan niman omihto: ―Nochin yotzonquis. Oncan omocuanecuiloloc, huan omicohuac. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yeh in tonali achto den pascuahiluitl, huan in tequihuahmen den judeahtecos ahmo oquinequiyayahque in mijcamen mamocahuacan ipan in cruz ipan in tonali den nesehuilistli, tleca inon tonali den nesehuilistli tequin mahuestic. Yeh in ica oquiluihque in Pilato maquintitlani ic maquinxopostequican in aquin catehque ipan incruz, ocachi ihsiu mamiquican. Huan maquinihcuanican intlacayo de ompa. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Oncan in soldados oyahque huan oquixopostejque in achto, huan noyojqui in oc seya in aquin ocatcahque ipan incruz tenahuac in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Huan ic omopachohque tenahuac in Jesús, oteitaque quen yimicohuatoc, huan ic inon ayacmo otexopostejque. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Huan seya den soldados oteyeltoquili ica se cohuitl yecateposyo, huan ic inon ohualquis yestli huan atl. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","In nehhuatl aquin niquintlahcuiluiya inin, nictlalitoc tlen oniquitac, huan niquihtohua in tlen melahuac. Huan nicmati in tlen niquihtohua nochin melahuac, ic namehhuanten noyojqui xicneltocacan. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Tleca inin opanoc matzonquisa in tlahcuiloli quen quihtohua: “Ahmo maquipostequican niyan se ohmitl.” ");
INSERT INTO ncjNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Huan ca oc se lado ipan in tlahcuiloli canin quihtohua: “Teitasque in aquin oteyeltoquilihque.” ");
INSERT INTO ncjNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Satepa de inin, José, den altepetl Arimatea, oquitlahtlanili in Pilato in tetlacayo in Jesús maquihuica. In José noyojqui tetlamachticau in Jesús, masque san ichtaca tleca quinmoucaita in tequihuahmen den judeahtecos. Pilato oquicahuili in José matetemohui in Jesús. Oncan oya huan oquihuicac in tetlacayo. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Noyojqui in Nicodemo, in aquin ohuiya tenohnotza in Jesús se tlayohua ihcuac opehualoc tetequiu, yeh oahsito quihuica cana sempohuali huan mahtlactli kilo den pahtli, tlatlanel den mirra huan áloes. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ijcon in José huan Nicodemo otehuicaque in tetlacayo in Jesús huan otepihpiquihque ica in miyac tatapahtli huehueyac ihcuac ihtech oquichayahuilihque inon pahtli. Ijcon otetlalilihque tleca in judeahtecos ijconon quintocahque in mijcamen. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","In canin otemictihque in Jesús ipan in cruz ocatca se tlamiloli inahuac, huan ipan inon tlamiloli ocatca se tlaltecochtli icxitlan in tepetl canin niyan aquin ayamo oquitocatoyahque. ");
INSERT INTO ncjNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Inon tlaltecochtli ahmo huehca huan ompa otetlalihque in tetlacayo in Jesús, tleca yi ipeuyan in tonali den nesehuilistli den judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ipan in achto tonali den semana, in María Magdalena oya molui sancuel caninca in tlaltecochtli. Huan ayamo otlatui. Huan oquitac quen yitlaihcuanili in tetl tlen ic otentzactoya in tlaltecochtli. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Oncan otzecuin huan oquinahsi in Simón Pedro huan in oc se tetlamachticau in aquin Jesús tequin omotlasohtlayaya, huan oquiniluic: ―Otehuicaque in Totecohtzin den tlaltecochtli, huan ahmo ticmatihque canin otetlalitohque. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Oncan Pedro huan in oc se tetlamachticau oquisque huan oyahque canin ca in tlaltecochtli. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","In inehuan oyahque tzetzecuini san secnin, huan in oc seya ocachi otzecuin quen in Pedro huan achto oahsic canin ca in tlaltecochtli. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Oncan onahualachix, huan oquitac in tatapahtli huehueyac ompa huetztoc, huan yehhua ahmo ocalac. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saniman oahsic in Simón Pedro icuitlapa in oc seya, huan yehhuatl ocalac ipan in tlaltecochtli. Huan noyojqui oquitac in tatapahtli huehueyac ompa huetztoc. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Huan noyojqui oquitac in oc se tatapahtli ic tlen otecuayalotoyahque in Jesús. Ahmo ocatca san secnin ihuan in tatapahtli huehueyac, tlahmo oixquimiliutoya huan ocatca secnin. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Oncan ocalac noyojqui in oc se tetlamachticau in aquin achto oahsic inahuac in tlaltecochtli, huan oquitac in tlen opanoc, huan oquineltocac nele oihxohuac. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pos ayamo oquimatiyayahque in tlahtoli tlen yihuehcau ihcuiliutoc quen Jesús omopiyaya tlen ihxohuas den mijcamen. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Oncan inon tetlamachticahuan omocuepque inchan. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Huan in María omotzeco quiahuac inahuac in tlaltecochtli, chocatica. Ic ochocaticatca, omoixpacho nahualachiya iihtec in tlaltecochtli. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Huan oquinitac ome ángeles tlaquentitoque ihistac, huan yehyehuatoque canin ocatca in tetlacayo in Jesús. Seya ocatca ic tetzoncuac huan oc seya ic teicxitla. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Huan in ángeles oquitlahtlanihque: ―Sihuatl, ¿tleca tichocatica? Yehhuatl oquiniluic: ―Nichocatica tleca otehuicaque in Notecohtzin, huan ahmo nicmati canin otetlalihque. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Hueloc quitlamiihtohua, queman omocuetlapantlachiyali huan oteitac in Jesús ompa oilohuaya. Huan in María ahmo oquimatiyaya tla Yehhuatzin in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Oncan Jesús omotlahtlani: ―Sihuatl, ¿tleca tichocatica? ¿Aquinon tictemohua? In María oquinehnehuilic cana yehhuatl in tlahpixqui den tlamiloli, huan oquiluic: ―Tlacatzintli, in tla tehhuatzin otehuicaloc, manechilui canin otecahualo, huan nehhuatl nitehuicas. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Oncan Jesús omoluic: ―¡María! Yehhuatl omocuep huan oteiluic ica intlahtol in judeahtecos: ―¡Raboni! ―quihtosnequi, Tlamachtiyani. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Huan Jesús oquiluiloc: ―Xinechcahcahua, tleca ayamo nitlehcotoc canin ilohuac in Tohueyitahtzin. Huan xiyau xiquinilui in nocnihuan, quen niyau nitlehcohua canin ilohuac in Nohueyitahtzin huan Namohueyitahtzin, in aquin noDios huan den namehhuan noyojqui. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Oncan in María Magdalena oya quinnahuatiya in tetlamachticahuan quen yehhuatl oteitac in Totecohtzin huan mach Yehhuatzin omoluic inin tlahtolten. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ic tiotlac ipan in achto tonali den semana, in tetlamachticahuan omosentlalihtoyahque san secnin huan oyectlahtlatzactoyahque, tleca momoutiyahque ica in tequihuahmen den judeahtecos. In Jesús ocalacohuac huan san tlama oquimonextililoc innepanco in tetlamachticahuan, huan oquintlahpaloloc ic quiniluiloc: ―¡Ximoyolsehuican! ");
INSERT INTO ncjNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Satepa ic omihto inin, oquinnextililoc in temahuan huan in teyelpa. Huan yehhuanten opajque ic oteitaque in Totecohtzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Niman Jesús oquiniluiloc oc sepa: ―Ximoyolsehuican. Quen in Tohueyitahtzin onechualtitlaniloc tlalticpac, ijcon namechtitlani namehhuanten. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Huan oncan otlaihyopitzaloc intech huan oquiniluiloc: ―Xicselican in Itiotonaltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","In aquin namehhuanten nanquitlapohpoluisque intlahtlacol, mocahuasque chipahuaque. Huan in aquihque ahmo nanquintlapohpoluisque, mocahuasque san ijcon tlahtlacoltihtoque. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","In Tomás, seya den mahtlactli huan ome tetlamachticahuan in aquin quitocahhuiyahque Cuate, ahmo inuan ocatca ihcuac ohualuilohuac in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Satepa in oc sequin tetlamachticahuan oquiluihque: ―Otiteitaque in Totecohtzin. Huan Tomás oquiniluic: ―In tlahmo niquitas ipan temahuan in tlacocoli ica in clavos, huan tlahmo nicalaquilis nomahpil in canin ocalac in clavos, huan tlahmo nicalaquis noman ipan teyelpa, ahhuel nicneltocas. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Chicueyi tonali satepa, in tetlamachticahuan omonechicohtoyahque ipan se cali, huan inon tonali in Tomás ompa inuan ocatca. Oncan, masque ipan in cali oyectlahtlatzactoya, in Jesús ocalacohuac, huan san tlama oquimonehnextililoc tlanepantla den yehhuanten huan omotlahpalohque huan oquiniluiloc: ―¡Ximoyolsehuican! ");
INSERT INTO ncjNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Niman omoluic in Tomás: ―Xiquita in nomahuan; xicalaqui nican momahpil, huan xicmachili nica ipan noyelpa. Huan ayacmo ximoxicohtiye in tlahmo ticneltoca. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Oncan in Tomás otenanquilic: ―¡Notecohtzin huan noDios! ");
INSERT INTO ncjNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Oncan Jesús omoluic: ―Tomás, axan ticneltoca tleca yotinechitac. Pactoque in aquin masque ahmo nechitztoyahque, huan nechneltocasque. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Huan Jesús omochiu oc sequin miyac tlachiuten mahuestic inixpa in tetlamachticahuan tlen ahmo ca tlahcuiloli ipan inin amatl. ");
INSERT INTO ncjNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Huan inin ca tlahcuiloli ic namehhuanten xicneltocacan quen in Jesús, Yehhuatzin in Cristo in Iconetzin Dios, huan ic xicpiyacan in yancuic nemilistli ic nanteneltocasque Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Satepa de inin, in Jesús oquinmonextililoc in tetlamachticahuan itentla in hueyi atl den Tiberias. Huan ijquinin omochiu. ");
INSERT INTO ncjNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ocahcatca san secnin in Simón Pedro, huan in Tomás in aquin oquitocahhuiyayahque Cuate, huan in Natanael, ialtepeu Caná den Galilea, huan in ipiluan Zebedeo huan oc ome tetlamachticahuan in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","In Simón Pedro oquiniluic: ―Niyau nimichquitzqui. Yehhuanten oquiluihque: ―Tehhuanten noyojqui mohuan tiyasque. Oncan oyahque, huan otlehcohque ihtech se barco, huan inon yohuilotl ahmo oquiahsique niyan tlen. ");
INSERT INTO ncjNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ihcuac opeu tlalpa tlanesi, in Jesús omonextiloc atlatentli, huan in tetlamachticahuan ahmo oquimatiyayahque in tla Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Oncan quiniluiloc: ―¿Tlen nanquichihuahque namehhuan? ¿Ahmo nanquiquitzquihtoque niyan tlen? Huan yehhuanten otenanquilihque: ―Niyan tlen ahmo ticahsitoque. ");
INSERT INTO ncjNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Oncan Jesús oquiniluiloc: ―Xictlasacan in matlatl ic iyejcan in barco, huan nanquiahsisque. Ijconon oquichiuque, huan satepa ahhuel oquiquixtiyayahque in matlatl ipan in atl, ic tequin miyac michten oquipiyaya. ");
INSERT INTO ncjNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Oncan in tetlamachticau in aquin Jesús tequin omotlasohtlayaya oquiluic in Pedro: ―¡Yehhuatzin in Totecohtzin! Hueloc oquicac in Simón Pedro quen Yehhuatzin in Totecohtzin, oncan oquitlali in icamisa (tleca oquiquixtihtoya ic tequiti), huan omotohuetzo ipan in atl, ihsiu maahsi in atlatentli. ");
INSERT INTO ncjNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","In oc sequinten tetlamachticahuan oahsique in atlatentli ihuan in barco, quitotochuilantihue in matlatl tentiu in michten. Ocahcatca cana se cien metros den atlatentli. ");
INSERT INTO ncjNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ic otemoque tlalpa, oquiahsique se tlecuili, huicsitica pani se michi huan pantzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Huan Jesús oquiniluiloc: ―Xicualicacan sequin michten in tlen hueloc nanquiquixtiyahque. ");
INSERT INTO ncjNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Oncan in Simón Pedro otlehcoc ihtech in barco huan oquitotochuilan ipan tlali in matlatl ic tentiu in michten huehhueyi, se ciento ompohuali huan mahtlactli huan yiyi. Huan masque tequin miyac, in matlatl ahmo otzomon. ");
INSERT INTO ncjNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Oncan Jesús oquiniluiloc: ―Xihualacan xitlacuacan. Huan niyan seya den tetlamachticahuan ahmo omoixcohyanui tetlahtlanis aquin Yehhuatzin, tleca quimauticaten quen Yehhuatzin in Totecohtzin. ");
INSERT INTO ncjNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Saniman in Jesús omopacholoc, omoan in pantzin huan oquinmacaloc yehhuanten, huan noyojqui ijcon omochiu ica in michi. ");
INSERT INTO ncjNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Inin opanoc ic yexpa in Jesús oquinmonenextililoc in tetlamachticahuan satepa ihcuac yoihxohuac den miquilistli. ");
INSERT INTO ncjNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Satepa den tlacualistli, in Jesús omotlahtlani in Simón Pedro: ―Simón, ticoneu Jonás, ¿tla tinechtlasohtla ocachi huan ahmo inihque? In Pedro otenanquilic: ―Queme, Notecohtzin, Tehhuatzin momati quen nitetlasohtla. Huan Jesús oquiluiloc: ―Tel, xiquinixpiya nocolelohhuan. ");
INSERT INTO ncjNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Oc sepa omotlahtlani huan yeh in ic oupa. ―Simón, ticoneu Jonás, ¿tinechtlasohtla? Huan Pedro otenanquilic: ―Queme, Notecohtzin, Tehhuatzin momati quen nitetlasohtla. Oncan omoluic: ―Tel, xiquinixpiya nocalnelitos. ");
INSERT INTO ncjNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ic yexpa omotlahtlani: ―Simón, ticoneu Jonás, tel, ¿tinechtlasohtla? Huan Pedro otlocox tleca omotlahtlani yexpa in tla tetlasohtla, huan oteiluic: ―Notecohtzin, Tehhuatzin momati nochin. Tehhuatzin momati quen nitetlasohtla. Huan Jesús omoluic: ―Tel, xiquinixpiya nocalnelitos. ");
INSERT INTO ncjNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ic nele nimitziluiya quen ihcuac oticatca ocachi titelpochtli, oticanayaya tlen tictequiutiya huan otiyaya canin oticnequiyaya. Huan ihcuac titectiya, mitzmasohuasque in oc seya, huan mitzuicasque canin tehhuatl ahmo ticnequis tiyas. ");
INSERT INTO ncjNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ic omihto inin, in Jesús oquimatiltilo quen miquis in Pedro ic tehueyitilis in Dios. Satepa omoluic: ―¡Xinechcuitlapanui! ");
INSERT INTO ncjNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ic omocuepque, in Pedro oquitac quen oquincuitlapanuihtaya in tetlamachticau in aquin Jesús tequin omotlasohtlayaya. Yiyehhua in aquin ocatca tenahuac ipan in tlacualistli huan otetlahtlani: “Notecohtzin, ¿aquinon teichtacahuis?” ");
INSERT INTO ncjNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ihcuac in Pedro oquitac in oc seya, otetlahtlani in Jesús: ―Notecohtzin, huan inin, ¿tlenon quipanos? ");
INSERT INTO ncjNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Huan Jesús omonanquilic: ―In tla nehhuatl nicnequis manemi hasta ihcuac nimocuepas, ¿campa mitzcocua? Tehhuatl xinechcuitlapanui. ");
INSERT INTO ncjNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Oncan impan in tlaneltocanimen mochayau inon tlahtoli quen mach inon tetlamachticau cana ahmo miquis. Huan Jesús ahmo omihto ahmo miquis. Tlahmo omihto: “In tla nicnequis manemi hasta ihcuac nimocuepas, ¿campa mitzcocohua?” ");
INSERT INTO ncjNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Inin yiyehhua in tetlamachticau aquin quihtohua inin tlahtolten melahuac, huan yehhuatl quihcuilohtoc in tlen oquihto ipan inin amatl. Huan ticmatihque in tlen quihtohua nochin melahuac. ");
INSERT INTO ncjNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Oncan miyac oc sequin tlachiuten in tlen omochiu in Jesús, in tla quihcuilonihque se huan seya, huelis niyan nochin tlalticpac ahmo quixiconi in tlahcuilolamamen in tlen yeni tlahcuiloli.");
INSERT INTO ncjNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tlasohtli Teófilo, ihtech in tlen achto noamau onitlahto de nochin in tlamantli tlen Jesús opehualoc quimochihuiliya huan monextiliya. ");
INSERT INTO ncjNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Ijcon oquimochihuilito hasta in tonali queman otehuicaque ipan neluicac. Ihcuac ayamo otehuicaque, omoluihtejqui in Jesús ica in Itiotonaltzin Dios, tlen quichihuasque in tetiotlatitlaniluan aquin oquintlapehpeniloc. ");
INSERT INTO ncjNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Huan satepa ic omicohuac, oihxohuac huan omonextiloc Jesús iixpa in tetiotlatitlaniluan quen se tlacatl. Huan ipan ompohuali tonali miyacpa oquinyecmonextilohuaya ica miyac tlamantli tlen omochihuaco, mateitacan in tetiotlatitlaniluan nele oyolihuac Yehhuatzin. Huan oquinnonotzaloc ica quen in Dios tlatequiutilos ipan tlalticpactli. ");
INSERT INTO ncjNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Huan ihcuac inuan oilohuayaya, Jesús oquinmoluilic: ―Ahmo xiquisacan Jerusalén. Maquichiyacan mapano tetlahtol tlen omechmocaquilti in Tohueyitahtzin, in tlen yonamechiluihtoya. ");
INSERT INTO ncjNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","De achto in Juan otlacuatequiyaya ica atl, huan ipan se tonali ayacmo huehcau nanquiselisque in Itiotonaltzin Dios. Ijcon mechcuatequisque. ");
INSERT INTO ncjNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Huan ic inon ihcuac omosentlalihque tehuan Jesús, otetlahtlanihque: ―¿Totecohtzin; yeh in axan queman mechmacalos oc sepa in chicahualistli matimaquisacan tehhuan israeltecos? ");
INSERT INTO ncjNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Huan oquinmonanquililic in Jesús: ―Ahmo mechmactihtoque tlen tonali mochihuas quen san Yehhuatzin mopiya tequihuahyotl ic mamochihuilican. ");
INSERT INTO ncjNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Huan queman nanquiselisque in Itiotonaltzin Dios nanquiselisque techicahualistzin. Huan nantlachipahuasque ica in yancuic tlahtoli de nehhuatl quen ipan in hueyi altepetl Jerusalén huan ipan nochin in tlali Judea huan Samaria, huan ic campa ocachi huehca ipan in tlalticpactli. ");
INSERT INTO ncjNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Queman omihto Jesús inon, yolic otlehcolo neluicac ihcuac oteitzteuque in tetiotlatitlaniluan. Huan ohuala se mextli huan oteixtlapachoc huan ayacmo oteitaque. ");
INSERT INTO ncjNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yehhuan otlachixticatcahque ic neluicac ihcuac ohuilohuaticatca Jesús, huan ome tlacamen otlaquentihtoyahque ica istac omonextihque innahuac in tetiotlatitlaniluan. ");
INSERT INTO ncjNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Huan oquiniluihque: ―Tlacamen den Galilea, ocachi cuali ayacmo xitlachixtiyecan ic neluicac. Inon Jesús aquin otlehcoloc ic neluicac, oc sepa hualuilohuas ijquin quen onanteitaque ohuilohuac. ");
INSERT INTO ncjNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ihcuac inon yehhuan omocuepque Jerusalén de ipan in tepetl itoca Olivostepetl. Inon se ohtli ahmo huehca, cana ome kilómetro, quenin in itlanahuatil in judeahtecos oquincahuiliyaya manehnemican ipan in tonali den nesehuilistli. ");
INSERT INTO ncjNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Queman oahsique ipan in hueyi altepetl Jerusalén, otlehcoque ipan segundo piso den cali canin ocatcayayahque. Ompa omotepaluihtoyahque Pedro huan Jacobo huan Juan huan Andrés huan Felipe huan Tomás huan Bartolomé huan Mateo huan Jacobo iconeu Alfeo, huan Simón in aquin ocatca politico cananista huan Judas icniu Jacobo. ");
INSERT INTO ncjNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nochin yehhuan omosentlaliyayahque ica se tlanehnehuilistli huan momostli omoyolmachtiyayahque. Inuan ocatcahque in sihuamen huan María inana in Jesús, huan tecnihuan. ");
INSERT INTO ncjNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Huan ipan inon tonalten omosentlalihque cana se ciento huan sempohuali tlaneltocanimen. Ic inon Pedro omotelquetz tlanepantla huan oquiniluic: ");
INSERT INTO ncjNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Nocnihuan, xinechmocaquitican. In hueyixtoc David oquihcuiloc ica in Judas in tlen ocualiluiloc ica in Itiotonaltzin Dios. Yeh in Judas otetemacti in Jesús queman otequitzquihque. ");
INSERT INTO ncjNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Tleca Judas ocatca seya de tehhuanten huan oquipiyaya tlen quichihuas ihtech inin tequitl. ");
INSERT INTO ncjNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yehhua oya huan oquicou se tlali ica in tomin tlen oquimacaque ica in tlen ahmo cuali oquichiu. Saniman ohuetz ic coyojquetz huan ocuepon, huan oquis nochin icuitlaxcoluan. ");
INSERT INTO ncjNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Huan queman nochin yehhuan aquin ochantiyayahque Jerusalén oquimatque inon, oquitocahhuihque inon tlali Acéldama, huan ica intlahtol quihtosnequi Tlali den Yestli. ");
INSERT INTO ncjNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Tleca ihtech in amatl den Salmos ijquin quihtohua: Maquicahuacan ichan huan ahmo aquin mamochanti ihtech. Huan noyojqui quihtohua: Oc se maquiana itequiu. ");
INSERT INTO ncjNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Huan ocachi oquiniluic in Pedro: ―Ic inon tel, se tlacatl quipiya tlen techmiyaquilis mamononotzacan den ihxohualistli ica in Totecohtzin Jesús. Yesquiyani seya aquin ocatca tohuan nochin tonali queman onemohuac tohuan in Totecohtzin Jesús. Opeu inon tonalten queman otlacuatequiyaya in Juan huan otlan queman ohuilohuac neluicac in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Huan oquintocahnotzque ome de yehhuan: Matías huan José Barsabás, aquin noyojqui oquitocahhuiyayahque Justo. ");
INSERT INTO ncjNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ihcuac inon otetlatlautihque Yehhuatzin Dios ijquin: ―Totecohtzin, Tehhuatzin quinixmatilo inyolo nochin tlacatl. Xitechmonextilili catli yehhua de inin ome tlacatl Tehhuatzin ticmotlapehpenilihtoc. ");
INSERT INTO ncjNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Huan yehhua maquichihua in itequiu in tetiotlatitlanil. Yeh in tequitl tlen Judas oquipolo ica itlahtlacol, huan oya in campa oquinamiquiyaya. ");
INSERT INTO ncjNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ihcuac inon oquitlapehpenihque seya, huan oquis Matías. Ihcuac inon yehhua oquitocahhuihque ihuan in mahtlactli huan se tetiotlatitlaniluan. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Queman oahsic in iiluiu in judeahtecos itoca Pentecostés, nochten in tlaneltocanimen san secnin ocatcahque. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Huan san tlamach opeu xahuani chicahuac, mihtos ohualaya neluicac quenin ihcuac huitz chicahuac yehyecatl, huan oquicajque nochin yehhuan quen omolinic ipan in cali canin oyehuatoyahque. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ihcuac inon onesque quen itleyo tletl omoxelohtoyahque huan omocauque itzoncuac sehse de yehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Huan ijcon oteselihque in Itiotonaltzin Dios, huan opeuque tlahtohuahque ica oc sehse intlahtol, san quenin in Itiotonaltzin Dios oquinyolpehualtiloc matlahtocan. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ipan in hueyi altepetl Jerusalén ocatcayayahque judeahtecos inon tonali, aquin nele otemahuestiliyayahque in Dios. Ohualahque de nohuiyan ipan in tlalticpactli. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Oquicajque quen oxahuantaya huan omosentlalihque inon tlacamen. Huan ahmo oquimatiyayahque tlen quihtosque tleca sehse de yehhuan oquicaquiyayahque quenin in tetlamachticahuan otlahtoticatcahque oc sehse intlahtol. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Quen tel oquimautoyahque huan omoluiyayahque sequin huan oc sequin: ―Tlen huelis; ¿ahmo den Galilea inin tlacamen aquin tlahtohticaten? ");
INSERT INTO ncjNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Quenin tel, sehseya de tehhuan tiquincaquihque tlahtohticaten ica tlen tehhuan totlahtol? ");
INSERT INTO ncjNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nican oncan tlacamen den tlali Partia huan Media huan Elam huan Mesopotamia huan Judea huan Capadocia huan Ponto huan Asia, ");
INSERT INTO ncjNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","huan Frigia huan Panfilia huan Egipto huan in tlali Africa tlen caten ocachi ompic den Cirene. Noyojqui oncaten romanohtecos aquin omotepaluihtoyahque nican Jerusalén. Sequin de yehhuan otlacatque judeahtecos huan oc sequin omochiuque tlaneltocanimen ica itlanehnehuilis in judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Oncaten noyojqui ic tlali Creta huan Arabia. Huan tinochten tiquincaquihque quen tlahtohticaten ica tlen tequin cualtzin tequitl mochihua Dios ica tlen tehhuan totlahtol. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nochten quen tel omonehnehuilihtoyahque huan ahmo oquimatiyayahque tlen quihtosnequi, huan omotlahtlaniyayahque: ―¿Tlen quihtosnequi nochin inin? ");
INSERT INTO ncjNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Huan oc sequin ica ohuehuetzcahque huan oquihtohuayahque: ―Inin tlacamen huintihque. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ihcuac inon Pedro omotelquetz ihuan in oc mahtlactli huan se tetiotlatitlaniluan huan otlahto chicahuac huan oquiniluic: ―Tlacatzitzin den Judea huan in aquin nanmochantihtoque nican Jerusalén, xicmatican tlen quihtosnequi inin huan xicyecaquican in tlen niyau namechiluiya. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tehhuanten ahmo tihuintihque quen namehhuan nanquinehnehuiliyahque, tleca hueloc chicnahue hora tlahca. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Tlen panohtica yeh in tlen oquihto in tetlayolchicau Dios itoca Joel queman oquihcuiloc: ");
INSERT INTO ncjNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ijcon omihto in Dios; yimero ahsis queman tlalpolihuis. Huan niquinyoltlaxili in Notiotonaltzin nochin tlacamen mamocahualo inyolihtec. Huan namopiluan tlahtosque ica notlahtoltzin. In telpochten quiyolnehnehuilisque huan in tetecten motemiquisque. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ipan inon tonali niquinyoltlaxili Notiotonaltzin ic mocahualos inyolihtec inon tlacamen huan sihuamen aquin quichihuasque notequiu, huan tlahtosque ica notlahtoltzin. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Tlacpac ipan in neluicactli huan tlatzintla ipan in tlalticpactli nictemacas tlachiuten tlen ic quichihuasque cuenta ayacmo huehcau itonal Totecohtzin. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ipan inon tonali ompayes hueyi tetzahuitl; huan achto de ihcuac ahsis, tlalpa momanas yestli huan xotlas in tletl huan mahcocuis in poctli. Ic inon tlayohuas ica in tonaltzintli huan mopatlas in metztli cahso quen yestli. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Huan maquisasque nochten in aquin tetlatlautisque in Totecohtzin. Ijcon oquihcuiloc in Joel. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Xicaquican tel, tlacamen de Israel, tlen niyau namechiluiya. In Jesús tealtepeu Nazaret, Yehhuatzin se tlacatl oquitlapehpeniloc in Dios. Huan inon nanquiyecmatihque tleca oquimochihuili in hueyi tlaistlacolten huan in tlachiuten mahuestic huan in tlanextilisten ic maquinehnehuilican techicahualis in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Omechtemactilihque Jesús quen omomat in Dios aquin omoyectlali yihuehcau. Huan namehhuan onantequitzquihque huan namehhuan onantemictihque. Tleca onantetemactihque matemasohualtican ica inmahuan tlacamen ahmo cualten. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Huan Dios oteihxitiloc, masque mijqui oilohuayaya, tleca ahhuel omocahualo mijqui. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","In hueyixtoc David oquihcuiloc in tlen omonextililoc in Itiotonaltzin Dios, ica tlen panos ihcuac micohuas in Jesús. Ijcon omihto: Nochipa oniquitayaya in Tohueyitahtzin Dios noixpa. Yehhuatzin oilohuac nonahuac, ahmo tlen manechmohmoutis. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ic inon oniyolpac, huan onicuihcuicac. Masque tilantoc notlacayo, nicmati oc sepa niihsas; ");
INSERT INTO ncjNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","tleca Tehhuahtzin ahmo quicahualos nonemilis canin caten in mijcamen, niyan ahmo nechmocahuilis mapalani notlacayo, tleca nehhuatl niteconeu tetlapehpenil. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Onechnextilihque quen ocachi cuali ninemi, huan tinechmomaquilis miyac paquilistli tleca nohuan ilohuac. Ijcon omihto in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Nocnihuan, ic nele cuali namechiluiya in tochichicacoltzin David omic huan oquitlalpachohque huan in tlaltecochtli nican Jerusalén. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Huan David ocatca se tlayolchicauqui huan oquimat quen Dios omocalactili tetlahtol, quen se teixuiu David ilohuas in Cristo aquin mochihuas hueyi tequihua quen ocatca in David. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ojcon David, quen oquinextililo in Itiotonaltzin Dios ica tlen panos, otlahto ica ihxohualistzin in Cristo, huan oquihto tenemilis ahmo mocahuas canin caten in mijcamen, niyan ahmo palanis tetlacayo. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Huan inin Jesús aquin Dios oquihxitiloc, Yehhuatzin in Cristo, huan ic inon nochin tehhuan cuali ticchipahuasque. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ojcon Dios oquimahuestililoc in Jesús ican tequihuahyotl. Huan Tohueyitahtzin Dios otemacalo in Itiotonaltzin quen oquimoluilic. Huan mochiutica inon Itiotonaltzin Dios nochin inin tlen nanquitztoque huan nanquicactoque. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tleca ahmo otlehcoc neluicac in David, huan san yehhuatl oquihto: In Tohueyitahtzin oquiluiloc in Notecohtzin: “Ximotlali nonahuac ");
INSERT INTO ncjNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hasta niquimpinautis nochin in aquin mitzcocoliyahque.” ");
INSERT INTO ncjNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Axan nicnequi xicyecmatican nochin namehhuan tlacamen den Israel quen inin Jesús aquin namehhuan onantetemactihque matemictican, Yehhuatzin in aquin Dios otetocahhuihque Totecohtzin huan Cristo tetlapehpenil in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Queman in tlacamen oquicajque inin, oyoltlocoxque huan oquitlahtlanihque in Pedro huan in oc sequin tetiotlatitlaniluan: ―Tocnihuan, ¿tlen cuali ticchihuasque? ");
INSERT INTO ncjNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ihcuac inon Pedro oquinnanquilic: ―Ximoyolcuepacan huan ximocuatequican sehse de namehhuan ipan Itocahtzin Jesucristo, huan mechtlapohpoluisque namotlahtlacol. Huan ojcon mechmacalos in Dios in Itiotonaltzin, mamocahualo namoyolihtec. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nanquimatihque inon tleca omechcaquiltiloc Dios ica namehhuan huan namopiluan huan nochin aquin caten huehca ica intlanehnehuilis, nochin yehhuan aquin in Totecohtzin Dios quimonequiltiya quinmononochilis. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ica inon tlahtoli huan oc sequin oquintlatlautic Pedro huan oquinnonotz ijcon: ―Ximaquisacan huan ximoxelocan den inin tlacamen aquin mopolohuahque. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ojcon oquincuatequihque in aquin oquichiuque cuenta ica itlahtol, huan inon tonali omosetilihque inuan in tlaneltocanimen cana yiyi mil tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Huan oquichiuque cuenta ica nochin in tlen in tetiotlatitlaniluan oquinnextiliyayahque, huan san se oquimatque sequin huan oc sequin. Huan omoyolmachtihque huan oquimomahsehuihque tetlaolichtilis Totecohtzin. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Nochten quen tel oquimautoyahque quen oquichiuque in tetiotlatitlaniluan in tlaistlacolten huan in tlanexten mahuestic. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Huan nochin tlaneltocanimen omosetilihque san secnin huan omoxeluihque nochin in tlen oquipiyayahque sequin huan oc sequin. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Oquinemacayayahque intlaluan huan nochin in tlen oquipiyayahque huan omotlasentlaliltihque in tomin, huan queman aquin quinequi, cuali quixeluisque. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Mostli omosentlaliyayahque ihtech in hueyi tiopantli den judeahtecos, huan ihtech inchan oquimomahsehuihque tetlaolichtilis Totecohtzin huan opactoyahque ic nochten. ");
INSERT INTO ncjNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","In tlaneltocanimen otemahuestiliyayahque in Dios, huan in oc sequinten oquinuelitaque. Huan mostli momiyaquiliyahque in tlaneltocanimen tleca quinmaquixtilohtiu Yehhuatzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ocalactayahque in Pedro huan Juan ihtech in hueyi tiopantli cana yiyi horahtiotlac, tleca inon in hora ic moyolmachtisque. ");
INSERT INTO ncjNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Huan nochipa ompa ocatcayaya se tlacatl xonecuil de ihcuac otlacat. Oquihuicayayahque inahuac in tiopantli, huan oquicahuayayahque inahuac in puerta itoca Cualtzin, maquintlahtlanili limosna in aquin ompa ocalaquiyayahque. ");
INSERT INTO ncjNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ihcuac in xonecuil oquitac quen ocalactayahque in Pedro huan Juan ipan in tiopantli, oquintlahtlanili se limosna. ");
INSERT INTO ncjNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ihcuac inon in Pedro huan Juan oquiyequitaque huan oquiluic in Pedro: ―¡Xitechcaqui! ");
INSERT INTO ncjNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Inon xonecuil oquichiu cuenta, huan oquinehnehuiliyaya cana quimacanihque itlahten. ");
INSERT INTO ncjNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Huan in Pedro oquiluic: ―Ahmo nicpiya niyan plata niyan oro, pero in tlen nicpiya nimitzmacas. Ica tetequihuahyotl in Jesucristo den altepetl Nazaret, ximoquetza huan xinehnemi. ");
INSERT INTO ncjNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Huan in Pedro oquiquitzqui in xonecuil ic iyecman huan oquiquetz huan saniman ochicau icxihuan. ");
INSERT INTO ncjNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ihcuac inon omoquetz saniman in xonecuil huan opeu nehnemi. Inuan ocalac ihtech in tiopantli nehnentiu huan patlantiu huan temahuestilihtiu in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nochin tlacatl oquitaque nehnentinemi huan temahuestilihtinemi in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Huan quen tel oquimautoyahque huan omomoutihque ica in tlen opanoc. Tleca oquixmatiyayahque yehhua in aquin omotlaliyaya quitlahtlani limosna inahuac in puerta tlen itoca in Cualtzin. ");
INSERT INTO ncjNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ocatca se lugar itoca icaltenco Salomón huan ompa oyahque in Pedro huan Juan. In xonecuil aquin oquipahtihque ahmo oquinixcahuayaya huan nochin in tlacamen quen tel oquimautoyahque huan otzecuinque nepa quitasque tlen opanoc. ");
INSERT INTO ncjNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ihcuac oquitac inon, in Pedro oquiniluic in tlacamen: ―Tlacatzitzin den Israel, ¿tleca quen tel nanquimatihque? Ahmo xicnehnehuilican oticpahtihque inin tlacatl ica tochicahualis noso tleca tequin titemahuestiliyahque. ");
INSERT INTO ncjNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","In Dios aquin oquineltocaque tochichicacoluan Abraham huan Isaac huan Jacob, Yehhuatzin aquin omohueyitili Iconetzin Jesús, in aquin namehhuan onantetemactihque inmajco in tequihuahmen. Huan queman Pilato in tequihua tecahcahuasquiyani, namehhuan ahmo onanquinejque. ");
INSERT INTO ncjNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Masque inon Jesús mahuestic teixpa in Dios, namehhuan onanquitlahtlanilihque maquicahcahua in Pilato se temictiyani. ");
INSERT INTO ncjNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ijcon onanquicahuilihque matemictican in aquin techmacalo in nemilistli. Huan Dios oteihxitiloc in Jesús ipan in tlaltecochtli, huan ic inon tehhuan ticchipahuahque. ");
INSERT INTO ncjNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Huan Dios oquipahtiloc inin tlacatl aquin nanquixmatihque, tleca tehhuan ticneltocahque ica techicahualis inon Jesús. Ijcon nanquitahque quen oquiyecpahtihque tleca ticneltocahque ipan Itocahtzin Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Tlacatzitzin den Israel, nicmati niyan namehhuan niyan namotequihuan ahmo onanquinehnehuiliyayahque tlen onanquichiuticatcahque queman onantetemactihque matemictican in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Huan Dios oquimochihuili ijcon in tlen yoquihtohque ic incamac in tetlayolchicaucahuan, quen oquipiyaya tlen tlapanolos in Cristo tetlapehpenil in Dios ica in miquilistli. ");
INSERT INTO ncjNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Axan tel, ximoyolcuepacan huan mechtlapohpoluilisque namotlahtlacol. Ihcuac inon in Totecohtzin cuali mechyolpacmacalos. ");
INSERT INTO ncjNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Huan mohualtitlanis in Jesús, Yehhuatzin in tetlapehpenil in Dios aquin omihtoc mechmaquixtilos. ");
INSERT INTO ncjNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Huan quipiya tlen mocahualos neluicac hasta queman Dios mochihuas nochin in tlen yomihtoc ipan itlahtoltzin. Ijcon yihuehcau otlahcuilohque in tlayolchicaucamen tetlapehpeniluan in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ojcon oquiniluic in Moisés aquin tochichicacoltzin: “Dios in Totecohtzin mechualtitlanilos se namocniu, quen onechualtitlanilo nehhuatl. Yeh noyojqui se tlayolchicauqui ica itlahtoltzin Dios. Xicchihuacan cuenta ica nochin tlen mechiluilos. ");
INSERT INTO ncjNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tleca mopolosque ihtech ichanihcahuan den Israel nochin tlacatl aquin ahmo quichihuilis cuenta ica Yehhuatzin aquin mechnonotzalos.” Ijcon oquihcuiloc in Moisés. ");
INSERT INTO ncjNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Huan ihcuac onentoya in tlayolchicauqui Samuel hasta axan, nochin in tlayolchicaucamen otlahtohque noyojqui ica tlen panotica axan. ");
INSERT INTO ncjNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Dios oquincaquiltiloc tochichicacoluan huan yeh in tlen omechualahsic axan, quen Yehhuatzin Dios omoluic in Abraham: “Ica se mochichicaixuiu niquinchihuilis molui cuali nochin tlacamen ipan in tlalticpactli.” ");
INSERT INTO ncjNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Dios omechualtitlanililoc in Iconetzin achto ica namehhuan, mamechuelitalo namochten ic nanquicahuasque in tlen ahmo cuali. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ihcuac mononotzticaten in Pedro huan Juan, ohualahque in tiopixcamen den judeahtecos ihuan in comandante den tiopantli. Noyojqui inuan ohualahque in saduceos. Yehhuan sequin tlamachtiyanimen den itlanahuatil den judeahtecos aquin ahmo oquineltocaque ica in ihxohualistli. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ocualantoyahque tleca Pedro huan Juan oquinnextilihtoyahque in tlacamen quen in Jesús oihxohuac huan ic inon ihsasque in mijcamen. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ihcuac inon oquinquitzquihque huan oquincalaquihque telpiloyan huan hasta ic mostla tleca yitiotlac huan ayacmo ocatca tlixcomacalistli. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Huan oquineltocaque miyacten aquin oquicajque in itlahtoltzin Dios huan ic yehhuan oahsic cana macuili mil in tlaneltocanimen san yehhuan tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ic mostla ipan Jerusalén omosentlalihque in tequihuahmen den altepetl, huan in tetecten, huan in tlamachtiyanimen den itlanahuatil in judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Noyojqui ihuan Anás, yehhua in hueyixtoc den tiopixcamen, huan Caifás huan Juan huan Alejandro huan nochin ichanihcahuan in achtohque den tiopixcamen. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Huan oquintitlanque maquinanacan in Pedro huan Juan, huan oquintlalihque tlanepantla huan oquintlahtlanihque: ―¿Ica tlen tequihuahyotl, noso aquin omechiluic xicpahtican inon tlacatl? ");
INSERT INTO ncjNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ihcuac inon in Pedro oquiniluic quen Itiotonaltzin Dios ocualmacaloc: ―Tequihuahmen huan tetecten den Israel, ");
INSERT INTO ncjNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","onantechtlahtlanihque quen oticpalehuihque se cocoxqui, huan quen opahtic. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Tiquihtohuahque namoixpa, maquimatican nochin tlacamen den Israel, inin tlacatl aquin nicanca namoixpa omopahtic ica Itocahtzin Jesucristo tealtepeu itoca Nazaret. Yehhuatzin in aquin namehhuan onantetemactihque matemictican ipan in cruz, huan oteihxitiloc Dios ipan in tlaltecochtli. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Quemaniyan quen se tlacatl quixtlasa tetl tlen ahmo yehui huan satepa san yehhua quinamiquis. Ijcon namehhuan onanteixtlasque in Jesús, huan satepa oquixohuac Yehhuatzin ocachi de nochin. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Niyan aquin oc se cuali techmaquixtilos tleca techmacatoque san Yehhuatzin Itocahtzin Jesús quen Totemaquixticahtzin. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","In tequihuahmen huan in tetecten quen tel oquimautoyahque queman oquitaque in Pedro huan Juan ahmo omomoutihque ic tlanonotzasque, tleca oquimatque quen ahyic omomachtihtoyahque huan ahmo tlen inquisca. Huan ic inon oquichiuque cuenta quen in Pedro huan Juan tehuan onemiyayahque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Huan in tlacatl aquin oquipahtihque ompa ocatca inahuac in Pedro huan Juan, huan ic inon in tequihuahten ahhuel oquinahhuaque. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ihcuac inon oquitequiutihque maquinquixtican in Pedro huan Juan huan omonohnotzque san yehhuanten, ");
INSERT INTO ncjNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","huan oquihtoque: ―¿Tlen ticchihuasque ica inin tlacamen? Tleca quimatihque nochten in aquin chancaten Jerusalén quen oquichiuque inin tlamelajcan tlapahtilistli, huan ahhuel tiquixtlasasque. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ayacmo ticnequihque maquinonotzacan inin tlamachtilistli huan ic inon tiquintlacahualtisque inin inehuan huan axan ayacmo matlanonotzacan ica itlahtol Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ihcuac inon oquinnotzque huan oquinnahuatihque ayacmo matlanonotzacan niyan ayacmo maquinnextilican ica itlahtoltzin Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Huan in Pedro huan Juan oquiniluihque in tequihuahten: ―¿Tlen ocachi monequis in Dios? Cox, ¿titetlacamatisque Yehhuatzin noso tamechtlacamatisque? ");
INSERT INTO ncjNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tehhuan ahhuel ticahuasque ic titlahtosque in tlen tiquitztoque huan tlen ticactoque. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ihcuac inon in tequihuahmen oc sepa oquintlacahualtihque in Pedro huan Juan huan oquincauque, tleca ahmo ocahsihque quen quintlapanoltisque. Huan noyojqui omomoutiyayahque inon tequihuahmen ica in tlacamen den altepetl, tleca nochten oquinuelitahque in tetiotlatitlaniluan huan otemahuestilihticatcahque in Dios ica in tlen opanoc. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Tleca inon tlacatl aquin oquipahtihque ica techicahualis in Dios oquipiyaya ocachi de ompohuali xihuitl. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Huan queman oquincauque in Pedro huan Juan, oyahque canin ocatcahque in tlaneltocanimen. Huan oquinnotzque nochin in tlen oquiniluihque in tiopixcamen huan in tetecten. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Queman oquicajque inon, nochten omoyolmachtiyayahque ica in Dios huan oquihtohque: ―Tohueyitahtzin, Tehhuatzin aquin oquimochihuili in neluicactli huan in tlalticpactli huan in atl, huan nochin in tlamantli tlen oncan. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tehhuatzin ica Tetiotonaltzin oticualmomaquili tetlaquehual David maquihto: ¿Tleca motlahtolchihuiyahque in tlalticpac tlacamen? San tlaluis quinehnehuiliyahque. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","In tequihuahmen den tlalticpactli oteixnamijque, huan omosechiuque matecocolican in Totecohtzin Dios huan in Cristo. Ijcon oquihcuiloc in David. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Tleca ic nele, Herodes huan Poncio Pilato, ihuan in tlacamen omosechiuque ihtech inin hueyi altepetl matecocolican tetlasohconetzin Jesús, aquin omotemacti ica tetequiu. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Yehhuan oquichiuque nochin tlen Tehhuatzin oticmonequilti mapano. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Huan axan, Totecohtzin, xicmotili quen techmohmoutisque huan xitechmoyolchicahuili tehhuan titetlaquehualtzihtzin matitlanonotzacan ica motlahtoltzin huan ahmo matimomoutican. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Mapahtican in cocoxcamen temajco huan matequitihua ica techicahualis in tlachiuten mahuestic ica Itocatzin Moconetzin, in aquin Motlapehpeniltzin toJesús. Ijcon omoyolmachtihque. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Queman otlanque moyolmachtiyahque, ohuehueyocac canin omosentlalihtoyahque huan nochten oquinyolchicahualo ica techicahualis in Itiotonaltzin Dios huan ayacmo omomoutihque matlahtocan ica itlahtoltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Huan in miyacten aquin otlaneltocaque san se intlamachilis ocualmatque. Ahmo aquin oquihtohuaya in tlen quipiya san yehhua inuaxca, in tlahmo nochin in tlen oquipiyayahque ooliliutoya sansecnin. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","In tetiotlatitlaniluan oquiyecchipauque ica in ihxohualistzin in Totecohtzin Jesús huan molui chicahuac intlahtol. Huan nochin oquinmotiochihuili in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ahmo ocatca niyan aquin tlen oquipolohuaya, tleca oquinemacayayahque nochin in tlen oquipiyayahque, tlalten noso calten, huan ocualicayayahque in tomin. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Huan oquitemactiyayahque inmajco in tetiotlatitlaniluan huan yehhuan omoxehxeluiyayahque san quen oquinequiyaya seya. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ijcon oquichiu se tlacatl itoca José den ichanihcahuan Leví, huan itocahyan Chipre, huan in tetiotlatitlaniluan oquitocahhuihque Bernabé, tlen quihtosnequi in aquin tlayolchicahua. ");
INSERT INTO ncjNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Inin tlacatl oquinemacac se itlal huan ocualicac in tomin huan oquitemacti inmajco in tetiotlatitlaniluan. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Huan se tlacatl itoca Ananías ihuan isihuau Safira oquinemacaque se intlal. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Huan inon tlacatl oquitemacti in tomin inmajco in tetiotlatitlaniluan, masque oquimocahui sa se chihton ic oquincahcayau. Ihuan oquisematiyaya isihuau. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ihcuac inon oquiluic in Pedro: ―Ananías; ¿tleca otimocau ica in Satanás mamitzyolquitzqui huan oticmocahui sequin tomin tlen omitzmacaque ica in tlali tlen oticnemacac? Tel, ¿ticnehnehuiliya cuali titecahcayahuas in Itiotonaltzin Dios? ");
INSERT INTO ncjNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Inon tlali mohuaxca ocatca. Ahmo oticpiyaya tlen ticnemacas. Huan queman oticnemacac, moyaxca nochin in tomin. ¿Tleca oticnehnehuili ticchihuas inin? Otiistlacat ahmo san ica in tlacatl, in tlahmo hasta ihuan in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Queman Ananías oquicac inin, ohuetz mijqui. Huan nochten in aquin oquimatque inon, molui omomoutihque. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ihcuac inon ohualahque sequin telpopochten, huan oquipipiquihque itlacayo huan oquiquixtihque huan oquihuicaque quitocahque. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Cana yiyi hora satepa, ocalac isihuau Ananías, huan ahmo oquimatiyaya tlen opanotoya. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedro oquitlahtlanic: ―Xinechilui: ¿Onanquinemacaque in tlali ica in tomin quen onanquihtohque? Huan otlananquilic yehhuatl: ―Ic nele ijcon ic oticnemacaque. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ihcuac inon in Pedro oquitlahtlanic: ―¿Tleca san se onanquimatque namehhuan ic nanquimohsihuiyahque Tetiotonaltzin Totecohtzin? Nepa quiahuac huitzen in aquin oquitocaque monamic huan axan tehhuatl mitzuicasque noyojqui. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ic inon yehhuatl ohuetz mijqui icxitla in Pedro. Queman ocalajque in telpopochten ocahsitohque yimijqui, huan oquihuicaque huan oquitocaque inahuac inamic. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Huan omomoutihque nochten in tlaneltocanimen ipan in itiotlayehualoltzin in Dios, ihuan in aquin oquimatque inon tlen opanoc. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Huan oquichihuayayahque in tetiotlatitlaniluan tlanepantla den tlacamen miyac tlachiuten mahuestic tlen ic quichihuasque cuenta, huan nochten omosentlaliyayahque ipan Icaltenco in Salomón. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Niyan aquin den oc sequinten omoixcohyehuiyayahque inuan monelosque in tlaneltocanimen huan in tlacamen molui oquinuelitayayahque. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Huan miyac tlacamen huan sihuamen oquineltocaque ica in Totecohtzin. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Noyojqui oquinquixtiyayahque in cocoxcamen ipan ohtli, huan oquintlaliyayahque ipan tlapechtli. Huan queman opanohuaya in Pedro, macana huetzis isehualyo ipan yehhuan ic mapahtican. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Huan hasta den oc sequin hueyi altepemen tlen caten tlanahuac, ohualahque miyac tlacamen ipan Jerusalén. Huan oquinualicayayahque incocoxcahuan huan in aquin oquipixtoyahque in ahmo cuali yehyecatl, huan nochten opahtiyayahque. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ihcuac inon in achtohque den tiopixcamen huan in saduceos, yehhuan aquin oquipalehuiyayahque, molui oquinnexicaluiyayahque. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Huan oquinquitzquihque presos in tetiotlatitlaniluan, huan oquincalaquihque ipan in telpiloyan. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Huan tlayohua se ángel den Totecohtzin oquintlapo in puertas den telpiloyan huan oquinquixti. Huan oquiniluic: ");
INSERT INTO ncjNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Xiyacan ximoquetzacan ihtech in tiopantli huan xiquinnonotzacan nochin tlacamen ica in tlahtoli de inin yancuic nemilistli. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Queman oquicajque inon, ic tlapoyaucan ocalajque ihtech in tiopantli huan opeuque quinextiliyahque. Ihcuac inon in achtohque den tiopixcamen omosentlalihque ihuan in hueyi junta den Israel, quihtosnequi nochin in tetecten den judeahtecos, huan oquintequiutihque maquinanacan in tetiotlatitlaniluan de ihtech in telpiloyan. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Huan queman oahsitohque in topilihten ihtech in telpiloyan, ayacmo oquinahsitohque. Huan omocuepque tlanahuatiyahque: ");
INSERT INTO ncjNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","―Oticahsitohque yec tzactoc in telpiloyan huan in soldados oquipihpixtoyahque iixpa in puertas, huan queman otitlatlapohque, ahmo aquin oticahsitohque tlahtec. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Queman oquicajque inon, in achtoque den tiopixcamen huan in comandante omotlahtlanihque se huan oc seya: ―¿Tlen panos axan? ");
INSERT INTO ncjNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ihcuac inon oahsic se tlacatl quihtotiu: ―In tlacamen aquin onanquincalaquihque telpiloyan yiompa caten tiopan tlamachtihtoque ica in oc sequin tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ihcuac inon in comandante oya ihuan in topilihten huan oquinualicac in tetiotlatitlaniluan, huan ahmo oquincocoliyayahque, tleca omomoutiyayahque cana quintemacasquiyanihque in oc sequinten. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Queman oquinualicahque, oquintlalihque iixpa in tequihuahmen den tiopantli, huan in hueyixtoc den tiopixcamen oquiniluic: ");
INSERT INTO ncjNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Tehhuan otamechtlacahualtihque namehhuan ayacmo xitlanextilican ica itlahtol Jesús. ¿Huan tlen onanquichiuque? Namehhuan yonanquimiyaquilihque namotlahtol ipan Jerusalén huan nanquinequihque nantechtlahtlacoltisque ic omic inon Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ihcuac inon otlananquilic in Pedro ihuan in oc sequin tetiotlatitlaniluan: ―Ticpiyahque tlen tictlacamatisque in Dios huan ahmo in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","In Dios den tochichicacoluan oteihxitiloc in Jesús aquin namehhuan onantemictihque, quen onantetemactihque matemasohualtican ipan in cruz. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Dios oquimotlalili in Jesús huehcapa canin ocachi mahuestic huan oquimochihuili Totecohtzin huan Totemaquixticahtzin. Yehhuatl in aquin oquinmocahuili mamoyolcuepacan in tlacamen den Israél huan maquintlapohpoluican intlahtlacol. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Inin tlahtoli tehhuan ticchipahuahque huan noyojqui quichipahualo Itiotonaltzin Dios. Yehhuatzin in aquin Dios quinmomaquilihtoc mamocahualo inyolihtec in aquin tetlacamatisque. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Queman oquicajque in tiopixcamen, ocualanque huan oquinequiyayahque quinmictisque. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Huan ocatca se tequihua itlanehnehuilis fariseo itoca Gamaliel, huan ocatca tlamachtiyani ica itlanahuatil in judeahtecos. Huan oquihuelitayayahque molui in tlacamen. Yehhuatl omoquetz huan oquinahuati maquinquixtican san chihton in tetiotlatitlaniluan. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ihcuac inon oquiniluic in tequihuahmen: ―Tlacamen den Israel, xicchihuacan cuenta quen nanquichihuasque ihuan inin tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tleca nanquilnamiquihque namehhuan ayamo temouti huehcau, omohueyili se tlacatl itoca Teudas huan oquihto mach yehhua se tlacatl hueyi iquisca. Huan oquipantocaque cana nahue ciento tlacamen. Huan oquitemo inemictilis huan omochayauque nochin aquin oquipantocayayahque huan ojcon omotlamixexelohque. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Satepa, ipan in tonali queman oquiquixtihque censo, noyojqui omohueyili in Judas, itocahyan Galilea, huan miyacten oquicuitlapanuiyayahque, huan noyojqui oquitemo inemictilis huan omochachayauque nochin in aquin oquicuitlapanuiyayahque. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ic inon, xiquincahuacan inin tlacamen huan ahmo ximocalactican inuan, tleca tla inin tlahtoli ca itlanehnehuilis tlacatl, ijcon tlamis tlamach. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Huan tla nele den Dios, namehhuan ahhuel nanquixitinisque. Ximomaluican ahmo nanteixnamiquihque in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Oquihtohque nochten mach cuali ocatcayaya inon itlahtol in Gamaliel. Oquinnotzque in tetiotlatitlaniluan huan oquinuihhuitejque huan oquintlacahualtihque ayacmo matlanonotzacan ica itlahtoltzin Jesús, huan ic satepa oquincahcauque. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Huan yehhuan oquisque iixpa in tequihuahmen, molui pactihue tleca Dios omocahualoc maquimpinautican tepampa in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Huan mostli ipan inchan huan ipan tiopan ahmo omotzecohque ic oquinnextiliyayahque ica itlahtoltzin Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ipan inon tonali oquimiyaquilihque in tlaneltocanimen. Huan in aquin otlahtohuayahque ica intlahtol griego opeuque quintenehuahque ica in judeahtecos, huan oquihtohuayahque mach ahmo quinyecchihuahque cuenta ica in viudas griegohtecas queman omoxehxelohuayahque mostli in tlacuali. ");
INSERT INTO ncjNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ihcuac inon in mahtlactli huan ome tetiotlatitlaniluan oquinsentlalihque nochin tlaneltocanimen huan oquiniluihque: ―Ocachi cuali ahmo matimotzecocan ic titlanonotzasque ica itlahtoltzin Dios ic maticxehxelocan tlacuali. ");
INSERT INTO ncjNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ic inon, tocnihuan, xiquintemocan chicome tlacatl ic namehhuan, aquin ahmo tlacahcayauqui, huan aquin tlanehnehuiliyahque, huan aquin quipiyahque in techicahualis Itiotonaltzin in Dios. Huan xiquinmacacan inon tequitl. ");
INSERT INTO ncjNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Huan tehhuanten timoyolmachtisque huan tiquinnextilisque ica itlahtoltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Omosechiuque nochten ic tlen oquihtohque in tetiotlatitlaniluan, huan oquitlapehpenihque in Esteban, se tlacatl aquin yec otlaneltocayaya huan quiyolquitzquihtoc in techicahualis Itiotonaltzin in Dios. Huan noyojqui oquintlapehpenihque in Felipe, huan Prócoro, huan Nicanor, huan Timón, huan Parmenas, huan Nicolás, yeh se tlacatl ochantiyaya Antioquía. Yehhuatl se griegohteco aquin oquineltocac quen judeahteco. ");
INSERT INTO ncjNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Saniman oquinualicahque iixpa in tetiotlatitlaniluan huan omoyolmachtihque huan oquitlalihque inman ipan yehhuan, maquinyolchicahuacan maquintlalilican intequiu. ");
INSERT INTO ncjNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Huan ocachi omochayau itlahtoltzin Totecohtzin huan ipan Jerusalén ocachi oquimiyaquilihque in tlaneltocanimen, huan otlaneltocaque miyac tiopixcamen ica in Jesucristo. ");
INSERT INTO ncjNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Oquichihuayaya in Esteban miyac tlachiuten mahuestic iixpa in tlacamen, tleca Dios oquimacaloc tequihuahyotl huan oquihuelitaloc. ");
INSERT INTO ncjNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ihcuac inon sequin tlacamen den ololi itoca Esclavos Libertados opeuque motlahtolchihuiyahque ica in Esteban. Huan oquimpalehuihque oc sequin tlacamen den altepemen den Cirene, huan den Alejandría, huan den tlali Cilicia, huan den tlali Asia. ");
INSERT INTO ncjNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Huan ahhuel oquixnamiquiyayahque in Esteban tleca otlahtohuaya ica tetlanehnehuilis Itiotonaltzin in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ihcuac inon oquintlaxtlahuihque sequin ica mamotencuacan quen Esteban otepactecatoya ica itlahtol in Moisés huan ica Yehhuatzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ijquin oquichiuque maquicocolican in Esteban in tetecten huan in tlamachtiyanimen den itlanahuatil Moisés. Huan oquiquitzquihque huan ocuicaque iixpa in tequihuahmen. ");
INSERT INTO ncjNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Huan oquintemohque in aquin quichipahuahque: ―Inin tlacatl nochipa quipacteca inin tiopantli huan itlanahuatil Moisés. ");
INSERT INTO ncjNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Oticajque queman oquihto mach inon Jesús tealtepeu Nazaret quixitinis inin tiopantli huan quipatilis itlanehnehuilis Moisés. ");
INSERT INTO ncjNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ihcuac inon, queman oquitaque in Esteban in tequihuahmen huan nochin in aquin ompa oyehuatoyahque, oquitaque nesi ixayac in Esteban quen ixayac se ángel. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ihcuac inon in hueyixtoc den tiopixcamen oquitlahtlani in Esteban: ―Tel, ¿melahuac tlen ic omitzteluihque? ");
INSERT INTO ncjNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Huan otlananquilic yehhuatl: ―Tocnihuan huan totatahhuan, xinechcaquican. Tohueyitahtzin Dios mahuestic oquimonextilili tochichicacoltzin Abraham queman ocatca ipan tlali Mesopotamia, ihcuac ayamo yau mochantiya Harán. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Huan oquimoluilic in Dios: “Xicahua motlal huan nochin mochanihcahuan, huan xiyau ipan in tlali tlen nehhua nimitznextilis.” ");
INSERT INTO ncjNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ihcuac inon oquis Abraham den tlali Caldea huan oya mochantlaliya ic Harán. Huan ihcuac omic itata Abraham, Dios omohualicac ipan inin tlali canin namehhuan nancaten axan. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Huan ahmo oquimomaquili niyan tlen tlali nican, niyan canin quitlalis icxi, huan Dios oquimocalactili itlahtoltzin quimacalos satepa inon tlali. Huan satepa ihcuac miquis, inin tlali ihuaxca yes ipiluan, masque ipan inon tonali Abraham ayamo oquipiyayaya ipiluan. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Huan Dios oquimoluilic quen ichichicaixuihuan in Abraham mochantisque quen sentlapalchanimen ihtech se tetlal para nahue ciento xihuitl. Huan ompa yesque tlaquehualten aquin ahmo quinmaluisque. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Huan noyojqui oquimoluilic in Dios: “Nehhua niquintlapanoltis inon tlacamen aquin quinchihualtisque tlaquehualten, huan satepa quisasque de ompa inon techichicaixuihuan huan nechmahuestilisque ipan inin tlali.” ");
INSERT INTO ncjNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ihcuac inon Dios omotlahtolnamijque ihuan Abraham, huan omotequiuti maquitlali in ixmatcayotl den judeahteco ipan nochten telpocamen, ijcon maquinehnehuilican yehhuan tehuaxca in Dios. Ic inon, queman otlacat iconeu in Abraham itoca Isaac, ipan chicueyi tonali Abraham oquitlalili in ixmatcayotl huan noyojqui ijcon oquichiu Isaac ica iconeu Jacob, huan ojcon oquichiu Jacob ica in mahtlactli huan ome ipiluan aquin in tetatahmen den ololten den Israel. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Huan inohque ipiluan Jacob tochichicacoluan. Huan se de yehhuan itoca José oquinexicaluiyayahque in icnihuan huan ic inon oquinemacaque. Huan in aquin oquicouque ocuicaque ipan in tlali Egipto. Huan in Dios omopalehui in José. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Huan masque molui oquimohsihuihque, oquimaquixtiloc in Dios. Oquimacaloc itlanehnehuilis in José huan oquihuelitac in hueyixtoc den Egipto itoca Faraón. Huan in Faraón oquitocahhui quen tequihua den Egipto huan ocuicac nochin tequitl ipan ichan in hueyixtoc. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Ihcuac inon ohuala se hueyi apistli huan oquitlapanoltiyayahque ipan in tlali Egipto huan ipan tlali Canaán, huan tochichicacoluan oquitlamihque tlen quicuahtiyesque. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Huan queman Jacob oquicac ic Egipto oncan tlen quicuasque, oquintitlan in tochichicacoluan in achto viaje. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ic oupa oyahque, José omoteixmatilti ihuan icnihuan. Huan oquinuicac iixpa in hueyixtoc Faraón maquinixmati ichanihcahuan José yehhuan judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ihcuac inon José otlatequiuti maquianacan itata Jacob huan nochten ichanihcahuan. Huan yehhuan ocatcahque yehpohuali huan caxtoli tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ojcon opanoc huan Jacob oya mochantiya ipan tlali Egipto, canin omic huan satepa omijque oc sequin tochichicacoluan. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Satepa oquinuicaque intlacayo ipan in altepetl Siquem, huan ompa oquintocaque ipan se tlacoyoctli. Inon tlacoyoctli yeh in tlen achto Abraham oquicohuili ipiluan in Hamor ipan altepetl Siquem huan anquimati quesqui ipatiu. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Opanoc miyac xihuitl huan opolihuiyaya oc chihton ic quisasque in israeltecos quen Dios omocalacti tetlahtol ihuan Abraham. Huan omomiyaquilihtohque inon tochichicacoluan nepa Egipto. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ihcuac inon omochiu hueyixtoc se tlacatl in aquin ahmo oquixmat in José. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Inon hueyixtoc oquincahcayau in tochichicacoluan huan ahmo oquinmalui. Huan oquiniluic maquintohuetzocan impiluan aquin tlacatis telpocatl, huan ijcon mamiquican huan ahmo mamiyaquilican ocachi inon tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ipan inon tonali otlacat in Moisés huan Dios otepacti in conetl. Itata ihuan inana oquiscaltihque ipan ichan cana yiyi metztli. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ohualahsic in tonali maquixtohuetzocan, huan oquian in conetl iichpocau in hueyixtoc den Egipto huan oquiyoliti quen ihuaxca. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ic inon, Moisés oquixtlamachtihque ica nochin in tlen oquimatiyayahque in tlacamen den Egipto, huan ocatca molui yolchicahuac ica tlen oquihtohuaya huan tlen oquichihuayaya. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Queman inon Moisés oquipiyayaya ompohuali xihuitl, oquinec quinitas ichantlacahuan, yeh in tlacamen israeltecos. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ompa oquitac quen se tlacatl egipciohteco oquihuihhuitectoya se itlacaicniu, huan oquipalehui inon ichantlacau. Omomacuep in Moisés huan ic inon oquimicti in egipciohteco. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Tleca Moisés oquinehnehuiliyaya mach icnihuan in israeltecos quichihuasque cuenta quen Dios quinmaquixtisque ica yehhuatl, huan yehhuan ahmo oquichiuque cuenta ojconon. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ic mostla Moisés omopachoc innahuac ome itlacaicnihuan aquin omotehuihtoyahque huan quen yehhuatl oquinec quinxelos, oquiniluic: “Namehhuan nanicnimen; ¿tleca nanmotehuiyahque se huan oc seya?” ");
INSERT INTO ncjNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ihcuac inon in aquin ahmo oquimalui aquin ihuan omocualantihtoya oquixtopeu se lado in Moisés huan oquiluic: “¿Huan aquin omitztlali cahso quen tequihua huan tlixcomacani ica tehhuanten? ");
INSERT INTO ncjNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Ticnequi tinechmictis noyojqui quen yalua oticmicti in egipciohteco?” ");
INSERT INTO ncjNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Queman oquicac inin, Moisés ocholo huan oya ipan in tlali Madián. Huan ompa ocatca quen sentlapalchani, huan oquimpix ome ipiluan. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Opanoc cana ompohuali xihuitl huan se tonali ic ocatcayaya ipan se acahualtlahtli inahuac se tepetl itocahyan Sinaí, oquimonextili se ángel ipan itleyo in tletl quen san opanchichina in sahsal. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés quen tel oquimat ica in tlen oquitztehuac huan queman omopacho maquiyequita, otetlahtolcac in Totecohtzin huan oquimihtaluihtehuac: ");
INSERT INTO ncjNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Nehhuatl in Dios den mochichicacoluan, yehhuan Abraham huan Isaac huan Jacob.” Ihcuac inon Moisés opeu huehueyoca ica moucayotl huan ahmo oixcohyeu quiitas. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Huan in Totecohtzin oquimoluilic: “Xiquixti motecac tleca canin tiihcatica tlali molui mahuestic. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nehhuatl niquitztoc quenin tlapanohuahque nopiluan nepa tlali Egipto, huan nicactoc quen tenahque, huan onitemo ic niquinquixtis. Xihuala tel, huan nimitztitlanis Egipto.” ");
INSERT INTO ncjNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Yeh in Moisés aquin achto oquixtlasque huan oquiluihque: “¿Aquin omitztlali cahso quen tequihua huan tlixcomacani?” Dios oquimotitlanili quen tequihua huan tlamaquixtiyani huan oquipalehui in ángel aquin oquimonextili ipan inon sahsal ipan in acahualtlahtli. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Yeh in Moisés aquin oquinquixti tochichicacoluan quiahuac in Egipto, huan oquichiu in tlachiuten mahuestic tlen ic quichihuasque cuenta ica in Dios ipan inon tlali, huan ipan in mar itoca Mar Chichiltic, huan ipan in acahualtlahtli cana oc se ompohuali xihuitl. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Inin Moisés yehhua in aquin oquiniluic in tlacamen den Israel: “Dios mechmohualtitlanilis se tlayolchicauqui quen onechualtitlan nehhuatl, huan yehhuatl quisas se de namehhuan. Xicchihuacan cuenta ica yehhuatl.” ");
INSERT INTO ncjNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Noyojqui Moisés yeh in aquin ihuan ocatca in tlacamen den Israel ipan in acahualtlahtli, huan ihuan in ángel aquin ihuan otlahto ipan in tepetl itoca Sinaí. Ocatca ihuan tochichicacoluan huan oquiselic in tlahtoli de nemilistli matechpanolti. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Huan tochichicacoluan ahmo oquinejque quitlacamatisque, huan oquixtlasque huan inyolihtec yoquinequiyayahque mocuepasque Egipto. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ic inon oquiluihque in Aarón icniu in Moisés: “Ticnequihque xitechchihchihuili dioses matechyecanacan tehhuan, tleca ahmo ticmatihque tlen oquipanoc inon Moisés aquin otechquixti Egipto.” ");
INSERT INTO ncjNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ihcuac inon oquichihchihuilihque se cuacue tlamachihchiutli huan oquitlaolichtique. Oquinmictilihque yolcamen ic maquimahuestilican inon tlamachihchiutli. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ihcuac inon Dios oquixohuac den yehhuanten huan omocahuilihque maquimahuestilican in sitlalten den neluicactli. Ojcon ca ipan iamau se tlayolchicauqui canin omoluic in Dios: Namehhuantzitzin israeltecos, nanquinehnehuiliyahque nannechmahuestiliyahque ihcuac onanquitlaolichtihque ipan in ompohuali xihuitl ipan inon acahualtlahtli. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Huan onanquihuicayayahque ipalia in tlamachihchiutli itoca Moloc, aquin onanquimahuestiliyayahque ihuan isitlal oc se tlamachihchiutli itoca Renfán, yehhuan tlamachihchiuten tlen namehhuan onanquichiuque maquimahuestilican. Huan ic inon namechquixtilis namotlal huan namechtitlanis ipan tlali Babilonia. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Ihcuac ocatcahque ipan in acahualtlahtli oquipiyayahque tochichicacoluan in manteado cali quen in tiopan canin oquieuque in itlanahuatil Moisés. Oquichiuque inon tiopan quen Dios oquimonextili in Moisés. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Tochichicacoluan oquiselihque inon tiopan quen intetlocolil huan ocualicaque ipan yancuic intlal. Yeh in Josué aquin oquintlicanaltiyaya queman oquincuilihque intlal in oc sequin tlacamen aquin Dios oquinquixtiloc. Ijcon ocatca ihcuac ohualnexohuac in hueyixtoc David. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Yehhuatl oquitlahuelitalo in Dios huan oquinec quichihchihuas tecaltzin Dios aquin temahuestiliyahque ichanihcahuan in Jacob. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Huan yeh in iconeu David itoca Salomón aquin oquichihchiu inon tecaltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Huan in Dios aquin ilohuac neluicac ahmo mochantilo ipan cali tlamachihchiutli. Quen oquihto se tlayolchicauqui: ");
INSERT INTO ncjNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Mihtohua Totecohtzin, Nehhua nitequihua ipan neluicatli canin nimotlaliya, huan in tlalticpactli yeh in tlen ipan nicsehuis nocxi. ¿Tlen cali nannechchihchihuilisque? ¿Tleca ticnehnehuiliyahque nicnequis campa nimosehuis? ");
INSERT INTO ncjNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Cox, ¿ahmo nehhuatl aquin oquinmochihchiu nochin inin tlamantli? ");
INSERT INTO ncjNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Noyojqui oquiniluic in Esteban: ―Huan namehhuan nochipa tequin mohsiucamen huan ahmo nanquitlacamatihque itlahtoltzin Dios. Namehhuan nanquichihuahque ijcon quen namochichicacoluan quen nochipa nanquixnamiquihque in Itiotonaltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Tleca namochichicacoluan ahmo oquichiuque cuenta ica intlahtol inon tetlanonotzcahuan Dios. Oquinmictihque yehhuan aquin oquihtohque quen hualuilohuas in Tlamelajcatzintli Jesús, huan queman ohualuilohuac, onantetemactihque matemictican. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ahmo onantetlacamatque, masque onanquiselihque in itlahtoltzin Dios tlen omechpanoltilihque in ángeles. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Queman in tlacamen oquicajque inon itlahtol Esteban, ocualanque hasta omotlancuechohque. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Huan in Esteban quiyolquitzquihtoc Itiotonaltzin Dios, huan oahcotlachix neluicac huan oquitac in tlanextli canin ilohuac in Dios, huan oteitac in Jesús motelquetzalohtoc ipan iyecmatzin in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ic inon in Esteban oquihto: ―Xiquitacan, nepa neluicac niquita in Tetiachicau ica nochin tlacatl moquetzalohtoc ipan teyecmatzin in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Huan yehhuan omonacastzajque huan ocoutzahtzihque chicahuac huan ocualquitzquihque in Esteban. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Huan oquiquixtihque quiahuac ipan in altepetl huan opeuque quitemacahque. Huan in motencuanimen oquicautejque impampijca inahuac in tlahpiyani den tiopixcamen itoca Saulo. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Huan ihcuac oquitemacatoyahque, in Esteban otzahtzic in Dios huan oquihto: ―Notecohtzin Jesús, xicmoselili nonemilis. ");
INSERT INTO ncjNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Satepa omotlancuaquetz huan otzahtzic chicahuac: ―Notecohtzin, ahmo xiquinmotlahtlacoltili inin tlacamen. Huan satepa de ihcuac oquihto inon, omic. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Huan Saulo ihuan oquisematiyayahque in aquin oquimictihque. Inon tonali opeu se hueyi tlamatecalistli ipan itiotlayehualoltzin ompa Jerusalén. Omoxexelohque nochten inon tlaneltocanimen huan omochayauque ipan in tlali Judea huan Samaria, huan omocauque Jerusalén san yehhuan in tetiotlatitlaniluan. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Huan oc sequin tlaneltocanimen oquitocaque in Esteban huan molui ic otlocoxque. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ijconon Saulo molui oquintlahuelitac in tlaneltocanimen, huan ocalaquiyaya sehse inchahchan huan oquinquixtiyaya ipan cali huan oquintotoxohtaya in tlacamen huan sihuamen, huan oquinuicac ihtech telpiloyan. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Huan yehhuan aquin ocholohque Jerusalén otlanonotzayayahque ica in yancuic itlahtoltzin Cristo ic nohuiyan canic oyayahque. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Huan ijcon se tlaxelohuani itoca Felipe oya ipan in altepetl Samaria huan opeu quinnonotza ica in itlahtoltzin Cristo. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Huan in tlacamen omosentlaliyayahque huan nochten oquichiuque cuenta in tlen oquiniluiyaya in Felipe. Huan noyojqui oquitayayahque quen molui mahuestic in tiotlachiuten tlen oquichihuayaya. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tleca oquimpahti miyacten in aquin oquipiyayahque in ahmo cuali yehyecatl. Huan ijcon tzahtzitihue ihcuac oquisayayahque. Noyojqui oquimpahti miyacten aquin mocoupitzquetzticaten huan in xonecuilten. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Huan ipan inon altepetl nochten opactoyahque. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Huan ocatca se tlacatl itoca Simón. Huan omotenextiliyaya tlamatqui. Ijcon oquincahcayahuayaya in tlacamen den altepetl Samaria. Huan oquihtohuaya: “Nele neh nicmati.” ");
INSERT INTO ncjNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nochin oquineltocayayahque ica yehhua. Ijconon nochten ocualsematque inon tlacatl huelis yehhua ichicahualistzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Huan ica yehhua oquichihuayayahque cuenta, tleca yihuehcau oquincahcayahuayaya ica in tlamatcayotl. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Huan oquineltocaque itlahtol Felipe, quen oquinnonotz ica tetlatequiutilistzin Dios huan quen cuali maquisasque ica Itocahtzin Jesucristo. Huan ic inon omocuatequihque nochten quen tlacamen huan sihuamen. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Noyojqui Simón oquineltocac huan omocuatequi. Huan ijcon oquicuitlapanuic in Felipe, huan tequin oquihuelitac quen oquichihuayaya ica iman in tlanextilisten huan in tlachiuten mahuestic. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Huan oquimatque in tetiotlatitlaniluan aquin ocatcahque Jerusalén quen oquiselihque itlahtoltzin Dios in tlacamen den Samaria. Oquintitlanque ompa in Pedro huan Juan. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ihcuac oahsihque, omoyolmachtihque ica in tlaneltocanimen den Samaria, mateselican in Itiotonaltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tleca ayamo quinualahsilotoc niyan se de yehhuan. San omocuatequihque ica Itocahtzin Totecohtzin Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ic inon Pedro huan Juan oquitlalihque inman ipan yehhuan, huan ijcon oteselihque Itiotonaltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Queman Simón oquitac quen quinualahsitiu in Itiotonaltzin Dios san ic oquitlalihque inman in tetiotlatitlaniluan, oquinnextili tomin, ");
INSERT INTO ncjNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","huan oquiniluic: ―Xinechmaca noyojqui inon tequitl. Ihcuac neh noyojqui nictlalis noman ipan san aquin, yeh noyojqui maquiseli in Itiotonaltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ihcuac inon oquiluic in Pedro: ―Ocachi cuali xiyau mictlan ican motomin tleca ticnehnehuiliya cuali ticohuas itetlocolil Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ahmo tlen ticpiya tiquitas ipan inin, tleca ahmo tlamelajcan moyolo iixpa in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Xicahua inon motlahtlacol huan ximotlatlauti tenahuac in Dios tla cana mitztlapohpoluilos ica tlen ticnehnehuilihtoc ipan moyolo. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Tleca nicnehnehuiliya tequin tinexicoltic. Ic inon motlahtlacol nesi yimitzilpihtoc. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Huan ijconon oquinanquilic in Simón: ―Nopampa ximoyolmachtican namehhuan, ahmo tlen nopa maahsi in tlen onannechiluihque. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","In tetiotlatitlaniluan oquichipauque huan otlanonotzque ica itlahtoltzin Dios ipan miyac altepemen den Samaria, huan omocuepque Jerusalén. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Satepa de inin, se ángel den Totecohtzin oquiluic in Felipe: ―Xiyau ic tlahtzintla ipan ohtli tlen temohua Jerusalén huan yau ahsi ipan altepetl Gaza. Yeh in ohtli tlen panohua ipan in hueyi acahualtlahtli. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Oya Felipe huan ipan ohtli oquinamic se hueyi tequihua den tlali Etiopía. Yeh inon tlacatl itlaeucau in sihuatl hueyixtoc den Etiopía itoca Candace. Inon tlacatl oyahtoya quimahuestiliya Dios nepa Jerusalén. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Yehhuatl mocueptica ipan ialtepeu, huan yehuatiu ipan se cocoucarro. Huan momachtihtiu ipan iamau in tlayolchicauqui Isaías. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Oncan in Itiotonaltzin Dios oquiluiloc in Felipe: ―Ximohualpacho nonahuac ipan in cocoucarro. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Huan omopacho Felipe huan oquicac ihcuac oamapouticatca ipan iamau Isaías, huan oquitlahtlani: ―¿Monehnehuiliya tlen momachtilohtica? ");
INSERT INTO ncjNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","In tlacatl oquinanquilic: ―Ahhuel nicnehnehuilis; ahmo oncan aquin nechyequiluis. Huan oquinotz in Felipe: ―Xihualehco huan ximotlali nonahuac. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Oquipoutoya in Itlahcuiloltzin canin quipiya inin: Ocuicaque quen calnelo ic quimictis, huan omocau tlamach quen calnelo ihcuac moichcayotequi. Niyan ahmo oquitlapo icamac. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Oquipinautihque masque ahmo tlen oquichiu. Cox, ¿aquin cuali quihtos ica inon ahmo cuali tlen oquichihuilihque? Tleca oquimictihque nican tlalticpac. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","In tequihua oquitlahtlanic in Felipe: ―Nimitztlatlautiya, huan xinechilui; ¿tlahtohua in tlayolchicauqui ica san yehhua noso ica oc seya? ");
INSERT INTO ncjNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ihcuac inon in Felipe opeu tlanonotza ipan in Itlahcuiloltzin canin oquipouticatca in tequihua huan oquiyequiluic in yancuic tlahtoli ica Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Huan ihcuac opanotayahque canin ocatca in atl, oquihto in tequihua: ―Nicanca in atl. Cox, ¿cuali nica nimocuatequis? ");
INSERT INTO ncjNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felipe oquinanquilic: ―Cuali tla ic nele moneltoca ipan moyolo. Huan oquinanquilic in tlacatl: ―Nicneltoca in Jesucristo Iconetzin in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ic inon oquitelquetz in cocoucarro huan otemohque in inehuan ipan in atl huan in Felipe oquicuatequi in tlacatl. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ihcuac ohualehcotayahque ipan in atl in Itiotonaltzin Dios ocuicaloc in Felipe, huan ayacmo oquitac in tlacatl. Huan yehhua ijcon oya pactiu. ");
INSERT INTO ncjNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Huan Felipe san tlama oahsihto ipan in altepetl Azoto, huan opanotaya ipan altepemen tlanonotztiu in itlahtoltzin den temaquixtilistli. Huan ijcon oahsic ipan oc se altepetl itoca Cesarea. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ihcuac inon in Saulo quintemohtinemi hasta quinmictis in tlaneltocanimen ica Totecohtzin. Huan ic inon oya quita in hueyixtoc den tiopixcamen. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Huan oquitlahtlanili in tlasellarolten tlen ic motemactihtiu inahuac in tequihuahmen ipan in tiopanten ihtech in altepetl Damasco, ic mamocahuilican quintemos in tlaneltocanimen. Quinualicasquiyani tlatemactilten in tlacamen huan sihuamen ipan in altepetl Jerusalén. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Huan ayacmo huehca ic ahsis ipan altepetl Damasco huan san tlamach oquitac se tlanextli ohualpetlan den neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Huan ohuetz tlalpa in Saulo huan oquicactehuac tlen cualiluiya: ―Saulo, ¿tleca tinechmateca? ");
INSERT INTO ncjNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ijcon otetlahtlani in Saulo: ―¿Aquin Tehhuatzin, Notecohtzin? Huan oquihualnanquililoc: ―Nehhua niJesús. Yeh in nehhuatl tinechmateca. San tehhuatl mosel timocococohtica, quen quichihua in cuacue ihcuac quitlasa in icxi quen ihcuac quitzintzapiniyahque. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Huan Saulo opapatlacaticatca ica moucayotl, huan otetlahtlani: ―Notecohtzin, ¿tlen monequi manicchihuas? Huan omonanquilic in Totecohtzin: ―Ximoquetza huan xiyau ipan in altepetl huan ompa mitziluisque tlen ticpiya ticchihuas. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Huan tequin omomoutihticatcahque in tlacamen aquin oquicuitlapanuihtinemiyayahque in Saulo, tleca oquicacteuque tlahtoli huan ahmo aquin oquitaque. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saniman omoquetztehuac in Saulo, huan yolic ic oyectlahtlachix huan ahhuel tlen oquitac. Ijcon omomaquitzquihtayahque ic oyahque ipan in altepetl Damasco. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ipan yiyi tonali ahhuel tlen oquitac, huan ahmo tlen oquicua huan niyan tlen oconic. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Se tlaneltocani ochantiyaya ipan in altepetl Damasco itoca Ananías. Omoixahsitehuac in Totecohtzin huan omonotz: ―¡Ananías! Huan otenanquilic yehhuatl: ―¿Tlen monequi, Notecohtzin? ");
INSERT INTO ncjNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Huan Totecohtzin omoluic: ―Xiyau ipan calle itoca Derecha huan tiahsis ichan Judas. Huan titlahtlanis ica se tlacatl itoca Saulo, ialtepeu itoca Tarso. Nepa moyolmachtihtoc. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Huan onicmocochnextili se tlacatl itoca Ananías aquin omopacho inahuac huan oquitlali iman ipan yehhua. Huan ijcon matlachiya oc sepa. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Queman oquicac inin, Ananías oquiluic: ―Notecohtzin, nechnonotztoque miyacten ica inon tlacatl, huan ic nochin in tlen ahmo cuali quichiutoc ica tetlapehpeniluan nepa Jerusalén. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Huan axan nican ohualahsic ica intlasellarolten den achtohque tiopixcamen. Huan ijcon quinuicanihque tlamactilten nochin yehhuan aquin quineltocahque ica Tehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ic inon omihto in Totecohtzin: ―Xiyau, tleca yinicpehpenihtoc inon tlacatl matlanonotza ica nehhua. Quinnonotzas in aquin ahmo judeahtecos ic nohuiyan ipan in tlalticpactli, ihuan inueyixtoque. Huan noyojqui quinnonotzas in tlacamen den Israel. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nicnextilis quen tequin quipiya tlapanos nopampa. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ijcon Ananías oya ipan in cali canin ocatca Saulo. Oquiahsito huan oquitlalili iman ipan yehhua huan oquiluic: ―Tocniu Saulo, Totecohtzin Jesús omitzmonextililoc ipan in ohtli canic otihualaya. Yehhuatzin onechualtitlaniloc ic xitlachiya oc sepa huan mitzualahsisque in Itiotonaltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Saniman ohuetz in tlen oquimohsihuihticatca ipan iixtelolo huan oc sepa cuali otlachix in Saulo. Ic inon omeu huan omocuatequi. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Huan satepa otlacua huan omelan oc sepa. Huan omocau sequin tonalten inuan in tlaneltocanimen aquin ochantiyayahque ipan in altepetl Damasco. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","In Saulo saniman opeu tlanonotza ipan in tiopanten den judeahtecos. Huan oquiniluic in Jesús Iconetzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nochten aquin oquicacticatcahque quen tel oquimauteuque huan oquihtohteuque: ―Nele inin tlacatl yeh in aquin oquinmatecatinemiyaya in tlaneltocanimen den Jesús nepa Jerusalén. Huan nican noyojqui ohuala maquinana in tlamactilten. Huan quintemactisquiyani inmajco in achtohque tiopixcamen. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ijcon Saulo ocachi chicahuac otlanonotzayaya quen Jesús, Yehhuatzin in Cristo Tetlapehpeniltzin Dios. Huan ijcon oquinnontzacuato in judeahtecos aquin ochantiyayahque ipan in altepetl Damasco. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Satepa den miyac tonalten ocualsematque in judeahtecos quen quimictisque in Saulo. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Huan oquimat yehhuatl. Quen tlahca huan quen tlayohua oquipihpiyayahque ipan in puerta canin in Saulo quisasquiyani ipan in altepetl ic quimictisquiyanihque. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Huan in tlaneltocanimen oquitlalihque iihtectla se hueyi chiquihuitl huan ic tlayohua oquitemohuihque ipan in tepamitl tlen quiyehualohua in altepetl huan ijcon omaquis. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Queman oahsic Jerusalén Saulo oquinec mosetilis inuan in tlaneltocanimen. Huan yehhuan nochten quimoucaitahque, tleca ahmo oquimatiyayahque tla cana yi tlaneltocani. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Masque ahmo oquixmatiyayahque, in Bernabé oquinixmatilti in tetiotlatitlaniluan. Oquinnonotz quen Saulo oteitac Totecohtzin ipan in ohtli huan ijcon tehuan otlahtoc. Noyojqui oquinnonotz quen Saulo ahmo oquimohmoutic ic tlanonotzas mateneltocacan ica in Jesús ipan in altepetl Damasco. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ic inon Saulo omocau ipan in altepetl Jerusalén huan nisic nepic inuan oyaya. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Huan ahmo ica moucayotl ic otlanonotzayaya mateneltocacan ica in Totecohtzin. Huan omoixnamijque ic monohnotza ihuan in judeahtecos aquin tlahtohuahque intlahtol in griegohtecos. Ic inon omotemacayayahque ic quimictisque. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Queman oquimatque inon, in tocnihuan ocuicaque in Saulo ipan in altepetl Cesarea, huan oquititlanque ipan oc se altepetl itoca Tarso. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Huan ic inon ayacmo oquintzacuiliyayahque in tlaneltocanimen ica in Jesús huan omochicauque ipan nochin altepemen ipan tlali Judea huan tlali Galilea huan tlali Samaria. Huan nochten temoucaitztinemihque teixpa in Dios huan oquinyolchicahualoc Itiotonaltzin. Huan ijcon omomiyaquilihque in tlaneltocanimen. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Quen Pedro oquinchanuihtinemiyaya in tocnihuan, noyojqui oya quinita sequin tetlapehpeniluan Dios aquin ochantiyayahque ipan altepetl Lida. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ompa oquiahsic se tlacatl itoca Eneas, in aquin omocoupitzquetzticatca cana chicueyi xiupa. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Huan Pedro oquiluic: ―Eneas, Jesucristo mitzpahtilos. Ximehua huan xicyectlali mopehpech. Eneas niman omeu. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Huan oquitaque nochten aquin chantihque ipan in altepemen Lida huan Sarón. Huan oquilcauque in achto intlaneltoquilis huan oquineltocaque itlahtoltzin Totecohtzin. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ipan inon tonalten ipan in altepetl Jope ocatca se tlaneltocani itoca Tabita, huan ica itlahtol griegohteco oquitocahhuiyayahque Dorcas. Inon sihuatl nochipa oquichiutinemiyaya cuali huan oquimpalehuiyaya in prohues. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ipan inon tonalten omococo huan omic in Dorcas. Huan queman oquipahpacaque, oquitecaque itlacayo ipan in piso segundo. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","In altepetl Jope ahmo huehca moitzticaten ihuan in altepetl Lida, canin ocatca in Pedro. In tlaneltocanimen oquimatque yehhua ompa ocatca huan oquintitlanque ome tlacamen mayacan quiluican: ―Xihsihui huan xihuala ic Jope. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ic inon Pedro oya inuan. Queman oahsico, oquihuicahque canin ocatca itlacayo in mijqui. Huan nochten in viudas oquiyehualohque in Pedro huan otzatzahtziteuque. Huan oquinextilihque itlaquenuan tlen oquichihchiu in Dorcas ihcuac onemiyaya. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Saniman in Pedro oquinquixtic nochten huan yehhua omotlancuaquetz huan omoyolmachti. Huan oquitzticatca in sihuatl mictoc huan oquiluic: ―Tabita, xiihsa. Ic inon niman oquitlapo iixtelolo huan queman oquitac in Pedro, omohualeu huan omotlali ipan ipehpech. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedro oquimaquitzqui huan oquiquetz. Saniman oquinnotz in tocnihuan ihuan in viudas, huan ijconon oquinnextili yolqui. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Inon omomat nohuiyan ipan in altepetl Jope, huan miyacten oquineltocaque ica Totecohtzin. ");
INSERT INTO ncjNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Huan omocau Pedro sequin tonalten ipan inon altepetl, ichan se cuitlaxchihchiuqui itoca Simón. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ipan in altepetl Cesarea ocatca se tlacatl itoca Cornelio. Yehhuatl se tlayecanqui ica se ololi den soldados itoca Italianos. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Inon tlacatl ihuan nochin ichanihcahuan otemahuestilihque Dios huan otetlacamatque. Noyojqui oquimacayaya miyac tomin tlen ic oquimpalehuiyaya in judeahtecos aquin oquimpolohuayaya huan nochipa omoyolmachtiyaya ica Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ipan se tonali, cana yiyi horahtiotlac, oquicochitac yec tlamelajcan se ángel. Ohualcalac in ángel huan oquinotz: ―¡Cornelio! ");
INSERT INTO ncjNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelio ic oquitac in ángel omonontzacu ica moucayotl. Huan otetlahtlani: ―¿Notecohtzin, tlen inin? Huan oquinanquilic in ángel: ―Oquicaquiloc in Dios tlen ic otimoyolmachti huan quen otiquimpalehuiyaya in aquin oquipolohuaya. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Tel, xiquintitlani motlaquehualuan ipan in altepetl Jope. Maquinotzacan mahuala in Simón, noyojqui itoca Pedro. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Quichampixtoc ichan oc se itoca Simón noyojqui. Yehhuatl se cuitlaxchihchiuqui mochantihtoc inahuac in mar. Yehhuatl in Pedro mitziluis tlen ticchiutiyes. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ihcuac inon oya in ángel aquin oquinotz. Oquinnotz in Cornelio inehuan aquin oquipalehuihticatcahque huan se soldado yolcuali aquin temahuestiliya in Dios huan moyolohmati ihuan Cornelio. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Oquiniluic tlen oquitac huan satepa oquintitlan ipan in altepetl Jope. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ic mostla mero oquiahsitohque ipan altepetl Jope. Huan Pedro otlehcoc ipan in cali den sotea cana ic nepantla. Oquinec moyolmachtis. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Huan tequin oapismicticatca. Yoquinequiyaya tlacuas huan ic oquichihchihuilihticatcahque itlacual, otlacochitac. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ipan neluicactli oquitac ohualtemohuaya ic tlalpa quen se hueyi manta. Quen se payo tlaquechilpili. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ihtech inon manta ocatcahque san tlen yolcamen huan totomen. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ic inon oquicactehuac se tlahtoli tlen oquiluic: ―Ximoquetza Pedro. Xicmicti huan ticuas. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Huan in Pedro otenanquilic: ―Ahmo, Notecohtzin, ahyic nicamahuiya ica tlen techtlacahualtiya tehhuan judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Huan oc sepa oquicac inon tlahtoli huan oquiluic: ―Queman Dios mihtos ayacmo quintlacahualtihtoc, tehhuatl ahmo xiquixtlasa. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ijcon opanoc yexpa, huan inon manta omocuep ic neluicac. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Huan Pedro molui omonehnehuilihticatca tlen inon oquitac. Huan niman oahsicohque caltenco itlanahuatiluan Cornelio. Ijcon ohualahque tlahtlantihuitzen canin ichan Simón. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ihcuac yotlahtoteuque, otlahtlanque chicahuac in tla ompa yetoc seya itoca Simón Pedro. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ijcon Pedro oc monehnehuilihtica in tlen oquicochitac queman in Itiotonaltzin Dios oquimoluilic: ―Xicaqui, mitznotzahque yiyi tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Xitemo huan xiyau inuan. Huan ahmo xicchiconehnehuili niyan chihton tleca nehhuatl notlatitlaniluan. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ijcon Pedro otemoc huan oquinahsito itlatitlaniluan Cornelio huan oquiniluic: ―Nehhuatl in aquin nanquitemohuahque. ¿Tlen ic onanualahque? ");
INSERT INTO ncjNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Yehhuan oquinanquilihque: ―Otechualtitlan in tlayecanqui Cornelio. Yehuatl se cuali tlacatl molui quimahuestiliyahque huan temoucaita in Dios. Nochten in judeahtecos quihuelitahque huan quitlasohtlahque. Se ángel oquiluic matenotza mahuilohua ichan, huan yehhuatl maquicaqui yec in tlen ticmoluilis. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ijcon oquinsehui in Pedro, huan ihuan omocauque inon tlayohua. Huan ic mostla Pedro inuan oya, huan oquiyolchicauque sequin tocnihuan aquin ochantiyayahque ipan in altepetl Jope. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ic huiptla oahsitohque ipan altepetl Cesarea canin oquinchixtoya in Cornelio inahuac se ololi den ichanihcahuan huan itenonotzcahuan melahuac. Nochten itetlatlautiluan. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Queman Pedro oahsic ichan in Cornelio, yehhua oquisehui huan omotlancuaquetz iixpa maquimahuestili. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Huan Pedro oquiquetz huan oquiluic: ―¡Ximoquetza! Nehhuatl noyojqui nitlacatl quen tehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ic ihuan omonohnotzticatca, ocalac in Pedro huan oquinitac miyacten tlacamen ompa omosentlalihque. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ijcon Pedro oquiniluic: ―Yinanquimatihque techtlacahualtilohtoc tehhuan judeahtecos ica totlanehnehuilis matimonelocan inuan in sentlapalchanimen. Niyan ahhuel ticalaquisque inchan. Huan Dios onechnextililoc ahmo niquixtohuetzos niyan aquin. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ic inon san quen onannechnotzque onihuala, niyan nitlahtolchihua. Huan axan onihuala nicmatis tlen ica onannechnotzque. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ic inon oquinanquilic in Cornelio: ―Yipanotoc nahue tonali ic inin hora nican onicatca nochan onimosauticatca. Huan onimoyolmachticatca ipan yiyi horahtiotlac, quen mostli. Huan oniquitac noixpa se tlacatl tzotzotlaca itlaquen. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Huan onechiluic: “Cornelio, in Dios no omocac in tlen otimoyolmachti, huan molnamiqui quen otiquimpalehui in aquin oquimpolohuaya. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Xicanacan Simón Pedro ipan in altepetl Jope. Ompa quichampixtoc in oc se Simón, se cuitlaxchihchiuqui aquin chanti inahuac in mar. Queman hualas, mohuan monohnotzas.” ");
INSERT INTO ncjNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ijcon onitlatitlan ihsiucan mamitztemocan, huan ocachi cuali yohualuilohuac. Axan tinochten nican ticaten teixpa in Dios huan ticnequihque ticaquisque nochin tlen Totecohtzin teiluilohtoc technonotzasque. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ic inon Pedro opeu quinnonotza huan oquiniluic: ―Axan nicnehnehuiliya ic nele Dios ahmo techchichicotlasohtlalo. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Huan moseliya masque aquin temoucaita huan mochihua in tlen cuali. Ahmo mochihua cuenta de canin chani. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Dios oquinnonotzaloc ica in cuali itlahtoltzin. Yeh in Jesucristo aquin otechnextililoc quen otechyequitaloc in Dios. Huan Yehhuatzin Totecohtzin tinochten. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yinanquimatihque tlen opanoc ipan intlal in judeahtecos. In Juan otlanonotzayaya matlacuatequican huan satepa ihcuac inon, in Jesús tealtepeu itoca Nazaret ohualquixohuac in tlali Galilea. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nanquimatihque quen Dios otemacaloc techicahualistzin in Itiotonaltzin Dios huan quen omochiutinemiyaya tlen cuali huan omopahtihtinemiyayahque in aquin otlapanolticatcahque ica ichicahualis in ahmo cuali tlacatl. Ijcon omochihuayaya tleca Dios tehuan ohuilohuayaya. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Huan tamechmacaticaten cuenta nochin tlen omochiu in Jesús quen nohuiyan ic Judea huan ipan in altepetl Jerusalén. Huan satepa otemictihque. Ijcon otemasohualtihque ipan in cruz. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Huan Dios oteyolitihque ipan yiyi tonali huan otechmonextililoc. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ahmo oquinmonextililoc nochin tlacamen, tlahmo san tehhuan aquin Dios otechtlapehpeniloc de achto ic ticchipahuasque. Ihcuac oyolihuac den mijcamen tehuan otitlacuahque. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Huan otechtequiutiloc matiquinnonotzcacan in tlacamen huan matitlatemactican quen Dios otetocahhuihque Yehhuatzin Jesús quen Tlixcomacani ica in tlacamen huan in mijcamen. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Noyojqui de yihuehcau nochin tetlayolchicaucahuan Dios otechnextilihque quen hualuilohuas in Jesús. Oquihtohque nochin aquin quineltocasque ica itlahtoltzin quintlapohpoluilos intlahtlacol. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro oc tlanonotztica ihcuac oquinualahxiltiloc in Itiotonaltzin Dios nochin yehhuanten aquin oquicacticatcahque itlahtol. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Huan ic inon quen tel oquimautejque in tlaneltocanimen judeahtecos aquin ihuan ohualahque in Pedro. Tleca ijcon in Itiotonaltzin Dios noyojqui oquinualahxiltiloc inin tlacamen, masque ahmo judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Tleca inon judeahtecos oquincaquiyayahque oc seseya ic tlahtohuahque huan ic temahuestiliyahque in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ijcon in Pedro oquintlahtlani: ―Cox, ¿oncan aquin cuali quintzacuilis ic mocuatequisque inihque tlacamen? Tleca yehhuan oteselihque in Itiotonaltzin Dios sajcon quen tehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Huan oquiniluic mayacan mocuatequican ica Tetocahtzin Jesucristo. Huan satepa oquitlatlautihque Pedro mamocahua inuan se quesqui tonali. ");
INSERT INTO ncjNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","In tetiotlatitlaniluan huan in tlaneltocanimen aquin ocatcahque ipan in tlali Judea oquicajque quen sequin tlacamen ahmo judeahtecos noyojqui oquiselihque itlahtoltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Huan ihcuac omocuep Jerusalén in Pedro, oquitlahtolchihuihque in tlaneltocanimen judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Oquitlahtlanihque: ―¿Tleca otiya tiquinita yehhuan aquin sentlapalchanimen, huan inuan otitlacua? ");
INSERT INTO ncjNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ic inon in Pedro oquintlaminonotz nochin tlen opanoc. Oquiniluic: ");
INSERT INTO ncjNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Onicatca ipan altepetl Jope, huan ihcuac onimoyolmachtihticatca, onicocochitac. Huan oniquitac nesi quen se hueyi manta. Ohualtemohuaya ic neluicac huan oilpihtoya naucan ipan iyecac huan onechualahsic. ");
INSERT INTO ncjNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ihcuac onitlachix yec oniquinitac iihtectla ompa ocatcahque san tlen yolcamen huan totomen. ");
INSERT INTO ncjNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Huan onicac se tlahtoli tlen onechiluic: “Ximoquetza Pedro. Xicmicti huan ticuas.” ");
INSERT INTO ncjNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Huan onicteluic: “Ocachi cuali ahmo, Notecohtzin, tleca ahyic nicamahuiya tlen techtlacahualtihtoque.” ");
INSERT INTO ncjNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ic inon oc sepa onechiluiloc: “Queman Dios omihto: Ayacmo mechtlacahualtihtoc; tehhuatl ahmo xiquixtlasa.” ");
INSERT INTO ncjNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ijquin opanoc yexpa, huan saniman omocuep ic neluicac inon manta. ");
INSERT INTO ncjNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ic inon hora oahsitohque yiyi tlacamen ipan in cali canin onicatca. Oquinualtitlanque den altepetl Cesarea, manechtemocan. ");
INSERT INTO ncjNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Huan Itiotonaltzin Dios onechtitlaniloc inuan huan ahmo tlen manicchiconehnehuili. Noyojqui nohuan oyahque inohque chicuasin tocnihuan. Tinochten oticalajque ichan inon Cornelio. ");
INSERT INTO ncjNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Otechnonotz quen nepa ichan oquitztoya se ángel oicatoya huan oquiluic in Cornelio: “Xiquintitlani in tlacamen ipan in altepetl Jope maquinotzacan in Simón Pedro. ");
INSERT INTO ncjNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Huan yehhuatl mitziluis quenin cuali mechmaquixtisque tehhuatl huan nochin mochanihcahuan.” ");
INSERT INTO ncjNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ihcuac onipeu niquinnonotza, oquinualahxiltiloc Itiotonaltzin Dios quen otechualahxiltiloc achto. ");
INSERT INTO ncjNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ic inon oniquilnamic quen otechiluiloc Totecohtzin: “Ic nele in Juan otlacuatequi ica atl, huan namehhuan mechcuatequilos ica Itiotonaltzin Dios.” ");
INSERT INTO ncjNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Tla Dios ijcon oquinmacaloc noyojqui in tlen otechmacaloc tehhuan aquin otiteneltocaque Totecohtzin Jesucristo, ahhuel niteixnamiquis Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ic inon ihcuac in tocnihuan oquicajque inon tlahtoli, ayacmo tlen oquihtohque huan otemahuestilihque in Dios. Oquihtohque: ―Ijcon quihtosnequi Dios noyojqui oquincahuililoc mamoyolcuepacan in tlacamen ahmo judeahtecos huan ijcon maquipiyacan in nemilistli nochipa. ");
INSERT INTO ncjNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ihcuac oquimictihque in Esteban, opeuque quinmatecahque in oc sequin tlaneltocanimen. Sequinten omoxexelohque huan oahsique in tlali Fenicia, huan oc sequin in tlali Chipre. Huan oc sequin oahsique ipan in altepetl Antioquía. Ompa otlanonotzque ica san yehhuan in judeahtecos ica itlahtoltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Huan sequin tlaneltocanimen inchan Chipre huan Cirene oahsitohque Antioquía. Huan otlanonotzque ihuan in masehualten ica itlahtoltzin Dios. Oquinmachtihque itlahtoltzin Jesucristo ijcon quinmaquixtilos. ");
INSERT INTO ncjNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Techicahualis Totecohtzin ica oquimpalehuiloc, huan ijcon miyaquin oquilcauque in achto intlaneltoquilis. Oteneltocaque Totecohtzin. ");
INSERT INTO ncjNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ihcuac in tlaneltocanimen ipan itiotlayehualoltzin Jerusalén oquicactejque tlen opanoc Antioquía, niman oquititlanque in Bernabé mayau quinita. ");
INSERT INTO ncjNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ihcuac oahsic in Bernabé, oquitac quen Dios oquintiochihualoc, huan tequin opac. Oquinyolchicahuato nochten mayecan yolcuali teixpa in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Tleca in Bernabé se cuali tlacatl huan molui quipixtoc Itiotonaltzin Dios. Huan yec oteneltocac. Ic inon miyac tlacamen oteneltocaque Totecohtzin. ");
INSERT INTO ncjNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ihcuac inon, in Bernabé oya quitemohua in Saulo ipan in altepetl Tarso. Queman oquiahsic, oquihuicac Antioquía. ");
INSERT INTO ncjNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ipan sentetl xihuitl ocatcahque inuan in tlaneltocanimen, huan oquinmachtihtoyahque miyacten. Yeh in Antioquía canin achto oquitocahhuiyahque cristianos in tlaneltocanimen tleca nentinemihque quen Cristo. ");
INSERT INTO ncjNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ipan inon tonalten oquisque Jerusalén sequin tetlanonotzcahuan Dios huan oahsitohque Antioquía. ");
INSERT INTO ncjNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Seya itoca Agabo omoquetz inepanco in tlaneltocanimen. Huan ica tetlanehnehuilis Itiotonaltzin Dios oquihto mach ahsiquiu se mayantli nohuiyan. Huan ijcon opanoc ipan in tonalten den hueyixtoc Claudio. ");
INSERT INTO ncjNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ic inon in tlaneltocanimen ipan Antioquía oquinehnehuilihque quimpalehuisque in tocnihuan aquin chantitoque ipan in tlali Judea, quen cuali quitemaca seya. ");
INSERT INTO ncjNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Huan ijcon oquichiuque, huan oquintitlanilihque intetlapalol inmajco in Bernabé huan Saulo. Yehhuan oquimactilihque in tlayecancamen ipan itiotlayehualoltzin nepa Judea. ");
INSERT INTO ncjNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ipan inon tonalten in hueyixtoc Herodes oquinmohsihui sequin tlaneltocanimen. ");
INSERT INTO ncjNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Oquintequiuti maquimictican in Jacobo, icniu in Juan. ");
INSERT INTO ncjNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Huan quen oquinehnehuili oquimpacti in judeahtecos, oquintequiuti noyojqui maquiquitzquican in Pedro. Inon opanoc ipan in iluitl ihcuac oquicuahque in pantzin in tlen ahmo semautoc. ");
INSERT INTO ncjNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ihcuac oquiquitzquihque in Pedro, in hueyixtoc Herodes otlatitlan maquitzacuacan ipan in telpiloyan. Huan oquipihpixticatcahque huan omopapatlaticatcahque in nahue ololten ica nanahue soldados. Oquinehnehuiliyaya quitemactini maquimictican maquipano iiluiu in judeahtecos itoca pascua. ");
INSERT INTO ncjNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ijcon in Pedro oquitzactoyahque huan oquiyecpihpixticatcahque. Huan in tlaneltocanimen mostli omoyolmachtihticatcahque huan molui omotlatlautihticatcahque ica yehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ipan in tlayohua achto den tonali ihcuac in Herodes quitemactini, ocochtoya in Pedro inuan ome soldados. Oquilpihtoyahque ica ome cadena huan oquipihpixtihticatcahque oc sequin soldados. ");
INSERT INTO ncjNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ihsiucan oquimonextili se ángel den Totecohtzin huan otlanextehuac ipan in telpiloyan. In ángel oquiahcolquitzqui ic oquihxiti huan oquiluic: ―Ximehua ihsiucan. Ic inon oquimacahcautehuac in cadenas. ");
INSERT INTO ncjNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Huan in ángel oquiluic ocachi: ―Ximotlahcoilpi huan xictlali motecac. Ihcuac ijcon oquichiu in Pedro, in ángel oquiluic: ―Xictlali mopampijca huan xinechcuitlapanui. ");
INSERT INTO ncjNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Huan Pedro oquis tlacuitlapa den ángel, niyan ic oquimat tla nele melahuac in tlen quichihua in ángel. Oquimonenextili quen oquicochitac. ");
INSERT INTO ncjNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Huan opanoque in achto ololi den soldados huan niman ipan in oc se ololi. Huan ihcuac oahsihque ipan in puerta den tepostli tlachixtica ic ohtli, inon puerta isel omotlapo. Oquisque huan ihcuac onehnenque oc chihton ipan in ohtli, in ángel oquicautehuac in Pedro. ");
INSERT INTO ncjNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ic inon in Pedro oixtlamautehuac huan oquihto: ―Axan nicnehnehuiliya melahuac Totecohtzin omohualtitlan teángel para nechmaquixtis iixpa in Herodes huan ojcon ayacuel tlen nechchihuilisque in judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Oquiyolnehnehuilihticatca in Pedro ic inon huan oahsic ichan María, inanatzin Juan Marcos. Huan nepa omosentlalihtoyahque miyacten ic omoyolmachtihtoyahque. ");
INSERT INTO ncjNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ihcuac otlixcalani ipan in puerta den sahuan, se ichpocatl itoca Rode oquinahualitac aquinon. ");
INSERT INTO ncjNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Huan queman oquitencac in Pedro, ahmo oquitlapo in puerta. Ica paquilistli otzecuin tlahtec quinnahuatiya ichanihcahuan mach Pedro ocatca iixco in puerta. ");
INSERT INTO ncjNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ijcon oquiluihque in ichpocatl: ―¡Otimonacaspatlac! Huan in ichpocatl oquintlaneltoctiyaya ic nele yehhuatl in Pedro. Huan yehhuan ahmo oquineltocaque huan oquihtohque: ―Ahmo yehhuatl; yeh in itonal. ");
INSERT INTO ncjNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Huan Pedro san ijcon oquichiuticatca huan ihcuac yoquitlapoluihque, oquitaque huan quen tel oquimauteuque. ");
INSERT INTO ncjNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Huan yehhuatl oquinchihuili senyas ica iman mamocahuacan, huan oquinnonotz quen Totecohtzin omoquixtic ipan in telpiloyan. Huan oquiniluic: ―Xiquiluican inin in Jacobo ihuan in tocnihuan. Huan ic inon oquis in Pedro huan ijcon oya oc se lado. ");
INSERT INTO ncjNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ihcuac yiyau tlatui, tequin oixpoliuque in soldados tleca ahmo oquimatque tlen opanoc ica in Pedro. ");
INSERT INTO ncjNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes otlatitlan maquitemocan huan quen ayacuel oquiahsic, oquintlahtlanic in soldados tlen opanoc. Otlatitlan Herodes maquinmictican in tlixpiyanimen. Satepa inon Herodes oquis Judea huan omochantihto Cesarea. ");
INSERT INTO ncjNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ocualantoya in Herodes ica in tlacamen den altepemen Tiro huan Sidón. Huan yehhuan oquisematque quen quiyolcuepas in Herodes. Omosetilihque ihuan se itequihuahicniu Herodes itoca Blasto. In Blasto inca otlahto inon tlacamen iixpa in Herodes, tleca Herodes oquintecpanohuaya hasta inuan ocualan. ");
INSERT INTO ncjNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herodes oquintlatitlanili mahualacan quimatican tlen tonali. Huan ipan inon tonali omotlaquenti ica cuahcuali itlaquen huan omotlali canin tlixcomaca huan oquinnonotz. ");
INSERT INTO ncjNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ijcon in tlacamen opeuque nahuatihque chicahuac: ―¡Inin aquin tlahtohua ahmo san tlacatl, in tlahmo se dios! ");
INSERT INTO ncjNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ipan inon hora se ángel den Totecohtzin oquicoco in Herodes. Tleca ahmo oquitemacac in mahuesyotl in Dios. Yehhua oocuilteyin ic omic. ");
INSERT INTO ncjNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Huan itlahtoltzin Totecohtzin omochayautaya huan otlanonotzayayahque nohuiyan. ");
INSERT INTO ncjNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabé huan Saulo oquitlamihque intequiu ic tlen oyahque Jerusalén huan omocuepque Antioquía. Inuan oyahyaya in Juan aquin noyojqui itoca Marcos. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ocatcahque tetlanonotzcahuan huan tlamachtiyanimen ipan tetiotlayehualoltzin Dios tlen ocatca Antioquía. Yehhuan Bernabé, huan Simón aquin noyojqui oquitocahhuiyaya Negro, huan Lucio ialtepeu Cirene, huan Manaén, huan Saulo. In Manaén yeh in aquin oyol ichan in hueyixtoc Herodes. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ipan se tonali ihcuac omosentlalihtoyahque mamoyolmachtican huan mamosahuacan, in Itiotonaltzin Dios oquinmoluilic: ―Xinechsecnintlalilican in Bernabé huan Saulo ica in tequitl tlen yiniquiniluihtoc. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ic inon ocachi omoyolmachtihque huan omosauque huan oquintlalilihque inman impan Bernabé huan Saulo, quihtosnequi maquinyolchicahualo ica inon tequitl. Ijcon omomatlapalohque ic oyahque. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Satepa quen inon Itiotonaltzin Dios oquintitlaniloc in Bernabé huan Saulo, oyahque tel ipan in altepetl Seleucia huan de ompa oquisque ipan barco oahsique ipan in tlali inepanco in atl itoca Chipre. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ihcuac oahsique ompa itentla in atl ca se altepetl itoca Salamina. Ompa opeuque tlanonotzahque ica itlahtoltzin Dios ipan tiopanten den judeahtecos. Juan noyojqui oyaya inuan quen intepalehuihcau. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Onemiyayahque ipan inon tlali hasta oahsique ipan in altepetl Pafos. Ompa ocahsitohque se judeahteco itoca Barjesús. Yehhua se tlamatqui. Molui tlacahcayauqui tleca oquihtohuaya mach ocatca tetlanonotzcau Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Inon tlamatqui ocatca ihuan in hueyixtoc Sergio Paulo. Yehhuatl se tlacatl molui tlanehnehuilisyo. In hueyixtoc otlatitlan maquinnotzacan in Bernabé huan Saulo, tleca oquinequiyaya quicaquis itlahtoltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Huan inon tlamatqui, aquin noyojqui itoca Elimas, oquinixnamic ahmo maquitlaneltocti in hueyixtoc. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","In Saulo, noyojqui itoca Pablo, molui quipixtoc Itiotonaltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Yehhua oquiyequixitac in Elimas huan oquiluic: ―Titlacahcayauqui; ticoneu in ahmo cuali tlacatl. Tehhuatl tiquixnamiqui nochin tlen cuali. Ocachi cuali ximocamasehui huan ayacmo xiistlacatlahtohtinemi ica itlahtoltzin Totecohtzin. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Axan tel, Totecohtzin mitztlapanoltisque, huan timochihuas tipopoyotl se quesqui tonali. Saniman ihtech otlapoyau, huan oquitemohuaya seya aquin maquimaquitzquitiu tleca ayacuel tlachiya. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Queman oquitac inon tlen opanoc, in hueyixtoc niman oquineltocac tleca tequin otehuelitili itlahtoltzin Totecohtzin. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pablo huan yehhuan aquin ihuan oyahyaya oquisque ipan altepetl Pafos ipan barco, huan oahsihque ipan altepetl Perge tlen ca ipan in tlali Panfilia. Huan in Juan Marcos oquincautehuac huan omocuep Jerusalén. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Satepa de inon oquisque de Perge huan oyahque ipan in altepetl Antioquía ipan in tlali Pisidia. Huan ipan in tonali den nesehuilistli den judeahtecos ocalajque ipan in tiopan de yehhuan huan ompa omosehuihque. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","In tequihuahmen den tiopan oquimpohuilihque in itlanahuatil Moisés huan intlahtol tetlayolchicaucahuan Dios. Huan satepa queman otlan ic inon, oquintlatitlanilihque in Pablo huan Bernabé huan oquiniluihque: ―Tocnihuan, tla oncan tlen tlahtoli ic nantechyolchicahuasque, cuali nantechnonotzasque axan. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ijcon omotelquetz in Pablo huan oquiahcoc in iman ic yau quinnonotza: ―Xicaquican, nomasehualicnihuan, ihuan nochten aquin temoucaitahque in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Tohueyitahtzin Dios oquintlapehpeniloc tochichicacoluan. Oquinmiyaquililoc ihcuac ochantihtoyahque ic sentlapal ipan in tlali Egipto. Huan satepa oquinquixtiloc ipan inon tlali ica techicahualis. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Huan Dios omoxico intlamachilis cana ompohuali xihuitl ipan in hueyi acahualtlahtli. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Huan omoxitinilihque in chicome ololten den tlacamen aquin ochantiyayahque ipan in tlali Canaán huan oquinmacaloc in tlali in tochichicacoluan. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Huan satepa ipan nahue ciento xihuitl huan tlahco, Yehhuatzin oquinmotlalili in tlixcomacanimen hasta itonal in tlayolchicauqui Samuel. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ijconon otetlahtlanilihque in Dios: “Xitechmomaquili se in hueyixtoc matechtequiutis.” Huan oquinmacaloc in Dios in hueyixtoc Saúl ipan ompohuali xihuitl. Yehhuatl iconeu Cis, se tlacatl den ichanihcahuan Benjamín. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Huan satepa Dios oquiquixtilo in Saúl, huan omotlali hueyixtoc in David. Huan Yehhuatzin omihto: “Axan nele nechpactiya inin David, iconeu Isaí, tleca quichihuas nochin tlen nicnequi.” ");
INSERT INTO ncjNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Huan se ichichicaixuiu inon David yeh in Jesús. Huan Dios omotlali Yehhuatzin ic quinmaquixtilos in tlacamen den Israel, quen omihto. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ihcuac ayamo hualuilohuahtoc in Jesús, in Juan Tlacuatequiyani yoquinnonotz in tlacamen den Israel. Oquiniluic: “Mamopatla namotlamachilis ic nanmocuatequisque.” ");
INSERT INTO ncjNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Huan ihcuac imiquilistempa, in Juan Tlacuatequiyani oquihto: “Ahmo nehhua in Cristo quen nanquinehnehuiliya. Huan satepa de nehhua hualuilohuas Yehhuatzin huan ahmo tlen noquisca niyan ic nimochihua tetlapalehuiyani.” ");
INSERT INTO ncjNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Notlacaicnihuan, namehhuan techichicaixuihuan Abraham, ihuan nochin aquin temoucaitasque in Dios. Huan techtitlanilihtoc inin tlahtoli den tlamaquixtilistli. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Huan in aquin omochantiyayahque Jerusalén niyan itlayecancahuan ahmo oteixmatiyayahque in Jesús. Niyan oquinehnehuiliyayahque tlen quihtosnequi in tlahcuiloli den tetlayolchicaucahuan, masque quipohuasque ic chichicueyi den nesehuilistli. Ijcon yehhuan oquitzonquixtique inon tlahcuiloli ihcuac otetlahtlacoltihque in Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Huan masque ahhuel otechipahuilihque niyan tlen ic temictisque, oquitlahtlanihque in Pilato matlatequiuti ic matemictican. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Queman otechihuilihque nochin tlen tlahcuilohtoc, otetemohuihque ipan in cruz huan otehuicaque tetocahque. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Huan Dios oteihxitiloc ipan in mijcamen. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Huan ic huehcau sequin tonalten in Jesús oquinmonextili in aquin tehuan onemiyayahque ihcuac onemohuac ic Galilea huan Jerusalén. Huan axan yehhuan tlanonotztinemihque ica itlahtoltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Huan tehhuan tamechnonotzahque ica in cuali tlahtoli; inon tlahtoli oquinmacaque tocoluan. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Inon tlen yomotzonquixti ica tlen achto techiluilohtoc tehhuan in titeixuihuan, quen yoteihxitiloc in Jesús. Quen ca tlahcuilohtoc noyojqui ipan in salmo ome, quen Dios oteiluiloc: “Tehhuatl tinoconeu; yonimitzpehpeni matlatequiutiya in tlacamen.” ");
INSERT INTO ncjNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Huan quen nele oteihxitiloc ipan in mijcamen, ahyic ocachi mapalani tetlacayo, ijconon omihto: “Nimitzyecmacas in tlatiochihualistli quen oniquiluihtoya in David.” ");
INSERT INTO ncjNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ic inon ca tlahcuilotoc ipan oc se Salmo quen tla omihtoc in Jesús: “Ahmo mocahuilis mapalani in notlacayo in aquin Tlamelajcatzintli Teconetzin.” ");
INSERT INTO ncjNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Tleca David oquipalehui ialtepeu quen oquinextililoc in Dios, huan satepa omic, huan inahuac oquitocaque in itatahhuan, huan opalan itlacayo. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Huan inon aquin oteihxitiloc in Dios, ahmo opalan tetlacayo. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Xicyecmatican nocnihuan, ipampa inin Jesús, tamechnonotzasque quen mechtlapohpoluisque namotlahtlacol. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Yehhuatzin cuali quintlapohpoluilos intlahtlacol nochin in aquin teneltocasque, masque ica itlanahuatil Moisés ahhuel quixtlapachosque intlahtlacol. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ximomaluican tel, ahmo mamechahsi inin tlen oquihcuilohque in tetlayolchicaucahuan quen omihto in Dios: ");
INSERT INTO ncjNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Xiquitacan namehhuan aquin ahmo tlacaqui; xicchihuacan cuenta quen nampolihuisque. Tleca nicchihuas se tequitl ipan namotonal, huan inon tequitl ahmo nanquineltocasque masque seya mechnonotzas. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Huan ihcuac oquisque in Pablo huan Bernabé, oquintlahtlanilihque in tlacamen maquinnonotzacan ica inin tlahtoli ipan chicueyi tonali, yeh den nesehuilistli. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ihcuac yomoxexelohque in tlacamen den tiopan, oquincuitlapanuihque in Pablo huan Bernabé miyaquin judeahtecos ihuan in aquin ijcon oquineltocaque. Huan yehhuan oquinnonotzayayahque mamoquetzacan chicahuac ica tetlasohtlalis Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Huan ipan chicueyi tonali omosentlalihque nochten den altepetl ic maquicaquican itlahtoltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Huan ihcuac oquitaque in judeahtecos in miyac tlacamen omosentlalihtoyahque, ocualanque huan opeuque ica tlatlahtohuahque in Pablo huan oquipactecayayahque. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ihcuac inon omoixcohyehuihque in Pablo huan Bernabé ic oquiniluihque: ―Huelica otamechnonotzque achto ica itlahtoltzin Dios, huan quen ahmo nanquinequihque nanquiselisque in tlen ic nancahsisquiyanihque in nemilistli nochipa, tehhuan tiyasque tiquinnotzasque in aquin ahmo judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tleca ijcon otechualtitlaniloc in Totecohtzin huan omihto: Nimitztlalihtoc quen tlanextli ic maquinehnehuilican in aquin ahmo judeahtecos. Maticualicacan in tlamaquixtilistli ic nohuiyan ipan in tlalticpactli. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ic oquicajque in tlacamen aquin ahmo judeahtecos, opajque huan opeuque quihtohuahque cualtzin itlahtoltzin Totecohtzin. Huan oquineltocaque nochin yehhuan in aquin tlatlalili den Dios macahsican in nemilistli nochipa. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Huan ijcon omochayau in itlahtoltzin Totecohtzin ic nohuiyan ipan inon altepemen. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Huan oquinyolchicauque in judeahtecos inon sihuamen molui tlaneltocanimen de yehhuan huan aquin hueyi inquisca, maquinmohsihuican in Pablo huan Bernabé. Huan ic inon oquintotocaque ipan inon altepemen. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Huan in Pablo huan Bernabé omoxotzehtzelohque ica in teutli ic maquichihuacan cuenta ica intlahtlacol inon tlacamen, huan oyahque ipan in altepetl Iconio. ");
INSERT INTO ncjNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Huan in tlaneltocanimen molui oyolpajque ica in Itiotonaltzin Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ipan in altepetl Iconio in Pablo huan Bernabé ocalajque sansecnin ipan in tiopantli den judeahtecos. Huan oquinnonotzque miyac, huan sequin oquineltocaque huan sequin ahmo. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Huan inohque judeahtecos aquin ahmo oquineltocaque oquinyolchicauque yehhuan aquin ahmo judeahtecos, maquinehnehuilican ahmo cuali in tlaneltocanimen. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ic inon omocauque yehhuan nepa miyac tonalten, huan omoixcohyehuihque ic oquinnonotzque ica itlahtoltzin Dios, tleca otetemachihque in Totecohtzin. Huan Tohueyitahtzin oquinmactilo in chicahualistli maquichihuacan in tlachiuten mahuestic huan in tlaistlacolten. Ijcon oquinnextilihque quen Dios otlahuelitalo ic tlen oquinonotzayayahque. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Huan omoxehxelohque in tlacamen den altepetl. Sequin oquimpalehuiyayahque in judeahtecos huan oc sequin oquimpalehuiyayahque in tetiotlatitlaniluan. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ic inon sequin judeahtecos huan sequin in aquin ahmo judeahtecos san ocualsematque ihuan in tequihuahmen maquimpinautican huan maquintemacacan. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Huan ic oquimatque in Pablo huan Bernabé, ocholohque ic Listra huan ic Derbe, ome altepemen den tlali Licaonia huan ipan in tlalten tlen quiyehualohua inon altepemen. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Huan nepa noyojqui oquinnonotzayayahque in tlahtoli den tlamaquixtilistli. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ipan in altepetl Listra ocatca se tlacatl aquin ahhuel onehnemiyaya tleca inon tlacatl cuecueltic ic otlacat, huan ahyic onehnen. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Inin tlacatl oquicactoya in tlen Pablo oquihtohuaya huan Pablo oquiyequitac huan oquinehnehuili cana quineltocas ic pahtis. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ic inon oquiluic in Pablo ica chicahuac itlahtol: ―Ximoquetza yec ica in mocxi. Huan in tlacatl saniman omoquetz huan niman opeu nehnemi. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ic oquitaque in tlen oquichiu in Pablo, in tlacamen opeuque tzahtzihque ica itlahtol Licaonia, huan oquihtohuayahque: ―¡Dioses oixnesihque quen tlacamen ohualtemohuahque ica tehhuanten! ");
INSERT INTO ncjNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Oquihtohuayahque in Bernabé ocatca se dios Júpiter huan in Pablo ocatca se dios Mercurio, tleca yehhuatl in tlahtohuani. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Huan in tiopixqui den Júpiter oquipiyaya itiopan canic oahsiyayahque ipan in altepetl. Oquihualicac in cuacuehten huan in xochitl tlen ic quinxochihuayanihque. Huan in tlacamen oquinequiyayahque quinmahuestilisque. Quinmictilinihque in cuacuehten quen tlatemactilten. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Huan ihcuac oquichiuque cuenta in Pablo huan Bernabé, opeuque quitzohtzomotzahque intlaquen tleca otlocoxticaten queman oquinehnehuilihque quinmahuestilisquiyanihque. Huan ocalajque inepantla inon tlacamen, tzahtzitihue: ");
INSERT INTO ncjNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―¡Tlacatzitzin! ¿Tleca ijcon nanquichihuahque? Tehhuan noyojqui titlacamen quen namehhuan huan ic inon tihuitzen ic tamechiluisque quen xicahuacan nochin in tlen ahmo mechpalehuis, huan xicuitlapanuican in Dios yolihuatoc. Yehhuatzin in aquin oquichihualoc in neluicactli huan in tlalticpactli, huan in mar huan nochin tlen oncan nohuiyan. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ipan in oc sequin tonalten oquinmocahuili in Dios maquichihuacan in tlacamen quen oquinejque, ");
INSERT INTO ncjNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","masque nochipa oquinmonextilohuaya aquin Yehhuatzin quen oquinmochihuiliyaya in tlen cuali. Yehhuatzin omohualtitlaniyaya in quiahuitl huan in cuali tlamilolten huan otechmacalohuaya miyac ica tlen titlacuasque huan tipaquisque. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Masque ijcon oquihtohque inon tlahtoli, molui tequiyo ic oquinmohsihuihque in Pablo huan Bernabé quen quinmictiyanihque in cuacuehten quen tlatemactilistli ic quinmahuestilisque. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Oncan oahsicohque sequin judeahtecos den altepetl Antioquía huan den Iconio. Huan oquinyolchicauque in tlacamen huan oquitemacaque in Pablo. Oquinehnehuiliyayahque quen yoquimictihque huan oquitotoxohque tlatentli den altepetl. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Huan ihcuac oquiyehualohque in tlaneltocanimen in Pablo, yehhua omoquetz huan oc sepa ocalac ipan in altepetl. Huan ic mostla oquis ihuan Bernabé huan oyahque ipan in altepetl Derbe. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Oquinnonotzque in tlahtoli den tlamaquixtilistli ipan in alteptl Derbe huan miyac oquinneltoctihque ic mochihuasque momachtiyanimen. Huan satepa omocuepque ipan in altepemen Listra huan Iconio huan Antioquía. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ipan inon altepemen oquinyolchicauque in tlaneltocanimen maquineltocacan chicahuac. Huan oquiniluihque huelica quitlapanoltisque miyac tlamantli achto ijcon calaquisque ipan tetlatequiutilistzin in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Noyojqui oquintlalihque tequihuahten ipan sehse tetiotlayehualoltzin Dios, huan satepa ihcuac omoyolmachtihque huan omosauque, otetlatlautilihque in Totecohtzin maquinmaluilo in tlaneltocanimen. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Satepa opanoque ic Pisidia huan oahsitohque ipan in tlali den Panfilia. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Oquinonotzque in itlahtoltzin ipan in altepetl Perge, huan oncan oyahque ipan in altepetl Atalia. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Huan de ompa ohualahque ipan barco ic omocuepque Antioquía, in altepetl canin oquintitlanque ica itlasohtlalistzin Dios ipan in tequitl tlen axan yoquitlamihque. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ihcuac oahsique Antioquía, oquinsentlalihque nochin den itiotlayehualoltzin huan in Pablo huan Bernabé oquinnonotzque nochin tlen Dios oquinchihuililoc ica yehhuan. Oquiniluihque quen in Totecohtzin yoquinseliloc in aquin ahmo judeahtecos, huan yehhuan noyojqui cuali maquineltocacan. ");
INSERT INTO ncjNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Huan in Pablo huan Bernabé omocauque ompa miyac tonalten ihuan in tlaneltocanimen. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ipan inon tonalten ohualahque oc sequin tlacamen den Judea aquin oahsitohque Antioquía. Opeuque quinnextiliyahque in tlaneltocanimen huan oquiniluihque ahhuel maquisasque in tlahmo quitlalisque in ixmatcayotl den judeahteco, quen oquihtohuaya in Moisés. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pablo huan Bernabé oquincocolihque tequin. Huan oquintocahhuihque in Pablo huan Bernabé ihuan oc sequinten, mayacan Jerusalén maquicaquican inon tlahtoli in tetiotlatitlaniluan huan in tequihuahmen den tetiotlayehualoltzin Dios de inon altepetl. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Oquintitlanque inon tlaneltocanimen den tetiotlayehualoltzin Antioquía. Ic oyahyaya, opanohtayahque ipan in tlalten den Fenicia huan Samaria, huan oquinnotzayayahque quen yehhuan aquin ahmo judeahtecos yoquicauque in yihuehcau intlaneltoquilis ic tecuitlapanuisque in Dios. Huan nochten in tocnihuan opaquiyayahque molui ica inon tlahtoli. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ihcuac oahsitohque Pablo huan Bernabé ipan Jerusalén, oquinmosehuihque ipan in itlayehualoltzin in tlaneltocanimen ihuan in tetiotlatitlaniluan huan in tequihuahmen. Huan oquinnonotzque nochin tlen Dios omochiu ica yehhuan. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Huan sequin fariseos aquin oquineltocaque omoquetzque huan oquihtohque: ―In tlaneltocanimen aquin ahmo judeahtecos quipiyahque tlen quitlalisque in ixmatcayotl den judeahteco huan quitlacamatisque in itlanahuatil Moisés. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Oncan omosentlalihque in tetiotlatitlaniluan huan in tequihuahmen para quiyectlalisque inon tlahtoli. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Satepa ihcuac omononotzque huehcau, omoquetz in Pedro huan oquiniluic: ―Tocnihuan, nanquimatihque quen yihuehcau in Dios onechtlapehpeniloc ipan namehhuan ic niquinnonotzas in itlahtoltzin de temaquixtilistli maquineltocacan in aquin ahmo judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Huan Dios moixmati inyolo in tlacamen huan oquinextililoc quen quinselilos tleca oquinmacaloc in Itiotonaltzin ijcon quen otechmacaloc. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Dios ahmo aquin omoixpapatlac ica tehhuanten huan yehhuanten tleca noyojqui oquinyolchipahualoc ihcuac oquineltocaque. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Axan tel, ¿tleca nanquinmohsihuisque ic nanquinmatiltisque inon tlanahuatili ipan inohque tlaneltocanimen? Niyan tehhuan niyan tocoluan ahhuel tictlacamatihque. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ahmo maquinchihuilican ijcon tleca ticneltocahque timaquisasque ica tetlasohtlalis in Totecohtzin Jesús ijcon quen yehhuan. Yeh in quen otechuelitalo in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Oncan nochten omocauque tlamach, huan oquicajque ic otlahtohque in Pablo huan Bernabé. Oquinnonotzque nochin tlen molui mahuestic in Dios omochiu ipan yehhuan aquin ahmo judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ihcuac otlanque tlahtohuahque, in Jacobo oquiniluic: ―Nocnihuan, xinechcaquican. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Yoquinonotz in Simón Pedro quen Dios oquinseliloc ic achto in aquin ahmo judeahtecos. Noyojqui oquitlapehpeniloc impan yehhuan sequin tlacamen para Yehhuatzin. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Huan ijcon quisa quen oquihcuilohque in tlayolchicaucamen, ijcon quen mihtohua in Dios ipan in Itlahcuiloltzin: ");
INSERT INTO ncjNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Satepa de inin nimocuepas huan oc sepa niquintlalilis den ichanihcahuan David seya aquin tlicanas. Oc sepa nicyectlalis in tlen omocau, huan nimocuepas niquinnextilis ocachi ");
INSERT INTO ncjNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","manechtemocan nochin tlacamen, yehhuan aquin israeltecos huan yehhuan aquin ahmo. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ijcon mihtohua in Totecohtzin aquin oquinixmatiltiloc inin tlamanten den tlen yihuehcau panotoc. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Ic inon niquihtohua quen ahmo xiquinmohsihuican in aquin ahmo judeahtecos aquin omoyolcuepque ica in yihuehcau intlaneltoquilis ic maquineltocacan in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Quinamiquis quen matiquintlahcuiluican quen ahmo tlen maquitacan ica tlen quimahuasnequi ica inon dioses tlachihchiuten. Niyan aquin ahmo masihuaahuilti niyan matlacaahuilti. Huan ahmo xicuacan nacatl tlen tlamecanili, niyan in yestli. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tleca de yihuehcau oncan ipan sehsen altepetl aquin tlanonotzahque ica itlanahuatil in Moisés. Inon tlen quiamapohuahque ipan in tiopanten de yehhuan ipan in tonali den nesehuilistli. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ic inon in tetiotlatitlaniluan, huan in tequihuahmen, ihuan nochten ipan itiotlayehualoltzin oquintlapehpenihque sequin de yehhuan, mayacan ic Antioquía ihuan Pablo huan Bernabé. Oquitocahhuihque in Judas tlen noyojqui itoca Barsabás, huan Silas. Yehhuan tlacamen tequin tlen inquisca ipan in tlaneltocanimen. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Huan ica yehhuan oquititlanque inon amatl tlen oquihto: “Tehhuan titetiotlatitlaniluan huan titequihuahmen huan namocnihuan tiquintlahpalohuahque in tocnihuan aquin ahmo judeahtecos huan in aquin chantihque ic Antioquía huan ipan in tlalten den Siria huan Cilicia. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ticmautoque quen sequin tlacamen quistoque den nican, niyan ahmo totlamatiyan, huan mechmosihuihtohque namehhuan ica tlahtolten huan mechtlapolochtihtohque. Quihtohticaten quen nanquipiyahque nanquitlalisque in ixmatcayotl den judeahteco huan nanquipiyahque nanquichihuahque cuenta ica itlanahuatil in Moisés. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ic inon tehhuan tinochten oticnehnehuilihque cuali matiquintocahhuican sequin tlacamen de tehhuanten ic mayacan mechitacan namehhuan san secnin inuan totlasohicnihuan Bernabé huan Pablo. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Yehhuan omotemacaque ica innemilis tepampa Totecohtzin Jesucristo. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Tel, tamechtitlaniliyahque in Judas huan Silas, huan yehhuan ic tlahtosque ihuan namehhuan ic mechyecnonotzasque nochin inin. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Omosetilihque in Itiotonaltzin Dios ihuan tehhuan ahmo tamechtlalilisque niyan tlen ocachi yetec, san inin tlahtoli molui chicahuac. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ahmo xicuacan inacayo in yolcamen tlen quinmactihtoque in dioses tlachihchiuten. Noyojqui ahmo xicuacan in yestli niyan in inacayo in yolcamen tlen tlamecanilten. Huan niyan aquin ahmo masihuaahuilti niyan matlacaahuilti. Tla nanquitlacamatisque inin tlahtoli, cuali nanquichihuasque. Cuali mayetocan.” ");
INSERT INTO ncjNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ijcon quen yoquintitlanque, yehhuan oyahque in Antioquía. Huan ompa omosentlalihque ipan itiotlayehualoltzin huan oquintemactilihque in amatl. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Huan ihcuac in tocnihuan oquimpohuilihque, ic inon tequin oquinyolpactic inon tlahtoli. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Huan quen cuali tlanonotzasque noyojqui in Judas huan Silas, oquinyolsehuihque huan oquinyolchicauque molui in tocnihuan ica intlahtol. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Satepa ic panotoc se quesqui tonalten ompa, in tocnihuan oquinnahuatihque tlamach in Judas huan in Silas mamocuepacan ica aquin oquinualtitlanque. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Huan Silas oquinec mocahuas. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Noyojqui in Pablo huan Bernabé omocauque in Antioquía, huan ic oc miyac oc sequinten oquinnextilihtoyahque huan oquinnonotztoyahque in itlahtoltzin Totecohtzin. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Satepa de quesqui tonali in Pablo oquiluic in Bernabé: ―Tiohue oc sepa tiquinita in tocnihuan ipan nochin altepemen canin tiquinnonotztoque in itlahtoltzin Totecohtzin, ic tiquinitasque quen yesque. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","In Bernabé oquinequiyaya quihuicas in Juan Marcos. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Huan in Pablo oquinehnehuili cuali tla ahmo quihuicasque, tleca oquinualcautehuac nepa Panfilia huan ahmo oquincuitlapanuiyaya ipan inon tequitl. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Omotlahtolchihuihque huan omosesecninuihque. In Bernabé oquihuicac in Marcos huan oyahque ipan in barco ic Chipre. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","In Pablo oquitlapehpeni in Silas huan oquisque satepa ic in tocnihuan otetlatlautiyahque maquinyequitalo ica itlasohtlalistzin in Totecohtzin. ");
INSERT INTO ncjNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Huan opanoque ic in tlali Siria huan Cilicia, quinyolchicautihue in tocnihuan ipan in itiotlayehualolten. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pablo huan Silas oahsique ipan in altepemen Derbe huan Listra, canin ocahsitohque se tlaneltocani itoca Timoteo, iconeu se sihuatl judeahteco tlaneltocani, huan in itata griegohteco. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","In tocnihuan aquin ochantiyayahque Listra huan Iconio otlahtohuayahque yec ihuan yehhuatl. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","In Pablo oquinec maquicuitlapanui in Timoteo huan oquimacac in ixmatcayotl den judeahtecos ic ahmo quinixnamiquinihque in judeahtecos in aquin ochantiyayahque ipan inon tlalten, quen nochten oquimatque itata griegohteco. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Huan ipan nochin altepemen canic opanohuayahque, oquinnahuatihque in oc sequin tocnihuan in tlen oquinmotlalihque in tetiotlatitlaniluan huan in tequihuahmen aquin ocatcahque Jerusalén. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ijcon in tiotlayehualolten omochiuque chicahuac ipan intlaneltoquilis, huan omomiyaquiliyayahque in tlaneltocanimen mostli. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","In Itiotonaltzin Dios ahmo oquinmocahuili maquihtocan in itlahtoltzin ipan in tlali den Asia. Ic inon oquitlahcotejque ipan in tlalten den Frigia huan Galacia. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Huan oahsique hasta tlacpac den tlali Misia. Huan ompa oquinehnehuiliyayahque calaquisque ipan in tlalten den Bitinia, huan Itiotonaltzin Dios ahmo oquinmocahuili maquichihuacan. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Oncan opanotayahque huehca ic Misia huan otemohque ic in altepetl Troas canin mosehuiyahque in barcos. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ompa ic tlayohua oquimocochnextili in Pablo, huan oquitac se tlacatl den tlali Macedonia aquin omoquetz iixpa huan oquitlatlautiyaya: “Mapano ic Macedonia huan xitechpalehuihtehua.” ");
INSERT INTO ncjNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Huan ica tlen in Pablo oquimocochnextili, niman oticyectlalihque ic tiyasque Macedonia. Ticyecmauticatcahque technotzalohtiu in Dios ic matiquinnonotzacan in tlahtoli den temaquixtilistli. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Otitlecohque tel, ipan in barco nepa Troas, huan otiyayahque saniman ic se tlali tlen ca inepanco in atl, itoca Samotracia, huan ic mostla otiahsique in Neápolis. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","De ompa otiyahque Filipos, yeh in altepetl ocachi hueyi ipan inon tlalten den Macedonia. Ompa oticatcahque sequin tonalten. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Se tonali den nesehuilistli otiquisque tlatentli den altepetl inahuac se atentli canin nochipa yahue moyolmachtiyahque. Otimotlahtlalihque ompa otiquinmacaque itlahtoltzin Dios inon sihuamen aquin omosentlalihtoyahque. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Se de yehhuan itoca Lidia, huan inon de se altepetl itoca Tiatira. Yehhuatl oquinemacayaya sequin tatapahtli cuali in ipahyo morado. Inon sihuatl otemahuestiliyaya in Dios huan otecacticatca, huan in Totecohtzin oquiyoltlapoloc ic maquichihua cuenta in tlen oquihtohuaya in Pablo. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Oncan omocuatequihque ihuan in ichanihcahuan huan satepa otechyecolti, quen techiluihtiu: ―Tla nanquinehnehuiliyahque ic nele nitlaneltocani ipan Totecohtzin, xihualacan ximotepaluican nochan. Huan otechtlatlautic matimotzecocan. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Opanoc se tonali ihcuac otiyayahque timoyolmachtiya, oticahsitohque se ichpochtli tlayolchicauqui. Ocatca inmajco in itecohhuan huan oquitlaniyaya miyac tomin ica inon itequiu. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Inon ichpochtli opeu techcuitlapanuiya huan tlahtohtiu: ―Inin tlacamen tepalehuiyahque in Dios tlen huehcapa metztoc. Mechiluihtihue ica in yancuic tlanehnehuilistli den temaquixtilistli. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Oquichiu inin ipan miyac tonalten, ihcuac in Pablo yoquimohsihui. Omocuep huan oquiluic in ahmo cuali yehyecatl in tlen ipan ocatca yehhua: ―Ic Itocahtzin Jesucristo nimitztequiutiya, xiquisa ipan yehhua. Huan in ahmo cuali yehyecatl oquicau saniman. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Huan ihcuac inon in itecohhuan in ichpocatl oquitaque ayacmo ocatca tlen ic quitlanisque in tomin ica inon ichpocatl. Oncan oquinquitzquihque in Pablo huan Silas huan oquinuicaque inixpa in tequihuahmen ipan in tiyanquistli. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Oquintemactihtohque inahuac in tlixcomacanimen huan oquihtohque: ―Inin tlacamen yehhuan in judeahtecos, huan opeuque tlamohsihuiyahque ipan toaltepeu. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Huan oquinnextiliyayahque intlanehnehuilis quen tehhuan ahhuel ticselisque tleca tehhuan tiromanohtecos. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Oncan in tlacamen oquinixnamijque in Pablo huan Silas, huan in tequihuahmen otlatequiutihque maquintlaquenquixtican huan maquinuihhuitequican ica tlacotl. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ihcuac yoquinuihhuitejque tequin, oquitequiutihque maquinixpiyacan yec. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ihcuac oquicac inon tlanahuatili, in tlixpixqui oquincalaqui ocachi ompic tlahtec ipan in telpiloyan. Huan oquinxoilpihque yec ipan in cuartones. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Huan ic tlahcoyohuac in Pablo huan Silas omoyolmachtihtoyahque huan ocuihcuicatoyahque teca in Dios. Huan in oc sequin aquin ompa tzactoque oquincacticatcahque. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Huan san tlama ohualuehueyocatehuac chicahuac huan oquitzetzelo in tepamitl den telpiloyan. Huan niman omotlapohque in puertas huan otlacahcauque in cadenas ipan inohque aquin tzactohque. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","In tlixpixqui oihsatehuac, huan oquitac in puertas den telpiloyan nochin tlapoutoque. Oquiquixti in espada ic momictini, tleca oquinehnehuili yocholohque in motzacuanimen. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Huan Pablo oquitzahtzili: ―Ahmo tlen ximochihuili, tinochten ticaten nican. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Oncan in tlixpixque oquitlahtlan in tletl, huan ocalac niman. Huan huehueyocatiu ica moucayotl, omotlamotlac icxitla in Pablo huan Silas. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Huan niman oquinquixti huan oquintlahtlani: ―Tlacatzitzin, ¿tlen nicchihuas ic nimaquisas? ");
INSERT INTO ncjNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Huan yehhuan oquinanquilihque: ―Xiteneltoca in Totecohtzin Jesucristo huan timaquisas, tehhuatl ihuan mochanihcahuan. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Huan oquinnonotzque itlahtoltzin Totecohtzin inuan nochin in ichanihcahuan. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Huan inon tlayohua in tlixpixqui oquimpaquili canin omoxoxoleuque. Oncan yehhuatl inuan in ichanihcahuan oquincuatequihque. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Satepa oquinuicac ichan huan oquintlamacac. Huan yehhuatl huan in ichanihcahuan molui opactoyahque ic oteneltocaque in Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ic mostla in tequihuahmen oquintitlanque in topilihten maquinahuati in tlixpixqui maquincahcahuacan. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Oncan in tlixpixqui oquiluic in Pablo: ―Nicpiya in tlanahuatili den tequihuahmen manamechcahcahua namehhuan. Quen yicuali nanyasque tlamach. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Huan Pablo oquiniluic in topilihten: ―Tehhuanten titlacamen romanohtecos, huan otechuihhuitejque temiyacaixpa huan niyan ahmo otechixcomacahque, huan otechtzajque. Cox, ¿axan techcahcahuasque san ichtacan? ¡Huelis ahmo! Mahualacan yehhuan techquixtican. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","In topilihten oquinnonotzque in tequihuahmen huan yehhuan omomoutihque ihcuac oquimatque in Pablo huan Silas tlacamen romanohtecos. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Oyahque quintlatlautiyahque maquintlapohpoluican huan oncan oquinquixtihque huan oquintlatlautihque maquisacan ipan inon altepetl. ");
INSERT INTO ncjNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ic oquisque den telpiloyan, yehhuan oyahque ichan in Lidia. Huan oquinitaque in tocnihuan huan oquinyolchicautejque, huan satepa oyahque. ");
INSERT INTO ncjNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ic oyahyaya in Pablo huan Silas, opanoque ic Anfípolis huan Apolonia huan niman oahsique ipan in altepetl Tesalónica canin ocatca se tiopantli den judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Huan saniman quen quichiutinemi, in Pablo oya ipan inon tiopantli. Huan ipan yiyi semana, ipan in tonali den nesehuilistli, otlanonotzque inuan. ");
INSERT INTO ncjNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Oquinyequiluihque tlen quihtosnequi in Itlahcuiloltzin Dios. Oquinnonotzque quen in Cristo omopix tlen otlapanoloc ic omicohuac. Huan satepa ic omicohuac omopix tlen oihxohuac. Huan oquiniluic: ―Yeh inin Jesús tlen namechnonotza, yeh in Cristo, tetlapehpenil Dios. ");
INSERT INTO ncjNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Oncan sequin in judeahtecos oquineltocaque huan omosetilihque inuan Pablo huan Silas. Noyojqui oquineltocaque sequin griegohtecos aquin otemahuestiliyayahque Dios, huan noyojqui miyaquin in sihuamen tlen hueyi inquisca. ");
INSERT INTO ncjNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Huan ic inon in judeahtecos aquin ahmo oquineltocaque itlahtoltzin Dios ohualcualanque huan oquinsentlalihque sequin tlacamen ahmo cualten aquin san ompic onemiyayahque. Huan omocuahcualantihque huan oquinmohsihuihque nochin in altepetl. Huan oquixuitecticatcahque in ical Jasón ic quintemohticaten in Pablo huan Silas ic quinquixtisque huan quintemactinihque inmajco inon tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Huan quen ahmo oquinahsihque ompa, oquitotoxohtahque in Jasón huan oc sequin tocnihuan inixpa in tequihuahten den altepetl huan otzahtzihque: ―Inin tlacamen aquin quinnetehuiltiyahque nochin tlacamen nohuiyan noyojqui yohualahsihque nican. ");
INSERT INTO ncjNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Huan Jasón oquinseli ichan. Nochin yehhuan quixnamiquihque in tlanahuatilten den hueyixtoc romanohteco, tleca quihtohuahque oncan oc se hueyixtoc itoca Jesús. ");
INSERT INTO ncjNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ic oquicajque inin tlahtolten, in tlacamen huan in tequihuahmen omocuacualantihque. ");
INSERT INTO ncjNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Huan Jasón huan in oc sequin oquitemactihque in tomin quen fianza huan oquincauque in tequihuahten. ");
INSERT INTO ncjNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Saniman in tocnihuan oquintitlanque in Pablo huan Silas ica yohuali ipan in altepetl Berea. Ic oahsitohque, oyahque ipan in tiopantli den judeahtecos. ");
INSERT INTO ncjNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","In tlacamen den Berea ocachi cualten quen den Tesalónica. Tequin cualtzin oquiselihque in itlahtoltzin Dios huan mostli oquitemohuayahque ipan in Itlahcuiloltzin in tla ic nele melahuac quen quihtohuahque in Pablo huan Silas. ");
INSERT INTO ncjNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Miyacten de yehhuan oquineltocaque, huan noyojqui sequin sihuamen griegohtecos, aquin hueyi inquisca, huan noyojqui in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Huan ihcuac in judeahtecos den Tesalónica oquimatque quen in Pablo tlanonotztoc ica itlahtoltzin Dios noyojqui ipan in altepetl Berea, oyahque ompa huan oquincualantihtohque in tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Huan in tocnihuan oquititlanque in Pablo mayau saniman itentla in mar, huan omocauque in Silas huan Timoteo ipan in altepetl Berea. ");
INSERT INTO ncjNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","In aquin ihuan oyahyaya in Pablo oquihuicaque ipan in altepetl Atenas. Saniman omocuepque huan oquiniluihque in Silas huan Timoteo mayacan maquiahsisque ihsiucan in Pablo. ");
INSERT INTO ncjNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ic oc quinchixtica in Silas huan Timoteo ipan in altepetl Atenas, in Pablo tequin omomohsihui ic oquiitac quen oquipiyaya in altepetl miyac santos tlachihchiuten. ");
INSERT INTO ncjNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ic inon, ipan in tiopanten otlahtohuaya inuan in judeahtecos huan oc sequinten aquin otemahuestiliyayahque in Dios. Huan mostli otlanonotzayaya ipan in tiyanquistli ihuan aquin omahsiyaya ompa. ");
INSERT INTO ncjNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Sequin tlacamen ompa omomachtiyayahque ica intlanehnehuilis in aquin oquintocahhuiyayahque epicureos. Huan oc sequin omomachtiyayahque intlanehnehuilis den estoicos. In Pablo opeuque ihuan omonohnotza. Sequin oquihtohque: ―¿Tlen techiluiya inin tlacatl ic tequin tlatlahtohua? Huan oc sequin oquihtohque: ―Nesi quen quitlanonotza itlanehnehuilis oc sequin dioses. Ojcon oquihtohque tleca Pablo oquinnonotz in itlahtoltzin Jesús huan quen oihxohuac. ");
INSERT INTO ncjNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Oncan ocuicaque nepa canin itocahyan Areópago, canin saniman omosentlaliyahque ic mononotza, huan oquitlahtlanihque: ―Cox, ¿cuali ticmatisque in tlen yancuic tlanehnehuilistli ticualica? ");
INSERT INTO ncjNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Quen titechiluiya inin yancuic tlahtoli huan ticnequihque ticmatisque tlen quihtosnequi nochin inin. ");
INSERT INTO ncjNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Huan nochin tlacamen den altepetl Atenas huan noyojqui in sentlapalchanimen aquin ochantiyayahque ompa, ahmo tlen oquichihuayayahque san matlacaquican huan maquihtocan itlahtlen oc se yancuic tlahtoli. ");
INSERT INTO ncjNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Oncan Pablo omoquetz inepanco yehhuan nepa itocahyan Areópago huan oquiniluic: ―Tlacatzitzin den Atenas, ic nochin namechita quen namehhuan molui nanquintlasohtlahque in santos. ");
INSERT INTO ncjNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nehhuatl niquinitztinemiyaya san campa nanquimahuestiliyahque. Huan onicahsic in tlaixpa seya quipiya tlahcuiloli inin tlahtoli: “Ica in dios aquin ahmo teixmatihque.” Cuali tel, inin dios aquin nanquimahuestilisque niyan ahmo nanquixmatihque, yehhua in Dios ica in aquin namechiluiya. ");
INSERT INTO ncjNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’In Dios in aquin omochiu in tlalticpactli huan nochin tlen ca ipan yehhua, teyaxca in neluicactli huan in tlalticpactli. Ahmo chantilo ipan tiopantli tlachihchiuten den tlacamen. ");
INSERT INTO ncjNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Niyan ahmo mopiya tlen motas ica in tlacamen ica tlen cuali tepalehuisque ica Yehhuatzin. San Yehhuatzin nele techmacalo nochin 