﻿USE sofia;
DROP TABLE IF EXISTS sofia.nchBl_vpl;
CREATE TABLE nchBl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nchBl_vpl WRITE;
INSERT INTO nchBl_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Quema pejqui nochi cati onca, Toteco Dios quichijchijqui ilhuicacti huan taltipacti. ");
INSERT INTO nchBl_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Pero taltipacti amo quenicatza nesiyaya, san cactoya, yon amo tacualtalili. San oncayaya se hueyi tzintayohuilot cati quiixtzactoya nopa at cati tahuel huejcata. Huan Itonal Toteco Dios nemiyaya aixco. ");
INSERT INTO nchBl_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Huan Toteco Dios quiijto: “¡Ma onca taahuili!” Huan oncac taahuili. ");
INSERT INTO nchBl_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Huan Toteco Dios quitachili nopa taahuili cati quichijtoya huan quiitac para cuali. Teipa quiiyocatali nopa taahuili ica nopa tzintayohuilot. ");
INSERT INTO nchBl_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Huan Toteco Dios quitocaxti nopa taahuili “tonaya” huan nopa tzintayohuilot quitocaxti “tayohua”. Huan panoc tiotac huan panoc ijnaloc. Huan ya ni elqui nopa achtohui tonali. ");
INSERT INTO nchBl_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Huan Toteco Dios quiijto: “Ma onca ajacat cati quixelos nopa at para mocahuas iyoca.” Huan quej nopa elqui. ");
INSERT INTO nchBl_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Huajca Toteco Dios quichijqui nopa ajacat cati quixelo nopa at para tajco nopa at mocajqui tatzinta huan ne seyoc tajco mocajqui huejcapa. ");
INSERT INTO nchBl_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Huan campa oncac ajacat quitocaxti “ilhuicacti”. Huan panoc tiotac huan panoc ijnaloc. Huan ya ni elqui nopa ompa tonali. ");
INSERT INTO nchBl_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Huan Toteco Dios quiijto: “Ma mosejcotili nopa at cati eltoc tatzinta ilhuicacti para ma mopanexti cati huactoc.” Huan quej nopa elqui. ");
INSERT INTO nchBl_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Huan Toteco Dios quitocaxti nopa cati huactoc “tali”. Huan nopa at cati mosejcotilijtoya quitocaxti “hueyi at”. Huan Toteco Dios quitachili cati quichijtoya huan quiitac para cuali. ");
INSERT INTO nchBl_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Huan Toteco Dios quiijto: “Ma temaca nopa tali nochi tamanti xihuit cati xoxohuic huan sesen icone ma eli quej ya. Ma onca xihuit cati temaca iyol huan cuame cati temacaj inintajca. Huan sesen tamanti ma quincahua iconehua cati quej ya.” Huan quej nopa elqui. ");
INSERT INTO nchBl_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Huajca nopa tali temacac nochi tamanti xihuit cati xoxohuic. Temacac xihuit cati temacaj iniyol huan cuame cati temacaj inintajca. Huan sesen ininconehua elqui quej nopa xihuit o nopa cuahuit cati temacac. Huan Toteco Dios quitachili cati quichijtoya huan quiitac para cuali. ");
INSERT INTO nchBl_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Huan panoc tiotac huan panoc ijnaloc. Huan ya ni elqui nopa expa tonali. ");
INSERT INTO nchBl_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Huan Toteco Dios quiijto: “Ma onca taahuili nepa ilhuicac para ma tatanexti ipan taltipacti para quiiyocatalis tonaya huan tayohua huan para ma tenextilica taya tonali, huan taya xihuit huan taya ipohual ipan ne xihuit itztoque. ");
INSERT INTO nchBl_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Huan ma cahuanica nepa ilhuicac para taahuise ipan taltipacti.” Huan quej nopa elqui. ");
INSERT INTO nchBl_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Huajca quej nopa Toteco Dios quichijchijqui nopa ome huejhueyi taahuili. Quichijqui tonati cati más hueyi para tatanextis tonaya huan nopa metzti para tatanextis tayohua. Huan Toteco Dios nojquiya quinchijchijqui sitalime. ");
INSERT INTO nchBl_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Huan Toteco Dios quintali nopa taahuilme ipan ilhuicacti para ma tatanextica ipan taltipacti. ");
INSERT INTO nchBl_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Nopa hueyi taahuili para taahuis tonaya huan cati amo más hueyi taahuis tayohua para quej ni moiyocatalise taahuili huan tzintayohuilot. Huan quiyolpacti Toteco Dios nochi cati quichijtoya pampa elqui cuali. ");
INSERT INTO nchBl_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Huan panoc tiotac huan panoc ijnaloc. Huan ya ni elqui nopa najpa tonali. ");
INSERT INTO nchBl_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Huan Toteco Dios quiijto: “Ma temi nopa at ica miyac tamanti cati yoltoque. Huan ma temi nochi ilhuicacti ica miyac tamanti totome cati patanij.” ");
INSERT INTO nchBl_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Huajca Toteco Dios quinchijchijqui nochi huejhueyi tapiyalme cati itztoque ipan hueyi at huan nochi tamanti michime. Huan quichijqui para sesen ma quinpiya iconehua quej ya. Huan quinchijchijqui nochi totome huan quichijqui para ma quinpiyaca ininconehua quej inijuanti. Huan Toteco Dios quitachili nochi cati quichijtoya huan quiitac para cuali. ");
INSERT INTO nchBl_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Huan Toteco Dios quitiochijqui sesen tamanti cati quinchijtoya huan quinilhui: “Ximomiyaquilica huan xijtemitica nopa hueyi at.” Huan Toteco Dios quinnahuati nopa totome: “Xijpiyaca miyac amoconehua huan xijtemitica campa hueli ipan taltipacti.” ");
INSERT INTO nchBl_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Huan panoc tiotac huan panoc ijnaloc. Huan ya ni elqui nopa macuilpa tonali. ");
INSERT INTO nchBl_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Huan Toteco Dios quiijto: “Ma onca ipan taltipacti nochi tamanti tapiyalme. Ma onca tapiyalme cati mosisiníaj huan cati maxojtzitzi huan nojquiya cati mohuahuatatzaj talchi.” Huan quej nopa elqui. ");
INSERT INTO nchBl_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Huajca quej nopa Toteco Dios quinchijchijqui nochi tapiyalme huan quintachili huan nochi quiitac para cuali. ");
INSERT INTO nchBl_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Teipa Toteco Dios quiijto: “Ama ma tiquinchihuaca masehualme. Tiquinchihuase ma elica quej tojuanti huan quipiyase totachiyalis. Huan inijuanti quipiyase tanahuatili ica michime, huan totome, huan ica tapiyalme cati mosisiníaj, huan ica cati maxojtzitzi huan ica nochi cati nemij ipan taltipacti.” ");
INSERT INTO nchBl_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Huajca Toteco Dios quinchijqui masehualme ica itachiyalis. Quena, quej yaya itachiyalis Toteco Dios quinchijqui. Quinchijchijqui tacat huan sihuat. ");
INSERT INTO nchBl_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Huan Toteco Dios quintiochijqui huan quinilhui: “Xiquinpiyaca miyac amoconehua para inijuanti itztose campa hueli ipan nochi taltipacti para ma tanahuatica. Nojquiya nimechtalía xiquinnahuatica nochi michime, totome huan nochi cati nemij ipan taltipacti.” ");
INSERT INTO nchBl_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Huan teipa Toteco Dios quinilhui nopa tacat huan sihuat: “Xiquitaca, nimechmaca nochi tamanti xihuit cati quipiya iyol huan nochi cuahuit cati quipiya itajca para anquicuase. ");
INSERT INTO nchBl_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Huan nopa tapiyalme, totome huan nochi sequinoc tamanti cati nemij ipan taltipacti niquinmaca nochi sacat huan xihuit cati xoxohuic para quicuase.” Huan quej nopa elqui. ");
INSERT INTO nchBl_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Huan Toteco Dios quitachili nochi cati quichijtoya huan quiitac para tahuel cuali. Huan panoc tiotac huan panoc ijnaloc. Huan ya ni elqui nopa chicuasempa tonali. ");
INSERT INTO nchBl_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Huajca quej nopa Toteco Dios quitamisencajqui nochi ilhuicacti, huan nochi taltipacti huan nochi cati onca nopona. ");
INSERT INTO nchBl_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Quema ajsic nopa chicompa tonali, Toteco Dios ya tantoya cati quichihuayaya huan mosiyajquetzqui. ");
INSERT INTO nchBl_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Huan Toteco Dios quitiochijqui nopa chicompa tonali huan quiijto para elis tatzejtzeloltic pampa ipan nopa tonali ya tantoya itequi huan mosiyajquetzqui. ");
INSERT INTO nchBl_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Huajca quej nopa TOTECO Dios quichijqui taltipacti huan ilhuicacti. Nica techilhuía quenicatza TOTECO Dios quichijqui ilhuicacti huan taltipacti. ");
INSERT INTO nchBl_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Achtohui amo oncayaya xihuit yon amo teno panquistoya pampa TOTECO Dios ayemo quichijtoya ma huetzi at ipan taltipacti. Nojquiya amo aqui itztoya para tequitis. ");
INSERT INTO nchBl_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Pero masque TOTECO Dios amo quichijtoya ma huetzi at, ten taltita tejcoyaya apocti huan quiatequiyaya nopa tali. ");
INSERT INTO nchBl_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Huan TOTECO Dios quicuic tali huan quichijchijqui itacayo se tacat. Huan quiyacailpitzqui huan quimacac nemilisti. Huan nopa tacat pejqui quipiya nemilisti. ");
INSERT INTO nchBl_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Teipa TOTECO Dios quitojqui se xochimili cati itoca Edén nepa imelac campa quisa tonati. Huan nopona quicajqui nopa tacat cati quichijchijtoya. ");
INSERT INTO nchBl_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Huan TOTECO Dios quichijqui ma moscalti xochimilijtic nochi tamanti cuame cati yejyectzitzi nesiyaya huan nochi tamanti cuame cati temacaj cuatajcayot para quicuase. Huan tatajco nopa xochimili TOTECO Dios quitojqui se cuahuit cati temaca itajca huan itoca cuahuit cati temaca nemilisti. Nojquiya quitojqui seyoc cuahuit ica itajca huan itoca nopa cuahuit cati temachiltía cati cuali huan cati amo cuali. ");
INSERT INTO nchBl_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ipan Edén oncayaya se hueyat cati quiatequiyaya nopa xochimili. Huan ten nopona, moxelohuayaya huan mochihuayaya nahui pilhueyatzitzi. ");
INSERT INTO nchBl_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Nopa achtohui amaxali ten nopa hueyat itoca Pisón huan ya ni cati tayahualohuayaya campa hueli ipan nochi nopa tali cati itoca Havila campa onca oro. ");
INSERT INTO nchBl_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Nopa oro ten nopa tali eliyaya senquisa cuali. Nojquiya nopona oncayaya se taajhuiyacayot cati patiyo huan piltetzitzi cati yejyectzitzi cati itoca ónice. ");
INSERT INTO nchBl_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Huan nopa ompa amaxali ten nopa hueyat itoca Gihón huan tayahualohuayaya campa hueli ipan nopa tali cati itoca Cus. ");
INSERT INTO nchBl_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Huan nopa expa amaxali ten nopa hueyat itoca Tigris huan pano iteno tali Asiria imelac campa quisa tonati. Huan nopa najpa amaxali ten nopa hueyat itoca Eufrates. ");
INSERT INTO nchBl_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Huajca TOTECO Dios quihuicac nopa tacat huan quicajqui ipan nopa xochimili cati itoca Edén para ma quimocuitahui, ");
INSERT INTO nchBl_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","huan TOTECO Dios quinahuati: “Huelis tijcuas itajca ten hueli cuahuit ipan ni xochimili, ");
INSERT INTO nchBl_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","pero ne cuahuit cati itoca ‘cuahuit cati temachiltía cati cuali huan cati amo cuali’, amo. Amo xijcualili itajca, pampa ipan nopa tonali quema tijcuas itajca, melahuac timiquis.” ");
INSERT INTO nchBl_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Teipa TOTECO Dios quiijto: “Amo cuali para itztos iselti ni tacat. Para amo cuesihuis, nijchihuilis se acajya cati quinamiqui huan cati quipalehuis.” ");
INSERT INTO nchBl_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Huan ica tali TOTECO Dios quinchijtoya nochi tapiyalme huan nochi totome. Teipa quihuiquili nopa tacat para ma quintocaxtali. Huan cati nopa tacat quintocaxtali, ya nopa elqui inintoca. ");
INSERT INTO nchBl_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Huajca nopa tacat quintocaxtali nochi tamanti tapiyalme cati maxojtzitzi, huan nochi totome huan nochi tapiyalme cati mosisiníaj. Pero yon se ten nopa tapiyalme amo quinamijqui para quipalehuis nopa tacat para amo cuesihuis. ");
INSERT INTO nchBl_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Huajca TOTECO Dios quichijqui tahuel ma cochi Adán. Huan quema cochtoya, quiquixtili se ielchiqui omiyo huan sempa quimotzquilti inacayo quej eltoya. ");
INSERT INTO nchBl_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Huan ica nopa tacat ielchiqui, TOTECO Dios quisencajqui se sihuat huan quihuicac campa nopa tacat. ");
INSERT INTO nchBl_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Huan quema nopa tacat quiitac nopa sihuat, quiijto: “¡Ama quena! Ya ni san se ica na, pampa inacayo quisqui nonacayotipa, huan iomiyo quisqui noomiyotipa. Itoca elis ‘sihuat’, pampa TOTECO Dios techquixtili ten na, nitacat.” ");
INSERT INTO nchBl_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Huan yeca se tacat quicahuas itata huan inana para mosejcotilis ihuaya isihua huan nopa ome mochihuase san se inintacayo. ");
INSERT INTO nchBl_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Huan masque nopa tacat huan isihua xolome nemiyayaj, amo pinahuayayaj. ");
INSERT INTO nchBl_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Nopa cohuat eliyaya cati más talnamiqui huan más quimatiyaya quenicatza tacajcayahuas que nochi sequinoc tapiyalme cati TOTECO Dios quinchijtoya. Huan se tonali nopa cohuat quitatzintoquili nopa sihuat: ―¿Amo amechilhuijtoc Dios para amo xijcuaca itajca yon se cuahuit ipan ni xochimili? ");
INSERT INTO nchBl_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Huan nopa sihuat quinanquili: ―Huelis tijcuase itajca ten hueli cuahuit, ");
INSERT INTO nchBl_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","pero iyojtzi ne cati eltoc tatajco xochimili Dios techilhuijtoc amo cuali tijcuase, yon tiquitzquise itajca ne cuahuit pampa sinta tijchihuase, timiquise. ");
INSERT INTO nchBl_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Pero nopa cohuat quiilhui nopa sihuat: ―Amo neli. Amo anmiquise. ");
INSERT INTO nchBl_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Cuali quimati Dios sinta anquicuase itajca nopa cuahuit elis quej amechtapolis amoixteyol huan amotalnamiquilis huan anquimatise cati cuali huan cati amo cuali. Quej nopa anelise quej ya. ");
INSERT INTO nchBl_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Teipa nopa sihuat quiitac para yejyectzi itajca nopa cuahuit huan nesiyaya cuali para quicuas. Huajca quiixtocac pampa nojquiya quinejqui quipiyas talnamiquilisti. Yeca quitejqui se huan quicuajqui. Huan teipa quimacac ihuehue huan ya nojquiya quicuajqui. ");
INSERT INTO nchBl_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Huan ipan nopa talojtzi elqui quej tapojqui iniixteyol huan nochi ome momacaque cuenta para xolome itztoyaj huan mopinajque. Huajca quiijtzonque ixihuiyo nopa cuahuit cati itoca higuera para quichihuase iniixpantzajca huan ica ya nopa motzajque. ");
INSERT INTO nchBl_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Huan teipa ica tiotac quema tasesestoc, nopa tacat huan isihua quicajque TOTECO Dios nemiyaya xochimilijtic. Huan motalojque motatitoj iica nopa cuame para TOTECO Dios ma amo quinita. ");
INSERT INTO nchBl_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Pero TOTECO Dios quinojnotzqui nopa tacat huan quitatzintoquili: ―¿Canque tiitztoc? ");
INSERT INTO nchBl_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Huan nopa tacat tananquili: ―Nijcajqui para tinemiyaya xochimilijtic huan nimajmajqui pampa nixolot. Huan yeca nimotati. ");
INSERT INTO nchBl_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Huajca Toteco Dios quitatzintoquili: ―Huan ¿ajquiya mitzilhuijtoc para tixolot? ¿Tijcuajtoc itajca nopa cuahuit cati nimitzilhui amo xijcua? ");
INSERT INTO nchBl_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Huan nopa tacat tananquili: ―Nopa sihuat cati techmacac quej notahuical, yaya techmacac se itajca nopa cuahuit huan yeca nijcuajqui. ");
INSERT INTO nchBl_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Huajca TOTECO Dios quitatzintoquili nopa sihuat: ―¿Para ten tijchijqui ya ni? Huan nopa sihuat quinanquili: ―Nopa cohuat nechcajcayajqui huan yeca nijcuajqui itajca nopa cuahuit. ");
INSERT INTO nchBl_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Huan teipa TOTECO Dios quiilhui nopa cohuat: ―Ica ya ni cati tijchijtoc, tielis más titatelchihuali que nochi sequinoc tapiyalme. Huan san timohuahuatatztinemis ipan tali huan taltepocti tijcuas nochi monemilis. ");
INSERT INTO nchBl_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nijchihuas ximocualancaitaca ta ica nopa sihuat, huan moixhui ica ya iixhui mocualancaitase. Iixhui mitztzonxamanis huan ta tijcotztantzacanis. ");
INSERT INTO nchBl_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Huan TOTECO Dios quiilhui nopa sihuat: ―Nijchihuas xineltaijyohui quema ticonepiyas huan ica tacuajcualoli titatacatiltis. Pero ta tijnequis mohuehue, huan yaya mitznahuatis. ");
INSERT INTO nchBl_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Huan TOTECO Dios quiilhui nopa tacat: ―Pampa tijneltoquili mosihua huan tijcuajqui itajca nopa cuahuit cati nimitzilhui amo xijcua, tatelchihuali elis nochi tali por ta motajtacol. Huan ica miyac tequit tijpiyas cati tijcuas nochi monemilis. ");
INSERT INTO nchBl_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Nopa tali quiixhualtis huitzti huan sahua mecat. Huan tijcuas nopa cuali xihuit cati moscaltis nopona. ");
INSERT INTO nchBl_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Huan timitonis miyac para tijpantis tacualisti cati ica timopanoltis hasta quema timiquis huan sempa timochihuas tali. Na nijchijqui motacayo ica tali, huan quema timiquis, sempa timochihuas tali. ");
INSERT INTO nchBl_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Huan Adán quitocaxti isihua Eva. (Eva quinequi quiijtos Nemilisti.) Huan Eva elqui ininana nochi masehualme cati itztoque. ");
INSERT INTO nchBl_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Huan TOTECO Dios quinchihuili Adán huan Eva iniyoyo ica inincuetaxo tapiyalme huan quinyoyonti. ");
INSERT INTO nchBl_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Huan TOTECO Dios moilhui: “Ama ni masehualme mochijtoque quej tojuanti pampa quimatij cati cuali huan cati amo cuali. Sinta quitequise itajca nopa cuahuit cati temaca nemilisti, itztose para nochipa quej ni.” ");
INSERT INTO nchBl_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Huajca TOTECO quinquixti ten nopa xochimili cati itoca Edén. Huan nopa tacat quititanqui ma tequiti ipan nopa tali cati ica quisencajtoya itacayo. ");
INSERT INTO nchBl_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Huan teipa quema TOTECO Dios ya quinquixtijtoya, quintali sequij ilhuicac ehuani cati inintoca querubines para itztose imelac nopa xochimili ica campa quisa tonati para ma quimocuitahuica nopa xochimili. Huan TOTECO Dios nojquiya quitali nopona se macheta cati lementoya huan momalacachohuayaya campa hueli para amo aqui ajsis campa nopa cuahuit cati temaca nemilisti. ");
INSERT INTO nchBl_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Huan Adán cochqui ihuaya isihua, huan isihua conecuic huan quitacatilti se oquichpil cati quitocaxti Caín. (Caín quinequi quiijtos Nijpixtoc.) Quej nopa quitocaxti pampa Eva quiijto: “Ica itapalehuil TOTECO nijpixtoc se tacat.” ");
INSERT INTO nchBl_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Huan teipa Eva quitacatilti seyoc oquichpil cati quitocaxtali Abel. Huan quema nopa ome moscaltijque, Abel quinmocuitahui borregojme, huan Caín miltequitic. ");
INSERT INTO nchBl_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Huan se tonali Caín quihualiquili TOTECO se tacajcahualisti cati quipixcatoya. ");
INSERT INTO nchBl_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Huan Abel nojquiya quihualiquili TOTECO sequij borregojme cati más tomahuaque huan cati achtohui tacatque. Huan quinmicti huan quimacac TOTECO. Huan TOTECO quicualitac Abel ica itacajcahualis huan quiseli. ");
INSERT INTO nchBl_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Pero ica Caín huan itacajcahualis amo quicualitac. Yeca Caín cualanqui miyac huan fiero tachixtinenqui. ");
INSERT INTO nchBl_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Huajca TOTECO quiilhui Caín: “¿Para ten ticualani huan fiero titachixtinemi? ");
INSERT INTO nchBl_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","¿Amo tijmati sinta tijchihuas cati cuali, nimitzselis huan tipaquis? Pero sinta amo tijchihua cati cuali, mitztanis tajtacoli. Nopa tajtacoli eltoc quej se tecuani cati mitzchiya mocalteno huan quinequi mitztanis, pero monequi ta xijtanis ya.” ");
INSERT INTO nchBl_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Huan panoc se ome tonati huan Caín quinotztejqui iicni Abel huan quiilhui: ―Ma tiyaca cuatita. Huan quema ajsitoj cuatita, Caín quitehui iicni Abel huan quimicti. ");
INSERT INTO nchBl_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Huajca TOTECO quitatzintoquili Caín: ―¿Canque itztoc moicni Abel? Huan Caín quinanquili: ―Amo nijmati na. Amo notequi para nijmocuitahuis noicni. ");
INSERT INTO nchBl_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Huan TOTECO quiilhui: ―¿Para ten tijchijtoc ya ni? Tijmicti moicni huan ieso tijtoyajtoc ipan tali. Huan ama eltoc quej ieso techtajtanía chicahuac ma nimitztatzacuilti. ");
INSERT INTO nchBl_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Huajca ama, por cati tijchijtoc, nimitztelchihuas. Ayecmo huelis titequitis ipan ni tali pampa tijnenpolojtoc ica ieso moicni. ");
INSERT INTO nchBl_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Huan masque titatojtocas, ayecmo teno tiqueliltis. Monequi san tinentinemis campa hueli ipan taltipacti huan amo cana tijpiyas para timochantalis. ");
INSERT INTO nchBl_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Huajca Caín quinanquili TOTECO: ―Nelchicahuac ni tatzacuiltili huan amo huelis niquijyohuis. ");
INSERT INTO nchBl_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ama techquixtía huejca ten ni tali huan ayecmo huelis nimitznechcahuis ta. Nielis se ninejnenquet campa hueli tali huan amo huelis nimosiyajquetzas. Quej ni cati hueli nechpantis, nechmictis. ");
INSERT INTO nchBl_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Pero TOTECO quinanquili: ―¡Amo! Sinta acajya mitzmictis, nijtatzacuiltis chicome huelta más para nijcuepilis. Huajca TOTECO quitalili ipan Caín se tanextili para nochi quiixmatisquíaj para yaya huan amo quimictisquíaj. ");
INSERT INTO nchBl_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Huan Caín quistejqui campa ihuaya camanaltiyaya TOTECO huan yajqui itztoti ipan se tali itoca Nod cati mocahua imelac Edén para campa quisa tonati. ");
INSERT INTO nchBl_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Huan Caín ihuaya cochqui isihua, huan yaya conecuic huan quitacatilti se oquichpil cati itoca Enoc. Teipa Caín quichijqui se altepet huan quitocaxti nopa altepet Enoc quej itoca icone. ");
INSERT INTO nchBl_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Huan Enoc motacachijqui huan elqui itata Irad. Huan teipa Irad moscalti huan elqui itata Mehujael. Huan teipa Mehujael motacachijqui huan elqui itata Metusael. Huan Metusael moscalti huan elqui itata Lamec. ");
INSERT INTO nchBl_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Huan Lamec quinpixqui ome isihuajhua; se itoca Ada huan ne seyoc Zila. ");
INSERT INTO nchBl_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Huan Ada quitacatilti Jabal. Huan Jabal motacachijqui huan elqui inintata masehualme cati mocajque ipan calme ten yoyomit huan quinxinachohuayayaj huan quiniscaltiyayaj tapiyalme. ");
INSERT INTO nchBl_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Huan Jabal quipixqui se iicni cati itoca Jubal. Huan Jubal moscalti huan quiyolilti tapitzali huan nopa tatzotzonali cati itoca arpa. Huan yaya elqui inintata masehualme cati tatzotzonaj. ");
INSERT INTO nchBl_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Huan Zila, nopa seyoc isihua Lamec, quitacatilti se oquichpil cati itoca Tubal Caín cati elqui se teposchijquet. Huan Tubal Caín quitejtzonayaya nopa teposti cati itoca bronce huan cati itoca hierro huan ica nopa teposti quichijchihuayaya miyac tamanti. Huan Tubal Caín quipixqui se isihua icni cati itoca Naama. ");
INSERT INTO nchBl_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Huan se tonali Lamec quinilhui iome sihuajhua Ada huan Zila: “Xijtacaquilica cuali cati nimechilhuis. Nijmicti se tacat pampa nechcoco. Huan elqui se telpocat cati nechmaquilijtoya. ");
INSERT INTO nchBl_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Sinta se acajya quichihuilisquía se tenijqui Caín, quiselisquía se tatzacuiltili chicome huelta más chicahuac. Pero sinta se acajya nechcuepilisquía cati nijchijtoc na, niLamec, monequisquía quiselis se tatzacuiltili cati amo san chicome hueltas, pero se tatzacuiltili cati tahuel más chicahuac.” ");
INSERT INTO nchBl_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Huan Adán cochqui ihuaya isihua, huan isihua sempa conepixqui huan quitacatilti seyoc oquichpil cati quitocaxti Set. (Set quinequi quiijtos Nechmacatoc.) Quej nopa quitocaxti pampa quiijto: “Toteco Dios techmacatoc seyoc conet ipataca Abel cati Caín quimicti.” ");
INSERT INTO nchBl_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Huan quema Set motacachijqui, quipixqui se icone cati quitocaxti Enós. Huajca ipan nopa tonali tacame pejque quihueyichihuaj TOTECO san sejco. ");
INSERT INTO nchBl_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ya ni inintoca iteipan ixhuihua Adán: Quema Toteco Dios quinchijqui masehualme, quinchijchijqui quej ya itachiyalis. ");
INSERT INTO nchBl_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Quinchijchijqui tacame huan sihuame huan ipan nopa tonali quema quinchijqui, quintiochijqui huan quintocaxti “masehualme”. ");
INSERT INTO nchBl_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Huan quema Adán quipixqui 130 xihuit, tacatqui icone cati elqui quej ya huan san se inintachiyalis huan quitocaxti Set. ");
INSERT INTO nchBl_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Huan quema ya tacajtoya Set, Adán noja itztoya seyoc 800 xihuit huan quinpixqui más iconehua, tacame huan sihuame. ");
INSERT INTO nchBl_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Huan mijqui Adán quema quipixqui 930 xihuit. ");
INSERT INTO nchBl_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Huan Set quipiyayaya 105 xihuit quema tacatqui icone, Enós. ");
INSERT INTO nchBl_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Teipa Set noja itztoya seyoc 807 xihuit huan noja quinpixqui sequinoc iconehua, tacame huan sihuame. ");
INSERT INTO nchBl_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Huan mijqui Set quema quipixqui 912 xihuit. ");
INSERT INTO nchBl_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Huan Enós quipiyayaya 90 xihuit quema tacatqui icone, Cainán. ");
INSERT INTO nchBl_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Teipa Enós noja itztoya seyoc 815 xihuit huan noja quinpixqui más iconehua, tacame huan sihuame. ");
INSERT INTO nchBl_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Huan Enós mijqui quema quipixqui 905 xihuit. ");
INSERT INTO nchBl_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Huan Cainán quipiyayaya 70 xihuit quema tacatqui icone, Mahalaleel. ");
INSERT INTO nchBl_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Teipa Cainán itztoya seyoc 840 xihuit huan noja quinpixqui más iconehua, tacame huan sihuame. ");
INSERT INTO nchBl_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Huan Cainán mijqui quema quipixqui 910 xihuit. ");
INSERT INTO nchBl_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Huan Mahalaleel quipiyayaya 65 xihuit quema tacatqui icone, Jared. ");
INSERT INTO nchBl_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Teipa Mahalaleel itztoya seyoc 830 xihuit huan noja quinpixqui más iconehua, tacame huan sihuame. ");
INSERT INTO nchBl_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Huan mijqui Mahalaleel quema quipixqui 895 xihuit. ");
INSERT INTO nchBl_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Huan Jared quipiyayaya 162 xihuit quema tacatqui icone, Enoc. ");
INSERT INTO nchBl_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Teipa, Jared itztoya seyoc 800 xihuit más huan noja quinpixqui más iconehua, tacame huan sihuame. ");
INSERT INTO nchBl_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Huajca Jared quiaxiti 962 xihuit huan huajca mijqui. ");
INSERT INTO nchBl_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Huan Enoc quipiyayaya 65 xihuit quema tacatqui icone, Matusalén. ");
INSERT INTO nchBl_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Huan Enoc nochipa quichijqui ipaquilis Toteco Dios. Huan teipa quema Matusalén ya tacajtoya, Enoc itztoya seyoc 300 xihuit más huan noja quinpixqui sequinoc iconehua, tacame huan sihuame. ");
INSERT INTO nchBl_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Huajca ica nochi Enoc quiaxiti 365 xihuit. ");
INSERT INTO nchBl_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Huan pampa Enoc nochipa nejnentoya quej Toteco Dios ipaquilis, se tonali polijqui pampa Toteco Dios quihuicac. ");
INSERT INTO nchBl_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Huan Matusalén quipiyayaya 187 xihuit quema tacatqui icone cati quitocaxti Lamec. ");
INSERT INTO nchBl_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Huan teipa Matusalén itztoya seyoc 782 xihuit más huan noja quinpixqui más iconehua, tacame huan sihuame. ");
INSERT INTO nchBl_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Huajca ica nochi Matusalén quiaxiti 969 xihuit huan huajca mijqui. ");
INSERT INTO nchBl_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamec quipiyayaya 182 xihuit quema tacatqui icone, ");
INSERT INTO nchBl_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","huan quitocaxti Noé. (Noé quinequi quiijtos Techyoltalis.) Quej nopa quitocaxti pampa quiijto: “TOTECO quitelchijqui ni tali, huan monequi titequitise tahuel chicahuac para titaeliltise, pero ni conet techyoltalis.” ");
INSERT INTO nchBl_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Huan teipa quema Noé ya tacajtoya, Lamec noja itztoya seyoc 595 xihuit huan noja quinpixqui más iconehua, tacame huan sihuame. ");
INSERT INTO nchBl_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Huajca Lamec quiaxiti 777 xihuit huan huajca mijqui. ");
INSERT INTO nchBl_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Huan Noé quipiyayaya 500 xihuit quema tacatque iconehua, Sem, Cam huan Jafet. ");
INSERT INTO nchBl_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Huan masehualme pejque momiyaquilíaj ipan ni taltipacti huan quinpixque iniichpocahua. ");
INSERT INTO nchBl_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Huan ipan nopa tonali sequij cati quintocaxtiyayaj “itelpocahua Toteco Dios” quinitaque para yejyectzitzi iniichpocahua masehualme ipan ni taltipacti. Huajca quintapejpenijque cati quinixtocayayaj huan mosihuajtijque inihuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Huan TOTECO quiijto: “Notonal amo quinijyohuis masehualme huan inintajtacolhua para nochipa pampa masehualme san panoni. Huajca ama niquincahuilis ni masehualme ma itztoca san se 120 xihuit.” ");
INSERT INTO nchBl_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Huan ipan nopa tonali huan nojquiya teipa itztoyaj huejcapantique tacame ipan taltipacti. Inijuanti nesque quema nopa “itelpocahua Toteco Dios” mosejcotilijque ihuaya iniichpocahua masehualme para quinpiyase coneme inihuaya. Huejcajquiya inijuanti itztoyaj huejhueyi masehualme cati nochi quinixmatiyayaj. ");
INSERT INTO nchBl_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Huan TOTECO quiitac para nelmiyac inintaixpanolhua masehualme ipan taltipacti huan nochipa moilhuiyayaj cati amo cuali quichihuase. ");
INSERT INTO nchBl_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Yeca ica tequipacholi TOTECO pejqui moyolpata. Moyolilhui sinta cuali elqui para quinchijtoya masehualme huan nelía quiyolcoco. ");
INSERT INTO nchBl_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Huan TOTECO quiijto: “Niquinpolihuiltis masehualme cati niquinchijchijtoc ipan taltipacti. Nojquiya niquinmictis nochi tapiyalme, totome huan cati mohuahuatatzaj talchi. Nimocuesohua huan nimoilhuía: ¿Para ten niquinchijchijqui?” ");
INSERT INTO nchBl_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Pero Noé quipanti cati cuali pampa TOTECO quicualitac. ");
INSERT INTO nchBl_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ama nimechpohuilis cati panoc ica Noé. Noé eliyaya se cuali tacat iixpa Toteco Dios. Yon se ipan nopa tonali amo huelqui quitatelhui ica yon se tamanti. Yaya nejnenqui quej Toteco Dios quinequiyaya. ");
INSERT INTO nchBl_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Huan Noé quinpixqui eyi itelpocahua. Inintoca elque Sem, Cam huan Jafet. ");
INSERT INTO nchBl_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Huan ipan nochi taltipacti campa hueli oncayaya cati fiero iixpa Toteco Dios huan nochi masehualme san mosisiniyayaj. ");
INSERT INTO nchBl_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Huan Toteco Dios quiitac para nelfiero eltoya, huan nochi masehualme san mocuapolojtoyaj ipan tajtacoli. ");
INSERT INTO nchBl_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Huajca Toteco Dios quiilhui Noé: “Niquinpolihuiltis nochi masehualme campa hueli ipan taltipacti pampa nochi san mosisiníaj, yeca niquinixpolos ica nochi cati onca. ");
INSERT INTO nchBl_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Huajca xijchihua se cuaacali ica nopa cuahuit cati itoca resina huan calijtic xijchihuili pilcuartojtzitzi. Xijtzacua ica chapopojti campa hueli iijtic huan ipani para amo calaquis at. ");
INSERT INTO nchBl_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Quej ni xijchihua nopa cuaacali. Xijchihua 135 metros ihuehueyaca, 22 metros huan tajco ipatajca huan 13 metros huan tajco ihuejcapanca. ");
INSERT INTO nchBl_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Xijchihua nopa cuaacali ica eyi pisos huan xijtali se ventana nechca tapamit. Huan xijtali se caltemit ipan se lado. ");
INSERT INTO nchBl_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Nijtitanis tahuel miyac at cati momanas huejcapa hasta quitzonpolihuiltis nochi tali huan nochi cati quipiyaj nemilisti campa hueli ipan taltipacti. Nochi cati onca ipan tali polihuis. ");
INSERT INTO nchBl_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Pero nijcahua nocamanal mohuaya para nimechmocuitahuis ipan nopa cuaacali. Huan ta ticalaquis ipan cuaacali huan calaquise mohuaya mosihua, motelpocahua huan moyexhua. ");
INSERT INTO nchBl_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Nojquiya tiquinhuicas mohuaya ome tapiyalme, se oquichti huan se sihuatzi ten nochi tamanti tapiyalme cati itztoque ipan taltipacti para noja ma itztoca mohuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Mohuaya calaquise ome ten nochi tamanti totome, tapiyalme huan cati mohuahuatatzaj para ma amo miquica. ");
INSERT INTO nchBl_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Nojquiya xijhuica mohuaya nochi tamanti tacualisti cati monequis anquicuase amojuanti huan nochi nopa tapiyalme.” ");
INSERT INTO nchBl_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Huan Noé quichijqui nochi quej Toteco Dios quiilhuijtoya. ");
INSERT INTO nchBl_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Teipa TOTECO quiilhui Noé: “San ta ten nochi masehualme cati ama itztoque tijchihua cati xitahuac. Yeca xicalaqui ipan cuaacali ihuaya mosihua huan moconehua. ");
INSERT INTO nchBl_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Xiquinhuica mohuaya chicome oquichme huan chicome sihuatzitzi ten nochi tamanti tapiyalme cati cuali para tacajcahualisti. Pero xijhuica san se oquichti huan se sihuatzi ten nopa tapiyalme cati amo motequihuíaj para tacajcahualisti. ");
INSERT INTO nchBl_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Nojquiya xiquinhuica chicome oquichme huan chicome sihuatzitzi ten nochi tamanti totome para amo polihuis inixinacho ipan taltipacti. ");
INSERT INTO nchBl_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Pampa ica chicome tonati nijchihuas ma huetzi at, huan huetzqui at para 40 tonati huan 40 yohuali. Quej nopa niquinpolihuiltis nochi cati yoltoque cati niquinchijchijtoc ipan ni taltipacti.” ");
INSERT INTO nchBl_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Huan Noé quichijqui nochi quej TOTECO quinahuatijtoya. ");
INSERT INTO nchBl_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Huan Noé quipiyayaya 600 xihuit quema momanqui nochi nopa miyac at para quiatzonpolihuiltis taltipacti. ");
INSERT INTO nchBl_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Huan Noé calajqui ipan cuaacali ihuaya iconehua, isihua huan iyexhua para momanahuise ten nopa miyac at cati huala. ");
INSERT INTO nchBl_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Huajca ojome hualajque nochi nopa tapiyalme campa Noé. Hualajque tapiyalme cati cuali para tacajcahualisti huan cati amo cuali para tacajcahualisti, cati patanij huan cati mohuahuatatzaj. ");
INSERT INTO nchBl_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Ojome nochi hualajque campa Noé huan calajque ipan cuaacali. Calajqui se oquichti huan se sihuatzi ten sesen tamanti tapiyali quej Toteco Dios tanahuatijtoya. ");
INSERT INTO nchBl_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Huan ica chicome tonati hualajqui tahuel miyac at ipan taltipacti. ");
INSERT INTO nchBl_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Quema Noé quipiyayaya 600 xihuit, ipan nopa 17 tonali ten nopa ompa metzti tapojqui nochi amelme campa meyayaya nopa at cati onca tatzinta huan tahuel pejqui toponi at. Huan pejqui huetzi at cati amo moquetzqui. ");
INSERT INTO nchBl_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Huan para 40 tonati huan 40 yohuali taquiyahuiyaya ipan taltipacti. ");
INSERT INTO nchBl_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Quena, ipan nopa tonal quema pehuasquía huetzis at, Noé calajqui ipan cuaacali ihuaya iconehua, Sem, Cam huan Jafet. Huan ihuaya isihua huan eyi iyexhua. ");
INSERT INTO nchBl_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Huan inihuaya calajque nochi tamanti tecuanime cati mosisiníaj, huan tapiyalme cati maxojtzitzi, huan nochi cati mohuahuatatzaj talchi huan nochi tamanti totome. ");
INSERT INTO nchBl_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Nochi tapiyalme calajque ihuaya Noé ipan cuaacali ica inihuical. ");
INSERT INTO nchBl_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Calajqui se oquichti huan se sihuatzi quej Toteco Dios quinahuatijtoya Noé. Teipa TOTECO quitzajqui icalte nopa cuaacali. ");
INSERT INTO nchBl_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Huan para 40 tonati san at hualayaya. Huan quema pejqui tejco nopa at, nopa cuaacali motananqui huan pejqui nemi aixco. ");
INSERT INTO nchBl_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Huan nopa at noja más tejcoc huan tahuel huejcata mochijqui, pero nopa cuaacali nejnentiyajqui aixco. ");
INSERT INTO nchBl_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Huan teipa noja más tejcotiyajqui hasta quinatzonpolihuilti nopa tepeme cati más huejcapantique ipan taltipacti. ");
INSERT INTO nchBl_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Huan teipa quema ya quitzactoya nopa tepeme noja tejcoc nopa at seyoc chicueyi metros iixco nopa tepeme. ");
INSERT INTO nchBl_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Yeca quej nopa mijque nochi cati itztoyaj ipan taltipacti. Mijque nochi totome, huan tecuanime cati mosisiníaj huan tapiyalme cati maxojtzitzi. Nojquiya mijque nochi tamanti piltapiyaltzitzi cati mohuahuatatzaj talchi huan nochi masehualme. ");
INSERT INTO nchBl_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Nochi cati itztoyaj ipan taltipacti cati taijyotilanayayaj mijque. ");
INSERT INTO nchBl_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","San Noé huan nochi cati itztoyaj ipan cuaacali mocajque. Nochi sequinoc quinpolihuilti. Nochi masehualme, tapiyalme, totome huan nochi cati mohuahuatatzaj mijque. ");
INSERT INTO nchBl_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Huan nopa at quiatzonpolihuilti nochi taltipacti para 150 tonati. ");
INSERT INTO nchBl_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Huajca Toteco Dios quielnamijqui Noé ica nochi nopa tapiyalme cati itztoyaj iijtic cuaacali. Huan Toteco Dios quichijqui ma taajaca ipan tali, huan nopa at pejqui temo. ");
INSERT INTO nchBl_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Huan motzajque nopa amelme campa meyayaya at tatzinta taltipacti, huan motzajqui nepa ilhuicac huan ayecmo taquiyajqui. ");
INSERT INTO nchBl_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Huan nopa at pejqui temotiya yolic. Huan ica seyoc 150 tonali miyac temotoya nopa at. ");
INSERT INTO nchBl_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Huan quema ajsic nopa 17 tonali ten nopa chicompa metzti, nopa cuaacali motalito ipan se tepet ipan nopa tepeme cati itoca Ararat. ");
INSERT INTO nchBl_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Huan mojmosta más temotiyahuiyaya nopa at. Huan quema ajsic nopa achtohui tonal ten nopa majtacpa metzti, nesqui inintzonpac nopa tepeme cati más huejcapantique. ");
INSERT INTO nchBl_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Huajca Noé quichixqui seyoc 40 tonati huan quitapo nopa ventana cati quichijtoya ipan nopa cuaacali. ");
INSERT INTO nchBl_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Huan quiquixti se cacalot huan quicahuili ma yahui. Huan nopa cacalot san patantinenqui campa hueli hasta huajqui tali. ");
INSERT INTO nchBl_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Teipa nojquiya quimajcajqui se paloma para quiitas sinta ya huajqui nopa tali. ");
INSERT INTO nchBl_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Pero nopa paloma mocuetqui ipan cuaacali pampa amo cana quipanti para mosiyajquetzas, pampa nopa tali noja temitoya ica at. Huajca Noé quiquixti imax, quiitzqui nopa paloma huan quicalaqui. ");
INSERT INTO nchBl_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Huajca Noé quichixqui seyoc chicueyi tonati huan sempa quititanqui nopa paloma calteno ten nopa cuaacali. ");
INSERT INTO nchBl_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Huan ica tiotac quema pejtoya tzintatayohuiya, nopa paloma mocuetqui huan quihualicayaya ipan itenchapich imaxihuiyo se cuahuit cati itoca olivo. Quej nopa Noé momacac cuenta para nopa tali huactiyahuiyaya. ");
INSERT INTO nchBl_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Huan Noé sempa quichixqui seyoc chicome tonati huan sempa quititanqui nopa paloma, pero ama quena, nopa paloma ayecmo mocuetqui. ");
INSERT INTO nchBl_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Huajca quema Noé quipiyayaya 601 xihuit ipan nopa achtohui tonali ten nopa achtohui metzti, tantoya nopa at. Huan Noé quiquixtili ipantzajca nopa cuaacali huan quiitac nochi huactinemiyaya. ");
INSERT INTO nchBl_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Huan ipan nopa tonali 27 itequi nopa ompa metzti, ya tami huactoya nopa tali. ");
INSERT INTO nchBl_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Huajca Toteco Dios quiilhui Noé: ");
INSERT INTO nchBl_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Xiquisa ten nopa cuaacali ihuaya mosihua, moconehua huan moyexhua. ");
INSERT INTO nchBl_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Nojquiya xiquinquixti nochi tapiyalme cati itztoque mohuaya. Xiquinquixti nopa totome huan nochi tapiyalme para ma yaca huan ma quinpiyaca miyac ininconehua huan ma quitemitica ni taltipacti.” ");
INSERT INTO nchBl_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Huajca Noé, huan isihua, huan iconehua huan iyexhua quisque ten nopa cuaacali. ");
INSERT INTO nchBl_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Nojquiya quisque nochi totome, huan nochi tapiyalme cati mosisiníaj, huan cati maxojtzitzi huan nochi cati mohuahuatatzaj. Huan sesen tamanti tapiyali quisqui ica iconehua cati quitoquiliyayaj. ");
INSERT INTO nchBl_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Teipa Noé quichijqui se taixpamit para TOTECO. Huan quicuic ten sesen tamanti tapiyali huan sesen tamanti totot cati cuali para tacajcahualisti. Huan quinmicti huan quintati ipan nopa taixpamit quej se tacajcahualisti para TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Quema TOTECO quiijnejqui ipocyo cati ajhuiyac, yaya moilhui: “Amo quema más nijtatzacuiltis taltipacti por inintajtacolhua masehualme pampa se masehuali hasta quema tacati san moilhuía ten amo cuali para quichihuas. Nojquiya ayecmo quema niquinpolihuiltis nochi tapiyalme quej nijchijqui ni huelta.” ");
INSERT INTO nchBl_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Nochi tonali quema eltos ni taltipacti, oncas toquisti huan pixquisti. Nochipa oncas tatotonilot huan tasesecayot. Oncas metzti quema tahuaquis huan metzti quema huetzis miyac at, Nochipa oncas tonaya huan tayohua. Ni tamanti amo quema tamis quema noja eltos taltipacti.” ");
INSERT INTO nchBl_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Huan Toteco Dios quitiochijqui Noé huan iconehua ica ni camanali: “Xiquinpiyaca miyac amoconehua huan xijtemitica ni taltipacti. ");
INSERT INTO nchBl_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Nochi tapiyalme ipan taltipacti amechimacasise. Anquipiyase tanahuatili ica nochi totome ipan ajacat, huan nochi tapiyalme ipan tali huan nochi cati itztoque ipan hueyi at. ");
INSERT INTO nchBl_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Huelis anquincuase nochi tapiyalme pampa nimechmaca nochi cati itztoque para tacualisti quej nojquiya nimechmacatoc nochi xihuit cati xoxohuic para tacualisti. ");
INSERT INTO nchBl_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Pero onca se tamanti cati amo cuali para anquicuase. Amo xijcuaca nacat ica ieso pampa inemilis se tapiyali eltoc ipan ieso. ");
INSERT INTO nchBl_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Amo xitemicti. Sinta se acajya quimictis se masehuali, monequi miquis. Huan sinta se tapiyali quimictis se masehuali, monequi miquis. Quena, monequi se masehuali techmacas cuenta taya quinchihuilijtoc sequinoc masehualme. ");
INSERT INTO nchBl_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Sinta acajya quimictía se masehuali, monequi sequinoc quimictise nopa temictijquet. Pampa Toteco Dios quichijchijtoc se masehuali quej ya itachiyalis. ");
INSERT INTO nchBl_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Pero amojuanti, xiquinpiyaca miyac amoconehua. Quena, ximomiyaquilica huan xijtemitica ni taltipacti, ica amoixhuihua huan amoteipan ixhuihua.” ");
INSERT INTO nchBl_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Teipa Toteco Dios quinilhui Noé huan iconehua: ");
INSERT INTO nchBl_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Ama nijcahua nocamanal ica amojuanti huan amoteipan ixhuihua, ");
INSERT INTO nchBl_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","huan ica nochi totome, huan nochi tapiyalme cati itztoque ipan taltipacti huan ica nochi cati quisque ipan cuaacali amohuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nijcahua nocamanal para ayecmo quema niquinpolihuiltis sempa nochi masehualme huan nochi tapiyalme ica miyac at campa hueli. Ayecmo quema oncas tahuel miyac at cati momanas campa hueli ipan nochi taltipacti para quisosolos. ");
INSERT INTO nchBl_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ya ni elis nopa tanextili ten nopa camanali cati nijchihua amohuaya huan inihuaya nochi tapiyalme para nochipa. Quinextis para ayecmo quema oncas tahuel miyac at hasta quinmictis nochi masehualme huan tapiyalme. ");
INSERT INTO nchBl_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Nijtalijtoc noacosemalo ipan mixti huan eltos quej se tanextili ten nopa cati nijtencahuilía ni taltipacti. ");
INSERT INTO nchBl_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Huan quema nijchihuas ma huala mixti ipan taltipacti, noacosamalo monextis ipan nopa mixti, ");
INSERT INTO nchBl_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","huan huajca niquelnamiquis nocamanal cati nijcajqui amohuaya huan inihuaya nochi tamanti tapiyalme. Ayecmo quema huetzis tahuel miyac at campa hueli ica sempa hasta quinpolos nochi tamanti cati itztoque. ");
INSERT INTO nchBl_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Pampa quema nopa acosamalot monextis ipan mixti, niquitas huan niquelnamiquis nopa camanali cati na, niamoTeco Dios, nijchijtoc para nochipa amohuaya huan inihuaya nochi masehualme huan nochi tapiyalme cati itztoque ipan ni taltipacti. ");
INSERT INTO nchBl_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ni acosamalot elis nopa tanextili ten nopa camanali cati nijchijtoc inihuaya nochi masehualme huan tapiyalme ipan taltipacti.” Quej nopa Toteco Dios quiilhui Noé. ");
INSERT INTO nchBl_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Iconehua Noé cati ihuaya quisque ipan cuaacali elque Sem, Cam huan Jafet. Huan Cam elqui itata Canaán. ");
INSERT INTO nchBl_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ten ni ieyi telpocahua Noé quisque nochi masehualme cati teipa momoyajque campa hueli ipan taltipacti para quitemitise. ");
INSERT INTO nchBl_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Huan Noé cati momajtoya miltequiti, quitojqui se xocomeca mili. ");
INSERT INTO nchBl_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Huan teipa se tonali quiic miyac xocomeca at huan ihuintic. Huan huetzqui xolot icalijtic ipan ichaj cati tachijchihuali ica yoyomit. ");
INSERT INTO nchBl_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Huan quema Cam, cati eliyaya itata Canaán, quiitac para itata huetztoya xolot, yajqui quinpohuilito iicnihua. ");
INSERT INTO nchBl_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Huajca Sem huan Jafet quicuique se yoyomit huan quitalijque iniajcoltipa huan icanejnentiyajque para amo quiitase inintata xolot. Huan quema calajque ipan icalijtic, tachixtiyajque sejcoyoc para amo quiitase Noé huan quitzajque Noé ica nopa yoyomit. ");
INSERT INTO nchBl_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Huan quema Noé isac huan ayecmo ihuintitoya, quimatqui cati Cam, icone teipan ejquet, quichijtoya huan quimatqui para amo quitepanitztoya. ");
INSERT INTO nchBl_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Huajca quiijto: “¡Toteco Dios ma quitelchihua Canaán! ¡Ma elis inintequipanojca sequinoc, huan amo aqui ma quitepanitas!” ");
INSERT INTO nchBl_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Huan Noé nojquiya quiijto: “Ma tijhueyitalica TOTECO cati Sem quihueyimati. Huan Canaán ma elis itequipanojca Sem.” Huan nojquiya quiijto: ");
INSERT INTO nchBl_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","“Toteco Dios más ma quihueyili ital Jafet. Huan iteipan ixhuihua Jafet ma itztoca inihuaya iteipan ixhuihua Sem. Huan Canaán ma eli inintequipanojca.” ");
INSERT INTO nchBl_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Huan quema tanqui nopa miyac at, Noé noja itztoya seyoc 350 xihuit, ");
INSERT INTO nchBl_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","huan mijqui quema quipiyayaya 950 xihuit. ");
INSERT INTO nchBl_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Sem, Cam huan Jafet eliyayaj iconehua Noé huan ya ni iniixhuihua cati quinpixque quema ya tantoya nopa miyac at cati momanqui ipan nochi taltipacti. ");
INSERT INTO nchBl_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Itelpocahua Jafet elque: Gomer, Magog, Madai, Javán, Tubal, Mesec huan Tiras. ");
INSERT INTO nchBl_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Itelpocahua Gomer elque: Askenaz, Rifat huan Togarma. ");
INSERT INTO nchBl_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Itelpocahua Javán elque: Elisa, Tarsis, Quitim huan Dodanim. ");
INSERT INTO nchBl_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Huan iixhuihua Jafet teipa momiyaquilijque huan mocajque nechca hueyi at ipan campa hueli talme campa camanaltiyayaj ica sese inincamanal. ");
INSERT INTO nchBl_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Itelpocahua Cam elque: Cus, Mizraim, Fut huan Canaán. ");
INSERT INTO nchBl_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Itelpocahua Cus elque: Seba, Havila, Sabta, Raama huan Sabteca. Itelpocahua Raama elque: Seba huan Dedán. ");
INSERT INTO nchBl_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Huan Cus nojquiya elqui itata Nimrod cati quipixqui miyac chicahualisti campa hueli ipan taltipacti. ");
INSERT INTO nchBl_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nochi quitocamatiyayaj Nimrod huan quimatiyayaj para ica itapalehuil TOTECO elqui se cuali tapejquet. Yeca quema masehualme quihueyitaliyayaj se tacat, quiijtosquíaj: “Yaya itztoc quej Nimrod, se cuali tapejquet ica itapalehuil TOTECO.” ");
INSERT INTO nchBl_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nopa achtohui altepeme cati moscaltijque ipan itanahuatil Nimrod elqui Babel, Erec, Acad huan Calne ipan tali Sinar. ");
INSERT INTO nchBl_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Huan itanahuatil Nimrod pejqui ipan tali Sinar huan momoyajqui hasta tali Asiria. Yaya quichijqui nopa altepeme cati inintoca Nínive, Rehobot huan Cala. ");
INSERT INTO nchBl_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Huan quichijqui Resén cati eltoya tatajco nopa hueyi altepet Nínive huan Cala. ");
INSERT INTO nchBl_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Huan Mizraim elqui itata: Ludim, Anamim, Lehabim, Naftuhim, ");
INSERT INTO nchBl_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusim, Caftorim huan Casluhim cati elqui inihueyi tata nopa filisteos. ");
INSERT INTO nchBl_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Huan Canaán elqui itata iachtohui cone cati itoca: Sidón huan quipixqui se iteipan cone cati itoca eliyaya Het. ");
INSERT INTO nchBl_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Huan Canaán nojquiya elqui inihuejcapan tata nopa masehualme: jebuseos, amorreos, gergeseos, ");
INSERT INTO nchBl_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","heveos, araceos, sineos, ");
INSERT INTO nchBl_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","arvadeos, zemareos huan hamateos. Teipa nochi ni masehualme cati eliyayaj iteipan ixhuihua Canaán momoyajque campa hueli. ");
INSERT INTO nchBl_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Inintal elqui ten tali Sidón hasta nopa piltaltzi cati itoca Gaza cati eltoya ipan ojti para Gerar. Huan neca campa quisa tonati inintal yajqui hasta altepet Lasa ipan ojti para nopa altepeme Sodoma, Gomorra, Adma huan Zeboim. ");
INSERT INTO nchBl_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Nochi ya ni elque iteipan ixhuihua Cam. Huan nica ijcuilijtoc inintoca ininfamilias, huan inincamanal cati sesen camanaltiyayaj. Huan ijcuilijtoc iniestados huan inintal ipan cati sese itztoya. ");
INSERT INTO nchBl_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Huan Sem elqui inihueyi tata Heber huan iconehua. Sem elqui cati achtohui tacatqui ten inana huan teipa tacatqui iicni Jafet. ");
INSERT INTO nchBl_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Huan Sem quinpixqui itelpocahua cati inintoca eliyayaj: Elam, Asur, Arfaxad, Lud huan Aram. ");
INSERT INTO nchBl_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Itelpocahua Aram elque: Uz, Hul, Geter huan Mas. ");
INSERT INTO nchBl_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Huan Arfaxad elqui itata Sala, huan Sala elqui itata Heber. ");
INSERT INTO nchBl_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Teipa Heber quinpixqui ome itelpocahua: Se motocaxtiyaya Peleg. (Peleg quinequi quiijtos Motajcoitac.) Quej nopa itoca pampa ipan nopa tonali taltipacti motajcoitac. Huan iicni Peleg motocaxtiyaya Joctán. ");
INSERT INTO nchBl_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Huan Joctán elqui itata: Almodad, Selef, Hazar Mavet, Jera, ");
INSERT INTO nchBl_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoram, Uzal, Dicla, ");
INSERT INTO nchBl_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO nchBl_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila huan Jobab. Nochi ya ni eliyayaj iconehua Joctán. ");
INSERT INTO nchBl_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Huan iteipan ixhuihua Joctán itztoyaj ipan nopa tali tatajco Mesa huan nopa tepeme campa quisa tonati imelac Sefar. ");
INSERT INTO nchBl_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Nochi ya ni elque iteipan ixhuihua Sem ica inihuejhueyi familias, huan inincamanal, huan ininpiltaltzitzi. Huan techilhuía nochi tali ica se tanahuatijquet campa mocahuayayaj para itztose. ");
INSERT INTO nchBl_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Huajca ni cati nimitzpohuilijtoc eltoya inintoca itayacanca teipan ixhuihua Noé. Huan sese inijuanti mochijqui se hueyi familia ica iniixhuihua cati teipa ehuani. Nojquiya nica quiijtohua nopa tali campa mocajque para itztose. Huan quema panotoya nopa miyac at, nochi xinachti masehualme quisque ten iixhuihua Noé huan campa hueli momoyajque ipan taltipacti. ");
INSERT INTO nchBl_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ipan nopa tonali nochi masehualme cati itztoyaj ipan taltipacti quipiyayayaj san se inincamanal huan camanaltiyayaj san se. ");
INSERT INTO nchBl_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Huan quema masehualme pejque momoyahuaj, miyac yajque para campa quisa tonati. Nepa quipantijque se tamayamit ipan tali Sinar huan nopona nelía miyac masehualme mocajque huan ayecmo quinejque momoyahuase. ");
INSERT INTO nchBl_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Huan se tonali inijuanti moilhuijque se ica seyoc: “Xihualaca ma tijchihuaca se hueyi altepet huan se huejcapantic torre cati ajsis hasta ilhuicac. Huan quej ni nochi techixmatise huan amo monequis timoxelose huan tiyase campa hueli ipan taltipacti. Ma tijchihuaca ladrillos huan ma tiquicxitica cuali ipan tit.” Huan quitequihuijque ladrillos ten soquit huan amo tet huan quitequihuijque chapopojti para quitatzquiltise huan amo soquit. ");
INSERT INTO nchBl_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Pero TOTECO temoc huan quiitaco nopa altepet huan nopa torre cati nopa masehualme quichijchihuayayaj. ");
INSERT INTO nchBl_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Huan yaya moilhui: “Nopa masehualme itztoque san sejco huan san se inincamanal. Yeca ni tamanti cati ama quichihuaj san ipejya cati hueli quichihuase san sejco. Teipa huelis quichihuase san cati inijuanti quinequise. ");
INSERT INTO nchBl_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Achi más cuali titemose para tiquinpatilise inincamanal para ayecmo ma quimachilica cati mocamanalhuise.” ");
INSERT INTO nchBl_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Huajca quej nopa TOTECO quichijqui huan yeca quiquetzqui inintequi huan ayecmo quichijque nopa altepet. Quej nopa TOTECO quinsemanqui nopa masehualme campa hueli ipan taltipacti para ma momoyahuaca quej ya quinequiyaya. ");
INSERT INTO nchBl_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Huan nopona itoca elqui Babel. (Babel quinequi quiijtos Campa Amo Huelque Momachilíaj Se Ica Seyoc.) Quej nopa itoca pampa nopona TOTECO quipatac inincamanal nochi masehualme cati itztoyaj ipan ni taltipacti para ayecmo huelque momachilíaj. Huan ten nopona TOTECO quinsemanqui campa hueli ipan taltipacti. ");
INSERT INTO nchBl_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ya ni eltoc inintoca iteipan ixhuihua Sem. Tanqui nopa miyac at huan ome xihuit teipa quema Sem quipiyayaya 100 xihuit, tacatqui ioquichpil Arfaxad. ");
INSERT INTO nchBl_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Teipa Sem noja itztoya seyoc 500 xihuit huan quinpixqui más iconehua, tacame huan sihuame. ");
INSERT INTO nchBl_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Huan quema Arfaxad quipixqui 35 xihuit, tacatqui ioquichpil Sala. ");
INSERT INTO nchBl_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Teipa Arfaxad noja itztoya seyoc 403 xihuit huan quinpixqui más iconehua, tacame huan sihuame. ");
INSERT INTO nchBl_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sala quipiyayaya 30 xihuit quema tacatqui ioquichpil Heber. ");
INSERT INTO nchBl_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Huan teipa Sala noja itztoya seyoc 403 xihuit huan quinpixqui más iconehua, tacame huan sihuame. ");
INSERT INTO nchBl_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Heber quipiyayaya 34 xihuit quema tacatqui ioquichpil cati itoca Peleg. ");
INSERT INTO nchBl_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Teipa Heber noja itztoya seyoc 430 xihuit huan quinpixqui más iconehua, tacame huan sihuame. ");
INSERT INTO nchBl_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Huan quema Peleg quipixqui 30 xihuit, tacatqui ioquichpil Reu. ");
INSERT INTO nchBl_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Huan teipa Peleg noja itztoya seyoc 209 xihuit huan noja quinpixqui más iconehua, tacame huan sihuame. ");
INSERT INTO nchBl_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu quipiyayaya 32 xihuit quema tacatqui ioquichpil Serug. ");
INSERT INTO nchBl_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Teipa Reu noja itztoya seyoc 206 xihuit huan quinpixqui más iconehua, tacame huan sihuame. ");
INSERT INTO nchBl_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Huan quema Serug quipixqui 30 xihuit, tacatqui ioquichpil Nacor. ");
INSERT INTO nchBl_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Huan teipa Serug noja itztoya seyoc 200 xihuit huan quinpixqui más iconehua, tacame huan sihuame. ");
INSERT INTO nchBl_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nacor quipiyayaya 29 xihuit quema tacatqui ioquichpil Taré. ");
INSERT INTO nchBl_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Teipa Nacor noja itztoya seyoc 119 xihuit huan quinpixqui más iconehua, tacame huan sihuame. ");
INSERT INTO nchBl_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Huan Taré ya quipixtoya 70 xihuit quema tacatque ioquichpilhua Abram, Nacor huan Harán. ");
INSERT INTO nchBl_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ama ya ni inintoca iteipan ixhuihua Taré. Taré elqui itata Abram, Nacor huan Harán. Huan teipa Harán elqui itata Lot. ");
INSERT INTO nchBl_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Huan Harán nojquiya quinpixqui ome iichpocahua. Se itoca Isca huan se itoca Milca. Pero Harán mijqui quema ayemo miquiyaya itata huan quema nochi inijuanti noja mocahuayayaj para itztose nopona campa tacatque ipan nopa altepet cati itoca Ur ipan nopa tali campa itztoyaj nopa caldeos. ");
INSERT INTO nchBl_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Huan Abram mosihuajti ihuaya Sarai. Huan Nacor mosihuajti ihuaya imachcone, Milca, cati elqui iichpoca Harán. ");
INSERT INTO nchBl_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Huan Sarai eliyaya se sihuat cati amo hueliyaya quinpiya coneme. ");
INSERT INTO nchBl_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Taré itztoya ipan altepet Ur ipan nopa tali campa itztoyaj nopa caldeos huan quisqui para yas ipan tali Canaán. Huan Taré quinhuicac itelpoca Abram, huan iyex, Sarai, huan iixhui, Lot, cati eliyaya itelpoca nopa mijcatzi Harán. Pero quema inijuanti ajsitoj ipan altepet Harán, mocajque nopona. ");
INSERT INTO nchBl_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Huan nopona mijqui Taré quema quipiyayaya 205 xihuit. ");
INSERT INTO nchBl_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","TOTECO ya quiilhuijtoya Abram: “Xijcajtehua motal, huan moteixmatcahua huan ichaj motata. Huan xiya hasta se tali cati nimitznextilis. ");
INSERT INTO nchBl_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Huan nimitzmacas miyac moixhuihua, huan niquinmiyaquilis moteipan ixhuihua hasta elise tahuel miyaqui masehualme ipan inintal. Nimitztiochihuas huan nijchihuas para campa hueli nochi ma mitzixmatica. Huan tielis se tatiochihualisti para sequinoc. ");
INSERT INTO nchBl_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Niquintiochihuas inijuanti cati mitztiochihuase. Huan inijuanti cati mitztelchihuase, niquintelchihuas. Huan niquintiochihuas nochi masehualme ipan taltipacti por ta.” ");
INSERT INTO nchBl_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Huajca Abram quisqui quej TOTECO quinahuatijtoya huan quipiyayaya 75 xihuit quema quisqui ipan altepet Harán para yas tali Canaán. ");
INSERT INTO nchBl_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Huan quihuicac isihua Sarai huan imachcone Lot. Nojquiya Abram quihuicac nochi nopa miyac tamanti huan tapiyalme cati quinpiyayaya huan nochi itequipanojcahua cati hualajtoyaj ihuaya ten altepet Harán pampa quincojtoya para iaxcahua. ");
INSERT INTO nchBl_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Huan quema inijuanti ajsitoj ipan tali Canaán, Abram quipanoc nopa tali hasta ajsitoj campa eltoc nopa hueyi ahua cuahuit cati itoca More nechca altepet Siquem. Ipan nopa tonali itztoyaj cananeos ipan nopa tali. ");
INSERT INTO nchBl_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Huan nopona TOTECO monexti ica Abram huan quiilhui: “Ni tali niquinmacas moteipan ixhuihua.” Huajca Abram quichijqui se taixpamit nopona para TOTECO cati monextijtoya ica ya. ");
INSERT INTO nchBl_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Teipa yajqui itztoti campa tepeco tatajco altepet Betel huan campa quisa tonati huan nopona quiquetzqui ichaj ten yoyomit. Altepet Betel mocahuayaya ica iarravesco para campa temo tonati. Huan altepet Hai mocajqui ica inejmat para campa quisa tonati. Huan nopona Abram quichijqui seyoc taixpamit huan quihueyichijqui TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Teipa sempa pejqui nejnemi hasta nopa tali cati itoca Neguev. ");
INSERT INTO nchBl_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ipan nopa tonali amo oncayaya tacualisti ipan nopa tali pampa amo taquiyajtoya. Huajca Abram yajqui para itztoti ipan tali Egipto para se ome xihuit, pampa nelía amo teno oncayaya para quicuase campa itztoyaj. ");
INSERT INTO nchBl_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Huan quema ajsitiyahuiyayaj Egipto, Abram quiilhui isihua Sarai: “Xiquita, cuali nijmati para nelía tiyejyectzi, ");
INSERT INTO nchBl_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","huan quema nopa egiptome mitzitase, quiijtose: ‘Ni sihuat, ya isihua ni tacat. Huajca ma tijmictica huan nopa sihuat elis toaxca.’ ");
INSERT INTO nchBl_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Yeca para ma amo teno nopantis, xiquijtos para tinoicni. Quej nopa techselise ica yejyectzi por ta, huan amo nimiquis.” ");
INSERT INTO nchBl_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Huajca quej nopa mocajque huan quema ajsitoj ipan tali Egipto, nopa egiptome quiitaque para Sarai eliyaya nelyejyectzi. ");
INSERT INTO nchBl_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Huan nojquiya quiitaque nopa huejhueyi tacame cati itztoyaj ichaj nopa hueyi Tanahuatijquet Faraón huan quiilhuitoj nopa tanahuatijquet para nopa sihuat eliyaya nelyejyectzi. Huajca Faraón quinnahuati ma quihuicaca ichaj para quicualtalis para teipa elis isihua. ");
INSERT INTO nchBl_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Huan pampa quiixtocac Sarai, Faraón quiseli Abram ica cuali. Huan Faraón quimacac Abram borregojme, huacaxme, burrojme, camellos huan tequipanohuani ten tacame huan sihuame para ma elica iaxcahua. ");
INSERT INTO nchBl_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Pero TOTECO quitatzacuilti nopa Faraón inihuaya nochi cati itztoyaj ipan ichaj ica cocolisti cati más fiero pampa Sarai itztoya ipan ichaj. ");
INSERT INTO nchBl_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Yeca nopa Faraón quinotzqui Abram iixpa huan quiajhuac. Quiilhui: “¿Para ten techchihuilijtoc ni tamanti? ¿Para ten amo techilhui para ni sihuat eliyaya mosihua? ");
INSERT INTO nchBl_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ta tiquijto para ya moicni huan yeca nimocuili. Xiquita, nica itztoc. ¡Xijhuica huan ya xiya!” ");
INSERT INTO nchBl_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Huajca nopa Faraón quinnahuati imasehualhua ma quicahuilica Abram ma quisa ipan nopa tali ihuaya isihua huan ica nochi cati quipixtoya. ");
INSERT INTO nchBl_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Huajca Abram quisqui tali Egipto ihuaya isihua, huan ihuaya Lot huan ica nochi cati quipixtoyaj. Huan nejnenque para norte huan sempa calajque ipan nopa tali Canaán ipan nopa huactoc tali cati itoca Neguev. ");
INSERT INTO nchBl_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Huan Abram nelía moricojchijtoya. Quipiyayaya miyac oro, plata huan tapiyalme. ");
INSERT INTO nchBl_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Quema quisque Neguev, yajque ica yolic huan ajsitoj campa nopa pilaltepetzi Betel. Huan teipa ajsitoj campa mocajtoyaj achtohui, tatajco Betel huan Hai. ");
INSERT INTO nchBl_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Nopona eliyaya campa quichijtoya se taixpamit. Huan nopona sempa quihueyichijqui TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Huan Lot cati nemiyaya ihuaya Abram nojquiya moricojchijtoya. Quipixqui san se imiyaca tapiyalme quej itío Abram. Quinpixqui miyac borregojme, chivojme, huacaxme huan miyaqui tequipanohuani cati itztoyaj ipan miyac calme ten yoyomit. ");
INSERT INTO nchBl_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Huan nopa tali campa mocahuayayaj Abram huan Lot amo quinaxiliyaya para quintamacase nochi inintapiyalhua. Huan yeca ayecmo hueliyaya itztoque san sejco pampa nelmiyaqui itztoyaj. ");
INSERT INTO nchBl_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Huan itequipanojcahua Abram cati quinmocuitahuiyayaj itapiyalhua mocualaniyayaj inihuaya cati quinmocuitahuiyayaj Lot itapiyalhua. Huan ipan nopa tonali nojquiya itztoyaj cananeos huan ferezeos campa inijuanti huan eliyayaj mahuililme. ");
INSERT INTO nchBl_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Huajca se tonali Abram quiilhui Lot: “Tojuanti tiicnime. Amo cuali para ma monajnanquilica motequipanojcahua ihuaya notequipanojcahua huan pehuas timocualanise tiome. ");
INSERT INTO nchBl_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ma timoxeloca. Xiquita, nica eltoc nochi ni tali para tijtapejpenis campa tijnequis. Sinta tijnequi tiyas nepa ica tonejmat, huajca na niyas ica toarraves. Huan sinta tiyas ica toarraves, huajca na niyas ica tonejmat.” ");
INSERT INTO nchBl_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Huan Lot quitajtachili nochi nopa yejyectzi tali ten nopa hueyat Jordán hasta nopa pilaltepetzi Zoar. Quiitac para quipiyayaya miyac at huan eliyaya quej se xochimili. Tahuel cuajcualtzi nesiyaya quej nopa tali Egipto. Ya ni panoc quema TOTECO ayemo quintamiltiyaya nopa altepeme Sodoma huan Gomorra. ");
INSERT INTO nchBl_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Huajca Lot quitapejpeni nochi nopa tamayamit nechca hueyat Jordán huan yajqui para campa quisa tonati. Quej ni moxelojque Abram huan Lot. ");
INSERT INTO nchBl_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Huajca Abram mocajqui ipan tali Canaán huan Lot yajqui itztoti ipan nopa altepeme campa tamaya. Huan Lot yolic quiijcuenijtiyajqui ichaj ten yoyomit hasta ajsito ipan altepet Sodoma ");
INSERT INTO nchBl_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","campa masehualme quipiyayayaj ininemilis tahuel fiero. Tahuel tajtacolchihuayayaj iixpa TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Teipa quema Lot ya quistoya, TOTECO quiilhui Abram: “Abram, xitachiya huejca ica norte huan ica sur, huan ica campa quisa tonati huan ica campa ontemo. ");
INSERT INTO nchBl_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Nochi ni tali cati hueli tiquita, na nimitzmacas. Huan para nochipa elis moaxca huan iniaxca moteipan ixhuihua. ");
INSERT INTO nchBl_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nijchihuas ma elica tahuel miyaqui moteipan ixhuihua quej imiyaca taltepocti. Huan sinta se huelisquía quipohuasquía taltepocti, nojquiya huelis quinpohuasquía nochi moteipan ixhuihua. ");
INSERT INTO nchBl_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Huajca ximoquetza, xinejnemi huan xijtachiliti ihuehueyaca huan ipatajca, pampa na nimitzmacas.” ");
INSERT INTO nchBl_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Huajca Abram quitananqui ichaj ten yoyomit huan quiquetzqui hasta campa oncayaya miyac ahua cuame cati eliyaya iaxca se tacat cati itoca Mamre nechca altepet Hebrón. Huan nopona Abram quichijqui se taixpamit para TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","4","Para 12 xihuit nopa Tanahuatijquet Quedorlaomer ten tali Elam quinchihualtiyaya macuilti tanahuatiani huan inimasehualhua ma quitequipanoca, pero ipan nopa 13 xihuit, nopa macuilti tanahuatiani quinyolaxitijque huan mosisinijque. Huajca mosentilijque ipan nopa tamayamit Sidim nopa macuilti tanahuatiani cati inintoca Tanahuatijquet Bera ten altepet Sodoma, Tanahuatijquet Birsa ten altepet Gomorra, Tanahuatijquet Sinab ten altepet Adma, Tanahuatijquet Semeber ten altepet Zeboim huan seyoc cati elqui tanahuatijquet ten altepet Bela cati nojquiya itoca Zoar. Sidim campa mosentilijque mocahua tatajco tepeme nechca campa eltoc nopa Hueyi At Cati Mictoc. Mosentilijque para momanahuise ten Quedorlaomer para ayecmo quitequipanose. Huan seyoc eyi tanahuatiani mosentilijque ihuaya Quedorlaomer para quipalehuise tatehuis. Ni eyi elque Tanahuatijquet Amrafel ten altepet Sinar, Tanahuatijquet Arioc ten altepet Elasar huan Tanahuatijquet Tidal ten altepet Goim. ");
INSERT INTO nchBl_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Huajca ipan nopa 14 xihuit, Quedorlaomer huan eyi tanahuatiani cati quipalehuiyayaj quisque huan nimantzi quintanque nopa refaitame ipan tali Astarot Karnaim, huan nopa zuzitame ipan tali Ham huan nopa emitame ipan Save Quiriataim. ");
INSERT INTO nchBl_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Huan quinquixtijtiyajque nopa horeos campa nopa cuatitamit Seir hasta nopa tamayamit ipan tali Parán cati eltoc nechca nopa huactoc tali campa amo teno eli. Nochi ni masehualme nopa Quedorlaomer quintanqui. ");
INSERT INTO nchBl_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Huan quema tacuepiliyayaj Quedorlaomer huan cati ihuaya itztoyaj, ajsitoj ipan tali En Mispat cati nojquiya itoca Cades. Huan quintanque nochi nopa amalecitame huan amorreos cati itztoyaj ipan nopa altepet Hazezón Tamar. ");
INSERT INTO nchBl_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Huajca nopa macuilti tanahuatiani ten altepeme Sodoma, Gomorra, Adma, Zeboim huan Bela o Zoar yajque ipan nopa tamayamit cati itoca Sidim huan mocualtalijque para motehuise inihuaya nopa nahui tanahuatiani cati eliyaya Tanahuatijquet Quedorlaomer ten tali Elam, huan ihuampoyohua cati inintoca: Tanahuatijquet Tidal ten altepet Goim, Tanahuatijquet Amrafel ten altepet Sinar huan Tanahuatijquet Arioc ten altepet Elasar. ");
INSERT INTO nchBl_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Pero nopa macuilti amo huelque tatanij. Huan ipan tamayamit Sidim oncayaya miyac ostot ica chapopojti. Huajca quema nopa tanahuatiani ten Sodoma huan Gomorra huan inihuampoyohua quinequiyayaj cholose ten nopa tatehuilisti, sequij ten inijuanti huetzque ipan nopa ostot huan sequinoc cholojque campa tepeme. ");
INSERT INTO nchBl_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Huajca tatanqui Quedorlaomer huan ihuampoyohua. Huan quicuique nochi tacualisti huan tamanti cati ipati cati oncayaya ipan altepeme Sodoma huan Gomorra huan quistejque. ");
INSERT INTO nchBl_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Huan pampa Lot, imachcone Abram, itztoya ipan altepet Sodoma, nojquiya quihuicaque ilpitoc ica nochi cati quipixtoya. ");
INSERT INTO nchBl_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Pero cholo se tacat huan quipohuilico Abram, nopa hebreo tacat quema mocahuayaya campa iahuamil se amorreo tacat cati itoca Mamre. Mamre eliyaya iicni Escol huan Aner cati nojquiya quimapalehuiyayaj Abram. ");
INSERT INTO nchBl_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Huajca quema Abram quimatqui para imachcone Lot quihuicatoyaj ilpitoc, quinsentili 318 itequipanojcahua cati temachme cati tacajtoyaj ipan ichaj, huan momachtijtoyaj tatehuise huan yajque para quipantitij Quedorlaomer huan quimanahuise Lot. Huan quintepotztocaque hasta nopa pilaltepetzi cati itoca Dan. ");
INSERT INTO nchBl_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Huan ica tayohua Abram quinpanti huan quintajcoitac itequipanojcahua huan quinyahualojque huan pejque quintehuíaj quema amo quinchiyayayaj. Huan quintehuijtiyajque hasta altepet Hoba cati mocahua ica norte ten altepet Damasco. ");
INSERT INTO nchBl_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Huan Abram quintanqui. Huan quimanahui imachcone, Lot, huan nopa sequinoc tacame huan sihuame cati quinhuicatoyaj. Huan quincuili nochi cati quiichtectoyaj. ");
INSERT INTO nchBl_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Huan quema Abram ya quitantoya Quedorlaomer huan cati quipalehuiyayaj, mocuetqui ipan ojti para ichaj. Huan ipan nopa tamayamit tatajco tepeme campa itoca Save o Inintamaya Tanahuatiani, hualajqui quinamiquico nopa tanahuatijquet ten altepet Sodoma. ");
INSERT INTO nchBl_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Huan nojquiya hualajqui quinamiquico Melquisedec, nopa tanahuatijquet ten altepet Salem. Yaya nojquiya eliyaya Itotajtzi Toteco Cati Más Hueyi. Huan Melquisedec quinmacac Abram huan itequipanojcahua pantzi huan xocomecat iayo. ");
INSERT INTO nchBl_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Huan quitiochijqui Abram ica ni camanali: “Abram, ma mitztiochihua Toteco Cati Más Hueyi, yaya cati quichijqui ilhuicacti huan taltipacti. ");
INSERT INTO nchBl_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Quena, ma tijhueyichihuaca Toteco Cati Más Hueyi, pampa quichijqui xiquintani mocualancaitacahua.” Huajca Abram quimacac Melquisedec se diezmo ten nochi cati quitantoya. ");
INSERT INTO nchBl_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Teipa nopa tanahuatijquet ten Sodoma quiilhui Abram: ―San techmactili nopa masehualme cati ehuani noaltepe cati tiquinmanahuijtoc huan ximocahui nochi tamantzitzi cati eliyaya iniaxca. ");
INSERT INTO nchBl_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Pero Abram quinanquili: ―Niquilhuijtoc TOTECO cati quichijqui ilhuicacti huan taltipacti, ");
INSERT INTO nchBl_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","para amo teno nijselis cati eliyaya amoaxca. Amo nijcuis yon se icpat, yon se lazo cati ica niquilpis notecac para amo quema huelis tiquijtos ta techricojchijqui. ");
INSERT INTO nchBl_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Amo teno nijnequi para na. San tijselise cati quicuajque notequipanojcahua. Pero nopa tacame cati yajque nohuaya, Aner, Escol huan Mamre, xiquincahuili ma quicuica cati quinamiqui para quiselise. ");
INSERT INTO nchBl_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Teipa TOTECO quinotzqui Abram ipan se tanextili cati elqui quej se temicti huan quiilhui: “Amo ximajmahui, Abram, pampa na nimitzmocuitahuis. Motaxtahuil elis nelhueyi.” ");
INSERT INTO nchBl_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Pero Abram quinanquili: ―TOTECO, Ta Cati Más Tijpiya Tanahuatili, san tapic para techmacas miyac tamanti pampa amo nijpiya se conet para nijcahuilijtehuas. Amo techmacatoc yon se nocone. Huan notequipanojca Eliezer cati ehua altepet Damasco quiselis nochi cati nijpiya quema nimiquis. ");
INSERT INTO nchBl_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Huan TOTECO quinanquili: ―Amo yaya quiselis cati tijcajtehuas. Quiselis se mocone cati tijpiyas teipa huan quipiyas ta moeso. ");
INSERT INTO nchBl_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Huajca TOTECO quihuicac Abram calteno huan quiilhui: ―Xijtachili ilhuicacti huan xijchihua fuerza xiquinpohua nopa sitalime. Quej nopa elis inimiyaca moteipan ixhuihua. Itztose tahuel miyaqui hasta amo aqui huelis quinpohuas. ");
INSERT INTO nchBl_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Huajca Abram quineltocac cati TOTECO quiijto huan TOTECO quiijcuilo nepa ilhuicac para Abram itztoya xitahuac iixpa. ");
INSERT INTO nchBl_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Huan TOTECO quiilhui: ―Na nimoTECO. Nimitzhualicac ten altepet Ur campa itztoque nopa caldeos para nimitzmacas ni tali para timoaxcatis. ");
INSERT INTO nchBl_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Pero Abram quiilhui: ―TOTECO, ta cati más tijpiya tanahuatili, ¿quenicatza huelis nijmatis sinta melahuac nijselis ni tali? ");
INSERT INTO nchBl_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Huan Toteco Dios quinanquili: ―Techhualiquili se becerra, se chivo huan se oquich borrego cati quipiyaj eyi xihuit. Nojquiya techhualiquili se pichontzi huan se paloma. ");
INSERT INTO nchBl_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Huajca Abram quihualiquili Toteco Dios nochi ni tapiyalme. Quinmicti, huan quintajtajcoitac huan quinijixnamicti, pero nopa totome amo quintajcoitac. ");
INSERT INTO nchBl_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Huan tzojpilome temoyayaj ipan nopa tapiyalme cati mictoyaj, pero Abram quinmajmatiyaya. ");
INSERT INTO nchBl_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Huan quema ya tatayohuatoya, Abram nelcochqui huan quimatqui para hualajqui ipan ya se tzintayohuilot huan tahuel majmahuiyaya. ");
INSERT INTO nchBl_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Huajca TOTECO quiilhui: ―Moteipan ixhuihua yase itztotij ipan seyoc tali quej seyoc tali ehuani. Huan masehualme cati nopona ehuani quintequihuise chicahuac huan quinitase quej iniaxcahua huan nopona moteipan ixhuihua taijyohuise para 400 xihuit. ");
INSERT INTO nchBl_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Pero teipa na nijtatzacuiltis nopa tali huan imasehualhua cati quintequihuise. Huan moteipan ixhuihua quisase ica miyac tamanti cati tahuel ipati. ");
INSERT INTO nchBl_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Pero ta timiquis quema ya tihuehuejtitos, quema noja oncas tasehuilisti. Mitztalpachose quema ayemo ajsitos nopa tonali. ");
INSERT INTO nchBl_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Nopona ipan nopa tali mocahuase hasta miquise moteipan ixhuihua cati achtohui calajque ipan nopa tali. Mocahuase hasta miquise ininconehua, huan iniixhuihua huan ininconehua iniixhuihua. Huan huajca quena, nopa masehualme huan ininconehua tacuepilise sempa nica ipan ni tali. Pero para amantzi ayemo ajsi tonali para hualase pampa ayemo tahuel nelfiero quichihuaj nopa amorreos cati ama itztoque nica ipan ni tali. Huajca ayemo ajsi nopa tonali para niquintatzacuiltis quej nijchihuas teipa ipan nopa tonali quema sempa hualase moteipan ixhuihua nopona. ");
INSERT INTO nchBl_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Huan quema ya temotoya tonati huan nochi ya tzintayohuatoya, nesqui quej se comit cati quipixtoya tilelemecti huan popocayaya. Huan nopa comit panoc tatajco campa nopa tapiyalme cati Abram quintejtectoya. ");
INSERT INTO nchBl_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Huan quej nopa ipan nopa tonali, TOTECO quicajqui icamanal ica Abram huan quiilhui: ―Nochi ni tali niquinmacas moteipan ixhuihua. Quiselise nochi ni tali ten campa pehua ica nopa hueyi hueyat ipan tali Egipto ica campa temo tonati huan noja quiselise hasta nopa hueyi hueyat cati itoca Eufrates campa quisa tonati. ");
INSERT INTO nchBl_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Nochi ni tali elis iniaxca campa ama itztoque nopa masehualme ceneos, cenezeos, cadmoneos, ");
INSERT INTO nchBl_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","heteos, ferezeos, refaitame, ");
INSERT INTO nchBl_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","amorreos, cananeos, gergeseos huan jebuseos. Nochi elis iniaxca moteipan ixhuihua. ");
INSERT INTO nchBl_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai, isihua Abram, amo huelqui conepiya, pero quipiyayaya se itequipanojca ten tali Egipto cati itoca Agar. ");
INSERT INTO nchBl_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Huajca Sarai moilhui quichihuas quej momajtoyaj quichihuaj ipan nopa tonali huan quimactilis ihuehue itequipanojca. Yeca quiilhui Abram: ―Xiquita, TOTECO amo nechcahuilijtoc ma niconepiya, huajca xicochi ihuaya notequipanojca Agar para yaya huelis quinpiyas coneme cati elise quej na noconehua. Huan Abram quichihuili cuenta cati Sarai quiilhui. ");
INSERT INTO nchBl_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Huan Sarai quinotzqui Agar, nopa Egipto ejquet, huan quimactili Abram para ihuaya ma cochi. Quema panoc ya ni, Abram ya quipixtoya majtacti xihuit para itztoc ipan tali Canaán. ");
INSERT INTO nchBl_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Huan Abram quiixmatqui Agar, huan Agar conecuic. Huan quema Agar momacac cuenta para ya conepiya, mohueyimatqui huan pejqui quicualancaita Sarai. ");
INSERT INTO nchBl_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Huajca Sarai quiilhui Abram: ―Ta motajtacol para nechcualancaita Agar. Na nimitzmactili para ihuaya ximoteca, pero quema quimatqui para conepiyas, mohueyimatqui. Ma TOTECO quiijto ajquiya quipiya tajtacoli, sinta ta o na. ");
INSERT INTO nchBl_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Huan Abram quinanquili: ―Xiquita, Sarai, motequipanojca Agar itztoc momaco para tijtatzacuiltis quej tiquitas cuali. Huajca Sarai pejqui quitaijyohuiltía Agar, huan yeca Agar cholojtejqui. ");
INSERT INTO nchBl_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Pero iilhuicac ejca TOTECO quipanti Agar campa meyayaya at ipan nopa huactoc tali campa amo teno eli. Itztoya ipan nopa ojti cati yahui para Shur. ");
INSERT INTO nchBl_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Huan iilhuicac ejca TOTECO quitatzintoquili: ―Agar, tiitequipanojca Sarai, ¿canque tihuala huan canque tiya? Huan Agar quinanquili: ―Nicholohua imaco noteco, Sarai. ");
INSERT INTO nchBl_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Huajca iilhuicac ejca TOTECO quiilhui: ―Xiya sempa campa moteco huan xijneltoquili nochi cati mitznahuatis. ");
INSERT INTO nchBl_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Huan nojquiya iilhuicac ejca TOTECO quiilhui: “Na niquinmiyaquilis moteipan ixhuihua hasta amo aqui huelis quinpohuas. ");
INSERT INTO nchBl_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ya ticonecuitoc huan tijpiyas se oquichpil huan tijtocaxtis Ismael, pampa TOTECO quicajqui quema timocuesohuayaya. (Ismael quinequi quiijtos TOTECO Tacaqui.) ");
INSERT INTO nchBl_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Huan mocone elis se tacat cati mosisinía. Motehuis inihuaya nochi, huan nochi quinequise quitehuise. Huan yaya itztos ica cualanti mojmosta ica nochi iicnihua.” ");
INSERT INTO nchBl_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Huan Agar quitocaxtali TOTECO cati ihuaya mocamanalhuijtoya “Toteco Dios Cati Nochi Quiita”. Quej nopa quitocaxti pampa moilhuiyaya: “Niquitztoc Toteco Dios cati techita huan noja niitztoc.” ");
INSERT INTO nchBl_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Huan yeca nopa ameli cati mocahua tatajco Cades huan Bered ama quitocaxtijtoque Beer Lahai Roi. (Beer Lahai Roi quinequi quiijtos Iamel Yaya Cati Itztoc Huan Cati Nechita.) ");
INSERT INTO nchBl_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Huan Agar quitacatilti icone Abram, huan Abram quitocaxti Ismael. ");
INSERT INTO nchBl_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Huan Abram quipiyayaya 86 xihuit quema tacatqui Ismael. ");
INSERT INTO nchBl_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Huan quema Abram quipiyayaya 99 xihuit, TOTECO Cati Quipiya Nochi Chicahualisti monexti campa ya huan quiilhui: ―Na niamoTeco Dios Cati Nijpiya Nochi Chicahualisti. Ximotemachi ipan na huan xijchihua san cati xitahuac noixpa. ");
INSERT INTO nchBl_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Huan na nijcahuas nocamanal ica ta para temachti nijchihuas para tiquinpiyas tahuel miyac moteipan ixhuihua. ");
INSERT INTO nchBl_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Huan Abram motancuaquetzqui huan mohuijtzonqui hasta talchi quema Toteco Dios quicamanalhuiyaya. Huan Toteco Dios nojquiya quiilhui: ");
INSERT INTO nchBl_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","―Nijcahua nocamanal ica ta para tielis tiinintata tahuel miyac masehualme cati itztose ipan tahuel miyac talme. ");
INSERT INTO nchBl_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Huan motoca ayecmo elis Abram. (Abram quinequi quiijtos Se Teta Cati Nochi Quitepanitaj.) Ama motoca elis Abraham. (Abraham quinequi quiijtos Inintata Miyac Masehualme Cati Itztoque Ipan Miyac Talme.) Quej nopa elis motoca pampa nimitzchihuas tiinintata miyac masehualme ipan miyac talme. ");
INSERT INTO nchBl_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Quena, nijchihuas para moteipan ixhuihua ma elica nelía miyaqui. Ipan ta quisase huejhueyi tanahuatiani cati quinnahuatise inimasehualhua ipan miyac talme. ");
INSERT INTO nchBl_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Huan na nijtamichihuas nochi cati nijcajtoc nocamanal para nijchihuas ica ta huan moteipan ixhuihua teipa para nochipa. Ni elis se camanal sencahuali cati amo quema tamis. Nochipa nielis nimoDios huan niininDios moteipan ixhuihua. ");
INSERT INTO nchBl_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Huan nochi ni tali cati itoca Canaán campa ama tiitztoc, nimitzmacas ta huan moteipan ixhuihua. Huan elis iniaxca para nochipa, huan na nielis niininDios. ");
INSERT INTO nchBl_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Huan Toteco Dios sempa quiilhui Abraham: ―Huan ya ni cati ta huan nochi moteipan ixhuihua monequi xijchihuaca. Monequi xijneltocaca nochi cati quiijtohua ni camanali cati nijchihua mohuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Huan ya ni nopa camanali cati monequi xijchihuaca. Monequi nochi oquichpilme huan tacame ma motequilica quej nimitzilhuía. ");
INSERT INTO nchBl_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ma quitzontequica iyecapa nopa cuetaxti ipan ininpiltacayohua. Ya nopa itoca circuncisión. Huan ya nopa elis nopa tanextili ten ni camanal sencahuali cati nijchihua amohuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Huajca ama monequi ta huan nochi tacame cati mitztequipanohuaj, masque tijcojqui nopa tacat para moaxca quema ya hueyi, o quitacatilti se motequipanojca, monequi nochi motequilise. Huan nojquiya monequi anquintequilise nochi amooquichpilhua cati tacajtiyase teipa. Xijchihuaca quema quipiyas chicueyi tonati ica tacajtoc. Quej nopa monequis ica moteipan ixhuihua, huan ininteipan ixhuihua motequipanojcahua huan ica nochi tequipanohuani cati tiquincohuas ten sequinoc talme. ");
INSERT INTO nchBl_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Nochi tacame huan oquichpilme monequi motequilise. Huan quej nopa elis quej anquihuicase se tanextili ten nocamanal ipan amonacayo huan nopa camanali cati nijchihua amohuaya huejcahuas para nochipa. ");
INSERT INTO nchBl_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Huan cati amo motequilis monequi xijquixtica para ayecmo quema itztos inihuaya momasehualhua pampa amo quitepanitac nopa camanali cati nijchijtoc ica amojuanti. ");
INSERT INTO nchBl_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Nojquiya Toteco Dios quiilhui Abraham: ―Huan mosihua, ayecmo elis itoca Sarai. Ama itoca elis Sara. (Sara quinequi quiijtos Iichpoca Se Tanahuatijquet.) ");
INSERT INTO nchBl_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Huan Sara nijtiochihuas huan temachti nimitzmacas se mocone ipan ya. Huan yaya elis ininana miyac masehualme ipan miyac talme, huan miyac iteipan ixhuihua elise huejhueyi tanahuatiani. ");
INSERT INTO nchBl_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Huan Abraham motancuaquetzqui huan mohuijtzonqui talchi para quihueyichihuas Toteco Dios, pero yolhuetzcayaya pampa amo quineltocayaya. San moilhuiyaya: “¿Quenicatza huelis nijpiyas se conet quema ya nijpiya 100 xihuit? Huan ¿quenicatza huelis Sara conepiyas quema ya quiaxiti 90 xihuit?” ");
INSERT INTO nchBl_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Huajca Abraham quiilhui Toteco Dios: ―Sinta huelis, san xijcahua nooquichpil Ismael ma itztos ica motatiochihualis. ");
INSERT INTO nchBl_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Huan Toteco Dios quinanquili: ―¡Amo! Amo ya nopa cati nimitzilhuía. Niquijto mosihua Sara quipiyas se icone cati tijtocaxtis Isaac. Huan ihuaya ya nicompahuis nopa camanali huan inihuaya iteipan ixhuihua para nochipa. ");
INSERT INTO nchBl_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Pero nojquiya nijcactoc cati techtajtanijtoc para Ismael huan quena, nijtiochihuas. Nijchihuas ma quinpiya miyac iconehua huan para ma momiyaquilica iixhuihua. Huan yaya elis inintata 12 huejhueyi tacame. Ica ya huan iteipan ixhuihua niquinchihuas ma elica se xinach masehualme ica miyac imasehualhua huan quipiyase se hueyi tali. ");
INSERT INTO nchBl_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Pero nopa camanal sencahuali nijchihuas ica Isaac, nopa conet cati Sara quitacatiltis ne se xihuit, quej ama. ");
INSERT INTO nchBl_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Huan quema Toteco Dios tanqui camanalti ihuaya Abraham, quistejqui. ");
INSERT INTO nchBl_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Huan nimantzi ipan nopa tonal Abraham quitzontequili iyecapa nopa cuetaxti ipan ipiltacayo Ismael. Huan nojquiya quintzontequili inincuetaxo nochi itequipanojcahua cati tacajtoyaj ipan ichaj huan nochi tacame cati quincojtoya. Quena, nochi tacame cati itztoyaj ipan ichaj huan cati quitequipanohuayayaj motequilijque quej Toteco Dios tanahuati. ");
INSERT INTO nchBl_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","25","Huan Abraham quipiyayaya 99 xihuit, huan icone, Ismael, quipiyayaya 13 xihuit quema quintzontequilijque inincuetaxo. ");
INSERT INTO nchBl_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Huajca ipan nopa tonal quema Toteco Dios quicamanalhui Abraham, Abraham huan icone, Ismael, motequilijque. ");
INSERT INTO nchBl_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Huan nojquiya motequilijque nochi nopa itequipanojcahua, tacame huan oquichpilme, cati itztoyaj ipan ichaj, masque tacatque nopona o quincojtoya ipan sequinoc talme. ");
INSERT INTO nchBl_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Huan TOTECO monexti campa Abraham quema itztoya ipan nopa ahuamili campa nopa huejhueyi cuame cati iaxca Mamre. Quej ni panoc. Se tonali Abraham mosehuijtoya calteno nechca ichaj ten yoyomit ipan nopa hora quema más tatotoniya. ");
INSERT INTO nchBl_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Huan Abraham ajcotachixqui huan quinitac eyi tacame ajsitihualayayaj nechca ichaj. Huan quema quinitac, moquetzqui huan motalo para quinnamiquis huan motancuaquetzqui huan mohuijtzonqui hasta talchi, ");
INSERT INTO nchBl_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","huan quiijto: ―Tatame, techchihuilica se favor, xipanoca techpaxaloca. ");
INSERT INTO nchBl_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Huan sinta anquiitaj cuali, nitajtanis se quentzi at para anmoicxipajpacase huan anmosiyajquetzase se quentzi itzinta ni cuahuit campa taecahuíaj. ");
INSERT INTO nchBl_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Nojquiya nimechhualiquilis se quentzi tacualisti para xijpiyaca tetili huan teipa sempa huelis anyase ipan amoojhui. Para na se paquilisti anhualajtoque huan nijnequi nimechtequipanos sinta antechcahuilise. Huan inijuanti quinanquilijque: ―Cualtitoc. ");
INSERT INTO nchBl_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Huan Abraham calajqui ipan ichaj ten yoyomit huan quiilhui Sara: ―Nimantzi xijcui eyi tatamachihuali ten harina cati más cuali huan xijchihua pantzi. ");
INSERT INTO nchBl_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Teipa Abraham motalo campa itztoyaj itapiyalhua huan quitapejpeni se becerro cati nelía yejyectzi. Huan quimacac se itequipanojca, huan ya nimantzi quichijqui se tacualisti. ");
INSERT INTO nchBl_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Huan teipa Abraham quinhualiquili mantequilla, lechi huan nopa becerro tacacatzoli huan quinmacac ma quicuaca. Huan Abraham moquetzqui nechcatzi cuatzinta para quintequipanos quema inijuanti tacuayayaj. ");
INSERT INTO nchBl_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Huan quema tanque tacuaj, nopa paxalohuani quitatzintoquilijque Abraham: ―¿Canque itztoc mosihua Sara? Huan Abraham tananquili: ―Itztoc nepa calijtic. ");
INSERT INTO nchBl_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Huajca se ten nopa tacame quiijto: ―Ne se xihuit quej ama sempa nimitzpaxaloqui, huan mosihua Sara ya quitacatiltijtos icone. Huan Sara moquetztoya icalixpa, quintacaquilijtoya cati camanaltiyayaj ihuaya Abraham. ");
INSERT INTO nchBl_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Huan Abraham huan Sara eliyayaj huehuentzitzi, huan ya panotoya nopa xihuit para Sara quipiyasquía se icone. ");
INSERT INTO nchBl_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Huan yeca amo huelqui moijyohui para amo huetzcas huan moilhui: “¿Quenicatza huelis nijpiyas ni paquilisti ama quema nohuehue huan na ya tihuehuentzitzi?” ");
INSERT INTO nchBl_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Pero TOTECO quiilhui Abraham: ―¿Para ten huetzcac Sara? ¿Para ten quiijto: ‘¿Quenicatza huelis nijpiyas ni paquilisti ama quema nohuehue huan na ya tihuehuentzitzi?’ ");
INSERT INTO nchBl_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","¿Timoilhuía para onca se tamanti cati na, nimoTeco Dios, amo hueli nijchihuas? Ne se xihuit sempa nimechpaxaloqui huan Sara quipixtos icone. ");
INSERT INTO nchBl_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Huan quema Sara quicajqui cati quiijto, majmajqui huan istacatic huan quiijto: ―Na amo nihuetzcac. Pero TOTECO quinanquili: ―Na nijmati para tihuetzcac. ");
INSERT INTO nchBl_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Teipa nopa paxalohuani moquetzque huan pejque nejnentiyahuij ipan ojti para altepet Sodoma. Huan Abraham inihuaya yajqui para quinnahuatijtehuas. ");
INSERT INTO nchBl_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Huajca TOTECO moilhui: “Monequi niquilhuis Abraham cati nijchihuas, ");
INSERT INTO nchBl_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","pampa yaya elis inintata miyaqui tacame huan sihuame cati mochihuase se hueyi xinach masehualme cati quipiyase miyac chicahualisti. Huan niquilhuijtoc para niquintiochihuas nochi masehualme ipan nochi talme ipan taltipacti ica ya. ");
INSERT INTO nchBl_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Na nijtapejpenijtoc para ma quinnextili iconehua ma quineltocaca notamachtil huan ma quichihuaca nochi cati cuali huan cati xitahuac. Huan na niquinchihuilis nochi cati cuali niquilhuijtoc.” ");
INSERT INTO nchBl_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Huajca TOTECO quiilhui Abraham: ―Nechyolmelajtoque para nopa masehualme ipan altepeme Sodoma huan Gomorra nelmosisiníaj. Nelfiero ininemilis huan tahuel miyac inintajtacolhua. ");
INSERT INTO nchBl_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ama niya nepa para niquitas sinta nelía inintajtacol nelhueyi quej nechilhuijtoque. Huan quej nopa nijmatis. ");
INSERT INTO nchBl_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Huan ne seyoc ome paxalohuani quisque para Sodoma, pero TOTECO mocajqui ihuaya Abraham. ");
INSERT INTO nchBl_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Huan Abraham quinechcahui huan quitatzintoquili: ―¿Tiquinpolos masehualme cati itztoque xitahuaque inihuaya cati tajtacolejque? ");
INSERT INTO nchBl_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Sinta itztoque 50 masehualme cati cuajcualme ipan nopa altepet, ¿noja tijtatzacuiltis nopa altepet? ¿Amo tijtapojpolhuis nopa altepet por nopa 50 masehualme? ");
INSERT INTO nchBl_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Amo cuali sinta tiquinmictis cuajcualme inihuaya cati tahuel tajtacolchijtoque pampa quej nopa nesi para nochi ome quipiyaj san se inintajtacol. ¡Amo xijchihua ya nopa! Ta, tijuez cati más tihueyi ipan nochi ni taltipacti, huan nijmati ta tijchihuas cati xitahuac. ");
INSERT INTO nchBl_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Huan TOTECO quinanquili: ―Sinta niquinpantis 50 masehualme cati itztoque xitahuaque ipan nopa altepet, huajca niquintapojpolhuis nochi por nopa 50 masehualme cati itztoque xitahuaque. ");
INSERT INTO nchBl_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Pero Abraham sempa quiilhui: ―Techtapojpolhui Toteco, sinta sempa nimitzcamanalhuía, pampa ta, tiToteco Dios, huan na san nise masehuali. ");
INSERT INTO nchBl_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Pero nohueli polihuij macuilti masehualme para ajsis 50 cati itztoque xitahuaque. ¿Tiquinmictis nochi ipan nopa altepet sinta san polihuij nopa macuiltij? Huan TOTECO quinanquili: ―Sinta niquinpantis 45 masehualme cati xitahuaque, amo nijpolos nopa altepet. ");
INSERT INTO nchBl_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Huan Abraham sempa quiilhui: ―Pero nohueli san itztoque 40 masehualme cati xitahuaque. Huan TOTECO quiijto: ―Sinta itztoque 40 cati xitahuaque, amo nijtamiltis nopa altepet. ");
INSERT INTO nchBl_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Pero Abraham sempa quiilhui: ―Nimitztajtanía amo xicualani nohuaya pampa nimitztatzintoquilía miyac hueltas, pero nohueli tiquinpantis san 30 masehualme cati itztoque xitahuaque. Huan Toteco sempa quiilhui: ―Sinta itztoque 30 masehualme cati itztoque xitahuaque, amo nijpolos nopa altepet. ");
INSERT INTO nchBl_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Huan Abraham noja quitatzintoquili: ―Toteco, nijmati para nimitznelcuatotonía pampa nimitznojnotza quej ni, pero ¿taya panos sinta san 20 masehualme cati itztoque xitahuaque tiquinpantis? Huan Toteco quiilhui: ―Sinta itztoque 20 cati xitahuaque, amo niquinmictis cati itztoque ipan nopa altepet. ");
INSERT INTO nchBl_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Huan Abraham sempa quitatzintoquili: ―NoTeco, amo xicualani nohuaya, pero nimitztatzintoquilis san ni huelta: ¿Taya tijchihuas sinta san tiquinpantis majtacti masehualme cati itztoque xitahuaque? Huan Toteco quiilhui: ―Sinta itztoque majtacti masehualme cati xitahuaque, amo nijsosolos nopa altepet. ");
INSERT INTO nchBl_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Huan quema TOTECO tanqui camanalti ihuaya Abraham, quistejqui. Huan Abraham no yajqui ichaj. ");
INSERT INTO nchBl_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Huan quema ya tayohuayaya nopa ome ilhuicac ehuani ajsitoj altepet Sodoma. Huan Lot mosehuijtoya nechca icalte nopa altepet campa tayacanani momajtoyaj mosentilíaj. Huan quema Lot quinitac, moquetztiquisqui para quinnamiquiti huan quinseli ica yejyectzi. Huan motancuaquetzqui huan mohuijtzonqui hasta talchi, ");
INSERT INTO nchBl_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","huan quinilhui: ―Tatame, techchihuilica se favor, ximocahuaca ni tayohua ipan nochaj. Nopona anmoicxipajpacase huan antonilise. Huan mosta cualca huelis sempa anyase ipan amoojhui. Pero quiijtojque: ―¡Amo! Tascamati. Tojuanti san ticochise nica calteno ipan calle. ");
INSERT INTO nchBl_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Pero Lot quinnelchihualti para ma cochica ichaj hasta quiijtojque para quena, huan yajque ichaj. Huan quema ajsitoj, Lot tanahuati ma quinsencahuilica se cuali tacualisti ica pantzi cati amo quipiya tasonejcayot. Huan nopa paxalohuani tacuajque. ");
INSERT INTO nchBl_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Huan teipa quema ayemo motecayayaj, nochi nopa tacame ten altepet Sodoma quiyahualocoj ichaj Lot. Hualajque cati más telpocame hasta cati más huehuentzitzi, ");
INSERT INTO nchBl_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","huan pejque quitzajtzilíaj Lot: ―¿Canque itztoque nopa tacame cati hualajque mochaj ni tayohua? ¡Xiquinquixti para timotecase inihuaya! ");
INSERT INTO nchBl_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Huajca Lot quisqui calteno para quincamanalhuis huan cuali quitzajqui nopa caltemit iica. ");
INSERT INTO nchBl_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Huajca Lot quinilhui nopa fiero tacame: ―Amo, nohuampoyohua, nimechtajtanía amo xijchihuaca nopa tamanti cati fiero. ");
INSERT INTO nchBl_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Niquinpiya ome noichpocahua cati ayemo quiixmajtoque yon se tacat, niquinquixtis huan nimechmacas para xijchihuaca inihuaya cati anquinequij, pero amo teno xiquinchihuilica ni tacame pampa nopaxalojcahua. ");
INSERT INTO nchBl_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Pero quinanquilijque: ―¡Ximijcueni tiseyoc tali ejquet! ¿San tiajsico nica huan tijnequi technahuatis? ¡Ama timitzchihuilise más fiero que inijuanti! Huan nimantzi pejque quitemajmatíaj Lot huan monechcahuijque campa caltemit para quitahuisose. ");
INSERT INTO nchBl_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Pero ipaxalojcahua quitapojque caltemit huan nimantzi quiitzquijque Lot huan quicalaquijque calijtic. Teipa sempa quitzajque caltemit. ");
INSERT INTO nchBl_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Huan ipaxalojcahua quinchijque ma popoyotiyaca nopa tacame cati itztoyaj calteno. Huan nochi hasta cati más telpocat huan hasta cati más huehuentzi, mocajque popoyotzitzi. Huan cuatique quitemohuaj nopa caltemit. ");
INSERT INTO nchBl_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Huajca nopa paxalohuani quiilhuijque Lot: ―Sinta tiquinpiya más moteixmatcahua nica ipan ni altepet, motaca conehua, mosihua conehua, momonticahua o sequinoc moteixmatcahua, monequi xiquinquixti huan huejca xiquinhuica. ");
INSERT INTO nchBl_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Pampa tijtamiltise ni altepet huan miquise nochi cati itztoque nica pampa tahuel miyac tajtacoli quichijtoque. TOTECO quitacaquilijtoc hasta ayecmo quiijyohuía cati fiero quichihuaj nica ehuani. Huajca techtitantoc para ma tijtamiltica ica nochi cati nica itztoque. ");
INSERT INTO nchBl_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Huajca Lot yajqui quinitato cati teipa elisquíaj imonticahua pampa ya quinijtantoyaj iichpocahua huan quinilhui: ―¡Ximoisihuiltica, xiquisaca huan huejca xiyaca pampa TOTECO quitamiltis ni altepet! Pero imonticahua amo quineltocaque. Moilhuijque san ahuilcamanaltiyaya. ");
INSERT INTO nchBl_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Huan quema ya tanestihualayaya, nopa ilhuicac ehuani quiisihuiltijque Lot huan quiilhuijque: ―Nimantzi ximoisihuilti huan xiquinhuica mosihua huan ne ome moichpocahua huejca para amo anmiquise quema tijtamiltise ni altepet. ");
INSERT INTO nchBl_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Huan Lot huejcahuayaya. Pero pampa TOTECO quitasojtac, nopa ilhuicac ehuani quimaitzquijque, huan quinitzquijque isihua huan iichpocahua huan quinquixtijque ipan nopa altepet para quinmanahuise. ");
INSERT INTO nchBl_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Huan quema nochi ichampoyohua Lot quistoyaj ten nopa altepet, nopa ilhuicac ehuani quinilhuijque: ―¡Ximotaloca para amo anmiquise! Amo ximoicantachilica, yon amo ximoquetztiyaca campa tamaya. Ximotaloca hasta campa tepeyo, sinta anquinequij anmomanahuise huan amo anmiquise. ");
INSERT INTO nchBl_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Pero Lot quinilhui: ―¡Amo, tatame! ¡Nelía nimechtajtanía, techtacaquilica se talojtzi! ");
INSERT INTO nchBl_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Nelía antechchihuilijtoque se hueyi favor huan anquimanahuijque nonemilis, pero na amo nihueli nicholos hasta campa tepeixco pampa huejca. Nopa tatzacuiltili huelis techajsiti ipan ojti, huan huajca, quena, timiquise. ");
INSERT INTO nchBl_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Nechca nica onca se pilaltepetzi campa huelis ticholose. ¡Techcahuili tiyase nepa para timomanahuise pampa nelía se altepet cati pisiltzi! ");
INSERT INTO nchBl_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Huajca se ten inijuanti quiijto: ―Cualtitoc, nijchihuas cati titajtantoc. Amo nijtamiltis nopa altepet cati tiquijtohua. ");
INSERT INTO nchBl_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Pero xiyaca, xicholojtehuaca nimantzi pampa amo teno huelis nijchihuas hasta anajsitij nepa. Huan yeca Lot quitocaxti nopa pilaltepetzi Zoar. (Zoar quinequi quiijtos Pisiltzi.) ");
INSERT INTO nchBl_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Huan quema ya tanestoya cuali, Lot ya ajsitoya ipan pilaltepetzi Zoar. ");
INSERT INTO nchBl_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Huan TOTECO quichijqui ma huetzi ten ilhuicac ipan altepeme Sodoma huan Gomorra se tamanti tit ica azufre cati tahuel tata. ");
INSERT INTO nchBl_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Huan nojquiya quintamilti nochi sequinoc ranchos ipan nopa tamayamit ica nochi cati itztoyaj nopona huan ica nochi xihuit. ");
INSERT INTO nchBl_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Pero isihua Lot cati hualayaya iica, ican tachixqui huan itacayo mocuetqui istat huan mocajqui ijcatoc quej se teteyot. ");
INSERT INTO nchBl_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Huan tonili ica ijnaloc, Abraham yajqui campa mocamanalhuijtoya ihuaya TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Huan ten nopona tachixqui ipan altepeme Sodoma huan Gomorra huan ipan nochi nopa ranchos cati eltoya ipan nopa tamayamit. Huan quiitac para tahuel tejcoyaya pocti quej elisquía se horno. ");
INSERT INTO nchBl_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Huajca quej nopa Toteco Dios quintatzacuilti nopa altepeme campa Lot itztoya. Pero Toteco Dios quielnamijqui Abraham huan cati quitajtanijtoya huan quiijcueni Lot ten nopa fiero tatzacuiltilisti. ");
INSERT INTO nchBl_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Teipa Lot majmajqui para mocahuas ipan pilaltepetzi Zoar huan yajqui tepeixco ihuaya iichpocahua huan nochi eyi mocajque nepa ipan se ostot. ");
INSERT INTO nchBl_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Huan se tonali nopa iichpoca cati achtohui ejquet quiilhui nopa teipan ejquet: ―Totata ya huehuentzi, huan amo aqui yon se tacat ipan ni tali cati huelis timotahuicaltise ihuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Yeca ma tiquihuintica totata huan ma tiquixmatica para tiquinpiyase cati ya iconehua para amo polihuis itoca. ");
INSERT INTO nchBl_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Huan ipan nopa tayohua quimacaque inintata xocomecat iayo cati nelcococ huan nopa achtohui ejquet motejqui ihuaya. Pero itata amo quimatqui ten panoc, yon quema motejqui, yon quema mijquejqui. ");
INSERT INTO nchBl_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Huan tonili nopa achtohui ejquet quiilhui nopa teipan ejquet: ―Xiquita, tayohua nimotejqui ihuaya totata, huajca ni tayohua nojquiya tiquihuintise para ta timotecas ihuaya. Huan quej nopa tiome tijpiyase cati ya iconehua. ");
INSERT INTO nchBl_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Huajca ipan nopa tayohua sempa quimacaque inintata xocomecat iayo huan nopa teipan ejquet motejqui ihuaya. Pero Lot amo quimatqui sinta itztoya, yon quema motejqui, yon quema mijquejqui. ");
INSERT INTO nchBl_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Quej nopa nochi ome iichpocahua conecuique ten inintata. ");
INSERT INTO nchBl_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Huan nopa achtohui ejquet quipixqui se icone cati quitocaxti Moab. Quema moscalti Moab, elqui inintata nochi masehualme cati ama inintoca moabitame. ");
INSERT INTO nchBl_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Huan nopa teipan ejquet quipixqui icone cati quitocaxti Ben Ammi. Quema moscalti Ben Ammi yaya elqui inintata nochi masehualme cati ama inintoca amonitame. ");
INSERT INTO nchBl_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Teipa Abraham quisqui ipan Mamre huan yajqui tali Neguev huan mocajqui ipan altepet Gerar cati mocahua tatajco ten Cades huan Shur. ");
INSERT INTO nchBl_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Huan quema itztoya nopona, quiijtohuayaya para isihua Sara eliyaya iicni. Huajca Abimelec, nopa tanahuatijquet ten Gerar, tatitanqui ma quicuitij Sara para teipa quichihuas isihua. ");
INSERT INTO nchBl_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Pero se tayohua Toteco Dios quinojnotzqui Abimelec ipan temicti huan quiilhui: “Abimelec, timiquis pampa nopa sihuat cati tijcuitoc ya motahuicaltijtoc.” ");
INSERT INTO nchBl_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Pero Abimelec ayemo quinechcahuijtoya nopa sihuat huan quinanquili: “Toteco, ¿techmictis masque amo teno nijchijtoc? ");
INSERT INTO nchBl_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Yaya Abraham cati nechilhui para nopa sihuat eliyaya iicni, huan Sara nojquiya quiijto para Abraham eliyaya itaca icni. Huajca nochi nijchijqui ica cuali noyolo. Huan na amo teno cati amo cuali nijchijtoc.” ");
INSERT INTO nchBl_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Huan Toteco quinanquili ipan temicti: “Na cuali nijmati para tijchijqui ica cuali moyolo huan yeca amo nimitzcahuili xijnechcahui para amo xitajtacolchihua ica na. ");
INSERT INTO nchBl_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Huajca ama, xijcuepili isihua nopa tacat pampa yaya se tajtolpanextijquet huan motatajtis huan tajtanis para xiitzto. Pero sinta amo tijcuepilis, ta huan nochi cati itztoque mohuaya anmiquise.” ");
INSERT INTO nchBl_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Huajca tonili, Abimelec mijquejqui cualca huan quinnotzqui itequipanojcahua huan quinpohuili nochi cati quitemictoya. Huan quema quicajque, nelía momajmatijque. ");
INSERT INTO nchBl_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Teipa Abimelec quinotzqui Abraham huan quiilhui: ―¿Taya tijchijtoc? ¿Taya tamanti amo cuali nimitzchihuilijtoc para techhualiquilijtoc na huan nomasehualhua ni hueyi tajtacoli? Techchihuilijtoc se tamanti cati amo quinamiqui techchihuilijtosquía. ");
INSERT INTO nchBl_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","¿Taya timoilhuiyaya quema tijsencajqui ni tamanti? ");
INSERT INTO nchBl_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Huan Abraham quinanquili: ―Na nimoilhui para nica huelis amo aqui cati quitepanita Toteco Dios huan nimoilhui techmictisquíaj pampa quinequisquíaj nosihua. ");
INSERT INTO nchBl_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Huan melahuac masque yaya nosihua, nojquiya noicni pampa yaya iichpoca notata, pero amo icone nonana. Yeca huelqui nimosihuajti ihuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Huan quema Toteco Dios nechnahuati ma nijcajtehua ichaj notata para campa hueli tiyase, niquilhui Sara sinta nechicnelía ma quiijto ipan sesen altepet campa tiajsisquíaj para na niiicni. ");
INSERT INTO nchBl_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Huajca Tanahuatijquet Abimelec quicuepili Abraham isihua Sara. Nojquiya quinsentili borregojme, huacaxme, huan taca tequipanohuani, huan sihua tequipanohuani huan quimacac Abraham, ");
INSERT INTO nchBl_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","huan quiilhui: ―Xijtachiliti nochi notal huan xijtapejpeni campa más mitzpactis para tiitztos. ");
INSERT INTO nchBl_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Huan Tanahuatijquet Abimelec quiilhui Sara: ―Nijmacatoc cati tijtocaxtía ‘moicni’ se mil plata tomi huan quej nopa nelcuali nimitztaxtahuía pampa nimitzpinahualti iniixpa nochi cati itztoque mohuaya. Huan amo aqui huelis camanaltis fiero ten ta por cati panoc. Nochi elis xitahuac. ");
INSERT INTO nchBl_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Huan Toteco Dios quichijtoya para yon se sihuat cati itztoya ichaj Tanahuatijquet Abimelec ma amo conepiya quema Sara itztoya ichaj. Huajca Abraham quitajtani TOTECO para ma quichicahua Abimelec huan isihua, huan nopa sequinoc isihua tequipanojcahua para sempa huelise conepiyase. Huan inijuanti mochicajque ");
INSERT INTO nchBl_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","TOTECO quipixqui hueyi iyolo ica Sara huan quitiochijqui quej mocajtoya ihuaya Abraham para quichihuas. ");
INSERT INTO nchBl_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Huan Sara conecuic huan quimacac Abraham se icone quema ya eliyaya nelhuehuentzi. Huan nopa oquichpil tacatqui ipan nopa metzti cati Toteco Dios quiilhuijtoya. ");
INSERT INTO nchBl_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Huan Abraham quitocaxtali icone, Isaac. ");
INSERT INTO nchBl_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Huan Abraham quitzontequili iyecapa nopa cuetaxti ipan ipiltacayo quema quipiyayaya chicueyi tonati tacajtoya quej Toteco Dios quinahuatijtoya ma quichihua. ");
INSERT INTO nchBl_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Huan Abraham quipiyayaya 100 xihuit quema tacatqui Isaac. (Isaac quinequi quiijtos Huetzquisti.) ");
INSERT INTO nchBl_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Huajca Sara quiijto: “Toteco Dios quichijtoc ma nihuetzca, huan nochi cati quimatise para nijpixtoc se nocone huetzcase nohuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","¿Ajquiya quiilhuijtosquía Abraham para na nijchichitisquía icone? Pero ama nijmacatoc se icone quema ya huehuentzi.” ");
INSERT INTO nchBl_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Huan nopa oquichpil Isaac moscalti huan teipa ipan nopa tonali quema Sara quichichijquixtili, Abraham ilhuichijqui. ");
INSERT INTO nchBl_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Huan Sara quiitac para Ismael cati Abraham quipixqui ica Agar nopa Egipto ejquet, quihuihuiitayaya Isaac. ");
INSERT INTO nchBl_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Huajca Sara yajqui quiilhuito Abraham: “¡Xijquixti nopa tequipanojquet, Agar, ihuaya icone! Amo quinamiqui para icone ma quiselis san se ihuaya nocone Isaac quema timiquis.” ");
INSERT INTO nchBl_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Huan ni tamanti cati Sara quiijto tahuel quiyolcoco Abraham pampa nopa oquichpil Ismael nojquiya eliyaya icone. ");
INSERT INTO nchBl_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Pero Toteco Dios quiilhui: “Amo ximocueso ica nopa oquichpil huan motequipanojca. Xijchihua nochi cati Sara mitztajtanía pampa moteipan ixhuihua hualase ipan Isaac. ");
INSERT INTO nchBl_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Huan nojquiya ica mocone cati nopa sihua tequipanojquet quitacatilti niquinmiyaquilis iteipan ixhuihua huan mochihuase seyoc xinachti masehualme ica nelía miyac imasehualhua pampa yaya nojquiya mocone.” ");
INSERT INTO nchBl_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Huajca tonili nelcualca, Abraham quicuic tacualisti huan se cuetaxti temitoc ica at huan quimamalti Agar huan quiilhui ma quisa ihuaya ioquichpil Ismael. Huan nopa sihuat yajqui huan san nentinemiyaya ipan nopa huactoc tali Beerseba campa amo teno eli pampa amo quimatiyaya canque yas. ");
INSERT INTO nchBl_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Huan quema tanqui nopa at cati eltoya ipan nopa cuetaxti, quicajtejqui nopa oquichpil cuatzinta, ");
INSERT INTO nchBl_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","huan yajqui mosehuito ica huejca pampa amo quinequiyaya quiitas quema miquisquía. Huan quema Agar mosehuijtoya imelac, nopa oquichpil pejqui tahuel choca. ");
INSERT INTO nchBl_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Huan Toteco Dios quicajqui para chocayaya nopa oquichpil, huan iilhuicac ejca Toteco Dios quinojnotzqui Agar ten ilhuicac huan quiilhui: “¿Taya tijpiya Agar? Amo ximajmahui pampa Toteco Dios quicactoc quej choca ne oquichpil nopona campa itztoc. ");
INSERT INTO nchBl_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Xiya, xijtananati nopa oquichpil huan xijmatilana. Amo ximajmahuica. Na nijchihuas ma itzto huan iteipan ixhuihua momiyaquilise huan mochihuase se xinachti masehualme cati nelía miyac imasehualhua.” ");
INSERT INTO nchBl_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Huajca Toteco Dios quej quiixtapo Agar para ma quiita se ameli ica at. Huan yaya yajqui huan quitemitito nopa cuetaxti ica at huan quiamacac Ismael. ");
INSERT INTO nchBl_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Huan Toteco Dios itztoya ihuaya nopa oquichpil huan quipalehui ma moscalti ipan nopa huactoc tali cati itoca Parán. Huan yaya elqui se cuali tapejquet ica cuataminti. Huan teipa inana quisihuajti ica se ichpocat ten tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Nojquiya ipan nopa tonali Tanahuatijquet Abimelec yajqui ihuaya Ficol, nopa tayacanquet ten isoldados para quicamanalhuise Abraham. Huan Tanahuatijquet Abimelec quiilhui Abraham: ―Nochi quiitaj para Toteco Dios mitzpalehuía ipan nochi tamanti cati tijchihua. ");
INSERT INTO nchBl_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Huajca ama xijtestigojquetza Toteco Dios para amo techtehuis, yon na, yon noconehua, yon noteipan ixhuihua. San techchihuilis cati cuali quej nimitzchihuili. Nojquiya xijchihua san se ica ni masehualme ten ni altepet campa ama tiitztoc quej se seyoc tali ejquet. ");
INSERT INTO nchBl_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Huan Abraham quinanquili: ―Cualtitoc, nijtestigojquetza Toteco Dios. ");
INSERT INTO nchBl_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Teipa Abraham quiyolmelajqui Abimelec ten se ameli cati itequipanojcahua Abimelec quiquixtilijtoyaj. ");
INSERT INTO nchBl_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Huan Abimelec quinanquili: ―Amo nijmati ajquiya huelqui quichijqui ya nopa. Amo teno nijmatiyaya ten ni tamanti hasta amantzi pampa amo aqui techyolmelajtoc. ");
INSERT INTO nchBl_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Huajca Abraham quincuic borregojme huan huacaxme huan quimacac Tanahuatijquet Abimelec para quiijtos para temachti amo moixpanose quej quiijto nopa camanali cati quisencahuayaya ihuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Pero teipa Abraham quiniyocaquixti chicome pilsihua borregojtzitzi ten iaxcahua, ");
INSERT INTO nchBl_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","huan Abimelec quitatzintoquili: ―¿Para ten tiquiniyocaquixtijtoc ne chicome pilsihua borregojtzitzi? ");
INSERT INTO nchBl_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Huan Abraham quinanquili: ―Xiquinseli ni chicome pilsihua borregojtzitzi cati nimitzmaca para ma nesi ta tijmati para na nijchijqui nopa ameli. ");
INSERT INTO nchBl_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Huajca yeca quitocaxtijque campa itztoyaj Beerseba. (Beerseba quinequi quiijtos Ameli Campa Quitestigojquetzque Toteco Dios.) Quej nopa quitocaxtijque pampa nopona nopa ome quitestigojquetzque Toteco Dios ten taya quichihuasquíaj. ");
INSERT INTO nchBl_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Huan nopona ipan Beerseba, quema tanque quichihuaj nopa camanali para amo moixpanose, Abimelec ihuaya Ficol cati quinyacanqui isoldados, mocuetque campa itztoyaj ipan nopa tali cati nojquiya inintal nopa filisteos. ");
INSERT INTO nchBl_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Huan ipan Beerseba, Abraham quitojqui se cuahuit cati itoca tamarisco. Huan nopona quihueyichijqui TOTECO, Nopa Dios Cati Nochipa Itztoc. ");
INSERT INTO nchBl_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Huan para miyac xihuit Abraham mocajqui nopona ipan inintal nopa filisteos. ");
INSERT INTO nchBl_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Teipa panoc tonali huan Toteco Dios quiyejyeco Abraham para quiitas sinta nelía quineltoquilía. Huan Toteco Dios quiilhui: ―Abraham. Huan Abraham quinanquili: ―Quena, nica niitztoc. ");
INSERT INTO nchBl_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Huan Toteco Dios quiilhui: ―Xijcui Isaac moiyojtzi cone cati nelía tiquicnelía huan xiya hasta nopa tali cati itoca Moriah. Nopona techmaca quej se tacajcahualisti ipan se tepet cati nimitznextilis. ");
INSERT INTO nchBl_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Huajca tonili nelcualca, Abraham mijquejqui huan quisiyajti iburro, huan quitzontejqui cuahuit para ipan quitatis tacajcahualisti. Huan quistejqui huan yajqui ihuaya icone, Isaac, huan ome itequipanojcahua hasta campa Toteco Dios quiilhui. ");
INSERT INTO nchBl_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Huan hualhuicta, Abraham quihuejcaitac nopa lugar, ");
INSERT INTO nchBl_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","huajca quinilhui itequipanojcahua: ―Ximocahuaca nica ica ni pilburrojtzi. Nooquichpil huan na tiyase achi nepa huan tijhueyichihuatij Toteco Dios huan teipa titacuepilise. ");
INSERT INTO nchBl_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Huan Abraham quicuic nopa cuahuit para nopa tacajcahualisti huan quitali iajcoltipa Isaac. Huan quicuic nopa cuchillo huan tit huan quej nopa nochi ome yajque san sejco. ");
INSERT INTO nchBl_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Teipa Isaac quiilhui Abraham: ―¡Papá! Huan Abraham quinanquili: ―¿Taya tijnequi, nocone? Huan Isaac quiijto: ―Xiquita, tijpiyaj cuahuit huan tit, pero ¿canque eltoc nopa pilborregojtzi para nopa tacajcahualisti? ");
INSERT INTO nchBl_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Huan Abraham quinanquili: ―Nocone, Toteco Dios quichihuas para ma onca se pilborregojtzi para nopa tacajcahualisti. Huan noja nejnentiyajque san sejco. ");
INSERT INTO nchBl_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Huan quema ajsitoj campa Toteco Dios quiilhuijtoya, Abraham quichijchijqui se taixpamit huan quicualtali nopa cuahuit. Teipa quiilpi icone, Isaac, huan quitali ipan taixpamit iixco nopa cuahuit. ");
INSERT INTO nchBl_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Huan Abraham quitananqui nopa cuchillo para quimictis icone. ");
INSERT INTO nchBl_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Huan ipan nopa talojtzi, iilhuicac ejca TOTECO quihualnojnotzqui ten nepa ilhuicac: ―¡Abraham! ¡Abraham! Huan Abraham tananquili: ―Nica niitztoc. ");
INSERT INTO nchBl_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Huan iilhuicac ejca TOTECO quiilhui: ―Amo teno xijchihuili nopa oquichpil. Ya niquita para tiquimacasi huan tijneltoca Toteco Dios huan amo tijtasomatqui para techmacas moiyojtzi cone. ");
INSERT INTO nchBl_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Huan Abraham tachixtejqui huan quiitac se borrego cati tacantoya ica icuacua ipan imacuayo se huitzcuahuit. Huajca yajqui, huan quicuito huan ya nopa quimacac Toteco Dios quej se tacajcahualisti quej ipataca icone. ");
INSERT INTO nchBl_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Teipa Abraham quitocaxtali campa itztoyaj: “Campa TOTECO Temacac Cati Monejqui.” Huan yeca noja moijtohua hasta ama: “Ipan ni itepe TOTECO, yaya temacac cati monequi.” ");
INSERT INTO nchBl_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Huan iilhuicac ejca TOTECO quinotzqui Abraham ica ompa, ");
INSERT INTO nchBl_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","huan quiilhui para TOTECO quej ni quiijtohua: ―Pampa tijchijtoc ni tamanti huan amo tijtasomatqui moiyojtzi cone, nimotestigojquetza noselti ");
INSERT INTO nchBl_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","para nimitztiochihuas tahuel miyac. Nijchihuas para moteipan ixhuihua ma elica pano miyac miles ten masehualme hasta amo aqui huelis quinpohuas. Elise quej inimiyaca nopa sitalime nepa ilhuicac huan quej imiyaca xali cati onca iteno hueyi at. Nojquiya inijuanti nochipa quintanise inincualancaitacahua. ");
INSERT INTO nchBl_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Huan niquintiochihuas nochi masehualme ipan nochi talme ipan taltipacti ica moixhui pampa techneltoquilijtoc. ");
INSERT INTO nchBl_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Huan Abraham mocuetqui hasta campa mocajtoyaj itequipanojcahua, huan teipa san sejco mocuetque Beerseba. Huan Abraham mocajqui nopona para itztos. ");
INSERT INTO nchBl_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Teipa panoc miyac tonali huan ajsico camanali para nopa sihuat Milca nojquiya quimacatoya coneme Nacor, itaca icni Abraham. ");
INSERT INTO nchBl_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Huan iniachtohui cone elqui Uz, huan teipa tacatqui Buz. Teipa tacatqui Kemuel cati teipa elqui itata Aram. ");
INSERT INTO nchBl_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Huan teipa tacatque Quesed, Hazo, Pildas, Jidlaf huan Betuel. ");
INSERT INTO nchBl_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Huan Betuel moscalti huan elqui itata Rebeca. Ya ni nopa chicueyi telpocame cati Milca quimacac Nacor cati eliyaya iicni Abraham. ");
INSERT INTO nchBl_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Huan nojquiya Nacor quinpixqui telpocame ica Reúma, itequipanojca. Ininconehua elqui Teba, Gaham, Tahas huan Maaca. ");
INSERT INTO nchBl_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara itztoya 127 xihuit, ");
INSERT INTO nchBl_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","huan mijqui ipan altepet Quiriat Arba cati nojquiya itoca Hebrón huan mocahua ipan tali Canaán. Huan Abraham mocueso huan quichoquili Sara pampa mijqui. ");
INSERT INTO nchBl_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Teipa quisqui campa huilantoya itacayo Sara huan yajqui campa nopa heteo tacame cati itztoyaj ipan nopa pilaltepetzi huan quinilhui: ");
INSERT INTO nchBl_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","―Masque nise seyoc tali ejquet nica campa amojuanti, technamaquiltica se quentzi amotal campa nijtocas nomijcatzi. ");
INSERT INTO nchBl_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Huan nopa heteo tacame quinanquilijque: ");
INSERT INTO nchBl_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","―¡Nohuampo, techtacaquili! Tojuanti timitzitaj para tise hueyi tacat cati Dios quitapejpenijtoc. Ayecmo más ximocueso. Xijtalpacho momijcatzi ipan nopa ostot cati más cuali tijpiyaj nica. Amo teno timitztasomatilise cati monequi tijtequihuis. ");
INSERT INTO nchBl_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Huajca Abraham moquetzqui huan mohuijtzonqui ica tatepanitacayot iniixpa nopa heteos, ");
INSERT INTO nchBl_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","huan quinilhui: ―Sinta nelía anquiitaj cuali para nijtalpachos nica nomijcatzi, techchihuilica se favor. Xijtajtanica Efrón, icone Zohar, ");
INSERT INTO nchBl_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ma technamaquilti nopa ostot cati itoca Macpela cati eltoc imiltateno. Na nijtaxtahuis quej quinamiqui para nopa tali, huan quej nopa elis noaxca se ostot nica para ipan nitetalpachos. ");
INSERT INTO nchBl_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Huan Efrón nopa heteo itztoya nopona inihuaya. Huan Abraham camanaltiyaya chicahuac para ma quicaquica nochi ihuampoyohua huan nochi cati mosehuijtoyaj nechca icalte nopa altepet. ");
INSERT INTO nchBl_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Huan Efrón quiijto: ―¡Amo, tate! Na san tapic nimitzmaca nopa tali huan nopa ostot cati eltoc nopona. Iniixpa nohuampoyohua nica nimitzmaca para nopona xijtoca momijcatzi. ");
INSERT INTO nchBl_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Pero Abraham mohuijtzonqui ica tatepanitacayot iniixpa nopa tacame cati nopona ehuani. ");
INSERT INTO nchBl_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Huan quiilhui: ―¡Se favor, techtacaquili! Nimitztajtanía xijseli nopa tomi para nopa tali huan teipa nijtalpachos nopona nomijcatzi. ");
INSERT INTO nchBl_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Huajca Efrón quinanquili: ");
INSERT INTO nchBl_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","―Techtacaquili, tate. Nopa tali ipati nahui kilos huan tajco ten plata tomi, pero amo teno monequi. San xijseli huan nopona xijtalpacho momijcatzi. ");
INSERT INTO nchBl_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Huan Abraham quiitac cuali ipati cati Efrón quiijtojtoya iniixpa nopa heteo tacame. Yeca quitamachijqui nopa tomi huan quimacac, huan nochi quimatiyayaj para xitahuac. ");
INSERT INTO nchBl_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Huan quej ni elqui iaxca Abraham nopa tali cati quiyahualojtoya nopa ostot Macpela cati eltoya imelac campa quisa tonati ipan tali Mamre ihuaya nochi cuame cati eltoya nopona. ");
INSERT INTO nchBl_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Nochi elqui iaxca Abraham iniixpa nopa heteos huan nochi cati mosehuijtoyaj nechca icalte nopa altepet. ");
INSERT INTO nchBl_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Huan Abraham quitalpacho Sara ipan nopa ostot Macpela ipan nopa mili Mamre nechca altepet Hebrón cati eltoc ipan tali Canaán. ");
INSERT INTO nchBl_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Huajca nopa heteo tacame quimacaque Abraham se amatajcuiloli para nopa tali cati quinamaquiltijque para ipan quitalpacho Sara. ");
INSERT INTO nchBl_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Huan Abraham ya eliyaya nelhuehuentzi, huan TOTECO quitiochijtoya ica nochi tamanti. ");
INSERT INTO nchBl_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Huan se tonali quinotzqui itayacanca tequipanojca cati quimocuitahuiyaya nochi cati iaxca huan quiilhui: ―Xijtali momax itzinta nometztomahuiya, ");
INSERT INTO nchBl_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","huan ica ya nopa tijtestigojquetzas TOTECO, nopa Dios cati quinahuatía ilhuicacti huan taltipacti para amo tijcahuas nocone Isaac ma mocuili se sihuat ten ni tali Canaán campa tiitztoque. ");
INSERT INTO nchBl_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Monequi xiya ipan notal campa nihualajqui huan xijtapejpeni se isihua campa noteixmatcahua. ");
INSERT INTO nchBl_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Huan itequipanojca quinanquili: ―Pero ¿taya nijchihuas sinta nopa sihuat amo quinequis hualas nohuaya? ¿Tijnequi ma nijhuicas mocone ipan nopa tali campa tiquisqui? ");
INSERT INTO nchBl_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Huan Abraham quiijto: ―¡Amo! Amo xijhuica nocone nepa. ");
INSERT INTO nchBl_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","TOTECO Dios mitzpalehuis, yaya cati tanahuatía ipan ilhuicacti huan cati nechquixti ichaj notata huan noteixmatcahua. Yaya cati nohuaya mocajtoc para quinmacas ni tali noteipan ixhuihua, quititanis iilhuicac ejca ma mitzyacana para tijhualicas ten nepa se ichpocat para nocone. ");
INSERT INTO nchBl_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Huan sinta nopa ichpocat amo quinequis hualas mohuaya, huajca ta timocahuas timajcajtoc ten ni camanali, pero amo xijhuica nocone nepa. ");
INSERT INTO nchBl_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Huajca itequipanojca Abraham quitali imax itzinta iquescuayo huan quitestigojquetzqui Toteco Dios para temachti quichihuasquía cati quinequiyaya. ");
INSERT INTO nchBl_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Teipa quitapejpeni miyac tamanti cati más cuali cati iteco quipiyayaya para temajmacati. Huan quincuic majtacti camellos cati iaxca Abraham huan yajqui altepet Nacor ipan tali Mesopotamia. ");
INSERT INTO nchBl_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Quema itequipanojca ajsitinemiyaya nechca nopa altepet, ya pejtoya tzintayohuiya. Huan ipan nopa hora miyac sihuame huan ichpocame hualayayaj atacuiquij. Huajca quinsiyajcuili nopa camellos nechca se ameli, ");
INSERT INTO nchBl_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","huan pejqui motatajtía ica TOTECO. Quiilhui: “TOTECO Dios, ta tiiTeco noteco, Abraham, xijchihua para ama ma quisa cuali notequi nica pampa tiquicnelía noteco Abraham. ");
INSERT INTO nchBl_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Nimocahuas nica nechca ni ameli campa ichpocame hualahuij atacuiquij. ");
INSERT INTO nchBl_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Techcahuili para nopa ichpocat cati niquilhuis ma quitemohui ico para ma niatis, ma technanquili: ‘Xiati, huan nojquiya niquinamacas mocamellos’. Huan quej nopa nijmatis para ya nopa cati tijtapejpenijtoc para isihua Isaac. Huan quej nopa nijmatis para tijtasojtatoc noteco, Abraham.” ");
INSERT INTO nchBl_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Huan ayemo tamiyaya motatajtía quema quiitac se ichpocat quiquechpanojtihualayaya ico. Huan nopa ichpocat itoca eliyaya Rebeca huan yaya elqui se iixhui Nacor cati elqui iicni Abraham. Nacor huan isihua, Milca, quipixque se telpoca tacat cati itoca Betuel cati elqui itata nopa ichpocat. ");
INSERT INTO nchBl_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Huan Rebeca eliyaya nelyejyectzi huan amo quema itztoya ihuaya se tacat. Huan Rebeca temotoya hasta campa eltoc ameli quitemitito ico huan ya ixtejcoyaya hasta talpani ica at. ");
INSERT INTO nchBl_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Huan nopa tequipanojquet motalo quiajsito huan quiilhui: ―Techcahuili ma niqui se quentzi at ipan moco. ");
INSERT INTO nchBl_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Huan nopa ichpocat quinanquili: ―Xiati, tate. Huan nimantzi quitemohui ico ten iajcolpa huan quiamacac. ");
INSERT INTO nchBl_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Huan quema nopa tequipanojquet tanqui ati, Rebeca quiijto: ―Nojquiya nijquixtis at para mocamellos hasta tami atise. ");
INSERT INTO nchBl_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Huan nimantzi atejqui campa atij tapiyalme. Huan motalo miyac huelta huan temoc campa ameli atacuiti hasta quintamiamacac nochi nopa camellos. ");
INSERT INTO nchBl_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Huan nopa tequipanojquet san quitachiliyaya huan amo teno quiijtohuayaya. San moilhuiyaya quenicatza TOTECO quipalehuijtoya ipan iojhui. ");
INSERT INTO nchBl_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Huan quema nopa camellos tanque atij, nopa tacat quiquixti se anillo ten oro cati quipixqui chicuase gramos ietica huan quimacac para quitalis ipan iyacatzol. Nojquiya quimacac ome maquechcosti ten oro cati quipixqui ietica chicuase gramos, ");
INSERT INTO nchBl_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","huan quiilhui: ―Techilhui ajquiya motata huan sinta onca ipan mochaj campa nomasehualhua huan na huelis timocahuase. ");
INSERT INTO nchBl_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Huan yaya tananquili: ―Niiichpoca Betuel, yaya cati elqui icone Milca huan Nacor. ");
INSERT INTO nchBl_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ipan tochaj onca campa timocahuas huan nojquiya onca miyac sacat huan tacualisti para mocamellos. ");
INSERT INTO nchBl_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Huajca nopa tequipanojquet motancuaquetzqui huan quihueyichijqui TOTECO, ");
INSERT INTO nchBl_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","huan quiijto: “Nimitzhueyichihua, TOTECO, ta cati tiiTeco noteco, Abraham. Ta titemachti huan nelía tijtasojtatoc noteco huan techyacantoc ipan ojti hasta nica campa ininchaj iteixmatcahua.” ");
INSERT INTO nchBl_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Huan Rebeca motalojtiyajqui hasta ichaj inana huan quiilhuito nochi cati quipanotoya. ");
INSERT INTO nchBl_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Huan Rebeca quipiyayaya se itaca icni cati itoca Labán. Huan Labán motalo hasta campa ameli quitemoco nopa tacat, ");
INSERT INTO nchBl_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","pampa quiitztoya nopa anillo, huan nopa maquechcosti cati iicni quihuicayaya ipan imax huan quicactoya cati panoc. Huan Labán monechcahui campa itequipanojca Abraham cati noja itztoya ihuaya icamellos nechca ameli, ");
INSERT INTO nchBl_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","huan quiilhui: ―Xihuala nochaj, ta cati TOTECO mitztiochijtoc. ¿Para ten tiitztoc nica huejcatzi? Nijcualtalijtoc nochaj para ta huan nojquiya onca campa mocahuase mocamellos. ");
INSERT INTO nchBl_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Huajca itequipanojca Abraham yajqui ihuaya. Huan nopona Labán quintatemohuili nopa camellos huan quintamacac. Teipa quihualicac at huan quinmacac nopa tequipanojquet huan nopa masehualme cati ihuaya hualayayaj para ma moicxipajpacaca. ");
INSERT INTO nchBl_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Huan quema quintalilijque tacualisti para tacuase, itequipanojca Abraham quiijto: ―Na amo nitacuas hasta niquijtos cati monequi niquijtos. Huan Labán quiijto: ―Huajca techilhui. ");
INSERT INTO nchBl_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Huan nopa tequipanojquet quiijto: ―Na niitequipanojca Abraham. ");
INSERT INTO nchBl_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","TOTECO miyac quitiochijtoc noteco huan quiricojchijtoc. Quimacatoc tahuel miyac borregojme, huacaxme, camellos huan burrojme. Quimacatoc miyac taca tequipanohuani huan sihua tequipanohuani, huan iyoca quimacatoc tahuel miyac oro huan plata. ");
INSERT INTO nchBl_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Nojquiya Sara, isihua Abraham, quimacac se icone quema eliyaya neltenantzi. Huan noteco quicahuilijtehuas icone nochi cati quipiya. ");
INSERT INTO nchBl_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Pero ya techchihualti ma nijtestigojquetza Toteco Dios para amo nijcahuas para icone ma mocuili se sihuat cati ehua ipan nopa tali Canaán campa tiitztoque. ");
INSERT INTO nchBl_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Techilhui ma nihuala nica campa iteixmatcahua itata huan ma nijtemo ten amojuanti se sihuat para icone. ");
INSERT INTO nchBl_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Huan na nijtajtani noteco taya monequi nijchihuas sinta nopa sihuat amo quinequis hualas nohuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Huan ya technanquili: ‘Na ninentoc ipan iojhui TOTECO huan nijmati yaya quititanis iilhuicac ejca huan mitzyacanas para nochi quisas cuali ipan moojhui. Huan temachti tijpantis se sihuat para nocone nepa campa noteixmatcahua huan iteixmatcahua notata.’ Quej nopa techilhui. ");
INSERT INTO nchBl_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Pero techilhui sinta noteixmatcahua amo quinequise mitzmacase nopa ichpocat, nopona tamis ni camanali cati tijtestigojquetztoc Toteco Dios para tijchihuas. ");
INSERT INTO nchBl_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Huajca ama quema niajsico campa ameli, niquilhui TOTECO Dios, yaya cati iTeco noteco, Abraham: ‘Sinta mopaquilis ta, xijchihua nochi ma quisa cuali ipan ni noojhui. ");
INSERT INTO nchBl_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ama niitztoc nechca ni ameli. Huajca xijchihua para quema hualas se ichpocat atacuiqui huan niquilhuis: Se favor, techcahuili niquis se quentzi at ipan moco, ");
INSERT INTO nchBl_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","para ma nechnanquili: Xiati, huan nojquiya nijquixtis at para mocamellos. Huan quej nopa nijmatis para yaya nopa ichpocat cati tijtapejpenijtoc para icone noteco.’ Quej nopa niquilhui TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Huan ayemo nitamiyaya nimotatajtía quema niquitac Rebeca quiquechpanojtihualayaya ico. Huan Rebeca temoc campa ameli para atacuis huan niquilhui: ‘Se favor, techcahuili niquis se quentzi at ipan moco.’ ");
INSERT INTO nchBl_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Huan Rebeca nimantzi quitemohui ico para ma niati huan nechilhui: ‘Xiati huan nojquiya nijquixtis at para mocamellos.’ ");
INSERT INTO nchBl_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Huan teipa nijtatzintoquili: ‘¿Ajquiya tiiichpoca?’ Huan ya nechnanquili para yaya iichpoca Betuel cati elqui icone Nacor huan Milca. Huajca nijtalili se anillo ipan iyacatzol huan se maquechcosti ipan imax. ");
INSERT INTO nchBl_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Huan nimotancuaquetzqui huan nijhueyichijqui huan nijpaquilismacac TOTECO Dios, yaya cati iTeco noteco Abraham pampa nechyacanqui ipan ojti cati xitahuac para nijpantis para icone se ichpocat cati itztoc se iteixmatca noteco. ");
INSERT INTO nchBl_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Huajca ama techilhuica sinta anquichihuase cati cuali huan xitahuac ihuaya noteco huan anquicahuilise Rebeca ma yas nohuaya. Huan sinta amo, techilhuica nojquiya para nijmatis taya monequis nijchihuas.” ");
INSERT INTO nchBl_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Huajca Labán huan Betuel quinanquilijque: ―Nochi ya ni huala ten TOTECO huan tiquitaj para yaya ipaquilis. Huajca amo huelis tojuanti timitzilhuise quena o amo. ");
INSERT INTO nchBl_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Xiquita, nica itztoc Rebeca. Huelis tijhuicas para ma eli isihua icone moteco quej TOTECO quitalijtoc. ");
INSERT INTO nchBl_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Huajca quema itequipanojca Abraham quicajqui ya nopa, motancuaquetzqui iixpa TOTECO huan mohuijtzonqui hasta talchi para quitascamatis. ");
INSERT INTO nchBl_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Teipa quiquixti miyac tamanti ten oro, plata huan miyac yoyomit huan quimacac Rebeca. Nojquiya itaca icni huan inana quintamajmacac. ");
INSERT INTO nchBl_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Huan quema tanqui, ya ihuaya nopa tacame cati ihuaya yahuiyayaj tacuajque huan taique huan nopona mocajque nopa yohuali. Huan tonili nopa tequipanojquet quiijto: ―Techcahuilica para nimantzi ma nitacuepili hasta ichaj noteco. ");
INSERT INTO nchBl_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Pero itaca icni huan inana Rebeca quiilhuijque: ―Noja ma mocahua ni ichpocat majtacti tonali tohuaya huan teipa yas mohuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Pero nopa tequipanojquet quinilhui: ―Amo techtzacuilica más pampa TOTECO quichijtoc ma quisa cuali noojhui, yeca techcahuilica nimantzi ma sempa niya ichaj noteco. ");
INSERT INTO nchBl_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Huajca inijuanti quinanquilijque: ―Tijnotzase nopa ichpocat huan tiquitase taya quiijtos. ");
INSERT INTO nchBl_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Huajca quinotzque Rebeca huan quitatzintoquilijque: ―¿Tijnequi tiyas ihuaya ni tacat amantzi? Huan Rebeca tananquili: ―Quena, niyas. ");
INSERT INTO nchBl_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Huajca quicahuilijque Rebeca ma yahui ihuaya itequipanojca Abraham huan inijuanti cati hualajtoyaj ihuaya. Huan nopa sihua tequipanojquet cati nochipa quimocuitahuijtoya Rebeca nojquiya yajqui ihuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Huan iteixmatcahua quitiochijque Rebeca quej ni: “Toicni, ¡xieli ininana tahuel miyac masehualme! ¡Moteipan ixhuihua nochipa ma tatanica, ica inincualancaitacahua!” ");
INSERT INTO nchBl_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Huajca Rebeca ihuaya itequipanojcahua tejcoque ipan camellos huan quitoquilijque itequipanojca Abraham. Huan quej nopa ne tequipanojquet quicuitejqui Rebeca. ");
INSERT INTO nchBl_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Teipa ipan tali Canaán Isaac cati mochantijtoya ipan Neguev, hualayaya ten nopa ameli cati itoca Iamel Toteco Cati Itztoc Huan Techita. ");
INSERT INTO nchBl_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Huan se tonali ica tiotac Isaac quisqui ichaj para nejnemis huan motatajtis huan tachixqui huan quinitac sequij camellos cati monechcahuiyayaj. ");
INSERT INTO nchBl_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Huan Rebeca nojquiya huejca tachixqui huan quema quiitac Isaac, temoc ten nopa camello, ");
INSERT INTO nchBl_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","huan quiilhui nopa tequipanojquet: ―¿Ajquiya ne tacat cati quistinemi ipan ne mili huan toixmelac huala? Huan nopa tequipanojquet tananquili: ―Yaya noteco. Huajca Rebeca moixtzajqui ica itzontzajcayo. ");
INSERT INTO nchBl_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Huan quema ajsitoj, nopa tequipanojquet quipohuili Isaac nochi cati quichijtoya. ");
INSERT INTO nchBl_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Huan teipa Isaac quihuicac Rebeca ipan ichaj ten yoyomit cati achtohui elqui iaxca Sara huan quichijqui isihua. Huan Isaac quiicneli Rebeca huan quej nopa moyoltali pampa inana mijqui. ");
INSERT INTO nchBl_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Huan Abraham mocuili seyoc isihua cati itoca Cetura. ");
INSERT INTO nchBl_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Huan iconehua cati quinpixqui ihuaya elque Zimram, Jocsán, Medán, Madián, Isbac huan Súa. ");
INSERT INTO nchBl_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Huan teipa Jocsán quinpixqui itelpocahua cati inintoca Seba huan Dedán. Huan iteipan ixhuihua Dedán elque nopa asureos, letuseos huan leumeos. ");
INSERT INTO nchBl_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Huan iconehua Madián elque Efa, Efer, Hanoc, Abida huan Elda. Nochi ya ni elque iteipan ixhuihua Cetura. ");
INSERT INTO nchBl_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Huan Isaac quiseli nochi cati Abraham quipiyayaya quema mijqui. ");
INSERT INTO nchBl_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Pero quema ayemo miquiyaya, quintamajmacac iconehua cati tacajtoyaj ica isihua tequipanojcahua huan quintitanqui neca quentzi más para campa quisa tonati huan quej nopa quiniyocatali ica icone Isaac. ");
INSERT INTO nchBl_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Huan Abraham itztoya 175 xihuit. ");
INSERT INTO nchBl_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Huan mijqui san pampa eliyaya nelhuehuentzi huan yajqui mosejcotilito inihuaya ihuejcapan tatahua. ");
INSERT INTO nchBl_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Huan Isaac huan Ismael, itelpocahua Abraham, quitalpachojque ipan nopa ostot cati itoca Macpela cati mocahua más campa quisa tonati ten altepet Mamre. Nopa ostot eltoya ipan ital se heteo tacat itoca Efrón cati elqui icone Zohar. ");
INSERT INTO nchBl_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Huan Abraham quincohuilijtoya nopa heteos nopa tali para ipan quitocas isihua, Sara. ");
INSERT INTO nchBl_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Teipa quema Abraham mijqui, Toteco Dios miyac quitiochijqui Isaac. Huan Isaac mocahuayaya para itztos nechca nopa ameli cati itoca Iamel Yaya Cati Itztoc Huan Cati Techita. ");
INSERT INTO nchBl_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Nica eltoc inintoca iconehua Ismael cati elqui icone Abraham ihuaya Agar, isihua tequipanojca Sara cati hualajqui ten tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ya ni inintoca quej tacajtiyajque: Nebaiot, cati elqui achtohui ejquet, teipa Cedar, Adbeel, Mibsam, ");
INSERT INTO nchBl_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Massa, ");
INSERT INTO nchBl_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar, Tema, Jetur, Nafis huan Cedema. ");
INSERT INTO nchBl_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Nochi ya ni inintoca nopa 12 iconehua Ismael. Sesen mochijqui tayacanquet ipan se hueyi familia ten iixhuihua. Huan nica quipiya campa mochantalijtiyajqui huan nopa pilaltepetzitzi cati mochijqui quihuicayaya sesen hueyi familia itoca. ");
INSERT INTO nchBl_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Huan Ismael quipiyayaya 137 xihuit quema mijqui huan mosejcotilito inihuaya ihuejcapan tatahua. ");
INSERT INTO nchBl_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Teipa iteipan ixhuihua Ismael mosemanque campa hueli ipan nopa tali ten Havila hasta Shur nechca iteno tali Egipto ipan ojti para Asiria. Nopona iteipan ixhuihua Ismael mocajque huan nochipa motehuiyayaj. ");
INSERT INTO nchBl_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Amantzi nimechpohuilis cati panoc ica Isaac, icone Abraham. ");
INSERT INTO nchBl_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaac quipiyayaya 40 xihuit quema mosihuajti ihuaya Rebeca cati eliyaya iichpoca Betuel huan iicni Labán. Labán huan Betuel eliyayaj nopa arameos cati itztoyaj ipan tali Aram. ");
INSERT INTO nchBl_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Huan Rebeca amo hueliyaya conepiya huan Isaac quitajtani TOTECO por ya. Huan TOTECO quicajqui cati quitajtani huan Rebeca conecuic. ");
INSERT INTO nchBl_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Pero quinpixqui cuateme cati motehuiyayaj iijtico huan moilhui: “Sinta quej ni elis nonemilis, amo huelis niquijyohuis.” Huajca yajqui quitajtanito TOTECO para ten quej nopa ipantiyaya, ");
INSERT INTO nchBl_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","huan TOTECO quinanquili: “Ome coneme itztoque ipan moijti. Huan inijuanti huan ininteipan ixhuihua mochihuase ome xinach masehualme. Huan sesen quinpiyas miyac imasehualhua huan itztose ipan ome talme. Ya pejtoque motehuíaj quema ayemo tacatij, huan para nochipa ininteipan ixhuihua nojquiya motehuise. Se elis más tetic que ne seyoc. Huan nopa teipan ejquet quipiyas más tanahuatili que nopa achtohui ejquet.” ");
INSERT INTO nchBl_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Huan quema ajsic nopa tonali para Rebeca conepiyas, nelía quinpixqui cuateme. ");
INSERT INTO nchBl_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Nopa achtohui ejquet nesiyaya chichiltic huan quipixqui miyac itzoyo ipan nochi itacayo. Huan quitocaxtijque Esaú. (Esaú quinequi quiijtos Cati Quipiya Miyac Itzoyo.) ");
INSERT INTO nchBl_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Huan nimantzi tacatqui ne seyoc cati quiitzquilijtoya icotzta iachtohui cone icni ica se imax. Yeca quitocaxtijque Jacob. (Jacob quinequi quiijtos Cati Taitzquía o Cati Tacajcayahua.) Huan Isaac quipiyayaya 60 xihuit quema Rebeca conepixqui. ");
INSERT INTO nchBl_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Huan nopa oquichpilme moscaltijque. Huan Esaú elqui se tacat cati quipactía nejnemi cuatita huan elqui se cuali tapejquet. Pero Jacob eliyaya se tacat cati quipixqui iyolo huan quipactía mocahuas ichaj. ");
INSERT INTO nchBl_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Huan Isaac más quiicneli Esaú pampa quipactiyaya quicuas cati quinmictiyaya quema tapehuayaya, pero Rebeca quiicneli Jacob. ");
INSERT INTO nchBl_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Huan se tonali quema Jacob quichihuayaya tacualisti, Esaú mocuetqui ten cuatita nelsiyajtoc. ");
INSERT INTO nchBl_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Huan quiilhui iicni: ―Techchihuili se favor, techmaca se quentzi nopa tacuali chichiltic cati tijpiya nopona pampa ya niapismiqui. (Yeca Esaú nojquiya quitocaxtiyayaj Edom cati quinequi quiijtos Chichiltic.) ");
INSERT INTO nchBl_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Huan Jacob quiilhui: ―Achtohui techmaca motequiticayo pampa tiachtohui ejquet. ");
INSERT INTO nchBl_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Huajca Esaú quiilhui: ―Tiquita ya niapismiqui huan nopa tanahuatili cati nijpiya pampa niachtohui ejquet amo techpalehuis quema nimiquis. ");
INSERT INTO nchBl_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Huajca Jacob quiilhui: ―Xijtestigojquetza Toteco Dios amantzi para noaxca. Huan Esaú quitestigojquetzqui Toteco huan quej nopa quipanoltili Jacob nopa tanahuatili cati eliyaya iaxca pampa achtohui ejquet. ");
INSERT INTO nchBl_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Huajca Jacob quimacac Esaú pantzi huan se tacualisti ten lentejas. Huan quema Esaú tanqui tacua, moquetzqui huan yajqui, yon amo quinejnehuili sinta quipolojtoya itanahuatil ten achtohui ejquet pampa amo quiitayaya para miyac ipati. ");
INSERT INTO nchBl_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ipan nopa tonali oncayaya se hueyi mayanti pampa amo oncayaya tacualisti ipan nochi nopa tali. Quej ni nojquiya panotoya achtohuiya quema Abraham noja itztoya. Huan yeca Isaac yajqui altepet Gerar campa tanahuatiyaya Abimelec, inintanahuatijca filisteos. ");
INSERT INTO nchBl_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Nopona TOTECO monexti ica Isaac huan quiilhui: “Amo xiya tali Egipto, ximocahua campa na nimitzilhuis ");
INSERT INTO nchBl_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","nica ipan ni tali. Huan na niitztos mohuaya huan nimitztiochihuas. Huan se tonali nimitzmacas ta ihuaya moteipan ixhuihua nochi ni talme. Quej nopa nijtamichihuas cati nijtencahuili motata Abraham para temachti nijchihuas. ");
INSERT INTO nchBl_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Huan nijchihuas ma elica nelmiyaqui moteipan ixhuihua quej sitalime ipan ilhuicac. Huan niquinmacas nochi ni talme. Nojquiya niquintiochihuas nochi masehualme ipan nochi talme ipan taltipacti por moixhui. ");
INSERT INTO nchBl_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Nochi ya ni nijchihuas pampa Abraham techneltoquili huan quichijqui cati niquilhui. Quitoquili nochi cati niquilhui para monequi quichihuas. Quitoquili notanahuatil, notamachtil huan nochi noleyes.” ");
INSERT INTO nchBl_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Huajca Isaac mocajqui ipan altepet Gerar. ");
INSERT INTO nchBl_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Huan quema nopa masehualme cati nopona ehuani quitatzintoquilijque quenicatza quiitayaya Rebeca, Isaac majmajqui quiijtos eliyaya isihua huan istacatic huan quiijto para eliyaya iicni. Isaac moilhui nopa tacame cati nopona ehuani quimictisquíaj huan mocuilisquíaj Rebeca pampa eliyaya nelyejyectzi. ");
INSERT INTO nchBl_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Huan quema Isaac mocajtoya nopona miyac tonali, se tonali Abimelec tachixtoya ipan iventana huan quiitac para Isaac quinajnahuayaya isihua Rebeca. ");
INSERT INTO nchBl_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Huajca tatitanqui ma quinotzatij huan quiilhui: ―Yaya mosihua, ¿amo que? Huajca, ¿para ten tiquijto para eliyaya moicni? Huan Isaac tananquili: ―Na nimoilhui nohueli nechmictisquíaj por ya. ");
INSERT INTO nchBl_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Huajca Abimelec quiilhui: ―¿Para ten techcajcayajtoc ica ni tamanti? San se quentzi huan se cati ehua nica hueltosquía motectosquía ihuaya mosihua huan topani huetztosquía se tatzacuiltili. ");
INSERT INTO nchBl_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Huajca Tanahuatijquet Abimelec quinilhui nochi imasehualhua: ―Sinta acajya quicuatotonía ni tacat o isihua, quipantis miquilisti. ");
INSERT INTO nchBl_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Huan ipan nopa xihuit nopona ipan nopa tali, Isaac tojqui huan quisentili miyac pixquisti hasta 100 hueltas imiyaca pampa TOTECO quitiochijqui. ");
INSERT INTO nchBl_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Huan Isaac moricojchijqui. Huan nochi cati iaxca más momiyaquili hasta nelnelía mochijqui se hueyi tacat ica miyac chicahualisti. ");
INSERT INTO nchBl_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Quinpixqui tahuel miyac borregojme, chivojme, huacaxme huan tequipanohuani. Huajca nopa filisteos pejque quicualancaitaj. ");
INSERT INTO nchBl_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Huan quitemitijque ica tali nochi iamel Isaac. Ni amelme quixajtoyaj itequipanojcahua Abraham, itata Isaac, huejcajquiya quema noja itztoyaj ipan nopa tali. ");
INSERT INTO nchBl_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Huajca teipa Tanahuatijquet Abimelec quiilhui Isaac: ―Xiya sejcoyoc pampa ica nochi motequipanojcahua huan motapiyalhua nelía anmiyaqui huan anitztoque más antetique que tojuanti. ");
INSERT INTO nchBl_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Huajca Isaac huan nochi cati itztoyaj ihuaya yajque. Huan quiquetzque ininchajchaj ten yoyomit ipan nopa tamayamit tatajco nopa tepeme nechca altepet Gerar. Huan nopona mocajqui. ");
INSERT INTO nchBl_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Huan Isaac sempa quitapo nochi nopa ameli cati itata quixajtoya cati nopa filisteos quitzactoyaj quema mijqui. Huan sempa quitocaxti sesen ameli quej itata quintocaxtalijtoya achtohuiya. ");
INSERT INTO nchBl_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Huan se tonali itequipanojcahua Isaac quichihuayayaj se ameli ipan nopa tamayamit huan quipantijque campa meyayaya se yejyectzi at. ");
INSERT INTO nchBl_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Pero altepet Gerar ehuani cati quinmocuitahuiyayaj borregojme pejque monajnanquilíaj inihuaya cati quinmocuitahuiyayaj iborregojhua Isaac. Quinilhuiyayaj para nopa at eliyaya iniaxca. Yeca Isaac quitocaxti nopa ameli Esek pampa ica monajnanquilijque. (Esek quinequi quiijtos Tanajnanquilisti.) ");
INSERT INTO nchBl_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Huan teipa itequipanojcahua Isaac quitapojque seyoc ameli, pero sempa ica mocualanijque. Huan nopa ameli quitocaxti Sitna. (Sitna quinequi quiijtos Cualancaitali.) ");
INSERT INTO nchBl_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Huajca Isaac quincajtejqui huan moiyocaquixti huejca. Nopona quixajqui seyoc ameli, pero amo aqui yajqui nepa para quitehuis. Huajca quitocaxti Rehobot. (Rehobot quinequi quiijtos Hueyi Tali.) Quej nopa quitocaxti pampa Isaac quiijto para ama TOTECO quitiochijtoc huan quimacatoc se hueyi tali cati quiaxili para nochi itapiyalhua ma moscaltica. ");
INSERT INTO nchBl_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Huan Isaac yajqui campa itoca Beerseba, ");
INSERT INTO nchBl_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","huan nopa tayohua TOTECO monexti ica ya huan quiilhui: “Na niDios cati niiTeco motata, Abraham. Amo ximajmahui, na niitztoc mohuaya. Nimitztiochihuas huan niquinmiyaquilis moteipan ixhuihua, pampa niquelnamiqui cati nijtencahuili notequipanojca Abraham.” ");
INSERT INTO nchBl_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Huajca Isaac quisencajqui se taixpamit nopona huan quihueyichijqui TOTECO. Huan nopona quiquetzqui ichaj ten yoyomit, huan itequipanojcahua quixajque se ameli. ");
INSERT INTO nchBl_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Se tonali Abimelec hualajqui ten altepet Gerar para mocamanalhuis ihuaya Isaac. Ihuaya hualayaya ihuampo Ahusat cati quitalnamictiyaya huan Ficol cati quinnahuatiyaya isoldados. ");
INSERT INTO nchBl_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Huan Isaac quintatzintoquili: ―¿Para ten anhualajque antechitaquij? Antechquixtijque ipan amotal pampa antechcualancaitayayaj. ");
INSERT INTO nchBl_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Huan quiilhuijque: ―Tiquitztoque para TOTECO itztoc mohuaya, huan timoilhuíaj cuali ma tijchihuaca se camanali. Nopa camanali elis ya ni: ");
INSERT INTO nchBl_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Xijtestigojquetza para amo quema techcocos pampa tojuanti amo quema timitzcocojtoque. Nochipa timitzchihuilijtoque cati cuali huan quema monejqui timoiyocaquixtis ten tojuanti, timitzmajcajque ica cuali quej titohuampo. Huan ama xiquita quenicatza TOTECO mitztiochijtoc. ");
INSERT INTO nchBl_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Huajca Isaac quinchihuili se hueyi tacualisti, huan san sejco inijuanti tacuajque huan taique. ");
INSERT INTO nchBl_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Huan tonili ica ijnaloc, mijquejque huan quitestigojquetzque Toteco para amo quema moixpanosquíaj se ica seyoc. Teipa Isaac quinnahuatijtejqui ica cuali. ");
INSERT INTO nchBl_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ipan nopa tonal, itequipanojcahua Isaac quiyolmelahuacoj para quipantijtoyaj at campa taxahuayayaj. ");
INSERT INTO nchBl_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Huan Isaac quitocaxti nopa ameli Seba. (Seba quinequi quiijtos Campa Tatestigojquetzqui.) Huan yeca nopa altepet hasta ama itoca Beerseba. (Beerseba quinequi quiijtos Ameli campa Tatestigojquetzque.) ");
INSERT INTO nchBl_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Huan quema Esaú quipiyayaya 40 xihuit mosihuajti ihuaya Judit cati eliyaya iichpoca Beeri se heteo tacat. Huan nojquiya Esaú mosihuajti ihuaya Basemat iichpoca seyoc heteo tacat cati itoca Elón. ");
INSERT INTO nchBl_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Huan ni ome sihuame quinmacaque Isaac huan Rebeca miyac tequipacholi. ");
INSERT INTO nchBl_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Huan Isaac eliyaya nelhuehuentzi huan ayecmo tachiyayaya. Huan se tonali quinotzqui Esaú, icone cati achtohui ejquet huan quiilhui: ―¡Nocone! Huan Esaú quinanquili: ―Techilhui taya tijnequi, papá. ");
INSERT INTO nchBl_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Huan Isaac quiijto: ―Ya tiquita para ninelhuehuentzi huan ten hueli tonali hueli nimiquis. ");
INSERT INTO nchBl_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Yeca nijnequi xiya cuatita ica mocuahuitol huan cuataminti para xijmictiti se masat. ");
INSERT INTO nchBl_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Teipa xijsencahua se tacualisti ajhuiyac quej na nechpactía huan xijhualica para nijcuas. Huan huajca nimitzmacas notatiochihual iixpa Toteco quema ayemo nimiqui. ");
INSERT INTO nchBl_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Pero Rebeca quitacaquilijtoya cati Isaac quiilhuiyaya Esaú. Huan teipa quema Esaú yajqui cuatita para quiitzquiti se masat para itata, ");
INSERT INTO nchBl_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeca quinotzqui Jacob, iteipan cone huan quiilhui: ―Nijcajqui para motata mocamanalhuiyaya ihuaya moicni Esaú huan quiilhuiyaya, ");
INSERT INTO nchBl_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","para ma quiitzquiti se masat huan ma quisencahuili se tacualisti cati ajhuiyac para quicuas. Quiijto para teipa quimacas itatiochihual iixpa TOTECO quema ayemo miqui. ");
INSERT INTO nchBl_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Huajca nocone, xijtacaquili cuali cati nimitzilhuis: ");
INSERT INTO nchBl_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Xiya campa itztoque totapiyalhua huan techhualiquili ome oquich chivojme cati más cuali. Huan nijsencahuilis motata se tacualisti ajhuiyac quej ya quipactía. ");
INSERT INTO nchBl_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Huan teipa tijhuiquilis ma quicua, huan quej nopa mitztiochihuas iixpa Toteco quema ayemo miqui. ");
INSERT INTO nchBl_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Pero Jacob quiilhui inana: ―Noicni quipiya miyac itzoyo ipan nochi itacayo, huan na, amo. ");
INSERT INTO nchBl_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Sinta notata techitzquis, quimatis amo niEsaú. Huan moilhuis para san ica nimahuiltía, huajca nijchihuas ma nechtelchihuas huan amo nechtiochihuas. ");
INSERT INTO nchBl_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Pero inana quinanquili: ―Nocone, na nopani ma huetzi nopa tatelchihuali. Ta xijchihua cati nimitzilhuía huan techhualiquili nopa oquich chivojme. ");
INSERT INTO nchBl_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Huajca Jacob quincuito nopa oquich chivojme huan quinhuicac campa inana. Huan inana quisencajqui se tacualisti ajhuiyac quej Isaac quipactiyaya. ");
INSERT INTO nchBl_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Huan Rebeca quiquixti nopa yoyomit cati más cuali cati Esaú, iachtohui cone, quiajoctoya ipan ichaj. Huan nopa yoyomit quitalili Jacob cati elqui iteipan cone. ");
INSERT INTO nchBl_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Huan quinquixtili inincuetaxo nopa chivojme ica nochi iniijhuiyo huan ica quipijqui Jacob ipan imax huan iquechta campa amo quipiyayaya itzoyo. ");
INSERT INTO nchBl_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Teipa quimacac nopa tacualisti huan nopa pantzi cati quisencajtoya. ");
INSERT INTO nchBl_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Huajca Jacob calajqui campa itztoya itata huan quiilhui: ―¡Papá! Huan Isaac quinanquili: ―Nica niitztoc. ¿Ajquiya ta, nocone? ");
INSERT INTO nchBl_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Huan Jacob quiilhui: ―Na niEsaú, moachtohui cone. Ya nijchijtoc cati techilhui. Ximijquehua, ximosehui huan xijcua ni masat cati nijmictito huan techmaca motatiochihual. ");
INSERT INTO nchBl_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Huajca Isaac quitatzintoquili: ―¿Quenicatza huelqui tijpanti nelnimantzi, nocone? Huan Jacob quinanquili: ―TOTECO, moDios, nechpalehui para nijpanti. ");
INSERT INTO nchBl_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Pero Isaac quiilhui: ―Ximonechcahui huan techcahuili ma nimitzijitzqui sinta nelía tinocone Esaú. ");
INSERT INTO nchBl_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Huan Jacob monechcahui para ma quiitzqui itata. Huan Isaac quiijto: “Nijcaqui motoscac quej Jacob, pero momax eltoc quej tiEsaú.” ");
INSERT INTO nchBl_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Huan Isaac amo quimatqui sinta eliyaya Jacob pampa imax quipiyayaya miyac itzoyo quej iicni, Esaú. Huajca quema quimacasquía itatiochihual iixpa Toteco, ");
INSERT INTO nchBl_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","sempa quitatzintoquili: ―¿Nelía ta tinocone Esaú? Huan Jacob quiilhui: ―Quena, na niEsaú. ");
INSERT INTO nchBl_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Huajca itata quiilhui: ―Techtequili, nocone, para nijcuas cati tijmictito, huan teipa nimitzmacas notatiochihual. Huajca Jacob quitequili para ma tacua itata huan nojquiya quihualiquili xocomecat iayo. Huan Isaac tacuajqui, ");
INSERT INTO nchBl_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","huan teipa quiilhui: ―Ximonechcahui, nocone huan techtzoponi. ");
INSERT INTO nchBl_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Huan quema Jacob monechcahui para quitzoponis, Isaac quiijnejqui iyoyo huan moilhui huelis nelía iachtohui cone. Huajca quitiochijqui ica ni camanali: “Ajhuiyac cati niquijnecui ten nocone. Mijyotía quej cuatitamit cati TOTECO quitiochijtoc. ");
INSERT INTO nchBl_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Toteco Dios ma mitzmaca at ten ilhuicac, para tijpiyas pixquisti cati más cuali ipan motal. Ma mitzmaca miyac trigo, huan miyac xocomecat iayo. ");
INSERT INTO nchBl_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Miyac masehualme ma mitztequipanoca. Ma motancuaquetzaca moixpa, masehualme ten miyac talme. Xiquinnahuati moicnihua. ¡Huan ma motancuaquetzaca moixpa nochi cati monana quintacatilti! Cati mitztelchihuase elise tatelchihualme. Huan cati mitztiochihuase elise tatiochihualme.” ");
INSERT INTO nchBl_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Teipa Isaac tanqui quitiochihua Jacob huan quema Jacob quisayaya ten campa itata, Esaú mocuetqui ten tapehuato. ");
INSERT INTO nchBl_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Huan Esaú nojquiya quisencajqui se tacualisti ajhuiyac huan quihuiquili itata. Huan quiilhui: ―Ximoquetza, papá. Xijcua ni cati nijpehuato huan techmaca motatiochihual iixpa Toteco. ");
INSERT INTO nchBl_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Huajca Isaac quitatzintoquili: ―¿Ajquiya ta? Huan ya tananquili: ―Na niEsaú, moachtohui ejca. ");
INSERT INTO nchBl_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Huan Isaac amo quimatiyaya taya quiijtos. Huan ica itoscac huihuipicayaya, quiijto: ―Huajca, ¿ajquiya nechhualiquili nopa tacualisti cati quicuito ipan cuatitamit? Na nijcuajqui quema ayemo tiajsiyaya huan nijmacac nopa tatiochihualisti, huan ya nelía elis tatiochihuali. ");
INSERT INTO nchBl_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Quema Esaú quicajqui cati itata quiijto, tzajtzic tahuel chicahuac ica miyac tequipacholi huan teipa quiijto: ―¡Techtiochihua nojquiya, papá! ");
INSERT INTO nchBl_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Pero Isaac quinanquili: ―Ya hualajqui moicni, huan nechcajcayajqui. Quihuicac nopa tatiochihuali cati eliyaya para ta. ");
INSERT INTO nchBl_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Huan Esaú quiijto: ―¡Yeca quitocaxtijque Jacob! (Jacob quinequi quiijtos Tacajcayajquet.) ¡Ica ni mochihua ome huelta nechcajcayajtoc! Achtohui nechquixtili notanahuatil cati noaxca eltoya pampa niachtohui ejquet. Huan ama nechquixtilijtoc notatiochihual. ¿Amo ticajoctoc seyoc tatiochihuali para na? ");
INSERT INTO nchBl_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Huajca Isaac quinanquili: ―Xiquita, na nijmacatoc Jacob tanahuatili para mitznahuatis. Niquijtojtoc para iteixmatcahua elise itequipanojcahua. Niquilhuijtoc para quipiyas miyac trigo huan miyac xocomecat iayo. ¿Taya mocahuas para noja huelis nimitzmacas, nocone? ");
INSERT INTO nchBl_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Huan Esaú noja quiilhui: ―¿San hueli titemaca san se tatiochihuali, papá? ¡Techtiochihua nojquiya! Huan Esaú sempa tahuejchijqui huan chocac. ");
INSERT INTO nchBl_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Huajca Isaac quiilhui: “Tiitztos huejca ipan tali cati amo hueli taixhualtía, huan campa amo huetzis at. ");
INSERT INTO nchBl_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Huan monequis timomanahuis ica momacheta. Tielis tiitequipanojca moicni, pero quema ayecmo huelis tiquijyohuis más, timoquixtis imaco.” ");
INSERT INTO nchBl_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Huajca Esaú quicualancaitac Jacob pampa quiichtequilijtoya itatiochihual huan pejqui moilhuía: “Ya nechca para miquis notata. Quema ya panotos nopa tequipacholi, nijmictis noicni, Jacob.” ");
INSERT INTO nchBl_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Huan Rebeca quimatqui cati Esaú moilhuiyaya quichihuas, huajca Rebeca tatitanqui ma quinotzatij Jacob. Huan quema ajsico, Rebeca quiilhui: ―Xiquita, ica nopa cati tijchihuili moicni, Esaú, yaya ama quinequi mitzmictis. ");
INSERT INTO nchBl_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Yeca, nocone, techtacaquili; xicholo nimantzi hasta tali Harán hasta ichaj noicni, Labán. ");
INSERT INTO nchBl_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ximocahua nopona se ome xihuit hasta quema ayecmo cualantos moicni. ");
INSERT INTO nchBl_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Huan quema ya quielcajtos cati tijchihuilijtoc, nitatitanis ma mitzyolmelahuaca para sempa xihuala. ¡Amo nijnequi niquinpolos ome noconehua ipan san se tonal! ");
INSERT INTO nchBl_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Huan teipa Rebeca quiilhui Isaac: ―Ya nisiyajtoc por ni heteo ichpocame cati Esaú mocuilijtoc. Sinta Jacob mocuilis se ichpocat cati ehua nica ipan tali Canaán, más cuali ma nimiqui. ");
INSERT INTO nchBl_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Huajca Isaac quinotzqui Jacob, huan quitiochijqui huan quiilhui: “Amo ximosihuajti ica se sihuat ten ni tali Canaán. ");
INSERT INTO nchBl_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Xiya tali Aram campa ichaj mohueyi tata Betuel huan ximosihuajti ihuaya se iichpoca motío Labán. ");
INSERT INTO nchBl_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Toteco Cati Quipiya Nochi Chicahualisti ma mitztiochihua huan ma mitzmaca miyac moixhuihua para ipan ta ma quisaca nelmiyaqui masehualme cati itztose ipan miyac talme. ");
INSERT INTO nchBl_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Toteco ma mitzmaca ta huan moteipan ixhuihua nopa tatiochihuali cati quitencahuili Abraham. Ma amechaxcati ni tali campa ama tiitztoque quej tiseyoc tali ehuani pampa ya ni nopa tali cati quitajtolcahuili Abraham para quinmacas iteipan ixhuihua.” ");
INSERT INTO nchBl_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Huajca quej nopa Isaac quititanqui Jacob ipan tali Aram. Huan Jacob ajsito ichaj Labán cati eliyaya icone Betuel cati ehua tali Aram. Huan Labán eliyaya iicni Rebeca cati eliyaya inana Jacob huan Esaú. ");
INSERT INTO nchBl_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esaú quimatqui para Isaac quimacac itatiochihual Jacob huan quititanqui ipan tali Aram para ma mosihuajtiti nepa. Huan quinahuatijtoya ma amo mosihuajti ica se sihuat cati ehua tali Canaán. ");
INSERT INTO nchBl_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Nojquiya quimatqui para Jacob quistoya para tali Aram quej itata huan inana quiilhuijtoyaj. ");
INSERT INTO nchBl_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Huajca Esaú quiitac para itata amo quipactiyayaj sihuame cati ehuani tali Canaán campa inijuanti itztoyaj. ");
INSERT INTO nchBl_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Yeca yajqui quiitato itío, Ismael, cati nojquiya icone Abraham. Nopona mosihuajti ihuaya se iichpoca cati itoca eliyaya Mahalat huan cati eliyaya iicni Nevaiot. Huajca Mahalat mochijqui isihua Esaú inihuaya nopa sequinoc sihuame cananeos cati ya mocuilijtoya. ");
INSERT INTO nchBl_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Huan Jacob quistoya altepet Beerseba huan yajqui ipan nopa ojti cati yahui altepet Harán. ");
INSERT INTO nchBl_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Huan ajsic ipan se lugar huan nopona panoc nopa tayohua pampa ya temotoya tonati. Huan quicuic se tet huan quitequihui para itzonteto. Huan motejqui huan cochqui. ");
INSERT INTO nchBl_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Huan quipixqui se temicti huan quiitayaya se escalera cati ijcatoya talchi huan ajsiyaya hasta ilhuicac. Huan ilhuicac ehuani ten TOTECO cati ipan temoyayaj huan tejcoyayaj. ");
INSERT INTO nchBl_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Nojquiya quiitayaya para TOTECO Dios itztoya huejcapa huan quiilhuiyaya: “Na niininTeco mohueyi tata Abraham huan motata Isaac. Ta huan moteipan ixhuihua niquinmacas ni tali campa amantzi tiitztoc. ");
INSERT INTO nchBl_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Moteipan ixhuihua elise nelmiyaqui quej imiyaca taltepocti cati amo aqui huelis quinpohuas. Huan mosemanase campa hueli. Yase hasta sur, huan norte, huan hasta campa quisa tonati huan hasta campa oncalaqui. Huan niquintiochihuas nochi familias ipan taltipacti ica ta huan moixhui. ");
INSERT INTO nchBl_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Na niitztoc mohuaya. Nimitzmocuitahuis campa hueli campa tiyas huan nijchihuas xitacuepilis ipan ni tali. Amo nimitztahuelcahuas. Nijchihuas nochi cati mohuaya nimocajtoc nijchihuas.” ");
INSERT INTO nchBl_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Huan quema Jacob isac, moilhui: “Nelía TOTECO itztoc ipan nica huan amo nijmatiyaya.” ");
INSERT INTO nchBl_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Huan Jacob majmajqui miyac huan moilhui: “¡Nica neltatzejtzeloltic! ¡Nica eltoc ichaj Toteco! ¡Ni icalte ilhuicac!” ");
INSERT INTO nchBl_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Huan tonili Jacob mijquejqui cualca huan quicuic nopa tet cati quitequihuijtoya para itzonteto. Huan quiquetzqui quej se tanextili para nopona campa Toteco quicamanalhui. Huan nopa tet quitequili aceite para quiiyocatalis para Toteco. ");
INSERT INTO nchBl_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Huan nechca nopona eltoya se altepet cati itoca Taahuili, pero Jacob quipatili itoca huan quitalili Betel. (Betel quinequi quiijtos Ichaj Toteco.) ");
INSERT INTO nchBl_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Huan nopona Jacob quitestigojquetzqui Toteco Dios taya quichihuasquía huan quiijto: “Toteco, sinta ta nohuaya tiitztos huan techmocuitahuis ipan ni noojhui cati nijchihua, huan sinta techtamacas huan techmacas cati nimoquentis, huajca na nimitztequipanos. ");
INSERT INTO nchBl_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Huan sinta amo nimococos huan nitacuepilis ica cuali ipan ichaj notata, huajca san ta, TOTECO, nijmatis para noTeco. ");
INSERT INTO nchBl_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Huan nica campa nijtalijtoc ni tet, elis mochaj, Toteco, campa nimitztencahuilis tacajcahualisti. Huan nochipa nimitzmactilis se diezmo ten nochi cati techmacas.” ");
INSERT INTO nchBl_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jacob sempa quiitzqui iojhui huan yajqui ipan se tali nechca campa quisa tonati. ");
INSERT INTO nchBl_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Huan nopona ipan potrero quiitac se ameli huan nechca mosentiliyayaj borregojme ipan eyi tatilimit pampa nopa tapiyalme momatque atij ipan nopa ameli. Huan quitzactoyaj nopa ameli ica se tet cati nelhueyi. ");
INSERT INTO nchBl_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Huan nopa tamocuitahuiani momajtoyaj mochiyaj hasta quema mosentilijtose nochi nopa borregojme cati sesen inijuanti iaxcahua huan san sejco quiijcueniyayaj nopa hueyi tet. Teipa quinamacayayaj ininborregojhua huan teipa san sejco sempa quitzacuayayaj ica nopa hueyi tet. ");
INSERT INTO nchBl_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Huajca Jacob quintatzintoquili nopa tamocuitahuiani: ―¿Canque amochaj, nohuampoyohua? Huan inijuanti tananquilijque: ―Tihualahuij altepet Harán. ");
INSERT INTO nchBl_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Huajca quinilhui: ―¿Anquiixmatij Labán iixhui Nacor? Huan quiilhuijque: ―Quena, tiquixmatij. ");
INSERT INTO nchBl_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Huan Jacob quinilhui: ―¿San cuali itztoc? Huan nopa tamocuitahuiani quiijtojque: ―Quena, itztoc cuali. Xiquita, ne huala iichpoca, Raquel, ihuaya iborregojhua. ");
INSERT INTO nchBl_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Huajca Jacob quiijto: ―Noja cualca para anquintzacuase borregojme. ¿Para ten amo anquinamacaj huan anquinhuicaj sempa ma tacuatij? ");
INSERT INTO nchBl_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Pero nopa tamocuitahuiani quiijtojque: ―Amo hueli tijchihuaj. Monequi tijchiyase ma hualaca nochi borregojme huan tamocuitahuiani para sentic tiquijcuenise ni tet cati ica quitzacuaj ni ameli para tiquinamacase toborregojhua. ");
INSERT INTO nchBl_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Huan quema Jacob noja camanaltiyaya inihuaya, ajsico Raquel ihuaya iborregojhua itata pampa eltoya itequi para quinmocuitahuis. ");
INSERT INTO nchBl_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Huan nimantzi quema Jacob quiitac Raquel, iichpoca itío Labán, ica iborregojhua, yajqui huan iseltitzi quiijcueni nopa tet cati ica quitzactoyaj nopa ameli. Huan quinamacac iborregojhua. ");
INSERT INTO nchBl_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Teipa quitajpalo huan quitzoponi huan pejqui choca chicahuac. ");
INSERT INTO nchBl_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Huan Jacob quipohuili para yaya eliyaya icone Rebeca cati iicni Labán. Huajca Raquel motalojtiyajqui huan quipohuilito itata. ");
INSERT INTO nchBl_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Huan quema Labán quicajqui cati Raquel quipohuili, para Jacob eliyaya icone isihua icni, motalojtejqui para quiseliti. Huan quinajnahuajqui, huan quitzoponi huan quihuicac ichaj. Teipa Jacob quipohuili para ten hualajqui. ");
INSERT INTO nchBl_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Huan Labán quiilhui: “Melahuac ta huan na san se toeso.” Huan Jacob mocajqui ihuaya Labán se metzti. ");
INSERT INTO nchBl_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Teipa Labán quiilhui: ―Amo hueli techtequipanos san tapic san pampa nimoteixmatca. Techilhui quesqui tijnequi ma nimitztaxtahui. ");
INSERT INTO nchBl_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Huan Labán quinpiyayaya ome iichpocahua. Nopa achtohui ejquet itoca Lea huan nopa teipan ejquet, Raquel. ");
INSERT INTO nchBl_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Huan iixteyolhua Lea amo quipiyayaya miyac tetili, pero Raquel eliyaya senquisa yejyectzi. ");
INSERT INTO nchBl_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Huan Jacob quiixtocayaya Raquel huan huajca quinanquili: ―Nimitztequipanos chicome xihuit sinta techmacas Raquel para elis nosihua. ");
INSERT INTO nchBl_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Huajca Labán tananquili: ―Cualtitoc, más cuali nimitzmacas ta, huan amo se cati amo niquixmati. Huajca ximocahua nohuaya huan nimitzmacas. ");
INSERT INTO nchBl_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Huan quej nopa Jacob tequitic chicome xihuit para Raquel, pero ya amo quimatqui sinta nelmiyac tonali pampa tahuel quiicneliyaya. ");
INSERT INTO nchBl_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Huan quema tanqui nopa chicome xihuit, Jacob quiilhui Labán: ―Techmaca nosihua para ma nimosihuajti ihuaya pampa ya tanqui nopa tonali cati ica nimocajqui mohuaya para nitequitis. ");
INSERT INTO nchBl_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Huajca Labán quinnotzqui nochi cati itztoyaj nopona para ma hualaca ipan nopa ilhuit ten nenamictili ");
INSERT INTO nchBl_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Pero ica tayohua Labán quicuic Lea huan quihuiquili Jacob. Quej nopa quimacac Lea para elis isihua huan Jacob cochqui ihuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Nojquiya Labán quimacac Lea se sihua tequipanojquet cati itoca Zilpa para ma quipalehui. ");
INSERT INTO nchBl_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Huan quema tanesqui, Jacob quiitac para cochtoya ihuaya Lea. Huajca yajqui quiilhuito Labán: ―¿Taya techchihuilijtoc? ¿Amo nimitztequipano para Raquel? Huajca ¿para ten techcajcayajtoc? ");
INSERT INTO nchBl_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Huan Labán quiilhui: ―Nica amo timomajtoque para motahuicaltis nopa teipan ejquet sinta ayemo motahuicaltía nopa achtohui ejquet. ");
INSERT INTO nchBl_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Xicaxiti se samano ihuaya Lea, huan teipa nojquiya timitzmacase Raquel sinta timotemacas titequitis nohuaya seyoc chicome xihuit. ");
INSERT INTO nchBl_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Huan Jacob motemacac. Huan quema tanqui se samano itahuicaltilis ica Lea, Labán quimactili Raquel para ma quichihua isihua. ");
INSERT INTO nchBl_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labán nojquiya quimacac Raquel se sihua tequipanojquet cati itoca Bilha para ma quipalehui. ");
INSERT INTO nchBl_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Huan Jacob mosejcotili ihuaya Raquel huan más quiicneli que Lea, masque monequiyaya quitequipanos Labán seyoc chicome xihuit por ya. ");
INSERT INTO nchBl_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Huan quema TOTECO quiitac para Jacob amo quiicneliyaya Lea, quichijqui ma conepiya, pero Raquel quichijqui ma amo conepiya. ");
INSERT INTO nchBl_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Huan Lea conecuic huan quipixqui se icone cati quitocaxti Rubén. (Rubén quinequi quiijtos Quiitac Notequipachol.) Quej nopa quitocaxti pampa quiijto: “TOTECO quiitac quenicatza tahuel nimocuesohuayaya huan nechmacatoc se conet, yeca ama nohuehue technequis.” ");
INSERT INTO nchBl_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Teipa Lea quipixqui seyoc icone cati quitocaxti Simeón. (Simeón quinequi quiijtos Se Cati Tacaqui.) Quej nopa quitocaxti pampa Lea quiijto: “TOTECO quicactoc para amo nechicnelía huan yeca nechmacac seyoc nocone.” ");
INSERT INTO nchBl_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Huan seyoc huelta Lea quipixqui seyoc icone huan quitocaxti Leví. (Leví quinequi quiijtos Motatzquilijtoc.) Quej nopa quitocaxti pampa quiijto: “Ama nohuehue itztos más nohuaya pampa ya nijmacatoc eyi oquichpilme.” ");
INSERT INTO nchBl_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Huan Lea quipixqui seyoc icone cati quitocaxti Judá. (Judá quinequi quiijtos Nijpaquilismacas.) Quej nopa quitocaxti pampa quiijto: “Ni huelta, quena, nijpaquilismacas TOTECO.” Teipa ayecmo conepixqui. ");
INSERT INTO nchBl_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Quema Raquel quiitac para amo hueliyaya quimaca coneme Jacob, pejqui quicualancaita iachtohui icni, Lea, huan quiilhui ihuehue: ―Techmaca coneme pampa sinta amo, nimiquis. ");
INSERT INTO nchBl_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Pero Jacob cualanqui ihuaya huan quiilhui: ―¡Amo na niDios! Yaya TOTECO cati amo mitzcahuilía xiconepiya. ");
INSERT INTO nchBl_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Huajca Raquel quiilhui ihuehue: ―Huajca xijcui notequipanojca Bilha huan ximocahua ihuaya. Huan quema yaya quinpiyas coneme, elis quej na noconehua. ");
INSERT INTO nchBl_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Quej ni Raquel quimacac Jacob itequipanojca, Bilha, para ma quinpiya coneme ihuaya. Huan Jacob mosejcotili ihuaya Bilha, ");
INSERT INTO nchBl_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","huan ya quimacac Jacob se icone. ");
INSERT INTO nchBl_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Huajca Raquel quiijto: “Toteco quichijtoc cati xitahuac para na pampa quicajqui cati nijtajtani huan techmacac se nocone. Yeca ni oquichpil itoca elis Dan.” (Dan quinequi quiijtos Yaya Quichijtoc Cati Xitahuac Para Na.) ");
INSERT INTO nchBl_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Teipa Bilha, itequipanojca Raquel, quimacac Jacob seyoc icone. ");
INSERT INTO nchBl_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Huajca Raquel quiijto: “Nimotehuijtoc ihuaya noachtohui icni huan nijtantoc. Yeca ni oquichpil itoca elis Neftalí.” (Neftalí quinequi quiijtos Notatehuijcayo.) ");
INSERT INTO nchBl_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Quema Lea quiitac para ayecmo hueliyaya conepiya, quimacac Jacob itequipanojca, Zilpa para ma conepiya ihuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Huan quema Zilpa quimacac se icone Jacob, ");
INSERT INTO nchBl_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea quiijto: “¡Se suerte! Yeca nopa oquichpil itoca elis Gad.” (Gad quinequi quiijtos Suerte.) ");
INSERT INTO nchBl_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Teipa Zilpa quimacac Jacob seyoc icone, ");
INSERT INTO nchBl_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","huan Lea quiijto: “¡Paquilisti! Ama sihuame quiijtose para nipaqui. Yeca nopa oquichpil itoca elis Aser.” (Aser quinequi quiijtos Paquilisti.) ");
INSERT INTO nchBl_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Se tonali Rubén yajqui mila quema eliyaya trigo pixquisti huan nopona quipanti se tamanti xihui pajti huan quihuiquili inana, Lea. Nopa xihui pajti itoca eliyaya mandrágoras huan nochi quiijtohuayayaj para nopa xihuit quichihua se tacat más ma quiicneli isihua. Huan quema Raquel quiitac nopa cuali xihui pajti, quiilhui Lea: ―Techchihuili se favor, techmaca se ome ten nopa xihui pajti cati mocone quihualicac. ");
INSERT INTO nchBl_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Pero Lea quiilhui: ―¿Timoilhuía se quentzi tamanti para techcuilijtoc nohuehue, huan nojquiya tijnequi techcuilis ni cuali xihui pajti cati nocone techhualiquili? Huan Raquel quiijto: ―Sinta techmacas se quentzi ixihui pajyo mocone, nijcahuilis Jacob ma cochi mohuaya ni tayohua. ");
INSERT INTO nchBl_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Huajca ica tiotac Lea quinamiquito Jacob quema hualayaya ten imil huan quiilhui: ―Ama ticochis nohuaya pampa nimitzpatatoc ica se cuali xihui pajti cati nocone techhualiquili. Huajca nopa tayohua Jacob cochqui ihuaya Lea. ");
INSERT INTO nchBl_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Huan Toteco Dios quitacaquili cati Lea quitajtani, huan conecuic huan quimacac Jacob imacuilpa cone. ");
INSERT INTO nchBl_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Huajca Lea quiijto: “Ni oquichpil itoca elis Isacar.” (Isacar quinequi quiijtos Se Taxtahuili.) “Quej nopa nijtocaxtis pampa Toteco Dios techmacatoc notaxtahuil pampa nijmacac nohuehue notequipanojca.” ");
INSERT INTO nchBl_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Teipa Lea conecuic huan quimacac Jacob ichicuasempa cone, ");
INSERT INTO nchBl_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","huan quiijto: “Dios techmacatoc se cuali nemacti. Ama nohuehue techtepanitas pampa ya nijmacatoc chicuaseme oquichpilme. Yeca ni oquichpil itoca elis Zabulón.” (Zabulón quinequi quiijtos Tatepanitacayot.) ");
INSERT INTO nchBl_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Teipa Lea quipixqui se sihuapil cati quitocaxti Dina. ");
INSERT INTO nchBl_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Pero Toteco Dios nojquiya quielnamijqui Raquel. Quicajqui cati quitajtaniyaya huan quicahuili ma conepiya. ");
INSERT INTO nchBl_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Huan Raquel conecuic huan quitacatilti se oquichpil huan quiijto: “Toteco Dios techquixtilijtoc nopa pinahualisti para amo hueli niconepiya. ");
INSERT INTO nchBl_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ma TOTECO nechcahuili nijpiyas seyoc.” Yeca quitocaxti José. (José quinequi quiijtos Seyoc.) ");
INSERT INTO nchBl_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Teipa quema Raquel quitacatiltijtoya José, Jacob quiilhui Labán: ―Techcahuili ma nitacuepili ipan notal ");
INSERT INTO nchBl_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","inihuaya noconehua huan nosihuajhua pampa nimitztequipanojtoc por inijuanti. Huajca ama nechcahuili ma niya. Cuali tijmati quenicatza nimitztequipanojtoc. ");
INSERT INTO nchBl_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Pero Labán quinanquili: ―Sinta tinohuampo, ximocahua nohuaya pampa se tajtolpanextijquet cati quimati tachiya para TOTECO techilhui yaya nechtiochijtoc por ta. ");
INSERT INTO nchBl_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","San techilhui quesqui tijnequi tijtanis huan nimitztaxtahuis. ");
INSERT INTO nchBl_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Huajca Jacob quiilhui: ―Cuali tijmati quenicatza nimitztequipanojtoc huan quenicatza niquinmocuitahuijtoc motapiyalhua. ");
INSERT INTO nchBl_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Nelquentzi tijpiyayaya quema ayemo nihualayaya huan ama tijpiya tahuel miyac. TOTECO mitztiochijtoc campa hueli niitztoya, pero ¿hasta quema nipehuas nitequitis para nochampoyohua? ");
INSERT INTO nchBl_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Huan Labán quiilhui: ―¿Quesqui tijnequi ma nimitztaxtahui? Huan Jacob quinanquili: ―Amo teno techtaxtahui. Noja niquinmocuitahuis moborregojhua sinta tijselis cati nimitzilhuis. ");
INSERT INTO nchBl_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ma tiyaca campa moborregojhua huan ama niquiniyocaquixtis nochi chivojme huan borregojme cati cuicuiltique huan pijpintojtique. Nochi chivojme cati amo senquisa chocoxtique huan nochi borregojme cati amo senquisa chipahuaque elise noaxcahua. Ya nopa elis notaxtahuil. ");
INSERT INTO nchBl_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Quej nopa mosta huicta, huelis tijtachiliqui cati nijtantoc huan nimantzi tijmatis sinta nijchihua cati cuali mohuaya o amo. Pampa sinta ipan notapiyalhua oncas chivojme cati chocoxtique huan borregojme cati chipahuaque, huajca tijmatis ya nopa nimitzichtequilijtoc. ");
INSERT INTO nchBl_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Huan Labán quiijto: ―Cualtitoc, quej nopa ma eli. ");
INSERT INTO nchBl_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Huan ipan nopa tonal Labán quiniyocaquixti nochi pilborregojtzitzi cati cuicuiltique, huan nochi chivojme cati pintojtique o cati quipixtoya quentzi chipahuac, huan quinmacac iconehua Jacob para ma quinmocuitahuica. ");
INSERT INTO nchBl_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Teipa iconehua quinhuicaque huejca quej eyi tonati ten ojti ihuejcaca ten ichaj Jacob. Huan Jacob noja mocajqui huan quinmocuitahui iborregojhua Labán. ");
INSERT INTO nchBl_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Huan Jacob quitzontejqui cuamacuayot xoxohuic ten nopa cuame álamo, almendro huan castaño, huan iyocatzitzi quixixinqui para ma nesi cuicuiltic, chipahuac huan chocoxtic. ");
INSERT INTO nchBl_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","Teipa nopa pitzajcuahuit quitali campa atiyayaj nopa tapiyalme pampa nopona momatque momamaj. Huan ya nopa quichihuayaya para ininconehua ma tacatica cuicuiltique, majmanchadojtique huan pijpintojtique. ");
INSERT INTO nchBl_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Huan Jacob quiniyocaquixtiyaya nopa sihua borregojme cati senquisa chipahuaque cati eliyaya iaxcahua Labán huan amo quincahuiliyaya ioquich borregojhua Labán cati chipahuaque ma quinnechcahuica para ma quinconemacaca. San quincahuiliyaya ma quinmamaltica oquich borregojme cati yayahuique cati ya iaxcahua para ma quinpiyaca ininconehua cati cuicuiltique huan yeca ininconehua elise iaxcahua ya. Quej nopa Jacob quisencajqui cati ya itapiyalhua iyoca ten itapiyalhua Labán. ");
INSERT INTO nchBl_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Nojquiya mojmosta quema nopa tapiyalme cati tomahuaque huan tetique momamayayaj, Jacob quitaliyaya nopa pitzajcuahuit cati iyocatzitzi quixixintoya campa atiyayaj para ma quiitaca. ");
INSERT INTO nchBl_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Pero quema hualayayaj tapiyalme cati cocoxquetique, amo quitaliyaya nopa pitzajcuahuit. Yeca nopa tapiyalme cati más cocoxquetique mocajque para Labán huan cati más tomahuaque para Jacob. ");
INSERT INTO nchBl_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Quej nopa Jacob moricojchijqui huan quinpixqui tahuel miyac borregojme. Nojquiya quinpixqui miyac taca tequipanohuani huan sihua tequipanohuani huan tahuel miyac camellos huan burrojme. ");
INSERT INTO nchBl_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Pero Jacob quimatqui para iconehua Labán quiijtojtinemiyayaj para yaya quicuitoya nochi cati iaxca inintata, Labán huan ica ya nopa Jacob moricojchijtoya. ");
INSERT INTO nchBl_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Nojquiya quiitac para Labán ayecmo quitachiliyaya cuali quej achtohuiya. ");
INSERT INTO nchBl_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Huajca TOTECO quiilhui Jacob: “Xitacuepili ipan ital motatahua campa itztoque moteixmatcahua huan na niyas mohuaya.” ");
INSERT INTO nchBl_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Huajca Jacob tatitanqui ma quinnotzatij Raquel huan Lea para ma hualaca ipan nopa potrero campa yaya itztoya ihuaya iborregojhua. ");
INSERT INTO nchBl_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Huan Jacob quinilhui: ―Niquita para amotata ayecmo techita san se quej achtohuiya, pero noTeco Dios cati notata quitequipanohua nochipa nohuaya nemi. ");
INSERT INTO nchBl_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Cuali anquimatij nijtequipanojtoc amotata hasta campa nihueltoc, ");
INSERT INTO nchBl_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","huan ya nechcajcayajtoc huan nechpatilijtoc notaxtahuil majtacti hueltas. Pero masque ya nopa, Toteco Dios amo quicahuilijtoc ma nechcoco. ");
INSERT INTO nchBl_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Quema Labán quiijto techtaxtahuis ica tapiyalme cati manchadojtique, nochi tacatiyayaj manchadojtique. Huan quema quiijto nechtaxtahuis ica cati cuicuiltique, nochi tacatiyayaj cuicuiltique. ");
INSERT INTO nchBl_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Quej nopa Toteco Dios quicuili itapiyalhua para nechmacas. ");
INSERT INTO nchBl_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Se tonali quema nopa tapiyalme momamayayaj, nijpixqui se temicti. Huan ipan temicti niquitac para nochi oquich chivojme cati tamamayayaj elque cuicuiltique, manchadojtique huan pijpintojtique. ");
INSERT INTO nchBl_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ipan nopa temicti iilhuicac ejca Toteco Dios nechnojnotzqui ica notoca huan nijnanquili: ‘Nica niitztoc.’ ");
INSERT INTO nchBl_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Huajca yaya techilhui: ‘Xijtachili cuali huan tiquitas para nochi oquichme cati quinconemacaj nopa sihua borregojme itztoque cuicuiltique, manchadojtique huan pijpintojtique. Quej nopa eltoc pampa niquitztoc nochi cati amo xitahuac mitzchihuilijtoc Labán. ");
INSERT INTO nchBl_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Na nimoTeco cati nimonexti ipan Betel campa ta tijquetzqui nopa tet quej se tanextilijcayot, huan techtajtolcahuili cati techchihuilisquía. ¡Xiisihui huan xiquisa ten nica huan xitacuepili ipan nopa tali campa titacatqui!’ Quej nopa Toteco nechilhui.” ");
INSERT INTO nchBl_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Huajca Raquel huan Lea tananquilijque: ―Tojuanti ayecmo teno tijpiyaj ipan ichaj totata. ");
INSERT INTO nchBl_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Techchihua quej amo techixmati. Technamacac huan nochi cati quiseli por tojuanti ya quitamilti. ");
INSERT INTO nchBl_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Nelía nochi ricojyot cati Toteco Dios quiquixtilijtoc totata eltoc toaxca huan iniaxca toconehua. Huajca xijchihua nochi cati Toteco Dios mitznahuatijtoc. ");
INSERT INTO nchBl_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Huajca Jacob mocualtali para tacuepilis ipan tali Canaán campa itztoya itata, Isaac. Quinilhui iconehua huan isihuajhua ma tejcoca ipan camellos. Huan quicuic nochi cati iniaxca huan quistejque ipan ojti. Nojquiya quinhuicac nochi tapiyalme cati quinselijtoya por itequi ipan tali Aram. Quej nopa quisqui para tacuepilis tali Canaán campa itztoya itata, Isaac. ");
INSERT INTO nchBl_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Huan Labán yajtoya huejca para quinximas iborregojhua huan Raquel quiichtequili iteteyohua para quinhuicas. ");
INSERT INTO nchBl_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Nojquiya Jacob quicajcayajqui Labán nopa Aram ejquet pampa amo quiilhui sinta quisasquía. ");
INSERT INTO nchBl_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","San cholojtejqui ica nochi cati iaxca, huan quipanoc nopa hueyat Eufrates huan yajqui campa nopa tepeme ipan tali Galaad. ");
INSERT INTO nchBl_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Eyi tonati teipa, quiilhuijque Labán para Jacob cholojtoya. ");
INSERT INTO nchBl_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Huajca Labán ihuaya iteixmatcahua quintepotztocatiyajqui huan ica chicome tonati quinajsitoj ipan cuatita ipan tali Galaad. ");
INSERT INTO nchBl_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Pero nopa tayohua Toteco Dios monexti ica Labán nopa tali Aram ejquet, ipan se temicti huan quiilhui: “Ximotachili para amo xijnojnotza Jacob ica cualanti.” ");
INSERT INTO nchBl_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Huan Jacob quiquetztoya ichaj ten yoyomit campa tepeme ipan tali Galaad huan nopona Labán quiajsito. Huan nojquiya nopona Labán quiquetzqui ichaj ten yoyomit. ");
INSERT INTO nchBl_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Huan Labán quitatzintoquili Jacob: ―¿Taya tijchijtoc? ¿Para ten techcajcayajtoc? ¡Tiquinhualicatoc nica noichpocahua quej itztosquíaj ipan se tatehuilisti! ");
INSERT INTO nchBl_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","¿Para ten techcajcayajtoc huan ticholojtejqui huan amo teno techilhui? Sinta nijmajtosquía, na nimitzmajcajtosquía ica paquilisti, huan ica tapitzali, huan tambores huan arpa. ");
INSERT INTO nchBl_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Yon amo techcahuili ma niquintzoponi noichpocahua huan noixhuihua. ¡Tijchijqui se huihuiyot! ");
INSERT INTO nchBl_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Na nihueltosquía nimechchihuilijtosquía cati fiero, pero tayohua nechnojnotzqui Toteco Dios cati motata quitequipanohua huan nechilhui ma nimotachili para amo nimitznojnotzas ica cualanti. ");
INSERT INTO nchBl_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Sinta nelía tiquistoc pampa tijnequi titacuepilis ichaj motata, cualtitoc. Pero ¿para ten techichtequili noteteyohua? ");
INSERT INTO nchBl_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Huajca Jacob quinanquili Labán: ―Nelía nimajmajqui. Nimoilhui para nohueli techquixtilisquía moichpocahua masque amo nijnequisquía. ");
INSERT INTO nchBl_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Pero sinta se cati nica itztoc quipiya moteteyohua, ¡ma miqui! Toteixmatcahua nica itztoque testigos. Huajca xijtemo sinta tijhualicaj se tamanti cati moaxca huan sinta tijpantía, xijhuica. Pero Jacob amo quimatiyaya sinta Raquel quinichtectoya nopa teteyome. ");
INSERT INTO nchBl_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Huajca Labán calajqui ipan ichaj Jacob huan ipan ininchaj nopa ome sihua tequipanohuani. Teipa calajqui ipan ichaj Lea, pero amo quinpanti iteteyohua. Huan quema quisayaya ipan ichaj Lea para calaquis ipan ichaj Raquel, ");
INSERT INTO nchBl_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Raquel quincuic nopa teteyome huan quintali iijtic cati ica quipejpechtía icamello huan ipan mosehui. Huan Labán quintemo nochi calijtic huan amo quinpanti. ");
INSERT INTO nchBl_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Huan Raquel quiilhui: ―Papá, amo xicualani sinta amo nimotanana moixpa pampa ama nijpiya nococolis cati totequijya tisihuame. Huan Labán quintemo iteteyohua campa hueli, pero amo quinpanti. ");
INSERT INTO nchBl_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Huan Jacob cualanqui huan quiajhuac Labán ica ni camanali: ―¿Taya amo cuali nijchijtoc? ¿Catijqui notajtacol cati ica miyac cualanti techtepotztocatoc? ");
INSERT INTO nchBl_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Tijtajtachilijtoc nochi tamanti cati noaxca huan ¿taya tijpantijtoc ten mochaj? ¡Xijtali nica iniixpa moteixmatcahua huan noteixmatcahua para ma quiijtoca ajquiya ten tiome quiijtohua cati melahuac! ");
INSERT INTO nchBl_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ica nopa 20 xihuit cati nitequitic mohuaya, amo quema moconetahuisojque moborregojhua, yon mochivojhua huan amo quema nijcuajqui yon se. ");
INSERT INTO nchBl_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Amo quema nimitzhualiquili tapiyalme cati quinmictiyayaj tecuanime. San na nitaxtahuayaya por cati polihuiyaya. Sinta tonaya o tayohua sequinoc techtachtequiliyayaj, ta techinamayaya. ");
INSERT INTO nchBl_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Tonaya nitonalmiquiyaya huan tayohua nisecmiquiyaya huan nimocochsosolohuayaya. ");
INSERT INTO nchBl_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Quej nopa eltoya para 20 xihuit ipan mochaj. Para sese moichpoca nimitztequipano chicome xihuit huan para motapiyalhua nitequitic chicuase xihuit. Huan majtacti hueltas techpatili notaxtahuil. ");
INSERT INTO nchBl_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Sinta amo itztosquía nohuaya noTeco Dios cati iTeco nohueyi tata Abraham huan notata Isaac, nelía techtitanisquía san nomax. Pero Toteco Dios quiitac quenicatza nitequitic hasta tahuel nisiyajqui. Quiitac miyac nimocuesohuayaya huan yeca tayohua mitzajhuac. ");
INSERT INTO nchBl_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Huajca Labán quinanquili Jacob: ―Ni ichpocame noichpocahua, ni ixhuime noixhuihua. Ni tapiyalme notapiyalhua. Nochi cati nica tiquita noaxca. Amo teno amo cuali huelis niquinchihuilis noichpocahua o ininconehua. ");
INSERT INTO nchBl_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Yeca xihuala huan ma tijchihuaca se camanal sencahuali cati elis quej se testigo cati techitase tiome para ma tijchihuaca nochi cati quiijtohua. ");
INSERT INTO nchBl_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Huajca Jacob quicuic se tet huan quiquetzqui quej se tanextili, ");
INSERT INTO nchBl_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","huan quinilhui iteixmatcahua: ―¡Xijsentilica teme! Huan nochi quisentilijque teme huan quimontonojque huan nopona tacuajque nechca nopa temontomit. ");
INSERT INTO nchBl_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Huan Labán quitocaxti campa itztoya Jegar Sahaduta ipan ya icamanal. (Jegar Sahaduta quinequi quiijtos Testigo.) Huan Jacob quitocaxti Galaad ipan ten ya icamanal. (Galaad ipan icamanal Jacob quinequi quiijtos Testigo.) ");
INSERT INTO nchBl_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Huajca Labán quiilhui: ―Ni temontomit mocahuas quej testigo cati techitas tiome para ma tijtamichihuaca cati tiquijtojque. Huan yeca teipa motocaxti Galaad nopona, ");
INSERT INTO nchBl_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","huan nojquiya itoca elqui Mizpa. (Mizpa quinequi quiijtos Se Torre Cati Tachiya.) Pampa Labán quiijto: ―Ma TOTECO techtachili tiome quema ayecmo huelis timoitase. ");
INSERT INTO nchBl_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Huan sinta tiquincualancaitas noichpocahua o timocuilis sequinoc sihuame, masque amo niaqui para niquitas, xijmati para san yaya Toteco Dios quitachilis. ");
INSERT INTO nchBl_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Huan Labán noja quiilhui Jacob: ―Xiquita, nica nijtalijtoc ni temontomit cati elis se tanextili tatajco tiome. ");
INSERT INTO nchBl_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ni teme elise testigos para yon ta, yon na, amo quema tijpanose ni nepamit para timoixpanose. ");
INSERT INTO nchBl_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Toteco Dios cati iTeco mohueyi tata, Abraham, huan nohueyi tata, Nacor, ma quiijto ajquiya ten tojuanti quichihua cati cuali. Huajca Jacob quitestigojquetzqui Toteco cati itata, Isaac, quihueyichihua. ");
INSERT INTO nchBl_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Teipa nopona quimacac tacajcahualisti Toteco huan quinnotzqui iteixmatcahua ma tacuaquij. Huan nochi tacuajque huan mocajque nopa tayohua campa nopa tepet. ");
INSERT INTO nchBl_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Hualmosta ica ijnaloc, Labán mijquejqui, huan quintzoponi iixhuihua, huan iichpocahua huan quintiochijqui. Teipa mocuetqui para ital. ");
INSERT INTO nchBl_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Huan quema Jacob quisqui huan nejnemiyaya ipan ojti, sequij iilhuicac ejcahua Toteco Dios quinamiquicoj. ");
INSERT INTO nchBl_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Quema Jacob quinitac, quiijto: “Nica tonilijque Toteco Dios huan iilhuicac ejcahua.” Yeca quitocaxti campa itztoya Mahanaim. (Mahanaim quinequi quiijtos Campa Tonilijque Ome Pamit.) ");
INSERT INTO nchBl_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Huan Jacob quintitanqui itayolmelajcahua imelac hasta Seir ipan tali Edom para quiitatij iicni, Esaú. ");
INSERT INTO nchBl_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Huan Jacob quinilhui: “Xiquilhuitij Esaú para niitequipanojca niitztoya ihuaya Labán nochi ni xihuit, ");
INSERT INTO nchBl_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","huan para niquinpiya huacaxme, burrojme, borregojme huan chivojme. Nojquiya niquinpiya tequipanohuani tacame huan sihuame. Xiquilhuitij nimechtitani annotayolmelajcahua para anquiitase para yaya ma quimati nihuala huan ma techselis ica cuali.” ");
INSERT INTO nchBl_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Huan quema nopa tayolmelahuani mocuetque, quiilhuijque Jacob: ―Tiyajque tiquitatoj moicni, Esaú huan ya huala para mitzseliqui ihuaya 400 tacame. ");
INSERT INTO nchBl_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Huan quema Jacob quicajqui ya nopa, majmajqui miyac huan pejqui tahuel mocuesohua. Huajca quintajcoxelo nopa tacame cati itztoyaj ihuaya huan san se quichijqui ica nopa borregojme, huacaxme huan camellos, ");
INSERT INTO nchBl_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","pampa moilhui: “Sinta Esaú huala ica imiyaca huan quintehuis se tajco notequipanojcahua, huajca ne seyoc tajco huelis cholose.” ");
INSERT INTO nchBl_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Huan pejqui motatajtía ica TOTECO huan quiilhui: “Toteco Dios, ta cati tiiTeco nohueyi tata Abraham huan notata Isaac. Ta techilhui ma sempa niyas campa noteixmatcahua ipan notal huan tijchihuasquía nochi ma quisa cuali. ");
INSERT INTO nchBl_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Amo quinamiqui techtasojtas huan techchihuilis cati noca timocajtoc para tijchihuas. Quema niquisqui notal huan nijpanoc ni hueyat Jordán, san nocuatopil nijpiyayaya, huan ama niquinpiya miyaqui noconehua hasta mochihuaj ome huejhueyi pamit pampa hueyi techtiochijtoc. ");
INSERT INTO nchBl_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Toteco Dios, ama se favor, techmanahui imaco noicni, Esaú. Niquimacasi para hualas techmictiqui huan quinmictiqui ni sihuame huan coneme. ");
INSERT INTO nchBl_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Pero ta tiquijtojtoc tijchihuas para nochi ma quisa cuali huan para noteipan ixhuihua elise nelmiyaqui quej xali nepa ipan hueyi at cati amo hueli mopohua.” ");
INSERT INTO nchBl_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Huan nopa tayohua Jacob quitapejpeni cati quipixtoya para quitamajmacas iicni, Esaú. ");
INSERT INTO nchBl_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Huan quiniyocatali 200 sihua chivojme, 20 oquich chivojme, 200 sihua borregojme, 20 oquich borregojme, ");
INSERT INTO nchBl_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","huan 30 sihua camellos inihuaya ininconehua. Nojquiya quiniyocatali 40 huacaxme, 10 torojme, 20 sihua burrojme huan 10 oquich burrojme. ");
INSERT INTO nchBl_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Teipa quinmactili itequipanojcahua huan quinxejxelo sesen tamanti tapiyalme huan quinilhui: ―Xitayacanaca huan amo xiquincahuilica ma mosejcotilica sequinoc tamanti tapiyalme. Se tatilimit ten se tamanti tapiyalme ma tayacanaca, huan teipa inintepotzco ma hualaca seyoc tatilimit ica seyoc tamanti tapiyalme. ");
INSERT INTO nchBl_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Huan Jacob quinilhui itequipanojcahua cati tayacanayayaj: ―Quema anquipantise noicni, Esaú, huan amechtatzintoquilis ajquiya amoteco huan canque anyahuij huan ajquiya iaxca nopa tapiyalme cati anquinhuicaj, ");
INSERT INTO nchBl_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","xijnanquilica: ‘Ni se nemacti para ta, toteco Esaú. Jacob, motequipanojca, mitztitanilía huan ya huala totepotzco.’ ");
INSERT INTO nchBl_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Nojquiya Jacob san se quiilhui itequipanojca cati teipa hualayaya ica más tapiyalme huan nopa sequinoc cati inintepotzco hualayayaj. Quinilhui: ―Quema anquipantise Esaú, xiquilhuica san se. ");
INSERT INTO nchBl_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Nojquiya xiquilhuica: ‘Motequipanojca, Jacob, huala totepotzco.’ Quej nopa quichijqui Jacob pampa moilhui: “Nijyoltalis ica cati nijtitani ma quihuiquilica, huan teipa nechitas na huan cuali nechselis.” ");
INSERT INTO nchBl_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Huajca tayacanque nopa tequipanohuani ica nopa tapiyalme cati quimacayaya iicni. Huan nopa tayohua Jacob mocajqui ipan ichaj ten yoyomit. ");
INSERT INTO nchBl_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ipan nopa tayohua Jacob mijquejqui huan quincuitejqui nopa ome isihuajhua, nopa ome isihua tequipanojcahua, huan nopa 11 iconehua, huan quinchihualti ma quiixcotonaca nopa pilatajtzi Jaboc. ");
INSERT INTO nchBl_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Huan quinchihualti itequipanojcahua ma quinpanoltica nochi tapiyalme huan tamanti cati iaxca ipan nopa seyoc nali. ");
INSERT INTO nchBl_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Huan Jacob mocajqui iseltitzi. Huan monexti se tacat cati motehui ihuaya hasta tanesqui. ");
INSERT INTO nchBl_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Pero quema nopa tacat quiitac para amo hueliyaya quitani, quiitzqui Jacob iquestzinta huan quilecueni. ");
INSERT INTO nchBl_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Huan nopa tacat quiilhui: ―Techmajcahua pampa ya tanesi. Huan Jacob quiilhui: ―Sinta amo techtiochihuas, amo nimitzmajcahuas. ");
INSERT INTO nchBl_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Huan nopa tacat quiilhui: ―¿Taya motoca? Huan ya quinanquili: ―Notoca Jacob. (Jacob quinequi quiijtos Tacajcayajquet.) ");
INSERT INTO nchBl_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Huajca nopa tacat quiilhui: ―Motoca ayecmo elis Jacob. Motoca elis Israel. (Israel quinequi quiijtos Se Cati Motehuía Ica Toteco.) ―Quej nopa motoca pampa timotehuijtoc ihuaya Toteco Dios huan ihuaya masehualme huan titatantoc. ");
INSERT INTO nchBl_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Huajca Jacob quiilhui: ―Techilhui taya motoca ta. Pero nopa tacat quinanquili: ―¿Para ten techtatzintoquilía notoca? Teipa nopa tacat quitiochijqui Jacob. ");
INSERT INTO nchBl_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Huan Jacob quitocaxti campa itztoya Peniel. (Peniel quinequi quiijtos Ixayac Toteco.) Quej nopa quitocaxti pampa quiijto: “Niquixtachilijtoc Toteco Dios huan noja niitztoc.” ");
INSERT INTO nchBl_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Huan Jacob quistejqui Peniel quema quisqui tonati, pero metzcuachotiyaya pampa lecuentoya iquesomiyo. ");
INSERT INTO nchBl_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Yeca hasta ama iteipan ixhuihua Israel amo quicuaj ilejleto imetztomahuiya se tapiyali pampa nopona iilhuicac ejca TOTECO quimaquili Jacob. ");
INSERT INTO nchBl_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Huan quema Jacob quiitac para Esaú hualayaya imelac ica 400 tacame, quinxejxelo nopa coneme ihuaya Lea, Raquel huan nopa ome sihua tequipanohuani. ");
INSERT INTO nchBl_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Quintali ma tayacanaca nopa sihua tequipanohuani ihuaya ininconehua. Teipa quitali Lea ihuaya iconehua huan hasta tateipa quintali Raquel huan José. ");
INSERT INTO nchBl_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Jacob tayacanqui huan mohuijtzonqui hasta talchi chicome huelta para quitepanitas iicni quema monechcahuiyaya. ");
INSERT INTO nchBl_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Pero Esaú motalo quinamiquito. Huan quicuanajnahuajqui, huan quitzoponi, huan nochi ome chocaque. ");
INSERT INTO nchBl_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Teipa Esaú quinitac nopa sihuame huan coneme cati hualayayaj huan tatzintocac: ―Huan ¿ajquiya inijuanti ni cati hualahuij mohuaya? Huan Jacob quinanquili: ―Ni cati Toteco Dios nechmacatoc. ");
INSERT INTO nchBl_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Huajca nopa sihua tequipanohuani ihuaya ininconehua monechcahuijque huan mohuijtzonque. ");
INSERT INTO nchBl_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Teipa monechcahuijque Lea huan iconehua huan san se quichijque. Huan más teipa ajsicoj José huan Raquel huan nojquiya mohuijtzonque. ");
INSERT INTO nchBl_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Huan Esaú quiilhui Jacob: ―¿Taya timoilhuía tijchihuas ica nochi nopa tapiyalme cati niquinpantijtihualajqui? Huan Jacob quiilhui: ―Nijnequi nimitzmacas ta, noicni, para techseli ica cuali. ");
INSERT INTO nchBl_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Huan Esaú quiijto: ―Amo, noicni. Na ya niquinpiya miyac. Ximocahua ica cati moaxca. ");
INSERT INTO nchBl_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Pero Jacob quiilhui: ―Amo, xijchihua se favor, xiquinseli pampa nimitzmaca. Para na nimitzita, eltoc quej niquita ixayac Toteco pampa techselijtoc ica cuali. ");
INSERT INTO nchBl_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Xijseli cati nimitzhualiquilijtoc pampa Toteco Dios tahuel nechricojchijtoc huan nochi cati tiquita, noaxcahua. Huan pampa Jacob quinelchihualti ma quiseli, Esaú quiseli. ");
INSERT INTO nchBl_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Teipa Esaú quiijto: ―Ma ya tiyaca huan san sejco tiajsise. ");
INSERT INTO nchBl_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Pero Jacob quiilhui: ―Noicni, ta tijmati para coneme amo quipiyaj tetili, yon amo quipiyaj tetili nopa piltapiyaltzitzi. Sinta tiquinquixtise chicahuac san se tonal, siyahuise huan nochi miquise. ");
INSERT INTO nchBl_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Más cuali para timotayacanaltis huan na niyas ica yolic quej nejnemij ni tapiyalme huan coneme hasta timosejcotilise ipan tali Seir. ");
INSERT INTO nchBl_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Huan Esaú quiijto: ―¡Cualtitoc! Techcahuili ma nimitzcahuilijtehua se ome tacame cati hualahuij nohuaya. Pero Jacob quiilhui: ―¡Amo! Amo ximocuatotoni. Cati ipati eltoc para tojuanti tiome ma tiitztoca ica cuali. ");
INSERT INTO nchBl_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Huan nopa tonali Esaú tacuepili Seir. ");
INSERT INTO nchBl_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Huan Jacob yajqui altepet Sucot huan nopona quichijqui se cali huan quinchihuili pilxajcaltzitzti itapiyalhua. Yeca quitocaxti campa itztoya Sucot. (Sucot quinequi quiijtos Pilxajcaltzitzi.) ");
INSERT INTO nchBl_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Teipa quema Jacob hualayaya ten tali Aram, ajsico ica cuali ipan tali Canaán huan quiquetzque iniyoyoncalhua nechca altepet Siquem. ");
INSERT INTO nchBl_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Huan teipa ica 100 plata tomi quicojqui nopa tali ten iteixmatcahua Hamor cati elqui itata Siquem. ");
INSERT INTO nchBl_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Huan nopona quichijqui se taixpamit huan quitocaxti El Elohe Israel. (El Elohe Israel quinequi quiijtos: Tahuel Hueyi Toteco Dios Cati Toteco Tiisraelitame.) ");
INSERT INTO nchBl_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Huan Dina, nopa ichpocat cati Lea quimacac Jacob, yajqui quinpaxaloto nopa ichpocame cati nopona ehuani. ");
INSERT INTO nchBl_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Pero nopona itztoya se telpocat cati itoca Siquem. Yaya eliyaya icone Hamor, se heveo tacat cati quinyacanayaya nopa heveos nopona. Huan Siquem quichihualti Dina ma moteca ihuaya huan quipinahualti. ");
INSERT INTO nchBl_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Pero masque ya nopa quichihuili, nopa telpocat nelía quiixtocac huan quiicneli huan quicamanalhui Dina ica nochi iyolo para nojquiya ma quiicneli. ");
INSERT INTO nchBl_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Huajca mocamanalhui ihuaya itata, Hamor, huan quiilhui: ―Xiya xiquijtaniti nopa ichpocat. Nijnequi nimosihuajtis ihuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Huan Jacob quimatqui para Siquem quipinahualtijtoya iichpoca, pero itelpocahua noja itztoyaj potrero ica inintapiyalhua huan yeca amo teno quiijto hasta ajsique. ");
INSERT INTO nchBl_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Huan ipan nopa tonali Hamor, itata Siquem, quicamanalhuito Jacob ten Dina. ");
INSERT INTO nchBl_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Huan quema itelpocahua Jacob tacuepilijque, huan quimatque cati panotoya, nelía cualanque pampa eliyaya se hueyi pinahualisti para nochi iteixmatcahua Jacob para se tacat san quej hueli motecasquía ihuaya iichpoca. ¡Elqui se tamanti cati amo quema mochijtosquía ica israelitame! ");
INSERT INTO nchBl_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Pero Hamor hualajqui quincamanalhuico Jacob huan itelpocahua huan quinilhui: ―Nocone Siquem nelía quiicnelía amosihua icni. Se favor, xijcahuilica ma mocuili. ");
INSERT INTO nchBl_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Nojquiya ma timohuampojchihuaca huan quej nopa timosihuajtise ihuaya amoichpocahua, huan amojuanti ihuaya toichpocahua. ");
INSERT INTO nchBl_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ximocahuaca ipan total. Xijtapejpenica nopa tali cati más anquinequise huan nopona xiitztoca. Nica huelis antanamacase, antacohuase huan anmoaxcatise talme. ");
INSERT INTO nchBl_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Huan nopa telpocat Siquem nojquiya quinilhui Jacob huan iicnihua Dina: ―Nimechtajtanía ma tiitztoca ica yejyectzi. ");
INSERT INTO nchBl_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Techilhuica quesqui tomi huan tamanti anquinequij para nopa ichpocat huan nimechmacas. Para na amo teno sinta antechtajtanise cati patiyo. San nijnequi xijcahuilica nopa ichpocat ma monamicti nohuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Pero pampa Siquem quipinahualtijtoya Dina, itelpocahua Jacob quinejque quincajcayahuase Siquem huan itata, Hamor, ");
INSERT INTO nchBl_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","huan huajca quinilhuijque: ―Amo hueli tijnamacase toicni ica se tacat cati amo motequilijtoc iyecapa nopa cuetaxti ipan itacayo pampa ya nopa elisquía se pinahualisti para tojuanti. ");
INSERT INTO nchBl_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","San huelis tijselise se tacat sinta elis quej tojuanti. Huajca achtohui nochi tacame ten amotal monequi ma motequilica inincuetaxo para quipiyase nopa machiyot cati itoca circuncisión. ");
INSERT INTO nchBl_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Huan huajca, quena, huelis anmosihuajtise ihuaya toichpocahua huan tojuanti ihuaya amoichpocahua. Huan tiitztose tatajco ten amojuanti huan tielise san se altepet. ");
INSERT INTO nchBl_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Pero sinta amo anquiselíaj cati timechtajtaníaj huan amo anmotequilíaj nopa machiyot, huajca tiquistehuase huan tijhuicase tosihua icni. ");
INSERT INTO nchBl_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Huajca Hamor huan itelpoca quicualcajque nopa camanali. ");
INSERT INTO nchBl_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Huan nimantzi yajqui nopa telpocat huan motequili icuetaxo pampa tahuel quiixtocayaya iichpoca Jacob. Huan Siquem elqui cati más quipixqui tatepanitacayot ica itata iteixmatcahua. ");
INSERT INTO nchBl_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Huajca ya huan itata, Hamor, yajque iteno icaltempa nopa altepet campa nochi momatque mosentilíaj huan quinilhuijque cati nopona ehuani: ");
INSERT INTO nchBl_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","―Ni masehualme quinequij elise tohuampoyohua. Ma mocahuaca nica tohuaya huan tanamacase pampa onca miyac tali para inijuanti. Huelis timosihuajtise ihuaya iniichpocahua, huan inijuanti ihuaya toichpocahua. ");
INSERT INTO nchBl_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Pero amo mocahuase para ma tielica san se altepet sinta nochi tojuanti cati titacame amo timotequilise iyecapan cuetaxo ipan totacayohua quej inijuanti momajtoque quichihuaj. ");
INSERT INTO nchBl_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Pero sinta quena, teipa nochi cati quipiyaj huan nochi inintapiyalhua elise toaxca. Huajca ma tijchihuaca cati quiijtohuaj. ");
INSERT INTO nchBl_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Huan nochi tacame ipan nopa altepet cati ya quipixtoyaj xihuit para elise soldados quicualcajque cati quiijtojque huan motequilijque nopa cuetaxti. ");
INSERT INTO nchBl_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Pero ica ihuictatica quema nopa tacame noja xoxocoxtoyaj pampa motectoyaj, Simeón huan Leví, nopa ome itelpocahua Jacob cati eltoyaj itaca icnihua Dina, yajque campa nopa altepet huan ica inimacheta quinmictijque nochi nopa tacame pampa amo quiijyohuijque cati quichijque. ");
INSERT INTO nchBl_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Quimictijque Hamor ihuaya icone, Siquem, huan quiquixtijtejque Dina ipan ichaj Siquem huan quistejque. ");
INSERT INTO nchBl_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Huan ajsicoj nopa sequinoc itelpocahua Jacob, huan panoque campa nopa mijcatzitzi huan quinichtequilijque nochi cati quipixtoyaj ipan nopa pilaltepetzi pampa quipinahualtijtoyaj iniicni. ");
INSERT INTO nchBl_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Quinhuicaque nochi borregojme, huacaxme, burrojme huan nochi cati oncayaya ipan nopa altepet huan ipan mila. ");
INSERT INTO nchBl_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Quiichtejque nochi cati oncayaya ipan calme huan quinhuicaque nochi coneme huan sihuame. ");
INSERT INTO nchBl_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Huajca quema Jacob quimatqui, quinilhui Simeón huan Leví: ―Anquichijtoque ma nimocahua fiero. Ama nopa cananeos huan nopa ferezeos cati itztoque ipan ni tali techcualancaitase, huan mosejcotilise, huan techtehuise huan techmictise na huan nochi noteixmatcahua pampa amo timiyaqui. ");
INSERT INTO nchBl_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Pero itelpocahua Jacob quiilhuijque: ―Pero amo hueli quichihuilise toicni quej se ahuilnenca sihuat huan amo teno oncas. ");
INSERT INTO nchBl_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Teipa Toteco Dios quiilhui Jacob: “Ximoquetza huan xiya xiitztoti Betel. Nopona xijchihua se taixpamit para techhueyimatis pampa nopona nimonexti ica ta quema ticholohuayaya ten moicni, Esaú.” ");
INSERT INTO nchBl_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Huajca Jacob quiilhui ichampoyohua huan nochi cati ihuaya yahuiyayaj: ―Xiquinquixtica nochi teteyome cati anquipiyaj, huan ximaltica huan xijpataca amoyoyo. ");
INSERT INTO nchBl_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Teipa xihualaca, ma tiyaca Betel pampa nepa nijchihuas se taixpamit huan tijhueyichihuase Toteco Dios cati nechpalehui quema nimocuesohuayaya. Yaya cati nohuaya yajtoc campa hueli campa ninentinentoc. ");
INSERT INTO nchBl_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Huajca quimactilijque Jacob nochi ininteteyohua huan nochi pijpiloli ica teteyome cati quihuicayayaj ipan ininacas, huan Jacob quintalpacho itzinta se ahuat cati eltoya nechca altepet Siquem. ");
INSERT INTO nchBl_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Huan quema quisque nopona, Toteco Dios quichijqui para nochi nopa pilaltepetzitzi cati nejnechca ma quinimacasica miyac, huan yeca amo quintepotztocaque. ");
INSERT INTO nchBl_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Huan Jacob huan nochi masehualme cati ihuaya nejnemiyayaj ajsitoj ipan Luz cati nojquiya itoca Betel ipan tali Canaán. ");
INSERT INTO nchBl_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Huan nopona quichijqui se taixpamit huan quitocaxti El Betel. (El Betel quinequi quiijtos Itaixpa Toteco Dios Cati Nechnamijqui Nica Betel.) Pampa quema mochololtiyaya ten iicni, Toteco Dios monextijtoya ihuaya nopona. ");
INSERT INTO nchBl_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Nojquiya nopona mijqui Débora, nopa sihuat cati quimocuitahuijtoya Rebeca. Huan quitalpachojque itzinta se ahua cuahuit nechca Belén. Huan Jacob quitocaxti nopa cuahuit Alónbacut. (Alónbacut quinequi quiijtos Ahuat Campa Nochi Chocaque.) ");
INSERT INTO nchBl_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Nojquiya Toteco Dios ya monextijtoya sempa ica Jacob quema tacuepiliyaya ten tali Aram huan quitiochijqui. ");
INSERT INTO nchBl_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Huan Toteco Dios quiilhuijtoya: “Ta motoca Jacob.” (Jacob quinequi quiijtos Tacajcayajquet.) “Pero ayecmo mitztocaxtise Jacob. Ama motoca elis Israel.” (Israel quinequi quiijtos Se Cati Moquetza Ica Chicahualisti Iixpa Toteco.) ");
INSERT INTO nchBl_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Huan nojquiya quema Toteco Dios quipatili itoca, Toteco quiilhui: “Na nimoTeco Dios Cati Nijpiya nochi Chicahualisti. Nijchihuas xiquinpiya miyac moconehua huan moteipan ixhuihua. Huan miyac masehualme quisase ipan moteipan ixhuihua, huan mochihuase miyac altepeme ipan inintal. Ipan moteipan ixhuihua oncas tanahuatiani huan sesen quinnahuatis imasehualhua ipan ital. ");
INSERT INTO nchBl_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Nopa tali cati nijmacac Abraham huan Isaac, mohuejcapan tatahua, nojquiya nimitzmacas ta huan teipa niquinmacas moteipan ixhuihua.” ");
INSERT INTO nchBl_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Huan Toteco Dios quistejqui nopona campa quicamanalhui Jacob. ");
INSERT INTO nchBl_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Huan Jacob quicuic se tet huan quiquetzqui quej se tanextili para quielnamiquis campa camanaltitoya ihuaya Toteco. Huan quitequili aceite huan xocomecat iayo nopa tet para quiiyocatalis para Toteco. ");
INSERT INTO nchBl_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Huan quitocaxti campa itztoya, Betel. (Betel quinequi quiijtos Ichaj Toteco Dios.) ");
INSERT INTO nchBl_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Teipa Jacob huan ifamilia quistejque ten Betel. Huan quema noja huejca itztoyaj para ajsitij altepet Efrata, Raquel ajsic tonali para conepiyas huan nelía taijyohuiyaya. ");
INSERT INTO nchBl_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Huan ipan nopa hora cati más ohui, nopa sihuat cati quipalehuiyaya para ma conepiya quiilhui: “Amo ximajmahui pampa tijtacatiltijtoc seyoc oquichpil.” ");
INSERT INTO nchBl_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Pero Raquel ya miquiyaya huan quema tantinemiyaya iijyoyo, quitocaxti ioquichpil Benoni. (Benoni quinequi quiijtos Oquichpil Cati Tacatqui Ica Taohuijcayot.) Pero teipa itata quitocaxti nopa ipiloquichpil Benjamín. (Benjamín quinequi quiijtos Oquichpil Cati Más Quipiya Tanahuatili.) ");
INSERT INTO nchBl_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Quej nopa Raquel mijqui huan quitalpachojque ipan ojti para altepet Efrata cati ama itoca Belén. ");
INSERT INTO nchBl_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Huan Jacob quiquetzqui se tet campa quitoctoyaj Raquel huan nopa tet hasta ama quejipa quinextía campa quitojque. ");
INSERT INTO nchBl_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Huan Israel, cati achtohui itoca eliyaya Jacob, quistejqui ipan ojti huan quiquetzato ichaj ten yoyomit ipan seyoc lado nopa altepet Migdal Edar. ");
INSERT INTO nchBl_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Huan quema Israel mocahuayaya nopona, Rubén motecato ihuaya Bilha, se itequipanojca itata. Huan itata quimatqui huan tahuel cualanqui. Huan Israel quinpixqui 12 itelpocahua. ");
INSERT INTO nchBl_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Nopa coneme cati quinpixqui ihuaya Lea elque: Rubén iachtohui ejca, Simeón, Leví, Judá, Isacar huan Zabulón. ");
INSERT INTO nchBl_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Cati quinpixqui ihuaya Raquel elque: José huan Benjamín. ");
INSERT INTO nchBl_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Huan cati quinpixqui ihuaya Bilha cati eliyaya itequipanojca Raquel elque: Dan huan Neftalí. ");
INSERT INTO nchBl_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Huan nopa coneme cati quinpixqui ihuaya Zilpa, cati eliyaya itequipanojca Lea, elque: Gad huan Aser. Ya ni nochi ioquichpilhua Jacob cati tacatque ipan tali Aram. ");
INSERT INTO nchBl_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Huan Jacob ajsito ichaj campa itztoya itata, Isaac, ipan Mamre, nopa altepet nechca Arba o Hebrón, campa huejcajquiya mochantijtoyaj Abraham huan Isaac. ");
INSERT INTO nchBl_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Huan Isaac quipiyayaya 180 xihuit quema mijqui. ");
INSERT INTO nchBl_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Quena, quema eliyaya nelhuehuentzi, yajqui mosejcotilito ihuaya ihuejcapan tatahua. Huan iconehua Esaú huan Jacob quitalpachojque. ");
INSERT INTO nchBl_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Huan ya ni iteipan ixhuihua Esaú cati nojquiya itoca Edom. ");
INSERT INTO nchBl_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaú mosihuajti inihuaya sihuame cati ehuani tali Canaán. Isihuajhua inintoca eliyaya Ada, iichpoca Elón nopa heteo tacat, huan Aholibama, iichpoca Aná huan iixhui Zibeón nopa heveo tacat. ");
INSERT INTO nchBl_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Huan nojquiya mosihuajti ihuaya Basemat, iichpoca Ismael, huan isihua icni Nebaiot. ");
INSERT INTO nchBl_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Huan Ada quimacac Esaú se icone cati itoca Elifaz. Huan Basemat quitacatilti Reuel, ");
INSERT INTO nchBl_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","huan Aholibama quintacatilti Jeús, Jaalam huan Coré. Ya ni iconehua Esaú cati tacatque quema noja itztoya ipan tali Canaán. ");
INSERT INTO nchBl_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Huan Esaú quincuitejqui isihuajhua, itaca conehua huan isihua conehua huan itequipanojcahua huan yajqui ipan seyoc tali para moiyocaquixtis ten iicni, Jacob. Quinhuicac nochi itapiyalhua huan nochi tamantzitzi cati quisentilijtoya ipan Canaán. ");
INSERT INTO nchBl_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Nelmiyac quipiyayayaj nochi ome icnime hasta ayecmo hueliyayaj itztoque san sejco. Nopa tali cati ipan itztoyaj amo quinaxiliyaya para quintamacase inintapiyalhua. ");
INSERT INTO nchBl_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Yeca Esaú cati nojquiya quitocaxtiyayaj Edom yajqui itztoti campa tepeyo ipan tali Seir. ");
INSERT INTO nchBl_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Nica eltoc inintoca iteipan ixhuihua Esaú cati quintocaxtijque edomitame. Inijuanti itztoyaj campa tepeyo ipan nopa tali cati itoca Seir. ");
INSERT INTO nchBl_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Inintoca iconehua Esaú elque Elifaz huan Reuel. Elifaz elqui icone isihua, Ada, huan Reuel elqui icone isihua, Basemat. ");
INSERT INTO nchBl_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Iconehua Elifaz elque Temán, Omar, Zefo, Gatam huan Senaz. ");
INSERT INTO nchBl_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifaz quipixqui se isihua tequipanojca cati itoca Timna cati quimacac se icone cati quitocaxti Amalec. Huan iconehua Elifaz elque iixhuihua Esaú huan isihua, Ada. ");
INSERT INTO nchBl_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Huan iconehua Reuel elque: Nahat, Zera, Sama huan Miza. Inijuanti elque iixhuihua Basemat nopa seyoc isihua Esaú. ");
INSERT INTO nchBl_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Huan Esaú quinpixqui iconehua ica isihua cati itoca eliyaya Aholibama cati elqui iichpoca Aná huan iixhui Zibeón. Inintoca ininconehua elque: Jeús, Jaalam huan Coré. ");
INSERT INTO nchBl_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ama nimitzilhuis nopa tayacanani ipan iteipan ixhuihua Esaú. Ipan iconehua Elifaz, iachtohui cone Esaú, elque: Tayacanani Temar, Omar, Zefo, Cenaz, ");
INSERT INTO nchBl_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Coré, Gatam huan Amalec. Nochi ya ni elque tayacanani ipan iteipan ixhuihua Elifaz ipan tali Edom. Huan nochi inijuanti elque iteipan ixhuihua Ada, isihua Esaú. ");
INSERT INTO nchBl_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Huan iconehua Reuel, icone Esaú, elque: Tayacanani Nahat, Zera, Sama huan Miza. Inijuanti tayacanque ipan iconehua Reuel ipan tali Edom huan elque iixhuihua Basemat, isihua Esaú. ");
INSERT INTO nchBl_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Iconehua Esaú ica isihua Aholibama, iichpoca Aná, elque: Tayacanani Jeús, Jaalam huan Coré. Inijuanti quinyacanque iniixhuihua. ");
INSERT INTO nchBl_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Nochi inijuanti elque nopa tayacanani ipan iteipan ixhuihua Esaú o Edom. Huan sesen inijuanti mochijqui se hueyi familia ica miyac masehualme. ");
INSERT INTO nchBl_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Iconehua Seir, nopa horeo tacat cati itztoyaj ipan nopa tali, elque: Lotán, Sobal, Zibeón, Aná, ");
INSERT INTO nchBl_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disón, Ezer huan Disán. Ya ni elque tayacanani ten horeos cati elque iixhuihua Seir ipan tali Edom. ");
INSERT INTO nchBl_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Iconehua Lotán elque: Hori huan Hemam. Huan Timna elqui isihua icni Lotán. ");
INSERT INTO nchBl_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Iconehua Sobal elque: Alván, Manahat, Ebal, Sefo huan Onam. ");
INSERT INTO nchBl_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Iconehua Zibeón elque: Aja huan Aná. Aná elqui cati quipanti campa meya at totonic ipan nopa huactoc tali quema quinmocuitahuiyaya iburrojhua itata. ");
INSERT INTO nchBl_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Iconehua Aná elque: Disón huan se isihuapil cati itoca Aholibama. ");
INSERT INTO nchBl_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Iconehua Disón elque: Hemdán, Esbán, Itrán huan Querán. ");
INSERT INTO nchBl_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Iconehua Ezer elque: Bilhán, Zaaván huan Acán. ");
INSERT INTO nchBl_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Iconehua Disán elque: Uz huan Arán. ");
INSERT INTO nchBl_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Nopa tayacanani ten horeos elque: Lotán, Sobal, Zibeón, Aná, ");
INSERT INTO nchBl_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disón, Ezer huan Disán. Ya ni elque inintayacancahua nopa horeos ipan sesen pilaltepetzitzi ipan tali Seir. ");
INSERT INTO nchBl_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Nica quiijtohua inintoca nopa huejhueyi tanahuatiani cati tanahuatijque ipan tali Edom achtohuiya quema israelitame ayemo quipiyayayaj se tanahuatijquet: ");
INSERT INTO nchBl_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, icone Beor, elqui tanahuatijquet ipan Edom huan ialtepe itoca eliyaya Dinaba. ");
INSERT INTO nchBl_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Quema Bela mijqui, pejqui tanahuatía Jobab, icone Zera, cati ehuayaya ipan pilaltepetzi Bosra. ");
INSERT INTO nchBl_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Quema Jobab mijqui, tanahuati Husam cati hualajqui altepet Temán. ");
INSERT INTO nchBl_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Quema Husam mijqui, pejqui tanahuatía Hadad, icone Bedad, cati quintanqui nopa tali Madián ehuani quema quinamiquicoj ipan tali Moab. Yaya ehuayaya ipan altepet Avit. ");
INSERT INTO nchBl_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Quema mijqui Hadad, pejqui tanahuatía Samla cati ehuayaya ipan Masreca. ");
INSERT INTO nchBl_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Quema Samla mijqui, pejqui tanahuatía Saúl cati ehuayaya ipan Rehobot, nopa pilaltepetzi cati eltoc nechca nopa hueyat Eufrates. ");
INSERT INTO nchBl_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Quema mijqui Saúl, tanahuati Baal Hanán cati eliyaya icone Acbor. ");
INSERT INTO nchBl_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Huan quema mijqui Baal Hanán, tanahuati Hadad. Ialtepe Hanán itoca eliyaya Pau huan Mehetabel cati eliyaya iichpoca Matred huan iixhui Mezaab elqui isihua. ");
INSERT INTO nchBl_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Nica eltoc inintoca itayacanca teipan ixhuihua Esaú huan sesen inijuanti quiyacanqui ihueyi familia huan campa sesen tayacanqui ipan nopa altepet cati quihuicac inintoca. Inintoca eltoc: Timna, Alva, Jetet, ");
INSERT INTO nchBl_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Aholibama, Ela, Pinón, ");
INSERT INTO nchBl_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Cenaz, Temán, Mibzar, ");
INSERT INTO nchBl_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel huan Iram. Nochi ni tacame tayacanque ipan tali Edom cati quihuicac itoca inihuejcapan tata, Esaú. Huan sese altepet cati iniaxcahua quihuicac itoca itayacanca ixhui cati tayacanqui nopona. ");
INSERT INTO nchBl_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob mocajqui para itztos ipan tali Canaán campa itztoya itata quema ayemo miquiyaya. ");
INSERT INTO nchBl_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Huan ya ni cati panoc ica Jacob huan iconehua. Quema José, icone Israel, eliyaya se telpocat cati quipiyayaya 16 xihuit, quinmocuitahuiyaya borregojme inihuaya itepotz icnihua cati eliyayaj ininconehua Bilha huan Zilpa, ne sequinoc isihuajhua itata. Huan teipa José quiilhuico itata nochi cati amo cuali quichihuayayaj iicnihua. ");
INSERT INTO nchBl_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Huan Israel más quiicneli José que ne sequinoc itelpocahua pampa tacatqui quema eliyaya nelhuehuentzi. Huan yeca quichihuili se iyoyo cati huehueyac huan tahuel yejyectzi. ");
INSERT INTO nchBl_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Pero quema iicnihua quiitaque para inintata más quiicneliyaya José que inijuanti, pejque quicualancaitaj huan yon quentzi amo quinequiyayaj quiitase. ");
INSERT INTO nchBl_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Se tonali José quipixqui se temicti huan quinpohuili iicnihua, pero ya nopa quichijqui más ma quicualancaitaca. ");
INSERT INTO nchBl_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Huan ya ni cati quinilhui: ―Xijtacaquilica huan nimechpohuilis nopa temicti cati nijpixqui. ");
INSERT INTO nchBl_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Nijtemijqui para nochi tojuanti tiitztoyaj mila, tijsentiliyayaj tamontomit ten trigo tzonti. Huan nimantzi cati na nijsentilijtoya motananqui huan moquetzqui xitahuac huan cati anquisentilijtoyaj techyahualojque huan quej motancuaquetzque para techtepanitase. ");
INSERT INTO nchBl_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Huajca iicnihua quiilhuijque: ―¿Tijnequi tiquijtos para tielis tihueyi tanahuatijquet huan technahuatis? Huajca más quicualancaitaque por itemic huan quej quinpohuilijtoya. ");
INSERT INTO nchBl_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Teipa José quipixqui seyoc temicti huan nojquiya quinpohuili iicnihua. Quinilhui: ―Xijtacaquilica, nijpixqui seyoc temicti huan niquitayaya para tonati huan metzti huan 11 sitalime nechhueyitepanitayayaj. ");
INSERT INTO nchBl_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Huan José nojquiya quipohuili ni temicti itata huan iicnihua; huan itata quiajhuac huan quiilhui: ―¿Taya tiquijtosnequi ica ni temicti cati tijpixqui? ¿Timoilhuía para monana, moicnihua huan na monequis timitzhueyitepanitase? ");
INSERT INTO nchBl_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Huan iicnihua quicualancaitaque, pero itata miyac moilhuiyaya ten ni tamanti. ");
INSERT INTO nchBl_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Se tonali iicnihua José quinhuicaque iborregojhua inintata para quitemojtiyase sacat huan ajsitoj nechca altepet Siquem. ");
INSERT INTO nchBl_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Huan ipan ichaj inintata quiilhui José: ―Xiquita, moicnihua quintacualtíaj noborregojhua nechca Siquem. Nijnequi xiya xiquinitati. Huan José quinanquili: ―¡Cualtitoc! ");
INSERT INTO nchBl_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Huajca itata quiilhui: ―Xiquitati quenicatza itztoque moicnihua huan nopa borregojme. Huan teipa xihuala techyolmelahuaqui. Huajca quej nopa, Israel quititanqui José para ma yahui campa nopa tamayamit nechca Hebrón. Huan quema José ajsito Siquem, ");
INSERT INTO nchBl_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","quintemohuayaya iicnihua campa hueli. Huan quipanti se tacat huan quitatzintoquili: ―¿Taya tijtemojtinemi? ");
INSERT INTO nchBl_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Huan José tananquili: ―Na niquintemojtinemi noicnihua. ¿Huelis techilhuis canque quinmocuitahuíaj ininborregojhua? ");
INSERT INTO nchBl_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Huan nopa tacat quiijto: ―Ya mijcuenijtejque nica. Nijcajqui quiijtohuaj para yahuij Dotán. Huajca José quintemojtiyajqui huan quinpanti ipan Dotán. ");
INSERT INTO nchBl_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Huan inijuanti quihuejcaitaque, huan quema ayemo onajsiyaya, quisencajque quenicatza quimictise. ");
INSERT INTO nchBl_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Quiijtojque: ―¡Xiquitaca ne huala cati tatemiqui! ");
INSERT INTO nchBl_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Xihualaca, ma tijmictica huan tijcalaquise ipan se ten ni ostome campa achtohuiya eltoya at huan tiquijtose para se tecuani quicuajqui. Huan tiquitase taya panos ica itemic. ");
INSERT INTO nchBl_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Pero quema Rubén quicajqui ni tamanti, quinejqui quimanahuis José ten ne sequinoc iicnihua. Huajca quiijto: ―Ma amo tijmictica, ");
INSERT INTO nchBl_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","para amo tijtoyahuase esti. San ma tijmajcahuaca ipan ne ostot cati eltoc ipan ni huactoc tali, pero amo teno ma tijchihuilica. Rubén quiijto ya ni pampa quinequiyaya para teipa quimanahuisquía José huan quihuicasquía campa itata. ");
INSERT INTO nchBl_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Pero quema José ajsito campa itztoyaj iicnihua, inijuanti quiquixtilijque iyoyo cati nelyejyectzi cati moquentijtoya. ");
INSERT INTO nchBl_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Huan quiitzquijque huan quimajcajque ipan nopa ostot cati amo quipiyayaya at pampa huactoya. ");
INSERT INTO nchBl_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Teipa quema mosehuijque para tacuase, quinitaque sequij ismaelitame cati ehuayayaj Galaad ica inincamellos cati quimamayayaj tacualpajti huan taajhuiyacayot ten bálsamo huan mirra, huan yahuiyayaj para tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Huajca Judá quinilhui iicnihua: ―¿Taya tijtanise sinta tijmictise toicni huan tijtatise imiquilis? ");
INSERT INTO nchBl_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Más cuali ma tiquinnamaquiltica ne ismaelitame huan ma amo tijmictica pampa yaya toicni. Huan iicnihua quicualcajque cati quinilhui. ");
INSERT INTO nchBl_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Huajca teipa quema panoque nopona nopa tanamacani cati ehuani tali Madián, iicnihua José quiquixtijque ipan ostot huan quinnamaquiltijque ica 20 plata tomi. Huan nopa tanamacani cati eliyaya iteipan ixhuihua Ismael quihuicaque ipan tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Huan teipa Rubén mocuetqui campa ameli huan amo quipanti José ostoco, quitzayanqui iyoyo pampa neltahuel mocuesohuayaya. ");
INSERT INTO nchBl_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Teipa mocuetqui campa itztoyaj iicnihua huan quinilhui: ―¡Nopa telpocat ayecmo aqui! ¿Taya huelis nijchihuas? ");
INSERT INTO nchBl_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Huan nopa icnime quicuique iyoyo José huan quipolojque ieso se chivo cati quimictijque, ");
INSERT INTO nchBl_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","huan quihuiquilijque inintata huan quiilhuijque: “Tijpantijque ni yoyomit. Xiquita sinta iyoyo mocone o amo.” ");
INSERT INTO nchBl_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Huan quema Jacob quiixmatqui, quiijto: “¡Quena, yaya nopa iyoyo nocone! Se tecuani quicocototzqui huan quicuajqui.” ");
INSERT INTO nchBl_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Huajca Jacob quitzayanqui iyoyo huan moyoyonti ica yoyomit ten tequipacholi huan chocac para miyac tonali pampa mijqui icone. ");
INSERT INTO nchBl_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Huan nochi iconehua quicajcahualtiyayaj para quiyoltalise, pero amo huelqui moyoltalía. Tahuel chocayaya por icone huan quiijtohuayaya: “Nimocuesos por nocone hasta quema nimiquis.” ");
INSERT INTO nchBl_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Huan ipan tali Egipto nopa madianita tacame quinamacaque José ica se tacat cati itoca Potifar cati quipiyayaya se hueyi tequit nopona ihuaya nopa hueyi tanahuatijquet Faraón. Yaya elqui tayacanquet ten nopa tacame cati quimocuitahuiyaya inemilis Faraón. ");
INSERT INTO nchBl_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ipan nopa tonali Judá moiyocaquixti ten iicnihua huan yajqui itztoti ipan pilaltepetzi Adulam huan mocajqui ichaj se tacat cati itoca Hira. ");
INSERT INTO nchBl_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Nopona quiixmatqui iichpoca se cananeo tacat cati itoca Súa huan mosihuajti ihuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Huan conecuic huan quipixqui se icone cati quitocaxti Er. ");
INSERT INTO nchBl_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Sempa conecuic huan quipixqui seyoc icone cati quitocaxti Onán. ");
INSERT INTO nchBl_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Huan noja quipixqui seyoc icone cati quitocaxti Sela cati tacatqui quema inijuanti itztoyaj ipan altepet Quezib. ");
INSERT INTO nchBl_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Judá quisihuajti Er, iachtohui ejca, ica se sihuat cati itoca Tamar. ");
INSERT INTO nchBl_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Pero TOTECO amo quipactiyaya inemilis Er pampa eliyaya nelfiero, yeca quimicti. ");
INSERT INTO nchBl_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Huajca Judá quiilhui itelpoca Onán: ―Ximosejcotili ihuaya icahual moicni quej quinamiqui tijchihuas pampa tiihuejpol huan xijpiya se conet para quiselis cati eliyaya iaxca moicni. ");
INSERT INTO nchBl_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Pero Onán quimatiyaya sinta tacatisquía se conet nochi masehualme quiitasquíaj para icone iicni huan amo ya icone. Yeca quema quinechcahuiyaya ihuejpol, quitoyahuayaya ixinacho talchi para ma amo conecui pampa amo quinejqui quimacas iicni cati mijqui iteipan ixhuihua quej monequiyaya quichihuase. ");
INSERT INTO nchBl_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Huan TOTECO quiitac para fiero cati quichijqui Onán pampa amo quichijqui cati monejqui. Yeca Toteco nojquiya quimicti. ");
INSERT INTO nchBl_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Huajca Judá quiilhui iyex Tamar: ―Ximocahua ticahuali huan xiitztoti ichaj motata hasta moscaltis nocone Sela. Pero amo ya nopa cati Judá moilhuiyaya. Yaya majmahuiyaya para Sela mocuilis Tamar pampa moilhui huelis miquisquía quej iicnihua mijque sinta itztos ihuaya. Huan Tamar yajqui itztoti ichaj itata quej quinahuati. ");
INSERT INTO nchBl_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Huan panoc miyac xihuit huan nojquiya mijqui isihua Judá cati elqui iichpoca Súa. Huan teipa quema Judá ayecmo mocuesohuayaya, yajqui ipan pilaltepetzi Timnat campa itequipanojcahua quinximayayaj iborregojhua. Nojquiya ihuaya yajqui ihuampo, Hira, cati ehuayaya altepet Adulam. ");
INSERT INTO nchBl_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Huan Tamar quimatqui para iyextat yahuiyaya Timnat quinximati iborregojhua, ");
INSERT INTO nchBl_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","huajca moquixtili iyoyo quej cati moquentíaj cahual sihuame huan moixtzajqui ica se yoyomit quej quichihuaj ahuilnenca sihuame huan mosehui iteno pilaltepetzi Enaim cati eltoc ipan ojti para Timnat. Quichijqui ya ni pampa quiitac Sela ya motacachijtoya huan Judá amo quisihuajtijtoya ihuaya. Huajca noja ayemo quipiyayaya se conet quej monejqui para quihuicas ieso huan itoca ihuehue cati mijqui. ");
INSERT INTO nchBl_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Huan Judá quiitac ipan ojti huan moilhui para eliyaya se ahuilnenca sihuat pampa moixtzactoya. ");
INSERT INTO nchBl_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Huajca quicajqui iojhui para quinechcahuis, yon amo quimatqui para eliyaya iyex huan quiilhui: ―Techcahuili ma nimoteca mohuaya. Huan yaya quinanquili: ―¿Taya techmacas sinta nimotecas mohuaya? ");
INSERT INTO nchBl_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Huan Judá quinanquili: ―Nimitztitanilis se pilchivojtzi. Huan ya quiijto: ―Cualtitoc, pero techcahuilijtehua cati moaxca hasta techtitanilis. ");
INSERT INTO nchBl_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Huan Judá quiilhui: ―¿Taya tijnequi ma nimitzcahuilijtehua? Huan Tamar quiijto: ―Techmaca mosello ihuaya imecayo huan mocuatopil cati tijpiya momaco. Huan Judá quimacac huan motejqui ihuaya, huan yaya quiconemacac. ");
INSERT INTO nchBl_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Teipa Tamar moquixtilito cati ica moixtzactoya huan sempa motalili iyoyo quej cati cahual sihuame moquentíaj. ");
INSERT INTO nchBl_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Teipa Judá quititanqui nopa pilchivojtzi ica ihuampo cati ehuayaya altepet Adulam para ma quiilhuiti nopa sihuat ma quicuepili cati iaxca. Pero ihuampo ayecmo quipanti. ");
INSERT INTO nchBl_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Huajca quintatzintoquili cati nopona ehuani: ―¿Canque itztoc nopa ahuilnenca sihuat cati ehua Enaim cati itztoya ojtenti? Huan quinanquilijque: ―Nica amo aqui yon se ahuilnenca sihuat. ");
INSERT INTO nchBl_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Huajca ihuampo tacuepili campa Judá huan quiilhui: ―Amo nijpanti nopa sihuat. Huan nopa masehualme cati nopona ehuani techilhuijque para amo aqui yon se ahuilnenca sihuat nopona. ");
INSERT INTO nchBl_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Huan Judá quiilhui: ―Techhuihuiitase sinta sempa tiyas tijtemoti. Nijchijqui cati niquijto huan nijtitanqui nopa pilchivojtzi huan amo tijpanti. Huajca ma mocahui nopa sihuat cati nijmacac. ");
INSERT INTO nchBl_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Huan quema panotoya eyi metzti, se hualajqui campa Judá huan quiilhui: ―Huelis moyex Tamar tacanentoc pampa quinemiltía se conet ipan itacayo. Huan Judá quiilhui: ―¡Xijquixtica ten nopa altepet huan xijtatica! ");
INSERT INTO nchBl_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Pero quema quiquixtiyayaj, Tamar tatitanqui ma quiilhuitij iyextat: “Nechconemacac yaya cati iaxca ni tamanti. Xiquita cuali ajquiya iaxca ni sello, ihuaya imecayo huan ni cuatopili.” ");
INSERT INTO nchBl_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Huan Judá quiixmatqui nopa tamanti huan quiijto: “Yaya quichijtoc cati cuali huan na, amo. Yaya quinejqui se conet para quihuicas itoca ihuehue cati mijqui huan amo nijtahuicalti ihuaya nocone Sela quej monequiyaya.” Huan Judá ayecmo quema motejqui ihuaya Tamar. ");
INSERT INTO nchBl_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Huan quema ajsic tonali para conepiyas, quinpixqui cuateme. ");
INSERT INTO nchBl_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Huan ipan nopa talojtzi quema tacatiyayaj, se ten inijuanti quiquixti imax, huan nopa cocoxcaitaquet quiilpili se icpat chichiltic huan quiijto: “Ya ni quisqui achtohui.” ");
INSERT INTO nchBl_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Pero teipa nopa pilconetzi quicalaqui imax huan iicni nelía tacatqui achtohui. Yeca nopa cocoxcaitaquet quitocaxti nopa conet Fares. (Fares quinequi quiijtos Cati Moojtapojtoc.) Quej nopa quitocaxti pampa quiijto: “Yaya moojtapo para quisqui achtohui.” ");
INSERT INTO nchBl_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Huan teipa tacatqui nopa seyoc oquichpil cati quipiyayaya nopa icpat chichiltic imaco huan quitocaxti Zara. (Zara quinequi quiijtos Chichiltic.) ");
INSERT INTO nchBl_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Huan nopa ismaelita tanamacani quihuicaque José hasta tali Egipto. Nopona quicojqui se tacat itoca Potifar cati quipixtoya se hueyi tequit ica Tanahuatijquet Faraón. Eliyaya inintayacanca nopa tacame cati quimocuitahuiyayaj inemilis. ");
INSERT INTO nchBl_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Pero TOTECO itztoya ihuaya José huan quichijqui para nochi ma quisa cuali cati José quichijqui ipan ichaj iteco. ");
INSERT INTO nchBl_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Huan iteco quiitac para TOTECO itztoya ihuaya José huan quitiochihuayaya huan nochi cati quichijqui quisqui cuali. ");
INSERT INTO nchBl_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Huan iteco quiicneli huan quitali para ma eli cati más quipalehuisquía. Nojquiya quichijqui ma quinnahuati nochi tequipanohuani ipan ichaj huan quitali imaco nochi cati quipixqui. ");
INSERT INTO nchBl_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Huan ten nopa tonali quema Potifar quicajqui imaco José ichaj huan nochi cati quipixqui, TOTECO pejqui más quitiochihua Potifar, huan iteixmatcahua huan nochi cati quipixqui ipan ichaj huan ipan mila. ");
INSERT INTO nchBl_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Huan Potifar ayecmo mocuatotoniyayaya ica teno, san para tacuas pampa motemachi ipan José. Huan nochi eltoya imaco huan nochi quisayaya cuali. Huan José eliyaya yejyectzi huan nesiyaya se cuali telpocat. ");
INSERT INTO nchBl_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Huan quema panoc tonali, isihua iteco pejqui quiixtoca. Huan se tonali quiilhui: ―Ximoteca nohuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Pero José amo quinejqui huan quiilhui: ―Xiquita, mohuehue quicajtoc nomaco nochi cati quipiya huan quimati sinta nica niitztoc, amo quipiya teno para ica mocuatotonis. ");
INSERT INTO nchBl_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ipan ni cali amo aqui más tayacana que na. Noteco nechmacatoc nomaco nochi para nijchihuas cati na niquitas para cuali. San ica ta amo nijpiya tanahuatili pampa tiisihua. Huajca, ¿quenicatza huelis nitajtacolchihuas ica Toteco Dios huan nijchihuas mohuaya se tamanti cati tahuel fiero? ");
INSERT INTO nchBl_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Huan masque nopa sihuat mojmosta quinotzayaya José ma moteca ihuaya, José amo quichijqui, yon amo quinechcahui campa itztoya. ");
INSERT INTO nchBl_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Pero se tonali José monejqui calaquis ichaj iteco para quichihuas itequi huan amo aquiyaya yon se más tequipanojquet nopona. ");
INSERT INTO nchBl_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Huan nopa sihuat quiitzqui ipan iyoyo huan quiilhui: ―Ximoteca nohuaya. Pero José motalojtejqui huan quicajtejqui iyoyo ipan imax. ");
INSERT INTO nchBl_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Huan quema nopa sihuat quiitac para quicahuilijtejqui iyoyo imaco, ");
INSERT INTO nchBl_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","tzajtzic chicahuac, huan quinnotzqui itatequipanojcahua huan quinilhui: ―Xiquitaca, nopa hebreo tacat cati nohuehue techhualiquili san techpinahualtía. Calajqui nica para techchihualtis ma nimoteca ihuaya, pero na nitzajtzic chicahuac. ");
INSERT INTO nchBl_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Huan quema techcajqui para nitzajtzic ica nochi nochicahualis, motalojtejqui hasta quicajtejqui iyoyo nica. ");
INSERT INTO nchBl_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Teipa nopa sihuat quiajojqui José iyoyo hasta ajsico ihuehue. ");
INSERT INTO nchBl_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Huan quipohuili quej quinpohuilijtoya nopa tequipanohuani huan quiilhui: ―Nopa hebreo cati tijcojqui huan techhualiquili calajqui ipan nocuarto huan quinequiyaya ma nimoteca ihuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Pero quema nitzajtzic chicahuac, motalojtiquisqui huan quicajtejqui iyoyo nica. ");
INSERT INTO nchBl_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Quej nopa nechchijqui motequipanojca cati tijcojqui. Huan iteco José cualanqui miyac quema quicajqui cati isihua quipohuiliyaya. ");
INSERT INTO nchBl_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Huan quiitzqui José huan tanahuati ma quicalaquica ipan tatzacti campa itztoyaj nochi tacame cati nopa hueyi tanahuatijquet quintzactoya. ");
INSERT INTO nchBl_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Pero TOTECO noja itztoya ihuaya José huan quinextili quenicatza quiicnelía pampa quichijqui para nopa tayacanca tetzajquet ma quicualita. ");
INSERT INTO nchBl_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Huan nopa tayacanca tetzajquet quincajqui imaco José nochi sequinoc cati tzactoque. Huan José tanahuatiyaya nochi cati nopona mochihuayaya. ");
INSERT INTO nchBl_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Huan nopa tayacanquet amo monequiyaya mocuatotonis ica teno cati eltoya imaco José pampa TOTECO itztoya ihuaya huan quichihuayaya para nochi ma quisa cuali. ");
INSERT INTO nchBl_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Panoc miyac tonali huan yaya cati quipiyayaya itequi para quiyecos nochi itailis nopa tanahuatijquet ten Egipto para quiitas sinta quipixqui ipajyo quichijqui cati amo quipacti iteco. Huan nojquiya taixpanoc itayacanca panchijca nopa tanahuatijquet. ");
INSERT INTO nchBl_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Huajca Faraón cualanqui inihuaya ni ome itequipanojcahua, ");
INSERT INTO nchBl_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","huan quintitanqui ipan tatzacti cati eltoya ipan ichaj inintayacanca nopa tacame cati quimocuitahuiyayaj. Huan eltoya san sejco campa José tzactoya. ");
INSERT INTO nchBl_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Huan nopa tayacanca tetzajquet quiilhui José ma quinmocuitahui. Huan panoque miyac tonali ipan tatzacti san sejco. ");
INSERT INTO nchBl_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Huan se tayohua yaya cati quiyecohuayaya itailis Faraón huan nopa seyoc cati quichihuayaya ipantzi quipixque sesen temicti. Huan sesen temicti quiijtosnequiyaya sesen tamanti. ");
INSERT INTO nchBl_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Huan ica ijnaloc José quinpantico moneltequipachohuayayaj, ");
INSERT INTO nchBl_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","huan quinilhui: ―¿Para ten anmotequipachohuaj? ");
INSERT INTO nchBl_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Huan quiilhuijque: ―Tijpixque sesen temicti huan amo tijpiyaj ajquiya techpohuilis taya quiijtosnequi. Huan José quinilhui: ―Yaya Toteco Dios cati temachiltía taya quiijtosnequi se tamanti. Huajca techpohuilica taya anquitemijque. ");
INSERT INTO nchBl_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Huajca nopa tacat cati itequi para quiyecos itailis Faraón quiilhui: ―Ipan notemic niquitayaya se xocomeca tzonti, ");
INSERT INTO nchBl_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","cati quipixqui eyi imacuayo. Huan nopa xocomeca cuahuit chamanqui, huan cahuanqui ixochiyo, huan temacac itajca. Huan teipa icsic itajca. ");
INSERT INTO nchBl_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Huan nijpiyayaya nomaco icaxi Faraón. Huan nijcuiyaya nopa xocomecat itajca huan nijpatzcayaya ipan icaxi. Teipa nijtaliyaya imaco Faraón. ");
INSERT INTO nchBl_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Huan José quiilhui: ―Nopa motemic quej ni quinequi quiijtos. Nopa eyi imacuayo elis eyi tonati, ");
INSERT INTO nchBl_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","pampa ica eyi tonati Faraón mitzquixtis nica, huan mitztalis sempa ipan motequi. Huan sempa tijmacas icaxi imaco quej achtohuiya tijchihuayaya. ");
INSERT INTO nchBl_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Quema panos ya nopa, techelnamiqui huan xijchihua se favor, xijcamanalhui Faraón ten na para ma techquixti ipan ni tatzacti. ");
INSERT INTO nchBl_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Techichtejque ipan nopa tali campa itztoque hebreos. Amo quinamiqui niitztos nica pampa amo teno cati amo cuali nijchijtoc. ");
INSERT INTO nchBl_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Huan quema nopa tayacanquet ten panchihuani quiitac cati José quiijtojtoya, quiilhui: ―Nojquiya nijpixqui se temicti huan niquitayaya para niquijpahuijtoya eyi chiquihuit ten pantzi. ");
INSERT INTO nchBl_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Huan nopa chiquihuit cati huejcapa quipiyayaya nochi tamanti pantzi para Faraón, pero totome hualayayaj huan quicuayayaj cati eltoya ipan nochiqui cati niquicpahuijtoya. ");
INSERT INTO nchBl_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Huajca José quinanquili: ―Ya ni cati motemic quinequi quiijtos; nopa eyi chiquihuit ten pantzi elis eyi tonati. ");
INSERT INTO nchBl_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Huan ica eyi tonati Faraón mitzquixtis ten nica huan quichihuas ma mitzcuahuiyonica ipan se cuahuit huan totome quicuase monacayo. ");
INSERT INTO nchBl_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Huan hualhuicta quiaxiti ixihui Faraón huan quichijqui se hueyi ilhuit para nochi cati quihuicayayaj tequit ipan ichaj. Huan iniixpa nochi itanotzalhua, Faraón tatitanqui ma quinquixtica ipan tatzacti yaya cati achtohuiya quiyecohuayaya itailis huan nojquiya nopa tayacanca panchijquet. ");
INSERT INTO nchBl_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Huan cati quiyecohuayaya itailis sempa quitali ipan itequi huan sempa pejqui quimaca icaxi quej achtohuiya. ");
INSERT INTO nchBl_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Pero ica nopa panchijquet tatitanqui ma quicuahuiyonica ipan se cuahuit quej José quiijtojtoya. ");
INSERT INTO nchBl_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Pero masque ya nopa panoc, nopa cati quiyecohuayaya itailis Faraón amo quielnamijqui José. ");
INSERT INTO nchBl_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Quema panotoya ome xihuit, se tonali Faraón quipixqui se temicti. Quitemijqui para ijcatoya iteno nopa hueyat Nilo, ");
INSERT INTO nchBl_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","huan chicome huacaxme cati yejyectzitzi huan tomahuaque quisayayaj ipan nopa hueyat huan tacuajtinemiyayaj. ");
INSERT INTO nchBl_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Huan iniica quisque chicome huacaxme cati fierojtique huan cocoxquetique. Quisque ipan nopa hueyat huan moquetzque iteno nechca nopa sequinoc. ");
INSERT INTO nchBl_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Teipa nopa huacaxme fierojtique huan cocoxquetique quincuajque nopa chicome huacaxme yejyectzitzi huan tomahuaque. Huan Faraón isac. ");
INSERT INTO nchBl_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Teipa sempa cochqui huan quipixqui seyoc temicti. Quiitayaya chicome imacuayo trigo yejyectzitzi cati temitoya ica iyol huan moscaltiyaya ipan san se tzonti. ");
INSERT INTO nchBl_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Huan iniica chamanqui seyoc chicome imacuayo trigo cati huactoc huan pitzantzitzi cati quitatijtoya nopa huac ajacat cati huala campa quisa tonati. ");
INSERT INTO nchBl_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Huan nopa chicome imacuayo trigo cati huactoc quincuajque nopa chicome imacuayo cati tomahuac huan temitoc. Huan Faraón isac huan momacac cuenta para eliyaya se temicti. ");
INSERT INTO nchBl_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Pero ica ijnaloc moneltequipachohuayaya huan tanahuati ma hualaca nochi tetonalitani huan nochi talnamijca tacame ipan tali Egipto. Huan Faraón quinpohuili itemic, pero yon se ten inijuanti amo huelqui quiilhui taya quinequiyaya quiijtos. ");
INSERT INTO nchBl_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Huajca nopa tacat cati quipixqui itequi para quiyecos itailis Faraón quielnamijqui José huan quiilhui Faraón: ―Ama niquelnamiqui cati amo cuali nijchijtoc. ");
INSERT INTO nchBl_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Quema ticualanqui nohuaya huan ihuaya nopa tayacanca panchijquet, techtitanqui tiome ipan nopa tatzacti ipan ichaj nopa tayacanquet ten nopa tacame cati mitzmocuitahuíaj. ");
INSERT INTO nchBl_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Huan se tayohua nopa panchijquet huan na, tijpixque sesen temicti. Huan sesen temicti quipixqui cati quinequiyaya quiijtos. ");
INSERT INTO nchBl_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Huan nopona ipan nopa tatzacti itztoya tohuaya se hebreo telpocat cati quitequipanojtoya nopa tayacanquet. Huan tijpohuilijque totemic huan nopa hebreo techilhui taya quiijtosnequi. ");
INSERT INTO nchBl_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Huan nochi panoc san quej techilhui. Na nitacuepili sempa ipan notequi huan nopa seyoc quicuapilojque. ");
INSERT INTO nchBl_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Huajca Faraón tatitanqui ma quinotzatij José huan nimantzi quiquixtijque ten nopa tatzacti. Huan José malti, huan motentzonxinqui, huan quipatac iyoyo huan monexti iixpa Faraón. ");
INSERT INTO nchBl_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Huan Faraón quiilhui: ―Nijpixqui se temicti huan amo aqui hueltoc quiixtoma, pero nijcactoc quema tijcaqui se temicti, hueli tiquixtoma. ");
INSERT INTO nchBl_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Huan José quinanquili: ―Amo nihueli na, pero Toteco Dios, quena. Yaya mitznextilis taya quinequi quiijtos motemic. ");
INSERT INTO nchBl_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Huan Faraón quiilhui José: ―Ipan notemic, niquitayaya para niijcatoya iteno nopa hueyat Nilo, ");
INSERT INTO nchBl_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","huan ipan nopa hueyat quisque chicome huacaxme tomahuaque huan yejyectzitzi cati tacuajtinemiyayaj. ");
INSERT INTO nchBl_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Huan iniica quisque seyoc chicome huacaxme cati fierojtique huan cocoxquetique. ¡Amo quema niquinitztoya huacaxme nelfierojtique ipan nochi tali Egipto! ");
INSERT INTO nchBl_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Huan ni huacaxme cocoxquetique huan fierojtique quincuajque nopa achtohui huacaxme cati tomahuaque. ");
INSERT INTO nchBl_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Pero masque quincuajque, amo tomahuixque. Noja eliyayaj cocoxquetique quej achtohui. “Huan teipa niisac. ");
INSERT INTO nchBl_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Teipa nijtemijqui chicome imacuayo trigo yejyectzitzi huan tomahuaque cati temitoya ica iyol huan moscaltiyayaj ipan san se tzonti. ");
INSERT INTO nchBl_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Huan iniica moscaltiyaya seyoc chicome imacuayo cati tzocoyoltic, huan pitzantzitzi, huan huactoya ica nopa huac ajacat cati huala campa quisa tonati. ");
INSERT INTO nchBl_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Huan ni chicome imacuayo cati pitzantzitzi quincuajque nopa chicome imacuayo cati tomahuaque. Na niquinpohuili notemic nopa tacame cati tetonalitaj, pero yon se amo huelqui nechilhuis taya quiijtosnequi.” ");
INSERT INTO nchBl_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Huajca José quiilhui Faraón: ―Nopa ome temicti cati tijpixqui, san se. Toteco Dios mitzyolmelajtoc cati yaya quichihuas. ");
INSERT INTO nchBl_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Nopa chicome huacaxme cati yejyectzitzi quinequi quiijtos chicome xihuit. Huan san se quiijtosnequi nopa chicome imacuayo trigo cati yejyectzitzi. ");
INSERT INTO nchBl_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Huan nopa chicome huacaxme cocoxquetique huan fierojtique cati quisque iniica nopa sequinoc, quinequi quiijtos seyoc chicome xihuit. Huan san se quiijtosnequi nopa chicome imacuayo trigo cati amo moscalti huan cati quihuatzqui nopa huac ajacat cati huala campa quisa tonati. Quinequi quiijtos chicome xihuit quema amo teno oncas. ");
INSERT INTO nchBl_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ya ni panos san quej nimitzilhuijtoc pampa Toteco Dios mitznextilijtoc cati ya quichihuas. ");
INSERT INTO nchBl_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Hualas chicome xihuit quema oncas tahuel miyac pixquisti ipan nochi tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Huan teipa hualas chicome xihuit cati amo teno oncas. Huan nopa mayanti ajsis campa hueli ipan nochi tali Egipto hasta amo aqui quielnamiquis nopa xihuit cati cuali. ");
INSERT INTO nchBl_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Elis nelhueyi nopa mayanti hasta amo nesis cati achtohuiya oncac. ");
INSERT INTO nchBl_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ta tijpixqui nopa temicti ompa pampa Toteco Dios motalijtoc quichihuas ni tamanti huan quichihuas nimantzi. ");
INSERT INTO nchBl_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Huajca xijtemo se tacat cati cuali iyolo huan cati talnamiqui para tayacanas ipan ni tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Huan ya ni xijchihua, totanahuatijca. Xijnahuati ma quintali gobernadores campa hueli ipan nochi ni tali para quiajocuise se coxtali ten sesen macuili coxtali cati quipixcase ipan tali Egipto ipan nochi nopa chicome xihuit quema tahuel taelis. ");
INSERT INTO nchBl_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ma quisentilica nopa trigo ipan nochi altepeme ipan nopa chicome cuali xihuit cati huala huan ma quitalica campa ta tijnahuatis, totanahuatijca. Huan teipa oncas tacualisti para nochi masehualme. ");
INSERT INTO nchBl_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Quej nopa, mocahuas ajoctoc nopa trigo ipan total para masehualme amo apismiquise ipan nopa chicome xihuit quema oncas mayanti.” ");
INSERT INTO nchBl_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Huajca Faraón huan itapalehuijcahua quicualcajque cati José quiijto, ");
INSERT INTO nchBl_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","huan Faraón quinilhui: ―¿Canque tijpantise seyoc tacat quej ya ni cati quipiya itonal Toteco Dios? ");
INSERT INTO nchBl_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Huan teipa Faraón quiilhui José: ―Amo aqui cati más talnamiqui huan cati más quimati que ta. San ta mitzmatiltijtoc Toteco Dios nochi ni tamanti. ");
INSERT INTO nchBl_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Huajca momaco mocahuas nochi cati noaxca huan nochi nomasehualhua quineltocase cati tiquinilhuis. San na nielis más hueyi que ta pampa na nihueyi tanahuatijquet. ");
INSERT INTO nchBl_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Xiquita, na nimitztalía tigobernador ipan nochi ni tali Egipto. Quema quiijto ya ni, ");
INSERT INTO nchBl_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Faraón moquixtili ipan imax ianillo cati quipixtoya nopa sello cati quinexti itanahuatil huan quitalili imax José. Teipa tanahuati ma quiyoyontica ica lino yoyomit cati nelcuali huan ma quitalilica iquechta se costi ten oro. ");
INSERT INTO nchBl_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Quichijqui nopa ompa tanahuatijquet huan quiilhui ma tejco ipan iompa carro. Huan quinnahuati itequipanojcahua ma quiyacantiyaca huan chicahuac ma teyolmelahuase: “¡Ximotancuaquetzaca! ¡Huala tanahuatijquet!” Quej nopa Faraón quitali José para ma tanahuati ipan nochi nopa tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Huan teipa Faraón quiilhui: ―Na nimitzmaca motequiticayo huan yon se ipan nochi Egipto huelis quiolinis imacpil sinta amo tijmaca tanahuatili. ");
INSERT INTO nchBl_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Huan Faraón quitocaxtali José, Zafnat Panea, huan quisihuajti ihuaya Asenat, iichpoca Potifera nopa totajtzi ipan altepet On. Huan campa hueli ipan tali Egipto nochi quiixmatque José. ");
INSERT INTO nchBl_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Huan José quipiyayaya 30 xihuit quema pejqui quitequipanohua Faraón, nopa tanahuatijquet ipan tali Egipto. Teipa José quinahuatijtejqui Faraón huan pejqui yahui campa hueli ipan nochi tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Huan nopa tali temacac miyac pixquisti ipan nopa chicome xihuit quema tahuel oncac, ");
INSERT INTO nchBl_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","huan José quiajojqui miyac trigo ipan nopa altepeme. Quicajtiyajqui ipan sese altepet nopa trigo cati quisentilijque ipan nopa pilaltepetzitzi nechca. ");
INSERT INTO nchBl_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Huan José quisentili miyac trigo quej imiyaca xali iteno hueyi at. Nelmiyac eliyaya nopa trigo hasta ayecmo quiijcuilo quesqui coxtali pampa amo hueliyaya quipohuaj. ");
INSERT INTO nchBl_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Huan quema ayemo pehuayaya nopa xihuit ten mayanti, José quinpixqui ome iconehua ihuaya isihua, Asenat. ");
INSERT INTO nchBl_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Nopa achtohui quitocaxti Manasés. (Manasés quinequi quiijtos Niquinelcajtoc.) Quej nopa quitocaxti pampa quiijto: “Toteco Dios quichijtoc ma niquelcahua noteixmatcahua huan nochi cati nitaijyohuijtoc.” ");
INSERT INTO nchBl_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Huan iompa cone quitocaxti Efraín. (Efraín quinequi quiijtos Temaca Itajca.) Quej nopa quitocaxti pampa quiijto: “Toteco Dios quichijtoc ma niquinpiya noconehua ipan ni tali campa nitaijyohuijtoc.” ");
INSERT INTO nchBl_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Huan tanqui nopa chicome xihuit quema tahuel oncac pixquisti ipan tali Egipto, ");
INSERT INTO nchBl_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","huan pejqui nopa chicome xihuit quema amo oncac pixquisti quej José quiijto. Huan oncac mayanti ipan nochi talme nechca, pero ipan tali Egipto oncayaya tacualisti. ");
INSERT INTO nchBl_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Huan quema Egipto ehuani pejque mayanaj, yajque quitajtanitoj trigo Faraón huan Faraón quinilhui nochi egiptome: “Xiyaca xiquitatij José huan xijchihuaca cati ya amechilhuis.” ");
INSERT INTO nchBl_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Huan quema nopa mayanti ajsic campa hueli ipan nochi nopa tali, José quitapo nochi nopa huejhueyi calme campa quiajoctoyaj trigo para quinnamaquiltis nopa egiptome pampa nopa mayanti eliyaya tahuel chicahuac. ");
INSERT INTO nchBl_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Huan masehualme cati ehuani ten campa hueli talme ajsiyayaj ipan tali Egipto para quicohuase trigo ica José pampa ipan nochi nopa talme, amo teno oncayaya para quicuase. ");
INSERT INTO nchBl_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Quema Jacob quimatqui para oncayaya trigo ipan tali Egipto, quinilhui itelpocahua: “¿Para ten anmochiyaj se ica seyoc para anquiitase ajquiya techpalehuis? ");
INSERT INTO nchBl_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nechilhuijtoque para ipan tali Egipto onca trigo. Xiyaca nepa huan xijcohuatij para noja tiitztose.” ");
INSERT INTO nchBl_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Huajca majtacti ten iicnihua José yajque tali Egipto quicohuatij trigo. ");
INSERT INTO nchBl_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Pero Jacob amo quicahuili ma yahui Benjamín, inelicni José pampa moilhui nohueli ipantisquía se tamanti cati fiero. ");
INSERT INTO nchBl_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Huajca itelpocahua Israel yajque inihuaya nochi sequinoc cati yahuiyayaj tacohuatij pampa campa hueli ipan nochi tali Canaán oncayaya mayanti. ");
INSERT INTO nchBl_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Huan José eliyaya gobernador ipan tali Egipto huan yaya cati quinnamaquiltiyaya trigo nochi masehualme cati ajsiyayaj ten campa hueli talme. Huan quema iicnihua José monextijque iixpa, motancuaquetzque huan mohuijtzonque talchi quej momatque tatepanitaj. ");
INSERT INTO nchBl_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Huan José quinixmatqui iicnihua quema quinitac, pero quichijqui quej amo quinixmatiyaya. Quincamanalhui ica cualanti huan quinilhui: ―¿Canque anhualahuij? Huan quiilhuijque: ―Tihualahuij tali Canaán para titacohuaquij. ");
INSERT INTO nchBl_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Huan masque José quinixmatqui iicnihua, inijuanti amo quiixmatque. ");
INSERT INTO nchBl_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Huan quielnamijqui nopa temicti cati quipixqui ten iicnihua achtohuiya huan quinilhui: ―Amo neli anhualahuij para antacohuase. Anhualajtoque anquiitaquij quenicatza eltoc total huan canica huelis antechtanise. ");
INSERT INTO nchBl_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Huan inijuanti quinanquilijque: ―¡Amo, tate! Timotequipanojcahua tihualajtoque tijcohuaquij trigo. ");
INSERT INTO nchBl_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nochi tojuanti tiiconehua san se tacat. Ticuajcualme. Amo quema tiyajtoque ipan se altepet para tijtachilise quenicatza huelis tijtanise. ");
INSERT INTO nchBl_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Huan José quiijto: ―¡Amo neli! Anhualahuij para anquiitaquij quenicatza huan canica huelis antechtanise ipan total. ");
INSERT INTO nchBl_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Pero inijuanti tananquilijque: ―Timotequipanojcahua tiitztoque 12 tiicnime ica san se tacat huan tiitztoque ipan tali Canaán. Toicni teipan ejquet mocajqui ihuaya totata huan se ayecmo aqui tohuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Pero José sempa quinilhui: ―Temachti amojuanti antachiyani, ");
INSERT INTO nchBl_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","pero ica ya ni tiquitase. Ica itanahuatil Faraón, nitanahuatía para amo huelis anquisase nica hasta ma huala amoicni teipan ejquet. ");
INSERT INTO nchBl_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ma yahui se ten amojuanti para quicuiti. Nopa sequij mocahuase tzactoque. Tiquitase sinta nelía cati anquiijtojtoque. Sinta amo, huajca nijmatis melahuac antachiyaj pampa anquinequij antechtanise. ");
INSERT INTO nchBl_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Huan José quintzajqui nochi inijuanti para eyi tonati, ");
INSERT INTO nchBl_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","pero ica ihualhuictaca quinilhui: ―Na nijtepanita Toteco Dios, huajca xijchihuaca ya ni huan nimechcahuilis anitztose. ");
INSERT INTO nchBl_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Sinta nelía ancuajcualme, ma mocahua tzactoc san se ten amojuanti. Huan sequinoc amojuanti xijhuicaca trigo para ma tacuaca amofamilia. ");
INSERT INTO nchBl_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Pero monequi techhualiquilica amoicni teipan ejquet para tiquitase sinta anquiijtojtoque cati melahuac. Pero sinta amo, huajca anmiquise. Huan inijuanti quicualcajque, ");
INSERT INTO nchBl_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","pero moilhuiyayaj se ica seyoc: ―Melahuac fiero tijchihuilijque toicni. Amo tijtacaquilijque quema tahuel mocuesohuayaya huan techtajtaniyaya ma tijtasojtaca. Huan yeca ama topani eltoc ni cuesoli. ");
INSERT INTO nchBl_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Huan Rubén quinilhui: ―Na nimechilhui para amo teno xijchihuilica, pero amo antechcajque huan ama monequi titaxtahuase por imiquilis. ");
INSERT INTO nchBl_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Pero amo quimatiyayaj sinta José quimachiliyaya inincamanal pampa José quinnojnotzayaya ica inincamanal egiptome huan seyoc quinixtomiliyaya cati quiijtohua. ");
INSERT INTO nchBl_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Huan José mohuejcatali ten iicnihua para amo huelis quiitase huan pejqui choca. Teipa moyoltali huan mocuetqui campa itztoyaj para quincamanalhui. Huan quiiyocaquixti Simeón huan iniixpa quinnahuati itequipanojcahua ma quiilpica. ");
INSERT INTO nchBl_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Teipa tanahuati ma quintemitilica inincoxtalhua iicnihua huan ma quicuepilica sese itomi ipan inincoxtal. Nojquiya tanahuati ma quinmacaca tacualisti para ipan ojti. Huan itequipanojcahua quej nopa quichijque. ");
INSERT INTO nchBl_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Huan quintamamaltijque ininburrojhua huan quistejque. ");
INSERT INTO nchBl_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Huan quema ajsitoj campa tonilisquíaj, se ten inijuanti quitapo icoxtal para quitamacas iburro huan quiitac itomi eltoya icoxtalijtic. ");
INSERT INTO nchBl_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Huajca quinilhui iicnihua: ―¡Xiquitaca nechcuepilijque notomi! ¡Nica eltoc ipan nocoxtal! Huan nochi momajmatijque miyac, huan huihuipicayayaj huan moilhuiyayaj se ica seyoc: ―¿Taya techchihuilijtoc Toteco Dios? ");
INSERT INTO nchBl_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Huan quema ajsitoj tali Canaán, quipohuilijque inintata, Jacob, nochi cati quinpanotoya, quiilhuijque: ");
INSERT INTO nchBl_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","―Nopa tacat cati tanahuatía ipan nopa tali technojnotzqui ica cualanti huan techilhui para san tiyajtoyaj titajtachiyatij ipan ital para huelis tijtanisquíaj. ");
INSERT INTO nchBl_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Pero tiquilhuijque para ticuali masehualme huan amo quema tijtajtachilijtoque se tali. ");
INSERT INTO nchBl_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Tiquilhuijque para tieliyayaj 12 tiicnime ten san se tacat, huan se ayecmo itztoc tohuaya. Nojquiya tiquilhuijque para nopa teipan ejquet mocajtoya mohuaya ta nica ipan Canaán. ");
INSERT INTO nchBl_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Huajca ya techilhui para monequi quiitas sinta nelía ticuajcualme. Quiijto monequi se ten tojuanti ma mocahua nopona huan para nopa sequinoc tojuanti ma tijhualicaca trigo para tofamilias cati mayanaj, ");
INSERT INTO nchBl_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","pero quiijto teipa monequi tijhuiquilise toicni teipan ejquet. Quej nopa quiijto para melahuac quimatis sinta ticuali masehualme o san titachiyani. Huan quiijto para quej nopa quimajcahuas toicni huan huelis titacohuase ipan ital ica cuali. ");
INSERT INTO nchBl_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Huan quema iicnihua José quiixcuetque inincoxtal, quiitaque para ipan sese inincoxtal oncayaya ininpilbolsa ica nopa tomi cati quihuicatoyaj. Huajca inijuanti huan inintata momajmatijque. ");
INSERT INTO nchBl_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Huan Jacob quinilhui: ―Antechquixtilise nochi noconehua. José ayecmo aqui tohuaya, Simeón nojquiya, huan ama antechquixtilise Benjamín. Amo teno quisa cuali para na. ");
INSERT INTO nchBl_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Huajca Rubén quiilhui itata: ―Xijcahua Benjamín ma yahui. Huan nijmocuitahuis huan nimitzcuepilis. Sinta amo nimitzcuepilis, huelis tiquinmictis nochi ome noconehua. ");
INSERT INTO nchBl_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Pero Jacob quiilhui: ―Nocone amo yas amohuaya. Iicni ya mijqui huan san ya mocahua. Sinta ipantis cati fiero ipan ojti, antechchihuilise ma nihuehuejmiqui ica tequipacholi. ");
INSERT INTO nchBl_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Huan nopa mayanti más eliyaya ipan inintal. ");
INSERT INTO nchBl_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Huan Jacob huan iteixmatcahua quitamicuajque nochi nopa trigo cati quicuitoj ipan tali Egipto, huajca quinilhui itelpocahua: ―Xiyaca sempa xijcohuatij trigo. ");
INSERT INTO nchBl_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Pero Judá quiilhui: ―Nopa tacat ya techilhuijtoc para amo huelis tiquitase sinta amo tijhuicase toicni teipan ejquet. ");
INSERT INTO nchBl_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Huajca sinta tijcahuas ma yahui tohuaya Benjamín, tiyase tijcohuatij trigo. ");
INSERT INTO nchBl_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Pero sinta amo tijcahuas ma yahui, amo tiyase pampa san tapic. Nopa tacat techilhui sinta amo tijhuicaj toicni teipan ejquet, amo huelis tiquitase. ");
INSERT INTO nchBl_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Huajca Israel quiijto: ―¿Para ten antechchihuilíaj cati fiero huan anquiilhuijque nopa tacat para anquipiyayayaj seyoc amoicni? ");
INSERT INTO nchBl_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Huan inijuanti quiilhuijque: ―Tiquilhuijque pampa ya techtatzintoquiliyaya miyac ten tojuanti huan tofamilias. Techtatzintoquili sinta noja itztoc totata, huan sinta tijpiyaj seyoc toicni. Huan san tijnanquiliyayaj cati techtatzintoquiliyaya. ¿Quenicatza tijmatisquíaj para techilhuisquía ma tijhuiquilica toicni? ");
INSERT INTO nchBl_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Huan Judá quiilhui Israel, itata: ―Sinta tijnequi ma tiitztoca, xijcahuili ma yahui Benjamín, huan na nijmocuitahuis huan tiyase nimantzi. Quej nopa amo timiquise, yon ta, yon tojuanti, yon toconehua. ");
INSERT INTO nchBl_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Huan sinta ten hueli ipantis, na notajtacol. Sinta amo nimitzcuepilis, huajca nijhuicas tajtacoli moixpa para nochipa. ");
INSERT INTO nchBl_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Sinta amo tihuejcajtosquíaj, ya tiyajtosquíaj huan ya tihualajtosquíaj ompa. ");
INSERT INTO nchBl_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Huajca itata quinilhui: ―Ayecmo onca seyoc tamanti cati hueli tijchihuase, huajca ama xijchihuaca ya ni. Xijtemilica amocoxtal tamanti cati más cuali cati temaca ni total para xijtamajmacatij nopa tacat. Xijhuiquilica quentzi bálsamo, sayolnecti, taajhuiyacayot, mirra, huan almendras huan nopa nueces cati itoca pistache cati nelía ajhuiyac. ");
INSERT INTO nchBl_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Xijhuicaca nojquiya ome huelta imiyaca nopa tomi cati amechcuepilijque ipan amocoxtal. Nohueli mocuapolojque. ");
INSERT INTO nchBl_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Huan xijhuicaca amoicni Benjamín huan sempa xiquitatij nopa tacat. ");
INSERT INTO nchBl_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Toteco Dios Cati Quipiya Nochi Chicahualisti ma amechtasojta. Ma amechpalehui iixpa nopa tacat para ma quicahuili nopa seyoc amoicni huan Benjamín para ma hualaca amohuaya. Huan ica na, sinta monequi niquinpolos noconehua, huajca quej nopa ma eli. ");
INSERT INTO nchBl_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Huajca itelpocahua Jacob quihuicaque iniicni, Benjamín, huan tamanti cati temajmacatij, huan ome hueltas imiyaca tomi. Teipa quistejque, moisihuiltijque yajque tali Egipto huan monextitoj iixpa José. ");
INSERT INTO nchBl_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Huan quema José quiitac Benjamín inihuaya hualayaya, quiilhui itequipanojca cati más tayacana ipan ichaj: ―Xiquinhuica ni tacame nochaj, huan xijmicti se huacax huan xijcualtali pampa tacuase nohuaya tajcotona. ");
INSERT INTO nchBl_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Huan nopa tequipanojquet quichijqui quej José quinahuati huan quinhuicac ichaj. ");
INSERT INTO nchBl_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Pero inijuanti momajmatijque pampa quinhuicayaya ichaj José huan moilhuijque: ―Techhualicatoc nica por nopa tomi cati techcuepilijque quema achtohui tihualajque. Ama quiijtos tiquichtequilijque, huan techquixtilis totapiyalhua huan techitzquise. Techchihualtise ma titequitica quej titequipanohuani cati quincojtoc. ");
INSERT INTO nchBl_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Huajca quema ajsitoj campa calaquij ipan ichaj José, monechcahuijque campa nopa tayacanca tequipanojquet, ");
INSERT INTO nchBl_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","huan quiilhuijque: ―¡Tate, techtacaquili! Quema achtohui tihualajque tijcohuacoj trigo, ");
INSERT INTO nchBl_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","tiquistejque ica totrigo huan tiajsitoj campa ticochisquíaj ipan ojti. Huan tijtapojque tocoxtalhua, huan icamaco sesen coxtali eltoya totomi sesen tojuanti. Eltoya ajsitoc totomi cati ica tijcojtoyaj nopa trigo. Huan ama tijhualicatoque para tijcuepase. ");
INSERT INTO nchBl_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Huan iyoca tijhualicaque más tomi para tijcohuase más trigo. Pero amo tijmatij ajquiya quitali totomi ipan tocoxtalhua. ");
INSERT INTO nchBl_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Huan nopa tayacanca tequipanojquet quinilhui: ―Amo ximocuesoca. Dios amoTeco huan iTeco amotata, huelis yaya quitali nopa tomi ipan amocoxtalhua pampa na nijseli nopa tomi cati antechmacaque. Huan nopa tequipanojquet quiquixti Simeón huan quihualicac campa itztoyaj nopa icnime. ");
INSERT INTO nchBl_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Teipa quinhuicac san sejco hasta ichaj José. Huan quinmacac at para ma moicxipajpacaca huan nojquiya quintamacac ininburrojhua. ");
INSERT INTO nchBl_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Huan inijuanti quicualtalijque cati quimacasquíaj José huan quichixque para ma ajsi tajcotona pampa quicactoyaj para tacuasquía inihuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Huan quema José ajsito ichaj, quimacaque cati quihuiquilijtoyaj, huan motancuaquetzque huan mohuijtzonque hasta talchi para quitepanitase. ");
INSERT INTO nchBl_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Huan José quintatzintoquili quenicatza itztoyaj huan nojquiya quinilhui: ―¿Quenicatza itztoc amotata, nopa tatatzi cati antechcamanalhuijque? ¿Noja itztoc? ");
INSERT INTO nchBl_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Huan inijuanti quiilhuijque: ―Totata, motequipanojca, noja itztoc huan itztoc cuali. ");
INSERT INTO nchBl_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Huan José quiixtemo Benjamín hasta quipanti. Elqui inelicni cati quitacatilti inana. Huan José quiijto: ―¿Ya ni amoicni teipan ejquet cati antechcamanalhuijque? Huan José quiilhui Benjamín: ―¡Ma Toteco Dios mitztiochihua, nocone! ");
INSERT INTO nchBl_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Huan quema José quiijto ya ni, monejqui moyoltetilis para amo chocas iniixpa pampa sempa quiitac iicni. Huan nimantzi quistihuetzqui, huan calajqui ipan icuarto huan nopona tahuel miyac chocac. ");
INSERT INTO nchBl_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Teipa quema huelqui moyoltali, mixami huan mocuetqui campa itztoyaj iicnihua. Teipa quinilhui itequipanojcahua: “¡Xijtecaca ne tacualisti!” ");
INSERT INTO nchBl_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Huan quitequilijque José itacualis iseltitzi ipan se mesa, huan iicnihua ipan seyoc. Huan ipan seyoc mesa quintequilijque nopa egiptome cati tacuayayaj ihuaya José. Pampa tali Egipto ehuani quinijiyayayaj hebreo masehualme huan amo tacuayayaj inihuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Huan José quinilhui sese iicnihua canque mosehuise. Quinsehui quej tacajtiyajque ten achtohui ejquet hasta cati teipan ejquet. Pejqui ica cati más hueyi hasta cati más pisiltzi. Huan nopa icnime san motachilijque. ");
INSERT INTO nchBl_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Huan quema quintequilijque nopa tacualisti cati eltoya ipan imesa José, Benjamín quitequilijque macuili hueltas más imiyaca que cati quintequilijque ne sequinoc. Huan quej nopa san sejco taique huan tacuajque. ");
INSERT INTO nchBl_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Teipa José quiilhui itayacanca tequipanojca: ―Xijtemiti inincoxtal ni tacame ica nochi trigo cati hueli quihuicase huan xijtali sese inintomi ipan icamac inincoxtal. ");
INSERT INTO nchBl_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Nojquiya xijtali nocaxi ten plata ipan icoxtal iniicni cati teipan ejquet, ihuaya nopa tomi cati taxtajqui para trigo. Huan nopa tequipanojquet quichijqui quej José quinahuatijtoya. ");
INSERT INTO nchBl_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Huan quema sanoc tanestoya, José quincahuili iicnihua ma yaca ihuaya ininburrojhua. ");
INSERT INTO nchBl_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Pero ayemo huejca yajtoyaj ten nopa altepet quema José quiilhui itequipanojca: ―Xiya xiquintoquili nopa tacame huan quema tiquinajsiti, xiquinilhui: ‘¿Para ten anquicuectoque cati cuali ica cati amo cuali? ¿Para ten anquiichtectoque nopa caxit ten plata ");
INSERT INTO nchBl_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","cati noteco quitequihuía para ipan atis huan para quiitas cati panos teipa? ¡Anquichijtoque cati fiero!’ ");
INSERT INTO nchBl_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Huan quema nopa tequipanojquet quinajsito, quinilhui nochi ya ni. ");
INSERT INTO nchBl_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Huan nopa icnime quiilhuijque: ―¿Para ten techcamanalhuía quej nopa? ¡Amo quema tijchihuasquíaj nopa tamanti! ");
INSERT INTO nchBl_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Xiquita, sempa tijhualicaque ten tali Canaán nopa tomi cati eltoya ipan tocoxtal. ¿Quenicatza tiquichtequise oro o plata ten ichaj moteco? ");
INSERT INTO nchBl_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","¡Ma miqui cati hueli ten tojuanti cati tijpantilis nopa caxit huan nochi tojuanti timitztequipanose san tapic! ");
INSERT INTO nchBl_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Huajca nopa tequipanojquet quiijto: ―Cualtitoc cati anquiijtohuaj, pero san yaya cati quipiya nopa caxit techtequipanos san tapic. Nopa sequij amo quipiyase tajtacoli. ");
INSERT INTO nchBl_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Huan sesen ten inijuanti nimantzi quitemohui icoxtal huan quitapo. ");
INSERT INTO nchBl_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Huan nopa tequipanojquet quitemo ipan sesen coxtali. Pejqui ica cati achtohui ejquet hasta nopa teipan ejquet huan quipanti nopa caxit ipan Benjamín icoxtal. ");
INSERT INTO nchBl_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Huajca quitzayanque iniyoyo ica hueyi tequipacholi. Huan teipa quintamamaltijque ininburrojhua huan mocuetque ipan nopa altepet. ");
INSERT INTO nchBl_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Huan quema Judá huan iicnihua ajsitoj ichaj José, ya noja itztoya nopona. Huan motancuaquetzque iixpa huan mohuijtzonque talchi, ");
INSERT INTO nchBl_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","huan José quinilhui: ―¿Taya anquichijtoque? ¿Amo anquimatij para se tacat quej na quimati cati quichihuaj sequinoc? ");
INSERT INTO nchBl_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Huan Judá quiijto: ―¿Taya huelis timitznanquilise? ¿Quenicatza huelis tijnextise para amo tijchijtoque? Toteco Dios techpantijtoc titajtacolchijtoque. Huajca nica tiitztoque huan timitztequipanose san tapic ihuaya cati quipixtoya nopa caxit. ");
INSERT INTO nchBl_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Pero José quiijto: ―Amo, amo quej nopa. San ya ne cati quipiyayaya nopa caxit techtequipanos san tapic. Huan nopa sequinoc ten amojuanti huelis antacuepilise ica cuali hasta ichaj amotata. ");
INSERT INTO nchBl_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Huajca Judá monechcahui campa José huan quiilhui: ―Na nimitztajtanía, noteco, para techcahuili nimitzilhuis se tamanti cati amo aqui quimati. Xijchihua se favor, amo xicualani nohuaya pampa tieltoc quej Faraón. ");
INSERT INTO nchBl_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Achtohui ta techtatzintoquili sinta tijpiyayayaj totata huan ten seyoc totaca icni. ");
INSERT INTO nchBl_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Huan timitzilhuijque para tijpiyaj totata cati huehuentzi huan tijpiyaj se toicni cati neltelpocat cati tacatqui quema totata eliyaya nelhuehuentzi. Huan timitzilhuijque para totata quiicnelía miyac. San ya mocahua ten inana. Nopa seyoc iicni ya mijqui. ");
INSERT INTO nchBl_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Huajca techtajtani ma tijhualicaca pampa tijnequiyaya tiquixmatis. ");
INSERT INTO nchBl_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Huan timitzilhuijque nopa telpocat amo hueli quicajtehua itata. Sinta quicajtehuasquía, itata miquisquía. ");
INSERT INTO nchBl_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Pero ta techilhui sinta ya amo hualasquía tohuaya, ayecmo techselisquía. ");
INSERT INTO nchBl_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Huajca quema timocuetque campa totata, tijpohuilijque nochi cati techilhuijtoya. ");
INSERT INTO nchBl_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Huan teipa totata techilhui ma tihualaca tijcohuaquij se quentzi trigo. ");
INSERT INTO nchBl_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Pero tiquilhuijque para amo hueli tihualase sinta toicni teipan ejquet amo hualas tohuaya. Sinta amo tohuaya huala, amo huelis timitzitase. ");
INSERT INTO nchBl_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Huan totata techilhui: ‘Anquimatij nosihua nechmacac ome noconehua. ");
INSERT INTO nchBl_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Huan se ten nopa ome quisqui huan nimoilhuía se tecuani quicuajqui pampa hasta ama ayecmo niquitztoc. ");
INSERT INTO nchBl_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Sinta anquihuicaj huejca ni seyoc nocone huan sinta ipantis se tamanti cati fiero, antechchihuase ma nihuehuejmiqui ica tequipacholi.’ ");
INSERT INTO nchBl_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Yeca sinta toicni amo tacuepilis tohuaya, ");
INSERT INTO nchBl_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","totata cati ya nelhuehuentzi nimantzi miquis ica tequipacholi pampa amo quiitas. Huan tijhuicase tajtacoli por imiquilis. ");
INSERT INTO nchBl_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Na niquilhui notata para ma quicahua nomaco huan nijmocuitahuisquía. Nojquiya niquilhui para sinta amo nijcuepilis, huajca nijhuicas tajtacoli iixpa para nochipa. ");
INSERT INTO nchBl_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Yeca nimitztajtanía, techcahuili ma nimocahua na para nimitztequipanos huan amo ya. Xijcahuili ma tacuepili ihuaya iicnihua. ");
INSERT INTO nchBl_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","¿Pampa quenicatza huelis nitacuepilis huan niquitas notata, sinta noicni amo yahui nohuaya? Amo nijnequi niquitas quenicatza taijyohuis notata.” ");
INSERT INTO nchBl_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Huan José ayecmo huelqui moijyohuía para amo chocas iniixpa itequipanojcahua cati itztoyaj nopona. Huan chicahuac quinilhui: “¡Xiquisaca nochi amojuanti cati anitztoque nica!” Huajca nochi itapalehuijcahua quisque pampa José quinequiyaya itztos iseltitzi ica iicnihua quema quinilhui ajquiya ya. ");
INSERT INTO nchBl_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Huan yaya pejqui choca chicahuac hasta nochi nopa egiptome ipan ichaj quicajque. Huan ajsic nopa camanali hasta nopa hueyi tequicali campa itztoc Faraón. ");
INSERT INTO nchBl_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Huan José quinilhui iicnihua: ―Na niJosé. ¿Noja itztoc notata? Huan iicnihua tahuel momajmatijque iixpa hasta amo hueliyayaj camanaltij. ");
INSERT INTO nchBl_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Pero ya quinilhui: ―Ximonechcahuica campa na. Huan quema monechcahuijque campa ya, yaya quinilhui: ―Na niamoicni José cati antechnamacaque para ma nechhualicaca tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Amo ximocuesoca, yon amo ximocualanica pampa antechnamacaque. Toteco Dios nechtitanqui nica achtohui que amojuanti para amo timiquise. ");
INSERT INTO nchBl_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ya panoc ome xihuit ica mayanti ipan ni tali, pero noja polihui seyoc macuili xihuit quema amo oncas yon quentzi pixquisti huan amo aqui huelis tatojtocas. ");
INSERT INTO nchBl_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Toteco Dios nechtitanqui nica achtohui que amojuanti para nijmanahuis amonemilis para ma mocahuaca amoteipan ixhuihua para mochihuase tahuel miyac masehualme ipan taltipacti. ");
INSERT INTO nchBl_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Huajca amo elqui amojuanti cati antechtitanque nica. ¡Amo! Elqui Toteco cati nechtitanqui, huan nechtalijtoc niitapalehuijca Faraón huan na cati nijconsejomaca. Yaya nechtalijtoc ma nitanahuati ipan ichaj huan ma nieli nigobernador ipan nochi ni tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Huajca xiyaca nimantzi campa itztoc notata huan xiquilhuica para icone, José, quiijtohua para Toteco Dios nechtalijtoc ma nitanahuati ipan nochi tali Egipto. Huajca nimantzi ma huala nechitaqui. Ma amo huejcahua. ");
INSERT INTO nchBl_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Huelis itztos nonechca, nopona campa itoca Gosén nica ipan tali Egipto ihuaya amojuanti, huan amoconehua, huan amoixhuihua, huan nochi amotapiyalhua huan nochi cati anquipiyaj. ");
INSERT INTO nchBl_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Nica nimechmacas tacualisti para nochi amofamilia huan nochi cati itztoque amohuaya para amo teno quinpolos. Noja oncas ni mayanti para seyoc macuili xihuit. Sinta amo hualas, amojuanti huan nochi cati anquipiyaj tahuel antaijyohuise. ");
INSERT INTO nchBl_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Teipa José quiijto: ―Xiquitaca amojuanti huan Benjamín para nelía na niJosé. ");
INSERT INTO nchBl_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Huajca xijpohuilica notata taya tanahuatili nijpiya nica ipan Egipto huan nochi cati anquiitztoque nica. San monequi nimantzi xijhualica notata. ");
INSERT INTO nchBl_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Huan José ica nochi iyolo quicuanajnahuajqui iicni Benjamín huan chocac miyac iquechpa. Huan Benjamín quicuanajnahuajtoc chocac ipan José. ");
INSERT INTO nchBl_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Teipa José quintzoponi nochi iicnihua huan chocac quema quincuanajnahuajqui. Huan teipa iicnihua pejque quicamanalhuíaj. ");
INSERT INTO nchBl_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Huan ipan ichaj Faraón quicajque para ajsicoj iicnihua José huan nelía pajque Faraón huan nochi itapalehuijcahua. ");
INSERT INTO nchBl_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Huan Faraón quiilhui José: ―Xiquinilhui moicnihua ma quintamamaltica inintapiyalhua huan ma tacuepilica ipan tali Canaán, ");
INSERT INTO nchBl_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","huan ma nechhualiquilica amotata huan nochi ininteixmatcahua. Na niquinmacas nopa tali cati más cuali ipan nochi ni tali Egipto. Huan quicuase cati más cuali cati ni tali temaca. ");
INSERT INTO nchBl_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Xiquinilhui ma quihuicaca cuacarrojme ten tali Egipto para ma quinhualicaca inisihuajhua ihuaya ininconehua huan amotata. ");
INSERT INTO nchBl_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ma amo mocuesoca ica cati ama quipiyaj. Nochi cati cuali cati onca ipan ni tali Egipto teipa elis iniaxca. ");
INSERT INTO nchBl_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Huan quej nopa quichijque itelpocahua Israel. Huan José quinmacac cuacarrojme quej Faraón tanahuatijtoya huan quinmacac tacualisti para ipan ojti. ");
INSERT INTO nchBl_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Nojquiya quinmacac yoyomit yancuic para mopatase, pero Benjamín quimacac 300 tomi ten plata huan macuili iyoyo para mopatas. ");
INSERT INTO nchBl_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Huan para itata José quititanili majtacti burrojme tamamajtoque ica tamanti cati onca ipan tali Egipto huan nojquiya quinmacac seyoc majtacti burrojme tamamajtoque ica trigo, pantzi huan tacualisti para ma tacua itata ipan ojti. ");
INSERT INTO nchBl_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Huan quema José quinmajcajqui iicnihua, quinilhui: ―Amo ximonajnanquilica ipan ojti. Huan inijuanti yajque. ");
INSERT INTO nchBl_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Huan quisque ipan tali Egipto huan ajsitoj ipan tali Canaán campa itztoya inintata, Jacob. ");
INSERT INTO nchBl_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Huan quema quipohuilijque Jacob para José noja itztoya huan yaya cati tanahuatiyaya ipan nochi tali Egipto, amo quimatiyaya taya quiijtos, yon taya quichihuas pampa amo hueliyaya quineltoca. ");
INSERT INTO nchBl_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Pero quema quipohuilijque nochi cati José quiijtojtoya huan quema quinitac nopa cuacarrojme cati José quintitantoya para quinhuicase, nelía pajqui miyac. ");
INSERT INTO nchBl_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Huan huajca quiijto: “Nelía temachti, nocone José noja itztoc huan amo nimiquis hasta niyas niquitati.” ");
INSERT INTO nchBl_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Huan Israel, cati nojquiya itoca eliyaya Jacob, quisqui ipan ojti ica nochi cati quipiyayaya. Huan quema ajsito ipan Beerseba, quimacac se tacajcahualisti Toteco Dios, yaya cati nojquiya iTeco itata, Isaac. ");
INSERT INTO nchBl_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Huan nopa tayohua Toteco quicamanalhui Israel ipan se temicti, huan quinojnotzqui ica itoca Jacob. Huan Jacob quinanquili: ―Nica niitztoc, noTeco. ");
INSERT INTO nchBl_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Huajca Toteco Dios quiilhui: ―Na niDios nimoTeco. Na niiTeco motata. Amo ximajmahui para tiyas tali Egipto pampa nopona nijchihuas para moteipan ixhuihua tahuel momiyaquilise hasta mochihuase se altepet ica tahuel miyac masehualme ica san se inieso. ");
INSERT INTO nchBl_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Na niyas mohuaya ipan Egipto huan teipa niquinquixtis moteipan ixhuihua nopona. Quema timiquis, motelpoca José itztos monechca. ");
INSERT INTO nchBl_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Huan itelpocahua Jacob quitejcoltijque inintata, huan ininconehua huan inisihuajhua ipan nopa cuacarros cati Faraón quintitantoya huan yajque. Huan quej nopa Israel quistejqui ten Beerseba. ");
INSERT INTO nchBl_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Huan Jacob huan itelpocahua quinhuicaque inintapiyalhua huan nochi cati quipixtoyaj ipan tali Canaán. ");
INSERT INTO nchBl_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Yajque nochi iconehua huan iixhuihua; tacame huan sihuame. ");
INSERT INTO nchBl_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Nica nimitzilhuis inintoca itelpocahua huan iteipan ixhuihua Israel o Jacob cati yajque tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Yajqui Rubén iachtohui cone Jacob. Yajque iconehua Rubén: Hanoc, Falú, Hezrón huan Carmi. ");
INSERT INTO nchBl_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Yajque Simeón huan iconehua: Jemuel, Jamín, Ohad, Jaquín, Zohar huan Saúl cati eliyaya icone se sihuat cananea. ");
INSERT INTO nchBl_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Yajque Leví huan iconehua: Gersón, Coat huan Merari. ");
INSERT INTO nchBl_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yajque Judá huan iconehua: Sela, Fares huan Zara. Pero iconehua cati inintoca Er huan Onán ya mictoyaj ipan tali Canaán. Huan iconehua Fares elque: Hezrón huan Hamul. ");
INSERT INTO nchBl_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Yajque Isacar huan iconehua: Tola, Fúa, Job huan Simrón. ");
INSERT INTO nchBl_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Yajque Zabulón huan iconehua cati inintoca eliyaya: Sered, Elón huan Jahleel. ");
INSERT INTO nchBl_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Nochi ni tacame cati nimitzilhuijtoc nica elque iconehua Jacob ihuaya Lea huan yajque tali Egipto ica Jacob. Huan nochi ni ininconehua tacatque quema itztoyaj ipan tali Aram. Nojquiya Jacob huan Lea quipixque se iniichpoca cati itoca Dina. Ininconehua huan iniixhuihua Jacob huan Lea mochijque 33. ");
INSERT INTO nchBl_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Nojquiya yajque tali Egipto Gad huan iconehua: Zifión, Hagui, Ezbón, Suni, Eri, Arodi huan Areli. ");
INSERT INTO nchBl_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Yajque Aser huan iconehua: Imna, Isúa, Isúi, Bería huan inisihua icni cati itoca Sera. Huan Bería ya quinpixqui iconehua: Heber huan Malquiel. ");
INSERT INTO nchBl_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Cati nimitzilhuijtoc nica elque iconehua Jacob ica Zilpa huan yajque tali Egipto inihuaya. Zilpa elqui nopa tequipanojquet cati Labán quimacac iichpoca, Lea, huan teipa Lea quimacac ihuehue para ma eli isihua. Huan ininconehua huan iniixhuihua Jacob ihuaya Zilpa elque 16 masehualme para nochi. ");
INSERT INTO nchBl_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Huan nojquiya yajque iconehua Raquel, isihua Jacob cati mijqui, huan inintoca ininconehua elque: José huan Benjamín. ");
INSERT INTO nchBl_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Huan ipan Egipto José quinpixqui coneme ihuaya isihua Asenat. Asenat elqui iichpoca Potifera, cati eliyaya se totajtzi nopona ipan altepet On. Ininconehua elque: Manasés huan Efraín. ");
INSERT INTO nchBl_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Huan iconehua Benjamín elque: Bela, Bequer, Asbel, Gera, Naamán, Ehi, Ros, Mupim, Hupim huan Ard. ");
INSERT INTO nchBl_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Cati nimitzilhuijtoc nica elque iconehua huan iixhuihua Raquel huan Jacob. Huan mochijque 14 masehualme para nochi. ");
INSERT INTO nchBl_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Huan nojquiya yajque tali Egipto Dan, icone Jacob, huan icone: Husim. ");
INSERT INTO nchBl_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Huan nojquiya yajque Neftalí huan iconehua: Jahzeel, Guni, Jeser huan Silem. ");
INSERT INTO nchBl_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Huan inijuanti elque iconehua Bilha, nopa tequipanojquet cati Labán quimacac iichpoca, Raquel, huan teipa Raquel quimacac Jacob para ma eli isihua. Huan iconehua huan iixhuihua Jacob ica Bilha elque chicome para nochi. ");
INSERT INTO nchBl_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Huan para nochi nopa masehualme cati yajque Egipto ihuaya Jacob cati nelía san se inieso elque 66, huan amo quinpojque inintelpocahua inisihuajhua. ");
INSERT INTO nchBl_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Huan ica nopa ome iconehua José cati tacatque ipan Egipto mochijque 70 masehualme ipan ifamilia Jacob quema ajsitoj nopona. ");
INSERT INTO nchBl_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Huan Jacob quititanqui Judá ma tayacana para quiitati José huan quimachiltis para ma quinamiquiqui ipan tali Gosén. Huan quema Judá ajsito campa José, ");
INSERT INTO nchBl_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","yaya tanahuati ma quicualtalica icuacarro para yas quinamiquiti itata. Huan quema ajsito iixpa itata, quinajnahuajqui huan huejcajqui choca ipan iajcol. ");
INSERT INTO nchBl_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Huan Israel quiilhui José: ―Ama ya huelis nimiquis pampa nelía nimitzitztoc ica noixteyol huan nimitzpanti noja tiitztoc. ");
INSERT INTO nchBl_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Huan José quinilhui iicnihua huan nochi ifamilia itata: ―Niyas niquitati Faraón para nijyolmelahuati para ya anajsitoque. Niquilhuis para noicnihua huan iteixmatcahua notata cati itztoyaj ipan tali Canaán ya hualajtoque para mocahuase nohuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Huan quinhualicatoque ininborregojhua, inihuacaxhua huan nochi cati quipiyaj pampa inintequi eltoc para quinmocuitahuíaj borregojme huan quiniscaltíaj tapiyalme. Quej nopa niquilhuis. ");
INSERT INTO nchBl_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Huajca quema nopa Faraón amechnotzas huan amechtatzintoquilis ipan taya antequitij, ");
INSERT INTO nchBl_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","xiquilhuica para nochipa anquiniscaltijtoque borregojme, san se quej amohuejcapan tatahua. Quej nopa amechcahuilis anmocahuase ipan tali Gosén pampa egiptome quinijiyaj cati quinmocuitahuíaj borregojme huan amo quinequij itztose inihuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Huan José yajqui quiyolmelahuato Faraón huan quiilhui para itata huan iicnihua ya ajsicoj ten tali Canaán huan itztoyaj ipan tali Gosén ihuaya ininborregojhua, huan inihuacaxhua huan nochi cati quipiyaj. ");
INSERT INTO nchBl_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Huan quintapejpeni macuilti iicnihua huan quinhuicac iixpa Faraón para ma quinixmatica. ");
INSERT INTO nchBl_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Huan Faraón quintatzintoquili: ―¿Taya tequit anquichihuaj? Huan inijuanti quiilhuijque: ―Tojuanti, timotequipanojcahua, tiquinmocuitahuíaj borregojme quej tohuejcapan tatahua quichijque. ");
INSERT INTO nchBl_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Huan tihualajtoque para timocahuase ipan ni tali pampa amo onca sacat para toborregojhua nepa ipan tali Canaán pampa nopa mayanti tahuel chicahuac nopona. Se favor, totanahuatijca, techcahuili ma timocahuaca ipan tali Gosén. ");
INSERT INTO nchBl_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Huan Faraón quiilhui José: ―Motata huan moicnihua hualajtoque para mocahuase nica mohuaya. ");
INSERT INTO nchBl_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Huajca huelis quitequihuise campa más cuali ipan ni tali Egipto. Xiquinmaca nopa tali Gosén para nopona ma mocahuaca pampa nelcuali. Huan sinta tijmati sequij ten inijuanti cati más quimatij nopa tequit, huajca xiquintali nochi notapiyalhua inimaco. ");
INSERT INTO nchBl_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Teipa José quihuicac itata, Jacob, iixpa Faraón para ma quiixmati. Huan Jacob quitiochijqui Faraón, ");
INSERT INTO nchBl_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","huan Faraón quiilhui: ―¿Quesqui xihuit tijpiya? ");
INSERT INTO nchBl_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Huan Jacob quinanquili: ―Nijpanotoc 130 xihuit cati nelohui. Pero ya nopa nelquentzi pampa ayemo nicajsi nopa xihuit cati nohuejcapan tatahua itztoyaj. ");
INSERT INTO nchBl_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Teipa Jacob quinahuatijtejqui Faraón huan quisqui. ");
INSERT INTO nchBl_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Huan José quimacac itata huan iicnihua nopa talme cati más cuali ipan tali Egipto, nopa tali cati itoca Ramesés para ma itztoca nopona quej Faraón tanahuatijtoya. ");
INSERT INTO nchBl_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Nojquiya José quinmacayaya tacualisti nochi iteixmatcahua quej sese inijuanti monejqui para quitequihuise. ");
INSERT INTO nchBl_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Huan teipa ipan yon se tali ayecmo oncac tacualisti pampa nopa mayanti más motananqui. Ipan tali Egipto huan ipan tali Canaán nochi tahuajqui. ");
INSERT INTO nchBl_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Huan nochi tomi ipan tali Egipto huan ipan tali Canaán ajsico imaco José pampa quinamacayaya trigo. Huan yaya quihuicac nopa tomi tequicalco campa itztoya Faraón. ");
INSERT INTO nchBl_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Huan quema ayecmo aqui quipixqui tomi ipan tali Egipto huan ipan tali Canaán, nopa egiptome yajque quiilhuitoj José: ―¡Techmaca cati tijcuase! Amo techcahuili ma tiapismiquica moixpa san pampa ya tanqui totomi. ");
INSERT INTO nchBl_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Huan José quinnanquili: ―Sinta ayecmo anquipiyaj tomi, huajca xiquinhualicaca amotapiyalhua huan nimechpatilis ica trigo. ");
INSERT INTO nchBl_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Huan nopa egiptome quinhuicaque inincahuayojhua, ininborregojhua, ininchivojhua, inihuacaxhua huan ininburrojhua, huan José quinpatili ica trigo. Quej nopa quinpanolti nochi nopa xihuit. ");
INSERT INTO nchBl_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Huan quema panoc nopa xihuit, inijuanti sempa yajque quiilhuitoj José: ―Ta tijmati ayecmo tijpiyaj tomi huan ama nochi totapiyalhua amoaxca. Ayecmo tijpiyaj seyoc tamanti cati huelis timitzmacase, san total mocahua huan totacayohua. ");
INSERT INTO nchBl_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Pero amo techcahuili ma tiapismiquica moixpa. Techcohua tojuanti ihuaya totalhua ica trigo. Huan tijtequipanose Faraón san tapic huan totalhua elis iaxca, pero techmaca trigo para tiitztose huan para ni tali ma amo nenpolihuis. ");
INSERT INTO nchBl_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Huajca José quicojqui para Faraón nochi piltaltzitzi ipan tali Egipto pampa nochi nopa egiptome quinamacaque inintalhua pampa amo huelque quiijyohuíaj nopa mayanti. Quej nopa nochi nopa tali panoc imaco Faraón. ");
INSERT INTO nchBl_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Huan José quinchijqui nopa egiptome campa hueli ma elica tequipanohuani cati tequitique san tapic. ");
INSERT INTO nchBl_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Pero amo quicojqui inintal nopa totajtzitzi pampa Faraón quinmacayaya trigo san tapic. Huan amo monejqui quinamacase inintalhua. ");
INSERT INTO nchBl_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Teipa José quinilhui nopa egiptome: ―Ama amojuanti ihuaya amotalhua anmocahuaj iaxca Faraón pampa nimechcojtoc para anelise iaxca ya. Nica anquipiyaj xinachti para xijtocaca. ");
INSERT INTO nchBl_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Pero quema anpixcase, monequi anquixelose nopa pixquisti cati oncas ica macuili partes. Se parte elis iaxca Faraón huan nopa seyoc nahui partes elis amoaxca para anquitocase, huan para anquicuase amojuanti huan amoconehua huan cati itztoque ipan amochajchaj. ");
INSERT INTO nchBl_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Huan inijuanti tananquilijque: ―Techmanahuijtoc para amo timiquise. Ica paquilisti tijtequipanose Faraón san tapic. ");
INSERT INTO nchBl_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Huajca José quichijqui nopa tanahuatili ipan nochi tali Egipto para ipan sesen macuili coxtali cati pixcase monequi quimacase Faraón se coxtali. Huan ni tanahuatili noja quitoquilíaj. Pero nopa totajtzitzi amo teno monejqui taxtahuase pampa inintalhua amo quema elqui iaxca Faraón. ");
INSERT INTO nchBl_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Huan nopa israelitame mocajque ipan nopa piltaltzi Gosén ipan tali Egipto huan nopona nochi quisqui cuali para inijuanti. Huan inijuanti tahuel momiyaquilijque. ");
INSERT INTO nchBl_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Huan Jacob itztoya 17 xihuit ipan Egipto huan quiaxiti 147 xihuit. ");
INSERT INTO nchBl_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Huan se tonali Israel quimatqui ayecmo huejcahuas para miquis, huajca tatitanqui ma quinotzatij José huan quiilhui: ―Se favor, xijtali momax noquescuayotzinta huan xijtestigojquetza Toteco para tijchihuas cati nimitztajtanis. Amo techtocas nica ipan tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Quema nimiquis huan nimosiyajquetzati ihuaya nohuejcapan tatahua, techhuica huan techtoca campa inijuanti toctoque. Huan José quiilhui: ―Quena, quej nopa nijchihuas. ");
INSERT INTO nchBl_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Huan itata sempa quiilhui: ―¡Xijtestigojquetza Toteco Dios! Huan José quitestigojquetzqui Toteco Dios para temachti quichihuas. Huan huajca Israel mohuijtzonqui ica itzonteco ipan icuatopil huan quihueyichijqui Toteco. ");
INSERT INTO nchBl_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Teipa quema panotoya se quentzi tonali quiilhuijque José para itata mococohua. Huajca José yajqui quiitato huan quinhuicac iome telpocahua, Manasés huan Efraín. ");
INSERT INTO nchBl_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Huan quema quiyolmelajque Jacob para icone, José, ajsitoya para quiitati, quichijqui campeca huan mosehui ipan itapech. ");
INSERT INTO nchBl_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Huan quiilhui José: ―Toteco Dios Cati Quipiya Nochi Chicahualisti monexti campa niitztoya nechca altepet Luz ipan tali Canaán huan techtiochijqui. ");
INSERT INTO nchBl_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Huan techilhui para quinmiyaquilis noconehua huan noteipan ixhuihua hasta mochihuase tahuel miyac masehualme. Nojquiya techilhui para noteipan ixhuihua quinmacasquía nopa tali huan elis iniaxca para nochipa. ");
INSERT INTO nchBl_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Huajca ama huan teipa ni ome moconehua, Efraín huan Manasés, cati tacatque nica ipan tali Egipto quema ayemo niajsiyaya elise quej noaxcahua para quiselise san se quej Rubén huan Simeón quiselise. ");
INSERT INTO nchBl_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Pero nopa moconehua cati tacatise teipa elise moaxcahua ta. Huan inijuanti quiselise cati ininaxca ipan nopa tali cati elis iniaxca Efraín huan Manasés. ");
INSERT INTO nchBl_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Quema nitacuepiliyaya ten tali Aram, mijqui monana Raquel ipan Canaán quema tinejnemiyayaj ipan ojti huan san quentzi polihuiyaya para tiajsitij altepet Efrata. Huan nijtojqui nopona ipan ojti para altepet Efrata cati ama itoca Belén. ");
INSERT INTO nchBl_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Huan Israel quinitac itelpocahua José huan quiijto: ―Huan ¿ni telpocame? ");
INSERT INTO nchBl_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Huan ya quiilhui: ―Ni noconehua cati Toteco Dios nechmacatoc nica ipan tali Egipto. Huan itata quiilhui: ―Xijchihua se favor, xiquinnechcahuilti campa na para niquinmacas notatiochihual. ");
INSERT INTO nchBl_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Huan Israel eliyaya nelhuehuentzi huan ayecmo cuali iixteyol, huan yeca ayecmo hueliyaya tachiya cuali. Huan José quinnechcahuilti itelpocahua campa itata, huan Jacob quintzoponi huan quinnajnahuajqui. ");
INSERT INTO nchBl_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Teipa Jacob quiilhui José: ―Ayecmo nijchiyayaya para sempa nimitzitas huan masque ya nopa, Toteco Dios nechcahuilijtoc nojquiya ma niquinita moconehua. ");
INSERT INTO nchBl_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Huan José quinijcueni itelpocahua cati itztoyaj nechca itancuaco itata, huan motancuaquetzqui huan mohuijtzonqui talchi ica hueyi tatepanitacayot iixpa itata. ");
INSERT INTO nchBl_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Huan teipa José quinmatilanqui nopa ome itelpocahua huan quitali Efraín ica inejmat huan Manasés ica iarraves, huan quinnechcahuilti campa itata, Israel. Quej nopa Efraín mocajqui ica iarraves Israel huan Manasés ica inejmat. ");
INSERT INTO nchBl_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Pero quema Israel quixitajqui imax, momanepano huan quitali inejmat ipan itzonteco Efraín cati eliyaya teipan ejquet, huan quitali iarraves ipan itzonteco Manasés cati eliyaya achtohui ejquet. ");
INSERT INTO nchBl_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Huajca Israel quintiochijqui quej ni: “Ma Toteco Dios quintiochihua ni telpocame. Yaya nopa Dios cati ihuaya nejnenque notatahua Abraham huan Isaac, huan cati nechmocuitahuijtoc nochi nonemilis. ");
INSERT INTO nchBl_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Yaya nopa Ilhuicac ejquet cati nechmanahuijtinentoc ten nochi cati fiero. Yaya ma quintiochihua ni telpocame. Huan nochi masehualme ma quimatica inijuanti noaxcahua, huan iniaxcahua notatahua, Abraham huan Isaac. Ma quinpiyaca miyac ininconehua huan ma tahuel momiyaquilica ininteipan ixhuihua ipan taltipacti.” ");
INSERT INTO nchBl_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Pero José amo quipacti para itata quitalijtoya inejmat ipan itzonteco Efraín huan quiitzquili imax para quiijcuenis huan quitalis ipan itzonteco Manasés. ");
INSERT INTO nchBl_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Quiilhui: ―¡Amo, papá! Ya ni cati achtohui ejquet. Xijtali monejmat ipan itzonteco. ");
INSERT INTO nchBl_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Pero itata amo quinejqui quichihuas huan quiilhui: ―Nijmati, nocone, ya nijmati. Nojquiya iteipan ixhuihua mochihuase nelía miyac masehualme cati nochi quintepanitase. Pero iicni teipan ejquet elis más hueyi que ya huan iteipan ixhuihua iicni más momiyaquilise huan mochihuase miyac talme. ");
INSERT INTO nchBl_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Huajca ipan nopa tonali Jacob quintiochijqui Efraín huan Manasés huan quinilhui: “Nochi sequinoc noteipan ixhuihua quitequihuise amotoca para tatiochihuase huan quiijtose: ‘Toteco Dios ma mitzchihua hueyi quej quinchijqui Efraín huan Manasés.’ ” Quej nopa Israel quitali para Efraín elis más hueyi huan teipa Manasés. ");
INSERT INTO nchBl_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Teipa Israel quiilhui itelpoca, José: ―Xiquita, ya ajsitinemi nopa tonali para nimiquis, pero Toteco Dios itztos amohuaya huan quichihuas para sempa xiyaca ipan inintal mohuejcapan tatahua. ");
INSERT INTO nchBl_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Huan nimitzmacatoc ta nopa tali cati más cuali que nopa cati niquinmacac moicnihua pampa más tihueyi. Yeca nimitzmaca cati niquinquixtili nopa amorreo masehualme ica nomacheta huan nocuahuitol. ");
INSERT INTO nchBl_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Huan Jacob quinnotzqui itelpocahua huan quinilhui: “Ximonechcahuica huan nimechilhuis cati amechpanos teipa. ");
INSERT INTO nchBl_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Noconehua, ximonechcahuica huan techcaquica. Na niJacob huan amojuanti annoconehua. Techtacaquilica niamotata, Israel. ");
INSERT INTO nchBl_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ta Rubén, tinoachtohui cone. Tieliyaya tinochicahualis huan quema titacatqui eltoya quej nopa achtohui iselca notetilis. Tijpiyas miyac chicahualisti huan tatepanitacayot. ");
INSERT INTO nchBl_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Pero ayecmo tielis cati más tihueyi, pampa tiitztoc quej at cati tehuilana. Quej nopa eltoc pampa techpinahualti quema timotejqui ipan notapech ihuaya notequipanojca. ");
INSERT INTO nchBl_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeón huan Leví nelía anicnime pampa san se amonemilis. Amomachetas anquitequihuíaj san para tatehuilisti. ");
INSERT INTO nchBl_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","¡Amo quema nijnequi nijcaquis amocamanal, yon amo quema nimosentilis amohuaya! Pampa quema ancualaniyayaj, antemictijque, huan san pampa anquinejque, anquinmetzpostejque torojme. ");
INSERT INTO nchBl_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","¡Tatelchihualtic, quena, tatelchihualtic amocualancayo, pampa annelfierojtique huan amo antatasojtaj! ¡Nimechsemanas huan anitztose campa hueli ipan nochi tali Israel! ");
INSERT INTO nchBl_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Ta tiJudá, moicnihua mitzpaquilismacase. Huan tiquinitzquis mocualancaitacahua ininquechta huan tiquintanis. Hasta moicnihua motancuaquetzase para mitztepanitase. ");
INSERT INTO nchBl_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ta tiJudá, tielis quej icone se tecuani cati tacuepili pactoc por nopa tapiyali cati quimictijtoc. Tielis quej se león cati mopachohua huan moteca talchi, huan quichiya taya quiitzquis. Tielis quej se sihua león cati nelía quipiya tetili. Amo aqui mitzcuesolmacas. ");
INSERT INTO nchBl_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Amo aqui huelis quiquixtis nopa tanahuatili cati moteipan ixhuihua quipiyase. Yon amo aqui hueli quinquixtilis nopa tepos cuatopili cati quipiyase para ica tetatzacuiltise. Quipiyase tanahuatili para nochipa. Huan teipa hualas moteipan ixhui cati temacas tasehuilisti. Yaya cati nelía iaxca nopa tepos cuatopili huan nopa tanahuatili para tanahuatis. Huan masehualme ipan nochi talme campa hueli quichihuase cati yaya quinilhuía. ");
INSERT INTO nchBl_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Elis se tominpixquet huan campa hueli oncas xocomeca mili cati iaxca. Quiilpis iburro ipan ten hueli xocomeca tzonti cati quinequis, huan sinta quinequi, quiilpis ipilconeburro ipan nopa xocomeca macuayot cati más cuali. Quipiyas miyac xocomecat iayo hasta nesis quej huelis ica quichicuenis iyoyo. Quena, hasta mocahuas quipiyas iayo xocomecat cati temacas nochi imil. ");
INSERT INTO nchBl_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Iixteyol elis más yayahuic que xocomecat iayo, huan itancochhua más chipahuac que lechi. ");
INSERT INTO nchBl_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Ta tiZabulón, moteipan ixhuihua itztose iteno hueyi at, huan nopona ajsise miyac cuaacalme. Motal ajsis hasta tali Sidón. ");
INSERT INTO nchBl_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Ta tiIsacar, moteipan ixhuihua elise tejtetique quej se tapiyali cati quimati tamama etic. Mosiyajquetzase campa quintzacuaj borregojme. ");
INSERT INTO nchBl_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Quema quiitase quenicatza nelía cuali amotal para ipan anmosiyajquetzase huan quenicatza nelía yejyectzi, huajca motancuaquetzase huan mocuitapantise para tamamase. Huan yon amo molinise moteipan ixhuihua quema quinchihuase ma tequipanoca san tapic. ");
INSERT INTO nchBl_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Ta tiDan, ta huan moixhuihua antetajtolsencahuase quej quinamiqui pampa anelise se hueyi familia ipan tali Israel. ");
INSERT INTO nchBl_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Moteipan ixhuihua elise quej se cohuat cati itztoc ojtipa, huan quintzacanía inincotzta cahuayojme huan quintahuisohua cati tejcotoque ipan cahuayojme. ");
INSERT INTO nchBl_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","¡TOTECO! Nijchiya para techmanahuis. ");
INSERT INTO nchBl_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Ta tiGad, miyac soldados hualase huan quintehuise moteipan ixhuihua, pero teipa inijuanti moicancuepase huan quinquixtijtiyase. ");
INSERT INTO nchBl_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ta tiAser, moteipan ixhuihua quipiyase tacualisti cati cuali. Quena, temacase tacualisti cati ajhuiyac quej cati quicuaj huejhueyi tanahuatiani. ");
INSERT INTO nchBl_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Ta tiNeftalí, moteipan ixhuihua elise quej se masat cati nemi campa quinequi huan cati quintacatiltía yejyectzitzi pilconemasatzitzi. ");
INSERT INTO nchBl_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Ta tiJosé, moteipan ixhuihua elise quej se cuali cuahuit cati quitoctoque campa ameli. Temaca miyac itajca huan imacuayohua moscaltía miyac hasta quipano nopa tepamit cati tilahuac. ");
INSERT INTO nchBl_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Masehualme quincualancaitase moteipan ixhuihua, huan quinmajcahuilise cuataminti huan nochipa quinmacase tequipacholi. ");
INSERT INTO nchBl_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Pero moteipan ixhuihua quiquetzase inincuahuitol xitahuac, huan amo huihuipicase inimax quema quitequihuise pampa elise tejtetique. Quena, tatanise pampa noTeco Dios, Yaya Cati Quipiya Nochi Chicahualisti quinpalehuis. Yaya quinmocuitahuis pampa yaya totamocuitahuijca tiisraelitame. Yaya nopa Hueyi Tet cati techmanahuijtoc miyac huelta. ");
INSERT INTO nchBl_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Quena, ma amechpalehui ininTeco mohuejcapan tatahua. Ma amechtiochihua ta huan amoteipan ixhuihua yaya Toteco Dios cati quipiya nochi chicahualisti. Ma quintiochihuas moteipan ixhuihua ica miyac tatiochihualisti quej at cati huala ten huejcapa ipan ilhuicac, huan cati huala huejcata ipan hueyi at huan quichihuas ma moscaltis amomilhua. Ma mitztiochihuas ta huan moteipan ixhuihua huan mosihuajhua. Ma amechmacas miyac amoconehua cati moscaltise cuali. Ma tahuel momiyaquilica amotapiyalhua. ");
INSERT INTO nchBl_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Quena, José, Toteco ma mitztiochihua, yaya cati noTeco na, nimotata. Ni tatiochihuali momiyaquilis hasta ajsis ipan nopa tepeme cati huejcahuase para nochipa. Nochi ya ni elis nopa tatiochihualisti cati ta tijpiyas, José, pampa Toteco mitziyocatali ten moicnihua para tielis tiinintanahuatijca. ");
INSERT INTO nchBl_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Ta tiBenjamín, moteipan ixhuihua tatanise quej se tepechichi. Ica ijnaloc quicuase cati quimictijtoque, huan hasta tiotac quipiyase cati mocajtoc para temajmacase.” ");
INSERT INTO nchBl_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ya ni nopa 12 itelpocahua Israel huan nopa tatiochihuali cati inintata quinmacac. Quinilhui cati quinamiqui para sesen quiselis pampa Toteco quinextili cati panos ica ininteipan ixhuihua sese ten inijuanti. ");
INSERT INTO nchBl_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Nojquiya Jacob quinmacac itelpocahua ni tanahuatili: “San quentzi polihui para nimiquis. Techtalpachoca inihuaya nohuejcapan tatahua ipan nopa ostot cati eltoc ipan ital Efrón nopa heteo. ");
INSERT INTO nchBl_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Quena, techtalitij nopona ipan tali Canaán ipan nopa ostot ipan nopa mila cati itoca Macpela, iixpa Mamre. Nopa cati Abraham quicohuili Efrón para ipan ma quintalpachoca nochi iteixmatcahua. ");
INSERT INTO nchBl_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Nopona quintoctoque Abraham ihuaya isihua, Sara, huan Isaac huan isihua, Rebeca, huan nopona nijtalpacho Lea. ");
INSERT INTO nchBl_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Nopa tali huan nopa ostot cati eltoc nopona quincohuili nopa heteo tacame.” ");
INSERT INTO nchBl_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Huan quema Jacob tanqui quinnahuatía itelpocahua, motejqui ipan itapech huan mijqui. ");
INSERT INTO nchBl_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Huajca José quinajnahuajqui itacayo itata huan chicahuac chocac huan quitzoponi. ");
INSERT INTO nchBl_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Teipa quinnahuati nopa itepajtijcahua ma quitalilica taajhuiyacayot cati pajyo ipan itacayo itata para ma amo palani. Huan quej nopa quichijque. ");
INSERT INTO nchBl_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Huan quitalilijque nopa pajtaajhuiyacayot 40 tonati pampa monejqui quitamiltise nopa tonali para amo palanis. Huan nopa egiptome quichoquilijque Israel 70 tonali. ");
INSERT INTO nchBl_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Teipa quema panoc nopa choquisti, José quincamanalhui itapalehuijcahua ipan ichaj Faraón huan quinilhui: ―Se favor, xijcamanalhuica Faraón ten na huan xiquilhuica ");
INSERT INTO nchBl_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","para quema notata miquiyaya, nechchijqui ma nijtestigojquetza Toteco Dios para nijtalpachosquía ipan se ostot ipan tali Canaán cati iaxca toteixmatcahua. Huajca xijtajtanica ma nechcahuili ma niya tali Canaán nijcahuati notata. Huan quema ya nijtalpachojtos, sempa nihualas. ");
INSERT INTO nchBl_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Huan nopa Faraón tananquili para quena huan quiilhui José: ―Xiya xijtalpachoti motata quej ya mitzilhui. ");
INSERT INTO nchBl_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Huan José yajqui quitalpachoto itata. Huan ihuaya yajque nochi nopa tacame cati quipiyayayaj tanahuatili para tanahuatise ihuaya José. Huan nojquiya yajque cati quipiyayayaj tanahuatili ipan ichaj Faraón huan ipan tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Huan yajque nochi iicnihua José inihuaya nochi iteixmatcahua itata. Ipan tali Gosén san quincajtejque ininconehua huan inintapiyalhua. ");
INSERT INTO nchBl_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Nojquiya yajque miyac masehualme ipan cuacarrojme huan ipan cahuayojme ihuaya José. Elque tahuel miyac masehualme cati yajque. ");
INSERT INTO nchBl_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Huan quema ajsitoj campa quiyolquixtíaj trigo ipan Atad nechca nopa hueyat Jordán, nochi quipixque se hueyi choquisti huan ica miyac tequipacholi José quichoquili itata para chicome tonati. ");
INSERT INTO nchBl_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Huan quema nopa cananeos cati ehuayayaj nopona quiitaque para nelía chocayayaj campa tayolquixtíaj campa itoca Atad, quiijtojque: “Tahuel hueyi inintequipachol nopa egiptome.” Huan yeca quitocaxtijque Abel Mizraim. (Abel Mizraim quinequi quiijtos Campa Nopa Egiptome Chocaque.) Abel Mizraim mocahua nechca hueyat Jordán para campa temo tonati. ");
INSERT INTO nchBl_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Huan itelpocahua Jacob quichijque ica inintata nochi cati ya quintajtanijtoya. ");
INSERT INTO nchBl_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Quihuicaque ipan tali Canaán huan quitalpachojque ipan nopa ostot cati eltoc ipan mila Macpela nechca Mamre cati Abraham quicohuilijtoya Efrón, nopa heteo tacat, para ipan quintalpachosquíaj nochi iteixmatcahua. ");
INSERT INTO nchBl_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Teipa quema ya quitalpachojtoyaj inintata, José tacuepili ipan tali Egipto ihuaya iicnihua huan nochi sequinoc cati ihuaya yajtoyaj. ");
INSERT INTO nchBl_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Quema iicnihua José momacaque cuenta para inintata Jacob ya mictoya, moilhuijque: “Nohueli José techcualancaitas huan quinequis techcuepilis ica cati fiero tijchihuilijque huejcajquiya.” ");
INSERT INTO nchBl_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Huajca tatitanque ma quiilhuitij: “Quema totata ayemo miquiyaya, ");
INSERT INTO nchBl_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","technahuati ma timitzilhuica, xijchihuili se favor huan techtapojpolhui totajtacol timoicnihua quema timitzchihuilijque cati fiero. Huan tojuanti nojquiya timitztajtaníaj techtapojpolhui cati timitzchihuilijque. Ama tijtequipanohuaj Toteco Dios cati totata quitoquili.” Huan José chocac quema quicajqui ni tamanti. ");
INSERT INTO nchBl_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Huan teipa ajsicoj iicnihua huan mohuijtzonque iixpa ica tatepanitacayot huan quiilhuijque: ―Nica techpixtoc para timoaxcahua. Timitztequipanose san tapic. ");
INSERT INTO nchBl_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Pero José quinilhui: ―Amo ximajmahuica. Na amo niDios para nimechtatzacuiltis. ");
INSERT INTO nchBl_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Melahuac anquinequiyayaj antechchihuilise cati nelía amo cuali, pero Toteco Dios quisencajqui para ica cati fiero antechchihuilijque, yaya quichihuasquía se tamanti cati nelpano cuali. Yaya quinequiyaya quimanahuis ininemilis miyac masehualme huan ya nopa cati ama anquiitaj ten pano. ");
INSERT INTO nchBl_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Huajca amo ximajmahuica. Nimechmacas amojuanti huan amoconehua ten anquicuase. Huan José quincamanalhui ica teicnelijcayot huan quej nopa quinyoltali. ");
INSERT INTO nchBl_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Huan José ihuaya nochi iteixmatcahua noja mocajque ipan tali Egipto huan yaya amo mijqui hasta quipixqui 110 xihuit. ");
INSERT INTO nchBl_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","José itztoya hasta iconehua Efraín quinpixque iniixhuihua. Nojquiya itztoya hasta Maquir, icone Manasés, quinpixqui iconehua. Quena, iixhuihua Manasés mahuiltijque iicxita inihueyi tata José. ");
INSERT INTO nchBl_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Huan se tonali José quinilhui iicnihua: “San polihui quentzi para nimiquis, pero teipa Toteco Dios hualas amechpalehuiqui huan amechquixtiqui ten ni tali para amechhuicas ipan nopa tali cati quintencahuili Abraham, Isaac huan Jacob para quinmacas.” ");
INSERT INTO nchBl_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Huajca José quincamanalhui iicnihua cati nojquiya eliyayaj itelpocahua Israel quej ya. Huan quinchihualti ma quitestigojquetzaca Toteco para quihuicase iomiyohua inihuaya quema ajsis tonali para quisase ten tali Egipto. Quinilhui: “Quema Toteco Dios hualas huan amechhuicas sempa ipan tali Canaán, monequi anquihuicase noomiyohua amohuaya.” ");
INSERT INTO nchBl_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Huajca José mijqui ipan tali Egipto quema quipiyayaya 110 xihuit huan itacayo quipajtijque ica pajtaajhuiyacayot para amo palanisquía. Huan quitalijque ipan se cuacajo ipan tali Egipto.");
INSERT INTO nchBl_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Nopa tacat cati itoca Israel yajqui ipan tali Egipto ihuaya 12 itelpocahua, huan sese ten inijuanti nojquiya quihuicac ifamilia. Huan ya ni inintoca itelpocahua Jacob cati ihuaya yajque tali Egipto: ");
INSERT INTO nchBl_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubén, Simeón, Leví, Judá, ");
INSERT INTO nchBl_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isacar, Zabulón, Benjamín, ");
INSERT INTO nchBl_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Neftalí, Gad huan Aser. ");
INSERT INTO nchBl_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Huan nochi iteixmatcahua Jacob cati yajque mochijque 70 masehualme. Pero seyoc itelpoca cati itoca José ya itztoya ipan tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Huan ica miyac xihuit mijqui José, huan iicnihua huan nochi nopa masehualme cati achtohui hualajtoyaj. ");
INSERT INTO nchBl_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Pero teipa iniixhuihua quinpixque miyac ininconehua huan motocaxtiyayaj israelitame. Huan nopa israelitame tahuel momiyaquilijtiyajque hasta mochijque tahuel miyaqui masehualme huan campa hueli itztoyaj ipan Gosén ipan tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Huan teipa panoc miyac xihuit huan pejqui tequiti se yancuic tanahuatijquet ipan tali Egipto cati amo quema quiixmajtoya José. Huan nopa yancuic tanahuatijquet quinilhui nopa egiptome: ");
INSERT INTO nchBl_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","“Xiquitaca, nopa israelitame mochijtoque nelmiyaqui masehualme huan más quipiyaj chicahualisti que tojuanti. ");
INSERT INTO nchBl_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Huajca monequi tijchihuase se tamanti para ayecmo momiyaquilise, pampa sinta oncas se tatehuilisti, huelis mosejcotilise ica tocualancaitacahua para techtehuise huan teipa cholose ten ni tali.” ");
INSERT INTO nchBl_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Huan yeca nopa egiptome quintalijque tacame cati tetique para ma quinchihualtica israelitame ma tequitica tahuel chicahuac. Quinchihualtijque ma quichijchihuaca nopa altepet Pitón huan Ramesés para nopa hueyi tanahuatijquet Faraón. Huan quintequihuijque nopa altepeme para ipan quiajocuise tacualisti. ");
INSERT INTO nchBl_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Pero quema noja más quintaijyohuiltiyayaj israelitame, noja más momiyaquiliyayaj. Yeca nopa egiptome pejque más quinimacasij. ");
INSERT INTO nchBl_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Huajca nopa egiptome tahuel quintequihuijque nopa israelitame huan amo quintasojtaque. ");
INSERT INTO nchBl_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Tahuel amo quinpatiitayayaj. San quintequihuiyayaj chicahuac huan quintaijyohuiltiyayaj miyac. Quinchihualtijque ma quicualtalica soquit huan ma quichihuaca ladrillos huan miyac tamanti miltequit. Huan quema tahuel taijyohuiyayaj nopa israelitame ipan nochi ni tequit, noja más nopa egiptome quinchihuilijque ten fiero. ");
INSERT INTO nchBl_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Nojquiya nopa hueyi tanahuatijquet quicamanalhui Sifra huan Fúa, nopa sihuame cati quinpalehuiyayaj israelita sihuame quema conepiyayayaj huan quinilhui: ");
INSERT INTO nchBl_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","―Quema anquipalehuise se hebreo sihuat para conepiyas, xiquitaca taya tacajtoc. Sinta tacajtoc se sihuapil, xijcahuaca ma itzto, pero sinta se oquichpil, xijmictica. ");
INSERT INTO nchBl_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Pero masque quej nopa quinilhui nopa tanahuatijquet, nopa sihuame quiimacasque Toteco Dios huan amo quichijque cati nopa tanahuatijquet quinnahuatijtoya. Quincajque ma itztoca nopa oquichpilme. ");
INSERT INTO nchBl_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Huajca nopa tanahuatijquet ten Egipto tatitanqui ma quinnotzatij nopa ome sihuame huan quintatzintoquili: ―¿Para ten anquincahuilíaj ma itztoca hebreo oquichpilme? ¿Para ten amo anquinmictíaj? ");
INSERT INTO nchBl_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Huan nopa sihuame quinanquilijque Faraón: ―Nopa hebreo sihuame amo tatacatiltíaj yolic quej Egipto sihuame. Más cuali inintacayo huan nimantzi tatacatiltíaj quema tojuanti ayemo tionajsij para tiquinpalehuise. ");
INSERT INTO nchBl_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Huan pampa nopa sihuame quitepanitaque Toteco Dios, yaya quintiochijqui huan quinchijqui nojquiya ma quinpiyaca ininconehua. Huan nopa hebreos o israelitame más momiyaquilijque hasta mochijque tahuel miyaqui. ");
INSERT INTO nchBl_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Huajca Faraón quinmacac se tanahuatili nochi imasehualhua: “Nochi hebreo oquichpilme cati tacatise monequi xiquinmajcahuaca ipan hueyat, pero sihuapilme xiquincahuaca ma itztoca.” ");
INSERT INTO nchBl_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Se tonali se tacat cati eliyaya se iteipan ixhui nopa huejcapan tata Leví mosihuajti ihuaya se sihuat cati nojquiya eliyaya se iteipan ixhui, pero ipan seyoc familia. ");
INSERT INTO nchBl_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Huan isihua conecuic huan quipixqui se icone. Huan quema quiitaque para nopa oquichpil eliyaya yejyectzi, quitatijque para eyi metzti. ");
INSERT INTO nchBl_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Pero quema itatahua ayecmo huelque quitatíaj más tonali, quicuique se chiquihuit cati quichijtoyaj ica acat, huan inana quitzajtzajqui ica chapopojti para amo calaquis at. Teipa quitali nopa pilconetzi iijtic nopa chiquihuit huan quicahuato acatzala iteno nopa hueyat Nilo. ");
INSERT INTO nchBl_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Nojquiya quiilhui ihuelti nopa pilconetzi ma quihuejcatachilijto para quiitas taya ipantis. ");
INSERT INTO nchBl_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Huan más tiotac, iichpoca nopa Faraón inihuaya itequipanojcahua temoque para maltitij hueyat. Huan quema nejnemiyayaj nechca hueyat, quiitaque nopa chiquihuit tatajco ten nopa acame. Huajca nopa ichpocat quititanqui se isihua tequipanojca ma quicuiliti nopa chiquihuit. ");
INSERT INTO nchBl_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Huan quitapo nopa aca chiquihuit huan quitachili iijtic. Huan nopona itztoya se piloquichpiltzi cati chocayaya. Huan iichpoca Faraón quitasojtac huan quiijto: ―Ni se piloquichpiltzi hebreo. ");
INSERT INTO nchBl_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Huajca iicni nopa pilconetzi monechcahui campa iichpoca Faraón huan quiilhui: ―¿Tijnequi ma nijnotzati se sihuat hebrea cati tachichitía para ma quiiscalti ni oquichpil? Huan iichpoca Faraón tananquili: ");
INSERT INTO nchBl_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","―Quena, xijnotzati. Huajca iicni nopa pilconetzi yajqui quinotzato inana, ");
INSERT INTO nchBl_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","huan iichpoca Faraón quiilhui: ―Xijhuica ni oquichpil huan techchichitili, huan na nimitztaxtahuis motequi. Huajca inana nopa piloquichpiltzi quihuicac huan quiiscalti. ");
INSERT INTO nchBl_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Huan quema ya moscaltijtoya, quimactili iichpoca Faraón. Huan nopa ichpocat quichijqui icone huan quitocaxti Moisés. (Moisés quinequi quiijtos Taquixtili.) Quej nopa quitocaxti pampa quiijto: ―Na nijquixti ipan at. ");
INSERT INTO nchBl_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Se tonali quema Moisés ya motacachijtoya, quisqui para quinpaxaloti nopa hebreos pampa quimatqui para quipiyayaya san se esti ica inijuanti huan quiitac para nelohui inintequi. Huan quiitac se tacat Egipto ejquet quihuitequiyaya se tacat hebreo huan quitasojtac, pampa eliyaya san se inieso. ");
INSERT INTO nchBl_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Huajca Moisés tachixqui campa hueli huan quema amo aqui quiitac, quimicti nopa tacat Egipto ejquet huan quitati itacayo ipan xali. ");
INSERT INTO nchBl_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Huan tonili sempa quisqui Moisés huan quiitac para ome hebreos motehuiyayaj, huajca quitatzintoquili cati tatehuiyaya: ―¿Para ten tijmaquilía mohuampo huan san se amoeso anquipiyaj? ");
INSERT INTO nchBl_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Huan nopa hebreo tacat quinanquili: ―¿Ajquiya mitztalijtoc ta quej titayacanquet o tijuez ica tojuanti? ¿Huelis timoilhuía techmictis quej yalohua tijmicti nopa Egipto ejquet? Quema Moisés quicajqui ni tamanti, majmajqui, pampa quimatqui para sequij quimatiyayaj para quimictijtoya nopa tacat Egipto ejquet. ");
INSERT INTO nchBl_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Huan quema Faraón quimatqui para Moisés quimictijtoya se tacat Egipto ejquet, tatitanqui ma quitemotij para quimictis, pero Moisés cholojtejqui huan yajqui itztoti ipan tali Madián. Huan quema ajsito nepa mosehuito nechca se ameli. ");
INSERT INTO nchBl_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Huan nopona ipan tali Madián itztoya se totajtzi cati itoca Reuel huan quinpixtoya chicome iichpocahua. Huan ipan nopa tonali inijuanti hualajtoyaj campa nopa ameli para quiquixtise at huan quitemitise campa atij tapiyalme huan quinamacase inintata iborregojhua. ");
INSERT INTO nchBl_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Pero hualajque sequinoc borrego tamocuitahuiani huan quinquixtijque nopa ichpocame. Huajca Moisés motananqui, huan quinmanahui huan teipa quinamacac ininborregojhua. ");
INSERT INTO nchBl_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Huan quema nopa ichpocame tacuepilijque campa itztoya inintata Reuel ya quintatzintoquili: ―¿Quenicatza ama antacuepilijque nimantzi? ");
INSERT INTO nchBl_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Huan tananquilijque: ―Se Egipto ejquet techmanahui inimaco nopa sequinoc tamocuitahuiani. Huan teipa yaya quiquixti at para tojuanti huan quinamacac toborregojhua. ");
INSERT INTO nchBl_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Huan inintata quintatzintoquili: ―Huan ¿canque itztoc nopa tacat? ¿Para ten anquicajtejque iseltitzi? Xiyaca xijnotzatij ma tacuaqui. ");
INSERT INTO nchBl_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Huan Moisés hualajqui huan mocajqui ipan ichaj Reuel. Huan teipa Reuel quimacac Moisés iichpoca cati itoca Séfora para ma quichihua isihua. ");
INSERT INTO nchBl_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Huan teipa Séfora quipixqui icone huan Moisés quitocaxti Gersón. (Gersón quinequi quiijtos Seyoc Tali Ejquet.) Pampa quiijto: “Ama na niseyoc tali ejquet ipan ni tali cati amo niquixmati.” ");
INSERT INTO nchBl_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Huan Moisés panoc miyac xihuit ipan tali Madián, huan nopa tanahuatijquet ten tali Egipto, mijqui. Pero nopa israelitame noja tahuel taijyohuiyayaj huan mocuesohuayayaj pampa tequipanohuayayaj san tapic. Huan talojtzitzi quitajtaniyayaj Toteco Dios ma quinpalehui ipan inintaijyohuilis. ");
INSERT INTO nchBl_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Huan Toteco quincajqui. Quena, quinchihuili cuenta pampa amo quielcajqui cati ininca mocajtoya Abraham, Isaac huan Jacob para quinmacas iniixhuihua se tali. ");
INSERT INTO nchBl_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Huajca Toteco Dios quinitac nopa israelitame huan quintasojtac. ");
INSERT INTO nchBl_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Se tonali Moisés quinmocuitahuiyaya iborregojhua imontaj, Jetro, cati eliyaya se totajtzi ipan tali Madián. Huan Moisés quinhuicac nopa borregojme hasta nese lado ten nopa huactoc tali hasta se tepet itoca Horeb. (Horeb quinequi quiijtos Nopa Tepet Campa Toteco Itztoc.) ");
INSERT INTO nchBl_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Huan nopona iilhuicac ejca TOTECO monexti ipan se tilelemecti cati tatayaya tatajco se xihuitzonti. Huan Moisés quiitac para nopa xihuitzonti lemeniyaya, pero amo tamiyaya. ");
INSERT INTO nchBl_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Huajca moilhui: “Amo quema niquitztoc se tamanti quej ni. Niyas niquitati para ten amo tamitata nopa xihuitzonti.” ");
INSERT INTO nchBl_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Huan quema TOTECO quiitac para Moisés monechcahuiyaya para quitachilis, quinojnotzqui tatajco ten nopa xihuitzonti huan quiilhui: ―¡Moisés! ¡Moisés! Huan Moisés quiijto: ―Nica niitztoc. ");
INSERT INTO nchBl_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Huajca TOTECO quiilhui: ―Amo ximonechcahui. Xijquixti motecac pampa tatzejtzeloltic ni tali campa timoquetza, pampa nica nojquiya niitztoc na. ");
INSERT INTO nchBl_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Huan TOTECO nojquiya quiilhui: ―Na niininTeco mohuejcapan tatahua Abraham, Isaac huan Jacob. Huajca Moisés moixtzajqui pampa majmajqui para quitachilis Toteco Dios, ");
INSERT INTO nchBl_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","huan TOTECO sempa quiijto: ―Niquitztoc quenicatza taijyohuíaj nomasehualhua cati itztoque ipan tali Egipto. Nijcactoc quenicatza chocaj pampa inintayacancahua fiero quinchihuilíaj. Niquintasojta pampa tahuel taijyohuíaj. ");
INSERT INTO nchBl_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Yeca nitemotoc para niquinmaquixtis inimaco nopa egiptome. Huajca niquinquixtis ipan nopa tali huan niquinhuicas hasta se tali cati hueyi huan cuali cati nochi temaca hasta mocahua itajca. Ipan nopa tali ama itztoque nopa cananeos, heteos, amorreos, ferezeos, heveos huan jebuseos. ");
INSERT INTO nchBl_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Huajca pampa nijtacaquilijtoc quenicatza techtzajtzilíaj nopa israelitame, huan niquitztoc quenicatza nopa egiptome fiero quinchihuilíaj, ");
INSERT INTO nchBl_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ama nimitztitanis tiquitati Faraón. Nijnequi tiyas para tiquinquixtis nopa israelitame ten tali Egipto pampa inijuanti nomasehualhua. ");
INSERT INTO nchBl_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Huajca Moisés quiilhui Toteco Dios: ―¿Pero ajquiya na para niyas nijcamanalhuiti Faraón huan niquinquixtiti ten tali Egipto nopa israelitame? ");
INSERT INTO nchBl_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Huan Toteco Dios quinanquili: ―Na niitztos mohuaya. Huan ya ni elis se tanextili para huelis tijmatis temachti para na nimitztitani. Quema ya tiquinquixtijtos nomasehualhua ipan tali Egipto, antacuepilise nica huan nochi amojuanti antechhueyichihuase ipan ni tepet Horeb. ");
INSERT INTO nchBl_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Pero Moisés quinanquili: ―Pero sinta niyas huan niquinilhuis nopa israelitame para yaya cati ininTeco inihuejcapan tatahua techtitantoc campa inijuanti, techtatzintoquilise quenicatza motoca, huajca, ¿taya niquinilhuis? ");
INSERT INTO nchBl_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Huan Toteco Dios quinanquili: ―NA NIITZTOC CATI NOCHIPA NIITZTOC. Huan tiquinilhuis nopa israelitame: Yaya cati itoca YAYA CATI NOCHIPA ITZTOC techtitantoc campa amojuanti. ");
INSERT INTO nchBl_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Huan nojquiya Toteco Dios quiilhui Moisés: ―Nojquiya xiquinilhui nopa israelitame para na cati niininTECO amohuejcapan tatahua, Abraham, Isaac huan Jacob, mitztitantoc campa inijuanti. Xiquinilhui ya ni elis notoca para nochipa. Ya ni nochipa eliyaya notoca huan nochipa elis notoca. Ica ni notoca techtocaxtise para nochipa nochi masehualme cati tacajtiyase. ");
INSERT INTO nchBl_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Xiya huan xiquinsentili nochi huehue tacame ipan nopa israelitame huan xiquinilhui para na niDIOS cati niininTeco amohuejcapan tatahua, Abraham, Isaac huan Jacob, nimonexti campa ta. Huan nimitzilhui para niquinhualtachilijtoc huan niquitztoc quenicatza fiero quinchihuilíaj ipan tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Huan nojquiya xiquinilhui para niquintencahuilía niquinquixtis ten nopa taijyohuilisti ipan Egipto, huan niquinhuicas ipan nopa tali campa itztoque nopa cananeos, heteos, amorreos, ferezeos, heveos huan jebuseos. Campa niquinhuicas eltoc se tali cati nochi temaca hasta mocahua itajca. ");
INSERT INTO nchBl_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Huan temachti nopa huehue tacame mitzneltocase. Huan teipa monequi tiyas inihuaya para anquiitatij nopa hueyi tanahuatijquet ten tali Egipto. Huan tiquilhuis para na niDIOS cati niamoTECO anhebreo masehualme huan para na nimonexti ica ta. Xiquilhui monequi quincahuas ma yaca israelitame ipan nopa huactoc tali campa amo teno eli. Xiquilhui monequi anyase eyi tonati ipan ojti para antechmacatij tacajcahualisti na, niamoTECO Dios. Quej nopa xiquilhuiti. ");
INSERT INTO nchBl_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Pero na cuali nijmati para nopa tanahuatijquet ten tali Egipto amo amechcahuas anquisase hasta nijnextilis para nelía hueyi nochicahualis. ");
INSERT INTO nchBl_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Yeca na nimomaxitahuas huan niquincocos nopa egiptome ica miyac huejhueyi tiochicahualnescayot cati nijchihuas ipan inintal para niquinnextilis nohueyi chicahualis. Huan teipa, quena, nopa Faraón amechcahuas para anquisase. ");
INSERT INTO nchBl_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Nojquiya nijchihuas para nopa egiptome ma quinequica amechpalehuise huan amechmajmacase tamanti quema anquisase. Yeca quema anquisase, amo anyase san amomax. ");
INSERT INTO nchBl_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Huan monequi sesen sihuat quitajtanis cati icalnechca o seyoc cati ihuaya itztoc para ma quimaca yoyomit cati cuali huan tamanti ten oro huan plata. Huan xiquinyoyontise amoconehua para quej nopa anquinquixtilijtehuase Egipto ehuani nochi cati quipixtoque.” ");
INSERT INTO nchBl_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Huan Moisés tananquili: ―¿Taya nijchihuas sinta nopa israelitame amo techneltocase, yon amo techchihuilise cuenta? Huelis quiijtose para ta, TOTECO, amo timonextijtoc nohuaya. ");
INSERT INTO nchBl_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Huajca TOTECO quiilhui Moisés: ―¿Taya tijpiya momaco? Huan Moisés tananquili: ―Se cuatopili. Huan TOTECO quiilhui: ");
INSERT INTO nchBl_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","―Xijmajcahua talchi. Huan Moisés quimajcajqui talchi huan ipan nopa talojtzi nopa cuatopili mochijqui se cohuat. Huan Moisés motalojtejqui pampa quiimacasiyaya, ");
INSERT INTO nchBl_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","pero TOTECO quiilhui: ―Xiquitzqui ipan icuitapil. Huan Moisés quiitzqui nopa cohuat huan sempa mocuetqui cuatopili. ");
INSERT INTO nchBl_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Huan TOTECO quiilhui: ―Quej nopa tijchihuas iniixpa nopa israelitame para ma quineltocaca para na niininTeco amohuejcapan tatahua, Abraham, Isaac huan Jacob nimonextijtoc moixpa para nimitztequimacas. ");
INSERT INTO nchBl_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Huan TOTECO quiilhui: ―Huan ama, xijcalaqui momax moyolixco. Huan Moisés quicalaqui imax iyolixco huan quema quiquixti, quiitac para quipiyayaya nopa fiero tacayo palanca cocolisti cati itoca lepra huan eliyaya chipahuac quej set. ");
INSERT INTO nchBl_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Huajca TOTECO quiilhui: ―Sempa xijcalaqui momax moyolixco. Huan Moisés quej nopa quichijqui. Huan quema sempa quiquixti imax, ya mochicajtoya huan eltoya cuali quej nochi itacayo. ");
INSERT INTO nchBl_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Huajca TOTECO quiilhui: ―Sinta ica nopa achtohui tanextili, amo mitzneltoquilise, huajca mitzneltocase ica nopa cati ompa. ");
INSERT INTO nchBl_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Pero sinta amo mitzneltocase ica ni ome tanextili, xijquixti at ten nopa hueyat huan xijtoyahua talchi. Huan quema nopa at cati tijquixtis ipan hueyat toyahuis talchi, mochihuas esti. Huan Moisés quiilhui TOTECO: ");
INSERT INTO nchBl_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","―¡Toteco! Na amo hueli nitatenquixtía cuali. Huan amo san ama o yalohua amo nihueli. Ni huejcajquiya. Nochipa quema nicamanalti, ohui quisa camanali ipan nonenepil. ");
INSERT INTO nchBl_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Pero TOTECO quiilhui: ―Na niquinmacatoc inincamac masehualme. Na nijchihua para se ma amo hueli camanalti, o ma amo hueli tacaqui. Nijchihua para se ma tachiya, o ma amo tachiya. ");
INSERT INTO nchBl_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Huajca xiya huan na niitztos mohuaya quema ticamanaltis, huan nimitznextilis cati monequi tiquijtos. ");
INSERT INTO nchBl_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Huan Moisés sempa quiijto: ―¡Toteco! Xijchihua se favor, xijtitani seyoc huan amo na. ");
INSERT INTO nchBl_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Huajca TOTECO cualanqui ihuaya Moisés huan quiilhui: ―¿Tiquita cualtitoc para yas mohuaya moicni Aarón cati nojquiya iixhui mohueyi tata Leví? Na nijmati para ya cuali camanalti. Huan ama huala ipan ojti mitznamiquiqui. Yaya paquis miyac quema mitzitas. ");
INSERT INTO nchBl_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Huajca xijcamanalhui huan xijpohuili nochi cati monequi quiijtos, huan yaya quiijtos cati tiquilhuis. Huan na niitztos amohuaya quema ancamanaltise huan nimechnextilis cati monequis anquichihuase. ");
INSERT INTO nchBl_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ta tiquilhuis Aarón cati monequi quiijtos huan Aarón quinilhuijtiyas sequinoc cati ta tiquilhuis. Yaya camanaltis cati ta ticamanaltisquía huan mitztepanitas quej elisquía ta tiDios. ");
INSERT INTO nchBl_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Pero xijhuica ni cuatopili ipan momax pampa ica ya ni tijchihuas tanextilijcayot cati huejhueyi. ");
INSERT INTO nchBl_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Huajca Moisés tacuepili ichaj imontaj Jetro, huan quiilhui: ―Techcahua ma nitacuepili ipan tali Egipto campa itztoque noicnihua cati san se esti tijpiyaj. Nijnequi niquitas sinta noja itztoque. Huan Jetro tananquili: ―Xiya ica cuali. ");
INSERT INTO nchBl_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","TOTECO quiilhui Moisés quema noja itztoya ipan tali Madián: ―Amo ximajmahui para titacuepilis ipan tali Egipto, pampa ya mijque nochi cati quinequiyayaj mitzmictise. ");
INSERT INTO nchBl_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Huajca Moisés quicuitejqui isihua huan icone huan quinsehuilti ipan se burro huan mocuetqui ipan tali Egipto. Huan ipan imax quihuicayaya nopa cuatopili cati Toteco Dios quimacac. ");
INSERT INTO nchBl_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Huan teipa TOTECO quiilhui Moisés: ―Quema tiajsiti tali Egipto, xiquita para tijchihuas iixpa Faraón nochi nopa tanextili cati nimitzmacatoc chicahualisti xijchihua. Pero na nijyoltetilis para amo quincahuas ma quisaca israelitame. ");
INSERT INTO nchBl_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Huajca tiquilhuis Faraón para na niamoTECO niquijtohua para nopa israelita masehualme niquinicnelía quej se quiicnelía icone achtohui ejquet. ");
INSERT INTO nchBl_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Huan xiquilhui para ya niquilhuijtoc ma quincahua ma quisaca para yase techhueyichihuatij. Pero sinta amo quincahuas ma quisaca, na nijmictis icone achtohui ejquet. Quej nopa xiquilhuiti Faraón. ");
INSERT INTO nchBl_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Huan quema mosiyajquetzqui Moisés huan iteixmatcahua nopa tayohua ipan ojti para tali Egipto, TOTECO monexti ica Moisés, huan quinequiyaya quimictis pampa amo quichijqui quej quiijtohua tanahuatili. Amo quitectoya iyecapa nopa cuetaxti cati eltoc ipan ipiltacayo ioquichpil. ");
INSERT INTO nchBl_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Huajca isihua Moisés cati itoca Séfora quicuic se cuchillo ten tet huan quitequili cati monequi ipan ipiltacayo icone huan quitoxonqui ipan iicxi Moisés huan quiilhui: “Nelía, ta tise nohuehue cati espoltic.” ");
INSERT INTO nchBl_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Huajca TOTECO ayecmo cualanqui ica Moisés huan quicahuili ma yahui. Huan Séfora quitocaxti Moisés “nohuehue cati espoltic” pampa monejqui yaya quitequili icuetaxo icone. ");
INSERT INTO nchBl_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Nojquiya TOTECO quiilhuijtoya Aarón para ma yahui ipan nopa huactoc tali para mopantiti ihuaya Moisés. Huajca Aarón yajqui quinamiquito Moisés ipan nopa tepet campa monextijtoya Toteco Dios. Huan nopona Aarón quitajpalo huan quitzoponi. ");
INSERT INTO nchBl_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Huan Moisés quipohuili Aarón nochi tamanti cati TOTECO quiilhuijtoya ma quiijto, huan nojquiya quinextili nopa huejhueyi tanextili cati quinahuatijtoya ma quichihua. ");
INSERT INTO nchBl_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Huajca Moisés huan Aarón ajsitoj tali Egipto huan quinsentilijque nopa huehue israelita tacame. ");
INSERT INTO nchBl_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Huan Aarón quinpohuili nochi cati TOTECO quiilhuijtoya Moisés, huan quichijqui nopa tanextili cati TOTECO quinextilijtoya ma quichihua. ");
INSERT INTO nchBl_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Huan nochi nopa tacame quineltocaque para TOTECO quintitantoya. Huan quema quimatque israelita masehualme para TOTECO quintacaquilijtoyaj huan quinitztoya quenicatza taijyohuiyayaj, motancuaquetzque iixpa TOTECO huan quihueyichijque. ");
INSERT INTO nchBl_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Teipa Moisés huan Aarón yajque quicamanalhuitoj nopa Faraón huan quiilhuijque: ―TOTECO Dios cati tiisraelitame tijhueyichihuaj mitzilhuía para xiquincahua imasehualhua ma yaca campa huactoc tali para ma quiilhuichihuilitij. ");
INSERT INTO nchBl_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Pero Faraón tananquili: ―¿Huan ajquiya ‘amoTECO’ para na ma nijneltoquili huan ma niquincahua ma yaca ne israelitame? Amo niquixmati amoTECO, huan yon amo niquincahuas ma yaca. ");
INSERT INTO nchBl_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Huajca Moisés huan Aarón quiijtojque: ―Toteco Dios cati toTeco tihebreos hualajtoc technamiquiqui huan techilhuijtoc cati monequi ma tijchihuaca. Huajca techcahua ma tiyaca eyi tonati ipan ojti ipan nopa huactoc tali para tijmacatij tacajcahualisti TOTECO Dios, pampa sinta amo, nohueli timiquise ica se hueyi cocolisti o ica macheta. ");
INSERT INTO nchBl_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Pero nopa tanahuatijquet ten tali Egipto quinilhui Moisés huan Aarón: ―¿Para ten anquintequipolohuaj ni tacame? Ma tacuepilica ipan inintequi. ");
INSERT INTO nchBl_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Huan nojquiya nopa Faraón quinilhui: ―Ama itztoque tahuel miyaqui israelitame ipan ni tali, huan san anquintequipolohuaj. ");
INSERT INTO nchBl_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Huajca ipan nopa tonali Faraón quinmacac se yancuic tanahuatili nopa tayacanani cati quinnahuatiyayaj huan quinhuitequiyayaj nopa israelita tequipanohuani. Quinilhui: ");
INSERT INTO nchBl_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","―Ayecmo xiquinmacaca sacat israelitame para quichihuase soqui ladrillos quej mochijtihualajtoc. Ma yaca inijuanti para quisentilitij nopa sacat cati monequi. ");
INSERT INTO nchBl_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Pero xiquinchihualtica ma temactilica san se imiyaca ladrillos quej achtohui. Yon se ladrillo ma amo polihui. Pampa nopa israelitame tatzcacalactoque huan yeca tahuejchihuaj huan quiijtohuaj quinequij yase quimacatij tacajcahualisti ininTeco. ");
INSERT INTO nchBl_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Huajca xiquinchihualtica ma tequitica más chicahuac nopa tacame. Xiquintequihuica para ma amo quitacaquilica ni istacatili cati Moisés huan Aarón quinilhuíaj. ");
INSERT INTO nchBl_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Huajca nopa tayacanani huan tetecome quisque huan yajque quinilhuitoj nopa israelitame: ―Nopa Faraón tanahuatijtoc ma ayecmo timechmacaca sacat. ");
INSERT INTO nchBl_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Ama monequi anyase anquitemotij. Pero monequi anquitamichihuase san se imiyaca ladrillos quej anquichihuayayaj achtohuiya. ");
INSERT INTO nchBl_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Huajca nopa israelitame campa hueli yajque ipan tali Egipto quitemotoj sacatzonti cati noja mocajtoya ten cati masehualme ya quitzontectoyaj, huan ya nopa quitequihuijque pampa ayecmo oncayaya sacat. ");
INSERT INTO nchBl_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","14","Huan mojmosta itayacancahua Faraón quinisihuiltiyayaj más huan quinilhuiyayaj: ―Xijchihuaca san se imiyaca ladrillos ipan se tonal quej quema amechmacayayaj sacat. Huan nojquiya nopa Egipto tetecome quinmaquiliyayaj nopa israelita tayacanani huan quinilhuiyayaj: ―¿Quenicatza, yon yalohua, yon ama, amo anquiaxitijtoque san se imiyaca ladrillos quej achtohuiya anquichihuayayaj? ");
INSERT INTO nchBl_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Huan nopa israelita tayacanani yajque tajtanitoj tapalehuili ica tanahuatijquet Faraón, huan quiilhuijque: ―¿Para ten quej ni techchihuilía? ");
INSERT INTO nchBl_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Nopa Egipto tetecome ayecmo techmaca sacat. Huan amo san ya nopa, nojquiya technahuatíaj ma tijchihuaca san se imiyaca soqui ladrillos, huan hasta techmaquilíaj pampa amo tihuelij. Pero inijuanti inintajtacol, pampa amo techmacaj sacat. ");
INSERT INTO nchBl_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Huajca Faraón quinnanquili: ―¡San antatzihuini! ¡Quena, antatzihuij! Huan yeca anquiijtojtinemij anyase anquimacatij tacajcahualisti amoTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Xiyaca xitequititij, huan masque ayecmo amechmacase sacat, monequi antemactilise san se imiyaca ladrillos. ");
INSERT INTO nchBl_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Huan nopa tayacanani ten israelitame mocuesojque quema quinilhuijque para monequi ma amo temos imiyaca nopa soqui ladrillos quej achtohuiya quichihuayayaj. ");
INSERT INTO nchBl_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Huan quema quisque iixpa Faraón, quinpantitoj Moisés huan Aarón quinchixtoyaj. ");
INSERT INTO nchBl_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Huan nopa israelita tayacanani quinilhuijque: ―TOTECO ma quiita cati amo cuali anquichijtoque ica tojuanti, huan ma amechtatzacuilti. Amojuanti amotajtacol para itequiticahua Faraón ma techtachilica fiero. Eltoc quej anquitalijtoque macheta ipan inimax para ma techmictica ica cati anquiilhuijtoque nopa tanahuatijquet. ");
INSERT INTO nchBl_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Huajca Moisés motatajti huan quiilhui TOTECO: ―Toteco, ¿para ten tiquinchihuilía cati amo cuali ni masehualme? ¿Para ten techtitanqui? ");
INSERT INTO nchBl_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Hasta ipan nopa tonali quema nihualajqui nijcamanalhuico nopa Faraón quej techilhui, yaya noja más quintaijyohuiltijtoc momasehualhua, huan ta amo teno tijchijtoc para tiquinmaquixtis. ");
INSERT INTO nchBl_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Huan TOTECO quinanquili: ―Ama tiquitas cati nijchihuas ica Faraón. Amo quincahuas nomasehualhua ma quisaca ipan ni tali hasta quiitas ihueyitilis nochicahualis. Pero quema quiitas nochicahualis, hasta quinquixtis para ma yaca. ");
INSERT INTO nchBl_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Huan noja Toteco Dios quicamanalhui Moisés huan quiilhui: ―NiamoTECO Cati Nochipa Niitztoc. ");
INSERT INTO nchBl_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nimonexti ica Abraham, Isaac huan Jacob huan niquinmatilti quenicatza niitztoc pampa niquinilhui notoca: NimoTECO Dios cati nijpiya nochi chicahualisti, pero amo niquinilhui ni seyoc notoca: Na Cati Nochipa Niitztoc. ");
INSERT INTO nchBl_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Nojquiya inihuaya nijchijqui nopa camanali para niquinmacas nopa tali Canaán campa achtohui itztoyaj quej seyoc tali ehuani. ");
INSERT INTO nchBl_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Huan na nijcactoc quenicatza chocaj nopa israelitame pampa nopa egiptome quintequipanoltíaj tahuel chicahuac huan amo niquelcajtoc cati niquintencahuilijtoc. ");
INSERT INTO nchBl_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Ama xiquinilhui nochi israelitame para na niamoTECO niquinmaquixtis ten inintequi cati tahuel ohui ipan ni tali Egipto. Quena, ica na nochicahualis huan ica huejhueyi tanextili, niquinmanahuis. Pampa nijchihuas huejhueyi tanextili para niquintatzacuiltis nopa egiptome pampa quej nopa xitahuac. ");
INSERT INTO nchBl_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Huan xiquinilhuiti na nimoaxcatis nopa israelitame huan elise nomasehualhua. Huan na nielis niininTeco. Quej nopa quimatise para na niininTeco Dios cati niquinmocuitahuía, huan na cati niquinquixtis ten nopa tequit cati tahuel etic ipan ni tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Huan xiquinilhuiti niquinhuicas ipan nopa cuali tali cati niquintencahuili niquinmacas Abraham, Isaac huan Jacob. Huan niquinmacas nopa israelitame nopa tali para elis iniaxca. Xiquinilhui na niininTECO niquijtohua. ");
INSERT INTO nchBl_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Huajca Moisés quinpohuili israelitame nochi ya ni, pero amo quitacaquilijque pampa mocuesohuayayaj ica inintequi cati tahuel chicahuac. ");
INSERT INTO nchBl_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Teipa TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","―Xiya xiquilhuiti Faraón nopa tanahuatijquet ipan tali Egipto para ma quincahua ma quisaca nopa israelitame ten ital. ");
INSERT INTO nchBl_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Pero Moisés quinanquili TOTECO: ―Yon nopa israelitame amo techchihuilíaj cuenta, ¿huajca quenicatza techtacaquilíaj nopa Faraón? Eltoc pampa amo cuali nitatenquixtía quema nicamanalti. ");
INSERT INTO nchBl_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Huajca quej nopa TOTECO quincamanalhui Moisés ihuaya Aarón huan quinilhui cati monequi quinilhuise nopa israelitame huan Faraón. Huan quintequimacac ma quinquixtica israelitame ipan tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Huan ya ni inintoca nochi inintayacanca tatahua israelitame huan ajquiya inijuanti cati tacatque teipa ten sesen hueyitata cati eliyaya itelpocahua Israel. Rubén cati elqui iachtohui cone Israel huejcajquiya quinpixqui iconehua cati inintoca: Hanoc, Falú, Hezrón huan Carmi. Huan sesen ten ni tacame quinpixqui miyac iixhuihua huan sesen mochijqui se hueyi familia, pero nochi hualajque ten Rubén. ");
INSERT INTO nchBl_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Huan Simeón itelpoca Israel huejcajquiya quinpixqui iconehua cati inintoca: Jemuel, Jamín, Ohad, Jaquín, Zohar huan Saúl cati elqui icone se cananea sihuat. Sesen ten ni tacame quinpixqui miyac iixhuihua huan sesen mochijqui se hueyi familia, pero nochi hualajque ten Simeón. ");
INSERT INTO nchBl_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Huan Leví, cati eliyaya itelpoca Israel huejcajquiya, itztoya 137 xihuit. Huan ipan inemilis quinpixqui itelpocahua cati inintoca: Gersón, Coat huan Merari. ");
INSERT INTO nchBl_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Huan iconehua Gersón cati mochijque huejhueyi familias elque: Libni huan Simei. ");
INSERT INTO nchBl_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Huan Coat itztoya 133 xihuit huan iconehua elque: Amram, Izhar, Hebrón huan Uziel. ");
INSERT INTO nchBl_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Huan iconehua Merari elque Mahli huan Musi. Nochi ya ni mochijque huejhueyi familias huan hualajque ten inihueyi tata Leví. Huan pejqui inintoca ica cati achtohui ejquet huan yajtiyajque hasta cati teipan ejquet. ");
INSERT INTO nchBl_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Huan ten iconehua Coat, Amram mosihuajti ihuaya iahui cati eliyaya iicni itata huan itoca eliyaya Jocabed, huan ya quintacatilti Aarón huan Moisés. Huan Amram itztoya 137 xihuit para nochi. ");
INSERT INTO nchBl_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Huan Izhar quinpixqui itelpocahua cati inintoca: Coré, Nefeg huan Zicri. ");
INSERT INTO nchBl_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Huan iconehua Uziel elque: Misael, Elzafán huan Sitri. ");
INSERT INTO nchBl_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Huan Aarón mosihuajti ihuaya Elisabet cati eliyaya iichpoca Aminadab huan isihua icni Naasón, huan quitacatilti Nadab, Abiú, Eleasar huan Itamar. ");
INSERT INTO nchBl_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Huan iconehua Coré elque Asir, Elcana huan Abiasaf. Nochi ya ni mochijque huejhueyi familias huan hualajque ten Coré. ");
INSERT INTO nchBl_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Huan Eleazar, icone Aarón, mosihuajti ica se iichpoca Futiel huan ya quitacatilti Finees. Nochi ni lista eltoc inintoca nopa tacame cati quinyacanque nopa huejhueyi familias ten ininteixmatcahua. Huan nochi hualajque ten inihueyi tata Leví. ");
INSERT INTO nchBl_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Huan ni Aarón huan Moisés cati mopantía inintoca ipan ni lista eltoc san se nopa tacame cati TOTECO quinilhui ma quinchihuaca nopa israelitame ma motecpanaca ica pamit huan ma quinquixtica ipan tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Huan nojquiya elque Moisés huan Aarón cati quicamanalhuitoj Faraón, nopa tanahuatijquet ten tali Egipto para ma quimaca caquihuili quinquixtise nopa israelitame. Huan teipa elque Moisés huan Aarón cati quinyacanque nopa israelitame ten nopa tali. ");
INSERT INTO nchBl_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Huan ipan nopa tonali quema TOTECO quinojnotzqui Moisés ipan tali Egipto, ");
INSERT INTO nchBl_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","quiilhui: ―Na niDIOS. Xiquilhui Faraón nopa tanahuatijquet ipan tali Egipto nochi nopa tamanti cati nimitzilhuía. ");
INSERT INTO nchBl_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Huan Moisés quinanquili TOTECO: ―Na amo nihueli nitatenquixtía cuali quema nicamanalti, huajca ¿quenicatza techtacaquilis nopa Faraón? ");
INSERT INTO nchBl_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Huan huajca TOTECO quiilhui Moisés: ―Xiquita, nimitzchihuas quej tielisquía se Dios quema timoquetzas iixpa Faraón. Huan moicni Aarón elis quej motajtolpanextijca huan yaya camanaltis por ta. ");
INSERT INTO nchBl_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Huan monequi tiquilhuis Aarón nochi cati nimitznahuatis huan teipa yaya camanaltis ihuaya Faraón para ma quincahua ma quisaca ten ital nopa israelitame. ");
INSERT INTO nchBl_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Pero na nijchihuas para nopa Faraón ma moyoltetili huan amo quinequis. Huan nijchihuas ipan tali Egipto miyac tanextili huan tamanti cati amo quema quiitztoque. ");
INSERT INTO nchBl_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Pero nopa Faraón amo amechchihuilis cuenta. Huan na nijtalis nomax ipan Egipto huan nijtatzacuiltis. Huan nijchihuas miyac huejhueyi tamanti para niquintajtolsencahuas hasta niquinquixtis nomasehualhua cati quisase ipan huejhueyi tatehuijca pamit. ");
INSERT INTO nchBl_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Huan quema ya nijnextijtos nochicahualis ipan tali Egipto huan ya niquinquixtijtos nopa israelitame nopona, nopa egiptome quimatise para na niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Huan Moisés huan Aarón quichijque nochi quej TOTECO quinnahuatijtoya. ");
INSERT INTO nchBl_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Huan Moisés quipiyayaya 80 xihuit huan Aarón 83 xihuit quema camanaltique ihuaya Faraón. ");
INSERT INTO nchBl_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Huan TOTECO quinilhui Moisés huan Aarón: ");
INSERT INTO nchBl_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","―Quema Faraón amechilhuis para xijchihuaca se tanextili, xijcui mocuatopil huan xijmajcahua talchi iixpa para ma mochihua se cohuat. ");
INSERT INTO nchBl_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Huajca Moisés huan Aarón yajque quiitatoj Faraón, huan quichijque senquisa cati TOTECO quinnahuatijtoya. Aarón quimajcajqui talchi icuatopil iixpa Faraón huan itapalehuijcahua, huan nopa cuatopili mocuetqui se cohuat. ");
INSERT INTO nchBl_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Huajca Faraón quinnotzqui nopa talnamiquini huan tenahualhuiani huan cati quimatiyayaj tacajcayahuaj huan sesen ten inijuanti nojquiya quichijque cati Aarón quichijtoya ica inintenahualhuijcayo. ");
INSERT INTO nchBl_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Sesen ten inijuanti quimajcajqui icuatopil talchi huan sesen cuatopili mocuetqui cohuat. Pero icuatopil Aarón quincuajqui inincuatopil nopa sequinoc. ");
INSERT INTO nchBl_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Pero masque ya nopa quichijqui, Faraón moyoltetili quej TOTECO quiijtojtoya para quichihuasquía huan amo quichihuili cuenta Moisés. ");
INSERT INTO nchBl_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Teipa TOTECO quiilhui Moisés: ―Faraón moyoltetilijtoc huan amo quincahuas ma quisaca nopa israelitame. ");
INSERT INTO nchBl_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Pero mosta cualca xiya xiquitati quema temos campa at. Xijchiya iteno nopa hueyat Nilo huan xijhuica nopa cuatopili cati mocuetqui cohuat. ");
INSERT INTO nchBl_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Huan nopona tiquilhuis Faraón para na niDios huan niamoTECO nochi anhebreo masehualme. Huan nimitztitantoc tiquilhuis para ma quincahua ma yaca nomasehualhua para techhueyichihuatij ipan huactoc tali, huan niquita para hasta ama, amo techtacaquilijtoc. ");
INSERT INTO nchBl_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Huajca xiquilhui para niamoTECO niquijtohua para ama yaya quimatis para na cati nelía niDios huan niininTECO nopa israelitame. Huan xiquilhui para quema tijmaquilis nopa at ica nopa cuatopili cati tijpiya momaco, nopa at mochihuas esti. ");
INSERT INTO nchBl_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Huan xiquilhui para michime miquise, huan nopa hueyat mijyotis hasta egiptome quiijiyase para quiise nopa at. Quej nopa tiquilhuis Faraón. ");
INSERT INTO nchBl_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Nojquiya TOTECO quiilhui Moisés: ―Xiquilhui Aarón ma quicui icuatopil huan ma quixitahua imax imelac nopa hueyame huan nopa atajme. Ma quixitahua imax ipan campa tameya huan campa quitecaj at ipan tali Egipto, huan nochi mochihuas esti. Huan nojquiya nopa at ipan nochi conme huan tamanti cati quipiyaj at ipan ininchaj mochihuas esti hasta nopa at ipan comit cati quichijtoque ten tet. ");
INSERT INTO nchBl_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Huajca Moisés huan Aarón quichijque nochi senquisa quej TOTECO quinnahuatijtoya. Huan quitananqui icuatopil huan quimaquili nopa hueyat Nilo iixpa Faraón huan itequiticahua, huan nochi at mocuetqui esti. ");
INSERT INTO nchBl_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Huan nochi michime mijque, huan nopa hueyame nelía mijyotiyaya hasta amo aqui hueliyaya ati. Oncayaya esti ipan nochi tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Pero nopa talnamiquini huan tenahualhuiani ipan tali Egipto quichijque san se ica inintenahualhuijcayo, huan huajca Faraón moyoltetili huan amo quitacaquili Moisés huan Aarón, quej TOTECO quiijtojtoya para panos. ");
INSERT INTO nchBl_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Huan Faraón mocuectiquisqui huan yajqui ipan icaltanahuatil, yon amo quichihuili cuenta ni tamanti. ");
INSERT INTO nchBl_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Huan nochi nopa egiptome monejqui quichihuase ameli iteno hueyat para quiquixtise at cati cuali pampa nopa at ipan hueyat amo hueliyaya moi. ");
INSERT INTO nchBl_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Huan TOTECO quichijqui ma mochihua esti nopa at ipan hueyat Nilo, huan teipa panoc chicome tonati. ");
INSERT INTO nchBl_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Huan TOTECO quiilhui Moisés: ―Xiya xiquitati Faraón huan xiquilhuiti para niamoTECO niquijtohua para ma quincahua ma yaca nomasehualhua para techhueyichihuatij. ");
INSERT INTO nchBl_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Pampa sinta amo quincahuas ma yaca, na tahuel nijtatzacuiltis nochi ital ica temasolime. ");
INSERT INTO nchBl_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Nopa hueyat Nilo quinyoliltis tahuel miyac temasolime. Huan nopa temasolime calaquise ipan ichaj, huan calaquise ipan itapech campa cochi. Huan calaquise ipan ininchaj itapalehuijcahua huan imasehualhua. Huan hasta calaquise campa quisajsaltíaj harina huan campa panicxitíaj. ");
INSERT INTO nchBl_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Huan nopa temasolime huitonise ininpani, huan ininpani itequipanojcahua huan ipan nochi imasehualhua. ");
INSERT INTO nchBl_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Huan nojquiya TOTECO quiilhui Moisés: ―Teipa xiquilhui Aarón ma tamanextis ica icuatopil ipan nopa hueyame, atajme, huan campa mantoc at para nopona ma quisaca temasolime huan ma quitemitica ni tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Huajca quej nopa Aarón tamanexti ica icuatopil ipan nopa at cati eltoya ipan tali Egipto, huan nopona quisque temasolime cati quitemitijque nochi nopa tali. ");
INSERT INTO nchBl_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Pero nopa tenahualhuiani nojquiya san se quichijque ica inintenahualhuijcayo. Nojquiya quichijque ma hualaca temasolime ipan tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Teipa Faraón tatitanqui ma quinotzatij Moisés ihuaya Aarón huan quinilhui: ―Xijtajtanica amoTECO para ma techijcuenili ni temasolime na ihuaya nomasehualhua. Huan huajca niquincahuas imasehualhua ma yaca quimacatij tacajcahualisti. ");
INSERT INTO nchBl_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Huan Moisés quinanquili Faraón: ―Nimitzcahuilía para ta techilhui nopa hora quema tijnequi ma nimotatajtis por ta, huan por inijuanti cati mitzpalehuíaj, huan por momasehualhua. Huan ipan nopa hora quema ta tiquijtos, nimotatajtis ica TOTECO para nopa temasolime ma mitztalcahuica, huan ma quitalcahuica amochajchaj. Huan ipan nopa hora amechtalcahuise huan mocahuase san ipan hueyat. ");
INSERT INTO nchBl_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Huajca nopa Faraón quiijto: ―Xijchihua mosta. Huan Moisés tananquili: ―Quej nopa elis, huan yeca tijmatis para amo aqui itztoc quej TOTECO Dios, ");
INSERT INTO nchBl_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","pampa nopa temasolime ayecmo itztose ipan amochajchaj. Mitztalcahuise huan quintalcahuise motequipanojcahua, huan momasehualhua. San mocahuase ipan nopa hueyat Nilo. ");
INSERT INTO nchBl_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Huajca Moisés huan Aarón quisque ipan ichaj Faraón. Huan teipa Moisés quitajtani TOTECO ma quinijcueni nopa temasolime cati quintitantoya ipan Faraón. ");
INSERT INTO nchBl_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Huan TOTECO quichijqui cati Moisés quitajtani, huan mijque nopa temasolime cati itztoyaj ipan calme huan calixpame huan ipan mila. ");
INSERT INTO nchBl_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Huan nopa masehualme quinsentilijque nopa temasolime cati mictoyaj huan quinmontonojque campa hueli huan tahuel mijyotiyayaj. ");
INSERT INTO nchBl_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Pero masque quej nopa elqui, quema Faraón quiitac para ayecmo onca nopa tamanti, moyoltetili huan amo quintacaquili Moisés huan Aarón, quej TOTECO quiijtojtoya para quichihuasquía. ");
INSERT INTO nchBl_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Huajca TOTECO quiilhui Moisés: ―Xiquilhui Aarón ma quixitahua icuatopil huan ma quimaquili nopa taltepocti para ma mochihuaca atime. ");
INSERT INTO nchBl_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Huajca quej nopa quichijqui. Huan Aarón quimaquili nopa taltepocti ica icuatopil, huan mocuetqui atime cati quinajsic nochi masehualme huan tapiyalme, pampa nochi taltepocti mochijque atime. ");
INSERT INTO nchBl_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Huan inijuanti cati tenahualhuíaj quichijque campeca para quinchihuase atime ica inintetanahualhuijcayo, pero amo huelque. Huan oncac atime ipan masehualme huan ipan tapiyalme. ");
INSERT INTO nchBl_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Huajca nopa tenahualhuiani quiilhuijque Faraón: ―¡Ni tamanti san Dios hueli quichihua! Pero Faraón moyoltetili huan amo quintacaquili, quej TOTECO quiijtojtoya para quichihuasquía. ");
INSERT INTO nchBl_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Huan TOTECO quiilhui Moisés: ―Mosta ximijquehua cualca huan xiya xijnamiquiti Faraón quema yas hueyat para maltiti huan xijcamanalhui. Xiquilhui para nimoTECO niquijtohua ma quincahua ma yaca nomasehualhua para ma techhueyichihuatij. ");
INSERT INTO nchBl_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Pampa sinta amo quincahuas ma yaca, na nijtitanis miyac tahuipamit ten sayolime ipan ya, ipan itequiticahua huan ipan nochi imasehualhua. Quena, temis ica sayolime ininchajchaj nochi Egipto ehuani, huan hasta talchi nojquiya temis. ");
INSERT INTO nchBl_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Pero quema quej ni panos niquiyocaquixtis tali Gosén campa itztoque nomasehualhua. Nopona amo oncas yon se sayoli. Quej nopa yaya quimatis para na niamoTECO cati niitztoc ipan ni tali. ");
INSERT INTO nchBl_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Nijchihuas ya ni para nesis catijqui nomasehualhua huan catijqui amo nomasehualhua. Quej ni elis mosta. ");
INSERT INTO nchBl_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Huan TOTECO quej nopa quichijqui. Huan hualajque nochi tamanti sayolime ipan Faraón huan ipan ininchajchaj cati quitequipanohuayayaj. Nochi tali Egipto temic ica sayolime. ");
INSERT INTO nchBl_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Huajca Faraón tanahuati ma quinotzatij Moisés huan Aarón huan quinilhui: ―Xiyaca xijmacatij tacajcahualisti amoTeco Dios, pero amo xiquisaca ten ni tali. ");
INSERT INTO nchBl_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Huan Moisés tananquili: ―Amo cuali tijchihuase quej nopa, pampa anEgipto ehuani anquinijiyaj nopa tapiyalme cati tijmacaj TOTECO Dios. Huan sinta anEgipto ehuani antechitase, na cuali nijmati para antechmictise ica tet. ");
INSERT INTO nchBl_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Monequi tiyase ipan huactoc tali hasta campa hueli tiajsise ipan eyi tonati, huan nopona tijmacase tacajcahualisti TOTECO Dios cati tijtequipanohuaj pampa quej nopa yaya technahuatía. ");
INSERT INTO nchBl_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Huajca nopa Faraón quiijto: ―Na nimechcahuas xiyaca ipan huactoc tali para xijmacaca itacajcahualis amoTECO Dios, pero amo xiyaca nelhuejca. Huan xijtajtanica amoTECO Dios por na. ");
INSERT INTO nchBl_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Huan Moisés tananquili: ―Quema na niquisas nica, nijtajtanis TOTECO para mosta ma mitztalcahuica nopa sayolime. Huan nojquiya quintalcahuise cati mitzpalehuíaj huan nochi Egipto ehuani. Pero ximomocuitahui amo techcajcayahuaca, yon ayecmo xiquintzacuili israelitame para yase quimacatij tacajcahualisti TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Huan quema Moisés quisqui ichaj Faraón, quitajtani TOTECO, ma tamica nopa sayolime, ");
INSERT INTO nchBl_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","huan TOTECO quichijqui cati Moisés quitajtani. Huan nopa sayolime quitalcahuijque Faraón, huan itayacancahua huan nochi Egipto ehuani. ");
INSERT INTO nchBl_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Pero Faraón sempa moyoltetili, huan amo quincahuili ma yaca nopa israelitame. ");
INSERT INTO nchBl_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Huajca TOTECO quiilhui Moisés: ―Xiya xiquitati Faraón huan xiquilhuiti para na niDIOS, niininTECO hebreo masehualme, huan na niquilhuía ma quincahua nomasehualhua ma yaca techhueyichihuatij. ");
INSERT INTO nchBl_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Huan xiquilhui sinta amo quincahuas ma yaca huan noja quintzacuilijtos, ");
INSERT INTO nchBl_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","huajca na niininTECO nijtalis nomax ipan itapiyalhua cati itztoque campa potrero, huan niquinmacas se hueyi cocolisti cati nelfiero. Nopa cocolisti quinajsis icahuayojhua, iburrojhua, icamellos, ihuacaxhua, huan iborregojhua. ");
INSERT INTO nchBl_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Pero na niininTECO niquiniyocatalis inintapiyalhua israelitame ica cati iniaxcahua nopa Egipto ehuani, pampa amo nijcahuas ma miqui yon se tapiyali ten israelitame. ");
INSERT INTO nchBl_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Nojquiya TOTECO tayolmelajqui nopa tonali quema quichihuas pampa quiijto: ―Na nijchihuas ni tamanti mosta. ");
INSERT INTO nchBl_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Huan tonili TOTECO ya nopa quichijqui. Nochi inintapiyalhua Egipto ehuani mijque, pero amo mijqui yon se inintapiyal israelitame. ");
INSERT INTO nchBl_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Huan Faraón tatitanqui ma yaca quiitatij inintapiyalhua nopa israelitame huan quipantitoj yon se tapiyali amo mictoya. Pero masque ya nopa elqui, Faraón moyoltetili huan amo quincahuili ma yaca nopa israelitame. ");
INSERT INTO nchBl_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Huajca TOTECO quinilhui Moisés huan Aarón: ―Xijcuica ome tamojtzoli cuajnexti campa quiicxitíaj pantzi huan xijmajcahua para huejcapa ipan ajacat iixpa Faraón. ");
INSERT INTO nchBl_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Huan nopa cuajnexti mochihuas taltepocti cati más cuechtic huan mosemanas ipan nochi tali Egipto huan quichihuas ma quisaca miyac taxhuisme ipan nochi masehualme huan tapiyalme ipan tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Huajca Moisés ihuaya Aarón quicuique cuajnexti campa quiicxitíaj pantzi huan yajque quiitatoj Faraón. Nopona Moisés quimajcajqui nopa cuajnexti para huejcapa, huan ya nopa quichijqui ma quisaca taxhuisme cati temalohuayayaj ipan nochi masehualme huan tapiyalme. ");
INSERT INTO nchBl_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Huan nopa tenahualhuiani amo huelque monextijque iixpa Moisés pampa inijuanti nojquiya quinpixque taxhuisme campa hueli quej nochi Egipto ehuani. ");
INSERT INTO nchBl_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Pero TOTECO quichijqui para nopa Faraón ma moyoltetili huan ma amo quintacaquili Moisés huan Aarón, quej TOTECO quiilhuijtoya Moisés. ");
INSERT INTO nchBl_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Huajca TOTECO quiilhui Moisés: ―Mosta ximijquehua cualca huan xiya xiquilhuiti Faraón para na niininTECO nopa hebreo masehualme huan niquijtohua ma quincahua ma yaca nomasehualhua para techhueyichihuatij. ");
INSERT INTO nchBl_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Pampa ni huelta nijtitanis se tatzacuiltili cati ajsis ipan iyolo Faraón, huan ipan iniyolo nochi cati quipalehuíaj huan nochi imasehualhua. Huan ica ya ni yaya quimatis para amo aqui seyoc Dios ipan nochi taltipacti, san na. ");
INSERT INTO nchBl_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Xiquilhui Faraón para na nihueltosquía nijmictijtosquía ica se cocolisti ihuaya nochi imasehualhua. ");
INSERT INTO nchBl_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Pero xiquilhui na nijtali ipan itequi huan nijcajtoc ma itzto hasta ama para nijnextilis nohueyi chicahualis huan para nochi masehualme ipan taltipacti ma quicaquica ajquiya na. ");
INSERT INTO nchBl_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Pero masque quiitztoc nochi cati nijchijtoc iixpa, noja quintzacuilía nomasehualhua huan amo quincahua ma yaca. ");
INSERT INTO nchBl_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Huajca xiquilhui para mosta ipan ni hora nijchihuas ma huetzi tesihuit nelchicahuac quej amo quema huetztoc ipan nochi tali Egipto hasta quema pejqui ni tali huan hasta ama. ");
INSERT INTO nchBl_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Huajca xiquilhui para nimantzi ma tanahuati ma quintzacuaca inintapiyalhua, pampa nopa tesihuit quinmictis nochi masehualme huan nochi tapiyalme cati amo quintzacuase calijtic. ");
INSERT INTO nchBl_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Huan sequij itapalehuijcahua Faraón quineltocaque cati TOTECO quiijto huan moisihuiltijque quincalaquij calijtic nochi inintapiyalhua huan inintequipanojcahua cati quincojtoyaj. ");
INSERT INTO nchBl_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Pero itztoyaj sequij cati san quiahuilmatque icamanal TOTECO cati Moisés quinilhuijtoya, huan quincajque ipan cuatitamit huan amo quintzajque calijtic. ");
INSERT INTO nchBl_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Huajca TOTECO quiilhui Moisés: ―Xijtanana momax huan xijmanexti ilhuicacti para ma huetzi tesihuit campa hueli ipan nochi tali Egipto. Huetzis ipan nochi masehualme huan tapiyalme huan huetzis ipan nochi tatocti ipan inimil Egipto ehuani. ");
INSERT INTO nchBl_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Huajca Moisés quitananqui icuatopil hasta ilhuicac huan TOTECO quititanqui tatomonilot, tapetanilot huan tesihuit ipan nochi tali Egipto. Huan nelía fiero elqui. ");
INSERT INTO nchBl_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Tahuel chicahuac huetzqui nopa tesihuit huan tapetaniyaya huan amo motilquetzayaya. Hasta ipejya Egipto amo quema huetztoya se tesihuit quej nopa. ");
INSERT INTO nchBl_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Huan nopa tesihuit quipolo nochi cati oncayaya ipan tali Egipto. Quinmicti nochi masehualme huan tapiyalme cati amo itztoyaj calijtic, huan quipolo nochi tatocti ipan mili huan nochi cuame ipan inintal. ");
INSERT INTO nchBl_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","San ipan tali Gosén campa itztoyaj israelitame, amo huetzqui yon se tesihuit. ");
INSERT INTO nchBl_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Huajca nopa Faraón tatitanqui ma quinnotzatij Moisés huan Aarón huan quinilhui: ―Ama nitajtacolchijtoc. Cati amoTECO quichihua, ya nopa xitahuac huan cati na huan nomasehualhua tijchihuaj, amo cuali. ");
INSERT INTO nchBl_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Nelmiyac tatomonilot huan tesihuit techajsitoc, huajca ayecmo niquintzacuilis más nopa israelitame. Xijtajtanica, amoTECO, por tojuanti para ma ayecmo huetzi tesihuit, huan na niquincahuas ma yaca israelitame. ");
INSERT INTO nchBl_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Huan Moisés quinanquili: ―Nimantzi quema niquisas ten ni altepet, nijtananas nomax huan nimotatajtis ica TOTECO. Huan ayecmo huetzis nopa tesihuit huan ayecmo tatomonis, huan quej nopa tijmatis para ni taltipacti iaxca TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Pero na cuali nijmati para yon ta, yon cati mitzpalehuíaj, amo anquitepanitaj TOTECO Dios. ");
INSERT INTO nchBl_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Huan nochi nopa tatocti cati itoca lino huan cebada nenpolijque, pampa nopa cebada ya eltoya para xitinis huan nopa lino xochiyojtoya. ");
INSERT INTO nchBl_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Pero nopa trigo ihuaya nopa centeno amo teno ipantic, pampa xitini teipa. ");
INSERT INTO nchBl_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Huan quema Moisés quisqui campa Faraón huan campa nopa altepet, quitananqui imax ica TOTECO huan motatajti. Huan nimantzi nochi motilquetzqui. Ayecmo huetzqui tesihuit, yon ayecmo taquiyajqui, huan ayecmo tatomonqui. ");
INSERT INTO nchBl_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Pero quema nopa Faraón quiitac para ayecmo taquiyahuiyaya, yon ayecmo huetziyaya tesihuit, yon ayecmo tatomoniyaya, sempa tajtacolchijqui. Huan amo san ya moyoltetili, pero nojquiya san se quichijque nochi cati quipalehuiyayaj. ");
INSERT INTO nchBl_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Huan pampa moyoltetili, Faraón amo quincahuili ma yaca nopa israelitame quej TOTECO teyolmelajtoya ica Moisés para quichihuasquía. ");
INSERT INTO nchBl_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Huan TOTECO quiilhui Moisés: ―Xiya xiquitati Faraón pampa na nijchijtoc para ya ihuaya itequiticahua ma moyoltetilica para huelis nijchihuas ni huejhueyi tanextili cati nijchihua iniixpa. ");
INSERT INTO nchBl_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Huan yeca se tonali ta huelis tiquinpohuilis moconehua huan moixhuihua nopa huejhueyi tamanti cati nijchijqui iniixpa Egipto ehuani. Quena, niquinyoltetilijtoc para xijmatica para na niDIOS, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Huajca Moisés huan Aarón yajque quiitatoj Faraón huan quiilhuijque: ―TOTECO Dios cati tihebreo masehualme tiquixmatij mitztajtanía hasta quema timoechcapanos iixpa. Quiijtohua monequi xiquincahua ma yaca imasehualhua para ma quihueyichihuatij. ");
INSERT INTO nchBl_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Quiijtohua sinta amo tijchihuas, mosta quichihuas ma hualaca chapolime ipan motal. ");
INSERT INTO nchBl_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Huan nopa chapolime quitemitise ni tali hasta ayecmo nesis talchi. Quicuase cati quentzi mocahua ama ten cati anquitojque cati amo nenpolij ica tesihuit. Huan nopa chapolime quicuase nochi cuame cati mocahua. ");
INSERT INTO nchBl_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Temise ipan mochaj huan ininchajchaj motequipanojcahua huan nochi sequinoc Egipto ehuani. Ipan nochi ininemilis, amotatahua yon amohuejcapan tatahua cati huejcajquiya itztoyaj amo quema quiitztoque se tamanti quej cati ama nijchihuas. Quema Moisés tanqui camanalti, moicancuetqui huan quisqui ten ichaj Faraón. ");
INSERT INTO nchBl_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Huan itequiticahua Faraón quiilhuijque: ―¿Hasta quema ni tacat noja techcuesolmacas? Xiquincahua ma yaca nopa masehualme ma quihueyichihuatij ininTECO Dios. ¡Ay Tanahuatijquet! ¿Ayemo tiquita para total Egipto ya tamisosolijtoc? ");
INSERT INTO nchBl_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Huan Faraón tatitanqui sempa ma quinnotzatij Moisés huan Aarón huan quinilhui: ―Xiyaca xijhueyichihuatij, amoTECO Dios. Pero achtohui techilhuica ajquiya inijuanti yase. ");
INSERT INTO nchBl_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Huan Moisés tananquili: ―Monequi nochi tiyase. Yase topilconehua hasta tohuehue masehualhua. Yase totelpocahua, toichpocahua, nochi toborregojhua huan nochi tohuacaxhua, pampa tijchihuase se hueyi ilhuit para TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Pero nopa Faraón quinilhui: ―Tanemijya nesi para amo ya nopa cati anquichihuase. ¿Anmoilhuíaj para na nimechcahuas anyase inihuaya nochi amosihuajhua huan amoconehua huan para amoTeco yas amohuaya? ");
INSERT INTO nchBl_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","¡Amo! ¡Amo quej nopa elis! Xiyaca san antacame para xijhueyichihuatij amoTECO, pampa ya nopa cati anquiijtohuaj anquinequij. Huan itapalehuijcahua quinquixtijque Moisés huan Aarón iixpa Faraón. ");
INSERT INTO nchBl_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Huan TOTECO quiilhui Moisés: ―Xijxitahua momax ipan tali Egipto para ma hualaca chapolime huan ma quitemitica. Ma quicuaca nochi tatocti huan nochi cati mocajqui quema huetzqui tesihuit campa hueli ipan inintal. ");
INSERT INTO nchBl_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Huan yeca Moisés quixitajqui imax ipan tali Egipto, huan TOTECO quichijqui ma huala se ajacat campa quisa tonati huan quiilpitzqui nopa tali se tonal huan se yohuali. Huan tonili nopa ajacat ya quinhualicatoya chapolime. ");
INSERT INTO nchBl_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Huan nopa chapolime calajque campa hueli ipan inintal. Amo quema oncatoya imiyaca chapolime quej nopa ipan se tali, yon ayecmo quema oncas. ");
INSERT INTO nchBl_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Quitemitijque nopa tali hasta amo nesiyaya talchi, huan quicuajque nochi tatocti huan nochi cuatacti cati mocajtoya ipan cuame cati momanahuij quema huetzqui tesihuit. Amo teno cati xoxohuic mocajqui ipan nochi tali Egipto, yon ipan cuame, yon ipan mila. ");
INSERT INTO nchBl_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Huajca Faraón tatitanqui nimantzi ma quinnotzatij Moisés huan Aarón huan quinilhui: ―Nitajtacolchijtoc ica amoTECO Dios huan ica amojuanti, ");
INSERT INTO nchBl_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","pero nimechtajtanía para san ni huelta techtapojpolhuica notajtacol. Huan ximotatajtica ica amoTECO Dios por na para ma techtalcahui ni tatzacuiltili cati temictía. ");
INSERT INTO nchBl_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Huan Moisés quisqui ichaj Faraón, huan motatajti ica TOTECO por ya. ");
INSERT INTO nchBl_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Huan TOTECO quipatac iojhui nopa ajacat, huan mocuetqui se chicahuac ajacat campa temo tonati huan quinhuicac nopa chapolime huan quinmajcajqui ipan Hueyi At cati itoca Chichiltic. Huan amo mocajqui ipan Egipto yon se chapoli. ");
INSERT INTO nchBl_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Pero TOTECO quichijqui para Faraón ma moyoltetili huan ma amo quincahuili ma yaca nopa israelitame. ");
INSERT INTO nchBl_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Huajca TOTECO quiilhui Moisés: ―Xijxitahua momax para ilhuicac, huan ipan nochi tali Egipto ma onca se tzintayohuilot cati nelyayahuic huan tilahuac hasta huelis tiquitzquis. ");
INSERT INTO nchBl_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Huajca Moisés quitananqui imax para ilhuicac, huan oncac se tzintayohuilot nelhueyi ipan tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Para eyi tonati amo aqui hueliyaya quiita cati icalnechca huan amo aqui quisqui ipan ichaj. Pero ipan nochi ininchajchaj nopa israelitame oncayaya taahuili. ");
INSERT INTO nchBl_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Huajca nopa Faraón tatitanqui ma quinotzatij Moisés huan quiilhui: ―Xiyaca xijhueyichihuatij amoTECO, huan xiquinhuicaca nojquiya amoconehua, pero ma mocahuaca nica amoborregojhua inihuaya amohuacaxhua. ");
INSERT INTO nchBl_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Pero Moisés tananquili: ―¡Amo tihuelise! Monequi techcahuas ma tiquinhuicaca nopa tapiyalme para nopa tacajcahualisti cati tijtatise para tijmacase TOTECO Dios. ");
INSERT INTO nchBl_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Huajca nojquiya totapiyalhua yase tohuaya. Yon se tapiyali amo hueli tijcajtehuase pampa monequi tiquintapejpenise sequij inijuanti cati titemacase quema tijhueyichihuase TOTECO Dios. Huan amo tijmatise taya tapiyalme tiquintequihuise hasta tiajsise nepa. ");
INSERT INTO nchBl_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Pero TOTECO quichijqui para Faraón ma moyoltetili huan amo ma quincahuili ma yaca. ");
INSERT INTO nchBl_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Nojquiya Faraón quiilhui Moisés: ―Techtalcahui huan ximomocuitahui para ayecmo techixtachiliqui sempa. Ipan nopa tonali quema timonextiqui noixpa, timiquis. ");
INSERT INTO nchBl_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Huan Moisés quinanquili: ―Cuali cati tiquijtojtoc. Ayecmo quema nimitzitas sempa. ");
INSERT INTO nchBl_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Huan TOTECO quiilhui Moisés: ―Noja nijhualicas seyoc tatzacuiltili ipan Faraón huan nopa egiptome. Huan teipa amo san amechcahuas xiyaca, pero quena, hasta amechquixtis. ");
INSERT INTO nchBl_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ama xiquinilhui israelitame para monequi nochi tacame huan sihuame ma quitajtanica inincalnechcahua tamanti ten oro huan plata. ");
INSERT INTO nchBl_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Huan TOTECO quichijtoya para nopa egiptome ma quincualitaca nopa israelitame. Yeca quinmajmacaque nopa israelitame cati quintajtaniyayaj. Nojquiya nopa tequichihuani cati quipalehuiyayaj Faraón quitepanitaque Moisés huan nochi egiptome nojquiya quicualitaque. ");
INSERT INTO nchBl_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Huajca Moisés quiilhui Faraón: ―TOTECO quiijtohua para tajco yohual panos ipan nochi tali Egipto, ");
INSERT INTO nchBl_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","huan quinmictis nochi amoachtohui conehua ipan nochi amochajchaj nochi anEgipto ehuani. Miquis moachtohui cone ta tiFaraón cati timosehuía ipan nopa siyaj yejyectzi campa titanahuatía huan hasta miquis iachtohui cone sesen sihua tequipanojquet cati tisi para iteco. Nojquiya miquise nochi iniachtohui conehua amotapiyalhua. ");
INSERT INTO nchBl_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ipan nochi tali Egipto, masehualme axtise chicahuac quej amo quema quichijtoque, huan quej ayecmo quema quichihuase sempa. ");
INSERT INTO nchBl_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Pero campa itztoque israelitame, yon se chichi amo taajhuas huan amo miquis yon se masehuali o tapiyali. Huajca Faraón ta tijmatis para TOTECO nelía quinicnelía israelitame. ");
INSERT INTO nchBl_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Huan hualase techitaquij nochi ni tequichihuani cati mitzpalehuíaj huan motancuaquetzase noixpa para techilhuise chicahuac para ma tiyaca inihuaya nochi tomasehualhua. Huan quema panos ya nopa, huajca quena, niyas. Huan Moisés quisqui iixpa nopa Faraón nelcualantoc. ");
INSERT INTO nchBl_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Huan TOTECO ya quiilhuijtoya Moisés: ―Nopa Faraón amo amechtacaquilis, huan yeca quej nopa nijchihuas noja más huejhueyi tiochicahualnescayot ipan Egipto para niquinnextilis nohueyi chicahualis. ");
INSERT INTO nchBl_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Huajca masque Moisés ihuaya Aarón quichijque nochi ni huejhueyi tiochicahualnescayot iixpa Faraón, TOTECO quichijtoya ma moyoltetili Faraón huan yeca amo quincahuili ma quisaca nopa israelitame ten tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Huan ipan tali Egipto TOTECO camanaltic ihuaya Moisés huan Aarón, huan quinilhui: ");
INSERT INTO nchBl_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Ama huan para nochipa ni metzti elis nopa achtohui metzti ten amoxihui anisraelitame. Huan ni metzti elis cati más ipati para amojuanti. ");
INSERT INTO nchBl_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Xiquinilhuica nochi israelitame para ama huan teipa sesen xihuit ipan 10 itequi ni metzti, sesen ten amojuanti ma quicui se pilborregojtzi o se oquich chivo para ifamilia. Sese familia quicuis san para ichaj. ");
INSERT INTO nchBl_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Huan sinta pisiltzi se familia huan amo hueli quicuase nochi se pilborregojtzi, huajca ma quitajcoitase se pilborregojtzi ihuaya cati itztoque icalnechca huan quicuase san sejco. Monequi quinpohuase quesqui inimiyaca nopa masehualme cati itztoque huan quesqui imiyaca cati sesen huelis quicuas para quimatise quenicatza ihuexca se pilborregojtzi huelise quitamise. ");
INSERT INTO nchBl_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Huan xiquinilhuica monequi quitapejpenise se oquich tapiyali cati quipiya se xihuit, huan cati amo teno cati amo cuali quipiya itacayo. Huelis quitequihuise se pilborregojtzi o se chivo. ");
INSERT INTO nchBl_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","“Monequi quiajocuise nopa tapiyali cati quitapejpenise hasta 14 itequi ni metzti. Huan ipan nopa tonali quema tiotaquixtos, sesen familia ten israelitame quimictise inintapiyal. ");
INSERT INTO nchBl_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Huan teipa quicuise ieso nopa tapiyali huan quipolose nopa tencuayomit cati eltoc itzompac icalte nopa cali campa quicuase inacayo. Nojquiya quipolose nopa caltemit itencuayo cati eltoc ipan inejmat huan iarraves. ");
INSERT INTO nchBl_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Huan ipan nopa tayohua quicuase nopa nacat tacacatzoli. Huan quicuase ica quilit cati chichic huan pantzi cati amo quipiya tasonejcayot. ");
INSERT INTO nchBl_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ma amo quicuaca nopa nacat xoxohuic, yon tapahuaxti. Monequi anquitihuatzase nopa tapiyali yajmaxtic ica itzonteco, imetz huan nochi cati quipixtoc iijtico. ");
INSERT INTO nchBl_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Huan amo teno hueli anquicahuase para seyoc tonali. Sinta se tamanti mocahua nopa tayohua huan amo anquitamicuase, monequi anquitatise. ");
INSERT INTO nchBl_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","“Quej ni antacuase. Achtohui ximoyoyontica ica amotaque huan ximoilpica. Xijquixtica amotecac huan xijpixtoca amocuatopil amomaco. Huan huajca, quena, xijcuaca nimantzi nopa tapiyali, pampa ya nopa noPascua, niamoTECO, quema na nimechpanos pero amo aqui ten amojuanti miquis. ");
INSERT INTO nchBl_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Pero ipan nopa tayohua nipanos ipan nochi tali Egipto huan niquinmictis nopa oquichpilme cati achtohui ehuani ipan sesen familia ten egiptome huan nopa oquichti cati achtohui tacatqui ten inintapiyalhua. Huan niquintamiltis nochi inintaixcopincayohua nopa Egipto ehuani. Na niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","“Huan nopa esti elis quej se tanextili ipan calme para xijnextica campa anitztoque. Huajca quej nopa quema niquitas nopa esti, san nimechcalpanos huan amo teno ininpantis amoconehua quema niquinmictis nopa Egipto ehuani ininconehua. ");
INSERT INTO nchBl_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Huan ni tonali quema niquintatzacuiltis egiptome monequi anquielnamiquise sesen xihuit. Ipan ni tonali monequi antechchihuilise se hueyi ilhuit na, niamoTECO. Anquichihuase ni ilhuit para nochipa huan ni ilhuit panos ten tetajme hasta ininconehua. ");
INSERT INTO nchBl_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Huan ipan nopa ilhuit anquicuase pantzi cati amo quipiya tasonejcayot para chicome tonati. Huajca ipan nopa achtohui tonali monequi xijquixtica nochi tasonejcayot ipan amochajchaj. Sinta acajya quicuas pantzi cati quipiya tasonejcayot ipan nopa chicome tonati ipan nopa ilhuit, monequi xijquixtica ten israelitame para nochipa. ");
INSERT INTO nchBl_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ipan nopa achtohui tonali ximosentilica san sejco ipan se tasentili cati tatzejtzeloltic huan sempa ximosentilica ipan nopa chicompa tonali. Ma amo aqui tequitis ipan nopa tonali. San huelis anquisencahuase tacualisti para nochi ma tacuaca. ");
INSERT INTO nchBl_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Quena, xijchihuaca nopa ilhuit ten pantzi cati amo quipiya tasonejcayot sesen xihuit ipan ni tonali quema nimechquixti nochi amojuanti ipan tali Egipto. Huajca xiilhuichihuaca ipan ni tonali para nochipa. Huan ni ilhuit panos ten tetajme hasta ininconehua para nochipa. ");
INSERT INTO nchBl_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Quena, sesen xihuit ica tiotac ipan 14 itequi nopa achtohui metzti, xipehuaca xijcuaca pantzi cati amo quipiya tasonejcayot huan san ya nopa xijcuaca hasta tiotac ipan 21 itequi nopa metzti. ");
INSERT INTO nchBl_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","“Monequi amo oncas tasonejcayot ipan amochajchaj para nopa chicome tonati. Pampa sinta acajya quicuas pantzi ica tasonejcayot, monequi anquiquixtise ten israelitame. San se anquichihuase masque quicuas se cati ehua seyoc tali, o se israelita cati nopona ehua. ");
INSERT INTO nchBl_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Amo teno xijcuaca cati quipiya tasonejcayot, masque campa hueli anitztoque. Monequi xijcuaca san nopa pantzi cati amo quipiya tasonejcayot.” Quej nopa TOTECO quiilhui Moisés huan Aarón ma quinilhuitij israelitame. ");
INSERT INTO nchBl_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Huajca Moisés quinnotzqui nochi nopa huehue tacame cati tayacanayayaj ipan israelitame huan quinilhui: “Xiyaca nimantzi huan xijtapejpenica sesen ten amojuanti se pilborregojtzi o se chivo para amofamilias, huan xiquinmictica para anilhuichihuase para nopa Pascua. ");
INSERT INTO nchBl_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Xijcuica se tatzquili ten nopa xihuit cati itoca hisopo huan xijxolonica ipan nopa esti cati eltoc ipan huajcali. Huan xijpoloca itzompac huan ipan nochi inejmat huan iarraves itencuayo amocalte. Huan yon se ten amojuanti amo hueli quisas calteno hasta quema tanesis. ");
INSERT INTO nchBl_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Huan quema TOTECO panos para quinmictis nopa egiptome, sinta quiitas nopa esti itzompac huan ipan nochi ome iteno se caltemit, huajca san quipanos nopa cali. Quej nopa, TOTECO amo quicahuilis nopa tasosolojquet ma calaqui ipan amochajchaj para quinmictis amoconehua. ");
INSERT INTO nchBl_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Monequi amojuanti ihuaya amoixhuihua, xijtepanitaca ni tanahuatilme para nochipa. ");
INSERT INTO nchBl_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Huan quema ya ancalactose ipan nopa cuali tali cati TOTECO amechmacas quej amechtencahuilijtoc, monequi anquichihuase ni tamanti. ");
INSERT INTO nchBl_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Huan quema amoconehua amechtatzintoquilise taya quiijtosnequi ni ilhuit cati anquichihuaj, ");
INSERT INTO nchBl_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","xiquinilhuica para ni tapiyali ten Pascua cati tijmictíaj eltoc se tacajcahualisti para TOTECO. Techelnamiquiltía quenicatza elqui quema TOTECO quinmicti nopa egiptome, pero san quipanoc tochajchaj tiisraelitame cati nojquiya tiitztoyaj ipan tali Egipto huan amo quimicti yon se ten tofamilias.” Quej nopa Moisés quinpohuili nopa israelita tayacanani. Huan nopa tayacanani motancuaquetzque huan mohuijtzonque talchi huan quihueyichijque TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Huan teipa yajque huan quichijque cati TOTECO quinahuatijtoya Moisés huan Aarón. ");
INSERT INTO nchBl_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Huan tajco yohual TOTECO quimicti sese achtohui ejquet ipan sesen familia ten Egipto ehuani. Quimicti iachtohui cone Faraón cati mosehuía ipan nopa yejyectzi siyaj para tanahuatis, hasta iniachtohui cone cati itztoya ipan tatzacti, huan nojquiya quinmicti iniachtohui conehua nochi tapiyalme. ");
INSERT INTO nchBl_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Huajca nopa tayohua mijquejque Faraón huan nochi itequiticahua cati quipalehuiyayaj, huan nochi sequinoc egiptome, huan campa hueli ipan nochi nopa tali Egipto nochi chocayayaj huan tahuejchihuayayaj. Amo oncayaya yon se cali ten Egipto ehuani campa amo oncayaya se mijcatzi. ");
INSERT INTO nchBl_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Huajca ipan nopa tayohua Faraón tatitanqui ma quinotzatij Moisés ihuaya Aarón, huan quinilhui: ―Amantzi xiquisaca. Xiyaca amojuanti inihuaya nochi nopa israelitame. Xiquincahuaca nomasehualhua. Xiyaca xijhueyichihuatij amoTECO quej anquiijtojque. ");
INSERT INTO nchBl_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Xiquinhuicaca nojquiya amoborregojhua huan amohuacaxhua quej anquiijtojtoyaj, huan xiyaca. Huan xijtajtanica, amoTECO, por na. ");
INSERT INTO nchBl_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Huan nopa Egipto ehuani quinisihuiltijque nopa israelitame para ma quisaca ten nopa tali pampa moilhuiyayaj huelis nochi egiptome miquisquíaj. ");
INSERT INTO nchBl_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Huajca nopa israelitame quicuique inintix, masque ayemo quipiyayaya tasonejcayot para mosonehuas. Huan quitalijque ipan tixhuapali, huan quimimilojque ica yoyomit huan quitalijque iniajcoltipa. ");
INSERT INTO nchBl_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Nojquiya quichijque cati Moisés quinnahuatijtoya huan quintajtanijque nopa egiptome yoyomit huan tamanti ten oro huan plata. ");
INSERT INTO nchBl_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Huan TOTECO quichijqui para nopa Egipto ehuani ma quincualitaca nopa israelitame huan quinmacaque nochi cati tajtaniyayaj, huan yeca nopa israelitame nelía quintaquijquixtilijque nopa egiptome. ");
INSERT INTO nchBl_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Huan nopa israelitame quisque Ramesés huan nejnenque hasta Sucot. Huan sinta mopohuasquíaj san inijuanti cati ya quipiyayayaj xihuit para tatehuise, mochihuayayaj nechca 600 mil, pero amo quinpojque sihuame huan coneme. Huan nochi icxinejnemiyayaj. ");
INSERT INTO nchBl_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Huan inihuaya yajque miyac tamanti masehualme cati amo israelitame huan nojquiya miyac borregojme huan huacaxme. ");
INSERT INTO nchBl_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Huan quichijque pantzi ica nopa tixti cati quiquixtijtoyaj. Huan nopa tixti amo quipixqui tasonejcayot pampa nopa egiptome quinquixtijque huan amo quiaxilijque para quichihuase inintacualis. ");
INSERT INTO nchBl_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Nopa israelitame itztoyaj ipan tali Egipto para 430 xihuit. ");
INSERT INTO nchBl_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Huan ipan nopa tonali quema quiaxitijque nopa 430 xihuit, nochi imasehualhua TOTECO quisque ipan nopa tali. ");
INSERT INTO nchBl_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","TOTECO quitapejpeni nopa tayohua huan quiiyocatali para ya pampa elqui ipan nopa tayohua quema quinquixti nopa israelitame ipan tali Egipto. Huajca sese xihuit nopa tayohua nochi israelitame cati ama itztoque huan cati teipa tacajtiyase monequi quiiyocatalise para TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Huan TOTECO quinilhui Moisés huan Aarón: “Ya ni nopa tanahuatilme para nopa Pascua Ilhuit. Yon se cati ehua seyoc tali amo huelis quicuas ten nopa tapiyali cati anquimictijtoque. ");
INSERT INTO nchBl_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Pero se tequipanojquet cati anquicojtoque, quena, huelis quicuas sinta ya anquitequilijtoque iyecapan cuetaxo ipan itacayo. ");
INSERT INTO nchBl_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Pero se cati ehua seyoc tali cati san panotinemi, o se tequipanojquet cati anquitaxtahuíaj pampa amo amoaxca amo hueli quicuas ten nopa tapiyali. ");
INSERT INTO nchBl_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Monequi xijcuaca sesen tapiyali calijtic ipan se cali. Amo xijquixtica calteno yon se quentzi ten nopa nacat. Amo xijtapanilica yon se iomiyo nopa tapiyali. ");
INSERT INTO nchBl_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Nochi israelita masehualme sentic monequi ilhuichihuase. ");
INSERT INTO nchBl_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Huan sinta itztoc se seyoc tali ejquet amohuaya cati quinequi ilhuichihuas amohuaya para quinescayotis cati TOTECO quichijqui ipan Pascua, monequi ma motequili nopa cuetaxti ipan itacayo, huan san se quichihuas ica nochi ioquichpilhua huan nochi itaca tequipanojcahua. Teipa quena, huelis quichihuas nopa ilhuit huan quicuas nopa nacat quej nochi sequinoc cati tacatque ipan amotal quichihuaj. Pero yon se oquichpil huan yon se tacat amo huelis quicuas inacayo nopa tapiyali sinta amo motequilijtoc iyecapa nopa cuetaxti ipan itacayo. ");
INSERT INTO nchBl_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Se cati amo motequilijtoc quej monequi amo hueli quicuas masque tacatqui quej israelita, o tacatqui ipan seyoc tali huan ama itztoc tatajco ten amojuanti.” ");
INSERT INTO nchBl_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Huan nochi nopa israelitame quichijque senquisa quej TOTECO quinahuatijtoya Moisés huan Aarón. ");
INSERT INTO nchBl_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Huajca ipan nopa tonali TOTECO quinquixti imasehualhua ten tali Egipto motecpantoyaj ica miyac pamit quej soldados. ");
INSERT INTO nchBl_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Huan TOTECO quinojnotzqui Moisés huan quiilhui: ");
INSERT INTO nchBl_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Techiyocatalili nochi oquichpilme cati achtohui ehuani, pampa nochi oquichpilme cati achtohui ehuani ten israelitame huan nochi inioquich tapiyalhua cati achtohui ehuani, nochi elise noaxcahua.” ");
INSERT INTO nchBl_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Huajca Moisés quinilhui nochi masehualme: “Xiquelnamiquica ni tonali huan xiilhuichihuaca ipan ni tonali sesen xihuit, pampa ipan ni tonali ica hueyi chicahualisti TOTECO techquixti ten tali Egipto campa titequipanohuayayaj quej titacohualme cati techcojtoyaj para tiiniaxcahua. Huan ipan ni tonali amo quema xijcuaca pantzi cati quipiya tasonejcayot. ");
INSERT INTO nchBl_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ama ni tonali anquisaj. ");
INSERT INTO nchBl_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Huajca sesen xihuit ipan ni metzti monequi anquielnamiquise ni tonali. Huan teipa san se anquichihuase quema TOTECO amechhuicatosa ipan nopa cuali tali campa itztoque nopa cananeos, heteos, amorreos, heveos huan jebuseos cati quintencahuili tohuejcapan tatahua para techmacas. Nopa tali quipiya miyac itajca hasta mocahua. Nopona nojquiya monequi xiilhuichihuaca ipan ni metzti. ");
INSERT INTO nchBl_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Para chicome tonati anquicuase pantzi cati amo quipiya tasonejcayot, huan ipan nopa tayacapan tonali monequi anilhuichihuase para TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Para chicome tonati anquicuase pantzi cati amo quipiya tasonejcayot. Ma amo oncas yon se tamanti tasonejcayot ipan amochaj. Huan yon se pantzi ica tasonejcayot amo oncas ipan amotal. ");
INSERT INTO nchBl_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Huan teipa ipan nopa tonali anquinilhuise amoconehua para ya ni tijchihuaj pampa TOTECO techchihuili nochi nopa tiochicahualnescayot quema techquixti ipan tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Huan quej anquitalisquíaj se tanextili ipan amomax o ipan amocuaixco cati amechelnamiquiltisquía se tenijqui, ya ni amechelnamiquiltis para monequi anquintoquilise nopa tanahuatilme cati techmacac TOTECO para nochipa, pampa nelía elqui TOTECO cati techquixti ten tali Egipto ica ihueyi chicahualis. ");
INSERT INTO nchBl_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Huan yeca monequi tiilhuichihuase sesen xihuit ipan ni tonali quej ni tanahuatili quiijtohua. ");
INSERT INTO nchBl_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Huan teipa ajsis nopa tonal quema TOTECO amechhuicas ipan nopa tali campa ama itztoque nopa cananeos huan yaya amechmactilis nopa cuali tali quej amechtencahuili amojuanti huan amohuejcapan tatahua para quichihuas. ");
INSERT INTO nchBl_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Huan quema anajsise nopona, nojquiya monequi anquimacase TOTECO nochi oquichpilme cati achtohui ehuani huan nochi oquich tapiyalme cati achtohui tacatij pampa inijuanti nelía iaxcahua. ");
INSERT INTO nchBl_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Huelis anquicohuilise TOTECO iachtohui cone se sihua burra para elis amoaxca sinta anquinequij. Para anquicohuilise Toteco, monequi anquimacase TOTECO se pilborregojtzi quej se tacajcahualisti para anquimanahuise nopa pilburrojtzi. Pero sinta amo anquitemactilise se pilborregojtzi quej se tacajcahualisti para anquipatase ica nopa pilburrojtzi, huajca monequi anquiquechpostequise nopa pilburrojtzi. Nojquiya monequi anquicohuilise TOTECO amooquichpilhua cati achtohui ehuani ica se tacajcahualisti cati anquitemactilise. ");
INSERT INTO nchBl_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Huan teipa quema amoconehua amechtatzintoquilise taya quiijtosnequi ni tamanti cati tijchihuaj, anquinilhuise para TOTECO techquixti ica hueyi chicahualisti ipan tali Egipto campa titetequipanojtoyaj quej techcojtosquíaj para tiiniaxcahua. ");
INSERT INTO nchBl_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Huan quema nopa Faraón moyoltetili huan amo quinejqui techcahuilis ma tiquisaca, TOTECO quinmicti nopa achtohui ehuani ipan sesen familia ten nopa Egipto ehuani. Huan nojquiya quinmicti nochi inioquich tapiyalhua cati achtohui tacatque. Huan yeca tijmacaj TOTECO nochi oquich tapiyalme cati tacatij achtohui quej se tacajcahualisti. Nojquiya tijcohuilise TOTECO tooquichpilhua cati achtohui ehuani. ");
INSERT INTO nchBl_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Huan ni ilhuit techelnamiquiltía ten TOTECO quej tijpixtosquíaj se tajcuiloli ipan tomax o ipan tocuaixco cati techelnamiquiltisquía se tenijqui. Techelnamiquiltía para TOTECO techquixti ten tali Egipto ica hueyi chicahualisti. Quena, quej nopa anquinilhuise.” ");
INSERT INTO nchBl_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Huajca teipa, quena, Faraón quincajqui ma quisaca nopa israelitame, huan quisque Egipto ica teposti para tatehuise. Pero Toteco Dios amo quinhuicac ipan nopa ojti cati pano ipan inintal nopa filisteos, masque eliyaya se ojti más xitahuac. Yaya moilhui: Sinta nimantzi monequi tatehuise, nopa israelitame sempa quinequise tacuepilise ipan tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Yeca Toteco Dios quichijqui para nopa israelitame ma temoca huan ma quimacaca se huelta campa hueli ipan nopa huactoc tali cati yahui campa nopa Hueyi At Chichiltic. Huan nopa israelitame quisque ica pamit huan ica teposti quej elisquía yahuij para tatehuitij. ");
INSERT INTO nchBl_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Huan Moisés nojquiya quihuicayaya iomiyohua José, pampa José quichijtoya para iixhuihua Israel ma quitestigojquetzaca Toteco para quihuicasquíaj iomiyohua. Quinilhuijtoya: “Melahuac, Toteco Dios teipa hualas amechpalehuiqui, huan quema ya nopa panos, monequi anquihuicase noomiyohua ten tali Egipto.” Huajca yeca quihuicaque. ");
INSERT INTO nchBl_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Huan nopa israelitame quistejque ipan Sucot huan yajque hasta Etam campa pehua nopa huactoc tali, huan nopona quiquetzque iniyoyoncalhua cati taxinepaloli ica iniijhuiyo chivojme. ");
INSERT INTO nchBl_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Huan ica tonaya TOTECO itztoya inihuaya ipan se mixti cati quinyacanayaya ipan ojti huan ica tayohua quinyacanayaya ica se tilelemecti cati quintaahuiliyaya. Yeca inijuanti huelque nejnemij tonaya huan tayohua. ");
INSERT INTO nchBl_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Huajca mojmosta nopa mixti tayacantiyajqui tonaya huan nopa tilelemecti ica tayohua huan amo quema quincajtejqui. ");
INSERT INTO nchBl_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Huan TOTECO quinojnotzqui Moisés huan quiilhui: ");
INSERT INTO nchBl_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Xiquinilhui nopa israelitame ma tacuepilica huan ma quiquetzaca iniyoyoncalhua ipan Pi Hahirot, tatajco ten Migdol huan nopa hueyi at. Nopona mocahuase atenti iixmelac Baal Zefón. ");
INSERT INTO nchBl_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Quej nopa Faraón moilhuis para anmomasiltijtoque pampa anitztoque tatajco ten huactoc tali huan hueyi at huan amo huelis ancholose. Moilhuis amo anquimatij canica anyase huan san anmocuapolojtinemij ipan huactoc tali. Quej nopa moilhuis. ");
INSERT INTO nchBl_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Huan nijchihuas Faraón ma moyoltetili huan ma amechtepotztoca. Huan huajca nijnextis nochicahualis ipan ya inihuaya isoldados para nopa egiptome ma quimatica na niamoTECO.” Huan nopa israelitame quichijque quej TOTECO quiijto. ");
INSERT INTO nchBl_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Huajca quema nopa tanahuatijquet ten tali Egipto quicajqui para nopa israelitame cholojtoyaj, yaya inihuaya cati quipalehuiyayaj moyolcuetque, huan moilhuijque: “¿Para ten tiquincahuilijque ma yaca nopa israelitame huan ayecmo ma techtequipanoca?” ");
INSERT INTO nchBl_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Huan nimantzi Faraón tanahuati para ma quincualtalica itatehuijca carrojhua huan quistejqui quinyacantiyajqui isoldados. ");
INSERT INTO nchBl_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Huan iica hualajque 600 tatehuijca carrojme cati más cuajcualme ihuaya nochi sequinoc tatehuijca carrojme ten Egipto, huan itayacanca soldados itztoyaj ipan sesen carro. ");
INSERT INTO nchBl_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Huan TOTECO quichijqui Faraón ma moyoltetili huan ma quintoquili nopa israelitame masque inijuanti ya quistoyaj ica hueyi chicahualisti. ");
INSERT INTO nchBl_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Huan nopa egiptome ica nochi inisoldados huan tatehuijca carrojme huan cahuayojme quintepotztocatiyajque nopa israelitame, huan quinajsitoj iteno nopa hueyi at nechca Pi Hahirot huan iixpa Baal Zefón campa quiquetztoyaj iniyoyoncalhua. ");
INSERT INTO nchBl_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Huan quema nopa israelitame quiitaque para Faraón ihuaya nopa egiptome monechcahuiyayaj, tahuel majmajque huan quitajtanijque TOTECO ma quinpalehui. ");
INSERT INTO nchBl_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Huan nopa israelitame quiilhuijque Moisés: ―¿Para ten techhualicatoc nica para ma timiquica ipan ni huactoc tali? Sinta tijnequiyaya techmictis, oncayaya campa techtalpachojtosquía ipan tali Egipto. ¿Para ten techquixti ten nopona? ");
INSERT INTO nchBl_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ipan Egipto timitzilhuijque para techcahua tiquintequipanose nopa egiptome. Más cuali elisquía noja tiquintequipanosquíaj huan amo timiquise nica ipan huactoc tali. ");
INSERT INTO nchBl_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Pero Moisés quinnanquili: ―Amo ximajmahuica. San ximoquetzaca huan amo ximolinica huan xiquitaca quenicatza TOTECO amechmaquixtis, pampa nopa egiptome cati ama anquinitaj ayecmo quema anquinitase sempa. ");
INSERT INTO nchBl_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Yon amo monequi antatehuise, TOTECO tatehuis por tojuanti. ");
INSERT INTO nchBl_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Huajca TOTECO quiilhui Moisés: ―¿Para ten san antechtajtaníaj tapalehuili? ¡Xiquinnahuati nopa israelitame ma quiitzquica iniojhui! ");
INSERT INTO nchBl_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Huan ta xijtanana mocuatopil huan xijxitahua momax para tijtajcoitas nopa hueyi at, huan huajca nopa israelitame huelis quiixcotonase ipan se ojti huactoc. ");
INSERT INTO nchBl_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Huan na nijchihuas nopa egiptome ma moyoltetilica huan ma amechtoquilica ipan hueyi at. Huan huajca nijnextis nochicahualis iixpa Faraón, huan isoldados, huan inintatehuijca carrojhua, huan inijuanti cati yahuij ipan cahuayojme. ");
INSERT INTO nchBl_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Huan quema ya nijnextijtos nochicahualis ipan Faraón, huan itatehuijca carrojhua, huan ipan inijuanti cati tejcotoque ipan cahuayojme, nopa egiptome quimatise para na niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Huan iilhuicac ejca Toteco Dios cati itztoya inihuaya ipan nopa mixti cati nejnemiyaya iniixpa, mopatac campa itztoya huan motali iniica. ");
INSERT INTO nchBl_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Huan yeca nopa mixti mocajqui tatajco ten nopa soldados ten Egipto huan nopa israelitame. Huan iica nopa mixti nesiyaya yayahuic iniixpa nopa egiptome, pero iixpa nopa mixti quintaahuiliyaya nopa israelitame. Huajca yeca nopa egiptome amo huelque quinajsij nopa israelitame nochi nopa tayohua. ");
INSERT INTO nchBl_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Huan Moisés quixitajqui imax ipan nopa hueyi at, huan TOTECO quititanqui se ajacat chicahuac cati hualajqui campa quisa tonati huan taajacac nochi tayohua huan quitajcoitac nopa hueyi at. Huajca quej nopa TOTECO quicuetqui nopa hueyi at ica huactoc tali. ");
INSERT INTO nchBl_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Huan nesqui ipan hueyi at se huactoc ojti huan ipan nopa ojti nopa israelitame panoque tatajco campa motapojtoya huan moquetztoya nopa at tahuel huejcapa quej eliyaya ome tepamit, se ipan ininejmat huan seyoc ipan iniarraves. ");
INSERT INTO nchBl_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Huan teipa nopa Egipto ehuani quintoquilijque. Quena, nochi nopa cahuayojme ica itatehuijca carrojhua Faraón huan inijuanti cati yahuiyayaj ipan cahuayojme calajque inintepotzco huan quintoquilijtiyajque hasta tatajco nopa hueyi at. ");
INSERT INTO nchBl_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Huan tajco yohual, TOTECO cati itztoya ipan nopa hueyi mixti huan ipan nopa tilelemecti quinitac nopa soldados ten tali Egipto huan quinhuihuichijqui para ma amo quimatica taya quichihuase. ");
INSERT INTO nchBl_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Huan quinquixtili nopa tepos yahuali cati ipan nemiyayaj inintatehuijca carrojhua para ma ayecmo huelica quihuicase inincarrojhua. Huajca nopa egiptome quiijtojque: ―Ma timochololtica ten ni israelitame, pampa DIOS, ininTECO techtehuía huan quinmanahuía. ");
INSERT INTO nchBl_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Huan teipa quema nopa israelitame ajsitoj seyoc nali, TOTECO quiilhui Moisés: ―Xijxitahua momax ipan nopa hueyi at para nopa at ma mosentili huan ma quinatzonpolihuilti nopa egiptome ipan inintatehuijca carrojhua inihuaya cati tejcotoque ipan cahuayojme. ");
INSERT INTO nchBl_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Huan Moisés quixitajqui imax ipan nopa hueyi at, huan quema tanestihualayaya, nopa at mocuetqui campa ipa eltoya. Huan quema nopa egiptome quinejque cholose, nopa hueyi at quinhuicac, huan quej nopa TOTECO quinisahuilti. ");
INSERT INTO nchBl_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Huan quema nopa at mocuetqui campa ipa eltoya, quinatzonpolihuilti nochi nopa soldados, carrojme huan cahuayojme cati calactoyaj ipan hueyi at para quintoquilise israelitame. Yon se ten isoldados Faraón amo mocajqui yoltoc. ");
INSERT INTO nchBl_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Pero nopa israelitame ya quiixcotontoyaj nopa hueyi at ipan se ojti huactoc tatajco campa nopa at moquetztoya quej ome tepamit ten at, se ipan ininejmat huan se ipan iniarraves. ");
INSERT INTO nchBl_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Huajca ipan nopa tonali TOTECO quinmaquixti nopa israelitame ten nopa egiptome huan nopa israelitame quiitaque inintacayohua nopa egiptome iteno nopa hueyi at. ");
INSERT INTO nchBl_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Huan quema nopa israelitame quiitaque nopa hueyi chicahualisti cati TOTECO quinextijtoya ica nopa egiptome, quihueyitepanitaque, huan motemachijque ipan ya huan ipan itequipanojca Moisés. ");
INSERT INTO nchBl_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Huajca Moisés inihuaya nopa israelitame huicaque ni huicat para TOTECO: “Nihuicas para TOTECO pampa tatanqui ica ihueyi chicahualis. Quinisahuilti ipan hueyi at nopa cahuayojme inihuaya cati ininpa tejcotoyaj. ");
INSERT INTO nchBl_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","TOTECO techchijtoc ma nihuica ica paquilisti. Yaya Notemaquixtijca cati techmaca tetili. Yaya Dios noTeco cati nijtepanita, huan nijpaquilismacas. Yaya nopa Dios cati notata quihueyichijqui, huan nijhueyitalis. ");
INSERT INTO nchBl_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","TOTECO ya nopa tatehuijquet cati más quipiya chicahualisti. Quena, TOTECO, ya nopa itoca. ");
INSERT INTO nchBl_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Quinisahuilti ipan hueyi at nopa tatehuijca carrojme, inihuaya isoldados Faraón. Nopa soldados cati más cuajcualme ipan nochi tali Egipto, misahuijque ipan hueyi at cati itoca Chichiltic. ");
INSERT INTO nchBl_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Huetzque hasta atatzinta quej teme. Huan nopa at cati huejcata quinatzonpolihuilti. ");
INSERT INTO nchBl_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","¡Ay, TOTECO! Tijpiya hueyi chicahualisti, huan tiquintamilti tocualancaitacahua. ");
INSERT INTO nchBl_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Huan ica mohueyi chicahualis tiquinpolo cati motalijque moixpa. Tejcoc mocualancayo quej se hueyi tit, huan quinpolihuilti. Inijuanti tami tataque quej sacat. ");
INSERT INTO nchBl_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Chicahuac tiquilpitzqui nopa hueyi at, huan nopa at motajcoitac. Nopa hueyi at motananqui huan moquetzqui oncac, quej moquetzaj ome huejcapantique tepame. Nopa hueyi at cati huejcata motetictali. ");
INSERT INTO nchBl_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Tocualancaitacahua mohueyimatque huan quiijtojque: ‘Tiquintoquilise hasta tiquinajsitij, huan tiquinquixtilise nochi cati quipiyaj, huan timochihuase titominpiyani ica cati iniaxca. Teipa tijquixtise tomacheta huan tiquintzontamiltise ica tomax.’ Quej nopa moilhuijque. ");
INSERT INTO nchBl_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Pero ta, TOTECO, titailpitzqui, huan nopa hueyi at quintolo. Misahuijque quej teposti ipan at cati huejcata. ");
INSERT INTO nchBl_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","¡Ay TOTECO! Amo aqui seyoc Dios cati ica huelis timitzhuicalotise. Amo aqui tatzejtzeloltic quej ta. Amo aqui quipiya mohueyi chicahualis. Cati ta tijchihua temajmatía. Huajca quinamiqui para timitzhueyichihuase. ");
INSERT INTO nchBl_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Titenextili mochicahualis, huan quintolo nopa tali. ");
INSERT INTO nchBl_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ica moteicnelijcayo techyacanas tojuanti timomasehualhua cati techmaquixtijtoc. Ica mochicahualis techhuicas hasta mochaj cati tatzejtzeloltic. ");
INSERT INTO nchBl_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Nochi tacame ipan nochi talme huihuipicase quema quimatise cati tijchijtoc. Nopa filisteos majmahuise pampa quinitzquis majmajti. ");
INSERT INTO nchBl_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Huan nopa tayacanani ten soldados ipan tali Edom, yon amo huelis taijyotilanase. Nopa tanahuatiani ten tali Moab huihuipicase ica majmajti. Huan ayecmo quipiyase chicahualisti inijuanti cati mooquichmatiyayaj ipan tali Canaán. ");
INSERT INTO nchBl_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Hueyi majmajti quinajsis. Quena, quinamiqui ma majmahuica. Tocualancaitacahua ayecmo techtehuise, san majmahuise ica mohueyi chicahualis, TOTECO, huan mocahuase quej teme. Tojuanti cati techcojtoc para timoaxcahua tijpanoque nopa at ica temachili. Inijuanti amo teno huelqui techchihuilise pampa ta techmanahui. ");
INSERT INTO nchBl_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","¡Ay TOTECO! Techhuica para tiitztotij ipan motepe cati tatzejtzeloltic. Techyacana hasta nopa tali campa tijtapejpeni para tiitztose, nopona ipan mochaj cati ta tijchijchijqui. ");
INSERT INTO nchBl_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","TOTECO, titanahuatis para nochipa.” ");
INSERT INTO nchBl_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Quema itatehuijca carrojhua Faraón huan icahuayojhua huan cati ipan tejcotoyaj calajque ipan hueyi at, TOTECO quichijqui nopa hueyi at ma quinhuica. Pero nopa israelitame quiixcotonque nopa hueyi at ipan se ojti huactoc. ");
INSERT INTO nchBl_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Huajca nopa sihua tajtolpanextijquet María, ihuelti Aarón, quicuic se tepos tatzilinti, huan nochi israelita sihuame quitzilinijtiyahuiyayaj nopa tepos tatzilinti, huan huicayayaj, huan mijtotiyayaj. ");
INSERT INTO nchBl_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Huan María huicayaya huan quinnanquiliyaya ica ni camanali: “Xihuicaca para TOTECO, pampa tatanqui ica ihueyi chicahualis. Quinisahuilti ipan hueyi at nopa cahuayojme, huan inijuanti cati ipan tejcotoyaj.” ");
INSERT INTO nchBl_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Huan Moisés quinyacanqui nopa israelitame huan quistejque ten nopa Hueyi At Chichiltic, huan yajque ipan nopa huactoc tali itoca Shur. Huan nejnenque para eyi tonati pero amo quipantiyayaj at. ");
INSERT INTO nchBl_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Huan quema ajsitoj campa se ameli cati itoca Mara, amo huelque quiique nopa at cati oncayaya nopona pampa eliyaya chichic. Yeca nopa ameli quitocaxtijque Mara cati quinequi quiijtos “chichic”. ");
INSERT INTO nchBl_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Huan nopa israelitame pejque cualancamanaltij ica Moisés, huan quiijtohuayayaj: “¿Taya huelis tiquise?” ");
INSERT INTO nchBl_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Huajca Moisés quitajtani TOTECO itapalehuil para quimatis taya quichihuas, huan TOTECO quinextili se cuamacuayot. Huan Moisés quimajcajqui nopa cuahuit ipan at, huan nopa at mocuetqui se cuali at. Huajca nopona TOTECO quincamanalhui israelitame para quinyejyecos sinta quitoquilisquíaj huan ya ni cati quintencahuili. ");
INSERT INTO nchBl_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Quinilhui: “Sinta anquitacaquilise cati niamoTECO Dios nimechilhuía, huan anquichihuase cati xitahuac noixpa huan anquineltocase notanahuatil, amo nimechtitanilis yon se cocolisti cati nijtitanqui ipan nopa egiptome, pampa na niamoTECO Cati Nimechchicahua.” ");
INSERT INTO nchBl_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Huan teipa nopa israelitame ajsitoj Elim campa oncayaya doce ameli huan 70 palma cuame, huan nopona nechca at quiquetzque iniyoyoncalhua. ");
INSERT INTO nchBl_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Huan nochi israelitame quisque Elim huan ajsique ipan nopa huactoc tali cati itoca Sin cati mocahua tatajco ten Elim huan Sinaí. Huan ajsitoj nopona ipan 15 itequi nopa ompa metzti ipan inixihui. ");
INSERT INTO nchBl_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Huan nopona ipan nopa huactoc tali, nochi pejque quitaijilhuíaj Moisés huan Aarón. ");
INSERT INTO nchBl_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Huan nopa masehualme quinilhuiyayaj: ―Más cuali eltosquía sinta TOTECO techcahuilijtosquía ma timiquica ipan tali Egipto. Nepa timosehuijtoyaj nechca nopa chachapali cati temitoya ica nacat huan titacuayayaj hasta tiixhuiyayaj, pero ama antechhualicatoque ipan ni huactoc tali para antechapismictise. ");
INSERT INTO nchBl_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Huajca TOTECO quiilhui Moisés: ―Nijchihuas para tacualisti ma huetzi ten ilhuicac quej quema taquiyahui. Huan mojmosta nopa israelitame monequi quisentilise san cati quitequihuise ipan nopa tonali. Nijnequi niquitas ajquiya quineltocas cati niquilhuis huan ajquiya, amo. ");
INSERT INTO nchBl_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Huan sesen samano ipan nopa chicuasempa tonali quema quisentilise para quihuicase ininchaj, ma quisentilica cati monequi para ome tonati. ");
INSERT INTO nchBl_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Huan Moisés huan Aarón quinilhuijque nopa israelitame: ―Ica tiotac anquimatise para yaya TOTECO amechquixti ipan tali Egipto, ");
INSERT INTO nchBl_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","huan ica ijnaloc anquiitase itatanex, pampa quicajqui para anquitaijilhuiyayaj. Pampa amo na huan Aarón cati antechtaijilhuíaj ¿Ajquiya tojuanti? Tojuanti amo titanahuatíaj. ");
INSERT INTO nchBl_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Huan Moisés quiijto: ―Ica tiotac TOTECO amechmacas nacat para antacuase, huan ica ijnaloc amechmacas pantzi hasta mocahuas, pampa quicactoc para amojuanti anquitaijilhuijque. Amo tojuanti antechtaijilhuijtoque. Tojuanti amo teno topati. Pero quena, anquitaijilhuijque TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Huan teipa Moisés quiilhui Aarón ma quinilhui nochi israelitame: ―Ximonechcahuica iixpa TOTECO, pampa ya quicactoc cati ica anquitaijilhuijque. ");
INSERT INTO nchBl_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Huan ipan nopa talojtzi quema Aarón quincamanalhuiyaya nopa israelitame, nochi tachixque ica campa nopa huactoc tali, huan itatanex TOTECO monexti ipan se mixti. ");
INSERT INTO nchBl_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Huan TOTECO quinojnotzqui Moisés huan quiilhui: ");
INSERT INTO nchBl_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","―Nijcactoc quenicatza noca camanaltij huan techtaijilhuíaj ni israelitame. ‘Xiquinilhui para quema tiotaquiyas, quicuase nacat, huan ica ijnaloc quicuase pantzi hasta ixhuise. Quej nopa quimatise para na niDIOS, niininTECO.’ ");
INSERT INTO nchBl_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Huan ipan nopa tiotac hualajque miyac totome cati inintoca codornices, huan quitemitijque campa itztoyaj nopa israelitame. Huan ica ijnaloc huetzqui ajhuechti huan quinyahualojtoya campa mocahuayayaj. ");
INSERT INTO nchBl_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Huan teipa quema nopa ajhuechti ya pojquejtoya, mocajqui ipan nopa tali se tamanti chipahuac quej ichcat. ");
INSERT INTO nchBl_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Huan nopa israelitame amo quimatiyayaj taya eliyaya, huajca quema quiitaque, moilhuijque se ica seyoc: “¿Huan ya ni taya?” Huan Moisés quinilhui: ―Ya ni nopa pantzi cati TOTECO amechmacatoc para amotacualis. ");
INSERT INTO nchBl_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Huan ya ni nopa tanahuatilme cati techmacatoc TOTECO: Sesen ten amojuanti ma quisentili cati monequi para quicuase cati itztoque ipan ichaj. Xijcuica quej ome litros para quicuas sesen masehuali ipan amofamilia. ");
INSERT INTO nchBl_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Huan nopa israelitame quichijque quej quinilhuijtoya. Huan sequij miyac quisentilijque huan sequinoc amo más. ");
INSERT INTO nchBl_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Huan quitamachijque ica se tatamachihuali cati itoca gomer cati quicui nechca ome litros. Huan amo mocajqui cati quisentilijtoya miyac, yon amo quipolo cati quisentilijtoya quentzi. Sesen ten inijuanti quipixqui san cati monequiyaya para quicuase ichampoyohua. ");
INSERT INTO nchBl_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Huan teipa Moisés quinilhui: ―Amo aqui ma quicahua yon se quentzi ni tacualisti para mosta. ");
INSERT INTO nchBl_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Pero sequij amo quitacaquilijque Moisés huan quiajojque nopa tacualisti para ne seyoc tonali. Huan tonili quiitaque ocuilojtoya huan mijyotiyaya. Huajca Moisés cualanqui ica inijuanti. ");
INSERT INTO nchBl_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Huajca sesen israelita quisentiliyaya ica ijnaloc cati monequiyaya para quicuase, huan tajcotona quema tatotoniyayaya atiyayaya cati mocahuayaya talchi. ");
INSERT INTO nchBl_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Pero ipan chicuasempa tonali quisentiliyayaj cati quicuasquíaj para ome tonati, quiijtosnequi se nahui litro para sesen masehuali. Huan nopa israelita tayacanani yajque quipohuilitoj Moisés cati quichihuayayaj, ");
INSERT INTO nchBl_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","huan Moisés quinilhui: ―¡Cuali! Ya nopa cati TOTECO tanahuatijtoc, pampa mosta elis nopa tonali para timosiyajquetzase. Timosiyajquetzase pampa eltoc se tonali tatzejtzeloltic. Nopa tonali taiyocatalili san para TOTECO huan amo titequitise. Huajca xijmolonica cati anquinequij huan xiquicxitica cati anquinequij ama huan xijtequihuica cati monequi ama, pero xicajocuica cati mocahuas para mosta. ");
INSERT INTO nchBl_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Huajca inijuanti quiajojque tacualisti para mosta, quej tanahuatijtoya Moisés. Huan tonili noja eliyaya cuali. Amo potehui, yon amo quinpixqui ocuilime. ");
INSERT INTO nchBl_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Huajca ipan sábado Moisés quiijto: ―Ama xijcuaca cati mocahua pampa ama ni tonali para timosiyajquetzase ica TOTECO huan amo anquipantise tacualisti. ");
INSERT INTO nchBl_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Mojmosta para chicuasen tonati huelis anquisentilise, pero ipan nopa chicompa tonali, timosiyajquetzase huan amo teno oncas calteno para anquisentilise. ");
INSERT INTO nchBl_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Pero sequij masehualme quisque ipan nopa chicompa tonali para quisentilise, pero amo teno quipantijque. ");
INSERT INTO nchBl_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Huajca TOTECO quiilhui Moisés: ―¿Hasta quema anquineltocase cati nimechnahuatía huan cati nimechmachtía? ");
INSERT INTO nchBl_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Xiquitaca para na, niamoTECO, nimechmacatoc ni tonali para ximosiyajquetzaca. Yeca ipan nopa chicuasempa tonali nimechmacas tacualisti para ome tonati. Huan ipan nopa chicompa tonali nochi monequi mocahuase ipan ininchajchaj huan amo ma quisaca. ");
INSERT INTO nchBl_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Huajca nopa israelitame mosiyajquetzque ipan nopa chicompa tonali. ");
INSERT INTO nchBl_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Huan quitocaxtijque “maná” nopa chipahuac pantzi cati quisentiliyayaj. (Maná quinequi quiijtos: ¿Taya Ya Ni?) Eliyaya chipahuac quej culanto iyol, huan iajhuiyaca elqui quej pantzi cati quichijtoque ica necti. ");
INSERT INTO nchBl_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Huan Moisés quiijto: ―TOTECO techmacatoc tanahuatili ma tijtemitica ome litro ica maná huan ticajocuise para toixhuihua cati teipa tacajtiyase ma quiitaca nopa tacualisti cati TOTECO techmacac ipan ni huactoc tali quema techquixti ipan tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Huajca Moisés quiilhui Aarón para ma quicui se chiquihuit huan ma quitema nopona ome litro ten maná. Huan quiilhui para teipa ma quitali iixpa TOTECO huan ma quiajocui para quiitase iniixhuihua. ");
INSERT INTO nchBl_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Huajca Aarón quichijqui cati TOTECO quinahuati Moisés, huan teipa quitali nopa chiquihuit ipan icaxa TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Huan nopa israelitame quicuajque maná para 40 xihuit hasta ajsitoj ipan tali Canaán campa sequinoc tatojtoctoyaj huan oncayaya ten quicuase. ");
INSERT INTO nchBl_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Huan inijuanti quitequihuijque se tatamachihuali cati itoca gomer cati eliyaya quej ome litro. Huan monequiyaya majtacti gomer para elisquía se tatamachihuali cati itoca efa cati quicuisquía quej 20 litros. ");
INSERT INTO nchBl_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Huan nochi nopa miyaqui israelitame quisque ten tali Sin huan yajque ica yolic quej TOTECO quinnahuatiyaya. Huan nejnentiyajque huan quiijcuenijtiyajque iniyoyoncalhua mojmosta hasta ajsitoj campa itoca Refidim. Pero nopona amo oncayaya at para atise, ");
INSERT INTO nchBl_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","huajca cualanque ica Moisés huan quiilhuijque: ―¡Techmaca at para tiatise! Huan Moisés quinnanquili: ―¿Para ten ancualanij ica na? San anquicualancamacaj huan anquiyejyecohuaj TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Pero nochi amiquiyayaj huan quitaijilhuiyayaj Moisés, quiilhuiyayaj: ―¿Para ten techchijqui ma tiquisaca ipan tali Egipto? ¿Para ten techhualicac nica? San techamictis ica toconehua huan totapiyalhua. ");
INSERT INTO nchBl_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Huajca Moisés quinojnotzqui TOTECO huan quiilhui: ―¿Taya nijchihuas ica ni masehualme? ¡San se quentzi más huan techtepachose! ");
INSERT INTO nchBl_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Huan TOTECO quinanquili: ―Xijhuica nopa cuatopili cati ica tijmaquili nopa hueyat Nilo. Huan xiquisa huan ximotali iniixpa ni masehualme para titayacanas. Huan xiquinhuica sequij huehue tacame cati quipiyaj tequit ica israelitame, huan xiya. ");
INSERT INTO nchBl_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Huan na nimitzchixtos campa nopa tet nechca tepet Horeb. Huan xijmaquili nopa tet huan nopona quisas at para atise nochi ni israelitame. Huajca Moisés quej nopa quichijqui iniixpa nopa huehue tacame ten nopa israelitame. ");
INSERT INTO nchBl_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Huan quitocaxti nopona campa itztoya Masah. (Masah quinequi quiijtos Campa Quiyejyecojque TOTECO Para Ma Quinmicti.) Huan nojquiya quitocaxti Meriba. (Meriba quinequi quiijtos Tanajnanquilisti.) Quej nopa quitocaxti pampa nopona nopa israelitame quinajnanquilijque huan quiyejyecojque TOTECO huan quiijtojque: “¿Itztoc TOTECO tohuaya o amo aqui?” ");
INSERT INTO nchBl_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Huan hualajque nopa amalecitame huan pejque quintehuíaj nopa israelitame ipan Refidim. ");
INSERT INTO nchBl_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Huan Moisés quiilhui Josué: ―Xiquintapejpeni tacame huan xiquintehuitij nopa amalecitame. Huan mosta na nimoquetzas tachiquiltipa ica icuatopil Toteco nomaco. ");
INSERT INTO nchBl_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Huan Josué huan nopa tacame quichijque cati Moisés quinnahuati, huan quintehuitoj nopa amalecitame. Huajca Moisés, Aarón huan Hur tejcoque tachiquiltipa para quintachilise. ");
INSERT INTO nchBl_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Huan quema Moisés quitananayaya imax, nopa israelitame tataniyayaj, pero quema quitemohuiyaya imax, tataniyayaj nopa amalecitame. ");
INSERT INTO nchBl_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Huan teipa Moisés macuatic. Huajca quicuique se tet para ipan mosehuis huan Aarón ihuaya Hur quimatanantoyaj. Se moquetzqui ica inejmat huan se ica iarraves. Huajca san quej nopa Moisés huelqui quiijyohui momatanantoc hasta quema calajqui tonati. ");
INSERT INTO nchBl_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Huan yeca Josué quintamimicti nopa amalecita soldados ica imacheta. ");
INSERT INTO nchBl_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Huan TOTECO quiilhui Moisés: ―Xiquijcuilo ni camanali ipan se amat cati huejcahuas para ma quielnamiquica nopa israelitame para nochipa, huan nojquiya xijyolmelahua Josué ten ya ni. Na niquintamiltis nochi nopa amalecitame ipan ni taltipacti huan amo aqui quinelnamiquis. ");
INSERT INTO nchBl_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Huan Moisés quichijqui se taixpamit cati quitocaxti: “TOTECO Itztoc Quej Se Bandera Cati Techyacana.” ");
INSERT INTO nchBl_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Huan Moisés quiijto: “Quej se bandera tomaco, Toteco techyacana ma titatanica. Pampa nopa amalecita masehualme motanantoque iixpa TOTECO, yaya quintehuis para nochipa.” ");
INSERT INTO nchBl_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Huan Jetro, nopa totajtzi ten tali Madián cati elqui imontaj Moisés, quicajqui quenicatza TOTECO quinquixtijtoya nopa israelitame ten tali Egipto. Nojquiya quicajqui nochi nopa yejyectzi tamanti cati quinchihuilijtoya Moisés huan imasehualhua. ");
INSERT INTO nchBl_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","3","Moisés quititantoya isihua, Séfora, ma yahui ichaj quema quinmanahuiyaya nopa israelitame. Huan Jetro imonta Moisés sempa quiselijtoya iichpoca inihuaya ome iconehua. Se ten nopa coneme itoca eliyaya Gersón. (Gersón quinequi quiijtos Seyoc Tali Ejquet.) Quej nopa Moisés quitocaxti pampa quiijtojtoya: “Nielqui nise seyoc tali ejquet ipan se tali cati amo niquixmati”. ");
INSERT INTO nchBl_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Huan nopa seyoc icone itoca eliyaya Eliezer. (Eliezer quinequi quiijtos Toteco Dios Yaya Notapalehuijca.) Quej nopa quitocaxti pampa quiijtojtoya: “Toteco Dios cati notata quitoquili hualajqui techpalehuico huan techmaquixti ten imacheta Faraón.” ");
INSERT INTO nchBl_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Huajca se tonali quema nopa israelitame ya ajsitoyaj ipan huactoc tali, Jetro quicuitejqui isihua huan iconehua Moisés huan yajque campa Moisés quiquetztoya ichaj ten yoyomit nechca itepe Toteco. ");
INSERT INTO nchBl_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Huan Jetro tatitanqui ma quiyolmelahuatij Moisés para ya ajsitoyaj. Quiilhui: ―Na niJetro, momontaj. Nihualajtoc nimitzitaqui huan nijhualica mosihua huan moconehua. ");
INSERT INTO nchBl_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Huan Moisés quisqui para quiseliti imontaj, huan quitajpalo ica yejyectzi huan quitzoponi. Huan teipa quema motajpalojque, calajque ipan se cali ten yoyomit. ");
INSERT INTO nchBl_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Huan nopona Moisés quipohuili imontaj nochi cati TOTECO quichihuilijtoya Faraón huan nopa egiptome pampa quinicneli nopa israelitame. Huan quipohuili nochi tamanti cati ininpantitoya ipan ojti huan quenicatza TOTECO quinmaquixtijtoya. ");
INSERT INTO nchBl_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Huan Jetro pajqui quema quicajqui quenicatza TOTECO quinpalehuijtoya nopa israelitame huan quinmaquixtijtoya ten nopa egiptome. ");
INSERT INTO nchBl_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Huan Jetro quiijto: ―Ma tijhueyichihuaca TOTECO cati amechmanahuijtoc imaco Faraón huan nochi egiptome, huan nochi cati fiero inijuanti amechchihuiliyayaj. ");
INSERT INTO nchBl_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ama niquitztoc para TOTECO itztoc más hueyi ten nochi sequinoc cati quintocaxtalíaj dioses, pampa amechmanahuijtoc inimaco masehualme cati mohueyimatiyayaj huan cati fiero amechchihuiliyayaj. ");
INSERT INTO nchBl_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Teipa Jetro quimacac Toteco sequij tacajcahualisti huan quitati se tapiyali iixpa. Huan Aarón ihuaya nochi nopa huehue tacame ten nopa israelitame yajque tacuatoj ihuaya imontaj Moisés iixpa Toteco Dios. ");
INSERT INTO nchBl_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Tonili Moisés mosehui quej juez para quintacaquilis nopa israelitame cati motatelhuiyayaj se ica seyoc. Huan semilhuit miyac masehualme ijcatoyaj iixpa hasta nochi cuatiyayaj. ");
INSERT INTO nchBl_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Huajca quema Jetro imontaj Moisés quiitac nochi nopa tequit cati Moisés iseltitzi quichihuayaya iniixpa nopa israelitame, quiilhui: ―¿Taya tiquinchihuilía ni masehualme? Amo cuali para san ta timosehuía para titetajtolsencahuas huan nochi inijuanti semilhuit moquetztoque. ");
INSERT INTO nchBl_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Huan Moisés quinanquili imontaj: ―Nochi hualahuij techitaquij para ma nijtajtani Toteco Dios taya ipaquilis. ");
INSERT INTO nchBl_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Huan quema mocualaníaj se ica seyoc, hualahuij techitaquij para ma niquinilhui ajquiya quichijtoc cati melahuac. Huajca na niquinilhuía taya quiijtohua Toteco Dios huan taya itamachtil. ");
INSERT INTO nchBl_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Huajca Jetro, imontaj Moisés, quiilhui: ―Amo cuali cati tijchihua. ");
INSERT INTO nchBl_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Tisiyajcamiquis huan nojquiya siyahuise nochi nopa masehualme cati hualahuij campa ta. Ni tequit nel tetic para ta. Moseltitzi amo huelis tijtamichihuas. ");
INSERT INTO nchBl_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Huajca ama xijcaqui huan nimitzilhuis cati monequi tijchihuas huan Toteco mitztiochihuas. Ta motequi timonextis iixpa Toteco por nochi ni masehualme huan xijtali iixpa nopa tamanti cati quincuesohua. ");
INSERT INTO nchBl_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Nojquiya monequi xiquinmachti itanahuatilhua huan cati yaya quiijtohua huan xiquinilhui quenicatza monequi itztose huan taya monequi quichihuase. ");
INSERT INTO nchBl_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Nojquiya monequi xiquintapejpeni ten nochi nopa masehualme sequij tayacanca tacame cati temachme huan cati quitepanitaj Toteco Dios. Xiquintapejpeni cati amo istacatij huan cati amo quinequij cati seyoc iaxca. Xiquintali sequij nopa tayacanca tacame ma quipiyaca tanahuatili ica mil masehualme. Huan tatzinta sese ten inijuanti, xiquintali 10 tacame cati quipiyase tanahuatili ica 100 masehualme. Huan tatzinta ten sesen nopa 100 masehualme, xiquintali ome tacame cati quipiyase tanahuatili ica 50 masehualme. Huan tatzinta ten sesen nopa 50 masehualme, xiquintali 5 tacame cati san quipiyase tanahuatili ica 10 masehualme. ");
INSERT INTO nchBl_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Huan inijuanti quisencahuase cati quincuesos ni masehualme ipan ten hueli talojtzi. Huan san nopa tamanti cati más huejhueyi mitzhualiquilise huan inijuanti quisencahuase nochi tamanti cati amo ohui. Quej nopa amo elis tahuel ohui nopa tequit pampa anquichihuase san sejco. ");
INSERT INTO nchBl_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Sinta Toteco mitzcahuilis xijchihua ya ni, huajca huelis tiquijyohuis motequi, huan nochi nopa masehualme paquise. ");
INSERT INTO nchBl_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Huajca Moisés quitacaquili imontaj huan quichijqui nochi cati quiilhuijtoya. ");
INSERT INTO nchBl_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Quintapejpeni tayacanca tacame cati más temachme ipan nopa israelitame huan quinmacac sequij ten inijuanti tanahuatili ica sesen mil masehualme. Huan tatzinta ten sesen nopa tayacanani, quinmacac 10 tacame tanahuatili ica 100 masehualme. Huan tatzinta sesen nopa tacame, quinmacac 2 tacame tanahuatili ica 50 masehualme. Huan tatzinta sesen inijuanti, quinmacac 5 tacame tanahuatili ica 10 masehualme. ");
INSERT INTO nchBl_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Huan inijuanti quintajtolsencahuayayaj masehualme ipan ten hueli tonali. Huan san nopa tamanti cati huejhueyi quihuiquiliyayaj Moisés, pero nochi camanali cati amo más ohui quisencahuayayaj inijuanti. ");
INSERT INTO nchBl_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Huan teipa Moisés quinahuatijtejqui imontaj, Jetro, huan yaya mocuetqui ipan ital. ");
INSERT INTO nchBl_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Ipan nopa tonali quema quiaxiti eyi metzti para quistoyaj nopa israelitame ten tali Egipto, inijuanti ajsitoj ipan nopa huactoc tali nechca tepet Sinaí. ");
INSERT INTO nchBl_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Huan teipa quistejque ipan Refidim huan ajsitoj campa tepet Sinaí, huan nopona quiquetzque iniyoyoncalhua iixpa nopa tepet ipan nopa huactoc tali. ");
INSERT INTO nchBl_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Huan nopona Moisés tejcoc ipan nopa tepet para mopantis ihuaya Toteco Dios. Huan TOTECO quinojnotzqui Moisés ten nopa tepet huan quiilhui ma quinilhui nopa israelitame ni camanali: ");
INSERT INTO nchBl_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","―Amojuanti ya anquiitztoque cati nijchijqui ica nopa egiptome. Anquimatij nimechmocuitahuijtoc. Quena, quej se hueyi cuatojti quinhuica iconehua ipan ieltapal para amo teno huelis quinajsis, quej nopa nimechhualicatoc campa na. ");
INSERT INTO nchBl_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Huajca ama sinta anquicaquise cati nimechilhuijtoc huan anquichihuase nopa camanali cati nijpiya amohuaya, huajca anelise annotapejpenilhua ten nochi masehualme. ");
INSERT INTO nchBl_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Huan anelise se altepet ica seyoc xinachti masehualme cati iyoca ten nochi sequinoc. Nochi anelise totajtzitzi huan tatzejtzeloltique noixpa. Quej nopa TOTECO quiilhui Moisés ma quinilhui nopa israelitame. ");
INSERT INTO nchBl_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Huajca Moisés yajqui huan quinnotzato nopa huehue tacame cati quipiyayayaj tanahuatili ica nopa israelitame huan quinilhui nochi cati TOTECO quinahuatijtoya. ");
INSERT INTO nchBl_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Huajca nochi nopa israelitame tananquilijque san se: ―Nochi cati TOTECO tanahuatijtoc, tijchihuase. Huajca Moisés yajqui quiilhuito TOTECO cati nopa israelitame tananquilijque, ");
INSERT INTO nchBl_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Huan TOTECO quiilhui: ―Xiquita, na nimonextis amoixpa ipan se mixti cati tilahuac para nopa masehualme ma nechcaquica quema nimitzcamanalhuis. Quej nopa motemachise ipan ta para nochipa. Huan Moisés quiilhui TOTECO taya quinanquilijtoyaj nopa israelitame. ");
INSERT INTO nchBl_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Huan TOTECO quiijto: ―Xiya xiquincualtaliti nopa masehualme ama huan mosta, huan xiquiniyocacahua senquisa para na. Monequi quichicuenise iniyoyo, ");
INSERT INTO nchBl_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","huan ma mocualtalise para huicta, pampa huicta nitemos na niamoTECO, huan niitztos ipan tepet Sinaí iniixpa nochi nopa masehualme. ");
INSERT INTO nchBl_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Huajca xijchihua se nepamit yahualtic nopa tepet huan xiquinnahuati nopa masehualme ma amo quiixcotonaca. Huan xiquinilhui ma motachilica para amo tejcose, yon amo ajsise campa nopa nepamit, pampa cati quiajsis nopa tepet o nopa nepamit temachti monequi anquimictise. ");
INSERT INTO nchBl_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Huan amo aqui huelis quitalis imax ipan nopa masehuali o nopa tapiyali cati monequi miquis, pampa monequi anquimictise ica tet o ica cuataminti, masque se masehuali o se tapiyali. Amo huelis anquicahuase ma itzto. Masehualme san huelise monechcahuise itzinta nopa tepet quema quicaquise quipitzaj icuacua se oquich borrego. ");
INSERT INTO nchBl_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Huajca Moisés temoc ten nopa tepet huan quincualtali nopa masehualme para quihueyichihuase Toteco. Huan nochi quichicuenijque iniyoyo. ");
INSERT INTO nchBl_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Huan Moisés quinilhui: ―Monequi anmocualtalise para huicta. Huan tacame huan sihuame ma amo motecaca san sejco ipan ni tonali. ");
INSERT INTO nchBl_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Huan ihuictaca ica ijnaloc, pejqui tatomoni huan tapetani, huan se mixti cati nelía tilahuac motali ipan nopa tepet. Huan quicajque se tapitzali cati nelía chicahuac hasta nochi nopa israelitame pejque huihuipicaj. ");
INSERT INTO nchBl_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Huan Moisés quinyacanqui nochi nopa israelitame, huan inijuanti quisque campa quiquetztoyaj ininchajchaj para mopantise ihuaya Toteco Dios. Huan moquetzatoj itzinta nopa tepet. ");
INSERT INTO nchBl_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Huan nochi nopa tepet Sinaí popocayaya pampa TOTECO hualtemotoya ipan se tit. Nopa pocti tejcoyaya quej campa tacacatzohuaj, huan nochi nopa tepet mojmoliniyaya tahuel chicahuac. ");
INSERT INTO nchBl_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Huan quema nopa tapitzali tahuel chicahuac eltiyajqui, Moisés camanaltic, huan Toteco Dios quinanquili ica itoscac cati elqui quej se tatomonilot. ");
INSERT INTO nchBl_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Huan TOTECO temoc hasta itzompac nopa tepet Sinaí huan quinotzqui Moisés ma tejco. Huan Moisés tejcoc, ");
INSERT INTO nchBl_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","huan TOTECO quiilhui: ―Xitemo huan xiquinelnamiquiltiti nopa masehualme para ma amo quiixpanoca nopa nepamit campa niquinilhuijtoc. Yon ma amo mocuatopejtiyaca pampa quinequise techitase para amo miquise. ");
INSERT INTO nchBl_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Hasta nojquiya nopa totajtzitzi cati quipiyaj inintequi para technechcahuise monequi mocualchijchihuase huan moiyocacahuase san para na para amo niquintzontamiltis. ");
INSERT INTO nchBl_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Huan Moisés quinanquili TOTECO: ―Nopa masehualme amo motemacase tejcose ipan ni tepet Sinaí, pampa ta titanahuati ma nijtali se nepamit huan ma niquiyocacahua ni tepet san para ta, huan ya nopa nijchijtoc. ");
INSERT INTO nchBl_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Pero TOTECO quiilhui: ―Xitemo sempa huan xijcuiti Aarón. Pero amo xiquincahuili nopa totajtzitzi, yon nopa masehualme, ma mocuatopehuaca huan ma quiixpanoca nopa nepamit para tejcose campa niitztoc, pampa sinta quichihuase, niquincocototzas. ");
INSERT INTO nchBl_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Huajca Moisés temoc sempa huan quinilhuito nopa israelitame cati TOTECO quiilhui. ");
INSERT INTO nchBl_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Huan Toteco Dios camanaltic huan quiijto nochi ni camanali: ");
INSERT INTO nchBl_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Na niDIOS, niamoTECO cati nimechquixti ipan tali Egipto campa antetequipanohuayayaj san tapic quej amechcojtosquíaj. ");
INSERT INTO nchBl_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Amo xijtepanitaca seyoc quej amoTeco, san na. ");
INSERT INTO nchBl_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Amo xijchihuaca itachiyalis yon se tamanti para anquitepanitase. Amo xiquixcopinaca cati eltoc ipan ilhuicac, yon cati eltoc ipan ni taltipacti, yon cati onca ipan hueyat para anquihueyichihuase. ");
INSERT INTO nchBl_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Amo ximotancuaquetzaca iniixpa taixcopincayome cati tachijchihualme, yon amo xiquinhueyichihuaca, pampa na niDIOS, niamoTECO, huan nimechtasomati huan nijnequi san na techhueyimatica. Huan quema niquintatzacuiltía tetajme cati amo quinequij techitase, nopa tatzacuiltili nojquiya quinajsis ininconehua, huan iniixhuihua huan ininteipan ixhuihua. ");
INSERT INTO nchBl_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Pero ica cati techicnelíaj huan cati quichihuaj notanahuatil, niquinicnelis huan niquintasojtas ininconehua, huan iniixhuihua huan hasta nopa iniixhuihua quinpiyase iniixhuihua mil huelta. Quena, notasojtacayo quinajsis para nochipa. ");
INSERT INTO nchBl_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Amo xicahuilmatica notoca niamoTECO Dios, pampa amo quinamiqui. Temachti nijtatzacuiltis cati san quej hueli quitequihuía notoca. ");
INSERT INTO nchBl_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Xiquelnamiquica sábado, nopa tonali para anmosiyajquetzase, huan xijtepanitaca. Ma elis taiyocatalili ten nochi sequinoc tonali. ");
INSERT INTO nchBl_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ipan chicuasen tonali xijchihuase nochi cati monequi anquichihuase. ");
INSERT INTO nchBl_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Pero nopa chicompa tonali elis se tonali para ximosiyajquetzaca huan techhueyitalica na niamoTECO Dios. Ipan nopa tonali amo hueli antequitise, yon amo xijcahuilica ma tequiti amotelpoca, yon amoichpoca, yon amotequipanojca, yon amosihua tequipanojca, yon amotapiyalhua, yon nopa seyoc tali ejquet cati itztoc ipan amochaj. ");
INSERT INTO nchBl_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Pampa ica chicuasen tonali TOTECO quichijqui ilhuicacti, taltipacti, hueyi at huan nochi cati quipiya. Huan mosiyajquetzqui ipan nopa chicompa tonali. Yeca TOTECO quitiochijqui nopa chicompa tonali huan quiiyocatali para ma timosiyajquetzaca. ");
INSERT INTO nchBl_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Xijtepanitaca amotata huan amonana para anitztose miyac xihuit ipan nopa tali cati TOTECO Dios amechmacas. ");
INSERT INTO nchBl_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Amo xitemictica. ");
INSERT INTO nchBl_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Amo ximomecatica. ");
INSERT INTO nchBl_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Amo xitachtequica. ");
INSERT INTO nchBl_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Amo aqui xiquistacahuica. ");
INSERT INTO nchBl_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Amo xiquixtocaca seyoc ichaj, yon amo xiquixtoca seyoc isihua, yon itaca tequipanojca, yon isihua tequipanojca, yon itoro cati tapoxonía, yon iburro. Amo xiquixtocaca yon se tamanti cati seyoc iaxca.” ");
INSERT INTO nchBl_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Nochi israelitame quicajque nopa tatomonilot huan nopa tapitzali. Quiitaque nopa tapetanilot huan nopa tepet cati popocayaya. Huan tahuel majmajque, huan huihuipicaque huan mohuejcaquetzque. ");
INSERT INTO nchBl_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Huan quiilhuijque Moisés: ―Techcamanalhui ta huan timitzneltoquilise. Pero ma amo techcamanalhui Toteco Dios, pampa huelis timiquise. ");
INSERT INTO nchBl_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Huan Moisés quinnanquili: ―Amo ximomajmatica. Toteco Dios hualajtoc quej ni para amechnextilis ihueyi chicahualis para xiquimacasica para nochipa huan para amo antajtacolchihuase. ");
INSERT INTO nchBl_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Huan nochi nopa masehualme más mohuejcaquetzque. Huan Moisés monechcahui campa nopa mixti cati yayahuic campa itztoya Dios. ");
INSERT INTO nchBl_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Huan TOTECO quiilhui Moisés: “Quej ni xiquinilhui nopa israelitame: ‘Ya anquiitztoque para nimechnojnotztoc ten ilhuicac. ");
INSERT INTO nchBl_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Amo xijchihuaca tamanti ten oro, o ten plata o ica yon se tamanti para anquihueyimatise. Monequi techtepanitaca san na. ");
INSERT INTO nchBl_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Techchihuilica se taixpamit ica soquit huan ipani antechmacase tacajcahualisti. Nopona xijtencahuaca nopa tacajcahualisti cati tatatili huan nopa tacajcahualisti para anquipiyase tayoltalili ica na, niamoTECO. Huan nopona anquintencahuase pilborregojtzitzi huan huacaxme quej amotacajcahualis. Huan campa hueli campa na nimechchihualtis para anmoilhuise ten na, nopona xijchihuaca se taixpamit. Huan nopona na niyas huan nimechtiochihuas. ");
INSERT INTO nchBl_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Sinta antechchihuilise se taixpamit ten tet, amo xijtequica nopa tet. Pampa sinta anquitequise ica teposti, amo quinamiqui anquitalise ipan notaixpa. ");
INSERT INTO nchBl_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Huan nijnequi notaixpa ma amo quipiyas escalones campa tacame monequi tejcose para quiajsise. Amo nijnequi para seyoc hueli quiitas tatzinta icuex cati tejcos nopona.’ ");
INSERT INTO nchBl_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Ya ni nopa tanahuatilme cati tiquinmacas israelitame: ");
INSERT INTO nchBl_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Sinta tijcohuas se tequipanojquet hebreo para moaxca, san monequi mitztequipanos chicuasen xihuit. Ipan nopa chicompa xihuit, monequi tijmajcahuas para ayecmo elis moaxca. Huan amo teno monequi mitztaxtahuis para quisas huan elis majcajtoc para yas campa quinequis. ");
INSERT INTO nchBl_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Sinta ajsico iseltitzi, yas iseltitzi. Pero sinta ajsico ica isihua, monequi isihua yas ihuaya. ");
INSERT INTO nchBl_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Sinta iteco quimacas se sihuat huan nopa sihuat quinpiyas oquichpilme huan sihuapilme; nopa sihuat huan iconehua mocahuase para iteco huan nopa taca tequipanojquet yas iseltitzi. ");
INSERT INTO nchBl_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Pero sinta nopa taca tequipanojquet quiijtos para amo quinequi itztos majcajtoc para yas campa ya quinequis huan quiijtohua quiicnelía iteco, isihua, huan iconehua huan quinequi mocahuas inihuaya, huajca yaya huelis mocahuas para noja elis iaxca iteco. ");
INSERT INTO nchBl_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Huan iteco quihuicas iniixpa jueces, huan nopona quinechcahuiltise iteno nopa caltemit cati quiyahualtzacua nopa altepet huan ica se hueyi tepos huitzmalot quicoyonilis inacas. Quej nopa yaya mochihuas itequipanojca iteco para nochipa. ");
INSERT INTO nchBl_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Sinta se tacat quinamacas iichpoca para ma tequipano san tapic, nopa ichpocat amo hueli mochihuas majcajtoc quej mochihuaj majcajtoque taca tequipanohuani. ");
INSERT INTO nchBl_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Pero sinta iteco nopa ichpocat amo quiixtocac huan yeca amo quichijqui isihua, masque quitapejpeni para se tonali elisquía isihua, huajca seyoc huelis quicohuas nopa ichpocat sempa. Pero nopa teteco amo huelis quinamacas nopa ichpocat ica se cati seyoc tali ejquet. ");
INSERT INTO nchBl_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Huan sinta nopa teteco quitapejpeni se sihua tequipanojquet hebreo para quimacas itelpoca para ma quichihua isihua, monequi nopa teteco ayecmo quiitas quej se tequipanojquet, monequi quiitas quej elisquía iichpoca. ");
INSERT INTO nchBl_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Huan sinta nopa teteco quicuis se hebrea ichpoca tequipanojquet para isihua huan teipa quicuis seyoc isihua, amo hueli quiquixtilis yon quentzi itacualis nopa cati achtohui. Noja monequi quitamacas cuali, huan quiyoyontis cuali huan itztos ihuaya. ");
INSERT INTO nchBl_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Huan sinta amo quinequi quichihuilis nochi ni eyi tamanti, nopa sihuat huelis mochihuas majcajtoc para yas campa yaya quinequis huan amo teno monequis taxtahuas para quisas. ");
INSERT INTO nchBl_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Sinta acajya quimaquilis seyoc huan yaya miquis, monequi anquimictise nopa temictijquet. ");
INSERT INTO nchBl_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Pero sinta cati temicti amo quinequiyaya quicocos, san panoc pampa huelis quej nopa Toteco Dios quicahuili ma eli, na nimitznextilis teipa canque huelis yas nopa masehuali para momanahuiti para amo aqui quiitzquis huan quimictis. ");
INSERT INTO nchBl_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Pero sinta nopa temictijquet mocualanis ihuaya seyoc huan quisencahuas quenicatza huelis quicajcayahuas huan quimictis, huajca monequi xijmictica. Masque nopa temictijquet motatiti tiopan calijtic huan quiitzquis notaixpa para momanahuis, monequi tijquixtis, huan xitanahuatis ma quimictica. ");
INSERT INTO nchBl_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Sinta se quimaquilis inana o itata, monequi anquimictise. ");
INSERT INTO nchBl_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Sinta se teichtequis, masque quinamacas nopa masehuali para ma tequipano, o noja quipixtos imaco quema anquipantise, monequi anquimictise. ");
INSERT INTO nchBl_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Sinta se quitelchihuas itata o inana, monequi anquimictise. ");
INSERT INTO nchBl_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Sinta masehualme motehuíaj huan se quimaquilis ne se ica se tet, o ica se imax, pero amo miquis, san huetztos ipan itapech, nopa cati tecoco amo monequi miquis. ");
INSERT INTO nchBl_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","Sinta nopa cocoxquet huelis motananas huan huelis quisas calteno ica icuatopil, huajca san monequi taxtahuas nopa tecocojquet cati ica mopajtis huan taxtahuas nochi nopa tonali tequit cati quipolos hasta cuali mochicahuas. ");
INSERT INTO nchBl_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Sinta se acajya quihuitequis itaca o isihua tequipanojca ica se cuahuit, huan yaya miquis pampa quicoco, monequi anquitatzacuiltise iteco por cati quichijtoc. ");
INSERT INTO nchBl_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Pero sinta nopa tequipanojquet itztos para se ome tonati huan teipa miquis, amo monequi anquitatzacuiltise iteco, pampa nopa tequipanojquet iaxca. ");
INSERT INTO nchBl_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Sinta ome tacame motehuíaj huan quicocose se sihuat cati conehue huan ica ya nopa quichihuase ma tacatis icone quema ayemo ajsi tonali, ya ni cati anquichihuase. Sinta amo miqui nopa conet, huajca cati quipiya tajtacoli monequi taxtahuas imiyaca cati quiijtos ihuehue nopa sihuat huan nopa jueces. ");
INSERT INTO nchBl_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Pero sinta miquis nopa conet, monequi anquimictise cati quicoco nopa sihuat. ");
INSERT INTO nchBl_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Huan sinta se teixteyolcocos, xiquixteyolcococa cati tecoco. Sinta tetancochtepehuas, xijtancochtepehuaca. Sinta se quicocos ipan imax o imetz se acajya, monequi nojquiya anquicocose cati tecocohua. ");
INSERT INTO nchBl_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Sinta se tetatía, nojquiya xijtatica. Huan sinta se tetzontequis, xijtzontequica. Sinta se quitejtzonas seyoc, nojquiya xijtejtzona yaya cati tetejtzontoc. ");
INSERT INTO nchBl_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Sinta se teteco quimaquilis itaca o isihua tequipanojca ipan iixteyol, huan quicahuas ixpitzitic huan ayecmo huelis tachiyas ica nopa iixteyol, monequi quicahuilis nopa tequipanojquet ma elis majcajtoc pampa quiixteyolcoco. ");
INSERT INTO nchBl_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Huan sinta se quitancochtepehua itaca o isihua tequipanojca, monequi quicahuilis nopa tequipanojquet ma eli majcajtoc pampa quitancochtepejqui. ");
INSERT INTO nchBl_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Sinta se toro quitompojhuis se masehuali ica icuacua huan miquis, monequi anquimictise nopa toro ica tet huan amo xijcuaca inacayo. Pero amo xijtatzacuiltica cati iaxca nopa tapiyali. ");
INSERT INTO nchBl_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Pero sinta nopa toro ya momajtoya tetompojhuía huan iteco quimati huan amo quitzacua cuali nopa toro, huan sinta teipa quimictis se acajya, monequi anquitzontepachose nopa toro huan iteco hasta miquise. ");
INSERT INTO nchBl_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Pero sinta iteixmatcahua cati nopa toro quimicti, achi más paquise ica tomi huan amo quinequise ma miqui iteco nopa toro, monequi nopa teteco ma quintaxtahuis ica tomi cati quiijtose para quimanahuis inemilis. ");
INSERT INTO nchBl_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Nojquiya quej ni elis sinta nopa toro quitompojhuis se sihuapil o se oquichpil. ");
INSERT INTO nchBl_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Pero sinta nopa toro quitompojhuía se taca o sihua tequipanojquet, monequi anquimictise nopa toro ica tet, huan cati iaxca nopa tapiyali monequi quitaxtahuis iteco nopa sihua o taca tequipanojquet 30 plata tomi. ");
INSERT INTO nchBl_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Sinta acajya quitapojtehua se ameli huan amo quitzacua huan teipa misahuis se toro o se pilburrojtzi, ");
INSERT INTO nchBl_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","huajca cati iaxca nopa ameli monequi quitaxtahuis quej ipati nopa toro cati quipolo. Inacayo nopa tapiyali cati mictoc elis iaxca cati taxtajqui. ");
INSERT INTO nchBl_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Sinta itoro se masehuali quicocos itoro seyoc masehuali hasta miquis, huajca quinamacase nopa toro cati itztoc huan quitajcoitase nopa tomi. Nojquiya quitajcoitase nopa toro cati mictoc. ");
INSERT INTO nchBl_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Pero sinta nopa teteco ya quimajtoya para nopa tapiyali ipa tetompojhuía huan amo quitacaquili, monequi amo san quitaxtahuis tajco. Monequi quitaxtahuis nochi cati ipati nopa tapiyali cati quimicti, huan nopa toro cati mictoc elis iaxca. ");
INSERT INTO nchBl_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Sinta se acajya quiichtequis se toro o se borrego huan quimictis o quinamacas, monequi taxtahuas macuilti torojme para sesen toro, o nahui borregojme para sesen borrego. ");
INSERT INTO nchBl_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Sinta acajya quipantis se tachtejquet quema calaqui techaj tayohua para tachtequis huan nopa cati chane quicocos nopa tachtejquet huan yaya miquis, nopa cati chane amo quihuicas tajtacoli. ");
INSERT INTO nchBl_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Pero sinta ica tonaya quimictis se tachtejquet, quena, quipiyas tajtacoli cati temictijtoc. “Cati tachtequi monequi quiixtahuas cati ipati cati quiichtectoc. Huan sinta amo quipiya tomi, monequi monamacas para tequipanos huan quej nopa quiixtahuas cati quiichtectoc. ");
INSERT INTO nchBl_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Sinta masehualme quipantise se toro, se burro o se borrego tachtecti cati noja itztoc imaco nopa tachtejquet, monequi taxtahuas ompa cati ipati. ");
INSERT INTO nchBl_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Sinta acajya quinmalacanis itapiyalhua huan tacuajcuatij tetocmiltita o texocomeca miltita, monequi quicuepilis yaya cati iaxca nopa tali se taxtahuili quej ipati nopa pixquisti cati más cuali quipixtoya ipan imil o ipan nopa ixocomecamil para quiixtahuas cati itapiyalhua quinenpolojque. ");
INSERT INTO nchBl_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Sinta acajya tajchinohua huan nopa tit panos ipan seyoc imila, huan quitatía nopa trigo cati quimontonojtoque, o cati ya eltoc para pixquisti o quitatía nochi tatocti, yaya cati quitati monequi taxtahuas por nochi cati quitati nopa tit. ");
INSERT INTO nchBl_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Sinta se masehuali quimactilis tomi o tamanti cati ipati se ihuampo para ma quimocuitahuili, huan se tachtejquet calaquis ipan nopa cali huan quitachtequilis, sinta quipantise, monequi nopa tachtejquet quiixtahuas ompa imiyaca ten cati quicuitoc. ");
INSERT INTO nchBl_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Pero sinta amo quipantise nopa tachtejquet, huajca cati quimocuitahuía nopa tamanti quihuicase iniixpa jueces para quiitase sinta yaya quicuitoc cati eltoya iaxca ihuampo cati ipan motemachi. ");
INSERT INTO nchBl_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Quema se quipolos se toro, o se burro, o se borrego, o se yoyomit, o ten hueli tamanti huan teipa quipantis imaco seyoc, huan sinta ne se quiijtohua para iaxca, huajca nochi ome cati quiijtohuaj para iniaxca monequi yase iniixpa jueces, huan nopa jueces quiijtose ajquiya iaxca. Huan yaya cati tecuilijtoc monequi quicuepas ompa. ");
INSERT INTO nchBl_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Sinta acajya quimactilis seyoc ma quimocuitahuili se burro, se toro, se borrego o seyoc tapiyali huan nopa tapiyali miquis, o mococos, o cholos huan amo aqui quiitac taya panoc, ");
INSERT INTO nchBl_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","nopa masehuali cati quimocuitahuiyaya monequi quitestigojquetzas TOTECO para amo teno cati amo cuali quichijtoc ica cati quicahuilijtoyaj. Huan cati iaxca nopa tapiyali monequi quineltoquilis icamanal ihuampo cati quitestigojquetztoc TOTECO. Huan nopa cati tamocuitahuiyaya amo teno monequi taxtahuas. ");
INSERT INTO nchBl_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Pero sinta iixpa quiichtequilijque nopa tapiyali, huajca nopa cati tamocuitahuiyaya monequi quiixtahuilis iteco nopa tapiyali quej ipati. ");
INSERT INTO nchBl_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Huan sinta nopa tapiyali quicocototzqui se tecuani, huajca nopa cati quimocuitahuiyaya monequi quinextis iomiyo nopa tapiyali cati mijqui huan quej nopa amo monequi taxtahuas. ");
INSERT INTO nchBl_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Sinta acajya motanehui se tapiyali, huan nopa tapiyali ipantis se tenijqui, o miquis, huan amo quiitac iteco, huajca yaya cati motanejqui monequi taxtahuas. ");
INSERT INTO nchBl_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Pero sinta nopa teteco noja itztoc ihuaya itapiyal quema ipantis se tenijqui, nopa cati motanejtoc amo monequi taxtahuas. Huan sinta se motanehui se tapiyali huan taxtahua para quitequihuis huan ipantis se tenijqui, amo monequi taxtahuas pampa ya taxtajtoc. ");
INSERT INTO nchBl_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Sinta se tacat quicajcayahuas se ichpocat cati amo quiijtantoque huan quichihualtis cochis ihuaya, monequi quitaxtahuis itata san se quej cati quitaxtahuisquía se tacat cati quinequisquía mocuilis ihuaya nopa ichpocat. Huan quema ya quitaxtahuijtos itata nopa ichpocat, huelis mocuilis. ");
INSERT INTO nchBl_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Huan masque itata nopa ichpocat amo quinequis quimactilis para ma eli isihua, nopa tacat monequi taxtahuas quej imiyaca tomi cati momajtoque temacaj para se ichpocat. ");
INSERT INTO nchBl_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Amo xijcahuilica ma itzto se tenahualhuijquet. Monequi xijmictica. ");
INSERT INTO nchBl_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Sinta acajya quichihuas se tamanti ica se tapiyali quej elisquía itahuical, monequi anquimictise. ");
INSERT INTO nchBl_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Sinta se quimacas se tacajcahualisti se taixcopincayot o seyoc tamanti cati quiita quej elisquía Dios, xijmictica. San na, niamoTECO, techmacaca tacajcahualisti. ");
INSERT INTO nchBl_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Amo xijcajcayahuaca, yon amo xijchihuilica cati fiero se seyoc tali ejquet, pampa amojuanti nojquiya aneltoyaj anseyoc tali ehuani ipan tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Amo xijtaijyohuiltica se sihuat cati cahualtzi, yon se icnotzi. ");
INSERT INTO nchBl_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Pampa sinta anquinchihuilíaj cati fiero, inijuanti techtajtanise ma niquinpalehui huan na nijcaquis huan niquinpalehuis. ");
INSERT INTO nchBl_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Huan nicualanis miyac huan nimechmictis ica macheta, huan amosihuajhua nojquiya mocahuase cahualtzitzi huan amoconehua icnotzitzi. ");
INSERT INTO nchBl_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Sinta anquitanejtise tomi se teicneltzi cati nojquiya se israelita quej amojuanti, amo ximochihuaca quej se tetomintanejtijquet. Amo xiquinamaca itanca. ");
INSERT INTO nchBl_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Sinta teicneltzi se masehuali cati anquitatanejtíaj huan monequi amechcahuilijtehuas itaque, monequi xijcuepilica quema tiotaquiyas, ");
INSERT INTO nchBl_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","pampa huelis setzi itaque quipiya para moquentis quema taseseya huan san ya nopa quipiya para ica mopiquis quema cochi. Huan sinta ya taijyohuis huan techtajtanis ma nijpalehui, nijtacaquilis huan nijpalehuis pampa na nitetasojta. ");
INSERT INTO nchBl_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Amo xiquintaijilhuica amotequiticahua, yon amo xijtaijilhuica yaya cati tanahuatía ipan amotal. ");
INSERT INTO nchBl_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Amo xihuejcahuaca para antechhualiquilise cati noaxca ten nochi amopixquis huan ten nochi amoxocomecamil. “Monequi techmactilica amoachtohui oquichpil. ");
INSERT INTO nchBl_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Nojquiya monequi techmacaca iniachtohui conehua amohuacaxhua huan amoborregojhua. Huelis mocahuase chicome tonati ihuaya ininana, pero ipan nopa chicueyi tonali techmacaca. ");
INSERT INTO nchBl_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Monequi anelise notatzejtzeloltica masehualhua. “Amo xiquincuaca tapiyalme cati tecuanime quinmictijtoque cuatita. Nopa nacat monequi xiquinmacaca chichime. ");
INSERT INTO nchBl_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Amo xijmoyahuaca se camanali cati amo melahuac ten sequinoc. Amo xijpalehuica se fiero masehuali. Amo xijtestigojquetzaca se tamanti cati amo melahuac por ya. ");
INSERT INTO nchBl_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Quema itztoque miyaqui cati quichihuasnequij cati amo cuali, amo ximocalaquica inihuaya. “Quema anmochihuase antestigos para anquiijtose miyacapa cati melahuac panotoc, amo xiquijtoca cati amo melahuac quej miyac masehualme quinequise xijchihuaca, pampa amo xitahuac sinta anquichihuase quej nopa. ");
INSERT INTO nchBl_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Yon amo xitatestigojquetza ica cati amo melahuac pampa tijchicoicnelía se cati teicneltzi huan tijnequi tijpalehuis. ");
INSERT INTO nchBl_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Sinta anquipantilise amocualancaitaca itoro o iburro cati cholojtoc, monequi xijhuiquilica. ");
INSERT INTO nchBl_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Sinta tijpanti mocualancaitaca quitananasnequi iburro cati huetztoc ica itamamal cati etic, amo xijcajtehua hasta tijpalehuis quitananas. ");
INSERT INTO nchBl_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Xiquinchihuili nochi teicneltzitzi cati xitahuac quema onca se cualanti. ");
INSERT INTO nchBl_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","“Xijtalcahui se cati quinequi quitatelhuis seyoc ica cati amo melahuac. Amo xijcahua ma quimictica se cati amo teno quichijtoc. Pampa na nijtatzacuiltis nojquiya yaya cati quicahuas se acajya ma quimicti se masehuali cati xitahuac. ");
INSERT INTO nchBl_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Quema titetajtolsencahua, amo xijseli se taxtahuili ixtacatzi. Cati quiselía taxtahuili ixtacatzi ayecmo huelis quiitas cati melahuac, huan amo quicahuilía ma camanalti cati quiijtohua cati xitahuac. ");
INSERT INTO nchBl_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Amo xijtaijyohuilti se cati seyoc tali ejquet, pampa nojquiya aneltoyaj anseyoc tali ehuani ipan tali Egipto. Huan anquimatij quenicatza anquimatiyayaj quema anitztoyaj ipan se tali cati amo amoaxca. ");
INSERT INTO nchBl_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“San chicuasen xihuit antatojtocase huan anpixcase ipan amotal. ");
INSERT INTO nchBl_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Huan quema ajsis nopa chicompa xihuit, amo teno xijtocaca. San xijcahuaca amotal ma mosiyajquetza. Huan sinta moscaltis iseltitzi se quentzi tocti, xiquincahuilica cati teicneltzitzi ipan amotal ma mopixquilica para ica mopanoltise. Huan cati mocahua ma quicuaca tapiyalme ten cuatita. Nojquiya quej nopa anquichihuase ica amoxocomeca mil huan ica amoolivo mil. ");
INSERT INTO nchBl_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Chicuasen tonati anquichihuase nochi cati monequi anquichihuase, pero ipan nopa chicompa tonali monequi ximosiyajquetzaca. Nojquiya ma mosiyajquetzaca amotorojhua huan amoburrojhua. Ma mosiyajquetzaca amotequipanojcahua cati anquincojtoque huan nopa seyoc tali ehuani cati amechpaxalohuaj. Nopa tasiyajquetzalisti amechpalehuis nochi amojuanti para sempa anquipiyase tetili. ");
INSERT INTO nchBl_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Ximotachilica huan xijchihuaca nochi ya ni cati nimechilhuijtoc. Amo quema xiquintestigojquetzaca inintoca taixcopincayome cati ne sequinoc quinhueyimatij. Yon amo quema xijtenquixtis inintoca. ");
INSERT INTO nchBl_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Eyi huelta ipan se xihuit antechilhuichihuilise. ");
INSERT INTO nchBl_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Xijchihuaca nopa ilhuit ten pantzi cati amo quipiya tasonejcayot quej nimechnahuatijtoc. Xijcuaca pantzi cati amo quipiya tasonejcayot chicome tonati quej nimechilhuijtoc. Anquicuase ipan metzti Abib ipan nopa tonali cati nimitzilhui, pampa ipan nopa metzti anquistejque tali Egipto. Huan amo aqui hueli technechcahuis sinta amo techhualiquilía se tacajcahualisti. ");
INSERT INTO nchBl_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Nojquiya xijchihuaca nopa ilhuit ten ipejya pixquisti huan techhualiquilica cati achtohui anquipixtoque ten anquitojque ipan amomil. Huan nojquiya sesen xihuit xijchihuaca nopa ilhuit ten itamiya pixquisti quema ya anquisentilijtoque nochi nopa pixquisti cati temacac cati anquitoctoque. ");
INSERT INTO nchBl_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Expa ipan se xihuit monequi nochi antacame ximonextica noixpa, na niamoTECO Cati más Nijpiya Tanahuatili. ");
INSERT INTO nchBl_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Quema antechmacase ieso se tapiyali para se tacajcahualisti, amo techmacaca san sejco ihuaya pantzi cati quipiya tasonejcayot. Yon amo xicajocuica ichiyajca nopa tapiyali para antechmacase seyoc tonali. ");
INSERT INTO nchBl_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Ipan nopa achtohui tonali ten nopa achtohui pixquisti, xijtapejpenica cati más cuali ten itajca cati temaca amotal huan techmactilica, na niamoTECO Dios. “Amo xiquicxitica se pilcone chivojtzi ipan inana ilechi quej quichihuaj tenahualhuiani. ");
INSERT INTO nchBl_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Xiquita, na nijtitanis noilhuicac ejca ma amechyacana, huan ma amechmocuitahui ipan ojti huan ma amechhuica hasta nopa tali cati nimechcualtalilijtoc. ");
INSERT INTO nchBl_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Xijtacaquilica cuali cati yaya amechilhuis huan xijneltoquilica. Amo xijhuejcamajcahuaca, pampa yaya quihuica nochi nopa tanahuatili cati nijhuica na huan amo amechtapojpolhuis amotajtacolhua sinta anquihuejcamajcahuase. ");
INSERT INTO nchBl_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Pero sinta nelía anquicaquise cuali nochi cati nimechilhuía huan anquichihuase nochi cati nimechnahuatijtoc, na nielis niinincualancaitaca amocualancaitacahua huan niquintaijyohuiltis cati amechtaijyohuiltise. ");
INSERT INTO nchBl_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Noilhuicac ejca amechyacanas huan amechhuicas ipan inintal nopa amorreos, heteos, ferezeos, cananeos, heveos huan jebuseos. Huan na niquintzontamiltis amoixpa. ");
INSERT INTO nchBl_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Amo ximotancuaquetzaca iniixpa inintaixcopincayohua nopa masehualme, yon amo xiquinhueyichihuaca. Amo quema xijtoquilica sequinoc fiero tamanti cati nopa masehualme quichihuaj. Monequi xiquintzontamiltica nochi nopa masehualme huan senquisa xiquinsosoloca nochi nopa teme cati quinhueyichihuaj. ");
INSERT INTO nchBl_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","San techhueyichihuaca na, niamoTECO Dios, huan nijtiochihuas amotacualis ihuaya amoa. “Huan nijchihuas para ma amo amechajsi cocolisti. ");
INSERT INTO nchBl_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Amo oncas yon se sihuat ipan amotal cati amo huelis conepiyas o cati conehuetzis. Huan nijchihuas para anitztose miyac xihuit ipan ni taltipacti. ");
INSERT INTO nchBl_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Na nijtitanis se hueyi majmajti ipan nochi nopa fiero masehualme campa anajsise hasta amo quimatise taya quichihuase. Huan nijchihuas ma cholojtehuaca amoixpa nochi amocualancaitacahua. ");
INSERT INTO nchBl_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Niquintitanis etzame ma tayacanaca huan ma quinquixtijtiyaca nopa heveos, nopa cananeos, huan nopa heteos amoixpa. ");
INSERT INTO nchBl_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Pero amo niquinquixtis nochi san ipan se xihuit. Sinta quej nopa nijchihuasquía, polihuisquía nochi cati tatojtoctoque, huan momiyaquilisquíaj tecuanime cati itztoque cuatita cati huelis amechcocose. ");
INSERT INTO nchBl_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Pero ica yolic niquinquixtijtiyas amoixpa quej nojquiya yolic anquinpixtiyase más amoconehua huan anmomiyaquilijtiyase para anmoaxcatise nopa tali. ");
INSERT INTO nchBl_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Quej ni nijquetztoc inepa amotal: Pejtehuas amotal ipan nopa Hueyi At Chichiltic huan yas hasta nopa Hueyi At Mediterráneo. Nojquiya pejtehuas ipan huactoc tali ica sur huan tamis ipan nopa hueyat Eufrates ica campa huala tonati. Na nijtalijtoc amomaco nochi masehualme cati ehuani ipan nopa tali para xiquinquixtica. ");
INSERT INTO nchBl_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","“Amo xijchihuaca yon se camanali inihuaya, yon ica inintaixcopincayohua. ");
INSERT INTO nchBl_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Amo xiquincahuilica ma mocahuaca ipan amotal para amo amechchihuase xitajtacolchihuaca ica na. Sinta anquinhueyichihuase inintaixcopincayohua, huajca nelía amechmasiltise.” ");
INSERT INTO nchBl_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Huan TOTECO quiilhui Moisés: ―Xitejco campa na niitztoc, ta ihuaya Aarón, Nadab, Abiú huan nopa 70 huehue tacame cati mohuaya quinyacanaj ni israelitame. Inijuanti ma motancuaquetzaca ica huejca para techhueyimatise. ");
INSERT INTO nchBl_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","San ta, Moisés, huelis timonechcahuis campa na, niamoTECO, niitztoc. Nopa sequinoc tayacanani amo huelise technechcahuise, huan nopa sequinoc israelitame amo huelis tejcose nica amohuaya. ");
INSERT INTO nchBl_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Huan Moisés yajqui quinpohuilito nopa israelitame nochi cati TOTECO quiijtojtoya huan cati tanahuatijtoya. Huan nochi israelitame ica sempa tananquilijque: ―Nochi cati TOTECO quiijtojtoc, tijchihuase. ");
INSERT INTO nchBl_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Huajca Moisés quiijcuilo nochi cati TOTECO quiilhuijtoya. Huan tonili cualca mijquejqui huan quichijchijqui se taixpamit itzinta nopa tepet, huan quiquetzqui nopa taixpamit ipan doce teme quej imiyaca itelpocahua Israel cati ica pejqui nopa doce huejhueyi familias ten israelitame cati ama onca. ");
INSERT INTO nchBl_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Teipa quintitanqui sequij israelita telpocame ma quimacaca TOTECO tacajcahualisti tatatili. Huan quinmictijque huan quintatijque torojme para tacajcahualisti para quipiyase tasehuilisti ica TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Huan Moisés quicuic tajco nopa esti, huan quitejqui ipan huajcalme huan nopa seyoc tajco quiijtzelo ipan taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Teipa quicuic nopa amat cati quipixtoya itanahuatil TOTECO, o nopa camanal sencahuali cati TOTECO quichijtoya inihuaya israelitame huan cati monequi quineltocase. Huan quinpohuili nochi nopa amat huan inijuanti quiijtojque: ―Quena, tijneltoquilise TOTECO huan tijchihuase nochi cati yaya techilhuijtoc. ");
INSERT INTO nchBl_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Huajca Moisés quicuic nopa esti ipan huajcalme, huan quinijtzelhuili nochi israelitame, huan quiijto: ―Ya ni nopa esti cati quipehualtía nopa camanal sencahuali cati TOTECO quichijqui amohuaya quema amechmacac nochi ni tanahuatili. ");
INSERT INTO nchBl_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Huan teipa Moisés tejcoc ipan nopa tepet ihuaya Aarón, Nadab, Abiú huan nopa 70 huehue tacame cati quinyacanayayaj nopa israelitame. ");
INSERT INTO nchBl_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Huan nopa israelita tayacanani quiitaque Dios, ininTeco israelitame. Huan iicxitantita eltoya se piso azultic quej nopa yejyectzi tet cati itoca zafiro, huan eliyaya tahuel tzalantic quej ilhuicacti. ");
INSERT INTO nchBl_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Huan masque nopa tayacanca israelitame quiitaque Toteco Dios huan san sejco tacuajque huan atique iixpa, amo quinmicti. ");
INSERT INTO nchBl_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Huan TOTECO quiilhui Moisés: ―Xitejco campa niitztoc ipan ni tepet huan ximocahua nica. Huan nimitzmacas nopa tepatacti campa niquijcuilojtoc nopa ley huan nopa tanahuatilme para tiquinmachtis israelitame. ");
INSERT INTO nchBl_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Huan Moisés tejcoc ipan itepe Toteco ica Josué itapalehuijca. ");
INSERT INTO nchBl_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Huan Moisés quinilhui nopa huehue tacame: ―Techchiyaca nica hasta quema titacuepilise. Nica mocahuas Aarón huan Hur amohuaya, huan sinta acajya quipiya se cualanti quema amo niaqui, ma quinilhuica inijuanti. ");
INSERT INTO nchBl_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Huan Moisés tejcoc ipan nopa tepet huan se mixti quitzajqui. ");
INSERT INTO nchBl_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Huan itatanex TOTECO temoc ipan tepet Sinaí, huan nopa mixti quitzajqui nopa tepet para chicuasen tonati. Huan quema ajsic nopa chicompa tonali, TOTECO quinotzqui Moisés tatajco ten nopa mixti. ");
INSERT INTO nchBl_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Huan nopa israelitame cati itztoyaj tatzinta quiajcotachilijque huan quiitaque itatanex TOTECO, huan para inijuanti elqui quej se tilelemecti cati nochi quitatiyayaj tepeixco. ");
INSERT INTO nchBl_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Huajca Moisés tejcotiyajqui ipan nopa tepet, huan calajqui ipan nopa mixti huan nopona mocajqui para 40 tonati huan 40 yohuali. ");
INSERT INTO nchBl_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Huan nojquiya TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Xiquinilhui nopa israelitame para hueli techmacase tacajcahualisti sinta quinequij. Xijsentilica nochi nopa tamanti cati sese israelita quinequi techmacas ica nochi iyolo. ");
INSERT INTO nchBl_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Sinta quinequij techmacase se tenijqui, huelis xiquinselhuili tamanti ten oro, plata huan cobre. ");
INSERT INTO nchBl_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","Nojquiya huelis tiquinselhuilis icpat ten nopa tzonti cati itoca lino cati tamalinti nelcanactzi, huan nojquiya icpat ten iniijhuiyo borregojme cati quipajtoque azultic, morado, o chichiltic. Nojquiya xijseli inincuitapan ijhuiyo chivojme, ");
INSERT INTO nchBl_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","huan inincuetaxo pesojme huan nopa cuahuit cati itoca acacia. ");
INSERT INTO nchBl_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Xijseli aceite para ica quitatise taahuili. Xijseli taajhuiyacayot para aceite cati quitequihuíaj para taiyocacahuase para na, huan nojquiya para ica anquisencahuase copali cati ajhuiyac. ");
INSERT INTO nchBl_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Nojquiya huelis techmacase teme cati pajpatiyo. Huelis techmacase nopa tet ónice huan sequinoc teme cati yejyectzitzi para anquitatzquiltise ipan nopa pantzajcayot huan nopa yolixtzajcayot para nopa hueyi totajtzi iyoyo. ");
INSERT INTO nchBl_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Teipa techchihuilica se cali para ipan niitztos tatajco ten amojuanti. ");
INSERT INTO nchBl_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Pero monequi xijsencahua nochaj ica nochi cuamesas huan tamantzitzi senquisa quej ni taixcopinali cati ama nimitznextilis. ");
INSERT INTO nchBl_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Ma quichihuaca se caxa yejyectzi ica nopa cuahuit cati itoca acacia. Huan nopa caxa quipiyas 1 metro 10 centímetros ihuehueyaca huan 65 centímetros ipatajca huan ihuejcapanca. ");
INSERT INTO nchBl_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Xicalaxoca ica senquisa oro iijtic huan ipani. Huan yahualtic itejteno xijchijchihuili se corona ten oro. ");
INSERT INTO nchBl_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Xijchihuili nahui huejhueyi anillos ten oro. Xijtalica nopa anillos najcac campa imetzhua, ome ipan se lado huan ome ipan ne seyoc. ");
INSERT INTO nchBl_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Huan xijchihuaca ome cuahuit cati huehueyac huan pitzahuac para ica anquiquechpanose. Huan xicalaxoca nopa cuahuit ica oro, ");
INSERT INTO nchBl_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","huan ma pano se ten nopa cuahuit huehueyac ipan nopa ome anillo ipan sesen lado ipan inacasta nopa caxa para quej nopa huelis anquitananase. ");
INSERT INTO nchBl_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Huan ayecmo xijquixtilica nopa cuahuit cati ica anquihuicase. Ma mocahua nopa cuahuit ipan ianillos nopa caxa. ");
INSERT INTO nchBl_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Huan quema anquisencahuase nopa caxa, xijtalica iijtic nopa tepatacti ica nopa tanahuatilme cati nimitzmacas. ");
INSERT INTO nchBl_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Huan xijchihuaca nopa caxa itzajca ten senquisa oro cati quipiyas se metro 10 centímetros ihuehueyaca huan 65 centímetros ipatajca. Nopona iixco nopa caxa timopantise huan nimechtasojtas quema antajtacolchihuase. ");
INSERT INTO nchBl_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Xiquinchihuaca nojquiya ome ilhuicac ehuani cati inintoca querubines cati ijcatose ipan itzajca nopa caxa. ");
INSERT INTO nchBl_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Xiquinchijchihuaca nopa ome querubines ica san se tatecti oro cati tatejtzonti ica itzajca nopa caxa. Se querubín moquetzas ipan se iteno huan ne se ipan seyoc iteno ica ihuehueyaca. ");
INSERT INTO nchBl_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Huan nopa querubines monequi quipatajtose inieltapal itzompac nopa caxa para quiecahuilise. Huan moixnamictose nopa querubines huan tachixtose tatzinta ipan itzajca nopa caxa, pampa nopona nitetasojtas. ");
INSERT INTO nchBl_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Quema ya tasencahuali itzajca, xijtalica caxa ijtic nopa tepatacti ica nopa tanahuatili cati nimitzmacas. ");
INSERT INTO nchBl_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Huan nopona tatajco ten nopa querubines cati ijcatoque iixco itzajca nopa caxa, nimechnamiquis huan nimechtasojtas. Quena, nopona itzonco nopa caxa cati quipiya nopa tepatacti cati quipiya nopa camanal sencahuali cati ica nimocajtoc amohuaya, nimechmatiltis nochi notanahuatilhua cati nijpiya para anisraelitame. ");
INSERT INTO nchBl_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Xijchihuaca se cuamesa ica nopa cuahuit acacia, huan quipiyas 90 centímetros ihuehueyaca, 45 centímetros ipatajca, huan 65 centímetros ihuejcapanca. ");
INSERT INTO nchBl_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Xicalaxoca nopa cuamesa ica senquisa oro. Nojquiya xijchihuilica icorona ten oro itejteno. ");
INSERT INTO nchBl_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Nojquiya yahualtic itejteno nopa cuamesa ma quipiya se icorona ten chicome centímetros huan tajco ihuejcapanca. Xicalaxoca nopa corona ica senquisa oro. ");
INSERT INTO nchBl_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Nojquiya xijchihuilica nahui anillos ten senquisa oro cati anquitalilise ipan sese inacasta campa imetzhua. ");
INSERT INTO nchBl_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Nopa anillos monequi tatzquitose itantita nopa corona nechca nopa cuamesa campa pehua imetz, huan ipan nopa anillos calaquis nopa cuahuit huehueyac para ica anquihuicase nopa cuamesa. ");
INSERT INTO nchBl_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Huan nopa cuahuit huehueyac cati ica anquiquechpanose nopa cuamesa monequi xijchihuaca ica acacia cuahuit, huan xicalaxoca ica senquisa oro. ");
INSERT INTO nchBl_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Nojquiya xijchijchihuaca platos, huejhueyi cucharas ten oro, tepos huitzcucharas huan huejhueyi xarros para ipan anatecase. Huan ica antechmacase, na niamoTeco, nopa tacajcahualisti cati anquitoyahuase noixpa. ");
INSERT INTO nchBl_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Huan monequi mojmosta noixpa anquitalise iixco nopa mesa nopa pantzi cati tenextilía para niitztoc amohuaya. ");
INSERT INTO nchBl_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Huan nojquiya xijchijchihuaca se taahuil quetzali ten senquisa oro cati tatejtejtzonali ica martillo. Quipiyas se icuayo huan chicuase imacuayohua. Huan sesen pilcaxitzitzi cati ipan tatatise quipiyas iyejyejca. Nesis quej se xochit mimilijtoc huan se xochit cati cahuantoc, huan nochi iyejyejca monequi elis san se tatecti oro. ");
INSERT INTO nchBl_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Huan ica nopa chicuase imacuayohua ten nopa taahuil quetzali quipiyas, eyi imacuayohua quisas se lado huan ne seyoc eyi imacuayohua quisas ne seyoc lado. ");
INSERT INTO nchBl_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Huan ipan sese imacuayo quipiyas eyi pilcaxitzitzi cati quiyecchijtoque para nesis quej eyi ixochiyo nopa almendra. Sesen quipiyas se xochit mimilijtoc huan se xochit cahuantoc. Nochi chicuase imacuayo cati quisase ipan icuayo nopa taahuil quetzali quipiyase san se xochit. ");
INSERT INTO nchBl_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Huan icuayo cati eltoc tatajco nopa taahuil quetzali quipiyas nahui pilcaxitzitzi ica inintachiyalis quej ixochiyo se almendra. Sesen quipiyas se xochit mimilijtoc huan se xochit cahuantoc. ");
INSERT INTO nchBl_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Campa quisa nopa achtohui ome imacuayohua ipan sesen lado icuayo, oncas se xochit mimilijtoc itantita imacuayo. Huan nojquiya itantita ipan sesen lado nopa ompa huan expa imacuayohua oncas se xochit mimilijtoc. Huajca quipiyas se xochit mimilijtoc itantita nochi chicuase imacuayohua ipan nopa taahuil quetzali. ");
INSERT INTO nchBl_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Ixochiyo huan imacuayohua elis tasencahuali ica san se tatecti ten senquisa oro cati tatejtzonti ica martillo. ");
INSERT INTO nchBl_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Huan xijchijchihuilica chicome piltaahuiltzitzi cati anquitatise para ma taahuica ica iniixmelac. ");
INSERT INTO nchBl_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Nojquiya xijchihuaca nopa cucharas para ica anquisehuise taahuili huan nochi pilplatotzitzi, huan nochi xiquinchihuaca ica senquisa oro. ");
INSERT INTO nchBl_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Monequis quej 33 kilos ten senquisa oro para anquichihuase huan anquiyectalise nopa taahuil quetzali. ");
INSERT INTO nchBl_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","“Ximotachili para tijchihuas nochi san quej na nimitznextilía amantzi nica ipan ni tepet. ");
INSERT INTO nchBl_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Xijchijchihuili nopa yoyon tiopamit majtacti cortinas ica icpat ten lino tamalinti hasta nelía canactzi, huan icpat ten iniijhuiyo borregojme cati quipajtoque azultic, morado huan chichiltic. Huan ma quixinepalo se cati tahuel quimati para nesis iniixcopinca nopa ilhuicac ehuani cati inintoca querubines. ");
INSERT INTO nchBl_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Huan sesen cortina quipiyas 12 metros huan tajco ihuehueyaca, huan ipatajca elis ome metro. Huan nochi nopa cortinas elis san se inihuejhuexca. ");
INSERT INTO nchBl_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Huan xijsalo nopa macuili cortinas san sejco. Huan nojquiya xijsalo nopa sequinoc macuili cortinas san sejco. Quej nopa quisas ome cortinas cati nelía huehueyac. ");
INSERT INTO nchBl_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Huan ipan se iteno ten nopa achtohui macuili cortinas cati tijsalojtoc, xijchihuili tailpili ica itzojhuaso cati tijtenyahualos ica icpat cati azultic. Nojquiya san se tijchihuas ipan se iteno nopa sequinoc macuili cortinas cati tijsalojtoc. ");
INSERT INTO nchBl_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Ipan nopa achtohui tasaloli ten cortinas, xijchihuili 50 tailpili huan ipan sesen xijcahua itzojhuaso. Teipa xijtenyahualos campa tijchihuili itzojhuaso ica icpat azultic. Xijchihuili seyoc 50 ipan ne seyoc cortina cati tijsalojtoc para ma moixnamiquica nopa 50 tailpili ipan se cortina ica cati eltoc ipan ne seyoc. ");
INSERT INTO nchBl_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Huan xijchihua 50 tepos chijcoli ten senquisa oro cati ica tijsojsos nopa ome cortinas cati tijsalojtoc, huan quej nopa elis san se tamanti para itzontzajca nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Huan nojquiya tijchihuas 11 cortinas ica se yoyomit tetic cati taxinepaloli ica iniijhuiyo oquich chivojme para elis quej se hueyi cuetaxti para tijtzontzacuas nopa yejyectzi yoyomit cati tijtalijtoc itzompac nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Monequi nopa tzontzajcayot cati eltoc quej se hueyi cuetaxti ten iniijhuiyo chivojme elis 13 metros huan tajco ihuehueyaca, huan ome metro ipatajca. Nochi nopa 11 cortinas monequi elis san se ihuejhuexca. ");
INSERT INTO nchBl_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Huan anquisalose macuili cortinas san sejco, huan iyoca anquisalose nopa seyoc chicuase cortinas san sejco. Huan quema anajsitij ipan nopa chicuasempa cortina, xijhuilpachoca para anquihuiyonise iixmelac nopa yoyon tiopamit campa ticalaquis. ");
INSERT INTO nchBl_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Huan nojquiya ipan iteno nopa cortinas, xijchihuilica 50 tailpili, sese ica itzojhuaso. Xijchihuaca 50 tailpili ica itzojhuaso ipan se cortina, huan ipan ne se san se xijchihua, 50 tailpili sese ica itzojhuaso. Huan moixnamiquise nopa achtohui tasaloli cortinas huan nopa seyoc tasaloli cortinas itejteno campa itzojhuaso. ");
INSERT INTO nchBl_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Huan nojquiya xijchihua 50 tepos chijcoli ten senquisa bronce cati ica quisojsos itzojhuaso nopa 50 tailpili ipan iteno se cortina ica itzojhuaso nopa 50 tailpili ipan iteno seyoc cortina, huan quej nopa elis san se itzontzajca quej se hueyi cuetaxti. ");
INSERT INTO nchBl_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Huan tajco se cortina mocahuas cuapilijtos iica nopa tiopamit huan seyoc tajco iixpa. ");
INSERT INTO nchBl_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Huan nopa yoyomit cati mocahuas cuapilijtoc oncac quitzacuas nopa tiopamit. Tajco metro cuapilijtos se lado huan seyoc tajco metro cati cuapilijtos seyoc lado ten nopa tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“Huan nojquiya tijchihuilis seyoc itzontzajca para yas iixco nopa itzontzajca cati eltoc quej se hueyi cuetaxti. Huan ya ni tijchihuas ica inincuetaxo borregojme cati quipiyaj se xihuit huan tijpas inincuetaxo ica chichiltic. Huan nopa najpa itzontzajca, xijchihua ica inincuetaxo pesojme huan quitzacuas nopa itzontzajca cati tachijchihuali ica borregojme inincuetaxo. ");
INSERT INTO nchBl_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Huan nojquiya xijchihuaca nopa huapalme cati moquetztos xitahuac para mochihuas nopa caltepamit ten nopa tiopamit. Xijchihuaca nopa huapalme ica acacia cuahuit. ");
INSERT INTO nchBl_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Huan nochi huapalme monequi elis nahui metro huan tajco ihuehueyaca, huan 65 centímetros ipatajca. ");
INSERT INTO nchBl_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Huan sesen huapali quihuicas ome imax cati huelis calaquis ipan seyoc huapali cati moquetza inechca. Xijchihua nopa huapalme para nopa yoyon tiopamit quej ni. ");
INSERT INTO nchBl_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Xijchihua 20 huapalme cati motequihuis ipan nopa caltepamit cati eltoc ica sur. ");
INSERT INTO nchBl_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Huan xijchihua 40 icuatetonyo ten senquisa plata, huan nopa 20 huapalme calaquis ininpani para moquetzas xitahuac. Sese huapali monequi quipiyas ome icuatetonyo tatzinta para nopa ome imax. ");
INSERT INTO nchBl_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","“Huan nopa caltepamit cati eltoc ica norte ipan nopa yoyon tiopamit nojquiya quipiyas 20 huapalme. ");
INSERT INTO nchBl_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Huan quipiyas 40 icuatetonyo ten plata. Ome icuatetonyo mocahuas tatzinta se huapali huan se ipan sese imax. ");
INSERT INTO nchBl_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Huan para iica nopa tiopamit campa temo tonati xijchihuili chicuase huapalme. ");
INSERT INTO nchBl_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Nojquiya xijchihuili ome huapalme para yas iica nopa tiopamit oncac ipan iesquina. ");
INSERT INTO nchBl_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Nopa huapalme cati yas calesquina, monequi tatzquis ica tepos chijcoli tatzinta huan huejcapa. ");
INSERT INTO nchBl_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Huajca para iica oncas chicueyi huapalme huan 16 icuatetonyo ten plata, ome icuatetonyo para sesen huapali. ");
INSERT INTO nchBl_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Nojquiya xijchihua cuaixtapali ten cuahuit acacia. Xijchihua macuili cuaixtapali para nopa huapalme ipan se caltepamit, ");
INSERT INTO nchBl_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","huan seyoc macuili cuaixtapali para nopa huapalme ipan seyoc caltepamit. Huan xijchihua seyoc macuili para nopa huapalme cati yas campa temo tonati, iica nopa tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Huan nopa cuaixtapali cati panos tatajco ipan ihuejcapanca nopa huapalme monequi elis san se tatecti cuahuit huehueyac cati ajsis ipan se iesquina nopa caltepamit hasta seyoc iesquina. ");
INSERT INTO nchBl_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Huan xicalaxoca nopa huapalme huan nopa cuaixtapalme ica oro, huan xijchihua nopa anillos calteno campa calaquise nopa cuaixtapalme ica senquisa oro. ");
INSERT INTO nchBl_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Huan xijquetza nopa yoyon tiopamit senquisa quej nimitznextili nica tepeixco. ");
INSERT INTO nchBl_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Nojquiya xijchihua se cortina ica lino icpat cati nelía canactzi huan icpat cati quipajtoque azultic, morado huan chichiltic. Huan quema quixinepalohua nopa yoyomit se yoyonchijquet cati cuali quimati, ma ipan quixinepalos noilhuicac ejcahua na, niamoTECO cati inintoca querubines. ");
INSERT INTO nchBl_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Huan xijpatahuas nopa cortina huan tijcuapilos ica tepos chijcolme ten oro ipan nahui taquetzalme ten cuahuit acacia cati quialaxojtoque ica oro. Huan nopa taquetzalme moquetzase ipan nahui caltetomit ten plata. ");
INSERT INTO nchBl_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Xijcuapilo nopa cortina itantita nopa tepos chijcolme. Huan iica nopa cortina xijtali nopa caxa cati quipiya notanahuatilhua. Huan ni cortina quiiyocatalis nopa achtohui cuarto campa tatzejtzeloltic ica nopa seyoc cuarto cati más calijtic cati itoca campa más tatzejtzeloltic cati quipiya nocaxa. ");
INSERT INTO nchBl_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","“Huan ipan nopa caxa xijtali itzajca campa nimechtasojtas quema antechixtzacuilise amotajtacolhua. ");
INSERT INTO nchBl_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Huan ipan nopa achtohui cuarto cati más calteno quema ayemo ticajsi campa nopa cortina, xijtali nopa cuamesa ica norte. Huan ipan nopa cuarto ica sur, xijtali nopa taahuil quetzali iixmelac nopa cuamesa. ");
INSERT INTO nchBl_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Huan para campa ticalaquis ipan nopa achtohui cuarto ipan yoyon tiopamit, xijchihua se cortina cati taxinepaloli ica lino icpat nelcanactzi huan ihuaya icpat cati azultic, morado huan chichiltic. Ma quichihua se yoyonchijquet cati cuali quimati. ");
INSERT INTO nchBl_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Huan nojquiya ni cortina xijcuapilo ica tepos chijcoli cati senquisa oro ipan macuili taquetzali ten cuahuit acacia cati tiquixaltis ica oro. Huan xijchihua macuili icuatetonyo ten bronce cati yas tatzinta ten nopa macuili taquetzalme. ");
INSERT INTO nchBl_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Xijchihua se taixpamit ica cuahuit cati itoca acacia. Huan elis cuadrado ica 2 metros huan 25 centímetros ihuehueyaca huan ipatajca, huan quipiyas 1 metro huan 25 centímetros ihuejcapanca. ");
INSERT INTO nchBl_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Huan ipan najcac iesquinajyo xijchihuili nahui icuacua cati san se inihuejhuexca. Xijchihua ica san se tatecti cuahuit huan xicalaxo ica nopa teposti bronce. ");
INSERT INTO nchBl_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Nojquiya xijchihuili nochi cati quitequihuise nopona. Xijchihuili cati ipan quitemase cuajnexti, huan itepos palas, huan nopa huajcali para quiselis esti, huan nopa tepos chijcoli para ica quiitzquise nopa nacat, huan nopa teposti para ticoli. Huan nochi tijchihuas ica bronce. ");
INSERT INTO nchBl_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Huan xijchijchihuili se tixicti ten bronce ica ivarillas. Xijtalili se anillo ipan sese inacasta para ica tijquixtis. ");
INSERT INTO nchBl_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Huan xijsehui nopa tixicti ipan nopa iteno cati mocahua tatajco ten nopa taixpamit, pampa ya nopa para ipan mosehuis tixicti campa oncas tit. ");
INSERT INTO nchBl_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Nojquiya xijchihua cuahuit huehueyac para nopa taixpamit para ica anquihuicase. Xijchihua ica cuahuit acacia huan xiquixalti ica bronce. ");
INSERT INTO nchBl_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Huan nopa cuahuit huehueyac cati anquisencahuase, xijcalaqui ipan ome lados ten nopa taixpamit ipan nopa anillos para huelis anquihuicase. ");
INSERT INTO nchBl_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Xijchihua nopa taixpamit ica huapalme, huan ma mocahua ijticacahuaxtic campa tipitzase. Huan xijchihua nochi senquisa quej nimitznextili nica ipan ni tepet. ");
INSERT INTO nchBl_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Nojquiya tijchihuilis cati elis quej se calixpamit cati quiyahualos nopa yoyon tiopamit. Huan xijchihuili se tatzacti ten cortinas ten lino yoyomit. Huan ihuehueyaca nopa lado ica sur elis 45 metros. ");
INSERT INTO nchBl_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Huan ipan nopa lado quipiyas 20 itaquetzalo cati moquetzas ipan 20 inincuatetonyo ten nopa teposti bronce. Huan xijtatacatzos nochi nopa taquetzali ica plata cati quipiya se ianillo. Huan nojquiya xijchihua tepos chijcoli ica plata para ica tijtatzquiltis nopa anillos ipan taquetzali ica nopa icuatetonyohua. ");
INSERT INTO nchBl_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Nopa tatzacti ten cortinas ica norte elis san se, 45 metros ihuehueyaca. Huan xijcuapilo nopa cortinas ipan 20 taquetzalme cati tijtatacatzos ica plata cati quipiya se ianillo, huan nopa taquetzali moquetzas ipan 20 cuatetomit. Huan nopa tepos chijcoli nojquiya xijchihua ica plata. ");
INSERT INTO nchBl_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Huan nopa cortinas cati quitzacuas iica nopa yoyon tiopamit campa huetzi tonati quipiyas 22 metros huan tajco ihuehueyaca. Huan xijcuapilo ipan 10 taquetzali cati moquetzas ipan 10 cuatetomit. ");
INSERT INTO nchBl_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Huan iixmelac nopa yoyon tiopamit campa quisa tonati, nojquiya tijpatahuas cortinas cati ihuehueyaca 22 metros huan tajco. ");
INSERT INTO nchBl_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Huan oncas cortinas ipan sesen lado campa tapojtoc para calaquise. Ipan se lado nopa cortinas quipiyase 7 metros huan quicuapilose ipan eyi taquetzali cati moquetzas ipan eyi cuatetomit. ");
INSERT INTO nchBl_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Huan ipan ne seyoc lado nojquiya nopa cortina quipiyas 7 metros huan quicuapilojtose ipan eyi taquetzali cati moquetzas ipan eyi cuatetomit. ");
INSERT INTO nchBl_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Huan tatajco, campa tapojtoc para calaquise, xijtali se cortina cati quipiyas 9 metros ihuehueyaca. Huan xijcuapilo nopa cortina ipan nahui taquetzali cati moquetzas ipan nahui cuatetomit. Huan nopa cortinas campa ancalaquise monequi elis taxinepaloli ica lino icpat cati nelía canactzi ihuaya icpat cati azultic, morado huan chichiltic. Huan quixinepalos se cati tahuel quimati. ");
INSERT INTO nchBl_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Huan tiquinalaxos ica plata nochi nopa taquetzalme ipan nopa tatzacti ten cortinas yahualtic ten nopa calixpamit. Huan xijtatacatzos sesen taquetzali ica se tatecti plata cati quipiya ianillo. Nojquiya nopa taquetzalme quipiyas tepos chijcolme ten plata, huan icuatetonyo ten bronce. ");
INSERT INTO nchBl_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Huan nopa tatzacti cati quitzacuas nopa calixpamit cati quiyahualohua nopa yoyon tiopamit quipiyas 45 metros ihuehueyaca, huan 22 metros huan tajco ipatajca. Huan nopa tatzacti ten cortinas quipiyas 2 metros huan 25 centímetros ihuejcapanca. Huan nopa cortinas xijchihua ica lino tamalinti nelcanactzi. ");
INSERT INTO nchBl_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Nochi tamantzitzi cati quitequihuise ipan nopa tequit tiopan calijtic huan nochi tepos chijcolme para ipan quicuapilose nopa tamantzitzi elis ten bronce. Huan nopa estacas para nopa yoyon tiopamit huan nopa tatzacti ten cortinas monequi xijchihua ica bronce. ");
INSERT INTO nchBl_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Huan xiquinnahuati nopa israelitame ma quihualicaca aceite cati más cuali cati quisa quema quitisij olivos. Huan anquitequihuise para nopa taahuili nochipa tatatos. ");
INSERT INTO nchBl_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Huan nopa taahuil quetzali anquiquetzase ipan nopa achtohui cuarto ipan nopa yoyon tiopamit campa timopantise. Nopa cuarto eltoc iixmelac nopa cortina cati quitzacua campa mocahua nopa caxa ipan nopa cuarto campa más tatzejtzeloltic. Huan Aarón huan itelpocahua quitatise nopa taahuili noixpa, na niamoTECO, sesen tiotac huan tatatos hasta ica ijnaloc. Huan ni tanahuatili monequi quichihuase israelitame huan iniixhuihua ama huan teipa. ");
INSERT INTO nchBl_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Xijnotza ma huala moicni Aarón huan itelpocahua Nadab, Abiú, Eleazar huan Itamar para huelis tiquiniyocatalis para na. Pampa niquintapejpenijtoc ipan nochi israelitame para ma elica totajtzitzi cati techtequipanose. ");
INSERT INTO nchBl_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Huan xijchihuili moicni Aarón iyoyo cati tatzejtzeloltic para ica techtequipanos. Huan iyoyo monequi elis nelía yejyectzi para nochi quitepanitase pampa quej nopa quinamiqui ihueyitilis nopa hueyi tequit cati quichihuas noixpa. ");
INSERT INTO nchBl_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Huan nochi masehualme cati talnamiquij para quisencahuas se tamanti huan cati niquinmacatoc yajatili, xiquinilhui ma hualaca para quichihuaquij iyoyo Aarón cati quinextis para yaya itztoc iyoca ten sequinoc totajtzitzi, pampa yaya elis nototajtzi para techtequipanos. ");
INSERT INTO nchBl_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","“Huan ya ni nopa yoyomit cati monequi quichihuilise Aarón para moquentis: iyolixtzajca, ipantzajca cati amo quipiya imancax, iyoyo cati huehueyac, ipaniyoyo cati yejyectzi tajtzonti, icuatzajca huan itzinquechilpica. Ma quichihuaca ni yoyomit para moicni Aarón huan nojquiya ma quinchihuilica iniyoyo itelpocahua para huelis techtequipanose quej nototajtzitzi. ");
INSERT INTO nchBl_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Huan cati quipiyaj talnamiquilisti quichihuase iniyoyo ica piltepos mecatzitzi ten oro huan ica icpat cati azultic, morado, huan chichiltic, huan quixinepalose ica lino icpat cati tamalinti nelía canactzi. ");
INSERT INTO nchBl_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Huan quichihuase nopa ixpantzajcayot ica miyac piltajco ilpicayotzitzi cati taxinepaloli ten oro cati nelcanactzi, huan icpat cati azultic, morado huan chichiltic, huan ica lino icpat tamalinti nelcanactzi. Huan monequi quichihuase masehualme cati nelía cuali quimatij. ");
INSERT INTO nchBl_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Monequi iixpantzajcayo elis ome tatecti ten yoyomit cati moixnamiquis iajcoltipa, huan iyolixco huan iica mocahuas se iyoyo. ");
INSERT INTO nchBl_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Huan iixpantzajcayo huan itzinquechilpica monequi elis ten san se taxinepaloli yoyomit. Huan itzinquechilpica ica cati quiilpis iyoyo elis yejyectzi tachijchihuali. Xijxinepaloca nopa yoyomit ica ipiltajco ilpicayo cati taxinepaloli ica oro cati canactzi, huan icpat ten lino cati tamalinti nelía canactzi, huan icpat cati quipajtoque azultic, morado huan chichiltic. ");
INSERT INTO nchBl_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Huan xijcui ome piltetzitzi cati itoca ónice huan ipani xijtejtequi huan xiquijcuilo inintoca nochi itelpocahua Israel. ");
INSERT INTO nchBl_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Chicuase inintoca xijtejtequi ipan se tet huan chicuase ipan seyoc tet. Huan xiquijcuilo inintoca quej tacajtiyajque. ");
INSERT INTO nchBl_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Quema quitalise nopa tocayot ipan nopa tet, monequi quitejtequise quej elisquía se sello. Huajca nopa ome teme quipiyase nochi inintoca itelpocahua Israel. Huan itejteno sesen tet xijchihua ipiltencuayo ten senquisa oro. ");
INSERT INTO nchBl_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Huan xijtali nopa ome tet iajcoltipa nopa ixpantzajcayot para nopa totajtzi nochipa quihuicas inintoca iajcolpa para ma techelnamiquiltijtinemi na, niamoTECO ten itelpocahua Israel. ");
INSERT INTO nchBl_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Huan xijtatzquiltis nopa piltetzitzi ipan oro. ");
INSERT INTO nchBl_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Huan xijchihua ome piltajco ilpicayotzitzi cati taxinepaloli ten oro cati nelía canactzi. Huan nopa piltajco ilpicayotzitzi quitatzquiltise ipan ipiltencuayohua nopa teme ten ónice cati quihuica iajcoltipa. ");
INSERT INTO nchBl_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Teipa ica yolic, xijchihuaca nopa yolixtzajcayot cati quipiyas cati amechnextilis taya nopaquilis na, niamoTECO Dios. Huan xijtequihui nopa piltepos mecatzitzi ten oro, huan lino icpat tamalinti nelcanactzi, huan icpat cati quipajtoque azultic, morado huan chichiltic quej tijtequihui ipan nopa ixpantzajcayot. ");
INSERT INTO nchBl_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Monequi tijcuilpachos para tijchihuas se bolsa cati ome panti. Ihuehueyaca huan ipatajca nopa bolsa elis 22 centímetros huan tajco, pampa cuadrado. ");
INSERT INTO nchBl_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Huan iixpa xijtatzquiltili nahui pamit ten piltetzitzi cati yejyectzitzi. Ipan nopa achtohui pamit xijtatzquiltili se piltetzi cati itoca rubí, se topacio huan se sardónice. Ya ni elis nopa achtohui pamit. ");
INSERT INTO nchBl_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Ipan nopa ompa pamit, xijtatzquiltili se esmeralda, se zafiro huan se diamante. ");
INSERT INTO nchBl_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Huan ipan nopa expa pamit xijtatzquiltili se jacinto, se ágata huan se amatista. ");
INSERT INTO nchBl_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Huan ipan nopa najpa pamit xijtatzquiltili se berilo, se ónice huan se jaspe. Nochi ni piltetzitzi monequi tatzquitose ipan ininpiltencuayohua ten oro cati mocahuas inintejteno. ");
INSERT INTO nchBl_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Huan imiyaca nopa piltetzitzi monequi elis quej imiyaca itelpocahua Israel, doce. Huan sesen piltetzi quinescayotis se itelpoca Israel huan anquitejtequise ipan sesen tet quej se pilsellojtzi cati quipiyas itoca se itelpoca Israel. ");
INSERT INTO nchBl_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Huan para quitatacatzos nopa yolixtzajcayot ipan nopa ixpantzajcayot, xijchihuili piltajco ilpicayotzitzi cati taxinepaloli ica piltepos mecatzitzi cati canactzi huan senquisa oro. ");
INSERT INTO nchBl_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Huan teipa xijchihua ome anillo ten oro, se ipan sesen iesquinajyo ica huejcapa ipan nopa yolixtzajcayot. ");
INSERT INTO nchBl_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Nopa ome piltajco ilpicayotzitzi panose ipan nopa ome anillo cati eltoc iajcoltipa nopa ixpantzajcayot. Quej nopa xijtatzquiltis nopa yolixtzajcayot ica nopa ixpantzajcayot. ");
INSERT INTO nchBl_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Nojquiya iniyacapa nopa piltajco ilpicayotzitzi moilpise ipan nopa anillos cati eltoc iajcoltipa nopa ixpantzajcayot. ");
INSERT INTO nchBl_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Teipa xijchihua seyoc ome anillo ten oro huan xiquintatacatzo nopa ome esquinas cati tatzinta ipan nopa yolixtzajcayot, pero xiquintatacatzos nopa ome anillos tatzinta ten nopa yolixtzajcayot campa moteca ipan cati quipantzacua. ");
INSERT INTO nchBl_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Huan teipa xijchihua seyoc ome anillos ipan nopa ixpantzajcayot, se ipan sesen lado iijtic nechca itzinquechilpica. ");
INSERT INTO nchBl_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Huan teipa xiquilpi nopa anillos cati tatzinta ipan nopa yolixtzajcayot ipan ni anillos ipan nopa ixpantzajcayot ica se listoj azultic para nopa yolixtzajcayot ma motali huan ma mocahua cuali ipan nopa ixpantzajcayot campa itajcoya huan amo papatacas. ");
INSERT INTO nchBl_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Huan yeca quema Aarón calaquis campa tatzejtzeloltic nochipa huelis quihuicas inintoca itelpocahua Israel iyolixco ipan nopa iyolixtzajcayo huan techelnamiquiltis na, niamoTECO, ten inijuanti. ");
INSERT INTO nchBl_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","“Huan iijtic nopa yolixtzajcayot campa ibolsa, xijtali nopa Urim huan nopa Tumim, nopa dados tatzejtzeloltic ten na, niamoTECO, cati anquitequihuise quema anisraelitame monequis anquimatise ‘quena’ nopaquilis se tamanti, o ‘amo’. Huan Aarón quihuicas iyolixco nopa Urim huan Tumim, nopa dados tatzejtzeloltic ten na, niamoTECO quema calaquis noixpa. ");
INSERT INTO nchBl_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Huan xijchihua iyoyo huehueyac cati senquisa azultic cati moquentis itantita nopa ixpantzajcayot. ");
INSERT INTO nchBl_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Huan monequi xijquechtequis campa calaquis itzonteco nopa totajtzi. Huan campa quiquechtequise monequi quihuilpachose se quentzi huan quiyahualose ica icpat para mochihuas se yejyectzi tajtzonti yahualtic para amo tzayanis iquechta. ");
INSERT INTO nchBl_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Huan icuextejteno nopa iyoyo huehueyac monequi xijchihua se tajtzonti yejyectzi campa xiquixcopina nopa cuatacti granada ica icpat azultic, morado huan chichiltic para ma quiyahualo icuexteno. Huan tatajco ten nopa granadas monequi xijcuapilojtiyas pilcampanajtzitzi ten oro. ");
INSERT INTO nchBl_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Monequi elis se pilcampanajtzi ten oro huan teipa se granada tajtzonti, teipa seyoc pilcampanajtzi ten oro huan seyoc granada tajtzonti, huan quej nopa yajtiyas ipan nochi itejteno. ");
INSERT INTO nchBl_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Huan ya nopa moquentis Aarón quema techtequipanos na, niamoTECO, calijtic campa más tatzejtzeloltic. Huan quema Aarón calaquis o quisas ipan nopa cuarto tzilinis nopa pilcampanajtzitzi ten oro para amo miquis. ");
INSERT INTO nchBl_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Nojquiya xijchihua se tatecti oro cati canactzi quej se piltepos patactzi quej se credencial huan ipan xijtejtequi se tajcuiloli quej campa quichihuaj se sello huan quiijtos: TAIYOCATALILI PARA TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Huan xiquilpi nopa piltepos patactzi ica se listój azultic iixpa ipan icuatzajca. ");
INSERT INTO nchBl_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Huan nopa piltepos patactzi mocahuas cuapilijtos ipan icuaixco Aarón. Huan quema nopa israelitame quiiyocatalise se tacajcahualisti para na huan quihualicase, sinta ayemo senquisa tapajpacti nopa tacajcahualisti noixpa na, niamoTECO, huajca Aarón ica nopa piltepos patactzi huelis quihuicas inintaixpanolhua cati quiajsitoque nopa tacajcahualisti. Huan huajca inon tacajcahualisti niquitas para tatzejtzeloltic huan nijselis. Yeca Aarón monequi motalilis nopa cuatzajcayot ica nopa piltepos patactzi nochipa quema calaquis tiopan calijtic noixpa. ");
INSERT INTO nchBl_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Huan ipaniyoyo nopa hueyi totajtzi xijchihuili taxinepaloli ica icpat ten lino tamalinti nelía canactzi. Huan nojquiya icuatzajca quichihuase ica lino, huan xijchihua itzinquechilpica huan ma quipiya itachijchihuayo cati yejyectzi. ");
INSERT INTO nchBl_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Huan nojquiya xiquinchihuili itelpocahua Aarón ininpaniyoyo, huan inintzinquechilpica cati yejyectzi tajtzonti huan inincuatzajca. Huan ica nopa iniyoyo yejyectzi, nochi masehualme quintepanitase. Nelía quinamiqui quipiyase inihueyitilis por nopa hueyi tequit cati quichihuase noixpa. ");
INSERT INTO nchBl_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","“Huajca ica nochi ni yoyomit xiquinyoyonti moicni Aarón huan itelpocahua. Teipa xiquinajalti aceite ipan inintzonteco huan xiquiniyocatali para na. Huan quej nopa xiquintequimaca para ma techtequipanoca quej totajtzitzi. ");
INSERT INTO nchBl_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Huan nojquiya xiquinchihuili inintatzintayoyo ica nopa cuali yoyomit lino para ma motalilica tatzinta ten nopa sequinoc iniyoyo. Huan quintzacuas ten inintzinquechta hasta ininquescuayotipa. ");
INSERT INTO nchBl_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Huan Aarón huan itelpocahua monequi moquentise quema calaquise tiopan calijtic para techtequipanose, o quema monechcahuise campa nopa taixpamit ipan nopa cuarto campa tatzejtzeloltic. Huan sinta moquentise cati nimechilhuía, amo motajtacoltise huan miquise. Ni tanahuatilme elis para Aarón huan itelpocahua para nochipa. ");
INSERT INTO nchBl_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Huan ya ni cati monequi xijchihua para tiquiyocatalis Aarón huan itelpocahua para ma elica nototajtzitzi. Xijcui se becerro huan ome oquich borregojme cati nelía cuajcualme huan amo teno amo cuali quipiyaj. ");
INSERT INTO nchBl_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Huan ica harina ten trigo cati amo quipiya tasonejcayot, xijchihua pantzi. Huan nojquiya xijchihua tortas cati quipiya aceite. Huan xijchihua seyoc pantzi cati nesis quej taxcali huactoc cati tiquixajalos ica aceite. ");
INSERT INTO nchBl_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Huan xijtema nochi ni pantzi ipan se chiquihuit, huan techmaca na niamoTeco ipan taixpamit ica nopa becerro huan nopa ome oquich borregojme. ");
INSERT INTO nchBl_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Huan xijhualica Aarón huan itelpocahua ipan icalixpa nopa yoyon tiopamit campa timopantise nechca campa calaquise, huan nopona xiquinpajpacas ica at. ");
INSERT INTO nchBl_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","“Huan xijcui nopa yejyectzi yoyomit cati anquisencahuilijtoque huan xijyoyonti Aarón ica nopa ixpantzajcayot, nopa yolixtzajcayot, huan ica ipaniyoyo. Huan xiquilpi nopa ixpantzajcayot ica nopa tajco ilpicayot. ");
INSERT INTO nchBl_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Huan xijtalis ipan itzonteco nopa cuatzajcayot. Huan ipan nopa cuatzajcayot xijtali nopa piltepos patactzi ten oro cati quiijtohua: TAIYOCATALILI PARA TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Huan xijcuis nopa aceite para tiquinajaltis masehualme huan tamanti para tiquiniyocatalis para na, niamoTECO, huan ticajaltis ipan itzonteco Aarón para tiquiyocatalis para techtequipanos na, niamoTeco. ");
INSERT INTO nchBl_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Huan xiquinhualica itelpocahua huan xiquinyoyonti ica nopa yoyomit cati anquichijque para inijuanti. ");
INSERT INTO nchBl_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Huan xiquintajcoilpi huan xiquintalili inincuatzajca, huan inijuanti quiselise nopa tequit ica nochi nopa tanahuatili huan elise totajtzitzi noixpa para nochipa. Quej ni, huajca xiquiniyocatali Aarón huan itelpocahua. ");
INSERT INTO nchBl_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Xijhuica nopa becerro iixpa nopa yoyon tiopamit, huan Aarón huan itelpocahua ma quitalica inimax ipan itzonteco nopa becerro. ");
INSERT INTO nchBl_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Teipa xijmicti nopa becerro noixpa na, niamoTECO, ipan nopa calixpamit nechca icalte campa calaquise ipan nopa yoyon tiopamit campa timopantise. ");
INSERT INTO nchBl_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Huan xijcui se quentzi ieso nopa becerro huan xijtali ica momacpil ipan nochi nahui icuacua nopa taixpamit campa quitatise tacajcahualisti. Huan nopa esti cati mocahuas, xijtoyahua nechca itzinta nopa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Teipa xijcui nochi nopa tachiyajcayot cati eltoc ipan icuetaxcol nopa becerro, huan cati eltoc ipan ieltapach huan nopa ome ieyo, huan nochi nopa tachiyajcayot cati eltoc ipan ieyo, huan xijtati ipan nopa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Pero inacayo nopa becerro, ica icuetaxo huan icuit, xijhuica huejca, campa amo onca calme huan xijtatiti. Huan ni becerro elis se tacajcahualisti para tajtacoli. ");
INSERT INTO nchBl_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Huan nojquiya xijcui se ten nopa oquich borregojme, huan Aarón ihuaya itelpocahua ma quitalica inimax ipan itzonteco. ");
INSERT INTO nchBl_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Huan xijmicti nopa oquich chivo huan ieso xijtzejtzelo yahualtic taixpamit ipan iquesta. ");
INSERT INTO nchBl_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Huan inacayo nopa oquich borrego, xijhuejhuelos. Huan xijpajpaca icuetaxcol huan imetz, huan xijtencahua ipan taixpamit ihuaya itzonteco huan nopa sequij cati tijhuejhuelojtoc. ");
INSERT INTO nchBl_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Huan xijtatis nochi nopa oquich borrego ipan nopa taixpamit. Huan ya ni elis se tacajcahualisti tatatili para na, niamoTECO. Huan nelía ajhuiyac mijyotis huan techpactis, pampa elis se tacajcahualisti tatatili cati antechmacaj ica tit. ");
INSERT INTO nchBl_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Teipa xijcui nopa seyoc oquich borrego, huan Aarón huan itelpocahua quitalise inimax ipan itzonteco. ");
INSERT INTO nchBl_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Huan xijmicti nopa oquich borrego, huan xijcui quentzi ieso huan xijpolo itzinta ininacas cati ininejmat Aarón huan itelpocahua. Nojquiya xijpolo quentzi nopa esti ipan inihueyi majpil huan inihueyi xojpil cati ininejmat. Huan xijtzejtzelo nopa esti yahualtic itejteno nopa taixpamit campa Quitatise Tacajcahualisti campa iquejquesta. ");
INSERT INTO nchBl_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Huan xijcui quentzi ten nopa esti ipan taixpamit huan quentzi nopa aceite cati ica titaiyocatalía, huan xiquijtzelo ipan Aarón huan ipan iyoyo, huan ipan itelpocahua huan ipan iniyoyo nojquiya. Huan ica ya nopa Aarón huan itelpocahua huan iniyoyo elis tatzejtzeloltic huan taiyocatalili para na, niamoTeco. ");
INSERT INTO nchBl_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Teipa xijquixtili ichiyajca nopa oquich borrego. Xijcui nopa tachiyajcayot campa icuitapil, icuetaxcol huan ieltapach. Huan xijcui nopa ome ieyo huan ininchiyajca, huan nopa imetz ten inejmat, pampa ica nopa tacajcahualisti ten nopa oquich borrego tiquintequitalis Aarón huan itelpocahua para techtequipanose. ");
INSERT INTO nchBl_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Nojquiya xijcui se pantzi ten nopa chiquihuit cati quipiya pantzi cati amo quipiya tasonejcayot cati eltoc noixpa na, niamoTECO. Huan nojquiya xijcui se torta cati quipiya aceite huan se ten nopa seyoc pantzi cati nesi quej taxcali huactoc cati anquiixajalojtoque aceite. ");
INSERT INTO nchBl_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Huan nochi ni pantzi huan ichiyajca nopa borrego, xijtali imaco Aarón huan inimaco itelpocahua. Huan inijuanti quihuisose noixpa, niamoTECO, pampa ya nopa elis se tacajcahualisti cati anquihuisose noixpa para antechmacase. ");
INSERT INTO nchBl_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Teipa xijcui ten inimax nochi cati quihuisojque noixpa huan xijtali ipan nopa taixpamit noixpa quej se tacajcahualisti tatatili. Huan nopa tacajcahualisti mijyotis ajhuiyac huan techpactis na niamoTECO. Ya ni elis se tacajcahualisti tatatili cati antechmacaj ipan tit. ");
INSERT INTO nchBl_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“Huan teipa xijcui iyolix nopa oquich borrego cati ica tijtequitalía Aarón para techtequipanos, huan xijhuisos noixpa, nimoTECO, huan teipa nopa iyolix elis para ta, Moisés. ");
INSERT INTO nchBl_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Huan nochipa quema tiquiniyocatalis tacame para ma elica totajtzitzi, Aarón huan itelpocahua quiselise iyolix huan imetz nopa borrego cati quihuisojque noixpa para techmacase. ");
INSERT INTO nchBl_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Quena, ya ni elis se tanahuatili para nochipa para xiquinmaca Aarón huan itelpocahua iyolix huan imetz se tacajcahualisti. Amo quema ma quielcahuaca israelitame para quinmacase ni nacat nopa totajtzitzi, masque temacaj se tacajcahualisti para moyoltalise nohuaya, niamoTECO, o temacaj se tacajcahualisti para techtascamatilise. Ya ni quinamiqui quiselise totajtzitzi para iniaxca. ");
INSERT INTO nchBl_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Huan nochi ni iyoyo Aarón cati tatzejtzeloltic teipa elis para nopa itelpoca cati quitoquilis ipan itequi quej nopa hueyi totajtzi cati más quipiya tequiticayot. Huan quej nopa, ni yoyomit panos ten se itelpoca hasta se iixhui, huan hasta se iixhui itelpoca. Sesen cati quiselis ni tequit para elis hueyi totajtzi cati ama quiselía Aarón, nojquiya quiselis ni yoyomit cati ihuaya yahui ni tequit. Quiselise quema quiiyocatalise sese ica aceite para quitequitalise para techtequipanos, niamoTeco. ");
INSERT INTO nchBl_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Huan nopa itelpoca Aarón cati quiselis itequi teipa, monequi moquentis ni yoyomit tatzejtzeloltic para chicome tonati, huan teipa quena, hueli pehuas tequitis ipan nopa achtohui cuarto campa tatzejtzeloltic. ");
INSERT INTO nchBl_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Huan xijcui inacayo nopa oquich borrego cati tijtequihuijtoc para tiquiniyocatalis Aarón huan itelpocahua, huan xijcacatzo campa tapajpacti noixpa na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Huan Aarón huan itelpocahua quicuase inacayo nopa oquich borrego ihuaya nopa pantzi cati eltos ipan nopa chiquihuit ipan calixpamit nechca campa calaquise ipan nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Quena, san inijuanti huelis quicuase ni tacajcahualisti cati tijtequihui quema tiquiniyocatali para ma techtequipanoca na, niamoTECO. Amo aqui más hueli quicuas, san inijuanti, pampa nopa nacat huan nopa pantzi taiyocatalili, huan tatzejtzeloltic para na. ");
INSERT INTO nchBl_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Huan sinta mocahuas quentzi pantzi o quentzi nacat hasta tonilis, monequi xijtatis, ayecmo huelis quicuase pampa taiyocatalili para na. ");
INSERT INTO nchBl_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Huajca para chicome tonati tiquinchihuilijtiyas Aarón huan itelpocahua nochi cati nimitznahuatía para xiquiniyocatali ma techtequipanoca. ");
INSERT INTO nchBl_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Ipan sesen tonali techmaca, niamoTECO, se becerro quej se tacajcahualisti para techixtzacuilis inintajtacolhua. Nojquiya xijpajpaca nopa taixpamit noixpa ica se tacajcahualisti cati anquitencahuase ipani. Mojmosta xicalti nopa taixpamit ica aceite para tiquiyocacahuas para na, niamoTeco. ");
INSERT INTO nchBl_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Para chicome tonati xijtencahua tacajcahualisti huan xijpajpaca nopa taixpamit para elis tahuel tatzejtzeloltic, huan nochi cati quiajsis nopa taixpamit elis tatzejtzeloltic, taiyocatalili para na. ");
INSERT INTO nchBl_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Huan teipa mojmosta xiquintencahua ipan nopa taixpamit ome pilborregojtzitzi cati quipiyaj sese xihuit. ");
INSERT INTO nchBl_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Xijtencahua se pilborregojtzi ica ijnaloc, huan se pilborregojtzi techmaca quema calaquiti tonati. ");
INSERT INTO nchBl_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Huan ica nopa pilborregojtzi ica ijnaloc, xijtencahua ome litros huan tajco harina cati más cuali taxacualoli ica se litro aceite cati tatejtejtzonti ten olivos. Huan nojquiya xijtecas ipan taixpamit se litro xocomecat iayo. Ya nopa elis se tacajcahualisti cati quitoyahuase para techmacase. ");
INSERT INTO nchBl_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Huan ne seyoc pilborregojtzi techmaca, niamoTECO, ica tiotac quema oncalaqui tonati. Huan nojquiya ma techmacaca nopa harina quej quichijque ica nopa tacajcahualisti cati ica ijnaloc, huan ma techmacaca xocomecat iayo quej quitoyajque ipan taixpamit ijnaloc. Huan ya ni elis se tacajcahualisti para na cati antechmacase ipan tit huan mijyotis ajhuiyac huan techpactis. ");
INSERT INTO nchBl_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ya ni elis nopa ome tacajcahualisti cati monequi anquichihuase mojmosta para ama huan teipa. Huan anquitencahuase noixpa na, niamoTECO, ni tacajcahualisti ipan nopa taixpamit campa tatatise ipan nopa calixpamit nechca campa icalte nopa yoyon tiopamit campa timopantise. Huan nopona nimechcamanalhuis. ");
INSERT INTO nchBl_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Quena, nopona nojquiya niquinnamiquis nopa israelitame. Huan nopa yoyon tiopamit elis tatzejtzeloltic pampa quipiyas notatanex. ");
INSERT INTO nchBl_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Huajca niquiyocatalis para na nopa tiopamit campa timopantise, huan nopa taixpamit campa tatatise. Huan niquiniyocatalis Aarón huan itelpocahua para ma elica nototajtzitzi huan nochi elise tatzejtzeloltique. ");
INSERT INTO nchBl_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Huan na nimocahuas para niitztos tatajco israelitame huan na nielis niininTeco. ");
INSERT INTO nchBl_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Huan inijuanti techixmatise para na niDIOS niininTeco cati niquinquixti ipan tali Egipto para nimocahuas huan niitztos inihuaya. Quena, na niDIOS, niininTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Nojquiya xijchihua se taixpamit para ipan anquitatise copali. Xijchihua ica nopa cuahuit cati itoca acacia. ");
INSERT INTO nchBl_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Huan ihuehueyaca iixpa monequi elis 45 centímetros huan ipatajca nojquiya 45 centímetros para elis cuadrado, huan ihuejcapanca elis 90 centímetros. Huan iixco nopa taixpamit huan icuacua monequi elis san se tatecti cuahuit. ");
INSERT INTO nchBl_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Huan tiquixaltis ica oro ipani, huan ipan iquespa huan icuacua. Xijchihuili se icorona itejteno cati senquisa oro. ");
INSERT INTO nchBl_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Nojquiya xijchihuili nahui anillo ten oro, ome ipan se lado campa inacasta huan ne ome ipan seyoc inacasta. Huan ipan nopa anillos anquicalaquise nopa cuahuit huehueyac para ica anquihuicase. ");
INSERT INTO nchBl_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Huan xijchihua nopa huehueyac cuahuit ica nopa cuahuit cati itoca acacia, huan xiquixalti ica oro. ");
INSERT INTO nchBl_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Huan ipan nopa achtohui cuarto campa tatzejtzeloltic, xijtali ni taixpamit para copali. Xijquetza ni taixpamit iixmelac nopa cortina cati quitzacua nopa cuarto campa más tatzejtzeloltic campa eltoc nopa caxa ica nopa tanahuatili huan itzajca campa timopantise. ");
INSERT INTO nchBl_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Huan sese ijnaloc quema ajsis hora para Aarón quitejtequis imecha nopa taahuili, monequi quitatis copali cati ajhuiyac ipan nopa taixpamit para copali. ");
INSERT INTO nchBl_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Huan nojquiya mojmosta ica tapoyahui quema Aarón quinsencahua huan quintatis nopa taahuilme, quitatis copali noixpa na, niamoTECO. Quej nopa oncas copali cati tatas noixpa mojmosta para nochipa hasta amoixhuihua quipiyase iniixhuihua. ");
INSERT INTO nchBl_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ipan nopa taixpamit para copali, amo xijtati seyoc tamanti copali, yon amo xiquintali tapiyalme para tatase. Amo xijtali tacajcahualisti ten harina, yon amo xijtoyahua ipani nopa tacajcahualisti cati monequi tijtoyahuas. ");
INSERT INTO nchBl_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Huan se huelta ipan se xihuit Aarón quitapajpacchihuas nopa taixpamit para copali quema quitalis ipan icuacua se quentzi ieso nopa tacajcahualisti para techixtzacuilis amotajtacolhua. Huan amoixhuihua huan iniixhuihua quej ni nojquiya quichihuase ipan ni taixpamit para copali se huelta ipan se xihuit. Ni taixpamit para copali nelía tatzejtzeloltic para na niamoTECO.” ");
INSERT INTO nchBl_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Huan TOTECO nojquiya quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Quema tijchihua se censo para tiquinpohuas nopa israelitame, sesen monequi quitaxtahuis TOTECO para quimanahuis inemilis. Quej nopa monequi para amo aqui miquis pampa tiquinpohua. ");
INSERT INTO nchBl_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Quema mopohuase, sesen masehuali monequi temacas se plata tomi cati quipiya chicuase gramos ietica huan ya nopa elis se tacajcahualisti para na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Quena, nochi cati ya quiaxitijtoque 20 xihuit, monequi moijcuilose huan monequi temacase nopa tomi. ");
INSERT INTO nchBl_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Yaya cati rico amo taxtahuas más, yon cati teicneltzi amo taxtahuas pilquentzi. Nochi techmacase na, niamoTECO, nopa plata tomi cati quipiya chicuase gramos ietica para quimanahuise ininemilis. ");
INSERT INTO nchBl_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Huan tijcuis nopa tomi cati temacatose israelitame para momanahuise, huan xijtequihui ipan itequi nopa yoyon tiopamit campa timopantise. Ica ya ni, niamoTECO nimechelnamiquis huan antechixtzacuilise amotajtacolhua para huelis anitztose.” ");
INSERT INTO nchBl_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Nojquiya xijchihua se hueyi paila ica nopa teposti bronce para ipan momajtequise totajtzitzi. Nojquiya xijchihuili ica bronce se tamanti cati ipan mosehuis nopa hueyi paila. Huan xijsehui ipan nopa calixpamit tatajco ten nopa taixpamit campa quitatise tacajcahualisti huan nopa cortina cati quitzacua nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Huan nopona momajtequise huan moicxipajpacase Aarón huan itelpocahua. ");
INSERT INTO nchBl_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Huan sesen huelta quema calaquise ipan nopa yoyon tiopamit campa timopantise, monequi momajtequise huan moicxipajpacase para amo miquise. Nojquiya quema monequis monechcahuise campa nopa taixpamit para quichihuase inintequi huan quitatise nopa tacajcahualisti cati techtencahuilise na, niininTECO, ");
INSERT INTO nchBl_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","monequi momajtequise huan moicxipajpacase para amo miquise. Huan ni tanahuatili monequi mocahuas para nochipa para Aarón, iixhuihua huan iniixhuihua quineltocase.” ");
INSERT INTO nchBl_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Huan TOTECO nojquiya quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Xijsentili ni taajhuiyacayot cati nimitzilhuía cati más cuali: Chicuase kilos cati senquisa mirra, eyi kilo canela, eyi kilo cálamo cati mijyotía ajhuiyac, ");
INSERT INTO nchBl_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","chicuase kilos cati casia huan nahui litros aceite cati itoca oliva. ");
INSERT INTO nchBl_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Huan ma quisencahua nochi ya ni se taajhuiyacachijquet cati cuali quimati itequi para ma elis nopa aceite cati tatzejtzeloltic cati tapojpohuase para ica taiyocatalise para notequi na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Huan xijtequihui ni aceite para ticajaltis nopa yoyon tiopamit campa timopantise huan nopa caxa ica nopa tanahuatili. ");
INSERT INTO nchBl_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","Nojquiya xicajalti nopa cuamesa huan nochi nopa tamantzitzi cati motequihuis nopona, huan xicajalti nopa taahuil quetzali ihuaya nochi cati motequihuis nopona, huan xicajalti nopa taixpamit para copali. ");
INSERT INTO nchBl_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Xicajalti nopa taixpamit campa quitatise tacajcahualisti huan nochi tamanti cati motequihuía nopona. Nojquiya xicajalti nopa hueyi paila ten bronce ihuaya cati ipan mosehuijtoc. ");
INSERT INTO nchBl_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Monequi tiquinajaltis para tiquiniyocatalis para na huan quej nopa nochi elis tahuel tatzejtzeloltic, huan nochi cati quiitzquise nopa tamantzitzi elise tatzejtzeloltique. ");
INSERT INTO nchBl_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Nojquiya tiquinajaltis Aarón huan itelpocahua ica aceite, huan tiquiniyocatalis para ma elica nototajtzitzi. ");
INSERT INTO nchBl_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Huan xiquinilhui nopa israelitame: ‘Ni aceite elis para taajaltise quema quiiyocatalise tamanti o masehualme para elise para TOTECO. Ni aceite anmotequilise para nochipa. ");
INSERT INTO nchBl_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Amo xijteca ipan cati hueli masehuali itacayo. Huan amo aqui ma quichihua seyoc taajhuiyacayot cati san se ica ya ni. Ni aceite tatzejtzeloltic, huan monequi anquiitase quej se tamanti tatzejtzeloltic. ");
INSERT INTO nchBl_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Sinta se acajya quisencahuas se taajhuiyacayot quej ni, o sinta se acajya quipolos se cati amo se nototajtzi, monequi anquiquixtise ten israelitame para nochipa.’ ” ");
INSERT INTO nchBl_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Nojquiya TOTECO quicamanalhui Moisés huan quiilhui: “Xijmanelo se taajhuiyacayot ica san se imiyaca tachipinti ten aceite ten resina, ten istit huan ten gálbano cati ajhuiyac mijyotía, huan nochi xijmanelo ihuaya nopa copali cati senquisa cuali. ");
INSERT INTO nchBl_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Huan ica ni tamanti ma quisencahua se copali cati senquisa cuali. Ma quimanelo nelía cuali quej quimati quichihua se taajhuiyacachijquet cati cuali quimati itequi. Huan ni copali elis tatzejtzeloltic san para na, niamoteco. ");
INSERT INTO nchBl_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Xijtijtisi cuali se quentzi ni tamaneloli hasta nelía cuechtic mocahuas, huan xijtali iixpa nopa caxa cati quipiya notanahuatil ipan nopa yoyon tiopamit campa timopantise. Huan monequi xijmatica ni tamaneloli copali eltoc tatzejtzeloltic. ");
INSERT INTO nchBl_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Amo aqui ma quichihua seyoc copali cati senquisa quej ni pampa ni tamaneloli copali eltoc tatzejtzeloltic para na niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Sinta se acajya quichihuas seyoc quej ni san para quiijnecuis, monequi anquimictise.” ");
INSERT INTO nchBl_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Huajca TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Xiquita, na nijtapejpenijtoc Bezaleel cati icone Uri huan iixhui Hur cati tacatqui ipan nopa hueyi familia ten iixhuihua Judá. ");
INSERT INTO nchBl_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Nijtemitijtoc Bezaleel ica noTonal. Huan nijmacatoc miyac yajatili huan tamachilisti para huelis quichihuas nopa yoyon tiopamit ica nochi tamanti cati monequi. ");
INSERT INTO nchBl_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Yaya cuali quimati quitejtzonas oro, plata huan bronce para quichihuas ten hueli cati monequi. ");
INSERT INTO nchBl_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Nojquiya hueli quiyejyectalis piltetzitzi cati patiyo para ma petani huan quimati quenicatza quiquejquetzas sese piltetzitzi ipan se piltencuayot para mocahuas yejyectzitzi. Nojquiya ya hueli quitejtequis cuahuit huan quiyejyectalis para nesis quej ten hueli tamanti cati tiquilhuis. ");
INSERT INTO nchBl_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Nojquiya nijtapejpenijtoc Aholiab, icone Ahisamac ipan nopa hueyi familia ten iixhuihua Dan, para elis itapalehuijca. Huan nochi sequinoc cati achi más quipiyaj inintalnamiquilis para quichihuase tamantzitzi cati yejyectzitzi, nojquiya niquinmacatoc iniyajatil para ma quichihuaca nochi cati nimitznahuatijtoc. ");
INSERT INTO nchBl_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Huajca inijuanti hueli quichihuase nopa yoyon tiopamit campa timopantise, huan nopa caxa campa eltoc notanahuatilhua, huan itzajca nopa caxa campa nimechtasojtas huan antechixtzacuilise amotajtacolhua. Nojquiya quichihuase nochi nopa tamantzitzi cati motequihuis tiopan calijtic. ");
INSERT INTO nchBl_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Quichihuase nopa cuamesa huan cati motequihuis nopona. Nojquiya quichihuase nopa taahuil quetzali cati senquisa oro ica nochi cati motequihuis ihuaya, huan quichihuase nopa taixpamit para copali. ");
INSERT INTO nchBl_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Quichihuase nopa taixpamit campa quitatise tacajcahualisti ica nochi tamantzitzi cati motequihuis. Nojquiya quichihuase nopa hueyi paila huan cati ipan mosehuis huan nochi cati motequihuis ihuaya. ");
INSERT INTO nchBl_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Nojquiya quixinepalose iyoyo tatzejtzeloltic nopa totajtzi Aarón huan quichihuase iniyoyo itelpocahua. ");
INSERT INTO nchBl_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Huan quema quichihuase nopa aceite cati ica antaajaltise para antaiyocatalise para na huan quema quichihuase nopa copali cati ajhuiyac mijyotía para quitatise ipan nopa taixpamit para copali, monequi nochi mochihuas senquisa quej nimitznahuatijtoc.” ");
INSERT INTO nchBl_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Huan TOTECO nojquiya quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Xiquinilhui nopa israelitame para monequi ma mosiyajquetzaca ipan nopa tonali cati nimechnahuati. Pampa nopa tonali elis quej se tanextili para amechelnamiquiltis amojuanti huan amoixhuihua cati amoca nimocajtoc. Huan quej nopa elis para nochipa hasta amoixhuihua teipa ehuani quipiyase iniixhuihua. Quej nopa anquimatise para na, niamoTECO, cati nimechchihua antatzejtzeloltique. ");
INSERT INTO nchBl_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Huajca monequi ma mosiyajquetzaca ipan nopa tonali cati nimechilhui para mosiyajquetzase pampa nopa tonali tatzejtzeloltic huan taiyocatalili para na. Sinta se amo quitepanita ni tanahuatili, monequi anquimictise. Sinta se tequitis ipan se tonali para anmosiyajquetzase, xijmictica. ");
INSERT INTO nchBl_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Chicuase tonati antequitise, pero ipan nopa chicompa tonali monequi anmosiyajquetzase pampa tatzejtzeloltic huan taiyocatalili para na, niamoTECO. Sinta se acajya tequitis ipan nopa tonali, monequi miquis. ");
INSERT INTO nchBl_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Nochi israelitame ama huan iniixhuihua teipa ma amo tequitica ipan nopa tonali para mosiyajquetzase. Monequi quitepanitase nopa tonali pampa quinextía nopa camanali cati nijchijtoc amohuaya. ");
INSERT INTO nchBl_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ni tamanti elis se tanextili para nochipa ica anisraelitame huan na, pampa ica chicuase tonati na, niamoTECO, nijchijqui ilhuicacti huan taltipacti, huan ipan nopa chicompa tonali, ayecmo nitequitic, san nimosiyajquetzqui.” ");
INSERT INTO nchBl_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Huan quema TOTECO tanqui camanalti ihuaya Moisés ipan nopa tepet Sinaí, quimacac ome tepatacti campa ijcuilijtoc itanahuatilhua. Huan Toteco Dios quiijcuilojtoya ica ya imax. ");
INSERT INTO nchBl_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Quema nopa israelitame quiitaque para Moisés huejcahuayaya huan amo nimantzi temoyaya ten nopa tepet, mosentilijque campa Aarón huan quiilhuijque: ―Techchihuili se taixcopincayot para ma techyacana pampa amo tijmatij taya ipantitoc Moisés cati techquixti ipan tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Huan Aarón quinilhui: ―Ma moquixtilica ininpijpilolhua amosihuajhua, amotelpocahua huan amoichpocahua; huan ma techhualiquilica nica. ");
INSERT INTO nchBl_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Huajca nochi moquixtilijque ininpijpilolhua huan quihuiquilijque Aarón. ");
INSERT INTO nchBl_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Huan yaya quiseli huan quiatili nopa oro, huan quema quiquixti ipan tit, quitejtzonqui ica se martillo huan quichijqui quej se becerro. Huajca nopa israelitame quiijtojque: ―¡Xitacaquica anisraelitame, ya ni todios cati techquixti ipan tali Egipto! ");
INSERT INTO nchBl_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Huan quema Aarón quiitac quenicatza paquiyayaj nopa israelitame, quisencajqui se taixpamit iixpa nopa becerro, huan teyolmelajqui: ―Mosta tijpiyase se ilhuit para TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Huan tonili nochi israelitame mijquejque cualca huan quinmictijque tapiyalme huan quintatijque ipan nopa taixpamit, huan temacaque tacajcahualisti para Toteco ma moyoltali ica inijuanti. Teipa nochi mosehuijque huan quichijque se hueyi tacualisti huan tacuajque huan taique quej amo monequi. Huan teipa nochi quichijque cati fiero quej cati quichihuaj ten hueli masehualme. ");
INSERT INTO nchBl_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Huajca TOTECO quiilhui Moisés: ―Xitemo amantzi ten ni tepet, pampa momasehualhua cati tiquinquixti ipan tali Egipto monenpolojtoque. ");
INSERT INTO nchBl_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Nimantzi quicajtejque nopa tanahuatilme cati niquinnahuati ma quitoquilica. Quiatilijque oro huan mochihuilijque se becerro huan amantzi quihueyichihuaj huan quimactilíaj tacajcahualisti, huan quiijtohuaj: ‘Anisraelitame, ya ni amodios cati amechquixti ipan tali Egipto.’ ");
INSERT INTO nchBl_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Nojquiya TOTECO quiilhui Moisés: ―Niquitztoc quenicatza itztoque ni masehualme huan niquita para nelyoltetique. ");
INSERT INTO nchBl_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Huajca ama techcahua, pampa nelía tahuel nicualani inihuaya huan niquintzontamiltis, pero ten ta, Moisés, niquinchihuas sequinoc masehualme cati momiyaquilise tahuel miyac huan itztose ipan se hueyi tali. ");
INSERT INTO nchBl_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Pero Moisés chicahuac quitajtani ITECO Dios ma amo quichihua, quiijto: ―¡Ay TOTECO! ¿Para ten ticualanis ica momasehualhua cati ta tiquinquixti ipan tali Egipto ica mohueyi chicahualis? ");
INSERT INTO nchBl_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Nopa egiptome quiijtose para ta cati tiininTeco tiquinquixti ipan tali Egipto, pampa ya timoilhuijtoya para tiquinmictis ipan tepeme pampa tijnequiyaya tiquinixpolihuiltis ten ni taltipacti. TOTECO, amo hueli tiquincahuilise nopa egiptome ma quiijtoca ya nopa. Yeca ayecmo xicualani. Ximoyolcuepa ica cati timoilhuijtoc tijchihuas huan amo xiquincoco momasehualhua. ");
INSERT INTO nchBl_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Xiquinelnamiqui Abraham, Isaac, huan Israel motequipanojcahua cati ta timotestigojquetzqui ica moseltitzi huan tiquinilhui tiquinmiyaquilis iniixhuihua para ma elica tahuel miyaqui hasta amo aqui huelis quinpohuas. Tiquijto itztose quej imiyaca sitalime nepa ilhuicac. Huan nochi ni tali tiquinmacas iniixhuihua. Huan tiquijto quiselise huan elis iniaxca para nochipa. Quena, quej nopa tiquintencahuili motequipanojcahua. ");
INSERT INTO nchBl_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Huajca TOTECO moyolcuetqui ica cati moilhuijtoya quinchihuilis imasehualhua. ");
INSERT INTO nchBl_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Huan Moisés pejqui temo ten nopa tepet, huan quihualicayaya imaco nopa ome tepatacti cati quipixtoya nopa tanahuatilme. Huan itanahuatilhua Toteco ijcuilijtoya iixpa huan iica nopa tepatacti. ");
INSERT INTO nchBl_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Yaya Toteco Dios cati quitejtejqui nopa tet huan quichijqui nopa tepatacti huan yaya cati ipan tajcuilo. ");
INSERT INTO nchBl_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Huan quema Josué quicajqui tahuejchihuayayaj nopa israelitame nopona tatzinta, quiilhui Moisés: ―Nijcaqui tahuejchihuaj campa itztoque nopa masehualme quej elisquía onca se tatehuilisti. ");
INSERT INTO nchBl_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Pero Moisés quinanquili: ―Amo tahuejchihuaj pampa tatantoque, yon amo quichihuaj pampa sequinoc quintantoque. Nijcaqui cati huicaj seyoc tamanti huicat. ");
INSERT INTO nchBl_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Huan quema Moisés monechcahuiyaya campa itztoyaj nopa israelitame, quiitac nopa becerro huan quenicatza mijtotiyayaj, huan nelía cualanqui. Huan quimajcajqui itzinta tepet nopa tepatacti cati quihuicayaya imaco huan cuechtic mocajqui. ");
INSERT INTO nchBl_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Huan quicuic nopa becerro cati quichijtoyaj huan quitati, huan quitisqui hasta quichijqui tatixtic. Huan nopa itatixo quiijtzelo ipan at, huan quinchihualti nopa israelitame ma quiica nopa at. ");
INSERT INTO nchBl_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Huan Moisés quiilhui Aarón: ―¿Taya mitzchihuilijque ni masehualme para tiquinyacantoc ma quichihuaca ni tajtacoli nelhueyi? ");
INSERT INTO nchBl_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Huan Aarón tananquili: ―Amo xicualani nohuaya, tate. Ta cuali tijmati ni masehualme quinpactía quichihuase cati amo cuali. ");
INSERT INTO nchBl_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Inijuanti techilhuijque ma niquinchihuili se taixcopincayot para techyacanas pampa amo tijmatiyayaj taya mopantic ta cati techquixti ipan tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Huan na niquinnanquili para sinta quipiyaj tamanti ten oro, ma quiquixtica huan inijuanti techmacaque. Huan nijtali nopa oro ipan tit huan quisqui ni becerro. ");
INSERT INTO nchBl_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Huan Moisés quiitac para nochi quipolojtoyaj ininpinahualis. Huan Aarón quincahuilijtoya ma quichihuaca ten hueli cati quinequiyayaj quichihuase. Huan quiitac inincualancaitacahua quinhuetzquiliyayaj. ");
INSERT INTO nchBl_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Huajca moquetzqui iixmelac campa calaquiyayaj ipan ipejya nopa altepet ten iniyoyoncalhua. Huan Moisés quiijto: ―Nochi cati itztoque ica TOTECO ma hualaca nica nohuaya. Huan nochi iixhuihua Leví mosentilijque ihuaya. ");
INSERT INTO nchBl_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Huajca Moisés quinilhui cati moiyocatalijtoyaj ica ya: ―TOTECO Dios ten tiisraelitame quiijtohua para sesen ten amojuanti monequi xijcuica amomacheta, huan xipehuaca ipan nopa achtohui calme huan xipanotiyaca hasta campa ontami nochi ni yoyoncalme. Huan xicalaquica ipan sesen yoyoncali huan xiquinmijmictijtiyaca masque amoicnihua, amohuampoyohua o amocalnechcahua pampa tahuel fiero quichijtoque. ");
INSERT INTO nchBl_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Huan iixhuihua Leví quichijque quej Moisés tanahuatijtoya huan ipan nopa tonali mijque nechca eyi mil masehualme. ");
INSERT INTO nchBl_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Huajca Moisés quinilhui: ―Ama anmoiyocatalijque para itequi TOTECO pampa anquineltocatoque cati amechnahuatijtoc, masque monejqui anquintzontamiltijque amoconehua huan amoicnihua. Huajca ama TOTECO amechtiochihuas. ");
INSERT INTO nchBl_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Huan tonili Moisés quinilhui nopa sequinoc israelitame: ―Anquichijtoque se hueyi tajtacoli. Ama monequi niyas huan nitejcos campa itztoc TOTECO huan niquitas sinta nihuelis nimechixtzacuilis amotajtacol. ");
INSERT INTO nchBl_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Huajca Moisés mocuetqui campa itztoya TOTECO, huan quiilhui: ―Melahuac nopa masehualme quichijtoque se hueyi tajtacoli huan mochihuilijque se taixcopincayot ten oro. ");
INSERT INTO nchBl_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Na nimitztajtanía chicahuac xiquintapojpolhui. Sinta amo, nojquiya techmicti na, huan xiquixpolo notoca ipan nopa amatapohuali cati tiquijcuilo. ");
INSERT INTO nchBl_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Pero TOTECO quinanquili Moisés: ―San niquixpolos itoca huan nijmictis cati noca tajtacolchihua. ");
INSERT INTO nchBl_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Huajca xiya xiquinhuica nopa masehualme hasta campa nimitzilhui. Huan xijmati para temachti noilhuicac ejca mitzyacanas. Pero quema ajsis nopa tonali quema nitetatzacuiltis, niquintatzacuiltis ni masehualme por inintajtacolhua. ");
INSERT INTO nchBl_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Huan TOTECO quititanqui se tatzacuiltijca cocolisti ipan nopa masehualme pampa quihueyichijque nopa becerro cati Aarón quichijqui. ");
INSERT INTO nchBl_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Huan TOTECO quiilhui Moisés: ―Xiquisa ten nica huan xiquinyacana nopa masehualme cati tiquinquixti ipan tali Egipto, huan xiquinhuica hasta nopa tali cati niquintencahuili Abraham, Isaac huan Jacob para niquinmacas iniixhuihua. ");
INSERT INTO nchBl_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Huan nijtitanis se noilhuicac ejca ma mitzyacana, huan yaya quinquixtis ten nopa tali nopa cananeos, amorreos, heteos, ferezeos, heveos huan jebuseos. ");
INSERT INTO nchBl_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Huan amechhuicas ipan nopa tali cati nochi temaca hasta mocahua itajca. Pero na amo niyas amohuaya, pampa nohueli nimechixpolihuiltis ipan ojti, pampa tahuel tetic amoyolo. ");
INSERT INTO nchBl_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","5","Huan TOTECO quiilhui Moisés: ―Xiquinilhui nopa israelitame para inijuanti nelía yoltetique. Xiquinilhui sinta niitztosquía inihuaya seyoc se talojtzi, huelis niquintamiixpolihuiltijtosquía. Huajca xiquinilhui ma moquixtilica nochi nopa tayejyecchijchijcayot ten oro cati quihualicaj quej pactoque, huan niquitas taya nijchihuas ica inijuanti. Huan tahuel miyac mocuesojque nopa israelitame quema quicajque ni camanali cati chicahuac. Huan nochi moquixtilijque iniyejyejca ten oro huan iniyoyo cati yejyectzitzi para amo nesis quej pactoque, pampa ayecmo paquiyayaj. ");
INSERT INTO nchBl_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Huajca ipan tepet Horeb nopa israelitame moquixtilijque ininpijpilolhua, inincoshua, huan nochi cati ica mocualtaliyayaj para moyejyecchijchihuase. Huan ayecmo quitequihuijque. ");
INSERT INTO nchBl_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Huan Moisés ya momajtoya quiquetza iyoca se yoyoncali achi quentzi huejca ten iniyoyoncalhua nopa israelitame. Huan quitocaxti nopa yoyoncali campa timopantise ihuaya TOTECO. Huan quema acajya quinequiyaya quitatzintoquilis TOTECO se tenijqui para quimatis ipaquilis, yahuiyaya ipan nopa yoyoncali campa mopantis ihuaya TOTECO cati eltoya iyoca ten ne sequinoc yoyoncalme. ");
INSERT INTO nchBl_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Huan quema Moisés yahuiyaya para mopantiti ihuaya TOTECO, nochi masehualme momajtoyaj quisaj ininchajchaj huan moquetzaj calteno nechca caltemit huan quitachilíaj Moisés hasta quema oncalaquiyaya ipan nopa yoyoncali. ");
INSERT INTO nchBl_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Huan sesen huelta quema Moisés calaquiyaya ipan nopa cali, nopa mixti hualtemoyaya huan motaliyaya icaltejteno nopa tiopa quema TOTECO camanaltiyaya ihuaya Moisés. ");
INSERT INTO nchBl_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Huajca quema nopa israelitame quiitayayaj nopa mixti moquetztoya icaltejteno nopa yoyoncali, sese ten inijuanti motancuaquetzayaya icalixpa huan quihueyichihuayaya Toteco. ");
INSERT INTO nchBl_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Huan TOTECO quicamanalhuiyaya Moisés moixtachilijtoyaj quej se cati camanalti ihuaya ihuampo. Huan teipa Moisés tacuepiliyaya campa ne sequinoc yoyon calme. Pero nopa telpoca tacat Josué, itelpoca Nun cati quipalehuiyaya Moisés, mocahuayaya nopona ipan nopa yoyoncali campa Mopantíaj ihuaya TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Huan Moisés quiilhui TOTECO: ―Xiquita, techilhuía ma niquinyacana ni israelitame hasta nopa cuali tali, pero amo techilhuía ajquiya tijtitanis nohuaya. Nojquiya tiquijtohua para cuali techixmati huan techcualitztoc. ");
INSERT INTO nchBl_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ama nimitztajtanía se favor. Sinta nelía techcualitztoc, techilhui taya mopaquilis para nijchihuas huan quej nopa más huelis nimitzixmatis. Huan na nimitzneltocas huan noja techcualitztinemis. Huan xiquelnamiqui para ni masehualme cati niquinyacana, nochi moaxcahua. ");
INSERT INTO nchBl_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Huan TOTECO quinanquili: ―Na, niamoTECO, niyas mohuaya huan nijchihuas para timosiyajquetzas. ");
INSERT INTO nchBl_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Huan Moisés quiijto: ―Sinta amo tiyas tohuaya, amo techchihua ma tiquisaca ten nica. ");
INSERT INTO nchBl_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Pampa sinta amo tiyas tohuaya, sequinoc masehualme amo quimatise para techicnelía, na huan ni momasehualhua. Sinta ta amo tohuaya tiyas, huajca tiitztose san se quej ten hueli masehualme. Pero sinta ta tiyas tohuaya, nesis techtapejpenijtoc huan techiyocatalijtoc ten nochi sequinoc masehualme ipan ni taltipacti. ");
INSERT INTO nchBl_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Huan TOTECO quiilhui Moisés: ―Huajca nijchihuas cati tiquijtojtoc pampa nijmati tijchihuas cati cuali, huan ta nimitzitas para tinonelhuampo. ");
INSERT INTO nchBl_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Huajca Moisés quiijto: ―Huajca nimitztajtanía, techcahuili ma nimitzita ta ica nochi motatanex cati yejyectzi. ");
INSERT INTO nchBl_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Huan TOTECO quinanquili: ―Na nijchihuas ma panos moixpa nochi cati cuali ten na. Huan quema nipanos, niquijtos cati quiijtosnequi notoca, TOTECO. Na nijtapejpenía ajquiya nijtasojtas huan ajquiya ihuaya nijpiyas hueyi noyolo. ");
INSERT INTO nchBl_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Pero noxayac amo huelis tiquitas, pampa yon se masehuali amo huelis quiitas noxayac huan itztos. ");
INSERT INTO nchBl_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Huajca TOTECO quiilhui: ―Nica nonechca eltoc se hueyi tet, nopona ximoquetza ipani. ");
INSERT INTO nchBl_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Huan na nimitztalis campa tacoyontoc ipan nopa hueyi tet, huan quema nipanos huan nesis notatanex nimitzixtzacuas ica nomax hasta ya nipanotos. ");
INSERT INTO nchBl_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Teipa niquijcuenis nomax, huan huelis tiquitas nocuitapa, pero noxayac amo tiquitas. ");
INSERT INTO nchBl_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Huan TOTECO quiilhui Moisés: ―Xijtejtequi ome tepatacti cati san cuali ihuejhuexca quej nopa achtohui tepatacme cati nimitzmacac. Huan ipani niquijcuilos nopa camanali cati quipixtoya nopa sequij cati tijtatapatzqui. ");
INSERT INTO nchBl_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Nojquiya ximonemili para mosta cualca titejcos ipan tepet Sinaí. Xihuala ximonextiqui noixpa itzompac nopa tepet. ");
INSERT INTO nchBl_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Ma amo aqui tejcos mohuaya huan amo aqui más itztos ipan nopa tepet. Yon se tapiyali amo hueli tacuajtinemis iteno nopa tepet. ");
INSERT INTO nchBl_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Huajca Moisés quitejtejqui nopa ome tepatacti san se quej nopa cati achtohui. Huan tonili cualca mijquejqui, huan quicuic nopa ome tepatacti imaco huan tejcoc ipan tepet Sinaí quej TOTECO quinahuatijtoya. ");
INSERT INTO nchBl_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Huajca TOTECO temoc ipan se mixti huan moquetzqui ihuaya Moisés, huan quiyolmelajqui taya quinequi quiijtos itoca, TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Huan TOTECO panoc iixpa Moisés huan quiijtojtiyajqui: ―Na niDIOS, moTECO. Na cati nitetasojta huan nijpiya hueyi noyolo ica masehualme. Ohui para nicualani, pampa tahuel niteicnelía. Huelis timotemachis ipan na pampa senquisa nitemachti. ");
INSERT INTO nchBl_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Niquinnextilis tahuel nelpano miyac masehualme quenicatza niquinicnelía, pampa niquintapojpolhuía inintajtacolhua quema techhuejcamajcahuaj huan techixpanoj. Pero sinta se acajya tajtacolchihua, amo niquijtohua para amo teno quichijtoc. Nijtatzacuiltía por itajtacol, huan nojquiya niquintatzacuiltis iconehua, huan iixhuihua, huan hasta iixhuihua ininconehua por nopa cati fiero yaya quichijqui. ");
INSERT INTO nchBl_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Huajca Moisés nimantzi mohuijtzonqui talchi, huan quihueyichijqui TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Huan Moisés quiijto: ―Toteco, sinta ama techcualitztoc, xiya tohuaya huan techyacana, pampa nelía ni masehualme yoltetique. Pero techtapojpolhui totaixpanolhua huan totajtacolhua, huan techseli para ma tielica timoaxcahua para nochipa. ");
INSERT INTO nchBl_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Huan TOTECO quinanquili: “¡Cualtitoc! Ya ni nopa camanal sencahuali cati ica nimocahuas amohuaya. Amoixpa nochi annomasehualhua nijchihuas huejhueyi tanextili quej cati amo quema mochijtoc ipan yon se tali ipan nochi ni taltipacti. Huan quiitase nohueyi chicahualis nochi nopa masehualme cati mohuaya itztoque. Quiitase cati na, niamoTECO, hueli nijchihua pampa temajmati nopa hueyi tamanti cati nijchihuas ica ta. ");
INSERT INTO nchBl_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","“Ipan ni camanal sencahuali cati tijchihuaj san sejco, monequi ta tijchihuas cati nimitznahuatijtoc ama, huan na amoixpa niquinquixtijtiyas ten amotal nopa amorreos, cananeos, heteos, ferezeos, heveos huan jebuseos. ");
INSERT INTO nchBl_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","“Pero ximomocuitahuica para amo xijchihuaca yon se camanali inihuaya masehualme cati itztoque ipan nopa tali campa ancalaquise para anitztotij. Sinta anmomatise inihuaya, amechtahuisose ipan tajtacoli. ");
INSERT INTO nchBl_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Pero quena, xijhuelonica nochi nopa taixpamit cati iniaxca, huan xijtamitatapatzaca ininteteyohua. Huan xijtzontequica nopa fiero taquetzalme ica nopa taixcopincayot Asera cati inijuanti quinhueyichihuaj. ");
INSERT INTO nchBl_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","“Amo quema ximotancuaquetzaca iixpa o xijhueyichihuaca seyoc quej elisquía se dios. Na niamoTECO huan techtocaxtíaj nopa DIOS CATI TETASOMATI, pampa nimechtasomati huan nijnequi san na techhueyichihuaca. ");
INSERT INTO nchBl_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Yeca amo xijchihuaca yon se camanali ica nopa masehualme cati itztoque ipan nopa tali. Huan quema inijuanti quinhueyichihuase huan quintencahuilise tacajcahualisti inintaixcopincayohua, huan motemacase iniixpa quej tacanenca sihuame, nojquiya amechnotzase para xiyaca inihuaya. Pero nimechilhuía, amo xiyaca. Amo ximomatica ica inijuanti pampa huelis anquinhueyichihuase inintaixcopincayohua huan anquicuase cati tacajcajtoque. ");
INSERT INTO nchBl_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Amotelpocahua amo hueli mosihuajtise ica iniichpocahua pampa nopa ichpocame quinhueyichihuaj taixcopincayome cati amo neli dios huan quinchihualtise amotelpocahua nojquiya ma quichihuaca. ");
INSERT INTO nchBl_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Amo quema xijchihuaca yon se taixcopincayot. ");
INSERT INTO nchBl_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Monequi xiilhuichihuaca ipan nopa ilhuit ten pantzi cati amo quipiya tasonejcayot. Monequi para chicome tonati anquicuase nopa pantzi cati amo quipiya tasonejcayot quej nimitznahuatijtoc. Xijchihuaca ni ilhuit ipan nopa tonali cati nimitzilhui ipan metzti Abib, pampa ipan nopa metzti anquisque ipan tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Nochi cati achtohui ehua elis noaxca. Elise noaxcahua nochi iniachtohui oquich conehua amotapiyalhua, masque amohuacaxhua, amoborregojhua o amochivojhua. ");
INSERT INTO nchBl_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Pero sinta tacatis se pilburrojtzi, huelis techcohuilise para anquitequihuise sinta antechmacase se pilborregojtzi. Pero sinta amo antechcohuilise nopa pilburrojtzi, monequi anquiquechpostequise. Nojquiya monequi antechcohuilise amoachtohui oquichpilhua ica se tacajcahualisti. Huan amo aqui huelis hualas techitaqui san ica imax. Monequi techhualiquilis se tacajcahualisti. ");
INSERT INTO nchBl_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Xitequitica para chicuasen tonati, pero ipan nopa chicompa tonali, monequi ximosiyajquetzaca. Masque antapoxoníaj o anpixcaj, monequi anmosiyajquetzase. ");
INSERT INTO nchBl_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Nojquiya xiilhuichihuaca ipan nopa ilhuit ten ipejya pixquisti quema achtohui anquipixcase trigo. Nojquiya xiilhuichihuaca ipan nopa ilhuit ten itamiya pixquisti quema nechca itamiya se xihuit. ");
INSERT INTO nchBl_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Eyi huelta ipan se xihuit monequi nochi tacame huan oquichpilme ma monextica noixpa, na niamoTECO, niamoDios anisraelitame. ");
INSERT INTO nchBl_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Huan na niquinquixtijtiyas amoixpa nopa masehualme cati amo techixmatij ipan nopa tali, huan nijhueyilijtiyas amotal. Huan quema anyase anmonextitij noixpa na, niamoTECO Dios, eyi huelta ipan se xihuit, amo aqui huelis quiixtocas o moaxcatis amotal. ");
INSERT INTO nchBl_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Quema antechmacase tacajcahualisti, amo techmacaca ica yon se tamanti cati quipiya tasonejcayot. Nojquiya amo huelis anquiajocuise hasta mosta yon se quentzi ten nopa tacajcahualisti para Pascua. ");
INSERT INTO nchBl_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Nopa cati achtohui taquis ipan amomil, huan nopa cati más cuali itajca monequi anquihuicase ipan nochaj, na niDIOS, niamoTECO. “Amo xiquicxitica se pilconechivojtzi ipan inana ilechi quej quichihuaj tenahualhuiani.” ");
INSERT INTO nchBl_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Huan TOTECO quiilhui Moisés: “Xiquijcuilo ni tanahuatilme cati nimitzmaca, pampa ica ni tanahuatilme nijchihuas ni camanali mohuaya huan inihuaya nopa israelitame.” ");
INSERT INTO nchBl_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Huan Moisés itztoya ihuaya TOTECO ipan nopa tepet para 40 tonati huan 40 yohuali. Huan ipan nochi nopa tonali amo tacuajqui, yon amo atic. Huan huajca TOTECO quiijcuilo ipan nopa tepatacme nochi nopa majtacti tanahuatilme cati monequi ma quichihuaca israelitame ipan nopa camanali cati TOTECO quichihuayaya inihuaya. ");
INSERT INTO nchBl_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Huan Moisés temoc ten tepet Sinaí ica nopa ome tepatacti cati quipixtoya nopa tanahuatilme. Huan petaniyaya ixayac pampa camanaltitoya ihuaya Toteco Dios, pero yaya amo quimatiyaya. ");
INSERT INTO nchBl_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Huan quema Aarón huan nochi nopa israelitame quiitaque ixayac Moisés petaniyaya, tahuel majmajque huan amo quinejque quinechcahuise. ");
INSERT INTO nchBl_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Huajca Moisés quinnotzqui ma quinechcahuica huan Aarón ica nochi tayacanani monechcahuicoj huan Moisés quincamanalhui. ");
INSERT INTO nchBl_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Huan teipa monechcahuijque nochi nopa sequinoc israelitame, huan Moisés quinilhui nochi nopa tanahuatilme cati TOTECO quimacac ipan tepet Sinaí. ");
INSERT INTO nchBl_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Huan quema Moisés tanqui quincamanalhuía, moixtzajqui ica se yoyomit. ");
INSERT INTO nchBl_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Pero sesen huelta quema Moisés calaquiyaya ipan nopa tiopamit iixpa TOTECO para mocamanalhuis ihuaya, moquixtiliyaya nopa yoyomit cati ica moixtzacuayaya huan quej nopa mocahuayaya hasta quema quisayaya. Huan quema quisayaya para quinyolmelahuas israelitame cati TOTECO quinnahuatijtoya, ");
INSERT INTO nchBl_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","nopa israelitame sempa quiitayayaj para petaniyaya ixayac, huajca Moisés sempa moixtzacuayaya. Huan quej nopa mocahuayaya moixtzactoc hasta sempa oncalaquiyaya para camanaltis ihuaya Toteco Dios. ");
INSERT INTO nchBl_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Huan Moisés quinsentili nochi israelitame huan quinilhui: “Ya ni nopa tanahuatili cati TOTECO quiijtojtoc ma tijchihuaca. ");
INSERT INTO nchBl_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Quiijto para huelis titequitise chicuasen tonati, pero nopa chicompa tonali elis para tojuanti se tonali tatzejtzeloltic, huan ipan nopa tonali monequi ximosiyajquetzaca para TOTECO. Sinta acajya tequitis ipan nopa tonali, monequi miquis. ");
INSERT INTO nchBl_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Yon amo xitipitzaca ipan amochajchaj ipan nopa tonali para anmosiyajquetzase.” ");
INSERT INTO nchBl_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Huan Moisés quincamanalhui nochi israelitame, huan quinilhui: “Ya ni cati TOTECO tanahuatijtoc ma tijchihuaca. ");
INSERT INTO nchBl_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Nochi amojuanti cati anquinequij anquimacase TOTECO se tenijqui ica amopaquilis huan ica nochi amoyolo, huelis anquimacase huan tijsentilise nopa tamanti. Huelis anquihualicase cati anquipiyaj ten oro, plata o bronce. ");
INSERT INTO nchBl_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","Huelis anquihualicase icpat ten lino cati tamalinti nelcanactzi. Xijhualicaca nojquiya icpat cati quipajtoque azultic, morado huan chichiltic. Nojquiya xijhualicaca nopa yoyomit cati tetic quej se cuetaxti cati taxinepaloli ica oquich chivo iijhuiyo. ");
INSERT INTO nchBl_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","Xijhualicaca inincuetaxo borregojme huan pesojme cati quipajtoque chichiltic. Nojquiya xijhualicaca nopa cuahuit cati itoca acacia, ");
INSERT INTO nchBl_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","huan oliva aceite para taahuilme. Nojquiya monequi nopa taajhuiyacayot cati quimanelose ica nopa aceite para quinajaltise tamanti huan masehualme para quiniyocatalise para itequi TOTECO. Huan monequi quichicahuase nopa taajhuiyajcayot para nopa copali cati ajhuiyac mijyotía. ");
INSERT INTO nchBl_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Nojquiya xijhualicaca nopa piltetzitzi cati yejyectzitzi cati inintoca ónice huan sequinoc piltetzitzi cati yejyectzitzi para tijtalise ipan nopa ixpantzajcayot huan nopa yolixtzajcayot para nopa hueyi totajtzi. ");
INSERT INTO nchBl_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“TOTECO tanahuatijtoc para nochi amojuanti cati anquipiyaj talnamiquilisti huan yajatili para anquichihuase se cuali tequit, xihualaca para anquichihuase nochi ni tequit cati tanahuatijtoc TOTECO ma tijchihuaca. ");
INSERT INTO nchBl_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Monequi tijchihuase nopa yoyon tiopamit ihuaya itzontzajca, itepos chijcolhua, ihuapalhua, icuaixtapalhua, itaquetzalhua huan itepos cuatetonyo. ");
INSERT INTO nchBl_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Tijchihuase nopa caxa ica cuahuit huehueyac para tijhuicase huan itzajca campa Toteco techtasojtas huan nopa cortina cati quitzacuas. ");
INSERT INTO nchBl_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Nojquiya tijchihuase nopa cuamesa huan cuahuit huehueyac para tijhuicase huan nochi cati motequihuía ica nopa cuamesa, ihuaya nopa pantzi cati tenextilía para TOTECO itztoc tohuaya. ");
INSERT INTO nchBl_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Quichihuase nopa taahuil quetzali cati elis para taahuili, huan nochi cati motequihuía nopona huan itaahuilhua, huan iaceite. ");
INSERT INTO nchBl_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Quichihuase nopa taixpamit para copali huan nopa cuahuit huehueyac cati ica quihuicase. Quichihuase nopa aceite para titaiyocatalise para Toteco huan nopa tamaneloli copali cati ajhuiyac mijyotía. Nojquiya quichihuase icortina para tijcuahuiyonise campa nopa caltemit campa calaquise ipan nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Quichihuase nopa taixpamit campa quitatise tacajcahualisti ica itixic huan iteposixtapalhua. Nojquiya quichihuase nopa cuahuit huehueyac para ica tijhuicase huan nochi nopa tamantzitzi cati motequihuis nopona. Huan quichihuase nopa hueyi paila ten bronce ihuaya cati ipan mosehuis. ");
INSERT INTO nchBl_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Quichihuase nopa tatzacti ten cortina cati quiyahualos nopa calixpamit. Huan nopa calixpamit quiyahualos nochi nopa yoyon tiopamit. Nojquiya quichihuase itaquetzalhua nopa cortina tatzacti, huan itepos cuatetonyo sesen ten nopa taquetzalme. Nojquiya quichihuase nopa cortinas cati tijcuahuiyonise cati quitzacuas campa ancalaquise ipan calixpamit. ");
INSERT INTO nchBl_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Quichihuase estacas, huan lazos para moilpis huan motetzilos nopa yoyon tiopamit, huan nopa taquetzali. ");
INSERT INTO nchBl_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Quichihuase nopa yoyomit cati moquentise totajtzitzi cati tequitise tiopan calijtic. Quena, monequi quichihuase nopa yoyomit tatzejtzeloltic para Aarón, huan nojquiya quichihuase cati moquentise itelpocahua.” ");
INSERT INTO nchBl_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Huan nochi israelitame motanantejque campa itztoya Moisés huan yajque ininchajchaj. ");
INSERT INTO nchBl_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Huan nochi cati quimachilijque para TOTECO quinyoltacani ma quimacaca se tenijqui huan ipan iniyolo quinequiyayaj quimacase, temacaque. Huan nopa israelitame quihuicaque nochi nopa ofrendas para nopa yoyoncali campa mopantise ihuaya TOTECO, huan nochi nopa tamantzitzi cati monequiyaya para quichihuase nopa tequit tiopan calijtic. Nojquiya quihualicaque cati monequiyaya para iyoyo tatzejtzeloltic nopa totajtzi. ");
INSERT INTO nchBl_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Huan hualajque tacame huan sihuame cati ica nochi iniyolo quinequiyayaj quimacase se tenijqui. Huan miyaqui quihualicayayaj tamanti ten oro cati quitequihuijtoyaj para moyejyecchihuase. Quihualicaque pijpilolme, anillos, maquechcosme huan ten hueli tatecti oro. Huan nochi ni oro quitencahuilijque TOTECO quej se ofrenda. ");
INSERT INTO nchBl_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Sequinoc quihuicaque icpat azultic, morado huan chichiltic huan lino icpat cati tamalinti nelcanactzi, huan nojquiya quihualicaque yoyomit cati tetic quej se cuetaxti cati taxinepaloli ica iniijhuiyo oquich chivojme. Quihualicaque inincuetaxo pesojme huan ininpochquiyo borregojme cati quipajtoque chichiltic. ");
INSERT INTO nchBl_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Huan nochi cati quinequiyayaj temacase se ofrenda ten plata, o bronce, quihuicaque campa TOTECO. Huan cati quipiyayayaj nopa cuahuit acacia cati monequi motequihuis ipan ichaj TOTECO, quihualicaque. ");
INSERT INTO nchBl_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Huan miyaqui sihuame cati hueliyayaj tamalinaj cuali huan cati ica nochi iniyolo tequitiyayaj, quihualicaque icpat cati azultic, morado huan chichiltic. Nojquiya quihualicaque lino icpat cati nelcanactzi. ");
INSERT INTO nchBl_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Huan sequinoc sihuame cati cuali hueliyayaj tamalinaj, quimalinque iniijhuiyo oquich chivojme huan quichijque yoyomit cati tetic. ");
INSERT INTO nchBl_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Huan nopa tayacanani quihuicaque piltetzitzi cati itoca ónice huan sequinoc piltetzitzi cati pajpatiyo para quitatzquiltise ipan nopa ixpantzajcayot huan yolixtzajcayot para nopa totajtzi. ");
INSERT INTO nchBl_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Huan nojquiya quihualicaque xihuit cati ajhuiyac mijyotía huan aceite para taahuili. Nojquiya quihualicaque aceite para nopa tamaneloli cati ica teajaltise quema taiyocatalise para Toteco, huan nopa copali cati ajhuiyac mijyotía. ");
INSERT INTO nchBl_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Huan nochi israelita sihuame huan tacame cati quimachilijque ipan iniyolo para hueli quichihuase se ten nopa tamanti tequit cati TOTECO quinahuatijtoya Moisés, quichijque huan quihuicaque cati quisencajtoyaj para ma eli quej se ofrenda para TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Huan Moisés quinilhui nopa israelitame: “Xiquitaca para TOTECO quitapejpenijtoc Bezaleel, icone Uri huan iixhui Hur cati tacatqui ipan nopa hueyi familia ten iixhuihua Judá, para tayacanas ipan nochi ni tequit. ");
INSERT INTO nchBl_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Huan Toteco Dios quitali Itonal ica ihueyi chicahualis ipan Bezaleel para tayacanas. Huan Toteco quimacatoc talnamiquilisti huan yajatili para quimatis miyac tamanti tequit para huelis quichihuas nochi cati monequi, ");
INSERT INTO nchBl_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","huan para huelis quichihuas tamanti yejyectzitzi ica oro, plata huan bronce. ");
INSERT INTO nchBl_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Cuali quimati quintequis huan quinalaxos piltetzitzi para petanise. Nojquiya quimacatoc yajatili para elis se cuali cuaxinquet cati hueli quitejtequi huan quiyectalía cuahuit para quichihuas cati yejyectzi. ");
INSERT INTO nchBl_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Nojquiya Toteco Dios quimacac talnamiquilisti Bezaleel ihuaya Aholiab para ma quinmachtica sequinoc nochi cati inijuanti quimatij. Aholiab eliyaya icone Ahisamac huan tacatqui ipan nopa hueyi familia ten iixhuihua Dan. ");
INSERT INTO nchBl_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Huan Toteco Dios quinmacatoc nochi ome tahuel miyac inintalnamiquilis para ma quichihuaca miyac tamanti tequit. Quimatij quenicatza quicualtalise oro, huan quenicatza cuatequise. Quimatij quenicatza quichihuase yoyomit cati yejyectzi tajtzonti ica icpat cati azultic, morado, huan chichiltic, taxinepaloli ica lino icpat nelcanactzi. Quipiyaj yajatili para quichihuase nochi ni tequit, huan para quiyoliltise nochi nopa tamantzitzi cati monequi quichihuase, huan quichihuase sese ica itachiyalis cati monequi. ");
INSERT INTO nchBl_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Huajca Bezaleel huan Aholiab huan nochi sequinoc masehualme cati TOTECO quinmacatoya talnamiquilisti para ni tequit, huan quipixque ipan iniyolo para tapalehuise, monejqui tequitise huan quichihuase nopa yoyon tiopamit senquisa quej TOTECO tanahuatijtoya.” ");
INSERT INTO nchBl_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Huajca Moisés quinotzqui Bezaleel huan Aholiab, huan nochi masehualme cati TOTECO quinmacatoya talnamiquilisti huan cati motemacayayaj ica nochi iniyolo para tequitise, huan nochi hualajque. ");
INSERT INTO nchBl_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Huan Moisés quinmactili nochi tamanti cati nopa israelitame quihualicatoyaj cati monequi quitequihuise ipan nopa yoyon tiopamit. Huan mojmosta nopa israelitame noja quihualicayayaj ofrenda para quitequihuise. ");
INSERT INTO nchBl_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Huajca teipa nochi inijuanti cati quichihuayayaj tamanti quitilquetzque inintequi, ");
INSERT INTO nchBl_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","huan quicamanalhuitoj Moisés huan quiilhuijque: “Nochi quihualicatoque tahuel miyac tamanti hasta conpano cati monequi para tijchihuase nochi cati TOTECO tanahuatijtoc.” ");
INSERT INTO nchBl_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Huajca Moisés tanahuati ma quinyolmelahuatij nochi israelitame ipan ininchajchaj para yon se tacat o sihuat ayecmo ma quisencahua seyoc tamanti para nopa tiopamit, yon ayecmo ma tahuajhualicaca. ");
INSERT INTO nchBl_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Pampa ya quipixtoyaj tahuel miyac cati quitequihuise huan hasta miyac mocahuayaya. ");
INSERT INTO nchBl_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Huan nopa masehualme cati Toteco quinmacatoya talnamiquilisti para ma tequitica nopona, quichijque itzontzajca nopa tiopamit. Quichijque ica 10 cortinas ica lino tamalinti nelcanactzi huan taxinepaloli ica icpat cati azultic, morado, huan chichiltic huan ipani nesiyaya inintachiyalis nopa ilhuicac ehuani cati inintoca querubines. ");
INSERT INTO nchBl_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Huan sesen ten nopa cortinas eliyaya 12 metros huan tajco ihuehueyaca, huan ome metro ipatajca. ");
INSERT INTO nchBl_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Huan quisalojque itamiya se cortina ica itamiya seyoc nopa macuili cortinas para mochijqui san se cortina cati huehueyac. Huan nopa seyoc macuili cortinas nojquiya quiijtzonque para mochijqui san se cortina cati huehueyac huan nopa ome cortinas huehueyac elqui para sesen lado itzontzajca nopa tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Huan ipan se iteno ten sesen nopa ome huehueyac cortinas cati quimojmotzquiltijtoyaj, quichihuilijque tailpili ica itzojhuaso campa mosojsos, huan quitenyahualojque sese itzojhuaso ica icpat azultic. ");
INSERT INTO nchBl_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Para nochi quichihuilijque 50 tailpili sese ica itzojhuaso para mosojsos ipan se lado nopa ome huehueyac cortinas cati achtohui tasaloli. Huan teipa quinchijque nopa tailpili ipan sese para ma moixnamictica ica nopa tailpili ipan seyoc. ");
INSERT INTO nchBl_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Nojquiya quichijque 50 tepos chijcoli ten oro para quisalose nopa 50 tailpili ipan sesen ten nopa ome cortinas tasaloli. Quej nopa quichijque para quitzacuase huejcapa ipan nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Nojquiya quichijque 11 cortinas ten nopa tetic yoyomit cati taxinepaloli ica iniijhuiyo oquich chivojme para quichijque iompa tzontzajca nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Huan sesen cortina ihuehueyaca eliyaya 13 metros huan tajco, huan ome metro ipatajca, huan nochi 11 cortinas quipixqui san se inihuejhuexca. ");
INSERT INTO nchBl_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Huan quisalojque macuili cortinas san sejco huan iyoca quisalojque seyoc chicuase cortinas. ");
INSERT INTO nchBl_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Huan ipan sese lado ten nopa ome huehueyac cortinas quichihuilijque 50 tailpili ica inintzojhuaso campa mosojsos. ");
INSERT INTO nchBl_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Nojquiya quichihuilijque 50 tepos chijcoli ten bronce para ipan quisalose inintzojhuaso nopa tailpili ipan se cortina ica nopa tailpili ipan seyoc cortina para iompa tzontzajca nopa yoyon tiopamit elis tasaloli san sejco. ");
INSERT INTO nchBl_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Huan nopa expa itzontzajca quichijque ica inincuetaxo oquich chivojme cati quipajque chichiltic, huan nopa najpa itzontzajca cati elqui más calixco quichijque ica inincuetaxo pesojme. ");
INSERT INTO nchBl_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Huan para icaltepayo nopa tiopamit quinquejquetzque nopa huapalme cati eliyaya ten cuahuit acacia. ");
INSERT INTO nchBl_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Huan sese huapali quipixqui nahui metros huan tajco ihuehueyaca, huan 65 centímetros ipatajca. ");
INSERT INTO nchBl_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Sese huapali quipixqui ome tepos chijcoli para quisalos ica ne sequinoc huapalme ipan sesen lado. ");
INSERT INTO nchBl_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Huan ijcatoyaj 20 huapalme ipan nopa caltepamit ica sur. ");
INSERT INTO nchBl_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Huan tatzinta ten sesen nopa huapali calaquiyaya ipan ome itepos cuatetonyo ten plata para moquetzas cuali. Oncayaya 40 tepos cuatetomit, ome cuatetomit ipan sese huapali. Huan sesen huapali quipixtoya ome tepos chijcoli para quitatzquiltis ipan itepos cuatetonyo. ");
INSERT INTO nchBl_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ipan nopa caltepamit ica norte oncayaya seyoc 20 huapalme, ");
INSERT INTO nchBl_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","huan 20 itepos cuatetonyo. Tatzinta ten sese huapali oncayaya ome itepos cuatetonyo. ");
INSERT INTO nchBl_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Iica nopa tiopamit ipan nopa lado campa temo tonati quipixqui chicuase huapalme. ");
INSERT INTO nchBl_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Huan quitalilijque seyoc huapali iica tiopamit campa sese iesquina. ");
INSERT INTO nchBl_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Huan quej nochi sequinoc huapalme, nopa huapalme campa inincalnacasta quipixqui tepos chijcoli ica tatzinta huan ica huejcapa para quisojsos ica nopa huapalme cati ininechca. ");
INSERT INTO nchBl_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Huajca campa temo tonati oncayaya chicueyi huapalme huan 16 tepos cuatetomit cati ipan moquetztoya, ome cuatetomit tatzinta ten sesen huapali. ");
INSERT INTO nchBl_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Quichijque cuaixtapali huejhuehueyac ten cuahuit acacia huan quitalijque iixpa nopa huapalme ipan nopa caltepamit cati quiyahualojque nopa tiopamit. Quichijque macuili cuaixtapali para iixpa nopa huapalme ipan se lado ten nopa tiopamit, ");
INSERT INTO nchBl_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","huan seyoc macuili cuaixtapali para iixpa nopa huapalme ipan ne seyoc lado, huan seyoc macuili cuaixtapali para iniixpa nopa huapalme cati moquetzque iica nopa tiopamit ica campa temo tonati. ");
INSERT INTO nchBl_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Huan nopa cuaixtapali cati panoc tatajco ten nopa huapalme cati moquetztoyaj pejque ica se iesquina tiopamit huan ajsic hasta seyoc iesquina nopa tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Huan nopa huapalme quinixaltijque ica oro, huan nopa anillos campa calaquiyayaj nopa cuaixtapalme elqui senquisa oro. Nojquiya quiixaltijque ica oro nopa cuaixtapalme cati huejhuehueyac. ");
INSERT INTO nchBl_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Huan nopa cortina cati quitzajqui nopa cuarto cati más calijtic quichijque ica lino cati tamalinti nelcanactzi huan taxinepaloli ica icpat cati quipajtoyaj azultic, morado huan chichiltic. Huan ipan nopa taxinepaloli nesiyayaj ome ilhuicac ehuani cati inintoca querubines. ");
INSERT INTO nchBl_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Huan para ipan mohuiyonis nopa cortina quichijque nahui taquetzali ica cuahuit acacia huan quinixalti ica oro. Huan ipan nopa taquetzali quitalijque tepos chijcoli ten oro. Huan sesen ten nopa nahui taquetzalme moquetztoya ipan inincuatetonyo ten plata. ");
INSERT INTO nchBl_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Nojquiya quichijque se cortina para quitzacuase campa calaquise ipan yoyon tiopamit. Quichijque ica lino nelcanactzi cati taxinepaloli ica icpat azultic, morado, huan chichiltic huan quiijtzonque yejyectzi ica itachijchihualo. ");
INSERT INTO nchBl_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Huan ni cortina tatzquitoya ipan macuili taquetzali ica macuili tepos chijcoli. Huan inintzompac nopa macuili taquetzalme huan tepos chijcolme quiixaltijque ica oro, huan nopa macuili icuatetonyo cati ipan moquetzqui nopa taquetzali quichijque ica bronce. ");
INSERT INTO nchBl_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Huan teipa Bezaleel quichijqui nopa caxa ica cuahuit acacia huan quipixqui 110 centímetros ihuehueyaca, huan 65 centímetros ipatajca, huan 65 centímetros ihuejcapanca. ");
INSERT INTO nchBl_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Iijtic huan ipani quialti ica senquisa oro, huan yahualtic itejteno quipiyayaya oro. ");
INSERT INTO nchBl_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Huan quichihuili nahui anillo ten oro huan quitalili najcac ipan inacasta. ");
INSERT INTO nchBl_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Nojquiya quichijqui cuahuit huehueyac huan quiixalti ica oro. ");
INSERT INTO nchBl_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Huan ipan nopa anillos quicalaqui nopa cuahuit huehueyac para quej nopa huelis quihuicase nopa caxa. ");
INSERT INTO nchBl_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Teipa quichijqui itzajca nopa caxa campa Toteco quintasojtas masehualme. ");
INSERT INTO nchBl_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Nojquiya iixco itzajca quinquetzqui ome iilhuicac ejcahua Toteco cati inintoca querubines cati tatejtzonti ica martillo. Huan nopa ilhuicac ehuani huan itzajca nopa caxa elqui ten san se tatecti oro. Huan nopa ilhuicac ehuani moquetztoyaj ipan sese iteno itzajca. ");
INSERT INTO nchBl_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Se iilhuicac ejca Toteco moquetztoc ipan se iteno huan nopa seyoc ipan seyoc iteno. Nopa querubines huan itzajca nopa caxa elqui ten san se tatecti oro tatejtzonti. ");
INSERT INTO nchBl_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Nopa ilhuicac ehuani moixnamictoyaj huan moeltapal tanantoyaj quej elisquía quiecahuiliyayaj huan quitachiliyayaj itzajca nopa caxa campa TOTECO quintasojtas masehualme. ");
INSERT INTO nchBl_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Nojquiya quichijqui nopa cuamesa ica cuahuit acacia. Huan quipiyayaya 90 centímetros ihuehueyaca, huan 45 centímetros ipatajca, huan 65 centímetros ihuejcapanca. ");
INSERT INTO nchBl_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Huan quiixalti ica senquisa oro. Huan quichihuilijque nopa cuamesa se corona ten oro cati quitenyahualo iixco. ");
INSERT INTO nchBl_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Nojquiya quitenyahualo iixco nopa cuamesa ica se pilhuapaltzi cati quipiya chicome centímetros ipatajca. Huan yahualtic quitejtejqui para quichihuili iyejyejca huan quiixalti nochi ica senquisa oro. ");
INSERT INTO nchBl_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Huan quichihuili nahui anillo ten oro, huan quitali najcac ipan inacasta nopa cuamesa campa pehua iicxihua iquespa nopa mesa. ");
INSERT INTO nchBl_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Nopa anillos eltoya huejcapa ipan iicxi nechca nopa pilhuapaltzi cati quitentzactoya nopa cuamesa. Huan quichijchijqui cuahuit huehueyac huan quicalaqui ipan nopa anillos ipan nopa cuamesa para quej nopa huelis quihuicase. ");
INSERT INTO nchBl_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Huan para quichihuas nopa cuahuit huehueyac para ica quihuicase nopa cuamesa quitequihui cuahuit acacia, huan quiixalti ica oro. ");
INSERT INTO nchBl_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Nojquiya quichijqui cati quitequihuise ipan cuamesa quej platome, huejhueyi cucharas, teposhuitzcucharas huan huejhueyi xarros para tacajcahualisti cati atic. ");
INSERT INTO nchBl_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Nojquiya quichijqui se taahuil quetzali cati senquisa oro. Iicxi, icuayo, ipilcaxihua, ixochiyo mimilijtoc huan cahuantoc huan nochi iyejca quichihuili ica san se tatecti oro cati tatejtzonali ica martillo. ");
INSERT INTO nchBl_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Huan quipixtoya chicuase imacuayohua; eyi imacuayohua ipan se lado, huan nopa seyoc eyi ipan seyoc lado. ");
INSERT INTO nchBl_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ipan sese imacuayo quipixqui eyi pilcaxitzitzi cati ipan tatatise huan quipixqui itachiyalis quej se almendra ixochiyo cati mimilijtoc huan se cati cahuantoc. Huan ipan nochi nopa chicuase imacuayohua quej nopa eliyaya. ");
INSERT INTO nchBl_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Huan ipan icuayo nopa taahuil quetzali quipiyayaya nahui pilcaxitzitzi, sese ica itachiyalis se xochit almendra, se nesiyaya se xochit mimilijtoc huan se quej se xochit cahuantoc. ");
INSERT INTO nchBl_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Huan tatzinta ten sesen nopa chicuase imacuayohua cati tatzquitoyaj ipan icuayo nopa taahuil quetzali quipiyayaya se xochit cahuantoc. ");
INSERT INTO nchBl_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Huan nochi ixochiyohua huan imacuayohua huan icuayo eliyaya ten san se tatecti oro huan tatejtejtzonti ica martillo. ");
INSERT INTO nchBl_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Nojquiya quichihuili chicome piltaahuiltzitzi, huan nopa cucharas cati ica quisehuiyayaj nopa taahuilme, huan quichihuilijque iplatohua. Huan nochi quichijque ica senquisa oro. ");
INSERT INTO nchBl_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Huan nopa taahuil quetzali ten oro quipixqui 33 kilos ietica. ");
INSERT INTO nchBl_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Nojquiya quichijqui se taixpamit campa quitatise copali huan elqui cuadrado, ica 45 centímetros ihuehueyaca huan ipatajca, huan quipiyayaya icuacua ipan nochi nahui iesquina, huan nochi san eliyaya se tatecti cuahuit. ");
INSERT INTO nchBl_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Huan quiixalti ica senquisa oro nochi itzontzajca, huan iquesta, huan icuacua. Huan yahualtic iixco quiquetzqui se corona ten oro cati quiyectali. ");
INSERT INTO nchBl_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Huan nojquiya quichihuili nahui anillos itantita nopa nahui iesquinajyo, huan nopona quicalaqui nopa cuahuit huehueyac para ica quihuicase. ");
INSERT INTO nchBl_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Huan nopa cuahuit huehueyac quichijqui ica cuahuit acacia, huan quiixalti ica oro. ");
INSERT INTO nchBl_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Nojquiya quichijqui nopa aceite cati tatzejtzeloltic para ica taiyocatalise para Toteco, huan quichijqui nopa copali cati ajhuiyac mijyotía. Nochi quichijqui Bezaleel, se taajhuiyacachijquet cati achi más quimatiyaya. ");
INSERT INTO nchBl_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Huan nojquiya ica cuahuit acacia quichijqui se taixpamit cati cuadrado iixco campa quitatise tacajcahualisti. Quipixqui 2 metros 25 centímetros ihuehueyaca huan ipatajca. Huan ihuejcapanca eltoya 1 metro 25 centímetros. ");
INSERT INTO nchBl_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Huan ipan najcac iesquina quichihuili icuacua. Huan quichijqui ica san se tatecti cuahuit huan quiixalti ica nopa teposti bronce. ");
INSERT INTO nchBl_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Huan quichihuili nochi cati monequi quitequihuise ipan nopa taixpamit quej nopa tepos caja cati ipan quitemase cuajnexti, nopa huajcalme para quiselise esti, huan nopa tepos chijcoli para ica quiitzquise nopa nacat, huan palas para ica quiquixtise cuajnexti, huan nopa teposti para ticoli. Huan nochi quichijqui ica bronce. ");
INSERT INTO nchBl_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Huan ica bronce quichihuili se tixicti ica ipiltepos ixtapalhua para iixco huelis motecas nopa tacajcahualisti cati quitatíaj. Huan quisehui nopa tixicti ipan tajco ihuejcapanca iijtico nopa taixpamit campa quipixqui se itencuayo. ");
INSERT INTO nchBl_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Huan nojquiya najcac campa iesquina quichihuili nahui anillos para ipan quicalaquise nopa cuahuit huehueyac para ica quihuicase. ");
INSERT INTO nchBl_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Huan quichijchijqui nopa cuahuit huehueyac ica cuahuit acacia huan teipa quiixalti ica bronce. ");
INSERT INTO nchBl_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Huan quincalaqui nopa huehueyac cuame ipan nopa anillo cati eltoya iquesta nopa taixpamit para huelis quihuicase. Huan quichijqui nopa taixpamit ica huapali huan mocajqui ijti cacahuaxtic. ");
INSERT INTO nchBl_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Huan quichijqui ica bronce nopa hueyi paila ten bronce para at huan nopa cati ipan mosehuía. Quichijque ica miyac tescat ten bronce cati sihuame momajtoyaj quitequihuíaj, pampa sihuame cati tequipanohuayayaj campa icalte nopa yoyon tiopamit quihualicaque inintesca huan temacaque. ");
INSERT INTO nchBl_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Teipa Bezaleel quichijchijqui se calixpamit cati quiyahualo nochi nopa yoyon tiopamit. Huan tzactoya nopa calixpamit ica cortinas quej se tepamit. Huan nopa cortinas cati quitzajqui nopa calixpamit ica sur quipixqui 45 metros ihuehueyaca. Huan quichijqui nopa cortinas taxinepaloli ica icpat ten lino nelía canactzi. ");
INSERT INTO nchBl_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Huan ica sur tatzquitoyaj nopa cortinas ipan 20 taquetzalme ica 20 inincuatetonyo ten bronce huan inintepos chijcolhua huan inianillos ten plata. ");
INSERT INTO nchBl_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Huan ica norte nopa cortinas cati mochijqui nopa tatzacti quipixqui 45 metros ihuehueyaca, huan tatzquitoyaj ipan 20 taquetzalme, huan 20 inincuatetonyo ten bronce ica inintepos chijcolhua huan inianillos ten plata. ");
INSERT INTO nchBl_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Huan campa temo tonati nopa cortinas cati quitzajqui nopa lado quipixqui 22 metros huan tajco ihuehueyaca, huan quipixqui 10 taquetzali, huan 10 cuatetomit para ipan tatzquis. Huan nopa taquetzali, huan inintepos chijcolhua huan inianillos nochi elqui ten plata. ");
INSERT INTO nchBl_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Huan ica campa quisa tonati nopa cortinas cati quitzajqui nopa lado quipixqui 22 metros huan tajco. ");
INSERT INTO nchBl_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Huan tatajco ten nopa tatzacti campa quisa tonati mocajqui tapojtoc quej caltemit para calaquise ipan calixpamit. Huan ipan se lado campa calaquise eltoya se cortina cati quipiyayaya 7 metros ihuehueyaca, huan eyi taquetzali sese ica icuatetonyo para ipan tatzquijque. ");
INSERT INTO nchBl_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Huan ipan ne se lado ten campa calaquiyayaj nojquiya eltoya se cortina cati quipiyayaya 7 metros ihuehueyaca, huan 3 taquetzali huan sesen ica icuatetonyo para ipan tatzquijque. ");
INSERT INTO nchBl_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Huan nochi nopa cortinas cati mochijqui nopa tatzacti cati eltoya yahualtic ten nopa calixpamit mochijtoya ica yoyomit taxinepaloli ten lino icpat cati canactzi. ");
INSERT INTO nchBl_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Huan icuatetonyo sesen taquetzali eliyaya ten bronce, huan itepos chijcolhua huan ianillos eliyaya ten plata. Huan iixco sesen taquetzali quiixalti ica plata. Huan nochi nopa tepos barras para ipan quicuapilose nopa cortinas eliyaya ten plata. ");
INSERT INTO nchBl_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Huan campa nopa cortina cati quitzacuayaya campa calaquij ipan nopa calixpamit elqui taxinepaloli ica lino icpat cati nelcanactzi huan icpat cati azultic, morado huan chichiltic. Nochi ya ni quichijchijqui se cati quimatiyaya taxinepalohua. Huan nopa cortina eliyaya 9 metros ihuehueyaca huan 2 metros 25 centímetros ihuejcapanca san se quej nopa sequinoc cortinas cati quiyahualojque nopa calixpamit. ");
INSERT INTO nchBl_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Huan campa calaquiyayaj quipixqui 4 taquetzali, sese ica icuatetonyo ten bronce para ipan moquetzas. Huan itepos chijcolhua huan ianillos nopa taquetzalme eliyaya ten plata huan itzonco sesen taquetzali nojquiya quiixalti ica plata. ");
INSERT INTO nchBl_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Huan nochi estacas eltoya ten nopa teposti bronce huan quitequihui para quiilpis huan quitetzilos nopa tiopamit. Huan nopa cortina tatzacti quiyahualo nopa calixpamit. Huan nopa calixpamit quiyahualo nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Huan ya ni nopa cuenta ten nopa yoyon tiopamit para elis ichaj nopa caxa ica itanahuatil TOTECO. Huan quichijque nochi quej Moisés tanahuatijtoya. Huan Itamar, icone totajtzi Aarón, tayacanqui para quiitztiyas sesen tequit. Huan nopa levitame quiijcuilojque quesqui imiyaca sesen tamanti quitequihuijtoyaj para quichihuase nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Huan Bezaleel, icone Uri huan iixhui Hur ipan nopa hueyi familia Judá, tayacanqui para quichihuas iixcopinca sesen tamanti senquisa quej TOTECO quinahuati Moisés ma quisencahua. ");
INSERT INTO nchBl_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Huan quipalehui Aholiab, icone Ahisamac, cati tacatqui ipan nopa hueyi familia Dan. Huan Aholiab eliyaya se tepos tejtzonquet para tayejyectalis, huan se cuali taxinepalojquet ica icpat. Huan quimatqui quichihuas yejyectzi yoyomit cati quipixqui itajtzonyo ica lino icpat cati canactzi huan icpat cati azultic, morado huan chichiltic. ");
INSERT INTO nchBl_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Nochi oro cati motequihui para nochi tamanti ipan nopa tiopamit eliyaya oro cati israelitame quimacatoyaj TOTECO. Huan ietica quipano 965 kilos quej nopa tatamachihuali cati quitequihuijque ipan nopa tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Huan imiyaca plata cati quitequihuijque quipanoc 3 mil 319 kilos. ");
INSERT INTO nchBl_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Nochi ni plata elqui cati quininanque nopa 603 mil 550 tacame cati moijcuilojque ipan nopa censo pampa ya quiaxitijque 20 xihuit. Sesen ten inijuanti temacaque macuili gramos ten plata quema moijcuilojque. ");
INSERT INTO nchBl_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Quitequihuijque 3 mil 300 kilos ten plata para inincuatetonyo icaltepayo tiopamit huan nopa taquetzalme para cortinas campa calaquise. Ica ni plata quichijque icuatetonyo 100 taquetzalme. Elqui nechca 33 kilos ten plata cati quitequihui ipan icuatetonyo sesen taquetzali. ");
INSERT INTO nchBl_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Huan nopa plata cati mocajqui, quitequihuijque para itepos chijcolhua, ianillos, huan para itzonco sesen ten nopa taquetzalme. ");
INSERT INTO nchBl_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Huan nopa bronce cati nopa israelitame quimacaque TOTECO quipanoc 2 mil 336 kilos ietica. ");
INSERT INTO nchBl_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Huan ica nopa bronce quichijque inincuatetonyo nopa taquetzalme cati quicuataquechi nopa cortinas campa calaquij ipan calixpamit. Huan quichijque nopa taixpamit ten bronce para ipan quitatise tacajcahualisti, huan quichijqui itixic ica ipilteposixtapalhua ten bronce cati ipan quitejque nopa tapiyali para quitatise. Huan nojquiya ica ni bronce quichijqui nochi nopa tamantzitzi cati monequiyaya campa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Nojquiya quitequihui bronce para nopa cuatetomit para taquetzalme cati quicuataquechi nopa cortinas cati quitzajqui nopa calixpamit huan nopa cortinas campa calaquij ipan calixpamit. Huan quitequihui bronce para iestacas para quiilpis huan quitetzilos nopa tiopamit huan nochi nopa taquetzalme. ");
INSERT INTO nchBl_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Nojquiya iniyoyo nopa totajtzitzi cati quitequihuise quema tequitise tiopan calijtic quixinepalojque ica icpat azultic, morado huan chichiltic. Huan quichijque iyoyo Aarón cati tatzejtzeloltic quej TOTECO quinahuatijtoya Moisés. Huan ni yoyomit quitequihuía san quema calaqui ipan tiopamit campa tatzejtzeloltic. ");
INSERT INTO nchBl_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Nojquiya quichijque ipantzajcayo taxinepaloli ica icpat ten oro cati azultic, morado, huan chichiltic huan lino icpat cati nelía canactzi. Huan nochi elqui nelía cuali tasencahuali. ");
INSERT INTO nchBl_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Quicuique se tatecti oro, huan quitejtzonque hasta quichijque se piltepos mecatzi cati nelía canactzi quej icpat. Huan nopa piltepos mecatzi ten oro quixinepalojque ihuaya lino icpat cati canactzi huan icpat cati azultic, morado huan chichiltic. Huan quichijchijqui nopa tequit se cati nelía quimatiyaya tequiti huan nelía yejyectzi mocajqui. ");
INSERT INTO nchBl_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Huan nopa ixpantzajcayot elqui ome pedazos ten yoyomit. Huan nojquiya quichijqui seyoc tatecti para iajcoltipa campa moixnamiquiyaya iyolixco huan icuitapa. ");
INSERT INTO nchBl_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Nojquiya nopa itzinquechilpica cati yejyectzi quichijchijque ica san se yoyomit quej cati quitequihuijque ipan nopa ixpantzajcayot. Nochi eltoya ten nopa piltepos mecatzi ten oro taxinepaloli ica lino icpat nelía canactzi huan ica icpat azultic, morado huan chichiltic. Nochi elqui quej TOTECO quiilhui Moisés. ");
INSERT INTO nchBl_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Huan quichijque piltetzitzi cati yejyectzi cati itoca ónice huan quitali ipan oro. Huan ipani quiijcuilojque inintoca nochi itelpocahua Israel quej se sello cati quipiya tajcuiloli cati nesi. ");
INSERT INTO nchBl_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Huan quitalili iajcoltipa nopa ixpantzajcayot para ica quinelnamiquiltis TOTECO ten itelpocahua Israel. Huan nochi quichijque quej TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nchBl_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Huan nojquiya se cati tahuel quimati tequiti quichijchijqui nopa yolixtzajcayot quej nopa pantzajcayot. Quixinepalo nopa icpat ten oro, lino icpat ihuaya icpat cati azultic, morado huan chichiltic. ");
INSERT INTO nchBl_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Huan quihuilpacho nopa yolixtzajcayot huan quichijqui se bolsa cati cuadrado. Ihuehueyaca huan ipatajca eltoya 22 centímetros. ");
INSERT INTO nchBl_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Huan iyolixco oncayaya nahui tatilimit ten piltetzitzi cati yejyectzitzi. Ipan nopa achtohui pamit quitatzquiltilijque se piltetzi cati itoca rubí, se topacio huan se sardónice. Ya ni elqui nopa achtohui tatilimit. ");
INSERT INTO nchBl_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Huan ipan nopa ompa tatilimit quitalilijtoya se esmeralda, se zafiro huan se diamante. ");
INSERT INTO nchBl_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Huan ipan nopa expa tatilimit quitatzquiltijque se jacinto, se ágata huan se amatista. ");
INSERT INTO nchBl_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Huan ipan nopa najpa tatilimit quitatzquiltijque se berilo, se ónice huan se jaspe. Huan mocajqui nochi ni piltetzitzi tatzquitoque ipan ininpiltencuayohua ten oro cati mocahua inintejteno huan cati quiyecchijtoyaj. ");
INSERT INTO nchBl_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Huan imiyaca nopa piltetzitzi elqui 12 quej inimiyaca itelpocahua Israel. Huan sese elqui quej se pilsellojtzi cati quichihua itoca se itelpoca Israel. ");
INSERT INTO nchBl_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Nojquiya quichijque para nopa yolixtzajcayot ipiltajco ilpicayo cati taxinepaloli ten oro. ");
INSERT INTO nchBl_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Huan quichihuili nopa yolixtzajcayot ome anillos ten oro oncac ipan iesquina cati huejcapa huan nopona quicalaqui nopa piltajco ilpicayotzi huan quitatzquiltili nopa yolixtzajcayot ica cati eltoc iajcoltipa ipan nopa ixpantzajcayot. ");
INSERT INTO nchBl_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Huan quitatzquiltijque oncac nopa ome piltajco ilpicayotzitzi ten oro cati yejyectzitzi taxinepaloli ipan inacas huejcapa ten nopa yolixtzajcayot. Huan teipa seyoc iteno nopa piltajco ilpilcayotzi quitatzquilti ipan sese anillo iajcoltipa ipan nopa ixpantzajcayot. ");
INSERT INTO nchBl_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Huan quitalijque oncac ni ome ipiltajco ilpicayo ten oro cati tayecchihuali, se ipan sesen ten nopa ome anillo cati eltoc iajcoltipa huan ica quitatzquiltilijque iyolixco nopa yolixtzajcayot ica iajcoltipa nopa ixpantzajcayot. ");
INSERT INTO nchBl_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Huan quichijque seyoc ome anillo ten oro cati quitatzquiltilijque ipan sese lado ipan itejteno nopa yolixtzajcayot. ");
INSERT INTO nchBl_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Nojquiya quichijque ome anillos ten oro cati quitatzquiltijque tatzinta ipan cati elqui iajcoltipa huan teipa quisalojque seyoc iteno ihuaya itzinquechilpica. ");
INSERT INTO nchBl_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Huan quinechicojque nopa yolixtzajcayot ica nopa ixpantzajcayot huan quiilpijque ica se listój azultic para ma motali cuali ipan nopa ixpantzajcayot itzinquechilpica para nochipa san sejco tatzquitose nopa yolixtzajcayot ica nopa ixpantzajcayot huan amo papatacas. Huan nochi quichijqui senquisa quej TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nchBl_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Huan nojquiya quichihuili nopa totajtzi iyoyo cati huehueyac cati mocajqui tatzinta ten nopa ixpantzajcayot, huan quichijqui nochi ica yoyomit azultic. ");
INSERT INTO nchBl_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Huan quiquechtejqui campa calaquis itzonteco huan quiyahualojque campa quiquechtectoya ica se yejyectzi tajtzonti cati tayahualoli para amo tzayanis. ");
INSERT INTO nchBl_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Huan itejteno iyoyo huehueyac quichihuili se tajtzonti ica iixcopinca nopa cuatacti cati itoca granada. Quiixcopinqui quema quixinepalo lino icpat huan icpat azultic, morado huan chichiltic. ");
INSERT INTO nchBl_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Nojquiya quichihuilijque pilcampanajtzitzi cati senquisa oro, huan quiilpijque tatajco nopa granadas. Huan quej nopa yajtiyajqui ipan nochi itejteno iyoyo. ");
INSERT INTO nchBl_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Quipixqui se pilcampanajtzi huan se granada, seyoc pilcampanajtzi huan seyoc granada ipan nochi itejteno icuex iyoyo huehueyac. Huan nopa totajtzi motalili nopa yoyomit quema quitequipano TOTECO tiopan calijtic. Huan nochi quichijque senquisa quej TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nchBl_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Huan para Aarón huan itelpocahua quinchihuilijque inintatzintayoyo ica yoyomit ten lino cati nelcanactzi. ");
INSERT INTO nchBl_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Nojquiya quixinepalojque nopa cuatzajcayot ica icpat ten lino cati nelcuali, huan quiyectalijque nopa yoyomit para inincuaixco ica icpat ten lino cati nelía cuali, huan quichijque inintatzintayoyo nojquiya ica icpat tamalinti ten lino huan nelía canactzi. ");
INSERT INTO nchBl_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Nojquiya quichijque inintzinquechilpicayo ica lino icpat nelcanactzi huan icpat cati azultic, morado huan chichiltic. Huan quichijque yejyectzi itajtzonyo senquisa quej TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nchBl_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Nojquiya quichijqui se piltatectzi ten oro para quitalis ipan icuatzajca huan ipani tajcuilojque quej se sello cati quiijto: TAIYOCATALILI PARA TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Huan quiilpijque ica se icpat azultic huan quitalijque iixpa nopa cuatzajcayot senquisa quej TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nchBl_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Huan quej ni tanqui nochi nopa tequit cati quichihuayayaj para quichihuase nopa yoyon tiopamit campa mopantise ihuaya TOTECO. Huan nochi quichijque nopa israelitame senquisa quej TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nchBl_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Huan nochi nopa tiopamit ica nochi tamanti cati quichijtoyaj quihualiquilijque Moisés. Quihualiquilijque nopa yoyon Cali cati quichijtoyaj ica nopa tetic yoyomit cati taxinepaloli ica iniijhuiyo oquich chivojme. Quihualicaque nopa cuamesas, tepos chijcolme, huapalme, cuaixtapali, taquetzalme huan icuatetonyo. ");
INSERT INTO nchBl_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Quihualiquilijque itzontzajca cati quichijtoyaj ica inincuetaxo oquich borregojme cati quipajtoyaj chichiltic, huan itzontzajca cati quichijtoyaj ica inincuetaxo pesojme huan nojquiya nopa cortinas ten ica quitzacuas nopa cuarto campa eltoya nopa caxa. ");
INSERT INTO nchBl_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Quihualicaque nopa caxa huan cuahuit huehueyac para ica quihuicase, huan itzajca, ");
INSERT INTO nchBl_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","huan nopa cuamesa ica nochi cati motequihuis ipani, huan nopa pantzi cati quitalíaj ipan nopa mesa para tenextilis Toteco itztoc tohuaya. ");
INSERT INTO nchBl_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Nojquiya quihualicaque nopa taahuil quetzali ten oro ica nochi itaahuilhua cati quitalilijtoyaj sesen campa monequiyaya huan nojquiya quihualicaque nochi nopa tamantzitzi cati monequi quitequihuise ica nopa taahuil quetzali ihuaya nopa aceite cati quitequilise para ma tata. ");
INSERT INTO nchBl_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Huan quihualicaque nopa taixpamit ten oro, ihuaya nopa copali cati ajhuiyac huan nopa aceite para taiyocatalise, huan nopa cortina para quicuapilose campa calaquise. ");
INSERT INTO nchBl_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Quihualicaque nopa taixpamit ten bronce huan nochi cati nopona motequihuía. Nojquiya quihualicaque itixic ten bronce huan nopa cuahuit huehueyac para ica quihuicase. Huan nochi quiixaltijtoyaj ica bronce. Nojquiya quihualicaque nopa hueyi paila huan icuayo cati ipan momajtequise totajtzitzi. ");
INSERT INTO nchBl_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Quihualicaque nopa cortinas cati mochihuas itzajca nopa calixpamit, ihuaya itaquetzalo huan itepos cuatetonyo. Nojquiya quihualicaque nopa cortinas para campa caltemit campa calaquise ipan calixpamit, huan nopa lazos huan estacas para quiilpise huan quitetzilose sesen taquetzali, huan nochi tamanti cati motequihuis tiopan calijtic. ");
INSERT INTO nchBl_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Nojquiya quihuiquilijque Moisés para ma quiita iyejyejca iniyoyo nopa totajtzitzi cati moquentise quema calaquise para tequitise tiopan calijtic campa tatzejtzeloltic. Quihualiquilijque nopa yoyomit cati tatzejtzeloltic para nopa hueyi totajtzi Aarón, ihuaya nopa yoyomit para itelpocahua quema quichihuase inintequi tiopan calijtic. ");
INSERT INTO nchBl_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Huan nopa israelitame quichijque nochi senquisa quej TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nchBl_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Huan quema Moisés quitachili nochi cati quichijtoyaj, quiitac para quichijtoyaj senquisa quej TOTECO tanahuatijtoya, huan quintiochijqui nochi inijuanti cati quichijchijtoyaj. ");
INSERT INTO nchBl_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Teipa TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Xijquetza nopa yoyon tiopamit campa timopantise ipan nopa achtohui tonali ipan nopa achtohui metzti ten nopa yancuic xihuit ipan amocalendario. ");
INSERT INTO nchBl_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Huan ipan nopa yoyon tiopamit ipan nopa cuarto más calijtic, xijtali nopa caxa, huan xijtzacua campa calaquise ipan nopa cuarto ica nopa cortina. ");
INSERT INTO nchBl_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Huan ipan nopa seyoc cuarto cati amo más calijtic, xijcalaqui nopa cuamesa para pantzi huan xijtali campa monequi. Teipa xijcalaqui nopa taahuil quetzali huan xijtati. ");
INSERT INTO nchBl_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","“Huan nojquiya ipan nopa cuarto cati amo más calijtic, xijtali nopa taixpamit ten oro campa quitatise copali huan nopa taixpamit ten copali mocahuas iixmelac nopa caxa cati eltoc ipan nopa cuarto cati más calijtic. Huan xijcuapilo seyoc cortina campa calaquise ipan nopa achtohui cuarto cati amo más calijtic huan ni cortina elis iixmelac nopa taixpamit ten oro huan quitzacuas campa calaquise ipan nopa cuarto cati amo más calijtic. ");
INSERT INTO nchBl_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Huan ipan nopa calixpamit, xijtali nopa taixpamit campa quitatise tacajcahualisti. Huan moquetzas iixmelac nopa cortina campa calaquise ipan nopa cuarto cati amo más calijtic. ");
INSERT INTO nchBl_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Teipa tatajco ten nopa yoyon tiopamit huan nopa taixpamit, xijtali nopa hueyi paila cati quitequilise at para momajtequise. ");
INSERT INTO nchBl_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Huan teipa xijquetza nopa tatzacti ten cortinas para xijchihua icalixpayo yahualtic nopa yoyon tiopamit. Huan cati campa calaquise ipan calixpamit, xijcuapilo nopa seyoc cortina. ");
INSERT INTO nchBl_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Huan xijcui nopa aceite cati ica teajaltise para taiyocatalise para TOTECO. Huan xiquijtzelhuili nopa yoyon tiopamit huan nochi cuamesas cati eltoc ipani. Xiquijtzelhuili nochi cati quitequihuise nopona. Huan nochi mocahuas tatzejtzeloltic, taiyocatalili para na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Teipa xiquijtzelhuili nopa taixpamit campa quitatise tacajcahualisti huan nochi cati motequihuía ihuaya. Huan quej nopa moiyocatalijtos nopa taixpamit huan elis tahuel tatzejtzeloltic. ");
INSERT INTO nchBl_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Nojquiya xiquijtzelhuili nopa hueyi paila campa momajtequise huan icuayo ten bronce huan quej nopa tiquiyocatalis huan tijchihuas tatzejtzeloltic para na. ");
INSERT INTO nchBl_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Huan xijhuica Aarón ihuaya itelpocahua ipan nopa calixpamit hasta iixmelac campa calaquise ipan nopa yoyon tiopamit campa timopantise, huan nopona ma maltica ica at. ");
INSERT INTO nchBl_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Huan xijyoyonti Aarón ica nopa yoyomit tatzejtzeloltic. Huan xicajalti ica aceite para tiquiyocatalis para techtequipanos quej nototajtzi cati más hueyi. ");
INSERT INTO nchBl_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Teipa xiquinhuica itelpocahua, huan xiquinyoyonti ica nopa yoyomit huehueyac cati anquinchijchihuilijque. ");
INSERT INTO nchBl_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Huan xiquinajalti aceite quej tijchijqui ica inintata, huan inijuanti nojquiya techtequipanose quej totajtzitzi. Huan quema tiquinajaltis aceite, pehuas se familia ten totajtzitzi cati amo tamis pampa iniixhuihua elise nototajtzitzi para nochipa.” ");
INSERT INTO nchBl_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Huan Moisés quichijqui nochi senquisa quej TOTECO quinahuatijtoya. ");
INSERT INTO nchBl_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Huajca ipan nopa achtohui tonali, ipan nopa achtohui metzti quema yahuiyaya para ome xihuit quistoyaj ipan tali Egipto, quiquetzque nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Huan quema Moisés quiquetzqui nopa yoyon tiopamit, quiquetzqui itepos cuatetonyo, ihuapalhua, huan quicalaqui icuaixtapalhua huan itaquetzalhua. ");
INSERT INTO nchBl_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Teipa quipatajque nopa cortina para quitzontzacuase, huan nojquiya nopa seyoc itzontzajca quitali san quej TOTECO quinahuatijtoya. ");
INSERT INTO nchBl_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Teipa quicuic nopa ome tepatacti cati quipixtoya itanahuatilhua TOTECO huan quitali ipan nopa caxa. Teipa quicalaqui nopa cuahuit huehueyac para ica quihuicase campa monequiyaya. Huan iixco quitali itzajca campa nopa totajtzi quinixtzacuilis inintajtacolhua masehualme iixpa TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Quema ya eltoya tasencahuali nopa caxa, quicalaqui ipan nopa cuarto cati más tiopan calijtic, huan quicuapilo nopa cortinas para quitzacuas nopa cuarto cati quipixtoya nopa caxa san quej TOTECO quinahuatijtoya. ");
INSERT INTO nchBl_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Teipa ica norte ipan nopa achtohui cuarto cati amo más calijtic, quitali nopa cuamesa. Nopa cuarto eltoc iixpa nopa yejyectzi Cortina. ");
INSERT INTO nchBl_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Huan ipan nopa cuamesa quitenqui nopa pantzi iixpa TOTECO senquisa quej TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nchBl_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Huan nojquiya ipan nopa cuarto cati amo más calijtic, ica sur quitali nopa taahuil quetzali iixmelac nopa cuamesa para pantzi. ");
INSERT INTO nchBl_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Huan quintati nopa taahuilme iixpa TOTECO quej TOTECO quinahuatijtoya ma quichihua. ");
INSERT INTO nchBl_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Huan ipan nopa cuarto nojquiya quitali nopa taixpamit ten oro. Huan quiquetzqui iixmelac nopa cortina cati quitzacuayaya nopa cuarto cati más calijtic. ");
INSERT INTO nchBl_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Huan ipan nopa taixpamit ten oro quitati nopa copali cati ajhuiyac quej TOTECO quinahuatijtoya. ");
INSERT INTO nchBl_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Nojquiya Moisés quicuapilo se cortina para quitzacuas campa calaquise ipan nopa cuarto cati amo más calijtic ipan nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Huan ipan nopa calixpamit iixmelac campa calaquise ipan nopa yoyon tiopamit, quitali nopa taixpamit campa quitatise tacajcahualisti. Huan ipan quintatijque tapiyalme para tacajcahualisti. Nojquiya quitati tacajcahualisti ten harina quej TOTECO quinahuatijtoya. ");
INSERT INTO nchBl_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Huan ipan nopa calixpamit cati eltoc tatajco ten nopa yoyon tiopamit huan taixpamit campa quitatise tacajcahualisti, quitali nopa hueyi paila, huan quitequili at para nopona ma moicxipajpacaca huan ma momajtequica totajtzitzi. ");
INSERT INTO nchBl_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Huan Moisés inihuaya Aarón huan itelpocahua nopona momajtequijque huan moicxipajpajque. ");
INSERT INTO nchBl_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Huan sesen huelta quema inijuanti calaquiyayaj ipan nopa yoyon tiopamit o sinta quinechcahuiyayaj nopa taixpamit campa quitatise tacajcahualisti, monequiyaya mopajpacase quej TOTECO tanahuatijtoya. ");
INSERT INTO nchBl_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Teipa Moisés quiquetzqui nopa tatzacti ten cortinas cati quitzajqui nopa calixpamit yahualtic ten nopa yoyon tiopamit huan nopa taixpamit. Huan campa calaquij ipan calixpamit, quicuapilo nopa cortina para elis quej se caltemit. Huan ica ya nopa Moisés quitamilti nopa tequit. ");
INSERT INTO nchBl_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Huan se mixti quisentzajqui nopa yoyon tiopamit. Huan itatanex TOTECO cati nelía yejyectzi quitemiti nopa tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Huan Moisés amo huelqui calaqui tiopan calijtic pampa nopa mixti motalijtoya nopona. Huan itatanex TOTECO cati tahuel cahuaniyaya quisentzajqui nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Huan ipan nopa tonali quema nopa israelitame nentinemiyayaj campa hueli, sinta nopa mixti quitalcahuiyaya nopa yoyon tiopamit, nopa israelitame quitananayayaj nopa yoyon tiopamit campa mopantiyayaj ihuaya TOTECO huan quitoquiliyayaj nopa mixti. ");
INSERT INTO nchBl_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Pero sinta nopa mixti amo mijcueniyaya, inijuanti nojquiya amo mijcueniyayaj hasta quema nopa mixti sempa mijcuenisquía. Huan huajca, quena, quema mijcuenisquía, inijuanti quitoquilisquíaj. ");
INSERT INTO nchBl_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Huan quej nopa elqui ipan nochi iniojhui. Tonaya nopa mixti ten TOTECO motaliyaya itzompac nopa tiopamit huan tayohua mochihuayaya quej se tit huan yeca nopa israelitame hueliyayaj tachiyase tonaya huan tayohua.");
INSERT INTO nchBl_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","TOTECO quinotzqui Moisés ten nopa yoyon tiopamit campa mopantiyayaj huan quiilhui: ");
INSERT INTO nchBl_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Xiquinilhuiti nopa israelitame ni tanahuatilme. Quema anquinequise antechhualiquilise se tacajcahualisti na, niamoTECO, monequi antechhualiquilise se ten amohuacaxhua, o se ten amoborregojhua o se ten amochivojhua. ");
INSERT INTO nchBl_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“Sinta elis se tacajcahualisti tatatili ten amohuacaxhua, huajca monequi antechmacase se becerro cati amo quipiya yon se tamanti cati amo cuali ipan itacayo. Monequi anquihuicase nopa tapiyali noixpa hasta campa icalte nopa yoyon tiopamit campa timopantíaj huan quej nopa na, niamoTECO, nijselis. ");
INSERT INTO nchBl_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Huan nopa masehuali cati quihualica quitalis imax ipan itzonteco nopa tapiyali, huan quej nopa, nopa tapiyali elis ipataca nopa masehuali. Huan na nijselis nopa tacajcahualisti huan niquitas para mijqui por nopa masehuali para quiixtzacuilis itajtacolhua noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Huan nopa masehuali quimictis nopa tapiyali nopona noixpa, niamoTECO. Huan itelpocahua Aarón, nopa totajtzitzi, quiijtzelose ieso nopa tapiyali yahualtic nopa taixpamit cati eltoc nechca icalte nopa yoyon tiopamit huan quej nopa techmacase. ");
INSERT INTO nchBl_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Huan nopa masehuali quiquixtilis icuetaxo nopa tapiyali cati elis quej se tacajcahualisti tatatili huan quihuejhuelos itacayo. ");
INSERT INTO nchBl_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Teipa itelpocahua Aarón, nopa totajtzitzi, tipitzase huan quitalise miyac cuahuit ipan nopa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Huan teipa itelpocahua Aarón quitalise nochi nacat tahuejhueloli ten nopa tapiyali ihuaya itzonteco huan ichiyajca ipan nopa cuahuit cati lementos. ");
INSERT INTO nchBl_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Pero achtohui quipajpacase icuetaxcol huan iquescuayohua nopa tapiyali huan teipa nopa totajtzitzi quitalise icuetaxcol huan iquescuayohua ipan nopa taixpamit para ma tata. Huan ya ni elis se tacajcahualisti tatatili cati mijyotis nelía ajhuiyac noixpa huan techyolpactis, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“Huan sinta nopa tapiyali cati temacas para se tacajcahualisti tatatili elis se borrego o se chivo, huajca monequi elis se oquichti cati amo quipiya yon se tamanti cati amo cuali ipan itacayo. ");
INSERT INTO nchBl_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Huan nopa masehuali cati quihualica nopa tacajcahualisti moquetzas nechca iquespa nopa taixpamit ipan nopa lado norte huan quimictis nopa tapiyali noixpa, na niamoTECO. Huan itelpocahua Aarón, nopa totajtzitzi, quicuise ieso nopa tapiyali huan ica quiatzejtzelhuise yahualtic nopa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Huan nopa masehuali cati temaca nopa tacajcahualisti, quihuejhuelos, huan nopa totajtzi quicuis nopa tapiyali itzonteco huan ichiyajca, huan quitalise ipan tit. ");
INSERT INTO nchBl_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Pero nopa masehuali cati temacas nopa tapiyali monequi achtohui quipajpacas icuetaxcol huan iquescuayohua. Huan teipa quema ya quipajpactos, nopa totajtzitzi quitatise ipan nopa taixpamit. Huan elis se tacajcahualisti tatatili cati mijyotis nelía ajhuiyac huan techyolpactis, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“Pero sinta acajya quinequi techmacas na, niamoTECO, se totot quej se tacajcahualisti, huajca hueli techmacas se paloma o se pichontzi. ");
INSERT INTO nchBl_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","“Huan nopa totajtzi quihuicas nopa paloma o nopa pichontzi campa nopa taixpamit huan quiquechhuilacatzos hasta quicotonas itzonteco huan quitatis itzonteco ipan taixpamit. Teipa quicahuilis ma quisa ieso nopa paloma ielchiquitipa nopa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Huan teipa nopa totajtzi quicuis iapompo huan iijhuiyo nopa piltototzi huan quinmajcahuas ielchiquitipa nopa taixpamit ica campa quisa tonati campa eltoc nopa cuajnexti. ");
INSERT INTO nchBl_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Teipa quiitzquis ipan ieltapalhua huan quitajcotequis, pero amo quicotonas. Teipa nopa totajtzi temacas nopa paloma quej se tacajcahualisti huan quitatis ipan tit cati eltoc ipan nopa taixpamit. Huan elis se tacajcahualisti tatatili cati mijyotis ajhuiyac huan techyolpactis, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“Quema se masehuali quinequis techmacas na, niamoTECO, se tacajcahualisti ten harina ten trigo o cebada, monequi quicuechtilis iyol hasta mochihuas se harina cati nelía cuechtic. Nojquiya monequis quitequilis aceite huan copali nopa harina. ");
INSERT INTO nchBl_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Teipa quimacas se itelpoca Aarón huan nopa totajtzi quicuis se quentzi nopa harina ica imax huan quitatis ipan nopa taixpamit quej se tanextili para ipan nopa talojtzi techmaca nochi nopa tacajcahualisti. Huan ya ni elis se tacajcahualisti tatatili cati mijyotis ajhuiyac noixpa na, niamoTECO, huan techyolpactis. ");
INSERT INTO nchBl_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Huan nochi nopa harina cati mocahuas ten nopa tacajcahualisti tatatili elis iniaxca Aarón huan itelpocahua, nopa totajtzitzi para quicuase. Huan nochi elis se tacajcahualisti cati tahuel tatzejtzeloltic para na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“Huan sinta acajya quinequi techmacas se tacajcahualisti ten harina cati taicxitili ipan horno, huajca monequi quicuechtilis iyol hasta mochihuas se harina cati nelía cuechtic, huan quimanelos ica aceite para quichihuas se pantzi, pero amo hueli quipiyas tasonejcayot. Nojquiya se masehuali hueli techmacas pantzi cati quej se taxcali huan cacatztic cati amo quipiya tasonejcayot huan san taajaloli ica aceite. ");
INSERT INTO nchBl_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","“Huan sinta nopa tacajcahualisti ten harina eli taicxitili ipan se comali, huajca nojquiya monequi elis tachijchihuali ica harina cati nelía cuechtic cati amo quipiyas tasonejcayot huan cati tamaneloli ica aceite. ");
INSERT INTO nchBl_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Huan teipa monequi quihuejhuelos nopa pantzi huan ipani quitoyahuas aceite. Huan ya ni nojquiya elis se tacajcahualisti ten harina. ");
INSERT INTO nchBl_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","“Huan sinta nopa tacajcahualisti ten harina elis se pantzi cati taicxitili ipan sartén, huajca nojquiya monequi elis tachijchihuali ica harina cati nelía cuechtic huan tamaneloli ica aceite. ");
INSERT INTO nchBl_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Huan quema se masehuali quihualicas se tacajcahualisti para na, niamoTECO, cati taicxitili ipan horno, comali o sartén, monequi quimactilis nopa totajtzi huan yaya quihuicas campa nopa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","“Huan nopa totajtzi quicuis san se quentzi ten nopa tacajcahualisti ten harina para quitatis para na ipan nopa tit ipan taixpamit. Huan nopa pocti ten nopa tit mijyotis ajhuiyac huan techpactis, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Huan nochi cati mocahua ten nopa tacajcahualisti tatatili elis iniaxca nopa totajtzitzi, Aarón huan itelpocahua, para quicuase. Huan nochi elis se tacajcahualisti tahuel tatzejtzeloltic para na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“Yon se tacajcahualisti ten harina cati antechhualiquilise, amo quema huelis quipiyas tasonejcayot, yon sayolnecti. Pampa yon se tamanti cati anquitatise ipan taixpamit para antechmacase amo hueli quipiyas tasonejcayot, yon sayolnecti. ");
INSERT INTO nchBl_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Pero quema ajsis nopa ilhuit quema anquipixcase amomil, huelis antemacase tacajcahualisti ten harina cati quipiya tasonejcayot huan sayolnecti. Pero sinta quipiya tasonejcayot o sayolnecti, amo hueli anquitatise quej se tacajcahualisti cati ajhuiyac mijyotis noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","“Nojquiya monequi anquitalise istat ipan nochi tacajcahualisti cati quipiya harina, pampa istat eli se tanextili cati amechelnamiquiltía ten nopa camanali cati na, niamoTeco Dios, nijchijqui amohuaya. Huajca nochipa monequi antechmacase istat ica amotacajcahualis. ");
INSERT INTO nchBl_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“Sinta anquinequij antechmacase, se tacajcahualisti ten nopa cati achtohui anquipixcaque ipan mili, huelis se tamanti quej trigo o cebada iyol, monequi xijyolquixtica huan xijcacatztilica ipan tit. ");
INSERT INTO nchBl_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Huan ipan nopa tacajcahualisti xijteca aceite huan copali. Ya nopa nojquiya elis se tacajcahualisti ten harina. ");
INSERT INTO nchBl_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Huan nopa totajtzitzi quicuise se quentzi ten nopa tacajcahualisti cati tamaneloli ica aceite huan copali para quitatise noixpa para techmacase. Huan quema quichihuase ya nopa, quiixnextise para nochi nopa tacajcahualisti eli tatzejtzeloltic huan noaxca na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“Sinta se masehuali quinequis techmacas na, niamoTECO, se tacajcahualisti para moyoltalis ica na, huelis techmacas se toro o se huacax. Pero nopa tapiyali monequi elis tapajpactic. Amo quipiyas yon se tamanti cati amo cuali ipan itacayo. ");
INSERT INTO nchBl_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Huan nopa masehuali cati quihualicas nopa tacajcahualisti quitalis imax ipan nopa tapiyali itzonteco huan quimictis nopona nechca caltemit ten nopa yoyon tiopamit. Huan itelpocahua Aarón, nopa totajtzitzi, quicuise nopa esti huan quiajtzelhuise yahualtic ten nopa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","“Huan ten nopa tacajcahualisti quicuise cati techmacase na, niamoTECO ipan tit. Quicuise nopa tachiyajcayot cati eltoc iijtico, huan nopa tachiyajcayot cati eltoc ipan icuetaxcol. ");
INSERT INTO nchBl_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Huan quicuise nopa ome ieyo ica nochi ichiyajca, huan nopa parte cati más hueyi ten ieltapach huan quiquixtise san sejco ica ieyo. ");
INSERT INTO nchBl_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Huan nochi ya ni itelpocahua Aarón, nopa totajtzitzi, quitatise para na, niamoTECO, ipan nopa tit ipan taixpamit. Huan elis se tacajcahualisti cati ajhuiyac mijyotis huan techpactis. ");
INSERT INTO nchBl_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“Huan sinta se masehuali quinequis techmacas tacajcahualisti para moyoltalis ica na, monequi techmacas se chivo o se borrego. Huelis techmacase se sihuatzi o se oquichti. Pero monequi nopa tapiyali elis tapajpactic. Amo hueli techmacas yon se tapiyali cati quipiya se tamanti cati amo cuali ipan itacayo. ");
INSERT INTO nchBl_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Huan san se quichihuas sinta nopa tacajcahualisti cati techmacas elis se pilborregojtzi. ");
INSERT INTO nchBl_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Nopa masehuali cati temacas, quitalis imax ipan nopa tapiyali itzonteco, huan quimictis nopona campa icalte nopa yoyon tiopamit. Teipa nopa totajtzitzi quicuise se quentzi esti huan quiajtzelhuise yahualtic ten nopa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","“Huan ipan nopa taixpamit quitalise nochi ichiyajca. Quitalise icuitapil cati quipiya miyac ichiyajca huan quicotonase nechca icuitapa nopa tapiyali. Nojquiya quitalise nochi ichiyajca cati mopantía iijtico huan tatajco ten icuetaxcol. ");
INSERT INTO nchBl_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Quitatis ieyo ica nochi ichiyajca huan nopa parte cati más hueyi ten ieltapach cati quiquixtise san sejco ica ieyo. ");
INSERT INTO nchBl_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Huan nochi ni tamanti nopa totajtzi quitatis ipan nopa taixpamit, huan ya ni elis se tacajcahualisti ten tacualisti cati techmacase, na niamoTECO, ipan tit. ");
INSERT INTO nchBl_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“Sinta se acajya quinequi quihualicas se sihua chivo para techmacas, ");
INSERT INTO nchBl_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","huajca nopa masehuali quitalis imax ipan nopa tapiyali itzonteco, huan teipa quimictis nopona nechca icalte nopa yoyon tiopamit campa timopantíaj. Huan nopa totajtzitzi quicuise se quentzi ieso nopa tapiyali huan quiajtzelhuise yahualtic ten nopa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","“Huan quiquixtilise nopa tapiyali nopa tachiyajcayot cati eltoc iijtico, huan nochi nopa tachiyajcayot cati eltoc ipan icuetaxcol, huan quitalise ipan nopa taixpamit para techmacase ipan tit. ");
INSERT INTO nchBl_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Nojquiya quitalise nopa ome ieyo huan nopa tachiyajcayot cati eltoc ipani. Huan quitalise nopa parte cati más hueyi ten ieltapach cati quiquixtise ihuaya ieyo. ");
INSERT INTO nchBl_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Huan ya ni elis se tacajcahualisti cati nopa totajtzi techmacas, niamoTECO, ipan tit huan mijyotis ajhuiyac huan techpactis. Nochi tachiyajcayot elis noaxca na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“Quena, ya ni elis se tanahuatili cati monequi anquitepanitase, amojuanti huan nochi amoixhuihua masque campa hueli anmopantíaj: Amo xijcuaca esti, yon tachiyajcayot.” ");
INSERT INTO nchBl_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Huan teipa TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Xiquinilhui nopa israelitame ni tanahuatilme. Sinta se ten amojuanti tajtacolchihuas huan quiixpanos se notanahuatil na, niamoTECO, huan amo quimati sinta taixpano, ya ni cati monequi quichihuas. ");
INSERT INTO nchBl_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“Sinta elis nopa hueyi totajtzi cati tajtacolchihuas masque amo quimatiyaya, quinchihuas para nopa sequinoc masehualme nojquiya ma quihuicaca tajtacoli huan monequi nopa hueyi totajtzi temacas noixpa se becerro cati amo teno quipiya cati amo cuali ipan itacayo. Ya nopa elis se tacajcahualisti para nopa tajtacoli cati ya quichijtoc. ");
INSERT INTO nchBl_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Huan monequi nopa hueyi totajtzi quihuicas nopa tapiyali campa icalte nopa yoyon tiopamit campa timopantíaj, huan nopona quitalis imax ipan itzonteco nopa tapiyali huan quimictis nopona noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Huan teipa nopa hueyi totajtzi quicuis se quentzi ten nopa tapiyali ieso huan quihuicas ipan nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Huan nopa totajtzi quixolonis imacpil ipan nopa esti huan taatzejtzelhuis chicome huelta noixpa nopona iixmelac nopa cortina cati quitzacua nopa cuarto Campa Más Tatzejtzeloltic. ");
INSERT INTO nchBl_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Teipa nojquiya nopa hueyi totajtzi quiajalos esti nopa nahui icuacua nopa taixpamit campa quitatíaj copali cati mocahua yoyon tiopan calijtic noixpa. Huan nopa esti cati noja mocahua, quitoyahuas talchi itzinta nopa taixpamit para tacajcahualisti tatatili cati eltoc nechca icalte nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Teipa quiquixtilis nochi nopa tachiyajcayot cati eltoc iijtico nopa becerro huan nochi cati eltoc ipan icuetaxcol. ");
INSERT INTO nchBl_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","Nojquiya quiquixtis nopa ome ieyo ihuaya ininchiyajca huan nopa parte cati más hueyi ten ieltapach cati quiquixtis ica sempa ica nopa ieyo. ");
INSERT INTO nchBl_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Huan nochi ni tamanti nopa totajtzi techmacas na, niamoTeco, ipan nopa taixpamit para tacajcahualisti tatatili. Quiijtosnequi quichihuas san se quej quichijqui ica nopa becerro cati techmacas quej se tacajcahualisti para moyoltalise ica na. ");
INSERT INTO nchBl_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Pero icuetaxo nopa becerro, huan inacayo, itzonteco, iicxihua, icuetaxcol huan icuit, ");
INSERT INTO nchBl_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","quinequi quiijtos nochi cati mocahua, monequi quicahuatij ipan se lugar cati tapajpacti noixpa huan cati mopantía huejca ten nopa yoyon calme campa anmochijtoque. Quena, quihuicase campa concahuaj nopa cuajnexti ten nopa tacajcahualisti cati quitatíaj ipan taixpamit. Huan nopona quitatise ica cuahuit cati mocahua ten nopa becerro cati elqui nopa tacajcahualisti para nopa tajtacoli cati quichijqui nopa totajtzi. ");
INSERT INTO nchBl_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“Sinta nochi israelitame quichihuase se tajtacoli, o sinta quichihuase se tamanti cati na, niamoTECO, niquinnahuatijtoc ma amo quichihuaca, masque yon se ten inijuanti amo quimatiyaya inta ten nopa tajtacoli, nochi nopa masehualme quihuicase tajtacoli noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Huajca quema quimatise para quichijtoque tajtacoli, monequi quihualicase se becerro huan techmacase quej se tacajcahualisti para tajtacoli. Nopa becerro quihualicase iixpa nopa yoyon tiopamit, ");
INSERT INTO nchBl_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","huan noixpa nopa huehue tacame cati quinyacanaj israelitame quitalise inimax ipan nopa tapiyali itzonteco huan nopona quimictise. ");
INSERT INTO nchBl_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Teipa nopa hueyi totajtzi quicuis se quentzi ieso nopa tapiyali huan quihuicas ipan nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Huan teipa quixolonis imacpil ipan nopa esti huan taatzejtzelhuis chicome hueltas noixpa iixmelac nopa cortina. ");
INSERT INTO nchBl_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Huan nojquiya nopa esti quiajalos nopa nahui icuacua nopa taixpamit cati eltoc noixpa tiopan calijtic. Huan nopa esti cati noja mocahuas quitoyahuas talchi itzinta nopa taixpamit campa temaca tacajcahualisti tatatili. Nopa taixpamit eltoc nechca icalte nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Huan nojquiya quiquixtilis nopa becerro nochi ichiyajca, huan quitatis ipan nopa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Huan san se quichihuas nopa totajtzi ica ni becerro cati temacaj quej quichijqui ica nopa becerro para nopa tacajcahualisti por tajtacoli. Huan quej nopa quichihuas nopa totajtzi para quiixtzacuas nochi nopa tajtacoli cati quichijque nopa israelitame, huan niquintapojpolhuis. ");
INSERT INTO nchBl_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Teipa cati mocahuas ten ni becerro nopa totajtzi quihuicas se quentzi huejca ten campa anmochijtoque. Nopona quitatis quej niquijto quitatisquía ne seyoc becerro. Ya ni elis se tacajcahualisti para nochi inintajtacolhua nochi israelitame. ");
INSERT INTO nchBl_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“Sinta se tayacanquet ten nopa israelitame quichihuas se tajtacoli huan quiixpanos se notanahuatil, niamoTECO Dios, masque amo quimatiyaya, huajca yaya quihuica tajtacoli noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Huajca quema ya quimachilijtos para quichijtoc se tajtacoli, nimantzi ma quihuicas se oquich chivo para techmacas quej se tacajcahualisti. Nopa tapiyali monequi elis tapajpactic. Amo quipiyas cati amo cuali ipan itacayo. ");
INSERT INTO nchBl_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Huan nopa masehuali quitalis imax ipan nopa oquich chivo itzonteco huan quimictis campa quinmictíaj nopa tapiyalme para tacajcahualisti tatatili. Huan teipa techmactilis na, niamoTECO, huan elis se tacajcahualisti para itajtacol. ");
INSERT INTO nchBl_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Teipa nopa totajtzi ica imacpil quicuis se quentzi ieso nopa tapiyali cati quitencajque quej se tacajcahualisti por tajtacoli huan quiajalos nopa nahui icuacua nopa taixpamit para tacajcahualisti tatatili. Huan nochi nopa esti cati noja mocahuas quitoyahuas itzinta nopa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Huan nochi ichiyajca nopa oquich chivo nojquiya monequi techmacase ipan tit quej quitatíaj ichiyajca nopa tapiyali cati se tacajcahualisti para moyoltalise ica na, niamoTECO. Huan quema ya quichijtos nochi ya ni, teipa nijtapojpolhuis nopa tayacanquet. ");
INSERT INTO nchBl_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“Sinta cati hueli israelita quichihuas se tajtacoli, yaya quihuica tajtacoli masque amo quimatiyaya para na, niamoTECO, nitanahuatijtoya amo aqui ma quichihua nopa tamanti. ");
INSERT INTO nchBl_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Huan teipa quema ya quimachilijtos para quichijtoc nopa tajtacoli, nimantzi monequi quihuicas se chivo cati sihuatzi cati amo quipiya yon se tamanti cati amo cuali ipan itacayo. Huan ya nopa elis se tacajcahualisti para nopa tajtacoli cati quichijqui. ");
INSERT INTO nchBl_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Huan quihuicas nopa tapiyali campa quinmictíaj nopa tapiyalme para tacajcahualisti tatatili. Huan nopona quitalis imax ipan nopa tapiyali itzonteco cati elis se tacajcahualisti por tajtacoli huan teipa quimictis. ");
INSERT INTO nchBl_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Huan nopa totajtzi quicuis ica imacpil se quentzi ieso huan quiajalos ipan nopa nahui icuacua nopa taixpamit para tacajcahualisti tatatili. Huan nopa esti cati noja mocahuas, quitoyahuas talchi itzinta nopa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Nojquiya nopa masehuali monequi quiquixtilis nochi ichiyajca nopa tapiyali. Quena, san se quichihuas quej quichihua ica nopa tacajcahualisti cati temacaj para moyoltalise ica na. Huan teipa nopa totajtzi quitalis nopa tachiyajcayot ipan nopa taixpamit huan quitatis. Huan elis se tacajcahualisti cati mijyotis ajhuiyac huan techpactis na, niamoTECO. Huan quej nopa, quichihuas nopa totajtzi para techixtzacuilis itajtacol nopa masehuali. Huan nijtapojpolhuis. ");
INSERT INTO nchBl_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“Pero sinta nopa masehuali quinequi techmacas se pilborregojtzi quej se tacajcahualisti por tajtacoli, hueli quihualicas se pilsihua borregojtzi cati amo quipiya ipan itacayo yon se tamanti cati amo cuali. ");
INSERT INTO nchBl_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Huan quitalis imax ipan itzonteco nopa tapiyali huan quimictis campa quinmictíaj nopa tapiyalme cati quintequihuíaj para tacajcahualisti tatatili. ");
INSERT INTO nchBl_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Huan nopa totajtzi quicuis se quentzi ieso nopa tapiyali ica imacpil huan quiajalos icuacua nopa taixpamit para tacajcahualisti tatatili. Huan nopa esti cati noja mocahuas quitoyahuas talchi itzinta nopa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Teipa quiquixtilis nochi ichiyajca nopa pilsihua borregojtzi. Quena, san se quichihuas quej quichijqui ica nopa pilborregojtzi cati techtencahuilijque quej se tacajcahualisti para moyoltalise ica na. Huan nopa totajtzi quitatis nochi nopa tachiyajcayot ipan nopa taixpamit huan techmacas na, niamoTECO, ica nopa tit. Huan ica cati quichihua nopa totajtzi techixtzacuilis nopa tajtacoli cati nopa masehuali quichijqui, huan nijtapojpolhuis. ");
INSERT INTO nchBl_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“Sinta se acajya quiitac quema panoc se tamanti cati amo cuali, o quicactoc se camanali cati amo cuali, huan teipa tequichihuani quitemohuaj se testigo cati quiitztoc nopa tamanti o quicactoc nopa camanali, huajca monequi teyolmelahuas cati nelía quiitztoc o quicactoc. Pampa sinta amo teyolmelahuas ten panoc, yaya quihuicas tajtacoli noixpa huan monequi techhualiquilis se tacajcahualisti. ");
INSERT INTO nchBl_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“Nojquiya monequi quihualicas se tacajcahualisti sinta se acajya quiitzquis se tamanti cati amo tapajpactic. Sinta mictoc se tapiyali cati amo tapajpactic para anquicuase masque teaxca o ehua cuatita, huan se masehuali quiitzquis itacayo, monequi techhualiquilis se tacajcahualisti. Nojquiya mochihuas amo tapajpactic noixpa cati quiitzquis itacayo se piltapiyaltzi cati mohuahuatatza talchi masque cati quiitzqui amo quimatiyaya sinta quiitzqui. Pero temachti mochijtoc amo tapajpactic huan monequi techhualiquilis se tacajcahualisti. ");
INSERT INTO nchBl_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“O sinta quiitzquis cuitat o ten hueli at cati quistoc ipan itacayo se masehuali, ayecmo elis tapajpactic noixpa. Huan quema quiitas para quichijtoc nopa tamanti huan quihuica tajtacoli noixpa, monequi quihualicas se tacajcahualisti. ");
INSERT INTO nchBl_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“Sinta se acajya tatestigojquetzas para quichihuas se tamanti cati cuali o amo cuali, huan teipa motejtemos huan quiitas para achi cuali amo camanaltitosquía, yaya quihuicas tajtacoli noixpa huan monequi quihualicas se tacajcahualisti. ");
INSERT INTO nchBl_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“Sinta se acajya quichihuas cati hueli ten ni tamanti, huajca monequi technelilhuis na, niamoTECO, taya quichijtoc, ");
INSERT INTO nchBl_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","huan monequi quihualicas noixpa nopa tacajcahualisti para nopa tajtacoli cati quihuica. Huelis quihualicas se sihua borrego o se sihua chivo. Huan nopa totajtzi techmacas para techixtzacuilis itajtacol nopa masehuali noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“Pero sinta nopa masehuali amo quipiya miyac tomi para quicohuas se pilborregojtzi, huajca hueli techmacas ome palomajme o ome pichones. Huan ni totome elise tacajcahualisti por nopa tajtacoli cati quihuica. Techmacas se quej se tacajcahualisti por tajtacoli huan nopa seyoc techmacas quej se tacajcahualisti tatatili. ");
INSERT INTO nchBl_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Huan nopa totome quinhualicas campa nopa totajtzi huan yaya temacas nopa achtohui piltototzi quej se tacajcahualisti por tajtacoli. Achtohui quipilquechhuilacatzos pero amo quicahuilis ma cotoni itzonteco. ");
INSERT INTO nchBl_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Teipa quicuis se quentzi ieso huan ica quiajtzelhuis se ielchiqui nopa taixpamit. Huan nopa esti cati noja mocahuas quitoyahuas talchi itzinta nopa taixpamit. Huan ya ni elis se tacajcahualisti por tajtacoli. ");
INSERT INTO nchBl_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Huan nopa ompa piltototzi techmacas quej se tacajcahualisti tatatili, huan quichihuas san se quej quiijtohua nopa tanahuatili. Huajca quej nopa quichihuas nopa totajtzi para techixtzacuilis itajtacol nopa masehuali noixpa. Huan na, niamoTECO, nijtapojpolhuis. ");
INSERT INTO nchBl_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“Huan sinta itomi se acajya noja amo quiaxilía para quincohuas ome palomajme o ome pichones, hueli quihuicas ome kilo harina para techmacas quej se tacajcahualisti por itajtacolhua. Pero amo quitalilis aceite, yon copali, pampa ya ni elis se tacajcahualisti por tajtacoli. ");
INSERT INTO nchBl_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Huan monequi quihualicas nopa harina campa nopa totajtzi, huan nopa totajtzi quicuis se quentzi ten nopa tacajcahualisti quej se tanextili para techmaca nochi nopa harina. Huan nopa se quentzi quitatis ipan nopa taixpamit quej quitatía nochi sequinoc tacajcahualisti para na. Ya ni elis se tacajcahualisti por tajtacoli. ");
INSERT INTO nchBl_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Huan ica nochi ya ni nopa totajtzi quiixtzacuilis itajtacol cati quichijtoc nopa masehuali, huan na nijtapojpolhuis nopa tajtacoli cati quichijtoc. Huan nopa harina cati noja mocahuas elis para nopa totajtzitzi inintacualis quej nojquiya mochihua ica nochi cati mocahua quema temacaj tacajcahualisti ten harina.” ");
INSERT INTO nchBl_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Nojquiya TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Sinta se masehuali quichihuas cati amo cuali, huan quisoquihuis tamantzitzi cati tatzejtzeloltique, huan amo quimatiyaya quema quichihua, teipa quema quimatis, monequi quihualicas se tacajcahualisti pampa tajtacole noixpa. Huan nopa tacajcahualisti elis se oquich chivo cati amo quipiya yon se tamanti cati amo cuali ipan itacayo. Huan nopa tapiyali monequi elis ipati quej ome plata tomi cati motequihuía ipan nopa yoyon tiopamit o achi más. Ya ni elis se tacajcahualisti para cati quihuica tajtacoli noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Huan nopa masehuali monequi quiixtahuas cati ipati nopa tamanti cati quisoquihuijtoc cati achtohui eliyaya tatzejtzeloltic. Huan nojquiya quipihuilis seyoc 20 por ciento más. Quej nopa, nopa totajtzi techixtzacuilis itajtacol nopa tacat noixpa, huan na, niamoTECO, nijtapojpolhuis. ");
INSERT INTO nchBl_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Cati hueli masehuali cati quiixpanos notanahuatil, niamoTECO, masque amo quimatqui sinta quichijqui, quihuica tajtacoli noixpa huan monequi quiselis itatzacuiltilis. ");
INSERT INTO nchBl_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Huan monequi quihuicas se tacajcahualisti campa nopa totajtzi. Huan nopa tacajcahualisti elis se oquich borrego cati ipati quej cati ta, Moisés, tiquijtos. Huan nopa oquich borrego amo quipiyas yon se tamanti cati amo cuali ipan itacayo. Huan nopa totajtzi techmacas nopa tacajcahualisti para techixtzacuilis itajtacol nopa masehuali pampa amo quimatiyaya sinta quichihuayaya tajtacoli. Huan na, niamoTECO, nijtapojpolhuis. ");
INSERT INTO nchBl_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ya ni elis se tacajcahualisti para cati quihuica tajtacoli pampa tajtacolchijtoc noixpa.” ");
INSERT INTO nchBl_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Sinta se acajya tajtacolchihuas huan quicajcayahuas seyoc pampa amo quineltocac nocamanal, niamoTECO, monequi quihualicas se tacajcahualisti. Huelis ya amo quimocuitahui cuali cati ihuampo quicahuili imaco para quimocuitahuis, o huelis quiichtequilijtoc, o quiquixtilijtoc se tenijqui pampa yaya más tetic, o huelis amo tacuetqui cati quitanejtijque. ");
INSERT INTO nchBl_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","O huelis se masehuali quipantis cati seyoc quipolojtoya, huan istacatis o tatestigojquetzas ica cati amo melahuac huan quiijtos amo quiitztoc. Nochi ya ni se tajtacoli. Nojquiya tajtacoli ten hueli tamanti amo cuali cati se masehuali quichihua ica tamantzitzi cati seyoc iaxca. ");
INSERT INTO nchBl_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Huan quema moitas o seyoc quiitas para tajtacolchijtoc huan quihuica tajtacoli noixpa pampa quipiya cati amo iaxca, o tatestigojquetztoc ica cati amo melahuac, huajca nimantzi monequi ma quicuepa nopa tamanti. ");
INSERT INTO nchBl_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Huan iyoca monequi noja temacas seyoc 20 por ciento quej elisquía se multa. Nochi temacas ipan san se tonali quema ipan nopa yoyon tiopamit techmacas se tacajcahualisti para nopa tajtacoli cati quihuica. ");
INSERT INTO nchBl_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Monequi techhualiquilis se oquich borrego cati tapajpactic huan senquisa cuali itacayo huan cati cuali ipati. ");
INSERT INTO nchBl_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Huan nopa totajtzi techmacas nopa tapiyali huan techixtzacuilis itajtacol nopa masehuali. Huan na, quena, nijtapojpolhuis ten hueli cati quichijtoc.” ");
INSERT INTO nchBl_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Xiquinilhuiti Aarón huan itelpocahua para quej ni eltoc tanahuatili para se tacajcahualisti tatatili. Nopa tacajcahualisti monequi eltos ipan nopa tit seyohual hasta ijnaloc huan nopa tit mocahuas lementoc. ");
INSERT INTO nchBl_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Huan tonili nopa totajtzi moquentis itatzintan yoyo ten lino nechca itacayo huan teipa iyoyo huehueyac ten lino. Huan quiquixtis nopa cuajnexti cati mocahua ten nopa tacajcahualisti huan quitalis ipan se ilado nopa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Teipa quiquixtis nopa iyoyo huan moquentis ne seyoc tamanti iyoyo huan quihuicas nopa cuajnexti hasta se lugar cati tapajpactic noixpa cati mocahua huejca ten campa anmochijtoque, huan nopona quicahuas. ");
INSERT INTO nchBl_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","“Nochipa monequi lementos se tit ipan taixpamit. Amo quicahuase ma sehui. Huan sese ijnaloc nopa totajtzi monequi quitalilis cuahuit nopa taixpamit huan teipa quitalis nopa tapiyali para nopa tacajcahualisti tatatili cati monequi mojmosta. Nojquiya nopona quitatis nopa tachiyajcayot ten nopa tacajcahualisti cati masehualme temacaj para moyoltalise ica na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Quena, amo quema hueli quicahuase para sehuis nopa tit ipan taixpamit. Monequi nochipa lementos. ");
INSERT INTO nchBl_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“Ya ni nopa tanahuatilme para tacajcahualisti ten harina. Itelpocahua Aarón monequi moquetzase iixmelac nopa taixpamit para techmacase nopa tacajcahualisti noixpa na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Se tacajcahualisti ten harina elis ten se harina cati quichijtoque nelcuechtic huan quimanelojtoque ica aceite huan copali. Huan se ten nopa totajtzitzi quicuis ica imax se quentzi ten nopa tacajcahualisti ten harina huan quitatis ipan nopa taixpamit para quinextis techtencahuilijtoc nochi noixpa. Huan mijyotis ajhuiyac noixpa na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Huan ica nopa harina cati mocahua ten nopa tacajcahualisti, Aarón huan itelpocahua, nopa totajtzitzi, quichihuase pantzi para quicuase, pero amo huelis quitalilise tasonejcayot ipani. Huan monequi quicuase nopona campa tatzejtzeloltic ipan nopa calixpamit ipan nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Ma momocuitahuica para amo quiicxitise ica tasonejcayot. Niquinmacatoc ni harina para elis iniaxca ten nochi nopa tacajcahualisti cati techmacaj ica tit. Eltoc tahuel tatzejtzeloltic quej nojquiya tatzejtzeloltic nopa tapiyalme cati techmacaj para tacajcahualisti por tajtacoli huan para cati quihuica tajtacoli. ");
INSERT INTO nchBl_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Nochi oquichpilme huan tacame cati iconehua huan iixhuihua Aarón cati hueli quicuase cati mocahuas ten nochi nopa tacajcahualisti cati techmaca ica tit. Huan quej ni elis tanahuatili para iteipan ixhuihua cati oquichpilme cati teipa tacajtiyase ipan ifamilia Aarón. Pero san inijuanti hueli quicuase pampa inijuanti taiyocatalilme para na. Mochihuas tatzejtzeloltic cati hueli masehuali cati quiitzquis nopa pantzi cati quichijtoque ica harina cati mocajqui ten nopa tacajcahualisti. Nojquiya mochihuas tatzejtzeloltic ten hueli masehuali o tamanti cati quitoxomas.” ");
INSERT INTO nchBl_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Huan TOTECO nojquiya quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Ipan nopa tonali quema Aarón o iteipan ixhuihua moiyocatalise para elise totajtzitzi, sesen monequi quihualicas para na, niamoTECO, ni tacajcahualisti. Techmacas se tacajcahualisti cati quipiya ome kilo ten harina nelcuechtic. Huan tajco ten nopa tacajcahualisti techmacase ica ijnaloc huan nopa seyoc tajco techmacase ica tiotac. ");
INSERT INTO nchBl_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Nopa tacajcahualisti monequi elis taicxitili ipan se comali huan cuali tamaneloli ica aceite. Huan quema ya icsitoc, quihuejhuelos nopa pantzi cati quichijtoque ica nopa tacajcahualisti ten harina huan techmacas. Huan mijyotis nelía ajhuiyac para na. ");
INSERT INTO nchBl_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Huan san se techmacas nopa itelpoca cati se tonali calaquis quej nopa yancuic hueyi totajtzi ipataca Aarón. Huan ni tacajcahualisti elis noaxca na, niamoTECO, huan monequi quitatise nochi nopa tacajcahualisti para techmacase ipan pocti pampa quej nopa nimechnahuatía. ");
INSERT INTO nchBl_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Huajca monequi quitatis senquisa nochi nopa tacajcahualisti ten harina cati nopa totajtzi techmacas para ya iseltitzi. Yon quentzi amo aqui hueli quicuas.” ");
INSERT INTO nchBl_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Xiquinilhui Aarón huan itelpocahua ni tanahuatilme para nopa tacajcahualisti por tajtacoli. Ni tacajcahualisti cati tahuel tatzejtzeloltic huan nopa tapiyali monequi quimictise campa quinmictíaj tapiyalme para tacajcahualisti tatatili. ");
INSERT INTO nchBl_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Huan nopa nacat cati mocahua elis iaxca nopa totajtzi cati techmacas nopa tacajcahualisti por tajtacoli para quicuas, pero monequi quicuas campa tatzejtzeloltic nopona ipan calixpamit, iixpa nopa yoyon tiopamit campa timopantíaj. ");
INSERT INTO nchBl_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Ten hueli tamanti o masehuali cati quitoxomas quentzi nopa nacat mochihuas tatzejtzeloltic, taiyocatalili para techtequipanos na. Huan sinta se quentzi ten ieso quiajsis iyoyo, nopa masehuali monequi quichicuenis iyoyo nopona campa tatzejtzeloltic. ");
INSERT INTO nchBl_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Sinta quiicxiti nopa nacat ipan se chachapali cati tachijchihuali ica soquit, monequi quitapanas teipa. Pero sinta quiicxiti nopa nacat ipan se tamanti tachijchihuali ica nopa teposti bronce, san monequi quipajpacas ica miyac cuidado teipa. ");
INSERT INTO nchBl_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","“San totajtzitzi huan inioquichpilhua hueli quicuase se tacajcahualisti por tajtacoli, pampa ya ni nopa tacajcahualisti cati tahuel tatzejtzeloltic. ");
INSERT INTO nchBl_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Pero sinta ieso nopa tapiyali ya quihuicatoque tiopan calijtic campa nopa cuarto cati Más Tatzejtzeloltic para quiixtzacuase inintajtacol masehualme, huajca amo aqui hueli quicuas inacayo. Nochi itacayo nopa tacajcahualisti monequi anquitatise noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“Ya ni nopa tanahuatilme para nopa tacajcahualisti para cati quihuica tajtacoli noixpa, niamoTECO. Nopa tacajcahualisti elis tahuel tatzejtzeloltic. ");
INSERT INTO nchBl_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Nopa tapiyali cati quitencajtoque quej se tacajcahualisti para cati quihuica tajtacoli, monequi quimictise ipan nopa lugar campa quinmictíaj nopa tapiyalme cati quintequihuíaj para tacajcahualisti tatatili. Huan ica ieso nopa tapiyali quiatzejtzelhuise yahualtic nopa taixpamit itzinta. ");
INSERT INTO nchBl_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Huan nopa totajtzi techmacas nochi ichiyajca masque cati mopantía campa tatzquitoc icuitapil o ipan icuetaxcol. ");
INSERT INTO nchBl_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","Huan temacas nopa ome ieyo ihuaya nopa tachiyajcayot cati mopantía ininpani. Nojquiya temacas nopa parte hueyi ten ieltapach cati quiquixtis ihuaya ieyo. ");
INSERT INTO nchBl_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Teipa nopa totajtzi quitatis nochi nopa partes ipan taixpamit, huan elis se tacajcahualisti para cati quihuica tajtacoli. Elis se tacajcahualisti cati techmacase niamoTECO ica tit huan mijyotis ajhuiyac noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Nochi totajtzitzi hueli quicuase nopa nacat cati mocahua ten se tacajcahualisti para cati quihuica tajtacoli, pero monequi quicuase campa tatzejtzeloltic pampa ni se tacajcahualisti tahuel tatzejtzeloltic. ");
INSERT INTO nchBl_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“San se tanahuatili eltoc para nopa nacat cati mocahua ten nopa tacajcahualisti por tajtacoli huan nojquiya para nopa tacajcahualisti para cati quihuica tajtacoli. Nopa nacat iniaxca nopa totajtzitzi cati temacase nopa tacajcahualisti para techixtzacuilise nopa tajtacoli noixpa huan inijuanti ma quicuaca. ");
INSERT INTO nchBl_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Pero quema se totajtzi techmacas se tacajcahualisti tatatili para se masehuali, nopa totajtzi san quiselis nopa tapiyali icuetaxo. ");
INSERT INTO nchBl_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Huan nojquiya nochi tacajcahualisti ten harina cati taicxitili ipan horno, comali o sartén, elis para ma quitequihui nopa totajtzi cati techmacas. ");
INSERT INTO nchBl_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Pero nochi tacajcahualisti ten harina masque tamaneloli ica aceite o amo, elis iniaxca iixhuihua Aarón. Huan monequi quinmajmacase sesen ten inijuanti san se imiyaca. ");
INSERT INTO nchBl_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“Ya ni nopa tanahuatili para nopa tacajcahualisti para ma onca tayoltalili ica na cati masehualme temacaj. ");
INSERT INTO nchBl_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Sinta eli se tacajcahualisti para tascamatili, monequi temacase ihuaya pantzi cati quipiya aceite, pero amo quipiyas tasonejcayot. Nojquiya monequi temacas ihuaya pantzi cati sepantic huan cacatztic cati amo quipiya tasonejcayot huan cati taajaloli ica aceite. Nojquiya monequi temacas pantzi ten harina cati tahuel tatzotzoltili huan cati quihuica aceite. ");
INSERT INTO nchBl_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Pero ica ni tacajcahualisti para tascamatili monequi quihualicas pantzi cati, quena, quipiya tasonejcayot. ");
INSERT INTO nchBl_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Se quentzi ten sesen tamanti ten ni tacajcahualisti nopa totajtzi quitejcoltis huejcapa huan quihuisos noixpa para techmacas. Huan teipa ni elis iaxca nopa totajtzi cati tapalehuía huan quiajtzelhui ieso nopa tapiyali ipan taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","“Huan cati quitencajqui nopa tapiyali quej se tacajcahualisti para ma onca tayoltalili ica na huan para techtascamatis monequi quicuas inacayo nopa tapiyali ihuaya ifamilia ipan nopa tonali quema techmacas. Amo teno huelis quicahuase para seyoc tonali. ");
INSERT INTO nchBl_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“Pero sinta se masehuali quihualicas se tacajcahualisti para ma onca tayoltalili ica na pampa tatestigojquetza cati quichihuas o cati amo quichihuas, o sinta quihualica san ica ipaquilis, huajca quena, nopa nacat cati mocahuas elis iaxca cati quihualicac. Huan inijuanti quicuase ipan nopa tonali o hasta mosta. ");
INSERT INTO nchBl_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Huan sinta ipan eyi tonati noja eltos nopa nacat, huajca monequi quitatis nochi. ");
INSERT INTO nchBl_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Pero sinta se masehuali quicuas nacat ipan eyi tonati cati quisqui ten se tacajcahualisti para ma onca tayoltalili ica na cati yaya techmacac, nopa tacajcahualisti ayecmo elis se tamanti cati techpactis na. Amo nijselis nopa tacajcahualisti huan niquitas quej se tamanti fiero noixpa huan amo nijselis yaya cati techmacac. Huan nopa masehuali cati quicuajqui ipan eyi tonati quihuicas itajtacol noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“Nojquiya sinta se quentzi nopa nacat huetzis ipan se tamanti cati amo tapajpactic noixpa, huajca ayecmo aqui huelis quicuas. Monequi quitatise nochi. “Pero nopa nacat cati amo quiajsis cati amo tapajpactic, quena, cati hueli masehuali cati amo tapajpactic hueli quicuas. ");
INSERT INTO nchBl_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","“Huan sinta cati hueli masehuali cati amo tapajpactic quicuas se quentzi inacayo nopa tapiyali cati noaxca na, niamoTECO, pampa se techmacatoc quej se tacajcahualisti para ma onca tayoltalili ica na, monequi xijquixtica ten amojuanti para ayecmo quema huelis itztos ica anisraelitame. ");
INSERT INTO nchBl_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","“Mahuilili sinta se masehuali quitoxomas se tamanti cati amo tapajpactic, masque cati quisa ipan inintacayohua masehualme, o se tapiyali cati amo tapajpactic, o ten hueli tamanti cati amo tapajpactic noixpa. Cati quitoxomas se tamanti cati amo tapajpactic huan teipa quicuas quentzi nacat ten se tacajcahualisti cati techmacatoque para ma onca tayoltalili ica na cati ya o seyoc techmacatoc, monequi xijquixtica ten amojuanti para ayecmo quema huelis itztos ica anisraelitame.” ");
INSERT INTO nchBl_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Huan teipa TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Xiquinilhui nopa israelitame ni tanahuatilme. Amo aqui huelis quicuas yon se tamanti tachiyajcayot masque ininchiyajca huacaxme, borregojme o chivojme. ");
INSERT INTO nchBl_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Pero ininchiyajca tapiyalme cati mijque ica iniselti o cati quinmictijque sequinoc tecuanime, hueli xijtequihuica ica ten hueli tequit, pero amo xijcuaca. ");
INSERT INTO nchBl_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","“Huan sinta cati hueli masehuali quicuas ichiyajca se tapiyali cati quitencajtoque quej se tacajcahualisti para na ipan tit, monequi xijquixtica ten amojuanti para ayecmo quema huelis itztos ica anisraelitame. ");
INSERT INTO nchBl_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","“Masque campa hueli anmochantalise, amo quema xijcuaca esti. Amo xijcuaca inieso totome cati patanij, yon sequinoc tamanti tapiyalme. ");
INSERT INTO nchBl_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Sinta se masehuali quicuas esti, monequi xijquixtica ten campa amojuanti para ayecmo quema huelis itztos ica anisraelitame.” ");
INSERT INTO nchBl_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Xiquinilhui nopa israelitame ni tanahuatilme. Quema se acajya quinequis techmacas na, niamoTECO, se tacajcahualisti para ma onca tayoltalili ica na, monequi quihualicas nopa partes cati monequi quitatis noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Quena, monequi ya iseltitzi quihualicas ica imax nopa tachiyajcayot ihuaya iyolix ten nopa tacajcahualisti para quitatise noixpa. Pero achtohui nopa tapiyali iyolix monequi quihuisos nopa totajtzi noixpa campa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Huan teipa iyolix nopa tapiyali elis iniaxca Aarón huan itelpocahua para ma quicuaca. Pero nopa totajtzi techmacas nochi nopa tachiyajcayot ipan tit ipan taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Nojquiya quema se techmacas se tacajcahualisti para ma onca tayoltalili ica na, monequi techmacas nopa tapiyali iquescuayo nejmat para elis iaxca nopa totajtzi. ");
INSERT INTO nchBl_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Quema se israelita temacas se tacajcahualisti para ma onca tayoltalili nohuaya, nopa totajtzi cati techmacas ieso huan ichiyajca nopa tapiyali quiselis iquescuayo nopa tapiyali para iaxca. ");
INSERT INTO nchBl_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Pampa na nijquixtilijtoc iyolix huan iquescuayo cati inejmat nopa tapiyali cati quihuisohuaj noixpa para techmacase, huan nijmacatoc Aarón huan itelpocahua para elis iniaxca nochipa. ");
INSERT INTO nchBl_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Quena, ipan nopa tonali quema Aarón huan itelpocahua monextijque noixpa para mochihuase totajtzitzi, niquiniyocatali ni partes para ma quicuaca ten nochi tacajcahualisti tatatili cati masehualme techmacase na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Huan ipan nopa tonali quema niquintequitali para ma elica totajtzitzi, nitanahuati para nopa israelitame ma quinmacaca nopa totajtzitzi ni partes ten tacajcahualisti pampa iniaxca. Huan ya nopa monequi nopa totajtzitzi quiselise hasta ininteipan ixhuihua cati tacajtiyase teipa huan para nochipa.” ");
INSERT INTO nchBl_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Huajca nica eltoc nopa tanahuatilme para quenicatza ma tijmacaca TOTECO se tacajcahualisti ten harina, se tacajcahualisti por tajtacoli huan se tacajcahualisti para cati quihuica tajtacoli iixpa, huan se tacajcahualisti para ma onca tayoltalili ica ya. Nojquiya techilhuía catijqui tacajcahualisti monequi temacas se totajtzi para moiyocatalis quema quiselía itequi para TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Nochi ni tanahuatilme TOTECO quimacac Moisés ipan nopa tepet Sinaí quema nopa israelitame noja itztoyaj ipan nopa huactoc tali, pampa nopona TOTECO techilhui para monequi ma tijhuicaca tacajcahualisti iixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Teipa TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Ama xiquinhuica Aarón huan itelpocahua hasta campa icalte nopa yoyon tiopamit. Huan xijhuica iniyoyo nopa totajtzitzi huan nopa aceite para tiquinaltis. Nojquiya xijhuica nopa becerro cati techmacase quej se tacajcahualisti por tajtacoli. Huan xiquinhuica nopa ome oquich borregojme huan nopa chiquihuit ica pantzi cati amo quipiya tasonejcayot. ");
INSERT INTO nchBl_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Huan xiquinilhui nochi nopa israelitame nojquiya ma mosentilica nopona.” ");
INSERT INTO nchBl_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Huajca Moisés quichijqui nochi senquisa quej TOTECO quinahuati. Huan quema mosentilijtoyaj nochi israelitame campa icalte nopa yoyon tiopamit, ");
INSERT INTO nchBl_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Moisés quinilhui: “Ya ni cati TOTECO tanahuatijtoc ma tijchihuaca.” ");
INSERT INTO nchBl_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Huan teipa Moisés quichijqui ma monechcahuica Aarón huan itelpocahua huan quinpajpajqui ica at. ");
INSERT INTO nchBl_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Huan teipa quiquenti Aarón itatzintan yoyo cati huehueyac, huan quitalili itzinquechilpica huan nojquiya quitalili ipantzajca. Huan ipan nopa pantzajcayot quitali nopa seyoc ipantzajca cati amo quipixqui imancax. ");
INSERT INTO nchBl_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Teipa Moisés quitalili nopa yolixtzajcayot cati quipixqui ibolsa huan nopona quitalili nopa Urim huan nopa Tumim, nopa dados tatzejtzeloltic ten Toteco. ");
INSERT INTO nchBl_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Huan teipa ipan itzonteco Aarón quitalili icuatzajca cati eli quej se tzonyahuali. Huan ipan icuaixco quitalili nopa piltepos patactzi cati tatzejtzeloltic huan cati tachijchihuali ica oro cati quiixnextía para yaya nopa hueyi totajtzi. Quej nopa TOTECO quinahuati ma quitalili Aarón. ");
INSERT INTO nchBl_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Teipa Moisés quicuic nopa aceite cati quitequihuíaj para ica taiyocatalíaj para elis iaxca Toteco, huan quipolo nochi tamanti cati onca ipan nopa yoyon tiopamit huan quej nopa quiniyocatali para elise senquisa para TOTECO iaxca. ");
INSERT INTO nchBl_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Huan quiijtzelo nopa aceite ipan nopa taixpamit chicome huelta para quiiyocatalis para elis iaxca Toteco nopa taixpamit huan nochi tamantzitzi cati motequihuíaj ipan nopa yoyon tiopamit. Nojquiya quiajtzelhui nopa hueyi paila huan cati ipan mosehuijtoc huan quej nopa quintatzejtzelolchijqui. ");
INSERT INTO nchBl_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Huan teipa nojquiya quitejqui quentzi aceite ipan itzonteco Aarón para quiiyocatalis para itequi. ");
INSERT INTO nchBl_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Huan teipa Moisés sempa quinnotzqui ma monechcahuica Aarón itelpocahua huan quinquenti iniyoyo cati huehueyac, huan quintalili inintzinquechilpica, huan nojquiya quintalili inintzontzajcayohua. Huan nochi quichijqui quej TOTECO quinahuatijtoya. ");
INSERT INTO nchBl_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Teipa quicuic nopa becerro para nopa tacajcahualisti por tajtacoli, huan Aarón huan itelpocahua quitalijque inimax ipan itzonteco nopa tapiyali. ");
INSERT INTO nchBl_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","16","Huan Moisés quimicti nopa tapiyali huan ica imacpil quicuic se quentzi esti huan quiajalo nopa nahui icuacua nopa taixpamit cati campa iesquina. Huan nojquiya quiatzejtzelhui nopa taixpamit para quitatzejtzelolchihuas. Huan nopa esti cati mocajqui quitoyajqui talchi itzinta nopa taixpamit. Teipa quicuic nopa tachiyajcayot cati mopantía ipan icuetaxcol ihuaya nopa parte cati más hueyi ten ieltapach, huan ome ieyo ihuaya ininchiyajca, huan quitencajqui iixpa TOTECO ipan tit ipan nopa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Huan nopa becerro inacayo huan icuetaxo, huan icuetaxcol ica icuit, quitatito ipan se lugar cati mocahua huejca ten campa mochijtoyaj. Quichijqui senquisa quej quinahuatijtoya TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Teipa quihualicac nopa oquich borrego para nopa tacajcahualisti tatatili iixpa TOTECO. Huan Aarón huan itelpocahua quitalijque inimax ipan itzonteco nopa tapiyali, ");
INSERT INTO nchBl_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","huan Moisés quiquechtzontejqui huan quiatzejtzelhui yahualtic nopa taixpamit ica ieso. ");
INSERT INTO nchBl_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Teipa quihuejhuelo nopa oquich borrego. Huan nopa nacat tatecti ihuaya itzonteco huan ichiyajca quitati ipan nopa taixpamit para quimacas TOTECO ipan pocti. ");
INSERT INTO nchBl_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Pero achtohui quipajpajqui icuetaxcol huan iquescuayo ica at, huan teipa quitati ipan nopa taixpamit. Huan quej nopa, nochi nopa oquich borrego yajmaxtic tatac iixpa TOTECO. Huan nopa tapiyali elqui se tacajcahualisti tatatili cati mijyoti ajhuiyac para ya. Huan Moisés quimacac TOTECO nopa tacajcahualisti ipan tit senquisa quej quinahuatijtoya. ");
INSERT INTO nchBl_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Teipa Moisés quiixnexti nopa seyoc oquich borrego cati elqui se tacajcahualisti para quiniyocatalis Aarón huan itelpocahua, huan inijuanti quitalijque inimax ipan itzonteco. ");
INSERT INTO nchBl_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Huan teipa Moisés quiquechtzontejqui nopa tapiyali, huan quicuic se quentzi ieso huan quitalili Aarón ipan inacas nejmat. Huan nojquiya quitalili ipan ihueyi xojpil cati inejmat huan ipan ihueyi majpil cati inejmat. ");
INSERT INTO nchBl_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Teipa Moisés quinilhui itelpocahua Aarón ma monechcahuica huan nojquiya quintalili ipan ininacas nejmat huan inixocpilhua cati hueyi cati ininejmat huan ipan inimacpil cati hueyi cati nojquiya ininejmat. Huan nopa esti cati mocajqui quiatzelhui itzinta huan yahualtic nopa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Teipa quicuic nopa tachiyajcayot huan icuitapil cati quipixtoya ichiyajca. Nojquiya quicuic nopa tachiyajcayot cati mopantía ipan icuetaxcol, ieltapach, huan nopa ome ieyo huan iquescuayo cati inejmat. ");
INSERT INTO nchBl_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Huan ten nopa chiquihuit cati quipixtoya pantzi cati amo quipiyayaya tasonejcayot cati eltoya iixpa TOTECO, Moisés quiquixti se pantzi, huan se pantzi cati tamaneloli ica aceite, huan se pantzi cati sepantic huan cacatztic. Huan nochi ya ni quitali ininpani nopa partes cati quisqui ipan nopa oquich borrego. ");
INSERT INTO nchBl_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Huan nochi ni tamanti quitali imaco Aarón huan ipan inimax itelpocahua para inijuanti ma quihuisoca iixpa TOTECO para quimacase. ");
INSERT INTO nchBl_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Huan teipa sempa quicuic nopa tamanti ten inimax, huan quitati ipan nopa taixpamit ihuaya nopa tacajcahualisti tatatili para quimacas TOTECO. Huan ya ni, quena, elqui se tacajcahualisti para quiniyocatalis Aarón huan itelpocahua para tequitise quej totajtzitzi. Huan mijyoti ajhuiyac para TOTECO. Ya ni elqui nopa tacajcahualisti cati quimacac TOTECO ipan tit. ");
INSERT INTO nchBl_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Huan teipa Moisés quicuic nopa oquich borrego iyolix huan quimacac TOTECO quej se tacajcahualisti tahuisoli iixpa, pampa quihuiso iixpa nopona campa nopa taixpamit. Huan teipa iyolix nopa tapiyali mocajqui iaxca Moisés pampa quej nopa tanahuati TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Teipa quicuic se quentzi ten nopa aceite para teiyocatalise huan se quentzi ten nopa esti cati eltoya ipan taixpamit huan ica quiatzejtzelhui iyoyo Aarón. Huan nojquiya quiatzejtzelhui iniyoyo itelpocahua Aarón. Huan quej nopa quichijqui ma elica taiyocatalilme Aarón huan itelpocahua para quitequipanose TOTECO, huan nojquiya iniyoyo quiiyocatalili para TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Huan Moisés nojquiya quinilhui Aarón huan itelpocahua: “Xiquicxitica nopa nacat ipan at nechca icalte ni yoyon tiopamit. Huan nopona xijcuaca ihuaya nopa pantzi cati eltoc ipan nopa chiquihuit cati quipiya nopa tacajcahualisti para amechiyocatalise para TOTECO. Quena, xijchihuaca quej niquijtojtoc pampa nimechnahuatía para monequi amojuanti xijcuaca. ");
INSERT INTO nchBl_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Huan nopa nacat huan pantzi cati noja mocahuas, monequi anquitatise. ");
INSERT INTO nchBl_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Huan amo hueli anquistehuase ten icalte nopa yoyon tiopamit para chicome tonati, pampa monequi chicome tonati para tamis nochi cati monequi para nimechiyocatalis para TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Huan nochi ni tamanti cati tijchijtoque, tijchijque pampa TOTECO quej nopa quinequiyaya ma tijchihuaca para quiixtzacuas amotajtacolhua iixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Huan sempa nimechnahuatía para tonaya huan tayohua para chicome tonati monequi anmocahuase nechca icalte nopa yoyon tiopamit. Quena, quej nopa TOTECO amechnahuatijtoc para amo anmiquise.” ");
INSERT INTO nchBl_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Huan Aarón huan itelpocahua quichijque nochi cati TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nchBl_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Panoc nopa chicome tonati para moiyocatalise para TOTECO huan ipan nopa chicueyi tonati Moisés quinnotzqui Aarón huan itelpocahua huan nochi nopa huehue tacame cati tayacanque ica israelitame. ");
INSERT INTO nchBl_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Huan quiilhui Aarón: “Xijcui se becerro para tijmacas TOTECO quej se tacajcahualisti por tajtacoli para ta. Huan nojquiya xijcui se oquich borrego para elis se tacajcahualisti tatatili. Huan ni tapiyalme monequi elise tapajpactique. Amo quipiyase ipan inintacayo yon se tamanti cati amo cuali. ");
INSERT INTO nchBl_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Huan xiquinilhuica nopa israelitame ma quicuica se oquich chivo para quimacase quej se tacajcahualisti por tajtacoli. Huan nojquiya ma quicuica se becerro huan se pilborregojtzi cati sanoc quiaxitijtoque sesen xihuit para quinmacase quej se tacajcahualisti tatatili. Ni tapiyalme monequi elise tapajpactique. Amo quipiyase yon se tamanti cati amo cuali ipan inintacayo. ");
INSERT INTO nchBl_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Huan nojquiya xiquinilhui monequi quicuise se toro cati taxahua huan se oquich borrego para ma quimacaca quej se tacajcahualisti para ma onca tayoltalili ica TOTECO. Nojquiya monequi quihualicase se tacajcahualisti ten harina cati quicuechtilijtoque huan quichijtoque se harina huan quimanelojtoque ica aceite. Quena, nochi ya ni monequi xijchihuaca pampa ama TOTECO monextis ica amojuanti.” ");
INSERT INTO nchBl_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Huajca nochi israelitame quihuicaque ni tamanti cati quinnahuatijtoya Moisés campa nopa yoyon tiopamit icalixpa. Huan nochi nopa israelitame monechcahuijque huan ijcatoyaj nopona iixpa TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Huajca Moisés quinilhui: “Quema ya anquichijtose nochi cati tanahuatía TOTECO, monextis ihueyitilis ica amojuanti.” ");
INSERT INTO nchBl_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Teipa Moisés quiilhui Aarón: “Ximonechcahui campa nopa taixpamit huan xijmaca TOTECO nopa tacajcahualisti por tajtacoli cati elis para ta motajtacolhua. Huan xijtencahua nopa tacajcahualisti tatatili cati quiixtzacuas motajtacolhua iixpa. Teipa xijmaca TOTECO nopa tacajcahualisti para quiixtzacuas inintajtacolhua nochi israelitame iixpa quej yaya tanahuatijtoc.” ");
INSERT INTO nchBl_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Huajca Aarón monechcahui campa nopa taixpamit huan quimicti nopa becerro quej se tacajcahualisti para tajtacoli por ya itajtacol. ");
INSERT INTO nchBl_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Huan itelpocahua quihualiquilijque nopa esti, huan Aarón quicuic se quentzi ten nopa esti ica imacpil huan quiajalo nopa nahui icuacua nopa taixpamit. Huan nopa esti cati noja mocajqui quitoyajqui talchi itzinta nopa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Huan teipa quitati nochi nopa tapiyali ichiyajca, ieyo huan nopa parte cati más hueyi ten ieltapach. Nochi quimacac TOTECO ipan pocti quej yaya quinahuatijtoya ma quichihuaca. ");
INSERT INTO nchBl_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Pero inacayo nopa tapiyali huan icuetaxo quitati ipan se lugar huejca ten campa timochijtoyaj. ");
INSERT INTO nchBl_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Huan teipa Aarón quimicti nopa tapiyali cati elqui para tacajcahualisti tatatili, huan itelpocahua quihuiquilijque nopa esti. Huan quiatzejtzelhui ica nopa esti yahualtic ipan nochi ielchiqui nopa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Huan quihuejhuelojque nopa tapiyali huan quihuiquilijque Aarón itzonteco huan sesen tatecti. ");
INSERT INTO nchBl_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Teipa quipajpajqui icuetaxcol huan iquescuayo huan nojquiya quitencajqui ipan tit ipan nopa taixpamit ihuaya nopa tacajcahualisti tatatili. ");
INSERT INTO nchBl_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Teipa quihualicac nopa oquich chivo cati quihualicatoyaj nopa israelitame. Huan quimicti huan quitencajqui quej se tacajcahualisti por tajtacoli para nopa israelitame inintajtacolhua. Nochi quichijque quej achtohui quichijqui ica nopa seyoc tacajcahualisti para tajtacoli cati yaya temacac por ya. ");
INSERT INTO nchBl_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Huan teipa quihualicac nopa tacajcahualisti tatatili. Huan quitencajqui iixpa TOTECO senquisa quej quiijto itanahuatil. ");
INSERT INTO nchBl_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Teipa quihualicac nopa tacajcahualisti ten harina. Huan quicuic se quentzi ten nopa harina cati quicuechtilijtoyaj ten nopa tacajcahualisti cati quihualicatoyaj, huan quitati ipan nopa taixpamit ihuaya nopa tacajcahualisti tatatili cati quitencajque ica ijnaloc. ");
INSERT INTO nchBl_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Teipa quiquechtzontejqui nopa toro cati quimati tapoxonía huan nopa oquich borrego cati temacatoyaj nopa israelitame quej se tacajcahualisti para ma onca tayoltalili ica TOTECO. Huan itelpocahua Aarón quihuiquilijque nopa esti, huan yaya quiatzelhui yahualtic huan itzinta nopa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Teipa quicuic nopa toro ichiyajca huan ichiyajca nopa oquich borrego. Huan quicuic nopa tachiyajcayot cati mopantía ipan inincuitapil huan cati mopantía ipan inincuitaxcol. Huan quicuic inieyo huan nopa parte ten inieltapach cati quipixqui ininchiyajca. ");
INSERT INTO nchBl_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Huan nochi nopa partes itelpocahua quitalijque ipan nopa tapiyalme iniyolix para quimacase Aarón. Huan nochi nopa tachiyajcayot quitati ipan nopa taixpamit para quimacas TOTECO ipan pocti. ");
INSERT INTO nchBl_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Pero iniyolix huan ininquescuayo cati inejmat, Aarón quitencajqui iixpa TOTECO quej se tacajcahualisti tahuisoli. Huan Aarón nochi quichijqui quej Moisés quinahuatijtoya. ");
INSERT INTO nchBl_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Huan Aarón quitejcolti imax para campa itztoyaj nopa israelitame huan quintiochijqui. Huan quema ya quitencajtoya nopa tacajcahualisti por tajtacoli, huan nopa tacajcahualisti tatatili, huan nopa tacajcahualisti para ma onca tayoltalili ica TOTECO, Aarón temoc ten campa nopa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Huan Moisés huan Aarón calajque calijtic ipan nopa yoyon tiopamit. Huan teipa quisque huan quintiochijque nopa israelitame, huan TOTECO ihueyitilis monexti iniixpa nochi nopa israelitame cati mosentilijtoyaj nopona. ");
INSERT INTO nchBl_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Huan TOTECO quititanqui tit ten iixpa huan nimantzi quitamitati nochi nopa tacajcahualisti huan nopa tachiyajcayot cati eltoya ipan nopa taixpamit. Huan quema nopa israelitame quiitaque ya nopa, quitzajtzilijque TOTECO ica paquilisti huan motancuaquetzque huan mohuijtzonque ica inixayac hasta talchi. ");
INSERT INTO nchBl_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Se tonali ome itelpocahua Aarón, inijuanti cati inintoca eliyaya Nadab huan Abiú, quicuique sese ticomit huan ipan quitalijque tit cati amo tatzejtzeloltic ihuaya copali huan quitatijque iixpa TOTECO. Pero cati quichijque amo elqui quej TOTECO quinnahuatijtoya ma quichihuaca. ");
INSERT INTO nchBl_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Huan TOTECO quititanqui se tit huan quintamitati huan mijque nopona iixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Huan teipa Moisés quiilhui Aarón: ―TOTECO quinequiyaya techilhuis para quej ni panos quema quiijto: ‘Niquinnextilis para nitatzejtzeloltic, nochi cati monechcahuíaj campa na. Huan nochi israelitame techhueyitalise.’ Huan Aarón amo molini. ");
INSERT INTO nchBl_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Huan Moisés quinotzqui Misael huan Elzafán cati eliyayaj itelpocahua Uziel, itío Aarón, huan quinilhui: ―Xihualaca huan xiquinhuicaca amoteixmatcahua inintacayohua. Xiquinquixtica ten nopa calixpamit cati iixpa ni yoyon tiopamit huan xiquinhuicaca huejca ten campa timochijtoque. ");
INSERT INTO nchBl_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Huan monechcahuijque huan quinhuicaque ininteixmatcahua inintacayohua, huan noja moquentijtoyaj iniyoyo cati huehueyac ten totajtzitzi. Huan quinhuicaque huejca ten campa timochijtoque quej Moisés quinnahuatijtoya. ");
INSERT INTO nchBl_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Teipa Moisés quicamanalhui Aarón huan nopa ome itelpocahua cati inintoca eliyaya Eleazar huan Itamar, huan quinilhui: ―Amo xichocaca yon amo ximocuesoca. Amo xijcahuaca amotzoncal ma nesis fiero, yon amo xijtzayanaca amoyoyo. Pampa sinta anmotequipachose, TOTECO nojquiya amechtzontamiltis huan yaya nelía cualanis ica nochi ni israelitame. Pero moicnihua, nochi nopa sequinoc israelitame, quena, hueli quinchoquilise Nadab huan Abiú huan hueli mocuesose por nopa tit cati TOTECO quititanqui. ");
INSERT INTO nchBl_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Pero amo hueli anquisase ten nopona campa nopa yoyon tiopamit. Sinta anquisase, anmiquise, pampa antaiyocatalilme para TOTECO por nopa aceite cati nimechajalti. Huan Aarón huan nopa ome itelpocahua quichijque nochi quej quinnahuati Moisés. ");
INSERT INTO nchBl_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Teipa TOTECO quicamanalhui Aarón huan quiilhui: ");
INSERT INTO nchBl_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Ta huan motelpocahua amo hueli anquiise xocomeca at o ten hueli tamanti tailisti cati cococ quema ancalaquise ipan nopa yoyon tiopamit. Sinta anquiise, anmiquise. Ni tanahuatili monequi anquitoquilise amojuanti huan nochi amoteipan ixhuihua cati tacajtiyase para nochipa. ");
INSERT INTO nchBl_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Monequi anquimachilise catijqui tamantzitzi tatzejtzeloltic para na huan catijqui amo, huan catijqui tapajpactic noixpa huan catijqui amo tapajpactic. ");
INSERT INTO nchBl_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Huan monequi anquinmachtise nopa israelitame nochi notanahuatil cati na, niamoTECO, nimechmacatoc ica Moisés.” ");
INSERT INTO nchBl_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Teipa Moisés quincamanalhui Aarón huan nopa ome itelpocahua cati noja itztoyaj cati inintoca eliyaya Eleazar huan Itamar. Quinilhui: ―Xijcuica nopa harina cati noja mocahua ten nopa tacajcahualisti cati anquimacaque TOTECO ipan tit. Xijpiyaca cuidado para amo quipiyas tasonejcayot huan xijcuaca nechca ielchiqui nopa taixpamit, pampa ya ni elis se tacajcahualisti cati tahuel tatzejtzeloltic. ");
INSERT INTO nchBl_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Huan monequi xijcuica huan xijcuaca nopona yoyon tiopan calijtic campa tatzejtzeloltic. Huan nopa cati mocahua ten nopa tacajcahualisti ten harina elis moaxca para motacualis, Aarón, huan para inintacualis motelpocahua. Quena, ni parte ten nopa tacajcahualisti cati anquitatise iixpa TOTECO elis amoaxca, pampa quej nopa tanahuatijtoc TOTECO ma nimechilhui. ");
INSERT INTO nchBl_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Pero iyolix nopa tapiyali cati anquihuisohuaj iixpa TOTECO huan iquescuayo cati nojquiya elis amoaxcahua, hueli anquicuase ipan ten hueli lugar cati tapajpactic. Quena, amojuanti huan amooquichpilhua huan amosihuapilhua hueli anquicuase nopa iyolix huan iquescuayo pampa amoaxca ten nochi tacajcahualisti para ma onca tayoltalili ica TOTECO cati israelitame temacaj. ");
INSERT INTO nchBl_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Nopa israelitame monequi quihualicase iquescuayo nopa tapiyali cati anquitejcoltise huan iyolix cati anquihuisose iixpa TOTECO para antemacase quema nojquiya anquitatise nopa tachiyajcayot. Huan teipa nopa partes elis amoaxca. Quena, ni ome tamanti mocahuas para ta huan para moconehua para nochipa pampa quej nopa tanahuatijtoc TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Huan teipa Moisés tatzintocac canque eltoc nopa oquich chivo cati quitencajque quej se tacajcahualisti por tajtacoli huan quipanti para ya quitatijtoyaj. Huan tahuel cualanqui ihuaya Eleazar huan Itamar, nopa ome itelpocahua Aarón cati noja itztoyaj. Huan quinilhui: ");
INSERT INTO nchBl_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","―¿Para ten amo anquicuajque nopa tacajcahualisti por tajtacoli campa tatzejtzeloltic tiopan calijtic? Pampa nelía eliyaya tatzejtzeloltic huan TOTECO amechmacac para anquiquixtise nopa tajtacoli cati israelitame quihuicaj iixpa huan para anquiixtzacuase inintajtacolhua. ");
INSERT INTO nchBl_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Monectoya anquicuajtosquíaj yoyon tiopan calijtic campa tatzejtzeloltic quej na nimechnahuatijtoya, pampa amo ya nopa tacajcahualisti cati anquihuicaj ieso tiopan calijtic campa Más Tatzejtzeloltic cati amo hueli anquicuase. ");
INSERT INTO nchBl_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Pero Aarón quiilhui Moisés: ―Inijuanti quitencajque inintacajcahualis para tajtacoli huan inintacajcahualis tatatili iixpa TOTECO. Pero ica inimiquilis ne sequinoc notelpocahua, na nimoilhui sinta tijcuasquíaj ama nopa tacajcahualisti por tajtacoli, huelis amo quipactijtosquía TOTECO. Yeca amo nijcuajqui. ");
INSERT INTO nchBl_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Huan quema Moisés quicajqui ya nopa, ayecmo cualanqui. ");
INSERT INTO nchBl_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Huajca TOTECO sempa quinilhui Moisés ihuaya Aarón: ");
INSERT INTO nchBl_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Xiquinilhuica nopa israelitame para san hueli quicuase ni tapiyalme cati ama nimechilhuis. ");
INSERT INTO nchBl_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Hueli quicuase cati quipiyaj iniisti maxaltic huan quicuajcuaj inintacualis ome huelta. ");
INSERT INTO nchBl_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Pero amo hueli anquincuase nopa camello, ");
INSERT INTO nchBl_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","nopa cuatochi, ");
INSERT INTO nchBl_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","huan nopa pesojti, pampa masque ni tapiyalme quicuajcuaj inintacualis ome huelta, amo quipiyaj iniisti maxaltic. ");
INSERT INTO nchBl_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","“Nojquiya amo hueli anquicuase nopa pitzot, pampa masque quipiya iisti maxaltic, amo quicuajcua ome huelta itacualis, huan yeca niquita para amo tapajpactic. ");
INSERT INTO nchBl_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","“Amo hueli anquicuase ininacayo ni tapiyalme yon amo hueli anquiitzquise se itacayo quema mictoc pampa amo tapajpactic. ");
INSERT INTO nchBl_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“Huan ten nochi michime huan tapiyalme cati itztoque ipan at, san hueli anquincuase cati quipiyaj inieltapal huan inipetayo. Quena, masque anquinitzquise ipan hueyi at o ipan se atajti san ni michime anquincuase. ");
INSERT INTO nchBl_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Amo hueli anquincuase yon se tamanti cati itztoc ipan hueyi at o ipan hueyame sinta amo quipiya ieltapal huan ipetayo quej quipiyaj michime. ");
INSERT INTO nchBl_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Nochi ni tamanti anquiijiyase huan amo hueli anquinitzquise inintacayo cati mictoque. ");
INSERT INTO nchBl_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Huan sempa nimechilhuía ya ni: Amo xijcuaca yon se tamanti cati itztoc ipan at sinta amo quipiya ieltapal huan ipetayo quej se michi. ");
INSERT INTO nchBl_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“Huan nojquiya itztoque totome cati amo hueli anquincuase. Amo xijcuaca yon se hueyi cuatojti, yon se huajti, yon tzojpilot cati momati nechca at, ");
INSERT INTO nchBl_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","yon se tamanti tzojpilot, ");
INSERT INTO nchBl_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","o yon se tamanti cacalot. ");
INSERT INTO nchBl_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","Yon amo xijcuaca nopa huejcapantic totot avestruz, yon nopa cuatojti cati nemi ten tayohua, yon nopa atotot cati chipahuac, o yon se tamanti cuajti. ");
INSERT INTO nchBl_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","Amo xijcuaca nopa tololojti, yon nopa cuamojmojti cati hueyi, yon nopa cuamojmojti cati ijcatoc iijhuiyo ipan itzonteco, ");
INSERT INTO nchBl_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","yon nopa cuamojmojti chipahuac, yon nopa totot yayahuic cati quincua michime, yon nopa pelícano, yon nopa tzojpilot cati quincua tapiyalme cati mictoque. ");
INSERT INTO nchBl_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","Yon amo xijcuaca nopa garza, yon nopa cigüeña, yon nopa totome cati quipiyaj huejhueyi inimetz, yon tzotzome. Nochi ni tapiyalme amo hueli anquincuase. ");
INSERT INTO nchBl_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“Nojquiya monequi xiquinijiyaca nochi tamanti sayolime cati patanij huan quipiyaj nahui inimetz. Amo xiquincuaca. ");
INSERT INTO nchBl_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Pero itztoque sequij tamanti cati quipiyaj inieltapal huan nahui iniicxihua cati hueli anquicuase. Sinta ipan inimetz quipiyaj inintancua cati quinpalehuíaj para huitonij, huajca quena, hueli anquincuase. ");
INSERT INTO nchBl_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Hueli anquincuase nochi tamanti pilchapoltzitzi, nochi chapolime cati huejhueyi, huan nochi chapolime cati quicuaj xihuit huan quipiyaj inieltapal. ");
INSERT INTO nchBl_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Pero nochi nopa sequinoc sayolime huan chapolime cati quipiyaj nahui iniicxi, amo hueli anquincuase. ");
INSERT INTO nchBl_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“Ni tamanti quichihua para se masehuali elis amo tapajpactic: “Sinta se masehuali quiitzquis itacayo se ten ni totome o sayolime cati mictoque, mocahuas amo tapajpactic hasta tayohua. ");
INSERT INTO nchBl_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","“Huan sinta se masehuali quiitzquis itacayo se ten ni tamanti tapiyalme quema ya mictoc, monequi nimantzi quichicuenis iyoyo huan noja mocahuas amo tapajpactic hasta tayohua. ");
INSERT INTO nchBl_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“Nojquiya anmochihuase amo antapajpactique quema anquiitzquise itacayo se tapiyali cati amo senquisa maxaltic iisti o amo quicuajcua ome huelta itacualis. ");
INSERT INTO nchBl_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","“Nojquiya amo huelis anquincuase tapiyalme quej chichime cati amo quipiyaj senquisa iniisti. Huan sinta se masehuali quiitzquis itacayo se ten ni tapiyali cati mictoc mocahuas amo tapajpactic hasta tayohua. ");
INSERT INTO nchBl_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Quena, quema se masehuali quiitzquis itacayo se ten ni tapiyali cati mictoc monequi nimantzi quichicuenis iyoyo, pero noja mocahuas amo tapajpactic hasta tayohua. ");
INSERT INTO nchBl_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“Huan ten nopa tapiyalme cati motalohuaj talchi, ya ni cati amo cuali para anquincuase: sehueme, quimichime, temasolime, tusame, ");
INSERT INTO nchBl_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","cocodrilojme, axilime, topitzime, huan tzonpetachiquime. ");
INSERT INTO nchBl_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","“Sinta se masehuali quiitzquis itacayo se ten ni tapiyalme cati mictoc, mocahuas amo tapajpactic hasta tayohua. ");
INSERT INTO nchBl_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","“Nojquiya mocahuas amo tapajpactic nochi tamanti cati ipan huetzis nopa tapiyali itacayo. Quena, sinta nopa tapiyali cati mictoc huetzis ipan se tamanti cuahuit, o se yoyomit, o se cuetaxti o se coxtali, huajca nopa tamanti mocahuas amo tapajpactic. Monequis anquitalise ipan at huan mocahuas amo tapajpactic hasta tayohua, pero teipa elis tapajpactic. ");
INSERT INTO nchBl_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","“Huan sinta nopa tapiyali huetzis ipan se tamanti cati tachijchihuali ica soquit, huajca nochi tamantzitzi cati quipixtoya iijtic elise amo tapajpactic, huan monequi anquitapanase nopa comit. ");
INSERT INTO nchBl_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Huan sinta nopa at cati ica quitapajpacchihuaj cati amo tapajpactic huetzis ipan se tamanti tacualisti o se tamanti tailisti, nopa tamanti nojquiya mochihuas amo tapajpactic pampa quiajsic nopa at. ");
INSERT INTO nchBl_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","“Sinta itacayo se ten ni tapiyali cati mictoc huetzis ipan ten hueli tamanti horno cati tachijchihuali ica soquit, huajca nopa horno mocahuas amo tapajpactic huan monequi anquixitinise. ");
INSERT INTO nchBl_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","“Huan sinta nopa tapiyali huetzis ipan se ameli cati quipiya at, nopa at mocahuas tapajpactic, pero nopa masehuali cati quiquixtis nopa tapiyali itacayo, yaya, quena, mocahuas amo tapajpactic. ");
INSERT INTO nchBl_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","“Huan sinta itacayo nopa tapiyali cati mictoc huetzis ipan xinachti cati quicajtoyaj para quitocase ipan mila, huajca nopa xinachti noja mochihuas tapajpactic. ");
INSERT INTO nchBl_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Pero sinta itacayo nopa tapiyali cati mictoc huetzis ipan xinachti cati xolontoc, huajca mocahuas amo tapajpactic. ");
INSERT INTO nchBl_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“Huan sinta anquipiyaj se tapiyali cati onca caquihuili para anquicuase pero nopa tapiyali miquis ica cocolisti, huajca amo xiquitzqui itacayo. Pampa sinta se masehuali quiitzquis itacayo, nopa masehuali mocahuas amo tapajpactic hasta tayohua. ");
INSERT INTO nchBl_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Huan sinta se masehuali quicuas inacayo o quihuicas itacayo nopa tapiyali, monequi nimantzi quichicuenis iyoyo, pero noja mocahuas amo tapajpactic hasta tayohua. ");
INSERT INTO nchBl_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“Monequi xiquinijiyaca nochi tapiyalme cati mohuahuatatzaj talchi huan amo xiquincuaca. ");
INSERT INTO nchBl_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","“Amo hueli anquincuase nochi tamanti cati mohuahuatatzaj talchi ica iniyolix, yon nopa cohuame cati nejnemij ica nahui iniicxi. Nojquiya amo hueli anquincuase nopa tapiyalme cati mohuahuatatzaj talchi huan quipiyaj miyac iniicxi, pampa nelía amo tapajpactique noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Amo xijtoxomaca yon se ten ni tapiyalme pampa amechchihuas amo antapajpactique. ");
INSERT INTO nchBl_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Na niamoTECO Dios. Nijnequi ximomocuitahuica cuali huan xielica antatzejtzeloltique pampa na nitatzejtzeloltic. Huajca amo xiquitzquica yon se ten ni tapiyalme cati mohuahuatatzaj talchi pampa amechchihuas amo antapajpactique noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Na niamoTECO cati nimechquixti ipan tali Egipto para nielis niamoTeco Dios. Huajca ama, monequi anelise antatzejtzeloltique pampa na nitatzejtzeloltic. ");
INSERT INTO nchBl_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“Huajca nica nimechilhuijtoc nopa tanahuatilme cati monequi anquitoquilise ica nochi totome, tapiyalme, tamanti cati itztoque ipan at huan tamanti cati mohuahuatatzaj talchi. ");
INSERT INTO nchBl_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Ni tanahuatilme amechpalehuise para anquimatise taya eli se tapiyali cati tapajpactic huan taya eli se tapiyali cati amo tapajpactic. Huan nojquiya amechpalehuis para anquimatise taya tapiyali hueli anquicuase huan taya tapiyali amo hueli anquicuase.” ");
INSERT INTO nchBl_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Huan TOTECO nojquiya quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Xiquinilhui nopa israelitame ni tanahuatilme. Quema se sihuat tanemiltis huan quitacatiltis se oquichpil, huajca nopa sihuat mocahuas amo tapajpactic para chicome tonati. Monequi quichihuas san se quej quichihua quema esotemo. ");
INSERT INTO nchBl_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Huan ipan nopa chicueyi tonali, quiyecapantequilise se quentzi icuetaxo ipan ipiltacayo nopa piloquichpiltzi. ");
INSERT INTO nchBl_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Teipa nopa piloquichpiltzi inana amo huelis quiitzquis yon se tamanti cati tatzejtzeloltic para seyoc 33 tonati pampa noja quipiya esotemolisti. Yon amo hueli calaquis tiopan calijtic hasta tamis nopa tonali para motapajpacchihuas. ");
INSERT INTO nchBl_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","“Pero sinta nopa sihuat quitacatiltis se sihuapil, huajca mocahuas amo tapajpactic para ome samano. Huan monequi quitepanitas nopa tanahuatili para quema esotemo. Huan teipa quichiyas seyoc 66 tonati para motapajpacchihuas. ");
INSERT INTO nchBl_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“Huan quema ya quitamiltijtos nopa tonali para motapajpacchihuas, huajca masque tacatqui oquichpil o sihuapil, inana monequi quihuicas campa nopa totajtzi ipan icalte nopa yoyon tiopamit se pilborregojtzi cati sanoc quipiya se xihuit para quimacas quej se tacajcahualisti tatatili. Nojquiya monequi quihuicas se paloma o se pichontzi para techmacas quej se tacajcahualisti por tajtacoli. ");
INSERT INTO nchBl_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","“Huan nopa totajtzi quintencahuas noixpa na, niamoTECO, huan techixtzacuilis itajtacol nopa sihuat noixpa. Huan quej nopa, nopa sihuat motapajpacchihuas ten nopa esotemolisti. Quena, ya ni eli nopa tanahuatili cati monequi quitoquilis quema quitacatiltis se conet masque oquichpil o sihuapil. ");
INSERT INTO nchBl_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","“Pero sinta nopa sihuat eli tahuel teicneltzi huan amo quipiya tomi para techmacas se pilborregojtzi, huajca hueli quinhuicas ome pichones o ome palomajme. Se ten nopa ome techmacas quej se tacajcahualisti tatatili, huan nopa seyoc techmacas quej se tacajcahualisti por tajtacoli. Huan quej nopa, nopa totajtzi techixtzacuilis itajtacol nopa sihuat, huan ya mocahuas tapajpactic noixpa.” ");
INSERT INTO nchBl_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","TOTECO quinilhui Moisés ihuaya Aarón: ");
INSERT INTO nchBl_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Quema anquiitase pehua temi icuetaxo se masehuali, o nesi para pehua cocome, o nesi para pehua mochihuas chipahuac icuetaxo, huelis quinequi pehuas nopa tacayo palanca cocolisti cati momahua. Huajca monequi anquihuicase nopa masehuali iixpa nopa totajtzi Aarón o iixpa se ten itelpocahua. ");
INSERT INTO nchBl_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Huan nopa totajtzi quitachilis ica cuidado campa monextijtoc nopa cocolisti. Huan sinta campa quipiya cocolisti, itzoyo pejtoc mochihua chipahuac huan sinta nopa cocot nesi para pejtoc itantita icuetaxo, huajca xijmachilica cuali para quipiya nopa tacayo palanca cocolisti. Huan huajca nopa totajtzi monequi teyolmelahuas para amo tapajpactic nopa masehuali. ");
INSERT INTO nchBl_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","“Huan sinta ipan icuetaxo nopa masehuali quinpiya manchas cati chijchipahuac pero amo palantoc hasta más huejcata, huan itzoyo amo mocuectoc chipahuac, monequi nopa totajtzi quitzacuas nopa masehuali iseltitzi para chicome tonati. ");
INSERT INTO nchBl_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Huan quema quiaxitis chicome tonati, nopa totajtzi sempa quitachilis. Huan sinta nesis para nopa cocot amo más mohueyilijtoc ipan icuetaxo, huajca quitzacuas para seyoc chicome tonati. ");
INSERT INTO nchBl_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Huan quema sempa ajsis nopa tonali chicome, monequi sempa quitachilis ica cuidado, huan sinta quiitas para nopa cocot amo más mohueyilía ipan icuetaxo huan pejtoc para tami, huajca nopa totajtzi teyolmelahuas para nopa masehuali eltoc tapajpactic noixpa. Pampa cati quipixtoya eliyaya san ten hueli cocot. Huan nopa masehuali monequi quichicuenis iyoyo, huan quej nopa sempa elis tapajpactic. ");
INSERT INTO nchBl_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Pero sinta nopa cocot mohueyilis teipa quema nopa totajtzi quiijto para tapajpactic, huajca monequi sempa hualas iixpa nopa totajtzi. ");
INSERT INTO nchBl_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Huan sinta nopa totajtzi quiijtos para nopa cocot mohueyilijtoc, huajca teyolmelahuas para nopa masehuali amo tapajpactic pampa quipiya tacayo palanca cocolisti. ");
INSERT INTO nchBl_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Quema se masehuali quinpiyas cocome ipan itacayo, monequi quihuicase iixpa totajtzi. ");
INSERT INTO nchBl_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Huan nopa totajtzi quitachilis ica cuidado, huan sinta quiitas para campa temitoc icuetaxo pehua mochihua chipahuac, huan itzoyo mocuectoc chipahuac, huan sinta tanemijya nesi inacayo tapojtoc campa temitoc, ");
INSERT INTO nchBl_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","huajca ya nopa eli nopa tacayo palanca cocolisti cati huejcajquiya quiajsitoc ipan icuetaxo. Huajca nopa totajtzi monequi teyolmelahuas para nopa masehuali amo tapajpactic. Amo monequi quitzacuas iselti para más quitachilise pampa quimati melahuac quipiya nopa cocolisti. ");
INSERT INTO nchBl_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Pero sinta nopa totajtzi quiitas para nopa mancha cati nopa masehuali quipiya ya mohueyilijtoc huan ya ajsitoc campa hueli ten iicxi huan hasta ipan itzonteco, ");
INSERT INTO nchBl_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","huajca quiijtos para nopa masehuali tapajpactic, pampa nochi ya mochijtoc chipahuac huan ya panotoc nopa palanca cocolisti. ");
INSERT INTO nchBl_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Pero sinta ipan icuetaxo quinpiya cocome tapojtoc cati nesi inelnacayo, huajca amo tapajpactic, ");
INSERT INTO nchBl_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","pampa tapojtoc icocohua huan nesi inelnacayo huan ya ni eltoc tacayo palanca cocolisti. ");
INSERT INTO nchBl_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","“Pero sinta nopa masehuali cati quipixqui se cocot tapojtoc huan nesiyaya inacayo teipa quiitas para icoco mocuectoc chipahuac, huajca monequi sempa yas campa nopa totajtzi para ma quitachilis. ");
INSERT INTO nchBl_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Huan nopa totajtzi quitachilis huan sinta campa cocojtoc nelía nesi chipahuac, huajca nopa totajtzi teyolmelahuas para tapajpactic nopa masehuali cati quinpixqui cocome. ");
INSERT INTO nchBl_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Quema icuetaxo se masehuali quipiyas se cocot cati temalquisa huan teipa mochicahuas, ");
INSERT INTO nchBl_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","pero mocahuas temitoc huan nesis chipahuac, o nesis chichiltic huan chipahuac, huajca nopa masehuali monequi yas campa nopa totajtzi para ma quitachili. ");
INSERT INTO nchBl_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Huan sinta nopa totajtzi quiitas para nopa cocot pejtoc huejcata, tatzinta ten icuetaxo, huan para itzoyo pehua para elis chipahuac, huajca monequi teyolmelahuas para nopa masehuali amo tapajpactic, pampa quipiya nopa tacayo palanca cocolisti cati pejqui quej se cocot ica temali. ");
INSERT INTO nchBl_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Pero sinta nopa totajtzi quitachilis huan amo quipantis itzoyo cati nesi chipahuac, huan sinta nopa cocot amo eltoc huejcata, huan san quentzi chipahuixtoc, huajca monequi quitzacuas iseltitzi para chicome tonati. ");
INSERT INTO nchBl_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Huan sinta itamiya nopa chicome tonati, nopa cocot mohueyilis achi más, huajca nopa totajtzi quiijtos para nopa masehuali amo tapajpactic pampa quipiya se cocot. ");
INSERT INTO nchBl_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Pero sinta nopa mancha cati chipahuac san campa eltoc, huan amo más mohueyilijtoc, huajca quimachilise para san mocahua lipintic icuetaxo campa pachijqui nopa cocot. Huan nopa totajtzi quiijtos para nopa masehuali eli tapajpactic noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Sinta se acajya motatis ipan itacayo ica ten hueli tamanti, huan sinta campa motatijtoc teipa nesis chipahuac, o nesis chichiltic huan chipahuac, ");
INSERT INTO nchBl_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","huajca nopa totajtzi quitachilis ica cuidado campa motatijtoc nopa masehuali. Huan sinta quiitas para cocojtoc achi huejcata hasta tatzinta ten icuetaxo huan itzoyo ya mocuectoc chipahuac, huajca ya quipiya nopa tacayo palanca cocolisti cati yolqui ten campa motati. Huan nopa totajtzi monequi quiijtos para nopa masehuali amo tapajpactic pampa quipiya nopa tacayo palanca cocolisti. ");
INSERT INTO nchBl_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Pero sinta nopa totajtzi quiitas para nopa masehuali amo quipiya itzoyo chipahuac campa cocojtoc, huan amo más huejcata, san ipan nopa icuetaxo huan nesi para ya caxantiya, huajca san quitzacuas iseltitzi para chicome tonati. ");
INSERT INTO nchBl_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Pero quema tantosa nopa chicome tonati, monequi sempa quitachilis nopa totajtzi. Sinta quiitas para campa cocojtoya achi más mohueyilijtoc, huajca nopa totajtzi quiijtos para, quena, nopa masehuali quipiya tacayo palanca cocolisti. ");
INSERT INTO nchBl_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Pero sinta campa cocojtoc amo más mohueyilijtoc huan nesi para ya caxantoc quentzi, huajca nopa totajtzi quiijtos para tapajpactic nopa masehuali noixpa. Cati quipiya eltoc pampa motati huan lipintic. ");
INSERT INTO nchBl_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Sinta se tacat o se sihuat quipiya se cocot ipan itzonteco o ipan itentzo, ");
INSERT INTO nchBl_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","huajca monequi yas campa nopa totajtzi para ma quitachili. Huan sinta nopa cocot nesis para panotoc tatzinta ten icuetaxo, huan sinta quiitas para nopona quipiya itzoyo cati nesi costic huan pitzantzi, huajca nopa totajtzi quiijtos para nopa masehuali amo tapajpactic pampa quipiya se tamanti cocot cati mochijtoc nopa tacayo palanca cocolisti ipan itzonteco o ipan itentzo. ");
INSERT INTO nchBl_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Pero sinta nopa totajtzi quiitas para nopa cocot amo ajsitoc tatzinta ten icuetaxo huan noja quipiya itzoyo cati yayahuic, huajca nopa totajtzi san quitzacuas nopa masehuali iseltitzi para chicome tonati. ");
INSERT INTO nchBl_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Huan quema tantosa nopa chicome tonati, nopa totajtzi monequi sempa quitachilis. Huan sinta quiitas para nopa cocot amo mohueyilijtoc huan amo pejtoc quipiya itzoyo cati nesi costic huan nesi para amo ajsitoc tatzinta ten icuetaxo nopa masehuali, ");
INSERT INTO nchBl_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","huajca nopa totajtzi quichihualtis ma quihuatani itentzo. Pero yaya amo hueli quihuatanis campa cocojtoc. Quema tamis mohuatanis, monequi noja mocahuas tzactoc para seyoc chicome tonati. ");
INSERT INTO nchBl_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Huan ipan nopa chicompa tonali nopa totajtzi sempa quitachilis. Huan sinta quiitas para nopa cocot amo mohueyilijtoc, huan nesi para amo ajsitoc huejcata ipan icuetaxo, huajca nopa totajtzi quiijtos para nopa masehuali eltoc tapajpactic. Huan teipa quema ya quichicuenijtos iyoyo, nopa masehuali mocahuas tapajpactic noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Pero sinta nopa cocot mohueyilis quema ya quiijto para tapajpactic, ");
INSERT INTO nchBl_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","huajca nopa totajtzi monequi sempa quitachilis. Huan ama, quena, sinta mohueyilijtoc, amo monequi quipantis itzoyo cati costic, pampa ya nesi nopa masehuali amo tapajpactic. ");
INSERT INTO nchBl_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Pero sinta quiitas para nopa cocot amo mohueyilía huan ya pejtoc para monextía itzoyo cati yayahuic, huajca quiijtosnequi ya caxantoc nopa cocot, huan tapajpactic nopa masehuali. Huajca nopa totajtzi quiijtos para tapajpactic. ");
INSERT INTO nchBl_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Huan quema se tacat o se sihuat pehuas para quipiyas ipan icuetaxo cocome cati nesi chipahuac, ");
INSERT INTO nchBl_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","huajca nopa totajtzi quitachilis icuetaxo nopa masehuali ica cuidado. Sinta quiitas nopa cocot san se quentzi chipahuac, huajca amo ya nopa tacayo palanca cocolisti. San quipiya ten hueli cocolisti cati quiajsic ipan icuetaxo huan tapajpactic eli nopa tacat noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Sinta se masehuali tepehuis nochi itzoncal hasta ayecmo mocahuas yon se, huajca nopa masehuali amo quipiya tacayo palanca cocolisti. ");
INSERT INTO nchBl_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Huan sinta se masehuali tepehuis itzoncal icuaixco huan ipan icuajtol, huajca ya nojquiya tapajpactic, amo quipiya cocolisti. ");
INSERT INTO nchBl_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Pero sinta campa tepehui itzoncal eltos se cocot cati nesis chipahuac huan chichiltic, huajca quiijtosnequi pejtoc tacayo palanca cocolisti campa tepejtoc itzoncal. ");
INSERT INTO nchBl_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Huajca monequi nopa totajtzi quitachilis campa yoli nopa cocot ipan itzonteco, o icuaixco. Sinta quiitas para nesi chipahuac huan chichiltic quej nopa tacayo palanca cocolisti, ");
INSERT INTO nchBl_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","huajca ya nopa quipiya huan amo tapajpactic. Huan nopa totajtzi monequi quiijtos para nopa masehuali melahuac quipiya tacayo palanca cocolisti ipan itzonteco. ");
INSERT INTO nchBl_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Se masehuali cati quipiya tacayo palanca cocolisti monequi quihuicas iyoyo tzayantoc, huan amo huelis moxilhuis. Monequi quitentzacuas ica se yoyomit huan monequi tzajtzitiyas: ‘Amo nitapajpactic. Amo nitapajpactic.’ ");
INSERT INTO nchBl_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Huan masque nopa cocolisti huejcahuas ipan itacayo, monequi itztos iseltitzi huejca ten campa mochijtoque ne sequinoc masehualme. ");
INSERT INTO nchBl_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Huan sinta se iyoyo o itaque se masehuali pojyajtoc, o quipiya se mancha monequi quitachilis nopa totajtzi, masque eltoc cati tachijchihuali ica lino o ica borregojme iniijhuiyo. ");
INSERT INTO nchBl_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","Masque nopa mancha eltoc ipan nopa icpat ten nopa yoyomit, o masque nopa yoyomit, o tamanti cati poyajtoc tasencahuali ica tapiyalme inincuetaxo; sinta yoli se mancha, huajca xijhuicaca campa nopa totajtzi. ");
INSERT INTO nchBl_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Huan sinta nesi quentzi xoxohuic o quentzi chichiltic nopa mancha cati yoli ipan nopa yoyomit o nopa tamanti cati quichijtoque ica cuetaxti, huajca campa nopa mancha ya pejtoc nopa tacayo palanca cocolisti, huan monequi quihuicase iixpa nopa totajtzi para ma quitachili. ");
INSERT INTO nchBl_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Huan nopa totajtzi quitachilis nopa yoyomit, o nopa tamanti, huan quiiyocatalis para chicome tonati. ");
INSERT INTO nchBl_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Huan quema ajsis tonali chicome, nopa totajtzi sempa quitachilis nopa mancha. Huan sinta quiitas para mohueyilijtoc ipan nopa yoyomit o ipan nopa cuetaxti, huajca quiijtosnequi para eli se mancha ten tacayo palanca cocolisti cati nelía fiero. Huajca nopa tamanti mocahuas amo tapajpactic masque taxinepaloli ipan nopa yoyomit, o mopantía ipan se tamanti ten cuetaxti. ");
INSERT INTO nchBl_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Huajca nopa yoyomit cati tachijchihuali ica lino, o ica borregojme iniijhuiyo, o nopa tamanti ten cuetaxti cati quipiya nopa mancha monequi quitatise pampa quipiya nopa tacayo palanca cocolisti cati nelía fiero. ");
INSERT INTO nchBl_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Pero sinta quema tamis chicome tonati, nopa totajtzi quitachilis huan quiitas para nopa mancha amo más mohueyilijtoc, ");
INSERT INTO nchBl_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","huajca quinnahuatis cati quihualicaque ma quichicuenica nopa tamanti cati quipiya nopa mancha, huan sempa quiiyocatalis seyoc chicome tonati. ");
INSERT INTO nchBl_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","“Huan quema ya quipajpactose, nopa totajtzi quitachilis sempa, huan sinta nesis para nopa mancha noja mocajtoc huan amo quipatatoc itachiyalis, huajca nopa tamanti monequi quitatise masque amo mohueyilijtoc más pampa quipiya nopa tacayo palanca cocolisti. Masque nopa mancha san ajsi ipan se lado o ajsi ipan nochi ome lados, monequi xijtatica. ");
INSERT INTO nchBl_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Pero sinta nopa totajtzi sempa quitachilis huan quiitas para nopa mancha ayecmo más nesi quej achtohui, huajca san quitejtequis huan quiquixtis campa monextijtoc nopa mancha ipan nopa yoyomit, o cuetaxti o ipan nopa tamanti cati taxinepaloli. ");
INSERT INTO nchBl_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Pero sinta nopa mancha sempa monextis campa hueli ipan nopa yoyomit, o ipan nopa tamanti ten cuetaxti, huajca nopa tamanti cati quipiya mancha monequi quitatise. ");
INSERT INTO nchBl_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Pero sinta quema ya quichicuenijtose nopa yoyomit o nopa tamanti ten cuetaxti ayecmo monextis nopa mancha, huajca san monequi quichicuenise seyoc huelta, huan teipa mocahuas tapajpactic huan sempa huelis quitequihuise. ");
INSERT INTO nchBl_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","“Huajca ya ni elqui nopa tanahuatili para nopa tacayo palanca cocolisti cati monextía ipan yoyomit cati tachijchihuali ica lino, o ica borregojme iniijhuiyo, o ica cuetaxti, o monextijtoc ipan sequinoc tamanti cati tachijchihuali ica tapiyalme inincuetaxo. Quena, ya ni nopa tanahuatili cati quitequihuise para quiijtose sinta nopa tamanti eli tapajpactic o eli amo tapajpactic.” ");
INSERT INTO nchBl_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Ya ni nopa tanahuatilme para se masehuali cati quipixtoya nopa tacayo palanca cocolisti huan quinequi hualas campa nopa totajtzi para motapajpacchihuas. ");
INSERT INTO nchBl_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Nopa totajtzi monequi yas campa itztoc nopa cocoxquet huejca ten campa anmochantijtoque para quitachilis ica cuidado. Sinta quiitas para ya pachijtoc campa quipixqui nopa cocot, ");
INSERT INTO nchBl_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","huajca tajtanis ma quihuiquilica ome totome cati tapajpactique huan cati anquipiyaj caquihuili para anquicuase. Tajtanis ma quinhuiquilica nepa campa itztoc nopa cocoxquet ihuaya tiocuahuit, se icpat cati chichiltic huan se imacuayo nopa xihuit cati itoca hisopo. ");
INSERT INTO nchBl_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Teipa nopa totajtzi tanahuatis ma quiquechtzontequica se ten nopa ome totome. Quena, monequi quiquechtzontequis ipan se comit cati tachijchihuali ica soquit huan quipiya at ten se ameli. ");
INSERT INTO nchBl_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Huan quicuis ica nopa tiocuahuit, huan nopa icpat cati chichiltic huan imacuayo nopa hisopo xihuit huan nopa seyoc piltototzi cati noja itztoc huan san sejco quinxolonis ica nopa achtohui tapiyali ieso ipan nopa comit cati quipiya at cati huala ten se ameli. ");
INSERT INTO nchBl_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Huan teipa ica nopa tamanti cati xolontoc quiatzejtzelhuis nopa totajtzi chicome huelta nopa masehuali cati motapajpacchihuas ten icocolis. Huan teipa quiijtos para tapajpactic. Huan nopa totot cati noja yoltoc quimajcahuas para ma patantinemi campa cuatitamit. ");
INSERT INTO nchBl_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Teipa nopa masehuali cati ya motapajpacchijtoc, monequi quichicuenis iyoyo, huan quihuatanis itzoncal. Monequi maltis huan sempa calaquis para itztos campa nochi sequinoc israelitame mochijtoque. Pero noja ayemo huelis calaquis ipan ichaj ten yoyomit. ");
INSERT INTO nchBl_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Huan ipan nopa chicompa tonali, nopa masehuali monequi sempa quitequis nochi itzoncal, itentzo huan iixtentzoyo. Teipa sempa quichicuenis iyoyo huan maltis, huan ica ya nopa, motapajpacchihuas ten nopa cocolisti cati quipixtoya. ");
INSERT INTO nchBl_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Huan ipan tonali chicueyi, quincuis eyi pilborregojtzitzi cati quipiyaj sesen xihuit huan cati amo quipiyaj yon se tamanti cati amo cuali ipan inintacayo. Monequi ome oquichme huan se sihuatzi cati cuali inintacayo. Nojquiya quicuis chicome litro harina cati nelcuechtic huan tamaneloli ica aceite para se tacajcahualisti ten harina, huan ihuaya quihuicas tajco litro aceite. ");
INSERT INTO nchBl_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Huan nopa totajtzi cati tetapajpacchihua, quihuicas nopa masehuali cati motapajpacchihuas noixpa, niamoTECO. Huan ihuaya quihualicas nochi nopa tamantzitzi cati motequihuis, huan temacas noixpa na, niamoTECO nepa campa icalte nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Teipa nopa totajtzi quicuis se ten nopa piloquich borregojtzitzi huan nopa tajco litro aceite huan quitencahuas noixpa quej se tacajcahualisti para nopa masehuali cati quihuica tajtacoli. Huan para techmacas monequi quinhuisos noixpa, niamoTECO. Huan elis quej se tacajcahualisti tahuisoli. ");
INSERT INTO nchBl_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Huan teipa nopa totajtzi quiquechtzontequis nopa pilborregojtzi nopona campa yoyon tiopan caltemit campa quinmictíaj nopa tapiyalme para tacajcahualisti por tajtacoli huan para tacajcahualisti tatatili. Huan nopa tacajcahualisti por tajtacoli huan ni tacajcahualisti para cati quihuica tajtacoli noixpa elis iaxca nopa totajtzi para itacualis pampa tahuel tatzejtzeloltic. ");
INSERT INTO nchBl_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","“Huan nopa totajtzi quicuis se quentzi ieso nopa tapiyali cati quitencajtoc quej se tacajcahualisti para cati quihuica tajtacoli noixpa huan nopa esti quiajalos ipan inacas nejmat nopa masehuali cati motapajpacchihuas. Nojquiya quiajalos ipan imacpil cati hueyi ten imax nejmat huan ipan ixocpil cati hueyi ten iicxi nejmat. ");
INSERT INTO nchBl_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","“Teipa nopa totajtzi quicuis nopa aceite huan quitecas quentzi ipan ten ya imax arraves. ");
INSERT INTO nchBl_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Huan teipa nopa totajtzi quixolonis imacpil ten imax nejmat ipan nopa aceite huan ica imacpil taatzejtzelhuis chicome huelta noixpa na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Huan ica nopa aceite cati noja mocahuas ipan nopa totajtzi imax, quiajalos se quentzi inacas nejmat nopa masehuali cati motapajpacchihuas. Huan nojquiya quiajalos ipan imacpil cati hueyi ten imax nejmat huan ipan ixocpil cati hueyi ten iicxi nejmat. Huan nojquiya quitalis aceite ipan nopa esti ten nopa tacajcahualisti para cati quihuica tajtacoli noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Huan nopa aceite cati noja mocahuas imaco nopa totajtzi quitequihuis para quiajalos ipan itzonteco nopa masehuali cati motapajpacchihuas huan techixtzacuilis itajtacolhua. ");
INSERT INTO nchBl_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Teipa nopa totajtzi techmacas nopa tacajcahualisti por tajtacoli para quiixtzacuas itajtacolhua nopa masehuali cati quitapajpacchihua ten nopa cocolisti cati quichijtoya amo tapajpactic. Huan teipa quimictis nopa tapiyali cati techmacas quej se tacajcahualisti tatatili. ");
INSERT INTO nchBl_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Huan techmacas ipan taixpamit nopa tacajcahualisti tatatili ihuaya nopa tacajcahualisti ten harina. Huan ica nochi ya ni, nopa totajtzi techixtzacuilis nopa masehuali itajtacolhua, huan yaya mocahuas tapajpactic. ");
INSERT INTO nchBl_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Pero sinta nopa masehuali eli tahuel teicneltzi huan amo huelis quincohuas ome pilborregojtzitzi, huajca hueli techmacas setzi pilborregojtzi quej se tacajcahualisti para cati quihuica tajtacoli, pero achtohui quihuisos noixpa, niamoTECO, para se tacajcahualisti tahuisoli para techixtzacuilis itajtacolhua. Huan para nopa tacajcahualisti ten harina, san quihualicas ome kilo huan tajco harina cati tamaneloli ica aceite, ihuaya se tajco litro aceite. ");
INSERT INTO nchBl_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","“Nojquiya quinhuicas ome pichones o ome palomas quej quiitas para quiaxilía itomi. Huan se ten nopa ome totome elis para techmacas quej se tacajcahualisti por tajtacoli, huan nopa seyoc techmacas quej se tacajcahualisti tatatili. ");
INSERT INTO nchBl_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Nochi ya nopa monequi quihuicas ipan nopa chicueyi tonali. Huan quimactilis nopa totajtzi nopona noixpa campa icalte nopa yoyon tiopamit campa timopantíaj. ");
INSERT INTO nchBl_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Huan nopa totajtzi quicuis nopa pilborregojtzi cati techmacas na, niamoTECO, quej se tacajcahualisti para cati quihuica tajtacoli. Nojquiya quicuis nopa tajco litro aceite, huan elis quej se tacajcahualisti cati quihuisos noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Teipa quiquechtzontequis nopa pilborregojtzi para se tacajcahualisti para cati quihuica tajtacoli, huan quicuis se quentzi ieso huan quiajalos ipan inacas nejmat nopa masehuali cati quipajpaca huan quiajalos ipan imacpil cati hueyi ten imax nejmat huan ixocpil cati hueyi ten iicxi nejmat. ");
INSERT INTO nchBl_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","“Teipa nopa totajtzi quicuis nopa aceite huan quitecas se quentzi ipan imax cati iarraves. ");
INSERT INTO nchBl_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Huan teipa quixolonis imacpil ten imax nejmat huan ica nopa aceite taatzejtzelhuis chicome huelta noixpa, na niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Nojquiya nopa totajtzi quicuis se quentzi nopa aceite cati quipixtoc ipan imax cati arraves huan quiajalos inacas nejmat nopa masehuali cati motapajpacchihua. Nojquiya quiajalos ipan imacpil cati hueyi ten imax nejmat huan ipan ixocpil cati hueyi ten iicxi nejmat. San se quiajalos campa quiajalo ieso nopa tapiyali cati quitencajque para tacajcahualisti para cati quihuica tajtacoli. ");
INSERT INTO nchBl_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Huan nopa aceite cati noja mocahuas ipan imax nopa totajtzi, quiajalos ipan itzonteco nopa masehuali cati motapajpacchihua. Ya nopa techixtzacuilis itajtacol, na niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","“Teipa techmacas nopa totajtzi se ten nopa palomas o nopa pichones, ten hueli cati quiaxili itomi para quicohuas. ");
INSERT INTO nchBl_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Techmacas se quej se tacajcahualisti por tajtacoli huan nopa seyoc techmacas quej se tacajcahualisti tatatili, huan ihuaya techmacas nopa tacajcahualisti ten harina. ");
INSERT INTO nchBl_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","“Huajca ya ni elqui nopa tanahuatilme cati monequi quitoquilis se masehuali cati ayecmo quipiya tacayo palanca cocolisti huan amo quiaxilis para temacas se tacajcahualisti patiyo para ica motapajpacchihuas.” ");
INSERT INTO nchBl_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Huan TOTECO quiilhui Moisés huan Aarón: ");
INSERT INTO nchBl_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Quema ya anajsitose ipan tali Canaán cati na nimechmacatoc para amoaxca huan na nijtalis ipan se cali se mancha cati nesi para quipiya se hueyi cocolisti huan amo san axoloquistoc; ");
INSERT INTO nchBl_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","huajca nopa masehuali cati iaxca nopa cali monequi yas quiitati nopa totajtzi huan quiilhuis: ‘Na niquita para ipan nochaj pejtoc mopanextía se mancha ten nopa hueyi cocolisti.’ ");
INSERT INTO nchBl_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","“Huan quema nopa totajtzi ayemo calaqui ipan nopa cali, tanahuatis ma quisaca nochi cati itztoque nopona huan ma quiquixtica nochi tamantzitzi cati eltoc calijtic. Quej nopa amo quiijtos para amo tapajpactique nochi nopa masehualme huan nopa tamantzitzi cati nopona onca. Huan teipa quema ya quistose, nopa totajtzi calaquis huan quitachilis nopa mancha cati mopanextijtoc. ");
INSERT INTO nchBl_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","“Huan sinta nopa totajtzi quiitas para nopona campa coyontoc nopa tapepecholme mopanextijtoque manchas cati nesij chichiltique o xoxohuique huan nesij para calactoque hasta huejcata ipan tapepecholi, ");
INSERT INTO nchBl_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","huajca nopa totajtzi quisas huan quitzacuas nopa cali para chicome tonati. ");
INSERT INTO nchBl_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Huan quema ajsis nopa chicome tonali, nopa totajtzi monequi sempa hualas quitachiliqui. Sinta quiitas para nopa mancha mohueyilijtoc ipan nopa tapepecholi, ");
INSERT INTO nchBl_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","huajca tanahuatis ma quiquixtica nopa teme ipan tapepecholi campa mopanextijtoc nopa mancha, huan monequi quimajcahuatij huejca ten campa anmochijtoque ipan se lugar cati amo tapajpactic. ");
INSERT INTO nchBl_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Huan nojquiya tanahuatis ma quihuatanica nopa tapepecholi yahualtic campa eltoya nopa mancha. Huan nochi nopa soquit huan taltepocti quicahuatij huejca ten campa anmochijtoque ipan se lugar cati amo tapajpactic. ");
INSERT INTO nchBl_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Teipa nopa tacame quicuise sequinoc teme para quitalise ipan campa quiijcuenijque nopa teme cati quipiyayayaj manchas. Huan nojquiya quitalise yancuic soquit para quitatzquiltise nopa tet. ");
INSERT INTO nchBl_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Pero sinta nopa mancha sempa mopanextis ipan nopa cali quema ya quipatatose nopa teme, huan ya quihuatanijtose nopa tapepecholi huan ya quitalilijtose soquit cati yancuic, ");
INSERT INTO nchBl_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","huajca nopa totajtzi calaquis huan sempa quitachilis ica cuidado. Huan sinta quiitas para nopa mancha mohueyilijtoc ipan nopa tapepecholi, huajca quiijtosnequi ya pejtoc nopa hueyi cocolisti cati más fiero ipan nopa cali. Huan nopa cali elis amo tapajpactic huan quej nopa mocahuas. ");
INSERT INTO nchBl_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Huajca monequi ma quitamiltica nopa cali huan nochi tet huan cuahuit huan soquit ma quicahuatij ipan se lugar campa amo tapajpactic cati mocahua huejca ten campa anmochijtoque. ");
INSERT INTO nchBl_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Huan sinta acajya calaquis calijtic ipan nopa tonali quema nopa totajtzi tanahuati para eltos tzactoc, huajca ya mocahuas amo tapajpactic hasta tayohua. ");
INSERT INTO nchBl_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Huan cati hueli cati tacuas o motecas ipan nopa cali quema tzactoc monequi quichicuenis iyoyo. ");
INSERT INTO nchBl_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Pero sinta quema ya quipatatoque nopa tet huan soquit, amo teno nesis quema sempa calaquis nopa totajtzi para quiitas nopa mancha, huajca quiijtos para nopa cali tapajpactic pampa nopa hueyi cocolisti ya ixpolijtoc. ");
INSERT INTO nchBl_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Huan quema nopa totajtzi quitapajpacchihuas nopa cali monequi quintequihuis ome totome, tiocuahuit, se icpat cati chichiltic huan se imacuayo nopa cuahuit cati itoca hisopo. ");
INSERT INTO nchBl_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Huan quiquechtzontequis se ten nopa ome totome ipan se huajcali cati tachijchihuali ica soquit cati quipiyas at cati huala ipan se ameli. ");
INSERT INTO nchBl_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","52","Huan nopa totajtzi quicuis nopa tiocuahuit, nopa hisopo xihuit imacuayo, nopa icpat cati chichiltic huan nopa seyoc totot cati yoltoc, huan san sejco quinxolonis ipan nopa achtohui totot ieso ihuaya nopa at ten ameli. Huan quinquixtis huan quiatzejtzelhuis chicome huelta nopa cali. Huan quej nopa quitapajpacchihuas nopa cali. ");
INSERT INTO nchBl_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Teipa yas huejca ten nopa altepet huan quimajcahuas nopa totot cati itztoc para ma patani ipan cuatitamit. Huan quej nopa ya quichijtos nochi cati monequi para techixtzacuilis nopa tajtacoli cati eltoya ipan nopa cali, huan nopa cali mocahuas tapajpactic.” ");
INSERT INTO nchBl_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","55","Nochi ya ni eli nopa tanahuatili para campa hueli campa quipantíaj manchas ten nopa hueyi cocolisti masque mopanextía ipan se cali, o ipan se yoyomit, o ipan icuetaxo se masehuali, ");
INSERT INTO nchBl_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","o sinta mopanextía campa samajtoc itacayo se masehuali, o campa motatijtoc, o campa iseli yoli se mancha. ");
INSERT INTO nchBl_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Huan ica ni tanahuatilme ten cocolisti ipan icuetaxo se masehuali o ipan ten hueli tamanti, anquimatise quema amo tapajpactic se tamanti huan quema tapajpactic. ");
INSERT INTO nchBl_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Huan TOTECO quiilhui Moisés huan Aarón: ");
INSERT INTO nchBl_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Xiquinilhuica nopa israelitame ni tanahuatilme. Quema se tacat quipiya at cati mojmosta temo ipan itacayo, huajca amo tapajpactic nopa tacat. ");
INSERT INTO nchBl_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Huan masque quisehuiquilis toyahuis o motzacuas, nopa tacat mocahuas amo tapajpactic. ");
INSERT INTO nchBl_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“Nochi tapechti cati ipan motecas nopa tacat cati aquisa mochihuas amo tapajpactic. “Huan campa mosehuis, quichihuas para nopa siyaj o nopa tamanti elis amo tapajpactic noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","“Huan cati hueli cati quitoxomas nopa tapechti, monequi quichicuenis iyoyo huan maltis, huan noja mocahuas amo tapajpactic hasta tayohua. ");
INSERT INTO nchBl_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","“Huan sinta se masehuali mosehuis ipan nopa siyaj o nopa tamanti campa ipan mosehui nopa tacat cati aquisa, huajca monequi quichicuenis iyoyo huan maltis, huan noja mocahuas amo tapajpactic hasta tayohua. ");
INSERT INTO nchBl_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“Huan cati hueli cati quitoxomas nopa tacat cati aquisa, monequi quichicuenis iyoyo, huan maltis, huan noja mocahuas amo tapajpactic hasta tayohua. ");
INSERT INTO nchBl_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“Huan sinta nopa tacat cati aquisa chajchas ipan se masehuali cati tapajpactic, huajca elis amo tapajpactic. Monequi nopa masehuali quichicuenis iyoyo huan maltis ica at, huan mocahuas amo tapajpactic hasta tayohua. ");
INSERT INTO nchBl_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“Huan sinta nopa tacat cati atemo tejcos ipan se cahuayo, huajca nopa cahuayojsiya mochihuas amo tapajpactic. ");
INSERT INTO nchBl_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","“Cati hueli cati quitoxomas o quihuicas se tamanti cati ipan mosehuijtoc, o motectoc nopa tacat cati atemo, mocahuas amo tapajpactic hasta tayohua. “Huan nopa masehuali monequi quichicuenis iyoyo huan maltis, huan noja mocahuas amo tapajpactic hasta tayohua. ");
INSERT INTO nchBl_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“Sinta nopa tacat cati atemo quiitzquis se acajya ica imax huan amo momajtequijtoc, huajca nopa tacat cati quiitzquili imax monequi quichicuenis iyoyo huan maltis, huan noja mocahuas amo tapajpactic hasta tayohua. ");
INSERT INTO nchBl_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“Sinta nopa tacat cati atemo quiitzquis se comit cati tachijchihuali ica soquit, huajca nopa comit monequi quitapanase. Huan sinta quinitzquis tamantzitzi cati tachijchihualme ica cuahuit, huajca nopa tamanti san monequi quinpajpacase ica at. ");
INSERT INTO nchBl_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“Sinta ayecmo atemos nopa tacat, huan quinequis pehuas motapajpacchihuas monequi achtohui quichiyas seyoc chicome tonati. Huan sinta quiitas ayecmo atemo, huajca quichicuenis iyoyo huan mopajpacas ica at ten ameli. ");
INSERT INTO nchBl_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Huan ipan tonali chicueyi, quincuis ome pichones o ome palomas huan monextis iixpa TOTECO campa icalte nopa yoyon tiopamit huan quinmacas nopa totajtzi. ");
INSERT INTO nchBl_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Huan nopa totajtzi techmacas se quej se tacajcahualisti por tajtacoli. Huan nopa seyoc techmacas quej se tacajcahualisti tatatili. Huan quej nopa, nopa totajtzi techixtzacuilis itajtacol nopa tacat por nopa atemolisti cati quipixqui. ");
INSERT INTO nchBl_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“Quema se tacat quitoyahuas ixinacho, monequi quipajpacas nochi itacayo ica at, huan noja mocahuas amo tapajpactic hasta tayohua. ");
INSERT INTO nchBl_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","“Huan sinta toyahuis se quentzi ipan se yoyomit o ipan se cuetaxti, huajca nopa tamanti monequi quipajpacase ica at huan noja mocahuas amo tapajpactic hasta tayohua. ");
INSERT INTO nchBl_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","“Huan quema se tacat itztos ihuaya se sihuat huan quitoyahuas ixinacho, huajca nochi ome monequi mopajpacase ica at, huan mocahuase amo tapajpactic hasta tayohua. ");
INSERT INTO nchBl_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Huan quema se sihuat esotemos, mocahuas amo tapajpactic para chicome tonati. “Huan cati quiitzquis nopa sihuat, mocahuas amo tapajpactic hasta tayohua. ");
INSERT INTO nchBl_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“Nochi tamanti cati ipan motecas o mosehuis nopa sihuat ipan nopa chicome tonati, mocahuas amo tapajpactic. ");
INSERT INTO nchBl_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","“Huan cati hueli cati quiitzquis itapech nopa sihuat cati esotemo, monequi quichicuenis iyoyo huan maltis, huan noja mocahuas amo tapajpactic hasta tayohua. ");
INSERT INTO nchBl_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","23","“Huan cati hueli cati quiitzquis nopa tapechti, o nopa siya, o ten hueli tamanti cati ipan mosehui nopa sihuat cati esotemo monequi quichicuenis iyoyo huan maltis, huan noja mocahuas amo tapajpactic hasta tayohua. ");
INSERT INTO nchBl_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“Sinta se tacat cochis ihuaya nopa sihuat ipan nopa tonali quema esotemo huan ieso quiajsis, huajca nopa tacat mocahuas amo tapajpactic para chicome tonati. Huan ten hueli tapechti cati ipan motecas nopa tacat nojquiya mocahuas amo tapajpactic. ");
INSERT INTO nchBl_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“Huan sinta se sihuat noja esotemos miyac tonali quema ayecmo ipohual, o pehuas esotemos ipan se tonali quema amo ipohual, huajca amo tapajpactic san se quej quema nelía ipohual. ");
INSERT INTO nchBl_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","“Huan nochi tapechti huan siyas cati ipan mosehuis mocahuas amo tapajpactic san se quej elij amo tapajpactique quema nelía ipohual para esotemo. ");
INSERT INTO nchBl_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","“Nojquiya cati hueli cati quiitzquis nopa tapechti campa motejqui, o nopa siyas campa mosehui, mocahuas amo tapajpactic. Monequi quichicuenis iyoyo huan maltis, huan noja mocahuas amo tapajpactic hasta tayohua. ");
INSERT INTO nchBl_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“Huan quema ya tantos esotemo, monequi quipohuas chicome tonati huan teipa mocahuas tapajpactic. ");
INSERT INTO nchBl_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Huan ipan tonali chicueyi nopa sihuat cati esotemoyaya quema amo ipohual monequi quincuis ome pichones, o ome palomas, huan quinhuicas campa nopa totajtzi huan quimactilis nechca icalte nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Huan nopa totajtzi techmacas se ten nopa totome quej se tacajcahualisti por tajtacoli, huan nopa seyoc techmacas quej se tacajcahualisti tatatili. Huan quej nopa, nopa totajtzi techixtzacuilis nopa esotemolisti cati nopa sihuat quipixqui cati quichihuayaya amo tapajpactic noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“Monequi quej ni anquintapajpacchihuase israelitame quema amo tapajpactique. Pampa sinta amo motapajpacchihuase, quichihuase amo tapajpactic nopa yoyon tiopamit campa na niitztoc tatajco ten inijuanti, huan quej nopa monequi miquise. ");
INSERT INTO nchBl_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","“Huajca nochi ya ni elqui nopa tanahuatili para se tacat cati atemo o cati toyahui ixinacho huan yeca mocajqui amo tapajpactic. ");
INSERT INTO nchBl_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Huan ni tanahuatilme nojquiya eli para sihuame quema esotemoj quema ipohual huan quema amo ipohual. Nojquiya nica eltoc tanahuatilme para tacame cati cochij ihuaya se sihuat cati amo tapajpactic pampa esotemo.” ");
INSERT INTO nchBl_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","TOTECO quicamanalhui Moisés quema ya mictoyaj nopa ome itelpocahua Aarón. Mijque pampa monechcahuijque campa itztoc TOTECO pero amo quej quinamiqui. ");
INSERT INTO nchBl_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Huan TOTECO quiilhui: “Xiquilhui moicni, Aarón, amo hueli calaquis ten hueli hora ipan nopa cuarto cati Más Tatzejtzeloltic cati eltoc iica nopa cortina campa eltoc nopa caxa. Sinta calaquis nopona ipan se tonali quema amo onca tanahuatili para calaquis, miquis. Pampa iixco itzajca nopa caxa campa techixtzacuilis tetajtacolhua na noseltitzi niitztos ipan nopa mixti. ");
INSERT INTO nchBl_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Huajca quej ni monequi mocualtalis Aarón, quema ajsis nopa tonali sesen xihuit quema monequi calaquis ipan nopa cuarto cati Más Tatzejtzeloltic. Aarón monequi quihualicas se becerro para techmacas quej se tacajcahualisti por tajtacoli huan se oquich borrego para techmacas quej se tacajcahualisti tatatili. ");
INSERT INTO nchBl_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Achtohui monequi maltis, huan teipa monequi moquentis itatzintan yoyo cati huehueyac huan cati tatzejtzeloltic, huan monequi moquentis itatzintan yoyo ten lino. Teipa motalilis itzinquechilpica, huan motalilis icuatzajca pampa ya ni iyoyo cati tatzejtzeloltic. ");
INSERT INTO nchBl_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“Huan nopa israelitame quihuiquilise ome oquich chivojme para tacajcahualisti por tajtacoli. Huan quihuiquilise se oquich borrego para elis se tacajcahualisti tatatili. ");
INSERT INTO nchBl_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Pero achtohui monequi Aarón ma techmaca nopa becerro quej se tacajcahualisti por tajtacoli cati techixtzacuilis cati ya itajtacolhua huan cati ya ifamilia inintajtacolhua. ");
INSERT INTO nchBl_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Huan teipa quincuis nopa ome oquich chivojme huan quinhualicas noixpa campa icalte nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Huan teipa quichihuas suertes ica nopa ome oquich chivojme para quiitas catijqui elis para na, niamoTECO, huan catijqui elis para quihuicas tetajtacolhua campa tahuel huactoc campa ayecmo quema huelis tacuepilis. ");
INSERT INTO nchBl_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Huan Aarón quimictis nopa oquich chivo cati elis para na huan techmacas quej se tacajcahualisti por tajtacoli. ");
INSERT INTO nchBl_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Pero nopa oquich chivo cati elis para quihuicas tetajtacolhua huejca, quiixnextis noja yoltoc noixpa, niamoTECO. Huan teipa quitalis tetajtacolhua ipan nopa chivo quej monequi para techixtzacuilis inintajtacol huan teipa quititanis para yas huejca ipan nopa huactoc tali para quihuicas tetajtacolhua nopona huan ayecmo quema tacuepilis sempa. ");
INSERT INTO nchBl_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Huan quema Aarón ya quimictijtos huan ya quitencajtos nopa becerro para techixtzacuilis itajtacolhua huan itajtacolhua iteixmatcahua, ");
INSERT INTO nchBl_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","monequi quicuis se ticomit cati temitoc ica ticoli xahuantoc cati eltoc ipan taixpamit noixpa na, niamoTECO. Huan nojquiya quicuis ome tamojtzoli copali cati tatixti nelía cuechtic huan cati mijyotía ajhuiyac, huan calaquis ipan nopa cuarto iica nopa cortina. ");
INSERT INTO nchBl_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Huan nopona ipan nopa cuarto campa na, niamoTECO, niitztoc, quitalis nopa copali ipan nopa tit cati quihualica. Huan quema quitatis nopa copali, ipocyo quichihuas se mixti para quiixtzacuas nopa caxa itzajca para Aarón amo quiitas huan amo miquis. Pampa ipan itzajca nopa caxa eltoc campa nijnextis tasojtacayot para masehualme. Huan iijtic nopa caxa oncas nopa tepatacti ica nopa camanali cati nijchihua amohuaya. ");
INSERT INTO nchBl_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Teipa quihualicas se quentzi ieso nopa becerro huan ica imacpil quiatzejtzelhuis chicome huelta iixpa itzajca nopa caxa ica campa quisa tonati pampa nopona nitetasojta. Nojquiya taatzejtzelhuis ica imacpil seyoc chicome huelta iixmelac nopa caxa. ");
INSERT INTO nchBl_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Teipa quisas huan quimictis nopa oquich chivo cati techmacas quej se tacajcahualisti por tajtacoli para israelitame inintajtacolhua. Huan quihualicas quentzi ieso ipan nopa cuarto cati iica nopa cortina. Huan ica ya nopa, quiatzejtzelhuis iixco itzajca nopa caxa campa onca tasojtacayot para masehualme huan nojquiya quiatzejtzelhuis iixpa. Quena, san se quichihuas quej quichijqui ica nopa becerro ieso. ");
INSERT INTO nchBl_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Huan quej nopa techixtzacuilis nopa tajtacoli cati israelitame quihuicaj cati quichijtoc ma amo eli tapajpactic nopa cuarto cati Más Tatzejtzeloltic. Teipa san se quichihuas para quiixtzacuas nopa tajtacoli cati quichijtoc para nopa yoyon tiopamit ma amo eli tapajpactic. Pampa nopa yoyon tiopamit ica nopa cuarto cati Más Tatzejtzeloltic mocahua tatajco campa mochijtoque nopa tajtacolchijca israelitame cati amo tapajpactique noixpa. Yeca inintajtacolhua quichihua ma eli amo tapajpactic hasta calijtic ipan nopa yoyon tiopamit huan monequi anquitapajpacchihuase. ");
INSERT INTO nchBl_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","“Huan quema Aarón panos calijtic Campa Más Tatzejtzeloltic para quiixtzacuas itajtacolhua, huan ifamilia inintajtacolhua, huan inintajtacolhua israelitame, huan nochi nopa tajtacoli cati quichijtoc para nopa cuarto ma eli amo tapajpactic, amo hueli itztos yon se masehuali ipan nopa yoyon tiopamit hasta yaya quisas. ");
INSERT INTO nchBl_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Huan teipa yaya monequi quisas huan yas campa nopa taixpamit cati eltoc ipan calixpamit noixpa na, niamoTECO, para quiixtzacuas nopa tajtacoli cati onca nopona. Huan quicuis se quentzi ieso nopa becerro huan se quentzi ieso nopa oquich chivo huan quiajalos ipan nopa nahui icuacua nopa taixpamit cati eltoc ipan nahui inacasta. ");
INSERT INTO nchBl_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Huan ica imacpil quitzejtzelos nopa esti chicome hueltas ipan nopa taixpamit, huan ica ya nopa quitapajpacchihuas israelitame inintajtacolhua huan mocahuase tatzejtzeloltique. ");
INSERT INTO nchBl_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Huan quema Aarón tantosa quitapajpacchihua nopa cuarto cati Más Tatzejtzeloltic, huan nopa yoyon tiopamit huan nopa taixpamit, tanahuatis ma quihualiquilica nopa oquich chivo cati itztoc. ");
INSERT INTO nchBl_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Huan Aarón quitalis nochi ome imax ipan itzonteco nopa oquich chivo cati itztoc huan techpohuilis nochi inintajtacolhua huan inintaixpanolhua israelitame. Huan quema quitenpojtosa nochi tetajtacolhua, huajca nochi tetajtacolhua mocahuase ipan nopa tapiyali. Huan teipa se tacat cati yaya ya quitapejpenijtoc, ma quihuicas nopa tapiyali huan ma quicahuati huejca ipan nopa huactoc tali huan ayecmo quema tacuepilis. ");
INSERT INTO nchBl_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Huan quema nopa tacat quimajcahuati nopa chivo, quihuicas nochi tetajtacolhua más huejca ipan se tali cati tahuel huactoc huan amo quema tacuepilis. ");
INSERT INTO nchBl_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Huan teipa quema Aarón sempa calaquis yoyon tiopan calijtic monequi moquixtilis iyoyo huehueyac cati tachijchihuali ica lino cati moquentijtoya para calaquis ipan nopa cuarto Campa Más Tatzejtzeloltic huan quicahuas iyoyo nopona ipan nopa cuarto Campa Tatzejtzeloltic ten nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Teipa mopajpacas ica at nopona ipan calixpamit ipan nopa yoyon tiopamit campa tatzejtzeloltic, huan teipa sempa moquentis iyoyo cati huehueyac huan cati ipa quitequihuía. Huan teipa hualas huan techmacas nopa tacajcahualisti tatatili para ya huan nojquiya nopa seyoc tacajcahualisti para israelitame para quiixtzacuas itajtacolhua huan israelitame inintajtacolhua. ");
INSERT INTO nchBl_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Huan ichiyajca nopa tapiyali cati quitencajqui quej se tacajcahualisti por tajtacoli, quitatis ipan nopa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Huan nopa tacat cati quitapejpenijque para quihuicas nopa oquich chivo huejca huan quititanis ipan nopa tali cati tahuel huactoc, quichihuas nopa tequit huan teipa quichicuenis iyoyo huan mopajpacas ica at. Huan huajca, quena, huelis calaquis sempa campa anmochijtoque. ");
INSERT INTO nchBl_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","“Huan itacayo nopa becerro huan nopa oquich chivo cati elque tacajcahualisti por tajtacoli huan cati inieso quihuicac Campa Más Tatzejtzeloltic para quiixtzacuas tajtacoli nopona, monequi quihuicase tahuel huejca ten campa anmochijtoque. Nopona quintatise ihuaya inincuetaxo, inincuitaxcol, inincuit huan nochi cati eltoya iniijtico. ");
INSERT INTO nchBl_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Huan teipa nopa cati quinhuicac, monequi quichicuenis iyoyo, huan mopajpacas ica at, huan teipa sempa hueli tacuepilis campa anmochijtoque. ");
INSERT INTO nchBl_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Huajca ya ni nopa tanahuatilme cati monequi anquitepanitase nochipa: Ipan majtacti itequi nopa chicompa metzti ipan israelita calendario, amo anquichihuase yon se tamanti tequit, pero monequi anmoechcapanose noixpa huan anmoyolcuepase. Ma amo tequitica israelitame, yon seyoc tali ehuani cati itztoque amohuaya, pampa ya ni se tanahuatili cati monequi nochi anquitepanitase. ");
INSERT INTO nchBl_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Ipan ni tonali nopa totajtzi quiixtzacuas amotajtacolhua para amechtapajpacchihuas huan yeca anmochihuase antapajpactique ten nochi amotajtacolhua noixpa na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ipan nopa tonali monequi anmosiyajquetzase huan anmoyoltachilise para anmoechcapanose noixpa. Ya ni eli se tanahuatili cati monequi anquitepanitase para nochipa. ");
INSERT INTO nchBl_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Huan teipa quema itztos seyoc hueyi totajtzi cati quiajaltise huan quiiyocatalise para quiixtzacuas tajtacoli quej ipataca inintata Aarón, nopa yancuic totajtzi moquentis nopa yoyomit tatzejtzeloltic cati tachijchihuali ica lino. ");
INSERT INTO nchBl_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Huan yaya quiixtzacuas tajtacoli por nopa cuarto Campa Más Tatzejtzeloltic huan por nopa yoyon tiopamit, huan por nopa taixpamit. Huan nojquiya quiixtzacuas inintajtacolhua nopa totajtzitzi huan inintajtacolhua nochi israelitame. ");
INSERT INTO nchBl_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Huajca xijmatica ya ni se tanahuatili cati monequi anquitepanitase para nochipa: Se huelta ipan se xihuit monequi techixtzacuilise inintajtacolhua israelitame.” Huan Aarón quitoquili senquisa nochi ni tanahuatilme cati TOTECO quimacac Moisés. ");
INSERT INTO nchBl_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Teipa TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Xijmaca Aarón huan nochi israelitame ni tanahuatilme. ");
INSERT INTO nchBl_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","“Cati hueli israelita cati quimictis se huacax, se pilborregojtzi o se oquich chivo nechca ichaj o huejca ten campa anmochijtoque quihuicas tajtacoli noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","Nochi tacajcahualisti huan nochi tapiyalme cati anquinmictise para tacualisti monequi achtohui xiquinhualicaca campa icalte nopa yoyon tiopamit para antechmacase na, niamoTECO. Sinta se masehuali quihuicas se tapiyali sejcoyoc huan quimictis huan amo techmacatoc na quej niquijto, huajca quihuica tajtacoli pampa quitoyajqui esti. Huan nopa tacat monequi anquiquixtise ten campa amojuanti para ayecmo quema huelis itztos amohuaya. ");
INSERT INTO nchBl_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Nimechmaca ni tanahuatili para israelitame ayecmo quema ma quimictica tapiyalme ipan sejcoyoc. Monequi ma quinhualicaca campa icalte nopa yoyon tiopamit para techmacase na, niamoTECO. Ma quimacaca nopa totajtzi huan nopona quinmictise nopa tapiyali quej se tacajcahualisti para ma onca tayoltalili nohuaya na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Huan nopa totajtzi quiijtzelos nopa esti ipan nopa taixpamit cati eltoc nechca icalte nopa yoyon tiopamit. Huan nopa tachiyajcayot quitatis huan mijyotis ajhuiyac huan techyolpactis na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Huan yeca israelitame ayecmo quema hueli quinmacase tacajcahualisti nopa ajacame campa hueli. Quej se tacanenca sihuat cati quicajtejtoc ihuehue, nopa israelitame tajtacolchijtoque miyac noixpa pampa nechcajtejtoque para quintoquilise ajacame. Ni tanahuatili para san nechca nopa yoyon tiopamit huelis quinmictise tapiyalme monequi xijtepanitaca amojuanti huan amoteipan ixhuihua cati tacajtiyase teipa. ");
INSERT INTO nchBl_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Huajca xiquinilhui para yon se israelita o seyoc tali ejquet cati itztoc amohuaya hueli quimictis se tapiyali o quitencahuas se tacajcahualisti, ");
INSERT INTO nchBl_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","huan amo quihualicas campa icalte nopa yoyon tiopamit huan techmacas na, niamoTECO. Cati hueli cati quichihuas ya nopa, monequi anquiquixtise ten campa amojuanti para ayecmo quema hueli itztos ica anisraelitame. San nopona campa icalte nopa yoyon tiopamit nijtapejpenijtoc para antechmacase tacajcahualisti huan san nopona anquinmictise tapiyalme. ");
INSERT INTO nchBl_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“Nojquiya sinta se israelita o se seyoc tali ejquet cati itztoc amohuaya quicuas esti, huajca na tahuel nicualanis ica nopa masehuali huan nijquixtis ten campa amojuanti para ayecmo quema huelis itztos ica anisraelitame. ");
INSERT INTO nchBl_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Pampa inemilis nopa tapiyali mocahua ipan ieso cati quipixtoc ipan itacayo. Huan nopa esti nimechmacatoc para anquiijtzelose ipan nopa taixpamit para ica antaxtahuase huan anquiixtzacuase amotajtacolhua. ");
INSERT INTO nchBl_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","“Huajca nimechilhuía anisraelitame: Yon se ten amojuanti huan yon se seyoc tali ejquet cati itztoc amohuaya amo hueli quicuas esti. ");
INSERT INTO nchBl_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Huan sinta israelitame o seyoc tali ehuani tapehuatij huan quimictise se tamanti tapiyali o totot cati tapajpactic para anquicuase, monequi nopona campa quimictise, quitoyahuase talchi ieso huan ipani quitemilise tali. ");
INSERT INTO nchBl_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Pampa ininemilis nochi tamanti tapiyalme eltoc ipan inieso cati quipixtoque ipan ininacayo. Yeca niquinilhuijtoc ma amo quicuaca esti, pampa inieso nochi totome huan tapiyalme quinmaca nemilisti. Huajca cati hueli cati quicuas esti, monequi anquiquixtise ten campa amojuanti para ayecmo quema huelis itztos ica anisraelitame. ");
INSERT INTO nchBl_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“Huan cati hueli israelita o seyoc tali ejquet cati quicuas inacayo se tapiyali cati mijqui ica iseltitzi, o cati quimictijque sequinoc tapiyalme, monequi quichicuenis iyoyo huan mopajpacas ica at. Huan noja mocahuas amo tapajpactic hasta tayohua. Teipa quema ajsis tayohua, mochihuas tapajpactic. ");
INSERT INTO nchBl_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Pero sinta amo quichicuenis iyoyo, yon amo mopajpacas ica at, huajca quihuicas tajtacoli.” ");
INSERT INTO nchBl_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Xiquinilhui nopa israelitame ni tanahuatilme. “Na, niamoTECO Dios. ");
INSERT INTO nchBl_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","“Nimechilhuía amo xijchihuaca quej quichihuaj nopa masehualme cati ehuani ipan tali Egipto campa achtohuiya anitztoyaj. “Yon amo xijchihuaca quej quichihuaj nopa masehualme cati itztoque ipan nopa tali Canaán campa nimechhuicas. Yon amo anquitoquilise inintanahuatilhua. ");
INSERT INTO nchBl_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","5","“Monequi anquitoquilise senquisa cati quiijtohuaj notanahuatilhua huan anquichijtinemise nochi cati na nimechilhuía, pampa na niamoTECO Dios. Huan sinta anquineltocase huan anquichihuase senquisa cati quiijtohuaj notanahuatilhua, huajca anquipantise nemilisti por nopa tanahuatilme. Na, niamoTECO, nimechilhuía. ");
INSERT INTO nchBl_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“Amo aqui hueli cochis ica seyoc cati iteixmatca cati san se inieso. Na niamoTECO, nimechilhuía. ");
INSERT INTO nchBl_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“Se ichpocat amo hueli cochis ihuaya itata. Huan se telpocat amo hueli cochis ihuaya inana, pampa yaya inana huan amo quinamiqui para cochis ihuaya. ");
INSERT INTO nchBl_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“Amo ximocuili se sihuat cati achtohui itztoya ihuaya motata. ");
INSERT INTO nchBl_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“Amo xicochi ica se moicni o motepotz icni, masque elis san iichpoca motata, o san iichpoca monana. Amo hueli ticochis ihuaya masque nopa moicni tacatqui ipan san se cali mohuaya o tacatqui sejcoyoc. ");
INSERT INTO nchBl_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“Amo xicochi ihuaya se moixhui masque icone moichpoca o motelpoca. Elis quej timoixpanos ica moseli, pampa se moixhui eli quej ta. ");
INSERT INTO nchBl_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“Amo xicochi ihuaya se ichpocat cati motepotz icni, pampa quitacatilti motepotz nana. Yaya eli moicni huan iichpoca motata. ");
INSERT INTO nchBl_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“Amo xicochi ihuaya moahui cati motata isihua icni, pampa quipiyaj san se inieso ihuaya motata. ");
INSERT INTO nchBl_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“Amo xicochi ihuaya moahui cati monana isihua icni, pampa quipiyaj san se inieso ihuaya monana. ");
INSERT INTO nchBl_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“Amo xiquixpano motío cati motata itaca icni para ticochis ihuaya isihua, pampa eli moahui. ");
INSERT INTO nchBl_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“Amo xicochi ihuaya moyex, pampa eli motelpoca isihua. ");
INSERT INTO nchBl_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“Amo xicochi ihuaya isihua motaca icni pampa quej nopa tiquixpanos motaca icni. ");
INSERT INTO nchBl_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“Amo xicochi ihuaya se sihuat huan nojquiya ihuaya iichpoca. Yon amo xicochi ihuaya se sihuat huan teipa ihuaya se iixhui, pampa san se inieso huan niquita tahuel fiero. ");
INSERT INTO nchBl_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“Amo hueli timocuilis se sihuat huan nojquiya timocuilis iicni, pampa mocualancaitase. Pero sinta mosihua miquis, huajca, quena, hueli timocuilis mohuejpol. ");
INSERT INTO nchBl_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“Amo xicochi ihuaya se sihuat quema esotemo. ");
INSERT INTO nchBl_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“Amo xicochi ihuaya mohuampo isihua para amo tiquixpanos. ");
INSERT INTO nchBl_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“Amo xijtemactili yon se mocone quej se tacajcahualisti para nopa teteyot cati itoca Moloc, pampa elis quej techtelchihua na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“Se tacat ma amo quichihua tamanti ihuaya seyoc tacat quej elisquía isihua, pampa ya nopa se hueyi tajtacoli. ");
INSERT INTO nchBl_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“Yon se tacat amo hueli quichihuas tamanti ihuaya se tapiyali pampa nelía tahuel fiero. Huan se sihuat nojquiya amo hueli quichihuas tamanti ihuaya se tapiyali, pampa se hueyi tajtacoli huan amo quinamiqui. ");
INSERT INTO nchBl_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“Huajca amo xijchihuaca yon se tamanti cati amechchihuas amo antapajpactique. Nopa masehualme cati itztoque ipan nopa talme campa nimechhuicas, quichijtoque miyac tamanti huan tahuel mochijtoque amo tapajpactique huan yeca niquinquixtis amoixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Quena, nochi nopa tali mocajtoc amo tapajpactic ica nopa miyac tamanti, huan yeca nochi nopa masehualme cati itztoque nopona niquintatzacuiltis huan niquinquixtis. ");
INSERT INTO nchBl_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Pero monequi anquitepanitase cati nimechilhuijtoc huan senquisa anquichijtinemise notanahuatilhua. Amo xijchihuaca yon se ten nopa fiero tamanti cati inijuanti quichihuaj. Ni tanahuatili monequi anquitepanitase nochi anisraelitame huan nochi seyoc tali ehuani cati itztoque campa amojuanti. ");
INSERT INTO nchBl_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Pampa nochi ni tamanti cati tahuel fiero quichijtoque nopa masehualme cati itztoque ipan nopa tali campa nimechhuicas. Yeca nopa tali mocajtoc tahuel amo tapajpactic noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Amo xijchihuaca nopa tamanti cati amo cuali para amo nimechquixtis quej niquinquixti nopa masehualme cati nopona itztoque. ");
INSERT INTO nchBl_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Cati hueli cati quichihuas nopa tamanti cati fiero monequi anquiquixtise ten campa amojuanti para ayecmo quema huelis itztos ica anisraelitame. ");
INSERT INTO nchBl_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Huajca ximomocuitahuica miyac para xijneltocatinemica cati nimechilhuijtoc. Amo ximochihuaca amo tapajpactique noixpa ica nopa fiero tamanti cati quichihuayayaj nopa masehualme cati ama itztoque campa nimechhuicas. Na niamoTECO Dios.” ");
INSERT INTO nchBl_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Xiquinilhui nochi israelitame ni tanahuatilme. “Xiitztoca antatzejtzeloltique pampa na, niamoTECO Dios, nitatzejtzeloltic. ");
INSERT INTO nchBl_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“Sese ten amojuanti monequi anquitepanitase amotata huan amonana. “Huan monequi ximosiyajquetzaca ipan nochi nopa tonali para anmosiyajquetzase. Na, niamoTECO Dios, nimechilhuía. ");
INSERT INTO nchBl_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“Amo quema sempa ximotemachica ipan teteyome huan taixcopincayome. Na, niamoTECO Dios cati nimechilhuía. ");
INSERT INTO nchBl_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Huan quema antechmacase se tacajcahualisti para ma onca tayoltalili ica na niamoTECO, monequi antechmacase quej quinamiqui, pampa sinta amo quinamiqui, amo nijselis. ");
INSERT INTO nchBl_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Nopa nacat ten nopa tapiyali cati antechmacase para nopa tacajcahualisti monequi anquicuase nopa tonali quema antechmacase o tonili. Pero sinta mocahuas nacat hasta ihuictaca, monequi anquitatise. ");
INSERT INTO nchBl_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Huan sinta anquicuase se quentzi hasta hualhuicta, huajca ya nopa elis se tajtacoli noixpa huan na amo nijselis amotacajcahualis. ");
INSERT INTO nchBl_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Sinta cati quicuas hasta huicta nopa tacajcahualisti cati se techmacas para ma oncas tayoltalili ica na, yaya quihuicas tajtacoli noixpa huan quiselis tatzacuiltili pampa quichijtoc amo tapajpactic nopa tacajcahualisti cati eltoya tatzejtzeloltic para na, niamoTECO. Nopa masehuali monequi anquiquixtise ten campa amojuanti para ayecmo quema itztos ica anisraelitame. ");
INSERT INTO nchBl_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Quema ajsis nopa tonali para anpixcase ipan amomil, amo xijcuica hasta campa milteno, yon amo xijtemoca cati mocajtoc, yon amo xijpejpenaca cati tepejtoc. ");
INSERT INTO nchBl_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Huan san se anquichihuase ica amoxocomecamil. Amo xijtequica hasta inacasta amomil, yon amo xijtemoca cati mocajtoc o tepejtoc. Na niamoTECO Dios cati nimechilhuía. ");
INSERT INTO nchBl_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Amo xitachtequica. Amo ximocajcayahuaca. Amo ximoistacahuica se ica seyoc. ");
INSERT INTO nchBl_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“Amo techtestigojquetzaca na quema anquiijtohuaj anquichihuase se tamanti huan ya anquimatij amo anquichihuase. Sinta quej nopa anquichihuase, huajca anquisoquihuise notoca, na niamoTECO Dios. ");
INSERT INTO nchBl_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“Amo aqui xijtaijyohuiltica, yon amo xitetachtequilica. “Sinta se tequipanojquet tequiti ipan mochaj, amo xijchiya hasta seyoc tonali para tijmacas itaxtahuil. ");
INSERT INTO nchBl_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“Amo xijtelchihua se tacat cati amo hueli tacaqui. “Yon amo xijtali se tamanti campa nejnemi se popoyotzi para amo motepotanis. Monequi techimacasica na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Se tequichijquet monequi tetajtolsencahuas xitahuac. Amo ma quichicoicneli cati teicneltzi, yon cati tapijpiya o cati hueyi. Nochi monequi ma quinchihuili san se. ");
INSERT INTO nchBl_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“Amo xiquejelnamiqui se masehuali iniixpa sequinoc ichampoyohua quema yaya amo aqui. “Amo xijtatelhui se masehuali ica se tamanti cati amo melahuac pampa tijnequi ma miqui. Na niamoTECO cati nimechilhuía. ");
INSERT INTO nchBl_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Amo xijcualancaita seyoc ipan moyolo. “Quema seyoc mitzchihuilijtoc cati amo monequi, xiquilhui xitahuac cati itajtacol para yaya mocualtalis huan para amo tijhuicas tajtacoli nojquiya pampa amo teno tiquilhui. ");
INSERT INTO nchBl_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“Amo quema xijcuepili seyoc israelita cati mitzchihuilijtoc cati amo cuali, yon amo ximoyolilhui talojtzitzi cati mitzchihuilijtoc para más timocualancamacas. Monequi xiquicneli seyoc quej ta moselti timoicnelía. Na niamoTECO cati nimechilhuía. ");
INSERT INTO nchBl_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Monequi xijtepanitaca notanahuatilhua. “Amo xijmamalti mohuacax ica seyoc tamanti tapiyali. “Ipan momila amo xijtoca ome tamanti xinachti. “Yon amo ximoquenti se yoyomit cati tachijchihuali ica lino icpat huan ica icpat ten ichcat. ");
INSERT INTO nchBl_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Sinta se tacat ten hueli quichihuas ihuaya se ichpoca tequipanojquet cati ya quiijtantoc seyoc, pero noja iaxca iteco huan ayemo itztoc majcajtoc, huajca monequi quiselis tatzacuiltili nopa tacat, pero amo para miquis pampa nopa ichpocat noja eliyaya se tequipanojquet cati tacohuali. ");
INSERT INTO nchBl_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Huan nopa cati tajtacolchijqui monequi quihuicas se oquich borrego campa icalte nopa yoyon tiopamit para quimacas TOTECO quej se tacajcahualisti para cati quihuica tajtacoli. ");
INSERT INTO nchBl_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Huan nopa totajtzi quiixtzacuas nopa tacat itajtacolhua cati quichijtoc ica nopa oquich borrego cati elis nopa tacajcahualisti para nopa tajtacoli cati quihuica, huan na, niamoTECO, nijtapojpolhuis. ");
INSERT INTO nchBl_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Huan quema ancalaquise ipan nopa tali huan anquitocase nochi tamanti cuahuit cati temaca itajca, nopa achtohui eyi xihuit amo anquicuase yon se itajca pampa monequi anquiitase nopa cuatajcayot para amo tapajpactic. ");
INSERT INTO nchBl_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Huan ipan nopa nahui xihuit, nochi nopa cuatajcayot elis taiyocatalili para na, niamoTECO. Quena, nochi nopa cuatajcayot antechmactilise para antechpaquilismacase. ");
INSERT INTO nchBl_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Pero ipan macuili xihuit, quena, ya anhuelise anquicuase nopa cuatajcayot, huan sinta antechneltocase, nopa cuame noja más temacase inintajca. ");
INSERT INTO nchBl_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Amo hueli anquicuase yon se tamanti nacat ihuaya esti. “Nojquiya amo quema xitetonalitaca, yon xijcahuilica seyoc ma amechtonalitas. Amo xitenahualhuica, yon amo xijcahuili seyoc ma quinahualhui seyoc para ta. ");
INSERT INTO nchBl_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“Amo ximoximaca campa amocuajtol, yon amo xijhuatanica san amotentzo inacasta quej sequinoc quichihuaj para quitepanitase inintaixcopincayohua. ");
INSERT INTO nchBl_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“Amo quema xijcococa amotacayo quej inijuanti quichihuaj, yon amo xijtequica amotacayo quema anchocaj por cati mictoque. Amo xiquinixcopinaca taixcopincayome ipan amotacayo ica tinta. Na, niamoTECO, nimechnahuatía. ");
INSERT INTO nchBl_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Amo xijchihua para moichpoca ma moichpocapolo pampa ta tijtacanemilti. Pampa quej nopa anquichihuase para nopa tali cati nimechmacas ma eli tatelchihuali por ahuilnencayot huan quej nopa tafiero elis. ");
INSERT INTO nchBl_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“Xijtepanitaca nopa tonali cati nijtalijtoc para anmosiyajquetzase. Huan xijtepanitaca noyoyon tiopa. Na niamoTECO Dios. ");
INSERT INTO nchBl_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Amo quema xijtemoca se cati quincamanalhuía mijcatzitzi yon cati tetonalitaj. Yon amo quema xijtemoca se tamatquet, yon se cati mitzilhuis ten motonal pampa amechmahuisnenpolos noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Ximoquetzaca quema ajsi se huehuentzi o se nanatzi, huan xijnextilica miyac tatepanitacayot. Quema anquinextilíaj tatepanitacayot se huehuentzi o se nanatzi, antenextilíaj para antechimacasij na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Quema se seyoc tali ejquet hualas ipan amotal para mocahuas amohuaya, amo xijchihuilica cati amo cuali. ");
INSERT INTO nchBl_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Sinta se seyoc tali ejquet mocahuas amohuaya, monequi anquiitase quej se nopona ejquet. Quena, monequi xiquicnelica quej anmoicnelíaj pampa nojquiya anitztoyaj seyoc tali ehuani ipan tali Egipto. Na, niamoTECO Dios, nimechnahuatía. ");
INSERT INTO nchBl_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Quema antetajtolsencahuaj amo xitacajcayahuaca. Xijchihuaca san cati xitahuac. Quema anquitamachihuaj se tali o anquitamachihuaj se tenijqui ica ietica o ica imiyaca, monequi nochi nopa tatamachihuali elis senquisa xitahuac. ");
INSERT INTO nchBl_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","San xijtequihuica tatamachihuali, teme, barras huan cualitros cati senquisa xitahuac para antatamachihuase. Amo quema xitecajcayahuaca yon pilquentzi. Na, niamoTECO Dios, cati nimechquixti ipan tali Egipto. ");
INSERT INTO nchBl_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“Huajca ximomocuitahuica para anquintepanitase nochi notanahuatilhua huan anquichijtinemise senquisa nochi cati nimechnahuatía, pampa na, niamoTECO, cati nimechilhuía.” ");
INSERT INTO nchBl_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Xiquinilhui nopa israelitame ni tanahuatili. “Cati hueli cati itztoc amohuaya, masque se israelita o se seyoc tali ejquet, sinta temacas icone quej se tacajcahualisti para nopa teteyot cati itoca Moloc, monequi anisraelitame anquitepachose hasta miquis. ");
INSERT INTO nchBl_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Na nimochihuas icualancaitaca huan ayecmo nijcahuilis itztos pampa quimacatoc icone nopa teteyot. Ica ya nopa quichijtoc amo tapajpactic noyoyon tiopa huan techpinahualtijtoc na cati nitatzejtzeloltic, huan quipinahualtijtoc notoca. ");
INSERT INTO nchBl_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Huan sinta israelitame ipan nopa tali cati nimechmacas amo quichihuilise cuenta quema seyoc temaca icone ica se teteyot huan amo quinequij quitepachose huan quimictise, ");
INSERT INTO nchBl_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","na nojquiya nimochihuas icualancaitaca yaya cati amo quichihuili cuenta huan nimochihuas inincualancaitaca nochi ichampoyohua. Huan niquinquixtis ten anisraelitame para ayecmo quema huelis itztose amohuaya pampa amo quichihuili cuenta cati nopa tacat quichijqui. Amo san nijtatzacuiltis yaya cati temaca icone, pero nojquiya niquintatzacuiltis nochi masehualme cati yase quej ahuilnenca sihuame huan quihueyichihuase nopa teteyot Moloc. Nochi niquinquixtis ten campa amojuanti para ayecmo quema huelise itztose ica anisraelitame. ");
INSERT INTO nchBl_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Sinta cati hueli masehuali yas campa se cati quiijtohua quincamanalhuía mijcatzitzi o quiijtohua para tetonalita, quinextía para nechcajtejtoc. Itztoc quej se tacanenca sihuat cati momecatijtoc. Huan na nimochihuas icualancaitaca huan nijquixtis ten campa amojuanti para ayecmo quema itztos ica anisraelitame. ");
INSERT INTO nchBl_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“Huajca ximoiyocatalica ten ni tamanti huan xiitztoca antatzejtzeloltique, pampa na niamoTECO Dios cati nimechnahuatía. ");
INSERT INTO nchBl_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Xiquinneltocaca notanahuatilhua huan xiquinchijtinemica, pampa na, niamoTECO, cati nimechtatzejtzelolchihua. ");
INSERT INTO nchBl_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“Cati quitelchihuas inana o itata, monequi xijmictica pampa tahuel quihuica tajtacoli noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“Sinta se tacat cochis ihuaya seyoc tacat isihua, huajca nopa tacat huan nopa sihuat monequi xiquinmictica. ");
INSERT INTO nchBl_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“Sinta se tacat cochis ihuaya itata isihua, huajca nopa tacat quiixpano itata, huan nopa ome, sihuat huan tacat, monequi xiquinmictica pampa tahuel quihuicaj tajtacoli noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“Huan sinta se tacat cochis ihuaya iyex, huajca nopa ome monequi xiquinmictica pampa tahuel quiixpanotoque se ininteixmatca. ");
INSERT INTO nchBl_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“Sinta se tacat cochis ihuaya seyoc tacat huan quichihuilis quej elisquía isihua, huajca nopa ome quichijtoque cati amo nijnequi niquitas huan monequi xiquinmictica. Quena, miquise pampa tahuel quihuicaj tajtacoli noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“Sinta se tacat mocuilis se ichpocat huan nojquiya mocuilis inana nopa ichpocat, huajca fiero. Nopa eyi monequi xiquinmictica huan xiquintatica para anquiquixtise nopa hueyi tajtacoli ten campa amojuanti. ");
INSERT INTO nchBl_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“Sinta se tacat quichihuas cati amo quinamiqui ihuaya se tapiyali, huajca nopa tacat huan nopa tapiyali monequi xiquinmictica. ");
INSERT INTO nchBl_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“Huan sinta se sihuat quichihuas cati amo quinamiqui ihuaya se tapiyali, huajca nopa sihuat huan nopa tapiyali monequi xiquinmictica. Miquise pampa tahuel quihuicaj tajtacoli noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“Sinta se telpocat cochis ihuaya se ichpocat cati itepotzicni pampa yaya itata iichpoca o huelis inana iichpoca, huajca nopa ome monequi anquinhuicase iniixpa nochi israelitame huan xiquinquixtica miyacapa para ayecmo hueli itztose campa anisraelitame para nochipa huan xiquinitaca quej mictoque. Pampa sinta se tacat cochis ihuaya isihua icni eli se tamanti cati nelía monequi tatzacuiltili. ");
INSERT INTO nchBl_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“Sinta se tacat cochis ihuaya se sihuat ipan nopa tonali quema esotemo, huajca nopa ome monequi xiquinquixtica ten campa amojuanti para ayecmo quema itztose ica anisraelitame, pampa nopa tacat quiixtapo campa esotemo nopa sihuat huan nopa sihuat quinexti ieso. ");
INSERT INTO nchBl_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“Amo xijchihua cati amo quinamiqui ihuaya moahui, yon monana isihua icni, yon motata isihua icni. Pampa sinta se masehuali ya nopa quichihuas ihuaya se iteixmatca cati nechca, nochi ome quihuicase tajtacoli huan quiselise tatzacuiltili. ");
INSERT INTO nchBl_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“Sinta se cochis ihuaya itío isihua, huajca quiixpano itío. Huan nopa ome quihuicase tajtacoli noixpa. Quema miquise, amo quipixtehuase yon se inincone. ");
INSERT INTO nchBl_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“Sinta se tacat quicuilis isihua itaca icni, huajca quichihua se hueyi tajtacoli huan quiixpano itaca icni huan amo quipixtehuase yon se inincone. ");
INSERT INTO nchBl_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“Monequi xijneltocaca huan xijchijtinemica nochi cati quiijtohua notanahuatilhua para amo amechisotas nopa tali campa nimechhuica para anitztotij. ");
INSERT INTO nchBl_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Amo xijchihuaca quej nopa masehualme cati ama itztoque nopona ipan nopa tali huan monequi niquinquixtis amoixpa. Quena, inijuanti quichijtinentoque nochi ni fiero tamanti, huan yeca amo nijnequi niquinitas. ");
INSERT INTO nchBl_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Huajca na nijcajtoc nocamanal para anmoaxcatise inintal pampa na nimechmactilía para amoaxca. Nopa tali elis se cuali tali cati temacas itajca hasta mocahua. “Na, niamoTECO Dios, cati nimechiyocatalijtoc ten nochi sequinoc masehualme. ");
INSERT INTO nchBl_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“Huan yeca monequi anquiniyocatalise nopa tapiyalme cati niquinita para tapajpactique para anquincuase huan inijuanti cati amo tapajpactique huan amo cuali para anquincuase. Amo ximochihuaca amo antapajpactique noixpa ica yon se tapiyali o totot cati niquijtojtoc amo tapajpactic, o ica yon se tamanti cati mohuahuatatza talchi. Pampa na nimechiyocatalijtoc ten nopa tamanti cati amo tapajpactic. ");
INSERT INTO nchBl_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Monequi xiitztoca antatzejtzeloltique noixpa, pampa na cati niamoTECO nitatzejtzeloltic. Huan nimechiyocatalijtoc ten nopa sequinoc masehualme para xielica annoaxcahua. ");
INSERT INTO nchBl_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“Cati hueli tacat o sihuat cati quiijtohua quincamanalhuía inintonalhua mijcatzitzi o quicamanalhuía se cati tetonalita, monequi xijmictica ica tet. Inijuanti quihuicase tajtacoli por inimiquilis.” ");
INSERT INTO nchBl_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Huan TOTECO quiilhui Moisés: “Xiquinilhui nopa totajtzitzi cati itelpocahua Aarón para ma amo quiitzquica ten hueli mijcatzi pampa quinchihuas amo tapajpactique noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Huelis quiitzquise imijcatzi se ininteixmatca cati nelía nechca quej ininana, inintata, inioquichpil, inisihuapil, inintaca icni, ");
INSERT INTO nchBl_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","o se inisihua icni cati noja itztoc inimaco para quimocuitahuise pampa ayemo motahuicaltía. Ica inijuanti quena hueli quiitzquise inimijcatzitzi pampa ininteixmatcahua cati nelnechca. ");
INSERT INTO nchBl_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Pero amo hueli mochihuase amo tapajpactique ica itacayo se mijcatzi cati san mosejcotilijtoya ihuaya se tacat cati eliyaya se ininteixmatca quej sequinoc tacame monequi quichihuase quema onca se mijcatzi. ");
INSERT INTO nchBl_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“Nopa totajtzitzi amo hueli quinextis sinta motequipachohuaj quema miqui se masehuali. Amo quinamiqui quihuatanise inacasta inintentzo, yon amo hueli quitequise inintzoncal tahuel echcapa, yon amo quinamiqui quitequise inincuetaxo quej seyoc tali ehuani quichihuaj. ");
INSERT INTO nchBl_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Monequi elise senquisa tatzejtzeloltique para na, niamoTeco Dios. Pampa inijuanti cati techmacase nopa tacajcahualisti tatatili huan nopa pantzi cati noaxca na, niamoTECO. Yeca monequi totajtzitzi elise tatzejtzeloltique huan amo quiahuilmatise na notoca. ");
INSERT INTO nchBl_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“Se totajtzi amo hueli mocuilis se sihuat cati ahuilnentoc, yon amo hueli mocuilis se sihuat cati moama sosolojtoc ihuaya ihuehue, pampa se totajtzi monequi mocahuas tatzejtzeloltic para na, niiTeco Dios. ");
INSERT INTO nchBl_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Se totajtzi monequi mocahuas taiyocatalili pampa yaya cati techmacas nopa tacajcahualisti noixpa na, niamoTeco Dios. Huajca ma mocahuaca tatzejtzeloltique nopa totajtzitzi, pampa na, niamoTECO, nitatzejtzeloltic, huan na cati nimechtatzejtzelolchihua. ");
INSERT INTO nchBl_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“Sinta se totajtzi iichpoca mochihuas se ahuilnenca sihuat, huajca moixpano huan quiixpano itata. Huan monequi anquitatise hasta miquis. ");
INSERT INTO nchBl_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“Huan nopa hueyi totajtzi cati ticajaltijtoque itzonteco ica nopa aceite para quinyacanas nochi sequinoc totajtzitzi, huan cati taiyocatalili para moquentis nopa yoyomit cati más tatzejtzeloltic, amo hueli tenextilis para tahuel mocuesohua quema quiajsis se tequipacholi. Amo hueli quicahuas itzoncal ma elis fiero, yon amo huelis quitzayanas iyoyo quej quichihuaj sequinoc ica tequipacholi. ");
INSERT INTO nchBl_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Huan nopa hueyi totajtzi amo hueli monechcahuis campa eltoc se mijcatzi itacayo, masque eli inana o itata. Amo hueli mochihuas amo tapajpactic noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Huan quema tequiti ipan nopa yoyon tiopamit, amo hueli quisas pampa quipiyaj se tequipacholi pampa quichihuas amo tapajpactic nopa yoyon tiopamit. Taajaltili nopa hueyi totajtzi para ma eli tatzejtzeloltic huan taiyocatalili san para na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“Nopa hueyi totajtzi monequi mocuilis se ichpocat cati ayemo quiixmati se tacat. ");
INSERT INTO nchBl_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Amo hueli mocuilis se sihuat cati mijqui ihuehue o cati quicajtoc ihuehue, o cati ahuilnentoc. Monequi mocuilis se ichpocat cati nojquiya huala ipan nopa hueyi familia ten totajtzitzi. Monequi elis se cati nelía cuali ichpocat. ");
INSERT INTO nchBl_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Pampa monequi se totajtzi quitepanitas TOTECO itanahuatil para iconehua ma elica tapajpactique noixpa. Na niamoTECO cati nimechtatzejtzelolchihua.” ");
INSERT INTO nchBl_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Xiquilhui Aarón ni tanahuatili. Ama huan teipa yon se moixhui cati quipiya se tenijqui cati amo cuali ipan itacayo amo huelis mochihuas totajtzi, yon amo hueli monechcahuis para techmacas nopa pantzi cati eltoc para na, niamoTeco Dios. ");
INSERT INTO nchBl_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Pampa yon se tacat cati amo ajsitoc itacayo amo hueli monechcahuis para quichihuas nopa tequit. Huajca sinta se tacat popoyotzi, o metzcototic, o lipintic itacayo, o sinta quipiya miyac ixocpilhua o imacpilhua, ");
INSERT INTO nchBl_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","o sinta quilecuenijtoc imax o iicxi, ");
INSERT INTO nchBl_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","o sinta cuitapanponpontic, o tahuel amo huejcapantic, o amo cuali se iixteyol, o sahuati, o cocoti, o sinta quicocojtoc itecsis, amo hueli tequitis quej se totajtzi. ");
INSERT INTO nchBl_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Huajca masque itztoc se iixhui nopa totajtzi Aarón, amo hueli techmacas, niamoTECO, se tacajcahualisti ipan tit sinta amo ajsitoc itacayo. Yon amo hueli techmacas nopa pantzi cati noaxca na, niamoTeco Dios. ");
INSERT INTO nchBl_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Pero, quena, ininconehua totajtzitzi cati amo ajsitoc inintacayo hueli quicuase nopa tacualisti cati huala ten nopa tacajcahualisti, masque se tacualisti cati tatzejtzeloltic, o cati tahuel tatzejtzeloltic. ");
INSERT INTO nchBl_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","San amo hueli calaquis para quinechcahuis nopa cortina pampa amo ajsitoc itacayo, yon amo hueli monechcahuis campa nopa taixpamit. Melahuac amo hueli quichihuas nopa tequit pampa quichihuas notiopa amo tapajpactic. Na, niamoTECO, cati niquiniyocatalijtoc nopa totajtzitzi.” ");
INSERT INTO nchBl_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Huajca Moisés quiilhui Aarón nochi ya ni huan nojquiya quinilhui itelpocahua huan nochi nopa israelitame. ");
INSERT INTO nchBl_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Teipa TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Xiquinilhui Aarón huan itelpocahua ma momocuitahuica miyac para amo ma quichihuaca amo tapajpactic se tacajcahualisti cati tatzejtzeloltic cati techmacaj israelitame. Amo hueli quiahuilmatise notoca na, niamoTECO Dios, huan notacajcahualis. ");
INSERT INTO nchBl_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Sinta se totajtzi cati amo tapajpactic quinechcahuis se tapiyali, o seyoc tamanti tacajcahualisti cati tatzejtzeloltic cati se israelita quihualicatoc para techmacas, huajca monequi xijquixti nopa totajtzi para ayecmo quema huelis itztos noixpa. Ni tanahuatili elis para totajtzitzi ama huan nojquiya para moteipan ixhuihua cati mochihuase totajtzitzi teipa. Na niamoTECO nimechilhuía. ");
INSERT INTO nchBl_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“Aarón, yon se ten moixhuihua cati quipiya nopa tacayo palanca cocolisti, o cati atemoj ipan inintacayo amo hueli quicuas nopa tacajcahualisti cati tatzejtzeloltic. Pero quema ya mochicajtoc huajca, quena, huelis quicuas. “Nojquiya elis amo tapajpactic cati hueli totajtzi cati quinechcahuis se mijcatzi, o temotos ixinacho, ");
INSERT INTO nchBl_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","o quiitzquis se tapiyali cati mohuahuatatza talchi, o quiitzquis se tacat cati amo tapajpactic. ");
INSERT INTO nchBl_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Cati hueli totajtzi cati amo tapajpactic ica ten hueli tamanti mocahuas amo tapajpactic noixpa, huan amo hueli quicuas nopa tacualisti tatzejtzeloltic cati huala ten tacajcahualisti. ");
INSERT INTO nchBl_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Pero quema tayohuiyas huan maltis, elis tapajpactic. Huan huajca, quena, hueli quicuas nopa tacajcahualisti cati tatzejtzeloltic pampa ya nopa itacualis. ");
INSERT INTO nchBl_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Se totajtzi amo hueli quicuas inacayo se tapiyali cati mijqui ica iselti, o cati quimictijque sequinoc tapiyalme, pampa sinta quicuas, huajca mochihuas amo tapajpactic noixpa. Na niamoTECO nimechilhuía. ");
INSERT INTO nchBl_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“Huajca xiquinilhui nopa totajtzitzi ma quitoquilica nochi ni tanahuatili ica miyac tatepanitali para amo quiixpanose huan amo miquise por inintajtacol. Na niamoTECO cati niquintatzejtzelolchihua. ");
INSERT INTO nchBl_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Yon se tacat cati amo totajtzi amo huelis quicuas ten nopa tacajcahualisti cati tatzejtzeloltic. “Yon amo hueli quicuas se tacat cati san quipaxalohua se totajtzi, o san quipalehuía se totajtzi se ome tonati. ");
INSERT INTO nchBl_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","“Pero sinta nopa totajtzi quicohuas se tequipanojquet ica itomi, huajca nopa tequipanojquet, quena, hueli quicuas nopa tacajcahualisti cati tatzejtzeloltic. Huan sinta nopa tequipanojquet quinpiyas iconehua, huajca, inijuanti nojquiya huelise quicuase nopa tacajcahualisti cati tatzejtzeloltic cati nopa totajtzi quinmacas. ");
INSERT INTO nchBl_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","“Huan sinta iichpoca se totajtzi motahuicaltis ihuaya se tacat cati amo totajtzi, huajca nopa ichpocat ayecmo huelis quicuas nopa tacajcahualisti cati tatzejtzeloltic. ");
INSERT INTO nchBl_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Pero sinta miquis ihuehue o quicahuas ihuehue, huan amo quinpiyas iconehua, huan sempa tacuepilis ipan ichaj itata cati eli se totajtzi, huajca nopa ichpocat sempa huelis quicuas itata itacualis quej quema eliyaya pisiltzi. Pero se tacat cati amo quipiya teno ica nopa totajtzi amo hueli quicuas nopa tacualisti. ");
INSERT INTO nchBl_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“Sinta se acajya mocuapolos huan quicuas nopa tacajcahualisti cati tatzejtzeloltic, huajca monequi quicuepas san se imiyaca quej cati quicuajqui, huan noja quipihuilis seyoc 20 por ciento. Huan quihualicas huan quimacas nopa totajtzi. ");
INSERT INTO nchBl_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Huajca nopa totajtzitzi monequi ma quitajtachilica ajquiya inijuanti quincahuilise ma quicuaca nopa tacajcahualisti para amo quichihuase amo tapajpactic nopa tacajcahualisti cati tatzejtzeloltic cati nopa israelitame techiyocatalilijtoque na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Pampa sinta se quiixpanos ni tanahuatili, quihuicas tajtacoli huan monequi quiselis tatzacuiltili. Na niamoTECO cati nijtatzejtzelolchihua nopa tacajcahualisti.” ");
INSERT INTO nchBl_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Xiquilhui Aarón, huan iconehua, huan nochi sequinoc israelitame ni tanahuatilme. Quema quinequis temacas tacajcahualisti cati hueli israelita o cati hueli seyoc tali ejquet cati itztoc campa amojuanti pampa tatestigojquetztoc para quichihuas se tamanti para na, o pampa san ica ipaquilis quinequi techmacas se tacajcahualisti, ");
INSERT INTO nchBl_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","huajca para nijselis monequi elis se becerro, se oquich borrego, o se oquich chivo cati senquisa cuali. ");
INSERT INTO nchBl_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Amo hueli techmacas yon se tapiyali cati quipiya ipan itacayo se tamanti cati amo cuali, pampa amo nijselis. ");
INSERT INTO nchBl_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","“Sinta se masehuali quinequis techmacas, niamoTECO, se tacajcahualisti para ma onca tayoltalili ica na pampa tatestigojquetztoc, o pampa san ica ipaquilis quinequi techmacas se tacajcahualisti, huajca monequi elis se toro, o se borrego, cati amo teno cati amo cuali quipiya itacayo para nijselis. ");
INSERT INTO nchBl_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Amo techmacaca na, niamoTECO, se tapiyali cati amo tachiya, o mometzpostectoc, o cotontoc imax, o cocoti, o sahuati, o quipiya seyoc tamanti cocolisti. Se tapiyali quej nopa amo quema xijtalica ipan notaixpa, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Pero sinta anquipiyaj se toro, o se pilborregojtzi cati quipiya miyac o amo miyac ixocpilhua, o quipiya cototzi o huehueyac se imetz, huajca quena, huelis antechmacase quej se tacajcahualisti cati san antechmacaj ica amopaquilis. Pero ni tamanti tapiyalme amo huelis antechmacase quej se tacajcahualisti quema monequi tacajcahualisti pampa antatestigojquetztoque cati anquichihuase. ");
INSERT INTO nchBl_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Nojquiya san se elis ni tanahuatili quema anajsise ipan amotal. Para tacajcahualisti, monequi se tapiyali cati senquisa cuali. Amo quema techmacaca se tapiyali cati cocojtoc itejquis, o motejtzontoc, o quihuahuatzojtoc itejquis o quiquixtilijtoque itecsis. ");
INSERT INTO nchBl_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Yon amo xiquincahuilica nopa seyoc tali ehuani ma quitencahuaca se tacajcahualisti quej nopa para elis tacualisti para na, niamoTeco Dios. Sinta quihualicase se tapiyali cati amo ajsitoc itacayo huan quinequise techmacase na, niamoTeco Dios, amo nijselis pampa amo tapajpactic. Amo cuali nochi itacayo.” ");
INSERT INTO nchBl_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Quema tacatis se becerro, se pilborregojtzi, o se piloquich chivojtzi monequi mocahuas ihuaya inana para chicome tonati. Pero quema quipiyas chicueyi tonati, huelis anquitequihuise quej se tacajcahualisti cati anquitatise para na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","“Ipan san se tonali amo hueli anquimictise se huacax ihuaya icone, o se sihua borrego ihuaya icone. ");
INSERT INTO nchBl_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Quema antechmacase se tacajcahualisti para antechtascamatilise, monequi anquichihuase quej quinamiqui para nijselis. ");
INSERT INTO nchBl_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Monequi anquicuase nopa tapiyali inacayo ipan nopa tonali quema antechmacase. Amo hueli anquicahuase se quentzi para anquicuase hasta seyoc tonali. Na niamoTECO cati nimechilhuía. ");
INSERT INTO nchBl_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Xijtepanitaca notanahuatil. Quena, xijtoquilijtinemica senquisa cati quiijtohua pampa na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","“Amo xijtequihuica notoca quej elisquía ten hueli tocayot pampa nitatzejtzeloltic. Huan monequi nochi israelitame ma techiyocatalica huan ma techixmatica para niitztoc niiyoca pampa nitatzejtzeloltic. Huan na niamoTECO cati nimechtatzejtzelolchihua. ");
INSERT INTO nchBl_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Na cati nimechmaquixti ipan tali Egipto para nielis niamoTECO huan niamoDios.” ");
INSERT INTO nchBl_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Xiquinilhuiti nopa israelitame ni tanahuatilme. Ya ni nopa tonali cati monequi anquiiyocacahuase para na, niamoTECO para anquichihuase ilhuit huan antechhueyimatise. Xiquintocaxtalica tonali para anquipiyase tasentili cati tatzejtzeloltique. Huan ipan ni tonali nochi israelitame ma mosentilica huan ma techhueyitalica. Huan ya ni nopa tonali: ");
INSERT INTO nchBl_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“Sesen samano para chicuase tonati antequitise, pero ipan tonali chicome, amo anquichihuase yon se tequit. Senquisa anmosiyajquetzase ipan nopa chicompa tonali. Elis se tonali tatzejtzeloltic para anmosentilise huan antechhueyichihuase. Quej ni anquichihuase ipan sesen samano. Nopa chicompa tonali elis tatzejtzeloltic huan taiyocatalili para na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“Huan ya ni eltoc nochi nopa tonali para anilhuichihuase huan anquipiyase se tanechicoli tatzejtzeloltic ipan sesen xihuit para antechhueyichihuase na, niamoTECO: ");
INSERT INTO nchBl_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“Nopa ilhuit ten Pascua monequi xijchihuaca ipan 14 itequi nopa achtohui metzti ipan amoisraelita xihui, huan pehuas quema temo tonati ica tiotac. ");
INSERT INTO nchBl_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","“Ipan ne seyoc tonal, anpehuase anquichihuase nopa ilhuit ten pantzi cati amo quipiya tasonejcayot. Para chicome tonati san hueli anquicuase pantzi cati amo quipiya tasonejcayot. ");
INSERT INTO nchBl_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Ipan nopa achtohui tonali ten nopa chicome tonati, anmosentilise ipan se tanechicoli tatzejtzeloltic, huan ipan nopa tonali amo anquichihuase yon se tequit. ");
INSERT INTO nchBl_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Huan ipan nochi nopa chicome tonati monequi anquitatise tacajcahualisti para na. Huan ipan nopa tonali chicome nojquiya anquipiyase se tanechicoli tatzejtzeloltic huan amo antequitise.” ");
INSERT INTO nchBl_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Xiquinilhui israelitame ni tanahuatilme. Quema ya anajsitose ipan nopa tali cati nimechmacas huan ya anquipixcatose cebada, monequi anquihuicase campa nopa totajtzi nopa achtohui manojo cati anquipixcase. ");
INSERT INTO nchBl_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Anquihuicase ipan ne seyoc tonali quema ya panoc nopa tonali quema anmosiyajquetzque. Huan nopa totajtzi quihuisos noixpa niamoTECO, huan na nijselis quej se tacajcahualisti. ");
INSERT INTO nchBl_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Ipan nopa tonali nojquiya antechmacase se pilborregojtzi quej se tacajcahualisti tatatili. Monequi nopa pilborregojtzi quipiyas se xihuit huan amo quipiyas ipan itacayo yon se tamanti cati amo cuali. ");
INSERT INTO nchBl_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Huan ihuaya ni pilborregojtzi monequi antechmacase se tacajcahualisti cati elis nahui kilos huan tajco ten harina cati tamaneloli ica aceite. Monequi anquitatise noixpa huan nelía techpactis. Nojquiya ihuaya monequi antechmacase se litro xocomecat iayo quej se tacajcahualisti cati anquitoyahuase noixpa. ");
INSERT INTO nchBl_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Huan quema ayemo anquihuicaj ni tacajcahualisti, amo huelis anquicuase yon se pilquentzi ten nopa cebada ipan amomil. Amo hueli anquicuise iyol, yon amo hueli anquicacatzose iyol, yon amo hueli anquichihuase pantzi. Ya ni elis se tanahuatili cati monequi anquitepanitase para nochipa. ");
INSERT INTO nchBl_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“Huajca nopa achtohui tonali anmosiyajquetzase huan nopa seyoc tonali anquihualicase nopa manojo yancuic huan teipa xipehuaca xijpohuaca chicome samano. ");
INSERT INTO nchBl_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","O huelis anquipohuase 50 tonali o chicome sábados cati ipan anmosiyajquetzaj, huan huajca anquihuicase seyoc tacajcahualisti cati quisa ten cebada para na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Anquihualicase ome pantzi ten amochajchaj para se tacajcahualisti cati anquihuisose noixpa, niamoTECO. Nopa pantzi monequi anquicualtalise ica se nahui kilos ten harina ica tasonejcayot. Ya ni elis se tacajcahualisti ten nopa tayacanca pixquisti. ");
INSERT INTO nchBl_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Huan ica nopa pantzi nojquiya antechmacase chicome pilborregojtzitzi cati sanoc quipiyaj sese xihuit cati amo teno cati amo cuali quipiyaj. Nojquiya techmacaca se becerro huan ome oquich borregojme huan nochi elise tacajcahualisti tatatili para na, niamoTECO. Huan nojquiya techmacaca nopa tacajcahualisti ten harina huan nopa tacajcahualisti cati tatoyahuali noixpa cati monequi techmacase ihuaya. ");
INSERT INTO nchBl_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","“Huan nojquiya antechmacase se oquich chivo quej se tacajcahualisti por tajtacoli, huan antechmacase ome pilborregojtzitzi quej se tacajcahualisti para ma onca tayoltalili ica na. ");
INSERT INTO nchBl_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Huan nopa totajtzitzi quinhuisose nopa ome pilborregojtzitzi noixpa, niamoTECO. Nojquiya quihuisose nopa ome pantzi ten nopa tayacapan pixquisti. Nochi ni tacajcahualisti elis taiyocatalili para na, niamoTECO, huan monequi anquinmactilise nopa totajtzitzi para ma eli inintacualis. ");
INSERT INTO nchBl_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","“Huan ipan san se nopa tonali anteyolmelahuase para oncas se tanechicoli cati tatzejtzeloltic para antechhueyichihuase. Amo huelis anquichihuase yon se tequit ipan nopa tonali. Ya ni elis se tanahuatili cati monequi nochi anisraelitame huan amoteipan ixhuihua anquitepanitase para nochipa. ");
INSERT INTO nchBl_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“Huan quema anpixcase ipan amomila ipan nopa tali, amo xipixcaca hasta campa amomilteno, yon amo xijpejpenaca cati tepejtoc talchi. Ya nopa xijcahuaca para ma quipejpenaca cati teicneltzitzi huan cati seyoc tali ehuani. Na niamoTECO Dios cati nimechilhuía.” ");
INSERT INTO nchBl_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Xiquinilhui israelitame ni tanahuatilme. Nopa achtohui tonali ipan nopa chicompa metzti ipan amoisraelita calendario elis tatzejtzeloltic. Monequi anquielnamiquise quej se tonali para anmosiyajquetzase. Pero monequi anmosentilise ipan se tanechicoli cati tatzejtzeloltic para antechhueyimatise. Huan anquinpitzase tapitzalme para antenotzase ipan ni ilhuit ten tapitzali. ");
INSERT INTO nchBl_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Huan ipan nopa tonali amo teno tequit anquichihuase, san antechmacase tacajcahualisti ipan tit.” ");
INSERT INTO nchBl_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Nojquiya TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Huan ipan nopa majtacpa tonali ipan nopa chicompa metzti anquichihuase nopa Tonali para Quiixtzacuas Tetajtacolhua. Ipan ni tonali anmosentilise ipan se tanechicoli cati tatzejtzeloltic para antechhueyimatise. Huan monequi anmosahuase, huan anmoicnonequise por amotajtacolhua. Huan anquitencahuase se tacajcahualisti ipan tit noixpa, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Ipan nopa tonali amo anquichihuase yon se tequit, pampa elis nopa Tonali Para Quiixtzacuas Tetajtacolhua. ");
INSERT INTO nchBl_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Cati hueli masehuali cati amo mosahuas huan amo moicnonequis por itajtacolhua ipan nopa tonali, monequi xijquixtica ten campa amojuanti para ayecmo quema itztos ica anisraelitame. ");
INSERT INTO nchBl_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Huan cati hueli cati quichihuas ten hueli tequit ipan nopa tonali, na nijtzontamiltis para ayecmo itztos ica anisraelitame. ");
INSERT INTO nchBl_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","“Quena, amo hueli anquichihuase yon se tequit. Ni tanahuatili monequi anquitepanitase amojuanti huan amoteipan ixhuihua para nochipa. ");
INSERT INTO nchBl_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Quena, ya ni elis se tonali para anmosiyajquetzase, huan monequi anmosahuase huan anmoicnonequise noixpa por amotajtacolhua. Ni Tonali Para Quiixtzacuas Tetajtacolhua pehuas ica tiotac ipan nopa chicnajpa tonali ipan nopa metzti huan huejcahuas hasta ne seyoc tonali ica tiotac.” ");
INSERT INTO nchBl_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Xiquinilhui israelitame ni tanahuatili. Ipan 15 itequi nopa chicompa metzti ipan amocalendario, anquipehualtise para anquielnamiquise nopa ilhuit quema anquichihuase pilxajcaltzitzi. Huan anilhuichihuase noixpa, niamoTECO, para chicome tonati. ");
INSERT INTO nchBl_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Ipan nopa achtohui tonali ten nopa chicome tonati anmosentilise ipan se tanechicoli cati tatzejtzeloltic para antechhueyichihuase. Ipan nopa tonali, amo hueli anquichihuase yon se tamanti tequit. ");
INSERT INTO nchBl_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Huan ipan nochi nopa chicome tonati, anquitatise tacajcahualisti para na, niamoTECO. Huan ipan nopa chicueyi tonali anmosentilise ipan seyoc tanechicoli cati tatzejtzeloltic para antechhueyichihuase. Ya ni itamiya nopa tanechicoli ten ni hueyi ilhuit. Ipan nopa tonali nojquiya amo aqui hueli quichihuas yon se tequit. ");
INSERT INTO nchBl_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“Huajca nica nimechilhuijtoc nopa tonali ipan se xihuit cati nijtalijtoc para anmosentilise huan anilhuichihuase para na, niamoTECO. Huan nojquiya ipan ni tonali anquitatise miyac tacajcahualisti para na. Nojquiya anquitencahuase tacajcahualisti ipan tit para na. Antechmacase tacajcahualisti tatatili, tacajcahualisti ten harina, huan tacajcahualisti ten tapiyalme cati anquinmictijtoque huan tacajcahualisti cati anquitoyahuase noixpa. Sesen tacajcahualisti antechmacase ipan nopa tonali quema quinamiqui. ");
INSERT INTO nchBl_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Nochi ni tacajcahualisti elis iyoca ten nopa tacajcahualisti cati monequi antechmacase ipan nopa tonali para anmosiyajquetzase ipan sesen samano. Nojquiya nochi ya ni eltoc iyoca ten nopa tacajcahualisti cati antechmactilijtihualahuij, o nopa tacajcahualisti cati antechmacase ica amoseltitzitzi quema antatestigojquetzase para anquichihuase se tenijqui o se tacajcahualisti cati anquitencahuase noixpa pampa san ipan amoyolo quisa para anquichihuase. ");
INSERT INTO nchBl_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“Ipan 15 itequi nopa chicompa metzti, quema ya anpixcaque, anquielnamiquise ni ilhuit noixpa, niamoTECO. Ni ilhuit quema anquichihuase pilxajcaltzitzi anquichihuase para chicome tonati. Huan ipan nopa achtohui tonali huan ipan nopa chicueyi tonati, monequi anmosiyajquetzase. ");
INSERT INTO nchBl_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Ipan nopa achtohui tonali ten ni ilhuit anquicuise imacuayo cuame cati yejyectzitzi huan cati quipiyaj inintajca. Anquicuise imacuayo apachij cuame huan inimacuayo cuame cati quipiyaj inixihuiyo huan moscaltíaj campa hueyat. Huan ica ya nopa anquichihuase pilxajcaltzitzi para ipan anitztose para chicome tonati huan anpaquise noixpa na, niamoTECO Dios. ");
INSERT INTO nchBl_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Sesen xihuit anquichihuase ni ilhuit para chicome tonati para na. Ya ni eli se tanahuatili cati monequi anquitepanitase nochi anisraelitame cati ama anitztoque huan nochi cati teipa tacatise. ");
INSERT INTO nchBl_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Ipan nopa chicome tonati nochi anitztose ipan pilxajcaltzitzi. ");
INSERT INTO nchBl_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Ica ni ilhuit, anquielnamiquise quema nimechquixti ipan tali Egipto huan nimechchijqui anitztose ipan pilxajcaltzitzi. Na niamoTECO Dios cati nimechilhuía.” ");
INSERT INTO nchBl_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Huajca Moisés quinyolmelajqui nopa israelitame ten nochi nopa ilhuime cati TOTECO quiixquetztoya para tiquelnamiquise. ");
INSERT INTO nchBl_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Xiquinnahuati israelitame ma quihualicaca aceite tzalantic para taahuili ipan Tiopamit. Nopa aceite monequi hualas ten olivas cati tatejtejtzonali. Ica nopa cuali aceite, nopa taahuilme amo quema sehuise. ");
INSERT INTO nchBl_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","4","Ma quinmocuitahui miyac nopa taahuilme ipan nopa taahuil quetzali cati senquisa oro. Quena, nopa taahuilme iixmelac nopa cortina cati quitzacua campa nocaxa monequi tatatose nochipa noixpa, niamoTECO. Huan elis Aarón itequi para quinpajpacas huan quintequilis aceite nopa taahuilme ijnaloc huan tiotac. Huan Aarón iixhuihua monequi quitepanitase ni tanahuatili para nochipa. ");
INSERT INTO nchBl_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","6","“Sesen chicueyi ipan nopa tonali para anmosiyajquetzase, nopa totajtzi monequi quitalis 12 pantzi ipan nopa mesa ten oro cati eltoc noixpa, niamoTECO. Sesen ten nopa pantzi monequi quichihuase ica nahui kilos huan tajco ten harina cati tahuel cuechtic. Huan quintecpanas ica ome tatecpicholi. Sesen tatecpichti quipiyas chicuase pantzi. ");
INSERT INTO nchBl_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Huan ipan sesen pamit ten nopa pantzi quitalis copali cati nelía cuali. Ni copali teipa elis se tacajcahualisti cati quitatis ipan taixpamit para techmacas, na niamoTECO. Huan nopa pilquentzi copali cati quitatis quinextis para techmaca senquisa nochi nopa pantzi. ");
INSERT INTO nchBl_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Huan sesen chicueyi ipan nopa tonali para anmosiyajquetzase, nopa totajtzi monequi quitalis nopa pantzi noixpa quej se tanextilijcayot ten nopa camanali cati nijchijtoc inihuaya nochi israelitame. ");
INSERT INTO nchBl_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Huan nopa pantzi elis para Aarón huan iconehua ma quicuaca, pero monequi quicuase campa tatzejtzeloltic. Quena, nopona ma quicuaca pampa nopa pantzi eltoc cati más tatzejtzeloltic ten nochi tamanti tacajcahualisti cati techmacatoque ipan tit. Huan na, niamoTECO, niquinmaca ma quicuaca nopa totajtzitzi huan ininconehua para nochipa.” ");
INSERT INTO nchBl_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Itztoya se telpocat cati inana eliyaya se israelita sihuat, pero itata eliyaya se tali Egipto ejquet. Huan se tonali nopa telpocat mocualani ihuaya se israelita tacat nopona campa nochi mochijtoyaj. ");
INSERT INTO nchBl_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Huan quema mohuilanayayaj, nopa telpocat quitelchijqui TOTECO. Huan sequinoc quihuicaque iixpa Moisés para ma quitajtolsencahua. Inana nopa telpocat eliyaya Selomit cati eliyaya iichpoca Dibri huan hualayaya ipan nopa hueyi familia Dan. ");
INSERT INTO nchBl_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Huan quitzajque nopa telpocat huan quichixque para TOTECO ma quiilhui Moisés taya tatzacuiltili monequi quiselis. ");
INSERT INTO nchBl_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Xijquixti nopa telpocat cati nechtelchijqui huejca ten campa anmochijtoque. Huan ma hualaca nochi cati quicajque quema nechtelchijqui, huan ma quitalica inimax ipan itzonteco. Huan teipa nochi israelitame ma quimaquilica ica tet hasta quimictise. ");
INSERT INTO nchBl_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Huan xiquinilhui israelitame sinta acajya techtelchihuas na, niamoTECO, o quitelchihuas notoca, nojquiya quiselis nopa tatzacuiltili. ");
INSERT INTO nchBl_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Quena, cati techtelchihuas na, niamoTECO, monequi miquis, huan monequi nochi israelitame quitepachose. Ni tanahuatili elis san se para israelitame huan para seyoc tali ehuani. Sinta se techtelchihuas monequi anquimictise. ");
INSERT INTO nchBl_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“Nojquiya sinta se tacat quimictis seyoc, nopa tacat cati temicti monequi nojquiya xijmictica. ");
INSERT INTO nchBl_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","“Cati quimictis se tapiyali cati seyoc iaxca, monequi quicuepilis seyoc tapiyali cati san se. ");
INSERT INTO nchBl_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“Sinta se acajya quicocos seyoc, monequi nojquiya san se anquicocose. ");
INSERT INTO nchBl_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Sinta se acajya quipostequilis seyoc iomiyo, huajca nojquiya monequi anquipostequilise iomiyo. O sinta se acajya quiixteyolquixtis seyoc, huajca nojquiya monequi anquiixteyolquixtise. Huan sinta se acajya tetancochtepehuas, huajca nojquiya monequi anquitancochtepehuase. Quena, quej se acajya quichihuilijtoc seyoc, monequi nojquiya anquichihuilise. ");
INSERT INTO nchBl_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","“Cati quimictis seyoc itapiyal, monequi quicuepas seyoc tapiyali cati san se. Pero sinta quimictis seyoc masehuali, monequi nojquiya xijmictica. ");
INSERT INTO nchBl_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","“Onca san se ni tanahuatili para nochi masehualme, masque israelitame o seyoc tali ehuani. Na, niamoTECO Dios, cati nimechnahuatía.” ");
INSERT INTO nchBl_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Huajca teipa Moisés quincamanalhui israelitame. Huan quihuicaque nopa telpocat cati quitelchijtoya TOTECO hasta huejca ten campa mochijtoyaj huan nopona nochi quimictijque ica tet. Huajca nopa israelitame quichijque senquisa quej TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nchBl_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Quema Moisés itztoya ipan tepet Sinaí, TOTECO quiilhui: ");
INSERT INTO nchBl_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Xiquinilhui nopa israelitame para quema ya anajsitose ipan nopa tali cati nimechmacas, nopa tali iseli monequi mosiyajquetzas sesen huelta quema ajsis xihuit chicome. Huan ica ya nopa anquinextise para nopa tali noaxca na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Para chicuase xihuit hueli antatojtocase ipan amomila. Nojquiya hueli anquitzontequise nopa xocomecame inimacuayo para más temacas, huan hueli anquitequise itajca. ");
INSERT INTO nchBl_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Pero ipan xihuit chicome, nopa tali monequi mosiyajquetzas huan elis se xihuit taiyocatalili para na para antenextilise antechtepanitaj. Amo xijtocaca yon se xinachti, yon amo xijtzontequica imacuayo nopa xocomecat para ma chamani más. ");
INSERT INTO nchBl_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Nopa cati ixhuas ica iseli ipan amomila campa tepejtoc iyol, amo xijpixcaca, yon amo xicajocuica. Huan itajca nopa xocomecat cati moscaltía iseli, amo xijtequilica quej ipa anquichijtoque, pampa ipan nopa xihuit, nopa tali san mosiyajquetzas. ");
INSERT INTO nchBl_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Pero cati ixhuas iseli ipan mila ipan nopa xihuit quema nopa tali mosiyajquetzas elis tacualisti para nochi hueli quitequihuise. Quitequihuis cati iaxca nopa mila, o itequipanojcahua cati quincojtoc, o itequipanojcahua cati quipalehuíaj se ome tonati, o nopa seyoc tali ehuani cati itztoque tatajco amojuanti. Nochi san se iniaxca elis para ma quicuaca, pero amo aqui huelis quipixcas para quiajocuis. ");
INSERT INTO nchBl_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Nojquiya amotapiyalhua huan nopa tapiyalme cati itztoque ipan cuatitamit san se hueli quicuase cati nopona eltoc ipan mila. ");
INSERT INTO nchBl_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“Xijpohuaca hasta tamis chicome xihuit chicome hueltas, o 49 xihuit. Huan quema ya tantos huan ajsis ne seyoc tonali, campa hueli anquipitzase icuacua se oquich borrego. ");
INSERT INTO nchBl_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Quena, campa hueli ipan nochi nopa tali Israel monequi anquipitzase tapitzali quema ajsis nopa Tonali Para Quiixtzacuase Tetajtacolhua ipan majtacti itequi nopa chicompa metzti ipan 50 xihuit. ");
INSERT INTO nchBl_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Pampa nopa xihuit 50 elis tatzejtzeloltic. Nopa xihuit elis se xihuit quema nochi cati tahuicaj elise majcajtoque ten nopa cati tahuicaj. Nojquiya ipan nopa xihuit monequi anquinmajcahuase nochi amoisraelita tequipanojcahua cati monamacatoque para amechtequipanose. Quena, nochi israelita tequipanohuani mocahuase majcajtoque. Huan nochi israelitame cati quinamacaque inintal, nopa tali sempa mochihuas iniaxca, o iniaxca iniixhuihua. Huan sesen israelita monequi sempa yas campa quistoc ifamilia huan campa eliyaya ital para quiselis sempa nopa tali cati eliyaya iaxca. ");
INSERT INTO nchBl_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Nopa xihuit 50 elis se xihuit quema anelise anmajcajtoque ten nochi amotequi. Amo antatojtocase, yon amo anquipixcase itajca cati ixhuac ica iseltitzi, yon itajca nopa xocomecat cati amo anquimocuitahuijtoque. ");
INSERT INTO nchBl_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Pampa nopa xihuit elis tatzejtzeloltic huan nochi israelitame mochihuase majcajtoque. Ipan nopa xihuit quema anquicuase se tamanti cati iseli ixhuac, xijcuitehuaca campa mila huan nimantzi xijcuaca, pero amo xipixcaca, yon amo xicajocuica. ");
INSERT INTO nchBl_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“Ipan nopa xihuit quema anmochihuase anmajcajtoque, sesen ten amojuanti monequi tacuepilis campa ital huan campa quisqui ifamilia. Huan masque ya quinamacatose ital, ipan nopa tonali sempa quimactilise. ");
INSERT INTO nchBl_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Huajca quema anquicohuilíaj o anquinamaquiltíaj seyoc israelita se tali, amo ximocajcayahuaca. ");
INSERT INTO nchBl_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Xijpohuaca quesqui xihuit mocahuas hasta nopa xihuit quema nochi mocahuas majcajtoc, huan xijtaxtahui quej quesqui xihuit huelis temacas itajca nopa tali hasta ajsis nopa xihuit quema sempa tacuepilis iaxca yaya cati achtohuiya quipixqui para iaxca. ");
INSERT INTO nchBl_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Huan sinta polihui miyac xihuit para ajsis nopa 50 xihuit quema nochi mocahuas majcajtoc, huajca más patiyo anquiixtahuase nopa tali para anquicohuase. Pero sinta pilquentzi xihuit eltos para sempa elis moaxca, amo más patiyo xijnamaca. Pampa nelía cati anquinamacaj eltoc imiyaca nopa pixquisti cati temacas nopa tali hasta sempa elis moaxca ta o cati achtohui quipixqui. Quena, quej nopa elis ipati nopa tali quema anquinamacase. ");
INSERT INTO nchBl_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","“Huajca techimacasica na, niamoTECO Dios, huan amo xijcajcayahuaca seyoc ica se taxtahuili cati amo ijqui. ");
INSERT INTO nchBl_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Monequi xiquintepanitaca notanahuatilhua huan xiquintoquilijtinemica para quej nopa anitztose ica temachili ipan amotal. ");
INSERT INTO nchBl_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Huan sinta anquitoquilise ni tanahuatili, nopa tali temacas miyac itajca, huan amechmacas para anquicuase hasta anixhuise cuali. Huan anitztose ica paquilisti ipan nopa tali. ");
INSERT INTO nchBl_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","“Pero huelis amojuanti anmoilhuise ya ni: ‘¿Taya tijcuase ipan nopa xihuit chicome, pampa amo antechcahuilíaj para titatojtocase, yon tipixcase?’ ");
INSERT INTO nchBl_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Na nijtitanis notatiochihualis ipan nopa xihuit chicuase, huan yeca nopa cati anquipixcase ipan nopa xihuit, huejcahuas para anmopanoltise hasta anpixcase sempa ipan nopa expa xihuit. ");
INSERT INTO nchBl_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Quena, quema sempa ajsis tonali para antatojtocase ipan xihuit chicueyi, noja anquicuajtose nopa pixquisti cati anquicuique ipan xihuit chicuase. Huan amechaxilis para ica anmopanoltise hasta oncas nopa pixquisti ipan xihuit chicnahui. ");
INSERT INTO nchBl_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“Xiquelnamiquica para nopa tali noaxca. Yeca amo hueli anquinamacase para mocahuas seyoc iaxca para nochipa. Amojuanti san anajsini huan anpaxalohuani nica, huan eltoc quej san nimechtanejtía nopa tali. ");
INSERT INTO nchBl_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Nochipa quema anquinamacaj se tali, nopa amat monequi quiijtos para sempa hueli anquicohuase para amoaxca ipan ten hueli tonali. ");
INSERT INTO nchBl_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“Huan quema se israelita mochihuas teicneltzi huan monequis mitznamaquiltis se quentzi ital, huajca se iteixmatca cati nelnechca hueli mitzcohuilis sempa nopa tali cati mitznamaquiltijtoc. ");
INSERT INTO nchBl_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","“Huan sinta nopa tacat amo quipiya yon se iteixmatca cati quipalehuis, pero ya iseli quisentilis nopa tomi, huajca yaya sempa hueli quicohuas nopa tali cati quinamacac. ");
INSERT INTO nchBl_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Huan monequi ximoilhuica quesqui xihuit ten pixquisti nopa tacojquet quiixtajtoc para elisquía iaxca nopa tali hasta nopa xihuit quema nochi elis majcajtoc. Huan quema nopa masehuali sempa quicohuas ital, monequi quicuepilis itomi nopa masehuali para nochi nopa xihuit cati quicojtoya para quitequihuis nopa tali pero ama ayecmo hueli quitequihuis pampa sempa quicojqui cati quinamacac. Pero quena, cati eliyaya iaxca se tali sempa hueli quicohuas para elis iaxca sinta quipiya nopa tomi. ");
INSERT INTO nchBl_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Pero sinta amo quisentilis nopa tomi quej quinamiqui para sempa quicohuas ital, huajca nopa tali eltos iaxca cati quicojqui hasta ajsis nopa xihuit quema nochi tali mocahuas majcajtoc huan mocuepas ica cati achtohui eliyaya iaxca. Huan huajca ipan nopa xihuit, quena, nopa tacat cati quinamacac nopa tali, sempa quiselis para iaxca. ");
INSERT INTO nchBl_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“Sinta se tacat quinamacas se cali ipan se altepet cati moyahualtzactoc ica tepamit, yaya huelis quicohuas sempa sinta quinequisquía para se xihuit huan sempa elis iaxca cati quinamacac. ");
INSERT INTO nchBl_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Pero quema ya quiaxitijtos se xihuit quinamacatoc, huajca ayecmo hueli quicohuas sempa nopa cali cati eltoc ipan se altepet cati moyahualtzactoc ica tepamit. Huan elis iaxca nopa tacat cati quicojtoc huan iniaxca iixhuihua para nochipa. Yon nopa cali amo hueli sempa mochihuas iaxca iteco cati achtohui ipan nopa xihuit quema nochi tali mocahuas majcajtos. Quej nopa eltoc tanahuatili para calme cati mopantíaj ipan se altepet cati moyahualtzactoc ica tepamit. ");
INSERT INTO nchBl_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Pero calme cati mopantíaj ipan pilaltepetzitzi cati amo moyahualtzactoque ica tepamit elise quej nopa talme campa mila. Quiijtosnequi iteco cati quinamacac huelis quicohuas sempa ica tomi, huan sinta amo quicohuas sempa nopa cali, quema ajsis nopa xihuit 50 elis majcajtoc huan sempa mochihuas iaxca cati achtohui. ");
INSERT INTO nchBl_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“Pero nopa calme cati mopantíaj ipan inialtepehua iixhuihua Leví, o nopa totajtzitzi, amo san se. Masque moyahualtzactoc nopa inialtepe ica tepamit, se levita tacat cati quinamacas ichaj sempa huelis quicohuas ipan ten hueli tonali. ");
INSERT INTO nchBl_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Huan se cali cati se iixhui Leví quinamacas, nojquiya elis iaxca nopa tacat ipan xihuit 50 quema nochi tali mocahuas majcajtoc. Pampa nopa levitame quiselijque ininchajchaj ipataca nopa tali campa hueltosquíaj tatojtocase. Yeca amo aqui hueli quincuilis ininchajchaj para nochipa. ");
INSERT INTO nchBl_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Huan nopa potreros cati nechca inialtepehua iixhuihua Leví amo hueli monamacase, pampa nopa piltaltzitzi mocahuas iniaxca para nochipa. ");
INSERT INTO nchBl_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“Sinta se israelita mochihuas teicneltzi huan yas campa ta, monequi xijpalehui quej elisquía se nejnenquet, o se seyoc tali ejquet, huan xijcahua ma itzto mohuaya. ");
INSERT INTO nchBl_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Quena, techimacasica na, niamoTeco Dios, huan xijcahuilica para amoicni ma itzto amohuaya. Huan amo xiquininamaca itanca quema anquitanejtíaj amotomi. ");
INSERT INTO nchBl_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Amo teno xitainamaca quema antetanejtíaj amotomi, yon amo xijtanica tomi sinta antemacase tacualisti. ");
INSERT INTO nchBl_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Pampa na, niamoTeco Dios cati nimechilhuía. Na cati nimechquixti ipan tali Egipto para nimechmactilis nopa tali Canaán huan para nielis niamoTeco Dios. ");
INSERT INTO nchBl_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“Sinta se moisraelita icni mocahuas nelteicneltzi huan quinequis monamacas ica ta para mitztequipanos, huajca xijcohua, pero amo xijtequihui quej elisquía se tequipanojquet cati tijcojtoc para moaxca cati amo quipiya yon se tequiticayot. ");
INSERT INTO nchBl_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Monequi xiquitas quej elisquía se tepaxalojquet o se cuali tequipanojquet cati mitzpalehuía. Huan san huelis mitztequipanos hasta ipan nopa xihuit quema nochi mocahuas majcajtoc. ");
INSERT INTO nchBl_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Huan ipan nopa xihuit quema nochi mocahuas majcajtoc yaya hueli quisas ihuaya iconehua huan tacuepilise campa itatahua inintal. ");
INSERT INTO nchBl_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Pampa anisraelitame elij annotequipanojcahua cati nimechquixti ipan tali Egipto, huan amo quinamiqui anmonamacase para anelise tequipanohuani cati seyoc iaxca huan antequipanose san tapic. ");
INSERT INTO nchBl_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Amo quema xijnahuati se israelita o xijtequihui chicahuac. Monequi techimacasica na, niamoTeco Dios. ");
INSERT INTO nchBl_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“Pero sinta anquinequij anquincohuase tequipanohuani para amoaxcahua para amechtequipanose san tapic, huajca huelis anquincohuase tacame huan sihuame cati ehuani ipan sequinoc talme, pero amo cati israelitame. ");
INSERT INTO nchBl_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Nojquiya hueli anquincohuase seyoc tali ehuani ininconehua cati itztoque campa amojuanti masque ininconehua tacatque ipan amotal. ");
INSERT INTO nchBl_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Huan quema anmiquise, huajca ni tequipanohuani cati amo israelitame cati anquincojtoque mocahuase iniaxcahua amoconehua, huan quintequipanose para nochipa. Pero anisraelitame amo hueli anquitequihuise seyoc israelita san tapic o anquinahuatise chicahuac. ");
INSERT INTO nchBl_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Sinta se seyoc tali ejquet cati itztoc ipan amotal mochihuas se tapijpixquet huan se israelita mochihuas teicneltzi huan quinequis monamacas ica nopa seyoc tali ejquet, ");
INSERT INTO nchBl_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","huajca cualtitoc. Pero masque monamacatos, nopa israelita noja quipiya tanahuatili para se iteixmatca quicohuas sempa para mocahuas majcajtoc. Quena, hueli quicohuas se iicni, ");
INSERT INTO nchBl_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","se itío, o se imachicni, o cati hueli iteixmatca cati nelnechca. Huan sinta ya iseli huelis quisentilis tomi para quicuepilis iteco quej quicojqui, huajca nojquiya huelis momanahuis ica iselti. ");
INSERT INTO nchBl_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Monequi quichihuase cuentas ihuaya iteco para quiitas quesqui monequi taxtahuas. Pehuase quipohuase ten nopa xihuit quema monamacac huan quipohuase hasta nopa 50 xihuit quema nochi mocahuas majcajtoc. San taxtahuas ten quesqui xihuit polihui para ajsis nopa xihuit quema elis majcajtoc. Quiijtosnequi quicuepilis iteco cati monequisquía quitaxtahuis seyoc tequipanojquet para tequitis quej ipataca hasta nopa 50 xihuit quema elisquía majcajtoc. ");
INSERT INTO nchBl_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Sinta noja polihui miyac xihuit para mocahuas majcajtoc, huajca quitaxtahuis iteco nechca imiyaca cati quiseli quema yaya monamacac ica ya. ");
INSERT INTO nchBl_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Pero sinta ayecmo miyac xihuit polihui para mocahuas majcajtoc, huajca san quiixtahuas nopa xihuit cati noja polihui. ");
INSERT INTO nchBl_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Sinta nopa israelita monamacatoc ica se seyoc tali ejquet, yaya mocahuas ihuaya quej se tequipanojquet cati motemacas tetequipanos para se xihuit. Huan nopa seyoc tali ejquet amo hueli quinahuatis chicahuac, yon amo hueli moaxcatis para nochipa. ");
INSERT INTO nchBl_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“Huan sinta nopa israelita tacat noja ayemo momanahuijtoc huan ajsis nopa xihuit 50, huajca mocahuas majcajtoc ipan nopa xihuit. Huan ya ica nochi iconehua quisase majcajtoque san sejco. ");
INSERT INTO nchBl_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Nochi anisraelitame annotequipanojcahua na. Na cati nimechquixti ipan tali Egipto para antechtequipanose. Na niamoTECO Dios. ");
INSERT INTO nchBl_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“Amo ximochijchihuilica teteyome, yon taixcopincayome. Quema anajsise ipan amotal amo xijquetzaca se tet cati anquichijchijtoque huan anquipajtoque para anquihueyichihuase, pampa na niamoTECO Dios. ");
INSERT INTO nchBl_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Monequi xiquintepanitaca notanahuatilhua huan ximosiyajquetzaca ipan nopa tonali quema nimechnahuatijtoc. Xijtepanitaca noyoyon tiopa. Na niamoTECO cati nimechilhuía. ");
INSERT INTO nchBl_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Sinta anquinneltocase notanahuatilhua huan anquitoquilise cati niquijtohua, ");
INSERT INTO nchBl_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","huajca nijchihuas para ma huetzi at ipan amotal quema monequi huetzis at. Huan nopa tali temacas miyac pixquisti, huan nopa cuame temacase miyac inintajca hasta mocahuas. ");
INSERT INTO nchBl_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Quena, anquipiyase miyac trigo hasta noja anquipixtose ipan nopa tonali quema anpehuase anquitequise xocomecat itajca. Huan noja anquitequihuijtose nopa xocomecat itajca hasta nopa tonali quema sempa anquitocase trigo. Quena, anquicuase ten nochi cati anquinequise hasta anixhuise cuali. Huan anitztose ica paquilisti ipan amotal. ");
INSERT INTO nchBl_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Quena, na noseltitzi nimechmacas tasehuilisti. Huan yeca quema ancochise, amo anmajmahuise. Amo oncas yon se tamanti cati amechmajmatis. Nijchihuas para nochi tapiyalme cati mosisiníaj ma ixpolihuica. Huan nopona ayecmo oncas tatehuilisti. ");
INSERT INTO nchBl_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Anquinquixtise amocualancaitacahua huan anquintzontamiltise ica amomacheta. ");
INSERT INTO nchBl_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Macuiltij ten amojuanti anquinquixtise cien amocualancaitacahua. Huan cien ten amojuanti anquinquixtise diez mil amocualancaitacahua. Huan quej nopa, nochi amocualancaitacahua anquintzontamiltise. ");
INSERT INTO nchBl_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Pampa na, nimechtiochihuas huan nimechmiyaquilis. Huan cati niquijtojtoc nijchihuas ica amojuanti, temachti nijchihuas. ");
INSERT INTO nchBl_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Quena, anquicuase nopa trigo cati huejcajquiya anquipixcaque. Huan quema ajsis tonali para anquipixcase nopa cati yancuic, monequis anquiquixtise cati anquipixcaque se xihuitaya para huelis anquiajocuise cati yancuic. ");
INSERT INTO nchBl_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","“Na nimocahuas para niitztos tatajco ten amojuanti huan na nimechitas para hueyi amopati. ");
INSERT INTO nchBl_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Niitztos campa amojuanti huan na nielis niamoTeco Dios huan amojuanti anelise annomasehualhua. ");
INSERT INTO nchBl_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Na niamoTECO cati nimechquixti ipan tali Egipto para ayecmo antetequipanose san tapic. Na cati nimechquixtili nopa cuahuit etic cati eltoya amoquechta para antapoxonise quej tapiyalme, huan na nimechchijqui ximoquetzaca xitahuac. ");
INSERT INTO nchBl_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“Pero sinta amo antechneltoquilise huan amo anquitepanitase nochi notanahuatilhua, ");
INSERT INTO nchBl_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","huan san anquihuejcamajcahuase huan amo anquinequise anquicaquise cati nimechilhuijtoc, huajca amojuanti anquisosolose nopa camanali cati nijchijtoc amohuaya. ");
INSERT INTO nchBl_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Huajca ya ni cati nimechchihuilis. Nimechtitanilis se cocolisti cati amechcocoxcamacas huan se majmajti cati nimantzi amechajsis, huan anquipantise cocolisti cati tahuel momahua. Nojquiya nimechmacas se cocolisti ten tatotonilot cati amechpopoyochihuas. Huan amotacayohua pehuas para nenpolihuis. Huan cati anquitocase ipan amomila, elis san tapic, pampa amocualancaitacahua amechichtequilise huan inijuanti quicuase. ");
INSERT INTO nchBl_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Na nielis niamocualancaitaca, huan sequinoc amocualancaitacahua niquincahuilis ma amechtanica. Quena, inijuanti amechnahuatise. Huan ancholojtehuase ica majmajti masque amo aqui amechquixtía. ");
INSERT INTO nchBl_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Huan sinta noja amo antechneltoquilise masque ya nimechtitanilijtos nochi ya ni, huajca nimechtatzacuiltis chicome huelta por sese amotajtacol. ");
INSERT INTO nchBl_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Quena, nijtamiltis nopa chicahualisti cati ica anmohueyimatij huan nijchihuas para nopa mixti ma ayecmo quitoyahua at. Huan ne tali nijchihuas ma elis quej xali. Quena, nijchihuas para elis quej nopa teposti bronce. ");
INSERT INTO nchBl_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","San tapic anmosiyahuiltise para antatojtocase pampa nopa tali ayecmo taeliltis huan nopa cuame ayecmo temacase inintajca. ");
INSERT INTO nchBl_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Huan sinta noja antechcualancaitase huan amo anquinequise anquitacaquilise cati nimechilhuía, huajca nimechtatzacuiltis chicome huelta más chicahuac. Quena, nopa tatzacuiltili nimechtitanilis por amotajtacolhua. ");
INSERT INTO nchBl_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Niquintitanis tapiyalme cati mosisiníaj para quintzontamiltise amoconehua huan amohuacaxhua. Huan nojquiya nimechtzontamiltis huan ayecmo anitztose anmiyaqui huan yeca ipan campa hueli ojti ayecmo itztose israelita masehualme. ");
INSERT INTO nchBl_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Pero sinta teipa noja ayemo anmocualtalise, huan ayemo anquichijtinemise cati na nijnequi huan san antechcualancaitase, ");
INSERT INTO nchBl_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","huajca nimotalis quej niamocualancaitaca huan nimechtatzacuiltis chicome huelta más chicahuac por sese amotajtacol. ");
INSERT INTO nchBl_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Huan nijchihuas para hualas se tatehuilisti campa amojuanti pampa anquisosolojtoque nopa camanali cati nijchijqui amohuaya. Huan sinta anmochololtise huan anmotatitij ipan amoaltepehua ica tepamit, huajca altepeijtic nijchihuas ma amechajsi se cocolisti cati temictía. Huan nimantzi amocualancaitacahua amechtanise. ");
INSERT INTO nchBl_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","“Huan teipa nijchihuas ma huala se mayanti huan tahuel pilquentzi elis itajca amomila. Majtacti sihuame huelise quiicxitise pantzi ipan setzi horno. Huan teipa anquipohuase nopa pantzi huan anmoxejxelhuilise para amechaxilis miyac tonali. Huan masque anquicuase se quentzi, amo anixhuise. ");
INSERT INTO nchBl_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Huan sinta ica ya nopa noja ayemo antechneltocase huan anquisehuiquilise anquichijtinemise cati amo nijnequi na, ");
INSERT INTO nchBl_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","huajca nimochihuas niamocualancaitaca. Huan tahuel más miyac nicualanis ica amojuanti huan nimechtatzacuiltis chicome huelta más chicahuac por sese amotajtacolhua. ");
INSERT INTO nchBl_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Huan anmayanase hasta anquincuase amoconehua cati oquichpilme huan cati sihuapilme. ");
INSERT INTO nchBl_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Huan na nijxitinis nopa taixpamit campa anquinhueyichihuaj teteyome ipan tachiquili. Nojquiya nijsosolos amotaixpa campa anquitatíaj copali para amotaixcopincayohua. Amotacayohua cati mictoque niquintalis ipan amoteteyohua cati nojquiya mictoque. Huan ayecmo nijnequis nimechitas. ");
INSERT INTO nchBl_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Nijxitinis amoaltepehua huan mocahuas quej se huactoc tali, huan nijsosolos campa antahueyichihuayayaj. Masque anquitatisquíaj copali noixpa, ayecmo nijselis. ");
INSERT INTO nchBl_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","“Nijsosolos nochi nopa tali. Huan quema amocualancaitacahua hualase para moaxcatise, quiitase cati nijchijtoc huan quitachilise huan quitetzaitase. ");
INSERT INTO nchBl_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Huan amojuanti nimechtitanis campa hueli ipan sequinoc talme huan nimechquixtis ica se macheta nomaco. Huan amotal mocahuas quej se huactoc tali, huan amoaltepehua mocahuas quej tasoli. ");
INSERT INTO nchBl_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","35","Huan quema anitztose ipan inintal amocualancaitacahua, nopa tali cati nimechmacac mosiyajquetzas. Quena, pampa amo anquicahuiliyayaj nopa tali ma mosiyajquetza sesen chicome xihuit quema anitztoyaj, nimechquixtis huan masque eltos tasosolijtoc, nopa tali mosiyajquetzas ica paquilisti quej quinamiquiyaya mosiyajquetzas. ");
INSERT INTO nchBl_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“Huan amojuanti cati noja anitztose ipan sequinoc talme, nimechchihuas para tahuel ximajmahuica ipan amoyolo hasta quema anquicaquise mojmolinía se tasoli, ancholose pampa anmoilhuise acajya amechtepotztoca ica macheta. Quena, anmajmahuise hasta anmotalose huan anhuetzise. Quej ni amopantis anisraelitame quema anitztose ipan amocualancaitacahua inintal. ");
INSERT INTO nchBl_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Hasta anmocuitiquisase se ica seyoc quema ancholose quej elisquía amechquixtíaj amocualancaitacahua ica macheta, pero amo. Huan ayecmo teno huelis anquichihuase iniixpa amocualancaitacahua pampa ayecmo anquipiyase chicahualisti. ");
INSERT INTO nchBl_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Huan anixpolihuise nopona tatajco ten inijuanti. Quena, elis quej inintal amechcuas. ");
INSERT INTO nchBl_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Huan amojuanti cati noja anitztose ipan nopa tali ten amocualancaitacahua anmotequipachojtinemise por amotajtacol. Quena, mojmosta anquipolojtiyase más amochicahualis ica nopa tajtacoli cati amojuanti huan amohuejcapan tatahua anquichijtoque. ");
INSERT INTO nchBl_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","41","“Pero teipa anquipanextise huan antechpohuilise nochi amotajtacolhua, huan antechpanextilise nopa tajtacoli cati quichijque amohuejcapan tatahua. Quena, antechpohuilise quenicatza amohuejcapan tatahua amo techneltoquilijque notanahuatil huan san quichijtinenque cati na amo nijnequi niquitas. Huan yeca niquinnextili nocualancayo huan niquinhuicac ipan inintal inincualancaitacahua. Huan quema amojuanti anmoechcapanose huan anquiselise nopa tatzacuiltili cati quinamiqui para nochi amotajtacolhua noixpa, ");
INSERT INTO nchBl_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","huajca na niquelnamiquis nopa camanali cati nijchijqui ihuaya Abraham, Isaac huan Jacob huejcajquiya. Huan niquelnamiquis nopa tali cati niquinmacac huan quenicatza ama mocahua tasosolijtoc. ");
INSERT INTO nchBl_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Pampa monequi para nopa tali mosiyajquetzas huan amo aqui itztos nopona quej na niquijto quinamiqui para mosiyajquetzas. Huan anisraelitame teipa anquiselise amotatzacuiltil pampa amo anquitepanitaque notanahuatil, yon amo anquinejque ma nimechnahuati. ");
INSERT INTO nchBl_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","“Huan masque anquichijtoque miyac tajtacoli huan anitztose ipan amocualancaitacahua inintal, na nimechelnamiquis. Amo nimechtahuelcahuas, yon amo nimechtzontamiltis nochi amojuanti, yon amo nijsosolos nopa camanali cati nijchijqui amohuaya. Na niamoTECO Dios. ");
INSERT INTO nchBl_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Huan pampa nimechicnelía, niquelnamiquis nopa camanali cati nijchijqui inihuaya amohuejcapan tatahua quema niquinquixti ipan tali Egipto quema nochi sequinoc talme ehuani san motachiliyayaj. Quena, niquinquixti para nielis niininTECO Dios.” ");
INSERT INTO nchBl_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Huajca nica eltoc nochi nopa tanahuatilme cati TOTECO quimacac Moisés ipan nopa tepet Sinaí para ma quinilhui israelitame. ");
INSERT INTO nchBl_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Xiquinilhui israelitame ni tanahuatilme. Quema se acajya ica iselti quinequis techtestigojquetzas na para moiyocacahuas para na, niamoTECO, o quiiyocacahuas se icone huan teipa quinequis momanahuis para elis majcajtoc, quej ni monequi taxtahuas. ");
INSERT INTO nchBl_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Para se tacat cati quipiya 20 xihuit hasta cati quipiya 60 xihuit, taxtahuas 50 plata tomi cati quitequihuíaj ipan nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Pero sinta eli se sihuat, huajca san taxtahuas 30 plata tomi. ");
INSERT INTO nchBl_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Huan para se oquichpil cati quipiya macuili xihuit hasta 20 xihuit, taxtahuase 20 plata tomi. Huan para se sihuapil cati quipiya macuili xihuit hasta 20 xihuit, taxtahuase majtacti plata tomi. ");
INSERT INTO nchBl_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Pero para se piloquichpiltzi cati sanoc quipiya se metzti ica tacatqui huan hasta cati quipiya macuili xihuit, taxtahuase macuili plata tomi. Huan para se pilsihuapiltzi cati quipiya se metzti hasta macuili xihuit, taxtahuase eyi plata tomi. ");
INSERT INTO nchBl_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Huan para se tacat cati quipiya 60 xihuit para huejcapa, taxtahuas 15 plata tomi. Huan sinta eli se sihuat cati quipiya 60 xihuit para huejcapa, taxtahuas majtacti plata tomi. ");
INSERT INTO nchBl_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Huan sinta se masehuali nelteicneltzi quiijtojtoc para motemacas ica na huan teipa quinequi sempa mocohuas pero amo huelis quisentilis nopa tomi cati monequi, huajca ma quihuicaca campa nopa totajtzi. Huan nopa totajtzi quiixquetzas quesqui plata tomi monequi taxtahuas nopa tacat teicneltzi. Quena, quiixquetzas quej quiitas para quiaxilis itaxtahuil nopa tacat cati quiijtojtoc para motemactilis ica na, niamoTECO, huan quinequi sempa mocohuas para mocahuas majcajtoc. ");
INSERT INTO nchBl_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“Pero sinta se acajya tatestigojquetztoc para techmacas na, niamoTECO, se tapiyali, huajca nopa tacat monequi nelía techmactilis nopa tapiyali. Nochi nopa tamanti cati se quiijtos para techmacas elis tatzejtzeloltic huan taiyocatalili para na. ");
INSERT INTO nchBl_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Huan sinta se quiijtojtoc para techmacas na, niamoTECO, se nemacti, amo hueli moyolcuepas. Huan sinta moilhuijtoc catijqui tapiyali techmacas huan quiijtojtoc para ya nopa techmacas, huajca nopa tapiyali ayecmo huelis quipatas. Yon amo hueli techmacas seyoc cati más cuali o más fiero. Huan sinta techmacasquía seyoc quej ipataca, huajca nochi nopa ome tapiyalme mocahuase taiyocatalilme para na, niamoTECO, huan amo hueli sempa quincohuas. ");
INSERT INTO nchBl_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","“Huan sinta quiijtos para techmacas se tapiyali cati amo tapajpactic para elis tacajcahualisti para na, niamoTECO, huajca nopa tacat quihuicas campa nopa totajtzi nopa tapiyali. ");
INSERT INTO nchBl_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Huan nopa totajtzi quitachilis sinta cuali o amo cuali, huan cati nopa totajtzi quiixquetzas para ipati, ya nopa monequi quiixtahuas ipan tiopamit para sempa mocohuis nopa tapiyali. ");
INSERT INTO nchBl_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Pero sinta teipa quinequis sempa quicohuas nopa tapiyali, monequi taxtahuas cati ipati quiixquetztoc nopa totajtzi huan nojquiya monequi quimiyaquilis seyoc 20 por ciento para quej nopa, nopa tapiyali sempa elis iaxca. ");
INSERT INTO nchBl_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","15","“Sinta acajya quiiyocatalis ichaj para elis tatzejtzeloltic para na, niamoTECO, huan teipa sempa quinequis mocohuis para iaxca, huajca quej ni quichihuas. Monequi ma huala nopa totajtzi ma quitachiliqui nopa cali huan quiixquetzas quesqui ipati. Huan nopa imiyaca tomi cati nopa totajtzi quiixquetzas, ya nopa elis ipati. Huan iyoca ten nopa ipati cati quiixquetztoc nopa totajtzi, nopa tacat monequi quipihuilis seyoc 20 por ciento. Huan quema taxtahuas nochi ya nopa, nopa cali sempa elis iaxca. ");
INSERT INTO nchBl_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“Huan sinta se acajya quiiyocatalis se quentzi tali cati quiselijtoc ten ihuejcapan tatahua para techmacas para elis noaxca, niamoTECO, huajca nopa totajtzi monequi quitachilis quenicatza ihuexca nopa tali huan quesqui litros ten xinachti monequi para quitocas. Quej nopa quiixquetzas ipati. Sinta quiitas para ipan nopa pedazo monequi 220 litros ten iyol cebada para quitocas para 50 xihuit huajca monequi taxtahuas 50 plata tomi. ");
INSERT INTO nchBl_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Huan sinta se tacat quiiyocatalis ital ipan nopa xihuit 50 quema nochi mocahua majcajtoc, huajca nochi cati ipati monequi taxtahuas ipan tiopamit para mocohuis sempa nopa tali. ");
INSERT INTO nchBl_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Pero sinta quiiyocatalis nopa tali quema ya panotoc nopa xihuit quema nochi mocahua majcajtoc, huajca nopa totajtzi quipohuas quesqui xihuit panotoc ten nopa xihuit huan quiquixtilis ten cati ipati elisquía para yajmaxtic 50 xihuit. San monequi taxtahuas para quesqui xihuit polihui para sempa ajsis nopa xihuit quema mocahuas majcajtoc. ");
INSERT INTO nchBl_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","“Huan sinta nopa tacat cati quiiyocatali ital sempa quinequis quicohuas nopa tali para iaxca, huajca monequi taxtahuas cati nopa totajtzi quiixquetzas para ipati huan iyoca monequi quipihuilis seyoc 20 por ciento. Huan quej nopa, nopa tali sempa elis iaxca. ");
INSERT INTO nchBl_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Pero sinta amo quicohuas nimantzi para sempa elis iaxca huan quinamaquiltis seyoc, huajca teipa ayecmo quema sempa huelis quicohuas para iaxca. ");
INSERT INTO nchBl_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Huan quema ajsis nopa xihuit para nochi mocahuas majcajtoc, nopa tali nojquiya mocahuas majcajtoc, huan elis taiyocatalili para na, niamoTECO, huan teipa elis para nopa totajtzitzi iniaxca. ");
INSERT INTO nchBl_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“Huan sinta acajya techiyocatalilis na, niamoTECO, se quentzi tali cati san quicojtoc huan amo quiselijtoc ten ihuejcapan tatahua, ");
INSERT INTO nchBl_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","huajca nopa totajtzi quipohuas quesqui xihuit polihui para ajsis nopa xihuit para nochi mocahuas majcajtoc. Huan quej nopa quiixquetzas ipati. Huan nopa tacat cati quiiyocatalijtoc ital para na, niamoTECO, monequi nimantzi taxtahuas ipan nopa tonal. ");
INSERT INTO nchBl_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Huan quema ajsis nopa xihuit para nochi mocahuas majcajtoc, nopa tali sempa elis iaxca nopa achtohui teteco cati nopa tacat quicohuili. ");
INSERT INTO nchBl_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","“Ipan nochi tamanti cati anquiixquetzase ipati, monequi anquitequihuise nopa tatamachihuali para ietica nopa plata tomi cati motequihuía ipan nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“Nochi huacaxme huan borregojme cati achtohui tacatij ten ininana amo hueli anquiniyocatalise para na, niamoTECO, pampa ya eltoc noaxcahua cati achtohui tacatij. ");
INSERT INTO nchBl_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Pero sinta anquinequij anquiiyocatalise se tapiyali cati iachtohui cone se tapiyali cati amo tapajpactic para tacajcahualisti huan yeca amo noaxca, huajca nopa tacat cati iaxca huelis sempa mocohuis sinta taxtahuas quej quiixquetztoc nopa totajtzi para ipati nopa tapiyali. Huan iyoca monequi quipihuilis seyoc 20 por ciento ten cati ipati. Huan sinta nopa tacat amo quinequis quicohuas sempa nopa tapiyali cati techmaca, huajca nopa totajtzi quinamaquiltis nopa tapiyali seyoc quej quiixquetztoc para ipati pampa amo cuali para tacajcahualisti. ");
INSERT INTO nchBl_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“Pero se masehuali, o se tapiyali, o se tali cati se quiselijtoc ten ihuejcapan tatahua huan senquisa techmacatoc para elis noaxca, ayecmo aqui huelis quicohuas o quinamacas ica seyoc, pampa ya nopa senquisa noaxca huan tahuel tatzejtzeloltic para na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Sinta quiijtohua tanahuatili para monequi miquis se masehuali, amo huelis taxtahuas para momanahuis. Monequi miquis. ");
INSERT INTO nchBl_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“Se diezmo ten nochi cati temaca momila eltoc noaxca. Quema nopa tali temacas iyol o nopa cuame temacase inintajca, monequi antechmacase na, niamoTeco, se tatamachihuali ten sesen majtacti tatamachihuali, pampa ya nopa eli noaxca huan tatzejtzeloltic para na. ");
INSERT INTO nchBl_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Huajca sinta acajya quinequis sempa mocohuis nopa iyol ten imila o itajca icuatatochua, huajca monequi taxtahuas cati ipati huan quimacas nopa totajtzi huan nojquiya monequi quipihuilis seyoc 20 por ciento. ");
INSERT INTO nchBl_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","“Huan ipan sesen majtacti tapiyalme monequi anquiquixtise se para antechmacase na, niamoTECO. Amo xiquintapejpenica catijqui tapiyalme elise noaxcahua. Quema nopa tapiyalme motecpanaj para calaquise ipan tatzacti huan nopa tamocuitahuijquet quinpohua sesen quema panoj itzala icuatopil, sesen huelta quema quipohuas hasta ipan majtacti, huajca nopa tapiyali elis noaxca na. Quena, ya nopa se diezmo huan tatzejtzeloltic para na nopa majtacpa tapiyali. ");
INSERT INTO nchBl_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Amo teno sinta nopa tapiyali cati elis noaxca elis cuali o amo cuali, amo huelis quiixpatas. Huan sinta quipatas, huajca nochi ome tapiyalme, nopa cati eltoya noaxca huan nopa cati ipataca, nochi mocahuase taiyocatalilme para na, niamoTECO. Huan amo aqui hueli sempa quicohuas para iaxca.” ");
INSERT INTO nchBl_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Huajca ya ni nopa tanahuatilme cati TOTECO quimacac Moisés ipan nopa tepet Sinaí para quinilhuis nochi israelitame.");
INSERT INTO nchBl_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","TOTECO quicamanalhui Moisés ipan nopa huactoc tali Sinaí ipan nopa yoyon tiopamit campa mopantiyayaj. Quicamanalhui ipan 15 itequi nopa ompa metzti ipan nopa israelita calendario quema ya panotoya se xihuit huan se metzti para nopa israelitame quistoyaj ten tali Egipto. Huan ya ni cati TOTECO quiilhui: ");
INSERT INTO nchBl_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","3","“Monequi ta ihuaya Aarón xijtananaca se censo ten nochi israelita tacame cati quiaxitijtoque 20 xihuit para huejcapa huan cati hueli tatehuíaj. Xiquijcuiloca sese itoca, huan itoca itata, huan itoca ihuejcapan tata, huan xiquinpohuaca quesqui itztoque. Huan quema ya anquinpojtose nochi, xiquintalica ipan tatehuijca pamit para tatehuise. ");
INSERT INTO nchBl_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Nojquiya amechpalehuis se iteipan ixhui nochi nopa 12 huejcapan tatame cati huejcajquiya itztoyaj. Sesen motapalehuijca elis cati más tayacana ipan iteixmatcahua ipan ihueyi familia. ");
INSERT INTO nchBl_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","15","Ya ni inintoca nopa tayacanani cati amechpalehuis ten sesen hueyi familia: Familia, Tayacanquet Rubén, Elisur, icone Sedeur Simeón, Selumiel, icone Zurisadai Judá, Naasón, icone Aminadab Isacar, Natanael, icone Zuar Zabulón, Eliab, icone Helón Efraín, icone José, Elisama, icone Amiud Manasés, icone José, Gamaliel, icone Pedasur Benjamín, Abidán, icone Gedeoni Dan, Ahiezer, icone Amisadai Aser, Pagiel, icone Ocrán Gad, Eliasaf, icone Deuel Neftalí, Ahira, icone Enán ");
INSERT INTO nchBl_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ya ni elqui inintoca nopa tayacanani cati tapejpenilme para tayacanase ipan sesen hueyi familia.” ");
INSERT INTO nchBl_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Huan Moisés huan Aarón inihuaya ni tayacanani cati TOTECO quintocaxtalijtoya, ");
INSERT INTO nchBl_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","quinnotzque nochi israelitame ma mosentilica ipan nopa tonali quema TOTECO quicamanalhui Moisés. Huan pejque quinijcuilohuaj nochi tacame cati ya quiaxitijtoyaj 20 xihuit para huejcapa. Huan sesen quiijcuilojque ajquiya eliyaya ihuejcapan tata huan ajquiya itata. Moijcuilojque sesentzitzi. ");
INSERT INTO nchBl_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Huajca nopona ipan nopa huactoc tali cati itoca Sinaí quinpojque nochi ni tacame quej TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nchBl_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","43","Huan quema Moisés, Aarón huan nopa 12 tayacanani ten israelitame ya tantoya inintequi, ya ni nopa tacame cati quinpojque cati quipiyayayaj 20 xihuit para huejcapa cati huelque yahuij tatehuitij: Familia, Quesqui Rubén, iachtohui cone Israel, 46,500 Simeón, 59,300 Gad, 45,650 Judá, 74,600 Isacar, 54,400 Zabulón, 57,400 Efraín, icone José, 40,500 Manasés, icone José, 32,200 Benjamín, 35,400 Dan, 62,700 Aser, 41,500 Neftalí, 53,400 ");
INSERT INTO nchBl_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Huajca ya ni techilhuía cati quipantijque Moisés huan Aarón huan nopa 12 tayacanani cati tayacanayayaj ipan sese ifamilia ten iteipan ixhuihua Israel. ");
INSERT INTO nchBl_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Quinpojque nopa israelita tacame cati quiaxitijtoyaj 20 xihuit ica huejcapa huan cati huelque yahuij para tatehuitij. ");
INSERT INTO nchBl_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Huan quipantijque para nochi itztoyaj 603 mil 550 taca israelitame cati hueliyayaj tatehuitij. ");
INSERT INTO nchBl_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Pero amo quinpojtoyaj tacame ipan nopa hueyi familia ten iteipan ixhuihua Leví, ");
INSERT INTO nchBl_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","pampa TOTECO quiilhuijtoya Moisés: ");
INSERT INTO nchBl_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Quema tijtananas se censo ten nochi israelitame cati hueli tatehuíaj, amo xiquinpohua nopa levitame, inijuanti cati hualajque ipan nopa huejcapan tata Leví. Amo xiquintali san sejco ihuaya ne sequinoc israelitame. ");
INSERT INTO nchBl_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Pero xiquintequimaca nochi levita tacame ma quimocuitahuica noyoyon tiopa cati quipiya nopa caxa, huan nochi cati eltoc ipani, huan nochi tamantzitzi cati nopona calijtic quitequihuíaj. Quema anyase sejcoyoc, elis levitame inintequi para quihuicase nopa yoyon tiopa campa na nimocahua amohuaya huan nojquiya quihuicase nochi cati quipiyaj. Nojquiya levitame ma quiquetzaca iniyoyoncalhua nechca nochaj para ma quiyahualoca. ");
INSERT INTO nchBl_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Huan quema monequi quihuicase nopa yoyon tiopamit, inijuantijya cati quicocopitzase. Huan quema anajsise campa anquiquetzase amoyoyoncalhua, inijuantijya cati sempa quicualchijchihuase nopa tiopamit quej eltoya. Pero sinta se tacat cati amo se iteipan ixhui Leví quinechcahuis nopa yoyon tiopamit campa na niitztoc amohuaya, monequi anquimictise. ");
INSERT INTO nchBl_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Huan monequi nochi masehualme ipan sesen hueyi familia ten israelitame quipiyase inilugar campa quiquetzase iniyoyoncalhua san sejco ipan se pamit. Huan iteipan ixhuihua sesen huejcapan tata quipiyase ininbandera nopona para quinextis canque eltoc ininpamit. ");
INSERT INTO nchBl_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Pero nochi nopa levitame quiquetzase iniyoyoncalhua yahualtic ten nopa yoyon tiopamit campa niitztoc amohuaya huan cati quipiya cati amohuaya nimocajtoc pampa inintequi levitame quimocuitahuise nopa tiopamit. Quimocuitahuise para cati hueli masehuali amo huelis monechcahuis huan amo nicualanis ica anisraelitame.” ");
INSERT INTO nchBl_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Huajca nopa israelitame quichijque senquisa nochi cati TOTECO quinahuati Moisés. ");
INSERT INTO nchBl_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Nojquiya TOTECO quiilhui Moisés huan Aarón ni tanahuatilme: ");
INSERT INTO nchBl_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Nochi israelitame monequi quiquetzase iniyoyoncalhua para huejca quiitase nopa yoyon tiopamit campa timopantíaj. Huan sesen mocahuas nechca ibandera ihuejcapan tata huan mocahuas nechca ihueyi bandera nopa tatehuijca pamit cati iniaxca. ");
INSERT INTO nchBl_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","8","“Nopa tacame ten nopa huejhueyi familias ten Judá, Isacar huan Zabulón quiquetzase iniyoyoncalhua huan ininbandera ica campa quisa tonati ten nopa yoyon tiopamit. Huan nica eltoc inintoca sesen hueyi familia, inintayacanca huan quesqui tacame hueliyayaj yahuij tatehuitij: Familia, Tayacanquet, Quesqui Judá, Naasón, icone Aminadab, 74,600 Isacar, Natanael, icone Zuar, 54,400 Zabulón, Eliab, icone Helón, 57,400 ");
INSERT INTO nchBl_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Huajca ipan nopa tatehuijca pamit ten Judá elis tacame ten hualahuij ipan ni eyi huejhueyi familias huan para nochi elque 186,400 tacame cati hueliyayaj tatehuíaj. Huan ni tatehuijca pamit tayacantiyas quema anisraelitame anquistehuase para anmochihuase sejcoyoc. ");
INSERT INTO nchBl_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","15","“Nopa tacame ten nopa huejhueyi familias ten Rubén, Simeón huan Gad quiquetzase iniyoyoncalhua huan ininbandera ica sur ten nopa yoyon tiopamit. Huan nica eltoc inintoca sesen hueyi familia, inintayacanca huan quesqui tacame hueliyayaj yahuij tatehuitij: Familia, Tayacanquet, Quesqui Rubén, Elisur, icone Sedeur, 46,500 Simeón, Selumiel, icone Zurisadai, 59,300 Gad, Eliasaf, icone Reuel, 45,650 ");
INSERT INTO nchBl_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Huajca ipan nopa tatehuijca pamit Rubén elis tacame cati hualahuij ipan ni eyi huejhueyi familias huan para nochi elque 151,450 tacame cati hueliyayaj tatehuíaj. Huan ni tatehuijca pamit motecpanase iica nopa tatehuijca pamit Judá quema anquistehuase para anmochihuatij sejcoyoc. ");
INSERT INTO nchBl_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“Huan teipa motecpanase nopa levitame cati quihuicase noyoyon tiopa, niamoTECO quema anquisase para anyase sejcoyoc. Huan quisase tatajco ipan nochi huejhueyi familias san quej mocahuaj tatajco iniyoyoncalhua. Quej nopa quisase campa monequi sesen ica ibandera. ");
INSERT INTO nchBl_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","23","“Nopa tacame ten nopa huejhueyi familias ten Efraín, Manasés huan Benjamín quiquetzase iniyoyoncalhua huan ininbandera ica campa temo tonati ten nopa yoyon tiopamit. Huan nica eltoc inintoca sesen hueyi familia, inintayacanca huan quesqui tacame hueliyayaj yahuij tatehuitij: Familia, Tayacanquet, Quesqui Efraín, Elisama, icone Amiud, 40,500 Manasés, Gamaliel, icone Pedasur, 32,200 Benjamín, Abidán, icone Gedeoni, 35,400 ");
INSERT INTO nchBl_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Huajca ipan nopa Itatehuijca pamit Efraín elis tacame cati hualahuij ipan ni eyi huejhueyi familias huan para nochi elque 108,100. Huan ni tatehuijca pamit motecpanase iniica nopa levitame. ");
INSERT INTO nchBl_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","30","“Nopa tacame ten nopa huejhueyi familias ten Dan, Aser huan Neftalí quiquetzase iniyoyoncalhua huan ininbandera ica norte ten nopa yoyon tiopamit. Huan nica eltoc inintoca sesen hueyi familia, inintayacanca huan quesqui tacame hueliyayaj yahuij tatehuitij: Familia, Tayacanquet, Quesqui Dan, Ahiezer, icone Amisadai, 62,700 Aser, Pagiel, icone Ocrán, 41,500 Neftalí, Ahira, icone Enán, 53,400 ");
INSERT INTO nchBl_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Huajca ipan nopa tatehuijca pamit ten Dan elis nopa soldados ten ni eyi huejhueyi familias huan san sejco ajsique 157,600 tacame cati huelque tatehuise. Huan ni tatehuijca pamit motecpanase iica ibandera hasta tateipa huan nejnemise iica nopa tatehuijca pamit Efraín.” ");
INSERT INTO nchBl_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Huajca quema ya quinpojtoyaj nochi israelita tacame cati hueliyayaj tatehuitij ipan nochi huejhueyi familias elque 603,550 tacame. ");
INSERT INTO nchBl_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Pero amo quintalijque san sejco nopa levitame pampa TOTECO quinahuatijtoya Moisés ma amo quinpohuaca ica cati tatehuise. ");
INSERT INTO nchBl_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Huajca nopa israelitame quichijque nochi senquisa quej TOTECO quinahuatijtoya Moisés. Huan sesen hueyi familia quiquetzqui ichaj ten yoyomit iica ibandera campa quinilhuijtoyaj. Huan quema quistejque, motecpantiyajque huan sesen hueyi familia nejnenqui senquisa quej TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nchBl_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Ya ni techpohuilía ten iteixmatcahua Moisés huan iicni Aarón ipan nopa tonali quema TOTECO quicamanalhui Moisés ipan nopa tepet Sinaí. ");
INSERT INTO nchBl_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Inintoca iconehua Aarón eliyaya: Nadab cati achtohui ejquet, Abiú, Eleazar, huan Itamar. ");
INSERT INTO nchBl_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Nochi inijuanti quinajalti ica aceite huan quiniyocacajqui ma elica totajtzitzi para tequitise tiopan calijtic. ");
INSERT INTO nchBl_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Pero Nadab huan Abiú mijque iixpa TOTECO nepa ipan nopa huactoc tali Sinaí pampa amo quitoquilijque icamanal TOTECO huan quitequihuijque se tit cati amo tatzejtzeloltic. Huan cati mijque ayemo quinpiyayayaj ininconehua, yeca san mocajqui Eleazar huan Itamar para quipalehuise inintata Aarón ipan itequi quej totajtzi ipan inemilis. ");
INSERT INTO nchBl_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Huan TOTECO quinojnotzqui Moisés huan quiilhui: ");
INSERT INTO nchBl_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Xiquinnotza ma hualaca nochi iteipan ixhuihua Leví huan xijchihua para ma monextica iixpa Aarón para quitequipanose. ");
INSERT INTO nchBl_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Huan inijuanti quitequipanose Aarón huan quintequipanose nochi israelitame pampa quichihuase miyac piltequitzitzi cati tiquinilhuis ma quichihuaca ipan nopa achtohui cuartos ipan nopa yoyon tiopamit campa timopantíaj. ");
INSERT INTO nchBl_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Quimocuitahuise nopa cuamesas huan nochi tamantzitzi cati eltoc ipan nopa yoyon tiopamit campa timopantíaj. Huan quichihuase nochi cati nimechnahuatijtoc anisraelitame xijchihuaca. ");
INSERT INTO nchBl_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Huajca nochi levitame ma mocahuaca imaco Aarón huan itelpocahua. Quena, nochi tacame ipan nopa hueyi familia Leví quinpalehuise nopa totajtzitzi, yeca nochi levitame mocahuase iyoca ten nochi nopa sequinoc israelitame para melahuac ma elica iaxcahua Aarón huan iniaxcahua itelpocahua. ");
INSERT INTO nchBl_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Pero san Aarón huan itelpocahua xiquintequimaca para ma elica totajtzitzi, nopa sequinoc levitame, amo. Sinta seyoc cati amo totajtzi quichihuas itequi se totajtzi huan monechcahuis campa más tiopan calijtic, monequi xijmictica.” ");
INSERT INTO nchBl_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Huan sempa TOTECO quinojnotzqui Moisés huan quiilhui: ");
INSERT INTO nchBl_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Ya nimechilhuijtoc para monequi techmacaca nochi amoachtohui conehua, pampa inijuanti noaxcahua. Pero para amo monequi antechmacatiyase amoachtohui conehua, ininpataca niquinselis nochi levitame para ma elica noaxcahua ininpataca nochi sequinoc israelitame, ");
INSERT INTO nchBl_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","pampa na noaxcahua nochi israelitame cati achtohui tacatij. Quema nijchijqui para ma miquica nochi cati achtohui ehuani ten nochi tali Egipto, nimocuili nochi coneme cati achtohui ehuani ten nochi anisraelitame, huan nojquiya nochi tapiyalme cati achtohui tacatise, huan yeca nochi noaxcahua. Na niamoTECO.” ");
INSERT INTO nchBl_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Huan TOTECO sempa quinojnotzqui Moisés ipan huactoc tali Sinaí huan quiilhui: ");
INSERT INTO nchBl_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Xiquinpohua nochi levitame ipan sesen cali, huan iyoca xiquinpohua ajquiya inijuanti hualajque ipan sese itelpoca nopa huejcapan tata Leví. Xiquinpohua nochi oquichpilme cati ya quiaxitijque se metzti para huejcapa.” ");
INSERT INTO nchBl_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Huan Moisés quinpojqui senquisa quej quinahuatijtoya TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Huan nopa huejcapan tata Leví quinpixqui eyi itelpocahua: Gersón, Coat huan Merari. ");
INSERT INTO nchBl_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Huan Gersón quinpixqui ome itelpocahua: Libni huan Simei. ");
INSERT INTO nchBl_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Huan Coat quinpixqui nahui itelpocahua: Amram, Izhar, Hebrón huan Uziel. ");
INSERT INTO nchBl_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Huan Merari quinpixqui ome itelpocahua: Mahli huan Musi. Huajca nica nimitzilhuijtoc ajquiya itztoyaj nopa tayacanani ipan nopa familias ten iteipan ixhuihua nopa huejcapan tata Leví huan ama tiquintocaxtía nochi levitame. ");
INSERT INTO nchBl_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Huajca iixhuihua Gersón mochijque ome huejhueyi familias cati quisqui ten itelpocahua, Libni huan Simei. ");
INSERT INTO nchBl_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Huan ama nochi inintaca ixhuihua cati quipiyayayaj se metzti para huejcapa mochijque 7 mil 500. ");
INSERT INTO nchBl_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Huan TOTECO quinnahuati iixhuihua Gersón ma quiquetzaca iniyoyoncalhua nechca nopa yoyon tiopamit ica campa huetzi tonati. ");
INSERT INTO nchBl_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Huan Eliasaf, icone Lael, elqui nopa tayacanquet ten iixhuihua Gersón. ");
INSERT INTO nchBl_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Huan inijuanti quipixque inintequi para quimocuitahuise nopa tiopamit huan nochi yoyomit cati quipixqui. Quimocuitahuijque itzajca, icortinas, ");
INSERT INTO nchBl_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","huan nopa cortinas cati mochihua nopa tatzacti cati quiyahualohua nopa taixpamit huan tiopamit, huan nopa cortinas cati quicuapilohuaj campa calaquise, huan nochi lazo cati motequihuía ipan nopa tiopamit. Ya nopa eliyaya inintequi iixhuihua Gersón. ");
INSERT INTO nchBl_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Huan iixhuihua Coat mochijque nopa nahui huejhueyi familias cati quisque ten itelpocahua, Amram, Izhar, Hebrón huan Uziel. ");
INSERT INTO nchBl_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Huan ama nochi inintaca ixhuihua cati quipiyaj se metzti para huejcapa mochijque 8 mil 600. Huan iixhuihua Coat tequitiyayaj tiopan calijtic. ");
INSERT INTO nchBl_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Huan TOTECO quinnahuati iixhuihua Coat ma quiquetzaca iniyoyoncalhua nechca tiopamit ica sur. ");
INSERT INTO nchBl_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Huan Elizafán, icone Uziel, elqui nopa tayacanquet ten iixhuihua Coat. ");
INSERT INTO nchBl_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Huan inijuanti quipixque tanahuatili para quimocuitahuise nopa caxa, nopa cuamesa para pantzi, nopa taahuil quetzali, nopa taixpamit para copali, nopa taixpamit para Tacajcahualisti Tatatili, huan nochi teposti cati quitequihuijque tiopan calijtic. Nojquiya quipixque inintequi para quimocuitahuise nopa cortina yejyectzi cati quitzacuayaya campa Tahuel Tatzejtzeloltic. Nojquiya quipixque inintequi para quicualtalise nochi ni tamanti sinta monequiyaya se quentzi tequit. Ya nopa eliyaya inintequi iixhuihua Coat. ");
INSERT INTO nchBl_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Huan Eleazar, icone nopa totajtzi Aarón, eliyaya nopa tayacanquet cati más hueyi ipan nochi levitame. Yaya cati quintequimacayaya nopa tacame cati tapalehuiyayaj tiopan calijtic. ");
INSERT INTO nchBl_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Huan iixhuihua Merari mochijque nopa ome huejhueyi familias cati quisque ten itelpocahua Mahli huan Musi. ");
INSERT INTO nchBl_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Huan ama nochi inintaca ixhuihua cati quipiyaj se metzti para huejcapa mochijque 6 mil 200. ");
INSERT INTO nchBl_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Huan TOTECO quinnahuati ma quiquetzaca iniyoyoncalhua nechca tiopamit ica norte. Huan Zuriel, icone Abihail, elqui nopa tayacanquet ten iixhuihua Merari. ");
INSERT INTO nchBl_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Huan inijuanti quipixque inintequi para quimocuitahuise nopa huapalme ica cati quichijque caltepamit, nopa cuaixtapalme, nopa taquetzalme, huan inintepos cuatetonyo, huan nochi tamantzitzi cati quitequihuía. ");
INSERT INTO nchBl_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Nojquiya quimocuitahuijque nopa taquetzalme para nopa calixpamit cati quiyahualohuayaya nopa tiopamit ihuaya nopa tepos cuatetomit para taquetzalme, ihuaya iniestacas huan inilazos. Ya nopa elqui inintequi iixhuihua Merari. ");
INSERT INTO nchBl_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Huan TOTECO quinnahuati Moisés, Aarón huan ininconehua ma quiquetzaca iniyoyoncalhua nechca nopa tiopamit ica campa quisa tonati. Huan quipixque inintequi para quinmocuitahuilise nochi nopa yoyon tiopamit campa TOTECO mopantiyaya ica nopa israelitame. Huan sinta cati hueli tacat quinechcahuisquía nopa yoyon tiopamit, monequiyaya quimictise. ");
INSERT INTO nchBl_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Huan nochi nopa levita tacame cati Moisés huan Aarón quinpojque cati quipiyayayaj se metzti para huejcapa ajsique 22 mil oquichipilme huan tacame. ");
INSERT INTO nchBl_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Teipa TOTECO quiilhui Moisés: “Xiquinpohua nochi achtohui ehuani oquichpilme huan tacame ipan israelitame cati quipiyaj se metzti para huejcapa, huan xiquinijcuilo ica inintoca. ");
INSERT INTO nchBl_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Nochi levitame elise noaxcahua para techtequipanose na, niamoTECO. Huan yeca ayecmo nimoaxcatis iniachtohui conehua nochi israelitame. Huan inintapiyalhua levitame nimoaxcatis, huan yeca ayecmo elis noaxca iniachtohui cone sesen sihua tapiyali cati iniaxca sequinoc israelitame cati amo levitame.” ");
INSERT INTO nchBl_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Huajca Moisés quinpojqui nochi israelitame cati achtohui ehuani cati oquichpilme o tacame senquisa quej TOTECO quinahuatijtoya. ");
INSERT INTO nchBl_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Huan nochi oquich israelitame cati quiaxitijtoyaj se metzti quinijcuilojque huan mochijque 22 mil 273 para nochi. ");
INSERT INTO nchBl_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Huan TOTECO quicamanalhui Moisés huan quiilhui: ");
INSERT INTO nchBl_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Techmaca nochi levitame para techtequipanose quej ininpataca amooquichpilhua cati achtohui ehuani, huan techmaca inintapiyalhua nopa levitame quej ininpataca inioquichtapiyalhua cati achtohui ehuani ten nochi israelitame. Quena, nochi levitame elise noaxcahua para ma techtequipanoca na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Pero nopa achtohui ehuani oquichpilme huan tacame ten nochi israelitame quipano 273 imiyaca nopa oquichpilme huan tacame cati eliyayaj levitame. Huajca ten nopa 273 achtohui ehuani israelitame, amo aqui se oquichpil o taca levita para ica nijpatas huan monequi antechcohuilise. ");
INSERT INTO nchBl_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Huajca para sesen ten nopa 273, monequi techmacaca macuili plata tomi cati quipiya 11 gramos ietica quej nopa tatamachihuali cati quitequihuíaj ipan tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Huan xiquinmactili nopa tomi Aarón ihuaya iconehua para antechcohuilise nopa 273 achtohui ehuani ipan israelitame cati mocajque.” ");
INSERT INTO nchBl_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Huajca Moisés quiseli nopa tomi cati nopa masehualme quitaxtahuiyayaj por nopa achtohui ehuani israelitame cati mocajque. ");
INSERT INTO nchBl_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Huan para nochi quiseli 1 mil 365 plata tomi ica ietica quej nopa tatamachihuali cati quitequihuijque ipan tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Huan teipa Moisés quinmactili Aarón huan itelpocahua nopa tomi senquisa quej TOTECO quinahuatijtoya. ");
INSERT INTO nchBl_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Teipa TOTECO quinnojnotzqui Moisés huan Aarón huan quinilhui: ");
INSERT INTO nchBl_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Xijtananaca se censo ten nochi nopa levitame cati nojquiya elij iteipan ixhuihua Coat. Xiquijcuiloca ajquiya inijuanti hualajque ipan sesen ten nopa huejhueyi tetatme cati eliyayaj itelpocahua nopa huejcapan tata Coat. ");
INSERT INTO nchBl_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Ama xiquinpohuaca nochi tacame cati quipiyaj 30 hasta 50 xihuit huan cati huelise tequitise ipan nopa yoyon tiopamit campa timopantíaj. ");
INSERT INTO nchBl_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Huan ya ni nopa tequit cati quichihuase iteipan ixhuihua Coat ica nopa tamanti tatzejtzeloltic tiopan calijtic. ");
INSERT INTO nchBl_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Quema monequi anquiijcuenise nopa yoyon tiopamit para anyase sejcoyoc, Aarón ihuaya iixhuihua calaquise achtohui huan quiquixtise nopa cortina cati quitzacua ipan caltemit campa calaquij campa nopa caxa cati quipiya cati amohuaya nimocajqui, niamoTECO, huan ica ya nopa quitzacuase nopa caxa. ");
INSERT INTO nchBl_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Huan ipani nopa cortina quitalise nopa seyoc cortina cati tachijchihuali ica inincuetaxo pesojme. Huan iixco quipatahuilise nopa patiyo yoyomit cati azultic huan sempa quicalaquise nopa cuahuit huehueyac ipan ianillos para quihuicase. ");
INSERT INTO nchBl_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Teipa ipan nopa cuamesa campa eltoc nopa pantzi monequi xijpajpatahuase se yoyomit azultic. Huan ipan nopa yoyomit quitalise nochi platome, cucharas, caxime huan nopa tazajme cati quitequihuíaj quema quitoyahuaj se tacajcahualisti tatoyahuali. Huan nojquiya nopa pantzi cati nochipa eltos nopona. ");
INSERT INTO nchBl_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Huan iixco nochi nopa tamanti quipatahuase nopa patiyo yoyomit cati chichiltic. Huan teipa quipiquise ica inincuetaxo pesojme huan teipa sempa quicalaquise nopa cuahuit huehueyac cati ica quihuicase. ");
INSERT INTO nchBl_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Teipa quicuise seyoc nopa patiyo yoyomit cati azultic huan quipatahuase ipan nopa taahuil quetzali ica itaahuilhua, iticuilhua, iplatos, huan nochi ixarro para aceite cati nopona quitequihuíaj. ");
INSERT INTO nchBl_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Huan nochi nopa tamanti ihuaya nopa taahuil quetzali quimimilose ica inincuetaxo pesojme. Huan teipa sempa quicalaquise nopa cuahuit huehueyac para quihuicase. ");
INSERT INTO nchBl_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Teipa quipatahuase seyoc patiyo yoyomit azultic ipan nopa taixpamit ten oro para copali. Teipa quipiquise ica inincuetaxo pesojme huan sempa quicalaquise nopa huejhueyi cuahuit para ica quihuicase. ");
INSERT INTO nchBl_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Huan nochi tamantzitzi cati motequihuía tiopan calijtic quisentilise huan quitalise ipan seyoc patiyo yoyomit azultic. Teipa quimimilose ica inincuetaxo pesojme huan sempa quicalaquise nopa huehueyac cuahuit para quihuicase. ");
INSERT INTO nchBl_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Teipa monequi quiquixtise nochi nopa cuajnexti ten nopa taixpamit campa quitatíaj tacajcahualisti. Huan ipan quipatahuase seyoc patiyo yoyomit morado. ");
INSERT INTO nchBl_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Huan iixco quitalise nochi ten motequihuía ipan taixpamit. Quitalise itepos caja campa quitemaj cuajnexti, iteposchijcolhua para quiitzquise nacat, ipalas, huan nopa huajcali para quiselis esti, huan nochi sequinoc teposme cati nopona motequihuíaj. Huan teipa quipiquise ica inincuetaxo pesojme huan sempa quicalaquise nopa huehueyac cuahuit para ica quihuicase. ");
INSERT INTO nchBl_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Huan quema Aarón huan itelpocahua ya tantose para quipijpiquise nochi nopa tamanti cati tatzejtzeloltic cati eltoya tiopan calijtic, huajca quena, hueli quicuiquij iixhuihua Coat para quihuicase ipan ojti hasta campa anajsise. Pero iteipan ixhuihua Coat amo hueli quiitzquise nopa tamanti tatzejtzeloltic, pampa miquise. Huajca nochi ni tamanti elis inintequi iteipan ixhuihua Coat para quihuicase. ");
INSERT INTO nchBl_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Huan Eleazar itelpoca nopa totajtzi Aarón quipiyas imaco nopa aceite para taahuilme, nopa copali cati ajhuiyac mijyotía, nopa tacajcahualisti ten harina cati monequi mojmosta, huan nopa aceite cati tatzejtzeloltic para taiyocatalise para na, niamoTECO. Nelía mocahua imaco Eleazar para quimocuitahuis nochi nopa yoyon tiopamit campa nimocahua amohuaya ica nochi cuamesas huan tamantzitzi cati onca tiopan calijtic huan nochi cati mochijtoc nopona.” ");
INSERT INTO nchBl_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Huan TOTECO quinilhui Moisés ihuaya Aarón: ");
INSERT INTO nchBl_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Amo xiquincahuilica para iteipan ixhuihua Coat ma quichihuaca tamanti tequit cati amo quipiyaj tanahuatili quichihuase para amo miquise. ");
INSERT INTO nchBl_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Para amo tantiyase iixhuihua Coat ipan levitame, quej ni anquichihuase. Aarón huan itelpocahua ma itztoca tiopan calijtic inihuaya huan ma quiilhuica sesen iixhui Coat taya monequi quichihuas huan taya monequi quihuicas para amo quinechcahuis cati tatzejtzeloltic huan miquise. ");
INSERT INTO nchBl_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Huan sinta amo aqui cati itelpocahua Aarón tiopan calijtic, huajca amo ma calaquica nopa coatitame yon se talojtzi, pampa huelis quiitase se tamanti cati tatzejtzeloltic, huan sinta quiitase se tenijqui, miquise.” ");
INSERT INTO nchBl_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Teipa sempa TOTECO quinojnotzqui Moisés huan quiilhui: ");
INSERT INTO nchBl_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Xijtanana nojquiya se censo ten nochi nopa levitame cati iixhuihua Gersón cati itztoya huejcajquiya. Xiquijcuilo ajquiya inijuanti hualajque ipan sesen ten nopa huejhueyi tetatme cati eliyayaj itelpocahua Gersón huejcajquiya. ");
INSERT INTO nchBl_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Xiquinpohuaca nochi tacame cati quipiyaj 30 hasta 50 xihuit cati huelise calaquise ipan notequi, niamoTECO, ipan nopa yoyon tiopamit campa timopantíaj. ");
INSERT INTO nchBl_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Huan ya ni elis inintequi iixhuihua Gersón quema tequipanose tiopan calijtic huan quema quihuicase tamamali. ");
INSERT INTO nchBl_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Quihuicase nopa cortinas ica cati quichijque nopa cuartos ipan tiopa, huan nopa inincuetaxo pesojme cati ica quitzactoque, huan nopa cortinas cati ica quitzacuaj campa ancalaquij tiopan calijtic. ");
INSERT INTO nchBl_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Nojquiya quihuicase nopa cortinas ipan nopa tatzacti iteno calixpamit, ihuaya nopa cortina cati quitzacua campa ancalaquij campa calixpamit cati quiyahualohua nopa tiopamit huan nopa taixpamit. Huan quihuicase nochi lazos huan teposme cati motequihuíaj ipan nopa cortinas. Huajca elis inintequi iixhuihua Gersón para quihuicase ni tamantzitzi. ");
INSERT INTO nchBl_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Huan Aarón ihuaya itelpocahua quinilhuise iixhuihua Gersón sesen tequit cati monequi quichihuase huan cati quihuicase. ");
INSERT INTO nchBl_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Pero elis Itamar, itelpoca nopa totajtzi Aarón, cati achi más quinnahuatis iixhuihua Gersón ipan inintequi. ");
INSERT INTO nchBl_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Xiquinpohua nojquiya nochi levitame cati elij iixhuihua Merari ten huejcajquiya ica sese inintelpocahua, pampa nochi ome mochijtoque huejhueyi tetajme. ");
INSERT INTO nchBl_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Xiquinpohua nochi iniixhuihua cati quipiyaj 30 hasta 50 xihuit huan hueli calaquise tequipanose tiopan calijtic. ");
INSERT INTO nchBl_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Iixhuihua Merari quihuicase nopa tiopamit ihuapalhua, icuaixtapalhua, itaquetzalhua huan itepos cuatetonyo. ");
INSERT INTO nchBl_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Nojquiya quihuicase nopa taquetzalme ipan calixpamit huan inintepos cuatetonyo, huan inintepos estacas, huan inimecayohua huan nochi nopa tamantzitzi cati quitequihuíaj. Huan Itamar monequi quinotzas sesen tacat ica itoca huan quiilhuis taya quihuicas quema anmijcuenise. ");
INSERT INTO nchBl_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Huajca ya ni eli inintequi iixhuihua Merari huan monequi quinnahuatis Itamar, icone nopa totajtzi Aarón.” ");
INSERT INTO nchBl_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Huajca Moisés huan Aarón huan nochi nopa tayacanani ten nopa israelitame quinpojque iixhuihua Coat. Huan quiniyocatali ipan nahui familias quej quisque ten inahui telpocahua Coat huejcajquiya. ");
INSERT INTO nchBl_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Quinpojque cati quipiyayayaj 30 hasta 50 xihuit huan quinijcuilojque para quitequipanose TOTECO ipan nopa yoyon tiopamit campa timopantíaj. ");
INSERT INTO nchBl_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Huan iixhuihua Coat ajsique 2 mil 750. ");
INSERT INTO nchBl_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Ya ni elque nochi iixhuihua Coat cati hueliyayaj tapalehuise ipan nopa yoyon tiopamit. Huan Moisés huan Aarón quinpojque huan quinijcuilojque senquisa quej TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nchBl_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Huan nojquiya quinpojque iixhuihua Gersón. Huan quiniyocatali ipan ome familias quej quisque ten sese nopa ome telpocahua Gersón huejcajquiya. ");
INSERT INTO nchBl_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Quinpojque cati quipiyayayaj 30 hasta 50 xihuit, ");
INSERT INTO nchBl_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","huan quinijcuilojque para quitequipanose TOTECO ipan nopa yoyon tiopamit huan ajsique 2 mil 630. ");
INSERT INTO nchBl_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Huajca ya ni elque nochi iixhuihua Gersón cati hueliyayaj tapalehuise ipan nopa yoyon tiopamit campa timopantíaj. Huan Moisés huan Aarón quinpojque huan quinijcuilojque senquisa quej TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nchBl_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Huan nojquiya quinpojque iixhuihua Merari. Huan quiniyocatali ipan ome familias quej quisque ipan sese ten nopa ome itelpocahua Merari huejcajquiya. ");
INSERT INTO nchBl_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Quinpojque cati quipiyayayaj 30 hasta 50 xihuit huan quinijcuilojque para quitequipanose TOTECO ipan nopa yoyon tiopamit campa timopantíaj. ");
INSERT INTO nchBl_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Huan iixhuihua Merari ajsique 3 mil 200. ");
INSERT INTO nchBl_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Huajca ya ni elque nochi iixhuihua Merari cati hueliyayaj tapalehuise ipan nopa yoyon tiopamit. Huan Moisés huan Aarón quinpojque senquisa quej TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nchBl_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Huan Moisés huan Aarón quinpojque nochi levitame cati itztoyaj ipan nopa tonali. Huan quiijcuilojque inintoca nopa tacame cati quisque ipan Coat, Gersón huan Merari cati elque nopa eyi itelpocahua Leví cati huejcajquiya. Huan quiijcuilojque cati quisque ten sese ininchicueyi telpocahua. ");
INSERT INTO nchBl_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Huan nopa tacame cati quipiyayayaj 30 hasta 50 xihuit huan hueliyayaj tapalehuise ipan tiopamit huan tamamase, ");
INSERT INTO nchBl_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ajsique 8 mil 580. ");
INSERT INTO nchBl_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Huajca ya ni elque nochi iteipan ixhuihua Leví cati huelque tapalehuise ipan tiopamit. Huan senquisa quej TOTECO quinahuatijtoya Moisés, quinpojque nochi cati quichihuase tequit o cati quihuicase tamantzitzi. ");
INSERT INTO nchBl_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Teipa TOTECO quicamanalhui Moisés huan quiilhui: ");
INSERT INTO nchBl_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Xiquinnahuati nochi israelitame para ma quinquixtica ten ininchajchaj nochi cati palani ininacayo ica lepra, huan nojquiya cati atemoj ipan inintacayo ihuaya nochi cati amo tapajpactique pampa quiitzquijque se mijcatzi. Huan xiquinquixtica huejca ten amoaltepe ten yoyoncalme. ");
INSERT INTO nchBl_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Xiquinquixtica tacame huan nojquiya sihuame cati mopantíaj ica ni cocolisti, huan ma yaca itztotij huejca ten amochajchaj para amo quichihuase amo tapajpactic campa amoyoyoncalhua pampa nopona tatajco ten amojuanti, niitztoc na cati nitatzejtzeloltic.” ");
INSERT INTO nchBl_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Huajca nopa israelitame quineltocaque nochi cati TOTECO quinahuatijtoya Moisés huan quinquixtijque nochi cati quej nopa mococohuayayaj. ");
INSERT INTO nchBl_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Huan TOTECO quinojnotzqui Moisés huan quiilhui: ");
INSERT INTO nchBl_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Xiquinilhui nochi israelitame para quema se tacat o se sihuat quiixpano seyoc masehuali, na niquijtohua para quihuica tajtacoli noixpa. ");
INSERT INTO nchBl_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Huan monequi nopa tacat o nopa sihuat technelilhuis noixpa cati quichijtoc huan teipa yas quitaxtahuiti nopa seyoc cati quichihuilijtoc fiero. Huan quicuepilis nochi cati quinenpolojtoc huan nojquiya quipihuilis 20 por ciento más huan amo quej quicuitoya. ");
INSERT INTO nchBl_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Huan sinta nopa tacat cati quitachtequilijtoya o ten hueli quichihuilijtoya ya mictoc huan amo aqui yon se iteixmatca para quicuepilis, huajca nopa tomi cati quitahuiquilía elis para Toteco huan para quitequihuis se totajtzi. Huan nojquiya monequi quimacas nopa totajtzi nopa oquich borrego cati monequi. Huan nopa totajtzi techtencahuilis para techixtzacuilis nopa tajtacoli cati quichijtoc nopa tacat. ");
INSERT INTO nchBl_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","“Nochi nemacti cati israelitame techhualiquilíaj na, niamoTECO, elis iaxca nopa totajtzi. ");
INSERT INTO nchBl_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Nochi tamanti tacualisti huan tapalehuili ten inimil cati quimacase TOTECO, mocahuas iaxca nopa totajtzi.” ");
INSERT INTO nchBl_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Huan TOTECO quinojnotzqui Moisés huan quiilhui ma quinmaca israelitame ni tanahuatilme: ");
INSERT INTO nchBl_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Sinta isihua se tacat quiixpanos ihuehue huan mocahuas ica seyoc tacat, ");
INSERT INTO nchBl_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","pero amo aqui quiitas para huelis quitatelhuis ica itajtacol, ya ni cati quichihuas. ");
INSERT INTO nchBl_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Sinta ihuehue, quena, quitasomati isihua huan moilhuía para tajtacolchijtoc, o huelis ihuehue quitasomati isihua huan amo teno quichijtoc, quej ni anquisencahuase. ");
INSERT INTO nchBl_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Nopa tacat monequi quihuicas isihua iixpa totajtzi ica se tacajcahualisti ten ome kilos harina ten cebada, huan techtencahuilis para na, niamoTECO. Pero amo quimanelos nopa harina ica aceite, yon amo quitalilis copali taajhuiyacayot, pampa ya nopa elis se tacajcahualisti para quimatis cati temachti, sinta moilhuía para tajtacolchijtoc isihua. ");
INSERT INTO nchBl_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“Huan nopa totajtzi quihualicas nopa sihuat para ma monechcahui huan moquetzas noixpa, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Huan nopa totajtzi quicuis se achi at cati taiyocatalili para na huan quitecas ipan se xarro ten soquit, huan quimanelos ica se achi taltepocti cati eltoc talchi ten nopa yoyon tiopamit campa itztoc. ");
INSERT INTO nchBl_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Huan teipa nopa totajtzi quichihuas para nopa sihuat ma moquetza noixpa, niamoTECO, huan quitojtomas itzoncal. Huan nopa totajtzi quitalis imaco nopa sihuat nopa tacajcahualisti ten harina pampa ihuehue moilhuía tajtacolchijtoc. Huan nopa totajtzi moquetzas iixpa nopa sihuat huan quipixtos imaco nopa xarro ica nopa at cati chichic huan cati quimaca se tatelchihuali, o se tatzacuiltili cati tajtacolchijtoc. ");
INSERT INTO nchBl_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Huajca nopa totajtzi quichihuas para nopa sihuat ma techtestigojquetza, niamoTECO, sinta amo tajtacolchijtoc. Huan teipa nopa totajtzi quiilhuis: ‘Sinta amo timocajtoc ica seyoc tacat quema ya tijpixtoc mohuehue, yon amo teno cati amo cuali tijchijtoc ica seyoc tacat, huajca amo teno ma mopanti quema tiquis ni at cati chichic cati quihualica tatelchihualisti ipan cati tajtacolchijtoc. ");
INSERT INTO nchBl_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Pero sinta timochijtoc amo titapajpactic huan titaixpanotoc quema ya tijpixtoc mohuehue huan timocajtoc ica seyoc tacat, ");
INSERT INTO nchBl_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","huajca TOTECO ma mitztelchihua huan ma mitztatzacuilti para nochi ma quiitaca. ");
INSERT INTO nchBl_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Huan quema tiquis ni at cati chichic, quichihuas ma palani mometztomahuiya huan ma semahuiya moijti huan amo huelis tiquinpiyas coneme.’ Huan nopa sihuat quiijtos: ‘Quej nopa ma eli.’ ");
INSERT INTO nchBl_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“Huajca nopa totajtzi quiijcuilos ni tatelchihualisti ipan se cuetax amat ica tinta huan teipa quiixpolos nopa tinta huan nopa camanali ica nopa at cati chichic. ");
INSERT INTO nchBl_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Teipa quichihuas para nopa sihuat ma quii nopa at cati temaca se tatelchihualisti ipan cati tajtacolchijtoc. Huan nopa at calaquis iijtico huan quichihuas chichic iijtico sinta quipiya tajtacoli. ");
INSERT INTO nchBl_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Huan teipa nopa totajtzi quiselis ten imaco nopa sihuat nopa tacajcahualisti ten harina, huan quihuisos iixpa TOTECO huan quihuicas campa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Huan quicuis se tamojtzoli ten nopa tacajcahualisti ten cebada huan quitatis ipan nopa taixpamit quej elisquía nochi nopa tacajcahualisti. “Huan teipa quema nopa totajtzi ya quichijtos nochi ni tamanti, quimacas nopa at ma quii. ");
INSERT INTO nchBl_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Huan sinta mochijtoc amo tapajpactic huan quiixpanotoc ihuehue, nopa at cati quihualica tatelchihualisti calaquis iijtico huan quichihuas para isihuayo ma semahuiya huan imetztomahuiya ma palani. Huan nochi imasehualhua quiitase nopa sihuat para tatelchihuali. ");
INSERT INTO nchBl_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Pero sinta nopa sihuat amo quipiya tajtacoli, amo teno oncas huan cuali huelis conepiyas. ");
INSERT INTO nchBl_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“Huajca ya ni eli nopa tanahuatili quema se quitasomati isihua pampa mochijtoc amo tapajpactic huan quiixpanotoc ihuehue quema ya motahuicaltijtoya ihuaya. ");
INSERT INTO nchBl_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","O ya ni nojquiya para quema se tacat moilhuía para isihua quiixpanotoc huan quitasomati, huan quinequi quimatis cati temachti. Ihuehue quiixpantis isihua noixpa, niamoTECO, huan nopa totajtzi quichihuilis senquisa quej quiijtohua ni tanahuatili. ");
INSERT INTO nchBl_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Huan amo elis itajtacol ihuehue sinta quiajsis ni tatelchihualisti, pampa eli ya itajtacol. Huan monequi quiijyohuis nochi tatzacuiltilisti.” ");
INSERT INTO nchBl_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Huan sempa TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Xiquinilhui nochi israelitame para quema se sihuat o se tacat quinequi moiyocacahuas para na niamoTECO, para elis se nazareo huan moiyocatalis para senquisa elis noaxca, huan amo quej sequinoc sihuame o tacame, ");
INSERT INTO nchBl_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","huajca nopa masehuali amo hueli quiis xocomeca at huan yon se taili cati nelcococ. Yon amo hueli quiis cati quixocoltijtoque, yon vinagre cati quichijtoque ica xocomeca at, o cati cococ. Nojquiya amo huelis quicuas xocomecat itajca, yon itajca cati ya huactoc. ");
INSERT INTO nchBl_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Ipan nochi nopa tonali quema noca mocajtoc para moiyocacahuas quej se nazareo, amo teno quicuas cati huala ipan xocomecat itajca, yon ixinacho, yon ipetayo. ");
INSERT INTO nchBl_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Ipan nochi nopa tonali quema moiyocacajtoc para na, amo hueli moximas. Yaya elis tatzejtzeloltic huan taiyocatalili para na, niamoTECO, huan quicahuas ma moscalti huehueyac itzoncal hasta quitamiltis nochi nopa tonali huan nopa tamanti cati techilhuijtoc. ");
INSERT INTO nchBl_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Huan ipan nochi nopa tonali quema moiyocatalijtoc para na, amo hueli monechcahuis campa se mijcatzi, pampa mochihuas amo tapajpactic noixpa. ");
INSERT INTO nchBl_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Masque miquis itata, inana, o se isihuaicni, o se itacaicni, ma amo monechcahuis para mochihuas amo tapajpactic pampa moiyocatalijtoc para na, niamoTeco Dios, huan quipiyas itzoncal huehueyac cati quinescayotía cati noca mocajtoc. ");
INSERT INTO nchBl_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Huan nochi tonali cati huejcahuas cati noca mocajtoc, monequi mocahuas tatzejtzeloltic noixpa. ");
INSERT INTO nchBl_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Huan sinta samolhui san huetzis mictoc se acajya cati moquetztoc ihuaya, huajca, quena, quichihuas amo tapajpactic noixpa, masque amo quinequiyaya mochihuas amo tapajpacti. Huajca quema ajsis chicome tonati para mochijtoc amo tapajpactic, monequi quitequis nochi itzoncal pampa itzoncal huehueyac quinescayotiyaya para taiyocatali para na. ");
INSERT INTO nchBl_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Huan ipan chicueyi tonati, quinhualicas ome pilpichontzitzi, o ome pilpalomajtzitzi, huan quimacas nopa totajtzi campa icalte nopa yoyon tiopamit campa timopantíaj. ");
INSERT INTO nchBl_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Huan nopa totajtzi techtencahuilis nopa piltototzi quej se tacajcahualisti por tajtacoli, huan nopa seyoc techtencahuilis quej se tacajcahualisti tatatili. Huan ica ya ni techixtzacuilis itajtacol pampa itztoya nechca se mijcatzi. Huan nojquiya ipan nopa tonal sempa moiyocatalis para na, niamoTECO, huan sempa pehuas quicahuas ma moscalti itzoncal. ");
INSERT INTO nchBl_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Nopa tonali cati ya panotoc quema achtohui moiyocatalijtoya para na, quiixpolo. Sempa monequi motemactilis ica na para elis nazareo nochi tonali quej quichijqui achtohui. Huan monequi quihualicas se piloquich borregojtzi cati san quipiya se xihuit para techtencahuilis quej se tacajcahualisti pampa quihuica tajtacoli. ");
INSERT INTO nchBl_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Huan quema ya tamis nochi nopa tonali cati motemacac para elis nazareo, ya ni nopa tanahuatili cati sesen monequi quitoquilis. Monequi hualas huan techhualiquilis se tacajcahualisti campa icalte nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Techtencahuilis se piloquich borregojtzi cati san quipiya se xihuit huan cati amo teno quipiya huan elis se tacajcahualisti tatatili. Huan nojquiya techmacas se pilsihua borregojtzi cati san quipiya se xihuit huan amo teno quipiya huan nopa elis se tacajcahualisti por tajtacoli. Nojquiya techtencahuilis se oquich borrego cati amo teno quipiya huan elis para se tacajcahualisti para nimoyoltalis ihuaya. ");
INSERT INTO nchBl_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Nojquiya ihuaya, techmacaca nopa tacajcahualisti ten harina huan cati tatoyahuali cati monequi techmacase ihuaya. Huan monequi nopa tacajcahualisti ten harina elis se chiquihuit temitoc ica pantzi cati amo quipiya tasonejcayot. Quipiyas tortas cati quichijtoque ica cuali harina maneltic ica aceite, huan nojquiya quipiyas pantzi cati cacatztic cati quixacualojtoque ica aceite. ");
INSERT INTO nchBl_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“Huan nopa totajtzi quitencahuas nochi ya ni noixpa ihuaya nopa tacajcahualisti por tajtacoli huan nopa tacajcahualisti tatatili cati ne nazareo quihualicac. ");
INSERT INTO nchBl_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Huan techmacas nopa oquich borrego huan nopa chiquihuit ica pantzi cati amo quipiya tasonejcayot, huan elis se tacajcahualisti para tayoltalili ica na. Huan nopa totajtzi nojquiya techmacas nopa tacajcahualisti ten harina huan cati tatoyahuali cati ihuaya yahui. ");
INSERT INTO nchBl_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“Huan nopona campa icalte nopa yoyon tiopamit campa timopantíaj, nopa nazareo monequi quiximas nochi itzoncal cati quinescayotiyaya cati noca mocajtoya, huan quicuis nochi nopa tzoncali huan quitalis ipan nopa tit cati eltoc itantita nopa tacajcahualisti para tayoltalili ica na. ");
INSERT INTO nchBl_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“Huan teipa quema cuali motzoncaltectosa ne nazareo, nopa totajtzi quicuis iajcol nopa oquich borrego cati molontoya hasta cuali icsitoc, huan quitalis imaco ne nazareo ihuaya se pantzi ica tatzopelcayot huan se pantzi cati cacatztic cati eltoc ipan nopa chiquihuit huan cati amo quipiya tasonejcayot. ");
INSERT INTO nchBl_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Huan teipa nopa totajtzi quicuis huan quihuisos nopa tacajcahualisti noixpa, niamoTECO, para ma eli se tacajcahualisti tahuisoli. Huan nochi nopa tacajcahualisti mochihuas tatzejtzeloltic huan elis iaxca nopa totajtzi, ica nopa pantzi ihuaya ielchiqui huan iajcol nacayo nopa borrego cati tahuisoli. Huan teipa quema nopa totajtzi tamis techtencahuilía nochi noixpa, ya cati eliyaya nazareo huelis quiis xocomeca at pampa ya tanqui cati noca mocajqui, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Huajca ya ni elqui nopa tanahuatili para se nazareo, huan amechilhuía taya tacajcahualisti monequi antechtencahuilise quema se quitamichihuas cati noca mocajtoc para quichihuas. Nojquiya monequi quihualicas nochi sequinoc tacajcahualisti cati techilhui techmactilis quema moiyocatali huan mochijqui nazareo.” ");
INSERT INTO nchBl_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Teipa TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Xiquilhui Aarón inihuaya iconehua para ma quintiochihuaca israelitame ica ni camanali. Ma quiijtoca: ");
INSERT INTO nchBl_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘Ma TOTECO mitztiochihua huan ma mitzmocuitahui. ");
INSERT INTO nchBl_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Ma cahuani ixayac TOTECO ica paquilisti quema moilhuía ten ta. Ma quipiya hueyi iyolo ica ta. ");
INSERT INTO nchBl_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Ma TOTECO mitznextili itaicnelijcayo huan ma mitzmaca itasehuilis ipan moyolo.’ ");
INSERT INTO nchBl_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Ica ni camanali, Aarón huan iconehua technotzase ma niquintiochihua israelitame huan, quena, na niquintiochihuas para nochi quimatise inijuanti noaxcahua.” ");
INSERT INTO nchBl_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Huan ipan nopa tonali quema Moisés ya quitamichijtoya nopa yoyon tiopamit campa TOTECO mocahuasquía inihuaya, quiatzejtzelhui ica aceite sesen tamanti cati eltoya calijtic, huan quiiyocatali para TOTECO. Nojquiya quiatzejtzelhui ica aceite nopa taixpamit huan nochi cati motequihuía nopona. ");
INSERT INTO nchBl_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Teipa yajque nopa tayacanca israelitame ipan sesen hueyi familia cati tapalehuijtoyaj para quitananque nopa censo. ");
INSERT INTO nchBl_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Huan quitalitoj iixpa TOTECO nochi cati quinequiyayaj quimactilise. Huan sesen ten nopa tayacanani quihualicac se hueyi toro. Huan sese ome tayacanani quihualicaque se cuacarro. Huajca ica nochi nopa nemacti cati quihualicaque elqui chicuase carrojme cati tzactoque, huan 12 huejhueyi torojme cati quimatij tatilanase huan quimacaque TOTECO iteno icalte nopa yoyon tiopamit campa mocahua TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nchBl_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Xiquinseli nopa cuacarrojme huan nopa huejhueyi torojme cati quimatij tatilanaj, huan xiquinmaca nopa levitame para ma quintequihuica ipan nochi nopa tequit cati monequi para quihuicase cati eltoc ipan nopa yoyon tiopamit campa timopantíaj. Xijmaca sesen levita nopa tamantzitzi cati monequi quitequihuis ipan ten ya itequi.” ");
INSERT INTO nchBl_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Huajca Moisés quinseli nopa cuacarrojme huan nopa huejhueyi torojme huan quinmajmacac nopa levitame. ");
INSERT INTO nchBl_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Iixhuihua Gersón quinmacac ome cuacarrojme huan nahui huejhueyi torojme para quitequihuise ipan inintequi. ");
INSERT INTO nchBl_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Huan iixhuihua Merari quinmacac nahui cuacarrojme huan chicueyi huejhueyi torojme para quitequihuise ipan inintequi. Nochi inin mocajqui imaco Itamar, icone nopa totajtzi Aarón. ");
INSERT INTO nchBl_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Pero iixhuihua Coat amo quinmacac yon se cuacarro huan yon se toro, pampa monejqui quihuicase iniajcoltipa nopa tamantzitzi tatzejtzeloltique cati mocajqui inimaco para quimocuitahuise. ");
INSERT INTO nchBl_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Huan nojquiya quema ajsic tonali para quiiyocatalise nopa taixpamit para TOTECO huan quitatzejtzelolchihuase, sesen ten nopa tayacanani ten nochi huejhueyi familias quihuicaque se nemacti huan quitalijque iixpa nopa taixpamit. ");
INSERT INTO nchBl_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Huan TOTECO quiilhui Moisés: “Mojmosta ipan sesen tonal quema anquitatzejtzelolchihuase nopa taixpamit, xijcahua para san setzi tayacanquet ma techmactili cati quihualicac.” ");
INSERT INTO nchBl_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Huajca ipan nopa achtohui tonali, quimactili inemac Naasón, icone Aminadab, ipan nopa hueyi familia Judá. ");
INSERT INTO nchBl_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Huan inemac eliyaya se hueyi plato ixsepantic ten plata huan ietica eliyaya se kilo huan tajco, ihuaya se hueyi taza ten plata ica ietica quej tajco kilo ipan itatamachihual nopa yoyon tiopamit. Huan nopa plato huan nopa hueyi taza quihualicac temitoc ica harina cati achi más cuali maneltic ica aceite para se tacajcahualisti ten harina. ");
INSERT INTO nchBl_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Nojquiya quihualicac se cuchara cati senquisa oro ica 110 gramos ietica, huan temitoya ica copali. ");
INSERT INTO nchBl_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Huan quihualicac se becerro, se oquich borrego huan se piloquich borregojtzi cati san quipiya se xihuit para elise se tacajcahualisti tatatili. ");
INSERT INTO nchBl_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Nojquiya quihualicac se oquich chivo quej se tacajcahualisti por tajtacoli. ");
INSERT INTO nchBl_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","Huan para se tacajcahualisti para ma onca tayoltalili ihuaya TOTECO, quinhualicac ome huejhueyi torojme cati quimatij tatilanaj, macuilti oquich borregojme, macuilti oquich chivojme huan macuilti piloquich borregojtzitzi cati san quipiyaj se xihuit. Nochi ya ni elqui nopa nemacti cati Naasón, icone Aminadab, quihualicac. ");
INSERT INTO nchBl_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Ipan ome tonati quihuicac inemac Natanael, icone Zuar, cati eliyaya tayacanquet ipan nopa hueyi familia Isacar. ");
INSERT INTO nchBl_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","23","Huan inemac cati temacac elqui san se quej cati temacac Naasón. ");
INSERT INTO nchBl_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Ipan eyi tonati quihuicac se nemacti Eliab, icone Helón, cati eliyaya tayacanquet ipan nopa hueyi familia Zabulón. ");
INSERT INTO nchBl_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","29","Huan temactili inemac cati elqui san se quej nopa sequinoc. ");
INSERT INTO nchBl_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Ipan nahui tonati quihuicac se nemacti Elisur, icone Sedeur, cati eliyaya tayacanquet ipan nopa hueyi familia Rubén. ");
INSERT INTO nchBl_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","35","Huan temactili nojquiya san se inemac quej nopa sequinoc. ");
INSERT INTO nchBl_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Ipan macuili tonati quihuicac se nemacti Selumiel, icone Zurisadai, cati eliyaya tayacanquet ipan nopa hueyi familia Simeón. ");
INSERT INTO nchBl_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","41","Huan temactili nojquiya san se nemacti quej nopa sequinoc. ");
INSERT INTO nchBl_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Ipan chicuasen tonati quihuicac se nemacti Eliasaf, icone Reuel, cati eliyaya tayacanquet ipan nopa hueyi familia Gad. ");
INSERT INTO nchBl_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","47","Huan temactili nojquiya san se nemacti quej nopa sequinoc. ");
INSERT INTO nchBl_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Ipan chicome tonati quihuicac se nemacti Elisama, icone Amiud, cati eliyaya tayacanquet ipan nopa hueyi familia Efraín. ");
INSERT INTO nchBl_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","53","Huan temactili nojquiya san se nemacti quej nopa sequinoc. ");
INSERT INTO nchBl_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Ipan chicueyi tonati quihuicac se nemacti Gamaliel, icone Pedasur, cati eliyaya tayacanquet ipan nopa hueyi familia Manasés. ");
INSERT INTO nchBl_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","59","Huan temactili nojquiya san se nemacti quej nopa sequinoc. ");
INSERT INTO nchBl_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Ipan chicnahui tonati quihuicac se nemacti Abidán, icone Gedeoni, cati eliyaya tayacanquet ipan nopa hueyi familia Benjamín. ");
INSERT INTO nchBl_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","65","Huan temactili nojquiya san se nemacti quej nopa sequinoc. ");
INSERT INTO nchBl_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Ipan majtacti tonati quihuicac se nemacti Ahiezer, icone Amisadai, cati eliyaya tayacanquet ipan nopa hueyi familia Dan. ");
INSERT INTO nchBl_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","71","Huan temactili nojquiya san se nemacti quej nopa sequinoc. ");
INSERT INTO nchBl_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Ipan majtacti huan se tonati quihuicac se nemacti Pagiel, icone Ocrán, cati eliyaya tayacanquet ipan nopa hueyi familia Aser. ");
INSERT INTO nchBl_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","77","Huan temactili nojquiya san se nemacti quej nopa sequinoc. ");
INSERT INTO nchBl_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Ipan majtacti huan ome tonati quihuicac se nemacti Ahira, icone Enán, cati eliyaya tayacanquet ipan nopa hueyi familia Neftalí. ");
INSERT INTO nchBl_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","83","Huan temactili nojquiya san se nemacti quej nopa sequinoc. ");
INSERT INTO nchBl_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Nochi ya ni elqui nopa nemacti cati nopa tayacanani ten israelitame temactilijque para quiiyocatalise nopa taixpamit para TOTECO huan quitatzejtzelolchihuase. Ica nochi elqui 12 huejhueyi platos cati ixsepantique ten plata, 12 huajcali ten plata, huan 12 huejhueyi cucharas ten oro. ");
INSERT INTO nchBl_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Huan sesen plato quipixqui se kilo huan tajco ietica, huan sesen huajcali ten plata quipixqui tajco kilo ietica. Ica nochi nopa tamanti ten plata elqui nechca 26 kilos ietica ipan itatamachihual nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Nojquiya oncayaya 12 cucharas ten oro cati temitoya ica copali cati quipixqui 110 gramos ietica ipan itatamachihual nopa yoyon tiopamit. Nopa oro ten nochi nopa cucharas quipixqui se kilo huan 320 gramos ietica. ");
INSERT INTO nchBl_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Huan nopa tapiyalme para tacajcahualisti tatatili elque ica nochi 12 becerros, 12 oquich borregojme, 12 piloquich borregojtzitzi cati san quipiyaj se xihuit ihuaya nopa 12 tacajcahualisti ten harina cati monequiyaya inihuaya, huan 12 oquich chivojme para quinmacase quej tacajcahualisti por tajtacoli. ");
INSERT INTO nchBl_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Huan nochi nopa tapiyalme cati quinhualicaque para tacajcahualisti para tayoltalili elqui ica nochi 24 becerros, 60 oquich borregojme, 60 oquich chivojme huan 60 piloquich borregojtzitzi cati sanoc quipiyayayaj se xihuit. Nochi ya ni elqui cati quimactilijque TOTECO quema quiiyocacahuayayaj huan quitatzejtzelolchihuayayaj nopa taixpamit para TOTECO. ");
INSERT INTO nchBl_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Huan quema Moisés calajqui ipan nopa yoyon tiopamit campa mopantiyayaj ihuaya Toteco Dios para quicamanalhuis, quicajqui itoscac. Huan caquistic para itoscac quisayaya tatajco ten nopa ome ilhuicac ehuani cati inintoca querubines cati moquetztoyaj iixco itzajca icaxa. Huajca nopona Toteco Dios quicamanalhui Moisés. ");
INSERT INTO nchBl_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Huan TOTECO quicamanalhui Moisés huan quiilhui: ");
INSERT INTO nchBl_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Xiquilhui Aarón quema quintalis nochi taahuilme, ma quichihua para ma taahui ica iixmelac ten nopa taahuil quetzali.” ");
INSERT INTO nchBl_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Huan quichijqui Aarón nochi cati TOTECO quinahuatijtoya Moisés, huan quinchijchijqui nochi taahuilme para ma taahuica ica iixmelac. ");
INSERT INTO nchBl_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Huan nopa taahuil quetzali quichijchijtoyaj ica senquisa oro cati quitejtejtzontoyaj san ica martillo. Ten iniicxi hasta iyecapa campa quichihuilijtoyaj ixochiyo, nochi quichijque san ica martillo. Nochi iyejyejca nopa taahuil quetzali elqui senquisa quej TOTECO quinextilijtoya Moisés ma quichihua. ");
INSERT INTO nchBl_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Huan TOTECO quicamanalhui Moisés huan quiilhui: ");
INSERT INTO nchBl_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Xiquinquixti nochi iteipan ixhuihua Leví ten ne sequinoc israelitame huan xiquintapajpacchihua noixpa para techtequipanose. ");
INSERT INTO nchBl_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ya ni cati tijchihuas: xiquinatzejtzelhuis ica at cati tetapajpacchihua noixpa. Teipa moximase huan mohuatanise hasta moquixtilise nochi tzoncali ipan inintacayo. Teipa maltise, huan cuali quichicuenise iniyoyo, huan quej nopa elise tapajpactique para techtequipanose. ");
INSERT INTO nchBl_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Teipa ma quihualicaca se becerro huan nopa tacajcahualisti ten harina cati ihuaya yahui. Ya nopa elis cuali harina maneltic ica aceite. Huan nojquiya quihuicase seyoc becerro quej se tacajcahualisti por tajtacoli. ");
INSERT INTO nchBl_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Ta tijchihuas para nopa levitame ma monechcahuica icalteno ni yoyon tiopamit campa timopantíaj huan nochi israelitame nojquiya nopona ma mosentilica. ");
INSERT INTO nchBl_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Teipa xijchihua para nopa levitame ma moixnextica noixpa huan nopa sequinoc israelitame ma quintalilica inimax ipan inintzonteco. ");
INSERT INTO nchBl_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Huan Aarón quihuisos imax noixpa, niamoTECO, quej techmaca se tacajcahualisti tahuisoli, huan quej nopa techmactilis nochi levitame quej se hueyi tacajcahualisti cati nochi israelitame techmacaj na, niamoTECO. Huan ica ya nopa quiniyocatalis nochi levitame para techtequipanose. ");
INSERT INTO nchBl_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Teipa nochi levitame quitalise inimax ipan inintzonteco nopa becerros. Teipa techtencahuilise se becerro quej se tacajcahualisti por tajtacoli huan seyoc becerro techmactilise quej se tacajcahualisti tatatili para na, niamoTECO, para techixtzacuilise inintajtacolhua nochi levitame. ");
INSERT INTO nchBl_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Huan teipa xiquintali nochi nopa levitame para ma moquetzaca iniixpa Aarón huan itelpocahua, huan nochi techmacas quej se tacajcahualisti tahuisoli para na, niamoTECO. ");
INSERT INTO nchBl_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Huan quej ni tiquiniyocatalis nopa levitame ten nochi sequinoc israelitame, huan nochi levitame elise noaxcahua. ");
INSERT INTO nchBl_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Huan quema ya anquintapajpacchijtose nopa levitame huan anquinnextijtose noixpa quej se tacajcahualisti tahuisoli, inijuanti hueli calaquise para techtequipanose ipan ni yoyon tiopamit campa timopantíaj. ");
INSERT INTO nchBl_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","“Pampa nochi levitame senquisa noaxcahua huan amo quej sequinoc israelitame, pampa nimoaxcati nochi levitame quej ininpataca nochi ininconehua israelitame cati achtohui ehuani cati monequiyaya techmactilisquíaj. ");
INSERT INTO nchBl_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Pampa nelía noaxcahua nochi cati achtohui tacatij ten israelitame, masque ininconehua o inintapiyalhua, nochi cati achtohui tacatij noaxcahua. Pampa huejcajquiya quema niquinmicti nochi coneme cati achtohui tacatque ipan tali Egipto, niquiniyocatali para noaxcahua nochi coneme cati achtohui ehuani ten israelitame. ");
INSERT INTO nchBl_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Pero ama quej ininpataca nopa achtohui ehuani ten nochi israelita coneme, nimoaxcatijtoc nochi levitame para noaxcahua. ");
INSERT INTO nchBl_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Huan ama nochi levitame cati niquintapejpeni iyoca ten nochi sequinoc israelitame nijmaca Aarón huan itelpocahua quej se nemacti para quinpalehuise quichihuase nopa tequit tatzejtzeloltic ipan ni yoyon tiopamit campa timopantíaj. Huan nopa levitame tequitise quej ininpataca nopa sequinoc israelitame. Huan techtencahuilise inintacajcahualis nopa sequinoc israelitame para quiixtzacuase inintajtacolhua noixpa na, niamoTECO. Huan quej ni, cati hueli israelita amo calaquis ipan ni yoyon tiopamit para tapalehuis para amo quinajsis israelitame se hueyi cocolisti cati ica miquise.” ");
INSERT INTO nchBl_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Huajca Moisés, Aarón huan nochi israelitame quichijque ica nopa levitame nochi cati TOTECO quinahuatijtoya Moisés ma quichihuaca. ");
INSERT INTO nchBl_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Huan nochi levitame motapajpacchijque huan quichicuenijque iniyoyo, huan Aarón quinpanexti iixpa TOTECO quej se tacajcahualisti tahuisoli. Huan Aarón nojquiya quitencajqui iixpa se tacajcahualisti para quinixtzacuilis inintajtacolhua para ma elica tapajpactique iixpa. ");
INSERT INTO nchBl_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Huajca quema tanqui nochi ni tamanti cati mochijqui, nopa levitame pejque calaquij para quichihuase nochi inintequi ipan nopa yoyon tiopamit campa timopantíaj ihuaya TOTECO, huan tequitique ica itanahuatil Aarón huan itelpocahua. Huan nochi quichijque senquisa quej TOTECO quinahuatijtoya Moisés ma quinchihuili nopa levitame. ");
INSERT INTO nchBl_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","TOTECO nojquiya quicamanalhui Moisés huan quiilhui: ");
INSERT INTO nchBl_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Nochi levitame quema quiaxitijtose 25 xihuit, monequi quipehualtise para techtequipanose ipan ni yoyon tiopamit campa timopantíaj. ");
INSERT INTO nchBl_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Huan quisase ipan nopa tequit quema quiaxitise 50 xihuit. ");
INSERT INTO nchBl_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Teipa quema ya quiaxitijtose nopa xihuit para mosiyajquetzase, huelis quinpalehuise inihuampoyohua ica tequit cati amo ohui, pero nopa tequit cati ohui ayecmo ma quichihuaca. Quej nopa anquintequimacase levitame.” ");
INSERT INTO nchBl_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Quema TOTECO quicamanalhui Moisés huan quiilhui nochi ni camanali ya panotoya se xihuit para quistejque ipan tali Egipto huan calaquiyayaj ipan nopa achtohui metzti ipan xihuit ome. Huan ipan nopa tonali nopa israelitame itztoyaj ipan nopa huactoc tali Sinaí huan nojquiya TOTECO quiilhui ni camanali: ");
INSERT INTO nchBl_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Sesen xihuit monequi nochi israelitame quinescayotise nopa ilhuit cati itoca Pascua ipan nopa tonali cati nimechnahuatijtoc. ");
INSERT INTO nchBl_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Quema ya tiotaquixtos ipan 14 itequi ni metzti cati achtohui ipan toxihui, anquitoquilise nopa tanahuatili quej ijcuilijtoc. Senquisa quej nimechnextilijtoc para anquichihuase, ya nopa anquichihuase.” ");
INSERT INTO nchBl_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Huajca Moisés quinnahuati nopa israelitame ma quinescayotica nopa Pascua ilhuit. ");
INSERT INTO nchBl_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Huan nopona ipan nopa huactoc tali cati itoca Sinaí quema tiotaquixtoya ipan 14 itequi nopa achtohui metzti ipan nopa xihuit, inijuanti ilhuichijque senquisa quej TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nchBl_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Pero itztoyaj sequij tacame cati mochijtoyaj amo tapajpactique iixpa TOTECO pampa quiitzquitoyaj se mijcatzi, huan yeca amo huelque quinescayotise nopa Pascua ipan nopa tonali. Huajca yajque quiitatoj Moisés ihuaya Aarón ipan nopa tonali, ");
INSERT INTO nchBl_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","huan quinilhuijque: ―Masque tiquitzquitoque se mijcatzi, huan timochijtoque amo titapajpactique iixpa TOTECO, ¿para ten amo huelis tijtencahuase se nemacti iixpa TOTECO ipan ni tonali quema nochi israelitame quinescayotíaj ni Pascua ilhuit? ");
INSERT INTO nchBl_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Huan Moisés quinnanquili: ―Ximochiyaca hasta TOTECO techilhuis taya cuali para mochihuas quema quej ni pano. ");
INSERT INTO nchBl_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Huan TOTECO quicamanalhui Moisés huan quiilhui: ");
INSERT INTO nchBl_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Xiquinilhui nopa israelitame quema inijuanti o se inincone amo hueli quinescayotis nopa ilhuit Pascua inihuaya nochi sequinoc, huelis teipa quichihuase. Sinta se amo hueli quinescayotis nopa ilhuit quema monequi pampa monejqui quiitzquis se mijcatzi o huelis se mopantía huejca ten ichaj quema sequinoc ilhuichihuaj, yaya hueli quinescayotise nopa ilhuit teipa. ");
INSERT INTO nchBl_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Pero quinescayotise quema tiotaquixtos ipan 14 ten nopa ome metzti ipan ne xihuit. Monequi quicuase nopa pilborregojtzi ica xihuit cati chichic huan pantzi cati amo quipiya tasonejcayot. ");
INSERT INTO nchBl_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Huan amo teno quicahuase para seyoc tonali, yon amo quipostequilise yon se iomiyo nopa pilborregojtzi. Ma quinescayotica nopa Pascua senquisa quej nimechnextilijtoc anquichihuase. ");
INSERT INTO nchBl_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Pero sinta se acajya cati tapajpactic huan amo cana yajtoc, san moilhuis para amo quinescayotis nopa Pascua ilhuit, monequi anquiquixtise para ayecmo huelis itztos amohuaya anisraelitame. Quej nopa anquichihuase, pampa amo techtencahuili nopa tacajcahualisti noixpa ipan nopa tonali quema, niamoTECO, nijtali, huan yeca monequi quiselis nopa tatzacuiltili por itajtacol. ");
INSERT INTO nchBl_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Nochi seyoc tali ehuani cati itztoque amohuaya nojquiya monequi quinescayotise nopa Pascua para na quej nimechnextilijtoc. Onca san se tanahuatili para israelitame huan seyoc tali ehuani para quenicatza quinescayotise, huan nochi monequi san se quichihuase.” ");
INSERT INTO nchBl_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Ipan nopa tonali quema tanque quiquetzaj nopa yoyon tiopamit cati quipixtoya nopa camanali cati quichijtoya inihuaya, se hueyi mixti hualajqui quitzacuaco. Huan quema pejqui tiotaquiya, nopa mixti mopatac para nesis quej se tilelemecti itzonta nopa tiopamit huan quej nopa eltoya hasta tanesiyaya. ");
INSERT INTO nchBl_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Huan quej ni eliyaya nochipa. Ica tonaya se mixti quitzacuayaya nopa yoyon tiopamit huan ica tayohua nesiyaya quej se hueyi tit. ");
INSERT INTO nchBl_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Quema nopa mixti mijcueniyaya ten nopa yoyon tiopamit, nopa israelitame quistehuayayaj huan quitoquilijtiyahuiyayaj. Huan quema nopa mixti moquetzayaya huan ayecmo nejnemiyaya, nopa israelitame nopona quiquetzayayaj iniyoyoncalhua. ");
INSERT INTO nchBl_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Quej ni nopa israelitame mijcueniyayaj quema TOTECO quinnahuatiyaya, huan moquetzayayaj san campa quinilhuiyaya. Nochi tonali quema nopa mixti mocahuayaya itzonta nopa tiopamit, amo quistehuayayaj. ");
INSERT INTO nchBl_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Huan masque nopa mixti mocahuayaya ipan tiopamit miyac tonali huan amo mijcueniyaya, nochi israelitame quineltoquiliyayaj itanahuatil TOTECO huan amo nejnemiyayaj. ");
INSERT INTO nchBl_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Huan quema nopa mixti amo mocahuayaya miyac tonali, nopa israelitame nojquiya amo mocahuayayaj miyac tonali, pampa quej nopa TOTECO quinnextilijtoya. ");
INSERT INTO nchBl_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Huan quema nopa mixti moquetzayaya ten se tiotac hasta ijnaloc, huajca nopa israelitame moquetzayayaj. Huan quema ica ijnaloc nopa mixti motananayaya, inijuanti nojquiya motananayayaj huan quitoquiliyayaj. Pero masque tonaya o tayohua quema mijcueniyaya nopa mixti, inijuanti quistehuayayaj para quitoquilise senquisa quej TOTECO tanahuatijtoya. ");
INSERT INTO nchBl_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Sinta nopa mixti moquetzayaya ipan nopa yoyon tiopamit campa TOTECO itztoya se ome tonati, o se metzti, o se xihuit, nochi nopa israelitame mocahuayayaj nopona huan ayecmo nejnemiyayaj. Pero quema nopa mixti motananayaya, inijuanti quistehuayayaj huan quitoquiliyayaj. ");
INSERT INTO nchBl_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Huajca quema TOTECO quinnahuatiyaya, ma quiquetzaca iniyoyoncalhua, inijuanti quinquetzayayaj. Huan quema TOTECO quinnahuatiyaya ma nejnemica para quitoquilise nopa mixti, quistehuayayaj. Quineltocaque nochi cati TOTECO quinahuati Moisés ma quichihuaca. ");
INSERT INTO nchBl_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Huan TOTECO quicamanalhui Moisés huan quiilhui: ");
INSERT INTO nchBl_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Xijchihua ome tapitzali ica plata cati tatejtzonali ica martillo. Huan anquipitzase para anquinnotzase israelitame ma mosentilica o para ma quimatica quema monequi motecpanase para quisase. ");
INSERT INTO nchBl_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Quema anquinpitzase nochi ome tapitzalme ica sempa, nochi israelitame quimatise ma mosentilica imelac icalte ni yoyon tiopamit campa timopantíaj. ");
INSERT INTO nchBl_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Pero quema anquipitzase setzi tapitzali, san mosentilise cati tayacanaj ipan sesen hueyi familia. ");
INSERT INTO nchBl_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Huan quema anhuejcahuase anquipitzase, elis para anquistehuase, huan inijuanti cati quiquetztoque ininchajchaj ica campa quisa tonati ten ni yoyon tiopamit achtohui quistehuase para nejnemise. ");
INSERT INTO nchBl_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Huan quema anquipitzase ica ompa, motecpanase para nejnemise cati quiquetztoque ininchajchaj ica sur huan nochi sequinoc quintoquilise. ");
INSERT INTO nchBl_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Pero quema san anquinnotzase masehualme para ma mosentilica, amo xihuejcahuaca xijpitzaca. ");
INSERT INTO nchBl_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","San totajtzitzi, inijuanti cati itelpocahua Aarón, huelise quipitzase nopa tapitzali. Ya ni elis se tanahuatili para anquitoquilise amojuanti huan amoixhuihua para nochipa. ");
INSERT INTO nchBl_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“Quema anajsise ipan amotal huan monequi anquintehuise amocualancaitacahua, xijpitzaca chicahuac nopa tapitzali, huan na, niamoTECO Dios, nimechelnamiquis, huan nimechmanahuis inimaco amocualancaitacahua. ");
INSERT INTO nchBl_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Nojquiya xijpitzaca nopa tapitzali quema onca tonali ten paquilisti. Xijpitzaca quema anilhuichihuaj, o quema eli selic metzti, o quema anquitencahuaj tacajcahualisti tatatili o tacajcahualisti para ma onca tayoltalili ica na. Huan quej nopa na cati niamoTECO huan niamoDIOS nimechelnamiquis.” ");
INSERT INTO nchBl_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Huan ipan 20 itequi nopa ompa metzti quema yahuiyaya para ome xihuit quistoyaj ten tali Egipto, nopa mixti motananqui ten nopa yoyon tiopamit campa TOTECO mocahuayaya. ");
INSERT INTO nchBl_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Huajca nopa israelitame quistejque ipan nopa huactoc tali cati itoca Sinaí huan quitoquilijque. Huan teipa nopa mixti moquetzato ipan nopa huactoc tali cati itoca Parán. ");
INSERT INTO nchBl_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Ya ni nopa achtohui huelta quema quistejque huan quitoquilijque nopa mixti quej TOTECO quinahuatijtoya Moisés ma quichihuaca. ");
INSERT INTO nchBl_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Huan achtohui motecpanque para nejnemise cati quihuicayayaj ibandera nopa tatehuijca pamit Judá. Huan Naasón, icone Aminadab, quinyacanayaya nopa hueyi familia Judá. ");
INSERT INTO nchBl_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Huan teipa quitoquilijque nopa hueyi familia Isacar ica inintayacanca, Natanael, icone Zuar. ");
INSERT INTO nchBl_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Huan teipa yahuiyaya nopa hueyi familia Zabulón ica inintayacanca, Eliab, icone Helón. ");
INSERT INTO nchBl_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Huan quema tanque quicocopitzaj nopa yoyon tiopamit campa TOTECO mocajqui inihuaya, nopa levitame cati iniixhuihua Gersón huan Merari motecpanque huan pejque quihuicatiyahuij nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Huan iniica motecpanque cati quihuicayayaj ibandera nopa tatehuijca pamit Rubén. Huan Elisur, icone Sedeur, quinyacanayaya nopa hueyi familia Rubén. ");
INSERT INTO nchBl_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Teipa quintoquili nopa hueyi familia Simeón ica inintayacanca cati itoca Selumiel, icone Zurisadai. ");
INSERT INTO nchBl_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Huan iniica yahuiyaya nopa hueyi familia Gad ica inintayacanca Eliasaf, icone Deuel. ");
INSERT INTO nchBl_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Huan iniica motecpanque iixhuihua Coat cati elqui seyoc itelpoca Leví huejcajquiya. Huan nopa coatitame quihuicayayaj nochi cuamesas, taixpamit huan tamanti tatzejtzeloltic ten nopa yoyon tiopamit. Huan cati tayacantiyajque nimantzi quiquetzatoj nopa yoyon tiopamit nopona campa yahuij para ya eltos tasencahuali quema ajsise ni tacame ica ni tamanti. ");
INSERT INTO nchBl_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Teipa iniica coatitame motecpanque cati quihuicayayaj ibandera nopa tatehuijca pamit Efraín. Huan Elisama, icone Amiud, quiyacanayaya nopa hueyi familia Efraín. ");
INSERT INTO nchBl_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Huan iniica yahuiyaya Gamaliel, icone Pedasur, cati quiyacanayaya nopa hueyi familia Manasés. ");
INSERT INTO nchBl_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Huan iniica motecpanque Abidán, icone Gedeoni, cati quiyacanayaya nopa hueyi familia Benjamín. ");
INSERT INTO nchBl_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Huan taica motecpanque cati quihuicayayaj ibandera nopa tatehuijca pamit Dan. Huan Ahiezer, icone Amisadai, quiyacanayaya nopa hueyi familia Dan. ");
INSERT INTO nchBl_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Huan iniica Dan yahuiyayaj nopa hueyi familia Aser ica inintayacanca cati itoca Pagiel cati eliyaya icone Ocrán. ");
INSERT INTO nchBl_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Huan iniica yahuiyaya nopa hueyi familia Neftalí ica inintayacanca Ahira cati eliyaya icone Enán. ");
INSERT INTO nchBl_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Quej ni motecpanque nopa huejhueyi familias ten israelitame quema quistehuayayaj para yase sejcoyoc. ");
INSERT INTO nchBl_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Se tonali Moisés quiilhui itex, Hobab, cati eliyaya icone Ragüel ten tali Madián: ―Tojuanti tiyahuij ipan nopa tali cati TOTECO quiijtojtoc para techmacas. Xihuala tohuaya huan tiitztose cuali mohuaya, pampa TOTECO techtencahuilijtoc cati cuali techchihuilis tiisraelitame. ");
INSERT INTO nchBl_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Pero Hobab quinanquili: ―Amo, amo nijnequi niyas. Nijnequi nitacuepilis notal campa itztoque noteixmatcahua. ");
INSERT INTO nchBl_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Pero Moisés quiilhui: ―Amo techcajtehua. Ta cuali tiquixmati nochi ojti ipan nopa huactoc tali huan canque cuali timocahuase. Xihuala tohuaya huan techyacana. ");
INSERT INTO nchBl_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Sinta tihualas tohuaya, nochi cati cuali cati TOTECO techmacas tojuanti, timitzmacase nojquiya. ");
INSERT INTO nchBl_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Huajca yaya yajqui huan nochi inijuanti quistejque ten itepe TOTECO huan nejnenque eyi tonati. Huan icaxa TOTECO cati quipixtoya cati quintencahuilijtoya tayacantiyahuiyaya huan quintemohuilijtinemiyaya canque mosiyajquetzase. ");
INSERT INTO nchBl_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Huan tonaya quema quistehuayayaj, nopa mixti cati TOTECO quinmacayaya yahuiyaya inintzonta. ");
INSERT INTO nchBl_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Huan quema quitananayayaj nopa caxa para quistehuase, Moisés chicahuac quiijtohuayaya: “¡Ximotanana TOTECO! ¡Xijchihua para nochi mocualancaitacahua ma mosemanaca! ¡Xijchihua para nochi cati amo quinequij mitzitase ma cholojtehuaca!” ");
INSERT INTO nchBl_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Huan quema quisehuiyayaj nopa caxa para mosiyajquetzase, Moisés sempa quiijtohuayaya chicahuac: “¡Ximocuepa, TOTECO, nica campa momasehualhua! ¡Tiitztoque tahuel nelpano miyac miles ten masehualme hasta amo aqui huelis techpohuas! ¡Nica ximocahua tohuaya!” ");
INSERT INTO nchBl_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Se tonali nopa israelitame pejque camanaltij cati amo monequi huan quitaijilhuiyayaj TOTECO por nopa taijyohuilisti cati moilhuijque quipanoyayaj. Huan TOTECO quincajqui huan tahuel cualanqui. Huan quintitanili se tit cati pejqui quintatía cati quiquetztoyaj ininchajchaj itejteno campa nopa sequinoc israelitame quiquetztoyaj ininchajchaj. ");
INSERT INTO nchBl_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Huajca nochi israelitame cuatzajtzique chicahuac huan quitajtanijque Moisés ma quinpalehui. Huan Moisés quitajtani TOTECO tapalehuili huan nopa tit sejqui. ");
INSERT INTO nchBl_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Huajca quitocaxtijque itejteno inialtepe Tabera. (Tabera quinequi quiijtos Campa Talemenqui.) Pampa hasta nopona nopa tit ten TOTECO quintati. ");
INSERT INTO nchBl_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Nopa masehualme cati amo israelitame cati nejnemiyayaj inihuaya israelitame huan hualajtoyaj ipan ten hueli xinachti masehualme, san moilhuiyayaj para quinequiyayaj quicuase nacat. Huan nopa israelitame nojquiya quintoquilijque huan pejque mochoquilíaj huan quiijtohuayayaj: “¡Nelía cuali elisquía sinta oncasquía nacat para tijcuase! ");
INSERT INTO nchBl_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Tiquelnamiquij nopa michime cati tiquincuayayaj san tapic nepa ipan tali Egipto. Huan nojquiya tijcuayayaj pepinos, meloj, xonacat, seboyas huan ajos. ");
INSERT INTO nchBl_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Pero ama nochi tiyamaníaj huan ayecmo timayanaj, pampa san ni maná onca para tijcuase.” ");
INSERT INTO nchBl_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Huan nopa maná cati huetziyaya eliyaya quej iyol nopa colanto huan nesiyaya achi costic quej cuaesti. ");
INSERT INTO nchBl_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Huan iajhuiyaca eliyaya quej taxcali ten harina taxacualoli ica aceite. Huan mojmosta nopa israelitame quisayayaj calteno huan quisentiliyayaj. Teipa quitisiyayaj ipan inimet, o quitejtzonayayaj, o quimanayayaj huan ica quichihuayayaj se pantzi. ");
INSERT INTO nchBl_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Ica tayohua, quema huetziyaya ajhuechti calteno, huetziyaya nojquiya nopa maná. ");
INSERT INTO nchBl_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Huan Moisés quicajqui para masehualme ipan sese israelita familia mosehuijtoyaj inincalixpa chocayayaj, pampa TOTECO tahuel cualanqui, huan Moisés nojquiya amo quipacti cati quichihuayayaj. ");
INSERT INTO nchBl_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Huajca Moisés quiilhui TOTECO: ―¿Para ten quej ni techchihuilijtoc, na nimotequipanojca? ¿Taya amo cuali nijchijtoc moixpa para techmamaltijtoc nochi ni masehualme? ");
INSERT INTO nchBl_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Amo na niinintata o niininana. Inijuanti amo noconehua. ¿Para ten techilhuía ma niquinmamajtinemi hasta tiajsise campa nopa tali cati tiquinilhuijtoc para tiquinmacas tohuejcapan tatahua? Na niquinhuica san quej se quihuica icone cati noja chichi. ");
INSERT INTO nchBl_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","¿Canque hueli nijcuis nacat para quicuase nochi ni miyaqui israelitame? Nochi san techchoquilíaj huan techilhuíaj: ‘Techmaca nacat para tijcuase.’ ");
INSERT INTO nchBl_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Na amo nihueli niquinhuicas nochi ni miyaqui masehualme noseltitzi. Niquinita quej se tamamali cati tahuel etic para na. ");
INSERT INTO nchBl_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Sinta quej ni techchihuilis nochipa, achi más cuali techmicti na ama sinta nelía techicnelía. Quej nopa amo monequi niquitas cati ni masehualme techchihuilise. ");
INSERT INTO nchBl_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Pero TOTECO quinanquili: ―Techsentilhuili 70 huehue tacame cati tijmati quenicatza tayacanase huan quihuicase tequiticayot ica ni miyaqui israelitame. Huan xiquinhualica campa nopa yoyon tiopamit campa timopantíaj huan nopona techchiya inihuaya. ");
INSERT INTO nchBl_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Huan na nitemos huan nopona nimitzcamanalhuis. Huan nijcuis Notonaltzi cati itztoc mohuaya huan nojquiya niquinmacas para inijuanti ma mitzpalehuica para anquinhuicase nochi ni miyaqui masehualme. Huan quej nopa amo monequi titequitis moseltitzi. ");
INSERT INTO nchBl_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Huan nojquiya nimantzi xiquinnahuati nochi israelitame ma moyolpajpacaca noixpa, pampa mosta ica ijnaloc quicuase nacat. Xiquinilhui ya niquincactoc para chocaj huan quiijtohuaj para elisquía cuali sinta oncasquía nacat para quicuase. Moilhuíaj achi más cuali itztoyaj nepa ipan tali Egipto. Yeca ama na niquinmacas nacat para quicuase. ");
INSERT INTO nchBl_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Huan amo quicuase se tonal, yon ome tonati, yon macuili tonati, yon majtacti tonati, yon 20 tonati. ");
INSERT INTO nchBl_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Pero quicuase nochi se metzti hasta quisas ipan iniyacatzol huan quiijiyase, pampa inijuanti techhuejcamajcajtoque na, cati niamoTECO; na cati niitztoc tatajco ten inijuanti. Chocatoque noixpa huan quiijtojtoque: ‘¿Para ten tiquisque nepa ipan tali Egipto?’ ");
INSERT INTO nchBl_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Huajca Moisés quiijto: ―San tacame cati nejnemij nohuaya itztoque 600 mil huan iyoca sihuame huan coneme. ¿Quenicatza tiquijtohua techmacas nacat para tijcuase nochi se metzti? ");
INSERT INTO nchBl_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Masque tiquinmictisquíaj nochi toborregojhua huan tohuacaxhua, amo quinaxilisquía para nochi. Masque tiquinmacasquía nochi michime cati itztoque ipan hueyi at, amo quinaxilisquía. ");
INSERT INTO nchBl_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Pero TOTECO quinanquili: ―¿Ta timoilhuía tahuel pilquentzi nochicahualis? Ama tiquitas sinta mochihuas o amo mochihuas cati niquijtohua. ");
INSERT INTO nchBl_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Huajca Moisés quisqui huan quinpohuili nochi israelitame cati TOTECO Dios quiilhuijtoya. Huan quinsentili nopa 70 huehue tacame ten nopa israelitame huan quintali yahualtic ten nopa yoyon tiopamit. ");
INSERT INTO nchBl_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Huan TOTECO temoc ipan nopa mixti huan quicamanalhui Moisés. Huan teipa quicuic Itonaltzi cati itztoya ipan Moisés para quipalehuis, huan nojquiya quinmacac nopa 70 huehue tacame. Huan quema Itonaltzi motali ipan nopa huehue tacame, pejque camanaltij quej tajtolpanextiani. Pero san se huelta panoc huan ayecmo quema mochijqui sempa. ");
INSERT INTO nchBl_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Huan itztoyaj ome ten nopa 70 huehue tacame cati TOTECO quintapejpenijtoya cati mocajtoyaj ipan ininchajchaj, se itoca Eldad huan ne se itoca Medad. Pero nojquiya Itonal TOTECO motali ipan inijuanti huan pejque camanaltij quej tajtolpanextiani nopona campa itztoyaj ipan ininchajchaj. ");
INSERT INTO nchBl_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Huajca sequij telpocame motalojtiyajque huan quiilhuitoj Moisés para Eldad huan Medad camanaltitoyaj quej tajtolpanextiani nepa campa ininchajchaj. ");
INSERT INTO nchBl_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Huajca Josué, icone Nun, cati quipalehuijtoya Moisés hasta itelpocatiya quiijto: ―Noteco Moisés, xiquintacahualti. ");
INSERT INTO nchBl_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Pero Moisés quinanquili: ―¿Ta techtasomati? Nelcuali elisquía sinta TOTECO quinmacasquía Itonaltzi nochi israelitame huan nochi elise tajtolpanextiani. ");
INSERT INTO nchBl_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Huan Moisés huan nochi nopa huehue tacame tacuepilijque campa ininchajchaj. ");
INSERT INTO nchBl_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Huan TOTECO quichijqui ma huala se ajacat chicahuac ten campa hueyi at huan quinhualicac tahuel miyac solime. Huan patantinemiyayaj campa hueli tatajco huan yahualtic nopa altepet ten iniyoyoncalhua nopa israelitame. Huan nopa solime patantinemiyayaj echcapantzi san quej se metro ihuejcapanca. Huan nojquiya eliyaya temitoc ica solime huejca ten ininchajchaj hasta campa se huelis ajsis sinta nejnemis para se tonal ihuejcaca. ");
INSERT INTO nchBl_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Huajca nochi nopa achtohui tonali huan yohuali huan ipan nopa seyoc tonali, nochi israelitame quinitzquitinemiyayaj huan quinmictijtinemiyayaj solime. Huan cati tahuel pilquentzi quisentili, quisentili quej 60 hueyi lalax chiquihuit ten senquisa solime. Huan pejque quinhuatzaj campa hueli itejteno inialtepe ten yoyon calme. ");
INSERT INTO nchBl_vpl VALUES ("NU11_33","005_11