﻿USE sofia;
DROP TABLE IF EXISTS sofia.ncf_vpl;
CREATE TABLE ncf_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ncf_vpl WRITE;
INSERT INTO ncf_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Inaatalem ina xan matenbung Iesu Karisito, ia xan tsi Dewit, ia xan tsi Abaram. ");
INSERT INTO ncf_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abaram, ia xan mom Aisak, Aisak, ia xan mom Jakop, Jakop, ia xan mom Juda mii xan no turamasen, ");
INSERT INTO ncf_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda, ia xan mom Peres ma Sera, xadelu nagaa, Tamaa Peres, ia xan mom Esron, Esron, ia xan mom Arem, ");
INSERT INTO ncf_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arem, ia xan mom Aminadap, Aminadap, ia xan mom Nason, Nason, ia xan mom Salmon, ");
INSERT INTO ncf_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon, ia xan mom Boas, xan nagaa Reaap, Boas, ia xan mom Obet, xan nagaa Rut, Obet, ia xan mom Jesi. ");
INSERT INTO ncf_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","O Jesi, ia xan mom King Dewit. Dewit, ia xan mom Solomon, xan nagaa xan tubu Uraia. ");
INSERT INTO ncf_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon, ia xan mom Reoboam, Reoboam, ia xan mom Abaija, Abaija, ia xan mom Asaa, ");
INSERT INTO ncf_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaa, ia xan mom Josapat, Josapat, ia xan mom Joram, Joram, ia xan mom Usaia, ");
INSERT INTO ncf_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaia, ia xan mom Jotam, Jotam, ia xan mom Aʼas, Aʼas, ia xan mom Esakaia, ");
INSERT INTO ncf_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esakaia, ia xan mom Manase, Manase, ia xan mom Amon, Amon, ia xan mom Josaia. ");
INSERT INTO ncf_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ma Josaia, ia xan mom Jekonaia, ma no turamasen sin leng ina gigi laa Babilon. ");
INSERT INTO ncf_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Mil sin abia gigi laa Babilon: Jekonaia, ia xan mom Salatiel, Salatiel, ia xan mom Serubabel, ");
INSERT INTO ncf_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel, ia xan mom Abiut, Abiut, ia xan mom Eliakim, Eliakim, ia xan mom Aso, ");
INSERT INTO ncf_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aso, ia xan mom Sadok, Sadok, ia xan mom Akim, Akim, ia xan mom Eliut, ");
INSERT INTO ncf_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut, ia xan mom Eliasa, Eliasa, ia xan mom Matan, Matan, ia xan mom Jakop, ");
INSERT INTO ncf_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ma Jakop, ia xan mom Josep, ia xan maxis Maria, iwaa ta taxaali Iesu, gita ta putsangi Karisito. ");
INSERT INTO ncf_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Biaabi tii suk sangaul axuuk ma ga laa et ina ul xaal sin Abaram laa sin Dewit, sangaul axuuk ma ga laa et xaal sin Dewit pupua sin gigi laa Babilon ma sangaul axuuk ma ga laa et sebula xaal sin gigi Babilon le pupua sin Karisito. ");
INSERT INTO ncf_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Balawaa inaatalem ina Maria tii taana Iesu Karisito: Maria, di tii se xubatsi ngali naba maxis sin Josep. Oro setauan sin delu ba ta maxis, di se tatanginai ta se tiaan taman tsi biaa Nantanua Pat ta tali sin. ");
INSERT INTO ncf_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Amuina Josep, iwaa xan maas, ia taamat tutiik tii ga xap saan ngali amangieli ia nan no matan no inaman, ga adodo ngali atsiplii adamisi ia. ");
INSERT INTO ncf_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Oro mil Josep adodo xuduxudu sin abia, xan angelo Orong ga asemat sin ia lalon binalang, ga we, “Josep, xan tsi Dewit, nangaam mataa ngali giwaa Maria laa tataam malen num tubu amuina Nantanua Pat tsaa a tali aia tsi lalon balan. ");
INSERT INTO ncf_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Maria naba taana tsi taamat ma u na a tsoxo iesani Iesu, amuina naba atoaa xan no inaman sin xadi no namaang tsaxa.” ");
INSERT INTO ncf_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Balawaa no maarang araraa atsap ngali taxaawiti xan totore Orong ta tali sin xan propet. ");
INSERT INTO ncf_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Iexa aina uul ta xap mager matul mii xa taamat naba tiaan, ma naba taana xa tsi taamat, di ba a tso iesani Emanuel.” Muina abala ies aweaatalaa, “Moroaa a manman mii gita.” ");
INSERT INTO ncf_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Biaa Josep ta pade, asuk amusili sawe xan angelo Orong ta asaait awatwati taman ma ga giwaa Maria laa tatan malen xan tubu. ");
INSERT INTO ncf_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Oro, delu xap mager matmatuul etaxaa til sin leng Maria ta taxaanai tsi taamat, o Josep ga a tso iesani ia, Iesu. ");
INSERT INTO ncf_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Mil sin di ta se taana Iesu lalon inaman laba Betliem, lalon prowins Judaia, sin xan no leng King Erot, no unsinaae biaa di ta xaal nan selina, di xaalame Jerusalem, ");
INSERT INTO ncf_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ma di ga atsura, “Inaai aia tsi di ta taana, iwaa xadi king no Jiu? Giem tii lasi xan xadaxada ta tsila lapalaa nan selina ma giem ga xaalame ngali langaari laa sin.” ");
INSERT INTO ncf_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Biaa King Erot ta alongmen abala, ga suk lolbiir ma no inaman in Jerusalem bula. ");
INSERT INTO ncf_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Biaa ta se ilei axumuli xadi no lalaamua ina no unsausawit ma no unaasasing ina lo, ga tiiriki di, “Itaa di ba taana aia Karisito?” ");
INSERT INTO ncf_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Di xisi, “Tile Betliem, lalon prowins Judaia, amuina propet tii se atalaa, ");
INSERT INTO ncf_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘Oro iu, Betliem, lalon pula Judaia, u suk xap mangutngut mu labatina no lalaamua in Judaia, amuina xaal sin iu xariin lalaamua naba ta bet tsuul sin iu, iwaa naba tsap untilaamamil sin nugu no inaman Israel.’” ");
INSERT INTO ncf_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mil Erot ga ilei axuina no unsinaae ngali atik axaautsi sen leng so xadaxada tii asemat. ");
INSERT INTO ncf_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ga tulen di laa Betliem, ma ga we, “Gim laa ma gim na nanen axaau ngali aia madalak, nawe gim se tatanginai, gim na le asaait alengi iaa ngali iaa ba laa langaari bula sin.” ");
INSERT INTO ncf_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mulina di ta se alongen King, di suk es laa ma iwaa xadaxada, di ta lasi nan selina, asuk laamuangen di pupua sin ta tilwat lapalaa papan abia xolot iwaa madalak ta manman lalon. ");
INSERT INTO ncf_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Biaa di tii lasi xadaxada, di suk taton buxa. ");
INSERT INTO ncf_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Di tsiga lalon anua, di ga lasi aia madalak mii xan nagaa Maria, ma di ga sage putput ma langaari laa sin. Di ga tsalali xadi no tinabel, biaa no iliil ina ta xaale lapalaa buxa, ma di ga tali no laa sin Iesu, goul, ma no maarang ta suk tso mamainaang (di ta putsangi parenkinsens ma mar). ");
INSERT INTO ncf_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Moroaa asaait alengi di lalon binalang ngali di na xap mula laa sangan Erot, di ga suk amusili sal xaatsap laa sin xadi inaman labalaba. ");
INSERT INTO ncf_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Biaa detuu se laa, xan angelo Orong asemat sin Josep lalon binalang. Ga paare weaatala, “Tapaas, giwaa madalak mii xan nagaa ma gutuu na sol laa Igip. Manman atia pupua sin iaa ba ta asaaiti iu. Sinsa Erot naba tsalei aila madalak ngali sas amantei.” ");
INSERT INTO ncf_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josep a tapaas, giwaa madalak ma xan nagaa nan abia bing ma detuu ga tapaas laa Igip. ");
INSERT INTO ncf_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Detuu ga manman atia laa pupua sin xan minet Erot. Ma ga atsapngen senaara Orong ta paatinai sin propet ga we, “Iaa ilei atsuulngi nugu tsi xaal Igip.” ");
INSERT INTO ncf_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Biaa Erot ta se nanxilalaa malen no unsinaae di tii apanaai ia, a suk magaa buxa, ma ga tali papaare watwat ngali di na sas amantei no tsi taamat dokdok araraa in Betliem biaa xadi no miet ta lua o paina, ta apuaa laa sin abia leng no unsinaae di tii asaaiti. ");
INSERT INTO ncf_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Biaa xan sen totore propet Jeremaia, a se tsap so: ");
INSERT INTO ncf_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Iexa ine biaa di ta alongmen Rama, tineng ma lolbiir, Rakel ta teng ngali xan no tsi ma ga palo ngali di na axorongi sin xan tineng, amuina xan no tsi di se met.” ");
INSERT INTO ncf_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mil sin Erot ta se met, iexa ina xan no angelo Orong asemat lalon binalang sin Josep tia Igip, ");
INSERT INTO ncf_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ma ga paare, “Tapaas giwaa tsi mii xan nagaa ma gim na laa lalon pula Israel, amuina biaa di, di ta xonon ngali sas amantei aia tsi di se met.” ");
INSERT INTO ncf_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Biaabi Josep ga tapaas, giwaa tsi mii xan nagaa ma di ga laa lalon pula Israel. ");
INSERT INTO ncf_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Oro biaa ta longmien malen Akelas a se tsap king tia Judaia, ta adi niaan xalkale sin xan mom, ilaa Erot, asuk mataa ngali laa atia. Moroaa tii se atewaai ia lalon binalang ngali es laa lalon prowins Galili, ");
INSERT INTO ncf_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ma ga man lalon inaman laba Nasaret. O ga se tsap so abia papaare no propet di tii paatinai ti tsaa, “Di ba putsangi ia Taan Nasaret.” ");
INSERT INTO ncf_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Sin abia no leng Jon Unaaxaxadaan a xaalame ngali baais lalon xolot biil ina Judaia, ");
INSERT INTO ncf_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ma ga papaare, “Puxisbal amuina Maradaan in Balalangit a se atat.” ");
INSERT INTO ncf_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ilawaa mu aila propet Aisaia ta papaare taman, “Inan xa a ililei lalon xobel biil, ‘Taxaaturungi xan sal Orong, xosaraa xan sal na tutiik.’ ” ");
INSERT INTO ncf_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Xan no uga Jon, di xosaraa taman no ulina kemal, ma xan biaal ulti balan di xosaraa taman xilkil ina matauteng. Xan luxaal no tsik ma daan ina matsii in lauteng. ");
INSERT INTO ncf_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","No inaman in Jerusalem ma no xolot araraa Judaia ma no prowins araraa in Jodan, di ga tsuul laa sangan ia. ");
INSERT INTO ncf_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ma di ga paare leng taman xadi no namaang tsaxa ma ga axadaani di lalon daansel Jodan. ");
INSERT INTO ncf_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Oro biaa ta lasi no daan Paarasi ma no Saadusi di ta xaalame sin abia xolot ta lo axaxadaan tia, ga paare ngali di, “Gim xan no tsi, no tsitsi tsaxa! Saa atewaai gim ngali sol sin xan minagaa Moroaa, biaa naba ta laa xaalame? ");
INSERT INTO ncf_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Gim na waalii xaa waawaan axaau ngali asen we, gim se puxisbal. ");
INSERT INTO ncf_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ma gim nangaam adodo we, gim pupua ngali paare sin gim tsaa, Abaram ia nagiem mom. Iaa asaaiti gim, xaal sin abala no xaat Moroaa a pupua ngali atsapngen xakaa tsi Abaram. ");
INSERT INTO ncf_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Xula a se taxaaturung muina no ie. Ma nawe no sen ie araraa di xap waalii xaa waawaan axaau, naba tal lii ma naa lii laangen lalon ie. ");
INSERT INTO ncf_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Iaa axadaani gim taman daan ngali puxisbal, oro mulina iaa iwaa xa, awatwat buxa ngen iaa. Iaa xap pupua ngali atsaxei xan no bubut. Naba axadaani gim taman Nantanua Pat, ma taman ie. ");
INSERT INTO ncf_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Xan pok biaa se papan no liman, ngali exasenlii no pinpin ina wit ma naba rii axaautsi xolot ina saali no pinpin ina wit, ma axumuli abia no wit laa lalon anuen atuturung ma na axaii abia no pinpin lalon abia ie, ta xap pupua ngali met.” ");
INSERT INTO ncf_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mil Iesu ga es xaal Galili ga laa lalon daansel Jodan ngalibi Jon naba axadaani. ");
INSERT INTO ncf_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Oro Jon a xonon ngali tilbanti ia ga we, “A pupua ngali u ba axadaani iaa, o ngalisa u ga xaalame sangaaga?” ");
INSERT INTO ncf_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Iesu ga xisi, “Papaalii na se weaatia atalaa; A axaau ngali gita na xosaraa abala, ngali taxaa puaa no namaang ta tutiik araraa.” Ma Jon ga sirawaa. ");
INSERT INTO ncf_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Biaa Jon tii axadaani araraai Iesu, a es tsuul lalon daan, sin abia xolot ina leng, balalangit asuk tsalel, ma ga lasi Nantanuan Moroaa tii soriri xaal lapalaa malen buna ma tii ga tsila papan ia. ");
INSERT INTO ncf_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ma ine xaal balalangit ga paare, “Ilawaa nugu Tsi, iwaa iaa ta titii buxaai; nugu tubudaan a manman papan ia.” ");
INSERT INTO ncf_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Mil Nantanua ga laamuangen Iesu laa lalon xobel biil ngali Saatan naba xonon. ");
INSERT INTO ncf_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Iesu a el no sangaul aet ina no leng ma bing, o mil ga suk itol. ");
INSERT INTO ncf_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Iwaa unxonkonon xa a xaalame sangan ga paare, “Nawe iu xan Tsi Moroaa, u na asaaiti abala no xaat ngali di ba tsap tsoki.” ");
INSERT INTO ncf_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Iesu ga xisi, “Di se atalaa, ‘Taamat a xap tino sin tsoki mu, oro a tino sin no totore araraa ta xaal sin ngutsina Moroaa.’ ” ");
INSERT INTO ncf_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mil iwaa Saatan ga giwaa Iesu laa lalon inaman laba pat, ma ga atilngi lapalaa suk se ina Xan Anua Moroaa. ");
INSERT INTO ncf_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","A paare, “Nawe iu xan Tsi Moroaa, u na rik laa lapula amuina di atalaa: “ ‘Naba paare watwat sin xan no angelo ngali tilaamamil sin iu, ma di ba tsiil tsaali iu taman no liman di. Ngalibi u ba xap tigen no xaiim sin xa xaat.’ ” ");
INSERT INTO ncf_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Iesu ga xisi ia, “Di atalaa weaatalaa bula: ‘Nangaam tali Orong num Moroaa sin xonkonon.’ ” ");
INSERT INTO ncf_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Iwaa Saatan a sebula giwaa Iesu laa lapalaa suk se papan buk, ma ga asen no maradaan araraa ina xolkolmoxo ma xadi no matmirmir. ");
INSERT INTO ncf_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Balawaa no maarang araraa, iaa ba tali no susum, nawe u ba sage putput ma langaari sin iaa.” ");
INSERT INTO ncf_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Iesu ga paare sin ia, “Soltia sin iaa Saatan! Di atalaa, ‘U na langaari laa sin Orong iwaa num Moroaa, ma u na lolong amusili ia xasinge mu.’ ” ");
INSERT INTO ncf_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Mil Saatan ga papaalii ia, o no angelo di ga le tilaamamil sin. ");
INSERT INTO ncf_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Biaa Iesu ta alongen we di se tali Jon lalon anua lodo, asuk mula laa Galili. ");
INSERT INTO ncf_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ga poroklii Nasaret; ga laa manman Kaperanaam sin gelgel ina daan ulis lalon xan xolot Sebulon ma Neptali, ");
INSERT INTO ncf_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ngali taxaa puaa biaa totore propet Aisaia tii paatina, ");
INSERT INTO ncf_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Pula ina Sebulon ma pula ina Neptali, biaa sal laa laman amusili gelgel ina Jodan, Galili xadi no Gentail, ");
INSERT INTO ncf_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","biaa inaman di ta manman lalon lodo di se lasi xaraxin rarar; papan abia di, di ta manman lalon maliip ina minet, rarar bia ta se tampanek.” ");
INSERT INTO ncf_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Sin abia xolot ina leng laa, Iesu atiltsoli ngali baais we, “Gim puxisbal, amuina Maradaan in Balalangit a se atat.” ");
INSERT INTO ncf_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Biaa Iesu ta lo eses sin gelgel ina daan ulis Galili, a lasi lo masen turamasen ilaa Saimon ta putsangi Pita, mii xan taamat Endru. Delu no untsunolau, ma delu lo liilii uben lalon daan ulis. ");
INSERT INTO ncf_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Iesu ga we, “Gulu xaalame amusili iaa ngali iaa ba asingan gululu taman tsunolau ngali giwaa no inaman.” ");
INSERT INTO ncf_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tiwaa tsaa, delu papaalii xadelu no uben ma delu ga amusili ia. ");
INSERT INTO ncf_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","A es laa tsaa, ga lasi biexaa lo masen turamasen sebula, ilaa Jeims ma Jon, xan no tsi Sebedi. Delu lo taxaaturungi xadetu no uben mii xadelu mom, ilaa Sebedi, papan mono o Iesu ga ilei delulu. ");
INSERT INTO ncf_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tiwaa tsaa delu ga papaalii mono ma xadelu mom ma delu ga amusili ia. ");
INSERT INTO ncf_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iesu ga laa lalon no xolot araraa Galili ma ga asingan di lalon xadi no anua sausawit ma ga babaais taman inesaait mamainaang ina maradaan ma ga atoaa no maramase ma biaa di ta isua met. ");
INSERT INTO ncf_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Inesaait ina Iesu asuk puaa araraai Siria, ma no inaman di ga le tali biaa di, di ta maramase taman no mat laxen minet. Biexaal taman no xaraxin sosong, biexaal no salawa tsaxa di tsigaii di. Biexaal di gogo ma no isua met ma ga atoaa di. ");
INSERT INTO ncf_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Xaraxin malep in Galili, Dekapolis, Jerusalem, Judaia ma biaa no xolot tabaxi daansel Jodan di ga amusili ia. ");
INSERT INTO ncf_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Biaa ta lasi abia malep, asuk laa lapalaa sin gelgel ina buk ma ga tsotso lapula. Xan no tsi asasing di xaalame sangan, ");
INSERT INTO ncf_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ma ga atiltsoli ngali asingan di ga we, ");
INSERT INTO ncf_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Atatoni abia di, di ta muun sin nantanua, amuina biaa Maradaan balalangit xadi. ");
INSERT INTO ncf_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Atatoni, biaa di, di ta lolbiir, di ba axorongi di. ");
INSERT INTO ncf_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Atatoni, biaa di, di ta adokdoki di, Di ba tapkina balan pula. ");
INSERT INTO ncf_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Atatoni biaa di, di ta itol ma marua ngali namaang ta tutiik, ngali Moroaa naba amaaslen di. ");
INSERT INTO ncf_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Atatoni biaa no unbiirbirum, ngali Moroaa naba asen biirbirum sin di. ");
INSERT INTO ncf_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Atatoni biaa xadi no butsa ta mixat, ngali di ba lasi Moroaa. ");
INSERT INTO ncf_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Atatoni abia no unmalina, ngali di ba putsangi di xan no tsi Moroaa. ");
INSERT INTO ncf_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Atatoni abia no inaman, biaa biexaal di ta tali xirabas sin di amuina ngali namaang tutiik, sinsa xadi Maradaan abia in balalangit. ");
INSERT INTO ncf_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Atatoni abia gim, no inaman di ta reret ngen gim, xosaraa xirabas sin gim ma lii no mat totore morokon papan gim amuina sin iaa. ");
INSERT INTO ncf_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Gim na paalam ma resres, amuina nagim xariin iliil made balalangit. Aweaatia mu malen di tii xosaraa xirabas sin no propet in ti laamua. ");
INSERT INTO ncf_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Gim no tes ina balan pula. Oro nawe biaa tes a se tamsi, naba xap xontes bula, naba sen xontes mula we? Naba se xap axaau ngali xawas bula oro di ba se silelii ma no inaman di ba bubut papan. ");
INSERT INTO ncf_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Gim xalaleng ina no inaman araraa ina xolkolmoxo. Xa inaman laba papan pu buk dokdok a xap pupua ngali xuxii. ");
INSERT INTO ncf_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","O no inaman di xap arar laam di ga aturungi paina xa xiis. Di ba ataxiwaa laam ngali tali laleng sin no inaman araraa lalon anua. ");
INSERT INTO ncf_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Sin abia uk sal mu, gim na atsilaa nagim no rarar labatina no inaman, ngali di ba lasi nagim no namaang axaau ma di ba paʼii nagim Mom in balalangit. ");
INSERT INTO ncf_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Gim nangaam adodo we iaa xaalame ngali saali lo o no propet. A xap, iaa xap xaalame ngali saali no, oro ngali taxaawiti no. ");
INSERT INTO ncf_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Iaa asaaiti gim taman so, balalangit ma balan pula naba xaapina, oro a xap xa pu inaatel dokdok ina lo sin no sen mat laxen xoror naba pupua ngali saali xa xolot ina, til sin no mat maarang araraa naba ta xap. ");
INSERT INTO ncf_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nawe xa alaxei xa lo dokdok buxa o ga asingan biexaal ngali xosaraa malen ia, di ba putsangi we ia adokdok buxa lalon Maradaan ina balalangit. Oro saa ia ta amusili ma ga asingan biexaal taman no lo, di ba putsangi we ia a lot lalon Maradaan ina balalangit. ");
INSERT INTO ncf_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Iaa asaaiti gim, nawe nagim ina tutiik a xap axaau buxa ngen no Paarasi o no unaasasing ina lo, gim ba xap tsiga lalon xan Maradaan balalangit. ");
INSERT INTO ncf_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Gim se alongen tsaa we di tii se asaaiti no inaman ti tsaa, ‘Nangaam sas amantei xa ma iwaa xa ta sas amantei xa, naba til nan ininte.’ ");
INSERT INTO ncf_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Oro iaa asaaiti gim we, nawe xa asuk magaa ngali xan taamat, naba til nan ininte. Nawe xa a lii no papaare tsaxa, di ba atilngi ia laamuaan Sanidrin. Nawe xa a paare, ‘Iu tangtangabaa,’ naba man lalon xariin mamaet ina ie Edes. ");
INSERT INTO ncf_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Biaabi nawe u saan ngali aturungi num tinabel papan ibe tsutsungit o u ga adodomi num taamat ta magaa mii iu, ");
INSERT INTO ncf_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","papaalii num tinabel laamuaan ibe tsutsungit ma u na laa xosaraa malina mii aia num taamat, mil u na mula ngali tali num tinabel sin Moroaa. ");
INSERT INTO ncf_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Atutiki isagaalen mamaet mii num matenkorot iwaa naba ta tali iu laamuaan unininte. U na xosaraa abala, biaa u ta manman tsaa mii nan sal. Naba soro tali iu sin unininte, o naba tali iu laa sin unxoxo, ma na lii iu lalon anua lodo. ");
INSERT INTO ncf_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Iaa asaaiti iu so, u ba xap tsuul pupua u ba ta lii araraai num nen xapkap ina toia. ");
INSERT INTO ncf_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Gim se alongmen we, ‘Nangaam xosaraa namaang tsaxa ngali matul mii xa u ta xap maxis sin.’ ");
INSERT INTO ncf_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Oro iaa asaaiti gim we, saa ia ta mataxaaxaa ngali xa aina a se xosaraa namaang tsaxa tsaa lalon xan butsa mii ia. ");
INSERT INTO ncf_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nawe mataam mua a taii iu laa sin namaang tsaxa. U na luapelii ma u na pipidi taman. Axaau ngali xa xolot ina isuaam u na xitiplii ngen no isuaam araraa na laa lalon Edes. ");
INSERT INTO ncf_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","O nawe num lima mua a taii iu laa sin namaang tsaxa. Xitiplii ma u na pipidi taman. Axaau ngali xa xolot ina no isuaam u na xitiplii ngen no isuaam araraa na laa lalon Edes. ");
INSERT INTO ncf_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Di se asaait taman we, ‘Saa ia ta atsiplii xan tubu na tali xa lawin perper sin xan tubu ngali asaait leng we a se atsiplii ia.’ ");
INSERT INTO ncf_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Oro iaa asaaiti gim, nawe xa atsiplii xan tubu biaa sin ta suk so sin ia, a se xosaraa ia ngali tsap malen xa ta se matul mii xa ta xap xan maxis, Ma nawe xa a maxis sin xa aina, xan maxis ta atsiplii, a se malen xa taamat iwaa tii se matul mii aina ta xap xan tubu. ");
INSERT INTO ncf_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Gim sebula longmien senaara di tii paatinai sin no inaman ti tsaa, ‘Gim nangaam laxei nagim no xuxubu ina waawaalima, oro gim na taxaariiti abia xuxubu ina waawaa lima gim ta xosaraa mii Orong.’ ");
INSERT INTO ncf_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Oro iaa asaaiti gim, gim nangaam waawaa lima laa balalangit, amuina biaa balalangit xan muina xalkale Moroaa, ");
INSERT INTO ncf_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ma na xap waawaa lima xaalame papan pula, amuina balawaa pula xan niaan xutxutsiil, ma na xap waawaa lima laa Jerusalem, amuina xadi inaman laba no Xariin King. ");
INSERT INTO ncf_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ma nangaam puris papan xuaam tsaa, amuina gim xap pupua ngali xosaraa xa ul na xuuk na pudi o pun. ");
INSERT INTO ncf_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Biaa mu gim na paare leng mu malen ‘Iou’ na ‘Iou’, o num ‘A xap’ na ‘A xap.’ No sen papaare mulina balawaa no totore axaal sin Saatan. ");
INSERT INTO ncf_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Gim se longmien malen di tii paare, ‘Matan ngali matan, ma lian ngali lian.’ ");
INSERT INTO ncf_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Oro iaa asaaiti gim, nangaam sas mulangen xa taamat morokon. Nawe xa atabaiʼi iu sin mua ina paapas, u na puxis tali biexa paapasen iu bula. ");
INSERT INTO ncf_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","O nawe xa a we na tali iu lalon ininte ngali adi num uga disdis, tali bula num uga disdis sin. ");
INSERT INTO ncf_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nawe xa atuaai iu ngali es mii sin kilomita ta xuuk, es laa mii sin xaa kilomita na lua. ");
INSERT INTO ncf_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tali sin iwaa xa ta ningi iu, ma gim nangaam taaltalu sin iwaa xa ta we na xiba sin iu. ");
INSERT INTO ncf_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Gim se alongmen biaa di ta se asaait, ‘Titii turaam atataaen iu ma ngutsulen num matenkorot.’ ");
INSERT INTO ncf_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Oro iaa asaaiti gim, gim na titii nagim no matenkorot, ma sawit ngali biaa di, di ta xosaraa no xirabas sin gim, ");
INSERT INTO ncf_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ngali gim ba tsap xan no tsi nagim Mom tade balalangit. A xosaraa xan pal ga tsila papan no untsaxa ma no inaman axaau, ma a tulen langit ngali no untutiik ma no inaman di ta xap tutiik. ");
INSERT INTO ncf_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nawe gim titii biaa mu di, di ta titii gim, sen iliil gim ba adi? No unaalalet taakis di xap xoxosaraa abia namaang? ");
INSERT INTO ncf_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ma nawe gim suei mu no turumasen gim, gim xosaraa sa tsaa bula ngen biexaal? Asen parawe no muun taltaalnge di xap xoxosaraa bula abia? ");
INSERT INTO ncf_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Gim na tutiik malen nagim Mom bula balalangit ta tutiik. ");
INSERT INTO ncf_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Gim na tilaamamil, gim na xap xosaraa nagim no namaang tutiik lalon no matan no inaman ngali di ba lasi. Nawe gim ba xosaraa weaatia, naba xap nagim xa xixiis sin nagim Mom balalangit. ");
INSERT INTO ncf_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Biaa u ta tabali no muun, u nangaam xuina tail ngali asaait leng taman malen no xalam lua di ta xaa xosaraa lalon anua sausawit, ma lalon no sal, ngali no inaman di ba manglen di. Iaa asaaiti gim taman so, di se alet araraai xadi no xixiis. ");
INSERT INTO ncf_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Oro biaa u ta tabali no muun, u nangaam poroklii num lima xaiaar na atii semaarang num lima mua ta xosaraa, ");
INSERT INTO ncf_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ngali biaa num no tinabel naba xuxii no, ngalibi num Mom iwaa ta xaa lasi semaarang u ta xosor axuina naba tabiel xisi sin iu. ");
INSERT INTO ncf_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ma biaa gim ta sausawit, gim nangaam malen no xalam lua, amuina di saan ngali til sausawit lalon no anua sausawit ma lalon no tsigur ina sal ngali no inaman di ba lasi di. Iaa asaaiti gim taman so, di se adi araraai xadi no xixiis. ");
INSERT INTO ncf_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Oro biaa u ta saan ngali sausawit, u na tsiga laa naanua, tsaxali num mat ma u na sawit laa sin num Mom, iwaa u ta xap pupua ngali lasi. Mil num Mom iwaa ta lasi sawe u ta xaa xosor axuina naba tali xa xixiis sin iu, ");
INSERT INTO ncf_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ma biaa gim ta sausawit gim nangaam ngurnguruk malen no muun taltaalnge; amuina di adodo we di ba longmien di taman xadi no papaare ta xuduxudu. ");
INSERT INTO ncf_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Gim nangaam malen di, amuina nagim Mom a se atii tsaa semaarang gim ta saansilii sin, sin gim ta xap mager atsuraa. ");
INSERT INTO ncf_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Balawaa se gim ba ta sawit sen we, “ ‘Nagiem Mom in balalangit, iesaam a pat, ");
INSERT INTO ncf_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","num maradaan na xaalame, num sirsiir giem ba xosor puaa lalon balan pula malen tia balalangit, ");
INSERT INTO ncf_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","U na tabali giem taman tsoki sin no leng xuxuuk. ");
INSERT INTO ncf_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Adodolii nagiem no namaang tsaxa, malen giem bula giem ta se adodolii xadi no namaang tsaxa biexaal, ");
INSERT INTO ncf_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","nangaam laamuangen giem lalon xonkonon, oro gii mulangen giem sin aia morokon.’ ");
INSERT INTO ncf_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Amuina nawe gim adodolii xadi no namaang tsaxa no inaman di ta xosaraa sin gim, nagim Mom in balalangit naba adodolii nagim no namaang tsaxa bula. ");
INSERT INTO ncf_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Oro nawe gim xap adodolii xadi no namaang tsaxa no inaman, nagim Mom naba xap adodolii nagim no namaang tsaxa. ");
INSERT INTO ncf_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Biaa gim ta el, gim nangaam mat birawis malen no xalam lua di ta xaa xosaraa, di xaa mata xixiin ngali asen sin no inaman malen di el. Iaa asaaiti gim taman so, di se adi araraai xadi no xixiis. ");
INSERT INTO ncf_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Oro biaa u ta el, u na patsaa xuaam taman wel ma u na silii no mataam, ");
INSERT INTO ncf_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","sinsa no inaman di ba xap nen xilalaa malen u el, oro num Mom mu iwaa u ta xap lasi, ma num Mom iwaa ta xaa lasi no maarang u ta xosor axuina no, naba tali num xixiis. ");
INSERT INTO ncf_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Gim nangaam axumuli nagim xaa maarang axaau lalon abala balan pula, biaa no ibaiba ma ros naba ta xosor atsoti, ma biaa no unpulapula di ba ta baxi anua ngali pulaxi no. ");
INSERT INTO ncf_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Oro, gim na axumuli nagim xaa maarang axaau tsaa tade balalangit. No ibaiba ma ros naba xap atsoti, ma no unpulapula di ba xap baxi anua ma di na pulaxi. ");
INSERT INTO ncf_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Amuina sen xolot u aturungi num no mat maarang axaau lalon, num butsa bula naba manman sin abia xolot. ");
INSERT INTO ncf_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Biaa no mataam, biaa laam ina isua. Nawe no mataam axaau, no isuaam araraa naba suk us taman laleng. ");
INSERT INTO ncf_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Oro nawe no mataam morokon, isuaam araraa naba us taman lodo. Nawe biaa laleng lalon iu a lodo, biaa lodo naba lot buxa. ");
INSERT INTO ncf_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“A xap xa na pupua ngali taxaa paina xaa manmanel na lua. U ba ngutsulen iexa o u ba titii iexa, o u ba lolong amusili iexa o u ba palolii iexa. Gim ba xap pupua ngali taxaa sin Moroaa ma xuxute bula. ");
INSERT INTO ncf_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Biaabi iaa ga asaaiti gim, gim nangaam lolbiir ngali nagim tino, sawe ngali ngani o nunngi, o ngali no isuaam, sawe gim ba alen. Tino a lot buxa ngen luxaal, ma biaa isua a lot buxa ngen uga? ");
INSERT INTO ncf_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Gim na lasi no maan nan wang, di xap soksok o tatat o axumuli luxaal laa lalon anuen atuturung. Oro nagim Mom tsaa in balalangit a tamtabali di. Moroaa adodo aloti gim buxa ngen no maan. ");
INSERT INTO ncf_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Saa ina gim sin xan lolbiir a pupua ngali asumaa xa pu xolot ina leng na xuuk sin xan tino? ");
INSERT INTO ncf_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“O ngalisa gim ta lolbiir ngali no uga? Gim na lasi no nanaal in lauteng di ta tsik, di xap taktaxaa o xaili sua. ");
INSERT INTO ncf_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Oro iaa asaaiti gim, sin xan matmirmir Solomon, tii xap pupua ngali amatmirmiri no isuaan ngen abala no nanaal. ");
INSERT INTO ncf_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nawe Moroaa amatmirmiri no palis in lauteng weaatia, biaa ta man atalaawaa o nowa di lii lalon ie. Moroaa naba pupua ngali alen gim. Nagim tinaalnge asuk dokdok buxa. ");
INSERT INTO ncf_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Lowas, gim nangaam lolbiir buxa ngali paare, ‘Giem ba se ngani sa?’ o ‘Giem ba se nunngi sa?’ o ‘Giem ba se alen sa?’ ");
INSERT INTO ncf_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","No muun taltaalnge di sol amusili abala no daan mat maarang, ma nagim Mom in balalangit, atii we, gim muun ngali abia no. ");
INSERT INTO ncf_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Oro, gim na tsalei xan maradaan setauan ma xan namaang tutiik, ngali naba tali balawaa no mat maarang araraa sin gim bula. ");
INSERT INTO ncf_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Biaabi gim nangaam lolbiir ngali nowa, amuina nowa naba lolbiir ngali ia tsaa. No leng xuxuuk a ie xirabas pupua ngali ia tsaa. ");
INSERT INTO ncf_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Gim nangaam atuti biexaal o Moroaa naba atuti gim bula. ");
INSERT INTO ncf_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sin sen namaang gim ta xosaraa sin biexaal, Moroaa naba xosaraa sin gim bula. Sin sen sal gim ta ininte sin biexaal, Moroaa naba ininte sin gim bula. ");
INSERT INTO ncf_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Ngalisa u ta lolbiir ngali pu ro ina ie lalon matan num taamat, biaa u ta xap adodomi abia xoltin ie lalon mataam tsaa? ");
INSERT INTO ncf_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","U ba sen adodo we ngali paare sin num taamat, ‘Tali ina tiltsomi iu ngali saali pu ro ina xoltin ie alen mataam,’ biaa u ta xap pupua ngali lasi mulina abia xoltin ie lalon mataam? ");
INSERT INTO ncf_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Iu nan xalam lua. U na setauan saali xoltin ie alen mataam tsaa, mil u ba pupua ngali nan axaautsi ngali saali pu ro alen matan num taamat. ");
INSERT INTO ncf_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Gim nangaam tabali no xapuna taman sawe ta pat; gim nangaam lii nagim no xatuul ina gem sin no bol. Nawe gim xosor wenangen atia, di ba pupua ngali xutsali no paina no xaden di, o mil di na tater adokdoki gim. ");
INSERT INTO ncf_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Gim na lo atsutsura, ma gim ba adi. Gim na lo tsatsel, ma gim ba tatanginai. Gim na lo pipidi ngali mat naba tsalel sin gim. ");
INSERT INTO ncf_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Amuina no inaman araraa di ta atsura, di ba adi, iwaa xa ta tsatsel, naba tatanginai, ma iwaa xa ta pipidi, Moroaa naba tsalali mat ngali di. ");
INSERT INTO ncf_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Saa ina gim, nawe xan tsi atsuraa ngali xa tsoki, u ba tali xa xaat sin? ");
INSERT INTO ncf_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O nawe atsuraa ngali xa xoo, u ba tali tsitsi sin? A suk xap! ");
INSERT INTO ncf_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Biaabi nawe gim no untsaxa, gim atii ngali tali xaa tinabel axaau sin nagim no tsi, aisa tsaa biaa nagim Mom balalangit naba tabiel taman no tinabel axaau sin di, di ta ningi ia! ");
INSERT INTO ncf_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Gim na xosaraa namaang axaau sin biexaal, malen gim ta saan ngali di na xosaraa namaang axaau sin gim. Balawaa asuk atsapngen abia lo ma asasing ina no propet. ");
INSERT INTO ncf_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Gim tsiga lalon abia mat dokdok. Sinsa biaa sal ngali laa sin minet asuk tsalel buxa ma asuk lot buxa biaa ta laa lalon xirabas ma no daan inaman di tsiga lalon abia sal. ");
INSERT INTO ncf_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Oro balawaa mat ina tino asuk dokdok buxa ma biaa sal asuk lalep buxa ngali amusili. Nen taamat di ta xap xudu mu di ba tsal tatanginai. ");
INSERT INTO ncf_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Gim na tilaamamil sin no propet daraxe. Di xaalame adamis sangan gim taman laplap ina no sipsip, oro lalon di, di no xapunakok ngaangaal in lauteng. ");
INSERT INTO ncf_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Gim pupua ngali nen xilalaa di sin xadi no waawaan, biaa xadi no namaang ta asen. A pupua ngali no inaman di ba paaski no greip sin no xoxon, o no taa sin no kuikui? ");
INSERT INTO ncf_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Malen mu, ie axaau a xaa waalii no waawaan axaau. Oro ie morokon a xaa waalii no waawaan morokon. ");
INSERT INTO ncf_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ie axaau asuk xap pupua ngali waalii xaa waawaan morokon, o xa ie morokon asuk xap pupua ngali waalii xaa waawaan axaau. ");
INSERT INTO ncf_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Biaabi no ie ta waalii no waan tsaxa, di ba tal lii laa lapula di na lii lalon ie lelep. ");
INSERT INTO ncf_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Iou, malen mu u ta xilalaa ie sin xan no waawaan, biaabi gim ba pupua ngali nen xilalaa no inaman sin xadi no namaang. ");
INSERT INTO ncf_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“A xap no inaman araraa di ta putsangi iaa, ‘Orong, Orong,’ di ba tsiga lalon maradaan ina balalangit, oro iwaa mu ta amusili xan sirsiir nugu Mom ta manman balalangit naba tsiga. ");
INSERT INTO ncf_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Sin abia leng ina ininte, xuduxudu di ba papaare ngali iaa, ‘Orong, Orong! Giem tii baais taman iesaam ma giem tii saali no salawa taman iesaam ma xosaraa no daan axixila xoror taman iesaam.’ ");
INSERT INTO ncf_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Oro iaa ba asaait axaautsi di, ‘Iaa suk xap atii gim, gim sol tia, gim no unlaklaxei lo!’ ");
INSERT INTO ncf_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Biaabi, nawe xa alongmen ma ga amilpuaa nugu no asasing a sinaae malen aia taamat ta tumaraa xan anua papan atkale. ");
INSERT INTO ncf_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Langit a xaalame, no daansel auus ma maal ga tigen anua, ma biaa anua ga xap xol tsaa, amuina axosngi awatwati no tutur papan atkale. ");
INSERT INTO ncf_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Oro nawe xa alongmen abala no totore ma ga xap amilpuaa nugu no asasing ia tangtangabaa a malen aia taamat ta tumaraa xan anua papan xenken. ");
INSERT INTO ncf_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Langit a xaalame, no daansel auus, ma maal ga tigen anua ma ga suk xol ma tabek tsaxa.” ");
INSERT INTO ncf_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Biaa Iesu ta se araraai xan no totore, biaa xumul di suk tunga sin xan no asasing, ");
INSERT INTO ncf_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","amuina asingan di taman banam so ma a xap malen xadi no unaasasing ina lo. ");
INSERT INTO ncf_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Biaa Iesu ta tsuul xaal papan gelgel ina buk, xariin malep di ga amusili ia, ");
INSERT INTO ncf_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","iexa taamat taman minet basbas a xaalame ga le sage putput sangan Iesu ga we “Orong, nawe u siir, u pupua ngali auuli iaa.” ");
INSERT INTO ncf_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iesu a tulsen liman ma ga taana aia taamat ga we, “Iaa siir! U na tuo!” Tiwaa tsaa xan minet basbas asuk maraamen. ");
INSERT INTO ncf_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Iesu ga asaaiti, “Nangaam asaaiti xa. Oro u na laa asen iu tsaa sin unsausawit ma u na tali num tinabel malen Moses ta paare watwat taman. Balawaabi biaa papaare leng sin no inaman araraa malen u se tuo.” ");
INSERT INTO ncf_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Biaa Iesu ta se mula laa Kaperanaam, o iexa lalaamua ina no unmakmaxil ga xaalame sangan ia, ga ningi ia ngali tiltsomi. ");
INSERT INTO ncf_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Orong, nugu untutule ilei naanua ta matul taman xan no tuen ta met ma ga taana xariin sosong.” ");
INSERT INTO ncf_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Iesu a paare, “Iaa ba xaalame ngali atoaa ia.” ");
INSERT INTO ncf_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Oro lalaamua ina no unmakmaxil a paare, “Orong, iaa xap taamat axaau buxa ngali u ba xaalame lalon nugu anua. U na paatinai mu totore ngali nugu untutule naba tuo. ");
INSERT INTO ncf_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Iaa atii abala amuina iaa manman paina xan banam nugu xariin lalaamua ina unmakmaxil ma iaa ie banam patanginai nugu no unmakmaxil. Iaa mu ngali paatinai we, ‘Laa’ o di ga laa, ‘xaalame’, o di ga xaalame. Ma nawe iaa paare sin nugu untutule, ‘xosaraa abala,’ di ga xosaraa.” ");
INSERT INTO ncf_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Biaa Iesu ta alongmen abala asuk olol, ga putsi laa sin abia di, di ta amusili ia, ga paare, “Iaa asaaiti gim taman so, iaa xap lasi xa tinaalnge malen abala lalon no Israel araraa! ");
INSERT INTO ncf_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ma iaa ga asaaiti gim taman abala, biaa no Gentail araraa di ba xaal sin no xolot araraa xaal nan selina, ma nan no tudaan, ma ngali xalkale mii Abaram, Aisak ma Jakop sin xan xariin luxaal lalon Maradaan ina balalangit. ");
INSERT INTO ncf_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Oro xuduxudu ina no tsi in Israel, biaa di Moroaa ta taxaaturungi abia Maradaan ngali di, Moroaa naba lii atsuulngi di lokobel lalon lodo xating, di ba tengteng ma angiririki no lian di.” ");
INSERT INTO ncf_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Iesu a paare ngali aia lalaamua in Rom, “Mula laa lokobel. Amuina u taltaalnge, naba se tsap.” Ma xan untutule a se tuo sin abia aua. ");
INSERT INTO ncf_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Biaa Iesu ta tsiga laa lalon xan anua Pita ma ga lasi xan xoxup aina Pita ta matmatuul papan ibe ta maramase taman isua lalep. ");
INSERT INTO ncf_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","A taana liman o biaa isua lalep ga suk papaalii ia, ma ga taxaaturungi luxaal ngali ia. ");
INSERT INTO ncf_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Biaa ta se nale bingbing, xuduxudu ina di, no salawa tsaxa di tsigaii di, di ga le tali di sin ia ma ga saali no tanua tsaxa taman totore ma ga atoaa xadi no maramase araraa. ");
INSERT INTO ncf_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Balawaa maarang a tsap ngali taxaawiti xan totore propet Aisaia tii papaare taman: “Tii adi xida no minet tsaxa sin gita ma ga atsaxei xida no maramase.” ");
INSERT INTO ncf_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Biaa Iesu ta lasi abia malep ulti ia, asuk paare watwat sin xan no tsi asasing ngali di ba tabaxi daan laa sin biexa gelgel xaatalaa ina daan ulis mii ia. ");
INSERT INTO ncf_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mil iexa unaasasing ina lo a xaalame sangan ma ga we, “Unaasasing iaa ba amusili iu sin no xolot araraa u ba ta laa sin.” ");
INSERT INTO ncf_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Iesu a xisi, “No xapunakok di ie mat ma no maan, di ie uni, oro xan Tsi Taamat a xap xaka xolot ngali atetei xuan.” ");
INSERT INTO ncf_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Iexa tsi asasing asaaiti ia, “Orong, u na setauan poroklii iaa ngali iaa ba laa punami nugu mom.” ");
INSERT INTO ncf_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Oro Iesu ga asaaiti ia, “Amusili iaa, ma u na poroklii no minet di na punami xadi no minet tsaa.” ");
INSERT INTO ncf_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Mil Iesu ga pis papan mono ma xan no tsi asasing di ga amusili ia. ");
INSERT INTO ncf_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Sauna mu xariin maal ga tapaas lalon daan ulis, ma no tuun ga xapas tsiga lalon mono, oro Iesu ga urange. ");
INSERT INTO ncf_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","No tsi asasing di laa ma apadaa Iesu, di ga we, “Orong, tiltsomi gita! Gita ba se liaan!” ");
INSERT INTO ncf_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Iesu a xisi di, “Nagim tinaalnge a dokdok, ngalisa gim ga suk mataa buxa?” Mil ga tapaas ma ga imii maal ma no tuun, ma ga suk malina araraa. ");
INSERT INTO ncf_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","No tsi asasing di suk olol ma di tiirik engen di, “Sen mat laxen taamat aila? Maal ma no tuun di ga lolong amusili mu ia.” ");
INSERT INTO ncf_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Biaa ta se tsap sin biexa gelgel lalon xobel ina Gedaranes, lo taamat salawa tsaxa ta tsigaii delulu, delu ta xaal lalon no lia pupuna delu ga le sabasue ia. Delu suk ngong tsaxa o biaa no inaman araraa di ga mataa buxa ngali esliu lalon abia sal. ");
INSERT INTO ncf_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Di xuup, “U wena xosaraa sa sin giem, Xan Tsi Moroaa? U xaalame ngali xosaraa atsoti giem setauan sin nagiem leng biaa Moroaa naba ta ininte sin giem?” ");
INSERT INTO ncf_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Biexa xobel bol a man palpalaa dokdok di tii angangen. ");
INSERT INTO ncf_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","No salawa tsaxa di ningi awatwati Iesu, “Nawe u tulen a tsuulngi giem, tulen giem laa sin no bol.” ");
INSERT INTO ncf_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Iesu a paare sin di, “Laa!” O di ga tsuul ma tsigaii no bol. Ma di araraa di ga esole laa lapula sin gelgel ina buk laa lalon daan ulis ma di ga suk met lalon daan. ");
INSERT INTO ncf_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Biaa no untilaamamil sin no bol di sol laa lalon inaman laba di ga asaait taman abala no maarang ma samaarang ta tsap sin abia lo taamat no salawa tsaxa di ta tsigaii delulu. ");
INSERT INTO ncf_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mil biaa inaman laba araraa di tsuul xaalame ngali le sabasue Iesu. Ma biaa di ta le lasi ia, di ningi awatwati ia ngali na papaalii xadi xobel. ");
INSERT INTO ncf_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iesu a pis papan mono o ga tabaxi daan ulis ma ga mula xaalame lalon xan inaman laba tsaa. ");
INSERT INTO ncf_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Biexaa inaman di giwaa iexa taamat no isuaan ta met laa sangan Iesu, di ta atetei papan xabangas. Biaa ta lasi xadi tinaalnge, ga paare ngali aia taamat no isuaan ta met, “U na taton nugu tsi, iaa se adodolii num no namaang tsaxa.” ");
INSERT INTO ncf_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Sin abia, biexaal ina no unaasasing ina lo, di paare sin di tsaa, “Ilawaa taamat a reret ngen Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Iesu atixi xadi no adodo ga we, “Ngalisa gim ta ie adodo morokon lalon nagim no butsa? ");
INSERT INTO ncf_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Sawe a malus ngen ngali paare taman, ‘Num no namaang tsaxa, iaa se adodolii,’ o ngali we, ‘Tapaas ma u na eses?’ ");
INSERT INTO ncf_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Oro ngali u ba atii we, xan Tsi Taamat a ie banam lalon xolkolmoxo ngali adodolii namaang tsaxa.” Mil Iesu ga asaaiti aia taamat isua met, “Tapaas adi num xabangas ma u na laa tataam.” ");
INSERT INTO ncf_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Iwaa taamat a tapaas ma ga laa tatan. ");
INSERT INTO ncf_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Biaa malep di ta lasi abia, di suk olol ma mataa ma paʼii Moroaa, iwaa ta se tali balawaa mat laxen banam sin no taamat. ");
INSERT INTO ncf_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Biaa Iesu ta tapaas atia, a lasi iexa taamat iesan ila Metiu ta xalkale lalon anuen taakis, ga asaaiti, “Amusili iaa.” O Metiu ga tapaas ma amusili Iesu. ");
INSERT INTO ncf_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mil Iesu mii xan no tsi asasing di angen lalon xan anua Metiu mii no unaalalet taakis ma biexaa no untsaxa bula. ");
INSERT INTO ncf_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Biaa no Paarasi di ta lasi abala, di suk atsuraa xan no tsi asasing, “Ngalisa nagim unaasasing ta angen mii no unaalalet taakis ma no untsaxa?” ");
INSERT INTO ncf_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Iesu ga alongen di ga we, “No taamat di ta maramase, di ba lasi dokta, ma a xap abia di, di ta tino axaau. ");
INSERT INTO ncf_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Oro gim na laa asasing ngali atii sen muina abala, ‘Iaa saan ngali gim na asen biirbirum, a xap tsutsungit.’ Iaa xap xaalame ngali ilei no inaman tutiik, oro iaa xaalame ngali ilei no untsaxa.” ");
INSERT INTO ncf_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Mil xan no tsi asasing Jon di ga xaalame ngali atsuraa Iesu, “Ngalisa giem mii no Paarasi giem ta xaa el o num no tsi asasing di ga xap el?” ");
INSERT INTO ncf_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Iesu a xisi, “No turan aia taamat ta maxis uul di xap pupua ngali lolbiir amuina a manman tsaa mii di. Leng biaa naba xaalame di ba ta gii alen ia sangan di, mil di ba el. ");
INSERT INTO ncf_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“A xap xa na xaa tsik xaili pu laplap uul sin laplap xabaar. Biaa pu laplap naba tater alen laplap ma na atsapngen xariin tater. ");
INSERT INTO ncf_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","O a xap xa na xaa titirii waain uul lalon xilkil xabaar ina waain. Nawe di ba xosaraa weaatia biaa xilkil naba pak, ma biaa waain naba suk rue tsuul ma biaa xilkil ina waain naba se tsaxa. Waain uul di xaa titirii lalon xilkil uul ngali waain ma xan xilkil naba man adis tsaa.” ");
INSERT INTO ncf_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iesu a papaare tsaa, o lalaamua ga xaalame ga le sage putput laamuaan ia ga we, “Nugu tsaana talaawaa mu a met. Oro xaalame u na aturungi limaam papan ngali naba tino.” ");
INSERT INTO ncf_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iesu a tapaas ga laa mii ia, mii xan no tsi asasing. ");
INSERT INTO ncf_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mil mu o iexa aina ta ie nanxaskas sin sangaul axuuk ma ga laa lua ina no miet, amusili ia o ga taana barangutsina xan uga disdis. ");
INSERT INTO ncf_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","A paare ngali ia tsaa, “Nawe iaa ba taana mu xan uga disdis, iaa ba tuo.” ");
INSERT INTO ncf_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Iesu a putsi ga suk lasi ia ga we, “U na taton nugu tsaana, num tinaalnge a se atoaa iu.” Tiwaa tsaa iwaa aina asuk tuo. ");
INSERT INTO ncf_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Iesu a es tsiga lalon xan anua aia lalaamua ga lasi abia no inaman di ta xuxuina no piut taman no tso tengteng ma xariin ngangaarare sin abia malep, ");
INSERT INTO ncf_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","a paare, “Gim sol tia; iwaa tsaana a xap met oro a urange mu.” Oro di ga nongen ia. ");
INSERT INTO ncf_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mulina abia malep di ta tulen atsuulngi di laa lokobel, atsiga ga taana liman aia tsaana o ga tapaas. ");
INSERT INTO ncf_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Inesaait ina abala maarang a suk sol laa lalon no xolot araraa. ");
INSERT INTO ncf_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Biaa Iesu ta tapaas atia laa, lo matababa delu ga amusili ia, ma delu ga ilei, “Xan Tsi Dewit tali biirbirum sin gelulu!” ");
INSERT INTO ncf_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Biaa Iesu ta se laa naanua, lo matababa delu xaalame sangan ia, ma ga atsuraa delulu, “Gulu taltaalnge we iaa pupua ngali xosaraa abala?” Delu xisi, “Iou, Orong.” ");
INSERT INTO ncf_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Mil ga taana no matan delulu ga we, “Sin nugululu tinaalnge mu, balawaa naba tsap sin gululu.” ");
INSERT INTO ncf_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ma delu ga pupua ngali nanen, Iesu ga suk paare watwat sin delulu, “Xa na suk xap atii abala maarang ta tsap sin gululu.” ");
INSERT INTO ncf_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Oro delu ga laa asaait taman abala sin no xobel araraa. ");
INSERT INTO ncf_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Biaa delulu ta lo tsuultsuul, iexa taamat salawa tsaxa a tsigaii ga xap pupua ngali papaare, di le tali sin Iesu. ");
INSERT INTO ncf_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","O biaa Iesu ta se saali aia salawa tsaxa iwaa taamat ta ben bong asuk papaare. Biaa malep di suk taton ma di ga we, “A xap xa mat maarang weaatala ti, di na lasi Israel.” ");
INSERT INTO ncf_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Oro no Paarasi di ga we, “Sin xan tsi lalaamua ina no salawa ga saali no salawa.” ");
INSERT INTO ncf_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iesu a tsigaii no inaman laba ma no xobel, ga asingan di lalon xadi no anua sausawit, ta babaais taman inesaait mamainaang ina Maradaan ma atotoaa no mat laxen minet araraa. ");
INSERT INTO ncf_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Biaa ta lasi abia malep, asuk ie biirbirum sin di, amuina xariin xirabas atsap sin di ma ga xap xa ngali tiltsomi di, di malen no sipsip ta xap xadi xa untilaamamil. ");
INSERT INTO ncf_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Mil ga paare sin xan no tsi asasing, “No daan luxaal ngali tatat a se malisa oro no untinaxaa di xap xudu. ");
INSERT INTO ncf_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ningi Orong ina tatat luxaal ngali naba tulenlii xaa untinaxaa laangen lalon uma ina tatat.” ");
INSERT INTO ncf_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iesu a ilei sangaul ma ga laa lua ina xan no tsi asasing xaalame sangan, ga tali banam sin di, ngali saali no tanua tsaxa ma ngali atoaa no mat laxen minet araraa. ");
INSERT INTO ncf_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Balawaa no iesan abia sangaul ma ga laa lua ina no aposal, lalaamua, ilaa Saimon (iwaa di ta putsangi Pita) ma turamasen Endru, Jeims xan tsi Sebedi, ma turamasen, Jon; ");
INSERT INTO ncf_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip ma Batalomiu, Tomas ma Metiu iwaa unaalalet taakis, Jeims xan tsi Alpias ma Tadeas; ");
INSERT INTO ncf_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon iwaa Silot ma Judas Iskariot iwaa tii tali Iesu sin no matenkorot. ");
INSERT INTO ncf_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Biaa sangaul ma ga laa lua Iesu tii tulen di taman no totore inanaa weaatala, “Gim nangaam laa labatina no Gentail o tsigaii xa inaman laba xadi no Samaria. ");
INSERT INTO ncf_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Gim laa labatina abia no sipsip in Israel di ta xaapina. ");
INSERT INTO ncf_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Biaa gim ta laa, baais taman abala inesaait, ‘Xan Maradaan balalangit a se atat.’ ");
INSERT INTO ncf_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Atoaa no maramase, atapaasi no minet, auuli abia no taamat ta ie basbas, saali no salawa. Gim se adi gomsaai, gim na tabiel gomsaa. ");
INSERT INTO ncf_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Gim nangaam adi xaa pu goul o silwa o kopa lalon nagim no biaal. ");
INSERT INTO ncf_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Gim nangaam adi nagim xaa tutuel ngali eses sin nagim ines, o nagim xaa pu uga bula o nagim xaa bubut o xudak ngali eses. ");
INSERT INTO ncf_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Sen inaman laba o xobel gim ta tsiga lalon gim na nanen ngali xaa inaman axaau ngali gim ba manman mii di pupua sin gim ba ta poroklii di. ");
INSERT INTO ncf_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Biaa gim ta tsiga lalon xa anua, tali tubudaan ina malina sin di. ");
INSERT INTO ncf_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nawe biaa matenaanua di axaau, poroklii malum na manman mii di, nawe di xap axaau, papaalii malum na mula laa sin gim. ");
INSERT INTO ncf_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nawe xa a xap suei atatoni gim o a xap lolong sin nagim no totore, gim na panlii kuku sin no xaden gim biaa gim ta tapaas poroklii abia anua o inaman laba. ");
INSERT INTO ncf_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Iaa asaaiti gim taman so naba suk axaau buxa ngali Sodom ma Gomoraa sin abia leng ina ininte ngen abia inaman laba. ");
INSERT INTO ncf_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Iaa tulen gim laa malen no sipsip labatina no xapunakok in lauteng. Biaabi gim na suk sinaae malen no tsitsi ma gim na leiwaa malen no buna. ");
INSERT INTO ncf_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Gim na tilaamamil sin no taamat, di ba ta tali gim sin no kaunsel in lokobel ma di na ririiti gim lalon xadi anua sausawit. ");
INSERT INTO ncf_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Amuina sin nugu namaang mu di ba atilngi gim laamuaan no gawana ma no king ngali gim ba tiltsoxoti di ma sin no Gentail. ");
INSERT INTO ncf_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Oro biaa di ba ta tsiili gim nangaam lolbiir, ngali sawe gim ba ta paare taman, o gim ba sen paare we. Sin abia aua, Nantanua Pat naba tali no totore sin gim ngali paare. ");
INSERT INTO ncf_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Amuina gim ba xap papaare oro Nantanuan nagim Mom naba papaare lalon gim. ");
INSERT INTO ncf_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Turumasen naba babel tali xan taamat tsaa laa sin minet, ma mom laa sin xan tsi, no tsixi di ba tsiil susuei sin xadi no mom ma nagaa ma di na sas amantei di. ");
INSERT INTO ncf_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","No inaman araraa di ba ngutsulen gim amuina sin iaa. Oro iwaa ta til watwat pupua sin xapkap naba tuo. ");
INSERT INTO ncf_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nawe di tali xirabas sin gim, sin xa xobel, sol laa sin biexa. Iaa asaaiti gim taman so, gim ba xap mager araraai no inaman laba in Israel setauan sin Xan Tsi Taamat naba ta xaalame. ");
INSERT INTO ncf_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Tsi asasing a xap lapalaa ngen xan unaasasing, o xa untutule a xap lapalaa bula ngen xan manmanel. ");
INSERT INTO ncf_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","No tsi asasing di arie pupua mii xadi no unaasasing, ma no untutule di arie pupua mii xadi no manmanel. Nawe lalaamua ina anua, di putsangi ia Belsabap, di ba putsangi abia di, no saa lalon abia xan anua? ");
INSERT INTO ncf_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Biaabi gim nangaam mataa sin abia di, no mat laxen maarang araraa di ta baaii, no inaman araraa di ba lasi ma no maarang ta xuxii, no inaman araraa di ba atii. ");
INSERT INTO ncf_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Sawe iaa ta asaaiti gim taman lalon lodo, gim na paare lalon leng taman. Sawe iaa ta buriik taman lalon talingaam, gim na baais taman papan unga ina anua. ");
INSERT INTO ncf_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Nangaam mataatinai abia di, di ba ta sas amantei isua, oro di xap pupua ngali sas amantei nantanua tuo. A suk lot buxa ngali, mataatinai iwaa naba ta xosor atsoti nantanua tuo ma isua lalon Edes. ");
INSERT INTO ncf_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","No tsitsiripaxa ta lua di uuli taman nan toia ta xuuk. Oro a xap xa ina di naba xol papan pula ma na met, oro sin xan sirsiir nagim Mom. ");
INSERT INTO ncf_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ma biaa bula no ul papan no xuan gim, Moroaa a se xoxoti no. ");
INSERT INTO ncf_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Biaabi gim na xap mataa; gim lot buxa ngen no tsitsiripaxa ta xudu. ");
INSERT INTO ncf_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Saa ia ta asaait leng taman iaa labatina no inaman, iaa bula iaa ba asaait leng taman ia lalon no matan nugu Mom balalangit. ");
INSERT INTO ncf_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Oro saa ia ta palolii iaa nan no matan no inaman, iaa bula iaa ba palolii ia nan no matan nugu Mom balalangit. ");
INSERT INTO ncf_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Gim nangaam adodo we iaa se xaalame ngali tali malina lalon balan pula. Iaa xap xaalame ngali tali malina, oro iaa le tali pubat. ");
INSERT INTO ncf_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Amuina iaa se xaalame ngali putsi, “‘Taamat naba epuske mii xan mom, tsaana naba epuske mii xan nagaa, aina minaxis naba epuske mii xan iaaiaa aina, ");
INSERT INTO ncf_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","xan no matenkorot taamat di ba xaal lalon abia matenaanua tsaa.’ ");
INSERT INTO ncf_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Saa ia ta titii buxaai xan mom o xan nagaa ngen iaa, a xap axaau buxa sin iaa; saa ia ta titii buxaai xan tsi o xan tsaana ngen iaa, a xap axaau buxa sin iaa, ");
INSERT INTO ncf_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ma saa ia ta xap adi xan tongol ma na amusili iaa, a xap axaau buxa sin iaa. ");
INSERT INTO ncf_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Saa ia ta tsalei xan tino naba xosorlii xan tino, ma saa ia ta xosorlii xan tino ngali iaa, naba tatanginai xan tino. ");
INSERT INTO ncf_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Saa ia ta suei atatoni gim a suei atatoni iaa bula, ma saa ia ta suei atatoni iaa, a suei atatoni iwaa ta tulen iaa. ");
INSERT INTO ncf_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Saa ia ta suei atatoni xa propet amuina ia propet naba tsiili iliil ina propet ma saa ia ta suei atatoni xa untutiik amuina sin ia untutiik naba tsiili iliil ina untutiik. ");
INSERT INTO ncf_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ma nawe xa a tali xa sobuk daan madil sin xa ina abala di ta dokdok amuina ia nugu tsi asasing, iaa asaaiti gim taman so, naba adi tsaa xan iliil.” ");
INSERT INTO ncf_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Mulina Iesu ta se xap sin asingan xan no sangaul ma ga laa lua ina tsi asasing, a laa atia ngali asingan ma baais lalon no inaman laba Gaalili. ");
INSERT INTO ncf_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Biaa Jon ta manman lalon anua lodo ga alongen sawe Karisito ta xosaraa, ga tulen xan no tsi asasing ");
INSERT INTO ncf_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ngali atsuraa ia, “Iu mu iwaa, no propet di ta we naba xaalame? O giem na liliis ngali xa tsaa?” ");
INSERT INTO ncf_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Iesu a xisi, “Gim mula, gim na asaaiti Jon taman no sen mat maarang gim ta alongmen ma lasi: ");
INSERT INTO ncf_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","no matababa di se nanen, no xadak met di se eses, biaa no taamat di ta ie basbas di se tsap uul. No talingaban di se lolong, biaa di, di ta se met di sebula tapaas mula ma biaa inesaait mamainaang di baais taman laa sin no muunwas. ");
INSERT INTO ncf_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Moroaa naba atubudaani abia di, di ta xap xol papaalii iaa ngali semaarang iaa ta xosaraa.” ");
INSERT INTO ncf_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Biaa xan no tsi asasing Jon, di es papaalii, Iesu ga paare sin abia no malep taman Jon: “Gim tii laa lalon xobel biil ngali lasi saa? Gim tii laa ngali lasi palis maal ta maalen? ");
INSERT INTO ncf_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nawe a xap, gim tii laa ngali lasi saa? Taamat ta taxaamirmir taman no uga disdis? A xap, biaa no inaman di ta xaa taxaamirmir axaau di xaa manman lalon xan xobel king. ");
INSERT INTO ncf_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Oro gim suk laa ngali lasi saa? Xa propet? Iou, iaa asaaiti gim, asuk buxa ngen propet. ");
INSERT INTO ncf_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ilawaa se aila xa propet di ta atatal taman: “ ‘Iaa ba tulen nugu ngutsu laamuangen iu iwaa naba ta taxaaturungi num sal laamuangen iu.’ ");
INSERT INTO ncf_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Iaa asaaiti gim taman so, labatina biaa no aina, di ta taxaa tsi, a xap xa na xaalame lapalaa malen Jon unaaxaxadaan, oro aso iwaa ta dokdok buxa lalon xan Maradaan in balalangit, a lot buxa ngen ia. ");
INSERT INTO ncf_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Atiltsoli sin xan no leng Jon unaaxaxadaan pupua talaawaa, Maradaan in balalangit alet sosong ina namaang tsaxa ma no inaman tsaxa di ga sas ngali epuske mii. ");
INSERT INTO ncf_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","“Amuina no propet araraa ma lo di tii se paare leng taman abala maradaan pupua sin Jon. ");
INSERT INTO ncf_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ma nawe nagim sirsiir ngali sirawaa, ia Elaija mu iwaa naba ta xaalame. ");
INSERT INTO ncf_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Saa ia ta ie no talinga, na lolong. ");
INSERT INTO ncf_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Sin sen maarang iaa ba puaa abala utmilmil? Di malen no tsi dokdok di ta tsotso lalon xolot ina sune ma di ga lo ililei sin biexaal. ");
INSERT INTO ncf_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“ ‘Giem sar taman piut ngali gim, ma gim ga xap tiili, giem anaanngi iexa tso tengteng, ma gim tii ga xap lolbiir.’ ");
INSERT INTO ncf_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Amuina Jon a xap xaalame ngali angen o ngali nun ma di paare we ‘A ie salawa tsaxa.’ ");
INSERT INTO ncf_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Xan Tsi taamat tii xaalame ngali angangen ma nunun ma di ga paare, ‘Ilawaa tsaam metmet ma ungogo, turan no unaalalet taakis ma no untsaxa.’ Oro nawe xa a ie sinaae sin Moroaa xan namaang tutiik naba asen so.” ");
INSERT INTO ncf_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Mil Iesu ga atiltsoli ngali atuti no inaman laba, biaa tii xosaraa xan no daan axixila, amuina di tii xap puxisbal. ");
INSERT INTO ncf_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Xaraxin xirabas naba tatanginai gim, Korasin! Xariin xirabas naba tatanginai gim, Betasaida! Nawe biaa no axixila xoror iaa ta xosaraa sin gim, di nii xosaraa no Taia ma Sidon, di nii se puxisbal setauan tsaa lalon no pu laplap tsaxa ma pit. ");
INSERT INTO ncf_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Oro iaa asaaiti gim, sin leng ina ininte, no inaman in Taia ma Sidon, di ba tsap axaau buxa ngen gim. ");
INSERT INTO ncf_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Ma gim Kaperanaam, Moroaa naba alet laangen gim tade balalangit ngaa? A xap, gim ba laa Edes. Nawe biaa no axixila xoror iaa nii xosaraa sin gim, biaa di tii xosaraa no Sodom, nii ba manman tsaa, sin abala no leng. ");
INSERT INTO ncf_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Oro iaa asaaiti gim, sin leng ina ininte no inaman in Sodom di ba tsap axaau buxa ngen gim.” ");
INSERT INTO ncf_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Sin abia leng Iesu a paare, “Iaa paʼii Mom, Orong ina balalangit ma balan pula, amuina sin u ta se axuina balawaa no maarang sin no unsinaae ma no unaasasing ma u ga asen no sin no tsi dokdok. ");
INSERT INTO ncf_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Iou Mom, amuina u ta taton buxa ngali xosaraa weaatalaa. ");
INSERT INTO ncf_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Balawaa no maarang araraa nugu Mom tii se tali no sin iaa, ma a xap xa na atii xan tsi, oro xan Mom mu, ma a xap xa na atii Mom oro xan tsi mu ma biaa di xan tsi ta sirawaa di, ngali asen ia. ");
INSERT INTO ncf_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Gim xaalame sin iaa, biaa gim araraa, gim ta se maluaai ma gim ga alet mamaxet, ngali iaa ba aiaawisi gim. ");
INSERT INTO ncf_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Gim adi nugu tunuru laa papan gim ma gim na asasing sin iaa, amuina nugu butsa a mangmagus ma a mangmangle xa, ma gim ba tatanginai iaawis ngali nagim no nantanua tuo. ");
INSERT INTO ncf_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Amuina nugu tunuru a malus mu ngali amusili ma nugu inaalet a malolo mu.” ");
INSERT INTO ncf_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sin abia xolot ina leng, Iesu mii xan no tsi asasing di es liu lalon uma wit sin Saabat. Xan no tsi asasing di itol ma di ga paaski no waan ina wit di ga ngani no. ");
INSERT INTO ncf_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Biaa no Paarasi di ta lasi abia, di paare ngali Iesu, “Lasi, num no tsi asasing di xosaraa abala maarang, di ta laxei lo ina Saabat.” ");
INSERT INTO ncf_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","A xisi, “Gim tii xap xoxoti samaarang Dewit tii xosaraa mii xan no turan biaa di tii itol? ");
INSERT INTO ncf_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","A tsiga lalon Xan Anua Moroaa ma ia mii abia xan no turan di ga ngani abia tsoki pat, biaa ta laxei lo amuina biaa tsoki pat xadi no unsausawit mu ma Moroaa ga xap adodo we, maarang di ta xosaraa, a xap tutiik. ");
INSERT INTO ncf_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Gim xap xoxoti lalon Lo, we no unsausawit araraa, di taktaxaa sin Saabat lalon Xan Anua Moroaa, biaabi nawe di tsolaa atsoti, di ba xap til lalon ininte? ");
INSERT INTO ncf_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Iaa asaaiti gim, iexa ia ta suk lot ngen abala Xan Anua Moroaa ila. ");
INSERT INTO ncf_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nawe gim nii atii muina ina abala totore, ‘Iaa saan ngali biirbirum buxa ngen tsutsungit,’ gim nii xap atutali tsaxa sin nugu no tsi asasing di ta tutiik. ");
INSERT INTO ncf_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Sinsa xan Tsi Taamat ia Orong ina Saabat.” ");
INSERT INTO ncf_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iesu a poroklii abia xolot, ga laa tsiga lalon xadi anua sausawit no Jiu. ");
INSERT INTO ncf_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ma iexa taamat liman ta met a manman bula. Biexaa Paarasi di nanen ngali xa sal ngali atuti Iesu, di ga atsuraa ia, “A tutiik ngali atoaa xa sin Saabat?” ");
INSERT INTO ncf_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","A paare sin di, “Nawe xa ina gim xaka sipsip a rik lalon lis sin Saabat, gim ba xap logo atsuulngi ia? ");
INSERT INTO ncf_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","No inaman di lot buxa ngen sipsip, biaabi ga tutiik ngali xosaraa namaang tutiik sin Saabat.” ");
INSERT INTO ncf_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Mil Iesu ga asaaiti aia taamat, “Apalasaa limaam.” Mil ga apalasaa liman ma ga suk tsap uul ma ga suk axaau malen biexaal. ");
INSERT INTO ncf_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Oro no Paarasi di ga tsuul ma di ga ngiti ngali tsalei xa sal ngali sas amantei Iesu. ");
INSERT INTO ncf_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Iesu a se atii we no Paarasi di se ngiti ngali sas amantei ia o tii ga se papaalii abia xolot. Xuduxudu ina inaman di amusili ia. O ga atoaa xadi no maramase araraa, ");
INSERT INTO ncf_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ga atewaai di ngali di na xap asaaiti xaal taman sawe ta xosaraa. ");
INSERT INTO ncf_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Biaabi xan xuxubu Moroaa ga taxaa puaa malen propet Aisaia tii paare. ");
INSERT INTO ncf_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ilawaa se nugu untutule, iaa ta axilangi, iaa ta titii buxaai, ma ga atatoni iaa. Iaa ba tali Nantanuaaga sin ia, ma naba, asaait leng taman ininte tutiik lalon no inaman labalaba. ");
INSERT INTO ncf_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Naba xap engangaae o xuup, ma naba xap xa na alongen inan lalon no sal. ");
INSERT INTO ncf_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Naba xap tabaxi xa pu paas tsaxa, o xuu pusi xa pu ie ngali naba met, pupua naba ta tali ininte tutiik ngali paapok. ");
INSERT INTO ncf_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Sin iesan mu, no inaman labalaba di ba aturungi xadi no tinaalnge sin.” ");
INSERT INTO ncf_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mil di ga le tali iexa taamat salawa tsaxa ta tsigaii ma ta matababa ma ngusbong o Iesu ga atoaa ia ga pupua ngali paare ma lasi no maarang. ");
INSERT INTO ncf_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","No inaman araraa di tunga di ga we, “Ilawaa se xan tsi Dewit?” ");
INSERT INTO ncf_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Oro biaa no Paarasi di ta alongmen abala di ga paare, “Sin Belsabap mu iwaa lalaamua ina no salawa tsaxa, ilawaa taamat ga saali no salawa tsaxa.” ");
INSERT INTO ncf_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Iesu a se atii xadi no adodo o ga paare sin di, “No Maradaan araraa di ba epuske mii di tsaa, ma naba tsaalen ma no inaman laba araraa o no anua xuxuuk di ba epuske mii di tsaa ma naba xap man. ");
INSERT INTO ncf_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nawe Saatan a saali Saatan a xap turangen ia tsaa, balawaa xan maradaan naba sen maan we? ");
INSERT INTO ncf_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ma nawe iaa saali no salawa tsaxa sin xan xoror Belsabap, sin saa num no inaman di saali di? Biaabi di ba tsap malen num no unininte. ");
INSERT INTO ncf_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Oro nawe iaa saali no salawa tsaxa taman Nantanuan Moroaa, biaa xan Maradaan Moroaa a se xaalame papan gim. ");
INSERT INTO ncf_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Xa naba sen pupua we ngali tsiga lalon xan anua aila taamat watwat ma na atsaxei atsuulngi xan no mat maarang? Naba setauan pis aturungi iwaa taamat watwat mil na pulaxi xan no mat maarang. ");
INSERT INTO ncf_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Saa ia ta xap manman mii iaa a epuske mii iaa, ma iwaa xa ta xap man etudim mii iaa a palaaen iaa. ");
INSERT INTO ncf_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Biaabi iaa ga asaaiti gim, no namaang tsaxa araraa ma no papaare tsaxa taman biexaal di ba adodolii no, oro no papaare reret ngali Nantanua naba xap adodolii no. ");
INSERT INTO ncf_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Saa ia ta paare taman xa totore ngali epuske mii xan tsi taamat naba adodolii, oro nawe xa a paare epuske ngali Nantanua Pat, Moroaa naba xap adodolii di, sin abala nan ul ma sin abalaa nan ul naba ta xaalame. ");
INSERT INTO ncf_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Gim putsangi xa ie axaau ma xan no waawaan naba axaau o gim putsangi xa ie a tsaxa ma xan no waawaan naba tsaxa, amuina ie gim nen xilalaa sin xan no waawaan. ");
INSERT INTO ncf_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Gim no tsitsi dokdok tsaxa, asen parawe gim ta tsaxa mu o gim xap pupua ngali paatinai no maarang axaau. Amuina ngus naba paatinai samaarang butsa ta us taman. ");
INSERT INTO ncf_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Iwaa taamat axaau, a xaa tali no maarang axaau, ina abia axaau ta manman lalon ia, o taamat morokon, a xaa tali no maarang morokon, ina abia morokon ta manman lalon ia. ");
INSERT INTO ncf_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Oro iaa we ina asaaiti gim, no inaman araraa di ba tali xadi no iliil xuxuuk sin leng ina ininte ngali no totore gomsaa di tii paare taman. ");
INSERT INTO ncf_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Amuina sin num no totore di ba inten iu we, u tutiik, ma sin num no totore mu di ba atutali mamaet sin iu.” ");
INSERT INTO ncf_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Biexaa Paarasi ma biexaa unaasasing ina lo di paare ngali Iesu, “Unaasasing giem saan ngali lasi xa axixila xoror xaal sin iu.” ");
INSERT INTO ncf_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","A xisi, “Ilawaa nan ul tsaxa, gim man palaaen Moroaa malen biaa di, di ta matmatuul mii no inaman di ta xap maxis sin di, di atsuraa ngali xa axixila xoror. Oro naba xap xa axixila ngali tali, oro axixila mu ina propet Jonaa. ");
INSERT INTO ncf_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Malen Jonaa tii man a tuul no siaat ma a tuul no bing lalon balan xaraxin xoo, biaabi xan Tsi Taamat naba man a tuul no siaat ma a tuul no bing lalon xan butsa pula. ");
INSERT INTO ncf_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“No inaman Niniwe di ba til lalon ininte mii balawaa ul ma di na atut tali mamaet papan abala nan ul; amuina di puxisbal sin xan babaais Jonaa, ma talaawaa iwaa ta lot buxa ngen Jonaa ila se. ");
INSERT INTO ncf_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Iwaa Kwin nan no paxel naba tapaas sin ininte mii balawaa ul ma na atut tali xan mamaet; amuina tii xaal sin xapkap ina pula ngali le longmien xan sinaae Solomon, o talaawaa iwaa ta lot buxa ngen Solomon ila se. ");
INSERT INTO ncf_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Nawe xa salawa tsaxa a tsuul alen xa taamat, a laa lalon no xolot ta pura ma ga tsal xolot ngali iaawis ma ga xap tatanginai xa. ");
INSERT INTO ncf_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Mil ga paare, ‘Iaa ba mula laa nan anua iaa tii papaalii.’ Biaa ta tsap, a xap tatanginai xaal nan anua, di tii rii lii no pun ma di ga aturung axaautsi no maarang lalon. ");
INSERT INTO ncf_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Mil ga tsuul ma ga laa giwaa apaasaalua ina biexaa salawa tsaxa di ta morokon buxa ngen ia tsaa, ma di ga tsiga ma man tia. Ma xan tino aia taamat ga suk tsaxa buxa ngen setauan. Balawaa naba tsap weaatia sin abala nan ul tsaxa.” ");
INSERT INTO ncf_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sin Iesu ta papaare tsaa mii abia malep, xan nagaa ma no turumasen di tiltil tsaa lokobel, di we di na papaare mii ia. ");
INSERT INTO ncf_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Xa ia ga asaaiti, “Num nagaa ma no turamasen iu balaa di ta tiltil lokobel ngali papaare mii iu.” ");
INSERT INTO ncf_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ga xisi ia, “Saa aia nugu nagaa ma no saa abia no turaagamasen?” ");
INSERT INTO ncf_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ga tulsi xan no tsi asasing ma ga paare, “Lasi, balawaa di, nugu no nagaa ma no turaagamasen. ");
INSERT INTO ncf_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Amuina iwaa xa ta xosor puaa xan sirsiir nugu Mom balalangit iwaa mu turaagamasen ma motogo ma nugu nagaa.” ");
INSERT INTO ncf_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Biaa leng tsaa Iesu a tsuul lalon anua ma ga laa xale sangan daan ulis. ");
INSERT INTO ncf_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Xaraxin malep di exumule ulti ia biaabi ga xaa papan mono ma ga laa tsotso papan, o no inaman di ga tiltil xuen. ");
INSERT INTO ncf_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mil ga asaaiti di taman no totore puapua, “Lolong, iexa unsoksok a laa soxaa xan no xalitsa. ");
INSERT INTO ncf_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Biaa ta lo xaaparen abia no xalitsa, biexaal a xol lalon sal o no maan di ga xaalame ma ngen araraai no ");
INSERT INTO ncf_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Biexaal a xol papan no xaat, biaa ta xap xa xariin pula. Atsik laa lapalaa isagaa amuina biaa pula a dokdok mu papan no xaat. ");
INSERT INTO ncf_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Oro biaa pal ta laa xaalame lapalaa, biaa no ta tsik di suk birawis ma met amuina di xap aturung baa. ");
INSERT INTO ncf_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Biexaa xalitsa di xol labatina no xoxon, biaa no xoxon di xail pataminai no ma amantei no. ");
INSERT INTO ncf_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Biexaal tsaa di xol papan pula mamainaang, ma di ga waalii no waan ie, biexaal sangsangaul axuuk o biexaal no sangaul a paas xuuk o biexaal no sangaul a tuul buxa ngen biaa ta soxaa. ");
INSERT INTO ncf_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Saa ia ta ie talinga na lolong.” ");
INSERT INTO ncf_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","No tsi asasing di xaalame sangan Iesu ma di ga atsuraa, “Ngalisa u ta papaare sin no inaman taman no totore puapua?” ");
INSERT INTO ncf_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Iesu a xisi, “Amuina Moroaa a se tali sinaae ina totore xuxii ina Maradaan ina balalangit sin gim, oro tii xap asen sin abala no inaman. ");
INSERT INTO ncf_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Saa ia ta se minaas, Moroaa naba taal buxaai sin ia, ngalibi naba ie minaas buxa oro saa ia ta xap iewas Moroaa naba saali no sen maarang biaa ta se taxaana. ");
INSERT INTO ncf_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Sin abia muina mu iaa ga papaare taman no totore puapua sin di. “Di nanen, aso di xap lasi; di alongmen, oro di xap lolong ma di xap leng. ");
INSERT INTO ncf_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Xan totore propet Aisaia a se taxaawiti sin di: “‘Gim ba tigiri alongmen, oro gim ba suk xap leng Gim ba tigiri lasi oro gim ba suk xap nen xilalaa xawas. ");
INSERT INTO ncf_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Amuina no balan abia no inaman naba se wat malen xaat; di xap pupua ngali lolong taman no talingan di ma di se aurangei no matan di. O di ba soro nanen taman no matan di, di ba soro lolong taman no talingan di, di ba soro leng taman xadi no butsa ma di naa puxisbal ma iaa ba atoaa di.’ ");
INSERT INTO ncf_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Oro atatoni no matan gim amuina di se nanen ma no talingan gim amuina di se lolong. ");
INSERT INTO ncf_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Iaa asaaiti gim taman so, xuduxudu ina no propet ma no inaman tutiik di titii buxaai lasi no maarang talaawaa gim ta lasi no, oro di tii xap lasi no ma longmien sawe u ta alongmen oro di xap alongmen no.” ");
INSERT INTO ncf_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Lolong, talaawaa gim ba alongmen muina totore puapua ina unsoksok. ");
INSERT INTO ncf_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nawe xa alongmen a abala inesaait mamainaang ina Maradaan ma ga xap leng sin, Saatan naba xaalame ma na saali sawe di ta se soxaa lalon no balan di. Ilawaa xalitsa a soxaa amusili sal. ");
INSERT INTO ncf_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ma xalitsa ta xol lalon pula ta ie xaat a malen xa ta alongmen totore ga adi isagaalen taman taton. ");
INSERT INTO ncf_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Oro amuina a xap ie baa, ga xap til adis. Biaa no mamaet o no xirabas ta xaalame amuina sin totore, di suk xol isagaa. ");
INSERT INTO ncf_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ma xalitsa ta xol labatina no xoxon a malen xa ta alongmen totore, ga lolbiir ngali no maarang ina abala tino o no daraxe ina minaas di amantei, balawaa no maarang axaili xan totore Moroaa, ga xap waalii xaa waawaan. ");
INSERT INTO ncf_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Oro ilawaa xalitsa ta xol papan pula mamainaang a malen xa ta alongmen totore ga leng sin o ga waalii no waawaan pupua malen sangsangaul xuuk o no sangaul a paas xuuk o no sangaul a tuul buxa ngen biaa ta soxaa.” ");
INSERT INTO ncf_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iesu asaaiti di taman biexa totore puapua: “Xan Maradaan Moroaa in balalangit, a malen xa taamat ta soxaa xalitsa axaau lalon xan uma. ");
INSERT INTO ncf_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Oro sin biexa bing no inaman araraa di ta urange xan matenkorot a xaalame ma ga soxaa no xalitsa ina palis tsaxa lolobet ina no wit ma ga laa. ");
INSERT INTO ncf_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mil biaa wit ga tsik ma ga waalii no waawaan o di ga lasi no palis tsaxa di ta tsik mii no. ");
INSERT INTO ncf_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Xan no untutule tapkina uma di xaalame sangan ma di ga paare, ‘Orong, giem sorowe, u tii soxaa no xalitsa axaau lalon num uma. Itaa axaal abala no palis tsaxa?’ ");
INSERT INTO ncf_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Tapkina uma a xisi di, ‘Iexa matenkorot a xosaraa abia namaang.’ “No untutule di atsuraa ia, ‘U saan ngali giem na laa ruplii no?’ ");
INSERT INTO ncf_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“A xisi, ‘A xap, amuina nawe gim ruplii no palis tsaxa gim ba soro ruplii no wit mii no. ");
INSERT INTO ncf_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Papaalii delu na arie tsik pupua sin leng ina tatat. Sin abia leng iaa ba asaaiti no untatat ngali di ba setauan axumuli no palis tsaxa ma rotsi no sin no poxo ngali axaii mil di na axumuli no wit ma alet laangen no lalon nugu anuen atuturung.’ ” ");
INSERT INTO ncf_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Asaaiti di taman biexa totore puapua, “Maradaan in balalangit a malen xa xalitsa ina tsupa, biaa taamat ta adi ma ga soxaa lalon xan uma. ");
INSERT INTO ncf_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Xalitsa ina tsupa asuk dokdok buxa ngen biexaal. Oro biaa ta tsik a malen ie lot lalon uma biaabi no maan di ta lo lapalaa di xaa le xosor uni papan xa no laxe.” ");
INSERT INTO ncf_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","A sebula asaait taman biexa totore puapua sin di, “Maradaan in balalangit a malen iis. Iexa aina a adi iis ga putsi mii palaua xan mamaxet a pupua malen no sangaul a tuul ina kilogram. Mil palaua araraa asuk pupuet.” ");
INSERT INTO ncf_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Balawaa no totore araraa Iesu ta paare taman sin abala malep, biaa no totore puapua. A xap alengi xa totore ina no sin no inaman. A xap, a asaait taman no totore puapua mu. ");
INSERT INTO ncf_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Biaabi ga taxaawiti sawe iexa propet ta paare taman: “Iaa ba paare taman no totore puapua. Iaa ba paare taman no mat maarang ta man xuxii sin atiltsoli ina xolkolmoxo.” ");
INSERT INTO ncf_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Apapaali abia malep o ga tsiga lalon anua o xan no tsi asasing di ga xaalame sangan di ga we, “U na alengi giem taman muina abala totore puapua ina palis tsaxa ta tsik lalon uma.” ");
INSERT INTO ncf_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","O Iesu ga xisi, “Iwaa taamat ta soxaa no xalitsa axaau, ia Xan Tsi Taamat. ");
INSERT INTO ncf_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Biaa uma balawaa xolkolmoxo ma biaa no xalitsa axaau a til axilangi no inaman lalon Maradaan, xan no palis tsaxa Saatan. ");
INSERT INTO ncf_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Iwaa matenkorot ta soxaa no xalitsa tsaxa, ia Saatan. Leng ina tatat, biaa xapkap ina xolkolmoxo, no untatat biaa no angelo. ");
INSERT INTO ncf_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Biaa no palis tsaxa di ta ruplii o di ga axaii no lalon ie a malen mu Moroaa naba ta xosaraa sin xapkap ina xolkolmoxo. ");
INSERT INTO ncf_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Xan Tsi Taamat naba tulen xan no angelo ngali di ba ruplii abia no mat maarang araraa lalon xan Maradaan biaa ta atsapngen namaang tsaxa ma no unlaklaxei lo araraa. ");
INSERT INTO ncf_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Di ba lii di lalon ie suaamsuaam ta suk les biaa di ba ta tengteng angiririki no lian di. ");
INSERT INTO ncf_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mil no untutiik di ba tsila malen pal lalon Maradaan sin xadi Mom. Saa ia ta ie talinga axaau na lolong. ");
INSERT INTO ncf_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Xan Maradaan balalangit a malen xariin tang buxa di tii axuina lalon uma. Biaa iexa taamat ta tatanginai, ga sebula axuina. Asuk taton buxa o ga laa sune taman xan no maarang araraa o ga laa uuli abia uma. ");
INSERT INTO ncf_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Xan Maradaan balalangit a sebula malen iexa unsusune ta tsatsel ngali no xatuul ina gem ta mat geramis. ");
INSERT INTO ncf_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Biaa ta tatanginai iexa xan iliil ta laa lapalaa buxa, a suk sol ma ga laa sune taman xan no maarang araraa ma ga laa uuli abia xatuul. ");
INSERT INTO ncf_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Iaa sebula paare, xan Maradaan balalangit a malen xe di ta atilngi lapula lalon daan ulis o ga saai no mat laxen xoo. ");
INSERT INTO ncf_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Mil xe ga us o no untsunulau di ga alet laangen xuen. Di ga tsotso ngali axumuli no xoo axaau lalon no xiis. Oro biaa no xo tsaxa di lii. ");
INSERT INTO ncf_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Naba weaatia sin xapkap ina xolkolmoxo. No angelo di ba xaalame ma di na exasen no untsaxa sin no untutiik. ");
INSERT INTO ncf_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ma di ba lii di laa lalon ie suaamsuaam ta suk les. Lalon abia ie di ba ta tengteng angiririki no lian di.” ");
INSERT INTO ncf_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Iesu ga atsuraa di, “Gim se leng sin abala no maarang araraa?” O di ga xisi, “Iou.” ");
INSERT INTO ncf_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Mil ga asaaiti di, “Biaabi no unaasasing araraa biaa di ta tsap no tsi asasing ina xan Maradaan balalangit, a malen tapkina anuen atuturung iwaa ta xaa alet atsuulngi no mat laxen maarang axaau ta uul ma no maarang xabaar sin xan anuen atuturung.” ");
INSERT INTO ncf_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Mil Iesu a se paare araraa taman balawaa no totore puapua o ga poroklii abia xobel. ");
INSERT INTO ncf_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","O ga laa lalon xan xobel tsaa ma ga taal asasing sin no inaman lalon xadi anua sausawit. Di alongmen xan totore o di ga suk olol, di ga atsura, “Itaa ilawaa taamat adi abala sinaae ma watwat ngali xosaraa no axixila xoror? ");
INSERT INTO ncf_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Gita atii we ilawaa taamat xan tsi untumtumar o Maria ia xan nagaa. Ma Jeims, Josep, Saimon ma Judas biaa xan no taamat. ");
INSERT INTO ncf_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","O no moton di manman mii gita. Asen parawe o ga pupua ngali xosaraa abala no mat maarang?” ");
INSERT INTO ncf_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Di taaltalu sin. Oro Iesu ga paare sin di, “Propet di manglen lalon no xobel araraa. Oro lalon xan xobel ma matenaanua so di xap manglen.” ");
INSERT INTO ncf_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ma ga xap xosaraa xaa daan axixila xoror atia amuina di xap taltaalnge sin. ");
INSERT INTO ncf_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sin abia leng king Erot alongmen inaatalem ina no maarang Iesu ta xosaraa. ");
INSERT INTO ncf_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ma ga asaaiti xan no untutule, “Ilawaa taamat ia Jon unaaxaxadaan, a sebula tapaas mula sin minet. Biaabi no axixila xoror ga taxaa lalon ia.” ");
INSERT INTO ncf_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Talaawaa Erot a se tsiili Jon ma ga pitsi ia ma ga aturungi lalon anua lodo amuina sin Erodias iwaa xan tubu Pilip, xan turamasen. ");
INSERT INTO ncf_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Amuina Jon tii asaaiti Erot we, “A xap tutiik ngali u ba maxis sin aila aina.” ");
INSERT INTO ncf_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","O Erot ga we na sas amantei Jon, oro tii ga mataatinai no inaman amuina di nan xilalaa Jon we ia propet. ");
INSERT INTO ncf_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Sin leng nagaa tii taana Erot xan tsaana Erodias a le tiili sangan no xibong ma Erot ga suk taton buxa, ");
INSERT INTO ncf_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","biaabi ga xosaraa xuxubu taman ta waawaalima ngali naba tali sen mat maarang sin aia tsaana sawe ta atsuraa ngali. ");
INSERT INTO ncf_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Amusili xan adodo xan nagaa iwaa tsaana we, “U na tali sin iaa atala papan palet xan xuan Jon unaaxaxadaan.” ");
INSERT INTO ncf_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Balan King asuk lolbiir, oro amuina sin abia xan waawaalima ma xan no xibong ta angen mii di, ga asaait ngali xosaraa malen ta atsuraa. ");
INSERT INTO ncf_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ma di ga iritlii xuan Jon lalon anua lodo. ");
INSERT INTO ncf_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Di ga aturungi xuan Jon papan palet ma di ga tali sin aia tsaana, ma ga adi laa sin xan nagaa. ");
INSERT INTO ncf_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Xan no tsi asasing Jon di ga xaalame ma adi xan pakpak Jon di ga laa punami. Mil di tii ga laa asaaiti Iesu. ");
INSERT INTO ncf_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iesu alongmen sawe ta tsap, ga poroklii biaa xobel papan mono laa sin biexa xobel biil. Biaa malep di ta alongmen abala, di suk eses xaal lalon inaman laba amusili ia. ");
INSERT INTO ncf_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Biaa Iesu ta laa tsal, ga lasi xariin malep. A titii buxaai di ma ga atoaa xadi no minet. ");
INSERT INTO ncf_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","A se nale bingbing, o no tsi asasing di ga xaalame sangan ma di ga we, “Balawaa xobel biil, o a se laa ngali lodo. Tulen abala malep laa, ngalibi di ba laa lalon no xobel ngali uuli xadi xaa luxaal.” ");
INSERT INTO ncf_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","O Iesu ga xisi, “Di na xap laa. Gim na tabali di taman xaa luxaal ngali angen.” ");
INSERT INTO ncf_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ma di ga xisi, “Alima nen tsoki ma no xoo a lua mu bala sin giem.” ");
INSERT INTO ncf_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Iesu ga we, “Gim adi no xaalame.” ");
INSERT INTO ncf_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ma ga asaaiti no inaman ngali di na tsotso papan palis. O ga adi abia no tsoki ta lima ma no xoo ta lua, ga nanen laa lapalaa balalangit ga putsangi axaau o ga tsabaxi no tsoki. Mil ga tali sin no tsi asasing o no tsi asasing di ga tabali no inaman. ");
INSERT INTO ncf_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Di araraa di angen ma di ga se maas ma no tsi asasing di ga tuali sangaul axuuk ma ga laa lua ina no xiis dokdok taman no pu ngaalngaal. ");
INSERT INTO ncf_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","No inaman di ta angen di pupua malen 5,000 ina no taamat, di xap iesei no aina ma no tsi dokdok. ");
INSERT INTO ncf_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","A xap sauna mu Iesu ga tulen xan no tsi asasing papan mono ngali laamua laa sin biexa papel ina daan ulis ma ga tulen mulangen bia malep. ");
INSERT INTO ncf_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Mil sin ta se tulen di laa, a laa lapalaa sin gelgel ina buk xasinge ngali sawit. Biaa ta se nale bingbing, ga se manman tia xasinge. ");
INSERT INTO ncf_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Oro mono a se man palaaen xuen o no paar ga tigen mono amuina sin maal ta epuske mii mono. ");
INSERT INTO ncf_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Atat se ngali tampanek o Iesu ga laa sangan di, ta eses papan daan ulis. ");
INSERT INTO ncf_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Biaa no tsi asasing di ta lasi ta eses papan daan ulis, di suk mataa buxa, di paare ma di ga xuup lot taman minataa, “Xa gaas!” ");
INSERT INTO ncf_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","A xap sauna mu Iesu ga paare ngali di, “Gim na watwat! Iaa mu. Gim nangaam mataa.” ");
INSERT INTO ncf_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita a xisi, “Orong nawe iu mu, asaaiti iaa ngali xaalame sangan iu papan daan.” ");
INSERT INTO ncf_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","A paare, “Xaalame.” Mil Pita ga tsuul papan mono ma ga eses papan daan xaalame sangan Iesu. ");
INSERT INTO ncf_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Oro biaa ta lasi maal, asuk mataa ma ga suk riri, ga xuup lot ga we, “Orong tiltsomi iaa!” ");
INSERT INTO ncf_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Sauna mu Iesu a tulis tali liman ga tsiili ia. Iesu a paare, “Num tinaalnge asuk dokdok buxa. Ngalisa u ta xap taltaalnge?” ");
INSERT INTO ncf_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Biaa delu ta en papan mono laman asuk malina. ");
INSERT INTO ncf_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mil biaa di, di ta manman papan mono di suk langaari sin, di ga paare, “A so maase, iu Xan Tsi Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Biaa di ta tabaxi daan, di ga laa tsal Genasaret. ");
INSERT INTO ncf_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Biaa no inaman lalon abia xobel di nen xilalaa Iesu, di suk tulen totore sin abia no xobel ulti Genasaret. No inaman di xaalame taman xadi no maramase sin ia. ");
INSERT INTO ncf_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ma di ga ningi awatwati Iesu ngali na sirawaa no inaman minet ngali di na taana mu barangutsina xan uga disdis ma biaa di araraa, di ta taana, di suk tuo. ");
INSERT INTO ncf_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mil biexaa Paarasi ma biexaa unaasasing ina lo di xaal Jerusalem di xaalame sangan Iesu ma di ga atsuraa, ");
INSERT INTO ncf_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ngalisa num no tsi asasing di ta laxei xadi namaang no xusaak? Biaa di ta xap guraii no liman di setauan ma di na angen!” ");
INSERT INTO ncf_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Iesu ga xisi, “Ma ngalisa gim ta laxei abia xan no lo Moroaa ngali xan axaau nagim namaang? ");
INSERT INTO ncf_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Amuina Moroaa a paare, ‘Manglen num mom ma nagaa’ o ‘Saa ia ta xororaa sin xan mom ma xan nagaa di na suk amantei.’ ");
INSERT INTO ncf_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Oro gim asaaiti no inaman, ‘Gim pupua ngali paare sin nagim no mom ma nagaa, “Sawe iaa tii xubatsi ngali tali ma tiltsomi gululu, iaa se xubatsi ngali tali malen tinabel sin Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ma nawe gim xosaraa abia, gim adodo we gim ba xap tali xaa was sin nagim no mom ma nagaa.’ Sin abia sal, gim asingan no inaman taman abia nagim no namaang, gim xap amusili xan lo Moroaa. ");
INSERT INTO ncf_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","No xalam lua, Aisaia tii suk tali xan totore propet taman gim: ");
INSERT INTO ncf_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ ‘Balawaa no inaman di manglen iaa taman xadi no bulina, oro xadi no butsa aman palaaen iaa. ");
INSERT INTO ncf_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Xadi langaari sin iaa amaara gomsaa, xadi no asasing, xadi no adodo gomsaa mu sin no inaman.’ ” ");
INSERT INTO ncf_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iesu a ilei xaraxin malep ina inaman xaalame sangan ma ga paare we, “Gim na lolong ma gim na leng. ");
INSERT INTO ncf_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Semaarang ta tsiga lalon ngutsina xa a xap xosaraa ga xap mixat, oro semaarang ta tsuul sin ngutsina, biaa a xosaraa ia, ga xap pat.” ");
INSERT INTO ncf_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","O xan no tsi asasing di ga xaalame sangan ma di ga atsuraa, “U atii bula we no Paarasi di se saae atsoti di, amuina gim ta amangieli di, ngali semaarang di ta alongmen?” ");
INSERT INTO ncf_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","A xisi, “No ie araraa nugu Mom lalon balalangit ta xap soxaa, di ba ruplii taman xan no baa. ");
INSERT INTO ncf_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Poroklii di, di no lalaamua matababa, nawe xa matababa a laamungen xa matababa, delulu ba arie rik lalon lis.” ");
INSERT INTO ncf_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita a asaaiti, “Alengi abia totore puapua sin giem.” ");
INSERT INTO ncf_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Iesu ga atsuraa di, “O gim xap mager leng? ");
INSERT INTO ncf_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Gim na leng we, semaarang ta tsiga lalon ngus a laa tutiik lalon balan ma ga tsuul alen pakpak. ");
INSERT INTO ncf_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Oro biaa no maarang ta tsuul xaal lalon ngutsina xa, axaal lalon butsa ma ga xosaraa di ga xap mixat. ");
INSERT INTO ncf_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Amuina no adodo morokon a tsuul xaal lalon butsa malen: sas amantei xa, matul mii xa u ta xap maxis sin, namaang tsaxa ina matul etaxaa, unpulapula, unaababaa, reret. ");
INSERT INTO ncf_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Balawaa no biaa ta xosaraa taamat ga xap mixat; oro ngali angen taman lima ta xap guraii a xap xosaraa taamat ga xap mixat.” ");
INSERT INTO ncf_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iesu a poroklii abia xolot o ga laa lalon xolot Taia ma Sidon. ");
INSERT INTO ncf_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Iexa aina in Kaanan a xaalame ma ga teng sangan ga we, “Orong, xan tsi Dewit, u na ie biirbirum sin iaa! Nugu tsaana salawa tsaxa a tsigaii ma ga suk tali xariin sosong sin ia.” ");
INSERT INTO ncf_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Oro Iesu tii ga xap xisi taman xa totore. O xan no tsi asasing di ga xaalame ma di ga ningi ia ga we, “Tulen lii ia na laa amuina a lo teng amumusili gita.” ");
INSERT INTO ncf_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","A xisi, “Iaa xaalame mu ngali xan no sipsip Israel ta xaapina.” ");
INSERT INTO ncf_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Oro aina ga xaalame ma ga sage putput sangan ga we, “Orong, u na tiltsomi iaa!” ");
INSERT INTO ncf_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","O ga xisi, “A xap tutiik ngali adi xadi no tsoki no tsi ma u ba silelii sin no xapuna.” ");
INSERT INTO ncf_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ga we, “Iou Orong, oro no xapuna di nganngani no mirmir ina luxaal ta xol paina xan ibe angangen xadi manmanel.” ");
INSERT INTO ncf_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mil Iesu ga xisi ia, “Aina, num tinaalnge a lot buxa! Iaa se tali sawe u ta atsura ngali.” O xan tsaana ga suk tuo sin abia aua. ");
INSERT INTO ncf_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iesu a papaalii atia ma ga es sin gelgel ina laman Galili. Mil ga laa lapalaa sin gelgel ina buk ma ga tsotso atia. ");
INSERT INTO ncf_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","O xaraxin malep, di tii ga xaalame sangan ngali le tali no isua met, no matababa ma no xadek met, ma no ngusbong ma xuduxudu ina biexaal bula ma di ga atetei di sangan no xaden ma ga atoaa di. ");
INSERT INTO ncf_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","No inaman di ga tunga biaa di ta lasi no ngusbong di ta papaare, no xadek met di ta tuo, no isua met di ta eses ma no matababa di ta nanen. Ma di ga paʼii Moroaa in Israel. ");
INSERT INTO ncf_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Iesu ga ilei xan no tsi asasing xaalame sangan ma ga we, “Iaa ie biirbirum sin abala no inaman, di se manman mii iaa sin no leng ta tuul o ga xap xaa luxaal ngali angen. O iaa ga xap saan ngali tulen aitoli di amuina di ba soro matagalgalil lalon sal.” ");
INSERT INTO ncf_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","O xan no tsi asasing di ga xisi, “Itaa gita ba adi xaa tsoki biaa naba ta pupua sin abala xaraxin xumul sin abala xobel ta suk man palaaen no xobel?” ");
INSERT INTO ncf_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","O Iesu ga atsura, “Aisa no tsoki biaa gim ta tataana?” Di xisi, “Apaasaalua no tsoki ma biexaa nen xoo dokdok.” ");
INSERT INTO ncf_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Iesu asaaiti abia xaraxin malep ngali tsotso papan pula. ");
INSERT INTO ncf_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Iesu adi abia no tsoki ta paasaalua mii no xoo o biaa ta se putsangi axaau, atsabaxi no ga tali no sin no tsi asasing o di ga tabali no inaman. ");
INSERT INTO ncf_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Di araraa di angen o di ga se maas. Mil no tsi asasing di ga adi no xiis lot ta paasaalua ina no pu ngaalngaal ina luxaal. ");
INSERT INTO ncf_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Xoxot ina abia di, di ta angen a mat malen 4,000 ina taamat mu, di xap iesei no aina ma no tsi. ");
INSERT INTO ncf_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Mil sin Iesu ta se tulen abia xaraxin malep laa, a xaa papan mono o ga laa sangan inaman laba Magadan. ");
INSERT INTO ncf_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","No Paarasi ma no Saadusi di xaalame sangan Iesu ma di ga xonon atsuraa ngali asen xa axixila sin di in balalangit. ");
INSERT INTO ncf_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","A xisi di, “Nawe wang a tok nale bingbing gim ba paare we, leng naba axaau. ");
INSERT INTO ncf_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ma lawaareng gim we, talaawaa naba maal mii langit amuina wang ta tok ma xirado. Gim atii ngali paate alengi nanen ina wang, oro gim xap pupua ngali paate alengi xaa axixila ina no leng. ");
INSERT INTO ncf_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Gim nan ul morokon ma no muun taltaalnge ina utmilmil, gim nanen ngali xa axixila, Oro iaa ba xap tali xa axixila, oro biaa mu xan axixila propet Jonaa.” O Iesu ga poroklii di ma ga laa. ");
INSERT INTO ncf_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Iesu ma xan no tsi asasing di se laa tabaxi daan ulis. No tsi asasing di adodolii ngali adi no tsoki. ");
INSERT INTO ncf_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","O Iesu ga asaaiti di, “Gim na xoxo axaau ngali epuske mii xadi no iis no Paarasi ma Saadusi.” ");
INSERT INTO ncf_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","O no tsi asasing di ga epaare labatina di tsaa we, “A paare weaatalaa, amuina gita ta xap adi xa tsoki?” ");
INSERT INTO ncf_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Iesu a se leng sin xadi no papaare, ga atsura, “Nagim tinaalnge a dokdok mu, ngalisa gim ta epaare labatina gim tsaa we a xap nagim xa tsoki? ");
INSERT INTO ncf_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Gim xap mager leng ngaa? Gim xap adodomi biaa no tsoki ta lima biaa 5,000 inaman di tii ngani ma aisa no xiis dokdok gim tii tuali? ");
INSERT INTO ncf_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","O adodomi biaa apaasaalua ina tsoki ngali abia 4,000 inaman ma aisa xiis lot gim tii tuali? ");
INSERT INTO ncf_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Asen parawe gim ta xap leng we, iaa xap papaare taman tsoki? Oro gim na xoxo axaau ngali epuske mii xadi no iis no Paarasi ma Saadusi.” ");
INSERT INTO ncf_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Mil di ga leng we, tii xap papaare taman abia iis ina xoxosaraa tsoki, oro ngali epuske mii xadi no asasing no Paarasi ma no Saadusi. ");
INSERT INTO ncf_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iesu a laa lalon inaman laba Sasaria Pilipaai o ga atsuraa xan no tsi asasing, “No inaman di we, Xan Tsi Taamat ia saa so?” ");
INSERT INTO ncf_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Di ga xisi, “Biexaal di we, iu Jon unaaxaxadaan, biexaal di we, iu Elaija ma biexaal di we, iu Jeremaia o xa ina no propet.” ");
INSERT INTO ncf_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ga atsura, “Oro gim, gim we, iaa saa?” ");
INSERT INTO ncf_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Pita a xisi, “Iu iwaa Karisito, iwaa Xan Tsi Moroaa ta tino.” ");
INSERT INTO ncf_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Iesu ga xisi, “Atubudaani iu Saimon xan tsi Jonaa. Xa taamat a xap asen abala totore sin iu, oro nugu Mom balalangit asen abala maarang sin iu. ");
INSERT INTO ncf_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ma iaa ga asaaiti iu Pita, iu xaat ma papan abia atkale, iaa ba tumaraa nugu matenaanua ina untaltaalnge ma no xoror araraa ina minet naba xap pupua ngali puxenlii. ");
INSERT INTO ncf_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Iaa ba tali no lubaluba in lalon Maradaan in balalangit sin iu. Sen maarang u ta pitsi lalon balan pula, iaa ba pitsi bula balalangit, o sen maarang u ta lubati lalon balan pula, iaa ba lubati bula balalangit.” ");
INSERT INTO ncf_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Mil tii ga atewaai xan no tsi asasing ngali di na xap asaaiti xa we, ia Karisito. ");
INSERT INTO ncf_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Sin abia no leng laa, Iesu a se atiltsoli alengi sin no tsi asasing we, naba laa Jerusalem ma na adi no xariin sosong sin no liman no xusaak ma no lalaamua ina no unsausawit ma no unaasasing ina lo. Ma di ba sas amantei o sin nanaatuul ina leng Moroaa naba atapaasi laa sin tino. ");
INSERT INTO ncf_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita a giwaa laa sin gelgel o ga atiltsoli ngali imii ia, “A xap Orong! Balawaa maarang naba suk xap tsap sin iu.” ");
INSERT INTO ncf_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","O Iesu a putsi ga asaaiti Pita, “Saatan laa mulina iaa! Nangaam xosaraa iaa ngali litke, ngali xosaraa xan sirsiir Moroaa. U xap amusili xan no adodo Moroaa, oro u amusili xadi adodo no taamat.” ");
INSERT INTO ncf_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Mil Iesu ga asaaiti xan no tsi asasing, “Saa ia ta wena tsap nugu tsi asasing, di na adodolii di tsaa, di na atsaxei xadi no tongol ma na amusili iaa. ");
INSERT INTO ncf_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Amuina saa ia ta titii xan tino tsaa, naba xosorlii, oro saa ia ta xosorlii xan tino ngali iaa, naba tatanginai mil. ");
INSERT INTO ncf_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Sen axaau taamat naba adi nawe adi abala xolkolmoxo araraa oro ga xosorlii nantanuan? O sawe xa naba ta tali ngali soxisi nantanuan? ");
INSERT INTO ncf_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Amuina Xan Tsi Taamat naba xaalame lalon xan minaalam xan Mom mii xan no angelo, mil naba tali iliil sin no inaman xuxuuk ngali no mat namaang di ta se xosaraa. ");
INSERT INTO ncf_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Iaa asaaiti gim taman so biexaa inaman di ta tiltil atala, di ba xap mager met, setauan di ba ta lasi Xan Tsi Taamat naba ta xaalame lalon Xan Maradaan.” ");
INSERT INTO ncf_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mulina no leng ta paasxuk ta se laa, Iesu a giwaa Pita, Jeims ma Jon turamasen Jeims, ma ga laamuangen detatuul papan buk lapalaa xasinge. ");
INSERT INTO ncf_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Iesu ga suk putsi sangan detatuul. O no matan ga tsila malen pal o xan no uga disdis ga tsila iaas malen laleng. ");
INSERT INTO ncf_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mil Moses mii Elaija delulu ga asemat sangan di ma delulu ga papaare mii Iesu. ");
INSERT INTO ncf_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita ga asaaiti Iesu, “Orong, asuk axaau ngali gita ta manman atala. Nawe u saan, iaa ba atilngi xaa anuenmoxo na tuul, num ka, xaka Moses ma xaka Elaija.” ");
INSERT INTO ncf_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita a papaare tsaa o biexa xelangit ta tsila asuk baaii di. O biexa ina lalon abia xelangit a paare, “Ilawaa nugu tsi, Iaa titii buxaai ma iaa ga taton sin. Gim na alongmen ia!” ");
INSERT INTO ncf_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Biaa no tsi asasing, detuu ta alongmen abala o detuu ga xol tudu papan pula taman xariin minataa. ");
INSERT INTO ncf_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Oro Iesu ga xaalame ma ga taana detatuul, ga we, “Gutuu tapaas. Gutuu nangaam mataa.” ");
INSERT INTO ncf_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Biaa di ta nanen laa lapalaa, di xap lasi xa, di lasi mu Iesu. ");
INSERT INTO ncf_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Biaa di ta tsuul papan buk, Iesu ga paare watwat sin di, “Gutuu nangaam asaaiti xa, sawe gutuu ta se lasi pupua Xan Tsi Taamat naba ta tapaas sin minet.” ");
INSERT INTO ncf_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","No tsi asasing di ga atsuraa ia, “Ngalisa no unaasasing ina lo di ta we Elaija na setauan xaalame laamuaan Karisito?” ");
INSERT INTO ncf_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Iesu ga xisi, “Balawaa totore aso Elaija naba setauan xaalame na atutiki mulangen no maarang araraa. ");
INSERT INTO ncf_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Iaa se asaaiti gim we Elaija a se xaalame tsaa o no inaman di ga xap nen xilalaa ia. Oro di xosaraa no mat namaang tsaxa di ta saan ngali. Sin abia namaang bula di ba tali sosong bula sin Xan Tsi Taamat.” ");
INSERT INTO ncf_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Mil no tsi asasing di ga leng we a paare sin di taman Jon unaaxaxadaan. ");
INSERT INTO ncf_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Biaa di ta xaalame sangan abia malep iexa taamat ga le sage putput laamuaan Iesu. ");
INSERT INTO ncf_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ga paare, “Orong u na ie biirbirum sin nugu tsi. A gogo ma ga saaen xariin sosong. Xuduxudu ina leng a xol lalon ie ma lalon daan. ");
INSERT INTO ncf_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Iaa ga giwaa laa sangan num no tsi asasing oro di ga xap pupua ngali atoaa.” ");
INSERT INTO ncf_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","O Iesu ga xisi, “Gim no utmilmil ina no muun taltaalnge. Saa puaa iaa ba ta manman mii gim? Aisa bula iaa ba ta atsaxei nagim no mamaet? Giwaa aia tsi xaalame sangan iaa.” ");
INSERT INTO ncf_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","O Iesu ga imii iwaa salawa tsaxa o ga suk tsuul alen aia tsi, sin abia aua asuk tuo. ");
INSERT INTO ncf_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","O mil no tsi asasing di ga xaalame sangan Iesu xasinge ma di ga atsuraa, “Asen parawe giem ga xap pupua ngali saali ia?” ");
INSERT INTO ncf_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","O ga xisi, “Amuina nagim no tinaalnge adokdok buxa. Aso maase, Iaa asaaiti gim taman so, nawe gim ie tinaalnge malen ilawaa xalitsa dokdok ina tsupa, o gim pupua ngali paare sin abala buk, ‘Tapaas atala u na laa atilie’ ma naba suk laa. Gim ba pupua ngali xosaraa no mat maarang araraa.” ");
INSERT INTO ncf_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Biaa di ta le tsap etudim Galili, Iesu ga paare ngali di. “Iexa taamat naba babel tali Xan Tsi Taamat papan no liman no taamat morokon. ");
INSERT INTO ncf_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","O di ba sas amantei o sin nanaatuul ina leng naba tapaas sin tino.” No tsi asasing di alongmen abala o di ga suk lolbiir buxa. ");
INSERT INTO ncf_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Mil Iesu mii xan no tsi asasing di laa tsap Kaperanaam o no unaalalet taakis ngali Xan Anua Moroaa di xaalame sangan Pita, o di ga atsuraa, “Num unaasasing a taltali taakis bula ngali xan Anua Moroaa?” ");
INSERT INTO ncf_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita a xisi, “Iou.” Biaa Pita tii tsiga naanua, Iesu a setauan paare, “Saimon u sen adodo we? No King ina xolkolmoxo di alalet taakis sin xadi no tsi tsaa o sin no inaman xaatsap?” ");
INSERT INTO ncf_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","O Pita ga xisi, “Sin no inaman xaatsap.” O Iesu ga paare sin ia, “Biaabi no tsi di na xap tali taakis. ");
INSERT INTO ncf_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Oro ngalibi gitaa ba soro xap xosaraa di ngali di ba saae atsoti di, laa lalon daan ulis ma u na ngangaul. Taii nanaaxuuk ina xoo ma u na apangaa ngutsina ngali u ba lasi nan xuxute tia lalon. U na adi aia xuxute u na tali sin di ngali nugu taakis ma num.” ");
INSERT INTO ncf_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Sin abia leng no tsi asasing di xaalame sangan Iesu ma di ga atsura, “Saa lot buxa lalon abia Maradaan in Balalangit?” ");
INSERT INTO ncf_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","A ilei iexa tsi dokdok xaalame sangan ma ga le atilngi labatina di. ");
INSERT INTO ncf_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ma ga paare, “Iaa asaaiti gim taman so, nawe gim xap putsi ma tsap malen no tsi dokdok, gim ba xap tsiga lalon abia Maradaan ina balalangit. ");
INSERT INTO ncf_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Biaabi, saa ia ta adokdoki ia tsaa malen aila tsi dokdok, a suk lot buxa lalon abia Maradaan ina balalangit. ");
INSERT INTO ncf_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ma saa ia ta suei atatoni xa tsi dokdok sin iesaaga, a suei atatoni iaa. ");
INSERT INTO ncf_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Oro nawe xa a xosaraa xa ina abala no tsi dokdok, di ta taltaalnge sin iaa, ngali litke lalon namaang tsaxa, naba axaau buxa ngali di na ataxiwaa xa xaat ngali amimii grein ulti inan ngali aliaani lalaman. ");
INSERT INTO ncf_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Xaraxin xirabas naba tsap lalon xolkolmoxo amuina di xosaraa no inaman, di ga xol sin namaang tsaxa. Asuk so balawaa no namaang tsaxa naba tsap, oro xaraxin xirabas naba tsap sin xa ta atsapngen abala no namaang tsaxa! ");
INSERT INTO ncf_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nawe limaam o xaim a xosaraa iu ngali litke sin namaang tsaxa, u na xitiplii ma u na lii laa. Naba axaau buxa ngali tino taman ta xap xa limaam o xa xaim ngen no limaam ta lua mii no xaim ta lua o di na lii iu lalon ie ta xap metmet. ");
INSERT INTO ncf_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ma nawe mataam a xosaraa iu ngali litke sin namaang tsaxa, luapelii ma u na lii laa. Naba suk axaau buxa ngali u na tino taman mat ta xuuk, ngen abia no mat ta lua ma di na lii iu nan ie ina Edes. ");
INSERT INTO ncf_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Gim nangaam nen amagurusiki xa ina abala no tsi dokdok. Amuina iaa asaaiti gim we, xadi no angelo nan balalangit, di tigiri laklasi no matan nugu Mom nan balalangit. ");
INSERT INTO ncf_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Nagim adodo asen we? Nawe xa taamat a ie sangsangaul ina no sipsip o iexa ina abia no sipsip ga es tangtangabaa, a pupua ngali naba suk papaalii abia no 99 sipsip ma na suk laa tsalei aiwaa sipsip ta es tangtangabaa? ");
INSERT INTO ncf_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","O nawe naba tatanginai, aso maase iaa asaaiti gim, naba suk taton buxa ngali aia sipsip ta xuuk ngen abia 99 ina sipsip, di ta xap es tangtangabaa. ");
INSERT INTO ncf_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Sin abia uk namaang mu nagim Mom in balalangit, a xap siir ngali xa ina abala no tsi dokdok, di na xaapina. ");
INSERT INTO ncf_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nawe num taamat a xosaraa namaang tsaxa sin iu, u na tulis asen xan namaang tsaxa, lolobet mu ina gululu. Nawe alongmen iu, u se gii mulangenai ia. ");
INSERT INTO ncf_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Oro nawe naba xap lolong, giwaa xa na xuuk o na lua mii iu ngali biaa totore naba leng taman alua o a tuul ina tiltsoxoti. ");
INSERT INTO ncf_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Oro nawe a xap lolong tsaa, u na asaaiti xan matenaanua Moroaa; ma nawe a xap lolong bula sin abia xumul, gim na xosaraa ia malen xa Gentail o xa unaalalet taakis. ");
INSERT INTO ncf_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Iaa asaaiti gim taman so, sen maarang gim ta xubatsi tala nan balan pula, ia naba xubatsi bula tade balalangit, O sen maarang gim ta lubati tala lalon balan pula, naba lubati bula balalangit. ");
INSERT INTO ncf_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Asuk so, Iaa sebula asaaiti gim, nawe lo taamat lalon xolkolmoxo delu ukbal taman xawas delu ta atsura ngali, naba xosor puaa ngali delulu sin nugu Mom balalangit. ");
INSERT INTO ncf_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Amuina nawe alua o a tuul ina taamat di tsap etudim sin iesaaga, iaa manman mii di.” ");
INSERT INTO ncf_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Mil Pita ga xaalame sangan Iesu ma ga atsuraa, “Orong, aisa iaa ba ta adodolii no namaang tsaxa nugu taamat ta xosaraa sin iaa? Pupua sin apaasaalua ina xoxot iaa ba ta adodolii?” ");
INSERT INTO ncf_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Iesu a xisi, “Iaa asaaiti gim, a xap paasaalua ina xoxot, oro no sangaul a paasaalua ma ga laa paasaalua ina xoxot. ");
INSERT INTO ncf_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Biaabi, Maradaan ina balalangit a malen king ta we na atutiki xadi no xiba xan no untutule. ");
INSERT INTO ncf_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ga se atiltsoxoli ngali atutiki no xiba o iexa taamat ta ie xiba sin ta pupua malen sangaul ina tausen xiis goul, di tii ga giwaa ia laa sin xan manmanel. ");
INSERT INTO ncf_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Amuina sin ta xap pupua ngali uul xisi abia xan xiba, iwaa manmanel asuk tali papaare watwat ngali iwaa taamat ma xan tubu ma xadelulu no tsi ma xan no maarang araraa di na sune taman no, ngali uul xisi xan xiba. ");
INSERT INTO ncf_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Iwaa untutule a sage putput laamuaan ia ma ga ningi awatwati. ‘Ben liliis adamis ngali iaa ba uul xisi araraai abia no maarang araraa.’ ");
INSERT INTO ncf_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Iwaa xan manmanel aia untutule asuk titii buxaai ia ma ga suk adodolii araraai abia xan xiba ma ga papaalii ia ga laa. ");
INSERT INTO ncf_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Oro biaa iwaa untutule ta tsuul laa lokobel atatanginai iexa xan uk untutule bula ta ie xiba sin, ta pupua malen sangsangaul ina xuxute. A logotsi ia ma ga atiltsoli ngali partsi inan. Ga asaaiti awatwati, ‘Uul xisi num xiba sin iaa.’ ");
INSERT INTO ncf_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Mil xan uk untutule ga sage putput lapula ma ga suk ningi awatwati, ‘U na ben man adamis liliisi iaa ngali iaa ba uul xisi nugu xiba.’ ");
INSERT INTO ncf_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Oro a xap lolong. A laa ma ga atsigili aia untutule nan anuen lodo, til sin naba ta uul xisi xan xiba ");
INSERT INTO ncf_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Biaa biexaa uk untutule, di ta lasi sawe ta tsap, di suk magaa ma di ga laa asaaiti manmanel taman no sen maarang ta tsap. ");
INSERT INTO ncf_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Mil manmanel ga ilei atsigili aia untutule ma ga asaaiti, iu morokon ina untutule, iaa adodolii araraai num no xiba, amuina u ta ningi awatwati iaa. ");
INSERT INTO ncf_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ngalisa u ta xap ie biirbirum sin num uk untutule malen iaa ta ie biirbirum sin iu? ");
INSERT INTO ncf_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Sin xan minagaa xan manmanel asuk tali ia laa nan anua lodo ma di ga tali xariin sosong sin, laa pupua naba ta uul xisi xan xiba. ");
INSERT INTO ncf_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Sin abala namaang nugu Mom balalangit naba xosaraa wengenai gim xuxuuk weaatia, nawe gim xap adodolii so xadi no namaang tsaxa nagim no taamat xaal lalon nagim no butsa.” ");
INSERT INTO ncf_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Biaa Iesu ta se paare araraa taman abala no maarang a poroklii Galili ma ga tsiga laa lalon prowins Judaia sin biexa papel ina Jodan. ");
INSERT INTO ncf_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Biexa xariin malep di tii amusili ia ma ga atoaa di atia. ");
INSERT INTO ncf_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Biexaa Paarasi di ga xaalame sangan ma di ga le xonon ia. Di ga atsuraa, “A tutiik sin lo, ngali xa taamat naba atsiplii xan tubu sin xaa muina?” ");
INSERT INTO ncf_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","A xisi, “Gim xap mager xoxoti, ‘sin atiltsoxoli Unaaxoxos a xosaraa delulu, taamat ma aina,’ ");
INSERT INTO ncf_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ma ga paare, ‘Ngali abala mu muina o taamat naba papaalii xan mom ma nagaa ma na man etudim mii xan tubu, ma delulu ba tsap nan pakpak ta xuuk?’ ");
INSERT INTO ncf_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Biaabi delulu ga se xap lua, oro delu ga se tsap nan pakpak ta xuuk mu. Biaabi biaa delulu Moroaa ta se asumaa todomien na xap xa taamat naba atsiplii delulu.” ");
INSERT INTO ncf_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Di ga atsuraa, “Ngalisa so ila Moses ga tali abia lo ngali taamat naba pupua ngali atalaa xa len perper laa sin xan tubu ngali alengi we a se atsiplii minaxis ma na tulen ia laa?” ");
INSERT INTO ncf_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Iesu a xisi, “Moses a sirawaa gim ngali atsiplii nagim no tubu, amuina nagim no butsa tii suk xitsa buxa, oro tii xap weaatalaa sin atiltsoxoli. ");
INSERT INTO ncf_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Iaa asaaiti gim we, saa ia ta atsiplii xan tubu, ma ga maxis sin xa xaatsap a malen a se matul mii iexa aina ta xap xan tubu, oro nawe xan tubu a matul mii iexa ta xap xan maxis, taamat a pupua ngali atsiplii ma na maxis sin iexa.” ");
INSERT INTO ncf_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","No tsi asasing di paare laa sin, “Nawe balawaa namaang lolobet ina taamat ma xan tubu, asuk axaau buxa ngali na xap xa na maxis.” ");
INSERT INTO ncf_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Iesu a xisi, “A xap di se araraa di pupua ngali sirawaa abala totore, oro biaa mu di, di ta tali sin di. ");
INSERT INTO ncf_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Amuina biexaa iunik, di se taxaanai di weaatia, ma biexaa iunik di tsap no iunik sin biexaal, o biexaal di axilangi ngali tino malen no iunik amuina ngali Maradaan in balalangit ma di ga xap maxis. Saa taamat ta pupua ngali adi abala totore na adi.” ");
INSERT INTO ncf_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mil no inaman di ga giwaa no tsi dokdok laa sangan Iesu ngali naba aturungi no liman papan di ma na sawit ngali di. Oro no tsi asasing di imii di. ");
INSERT INTO ncf_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Iesu a paare, “Gim papaalii no tsi dokdok di na xaalame sangan iaa ma gim nangaam tilbanti di, amuina Maradaan ina balalangit xadi abala di.” ");
INSERT INTO ncf_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Biaa ta se xap sin aturungi no liman papan di, a suk poroklii di. ");
INSERT INTO ncf_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Iexa taamat a xaalame sangan Iesu ma ga le atsuraa, “Unaasasing, no sen maarang axaau iaa ba xosaraa ngali adi tino laaliu?” ");
INSERT INTO ncf_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Iesu a xisi, “Ngalisa iu ta atsuraa iaa ngali sen maarang ta axaau? Axuuk mu aia ta axaau. Nawe u saan ngali adi tino laaliu, u na no lo.” ");
INSERT INTO ncf_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ga atsura, “No sen mat lo?” Iesu a xisi, “ ‘Nangaam sas amantei xa taamat, nangaam matul mii iwaa xa u ta xap maxis sin, nangaam pulapula, nangaam dadare, ");
INSERT INTO ncf_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","manglen num mom ma nagaa, ma u na titii buxaai no turaam atataaen iu malen u ta titii buxaai iu tsaa.’ ” ");
INSERT INTO ncf_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Iwaa taamat xulaau ga paare, “Biaa no lo araraa iaa se amusili, sen maarang bula biaa iaa ta xap xosaraa?” ");
INSERT INTO ncf_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iesu a xisi, “Nawe u saan so ngali u na tutiik araraa, laa ma u na sune taman num no maarang araraa ma tali sin no muunwas ngali u ba adi no daan tubudaan in balalangit. Mil xaalame, amusili iaa.” ");
INSERT INTO ncf_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Biaa iwaa taamat xulaau ta longmien abala, a suk laa taman lolbiir, amuina ia untang. ");
INSERT INTO ncf_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Iesu ga paare ngali xan no tsi asasing, “Iaa suk asaaiti gim taman so, a suk lelep buxa, ngali xa untang ngali tsiga lalon Maradaan ina balalangit. ");
INSERT INTO ncf_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Iaa ba sebula asaaiti gim, a suk malus ngali kemal ngali tsiga lalon mat ina tip xabati, ngen ngali xa untang na tsiga lalon xan Maradaan Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Biaa no tsi asasing di ta longmien abala, di suk olol buxa ma di ga atsuraa, “O saa so naba pupua ngali adi tino laaliu?” ");
INSERT INTO ncf_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Iesu ga matngen di ma ga paare, “Mii taamat mu, a xap pupua, oro sin Moroaa biaa no maarang araraa a pupua.” ");
INSERT INTO ncf_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pita ga xisi, “Giem se papaalii no mat maarang araraa ngali amusili iu, sen maarang biaa ngali giem?” ");
INSERT INTO ncf_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Iesu ga paare ngali di, “Iaa asaaiti gim taman so, sin abia leng Moroaa naba ta xosaraa auuli xolkolmoxo ma biaa xan tsi taamat naba ta tsotso papan biaa xan muina xalkale ina minaalam; biaa gim, gim ta amusili iaa, gim bula, gim ba tsotso papan abia no muina xalkale ta sangaul ma ga laa lua ngali ininte sin abia sangaul ma ga laa lua ina matenbung in Israel. ");
INSERT INTO ncf_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","O biaa di, di ta poroklii xadi anua, xadi no taamat, no moton di, xadi mom, xadi nagaa, o xadi no tsi ma no uma ngali iesaaga, di ba adi sangsangaul axuuk buxa ina iliil ma di ba tapkina abia tino laaliu. ");
INSERT INTO ncf_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Oro a xuduxudu ina biaa di, di ta lalaamua di ba amamil o a xuduxudu ina biaa di, di ta amamil di ba lalaamua.” ");
INSERT INTO ncf_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Maradaan in balalangit a malen tapkina uma ta laa lawaareng bingbing ngali giwaa no untinaxaa ngali xan uma waain. ");
INSERT INTO ncf_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Iwaa taamat a sirawaa di ngali uuli di taman nan denarias axuuk sin leng axuuk ma ga tulen di laa nan xan uma waain. ");
INSERT INTO ncf_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Sin apaasaaet lawaareng, a es laa ma ga lasi biexaal di ta tiltil gomsaa nan xolot ina susune. ");
INSERT INTO ncf_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ga asaaiti di, ‘Gim bula gim laa taxaa lalon nugu uma waain ngali iaa ba uuli atutiki gim taman sen iliil ta tutiik.’ ");
INSERT INTO ncf_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Mil di ga laa. “Tii ga sebula laa sin talu piaak lasiaat ma sin nan a tuul nale ma ga xosaraa abia uk maarang. ");
INSERT INTO ncf_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Sin nan alima nale, a sebula laa tatanginai biexaal di ta tiltil gomsaa tsaa. Ga atsuraa di, ‘Ngalisa gim ta tiltil gomsaa sin abala leng xiduul, gim ta xap xosaraa xaa was?’ ");
INSERT INTO ncf_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Di xisi, ‘Amuina a xap xa na taal tinaxaa sin giem.’ “Ga xisi di, ‘Gim bula, gim laa taxaa lalon nugu uma waain.’ ");
INSERT INTO ncf_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Biaa ta se nale bingbing, iwaa tapkina uma waain ga asaaiti xan untilaamamil, ‘Ilei no untinaxaa ma u na uuli di taman xadi no iliil, atiltsoli sin xapkap ina no untinaxaa ma na laa sin abia no untinaxaa setauan.’ ");
INSERT INTO ncf_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Biaa no untinaxaa, ia ta giwaa di sin a lima nale di xaalame ma ga uuli di taman nan denarias ta xuuk. ");
INSERT INTO ncf_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","O biaa di, ta setauan giwaa tsaxali di, di soro adodo we, di ba alet buxaai ngen biexaal, oro ga xap, di xuxuuk, a uuli di taman nan denarias ta xuuk mu. ");
INSERT INTO ncf_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Biaa di ta adi abia iliil, di suk paare xuduxudu ngali aia tapkina uma waain. ");
INSERT INTO ncf_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Di ga paare, ‘Biaa di u ta taal tinaxaa sin di mil, di taxaa dokdok mu, o u ga uuli di etuna mii giem, biaa giem ta adi abia mamaet ina tinaxaa sin lelep ina leng!’ ");
INSERT INTO ncf_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Oro a xisi iexa ina di, ‘Turaaga, iaa tii xap xosaraa namaang tsaxa sin iu. U tii siir ngali taxaa ngali xa denarias, taa? ");
INSERT INTO ncf_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Adi num iliil ma u na laa. Iaa saan ngali tabali aia xa iaa ta taal tinaxaa sin mil, na malen abia iaa ta tali sin iu. ");
INSERT INTO ncf_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","A tutiik ngali iaa na xosaraa sawe iaa ta saan ngali taman nugu xuxute tsaa? O u bal tsaxa amuina iaa ta tabiel axaautsi biexaa untinaxaa?’ ");
INSERT INTO ncf_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Biaabi iwaa ta amamil, naba lalaamua, o iwaa ta lalaamua, naba amamil.” ");
INSERT INTO ncf_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Talaawaa Iesu a se es laa lapalaa Jerusalem. Nan sal, ga axumuli abia sangaul axuuk ma ga laa lua ina tsi asasing laa sin gelgel ma ga papaare sin di, ");
INSERT INTO ncf_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Gita laa lapalaa Jerusalem ma Xan Tsi Taamat di ba babel tali sin no lalaamua ina no unsausawit ma no unaasasing ina lo. Ngali di ba atut tali minet papan ia. ");
INSERT INTO ncf_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ma di ba tali ia laa sin no Gentail ngali di ba rereti ma ririiti ma ataxiwaa papan tongol. O sin nanaatuul ina leng naba tapaas mula sin tino.” ");
INSERT INTO ncf_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Mil xadi nagaa xan no tsi Sebedi, a xaalame sangan Iesu mii xan no tsi ma ga sage putput lapula ngali atsuraa ngali xa tubudaan sin. ");
INSERT INTO ncf_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Iesu ga atsuraa, “Sen maarang iu saansili?” Ga paare, “U siir ngali abala nugu no tsi ta lua, ngali iexa naba xalkale sin num lima mua, o iexa sin num lima xaiaar lalon num Maradaan.” ");
INSERT INTO ncf_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Iesu ga paare ngali di, “Gim suk xap atii sen maarang gim ta atsuraa iaa ngali. Gululu pupua ngali nun lalon abia sobuk ina xaraxin mamaet biaa iaa ba ta nun lalon?” Delulu xisi, “Gelu pupua.” ");
INSERT INTO ncf_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Iesu ga paare sin delulu, “Gulu ba nun lalon nugu sobuk, oro ngali xalkale sin nugu mua o xaiaar, iaa xap pupua ngali tali abia. Biaa no xalkale xadi no mu abia di, nugu Mom ta se taxaaturungi ngali di.” ");
INSERT INTO ncf_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Biaa sangaul ina tsi asasing di ta longmien abala, di suk xap taton sin abia lo masen xan taamat. ");
INSERT INTO ncf_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Iesu ga ilei axumuli di ma ga paare, “Gim atii xadi no unbanam no Gentail di aorongi di tsaa papan xadi no gawaman, biaa di ta atsapngen biaa banam papan di. ");
INSERT INTO ncf_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","A xap weaatia sin gim, oro nawe sa ia ta wena madil laba labatina gim, ia na tsap nagim untutule. ");
INSERT INTO ncf_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma sa ia ta we na lalaamua, na setauan tsap nagim untutule. ");
INSERT INTO ncf_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Malen mu Xan Tsi Taamat tii xap xaalame ngali gim ba tabali ia oro a xaalame ngali tabali gim, ma ga tali xan tino malen iliil ngali uuli mulangen xuduxudu.” ");
INSERT INTO ncf_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Biaa Iesu mii xan no tsi asasing di ta se papaalii Jeriko, xaraxin malep di suk amusili ia. ");
INSERT INTO ncf_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Lo matababa delu tsotso sin gelgel ina sal, ma delulu ga suk longmien malen Iesu a se es liu, delulu ga xuup lot, “Orong, xan Tsi Dewit, u na ie biirbirum sin gelulu!” ");
INSERT INTO ncf_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Biaa malep di suk imii delulu ma di ga asaaiti delulu ngali bong, oro delu xuup lot buxa tsaa, “Orong, xan Tsi Dewit, u na ie biirbirum sin gelulu!” ");
INSERT INTO ncf_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iesu a til ma ga ilei delulu, ma ga atsuraa delulu, “Gululu saan ngali iaa ba xosaraa sa sin gululu?” ");
INSERT INTO ncf_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Delulu xisi, “Orong, gelu saan ngali nanen sebula.” ");
INSERT INTO ncf_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iesu a titii buxaai delulu ma ga taxaanai no matan delulu. Tiwaa tsaa delu suk nanen ma delu ga amusili ia. ");
INSERT INTO ncf_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Di se es laa Jerusalem ma di ga se le tsap Betapage papan abia Buk Olip, Iesu ga tulen no tsi asasing ta lua, ");
INSERT INTO ncf_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ma ga asaaiti delulu, “Gululu na laa nan abia xobel laamuaan gululu, gululu ba tatanginai donki tia, di ta pitsi mii xan donki dokdok sangan, gululu na lubati delulu ma gululu na le tali delulu sin iaa. ");
INSERT INTO ncf_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nawe xa a paare taman xawas sin gululu, gululu na asaaiti di, Orong asaansili delulu, ma naba tulen mulangen delulu isagaa mu.” ");
INSERT INTO ncf_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Balawaa a tsap ngali taxaawiti biaa propet tii se paare taman: ");
INSERT INTO ncf_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Asaaiti xan tsaana Saion, ‘Lasi, nagim king ta xaalame sangan gim, a mangmagus ma ga tsotso papan donki, ma papan donki dokdok.’ ” ");
INSERT INTO ncf_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","No tsi asasing delulu laa ma delulu xosaraa malen abia Iesu ta paare alengi delulu. ");
INSERT INTO ncf_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Delulu le tali aia donki mii iwaa donki dokdok, ma di ga sulali xadi no uga disdis papan lo donki ma Iesu ga tsotso papan delulu. ");
INSERT INTO ncf_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Xaraxin malep, di ga sulali xadi no uga disdis lalon sal, o biexaal di tale no laxen baibai ma di ga sulali no lalon sal. ");
INSERT INTO ncf_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Biaa malep di ta es laamuaan Iesu ma biexaal di ta amusili ia, di ga tol, “Osaana, laa sin xan Tsi Dewit!” “Atubudaani iwaa ta xaalame sin iesan Orong!” “Osaana lapalaa suk se tade balalangit!” ");
INSERT INTO ncf_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Biaa Iesu ta tsiga Jerusalem, biaa inaman laba araraa di olol ma di ga atsura, “Saa waaila?” ");
INSERT INTO ncf_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Biaa malep di ga xisi, “Ilawaa Iesu, iwaa propet in Nasaret lalon Galili.” ");
INSERT INTO ncf_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iesu a tsiga lalon bengbeng ina Xan Anua Moroaa ma ga xalel atsuulngi abia di, di ta uuli no maarang ma biaa di ta sune tia. Ga puxenlii xadi no teibal no taamat ina soxisi xuxute, ma xadi no niaan xalkale bula abia di, di ta sune taman no buna. ");
INSERT INTO ncf_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","A paare sin di, “Di tii atalaa, ‘Nugu anua iaa ba putsangi anua ina sausawit,’ oro gim se xosaraa malen ‘xadi niaan no unpulapula.’ ” ");
INSERT INTO ncf_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","No matababa ma no xadek tsaxa di xaalame sangan lalon xolot ina Xan Anua Moroaa ma ga atoaa di. ");
INSERT INTO ncf_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Oro biaa no lalaamua ina no unsausawit ma no unaasasing ina lo di ta lasi abala no tinaxaa axaau ta xosaraa, ma no tsi dokdok di ta toltol lalon xolot ina Xan Anua Moroaa, “Osaana laa sin xan Tsi Dewit,” di suk bal magaa ngali ia. ");
INSERT INTO ncf_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Di ga atsuraa ia, “U longmien bula senaara balawaa no tsi dokdok di ta tol papaatinai?” Iesu a xisi, “Iou, gim xap mager xoxoti, taa? “‘Sin no bulina no tsi dokdok ma no madalak Orong naba ilei ngali num pinpinis?’ ” ");
INSERT INTO ncf_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ma a papaalii di ma ga es tsuul lalon abia inaman laba ma ga laa Betani ma ga manngi abia bing tia. ");
INSERT INTO ncf_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Lawaareng bingbing Iesu a es mula laa lalon inaman laba, ga se itol. ");
INSERT INTO ncf_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","A lasi iexa ie fik sangan sal ga suk es laa sangan. Ma ga xap tatanginai xaa waawaan papan, oro no lawina mu. O ga suk paare ngali, “U ba xap pupua ngali waalii xaa waawaan iu bula!” Tiwaa tsaa iwaa ie fik asuk malang araraa. ");
INSERT INTO ncf_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Biaa no tsi asasing di ta lasi abala, di suk olol ma di ga atsura, “Amalang isagaa sen we aila ie fik?” ");
INSERT INTO ncf_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Iesu a xisi, “Iaa asaaiti gim taman so, nawe gim ie tinaalnge ma gim xap adodo xudu, gim pupua mu ngali xosaraa sawe sin aila ie fik ma gim pupua tsaa bula ngali asaaiti abala buk, ‘Laa lii iu tsaa lalaman,’ ma biaa maarang naba tsap. ");
INSERT INTO ncf_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nawe gim taltaalnge, gim ba adi semaarang gim ta ningi lalon sausawit.” ");
INSERT INTO ncf_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Biaa Iesu ta tsiga lalon xolot ina Xan Anua Moroaa ma ga xosaraa asasing, no lalaamua ina no unsausawit ma xadi no xusaak no inaman di xaalame sangan ma di ga atsuraa, “Sin sen banam u ga xosaraa abala no maarang? Ma saa tali abala banam susum?” ");
INSERT INTO ncf_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Iesu ga xisi, “Iaa bula iaa wena atsuraa gim taman xa atsutsura. O nawe gim xisi iaa. Iaa ba asaaiti gim taman sen banam abala, iaa ga xosaraa abala no maarang. ");
INSERT INTO ncf_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Xan axaxadaan Jon itaa axaal? Axaal balalangit, o sin no inaman mu?” Di ga etsura engen di ma di ga paare, “Nawe gita ba paare we axaal, ‘balalangit’, naba atsura we, ‘O ngalisa gim ta xap taltaalnge sin?’ ");
INSERT INTO ncf_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","O nawe gita we, ‘sin no inaman,’ gita mataa sin no inaman, amuina di adodo we Jon ia propet.” ");
INSERT INTO ncf_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Biaabi di ga xisi Iesu, “Giem xap atii.” Mil Iesu ga we, “O iaa ba xap asaait alengi gim bula taman sen banam biaa iaa ga xosaraa abala no maarang. ");
INSERT INTO ncf_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Nagim sen adodo? Iexa taamat xan no tsi alua. A laa sangan iwaa tuaa ina tsi ma ga asaaiti, ‘Nugu tsi, laa taxaa talaawaa lalon uma waain.’ ");
INSERT INTO ncf_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Iwaa tsi a xisi, ‘Iaa ba xap laa’, oro mil ga putsi xan adodo ma ga laa. ");
INSERT INTO ncf_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Mil iwaa mom a sebula laa sangan iexa tsi ma ga tore taman abia uk totore. Iwaa tsi a xisi, ‘Iaa ba laa mom,’ oro tii ga xap laa. ");
INSERT INTO ncf_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Saa ina abala delulu a amusili?” Di xisi, “Iwaa tuaa.” Iesu ga asaaiti di, “Iaa asaaiti gim taman so, no unaalalet taakis ma no aina in nan sal, di ba tsiga lalon xan Maradaan Moroaa laamuaan gim. ");
INSERT INTO ncf_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Amuina Jon tii xaalame ngali asen namaang tutiik sin gim, o gim tii ga xap taltaalnge sin, oro no unaalalet taakis ma no aina in nan sal, di tii ga taltaalnge sin. Mil biaa gim ta se lasi abala maarang, gim tii xap puxisbal ma taltaalnge sin. ");
INSERT INTO ncf_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Gim na longmien biexa totore puapua: Iexa tapkina pula tii soxaa biexa uma waain. A xosaraa barateng ulti ma ga xaii mat lalon xaat ngali parlii waain lalon ma ga xosaraa anua xoxo lalon uma. Mil ga bisi abia uma waain sin biexaa unbisbis uma ngali ben taxaa xuxute taman ma ga laa sin biexa xobel. ");
INSERT INTO ncf_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Mil sin leng ina papaas ta se xaalame, a tulen xan untutule laa sangan aia unbisbis uma ngali laa adi xakaa waawaan. ");
INSERT INTO ncf_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“No unbisbis, di tsiili xan no untutule; di tsaapi iexa, sas amantei iexa, o nanaatuul, di pidi taman no xaat. ");
INSERT INTO ncf_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mil ga tulen biexaa untutule ta xudu ngen abia di ta setauan tulen laa sangan di, ma no unbisbis uma di ga sebula xosaraa abia xuuk namaang sin di. ");
INSERT INTO ncf_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Sin xapkap ina, a tulen xan tsi laa sin di ma ga paare, ‘Di ba manglen nugu tsi.’ ");
INSERT INTO ncf_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Oro biaa no unbisbis, di ta lasi xan tsi, di epaare, ‘O ilawaa se aila naba ta momtsoli uma. Xaalame, gita laa sas amantei ngali gita ba adi abia uma ta momtsoli.’ ");
INSERT INTO ncf_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Di giwaa ia ma di ga lii atsuulngi lalon uma waain ma di ga sas amantei. ");
INSERT INTO ncf_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Biaabi, biaa tapkina uma waain ta xaalame, naba xosaraa sa sin abia no unbisbis uma?” ");
INSERT INTO ncf_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Di ga xisi, “Na ba suk tsaalen atsoti abia no unbisbis uma tsaxa. O naba bisi tali abia uma waain sebula sin biexaa unbisbis uma ngali di ba exasen xaa waawaan mii ia sin leng papaas.” ");
INSERT INTO ncf_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Iesu asaaiti di, “Asen parawe gim tii xap mager xoxoti lalon Inaatel Pat: “ ‘Iwaa xaat no untunumar di ta palolii, a se tsap malen atkale so ina anua; Orong a xosaraa abalaa, ma ga matmirmir nan no matan gita?’ ");
INSERT INTO ncf_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Biaabi, iaa we ina asaaiti gim we, xan Maradaan Moroaa, Moroaa naba saali sin gim, ma naba tali sin no inaman biaa di ba ta waalii xadi xaa waawaan. ");
INSERT INTO ncf_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","O saa ia ta xol papan abala xaat, naba suk xamidimidi araraa, oro saa ia biaa xaat ta xol papan naba suk axaxaitsaa ia.” ");
INSERT INTO ncf_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Biaa no lalaamua ina no unsausawit ma no Paarasi di ta longmien xan no totore puapua Iesu, di suk atii we Iesu a papaare taman di. ");
INSERT INTO ncf_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Di suk tsalei xa sal ngali pitsi ia, oro di ga mataatinai abia malep amuina biaa inaman di adodo we, Iesu ia propet. ");
INSERT INTO ncf_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iesu a sebula paare taman no totore puapua laa sin di ma ga paare: ");
INSERT INTO ncf_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Xan Maradaan balalangit a malen king iwaa ta taxaaturungi luxaal ngali alabaa sin xan tsi. ");
INSERT INTO ncf_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","A tulen xan no untutule ngali asaaiti abia di, ta tali xan iliile ngali di, ngali xaalame sin abia luxaal ina alaba, oro di tii ga palo ngali xaalame. ");
INSERT INTO ncf_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“A sebula tulen biexaa untutule ma ga paare, ‘Gim asaaiti abia di, iaa ta se tali nugu ililei ngali di, malen iaa se taxaaturungi nugu luxaal. Nugu no bulmakau ta pompom, a se taxaaturung, ma no maarang araraa a se manman. Gim xaalame sin abala luxaal ina alaba.’ ");
INSERT INTO ncf_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Oro di xap longmien ia ma di ga laa liu, iexa a laa man lalon xan uma, iexa a laa sin xan tinaxaa ngali atsapngen xuxute. ");
INSERT INTO ncf_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","O biexaal di tsiili xan no untutule ma di ga tsaapi di ma sas amantei di. ");
INSERT INTO ncf_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Iwaa king asuk magaa buxa, a tulen xan no unmakmaxil ma di ga xosor atsoti abia no inaman di ta sas amantei no taamat, ma auki abia xadi inaman laba. ");
INSERT INTO ncf_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Mil ga asaaiti xan no untutule, ‘Biaa luxaal ina alaba a se taxaaturung, oro biaa di, iaa ta ilei ngali di ngali xaalame, di ga xap manglen abia nugu ililei ngali xaalame. ");
INSERT INTO ncf_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Biaabi, gim na laa sin no martsur ina sal dokdok ma gim na ilei ma giwaa xaal ngali xaalame sin luxaal ina alaba.’ ");
INSERT INTO ncf_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Biaa no untutule, di suk laa lalon no martsur ina sal ma di ga laa gii axumuli biaa no inaman di ta pupua ngali tatanginai di, no inaman axaau ma no inaman morokon bula. Biaa anua ina alaba asuk us taman no inawut. ");
INSERT INTO ncf_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Oro biaa iwaa king ta xaalame ngali le lasi no inawut, a suk lasi iexa taamat ta xap alen xaka uga disdis ina alaba. ");
INSERT INTO ncf_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ga atsuraa, ‘Turaaga, u sen tsiga we, u ta xap tamtuel lalon xa uga disdis ina alaba?’ Iwaa taamat asuk xap papaare. ");
INSERT INTO ncf_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Mil king ga asaaiti no untutule, ‘Gim pitsi ia sin no xaden ma no liman, ma gim na lii ia laa lokobel lalon lodo, biaa xolot no tineng ma angiririki no lian di.’ ");
INSERT INTO ncf_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Amuina Moroaa a ilei xuduxudu ngali xaalame, oro a xap xudu mu a inten tsaxali.” ");
INSERT INTO ncf_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","No Paarasi di suk atiltsoxoli ngali atutiki xaa sal ngali atsinaa ia sin xan no papaare. ");
INSERT INTO ncf_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Di tulen xadi no tsi asasing laa sin Iesu mii no Erodian ma di ga paare, “Unaasasing, giem atii malen iu taamat ina namaang so, ma num no asasing ina xan namaang Moroaa biaa ta laa mii soina. U xap putsi num adodo sin xa taamat amuina sin xan xalkale ta lapalaa. ");
INSERT INTO ncf_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Asaaiti mu giem num sen adodo? A tutiik ngali gita na uuli taakis laa sin Sisa o a xap?” ");
INSERT INTO ncf_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Oro Iesu a se atii tsaa xadi adodo tsaxa ma ga paare, “Gim no xalam lua ngalisa gim ta we gim na atsinaa iaa sin nugu no papaare? ");
INSERT INTO ncf_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Gim asen sin iaa biaa xuxute gim ta xaa uuli taakis taman.” Di ga tali nan denarias sin ia. ");
INSERT INTO ncf_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ma ga atsuraa di, “Tanuaan saa aila? Ma xan atatal saa abala?” ");
INSERT INTO ncf_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Di xisi, “Xan Sisa.” Mil ga asaaiti di, “Gim na tali sin Sisa sawe biaa xan Sisa, o gim na tali sin Moroaa sawe biaa xan Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Biaa di ta longmien xan totore di suk olol buxa. Di poroklii ia ma di suk exatsep loxona ia. ");
INSERT INTO ncf_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sin abia xuuk leng tsaa, no Saadusi biaa di ta paare we a xap xa tinapaas mula, di le tsap sangan taman xadi atsutsura. ");
INSERT INTO ncf_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Di paare, “Unaasasing, Moses tii asaaiti gita, nawe xa taamat a met ta xap xakaa tsi, turumasen na maxis sin aia aina nal sebula ngali atsapngen xakaa tsi turumasen. ");
INSERT INTO ncf_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Talaawaa tii paasaalua tumasen turumasen di ta manman lolobet ina giem. Iwaa tuaa ina tsi a maxis ma ga met, oro amuina ta xap xakaa tsi, a poroklii xan tubu sin turumasen. ");
INSERT INTO ncf_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Biaa uk namaang a tsap bula sin nan alua ina turumasen ma a laa bula sin nanaatuul, laa pupua sin apaasaalua ina turumasen. ");
INSERT INTO ncf_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Sin xapkap ina iwaa aina a met. ");
INSERT INTO ncf_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Biaabi sin tinapaas mula, xan tubu saa so ina di, sinsa apaasaalua ina di araraa di tii maxis sin?” ");
INSERT INTO ncf_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Iesu ga xisi, “Gim xap tutiik amuina gim xap atixi abia Inaatel Pat o xan xoror watwat Moroaa. ");
INSERT INTO ncf_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sin tinapaas mula no inaman di ba xap maxis ma di ba xap tali di ngali maxis; di ba malen no angelo nan balalangit. ");
INSERT INTO ncf_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Oro taman abia tinapaas mula ina no minet - gim xap xoxoti sen maarang Moroaa ta paare sin gim, ");
INSERT INTO ncf_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Iaa xan Moroaa Abaram, xan Moroaa Aisak, ma xan Moroaa Jakop.’ A xap ia Moroaa ina minet, oro ia Moroaa ina no inaman di ta tino.” ");
INSERT INTO ncf_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Biaa no malep di ta alongmen abala, di suk olol buxa sin xan asasing. ");
INSERT INTO ncf_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Biaa no Paarasi, di ta longmien malen Iesu a se abongi no Saadusi, di suk exumule. ");
INSERT INTO ncf_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Iexa ina no unsinaae ina lo, a xonon Iesu taman abala atsutsura. ");
INSERT INTO ncf_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Unaasasing, sen lo a lot buxa sin abala no lo.” ");
INSERT INTO ncf_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Iesu a xisi: “‘U na titii buxaai num Orong Moroaa taman num butsa araraa ma taman tanuaam araraa ma num adodo se araraa.’ ");
INSERT INTO ncf_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Balawaa se nan axuuk so ma xaraxin lo ina di se araraa. ");
INSERT INTO ncf_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma nanaalua ina lo, a malen abia nanaaxuuk: ‘U na titii buxaai no inaman atataaen iu malen iu tsaa.’ ");
INSERT INTO ncf_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","No lo araraa ma xadi no totore no propet di xaalame sin abala no lo ta lua.” ");
INSERT INTO ncf_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Biaa no Paarasi di ta exumule etudim tsaa, Iesu atsuraa di, ");
INSERT INTO ncf_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Gim sen adodo we ngali Karisito? Karisito ia xan tsi saa?” Di ga xisi, “Xan tsi Dewit.” ");
INSERT INTO ncf_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ga paare ngali di, “O ngalisa Dewit ta paare taman xan Nantanuan Moroaa, ga putsangi ia Orong? Amuina a paare, ");
INSERT INTO ncf_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ ‘Iwaa Orong a paare sin nugu Orong: “Tsotso sin nugu lima mua til sin iaa ba ta aturungi num no matenkorot paina no xaiim.” ’ ");
INSERT INTO ncf_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","O nawe Dewit a putsangi ia ‘Orong’, asen parawe we, ia xan tsi Dewit?” ");
INSERT INTO ncf_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Asuk xap xa na pupua ngali paatinai xa totore ngali xisi, xaal sin abia leng, di suk xap atsuraa ia taman xaa atsutsura bula amuina di mataa. ");
INSERT INTO ncf_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Mil Iesu ga asaaiti abia no malep ma xan no tsi asasing: ");
INSERT INTO ncf_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“No unaasasing ina lo ma no Paarasi, di asingan gim taman xan no lo araraa Moses. ");
INSERT INTO ncf_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Biaabi gim na amusili di ngali xosaraa no maarang araraa, di ta asaaiti gim taman. Oro gim nangaam xosaraa sawe di ta xoxosaraa, amuina di xap xonon ngali xosaraa sawe di ta baais taman. ");
INSERT INTO ncf_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Di rosriiti no mamaxet ma aturungi no papan no xalkalan biexaa inaman, oro di tsaa di xap siir ngali tulsen xa kakaalis ngali tiltsomi di. ");
INSERT INTO ncf_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“No maarang araraa di xosaraa ngali no inaman di ba lasi. Di xosaraa no bokis ngali ningning ta lot ma no mirmir ta tsirtsiir ta dis papan xadi no uga. ");
INSERT INTO ncf_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Di saan ngali no xalkale ina mangmangle sin no xariin luxaal ma no xalkale lapalaa lalon no Anua Sausawit. ");
INSERT INTO ncf_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Di saan ngali no inaman di na suei di taman mangmangle lalon no anua susune ma ngali biexaal di ba putsangi di Rabai. ");
INSERT INTO ncf_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Oro di ba xap putsangi gim ‘Rabai’, amuina nagim unaasasing axuuk ma gim no masen xan taamat araraa. ");
INSERT INTO ncf_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ma gim nangaam putsangi xa lalon abala xolkolmoxo ‘mom’, amuina nagim Mom axuuk ma a manman balalangit. ");
INSERT INTO ncf_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","O di ba xap putsangi gim ‘unaasasing’, amuina nagim Unaasasing axuuk mu iwaa Mesaia. ");
INSERT INTO ncf_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Iwaa ta lot buxa labatina gim naba tsap nagim untutule. ");
INSERT INTO ncf_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ngali no saa di ta aloti di tsaa, Moroaa naba adokdoki di, ma no saa di ta adokdoki di tsaa, Moroaa naba aloti di. ");
INSERT INTO ncf_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Xaraxin xirabas sin gim, no Paarasi ma no unaasasing ina lo gim no xalam lua! Gim tsaxil xaali Maradaan in balalangit papan no matan no inaman. Gim tsaa gim xap tsiga lalon ma gim xap papaalii biexaal di ta xonon ngali tsiga lalon. ");
INSERT INTO ncf_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Xaraxin xirabas sin gim no Paarasi ma no unaasasing ina lo, gim no xalam lua. Gim laa palpalaa papan pula ma lalaman ngali gii atsigili xa Gentail ngali tsap xa Jiu, ma biaa gim ta se xosor puaa gim asing atsoti ia, o gim ga xosaraa ia malen xa tsi in Edes so, malen gim tsaa. ");
INSERT INTO ncf_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Xaraxin xirabas sin gim, no matababa ina lalaamua! Gim we, ‘Nawe xa apuris sin Xan Anua Moroaa, biaa a maarang gomsaa oro nawe xa apuris sin goul ina Xan Anua Moroaa, a se xosaraa biaa xuxubu naba ta xap laxei.’ ");
INSERT INTO ncf_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Gim no matababa tangtangabaa! Sawe a lot buxa: biaa goul, o Xan Anua Moroaa biaa ta xosaraa abala goul ga tsap pat. ");
INSERT INTO ncf_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Gim bula gim paare, ‘Nawe xa apuris sin ibe tsutsungit, a maarang gomsaa mu; oro nawe xa apuris sin sen mat tinabel papan, a se xosaraa ngali biaa xuxubu naba xap laxei.’ ");
INSERT INTO ncf_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Gim no matababa! Sawe a suk lot buxa: tinabel, o ibe tsutsungit biaa ta apati tinabel? ");
INSERT INTO ncf_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Biaabi, saa ia ta puris sin ibe tsutsungit a puris ngali abia ma no maarang araraa papan bula. ");
INSERT INTO ncf_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma saa ia ta puris sin Xan Anua Moroaa, apuris sin abia Xan Anua Moroaa ma sin Moroaa iwaa ta manman lalon. ");
INSERT INTO ncf_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ma saa ia ta puris laa sin balalangit apuris laa sin xan niaan xalkale Moroaa ma sin Moroaa iwaa ta xalkale papan. ");
INSERT INTO ncf_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Xaraxin xirabas sin gim, no unaasasing ina lo ma no Paarasi, gim no xalam lua! Gim tali axuuk xolot ina sangaul ina nagim no spais, mint, dil ma kumin. Oro gim palolii biaa maarang lot buxa ina xan lo Moses, ininte tutiik, biirbirum ma tinaalnge. Gim na amusili biaa maarang ta lot buxa ina lo ma gim na xap adodolii ngali tali nagim axuuk xolot ina sangaul. ");
INSERT INTO ncf_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“Gim no lalaamua matababa, gim saali ngatangata o gim ga xonmen kemal! ");
INSERT INTO ncf_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Xaraxin xirabas sin gim, no unaasasing ina lo ma no Paarasi! Gim no xalam lua! Gim guraii axaautsi lokobel ina sobuk ma dis, oro lalon asuk us taman lulut ma gim saan ngali xaa daan maarang. ");
INSERT INTO ncf_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","No matababa ina Paarasi! Gim setauan guraii axaautsi lalon sobuk ma dis o mil lokobel ina bula naba suk mat mamainaang. ");
INSERT INTO ncf_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Xaraxin xirabas sin gim, no unaasasing ina lo ma no Paarasi! Gim no xalam lua! Gim malen abia no io di ta silii aiaasi no, biaa ta matmirmir lokobel, oro talaa lalon a us taman no tuen ina no tongaan ma no maarang araraa ta xap mixat. ");
INSERT INTO ncf_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Sin abia uk namaang, talaa lokobel gim tsap tutiik lalon no matan no inaman, oro lalon gim, auus taman daraxe ma no unlaklaxei lo. ");
INSERT INTO ncf_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Xaraxin xirabas sin gim, no unaasasing ina lo ma no Paarasi, gim no xalam lua! Gim tumaraa no lia pupuna ngali no propet ma gim amirmiri xadi no io no untutiik. ");
INSERT INTO ncf_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ma gim ga we, ‘Nawe gita nii tino sin abia no leng ina xida no iaaiaa, gita nii xap sas amantei no propet mii di.’ ");
INSERT INTO ncf_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Sin abia namaang, gim se paare leng we, gim tsaa xadi no utmilmil so abia di, di ta sas amantei no propet. ");
INSERT INTO ncf_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Lowas, gim na araraai sawe nagim no iaaiaa di tii atiltsoli. ");
INSERT INTO ncf_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Gim no tsitsi! Gim no tsi ina no tsitsi tsaxa! Gim ba sen sol xuxii we, sin xan ininte Moroaa sin gim ngali laa Edes? ");
INSERT INTO ncf_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Biaabi iaa ga tulen laa sin gim no propet ma no unsinaae ma no unaasasing. Biexaal gim ba sas amantei di ma ataxiwaa di papan tongol; biexaal gim ba ririiti di lalon no Anua Sausawit ma biexaal gim ba xalel atsuulngi di sin biexa inaman laba laa sin biexaa inaman laba. ");
INSERT INTO ncf_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Sin abala muina, gim ba saae atsoti gim taman xadi dal no untutiik biaa tii tamkabare papan pula xaal sin xan dal untutiik Abel laa sin xan dal Sekaraia xan tsi Berekia, iwaa gim ta sas amantei labatina Xan Anua Moroaa ma ibe tsutsungit. ");
INSERT INTO ncf_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Iaa asaaiti gim taman so, balawaa no maarang naba tsap sin abala nan ul. ");
INSERT INTO ncf_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O Jerusalem, Jerusalem, iu tii sas amantei no propet ma u ga pidi amantei abia di, Moroaa ta tulen di laangen sin iu. Saa puaa iaa ta lo saansili ngali gii axumuli num no tsi, malen puraa aina ta gii axumuli xan no puraa dokdok paina xan no paalpaal, oro u tii xap siir. ");
INSERT INTO ncf_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Lolong, num anua Moroaa, di se xosor atsoti. ");
INSERT INTO ncf_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Iaa asaaiti gim, gim ba xap lasi iaa bula pupua gim ba ta we, ‘Atubudaani aia xa ta xaalame sin iesan Orong.’ ” ");
INSERT INTO ncf_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesu a se papaalii Xan Anua Moroaa ma ga se es laa, biaa xan no tsi asasing di ga xaalame sangan ngali asen abia no tunumar. ");
INSERT INTO ncf_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ga atsuraa di, “Gim lasi bula abala no mat maarang? Iaa asaaiti gim taman so, di ba xap poroklii xa xaat na man papan biexa; di ba lii no xaat araraa lapula.” ");
INSERT INTO ncf_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Iesu a lo xalkale papan Buk Olip o no tsi asasing di ga le tiiriki xasinge. Di paare, “Asaaiti giem, naba tsap so langisa ma num no sen axixila sin num xaxaalame ma sin xapkap ina xolkolmoxo?” ");
INSERT INTO ncf_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Iesu a xisi, “Gim na xoxo axaau ma nangaam papaalii xa na apanaai gim. ");
INSERT INTO ncf_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Sinsa xuduxudu di ba xaalame sin iesan iaa, di ba paare we, ‘Iaa Karisito’, ma di ba apanaai xuduxudu. ");
INSERT INTO ncf_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Gim ba longmien no maxil ma inesaait ina no maxil oro gim na xap mata. Balawaa no maarang naba tsap setauan, oro xapkap ina tsaa biaa, naba ta xaalame. ");
INSERT INTO ncf_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Xobel labalaba naba epuske ngen iexa inaman labalaba ma maradaan naba epuske ngen iexa maradaan. No inaman di ba met sin itol ma ninil naba tsap lalon biexaa xobel. ");
INSERT INTO ncf_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Oro balawaa atiltsoxoli mu ina no xaraxin xirabas. ");
INSERT INTO ncf_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Di ba tsiili gim ngali gim ba alet sosong ma di na sas amantei gim. Amuina sin iesaaga, no inaman labalaba araraa di ba ngutsulen gim. ");
INSERT INTO ncf_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Sin abia leng, xuduxudu di ba taaltalu sin tinaalnge ma di na babel tali ma ngutsulen engen di. ");
INSERT INTO ncf_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ma no propet daraxe di ba asemat ngali apanaai xuduxudu ina inaman. ");
INSERT INTO ncf_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Amuina sin no unlaklaxei lo ta tsik, biaa titii sin xuduxudu naba madil. ");
INSERT INTO ncf_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Oro iwaa ta tilwatwat pupua sin xapkap naba adi tino. ");
INSERT INTO ncf_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ma balawaa inesaait mamainaang ina Maradaan di ba baais taman lalon xolkolmoxo araraa malen xa papaare leng sin no inaman labalaba araraa o mil, xapkap ina naba xaalame. ");
INSERT INTO ncf_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Biaabi biaa gim ta lasi abia maarang ta suk tsaxa buxa ta tiltil nan xolot ta pat, biaa se xaraxin namaang morokon ina minangel ta atsapngen xirabas biaa propet Daniel tii papaare taman. (Papaalii unxoxot na sinaae sin.) ");
INSERT INTO ncf_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Biaa gim ta manman Judaia gim na sol laa papan no buk. ");
INSERT INTO ncf_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nawe xa a manman papan unga ina anua, na xap tsiga ngali adi xawas lalon anua. ");
INSERT INTO ncf_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nawe xa a manman lalon uma na xap mula ngali laa adi xan uga disdis. ");
INSERT INTO ncf_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Xaraxin xirabas ngali abia no leng sin xa aina nawe a tiaan ma aina ta asus. ");
INSERT INTO ncf_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Gim na ningning ngali gim ba xap sol sin leng ina madil o sin Saabat. ");
INSERT INTO ncf_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Biaa naba tsap xaraxin leng tsaxa, naba xap arie pupua xaal sin atiltsoxoli ina xolkolmoxo pupua talaawaa ma naba xap tsap bula. ");
INSERT INTO ncf_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","“Nawe Moroaa nii xap apitpiti abia no leng naba xap xa na tino. Oro amuina sin Moroaa ta se axilangi xan no inaman tsaa, naba apitpiti abia no leng. ");
INSERT INTO ncf_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Sin abia leng nawe xa a paare ngali gim we, ‘Lasi, Karisito aila!’ o ‘Ilawaa se!’ nangaam taltaalnge sin. ");
INSERT INTO ncf_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Amuina no Karisito daraxe ma propet ababaa, di ba asemat ma atsapngen no xariin axixila ma no axixila xoror ngali apanaai xuduxudu ma nawe a pupua naba apanaai xan no inaman Moroaa. ");
INSERT INTO ncf_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Lolong, iaa se asaait setauan tsaa sin abia no leng naba ta tsap. ");
INSERT INTO ncf_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Biaabi nawe xa asaaiti gim we, ‘Ile lalon xolot biil,’ nangaam laa atia; o nawe xa a we, ‘Ila naanua,’ nangaam taltaalnge sin. ");
INSERT INTO ncf_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ngali xan tsinap xan Tsi Taamat naba malen di ta lasi tsilatsila biaa ta xaal nan selina ma na laa nan tudaan. ");
INSERT INTO ncf_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Itaa xa pakpak ina minet ta manman, no talagaa di ba exumule. ");
INSERT INTO ncf_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Sauna mu, mil sin abia no leng ina no xariin xirabas, “ ‘Matanios naba tsap lodo, ma uleng naba xap tsila; No xadaxada di ba xol xaal nan wang ma no xoror nan balalangit naba didiir.’ ");
INSERT INTO ncf_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Biaa xan axixila Xan Tsi Taamat naba asemat lapalaa balalangit ma no matenbung araraa lalon xolkolmoxo di ba lolbiir biaa di ba ta lasi xan Tsi Taamat naba ta xaalame lalon no xelangit ina balalangit taman xoror watwat ma xariin minaalam. ");
INSERT INTO ncf_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ma naba tulen xan no angelo taman xariin ngangaarare ina tail, di na giwaa biaa xan no ta se inten tsaxali xaal sin no matan maal ta et xaal sin xapkap ina balalangit laa sin biexa. ");
INSERT INTO ncf_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Talaawaa gim na asasing sin abala totore puapua ina aia ie fik. Biaa leng ina xan no laxe ta baal ma gim ba lasi xan no laalaa naba tsik tsuul, o gim ba se atii we leng ina pal a se atat. ");
INSERT INTO ncf_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Oro biaa gim ta lasi abala no maarang ta tsaptsap, gim ba se atii we leng a se xaalame atataaen matenmat. ");
INSERT INTO ncf_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Iaa asaaiti gim taman so balawaa utmilmil naba suk xap met pupua sin abala no mat maarang naba ta se tsap. ");
INSERT INTO ncf_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Balalangit ma pula naba xap, oro nugu no totore naba suk xap pupua ngali xap. ");
INSERT INTO ncf_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Oro a xap xa na atii leng ma aua, no angelo bula lalon balalangit di xap atii, o Xan Tsi bula, oro Mom mu atii. ");
INSERT INTO ncf_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","A malen mu sin xan no leng Noa, naba weaatia sin xan tsinap xan Tsi Taamat. ");
INSERT INTO ncf_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Sin abia no leng, setauan sin tuun, no inaman di tii angangen ma nunun, makmaxis ma taal tali di sin minaxis, laa pupua sin leng Noa ta tsiga lalon mono; mil daan tii ga tsabalen. ");
INSERT INTO ncf_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ma di tii ga xap atii senaara naba ta tsap pupua sin daan ta tsabalen adi di. Biaa se sawe naba tsap sin xan tsinap xan Tsi Taamat. ");
INSERT INTO ncf_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Alua no taamat lalon uma; iexa Xan Tsi Taamat naba giwaa o iexa naba paata. ");
INSERT INTO ncf_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","No aina alua delu ba iesei tapiok arie; iexa Xan Tsi Taamat naba giwaa o iexa naba paata. ");
INSERT INTO ncf_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Biaabi gim na xoxo amuina gim xap atii sin sen leng nagim Orong naba xaalame. ");
INSERT INTO ncf_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Oro gim na leng axaau sin abala: Nawe tapkina anua a se atii sin sen xolot ina leng nabing iwaa unpulapula naba xaalame, naba se xoxo liliis, ngali di na xap baxi xan anua ngali tsiga lalon. ");
INSERT INTO ncf_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Biaabi gim na taxaaturung bula amuina Xan Tsi Taamat naba xaalame sin abia xolot ina leng biaa gim ta xap adodo we naba xaalame. ");
INSERT INTO ncf_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Saa untutule aia ta taltaalnge ma ta sinaae, iwaa manmanel ta se aturungi ngali laamuangen no untutule lalon xan anua, ngali tabali di taman xadi no luxaal sin abia xolot ina leng so? ");
INSERT INTO ncf_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Manmanel naba suk atubudaani xan untutule biaa ta tatanginai ta xosaraa no tinaxaa sin xan inamula. ");
INSERT INTO ncf_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Iaa asaait gim so, manmanel naba axilangi ia ngali tilaamamil sin xan no mat maarang araraa. ");
INSERT INTO ncf_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Oro nawe iwaa untutule a tsaxa ma ga paare tsaa sin ia we, ‘Nugu manmanel a se laa man buxa sin no daan leng,’ ");
INSERT INTO ncf_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ma ga atiltsoli ngali tsaapi biexaa uk untutule, ma ga ngani no luxaal ma ga nun mii no unnunun. ");
INSERT INTO ncf_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Xan manmanel aia untutule naba xaalame sin leng ma xolot ina leng ta xap atii we naba xaalame. ");
INSERT INTO ncf_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Naba xotopen ia laa sin no xolot dokdok ma na tali ia laa sin xadi xobel no xalam lua ngali di ba tengteng ma angiririki no lian di. ");
INSERT INTO ncf_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Sin abia leng mu Maradaan in balalangit naba malen sangaul ina aina uul, di ta adi xadi no rarar ngali laa balsi taamat minaxis uul. ");
INSERT INTO ncf_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Alima ina di, di tangtangabaa o alima di sinaae. ");
INSERT INTO ncf_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Biaa di, di ta tangtangabaa di adi xadi no rarar mu oro di ga xap adi xadi xaa daanwe mii di. ");
INSERT INTO ncf_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Biaa di, di ta sinaae, di adi xadi no rarar mii xadi no daanwe lalon no botol. ");
INSERT INTO ncf_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Iwaa taamat minaxis uul a xap xaalame isagaa o di ga se maaii ma di ga suk urange. ");
INSERT INTO ncf_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Labatina bing biexa ililei atsap, ‘Minaxis uul se bia, gim tsuul xaalame ngali le sabasue ia!’ ");
INSERT INTO ncf_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Biaa no aina uul di pade ma di ga taxaaturungi xadi no rarar. ");
INSERT INTO ncf_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mil no aina tangtangabaa di paare ngali abia di, di ta sinaae, ‘Gim na tali nagiem xaa pu daanwe; nagiem no rarar a we na se met.’ ");
INSERT INTO ncf_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Di xisi, ‘A xap, naba xap pupua ngali gita araraa. Oro gim na laa sin abia di, di ta sune taman daanwe ngali gim ba laa uuli nagim xaal tsaa.’ ");
INSERT INTO ncf_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Biaa no aina di ta laa ngali uuli daanwe, iwaa taamat ta maxis uul asuk tsap. Biaa no aina uul di ta taxaaturung di suk tsiga mii laa lalon luxaal ina alaba o mat ga suk tsaxil. ");
INSERT INTO ncf_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Mil biaa no aina uul di se le tsap, di ga we, ‘Orong, Orong! Tsalali mat ngali giem!’ ");
INSERT INTO ncf_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Oro ga xisi, ‘Iaa suk asaaiti gim so, iaa suk xap atii gim.’ ");
INSERT INTO ncf_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Biaabi gim na xoxo, amuina gim xap atii leng o aua. ");
INSERT INTO ncf_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Naba sebula malen xa taamat ta laa sin xa ines palpalaa, ga ilei xan no untutule ma ga tali xan no tang sin di ngali di ba tilaamamil sin no. ");
INSERT INTO ncf_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A tali a lima no xiis goul sin axuuk, sin iexa, a lua o iexa, axuuk, ta pupua ngali detuu ba taxaa taman. Mil, ga laa sin abia ines. ");
INSERT INTO ncf_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Iwaa taamat ta adi no xiis goul ta lima, a laa taxaa taman o ga adi no xiis alima sebula papan. ");
INSERT INTO ncf_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ilawaa taamat bula taman no xiis goul ta lua a laa adi no xiis ta lua papan. ");
INSERT INTO ncf_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Oro iwaa ta adi xiis goul axuuk a laa ma xaii mat lalon pula ma ga axuina xan goul manmanel. ");
INSERT INTO ncf_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Iwaa xadetu manmanel abia no untutule a se laa man adis o ga se laa mula ma ga atutiki no xuxute mii detatuul. ");
INSERT INTO ncf_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Iwaa taamat ta adi no xiis goul ta lima, a tali no xiis goul ta lima papan. Ga paare, ‘Manmanel, u tali no xiis goul ta lima sin iaa. Lolong, iaa se xosaraa alima sebula.’ ");
INSERT INTO ncf_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Xan manmanel a xisi, ‘U suk xosor axaautsi tinaxaa! Iu untutule axaau ma iaa taalnge sin iu. U suk so sin abia no maarang ta xap xudu; Iaa ba tali abala no daan maarang sin iu ngali u ba tilaamamil sin no. Xaalame ma u na le taton mii iaa!’ ");
INSERT INTO ncf_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Iwaa taamat taman no xiis goul ta lua a xaalame bula ma ga paare, ‘Manmanel, u tali no xiis alua sin iaa; lolong, iaa se xosaraa alua sebula.’ ");
INSERT INTO ncf_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Xan manmanel a xisi, ‘U suk xosor axaautsi tinaxaa! Iu untutule axaau ma iaa taalnge sin iu. U suk so sin abia no maarang ta xap xudu; Iaa ba tali abala no daan maarang sin iu ngali u ba tilaamamil sin no. Xaalame ma u na le taton mii iaa!’ ");
INSERT INTO ncf_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Mil iwaa taamat ta adi xiis goul axuuk a se laa xaalame ma ga paare. ‘Manmanel, iaa atii we iu taamat makmagaa, u xaa paaski no luxaal u ta xap soxaa no ma axumuli no samaarang u ta xap xaaparen no purapura ina. ");
INSERT INTO ncf_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Biaabi iaa ga mataa ma iaa ga laa axuina abia num xiis goul lalon pula. Lasi, balawaa se abia num xiis.’ ");
INSERT INTO ncf_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Xan manmanel a xisi, ‘Iu taamat morokon, nan pelmet ina untutule! U ga atii we iaa xaa paaski no luxaal biaa iaa ta xap soxaa ma axumuli no samaarang iaa ta xap xaaparen no purapura ina. ");
INSERT INTO ncf_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Biaabi u na aturungi nugu no goul lalon anuen atuturung xuxute ngali biaa iaa ba mula iaa ba alet mulangenai xaa nen xuxute papan. ");
INSERT INTO ncf_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“‘Adi abia xiis goul sin ia ma u na tali sin aia taamat taman xan no xiis ta sangaul. ");
INSERT INTO ncf_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Saa ia ta ie was buxa, Moroaa naba taal buxaai sin, ma naba suk minaas buxa. Saa ia ta xap ie was buxa o nawe a ie was, Moroaa naba alet mulangen sin. ");
INSERT INTO ncf_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ma u na lii atsuulngi aia goraa pales ina untutule laa lokobel lalon lodo tiwaa naba ta tengteng ma angiririki no lian.’ ");
INSERT INTO ncf_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Biaa xan Tsi Taamat naba ta xaalame lalon xan minaalam mii no angelo araraa, naba tsotso papan xan niaan xalkale lalon xan minaalam. ");
INSERT INTO ncf_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","No inaman labalaba araraa di ba exumule laamuaan, ma naba exasenlii no inaman iexa sin iexa malen untilaamamil ina no sipsip ta exasenlii no sipsip sin no meme. ");
INSERT INTO ncf_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Naba aturungi no sipsip sin xan mua o no meme sin xan xaiaar. ");
INSERT INTO ncf_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Mil iwaa King naba paare sin abia di sin xan mua, ‘Gim xaalame, gim no saa, nugu Mom ta atubudaani; gim adi biaa xalkale gim ta momtsoli biaa Maradaan ta se taxaaturungi ngali gim atiltsoli sin axoxos ina xolkolmoxo. ");
INSERT INTO ncf_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Amuina iaa tii itol, gim tii tali pu luxaal ngali ngani; iaa tii marua, gim tii tali daan sin iaa ngali nun, iaa tii xaalame sangan gim, sin iaa tii xibong, oro gim tii suei atatoni iaa. ");
INSERT INTO ncf_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Iaa tii belbel o gim tii alen iaa, iaa tii maramase gim tii tilaamamil sin iaa, Iaa tii manman lalon anuen lodo gim tii le uwaa iaa.’ ");
INSERT INTO ncf_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Mil no untutiik di ba xisi ia, ‘Orong, langisa giem tii lasi iu, u tii itol ma giem ga tabali iu, O u tii marua ma giem ga tali daan sin iu ngali nun? ");
INSERT INTO ncf_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Langisa giem ta lasi iu malen xa xibong ma giem ga suei atatoni iu, o iu tii belbel ma giem ga alen iu? ");
INSERT INTO ncf_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Langisa giem tii lasi iu ta maramase o iu tii man lalon anua lodo ma giem ga tii laa uwaa iu?’ ");
INSERT INTO ncf_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Iwaa King naba xisi, ‘Iaa asaaiti gim taman so, semaarang gim ta xosaraa sin xa ina abala nugu no taamat, gim se xosaraa ngali iaa.’ ");
INSERT INTO ncf_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Mil naba paare ngali abia di, sin xaiaar, ‘Gim na papaalii iaa, biaa gim, di ta xororaa gim, ngali laa nan ie ta xap metmet, ta taxaaturung ngali maraanis ma xan no angelo. ");
INSERT INTO ncf_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Amuina iaa tii itol, gim ga xap tabali iaa ngali angen, iaa tii marua, gim ga xap anungi iaa, ");
INSERT INTO ncf_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","iaa tii xaalame sangan gim, malen xa xibong, ma gim ga xap suei atatoni iaa, Iaa tii belbel o gim tii ga xap alen iaa, iaa tii maramase ma iaa tii manman nan anua lodo o gim tii ga xap tilaamamil sin iaa.’ ");
INSERT INTO ncf_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Di ba xisi bula, ‘Orong, langisa giem ta lasi u ta itol o marua o xa xibong, o u ta belbel o u tii maramase o u tii man lalon anuen lodo ma giem ga tii xap tiltsomi iu?’ ");
INSERT INTO ncf_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Naba xisi, ‘Iaa asaaiti gim taman so, sawe gim tii xap xosaraa ngali xa ina abala no mat taamat, biaa gim tii xap xosaraa ngali iaa.’ ");
INSERT INTO ncf_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Mil King naba tulen di laa ngali adi sosong laaliu, oro no untutiik di ba adi tino laaliu.” ");
INSERT INTO ncf_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Biaa Iesu ta se paatinai araraai abia no maarang, ga asaaiti xan no tsi asasing, ");
INSERT INTO ncf_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Malen gim atii, no leng alua bula biaa ngali Esliwaa ma xan Tsi Taamat di ba babel tali sin xan no matenkorot ngali di ba ataxiwaa papan tongol.” ");
INSERT INTO ncf_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Biaa no lalaamua ina no unsausawit ma no xusaak ina no inaman di tsap exumule lalon xan anua Kaiapas iwaa unsausawit lapalaa. ");
INSERT INTO ncf_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Di ga ngiti ngali tsiil axuina ma sas amantei Iesu. ");
INSERT INTO ncf_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Oro di ga paare, “Na xap sin leng ina Esliwaa, o xa inesas naba soro tsap labatina no inaman.” ");
INSERT INTO ncf_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Biaa Iesu ta manman lalon inaman laba Betani, lalon xan anua Saimon iwaa tii se ie minet basbas, ");
INSERT INTO ncf_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","iexa aina a le tsiga taman biexa sobuk xaat taman daan tso xan iliil ta suk lot, ga le xabaren papan xuan Iesu sin ta matmatuul sangan ibe angangen. ");
INSERT INTO ncf_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Biaa xan no tsi asasing di ta lasi abala, di ga suk magaa, di ga atsura, “Ngali sa ta sar taman? ");
INSERT INTO ncf_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Gita pupua ngali sune taman abala daan tso ngali adi xaraxin xuxute ngali tali sin abia di, di ta muun.” ");
INSERT INTO ncf_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Iesu a atii abala ga paare ngali di, “Ngalisa gim ta magaa sin aila aina? A suk xosaraa namaang ta matmirmir sin iaa. ");
INSERT INTO ncf_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Iwaa muunwas naba tigiri manman mii gim oro iaa ba xap tigiri manman mii gim. ");
INSERT INTO ncf_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Biaa ta xabaren abala daan tso papan no isuaaga a taxaaturungi nugu pakpak ngali di ba punami. ");
INSERT INTO ncf_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Iaa asaaiti gim so, itaa di ta baais taman inesaait mamainaang lalon xolkolmoxo, sawe ta xosaraa di ba asaait taman, ngali adodomi ia.” ");
INSERT INTO ncf_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Judas Iskariot iexa ina abia sangaul axuuk ma ga laa lua ga laa sangan aia lalaamua ina no unsausawit. ");
INSERT INTO ncf_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ma ga atsura, “Gim ba tali sa sin iaa nawe iaa ba tali Iesu papan no liman gim?” Di ga uuli Judas taman no sangaul a tuul ina nen silwa. ");
INSERT INTO ncf_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Xaal atia laa, a se nanen ngali xa leng axaau, ngali tali Iesu. ");
INSERT INTO ncf_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Sin lalaamua ina leng, luxaal ina tsoki ta xap xa iis, no tsi asasing di xaalame sangan Iesu ma di ga atsuraa, “U saan ngali giem na taxaaturungi luxaal ina Esliwaa itaa?” ");
INSERT INTO ncf_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","A xisi, “Tsiga laa lalon inaman laba sangan iexa taamat ma gim na asaaiti, ‘Nagiem unaasasing a paare: nugu leng Moroaa ta axilangi a se atat! Iaa ba ngani luxaal ina Esliwaa mii nugu no tsi asasing lalon num anua.’” ");
INSERT INTO ncf_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ma no tsi asasing di ga xosaraa malen Iesu ta asaaiti di, di na taxaaturungi Luxaal ina Esliwaa. ");
INSERT INTO ncf_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Biaa ta se nale bingbing Iesu a matmatuul mii xan no tsi asasing ta sangaul axuuk ma ga laa lua sangan ibe angangen. ");
INSERT INTO ncf_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","O biaa di ta lo angangen, Iesu ga paare, “Iaa asaaiti gim taman so, xa ina gim naba babel tali iaa.” ");
INSERT INTO ncf_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Di ga suk lolbiir. O di xuxuuk, di ga paare ngali, “A suk so, a xap iaa, Orong?” ");
INSERT INTO ncf_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Iesu a xisi, “Iwaa xa ta iwaa liman mii iaa lalon abala dis naba babel tali iaa. ");
INSERT INTO ncf_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Xan Tsi Taamat naba met malen di ta se atalaa ngali ia. Oro xaraxin xirabas sin aia taamat ta babel tali Xan Tsi Taamat. Naba suk axaau buxa ngali di nii xap taana ia.” ");
INSERT INTO ncf_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Mil Judas, iwaa naba ta babel tali ia, a paare, “A xap iaa Rabai?” Iesu a xisi, “Iou iu mu.” ");
INSERT INTO ncf_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Biaa di ta lo angangen, Iesu a adi tsoki, ga putsangi axaau ga tsabaxi, ga tali sin xan no tsi asasing, ga we, “Gim adi ma gim na ngani, balawaa nugu pakpak.” ");
INSERT INTO ncf_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Mil ga adi sobuk, ma ga putsangi axaau ma ga tali sin di, ga paare, “Gim araraa, gim nun sin abala. ");
INSERT INTO ncf_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Balawaa nugu dal ina xuxubu, biaa ta tamkabare ngali no daan inaman ngali adodolii no namaang tsaxa. ");
INSERT INTO ncf_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Iaa asaaiti gim, iaa ba xap nun sin abala waain talaawaa pupua sin abia leng iaa ba ta sebula nun uul mii gim lalon xan Maradaan nugu Mom.” ");
INSERT INTO ncf_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Biaa di ta se anaanngi araraai iexa ananaan, di suk tsuul laa papan buk Olip. ");
INSERT INTO ncf_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mil Iesu ga asaaiti di, “Talaawaa nabing tsaa gim araraa gim ba xol palaaen iaa, amuina di tii atalaa abala: “ ‘Iaa ba sas amantei untilaamamil ina no xobel sipsip ma no sipsip di na sol exatsep.’ ");
INSERT INTO ncf_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Oro mil iaa ba ta tapaas mula, iaa ba laamuangen gim laa Galili.” ");
INSERT INTO ncf_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita a xisi, “Nawe di araraa di xol palaaen amuina sin iu, iaa ba suk xap xol palaaen.” ");
INSERT INTO ncf_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Iesu a xisi “Iaa asaaiti gim taman so, talaawaa tsaa nabing setauan sin puraa naba ta teng o u ba paare a tuul we, u xap atii iaa.” ");
INSERT INTO ncf_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Oro Pita ga asaaiti, “Oro nawe iaa met mii iu, iaa ba xap paare we, iaa xap atii iu. A suk xap.” No tsi asasing araraa di paare weaatia bula. ");
INSERT INTO ncf_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mil Iesu mii xan no tsi asasing di laa sin biexa xobel di ta putsangi Getsemani ma ga asaaiti di, “Gim tsotso atala ininti iaa ta ben laa atilie ngali laa sausawit.” ");
INSERT INTO ncf_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","A giwaa mii ia Pita ma xan no tsi Sebedi ta lua, ma ga suk lolbiir ma bal mamaet. ");
INSERT INTO ncf_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Mil ga asaaiti detatuul, “Nantanuaaga asuk lolbiir tsaxa biaa iaa ga saaen we iaa ba met. Gutuu manman atala ma gutuu na xoxo mii iaa.” ");
INSERT INTO ncf_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Iesu a es laa dokdok, mil ga tudu papan pula ma ga sausawit, “Nugu Mom nawe u pupua, saali abala sobuk ina mamaet sin iaa. Oro na xap nugu sirsiir, num sirsiir.” ");
INSERT INTO ncf_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mil ga mula o ga lasi xan no tsi asasing ta tuul detuu ta urange. Ga asaaiti Pita, “A xap pupua ngali gim naba xoxo mii iaa sin xa aua na xuuk? ");
INSERT INTO ncf_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Xoxo ma gutuu na sausawit ngali gutuu ba xap xol lalon xonkonon. Nantanuaam a siir oro no isua amaluaai.” ");
INSERT INTO ncf_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","A sebula mula nan alua ma ga sawit, “Nugu Mom, nawe u xap pupua ngali saali abala sobuk ina mamaet oro iaa na nun tsaa sin. Num sirsiir iaa ba xosor puaa.” ");
INSERT INTO ncf_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Biaa ta mula, a tatanginai detuu ta sebula urange, amuina no matan detatuul asuk mamaxet. ");
INSERT INTO ncf_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ma ga poroklii sebula detatuul ma ga laa sawit nanaatuul ma ga paare taman abia uk totore. ");
INSERT INTO ncf_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Mil ga mula laa sangan xan no tsi asasing ma ga paare ngali detatuul, “Gutuu urange ma iaawis tsaa? Gutuu lasi, aua a se xaalame ngali iwaa xa naba ta tali xan Tsi Taamat papan no liman no inaman tsaxa. ");
INSERT INTO ncf_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Gutuu tapaas! Gita laa! Iwaa xa naba ta babel tali iaa ila se.” ");
INSERT INTO ncf_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Biaa ta lo papaare tsaa, Judas, xa ina abia sangaul axuuk ma ga laa lua a se tsap, No lalaamua ina no unsausawit ma no xusaak di tulen abia xariin xumul ngali laa mii xadi no pubat ma no bom. ");
INSERT INTO ncf_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas iwaa unbababel a se tali axixila tsaa sin di ga we, “Gim ba tsiili aia, iaa ba ta nguri.” ");
INSERT INTO ncf_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas asuk es tutiik laa sangan Iesu ma ga we, “Nabing Rabai.” Mil ga nguri ia. ");
INSERT INTO ncf_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Iesu a xisi, “Turaaga, xosaraa sawe u ta xaalame ngali.” O no taamat di ga es tsuul ma di ga tsiili Iesu. ");
INSERT INTO ncf_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Sin abia, iexa taamat ta tsomi Iesu atataxaa ngali xan pubat, a irir tsaali ma ga ritlii talingan xan untutule unsausawit lapalaa. ");
INSERT INTO ncf_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Iesu ga asaaiti, “Aturung mulangen num pubat lalon niaan, amuina biaa di, di ta irir tsaali pubat, di ba met sin pubat. ");
INSERT INTO ncf_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Gim xap adodo we iaa xap pupua ngali ningi nugu Mom, ma talaawaa tsaa na tulen sangaul axuuk ma ga laa lua ina no xumul ina angelo ngali tiltsomi iaa? ");
INSERT INTO ncf_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Oro balawaa Inaatel Pat di ba sen xosor puaa we, biaa ta paare we, naba tsap weaatala?” ");
INSERT INTO ncf_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Sin abia aua Iesu ga paare ngali abia malep, “Asen parawe, iaa laamuangen xaa unpulapula o gim ga xaalame mii no pubat ma no bom ngali le tsiili iaa? Sin no daan leng iaa tsotso sangan bengbeng ina Xan Anua Moroaa ma iaa ga asingan no inaman o gim ga xap tsiili iaa. ");
INSERT INTO ncf_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Oro balawaa no maarang araraa a tsap ngali xosor puaa xadi atatal no propet.” O no tsi asasing di suk tapas poroklii ma di ga sol. ");
INSERT INTO ncf_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Biaa di, di ta tsiili Iesu di giwaa laa sin Kaiapas, iwaa unsausawit lapalaa, tiwaa, no unaasasing ina lo ma no xusaak di ta exumule. ");
INSERT INTO ncf_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Oro Pita a es amil tsaa palaaen Iesu, pupua sin xan xariin xolot iwaa unsausawit lapalaa. A tsiga ma ga tsotso mii no unxoxo ngali lasi sawe naba ta tsap. ");
INSERT INTO ncf_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","No lalaamua ina no unsausawit ma biaa Sanidrin xiduul di nanen ngali xa inaabaa sin Iesu ngali di ba amantei ia. ");
INSERT INTO ncf_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","No inaman di tii tsap taman xadi no inaabaa oro no kaunsel di tii ga xap tatanginai xaa inaabaa na lua ta arie pupua ngali ininte sin. Sin xapkap ina, no taamat delu lua, delu xaalame, ");
INSERT INTO ncf_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ma delu ga paare we, “Ilawaa taamat a paare we, ‘Iaa pupua ngali beklii abala Xan Anua Moroaa ma iaa ba tumar mulangen lalon no leng ta tuul.’ ” ");
INSERT INTO ncf_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","O mil iwaa unsausawit lapalaa ga til lapalaa ma ga paare ngali Iesu, “U ba xap xisi? Sen mat papaare leng abala lo taamat di ta lii ngali iu?” ");
INSERT INTO ncf_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Oro Iesu ga til adamis. Iwaa unsausawit lapalaa ga paare ngali, “Iaa atuti iu taman abala ma iaa ga puris sin aia Moroaa ta tino: U na asaaiti giem nawe iu Karisito, Xan Tsi Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Iesu a xisi, “Iou, biaa mu u ta paare taman. Oro iaa asaaiti gim se araraa: Talaa mil gim ba lasi xan Tsi Taamat naba tsotso sin lima mua ina iwaa Belaba ma naba xaalame papan no xelangit in balalangit.” ");
INSERT INTO ncf_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mil iwaa unsausawit lapalaa a taterlii xan uga disdis ma ga paare, “Ilawaa taamat a paare tsaxa sin Moroaa! Ngalisa tsaa gita ta saan ngali xaal ngali tiltsoxoti ia? Lasi talaawaa gim se longmien ta reret. ");
INSERT INTO ncf_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Gim sen adodo we?” Di xisi, “A se pupua mu, ngali na met.” ");
INSERT INTO ncf_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Mil di ga ubiisi no matan ma tuti ia taman no lape liman di. Biexaal di tabaii ia, ");
INSERT INTO ncf_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ma di ga paare, “Paare leng sin giem, Karisito. Saa tuti iu?” ");
INSERT INTO ncf_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Talaawaa Pita a se xalkale tia lokobel ina xan anua unsausawit lapalaa, o iexa tsaana untutule ga xaalame sangan ia, ga paare, “Iu bula u tii manman mii Iesu in Galili.” ");
INSERT INTO ncf_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Oro a ulis xaali abia so laamuaan di araraa. Ma ga paare, “Iaa xap atii senaara iu ta papaare taman.” ");
INSERT INTO ncf_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Mil ga sebula tsuul nan matenmat o iexa tsaana untutule ga lasi ia ma ga paare ngali no inaman atia, “Ilawaa taamat a eses mii Iesu in Nasaret.” ");
INSERT INTO ncf_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","A sebula ulis ma ga puris, “Iaa xap atii aia taamat!” ");
INSERT INTO ncf_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mil dokdok mu, biaa di, di ta tiltil tia di laa sangan Pita ma di ga paare, “Asuk so maase, iu bula ina di, nan xaliman iu tsaa asaait leng taman iu.” ");
INSERT INTO ncf_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mil ga atiltsoli ngali lii no xoror tsaxa papan ia ma ga puris sin di, “Iaa xap atii aia taamat!” O a xap sauna mu puraa a suk teng. ");
INSERT INTO ncf_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Mil Pita ga adodomi xan totore Iesu ta paare, “Setauan sin puraa naba ta teng u ba paare a tuul we, u xap atii iaa.” A tsuul laa lokobel ma ga suk teng buxa. ");
INSERT INTO ncf_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Lawaareng bingbing no lalaamua ina no unsausawit araraa ma xadi no xusaak no inaman di ngiti xadi no puapua ngali di ba sen sas amantei we, Iesu. ");
INSERT INTO ncf_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Di pitsi ia, ma di ga giwaa ia laa ngali tali ia sin Pailat iwaa gawana. ");
INSERT INTO ncf_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Biaa Judas iwaa ta babel tali ia, tii lasi malen di se atuti Iesu ngali sas amantei, tii suk lolbiir, ma ga taal mulanginai abia no sangaul a tuul ina nen silwa sin no lalaamua ina no unsausawit ma no xusaak. ");
INSERT INTO ncf_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ga we, “Iaa se xosaraa namaang tsaxa, ngali babel tali taamat iwaa ta suk xap xosaraa xawas na tsaxa.” Di xisi, “O samaarang abia sin giem? Num mamaet abia.” ");
INSERT INTO ncf_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ma Judas ga lii abia xuxute laa lalon Xan Anua Moroaa ma ga tsuul poroklii di. Mil ga laa ma alulua. ");
INSERT INTO ncf_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","No lalaamua ina no unsausawit di adi abia xuxute di ga we, “Balawaa xuxute gita uuli ngali sas amantei xa taamat taman, biaabi ga xap tutiik sin lo ngali gita na aturungi lalon niaan atuturung xuxute.” ");
INSERT INTO ncf_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ma di ga adodo ngali uuli pu pula sin iexa untumtumar kabalaa. Di ga xosaraa xadi kaka no inaman xibong. ");
INSERT INTO ncf_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ngali abala muina, di ga putsangi abia kaka talaawaa, “Pula ina dal.” ");
INSERT INTO ncf_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Biaa xan papaare propet Jeremaia a se taxaa puaa, “Di adi no sangaul a tuul ina nen silwa, xan iliil aia taamat sin no inaman Israel. ");
INSERT INTO ncf_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ma di ga uuli pu pula sin untumtumar kabalaa, malen Orong ta paare watwat sin iaa.” ");
INSERT INTO ncf_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Talaawaa Iesu a til laamuaan gawana ma ga atsuraa ia, “Iu xadi king no Jiu?” Iesu a xisi, “Iou, biaa malen u ta se paare.” ");
INSERT INTO ncf_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Biaa no lalaamua ina no unsausawit ma no xusaak di ta atut tali no maarang sin ia, o ga suk xap xisi di. ");
INSERT INTO ncf_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mil Pailat atsuraa ia, “Di atut tali abala no maarang tsaxa sin iu. U xap alongen di?” ");
INSERT INTO ncf_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Oro Iesu ga suk xap xisi, ma a xap xa pu totore na xuuk na tsuul o gawana ga suk olol. ");
INSERT INTO ncf_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Talaawaa xan namaang gawana, sin Luxaal ina Esliwaa ngali aleiwaai xa xaus, no inaman di ba ta axilangi. ");
INSERT INTO ncf_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Sin abia leng iexa xaus di ta suk leng axaau sin, xan iesan ilaa Iesu Baraabas. ");
INSERT INTO ncf_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","O mil biaa malep di ga exumule, Pailat ga atsuraa di, “Sen xaus so, gim saan ngali iaa ba aleiwaai? Gim saan ngali Iesu Baraabas o Iesu iwaa di ta putsangi Karisito?” ");
INSERT INTO ncf_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Amuina ia tii atii sin xadi no bal tsaxa biaa di ga tali Iesu laa sin ia. ");
INSERT INTO ncf_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Biaa Pailat ta lo tsotso sin niaan xalkale ina ininte, o xan tubu ga tulen biexa totore laa sin, a we, “Nangaam suk xosaraa xawas sin aia untutiik. Amuina, talaawaa, iaa se saaen xariin mamaet lalon binalang amuina sin ia.” ");
INSERT INTO ncf_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Oro no lalaamua ina no unsausawit ma no xusaak di atuali biaa malep ngali atsuraa ngali aleiwaai Baraabas o di na sas amantei Iesu. ");
INSERT INTO ncf_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pailat atsuraa abia malep sebula, “Sa so ina delulu gim saan ngali iaa ba aleiwaai?” Di xisi, “Baraabas!” ");
INSERT INTO ncf_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pailat a atsura di, “Iaa ba se xosaraa sa sin Iesu, iwaa di ta putsangi Karisito?” Di araraa, di xisi, “Ataxiwaa papan tongol.” ");
INSERT INTO ncf_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pailat atsura, “Ngalisa? Sen maarang tsaxa so a xosaraa?” Oro di ga xuup lot buxa, “Ataxiwaa papan tongol!” ");
INSERT INTO ncf_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Biaa Pailat ta lasi we a se xap xaka sal, oro epurutsaae tii se atiltsoli ngali tsap, adi daan ma ga guraii no liman laamuaan abia malep. A paare, “Iaa taamat leiwaa sin xan dal aila taamat, nagim maarang abia!” ");
INSERT INTO ncf_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","No inaman araraa di xisi, “Xan dal naba manman papan giem ma papan nagiem no tsi.” ");
INSERT INTO ncf_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Mil ga aleiwaai Baraabas laa sin di, oro no unmakmaxil di ririiti setauan Iesu mil di ba ataxiwaa papan tongol. ");
INSERT INTO ncf_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mil xan no unmakmaxil gawana, di giwaa Iesu laa lalon xan xaraxin anua gawana ma di araraa di ga le exumule sangan ia. ");
INSERT INTO ncf_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Di taterlii xan no uga disdis ma di ga alen tali uga disdis ta tok sin. ");
INSERT INTO ncf_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","O mil di ulsen no xoxon malen bungwal ma di ga aturungi papan xuan. Mil di ga aturungi paas lalon xan lima mua ma di ga sage putput laamuaan, ma di ga paare rereti ia, “Lasi, xadi King no Jiu!” ");
INSERT INTO ncf_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Di xamutsaa ma di ga adi paas, ma di ga lo panpantsi xuan. ");
INSERT INTO ncf_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mil sin di ta rereti ia, di saali uga disdis sin o di ga alen tali xan uga disdis tsaa o di laamuangen laa ngali ataxiwaa papan tongol. ");
INSERT INTO ncf_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Biaa di ta es laa, di sabasue iexa taamat in Sairin, iesan ila Saimon ma di ga atuaai ngali atsaxei abia tongol. ");
INSERT INTO ncf_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Di tsap sin abia xobel, di ta putsangi Golgaata (muina aweaatalaa “biaa Xobel ina Barang”). ");
INSERT INTO ncf_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Di tabali Iesu taman waain ngali nun, di ta putsi taman tubatuba ta xon bobo, oro mil sin ta xonon, tii xap saan ngali nunngi. ");
INSERT INTO ncf_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Biaa di ta se ataxiwaa papan tongol, di ga exasen xan no uga sin di ta uraura. ");
INSERT INTO ncf_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Di tsotso lapula ngali xoxo sin. ");
INSERT INTO ncf_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Lapalaa papan xuan di atalaa abala totore ngali atuti ia: Ilawaa Iesu iwaa xadi King no Jiu. ");
INSERT INTO ncf_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","No unpulapula alua di ataxiwaa mii ia, iexa sin xan lima mua iexa sin xan lima xaiaar. ");
INSERT INTO ncf_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","No inaman di xaa esliwaa o di ga rereti ma di ga luen no xuan di. ");
INSERT INTO ncf_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","O di ga paare, “Iu iwaa ta we, u ba beklii Xan Anua Moroaa ma u ba tumaraa sin no leng ta tuul. Aleiwaai iu tsaa. Nawe iu Xan Tsi Moroaa, u na tsuul lapula papan tongol.” ");
INSERT INTO ncf_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sin abia uk namaang no lalaamua ina no unsausawit ma no unaasasing ina lo ma no xusaak, di rereti ia. ");
INSERT INTO ncf_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Di paare, “Aleiwaai biexaal o ngalisa ta xap pupua ngali aleiwaai ia tsaa? Ia Xadi King no Israel. Papaalii na tsuul lapula talaawaa papan tongol ma gita ba taltaalnge sin ia. ");
INSERT INTO ncf_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","A paare we, ‘Iaa Xan Tsi Moroaa.’ A taalnge sin Moroaa, papaalii Moroaa na gii mulangen ia talaawaa nawe a saan ngali.” ");
INSERT INTO ncf_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Sin abia uk namaang biaa no unpulapula ta lua di ta ataxiwaa delu papan tongol mii ia, delu rereti ia bula. ");
INSERT INTO ncf_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Sin talu piaak laa pupua sin nan a tuul ina leng nale, lodo a baaii araraai balan pula. ");
INSERT INTO ncf_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nale sin a tuul ina leng Iesu a teng lot, “Eloi, Eloi, lemaa sabakatani?” (Muina abala, “Nugu Moroaa, Nugu Moroaa, ngalisa u ta papaalii iaa?”) ");
INSERT INTO ncf_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Biaa biexaal ina di, di ta tiltil tia di longmien abala, di ga paare, “A ilei Elaija.” ");
INSERT INTO ncf_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tiwaa tsaa iexa ina di a sol tapaas ma ga adi ututes. Ga utii taman waain manuul ta aturung tali sin paas ma ga tulis tali sin Iesu ngali na nun. ");
INSERT INTO ncf_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Biexaal, di ga paare, “Talaawaa u na poroklii ia. Gita ba lasi nawe Elaija naba xaalame ngali aleiwaai ia.” ");
INSERT INTO ncf_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ma biaa Iesu ga sebula teng lot, o ga poroklii nantanuaan. ");
INSERT INTO ncf_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Sin abia aua biaa taago lalon Xan Anua Moroaa, Moroaa asuk tater lua sin xaal tile lapalaa laa tulo lapula. Pula a gura ma no xaat ga tamxirek, ");
INSERT INTO ncf_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ma no lia pupuna a tabek ma ga tsalel, ma xadi no pakpak no inaman pat biaa di tii met di tino mula. ");
INSERT INTO ncf_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Di latsuul xaal lalon no lia pupuna mulina Iesu ta se tapaas mula, di laa lalon inaman laba pat ma di ga asemat sin no daan inaman. ");
INSERT INTO ncf_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Biaa lalaamua ina no unmakmaxil ma biaa di mii ia, di ta xoxo sin Iesu di lasi abia ninil ma biaa no maarang ta tsap, di suk mataa ma di ga teng lot, “Asuk so maase, ia Xan Tsi Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Xuduxudu ina no aina bula, di ta lo nanen palpalaa tsaa. Di tii amusili Iesu xaal Galili ngali tilaamamil sin sawe ta muun sin. ");
INSERT INTO ncf_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Labatina di, ilaa Maria Magdalin, Maria xan nagaa Jeims ma Josep, ma xan nagaa xan no tsi Sebedi. ");
INSERT INTO ncf_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Biaa ta se nale bingbing, iexa uniewas in Arimatia a laa xaalame, iesan ilaa Josep iwaa tii se tsap xan tsi asasing Iesu. ");
INSERT INTO ncf_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","A laa sin Pailat ga laa atsuraa ngali xan pakpak Iesu. Ma Pailat ga ning awatwati no unxoxo ngali tali xan pakpak Iesu laa sin ia. ");
INSERT INTO ncf_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josep adi pakpak ga ngaati taman laplap uul, ");
INSERT INTO ncf_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ma ga aturungi lalon xan lia pupuna uul tsaa, biaa tii se xaii lalon xaat. A puxen xariin xaat laamuaan sin mat tsigatsiga ina abia lia pupuna ma ga laa. ");
INSERT INTO ncf_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magdalin ma iexa Maria delulu lo xalkale sin biexa papel ina lia pupuna. ");
INSERT INTO ncf_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sin leng papan, mulina leng taxaaturung, no lalaamua ina no unsausawit ma no Paarasi di laa sangan Pailat. ");
INSERT INTO ncf_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Di paare, “Manmanel, giem adodomi we, biaa tii tino tsaa iwaa undadaraxe a we, ‘Mulina sin no leng ta tuul, iaa ba tapaas mula.’ ");
INSERT INTO ncf_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Lowas u na tali totore watwat ngali di na xoxo sin lia pupuna laa pupua sin nanaatuul ina leng. Xan no tsi asasing di ba soro le pulaxi xan pakpak di na asaaiti no inaman we, a se tapaas mula sin minet. Balawaa daraxe naba suk tsaxa buxa ngen biaa setauan.” ");
INSERT INTO ncf_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailat ga xisi, “Giwaa xaa unxoxo ngali tilkaali abia lia pupuna ngali naba watwat, malen gim ta atii.” ");
INSERT INTO ncf_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Biaabi di ga laa ma xosaraa awatwati abia mat ina lia pupuna, sin di ta aturungi barbar papan aia xaat ma di ga atilngi no unxoxo. ");
INSERT INTO ncf_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Mil sin Saabat, lawaareng bingbing sin nanaaxuuk ina leng, Maria Magdalin ma iexa Maria delu laa nanen nan lia pupuna. ");
INSERT INTO ncf_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Sauna mu xariin ninil, o xan angelo Orong a xaal balalangit ga laa sangan lia pupuna. A puxen mulangen xaat o ga xale papan. ");
INSERT INTO ncf_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Xan nanen asuk malen tsilatsila, o xan no uga disdis asuk iaas malen biso ina tuun. ");
INSERT INTO ncf_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","No unxoxo di suk mataa sin ma di ga didiir, ma di ga malen no taamat di ta se met. ");
INSERT INTO ncf_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Iwaa angelo a paare sin abia lo aina, “Gulu nangaam mataa, iaa atii gulu le nanen ngali Iesu, iwaa di tii ataxiwaa papan tongol. ");
INSERT INTO ncf_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","A xap manman, atala! A se tapaas mula, malen tii se paare. Gulu xaalame, le lasi niaan tii matul sin. ");
INSERT INTO ncf_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Gulu laa isagaa ma gulu na laa asaaiti xan no tsi asasing, ‘A se tapaas mula sin minet o ga se laamuangen gim laa Galili. Tiwaa gim ba lasi ia.’ Talaawaa iaa se asaaiti gululu.” ");
INSERT INTO ncf_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Mil lo aina delu isagaa papaalii lia pupuna, delu mataa oro delu taton bula, delu ga sol laa ngali asaaiti xan no tsi asasing. ");
INSERT INTO ncf_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Sauna mu, Iesu ga sabasue delulu, ga paare, “Lawaareng.” Delulu ga xaalame sangan ma delulu ga taana no xaden ma delulu ga langaari sin. ");
INSERT INTO ncf_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Mil Iesu ga asaaiti delu, “Gulu nangaam mataa! Gulu laa asaaiti nugu no taamat ngali di na laa Galili, di ba lasi iaa atia.” ");
INSERT INTO ncf_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","No aina delulu lo es laalaa o biexaa unxoxo di laa lalon inaman laba. Di atolomi xadi inaatalem sin no lalaamua ina no unsausawit taman no maarang araraa ta tsap. ");
INSERT INTO ncf_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Biaa no lalaamua ina no unsausawit, di ga exumule mii no xusaak ma di ga ngiti xa namaang morokon ma di ga tali xaraxin xuxute sin no unmakmaxil. ");
INSERT INTO ncf_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Di ga asaaiti di, “Gim ba paare we, ‘Xan no tsi asasing Iesu, di xaalame nabing di ga pulaxi ia, sin giem ta urarange.’ ");
INSERT INTO ncf_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nawe balawaa inaatalem a tsap sin gawana, giem ba atuali ia taman no totore ma giem ba tilkaali gim sin sen mamaet.” ");
INSERT INTO ncf_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Biaa no unmakmaxil di ga adi abia tang ma di ga xosaraa malen di ta se asaaiti di. Ma balawaa inaatalem ga tii sol puaa no Jiu le pupua talaawaa. ");
INSERT INTO ncf_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Mil biaa sangaul axuuk ma ga laa xuuk ina no tsi asasing, di ga laa Galili sin biaa buk biaa Iesu tii asaaiti di taman ngali di ba laa sin. ");
INSERT INTO ncf_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Biaa di ta lasi ia di suk langaari laa sin; oro biexaal xadi no adodo a xudu. ");
INSERT INTO ncf_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Iesu ga xaalame sangan di ma ga paare we, “Biaa banam araraa in balalangit ma papan pula, nugu Mom tii se tali sin iaa. ");
INSERT INTO ncf_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Biaabi gim na laa atsapngen xaa tsi asasing sin no inaman labalaba araraa, ma gim na axadaani di sin iesan Mom ma ina xan Tsi ma ina Nantanua Pat, ");
INSERT INTO ncf_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ma gim na asingan di ngali lolong amusili biaa no mat maarang araraa iaa ta paare watwat sin gim ngali xosaraa. Iaa asaaiti gim taman so, iaa ba manman mii gim sin no leng araraa laa pupua sin xapkap ina xolkolmoxo.” ");
INSERT INTO ncf_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Balawaa atiltsoli ina inesaait mamainaang, xan Iesu Karisito xan Tsi Moroaa. ");
INSERT INTO ncf_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Malen Aisaia iwaa propet ta paare weaatalaa: “Iaa ba tulen nugu ngutsu laamuangen iu. Iwaa naba ta taxaaturungi num sal.” ");
INSERT INTO ncf_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Inan xa a ililei lalon xobel biil, ‘Taxaaturungi xan sal Orong, xosaraa xan sal na tutiik.’ ” ");
INSERT INTO ncf_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","O Jon Unaaxaxadaan a xaalame ga axadaani no inaman lalon xolot biil, ga baais taman axaxadaan ngali puxisbal, ma ngali adodolii no namaang tsaxa. ");
INSERT INTO ncf_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","No daan inaman sin no xolot araraa Judaia ma no inaman araraa Jerusalem di tsuul laa sangan Jon. Di asaait leng taman xadi no namaang tsaxa ma Jon ga axadaani di lalon daansel Jodan. ");
INSERT INTO ncf_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon alen uga di ta xosaraa taman xan no ulina kemal ma xan biaal ulti balan, di xosaraa taman xilkil ina matauteng, ma ga xaa ngani no tsik ma matsii in lauteng. ");
INSERT INTO ncf_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","A baais ma ga paare we, “Iexa ia naba xaalame mil sin iaa, xan xoror a watwat buxa ngen nugu watwat. Iaa xap muun axaau buxa ngali sage putput ma ngali lubati no sua sin xan no bubut. ");
INSERT INTO ncf_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Iaa axadaani gim taman daan, oro ia naba axadaani gim taman Nantanua Pat.” ");
INSERT INTO ncf_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sin abia leng Iesu a es xaal Nasaret lalon Galili ma Jon ga axadaani ia lalon daansel Jodan. ");
INSERT INTO ncf_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Sauna mu biaa Iesu tii se sobet tsuul xaal lalon daan, balalangit asuk tsalel, ma Jon ga lasi Nantanua ta soriri xaalame papan malen buna. ");
INSERT INTO ncf_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma inan xa axaal balalangit ga paare we, “Iu mu nugu tsi iwaa iaa ta titii buxaai, iwaa iaa ta taton sin.” ");
INSERT INTO ncf_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tiwaa tsaa, Nantanua ga tulenlii laa nan biil. ");
INSERT INTO ncf_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ma ga man nan biil no sangaul aet ina no leng mii no matauteng, o Saatan ga xonon, o no angelo di ga le tilaamamil sin. ");
INSERT INTO ncf_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mulina di se tali Jon lalon anua lodo, Iesu a laa Galili ma ga baais taman xan inesaait mamainaang Moroaa. ");
INSERT INTO ncf_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ga paare, “Leng a se tsap. Xan Maradaan Moroaa a se atat. Gim na puxisbal ma taltaalnge sin inesaait mamainaang.” ");
INSERT INTO ncf_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Biaa Iesu ta lo eses sin gelgel ina daan ulis Galili, a lasi Saimon mii turamasen Endru. Delu no untsunolau ma delu lo liilii uben lalon daan ulis. ");
INSERT INTO ncf_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Iesu ga we, “Gululu xaalame amusili iaa ngali iaa ba asingan gululu taman tsunolau ngali gii inaman.” ");
INSERT INTO ncf_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tiwaa tsaa delu papaalii xadelu no uben ma delu ga amusili Iesu. ");
INSERT INTO ncf_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Biaa ta es laa dokdok tsaa, ga lasi lo masen turamasen ilaa Jeims ma Jon, xan no tsi Sebedi. Delu lo taxaaturungi xadetu no uben papan xadetu mono. ");
INSERT INTO ncf_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tiwaa tsaa a ilei delulu ma delulu ga papaalii xadelulu mom Sebedi lalon mono mii no untinaxaa ma delulu ga amusili ia. ");
INSERT INTO ncf_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Di ga laa Kaperanaam ma mulina mu biaa Saabat ta se laa xaalame, Iesu a laa lalon anua sausawit ma ga atiltsoli ngali taal asasing. ");
INSERT INTO ncf_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","No inaman di suk tunga sin xan no asasing, amuina asingan di malen xa a ie banam. A xap malen abia no unaasasing ina lo. ");
INSERT INTO ncf_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mulina mu, iexa taamat lalon xadi anua sausawit, iwaa no tanua tsaxa di ta tsigaii, ga xuup lot, ");
INSERT INTO ncf_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Iesu in Nasaret! U saan ngali sa sin giem? U xaalame ngali tsaalen giem? Iaa atii iu saa. Iu iwaa Xa ta Pat xan Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iesu a atewaai di, “U na bong! Tsuul papaalii aia taamat!” ");
INSERT INTO ncf_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Iwaa tanua tsaxa atsaaparen buxaai iwaa taamat ma ga xuup lot ma ga tsuul papaalii aia taamat. ");
INSERT INTO ncf_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","No daan inaman di suk olol. Di etsura ngen di, “Sawe abala? Xa asasing uul, ma taman abia banam! A tulenlii bula abia no tanua tsaxa ma di ga lolong amusili ia.” ");
INSERT INTO ncf_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Inesaait ina ia asuk sol isagaa laa lalon abia no xolot araraa ina prowins Galili. ");
INSERT INTO ncf_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Mulina mu di ta papaalii anua sausawit, di laa mii Jeims ma Jon ma di ga tsiga laa lalon xan anua Saimon ma Endru. ");
INSERT INTO ncf_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Xan xoxup Saimon a maramase taman isua lalep papan ibe, ma di ga asaaiti Iesu taman. ");
INSERT INTO ncf_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ma ga laa sangan, a taxaana liman ma ga atapaasi. Biaa isua lalep apapaali ia ma ga suk taxaaturungi luxaal ngali di. ");
INSERT INTO ncf_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Biaa ta se nale bingbing mulina matanios ta tsurii, no inaman di le tali no inaman araraa di ta ie minet sin Iesu ma biaa di bula no salawa tsaxa di ta tsigaii di. ");
INSERT INTO ncf_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Biaa no inaman araraa lalon abia inaman laba di le tsap esuei matan abia anua. ");
INSERT INTO ncf_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ma Iesu ga atoaa xuduxudu biaa di ta ie no mat laxen minet, ma ga saali bula no daan salawa tsaxa oro a xap papaalii no salawa tsaxa ngali di na papaare amuina di atixi ia saa. ");
INSERT INTO ncf_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Lawaareng bingbing ta lodo tsaa, Iesu a pade ma ga tsuul papaalii anua. A laa sin biexa xolot biil ngali sawit. ");
INSERT INTO ncf_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Mil Saimon ma no turan di, di ga laa nanen ngali ia. ");
INSERT INTO ncf_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","O biaa di ta se laa tatanginai, di suk paare sin, “No inaman araraa di tsaltsalei iu!” ");
INSERT INTO ncf_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Iesu a xisi di ga we, “Gita laa nan xa xolot atataaen no xobel ngali iaa ba baais lalon abia no xolot. Balawaa se muina, iaa ga xaalame atala.” ");
INSERT INTO ncf_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ma ga laa nan no xolot araraa Galili ma ga babaais lalon xadi no anua sausawit ma ga saali no salawa tsaxa sin no inaman. ");
INSERT INTO ncf_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Iexa taamat taman minet basbas a xaalame, ga sage putput ma ga ningi Iesu, “Nawe u siir, u na auuli iaa.” ");
INSERT INTO ncf_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iesu asuk titii buxaai aia taamat, a tulsen liman, ma ga taana aia taamat ma ga paare, “Iaa siir, u na tsap uul!” ");
INSERT INTO ncf_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tiwaa tsaa, minet basbas a papaalii aia taamat ma ga se tuo. ");
INSERT INTO ncf_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Iesu ga tulenlii isagaa laa, taman papaare watwat ngali atewaai ia, ");
INSERT INTO ncf_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Nangaam asaaiti xaal taman abala, oro laa mu ma u na asen no isuaam sin unsausawit ma u na tun axaii num tinabel malen Moses ta paare watwat taman, ngali num atotoaa, naba malen papaare leng sin di.” ");
INSERT INTO ncf_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Oro iwaa taamat a es tsuul ma ga atiltsoli ngali paare leng taman abia inesaait sin no inaman araraa. Sin abia muina, Iesu a se xap pupua ngali tsigaii gomsaai xa inaman laba oro ga manman lokobel nan no biil. No inaman di xaalame tsaa sangan, xaal sin no daan xolot. ");
INSERT INTO ncf_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mulina biexaa nen leng, Iesu tii sebula tsiga Kaperanaam. Inesaait ina Iesu no inaman di tii longmien we a se mula xaalame lokobel. ");
INSERT INTO ncf_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Xuduxudu ina inaman di exumule biaabi ga xap xa xolot na leiwaa lalon anua ma lokobel ina matenmat, ma ga baais taman abia totore sin di. ");
INSERT INTO ncf_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Biexaa taamat ta et di alet xaalame ngen taamat isua met. ");
INSERT INTO ncf_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Oro di xap pupua ngali tali aia taamat sin Iesu, amuina sin abia xumkumul. Di ga tseng alen lapalaa papan xuan anua tutiik sin Iesu, di ga a soriri xabangas taman isua met. ");
INSERT INTO ncf_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Biaa Iesu tii lasi xadi tinaalnge, ga paare ngali aia taamat isua met, “Nugu tsi num no namaang tsaxa iaa se adodolii no.” ");
INSERT INTO ncf_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Talaawaa biexaa unaasasing ina lo di ta tsotso tia, di adodo lalon xadi no butsa, di ga paare, ");
INSERT INTO ncf_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ngalisa ilawaa taamat ta paare weaatalaa? A reret ngen Moroaa. Saa pupua ngali adodolii no namaang tsaxa oro Moroaa mu?” ");
INSERT INTO ncf_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tiwaa tsaa Iesu atixi lalon nantanuaan, sen maarang di ta adodo amusili o ga paare sin di, “Ngalisa gim ta adodo lalon nagim no butsa taman abala no maarang? ");
INSERT INTO ncf_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Sawe a malus ngali paare sin aila isua met, ‘Num no namaang tsaxa iaa se adodolii,’ o ngali paare we, ‘Tapaas, adi num xabangas ma u na eses?’ ");
INSERT INTO ncf_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Oro ngali gim ba atii we, Xan Tsi Taamat a ie banam lalon xolkolmoxo ngali adodolii namaang tsaxa.” Iesu ga asaaiti aia taamat isua met, ");
INSERT INTO ncf_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Iaa asaaiti iu, tapaas, adi num xabangas ma u na laa tataam.” ");
INSERT INTO ncf_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tiwaa tsaa a tapaas, adi xan xabangas ma asuk es tsuul papan no matan no daan inaman araraa. Ma no inaman di suk tunga ma di ga paʼii Moroaa di ga we, “Giem tii xap mager lasi xawas weaatalaa!” ");
INSERT INTO ncf_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesu a sebula mula laa lalon daan ulis. No daan inaman di amusili laa lalon abia xolot ma tii taal asasing sin no inaman. ");
INSERT INTO ncf_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Biaa ta lo eses laa, asuk lasi Liwai xan tsi ilaa Alpias, ta xalkale lalon anuen taakis. Iesu ga paare ngali, “Amusili iaa.” Liwai a tapaas ma ga amusili ia. ");
INSERT INTO ncf_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Biaa Iesu ta angangen lalon xan anua Liwai. Xuduxudu ina no unaalalet taakis ma no untsaxa di angangen mii Iesu ma xan no tsi asasing bula, amuina xuduxudu ina di, di amusili Iesu. ");
INSERT INTO ncf_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Biaa no unaasasing ina lo biaa no Paarasi di ta lasi Iesu, ta angen mii no unaalalet taakis ma no untsaxa, di ga atsuraa abia xan no tsi asasing, “Ngalisa ta angen mii no inaman di ta alalet taakis ma no untsaxa?” ");
INSERT INTO ncf_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Iesu alongmen abalaa, ga paare sin di, “No inaman axaau di xap saansili untubatuba. Oro biaa mu di, di ta ie minet di saansili untubatuba. Iaa tii xap xaalame ngali ilei no inaman tutiik, oro ngali no untsaxa.” ");
INSERT INTO ncf_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Sin leng xan no tsi asasing Jon ma no Paarasi di el, biexaa inaman di xaalame ma di ga atsuraa Iesu, “Asen parawe xan no tsi asasing Jon ma xadi no Paarasi di ta el, oro num no tsi asasing di xap el.” ");
INSERT INTO ncf_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iesu a xisi di, “Biaa xan no xibong aia taamat ta we na maxis di ba sen el we, nawe iwaa taamat ta wena maxis a manman tsaa mii di? Di xap pupua, sinsa taamat ta wena maxis a manman tsaa mii di. ");
INSERT INTO ncf_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Oro leng naba ta xaalame biaa di ba gii mulangen taamat ta wena maxis sin di, o sin abia leng di ba el. ");
INSERT INTO ncf_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“A xap xa na tsik tali laplap uul ngali xabati tater ina laplap xabaar, biaa pu laplap uul naba tsiip ma na tatari abia laplap xabaar, biaabi naba suk tater lot. ");
INSERT INTO ncf_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","A xap xa na pupua ngali tiitiiri waain uul laa lalon no xilkil ina waain xabaar, nawe aweaatia biaa waain uul naba pupuet o sobuk na pak, o biaa waain ma biaa xilkil naba suk tsaxa araraa. Naba axaau na ut tuali waain uul laa lalon xilkil ina waain uul.” ");
INSERT INTO ncf_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sin biexa Saabat Iesu tii eses lalon uma wit mii xan no tsi asasing, o xan no tsi asasing di ga paaski no xalitsa ina wit. ");
INSERT INTO ncf_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","No Paarasi di ga paare ngali Iesu, “Lasi, ngalisa di ta xosaraa abala, di ta xap manglen Saabat?” ");
INSERT INTO ncf_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Iesu a xisi, “Gim xap muun xoxoti sen maarang Dewit tii xosaraa mii xan no turan, biaa di tii itol ma muun? ");
INSERT INTO ncf_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Sin xan no leng Abiata unsausawit lapalaa, Dewit tii tsiga lalon Xan Anua Moroaa ma ga ngani tsoki pat ta pupua mu ngali no unsausawit di ba ngani, ma ga tabali bula no turan.” ");
INSERT INTO ncf_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ma ga paare ngali di, “Moroaa a xosaraa Saabat ngali xan axaau taamat ma a xap xosaraa taamat ngali Saabat. ");
INSERT INTO ncf_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Biaabi Xan Tsi Taamat, ia Orong ina Saabat bula.” ");
INSERT INTO ncf_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Biexa leng Iesu atsiga laa lalon anua sausawit, o iexa taamat liman ta met bula ia tia. ");
INSERT INTO ncf_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Biexaa inaman atia di lo nen tsaltsalei xa sal ngali atuti Iesu, ma di ga lo xoxoen ngali lasi nawe naba atoaa aia taamat sin Saabat. ");
INSERT INTO ncf_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Iesu a paare sin iwaa taamat lima met, “Til laamuaan no matan abala no inaman araraa.” ");
INSERT INTO ncf_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Mil Iesu ga atsuraa no inaman, “Sen namaang a tutiik sin Saabat: ngali xosaraa namaang mamainaang o ngali xosaraa namaang morokon? Ngali atoaa xa o ngali sas amantei xa?” Oro di suk xale bong mu. ");
INSERT INTO ncf_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iesu asuk magaa ma ga atsoxaa ariiti di. Ma ga suk lolbiir amuina xadi no butsa a taban. Mil ga paare sin iwaa taamat, “Apalasaa limaam.” Iwaa taamat apalasaa liman ma ga sebula axaau. ");
INSERT INTO ncf_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tiwaa tsaa no Paarasi mii no Erodian di suk tsalei xa sal ngali sas amantei Iesu. ");
INSERT INTO ncf_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesu a tapaas laa mii xan no tsi asasing laa sangan daan ulis, ma xaraxin malep in Galili di ga amusili ia. ");
INSERT INTO ncf_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Di xaalame amuina di se longmien no mat maarang Iesu ta xosaraa no. Biexaa inaman di xaal Judaia, tia Jerusalem, ma Idumea, ma sin no xolot xaatalaa ina daansel Jodan ma sin no xolot Taia ma Sidon. ");
INSERT INTO ncf_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","A lasi abia malep o ga asaaiti xan no tsi asasing ngali di na taxaaturungi xa tsiibi dokdok ngali ia. A saan ngali xa tsiibi dokdok amuina a palo ngali abia malep na asuruti ia. ");
INSERT INTO ncf_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Amuina a se atoaa no daan inaman o biaa no inaman taman no mat minet di lo esurut ngen di laa laamua ngali taxaana Iesu. ");
INSERT INTO ncf_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Biexaal di ie salawa tsaxa lalon di. Biaa no salawa di xaa lasi Iesu, di xaa xol lapula laamuaan ia ma di ga xuup weaatalaa, “Iu xan Tsi Moroaa!” ");
INSERT INTO ncf_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Oro, Iesu a imii no salawa ngali di na xap asaait leng taman ia, saa so. ");
INSERT INTO ncf_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Mil Iesu ga laa lapalaa papan buk ma ga ilei biexaa taamat ngali di na xaalame sangan ia, ma di ga laa lapalaa sangan Iesu. ");
INSERT INTO ncf_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Iesu axilangi sangaul ma ga laa lua ina taamat ma ga a tso iesani di no Aposal, ngali di ba manman mii ia ngali naba tulen laangen di sin biexaa xobel ngali babaais. ");
INSERT INTO ncf_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma di ie banam ngali saali no salawa tsaxa. ");
INSERT INTO ncf_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Balawaa se sangaul axuuk ma ga laa lua ina taamat ta axilangi di: Saimon (iwaa Iesu ta a tso iesani Pita); ");
INSERT INTO ncf_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jeims ma Jon xan no tsi Sebedi (Iesu a tso iesani di Boaneges, muina balawaa ies aweaatalaa, No tsi ina Parparariek); ");
INSERT INTO ncf_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Endru, Pilip, Batalomiu, Metiu, Tomas, ma Jeims xan tsi ilaa Alpias, Tadeas, Saimon ia ina no Silot, ");
INSERT INTO ncf_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ma Judas Iskariot iwaa ta babel tali ia. ");
INSERT INTO ncf_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Mil Iesu ga tsiga lalon anua ma no malep di sebula exumule sangan ia. Biaabi ia ma xan no tsi asasing di ga xap pupua ngali angen. ");
INSERT INTO ncf_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Biaa xan matenaanua Iesu di ta alongmen abala no maarang, di ga laa ngali giwaa ia amuina no inaman di we, “Xan no adodo a tangtangabaa.” ");
INSERT INTO ncf_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ma no unaasasing ina lo di ta xaal lapula Jerusalem di we, “Belsabap atsigaii aia! Iwaa lalaamua ina no salawa ta tali watwat sin ia ngali saali no salawa.” ");
INSERT INTO ncf_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","O Iesu ga ilei no inaman di ga exumule, ma ga paatinai no totore puapua. Iesu ga we, “Saatan naba sen pupua we ngali saali Saatan? ");
INSERT INTO ncf_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nawe xa maradaan a exasen ia tsaa, biaa maradaan naba suk xap pupua ngali tilwatwat. ");
INSERT INTO ncf_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nawe xa matenaanua a exasen ia tsaa, biaa matenaanua naba xap pupua ngali tilwatwat. ");
INSERT INTO ncf_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ma nawe Saatan a epuske mii ia tsaa, ga se exasen ia ma naba xap pupua ngali tilwatwat, ma xan xapkap ina a se xaalame. ");
INSERT INTO ncf_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","A suk so maase, a xap xa na pupua ngali tsiga lalon xan anua xa taamat watwat ngali pulaxi xan no mat maarang, oro setauan na pis atingtingi iwaa taamat watwat. Mil naa pulaxi no mat maarang lalon anua. ");
INSERT INTO ncf_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Iaa asaaiti gim taman so, no namaang tsaxa araraa ma xadi no reret no inaman, Moroaa naba adodolii no. ");
INSERT INTO ncf_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Oro saa ia ta reret ngali epuske sin Nantanua Pat, Moroaa naba xap pupua ngali adodolii. Moroaa naba ininte sin xan namaang tsaxa laaliu.” ");
INSERT INTO ncf_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesu a paare taman abala amuina, di paare we, “Salawa tsaxa atsigaii ia.” ");
INSERT INTO ncf_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mil xan nagaa Iesu ma xan no turamasen di le tsap. Di tiltil lokobel ma di ga tulen iexa taamat ngali ilei tsoli ia. ");
INSERT INTO ncf_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Biaa malep di ta tsotso ulti Iesu, di ga asaaiti ia, “Num nagaa ma no turamasen iu, balaa di lokobel, di ta nanen ngali iu.” ");
INSERT INTO ncf_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Iesu ga atsura, “Saa nugu nagaa ma no saa no turamasen iaa?” ");
INSERT INTO ncf_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Mil Iesu ga lasi abia di ta tsotso ulti ia, ga paare, “Balawaa di mu nugu no nagaa ma no turamasen iaa. ");
INSERT INTO ncf_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","O saa ia ta xosaraa xan sirsiir Moroaa biaa di, nugu taamat ma motogo ma nagaa.” ");
INSERT INTO ncf_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sin biexa leng, Iesu a sebula atiltsoli ngali asingan no inaman sangan daan ulis. Ma biaa malep di ta exumule ulti ia, asuk lot buxa. Biaabi ga pis xaa papan tsiibi ma ga tsotso papan, palaaen xuen. O no inaman araraa di ga manman xuen sin gelgel ina daan. ");
INSERT INTO ncf_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Iesu asingan di taman no totore puapua ma lalon xan asasing, a paare we; ");
INSERT INTO ncf_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Gim lolong! Unsoksok a laa ngali soxaa no xalitsa. ");
INSERT INTO ncf_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Biaa ta lo xaaparen no xalitsa, biexaa xalitsa a xol no nan sal, ma no maan di xaalame ma ngen araraai abia no xalitsa. ");
INSERT INTO ncf_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Biexaa xalitsa, a xol papan pula ta ie xaat. No xalitsa asuk tsik isagaa mu, amuina pula a xap riri buxa. ");
INSERT INTO ncf_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Oro biaa matanios talaa xaalame lapalaa, biaa no xalitsa ta se tsik, di suk malang amuina a xap xadi xaa baa. ");
INSERT INTO ncf_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Biexaal ina no xalitsa di xol laa lolobet ina no xoxon, biaa di ta tsik, no xoxon di xaili no. Biaabi di ga xap waalii xaa waawaan di. ");
INSERT INTO ncf_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Biexaal di xol papan pula mamainaang, ma biaa no xalitsa ga suk tsik. A tsik laa lapalaa ma ga waalii no waan ie. Biexaal ina no ie, di waalii no sangaul a tuul ina no waawaan, biexaal no sangaul a paas xuuk ina waawaan, biexaal di waalii no sangsangaul ina waawaan.” ");
INSERT INTO ncf_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Iesu a paare, “Iwaa ta ie talinga ngali lolong, papaalii na lolong.” ");
INSERT INTO ncf_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Biaa Iesu ta se man xasinge, xan sangaul ma ga laa lua ina tsi asasing ma biexaa inaman di ulti, di atsuraa ia taman no totore puapua. ");
INSERT INTO ncf_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Iesu asaaiti di, “Moroaa a se tali abia namaang ta xuxii ina xan Maradaan sin gim. Oro sin biaa di lokobel ina xan maradaan Moroaa, no maarang araraa, iaa ta paare sin di taman biaa no totore puapua. ");
INSERT INTO ncf_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ngalibi, “ ‘Di ba lo nanen ma nanen oro di ba xap atii sa. Di ba lo lolong ma lolong, oro di ba xap leng. Nawe di xosaraa abala no maarang, di ba soro puxisbal ma Moroaa naba adodolii xadi no namaang tsaxa.’ ” ");
INSERT INTO ncf_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Mil Iesu ga paare ngali di, “Gim xap leng sin abala totore puapua? Gim ba sen leng we sin biexaa totore puapua? ");
INSERT INTO ncf_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Iwaa unsoksok a soxaa xan totore Moroaa. ");
INSERT INTO ncf_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Biexaa inaman di malen aia waan ie ta xol nan sal, malen abia totore di ta soxaa. A xap lil mu sin di ta alongmen xan totore Moroaa, Saatan a xaalame isagaa mu ma ga saali abia totore di ta se soxaa lalon di. ");
INSERT INTO ncf_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Biexaal di malen no xalitsa di ta soxaa lalon pula ta ie xaat. Di alongmen totore ma tiwaa tsaa di ga adi taman taton. ");
INSERT INTO ncf_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Oro biaa di ta xap aturung baa, biaa totore a xap man adis lalon di. Biaa no mamaet o no xonkonon atsap, amuina sin abia totore, di ba xol isagaa mu. ");
INSERT INTO ncf_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Biexaal di malen no xalitsa di ta soxaa no lolobet ina no xoxon. Di alongmen abala totore. ");
INSERT INTO ncf_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Oro biexaa mat maarang atsiga lalon xadi tino, lolbiir, titii buxaai xuxute ma mataxaaxaa. Balawaa no maarang a xaili xan totore Moroaa ngali naba xap tsik. O biaa totore puapua a xap waalii xaa waawaan lalon xadi tino. ");
INSERT INTO ncf_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Biexaal di malen iwaa xalitsa di ta soxaa lalon pula mamainaang, di longmien totore ma di sirawaa ma di waalii no waawaan di. Biexaal di waalii no sangaul a tuul, biexaal no sangaul a paas xuuk, biexaal sangsangaul ina di ta soxaa.” ");
INSERT INTO ncf_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","O Iesu ga paare sin di, “Gim xap xaa axaxuina xa rarar paina xa xiis o paina xa ibe, asuk xap. Gim ba aturungi sin niaan taktaxiu tsaa. ");
INSERT INTO ncf_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","No mat maarang araraa ta xuxii, Moroaa naba atsapngen no lalon leng ngali no inaman araraa di ba lasi. ");
INSERT INTO ncf_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nawe gim ie talinga ngali lolong, gim na lolong!” ");
INSERT INTO ncf_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ma ga sebula paare, “Gim na adodo axaautsi sawe gim ta se alongmen. Nawe gim suk lolong axaau sin iaa, Moroaa naba tali buxaai sinaae sin gim. ");
INSERT INTO ncf_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Saa ia, ta ie sinaae sin xan totore Moroaa, Moroaa naba taal buxaai sinaae sin, o saa ia, ta xap ie sinaae sin xan totore Moroaa, nawe a ie sinaae, Moroaa naba alet mulangena sin.” ");
INSERT INTO ncf_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Iesu ga sebula paare, “Xan Maradaan Moroaa a weaatala. Taamat a xaaparen no xalitsa papan pula. ");
INSERT INTO ncf_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nabing ma lasiaat, biaa ta urange o a padepade, no xalitsa a tsik. Iwaa taamat a xap atii no xalitsa asen tsik we. ");
INSERT INTO ncf_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Pula tsaa a xosaraa no xalitsa ngali tsik. Setauan biaa dikdixan ina soksok asemat, mil no lalawina, mil no xala se. ");
INSERT INTO ncf_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Sauna mu sin no xala ta se maatkel, aturungi tatel sin, amuina leng ina papaas a se tsap.” ");
INSERT INTO ncf_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","O Iesu ga sebula paare we, “Gita ba paare wesa ngali xan Maradaan Moroaa a malen sa? O sen totore puapua naba alengi? ");
INSERT INTO ncf_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Xan xalitsa tsupa biaa ta suk dokdok gim ta xaa soxaa lalon pula. ");
INSERT INTO ncf_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","A xaa tsik ga tsap xaraxin ie ngen abia no xariin ie lalon uma. Xan no xariin laxe, biaa no maan di ta xosor uni papan, paina xan marmaru.” ");
INSERT INTO ncf_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iesu atolomi no daan totore puapua weaatalaa ngali asingan di. Asingan di taman abia no mat maarang se araraa ngali di ba atii. ");
INSERT INTO ncf_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tii xap paare taman xawas bula sin di, oro taman no totore puapua mu. Oro biaa tii man xasinge mii xan no tsi asasing tsaa, tii ga alengi no maarang araraa sin di. ");
INSERT INTO ncf_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Biaa ta se laa nale bingbing, Iesu asaaiti xan no tsi asasing, “Gita laa sin biexa gelgel xaatalaa.” ");
INSERT INTO ncf_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Di papaalii abia xumul mil, di ga laa mii ia papan mono malen ta se manman papan mono. Biexaa mono bula di ga amusili di. ");
INSERT INTO ncf_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Xaraxin maal ga tapaas, ma no tuun ga le xapas patanginai mono ma ga atiltsoli ngali us taman daan. ");
INSERT INTO ncf_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Iesu a lo urarange talaa xaamil ina mono ma ga xulang papan lulaa. Xan no tsi asasing di laa sangan ma apadaa ia di ga we, “Unaasasing, u suk xap adodo we, gita ba liaan?” ");
INSERT INTO ncf_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Iesu a tapaas, ga imii maal, ma ga paare ngali no tuun ga we, “Bong! Man adamis!” Mil, maal ga xap ma laman ga suk malina araraa. ");
INSERT INTO ncf_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Iesu ga asaaiti xan no tsi asasing, “Ngalisa gim ta suk mataa buxa? Gim xap mager taltaalnge?” ");
INSERT INTO ncf_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Xan no tsi asasing di suk mataa buxa ma etirikngen di, di ga we, “Saa xaawe aila? O maal ma no tuun di ga lolong amusili mu ia.” ");
INSERT INTO ncf_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iesu ma xan no tsi asasing di tabaxi daan ulis laa lalon xolot ina Gerasin. ");
INSERT INTO ncf_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Biaa Iesu ta tsuul papan mono, sauna mu iexa taamat taman tanua tsaxa a tsuul xaal lalon io ngali le sabasue ia. ");
INSERT INTO ncf_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ilawaa taamat a manman lalon abia no io ma asuk xap xa na pupua ngali rotsi taman xa tsen. ");
INSERT INTO ncf_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","No daan leng no inaman di rotsi no liman ma no xaden taman tsen oro, a xaa tigiri amutmuti no tsen sin no xaden. A xap xa na watwat pupua ngali epuske ma abonga ia. ");
INSERT INTO ncf_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Sin no siaat ma sin no bing, a xaa es labatina no io ma ga xaa laa papan no buk ma ga xaa xuupkup ma tae no isuaan sin no xaat ta irom. ");
INSERT INTO ncf_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Biaa ta lasi Iesu palpalaa tsaa iwaa taamat asuk sol laa sangan ia ma ga sage putput laamuaan ma ga xuup lot, ");
INSERT INTO ncf_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","“U wena xosaraa sa sin iaa, Iesu, xan Tsi Moroaa lapalaa suk se? U na puris sin Moroaa we u ba xap asosongi iaa!” ");
INSERT INTO ncf_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Amuina Iesu ga paare ngali, “Iu tanua tsaxa, u na tsuul alen aila taamat.” ");
INSERT INTO ncf_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","O Iesu ga atsuraa ia, “Saa iesaam?” Taamat a xisi, “Iesaaga ilaa Legion, amuina giem suk xudu.” ");
INSERT INTO ncf_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma iwaa taamat a sebula ma a sebula ningi Iesu ngali naba xap tulen atsuulngi di xaal, sin abia xolot. ");
INSERT INTO ncf_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Biexa xariin xobel bol, di tabali di papan buk atataaen abia xolot. ");
INSERT INTO ncf_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Biaa no salawa tsaxa di ningi Iesu, “Tulen giem laa labatina no bol ngalibi giem ba pupua ngali tsigaii di.” ");
INSERT INTO ncf_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Iesu ga sirawaa di ma no salawa tsaxa di tsuul alen aia taamat ma di ga tsigaii no bol. Biaa xobel bol araraa a malen 2,000 di tii ga esole laa lapula sin soriri ina buk laa lalon daan ulis ma di tii ga suk liaan. ");
INSERT INTO ncf_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Biaa no untilaamamil sin xobel bol, di lasi abia ma di ga suk sol ma di ga atolomi abala sin inaman laba ma no xolot atataaen xobel laba, no inaman di tii xaalame ngali le lasi semaarang tii tsap. ");
INSERT INTO ncf_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Biaa di tii xaalame sangan Iesu, di lasi aia taamat no salawa tsaxa di tii ben tsigaii, a se xalkale tia ma ga se alen axaautsi xan laplap ma xan adodo a se tutiik ma di tii ga suk mataa. ");
INSERT INTO ncf_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Biaa no inaman di tii lasi sen maarang Iesu tii xosaraa, di asaaiti biexaa inaman taman abia maarang tii tsap sin iwaa taamat biaa no salawa tsaxa di tii ben tsigaii ma biaa xobel bol bula. ");
INSERT INTO ncf_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ma no inaman di ga ningi Iesu ngali na papaalii xadi xolot. ");
INSERT INTO ncf_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Biaa Iesu tii es en laa papan mono, iwaa taamat, Iesu tii ben saali no salawa tsaxa sin, a ningi Iesu ngali naba laa mii ia. ");
INSERT INTO ncf_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Iesu tii xap papaalii ia, oro ga asaaiti ia, “Laa tataam sangan num matenaanua ma iu naa asaaiti di taman xan watwat Orong biaa ta se xosaraa ngali iu ma tii sen tali we xan biirbirum sin iu.” ");
INSERT INTO ncf_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ma taamat ga laa ma paare leng Dekapolis, aisa no maarang Iesu tii se xosaraa sin ia. Ma no inaman araraa di tii ga suk olol buxa. ");
INSERT INTO ncf_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Biaa Iesu ta se tabaxi daan ulis sebula papan mono ngali mula laa sin biexa papel ina daan ulis. Lan abia xolot, xariin malep di exumule ulti ia, sin tii manman sangan daan ulis. ");
INSERT INTO ncf_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","O iexa lalaamua ina anua sausawit iesan Jairus, a xaalame lalon abia xolot, ga lasi Iesu ma ga sage putput laamuaan. ");
INSERT INTO ncf_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ma ga ningi Iesu we, “Nugu tsaana dokdok a se atat ngali met. Timaa xaalame ma u na aturungi no limaam papan ia ngalibi naba tuo ma naba tino.” ");
INSERT INTO ncf_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ma Iesu ga laa mii aia lalaamua ina anua sausawit. Xaraxin malep di amusili Iesu ma di ga esurut ulti ia. ");
INSERT INTO ncf_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Iexa aina tia, tii manman taman minet ina nanxaskas sin no miet ta sangaul axuuk ma ga laa lua. ");
INSERT INTO ncf_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tii taana xaraxin sosong xaal sin no daan untubatuba di tii xonon ngali tiltsomi ia ma ga se araraai xan no xuxute sin di, oro tii suk tsap tsaxa buxa. ");
INSERT INTO ncf_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ma biaa tii lolong xaa sin Iesu, asuk xaalame mulina ia, ma ga taana xan laplap. ");
INSERT INTO ncf_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Aina tii adodo, “Nawe iaa taana mu xan laplap, iaa ba tuo.” ");
INSERT INTO ncf_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tiwaa tsaa, biaa dal asuk xap. Asuk saaen sin no isuaan we, a se leiwaa sin xan sosong. ");
INSERT INTO ncf_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tiwaa tsaa, Iesu a xilalaa we, biaa xoror atsuul alen ia. Ma ga putsi ma atsura, “Saa taxaane nugu laplap?” ");
INSERT INTO ncf_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Xan no tsi asasing di xisi, “Xuduxudu ina inaman di lo asuruti iu, ma u ga atsura tsaa, ‘Saa taxaane iaa?’ ” ");
INSERT INTO ncf_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Oro Iesu a lo nanen iʼis tsaa ngali atixi saa taxaane ia. ");
INSERT INTO ncf_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mil iwaa aina tii ga suk atixi we, a se tuo. A xaalame ma ga xol laamuaan no xaden Iesu. No isuaan tii didiir taman minataa, o ga asaaiti ia taman inesaait so ina xan minet. ");
INSERT INTO ncf_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Iesu ga paare ngali ia, “Tsaana, num tinaalnge a se atoaa iu. Laa lalon malina ma iaa se aleiwaai iu sin num sosong.” ");
INSERT INTO ncf_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Biaa Iesu ta lo papaare tsaa sin aia aina biexaa taamat di xaalame xaal lalon xan anua Jairus, lalaamua ina anua sausawit, di ga asaaiti, “Nangaam le atarangaai unaasasing. Num tsaana a se met.” ");
INSERT INTO ncf_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nanlii mu sen maarang di ta paatina. Iesu ga paare ngali Jairus, “Nangaam mataa, u na taltaalnge mu.” ");
INSERT INTO ncf_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tii xap papaalii xa bula ngali amusili ia, oro tii giwaa mu Pita, Jeims ma Jon iwaa turamasen Jeims. ");
INSERT INTO ncf_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Biaa di le tsap tatan Jairus, o Iesu tii ga lasi no inaman di ta lo teng lolbiir. ");
INSERT INTO ncf_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Iesu atsiga ma ga paare ngali di, “Ngalisa abala no tengteng lolbiir? Ilawaa tsaana a xap met, oro a urarange mu.” ");
INSERT INTO ncf_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Oro di ga nongngen ia. Mulina ta se atsuulngi di, a giwaa xan mom, nagaa ma xan no tsi asasing ta tuul ma di ga tsiga tiwaa, itaa iwaa tsaana ta manman. ");
INSERT INTO ncf_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","A taxaane liman ma ga paare ngali ia, “Talita Koum!” (Muina a weaatalaa, “Tsaana dokdok, iaa paare ngali iu, tapaas!”). ");
INSERT INTO ncf_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tiwaa tsaa iwaa tsaana asuk til laa lapalaa ma ga suk atiltsoli eses. (Tii sangaul axuuk ma ga laa lua ina xan no miet.) Sin abala, di suk olol buxa. ");
INSERT INTO ncf_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ga tali totore watwat sin xan mom ma nagaa ngali delu na xap asaaiti no inaman taman abala. Ma ga asaaiti delu ngali tali xaka pu luxaal ngali angen. ");
INSERT INTO ncf_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesu apapaali biaa xolot ma ga mula laa lalon xan inaman laba tsaa mii xan no tsi asasing. ");
INSERT INTO ncf_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sin Saabat, asingan no inaman lalon anua sausawit. No daan inaman di alongmen, di suk tunga. Di we, “Itaa adi balawaa no asasing ta asingan no inaman taman? Saa tali balawaa sinaae sin ia, ngali xosaraa abala no mat axixila? ");
INSERT INTO ncf_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ia mu iwaa untunumar. Iwaa mu xan tsi Maria ma ia xan no taamat ilaa Jeims, Josis, Judas ma Saimon. Ma no moton bala di mii gita.” No inaman di ga bal tsaxa ngali ia. ");
INSERT INTO ncf_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Iesu ga paare ngali di, “No inaman xaal sin xan inaman laba xa propet, di ba xap manglen ia.” ");
INSERT INTO ncf_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","A xap pupua ngali xosaraa xaa axixila na xudu atia. Biaa mu ga aturungi liman papan nen inaman minet mu, ma ga atoaa di. ");
INSERT INTO ncf_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ma Iesu ga suk tunga sin ta xap xadi xa tinaalnge. Mil ga baais laa sin no xobel xuxuuk. ");
INSERT INTO ncf_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Iesu a ilei axumuli sangaul ma ga laa lua ina xan no tsi asasing ma ga tulen di laa alualua. Ma ga tali banam sin di, ngali saali no salawa tsaxa. ");
INSERT INTO ncf_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Asaaiti di weaatalaa: “Sin abala nagim ines gim nangaam adi xawas, gim adi mu xudak ina eses. Nangaam adi xa tsoki ma xa tutuel, ma xa xuxute lalon num biaal. ");
INSERT INTO ncf_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tamtuel lalon no bubut ma na xap xa laplap bula. ");
INSERT INTO ncf_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nawe gim tsiga lalon xa anua, manman atia, a pupua gim ta papaalii abia inaman laba. ");
INSERT INTO ncf_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nawe xa xobel a xap suei atatoni gim o di xap lolong sin gim, gim na panlii kuku sin no xaden gim nawe gim tapaas papaalii di. Balawaa papaare leng ngali epuske mii di.” ");
INSERT INTO ncf_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ma xan no tsi asasing di ga laa baais sin no inaman ngali di na puxisbal. ");
INSERT INTO ncf_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Di saali no daan salawa tsaxa, ma di ga patsaa daanwe papan no daan minet ma di ga atoaa di. ");
INSERT INTO ncf_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","King Erot tii alongmen abala we, no inaman araraa di se atik axaautsi iesan Iesu. Biexaal di we, “Jon unaaxaxadaan, a se tapaas mula sin minet ma biaabi no axixila xoror watwat ga taxaa lalon ia.” ");
INSERT INTO ncf_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Biexaal di we, “Ia Elaija.” Biexaal di we, “Ia propet a malen xa ina no propet in ti laamua.” ");
INSERT INTO ncf_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Oro biaa Erot ta longmien abala, asuk we, “Iwaa Jon, iaa ta iritlii xuan, a sebula tapaas mula sin minet!” ");
INSERT INTO ncf_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Erot tsaa tii tali papaare watwat ngali laa pitsi Jon ma di ga laa aturungi lalon anua lodo. Ga xosaraa abala namaang ngali atatoni Erodias. Pilip iwaa xan taamat tii maxis sin ia, oro talaawaa Erot a sebula maxis sin. ");
INSERT INTO ncf_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jon tii asaaiti Erot ga we, “Asuk xap tutiik ngali u ba maxis sin xan tubu turumasen iu.” ");
INSERT INTO ncf_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Balawaa totore a xosaraa Erodias ga ngutsulen buxaai Jon ma ga saan ngali sas amantei ia. Oro tii xap pupua ");
INSERT INTO ncf_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","amuina Erot amatinai Jon ma ga saan ngali tilkaali ia, amuina atii Jon ia taamat tutiik ma taamat pat. Biaa Erot ta alongmen Jon, tii suk adodo xuduxudu, oro tii saan tsaa ngali alongmen ia. ");
INSERT INTO ncf_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Leng so a se tsap, sin leng so nagaa ta taxaana ia, Erot ga xosaraa xariin luxaal, ngali no lalaamua ina gawaman, no lalaamua ina unmakmaxil, ma no taamat laba in Galili. ");
INSERT INTO ncf_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Biaa xan tsaana Erodias tii xaalame ma ga le tiili, tii suk atatoni Erot ma biaa no xibong ina abia luxaal. Ma King Erot ga paare sin iwaa tsaana, “U na ningi iaa ngali sawe u ta saan ngali, ma iaa ba tali susum.” ");
INSERT INTO ncf_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ma ga xubatsi sin ia, “Samaarang u ta atsuraa iaa ngali, iaa ba tali xolot axuuk ina alua ina nugu Maradaan sin iu.” ");
INSERT INTO ncf_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tsaana a laa sangan xan nagaa ma ga laa atsuraa ia, “Sen maarang iaa ba ningi sin King?” O xan nagaa ga xisi, “Atsuraa ngali xuan Jon unaaxaxadaan.” ");
INSERT INTO ncf_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tiwaa tsaa, tsaana a isagaa laa sangan king taman xan atsutsura; “Iaa saan ngali u na tali xuan Jon unaaxaxadaan papan xa palet talaawaa tsaa.” ");
INSERT INTO ncf_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","King asuk lolbiir buxa, oro amuina tii se xubatsi mii iwaa tsaana ma xan no xibong ina abia luxaal di alongmen bula, King Erot ga xap pupua ngali puxislii sa ta atsuraa ngali. ");
INSERT INTO ncf_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tiwaa tsaa King a tulen iexa asilalxadek ngali laa adi xuan Jon xaalame. Asilalxadek a laa ma iritlii xuan Jon lalon anua lodo, ");
INSERT INTO ncf_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ma ga alet mulangenai xuan Jon lalon palet. King a tali sin tsaana, ma ga tali laangen sin xan nagaa. ");
INSERT INTO ncf_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Xan no tsi asasing ilaa Jon, di alongmen abala maarang ta tsap, o di ga xaalame ma le adi xan pakpak ma di ga laa aturungi lalon io. ");
INSERT INTO ncf_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","No aposal, di til ulti Iesu ma di ga atolomi sin ia taman no maarang araraa di tii se xosaraa ma asingan no inaman taman. ");
INSERT INTO ncf_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Amuina sin no daan inaman di ta xaxaalame ma mulamula, Iesu mii xan no tsi asasing, di ga xap pupua ngali angen. Ga paare sin di, “Gim xaalame xasinge mii iaa sin xa xolot ta man adamis ma gita na iaawis.” ");
INSERT INTO ncf_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ma di ga xaa laa papan mono di xasinge laa sin xobel biil. ");
INSERT INTO ncf_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Oro no daan inaman di tii lasi we di se laa ma di ga nanxilalaa di ma di ga sol xaal lalon abia no inaman laba araraa ma di laa tsap laamuangen di. ");
INSERT INTO ncf_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Biaa Iesu ta tsal ma ga lasi malep, asuk ie biirbirum ngali di amuina di malen no sipsip ta xap xadi xa untilaamamil. Ma ga atiltsoli ngali asingan di taman no daan maarang. ");
INSERT INTO ncf_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","A se nale sin abia leng, o xan no tsi asasing di ga xaalame sangan ia, di ga we, “Balawaa xobel biil, ma a se nale buxa. ");
INSERT INTO ncf_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Se tulen no inaman laa, ngali di ba laa lalon no xobel xaatsap ulti gita ngali uuli xadi xaa was ngali ngani.” ");
INSERT INTO ncf_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Iesu ga xisi di ga we, “Gim na tali xaa was ngali di ba ngani.” Di ga asaaiti ia, “Giem xap pupua ngali uuli xaa tsoki pupua ngali tabali abala no inaman! Balawaa xuxute a malen iliil ina xa taamat ta taxaa watwat no uleng apaasaatuul. U saan ngali giem ba lii xariin xuxute ngali uuli xaa tsoki biaa ta pupua ngali di araraa?” ");
INSERT INTO ncf_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","O Iesu ga atsuraa di, “Aisa no tsoki biaa? Gim laa nanen.” Biaa di ta laa atik tatanginai, di xaalame sin, di ga we, “Alima no tsoki ma alua no xoo.” ");
INSERT INTO ncf_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Mil Iesu ga paare ngali xan no tsi asasing, ngali asaaiti no inaman di na tsotso lalon no xumkumul papan no palis xarawaak. ");
INSERT INTO ncf_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","O no inaman di ga tsotso lalon no xumkumul ina no sangaul alima, ma no sangsangaul. ");
INSERT INTO ncf_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","A adi abia no tsoki ta lima ma no xoo ta lua ma ga nanen xale lapalaa balalangit ma ga putsangi axaau, ma ga tsabaxi no tsoki ma ga tali no sin xan no tsi asasing ngali di ba tabali no inaman. Mil ga exasen bula no xoo ta lua labatina di araraa. ");
INSERT INTO ncf_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","No inaman se araraa di angen ma di ga se maas. ");
INSERT INTO ncf_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","No tsi asasing di tuali sangaul ma ga laa lua ina xiis taman no ngaalngaal ina tsoki ma xoo. ");
INSERT INTO ncf_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Xoxot ina no taamat di tii se angen tii 5,000. ");
INSERT INTO ncf_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tiwaa tsaa Iesu asaaiti xan no tsi asasing ngali di na pis xaa papan mono ma di na laamuangen ia laa Betasaida o ia na axatsapen abia xumkumul. ");
INSERT INTO ncf_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Mulina ta papaalii di, asuk laa lapalaa sin gelgel ina buk ngali sawit. ");
INSERT INTO ncf_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Biaa ta se nale bingbing, mono a se bebe labatina daan ulis o ia xasinge tsaa, tia xuen. ");
INSERT INTO ncf_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Tii lasi no tsi asasing di ta se xaao sin alulusa, amuina maal a epuske mii di. Sin nanaaet ina xoxo nabing, atsuul ma ga eses lapalaa papan abia daan ulis laa sangan di. Nap dokdok mu naba se es liwaa di, ");
INSERT INTO ncf_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","o no tsi asasing di ga lasi ia ta eses papan daan ulis, di ga sorowe xa gaas ma di ga suk xuup, ");
INSERT INTO ncf_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","amuina di araraa di se lasi ia, ma di ga suk mataa. Tiwaa tsaa Iesu ga paare ngali di, “Gim na watwat! Iaa mu! Gim na xap mataa.” ");
INSERT INTO ncf_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Mil ga en papan mono mii di o maal ga met. No tsi asasing di suk tunga buxa. ");
INSERT INTO ncf_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Di tii se lasi ia ta xosaraa axixila ina no tsoki ta lima, ma di xap leng sin abia, amuina xadi no butsa tii taban. ");
INSERT INTO ncf_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Biaa di ta se tabaxi daan ulis laa xaatalaa, di suk laa tsal Genasaret ma di ga pitsi mono atia. ");
INSERT INTO ncf_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Biaa di ta tsuul papan mono a xap sauna mu no inaman di suk nen xilalaa Iesu. ");
INSERT INTO ncf_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Di sol laa lalon no xolot araraa ma di ga atsaxei no minet papan no xapat biaa di ta se longmien no sen xolot ta manman tia. ");
INSERT INTO ncf_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Sin no sen mat xolot Iesu a laa sin, lalon no xobel ma no inaman laba, di xaa le aturungi no minet lalon no xolot susune. Ma di ga ningi awatwati ia ngali di na taana mu barangutsina ina xan uga disdis. Ma biaa di, di ta taana ia, di tii suk tuo. ");
INSERT INTO ncf_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Biexaa Paarasi ma biexaa unaasasing ina lo di xaal Jerusalem, di ga le exumule ulti Iesu. ");
INSERT INTO ncf_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Di lasi biexaal ina xan no tsi asasing di ta nganingani xadi no luxaal taman no liman di, di ta xap guraii no. ");
INSERT INTO ncf_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(No Paarasi ma no Jiu araraa, di xap xaa angen pupua sin di ta guraii no liman di amusili xadi namaang no xusaak. ");
INSERT INTO ncf_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Biaa di ta xaal lalon no xolot susune, di ba xap mager angen til sin di ba ta guraii no liman di. Ma di amusili biexaa mat namaang malen ngali guraii no sobuk, no ketal ma no kabalaa ina axaxuu.) ");
INSERT INTO ncf_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ma no Paarasi mii no unaasasing ina lo di atsuraa Iesu weaatalaa, “Ngalisa num no tsi asasing di ta xap tino amusili xadi namaang no xusaak, ma di ga ngani xadi no luxaal taman no liman di ta xap mixat?” ");
INSERT INTO ncf_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Iesu a xisi ga we, “Gim no xalam lua, Aisaia tii tutiik sin tii tali totore ina propet sin gim, biaa tii atalaa, “ ‘Balawaa no inaman di manglen iaa taman no bulina mu di. Oro xadi no butsa asuk palaaen iaa. ");
INSERT INTO ncf_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Di langaari sin iaa gomsaa mu. Di asasing mu taman no lo sin no taamat, ma a xap nugu no lo.’ ");
INSERT INTO ncf_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Gim se adodolii xan no totore watwat Moroaa ma gim ga taxaariti xadi namaang no taamat in ti laamua.” ");
INSERT INTO ncf_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Iesu ga asaaiti di, “Gim ie adodo mamainaang ngali puxislii xan lo Moroaa ngali amusili nagim no namaang nagim no iaaiaa in ti laamua. ");
INSERT INTO ncf_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses tii paare we, ‘Gim na manglen nagim no mom ma nagaa.’ Ma ga sebula paare we, ‘Nawe xa a xororaa xan mom o xan nagaa, di na sas amantei.’ ");
INSERT INTO ncf_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Oro gim paare we, nawe xa taamat a ie maarang biaa ta pupua ngali tiltsomi xan mom o nagaa oro ga we, ‘Balawaa xan tinabel Moroaa mu,’ ");
INSERT INTO ncf_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","mil naba se xap pupua ngali xosaraa xawas ngali xan mom ma nagaa. ");
INSERT INTO ncf_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Sin abala sal gim puxislii xan totore Moroaa taman nagim no namaang biaa di tii tali sin gim ti tsaa. Ma gim ga xosaraa no mat maarang weaatia.” ");
INSERT INTO ncf_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Iesu a sebula ilei abia malep ngali xaalame sangan ma ga we, “No inaman araraa, gim na longmien iaa, ma gim na leng sin abala. ");
INSERT INTO ncf_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","A xap xawas lokobel ina xa taamat na xosaraa ia ngali na xap mixat, Oro sawe ta tsuul xaal lalon taamat naba xosaraa ia na xap pat.” ");
INSERT INTO ncf_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Mil sin Iesu ta se papaalii abia malep ga tsiga naanua, no tsi asasing di atsuraa ia taman abala totore puapua. ");
INSERT INTO ncf_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","O Iesu ga we, “Gim suk tangtangabaa so? Gim xap lasi we, a xap xawas lokobel ta tsigaii taamat, a pupua ngali xosaraa ia ngali na xap mixat. ");
INSERT INTO ncf_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Amuina a xap tsiga laa lalon xan butsa, oro atsiga laa lalon xan xuurkuur o mil ga tsuul alen isuaan.” (Iesu tii paate asen abala we, no luxaal araraa axaau ngali ngani.) ");
INSERT INTO ncf_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Iesu a we, “Sawe ta tsuul xaal sin xa taamat, biaa mu maarang a xosaraa aia taamat ga xap mixat. ");
INSERT INTO ncf_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Amuina talaa lalon xan butsa taamat, atsuul taman no adodo morokon, no manginngin ina namaang ngali matul ina namaang ina maxis, pulapula, sas amantei taamat, matul mii xa u ta xap maxis sin, ");
INSERT INTO ncf_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","angen tsaxa, bal lelep buxa, ababaa, reret tsaxa, mataxaaxaa, pingpingse, paraak ma tangtangabaa. ");
INSERT INTO ncf_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Balawaa no namaang tsaxa atsuul xaal lalon taamat ma ga xosaraa taamat ga xap mixat.” ");
INSERT INTO ncf_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iesu a se papaalii abia xolot ma ga se laa lalon xolot atataaen Taia. Atsiga lalon anua o ga xap saan ngali xaal di na atixi a manman atia. Oro tii xap pupua ngali naba xuxii. ");
INSERT INTO ncf_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Iexa aina, xan tsaana dokdok salawa tsaxa ta tsigaii, sauna mu biaa ta longmien Iesu ta manman lalon abia xolot, asuk xaalame ma xol sangan no xaden. ");
INSERT INTO ncf_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Iwaa aina in Grik, di ta taxaane Ponisia lalon Siria. Ga ningi Iesu ngali na tulen atsuulngi no salawa tsaxa papaalii xan tsaana. ");
INSERT INTO ncf_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Iesu asaaiti aina, “Setauan papaalii no tsi di na ngani no maarang araraa di ta saan ngali, amuina a xap mamainaang ngali adi xadi tsoki no tsi ma na lii laa ngen sin no xapuna.” ");
INSERT INTO ncf_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Aina a xisi, “Iou, Orong, aso abia. Oro no xapuna paina ibe di xaa ngani xadi no pu mirmir no tsi.” ");
INSERT INTO ncf_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ma ga asaaiti, “Amuina sin abia xixiis axaau, u pupua ngali laa; salawa tsaxa a se papaalii num tsaana.” ");
INSERT INTO ncf_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","A laa naanua ma ga laa tatanginai xan tsaana ta matmatuul papan ibe, salawa tsaxa ta se papaalii. ");
INSERT INTO ncf_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Mil Iesu apapaali no xolot sangan Taia, ga laa lalon Sidon ma laa lapula sin Laman Galili ma laa lalon no xolot ina Dekapolis. ");
INSERT INTO ncf_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","A manman atia o biexaal no inaman di ga le tali iexa taamat ta talingaban sangan. Iwaa taamat ga xap pupua ngali papaare. Di ga suk ningi awatwati ia ngali naba aturungi liman papan aia taamat ngali naba atoaa ia. ");
INSERT INTO ncf_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Mil sin ta giwaa aia taamat laa sin gelgel, palaaen abia malep, asuk atsigali xan no kakaalis laa lalon xan no talingan aia taamat. Mil ga xamutsa no liman ma ga taxaane nan xaliman aia taamat. ");
INSERT INTO ncf_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","A nanen laa lapalaa balalangit, alet maal ma ga paare ngali ia, “Epapata!” (Muina abalaa, “Na tsalel!”). ");
INSERT INTO ncf_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tiwaa tsaa, talingan aia taamat asuk tsalel ma nan xaliman a se tamluba ma ga suk atiltsoli ngali papaare tutiik. ");
INSERT INTO ncf_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Iesu asuk paare watwat ngali di na xap asaaiti xaal taman sawe ta tsap. Tii asaaiti di sebula ma sebula ngali xap paare taman xawas oro di ga lo papaare leng tsaa taman sawe tii se xosaraa. ");
INSERT INTO ncf_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","No inaman di suk olol buxa. Di ga we, “Tii se xosaraa axaautsi no maarang araraa. A xosaraa no talingaban ma di ga lolong! Ma biaa no ngusbong, a xosaraa di, di ga papaare.” ");
INSERT INTO ncf_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Lalon abia no leng, biexa xariin malep di sebula le tsap esuei. Amuina a xap xadi xawas ngali angen o Iesu ga ilei xan no tsi asasing xaalame sangan ga paare, ");
INSERT INTO ncf_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Iaa titii buxaai abala no inaman. Di ta se manman mii iaa no leng ta tuul ma ga xap xadi xawas ngali angen. ");
INSERT INTO ncf_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nawe iaa ba tulen di laa lalon no tatan di, di ta itol di ba matagalgalil lalon sal, amuina biexaal ina di, di xaal palpalaa.” ");
INSERT INTO ncf_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Xan no tsi asasing di xisi, “Gita man palaaen no inaman laba. Itaa gita ba pupua ngali adi xaa tsoki na xudu ngali tabali abala no inaman?” ");
INSERT INTO ncf_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Iesu ga atsuraa di, “Aisa no tsoki biaa sin gim?” Di xisi di ga we, “Apaasaalua no tsoki bala.” ");
INSERT INTO ncf_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","O Iesu ga asaaiti abia malep ngali di na tsotso lapula. Biaa ta se adi abia no tsoki ta paasaalua, a putsangi axaau sin Moroaa, atsabaxi no tsoki ga tali sin xan no tsi asasing ngali di ba tali sin no inaman. Ma di ga xosor puaa. ");
INSERT INTO ncf_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Xadi nen xoo dokdok bula biaa; Iesu a putsangi axaau sebula ngali abia no xoo ga asaaiti xan no tsi asasing ngali exasen no, sin no inaman. ");
INSERT INTO ncf_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","No inaman di angen ma di ga suk maas. Mil no tsi asasing di luxui no pu ngaalngaal di ta maaslii ma di ga tuali no xiis lot ta paasaalua taman no. ");
INSERT INTO ncf_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tii 4,000 ina taamat di ta angen. Mil sin ta se tulen laangen di, ");
INSERT INTO ncf_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tiwaa tsaa a xaa papan mono mii xan no tsi asasing ma di tii ga laa sin no xolot ina Dalmanuta. ");
INSERT INTO ncf_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","No Paarasi di xaalame ma di ga atiltsoli ngali atsuraa Iesu, ngali xonon ia. Di ga atsuraa ia ngali xa axixila ta xaal balalangit. ");
INSERT INTO ncf_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Iesu alet maal buxa, ga we, “Ngalisa balawaa nan ul ta atsuraa ngali xa axixila? Iaa asaaiti gim taman so naba xap xa axixila naba tsap sin abala ul.” ");
INSERT INTO ncf_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Mil apapaali di ma ga mula laa papan mono ma ga tabaxi daan laa sin biexa gelgel ina daan ulis. ");
INSERT INTO ncf_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","No tsi asasing di adodolii ngali adi xaa tsoki mii di, di adi axuuk mu mii di papan mono. ");
INSERT INTO ncf_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Iesu atewaai di, “Gim na tilaamamil axaau sin xadi iis no Paarasi ma xan iis Erot.” ");
INSERT INTO ncf_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Di ga paare usili abala totore lolobet ina di tsaa, ma di ga we, “A tore weaatia amuina a xap xida xa tsoki.” ");
INSERT INTO ncf_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Iesu tii se atii xan no tsi asasing di tii papaare taman sa o ga atsuraa di, “Ngalisa gim ta papaare taman ta xap xa tsoki? Gim xap mager lasi o leng? Nagim no butsa ataban? ");
INSERT INTO ncf_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Gim ie mat o gim ga xap pupua ngali lasi, gim ie talinga o gim ga xap pupua ngali longmien? O gim ga xap adodomi? ");
INSERT INTO ncf_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Biaa iaa ta tsabaxi no tsoki ta lima ngali 5,000 taamat, aisa no xiis gim ta tuali no taman no ngaalngaal?” Di xisi, “Sangaul axuuk ma ga laa lua.” ");
INSERT INTO ncf_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ma biaa iaa ta tsabaxi no tsoki ta paasaalua ngali abia 4,000 ina taamat, aisa no xiis lot ta us taman no pu ngaalngaal?” Di xisi, “Apaasaalua.” ");
INSERT INTO ncf_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Iesu ga paare ngali di, “Asuk so maase, gim na se leng sin iaa saa.” ");
INSERT INTO ncf_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Di xaalame Betasaida o biexaa inaman di ga xaalame ngali le tali iexa taamat matababa. Di ga ningi awatwati Iesu ngali na taana ia. ");
INSERT INTO ncf_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ga taxaana liman ga laamuangen atsuulngi ia laa lokobel. Biaa ta se xamutsaa no matan aia taamat, ga aturungi no liman papan ia, Iesu ga atsura, “U lasi xawas?” ");
INSERT INTO ncf_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Iwaa taamat a nanen laa lapalaa ga we, “Iaa lasi no inaman; di malen no ie di ta es iʼis.” ");
INSERT INTO ncf_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Iesu a sebula aturungi no liman papan no matan aia matababa. Mil no matan aia taamat ga tsalel, ma no matan ga se axaau ma ga se nen axaautsi no maarang. ");
INSERT INTO ncf_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","O Iesu ga tulen laangen tatan ga we, “Nangaam tsiga laa lalon xobel.” ");
INSERT INTO ncf_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Iesu mii xan no tsi asasing di laa lalon no xobel ulti Sasaria Pilipaai. Biaa di ta se es mula, Iesu ga atsuraa di, “No inaman di we iaa saa?” ");
INSERT INTO ncf_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Di xisi, “Biexaa inaman di we iu Jon unaaxaxadaan. Biexaal di we iu Elaija. Oro, biexaal di we iu xa ina no propet.” ");
INSERT INTO ncf_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","O Iesu ga atsuraa di, “O gim, gim adodo we iaa saa so?” Pita a xisi ga we, “Iu Karisito.” ");
INSERT INTO ncf_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Iesu ga atewaai di, “Gim na xap asaaiti xaal taman iaa saa.” ");
INSERT INTO ncf_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Mil Iesu ga atiltsoli ngali asingan di taman Xan Tsi Taamat naba adi no daan sosong, ma no xusaak ina no Jiu, no lalaamua ina no unsausawit, ma no unaasasing ina lo, di ba palolii ia ma di na sas amantei ia ma mulina no leng ta tuul naba tapaas mula. ");
INSERT INTO ncf_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","A paare leng taman abala, o mil Pita ga giwaa ia laa sin gelgel ma ga atiltsoli ngali imii ia. ");
INSERT INTO ncf_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Oro biaa Iesu ta putsi ga lasi xan no tsi asasing, asuk imii Pita ga we, “Laa mulina iaa, Saatan! U xap atii lalon num adodo xan no maarang Moroaa, oro u atii mu xan no maarang no taamat.” ");
INSERT INTO ncf_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Mil Iesu ga ilei abia malep mii xan no tsi asasing xaalame sangan, ma ga paare, “Nawe xa a saan ngali amusili iaa, na adodolii ia tsaa, na atsaxei xan tongol, ma na amusili iaa. ");
INSERT INTO ncf_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nawe saa ia ta adodo buxa ngali xan tino, naba xosorlii xan tino. Oro, saa ia ta tali xan tino ngali iaa ma ngali inesaait mamainaang biaa naba aleiwaai xan tino. ");
INSERT INTO ncf_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Asen axaau we ngali xa taamat naba tapkina abala xolkolmoxo oro ga xosorlii xan tino? ");
INSERT INTO ncf_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","O sen iliil xa taamat naba tali ngali soxisi xan tino? ");
INSERT INTO ncf_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nawe xa a mangiel sin iaa ma nugu no totore lalon abala nan ul ina untsaxa, Xan Tsi Taamat naba mangiel bula sin, biaa naba xaalame taman xan minaalam xan Mom mii xan no angelo pat.” ");
INSERT INTO ncf_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ma Iesu ga paare ngali di, “Iaa asaaiti gim taman so, xaal ina gim di ta tiltil atalaa di ba xap xonon saaen minet setauan o di ba ta lasi xan Maradaan Moroaa naba xaalame taman xoror watwat.” ");
INSERT INTO ncf_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Mulina no leng apaasxuk, Iesu a giwaa Pita, Jeims ma Jon ma di ga laa papan buk, di man tia xasinge. No isuaan Iesu ga suk puxis auuli nan no matan detatuul. ");
INSERT INTO ncf_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Xan no uga atsila ma ga suk iaas buxa malen no biso ina tuun ta xapas. ");
INSERT INTO ncf_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ma Elaija ma Moses delu ga asemat lalon no matan detatuul ma delulu ga papaare mii Iesu. ");
INSERT INTO ncf_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita ga asaaiti Iesu, “Rabai, asuk axaau ngali gita ta man atala. Getu ba atilngi xaa baul na tuul atala, num xa, xaka Moses, ma xaka Elaija.” ");
INSERT INTO ncf_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Pita a xap atii sawe ngali paatina, amuina detuu suk mataa buxa.) ");
INSERT INTO ncf_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","O pu xelangit ga asemat ma ga ngaati detatuul. Mil, inan xa axaal lalon abia xelangit ga paare, “Ilawaa nugu Tsi iwaa iaa ta titii buxaai. Gutuu lolong sin!” ");
INSERT INTO ncf_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Sauna mu biaa detuu ta nanen iʼis, o detuu ga xap lasi xa mii detatuul oro Iesu xasinge mu. ");
INSERT INTO ncf_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Biaa di lo tsuultsuul xaal papan buk, Iesu ga asaait awatwati detatuul ngali detuu na xap asaaiti xa taman sawe detuu tii lasi til sin xan Tsi Taamat naba ta tapaas mula sin minet. ");
INSERT INTO ncf_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tuu tsi asasing detuu xap papaare taman sawe detuu tii lasi. Detuu epaare we, sen muina abala “tinapaas mula sin minet.” ");
INSERT INTO ncf_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ma detuu ga atsuraa ia weaatalaa, “Ngalisa no unaasasing ina lo di ta we Elaija na setauan xaalame?” ");
INSERT INTO ncf_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Iesu a xisi di ga we, “Di tutiik di ta paatina we Elaija na setauan xaalame ngali le axos atutiki sebula no maarang araraa. O ngalisa inaatel ta we Xan Tsi Taamat naba alet sosong buxa ma no inaman di ba palolii? ");
INSERT INTO ncf_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Oro iaa asaaiti gututuul, Elaija tii se xaalame tsaa, ma no inaman di se xosaraa no maarang araraa sin ia malen di ta saan ngali xosaraa sin ia malen inaatel tii se ataala taman ia.” ");
INSERT INTO ncf_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Biaa di tii xaalame sangan biexaa tsi asasing, di tii lasi xariin malep ta ulti di, ma no unaasasing ina lo, di tii lo engangaae mii di. ");
INSERT INTO ncf_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tiwaa tsaa no inaman araraa di tii lasi Iesu, di tii suk tunga buxa ma di ga sol laa ngali suei atatoni ia. ");
INSERT INTO ncf_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ga atsuraa di, “Sawe abia gim ta engangaae taman?” ");
INSERT INTO ncf_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Iexa taamat ina abia malep a xisi, “Unaasasing, iaa le tali nugu tsi susum, iwaa salawa tsaxa atsigaii ia ma ga tilbanti ia ngali naba xap papaare. ");
INSERT INTO ncf_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Biaa salawa tsaxa ta xaa laamuangen ia, naba lii laangen ia papan pula, no biso a tsuul lalon ngutsina, ga xaa angiririki no lian ma no isuaan ga xaa totogolo. Iaa atsuraa num no tsi asasing ngali di ba saali iwaa salawa tsaxa oro di ga xap pupua.” ");
INSERT INTO ncf_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iesu ga xisi, “Gim nan ul ina xap taltaalnge. Aisa no leng iaa ba manman tsaa mii gim? Nagim muun taltaalnge a tali xaraxin lolbiir sin iaa. Gim taal xaalame ngen aia tsi sin iaa.” ");
INSERT INTO ncf_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ma di ga tali ia. Biaa iwaa salawa tsaxa tii lasi Iesu, tiwaa tsaa ga suk lii adidiiri aia tsi. A xol papan pula, ma ga ulal, ma biso ga tsuul lalon ngutsina. ");
INSERT INTO ncf_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Iesu atsuraa xan mom aia tsi, “Aisa no leng ta se tsap abala maarang sin?” Xan mom tsi a xisi, “Atiltsoli sin ta tsi dokdok tsaa. ");
INSERT INTO ncf_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ilawaa salawa tsaxa atigiri lii ilawaa tsi laa nan ie o lalon daan ngali na sas amantei. Oro nawe u pupua ngali xosaraa xawas ngali, timaa asen num biirbirum sin giem ma u na tiltsomi giem.” ");
INSERT INTO ncf_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Mil Iesu ga paare, “Nawe u pupua? No mat maarang araraa a pupua sin iwaa xa, ta taltaalnge mu.” ");
INSERT INTO ncf_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tiwaa tsaa xan mom tsi asuk xuup we, “Iaa suk taltaalnge so! Tiltsomi iaa ngali aiepatsaa nugu muun taltaalnge!” ");
INSERT INTO ncf_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Biaa Iesu ta lasi malep di ta sol ngali le nanen, asuk imii aia salawa tsaxa. Ga paare, “Iu talingaban ma ngus bong tanua, iaa paare watwat ngali u na tsuul alen aia tsi ma u na suk xap tsigaii ia bula.” ");
INSERT INTO ncf_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Iwaa salawa tsaxa angiek lot ga suk xol didiir buxa ma ga tsuul alen aia tsi. Ma iwaa tsi ga malen a se met ma no daan inaman di ga paare, “A se met!” ");
INSERT INTO ncf_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Oro Iesu ga taxaana liman ma ga atilngi laa lapalaa papan no xaden ma ga til lapalaa. ");
INSERT INTO ncf_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mil Iesu tii se tsiga naanua, xan no tsi asasing di ga tiirik pulaxi ia, di ga we, “Ngalisa giem ta xap pupua ngali saali iwaa salawa tsaxa?” ");
INSERT INTO ncf_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Iesu ga xisi, “Ilawaa mat laxen salawa tsaxa a pupua mu ngali saali mu taman sausawit.” ");
INSERT INTO ncf_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Di papaalii abia xolot ma di ga es tsiga Galili. Iesu tii xap saan ngali xa na atii itaa di ta manman, ");
INSERT INTO ncf_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","amuina tii lo asasingan xan no tsi asasing. Ga paare sin di, “Xa naba babel tali Xan Tsi Taamat papan no liman no taamat morokon. Di ba sas amantei ia ma mil sin no leng ta tuul naba tapaas mula sin minet.” ");
INSERT INTO ncf_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Oro di tii xap leng sin muina ina abala totore. Di ga mataa ngali atsuraa ia taman abala. ");
INSERT INTO ncf_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Di xaalame Kaperanaam. Biaa tii se man lalon anua, asuk atsuraa di, “Gim engangaae taman sa lalon sal?” ");
INSERT INTO ncf_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Oro di suk xale adamis amuina lalon sal di engangaae engen di tsaa ngali saa ina di asuk lot buxa. ");
INSERT INTO ncf_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iesu a tsotso lapula, o ga ilei sangaul axuuk ma ga laa lua ga we, “Nawe xa a saan ngali na lalaamua, na suk tsap taamat mil ma na tsap xadi untutule no inaman araraa.” ");
INSERT INTO ncf_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Iesu a giwaa tsi dokdok ma ga atilngi labatina di. A logoen tsi lalon no liman ma ga paare ngali di, ");
INSERT INTO ncf_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Saa ia ta suei atatoni xa tsi dokdok malen ilawaa sin iesaaga, a suei atatoni iaa, ma saa ia ta suei atatoni iaa, a xap suei atatoni mu iaa oro a suei atatoni nugu Mom iwaa ta tulen iaa.” ");
INSERT INTO ncf_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon ga paare, “Unaasasing, giem tii lasi iexa taamat ta saali no salawa tsaxa sin iesaam, ma giem ga paare sin ia ngali na xap xosaraa abala amuina a xap ia ina gita.” ");
INSERT INTO ncf_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Iesu ga paare, “Gim nangaam tilbanti ia. A xap xa na xosaraa xa axixila sin iesaaga, O mil dokdok ga pupua ngali paare tsaxa taman iaa. ");
INSERT INTO ncf_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Iwaa ta xap epuske mii gita, ia xida. ");
INSERT INTO ncf_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Iaa asaaiti gim taman so. Saa ia ta tali xa sobuk daan sin iesaaga, amuina gim xan no Karisito, naba xap xosorlii xan iliil. ");
INSERT INTO ncf_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Nawe xa a xosaraa abala no tsi dokdok di ta taltaalnge sin iaa laa lalon namaang tsaxa, xan ininte Moroaa sin ia, naba suk tsaxa buxa ngen ngali pal tali xa xariin xaat sin inan ma na lii ia laa lalaman. ");
INSERT INTO ncf_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nawe limaam ataii iu ngali xosaraa namaang tsaxa, xitiplii. Naba suk axaau buxa ngali tsigaii tino laaliu taman lima ta xuuk ngen no limaam ta lua, ma di na lii iu lalon Edes. ");
INSERT INTO ncf_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nawe xaim ataii iu laa sin namaang tsaxa, u na xitiplii. Naba suk axaau ngali u ba tsigaii tino laaliu taman xadek xuuk, ngen no xaim ta lua, ma di na lii iu lalon Edes. ");
INSERT INTO ncf_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nawe mataam ataii iu laa sin namaang tsaxa, u na luapelii mataam. Asuk axaau ngali tsigaii xan Maradaan Moroaa taman mataam ta xuuk, ngen no mataam ta lua, ma di na lii iu lalon Edes. ");
INSERT INTO ncf_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tiwaa “ ‘xadi no goto a xap metmet, ma biaa ie suaamsuaam ta xap metmet.’ ");
INSERT INTO ncf_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Moroaa naba amixati no inaman araraa taman ie malen xa unsausawit ta amixati tinabel taman tes. ");
INSERT INTO ncf_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Tes asuk axaau. Oro nawe a se xosorlii xan xontes, naba sen xontes mula we. Gim na ie tes lalon gim tsaa ma gim na man etudim taman malina.” ");
INSERT INTO ncf_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Mil Iesu ga papaalii biaa xolot ma ga laa lalon xolot ina Judaia ma ga tabaxi daansel Jodan. Malep di sebula xaalame sangan ma ga asingan di malen xan namaang. ");
INSERT INTO ncf_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Biexaa Paarasi di xaalame sangan ia ngali le xonon. Di atsuraa, “A tutiik ngali xa taamat naba atsiplii xan tubu?” ");
INSERT INTO ncf_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","A xisi, “Sen maarang xaawe Moses tii paare watwat ngali gim na xosaraa?” ");
INSERT INTO ncf_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Di we, “Moses asiir ngali taamat naba atalaa xa lan perper ngali atsiplii aina ma tulen ia laa.” ");
INSERT INTO ncf_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Iesu a xisi, “Tii weaatia amuina nagim no butsa tii taban, biaabi Moses tii ga atala abala lo. ");
INSERT INTO ncf_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Oro sin atiltsoli ina axoxos, ‘Moroaa a xosaraa taamat ma aina.’ ");
INSERT INTO ncf_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Biaabi taamat naba papaalii xan mom ma nagaa ma na laa man etaxaa mii xan tubu. ");
INSERT INTO ncf_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ma delu se tsap xuuk mu.’ Ma delu se xap lua oro delu se tsap pakpak ta xuuk mu. ");
INSERT INTO ncf_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Biaabi Moroaa ga se esumae ngen delulu ma na xap xa taamat na atsiplii delulu.” ");
INSERT INTO ncf_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Biaa di ta se manman naanua sebula, xan no tsi asasing di ga atsuraa Iesu taman abala. ");
INSERT INTO ncf_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","A xisi, “Saa ia ta atsiplii xan tubu ga maxis sin aina xaatsap, iwaa taamat a se matul mii iwaa xa ta xap maxis sin. ");
INSERT INTO ncf_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma nawe aina atsiplii xan maxis, ma ga maxis sin taamat xaatsap, a se matul mii iwaa xa ta xap maxis sin.” ");
INSERT INTO ncf_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","No inaman di le tali xadi no tsi dokdok sin Iesu ngali naba taxaanai di, oro no tsi asasing di ga imii di. ");
INSERT INTO ncf_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Biaa Iesu ta lasi abala, asuk magaa, ga paare sin di, “Gim papaalii abia no tsi dokdok di na xaalame sangan iaa. Gim nangaam tilbanti di. Amuina xan Maradaan Moroaa xadi abia di, ta malen abala no tsi dokdok. ");
INSERT INTO ncf_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Iaa suk asaaiti gim taman so. Saa ta xap adi xan Maradaan Moroaa malen xa tsi dokdok naba suk xap tsiga.” ");
INSERT INTO ncf_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ma ga giwaa no tsi dokdok lalon no liman, aturungi liman papan di ma atubudaani di. ");
INSERT INTO ncf_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iesu a se tiltsoli ngali es laa, o iexa taamat ga sol laa sangan, ma ga sage putput laamuaan ia ga atsuraa, “Unaasasing axaau, iaa na xosaraa semaarang ngali adi tino laaliu?” ");
INSERT INTO ncf_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Iesu ga xisi, “Ngalisa u ta putsangi iaa axaau? A xap xa na axaau oro Moroaa mu. ");
INSERT INTO ncf_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","U atii no lo: ‘Nangaam sas amantei xa, nangaam matul mii xa aina ta xap num tubu, nangaam pula, nangaam paare dadare, nangaam apanaai xa, u na manglen num mom ma nagaa.’ ” ");
INSERT INTO ncf_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ga paare, “Unaasasing, iaa tii suk long amusili abala no lo araraa, sin iaa tii tsi dokdok tsaa.” ");
INSERT INTO ncf_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iesu asuk nanen tutiik sin ia taman titii ma ga paare, “U muun tsaa ngali was ta xuuk, u na laa sune taman num no maarang araraa, ma u na tabali no muunwas, ngali u ba ie was axaau balalangit. Mil xaalame, le amusili iaa.” ");
INSERT INTO ncf_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Sin abala, no matan taamat asuk birawis, ma ga suk es laa taman lolbiir amuina ia untang. ");
INSERT INTO ncf_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iesu a nanen iʼis ma ga paare ngali xan no tsi asasing, “A suk lelep buxa ngali xa untang ngali tsiga lalon xan Maradaan Moroaa!” ");
INSERT INTO ncf_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","No tsi asasing di suk tunga sin xan no totore. Oro Iesu ga sebula paare, “No tsi, asuk lelep buxa ngali tsiga lalon xan Maradaan Moroaa! ");
INSERT INTO ncf_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Asuk malus mu ngali xa kemal na tsiga lalon mat ina nil, ngen xa untang ngali tsiga sin xan Maradaan Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","O no tsi asasing di suk olol buxa, ma di ga paare engen di, “O saa naba pupua ngali adi tino laaliu?” ");
INSERT INTO ncf_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iesu a matngen di ma ga paare, “Taamat a xap pupua ngali xosaraa abala no maarang, oro a xap sin Moroaa, a pupua ngali xosaraa no maarang araraa.” ");
INSERT INTO ncf_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita ga paare ngali ia, “Giem se poroklii no daan maarang araraa, ngali amusili iu!” ");
INSERT INTO ncf_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Iesu ga xisi, “Iaa asaaiti gim taman so. Nawe xa tii se papaalii xan no matenaanua, o xan no turamasen, o no moton, o nagaa, o mom, o xan no tsi, o xan no uma ngali iaa ma ngali inesaait mamainaang, ");
INSERT INTO ncf_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","mil naba adi no sangsangaul axuuk ina iliil lapalaa buxa, sin no leng ta manman sin abala tino ma Moroaa naba tali no daan maarang buxa ngen abia no ti laamua. Naba tali no anua ma no turamasen, no moton, no nagaa, ma no tsi, ma no uma. Oro biexaal di ba asosongi ia ma mil sin xapkap ina, naba ie tino laaliu. ");
INSERT INTO ncf_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Oro xuduxudu biaa di ta lalaamua di ba amil o biaa di ta a mil di ba lalaamua.” ");
INSERT INTO ncf_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Sin xadi ines laa lalon sal xaali lapalaa Jerusalem, Iesu a es laamuaan di. Ma no tsi asasing di tii ga suk tunga ma biaa di, di tii es amil di suk mataa. Ma ga sebula gii tsaxali sangaul ma ga laa lua ina tsi asasing laa sin gelgel o tii ga asaaiti di, taman sen maarang naba ta tsap sin ia. ");
INSERT INTO ncf_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ga paare, “Gita ba laa lapalaa Jerusalem. Xan Tsi Taamat di ba babel tali laa papan no liman no lalaamua ina no unsausawit ma no unaasasing ina lo. Di ba atutali minet sin ia. Di ba tali ia laa sin no Gentail, ");
INSERT INTO ncf_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ma di ba reret ngen ia ma di ba ibisi ia. Di ba ririiti ia taman ririit ma sas amantei. Mulina no leng ta tuul, naba sebula tapaas mula.” ");
INSERT INTO ncf_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Mil Jeims ma Jon, xan no tsi ilaa Sebedi, delu xaalame sangan ia. Delu paare, “Unaasasing, gelu saan ngali una xosaraa sawe gelu ta atsuraa iu ngali.” ");
INSERT INTO ncf_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ga atsura, “Sen maarang xaawe gulu saan ngali iaa ba xosaraa ngali gululu?” ");
INSERT INTO ncf_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Delu xisi ia, “Gelu saan ngali u na siir tali xa ina gelulu na tsotso sin num lima mua o xa sin lima xaiaar, sin num minaalam.” ");
INSERT INTO ncf_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","O Iesu ga paare, “Gulu xap atii sa maarang gulu ta atsura ngali. A pupua ngali gulu ba nun lalon abia sobuk iaa ba ta nun taman? O a pupua ngali gulu ba axaxadaan bula taman abia axaxadaan iaa ba axaxadaan taman?” ");
INSERT INTO ncf_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Delu xisi ia, “Iou, gelu pupua!” Iesu ga paare ngali delulu, “Gulu ba nun lalon abia sobuk iaa ba ta nun lalon, ma gulu ba axaxadaan taman abia axaxadaan iaa ta axadaan taman. ");
INSERT INTO ncf_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Oro ngali tsotso sin nugu lima mua o sin nugu lima xaiaar, iaa xap pupua ngali tali. Balawaa no xolot ngali abia mu delulu, Moroaa ta se taxaaturungi.” ");
INSERT INTO ncf_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Biaa sangaul ina no tsi asasing di ta alongmen abala, di suk magaa ngali Jeims ma Jon. ");
INSERT INTO ncf_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Iesu a ilei axumuli di ma ga paare, “Gim atii we, biaa di, di ta we, di no lalaamua ina no Gentail, di orong papan di. Ma xadi no lalaamua lapalaa, di ie banam papan di. ");
INSERT INTO ncf_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Gim nangaam malen di. Nawe xa a saan ngali naba lot labatina gim, na suk xosaraa ia tsaa malen untutule. ");
INSERT INTO ncf_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nawe xa ina gim a saan ngali naba tsap lalaamua, ia na malen untutule sin no inaman araraa. ");
INSERT INTO ncf_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Sin abia uk sal, Xan Tsi Taamat a xap xaalame ngali no inaman di ba taxaa ngali ia. Oro a xaalame ngali naba tiltsomi di, ma ngali tali xan tino malen xa iliil ngali no inaman araraa, di ba adi tino laaliu.” ");
INSERT INTO ncf_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Mil di tii ga xaalame Jeriko. Biaa Iesu mii xan no tsi asasing ma biaa malep di ta poroklii abia inaman laba, iexa matababa, iesan Bartimeus (xan tsi ilaa Timeus) a tsotso sin gelgel ina sal ma ga lo ningning ngali xakaa was. ");
INSERT INTO ncf_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Biaa tii alongmen we Iesu in Nasaret, asuk xuup lot, “Iesu, xan tsi Dewit, u na ie biirbirum sin iaa!” ");
INSERT INTO ncf_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Xuduxudu ina di, di suk imii ia, di ga paare ngali na bong. Oro asuk xuup lot buxa, “Xan tsi Dewit, u na ie biirbirum sin iaa!” ");
INSERT INTO ncf_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Iesu atilwat ga paare, “Ilei ia.” Ma di ga ilei aia matababa, di ga paare, “U na suk taton! U na tapaas, a ilei ngali iu.” ");
INSERT INTO ncf_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ga lii xan laplap disdis laa sin gelgel, apistapaas ma ga xaalame sangan Iesu. ");
INSERT INTO ncf_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Iesu atsuraa ia, “U saan ngali ina xosaraa sa susum?” Matababa a xisi, “Rabai, iaa saan ngali nanen.” ");
INSERT INTO ncf_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Iesu ga paare, “Laa. Num tinaalnge a se atoaa iu.” Tiwaa tsaa tii suk pupua ngali nanen ma ga es amusili Iesu lalon sal. ");
INSERT INTO ncf_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Biaa di se eses atataaen Jerusalem ma di tii le tsap Betapage ma Betani papan Buk Olip. Iesu ga tulen xan no tsi asasing ta lua, ");
INSERT INTO ncf_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ga paare ngali delulu, “Gulu laa lalon abia xobel laamuaan gululu, tiwaa tsaa biaa gulu ta se es tsiga lalon xobel, gululu ba tatanginai donki dokdok iwaa di ta pis atilngi. Xa a xap mager tsotso papan. Gulu na lubati ia ma gulu na taal axaalamengen tala. ");
INSERT INTO ncf_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nawe xa atsuraa gululu, ‘Ngalisa gulu ta xosaraa abala?’ Gulu na asaaiti ia, ‘Orong a saan ngali ma nap dokdok mu naba tulen mulangenai.’ ” ");
INSERT INTO ncf_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Delu tii laa ma tatanginai donki dokdok, di ta pis tali lokobel ina sal atataaen matenmat ma delu ga lubalii ia. ");
INSERT INTO ncf_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Biexaa inaman di tiltil atia di ga atsura, “Semaarang abia gululu ta xosaraa? Ngalisa gulu ta lubalii donki dokdok?” ");
INSERT INTO ncf_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Delu xisi malen Iesu tii asaaiti delulu. Ma no inaman di sirawaa delulu ngali adi aia donki dokdok. ");
INSERT INTO ncf_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Biaa delulu ta le tali donki dokdok sin Iesu. Di sulali xadi no laplap disdis papan donki dokdok o ga tsotso papan. ");
INSERT INTO ncf_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Xuduxudu ina no inaman di sulali xadi no laplap disdis lalon sal o biexaal di adi no laxe ina ie ma di ga aturungi amusili sal. ");
INSERT INTO ncf_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Biaa no inaman di ta es laamua ma biaa di, di ta es amil di xuup, “Osaana! Moroaa naba atubudaani Iwaa xa ta xaalame lalon iesan xida Orong! ");
INSERT INTO ncf_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Moroaa naba atubudaani biaa Maradaan ta malen xan Maradaan xida mom Dewit, Osaana! Paʼii Moroaa Balalangit!” ");
INSERT INTO ncf_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iesu atsiga Jerusalem ma ga laa lalon Xan Anua Moroaa. A nanen iʼis sin no mat maarang araraa, oro amuina ta se nale bingbing, asuk laa Betani mii sangaul axuuk ma ga laa lua. ");
INSERT INTO ncf_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Sin leng papan biaa di ta se papaalii Betani, Iesu asuk itol. ");
INSERT INTO ncf_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Aman palpalaa tsaa ga lasi iexa ie fik taman xan no laalaa. A laa sangan aia ie fik ngali atii nawe xa waawaan biaa sin. Biaa ta se laa sangan, a xap tatanginai xaa waawaan sin, no laalaa mu. Amuina a xap xan leng no ie fik ngali waa. ");
INSERT INTO ncf_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","O ga paare sin aia ie fik, “Naba suk xap xa na ngani xa waawaan sin iu bula.” Ma xan no tsi asasing di alongmen ia ta paare taman. ");
INSERT INTO ncf_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Biaa ta se tsap Jerusalem, atsiga lalon Xan Anua Moroaa, ma ga atiltsoli ngali xalel atsuulngi abia no inaman di ta susune ma biaa di, di ta iliil maarang ma susune tia. A puxenlii no ibe ina soxisi no xuxute ma no niaan xalkale ina abia di, di ta sune taman no buna. ");
INSERT INTO ncf_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ma ga xap sirawaa xa ngali na adi xan no maarang laa lalon no xolot tia lalon Xan Anua Moroaa. ");
INSERT INTO ncf_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ma ga asingan di, ga paare, “Di atalaa: “ ‘Nugu anua, di ba putsangi anua ngali sausawit sin no inaman labalaba araraa.’ Oro gim se xosaraa ga tsap malen ‘xadi anua no unpulapula.’ ” ");
INSERT INTO ncf_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","No lalaamua ina no unsausawit ma no unaasasing ina lo, di alongmen abala ma di ga nen tsalei xa sal ngali sas amantei ia, oro di tii mataatinai buxaai amuina biaa malep di tunga buxa sin xan no asasing. ");
INSERT INTO ncf_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Biaa ta se nale bingbing di papaalii abia inaman laba. ");
INSERT INTO ncf_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Lawaareng, biaa di ta se es mula, di tii lasi abia ie fik ta se malang xaal sin xan no baa. ");
INSERT INTO ncf_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita adodomi o ga paare sin Iesu, “Rabai, lasi! Iwaa ie fik u tii xororaa a se malang.” ");
INSERT INTO ncf_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Iesu a xisi, “U na ie tinaalnge sin Moroaa. ");
INSERT INTO ncf_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Iaa asaaiti gim taman so, nawe xa a paare sin balawaa buk, ‘Laa lii iu tsaa talaa lau.’ Ma ga xap boik lalon xan butsa oro ga taltaalnge sin sawe ta paatina naba tsap, biaa naba tsap ngali ia. ");
INSERT INTO ncf_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Biaabi iaa asaaiti gim, senaara gim ta ningning ngali lalon sausawit, gim na taltaalnge we gim se adi, ma biaa maarang num ba se. ");
INSERT INTO ncf_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ma biaa gim ta til sausawit, nawe gim ie mamaet ngali xa, gim na adodolii abia mamaet, ngalibi nagim Mom balalangit naba adodolii nagim no mat namaang tsaxa.” ");
INSERT INTO ncf_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Di sebula le tsap Jerusalem. O biaa Iesu ta lo eses lalon biexaa xolot ina Xan Anua Moroaa, no lalaamua ina no unsausawit, no unaasasing ina lo, ma no xusaak, di suk xaalame sangan. ");
INSERT INTO ncf_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Di ga atsuraa ia, “Sin sen banam o u ga xosaraa abala no maarang? Sa tali abala banam susum ngali xosaraa abala?” ");
INSERT INTO ncf_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Iesu ga xisi, “Iaa ben atsuraa gim taman xien atsutsura. Gim na xisi iaa, ma iaa ba asaaiti gim taman sen banam abala, iaa ta xosaraa no maarang taman. ");
INSERT INTO ncf_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Gim asaaiti iaa, biaa axaxadaan sin Jon, axaal balalangit o axaal sin taamat mu?” ");
INSERT INTO ncf_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Di usili abala labatina di tsaa, di ga epaare, “Nawe gita we axaal balalangit, naba atsuraa gita we, ‘O ngalisa gim ta xap taltaalnge sin ia?’ ");
INSERT INTO ncf_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Oro nawe gita we, ‘Axaal mu sin no taamat.’ ” (Di mataa sin no inaman, amuina di tii taltaalnge we, Jon ia propet so.) ");
INSERT INTO ncf_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ma di ga xisi Iesu, “Giem xap atii.” Iesu ga paare, “Ma iaa ba xap asaaiti gim, saa tii tali abala banam sin iaa ngali xosaraa abala no maarang.” ");
INSERT INTO ncf_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Atiltsoli ngali paare taman no totore puapua, “Taamat asoxaa uma waain. A bateng ulti ma ga xaii mat ngali parlii daan ina waain. A xosaraa anua ta laa lapalaa ngali xoxo sin uma waain. Ma ga bisi abia uma waain laa sin biexaa untinaxaa ma ga tapaas laa amusili xan ines. ");
INSERT INTO ncf_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mil, sin leng se ngali papaas sin no waawaan waain. Iwaa tapkina uma waain a laa ma ga tulen untutule laa sangan no untinaxaa lalon uma waain ngali adi xaa waawaan waain. ");
INSERT INTO ncf_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Oro di tsiili ia ma di ga suk tsaapi ia ma di ga tulen mulangenai gomsaa. ");
INSERT INTO ncf_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mil ga sebula tulen iexa untutule laa sangan di. Di pantsi papan xuan ma di ga suk amangieli ia. ");
INSERT INTO ncf_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","A sebula tulen iexa untutule, ma di ga sas amantei. A sebula tulen biexaa daan untutule. Biexaal ina di, di tsaapi o biexaal di sas amantei. ");
INSERT INTO ncf_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“A se xuuk mu iexa ngali tulen, xan tsi, iwaa ta suk titii buxaai. A tulen amilngen se ma ga paare, ‘Di ba manglen nugu tsi.’ ");
INSERT INTO ncf_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Oro no untinaxaa di ga epaare ngen di, ‘Ilawaa tsi, naba momtsoli uma waain. Gim xaalame, gita laa sas amantei ia, ngalibi gita ba tapkina uma waain.’ ");
INSERT INTO ncf_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ma di ga giwaa ia ma sas amantei ia ma di ga lii atsuulngi nan uma waain. ");
INSERT INTO ncf_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Iwaa tapkina ina uma waain naba se xosaraa sa? Naba laa sangan no untinaxaa ma naba sas amantei di, ma naba bisi uma waain sin biexaal. ");
INSERT INTO ncf_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Gim se xoxoti abala Inaatel Pat. “ ‘Balawaa xaat no untunumar di ta palolii, a se tsap xa atkale ina tsigur. ");
INSERT INTO ncf_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Orong a se xosaraa abala no ma ga mat geramis nan no matan gita.’ ” ");
INSERT INTO ncf_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Di ga nanen ngali xa sal ngali tsiili ia amuina di tii se atii we, tii paare taman abala totore puapua ngali epuske mii di. Oro di tii mataatinai abia malep o di ga papaalii ia ma di ga laa. ");
INSERT INTO ncf_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mil di ga tulen biexaa Paarasi ma biexaa Erodian (no inaman di ta amusili King Erot) laa sangan Iesu. Di saan ngali tsiili ia amusili xan no totore. ");
INSERT INTO ncf_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Di tii xaalame sangan ma di ga paare, “Unaasasing, giem atixi we, iu taamat ina soina. No inaman di xap pupua ngali putsi iu amuina iu xap adodo aloti di malen di no sa. Ma u asasing taman xan sal Moroaa so. U we, a tutiik ngali ulii taakis laa sin Sisa? A pupua ngali gita ba uuli o a xap?” ");
INSERT INTO ncf_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Oro Iesu tii se atixi di no unpiekpiek bal ma ga paare, “Ngalisa gim ta xonon ngali atsina iaa? Gim tali xa xuxute ngali iaa ba lasi.” ");
INSERT INTO ncf_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Di tali nan xuxute sin ia ma ga atsura, “Patpatsen saa aila papan xuxute? Ma iesan saa abia papan?” Di xisi, “Xan Sisa.” ");
INSERT INTO ncf_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Mil Iesu ga paare ngali di, “Tali sin Sisa biaa no, xan no Sisa, ma tali sin Moroaa biaa no, xan no Moroaa.” Ma di ga olol buxa sin ia. ");
INSERT INTO ncf_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Mil no Saadusi biaa di ta paare we, a xap xa tinapaas mula. Di xaalame sangan taman biexa atsutsura. ");
INSERT INTO ncf_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Di paare, “Unaasasing, Moses tii atatal ngali gita we, ‘Nawe turumasen xa taamat ametli xan tubu ma ga xap ie no tsi sin, turamasen na maxis sin aia aina nal, turumasen ta metlii ngali na ie no tsi sin.’ ");
INSERT INTO ncf_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tii paasaalua tuu masen turamasen. Nan axuuk a setauan maxis sin aia aina, ga metli ma ga xap ie no tsi sin. ");
INSERT INTO ncf_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nanaalua ina turamasen ga maxis sin aia aina nal. Ma ga sebula metli ga xap tali xaa tsi sin. Ma nanaatuul bula aweaatia. ");
INSERT INTO ncf_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Biaa tumasen turamasen ta paasaalua di xap ie no tsi sin aia aina nal ma iwaa aina bula ga se met. ");
INSERT INTO ncf_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Sin leng ina tinapaas mula, xan tubu saa so ina di? Amuina apaasaalua ina di se araraa, di tii maxis sin.” ");
INSERT INTO ncf_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iesu tii ga xisi, “gim xap tutiik, ngali no muina ta lua, amuina gim xap atii no Inaatel Pat o xan xoror watwat Moroaa. ");
INSERT INTO ncf_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Biaa no minet di ba ta tapaas mula, no taamat di ba xap maxis ma di ba xap tali no aina sin minaxis, di ba malen no angelo in balalangit. ");
INSERT INTO ncf_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Talaawaa taman no minet di ba ta tapaas mula. Gim tii se xoxoti lalon xan inaatel Moses, sin abia ie dokdok tii dami, biaa Moroaa tii paare sin ia, ‘Iaa xan Moroaa Abaram, xan Moroaa Aisak ma xan Moroaa Jakop.’ ");
INSERT INTO ncf_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ia a xap Moroaa ina no minet oro ina di, di ta tino. Nagim no adodo asuk apanaai gim.” ");
INSERT INTO ncf_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Iexa ina no unaasasing ina lo tii xaalame ma ga alongmen di ta papaare. Tii ga lasi we Iesu asuk xiis axaautsi xadi no atsutsura. Ga atsuraa ia, “Sen lo asuk lot buxa ngen abala no lo araraa?” ");
INSERT INTO ncf_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Iesu ga xisi, “Iwaa lo ta suk lot buxa abala: ‘Lolong, no Israel, iwaa Orong xida Moroaa, iwaa Orong ta xuuk. ");
INSERT INTO ncf_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","U na titii buxaai Orong num Moroaa lalon num butsa araraa, lalon nantanuaam araraa, lalon num adodo araraa, ma taman num watwat araraa.’ ");
INSERT INTO ncf_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nanaalua ina lo aweaatalaa, ‘U na titii buxaai no turaam atataaen iu malen iu tsaa.’ Balawaa no lo ta lua asuk lot buxa ngen no lo araraa.” ");
INSERT INTO ncf_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Taamat tii xisi, “Biaa xixiis asuk axaau, unaasasing. U suk tutiik, u ta paatina we, Iwaa Moroaa axuuk mu ma a xap xaal bula oro ia mu. ");
INSERT INTO ncf_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","U na titii buxaai Moroaa taman num butsa araraa, ma num adodo araraa, ma taman num watwat araraa. Ma u na titii buxaai abia di, atataaen iu malen u ta titii buxaai iu tsaa. Balawaa no namaang asuk lot buxa ngen no tinabel ngali tsutsungit tali sin Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Biaa Iesu tii lasi we, tii xisi taman sinaae. Ma ga paare ngali ia, “U xap man palpalaa sin xan Maradaan Moroaa.” Mulina abia, di suk mataa ngali atsuraa ia taman xaa atsutsura bula. ");
INSERT INTO ncf_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Biaa Iesu tii asingan no inaman lalon xolot ina Xan Anua Moroaa. Ga atsura, “No unaasasing ina lo di paare we, ‘Karisito ia xan tsi Dewit.’ ");
INSERT INTO ncf_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dewit ia tsaa a papaare sin xan watwat Nantanua Pat ga paare: “ ‘Orong a paare sin nugu Orong: “Tsotso sin nugu lima mua, til sin iaa ba ta tali num no matenkorot paina no xaim.”’ ");
INSERT INTO ncf_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dewit tsaa, a putsangi Karisito ‘Orong.’ O asen parawe we, ia xan tsi Dewit?” Xaraxin malep di lolong sin ia taman pinaalam. ");
INSERT INTO ncf_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Iesu a paare laa tsaa ma ga asingan di. Ma ga paare we, “Atewaai no inaman sin no unaasasing ina lo. Di saan ngali eses ulti no xolot, di ta tamtuel lalon no uga disdis ta mat geramis, ma di saan ngali no inaman di na suei atatoni di, sin no xolot susune. ");
INSERT INTO ncf_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Di saan ngali ie no xalkale lot lalon no anua sausawit. Ma di saan ngali no niaan xalkale ina mangmangle xa sin no xaraxin luxaal. ");
INSERT INTO ncf_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Di saan ngali pulaxi xadi no anua no nal. Di saan ngali xosaraa no ningning disdis nan no matan biexaa inaman. Moroaa naba ininte sin abala no mat laxen inaman tsaxa.” ");
INSERT INTO ncf_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iesu a tsotso xaatian ina niaan atuturung xuxute ma matngen abia malep di ta atuturung xadi no xuxute lalon anuen tang ina Xan Anua Moroaa. No daan untang di tali no xaraxin xuxute laa lalon. ");
INSERT INTO ncf_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Oro iexa aina nal, tii xaalame ma ga tali no peni dokdok alua, biaa ta pupua malen toia axuuk. ");
INSERT INTO ncf_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ga ilei xan no tsi asasing ngali xaalame sangan ia ma ga paare, “Iaa asaaiti gim taman so. Ilawaa aina nal ta muunwas, a taal buxaai lalon anuen tang ngen biexaal. ");
INSERT INTO ncf_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Di tabiel xaal sin xadi no minaas. Oro Ilawaa aina nal, amuina sin ta muunwas, asuk tabiel taman abia xan no xuxute araraa ina xan xalkale, ma ga se xap xakaa nen xuxute ngali tiltsomi ia tsaa.” ");
INSERT INTO ncf_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Biaa Iesu tii se papaalii Xan Anua Moroaa o iexa ina xan no tsi asasing ga paare ngali ia, “Unaasasing lasi! Balawaa tunumar ina Xan Anua Moroaa asuk matmirmir taman no xaraxin xaat.” ");
INSERT INTO ncf_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Iesu a xisi, “Gim se lasi balawaa no xaraxin tunumar araraa? A xap xa xaat naba matul papan biexaal, di ba lii di araraa laa lapula.” ");
INSERT INTO ncf_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mil sin Iesu ta lo tsotso papan Buk Ina Olip, xaatian ina Xan Anua Moroaa, Pita, Jeims, Jon ma Endru, di atsuraa ia xasinge, ");
INSERT INTO ncf_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Asaaiti giem, langisa so balawaa no maarang naba tsap? Ma sen mat axixila naba tsap ngali xosor puaa abia no maarang araraa?” ");
INSERT INTO ncf_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Iesu ga paare ngali di, “Gim na xoxo axaau, ngali xa na xap apanaai gim. ");
INSERT INTO ncf_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Xuduxudu di ba xaalame lalon iesaaga ma di ba paare, ‘Iaa Karisito,’ ma di ba apanaai xuduxudu. ");
INSERT INTO ncf_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Biaa gim ta alongmen no maxil ma no inesaait ina maxil, gim nangaam mataa. Balawaa no maarang naba tsap oro xapkapina leng bia tsaa ta xaalame. ");
INSERT INTO ncf_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","No xobel labalaba di ba esas mii biexaa xobel labalaba. No maradaan di ba esas mii biexaa maradaan. No xaraxin ninil ma no xaraxin itol naba tsap sin no daan xolot. Balawaa no atiltsoli ina sosong malen aina ta taxaa tsi. ");
INSERT INTO ncf_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Gim na xoxo. Di ba tsiili gim ma giwaa gim laa sin no kaunsel ina xobel ma di ba ririiti gim lalon no anua sausawit. Amuina sin iaa mu, gim ba til laamuaan no king ma no gawana ma gim ba paare leng sin di. ");
INSERT INTO ncf_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ma gim na babaais taman inesaait mamainaang setauan sin no xobel labalaba araraa. ");
INSERT INTO ncf_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Biaa di ta tsiili ma ininte sin gim, nangaam lolbiir ngali sen maarang gim ba ta paatina. Paatina samaarang Moroaa ta tali sin gim sin abia leng, sinsa a xap gim atia gim ta papaare, oro Nantanua Pat. ");
INSERT INTO ncf_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Lo masen turamasen delulu ba babel tali delulu laa sin minet, ma mom mii xan tsi. No tsi di ba epuske mii xadi no mom ma nagaa ma di ba xosaraa biexaal ngali sas amantei di. ");
INSERT INTO ncf_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","No inaman araraa di ba ngutsulen gim, amuina sin iaa. O iwaa mu ta til watwat til sin xapkapina naba tuo. ");
INSERT INTO ncf_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Biaa gim ta lasi xaraxin namaang morokon ta xosor atsoti tiltil ina abia xolot ta xap xan—papaalii no unxoxot di na leng—mil biaa di, di ta manman Judaia, di na sol laa papan no buk. ");
INSERT INTO ncf_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Na xap xa papan unga ina anua, na tsuul laa lapula o na tsiga lalon anua ngali alet atsuulngi xaa was. ");
INSERT INTO ncf_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Na xap xa ta manman lalon uma, na mula ngali adi xan uga disdis. ");
INSERT INTO ncf_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Sin abia leng, xaraxin xirabas sin no aina di ta maet ma biaa di ta tilaamamil sin no madalak. ");
INSERT INTO ncf_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Gim na sausawit ngali balawaa no maarang naba xap tsap sin leng ina tes laxum, ");
INSERT INTO ncf_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","amuina biaa no leng naba us taman xirabas biaa ta xap tsap weaatalaa xaal sin atiltsoli biaa Moroaa tii axosngi xolkolmoxo pupua atalaa—ma naba xap tsap bula. ");
INSERT INTO ncf_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nawe Orong naba xap xitip apitpiti no leng tsaxa, mil naba xap xa na tino. Oro ngali tilaamamil sin abia di, ta se inten tsoli, tii apitpiti abia no leng. ");
INSERT INTO ncf_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Sin abia leng, nawe xa naba paare ngali gim, ‘Lasi, Ilawaa se Karisito!’ O iexa naba we ‘Lasi, idawaa se,’ nangaam taltaalnge sin di. ");
INSERT INTO ncf_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Amuina no Karisito dadare ma no propet dadare, di ba asemat ma xosaraa no axixila xoror ngali apanaai no untaltaalnge—nawe a pupua. ");
INSERT INTO ncf_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Biaabi gim na xoxo; iaa se anaai gim setauan tsaa. ");
INSERT INTO ncf_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Sin abia no leng amusili abia xirabas, “ ‘Matanios naba lodo, ma uleng naba xap tali laleng; ");
INSERT INTO ncf_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","No xadaxada di ba xol xaal wang. Ma Moroaa naba aguraa no maarang balalangit.’ ");
INSERT INTO ncf_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Sin abia leng no inaman di ba lasi Xan Tsi Taamat naba ta xaxaalame lalon no xelangit taman xoror watwat ma minaalam. ");
INSERT INTO ncf_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma naba tulen xan no angelo laa ulti xolkolmoxo araraa, ma di ba axumuli biaa di, ngali Moroaa ta se axilangi di, biaa di ta xaal sin no tsigur ta et, xaal sin xapkap ina xolkolmoxo laa sin xapkap ina balalangit. ");
INSERT INTO ncf_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Talaawaa gita na alet asasing sin abala totore puapua ina ie fik: Sauna mu biaa no laxe ta se malus ma no lalawina a se atiltsoli ngali xol, gim se atixi we, leng ina soksok a se atat. ");
INSERT INTO ncf_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","O nawe gim lasi balawaa no maarang ta tsap, gim atixi biaa leng a se atat, bala se matenmat. ");
INSERT INTO ncf_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Iaa asaaiti gim taman so. Balawaa utmilmil di ba suk xap met til no mat maarang araraa naba ta tsap. ");
INSERT INTO ncf_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Balalangit ma xolkolmoxo delulu ba xap, oro nugu totore naba xap xa xapkapina. ");
INSERT INTO ncf_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“A xap xa na atii abala leng naba ta tsap. Xan Tsi ma no angelo in balalangit di xap atii, oro Mom mu xasinge, atixi. ");
INSERT INTO ncf_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Gim na xoxo! Gim na taxaaturung! Gim xap atixi langisa biaa leng naba ta xaalame. ");
INSERT INTO ncf_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","A malen xa taamat ta laa sin xan ines. Apapaali xan anua ma ga tali xan no untutule di ga tilaamamil sin anua. A tali sin no untutule xuxuuk taman xan mat laxen tinaxaa xaatsap ngali di ba xosaraa. Ga asaaiti iexa ngali xoxo sin matenmat. ");
INSERT INTO ncf_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Biaabi gim na xoxo amuina gim xap atixi langisa tapkina anua naba mula xaalame. Oro naba xaalame nale mu o labatina bing o sin puraa naba ta teng o lawaareng bingbing. ");
INSERT INTO ncf_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nawe a xaalame isagaa mu, ma nangaam papaalii na le tatanginai gim ta urarange. ");
INSERT INTO ncf_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Sawe iaa ta asaaiti gim, iaa asaaiti no inaman araraa: Gim na taxaaturung!” ");
INSERT INTO ncf_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","A se lua mu nen leng se biaa mu, ngali Luxaal ina Esliwaa ma Luxaal ina Tsoki xonone ta xap xa iis sin. No lalaamua ina no unsausawit ma no unaasasing ina lo di xonon ngali tsalei xa sal na xuxii ngali tsiili Iesu ma sas amantei. ");
INSERT INTO ncf_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Oro di paare, “Gita ba xap xosaraa sin leng ina luxaal, amuina no inaman di ba soro atiltsoli esas.” ");
INSERT INTO ncf_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Biaa Iesu tii manman Betani tii xalkale lalon xan anua Saimon, iwaa ta ie minet basbas, iexa aina a xaalame sangan taman sobuk xaat ta us taman daan ta tso mamainaang, xan iliil abuxa. Atsalali sobuk xaat ma ga arueti biaa daan ta tso mamainaang papan xuan Iesu. ");
INSERT INTO ncf_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Biexaal ina di biaa di atia, di magaa, ma di ga epaare engen di, “Ngalisa ta xosorlii gomsaai abala daan ta tso mamainaang? ");
INSERT INTO ncf_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nii ba pupua ngali sune taman ngali adi iliil ina miet ta xuuk ma xolot, biaa xuxute nii ba tali sin no muunwas.” Di tii ga imii buxaai ia. ");
INSERT INTO ncf_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Iesu ga paare, “Gim poroklii ia. Ngalisa gim ta imii ia? A xosaraa namaang ta matmirmir sin iaa. ");
INSERT INTO ncf_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","No muunwas di ba tigiri manman mii gim ma gim pupua ngali tiltsomi di sin no leng gim ta saan. Oro iaa ba xap tigiri manman mii gim. ");
INSERT INTO ncf_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","A xosaraa abia ta pupua ngali xosaraa. Arueti daan ta tso mamainaang papan no isuaaga setauan ngali taxaaturungi nugu pupuna. ");
INSERT INTO ncf_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Iaa asaaiti gim taman so, itaa biaa inesaait mamainaang di ba ta baais laa sin xolkolmoxo araraa, sawe tii se xosaraa di ba asaaiti bula taman ia, ngali adodomi ia.” ");
INSERT INTO ncf_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Mil Judas Iskariot, iexa ina sangaul ma ga laa lua, a laa sangan no lalaamua ina no unsausawit ngali babel tali Iesu sin di. ");
INSERT INTO ncf_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Di suk taton ngali alongen abala ma di ga xubatsi ngali tali xaa xuxute sin ia, biaabi ga nanen ngali xa sal axaau ngali naba tali ia sin di. ");
INSERT INTO ncf_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Sin nanaaxuuk ina leng sin Luxaal ina Tsoki. Biaa namaang xadi no Jiu ngali tsutsungit tali sipsip dokdok ina Esliwaa, xan no tsi asasing Iesu di atsuraa ia, “U saan ngali itaa giem na laa ngali taxaaturungi no maarang ngali u ba ngani abia Luxaal ina Esliwaa?” ");
INSERT INTO ncf_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Biaabi ga tulen xan no tsi asasing ta lua, ga asaaiti delulu, “Gulu laa lalon inaman laba ma iexa taamat ia ta atsaxei sobuk taman daan naba sabasue gululu. Gulu na amusili. ");
INSERT INTO ncf_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Biaa ta tsiga lalon anua, gim na atsuraa tapkina anua, ‘Unaasasing atsura: inaabi xabin ina axos xibong biaa iaa ba pupua ngali ngani luxaal ina Esliwaa mii nugu no tsi asasing?’ ");
INSERT INTO ncf_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Naba asen gululu taman xabin lot tade lapalaa ina anua. Di tii se taxaaturungi abia xabin. Gululu na taxaaturungi abia luxaal atia ngali gita.” ");
INSERT INTO ncf_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Lo tsi asasing delu tapaas ma delu ga laa lalon inaman labalaba ma delu ga tatanginai no mat maarang ta tsap malen Iesu tii se paare taman. Biaabi delu tii ga taxaaturungi Luxaal ina Esliwaa. ");
INSERT INTO ncf_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Biaa ta se nale bingbing Iesu a se tsap lalon anua mii sangaul ma ga laa lua. ");
INSERT INTO ncf_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Biaa di ta lo angangen etudim papan ibe, ga paare, “Iaa asaaiti gim taman so, xa ina gim naba babel tali iaa, iwaa xa ta angangen mii iaa.” ");
INSERT INTO ncf_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Di tii ga suk lolbiir ma di xuxuuk di paare ngali ia, “Aso, a xap iaa?” ");
INSERT INTO ncf_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","A xisi, “Xa ina abia sangaul ma ga laa lua, iwaa ta iwaa tsoki mii iaa lalon koi. ");
INSERT INTO ncf_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Xan Tsi Taamat naba laa malen Inaatel Pat tii se asaait taman ia. Oro xaraxin xirabas sin aia ta babel tali Xan Tsi Taamat. Nii ba suk axaau nawe xan nagaa na xap taxaane ia.” ");
INSERT INTO ncf_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Biaa di ta lo angangen, Iesu a adi tsoki, ga putsangi axaau, atsabaxi ma ga tali sin xan no tsi asasing ga paare, “Gim adi, balawaa nugu pakpak.” ");
INSERT INTO ncf_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mil ga adi sobuk waain, ga putsangi axaau, ma ga tali sin di, ma di araraa, di ga nun sin abia sobuk. ");
INSERT INTO ncf_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ga paare sin di, “Balawaa nugu dal ina xuxubu uul, tii rue tsuul ngali no daan inaman. ");
INSERT INTO ncf_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Iaa asaaiti gim taman so, iaa ba xap bula nun sin waawaan waain, til sin leng iaa ba ta nunngi biaa ta uul lalon xan Maradaan Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Biaa di tii se anaangi nan ararouk, di ga laa papan Buk Olip. ");
INSERT INTO ncf_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iesu ga asaaiti di, “Gim araraa gim ba sol loxona iaa. Inaatel Pat a paare weaatalaa: “ ‘Iaa ba tsaapi untilaamamil ina no sipsip, ma no sipsip di ba sol exatsep.’ ");
INSERT INTO ncf_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Oro mulina iaa ba ta se tapaas mula sin met, iaa ba laamuangen gim laa Galili.” ");
INSERT INTO ncf_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita a paare, “Nawe di araraa di sol loxona iu! Iaa ba xap.” ");
INSERT INTO ncf_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Iesu a xisi, “Iaa asaaiti iu taman so. Talaawaa nabing mil sin puraa naba ta xap mager teng nanaalua, u ba paare a tuul we, u xap atii iaa.” ");
INSERT INTO ncf_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pita ga xisi awatwati, “O nawe iaa nii met mii iu, iaa ba suk xap paare we, iaa xap atii iu!” Ma biaa di araraa di arie paatina abia uk totore. ");
INSERT INTO ncf_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Di laa lalon biexa xolot di ta putsangi Getsemani, ma Iesu ga paare sin xan no tsi asasing, “Gim na tsotso atala, ngali iaa ba laa sawit.” ");
INSERT INTO ncf_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","A giwaa Pita, Jeims, ma Jon, ngali laa mii ia. Ma ga atiltsoli ngali saaen lolbiir ma xaraxin xirabas. ");
INSERT INTO ncf_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ga paare ngali detatuul, “Nantanuaaga a se xaao taman lolbiir laa pupua sin xolot ina minet. Gutuu na manman atala ma gutuu na xoxo taman ningning.” ");
INSERT INTO ncf_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","A es laa dokdok palaaen di o ga xol tudu lapula ma ga sawit. A sawit ma ga paare, “Abba Mom, nawe a pupua lalon num ngitngit, timaa sirawaa iaa ngali ina xap tsigaii abia leng sosong biaa naba ta xaalame. Iu pupua ngali xosaraa no mat maarang araraa. Saali abala sobuk ina sosong sin iaa. Oro na xap sin nugu sirsiir, oro sin num sirsiir.” ");
INSERT INTO ncf_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mil ga sebula mula laa sangan xan no tsi asasing ma ga laa tatanginai detuu ta urange. A paare ngali Pita, “Saimon, iu urange? Iu xap pupua ngali xoxo liliis etaxaa mii iaa sin xa aua? ");
INSERT INTO ncf_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Gutuu na xoxo ma sausawit ngalibi gutuu ba xap xol sin xonkonon. Aso nantanua asiir oro isua a maluaai.” ");
INSERT INTO ncf_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ga sebula laa ma ga sawit taman abia uk maarang. ");
INSERT INTO ncf_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Biaa ta se mula, atatanginai detuu ta sebula urange, amuina no matan detatuul a se mamaxet ngali urange. Detuu xap atii sawe ngali paatina sin Iesu. ");
INSERT INTO ncf_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nanaatuul ina xan inamula, ga paare ngali detatuul, “Gutuu urarange ma iaaiaawis tsaa? A se pupua! Talaawaa, biaa aua a se xaalame. Lasi, xa naba babel tali Xan Tsi Taamat, papan no liman no untsaxa. ");
INSERT INTO ncf_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Gutuu tapaas! Nagaa na laa, nugu unbababel ila se xaalame.” ");
INSERT INTO ncf_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Tiwaa tsaa, ta lo papaare, Judas iwaa xa ina sangaul ma ga laa lua a se asemat. Tii xaalame mii xumul taman no bainat ta irom ma no bom, biaa no lalaamua ina no unsausawit, ma no unaasasing ina lo, ma no xusaak ina no Jiu, di tii se tulen abala malep. ");
INSERT INTO ncf_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Iwaa unbababel tii se ngiti mii di taman axixila. “Iwaa xa iaa ba ta nguri, iwaa se taamat aia. Gim na tsiili ma gim na laamuangen ia laa papan no liman no unxoxo.” ");
INSERT INTO ncf_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tiwaa tsaa a se es laa sangan Iesu, ma ga paare, “Rabai,” ma ga nguri ia. ");
INSERT INTO ncf_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Biaa no taamat di logotsi Iesu ma di tii ga tsiili ia. ");
INSERT INTO ncf_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Iexa ina abia di ta tiltil atat, ate tsoli xan bainat ma ga iritlii talingan xan untutule unsausawit lapalaa. ");
INSERT INTO ncf_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Iesu ga paare, “Gim xaalame ngali tsiili iaa taman no bainat ma no bom, malen xa unpulapula. ");
INSERT INTO ncf_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","No leng araraa iaa manman mii gim ma taal asasing lalon xolot ina Xan Anua Moroaa. Ma gim tii xap tsiili iaa. Oro Inaatel Pat naba taxaa puaa.” ");
INSERT INTO ncf_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Biaa xan no tsi asasing di sol papaalii ia. ");
INSERT INTO ncf_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Iexa taamat xulaau ta alen pu uga mu, amusili Iesu. Biaa di tii tsiili ia, ");
INSERT INTO ncf_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","a suk sol belbel laa poroklii xan uga. ");
INSERT INTO ncf_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Di giwaa Iesu laa sangan unsausawit lapalaa, ma no lalaamua ina no unsausawit, no xusaak ma no unaasasing ina lo, biaa di ta tsap etudim. ");
INSERT INTO ncf_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita a es amil palaaen di ma ga suk laa tsiga lokobel ina xan anua unsausawit lapalaa. Ga tsotso mii no unxoxo ma ga malil sin ie. ");
INSERT INTO ncf_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","No lalaamua ina no unsausawit ma no kaunsel araraa in Jiu, di lo tsatsel ngali xaa papaare leng ngali epuske mii Iesu ngalibi di ba pupua ngali sas amantei ia oro di xap tatanginai xawas. ");
INSERT INTO ncf_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Xuduxudu ina inaman di papaare leng taman no daraxe ngali epuske mii ia, oro di xap ukbal taman xadi no totore. ");
INSERT INTO ncf_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mil biexaal di til lapalaa ma di ga tali abala no papaare leng daraxe ngali epuske mii ia, ");
INSERT INTO ncf_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Giem alongmen ia ta paare, ‘Iaa ba baxi abala Xan Anua Moroaa biaa no taamat di ta xosaraa. Ma mulina sin no leng ta tuul, iaa ba xosor mulangenai biexa, biaa taamat ta xap xosaraa.’ ” ");
INSERT INTO ncf_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Oro xadi no papaare leng a xap ukbal mii di. ");
INSERT INTO ncf_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mil iwaa unsausawit lapalaa a til laamuaana di ma ga atsuraa Iesu, “U xap pupua ngali xisi? Sen papaare leng abala, balawaa no taamat di ta tali ngali epuske mii iu?” ");
INSERT INTO ncf_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Oro Iesu aman adamis ma ga xap tali xa xixiis. Ma iwaa unsausawit lapalaa ga sebula atsuraa ia, “Iu mu Karisito, xan Tsi Moroaa, iwaa gita ta langaari laa sin?” ");
INSERT INTO ncf_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Iesu a paare, “Iaa mu. Ma gim ba lasi Xan Tsi Taamat naba ta tsotso sin lima mua ina iwaa Belaba ma naba ta xaalame papan no xelangit in balalangit.” ");
INSERT INTO ncf_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Biaa iwaa unsausawit lapalaa alongmen abalaa asuk magaa buxa, ga tatari xan no uga disdis ma ga atsura, “Ngalisa gita ta saan ngali xaa daan tiltsoxoti? ");
INSERT INTO ncf_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Gim se alongmen xan reret laa sin Moroaa. Nagim sen adodo?” Di araraa, di atuti ngali sas amantei ia. ");
INSERT INTO ncf_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mil biexaal di ga atiltsoli ngali xamutsa ia. Di baa xaali no matan ma di ga tabaii taman no lapen liman di. Di ga paare, “Nawe iu xa propet so, saa pantsi iu?” Ma no unxoxo di ga giwaa ma di ga laa tsaapi ia. ");
INSERT INTO ncf_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Biaa Pita ta lo manman lapula lokobel ina anua, o xan tsaana untutule iwaa unsausawit lapalaa a xaalame atia. ");
INSERT INTO ncf_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Biaa ta lasi Pita ta malmalil sangan ie, asuk nan ariti ia. Ma ga paare, “U tii manman bula mii Iesu, iwaa taamat in Nasaret.” ");
INSERT INTO ncf_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Oro Pita a xisi, “Iaa suk xap atii o leng sin sen maarang iu ta papaare taman.” Tii es tsuul matenmat. ");
INSERT INTO ncf_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Biaa iwaa untutule tsaana tii lasi ia atia, a sebula paare ngali abia di, di ta til iʼis, “Ilawaa taamat ia bula ina di.” ");
INSERT INTO ncf_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pita a sebula paare, biaa totore a xap so. A xap sauna mu biaa di, di ta tiltil sangan Pita, di paare, “A suk so, iu iexa ina di, amuina iu in Galili.” ");
INSERT INTO ncf_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Atiltsoli ngali lii no xoror tsaxa papan ia tsaa, ga waawaa lima sin di, “Iaa xap atii aila taamat gim ta papaare taman.” ");
INSERT INTO ncf_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Sauna mu iwaa puraa asuk teng nanaalua. Mil Pita ga adodomi xan no totore Iesu tii paare ngali ia, “Setauan sin puraa naba ta xap mager teng nanaalua iu ba paare a tuul we, u xap atii iaa.” Ma ga suk saaen xaraxin lolbiir ma ga teng. ");
INSERT INTO ncf_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Lawaareng bingbing tsaa, no lalaamua ina no unsausawit, mii no xusaak, no unaasasing ina lo, ma no kaunsel araraa, di se tsap taman adodo ta xuuk. Di pitsi Iesu ma di ga laamuangen ia laa ngali tali sin Pailat. ");
INSERT INTO ncf_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailat atsuraa Iesu, “Iu xadi king no Jiu?” Iesu a xisi, “Iou, Malen u ta se paare.” ");
INSERT INTO ncf_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","No lalaamua ina no unsausawit di atuti ia taman no daan maarang. ");
INSERT INTO ncf_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ma Pailat a sebula atsuraa ia. “Ngalisa u ta xap xisi di? Lasi aisa abala no maarang, di ta atuti iu taman.” ");
INSERT INTO ncf_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Oro Iesu tii ga xap xisi tsaa ma Pailat ga suk olol buxa. ");
INSERT INTO ncf_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Sin xan namaang Pailat talaawaa sin Luxaal ina Esliwaa, naba aleiwaai xa xaus iwaa no inaman di ta axilangi. ");
INSERT INTO ncf_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Iexa taamat, iesan Baraabas tii manman lalon anua lodo mii biexaal biaa di tii esas mii Rom gawaman ma di ga sas amantei biexaal. ");
INSERT INTO ncf_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Biaa malep di xaalame sangan Pailat ngali atsuraa ia ngali xosaraa xan sen namaang ngali aleiwaai xa xaus. ");
INSERT INTO ncf_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pailat atsuraa di, “Gim saan ngali iaa ba aleiwaa xadi king no Jiu laa sin gim?” ");
INSERT INTO ncf_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat a se atixi biaa no lalaamua ina no unsausawit di se tali Iesu laa sin ia amuina di pengsen Iesu. ");
INSERT INTO ncf_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Oro no lalaamua ina no unsausawit di anaai abia malep ngali atsuraa Pailat ngali naba aleiwaa Baraabas ma na xap Iesu. ");
INSERT INTO ncf_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailat atsuraa di, “Iaa ba xosaraa sa sin ilawaa taamat gim ta putsangi king ina no Jiu?” ");
INSERT INTO ncf_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Di xuup lot, “Ataxiwaa papan tongol!” ");
INSERT INTO ncf_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailat atsuraa, “Ngalisa? Sen lo tii se laxei?” Oro di ga xuup lot buxa, “Ataxiwaa papan tongol!” ");
INSERT INTO ncf_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pailat a saan ngali na atatoni abia malep, ma ga aleiwaa Baraabas laa sin di. Ma ga asaaiti no unmakmaxil ngali ririiti Iesu ma ga tali ia laa sin no unmakmaxil ngali di ba ataxiwaa papan tongol. ");
INSERT INTO ncf_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Xan no unmakmaxil di laamuangen Iesu laa lalon xan xaraxin anua gawana di putsangi Pretoriam ma di ga ilei axumuli abia no unmakmaxil araraa. ");
INSERT INTO ncf_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Di aturungi uga disdis ta de papan ia. Mil di ga ili todomien no suen xoxon ngali xosaraa bungwal ma di ga tsoben papan ia. ");
INSERT INTO ncf_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ma di se atiltsoli xuup laa sin, “Ilase, iwaa xadi King no Jiu.” ");
INSERT INTO ncf_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","No unmakmaxil di ulaulatsi ia papan xuan taman paas ma di ga xamutsaa ia. Di soloki ma sage putput ma langaari laa sin ia. ");
INSERT INTO ncf_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Di se reret ngen ia ma di saali abia laplap disdis ta de ma di ga arusarusai ia taman xan no laplap tsaa. Mil di ga gii atsuulngi ngali laa ataxiwaa papan tongol. ");
INSERT INTO ncf_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Iexa taamat in Sairin ilaa Saimon xan mom ilaa Aleksenda ma Rupus axaal lauteng ma ga laa lalon inaman laba. No unmakmaxil di atuaai ngali naba atsaxei xan tongol Iesu. ");
INSERT INTO ncf_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Di giwaa laangen Iesu laa sin abia xolot Golgaata (muina Golgaata, Xolot ina Barang). ");
INSERT INTO ncf_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mil di ga tali waain di ta louxaa mii mar, oro tii palo ngali nungi. ");
INSERT INTO ncf_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ma di ga ataxiwaa papan tongol. Di exasen abia xan no uga Di ga uraura ngali xuxuuk ina di naba adi xaka uga. ");
INSERT INTO ncf_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Sin apaasaaet ina matanios lawaareng biaa di tii ataxiwaa ia. ");
INSERT INTO ncf_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Biaa atatal alengi muina di ta atuti ia, ga xoxot weaatalaa: “Xadi King no Jiu.” ");
INSERT INTO ncf_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Di ataxiwaa alua no unpulapula mii ia, iexa sin lima mua ma iexa sin lima xaiaar. ");
INSERT INTO ncf_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Biaa di, di ta esliu sangan, di tii ga reret ngali ia. Di tii ga uraa xadi no xuan ma di tii ga paare, “Iu tii paare we u ba xosor atsoti Xan Anua Moroaa ma u ba sebula axos mulangenai sin no leng ta tuul, ");
INSERT INTO ncf_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","u na tsuul xaal papan tongol ma u na atoaa iu tsaa!” ");
INSERT INTO ncf_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Sin abia uk sal no lalaamua ina no unsausawit ma no unaasasing ina lo di reret taman ia labatina di tsaa. Di paare weaatalaa, “Tii atoaa biexaal, oro a xap pupua ngali atoaa ia tsaa! ");
INSERT INTO ncf_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Papaalii ilawaa Karisito, ilawaa King in Israel, na tsuul papan tongol talaawaa, ngalibi gita ba lasi ma taltaalnge sin.” Biaa delulu ta taxiu mii ia, delulu bula, delu reret ngali ia. ");
INSERT INTO ncf_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Sin talu piaak lasiaat, xobel araraa tii suk lodo laa pupua sin a tuul ina matanios nale. ");
INSERT INTO ncf_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nale se sin a tuul ina matanios Iesu a xuup lot weaatalaa, “Eloi, Eloi, lama sabakatani?” Muina a weaatalaa, “Nugu Moroaa, Nugu Moroaa, ngali sa u ta se papaalii iaa?” ");
INSERT INTO ncf_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Biaa biexaal ina di, di tii tiltil atat di alongmen abala, di ga paare, “Gim longmien, a ililei Elaija.” ");
INSERT INTO ncf_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Iexa taamat a sol laa ga utii ututes taman waain manuul, ga aturung tali sin paas, ma ga tali sin Iesu ngali nun. Gim papaalii ia xasinge, a paare, “Gita ba lasi nawe Elaija naba xaalame, ngali atsuulngi ia lapula.” ");
INSERT INTO ncf_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Iesu a xuup lot, ga taii xan xapkap ina mamaisa. ");
INSERT INTO ncf_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Biaa xaraxin taago ina Xan Anua Moroaa tii tater sin no papel ta lua xaal lapalaa ma laa pupua lapula. ");
INSERT INTO ncf_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ma biaa Lalaamua ina no unmakmaxil iwaa ta tiltil laamuaan Iesu, ga alongmen xan tineng ma ga lasi tii sen met we, ga paare, “Asuk so maase, ilawaa taamat tii xan Tsi so Moroaa!” ");
INSERT INTO ncf_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Biexaal ina no aina di tii til nanen palpalaa tsaa. Labatina di, ilaa Maria Magdalin, ma Maria xan nagaa Jeims iwaa xulaau ma Josis ma Salomi. ");
INSERT INTO ncf_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tia Galili, balawaa no aina di tii amusili ma tilaamamil sin xan no muun. No daan aina di tii xaalame Jerusalem mii ia, di tii manman tia bula. ");
INSERT INTO ncf_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Sin leng taxaaturung (biaa leng laamuaan Saabat). Biaa ta se nale bingbing, ");
INSERT INTO ncf_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Josep in Arimatia, ia ina abia kaunsel, iwaa tii liliis tsaa ngali xan Maradaan Moroaa, tii xap mataa ngali laa lasi Pailat ma ga laa atsuraa ia ngali xan pakpak Iesu. ");
INSERT INTO ncf_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat asuk tunga ta alongmen we, Iesu tii se met tsaa. A ilei awatwati iwaa lalaamua ina no unmakmaxil ma ga atsuraa ia nawe Iesu a se met. ");
INSERT INTO ncf_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Biaa tii se asasing sin ia, we a so, tii suk tali abia pakpak sin Josep. ");
INSERT INTO ncf_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josep tii uuli no laplap ma ga alet atsuulngi xan pakpak ga ngaati taman laplap, ma ga aturung lalon io, di ta xaii lalon xaat. O ga puxen xaraxin xaat laangen ngali banti matenmat. ");
INSERT INTO ncf_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magdalin ma Maria xan nagaa Josis, delu tii lasi itaa tii atetei ia. ");
INSERT INTO ncf_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mulina Saabat a se liu, Maria Magdalin ma Maria xan nagaa Jeims ma Salomi, detuu uuli no pilogo ta tso mamainaang ngali laa patsaa no isuaan Iesu. ");
INSERT INTO ncf_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Lawaareng bingbing tsaa setauan sin pal ta xap mager tapaas, sin nanaaxuuk leng ina wik, tuu aina detuu es laa sangan lia pupuna. ");
INSERT INTO ncf_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Detuu ga etsura ngen detatuul, “Saa naba puxenlii xaat sin matenmat ina lia pupuna?” ");
INSERT INTO ncf_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Oro biaa detuu ta nanen laa lapalaa, detuu se lasi abia xaraxin xaat, xa tii se puxenlii. ");
INSERT INTO ncf_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Biaa detuu ta tsiga lalon lia pupuna, detuu suk lasi taamat xulaau alen uga disdis ta iaas. A tsotso sin papel lima mua ma detuu ga suk mataa. ");
INSERT INTO ncf_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Taamat asaaiti detatuul, “Gutuu nangaam mataa. Iaa atixi gutuu nanen ngali Iesu in Nasaret, iwaa di ta ataxiwaa. A se tapaas mula. A se xap manman atala. Gim lasi, balawaa xolot di tii atetei ia lalon. ");
INSERT INTO ncf_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Gutuu laa asaaiti xan no tsi asasing ma Pita, ‘A se laamuangen gim laa Galili. Gim ba lasi ia tia malen tii se asaaiti gim.’ ” ");
INSERT INTO ncf_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Detuu didiir ma adodo xudu, detuu tsuul ma sol papaalii lia pupuna. Detuu xap asaaiti xa, amuina detuu suk mataa. ");
INSERT INTO ncf_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Biaa Iesu tii tapaas mula sin minet lawaareng bingbing sin nanaaxuuk ina leng ina wik. Asemat setauan sin Maria Magdalin, iwaa aina tii setauan saali no salawa tsaxa ta paasaalua sin. ");
INSERT INTO ncf_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tii laa asaaiti abia di, di tii manman mii ia, ma di tii se tso sin lolbiir ma tengteng. ");
INSERT INTO ncf_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Biaa di tii alongmen we Iesu tii se tino, ma tii ga se lasi ia, di tii ga xap taltaalnge sin. ");
INSERT INTO ncf_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mil sin abia Iesu ga asemat sin biexa nanen xaatsap sin lo taamat biaa delu ta papaalii Jerusalem ma eses laa Emaus. ");
INSERT INTO ncf_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Delu es mula ma delu ga paatina sin di araraa taman sen maarang ta tsap, oro di tii xap taltaalnge sin delulu bula. ");
INSERT INTO ncf_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mil Iesu asemat sin sangaul axuuk ma ga xuuk ina no tsi asasing biaa di ta lo angangen. A imii di sin xadi muun taltaalnge ma xadi no butsa a taban ngali taltaalnge sin abia di ta se lasi ia mulina sin xan tinapaas mula. ");
INSERT INTO ncf_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","A paare ngali di, “Gim na laa lalon xolkolmoxo araraa ma baais taman inesaait mamainaang laa sin no sin no axoxos araraa. ");
INSERT INTO ncf_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Saa ia ta taltaalnge ma ga adi axaxadaan, naba tuo, oro saa ia ta xap taltaalnge Moroaa naba atuti ia. ");
INSERT INTO ncf_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ma balawaa no axixila naba amusili no untaltaalnge. Di ba saali no salawa tsaxa sin iesaaga ma di ba paare taman no xalam uul. ");
INSERT INTO ncf_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Di ba taxaane no tsitsi taman no liman di, ma biaa di ta nunngi no muu, naba xap amantei di araraa, di ba aturungi no liman di papan no minet ma di ba tuo.” ");
INSERT INTO ncf_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Mulina Orong Iesu tii se papaare sin di, Moroaa tii ga alet laangen ia laa lapalaa balalangit, ma ga tsotso sin xan lima mua Moroaa. ");
INSERT INTO ncf_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Mil no tsi asasing di laa ma di ga baais sin no xolot araraa, ma Orong ga taxaa mii di ma ga asoi abia xan totore mii no axixila ta lo amumusili di. ");
INSERT INTO ncf_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Balawaa inaatel a laa sin iu, taamat orong Tiopilis. Xuduxudu ina biexaal di se xonon ngali atalaa no sen maarang tii taxaa puaa labatina giem. ");
INSERT INTO ncf_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Di tii tali xadi totore abia no inaman di tii setauan lasi no maarang taman no matan di, di no untinaxaa ina totore. ");
INSERT INTO ncf_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Biaabi iaa tsaa bula, iaa se tirei usili abala no maarang araraa tii tiltsoli xaal ti, ma axaau bula ngali iaa ba atal axaautsi laa sin iu abala no maarang tii tsap. ");
INSERT INTO ncf_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Iaa xosaraa abala ngali u ba atii soina abala no maarang di tii se asingan iu taman. ");
INSERT INTO ncf_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Sin xan no leng King Erot in Judaia, iexa unsausawit iesan Sekaraia ina xan matenbung Abaija, no unsausawit. Xan tubu Elisabet bula ia ina xan matenbung Aron. ");
INSERT INTO ncf_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Delu suk tutiik lalon no matan Moroaa sin amumusili xan no lo Orong araraa ma a xap xa namaang tsaxa sin delulu. ");
INSERT INTO ncf_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Oro was mu, a xap xadelu xaa tsi, amuina Elisabet a xap alalet tsi a le pupua sin delu ta se maas ma xuaala. ");
INSERT INTO ncf_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Biaa leng Sekaraia mii no uk untinaxaa di ta taktaxaa o ia ga taxaa malen unsausawit laamuaan Moroaa. ");
INSERT INTO ncf_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","No unsausawit, di tii axilangi Sekaraia sin namaang ina uraura, ngali tsiga lalon Xan Anua Moroaa ngali axaii no pilogo ta tso mamainaang. ");
INSERT INTO ncf_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sin abia leng ngali axaii no pilogo, no unlanglangaari di tsap exumule lokobel ina Xan Anua Moroaa ma di ga lo sausawit. ");
INSERT INTO ncf_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Xan angelo Orong, ga asemat sin papel lima mua ina ibe tsutsungit taman no pilogo, biaa ta tso mamainaang. ");
INSERT INTO ncf_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Biaa Sekaraia ta lasi angelo, asuk olol ma ga mataa. ");
INSERT INTO ncf_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","O angelo ga paare ngali, “Nangaam mataa Sekaraia, num sausawit, Moroaa a se longmien. Num xuaala Elisabet naba taana xa tsi taamat ma u ba a tsoxo iesani taman Jon. ");
INSERT INTO ncf_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","U ba suk us taman tataton amuina sin ia. Xuduxudu ina inaman di ba suk papaalam buxa sin xan tsinap, ");
INSERT INTO ncf_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","amuina naba us taman Nantanua Pat biaa ta manman tsaa lalon balan xan nagaa ma naba taamat lot lalon no matan Orong ma naba xap nun waain o no mat laxen daan tangtangabaa, ma xan tino naba us taman Nantanua Pat setauan tsaa sin di ta xap mager taxaana. ");
INSERT INTO ncf_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Naba gii mulangenai xuduxudu ina inaman in Israel, xaalame sangan Orong, xadi Moroaa. ");
INSERT INTO ncf_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ma naba laamuaan Orong, lalon nantanua ma lalon xan xoror Elaija. Ngali putsi xadi no butsa no mom ngali di ba adodo ngali xadi no tsi ma no xolout ngali adi xadi sinaae no untutiik, ma ngali taxaaturungi inaman ngali xan tsinap Orong.” ");
INSERT INTO ncf_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sekaraia atsuraa angelo, “Naba sen tsap we abala maarang? Iaa se maas ma nugu tubu bula a se xuaala.” ");
INSERT INTO ncf_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Angelo a xisi, “Iaa Gebriel, iaa tiltil lalon no matan Moroaa, ga tulen iaa ngali le asaaiti iu taman balawaa inesaait mamainaang. ");
INSERT INTO ncf_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Lasi! U ba ngusbong pupua sin leng balawaa maarang naba ta tsap amuina u xap taltaalnge sin nugu no totore. Balawaa maarang naba tsap, sin leng Moroaa tsaa ta se xubatsi.” ");
INSERT INTO ncf_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","No inaman di se maara liliis ma di ga adodo xuduxudu amuina Sekaraia a se laa paate buxa tala nan Xan Anua Moroaa. ");
INSERT INTO ncf_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sekaraia a es tsuul o ga xap pupua ngali papaare. Di ga se atixi malen a lasi xa binalang nanen lalon Xan Anua Moroaa amuina ta xosaraa mu no axixila laa sin di ma ga xap papaare. ");
INSERT INTO ncf_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Mulina xan tinaxaa Sekaraia a se xap, o ga se mula laa lokobel. ");
INSERT INTO ncf_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mulina abia, xan xuaala, Elisabet, ga se tiaan ma ga manman mu naanua no uleng alima. ");
INSERT INTO ncf_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elisabet ga paare, “Orong tii xosaraa abala maarang ngali iaa sin abala no leng, ga saali nugu minangel sin sa, no inaman di tii we, iaa xap alalet tsi.” ");
INSERT INTO ncf_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Xan no uleng Elisabet a se paasxuk o Moroaa ga tulen angelo Gebriel laa Nasaret, lalon xariin xolot Galili. ");
INSERT INTO ncf_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","A laa tsap sangan iexa aina uul ta xap mager matul mii xa taamat, iesan Maria. Di tii axanei ia ngali maxis sin iexa taamat iesan Josep ina xan matenbung Dewit. ");
INSERT INTO ncf_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Angelo a laa, ga paare, “Lasiaat axaau Maria, Orong a saansili buxaai iu ma ga tilaamamil buxa susum.” ");
INSERT INTO ncf_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria asuk adodo xuduxudu sin abia no totore angelo ta asaait taman ga paare, “Ngalisa so ta le tali abala no inesaait weaatalaa.” ");
INSERT INTO ncf_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Angelo a paare sin Maria, “Nangaam mataa, Maria, Moroaa ataton sin iu. ");
INSERT INTO ncf_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ma lasi, u ba tiaan ma u ba taana xa tsi, ma u ba a tsoxo iesani, Iesu. ");
INSERT INTO ncf_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Naba ies lot buxa ma di ba putsangi, Xan Tsi Moroaa ta suk lapalaa buxa. Orong Moroaa naba tali xan muina xalkale Dewit sin, ");
INSERT INTO ncf_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ma naba til laamuangen xan no inaman Jakop laaliu. Xan Maradaan naba xap xa xapkap ina.” ");
INSERT INTO ncf_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria atsuraa angelo, “Naba tsap sen parawe abala, amuina iaa xap mager matul mii xa taamat?” ");
INSERT INTO ncf_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angelo ga xisi, “Nantanua Pat naba tsuul xaalame papan iu, ma xan xoror Moroaa. Iwaa lapalaa suk se naba le ngaati iu. Iwaa tsi u ba ta taxaali naba tsap Tsi Pat ma di ba putsangi Xan Tsi Moroaa. ");
INSERT INTO ncf_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ma Lasi, num mixap, Elisabet, a se xuaala o talaawaa a se tiaan. No inaman di tii we naba xap alalet tsi o talaawaa a se paasxuk xan no uleng taman bal tsi. ");
INSERT INTO ncf_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Amuina a xap xawas we Moroaa a xap pupua ngali xosaraa!” ");
INSERT INTO ncf_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria a xisi, “Iaa xan untutule Orong. Axaau biaa maarang u ta paatina na tsap susugu!” Mil Angelo ga se papaalii Maria. ");
INSERT INTO ncf_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Sin abia xolot ina leng Maria ataxaaturung ma ga isagaa laa lapalaa lalon biexa inaman laba papan no buk Judaia. ");
INSERT INTO ncf_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","A es tsiga lalon xan anua Sekaraia ma ga paare sin Elisabet, “Lasiaat axaau.” ");
INSERT INTO ncf_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Biaa Elisabet ta alongmen Maria ta, “Lasiaat axaau ngali ia,” iwaa tsi lalon balan asuk giis. Ma Nantanua Pat asuk tsigaii xan tino Elisabet. ");
INSERT INTO ncf_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elisabet asuk paare lot weaatala, “Moroaa a se atubudaani iu buxa labatina no aina ma a se atubudaani bula iwaa tsi u ba ta taxaane. ");
INSERT INTO ncf_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","O ngalisa iu tii saansili iaa, biaa ngali xan nagaa nugu Orong naba xaalame sangan iaa? ");
INSERT INTO ncf_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Biaa iaa ta alongmen inaam ilawaa tsi nan balaaga asuk giis taman taton. ");
INSERT INTO ncf_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Atubudaani iwaa xa ta taltaalnge ngali abia maarang Orong ta we naba tsap sin.” ");
INSERT INTO ncf_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria a paare we, “Nantanuaaga aminaalami Orong. ");
INSERT INTO ncf_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nantanuaaga a paalam sin Moroaa nugu untino, ");
INSERT INTO ncf_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","amuina adodo buxa, ngali aina untutule gomsaa mu. Talaawaa no utmilmil araraa di ba putsangi iaa tubudaan. ");
INSERT INTO ncf_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ngali iwaa Belaba a xosaraa abala maarang lot ngali iaa– Iesan a pat. ");
INSERT INTO ncf_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Xan biirbirum naba suk laa sin abia di, di ta mataatina ma manglen ia. Xan titii bula naba laa sin xadi no tsi ma naba laa bula sin xadi no utmilmil. ");
INSERT INTO ncf_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","A se atsapngen no xariin maarang taman no liman. A se saali no namaang ina paraak lalon no balan di ma di ga laa lalon xadi no adodo. ");
INSERT INTO ncf_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Moroaa atsiklii no lalaamua lot sin xadi no Maradaan, Oro alet alabati abia di, di ta mangmagus. ");
INSERT INTO ncf_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Atabali abia di, di ta itol, taman no maarang axaau, Oro a tulen lii no inaman untang gomsaa. ");
INSERT INTO ncf_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Moroaa a se tiltsomi xan no untutule in Israel, ngali adodomi xan biirbirum, ");
INSERT INTO ncf_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Sin Abaram, ma xan no utmilmil laaliu, malen sen maarang ta asaaiti xida no mom taman.” ");
INSERT INTO ncf_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria a manman mii Elisabet pupua no uleng a tuul o mil ga mula laa tatan. ");
INSERT INTO ncf_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Leng se ngali Elisabet naba se taxaana xan madalak o ga taana tsi taamat. ");
INSERT INTO ncf_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","No matenaanua atataaen mii xan no mixap, di lasi xan xariin biirbirum Orong sin ma di ga suk taton mii ia. ");
INSERT INTO ncf_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ilawaa tsi dokdok xan no leng a se paasaatuul o di ga le axasaui. Di wena a tsoxo iesani taman Sekaraia amuina iesan xan mom. ");
INSERT INTO ncf_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Oro xan nagaa ga paare, “A xap! Gita ba putsangi iesan ilaa Jon.” ");
INSERT INTO ncf_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Di ga paare ngali ia, “A xap xa labatina num matenbung iesan na malen abia ies.” ");
INSERT INTO ncf_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Di laa ma xosaraa no axixila laa sin xan mom, ngali saa iesan xan tsi. ");
INSERT INTO ncf_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","O ga atsura ngali xawas ngali atatal papan, ga atatal weaatala, “Iesan ilaa Jon.” Biaa di araraa, di ga suk olol. ");
INSERT INTO ncf_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tiwaa tsaa ngutsina asuk tsalel ma ga sebula papaare o ga suk paʼii Moroaa. ");
INSERT INTO ncf_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","No matenaanua atataaen, di lasi abala no maarang ta tsap, di ga mataa ma inesaait ina ga suk sol isagaa laa lalon no xobel lapalaa papan no buk Judaia. ");
INSERT INTO ncf_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Biaa di ta alongmen abala, di suk adodo xuduxudu lalon xadi no butsa ma di ga atsura weaatala, “Ilawaa tsi naba tsap sen mat laxen taamat mil?” Amuina di lasi liman Orong ta manman mii ia. ");
INSERT INTO ncf_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nantanua Pat atsigaii xan mom Jon, ilaa Sekaraia, ma tii ga tali xan totore propet: ");
INSERT INTO ncf_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Na ga paʼii Orong, iwaa xida Moroaa no Israel amuina a se xaalame ngali tiltsomi gita ma gii mulangenai xan no inaman. ");
INSERT INTO ncf_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Moroaa a se tali xariin taamat watwat sin gita, iwaa naba ta tsap xida untino, ia ina xan matenbung Dewit, iwaa xan untutule Moroaa. ");
INSERT INTO ncf_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Xan no propet pat Moroaa di tii se asaait taman abala no maarang setauan tsaa ");
INSERT INTO ncf_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Moroaa naba tali ilawaa taamat watwat ngali aleiwaa gita sin xida no matenkorot, ma sin xadi watwat abia di, di ta ngutsulen gita. ");
INSERT INTO ncf_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Moroaa tii se asen xan biirbirum laa sin xida no iaaiaa ma ga adodomi ta xubatsi xan totore pat. ");
INSERT INTO ncf_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Moroaa ga puris ngali xida mom Abaram: ");
INSERT INTO ncf_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ngali gii tsaxali gita sin xadi watwat xida no matenkorot, ma ngali gita ba pupua ngali taxaa ngali ia ma gita na xap mataa, ");
INSERT INTO ncf_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Gita na tsap tutiik ma pat lalon no matan Moroaa sin xida no leng se araraa. ");
INSERT INTO ncf_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ma iu, nugu tsi, mil di ba putsangi iu xan propet Moroaa Iwaa in Lapalaa suk se. Ngali u ba laamua setauan, ngali taxaaturungi sal ngali xan tsinap Orong. ");
INSERT INTO ncf_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ngali u ba taal sinaae sin xan no inaman biaa sinaae ina aleiwaai no inaman, ngali adodolii xadi no mat namaang tsaxa. ");
INSERT INTO ncf_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Amuina ngali xan biirbirum xida Moroaa, biaa pal ta xaalame lapalaa atsilangi gita, axaal balalangit ");
INSERT INTO ncf_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ma naa tsila papan biaa di, di ta manman lalon lodo, ma sin abia di bula sin maliip ina minet. Ngali asen sal sin no xaden gita lalon sal ina malina.” ");
INSERT INTO ncf_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ma iwaa tsi a se lot ma ga watwat sin nantanuaan. A manman nan xobel biil, til sin leng ta asemat nan no matan no inaman Israel. ");
INSERT INTO ncf_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Sin abia no leng Jon tii dokdok tsaa, Sisa Agustus, iwaa xariin lalaamua ina gawaman Rom, tii tali totore watwat sin no inaman lalon xolkolmoxo araraa in Rom, ngali di na laa taal ies. ");
INSERT INTO ncf_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Balawaa tii lalaamua ngali taal ies (balawaa maarang tii tsap in no leng Kurinias tii lalaamua in Siria). ");
INSERT INTO ncf_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Biaabi no inaman di na laa lalon xadi no xobel so ngali taal ies. ");
INSERT INTO ncf_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep bula a xaal Nasaret, nan xolot Galili ngali laa lapalaa Betliem lalon xolot Judaia, xan xobel so Dewit amuina ia ina xan matenbung Dewit. ");
INSERT INTO ncf_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","A laa atia ngali taal ies mii Maria amuina di se xanei delulu ngali maxis, o Maria, nap dokdok naba se taxaa tsi. ");
INSERT INTO ncf_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Sin xadi manman atia, leng a se tsap ngali Maria naba alet tsi ");
INSERT INTO ncf_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ma ga se taana tuaa ina tsi, ga ngaati taman no alale ma ga atetei lalon niaan tsaamtsaam sin no sipsip, amuina tii xap xadetu xa xabin lalon abia anuen xibong. ");
INSERT INTO ncf_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","No untilaamamil ina no sipsip, di tii tilaamamil sin xadi no sipsip nabing, sin no xolot palis nan waa, ");
INSERT INTO ncf_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ma xan angelo Orong ga tsap sangan di. Ma xan minaalam Orong ga tsila ulti di ma di ga suk mataa. ");
INSERT INTO ncf_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Angelo ga asaaiti di, “Gim nangaam mataa! Iaa tsap ngali tali inesaait mamainaang sin gim ngali no inaman se araraa di ba suk taton. ");
INSERT INTO ncf_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Talaawaa, nan xan xobel Dewit, di se taana aia untino, iwaa Karisito Orong. ");
INSERT INTO ncf_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Balawaa axixila ngali asen sin gim: gim ba tatanginai madalak, di ta ngaati taman no alale ma di ga atetei lalon niaan tsaamtsaam ina no sipsip.” ");
INSERT INTO ncf_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","O tiwaa tsaa xariin xumul ina angelo in balalangit, di ga suk tsap mii aia angelo ma di ga paʼii Moroaa, weaatalaa: ");
INSERT INTO ncf_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Minaalam sin Moroaa a laa Lapalaa suk se. Ma nan balan pula, malina na manman sin no inaman biaa Orong ta taton sin di.” ");
INSERT INTO ncf_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","No angelo di se mula laa nan balalangit, o no untilaamamil ina no sipsip di ga epaare sin di, “Na ga laa Betliem ngali laa lasi abala maarang ta tsap, Orong ta se asaaiti gita taman.” ");
INSERT INTO ncf_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Di tapaas isagaa, di ga laa tatanginai Maria ma Josep mii iwaa madalak, ta matmatuul lalon niaan tsaamtsaam ina no sipsip. ");
INSERT INTO ncf_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Biaa di ta se lasi, di suk asaait taman abia inesaait di ta se longmien ina aia tsi dokdok. ");
INSERT INTO ncf_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","O biaa no inaman di ta alongmen abala, di suk olol buxa sin abia inesaait no untilaamamil ina sipsip di ta asaait taman. ");
INSERT INTO ncf_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Oro Maria ga suk adodo ariiti abala no maarang. Ma ga manman no nan xan butsa. ");
INSERT INTO ncf_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Biaa di ta mula, no untilaamamil ina no sipsip di suk aminaalami ma paʼii Moroaa ma di ga alet laangen iesan laa lapalaa, amuina di se longmien ma lasi abia no maarang, malen angelo ta se asaait taman. ");
INSERT INTO ncf_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Sin apaasaatuul ina leng, di axasaui tsi malen xadi namaang ma di ga se a tsoxo iesani Iesu, biaa ies angelo tii setauan tali sin xan nagaa ta xap mager maet. ");
INSERT INTO ncf_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Biaa no leng ngali amixati delulu amusili xan lo Moses tii se araraai, Josep ma Maria delu giwaa Iesu laa Jerusalem ngali di ba tali ia sin Orong. ");
INSERT INTO ncf_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(Biaa atatal a manman sin xan Lo Orong, “Malen iwaa tuaa ina tsi, di ba patu tali ia laa sin Orong.”) ");
INSERT INTO ncf_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ngali tsutsungit tali xa tinabel amusili xan Lo Orong, “taman no buna alua o nawe no baalis uul alua.” ");
INSERT INTO ncf_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Sin abia no leng, ia xa taamat iesan ilaa Simeon in Jerusalem. Ia untutiik ma untinaalnge. Tii ga liliis ngali untino naba le anaai Israel. Nantanua Pat tii manman mii. ");
INSERT INTO ncf_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nantanua Pat tii ga asen sin ia malen naba setauan lasi Karisito iwaa Orong tii se axilangi o mil maaba na met. ");
INSERT INTO ncf_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nantanua Pat a laamuangen Simeon ngali tsiga lalon xolot ina Xan Anua Moroaa. Biaa ta se manman atia, lomasen xan maxis, delu xaalame taman tsi Iesu, ngali xosor amusili xadi namaang ina Lo. ");
INSERT INTO ncf_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon alogo tsaxali ia ma ga paʼii Moroaa ga we, ");
INSERT INTO ncf_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Belaba Orong, malen num xuxubu tsaa, talaawaa num untutule naba iaawis laaliu lalon malina, ");
INSERT INTO ncf_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Amuina no mataaga tsaa a se lasi num atotoaa, ");
INSERT INTO ncf_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Iwaa u ta se axilangi ma no inaman se araraa di se lasi. ");
INSERT INTO ncf_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Num xariin rarar atsap ngali asen sin no inaman Gentail, Ma ngali abia minaalam laa sin no inaman Israel.” ");
INSERT INTO ncf_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Josep ma Maria delu olol sin abia no totore ta paatina ngali ia. ");
INSERT INTO ncf_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon atubudaani delulu ma ga asaaiti Maria, xan nagaa madalak, “Ilawaa tsi naba axolngi no daan inaman in Israel ma naba luxu atapaasi bula biexaal. Ia naba tsap axixila biaa no inaman di ba ta paare epuske mii. ");
INSERT INTO ncf_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ngalibi xadi no adodo nan xadi no butsa naba asemat no. O iu, u ba adi xariin mamaet malen pubat ta tsoxaa nantanuaam bula.” ");
INSERT INTO ncf_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Iexa propet aina ilaa Ana xan tsaana Panuel ina xan matenbung Asaa. A se xuaala buxa o xan no miet a pupua malen no sangaul apaasaatuul ma ga laa et. A manman mii xan maxis no miet apaasaalua o xan maxis tii se metlii. A xap xaa papaalii Xan Anua Moroaa, ngali tigiri langaari sin no bing ma siaat ngali el ma ningning. ");
INSERT INTO ncf_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","A xaalame sangan Josep ma Maria sin abia leng ma ga suk putsangi axaau laa sin Moroaa. O ga paare taman aia tsi laa sin abia no inaman, di ta lo nanen liliisi Moroaa ngali gii mulangena Jerusalem. ");
INSERT INTO ncf_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mil Josep ma Maria delu se taxaawiti no maarang ngali amusili xan lo Orong. Di ga se mula laa Galili ngali laa tutiik sin xadetu xobel Nasaret. ");
INSERT INTO ncf_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Iesu tii se lot ma ga se tsi watwat, ga us taman sinaae ina nantanua ma ga us taman xan amiimiilam Moroaa. ");
INSERT INTO ncf_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Sin no miet araraa, xan mom ma xan nagaa Iesu, delu xaa laa Jerusalem sin luxaal ina Esliwaa. ");
INSERT INTO ncf_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tii se sangaul ma ga laa lua xan no miet o detuu ga laa sin abia luxaal amusili xadi namaang no Jiu. ");
INSERT INTO ncf_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mulina luxaal, xan mom ma xan nagaa, delu se es mula laa lokobel, delu xap atii we, iwaa tsi Iesu ilei tsaa Jerusalem. ");
INSERT INTO ncf_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Delu we ia mii delulu labatina abia inaman ma delulu ga lo eses sin abia leng xiduul. A se nale, delu ga nanen ngali, labatina xadi no mixap ma no turan di. ");
INSERT INTO ncf_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Delu xap tatanginai, ma delu ga sebula mula laa Jerusalem ngali laa nanen tsalei. ");
INSERT INTO ncf_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","No leng a tuul a se liu, o delu suk tatanginai Iesu lalon xolot ina Xan Anua Moroaa, ta xalkale labatina no unaasasing. A longmien di ma ga atsuraa di taman no atsutsura. ");
INSERT INTO ncf_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","No inaman araraa tia di ta alongmen, di suk olol sin xan sinaae ma xan no xixiis. ");
INSERT INTO ncf_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Xan mom ma xan nagaa delu lasi ma delu ga suk olol buxa. Xan nagaa ga paare ngali, “Nugu tsi, ngali sa u ta xosor wenangen gelulu weaatala? Iaa ma num mom, gelu suk adodo buxa ngali iu ma gelu ga lo tsatsel ngali iu.” ");
INSERT INTO ncf_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Iesu ga xisi delulu, “Gulu tsalei iaa ngali sa? Gulu xap atii we iaa na manman nan xan anua nugu mom?” ");
INSERT INTO ncf_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Oro delu ga xap leng sin sen maarang ta paatina. ");
INSERT INTO ncf_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Mil Iesu ga se laa Nasaret mii xan mom ma xan nagaa, ma ga tigiri lolong. Xan nagaa asuk adodo ariiti abala no maarang nan xan butsa. ");
INSERT INTO ncf_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Iesu a se lot lalon sinaae ma pakpak, ma Moroaa ma no inaman bula di taton buxa sin. ");
INSERT INTO ncf_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sin sangaul ma ga laa lima ina miet ina xan Maradaan Sisa Taiberias, iwaa xariin lalaamua ina gawaman Rom, Pontius Pailat tii tilaamamil sin Judaia, Erot Antipaas tii tilaamamil sin Galili, o xan taamat, ilaa Pilip, tii tilaamamil sin Ituria ma Terakonaitas, ma Lisanias tii tilaamamil sin Abilin. ");
INSERT INTO ncf_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anas ma Kaiapas, delu tii no unsausawit lapalaa. Sin abia no leng, xan totore Moroaa a xaalame sin Jon, xan tsi Sekaraia, ta manman lalon abia xobel biil. ");
INSERT INTO ncf_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jon tii laa lalon no daan xolot ina Jodan ma ga baais taman, axaxadaan ngali puxisbal, ma ngali adodolii no namaang tsaxa. ");
INSERT INTO ncf_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Malen Inaatel Pat, Aisaia iwaa propet ta papatina: “Inan xa a ililei lalon xobel biil ga we, ‘Taxaaturungi xan sal Orong, xosaraa xan sal na tutiik! ");
INSERT INTO ncf_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tuali no maxaaba araraa, ma atutiki no buk na laa lapula. No sal xoriik na tutiik ma amadipi no xolot ta bukbuken. ");
INSERT INTO ncf_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ma no inaman araraa, di ba lasi xan watwat Moroaa ta aleiwaai di.’ ” ");
INSERT INTO ncf_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jon ga paare ngali abia malep di ta xaalame ngali adi axaxadaan sin ia, ga paare, “Gim xan no tsi, no tsitsi tsaxa! Saa atewaai gim ngali sol sin xan minagaa Moroaa, biaa naba ta laa xaalame? ");
INSERT INTO ncf_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Gim na waalii xaa waawaan axaau ngali asen we, gim se puxisbal. Ma gim nangaam adodo we, gim pupua ngali paare sin gim tsaa we, Abaram ia nagiem mom. Iaa asaaiti gim, xaal sin abala no xaat Moroaa a pupua ngali atsapngen xakaa tsi Abaram. ");
INSERT INTO ncf_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Xula a se taxaaturung muina no ie. Ma nawe no sen ie araraa di xap waalii xaa waawaan axaau, naba tal lii ma na lii laangen lalon ie.” ");
INSERT INTO ncf_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","No inaman, di atsuraa, “O giem ba xosaraa sa?” ");
INSERT INTO ncf_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jon ga xisi di, “Nawe xa ia xan no uga disdis ta lua, na tali xa sin xa taamat ta xap xaka, o nawe xa a ie luxaal na xosaraa weaatia bula.” ");
INSERT INTO ncf_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","No unaalalet taakis, di xaalame ngali Jon naba axadaani di. Di le atsuraa Jon, “Unaasasing, giem ba xosaraa sa?” ");
INSERT INTO ncf_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Jon a xisi, “Gim nangaam alet buxaai xuxute ngen papan abia gim ta saansili.” ");
INSERT INTO ncf_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mil biexaa unmakmaxil di atsuraa Jon, “Giem ba xosaraa sa?” Jon a xisi di, ga we, “Gim nangaam ningi atuaai xaa xuxute sin no inaman ma nangaam daraxe tali xaa totore sin di ma gim na taton taman nagim no iliil.” ");
INSERT INTO ncf_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","No inaman di tii lo liliis ma di ga adodo lalon xadi no butsa we, manaa Jon, ia mu Karisito. ");
INSERT INTO ncf_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jon ga xisi di se araraa ga we, “Iaa axadaani gim taman daan, Oro iwaa naba ta xaalame mil sin iaa, xan xoror a watwat buxa ngen iaa. Iaa xap muun mamainaang buxa ngali lubati xan no bubut. Ia naba axadaani gim taman Nantanua Pat ma taman ie. ");
INSERT INTO ncf_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Xan pok biaa se lalon no liman, ngali exasenlii no pinpin sin no wit ngali rii axaautsi xolot ina saali no pinpin ina wit, ma axumuli no wit laa lalon anuen atuturung, oro na axaii no pinpin ina wit lalon abia ie ta xap pupua ngali met.” ");
INSERT INTO ncf_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon a tali inanaa watwat sin no inaman ma ga baais taman inesaait mamainaang laa sin di. ");
INSERT INTO ncf_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Oro biaa Jon ta imii King Erot papan no matan sin ta xosaraa no daan mat namaang tsaxa ma ta giwaa bula xan tubu turamasen, ilaa Erodias. ");
INSERT INTO ncf_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","O Erot a sebula xosaraa xariin namaang tsaxa papan abia xan no namaang tsaxa, ga tali Jon nan anua lodo. ");
INSERT INTO ncf_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jon a lo axaxadaani no inaman araraa, o ga axadaani Iesu bula. O biaa Iesu tii ningning, balalangit asuk tsalel, ");
INSERT INTO ncf_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ma Nantanua Pat ga soriri xaalame papan malen buna. O inan xa axaal balalangit, ga we, “Iu nugu tsi, iwaa iaa tii suk titii buxaai ma iaa taton sin iu.” ");
INSERT INTO ncf_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Xan no miet Iesu a se no sangaul a tuul o ga atiltsoli xan inatalil. No inaman di adodo we Iesu ia xan tsi Josep, Josep ia xan tsi Eli, ");
INSERT INTO ncf_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli ia xan tsi Matat, Matat ia xan tsi Liwai, Liwai ia xan tsi Meltsi, Meltsi ia xan tsi Janai, Janai ia xan tsi Josep, ");
INSERT INTO ncf_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep ia xan tsi Matatias, Matatias ia xan tsi Emos, Emos ia xan tsi Naum, Naum ia xan tsi Esli, Esli ia xan tsi Nagai, ");
INSERT INTO ncf_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai ia xan tsi Maat, Maat ia xan tsi Matatias, Matatias ia xan tsi Semein, Semein ia xan tsi Josek, Josek ia xan tsi Joda, ");
INSERT INTO ncf_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda ia xan tsi Joanan, Joanan ia xan tsi Resa, Resa ia xan tsi Serubabel, Serubabel ia xan tsi Salatiel, Salatiel ia xan tsi Neri, ");
INSERT INTO ncf_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ia xan tsi Meltsi, Meltsi ia xan tsi Adi, Adi ia xan tsi Kosam, Kosam ia xan tsi Elamadam, Elamadam ia xan tsi Er, ");
INSERT INTO ncf_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ia xan tsi Josua, Josua ia xan tsi Eliʼesa, Eliʼesa ia xan tsi Jorim, Jorim ia xan tsi Matat, Matat ia xan tsi Liwai, ");
INSERT INTO ncf_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Liwai ia xan tsi Simeon, Simeon ia xan tsi Juda, Juda ia xan tsi Josep, Josep ia xan tsi Jonam, Jonam ia xan tsi Eliakim, ");
INSERT INTO ncf_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim ia xan tsi Melea, Melea ia xan tsi Mena, Mena ia xan tsi Matata, Matata ia xan tsi Naitan, Naitan ia xan tsi Dewit, ");
INSERT INTO ncf_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dewit ia xan tsi Jesi, Jesi ia xan tsi Obet, Obet ia xan tsi Boas, Boas ia xan tsi Salmon, Salmon ia xan tsi Nason, ");
INSERT INTO ncf_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason ia xan tsi Aminadap, Aminadap ia xan tsi Admin, Admin ia xan tsi Aram, Aram ia xan tsi Esron, Esron ia xan tsi Peres, Peres ia xan tsi Juda, ");
INSERT INTO ncf_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda ia xan tsi Jakop, Jakop ia xan tsi Aisak, Aisak ia xan tsi Abaram, Abaram ia xan tsi Tera, Tera ia xan tsi Naor, ");
INSERT INTO ncf_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naor ia xan tsi Seruk, Seruk ia xan tsi Reu, Reu ia xan tsi Pelek, Pelek ia xan tsi Eber, Eber ia xan tsi Sala, ");
INSERT INTO ncf_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala ia xan tsi Kaanan, Kaanan ia xan tsi Apaxad, Apaxad ia xan tsi Siem, Siem ia xan tsi Noa, Noa ia xan tsi Lamek, ");
INSERT INTO ncf_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek ia xan tsi Matusela, Matusela ia xan tsi Enok, Enok ia xan tsi Jared, Jared ia xan tsi Maxalalel, Maxalalel ia xan tsi Kaanan, ");
INSERT INTO ncf_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaanan ia xan tsi Enos, Enos ia xan tsi Set, Set ia xan tsi Adam, Adam ia xan tsi Moroaa. ");
INSERT INTO ncf_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iesu asuk us taman Nantanua Pat biaa ta mula xaal Jodan, ma Nantanua ga giwaa laa lalon xobel biil. ");
INSERT INTO ncf_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","O Saatan ga xonon ia sin no sangaul aet ina no leng. A xap ngani xawas sin abia no leng o mil sin abia no leng ga suk itol. ");
INSERT INTO ncf_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Saatan ga paare ngali, “Nawe iu Xan Tsi Moroaa, u na asaaiti abala no xaat ngali di ba tsap tsoki.” ");
INSERT INTO ncf_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Iesu a xisi, ga we, “Di se atalaa, ‘Taamat a xap tino sin tsoki mu.’ ” ");
INSERT INTO ncf_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","A xap sauna mu, Saatan ga giwaa ia laa papan biexa xolot lapalaa o ga asen no Maradaan araraa ina xolkolmoxo. ");
INSERT INTO ncf_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ma Saatan a asaaiti, “Iaa ba tali no banam susum ma xadi no geramis, amuina di se tali no susugu ma iaa pupua ngali tali sin saa ia, iaa ta saan ngali tali sin. ");
INSERT INTO ncf_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","U ba tapkina abala no, nawe u langaari sin iaa.” ");
INSERT INTO ncf_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Iesu a xisi ga we, “Di atalaa, ‘U na langaari laa sin Orong, iwaa num Moroaa, ma u na lolong amusili mu ia xasinge.’ ” ");
INSERT INTO ncf_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ma Saatan ga giwaa ia laa Jerusalem, ga atilngi tile lapalaa suk se ina Xan Anua Moroaa, ga we, “Nawe iu xan Tsi Moroaa, u na rik laa lapula. ");
INSERT INTO ncf_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Amuina di atalaa, “ ‘Naba paare watwat sin xan no angelo ngali tilaamamil sin iu,’ ” ");
INSERT INTO ncf_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ma ga paare bula we, “ ‘di ba tsiil tsaali iu taman no liman di, ngalibi u ba xap tigen no xaiim sin xa xaat.’ ” ");
INSERT INTO ncf_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Iesu ga xisi ia, “Di atalaa, ‘Nangaam tali Orong num Moroaa sin xonkonon.’ ” ");
INSERT INTO ncf_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Biaa Saatan ta se araraai xan no xonkonon, ga papaalii ia, o ga liliis ngali xa leng axaau ngali sebula xonon Iesu. ");
INSERT INTO ncf_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iesu ga mula laa Galili taman xan watwat Nantanua, o inesaait ina asuk laa sin no xolot araraa ulti inaman laba. ");
INSERT INTO ncf_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Asingan no inaman lalon xadi no anua sausawit ma di araraa, di ga suk paʼii ia. ");
INSERT INTO ncf_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Mil ga laa Nasaret lalon xan xobel so, tii lot lalon. Sin Saabat, a laa lalon anua sausawit malen xan namaang, ma ga til ngali xoxoti Inaatel Pat, ");
INSERT INTO ncf_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Di suk tali xan Inaatel Propet Aisaia sin. Iesu adi, ga tsalali, ga tatanginai xolot lalon, o ga xoxoti weaatalaa: ");
INSERT INTO ncf_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Nantanuaan Orong ila papan iaa, amuina a se patsaa apati iaa ngali baais taman inesaait mamainaang, laa sin no muunwas. A tulen iaa ngali baais weaatala: no inaman lalon anua lodo, di ba leiwaa, ma no matababa di ba sebula nanen, ma no inaman di ta adi xariin mamaet, di ba leiwaa, ");
INSERT INTO ncf_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ma ngali baais taman miet Orong naba ta asen xan tubudaan.” ");
INSERT INTO ncf_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ga ulis mulangenai Inaatel Pat ma ga taal mulangenai laa sin untinaxaa ina Anua Sausawit o ga tsotso, ma no inaman lalon anua sausawit di ga lo nan ariti ia. ");
INSERT INTO ncf_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","O ga sebula asaaiti di, “A se taxaawiti abala Inaatel Pat sin nagim lolong atalaa.” ");
INSERT INTO ncf_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Di suk tinangen ma adodo xuduxudu sin abia no totore mamainaang ta tsuul lalon ngutsina ma di ga we, “Ilawaa mu xan tsi Josep aila, ngaa?” ");
INSERT INTO ncf_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Iesu ga paare ngali di, “Asuk so maase, gim ba paare taman abala totore puapua sin iaa: ‘Pispis toto, u na atoaa iu tsaa! Ma u na xosaraa abala no maarang tala lalon num xobel tsaa, malen giem ta alongmen u ta se xosaraa no Kaperanaam.’ ” ");
INSERT INTO ncf_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ga lo papaare tsaa, “Iaa asaaiti gim taman so, a xap xa propet di ba sirawaa lalon xan xobel so. ");
INSERT INTO ncf_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Iaa suk asaaiti gim taman so, sin xan no leng Elaija, tii suk xudu abia no aina xadi no maxis di ta se metli di in Israel. Sin abia no leng xariin itol tii tsap sin no xobel se araraa amuina tii xap xaa langit no miet a tuul ma xolot. ");
INSERT INTO ncf_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","O Moroaa tii xap tulen Elaija laa sin abia no aina nal in Israel. Oro, a tulen ia laa sangan iexa aina nal in Sarapat lalon xolot Sidon. ");
INSERT INTO ncf_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ma no daan inaman Israel di tii ie minet basbas sin xan no leng propet Elisa, o tii ga xap xa ina di na tuo, oro Neman mu in Siria.” ");
INSERT INTO ncf_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","No inaman lalon anua sausawit, di alongmen abala xan no totore ma di ga suk magaa buxa. ");
INSERT INTO ncf_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Di tapaas ma di ga tatei atsuulngi Iesu lalon abia inaman laba, ma di ga giwaa laa papan buk ngali di ba lii laangen lapula amuina Nasaret a manman papan buk. ");
INSERT INTO ncf_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Oro asuk es tapaas labatina abia xumul mu, ma ga laa lalon xan sal. ");
INSERT INTO ncf_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Mil Iesu ga laa lapula, laa Kaperanaam biexa inaman laba in Galili o sin Saabat ga atiltsoli ngali asingan no inaman. ");
INSERT INTO ncf_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Di suk tunga sin xan no asasing amuina xan no inesaait a ie banam. ");
INSERT INTO ncf_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Lalon anua sausawit, taamat ia salawa tsaxa ta tsigaii a xuup lot weaatalaa, ");
INSERT INTO ncf_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Aii! Iesu in Nasaret! U saan ngali samaarang sin giem? U xaalame ngali le xosor atsoti giem? Iaa atii iu saa. Iu iwaa Xa ta Pat xan Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iesu asuk imii ga we, “U na bong! Tsuul papaalii aia taamat!” Iwaa salawa tsaxa apipidi taman taamat lapula sangan di ma ga suk tsuul alen. Ga xap xosor atsoti aia taamat. ");
INSERT INTO ncf_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","No inaman araraa di tunga ma di ga epaare engen di, “Sen mat asasing abala? A paare taman banam ma watwat ga tulenlii no tanua tsaxa ma di ga tsuul!” ");
INSERT INTO ncf_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Inesaait ina ia asuk sol laa lalon no xolot araraa lalon abia inaman laba. ");
INSERT INTO ncf_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iesu apapaali anua sausawit o ga tsiga lalon xan anua Saimon. Sin abia xolot ina leng xan xoxup Saimon a maramase taman isua lalep buxa ma di ga ningi Iesu ngali tiltsomi ia. ");
INSERT INTO ncf_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ma Iesu ga tudu laa sin aia aina ma ga imii abia isua lalep sin, o minet ga suk papaalii ma tiwaa tsaa aina asuk tapaas ma ga suk tabali di. ");
INSERT INTO ncf_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Biaa matanios ta we na se laa tsurii, no inaman di le tali no inaman di ta ie no mat laxen minet sangan Iesu, o ga aturungi no liman papan di xuxuuk ma ga atoaa di. ");
INSERT INTO ncf_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","No salawa tsaxa bula, di tsuul alen no daan inaman ma di ga xuupkup weaatala, “Iu xan Tsi Moroaa.” O Iesu ga imii di, ma ga xap sirawaa di ngali di na papaare, amuina di atixi ia Karisito. ");
INSERT INTO ncf_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","A se tampanek o Iesu ga laa lalon biexa xobel biil. No inaman di ga lo nanen ngali, o biaa di ta tatanginai, di suk xonon ngali alilii ngali naba xap papaalii di. ");
INSERT INTO ncf_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Oro ga paare, “Moroaa a tulen iaa ngali baais taman Inesaait Mamainaang ina xan Maradaan sin biexaa xobel bula, biaabi iaa tii ga xaalame.” ");
INSERT INTO ncf_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ma Iesu ga lo babaais lalon xadi no anua sausawit lalon prowins Judaia. ");
INSERT INTO ncf_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Sin biexa leng, Iesu atiltil xuen ina daan ulis Genasaret mii no daan inaman. Di ga suk til asuruti Iesu ngali alongmen xan no totore Moroaa. ");
INSERT INTO ncf_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","A nanen laa, ga lasi alua no mono talaa xuen, biaa no untsunulau di ta papaalii no ma di ga laa guraii xadi no uben. ");
INSERT INTO ncf_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ga xaa papan xan mono Saimon ma ga atsuraa ngali na tsulen adokdoki laa lau, ga tsotso papan mono ma ga asingan no inaman. ");
INSERT INTO ncf_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","A se totore xap o ga paare ngali Saimon, “U na alusa taman mono laa lalaman ma gim na aririi no uben ngali saʼii xaa xo.” ");
INSERT INTO ncf_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimon a xisi, ga we, “Manmanel, giem se maara tsulau sin abala bing xiduul o giem ga xap muun saʼii xaa xo, Oro amuina u ta paare, iaa ba amusili ma aririi nugu uben.” ");
INSERT INTO ncf_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Di amusili xan totore Iesu, ma di suk saʼii buxaai no xoo. Biaa uben ga we na se tater. ");
INSERT INTO ncf_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Di ga ilei no uk untinaxaa papan biexa mono ngali le tiltsomi di. Di xaalame, di ga tuali no mono ta lua taman no xoo ma nap dokdok biaa no mono naba se lulus. ");
INSERT INTO ncf_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Biaa Saimon Pita ta lasi abala asuk sage putput sangan no xaden Iesu, ga we, “Til alen iaa, Orong. Iaa taamat tsaxa!” ");
INSERT INTO ncf_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","10","Ia mii abia no uk untinaxaa, ilaa Jeims ma Jon, xan no tsi Sebedi, di suk olol buxa sin no daan xoo di ta saai. O Iesu ga paare sin Saimon, “Nangaam mataa, atiltsoli atalaa ma mil u ba tsap untsunulau ngali gii inaman.” ");
INSERT INTO ncf_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Di taʼi no mono laa lapalaa, di ga papaalii no mat maarang araraa ma di ga amusili ia. ");
INSERT INTO ncf_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Biaa Iesu ta manman lalon biexa inaman laba, o iexa taamat ga xaalame taman minet basbas ta se araraai ia. Biaa ta lasi Iesu, asuk xol tudu lapula ma ga ningi Iesu, “Orong, nawe u siir, u na atoaa iaa.” ");
INSERT INTO ncf_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iesu a tulsen liman, ga taana aia taamat ga we, “Iaa sirawaa iu, ngali u ba tuo!” Tiwaa tsaa minet basbas asuk papaalii ia. ");
INSERT INTO ncf_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Mil Iesu ga asaait awatwati, “Nangaam asaaiti xa, oro u na laa asen iu tsaa sin unsausawit ma u na tali num tinabel malen Moses ta paare watwat taman, malen u se tuo, ngali asen so sin di, num minet a se xap.” ");
INSERT INTO ncf_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Inesaait ina Iesu asuk sol isagaa buxa, ma xuduxudu ina no inaman di ga xaalame ngali lolong ma ngali Iesu naba atoaa xadi no minet. ");
INSERT INTO ncf_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Oro, Iesu a xaa papaalii di ngali laa sausawit lalon no xobel biil xasinge. ");
INSERT INTO ncf_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sin biexa leng Iesu a lo taal asasing o no Paarasi ma no unaasasing ina lo sin no xobel araraa Galili, Judaia ma Jerusalem di tii xalkale tia. Xan xoror watwat Orong a manman sin ia, ngali atoaa no minet. ");
INSERT INTO ncf_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Gim lasi, biexaa taamat di ta atsaxei xaalame ngen iexa taamat papan xabangas no isuaan ta met. Di ga xonon ngali giwaa laa naanua ngali atetei laamuaan Iesu, o ga xap xa sal ngali tsiga, ");
INSERT INTO ncf_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Biaa di ta xap pupua ngali tsalei xa sal, amuina sin abia malep, di en papan unga ina anua ma di ga tseng alen unga ina anua, di ga aririi aia taamat papan xabangas labatina abia malep laamuangen Iesu. ");
INSERT INTO ncf_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Biaa Iesu ta lasi xadi tinaalnge, a laa ga we, “Turaaga, iaa se adodolii num no namaang tsaxa.” ");
INSERT INTO ncf_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","No Paarasi ma no unaasasing ina lo, di lo adodo lalon xadi no butsa tsaa, “Saa taamat aila ta reret? Xa a xap pupua ngali adodolii no namaang tsaxa, oro Moroaa mu a pupua.” ");
INSERT INTO ncf_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iesu atixi xadi no adodo ga atsura, “Ngalisa gim ta adodo amusili abala no maarang lalon nagim no butsa? ");
INSERT INTO ncf_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Sen maarang asuk malus ngali paatina, ‘Num no namaang tsaxa iaa se adodolii’ o ngali we, ‘Tapaas ma u na eses?’ ");
INSERT INTO ncf_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Oro ngali gim ba atii we Xan Tsi Taamat a ie banam lalon xolkolmoxo ngali adodolii namaang tsaxa.” Iesu ga asaaiti aia taamat isua met, “Iaa asaaiti iu, tapaas, adi num xabangas ma u na laa tataam!” ");
INSERT INTO ncf_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tiwaa tsaa, taamat a tapaas pan no matan di, adi xan xabangas ta matmatuul papan ma ga paʼii Moroaa laa tatan. ");
INSERT INTO ncf_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","No inaman araraa di suk mataa ma di ga paʼii Moroaa. Di taton, di ga we, “Talaawaa giem se lasi no mat maarang mamainaang ta tsap.” ");
INSERT INTO ncf_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Mulina abala, Iesu a es tsuul o ga lasi iexa unaalalet taakis, iesan Liwai, axalkale lalon anuen taakis. Iesu ga paare, “Amusili iaa.” ");
INSERT INTO ncf_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Liwai a tapaas papaalii xan no mat maarang araraa ma ga suk amusili Iesu. ");
INSERT INTO ncf_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Mil Liwai ga xosaraa xariin luxaal tatan ngali Iesu o xariin malep ina no unaalalet taakis ma biexaa no inaman bula, di le angen mii di. ");
INSERT INTO ncf_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Oro no Paarasi ma no unaasasing ina lo, di ga paare xuduxudu laa sin xan no tsi asasing Iesu, “Ngalisa gim ta angen ma nun mii no unaalalet taakis ma no untsaxa?” ");
INSERT INTO ncf_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iesu a xisi di, ga we, “Pispis toto a xap xaalame ngali lasi no inaman di ta axaau? A xap! A xaalame ngali biaa di ta maramase. ");
INSERT INTO ncf_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Iaa xap xaalame ngali ilei no untutiik oro iaa xaalame ngali ilei no untsaxa ngali puxisbal.” ");
INSERT INTO ncf_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Di ga paare ngali ia, “Xan no tsi asasing Jon, ma xadi no tsi asasing no Paarasi, di tigiri el ma sausawit, oro num no di lo angangen ma nunun mu.” ");
INSERT INTO ncf_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Iesu ga xisi di, “A pupua ngali gim ba atutiki xan no xibong aia taamat minaxis, ngali di na el sin iwaa taamat minaxis ta manman tsaa mii di? ");
INSERT INTO ncf_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Oro leng biaa naba xaalame nawe no matenkorot di ba saali iwaa taamat ta we na maxis sin di, ma sin abia no leng di ba el.” ");
INSERT INTO ncf_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ga asaaiti di taman abala totore puapua, “A xap pupua ngali xa naba taterlii xa xolot ina laplap uul ma na tsik tali sin xa laplap xabaar. Nawe a xosaraa weaatia naba se tater abia laplap uul o biaa laplap uul naba xap mat etuna mii abia laplap xabaar. ");
INSERT INTO ncf_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ma a xap pupua ngali xa na tiitiiri waain uul laa lalon no xilkil ina waain xabaar. Nawe aweaatia, biaa xilkil xabaar ina waain uul naba pak, Biaabi waain naba rue tsuul o xilkil ina waain na se tsaxa. ");
INSERT INTO ncf_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","A xap, waain uul di xaa tiitiiri laa lalon xilkil uul ina waain. ");
INSERT INTO ncf_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ma nawe xa anunngi waain xabaar, naba xap saansili ngali waain uul, naba paare weaatalaa, ‘Biaa waain xabaar asuk axaau buxa.’ ” ");
INSERT INTO ncf_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sin biexa Saabat, Iesu a eses laa lalon uma wit o xan no tsi asasing di ga paaski no xalitsa ina wit. Di gisi no taman no liman di ngali saali pinpin, ma di ga ngani no. ");
INSERT INTO ncf_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Biexaa Paarasi di laa ma atsuraa, “Ngalisa gim ta xosaraa abia ta laxei lo ina Saabat?” ");
INSERT INTO ncf_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Iesu a xisi, “O gim xap xoxoti sen maarang Dewit tii xosaraa mii xan no turan, biaa di tii itol? ");
INSERT INTO ncf_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tii tsiga lalon xan anua Moroaa ga adi no tsoki pat ma di ga ngani no, biaa no unsausawit mu di ba ta ngani, amusili lo. Ma ga tabali no turan bula.” ");
INSERT INTO ncf_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Mil Iesu ga asaaiti di, “Xan Tsi Taamat, ia Orong ina Saabat.” ");
INSERT INTO ncf_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sin biexa Saabat, Iesu tii laa lalon anua sausawit ma ga asingan no inaman o iexa taamat xan lima mua ta met totogolo. ");
INSERT INTO ncf_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","No Paarasi ma no unaasasing ina lo, di nen tsalei xa muina ngali atut tali sin Iesu, ma di ga lo xoxoen, ngali nawe atoaa xa sin Saabat. ");
INSERT INTO ncf_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Oro Iesu a se atixi xadi adodo ga paare sin aia taamat liman ta met totogolo, “Tapaas ma u na til laamuaan abala no inaman araraa.” Taamat a tapaas ma ga til sin abia xolot. ");
INSERT INTO ncf_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Mil Iesu ga paare ngali di, “Iaa we ina atsuraa gim, sen mat lo a tutiik sin Saabat, ngali xosaraa mamainaang o ngali xosaraa morokon? O ngali atoaa tino o xosor atsoti tino?” ");
INSERT INTO ncf_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Iesu a nanen iʼis sin di se araraa o ga paare sin aia taamat, “Apalasaa limaam.” Taamat amusili Iesu ta paare, o liman ga sebula axaau. ");
INSERT INTO ncf_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Oro di suk bal musteng ma di ga epaare engen di xuxuuk ngali sawe di ba soro xosaraa sin Iesu. ");
INSERT INTO ncf_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Sin abia no leng, Iesu tii laa papan biexa buk ngali sawit ma lalon abia bing xiduul a lo sausawit laa sin Moroaa. ");
INSERT INTO ncf_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","A se lawaareng o tii ga ilei xan no tsi asasing xaalame sangan ma ga axilangi sangaul ma ga laa lua ina di ma ga putsangi di no aposal: ");
INSERT INTO ncf_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ilaa Saimon (iwaa Iesu ta a tsoxo iesani Pita) turamasen Endru, Jeims, Jon, Pilip, Batalomiu, ");
INSERT INTO ncf_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Metiu, Tomas, Jeims xan tsi Alpias, Saimon iwaa Silot, ");
INSERT INTO ncf_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas xan tsi Jeims ma Judas Iskariot, iwaa tii babel tali Iesu sin xan no matenkorot. ");
INSERT INTO ncf_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Iesu tii es soriri mii di ga laa til papan xolot ta tutiik. Xaraxin malep ina xan no tsi asasing mii xaraxin malep ina inaman di manman tia. Di xaal sin no xolot araraa ina Judaia, Jerusalem ma sin no xolot xuen ina Taia ma Sidon. ");
INSERT INTO ncf_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Biaa no inaman di tii xaalame ngali alongmen ia ma ngali naba atoaa xadi no maramase. Biaa di, no salawa tsaxa di tii atangtangabaai di, di se tuo. ");
INSERT INTO ncf_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ma no inaman di xonon ngali taana Iesu amuina xoror ina tino atsuul sin ma ga atoaa di se araraa. ");
INSERT INTO ncf_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iesu a nanen sin xan no tsi asasing ga paare, “Atatoni biaa gim no muunwas, xan Maradaan Moroaa nagim. ");
INSERT INTO ncf_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Atatoni biaa gim, gim ta itol talaawaa, Orong naba tabiel amaasi gim. Atatoni biaa gim, gim ta tengteng talaawaa, mil gim ba nong tataton. ");
INSERT INTO ncf_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Atatoni abia gim biaa no inaman di ta ngutsulen gim, ma di ga palolii gim, rereti gim, ma di ga atsoti no iesan gim malen morokon, amuina sin iaa, Xan Tsi Taamat. ");
INSERT INTO ncf_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Gim na paalam sin abia leng ma gim na tiili taman tataton amuina nagim xariin iliil made balalangit. Amuina xadi no mom di tii xosaraa abia no mat namaang sin no propet. ");
INSERT INTO ncf_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Oro Xaraxin xirabas sin gim no untang, amuina gim se adi tsaa axoxorong. ");
INSERT INTO ncf_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Xaraxin xirabas sin gim, gim ta angen axaau talaawaa, amuina mil gim ba itol. Xaraxin xirabas sin gim, gim ta nongnong tataton, amuina mil gim ba lolbiir ma lo tengteng. ");
INSERT INTO ncf_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Xaraxin xirabas sin abia gim, no inaman di ta paipaʼii gim, amuina biaa mat namaang xadi no mom di tii xoxosaraa sin no propet ababaa. ");
INSERT INTO ncf_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Oro iaa asaaiti gim, gim tii alongmen iaa. Gim na titii nagim no matenkorot ma gim na xosaraa mamainaang sin abia di, di tii ngutsulen gim. ");
INSERT INTO ncf_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Gim na atubudaani abia di tii xororaa gim ma gim na sawit ngali biaa di, di tii xosor atsoti gim. ");
INSERT INTO ncf_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nawe xa atabaiʼi num paapas, u na puxis tali biexa paapas bula sin. Nawe xa adi num uga disdis, nangaam tilbanti ngali adi biexa uga bula. ");
INSERT INTO ncf_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tabali no inaman araraa di ta ningi gim, ma nawe xa adi nagim xawas, gim nangaam ning mulangena. ");
INSERT INTO ncf_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Gim na xosaraa namaang axaau sin biexaal, malen gim ta saan ngali di ba xosaraa namaang axaau sin gim. ");
INSERT INTO ncf_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nawe gim titii mu biaa di, di ta titii gim, gim we Moroaa naba atubudaani gim? No untsaxa bula di titii abia di, biaa di ta titii di. ");
INSERT INTO ncf_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ma nawe gim axaau ngali abia di, di ta axaau ngali gim, Moroaa naba tali tubudaan sin gim? Amuina no untsaxa bula di xoxosaraa abia bula. ");
INSERT INTO ncf_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ma nawe gim tali xawas, laa sin biaa di, gim ta taltaalnge sin di, ngali di ba xisi, Moroaa naba tali tubudaan sin gim? Amuina no untsaxa bula di taal maarang sin no untsaxa ngali di ba xiis buxaai laa sin di. ");
INSERT INTO ncf_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Oro gim na titii nagim no matenkorot ma gim na xosaraa mamainaang sin di. Gim na tabali di, ma gim nangaam taalnge ngali di ba xiis mulangenai. Mil nagim iliil naba suk lot ma gim ba xan no tsi iwaa ta suk Lapalaa Buxa. Amuina axaau sin abia di, di ta xap taton sin Moroaa, ma biaa no untsaxa. ");
INSERT INTO ncf_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Gim na ie biirbirum malen nagim Mom bula ta ie biirbirum sin no inaman araraa. ");
INSERT INTO ncf_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Gim nangaam ininte, ngali Moroaa naba xap ininte sin gim bula. Gim nangaam atutali mamaet papan xa, ngali Moroaa naba xap atutali mamaet papan gim bula. Gim na adodolii xadi no namaang tsaxa biexaal, ngali Moroaa naba adodolii nagim no namaang tsaxa. ");
INSERT INTO ncf_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tabiel, ngali Moroaa naba tabali gim. Puapua axaau abia Moroaa ta tsoxaa laa lapula ma ga taagalen ngali tuali sebula ma naa usli. Ma naa rue laa pano xaiim. Sinsa, sen puapua gim ta tali, Moroaa naba taal mulangen abia puapua sin gim.” ");
INSERT INTO ncf_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iesu asaaiti di bula taman abala totore puapua, “A pupua ngali xa matababa naba laamuangen iexa matababa? A xap! Delu ba suk xol arie laa lalon lis!” ");
INSERT INTO ncf_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Xa tsi asasing a xap laamuangen xan unaasasing. A xap! No tsi asasing araraa, nawe di ba alet asasing axaau di ba arie pupua malen xadi unaasasing. ");
INSERT INTO ncf_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ngalisa u ta lasi pu ro ina ie lalon matan num taamat o u ga xap adodomi abia xoltin ie lalon mataam tsaa? ");
INSERT INTO ncf_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","U ba sen paare we, sin num taamat: ‘Nugu taamat, xaalame ina saali pu ro ina ie alen mataam,’ biaa iu tsaa u xap adodo ngali lasi xoltin ie lalon mataam tsaa. Iu nan xalam lua! U na setauan saali xoltin ie alen mataam tsaa, mil u ba pupua ngali nanen axaau, ngali saali pu ro ina ie alen matan num taamat. ");
INSERT INTO ncf_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“A xap xa ie axaau na xaa waalii xaa waawaan tsaxa, malen mu a xap xa ie tsaxa na xaa waalii xaa waawaan axaau. ");
INSERT INTO ncf_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","No ie xuxuuk, di nen xilalaa sin xan no waawaan tsaa. No inaman di xap paaski no waawaan fik lalon no kuikui, o no greip sin no bariar. ");
INSERT INTO ncf_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Taamat axaau asen xan no namaang axaau amusili no namaang axaau lalon xan butsa. Taamat morokon asen xan no namaang morokon amusili no namaang morokon lalon xan butsa. No sen namaang ta usli lalon xan butsa taamat, naba tsuul lalon ngutsina. ");
INSERT INTO ncf_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ngalisa gim ta putsangi iaa, ‘Orong, Orong,’ o gim ga xap xosor amusili saxawe iaa ta paatinai? ");
INSERT INTO ncf_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Iaa ba asen sin iu, iwaa ta xaalame sangaaga ta sen we ma ga alongmen nugu no totore ma ga amilpuaa no. ");
INSERT INTO ncf_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Iwaa taamat a malen aia taamat ta tumaraa anua papan pula. Axaii aririi no mat ma ga axos awatwati no tutur papan atkale. Nawe xariin tinate a xaalame ngali abia anua, naba xap pupua ngali tsuuleli amuina axos awatwati anua. ");
INSERT INTO ncf_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Oro iwaa xa ta alongmen nugu no totore ma ga xap amilpuaa no, a malen aia taamat ta xosaraa anua papan pula ga xap muun atilariiti xan no tutur ina anua papan atkale. Tiwaa tsaa biaa xariin tinate ta laa xaalame asuk tsuule lii abia anua ma ga suk tabek laaliu.” ");
INSERT INTO ncf_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Biaa Iesu ta se araraai xan no papaare sin xadi lolong no inaman, asuk tsiga Kaperanaam. ");
INSERT INTO ncf_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tia, xan untutule lalaamua ina no unmakmaxil a maramase ngali na se met. Iwaa lalaamua ina no unmakmaxil asuk titii buxaai iwaa xan untutule. ");
INSERT INTO ncf_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Iwaa lalaamua ina no unmakmaxil alongen Iesu ta tsap ma ga tulen no xusaak ina no Jiu laa sangan ia, ngali di na atsuraa, ngali na xaalame ma na atoaa xan untutule. ");
INSERT INTO ncf_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Biaa di ta xaalame sangan Iesu di suk asaait awatwati weaatalaa, “Ilawaa taamat asuk saan ngali una xosaraa abala sin, ");
INSERT INTO ncf_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","amuina a titii buxaai xida xobel labalaba Judaia ma ga xosaraa xida anua sausawit.” ");
INSERT INTO ncf_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","O Iesu ga laa mii di. Tii xap mager tsap atataaen anua, iwaa lalaamua ina no unmakmaxil ga tulen no turan ngali asaaiti ia weaatala: “Orong, nangaam adodo xuduxudu, amuina iaa xap axaau buxa ngali u ba xaalame tataaga. ");
INSERT INTO ncf_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Biaabi iaa ga lasi malen iaa xap pupua ngali xaalame sangaam amuina iaa xap mamainaang buxa ngali xaalame sangaam. Oro u na paare mu ngali nugu untutule naba tuo. ");
INSERT INTO ncf_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ngali iaa tsaa taamat, iaa manman paina banam, nugu no unmakmaxil di manman paina iaa. Iaa xaa asaaiti aila, ‘Laa,’ o ga laa; o iliaa, ‘xaalame,’ o ga xaalame. Iaa xaa asaaiti nugu untutule, ‘xosaraa abala,’ ga xaa xosaraa malen iaa ta xaa paare.” ");
INSERT INTO ncf_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Biaa Iesu ta alongmen abala, asuk olol buxa sin ia, ga putsi laa sin abia malep ta amusili ia ga paare, “Iaa asaaiti gim, iaa xap tatanginai xa na ie xariin tinaalnge tala Israel malen aila.” ");
INSERT INTO ncf_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mil biaa no taamat di ta xaalame sangan Iesu, biaa di ta se mula laa nan anua, di se laa tatanginai iwaa untutule ta se axaau. ");
INSERT INTO ncf_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mil mu, Iesu a laa lalon inaman laba Nain o xan no tsi asasing ma xariin malep di tii laa bula mii ia. ");
INSERT INTO ncf_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Biaa Iesu ta se laa atataaen matan mat ina abia inaman laba, di alet atsuulngi iexa tsi ta se met. Xan tsi taamat iwaa aina ta xuuk mu xan maxis tii se metlii taman. Biaa xariin malep lalon inaman laba di laa mii ia. ");
INSERT INTO ncf_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Biaa Orong ta lasi iwaa aina, asuk titii buxaai ia ma ga asaaiti, “Nangaam teng.” ");
INSERT INTO ncf_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Mil ga laa lapalaa ga taana abia xabangas tongaan ta tete papan, ma biaa di, di ta atsaxei ia di suk til wat. Iesu ga paare, “Taamat xulaau, iaa asaaiti iu, u na tapaas!” ");
INSERT INTO ncf_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Iwaa tongaan a tapaas ma ga suk papaare, o Iesu ga giwaa laa sin xan nagaa. ");
INSERT INTO ncf_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","No inaman araraa di tii us taman xariin minataa ma di tii ga suk paʼii Moroaa, di ga paare weaatalaa, “Ilawaa xariin propet so, a se tsap labatina gita. Ma gita se lasi no liman Moroaa ta taxaa talaawaa” ");
INSERT INTO ncf_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Balawaa inesaait ina Iesu asuk sol sin no xolot araraa Judaia ma biaa no inaman laba atataaen. ");
INSERT INTO ncf_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Xan no tsi asasing Jon di tii asaaiti ia, taman abala no maarang. Tii ilei delulu, ");
INSERT INTO ncf_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ma ga tulen delulu ngali laa atsuraa Orong: “Iu mu Karisito iwaa naba xaalame, o giem ba lo liliis tsaa ngali xa, xaatsap?” ");
INSERT INTO ncf_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Biaa lo taamat delu tii le tsap sangan Iesu, delu ga paare, “Jon Unaaxaxadaan a tulen gelu xaalame sangaam ngali le atsuraa iu: ‘Iu mu Karisito iwaa naba ta xaalame, o giem ba lo liliis tsaa ngali xa xaatsap?’ ” ");
INSERT INTO ncf_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sin abia leng, Iesu atoaa no daan inaman di tii ie maramase ma ga saali no salawa morokon ta tsigaii di, ma ga atoaa no matababa. ");
INSERT INTO ncf_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","O ga xisi delulu, “Gulu na mula, ma gulu na atolomi sin Jon, sawe gululu ta se lasi ma alongmen: No matababa di se nanen, no xadek met di se eses, biaa no taamat taman minet basbas di se tuo, biaa no talingaban di se lolong, biaa no inaman di ta se met, di se tapaas mula ma di se baais taman inesaait mamainaang laa sin no muun was. ");
INSERT INTO ncf_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Atubudaani aia taamat ta xap xol laa palaaen amuina sin iaa.” ");
INSERT INTO ncf_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Mulina xan no tsi asasing Jon, delu tii se laa, Iesu a sebula papaare sin abia malep taman Jon, “Gim tii laa lalon xobel biil, ngali laa lasi sawe? Biaa lenlil maal ta lo mamaalen? ");
INSERT INTO ncf_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nawe a xap, O gim tii laa ngali lasi sa? Taamat ta tamtuel lalon no uga mamainaang buxa? A xap! Biaa di, di ta tamtuel lalon no uga mamainaang buxa xadi no iliil ta lapalaa ma di manman lalon no xariin anua. ");
INSERT INTO ncf_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Oro gim tii laa ngali laa lasi sa? Xa propet? Iou! Iaa asaaiti gim, Jon asuk lot buxa ngen tsaa no propet. ");
INSERT INTO ncf_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Balawaabi di ga atalaa abala ngali aia xa. “ ‘Iaa ba tulen nugu ngutsu laamuangen iu, iwaa naba ta taxaaturungi num sal laamuaan iu.’ ");
INSERT INTO ncf_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Iaa asaaiti gim, labatina no inaman araraa, biaa di, no aina di ta taxaana, a xap xa na lot buxa ngen Jon, oro iwaa ta dokdok buxa lalon xan Maradaan Moroaa asuk lot buxa ngen ia.” ");
INSERT INTO ncf_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(No inaman araraa, ma no unaalalet taakis bula, biaa di ta alongen xan no totore Iesu, di suk nen xilalaa we xan sal Moroaa asuk tutiik amuina Jon tii axadaani di. ");
INSERT INTO ncf_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Oro no Paarasi ma no unsinaae ina lo di palolii xan adodo Moroaa ngali di, amuina di tii xap muun alet axaxadaan sin Jon.) ");
INSERT INTO ncf_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Iaa ba sen apuaa we, abala nan ul in atalaawaa? Di sen parawe? ");
INSERT INTO ncf_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Di malen abia no tsi dokdok di ta tsotso lalon niaan susune, di xaa ililei engen di: “ ‘Giem xuina piut ngali gim ba tiili o gim ga xap muun tiili. Giem anaanngi no tso tengteng o gim ga xap muun teng.’ ");
INSERT INTO ncf_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Amuina Jon Unaaxaxadaan, tii xap xaalame ngali ngen tsoki ma nun waain o gim ga paare, ‘Salawa tsaxa tii tsigaii ia.’ ");
INSERT INTO ncf_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Xan Tsi Taamat a xaalame ga angangen ma nun, ma gim ga paare, ‘Ilawaa taamat atsaam metmet ia ungogo taman daan watwat, ma xan no turan, no unaalalet taakis ma no untsaxa.’ ");
INSERT INTO ncf_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Oro biaa tino mamainaang ina abia di, di ta amusili sinaae, di asen we aso.” ");
INSERT INTO ncf_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Iexa ina no Paarasi aningi Iesu ngali laa angen tatan sin biexa nale. Iesu a se laa lalon xan anua aia Paarasi ma ga se tsotso ngali angen. ");
INSERT INTO ncf_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Iexa aina, a manman taman tino ina namaang tsaxa lalon abia inaman laba, ga atii we Iesu naba le angen tatan aia Paarasi, asuk xaalame taman sobuk xaat ta us taman daan ta tso mamainaang. ");
INSERT INTO ncf_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ma ga le til mulina ia sangan no xaden taman no tineng, asuk amadaaki no xaden ia taman xan no didin mat. Ga sil a puraa no xaden ia taman no ulin xuan, anguri no, ma ga patsaa abia daan ta tso mamainaang papan xan no xaden. ");
INSERT INTO ncf_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Biaa iwaa Paarasi ta ningi ia ngali xaalame tatan, a lasi abala ga suk paare sin ia tsaa, “Nawe ilawaa taamat ia propet, naba atii saa aia ta taana ia ma sen mat laxen aina aia, amuina ilawaa aina untsaxa.” ");
INSERT INTO ncf_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iesu a xisi ia, “Saimon, was bala iaa we ina asaaiti iu taman.” Saimon ga paare, “Asaaiti iaa, unaasasing.” ");
INSERT INTO ncf_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Lo taamat delu ie xiba sin iexa taamat ngali delu ba xisi mil. Xan xiba iexa taamat a malen no sangsangaul alima ina xuxute (500) o iexa no sangaul alima (50) sin. ");
INSERT INTO ncf_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Delu adi abia no xuxute oro delu ga xap ie xuxute ngali xisi. Mil iwaa taamat ga adodolii xadelu no xiba amuina delu xap muun xisi no. Lowas, saa ina delulu naba suk titii buxaai iwaa taamat?” ");
INSERT INTO ncf_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon a xisi, “Manaa, iwaa taamat ta adi xuxute lot tii se adodolii xan xiba.” Iesu ga we, “Num ininte a tutiik.” ");
INSERT INTO ncf_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Mil Iesu apuxutsi laa sangan aia aina ga paare ngali Saimon, “U lasi aila aina. Iaa le tsiga lalon num anua o u ga xap muun tali xa daan ngali silii no xaʼigi, oro ilawaa aina asilii no xaʼigi taman xan no didin mat ma ga a puraa no taman no ulin xuan. ");
INSERT INTO ncf_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","U tii xap nguri iaa, oro ilawaa aina, biaa iaa ta le tsiga, a xap iaawis sin ngurnguri no xaʼigi. ");
INSERT INTO ncf_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","U xap aturungi daanwe papan xuaaga, oro ilawaa aina a patsaa no xaʼigi taman daan ta tso mamainaang. ");
INSERT INTO ncf_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Biaabi iaa ga asaaiti iu, xan no namaang tsaxa araraa iaa se adodolii no, asen malen xan titii a buxa. Oro, saa ia ta adodolii dokdok, xan titii a dokdok bula.” ");
INSERT INTO ncf_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Mil Iesu ga asaaiti ia, “Num no namaang tsaxa, iaa se adodolii no.” ");
INSERT INTO ncf_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Biaa no xibong di epaare engen di tsaa, “Saa taamat aila, ta pupua ngali adodolii no namaang tsaxa?” ");
INSERT INTO ncf_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Iesu ga paare ngali aia aina, “Num tinaalnge a se atoaa iu, laa lalon malina.” ");
INSERT INTO ncf_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Mulina abala, Iesu a laa lalon no inaman laba ma no xobel xuxuuk ngali baais taman inesaait mamainaang ina xan Maradaan Moroaa. Sangaul axuuk ma ga laa lua ina xan no tsi asasing di tii laa mii ia, ");
INSERT INTO ncf_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ma biexaa aina bula, biaa Iesu tii saali no salawa tsaxa ma no mat laxen maramase sin di: Ilaa Maria Magdalin, iwaa no salawa ta paasaalua tii tsuul alen, ");
INSERT INTO ncf_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ila Joana, xan xuaala ilaa Kusa, iwaa ta lalaamua lalon xan anua Erot; ilaa Susana ma biexaal bula. Balawaa no aina di tiltsomi Iesu mii xan no tsi asasing taman xadi no xuxute ma xadi no luxaal tsaa. ");
INSERT INTO ncf_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Biaa xariin malep di ta tsap etudim, di xaal lalon no daan inaman laba se araraa, o Iesu ga asaaiti di taman abala totore puapua. ");
INSERT INTO ncf_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Unsoksok a laa ngali soxaa xan no xalitsa. A laa ma ga amiiri no xalitsa o biexaa xalitsa ga xol amusili sal. No inaman di eses papan no ma no maan di ga le ngani no. ");
INSERT INTO ncf_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Biexaa xalitsa a xol papan no xaat. O biaa di ta tsik dokdok mu di ga malang amuina a xap xa daan sin. ");
INSERT INTO ncf_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Biexaa xalitsa a xol labatina no xoxor ga tsik mii no palis, o biaa no palis xoxor ta tsik butbutu, asuk xail amantei no. ");
INSERT INTO ncf_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Oro biexaa xalitsa a xol tsaa lalon pula ta axaau ga tsik no ma ga waalii no waawaan. Atsap sangsangaul ina waawaan ina xalitsa axuuk di ta soxaa.” Biaa ta paatina abala asuk paare lot, “Iwaa ta ie talinga, na lolong.” ");
INSERT INTO ncf_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Xan no tsi asasing di ga atsuraa ngali sen muina ina abala totore puapua. ");
INSERT INTO ncf_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Iesu ga asaaiti di, “Sinaae ngali no maarang ta xuxii lalon xan Maradaan Moroaa a se tali sinaae sin gim, o sin biexaal xaatsap iaa paatina no totore puapua, ngalibi, “ ‘Di ba lasi no maarang, ta malen di xap lasi no, ma di ba alongen no totore o di ba xap muun leng.’ ");
INSERT INTO ncf_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Balawaa muina ina totore puapua: Biaa xalitsa xan totore Moroaa. ");
INSERT INTO ncf_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Biaa no xalitsa ta xol lalon sal a malen abia di ta alongmen no totore, o Saatan ga xaalame ma ga saali abia totore lalon xadi no butsa, ngalibi di ba xap taltaalnge ma adi atotoaa. ");
INSERT INTO ncf_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Biaa no xalitsa ta xol papan xaat, a malen abia di ta adi totore taman taton nawe di alongmen, oro di xap atsuul baa. Di taltaalnge dokdok mu, o nawe xonkonon atsap, di se xol. ");
INSERT INTO ncf_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Biaa no xalitsa ta xol labatina no palis xoxor a malen abia di ta alongmen xan totore Moroaa, oro di ga amusili xadi no sal tsaa di ga liaan taman lolbiir ina tino, di ga taton taman xadi no daan maarang malen tang ma di ga xap maatkel. ");
INSERT INTO ncf_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Oro, biaa no xalitsa papan pula axaau a til axilangi biaa no butsa ta suk axaau ma di ga alongmen totore, taxaariti, amusili ma di ga waalii no waawaan. ");
INSERT INTO ncf_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“A xap xa na araraa rarar ma na baaii, o na aturungi paina ibe. A xap! A xaa ataxiwaa sin niaan taktaxiu ngalibi no saa di ta tsiga di ba lasi abia rarar. ");
INSERT INTO ncf_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ngali abia muina a xap xawas ta xuxii di ba xap tsal tatanginai, ma sawe u ta axuina naba tsap lengleng. ");
INSERT INTO ncf_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Biaabi u na adodoriiti sawe u ta alongmen. Nawe saa ia ta iewas, di ba tabiel buxaai; oro saa ia ta xap iewas, ga adodo we a iewas, di ba alet mulangen no maarang sin ia.” ");
INSERT INTO ncf_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Talaawaa xan nagaa Iesu ma no turumasen di xaalame ngali le lasi Iesu, oro di ga xap pupua ngali laa sangan amuina sin abia xariin malep. ");
INSERT INTO ncf_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Xa ga asaaiti ia, “Num nagaa ma no turumasen iu balaa di ta tiltil lokobel, di saan ngali lasi iu.” ");
INSERT INTO ncf_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Iesu a xisi, “Nugu nagaa ma no turumasen iaa, biaa mu di, di ta alongmen xan totore Moroaa ma di ga amusili no.” ");
INSERT INTO ncf_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sin biexa leng Iesu asaaiti xan no tsi asasing, “Naga laa sin gelgel xaatalaa ina daan ulis.” Ma di ga xaa papan mono ma di ga laa. ");
INSERT INTO ncf_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Biaa di ta se alusa laa, Iesu asuk urange. Biexa xariin maal a tapaas lalon daan ulis ma ga wena se lulus ma di suk manman lalon xaraxin mamaet. ");
INSERT INTO ncf_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","No tsi asasing di ga laa ma apadaa ia, di ga paare, “Orong, Orong, gita ba se liaan!” Iesu a pade ma ga imii maal ma laman, ma biaa xariin maal ga suk met araraa ma ga suk malina. ");
INSERT INTO ncf_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Iesu ga atsuraa xan no tsi asasing, “Itaa gim se tali nagim tinaalnge?” Lalon minataa ma lalon olol, di ga etsura engen di. “Nugutu sen taamat so aila? A paare o maal ma daan ga lolong amusili ia.” ");
INSERT INTO ncf_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Di alusa laa lalon xolot ina Gerasin, a manman xaatalaa ina daan ulis Galili. ");
INSERT INTO ncf_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Biaa Iesu ta tsuul laa xuen, iexa taamat lalon inaman laba salawa ta tsigaii asuk sabasue. Xamkabaar tsaa, ilawaa taamat abelbel, a xap manman lalon xa anua, a xaa manman lalon no lia pupuna mu. ");
INSERT INTO ncf_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Biaa ta lasi Iesu asuk xuup lot weaatalaa, “U wena xosaraa sa sin iaa, Iesu, xan Tsi Moroaa lapalaa suk se? Iaa ningi iu ngali u na xap xosaraa atsoti iaa!” ");
INSERT INTO ncf_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Amuina Iesu a se paare watwat ngali aia tanua tsaxa na tsuul alen aia taamat. No daan leng iwaa salawa atigiri sabatsoli ia. Nawe no inaman di xaa pitsi taman tsen sin no liman ma no xaden a xaa baxi tsen ma ga xaa sol laa lalon no xobel biil sin iwaa salawa ta xaa tali watwat sin. ");
INSERT INTO ncf_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Iesu atsuraa, “Saa iesaam?” Iwaa taamat a xisi ga we, “Iaa Legion,” amuina no daan salawa tsaxa di se tsigaii ia. ");
INSERT INTO ncf_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ma biaa no salawa di ningi awatwati Iesu, ngali na xap tulen di laa lalon lis. ");
INSERT INTO ncf_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Xariin xobel bol di lo angangen sin gelgel ina buk. Biaa no salawa di ningi Iesu ngali na tulen di laa lalon abia no bol ma Iesu ga siir. ");
INSERT INTO ncf_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Biaa no salawa di ta tsuul lalon aia taamat, ma di suk tsigaii no bol ma di suk soriri tsuul papan buk, di ga rik lalon daan ulis ma di tii ga suk liaan. ");
INSERT INTO ncf_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","No untamtabiel bol di lasi weaatia, o di suk sol laa ma di ga paatina taman abia maarang lalon inaman laba ma sin no xobel palaaen inaman laba. ");
INSERT INTO ncf_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","O no inaman di ga laa ngali lasi abia maarang ta tsap. Biaa di ta xaalame sangan Iesu, di le tatanginai iwaa taamat no salawa ta tsuul papaalii ta tsotso sangan no xaden Iesu. Atamtuel lalon no manman ma ga se adodo axaau, o di ga suk mataa. ");
INSERT INTO ncf_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Biaa di tii lasi abala, di asaaiti no inaman taman Iesu tii sen atoaa wenangenai aia taamat no salawa tsaxa tii tsigaii ta se tuo. ");
INSERT INTO ncf_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Mil no inaman lalon xolot Gerasin di ga ningi Iesu ngali na se papaalii di amuina di mataa buxa sin abia maarang ta xosaraa. Biaabi Iesu ga taxaaturung ngali xaa papan mono ngali laa. ");
INSERT INTO ncf_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Iwaa taamat no salawa di ta tsuul papaalii, aningi awatwati Iesu ngali amusili ia, oro Iesu ga tulenlii ia ga paare, ");
INSERT INTO ncf_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Mula laa lokobel ma u na baais taman sawe Moroaa ta se xosaraa sin iu. Biaabi, iwaa taamat ga laa ma ga atalem sin no inaman laba taman samaarang Iesu ta se xosaraa sin ia.” ");
INSERT INTO ncf_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Iesu a se mula o xariin malep ina inaman di suk putsangi axaau sin xan tsinap, amuina di lo liliis ngali ia. ");
INSERT INTO ncf_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mil iexa taamat iesan ila Jairus lalaamua ina anua sausawit a xaalame ma ga le xol sangan no xaden Iesu. Ga ningi Iesu ngali xaalame lalon xan anua, ");
INSERT INTO ncf_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","amuina xan nan tsaana mu, a we na se met, iwaa tsaana xan no miet a sangaul axuuk ma ga laa lua. Biaa Iesu ta es laa lalon sal, biaa malep di suk asuruti ia. ");
INSERT INTO ncf_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ma iexa aina ia ta ie minet nanxaskas sin no miet ta se sangaul axuuk ma ga laa lua, ma ga xap xa na pupua ngali atoaa ia. ");
INSERT INTO ncf_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Iwaa aina a xaalame mulina Iesu ma ga taana barangutsina xan uga disdis, o tiwaa tsaa biaa minet nanxaskas asuk xap. ");
INSERT INTO ncf_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","“Saa taxaane iaa?” Iesu a tiirik. Biaa di araraa di ga ulis, Pita ga paare, “Lalaamua, xariin malep di asuruti iu.” ");
INSERT INTO ncf_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Oro Iesu ga paare, “Xa tsaa ia ta taana iaa. Iaa atii, amuina iaa saaen xoror watwat ta tsuul alen iaa.” ");
INSERT INTO ncf_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mil aina ga lasi malen Iesu a se atik tatanginai, asuk es didiir xaalame ma ga le xol sangan no xaden. Lalon no matan no inaman, asuk asaaiti Iesu ngalisa ta taana ma ga sen tuo we. ");
INSERT INTO ncf_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Iesu ga paare ngali ia, “Nugu tsaana, num tinaalnge a se atoaa iu, u na laa lalon malina.” ");
INSERT INTO ncf_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Biaa Iesu ta lo papaare tsaa, iexa taamat axaal lalon xan anua Jairus, lalaamua ina anua sausawit ga asaaiti Jairus, “Num tsaana a se met, nangaam alilii bula unaasasing.” ");
INSERT INTO ncf_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Iesu alongmen abala ga paare ngali Jairus, “Nangaam mataa; u na taltaalnge, ngali naba tuo.” ");
INSERT INTO ncf_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Biaa Iesu ta se laa tsap lalon xan anua Jairus, a xap siir ngali xaal di na tsiga mii. Asiir mu ngali Pita, Jon, Jeims, ma xan mom ma xan nagaa tsaana ngali di na tsiga. ");
INSERT INTO ncf_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Sin abia aua, no inaman di teng lolbiir ma biexaal di suk teng xuupkup. Iesu ga paare ngali di, “Gim nangaam tengteng, ilawaa tsaana a xap met, a urange mu.” ");
INSERT INTO ncf_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Di suk nongen ia, amuina di atii tsaana a se met. ");
INSERT INTO ncf_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Oro ga taana liman ma ga paare weaatalaa, “Nugu tsaana, u na tapaas!” ");
INSERT INTO ncf_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nantanuaan tsaana asuk mula, ma a xap sauna mu tsaana asuk til lapalaa, o Iesu ga asaait ngali di na tabali. ");
INSERT INTO ncf_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Xan mom ma xan nagaa di suk olol buxa, oro Iesu asaait awatwati di ngali di na xap asaaiti xaal taman abala maarang ta tsap. ");
INSERT INTO ncf_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Biaa Iesu ta se ilei axumuli xan no tsi asasing ta sangaul ma ga laa lua, asuk tali abia watwat ma banam sin di ngali tulen atsuulngi no salawa ma atoaa no mat laxen maramase, ");
INSERT INTO ncf_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ma a tulen di ngali baais taman xan Maradaan Moroaa ma ngali atoaa biaa di, di ta maramase. ");
INSERT INTO ncf_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Iesu ga asaaiti di, “Gim nangaam adi xaa was sin abala ines—na xap xa xudak, na xap xa tutuel, na xap xa tsoki, na xap xa xuxute ma na xap xa uga bula mii gim. ");
INSERT INTO ncf_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Sen anua gim laa tsap lalon, gim na manman atia lalon til gim ta papaalii abia inaman laba. ");
INSERT INTO ncf_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nawe no inaman di xap sirawaa gim lalon abia xobel, gim na panlii kuku sin no xaden gim nawe gim tapaas papaalii abia xobel ngali asen so malen xa papaare leng ngali epuske mii di.” ");
INSERT INTO ncf_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Lowas no tsi asasing di tapaas laa lalon no xobel xuxuuk di ga baais taman Inesaait Mamainaang ma di ga atoaa no inaman lalon abia no xolot araraa. ");
INSERT INTO ncf_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Erot, gawana ina no prowins Galili ma Peraiʼa, alongmen abala no maarang ta tsap ma xan adodo asuk xap matul axaau. Amuina biexaal di we Jon a se tapaas mula sin minet. ");
INSERT INTO ncf_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Biexaal di we Elaija a se asemat, o biexaal bula di we, iexa ina no propet in ti laamua a sebula tino mula. ");
INSERT INTO ncf_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Oro Erot ga paare, “Iaa se ritlii xuan Jon. O saa aila, iaa ta alongmen ta sebula xosaraa abala no maarang?” Ma ga xonon ngali na lasi ia. ");
INSERT INTO ncf_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Biaa no aposal di ta se mula laa di le asaaiti Iesu taman no sen maarang di ta se xosaraa. A giwaa di mii ia ma di ga arie laa xasinge di tsaa lalon xobel Betasaida. ");
INSERT INTO ncf_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Oro biaa malep, di se sinaae sin Iesu itaa naba ta laa ma di ga suk amusili ia. Iesu a suei di ma ga asaaiti di taman xan Maradaan Moroaa, ga atoaa abia di, di ta maramase. ");
INSERT INTO ncf_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","A se nale, o no sangaul axuuk ma ga laa lua ina tsi asasing di ga xaalame sangan Iesu di ga we, “Tulen abala malep laa lalon no xobel atat ngali di ba laa tsal xadi luxaal ma xaa xolot ngali urange amuina gita man lalon xobel biil.” ");
INSERT INTO ncf_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Iesu ga xisi, “Gim na tabali di taman xaa luxaal ngali di ba angen.” Di xisi, “Alima no tsoki ma alua mu no xoo bala, o giem xap pupua ngali uuli xaa luxaal ngali abala xariin malep.” ");
INSERT INTO ncf_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","A pupua malen alima no tausan ina taamat. O Iesu ga paare sin xan no tsi asasing ga we, “Gim na atsotsoi no taamat sin no xumkumul ina no sangaul alima ina taamat.” ");
INSERT INTO ncf_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","No tsi asasing di xosaraa weaatia o no inaman araraa di suk tsotso lapula. ");
INSERT INTO ncf_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Iesu adi no tsoki ta lima ma no xoo ta lua, a nanen laa balalangit ga putsangi axaau sin Moroaa ma ga tsabaxi no. Mil ga tali sin no tsi asasing ngali di ba tabali no inaman. ");
INSERT INTO ncf_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","No inaman di angen ma di ga suk maaslii no xolot ina luxaal. No tsi asasing di adi sangaul ma ga laa lua ina tep ma di ga tuali xadi no ngaalngaal. ");
INSERT INTO ncf_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sin biexa leng, Iesu a laa sausawit mii xan no tsi asasing lalon biexa xolot ta xap xa inaman ma Iesu ga atsuraa di, “Balawaa no malep di we iaa saa?” ");
INSERT INTO ncf_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Di xisi, “Biexaal di we, iu Jon unaaxaxadaan, biexaal di we, iu Elaija, biexaal bula di we, iu xa ina abia no propet in ti laamua, o ga sebula tino mula.” ");
INSERT INTO ncf_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","O Iesu ga atsura, “Oro gim, gim we iaa saa?” Pita a xisi, “Iu xan Karisito Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Iesu atewaai di ngali di na tilaamamil ngali xap asaaiti xaal taman abala. ");
INSERT INTO ncf_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","O Iesu ga we, “Xan Tsi Taamat naba alet sosong sin no daan mat maarang, ma no xusaak, no lalaamua ina no unsausawit ma no unaasasing ina lo di ba palolii ia. Ma di ba sas amantei, o mulina nanaatuul ina leng naba tapaas mula taman tino.” ");
INSERT INTO ncf_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Iesu ga paare sin di araraa, “Nawe xa a saan ngali amusili iaa, na suk adodolii ia tsaa, ma na atsaxei xan tongol sin no daan leng ma na amusili iaa. ");
INSERT INTO ncf_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nawe saa ia ta taxaariti xan tino lalon xolkolmoxo, naba xosorlii, oro saa ia ta tali xan tino lalon xolkolmoxo ngali iaa naba tino. ");
INSERT INTO ncf_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Xan sen axaau taamat naba adi nawe a tapkina abala xolkolmoxo o mil ia tsaa ga xap adi tino laaliu? ");
INSERT INTO ncf_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nawe xa a mangiel sin iaa ma nugu no totore, Xan Tsi Taamat bula naba mangiel sin, nawe a xaalame taman xan minaalam ma xan no minaalam xan Mom ma no angelo pat. ");
INSERT INTO ncf_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Iaa asaaiti gim taman so, biexaal ina gim di ta tiltil atalaa di ba xap mager met sin di ba ta setauan lasi xan Maradaan Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Iesu asaait taman abala o mulina no leng ta paasaatuul ta se liu, A giwaa Pita, Jon ma Jeims ma di ga laa ningning lapalaa papan biexa buk. ");
INSERT INTO ncf_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Biaa Iesu ta lo sausawit, xan nanen asuk tsap xaatsap ma xan no uga disdis asuk iaas buxa malen tsilatsila. ");
INSERT INTO ncf_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","No taamat alua, ilaa Moses ma Elaija, ");
INSERT INTO ncf_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","delu asemat taman minaalam ina tsilatsila, ma delu ga papaare mii Iesu. Detuu papaare taman Iesu naba ta poroklii xolkolmoxo, biaa naba ta taxaa puaa tia Jerusalem. ");
INSERT INTO ncf_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita mii no turan, detuu suk mata uʼurange, oro biaa detuu ta pade axaau maaba, di suk lasi xan minaalam Iesu ma biaa delulu ta tiltil mii. ");
INSERT INTO ncf_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Biaa Moses ma Elaija delu ta we na se papaalii Iesu, Pita asuk paare sin, “Manmanel, asuk axaau gita na le man ataala. Gita na atilngi xaa baul na tuul ataala, num ka, xaka Moses ma xaka Elaija.” (Pita a xap atii sawe abia ta papaare taman.) ");
INSERT INTO ncf_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Biaa ta lo papaare tsaa, pu xelangit atsap, ma ga ngaati di ma di ga suk mataa, biaa di ta tsiga lalon abia xelangit. ");
INSERT INTO ncf_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","O inan xa axaal lalon abia xelangit ga we, “Ilawaa, nugu tsi, iaa ta se axilangi. Gim na lolong sin.” ");
INSERT INTO ncf_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Biaa ine a se papaare xap, o detuu ga lasi Iesu ta se tiltil ia xasinge. No tsi asasing detuu xap asaaiti xa sin abia aua taman sawe detuu ta se lasi. ");
INSERT INTO ncf_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Sin leng papan, biaa di ta se tsuul lapula xaal papan buk, xariin malep di le sabasue ia. ");
INSERT INTO ncf_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Lasi, iexa taamat lalon abia malep asuk ilei Iesu, “Unaasasing, iaa suk ningi iu ngali u ba lasi nugu tsi, ilawaa nugu nan tsi mu. ");
INSERT INTO ncf_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Salawa tsaxa alogotsi ia o ga tunga ma ga xaa xuup, a xaa lii adidiiri lapula ma no biso ga xaa tsuul lalon ngutsina. A xap xaa papaalii ia, ma ga tsaalen ia. ");
INSERT INTO ncf_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Iaa ningi num no tsi asasing ngali di na saali aia salawa tsaxa o di ga xap pupua.” ");
INSERT INTO ncf_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iesu a xisi, “Gim no muun taltaalnge ma no utmilmil ina namaang morokon. Saapuaa iaa ta manman mii gim, o gim ba ie tinaalnge langisa? Tali num tsi tala.” ");
INSERT INTO ncf_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Biaa iwaa tsi ta lo es xaxaalame, iwaa salawa tsaxa alii ia papan pula ma ga suk didiir. Oro Iesu asuk imii iwaa salawa tsaxa, atoaa iwaa tsi ma ga taal mulangenai laa sin xan mom. ");
INSERT INTO ncf_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","No inaman di suk tunga sin abia xan watwat ma xan minaalam Moroaa. Biaa no inaman di ta lo adodo xuduxudu sin abia maarang Iesu ta xosaraa, o Iesu ga paare sin xan no tsi asasing, ");
INSERT INTO ncf_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Gim na lolong axaau sin sawe iaa ta wena asaaiti gim taman. Xan Tsi Taamat di ba babel tali papan no liman no taamat.” ");
INSERT INTO ncf_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Oro di xap leng sin muina abala totore. Balawaa totore asuk man xuxii sin di ngali di ba xap tsiili. Di ga mataa ngali atsuraa Iesu taman. ");
INSERT INTO ncf_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Biexa inemagaae atsap lolobet ina no tsi asasing ngali saa naba suk ies lot labatina di. ");
INSERT INTO ncf_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iesu a se atii xadi no adodo ina butsa, ga giwaa tsi dokdok ma ga atilngi sangan. ");
INSERT INTO ncf_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ma ga paare ngali di, “Nawe saa ia ta suei atatoni aila tsi dokdok sin iesan iaa, a malen mu ta suei atatoni iaa, o nawe saa ia ta suei atatoni iaa, a malen mu ta suei atatoni iwaa ta tulen iaa. Amuina saa ia ta adokdoki labatina gim araraa, a ies lot lalon no matan Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon asaaiti, “Manmanel, giem tii lasi iexa taamat ta tulen atsuulngi no salawa sin iesaam ma giem xonon ngali tilbanti amuina ia a xap ina gita.” ");
INSERT INTO ncf_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Iesu a xisi, “Gim nangaam tilbanti, nawe saa ia ta xap epuske mii gim, ia mu ina gim.” ");
INSERT INTO ncf_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Leng a se atat ngali Iesu naba se laa balalangit, o ga adodo watwat ngali laa Jerusalem. ");
INSERT INTO ncf_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","A es laa lalon xolot Samaria ma ga tulen no ngutsu ngali asaaiti no inaman lalon biexaa xobel ngali di na taxaaturung ngali xan tsinap Iesu. ");
INSERT INTO ncf_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Oro, no inaman atia di xap sirawaa ia, amuina di se atii we Iesu naba laa Jerusalem. ");
INSERT INTO ncf_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Biaa xan no tsi asasing, Jeims ma Jon delu ta alongmen abala delu suk atsuraa Iesu, “Orong, u saan ngali gelu na asaaiti Moroaa ngali na tulen ie xaal balalangit ngali le xosor atsoti di?” ");
INSERT INTO ncf_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Oro Iesu aputsi ma ga imii delu, ");
INSERT INTO ncf_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ma di ga se laa sin biexa xobel xaatsap. ");
INSERT INTO ncf_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Biaa di ta lo eses laa lalon sal o iexa taamat ga asaaiti Iesu, “Iaa ba amusili iu sin no xolot araraa u ba ta laa sin.” ");
INSERT INTO ncf_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Iesu a xisi, “No xapunakok di ie mat ma no maan di ta lolo lapalaa di ie uni, oro xan Tsi Taamat a xap xa xolot ngali atetei xuan.” ");
INSERT INTO ncf_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ga sebula asaaiti iexa taamat, “U na amusili iaa.” Oro, iwaa taamat a xisi, “Orong, u na setauan poroklii iaa ngali iaa ba laa punami nugu mom.” ");
INSERT INTO ncf_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Iesu ga paare ngali, “Papaalii no minet di na punami xadi no minet tsaa, oro u na laa ma baais taman xan Maradaan Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ma iexa taamat a sebula paare, “Iaa ba amusili iu, Orong, maarang mu iaa na ben mula ngali laa xubalaasaai sin nugu matenaanua.” ");
INSERT INTO ncf_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Iesu a xisi, “A xap xa taamat na taxaana ios ngali tsupki pula o ga nanen mula, a xap pupua ngali inatalil lalon xan maradaan Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Mulina abia, Orong ga axilangi no sangaul apaasaalua ma ga laa lua ina biexaal bula ina xan no tsi asasing. Ma ga tulen alualua ina di, laamuangen ia sin no xobel araraa, Iesu naba ta laa lalon. ");
INSERT INTO ncf_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Iesu asaaiti di, “No uma ngali tatat a se malisa, oro a xap xaa daan untinaxaa. Gim na ningi Orong ina tatat uma ngali naba tulen no untinaxaa laa lalon uma ngali alet luxaal. ");
INSERT INTO ncf_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Laa! Iaa tulen gim malen no sipsip dokdok ngali laa labatina no xapunakok. ");
INSERT INTO ncf_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nangaam adi xa paakpaak dokdok o xa tutuel lot o xaa bubut ma gim nangaam suei atatoni xaal lalon sal. ");
INSERT INTO ncf_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Biaa gim ta tsiga lalon xa anua, gim na setauan paare weaatalaa, ‘Malina na manman labatina abala anua.’ ");
INSERT INTO ncf_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nawe xa taamat ina malina ia, biaa malina naba iaawis papan ia, o nawe a xap, biaa malina naba mula xaalame sin gim. ");
INSERT INTO ncf_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Gim na manman lalon abia anua. Gim na ngani ma nunngi sen mat maarang di ta tabali gim taman, amuina untinaxaa naba adi bula xan iliil. Gim nangaam tsuul tsiga lalon no anua. ");
INSERT INTO ncf_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Biaa gim ta tsiga lalon xa inaman laba ma di suei atatoni gim, ngani samaarang di ta taxaaturungi ngali gim. ");
INSERT INTO ncf_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Gim na atoaa biaa di ta ie minet ma gim na asaaiti di: ‘Xan Maradaan Moroaa a se atataen gim.’ ");
INSERT INTO ncf_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Oro biaa gim ta tsiga lalon xa inaman laba ma di ga xap sirawaa gim, gim na laa lalon no sal ma gim na paare, ");
INSERT INTO ncf_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘No kuku ina nagim inaman laba biaa ta tso wat sin no xaden giem, giem sebula panlii sin gim. O gim na se atii: Xan Maradaan Moroaa a se atat.’ ");
INSERT INTO ncf_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Iaa asaaiti gim, sin abia leng naba axaau buxa tsaa sin Sodom ngen abia inaman laba. ");
INSERT INTO ncf_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Xariin xirabas sin gim no Korasin ma xariin xirabas sin gim no Betasaida! Amuina nawe no xariin axixila tii tsap lalon nagim no inaman laba. O nawe balawaa no xariin axixila tii se tsap Taia ma Sidon, di ba se puxisbal tsaa. Di ba se alen no pu laplap tsaxa ma di na patsaa di taman pit papan no xuan di. ");
INSERT INTO ncf_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Oro naba axaau buxa tsaa ngali no inaman Taia ma Sidon sin leng ina ininte ngali gim. ");
INSERT INTO ncf_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","O gim no inaman Kaperanaam, gim we di ba alet laangen iesan gim laa lapalaa balalangit? Asuk xap! Di ba lii laangen gim lalon lis. ");
INSERT INTO ncf_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Nawe saa ia ta lolong sin gim, a malen mu ta lolong sin iaa o nawe saa ia ta palolii gim, a palolii iaa bula, ma nawe saa ia ta palolii iaa, a palolii aia bula ta tulen iaa.” ");
INSERT INTO ncf_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","No sangaul apaasaalua ma ga laa lua ina no tsi asasing di se laa mula taman taton di ga we, “Orong, no salawa di lolong sin giem biaa giem ta putsangi iesaam.” ");
INSERT INTO ncf_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","A xisi, “Iaa lasi Saatan ta xol xaal balalangit malen tsilatsila. ");
INSERT INTO ncf_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Lasi, iaa se tali banam sin gim ngali xutsili no tsitsi ma no sogomare ma ngali le aiepatsaa xan xoror matenkorot. A xap xawas naba xosor atsoti gim. ");
INSERT INTO ncf_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Oro gim nangaam taton sin no salawa tsaxa di ta lolong sin gim, gim na taton malen no iesan gim di se atalaa balalangit.” ");
INSERT INTO ncf_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Sin abia aua Iesu asuk us taman taton sin Nantanua Pat ga we, “Iaa paʼii iu, nugu Mom, Orong ina balalangit ma balan pula, amuina u ta unngena abala no maarang sin no unsinaae ma sin no inaman di ta adi xariin asasing o u ga asen abala no maarang sin no tsi dokdok. Asuk so, nugu Mom, u xosaraa abala amusili num sirsiir. ");
INSERT INTO ncf_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Nugu Mom a se tali no mat maarang araraa susugu, o a xap xa na atii saa aia Tsi, oro Xan Mom mu, ma a xap xa na atii saa aia Mom, oro Xan Tsi mu ma ngali biaa di, Xan Tsi ta axilangi ngali atsapngen ia.” ");
INSERT INTO ncf_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Iesu agar laa sin xan no tsi asasing ma ga asaait axuina di, “Moroaa atatoni abia no mat ta lasi samaarang gim ta se lasi. ");
INSERT INTO ncf_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Amuina no propet ma no king, di tii suk saan ngali lasi sawe gim ta lasi oro di xap lasi, ma alongmen sawe gim ta alongmen, oro di tii xap alongmen no.” ");
INSERT INTO ncf_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Sin biexa leng iexa unsinaae ina lo a til lapalaa ga xonon Iesu taman abala atsutsura ga we, “Unaasasing, iaa na suk xosaraa sen maarang xaawe ngali adi abia tino laaliu?” ");
INSERT INTO ncf_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","A xisi, “Di atalaa sawe lalon xan lo Moses? U adi sen mat sinaae sin abia no lo?” ");
INSERT INTO ncf_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","A xisi, “U na titii Orong iwaa num Moroaa taman num butsa araraa, nantanuaam, ma num watwat, ma num adodo.” Ma “U na suk titii no turaam, malen u ta titii iu tsaa.” ");
INSERT INTO ncf_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Iesu ga xisi, “U tii suk xisi axaautsi. U na xosaraa abala ngali u ba adi tino laaliu.” ");
INSERT INTO ncf_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Oro a we na asen we a tutiik tsaa ma ga atsuraa Iesu, “Ma saa aia turaaga?” ");
INSERT INTO ncf_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iesu a xisi, “Iexa taamat a es xaal Jerusalem ngali laa lapula Jeriko, o no unpulapula di tsilriti ma di ga taterlii xan no uga araraa. Di suk sas atsoti ma di ga sol papaalii lapula ta se met xiirkires. ");
INSERT INTO ncf_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Sin abia leng bula, iexa unsausawit amusili abia uk sal laa lapula. Biaa ta le lasi iwaa taamat ta matmatuul asuk es xatsep laa sin gelgel ina sal ma ga es liu. ");
INSERT INTO ncf_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ma iexa Liwai a es xaalame bula lalon abia uk sal, a le lasi aia taamat ta matmatuul ma ga sebula es xaa sin gelgel. ");
INSERT INTO ncf_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","O iexa taamat in Samaria a se es xaalame sin abia uk sal. Biaa ta lasi aia taamat ta matmatuul asuk titii buxaai. ");
INSERT INTO ncf_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","A es laa sangan, ga aruati daanwe ma waain sin xan no toto ma ga pitsi no. Atsaxei taamat laa papan xan donki ma ga giwaa laa lalon anuen xibong ma ga tilaamamil sin. ");
INSERT INTO ncf_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Sin leng papan, a tali nen xuxute ta lua sin untilaamamil ina anuen xibong ga asaaiti, ‘U na tilaamamil sin, o nawe u lii aisa lapalaa papan abala xuxute ngali tilaamamil sin aila taamat, iaa ba xisi sin leng iaa ba ta laa mula.’ ");
INSERT INTO ncf_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Saa ina abala tuu taamat xan turan so, iwaa taamat no unpulapula di ta tsaapi?” ");
INSERT INTO ncf_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Unsinaae ina lo a xisi, “Iwaa taamat ta tali xan biirbirum sin.” Iesu ga asaaiti, “U na laa ma u na xosaraa wenangen atia.” ");
INSERT INTO ncf_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Iesu mii xan no tsi asasing di eses laa ma di ga se tsap lalon biexa xobel, o iexa aina iesan Maata, ga sirawaa Iesu laa tatan. ");
INSERT INTO ncf_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tawaneina Maata, ilaa Maria, a xale sangan Orong ma ga lolong sin Iesu ta papaare. ");
INSERT INTO ncf_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Maata ga xap taton amuina no maarang tsaa biaa ngali taxaaturungi no. O Maata ga laa sangan Iesu ga paare, “Orong, num sen adodo ngali tawaneina iaa ta papaalii iaa xasinge ngali xosaraa abala no tinaxaa? Asaaiti ngali naba tiltsomi iaa!” ");
INSERT INTO ncf_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Orong ga xisi, “Maata, Maata, u suk adodo buxa ma lolbiir ngali no maarang ta xudu, ");
INSERT INTO ncf_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","oro was ta xuuk mu gita na saan ngali. Maria a se intentsoli abia maarang ta suk axaau, ma naba xap xa na saali tsaa sin.” ");
INSERT INTO ncf_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sin biexa leng, Iesu a ningning lalon biexa xolot. Biaa ta se ningning xap, iexa ina xan no tsi asasing ga paare, “Orong, u na asingan giem ngali ningning malen Jon tii asingan xan no tsi asasing.” ");
INSERT INTO ncf_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ga paare ngali di, “Gim na ningning weaatalaa, “ ‘Mom, giem nen xilalaa iesaam a pat. Num Maradaan na xaalame. ");
INSERT INTO ncf_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","U na tabali giem sin no leng xuxuuk taman tsoki. ");
INSERT INTO ncf_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Adodolii nagiem no namaang tsaxa, ngali giem bula, giem ba adodolii abia di, di ta xosaraa namaang tsaxa ngali epuske mii giem. Ma nangaam laamuangen giem laa sin xonkonon.’ ” ");
INSERT INTO ncf_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Mil ga paare ngali di, “Nawe xa ina gim a laa sangan turan labatina bing ga paare, ‘Turaaga, u na ben tali xaa tsoki na tuul sin iaa, ");
INSERT INTO ncf_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","amuina iexa turaaga a xaalame sangan iaa sin biexa ines o ga xap xawas ngali tabali taman.’ ");
INSERT INTO ncf_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“O nawe iwaa turaam naanua, naba xisi, ‘Nangaam le angaasen iaa, mat a se tsaxil o iaa urange bula mii nugu no tsi. Iaa xap pupua ngali tapaas bula ngali tali xawas sin iu.’ ");
INSERT INTO ncf_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Iaa asaaiti gim, biaa naba ta xap pade ngali tali tsoki sin ia, amuina ia turan, oro amuina taamat a lo ningningi ia tsaa, naba pade ma tali tsoki sin ia. ");
INSERT INTO ncf_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ma iaa ga paare sin gim, gim na atsura ngali gim ba adi, gim na tsatsel ngali gim ba tatanginai, gim na pipidi ngali mat naba tsalel ngali gim. ");
INSERT INTO ncf_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Amuina no inaman araraa di ta atsutsura, di ba adi, iwaa xa ta tsatsel, naba tatanginai, ma iwaa xa ta pipidi, mat naba tsalel ngali. ");
INSERT INTO ncf_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Saa ina gim no mom, nawe num tsi a atsura ngali xa xoo, o u ga tali tsitsi sin? ");
INSERT INTO ncf_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O nawe, atsura ngali xa xatuul o u ga tali sogomare sin? ");
INSERT INTO ncf_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Oro gim no untsaxa, gim atii ngali tali xaa tinabel axaau sin nagim no tsi. Nagim Mom tade balalangit a mamainaang buxa ngen gim no inaman. Asuk atixi ngali naba sen tabiel wenangen xan no tsi. Naba tali aia Nantanua Pat laa sin abia di, di ta atsuraa ia ngali.” ");
INSERT INTO ncf_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Mil Iesu a saali salawa tsaxa sin taamat ta ngusbong. Biaa iwaa salawa tsaxa ta poroklii aia taamat, asuk atiltsoli papaare ma biaa malep di ga suk tunga. ");
INSERT INTO ncf_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Oro biexaal ina di, di paare, “A saali no salawa tsaxa taman xan xoror Belsabap, iwaa lalaamua ina no salawa tsaxa.” ");
INSERT INTO ncf_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","O biexaal di xonon Iesu ma di ga atsuraa ngali xa axixila in balalangit. ");
INSERT INTO ncf_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Iesu a se atixi xadi no adodo ga paare ngali di: “Xa Maradaan di ba esas engen di tsaa, ma na xosor atsoti di, ma no matenaanua di ba esas engen di tsaa ma di ba xol. ");
INSERT INTO ncf_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nawe Saatan a esas mii xan salawa tsaxa tsaa, naba sen tilwatwat we abia xan maradaan? Iaa paare weaatala amuina gim paare we, iaa saali no salawa tsaxa taman xan watwat Belsabap. ");
INSERT INTO ncf_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","O nawe iaa saali no salawa tsaxa taman xan watwat Belsabap, o nagim no tsi asasing di saali no salawa tsaxa taman xan watwat saa? Biaabi, di ba tsap num no unininte. ");
INSERT INTO ncf_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Oro nawe iaa saali no salawa tsaxa taman xan watwat Moroaa, asen xan Maradaan Moroaa a se xaalame labatina gim. ");
INSERT INTO ncf_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Nawe xa taamat watwat asuk xoxo axaau sin xan anua tsaa, xan no mat maarang naba xap xa na pulaxi no. ");
INSERT INTO ncf_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Oro nawe iexa taamat watwat buxa a esas mii ma ga aiepatsaa ia, naba adi xan no mat bakbaxil ina inesas, biaa no ta taalnge sin, ma na exasen xan no mat maarang ina anua. ");
INSERT INTO ncf_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Nawe xa a xap manman mii iaa, a epuske mii iaa. O nawe xa a xap tiltsomi iaa ngali axumuli xan no inaman Moroaa, a xalel tsaalen di. ");
INSERT INTO ncf_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Nawe salawa tsaxa atsuul alen xa taamat, a xaa sol laa lalon no xolot pura ngali iaawis. O nawe a xap tatanginai xa xolot. Mil naba we, ‘Iaa ba mula laa lalon abia anua iaa tii papaalii.’ ");
INSERT INTO ncf_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Biaa nawe a le tatanginai anua di ta se rii ma di ga se xosor amamainaangi, ");
INSERT INTO ncf_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","naba sebula mula ngali laa giwaa xaa salawa tsaxa na apaasaalua biaa di ta morokon buxa ngali le manman. Ma xan tino iwaa taamat naba suk tsaxa buxa ngen tiwaa setauan.” ");
INSERT INTO ncf_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Biaa Iesu ta lo papaare tsaa iexa aina lalon abia malep asuk ilei xuupkup weaatalaa, “Moroaa atubudaani iwaa nagaa ta taxaali iu ma ga tilaamamil susum.” ");
INSERT INTO ncf_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Iesu ga xisi, “Moroaa naba atubudaani abia di, di ta alongmen xan totore ma di ga long amusili.” ");
INSERT INTO ncf_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Biaa malep a lo tsap bukbuxa o Iesu ga we, “Balawaa nan ul morokon. A atsura ngali xa axixila xoror, oro naba xap xa bula na tali, biaa mu axixila ina Jonaa. ");
INSERT INTO ncf_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonaa atsap malen axixila ngali no inaman Niniwe, o Xan Tsi Taamat bula naba tsap axixila sin abala nan ul. ");
INSERT INTO ncf_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Iwaa Kwin in nan no paxel naba til nan ininte mii no taamat sin abala nan ul ma atuti mamaet sin di; ia tii xaal palpalaa sin xapkap ina balan pula ngali alongmen xan sinaae Solomon, ma talaawaa iwaa xa ta lot buxa ngen Solomon ila se. ");
INSERT INTO ncf_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","No taamat in Niniwe di ba til nan ininte mii abala nan ul ma di na atuti di; amuina di tii se puxisbal sin xan no babaais Jonaa, o talaawaa iwaa xa ta suk lot buxa ngen Jonaa ila se. ");
INSERT INTO ncf_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Gita xap xaa arar laam ma axuina lalon xa xolot xuxii o paina xa xiis, a xap! Gita xaa ataxiwaa sin niaan taktaxiu ngali biaa di, di ta tsiga lalon anua di ba lasi abia laam. ");
INSERT INTO ncf_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","No matan gim, biaa laam ina nagim no isuaan. O nawe no matan gim a axaau no isuaan gim naba suk us taman tsilatsila o nawe no matan gim atsaxa, biaa no isuaan gim bula naba suk us taman lodo. ");
INSERT INTO ncf_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","U na tilaamamil axaau ngali biaa rarar lalon iu na xap lodo. ");
INSERT INTO ncf_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Biaabi, nawe no isuaam a auus taman rarar ma a xap xa xolot na lodo, rarar naba tsilangi no xolot araraa malen abia rarar ta tsila papan iu.” ");
INSERT INTO ncf_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Biaa Iesu ta se papaare xap, iexa Paarasi a se atsuraa ngali laa angen mii lalon xan anua. Iesu a se laa tsotso ngali angen. ");
INSERT INTO ncf_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Oro iwaa Paarasi, a lasi Iesu ta xap guraʼi no liman setauan ngali angen ma ga suk tunga. ");
INSERT INTO ncf_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mil Orong ga paare ngali ia, “Gim no Paarasi gim guraʼi lokobel ina no sobuk ma no palet, o lalon asuk us taman namaang ina angen tsaxa ma namaang morokon. ");
INSERT INTO ncf_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Gim no untangtangabaa! Iwaa Orong a xap xosaraa lokobel ma lalon bula? ");
INSERT INTO ncf_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Oro gim na tabali no muun was, ngalibi no maarang araraa naba mixat ngali gim. ");
INSERT INTO ncf_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Xariin xirabas sin gim no Paarasi! Gim tali sin Moroaa axuuk ina sangaul ina nagim no lawin ie ta tso mamainaang, ma biexa mat laxen tubatuba nan uma, Oro gim adodolii ininte tutiik ma xan titii Moroaa. Gim na watwat ngali xosaraa balawaa no namaang, ma gim nangaam poroklii biaa xaa lo bula. ");
INSERT INTO ncf_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Xariin xirabas sin gim no Paarasi! Gim saan ngali no xalkale lot lalon no anua sausawit ma ngali no inaman, di ba suei atatoni gim sin no xolot susune. ");
INSERT INTO ncf_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Xariin xirabas sin no Paarasi! Gim malen abia no io ina minet ta xap xa axixila papan no ma no inaman di eses papan di ma di ga xap atii.” ");
INSERT INTO ncf_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Iexa unsinaae ina lo a xisi ia, “Unaasasing, biaa u ta paatina abala no maarang a malen u amangieli giem.” ");
INSERT INTO ncf_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Iesu a xisi, “Gim no unsinaae ina lo bula, xariin xirabas sin gim! Gim tali no xariin mamaxet papan no inaman, o gim xap pupua ngali tiltsomi di taman xa kakaalis na xuuk ngali atsaxei abia no xariin mamaxet. ");
INSERT INTO ncf_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Xariin xirabas sin gim, gim xaii no lia pupuna ngali punami no propet in ti, biaa nagim no iaaiaa di tii sas amantei di. ");
INSERT INTO ncf_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Gim asaait leng so taman abia, ngali asen malen gim til mii nagim no iaaiaa we di axaau. Di ta sas amantei no propet ma gim ga atilngi xadi no lia pupuna. ");
INSERT INTO ncf_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Amuina sin abala, xan sinaae Moroaa a paare, ‘Iaa ba tulen no propet ma no aposal laa sin gim, oro, gim ba sas amantei di o biexaal gim ba tali mamaet sin di.’ ");
INSERT INTO ncf_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Biaabi gim nan ul in atalaa gim ba til nan ininte ngali xadi no tino no propet araraa gim ta sas amantei di sin atiltsoli ina abala xolkolmoxo pupua talaawaa. ");
INSERT INTO ncf_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Atiltsoli sin xan dal Abel ma laa sin xan dal Sekaraia, iwaa di tii sas amantei labatina ibe tsutsungit ma Xan Anua Moroaa. Iou iaa asaaiti gim, balawaa nan ul, di ba adi xariin ininte ngali di se araraa. ");
INSERT INTO ncf_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Xariin xirabas sin gim no unsinaae ina lo, amuina gim se tsaxil xaale mat ina sinaae sin Moroaa, gim tsaa gim ba xap tsigaii ma gim ga tilkaali abia di, di ta we na tsiga.” ");
INSERT INTO ncf_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Biaa Iesu ta papaalii abia xolot, no Paarasi mii no unaasasing ina lo, di atiltsoli ngali epuske buxa mii ia, ma tiirik apopogoroi taman no daan atsutsuraa, ");
INSERT INTO ncf_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","amuina di liliisi ngali longmien nawe a paatina xa totore ta tsaxa. ");
INSERT INTO ncf_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Biaa leng, xariin malep ina tausen di tii exumule ngalibi di ba se es butbutili di xuxuuk. Iesu ga setauan paare ngali xan no tsi asasing, “Gim na xoxo ngali epuske ngali xadi iis no Paarasi biaa no xalam lua. ");
INSERT INTO ncf_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Gim nangaam malen di, amuina no maarang araraa no inaman di ta baaii, Moroaa naba asen no. Naba alengi no maarang araraa biaa di ta xonon ngali axuina. ");
INSERT INTO ncf_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Sen totore gim ta paatina lalon lodo, di ba alongmen nan leng. Ma sen totore gim ta burburik taman naanua, di ba babaais taman lapalaa papan unga ina anua. ");
INSERT INTO ncf_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“No turaaga, gim nangaam mataatina biaa di, di ta pupua ngali sas amantei pakpak, ma mulina abia di ba xap xosaraa xawas bula. ");
INSERT INTO ncf_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Oro iaa ba asen sin gim saa, gim na mataatine: Mataatine Moroaa, iwaa naba ta sas amantei pakpak, ma mulina a ie xoror ngali lii gim laa lalon ie suaamsuaam in Edes. Iou! Iaa asaaiti gim, gim na mataatine ia. ");
INSERT INTO ncf_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Alima no xamkabalila di sune taman no ngali nen xuxute alua, oro Moroaa a xap adodolii xa ina abia no maan dokdok. ");
INSERT INTO ncf_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Biaa no ul bula papan xuaam Moroaa a se iesei no. Gim nangaam mataa, Gim lot buxa sin xan adodo Moroaa ngen no daan xamkabalila. ");
INSERT INTO ncf_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Iaa asaaiti gim, iwaa ta papaare leng taman iaa pan no matan no inaman, Xan Tsi Taamat naba papaare leng taman ia pan no matan xan no angelo Moroaa. ");
INSERT INTO ncf_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Oro saa ia ta palolii iaa lalon no matan no inaman iaa ba palolii ia bula lalon no matan xan no angelo Moroaa. ");
INSERT INTO ncf_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ma no inaman araraa biaa di ta paare tsaxa ngali Xan Tsi Taamat, Moroaa naba adodolii ia, oro saa ia ta rereti Nantanua Pat, Moroaa naba xap adodolii ia. ");
INSERT INTO ncf_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nawe di tali gim laamuaan no Anua Sausawit ma xadi banam no Gentail, gim nangaam lolbiir ngali tilkaali gim tsaa, o ngali paatina sa. ");
INSERT INTO ncf_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Sin abia aua, Nantanua Pat naba asingan gim ngali paatinai sa.” ");
INSERT INTO ncf_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Iexa taamat lalon abia malep a paare ngali ia, “Unaasasing, u na asaaiti turamasen iaa ngali naba exasen no maarang labatina gelulu, biaa gelulu ta momtsoli.” ");
INSERT INTO ncf_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Iesu a xisi, “Saa axilangi iaa ngali ininte o xosaraa malina labatina gululu?” ");
INSERT INTO ncf_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mil ga paare sin di, “Gim na xoxo sin no mat laxen namaang ina lulut! Xan tino taamat a xap manman sin xan no minaas ta tapkina.” ");
INSERT INTO ncf_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ma ga asaaiti di taman abala totore puapua, “Lalon xan uma iexa uniewas, no mat maarang araraa asuk waalii no daan luxaal axaau. ");
INSERT INTO ncf_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Adodo sin ia tsaa ga paare, ‘Iaa ba se xosaraa sa? A xap xa xolot ngali iaa ba aturungi nugu no luxaal.’ ");
INSERT INTO ncf_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Mil ga paare, ‘Iaa ba xosaraa abala. Iaa ba beklii nugu niaan atuturung dokdok, o iaa na axosngi xa anua lot ngali iaa ba aturungi abia nugu no luxaal ma no maarang axaau lalon. ");
INSERT INTO ncf_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ma iaa ba paare lalon nugu butsa, “U se taxaaturungi no mat maarang axaau ngali manman sin abala no daan miet talaa xaalame. Talaawaa u ba se iaawis! U ba angen, nun, ma u na lo tataton.”’ ");
INSERT INTO ncf_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Oro Moroaa asaaiti ia, ‘Iu tangtangabaa! U ba met talaawaa nabing mu. O saa naba se adi abia no mat maarang iu ta se taxaaturungi no ngali iu tsaa?’ ");
INSERT INTO ncf_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Balawaa mat maarang a xaa tsap sin xa ta xaa taxaaturungi no mat maarang ngali ia tsaa, oro ga xap iewas sin Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Mil Iesu ga paare sin xan no tsi asasing, “Biaabi iaa ga asaaiti gim, gim nangaam lolbiir ngali nagim tino sawe ngali ngani o ngali no isuaan gim, sawe gim ba ta alen. ");
INSERT INTO ncf_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tino a lot buxa ngen luxaal, ma pakpak a lot buxa ngen uga. ");
INSERT INTO ncf_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Gim lasi no xotkot. Di xap soksok o di xap ie niaan atuturung, oro Moroaa a tamtabali di. Moroaa adodo aloti gim ngen abala no maan. ");
INSERT INTO ncf_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Saa ina gim sin namaang ina lolbiir naba pupua ngali asumaa xa aua na xuuk sin xan tino? ");
INSERT INTO ncf_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Amuina gim xap pupua ngali xosaraa xa maarang dokdok, ngalisa gim ta lolbiir ngali abala no daan maarang? ");
INSERT INTO ncf_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Gim na lasi no nanaal in lauteng di ta tsik. Di xap taktaxaa o ili xaa was. Oro iaa asaaiti gim, Solomon lalon xan no matmirmir araraa tii rusarusa malen abala no nanaal. ");
INSERT INTO ncf_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nawe biaa Moroaa ta sen amatmirmiri we no palis in lauteng, talaawaa di manman o nowa di ga ritlii ma di ga lii lalon ie. Aisa mu Moroaa ta amatmirmiri gim ngen abala no nanaal? Ngalisa nagim tinaalnge ta dokdok? ");
INSERT INTO ncf_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ma gim nangaam adodo ngali samaarang gim ba ta ngani ma nunngi; gim nangaam lolbiir ngali no. ");
INSERT INTO ncf_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Biaa no muun taltaalnge lalon xolkolmoxo di ba sol amusili no mat maarang, oro nagim Mom atii samaarang u ta saan ngali. ");
INSERT INTO ncf_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Oro gim na tsalei xan Maradaan, ma balawaa no mat maarang araraa naba tali sin gim bula. ");
INSERT INTO ncf_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Gim nangaam mataa. Nugu no sipsip dokdok, nagim Mom asuk taton ngali tali xan Maradaan sin gim. ");
INSERT INTO ncf_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Gim na sune taman nagim no mat maarang ma gim na tabali no muun was. Gim na adi xaa paakpaak biaa naba ta xap tater, biaa naba ta man axaau tile balalangit, ma biaa no maarang axaau naba ta xapkap ma biaa no unpulapula di ba ta xap xaalame atataaen ma no ibaiba di ba xap xosor atsoti no. ");
INSERT INTO ncf_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Amuina sen xolot u ta aturungi num no tang tia, num butsa naba manman sin abia xolot bula. ");
INSERT INTO ncf_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Gim na rusarusa taxaaturung ngali taxaa ma nagim no laam na lo rarar, ");
INSERT INTO ncf_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","malen no untutule di ta liiliisi xadi manmanel ngali mula xaal sin luxaal ina alaba, ngalibi biaa naba ta xaalame ma na pipidi, di ba isagaa mu ngali tsalali mat ngali ia. ");
INSERT INTO ncf_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Atubudaani abia no untutule xadi manmanel ta le tatanginai di ta xoxo biaa naba ta xaalame. Iaa asaaiti iu taman so, naba taxaaturungi ia tsaa ngali tabiel, naba arusarusai ia tsaa ngali tabiel, ma naba atsotsoi di papan ibe ma naba xaalame ngali le tabali di. ");
INSERT INTO ncf_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Atubudaani abia no untutule xadi manmanel ta tatanginai di ta taxaaturung, nawe atsap labatina bing o lawaareng bingbing. ");
INSERT INTO ncf_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Oro gim na leng sin abala: nawe tapkina anua atii sen aua unpulapula naba ta xaalame, naba xap papaalii anua ngali di ba pula lalon. ");
INSERT INTO ncf_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Gim bula, gim na taxaaturung, amuina Xan Tsi Taamat naba laa xaalame sin xa aua, biaa gim ta xap atii.” ");
INSERT INTO ncf_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita atsuraa Iesu, “Orong, u lii abala totore puapua ngali giem no tsi asasing o ngali no inaman araraa?” ");
INSERT INTO ncf_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Orong ga xisi, “No saa abia di no untinaalnge ma unsinaae, no saa abia, manmanel ta axilangi di ngali tilaamamil sin xan no untutule ngali tabali di taman xuxute ngali iil luxaal sin leng so ina? ");
INSERT INTO ncf_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Atubudaani aia untutule iwaa xan manmanel ta tatanginai ta xosaraa tinaxaa biaa ta mula. ");
INSERT INTO ncf_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Iaa asaaiti gim taman so, manmanel naba axilangi aia untutule ngali tilaamamil sin xan no mat maarang araraa. ");
INSERT INTO ncf_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Oro nawe iwaa untutule adodo lalon xan butsa, ‘Nugu manmanel naba xap laa mula isagaa,’ ma ga tiltsoli ngali tsaapi no untutule taamat ma aina, a lo angangen, nunun daan watwat ma ga gogo. ");
INSERT INTO ncf_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Xan manmanel aia untutule naba xaalame sin abia leng biaa naba ta xap atii ma sin abia aua. Xan manmanel naba sas atsoti ia ma na tsek tali xaka xolot mii abia no muun taltaalnge. ");
INSERT INTO ncf_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Iwaa untutule ta atii xan sirsiir xan manmanel ma ga xap taxaaturung o ga xap xosaraa sawe xan manmanel ta saan ngali, xan manmanel naba suk tsatsek buxaai. ");
INSERT INTO ncf_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Oro iwaa xa ta xap atii sawe xan manmanel ta saan ngali ma ga xosaraa no maarang ngali atsapngen sosong di ba tsaapi adokdoki mu. Biaa Moroaa ta se tabiel buxaai iu, iu na suk taxaa axaau taman ngali ia ma biaa Moroaa tii se taalnge so sin iu, u na taxaa laa sin ia taman soina.” ");
INSERT INTO ncf_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Iesu ga asaait, “Iaa se xaalame ngali tali ie lelep papan balan pula o iaa ga saan ngali we a se atiltsoli tsaa. ");
INSERT INTO ncf_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Oro iaa na adi biexa mat laxen axaxadaan biaa di ba ta axaxadaani iaa taman ma talaawaa iaa ie xaraxin lolbiir pupua sin naba ta xap. ");
INSERT INTO ncf_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Gim adodo we iaa xaalame ngali tali malina sin balan pula? Asuk xap! Iaa asaaiti gim, iaa xaalame ngali tsekxirixi gim. ");
INSERT INTO ncf_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Xaal talaawaa, nawe alima lalon matenaanua axuuk, di ba tsekxirixi di tsaa, a tuul di ba epuske mii alua ma alua di ba epuske mii a tuul. ");
INSERT INTO ncf_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Iaa ba tsekxirixi di, mom naba epuske mii xan tsi, ma tsi naba epuske mii xan mom, ma nagaa naba epuske mii xan tsaana, tsaana naba epuske mii xan nagaa, nagaa naba epuske mii xan iaaiaa aina, ma xan iaaiaa aina naba epuske mii nagaa.” ");
INSERT INTO ncf_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iesu asaaiti xumul, “Nawe gim lasi no xelangit talaa lodo xaal nan no tudaan, sauna mu gim ba we, ‘Naba se usa,’ ma naba suk usa. ");
INSERT INTO ncf_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ma nawe amaal xaal lalon nan no paxel, gim we, ‘Pal naba lelep,’ ma ga suk tsap we atia. ");
INSERT INTO ncf_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Gim no xalam lua! Gim atii ngali paate alengi xan nanen balan pula ma no balalangit. Ngalisa gim ga xap pupua ngali nan xilalaa balawaa leng? ");
INSERT INTO ncf_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ngalisa gim ta xap ininte ngali gim tsaa ngali sawe ta tutiik? ");
INSERT INTO ncf_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Biaa u ta lo laalaa mii num matenkorot ngali laa sin unininte, u na xonon ngali ukbal mii ia lalon sal o naba soro tataii iu laa sin unininte ma unininte naba tali iu laa sin asilalxadek, ma asilalxadek naa lii iu laa lalon anua lodo. ");
INSERT INTO ncf_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Iaa asaaiti iu, u ba xap pupua tsaa ngali tsuul til sin u ba ta xiis araraai num nen xapkap ina toia.” ");
INSERT INTO ncf_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Sin abia leng, biexaa inaman di le tsap ma di ga le asaaiti Iesu taman biexaa inaman Galili biaa Pailat ta tulen no unmakmaxil ngali laa sas amantei di biaa di ta tali xadi no tinabel laa sin Moroaa. ");
INSERT INTO ncf_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Iesu ga xisi di, “Gim adodo we balawaa no inaman Galili no untsaxa buxa ngen biexaa inaman Galili amuina di ta ilua weaatia? ");
INSERT INTO ncf_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Iaa asaaiti gim, asuk xap! Nawe gim ba xap puxisbal, gim bula gim ba suk ilua. ");
INSERT INTO ncf_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","O biaa sangaul ma ga laa paasaatuul ina inaman, di ta met lalon xariin anua ta dis laa lapalaa biaa tii xol patamina di tia Jerusalem lalon pu xobel dokdok Silom. Gim adodo we di suk tsaxa buxa ngen abia no inaman Jerusalem?” ");
INSERT INTO ncf_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Iaa asaaiti gim, asuk xap! Oro nawe gim ba xap puxisbal, gim bula gim ba suk met. ");
INSERT INTO ncf_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Mil Iesu ga asaaiti di taman abala totore puapua: “Iexa taamat asoxaa xan ie fik lalon xan uma waain o mil ga laa ngali nanen ngali xaa waawaan papan, o ga xap tatanginai xaa waawaan. ");
INSERT INTO ncf_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","A laa, ga asaaiti aia untilaamamil sin abia uma waain, ‘A se tuul no miet abala iaa ta lo xaxaalame ngali nanen ngali xaa waawaan papan abala ie fik o iaa ga xap tatanginai xaal. U na tal lii! Ngalisa ta se ngen araraai luxaal ina pula?’ ");
INSERT INTO ncf_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Iwaa untilaamamil ina uma a xisi, ‘Orong u na papaalii xa miet na xuuk bula. Iaa ba setauan tsup ulti muina ie ma aturungi taxen bulmakau. ");
INSERT INTO ncf_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nawe naba waa sin abala miet lapalaa, biaa naba axaau! O nawe naba xap, iaa ba tal lii.’ ” ");
INSERT INTO ncf_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sin biexa leng Saabat, Iesu asingan no inaman lalon biexa anua sausawit. ");
INSERT INTO ncf_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Lalon abia xolot, iexa aina, salawa tsaxa a xosaraa ga suk taaluduk sin no miet ta sangaul ma ga laa paasaatuul. Asuk tudu liu ma ga xap pupua ngali atutiki taaluna. ");
INSERT INTO ncf_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Biaa Iesu ta lasi ia, asuk ilei xaalame sangan ma ga we, “Aina, talaawaa u se leiwaa sin num minet.” ");
INSERT INTO ncf_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Mil ga taana taman no liman ma a xap sauna mu, ga atutiki taaluna ma ga paʼii Moroaa. ");
INSERT INTO ncf_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Lalaamua ina anua sausawit asuk magaa amuina Iesu atoaa aia aina sin leng Saabat, ma ga asaaiti no inaman, “No leng apaasxuk ngali taxaa, gim na xaalame ngali di ba atoaa gim sin abia no leng, a xap sin leng Saabat.” ");
INSERT INTO ncf_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Orong a xisi ia, “Gim no xalam lua! Sin no leng Saabat gim xaa laa lubati nagim no bulmakau o donki, xaal lalon anuen bulmakau ma gim xaa laamuangen di laa lalon no daan ngali nun. ");
INSERT INTO ncf_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","O naba sen parawe sin aila aina, xan tsaana Abaram, biaa Saatan tii ale sin, sin no miet ta sangaul ma ga laa paasaatuul, o gim we, a xap tutiik ngali iaa ba aleiwaai sin leng Saabat?” ");
INSERT INTO ncf_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Biaa tii paare weaatalaa, xan no matenkorot araraa di suk mangiel buxa, oro no inaman di suk taton ngali abala no maarang mamainaang buxa tii xoxosaraa. ");
INSERT INTO ncf_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Mil Iesu ga atsura, “Xan Maradaan Moroaa asen parawe? Iaa ba apuaa malen sa? ");
INSERT INTO ncf_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","A malen xalitsa ina tsupa o taamat ga adi ma ga soxaa lalon xan uma. Mil ga tsik lot malen ie o no maan di ga le xale papan xan no laxe.” ");
INSERT INTO ncf_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Iesu a sebula atsura, “Iaa ba sen apuaa we abala xan Maradaan Moroaa sin? ");
INSERT INTO ncf_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Asuk malen iis aina ta adi ma ga xaa louxaa mii xariin palawa ma ga suk pupuet lot.” ");
INSERT INTO ncf_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Biaa xan ines Iesu laa Jerusalem, a laa lalon no inaman laba ma no xobel ma ga lo asingan no inaman. ");
INSERT INTO ncf_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Xa ga atsuraa ia, “Orong, naba xap xudu no inaman, di ba adi atotoaa?” Ga suk paare ngali di, ");
INSERT INTO ncf_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Gim na suk watwat buxa ngali tsiga lalon abia mat dokdok, amuina xuduxudu, di ba xonon ngali tsiga lalon ma di ba xap pupua. ");
INSERT INTO ncf_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Biaa tapkina anua naba ta tapaas ma na tsaxali mat, gim ba til lokobel ma na pipidi ma gim ba suk ningi awatwati, ‘Orong, u na tsalali mat ngali giem!’ “Oro naba xisi weaatalaa: ‘Iaa suk xap atii gim o gim tii xaal itaa.’ ");
INSERT INTO ncf_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Mil gim ba paare, ‘Giem tii angangen ma nunun mii iu, ma iu tii asingan giem lalon nagiem no sal dokdok.’ ");
INSERT INTO ncf_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Oro naba xisi, ‘Iaa xap atii gim o itaa gim suk xaal. Gim soltia sin iaa gim araraa no inaman morokon!’ ");
INSERT INTO ncf_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Tia no tineng ma di ba angiririki no lian di; biaa gim ba ta lasi Abaram, Aisak, Jakop ma no propet araraa, di ta manman lalon xan Maradaan Moroaa, oro gim tsaa gim ba lasi Moroaa naba ta lii atsuulngi gim. ");
INSERT INTO ncf_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","No inaman di ba xaal nan selina, ma nan tudaan, ma nan no ruu, ma nan no paxel, di ba le adi xadi no xolot sin luxaal ina xan Maradaan Moroaa. ");
INSERT INTO ncf_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Asuk so, biaa no inaman di ta amamil, di ba lalaamua, o biaa di ta lalaamua di ba amamil.” ");
INSERT INTO ncf_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sin abia leng, biexaa Paarasi di xaalame sangan Iesu, di ga paare sin, “U na papaalii abala xolot ma u na laa lalon xa xolot xaatsap. Erot a wena sas amantei iu.” ");
INSERT INTO ncf_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ga xisi, “Gim mula, gim na asaaiti aia xapunakok weaatalaa, ‘Iaa ba saali no salawa tsaxa ma iaa ba atoaa no inaman talaawaa ma nowa ma sin nanaatuul ina leng, iaa ba araraai nugu tinaxaa.’ ");
INSERT INTO ncf_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Iaa na suk laa tsaa talaawaa, ma nowa ma tilaa, ngali iaa ba laa tsap Jerusalem. Amuina, asuk so maase, a xap xa propet na met lalon xa xobel xaatsap oro Jerusalem mu. ");
INSERT INTO ncf_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem, Jerusalem! Gim xaa sas amantei no propet ma gim xaa pidi amantei xan no inaman Moroaa, ta tulen di xaalame sin gim. Xuduxudu ina leng, iaa we ina axumuli nagim no tsi malen xan namaang puraa aina ta xaa axumuli xan no puraa dokdok paina xan no paalpaal, o gim ga xap siir. ");
INSERT INTO ncf_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Alongmen! Nagim xobel naba suk tsaxa ma na manman gomsaa. Iaa suk asaaiti gim, gim ba xap bula lasi iaa, til sin leng gim ba ta paare, ‘Moroaa atubudaani iwaa taamat ta xaalame sin iesan Orong.’ ” ");
INSERT INTO ncf_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sin leng Saabat, Iesu a laa ngali laa angen lalon xan anua lalaamua ina no Paarasi, o di ga xale ngali rimiti ia. ");
INSERT INTO ncf_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","A nanen laamuaan ia, asuk lasi iexa taamat ta maramase taman isua ting. ");
INSERT INTO ncf_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Iesu atsuraa no Paarasi ma no unsinaae ina lo, “Xan lo Moroaa a sirawaa bula ngali atoaa no maramase sin leng Saabat o a xap?” ");
INSERT INTO ncf_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Oro di ga xale bong mu. Ga taana iwaa taamat, ga atoaa ia ma ga tulen laangen ia. ");
INSERT INTO ncf_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Mil ga atsuraa di, “Nawe xa ina gim a ie tsi o xa bulmakau ta xol laa lalon mat ina daan sin leng Saabat, naba sen parawe, gim ba laa taii atsuulngi esagaalen mu, o a xap?” ");
INSERT INTO ncf_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ma di ga xap paatina xawas. ");
INSERT INTO ncf_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Biaa ta matngen no inawut di ta tsap sin luxaal ma di ga inten no xalkale ina mangmangle pan ibe luxaal, ga asaaiti di taman abala totore puapua: ");
INSERT INTO ncf_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nawe xa aningi iu ngali iu ba xaalame sin xan luxaal ina alaba, nangaam inten xa xalkale ina mangmangle, amuina xa ia di ta manglen buxaai ngen iu, di ba soro ningi ngali xaalame bula. ");
INSERT INTO ncf_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nawe a weaatia, iwaa taamat ta ningi gululu arie ngali xaalame, naba paare sin iu weaatalaa, ‘U na tali abia xalkale sin aila taamat,’ mil u ba suk mangiel ma u na laa tsotso mil. ");
INSERT INTO ncf_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Oro nawe di ningi iu ngali xaalame sin luxaal, naba suk axaau ngali u na adi abia niaan xalkale ta lapula mu, o nawe iwaa ta ningi iu ngali xaalame naba le asaaiti iu, ‘Taat, u na tapaas ma u na laa adi xa niaan xalkale lot.’ Biaabi no inaman di ta tsap esuei sin abia luxaal, di ba suk manglen iu labatina no uk inawut. ");
INSERT INTO ncf_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Amuina no saa biaa di ta aloti di tsaa, di ba adokdoki di ma no saa biaa di ta adokdoki di tsaa, di ba aloti di.” ");
INSERT INTO ncf_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Mil Iesu ga paare ngali tapkina luxaal, “Nawe iu xosaraa xa luxaal, lasiaat o nale, nangaam ilei no turaam, num no taamat ma num no matenbung o no uniewas atataaen iu, nawe u xosaraa weaatia, di ba sebula ningi iu ngali xaalame sin xadi luxaal ngali xiis mulangenai abia num luxaal. ");
INSERT INTO ncf_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Oro biaa iu ta xosaraa xa luxaal, axaau ngali u ba ningi no muunwas, no taaluduk, no xadek tsaxa ma no matababa. ");
INSERT INTO ncf_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Sin abia, Moroaa naba suk atubudaani iu, amuina di xap pupua ngali xiis mulangena num no luxaal. Moroaa naba xisi abia namaang iu ta xosaraa sin di, sin leng no inaman tutiik di ba ta tapaas mula sin minet.” ");
INSERT INTO ncf_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Biaa iexa taamat ta angen mii di ta alongmen abala, ga paare ngali Iesu, “Moroaa u na atatoni iwaa taamat ta angen sin luxaal ina xan Maradaan Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Iesu a xisi, “Iexa taamat a taxaaturungi xariin luxaal ma ga ningi no daan inawut xaalame. ");
INSERT INTO ncf_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Sin leng ina luxaal, a tulen xan untutule ngali laa asaaiti abia di, ta se ningi di, ‘Gim xaalame, no luxaal a se taxaaturung.’ ");
INSERT INTO ncf_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Oro di araraa di paare, di taliil. Iexa a setauan paare, ‘Iaa er uuli xoltin pula o iaa ben laa ngali lasi. Timaa, adodolii iaa. Iaa xap pupua ngali xaalame.’ ");
INSERT INTO ncf_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Iexa a paare, ‘Iaa er uuli alualua lalon no xumul ina bulmakau ta lima o talaawaa iaa se laa ngali xonon di. Timaa, adodolii iaa. Iaa xap pupua ngali xaalame.’ ");
INSERT INTO ncf_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Iexa bula a paare, ‘Iaa er maxis mu biaabi iaa xap pupua ngali xaalame.’ ");
INSERT INTO ncf_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Iwaa untutule a mula ma ga laa asaaiti xan manmanel taman abala no maarang. Tapkina anua alongmen abala, asuk magaa buxa ma ga asaaiti xan untutule, ‘U na laa isagaa lalon no xariin sal ma no sal dokdok lalon inaman laba ma u na giwaa no muunwas, ma no isua met, no xadek tsaxa ma no matababa ngali xariin luxaal.’ ");
INSERT INTO ncf_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Untutule a paare, ‘Manmanel, samaarang u ta asaaiti giem ngali xosaraa giem se xosor puaa, oro, no xolot tsaa bala ngali xaal bula.’ ");
INSERT INTO ncf_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Mil iwaa manmanel ga asaaiti xan untutule, ‘U na laa lalon no sal ma no sal laba ina inaman labalaba ma u na asaait awatwati di ngali xaalame, ngalibi nugu anua naba suk us. ");
INSERT INTO ncf_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Iaa asaaiti gim, biaa no taamat iaa tii ningi di, naba suk xap xa ina di naba le xon saaen nugu luxaal.’ ” ");
INSERT INTO ncf_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Xariin xumul di eses mii Iesu, o ga putsi, ga asaaiti di, ");
INSERT INTO ncf_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Nawe xa a xaalame sangan iaa o ga xap ngutsulen xan mom ma nagaa, xan tubu ma no tsi, no turumasen ma no moton–iou, xan tino tsaa bula–naba xap pupua ngali tsap nugu tsi asasing. ");
INSERT INTO ncf_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ma nawe xa a xap atsaxei xan tongol ma ga amusili iaa naba xap pupua ngali tsap nugu tsi asasing. ");
INSERT INTO ncf_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Nawe xa ina gim a saan ngali xosaraa xa xariin anua ta laa lapalaa, naba setauan tsotso ngali xoxoti iliil ngali lasi nawe a ie xuxute pupua ngali araraai abia anua. ");
INSERT INTO ncf_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ngali nawe a se axosngi atkale ma ga xap pupua ngali araraai, biaa no inaman araraa di ba lasi, ma di ba reret taman ia. ");
INSERT INTO ncf_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Di ba paare weaatalaa, ‘Nan pepexa, atiltsoli ngali xosaraa anua o ga xap pupua ngali araraai.’ ");
INSERT INTO ncf_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Nawe xa king a se taxaaturung ngali laa sin maxil ngali esas mii iexa king, naba setauan xale ma na adodo, xan 10,000 ina unmakmaxil a pupua ngali epuske mii iexa king taman xan 20,000 ina unmakmaxil, o a xap? ");
INSERT INTO ncf_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nawe iwaa king a xap pupua, naba suk tulen esagaalen xan no unmalina laa sin aia king ta manman palpalaa tsaa, ngali di ba laa ningi ngali malum. ");
INSERT INTO ncf_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Sin abia uk sal, nawe xa ina gim a xap pupua ngali papaalii xan no maarang araraa ta tapkina, naba xap pupua ngali tsap nugu tsi asasing. ");
INSERT INTO ncf_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Tes maarang axaau, oro nawe xan xon tes a tamsi, naba sen xon tes mula we. ");
INSERT INTO ncf_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Naba xap axaau ngali pula o tien bulmakau oro a se pupua mu ngali silelii. “Iwaa ta ie talinga, poroklii na lolong.” ");
INSERT INTO ncf_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Talaawaa no unaalalet taakis ma no untsaxa, di le tsap exumule ulti ngali alongmen ia. ");
INSERT INTO ncf_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Oro no Paarasi ma no unaasasing ina lo, di ga buriik xuduxudu labatina di tsaa, “Ilawaa taamat a xaa suei atatoni no untsaxa ma ga xaa angen mii di.” ");
INSERT INTO ncf_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mil Iesu ga asaaiti di taman abala totore puapua: ");
INSERT INTO ncf_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nawe xa ina gim a ie sangsangaul axuuk ina sipsip ma axuuk ina di ga xaapina. Naba papaalii no sangaul apaasaaet ma ga laa paasaaet lalon xa xolot axaau, ma na laa tsatsel ngali iwaa sipsip ta xaxapina pupua naba ta tatanginai. ");
INSERT INTO ncf_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Biaa ta se tatanginai, a suk taton buxa, ga atsaxei papan xalkalan ");
INSERT INTO ncf_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ma ga laa tatan. Mil ga ilei todomien no turan ma no inaman atataaen ma ga paare, ‘Gim na papaalam mii iaa, amuina iaa se tsal tatanginai nugu sipsip, iwaa ta ben xaxapina.’ ");
INSERT INTO ncf_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Iaa asaaiti gim, sin abia uk sal mu di ba papaalam buxa balalangit nawe untsaxa a xuuk a puxisbal ngen no sangaul apaasaaet ma ga laa paasaaet ina untutiik, biaa ta xap xa tinaxaa bula ngali di na puxisbal. ");
INSERT INTO ncf_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Nawe xa aina a ie sangaul ina xuxute, ga xosorlii axuuk. Naba arara laam, rii anua o na tsatsel axaau til sin naba ta tatanginai. ");
INSERT INTO ncf_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Biaa ta tatanginai, naba suk ilei todomien no turan ma no inaman atataaen ngali xaalame sangan, o ga paare, ‘Gim na papaalam mii iaa, iaa se tatanginai nugu xuxute, iwaa ta ben xaxapina.’ ");
INSERT INTO ncf_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Iaa asaaiti gim, sin abia uk sal mu di ba papaalam laamuaan xan no angelo Moroaa nawe xa untsaxa a puxisbal.” ");
INSERT INTO ncf_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iesu ga lo papaare tsaa, “Iexa taamat xan no tsi alua. ");
INSERT INTO ncf_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Iwaa nan kes, ga asaaiti xan mom, ‘Mom u na tali nugu nabuk ina num xalkale iaa ta momtsoli no.’ Biaa se, mom asuk exasen xan xalkale labatina delulu. ");
INSERT INTO ncf_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Nen leng a se liu ma iwaa nan kes aturung todomien xan no maarang ma ga tapaas laa palpalaa sin biexa inaman laba. Lalon abia xobel, a laa xosaraa no mat namaang tsaxa ma ga araraai xan no mat maarang lalon tino tangtangabaa. ");
INSERT INTO ncf_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Mulina ta se lii araraai xan no xuxute, xariin itol atsap lalon abia inaman labalaba araraa, o iwaa tsi ga suk muun sin no mat maarang araraa. ");
INSERT INTO ncf_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","A laa atiltsoli ngali taxaa sin iexa taamat lalon abia inaman labalaba, o iwaa xa ga tulen ngali laa tilaamamil sin xan no bol. ");
INSERT INTO ncf_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Asuk saan buxa ngali ngani abia xadi bilong no bol, oro ga xap xa na tabali taman xa pu luxaal. ");
INSERT INTO ncf_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Biaa xan adodo tii se laa mula, ga we, ‘Aisa xan no untinaxaa nugu mom, balaa di ta lo angangen axaau buxa, o iaa tala, iaa ta se met taman maaga no itol! ");
INSERT INTO ncf_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Iaa ba tapaas ma iaa na mula laa sangan nugu mom ma iaa na asaaiti, “Mom iaa se xosaraa namaang tsaxa lalon no matan Moroaa ma no mataam bula. ");
INSERT INTO ncf_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Iaa xap axaau buxa ngali u ba putsangi iaa bula malen num tsi, u na xosaraa iaa malen num no untinaxaa.”’ ");
INSERT INTO ncf_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Biaa se, iwaa tsi ga tapaas ma ga laa sangan xan mom. “Oro biaa ta eses palpalaa tsaa, xan mom a lasi ma ga suk titii buxaai, ma ga sol laa sangan xan tsi ma ga logotsi ma ga nguri ia. ");
INSERT INTO ncf_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Iwaa tsi ga asaaiti xan mom, ‘Mom, iaa se xosaraa namaang tsaxa lalon no matan Moroaa ma lalon no mataam. Iaa xap axaau bula ngali u ba putsangi iaa malen num tsi.’ ");
INSERT INTO ncf_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Oro xan mom, ga paare sin xan no untutule, ‘Gim isagaa! Gim na adi abia uga disdis ta mamainaang ma gim na alen tali sin. Gim na aturungi bula ring sin xan kakaalis ma no bubut sin no xaden. ");
INSERT INTO ncf_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Gim na laa tsaapi aia bulmakau uul ta pompom ma gim na adi ngen tala ngali gita ba xosaraa xariin luxaal ngali gita ba papaalam. ");
INSERT INTO ncf_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Amuina ilawaa nugu tsi tii se met o talaawaa a sebula tino mula, tii se xaapina, o talaawaa gita sebula tatanginai.’ Di ga atiltsoli papaalam. ");
INSERT INTO ncf_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Sin abia aua, iwaa tuaa ina tsi tii manman lalon uma. Biaa ta mula atataaen anua asuk alongmen no ananaan ma no tinili. ");
INSERT INTO ncf_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Iwaa tuaa ina tsi a ilei iexa untutule ma ga atsuraa, ‘Samaarang abala ta tsap?’ ");
INSERT INTO ncf_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Untutule a xisi, ‘Turumasen iu a se mula o num mom ga se tsaapi aia bulmakau uul ta pompom, amuina a se mula xaalame taman tino mamainaang.’ ");
INSERT INTO ncf_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Iwaa tuaa ina tsi alongmen abala ga suk magaa ma ga palo ngali tsomi di sin abia luxaal. Xan mom ga tsuul xaalame ga le ningi ngali tsomi di. ");
INSERT INTO ncf_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Oro ga xisi xan mom, ‘Lasi! Sin abala no miet iaa lo taktaxaa malen num untutule ma iaa xap xaa longlii num no papaare, o u xap mager atatoni iaa taman xa meme uul ngali iaa ba soro xosaraa xa luxaal mii no turan iaa. ");
INSERT INTO ncf_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Oro ilawaa num tsi, tii laa lii gomsaai num no mat maarang sin no aina in nan sal, a le tsap, o u ga tsaapi aia bulmakau uul ta pompom ngali ia!’ ");
INSERT INTO ncf_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“O xan mom ga paare, ‘Nugu tsi, u tigiri manman mii iaa, o balawaa nugu no mat maarang, num no. ");
INSERT INTO ncf_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Oro gita xosaraa abala luxaal ngali papaalam amuina num taamat tii se met o talaawaa a se tino mula, tii se xaxapina o talaawaa gita se tatanginai.’ ” ");
INSERT INTO ncf_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesu asaaiti xan no tsi asasing: “Iexa untang iwaa xan untilaamamil, ta atutali mamaet we a lii gomsaai xan no mat maarang. ");
INSERT INTO ncf_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","O iwaa untang ga ilei ma ga tiiriki, ‘Sawe abala iaa ta alongmen taman iu? Alengi iaa taman num no tinaxaa u ta xosaraa, amuina u xap pupua ngali tilaamamil sin nugu no maarang bula.’ ");
INSERT INTO ncf_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Iwaa untilaamamil a asaaiti ia tsaa, ‘Iaa ba se xosaraa sa atala? Nugu manmanel a se saali iaa sin nugu tinaxaa. Iaa xap watwat buxa ngali xaxie ma iaa mangiel bula ngali tsap unningning. ");
INSERT INTO ncf_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Iaa atii! Iaa ba xosaraa sa nawe iaa ba poroklii nugu tinaxaa atala, no inaman di ba suei atatoni iaa laa lalon xadi no anua.’ ");
INSERT INTO ncf_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Biaabi ga ilei xuxuuk ina abia no inaman di ta ie xiba sin aia manmanel, a setauan atsuraa aia ta laamua, ‘Aisa tsaa biaa num xiba sin nugu manmanel?’ ");
INSERT INTO ncf_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“A xisi, ‘Apaasaatuul ina no sangsangaul ina no galen ina olip daanwe.’ “Iwaa untilaamamil asaaiti ia, ‘U na adi aisa u ta xiba sin, u na tsotso isagaa, ma u na aririi laa sin no sangsangaul aet.’ ");
INSERT INTO ncf_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“A sebula atsuraa nanaalua, ‘Ma aisa tsaa biaa u ta xap mager xisi?’ “ ‘Sangsangaul axuuk ina no xiis ina wit.’ “Mil ga sebula asaaiti ia, ‘Adi num xiba ma u na aririi laa sin no sangual apaasaatuul.’ ");
INSERT INTO ncf_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“O iwaa manmanel atinangen aia untilaamamil tsaxa amuina ta xosaraa abia taman sinaae axaau. Amuina no inaman sin abala xolkolmoxo di ie sinaae buxa ngali xoxosaraa axaautsi xadi no inaman tsaa, ngen xan no inaman Moroaa. ");
INSERT INTO ncf_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Iaa asaaiti gim, gim na tiltsomi no inaman sin abala xolkolmoxo taman xuxute ngali di ba tsap malen nagim no taamat, o mil, sin abia no mat maarang naba ta se xap, Moroaa naba suei atatoni gim laa lalon xobel ina tino laaliu. ");
INSERT INTO ncf_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ma saa ia ta pupua ngali taalnge sin no maarang dokdok buxa, naba pupua bula ngali taalnge sin no maarang lot. Ma nawe saa ia, ta xap so sin no maarang dokdok, naba xap so sin no maarang lot. ");
INSERT INTO ncf_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Biaa nawe di xap taalnge sin gim ngali xosaraa abala no maarang lalon abala xolkolmoxo, saa naba taalnge sin gim taman no minaas so in balalangit. ");
INSERT INTO ncf_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ma nawe gim xap pupua ngali tilaamamil sin xan no maarang xa xaatsap, o saa naba tali num xaa maarang ngali tapkina no? ");
INSERT INTO ncf_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“A xap pupua ngali xa untutule naba taxaa paina xaa manmanel na lua. Nawe a weaatia, naba ngutsulen iexa o iexa naba titii. O naba lolong amusili iexa o iexa naba taaltalu sin. Gim xap pupua ngali taxaa arie sin Moroaa ma sin xuxute bula.” ");
INSERT INTO ncf_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Biaa no Paarasi di ta alongmen abala, di suk reret ia, amuina di titii buxaai xuxute. ");
INSERT INTO ncf_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","O Iesu ga paare ngali di, “Gim, abia no mat laxen inaman, gim ta xaa we gim tutiik lalon no matan no inaman, oro Moroaa asuk atixi axaautsi nagim no butsa. Samaarang asuk lot buxa labatina gim no taamat, asuk morokon buxa nan no matan Moroaa. ");
INSERT INTO ncf_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Xan lo Moroaa ma xadi totore no propet di tii se babaais tsaa pupua sin Jon ta tsap. Atiltsoli sin abia leng, di ta baais taman inesaait mamainaang ina xan Maradaan Moroaa, no inaman araraa di se esurut ngen di ngali tsiga. ");
INSERT INTO ncf_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","A malus mu ngali balalangit ma balan pula naba xaxapina, ngen xa pu inaatel ina lo na xaxapina. ");
INSERT INTO ncf_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Nawe xa atsiplii xan tubu ma ga maxis sin iexa aina xaatsap, a se xosaraa namaang ina matul mii aina ta xap maxis sin, ma nawe taamat a maxis sin aina xan maxis ta atsiplii, a se xosaraa namaang ina matul mii taamat ta xap maxis sin. ");
INSERT INTO ncf_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Iexa untang, a xaa tamtuel taman uga de ma iliil ina a lot buxa, ma sin no baabaa leng se araraa a xosaraa no xariin luxaal. ");
INSERT INTO ncf_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Sangan xan matenmat, di xaa le atetei iexa unningning, iesan ila Lasarus no isuaan ta us taman toto. ");
INSERT INTO ncf_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","A xaa laa tete atia ma ga xaa saan ngali ngani no mirmir ta xol laa paina xan ibe angangen iwaa untang. Ma no xapuna bula, di xaa xaalame ngali damdami xan no toto. ");
INSERT INTO ncf_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Sin abia leng ta tsap Lasarus tii se met ma no angelo di ga giwaa laa balalangit sangan Abaram. Iwaa taamat untang tii met bula ma di tii ga punami. ");
INSERT INTO ncf_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Iwaa untang a laa lalon ie Edes ma ga saaen xariin sosong. O tii ga nanen laa lapalaa, ga lasi Abaram palpalaa mii ilaa Lasarus sangan. ");
INSERT INTO ncf_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Biaabi ga ilei ia, ‘Mom Abaram, u na ie biirbirum sin iaa. U na tulen Lasarus ngali iwaa xan kakaalis lalon daan ma na le amadili nankalimaaga amuina iaa manman lalon xariin sosong lalon abala ie!’ ");
INSERT INTO ncf_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Oro Abaram a xisi, ‘Nugu tsi, adodomi sin num no leng u tii tino, u tii adi no mat maarang axaau o Lasarus tii adi no maarang tsaxa. Oro talaawaa, Lasarus a se taton lalon xan axoxorong sin Moroaa o iu se manman atala lalon abia xariin sosong. ");
INSERT INTO ncf_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ma biexa was bula, xariin maxaaba bala labatina gita, ngalibi biaa di ta saan ngali xaal atala laa sangan iu, di ba xap pupua ma naba xap xa na pupua ngali laxei tabaxi tile xaatian xaalame sangan giem.’ ");
INSERT INTO ncf_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“O ga xisi, ‘Iaa ningi awatwati iu, mom, u na tulen Lasarus laa tatan nugu mom, ");
INSERT INTO ncf_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","amuina no turaagamasen alima. Tulen ngali na atewaai di, ngalibi di ba xap xaalame bula lalon abala xolot ina xariin sosong.’ ");
INSERT INTO ncf_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abaram a xisi, ‘Xan no inaatel Moses ma no propet biaa tia, di na alongmen no.’ ");
INSERT INTO ncf_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“A paare, ‘A xap, Mom Abaram! Nawe xa a tapaas mula xaal sin minet ga laa asaaiti di, di ba puxisbal.’ ");
INSERT INTO ncf_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Abaram a paare ngali ia, ‘Nawe di xap alongmen Moses ma no propet di ba xap taltaalnge bula sin xa nawe a tapaas mula xaal sin minet.’ ” ");
INSERT INTO ncf_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesu a paare ngali xan no tsi asasing, “No xonkonon biaa naba ta xaalame ngali xosaraa no inaman ngali di ba xosaraa namaang tsaxa. Oro xariin xirabas sin aia taamat ta le tali abia xonkonon sin xa! ");
INSERT INTO ncf_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Na ba suk axaau ngali xa na pistali xa xariin xaat sin inan ma na lii laangen ia lalon laman xoskos maxet ngali naba xap xosaraa xa ina abala no tsi dokdok na xol lalon namaang tsaxa. ");
INSERT INTO ncf_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Lowas, gim na xoxo sin gim tsaa. “Nawe num taamat a xosaraa namaang tsaxa, u na imii ia ma nawe a puxisbal u na adodolii xan no namaang tsaxa. ");
INSERT INTO ncf_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nawe a xosaraa no namaang tsaxa apaasaalua susum sin leng ta xuuk ma xan inamula xaalame sangaam apaasaalua sebula ma ga paare, ‘Iaa puxisbal sin nugu no namaang tsaxa iaa ta xosaraa susum.’ U na adodolii abia xan no namaang tsaxa.” ");
INSERT INTO ncf_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","No aposal di asaaiti Orong, “U na aloti nagiem tinaalnge.” ");
INSERT INTO ncf_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Orong ga xisi di, “Nawe nagim tinaalnge adokdok mu malen xalitsa ina tsupa, gim pupua ngali asaaiti ilawaa ie xaso, ‘U na ruplii iu tsaa ma u na soxaa iu tsaa talaa lau,’ ma naba lolong amusili gim. ");
INSERT INTO ncf_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Nawe xa ina gim, xan untutule a laa pulis lalon uma ma ga tilaamamil sin no sipsip. Biaa untutule ta mula xaal lalon uma, naba pupua ngali asaaiti ia weaatalaa, ‘Xaalame ma u na le tsotso ngali angen?’ ");
INSERT INTO ncf_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Asuk xap, naba sebula tulen, ‘U na laa sisil, taxaaturungi nugu luxaal ma u na tabali iaa ngali iaa ben angen ma nun, o mil nawe iaa se xap, iu soro.’ ");
INSERT INTO ncf_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","U we, iwaa manmanel naba putsangi axaau sin untutule amuina ta xosaraa abia no tinaxaa malen ta asaaiti ngali xosaraa? A suk xap. ");
INSERT INTO ncf_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Gim bula, biaa gim ta se xosaraa no tinaxaa malen Moroaa ta asaaiti gim, gim ba paare weaatalaa, ‘Giem no untutule gomsaa mu, giem taxaa puaa mu nagiem no tinaxaa.’ ” ");
INSERT INTO ncf_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Iesu a eses labatina prowins Samaria ma Galili ngali laa Jerusalem. ");
INSERT INTO ncf_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Biaa ta es tsiga lalon biexa xobel, asangaul no taamat di ta ie minet basbas, di sabasue ia. Di tiltil palpalaa tsaa, ");
INSERT INTO ncf_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","di ga ilei lot, “Orong, Iesu, u na ie biirbirum sin giem!” ");
INSERT INTO ncf_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Biaa ta lasi di ma ga asaaiti di, “Gim laa asen no isuaan gim sin no unsausawit.” Biaa di es laa, di suk tuo sin abia maramase. ");
INSERT INTO ncf_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Iexa ina di, biaa ta lasi we a se tuo, asuk es mula laa sangan Iesu, ga xuup paipaʼii Moroaa. ");
INSERT INTO ncf_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","A xaalame ma ga le sage putput sangan no xaden Iesu, ga putsangi axaau laa sin. Ia taan ina prowins Samaria. ");
INSERT INTO ncf_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Iesu ga atsura, “Iaa tii se atoaa sangaul ina taamat, o inaabi biexaal? ");
INSERT INTO ncf_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Asuk xap xa bula na mula ngali le paʼii Moroaa, iwaa taan Samaria mu.” ");
INSERT INTO ncf_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ga paare ngali ia, “U na tapaas laa, num tinaalnge a se atoaa iu.” ");
INSERT INTO ncf_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Biexaa Paarasi, di atsuraa Iesu, “Langisa so xan Maradaan Moroaa naba xaalame?” Iesu ga xisi di, “Xan Maradaan Moroaa naba xap xaalame sin gim ta liliis ma atsotsoxo ngali. ");
INSERT INTO ncf_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","No inaman di ba xap we, ‘Lasi, balawaa se,’ o ‘Biliaa se,’ amuina xan Maradaan Moroaa bia lalon nagim no butsa.” ");
INSERT INTO ncf_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Mil ga asaaiti xan no tsi asasing, “Leng biaa naba ta xaalame biaa gim ba saan buxa ngali lasi xa leng ta xuuk, xan aia Xan Tsi Taamat, oro gim ba xap pupua ngali. ");
INSERT INTO ncf_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","No inaman di ba asaaiti gim, ‘Iliaa se!’ o ‘Ilawaa se!’ Oro, gim nangaam amusili ma taltaalnge sin di. ");
INSERT INTO ncf_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Amuina Xan Tsi Taamat naba tsap malen tsilatsila ta atsilangi balalangit araraa. ");
INSERT INTO ncf_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Oro naba setauan alet sosong sin no daan maarang ma no inaman sin abia no utmilmil di ba palolii ia. ");
INSERT INTO ncf_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Sin leng Xan Tsi Taamat naba ta mula, naba suk malen mu xan no leng Noa. Biaa mu uk maarang naba tsap. ");
INSERT INTO ncf_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","No inaman di tii lo angangen ma nunun ma di tii emaxise til sin leng Noa tii tsiga lalon mono, o xariin tuun ma langit ga tsap ma ga suk aliaani no inaman araraa. ");
INSERT INTO ncf_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Naba malen bula xan leng Lot. No inaman di tii lo angangen ma nunun ma di tii uulul ma sune taman no maarang, ma di tii soksok uma ma di tii tumtumar anua. ");
INSERT INTO ncf_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","O sin abia leng Lot tii papaalii Sodom, ie mii no xaat lelep ausa xaal balalangit, ma ga suk tuun amantei no inaman araraa. ");
INSERT INTO ncf_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Naba suk weaatala, sin abia leng Xan Tsi Taamat naba ta mula. No inaman di ba xap muun taxaaturung. ");
INSERT INTO ncf_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Sin abia leng nawe taamat a manman papan unga ina anua, o xan no maarang balaa naanua, naba xap pupua ngali tsuul ngali adi no. Naba malen bula taamat ta manman lalon uma naba xap pupua ngali mula laa lalon anua. ");
INSERT INTO ncf_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Adodomi samaarang tii tsap sin xan tubu Lot. ");
INSERT INTO ncf_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nawe saa ia ta wena xonon ngali taxaariti xan tino, naba xosorlii xan tino, ma nawe sa ia ta tali xan tino ngali iaa, naba adi tino laaliu. ");
INSERT INTO ncf_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Iaa asaaiti gim, sin abia bing no taamat alua delu ba matul arie papan uk ibe, axuuk Moroaa naba giwaa, ma iexa naba manman mula. ");
INSERT INTO ncf_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","No aina alua delu ba iesei tapiok arie, Moroaa naba giwaa xa ma naba papaalii iexa.” ");
INSERT INTO ncf_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Di ga atsuraa, “Orong, itaa abala maarang naba tsap?” Ga xisi di, “Nawe xa pakpak a met, ga xapul, sin abia xolot mu no xotkot di ba le exumule.” ");
INSERT INTO ncf_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Mil Iesu asaaiti xan no tsi asasing taman totore puapua ngali asen sin di, ngali di na tigiri sausawit ma di na xap pelmet. ");
INSERT INTO ncf_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ga paare, “Sin biexa inaman laba, iexa unininte, a xap muun mataatina Moroaa ma a xap titii no inaman bula. ");
INSERT INTO ncf_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Iexa aina nal, nan abia inaman laba, atigiri lo xaxaalame sangan ngali ningi, ‘U na tiltsomi iaa sin nugu ininte, ngali atutiki biaa mamaet labatina iaa mii nugu matenkorot.’ ");
INSERT INTO ncf_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“A se xudu no leng, iwaa unininte ta palo ngali tiltsomi, o mil ga sebula adodo mula sin ia tsaa, ‘Asuk so, iaa xap mataatina Moroaa ma iaa xap manglen inaman, ");
INSERT INTO ncf_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","oro ilawaa aina atigiri tali mamaet sin iaa, malen axaau ngali iaa ba xosaraa xan ininte, sin sa naba ta apelmeti iaa sin ta tigiri xaxaalame.’ ” ");
INSERT INTO ncf_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Orong ga sebula paare, “Lolong sin aia unininte ta xap ininte tutiik ta papaare. ");
INSERT INTO ncf_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Gim atii we Moroaa naba tali ininte tutiik sin xan no inaman ta se intentsoli di, biaa di ta lo tengteng laa sangan sin no siaat ma no bing. O naba lo longlilii mu di? ");
INSERT INTO ncf_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Iaa asaaiti gim, naba isagaa mu ngali tali ininte sin di! Biaa Xan Tsi Taamat naba ta xaalame, u we naba tatanginai tsaa xaa untinaalnge lalon abala balan pula?” ");
INSERT INTO ncf_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Iesu a paare taman abala totore puapua, di ta we di tutiik ma di ga nen amagurusiki biexaa inaman xaatsap. ");
INSERT INTO ncf_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Alua no taamat, delu laa lapalaa sangan Xan Anua Moroaa ngali laa sausawit. Iexa ina delulu Paarasi o iexa unaalalet taakis. ");
INSERT INTO ncf_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Iwaa Paarasi a til ma ga sawit asen ia tsaa, weaatalaa, ‘Moroaa, iaa putsangi axaau sin iu, we, iaa xap malen biexaa taamat, di no unpulapula ma di no untsaxa ma di xaa matul mii no aina xaatsap, ma iaa xap malen bula ilawaa unaalalet taakis. ");
INSERT INTO ncf_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Iaa xaa el sin no leng alua ina wik axuuk ma iaa ga xaa tali axuuk sangaul ina nugu no xuxute laa susum sin sawe iaa ta taana.’ ");
INSERT INTO ncf_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Oro iwaa unaalalet taakis a til palpalaa ma ga xap muun nanen laa balalangit tsaa, o ga pantsi bongbongon, ga we, ‘Moroaa, iaa untsaxa, u na ie biirbirum sin iaa.’ ");
INSERT INTO ncf_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Iaa asaaiti gim, ilawaa unaalalet taakis atsap untutiik lalon no matan Moroaa, o ilawaa Paarasi a xap. Amuina saa ia ta alet laangen iesan lapalaa, Moroaa naba laangen iesan lapula, O saa ia ta laangen iesan lapula, Moroaa naba alet laangen iesan lapalaa.” ");
INSERT INTO ncf_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","No inaman di le tali xadi no tsi dokdok sin Iesu ngali naba taana di. O biaa no tsi asasing di ta lasi abala, di suk imii di. ");
INSERT INTO ncf_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Oro Iesu ga ilei no tsi dokdok xaalame sangan, ga we, “Gim papaalii no tsi dokdok di na xaalame sangaaga. Gim na xap tilbanti di amuina xan Maradaan Moroaa xadi abia di, di ta malen abala no tsi dokdok. ");
INSERT INTO ncf_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Iaa asaaiti gim so, saa ia ta xap adi xan Maradaan Moroaa malen xa tsi dokdok, naba xap pupua ngali tsiga lalon abia Maradaan.” ");
INSERT INTO ncf_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Iexa lalaamua atsuraa ia, “Unaasasing mamainaang! Iaa ba xosaraa samaarang ngali tapkina abia tino laaliu?” ");
INSERT INTO ncf_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Iesu a xisi, “Ngalisa u ta we iaa taamat mamainaang? A xap xa na mamainaang, Moroaa mu a mamainaang. ");
INSERT INTO ncf_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","U se atii xan no lo Moroaa, ‘Nangaam matul mii aina ta xap num tubu, nangaam sas amantei xa, nangaam pulapula, nangaam ababaa, manglen num mom ma nagaa.’ ” ");
INSERT INTO ncf_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ga xisi, “Iaa se taxaawiti ma amusili abala no lo sin leng iaa tii xulaau ma le pupua atalaa.” ");
INSERT INTO ncf_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Biaa Iesu ta alongmen abala, ga paare sin ia, “U muun tsaa ngali was ta xuuk. U na sune taman num no mat maarang ma u na tali abia no xuxute sin no muunwas, ngali u ba iewas balalangit, ma xaalame u na amusili iaa.” ");
INSERT INTO ncf_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Biaa ta alongmen abala, asuk lolbiir buxa amuina ia untang. ");
INSERT INTO ncf_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iesu a atsoxaa iwaa lalaamua, ga we, “Naba suk lelep ngali xa untang ngali tsiga laa lalon xan Maradaan Moroaa. ");
INSERT INTO ncf_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Aso, a suk malus mu ngali xa kemal na tsiga lalon mat ina nil samsamaap, ngen xa untang ngali tsiga lalon xan Maradaan Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Biaa di, di ta alongmen abala, di suk atsuraa, “O no saa so di ba pupua ngali adi abia atotoaa?” ");
INSERT INTO ncf_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Iesu a xisi di, “Samaarang no taamat di ta xap pupua ngali xosaraa, Moroaa mu a pupua ngali xosaraa.” ");
INSERT INTO ncf_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pita ga asaaiti ia, “Lasi, giem se poroklii nagiem no maarang se araraa ngali amusili iu.” ");
INSERT INTO ncf_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Iesu a paare ngali di, “Iaa suk asaaiti gim taman so, saa ia ta poroklii tatan, o xan tubu, o xan no turamasen, o xan mom ma nagaa, o xan no tsi ngali tapkina xan Maradaan Moroaa, ");
INSERT INTO ncf_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","naba adi no daan maarang sin abala tino, ma sin abia tino mil naba ta laa xaalame biaa tino laaliu.” ");
INSERT INTO ncf_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iesu agii axumuli no tsi asasing ta sangaul axuuk ma ga laa lua, ga asaaiti di, “Gita ba se laa lapalaa Jerusalem ma no maarang araraa no propet di tii se atalaa ngali Xan Tsi Taamat naba se taxaa puaa. ");
INSERT INTO ncf_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Di ba gii tali sin no Gentail. Di ba reret ngen, di ba amangieli di ba xamutsaa, ");
INSERT INTO ncf_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","di ba ririiti o di na sas amantei ia. Sin nanaatuul ina leng naba sebula tapaas mula nan suu ina minet.” ");
INSERT INTO ncf_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","No tsi asasing, di xap muun leng sin xan no totore. Muina ina abia no totore axuxii sin di ma di ga xap atixi sen maarang a papaare taman. ");
INSERT INTO ncf_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Iesu a se es atataaen Jeriko o iexa matababa axalkale sin gelgel ina sal ma ga lo ningningi no inaman ngali xaa was. ");
INSERT INTO ncf_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Biaa ta alongmen malep ina inaman ta es liu, ga atsuraa, “Sawe abala ta tsap?” ");
INSERT INTO ncf_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Di ga asaaiti, “Iesu in Nasaret, a es liu.” ");
INSERT INTO ncf_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","A suk ilei, “Iesu, xan tsi Dewit, u na ie biirbirum sin iaa!” ");
INSERT INTO ncf_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Biaa no inaman di ta es lalaamua, di imii, di ga asaaiti ngali na bong, oro asuk ilei lot, ga we, “Xan tsi Dewit, u na ie biirbirum sin iaa!” ");
INSERT INTO ncf_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Iesu a til wat ma ga asaaiti di, “Gii xaalamien sangaaga.” Biaa iwaa taamat ta xaalame atat, Iesu ga atsuraa ia, ");
INSERT INTO ncf_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“U saan ngali iaa ba xosaraa sa susum?” A xisi, “Orong, iaa saan ngali nanen.” ");
INSERT INTO ncf_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Iesu ga asaaiti ia, “Adi num nanen, num tinaalnge a se atoaa iu.” ");
INSERT INTO ncf_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tiwaa tsaa, a suk nanen ma ga amusili Iesu, ma ga lo paipaʼii Moroaa. Biaa no inaman araraa di ta lasi, di suk paʼii bula Moroaa. ");
INSERT INTO ncf_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iesu atsiga Jeriko, ma ga eses labatina inaman, ");
INSERT INTO ncf_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Iexa taamat tia iesan Sakias, lalaamua ina no unaalalet taakis ma ia untang. ");
INSERT INTO ncf_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","A we na suk lasi so sawaa ia Iesu, oro biaa ta pitpit, ga xap pupua amuina sin abia malep. ");
INSERT INTO ncf_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Biaabi ga suk sol laa laamua ma ga enngi iexa ie fik ngali lasi Iesu amuina Iesu naba es xaalame sin abia sal. ");
INSERT INTO ncf_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Biaa Iesu ta tsap sin abia xolot, a nanen laa lapalaa, ga suk paare sin ia, “Sakias, u na tsuul isagaa xaalame lapula. Iaa ba manman mii iu lalon num anua atalaa.” ");
INSERT INTO ncf_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Asuk tsuul isagaa lapula, ga suei atatoni Iesu laa tatan. ");
INSERT INTO ncf_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","No inaman araraa di lasi abia, di ga suk buriik weaatalaa, “Ilawaa taamat a se laa malen inawut lalon xan anua aia untsaxa.” ");
INSERT INTO ncf_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Oro Sakias a til ga asaaiti Orong, “Lasi Orong! Talaawaa iaa ba tali xolot axuuk ina nugu no mat maarang laa sin no muunwas. O nawe iaa tii se apanaai biexaal ma pulaxi xaa was, iaa ba xiis mulangena aet ina no xolot papan.” ");
INSERT INTO ncf_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Iesu ga paare sin ia, “Talaawaa, Atotoaa xa a se tsap nan abalaa anua, amuina ilawaa taamat bula, ia xan tsi taamat Abaram. ");
INSERT INTO ncf_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Xan Tsi Taamat a xaalame ngali tsalei ma atoaa abia di, di ta se xaxapinai.” ");
INSERT INTO ncf_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Biaa di ta lo lolong, Iesu ga asaaiti di taman abala totore puapua amuina a se atataaen Jerusalem, o no inaman di se adodo we, sauna mu xan Maradaan Moroaa naba se asemat. ");
INSERT INTO ncf_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ga paare, “Iexa manmanel ta ies lot, a laa lalon biexa inaman laba palpalaa ngali di ba axilangi ngali naba King o mil na mula. ");
INSERT INTO ncf_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Biaabi ga ilei xan no untutule ta sangaul, ga tali sangaul ina nen xuxute sin di xuxuuk, ga we, ‘Gim na taxaa taman abala no xuxute til sin leng iaa ba ta mula.’ ");
INSERT INTO ncf_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Oro xan no uk totore lalon abia xobel di ngutsulen ia ma di ga tulen biexaa inaman ngali laa asaaiti weaatalaa, ‘Giem palo ngali ilawaa taamat naba tsap nagiem king.’ ");
INSERT INTO ncf_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Oro, iwaa taamat a se tsap king ma ga se mula laa tatan. Mil ga ilei abia no untutule, biaa di ta ben taal xuxute sin di, ngali naba atii aisa di ta se atsapngen. ");
INSERT INTO ncf_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Lalaamua ina no untutule a xaalame, ga paare, ‘Nugu manmanel, iaa taxaa taman abia nen xuxute u ta tali sin iaa, ma ga tsap sangaul ina xuxute papan.’ ");
INSERT INTO ncf_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Manmanel a xisi, ‘Asuk axaau maase, nugu untutule axaau so, amuina u ta taxaa puaa ngali xosaraa abia tinaxaa dokdok, u ba laamuangen sangaul ina no inaman laba.’ ");
INSERT INTO ncf_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Nanaalua ina untutule a xaalame ma ga paare, ‘Nugu Manmanel, num nen xuxute a se atsapngen alima ina xuxute papan.’ ");
INSERT INTO ncf_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Manmanel a xisi, ‘U ba laamuangen no inaman laba ta lima.’ ");
INSERT INTO ncf_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Iexa untutule tii xaalame, ga paare, ‘Manmanel, biaa num nen xuxute abala, Iaa ngaati taman pu laplap ma iaa ga unngena. ");
INSERT INTO ncf_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Iaa suk mataa buxa amuina iu xoaat, u xaa adi no maarang u ta xap aturungi no, ma u xaa tataii senaara u ta xap soxaa.’ ");
INSERT INTO ncf_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Manmanel a xisi, ‘Iaa ba ininte sin num no totore tsaa, iu untutule morokon! U tii atixi weaatalaa, iaa taamat xoaat ma iaa xaa adi no maarang iaa ta xap aturungi no ma tataii abia no luxaal iaa ta xap soxaa no. ");
INSERT INTO ncf_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ngalisa u ta xap aturungi nugu xuxute lalon anuentang, ngali nawe iaa ba mula iaa ba alet mulangena xaa xuxute papan?’ ");
INSERT INTO ncf_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Mil ga paare ngali abia di, di ta tiltil atat, ‘Gim na alet mulangena abia nen xuxute sin ma gim na laa tali sin aia untutule xan no xuxute ta sangaul.’ ");
INSERT INTO ncf_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Di ga paare, ‘Manmanel, a se sangaul xan nen xuxute tsaa.’ ");
INSERT INTO ncf_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“A xisi, ‘Iaa asaaiti gim, sin no saa di ta iewas iaa ba tabiel buxaai di, oro ngali abia di, di ta xap iewas, no senaara ta tapkina no, iaa ba saali no sin. ");
INSERT INTO ncf_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Oro biaa nugu no matenkorot di ta xap saan ngali iaa ba tsap xadi king, gim na giwaa di xaalame ma gim na le sas amantei di laamuaan iaa!’ ” ");
INSERT INTO ncf_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Mil sin Iesu ta se paare taman abala, asuk es laamua laa lapalaa Jerusalem. ");
INSERT INTO ncf_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Iesu a se tsap atataaen Betapage ma Betani, sangan buk di ta putsangi Buk ina no Olip, ga tulen xan no tsi asasing ta lua, ga asaaiti delulu, ");
INSERT INTO ncf_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Gulu na laa lalon abia xobel laamuaan gululu, ma biaa gulu ba ta tsiga, gulu ba tatanginai donki dokdok xa ta xap mager tsotso papan, di ta pistali tia. Gulu na lubati sua ma gulu na xaalame taman. ");
INSERT INTO ncf_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nawe xa atsuraa gululu we, ‘Ngalisa gulu ta lubati donki dokdok,’ gulu na asaaiti, ‘Orong a saan ngali.’ ” ");
INSERT INTO ncf_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Biaa delulu, ta Iesu tulen laamuangen delulu, delu tatanginai malen ta se paatinai sin delulu. ");
INSERT INTO ncf_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Biaa delu ta lo lulubati donki dokdok, tapkina atsuraa delulu, “Ngalisa gulu ta lubati donki dokdok?” ");
INSERT INTO ncf_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Delulu xisi, “Orong a saan ngali.” ");
INSERT INTO ncf_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ma delu ga laamii xaalame sangan Iesu, delu aturungi xadelu no uga disdis papan donki dokdok ma delu ga aenngi Iesu. ");
INSERT INTO ncf_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Biaa Iesu ta se laa taman donki dokdok, no inaman di suk sulali xadi no uga disdis lalon sal laamuaan. ");
INSERT INTO ncf_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Biaa ta le tsap atataen abia xolot sal ta soriri papan Buk ina no Olip, biaa malep araraa ina no tsi asasing di suk atiltsoli ngali papaalam ma paʼii Moroaa taman xuupkup, ngali no axixila di tii se lasi. ");
INSERT INTO ncf_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Di xuup weaatala, “Atubudaani iwaa king ta xaalame sin iesan Orong!” “Malina lalon balalangit ma minaalam lapalaa suk se!” ");
INSERT INTO ncf_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Biexaa no Paarasi lalon abia malep, di paare sin Iesu, “Unaasasing, u na imii num no tsi asasing ngali di na bong.” ");
INSERT INTO ncf_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ga xisi di, “Iaa asaaiti gim, nawe di ba bong, no xaat di ba xuup lot.” ");
INSERT INTO ncf_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Biaa ta tsap Jerusalem o ga lasi inaman laba, asuk teng ngali, ");
INSERT INTO ncf_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ma ga paare, “Nawe gim nii se atii tsaa sin abala leng sawe naba tali malina sin gim, oro talaawaa axuxii lalon no matan gim. ");
INSERT INTO ncf_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","No leng naba ta xaalame, biaa nagim no matenkorot di ba tumaraa xa barateng ngali epuske mii gim ma ulti gim ma asuruti gim sin no daan xolot. ");
INSERT INTO ncf_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Di ba araabi gim laa lapula papan pula, gim mii nagim no tsi sangan nagim no xuur. Di ba xap poroklii xa xaat papan iexa xaat, amuina gim xap nen xilalaa xan leng Moroaa ngali xaalame sangan gim.” ");
INSERT INTO ncf_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Iesu ga tsiga lalon xolot lokobel ina Xan Anua Moroaa ma ga xalel atsuulngi no inaman di ta sune taman xadi no maarang. ");
INSERT INTO ncf_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ma ga asaaiti di, “Inaatel a paare, ‘Nugu anua, naba tsap anua ina sausawit.’ Oro gim se xosaraa, ga tsap malen ‘xadi lia no unpulapula.’” ");
INSERT INTO ncf_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Sin no leng xuxuuk, a xaa taal asasing lalon Xan Anua Moroaa. Oro no lalaamua ina no unsausawit, no unaasasing ina lo, ma no lalaamua labatina no inaman, di lo xonkonon ngali sas amantei ia. ");
INSERT INTO ncf_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Oro di ga xap pupua ngali tsalei xa sal ngali tsaapi, amuina no inaman araraa di taliil sin longlongmien xan no totore. ");
INSERT INTO ncf_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sin biexa leng biaa Iesu ta lo asingan no inaman ma babaais taman inesaait mamainaang nan xolot lokobel ina Xan Anua Moroaa, no lalaamua ina no unsausawit ma no unaasasing ina lo, mii no xusaak, di ga xaalame sangan ia, ");
INSERT INTO ncf_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","di ga paare, “Asaaiti giem, sin xan banam saa u ga xosaraa abala no maarang? Saa tali abala banam susum?” ");
INSERT INTO ncf_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ga xisi, “Iaa ba atsuraa gim bula taman xa atsutsura, gim asaaiti iaa, ");
INSERT INTO ncf_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","biaa xan axaxadaan Jon, axaal balalangit o axaal sin no inaman mu?” ");
INSERT INTO ncf_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Di etsura engen di, di ga paare, “Nawe gita we, ‘Axaal balalangit,’ naba atsuraa gita, ‘O ngalisa gim tii xap taltaalnge sin ia?’ ");
INSERT INTO ncf_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Oro nawe gita we, ‘Axaal sin no inaman mu,’ balawaa no inaman di ba suk pidi amantei gita taman no xaat, amuina di taltaalnge sin Jon we, ia propet.” ");
INSERT INTO ncf_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Di tii xisi, “Giem xap atii itaa Jon a adi.” ");
INSERT INTO ncf_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Iesu ga paare, “Iaa bula iaa ba xap asaaiti gim, sin sen banam iaa ga lo xoxosaraa abala no maarang.” ");
INSERT INTO ncf_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ga paare ngali no inaman taman abala totore puapua: “Taamat a soxaa uma waain ma ga bisi tali sin biexaa unbisbis ma ga se laa man adis palpalaa. ");
INSERT INTO ncf_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Sin leng ina papaas a tulen xan untutule laa sangan no unbisbis ina uma waain ngali di ba tali xaa waawaan waain ina abia uma sin ia. Oro no unbisbis di ga tsaapi ia ma di ga tulenlii gomsaai. ");
INSERT INTO ncf_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","A sebula tulen iexa untutule, oro iwaa bula di tsaapi ma di ga amangieli ma di ga tulen mulangenai gomsaai. ");
INSERT INTO ncf_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","A sebula tulen nanaatuul ina untutule ma no unbisbis di ga suk sas atsaxati ma di ga lii atsuulngi. ");
INSERT INTO ncf_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Iwaa tapkina uma waain ga paare ngali ia tsaa, ‘Iaa ba se xosaraa sa? Iaa ba se tulen nugu tsi, iwaa iaa ta titii buxaai, manaa di ba manglen!’ ");
INSERT INTO ncf_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Oro biaa no unbisbis lalon uma waain di ta lasi, di suk epaare ngen di, ‘Ilawaa se naba ta tapkina uma mil. Gita na sas amantei ngali gita ba tapkina abala no mat maarang.’ ");
INSERT INTO ncf_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Biaabi di ga lii atsuulngi nan uma, ma di ga sas amantei. “Iwaa tapkina uma waain naba se xosaraa sa sin di? ");
INSERT INTO ncf_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Naba xaalame ngali sas amantei abia no unbisbis ma naba tali abia uma waain laa sin biexaal.” Biaa no inaman di ta alongmen, di suk paare we, “Balawaa maarang na xap tsap!” ");
INSERT INTO ncf_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Iesu a nanen tutiik sin di ma ga atsuraa, “O sen muina ina abala totore biaa di ta atalaa: “ ‘Biaa xaat no untumtumar di tii palolii, biaa mu xaat a se tsap watwat ina anua.’ ");
INSERT INTO ncf_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Saa ia ta xol laa papan abia xaat, naba suk xamidimidi oro iwaa xa, xaat ta xol papan, naba suk xaxaitsa.” ");
INSERT INTO ncf_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","No unaasasing ina lo ma no lalaamua ina no unsausawit di tsalei xa sal ngali di ba suk tsiili esagaalen, amuina di se atii we biaa totore puapua ta xosaraa, a paatina ngali epuske mii di. Oro di mataatina no inaman. ");
INSERT INTO ncf_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Di man atataen ngali lo xoxoen ma di ga tulen no taamat biaa di ta xosaraa di malen di tutiik. Di adodo ngali tsiili Iesu sin xaka papaare ngali di ba tali ia sin xan xoror ma banam lalaamua ina gawaman. ");
INSERT INTO ncf_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ma biaa no taamat di ga atsuraa ia, “Unaasasing, giem atixi we u paare ma asasing taman sawe ta tutiik, ma u asen abia num uk saansaan ngali no inaman araraa o u asasing taman xan namaang Moroaa biaa ta asen soina. ");
INSERT INTO ncf_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","We, a tutiik ngali giem na uuli taakis laa sin Sisa, o a xap?” ");
INSERT INTO ncf_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Oro Iesu a se atii xadi no atsinaa ma ga asaaiti di, ");
INSERT INTO ncf_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Gim na asen xien xuxute. Nantanuaan saa ma iesan saa abia papan?” Di xisi, “Sisa.” ");
INSERT INTO ncf_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ga paare sin di, “Lowas, gim na tali sin Sisa sawe biaa xan Sisa ma gim na tali sin Moroaa sawe biaa xan Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Di xap pupua tsaa ngali atsinaa ia taman xan no totore labatina no inaman. Di suk olol sin abia xan xixiis, di ga suk bong. ");
INSERT INTO ncf_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Biexaa Saadusi di ta we a xap xa tinapaas mula sin minet, di xaalame sin Iesu taman biexa atsutsura, ");
INSERT INTO ncf_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Unaasasing, Moses atatal ngali giem, ga we, ‘Nawe xa taamat ametli xan tubu ma delu ga xap ie tsi, turamasen aia taamat naba sebula maxis sin aia aina nal, ngali delu na atsap ngen xakaa tsi aia turamasen ta se met.’ ");
INSERT INTO ncf_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tumasen turamasen detuu paasaalua, nan axuuk a setauan maxis sin iexa aina o ga metlii, ga xap ie tsi sin. ");
INSERT INTO ncf_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ma nanaalua ");
INSERT INTO ncf_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ma nanaatuul a sebula maxis sin ma sin abia uk sal mu, biaa tumasen turamasen ta paasaalua, di araraa di metli, di ga xap ie tsi paina. ");
INSERT INTO ncf_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mil aina bula asuk met. ");
INSERT INTO ncf_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Lowas, sin leng ina tinapaas mula sin minet, ilawaa aina xan tubu saa so ina di, amuina apaasaalua ina di se araraa di tii maxis sin?” ");
INSERT INTO ncf_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Iesu a xisi di, “No inaman sin abala nan ul di maxis ma di ba tali xadi no tsaana sin no minaxis. ");
INSERT INTO ncf_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Oro biaa di no saa, di ta sirawaa di ngali alet xolot sin abia nan ul ma lalon tinapaas mula sin minet di ba xap bula maxis o tali bula di sin minaxis, ");
INSERT INTO ncf_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ma di ba xap pupua ngali met bula amuina di se malen no angelo. Di xan no tsi Moroaa, amuina di no tsi ina tinapaas mula. ");
INSERT INTO ncf_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Oro Moses tsaa a asen abala taman tsintsin ina ie dokdok ta rar amuina a ilei Orong, ‘Xan Moroaa Abaram, ma xan Moroaa Aisak ma xan Moroaa Jakop.’ ");
INSERT INTO ncf_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","A xap ia xadi Moroaa no minet, oro ia xadi Moroaa no inaman di ta tino, amuina sin ia di araraa di tino.” ");
INSERT INTO ncf_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Biexaal ina abia no unaasasing ina lo, di we, “Unaasasing, u suk xiis axaautsi.” ");
INSERT INTO ncf_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","O xa ga xap bula atsuraa Iesu taman xaa atsutsura amuina di mataatinai xan no xixiis. ");
INSERT INTO ncf_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Mil Iesu ga paare ngali di, “Asen parawe di ga paare we, Karisito xan tsi Dewit? ");
INSERT INTO ncf_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Xan inaatel Dewit tsaa alengi sin Saam, “ ‘Orong a paare sin nugu Orong, “U na tsotso sin nugu lima mua ");
INSERT INTO ncf_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","til sin iaa ba ta xosaraa num no matenkorot malen xa niaan xutxutsiil.” ’ ");
INSERT INTO ncf_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dewit a putsangi ia, ‘Orong,’ Asen parawe, o mil ga tsap malen xan tsi?” ");
INSERT INTO ncf_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Biaa no inaman araraa di ta lo lolong, Iesu ga asaaiti xan no tsi asasing, ");
INSERT INTO ncf_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Gim na xoxo sin no unaasasing ina lo. Di saan ngali es asen di taman no uga disdis ta silal ma di ga saan ngali no inaman di na suei atatoni di na no xolot ina susune. Ma di saan bula ngali adi xalkale lot lalon no anua sausawit ma no xalkale ina mangmangle xa sin no xariin luxaal. ");
INSERT INTO ncf_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Di adaani no aina nal ngali xadi no anua ma di xosaraa no ningning disdis ngali asen we di no taamat pat oro asuk xap. Biaa no mat taamat weaatalaa, Moroaa naba suk ininte buxa sin di mil.” ");
INSERT INTO ncf_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iesu a nanen lapalaa ma ga lasi no untang di ta laa tali xadi no tinabel lalon niaan atuturung xuxute lalon Xan Anua Moroaa. ");
INSERT INTO ncf_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","A lasi bula iexa aina nal ta muunwas, ta aturungi nen toia ta lua. ");
INSERT INTO ncf_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Iesu ga we, “Iaa asaaiti gim taman so, ilawaa aina muunwas, a se aturungi xariin xuxute ngen biexaal. ");
INSERT INTO ncf_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Balawaa no inaman araraa di tali xadi no tinabel taman xolot ina xadi no minaas oro ngali ia, xaal sin xan muunwas a tali no maarang araraa naba ta tino sin no.” ");
INSERT INTO ncf_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Biexaal ina no tsi asasing, di tii lii no totore ngali Xan Anua Moroaa di ta amirmiri taman no xaat ta matmirmir ma no tinabel no inaman di ta tali sin Moroaa. Oro Iesu ga paare, ");
INSERT INTO ncf_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ngali no maarang gim ta lasi atalaa, biaa leng naba ta xaalame biaa naba ta xap xa xaat di na poroklii papan iexa, biaa no xaat araraa di ba lii no lapula.” ");
INSERT INTO ncf_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Di atsuraa, “Unaasasing, langisa abala no maarang naba tsap? Ma sen mat axixila naba asaait malen biaa maarang naba se tsap?” ");
INSERT INTO ncf_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ga xisi di, “Gim na xoxo, di ba soro apanaai gim. Amuina xuduxudu ina no inaman di ba xaalame sin iesaaga. Ma di ba we, ‘Iaa iwaa xa,’ ma, ‘Leng a se atat!’ Gim nangaam amusili di. ");
INSERT INTO ncf_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Biaa gim ba ta alongmen no maxil ma no mat xariin xirabas, gim nangaam mataa. Balawaa no mat laxen maarang naba setauan tsap, oro xapkap ina naba xap mager tsap!” ");
INSERT INTO ncf_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Mil ga asaaiti di, “Xobel labalaba di ba esas mii biexaa xobel labalaba, ma Maradaan di ba esas mii biexaa Maradaan. ");
INSERT INTO ncf_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","No xariin ninil, no xariin itol, ma no minet watwat bula naba tsap sin no daan xobel, ma no maarang ta tsap ta atsapngen minataa ma no mat xariin axixila xaal balalangit. ");
INSERT INTO ncf_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Oro laamuaan abala no araraa, di ba setauan tsiili gim, ma di ba xosor atsoti gim. Di ba tali gim lalon no anua sausawit ma di ba lii gim lalon no anua lodo, ma gim ba til laamuaan no king ma no lalaamua ina gawaman amuina sin iesaaga. ");
INSERT INTO ncf_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mil gim ba pupua ngali tiltsoxoti laa sin di. ");
INSERT INTO ncf_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Oro gim na atutiki nagim no adodo ngali xap lolbiir ngali taxaaturung setauan, ngali gim ba sen tilkaali wenangen gim tsaa. ");
INSERT INTO ncf_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Amuina iaa ba tali sin gim no totore ma sinaae ina nantanua biaa ta xap xa ina nagim no matenkorot naba pupua ngali epuske mii gim ma di na paare we gim abaa. ");
INSERT INTO ncf_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nagim no mom ma nagaa, no turamasen gim, ma nagim matenbung ma no turan gim, di ba babel tali gim sin no matenkorot, ma di ba sas amantei xaal ina gim. ");
INSERT INTO ncf_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","No inaman araraa, di ba ngutsulen gim amuina sin iesaaga. ");
INSERT INTO ncf_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Oro xa ulina xuaam naba xap liu! ");
INSERT INTO ncf_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nawe gim ba til watwat gim ba adi abia tino. ");
INSERT INTO ncf_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Biaa gim ba ta lasi no unmakmaxil di ta til ulti Jerusalem, gim ba atii we, a se atat ngali di ba se xosor atsoti xobel. ");
INSERT INTO ncf_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Gim na papaalii abia di lalon prowins Judaia di na sol laa papan no buk, gim na papaalii abia di nan inaman laba di na tsuul, ma biaa di nan no uma di na xap tsiga nan inaman laba. ");
INSERT INTO ncf_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Amuina leng se bala ngali xariin xirabas ngali xosor puaa malen no propet di tii atalaa. ");
INSERT INTO ncf_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Sin abia no leng naba suk mamaet buxa sin no aina di ta maet ma ngali no nagaa di ta asus! No inaman lalon abia xolot di ba saaen xariin sosong amuina Orong laba a se bal musteng sin abala inaman. ");
INSERT INTO ncf_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","No matenkorot di ba le sas amantei di taman bainat, ma di naa giwaa di laa lalon no anua lodo sin biexaa inaman labalaba. Ma no Gentail di ba le but tsaalen Jerusalem til sin no leng no Gentail di ba ta taxaa puaa. ");
INSERT INTO ncf_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“No axixila naba tsap sin matanios, uleng ma no xadaxada. Lalon balan pula, no inaman lalon no inaman labalaba di ba suk lolbiir ma adodo xuduxudu, amuina sin abia tengteng ina no xariin tuun ta xapas talaa lau. ");
INSERT INTO ncf_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","No inaman di ba met xiirkires taman minataa ma lolbiir biaa naba ta xaalame lalon xolkolmoxo amuina no maarang balalangit naba didiir. ");
INSERT INTO ncf_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Sin abia xolot ina leng, di ba lasi xan Tsi Taamat ta xaalame lalon xelangit taman xoror ma xan xariin minaalam. ");
INSERT INTO ncf_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Biaa no maarang ta se tiltsoli ngali tsap, gim na til laa lapalaa ma gim na nanen laa lapalaa amuina xan leng Moroaa a se xaalame atat ngali gii mulangenai gim.” ");
INSERT INTO ncf_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ga sebula asaaiti di taman abala totore puapua: “Gim na lasi xa ie fik ma biexaa ie bula. ");
INSERT INTO ncf_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Biaa gim ta lasi no xupis uul sin abia no ie, gim se atii we, no leng ina pal a se atat. ");
INSERT INTO ncf_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Malen bula, nawe gim lasi abala no maarang ta se lo tsaptsap, gim se atixi weaatalaa, xan Maradaan Moroaa a se atat. ");
INSERT INTO ncf_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Iaa asaaiti gim taman so, balawaa utmilmil, naba xap mager met, til sin balawaa no maarang naba ta setauan tsap. ");
INSERT INTO ncf_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Balalangit ma xolkolmoxo naba xap, oro nugu no totore naba so laaliu. ");
INSERT INTO ncf_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Gim na tilaamamil, o nagim no butsa na xap mamaxet taman nunun daan watwat ma gim na ngong, ma gim na xap lolbiir ngali no maarang sin abala balan pula. Balawaa leng naba soro alolaa gim malen atsinaa. ");
INSERT INTO ncf_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Balawaa maarang naba xaalame papan abia di araraa di ta man lalon abala balan pula. ");
INSERT INTO ncf_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Gim na tigiri xoxo ma sausawit ngali gim ba pupua ngali sol poroklii no sawe naba ta tsap. Ma gim ba pupua ngali til laamuaan Xan Tsi Taamat.” ");
INSERT INTO ncf_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Sin no leng xuxuuk, Iesu asingan no inaman lalon Xan Anua Moroaa o nan no nale a se xaa laa man lapalaa papan Buk ina no Olip. ");
INSERT INTO ncf_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ma no inaman araraa di xaa xaalame nan no lawaareng tsaa ngali alongmen xan no asasing lalon Xan Anua Moroaa. ");
INSERT INTO ncf_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Leng a se atat ngali Luxaal ina Tsoki ta xap xa Iis, di putsangi Luxaal ina Esliwaa. ");
INSERT INTO ncf_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","O no lalaamua ina no unsausawit ma no unaasasing ina lo di lo nanen ngali xa sal ngali di ba sas amantei Iesu, oro di mataatina no inaman. ");
INSERT INTO ncf_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Mil Saatan ga tsigaii Judas, biexa iesan Iskariot, ia ina abia xan no tsi asasing ta sangaul ma ga laa lua. ");
INSERT INTO ncf_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ma Judas ga se laa sangan no lalaamua ina no unsausawit ma no unxoxo ina Xan Anua Moroaa, ga papaare mii di ngali sen sal naba amusili ngali naba babel tali Iesu. ");
INSERT INTO ncf_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Di suk taton ma di ga engit ngali di ba tali xaa xuxute sin. ");
INSERT INTO ncf_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ga siir ma ga nanen tsalei xa sal biaa ta xap xa malep tia. ");
INSERT INTO ncf_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Leng a se tsap ngali Luxaal ina Tsoki ta xap xa Iis. Balawaa leng ina Esliwaa di ba tsutsungit tali xa sipsip dokdok malen tinabel. ");
INSERT INTO ncf_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Iesu a tulen Pita ma Jon, ga paare, “Gulu laa taxaaturungi Luxaal ina Esliwaa ngali angen sin gita.” ");
INSERT INTO ncf_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Delu atsuraa, “U saan ngali itaa gelu ba laa taxaaturungi luxaal?” ");
INSERT INTO ncf_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ga xisi delulu, “Nawe gulu se tsiga lalon inaman laba, taamat ia naba ta sabasue gululu ta atsaxei sobuk daan. Gulu na amusili laa lalon abia anua naba ta tsiga lalon. ");
INSERT INTO ncf_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ma gulu na asaaiti aia tapkina anua weaatalaa, ‘Unaasasing atsura, inaabi xadi xabin no inawut, ngali iaa ba le ngani Luxaal ina Esliwaa lalon mii nugu no tsi asasing?’ ");
INSERT INTO ncf_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Naba asen gululu taman xariin xabin biaa ta manman lapalaa lalon abia anua mii no mat maarang araraa ta se manman. Gulu na laa taxaaturungi luxaal atia.” ");
INSERT INTO ncf_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Delu poroklii di ma delu ga laa tatanginai abia no maarang malen Iesu ta se asaaiti delulu tsaa. Ma delu ga taxaaturungi Luxaal ina Esliwaa. ");
INSERT INTO ncf_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Biaa aua a se tsap o Iesu mii xan no aposal di se xale ngali angen. ");
INSERT INTO ncf_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","O ga asaaiti di, “Iaa suk saan buxa ngali ngani abala Luxaal ina Esliwaa mii gim setauan o mil iaa na adi xariin sosong. ");
INSERT INTO ncf_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Iaa asaaiti gim, iaa ba xap ngani bula abala Luxaal ina Esliwaa pupua sin ta tatanginai abia ta se taxaa puaa no lalon xan Maradaan Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Iesu adi sobuk taman waain ma ga putsangi axaau laa sin Moroaa ma ga we, “Gim na adi abala ma gim na exasen labatina gim. ");
INSERT INTO ncf_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Iaa asaaiti gim, iaa ba xap nun waain bula pupua sin xan Maradaan Moroaa naba ta xaalame.” ");
INSERT INTO ncf_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Iesu adi tsoki, ga putsangi axaau, atsabaxi ma ga tali sin di, ga paare, “Balawaa isuaaga, iaa ta tali sin gim. Gim na xosaraa abala ngali adodomi iaa.” ");
INSERT INTO ncf_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Sin abia uk sal mulina luxaal, a adi sobuk, ga paare, “Balawaa sobuk ina nugu dal, ngali xuxubu uul, a tamkabare ngali gim. ");
INSERT INTO ncf_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Oro biaa liman aia xa, iwaa naba ta babel tali iaa bala mii iaa papan ibe angangen. ");
INSERT INTO ncf_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Xan Tsi Taamat naba met malen Moroaa ta se xubatsi. Oro xariin xirabas sin aia xa ta babel tali ia sin no matenkorot.” ");
INSERT INTO ncf_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","O di ga etiirik engen di, “Saa so labatina gita naba xosaraa abala namaang morokon?” ");
INSERT INTO ncf_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Mil biexa mamaet asuk tsap labatina di ngali saa so ina di asuk lot buxa. ");
INSERT INTO ncf_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Iesu ga paare sin di, “Xadi no king no Gentail di orong papan di, o biaa di ta ie banam papan di, di putsangi di tsaa no untamtabiel. ");
INSERT INTO ncf_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Oro gim nangaam malen di. Oro, iwaa ta suk lot buxa labatina gim, na xosaraa adokdoki malen tsi dokdok, ma iwaa ta lalaamua na malen iwaa untutule mu. ");
INSERT INTO ncf_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Saa suk lot buxa, iwaa xa ta xale papan ibe angangen o iwaa untutule? Iwaa xa ta tsotso ma angangen papan ibe. Aso abia? Oro iaa manman labatina gim malen xa untutule. ");
INSERT INTO ncf_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Gim abia no inaman gim tii til mii iaa sin nugu no xonkonon. ");
INSERT INTO ncf_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","O iaa ba tali Maradaan malen nugu mom tii tali sin iaa, ");
INSERT INTO ncf_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ngalibi gim ba angen ma nun mii iaa papan nugu ibe angangen lalon nugu Maradaan ma gim ba tsotso lalon no xalkale ngali ininte sin sangaul ma ga laa lua ina xan no matenbung Israel.” ");
INSERT INTO ncf_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ga paare, “Saimon, Saimon, Saatan a se atsura ngali gisi iu malen wit. ");
INSERT INTO ncf_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Oro iaa se sawit ngali iu ngali num tinaalnge naba xap met. O biaa u ba ta se mula, u na awatwati num no taamat.” ");
INSERT INTO ncf_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Oro a xisi, “Orong, iaa taxaaturung ngali laa lalon anua lodo ma ngali minet!” ");
INSERT INTO ncf_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Iesu a xisi, “Iaa asaaiti iu, Pita, puraa naba xap mager teng, ma u ba uliis nanaatuul we u xap atii iaa.” ");
INSERT INTO ncf_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Mil Iesu ga tiiriki di, “Biaa iaa tii tulen gim ngali laa baais taman Inesaait Mamainaang, gim tii xap adi xa paakpaak o xa tutuel ma xa bubut. O gim tii muun tsaa ngali xawas?” Di ga xisi, “Asuk xap!” ");
INSERT INTO ncf_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ma ga paare ngali di, “O nawe xa ina gim a ie xa paakpaak ma xa tutuel bula, u na adi. O nawe xa a xap xaka tetel ngali sas, na sune taman xan uga disdis ngali uuli xaka. ");
INSERT INTO ncf_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Iaa asaaiti gim, sawe Inaatel Pat ta paare taman ngali iaa, ‘O di ga xoxot tali mii no unlaklaxei lo;’ ma asaaiti gim balawaa naba taxaa puaa malen no propet di tii paare taman iaa. Iou, sawe di tii atalaa taman iaa, naba se tsap so.” ");
INSERT INTO ncf_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Xan no tsi asasing di ga paare, “Orong, no tetel bala ta lua.” O ga xisi, “A se pupua.” ");
INSERT INTO ncf_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iesu a sebula es laa papan Buk ina no Olip ma xan no tsi asasing di ga amusili. ");
INSERT INTO ncf_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Biaa di ta se tsap nan abia xolot o ga paare ngali di, “Gim na sawit ngali gim ba xap xol lalon no xonkonon.” ");
INSERT INTO ncf_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ga papaalii di, ga laa palpalaa dokdok mu, ga sage putput ma tii ga sawit, ");
INSERT INTO ncf_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Mom, nawe u siir, u na adi abala sobuk sin iaa. Oro nangaam amusili nugu sirsiir, u na amusili num sirsiir tsaa.” ");
INSERT INTO ncf_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","O angelo in balalangit a le asemat sin ma ga awatwati ia. ");
INSERT INTO ncf_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ma ga saaen xariin mamaet papan ma ga suk sawit watwat. O xan malangitsa ga suk tuul malen dal sin no isuaan ga xol papan pula. ");
INSERT INTO ncf_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Biaa ta tapaas ga mula laa sangan no tsi asasing, ga tatanginai di, di ta se urange met taman lolbiir. ");
INSERT INTO ncf_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Atsuraa di, “Ngalisa gim ta urange? Gim tapaas ma gim na sawit ngalibi gim ba xap xol sin no xonkonon.” ");
INSERT INTO ncf_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Biaa Iesu ta lo papaare tsaa, biaa malep di suk tsap mii iwaa taamat di ta putsangi Judas, ia ina abia sangaul ma ga laa lua, tii laamuangen di. A le tsap sangan Iesu ma ga nguri ia. ");
INSERT INTO ncf_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Oro Iesu ga atsuraa ia, “Judas, u babel tali Xan Tsi Taamat taman u ta nguri?” ");
INSERT INTO ncf_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Biaa no tsi asasing di ta lasi samaarang naba ta tsap o di ga paare, “Orong, axaau ngali giem ba sas taman nagiem no tetel?” ");
INSERT INTO ncf_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","O iexa ina di ga adi xan tetel ma ga ritlii talinga mua ina xan untutule unsausawit lapalaa. ");
INSERT INTO ncf_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Oro Iesu ga xisi, “Nangaam xosaraa bula abala,” ma ga taxaanai talingan ma ga atoaa ia. ");
INSERT INTO ncf_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Mil Iesu ga paare sin abia no lalaamua ina no unsausawit ma no unxoxo ina Xan Anua Moroaa ma biaa no xusaak, di ta xaalame ngali tsiili, “Iaa laamungen xa inesas biaa gim ga xaalame taman no tetel ma no bom? ");
INSERT INTO ncf_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Sin no daan leng iaa xaa manman mii gim lalon no xolot ina Xan Anua Moroaa o gim ga xap muun tsiili iaa. Oro nagim aua a se bala biaa lodo naba ta ie banam.” ");
INSERT INTO ncf_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Mil di ga tsiili Iesu ma di ga giwaa ia laa lalon xan anua unsausawit lapalaa, o Pita ga lo es amamil palaaen di. ");
INSERT INTO ncf_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Oro biaa no inaman di ga taangi ie labatina biexa xolot lokobel ina xan anua unsausawit ma di ga xale exumule, Pita tii se le tsotso mii di. ");
INSERT INTO ncf_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Iexa tsaana untutule a lasi Pita ta tsotso tia sangan abia ie ta rarar ma ga nen axaautsi Pita, o ga we, “Ilawaa taamat bula tii manman mii ia.” ");
INSERT INTO ncf_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Oro Pita ga uliis. A paare, “Aina, iaa xap atii ia.” ");
INSERT INTO ncf_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Manman dokdok, iexa taamat a sebula lasi Pita ga we, “Iu bula ina di.” Pita ga xisi, “Taat, iaa a xap.” ");
INSERT INTO ncf_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nap dokdok mu, iexa taamat a paare watwat, “Asuk so maase, ilawaa taamat mu tii manman mii Iesu. Ia in Galili.” ");
INSERT INTO ncf_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pita ga sebula xisi, “Taat, iaa xap atii samaarang abia u ta totore taman!” O biaa ta lo papaare tsaa, puraa asuk teng. ");
INSERT INTO ncf_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Orong a putsi ma ga nanen laa tutiik sin Pita. Mil Pita ga suk adodomi xan totore Orong tii ben paare taman. “Puraa naba xap mager teng talaawaa o u ba paare nan a tuul we, u xap atii iaa.” ");
INSERT INTO ncf_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ma ga tsuul laa lokobel ma ga suk teng lolbiir. ");
INSERT INTO ncf_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Biaa no taamat di ta xoxo sin Iesu di tore reret ma di ga ririiti ia. ");
INSERT INTO ncf_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Di ngaati no matan taman laplap ma di ga atsuraa weaatala, “U na asen we iu propet. Saa ina giem a pantsi iu?” ");
INSERT INTO ncf_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","O di ga lii no mat papaare tsaxa sin ia. ");
INSERT INTO ncf_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Biaa ta se tampanek, no xusaak ina no inaman mii no lalaamua ina no unsausawit ma no unaasasing ina lo, di tsap esuei araraa o di ga giwaa Iesu ngali le til laamuaan di. ");
INSERT INTO ncf_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Di paare ngali, “Nawe iu Karisito, u na asaaiti giem.” Iesu a xisi, “Nawe iaa asaaiti gim, gim ba xap taltaalnge sin iaa, ");
INSERT INTO ncf_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ma nawe iaa atsuraa gim, gim ba xap xisi. ");
INSERT INTO ncf_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Oro atiltsoli atalaa xan tsi taamat naba tsotso sin papel lima mua sangan Moroaa iwaa Belaba.” ");
INSERT INTO ncf_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Di araraa di ga atsuraa, “Aso abia iu Xan Tsi Moroaa, ngaa?” Ga xisi, “Gim paare tutiik we, iaa iwaa xa.” ");
INSERT INTO ncf_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Mil di ga suk paare weaatalaa, “Gita na xap ilei xa taamat bula ngali le paare leng taman ia. Gita se alongmen xan no totore, ia tsaa ta se paatina.” ");
INSERT INTO ncf_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Mil no lalaamua araraa di tii ga tapaas ma di ga laamuangen ia laa sangan Pailat. ");
INSERT INTO ncf_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ma di ga atiltsoli ngali atuti, di ga paare, “Giem tatanginai ilawaa taamat abaa laa sin xida inaman labalaba. Ga tilbanti nagiem no inaman ngali di na xap uuli taakis laa sin Sisa ma ga paare, ‘Iaa Karisito ma king.’ ” ");
INSERT INTO ncf_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pailat ga atsuraa Iesu, “Aso iu xadi king no Jiu?” Iesu ga xisi, ga we, “Biaa totore u ta paatina, biaa aso.” ");
INSERT INTO ncf_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","O Pailat ga paare laa sin no lalaamua ina no unsausawit ma biaa malep, “Iaa xap tatanginai xawas na tsaxa sin aila taamat.” ");
INSERT INTO ncf_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Oro di ga sebula paare watwat, “Ilawaa taamat asing atsoti no inaman araraa lalon prowins Judaia ngali xosaraa mamaet. Atiltsoli xaal Galili o ga se xaalame araraa ataala.” ");
INSERT INTO ncf_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat alongmen abala o ga tiiriki di, “Ilawaa taamat ia in Galili?” ");
INSERT INTO ncf_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","O biaa Pailat ta se sinaae we Iesu ia in Galili, asuk tulen laangen sin Erot amuina Erot ia gawana ina prowins Galili. O sin abia leng Erot tii manman bula tia Jerusalem. ");
INSERT INTO ncf_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Biaa Erot tii lasi Iesu, asuk taton amuina saapuaa ta wena lasi Iesu. Tii alongmen Iesu ta xoxosaraa no axixila xoror, ma ga saan ngali Iesu na xosaraa xaa axixila xoror sangan. ");
INSERT INTO ncf_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Asuk atsuraa Iesu taman no daan atsutsura, oro Iesu ga xap xisi tsaa xa totore. ");
INSERT INTO ncf_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","No lalaamua ina no unsausawit ma no unaasasing ina lo di tiltil tia ma di ga lii no totore tsaxa ngali atuti ia. ");
INSERT INTO ncf_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Erot ma xan no unmakmaxil di paare amagurusiki ma di ga rereti ia. Di alen tali uga disdis ta suk matmirmir sin ma di ga tulen mulangen laa sangan Pailat. ");
INSERT INTO ncf_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Setauan Erot tii xaa matenkorot mii Pailat, o sin abia leng, delu suk tsap lomasen turan axaau. ");
INSERT INTO ncf_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailat a ilei axumuli no lalaamua ina no unsausawit mii xadi no lalaamua no inaman, ma no inaman bula, ");
INSERT INTO ncf_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","o ga asaaiti di, “Gim gii tali ilawaa taamat sin iaa ma gim ga we, ‘A xosaraa atsoti xadi adodo no inaman ma di ga palolii gawaman.’ Iaa se ininte lalon no matan gim o iaa ga xap tatanginai xawas ngali asen ta xosor atsoti malen gim tii se paare. ");
INSERT INTO ncf_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erot bula a xap tatanginai xawas na tsaxa sin o ga sebula tulen mulangena xaalame sangan giem malen gim ta se lasi. Giem lasi ilawaa taamat a xap xosaraa xawas na tsaxa ngali na met. ");
INSERT INTO ncf_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Biaabi iaa ba ririiti o mil iaa na aleiwaa ia.” ");
INSERT INTO ncf_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Di araraa di xuup lot we, “Saali ia laa! Aleiwaa Baraabas xaalame sin giem!” ");
INSERT INTO ncf_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Baraabas di tii lii lalon anua lodo amuina tii atapaasi maxil lalon inaman laba ma ngali tii ga sas amantei iexa taamat bula.) ");
INSERT INTO ncf_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailat a saan ngali aleiwaa Iesu o ga sebula asaaiti di we, “Iesu a xap xosaraa xawas na tsaxa.” ");
INSERT INTO ncf_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Oro, no inaman di lo xuupkup tsaa, “Ataxiwaa ia! Ataxiwaa ia!” ");
INSERT INTO ncf_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pailat a sebula paare nanaatuul laa sin di: “Ngalisa? Sen mat namaang tsaxa a xosaraa? Iaa xap tatanginai xa mamaxet sin, ngali iliil ina xan minet. Biaabi Iaa ba ririiti mu ia, ma inaa aleiwaa.” ");
INSERT INTO ncf_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Oro di lo xuupkup tsaa laa sin Pailat ngali di na ataxiwaa Iesu papan tongol. Xadi no xuupkup asuk watwat ma Pailat ga putsi xan adodo. ");
INSERT INTO ncf_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Biaabi ga adodo ngali xosor puaa xadi atsutsura. ");
INSERT INTO ncf_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","A aleiwaa aia taamat tii ben manman lalon anua lodo sin tii xosaraa maxil ma ga sas amantei iexa taamat, iwaa taamat di ta atsura ngali. Ma ga tali Iesu sin xadi sirsiir. ");
INSERT INTO ncf_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Biaa di ta gii laangen Iesu, di suk tsiili Saimon in Sairin, iwaa ta wena laa Jerusalem xaal lokobel. Di aturungi tongol papan ma ga atsaxei mulina Iesu. ");
INSERT INTO ncf_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Xariin malep ina inaman di es amusili ia mii no aina biaa di ta teng lolbiir buxa ngali ia. ");
INSERT INTO ncf_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Iesu a putsi ga paare sin di, “No aina in Jerusalem, gim nangaam teng ngali iaa. Gim na teng ngali gim tsaa ma nagim no tsi. ");
INSERT INTO ncf_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ngali leng naba ta xaalame biaa gim ba ta paare we, ‘Atubudaani biaa no aina nal biaa xadi no laalaatsi ta xap alalet madalak ma biaa di ta xap xaa asus!’ ");
INSERT INTO ncf_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mil “ ‘Di ba paare laa sin no buk, “Gim na xol papan giem!” Ma sin no buk dokdok, “Gim na baaii giem.”’ ");
INSERT INTO ncf_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ngali nawe no inaman di xosaraa no maarang biaa ie ta tuo tsaa, sawe naba tsap nawe a malang?” ");
INSERT INTO ncf_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Alua no unlaklaxei lo di gii atsuulngi bula delulu ngali laa ataxiwaa mii Iesu. ");
INSERT INTO ncf_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Biaa di tii se le tsap lalon abia xolot di ta putsangi, ‘Barang′, di suk ataxiwaa Iesu papan tongol mii abia no unpulapula ta lua, iexa sin papel lima mua ma iexa sin papel lima xaiaar. ");
INSERT INTO ncf_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Iesu ga paare weaatalaa, “Nugu Mom, u na adodolii xadi namaang tsaxa amuina di xap nen xilalaa sawe di ta xosaraa.” O no unmakmaxil di sar uraura ngali adi xan no uga Iesu. ");
INSERT INTO ncf_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","No inaman di lo limlim, o no lalaamua ina no Jiu, di ga lo ngongopai Iesu, di ga we, “Tii aleiwaai biexaal o talaawaa na aleiwaa ia tsaa ngali asen malen ia Mesaia, Moroaa tii se axilangi.” ");
INSERT INTO ncf_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","No unmakmaxil bula di rereti ia, di ga xaalame sangan ma di ga tali waain manuul sin, ");
INSERT INTO ncf_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ma di ga we, “Nawe iu xadi king no Jiu, u na aleiwaai iu tsaa!” ");
INSERT INTO ncf_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Biexa atatal di atalaa lapalaa ina ia, a paare we: “Ilawaa, xadi king no Jiu.” ");
INSERT INTO ncf_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Iexa ina abia no unpulapula delu tii taxiu mii ia, ga rereti ia, ga paare, “Asen parawe, a xap iu Karisito? U na atoaa gita ta tuul.” ");
INSERT INTO ncf_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Oro iexa ina delulu alongmen iwaa turan ta paare, asuk imii, ga we, “Asen parawe, u xap mataatina Moroaa? Gita ta tuul arie gita adi abia uk ininte. ");
INSERT INTO ncf_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","O di ataxiwaa gitaa ngali xidaa no namaang tsaxa, oro ilawaa taamat a xap xosaraa xa namaang tsaxa.” ");
INSERT INTO ncf_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mil ga asaaiti, “Iesu, u na adodomi iaa, biaa u ba ta tsiga lalon num Maradaan.” ");
INSERT INTO ncf_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Iesu ga xisi ia, “Iaa suk asaaiti iu taman so, talaawaa tsaa u ba manman mii iaa lalon xobel geramis buxa.” ");
INSERT INTO ncf_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","A se 12 kilok lasiaat o xobel araraa tii suk lodo laa pupua sin 3 kilok nale, ");
INSERT INTO ncf_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","amuina matanios a se xap tsila o biaa taago lalon Xan Anua Moroaa asuk tater laa sin no xolot ta lua. ");
INSERT INTO ncf_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Iesu asuk ilei lot, “Mom, ‘iaa tali nantanuaaga papan no limaam.’ ” O biaa tii se paare xap taman abala, a suk met. ");
INSERT INTO ncf_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Iexa lalaamua ina no unmakmaxil a lasi sawe ta tsap, ma ga suk paʼii Moroaa, ga paare, “Asuk so maase, ilawaa taamat asuk tutiik!” ");
INSERT INTO ncf_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Biaa no inaman di tii tsap exumule ngali le tiltsoxoti di ngali lasi sawe tii tsap, o di ga mula laa tatan di, di ga pantsi no bongbongon di taman xariin lolbiir. ");
INSERT INTO ncf_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","O biaa no inaman araraa di ta atii Iesu, mii no aina bula di ta amusili xaal Galili, di rom til palpalaa ma di ga matngen abala no maarang. ");
INSERT INTO ncf_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Iexa taamat iesan Josep in Arimatia ina prowins Judaia, asuk taamat mamainaang ma a tutiik, ma ga lo liliis ngali xan Maradaan Moroaa. Ia bula ina kaunsel, oro tii xap ukbal biaa di ta inten ngali ataxiwaa Iesu. ");
INSERT INTO ncf_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","A laa sangan Pailat ma ga atsuraa ngali naba adi xan pakpak Iesu ngali naba laa punami. ");
INSERT INTO ncf_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Adi papan tongol xaalame lapula ma ga ngaati taman laplap, o ga aturungi lalon biexa lia di tii xosaraa lalon no xaat. Biaa lia pupuna di tii xap mager aturungi xa tongaan lalon. ");
INSERT INTO ncf_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Balawaa leng ina taxaaturung ngali Saabat o Saabat naba se atiltsoli. ");
INSERT INTO ncf_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","O biaa no aina di tii xaal Galili mii Iesu, di amusili Josep, ma di ga lasi abia lia pupuna ma di ga lasi di ta sen atetei wenangen xan pakpak Iesu. ");
INSERT INTO ncf_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Mil di mula laa lokobel ngali laa taxaaturungi no mat laxen tubatuba ma daan ta tso mamainaang. Oro di iaawis sin abia Saabat ngali long amusili xan no lo Moroaa. ");
INSERT INTO ncf_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sin Sande lawaareng bingbing, no aina di adi abia no tubatuba tso di tii taxaaturungi, ma di ga laa lalon lia pupuna. ");
INSERT INTO ncf_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Di laa tatanginai xaat xa ta se puxenlii sin lia pupuna. ");
INSERT INTO ncf_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","O biaa no aina di ta tsiga, di xap muun laa tatanginai xan pakpak Orong Iesu. ");
INSERT INTO ncf_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Biaa di ta lo tiltil atia ma adodo xuduxudu sin abala maarang, a xap sauna mu, o no taamat alua, delu suk le til sangan di. Xadi no uga disdis asuk tsila buxa malen tsilatsila. ");
INSERT INTO ncf_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","No aina di suk mataa buxa ma di ga sage putput ma di ga tudu matngen pula. Oro biaa lo taamat, delulu ga paare ngali di, “Ngalisa gim ta nanen ngali iwaa taamat ta tino labatina no inaman di tii se met? ");
INSERT INTO ncf_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","A xap manman atala, a se tapaas mula! Gim na adodomi sawe tii asaaiti gim taman, biaa gim tii manman tsaa mii gim lalon prowins Galili, ");
INSERT INTO ncf_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Di ba tali Xan Tsi Taamat sin no taamat tsaxa ngali di ba ataxiwaa papan tongol, o sin nanaatuul ina leng naba tapaas mula.’ ” ");
INSERT INTO ncf_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Biaa di ta alongmen abala, di suk adodomi abia xan no totore. ");
INSERT INTO ncf_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Biaa di ta se mula xaal lalon lia pupuna, di suk asaait taman abala no maarang araraa sin no tsi asasing ta sangaul axuuk ma ga laa xuuk ma biexaal. ");
INSERT INTO ncf_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ilaa Maria Magdalin, Joana, ma Maria xan nagaa Jeims, mii biexaal bula mii di. Di tii asaaiti no aposal taman. ");
INSERT INTO ncf_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","O no tsi asasing di we xadi no totore no aina a malen no papaare gomsaa mu ma di ga xap taltaalnge sin. ");
INSERT INTO ncf_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Oro Pita atapaasi ma ga suk sol laa lalon lia pupuna, atudu ma ga lasi no laplap di ta isi Iesu taman ta matmatuul mu tia. Adodo sin ia tsaa, samaarang abala ta suk tsap o ga es mula. ");
INSERT INTO ncf_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Sin abia uk leng, no tsi asasing ta lua, delu es laa lalon biexa xobel Emaus, disdis ina abia sal xaal Jerusalem a pupua malen sangaul ma ga laa xuuk ina kilomita. ");
INSERT INTO ncf_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Delu eses ma delu ga lo papaare taman abia no maarang ta tsap. ");
INSERT INTO ncf_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Biaa delu ta lo epaare engen delulu, Iesu tsaa tii xaalame ma ga le estsomi delulu laa, ");
INSERT INTO ncf_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","oro Moroaa atilxaali ngali delulu ba xap pupua ngali nen xilalaa ia. ");
INSERT INTO ncf_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","O ga atsuraa delulu, “Samaarang abia gulu ta es papaatinai lalon sal?” Delu tilwat ma no matan delulu asuk mat malen delu suk lolbiir buxa. ");
INSERT INTO ncf_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Iexa ina delulu, iesan Kilipas atsuraa Iesu, “Manaa iu mu ta xuuk u ta limlim Jerusalem u ta xap atii abala no maarang ta tsap sin abala no leng?” ");
INSERT INTO ncf_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Iesu ga atsuraa, “No sen mat maarang abia?” Delu xisi Iesu, “Biaa no maarang ta tsap sin Iesu lalon xobel Nasaret. Ia propet, ma xan no totore a ie xoror ma ga xosaraa no axixila xoror bula laamuaan Moroaa ma no inaman araraa bula. ");
INSERT INTO ncf_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","No lalaamua ina no unsausawit ma nagiem no lalaamua, di tali ia ngali di na ininte sin ngali na met ma di tii ga ataxiwaa pan tongol. ");
INSERT INTO ncf_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Oro giem taalnge we ia mu naba ta gii mulangen no inaman Israel. O balawaa nanaatuul ina leng sin balawaa no maarang araraa ta tsap. ");
INSERT INTO ncf_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ma biexa was, biexaa aina ina giem, di alolaa giem. Di ta laa lawaareng bingbing lalon lia pupuna, ");
INSERT INTO ncf_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","oro di ga xap tatanginai xan pakpak, ma di ga xaalame, di ga le asaaiti giem we di lasi nanen binalang ina no angelo, di ta we, a se tapaas mula. ");
INSERT INTO ncf_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","O biexaal ina giem di ga laa lalon lia pupuna, di ga laa tatanginai lia xonone, malen mu no aina di tii asaait oro di tii xap lasi ia.” ");
INSERT INTO ncf_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ga paare ngali delulu, “Gulu suk tangtangabaa ma gulu ga xap taltaalnge lalon nugululu no butsa sin xadi no totore no propet, ");
INSERT INTO ncf_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","biaa Karisito naba adi abia xariin mamaet o mil na tsigaii xan minaalam.” ");
INSERT INTO ncf_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ma ga asaait alengi delulu taman sawe Inaatel Pat ta asaait taman ngali ia tsaa. Atiltsoli sin Moses ma no propet araraa. ");
INSERT INTO ncf_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Detuu se xaalame atataaen xobel delu ta wena laa lalon o Iesu ga se xonon ngali es laa tsaa. ");
INSERT INTO ncf_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Oro delu ga suk ningi awatwati ngali naba manman mii delulu, amuina a se nale ma bing bula a se xaalame atat. O Iesu ga se manman mii delulu. ");
INSERT INTO ncf_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Biaa ta lo xalkale mii delulu, adi tsoki, ga putsangi axaau sin Moroaa, atsabaxi ma ga atiltsoli ngali tabali delulu taman. ");
INSERT INTO ncf_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Mil xadelu no matan asuk tsalel ma delu ga suk nen xilalaa ia, oro Iesu asuk maraamen sangan delulu. ");
INSERT INTO ncf_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Delu ga etore engen delulu tsaa, “Asuk so maase, gita tii suk taton buxa lalon xida no butsa biaa tii eses mii gitaa lalon sal ma ga lo papaare sin gitaa taman no totore xaal lalon Inaatel Pat.” ");
INSERT INTO ncf_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Delu tapaas isagaa ma delu ga mula laa Jerusalem, ma delu ga laa tatanginai sangaul axuuk ma ga laa xuuk ina no tsi asasing mii biexaa inaman di ta man etudim. ");
INSERT INTO ncf_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Delu laa tsap o delu ga asaaiti di, “Asuk so maase, Orong a se tapaas mula! Ma tii ga asemat sin Saimon!” ");
INSERT INTO ncf_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","O mil, biaa no taamat ta lua, delu ga asaaiti di taman sa maarang ta tsap sin delulu lalon sal laa Emaus ma delu tii sen nen xilalaa we Iesu, biaa tii tsabaxi tsoki. ");
INSERT INTO ncf_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Biaa di ta lo totore tsaa taman abala maarang, o Iesu tsaa asemat ma ga til labatina di, ga paare, “Malina na manman mii gim.” ");
INSERT INTO ncf_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Di suk tunga ma di ga suk mataa buxa amuina di soro we di lasi xa tongaan. ");
INSERT INTO ncf_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","O ga paare ngali di, “Ngalisa gim ta mataa? Ma ngalisa gim ta xap taltaalnge lalon nagim no butsa? ");
INSERT INTO ncf_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Gim na lasi no limaaga ma no xaʼigi. Iaa mu Iesu. Gim na taana iaa ngali gim ba atii. No tongaan di xap ie pines ma tuen o gim lasi, iaa taamat toto.” ");
INSERT INTO ncf_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Mil sin ta paare weaatalaa ga asen no liman ma no xaden. ");
INSERT INTO ncf_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","O di ga xap taltaalnge tsaa amuina di suk olol ma taton buxa. O Iesu ga ningi di, “Xaa luxaal biaa tia ngali iaa ba ngani?” ");
INSERT INTO ncf_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Di ga tali pu xolot ina xoo di ta tuni, ");
INSERT INTO ncf_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Iesu adi, ga ngani sangan di. ");
INSERT INTO ncf_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ma ga asaaiti di, “Iaa tii se asaaiti gim taman abala no maarang sin abia no leng iaa tii manman mii gim. No maarang araraa naba tsap so malen di tii se atalaa lalon xan no lo Moses, ma no propet ma lalon No Saam bula.” ");
INSERT INTO ncf_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","O ga suk alengi Inaatel Pat sin xadi no adodo ngali di ba leng. ");
INSERT INTO ncf_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ga paare ngali di, “Inaatel Pat a paare: ‘Karisito naba alet sosong, na met, o sin nanaatuul ina leng naba tapaas mula sin minet.’ ");
INSERT INTO ncf_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ma di ba baais taman iesan, tiltsoli Jerusalem ma laa sin no xolot araraa ina abala balan pula, ngali no inaman di ba puxisbal ma Moroaa naba adodolii xadi no namaang tsaxa. ");
INSERT INTO ncf_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","O gim nugu no tiltsoxoti sin abala no maarang. ");
INSERT INTO ncf_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ma iaa ba tulen sawe nugu Mom ta se xubatsi ngali tulen sin gim. Oro gim na liliis lalon inaman laba pupua sin biaa xoror in lapalaa naba ta xaalame papan gim.” ");
INSERT INTO ncf_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Biaa ta laamuangen di laa lalon biexa xolot atataaen Betani, ga tulsen no liman laa lapalaa ma ga atubudaani di. ");
INSERT INTO ncf_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Biaa ta lo atubudaani di tsaa, asuk papaalii di, ma Moroaa ga gii laangen lapalaa balalangit. ");
INSERT INTO ncf_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ma di ga langaari laa sin ia ma di tii ga mula laa Jerusalem taman pinaalam ma resres. ");
INSERT INTO ncf_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ma sin no daan leng se araraa, di tigiri manman atataaen Xan Anua Moroaa ngali paipaʼii Moroaa. ");
INSERT INTO ncf_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Sin atiltsoli so, Totore tii se manman tsaa, iwaa Totore tii se manman mii Moroaa ma biaa Totore, ia tsaa Moroaa. ");
INSERT INTO ncf_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ia tii manman mii Moroaa sin atiltsoli so. ");
INSERT INTO ncf_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Sin ia mu, no maarang araraa atsap. Nawe ia nii xap, naba xap xawas naba tsap. ");
INSERT INTO ncf_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Sin ia mu, tino, ma biaa tino, a tali laleng sin no inaman. ");
INSERT INTO ncf_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Biaa laleng ina leng atsila lalon lodo o lodo ga xap pupua ngali bibingli laleng. ");
INSERT INTO ncf_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Iexa taamat ia tii xaalame, Moroaa a tulen, iesan ilaa Jon. ");
INSERT INTO ncf_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","A xaalame malen xa tiltsoxoti ngali papaare leng taman abia laleng ina leng, ngalibi, sin ia mu, no inaman araraa di ba taltaalnge. ");
INSERT INTO ncf_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon tsaa a xap abia laleng, a xaalame mu ngali tiltsoxoti abia laleng. ");
INSERT INTO ncf_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Biaa laleng so, ta tali laleng sin no inaman araraa, biaa ta se xaalame lalon xolkolmoxo. ");
INSERT INTO ncf_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ia tii se manman lalon xolkolmoxo ina inaman, ma Moroaa axosngi abala xolkolmoxo sin ia oro xolkolmoxo tii ga xap nen xilalaa ia. ");
INSERT INTO ncf_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tii xaalame sangan xan no inaman tsaa, o di ga xap sirawaa ia. ");
INSERT INTO ncf_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Oro biaa di araraa, di ta sirawaa ia, biaa di ta taltaalnge sin iesan, a tali abia banam ngali di ba tsap xan no tsi Moroaa. ");
INSERT INTO ncf_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Oro biaa xan no tsi Moroaa di xap deltsoli sin xadi no iaaiaa, ma a xap sin sirsiir ina pakpak, ma a xap sin sirsiir ina minaxis oro sin xan sirsiir Moroaa. ");
INSERT INTO ncf_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Totore a se tsap taamat toto, ma ga manman lolobet ina gita, gita se lasi xan minaalam, biaa minaalam ta xuuk mu, iwaa ta xaal sin Mom, auus taman amiimiilam papan amiimiilam ma soina. ");
INSERT INTO ncf_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon a paare leng taman aia Totore. Atol ga paare, “Ilawaa aila iaa tii asaait taman we, ‘Iwaa naba ta amil papan iaa, a lot buxa ngen iaa, amuina ia setauan ngen iaa.’ ” ");
INSERT INTO ncf_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Amuina sin xan amiimiilam ta us buxa, gita se adi axuuk tubudaan papan iexa. ");
INSERT INTO ncf_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moroaa a tali lo sin gita sin Moses; amiimiilam ma soina axaal sin Iesu Karisito. ");
INSERT INTO ncf_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Asuk xap xa na se lasi Moroaa, oro iwaa xan tsi ta xuuk mu, iwaa Moroaa so, iwaa ta manman mii Mom ma ga se alengi xolkolmoxo ina inaman taman Moroaa. ");
INSERT INTO ncf_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Balawaa tii xan papaare leng Jon, biaa no Jiu in Jerusalem di tii tulen no unsausawit ma no Liwai ngali tiiriki ia, ia saa. ");
INSERT INTO ncf_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Tii xap bong, ataxaa puaa ngali paare leng taman balan so we, “Iaa xap Karisito.” ");
INSERT INTO ncf_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","O di ga atsuraa ia, “O saa iu? Iu Elaija?” A paare, “A xap, iaa xap Elaija.” “O iu iwaa propet, Aisaia ta papaatinai?” A xisi, “A xap.” ");
INSERT INTO ncf_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Xapkap ina, no unsausawit ma no Liwai di atsuraa, “O saa iu? U na asaait alengi giem, ngali laa taal mulangenai xa xixiis sin abia di, di ta tulen giem. O iu saa so?” ");
INSERT INTO ncf_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jon ga xisi di sin xan totore Aisaia iwaa propet, “Iaa inan aia xa ta ililei lalon xobel biil, ‘Xosor atutiki xan sal Orong.’ ” ");
INSERT INTO ncf_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","No Jiu bula di tii tulen biexaa Paarasi mii di, ");
INSERT INTO ncf_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","di tiiriki ia, “Ngalisa iu ta axaxadaan nawe u xap Karisito, o Elaija o xa propet?” ");
INSERT INTO ncf_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jon ga xisi di, “Iaa axaxadaan taman daan, oro labatina gim, axuuk xa ia ta tiltil gim ta xap atii. ");
INSERT INTO ncf_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Iwaa mu xa ta amil papan iaa, iaa xap muun mamainaang buxa ngali lubati xan no bubut.” ");
INSERT INTO ncf_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Balawaa no araraa atsap lalon xolot Betani, xaatalaa ina daansel Jodan, biaa Jon tii lo axaxadaan tia. ");
INSERT INTO ncf_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Leng papan, Jon a lasi Iesu ta xaalame sangan o ga paare, “Gim lasi, xan Tsi Sipsip Moroaa iwaa ta xaa saali namaang tsaxa ina xolkolmoxo ina no inaman. ");
INSERT INTO ncf_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ilawaa taamat iaa ta papaatinai, ‘Iexa taamat ia naba ta amil papan iaa, a lot buxa ngen iaa, amuina tii setauan manman ngen iaa.’ ");
INSERT INTO ncf_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Iaa tsaa iaa tii xap atii ia, oro muina iaa ta xaalame ngali xosaraa axaxadaan taman daan, ngali ia naba tsap lengleng sin no inaman in Israel.” ");
INSERT INTO ncf_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","O mil Jon ga tali abala xan papaare leng ta we, “Iaa lasi Nantanua ta xaalame lapula, axaal balalangit malen buna, ga tsotso papan. ");
INSERT INTO ncf_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Iaa nii xap atii ia, oro iwaa xa ta tulen iaa ngali xosaraa axaxadaan taman daan a asaaiti iaa, ‘Iwaa taamat gim tii lasi Nantanua tii xaalame lapula ga tsotso papan, iwaa mu aia naba xosaraa axaxadaan taman Nantanua Pat.’ ");
INSERT INTO ncf_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Iaa se lasi, ma iaa ga papaare leng weaatalaa, ilawaa xan Tsi Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Leng papan Jon a sebula le tiltil tia mii xan no tsi asasing alua. ");
INSERT INTO ncf_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Biaa tii lasi Iesu ta es liu ga we, “Gulu lasi, xan Tsi Sipsip Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Biaa delu ta alongen ta paare weaatalaa, delu suk amusili Iesu. ");
INSERT INTO ncf_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iesu a putsi ma lasi delulu ta amusili ia, o ga atsuraa delu, “Gulu saan ngali sa?” Delu ga xisi weaatalaa, “Rabai (muina unaasasing) itaa u manman?” ");
INSERT INTO ncf_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","A xisi, “Gulu xaalame ma gulu na le lasi.” Delu laa mii, ma delu ga lasi itaa ta xaa manman, ma delu ga manman mii sin abia leng araraa. Amat malen nanaaet ina aua nale. ");
INSERT INTO ncf_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Endru, iwaa turamasen Saimon Pita, tii xa ina abia delulu, delu tii alongen sawe Jon tii paare taman ma delu ga amusili Iesu. ");
INSERT INTO ncf_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nanaaxuuk ina maarang, Endru a tsalei turamasen, ilaa Saimon, ma ga asaaiti weaatalaa, “Gelulu se tatanginai Mesaia” (muina abala, Karisito, iwaa Moroaa ta se xanei). ");
INSERT INTO ncf_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ma ga giwaa ia laa sangan Iesu. Iesu a lasi ma ga asaaiti weaatalaa, “Iu Saimon, xan tsi Jon. Iaa ba a tso iesani iu taman Sepas” (muina Pita). ");
INSERT INTO ncf_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Leng papan, Iesu adodo ngali laa Galili. A laa tatanginai Pilip, ma ga asaaiti, “Xaalame, amusili iaa.” ");
INSERT INTO ncf_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip ia ina inaman laba Betasaida, malen mu Endru ma Pita. ");
INSERT INTO ncf_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilip a laa tatanginai Natanael, ma ga asaaiti weaatalaa, “Giem se tatanginai iwaa taamat Moses tii asaait taman lalon buk lo, ma no propet bula di tii asaait taman. Iwaa taamat iesan ilaa Iesu, ia in Nasaret, xan tsi Josep.” ");
INSERT INTO ncf_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael atsura, “Nasaret! A pupua ngali xawas axaau naba xaal Nasaret?” Pilip a xisi, “Xaalame u na le lasi!” ");
INSERT INTO ncf_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Biaa Iesu ta lasi Natanael ta xaalame ga asaait taman, “Taan Israel so aila! A xap xa daraxe sin.” ");
INSERT INTO ncf_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael ga atsuraa Iesu, “U atii iaa sen parawe?” Iesu a xisi ga we, “Iaa tii setauan lasi iu, sin Pilip tii xap mager ilei iu. U tii manman paina ie fik.” ");
INSERT INTO ncf_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael ga paare leng, “Rabai, iu xan tsi Moroaa, ma iu xadi King no Israel.” ");
INSERT INTO ncf_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ma Iesu ga paare, “U taltaalnge, amuina iaa ta asaaiti iu we, ‘Iaa setauan lasi iu paina ie fik.’ Mil, U ba lasi no maarang ta lot buxa ngen abala! ");
INSERT INTO ncf_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Iaa asaaiti gim taman so, gim ba lasi balalangit naba tsalel, ma xan no angelo Moroaa di ba xaxaale lapalaa ma di ba xaxaalame lapula papan xan Tsi Taamat.” ");
INSERT INTO ncf_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Sin nanaatuul ina leng biexa luxaal ina alaba atsap Kaana lalon prowins Galili. Xan nagaa Iesu a manman tia bula. ");
INSERT INTO ncf_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","O Iesu ma xan no tsi asasing bula di tii ningi di ngali laa man sin abia luxaal ina alaba. ");
INSERT INTO ncf_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Biaa xadi no waain ta se xap, xan nagaa Iesu ga asaaiti ia, “A se xap sin xadi no waain.” ");
INSERT INTO ncf_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Iesu a xisi, “Aina! Nugu sen xolot lalon abala maara? Nugu leng a xap mager tsap.” ");
INSERT INTO ncf_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Xan nagaa ga asaaiti no untutule, “Gim na xosaraa sawe malen ta asaaiti gim.” ");
INSERT INTO ncf_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Atataaen mu di, no sobuk xaat daan ina utut apaasxuk a manman tia, biaa no Jiu di ta xaa guraii no liman di, sin namaang ngali guraii lii no uba tsaxa. No xaat daan ina utut xuxuuk a pupua ngali taana malen no sangaul apaasaatuul, o sangsangaul axuuk ma no sangaul alua ina lita ina daan. ");
INSERT INTO ncf_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iesu ga asaaiti no untutule, “Gim na ut tuali no sobuk xaat daan;” ma di ga ut auusi no. ");
INSERT INTO ncf_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ga paare, “Tia! Gim utii tuali xaa sobuk daan laa sin aia lalaamua ina luxaal.” O di ga taxaa puaa xan totore. ");
INSERT INTO ncf_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","O lalaamua ina luxaal ga xonon abia daan Iesu ta se putsi laa sin waain. A xap atii itaa abia waain axaal, aso no untutule di ta utii abia waain di atii. Ma ga ilei aia taamat minaxis xaalame sangan, ");
INSERT INTO ncf_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ma ga asaaiti, “No inaman araraa di ba setauan tabiel taman waain mamainaang, o mil sin no inawut di ta se nun buxa, di ga tabiel maaba taman waain ta xap axaau buxa. Oro, iu tii aturung axaautsi abia ta axaau buxa ngali tabiel sin xapkap ina luxaal.” ");
INSERT INTO ncf_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Balawaa nan axuuk ina xan no xaraxin axixila xoror Iesu tii xosaraa Kaana, lalon xolot Galili. A asen xan minaalam, ma xan no tsi asasing di ga ie tinaalnge so sin. ");
INSERT INTO ncf_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Mulina abia, Iesu ga laa lapula nan xobel Kaperanaam mii xan nagaa, ma no turamasen ma xan no tsi asasing. Di ga manman atia biexaa nen leng. ");
INSERT INTO ncf_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Leng a se atat ngali Luxaal ina Esliwaa xadi no Jiu, o Iesu ga es laa lapalaa Jerusalem. ");
INSERT INTO ncf_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tia a tatanginai no inaman di ta sune taman no bulmakau, sipsip ma no buna ma biexaal di tsotso ngali soxisi no xuxute lalon xolot ina Xan Anua Moroaa. ");
INSERT INTO ncf_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ga adi biexa sua ga xosaraa ririit. Mil ga xalel atsuulngi di lalon Xan Anua Moroaa mii xadi no sipsip ma bulmakau, Iesu ga puxenlii xadi no niaan atuturung abia di ta soxisi no xuxute ma ga xabaren no. ");
INSERT INTO ncf_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Iesu a paare ngali abia di, di ta sune taman no buna, “Gim alet atsuulngi no. Gim nangaam xosaraa xan anua nugu Mom malen xa anua ina susune.” ");
INSERT INTO ncf_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Xan no tsi asasing di alongen abala totore o di ga adodomi Inaatel Pat ta paare, “Nugu xariin saansaan asuk lot buxa ngali Xan Anua Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","O no Jiu di ga tiirik apopogoroi ia, “No sen mat laxen axixila iu pupua ngali xosaraa no sin giem ngali asen so num banam ma tinaxaa ngali xosaraa abala no maarang araraa.” ");
INSERT INTO ncf_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Iesu a xisi di, “Iaa ba baxi abala Xan Anua Moroaa o inaa xosaraa mulangenei sin no leng ta tuul.” ");
INSERT INTO ncf_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","No lalaamua ina no Jiu di xisi, “A adi giem no sangaul aet ma ga laa paasxuk ina miet ngali tumaraa balawaa Xan Anua Moroaa o iu ba pupua ngali a til mulangenai sin nen leng ta tuul mu?” ");
INSERT INTO ncf_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Oro biaa Xan Anua Moroaa Iesu ta papatina, biaa mu xan pakpak. ");
INSERT INTO ncf_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Mil ta se tapaas mula sin minet, xan no tsi asasing di adodomi samaarang tii asaait taman. Biaa maaba di ga taltaalnge sin Inaatel Pat ma no totore biaa Iesu tii paatinai no. ");
INSERT INTO ncf_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Biaa Iesu tii manman Jerusalem sin no leng ina Luxaal ina Esliwaa ma xuduxudu ina inaman di taltaalnge sin iesan Iesu amuina di lasi no axixila xoror ta xosaraa. ");
INSERT INTO ncf_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Oro Iesu a xap taalnge tali ia tsaa so sin di, amuina atii xadi no butsa araraa. ");
INSERT INTO ncf_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","A xap saan ngali xa na asaaiti taman xadi papaare leng no inaman, amuina atii xadi no adodo no inaman. ");
INSERT INTO ncf_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Iexa taamat ina no Paarasi iesan ila Nikodimas iexa kaunsel ina no Jiu. ");
INSERT INTO ncf_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ga xaalame sangan Iesu nabing ga paare, “Rabai, giem atii iu unaasasing Moroaa ta tulen amuina a xap xa na pupua ngali atsapngen abia no axixila xoror nawe Moroaa a xap manman mii.” ");
INSERT INTO ncf_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","O Iesu ga xisi, “Asuk so maase, a xap xa na pupua ngali naba tsiga lalon xan Maradaan Moroaa nawe di xap taxaana auuli sebula.” ");
INSERT INTO ncf_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimas atsura, “Asen parawe? Di ba sebula taxaana aia taamat ta se maas? A xap pupua ngali naba sebula tsiga nanaalua lalon balan xan nagaa ma na taxaana mulangenai.” ");
INSERT INTO ncf_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Iesu a xisi, “Asuk so maase, a xap xa na pupua ngali naba tsiga lalon xan Maradaan Moroaa nawe di xap taxaana taman daan ma Nantanua. ");
INSERT INTO ncf_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Aina a taxaana taamat toto, oro Nantanua Pat atapaasi tino lalon nantanua. ");
INSERT INTO ncf_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Nangaam tunga sin iaa ta asaaiti gim, ‘Di na taxaana auuli gim sebula.’ ");
INSERT INTO ncf_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Maal a laa sin sen xolot ta saan ngali laa. Gim alongen xan tengteng ina ta maalen, oro gim xap atii itaa a xaal ma itaa ga laa. Malen mu gita araraa di ta taxaana gita lalon Nantanua.” ");
INSERT INTO ncf_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimas ga atsura, “Naba tsap sen parawe abala maarang?” ");
INSERT INTO ncf_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iesu ga paare, “Iu xariin unaasasing xadi no Israel, o asen parawe u ga xap leng sin abala no maarang? ");
INSERT INTO ncf_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Asuk so maase, giem papaare taman no maarang giem ta atii ma giem papaare leng taman no maarang giem ta lasi so oro gim ga xap taltaalnge sin nagiem no papaare leng. ");
INSERT INTO ncf_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Iaa se asaaiti gim taman no maarang ina abala balan pula, ma gim ga xap taltaalnge. Gim ba sen taltaalnge we nawe iaa papaare taman no maarang in tile lapalaa balalangit? ");
INSERT INTO ncf_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","A xap mager xa na laa lapalaa balalangit, aso iwaa mu xa ta xaalame lapula xaal balalangit, Xan Tsi Taamat. ");
INSERT INTO ncf_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Malen mu Moses ta xosaraa nantanuaan tsitsi ma ga alet laangen lapalaa lalon xobel biil. Xan Tsi Taamat naba weaatia bula. ");
INSERT INTO ncf_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ngali no inaman araraa di ta taltaalnge sin ia, di ba adi tino laaliu. ");
INSERT INTO ncf_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Moroaa asuk titii buxaai xolkolmoxo ina inaman se araraa o ga tulen xan Tsi ta xuuk mu ngali saa ia ta taltaalnge sin naba xap met, oro naba adi tino laaliu. ");
INSERT INTO ncf_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Moroaa a xap tulen Xan Tsi xaalame lalon xolkolmoxo ina inaman ngali atuti no inaman. A xap. A tulen ngali gii mulangenai di laa sangan ia. ");
INSERT INTO ncf_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Saa ia ta taltaalnge sin ia, Moroaa naba xap atuti ia, oro saa ia ta xap taltaalnge, Moroaa a se atuti ia tsaa, amuina a xap taltaalnge sin iesan iwaa Xan Tsi Moroaa ta xuuk mu. ");
INSERT INTO ncf_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","No inaman lalon balan pula di ba til lalon ininte amuina laleng a se tsap lalon xolkolmoxo ina inaman, oro no inaman di ga titii buxaai lodo ma di palolii laleng, amuina sin xadi no namaang morokon. ");
INSERT INTO ncf_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Saa ia ta xoxosaraa namaang morokon a palolii laleng, ma naba xap manman lalon laleng, amuina a palo ngali laleng naba alengi xan no namaang tsaxa. ");
INSERT INTO ncf_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Oro biaa di ta xosaraa namaang ta tutiik di se tsap nan laleng ngali biexaal di ba lasi we di xosaraa senaara Moroaa ta saansili.” ");
INSERT INTO ncf_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Mil Iesu ma xan no tsi asasing di ga se laa lalon xolot Judaia, ma di ga manman biexaa leng atia o Iesu tii ga lo axaxadaani no inaman bula. ");
INSERT INTO ncf_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Sin abia no leng, di xap mager tali Jon lalon anua lodo, ma ia bula ga lo axadaani no inaman tia Ainon atataaen xobel, Salim. Amuina lalon abia xobel no daan asuk xudu. Ma no inaman di lo xaxaalame sangan. ");
INSERT INTO ncf_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ma iexa taamat Jiu a xaalame ma ga emagaae mii xan no tsi asasing Jon taman xadi namaang no Jiu ngali guraii di ngali di ba tsap mixat lalon no matan Moroaa. ");
INSERT INTO ncf_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ma di ga xaalame sangan Jon ma di ga asaaiti weaatala, “Rabai, iwaa taamat ta manman mii iu talaa xaatalaa ina Jodan, iwaa mu u tii papaare leng taman, a lo axaxadaan bula, ma no daan inaman di ga laa sangan!” ");
INSERT INTO ncf_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jon a xisi, “Taamat a pupua mu ngali adi senaara di ta tali sin ia xaal balalangit. ");
INSERT INTO ncf_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Malen gim se adodolii iaa ta paare sin gim, ‘Iaa xap Karisito. Iaa taamat mu, Moroaa ta tulen laamuangen ia.’ ");
INSERT INTO ncf_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Taamat minaxis a se giwaa xan tubu. O turan aia taamat maxis a til lolong ngali, o ga suk taton sin ta alongen inan ta paare. Iaa malen turan aia taamat minaxis, ma nugu tataton a se xubit. ");
INSERT INTO ncf_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ia na tsap lot buxa, ma iaa na tsap dokdok. ");
INSERT INTO ncf_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Iwaa ta xaal tile balalangit a lot buxa ngen no inaman se araraa. Ma saa ia lalon abala balan pula, ia in tala lapula ma ga papaare taman no maarang in lapula. Iwaa xa ta xaal balalangit, a lot buxa ngen no inaman se araraa. ");
INSERT INTO ncf_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","A papaare leng taman no maarang ta se lasi ma ta se alongen, oro a xap xa na taltaalnge sin xan no papaare leng. ");
INSERT INTO ncf_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ma saa ia ta taltaalnge sin abia papaare leng, asen we xan totore Moroaa asuk so. ");
INSERT INTO ncf_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Iwaa xa Moroaa ta tulen, ngali paare taman xan totore, amuina Moroaa a se tali Nantanuaan biaa ta xap xa xapkap ina. ");
INSERT INTO ncf_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mom a titii buxaai Xan Tsi ma ga se tali no mat maarang araraa papan no liman. ");
INSERT INTO ncf_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Saa ia ta taltaalnge sin Xan Tsi a se adi tino laaliu, oro saa ia ta palolii Xan Tsi, naba xap adi tino laaliu, amuina xan minagaa Moroaa a manman papan ia.” ");
INSERT INTO ncf_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","No Paarasi di alongen we xuduxudu ina no tsi asasing di xaalame sangan Iesu ma ga axadaani xuduxudu ina di ngen Jon. ");
INSERT INTO ncf_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Oro Iesu tsaa a xap axadaani no inaman, oro xan no tsi asasing mu di axadaani di.) ");
INSERT INTO ncf_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Biaa Orong ta alongen abala totore, a tapaas poroklii xolot Judaia ma ga mula laa Galili, ");
INSERT INTO ncf_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","sin abia xan ines naba es tsiga tsaa nan xolot Samaria. ");
INSERT INTO ncf_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Di eses laa lalon sal, ma di ga laa tsap lalon inaman laba Sikar lalon xolot Samaria. Biaa xobel atataaen abia pu pula, ila Jakop tii setauan tali tsaa sin xan tsi Josep. ");
INSERT INTO ncf_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ma xan matandaan Jakop a manman atia. Iesu a se pelmet sin ta eses ma ga xale iaawis atia sangan matandaan, ma a se sangaul ma ga laa alua ina aua nale. ");
INSERT INTO ncf_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ma iexa aina in Samaria a xaalame ngali le ut. Iesu a lasi aia aina ta ut ma ga ningi, “Ben tali xa pu daan.” ");
INSERT INTO ncf_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Xan no tsi asasing di se laa lalon inaman laba ngali uul luxaal. ");
INSERT INTO ncf_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Iwaa aina Samaria ga paare ngali ia, “Ngalisa u ta ningi iaa ngali xa pu daan, amuina iu Jiu, o iaa aina in Samaria?” (Amuina no Jiu ma no Samaria di xap enane axaau.) ");
INSERT INTO ncf_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ma Iesu ga xisi ia, “Nawe iu nii nen xilalaa xan tinabel Moroaa ma saa ia ta ningi iu ngali xa pu daan, u nii ningi ma nii se tali sin iu daan ina tino.” ");
INSERT INTO ncf_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Iwaa aina a paare, “Orong, a xap num xa sobuk ngali ut, o tum aririi buxa. O itaa iu ba adi abia daan ina tino? ");
INSERT INTO ncf_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ila Jakop, nagiem iaaiaa a tali abala tum sin giem, ma ia mii xan no tsi ma xadi no xadek et, di tii nunun sin. Nangaam paare we, iu lot buxa ngen Jakop?” ");
INSERT INTO ncf_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ma Iesu a xisi, “No saa biaa di ta nun sin abala daan di ba marua bula ngali nun, ");
INSERT INTO ncf_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","oro saa ia ta nun sin abia daan iaa ba ta tali sin, naba xap marua bula. Daan iaa ba ta tali sin, naba malen keke ta lo wetwet taman abia daan ina tino laaliu.” ");
INSERT INTO ncf_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Iwaa aina ga asaaiti ia, “Orong, u na tali abala daan ngali iaa ba xap marua bula, ma ngali iaa ba xap xaal palpalaa bula ngali le ut atala!” ");
INSERT INTO ncf_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ga paare sin ia, “U na laa ilei num maxis ma u na mula xaalame!” ");
INSERT INTO ncf_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ga xisi, “A xap nugu xa maxis.” Ma Iesu ga asaaiti ia, “A tutiik abia iu ta paare we a xap num xa maxis ");
INSERT INTO ncf_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","amuina, iu tii se maxis sin a lima no taamat, ma iwaa taamat u ta manman mii a xap num maxis so. Biaa totore iu ta asaaiti iaa taman a so.” ");
INSERT INTO ncf_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Iwaa aina a paare sin, “Orong, iaa nen xilalaa we iu propet. ");
INSERT INTO ncf_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nagiem no iaaiaa no Samaria di xaa langaari laa sin Moroaa papan abala buk. Oro gim no Jiu, gim we Jerusalem tsaa xobel so ngali gita ba langaari laa sin ia.” ");
INSERT INTO ncf_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Iesu a paare leng, “Aina, u na taltaalnge sin nugu no totore. Leng biaa naba ta xaalame ma gim ba langaari laa sin Mom a xap papan abala buk o tile Jerusalem bula. ");
INSERT INTO ncf_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Gim no Samaria gim langaari sin sawe gim ta xap atii; oro giem no Jiu giem langaari sin sawe giem ta atii, amuina atotoaa axaal sin no Jiu. ");
INSERT INTO ncf_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Leng biaa naba xaalame ma bala se tsap, biaa no unlanglangaari so di ba langaari laa sin Mom lalon nantanua ma soina. Biaa no mat laxen unlanglangaari, Mom ta tsaltsalei di. ");
INSERT INTO ncf_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Moroaa ia nantanua. Ma xan no unlanglangaari di na langaari laa sin lalon nantanua ma soina.” ");
INSERT INTO ncf_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Iwaa aina a paare sin, “Iaa atii iwaa Mesaia naba xaalame, iwaa di ta putsangi Karisito, biaa naba ta tsap naba papaare alengi no mat maarang araraa sin gita.” ");
INSERT INTO ncf_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ma Iesu ga paare leng, “Iaa mu, iwaa Mesaia iu ta papaare mii.” ");
INSERT INTO ncf_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Talaawaa xan no tsi asasing di se mula sin iil luxaal ma di ga lasi ta papaare mii iexa aina ma di ga suk tunga buxa. Oro a xap xa na atsura, “Iu saan ngalisa?” o “Ngalisa iu ta papaare mii aia aina?” ");
INSERT INTO ncf_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ma iwaa aina a poroklii xan sobuk daan atia ma ga mula laa nan inaman laba ga asaaiti no inaman weaatalaa, ");
INSERT INTO ncf_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Gim xaalame gim na le lasi iexa taamat, asaaiti iaa taman no mat namaang iaa tii xoxosaraa no. Ia Karisito mu?” ");
INSERT INTO ncf_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Di papaalii inaman laba ma di ga lo laalaa ngali lasi Iesu. ");
INSERT INTO ncf_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Talaawaa xan no tsi asasing di suk asaaiti ia, “Rabai, angen!” ");
INSERT INTO ncf_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Oro ga xisi di, “Nugu luxaal ngali angen gim xap atii no.” ");
INSERT INTO ncf_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ma xan no tsi asasing di ga etsura engen di tsaa, “Male xa a se le tabali?” ");
INSERT INTO ncf_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ma Iesu ga asaaiti di, “Nugu luxaal a weaatala, iaa na amusili xan sirsiir Iwaa ta tulen iaa, ma ngali araraai abia xan tinaxaa ta tali sin iaa. ");
INSERT INTO ncf_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Gim xaa paare we, ‘Nawe no uleng a se et, o uma na maatkel maaba.’ Oro iaa asaaiti gim, gim na tsaleli no matan gim ma gim na lasi no uma ta se maatkel ngali tatat! ");
INSERT INTO ncf_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ma talaawaa, Iwaa untatat uma a se adi xan iliil axaau oro talaawaa a tatei uma ngali laa sin tino laaliu ngalibi iwaa unsoksok uma ma iwaa untatat uma delu ba arie taton. ");
INSERT INTO ncf_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Balawaa totore aso: ‘Xa a soxaa uma, o iexa a tatei uma.’ ");
INSERT INTO ncf_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Iaa tulen gim ngali gim ba laa tatei sawe gim tii xap soxaa. Biexaal di se xosaraa xariin tinaxaa, o gim se laa ngali tatei abia tubudaan ina xadi tinaxaa.” ");
INSERT INTO ncf_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Xuduxudu ina no Samaria lalon inaman laba di tii taltaalnge sin ia amuina sin xan papaare leng iwaa aina, “Tii asaaiti iaa taman no maarang araraa iaa tii xosaraa.” ");
INSERT INTO ncf_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ma biaa no Samaria di tii xaalame sangan ia, di tii ga ningi ngali na ben manman mii di. O tii ga manman mii di no leng alua. ");
INSERT INTO ncf_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ma amuina sin xan no totore, xuduxudu ina di bula di tii tsap no untaltaalnge. ");
INSERT INTO ncf_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Di ga asaaiti iwaa aina, “Giem tii taltaalnge setauan, amuina abia no totore iu ta asaaiti giem taman, o talaawaa giem alongen ma giem se atii we aso, ia untino so ina xolkolmoxo ina inaman.” ");
INSERT INTO ncf_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","No leng alua a se liu o Iesu ga tapaas papaalii Samaria o ga laa Galili mii xan no tsi asasing. ");
INSERT INTO ncf_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ma Iesu tii ga paare leng weaatalaa, “No inaman di xap manglen no propet lalon xan inaman labalaba tsaa.” ");
INSERT INTO ncf_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Biaa di ta le tsap Galili, o no inaman di ga suei atatoni ia amuina, di tii se lasi no maarang araraa ta xosaraa tia Jerusalem sin Luxaal ina Esliwaa amuina di tii manman tia bula. ");
INSERT INTO ncf_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ma ga sebula tsap lalon xobel Kaana ina Galili, lalon abia uk xobel Iesu tii putsi daan laa sin waain. Iexa lalaamua ina no unmakmaxil ia tia, xan tsi a maramase tia Kaperanaam. ");
INSERT INTO ncf_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Biaa ilawaa taamat tii alongmen we Iesu a se tsap Galili xaal Judaia, a laa sangan ma ga ningi awatwati ngali xaalame Kaperanaam ngali atoaa xan tsi amuina a se atat ngali met. ");
INSERT INTO ncf_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iesu ga asaaiti ia, “Gim ba xap taltaalnge nawe gim xap lasi no axixila xoror.” ");
INSERT INTO ncf_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ma iwaa lalaamua in no unmakmaxil ga xisi, “Orong, gita laa! Nugu tsi naba soro met!” ");
INSERT INTO ncf_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ma Iesu ga xisi, “U na laa. Num tsi naba tino.” Ma iwaa taamat a taltaalnge sin xan totore Iesu ma ga laa. ");
INSERT INTO ncf_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Biaa ta eses tsaa lalon sal laa, xan no untutule di ga sabasue taman inesaait, “Num tsi a se tino!” ");
INSERT INTO ncf_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ma ga atsuraa di, sen aua xan tsi ta saaen axaautsi. O di ga xisi, “No isuaan a sebula madil torongonol lasiaat sin nan axuuk ina matanios.” ");
INSERT INTO ncf_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Mil xan mom aia tsi a se adodomi we biaa mu aua tsaa Iesu ta se asaaiti we, “Num tsi naba tino.” O iwaa taamat mii xan matenaanua araraa di ga taltaalnge sin Iesu. ");
INSERT INTO ncf_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Balawaa nanaalua ina xan no axixila xoror Iesu ta xosaraa mulina ta xaal Judaia ga laa Galili. ");
INSERT INTO ncf_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Mulina abala no maarang, Iesu a xaale lapalaa Jerusalem ngali xadi luxaal no Jiu. ");
INSERT INTO ncf_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Tia Jerusalem atataaen Matenmat ina no Sipsip, biexa pu daan ulis biaa, sin totore Ibru di putsangi Betasaida, o ulti abia daan, no baul alima ngali arare. ");
INSERT INTO ncf_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Sin abia no xolot arare, xuduxudu ina no inaman di ta maramase, di xaa pulpulaai atia, no matababa, no xadek tsaxa mii no isua met. ");
INSERT INTO ncf_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Iexa taamat tii xap eses sin no sangaul a tuul ma ga laa paasaatuul ina no miet. ");
INSERT INTO ncf_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Biaa Iesu ta lasi ta matmatuul tii suk atii, tii manman taman abia minet xapkabaar tsaa, ga atsuraa ia, “U saan ngali u ba tuo?” ");
INSERT INTO ncf_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Iwaa taamat tii xap eses a xisi, “Orong, a xap xa ngali tiltsomi iaa ngali rik laa lalon pu daan ulis nawe daan agiis. Biaa nawe iaa laa, biexaal di se xaa laamuangen iaa.” ");
INSERT INTO ncf_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Iesu ga asaaiti, “Tapaas! Adi num xapat ma u na eses.” ");
INSERT INTO ncf_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tiwaa tsaa taamat asuk tuo; a adi xan xapat ma ga eses. Balawaa maarang tii tsap sin Saabat, ");
INSERT INTO ncf_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ma no Jiu di ga paare ngali aia taamat Iesu tii atoaa, “Talaawaa leng Saabat, lo a paare we, a xap tutiik ngali u ba atsaxei num xapat.” ");
INSERT INTO ncf_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Oro a xisi, “Iwaa taamat ta atoaa iaa a we, ‘Adi num xapat ma u na eses.’ ” ");
INSERT INTO ncf_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ma di ga tiiriki, “Sen taamat aia, ta asaaiti iu ngali adi num xapat ma u na eses?” ");
INSERT INTO ncf_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Iwaa taamat ta se tuo a xap atii saa taamat, amuina Iesu a se tsiga lalon abia xariin malep tia ga se laa. ");
INSERT INTO ncf_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mil Iesu ga se tatanginai lalon Xan Anua Moroaa ga asaaiti, “Lasi, u se axaau. Nangaam xosaraa bula namaang tsaxa o xa maarang tsaxa buxa naba soro tsap susum.” ");
INSERT INTO ncf_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Iwaa taamat ga laa asaaiti no Jiu we, “Ilaa Iesu mu aia ta atoaa iaa.” ");
INSERT INTO ncf_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Amuina Iesu ta xosaraa abia no maarang sin leng Saabat, no Jiu di ga suk tali mamaet sin ia. ");
INSERT INTO ncf_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Iesu asaaiti di, “Nugu mom a tigiri taktaxaa sin no leng araraa ma ga le pupua atalaa ma iaa bula iaa taktaxaa tsaa.” ");
INSERT INTO ncf_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Sin abala muina no Jiu di xonon ngali tsaapi ia, a xap sin ta laxei leng Saabat mu oro amuina, ta putsangi Moroaa xan mom tsaa, ma ga xosaraa malen arie pupua mii Moroaa. ");
INSERT INTO ncf_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Iesu a xisi di, “Iaa asaaiti gim taman so, xan Tsi naba xap pupua ngali xosaraa xa maarang xasinge; a pupua mu ngali xosaraa no maarang ta lasi xan Mom ta xosaraa. No maarang Mom ta xosaraa, xan Tsi bula naba xosaraa. ");
INSERT INTO ncf_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mom a titii buxaai xan tsi ma ga asen sin ia no maarang araraa ta xosaraa. Iou, gim ba suk olol buxa sin no maarang naba ta asen sin ia no maarang ta lot buxa ngen abala no. ");
INSERT INTO ncf_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","A malen mu Mom ta atapaasi no minet ma ga tali tino sin di, biaabi xan Tsi ga tali tino sin no saa ta taton ngali tali sin di. ");
INSERT INTO ncf_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Papan abia Mom naba xap ininte sin xa, oro a taalnge tali abia no ininte araraa sin xan Tsi. ");
INSERT INTO ncf_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ngalibi no inaman araraa, di ba manglen xan Tsi malen mu di ta manglen Mom. Iwaa ta xap manglen xan Tsi a xap manglen bula Mom, iwaa ta tulen ia. ");
INSERT INTO ncf_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Iaa asaaiti gim taman so, saa ia ta alongen nugu totore ma ga taltaalnge sin ia, iwaa ta tulen iaa, a se adi tino laaliu ma Mom naba xap atuti ia, a se poroklii minet ma ga se adi tino. ");
INSERT INTO ncf_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Iaa asaaiti gim taman so, leng naba xaalame ma a se tsap, no inaman di ta met, di ba alongmen inan Xan Tsi Moroaa o biaa di ta longmien di ba tino. ");
INSERT INTO ncf_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Amuina Mom ta ie tino lalon ia tsaa, ma ga se tali sin xan Tsi, tino lalon ia tsaa. ");
INSERT INTO ncf_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ma ga se tali banam sin ia ngali ininte amuina ia Xan Tsi Taamat. ");
INSERT INTO ncf_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Gim nangaam olol sin abala, leng biaa naba xaalame biaa di araraa lalon io di ba alongmen xan inan ");
INSERT INTO ncf_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ma di na tsuul, o biaa di, di ta xosaraa namaang axaau di ba tapaas mula ngali adi tino, o biaa di ta xosaraa namaang morokon di ba tapaas mula ngali til lalon ininte. ");
INSERT INTO ncf_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Iaa xasinge iaa xap pupua ngali xosaraa xawas. Iaa ininte mu malen iaa ta alongmen sin nugu Mom, ma nugu ininte asuk tutiik, amuina iaa xap saan ngali atatoni iaa tsaa, oro ia iwaa ta tulen iaa. ");
INSERT INTO ncf_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Nawe iaa papaare leng taman iaa tsaa biaa nugu papaare a xap so. ");
INSERT INTO ncf_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Oro xa xaatsap a papaare leng ngali iaa, ma iaa atii biaa xan papaare leng taman iaa, aso. ");
INSERT INTO ncf_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Gim tulen biexaa ngutsu laa sin Jon ma ga se papaare leng taman iaa sin soina. ");
INSERT INTO ncf_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Iaa xap sirawaa abala papaare leng xadi no inaman lalon abala balan pula. Oro iaa paare taman ngali gim ba tuo. ");
INSERT INTO ncf_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon tii malen aia rarar ta rar ma ga tsila, ma gim ga axilangi ngali taton mu sin pu xolot ina leng sin xan laleng. ");
INSERT INTO ncf_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Iaa ie papaare leng biaa ta lot buxa ngen xan no Jon. Biaa no tinaxaa so Mom ta tali sin iaa ngali araraai ma balawaa iaa ta xosaraa a paare leng we, Mom a tulen iaa. ");
INSERT INTO ncf_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ma Mom tsaa ta tulen iaa, a se paare leng tsaa taman iaa. Gim tii suk xap mager longmien inan ma lasi no matan. ");
INSERT INTO ncf_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ma xan totore a xap manngi gim amuina gim xap taltaalnge sin iwaa ta tulen iaa. ");
INSERT INTO ncf_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Gim no Jiu gim tigiri tsaltsalei xan no Inaatel Pat amuina gim adodo sin no lo ngali adi tino laaliu. Balawaa no Inaatel Pat a paare leng taman iaa. ");
INSERT INTO ncf_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Oro gim ga xap siir tsaa ngali xaalame sin iaa ngali gim ba ie tino. ");
INSERT INTO ncf_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Iaa xap tsatsel ngali xadi no paipaʼii no inaman. ");
INSERT INTO ncf_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Oro iaa atii gim. Iaa atii we, gim xap ie titii sin Moroaa lalon nagim no butsa. ");
INSERT INTO ncf_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Iaa se xaalame sin iesan nugu Mom, ma gim ga xap sirawaa iaa. Oro nawe xa xaatsap a xaalame sin iesan tsaa gim ba sirawaa ia. ");
INSERT INTO ncf_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Iaa suk xap olol gim ta xap pupua ngali taltaalnge amuina gim manglen gim xuxuuk tsaa, oro gim xap tsalei abia mangmangle xa ta xaal sin iwaa Moroaa ta xuuk mu. ");
INSERT INTO ncf_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Gim nangaam adodo we iaa ba atutali gim laamuaan Mom. Iwaa xa ta atutali gim lalon totore ilaa Moses iwaa gim ta se taalnge sin ia. ");
INSERT INTO ncf_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nawe gim se taltaalnge sin Moses, gim nii taltaalnge sin iaa bula, amuina tii se atatal taman iaa. ");
INSERT INTO ncf_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Oro amuina gim ta xap taltaalnge sin sawe Moses tii atalaa biaabi gim ba sen taltaalnge we sin samaarang iaa ta paare taman?” ");
INSERT INTO ncf_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Mulina abala no maarang, Iesu atabaxi laman laa xuen sin biexa papel ina laman Galili (biaa laman Taiberias), ");
INSERT INTO ncf_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","o xariin malep ina inaman di ga amusili amuina di lasi no axixila xoror biaa ta xosaraa sin no inaman di ta maramase. ");
INSERT INTO ncf_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Mil Iesu a laa papan gelgel ina buk ma ga manman mii xan no tsi asasing. ");
INSERT INTO ncf_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Xadi Luxaal ina Esliwaa no Jiu a se atat. ");
INSERT INTO ncf_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Biaa Iesu ta nanen laa ga lasi xaraxin malep di ta lo xaxaalame sangan ia, ga paare ngali Pilip, “Gita ba uul tsoki itaa ngali angen sin abala no inaman?” ");
INSERT INTO ncf_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","A atsuraa mu ngali xonon ia, amuina a se atii sin ia tsaa sawe naba ta xosaraa. ");
INSERT INTO ncf_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilip tii xisi ia, “Iliil ina apaasaatuul no uleng ina tinaxaa a xap pupua ngali uuli xaa tsoki pupua ngali xuxuuk ina di naba ngani xa pu nap.” ");
INSERT INTO ncf_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Iexa ina xan no tsi asasing, ila Endru turamasen Saimon Pita, a paare, ");
INSERT INTO ncf_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Iexa tsi xulaau ila taman nen tsoki alima ma nen xoo alua, oro naba xap pupua ngali abala inaman di ta suk xudu.” ");
INSERT INTO ncf_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Iesu asaaiti di, “Gim na atsotsoi no inaman lapula.” No palis a se malisa sin abia xolot, o no taamat di ga tsotso pupua malen no tausen a lima. ");
INSERT INTO ncf_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Mil Iesu adi no tsoki, ma ga putsangi axaau sin Moroaa ma ga tabali abia di ta tsotso ma a xosaraa weaatia sin no xoo ma ga suk buxa ngen sawe di ta saan ngali. ");
INSERT INTO ncf_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Biaa di ta se maas, ga asaaiti xan no tsi asasing, “Gim axumuli abia no pu ngaalngaal ina luxaal di ta papaalii. Gim nangaam tsaalen luxaal.” ");
INSERT INTO ncf_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ma di ga axumuli abia no pu ngaalngaal ma di ga tuali auusi no tep ta sangaul axuuk ma ga laa lua. ");
INSERT INTO ncf_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mil biaa no inaman di tii se lasi abia axixila Iesu ta xosaraa, di ga paare, “Asuk so ilawaa se Propet naba ta xaalame sin abala xolkolmoxo ina inaman.” ");
INSERT INTO ncf_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Iesu a se atii we di xaalame ngali atuaai ia ngali naba tsap king. A papaalii di sebula ma ga laa papan buk xasinge. ");
INSERT INTO ncf_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Biaa ta se nale bingbing, xan no tsi asasing di ga laa lapula sangan daan ulis, ");
INSERT INTO ncf_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","di en papan mono ngali laa sin biexa papel ina daan ulis Kaperanaam. A se bing o Iesu ga xap mager le tsomi di. ");
INSERT INTO ncf_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Xaraxin maal watwat amaalen daan ulis ma ga epurutsaae. ");
INSERT INTO ncf_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Mil di ta se alusa laa palpalaa malen alima o apaasxuk ina kilomita, di tii ga lasi Iesu ta es xaalame sangan mono papan daan ulis di ga suk mataa buxa. ");
INSERT INTO ncf_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Iesu ga asaaiti di, “Gim nangaam mataa, Iaa mu.” ");
INSERT INTO ncf_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Mil di ga se sirawaa ia ngali giwaa laa papan mono, o sauna mu, mono a se atal xuen sin abia xolot di ta laa tia. ");
INSERT INTO ncf_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Leng papan biaa malep di ta manman sin biexa papel xuen ina daan ulis, di se atii we mono axuuk mu abia ta manman atia, o Iesu tii xap laa mii xan no tsi asasing, oro di tii laa xasinge. ");
INSERT INTO ncf_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mil biexaa mono in Taiberias di le tsap xuen sangan abia xolot no inaman di ta ngani araraai tsoki mil sin Orong ta se putsangi axaau. ");
INSERT INTO ncf_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Biaa malep di se atii we Iesu ma xan no tsi asasing di xap manman atia, di xaa papan abia no mono di ga laa Kaperanaam ngali tsalei Iesu. ");
INSERT INTO ncf_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Biaa no inaman di ta tatanginai Iesu talaa xaatalaa ina daan ulis ma di ga atsuraa, “Rabai, Iu tsap atala langisa?” ");
INSERT INTO ncf_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Iesu a xisi di, “Iaa asaaiti gim taman so, gim lo nanen ngali iaa, a xap muina gim ta lasi no axixila xoror oro amuina gim ngani no tsoki ma gim ga se maas. ");
INSERT INTO ncf_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Gim nangaam taxaa ngali luxaal biaa naba ta tsaxa, oro gim na taxaa ngali luxaal biaa ta manman ngali tino laaliu. Biaa luxaal xan Tsi Taamat naba ta tali sin gim, amuina Moroaa, iwaa Mom, a se buri ia.” ");
INSERT INTO ncf_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Mil di ga atsuraa ia, “Giem ba xosaraa sa ngali giem ba xosaraa xan no tinaxaa Moroaa biaa ta saan ngali?” ");
INSERT INTO ncf_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Iesu a xisi di, “Xan tinaxaa Moroaa abala: gim na taltaalnge sin iwaa xa tii tulen.” ");
INSERT INTO ncf_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Biaabi di ga atsura, “Sen mat axixila xoror u ba xosaraa ngali giem ba lasi ma giem na taltaalnge sin iu? U ba suk xosaraa sa so? ");
INSERT INTO ncf_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nagiem no iaaiaa tii laamua di tii ngani manaa lalon xobel biil; malen inaatel ta paare: ‘A tali tsoki in balalangit sin di ngali ngani.’ ” ");
INSERT INTO ncf_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Iesu a paare, “Iaa asaaiti taman so, a xap Moses aia ta tali tsoki xaal balalangit sin gim oro nugu Mom a tali abia tsoki so, ta xaal balalangit. ");
INSERT INTO ncf_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Amuina xan tsoki Moroaa axaal balalangit ma a tali tino sin abala xolkolmoxo ina inaman.” ");
INSERT INTO ncf_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Di ga paare, “Orong, talaawaa u na tigiri tali abala tsoki sin giem.” ");
INSERT INTO ncf_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Iesu ga paare leng sin di, “Iaa biaa tsoki ina tino. Saa ia ta xaalame sin iaa naba xap bula itol, ma saa ia ta taltaalnge sin iaa naba xap bula marua. ");
INSERT INTO ncf_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Oro malen iaa se asaaiti gim, ma gim se lasi iaa, oro gim xap taltaalnge tsaa. ");
INSERT INTO ncf_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","No inaman araraa, Mom a se tali sin iaa, di ba xaalame sin iaa, o saa ia ta xaalame sangan iaa, iaa ba xap saali. ");
INSERT INTO ncf_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Amuina iaa tii xaal balalangit xaalame lapula a xap ngali taxaawiti nugu sirsiir oro ngali taxaawiti xan sirsiir iwaa ta tulen iaa. ");
INSERT INTO ncf_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Balawaa xan sirsiir aia, ta tulen iaa, biaa iaa na xap xosorlii xa ina abala no inaman araraa ta se tali sin iaa, oro iaa ba atapaasi di araraa mula sin tino sin xapkap ina no leng araraa. ");
INSERT INTO ncf_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Amuina xan sirsiir nugu Mom aweaatalaa, biaa di araraa di ta nanen sin xan Tsi ma di ga taltaalnge sin ia di ba adi tino laaliu, ma iaa ba atapaasi di sin xapkap ina no leng araraa.” ");
INSERT INTO ncf_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Sin abala xan no totore Iesu, no Jiu di ga burburik amuina ta paare, “Iaa tsoki in balalangit ta xaalame lapula.” ");
INSERT INTO ncf_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Di atsura, “Ilawaa taamat Iesu xan tsi Josep mu? Giem atii xan mom ma nagaa. Asen parawe ga paare, ‘Iaa xaal balalangit xaalame lapula?’ ” ");
INSERT INTO ncf_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iesu a xisi, “Gim nangaam ngurnguruk labatina gim tsaa. ");
INSERT INTO ncf_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","A xap xa na pupua ngali xaalame sin iaa, oro Mom tsaa iwaa ta tulen iaa naba tataii ia, ma iaa ba atapaasi ia laa sin tino sin xapkap ina no leng araraa. ");
INSERT INTO ncf_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Di tii se atalaa lalon xadi Buk no Propet: ‘Moroaa naba tali asasing sin no inaman araraa.’ Gim araraa, biaa gim ta lolong sin Mom ma adi asasing sin ia, gim xaalame sangaaga. ");
INSERT INTO ncf_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","A xap xa na se lasi Mom, oro iwaa mu ta xaal sin Moroaa, iwaa mu xa ta se lasi Mom. ");
INSERT INTO ncf_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Iaa asaaiti gim taman so, iwaa xa ta taltaalnge naba adi tino laaliu. ");
INSERT INTO ncf_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Iaa, iwaa tsoki ina tino. ");
INSERT INTO ncf_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nagim no iaaiaa tii laamua di tii ngani manaa lalon xobel biil, oro di tii ga met tsaa. ");
INSERT INTO ncf_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Oro balawaa tsoki ta xaalame lapula xaal balalangit, biaa xa taamat naba ta ngani ma naba xap met. ");
INSERT INTO ncf_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Iaa biaa tsoki ina tino, tii xaalame lapula xaal balalangit. Nawe xa angen sin abala tsoki, naba tino laaliu. Balawaa tsoki biaa nugu pines, biaa iaa ba ta tali ngalibi xolkolmoxo ina inaman di ba tino.” ");
INSERT INTO ncf_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Mil no Jiu di engangaae labatina di tsaa, “Asen parawe ilawaa taamat ta pupua ngali tali xan pines sin gita ngali ngani?” ");
INSERT INTO ncf_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Iesu ga asaaiti di, “Iaa asaaiti gim taman so, nawe gim xap ngani xan pines xan Tsi Taamat ma nunngi xan dal, naba xap xa tino sin gim. ");
INSERT INTO ncf_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Saa ia ta angen sin nugu pines ma ga nun sin nugu dal a ie tino laaliu, ma iaa ba atapaasi, sin xapkap ina no leng araraa. ");
INSERT INTO ncf_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Amuina nugu pines, luxaal so ma nugu dal, daan so ngali nun. ");
INSERT INTO ncf_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Saa ia ta ngani nugu pines ma nunngi nugu dal a manman lologo ma iaa man lalon ia. ");
INSERT INTO ncf_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Malen mu Mom iwaa ta tino, a tulen iaa ma iaa ga tino amuina sin Mom, ngalibi saa ia ta angangen sin iaa naba tino amuina sin iaa. ");
INSERT INTO ncf_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Balawaa tsoki biaa ta xaalame lapula axaal balalangit. Nagim no iaaiaa di ngani manaa o mil di ga met, oro iwaa ta angen sin abala tsoki, naba tino laaliu.” ");
INSERT INTO ncf_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tii papaare taman abala biaa ta lo asasingan no inaman lalon anua sausawit Kaperanaam. ");
INSERT INTO ncf_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Biaa di ta alongmen abala, xuduxudu ina no tsi asasing di paare we, “Balawaa asasing asuk lelep buxa, saa naba sirawaa?” ");
INSERT INTO ncf_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Aleng we, xan no tsi asasing di ngurnguruk ngali abala, Iesu ga paare sin di, “Balawaa no totore a alolbiri gim? ");
INSERT INTO ncf_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Gim ba wesa nawe gim ba lasi xan tsi taamat ta xaale lapalaa lalon abia xobel tii xaal tia? ");
INSERT INTO ncf_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Nantanua a tali tino, pines a ies gomsaa. Balawaa no totore iaa ta paare taman sin gim a nantanua ma a ie tino. ");
INSERT INTO ncf_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Oro biexaal ina gim, gim xap taltaalnge.” Amuina Iesu a se atii tsaa sin atiltsoli, saa ina di a xap taltaalnge ma saa naba babel tali sin no matenkorot. ");
INSERT INTO ncf_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ma ga lo papaare tsaa ga we, “Biaabi Iaa ga asaaiti gim, a xap xa naba pupua ngali xaalame sangaaga nawe Mom a xap tataii ia.” ");
INSERT INTO ncf_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Amuina sin abala no maarang, o xuduxudu ina xan no tsi asasing di ga putsi di mula ma di ga xap amusili ia bula. ");
INSERT INTO ncf_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Iesu atsuraa abia sangaul axuuk ma ga laa lua ina xan no tsi asasing, “O gim saan ngali laa bula?” ");
INSERT INTO ncf_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimon Pita a xisi ia, “Orong, saa bula ia giem ba ta laa sangan? U ie totore ina tino laaliu. ");
INSERT INTO ncf_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Giem taltaalnge ma giem atii we u pat, u xuuk sin Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Mil Iesu ga xisi, “Iaa axilangi gim ta sangaul axuuk ma ga laa lua, aso? Oro iexa ina gim, ia maraanis.” ");
INSERT INTO ncf_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iesu atii Judas, xan tsi Saimon Iskariot, iexa ina no sangaul axuuk ma ga laa lua ina xan no tsi asasing, naba ta babel tali ia. ");
INSERT INTO ncf_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Mil Iesu ga se laa galil Galili, ngali man palaaen Judaia amuina no Jiu di liliisi ngali sas amantei. ");
INSERT INTO ncf_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Oro, biaa Luxaal ina no Tebanikel xadi no Jiu a se atat. ");
INSERT INTO ncf_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Xan no turumasen Iesu di paare sin ia, “Iu na se tapaas atala ma iu na se laa Judaia ngalibi num no tsi asasing di ba lasi no axixila xoror u ta xosaraa no. ");
INSERT INTO ncf_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","A xap xa iwaa ta saan ngali atsapngen iesan na xosaraa no mat maarang na xuxii amuina iu xosaraa abala no ngali asen iu tsaa lalon xolkolmoxo ina inaman.” ");
INSERT INTO ncf_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Amuina xan no turamasen di xap taltaalnge bula sin ia. ");
INSERT INTO ncf_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Biaabi Iesu ga asaaiti di, “Biaa nugu leng axaau a xap mager tsap oro, sin gim no leng araraa axaau. ");
INSERT INTO ncf_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Xolkolmoxo naba xap ngutsulen gim oro a ngutsulen iaa amuina iaa paare leng we semaarang iaa ta xosaraa, a morokon. ");
INSERT INTO ncf_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gim laa sin abia luxaal. Iaa ba xap mager laa sin abia luxaal amuina ngali iaa, biaa nugu leng axaau a xap mager tsap.” ");
INSERT INTO ncf_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","A papaare araraa, tii suk manman tia Galili. ");
INSERT INTO ncf_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Mil sin xan no turamasen di tii se laa lapalaa sin luxaal, ia bula a laa, tii xap eses matan no inaman oro a es xuxii. ");
INSERT INTO ncf_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Sin abia luxaal no Jiu di lo nanen ma di ga atsura, “Inaai se aia taamat?” ");
INSERT INTO ncf_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Labatina no inaman di lo burburik taman ia, biexaal di paare, “Ia taamat axaau.” O biexaal di xisi, di ga paare, “A xap apanaai no inaman.” ");
INSERT INTO ncf_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Oro a xap xa na paare laba taman ia amuina di mataatine no Jiu. ");
INSERT INTO ncf_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","A se labatina luxaal, Iesu a laa tsiga lalon xolot ina Xan Anua Moroaa ma ga atiltsoli asingan no inaman. ");
INSERT INTO ncf_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","No Jiu di tunga ma di ga atsura, “Ilawaa taamat asen sinaae we sin ta xap asasing?” ");
INSERT INTO ncf_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Iesu a xisi di, “Balawaa nugu asasing a xap nugu tsaa, a xaal sin iwaa ta tulen iaa. ");
INSERT INTO ncf_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nawe xa axilangi ngali xosaraa xan sirsiir Moroaa, naba tsal tatanginai nawe balawaa nugu asasing axaal sin Moroaa o iaa paare mu taman nugu adodo tsaa. ");
INSERT INTO ncf_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Iwaa ta papaare mu taman xan adodo, a we di na paʼii ia tsaa, oro iwaa ta taxaa ngali manglen aia xa ta tulen xaalamengen, ia taamat so, amuina ia untutiik. ");
INSERT INTO ncf_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses tii tali lo sin gim. A xap xa lolobet ina gim na amusili abia lo. Ngalisa so gim ta saan ngali sas amantei iaa?” ");
INSERT INTO ncf_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Biaa malep di xisi, “Salawa tsaxa atsigaii iu, saa wena sas amantei iu?” ");
INSERT INTO ncf_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Iesu a xisi di, “Iaa tii xosaraa biexa axixila xoror ta xuuk o gim araraa gim ga tunga. ");
INSERT INTO ncf_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Amuina Moses tii tali namaang ina xasau (Moses a xap atsapngen abala namaang, a xap, tii xaal tsaa sin nagiem iaaiaa Abaram), gim axasaui tsi sin Saabat. ");
INSERT INTO ncf_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nawe xa tsi a xasau sin Saabat, di xosaraa ngali amusili xan Lo Moses, ngali sa u ta magaa sin iaa ta atoaa taamat xiduul sin Saabat?” ");
INSERT INTO ncf_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Gim nangaam ininte taman no matan gim mu, ma axaau gim na ininte taman namaang tutiik. ");
INSERT INTO ncf_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Sin abia mu no maarang biexaa inaman in Jerusalem di atsura, “Ilawaa mu taamat aila di ta xonon ngali sas amantei? ");
INSERT INTO ncf_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ia mu a tigiri paare laba lalon no matan no inaman o di ga xap paare taman xa totore sin ia. Amanaa no unbanam ina Jiu di adodo we, aso maase ia mu Karisito. ");
INSERT INTO ncf_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Oro, gita atii ilawaa taamat in itaa, oro biaa Karisito naba ta xaalame a xap xa naba atii itaa axaal.” ");
INSERT INTO ncf_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Iesu a lo xoxosaraa asasing tsaa lalon xolot ina Xan Anua Moroaa ga paare lot we, “Iou, gim atii iaa ma gim atii itaa iaa xaal. Iaa xap xaalame atala sin nugu adodo tsaa, a xap, oro iwaa xa ta tulen iaa, ia mu aso. Gim xap atii ia, ");
INSERT INTO ncf_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","oro, iaa atii ia, amuina iaa xaal sin ia ma ga tulen iaa.” ");
INSERT INTO ncf_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Di lo xonkonon ngali tsiili ia, oro ga xap xa na logotsi ia amuina xan leng a xap mager xaalame. ");
INSERT INTO ncf_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Oro xuduxudu ina abia malep di ga taltaalnge tsaa sin ia, di ga paare, “Biaa Karisito naba ta xaalame naba xosaraa xuduxudu ina no axixila xoror ngen aila taamat?” ");
INSERT INTO ncf_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","No Paarasi di alongen abia malep di ta burburik taman abala no maarang amusili ia, o no lalaamua ina no unsausawit ma no Paarasi di ga tulen no unxoxo ina Xan Anua Moroaa ngali tsiili ia. ");
INSERT INTO ncf_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Iesu ga paare, “Iaa ba manman dokdok mu mii gim o mil iaa na laa sangan aia xa ta tulen iaa. ");
INSERT INTO ncf_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Gim ba tsalei iaa, ma gim ba xap tatanginai iaa tsaa, ma biaa xolot iaa ba ta laa sin, gim xap pupua ngali xaalame sin.” ");
INSERT INTO ncf_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","No Jiu di ga epaare engen di, “Itaa naba laa aila taamat, ngali gita ba xap pupua ngali tatanginai ia? Manaa, naba laa lalon abia xolot, xida no inaman di ta man tamtsaare labatina no Grik, ma na asingan di? ");
INSERT INTO ncf_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Sen muina abala ta we, ‘Gim ba tsatsel ngali iaa, o gim ba xap tatanginai iaa,’ ma ‘sen xolot iaa ba laa lalon gim ba xap pupua ngali xaalame sin?’ ” ");
INSERT INTO ncf_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Sin abia xariin leng ma xapkap ina leng ina luxaal, Iesu a til ma ga paare laba ga we, “Nawe xa ia ta marua, na xaalame sangan iaa ngali le nun. ");
INSERT INTO ncf_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Saa ia ta taltaalnge sin iaa, malen Inaatel Pat ta se paare; ‘No daan sal taman daan ina tino naba rue tsuul xaal sin ia.’ ” ");
INSERT INTO ncf_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Tii papaare taman Nantanua, biaa no saa di ta taltaalnge sin ia, di ba adi mil. Amuina Nantanua a xap mager xale lapalaa, ma Iesu a xap mager adi xan minaalam. ");
INSERT INTO ncf_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Biexaa inaman lalon abia malep di ta alongmen ia ta paare, asuk so, “Ilawaa propet so.” ");
INSERT INTO ncf_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","O biexaal di paare, “Ia Karisito.” Ma biexaal tsaa, di atsura, “Karisito naba sen xaal Galili we? ");
INSERT INTO ncf_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Inaatel Pat a paare we, Karisito naba xaal sin xan matenbung Dewit, ma xaal Betliem, biaa inaman laba Dewit tii manman tia.” ");
INSERT INTO ncf_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Biaa malep di suk tsekxirixi engen di, amuina sin Iesu. ");
INSERT INTO ncf_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Biexaal ina di, di saan ngali tsiili ia, oro a xap xa na logotsi ia. ");
INSERT INTO ncf_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Biaa no unxoxo ina Xan Anua Moroaa di ta se laa mula, o no lalaamua ina no unsausawit ma no Paarasi di ga atsuraa di, “Ngalisa gim ta xap giwaa ia xaalame?” ");
INSERT INTO ncf_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","No unxoxo di xisi, “A xap xa na paare malen aia taamat ta papaare!” ");
INSERT INTO ncf_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","No Paarasi di ga axaraati di, “Apanaai gim bula? ");
INSERT INTO ncf_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Xa lalaamua o xa Paarasi a taltaalnge sin ia bula? ");
INSERT INTO ncf_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","A xap! Biaa malep di xap atii lo, xoror tsaxa bia papan di.” ");
INSERT INTO ncf_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimas, iwaa tii setauan laa sangan Iesu, ia ina abia no lalaamua ina no Jiu, ga paare, ");
INSERT INTO ncf_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Sin xida lo, gita xap pupua ngali atuti xa nawe gita xap mager alongen ia, ma tsaltatangine sen maarang ta se xosaraa.” ");
INSERT INTO ncf_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Di xisi ma di ga nen amagurusiki, “Iu bula in Galili? Nen puxen Inaatel Pat ngali u ba tatanginai we a xap xa propet na tsuul xaal Galili.” ");
INSERT INTO ncf_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Mil di xuxuuk, di se laa nan no tatan di. ");
INSERT INTO ncf_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Oro biaa Iesu tii laa papan Buk Olip. ");
INSERT INTO ncf_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Lawaareng bingbing tsaa a sebula mula xaalame lalon xolot ina Xan Anua Moroaa. No inaman araraa di ga ulti ia ma ga tsotso lapula ma ga taal asasing sin di. ");
INSERT INTO ncf_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","No unaasasing ina lo ma no Paarasi di gii xaalamengen iexa aina di ta tsiili ta matul mii taamat ta xap xan maxis. Di ga atilngi laamuaan di. ");
INSERT INTO ncf_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Di ga asaaiti Iesu, “Unaasasing, ilawaa aina giem tsiili ta matul mii taamat ta xap xan maxis. ");
INSERT INTO ncf_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lalon abala xan no lo Moses, a paare watwat ngali gita na pidi aia mat laxen aina taman no xaat pupua sin ta met. Iu ba paare we sa?” ");
INSERT INTO ncf_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Di paare weaatalaa ngali atsina ia, ngalibi di ba pupua ngali atutali xa totore sin ia. Iesu ga tudu ma ga atatal taman xan kakaalis papan pula. ");
INSERT INTO ncf_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Biaa di ta lo atsutsuraa ia, a tapaas ma ga asaaiti di, “Nawe saa ia ina gim, ta xap xaka namaang tsaxa, papaalii na setauan lii xa xaat sin ia.” ");
INSERT INTO ncf_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ma ga sebula tudu ma ga atatal papan pula. ");
INSERT INTO ncf_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Biaa di ta alongmen abala, di suk exatsep xuxuuk, no maas setauan, pupua sin Iesu xasinge mii aina ta lo tiltil tsaa. ");
INSERT INTO ncf_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Iesu a tapaas ga atsuraa ia, “Aina, inabise di? Tii xap xa na atuti iu?” ");
INSERT INTO ncf_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Aina ga paare, “Orong, a xap xa.” O Iesu ga paare, “Iaa ba xap atuti iu. U na se laa, o talaawaa nangaam xosaraa xa namaang tsaxa bula.” ");
INSERT INTO ncf_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Iesu ga sebula asaaiti no inaman, “Iaa, iaa laleng ina abala xolkolmoxo ina no inaman. Saa ia ta amusili iaa naba xap eses lalon lodo, a xap, naba ie laleng ina tino.” ");
INSERT INTO ncf_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","No Paarasi di ga tubusen ia, “Iu lo papaare leng taman iu tsaa, o biaa num papaare leng a xap so.” ");
INSERT INTO ncf_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Iesu ga xisi di, “O nawe iaa papaare leng taman iaa tsaa, nugu papaare leng aso, amuina iaa atii, itaa iaa xaal ma itaa iaa ba laa. Oro gim xap atii, itaa iaa xaal o iaa ba laa itaa. ");
INSERT INTO ncf_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Gim ininte sin sawe gim ta lasi, oro iaa xap ininte sin xa. ");
INSERT INTO ncf_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Oro nawe iaa ininte, nugu no adodo aso amuina a xap iaa xasinge. Iaa til mii Mom iwaa ta tulen iaa. ");
INSERT INTO ncf_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lalon nagim lo tsaa di tii atalaa we, papaare leng ina no taamat ta lua aso. ");
INSERT INTO ncf_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Iaa tsaa iaa paare leng taman iaa tsaa, iexa nugu xa tiltsoxoti iwaa Mom, iwaa ta tulen iaa.” ");
INSERT INTO ncf_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ma di ga tiirik apopogoroi, “Inaai num Mom?” Iesu a xisi, “Gim xap atii iaa ma nugu Mom. Nawe gim nii atii iaa gim ba atii nugu Mom bula.” ");
INSERT INTO ncf_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","A paare taman abala totore sin ta asingan no inaman lalon xolot ina Xan Anua Moroaa sangan abia xolot ina atuturung tinabel, oro a xap xa na tsiili ia amuina xan aua a xap mager tsap. ");
INSERT INTO ncf_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Iesu a sebula paare sin di, “Iaa ba se laa o gim ba nanen ngali iaa ma gim ba met taman nagim no namaang tsaxa. Itaa iaa ba ta laa, gim ba xap pupua ngali xaalame.” ");
INSERT INTO ncf_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Balawaa a xosaraa no Jiu di ga atsuraa di tsaa, “Naba sas amantei ia tsaa? Biaabi ga paare, ‘Itaa iaa ba ta laa gim ba xap pupua ngali xaalame.’ ” ");
INSERT INTO ncf_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Oro a lo papaare tsaa, “Gim in atala lapula, o iaa in lapalaa. Gim ina abala xolkolmoxo ina inaman, iaa xap ina abala xolkolmoxo. ");
INSERT INTO ncf_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Iaa tii asaaiti gim we, gim ba met lalon nagim no namaang tsaxa ma nawe gim ba xap taltaalnge we iaa iwaa Karisito, gim ba suk met sin nagim no namaang tsaxa.” ");
INSERT INTO ncf_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Di atsuraa, “Saa iu?” Iesu a xisi, “Biaa mu maarang iaa ta ben papaare taman. ");
INSERT INTO ncf_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","A xudu no maarang iaa ba ta paatina sin gim ma ngali ininte taman gim. Oro iwaa ta tulen iaa, asuk so ma senaara iaa ta longmien sin ia, iaa asaaiti xolkolmoxo ina inaman taman.” ");
INSERT INTO ncf_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Di xap leng we, tii se asaaiti di taman xan Mom. ");
INSERT INTO ncf_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Biaabi Iesu ga paare, “Biaa gim ta alet laangen xan Tsi Taamat lapalaa, mil gim ba atii we, iaa Karisito ma iaa xap xosaraa xawas taman nugu adodo tsaa oro iaa papaare mu taman senaara Mom tsaa ta asingan iaa. ");
INSERT INTO ncf_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Iwaa ta tulen iaa, ila mii iaa. A xap papaalii iaa xasinge. Amuina iaa tigiri xosaraa biaa no maarang ta atatoni ia.” ");
INSERT INTO ncf_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ma sin abia xan no papaare, xuduxudu ina di, di aturungi xadi tinaalnge sin ia. ");
INSERT INTO ncf_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","O Iesu ga paare sin abia no Jiu, di tii se taltaalnge sin ia. “Nawe gim taxaariti nugu no asasing, gim nugu no tsi asasing so. ");
INSERT INTO ncf_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Gim ba atii so ina, ma biaa so ina, naba aleiwaai gim.” ");
INSERT INTO ncf_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Di xisi ia, “Giem xan no iaaiaa Abaram, ma giem tii xap no untutule paina xa. U ba sen paare we, giem atii we giem leiwaa.” ");
INSERT INTO ncf_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Iesu a xisi di, “Iaa asaaiti gim taman so ina, gim araraa xuxuuk gim ta xoxosaraa namaang tsaxa, gim xan no untutule namaang tsaxa. ");
INSERT INTO ncf_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Untutule a xap ia so ina matenaanua, oro iwaa tsi ia ina matenaanua laaliu. ");
INSERT INTO ncf_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nawe tsi aleiwaai gim, gim ba suk leiwaa so. ");
INSERT INTO ncf_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Iaa atixi gim, gim xan no iaaiaa Abaram, oro gim se saage ngali sas amantei iaa, amuina gim xap adi nugu totore. ");
INSERT INTO ncf_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Iaa paare taman sa nugu Mom ta se asen sin iaa, oro gim xosaraa sen maarang nagim mom ta asaaiti gim taman.” ");
INSERT INTO ncf_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Di xisi ia, “Abaram nagiem mom.” Iesu asaaiti, “Nawe gim xan no tsi so Abaram, gim ba xosaraa no uk tinaxaa biaa Abaram tii xoxosaraa no. ");
INSERT INTO ncf_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Malen talaawaa gim lo nanen ngali iaa, ngali sas amantei iaa. Iaa iwaa ta se asaaiti gim taman soina biaa iaa ta alongmen sin Moroaa. Abaram tii xap xosaraa abala no maarang. ");
INSERT INTO ncf_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Gim lo xoxosaraa no maarang nagim Mom tsaa tii xoxosaraa.” Di xiis atsaxati, “Giem xap no tsi in nan sal. Moroaa ia tsaa iwaa nagiem Mom.” ");
INSERT INTO ncf_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","O Iesu ga asaaiti di, “Nawe Moroaa nagim Mom so, gim ba titii iaa, amuina iaa xaal sin Moroaa ma talaawaa iaa se tala. Iaa xap xaalame iaa tsaa, oro a tulen iaa. ");
INSERT INTO ncf_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ngalisa gim ga xap leng sin nugu totore iaa ta asaait taman? Amuina gim xap pupua ngali alongmen sawe iaa ta papaare taman. ");
INSERT INTO ncf_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Gim xan no tsi nagim mom Saatan, ma gim amusili xan no namaang tsaxa nagim mom. Sin atiltsoli, ia tii unsasas xa ma ia undadare ma a xap xa so lalon ia. Biaa ta dare, a paare taman xan no mat laxen namaang tsaa, ia undadare ma ia mom ina no dalek. ");
INSERT INTO ncf_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Iaa paare taman so, oro gim ga xap taltaalnge sin iaa. ");
INSERT INTO ncf_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Saa ina gim a pupua ngali tulis asen we, iaa mangiel sin nugu namaang tsaxa? Ma nawe iaa tore so, ngalisa gim ta xap taltaalnge sin iaa? ");
INSERT INTO ncf_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Saa ia ta xaal sin Moroaa, a xaa alongmen xan no totore Moroaa. Amuina gim ta xap alongmen iaa, gim xap xan Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","No Jiu di xisi atsaxati, “Giem paare so we, iu in Samaria, o salawa tsaxa aia ta manman lalon iu?” ");
INSERT INTO ncf_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Iesu a xisi di, “Salawa tsaxa a xap manman lalon iaa. Iaa tigiri paipaʼii nugu Mom o gim xap xaa manglen iaa. ");
INSERT INTO ncf_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Iaa xap tsatsel ngali minaalam, a xap, Moroaa ia ta tsatsel ngali, ma ia unininte. ");
INSERT INTO ncf_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Iaa asaaiti gim taman so, nawe xa a taxaariti nugu totore, naba suk xap met.” ");
INSERT INTO ncf_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","No Jiu di tubusen ia, “Talaawaa giem atii salawa tsaxa atsigaii iu. Abaram ma no propet di se met, o iu we nawe xa amusili num totore naba suk xap met. ");
INSERT INTO ncf_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Iu lot buxa ngen nagiem mom Abaram? Tii se met, mii no propet. U we iu saa?” ");
INSERT INTO ncf_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Iesu a xisi, “Nawe iaa aminaalami iaa tsaa, nugu minaalam naba suk maarang gomsaa. Nugu Mom iwaa gim ta paare we nagim Moroaa, iwaa mu ta aminaalami iaa. ");
INSERT INTO ncf_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Aso gim tii xap atii ia, iaa atii ia. Nawe iaa paare we iaa xap atii ia, iaa ba undadare malen gim; oro iaa atii ia ma iaa amusili xan totore. ");
INSERT INTO ncf_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Num iaaiaa Abaram, a papaalam buxa ngali lasi nugu leng; tii se lasi ma ga suk taton.” ");
INSERT INTO ncf_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","No Jiu di ga olol ma di paare, “Num no miet a xap mager no sangaul alima, o asen parawe we, u tii se lasi Abaram?” ");
INSERT INTO ncf_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Iesu a xisi, “Iaa asaaiti gim taman so, setauan sin di tii taana Abaram, iaa mu.” ");
INSERT INTO ncf_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ngali abia mu, di ga adi no xaat ngali pidi ia, oro Iesu ia tsaa ga xuxii, ga poroklii xolot ina Xan Anua Moroaa. ");
INSERT INTO ncf_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Iesu a es laa, ga lasi iexa taamat matababa, xaal sin nagaa tii taxaana. ");
INSERT INTO ncf_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Xan no tsi asasing di atsuraa ia, “Rabai, saa xosaraa namaang tsaxa, ilawaa taamat, o xan mom ma nagaa biaa di tii ga taxaanai ia, ga se matababa?” ");
INSERT INTO ncf_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Iesu a xisi, “A xap ilawaa taamat o xan mom o xan nagaa di xosaraa namaang tsaxa biaa ga matababa, oro balawaa atsap ngali Moroaa naba asen xan tinaxaa lalon xan tino. ");
INSERT INTO ncf_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Sin abala ta leng tsaa gita na xosaraa xan no tinaxaa aia xa ta tulen iaa. Bing naba xaalame biaa naba xap xa na pupua ngali taxaa. ");
INSERT INTO ncf_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Biaa iaa ta manman lalon xolkolmoxo ina inaman, iaa tsaa abia laleng ina xolkolmoxo.” ");
INSERT INTO ncf_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Mil sin ta paare, Iesu a xamutsa papan pula, o ga xosaraa pixaa taman xan xamutsa ma ga patsaa papan no matan aia taamat. ");
INSERT INTO ncf_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","A paare sin, “Laa guraii no mataam lalon pu daan ulis, Silom” (muina abala totore Silom tulen). Biaabi iwaa taamat ga laa guraii no matan, o ga mula ta se nanen. ");
INSERT INTO ncf_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","No inaman di ta man atataaen ma biaa di ta lasi ta xaa ningning di atsura, “Ilawaa uk taamat amuila, ta xaa xale ningning was?” ");
INSERT INTO ncf_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Biexaal di we, “Ia mu.” Biexaal di paare, “A xap, a mat malen ia.” Oro ga asaait leng taman ia tsaa, weaatala, “Iaa mu.” ");
INSERT INTO ncf_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Di tiiriki, “Asen we, o no mataam ga tsalel?” ");
INSERT INTO ncf_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","A xisi ga we, “Iwaa taamat di putsangi Iesu a xosaraa pixaa ga patsaa papan no mataaga, o ga asaaiti iaa ngali laa guraii no mataaga lalon daan Silom. Biaabi iaa ga laa guraii no mataaga, o iaa ga se nanen.” ");
INSERT INTO ncf_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Di atsuraa ia, “Inaai se aia taamat?” A xisi, “Iaa xap atii.” ");
INSERT INTO ncf_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Di gii laangen aia taamat matababa laa sangan no Paarasi. ");
INSERT INTO ncf_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Biaa leng Iesu ta xosaraa pixaa ma ga tsalali no matan aia taamat, tii Saabat. ");
INSERT INTO ncf_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Biaabi no Paarasi di ga atsuraa bula, asen parawe, o iu ga nanen. Iwaa taamat a xisi, “A patsaa pixaa papan no mataaga. O iaa ga laa guraii no mataaga ma talaawaa iaa ga se nanen.” ");
INSERT INTO ncf_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Biexaal ina no Paarasi di we, “Ilawaa taamat a xap xaal sangan Moroaa sin sa, a xap amusili Saabat.” Oro biexaal di atsura, “Asen parawe, o xa untsaxa, naba pupua ngali xosaraa no axixila xoror?” Biaabi di ga exatsep sin no xolot ta lua. ");
INSERT INTO ncf_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mil di sebula putsi laa sangan aia taamat tii matababa, “Amuina tii tsalali no mataam, u ba paare wesa ngali ia?” Iwaa taamat a xisi, “Ia propet.” ");
INSERT INTO ncf_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","No Jiu di xap mager taltaalnge we, ia tii matababa, o ga se nanen, pupua sin di ta tutule ngali xan mom ma nagaa aia taamat. ");
INSERT INTO ncf_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Di atsura, “Nugulu tsi aila? Ilawaa mu aila u ta we iu tii taxaana ta matababa? Asen parawe ga se nanen?” ");
INSERT INTO ncf_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Delu xisi, “Gelu atii ia nagelulu tsi, o gelu atii ta matababa sin nagaa tii taxaana. ");
INSERT INTO ncf_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Oro malen a se nanen, o saa ia ta tsalali no matan, gelu xap atii. Atsuraa ia, a se lot, a pupua ngali asaaiti gim.” ");
INSERT INTO ncf_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Delu asaait taman abala, amuina delu mataatinai no Jiu sinsa, di tii se xubatsi we, saa ia ta paare leng taman Iesu ia Karisito, di ba saali atsuulngi ia lalon anua sausawit. ");
INSERT INTO ncf_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Biaabi xan mom ma nagaa, delu ga paare, “A se lot pupua, gim atsuraa ia.” ");
INSERT INTO ncf_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ma di sebula ilei ngali aia taamat ta matababa ma di ga paare sin, “U na aminaalami Moroaa! Giem atii aia taamat ta atoaa iu, ia untsaxa.” ");
INSERT INTO ncf_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","A xisi, “Iaa xap atii, nawe ia untsaxa o a xap, was mu iaa ta atii; iaa tii matababa o talaawaa iaa se nanen.” ");
INSERT INTO ncf_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Di ga atsuraa ia, “Tii xosaraa sa sin iu? Asen tsalali wenangenai no mataam?” ");
INSERT INTO ncf_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","A xisi, “Iaa se asaaiti gim tsaa, o gim ga xap lolong. Ngalisa so gim ta wena sebula alongmen? Gim wena tsap xan no tsi asasing, bula?” ");
INSERT INTO ncf_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Di ga tubusen weaatalaa, “Iu xan tsi asasing, oro giem xan no tsi asasing Moses. ");
INSERT INTO ncf_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Giem atii we Moroaa tii papaare sin Moses. Oro ngali aia taamat giem xap atii itaa axaal.” ");
INSERT INTO ncf_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Iwaa taamat a xisi, “Balawaa maarang asuk alolaa iaa buxa! Gim xap atii itaa axaal, oro atsalali no mataaga. ");
INSERT INTO ncf_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Gita atii Moroaa a xap xaa alongmen xadi no sausawit no untsaxa, a xap, a xaa alongmen xadi sausawit no untutiik, di ta amusili xan sirsiir. ");
INSERT INTO ncf_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Sin atiltsoli, a xap xa na alongmen xa taamat ta tsalali no matan xa di ta taxaana ta matababa. ");
INSERT INTO ncf_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nawe ilawaa taamat a xap xan Moroaa naba xap pupua ngali xosaraa xawas.” ");
INSERT INTO ncf_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Sin abala di xisi, “Iu tii tsap lalon namaang tsaxa sin leng di tii taxaana iu, u xap pupua ngali asingan giem,” ma di ga tulen atsuulngi. ");
INSERT INTO ncf_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Biaa Iesu ta alongmen we di se tulen atsuulngi lokobel, a tatanginai ia, ga paare, “U taltaalnge sin xan Tsi Taamat?” ");
INSERT INTO ncf_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Iwaa taamat atsura, “Orong, saa taamat aia? Asaaiti iaa ngalibi iaa ba taltaalnge sin ia.” ");
INSERT INTO ncf_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Iesu a paare, “Iu se lasi ia, aso, ia mu iwaa xaa iu ta papaare mii talaawaa.” ");
INSERT INTO ncf_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mil iwaa taamat ga paare, “Orong, iaa taltaalnge,” ma ga langaari laa sin ia. ");
INSERT INTO ncf_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Iesu ga paare, “Iaa xaalame lalon xolkolmoxo ina inaman ngali ininte sin di, ngalibi no matababa di ba nanen, o biaa di, di ta nanen di ba tsap baba.” ");
INSERT INTO ncf_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Biexaa Paarasi atataaen ia di alongen abala o di ga paare, “Sawe? O giem xap matababa.” ");
INSERT INTO ncf_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Iesu ga paare, “Nawe gim nii matababa gim nii xap ie namaang tsaxa. Oro biaa gim ta we ‘giem nanen’ nagim namaang tsaxa a manman tsaa.” ");
INSERT INTO ncf_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Iaa asaaiti gim taman so, iwaa taamat ta xap tsiga matenmat ina xobel sipsip o ga laxe papan barateng ia unpulapula. ");
INSERT INTO ncf_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","O saa ia ta tsiga matenmat, ia untilaamamil ina no sipsip. ");
INSERT INTO ncf_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Unxoxo ina matenmat, a xaa tsalali matenmat ngali ia, ma no sipsip di alongen xan inan. A ilei xan no sipsip tsaa taman no iesan di ma ga xaa tsuul laamuangen di. ");
INSERT INTO ncf_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Biaa ta se atsuulngi abia xan no sipsip araraa tsaa, a xaa laamuangen di o di ga amusili ia amuina di long xilalaa inan. ");
INSERT INTO ncf_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Di ba xap amusili xa xaatsap, Oro di ba sol loxona aia xa, amuina di xap long xilalaa inan aia taamat xaatsap.” ");
INSERT INTO ncf_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesu a paare taman abala totore puapua, oro di xap leng sin sawe ta asaaiti di taman. ");
INSERT INTO ncf_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Biaabi Iesu ga sebula paare, “Iaa asaaiti gim taman so, iaa matenmat ina no sipsip. ");
INSERT INTO ncf_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Biaa di, di tii laamuangen iaa, di no unpulapula ma no unsasas, oro no sipsip di xap lolong sin di. ");
INSERT INTO ncf_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Iaa, iaa matenmat. Saa ia ta tsiga sin iaa naba tino, naba tsiga lalon matenmat ma na tsuul lokobel ma naba tsaltsalei no palis axaau. ");
INSERT INTO ncf_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Unpulapula a xaalame mu ngali pula, sas amantei ma xosor atsoti no maarang. Iaa, iaa xaalame ngali di ba ie tino, biaa ta usli. ");
INSERT INTO ncf_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Iaa untilaamamil axaau ina no sipsip. Untilaamamil axaau ina no sipsip naba met ngali xan no sipsip. ");
INSERT INTO ncf_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Iwaa untinaxaa di ta uuli, a xap iwaa untilaamamil so ina no sipsip ma a xap tapkina abia no sipsip. Biaabi nawe a lasi xapunakok ta xaalame, naba sol poroklii no sipsip ma na suk sol loxono di. Mil xapunakok naba xalili di ma di na sol exatsep. ");
INSERT INTO ncf_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Iwaa untinaxaa a sol amuina di uuli mu ia, ma ga xap adodo buxa ngali no sipsip oro ngali ia mu. ");
INSERT INTO ncf_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Iaa untilaamamil axaau ina no sipsip, iaa atii nugu no sipsip ma nugu no sipsip bula di atii iaa. ");
INSERT INTO ncf_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Malen mu Mom ta atii iaa, iaa bula iaa atii Mom ma iaa ga met ngali no sipsip. ");
INSERT INTO ncf_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Biexaal ina abala no sipsip di xap ina abala xobel sipsip. Iaa ba giwaa bula di. Di bula di ba long xilalaa inaaga o di ba tsap etudim malen xobel sipsip axuuk ma iaa ba tsap xadi untilaamamil. ");
INSERT INTO ncf_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Sin abia muina nugu Mom ga titii iaa amuina iaa tii met ma iaa ba sebula tapaas mula. ");
INSERT INTO ncf_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","A xap xa naba saali nugu tino, oro iaa tali taman nugu sirsiir tsaa. Iaa ie banam ngali tali nugu tino ma banam ngali alet mulangenai. Balawaa totore watwat iaa tii adi sin nugu mom.” ");
INSERT INTO ncf_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Sin abala totore no Jiu di sebula xap ukbal. ");
INSERT INTO ncf_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Xuduxudu ina di, di paare we, “No salawa di tsigaii ma ga paare tangtangabaa. Ngalisa gita na longmien ia?” ");
INSERT INTO ncf_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Oro biexaal di paare, “Biaa no totore a xap xan no aia taamat ta ie salawa tsaxa. Asen parawe gim ga we xa taamat ta ie salawa tsaxa a pupua ngali tsaleli matan xa matababa?” ");
INSERT INTO ncf_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tia Jerusalem, xariin Luxaal ngali Axilangi xan Anua Pat Moroaa ta tsap uul, o biexa bula no leng ina madil. ");
INSERT INTO ncf_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Iesu ga eses lalon xolot ina Xan Anua Moroaa di putsangi xolot arare xan Solomon. ");
INSERT INTO ncf_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","O no Jiu di ga til ulti ia di ga tiirik, “Ngalisa iu ta aboiki giem? Nawe aso iu Karisito, asaait alengi giem.” ");
INSERT INTO ncf_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Iesu a xisi di, “Iaa se asaaiti gim oro gim ga xap taltaalnge. No axixila xoror iaa ta xosaraa no sin iesan nugu Mom, a paare leng taman iaa. ");
INSERT INTO ncf_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Oro gim ga xap taltaalnge amuina gim xap nugu no sipsip. ");
INSERT INTO ncf_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nugu no sipsip di xaa alongmen inaaga, iaa atii di; ma di tigiri xaa amusili iaa. ");
INSERT INTO ncf_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Iaa tali tino laaliu sin di, ma di ba suk xap met, xa naba xap saali di lalon no limaaga. ");
INSERT INTO ncf_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nugu Mom iwaa ta tali di sin iaa, a lot buxa ngen no maarang araraa; a xap xa na pupua ngali saali di lalon no liman Mom. ");
INSERT INTO ncf_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Iaa ma nugu Mom, gelu xuuk mu.” ");
INSERT INTO ncf_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","No Jiu di adi no xaat sebula ngali pidi ia. ");
INSERT INTO ncf_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Oro Iesu a paare ngali di, “Iaa se asingan gim taman no axixila xoror ta xaal sin Mom. Inaabi abala no tinaxaa axaau gim ta saan ngali pidili iaa taman?” ");
INSERT INTO ncf_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","No Jiu di ga xisi, “Giem xap pidili iu taman xa ina abala no, oro, ngali abia num no papaare reret taman Moroaa. Iu mu taamat gomsaa, iu we iu Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Iesu a xisi di, “Di tii atalaa lalon nagim lo. ‘Iaa se paare, gim no moroaa?’ ");
INSERT INTO ncf_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nawe a putsangi di ‘no moroaa,’ sin saa so xan totore Moroaa a xaalame sin ma balawaa Inaatel Pat ga suk so laaliu. ");
INSERT INTO ncf_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Asen parawe se sin aia Mom ta we a se aturung axatsapen malen xan tsi tsaa ma ga tulen laa lalon xolkolmoxo ina inaman? Ngalisa gim ga we, iaa paare reret taman Moroaa, amuina iaa ta we, ‘Iaa xan tsi Moroaa?’ ");
INSERT INTO ncf_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Gim nangaam taltaalnge sin iaa, nawe iaa xap xosaraa sawe nugu Mom ta xosaraa. ");
INSERT INTO ncf_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Oro nawe iaa xosaraa o gim ga xap taltaalnge sin iaa, gim na taltaalnge sin no axixila xoror, biaabi gim ba atii ma leng we, Mom ila lalon iaa, ma iaa lalon Mom.” ");
INSERT INTO ncf_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Di wena sebula tsiili ia, o di ga tsilpuli ia. ");
INSERT INTO ncf_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Mil Iesu ga mula, ga tabaxi Jodan laa sin abia xolot Jon tii axadaani no inaman sin abia no leng tii xulaau. Tii manman tia. ");
INSERT INTO ncf_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ma no daan inaman di ga xaalame sangan ia, di ga we, “Jon a xap xosaraa xa axixila xoror oro sawe biaa Jon ta asaait taman aila taamat, asuk so.” ");
INSERT INTO ncf_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","O sin abia xolot, xuduxudu di ga taltaalnge sin Iesu. ");
INSERT INTO ncf_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Iexa taamat iesan ilaa Lasarus, a maramase. Ia in Betani, xan xobel Maria ma tawaneina Maata. ");
INSERT INTO ncf_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Iwaa Maria, moton Lasarus ta maramase, iwaa mu tii patsaa daan tso mamainaang papan Orong ga a puraa no xaden taman ulinxuan. ");
INSERT INTO ncf_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lomasen tawaneina delu tulen totore sin Iesu, “Orong iwaa iu ta titii a maramase.” ");
INSERT INTO ncf_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Iesu alongmen abala ga we, “Balawaa maramase naba xapkap lalon minet. A xap, ngali asen xan minaalam Moroaa, biaabi ngali xan tsi Moroaa naba aminaalami sin.” ");
INSERT INTO ncf_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iesu a titii Maata mii tawaneina ma Lasarus. ");
INSERT INTO ncf_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Oro, biaa ta se alongen we, Lasarus a maramase, a sebula manman no leng alua lalon abia xobel ta manman tia. ");
INSERT INTO ncf_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Mil ga asaaiti xan no tsi asasing, “Gita ba sebula mula laa Judaia.” ");
INSERT INTO ncf_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Xan no tsi asasing di paare sin, “Rabai, talaawaa mu no Jiu di wena pidili iu taman no xaat, o iu wena sebula mula laa tia?” ");
INSERT INTO ncf_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Iesu a xisi di, “Gita atii we sangaul axuuk ma ga laa lua ina aua lasiaat. Taamat iwaa ta eses lalon laleng naba xap litke, amuina a nanen lalon xan laleng ina xolkolmoxo ina inaman. ");
INSERT INTO ncf_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nawe a eses nabing biaa naba litke amuina biaa laleng a xap manman lalon ia.” ");
INSERT INTO ncf_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Mil sin abia no maarang, a laa ga asaaiti di, “Turan gita ilaa Lasarus a se urange; oro iaa ba laa atia ngali apadaa ia.” ");
INSERT INTO ncf_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Xan no tsi asasing di ga we, “Orong, nawe a urange, biaa naba axaau mu.” ");
INSERT INTO ncf_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Iesu a papaare taman xan minet Lasarus, oro xan no tsi asasing di adodo we, Lasarus a urange mu. ");
INSERT INTO ncf_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","O mil tii ga asaait alengi di, “Lasarus a se met, ");
INSERT INTO ncf_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ma amuina ngali gim, iaa taton iaa ta xap manman mii di, ngali gim ba taltaalnge. Oro, gita laa sangan ia.” ");
INSERT INTO ncf_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Mil Tomas, biexa iesan Didimus, ga asaaiti no tsi asasing araraa ga we, “Nagaa laa mii, ngali gita ba met bula mii ia.” ");
INSERT INTO ncf_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Sin xan tsinap, Iesu tii atik tatanginai malen Lasarus a se matul no leng aet lalon lia pupuna. ");
INSERT INTO ncf_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani aman malen a tuul no kilomita palaaen Jerusalem, ");
INSERT INTO ncf_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ma xuduxudu ina no Jiu di ga xaalame sangan Maata ma Maria ngali le atuturi delulu amuina moton delulu a se xaapina. ");
INSERT INTO ncf_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Biaa Maata ta alongmen we, Iesu a se xaalame, ga tsuul ngali laa es balsi ia, oro Maria a manman mu lalon xadi anua. ");
INSERT INTO ncf_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maata ga paare sin Iesu, “Orong, nawe u nii manman atala, motogo nii ba xap met. ");
INSERT INTO ncf_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Oro, iaa atii malen talaawaa Moroaa naba tali sawe u ta ningi sin.” ");
INSERT INTO ncf_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Iesu ga paare sin ia, “Num taamat naba tapaas mula taman tino.” ");
INSERT INTO ncf_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maata ga xisi, “Iaa atii naba tapaas mula sin xapkap ina no leng araraa.” ");
INSERT INTO ncf_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Iesu ga paare ngali ia, “Iaa, iaa tinapaas mula ma tino. Iwaa xa ta taltaalnge sin iaa naba adi tino, ma nawe a se met naba tino, ");
INSERT INTO ncf_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ma iwaa ta tino ma ta taltaalnge sin iaa naba suk xap met. U taltaalnge sin abala?” ");
INSERT INTO ncf_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Maata asaaiti ia, “Iou Orong, iaa taltaalnge we, iu mu Karisito, xan tsi Moroaa iwaa naba ta xaalame lalon xolkolmoxo ina inaman.” ");
INSERT INTO ncf_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ma mulina Maata ta se paare weaatalaa, a mula ga laa ileitsoli tawaneina Maria o ga asaaiti, “Unaasasing ila se, a tiirik ngali iu.” ");
INSERT INTO ncf_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Biaa Maria ta alongmen abala, a tapaas isagaa ma ga suk laa sangan. ");
INSERT INTO ncf_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Iesu a xap mager tsiga lalon abia xobel, a lo manman tsaa sin abia xolot ta balsi Maata tia. ");
INSERT INTO ncf_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Biaa no Jiu di ta manman ngali atuturi Maria lalon anua di lasi ta tapaas isagaa ga tsuul, di suk amusili. Di sarowe naba laa lalon lia pupuna ngali laa teng. ");
INSERT INTO ncf_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Biaa Maria ta laa tsap sin abia xolot Iesu ta manman tia ga lasi ia, a sage putput sangan ga we, “Orong, nawe iu nii manman tala, motogo nii xap met.” ");
INSERT INTO ncf_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Biaa Iesu ta lasi ta lo tengteng, ma no Jiu biaa di ta xaalame mii di teng bula, tii suk lolbiir buxa lalon nantanuaan ma ga adodo buxa. ");
INSERT INTO ncf_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ga atsuraa di, “Gim atetei lalon sen lia pupuna?” Di ga xisi, “Orong, xaalame ma u na le lasi.” ");
INSERT INTO ncf_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iesu ga teng. ");
INSERT INTO ncf_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mil no Jiu di ga paare, “Gim lasi, asuk titii buxaai ia.” ");
INSERT INTO ncf_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Oro biexaal ina di, di paare, “A tsalali no matan aia taamat ta baba o ngalisa ga xap pupua ngali tilkaali ia sin minet?” ");
INSERT INTO ncf_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Iesu asuk lolbiir buxa ga xaalame sangan lia pupuna. Biaa lia pupuna aman lalon lia sin gelgel ina buk, o biexa xaat di axos banti matenmat ina tsigatsiga. ");
INSERT INTO ncf_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ga paare, “Gim puxenlii abia xaat alen matenmat.” O Maata, moton aia tongaan ga we, “Orong, amuina a se matul no leng aet, a se xapul aia.” ");
INSERT INTO ncf_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Iesu ga paare ngali di, “Iaa tii asaaiti gim we, nawe gim taltaalnge gim ba lasi xan minaalam Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ma di ga puxenlii aia xaat. Iesu ga agar xale lapalaa ga paare, “Mom, iaa putsangi axaau sin iu, iu ta se alongmen iaa. ");
INSERT INTO ncf_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Iaa tii atii we, iu tigiri alongmen iaa, oro, iaa paare taman abala ngali xadi axaau balawaa malep di ta tiltil atala, ngali di ba taltaalnge we iu tulen iaa.” ");
INSERT INTO ncf_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Biaa ta se paare taman abala, asuk ilei xuupkup, “Lasarus, u na tsuul!” ");
INSERT INTO ncf_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Iwaa tongaan asuk tsuul taman no liman ma no xaden di tii ulsi taman no xolot ina laplap, o xuan di ngaati bula. Iesu ga paare ngali di, “Gim lubatli abia no laplap ina pupuna, gim aleiwaai ia.” ");
INSERT INTO ncf_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Biaabi xuduxudu ina no Jiu, biaa di ta xaalame ngali le uwaa Maria ma di tii se lasi sawe Iesu tii xosaraa ma di ga taltaalnge sin ia. ");
INSERT INTO ncf_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Oro, biexaal ina di, di laa sangan no Paarasi di ga asaaiti di taman sawe Iesu tii se xosaraa. ");
INSERT INTO ncf_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mil no lalaamua ina no unsausawit ma no Paarasi di ga ilei biexa xalkale ina Sanidrin. Di ga atsura, “Gita ba xosaraa sa? Ilawaa taamat a se xosaraa xuduxudu ina no mat axixila xoror. ");
INSERT INTO ncf_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nawe gita ba papaalii, na lo xoxosaraa abala, inaman araraa di ba suk taltaalnge sin. O no Rom di ba xaalame ma di na araabi Xan Anua Moroaa ma xida xobel labalaba.” ");
INSERT INTO ncf_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Oro iexa ina di, ilaa Kaiapas, iwaa tii unsausawit lapalaa sin abia miet, ga asaaiti di, “Gim suk xap atii xawas! ");
INSERT INTO ncf_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Gim xap atik axaautsi we, naba axaau ngali xa na xuuk na met ngali no inaman, o na xap abala xobel labalaba na araabi.” ");
INSERT INTO ncf_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","A xap asaait taman abala sin xan adodo tsaa, Oro, biaa tii unsausawit lapalaa sin abia miet, tii tali xan totore propet we, Iesu naba se met ngali abala xobel labalaba, ");
INSERT INTO ncf_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ma a xap ngali xobel labalaba mu oro, ngali abia xan no tsi Moroaa, di ta man iʼis, ngali giwaa etudim di ngali di ba tsap xuuk. ");
INSERT INTO ncf_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ma sin abia leng ma laa, di ga se ngiti ngali sas amantei Iesu. ");
INSERT INTO ncf_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ma Iesu ga se xap bula eses iʼis papan no matan no Jiu. Ga laa lalon biexa xobel biil lalon inaman laba Epraaem, ga manman atia mii xan no tsi asasing. ");
INSERT INTO ncf_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Xadi Esliwaa no Jiu a se atat, o xuduxudu ina no inaman ina no xobel xaatsap, di xaale Jerusalem ngali xosaraa namaang ina amixati ngali aleiwaai di tsaa setauan ina Esliwaa. ");
INSERT INTO ncf_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Di lo nanen ngali Iesu biaa di ta lo tiltil lalon Xan Anua Moroaa ma di ga etiirik engen di, “Naba soro xap xaalame sin abala luxaal?” ");
INSERT INTO ncf_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ma no lalaamua ina no unsausawit ma no Paarasi di ga tali totore watwat we, saa ia ta lasi Iesu lalon xa xolot, na paate alengi sin di, ngali di ba pupua ngali tsiili ia. ");
INSERT INTO ncf_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","A se paasxuk no leng ngali laa sin Esliwaa o Iesu ga tsap Betani, biaa xobel Lasarus ta xaa manman, iwaa Iesu tii atapaasi sin ta se met. ");
INSERT INTO ncf_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Tiwaa di tii xosaraa luxaal ngali Iesu. Maata atabali di ma Lasarus bula a tsotso sangan ibe angangen mii. ");
INSERT INTO ncf_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mil Maria ga adi biexa daan ta tso mamainaang, di ta xosaraa taman no pilogo tso, xan iliil asuk lot buxa ga patsaa papan no xaden Iesu ma ga silaapuraa taman ulin xuan. Ma anua ga suk tso mamainaang buxa sin abia daan tso. ");
INSERT INTO ncf_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Oro iexa ina xan no tsi asasing, ilaa Judas Iskariot, iwaa naba ta babel tali Iesu papan no liman no matenkorot a we, ");
INSERT INTO ncf_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ngalisa ta palo ngali sune taman abala daan tso ma naa adi xuxute naa tali sin no muunwas. Asuk pupua malen iliil ina miet ta xuuk.” ");
INSERT INTO ncf_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","A papaare taman abala amuina a xap atarangaai no muunwas, oro, amuina ia unpulapula; a xaa tilaamamil sin xadi no tang, o ga pulapula lalon abia niaan atuturung. ");
INSERT INTO ncf_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Iesu ga asaaiti, “Papaalii ia. A uuli abala daan tso ga aturungi liiliisi leng ina di ba ta punami iaa. ");
INSERT INTO ncf_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","No muunwas di ba tigiri manman mii gim, oro iaa ba xap tigiri manman mii gim.” ");
INSERT INTO ncf_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","O mil xaraxin xumul ina no Jiu di atik tatanginai we Iesu a manman Betani ma di ga xaalame. A xap ngali Iesu mu, di we di na lasi Lasarus, iwaa Iesu ta atapaasi sin minet. ");
INSERT INTO ncf_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ma no lalaamua ina no unsausawit di ga ngiti bula ngali sas amantei Lasarus. ");
INSERT INTO ncf_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Amuina sin ia mu, xuduxudu ina no Jiu di laa sangan Iesu ma di ga taltaalnge sin ia. ");
INSERT INTO ncf_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Leng papan, xariin xumul, biaa di ta xaalame sin abia luxaal, di alongmen we Iesu naba xaalame Jerusalem. ");
INSERT INTO ncf_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ma di ga adi no lexe ina baibai ma di ga laa ngali sabasue ia, ma di ga tol, “Osaana!” “Atubudaani, iwaa ta xaalame sin xan iesan Orong!” “Atubudaani xadi king no Israel!” ");
INSERT INTO ncf_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iesu atatangina iexa donki dokdok, ma ga tsotso papan, malen inaatel ta tore: ");
INSERT INTO ncf_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“U nangaam mataa, tsaana in Saion. U na lasi, num king ia ta xaalame, A tsotso papan taaluna donki uul!” ");
INSERT INTO ncf_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Setauan, xan no tsi asasing di tii xap leng sin abala no maarang; oro mu mil Moroaa ta aminaalami Iesu, di ga adodomi maaba we, balawaa no maarang di tii atalaa ngali ia, ma di se xosaraa abia no maarang laa sin. ");
INSERT INTO ncf_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Biaa xumul di ta manman mii biaa tii ilei atsuulngi Lasarus xaal lalon io ma ga atapaasi sin minet, di lo papaatinai abia totore. ");
INSERT INTO ncf_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Xuduxudu ina no inaman di laa es balsi ia. Amuina di tii se alongmen abia axixila ta xosaraa. ");
INSERT INTO ncf_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Biaabi no Paarasi di ga paare laa sin di tsaa we, “Gim lasi, gita ba xap xosor puaa xawas. Gutuu atsoxaa, balawaa xolkolmoxo araraa a se amusili ia.” ");
INSERT INTO ncf_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Talaawaa biexaa Gentail lolobet ina di, di tii laa langaari mii di sin xariin luxaal. ");
INSERT INTO ncf_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Di xaalame sangan Pilip, ia in Betasaida lalon xariin xolot Galili di ga ningi, “Taamat laba, giem saan ngali lasi Iesu.” ");
INSERT INTO ncf_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilip a laa ngali asaaiti Endru, ma delu arie, delu ga asaaiti Iesu. ");
INSERT INTO ncf_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Iesu a xisi ga we, “Xolot ina leng a se tsap ngali Moroaa naba aminaalami xan Tsi Taamat. ");
INSERT INTO ncf_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Iaa asaaiti gim taman so, nawe xa xalitsa ina wit a xap xol papan pula o na met, aman tsaa malen xalitsa axuuk. Oro, nawe amet naba atsapngen no daan xalitsa. ");
INSERT INTO ncf_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nawe taamat a titii buxaai xan tino lalon xolkolmoxo, naba xosorlii xan tino, oro iwaa xa ta ngutsulen tsaa xan tino, naba adi tino laaliu. ");
INSERT INTO ncf_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Iwaa ta taxaa sin iaa na amusili iaa, o itaa iaa ta manman ia bula naba manman mii iaa. Nugu Mom naba manglen iwaa ta taxaa sin iaa. ");
INSERT INTO ncf_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Talaawaa nugu butsa asuk mamaet, ma iaa ba paatina sa? ‘Mom nangaam papaalii iaa ngali iaa ba saaen sosong.’ A xap, sin abala muina mu, iaa ga xaalame sin abala xolot ina leng. ");
INSERT INTO ncf_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Mom, aminaalami tsaa iesaam!” Mil inan Moroaa axaal balalangit ga we, “Iaa se aminaalami, ma iaa ba sebula aminaalami.” ");
INSERT INTO ncf_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Biaa xumul ta man tia di alongmen ma di ga we, “Parpararek.” O biexaal di we, “O xa angelo a papaare sin ia.” ");
INSERT INTO ncf_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Iesu ga we, “Balawaa ina ngali axaautsi gim, a xap ngali nugu mamainaang. ");
INSERT INTO ncf_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Talaawaa leng ina ininte. Lalon abala xolkolmoxo Saatan iwaa lalaamua ina abala xolkolmoxo di ba tsikli. ");
INSERT INTO ncf_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Oro iaa, biaa di ba ta alet laangen iaa lapalaa sin xolkolmoxo, iaa ba giwaa no inaman araraa xaalame sin iaa tsaa.” ");
INSERT INTO ncf_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","A paatina abala no ngali asen biaa mat laxen minet, ia naba ta met sin. ");
INSERT INTO ncf_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Biaa xumul di xisi di ga we, “Nagiem lo a we, Karisito naba manman laaliu. O asen parawe gim ta tore we, ‘Xan Tsi Taamat na suk alet laangen lapalaa?’ Saa ia xan tsi taamat?” ");
INSERT INTO ncf_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","O Iesu ga asaaiti di, “Biaa laleng naba ta manman mii gim arom dis dokdok. Biaa ta leng tsaa, gim na eses ngali biaa lodo naba xap baaii gim. Iwaa xa ta eses lalon lodo, a xap atii itaa a laa. ");
INSERT INTO ncf_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Taltaalnge sin laleng, biaa ta manman tsaa mii gim. Ngalibi, gim ba tsap xan no tsi laleng.” Mil Iesu a se papaare xap, o ga se laa ma ga xuxii sin di. ");
INSERT INTO ncf_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Biaabi Iesu tii lo xoxosaraa no daan axixila nan no matan di, oro di ga xap saan tsaa ngali taltaalnge sin ia. ");
INSERT INTO ncf_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Balawaa ngali atsapngen so xan totore Aisaia iwaa propet, “Orong, saa ia ta se taltaalnge sin xida no totore ma sin saa, xan liman Orong a se asen sin?” ");
INSERT INTO ncf_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Sin abala muina mu o di ga xap pupua ngali taltaalnge amuina Aisaia a se asaait bula: ");
INSERT INTO ncf_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“A se ababai no matan di ma a se xap xa sasaae lalon xadi no balan, o di ga xap pupua ngali nanen taman no matan di, o di ga xap pupua ngali atixi taman xan di no butsa. Oro di ba puxisbal ngali iaa ma ba atoaa di.” ");
INSERT INTO ncf_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia tii paare leng taman abala no maarang sin ta lasi xan minaalam Iesu o ga paare taman ia. ");
INSERT INTO ncf_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Oro labatina no lalaamua ina no Jiu, xuduxudu ina di, di taltaalnge sin ia. O di ga xap asaait leng taman amuina di mataa, we no Paarasi di ba imii atsuulngi di lalon anua sausawit, xadi no Jiu. ");
INSERT INTO ncf_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Di suk titii buxaai xadi no pinpinis no inaman ngen xan pinpinis Moroaa. ");
INSERT INTO ncf_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Iesu atol ga we, “Iwaa xa ta taalnge sin iaa a xap taltaalnge sin iaa mu, a xap, oro a taltaalnge bula sin iwaa ta tulen iaa. ");
INSERT INTO ncf_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Iwaa xa ta lasi iaa, a lasi iwaa ta tulen iaa xaalame. ");
INSERT INTO ncf_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Iaa se xaalame malen laleng ina abala xolkolmoxo, ngali saa ia ta taltaalnge sin iaa, naba xap manman lalon lodo. ");
INSERT INTO ncf_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Nawe xa a xap alongmen nugu no totore ga xap amusili no, iaa ba xap inten ia, amuina iaa xap xaalame ngali ininte sin no inaman lalon xolkolmoxo, a xap, iaa xaalame ngali aleiwaai di. ");
INSERT INTO ncf_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Iwaa ta taaltalu sin nugu no totore ga xap amusili no biaa totore mu naba ininte sin ia. Balawaa totore iaa ta se paare taman biaa mu totore naba ininte sin ia sin xapkap ina no leng. ");
INSERT INTO ncf_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Amuina iaa tii xap tore taman nugu adodo tsaa, oro Mom iwaa ta tulen iaa xaalame ngali asaaiti iaa ngali paare ma ngali iaa ba sen paare we. ");
INSERT INTO ncf_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Iaa atii weaatala, xan no papaare watwat a xaa tali tino laaliu. Ngali senaara iaa ta paare taman, biaa mu malen mom ta se asaaiti iaa taman.” ");
INSERT INTO ncf_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Leng ngali Luxaal ina Esliwaa a se atat, o Iesu a se atii we, xan leng ngali papaalii abala xolkolmoxo ina inaman a se xaalame, ngali naba laa sangan Mom. A tigiri titii di malen xan no tsaa, di ta manman lalon xolkolmoxo, oro talaawaa a saan ngali asen we, a titii buxaai di. ");
INSERT INTO ncf_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Iesu mii xan no tsi asasing di se xale sin luxaal nale, Saatan a se tsigaii xan adodo tsaa Judas Iskariot, xan tsi Saimon ngali babel tali Iesu papan no liman no matenkorot. ");
INSERT INTO ncf_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iesu atii we, xan Mom a se tali sin ia no maarang araraa paina xan banam, ma axaal sin Moroaa ma naba mula laa sin Moroaa, ");
INSERT INTO ncf_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Lalon abia luxaal a til laa lapalaa, axarisli xan uga disdis ta alalen lokobel ma ga alen taawal ulti ia. ");
INSERT INTO ncf_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Mil, aruati daan lalon diis, ga guraii no xaden xan no tsi asasing ma ga a puraa no taman abia taawal ta alen. ");
INSERT INTO ncf_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","A xaalame sangan Saimon Pita, o Saimon Pita ga paare ngali, “Orong, u ba xap guraii no xaʼigi?” ");
INSERT INTO ncf_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Iesu ga xisi, “U xap leng sin sawe iaa ta wena xosaraa atala, oro mil u ba atii.” ");
INSERT INTO ncf_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita a paare we, “A xap, u ba suk xap guraii xaʼigi.” Iesu a xisi, “Nawe iaa ba xap guraii no xaiim, iu ba xap tsap nugu tsi asasing.” ");
INSERT INTO ncf_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saimon Pita a xisi, “Orong, nangaam guraii mu xaʼigi, oro u na guraii no limaaga ma xuaaga bula!” ");
INSERT INTO ncf_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Iesu tii ga xisi, “Saa ia ta se sisil a saan mu ngali na guraii no xaden; no isuaan araraa a xap pun. O gim, gim xap pun, oro axuuk ina gim mu a pun.” ");
INSERT INTO ncf_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Atii saa ina di naba babel tali ia papan no liman no matenkorot, biaabi ga we axuuk mu ia xa ina gim a pun. ");
INSERT INTO ncf_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Biaa Iesu ta se guraii araraai no xaden di, atamtuel sebula lalon xan no uga disdis ma ga mula laa lalon niaan ta tsotso. Ga atsuraa di, “Gim atii ngali sa iaa ta xosaraa abala sin gim? ");
INSERT INTO ncf_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Gim putsangi iaa ‘Unaasasing’ ma ‘Orong,’ a tutiik abia, amuina iaa iwaa mat laxen taamat. ");
INSERT INTO ncf_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Talaawaa biaa iaa ta se guraii no xaden gim malen nagim Orong ma Unaasasing, gim na eguraii engen no xaden gim. ");
INSERT INTO ncf_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Iaa taxaaturungi abala puapua ngali gim na amusili senaara iaa tii se xosaraa sin gim. ");
INSERT INTO ncf_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Iaa asaaiti gim taman so, a xap xa untutule na lot ngen xan manmanel, o xa ngutsu na lot buxa ngen aia xa ta tulen ia. ");
INSERT INTO ncf_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Talaawaa gim ta se atii abala no maarang, Orong naba atubudaani gim nawe gim xosaraa no. ");
INSERT INTO ncf_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Iaa xap paare ngali gim araraa, a xap, iaa atii no saa iaa tii se axilangi di. Balawaa ngali taxaa puaa so Inaatel Pat: ‘Saa ia gelulu ta arie ngani nugu tsoki, naba babel tali iaa.’ ");
INSERT INTO ncf_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Talaawaa iaa asaaiti gim o setauan sin naba tsap, biaa naba ta tsap, gim ba taltaalnge we, ‘Iaa iwaa mu, Iaa.’ ");
INSERT INTO ncf_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Iaa asaaiti gim taman so: saa ia ta sirawaa iwaa xa iaa ta tulen, a malen mu, ta sirawaa iaa, ma iwaa xa ta sirawaa iaa, a sirawaa iwaa xa ta tulen iaa.” ");
INSERT INTO ncf_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Mil ina Iesu ta paare taman abala, nantanuaan asuk mamaet ga paare leng we, “Iaa asaaiti gim taman so: xa ina gim naba babel tali iaa papan no liman no matenkorot.” ");
INSERT INTO ncf_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","No tsi asasing di agar iʼis ngen di. Di araraa di suk xap leng, saa ina di so. ");
INSERT INTO ncf_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Iexa tsi asasing, iwaa Iesu ta suk titii buxaai, tii tsotso sangan ia, ");
INSERT INTO ncf_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","o Saimon Pita ga putmaata ia, “Atsuraa ia, saa so naba babel tali ia?” ");
INSERT INTO ncf_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Iwaa taamat a suxa mula ga ale sin Iesu ga atsuraa, “Orong, saa aia?” ");
INSERT INTO ncf_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Iesu tii ga xisi, “Iwaa xa aia iaa ba ta amadaaki abala pu tsoki lalon diis, iaa na tali sin.” Biaa ta amadaaki pu tsoki lalon diis asuk tali sin Judas Iskariot, xan tsi Saimon. ");
INSERT INTO ncf_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Biaa Judas ta ngani abia tsoki, Saatan asuk tsigaii. Iesu ga asaaiti, “Sawe iu ta saan ngali xosaraa, iu na xosor isagaalen,” ");
INSERT INTO ncf_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","oro, a xap xa ina di tia lalon abia luxaal na atii ngalisa so Iesu ga paare weaatala sin ia. ");
INSERT INTO ncf_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Amuina Judas tii tilaamamil sin no xuxute, o biexaal ina no tsi asasing, di ga adodo we, Iesu a tulen ngali laa uuli xaa was, di ta saan ngali, ngali abia luxaal o ngali tali xaa was sin no muunwas. ");
INSERT INTO ncf_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tiwaa tsaa biaa Judas tii ngani abia tsoki, a suk tsuul, sin ta se bing. ");
INSERT INTO ncf_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Biaa ta se laa, Iesu ga paare, “Talaawaa xan minaalam Xan Tsi Taamat a se tsap lengleng, ma xan minaalam Moroaa a se tsap lengleng sin ia.” ");
INSERT INTO ncf_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nawe Moroaa a adi minaalam sin ia, naba aminaalami xan tsi tsaa ma naba aminaalami ia, tiwaa tsaa. ");
INSERT INTO ncf_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Nugu no tsi, iaa ba xap man buxa mii gim. Gim ba nanen ngali iaa, malen iaa ta se asaaiti no Jiu, talaawaa iaa asaaiti gim: Gim xap pupua ngali laa lalon abia xolot iaa ba ta laa sin. ");
INSERT INTO ncf_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Balawaa papaare watwat uul, iaa ta tali sin gim: Gim na etitii engen gim tsaa. Malen iaa ta titii gim, biaabi gim na etitii engen gim tsaa. ");
INSERT INTO ncf_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Sin abala, no inaman araraa di ba atii we gim nugu no tsi asasing, nawe gim etitii ngen gim tsaa.” ");
INSERT INTO ncf_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimon Pita ga atsuraa ia, “Orong, itaa u ba laa?” Iesu ga xisi, “U xap pupua ngali amusili iaa laa lalon abia xolot talaawaa. Oro, mil maaba iu ba laa itaa iaa ta laa.” ");
INSERT INTO ncf_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita ga sebula atsuraa, “Orong, ngali sa iaa ga xap pupua ngali amusili iu talaawaa? Iaa ba tali nugu tino ma iaa ba met ngali iu.” ");
INSERT INTO ncf_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Mil Iesu ga xisi, “Aso iu ba met ngali iaa? Iaa asaaiti iu so, setauan sin puraa naba ta teng, iu ba uliis nanaatuul we, u xap atii iaa! ");
INSERT INTO ncf_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Nagim no butsa na xap lolbiir ma gim nangaam adodo xuduxudu, gim na taltaalnge sin Moroaa ma taltaalnge bula sin iaa. ");
INSERT INTO ncf_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Lalon xan anua nugu Mom, auus taman no xabin ngali manman; nawe nii xap so iaa nii se asaaiti gim. Iaa ba laa tia ngali taxaaturungi nagim xa xobel. ");
INSERT INTO ncf_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","O nawe iaa laa taxaaturungi xa xobel ngali gim, iaa ba mula ngali le giwaa gim ngali, gim bula gim ba laa manman nan abia xobel iaa ta manman lalon. ");
INSERT INTO ncf_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Gim atii sal ngali laa nan abia xobel iaa ba ta laa sin.” ");
INSERT INTO ncf_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas a paare ngali ia, “Orong giem xap atii itaa iu ba laa, giem ba sen atii wena abia sal?” ");
INSERT INTO ncf_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Iesu a xisi, “Iaa, iaa sal ma iaa so ma iaa tino. Xa naba xap xaalame sin Mom nawe a xap setauan xaalame sin iaa. ");
INSERT INTO ncf_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nawe gim nii suk atii iaa gim nii atii nugu Mom bula. Oro talaawaa ma laa, gim se atii ma gim tii se lasi ia.” ");
INSERT INTO ncf_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilip ga paare, “Asen sin giem num Mom, biaa mu giem ta saan ngali.” ");
INSERT INTO ncf_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Iesu ga xisi, “Pilip, o u tii xap atii iaa tsaa sin abala no leng iaa tii lo manman mii gim? Iwaa xa ta se lasi iaa, a se lasi Mom. Asen parawe u ta we, ‘Asen Mom sin giem?’ ");
INSERT INTO ncf_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Iu xap taltaalnge we iaa manman lalon Mom, o Mom a manman lalon iaa? No totore iaa ta paare taman no sin gim a xap nugu no tsaa, oro iwaa Mom ta manman mii iaa, iwaa aia ta xoxosaraa xan no tinaxaa. ");
INSERT INTO ncf_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Taltaalnge sin iaa, biaa iaa ta we iaa manman lalon Mom, ma ia a manman lalon iaa; o gim na taltaalnge sin no axixila xoror ina xan no tinaxaa tsaa. ");
INSERT INTO ncf_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Iaa asaaiti gim taman so, saa ia, iwaa ta ie tinaalnge sin iaa, naba xosaraa sawe iaa ta se xosaraa. Naba xosaraa no xaraxin maarang ngen abala no, amuina iaa ba laa sangan Mom. ");
INSERT INTO ncf_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Iaa ba xosaraa semaarang gim ta ningi sin iesaaga, ngalibi xan tsi naba tali minaalam laa sin Mom. ");
INSERT INTO ncf_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nawe gim atsuraa iaa ngali xaa was sin iesaaga, iaa ba taxaa puaa. ");
INSERT INTO ncf_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Nawe gim titii iaa, gim ba amusili nugu totore watwat. ");
INSERT INTO ncf_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Iaa ba ningi Mom ngali naba tali iexa Unaananaai xa ngali tiltsomi gim, ma na manman mii gim laaliu, ");
INSERT INTO ncf_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","iwaa Nantanua ina soina. Xolkolmoxo ina inaman naba xap pupua ngali sirawaa, amuina a xap lasi o atii ia. Oro gim atii ia, amuina a manman mii gim ma naba manman lalon gim. ");
INSERT INTO ncf_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Iaa ba xap poroklii gim xasinge malen no nantinmet, iaa ba xaalame sangan gim. ");
INSERT INTO ncf_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","A xap lil o xolkolmoxo naba xap bula lasi iaa, oro gim ba lasi iaa. Amuina iaa tino o gim bula gim ba tino. ");
INSERT INTO ncf_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Sin abia leng gim ba nanxilalaa we, iaa manman lalon Mom, o gim manman lalon iaa o iaa manman lalon gim. ");
INSERT INTO ncf_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Saa ia ta adi nugu no totore watwat ma ga amusili no, iwaa mu aia ta titii iaa. Iwaa xa ta titii iaa, nugu Mom naba titii ia ma iaa bula iaa ba titii ia ma iaa na asen iaa tsaa sin ia.” ");
INSERT INTO ncf_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Mil Judas (a xap Iskariot) ga we, “Oro Orong, ngalisa o u ga we na asen iu tsaa sin giem o a xap sin xolkolmoxo ina inaman?” ");
INSERT INTO ncf_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iesu a xisi, “Nawe saa ia ta titii iaa, naba amusili nugu asasing. Nugu Mom naba titii ia ma gelulu ba xaalame sin ia ma gelulu na tino etaxaa mii ia. ");
INSERT INTO ncf_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Saa ia ta xap titii iaa, naba xap amusili nugu asasing. Balawaa no totore gim ta alongen, a xap nugu no tsaa, xan no Mom iwaa ta tulen iaa. ");
INSERT INTO ncf_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Iaa se asaait taman abala no maarang araraa, biaa iaa ta lo manman etaxaa tsaa mii gim. ");
INSERT INTO ncf_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Oro, Unaananaai xaa iwaa Nantanua Pat iwaa Mom naba ta tulen sin iesaaga. Naba asingan gim taman no mat maarang, ma na sebula asen mulangen sin nagim no adodo no maarang iaa tii asaaiti gim taman. ");
INSERT INTO ncf_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Iaa papaalii malina mii gim, ma iaa tali nugu malina sin gim. Iaa xap tali sin gim malen xolkolmoxo ina inaman ta xaa tali. Gim nangaam lolbiir ma gim na xap mataa. ");
INSERT INTO ncf_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Gim alongen iaa ta asaaiti gim, ‘Iaa ba laa ma iaa ba mula bula.’ Nawe gim titii iaa, gim nii se taton we, iaa ba laa sangan Mom, amuina Mom a lot buxa ngen iaa. ");
INSERT INTO ncf_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","O talaawaa, iaa setauan asaaiti gim, mil naba tsap. O ngali nawe naba tsap gim ba taltaalnge. ");
INSERT INTO ncf_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Iaa ba xap paare adis mii gim, iwaa lalaamua ina xolkolmoxo ina inaman, Saatan, ia ta se xaalame. A xap xaka watwat ngali taxaariti iaa. ");
INSERT INTO ncf_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Biaa ngali, xolkolmoxo na suk atii we iaa titii Mom. Iaa xosaraa semaarang mu Mom ta paare watwat taman. “Gim xaalame, gita na laa. ");
INSERT INTO ncf_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Iaa, aia waain so, o nugu Mom a tapkina uma. ");
INSERT INTO ncf_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","A xitiplii biaa no laxe ina iaa, biaa ta xap xaa waalii xaa waawaan. Ma biaa no laxe araraa ta xaa waalii no waawaan, naba itsilen no ngali di ba waa buxa. ");
INSERT INTO ncf_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Balawaa totore biaa iaa ta se asaaiti gim taman a se itsilen gim tsaa. ");
INSERT INTO ncf_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Gim na tso sin iaa, ma iaa ba tso sin gim. A xap xa laxe na pupua ngali waalii xaa waawaan ia tsaa, a xap, na suk tso sin waain. Gim ba xap waalii xaa waawaan nawe gim xap tso sin iaa. ");
INSERT INTO ncf_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Iaa, aia waain, o gim no laxe. Nawe xa taamat a tso sin iaa, o iaa tso sin, biaabi naba waalii xaa daan waawaan. Nawe a xap tso sin iaa, naba xap pupua ngali xosaraa xawas. ");
INSERT INTO ncf_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nawe xa a xap tso sin iaa, a malen abia laxe di ta lii axumuli ngali naba malang, mil di na axaii. ");
INSERT INTO ncf_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nawe gim tso sin iaa, ma nugu no totore a tso sin gim, gim ba atsura ngali sawe gim ta saan ngali, iaa ba tali sin gim. ");
INSERT INTO ncf_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nawe gim waalii buxaai xaa waawaan, gim ba asen we gim nugu no tsi asasing, biaa ta asen xan minaalam nugu Mom. ");
INSERT INTO ncf_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Iaa se titii gim, malen mu Mom ta titii bula iaa, talaawaa gim na tso lalon nugu titii. ");
INSERT INTO ncf_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nawe gim amusili nugu no totore watwat, gim ba tso lalon nugu titii, malen iaa ta amusili xan no papaare watwat nugu Mom, ma iaa ga tso lalon xan titii. ");
INSERT INTO ncf_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Iaa asaaiti gim taman abala no maarang ngali nugu resres naba manman lalon gim, ngalibi biaa nagim resres naba suk usli. ");
INSERT INTO ncf_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nugu papaare watwat abala, gim na titii engen gim malen Iaa ta titii gim. ");
INSERT INTO ncf_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","A xap xa na ie abia xaraxin titii malen aia xa ta tali xan tino ngali no turan. ");
INSERT INTO ncf_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nawe gim amusili nugu no papaare watwat, gim no turaaga. ");
INSERT INTO ncf_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Iaa xap bula putsangi gim no untutule, a xap, amuina untutule a xap atii xan no tinaxaa xan manmanel, oro iaa putsangi gim no turaaga. Amuina iaa se alengi gim taman no maarang araraa, biaa iaa ta asasing taman no sin Mom. ");
INSERT INTO ncf_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Gim xap axilangi iaa, oro, Iaa, iaa axilangi gim ngali laa ma ngali waalii xaa waawaan. Biaa no waawaan naba ta man laaliu, mil Mom naba tali sawe gim ta ningi sin iesaaga. ");
INSERT INTO ncf_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Balawaa nugu papaare watwat; Gim na etitii engen gim. ");
INSERT INTO ncf_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Nawe xolkolmoxo a ngutsulen gim, gim na adodomi we, tii setauan ngutsulen iaa. ");
INSERT INTO ncf_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nawe gim xan no xolkolmoxo, naba titii gim malen xan no tsaa. Oro gim a xap ina xolkolmoxo, amuina iaa se inten tsaali gim nan xolkolmoxo, biaabi xolkolmoxo ga ngutsulen gim. ");
INSERT INTO ncf_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Gim adodomi abia no totore iaa ta asaaiti gim taman, ‘A xap xa untutule na lot buxa ngen xan manmanel.’ Nawe di tsaalen iaa, di ba tsaalen gim bula; nawe di long amusili nugu asasing, di ba long amusili nagim no asasing bula. ");
INSERT INTO ncf_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Balawaa no maarang di ba xosaraa sin gim, amuina sin iesaaga, di xap atii saa aia ta tulen iaa. ");
INSERT INTO ncf_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nawe iaa nii xap xaalame ma iaa nii xap papaare sin di, di nii ba xap mangiel sin xadi no namaang tsaxa. Oro talaawaa a se xap xadi xaa martsur xadi no namaang tsaxa. ");
INSERT INTO ncf_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Saa ia ta ngutsulen iaa, a ngutsulen bula nugu Mom. ");
INSERT INTO ncf_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nawe iaa nii xap xosaraa biaa no tinaxaa, xa ta xap pupua ngali xosaraa labatina di, di nii xap mangiel sin namaang tsaxa. Oro talaawaa biaa di ta se lasi abala no axixila xoror, di tii ngutsulen arie gelulu nugu Mom. ");
INSERT INTO ncf_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Balawaa ngali taxaawiti biaa totore di ta atalaa lalon xadi lo, ‘Asuk xap xa muina di ga ngutsulen iaa.’ ");
INSERT INTO ncf_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Biaa iwaa Unaananaai xa naba ta xaalame, iwaa iaa ba ta tulen a xaalame sangan gim, xaal sin Mom, ia Nantanua so iwaa ta tsuul xaal sin Mom naba paare leng taman iaa. ");
INSERT INTO ncf_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ma gim bula gim na paare leng, amuina gim tii manman mii iaa sin atiltsoli tsaa. ");
INSERT INTO ncf_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Balawaa no maarang araraa iaa tii se asaaiti gim taman, ngalibi gim ba xap litke. ");
INSERT INTO ncf_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Di ba xalel atsuulngi gim nan anua sausawit; asuk so leng biaa naba ta xaalame biaa xa naba ta tsaapi gim, naba adodo we, a xosaraa abia malen xan tinabel laa sin Moroaa. ");
INSERT INTO ncf_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Di ba xosaraa abia no maarang amuina di xap atii nugu Mom o iaa. ");
INSERT INTO ncf_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Oro Iaa se asaaiti gim taman no, ngali biaa leng naba xaalame gim ba adodomi malen iaa tii se atewaai tsaa gim. Iaa tii xap asaaiti gim setauan amuina iaa manman mii gim. ");
INSERT INTO ncf_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Talaawaa iaa ba laa sangan aia ta tulen iaa, oro a xap xa ina gim na atsuraa iaa, ‘Itaa u laa?’ ");
INSERT INTO ncf_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Oro biaa iaa tii se paare taman abala no maarang, gim ba suk lolbiir buxa. ");
INSERT INTO ncf_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Oro iaa asaaiti gim taman so, ngali nagim axaau iaa ba poroklii gim. Amuina nawe iaa xap laa iwaa Unaananaai xa Nantanua Pat, naba xap xaalame sin gim oro nawe iaa laa, iaa ba tulen ia xaalame sangan gim. ");
INSERT INTO ncf_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Biaa naba ta xaalame ngali tsik asen no untsaxa lalon xolkolmoxo taman namaang tsaxa ma xan namaang tutiik Moroaa ma xan ininte. ");
INSERT INTO ncf_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Naba tsik asen malen di xap tutiik amuina sin xadi no namaang tsaxa di ta xap taltaalnge sin iaa. ");
INSERT INTO ncf_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","O taman namaang tutiik, amuina iaa laa sangan Mom o gim ba xap lasi iaa bula. ");
INSERT INTO ncf_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ma taman ininte, amuina Moroaa tii se ininte sin aia lalaamua ina xolkolmoxo ina inaman, iwaa Saatan. ");
INSERT INTO ncf_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“A xudu buxa no totore bala iaa ta we ina asaaiti gim taman no, oro talaawaa naba suk xap pupua ngali adi. ");
INSERT INTO ncf_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Oro biaa Nantanua ina so naba xaalame, naba laamuangen gim laa nan so araraa, naba xap paare tsaa taman ia, naba paare taman semaarang ta alongen ma naba asaaiti gim taman sawe naba ta xaalame laamua. ");
INSERT INTO ncf_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Naba tali minaalam sin iaa sin ta asaaiti gim taman samaarang ta adi sin iaa ma paate alengi sin gim. ");
INSERT INTO ncf_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Biaa no semaarang araraa xan no Mom, nugu no, biaabi iaa ga paare we, Nantanua naba adi sawe iaa ta tali sin ia ma na alengi sin gim. ");
INSERT INTO ncf_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Dokdok mu gim ba xap lasi iaa bula o mil dokdok mu gim ba lasi iaa.” ");
INSERT INTO ncf_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Biexaal ina xan no tsi asasing di epaare engen di, “Sen muina abala totore ta we, ‘Dokdok mu gim ba xap lasi iaa bula o mil dokdok mu gim ba lasi iaa,’ ma ‘Amuina iaa laa sangan Mom?’ ” ");
INSERT INTO ncf_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Di lo etsura engen di, “Sen muina abala totore ta we ‘dokdok mu?’ Giem xap leng a paare taman sa.” ");
INSERT INTO ncf_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Iesu a lasi malen, di wena atsuraa ia taman abia totore, o ga paare ngali di, “Gim etsura engen gim xuxuuk ngali sen muina ngali biaa, iaa ta we, ‘Dokdok mu gim ba xap lasi iaa bula o mil dokdok mu gim ba lasi iaa?’ ");
INSERT INTO ncf_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Iaa asaaiti gim taman so, gim ba teng ma lolbiir oro xolkolmoxo naba res o gim ba lolbiir, oro num lolbiir naba putsi laa sin tataton. ");
INSERT INTO ncf_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Aina a taktaxaa tsi alet sosong, amuina xan leng a se xaalame, oro nawe a se taxaana xan madalak, naba se adodolii abia xariin sosong amuina sin ta taton sin xan madalak ta se tsap lalon xolkolmoxo. ");
INSERT INTO ncf_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Sin gim talaawaa, nagim leng ina lolbiir, oro iaa ba lasi gim sebula o gim ba taton ma a xap xa naba saali nagim tataton. ");
INSERT INTO ncf_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Sin abia leng gim ba xap atsuraa iaa ngali xawas bula, iaa asaaiti gim taman so nugu Mom naba tali semaarang gim ta atsuraa ngali, sin iesaaga. ");
INSERT INTO ncf_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Pupua talaawaa gim xap mager atsuraa ngali xaa was sin iesaaga. Gim na atsuraa ngali samaarang gim ta saan ngali, ngali gim ba adi, ngali nagim tataton naba suk us araraa. ");
INSERT INTO ncf_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Iaa se xosaraa no totore puapua. Oro leng biaa naba ta xaalame ma iaa ba xap bula paare taman xaa totore puapua, biaa iaa ba ta alengi totore so ina nugu Mom. ");
INSERT INTO ncf_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Sin abia leng, gim ba atsura sin iesaaga o iaa xap paare we, iaa ba atsuraa Mom ngali gim. ");
INSERT INTO ncf_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Mom a titii gim amuina gim tii titii iaa ma gim se taltaalnge we iaa xaal sangan Moroaa. ");
INSERT INTO ncf_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Iaa xaal sangan Mom ma iaa ga tsiga lalon xolkolmoxo ina inaman; talaawaa iaa papaalii xolkolmoxo ma iaa ga mula laa sangan Mom.” ");
INSERT INTO ncf_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Mil xan no tsi asasing Iesu di ga paare, “Talaawaa maaba u ga paare leng sin giem we, biaa u ga xap totore puapua bula. ");
INSERT INTO ncf_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Talaawaa giem se lasi, u atii no maarang araraa, biaabi ga xap xaa na pupua ngali atsura iu bula, talaawaa giem taltaalnge we, aso, u xaal sangan Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Iesu a xisi, “Gim taltaalnge maaba? ");
INSERT INTO ncf_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Lolong, leng biaa naba ta xaalame, ma a se tsap we, gim araraa gim ba sol exatsep laa sin nagim no anua xuxuuk ma gim na papaalii iaa xasinge. Oro Mom naba manman mii iaa. Iaa ba xap manman xasinge. ");
INSERT INTO ncf_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Iaa se asaaiti gim taman abala no maarang, ngalibi, lalon iaa, gim ba adi malina. Lalon abala xolkolmoxo ina inaman gim ba adi no xariin mamaet. Til watwat! Iaa se aiepatsaa xolkolmoxo.” ");
INSERT INTO ncf_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Mulina Iesu ta paare taman abia no maarang, a nanen xaale lapalaa balalangit ma ga ningning: “Mom biaa leng a se xaalame, aminaalami num tsi ngali num tsi naba aminaalami iu. ");
INSERT INTO ncf_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Amuina iu tsaa iu se tali banam sin ia lapalaa papan no inaman araraa ngali naba tali tino laaliu sin abia di araraa iu tii se tali sin ia. ");
INSERT INTO ncf_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Talaawaa balawaa tino laaliu, ngali di ba atii iu, iu mu Moroaa so, ma Iesu Karisito iwaa iu tii tulen. ");
INSERT INTO ncf_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Iaa se asen num minaalam sin xolkolmoxo ina inaman sin iaa ta se araraai abia tinaxaa iu ta tali sin iaa ngali xosaraa. ");
INSERT INTO ncf_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ma talaawaa Mom aminaalami iaa lalon no mataam taman abia minaalam tii manman sin iu setauan tsaa sin xolkolmoxo tii atiltsoli. ");
INSERT INTO ncf_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Iaa se asen iu sin abia di, no saa biaa iu ta tali xaalame sin iaa, xaal sin xolkolmoxo ina inaman. Biaa di num no, iu ta tali di sin iaa ma di ga long amusili num no totore. ");
INSERT INTO ncf_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Talaawaa di atii malen no maarang araraa iu ta tali sin iaa axaal susum. ");
INSERT INTO ncf_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Amuina biaa no inesaait iu tii tali susugu, Iaa tali no sin di, ma di tii ga sirawaa no. Di tii suk atii so malen iaa xaal sin iu, o di ga taltaalnge weaatalaa iu tulen iaa. ");
INSERT INTO ncf_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Iaa ningning ngali di, iaa xap ningning ngali abala xolkolmoxo oro ngali abia di, iu tii se tali sin iaa, amuina di num no tsaa. ");
INSERT INTO ncf_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nugu no maarang araraa num no, o num no maarang araraa nugu no. Ma minaalam a xaalame sin iaa amusili abia no maarang. ");
INSERT INTO ncf_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Iaa ba xap man adis nan xolkolmoxo, Oro di manman tsaa nan xolkolmoxo ma iaa ba xaalame sangan iu. Mom Pat tilkaali di taman xoror ina iesaam–biaa iesaam iu tii tali sin iaa–amuina ngali di ba xuuk mu malen gitaa ta xuuk. ");
INSERT INTO ncf_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Biaa iaa tii manman mii di, iaa ga tilkaali di taman iesaam u tii tali sin iaa; o iaa tii ga tilaamamil sin di. A xap xa na xaapina oro iwaa xa ta xuuk mu ta xaapina iwaa Moroaa naba ta tulen laa sin tsaxa ina, ngalibi Inaatel Pat naba taxaa puaa. ");
INSERT INTO ncf_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Iaa xaalame sangan iu talaawaa, oro iaa paare taman biaa no maarang nan xolkolmoxo, ngalibi nugu tataton naba usli lalon di. ");
INSERT INTO ncf_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Iaa se tali num totore sin di, no inaman lalon xolkolmoxo di ngutsulen di, amuina nugu no inaman di xap ina abala xolkolmoxo malen Iaa bula iaa xap ina abala xolkolmoxo. ");
INSERT INTO ncf_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nugu ningning a xap ngali iu ba saali di lalon xolkolmoxo, oro ngali iu ba tilkaali di sin aia morokon. ");
INSERT INTO ncf_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Di xap ina abala xolkolmoxo, malen iaa bula a xap ina abala xolkolmoxo. ");
INSERT INTO ncf_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Apati di taman soina, num totore asuk so. ");
INSERT INTO ncf_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Malen iu tulen iaa xaalame lalon xolkolmoxo, o iaa tulen di laa lalon xolkolmoxo. ");
INSERT INTO ncf_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ngali xadi axaau, iaa apati iaa tsaa, ngalibi, di bula di ba apati di taman so. ");
INSERT INTO ncf_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Nugu ningning a xap ngali di mu, iaa ningning bula ngali biaa di ba ta taltaalnge sin iaa, amuina sin xadi no inesaait. ");
INSERT INTO ncf_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ma biaa di araraa, di ba tsap xuuk mu, Mom, malen mu iu lalon iaa, ma iaa lalon iu, ngali di bula di ba manman lalon gitaa ngali xolkolmoxo di ba taltaalnge we iu tulen iaa. ");
INSERT INTO ncf_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Iaa tii se tali sin di abia minaalam biaa iu tii tali sin iaa, ngali di ba xuuk malen gitaa ta xuuk. ");
INSERT INTO ncf_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Iaa lalon di ma iu lalon iaa, ngali di ba man taman xuuk bal araraa, ngali xolkolmoxo di ba atii iu tulen iaa ma iaa se titii di malen iu tii se titii iaa. ");
INSERT INTO ncf_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Mom, iaa saan ngali abia di iu tii tali di sin iaa, di ba manman mii iaa itaa iaa ta manman ngalibi di ba lasi nugu minaalam, biaa minaalam iu tii se tali sin iaa amuina iu titii iaa, setauan tsaa sin axoxos ina xolkolmoxo. ");
INSERT INTO ncf_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Mom untutiik laaliu, oro xolkolmoxo a xap atii iu, iaa atii iu. Ma balawaa di ga se atii iu we, iu tulen iaa. ");
INSERT INTO ncf_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Iaa se alengi iu sin di, ma iaa ba tigiri alengi iu, ngali biaa num titii sin iaa naba manman sin di bula, ma ngali iaa tsaa iaa ba manman lalon di.” ");
INSERT INTO ncf_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Biaa tii se ningning araraa, Iesu ma xan no tsi asasing di tapaas ma di tii ga es xitipi maxaaba Kidron. Sin biexa papel ina uma olip biaa, ia mii xan no tsi asasing di tii laa lalon. ");
INSERT INTO ncf_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, iwaa tii babel tali ia nan no liman no matenkorot, tii atik axaautsi abia xolot, amuina Iesu ma xan no tsi asasing di tigiri laa esue lalon abia uma. ");
INSERT INTO ncf_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judas ga laa lalon abia uma, ma ga giwaa no unmakmaxil in Rom ma biaa no unxoxo ina Xan Anua Moroaa di ta manman paina lalaamua ina no unsausawit ma no Paarasi. Di adi no sul ma no mat maarang ina makmaxil. ");
INSERT INTO ncf_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Iesu atii no maarang araraa naba ta tsap sin, a es sabasuei di ma ga atsuraa di, “Gim tsalei saa?” ");
INSERT INTO ncf_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Di xisi, “Giem tsalei Iesu in Nasaret.” Iesu ga paare, “Iaa mu atala.” (Judas, iwaa ta babel tali Iesu, atiltil mii di.) ");
INSERT INTO ncf_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Biaa Iesu ta paare we, “Iaa mu atala,” di suk suxa mula ma di tii ga xol lapula. ");
INSERT INTO ncf_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","A sebula atsuraa di, “Gim tsalei saa?” Di sebula paare, “Giem tsalei Iesu in Nasaret.” ");
INSERT INTO ncf_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Iesu a xisi, “Iaa tii se asaaiti gim, iaa mu Iesu. Nawe gim le tsalei iaa, gim na papaalii abala no taamat di na laa.” ");
INSERT INTO ncf_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Balawaa tii tsap ngali taxaa puaa abia xan totore tii asaaiti xan mom, ga we: “Iaa tii xap xosorlii xa na xuuk ina abia di, iu tii tali sin iaa.” ");
INSERT INTO ncf_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimon Pita adi xan tetel ma ga tal lii talinga mua ina xan untutule lalaamua ina no unsausawit. (Iesan aia untutule Malkus.) ");
INSERT INTO ncf_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Iesu asaait awatwati Pita, “Aturung mulangen num tetel. Asen parawe, iaa ba xap nun nan abia sobuk nugu Mom tii tali sin iaa?” ");
INSERT INTO ncf_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","No unmakmaxil mii xadi lalaamua no unxoxo ina Xan Anua Moroaa di tsiili Iesu ma di ga pitsi ia. ");
INSERT INTO ncf_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Di setauan giwaa laa sangan Anas, iaanmuna ilaa Kaiapas iwaa tii lalaamua ina no unsausawit sin abia miet. (Kaiapas a maxis sin xan tsaana Anas.) ");
INSERT INTO ncf_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiapas, iwaa tii se anaai tsaa no lalaamua ina no Jiu, tii we asuk mamainaang buxa ngali xa taamat na ilua ngali no inaman se araraa. ");
INSERT INTO ncf_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Pita ma iexa tsi asasing delu es amusili Iesu. Amuina iwaa tsi asasing asuk tsiga amusili Iesu laa lalon xolot lokobel ina xan anua Anas amuina iwaa lalaamua ina no unsausawit tii atik axaautsi aia tsi asasing, ");
INSERT INTO ncf_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","oro Pita tii ga til liliis lokobel matenmat. Iexa tsi asasing, unsausawit lapalaa ta atik axaautsi ia, a es mula xaalame matenmat, tii ga paare sin aia tsaana tii tilaamamil sin matenmat, ngali gii atsigali Pita. ");
INSERT INTO ncf_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Iwaa tsaana untutule matenmat tii ga atsuraa Pita, “Iu bula xan tsi asasing aia taamat?” Pita tii ga xisi, “A xap, a xap iaa.” ");
INSERT INTO ncf_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","No unxoxo ina Xan Anua Moroaa ma no untutule di taangi ie ma di ga til malmalil sangan, amuina xobel tii madil buxa, ma Pita bula ga laa til malmalil mii di. ");
INSERT INTO ncf_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Sin abia xolot ina leng, lalaamua ina no unsausawit tii atsuraa Iesu ngali xan no tsi asasing ma xan no asasing. ");
INSERT INTO ncf_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Iesu tii ga xisi, “Iaa xaa paare leng sin xolkolmoxo ina inaman araraa. Iaa tii tigiri asingan no Jiu lalon anua sausawit ma lalon Xan Anua Moroaa, biaa xadi no xolot no inaman Jiu ngali tsaptsap esuei. Iaa xap paare axuina xa totore. ");
INSERT INTO ncf_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Gim atsuraa iaa ngali sa? Gim na atsuraa abia di, di ta alongen iaa, amuina di atii so semaarang iaa ta papaare taman.” ");
INSERT INTO ncf_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Biaa Iesu ta paare taman abala, iexa unxoxo ina Xan Anua Moroaa asuk tabaii ia o ga paare, “Sen mat xixiis abia laa sin lalaamua ina no unsausawit?” ");
INSERT INTO ncf_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Iesu tii ga xisi, “Nawe Iaa paare tsaxa, u na paare leng taman semaarang iaa ta paare tsaxa taman. Oro nawe iaa tii paare so, ngalisa iu ta tabaii iaa?” ");
INSERT INTO ncf_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Mulina abia, Anas a tulen Iesu laa sangan Kaiapas, iwaa lalaamua ina no unsausawit, taman no liman di ta ros atingtingi tsaa. ");
INSERT INTO ncf_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Pita tii til malmalil tsaa sangan ie o di sebula atsuraa, “Iu bula xan tsi asasing?” Pita tii ga uliis, ga paare, “A xap, a xap iaa!” ");
INSERT INTO ncf_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Iexa untutule ina unsausawit lapalaa, asaaiti ia, “Iaa lasi iu mii ia nan uma.” (Iwaa untutule, xan mixap aia taamat Pita ta ritlii talingan nan uma.) ");
INSERT INTO ncf_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pita a sebula uliis. A xap sauna mu, puraa asuk atiltsoli ngali teng. ");
INSERT INTO ncf_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Lawaareng bingbing tsaa no Jiu di giwaa Iesu xaal sangan Kaiapas lalon xan xariin anua Pailat, iwaa gawana in Rom. No Jiu di xap tsiga lalon xan xobel Pailat amuina sin xadi namaang, nawe di tsiga lalon xadi anua no Rom, di ba xap mixat nan no matan Moroaa ngali di ba xap pupua ngali ngani luxaal ina Esliwaa. ");
INSERT INTO ncf_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pailat atsuul lokobel sangan no Jiu ma ga atsuraa di, “Ilawaa taamat a xosaraa atsoti semaarang o gim ga gii a xaalamengen?” ");
INSERT INTO ncf_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Di xisi, “Nawe nii xap taamat tsaxa, giem nii xap le tali pan no limaam.” ");
INSERT INTO ncf_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pailat a paare, “Gim giwaa ma gim na ininte sin, taman nagim no lo tsaa no Jiu.” Oro no Jiu di xisi Pailat, “Giem xap ie banam ngali sas amantei xa taamat.” ");
INSERT INTO ncf_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Balawaa atsap ngali taxaa puaa xan no totore Iesu tii papatina xan minet naba ta sen met we. ");
INSERT INTO ncf_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Biaa Pailat ta sebula tsiga mula laa lalon xariin anua, ga ilei Iesu ma tii ga atsuraa ia, “Iu xadi King no Jiu?” ");
INSERT INTO ncf_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Iesu tii ga atsura, “Balawaa atsutsura num tsaa, o di asaaiti iu mu taman iaa?” ");
INSERT INTO ncf_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pailat a xisi, “Iu we, iaa xa Jiu? Num no inaman ma num no lalaamua ina no unsausawit tsaa di le tali iu papan no limaaga. O u xosaraa sa?” ");
INSERT INTO ncf_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Iesu a paare, “Nugu Maradaan a xap in atala lalon xolkolmoxo. Nawe in atala, nugu no untutule di nii ba sas xaali iaa ngali no Jiu di ba xap tsiili iaa. Oro nugu Maradaan ina biexa xobel xaatsap.” ");
INSERT INTO ncf_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pailat ga paare, “Iu King, ngaa?” Iesu a xisi, “Iou, iaa King malen iu ta se paare. Nugu nagaa tii taxaana iaa, ngali xosaraa abia tinaxaa, ma iaa tii xaalame lalon xolkolmoxo ina inaman ngali paare leng sin no inaman taman totore so. No inaman araraa di ta atii totore so, di alongen iaa.” ");
INSERT INTO ncf_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pailat tii atsura, “Samaarang abia totore so?” A sebula tsuul laa lokobel sangan no Jiu, ga paare, “A xap xa muina ngali ilawaa taamat naba til nan ininte. ");
INSERT INTO ncf_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Sin nagim namaang ina xalkale iaa ba aleiwaai xa xaus na xuuk lalon anua lodo, laa sin gim sin leng ina Esliwaa. Gim saan ngali iaa ba aleiwaai xadi King no Jiu?” ");
INSERT INTO ncf_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Di xuup ma di ga paare, “Na xap aia! U na tali Baraabas sin giem!” Iwaa Baraabas tii unsasas. ");
INSERT INTO ncf_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Mil Pailat tii ga tali Iesu sin no unmakmaxil ma di tii ga ririiti. ");
INSERT INTO ncf_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","No unmakmaxil di xosaraa bungwal taman no suen xoxon ma di ga tsoben papan xuan ma di ga alen tali uga disdis ta de sin ia. ");
INSERT INTO ncf_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Di ga es laa sangan, di rereti, “Iu xadi king no Jiu!” Ma di ga tamtabaii ia sin no paartsen matan. ");
INSERT INTO ncf_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pailat tii sebula mula laa sangan no Jiu, ga paare, “Gim lolong, iaa ba gii xaalamengen sangan gim, ngali gim tsaa, gim ba lasi malen iaa xap tatanginai xa muina ngali ilawaa taamat naba til nan ininte.” ");
INSERT INTO ncf_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Biaa Iesu tii es tsuul taman bungwal ta xoxor papan xuan ma uga disdis ta de, di tii alen tali sin, Pailat paare ngali di, “Lasi, iwaa taamat se aila.” ");
INSERT INTO ncf_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Biaa no lalaamua ina no unsausawit ma no unxoxo ina Xan Anua Moroaa di ta lasi ia, di suk xuup lot, “Ataxiwaa papan tongol! Ataxiwaa papan tongol!” Oro Pailat ga xisi di, “Gim tsaa, gim na giwaa ma ataxiwaa papan tongol. Amuina iaa xap tatanginai xa muina ngali ataxiwaa ia.” ");
INSERT INTO ncf_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","No Jiu di xiis apopogoroi, “Giem ie lo bula, sin abia lo iwaa taamat na met amuina ta paare we, ia xan tsi Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Biaa Pailat tii alongen abia totore, asuk mataa buxa. ");
INSERT INTO ncf_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Atsiga mula laa lalon xariin anua, ga atsuraa Iesu, “Iu in itaa so?” oro Iesu tii ga xap xisi. ");
INSERT INTO ncf_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pailat asaaiti Iesu, “U palo ngali paare mii iaa? O u xap xilalaa iaa, we iaa ie banam ngali aleiwaa iu ma ngali ataxiwaa iu?” ");
INSERT INTO ncf_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Iesu ga xisi, “A xap num ka banam ngali atilngi iaa nan ininte nawe Moroaa nii xap tali sin iu. Sin abia, iwaa taamat tii tali iaa papan no limaam, xan namaang tsaxa a lot buxa sin num namaang tsaxa.” ");
INSERT INTO ncf_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Amuina sin Iesu ta paare, Pailat asuk xonon ngali aleiwaa Iesu. A xap pupua ngali xosaraa amuina no Jiu di xuupkup, di ga we, “Nawe iu aleiwaa aila taamat, a xap turan iu Sisa. Saa ia ta we ia king, a epuske mii Sisa.” ");
INSERT INTO ncf_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Biaa Pailat tii alongen abia, asuk gii atsuulngi Iesu laa lokobel. Pailat tii ga xale papan xan niaan xalkale ina ininte. Iesan abia niaan xalkale, “Sal Xaat ina Eses” (sin totore in Ibru, di putsangi taman ‘Gabbata′). ");
INSERT INTO ncf_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","A se atat ngali tail sin leng ina taxaaturung ngali leng ina Esliwaa. Pailat asaaiti no Jiu, “Ilawaa se nagim king.” ");
INSERT INTO ncf_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","No Jiu di tii xuup mula, “Giwaa laa, giwaa laa, ataxiwaa ia!” Pailat atsuraa di, “Gim saan ngali iaa na ataxiwaa nagim king?” No lalaamua ina no unsausawit, di xisi, “A xap nagiem xa king bula, Sisa ta xuuk mu.” ");
INSERT INTO ncf_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","O sin abia, Pailat a tapaas maaba ma ga tali ia papan no liman di, ngali di ba ataxiwaa papan tongol. O no unmakmaxil di ga giwaa Iesu laa. ");
INSERT INTO ncf_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Iesu tsaa atsaxei xan tongol ma ga es tsuul laa lalon xolot ina Barang (sin totore in Ibru, di putsangi taman ‘Golgaata′). ");
INSERT INTO ncf_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tia Golgaata, di suk ataxiwaa ia papan tongol. Di ataxiwaa bula no taamat alua mii ia, iexa sin papel lima mua o iexa sin lima xaiaar o Iesu lolobet ina delulu. ");
INSERT INTO ncf_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailat atalaa biexa inesaait ma di ga ataxiwaa papan xan tongol Iesu. Biaa inesaait a paare weaatala: “Iesu in Nasaret, xadi king no Jiu.” ");
INSERT INTO ncf_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Xuduxudu ina no Jiu di xoxoti abia inesaait amuina biaa xobel Iesu ta taxiu sin aman atataaen abia inaman laba. Was bula, Pailat atalaa abia pu inesaait taman no mat laxen totore a tuul: Ibru, Latin ma Grik. ");
INSERT INTO ncf_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Lalaamua ina no unsausawit di lasi abia inesaait ma di ga xap taton ngali. Di tapaas ma asaaiti Pailat, “Nangaam atalaa we, ‘Xadi King no Jiu,’ oro u na atalaa, ilawaa taamat a we ia xadi King no Jiu.” ");
INSERT INTO ncf_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pailat a xisi di, “Samaarang iaa ta se atalaa, biaa mu. Iaa se atalaa.” ");
INSERT INTO ncf_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Mulina no unmakmaxil di ta se ataxiwaa Iesu papan tongol, di adi xan no uga disdis ma di ga exasen no lolobet ina di sin no nabuk ta et. Taamat axuuk adi xan nabuk. Uga disdis a manman tsaa. Di adi uga disdis, biaa di ta ili xaal lapalaa laa pupua lapula, biaa di ta xap tsik xaili todomien lolobet. ");
INSERT INTO ncf_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ma di ga epaare engen di, “Gita na xap tatari abala uga disdis, oro gita na uraura ngali saa naba adi.” Balawaa atsap ngali taxaawiti Inaatel Pat ta paare we, “Di exasen nugu no uga lolobet ina di, ma di uraura ngali nugu uga disdis iaa ta alalen.” Balawaabi no unmakmaxil di tii ga xosaraa abala no maarang. ");
INSERT INTO ncf_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Biaa di, di tii tiltil sangan xan tongol Iesu: xan nagaa Iesu tsaa, tawaneina, xan nagaa, Maria xan tubu Kolopas, ma Maria Magdalin. ");
INSERT INTO ncf_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Biaa Iesu ta lasi xan nagaa ta tiltil, mii iwaa xan tsi asasing, ta xaa suk titii buxaai, a paare ngali xan nagaa, “Aina, num tsi aia.” ");
INSERT INTO ncf_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ma ngali aia tsi asasing a we, “Num nagaa aia.” Sin abia leng, iwaa tsi asasing a giwaa xan nagaa Iesu ngali laa manman tatan. ");
INSERT INTO ncf_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Iesu a se atii we xan no tinaxaa araraa a se xap, malen xan Mom ta tulen ngali le xosaraa. O ngali taxaawiti Inaatel Pat, Iesu ga paare, “Iaa marua!” ");
INSERT INTO ncf_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Sobuk taman waain manuul a manman mu tia sangan di, di adi xoltin ututes ma di ga iwaa lalon abia waain manuul, di ga pis tali sin laxe ina isop, ma di ga tsulen laa sin no bulina Iesu. ");
INSERT INTO ncf_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Biaa Iesu ta nonopi ga xonmen araraai abia waain manuul, ga paare, “A se xap.” Mil ga atudungi xuan ma ga poroklii xan tino. ");
INSERT INTO ncf_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Sin abia leng ina taxaaturung ngali leng Saabat sin leng papan o no Jiu di ga palo ngali abia tuu ilua na taxiu lapalaa papan no tongol sin leng Saabat. Biaabi no Jiu di ga atsuraa Pailat ngali di ba pan xudili no xaden abia tuu taamat detuu ta taxiu lapalaa papan no tongol. Di atsuraa ia amuina di saan ngali di ba met isagaa, ngali di ba saali di laamuaan Leng Saabat. ");
INSERT INTO ncf_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Sin abia, no unmakmaxil di setauan laa ma xudili no xaden abia lo taamat delu ta taxiu mii Iesu. ");
INSERT INTO ncf_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Biaa di ta xaalame sin Iesu, di le tatanginai Iesu ta se met. Biaabi di ga xap xudili no xaden. ");
INSERT INTO ncf_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Oro, iexa unmakmaxil a laa ma tsoxaa Iesu sin xan baralus taman bili o dal ma daan ga rue tsuul xaal lalon no isuaan. ");
INSERT INTO ncf_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Balawaa papaare leng axaal sin taamat tii lasi abala no maarang taman no matan. Biaa no maarang ta paatina aso ma ga atii we a paare taman so, ngali gim bula, gim ba taltaalnge. ");
INSERT INTO ncf_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Balawaa no maarang atsap ngali taxaawiti Inaatel Pat ta paare, “Naba xap xakaa tuen naba tamkudil.” ");
INSERT INTO ncf_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ma biexa xolot bula lalon Inaatel Pat ta we, “No inaman di ba nanen sin iwaa di ta tsoxaa.” ");
INSERT INTO ncf_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Mulina abia no maarang ta se tsap, Josep in Arimatia a le atsuraa Pailat ngali adi xan pakpak Iesu ngali laa punami. Josep bula xan tsi asasing Iesu, o tii ga xaa es xuxii, amuina tii mataatinai no Jiu. Pailat asiriwaa Josep, ma ga laa adi xan pakpak Iesu. ");
INSERT INTO ncf_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimas, iwaa ta ben laa sangan Iesu nabing, a laa bula mii Josep, ga adi no daanwe ta tso mamainaang, di ta aturung tadamien no, ngali aturungi sin no isuaan Iesu ngali taxaaturungi ngali punami. Biaa no daanwe tso, xadi no iliil ta pupua malen no sangaul a tuul ma ga laa et ina kilogram. ");
INSERT INTO ncf_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Delu adi xan pakpak Iesu ma delu ga laa isi taman no uga, di ta tater adisi no, mii abia no daanwe ta tso mamainaang malen xadi namaang ina pupuna no Jiu. ");
INSERT INTO ncf_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Sangan abia xolot Iesu ta taxiu tia biexa uma biaa. Lalon abia uma lia pupuna uul biaa ngali pupuna, di ta xap mager pupuna lalon. ");
INSERT INTO ncf_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Delu atetei Iesu lalon abia lia pupuna ta atat mu amuina xadi leng no Jiu ina taxaaturung ngali leng Saabat. ");
INSERT INTO ncf_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Lawaareng bingbing sin nanaaxuuk ina leng ina wik, Maria Magdalin a laa lasi abia lia pupuna di ta atetei Iesu lalon ma ga lasi biaa xaat, di tii tsaxali matan lia pupuna taman ta se xap manman. ");
INSERT INTO ncf_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","A tapaas ma ga sol laa sangan Saimon Pita mii iexa tsi asasing, iwaa Iesu ta suk titii buxaai, ga paare, “Di se adi Orong lalon lia pupuna o gita xap atii itaa di se laa taman!” ");
INSERT INTO ncf_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","O Pita ma iexa tsi asasing, delu ga tapaas ngali laa lasi abia lia pupuna. ");
INSERT INTO ncf_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Delu arie solsol, o iwaa tsi asasing asuk sol leiwaa Pita ma ga setauan laa tsap sangan lia pupuna. ");
INSERT INTO ncf_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Atudu ma ga nanen tsiga, ga lasi mu no pu uga di ta isi Iesu taman no ta matmatuul. Oro ia tsaa a xap tsiga. ");
INSERT INTO ncf_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saimon Pita a se le sol tsap ma ga tsiga laa lalon lia pupuna. A lasi no pu uga ta matmatuul mu tia, ");
INSERT INTO ncf_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ma biexa uga bula di tii ngaati xuan Iesu taman, a xap matul etaxaa mii biexaal. Amat malen xa a puti aturungi sin biexa papel ma di xap matul etaxaa. ");
INSERT INTO ncf_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Iwaa tsi asasing ta setauan sol tsap sangan lia pupuna, atsiga amil, tii ga lasi ma tii ga taltaalnge. ");
INSERT INTO ncf_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Di tii xap muun leng tsaa sin Inaatel Pat tii paare taman Iesu, naba ta tapaas mula sin minet.) ");
INSERT INTO ncf_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","No tsi asasing di se mula laa lalon no tatan di, ");
INSERT INTO ncf_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Oro ilaa Maria a til tengteng lokobel matan lia pupuna. O ga we a tudu ngali nanen tsiga lalon, ");
INSERT INTO ncf_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","a lasi no angelo ta lua delu ta tsotso lalon abia xolot di ta atetei Iesu tia. Delu tamtuel lalon no uga ta iaas. Iexa a tsotso sin niaan xuan o iexa sin niaan no xaden. ");
INSERT INTO ncf_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Delu ga atsuraa, “Aina, u teng ngali saa?” Maria a xisi, “Di se adi xan pakpak nugu Orong, o iaa xap atii itaa di se laa taman.” ");
INSERT INTO ncf_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Maria aputsi o ga lasi Iesu ta tiltil, ma ga xap xilalaa we ia Iesu. ");
INSERT INTO ncf_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Iesu a paare, “Aina, u teng ngali sa? U nanen ngali saa?” Maria a sorowe ia untinaxaa tia lalon uma, ga paare, “Nugu taamat, nawe u se adi ia ma u ga laa aturungi lalon xa xolot, u na asaaiti iaa ngali iaa ba laa adi ia.” ");
INSERT INTO ncf_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Iesu a putsangi iesan, “Maria.” O Maria ga agar laa sangan o ga suk ilei, “Rabai!” (Totore in Ibru malen unaasasing). ");
INSERT INTO ncf_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Iesu ga paare sin, “Nangaam taana iaa, amuina iaa xap mager mula laa sangan nugu Mom. U na laa sangan no turaagamasen ma u na asaaiti di, ‘Iaa ba se mula laa sangan nugu Mom ma nagim Mom bula, nugu Moroaa ma nagim Moroaa bula.’ ” ");
INSERT INTO ncf_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maria Magdalin a laa sangan no tsi asasing taman inesaait: “Iaa tii se lasi Orong!” O tii ga asaaiti di taman abia no totore Iesu tii asaaiti taman. ");
INSERT INTO ncf_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","A se nale sin abia nanaaxuuk ina leng ina wik, o no tsi asasing di man etudim naanua lalon no mat tsinaxil, amuina di ta mataatinai no Jiu. O Iesu tii ga xaalame ma ga le til labatina di, ga paare, “Malina naba manman mii gim!” ");
INSERT INTO ncf_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Mil sin ta papaare araraa taman abia ma tii ga asen no liman ma xan lus. Biaa no tsi asasing di tii lasi Orong, di suk taton buxa. ");
INSERT INTO ncf_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Iesu a sebula paare ngali di, “Malina naba manman mii gim! Mom tii se tulen iaa, ma iaa bula, iaa tulen gim.” ");
INSERT INTO ncf_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tii se paare araraa sin di o tii ga xuu tali maal sin di ma ga asaaiti di, “Gim adi Nantanua Pat. ");
INSERT INTO ncf_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nawe gim adodolii xadi no namaang tsaxa no inaman, Moroaa bula naba adodolii nagim no namaang tsaxa, o nawe gim xap adodolii xadi no namaang tsaxa no inaman, Moroaa bula naba xap adodolii xadi no namaang tsaxa.” ");
INSERT INTO ncf_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomas (di putsangi bula Didimus), ia ina sangaul axuuk ma ga laa lua, tii xap manman mii abia no tsi asasing Iesu tii le tsap tatanginai di. ");
INSERT INTO ncf_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Biexaa tsi asasing di tii ga asaaiti ia, “Giem se lasi Orong!” Oro tii ga xisi di, “Nawe iaa xap lasi no niaan nil sin xan no liman, ma nawe iaa xap taana taman nugu kakaalis, ma nawe iaa xap aturungi limaaga sin niaan ina xan lus, iaa ba suk xap taltaalnge.” ");
INSERT INTO ncf_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wik axuuk mil o no tsi asasing di sebula man etudim lalon anua. Tomas bula a manman mii di. No mat atsaxil araraa o Iesu tii ga xaalame, ga le til labatina di ma ga we, “Malina naba manman mii gim.” ");
INSERT INTO ncf_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Mil tii ga asaaiti Tomas, “U na aturungi num kakaalis atala ma u na lasi no liman iaa, ma u na tulsi limaam ma u na aturungi tala lalon nugu lus. Nangaam adodo xuduxudu, u na taalnge mu.” ");
INSERT INTO ncf_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas tii ga paare ngali ia, “Nugu Orong ma nugu Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Mil Iesu tii ga asaaiti ia, “U lasi iaa maaba o u ga taltaalnge, ngaa? Atubudaani abia di, di tii xap lasi iaa, o di tii ga taltaalnge.” ");
INSERT INTO ncf_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","No tsi asasing di lasi Iesu ta xosaraa xuduxudu ina no axixila xoror ngali asen malen ia xan tsi Moroaa o iaa ga xap atal araraai biexaal ina abala no axixila lalon abala buk. ");
INSERT INTO ncf_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Balawaa no mat maarang iaa tii se atalaa no, ngali u ba taltaalnge we, Iesu ia Karisito, xan tsi Moroaa, ma sin num tinaalnge u ba adi tino laaliu sin iesan. ");
INSERT INTO ncf_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Mil sin biexa leng Iesu a sebula asemat sangan xan no tsi asasing lalon daan ulis Taiberias. Atsap weaatalaa: ");
INSERT INTO ncf_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita, Tomas (di putsangi taman Didimus), Natanael in Kaana, lalon xobel Galili, xan no tsi Sebedi, ma biexaa tsi asasing ta lua di ta manman etudim. ");
INSERT INTO ncf_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pita asaaiti di, “Iaa ben laa tsulau.” Di ga xisi, “Lowas, giem ba laa mii iu.” Di tapaas ma en lapalaa papan mono ngali laa tsulau. Sin abia bing di suk xap muun adi tsaa xa xo. ");
INSERT INTO ncf_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Lawaareng bingbing, Iesu a se tiltil tia xuen. Oro no tsi asasing di xap muun nen xilalaa we Iesu aia. ");
INSERT INTO ncf_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Iesu ga ilei laa ngali di, ga paare, “No turaaga, nagim xaa xoo se biaa?” Di tii ga xisi, “A xap.” ");
INSERT INTO ncf_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Tii ga asaaiti di, “Gim na lii nagim uben sin papel lima mua ina mono ngali gim ba adi xaa xoo.” Di lii uben malen abia ta asaaiti di, o di ga wena tataii o di suk xap pupua, amuina uben a mamaxet taman no xo ta xudu. ");
INSERT INTO ncf_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Iwaa tsi asasing Iesu ta suk titii buxaai asaaiti Pita, “Lasi, Orong ailo!” Biaa Saimon Pita tii alongen ta paare, “Orong ailo,” alen axaautsi xan uga disdis (ta lubalii ngali tsulau) asuk pis tsuul papan mono. ");
INSERT INTO ncf_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Biexaa no tsi asasing papan mono, di amil ma di ga tataii amilngen uben taman no xoo, amuina di manman atataen xuen, malen sangsangaul ina no mita. ");
INSERT INTO ncf_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Di laa atal xuen, di ga lasi ie ta se suamles mii no xoo lapalaa papan, ma no tsoki bula sangan ie. ");
INSERT INTO ncf_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Iesu a paare ngali di, “Gim tali xaa xoo tala, biaa gim ta er adi no.” ");
INSERT INTO ncf_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Biaa Saimon Pita aen papan mono ma ga tataii uben laa xuen. Uben asuk us buxa taman no xoo lot, a pupua malen no sangsangaul axuuk ma no sangaul alima ma ga laa tuul (153), o uben ga xap muun tater tsaa. ");
INSERT INTO ncf_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Iesu ga paare ngali di, “Gim xaalame, gim na le angen.” A xap xa ina no tsi asasing na watwat ngali atsuraa, “Saa iu?” Amuina di se atixi ia Orong. ");
INSERT INTO ncf_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Iesu a le adi tsoki ma xoo ma ga tali sin di. ");
INSERT INTO ncf_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Balawaa xan nanaatuul ina xan asemat Iesu sangan xan no tsi asasing mulina ta tapaas mula sin minet. ");
INSERT INTO ncf_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Biaa di tii se angen araraa o Iesu ga atsuraa Saimon Pita, “Saimon, xan tsi ilaa Jon, u suk titii buxaai iaa, ngen abala no tsi asasing?” Saimon Pita ga paare, “O iou, Orong, u atii iaa titii buxaai iu.” Iesu a paare, “Tabali nugu no sipsip dokdok.” ");
INSERT INTO ncf_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Iesu ga sebula atsuraa, “Saimon xan tsi ila Jon, u suk titii buxaai iaa?” Saimon Pita ga sebula xisi, “Iou Orong, u atii iaa titii buxaai iu.” Iesu ga paare, “Tilaamamil sin nugu no sipsip.” ");
INSERT INTO ncf_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Iesu a sebula atsuraa nanaatuul, “Saimon, xan tsi ila Jon, u suk titii buxaai iaa?” Pita tii suk saae atsoti amuina Iesu tii sebula atsuraa nanaatuul, “U suk titii buxaai iaa?” O ga asaaiti, “Orong, u atii no mat maarang se araraa, u atii iaa suk titii buxaai iu.” Iesu ga sebula paare, “Tabali nugu no sipsip. ");
INSERT INTO ncf_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Iaa asaaiti iu so, biaa u tii xulaau, u xaa alen iu tsaa o u ga xaa laa lalon no xolot u ta saan ngali laa tia. Oro biaa u ta maas u ba apalasaa no limaam ngali xa taamat naba alen iu ma naba giwaa iu ngali laa lalon xa xolot u ta xap saan ngali laa lalon.” ");
INSERT INTO ncf_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Iesu a paare taman abala ngali asen abia mat minet Pita naba ta aminaalami Moroaa taman. Mil Iesu ga asaaiti, “Amusili iaa.” ");
INSERT INTO ncf_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita ga putsi ga lasi iwaa tsi asasing, Iesu ta suk titii buxaai ta es amusili delulu, asuk atsuraa Iesu (Iwaa tsi asasing tii tsotso a le sin Iesu sin xadi xapkap ina luxaal, tii ga atsuraa Iesu, “Orong, saa naba babel tali iu sin no matenkorot?”) ");
INSERT INTO ncf_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","O biaa Pita ta lasi ia ga atsuraa, “Orong, o ilawaa taamat naba sen parawe?” ");
INSERT INTO ncf_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Iesu tii xisi, “Nawe iaa saan ngali naba tino pupua sin leng iaa ba ta laa mula, o num sen xolot? U na amusili iaa.” ");
INSERT INTO ncf_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Amuina sin abala, balawaa inatalem asuk laa araraa labatina no turumasen lalon Karisito, di ga paare we, iwaa tsi asasing naba xap met. Oro Iesu a xap paare we naba xap met. A paare mu we, “Nawe iaa saan ngali naba tino pupua sin leng iaa ba ta laa mula, num sen xolot?” ");
INSERT INTO ncf_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ilawaa mu tsi asasing, tii paare leng taman abala no maarang, ma ga atalaa no. Gita se atii balawaa xan no papaare leng ta paatinai no aso. ");
INSERT INTO ncf_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iesu tii xosaraa biexaa daan maarang bula. Nawe di nii atalaa no araraa, Iaa xap adodo we, balawaa xolkolmoxo ina inaman araraa naba xap xa niaan ngali aturungi abia no buk biaa biexaal di nii atalaa no. ");
INSERT INTO ncf_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiopilis, lalon nugu buk setauan, iaa tii atatal taman no maarang araraa Iesu tii atiltsoli ngali xosaraa ma ngali asasing bula, ");
INSERT INTO ncf_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","til sin abia leng Moroaa ta se giwaa laa balalangit. Mulina tii se tali no papaare watwat taman Nantanua Pat sin xan no aposal biaa tii se axilangi di. ");
INSERT INTO ncf_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Mulina sin xan xaraxin sosong ma minet, tii asen ia tsaa sin biaa no taamat ma ga asen sin no daan sal, ga asoi we, a se tino mula. Tii asemat sin di lalon no sangaul aet ina no leng mulina ta se tapaas mula ma tii ga paatinai xan Maradaan Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Sin biexa leng di xale exumule, o Iesu tii ga xale angangen mii di o tii ga asaaiti di taman abala papaare watwat: “Gim nangaam papaalii Jerusalem, oro gim na liliis ngali abia tinabel biaa nugu Mom ta se xubu tali sin gim biaa gim ta se longmien, iaa tii se asaaiti gim taman. ");
INSERT INTO ncf_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon axaxadaan taman daan oro sin abala no leng mu Moroaa naba axadaani gim taman Nantanua Pat.” ");
INSERT INTO ncf_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Biaa di ta tsap exumule, di atsuraa ia, “Orong, sin abala leng u ba sebula axos mulangenai biaa Maradaan laa sin no Israel?” ");
INSERT INTO ncf_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Iesu a paare ngali di ma ga we, “A xap ngali gim ngali atii leng ma xolot ina leng, nugu Mom ta se axilangi sin xan banam tsaa. ");
INSERT INTO ncf_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Oro gim ba adi xoror biaa Nantanua Pat ta xaalame papan gim ma gim ba asaait leng so taman iaa lalon Jerusalem ma laa sin no xolot araraa Judaia ma Samaria ma laa sin xapkap ina xolkolmoxo ina inaman.” ");
INSERT INTO ncf_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Mulina ta se paare taman abala no, Moroaa a se gii laangen ia laa lapalaa laamuaan di ma xelangit ga axuina ia pan no matan di. ");
INSERT INTO ncf_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Di lo til nanen amusili ia laa lapalaa balalangit, o a xap sauna mu no taamat ta lua, delu ugauga iaas, delu ga se le til sangan di. ");
INSERT INTO ncf_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Delu ga paare we, “No taamat in Galili, ngalisa gim ta tiltil atala nanen laa nan wang? Ilawaa mu uk Iesu, Moroaa ta se giwaa sangan gim laa balalangit, naba bula mula xaalame sin abia uk sal gim ta se lasi ta laa balalangit.” ");
INSERT INTO ncf_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Di se es papaalii Buk Olip ngali mula laa Jerusalem, balawaa a pupua mu malen axuuk kilomita xaal nan inaman laba. ");
INSERT INTO ncf_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Di se laa tsap Jerusalem, di suk es tsiga laa lapalaa lalon xabin di ta xaa manman lalon. Biaa di tii manman, Pita, Jon, Jeims ma Endru; Pilip ma Tomas, Batalomiu ma Metiu, Jeims xan tsi ilaa Alpias ma Saimon iexa ina no Silot, ma Judas xan tsi ilaa Jeims. ");
INSERT INTO ncf_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Balawaa no taamat di xaa man etudim ngali sausawit mii no aina ma Maria xan nagaa Iesu ma no turamasen. ");
INSERT INTO ncf_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Sin abia no leng, Pita a til laa lapalaa labatina abia malep ina 120 ina no untaltaalnge. ");
INSERT INTO ncf_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ga paare weaatalaa, “Nugu no taamat, no totore lalon Inaatel Pat a se tsap so, setauan tsaa Nantanua Pat tii se asaait, malen balawaa totore tii tsuul xaal sin ngutsina Dewit taman aila taamat Judas, iwaa ta laamungen di ngali tsiili Iesu - ");
INSERT INTO ncf_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ia mu ina gita ma tii xosaraa uk inatalil malen gita.” ");
INSERT INTO ncf_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Judas tii adi abia iliil ngali abia xan namaang tsaxa tii xosaraa, ma ga uuli xoltin pula. Tiwaa tsaa nan abia xolot asuk xol xapil tudu ma xan balan asuk pak ma xan no tine, tii suk lotsul lapula papan pula. ");
INSERT INTO ncf_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Mulina abia, no daan inaman in Jerusalem di se alongen abala, o di ga putsangi iesan abia xolot sin xadi totore Akeldama, muina ina aweaatalaa Pula ina Dal.) ");
INSERT INTO ncf_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita a paare, “Di atatal lalon buk Saam, “‘Xan xalkale tii se biil; ma na xap xa bula na manngi,’ ma ‘xa na adi xan xalkale ina lalaamua.’ ");
INSERT INTO ncf_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Balawaabi, a suk axaau tsaa ngali gita na axilangi xa ina gita ta xaa manman mii gita sin no leng araraa mii Orong Iesu sin xan eses labatina gita, ");
INSERT INTO ncf_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","atiltsoli sin xan axaxadaan Jon, til sin leng biaa Moroaa tii giwaa Iesu laa lapalaa papaalii gita. Ngali xa ina abala di na tsap xa tiltsoxoti mii gita taman xan tinapaas mula Iesu.” ");
INSERT INTO ncf_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Di se axilangi no taamat alua, iexa Josep iesan Barsabaas, iesan bula Jastas, ma iexa ilaa Mataias. ");
INSERT INTO ncf_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Mil di ga sausawit we atala, “Orong, iu suk atik axaautsi no butsa giem araraa. U na asen sin giem saa xaawe ina abala delulu u tii se axilangi ");
INSERT INTO ncf_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ngali adi abia inatalil ina aposal, biaa Judas tii papaalii ngali laa man nan xan xobel tsaa.” ");
INSERT INTO ncf_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Mil di tii ga ura-ura taman no xaat ma no xaat di xol laa sin Mataias; biaabi di tii ga xoxot tali ia mii sangaul axuuk ma ga laa xuuk ina aposal. ");
INSERT INTO ncf_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Biaa leng ina Pentikos tii se xaalame, no Aposal araraa di tii se le tsap etudim sin uk xolot. ");
INSERT INTO ncf_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Sauna mu, tengteng ina was ta malen maal watwat, tii xaal balalangit ga maalen tuali abia anua di tii xalkale lalon. ");
INSERT INTO ncf_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Di tii ga lasi malen no xalam ina ie tii tsuul exasen ma ga oles xuxuuk papan di. ");
INSERT INTO ncf_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ma di araraa di ga us taman Nantanua Pat. Di atiltsoli ngali papaare taman no mat laxen totore ina xalam, Nantanua Pat tii ga asingan di. ");
INSERT INTO ncf_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Talaawaa no Jiu biaa di ta mataatinai Moroaa di manman Jerusalem xaal sin no inaman labalaba araraa lalon xolkolmoxo ina inaman. ");
INSERT INTO ncf_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Biaa di tii alongen abala tengteng, malep araraa di suk tsap etudim, ma di tii ga olol amuina di xuxuuk di alongen no untaltaalnge di tii papaare sin xadi no totore xuxuuk tsaa. ");
INSERT INTO ncf_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Di suk olol buxa ma di ga atsura, “Lolong, balawaa no inaman di tii papaare, a xap di araraa in Galili? ");
INSERT INTO ncf_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","O ngalisa gita araraa gita ga alongmen di, ta tsaxali xadi totore tsaa? ");
INSERT INTO ncf_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Giem no inaman in Patia, Mede, Elam; ma xaal Mesopotemia, ma sin no xolot Judaia ma Kapadosia ma xaal Pontus ma Asia, ");
INSERT INTO ncf_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ma xaal Pirigia ma Pampilia xaal Igip ma sin no xolot Libia atataaen Sairen; ma no xibong in Rom. ");
INSERT INTO ncf_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","No Jiu ma no Gentail di ta se tsap no Jiu; ma biexaal ina giem in Kirit ma Arabia. Giem alongen abala no inaman di ta papaare taman nagiem totore tsaa, ngali asaait taman no xariin axixila Moroaa tii se xosaraa!” ");
INSERT INTO ncf_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Di olol ma di ga adodo xuduxudu, ma di ga etsura engen di, “Sen muina abala maarang?” ");
INSERT INTO ncf_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Biexaal di tii paare soloki no untaltaalnge ma di tii ga paare, “Di tii ga nun tangtangabaa buxa taman waain.” ");
INSERT INTO ncf_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pita a laa ma ga til lapalaa mii sangaul axuuk ma ga laa xuuk ina aposal ma ga papaare lot laa sin abia malep: “No turaaga no Jiu ma gim araraa gim ta manman Jerusalem, iaa we ina alengi abala maarang sin gim; gim na suk lolong axaau sin sen maarang iaa ba ta asaaiti gim taman. ");
INSERT INTO ncf_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Balawaa no inaman di xap nun tangtangabaa malen gim ta paare; a xap. Balawaa apaasaaet ina leng tsaa lawaareng! ");
INSERT INTO ncf_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Propet Joel tii ga papaare taman abala tsaa: ");
INSERT INTO ncf_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“‘Moroaa ga paare, “Sin xapkap ina balawaa no leng iaa ba xabaren Nantanuaaga papan no inaman araraa. Nagim no tsixi ma tsaxana di ba tali nugu totore tsaa, Nagim no xulaau di ba lasi no nanen binalang xaal sin iaa, ma nagim no maas di ba balngen no binalang. ");
INSERT INTO ncf_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Sin abia no leng iaa ba xabarenlii Nantanuaaga lalon nugu no untutule taamat ma aina, ma di ba tali xadi totore ina propet tsaa. ");
INSERT INTO ncf_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Iaa ba asen no axixila xoror lapalaa balalangit ma no axixila xoror sin xolkolmoxo lapula, dal ma ie ma ubaas ta butbutu. ");
INSERT INTO ncf_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ma matanios naba putsi laa sin lodo ma uleng naba tok malen dal, setauan sin xaxaalame ina xariin leng ma minaalam ina xan leng Orong. ");
INSERT INTO ncf_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nawe saa ia ta ilei iesan Orong naba tuo.” ’ ");
INSERT INTO ncf_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“No inaman Israel, gim na lolong sin abala: Moroaa tii tulen Iesu in Nasaret xaalame sin gita ngali xosaraa no axixila xoror, no xariin tinaxaa, ma no axixila xoror, biaa Moroaa tii xosaraa no labatina gim sin ia, malen gim tsaa gim ta atii. ");
INSERT INTO ncf_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Moroaa atii sawe naba ta tsap ma sawe tii se ngiti malen ta se tsap biaa gim ta babel tali Iesu. Ma gim tii ga tiltsomi no untsaxa ngali tali ia sin minet, sin gim tii ataxiwaa papan tongol. ");
INSERT INTO ncf_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Oro Moroaa atapaasi ia sin minet ma aleiwaai ia sin sosong watwat ina minet, amuina minet tii ga suk xap pupua ngali taxaariti ia. ");
INSERT INTO ncf_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","King Dewit a paare taman ia, “‘Iaa se lasi Orong ta tigiri laamuangen iaa. Amuina a manman sin nugu lima mua ma iaa ba xap mataa. ");
INSERT INTO ncf_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Amuina sin abia, iaa paʼii iu Moroaa taman taton; nugu pakpak naba iaawis ma liliis lalon tinaalnge, ");
INSERT INTO ncf_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","amuina u ba xap papaalii iaa lalon Edes. U ba xap papaalii iwaa num ta Pat na maraap lalon io. ");
INSERT INTO ncf_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","U tii se asen sin iaa biaa sal ina tino. Ma u ba auusi iaa taman pinaalam ma u ba tigiri manman mii iaa.’ ");
INSERT INTO ncf_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Nugu no taamat, iaa asaaiti gim taman so: Dewit iwaa xida iaaiaa, tii se met ma di ga se punami ma talaawaa xan lia pupuna bala tsaa mii gita sin abala no leng. ");
INSERT INTO ncf_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Oro ia propet ma tii ga se atiixi we Moroaa tii se xubatsi ma waawaalima ngali naba xanei xa ina xan no utmilmil ngali naba tsap king malen ia. ");
INSERT INTO ncf_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Nanen sin sawe naba ta laa xaalame, a se paare taman xan tinapaas mula Karisito, we naba xap papaalii ia lalon suu ina minet ma no isuaan tii xap maraap. ");
INSERT INTO ncf_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Moroaa tii se atapaasi Iesu laa sin tino ma giem araraa no tiltsoxoti ina abala soina. ");
INSERT INTO ncf_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Moroaa tii se giwaa Iesu laa balalangit ma tii ga se xalkale sin lima mua ina xan Mom, ma tii ga se adi Nantanua Pat sin xan Mom malen tii se xubatsi, ma talaawaa tii se xabaren sawe gim ta se lasi ma alongen. ");
INSERT INTO ncf_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Amuina Dewit tii xap laa lapalaa balalangit, oro ia tsaa tii we, “‘Orong asaaiti nugu Orong: “U na tsotso atala sin nugu lima mua ");
INSERT INTO ncf_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","til sin iaa ba ta xosaraa num no matenkorot malen xa niaan xutxutsiil.” ’ ");
INSERT INTO ncf_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Biaabi, no inaman Israel araraa di ba atiixi maaba we: Moroaa a se xosaraa iwaa Iesu, gim tii ataxiwaa, ngali tsap Orong ma Karisito.” ");
INSERT INTO ncf_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Biaa no inaman di alongmen abala xan totore Pita, ma balawaa ga suk tsixi xadi no butsa ma di tii ga paare ngali Pita ma biexaa aposal, “Nagiem no taamat, giem ba se xosaraa sa?” ");
INSERT INTO ncf_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pita tii ga xisi, “Gim na puxisbal ma gim xuxuuk, gim na adi axaxadaan sin iesan Iesu Karisito ngali Moroaa naba adodolii nagim no namaang tsaxa; ma gim ba adi tinabel ina Nantanua Pat. ");
INSERT INTO ncf_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Amuina biaa xuxubu ngali gim ma nagim no tsi ma biaa di, di ta manman palpalaa bula. Ma ngali no inaman araraa Orong xida Moroaa naba ta ilei di.” ");
INSERT INTO ncf_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Taman biexaa totore bula Pita atewaai di ngali di na tilaamamil. A ningi awatwati di we, “Gim na ningi Moroaa ngali naba atoaa gim tsaa ngalibi gim ba xap adi mamaet sin abala no utmilmil tsaxa.” ");
INSERT INTO ncf_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Sin abia leng, di tii sirawaa xan inesaait, biaa di tii axadaani di tii 3,000 ina inaman araraa di tii xoxot tali mii no untaltaalnge. ");
INSERT INTO ncf_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Di tii suk taliil sin alongmen xadi no asasing no aposal, ma di tii ga eturangen di tsaa sin namaang ina tsabaxi tsoki, ma sin sausawit. ");
INSERT INTO ncf_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Di araraa di suk olol ma no aposal di ga xosaraa no axixila xoror. ");
INSERT INTO ncf_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","No untinaalnge araraa di exumule ma di tii ga exasen engen xadi no mat maarang araraa. ");
INSERT INTO ncf_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Di sune taman xadi no xoltin pula, ma xadi no mat maarang araraa ma di adi no xuxute ma exasen laa sin no saa di ta muun. ");
INSERT INTO ncf_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","No leng araraa, di tigiri tsap exumule lalon xolot ina Xan Anua Moroaa ma di tii ga tsabaxi tsoki lalon xadi no matenaanua, ma di ga arie angen taman tataton ma adokdoki di tsaa, ");
INSERT INTO ncf_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","di paipaʼii ma alet laangen iesan Moroaa laa lapalaa ma biexaa inaman in Jerusalem di tii ga bal axaau mu ngali di. Ma sin no leng xuxuuk, Orong agii atsigili no inaman biaa di tii tuo. ");
INSERT INTO ncf_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Sin biexa leng, Pita ma Jon delu es laa lapalaa lalon Xan Anua Moroaa sin leng ina sausawit—sin nanaatuul ina matanios nale. ");
INSERT INTO ncf_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","O iexa taamat xadak tsaxa xaal sin di tii taxaali. Di tii xaa atsotsoi sangan matenmat ina Xan Anua Moroaa, biaa di tii putsangi Matenmat Mirmir. Sin no leng araraa di xaa le atsotsoi ngali ninginingi no inaman, di ta xa es tsiga laa lalon xolot ina Xan Anua Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Biaa iwaa taamat tii lasi Pita ma Jon delu ta we na es tsiga, asuk ningi delulu ngali xaa xuxute. ");
INSERT INTO ncf_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pita ma Jon delu suk nanen tutiik laa sin iwaa taamat. Pita ga paare ngali, “U na nan ariiti gelulu!” ");
INSERT INTO ncf_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ilawaa taamat a nanen ariti Pita ma Jon ga adodo we delu ba tali xawas sin. ");
INSERT INTO ncf_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Oro Pita a paare ngali, “Silwa ma goul a xap nago xaal ina. Oro iaa ba tali semaarang iaa ta tapkina sin iu. Sin iesan Iesu Karisito in Nasaret, u na tapaas ma u na eses.” ");
INSERT INTO ncf_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pita ataxaanai ia sin lima mua ma ga tiltsomi ngali til laa lapalaa. O tiwaa tsaa no xaden ga suk tutiik ma ga se watwat. ");
INSERT INTO ncf_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","A pis laa lapalaa taman no xaden ma tii ga atiltsoli eses. Asuk es tsiga mii Pita ma Jon lalon xolot ina Xan Anua Moroaa ma ga es pispis, paipaʼii Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","No inaman araraa di lasi ta eses ma paipaʼii Moroaa, ");
INSERT INTO ncf_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","di nanxilalaa ia malen iwaa mu taamat ta xaa xalkale ninginingi no inaman sangan matenmat ina xolot ina Xan Anua Moroaa biaa di ta putsangi Matenmat Mirmir. Di suk adodo buxa ma taton sin semaarang ta tsap sin. ");
INSERT INTO ncf_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Iwaa unningning asuk es etaxaa mii Pita ma Jon, o no inaman di tii ga olol buxa ma di ga sol xaalame sangan Pita ma Jon lalon xolot arare ina Xan Anua Moroaa di putsangi xan Paradaa Solomon. ");
INSERT INTO ncf_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Biaa Pita tii lasi abala, asuk paare ngali di, “No inaman in Israel, ngalisa gim ta olol sin abala? Ngalisa gim ta nen ariiti giem? Manaa gim sorowe we gelulu suk tutiik ma sin abala muina gelulu ie xoror ngali atoaa ilawaa taamat ngali naba eses mula. Balawaa a xap so. ");
INSERT INTO ncf_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Xan Moroaa Abaram, Aisak ma Jakop, ia bula xadi Moroaa xida no iaaiaa; a se aminaalami iesan xan untutule Iesu laa lapalaa. Iwaa gim tii siir tali sin Pailat ngali sas amantei o gim tii ga ulislii sin ia. Sin ta we, ‘Na se luba aleiwaai ia.’ ");
INSERT INTO ncf_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Gim ulislii iwaa taamat Pat ma Untutiik gim tii ga atsuraa ngali iwaa unsasas xa ngali na luba tali sin gim. ");
INSERT INTO ncf_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Gim tii ga sas amantei iwaa untino. Oro Moroaa atapaasi sin minet. O talaawaa gelu no tiltsoxoti ina abala maarang. ");
INSERT INTO ncf_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Sin tinaalnge ina iesan Iesu, iwaa taamat gim ta lasi ma atii a ie watwat. Biaa iesan Iesu ma tinaalnge axaal sin ia biaa ta taal araraai abia atotoaa sin ia malen gim araraa gim tii lasi. ");
INSERT INTO ncf_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“O talaawaa no turaagamasen, iaa atiixi we, gim xap atixi samaarang gim mii nagim no lalaamua gim tii xosaraa sin Iesu. ");
INSERT INTO ncf_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Oro talaawaa Moroaa a se taxaa puaa sen inesaait tii paatinai ti laamua sin no propet, biaa tii paare we, Karisito naba saaen sosong. ");
INSERT INTO ncf_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Gim na se puxisbal ma na amusili Moroaa, ngali naba sibilenli nagim no namaang tsaxa. ");
INSERT INTO ncf_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nawe gim xosaraa abia, gim ba atii Moroaa a manman mii gim. Naba tulen iwaa Karisito, iwaa tii se axilangi ngali gim, iwaa Iesu. ");
INSERT INTO ncf_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Na ben man lapalaa balalangit til sin abia leng Moroaa naba xosor auuli no maarang araraa, malen tii se xubatsi laamua tsaa mii xan no propet pat. ");
INSERT INTO ncf_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses tii paare ti laamua we, ‘Iwaa Orong nagim Moroaa naba tali nagim xa propet malen iaa, xaal labatina nagim no inaman tsaa. Gim na lolong axaau sin no mat maarang ta asaaiti gim taman. ");
INSERT INTO ncf_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nawe xa a xap lolong axaau sin iwaa propet, di ba ieslii labatina xan no inaman.’ ");
INSERT INTO ncf_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Asuk so maase, no propet araraa, di xaal sin Samuel ma laa xuduxudu ina no propet di tii paare, ma di tii ga asaait taman abala no leng. ");
INSERT INTO ncf_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Gim xan no utmilmil abia no propet ma ina abia xuxubu, Moroaa tii se xubatsi mii nagim no mom. Tii paare ngali Abaram, ‘Xaal sin num no utmilmil, iaa ba atubudaani no inaman araraa ina abala xolkolmoxo ina inaman.’ ");
INSERT INTO ncf_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Biaa Moroaa tii atapaasi xan untutule, a tulen ia setauan ngali atubudaani gim ngali taaltalu sin nagim no namaang tsaxa.” ");
INSERT INTO ncf_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita ma Jon, delu papaare tsaa sin no inaman, biaa no unsausawit ma iwaa lalaamua ina no unxoxo ina Xan Anua Moroaa, ma no Saadusi di ga xaalame sangan di. ");
INSERT INTO ncf_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Di suk bal tsaxa amuina no aposal di asingan no inaman ma babaais sin Iesu taman tinapaas mula sin minet. ");
INSERT INTO ncf_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Di tsiili Pita ma Jon sin ta se nale bingbing, di aturungi delulu lalon anua lodo ngali laa sin biexa leng. ");
INSERT INTO ncf_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Oro xuduxudu ina inaman di tii alongen abia inesaait ma di tii ga taltaalnge sin Iesu ma xoxot ina abia inaman a laa pupua malen no tausen alima (5,000). ");
INSERT INTO ncf_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Sin leng papan, no lalaamua ma no xusaak ina no Jiu ma no unaasasing ina lo, di tsap etudim tia Jerusalem. ");
INSERT INTO ncf_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas iwaa unsausawit lapalaa mii Kaiapas, ma Jon ma Aleksenda mii biexaa taamat ina abia xan matenaanua iwaa unsausawit lapalaa. ");
INSERT INTO ncf_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Di tii giwaa Pita ma Jon ma di ga atilngi delulu laamuaan di ma di tii ga atiltsoli atsuraa delulu, “Sin xan xoror saa ma sin iesan saa biaa gulu ga xosaraa abala?” ");
INSERT INTO ncf_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","O Pita ta us taman Nantanua Pat, tii ga paare ngali di: “Gim no lalaamua ma no xusaak ina inaman! ");
INSERT INTO ncf_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Nawe gim ininte sin giem, talaawaa, amuina giem ta asen namaang mamainaang sin aia xadak tsaxa ma gim tii ga atsuraa giem ta sen tuo we, ");
INSERT INTO ncf_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","biaabi, gim na atii abala, gim mii no inaman araraa in Israel, sin iesan Iesu Karisito in Nasaret, iwaa gim tii ataxiwaa papan tongol oro iwaa Moroaa tii atapaasi xaal sin minet, o iwaa taamat ta til laamuaan gim, tii ga tuo. ");
INSERT INTO ncf_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ia mu, biaa inaatel ta paare taman, “ ‘Iwaa xaat biaa gim no untunumar gim ta ngutsulen lii. O ia a se tsap martsur ina atkale ina anua.’ ");
INSERT INTO ncf_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Gita ba xap tatanginai atotoaa xa bula sin xa. Amuina a xap xa ies bula paina balalangit iwaa Moroaa ta tali sin no inaman ngali gita na tuo.” ");
INSERT INTO ncf_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Biaa no lalaamua di lasi Pita ma Jon, delu ta xap mataa ma ngali atiixi we delu xap laa nan xa asasing ma delu no taamat gomsaa mu. Di suk olol, ma nan xilalaa we, delu tii etaxaa mii Iesu. ");
INSERT INTO ncf_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Oro di ga lasi iwaa taamat ta se tuo ta tiltil mii delulu tia, oro di xap pupua ngali paatinai xawas ngali epuske mii delulu. ");
INSERT INTO ncf_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Di ga asaaiti awatwati no unxoxo ngali giwaa atsuulngi detatuul alen Sanidrin. Ma di ga exumule ngali atutiki no papaare labatina di ngali sen maarang di ba se xosaraa. ");
INSERT INTO ncf_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Di etsura engen di, “Gita ba xosaraa sa sin abala lo taamat? No inaman araraa di ta manman Jerusalem, di atiixi abala axixila xoror delulu ta xosaraa ma gita ba xap pupua ngali ulis, ‘we a xap tsap.’ ");
INSERT INTO ncf_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Oro ngali tilbanti balawaa maarang ngali na xap tsitsiil laa buxa labatina no inaman, gita na atewaai abala lo taamat we gita ba tali sosong sin delulu nawe delulu asaaiti biexaa inaman taman abala ies.” ");
INSERT INTO ncf_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Di asaait awatwati no unxoxo ngali giwaa atsigili biaa lo taamat ngali tsiga sebula, biaa di ga asaait awatwati delulu ngali delu na xap bula papaare taman Iesu ma asingan xaal taman ia bula. ");
INSERT INTO ncf_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Oro Pita ma Jon delu xisi, “Gim tsaa gim na ininte. Sin sawe ta tutiik lalon no matan Moroaa, ngali amusili gim o ngali amusili Moroaa? ");
INSERT INTO ncf_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ngali abala, gelu ba xap pupua ngali bong ngali papaare taman sen maarang gelu tii se lasi ma longmien.” ");
INSERT INTO ncf_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Mulina di ta anaai awatwati delulu, di ga luba aleiwaa delulu. Di ga xap tatanginai xa xirabas ngali asosongi delulu amuina no inaman di lo paipaʼii Moroaa ngali samaarang tii se tsap. ");
INSERT INTO ncf_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ngali iwaa taamat delu tii xosaraa axixila xoror sin ma tii ga se tuo, xan no miet tii se liwaa no sangaul aet. ");
INSERT INTO ncf_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Biaa, Pita ma Jon delu tii se tsuul leiwaa, delu suk mula laa sangan xadelu no inaman tsaa ma delu ga paatina abia no maarang araraa, lalaamua ina no unsausawit ma no xusaak di tii se paatina sin delulu. ");
INSERT INTO ncf_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Biaa no untaltaalnge di alongen abala, di suk xale etudim taman sausawit laa sin Moroaa. Di ga we, “Belaba Moroaa, iu Unaaxoxos ina balalangit ma xolkolmoxo ma laman ma no mat maarang lalon. ");
INSERT INTO ncf_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Iu papaare taman Nantanua Pat sin num untutule iwaa nagiem iaaiaa Dewit: “ ‘Ngalisa no Gentail di tii bal musteng buxa? Ma ngalisa no inaman in Israel di tii ngiti gomsaai iaa? ");
INSERT INTO ncf_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","No king ina xolkolmoxo di taxaaturung ngali epuske mii iaa ma no lalaamua di exumule ngali epuske mii Orong ma mii iwaa Moroaa tii apati taman olip wel.’ ");
INSERT INTO ncf_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Asuk so, Erot ma Pontius Pailat delu tii le exumule mii no Gentail ma no inaman in Israel lalon abala inaman laba. Di ngiti ngali epuske mii num untutule pat Iesu iwaa u tii se apati malen Mesaia. ");
INSERT INTO ncf_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Di tii tsap exumule ngali xosaraa no daan maarang, biaa sin num xoror ma sirsiir u tii sirawaa ngali naba tsap. ");
INSERT INTO ncf_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Oro talaawaa Orong u na adodomi xadi xuxubu ngali ririiti giem ma awatwati giem, num no untutule, ngali paare taman num totore taman xaraxin watwat. ");
INSERT INTO ncf_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","U na tulsen liman papan no inaman ngali atoaa ma u na xosaraa no mat laxen axixila xoror ma xariin axixila sin iesan iwaa untutule pat Iesu.” ");
INSERT INTO ncf_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Mulina di tii se sausawit xap, biaa anua di ta exumule lalon asuk giis. Ma Nantanua Pat ga tuali di ma di ga papaare taman Xan Totore Moroaa taman xoror ma di ga xap mataa. ");
INSERT INTO ncf_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Biaa no untaltaalnge araraa di uk bal taman adodo ta xuuk mu. A xap xa na paare we xan no maarang xasinge mu, a xap. Oro di exasen xadi no maarang araraa. ");
INSERT INTO ncf_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","No aposal di tii lo papaare leng taman xaraxin xoror ina xan tinapaas mula Orong Iesu ma xan amiimiilam Moroaa ga suk taxaa buxa papan di araraa. ");
INSERT INTO ncf_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","A xap xa labatina di na muun sin luxaal ma biexaa was. Biaa di, di ta ie pula o no anua, di sune taman no ma di ga tali abia xuxute di tii tsiili. ");
INSERT INTO ncf_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ma di tii ga aturungi no, sangan no xaden no aposal, ma di ga exasen no laa sin no saa di tii muun ngali xaa maarang. ");
INSERT INTO ncf_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Iexa taamat, iesan ila Josep ia ina matenbung Liwai, xan xobel so papan ienusa Saipras. Biaa no aposal di a tso iesani taman Banabaas. (Balawaa ies Banabaas muina Tsi ina Ananaai xa.) ");
INSERT INTO ncf_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Tii sune taman xan xoltin pula tsaa laa sin iexa taamat, ma tii ga aturungi abia xuxute sangan no xaden no aposal. ");
INSERT INTO ncf_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Talaawaa iexa taamat, iesan ilaa Ananias o xan tubu iesan ilaa Sapira. Ia tii sune bula taman xan xoltin pula. ");
INSERT INTO ncf_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Oro xolot ina abia xuxute tii axuina ngali xan tsaa, ma xan tubu bula atiixi abala, ma tii ga aturungi xolot mu ina abia xuxute sangan no xaden no aposal. ");
INSERT INTO ncf_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","O Pita ga paare weaatala sin, “Ananias, asen parawe u ga siir tali Saatan ngali tuali num balan ngali u ga apanaai Nantanua Pat ngali axuina xolot ina xuxute u tii adi ina abia num pula? ");
INSERT INTO ncf_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tii xap num xoltin pula sin u ta xap mager sune taman? Mil u ta sune taman, u pupua ngali lii abia xuxute malen u saan ngali. Oro u daraxe we biaa no xuxute araraa ina tinabel. Ngalisa u tii xosaraa abala namaang? U tii se xap apanaai no inaman, oro u tii se apanaai Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Biaa Ananias tii alongen abala asuk xol met lapula. Biaa no inaman di tii alongen abala maarang di tii suk mataa buxa. ");
INSERT INTO ncf_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","No xulaau di tii tsiga ma di ga ngaati taman no laplap ma di tii ga laa punami. ");
INSERT INTO ncf_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","A tuul no aua mil, xan tubu Ananias a le es tsiga, oro a xap atii biaa maarang tii se tsap sin xan maxis. ");
INSERT INTO ncf_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","O Pita tii atsuraa, “Asaaiti iaa balawaa mu se abia xuxute gululu ta adi sin nagulu pula?” Aina a xisi, “Iou, biaa se araraa.” ");
INSERT INTO ncf_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","O Pita ga asaaiti, “Asen parawe gululu ta siir ngali xonon Nantanuaan Orong? Lasi, biaa no taamat di ta punami num maxis biaa se di matenmat, ma di ba alet atsuulngi iu bula.” ");
INSERT INTO ncf_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Sauna mu iwaa aina asuk xol sangan no xaden ma tii ga suk met. No xulaau di le es tsiga ma di tii ga lasi aina ta se met, di ga alet atsuulngi, ma di ga laa punami sangan xan maxis. ");
INSERT INTO ncf_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Xan matenaanua Moroaa in Jerusalem ma biexaa inaman di alongen abala maarang ta tsap di suk mataa buxa. ");
INSERT INTO ncf_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","No aposal di xosaraa no daan mat laxen axixila ma no axixila xoror labatina no inaman. No untaltaalnge araraa di xaa laa tsap esuei papan xan paradaa Solomon. ");
INSERT INTO ncf_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","A xap xa na adodo ngali tsomi di oro di manglen buxaai no inaman. ");
INSERT INTO ncf_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Oro no daan taamat ma aina di tii taltaalnge sin Orong Iesu ma di tii ga xoxot tali di. ");
INSERT INTO ncf_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Sin abala muina no inaman di ga le tali no maramase sin gelgel ina sal ma di ga le atetei di papan no xabangas, ngali xan maliip Pita naba liu papan di sin ta es liwaa di. ");
INSERT INTO ncf_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Malep ina inaman di xaalame sangan no aposal, di xaal sin no inaman laba ulti ma sangan Jerusalem bula, di gii xaalamien xadi no inaman di ta maramase ma biaa di no tanua tsaxa di ta tsigaii di, ma Moroaa ga atoaa di araraa. ");
INSERT INTO ncf_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Lalaamua ina no unsausawit mii xan no turan araraa, biaa no Saadusi, di lasi balawaa no maarang no aposal di tii xosaraa no ma no balan di tii ga suk bal tsaxa buxa. ");
INSERT INTO ncf_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Di tsiili no aposal ma di tii ga tali di lalon anua lodo. ");
INSERT INTO ncf_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Oro sin abia bing, xan angelo Orong atsalali no matenmat ina anua lodo ma ga atsuulngi di lokobel. ");
INSERT INTO ncf_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Ma ga asaaiti di, “Gim laa til lalon xolot ina Xan Anua Moroaa ma gim na asaaiti no inaman taman inesaait araraa ina balawaa tino uul.” ");
INSERT INTO ncf_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","No aposal di amusili abala papaare, di ga laa lalon xolot ina Xan Anua Moroaa lawaareng bingbing ma di tii ga atiltsoli ngali baais laa sin no inaman. Biaa iwaa unsausawit lapalaa mii no turan, di tii tsap exumule, di tii ga ilei Sanidrin, biaa no xusaak araraa in Israel, ma di ga tulen inesaait laa lalon anua lodo ngali di ba tulen no aposal xaalame. ");
INSERT INTO ncf_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Oro biaa di ta tsap nan anua lodo, iwaa lalaamua ina no unxoxo a xap tatanginai no aposal tia biaabi di tii ga mula ma di tii ga asaaiti Sanidrin, ");
INSERT INTO ncf_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Biaa giem ta tsap nan anua lodo, giem tatanginai mat ta tsaxil ma no unxoxo di tii tiltil matan mat. Oro biaa giem tii tsalali mat, giem tii xap lasi xa na manman lalon.” ");
INSERT INTO ncf_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Biaa iwaa lalaamua ina no unxoxo ina Xan Anua Moroaa mii no lalaamua ina no unsausawit di tii alongen abala totore, di tii ga suk adodo xuduxudu we, “Sen maarang a se tsap sin di?” ");
INSERT INTO ncf_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Iexa taamat tii tsap ma tii ga asaaiti di weaatala, “Gim na lolong, biaa no taamat gim tii tali di lalon anua lodo, bile di se tiltil lalon xolot ina Xan Anua Moroaa ma di ga lo asasingan no inaman.” ");
INSERT INTO ncf_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Sin abia iwaa lalaamua ina no unxoxo mii xan no unxoxo di ga laa gii mulangen no aposal xaalame, ma di ga xap xosor atsoti di. Amuina di mataa, we no inaman di ba soro pidili di taman xaa xaat. ");
INSERT INTO ncf_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","No unxoxo di giwaa axaalamen no aposal ma di ga atilngi di lalon no matan Sanidrin ngali no unsausawit lapalaa di ba atsuraa di. ");
INSERT INTO ncf_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Ma ia ga asaaiti di, “Giem se asaait awatwati gim ngali gim ba xap asasing ma baais sin no inaman taman iesan ilawaa taamat. Oro lasi, gim se asingan no inaman sin no xolot araraa in Jerusalem taman abala no asasing! O gim tii ga wena atuti xan minet ilawaa taamat sin giem.” ");
INSERT INTO ncf_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","O Pita mii biexaa no aposal di tii ga xisi di, “Giem ba amusili mu Moroaa, giem na xap amusili xan adodo taamat! ");
INSERT INTO ncf_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Xadi Moroaa xida no mom iwaa tii atapaasi Iesu xaal lalon suu ina minet, mil sin gim tii sas amantei sin gim ta ataxiwaa papan tongol. ");
INSERT INTO ncf_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Moroaa tii atapaasi laa lapalaa sin xan lima mua malen xan tsi pat ma untino, ngali tali sal sin no Israel ngali puxisbal ma Moroaa naba adodolii xida no namaang tsaxa. ");
INSERT INTO ncf_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Giem no tiltsoxoti ina abala no maarang, ma Nantanua Pat bula, iwaa Moroaa tii se tali sin abia di, di ta lolong amusili ia.” ");
INSERT INTO ncf_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Biaa di tii alongen abala xan papaare Pita, di tii suk bal musteng buxa ma di tii ga saan ngali sas amantei di. ");
INSERT INTO ncf_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Oro iexa ina di, ia Paarasi, o iesan ilaa Gamalel, ia unaasasing ina lo ma no inaman di xaa manglen ia. A til laa lapalaa laamuaan abia Sanidrin ma ga asaait ngali gii atsuulngi no taamat ngali laa liliis dokdok lokobel. ");
INSERT INTO ncf_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Gamalel ga asaaiti biaa kaunsel weaatala, “No inaman in Israel, gim na suk tilaamamil sin sawe gim ta we na xosaraa sin abia no taamat. ");
INSERT INTO ncf_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","No leng tii se laa, gim atiixi mu, Teudas tii asemat ma tii ga paare we, ‘Ia taamat laba;’ ma tii ga mat malen 400 ina no inaman di tii amusili. Oro biexaal di sas amantei ia ma biaa no inaman araraa di ta amusili ia, di tii ga sol exatsape, ma biaa xadi tinaxaa tii suk maarang gomsaa mu. ");
INSERT INTO ncf_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","O mil sin ia, leng ina taal ies tii tsap, Judas in Galili tii asemat ma ga laamuangen malep ma di ga amusili ia, oro biexaal di tii sas amantei ia, ma biaa di araraa, di tii amusili ia di tii sol exatsape. ");
INSERT INTO ncf_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Biaabi amuina sin balawaa no maarang, iaa tii ga asaaiti gim ngali gim na xap xosaraa xawas sin balawaa no taamat. Gim na papaalii adamisi di. Gim papaalii di na laa! Amuina nawe balawaa tinaxaa di tii xosaraa, axaal sin xadi adodo no taamat mu, naba maraamen. ");
INSERT INTO ncf_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Oro nawe Moroaa tsaa atapaasi abala tinaxaa, gim xap pupua ngali tilbanti di. Gim ba tatanginai malen gim se esas epuske mii Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Xan totore tii ga putsi xadi no butsa. Di ga ilei atsigili no aposal ma di ga ririiti di. Mil di tii ga paare watwat ngali tilbanti di ngali papaare taman iesan, Iesu bula. Ma di ga luba aleiwaa di. ");
INSERT INTO ncf_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","No aposal di ga papaalii abia Sanidrin, ma di tii ga taton, amuina di atii malen Moroaa amanglen di we, di pupua ngali alet sosong ngali iesan Iesu. ");
INSERT INTO ncf_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ma sin no leng xuxuuk, di laa lalon xolot ina Xan Anua Moroaa ma no anua xuxuuk ngali asingan no inaman ma di xap papaalii tinaxaa ina asasing ma babaais taman inesaait mamainaang ina Iesu iwaa Karisito. ");
INSERT INTO ncf_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Sin abia no leng biaa xoxot ina no tsi asasing di suk malisa. Ma sin abia no tsi asasing di ta totore in Grik, di paare xuduxudu ngali no tsi asasing di ta papaare in Ibru sin no leng xuxuuk, di xap tiltsomi xadi no nal di ta muun sin luxaal. ");
INSERT INTO ncf_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Biaabi sangaul axuuk ma ga laa lua ina aposal araraa, di tii ga axumuli no tsi asasing araraa ma di tii ga asaaiti di, “A xap tutiik ngali giem ngali longlii biaa inatalil ina xan totore Moroaa, ngali giem ba exasen no luxaal. ");
INSERT INTO ncf_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","No turaagamasen, gim na axilangi xaa taamat na paasaalua labatina gim biaa gim ta atii we di us taman Nantanua Pat ma sinaae. Gita ba tali abala tinaxaa laa sin di, ");
INSERT INTO ncf_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ma giem ba taliil sin sausawit ma xosaraa inatalil ina xan totore Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Balawaa ngitngit atatoni biaa malep araraa. Di axilangi Stepan, iwaa taamat ta us taman tinaalnge ma Nantanua Pat. Ma di ga axilangi Pilip ma Prokorus ma Nikanor ma Timon ma Parmenas ma Nikolas, ia taamat in Antiok, tii ia ina no Gentail ma ga tsap xa Jiu. ");
INSERT INTO ncf_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Di tali abala no taamat sin no aposal, ma di tii ga aturung no liman di papan di ma di ga sawit awatwati di ngali xosaraa abala inatalil. ");
INSERT INTO ncf_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Biaabi xan totore Moroaa ga suk laa sin no daan xolot. Xoxot ina no tsi asasing in Jerusalem asuk pis isagaa laa lapalaa ma xuduxudu ina no unsausawit lapalaa di tii tsap no tsi asasing. ");
INSERT INTO ncf_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Talaawaa Stepan, iwaa taamat ta us taman xan amiimiilam ma xoror Moroaa, tii xosaraa no xariin maarang ma no axixila xoror labatina no inaman. ");
INSERT INTO ncf_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Biexaa taamat di tapaas xaal nan Anua Sausawit xadi no inaman leiwaa malen di ta putsangi, no Jiu in Sairin ma Aleksendia ma no prowins ina Silisia ma Asia. Balawaa no taamat di atiltsoli inebut mii Stepan. ");
INSERT INTO ncf_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Oro di ga xap pupua ngali aiepatsaa xan sinaae ma tinaxaa ina Nantanua Pat iwaa ta tali xoror sin ngali papaare. ");
INSERT INTO ncf_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Mil di tii ga paare xuxii ngali atuaai biexaa taamat we, “Giem alongmen Stepan ta paare taman no totore tsaxa ngali Moses ma Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","No inaman ma no xusaak ma no unaasasing ina lo, di bal musteng ngali sawe di tii paatina. Di tii tsiili Stepan ma di tii ga atilngi laamuaan abia Sanidrin. ");
INSERT INTO ncf_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Di giwaa no unaababaa ngali tiltsoxoti di ngali paare leng we, “Ilawaa taamat a xap iaawiis sin papaare epuske ngali abala Xan Anua Pat Moroaa ma biaa xan lo Moses. ");
INSERT INTO ncf_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Giem tii alongen ia ta paare we ilawaa Iesu in Nasaret naba xosor atsoti abala xobel ma na soxisi no namaang Moses tii tali sin gita.” ");
INSERT INTO ncf_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Biaa di, di tii xalkale lalon Sanidrin, di nan ariti Stepan, ma di ga lasi no paartsen matan ta suk malen xa angelo. ");
INSERT INTO ncf_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mil unsausawit lapalaa tii ga atsuraa ia, “Balawaa no papaare aso?” ");
INSERT INTO ncf_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","A xisi, “No turaagamasen ma no mom, gim na lolong sin iaa! Moroaa ina minaalam asemat sin xida mom Abaram biaa tii setauan manman tsaa Mesopotemia, laamua sin tii man Aran. ");
INSERT INTO ncf_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Moroaa asaaiti ia, ‘Poroklii num inaman labalaba ma num no inaman, ma u na laa lalon abia pula iaa ba ta putaasen sin iu.’ ");
INSERT INTO ncf_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Biaabi ga papaalii biaa pula ina matenbung Kaldean ma ga laa manman Aran. Mulina xan minet xan mom, Moroaa a tulen ia laa sin balawaa pula biaa talaawaa gim ta manman lalon. ");
INSERT INTO ncf_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Moroaa tii xap tali xa maarang malen ta momtsoli sin, asuk xap xa xolot ina pula. Oro axubutali ia mii xan no utmilmil mulina ia, di ba xalkale lalon abia pula, sin abia leng Abaram tii xap mager ie tsi. ");
INSERT INTO ncf_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Moroaa tii papaare ngali lalon abala namaang: ‘Num no utmilmil, di ba tsap no xibong lalon xaa inaman labalaba ta xap xadi no tsaa, ma di ba tsap no untutule ma di ba ngungutsen di pupua sin 400 ina miet. ");
INSERT INTO ncf_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Oro iaa ba tali mamaxet sin abia inaman labalaba di ta taxaa paina di, malen no untutule. Mil di ba tsuul lalon abia inaman labalaba ma di ba langaari sin iaa lalon abala xolot.’ ");
INSERT INTO ncf_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Mil Moroaa ga tali abia xuxubu ina xasau. Ma Abaram ga tsap xan mom Aisak ma ga axasaui ia sin no leng ta paasaatuul mulina abia leng di ta taxaana. Mil Aisak ga tsap xan mom Jakop. Jakop atsap xadi mom biaa no sangaul axuuk ma ga laa lua ina xida no iaaiaa. ");
INSERT INTO ncf_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Amuina xida no iaaiaa di tii bal tsaxa ngali Josep, di ga suni taman ia malen untutule laa Igip. Oro Moroaa tii manman mii ia. ");
INSERT INTO ncf_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ma ga aleiwaa ia sin xan no mamaet. A tali sinaae sin Josep ngali naba xosaraa ia ngali adi abia sirsiir axaau sin Paarao, king in Igip, biaabi ga tali ia ngali laamuangen no Igip ma xan no xariin anua. ");
INSERT INTO ncf_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Mil xariin itol ga tsap Igip ma Kaanan ta tali xariin mamaet ma xida no iaaiaa di ga xap pupua ngali tsal luxaal. ");
INSERT INTO ncf_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jakop ga longmien we no xala bilo Igip, asuk tulen xida no iaaiaa sin abia nanaaxuuk ina uwaa. ");
INSERT INTO ncf_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Sin nanaalua ina uwaa, Josep asaaiti no turamasen taman ia saa, ma Paarao tii ga atii xan matenaanua Josep. ");
INSERT INTO ncf_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Mulina abala, Josep ga tulen totore ngali xan mom Jakop ma xan matenaanua araraa, no sangaul apaasaalua ma ga laa lima ina di araraa. ");
INSERT INTO ncf_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Biaa Jakop ta laa lapula Igip ma tiwaa ia mii xida no iaaiaa di tii met. ");
INSERT INTO ncf_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Xadi no iaaiaa di tii alet mulangen xadi no pakpak laa Sekam ma di ga aturungi lalon no lia pupuna biaa Abaram tii iltsoli sin xan no tsi ila Amor itan Sekam taman abia xuxute ta pupua sin abia xolot. ");
INSERT INTO ncf_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Biaa leng a se xaalame atat, biaa Moroaa naba taxaa puaa xan xuxubu sin Abaram, xoxot ina xadi no inaman in Igip asuk laa lapalaa buxa. ");
INSERT INTO ncf_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Mil iexa king iwaa ta xap atiixi Josep atsap malen lalaamua in Igip. ");
INSERT INTO ncf_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Tii apanaai buxaai di ngali xosor atsoti xida no inaman ma ga ngungutsen di ma ga alolbiri xida no iaaiaa sin tii atuaai di ngali lii atsuulngi xadi no madalak uul lokobel ngali di ba met. ");
INSERT INTO ncf_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Sin abia leng, di tii taxaana Moses ma tii ga suk mat mamainaang lalon no matan Moroaa. Sin no uleng ta tuul di tii tilaamamil sin, lalon xan anua xan mom. ");
INSERT INTO ncf_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Biaa, di ta se atsuulngi lokobel, xan tsaana Paarao a giwaa ma ga tilaamamil sin malen xan tsi so tsaa. ");
INSERT INTO ncf_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moses tii asasing sin no sinaae araraa in Igip ma tii ga suk ie xoror buxa sin xan no papaare ma xan no tinaxaa. ");
INSERT INTO ncf_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Biaa xan no miet tii se no sangaul aet, tii adodo lalon butsa ngali laa uwaa xan matenbung in Israel. ");
INSERT INTO ncf_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tii lasi iexa Igip ta tsaapi iexa ina no Israel ma ga laa ngali tilkaali ma ga sas amantei aia Igip. ");
INSERT INTO ncf_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses tii adodo we xan no inaman tsaa di ba nanxilalaa we Moroaa a tali ia ngali aleiwaai di, oro di ga xap atii. ");
INSERT INTO ncf_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Leng papan Moses a le tsap ga lasi no taamat ta lua in Israel delu ta esas. Moses a xonon ngali naba tali malum, ‘Gululu lomasen turamasen. Ngalisa gululu ta esas engen gululu?’ ");
INSERT INTO ncf_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Oro iwaa taamat ta ngungutsen iexa, a tsulenlii Moses laa sin gelgel ga paare, ‘Saa tali iu ngali u ba tsap lalaamua ma unininte labatina giem? ");
INSERT INTO ncf_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","U wena sas amantei iaa malen u ta sas amantei iwaa taan Igip torongonol?’ ");
INSERT INTO ncf_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Biaa Moses ta longmien abala asuk sol laa Midian ma ga laa manman malen xa xibong ma xan no tsi ga lua. ");
INSERT INTO ncf_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Mulina no sangaul aet ina no miet a se liu, ‘iexa angelo ga asemat sangan Moses lalon rarar ina ie lalon ie dokdok lalon xobel biil atataaen Buk Sinai.’ ");
INSERT INTO ncf_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Biaa Moses tii lasi abia, asuk olol buxa sin abia nanen. Biaa ta se es laa atataen ngali nan axaautsi, asuk alongmen inan Orong. ");
INSERT INTO ncf_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Iaa xan Moroaa num no mom iwaa xan Moroaa Abaram, Aisak ma Jakop.’ Moses adidiir taman minataa ma ga xap saan ngali nanen bula. ");
INSERT INTO ncf_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Mil Orong ga paare ngali, ‘Saali num no bubut, amuina biaa xolot u ta tiltil lalon pula pat. ");
INSERT INTO ncf_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Asuk so maase iaa se lasi no mat laxen namaang tsaxa sin nugu no inaman in Igip. Iaa se alongen xadi no tineng ma balawaa iaa ba xaalame lapula ngali iaa ba aleiwaai di. Xaalame talaawaa ngali iaa ba tulen mulangenai iu laa Igip.’ ");
INSERT INTO ncf_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ilawaa uk Moses aila iwaa di tii palolii taman no totore, ‘Saa tali iu ngali u ba lalaamua ma unininte?’ Moroaa tsaa tii tulen ngali tsap xadi lalaamua ma xadi unaaleleiwaai xa, xaal sin iwaa angelo ta asemat sangan ia lalon biaa ie dokdok. ");
INSERT INTO ncf_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Tii gii atsuulngi di Igip, ma ga xosaraa no mat laxen axixila xoror Igip ma lalon Laman Tok ma sin no sangaul aet ina miet lalon xobel biil. ");
INSERT INTO ncf_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Balawaa Moses tii asaaiti no inaman Israel, ‘Moroaa naba tulen xa propet malen iaa xaal sin nagim no inaman tsaa.’ ");
INSERT INTO ncf_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Tii manman mii xida no iaaiaa, xan no matenbung Moroaa lalon xobel biil, biaa iwaa angelo ta papaare sin papan Buk Sinai. Ma tiaa Moroaa ga tali sin Moses biaa no totore ina tino ngali tali sin gita. ");
INSERT INTO ncf_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Oro xida no iaaiaa di ga palo ngali lolong amusili ia. Di palolii ia ma lalon no butsa di tii ga putsi mula laa Igip. ");
INSERT INTO ncf_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Di asaaiti Aron, ‘Xosaraa nagiem xaa moroaa biaa di ba ta laamuangen giem. Ngali ilawaa taamat Moses tii gii atsuulngi giem Igip, gita se xap atii samaarang a se tsap sin ia!’ ");
INSERT INTO ncf_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Biaa leng se di xosaraa malagan malen bulmakau ma di ga tali no tsutsungit laa sin ma di xosaraa no res taman mangmangle sin sawe no liman di ta xosaraa. ");
INSERT INTO ncf_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Oro Moroaa ga taaltalu sin di ma ga poroklii di ngali langlangaari laa sin matanios, uleng, ma no xadaxada biaa ta ukbal mii sawe di ta atalaa lalon xadi buk no propet: “ ‘Inaman in Israel, gim tii se sas amantei no matauteng ma gim tii ga tsutsungit tali no sin no sangaul aet ina miet gim ta manman lalon xobel biil, oro gim tii xap tali di sin iaa. ");
INSERT INTO ncf_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Gim tii alet laangen lapalaa anuenmoxo ina Molok ma no xadaxada ina nagim no moroaa Repan, biaa no malagan gim ta xosaraa ngali langaari. Biaabi iaa ba tulen gim laa lalon biexa xobel palpalaa’ sin biexa papel ina Babilon. ");
INSERT INTO ncf_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Xida no iaaiaa di tii ie Anuenmoxo ngali paare leng lalon xobel biil. Di tii se xosaraa malen Moroaa tii se laamuangen Moses, amusili puapua ia tii se lasi. ");
INSERT INTO ncf_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Biaa di tii adi abia Anuenmoxo, xida no iaaiaa mii Josua di tii atsaxei mii di biaa di tii adi biaa pula sin no inaman labalaba biaa Moroaa tii xalel atsuulngi di lalon. Tii manman atia pupua sin xan no leng Dewit. ");
INSERT INTO ncf_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Amuina xan amiimiilam Moroaa sin Dewit ma ga atsura ngali na xosaraa xaka anua xan Moroaa Jakop ngali manman. ");
INSERT INTO ncf_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Oro Solomon mu iwaa ta tumaraa biaa anua ngali ia. ");
INSERT INTO ncf_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Oro Moroaa lapalaa suk se a xap manman lalon no anua biaa no taamat di ta tumaraa. Malen propet ta paare: ");
INSERT INTO ncf_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Orong a paare. ‘Balalangit biaa nugu muina xalkale ma balawaa balan pula biaa nugu niaan xutxutsiil. Sen mat anua u ba tumaraa ngali iaa? Ma inaabi ba nugu xolot iaawis? ");
INSERT INTO ncf_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","A xap no limaaga abala ta xosaraa abala no maarang?’ ");
INSERT INTO ncf_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Gim malen no muun taltaalnge, di ta palo ngali taltaalnge sin Moroaa ma di ga banti no talingan ma xadi no butsa sin sawe ta paatinai. Gim malen mu nagim no iaaiaa: Gim tigiri puxislii Nantanua Pat! ");
INSERT INTO ncf_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nagim no iaaiaa di xosaraa no propet araraa ngali saaen sosong. Di tii sas amantei biaa di, di tii paare leng taman xan tsinap iwaa untutiik. Ma talaawaa gim se babel tali ma gim se sas amantei ia. ");
INSERT INTO ncf_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Moroaa a tulen xan no angelo biaa di ta tali xan lo sin gim oro gim ga xap long amusili xan lo.” ");
INSERT INTO ncf_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Biaa di ta alongmen abala di suk bal lelep ma di ga ngaalpaam sin ia ");
INSERT INTO ncf_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Oro Stepan auus taman Nantanua Pat a nanen laa lapalaa balalangit ma ga lasi xan minaalam Moroaa ma Iesu ta tiltil sin xan lima mua Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","A paare, “Nanen, iaa lasi balalangit ta tsalel ma Xan Tsi Taamat ta tiltil sin xan lima mua Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Sin abala di banti no talingan di ma di ga xuup lot, di sol isagaa laa sangan ia. ");
INSERT INTO ncf_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Di tataii atsuulngi lalon inaman laba ma di ga taxaa sin pidili taman no xaat. Tiwaa tsaa biaa no tiltsoxoti di aturungi xadi no uga disdis sangan no xaden iexa xulaau iesan ila Sol. ");
INSERT INTO ncf_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Biaa di lo pipidili, Stepan a lo ningning, “Orong Iesu adi nantanuaaga.” ");
INSERT INTO ncf_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Mil ga xol papan xan no putput ga teng lot, “Orong adodolii di ngali abala namaang tsaxa sin di ta sas amantei iaa.” Biaa ta paare taman abala, asuk met. ");
INSERT INTO ncf_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ma Sol ga manman tia, ngali ukbal sin xan minet. Sin abia leng xariin mamaxet atsap sin biaa xan matenaanua Moroaa lalon Jerusalem, ma di araraa di ga tamtsaare sin no prowins araraa Judaia ma Samaria oro no aposal tsaa di manman Jerusalem ");
INSERT INTO ncf_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Xan no inaman Moroaa di punami Stepan taman no tineng ma lolbiir ngali. ");
INSERT INTO ncf_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Oro Sol atiltsoli ngali xosaraa atsoti xan matenaanua Moroaa. A laa lalon no anua xuxuuk ma ga tataii atsuulngi no taamat ma aina ma ga aturungi di lalon anua lodo. ");
INSERT INTO ncf_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Biaa di, di ta man tamtsaare di baais taman xan totore Moroaa sin no xolot di ta laa lalon. ");
INSERT INTO ncf_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilip a laa lapula lalon inaman laba ina prowins Samaria ma ga baais taman Karisito atia. ");
INSERT INTO ncf_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Biaa malep di tii alongen Pilip ma di tii ga lasi no axixila xoror tii xosaraa, di suk lolong axaau sin sawe ta paare taman. ");
INSERT INTO ncf_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","No salawa tsaxa di xuup pirite tsuul sin xuduxudu, ma biaa di ina no isua met ma no xadek met di tii ga tuo. ");
INSERT INTO ncf_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Biaabi xariin taton ga tsap lalon abia inaman laba. ");
INSERT INTO ncf_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Sin abia no leng laamuaan Pilip ta xaalame, iexa taamat iesan ila Saimon a xosaraa tsunuxa lalon inaman laba ma ga alolaa no inaman in Samaria. A paare pispis we ia taamat lot. ");
INSERT INTO ncf_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ma biaa no xariin inaman ma no inaman gomsaa di araraa di taltaalnge sin ia di ga paare, “Ilawaa taamat xan xoror awatwat amuina Moroaa a xosaraa ngali tsap lot suk se.” ");
INSERT INTO ncf_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Di tii se amusili tsaa amuina tii atunga di taman xan makmaxar tsaxa sin no daan leng. ");
INSERT INTO ncf_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Oro biaa di tii taltaalnge sin sawe Pilip tii baais taman inesaait mamainaang ina xan Maradaan Moroaa ma iesan Iesu Karisito, di tii ga adi axaxadaan, taamat ma aina. ");
INSERT INTO ncf_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon ia tsaa a taltaalnge ma Pilip ga axadaani. Ma ga amusili ia sin no xolot araraa, ma ga olol sin no xariin axixila ma no axixila xoror tii lasi. ");
INSERT INTO ncf_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Biaa no aposal in Jerusalem di alongen we no Samaria di se sirawaa xan totore Moroaa, di tulen Pita ma Jon ngali laa sangan di. ");
INSERT INTO ncf_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Biaa delulu tii laa tsap, delulu ningning ngali di ngali di ba pupua ngali adi Nantanua Pat, ");
INSERT INTO ncf_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","amuina Nantanua Pat tii xap mager xaalame papan di; di tii axadaani mu di sin iesan Orong Iesu. ");
INSERT INTO ncf_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Mil Pita ma Jon di ga aturungi no liman di papan di o di tii ga adi Nantanua Pat. ");
INSERT INTO ncf_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Biaa Saimon ta lasi Pita ma Jon delulu tali Nantanua Pat sin delulu tii aturungi no liman delulu papan no inaman, tii tali no xuxute sin delulu, ");
INSERT INTO ncf_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ma ga paare, “Tali bula abala xoror susugu ngalibi no saa iaa ta aturungi no limaaga papan di, di ba adi Nantanua Pat.” ");
INSERT INTO ncf_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pita a xisi, “Moroaa naba xosaraa atsoti num no xuxute mii iu, amuina u adodo we, u ba pupua ngali uuli abia xan tinabel Moroaa taman xuxute! ");
INSERT INTO ncf_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","A xap num ka xolot lalon abala inatalil, amuina num butsa a xap tutiik nan no matan Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","U na puxisbal sin abala namaang tsaxa ma u na ningning sin Orong. Male naba adodolii num no namaang tsaxa sin abia adodo lalon num butsa. ");
INSERT INTO ncf_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Amuina iaa lasi bal tsaxa sin iu ngali gelulu ma u tii ga tsap tutule ina namaang tsaxa.” ");
INSERT INTO ncf_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Mil Saimon ga xisi, “Sawit laa sin Orong ngali iaa ngalibi naba xap xawas, gim ta paare taman naba tsap sin iaa.” ");
INSERT INTO ncf_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Biaa Pita ma Jon, delu tii paare leng taman Iesu ma delu tii ga se mula laa Jerusalem ma delu tii ga baais taman xan inesaait mamainaang Orong sin no daan xobel lalon Samaria. ");
INSERT INTO ncf_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Talaawaa xan angelo Orong a paare ngali Pilip, “Laa nan no paxel sin abia sal biil ta laa lapula xaal Jerusalem laa Gasa.” ");
INSERT INTO ncf_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","O ga tapaas laa sin xan ines ma sauna mu a balsi iexa taamat in Itiopia iwaa iunik, ia taamat lot ta tilaamamil sin xan niaan aturung xuxute Kandas, Kwin in Itiopia. Ilawaa taamat tii laa Jerusalem ngali langaari, ");
INSERT INTO ncf_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ma sin xan ines laa lokobel a tsotso papan xan karis ma ga xoxoti xan inaatel propet Aisaia. ");
INSERT INTO ncf_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nantanua Pat asaaiti Pilip, “U na laa sangan abilu karis ma u na es atataen.” ");
INSERT INTO ncf_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Mil Pilip ga sol laa lapalaa sangan karis ma ga alongen iwaa taamat ta xoxoti inaatel xan Aisaia iwaa propet. Pilip atsuraa, “U leng sin sawe u ta xoxoti?” ");
INSERT INTO ncf_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","A xisi, “Iaa ba sen leng we? Iaa saan ngali xa na alengi axaautsi iaa.” Biaabi ga ningi Pilip ngali xaalame lapalaa ngali le tsotso mii ia. ");
INSERT INTO ncf_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ilawaa taman axoxoti xolot ina balawaa Inaatel Pat: “Di tii laamungen malen xa sipsip ngali laa sas amantei ma malen sipsip uul ta man adamis biaa xa taamat ta xitiplii xan no ul, ma ga xap aponga ngutsina. ");
INSERT INTO ncf_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Biaa no inaman di ta adokdoki ia di tii xap ininte tutiik sin. Giem xap atii xan no utmilmil. Amuina di se adi xan tino sin abala xolkolmoxo ina inaman.” ");
INSERT INTO ncf_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Itiopia atsuraa Pilip, “U na asaaiti iaa timaa, saa propet aia, u ta papaare taman, ia tsaa o xa xaatsap?” ");
INSERT INTO ncf_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Mil Pilip ga atiltsoli abala xolot ina Inaatel Pat ma tii ga asaaiti ia taman inesaait mamainaang ina Iesu. ");
INSERT INTO ncf_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Biaa di ta sol laa papan abia sal, di tii tsap sangan no daan o iwaa iunik ga paare, “Lasi, daan abala. Aso maase u suk pupua mu ngali axadaani iaa.” ");
INSERT INTO ncf_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ma ga asaaiti, “Atilngi abia karis.” Pilip ma iunik, delu ga tsuul laa lapula lalon daan ma Pilip tii ga axadaani ia. ");
INSERT INTO ncf_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Biaa delu ta tsuul xaal lalon daan, Nantanuan Orong a giwaa isagaalen Pilip laa, ma iwaa iunik ga xap lasi bula ia, oro ga laa lalon xan sal taman tataton. ");
INSERT INTO ncf_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Oro Pilip a se laa asemat Asotas ma ga eses ma ga babaais taman inesaait mamainaang lalon no inaman laba araraa pupua ta tsap Sasaria. ");
INSERT INTO ncf_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sin abia no leng, Sol tii taxaa sin lo abubuaa xan no tsi asasing Orong ngali sas amantei di. A laa sangan no unsausawit lapalaa, ");
INSERT INTO ncf_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ma tii ga atsuraa ia ngali atalaa xaa inaatel laa sin no lalaamua ina Anua Sausawit lalon inaman laba Damaaskas, ngalibi nawe atatangina xaa inaman tia lalon abia Sal xan Orong, nawe no taamat o aina, naba pupua ngali pitsi di malen no xaus laa Jerusalem ngali laa lalon anua lodo. ");
INSERT INTO ncf_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sol tii se laa atataen Damaaskas lalon abia xan ines, sauna mu biaa rarar axaal balalangit a le tsila ulti. ");
INSERT INTO ncf_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Sol a xol laa lapula papan pula ma tii ga alongen ina ta paare ngali, “Sol, Sol, ngali sa u tii asosongi iaa buxa?” ");
INSERT INTO ncf_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sol atsura, “Saa iu Orong?” A xisi, “Iaa Iesu, iwaa u ta asosongi. ");
INSERT INTO ncf_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","U na tapaas ma u na laa lalon inaman laba, ma xa naba asaaiti iu sawe u ba ta xosaraa.” ");
INSERT INTO ncf_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","No taamat di ta eses mii Sol, di tii til ngus bong; di alongmen tengteng oro di tii xap lasi xa. ");
INSERT INTO ncf_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol a tapaas xaal lapula, oro biaa ta apododa no matan, oro a xap pupua ngali lasi xawas, biaabi di ga laamuangen sin no liman laa Damaaskas. ");
INSERT INTO ncf_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sin no leng ta tuul no matan tii baba, ma ga xap muun angen ma nunngi xawas. ");
INSERT INTO ncf_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Lalon abia inaman laba Damaaskas, iexa tsi asasing iesan ila Ananias. Orong a ilei lalon nanen, “Ananias!” A xisi, “Iou, Orong.” ");
INSERT INTO ncf_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ma Orong tii ga asaaiti, “U na laa sin xan anua Judas lalon abia Sal di ta putsangi Tutiik ma u na atsuraa ngali taamat in Taasas iesan ila Sol, ia ta lo ningning. ");
INSERT INTO ncf_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Lalon nanen binalang tii se lasi iexa taamat iesan ila Ananias, ta xaalame ma ga aturungi no liman papan ngali naba nanen mula.” ");
INSERT INTO ncf_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias a xisi, “Orong, iaa se alongen no inaman di ta paatina no totore ngali aila taamat, ma no mat laxen namaang tsaxa araraa tii xosaraa ngali num no inaman pat in Jerusalem. ");
INSERT INTO ncf_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ma tii ga xaalame atala taman banam sin no lalaamua ina no unsausawit ngali tsiili no saa di ta ilei iesaam.” ");
INSERT INTO ncf_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Oro Orong tii ga paare ngali Ananias, “Laa! Ilawaa taamat iaa se axilangi nugu untinaxaa ngali alet laangen iesaaga laa sin no Gentail ma laamuaan xadi no king ma labatina no Israel. ");
INSERT INTO ncf_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Iaa ba asen sin ia no mat laxen xariin sosong naba ta adi ngali iesaaga.” ");
INSERT INTO ncf_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Mil Ananias tii ga laa sin anua ma ga tsiga. Aturungi no liman papan Sol, ga paare, “Turaagamasen Sol, Orong Iesu, saa tii asemat sangan iu lalon sal, biaa u ta xaalame atala, a tulen iaa ngalibi u ba nanen sebula ma ngali u ba us taman Nantanua Pat.” ");
INSERT INTO ncf_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tiwaa tsaa, no maarang ta malen une, a xol sin no matan Sol, ma ga sebula nanen. A tapaas ma tii ga axadaani ia, ");
INSERT INTO ncf_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ma mulina tii se angen ma tii ga sebula alet mulangen xan watwat. Sol tii ben manman biexaa nen leng mii no tsi asasing in Damaaskas. ");
INSERT INTO ncf_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tiwaa tsaa tii atiltsoli ngali baais lalon no Anua Sausawit we, “Iesu ia xan tsi Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Biaa di araraa di tii alongen Sol di suk olol ma di ga atsura, “Ilawaa taamat amuila tii xosaraa atsoti tinaxaa Jerusalem labatina biaa di ta putsangi abala ies? Ma talaawaa a se xaalame atala ngali tsiili di ngali tali di sin no lalaamua ina no unsausawit.” ");
INSERT INTO ncf_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sol tii suk tsap watwat buxa ma no Jiu, di tii manman Damaaskas, di tii ga bal tsaxa buxa, biaa tii asoi we, Iesu ia Mesaia. ");
INSERT INTO ncf_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Mulina no daan leng tii se laa, no Jiu di xale etudim ma di tii ga ngiti ngali sas amantei Sol. ");
INSERT INTO ncf_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Oro xa asaaiti Sol taman xadi no sen adodo. Sin no siaat ma bing di xale atataen no matenmat ina inaman laba ngali matngen ngali sas amantei ia. ");
INSERT INTO ncf_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Oro xan no tsi asasing Sol di ga giwaa nabing ma di ga aririi lalon xiis lot sin mat ina xuur. ");
INSERT INTO ncf_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Biaa tii se xaalame Jerusalem, a xonon ngali laa tsomi no tsi asasing, oro di tii ga suk mataatinai ma di tii ga xap taltaalnge we ia, xa tsi asasing so. ");
INSERT INTO ncf_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Oro Banabaas a giwaa Sol ma ga laa tali sangan no aposal. Tii asaaiti di taman Sol tii sen lasi Orong we lalon sal ma Orong ga papaare sin, ma tii xap mataa ngali baais taman iesan Iesu tia Damaaskas. ");
INSERT INTO ncf_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Biaabi Sol ga manman mii di ma tii ga se eses leiwaa Jerusalem ma tii ga xap mataa ngali baais taman iesan Orong. ");
INSERT INTO ncf_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","A papaare ma epuske mii no Jiu biaa di ta xaa totore in Grik, ma di tii ga xonon ngali sas amantei ia. ");
INSERT INTO ncf_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Biaa no untaltaalnge di tii alongen abala maarang, di tii giwaa Sol laa lapula Sasaria ma di tii ga tulen laangen lalon inaman laba Taasas. ");
INSERT INTO ncf_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mil biaa xan matenaanua Moroaa lalon no prowins Judaia, Galili, ma Samaria di tii taton sin abia leng ina malina. Nantanua Pat tii awatwati no balan di ma ga ananaai di, ma di tii ga tsap xuduxudu sin xoxot, biaa di tii manman taman minataa ina Orong. ");
INSERT INTO ncf_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Biaa Pita tii galil lalon abia no prowins, tii laa ngali uwaa xan no inaman pat Moroaa in Lida. ");
INSERT INTO ncf_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Lalon abia xobel, tii tatanginai iexa taamat iesan ila Aeneas, iwaa taamat no isuaan tii met ma tii ga lo matmatuul papan ibe sin no miet tii paasaatuul. ");
INSERT INTO ncf_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ma Pita tii ga asaaiti ia, “Aeneas, Iesu Karisito a se atoaa iu. Tapaas ma u na adi num ibe.” Sauna mu, Aeneas ga tapaas. ");
INSERT INTO ncf_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Biaa di araraa, di tii manman tia Lida ma lalon inaman laba Saron, di lasi ia ma di tii ga taltaalnge sin Orong. ");
INSERT INTO ncf_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Lalon inaman laba Jopa iexa tsi asasing aina iesan ila Tabita, sin totore in Grik di putsangi Dokaas. Atigiri xoxosaraa no namaang axaau ma ga tiltsomi no muunwas. ");
INSERT INTO ncf_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Sin abia leng tii maramase ma ti ga met, ma di tii ga silii ma di tii ga aturungi lalon biexaa xabin lapalaa. ");
INSERT INTO ncf_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Xobel laba Lida a manman atataaen Jopa. Biaa no tsi asasing di tii lolong we, Pita a manman tia Lida, di suk tulen no taamat alua laa sangan ma di tii ga ningi, “Timaa xaalame isagaa!” ");
INSERT INTO ncf_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pita tii laa mii di, ma biaa ta tsap, di giwaa laa lapalaa lalon abia xabin. No nal araraa di til ulti ia, di ta tengteng ma di ga asen xadi no uga disdis ma biexaa uga bula biaa Dokaas ta xosaraa biaa tii manman tsaa mii di. ");
INSERT INTO ncf_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita a tulen atsuulngi di lalon abia xabin; ma ga sage putput ma ga sausawit. Biaa ta putsi laa sin aina ta met tii ga paare, “Tabita u na tapaas.” A pododa no matan ma tii ga lasi Pita ma tii ga tapaas ma tii ga tsotso. ");
INSERT INTO ncf_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita tii ga taxaana liman ma tii ga tiltsomi ngali tapaas, ma tii ga til. Pita ga ilei abia no untaltaalnge ma no nal ma tii ga tali ia sin di tii se tino. ");
INSERT INTO ncf_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Xuduxudu ina no inaman araraa Jopa di tii se atixi abia maarang Pita tii xosaraa no ma xuduxudu ina no inaman di tii ga taltaalnge sin Orong. ");
INSERT INTO ncf_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita tii manman Jopa sin biexaa nen leng mii taamat iesan ila Saimon iwaa tii xaa xosaraa no maarang taman no xilkil ina no mat laxen xadak et. ");
INSERT INTO ncf_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Iexa taamat a manman lalon inaman laba Sasaria iesan ila Konilias. Ia lalaamua ina no unmakmaxil di putsangi xumul Itali. ");
INSERT INTO ncf_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ia ma xan matenaanua, di no Gentail, ma di manglen ma langaari laa sin Moroaa. A tabiel buxaai abia di, di ta muun ma ga tigiri sausawit sin Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Biexa leng sin nanaatuul ina matanios a lasi biexa nanen. A suk lasi iexa angelo xan Moroaa iwaa ta xaalame sangan ga paare, “Konilias.” ");
INSERT INTO ncf_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Konilias anan ariti taman minataa. Atsura, “Sawe abala, Orong?” Angelo a xisi, “Num no sausawit ma num no tinabel laa sin no muun tii se le tsap malen xa tinabel axaau ngali adodomi laamuaan Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","U na tulen xaa taamat laa Jopa ngali laa gii mulangen taamat iesan ila Saimon iwaa di ta putsangi Pita. ");
INSERT INTO ncf_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ia ta manman mii Saimon iwaa taamat xan tinaxaa ngali xosaraa no maarang taman no xilkil ina no xadak et, xan anua aman atataaen xuen.” ");
INSERT INTO ncf_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Biaa angelo ta se paare xap mii ia, o tii ga se laa. Konilias a ilei xan no untutule ta lua ma iexa unmakmaxil iwaa ta taltaalnge sin Moroaa iwaa tii xaa tiltsomi ia. ");
INSERT INTO ncf_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Tii asaaiti abia no taamat ta tuul taman samaarang ta tsap sin ma ga tulen di laa Jopa. ");
INSERT INTO ncf_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Lasiaat sin leng papan di ta lo eses sin abia ines ma di ga se tsap lalon inaman laba, Pita aen papan unga ina anua ngali laa ningning. ");
INSERT INTO ncf_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pita a itol ma ga saan ngali xawas ngali angen, o biaa di lo taxaaturungi luxaal, Pita a xol laa lalon nanen binalang. ");
INSERT INTO ncf_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Tii lasi balalangit atsalel o maarang malen xariin laplap a lo tsuul xaalame lapula sin xan no tsigur ta et. Biaa maarang a soriri xaal balalangit xaalame lapula. ");
INSERT INTO ncf_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Lalon abia laplap no daan mat laxen xadek et ma no maarang di ta xaamkaam taman no balan ma no maan. ");
INSERT INTO ncf_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Biexa ine ga asaaiti, “Tapaas Pita, ma u na sas amantei ma u na ngani.” ");
INSERT INTO ncf_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pita a xisi, “Asuk xap Orong! Iaa suk xap mager ngani xa maarang biaa xadi lo no Jiu ta papaare we a xap mixat.” ");
INSERT INTO ncf_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Biaa ine a sebula paare nanaalua, “Nawe Moroaa a xosaraa xawas ga mixat u na ngani, nangaam paare we, a xap mixat.” ");
INSERT INTO ncf_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Balawaa maarang a sebula tsap nanaatuul, o sauna mu biaa laplap ga sebula mula laa lapalaa balalangit. ");
INSERT INTO ncf_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Biaa Pita ta lo adodo usili abala nanen, sauna mu no taamat Konilias tii tulen detatuul, detuu atsura ngali itaa xan anua Saimon a manman, ma di le tsal tatanginai xan anua Saimon ma di tii ga til matenmat. ");
INSERT INTO ncf_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Detuu ilei ma detuu ga atsuraa, “Saimon iwaa di ta putsangi Pita, a manman itaa?” ");
INSERT INTO ncf_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Biaa Pita ta lo adodomi tsaa abia nanen binalang, Nantanua ga paare sin ia. “Lolong, Saimon, no taamat detuu ta tuul di nanen ngali iu. ");
INSERT INTO ncf_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Biaabi u na tapaas ma u na tsuul lapula. Nangaam adodo xuduxudu ngali laa mii detatuul, amuina iaa tulen detatuul.” ");
INSERT INTO ncf_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pita atsuul laa lapula ma ga asaaiti detatuul, “Lolong, iaa iwaa xa gim ta nanen ngali. Gim xaalame ngalisa?” ");
INSERT INTO ncf_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Biaa tuu taamat detuu xisi, “Getu xaal sangan Konilias iwaa lalaamua ina no unmakmaxil. Iwaa no Jiu araraa di ta manglen ma ia untutiik ma ga mataatine Moroaa. Xan angelo pat Moroaa asaaiti ia, ngali naba xaalame lalon xan anua ngalibi naba le alongen sawe u ba ta asaait taman.” ");
INSERT INTO ncf_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Mil Pita ga sirawaa abia no taamat laa naanua malen xan no inawut. Sin biexaa leng papan, Pita a tapaas ma di tii ga es laa mii detatuul mii biexaal ina no turumasen lalon Orong in Jopa. ");
INSERT INTO ncf_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Leng papan atsap Sasaria. Konilias alilisi di ma ga ilei axumuli xan no matenbung ma no turan. ");
INSERT INTO ncf_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Biaa Pita tii es tsiga lalon anua, Konilias a es sabasue ia ma tii ga sage putput sangan no xaden taman mangmangle xa sin. ");
INSERT INTO ncf_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Oro Pita atapaasi ma ga asaaiti, “Til lapalaa, iaa taamat mu malen iu.” ");
INSERT INTO ncf_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pita a papaare mii, o ga es tsiga ma ga laa tatanginai xariin xumul, di tii exumule. ");
INSERT INTO ncf_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pita tii paare ngali di: “Gim suk atik axaautsi we, nagiem lo no Jiu atilxaali no Jiu ngali man atataen no Gentail o ngali uwaa di. Oro Moroaa asen sin iaa we, iaa na xap paare we Moroaa naba xap amixati di. ");
INSERT INTO ncf_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Biaa iu ta tulen detatuul ngali giwaa iaa xaalame, tiwaa tsaa iaa siir ma iaa ga xaalame mii detatuul. A pupua ngali iaa ba atsura, ngalisa gim ta tutule ngali iaa?” ");
INSERT INTO ncf_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Konilias a xisi, “No leng aet a se laa, iaa ta manman lalon nugu anua ma iaa ga lo sausawit sin nanaatuul ina matanios nale. Sauna mu iexa taamat ta tamtuel lalon uga disdis ta tsila, a le til laamuaan iaa, ");
INSERT INTO ncf_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ma ga we, ‘Konilias, Moroaa a se alongen num sausawit ma ga adodomi num no tinabel sin no muunwas. ");
INSERT INTO ncf_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Tulen totore laa Jopa ngali Saimon iwaa di ta putsangi Pita. Ia inawut lalon xan anua Saimon iwaa ta xosaraa no maarang taman no xilkil, iwaa ta man atataen xuen.’ ");
INSERT INTO ncf_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Sauna mu iaa ga tutule ngali iu, ma ga axaau ngali u ta se xaalame tala. Talaawaa giem araraa se tala laamuaan Moroaa ngali lolong sin no maarang araraa Orong tii se asaait awatwati iu ngali asaaiti giem.” ");
INSERT INTO ncf_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Mil Pita tii ga atiltsoli papaare, “Talaawaa iaa se atii so we Moroaa a xap asen xan saansaan mu sin xan no inaman, ");
INSERT INTO ncf_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","oro a sirawaa no inaman lalon no inaman labalaba araraa biaa di ta mataatinai ia ma di ga xosaraa namaang tutiik. ");
INSERT INTO ncf_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Gim atiixi xan inesaait Moroaa, tii tulen sin no inaman Israel, ngali babaais taman inesaait mamainaang ina malina lalon Iesu Karisito, iwaa xadi Orong no inaman araraa. ");
INSERT INTO ncf_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Gim tii se atiixi sawe tii tsap sin no xolot araraa Judaia, atiltsoli Galili mulina biaa Jon tii baais taman axaxadaan, ");
INSERT INTO ncf_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","biaa Moroaa ta sen apati we Iesu in Nasaret taman Nantanua Pat ma xoror watwat, ma ta sen laa ulti biexaa xolot ngali xosaraa mamainaang ma atotoaa no inaman araraa biaa di ta manman paina xan xoror maraanis, amuina Moroaa a manman mii ia. ");
INSERT INTO ncf_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Giem no tiltsoxoti ina no maarang araraa tii xosaraa no lalon no prowins Galili, Samaria ma Judaia ma lalon Jerusalem. Di sas amantei ia sin di ta ataxiwaa ia papan tongol, ");
INSERT INTO ncf_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","oro Moroaa ga atapaasi ia sin minet sin nanaatuul ina leng ma ga xosaraa ia ngalibi di ba lasi ia. ");
INSERT INTO ncf_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Oro no inaman araraa Judaia di tii xap lasi, oro ngali no tiltsoxoti mu di lasi ia biaa Moroaa tii se axilangi tsaa, sin giem biaa giem tii ngani ma nun mii, biaa tii tapaas mula sin minet. ");
INSERT INTO ncf_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Tii asaait awatwati giem ngali baais laa sin no inaman ma paare leng taman ia, iwaa xa Moroaa ta axilangi malen unininte sin no inaman di ta tino ma biaa di, di tii se met. ");
INSERT INTO ncf_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","No propet araraa di tii paare leng taman ia nawe xa a taltaalnge sin ia naba adi abia adodolii xa sin xan no namaang tsaxa, sin iesan.” ");
INSERT INTO ncf_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita tii lo papaare tsaa taman abala no totore, o Nantanua Pat asuk xaalame papan abia no inaman araraa di tii alongen abia inesaait. ");
INSERT INTO ncf_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Biaa no untaltaalnge ina no Jiu, biaa di tii xaalame mii Pita, di tii tunga we, biaa tinabel ina Nantanua Pat tii arueti papan no Gentail bula. ");
INSERT INTO ncf_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Amuina di tii alongmen di ta papaare taman no mat laxen xalam ma di tii ga paʼii Moroaa. Mil Pita ga paare, ");
INSERT INTO ncf_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“A pupua ngali xa naba tilbanti di ngali axaxadaan taman daan? Di tii se adi Nantanua Pat malen giem bula.” ");
INSERT INTO ncf_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Biaabi Pita tii ga paare, “Iaa ba axadaani gim taman iesan Iesu Karisito.” Mil di tii ga atsuraa Pita ngali na ben manman mii di xaa nen leng bula. ");
INSERT INTO ncf_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","No aposal ma no untaltaalnge tia Judaia di tii alongen we, no Gentail bula di tii se taltaalnge sin xan totore Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","O biaa Pita tii laa lapalaa Jerusalem, biaa di, di tii manman tsaa sin namaang ina xasau, di tii magaa sin Pita. ");
INSERT INTO ncf_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Di tii ga paare ngali Pita, “Iu tii laa malen inawut lalon xadi anua no Gentail ma iu ga angen mii di.” ");
INSERT INTO ncf_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pita tii ga atiltsoli ngali asaait alengi di taman no mat maarang biaa tii tsap so. ");
INSERT INTO ncf_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Iaa manman nan inaman laba Jopa ma iaa ga lo sausawit ma iaa ga lasi nanen binalang. Ma iaa ga lasi maarang axaal balalangit malen xariin laplap di ta aririi laa lapula sin xan no tsigur ta et ma ga xaalame sangaaga. ");
INSERT INTO ncf_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Iaa nanen lalon ma iaa ga lasi no xadek et, ma biaa di ta xaamkaam taman no balan di ma no maan. ");
INSERT INTO ncf_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Mil iaa tii ga alongen inan xa ta asaaiti iaa, ‘Tapaas Pita. U na sas amantei no ma u na ngani no.’ ");
INSERT INTO ncf_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Oro iaa xisi, ‘Naba suk xap, Orong! Iaa suk xap mager ngani xa maarang biaa ta xap mixat.’ ");
INSERT INTO ncf_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Biaa ina a sebula xaal balalangit, ‘Nawe Moroaa a xosaraa xawas ga mixat ngali ngani, biaa nangaam paare we, a xap mixat ngali ngani.’ ");
INSERT INTO ncf_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Balawaa maarang a sebula tsap nanaatuul, biaa di tii ga sebula alet mulangenai laa lapalaa balalangit. ");
INSERT INTO ncf_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Sauna mu, biaa no taamat ta tuul iwaa taamat ta tulen detatuul xaalame sangan iaa xaal Sasaria, detuu se le tsap lalon abia anua iaa ta manman lalon. ");
INSERT INTO ncf_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Nantanua Pat tii ga asaaiti iaa ngali iaa ba xap adodo xuduxudu oro ina laa mii detatuul. Balawaa tumasen xan taamat, ta paasxuk in Jopa, di laa bula mii iaa Sasaria ma iaa tii ga tsiga lalon xan anua Konilias. ");
INSERT INTO ncf_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Tii asaaiti giem taman tii lasi angelo tii tsap lalon xan anua ma tii ga we, ‘U na tulen xa taamat laa Jopa ngali laa asaaiti taamat ia iesan ila Saimon biexa iesan Pita ngali na xaalame. ");
INSERT INTO ncf_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ngali naba tali xa inesaait sin iu, ngali num matenaanua araraa di ba tuo.’ ");
INSERT INTO ncf_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Biaa iaa tii se atiltsoli papaare Nantanua Pat tii suk xaalame lapula papan di malen tii xaalame papan gita, sin atiltsoli. ");
INSERT INTO ncf_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Mil iaa tii ga adodomi balawaa totore Orong tii paatina, ‘Jon tii axaxadaan taman daan, oro Moroaa naba axadaani gim taman Nantanua Pat.’ ");
INSERT INTO ncf_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nawe Moroaa tii tali sin di, biaa uk tinabel malen tii tali sin gita, biaa gita til taltaalnge sin Orong Iesu Karisito, iaa saa ngali adodo we, iaa pupua ngali epuske mii Moroaa?” ");
INSERT INTO ncf_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Biaa di tii alongen abala xan totore Pita, di tii se xap emagaae bula mii ia, oro di tii ga paʼii iesan Moroaa ma di ga paare, “Talaawaa, Moroaa tii se siir tali bula no Gentail ngali di ba puxisbal ngali adi tino laaliu.” ");
INSERT INTO ncf_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","No untaltaalnge di tii exatsep amusili biexa xaraxin mamaet tii tsap ma di ga sas amantei Stepan. Biexaal ina no untaltaalnge di tii se laa tsap nan xolot Ponisia, papan ienusa Saipras, ma nan inaman laba Antiok lalon prowins Asia, ma di tii ga baais taman inesaait mamainaang ina Iesu, sin no Jiu mu. ");
INSERT INTO ncf_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Oro biexaal ina no untaltaalnge di no taamat in Saipras ma Sairin di tii laa Antiok ma di tii ga baais taman inesaait mamainaang xan Orong Iesu laa sin no Grik. ");
INSERT INTO ncf_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","No liman Orong tii manman mii di ma xuduxudu ina inaman di tii ga taltaalnge ma puxisbal ma di tii ga amusili Orong Iesu. ");
INSERT INTO ncf_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Inesaait ina abala tii tsiili no talingan xan matenaanua Moroaa Jerusalem ma di ga tulen Banabaas laa Antiok. ");
INSERT INTO ncf_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Biaa Banabaas ta laa tsap, ma tii ga lasi malen Moroaa atubudaani di mii amiimiilam, asuk taton ma tii ga anaai di biaa di ta manman lalon soina sin Orong mii xadi no butsa araraa. ");
INSERT INTO ncf_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ia taamat axaau xan tino auus taman Nantanua Pat ma tinaalnge. Ma xuduxudu ina no inaman di ga puxisbal ma di tii ga xaalame sangan Orong. ");
INSERT INTO ncf_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Mil Banabaas ga laa Taasas ngali laa tsalei Sol. ");
INSERT INTO ncf_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Biaa tii ga se tatanginai ia, ma asuk giwaa xaalame Antiok. Ma sin abia miet xiduul Banabaas ma Sol delu manman etudim mii xan matenaanua Moroaa ma delu tii ga taal asasing sin biaa malep ina inaman. Tia Antiok, biaa no tsi asasing di tii setauan putsangi di no Kiristen. ");
INSERT INTO ncf_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Sin abia no leng, biexaa propet di tii papaalii Jerusalem ma di tii ga xaalame lapula Antiok. ");
INSERT INTO ncf_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Iexa ina di iesan ila Agabas a til ma sin xan watwat Nantanua Pat tii paare leng taman xariin itol naba tsap patanginai xolkolmoxo ina inaman. (Tii tsap sin leng Sisa Kolodias ta tsap king.) ");
INSERT INTO ncf_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Biaabi no tsi asasing di ga adodo ngali tulen xuxute ngali tiltsomi no taamat ma no moton biaa di ta manman Judaia. Di xuxuuk di ba tali no xuxute malen di ta pupua ngali tali. ");
INSERT INTO ncf_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Di tii xosaraa abala ngali tulen abia xadi no tinabel sin no xusaak sin Banabaas ma Sol. ");
INSERT INTO ncf_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Sin abia leng King Erot Agripa atiltsoxali ngali tsiili biaa xan matenaanua Moroaa. A ngiti ngali tali xariin sosong sin di. ");
INSERT INTO ncf_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","A tali Jeims xan turumasen Jon ngali xan no unxoxo di ba sas amantei taman bainat. ");
INSERT INTO ncf_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Biaa tii lasi malen biaa namaang atatoni no Jiu, a sebula tsiili Pita. Balawaa tii tsap labatina Luxaal ina Tsoki ta xap xa Iis. ");
INSERT INTO ncf_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Mil sin ia ta tsiili Pita ga lii lalon anua lodo, a tali ia sin no xumul aet ina no unxoxo ta et ngali tilaamamil sin. Amuina, Erot a saan ngali Pita naba le til nan ininte nan no matan no inaman araraa mulina leng ina Esliwaa. ");
INSERT INTO ncf_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pita a manman lalon anua lodo oro xan matenaanua Moroaa di tii lo sausawit watwat laa sin Moroaa ngali ia. ");
INSERT INTO ncf_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Biaa bing papan ngali Erot naba se tulen atsuulngi Pita laa lalon ininte, Pita tii lo matmatuul lolobet ina no unxoxo ta lua taman no tsen ta lua di ta pitsi taman, ma biexaa unxoxo bula di tiltil tala lokobel sin matan mat. ");
INSERT INTO ncf_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Sauna mu xan angelo Orong asemat ma laleng ga tsilangi lalon abia anua lodo. Ma tii ga pan apadaa Pita sin xalkalen ga paare, “Isagaa, u na tapaas!” Tiwaa tsaa no tsen sin no liman asuk lubat ma ga xol no lapula. ");
INSERT INTO ncf_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ma angelo ga paare sin, “U na pis ariiti num biaal ma num no bubut.” Ma Pita ga xosaraa we atia. Ma angelo ga asaaiti bula ngali, “Alen ariiti num uga disdis ma amusili iaa.” ");
INSERT INTO ncf_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pita ga tsuul laa lokobel lalon anua lodo amusili ia. Oro tii xap atii we biaa maarang angelo tii xosaraa aso, Pita asorowe a lasi xa nanen mu. ");
INSERT INTO ncf_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Delu es liwaa nan axuuk ma nan alua ina no unxoxo ma delu tii ga xaalame sangan matenmat biaa ta laa lalon inaman laba. Biaa matenmat atsalel xasinge tsaa ma delulu ga es tsuul. Delu es amusili abia sal o sauna mu angelo ga papaalii ia ma ga se laa. ");
INSERT INTO ncf_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pita ga suk leng maaba sin senaara ta tsap sin ma ga paare, “Balawaa iaa ga atiixi maaba we aso Orong a tulen xan angelo xaalame ngali aleiwaa iaa sin xan xoror Erot ma sin no daan mat maarang no Jiu di tii we, di na xosaraa.” ");
INSERT INTO ncf_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Biaa tii se leng sin abala, asuk es laa tatan Maria xan nagaa Jon iwaa di ta putsangi Mak. No daan inaman di tsap esuei ma di ga lo sausawit. ");
INSERT INTO ncf_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita a pipidi tala lokobel matenmat ma iexa tsaana untutule iesan ila Roda a xaalame ngali tsalali matenmat. ");
INSERT INTO ncf_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Biaa tii long xilalaa inan Pita asuk taton buxa, ma ga sebula sol tsiga mula, ta xap mager tsalali mat, ma ga asaait we, “Pita ilaa ta tiltil lokobel!” ");
INSERT INTO ncf_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Di ga paare sin, “Iu se tangtangabaa.” Oro iwaa aina a paare watwat, “Asuk so!” Ma biaa no inaman di we, “Manaa iu alongen xan angelo.” ");
INSERT INTO ncf_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Oro Pita a lo pipidi tsaa matenmat til di ta tsalali mat, di ga lasi ia ma di ga suk olol buxa. ");
INSERT INTO ncf_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pita tii ga xosaraa axixila taman liman laa sin di ngali di ba xap papaare. Ma ga asaait alengi di taman senaara Orong ta xosaraa sin ga tulen atsuulngi lalon anua lodo. Ma ga paare, “Gim na asaaiti Jeims ma xida no taamat taman abala maarang.” Pita apapaali di ma ga suk laa sin biexa xolot. ");
INSERT INTO ncf_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Sin abia lawaareng, no unxoxo di ta tilaamamil sin anua lodo, di xap bula lasi Pita ma di ga lolbiir buxa ma di ga etsura ngen di, “Pita a se laa itaa?” ");
INSERT INTO ncf_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Erot a tali papaare watwat ngali tsalei Pita oro di xap tatanginai. Biaabi tii ga atsuraa awatwati no unxoxo ma ga paare watwat ngali sas amantei di. Mulina abia, Erot apapaali Judaia ma ga laa manman Sasaria. ");
INSERT INTO ncf_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Tii magaa ma ga emagaae mii no inaman Taia ma Sidon. Ma di ga exumule ngali lasi ia. Di atuali Bilastas, iwaa taamat lot xan Erot, we di saan ngali xosaraa malum mii ia, amuina di xaa alet luxaal sin xan pula Erot. ");
INSERT INTO ncf_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Erot tii axilangi leng, tii taxaa mirmir taman xan no matmirmir king ma ga tsotso papan xan niaan xalkale, ma ga papaare lot laa sin no inaman araraa. ");
INSERT INTO ncf_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Di ga xuup lot, “A xap inan taamat aila ta papaare, oro inan moroaa abala!” ");
INSERT INTO ncf_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tiwaa tsaa xan angelo Orong a sas lii lapula, amuina tii xap manglen iesan Moroaa. Ma no goto di tii ga ngani xan pakpak ma ga met. ");
INSERT INTO ncf_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Oro xan totore Moroaa tii ga suk tsik watwat ma ga suk laa sin no daan xolot. ");
INSERT INTO ncf_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","O biaa Banabaas ma Sol delu ta se araraai xadelu no inatalil Jerusalem, delu suk mula laa Antiok. Ma delu ga giwaa Jon biexa iesan ila Mak. ");
INSERT INTO ncf_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Labatina xan matenaanua Moroaa in Antiok, xadi no propet ma no unaasasing: Banabaas, Simeon biexa iesan ila Maxet, Lusias taan Sairin, Manain (iwaa tii arie lotlot ma manman mii Erot Antipaas) ma Sol. ");
INSERT INTO ncf_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Biaa di tii lo langlangaari laa sin Orong ma di ga el, Nantanua Pat ga asaaiti, “Gim na axilangi Banabaas ma Sol ngali xosaraa balawaa tinaxaa iaa tii se ilei delulu ngali.” ");
INSERT INTO ncf_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Mulina di se el ma sausawit, di tulsen no liman di papan delulu ma di ga tulen delulu laa. ");
INSERT INTO ncf_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Nantanua Pat a tulen delulu ngali laa lapula inaman laba Selusia ma delu ga xaa papan mono ngali laa Saipras. ");
INSERT INTO ncf_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Delu laa tsap nan inaman laba Salamis ma delu ga tsiga lalon xadi Anua Sausawit no Jiu ma delu ga baais taman xan totore Moroaa. Jon biexa iesan Mak tii laa mii delulu ma tii ga tiltsomi delulu. ");
INSERT INTO ncf_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Delu eses ulti abia ienusa araraa Saipras, til delu ta le tsap lalon inaman laba Papos. Lalon abia xobel Papos, delu tatanginai taamat iesan ila Bar-Iesu. Ilawaa taamat ia xadi untsunuxa no Jiu ma ia propet ababaa. ");
INSERT INTO ncf_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ia turan gawana ta xaa tiltsomi ia papan abia ienusa, iesan Segias Polas. Iwaa gawana ia unsinaae. Tii ilei ngali Banabaas ma Sol xaalame amuina a we na alongmen xan totore Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Oro Elimas ilawaa untsunuxa (muina abia ies untsunuxa), a we na puxutsi gawana sin abia tinaalnge sin Iesu. ");
INSERT INTO ncf_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Biaa Sol biexa iesan ila Pol, Moroaa ga auusi ia taman Nantanua Pat ma ga nanen tutiik laa sin Elimas, ma ga paare, ");
INSERT INTO ncf_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Iu xan tsi maraanis! Ma iu xadi matenkorot no maarang ta tutiik, ma iu us taman no daan mat laxen namaang ina derexe. U xaa tigiri saan ngali puxutsi xan soina Orong ngali laa tsap malen inaabaa. ");
INSERT INTO ncf_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Lolong, talaawaa liman Orong a se xaalame papan iu, iu ba se matababa, ma iu ba xap lasi xalaleng ina pal sin xaa nen leng.” Tiwaa tsaa xuu ma lodo a suk baaii Elimas, ma ga es papas tsalei xa taamat ngali gii laamuangen ia taman liman. ");
INSERT INTO ncf_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Biaa iwaa gawana ta lasi senaara ta tsap, asuk olol sin abia xan asasing, biaabi ga suk taltaalnge sin Orong. ");
INSERT INTO ncf_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol mii xan inaman, di xaa papan mono xaal Papos ma di ga laa tsap Perga nan prowins Pampilia; oro nan abia xolot Jon Mak apapaali di ma ga mula laa Jerusalem. ");
INSERT INTO ncf_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Di xaal Perga ma di ga laa lalon inaman laba Antiok ina prowins Pisidia. Sin Saabat di es tsiga lalon anua sausawit ma di ga laa tsotso. ");
INSERT INTO ncf_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Mulina iexa taamat ta se xoxot sin xan no lo Moses ma no propet, no lalaamua ina anua sausawit, di ga tulen inesaait laa sin di we, “Nagiem no taamat, nawe nagim xa papaare biaa ngali anaai no inaman, axaau gim na papaare.” ");
INSERT INTO ncf_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pol a til lapalaa ga xosaraa axixila taman no liman ma ga paare, “No taamat in Israel ma gim no Gentail gim ta langaari laa sin Moroaa. Gim na lolong sin iaa! ");
INSERT INTO ncf_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Xadi Moroaa no Israel tii inten tsoli xida no iaaiaa ma tii ga xosaraa di ngali tsap xudu sin biaa di tii man malen no xibong Igip. Mil sin di ta se manman no daan miet, Moroaa atiltsomi di ma ga asen xan xoror watwat, biaa tii gii atsuulngi di Igip. ");
INSERT INTO ncf_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Tii adi abia mamaet ngali tilaamamil sin di sin no sangaul aet ina no miet lalon abia ines nan xobel biil. ");
INSERT INTO ncf_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Tii araabi no matenbung ta paasaalua tia Kaanan ma ga tali abia xadi pula laa sin no inaman Israel ngali momtsoli. ");
INSERT INTO ncf_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Balawaa no maarang se araraa tii tsap lalon abala 450 ina miet. “Mulina abia Moroaa ga tali no unininte sin di malen xadi no lalaamua ma ga laa pupua sin xan leng propet Samuel. ");
INSERT INTO ncf_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Biaa no inaman di ta atsuraa ngali xadi xa king ma Moroaa ga tali Sol, xan tsi ila Kis, ia ina xan matenbung ila Benjamin, ngali tsap xadi king sin no sangaul aet ina no miet. ");
INSERT INTO ncf_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Mil Moroaa ga saali Sol, tii suk axilangi Dewit ngali tsap xadi king. A papaare leng sin no inaman taman Dewit, ‘Iaa se tatanginai Dewit xan tsi ila Jesi, iwaa mat taamat iaa suk saansili, iwaa naba ta xosaraa no daan maarang malen iaa ta saan ngali na xosaraa no.’ ");
INSERT INTO ncf_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Xaal sin xan no utmilmil Dewit, Moroaa a se tali iwaa untino Iesu sin no Israel, malen ta xubatsi. ");
INSERT INTO ncf_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Setauan sin Iesu ta atiltsoli xan tinaxaa, Jon tii baais laa sin no inaman araraa in Israel ngali di na puxisbal ma di na adi axaxadaan. ");
INSERT INTO ncf_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","A se atat ngali Jon naba se araraai xan no tinaxaa ga we, ‘Gim adodo we saa iaa? A xap iaa iwaa taamat gim ta liliis ngali, a xap. Oro lolong, iwaa xa ta xaalame mulina iaa, iaa xap mamainaang buxa ngali lubati xan no bubut.’ ");
INSERT INTO ncf_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“No turaagamasen, gim xan no utmilmil Abaram, ma gim no Gentail gim ta langaari laa sin Moroaa, balawaa inesaait ina atotoaa xa a xaalame sin gita biaa Orong ta tulen. ");
INSERT INTO ncf_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","No inaman di ta tino Jerusalem ma xadi no lalaamua di xap nen xilalaa we, Iesu ia untino, ma di xap leng axaau sin xadi no totore no propet di ta xaa xoxoti sin no Saabat malen di ta taxaa puaa. Di atut tali ngali na met. ");
INSERT INTO ncf_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","“Ma biaa di ta xap tatanginai xa muina ngali na ilua, ma di suk atsuraa Pailat ngali na met. ");
INSERT INTO ncf_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ma mil sin di ta se xosor puaa senaara inaatel ta papaare taman, di alet atsuulngi xan pakpak papan tongol ma di ga laa aturungi lalon lia pupuna. ");
INSERT INTO ncf_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Oro Moroaa tii ga atapaasi ia xaal sin minet, ");
INSERT INTO ncf_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ma sin no daan leng, asemat sin no inaman biaa tii xaa eses mii di xaal Galili laa Jerusalem. O biaa no inaman di tii se paare leng so taman abia inesaait sin no Jiu. ");
INSERT INTO ncf_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Giem asaaiti gim taman biaa inesaait mamainaang biaa Moroaa tii se xubatsi tsaa sin xida no iaaiaa. ");
INSERT INTO ncf_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","A se taxaa puaa abala ngali gita, xadi no tsi sin ta atapaasi Iesu ngali tino mula, malen Dewit ta atalaa sin nanaalua ina no Saam. Balawaa totore a paare, “‘Iu nugu tsi; talaawaa iaa se tsap num mom.’ ");
INSERT INTO ncf_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Mil sin ta se met, Moroaa atapaasi xan tsi ngali tino mula ma naba xap pupua ngali maraap bula malen Moroaa ta atalaa, “‘Iaa ba tali sin gim biaa ta pat ma biaa soina tubudaan iaa ta xubatsi ngali tali sin Dewit.’ ");
INSERT INTO ncf_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Malen abia totore Dewit ta paatina sin biexa xolot, “‘U ba xap poroklii xan pakpak num taamat pat ngali naba maraap.’ ");
INSERT INTO ncf_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Dewit tii xosor puaa sawe Moroaa ta se ngiti ngali na xosaraa sin ta tino tsaa; ma biaa tii met, di ga punami xan pakpak mii xan no mom ma xan pakpak tii ga maraap. ");
INSERT INTO ncf_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Oro, iwaa taamat biaa Moroaa ta atapaasi sin minet xan pakpak tii xap maraap. ");
INSERT INTO ncf_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Biaabi nugu no taamat, iaa saan ngali gim na atiixi we, sin Iesu, getu ga baais taman inesaait sin gim ngali adodolii no namaang tsaxa. ");
INSERT INTO ncf_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Sin ia mu no inaman araraa di ta taltaalnge sin ia, di se tutiik lalon no matan Moroaa sin xadi no namaang tsaxa. Oro gim xap pupua ngali tsap tutiik sin amusili xan lo Moses. ");
INSERT INTO ncf_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Gim na tilaamamil ngali senaara no propet di se paare taman naba xap tsap sin gim: ");
INSERT INTO ncf_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“‘Gim lasi, gim no unaaxaxaraati, gim na tunga ma gim na met! Ngali biaa tinaxaa iaa ba ta xosaraa sin abala nagim no leng we gim ba suk xap taltaalnge, nawe xa tsaa asaaiti gim.’ ” ");
INSERT INTO ncf_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Biaa Pol ma Banabaas delu ta se saan ngali tapaas papaalii Anua sausawit, biaa no inaman di sebula ningi delulu ngali baais bula taman balawaa no maarang sin biexa Saabat. ");
INSERT INTO ncf_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mulina no inaman di ta se laa, xuduxudu ina no Jiu ma no Gentail, biaa di, di ta tsap no Jiu, di tii amusili Pol ma Banabaas. Delu papaare mii di ma anaai awatwati di ngali tigiri manman lalon xan amiimiilam Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sin biexa Saabat papan, biaa inaman laba araraa, di exumule ngali alongen xan totore Orong. ");
INSERT INTO ncf_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","O biaa no Jiu di ta lasi abia malep, di suk bal tsaxa ma di ga paare tabaxi xan no totore Pol ma di ga lii no papaare tsaxa ngali epuske mii semaarang tii papaatinai. ");
INSERT INTO ncf_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Mil Pol ma Banabaas delu xiis awatwati di, “Gelu na setauan asaaiti gim taman xan totore Moroaa. Biaa gim ta palolii xan inesaait ma gim ga xap pupua ngali asen we gim xap tutiik ngali adi tino laaliu mii ia. Lolong, talaawaa gelu ba se laa sin no Gentail ");
INSERT INTO ncf_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ilawaa Orong a se paare watwat sin gita, “‘Iaa se axilangi iu ngali tsap laleng ngali no Gentail ngali iu ba tali atotoaa xa sin no inaman araraa lalon xolkolmoxo ina inaman.’ ” ");
INSERT INTO ncf_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Biaa no Gentail di ta alongen abala, di suk taton ma di ga paʼii xan no totore Orong. O biaa di, Orong tii se axilangi di, ngali adi tino laaliu, di tii suk taltaalnge. ");
INSERT INTO ncf_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Xan totore Orong asuk tsitsiil laa sin abia inaman laba araraa. ");
INSERT INTO ncf_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Oro no Jiu di angunguti no Gentail aina biaa di ta lalaamua ma biaa di tsap no Jiu mii no lalaamua taamat ina inaman laba. Di atiltsoli no epurutsaae ngali epuske mii Pol ma Banabaas ma di ga saali delulu lalon xadi inaman laba. ");
INSERT INTO ncf_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pol ma Banabaas delu panlii no kuku sin no xaden delulu ngali asen sin di we Orong a palolii di ma naba tali mamaet sin di. Mil delu tii ga laa Aikonium. ");
INSERT INTO ncf_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ma no tsi asasing in Antiok, di ga suk us taman pinaalam ma mii Nantanua Pat. ");
INSERT INTO ncf_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Tia Aikonium: Pol ma Banabaas delu tsiga nan xadi anua sausawit no Jiu malen delu tii xoxosaraa ti. Delu ga paare alengi no inaman ma xuduxudu ina no Jiu ma Gentail di ga taltaalnge sin Orong. ");
INSERT INTO ncf_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Oro, biaa no Jiu di ta xap taltaalnge, di atiltsoli no epurutsaae mii no Gentail ma di ga puxutsi xadi no adodo ma sasaae ngali tilbanti delulu. ");
INSERT INTO ncf_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pol ma Banabaas delu man adis tsaa sin no leng ta xudu lalon abia xolot ma delu ga paare watwat taman xan amiimiilam Moroaa. Orong a xosaraa di ngali di ba pupua ngali xosaraa no axixila xoror ma axixila ngalibi ia ga asen we xan no totore aso. ");
INSERT INTO ncf_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","No inaman lalon abia inaman laba di xap ukbal. Biexaal di se til sin xadi papel no Jiu ma biexaal sin xadi papel no aposal. ");
INSERT INTO ncf_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Biaabi no Gentail ma no Jiu mii xadi no lalaamua, di ga saan ngali ngiti ngali pidi amantei delulu. ");
INSERT INTO ncf_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Oro delu ga atik tatanginai abala, delu ga sol laa nan prowins Likonia sin no inaman laba Listara ma Debi ma no xolot ulti inaman laba, ");
INSERT INTO ncf_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","lalon abia no xolot delulu baais taman abia inesaait mamainaang laa sin no inaman. ");
INSERT INTO ncf_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lalon abia inaman laba Listara, taamat ia no xaden ta met ma ga xap pupua ngali eses atiltsoli tsaa sin xan nagaa tii taxaana. ");
INSERT INTO ncf_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Iwaa taamat tii tsotso lolong sin Pol biaa tii lo papaare. Pol asuk nanen tutiik laa sin ma ga lasi malen ilawaa taamat a ie tinaalnge we naba tuo, ");
INSERT INTO ncf_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ma Pol ga paare lot laa sin, “Til tutiik laa lapalaa taman no xaiim.” Tiwaa tsaa, iwaa taamat a pis laa lapalaa ma ga atiltsoli eses. ");
INSERT INTO ncf_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Biaa no inaman di lasi sen maarang Pol ta xosaraa, di suk atiltsoli xuupkup ma di ga paare sin totore in Aikonium, “No moroaa di se xaalame lapula sangan gita malen no taamat toto!” ");
INSERT INTO ncf_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Di putsangi Banabaas taman Sus iwaa lalaamua ina moroaa ababaa ma Pol di putsangi taman Emes iwaa moroaa ababaa amuina ia lalaamua ina unbabaais. ");
INSERT INTO ncf_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Iwaa unsausawit ina Sus xaal xan anua Sus a manman lokobel atataaen mu inaman laba, iwaa unsausawit a giwaa axaalamei no bulmakau ma no usiusi laa matenmat ina abia inaman laba. Amuina iwaa lalaamua ma no inaman di we di na tsutsungit ngali tun axaii no tinabel laa sin delulu. ");
INSERT INTO ncf_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Oro biaa lo aposal Banabaas ma Pol delu ta alongen abala, delu ga suk xap ukbal taman sawe ta tsap biaabi delu ga tatari xadelu no manman ma delu ga sol laa sangan abia inaman ma delu ga xuup: ");
INSERT INTO ncf_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Delu we, “No taamat, ngalisa gim ta xosaraa abala no maarang? Gelu bula, gelu no taamat mu, no taamat toto malen mu gim. Gelu xaalame ngali tali abala inesaait mamainaang sin gim, ngali asaaiti gim ngali taaltalu sin balawaa no maarang ta xap so ma gim na agar laa sin Moroaa iwaa ta tino, iwaa ta xosaraa balalangit, ma xolkolmoxo ma laman ma no daan mat maarang lalon di. ");
INSERT INTO ncf_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Tii laamua tsaa, Moroaa tii poroklii no Gentail ngali langaari sin no sen moroaa di ta saan ngali amusili. ");
INSERT INTO ncf_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Oro a se asen xan mamainaang sin no inaman araraa we ia iwaa xa ta xosaraa xolkolmoxo ma asuk lot, ia mu a tali langit ma ga atsiki no xalitsa ma no xala ngali naba maatkel sin xadi uleng. A tali no daan luxaal sin gim ngali angen ma naba auusi nagim no butsa taman tataton.” ");
INSERT INTO ncf_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Sin abala no totore, tii suk lelep sin delulu ngali tilbanti biaa xumul ngali tun axaii no tinabel ngali delulu. ");
INSERT INTO ncf_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Mil biexaal ina no Jiu di xaal Antiok ma xaal Aikonium ma di ga atuali abia no inaman in Listara malen xan totore Pol a xap so. No Jiu di magaa sin Pol ma di ga pidili taman no xariin xaat pupua sin ta xol lapula. Di sorowe a se met biaabi di ga tate atsuulngi lalon inaman laba ma di ga poroklii ta matmatuul tia. ");
INSERT INTO ncf_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Oro, biaa no tsi asasing di ta se exumule ulti ia, Pol a tapaas ma ga sebula tsiga mula laa lalon inaman laba. Leng papan, ia ma Banabaas delu ga se laa Debi. ");
INSERT INTO ncf_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Delu ga baais taman Inesaait Mamainaang lalon abia inaman laba, ma xuduxudu ina no inaman di ga tsap no tsi asasing. Mulina abia, delu sebula mula laa Listara, Aikonium ma Antiok. ");
INSERT INTO ncf_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Lalon abia no inaman laba delu awatwati no tsi asasing ma anaai di ngali di na man taman soina tinaalnge. Di ga paare, “Gita na tsigaii no xaraxin xirabas ngali tsiga lalon xan Maradaan Moroaa.” ");
INSERT INTO ncf_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pol ma Banabaas, delu se axilangi no xusaak xuxuuk sin xan matenaanua Moroaa sin Karisito ngali no sausawit ma el, delu ga tali di sin Orong iwaa di ta se taalnge sin. ");
INSERT INTO ncf_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Mulina delu ta se es laa lalon no xolot Pisidia, delu se le tsap Pampilia. ");
INSERT INTO ncf_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ma biaa delu ta se baais araraa taman inesaait mamainaang lalon inaman laba Perga, delu se laa lapula Atalia. ");
INSERT INTO ncf_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Xaal Atalia delu sebula xaa papan mono laa Antiok. Lalon abia xobel no tsi asasing, di tii tali Pol ma Banabaas paina xan amiimiilam Moroaa sin biaa tinaxaa delu ta se araraai maaba. ");
INSERT INTO ncf_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Sin xadi tsinap atia, di gii axumuli xan matenaanua Moroaa ma delu ga atolomi no maarang Moroaa ta xosaraa no lalon delulu, ma biaa Moroaa ta tsalali abia mat ina tinaalnge laa sin no Gentail. ");
INSERT INTO ncf_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ma delu ga man adis tia mii no tsi asasing. ");
INSERT INTO ncf_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Biexaa taamat di xaal lapula Judaia ngali laa Antiok ma di laa taal asasing sin no untaltaalnge weaatalaa, “Gim ba suk xap pupua ngali adi atotoaa nawe di xap axasaui gim malen xan lo Moses ta paare.” ");
INSERT INTO ncf_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Balawaa maarang a xosaraa Pol ma Banabaas ma delu ga ebut buxa ma paare xuduxudu taman xadi asasing, biaabi di ga adodo ngali tulen Pol ma Banabaas ma biexaal in Antiok ngali laa Jerusalem ngali lasi no aposal ma no xusaak taman abala maarang. ");
INSERT INTO ncf_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Xan matenaanua Moroaa a tulen di laa nan sal, ma biaa di ta se lo eses lalon sal Ponisia ma Samaria, di ga papaare leng we, no Gentail bula di se puxisbal. Balawaa inesaait atatoni buxaai no untaltaalnge. ");
INSERT INTO ncf_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Biaa, di se tsap Jerusalem, no aposal ma no xusaak ina xan matenaanua Moroaa di suei atatoni di o Pol ma Banabaas delu ga asaait taman senaara Moroaa tii se xosaraa lalon delulu. ");
INSERT INTO ncf_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Oro biexaa untaltaalnge ina no Paarasi, di til lapalaa ma di ga paare, “Di na axasaui no Gentail ma na asaaiti di ngali amusili xan lo Moses.” ");
INSERT INTO ncf_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","No aposal ma no xusaak ina no untaltaalnge di tii tsap exumule ngali paare usili abala atsutsura. ");
INSERT INTO ncf_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Mulina biaa di ta se paare usili abia atsutsura, Pita a tapaas ma ga paare labatina di, “Nugu no taamat, gim atixi sin abia no leng ta se xap, Moroaa a inten iaa labatina gim ngali baais taman inesaait mamainaang laa sin no Gentail, ngali di na alongmen ma di na taltaalnge. ");
INSERT INTO ncf_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ma Moroaa iwaa ta atiixi xadi butsa no taamat asen we a sirawaa no Gentail sin ta tali Nantanua Pat sin di, malen mu ta tali sin gita. ");
INSERT INTO ncf_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Moroaa tii xap xosor axaatsap ngen di mii gita, a xap. Amuina tii amixati xadi no butsa sin di ta taltaalnge. ");
INSERT INTO ncf_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Biaabi, ngalisa talaawaa gim ta tali Moroaa sin xonkonon, sin gim ta tali tunuru mamaxet papan no tsi asasing, biaa xida no iaaiaa ma gita ta xap pupua bula ngali atsaxei? ");
INSERT INTO ncf_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","A xap! Giem taltaalnge we sin xan amiimiilam Orong Iesu we giem se leiwaa, malen mu di.” ");
INSERT INTO ncf_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Biaa inaman araraa di suk xale bong, ma di ga alongen Banabaas ma Pol delu ta asaait taman no axixila ma no axixila xoror Moroaa ta atsapngen sin delulu labatina no Gentail ");
INSERT INTO ncf_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Biaa delu ta se papaare araraa, ila Jeims a soro til ma ga papaare. “Nugu no taamat, gim na longmien iaa. ");
INSERT INTO ncf_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimon a se alengi sin gita, xan sen titii Moroaa setauan sin biaa ta giwaa biexaal labatina no Gentail ngali xan no inaman tsaa. ");
INSERT INTO ncf_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Xadi no totore no propet a ukbal taman sawe ta se tsap malen di ta se atalaa: ");
INSERT INTO ncf_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“‘Mulina abala no maarang, iaa ba laa mula ma iaa ba bula atilngi xan anuasel Dewit biaa tii se xol. A se tabek araraa, iaa ba sebula xosor mulanginai ma iaa ba sebula aturung mulanginai, ");
INSERT INTO ncf_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ngali abia no inaman ina xolkolmoxo, di ba tsatsel ngali Orong, ma no Gentail biaa di iaa ta ilei di ngali nugu no. Iaa Orong iaa paare taman abala, iwaa ta xosaraa abala no maarang, ");
INSERT INTO ncf_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","biaa di ta se atiixi no xamkabaar tsaa.’ ");
INSERT INTO ncf_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Balawaa nugu ininte, ngalibi gita na xap xosaraa na lelep buxa sin no Gentail biaa di ta puxisbal laa sin Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Oro gita na atatal laa sin di. Gita ba asaaiti di ngali di na xap ngani abia no luxaal ta morokon di ta tsutsungit tali sin no malagan. Aina ma taamat di na xap exus mii xa xaatsap di ta xap maxis sin di. Ma di ba xap ngani no nganei malen bol ma maan di ta luti no inan di taman sua ma di na xap ngani no nganei ta daldal tsaa. ");
INSERT INTO ncf_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","O ngali xan lo Moses, di tii babaais laa sin no Jiu lalon xadi no anua sausawit lalon no inaman laba araraa, sin no Saabat araraa sin abalaa no miet ti laamua.” ");
INSERT INTO ncf_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","No aposal ma no xusaak ina xan matenaanua Moroaa ma biaa no inaman araraa di se adodo ngali axilangi xaa taamat ina di tsaa ngali tulen laa Antiok mii Pol ma Banabaas. Di tii inten tsoxoli Judas (biexaa iesan ila Barsabaas) ma Sailas. Biaa no taamat ta lua, no lalaamua labatina abia no untaltaalnge. ");
INSERT INTO ncf_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Di tii tulen abala inaatel mii di: No aposal ma no xusaak, ma nagim no taamat: Laa sin no Gentail biaa no untinaalnge, tia Antiok, Siria ma Silisia: Lasiaat axaau. ");
INSERT INTO ncf_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Giem se alongen we biexaal di se laa loxona giem di ta xap adi xida banam ma di ga aboiki nagim no adodo ma di ga amamaxeti gim sin senaara di ta paatina. ");
INSERT INTO ncf_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Biaabi giem araraa giem ga ukbal ngali axilangi xaa taamat ngali tulen di laa sangan gim mii no turan giem so Banabaas ma Pol - ");
INSERT INTO ncf_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","balawaa no taamat delu xap mataa ngali tali xadelu tino ngali met sin iesan Orong Iesu Karisito. ");
INSERT INTO ncf_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Biaabi, giem ga tulen Judas ma Sailas ngali asaait taman no ngutsina delulu taman biaa uk totore giem ta atalaa. ");
INSERT INTO ncf_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Balawaa a suk axaau sin Nantanua Pat ma sin giem ngali giem na xap amamaxeti gim taman xawas bula oro ngali amusili xida no totore. ");
INSERT INTO ncf_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Gim na xap ngani abia no luxaal di ta tsutsungit tali sin no malagan, ma no nganei daldal, ma sin no nganei di ta luti no. Ma gim na xap exus mii biaa di, gim ta xap maxis sin di. Gim ba tsap axaau nawe gim pep alen abala no namaang. Nagiem axaau ma mamainaang so a laa sin gim. ");
INSERT INTO ncf_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Di se tulen abia no taamat ma di ga laa lapula Antiok. Biaa di ta axumuli no untaltaalnge ina anua langlangaari ma di ga tali abia inaatel sin di. ");
INSERT INTO ncf_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","No inaman di xoxoti, ma di ga suk taton sin biaa inesaait biaa ta anaai di ngali til watwat. ");
INSERT INTO ncf_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas ma Sailas, delu no propet, ma delu ga paare buxa sin di ngali anaai ma awatwati no untaltaalnge. ");
INSERT INTO ncf_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Mulina delu ta se manman biexaa leng tia Antiok, xadelu no taamat di tulen delulu taman tubudaan ina malina ngali mula laa sin abia di, di tii tulen delulu. ");
INSERT INTO ncf_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Oro Pol ma Banabaas, delu se manman tia Antiok. Delu mii biexaal, delulu ga babaais taman inesaait mamainaang ma delu ga asingan no inaman taman xan totore Orong. ");
INSERT INTO ncf_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Mulina biexaa leng, Pol a paare sin Banabaas, “Gitaa ba mula ngali laa uwaa xida no taamat sin no inaman laba araraa, biaa gitaa tii baais taman xan totore Orong ma gitaa ba lasi nawe di xosaraa axaautsi sin xadi tinaalnge.” ");
INSERT INTO ncf_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabaas a saan ngali na giwaa Jon, di putsangi bula Mak, ngali laa mii di. ");
INSERT INTO ncf_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Oro Pol adodo we a xap tutiik ngali giwaa ia amuina tii papaalii di Pampilia ma ga se xap eses mii di ngali alet laangen abia tinaxaa. ");
INSERT INTO ncf_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Delu xap ukbal buxa ma delu ga exatsape. Banabaas a giwaa Mak ma delu ga se xaa papan mono laa papan ienusa Saipras. ");
INSERT INTO ncf_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Oro Pol axilangi Sailas ma delu ga se laa, biaa delu ta laa xadelu no taamat di atubudaani delulu taman xan amiimiilam Orong. ");
INSERT INTO ncf_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pol tii es laa lalon no prowins Siria ma Silisia ma ga awatwati xan no matenaanua Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol tii es xaalame Debi mil ga laa Listara. Lalon abia xolot, iexa tsi asasing a manman atia iesan ila Timoti. Xan nagaa ia Jiu ma ia untinaalnge ma xan mom taan Grik. ");
INSERT INTO ncf_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Biaa no taamat in Listara ma Aikonium, di paare leng we ia taamat axaau ma xan namaang axaau buxa. ");
INSERT INTO ncf_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol a saan ngali na giwaa Timoti laa mii sin abia ines, biaabi Pol ga axasaui Timoti, amuina no Jiu di manman lalon abia xolot, aso di araraa di atii xan mom in Grik. ");
INSERT INTO ncf_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Sin abia xadi ines, di es tsiga lalon no inaman laba ma di ga tali no ininte sin no untaltaalnge biaa ta xaal sin no aposal ma no xusaak in Jerusalem, ngali no inaman di ba amusili no. ");
INSERT INTO ncf_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Biaa xan no matenaanua Moroaa, di tii watwat lalon tinaalnge ma di ga tsik xudu sin no leng xuxuuk sin xadi xoxot. ");
INSERT INTO ncf_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pol ma xan no inaman di se eses laa lalon abia no prowins Pirigia ma Galeisia, amuina Nantanua Pat a xap sirawaa di ngali di ba baais taman inesaait mamainaang lalon prowins Asia. ");
INSERT INTO ncf_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Biaa di ta se tsap sin tigatiga ina Misia, di suk xonon ngali tsiga Bitinia. Oro Nantanuaan Iesu a xap saan ngali di na laa. ");
INSERT INTO ncf_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ma di ga es liwaa Misia ma di ga se es laa lapula Troaas. ");
INSERT INTO ncf_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Sin abia bing Pol a urange ma ga lasi binalang nanen ga lasi taamat in Masedonia ta tiltil ma ga ninginingi Pol ma ga paare, “Xaalame tala Masedonia ma u na le tiltsomi giem.” ");
INSERT INTO ncf_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Mulina mu Pol ta se lasi abia binalang nanen, giem suk taxaaturung ngali tapaas laa Masedonia. Amuina giem nanxilalaa we, Moroaa a se ilei giem ngali baais taman inesaait mamainaang, laa sin abia no inaman. ");
INSERT INTO ncf_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Giem xaa papan mono, xaal Troaas ma giem ga sol laa tutiik sin ienusa Samotes. Ma sin leng papan, giem se laa tsap Niapolis. ");
INSERT INTO ncf_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Giem xaal atia ma giem ga suk es tsiga laa Pilipaai, biaa inaman laba lot no Rom di tii tumaraa ma biaa inaman laba Masedonia. Giem manman tia biexaa nen leng. ");
INSERT INTO ncf_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sin leng Saabat, giem se es tsuul lalon matenmat ina inaman laba, ngali laa sangan daansel ngali tsalei xa xolot ngali sausawit. Giem tsotso lapula ma giem ga tiltsoli papaare sin no aina di ta tsap exumule lalon abia xolot. ");
INSERT INTO ncf_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Iexa aina ina abia no aina di ta lolong, iesan ila Lidia. Ilawaa aina ina inaman laba Taiataira, axoxosaraa no laplap de ngali sune taman no. Ilawaa aina, a xaa langaari laa sin Moroaa ma Orong ga tsalali xan butsa ngali long tsiili senaara Pol ta papaare taman. ");
INSERT INTO ncf_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Biaa ia mii xan no inaman matenaanua, giem ga axadaani di. Asuk ningi watwati giem ngali laa lalon xan anua. “Nawe gim adodo we iaa untaltaalnge sin Orong, gim na xaalame ma le manman mii iaa lalon nugu anua.” Ma ga awatwati giem ngali amusili laa tatan. ");
INSERT INTO ncf_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Sin biexa leng, giem ta eses laa lalon xolot ina sausawit, giem sabasue tsaana untutule, tanua tsaxa ta xaa tsigaii, o ga xaa paare leng taman no maarang naba ta tsap talaa laamua. Ma ga xaa alet buxaai no xuxute ngali xan no manmanel sin ta xaa atolomi samaarang naba ta tsap talaa laamua. ");
INSERT INTO ncf_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ilawaa tsaana amusili Pol ma giem se araraa, ga xuupkup, “Balawaa no taamat xan no untutule Moroaa iwaa lapalaa suk se! Di ta paare leng sin gim taman sal ngali aleiwaai gim.” ");
INSERT INTO ncf_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Tii lo xoxosaraa abala namaang sin no daan leng. Mil Pol tii ga se pelmet sin abia xan namaang ta tigiri xosaraa, ma ga putsi ga paare ngali aia tanua tsaxa, “Sin iesan Iesu Karisito, iaa asaaiti awatwati iu, tsuul papaalii ia.” Tiwaa tsaa iwaa tanua tsaxa asuk tsuul papaalii ia. ");
INSERT INTO ncf_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","O biaa xan manmanel iwaa tsaana untutule tii se atii we xadi sal ngali xosor xuxute a se xap. Di suk tsiili Pol ma Sailas ma di ga tataii delulu laa lalon xolot ina susune ngali delu ba laa til lalon no matan no lalaamua ina inaman laba. ");
INSERT INTO ncf_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Di giwaa delulu laa sin no unininte ma di ga paare, “Balawaa no taamat, di no Jiu ma balawaa di se xosaraa no xariin xirabas nan inaman laba. ");
INSERT INTO ncf_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Balawaa, di se asingan no inaman taman no namaang biaa ta tabaxi, xadi lo no Rom gita ga xap pupua ngali adi o xosaraa no.” ");
INSERT INTO ncf_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Biaa malep di til etudim ngali imii Pol ma Sailas. Ma biaa no unininte di asaaiti di ngali taterlii xadelu no manman ma ngali ririiti delulu. ");
INSERT INTO ncf_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Mulina di tii se riit atsaxati delulu, di laa lii delulu lalon anua lodo. Ma di ga asaaiti awatwati unxoxo, ngali na suk xoxo axaau sin delulu. ");
INSERT INTO ncf_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ma iwaa unxoxo ta adi abia papaare watwat, asuk laa tali delu se talaa lolobet ina anua ma ga ros riiti no xaden delulu sin no xatin xupaap mamaxet. ");
INSERT INTO ncf_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Labatina bing se, Pol ma Sailas delu ga lo sausawit ma anaanngi no ararouk laa sin Moroaa. Ma biexaa xaus di tii ga alongen delulu. ");
INSERT INTO ncf_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Sauna mu, xaraxin ninil asuk tsap ma ga uraa no atkale ina abia anua lodo. Tiwaa tsaa, biaa no mat araraa ina anua lodo di suk tsalel, ma no tsen ga tamluba sin no xaus. ");
INSERT INTO ncf_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Iwaa unxoxo asuk pade, o biaa ta lasi no mat ina anua lodo ta tsalel, a suk irir tsaali xan bainat ngali naba se sas amantei ia tsaa, amuina a sorowe no xaus di tii se sol. ");
INSERT INTO ncf_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Oro Pol ga xuup laa sin aia unxoxo, “Nangaam sas amantei iu tsaa! Giem araraa mu tala.” ");
INSERT INTO ncf_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Iwaa unxoxo a ilei xa ngali xaa rarar. A sol tsiga ma ga xol didiir laamuaan Pol ma Sailas. ");
INSERT INTO ncf_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","A gii atsuulngi delulu ma ga atsuraa delulu, “Lo taamat orong, iaa ba xosaraa sa ngali iaa ba leiwaa?” ");
INSERT INTO ncf_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Delu xisi, “U na taltaalnge sin Orong Iesu ngali u ba leiwaa mii num matenaanua araraa.” ");
INSERT INTO ncf_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Mil sin abia, Pol ma Sailas, delu ga baais taman xan totore Orong Iesu laa sin unxoxo ma biaa bula di ta manman mii lalon xan anua. ");
INSERT INTO ncf_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Sin abia aua nabing, iwaa unxoxo a giwaa delulu ma ga guraii xadelu no toto ina ririit. Mil Pol ma Sailas delu ga axadaani iwaa unxoxo mii biaa di araraa lalon xan matenaanua. ");
INSERT INTO ncf_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Iwaa unxoxo, a giwaa delulu laa lalon xan anua ma ga xosaraa luxaal ngali angen sin delulu. Ia mii xan matenaanua araraa di suk us taman pinaalam amuina talaawaa di se taltaalnge sin Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Lawaareng sin biexa leng, no unininte, di tulen xadi no asilalxadek taman papaare ngali atsuulngi Pol ma Sailas. ");
INSERT INTO ncf_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Iwaa unxoxo ga asaaiti Pol, “No unininte di se paare watwat ngali iu mii Sailas ngali aleiwaai gululu lalon anua lodo. Talaawaa, gulu se laa lalon malina.” ");
INSERT INTO ncf_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Oro Pol ga paare sin no asilalxadek, “Di tii ririiti gelulu matan no inaman di ta xap ininte sin gelulu, oro gelulu in Rom; ma di ga lii gelulu lalon anua lodo. O talaawaa di we di na tulen atsuulngi axuina mu gelulu. A xap! Papaalii di na xaalame di tsaa ngali gii atsuulngi gelulu.” ");
INSERT INTO ncf_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Biaa no asilalxadek di paatinai sin no unininte taman xan totore Pol. O biaa di ta alongen abala malen Pol ma Sailas, delulu lo taan Rom, di suk mataa. ");
INSERT INTO ncf_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Di xaalame ma di ga ningi di ngali adodolii xadi no namaang tsaxa ma di ga gii atsuulngi delulu lalon anua lodo. Ma di ga asaaiti delulu ngali papaalii abia inaman laba. ");
INSERT INTO ncf_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Mulina abia Pol ma Sailas delu ta se tsuul lalon anua lodo, delu suk es laa tatan Lidia. Delu laa tatanginai xadelu no untaltaalnge ma delu ga taal inanaa sin di. Mil delu ga suk papaalii di. ");
INSERT INTO ncf_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pol ma Sailas delu se es liwaa no inaman laba Ampipolis ma Apolonia ma delu tii ga le tsap Tesalonika. Lalon abia xolot, xadi anua sausawit no Jiu. ");
INSERT INTO ncf_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Malen tsaa sin abia xan namaang Pol, a suk es tsiga lalon anua sausawit ma sin no Saabat ta tuul asingan di taman Inaatel Pat ");
INSERT INTO ncf_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ma ga alengi ma asen so we Karisito naba adi sosong ma naba tapaas mula sin minet. A paare we, “Ilawaa Iesu iaa ta baais taman, ia Karisito.” ");
INSERT INTO ncf_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Biexaal ina no Jiu, di taltaalnge sin abia inesaait, di ga amusili Pol ma Sailas, ma xuduxudu ina malep ina no Grik, di ta mataatina Moroaa, ma nen aina di ta ies lot, di amusili bula Pol ma Sailas. ");
INSERT INTO ncf_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Oro no Jiu di bal tsaxa tsaa ngali delulu. O di ga giwaa no taamat morokon lalon no xolot susune ma di ga til etudim ngali xosaraa no xariin inesas lalon abia inaman laba. Ma di ga sol isagaa laa lalon xan anua Jaison ngali tsalei delulu, ngali giwaa atsuulngi delulu laa lalon abia malep. ");
INSERT INTO ncf_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Oro di xap tatanginai delulu. Di laa ma tataii Jaison ma biaa di no untaltaalnge, laamuaan no lalaamua ina abia inaman laba. Ma di ga xuup weaatala, “Balawaa se no taamat di ta atapaasi no xirabas sin abala xolkolmoxo ina inaman. Ma talaawaa, di se xaalame tala. ");
INSERT INTO ncf_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ma Jaison ga suei atatoni di laa lalon xan anua, ma di ga manman mii. Di araraa di se pislaxei xan no lo Sisa biaa di ta paare we, ‘Iexa King tsaa ia, iesan ilaa Iesu.’ ” ");
INSERT INTO ncf_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Biaa di ta alongen abala totore, biaa malep ma no unbanam ina inaman laba di olol ma di ga suk boik. ");
INSERT INTO ncf_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Di atuaai Jaison ma no untaltaalnge ngali ul lii xadi no mamaet ma di ga tulen di laa. ");
INSERT INTO ncf_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Biaa ta se bing, biaa no untaltaalnge di se tulen Pol ma Sailas laa lalon inaman laba Beria. Biaa delu ta se laa tsap tia, delu suk es tsiga lalon anua sausawit sin no Jiu. ");
INSERT INTO ncf_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Balawaa no inaman Beria, xadi namaang asuk axaau buxa ngen no inaman Tesalonika. Biaa no inaman di ta longmien abala inesaait mamainaang, di adi abia totore taman taton ma di xoxoti abia no Inaatel Pat sin no leng araraa ngali atixi senaara Pol ta asaait taman aso o a xap. ");
INSERT INTO ncf_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Xuduxudu ina no Jiu di ga taltaalnge ma biexaal ina no Grik aina di ta ies lot mii xuduxudu ina biaa no taamat in Gentail. ");
INSERT INTO ncf_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Biaa no Jiu in Tesalonika di ta se atii we, Pol a se baais taman xan totore Moroaa tia Beria ma di ga laa bula ngali angunguti ma tsixi no balan abia malep. ");
INSERT INTO ncf_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Tiwaa tsaa biaa no untaltaalnge di suk isagaa ngali tulen Pol laa xuen, oro Sailas ma Timoti, delu manman mula Beria. ");
INSERT INTO ncf_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Biaa no taamat di ta es tali Pol laa Atens. Mil di ga se mula taman papaare watwat laa sin Sailas ma Timoti ngali delu na isagaa mula laa ngali tsomi Pol. ");
INSERT INTO ncf_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Biaa Pol tii lo liliisi Sailas ma Timoti lalon inaman laba Atens, asuk lolbiir buxa sin ta lasi abia no inaman laba ta us taman no mat moroaa ababaa. ");
INSERT INTO ncf_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Biaabi ga asingan no Jiu ma no Grik, biaa di ta langlangaari laa sin Moroaa, lalon anua sausawit, ma no inaman bula lalon no xolot susune sin no leng xuxuuk mii no saa di tsap esuei atia. ");
INSERT INTO ncf_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Biexaa xumul ina no Epikurian ma no Stoik unsinaae di atiltsoli ngali engangaae mii ia. Biexaal ina di, di atsura, “A we na paatina sa aila unpepexa?” Biexaal di paare “Amat malen asasing taman no moroaa xaatsap.” Di paatinai abala amuina Pol a baais taman Iesu ma tinapaas mula. ");
INSERT INTO ncf_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Di ga giwaa ia laa Areopagus ma di ga paare sin, “Giem we na atii abia asasing uul iu ta papaare taman. ");
INSERT INTO ncf_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Biexaa maarang iu ta paatinai no a teng xaatsap sin no talingan giem ma giem ga saan ngali atii muina ina abala no totore.” ");
INSERT INTO ncf_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Biaa no inaman in Atens araraa ma no xibong di ta manman tia, di saan buxa ngali papatina pales ma alongmen no adodo uul.) ");
INSERT INTO ncf_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pol a til lapalaa labatina abia xalkale lalon xolot Areopagus ma ga paare, “No taamat in Atens, sin nugu nanen, iaa lasi malen sin nagim no sal araraa gim no unlanglangaari so. ");
INSERT INTO ncf_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Amuina biaa iaa ta es galil lalon nagiem inaman laba ma iaa ga nanen laa sin no xolot gim ta xaa langaari tia, iaa tatanginai abia niaan tsutsungit di ta atalaa, laa sin Moroaa gita ta xap atii. Talaawaa sawe gim ta langaari laa sin a malen maarang gim ta xap atii, iaa ba baais laa sin gim. ");
INSERT INTO ncf_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Iwaa Moroaa tii xosaraa xolkolmoxo ma no mat maarang araraa lalon, Ia Orong ina balalangit ma tala balan pula. Ma a xap manman lalon no anua langlangaari biaa no taamat di ta xosaraa taman no liman di. ");
INSERT INTO ncf_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ma a xap saan ngali xaa was biaa no inaman di ba ta taxaa tali sin, amuina ia mu a tali tino ma maal ma no daan maarang sin no inaman araraa. ");
INSERT INTO ncf_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Xaal sin iwaa taamat ta xuuk, axosngi no mat laxen matenbung ina inaman ma ga axosngi di ngali di na manngi xolkolmoxo. Ia tsaa a se atutiki setauan tsaa biaa leng ngali di ma a se axilangi abia xobel ngali di na manman tia. ");
INSERT INTO ncf_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Moroaa a se xosaraa abala ngalibi no inaman di ba tsatsel ngali ia ma ngali nawe di papaas ngali ia di ba tatanginai ia. Oro Moroaa Ia asuk xap man palaaen gita xuxuuk. ");
INSERT INTO ncf_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ngali sin ia mu, gita manman, gita eses ma gita ie tino. Malen nagim no unsinaae tsaa di tii paare. ‘Gita xan no utmilmil.’ ");
INSERT INTO ncf_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Biaabi gita xan no utmilmil Moroaa, gita na xap adodo we Moroaa a malen goul o silwa o xaat, o xa malagan taamat ta xosaraa taman no lima. ");
INSERT INTO ncf_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Xamkabaar laamua, Moroaa tii nanlii xadi no adodo gomsaa, oro talaawaa a se paare watwat sin no inaman araraa sin no xolot araraa ngali puxisbal. ");
INSERT INTO ncf_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Amuina a se axilangi leng ngali naba ininte sin xolkolmoxo taman ininte tutiik sin iwaa taamat tii se axanei. A se asen so malen naba ininte sin no inaman araraa sin ta atapaasi ia xaal sin minet.” ");
INSERT INTO ncf_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Biaa di tii alongen Pol ta papaare taman tinapaas mula sin minet biexaal ina di, di soloki ma biexaal di we, “Giem saan ngali lolong bula sin abia maarang iu tii paatinai.” ");
INSERT INTO ncf_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ma sin abia, Pol ga se papaalii abia xalkale ina lolong. ");
INSERT INTO ncf_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Biexaa nen taamat di tsap xan no unaamamil Pol ma di ga taltaalnge. Labatina di, ilaa Dionisias iexa ina no Areopagas ma iexa aina iesan ilaa Daamaris ma biexaal bula. ");
INSERT INTO ncf_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Mulina abala Pol a se papaalii Atens ma ga se laa Korin. ");
INSERT INTO ncf_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Tiwaa, a balsi taan Jiu iesan ilaa Akuila. Ia taamat so ina prowins Pontas ma a er xaal mu Itali mii xan tubu ila, Prisila. Amuina Empora Kolodias a tali inesaait watwat ngali no Jiu araraa di na papaalii Rom. Pol tii ga laa ngali lasi di. ");
INSERT INTO ncf_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","A manman ma ga taxaa mii di, amuina ia untunumar ina anua sal malen mu di. ");
INSERT INTO ncf_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sin no leng Saabat araraa a engangaae lalon anua sausawit ngali xonon putsi xadi no adodo no Jiu ma no Grik. ");
INSERT INTO ncf_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Biaa Sailas ma Timoti, di ta se tsap xaal Masedonia, Pol asuk tali abia no leng araraa tsaa sin babaais ma papaare leng sin no Jiu we Iesu ia Karisito. ");
INSERT INTO ncf_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Oro biaa no Jiu, di ta epuske mii Pol ma di tii ga tubusen ia, a panlii no kuku sin xan no manman, ma ga paare ngali di, “Nawe gim met taman ininte ina nagim no namaang tsaxa, biaa nagim siksik ma a xap nugu. A xap nago xa mamaet. Atiltsoli talaawaa, iaa ba se laa babaais sin no Gentail.” ");
INSERT INTO ncf_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Mil sin abia, Pol ta se papaalii anua sausawit ma ga laa atataen xan anua Taitus Jastas, ia unlanglangaari laa sin Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ilaa Kirispus, ia lalaamua ina anua sausawit ma xan matenaanua araraa, di tii taltaalnge sin Orong ma xuduxudu ina inaman in Korin di tii ga alongen ia, ma di tii taltaalnge ma di ga adi axaxadaan. ");
INSERT INTO ncf_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Sin biexa bing, Orong a paare sin Pol lalon biexa binalang nanen, “Nangaam mataa, u na papaare tsaa ma nangaam bong. ");
INSERT INTO ncf_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Amuina iaa manman mii iu, ma naba xap xa na pupua ngali tsaapi ma taal sosong sin iu, amuina a xudu nugu no inaman lalon abala inaman laba.” ");
INSERT INTO ncf_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Biaabi Pol ga manman mii di sin miet axuuk ma xolot, ma ga asingan di taman xan totore Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Oro biaa Galio tii tsap gawana ina prowins Akaia, no Jiu di til etudim ngali tsiili Pol ma di tii ga atilngi ia lalon xalkale ina ininte. ");
INSERT INTO ncf_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Di atuti, “Ilawaa taamat we, tii atapaasi no balan no inaman ngali langaari sin Moroaa sin biaa namaang ta epuske mii lo.” ");
INSERT INTO ncf_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Biaa Pol ta we na se aponga ngutsina, Galio asuk asaaiti no Jiu, “Nawe gim no Jiu gim paare xuduxudu ngali no namaang tsaxa buxa o no xirabas lot, naba suk axaau buxa ngali iaa ba alongmen gim. ");
INSERT INTO ncf_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Oro biaa ta tali no atsutsura ina no totore ma no ies ma nagim no lo tsaa, gim na atutiki gim tsaa. Iaa ba xap tsap unininte sin gim ngali abala no namaang.” ");
INSERT INTO ncf_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ma ga lii atsuulngi di laa lokobel ina abia xan xalkale ina ininte. ");
INSERT INTO ncf_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Di araraa, di suk magaa buxa ngali Sostenes, lalaamua ina anua sausawit ma di ga tsaapi ia laamuaan unininte. Oro Galio asuk nanlii mu. ");
INSERT INTO ncf_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pol a sebula manman Korin sin biexaa nen leng. Mil, ga papaalii xan no taamat ma ga xaa papan mono ngali laa Siria, Ila Prisila ma Akuila, delu se tsomi laa lalon abia xolot. Setauan ngali naba se xaa papan mono, ari xuan itaan Senkeria amuina, a xosaraa xan xuxubu mii Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Di se laa tsap Epeso ma Pol ga se papaalii Prisila ma Akuila. Tii se es tsiga laa lalon anua sausawit xasinge ma ga engangaae mii no Jiu. ");
INSERT INTO ncf_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ma di ga atsuraa ia ngali naba man adis mii di, oro ga palo. ");
INSERT INTO ncf_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Oro, biaa tii we na se laa, a xubatsi, “Iaa ba mula nawe xan sirsiir Moroaa.” Mil ga xaa papan mono papaalii Epeso. ");
INSERT INTO ncf_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Biaa tii se le tsal Sasaria asuk es laa lapalaa ma ga suei atatoni xan matenaanua Moroaa, ma ga sebula mula laa lapula Antiok. ");
INSERT INTO ncf_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Mil ta se rom man adis Antiok, Pol a se tapaas atia ma ga se laa sin no xolot xuxuuk lalon no prowins ina Galeisia ma Pirigia ga awatwati no tsi asasing. ");
INSERT INTO ncf_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Sin abia leng, iexa taamat ina no Jiu, iesan ila Apolos. Di tii taxaana ia Aleksendia xan xobel so, tii ga xaalame Epeso. Ia unsinaae ma ga ie sinaae sin Inaatel Pat. ");
INSERT INTO ncf_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Di tii asingan ia taman xan sal Orong ma a papaare taman abia xariin sasaae, ma asasing tutiik taman Iesu. Oro tii atiixi mu xan axaxadaan Jon. ");
INSERT INTO ncf_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ia tii atiltsoli papaare taman watwat lalon anua sausawit. Biaa Prisila ma Akuila, delu alongen tii papaare, delu giwaa laa lalon xadelu anua ma delu ga asaait axaautsi taman tutiik ina xan sal Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Biaa Apolos tii se saan ngali laa lalon prowins Akaia, biaa xan no taamat lalon Karisito di awatwati ia ma di ga atatal laa sin no tsi asasing tia ngali di na suei atatoni ia. Sin xan tsinap, tii suk tiltsomi buxaai di, biaa sin xan amiimiilam Moroaa di tii se taltaalnge. ");
INSERT INTO ncf_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ia tii aiepatsaa no engangaae mii no Jiu lalon abia xumul ina epuske. Ma ngali asoi abia malen, totore lalon Inaatel Pat ta paare, Iesu mu ia Karisito. ");
INSERT INTO ncf_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Biaa Apolos ta manman Korin, Pol asuk es tsiga labatina xobel ma ga le tsap Epeso. Lalon abia xolot, tii ga se tatanginai biexaa tsi asasing. ");
INSERT INTO ncf_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ga atsuraa di, “Gim tii se adi Nantanua Pat, sin abia gim tii taltaalnge?” Di xisi, “A xap. Giem suk xap atii tsaa we xa Nantanua Pat ia.” ");
INSERT INTO ncf_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pol ga atsuraa di, “Gim tii adi sen matlaxen axaxadaan?” Di xisi, “Biaa xan axaxadaan Jon.” ");
INSERT INTO ncf_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pol ga paare, “Xan axaxadaan Jon, biaa axaxadaan ina puxisbal. Asaaiti no inaman ngali di na taltaalnge sin aia ta xaalame mulina ia, iwaa Iesu.” ");
INSERT INTO ncf_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Biaa di tii alongen abala, di tii suk axadaani di sin iesan Orong Iesu. ");
INSERT INTO ncf_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Biaa Pol tii tulsen no liman papan di, Nantanua Pat tii suk xaalame papan di ma di tii ga papaare taman no matlaxen xalam ma di tii ga tali totore ina propet. ");
INSERT INTO ncf_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","(Di sangaul ma ga laa lua ina taamat araraa.) ");
INSERT INTO ncf_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pol atsiga lalon anua sausawit ma ga paare watwat tia sin no uleng ta tuul ma ga engangaae buxa taman xan Maradaan Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Oro, biexaal ina di xadi no adodo ataban ma di ga palo ngali taltaalnge ma di ga paare tsaxa sin abia xan sal Orong. Pol tii ga papaalii di ma ga giwaa no tsi asasing ma tii ga papaare sin di sin no leng xuxuuk lalon xan anua asasing Tiranas. ");
INSERT INTO ncf_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Tii xosaraa abala sin no miet ta lua ngalibi, no Jiu ma no Gentail araraa di ta manman lalon prowins Asia di na alongen xan totore Orong. ");
INSERT INTO ncf_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Moroaa tii ga tali abia banam sin Pol ngali atsapngen no axixila xoror ta xaatsap buxa, ");
INSERT INTO ncf_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ngalibi no pu agisip ma no pu laplap ta le matse sin no isuaan, di adi no ma aturungi papan no minet ma di ga tuo ma no salawa tsaxa di tii ga papaalii di. ");
INSERT INTO ncf_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Biexaa Jiu, di ta es galgalil ngali xalel lii atsuulngi no tanua tsaxa biaa di ta xonon ngali saali no salawa sin iesan Orong Iesu papan biaa no inaman no salawa tsaxa ta tsigaii di. Ma di tii ga paare, “Sin iesan Iesu iwaa Pol tii babaais taman, iaa asaait awatwati gim ngali tsuul.” ");
INSERT INTO ncf_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Apaasaalua ina xan no tsi iexa xaraxin lalaamua ina no unsausawit ina no Jiu, ilaa Sikiwa, di tii xoxosaraa abala. ");
INSERT INTO ncf_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ma biexa leng iwaa salawa tsaxa tii xisi di, “Iesu, iaa atixi, ma iaa atii Pol, oro no saa gim?” ");
INSERT INTO ncf_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ma iwaa taamat salawa tsaxa ta tsigaii, a pis papan di taman xaraxin xoror, ma ga sas atsoti di, ma di tii ga sol tsuul belbel xaal nan anua taman no isua daldal. ");
INSERT INTO ncf_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Biaa no Jiu ma no Gentail di ta manman Epeso, biaa di tii se longmien, di suk us taman minataa, ma di tii ga alet alabati iesan Orong Iesu taman xariin mangmangle. ");
INSERT INTO ncf_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Xuduxudu ina abia di tii taltaalnge, di xaalame ma di ga paare leng taman xadi no namaang tsaxa di tii xoxosaraa no. ");
INSERT INTO ncf_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Biexaal ina abia di, biaa di tii atalaa xadi no buk tsunuxa, ma di tii ga axaii no lalon ie nan no matan no inaman. Biaa di tii xoxot todomien no, iliil ina no a pupua malen 50,000 silwa araraa ina no xuxute. ");
INSERT INTO ncf_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Sin abala namaang, xan totore Orong Iesu ga suk sol laa sin no xolot ma ga tsik taman xoror watwat. ");
INSERT INTO ncf_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Mulina abala maarang tii se tsap, Pol a se adodo lalon xan butsa ngali laa Jerusalem a es tsiga labatina Masedonia ma Akaia. A paare, “Mulina iaa ba ta tsap tia, iaa na laa uwaa Rom bula.” ");
INSERT INTO ncf_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ma ga se tulen xan no untiltiltsomi ilaa Timoti ma Erastas laa Masedonia, o ia ga ben man adis tsaa lalon prowins Asia. ");
INSERT INTO ncf_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Sin abia no leng, no xaraxin mamaet a tapaas, amuina sin abia xan sal Orong. ");
INSERT INTO ncf_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Iexa untumtumar silwa, iesan ila Demitias, iwaa ta xosaraa pu silwa anua ina Atemis iwaa moroaa ababaa. Balawaa tinaxaa a tali no daan xuxute sin no untunumar. ");
INSERT INTO ncf_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","A ilei axumuli abia no untunumar mii biexaa untinaxaa ma tii ga paare, “No taamat, gim tii se atiixi malen gita tii adi xariin iliil sin abala tinaxaa. ");
INSERT INTO ncf_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Gim se lasi ma alongmen ilawaa taamat Pol, ta awatwati no daan inaman ngali putsi xadi no adodo ma di tii ga laa palaaen biaa no malagan no untunumar di ta xosaraa no, tala Epeso ma no xolot araraa Asia. A paare, ‘A xap no moroaa so abia, no inaman di ta tumaraa.’ ");
INSERT INTO ncf_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Biexa was ta tsaxa, xida tinaxaa naba xosorlii abia ies axaau. Oro di ba xap manglen bula iwaa xariin moroaa aina Atemis ma biaa xan anua, biaa no inaman araraa di tii langaari laa sin abia prowins Asia ma xolkolmoxo araraa, naba xosorlii abia xan xariin geramis moroaa aina.” ");
INSERT INTO ncf_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Biaa di ta alongen abala, di suk magaa buxa ma di ga atiltsoli ngali xuup, “Atemis lot in Epeso!” ");
INSERT INTO ncf_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Sauna mu biaa inaman laba araraa di tii suk tangtangabaa, ma di ga tsiili Gaius mii Aristakas, biaa delulu ta xaal Masedonia mii Pol. Ma no inaman araraa di suk tsiga esurut isagaa laa lalon anua xumkumul malen taamat axuuk. ");
INSERT INTO ncf_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol a saan ngali til laamuaan abia malep, oro no tsi asasing di xap sirawaa ngali na sabasuei di. ");
INSERT INTO ncf_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Biexaa lalaamua ina abia prowins, biaa no turan Pol, di tulen totore sin ma ningi awatwati ngali naba xap laa lalon anua xumkumul. ");
INSERT INTO ncf_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Biaa xumul di tii suk boik, biexaal di xuupkup papaatinai biexa was ta xuuk, biexaal biexa was xaatsap, xuduxudu ina abia no inaman di xap atii langisa di ta le manman atia. ");
INSERT INTO ncf_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Biexaa xumul di adodo we balawaa xalkale xan Aleksenda amuina no Jiu di tsulen ia laa laamua. A paare axilangi no inaman taman no liman ngali di na bong. ");
INSERT INTO ncf_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Oro biaa di se xilalaa malen ia taamat in Jiu, di xuup adis etudim sin no aua ta lua: “Atemis lot in Epeso!” ");
INSERT INTO ncf_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Iexa unbanam ina inaman laba, ga abongi di, tii ga paare. “No taamat in Epeso, malen no inaman araraa sin xolkolmoxo ina inaman di atiixi bula we inaman laba Epeso a tilaamamil sin abala xan anua lot Atemis ma biaa malagan tii xol xaal balalangit? ");
INSERT INTO ncf_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Biaabi xa ga xap pupua ngali abaa taman abala no maarang. Gim na se man adamis ma gim na xap xosaraa xawas na tsaxa. ");
INSERT INTO ncf_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Gim se giwaa abala no taamat xaalame tala oro di xap pulaxi xaa was lalon no anua o paare tsaxa taman ilawaa xida moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Oro nawe Demitias mii xan uk untunumar di saan ngali atilngi xa lalon ininte. No leng ina ininte atsalel ma no unininte biaa, ngali atutiki no inemagaae. Di pupua ngali engangaae atia. ");
INSERT INTO ncf_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Oro nawe xawas bula biaa, gim ta saan ngali tali sin ininte, axaau mu biaa maarang di na atutiki laamuaan no unininte. ");
INSERT INTO ncf_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Malen balawaa, nawe Rom naba we gita se epurutsaae, amuina sin sawe ta tsap talaawaa, giem ba xap pupua ngali tali xa xixiis ngali abala tangtangabaa, amuina a xap xa muina.” ");
INSERT INTO ncf_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Mulina tii se paatina abala, a tulen biaa xumul laa. ");
INSERT INTO ncf_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Biaa epurutsaae tii se xap, Pol tii se tutule ngali no tsi asasing ngali xaalame sangan ngali na anaai di, ma tii ga putsangi xubalaasaai sin di ma ga laa Masedonia. ");
INSERT INTO ncf_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Biaa ta se laa es tsiga lalon abia xolot, a anaai no untaltaalnge taman no daan totore sin abia no inaman laba araraa ta tsiga lalon. Mil tii ga se laa tsap Gris. ");
INSERT INTO ncf_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Sin abia prowins tii le tsap a manman tia no uleng a tuul. A se saage ngali laa Siria oro no Jiu di ga adodo ngali sas amantei ia. Biaabi ga adodo ngali mula laa Masedonia. ");
INSERT INTO ncf_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Biexaa taamat di tsomi sin abia ines malen ila Sapata xan tsi ilaa Piras ia in Beria, ila Aristakas ma Sikudas in Tesalonika ma Gaius in Debi ma Timoti bula ma Taitsikas ma Tropimas lalon prowins Asia. ");
INSERT INTO ncf_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Balawaa no taamat di setauan eses laamua tsaa ngen Pol ma di ga liliis ngali giem Troaas. ");
INSERT INTO ncf_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Oro giem xalkale tsaa Pilipaai, pupua sin leng ina luxaal ina tsoki ta xap xa iis. Mil giem ga tuut papan mono xaal Pilipaai ma sin no leng ta lima ta se liu, giem se laa tsap Troaas ma giem ga manman atia no leng apaasaalua. ");
INSERT INTO ncf_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Sin nanaaxuuk leng ina wik, giem se tsap etudim ngali tsabaxi exasen tsoki. Ma Pol ga lo papaare sin no inaman til ta se laa labatina bing amuina naba se papaalii di sin leng papan. ");
INSERT INTO ncf_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Papan abia xabin lapalaa ina abia anua giem ta exumule lalon, axuduxudu no laam biaa lalon xabin. ");
INSERT INTO ncf_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Iexa taamat xulaau iesan ilaa Iutikas a tsotso papan maalwimat, biaa Pol ta lo papaare tsaa iwaa xulaau asuk taba taman mano urange, o asuk xol xaal sin nanaatuul ina paradaa, laa lapula papan pula, di alet tsoxoli sin ta se met. ");
INSERT INTO ncf_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pol atsuul laa lapula ma ga laa wales papan aia taamat xulaau ma ga logotsi ma ga paare, “Gim nangaam lol tsaxa, a tino mu!” ");
INSERT INTO ncf_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ma ga sebula laa lapalaa ma ga tsabaxi tsoki ga exasen ma di ga ngani, mulina ta papaare pupua sin ta tampanek, asuk papaalii di. ");
INSERT INTO ncf_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","No inaman di giwaa iwaa xulaau laa lokobel ta tino mu ma di ga paʼii Orong ma di ga adi xariin axoxorong. ");
INSERT INTO ncf_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Giem se laamua papan mono laa Asos, tiwaa giem ba giwaa Pol. Tii se paare leng taman abia xan ines ngali eses. ");
INSERT INTO ncf_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Biaa giem ta ebulis Asos, giem tii giwaa ia laa papan mono ma giem tii ga laa Mitilini. ");
INSERT INTO ncf_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Leng papan giem se tuut xaal atia ma giem tii ga se le tsap Kios. Mulina abia leng, giem se es tabaxi sal ngali laa Samos ma sin leng papan giem tii se laa tsap Miletas. ");
INSERT INTO ncf_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pol ga se adodo ngali naba se tuut laa liwaa Epeso amuina a palo ngali man adis lalon prowins Asia. Pol a isagaa buxa ngali na tsap Jerusalem tutiik sin leng ina Pentikos. ");
INSERT INTO ncf_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Xaal Miletas, Pol tii ga se tulen totore ngali no xusaak ina xan matenaanua Moroaa Epeso ngali di na xaalame. ");
INSERT INTO ncf_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Biaa di tii le tsap, Pol ga paare sin di, “Gim se atii, iaa sen tino we sin iaa tii manman mii gim, atiltsoli sin nanaaxuuk ina leng iaa tii xaalame tia lalon prowins Asia. ");
INSERT INTO ncf_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Oro iaa taxaa ngali Orong taman xaraxin mangmangle ma taman no didinmat, oro biexaa Jiu di tali xaraxin mamaxet ina xonkonon taman xadi no ngitngit. ");
INSERT INTO ncf_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Gim se atiixi malen, iaa tii xap mataa ngali baais taman xawas biaa naba ta tiltsomi gim oro iaa tii se asingan gim laamuaan no inaman ma laa sin no anua xuxuuk. ");
INSERT INTO ncf_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Iaa tii se baais sin no Jiu ma no Gentail ngali di na puxisbal ma di na agar laa sin Moroaa ma taltaalnge bula sin xida Orong Iesu. ");
INSERT INTO ncf_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“O talaawaa, iaa xap atii senaara naba tsap susugu Jerusalem, oro Nantanua Pat atapaasi iaa ngali laa atia. ");
INSERT INTO ncf_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Iaa atixi mu, malen sin no inaman laba xuxuuk, Nantanua Pat a se atewaai iaa malen anua lodo ma no xirabas alilisi iaa. ");
INSERT INTO ncf_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Oro, iaa xap adodomi nugu tino nawe senaara atsap susugu, iaa na suk araraai abia inatalil Orong Iesu ta tali susugu ngali paare leng taman abia inesaait mamainaang ina xan amiimiilam Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Oro talaawaa, iaa se atixi malen a xap xa labatina gim no saa iaa tii se laa baais taman xan Maradaan Moroaa, naba xap bula lasi iaa. ");
INSERT INTO ncf_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Biaabi, iaa tii ga asaait alengi gim malen talaawaa nawe xa ina gim a xap taltaalnge sin Iesu o ga met, iaa suk leiwaa sin xadi no dal abia no inaman araraa. ");
INSERT INTO ncf_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ma iaa tii xap mataa ngali papaare leng sin gim taman xan sirsiir araraa Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Gim na xoxo sin gim tsaa ma no inaman araraa, biaa Nantanua Pat tii se xosaraa gim ngali tsap xadi no xusaak, gim na malen no xusaak sin xan matenaanua Moroaa, biaa tii se uuli taman xan dal tsaa. ");
INSERT INTO ncf_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Iaa atiixi malen mulina iaa ta laa, no xapunakok, di ba xaalame labatina gim ngali tsaarien xan no sipsip Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Biexaal ina nagim no inaman tsaa di ba atapaasi ma putsi abia soina laa sin no dalek ngalibi naba tatelii xadi adodo no tsi asasing ngali amusili di. ");
INSERT INTO ncf_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Gim na xoxo axaau. Gim na adodomi malen sin no miet ta tuul, iaa xap iaawis sin atewaai gim xuxuuk sin no bing ma siaat taman didin mat. ");
INSERT INTO ncf_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Talaawaa iaa tali gim sin Moroaa ma sin xan totore ina xan amiimiilam biaa naba ta pupua ngali atsiki gim ma naba tali abia, gim ba ta momtsoli, labatina abia xan no inaman pat Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Sin nugu manman mii gim, iaa tii xap saan ngali xaa silwa o goul o xaa uga sin xaal. ");
INSERT INTO ncf_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Gim tsaa gim atixi we iaa taxaa taman no limaaga tsaa ngali puaa nugu no muun mii nugu no uk tinaxaa. ");
INSERT INTO ncf_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Sin no maarang araraa iaa ta xosaraa no, iaa asen sin gim we, sin balawaa no mat tinaxaa ta lelep gita na suk tiltsomi no maluaai ngali adodomi xan no totore Orong Iesu tsaa ta paare, ‘Asuk tubudaan buxa ngali tabiel ngen ngali adi.’ ” ");
INSERT INTO ncf_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Biaa tii se paatina abala no, a sage putput mii di araraa ma di tii ga sawit. ");
INSERT INTO ncf_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Di araraa di teng sin di ta elogo ngen ia ma di ga nguri. ");
INSERT INTO ncf_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Xan no totore Pol a xosaraa di ga lolbiir amuina di ba se xap bula lasi no matan. Mil di es tsomi ngali laa papan mono. ");
INSERT INTO ncf_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Mulina giem ta se papaalii di taman lolbiir, giem se laa tutiik Kos. Leng papan giem se laa Rodes, ma xaal atia giem laa Patara. ");
INSERT INTO ncf_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Giem tatanginai mono ta tabaxi Ponisia ma giem ga pis xaa papan ma giem ga se tuut laa. ");
INSERT INTO ncf_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Mulina giem tii se lasi ienusa Saipras ma giem ga tuut laa nan no paxel ina ienusa, giem ga tuut laa nan prowins Siria. Giem se laa tsal lalon inaman laba Taia biaa nagiem mono ta atsuul tali no maarang atia. ");
INSERT INTO ncf_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Giem tatanginai biexaa tsi asasing ma giem ga manman mii di atia sin wik axuuk. Di amusili Nantanua Pat, di ga paare sin Pol, “Nangaam laa Jerusalem.” ");
INSERT INTO ncf_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Oro biaa wik tii se liu. Giem se papaalii Taia ma amusili nagiem sal. No tsi asasing araraa mii xadi no tubu ma xadi no tsixi, di es tsuul tsoxomi giem xaal lalon inaman laba, tiwaa xuen, giem sage putput ma giem ga sawit. ");
INSERT INTO ncf_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Mil, biaa giem ta se paare xubalaasaai engen giem, giem pis xaa papan mono ma di ga se mula laa lokobel. ");
INSERT INTO ncf_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Giem sebula tapaas amusili nagiem sal xaal Taia ma giem se laa tsal nan inaman laba Tolemes. Lalon abia xolot, giem se ebulis mii no untaltaalnge, ma giem ga se manman mii di tia sin nan leng ta xuuk. ");
INSERT INTO ncf_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Giem tapaas sin leng papan, giem ga se laa tsap Sasaria. Ma giem se laa manman lalon xan anua Pilip. Pilip iwaa unbabaais, ma ia ina abia apaasaalua ina abia no taamat di ta tiltsomi no aposal. ");
INSERT INTO ncf_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Xan no tsaana detuu et ma di xap maxis. Detuu xaa tali xan totore Moroaa tsaa. ");
INSERT INTO ncf_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Giem se manman atia sin no daan leng o iexa propet iesan ilaa Agabas tii xaal lapalaa Judaia. ");
INSERT INTO ncf_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ma ga xaalame sangan giem ma ga adi xan biaal ilaa Pol ma ga rotsi no liman ma no xaden tsaa taman, ga we, “Nantanua Pat a paare, ‘Sin abala sal, no Jiu in Jerusalem di ba pitsi tapkina abala biaal ma di na tali sin no Gentail.’” ");
INSERT INTO ncf_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Biaa giem tii se alongmen abala, giem mii no inaman tia, giem ningi buxaai Pol ngali naba xap laa lapalaa Jerusalem. ");
INSERT INTO ncf_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pol a laa ma ga xisi di we atala, “Ngalisa gim ta tengteng ma gim ga baxi nugu butsa? Iaa taxaaturung mu ngali di ba pitsi iaa oro ina met bula lapalaa Jerusalem, ngali iesan Orong Iesu.” ");
INSERT INTO ncf_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Giem se xap pupua ngali puxutsi xan adodo, giem se papaalii mu ia ma giem ga we, “Gita ba xap tilbanti. A se manman paina xan sirsiir Orong.” ");
INSERT INTO ncf_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Mulina abia, giem se taxaaturung ma giem ga se laa lapalaa Jerusalem. ");
INSERT INTO ncf_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Biexaa tsi asasing in Sasaria di xaalame mii giem ma di ga le tali giem lalon xan anua Nason, iwaa giem ba ta manman mii. Ia taamat in Saipras ma ia taamat in tii setauan ina no tsi asasing. ");
INSERT INTO ncf_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Biaa giem ta se laa tsap Jerusalem, no untaltaalnge, biaa nagiem no taamat di suk suei giem taman tataton. ");
INSERT INTO ncf_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Sin leng papan, Pol ma giem se araraa giem laa lasi Jeims, ma no xusaak araraa bula di manman tia. ");
INSERT INTO ncf_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pol a suei atatoni di taman malina ma ga paatinai no inaatalem amusili abia xan tinaxaa Moroaa biaa tii xosaraa labatina no Gentail, lalon abia xan inatalil. ");
INSERT INTO ncf_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Biaa di tii alongen abala, di suk paʼii Moroaa, ma di ga paare ngali Pol, “U na lasi nagiem taamat, aisa bala no tausan ina no Jiu, di se taltaalnge, ma di se araraa di mangat buxa ngali amusili xan lo Moses. ");
INSERT INTO ncf_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Biexaal di asaaiti di we, u asingan no Jiu araraa, biaa di ta manman labatina no Gentail, ngali taaltalu sin xan lo Moses. Ma u asaaiti di ngali di ba xap axasaui xadi no tsi ma di ba xap bula amusili xida namaang. ");
INSERT INTO ncf_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Gita ba se xosaraa sa? Balawaa di ba se alongen malen iu se xaalame tala. ");
INSERT INTO ncf_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Iu na xosaraa senaara giem ta se asaaiti iu. No taamat detuu et bala mii giem detuu se xosaraa xuxubu laa sin Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","U na giwaa abala no taamat, ma gim arie laa lalon Xan Anua Moroaa ngali tsigaii abia namaang ina amixati ma na uuli xadi iliil ngali rii lii no ulin xuan di, mil no inaman di ba atii we a xap xa so sin xadi inaatalem ina iu. Oro iu tsaa iu amusili xan lo Moses. ");
INSERT INTO ncf_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Oro ngali abia, no untaltaalnge ina Gentail, giem se atatal laa sin di taman nagiem adodo. Giem asaaiti di ngali di na xap ngani luxaal biaa di ta tsutsungit laa sin no malagan, ma di ba xap nungi dal, ma di na xap ngani abia no nganei di ta luti. Ma gim nangaam exus mii no aina di ta xap maxis sin di.” ");
INSERT INTO ncf_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Sin leng papan, Pol a giwaa no taamat ma ga arie amixati ia tsaa mii di. A se es laa lalon Xan Anua Moroaa, ngali paare leng taman no leng ina guraii auuli di naba xap sin sen leng ma ngali tali tinabel sin di xuxuuk. ");
INSERT INTO ncf_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Biaa no leng ta paasaalua ina amixati ta atat ngali xap, biexaa Jiu lalon prowins Asia di tii se lasi Pol lalon Xan Anua Moroaa. Di atapaasi malep taman no minagaa ma di ga logotsi ia. ");
INSERT INTO ncf_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Di xuupkup papaare we, “No taamat in Israel, gim na tiltsomi giem! Ilawaa taamat a laa sin no daan xolot ma ga asingan no inaman sin no xolot araraa ngali epuske mii nagiem no inaman, ma xida no lo ma balawaa xolot. O talaawaa a se gii atsigali biexaa Gentail laa lalon Xan Anua Moroaa ma ga amorokoni.” ");
INSERT INTO ncf_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Biexaal di tii setauan lasi Tropimas ia taamat in Epeso mii Pol lalon abia inaman laba. Ma di ga adodo we Pol tii giwaa ia laa lalon Xan Anua Moroaa.) ");
INSERT INTO ncf_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","No inaman lalon abia inaman laba Jerusalem di suk lol tsaxa. No inaman di sol xaal sin no daan xolot ma di ga le logotsi Pol. Di tataii atsuulngi xaal lalon Xan Anua Moroaa, ma tiwaa tsaa di suk tsaxali no matan mat. ");
INSERT INTO ncf_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Di we na se sas amantei Pol o lalaamua lot ina no unmakmaxil in Rom ga se alongen inesaait malen inaman araraa Jerusalem di epurutsaae. ");
INSERT INTO ncf_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Sauna mu, tii giwaa no lalaamua ma no unmakmaxil di ga sol laa lapula sangan abia malep. Biaa no taamat di ta lasi iwaa lalaamua lot ma xan no unmakmaxil, di se xap tsaapi bula Pol. ");
INSERT INTO ncf_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Lalaamua lot a se xaalame ma tii ga se tsiili ia. A paare watwat ngali no unmakmaxil di na rotsi Pol taman no tsen ta lua. Mil ga atsura. “Sa taamat aila? Ma a xosaraa sa?” ");
INSERT INTO ncf_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Biexaal ina abia malep di xuup papaatinai biexa was, o biexaal di xuup papaatinai was xaatsap. Biaabi iwaa lalaamua lot ga xap pupua ngali tatanginai soina, amuina sin abia ngaarere. A paare watwat ngali atsigali Pol lalon xadi bengbeng no unmakmaxil. ");
INSERT INTO ncf_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Biaa Pol ta se es tsap sangan no matsabal, biaa malep di suk magaa buxa ngali tsaapi Pol, biaabi no unmakmaxil di ga suk atsaxei ia. ");
INSERT INTO ncf_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Biaa malep di ta eses amamil di lo xuup papaatinai, “Giem na sas amantei!” ");
INSERT INTO ncf_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Biaa no unmakmaxil di se taxaaturung ngali giwaa Pol laa lalon xadi bengbeng no unmakmaxil, o atsuraa lalaamua lot, “A pupua ngali iaa ba asaaiti iu taman xawas?” Lalaamua a xisi, “U pupua ngali paare in Grik? ");
INSERT INTO ncf_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","A xap iu aia taamat in Igip iwaa ta atiltsoli no epurutsaae ma laamuangen no tausan aet (4,000) ina no unsasas lalon xobel xenken biil sin balaa xaa leng ta se xap?” ");
INSERT INTO ncf_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pol a xisi, “Iaa taan Jiu lalon xobel Taasas, lalon prowins Silisia. Iaa taamat so lalon abia xariin inaman laba. Timaa, iaa we ina ben paare sin no inaman.” ");
INSERT INTO ncf_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Lalaamua asiir ngali naba totore. Pol a til papan matsabal ma ga xosaraa axixila ngali man adamis taman no liman sin abia malep. Biaa di tii se bong, ga se paare laa sin no inaman taman xadi totore Ibru. ");
INSERT INTO ncf_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Nugu no mom ma no turaagamasen, gim na lolong axaau sin senaara iaa ba ta paare leng taman, iaa xap xosaraa xawas na tsaxa.” ");
INSERT INTO ncf_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Biaa di tii alongmen ta papaare sin totore Ibru, di tii suk bong. Pol ga paare, ");
INSERT INTO ncf_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Iaa Jiu. Nugu nagaa tii taxaana iaa lalon inaman laba Taasas lalon prowins Silisia. Oro Iaa tii lot lalon abia inaman laba. Iaa tii asasing paina Gamalel. Iaa tii suk asasing axaau taman xadi lo xida no iaaiaa. Ma iaa ga suk mangat buxa ngali Moroaa malen gim araraa talaawaa. ");
INSERT INTO ncf_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Iaa tii xaa tali mamaet sin biaa no unaamumusili abia xan Sal Orong ma sas atsoti di sin abia sal pupua sin xadi minet, iaa tii xaa tsiili bula no taamat ma no aina ma iaa ga lii di lalon anua lodo. ");
INSERT INTO ncf_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Malen bula lalaamua ina no unsausawit ma biaa kaunsel araraa di ba paare leng sin gim araraa, iaa xaa adi bula no inaatel xaal sin di, laa sin xadi no taamat in Damaaskas, ma iaa ga laa atia ngali giwaa abia no inaman malen no xaus laa Jerusalem ngali alet sosong. ");
INSERT INTO ncf_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Biexa leng labatina siaat se, iaa tii se xaalame atat ngali tsap Damaaskas. Sauna mu biaa tsilatsila ina rarar asuk xaal lapalaa balalangit ma ga suk le tsila ulti iaa. ");
INSERT INTO ncf_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Iaa xol laa lapula ma iaa ga alongen inan xa ta papaare ngali iaa ga we, ‘Sol, Sol! Ngalisa iu ta xosor atsoxoti iaa?’ ");
INSERT INTO ncf_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Iaa atsura, ‘Saa iu, Orong?’ “A xisi, ‘Iaa Iesu in Nasaret, iwaa iu ta taxaa ngali xosor atsoxoti.’ ");
INSERT INTO ncf_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Biaa no turaaga, di tii lasi abia rarar oro di tii xap leng sin abia inan ina iwaa xa ta papaare sin iaa. ");
INSERT INTO ncf_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Iaa atsuraa, ‘Orong, iaa ba se xosaraa sa?’ “Orong ga asaaiti, ‘Tapaas ma u na laa Damaaskas. Tiwaa di ba asaaiti iu taman no maarang araraa Moroaa ta saan ngali u ba xosaraa no.’ ");
INSERT INTO ncf_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Biaa no turaaga, di taxaana no limaaga ma di ga es laamuangen iaa laa Damaaskas amuina biaa tsilatsila ina rarar ta ababai no mataaga. ");
INSERT INTO ncf_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Iexa taamat iesan ilaa Ananias tii xaalame ngali le lasi iaa. Ia unaamumusili axaau ina xan lo Moses ma no Jiu araraa di ta manman tia, di suk manglen buxaai ia. ");
INSERT INTO ncf_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","A le til sangaaga ga paare, ‘Nugu taamat Sol, nanen mula.’ Tiwaa tsaa iaa suk pupua ngali lasi ia. ");
INSERT INTO ncf_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Ga paare, ‘Xadi Moroaa xida no iaaiaa tii se axilangi iu ngali atii xan sirsiir ma ngali lasi Iwaa Untutiik, ma ngali alongmen no totore xaal sin ngutsina. ");
INSERT INTO ncf_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ngali iu ba xan tiltsoxoti sin no inaman araraa ngali sen maarang iu tii lasi ma alongen no. ");
INSERT INTO ncf_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ma talaawaa, u liliisi sa? U na tapaas, u na ningning sin iesan Orong Iesu ma u na adi axaxadaan ngali guraii lii num no namaang tsaxa.’ ");
INSERT INTO ncf_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Biaa iaa tii se mula laa Jerusalem ma iaa ga lo sausawit lalon Xan Anua Moroaa ma iaa ga lasi binalang nanen. ");
INSERT INTO ncf_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ma iaa ga lasi Orong ta papaare ngali iaa, ‘Isagaa, u na papaalii Jerusalem talaawaa tsaa, amuina no inaman atala di ba xap sirawaa num no papaare leng taman iaa.’ ");
INSERT INTO ncf_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Iaa xisi, ‘Orong, balawaa no taamat di atiixi we iaa tii xaa laa sin no anua sausawit xuxuuk ma laa sin biexa ma ngali tsiili ma lii di lalon no anua lodo ma ngali tsaapi biaa di, di ta taltaalnge sin iu. ");
INSERT INTO ncf_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ma biaa di ta pidi Stepan iwaa num tiltsoxoti, taman no xaat ma xan dal ga rue papan pula, iaa tii manman mii di ma iaa ga ukbal ngali sas amantei ia. Ma iaa tii ga xoxo sin xadi no uga disdis abia di, di ta pidi ia.’ ");
INSERT INTO ncf_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Mil Orong ga paare ngali iaa, ‘Laa; iaa ba tulen iu laa palpalaa sangan abia no Gentail.’” ");
INSERT INTO ncf_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Biaa malep di lolong til sin Pol ta paare weaatala, mil di ga xuup laa lapalaa, “Gim na sas amantei ia. A xap pupua ngali naba manman sin abala tino.” ");
INSERT INTO ncf_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Biaa di ta lo xuupkup ma di ga lii xadi no uga disdis ngali tsaaparen lii kuku nan waa. ");
INSERT INTO ncf_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Lalaamua ina no unmakmaxil asaaiti di ngali di na giwaa Pol laa lalon xadi bengbeng no unmakmaxil. A asaait awatwat abia di ngali di ba ririiti ma atsuraa ngalisa no inaman di ga xuupkup we atia sin ia. ");
INSERT INTO ncf_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Biaa no unmakmaxil di se pitsi no liman ngali di ba se ririiti, Pol ga paare sin iexa lalaamua ina no unmakmaxil ta tiltil tia, “A tutiik ngali gim ba ririiti taamat in Rom iwaa gim ta xap tatanginai xa xirabas sin?” ");
INSERT INTO ncf_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Biaa iwaa lalaamua ta alongen abala asuk laa sangan lalaamua lot ma ga atsuraa, “U ba se xosaraa sa? Ilawaa taamat so in Rom.” ");
INSERT INTO ncf_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Lalaamua lot a se es laa sangan Pol ma ga atsuraa, “Asaaiti iaa, iu so in Rom?” Pol a xisi ga paare, “Iou, iaa taamat so in Rom.” ");
INSERT INTO ncf_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Mil iwaa lalaamua lot ga paare, “Iaa tii se uuli xaraxin xuxute ngali tsap malen taamat in Rom.” Pol ga xisi, “Oro nugu nagaa tii taxaana iaa malen iaa taamat so in Rom.” ");
INSERT INTO ncf_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Biaa no unmakmaxil di tii taxaaturung ngali atsuraa ma ririiti Pol, di suk isagaa ngali papaalii ia. Iwaa lalaamua lot asuk mataa amuina tii se atiixi we, tii se pitsi Pol, iwaa taamat so in Rom. ");
INSERT INTO ncf_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Leng papan, lalaamua lot a we na tsalei ngalisa so no Jiu di ga atutali no namaang tsaxa sin Pol. O di ga lubati no tsen sin ia ma asaaiti no lalaamua ina no unsausawit ma abia Sanidrin araraa ngali exumule. Mil ga giwaa Pol ngali til laamuaan di. ");
INSERT INTO ncf_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pol a nanen tutiik laa sin abia Sanidrin ma ga paare, “Nugu no taamat, iaa se taxaawiti nugu tinaxaa sin Moroaa taman adodo axaau lalon nugu butsa pupua atalaawaa.” ");
INSERT INTO ncf_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Sin abia iwaa lalaamua ina no unsausawit ila Ananias, a paare sin abia di ta til sangan Pol, ngali tabaii ngutsina. ");
INSERT INTO ncf_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Mil Pol ga paare ngali ia, “Moroaa naba tabaii iu! U mat geramis lokobel oro lalon iu, u se us taman namaang tsaxa. Iu tsotso mu tia ngali ininte susugu sin xan lo Moses, oro iu tsaa, u tabaxi lo sin u ta asaaiti di ngali tabaii iaa.” ");
INSERT INTO ncf_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Biaa di ta tiltil sangan Pol di we “Nangaam paare tsaxa sin iwaa xan unsausawit lapalaa Moroaa!” ");
INSERT INTO ncf_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pol a xisi, “Nugu no taamat, iaa xap nan xilalaa we ia lalaamua ina no unsausawit. Malen di tii se atalaa we, ‘Nangaam paare tsaxa sin xa unbanam ina num no inaman tsaa.’ ” ");
INSERT INTO ncf_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pol a se atiixi malen biexaal ina di no Saadusi ma biexaal no Paarasi. Pol ga xuup laa sin abia Sanidrin, “Nugu no taamat, iaa Paarasi atala ma iaa xan tsi Paarasi. Iaa til nan ininte amuina nugu tinaalnge sin tinapaas mula sin minet.” ");
INSERT INTO ncf_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Biaa Pol ta paatina abala, inemagaae asuk tapaas labatina no Paarasi ma no Saadusi ma biaa kaunsel asuk tsekxirixi sin no xolot ta lua. ");
INSERT INTO ncf_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(No Saadusi di we a xap xa tinapaas mula ma xaa angelo o xaa tanua tsaxa, oro no Paarasi di taltaalnge sin abala no maarang araraa.) ");
INSERT INTO ncf_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Biaa no inaman di suk atapaasi minagaa ma xuupkup. Biexaa unaasasing ina lo biaa no Paarasi di til lapalaa ma di ga paare, “Giem xap tatanginai xawas na tsaxa sin ilawaa taamat. Manaa xa tanua o xa angelo a papaare sin ia?” ");
INSERT INTO ncf_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Biaa inemagaae atapaasi inesas, O lalaamua lot ga suk mataa, di ba soro sas atsoti Pol. A asaaiti xan no unmakmaxil ngali laa lapula ngali giwaa alen ia sin abia di ma ngali laa tali lalon xadi bengbeng no unmakmaxil. ");
INSERT INTO ncf_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Bing papan, Orong a le til sangan Pol, ga we, “U na til watwat, malen iu ta se papaare leng taman iaa tala Jerusalem, iu na laa papaare leng bula taman iaa Rom.” ");
INSERT INTO ncf_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Sin biaa lawaareng, biexa xumul ina no Jiu di ngiti Pol, di se xubatsi sin Moroaa ngali xap angen o nun til sin di ba ta sas amantei Pol. ");
INSERT INTO ncf_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Biexaal bula papan no sangaul aet ina taamat di ngiti Pol. ");
INSERT INTO ncf_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Di laa sangan no lalaamua ina no unsausawit ma no xusaak, ma di ga we, “Giem se xubatsi laa sin Moroaa ngali giem ba xap ngani xawas til sin giem ta se sas amantei Pol. ");
INSERT INTO ncf_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Biaabi talaawaa gim ma abia Sanidrin, gim na ningi lalaamua lot ina no unmakmaxil, ngali naba tali Pol nan no matan Sanidrin ngali gim ba abaa malen gim saan ngali asasing usili xan mamaet. Giem ba taxaaturung ngali sas amantei setauan sin naba ta tsap atala.” ");
INSERT INTO ncf_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Oro biaa xan tsi moton Pol ta alongen abala engit asuk laa lalon xadi bengbeng no unmakmaxil ma ga asaaiti Pol. ");
INSERT INTO ncf_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Mil Pol ga ilei iexa lalaamua ma ga asaaiti, “Giwaa ilawaa tsi xulaau laa sin lalaamua lot; was biaa ngali asaaiti ia taman.” ");
INSERT INTO ncf_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Biaabi ga giwaa ma ga laa tali sin lalaamua lot. Iwaa lalaamua a paare, “Ilaa Pol, iwaa xaus, atsura ngali iaa ngali le tali ilawaa tsi xulaau sangan iu, amuina was biaa ngali asaaiti iu.” ");
INSERT INTO ncf_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Lalaamua lot ga taxaana liman ga laa mii sin gelgel ma ga atsuraa, “U we iu na asaaiti iaa taman sa?” ");
INSERT INTO ncf_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ga paare, “Biaa no Jiu, di se ukbal ngali atsuraa iu ngali giwaa Pol lalon no matan Sanidrin nowa, ngali di ba abaa malen di saan ngali xaa asasing usili ia. ");
INSERT INTO ncf_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Oro, nangaam taalnge sin di amuina a se xudu buxa ngen no sangaul aet ina no taamat biaa di ta man xuxii ngali ia. Di se xubatsi laa sin Moroaa ngali di ba xap angen o nun til di ba sas amantei ia. Talaawaa di se taxaaturung, di liiliisi ngali iu na siir sin xadi ningning.” ");
INSERT INTO ncf_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Lalaamua lot a se tulen laa iwaa tsi xulaau ma ga asaaiti, “Nangaam asaaiti xa, we u se asaaiti iaa taman abala inesaait.” ");
INSERT INTO ncf_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Mil lalaamua lot a ilei xan no lalaamua ta lua ma ga tali no totore sin delulu. A we, “Gim na taxaaturungi no sangsangaul alua ina no unmakmaxil ma no sangaul apaasaalua ina unmakmaxil mii no ors ma no sangsangaul alua ina no unmakmaxil mii xadi no bili. Talaawaa nabing sin nan apaasaaet ina aua di ba tapaas laa Sasaria. ");
INSERT INTO ncf_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Gim na tali bula xa ors sin Pol ngali di ba solen ia ngali naba laa tsap axaau mu sangan Gawana Peliks.” ");
INSERT INTO ncf_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","A atalaa inesaait laa sin Gawana. ");
INSERT INTO ncf_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Xaal sin Kolodias Lisias. Mangmangle xa laa sin Gawana Peliks: Pinaalam ma Resres. ");
INSERT INTO ncf_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ilawaa taamat no Jiu di logotsi ma di ga saan ngali sas amantei. Oro iaa xaalame mii nugu no unmakmaxil ma iaa ga aleiwaa ia, amuina iaa se nanxilalaa we, ia taamat so in Rom. ");
INSERT INTO ncf_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Iaa saan ngali atii, ngalisa di ta atut tali no totore sin, biaabi iaa ga giwaa laangen sangan xadi Sanidrin. ");
INSERT INTO ncf_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Iaa tatanginai we, di atutali mamaxet sin Pol, amuina no atsutsuraa biaa ina xadi lo, oro di atutali ia gomsaa ngali laa sin minet o laa lalon anua lodo. ");
INSERT INTO ncf_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Xa asaaiti iaa we, di ngiti ngali sas amantei iwaa taamat. Sauna mu iaa suk tulen xaalamengen sangaam. Iaa asaait awatwati bula abia no Jiu di ta ngiti ia ngali tali xadi adodo sin iu, ngali sen muina di ta saan ngali sas amantei ia. ");
INSERT INTO ncf_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ma no unmakmaxil di ga se xosaraa puaa xadi tinaxaa malen lalaamua ta asaaiti di. Di giwaa Pol mii di sin abia bing ma di ga le tali Antipatris. ");
INSERT INTO ncf_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Leng papan, biaa no unmakmaxil di ta sosolen no ors di se laa mii Pol Sasaria, o biexaa unmakmaxil di se mula laa lalon xadi bengbeng no unmakmaxil. ");
INSERT INTO ncf_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Biaa no unmakmaxil di se laa tsap Sasaria. Di se tali inesaait sin gawana ma di ga tali Pol sin. ");
INSERT INTO ncf_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gawana a se xoxoti inesaait o ga se atsuraa Pol, “Iu in lalon sen prowins?” A se atiixi, ia taamat in Silisia. ");
INSERT INTO ncf_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Gawana ga asaaiti, “Iaa ba alongen num mamaxet nawe biaa di, di ta atut tali iu di ba xaalame.” Mil ga se tali totore watwat ngali tali Pol lalon xan xariin anua King Erot, ngali no unxoxo di ba tilaamamil sin ia tia. ");
INSERT INTO ncf_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Mil sin no leng ta lima ta se liu, iwaa unsausawit lapalaa, Ananias, a se laa lapula Sasaria mii biexaa xusaak ina no Jiu ma unmalina Tertulas. Ma di ga laa atut tali xirabas sin Pol laamuaan gawana. ");
INSERT INTO ncf_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Biaa di ta se ilei atsigali Pol, Tertulas ga paatina asen xan xirabas Pol laamuaan Peliks. “Giem tii suk papaalam ma man adis lalon malina paina iu ma num adodo axaau labatina no inaman ta puxutsi axaautsi abala inaman labalaba. ");
INSERT INTO ncf_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Sin no xolot araraa ma no sal araraa, ma mangmangle xa sin iu Peliks, giem nan xilalaa abala taman xaraxin taton. ");
INSERT INTO ncf_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Oro ngali u ba xap man adis sin abala xalkale ma ngali alolbiri iu, iaa atsuraa iu, axaau u na ben alongen abala pu inesaait pitpit. ");
INSERT INTO ncf_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Giem se tatanginai malen ilawaa taamat a xaa atapaasi no xirabas ma no epurutsaae labatina no Jiu lalon abala xolkolmoxo araraa. Ia lalaamua ina abia xumul in Nasaret. ");
INSERT INTO ncf_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ma ga xonon ngali tsolaa atsoti Xan Anua Moroaa o giem ga tsiili. ");
INSERT INTO ncf_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Iu tsaa iu na tiirik usili ia ma, iu tsaa u na amusili xan no xirabas, u ba pupua ngali leng axaau sin no maarang biaa giem ta atut tali sin ia.” ");
INSERT INTO ncf_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Biaa no Jiu di tiltsomi Tertulas ma di ga paare we, “Biaa no maarang aso.” ");
INSERT INTO ncf_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Gawana a xosaraa axixila laa sin Pol ngali naba papaare. Pol a xisi ga we, “Iaa atixi malen iu tii ininte sin abala inaman labalaba sin no daan miet, ma iaa ga suk taton ngali tilkaali iaa. ");
INSERT INTO ncf_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Iu pupua ngali atiixi we aso, iaa tii laa lapalaa Jerusalem sin sangaul axuuk ma ga laa lua ina leng ngali langaari. ");
INSERT INTO ncf_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Nugu no matenkorot di xap tatanginai iaa ta emagaae mii xa lalon Xan Anua Moroaa, o atapaasi no epurutsaae mii malep tia o iaa xap atapaasi xaa minagaa lalon anua sausawit o itaa bula lalon inaman laba. ");
INSERT INTO ncf_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ma di xap pupua ngali asoi so sin iu biaa no xirabas di ta atut tali no sin iaa. ");
INSERT INTO ncf_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Oro iaa paare leng we, iaa langaari sin iwaa Moroaa xan nagiem no mom malen xa unaamumusili sal xan Orong, biaa di ta putsangi xumul xaatsap. Iaa taltaalnge sin no maarang araraa, biaa ta ukbal mii lo ma biaa di tii se atalaa xaal sin no propet. ");
INSERT INTO ncf_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Iaa ie tinaalnge bula sin Moroaa malen balawaa no taamat. We, gita ba tapaas mula lalon suu ina minet, mii no untutiik ma no untsaxa. ");
INSERT INTO ncf_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Biaabi iaa ga tigiri xonon ngali adodo axaau lalon nugu butsa we a xap nago xa mamaet nan no matan Moroaa ma no inaman. ");
INSERT INTO ncf_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Mil sin biexaa miet iaa tii xap manman Jerusalem, iaa sebula mula laa ngali tali no tinabel sin nugu no inaman ngali no muunwas ma tali no tinabel laa sin Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Iaa tii amixati iaa, biaa di ta tatanginai iaa lalon bengbeng ina Xan Anua Moroaa, iaa ta xosaraa abala tinaxaa. Tii xap xa xumul mii iaa ma iaa tii xap tsigaii xa engangaae. ");
INSERT INTO ncf_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Oro biexaal ina no Jiu in prowins Asia, di nii tsap laamuaan iu nawe di saan ngali atut tali xaa maarang sin iaa. ");
INSERT INTO ncf_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","O biaa di ta manman atala di na paatinai sen xariin namaang tsaxa di ta tatanginai lalon iaa biaa iaa ta til lalon no matan Sanidrin, ");
INSERT INTO ncf_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","oro nawe xa maarang ta xuuk mu, iaa ta xuup laamuaan di: ‘Biaa iaa ta papaare taman tinapaas mula sin minet biaa iaa ga til lalon ininte laamuaan iu talaawaa.’ ” ");
INSERT INTO ncf_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Gawana Peliks a se atixi axaautsi tsaa abala xan sal Orong, ga se arisi ininte, a se paare, “Nawe lalaamua ina no unmakmaxil Lisias naba xaalame, iaa ba atutiki abala num xirabas.” ");
INSERT INTO ncf_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Asaaiti no lalaamua ngali di na xoxoen Pol lalon bengbeng oro ngali aleiwaai adokdoki ia ma ngali xan no turan di ba pupua ngali tilaamamil sin. ");
INSERT INTO ncf_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Mulina biexaa leng, Peliks tii se xaalame mii xan tubu Darusila, ain Jiu. A tutule ngali Pol ngali naba le longmien ia ta papaare sin, taman tinaalnge lalon Karisito Iesu. ");
INSERT INTO ncf_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Peliks asuk mataa sin Pol ta papaare taman namaang tutiik, namaang ina arongi xalkale ma sin leng ina ininte sin abala xolkolmoxo. A we, “A se pupua ngen atala, poroklii, se laa, nawe iaa tsap sin xa leng axaau, iaa ba sebula tutule ngali iu.” ");
INSERT INTO ncf_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ma ga saan bula ngali Pol na tali xaa xuxute sin ngali ulii xan leiwaa. Ma ga tigiri tutule ngali ia ma ga papaare mii. ");
INSERT INTO ncf_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Amuina a we na atatoni no Jiu, ga papaalii Pol lalon anua lodo. No miet alua a se liu, o ila Porsias Pestas a soro soxisi xan xalkale ina gawana ila Peliks. ");
INSERT INTO ncf_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Mulina no leng ta tuul, a se tsap lalon prowins. Pestas a se laa lapalaa Sasaria ngali laa Jerusalem. ");
INSERT INTO ncf_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Lalon abia xolot no lalaamua ina no unsausawit ma no lalaamua ina no Jiu di tsap sangan Pestas ma di ga atut tali Pol taman xan no asasing. ");
INSERT INTO ncf_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Di atsuraa awatwati Pestas ngali naba tulen mulangenai Pol laa Jerusalem. Amuina di se saage ma xuxii ngali sas amantei Pol lalon sal. ");
INSERT INTO ncf_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Pestas a xisi, “Pol a manman Sasaria ma a xap sauna mu iaa tsaa iaa ba laa atia. ");
INSERT INTO ncf_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Papaalii xaa lalaamua ngali di ba xaalame mii iaa ngali atut tali xaa xirabas sin aia taamat, nawe a xosaraa xaa namaang tsaxa.” ");
INSERT INTO ncf_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Pestas a se manman mii di Jerusalem sin no leng apaasaatuul o sangaul ina leng mii di, ma ga laa lapula Sasaria, ma leng papan a ilei axumuli di ngali niaan xalkale ina ininte ma ga asaait awatwati di ngali di na tali Pol laamuaan ia. ");
INSERT INTO ncf_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Biaa Pol ta se tsap, biaa no Jiu di tii xaalame lapula xaal Jerusalem di suk til ulti ia ma atut tali no totore watwat ngali epuske mii ia, di ba xap pupua ngali asoi no. ");
INSERT INTO ncf_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Mil Pol ga tali no totore sin lolong ngali tilkaali ia. A we, “Iaa xap xosaraa xa namaang tsaxa, biaa ta epuske mii xadi lo no Jiu, o ina Xan Anua Moroaa o Sisa.” ");
INSERT INTO ncf_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Pestas adodo ngali atatoni no Jiu ma ga asaaiti Pol, “U saan ngali laa lapalaa Jerusalem ngali u ba til lalon xonkonon laamuaan iaa, sin abia no xirabas, di ta atuti u taman?” ");
INSERT INTO ncf_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pol a xisi, “Talaawaa iaa til laamuaan xan niaan xalkale Sisa, tiwaa iaa ba til lalon ininte. Iaa suk xap xosaraa xawas na tsaxa sin no Jiu, malen iu tsaa, u suk atik axaautsi. ");
INSERT INTO ncf_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nawe iaa xosaraa xawas puaa lo ta paare we ina met, axaau mu. Iaa xap we iaa palo ngali met. Oro nawe biaa no xirabas, no Jiu di ta atuti iaa taman no, a xap so, asuk xap pupua ngali xa na tali iaa sin di. Iaa atsura ngali til lalon no matan Sisa ngali naba ininte sin iaa.” ");
INSERT INTO ncf_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Mil sin Pestas ta se papaare taman abala mii xan kaunsel. A se paare, “U saan ngali Sisa na ininte sin iu, biaabi sangan Sisa u ba laa!” ");
INSERT INTO ncf_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Mil sin nen leng ta se liu, King Agripa ma Bernis delu se laa tsap Sasaria ngali le lasi ma tali mangmangle sin Pestas. ");
INSERT INTO ncf_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Amuina delu se manman no daan leng tia, Pestas ga papaare mii king taman xan xirabas Pol. A paare we, “Iexa taamat ila, iesan Pol, Peliks tii papaalii ia malen xa xaus. ");
INSERT INTO ncf_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Biaa iaa tii laa Jerusalem, lalaamua ina no unsausawit ma no xusaak ina no Jiu, di atuti Pol taman no totore. Di atsura ngali iaa ba ininte sin ia ngali di na atuti ngali na met. ");
INSERT INTO ncf_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Iaa asaaiti di malen a xap xadi namaang no Rom ngali siir tali xa taamat setauan sin ta xap mager til nan no matan xan no matenkorot ma ga pupua ngali tilkaali ia tsaa ngali epuske mii xadi no xirabas. ");
INSERT INTO ncf_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Biaa di tii xaalame tala mii iaa. Iaa tii xap alilii abia xirabas, oro sin leng papan iaa tii axumuli abia xalkale ina ininte ma iaa ga asaait watwat ngali di na atsigili aia taamat. ");
INSERT INTO ncf_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Biaa xan no matenkorot, di tapaas ma di ga paare. Di xap atuti ia taman xaa xariin namaang morokon iaa ta adodo sin no. ");
INSERT INTO ncf_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Oro xadi no adodo ina engangaae mii ia ngali xadi no namaang no Jiu ma ngali iwaa taamat ta met iesan Iesu iwaa Pol ta paare we a tino. ");
INSERT INTO ncf_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Iaa xap atiixi buxa abala no maarang o iaa ga atsuraa Pol we, ‘U saan ngali laa Jerusalem ngali di ba alongen num no xirabas tia?’ ");
INSERT INTO ncf_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Biaa Pol ta paare we, ‘Iaa na til laamuaan Empora ngali ininte sin ia.’ Iaa paare watwat ngali na manman lalon anua lodo pupua iaa ba ta tulen ia laa sangan Sisa.” ");
INSERT INTO ncf_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Mil Agripa ga paare sin Pestas, “Iaa saan ngali longmien aila taamat iaa xasinge.” A xisi, “Nowa u ba alongmen ia.” ");
INSERT INTO ncf_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Sin leng papan, Agripa ma Bernis delu xaalame taman xariin mirmir ma delu ga tsiga lalon xariin anua xalkale mii no lalaamua ina no unmakmaxil ma no lalaamua ina abia inaman laba. Pestas a paare watwat ngali gii atsigili Pol. ");
INSERT INTO ncf_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Pestas a paare, “King Agripa ma gim araraa no saa, gim ta manman mii giem, gim lasi ilawaa taamat! No Jiu araraa lalon abala inaman laba Jerusalem ma tala Sasaria di atsuraa iaa ngali ia. Di ga xuup papaare, ‘Ilawaa taamat naba xap manman bula sin abala tino.’ ");
INSERT INTO ncf_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Iaa xap tatanginai xawas sin ngali naba met, oro amuina a tali xan atsutsura ngali Empora, iaa ga adodo ngali tulen laa Rom. ");
INSERT INTO ncf_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Oro a xap nugu xawas na leng so ngali atalaa laa sin Empora taman ia. Biaabi iaa ga tali ia laamuaan gim araraa, ma laa bula sin iu King Agripa, ngalibi sin xapkap ina tsatsel, iaa ba pupua ngali atalaa xawas. ");
INSERT INTO ncf_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Sinsa a xap axaau ngali tulen xa taamat, ta manman lalon anua lodo, sin iaa ta xap paare leng taman sen xirabas di ta atutali ia taman.” ");
INSERT INTO ncf_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Mil Agripa ga paare ngali Pol, “U pupua ngali papaare ngali iu tsaa.” Pol ga xosaraa axixila taman liman ngali putsangi axaau ma asen mangmangle xa ma ga atiltsoli ngali paare xaali ia. ");
INSERT INTO ncf_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“King Agripa, iaa atik axaautsi iaa tsaa, iaa ga taton ngali til laamuaan iu talaawaa ngali paare xaali iaa sin abia xirabas no Jiu di ta atut tali sin iaa. ");
INSERT INTO ncf_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Malen u atiixi axaautsi xadi namaang no Jiu ma biaa no maarang di ta paare xuduxudu taman. Biaabi iaa ga ningi iu ngali u ba xale adamis ma u na alongen iaa. ");
INSERT INTO ncf_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“No Jiu araraa di suk atixi nugu namaang ina tino sin atiltsoli iaa tii tsixi dokdok tsaa lalon nugu inaman labalaba tsaa ma Jerusalem bula. ");
INSERT INTO ncf_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Di tii se atiixi iaa tii tsaa ma nawe di siir, di pupua ngali paare leng taman iaa, we iaa tino malen xa Paarasi, iaa amusili axaautsi abia xida lo ina taltaalnge. ");
INSERT INTO ncf_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","O talaawaa amuina sin nugu liliis taman tinaalnge lalon sawe Moroaa ta se xubatsi laa sin nagiem no iaaiaa, ma talaawaa iaa se til nan ininte. ");
INSERT INTO ncf_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Balawaa xuxubu ngali xida sangaul ma ga laa lua ina matenbung, di liliis taman tinaalnge ngali lasi naba ta tsap, malen di ta watwat ngali taxaa laa sin Moroaa lasiaat ma nabing. O king, amuina sin abala liliis taman tinaalnge we no Jiu di tii ga atuti iaa taman abala no totore. ");
INSERT INTO ncf_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ngalisa biexaal ina gim di ta adodo we, gim xap pupua ngali taltaalnge we Moroaa naba atapaasi no minet? ");
INSERT INTO ncf_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Iaa se taltaalnge watwat bula we, iaa xosaraa no maarang araraa biaa ta pupua ngali esas epuske mii iesan Iesu in Nasaret. ");
INSERT INTO ncf_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","O biaa mu namaang biaa iaa tii xosaraa Jerusalem, sin xadi banam no lalaamua ina no unsausawit iaa ga tali xan no inaman Moroaa lalon anua lodo, ma biaa di tii se met araraa, iaa ukbal mii abia adodo. ");
INSERT INTO ncf_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Xuduxudu ina no leng iaa xaa laa sin no anua sausawit, ngali asosongi di ma atuaai di ngali paare tsaxa ngali Iesu. Lalon nugu minagaa ngali di, iaa xaa laa sin biexaa inaman laba palpalaa ngali tsalei ma asosongi di. ");
INSERT INTO ncf_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Sin biexa ina nugu no ines, iaa tii ga laa Damaaskas, taman banam ma xadi tinaxaa abia no lalaamua ina no unsausawit. ");
INSERT INTO ncf_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","A se laa ngali siaat papan talupiak, nugu King Agripa, o biaa iaa ta eses lalon sal, iaa ga lasi tsilatsila axaal balalangit, a tsila buxa ngen tsilatsila ina matanios, a xaalame ma ga tsila ulti iaa mii biaa no taamat di ta arie eses mii iaa. ");
INSERT INTO ncf_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Giem xol laa lapula papan pula ma iaa tii ga alongen inan xa ta paare ngali iaa sin totore in Ibru, ‘Sol, Sol, ngalisa iu ta esas mii iaa? U asosongi iu tsaa sin u ta sas epuske mii iaa.’ ");
INSERT INTO ncf_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“O iaa ga atsura, ‘Saa iu, Orong?’ “Orong a xisi, ‘Iaa Iesu, iwaa mu iu ta taxaa sin lo xosor atsoti. ");
INSERT INTO ncf_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Talaawaa u na til lapalaa taman no xaiim. Iaa se asemat sin iu ngali axilangi iu malen xa untutule ma xa untiltsoxoti ngali sawe u ta se lasi sin iaa ma senaara iaa ba asen sin iu. ");
INSERT INTO ncf_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Iaa ba aleiwaa iu sin num no inaman tsaa ma sin no Gentail. Talaawaa iaa tulen iu laa sangan di. ");
INSERT INTO ncf_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Ngali u ba tsalali no matan di ma ngali di ba puxutsi xadi no namaang ta lodo ngali xaalame sin leng, ma ngali di ba taaltalu sin xan banam Saatan ma di na xaalame sin Moroaa ngalibi xadi no namaang tsaxa Moroaa naba adodolii ma di ba man labatina no inaman pat amuina sin xadi tinaalnge sin iaa.’ ");
INSERT INTO ncf_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“King Agripa, iaa suk long axaautsi abala binalang nanen xaal balalangit ma iaa ga suk amusili araraai. ");
INSERT INTO ncf_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Setauan iaa atiltsoli baais taman abia totore Damaaskas, ma laa Jerusalem ma laa sin no xolot araraa Judaia, ma laa sin no Gentail bula, ma iaa ga baais ngali di na puxisbal ma xaalame sangan Moroaa ma di na asen so xadi no puxisbal taman xadi no tinaxaa. ");
INSERT INTO ncf_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Sin abia muina, no Jiu di tii ga tsiili iaa lalon Xan Anua Moroaa ma di ga xonon ngali sas amantei iaa. ");
INSERT INTO ncf_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Oro Moroaa tii tiltsomi iaa xaal tii a le pupua sin abala leng, ma talaawaa iaa ga asaait alengi laa sin no iewas ma no muunwas. Iaa xap asaait taman xaa was ngen papan samaarang no propet ma Moses di tii se asaait taman biaa naba ta tsap. ");
INSERT INTO ncf_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Di we Karisito naba alet sosong, ma ia nan axuuk setauan naba tapaas mula lalon suu ina minet, ma naba babaais taman inesaait mamainaang malen laleng laa sin xan no inaman tsaa ma no Gentail.” ");
INSERT INTO ncf_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Sin abala xolot, Pestas axitipi xan papaare Pol. Pestas ga pirares ngali ia, “U se tangtangabaa, num xaraxin sinaae atangtangbaai iu.” ");
INSERT INTO ncf_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Oro Pol ga xisi, “Pestas, iaa manglen num xalkale lapalaa, iaa xap tangtangabaa atala. Senaara iaa ta paatina aso ma a ie muina. ");
INSERT INTO ncf_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","King Agripa atik axaautsi abala no maarang, ma iaa pupua ngali papaare mii ia ma iaa ga xap mataa. Iaa taalnge we a xap xawas na xuxii sin ia amuina di xap xosaraa lalon tsigur.” ");
INSERT INTO ncf_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Pol atsuraa King Agripa, “U taltaalnge bula sin no propet? Iaa atii u taltaalnge!” ");
INSERT INTO ncf_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","King Agripa ga paare ngali Pol, “Sin abala aua ta pitpit mu u we, u pupua ngali adaani iaa ngali iaa ba tsap untaltaalnge?” ");
INSERT INTO ncf_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pol a xisi, “Nawe a pitpit o a disdis abia leng, iaa sausawit laa sin Moroaa a xap ngali iu mu oro ngali abia di xuxuuk di ta lolong sin iaa talaawaa, ma di ba tsap malen iaa. Oro a xap ngali abala no tsen.” ");
INSERT INTO ncf_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Mil King Agripa ga tapaas, mii Gawana Pestas, Bernis ma biaa no inaman di ta xalkale mii di, di til lapalaa. ");
INSERT INTO ncf_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","O biaa di ta se papaalii xabin, di paare engen di, “Ilawaa taamat a xap xosaraa xawas na tsaxa ngali na met o na laa lalon anua lodo.” ");
INSERT INTO ncf_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripa a paare ngali Pestas, “Gita nii se aleiwaai ilawaa taamat nawe nii xap atsuraa Sisa ngali ininte sin xan xirabas.” ");
INSERT INTO ncf_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Mil di tii ga se adodo ngali giem ba se tuut papan mono laa Itali. Di ga gii tali Pol ma biexaa xaus laa sin Julias iwaa lalaamua ina no unmakmaxil, di putsangi di xan no unmakmaxil Sisa. ");
INSERT INTO ncf_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Giem se pis xaa papan mono xaal Adaramitam biaa ta se taxaaturung ngali laa lalon no matanang xuen lalon prowins Asia ma giem ga tuut laa lau. Aristakas, ia taamat in lalon prowins Masedonia axaal nan inaman laba Tesalonika a xaalame mii giem. ");
INSERT INTO ncf_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Leng papan, giem se laa tsal Sidon ma ilaa Julias ga titii Pol ma ga sirawaa ia ngali naba laa sangan no turan ngali di ba tabali ia sin ta muun. ");
INSERT INTO ncf_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Xaal atia, giem ga tuut laa lau sebula ma giem ga tuut xaatalaa ta malina ina ienusa Saipras, amuina maal watwat tii sabasue giem. ");
INSERT INTO ncf_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Biaa giem ta se tuut tabaxi laman xuen Silisia ma Pampilia o giem ga se laa tsal lalon inaman laba Mira lalon abia prowins Lisia. ");
INSERT INTO ncf_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Tiwaa, iwaa lalaamua ina no unmakmaxil atatanginai biexa mono in Aleksendia ta tuut laa Itali, ga se tali giem papan abia mono. ");
INSERT INTO ncf_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Giem tuut adamis sin abia no daan leng, ma ga suk lelep ngali tsap Kinidas. Biaa maal watwat tii sabasue giem, giem ga xap pupua ngali tuut tsutsup sin abia sal, o giem ga se tuut lalon malina xaatalaa nan no paxel ina ienusa Kirit biaa ta nanen laa sin ienusa Salmone. ");
INSERT INTO ncf_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","A suk lelep sin giem ngali tuut amusili abia xuen lalon abala ines ma giem tii ga se le tsap lalon xolot di ta putsangi Matanang Axaau atataen inaman laba Laisia. ");
INSERT INTO ncf_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Giem se araraai gomsaai no leng ma biaa ngali tuut laa a se tsaxa buxa amuina talaawaa giem se liwaa no leng ina el, biaabi Pol ga atewaai di. ");
INSERT INTO ncf_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“No taamat, iaa lasi weaatalaa balawaa xida ines naba tatanginai xa xirabas ma naba tsaalen mono mii no maarang papan ma xida no tino tsaa bula.” ");
INSERT INTO ncf_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Oro iwaa lalaamua ina no unmakmaxil ta laa mii Pol a xap longmien semaarang Pol ta paatina, oro ga suk lolong amusili xan adodo tietieʼie ina mono ma tapkina mono. ");
INSERT INTO ncf_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Sinsa biaa matanang a xap axaau ngali manngi teslaxum biaabi xuduxudu di ga adodo ngali tuut laa tsaa ngali tatanginai Pinix ma di na manngi teslaxum atia. Balawaa matanang in Kirit, biaa ta nanen laa nan no paxel mii nan tudaan ma nan no ruu mii nan tudaan. ");
INSERT INTO ncf_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Biaa nan pu maalwi nan no paxel ta atiltsoli ngali maal, di ga se adodo malen biaa se pu maalwi nano paxel di ta saan ngali. Biaabi di ga te a engen aga ma di ga tuut amusili xuenkuen ina ienusa Kirit. ");
INSERT INTO ncf_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Oro sauna mu xariin maal buxa nan no ruu mii maal nan selina a soriri xaal papan ienusa. ");
INSERT INTO ncf_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Maal a le maalen tsaxali mono ma ga suk laa taman, Ma mono ga se xap pupua ngali tuut sabasue maal. Giem suk papaalii mu ma ga amusili xan maalwi maal. ");
INSERT INTO ncf_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Biaa giem ta se tuut laa nan no paxel ina ienusa dokdok di ta putsangi Kauda. Tii suk lelep ngali te a engen ma pis ariti abia mono dokdok. ");
INSERT INTO ncf_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Biaa no taamat di ta a engen mono dokdok lapalaa papan mono, di a xaa ngen no sua paina mono ngali rosaariti ma taxaariiti. Biaa no taamat di suk mataa sin mono naba xotso xuen papan xenken Sirtis. Biaabi di ga aririi xan aga mono ngali alilii ma ga laa mii maal. ");
INSERT INTO ncf_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Biaa xaraxin maal atapaasi no paar ma ga tuti mono biaabi sin leng papan, di ga atiltsoli lii laa lau biexaa was papan mono. ");
INSERT INTO ncf_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Sin nanaatuul ina leng, di lii laa lau biexaa xolkolot ina mono taman no liman di tsaa. ");
INSERT INTO ncf_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Sin abia no leng, giem xap muun lasi matanios ma no xadaxada. Biaa xariin maal mii langit a lo asumaa ma giem ga xap taalnge we giem ba tino bula. ");
INSERT INTO ncf_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Mulina no daan leng no taamat di tii xap ngani xaa pu luxaal, Pol ga til lapalaa laamuaan di ma ga asaaiti di, “No taamat, nawe gim nii se longmien nugu inanaa ma gim na xap tuut poroklii Kirit biaa xariin maal tsaxa mii langit nii xap atsoti mono ma gim nii xap xosorlii no maarang lau. ");
INSERT INTO ncf_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Oro Talaawaa iaa ningi gim ngali gim na tilwatwat, amuina xa ina gim naba xap met. Mono mu naba lulus. ");
INSERT INTO ncf_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Torongonol nabing xan angelo Moroaa iwaa nugu sin saa iaa ta taxaa ngali, a til sangaaga. ");
INSERT INTO ncf_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","A we, ‘Pol nangaam mataa. U ba suk til lalon ininte laamuaan Sisa. Ma lolong, Moroaa taman xan amiimiilam a se tali sin iu, xadi no tino araraa abia di, di ta tuut mii iu.’ ");
INSERT INTO ncf_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Biaabi no taamat, gim na tilwatwat, amuina iaa ie tinaalnge lalon Moroaa ngali naba tsap malen abia ta se asaaiti iaa taman. ");
INSERT INTO ncf_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Oro gita ba xotso tsaa xuen papan xa ienusa.” ");
INSERT INTO ncf_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Sin sangaul axuuk ma ga laa et ina bing, giem lo bebe tsaa mii maal tabaxi laman Adriaatik, o sin labatina bing se, biaa no untutut papan mono di se saaen malen a se xaalame atat ngali xotso xuen. ");
INSERT INTO ncf_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Di ga adi sua ta mamaxet sin barangutsina ma di ga lii laa lapula lalon daan. Di tatanginai we, biaa riri ina daan laa lapula paina mono a pupua malen no sangaul aet ina mita. Mil sebula di tatanginai riri ina daan a pupua malen no sangaul a tuul ina mita. ");
INSERT INTO ncf_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Giem suk mataa we giem ba soro tigen xaa xaat. Di ga aririi no aga aet mulina mono, laa lapula ma di ga sausawit ngali na tampanek. ");
INSERT INTO ncf_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","No untutut papan mono di se saan ngali sol loxono mono. Di aririi no mono dokdok lapula lalaman. Di dare ngali aririi biexaa aga lapula laamuaan mono. ");
INSERT INTO ncf_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pol ga se paare ngali lalaamua ma no unmakmaxil, “Nawe balawaa no taamat di na xap manman papan mono gim ba xap pupua ngali tino.” ");
INSERT INTO ncf_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","No unmakmaxil di riit xitipi no sua biaa ta taxaana mono dokdok ma di ga papaalii ga suk xol laa lalaman. ");
INSERT INTO ncf_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Biaa ta xap mager tampanek Pol ga ningi di araraa ngali angen. A paare, “Sin abia sangaul ma ga laa et ina no leng, gim lolbiir ma gim tii ga xap muun ngani xaa pu luxaal. ");
INSERT INTO ncf_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","O talaawaa iaa ningi gim ngali gim na ngani xaa pu luxaal ngali atuturi gim. Na ba xap xa ina gim naba xosorlii xien uul ina xan xuan.” ");
INSERT INTO ncf_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Mulina ta se paatina abala, Pol adi biexaa tsoki ma ga putsangi axaau sin Moroaa laamuaan di se araraa. Mil ga tsabaxi ma ga ngani. ");
INSERT INTO ncf_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Xan no totore anaai di ma di tsaa, di ga ngani biexaa luxaal. ");
INSERT INTO ncf_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Biaa di araraa papan mono di pupua malen 276 ina giem. ");
INSERT INTO ncf_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Biaa di ta se xap sin angen araraa, di lii no xiis wit laa lalaman ngali amololoi mono. ");
INSERT INTO ncf_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Biaa ta se tampanek di xap nen xilalaa abia ienusa. Oro di lasi biexa matanang mii xenken xuen. Ma di ga se adodo ngali axotsoi mono atia nawe di pupua. ");
INSERT INTO ncf_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Di xitiplii no aga ma di ga poroklii no lalaman, tiwaa tsaa di ga lubalii sua biaa ta taxaariti no es. Mil di ga taii laangen sal laa laamuaan mono ngali maal naba maalen laangen xuen. ");
INSERT INTO ncf_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Oro biaa mono a xotso papan banaai xenken. Laamuaan mono asuk laa tupa wat sin xenken ma ga xap pupua ngali giis ma biaa mulina mono ga tabek sin no xolkolot sin no paar ta lo tiktigen. ");
INSERT INTO ncf_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","No unmakmaxil di ngiti ngali sas amantei abia no xaus ngali tilkaali di ngali di na xap suaal laa xuen ma sol loxona di. ");
INSERT INTO ncf_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Oro iwaa lalaamua Julias a saan ngali di na papaalii Pol na tino biaabi ga tilbanti di ngali di na xap sas amantei no xaus, Oro a tulen abia di ta pupua ngali suaal di na pis setauan laa lalaman ngali suaal laa xuen. ");
INSERT INTO ncf_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Biexaal di ba xaa papan no xupaap o papan no pu xolot ina mono. Sin abia sal di araraa di ga laa tsap axaau xuen. ");
INSERT INTO ncf_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Giem se tsap axaau mu xuen o giem ga tatanginai we, biaa ienusa di putsangi Maalta. ");
INSERT INTO ncf_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Biaa no inaman papan abia ienusa di sabasue giem taman namaang ta suk axaau buxa. Di taangi ie ngali giem amuina langit ausa ma tii se tso sin madil. ");
INSERT INTO ncf_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pol ga se laa papat ma ga aturungi no pu aia papan ie suaamsuaam ma tsitsi tsaxa ga lotsul lalon ie ta alapa ma ga suk ulsi liman Pol. ");
INSERT INTO ncf_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","O biaa no inaman papan abia ienusa di lasi tsitsi tsaxa ta taxiu sin liman Pol ma di ga paare engen di tsaa “Manaa ilawaa taamat ia unsasas, amuina a xap met lau, oro moroaa ina Ininte a xap sirawaa ngali na tino.” ");
INSERT INTO ncf_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Oro Pol a uraalii tsitsi sin liman laa lalon ie. A xap muun saaen xa xolot na tsaxa sin liman. ");
INSERT INTO ncf_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","No inaman di suk adodo watwat malen no isuaan naba ting o naba met. Oro mil di ta se liliis adis ma di ga xap lasi xawas na tsap sin Pol, di puxutsi xadi no adodo ma di ga paare, “Ia xa moroaa.” ");
INSERT INTO ncf_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ma atataaen abia xobel, biaa xan uma iexa taamat lot iesan ila Pubilias tii manman atia. Tii iexa ina no unbanam papan abia ienusa. A suei atatoni giem laa tatan ma ga tilaamamil axaau sin giem sin no leng ta tuul. ");
INSERT INTO ncf_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Xan mom Pubilias a maramase ma ga matmatuul papan ibe taman minet isua lelep ma sodal. Pol a se es tsiga ngali lasi. Aturungi no liman papan ma ga sausawit o iwaa taamat ga suk tuo. ");
INSERT INTO ncf_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Biaa di ta lasi abala maarang tii tsap, biaa no minet araraa papan ienusa di tii xaalame sangan Pol ma ga atoaa di. ");
INSERT INTO ncf_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Di manglen giem sin no daan laxen sal o biaa giem ta se taxaaturung ngali tuut di se tabali giem taman no daan tinabel giem ta saansili papan mono ngali nagiem ines. ");
INSERT INTO ncf_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Mulina no uleng ta tuul, giem se tuut papan mono biaa ta manman Maalta sin teslaxum papan abia ienusa. Xadi mono no Aleksendia in Igip. Laamuaan abia mono no malagan alua a til axilangi lo xatsang moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Giem tsap Sirakus ma giem ga manman tia no leng a tuul. ");
INSERT INTO ncf_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Giem xaal atia ma giem ga tuut laa tsap Regiam. Sin leng papan maal nan no paxel a sebula tapaas o sin biexa leng giem se tsap Puteoli. ");
INSERT INTO ncf_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Lalon abia xolot giem tatanginai no untaltaalnge, di ningi giem ngali laa manman mii di sin wik ta xuuk. Giem tii ga se tapaas atia ma giem ga atiltsoli ngali eses laa Rom. ");
INSERT INTO ncf_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Biaa no untaltaalnge tia di ta alongen we giem xaalame, di ga xaalame ngali le sabasue giem lalon sal xaal lalon abia no xolot ina susune sin Apias, ma biaa xolot di putsangi, “A Tuul No Anua Iaawis.” Pol a lasi abia no untaltaalnge di tii ga suk awatwati ia ma ga putsangi axaau laa sin Moroaa. ");
INSERT INTO ncf_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Giem se laa tsap Rom o Pol ga se pupua ngali man ia tsaa mii xa unmakmaxil ngali xoxo sin ia. ");
INSERT INTO ncf_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Mulina no leng ta tuul, Pol a ilei axumuli no lalaamua ina no Jiu. Biaa di tii se exumule sangan Pol o ga asaaiti di, “Nugu no taamat, iaa xap xosaraa xawas na tsaxa ngali xida no inaman, o iaa xap xosaraa xawas na tsaxa sin xadi namaang xida no iaaiaa. Di tii tsiili iaa Jerusalem ma di ga tali iaa sin no Rom. ");
INSERT INTO ncf_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Mil biaa no Rom, di ta se ininte sin iaa, ma di xap tatanginai xawas na tsaxa sin iaa ngali ina met. ");
INSERT INTO ncf_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Oro no Jiu di paare xuduxudu sin abala totore, biaa iaa ga xap nanen ngali xa sal xaatsap. Iaa atsuraa Sisa ngali naba atutiki nugu ininte. Oro a xap nago xa xirabas ngali epuske mii nugu no inaman tsaa. ");
INSERT INTO ncf_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ngali abala muina, iaa tii ga atsura ngali le lasi gim ma ngali totore mii gim. Amuina sin xadi liliis taman tinaalnge no Israel sin Karisito, biaa di tii ga pitsi iaa taman abala tsen.” ");
INSERT INTO ncf_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Di xisi, “Giem tii xap adi xa inaatel xaal Judaia taman xa totore ina iu. Ma a xap xa ina abala nagiem no taamat di ta xaal tia ma di na paatinai xawas na tsaxa ina iu. ");
INSERT INTO ncf_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Oro giem saan ngali alongen num adodo amuina giem atii we sin no daan xolot, no inaman di paare epuske mii abia xumul xaatsap.” ");
INSERT INTO ncf_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ma di ga se xubatsi leng ngali sabasue Pol, ma no daan inaman di xaalame lalon abia xolot ta manman tia. Atiltsoli lawaareng ma ga laa bing, alengi ma baais sin di taman xan Maradaan Moroaa, ma ga xonon ngali adaani di ngali taalnge sin Iesu sin xan lo Moses ma xadi no inaatel no propet. ");
INSERT INTO ncf_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Biexaal ina no Jiu di taltaalnge sin no semaarang Pol ta paare taman oro biexaal ina di xap taltaalnge. ");
INSERT INTO ncf_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Di xap uk bal labatina di tsaa, mulina xan xapkap ina totore Pol, di tapaas papaalii ia, ga paare, “Nantanua Pat a paare taman soina sin nagim no iaaiaa, biaa ta paare sin Propet Aisaia, ");
INSERT INTO ncf_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","“ ‘Laa sangan abala no inaman ma iu na asaaiti di, “Gim ba lo lolong oro gim ba xap leng, gim ba lo nanen oro gim ba xap nen xilalaa xawas.” ");
INSERT INTO ncf_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ngali xadi no butsa abala no inaman, a se watwat, di banti xadi no talingan ngali lolong, ma di tii ga a urange no matan di. Oro di ba soro nanen taman no matan di, di ba soro lolong taman no talingan di, naba leng lalon xadi no butsa, ma di ba puxisbal ma iaa ba atoaa di.’ ");
INSERT INTO ncf_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“Biaabi, iaa ga saan ngali gim ba atiixi malen biaa xan atotoaa Moroaa a se tulen laa sin no Gentail, ma di ba lolong.” ");
INSERT INTO ncf_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Mil Pol ta paatina abala, biaa no Jiu di poroklii ia ma di ga engangaae labatina di tsaa lalon sal. ");
INSERT INTO ncf_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pol a manman atia sin no miet ta lua lalon abia xan anua tsaa, ta xaa uuli sin tapkina anua ta manman lalon. Ma ga xaa suei atatoni biaa di araraa di tii xaa le lasi ia. ");
INSERT INTO ncf_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Pol a xap mataa ma a xap xa na tilbanti ia ngali baais taman xan Maradaan Moroaa ma ngali asingan no inaman taman Orong Iesu Karisito. ");
INSERT INTO ncf_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Iaa, Pol xan untutule Iesu Karisito. Tii ilei iaa ngali tsap xa aposal, ma ga axilangi iaa ngali baais taman xan inesaait mamainaang Moroaa. ");
INSERT INTO ncf_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Tii xubatsi abala inesaait mamainaang ti laamua tsaa sin xan no propet lalon abia inaatel pat. ");
INSERT INTO ncf_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Biaa ta papaare taman xan tsi, iwaa ta tsap malen taamat toto, di taxaana ia sin xan matenbung Dewit. ");
INSERT INTO ncf_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Oro Moroaa alengi we, Iesu Karisito, xida Orong ia xan tsi Moroaa, biaa tii atapaasi mulangen sin minet taman xan xoror Nantanua Pat. ");
INSERT INTO ncf_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Gita se adi abia tinabel ina amiimiilam sin ia ma tinaxaa ina aposal ngali baais taman inesaait mamainaang laa sin no Gentail araraa, ngalibi di ba taltaalnge sin ia ma amusili ia ma di na alet alabati iesan. ");
INSERT INTO ncf_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Gim bula, gim man labatina abia no Gentail, biaa Moroaa tii se ilei gim ngali tsap xan no inaman Iesu Karisito. ");
INSERT INTO ncf_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Balawaa inaatel a laa sin gim araraa Rom, biaa inaman Moroaa ta titii di ma ga ilei di ngali tsap xan inaman pat. Iaa sawit we Moroaa xida mom ma Orong Iesu Karisito naba tali biaa amiimiilam ma malina sin gim. ");
INSERT INTO ncf_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Setauan, iaa we ina putsangi axaau sin nugu Moroaa lalon Iesu Karisito ngali gim araraa, amuina nagim no tinaalnge a paare leng lalon xolkolmoxo ina inaman araraa. ");
INSERT INTO ncf_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Moroaa atiltsoxoti iaa, ngali iaa ta xosaraa xan tinaxaa amusili abia inesaait mamainaang ina xan tsi taman nugu tino araraa. Moroaa atii we, senaara iaa ta paatinai, aso: biaa iaa ta xap muut sin putputsangi gim, sin nugu no sausawit. ");
INSERT INTO ncf_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Sin nugu sausawit, iaa tigiri atsura we, nawe sin xan sirsiir Moroaa, talaawaa, iaa ba pupua ngali xaalame sangan gim. ");
INSERT INTO ncf_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Amuina iaa suk saan buxa ngali lasi gim, ngali iaa ba pupua ngali asing tali xaa tinabel ina nantanua biaa naba awatwati nagim tinaalnge, ");
INSERT INTO ncf_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ngalibi, gita ba pupua ngali anaai engen gita lalon xida no tinaalnge. ");
INSERT INTO ncf_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Nugu no taamat ina tinaalnge, iaa saan ngali gim na atii we iaa tigiri adodo ngali xaalame sangan gim, ngalibi iaa ba pupua, ngali paaski xaa waawaan labatina gim, malen mu iaa tii xosaraa, labatina no Gentail. Oro iaa tii xap pupua ngali xosaraa amuina biexaa maarang a tigiri tilbanti iaa. ");
INSERT INTO ncf_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Nugu tinaxaa se ngali baais sin no inaman araraa ngali no Grik ma no inaman xuul, ma laa arie sin no unsinaae ma no tangtangabaa. ");
INSERT INTO ncf_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Biaabi iaa ga suk saan buxa ngali baais taman inesaait mamainaang laa sin gim bula, gim ta manman Rom. ");
INSERT INTO ncf_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Amuina iaa xap mangiel taman abala inesaait mamainaang ina Iesu Karisit