﻿USE sofia;
DROP TABLE IF EXISTS sofia.nce_vpl;
CREATE TABLE nce_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nce_vpl WRITE;
INSERT INTO nce_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","2","Jekop na bubë nëbalebë anebo gali melëgëbetëme lalële. Jekop Kenan life mëta mana tafa tle. Ëtani bolijaya kë life mëta tafa tle. Na Jekopbë nëba Josep, bu falake ho, na bu 17 tlibutu këniji watle. Na këbë hona bolijahanina bolijayabë sipsip klelina mëmë klelina li li ona mëta mëtlëwagukefëma. Na Bilha na Silpa bu Jekopbë fli one. Na kë tlemalë one bu Josep bolijahanibë botamenino. Na Josep bolijayame gali tujuwelikefle, “Afani sipsip kleli mëglëma sle hana mla.” ");
INSERT INTO nce_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Na Jekop, bubë li weniji Israel, bu hoti tafa tëglena, bubë mëse Josepme mana fata totle. Na bume tako tole këme tletle na kwe bubë fli bowenenime tokwëfo tolewa latletëme. Na bu ëho lalemu susu totle na Josepme tlële. ");
INSERT INTO nce_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Na Josepbë bolijahani bolijayabë lowene hwi motlotla na bu melowene mëtla, “Aya Josepme fwa feilawa sle lotlefe na kwe seme mesle hana lëtana.” Na këme nëgeme bu Josepme tëboijiwamu këme mëtletla na bu Josepme lale lale gali hana motlola. ");
INSERT INTO nce_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","Na Josep nimitelë hwi tle na bolijahanime gali tlome, “Bo nimitelë gali të nëtatëyo. Sebo nuju mago wesibi kë lalei notomabë na kwe bobë witi hi wesibi leitabo lahujuwa mële na sobobë witi hi wesibi leitabo bobëme lasabuwa motome, na bobëme labubusuwa mëtletëme, eso home fene bubusu mëtletle.” Na bu kë nimitelë gali yafe aholokwane mëtla na bu Josepme tëboijiwamu mëtletla. ");
INSERT INTO nce_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Na bolijahani gali motlola, “Ju melowene lalene? Sebobë eso ho tafa naegletënamene?” Na kë nimitelë gali aholokwane motlola, na bu këme enisusu mëtletla. ");
INSERT INTO nce_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Na tokwafe Josep li nimitelë hwi tle. Na bolijahanime ita të tëtatëme. Bu megali tlome, “Bo li nimitelë mehwi nelë. Na bo klijina, yemena, sigetobana we ita jwa këniji mehwi nanolomë. Na bome bubusu mëletenë.” ");
INSERT INTO nce_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Na bu kë nimitelë gali bolijayame mata të tëtatle. Na bolijaya tako wame metlole na gali tlole, “Kë habëtabo nimitelë gali të etolene? Ju melowene lalene? Sebo bitana blijahaninona sëkefo miti bubusu nanëgletëyomene?” ");
INSERT INTO nce_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Na Josep bolijahani bume tëboijiwa motlola na bume tëbo lowene fa mëtëtatla. Kwe bolijaya kë nimitelë gali mana lowene tokoukefëtle. ");
INSERT INTO nce_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Tokwafe Josep bolijahani Sekem lifewa mititiya, bolijayabë sipsip kleli mëglëwagukefëma namëglame. ");
INSERT INTO nce_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Na Jekop Josepme gali tlole, “Ju walowene eletëme. Blijahani sipsip kleli Sekem life li mëta kë mëlëma. Bo jume bu belë jine nëgelëkakëme.” Na Josep gali tafu tëtatle, “Wo, nogowimefe.” ");
INSERT INTO nce_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Bolijaya gali tlole, “Blijahanime hwi eujuwelëmeme, lalowa tafa mulane? Na sipsip kleli na mëmë kleli mata hwi elomeme, lalowa milibene o hanane. Na bome gali elëfanëme.” Na Jekop bume Hebron life mago jine tlële. Na Josep tugujubëë na Sekem lifewa, fwa tule. ");
INSERT INTO nce_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Na bubë bolijahaninome hohwi tëtagutëme. Na ho li bume hwi telokwakle na tuju tle na gali tlole, “Ju fëye wesibi hohwi etatlene?” ");
INSERT INTO nce_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Na Josep bume megali tlole, “Bo bobë afaninome hohwi nëtatemëyo. Ju bome lalowa gali eglonëmene? Bu sipsip kleli na mëmë kleli fëye life mëta mlëmane?” ");
INSERT INTO nce_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Na kë ho gali metafu latëtatle, “Ebë life wakile mëtla. Bo bume waaholokwane tlomë. Bu megali lamëtla, ‘Te manuja. Totan lifewa.’ ” Na Josep bume Totan lifewa esogo tlagume na hwi telokwakëme. ");
INSERT INTO nce_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Na bu kakëwa asë tëkeke, na bolijahani bume mana hwi mëtelëkakla. Na bu blalo gëgali mëtla, bume mogo nalë tëkle namogotlame. ");
INSERT INTO nce_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Na gali mëtla, “Nimitelë tëgeijilawaho kë lisiyo. ");
INSERT INTO nce_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Te mogo nalë tëkle nogotlabëme mana sagli manëlëtla. Mogo nalë tëkle notlame na mogo tako flujuwa tuku nëtëkakame. Na bubë nimitelë gali fata hana lëgletleme. Na tokwafe ayame sogëna nololame, ‘Waluju mago kleli watëkle totle.’ ” ");
INSERT INTO nce_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Na kwe Ruben kë gali aholokwane tlome na Ruben, Josepme lëgaitalebeme lowene hohwi tëtatle, na megali tlome, “Asa tëkle manotla, matëbe. ");
INSERT INTO nce_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Sebo bume ona mago yefi tu fuluju elë fwa tuku manëtëkaka.” Ruben bu melowene latle, “Tokwafe bo bume fuluju mago ki nokokëme na aya belë jine nelëkaklëme.” ");
INSERT INTO nce_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Na Josep bolijahani belë fowa tëkaki. Na bubë lale ëho bolijaya kë susu tëgëtatlebë latohwawa mëtëtatla. ");
INSERT INTO nce_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Na bume fa mototla na tu jwa yefi tu fuluju elë tuku mëtëtëkaka. Na Ruben li sloslowa tle. ");
INSERT INTO nce_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Fe mëtëkaka na tafa mëtla. Na hi wesibi hi mëtëglabëë na Ismael enëneme hwi mëtelëkakëma, Gileat life mago mitisiya. Na bubë kamel kleli, lale lale lëkaluna wesibi na fli wesibi baliti tatakona kë glo mëglabë na kahalu tiha wesibi, Isip lifewa mëtëmalitama, baliti këna glo namëglame. ");
INSERT INTO nce_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Na Juda bolijamonime gali tlome, “Sebo Josepme mogo nalë tëkle nogotlana, kwe seme kë wesibi habelë lëgaitanamene. Tëkle asa manotla. ");
INSERT INTO nce_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Sebo bume Ismael enëneme baliti sëneme yo manoloma baliti këna glo nanëglame. Sebo bume tëkle hana nogotlame. Bu sebobë keinebamu nëgeme, sebobë ilawa mago.” Na Judame gali motlola, “Jubë gali lale gali.” ");
INSERT INTO nce_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Na Ismael enëne bu belë Midian life mago fwa mëtëkakija. Na Josepme bolijahani fuluju mago ki motokokëya. Na Ismael enëneme yo motloma. Na 20 silva baliti këna glo namëglame. Josep bubë wege manawa fa nalëgëtatëmeme. Na Ismael enëne Josepme Isip lifewa mëtëmalitala. ");
INSERT INTO nce_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Tokwafe Ruben fulujuwa tisi, Josepme ki nalokokeme fene. Kwe Josepme hwi hana tlole. Na bu tako maninibomu metletle na ye tletle. Na bubë ëho kaka totle, bu maninibo tëgletleme nëgeme. ");
INSERT INTO nce_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Na bubë bolijamoni belë tuju. Na bume gali tlome, “Sebobë keinëba Josep bu fuluju mëta hana lëtabe. Masiwafe. Habelë nëgletelëmene?” ");
INSERT INTO nce_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Na bu mëmë kleli mogo nalë tëke motlola. Na Josepbë ëho kë ko mëta flu mëtëtatla. ");
INSERT INTO nce_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Na bu kë ëho bolijaya belë mëtehula na gali motlola, “Sebo ebë ëho waluju mago hwi tlola. Ju ebë ëho eselële fene. Ebë jubë nëbabë ëho nowa.” ");
INSERT INTO nce_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Na bu ëho hwi sle tlole na gali tlome, “O nëgalifee. Maseiwafee. Bobë nëbabë ëhofe. Waluju mago kleli wahi tlefee.” ");
INSERT INTO nce_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Na bolijaya bubë ato mago ëho kaka totome, na tëbo ëho gëgelo tle. Na boweneme itaita meye tëkoukefëtlebëë. ");
INSERT INTO nce_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Na bowenenino na bokonino bu belë mitisitla, bubë maninibo tli namëgëtatlame. Kwe bubë maninibo lowene hana tli mëtëtatla. Na bolijaya gali tlome, “Bo gli nëgelëna, na bobë nëba belë nëgëmatulëna, alibaho lifewa, bo mana ye nëgëmalitëme.” Na bu Josepme itaita ye tlekefëtle. ");
INSERT INTO nce_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Na Midian life mago enëne Josepme Isip lifewa mëtëmalitala, na Potifarme baliti sëneme yo motlola, baliti këna glo namëglame, Josep bubë wege manawa fa nalëgëtatleme. Na Potifar bu eso ho Ferobë wege fa tëtakefetle. Na Potifar bu eso ho Ferobë plismanëbë eso ho tafa tletëme. Na bu iniwa, eso ho Ferobë lo mëta sei mëtlëkefla, wame ho lime. Fero bu Isip life mago eso ho tafa tletëme. ");
INSERT INTO nce_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Na Ismael enëne Josepme Isip lifewa mëtlelula, na Potifarme yo motlola, baliti sëneme. Baliti këna glo namëglame, Josep bubë wege manawa fa nalëgëtatleme. Na Potifar bu eso ho Ferobë wege fa tëtakefëtle. Na Potifar bu eso ho Ferobë plismanëbë eso ho tafa tletëme. Na bu iniwa, eso ho Ferobë lo mëta sei mëtlëkefla, wame ho lime. Fero bu Isip life mago eso ho tafa tletëme. ");
INSERT INTO nce_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Goto Josepme lataitale, këme nëgeme Josepbë wege lalowamu, këme lëbetle. Na Josep Potifarbë lo mëta tafa tle. ");
INSERT INTO nce_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potifar bubë wege hwi tlotle na bu melowene tle, “Bubë iniwa wege lalemu lëbetlefe. Goto lëgaitaleme nëgeme.” ");
INSERT INTO nce_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Na bu Josepme fleflesu tletle na gali tlole, “Bobë iniwa wesibi tafa elelëmetënë.” ");
INSERT INTO nce_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Josep Potifarna weife tafa mëtelo na këme nëgeme Goto Potifarbë ilawa mago home ululu sle tëtagume, na bubë iniwa wesibi mata na bubë nuju mago wesibi mata ululu sle tëtagumetle. ");
INSERT INTO nce_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","7","Na Potifar gali tlole, “Bobë iniwa wesibibë eso home tafa eletenë.” Na Potifar bubë iniwa wesibi hana tutune tletëme. Bu hi wesibime fwa lowene tle. Na Josep bu tokwëfo tafawa kofene tle na Potifarbë no mana kë memaune tlële. Bu kalëlego homu na bu lale klisomu nëgeme. Na gali tlole, “Ju mana esi, bona ni nanëgebome.” ");
INSERT INTO nce_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Kwe Josep tole hana tletëmu na gali tolë, “Bome bihe kë wesibime nane gali tlonë. Weye. Matëbe. Bome wagali tlonë, bubë wesibibë esoho tafa nëgelëbëme. Na bubë lo mago wesibi hana tutune lëletëme. ");
INSERT INTO nce_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Bo ebë lobë bolijaya ho ha nëtabë. Bu bome iniwa wesibime hehë hana lëletenë. Jume fwamu hehë lëletenë. Sebo melë fëyeme nëgelomene. Matëbe. Kwe bo melë nëgelëna, bo Gotome tëbo nogotlëme.” ");
INSERT INTO nce_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Na itaita mëse awi, gali tlokwefle, buna ni namëgebome. Kwe Josep gali tle, “Matëbe.” Na loliwa hana tujutë. ");
INSERT INTO nce_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Tokwafe li olëna, Josep lowa tëkaklu, bubë wege fa nalogotleme. Na fli wege ho hana tafa mëtla. Buwa tafa telule. ");
INSERT INTO nce_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Na Potifar no bu belë tisi tle na ëho mëta fa tetokwakile na gali tlole, “Esimo. Bona ni nanëgebo.” Kwe ëho bubë toba mëta lakilewa tletë na latlëbukakuwa. ");
INSERT INTO nce_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Na mëse melowene tletle, “Josep walëlëboukakufe, na ëho tobana mana tehwatle.” ");
INSERT INTO nce_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Na home we tlome na mitisitëya na bu gali tlome, “Sobo aholokwane elo. Bobë ho Hibru mago home sebobë lo eli kë tëglesulebë seme tëbo lalëtana. Bome lisëme yafe tou lëtanë, kwe bo mana kë jakle nelë. ");
INSERT INTO nce_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Bo afëflei nëgelëme nëgeme bu mana kë lëlëboukaku. Na bu ëhowa bobë toba mëta kile lële.” ");
INSERT INTO nce_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Na Potifar no ëho mana gwa tëtakefëtle na bohe lowa mana tisi. ");
INSERT INTO nce_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Na boheme të tëtatle, “Hibru mago home, ju kë tëglesulebë bome lisëme yafe tou lëtanë. ");
INSERT INTO nce_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Kwe bo feilawa jiyakle noglolëme nëgeme, këme lëlëboukaku. Na bu ëhowa bobë toba mëta ekë kile lële.” ");
INSERT INTO nce_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Na no kë gali të tëtatle na Josepbë eso ho enisusu tletle. ");
INSERT INTO nce_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Na Potifarbë wege enëne Josepme fa mototla na kalabusu lowa tuku mëtla. Eso ho Ferobë kalabusu enëne këme kë tafa mëglekefëyabë lowa mëtlelula. ");
INSERT INTO nce_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Kwe Goto Josepme lataitale. Këme nëgeme bubë wege lalemu tëbetle. Kalabusu enenebë eso ho fleflesu tletle. ");
INSERT INTO nce_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Na Josepme këme gali tlole, “Ju iniwa kalabusu hobë eso home tafa eletëme.” Na Josep bu kalabusu hobë wege hwi tlotëme. ");
INSERT INTO nce_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Na Goto Josepna mëtëtabo na bubë wege taitatle. Na këme nëgeme kalabusu lo bolijaya bu wesibi tutune hana tletëme. Josepbë wege lalemu nëgeme. ");
INSERT INTO nce_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Tokwafe eso ho Ferobë bletë nage ahujume lëglekefëtlebë ho na bubë hitu su lëtakefëtlebë ho, humëi na hi lëglelëme, bu eso ho Ferome tëbo lamototlo. Na bu welili tletëme. ");
INSERT INTO nce_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Na eso ho Fero kë tlemalë wege home wame tlome. ");
INSERT INTO nce_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Na bu kë tlemalë home Potifarbë kalabusu lowa sike mëtla, Josep këme kë tafa tëglebë. ");
INSERT INTO nce_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Na kalabusu lo bolijaya Josepme gali tlole, “Ju kë tlemalë home tafa elelëme.” Na kë tlemalë ho kalabusu lo mëta tako olë tafa mëtelo. ");
INSERT INTO nce_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Tokwafe eso ho Ferobë hi wesibi ahujume lëglekefëtlebë ho na hitu su lëtakefëtlebë ho, bu kalabusu lo mëta kë tafa mëtelobë, bu nimitelëna hwi mëtelo. Na bubë tële nimitelë esobë bwa bwa. ");
INSERT INTO nce_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Na olobalë Josep bu belë hwime tuju tëme na mehwi latlome, “Yeluna alëla memëtelo.” ");
INSERT INTO nce_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Na takune tlome, “Sobo fëyeme tutune elone?” ");
INSERT INTO nce_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Na bu metafu mëtëtatelo, “Sebo nimitelë hwi nëgelome nëgeme, kwe seme li ho nimitelë esome hana gali lolono.” Na Josep bu tlemalë home gali tlome, “Goto nimitelë wayo gali buwa lowene lëletëme. Na buwa olafa lotometëname. Te, sobobë nimitelë galibë bome të etometëna.” ");
INSERT INTO nce_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Na hitu su tëtakefëtlebë ho bubë nimitelë gali të totle. Bu gali tle, “Bo nimitelë nanelë wain taba liji hwi nololë. ");
INSERT INTO nce_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Kë taba aona tikefona. Laba okwëfo foke mele. Na tahweji kë mëta fu mele. Na liji tatakowa mowalë. Na iniwa nigliji mele. ");
INSERT INTO nce_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Kë taba liji tu, lale iji lamële. Na bo eso ho Ferobë kabo fa nëtë. Na kë taba liji tu kiki notomë. Na bo kë tu eso ho Ferome kabona nëlëlë. Bobë nimitelë gali tei.” ");
INSERT INTO nce_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Na Josep gali tle, “Nimitelë esobë melëgëbelalëletle. Aona taba tikefobë, aona olëme lëlekuju lële. ");
INSERT INTO nce_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Aona olë yawe na eso ho Ferobë wame lowene mana tli lëbetleme. Na mana eso ho Fero bu gali loglëme, ‘Ita esimo, jubë wege ita fa naegotleme.’ Na ju tokwafe eso ho Ferobë hitu ita su egëtakefëtleme, ëbame ju fene su tëtakefëtle, humëina hi lëglelime. ");
INSERT INTO nce_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Na tokwafe, ju eso ho Ferobë lo mëta tafa eglena bome maninibo eletenëme na bome aholokwana asa ti ele. Lowene egletenëme na eso ho Ferome gali eloleme, bome kë kalabusu lo mago tuhu nalëgëtanëme. ");
INSERT INTO nce_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ëbamemu, bobë toba tabana lei mototometëna na Hibru life mago mana mëtlesuna ebë lifewa. Na bo ebë life mëta bo tafa tëgelëna, bo fëyeha hana telë. Kwe bome blawa kalabusu mëtëtana.” ");
INSERT INTO nce_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Na hi wesibi ahujume lëglekefëtlebë ho bu hitu su tëtakefëtlebë hobë nimitelë wayo gali aholokwane tle, na lowene tle, “Lalowafe.” Na Josepme gali tlole, “Bo melë nimitelë mehwi nanelë. Bo aona basketë musu bletë nage manogwa eso mëta gogwa mana nehwei. ");
INSERT INTO nce_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Matawa mago isekubë eso ho Ferobë lale nage ëfomemu mobe. Na kwe fole kë nage, ëfo mago hi mele. Bobë nimitelë gali tei yawe lële.” ");
INSERT INTO nce_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Na Josep gali tle, “Nimitelë esobë melëgëbelalële. Aona isekubë, aona olëme lëlekuju lële. ");
INSERT INTO nce_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Aona olë yawe jwa mëleme na eso ho Fero jume kalabusu lo mago tuhu lëtame na jume mou lokwati sika lëtame. Na jubë ato ti mëta tabana kesi lëtatëme. Na fole jubë afabo mana hi meletëme.” ");
INSERT INTO nce_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Aona olëbëna eso ho Fero, bubë wege home tako salë fata tëtatëme, bota bume këna fu togotlebë olëbë salë. Na bubë hitu su tëtakefëtlebë ho na hi wesibi ahujume tëglekefëtlebë ho kalabusu lo mago tutuhu mëtla. Na mëtlesuma, na eso ho Ferobë naba li mëta ola mëtla. ");
INSERT INTO nce_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Na eso ho Fero bu hitu su tëtakefëtlebë home gali tlole, “Ju ejume, na jubë wege ita fa naegotleme.” ");
INSERT INTO nce_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Kwe eso ho Ferobë hi wesibi kë ahujume tëglekefëtlebë home ti mëta tabana kesi totle na lagliwa tle. Ebë wesibi mefata këme mëtle, ëbame nimitelë eso galibëme Josep fene gali tle. ");
INSERT INTO nce_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Kwe eso ho Ferobë hitu su lëtakefëtlebë ho Josepme aholokwanamu ti tle. ");
INSERT INTO nce_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Tële tlibutu wamutuju na eso ho Fero nimitelë hwi tle. Bu nimitelë mehwi latle. Bu Nail tu helefo mëta tlibe. ");
INSERT INTO nce_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Na 7 bulmakau kleli tatako, tu mago fe motokoke, lifijuwa. Na bu tu helefo mago agosaba hi mele. ");
INSERT INTO nce_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Na tokwafe 7 ato tikatabo bulmakau kleli mata tu mago fe motokoke. Na bu tatako bulmakau kleli mëglëbo li mëta mëtlibe. ");
INSERT INTO nce_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Na tokwafe ato tikatabo bulmakau kleli tatako bulmakau klelibëme hi mëtle. Eso ho Fero bu kë nimitelë hwi tle na ni mago lahujuwa tëkake. ");
INSERT INTO nce_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Na ita ni tëtebokwake na li nimitelë hwi tle. Witi hi wesibi jowa hulu lële na kë jowa witi mëta hi wesibi 7 këniji mëbe. Na bu tatako mële na lalemu mëbe. ");
INSERT INTO nce_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Na tokwafe li witi hi wesibi jowa hulu lële na kë jowa witi mëta hi wesibi 7 këniji mëbe. Kwe bu tokwëtokwë mëbe na tëbo lamele. Na ona elë mago atëte tabo flelu ligisibë na lakokowa mëbe. ");
INSERT INTO nce_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Kwe kë tokwëtokwë witibë tatako witime lahiwa mele. Na eso ho Fero huju tëkake na lowene tle, “Bo nimitelëna hwi nelëfe.” ");
INSERT INTO nce_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Na olobalë bu tako tutune latle. Na bu tatako lowene home na yanowai home mata we tlome. Na bubë tële nimitelë gali të tëtatëme. Kwe kë enëne bume nimitelë wayo galibë të sle hana mëtëtatla. Bu kë tële nimitelë wayo galibë lowene hana mëtletëma. ");
INSERT INTO nce_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Na hitu su lëtakefëtlebë ho eso ho Ferome gali tlole, “O ëjewa ekë lowene nelëfe. ");
INSERT INTO nce_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ëbame ju bo name hi wesibi ahujume tëglekefëtëbë ho name wame latlona. Na ju seme Potifarbë kalabusu lowa sike tle. ");
INSERT INTO nce_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Kë mëta tafa telo. Na nimitelë hwi telo. Na sebobë nimitelë wayo gali bwa bwa. ");
INSERT INTO nce_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Na Hibru mago falake ho sebona tafa tla na bu kalabusu lo bolijaya hobë wege fa lëtakefëtle. Na sebo bume nimitelë gali të tëtatelo. Na bu sebobë nimitelë wayo galibë olafa sle tëtatëna. ");
INSERT INTO nce_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Na wesibi mefata wametle bu fene gali tlono. Bo jubë wege ita fa totlë, kwe ju hi wesibi ahujume tlekëfetëbë home ti mëta tabana kesi totle na bu lagliwa tle.” ");
INSERT INTO nce_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Na eso ho Fero bu kë gali yafe aholokwane tlole. Na bubë wege home jine telëkakle, Josepme no nalëglëleme. Na kë ho Josepme kalabusu lo mago hokweinawa no tujuwelële. Na Josep bubë ëbehuba laba glo tle. Na lale ëho gegelo tle. Na eso ho Fero belë mëtlelula. ");
INSERT INTO nce_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Na eso ho Fero Josepme gali lolole, “Bo nimitelë mehwi nanelë kwe bu nimitelë wayo galibë të hana mëtatëna. Bu lowene hana mëletëma. Kwe ho bu bome megali lamolona, ‘Ju nimitelë gali aholokwane eglena na ju nimitelë wayo galibë lowene sle ekoutëmeme.’ ” ");
INSERT INTO nce_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Na Josep gali lolole, “Bo kwe hanane. Goto kwe fëyemene. Buwa jubë nimitelë wayo galibë olafa logotometëme. Kwe jubë tutune lowene tli lëgëbetëme.” ");
INSERT INTO nce_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Na eso ho Fero Josepme gali lolole, “Bo nimitelë mehwi nanelë. Bo Nail tu helefo mëta nilibë. ");
INSERT INTO nce_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Na bo 7 tatako bulmakau kleli hwi nolomë. Na bu tu mago fe mokoke lifijuwa. Na tu helefo mago agosaba hi hi mele. ");
INSERT INTO nce_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Na tokwafe 7 bulmakau kleli tu mago mata fe mokoke na bu ato tika tanono na elebowa. Na bo këha ato tika tanono bulmakau kleli, Isip life mëta hwi hana nolomë. Hanane mu. ");
INSERT INTO nce_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Na ato tika tanono bulmakau kleli tatako bulmakau klelime hi mele. ");
INSERT INTO nce_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Bu wahi mele, kwe bubë ato sëse hana meletëme, otome fene mitlibe. Na ëje mata mëtabowa mëlibe. Na bo ni mago sagli nelëkaklë. ");
INSERT INTO nce_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Na bo ita ni nëtebokwakë na ita li nimitelë hwi nelë. Witi hi wesibi jowa hulu lële na kë jowa witi mëta hi wesibi 7 këniji mëbe. Na bu tatako mële na lalemu mëbe. ");
INSERT INTO nce_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Na tokwafe li witi hi wesibi jowa hulu lële na kë jowa witi mëta hi wesibi 7 këniji mëbe. Kwe bu tokwëtokwë mëbe na tëbo lamele. Na ona mago atëte tabo flelu ligisibë na lakokowa lotome. ");
INSERT INTO nce_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Na kwe kë tokwëtokwë witibë tatako witime lahiwa mele. Na bo kë nimitelë gali waiyobëme, yanowai home yafe takune nolomë kwe bu bome nimitelë wayo galibë të sle hana mëtatëna.” ");
INSERT INTO nce_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Na Josep eso ho Ferome gali tlole, “Jubë tële nimitelë gali kë nëgebë ebë jowa wayo galiwa. Goto bu wesibi jume wafi lebotane lëtatë. Na kë wesibi tokwafe fata lëgleme. ");
INSERT INTO nce_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Na 7 tatako bulmakau klelibë, 7 tlibutume lëlekuju lële. Na 7 tatako witibë mata 7 tlibutume lëlekuju lële. Ebë tële nimitelë gali kë nëgebë jowa wayo galiwa. ");
INSERT INTO nce_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Na 7 ato tika tanono bulmakau klelibë na 7 tokwëtokwë witibë, atëte tabo flelu kë koko totomebë, bu 7 tlibutume lëlekuju lële. Na kë 7 tlibutu, bu hi wesibi jwamu. Na bu foneme gigli mëglame. ");
INSERT INTO nce_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Bo jume ëje wagali nolë. Goto bu wesibi jume wafi lebotane lotometë. Na kë wesibi tokwafe fata lëgleme. ");
INSERT INTO nce_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Na 7 lale tlibutu migisina, Isip life mëta lebutako hi wesibi hulu mokoumemu. ");
INSERT INTO nce_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Na tokwafe kë 7 lale tlibutu yawe mëglena, 7 tëbo tlibutu migisime. Na bu mana foneme gigli nëlame. Hi wesibi jwa nëgeme. Na iniwa enëne, lale tlibutu lowenebë aholokwana ti mëglame. Na tako fone Isip life tëbo logotlememu. ");
INSERT INTO nce_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Kë 7 tlibutu kë migisibë, bu tëbo tlibutumu. Na oneho foneme gigli mëglame. Na iniwa oneho lale tlibutu lowenebë aholokwana ti mokoujame. ");
INSERT INTO nce_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Goto bubë lowene këbë wesibi mëta wafi gwa lotle. Këme nëgeme, ju këha tële nimitelë këme hwi elome, ju kë wesibi lowene naegletleme.” ");
INSERT INTO nce_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Te, ju lale lowene home hohwi etamëme na hwi eloleme na aniji eloleme. Na kë hobë Isip life enëneme tafa nalëglelëmeme. ");
INSERT INTO nce_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Na ju fli lale lowenena home aniji elomeme. Na 7 lebutako hi wesibi tlibutu migisina, kë enëne iniwa nuju mago hi wesibi loko mëtagujayame. Na bu tobali fu motomame. Na 4 fubë hi wesibi onehome sa mëtatëmame. Na jowa fubë hi wesibi gogwa lo mëta gogwa mulame. ");
INSERT INTO nce_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Na lale lowenena ho bu lale tlibutuna kë fata mëglebë hi wesibi loko mëtagujayame. Na bu, jubë lokwalëfe mëta fwa wege melame. Na bu witi liji na fli hi wesibi, loko lo takowa loko mëtagujayame.” ");
INSERT INTO nce_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Na 7 hi wesibi jwa tlibutu Isip lifate mëta fata mëglena, kwe Isip lifate mago oneho eso enëne kë loko mëgëtayabë lo mago hi wesibi glo mëlekefëyame. Këme nëgeme oneho foneme gigli hana mëglame. ");
INSERT INTO nce_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Eso ho Fero na bubë wege ho, Josepbë gali yafe aholokwane mëtla na kë galibëme tako tole memëtletla. ");
INSERT INTO nce_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Na eso ho Fero gali lolome, “Gotobë Amtëtomba, bu mëta tafa lëletle. Na sebo këha home fëye mago hohwi nëgëtayamene. Sebo këha home hohwi nëgëtayana, kwe sebo këha home hana hwi noglolame, Gotobë Amtëtomba tafa lëgletlebë home, sebo Josep mefwa aniji noglolame, Gotobë Amtëtomba tafa lëgletleme nëgeme.” ");
INSERT INTO nce_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Na eso ho Fero Josepme gali tlole, “Goto buwa jume kë wesibi waolafa lotometë. Na li ho juha lowene ho hana tafa lële. Hanane mu. ");
INSERT INTO nce_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Bo jume këme aniji nolë. Bobë life mago onehobë eso ho tafa naegletëmeme, jubë gali aholokwane melame na esogo melelëtëyome. Ju bobë lokwalëfe mëta fwa tafa eletenëme kwe bo tako eso homu tafa nelëme.” ");
INSERT INTO nce_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","“Bo jume Isip life tafa eglelëlebë home ekë aniji nolë.” ");
INSERT INTO nce_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Na eso ho Fero bubë toba baliti tohwa lëtamë, na bu Josepbë toba ku mëta gelo lëtatle. Kë toba baliti eso home lëlekuju elamë. Na bu lale ëho Josepme gelo lëtatle na lale tliji mou mëta lehotle. ");
INSERT INTO nce_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Na eso ho Fero bu kalë loha wesibi, wesibi Josepme lëlële. Hos kleli bu kë kalë loha wesibi, wesibime ki lokou. Na Josep bu këna na asë lëgëbelëfame. Na wege ho motoutaya na megali mëtlaguma, “Josep nagi kë lisiyo. Sobo alëge mago fë ebokwako.” Na kë lakalena, Josep, iniwa Isip onehome tokwefo eso home tafa tletëme. ");
INSERT INTO nce_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Na eso ho Fero Josepme gali lolole, “Bo Isip lifebë tako eso ho na bo megali nelë. Isip life mago oneho bu bubë lowenenawa wesibi li hana mogotlame. Jume afina takune molëyome.” ");
INSERT INTO nce_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Na eso ho Fero bu Josepme tiho weniji fë tëtatle, Safenat Panea. Na bu Potifera bokome yo tlole. Bubë weniji Asenat. Potifera bu Heliopolis life magobë fëso hi wesibi ahujume ahujume lëglekëfebë ho. Na Josep bu Isip lifate mëta tafa tle. Na bu Isip lifebë tokwëtokwë life elëme asë tëbelëfa. ");
INSERT INTO nce_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Na Josep bu 30 tlibutu watle na eso ho Ferobë wege mana fa tëtatle. Na bu eso ho Ferobë lo kile lotle na Isip lifebë tokwëtokwë life elëme asë tëbelëfa. ");
INSERT INTO nce_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Na kë 7 lale tlibutu migisina na feilawa lale hi wesibi fata mëgleme. ");
INSERT INTO nce_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Na Josep bu kë hi wesibi loko tëtagwi na jowa jowa lifatebë nuju mago hi wesibi loko lo mëta gogwa tokou. ");
INSERT INTO nce_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Na Josep bu kë loko tëtagwibë hi wesibi yafe tabei tle. Kwe bu feilawa wesibimu yenëba fenene na bu tabei hana tle manawa gogwa tle. ");
INSERT INTO nce_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Na 7 tëbo tlibutu fata jwa mëtëglena, Josep no Asenat tële iko nëbale mana fata totome. Asenat Potiferabë boko na bu Heliopolis life magobë fëso hi wesibi ahujume ahujume lëglekëfebë ho. ");
INSERT INTO nce_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Na Josep gali tle, “Goto bome lalaitanë. Na bobë afani kë tëbo mëtëtanabë na ilawa mago enëneme aholokwana ti nelë.” Na këme nëgeme bubë abwa nëba, Manase weniji këme fë totle. Manase gali wayo ebë aholokwana ti. ");
INSERT INTO nce_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Na bu ita gali tle, “Goto bome nëbale tële tlënë, hobota kë fa togotlëbë lifate mëta.” Na këme nëgeme bubë li nëbame Efraim weniji këme fë totle. Efraim gali wayo ebë nëba walëlënë. ");
INSERT INTO nce_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Na 7 lale tlibutu mutuju. ");
INSERT INTO nce_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Na 7 tëbo tlibutu fata mëtle, Josep fene gali tle. Na fli life hi wesibi alujawamu. Kwe Isip life mëta hi wesibi mana metëbe. ");
INSERT INTO nce_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Na tokwafe Isip life enëne tako foneme gigli mëtla. Na eso ho Ferome gali motlola, hi wesibi nalëglëmeme. Na eso ho Fero bume gali tlome, “Sobo Josep belë eyeume. Na bubë gali aholokwane sle elolome, some gali sle nalëglëyome, na sobo bubë gali esogo elelëtelome.” ");
INSERT INTO nce_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Na Isip life mago enëne foneme tako gigli mëtla na Josep hi wesibi loko lo ino mana titika tokoutëme. Na këbë enëne kë hi wesibi balitina glo namëkoukefëyame. ");
INSERT INTO nce_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Na fli life mago oneho mata foneme tako gigli memëtla, këme nëgeme bu Josep belë mitisikefëya, na hi wesibi balitina glo mëtlekefëya. ");
INSERT INTO nce_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Na Josep bolijaya Jekop, gali aholokwane tle, “Lale hi wesibi Isip life mëta memobe.” Na bu bowenenime gali tlome, “Sobo emëta tafawa fëyeme elone? ");
INSERT INTO nce_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Bo gali waaholokwane nelë, ‘Lale hi wesibi Isip life mëta memobe.’ Te, sobo kë lifewa eimome na lale hi wesibi kë mago glo emolome. Na sebo hi nanëglame, foneme gigli nëglalime.” ");
INSERT INTO nce_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Na Josepbë 10 bolijahani Kenan life kile mototla na Isip lifewa mitimiya, lale hi wesibi balitina glo namëgemolame. ");
INSERT INTO nce_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Kwe Jekop, Josep bolijamome Benjaminme, Isip lifewa jine hana tlële. Bu melowene latle, bu ligimena na bume alëgeme tëbo mogotlame. Josepna Benjaminna jowa bota mëta fwa fata mëtelo. ");
INSERT INTO nce_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Na Kenan life mago enëne mata tako foneme gigli mëtla. Këme nëgeme Jekop boweneninona na fli Kenan enënena iniwa mitimiya, hi wesibi balitina glo namëgemolame. ");
INSERT INTO nce_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Josep Isip life onehome tafa tlelëme. Na bu iniwa onehome lale hi wesibi sa tëtakefëtëme. Na bubë bolijahani, bu belë fata mëtla na sëkefo miti tafa mëtla na life elë hwi mëtëtëkaka. Josep bu Isip life mago eso ho nëgeme, bu sëkefo miti këme tafa mëtletla. ");
INSERT INTO nce_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Na Josep bu bolijahanime watëselëme. Kwe bubë weniji ëho latëtatëme. Na bu feilawa jiyakle tlome, “Sobo hamago esijone.” Na bume tafu mëtëtatla, “Sebo Kenan life mago nisiya, hi wesibi glo nanëglame.” ");
INSERT INTO nce_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Na Josep bu bolijahanime wa tëselëme kwe bume hana mëtëselëla. ");
INSERT INTO nce_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Na Josep bu bolijahanime hwi tlome, bume sëkefo miti tafa mëtletla. Na bu ëtani kë hwi tëglebë nimitelë gali ita lowene tletle. Na bu gali tlome, “Sobo hwelutuwa hwi enëne. Sobo Isip lifatebë flesu ho jwa life hwime esijo. Na tokwafe këbë life tëbo naegotlome.” ");
INSERT INTO nce_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Na bu gali tafu mëtëtatla, “O eso ho, weye, hanane. Sebo jubë wege enëne, hi wesibi glome nisiya. ");
INSERT INTO nce_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Sebobë aya jowa. Sebo hwelutuwa hwi enëne hanane. Sebo nëgali enënemu.” ");
INSERT INTO nce_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Kwe Josep gali tlome, “Hanane mu. Sogë lalo. Sobo Isip lifatebë flesu ho jwa life hwime esijo. Na tokwafe këbë flesu ho jwa life tëbo naegotlome.” ");
INSERT INTO nce_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Kwe bu gali motlola, “O eso ho. Sebo we ita tële nëbale na sebobë aya jowa, Kenan life mago ho. Na sebobë nagifu keinëba ayana tafa lamulo, kwe li keinëba wagli tle.” ");
INSERT INTO nce_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Kwe Josep gali tle, “Weye, hanane. Bo ëje wagali nelë, sobo hwelutuwa hwi enëne. ");
INSERT INTO nce_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Bo sobobë lowene su nëtatëyo fene. Sobobë gali nëgali gali o sogëna gali. Sobobë nagifu keinëba ebë life elë hana ligisina na bobë naba lime hana liglibena, kwe bo melowene, sobo sogëna gali na sobo sobobë lifekuwa hana egitome, hanane mu. Bo nëgali gali hana nëgelëna kwe melëmane bobë eso ho Fero tëbo malëtanë. ");
INSERT INTO nce_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","So mago li lujume na sobobë keinebame nolujuwelëlëme. Sobo fli kalabusu lo mëta mana tafa elome. Na bo lowene nanëgelëme sobobë gali nëgali gali o sogëna gali. Sobo sogëna egelona na sobobë keinëba hana eglesulona, kwe bo melowene nëgelëme, sobo hwelutuwa hwi enëne. Bo nëgali gali hana nëgelëna kwe melëmane, bobë eso ho, Fero tëbo malëtanë.” ");
INSERT INTO nce_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Na këme wagali tle na kalabusu lowa sike tle na bu tële olë kalabusu lo mëta tafa mëtelula. ");
INSERT INTO nce_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Na aona olëbëna Josep gali tlome, “Bo Gotome esogo nëglelëkeflëbë ho na bo some këme manibo nëletëyo. Sobo bobë gali esogo eglolona kwe sobo lalowa tafa egelome. ");
INSERT INTO nce_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Sobo nëgali gali hobë kwe bo metole nanelë, somago jowa howa kë kalabusu lo mëta tafa lëleme. Na sobo fli eitome. Na sobo kë glo tëgelobë hi wesibi sobobë ilawa enëneme ehwetutemome. Bu foneme gigli mëglalime. ");
INSERT INTO nce_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Na sobobë keinebame bo belë elesutëname. Na bo melowene nanëgelëme, sobobë gali nëgali galimufe. Na some hana tëbo nëgëtome.” Na bu gali mëtla, “Jubë gali lalowa.” ");
INSERT INTO nce_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Na Josep bolijahani blalo gali mëtla, “Nëgali, ëbame sebo keinebame tëbo totla. Na bu seme lëkle tëtana na yafe gali tlona, ‘Matëbe, tëbo asa etana.’ Kwe bubë gali aholokwane hana tlola na bume manibo hana tletla. Këme nëgeme seme ebë hobota këme lisitëna.” ");
INSERT INTO nce_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Na Ruben gali tlome, “Bo yafe gali tlëyo, keinebame asa tëkle etlo. Kwe bobë gali boblo latëtatëna. Josep gli tëgleme nëgeme, na kë hobota kofayame seme këme lisitëna.” ");
INSERT INTO nce_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Na Josepbë bolijahani Hibru galina gëgali mëtla. Na Josep bubë gali lowene latletëme kwe bolijahani melowene lamëtla, “Bu sebobë gali lowene hana lële.” Josep Isip life hobë galina gali tlome na li ho Josepbë gali bolijahanime Hibru galina obwelë tëtatëme, këme mumu mëtëbetla, “Sebobë gali lowene hana lëlefe.” ");
INSERT INTO nce_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Na Josep bubë gali aholokwane tlome. Na bume hune totome na hwelutuwa tako ye tletëme. Na ye kuju tëbe. Na ita tisi. Na bume gëgali tleleme. Na Simeonme aniji tlole. Na tële toba tabana lei totometle, bolijahanibë naba li mëta. Na bume kalabusu lowa tuku tle. ");
INSERT INTO nce_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Tokwafe Josep wege home hwelutuwa gali tlome, “Sobo ebë enënebë musu mëta lale hi wesibi sisike eletemomo. Kwe bu kë mëtehweijabë baliti, bubë musu ëfo mëta sike ekoutemome. Na sobo fli hi wesibi mata elëmome, alëgeme hi namokoujame.” Na bu melë mëtla Josep fene gali tlome. ");
INSERT INTO nce_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Na bolijahani bubë hi wesibi musu, bubë donki kleli matawa gogwa motola, na mititiya. ");
INSERT INTO nce_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Mititiyabëë na olë ki tëbe na alëge mëta ni namëgebëyame. Na ho li musu tuhu totle, hi wesibi donki klelime lëglële nalëgleme. Na bubë baliti, musu ëfo mago hwi tlome. ");
INSERT INTO nce_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Hwi tlome na bolijahanime we telokwakëme, “Bu bobë hi wesibi glo baliti bobë musu mëta wasike mëlafe. Bobë musu mëta ekë mëtemole.” Na bu klelegomu memotokouja. Na uli mëtla na bu blalo gëgali mëtla, “Iyee! Goto bu seme habelë lalëtanane.” ");
INSERT INTO nce_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Na bu Kenan lifewa fwa mutula. Na bolijaya belë mutuja. Na bume kë fata tëgletëmebë wesibibë gali bolijayame të mëtëtatla. ");
INSERT INTO nce_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Na bu gali motlola, “Isip lifebë eso ho seme feilawa gali tlona. Na blawa meso tëtatëna, ‘Sobo hwelutuwa hwi enënefe.’ ");
INSERT INTO nce_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Na sebo megali tlola, ‘Sebo nëgali enënemu. Sebo hwelutuwa hwi enëne hanane. ");
INSERT INTO nce_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Sebo we ita tële nëbale na sebobë aya jowa. Na sebobë nagifu keinëba ayana Kenan life mëta tafa melo, kwe li keinëba wagli tle.’ ");
INSERT INTO nce_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Na kë eso ho seme gali tlona, ‘Bo sobobë manibo fene su nëtatëyo. So mago li ho bona tafa nelome na fliye eitome sobobë ilawa enëneme hi wesibi ehwetutemome, bu foneme gigli mëglalime. ");
INSERT INTO nce_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Na sobobë nagifu keinëba bome elesutënana, bo melowene nanëgletëyome, sobo nëgali enënemu na sogëna enëne hanane na hwelutuwa hwi enëne hanane. Na bo sobobë afame kalabusu lo mago tuhu notokwaklëme. Na sobobë lifewa ita elelulome. Na sobo ebë life mago hi wesibi lalowa glo eglekefome.’ ” ");
INSERT INTO nce_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Na bu hi wesibi musu tutuhu motokouja na bubë baliti musu ëfo mago mana hwi mëtlaguma. Na bu bolijayana kë baliti hwi motloma na bu tako uli memëtla. ");
INSERT INTO nce_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Na bolijaya Jekop feilawa jiyakle tlome, “Sobo bobë nëbale tlemalë watëbo totomo. Josep waflawi tlita na Simeon mata waflawi tlita. Na sobo metole lalone, Benjaminme eglelulo naegelomene. Matëbemu. Kë sobo bome hobota gwa etakefëtëna.” ");
INSERT INTO nce_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Na Ruben bolijayame gali tlole, “Bo Benjamin, Isip life mago jume nëglesutë jwa nëgena kwe ju bobë tlemalë iko nëbale lalowa tëtëkle etomeme. Bo Benjaminme manëlelulë. Na bo ju belë mana fata nëlelëkakilëme.” ");
INSERT INTO nce_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Kwe Jekop gali tlole, “Bobë nëba juna hana egimome. Bolijaha wagli tle na buwa tafa lële. Na bume alëgeme tëbo mogotlana, kwe bo tako manibo mefwa gli nëgelëme. Bo filemi ho nëgeme.” ");
INSERT INTO nce_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Kenan life mëta hi wesibi alujawamu. Na iniwa oneho foneme giglimu memëtla. ");
INSERT INTO nce_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Na bu Isip life mago kë mëtehweijabë hi wesibi wayawe motloma. Na Jekop bowenenime gali tlome, “Sobo Isip lifewa ita eimomo na fli hi wesibi glo naegemole tëname.” ");
INSERT INTO nce_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Kwe Juda bolijayame gali tlole, “Aya, sebo jume wagali tolëyo, Isip life mago eso ho feilawa gali tlona, ‘Sobobë nagifu keinëba eglesutëna jwa nëgena kwe bome hana hwi egloname na hi wesibi hana glo egelome.’ ");
INSERT INTO nce_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ju seme nagifu keinëbame jine egletënana kwe sebo nimëyame na hi wesibi glo nemole tëyome. ");
INSERT INTO nce_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Kwe ju jine jwa egletënana kwe sebo hana nigimëyame. Kë ho seme megali togloname nëgeme, ‘Sobobë nagifu keinëba eglesutëna jwa nëgena kwe bome hana hwi eglokwakiname.’ ” ");
INSERT INTO nce_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Na Jekop gali tlome, “Sobo kë home fëyeme gali tlolone, ‘Li keinëba mana lëtabetëyo.’ Kë sobo bome hobota gwa tëtatëna.” ");
INSERT INTO nce_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Na bowenenino gali motlola, “Kë ho, sebobë ilawa mago enëneme tëtakune latlona. Na bu metakune latlona, ‘Blijaya mana tafa lëlene o wagli tle. Na li keinëba nanene.’ Na sebo bubë takune tafu tëtatla. Sebo meweniji latla, blawa takune lononawa. Sebo melowene hana tletla, seme megali nalogloname, ‘Sobobë nagifu keinëba elesutëna.’ ” ");
INSERT INTO nce_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Juda bolijayame gali tlole, “Ju Benjaminme jine elëbakëtenë na sebo iniwa nigimëya nanëglame, hi wesibi glo nanëgemolame. Na juna, sebobë nëbalena, sebo iniwa foneme hana gigli nëglame. ");
INSERT INTO nce_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Na bowa ululu sle nëgëtagulëme. Kwe bo ju belë sei jwa nëglëkakilëna kwe bobë wesibiwa. Na bobë kë manibo unaunalëme mana lëbekefëtenëme. ");
INSERT INTO nce_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ju seme lëkle jwa egëtanabë kwe sebo Isip lifewa tëlafe nuguja wa nëglame fene.” ");
INSERT INTO nce_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Na Jekop bowenenime gali tlome, “Masiwafe, kë eso hobë gali nëgali gali nëgena kwe sobo Benjaminme sei egujelëlome. Na sobo melë saelo. Sobo eflëbowa hi wesibi musu mëta sisike elome na ehowomujome na kë eso home manawa emowelëlome. Na saule tuha wesibi na yemaseneha wesibi na layaha wesibi bume ehwemutelome. ");
INSERT INTO nce_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Na some musu mëta kë sisike mëtletëyobë baliti mata ehwemutelome na bume emowelëlome. Bo lowene hana nelë bale bubë wege ho yaya lametlanawa na kë baliti këme sisike mëtla. Na sobo fli baliti mata ehowomujome na fli hi wesibi këna glo naegemolome. ");
INSERT INTO nce_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Na nagifu keinebame elemulome na kë ho betelë eimome. ");
INSERT INTO nce_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Bo Gotome megëgali nanëlelëlë, bu kë eso hobë manibo sle lëgëtatleme na some lëgaitome na Simeonname na Benjaminname yo lëlëyome. Kwe bobë nëbale iniwa tëbo miglitayana kwe melëmane tëbo matla.” ");
INSERT INTO nce_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Na Jekop boweneni, eso home mëglëlabë lale wesibi na hi wesibi glo baliti loko mëtëtaya. Na bu Benjaminna Isip lifewa mitimiya. Na Josep belë tuhu mëtemola. ");
INSERT INTO nce_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Na Josep bolijahaniname Benjaminname hwi tlome na bubë lo tafa lëglelëkefëtlebë wege home gali tlole, “Ju ebë enëneme bobë lowa elelumemo. Na bulmakau kleli tëkle etleme. Na kë ahujume eleme. Na klijina bo bume hi nanëglelëmëme.” ");
INSERT INTO nce_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Na kë wege ho bu melëtle Josep fene gali tlole. Na bu kë enëneme Josepbë lowa tlelume. ");
INSERT INTO nce_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Na bu lowa tlelumebëë, bu tako uli memëtla, na melowene lamëtla, “Ëbame sebo kë tigisiyabë na bu hi wesibi glo baliti sebobë musu mëta sisike mëtla. Na bu kë balitime lowene mëtla na seme tëbo nalëgëtanamefe, bubë lowa këme lëleluna. Na bu seme fa fa mëglame nawa na kalabusu lowa sisike melame na kë eso hobë wege mana fa nëtatlame. Na sebobë donki kleli tukli melame.” ");
INSERT INTO nce_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Na Josepbë wege ho ino li mëta tlibe na bolijahani bu belë mutuja. Na gali motlola, ");
INSERT INTO nce_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Masiwafe, sebo tokwëfo takune. Ëbame sebo ebelë balitina hi wesibi glome tisiya. ");
INSERT INTO nce_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Glo tla. Na titiya. Na alëgeme ni tebëya. Na hi wesibi musu tutuhu tokouja. Na hi wesibi këna glo baliti, musu ëfo mëta hwi tlaguma. Na sebo kë baliti ekë nehweija. ");
INSERT INTO nce_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Kë baliti sebobë musu mëta ya sike tlene. Sebo lowene hana nëla. Na sebo fli baliti mata nehweija hi wesibi glo nanëglabëme.” ");
INSERT INTO nce_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Na kë wege ho gali tlome, “Sobo tutune asa elo na uli asa elo. Sobobë na blijayabë Goto bu kë baliti sobobë musu mëta wasike tleteyo. Bo hi wesibi këna glo tëgelëbë baliti waglo telë.” Na bu Simeonme kalabusu lo mago tuhu totle na bolijahani belë tlelule. ");
INSERT INTO nce_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Na bu iniwa Josepbë lowa tlelëkakume. Na bume tu tlëme, elebo flëke swa namogotomame. Na hi wesibi mata bubë donki klelime tlëme. ");
INSERT INTO nce_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Na bu meaholokwane mëtla, “Josep klijina ligisimefe. Hi nalëglelëmeme.” Na bu Josepme mëglëlabë lale wesibi sle mototoma. ");
INSERT INTO nce_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Na Josep tisi na bu kë lale wesibi metlëla na sëkefo miti bubusu mototoma. ");
INSERT INTO nce_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Na Josep takune tlome, “Sobo lalowa tafa eulone o hanane? Na sobo ëbame bome këgali toglonabë filemi mana tafa lëlene o wagli tle?” ");
INSERT INTO nce_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Na bu gali tafu mëtëtatla, “Ei, sebobë aya bu mana lëtabe na lalowa tafa lule. Na jubë wege hoha tafa lule.” Na ita sëkefo miti bubusu mëtletla. ");
INSERT INTO nce_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Na Josep, bolijamo Benjaminme hwi tlole, weife aliji magobë. Na bolijahanime takune tlome, “Ebë sobobë keinëbane, sobo kë gali toglonabë.” Na bu Benjaminme gali tlole, “O hëyai, Goto jume manibo lëgletëme na laitame.” ");
INSERT INTO nce_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Na Josep bubë keinëbame manibo latletle na ëjeha ye lëletleme. Na këme nëgeme hokweinawa hune totome. Na kwe molowa tëkaklu na kë mëta hwelutuwa ye teluletle. ");
INSERT INTO nce_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Na bu ye kuju tëbe. Na nolo tuna swa totle. Na tëkakli. Na bu manibo tafuwa latotle. Na bubë wege home gali tlome, “Te, hi wesibi glo elome na masei mëta gogwa ekoujome.” ");
INSERT INTO nce_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Na Josep li masei mëta hi tle. Na bolijahani li masei mëta hi mëtla. Na Isip life mago ho, Josepbë lo mëta kë tafa metlabë, li masei mëta blalo hi mëtla. Isip life mago ho, bu Hibru life mago home tole hana mëtlekefëtëma, bu yonane hana mëtla. Këme nëgeme bu blalo këme hi mëtla. ");
INSERT INTO nce_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Na bu Josepbë naba lime metafana tafa mëtla, botamenino fene fufu mototoma. Bu oto mago ho mëta okli mëtla na këme keibë, këme keibë na nagifu nëba yaweme tafa tule. Na bu kë tafabë hwi motlola na klelego memëtletla na blalo gëgali mëtla, “Bu seme habëna lowene lëgletënamene. Beënino kë fufu mëtëtanabëme.” ");
INSERT INTO nce_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Na wege ho bu bolijahanibë hi wesibi Josepbë masei mago glo mëtletëma. Na kë hi wesibi bume sa mëtëtatëma. Kwe bu Benjaminme feilawa hi wesibimu tlële, tobalimalë hi mëglabë hi wesibi fene tlële. Na bu Josepna hi mëtla. Na bu tako fleflesu lamëtla. ");
INSERT INTO nce_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Na bu wafi hi mëtla na Josepbë lo tafa lëglelëkefëtlebë wege home gali tlole, “Ju ebë enënebë musu mëta hi wesibi sisike eletëmemo. Houme fwa asa sike eletëme, ëfomume etometemome. Na ju bubë hi wesibi glome kë mohweijabë baliti, musu ëfo mëta sike ekoutëmeme. ");
INSERT INTO nce_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Na ju bobë lale titono silva kabo nagifu nëbabë musu ëfo mëta tuku eletleme. Na bubë hi wesibi këna glo tëglebë baliti mata sike egletleme.” Na bu melatle Josep fene gali tlole. ");
INSERT INTO nce_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Na olë feti tëbe na wege ho bolijahanime sei tlagume. Na buna donki klelina iniwa mutuja. ");
INSERT INTO nce_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Na bu kë tako lifate kile mëtla. Na kakë hana mutuja na Josep bubë wege home gali tlole, “Ju kë enëneme hokweinawa esogo elagume. Na ju esune egujuwelëmena metakune eglomeme, ‘Sebo sobona yonane nanëla kwe sobo fëyeme gëglë eletënane. ");
INSERT INTO nce_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Sobo bobë eso hobë lale titono silva kabo fëyeme tokli eletelone. Bobë eso ho tu këna hi lëlekëfe. Kë kabo, lowene hwi mago kabo. Bu kë kabo hwi lolokwefë na bu melowene lalëlekëfe, wesibi tokwafe fata mëglemefe. Sobo fëyeme tëbo enitonë.’ ” ");
INSERT INTO nce_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Na Josepbë wege ho bume esune tlëme na Josepbë gali këme gali tlome. ");
INSERT INTO nce_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Bu gali tafu mëtëtatla, “Masiwafe, ju seme blawa fëyeme so etatënane. Sebo këha melë hana nëglame. ");
INSERT INTO nce_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ju seme walowene eletëna. Sebo Kenan life mago kë tigisiyabë na musu ëfome këhwi toglomabë baliti watehweitëyo. Ju walowene eletëme sebo nëgali gali ho. Ju habelë lowene lalene, jubë eso hobë silva na gol tokli nëgletlameha. Weye. Hanane mu. ");
INSERT INTO nce_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","O eso ho, ju sebobë musu hohwi etagwi. Na ju kë kabo li hobë musu mëta hwi eoglëna kwe kë home mogo nalë satëkle etle. Na ju seme fli kalabusu etaname na sebo jume manawa wege nëgletëyobë ho fata nëletëyome.” ");
INSERT INTO nce_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Na bu gali tafu tëtatëme, “Sobobë gali lalemu. Bo kë kabo li hobë musu mëta hwi noglotelëna kwe bume fwa kalabusu nogotlëme na bobë wege manawa fa lotleme. Na kwe fliye, egitome.” ");
INSERT INTO nce_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Na hokweinawa bubë musu life mëta gogwa motokouja na musu ëfo totohwa mëtëtaguma. ");
INSERT INTO nce_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Na Josepbë wege ho kabo hohwi tëtagutë. Bu abwa nëbabë musu afina hohwi tëtatle na këme keibë nëbabë musu, këme keibë nëbabë musu hohwi tëtagutë. Na nagifu nëbabë Benjaminbë musu yaweme hohwi tëtatle. Na kë kabo Benjaminbë musu mëta hwi tolë. ");
INSERT INTO nce_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Na bolijahani kë wesibi hwi motlëya na klelego memetla. Na bubë ëho këme kaka mototoma, bu tako manibo mëtletlame nëgeme. Na bubë musu, donki kleli matawa gogwa mëtla. Na ita lifatewa mutuja. ");
INSERT INTO nce_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Judana bolijahanina, Josepbë lowa tutuhu motula, Josep lo mëta mana tafa tle. Na bu tako uli memëtletla na Josepbë elebo lime lamëtitigotlawa. ");
INSERT INTO nce_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Na Josep gali tlome, “Sobo bobë lale titono silva kabo fëyeme tokli elone. Sobo lowene hana elone, bo kwe melë ho nëtabë, wesibi ëho mëglebë, eli bo kë wesibi hwi noglomëme.” ");
INSERT INTO nce_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Na Juda gali tafu tëtatle, “O eso ho, sebo jume habë gali noglëyomene. Sebo kë tëbo wesibi habëna sle nogotlamene. Goto bu sebobë tëbo wesibi waolafa lotome. O eso ho, kë ho bu jubë kabo toklime kë fa lëgëtabë, kalabusu egotleme. Kwe bume fwa nane, seme iniwa kalabusu egëtaname. Na sebo jume manawa wege nëgletëyobë ho fata nëletëyome.” ");
INSERT INTO nce_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Na Josep gali tlome, “Hanane mu, bo melë hana nëgelëme. Kë ho, bubë musu mëta kabo kë hwi loglëbë, bume fwa kalabusu nogotlëme na buwa manawa wege lëgletenë ho fata lëleme. Sobo fli kwe blijaya belë lalowa egitome.” ");
INSERT INTO nce_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Na Juda Josep belë tuju na gali tlole, “Aiyoo, eso ho ju bobë gali aholokwane enonë. Bo jume lalowa gali noglëmene. Bo walowene nelë, ju tako eso homu, eso ho Fero fenene. Ju bome wame asa enonë. ");
INSERT INTO nce_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","O eso ho, ëtani ju seme metakune latlona, ‘Sobobë blijayana, blijahanina mana tafa mëlane o hanane?’ ");
INSERT INTO nce_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Na sebo gali tolëyo, ‘Negalife. Sebobë aya mana tafa lële na bu filemimu. Na sebobë nagifu keinëba mana tafa lële. Bolijaya filemimu tëtabe na bota mana fu totle. Na kë nëbabë bolijaha wagli tle, buwa tafa lële. Na këme nëgeme bolijaya bume tako tole lalëletle.’ ");
INSERT INTO nce_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Na eso ho, ju seme megali latlona, ‘Sobobë nagifu keinëba bome elesutënamo, bo bume hwi nanoglolëme.’ ");
INSERT INTO nce_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Na sebo jume gali metafu tëtatëyo, ‘Kë nëba bolijayame asa kile malotle. Bu bolijayame kile logotlena kwe bolijaya tako manibo fwa gli lëgleme.’ ");
INSERT INTO nce_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Kwe ju seme gali tlona, ‘Sobobë nagifu keinëba eglesulo jwa nëgena kwe sobo bome ita hana hwi egloname, hanane mu.’ ");
INSERT INTO nce_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Na sebo aya belë titia na ju seme kë gali toglonabë gali bume të tëtatla. ");
INSERT INTO nce_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Na tokwafe aya gali tlona, ‘Sobo eimome na fli hi wesibi, balitina glo emoletëname.’ ");
INSERT INTO nce_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Na sebo gali tlola, ‘Sebo hana nigimëyame. Sebobë nagifu keinëba bume nëglelula jwa nëglana kwe sebo kë home hana hwi noglolame. Anë, sebobë keinëbame nëglelulana kwe sebo kë eso home hwi noglolame.’ ");
INSERT INTO nce_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Na sebobë aya megali tlona, ‘Sobo walowene elo, bobë mëse Resel iko nëbale tële wafata totometenë. ");
INSERT INTO nce_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Na jowa nëba bome wakile tëtanë na bo melowene nanelë, waluju mago kleli bume watëkle totle. Bo ita hwi hana nololë. ");
INSERT INTO nce_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Na sobo li nëba bo mago eglemulona na bume alëgeme tëbo mogotlana kwe bo tako manibo fwa gli negelëme, bo filemi ho nëgeme.’ ");
INSERT INTO nce_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","O eso ho, sebo nagifu keinëba ebë life mëta kile nëglana, na sebowa nigitiyana, na sebobë aya kë nëbame hwi jwa loglolena kwe bu gli lëgleme. Bu kë nëbame tako tolemu lalëletle. Sebobë aya filemimu na sebo kë nëba nëglelula jwa nëglana kwe sebo bume tëboha nogotlame. Na bu tako manibome fwa gli lëgleme. ");
INSERT INTO nce_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Na bo ayame wagali sle tlolë. Na bo megali latlolë, ‘Bo ululu sle nugujuwetlëme na bo ju belë hana nëglesulëna kwe bobë wesibiwa. Na bobë kë manibo unaunalëme mana lëbekefëtenëme.’ ");
INSERT INTO nce_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Na bo metole nanelë, kë nëba manawa wege lëgletëbë ho fata hana lëgleme, bowa fata nëgletëme. Bu kwe bolijahanina matitiya. ");
INSERT INTO nce_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Kë nëba bona hana nëgëyeuna kwe bo aya belë ita hana nuguwime. Bo bubë manibo hwime tole hana nëlëyo.” ");
INSERT INTO nce_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Na Josep bolijahanime tako manibo tletëme kwe bubë wege hobë li mëta yeme tole hana tle. Këme nëgeme bubë wege home gali tlome, “Sobo iniwa lo mago totoho ekako.” Na totoho mëtëkaka na buwa bolijahanime tafa tlelëme. Na bu Hibru galina gali tlome, “Bo Josep, sobobë keinëba.” ");
INSERT INTO nce_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Na Josep feilawa ye tle. Na Isip life mago oneho kë ye lego aholokwane mutula. Na kë ye tëglebë gali Isip lifate mago eso home gali mutujuwelëla. ");
INSERT INTO nce_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Josep gali tlome bolijahanime, “Bo Josep. Bobë aya wagli tlene o mana tafa lële.” Na bolijahani bubë gali yafe aholokwane motlola kwe bu tako uli memëtletla na bu gali tafu hana mëtëtatla. ");
INSERT INTO nce_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Na kwe Josep bolijahanime gali tlome, “Sobo loliwa esijo.” Na bu loliwa mutuja. Na bu gali tlome, “Bo Josep, sobobë keinëba. Ëtani sobo bome Isip life mago home yo tlomo, bubë wege manawa fa nanëgëtatemëme, na baliti glo telo. ");
INSERT INTO nce_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Kwe sobo ëtani bome kë tëbo tëgëtanabë wesibime tutune asa elo na welili asa elo. Bo some kofayame hana tëbo nogotome. Goto buwa jine tlënë. Some ebë life elë nogoutatëyobëme, onehome nëgaitamë nanëgelëme. Foneme gigli jwa namëglame. ");
INSERT INTO nce_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Na kë life mëta hi wesibi jwa tlibutu tële wamutuju. Kwe hi wesibi jwa tlibutu tobali mana mebokwe, na bu nuju mago hi wesibi hana wawa mëglame. ");
INSERT INTO nce_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Na Goto bu bome, nogoutatëyobëme jine telëbakënë, some nëgaito nanëgelëme, sobo foneme gigli jwa naegelome. Na sobobë nëbaletono unaunalëme natafa mokoutëyome. ");
INSERT INTO nce_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Kwe ebë lifewa sobowa jine tlëna nane. Wëye. Goto buna jine tlënë. Na bome aniji tlonë, eso ho Ferome lale lale lowene nëglëlëbëme. Oneho, eso ho Ferobë lo mëta kë tafa mëglabë, na bu, bome eso home tafa nëgletemëbëme anijimotlona. Na bo Isip lifebë iniwa onehobë eso home tafa nëletemë. ");
INSERT INTO nce_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Na sobo aya belë hokweinawa eitome na megali eglolome, ‘Jubë nëba Josep mana lëtabe na bu megali lalële, Goto bome Isip lifebë eso home aniji tlonë. Na ju bo belë hokweinawa esi. ");
INSERT INTO nce_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Na jubë nëbalename na blijafujuniname iniwa elesumeme. Na ju mëmë kleli na sipsip kleli na bulmakau kleli name na sobobë iniwa wesibi fli etobaklome. Na bomëta esijome. Na Gosen lifeku mëta tafa elome, bobë li mëta. ");
INSERT INTO nce_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Na ju Gosen life mëta tafa eglena, bo jume tafa nanëglelëme. Hi wesibi jwa tlibutu tobali mana mëbe. Na bo metole nanelë, ju na jubë nëbale foneme gigli hana mëglame na sobobë kleli mata foneme gigli hana mëgleme, bo some tafa nëglelëyome nëgeme.’ ” ");
INSERT INTO nce_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Na Josep bolijahanime gali tlome, “Sobo, seme Benjaminna, hwi sle elona na lowene sle eletëname, bo Josep, bo some ekë gëgali nëlelëyo. ");
INSERT INTO nce_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Na sobo ayame megali eglolome, ‘Josep Isip life mëta eso home tafa lële.’ Na lebutako wesibi sobo kë hwi eglomobë ayame mata gali etujuwelolome. Na sobo hokweinawa eitome na bume elesutëname.” ");
INSERT INTO nce_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Josep gëgali wayawe tlole, na bolijamo Benjaminme yena hwë tlële. Na Benjamin mata hwë tlële na ye mëtlelëgo. ");
INSERT INTO nce_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Na Josep fli bolijahanime yena hohwë tokou na bubë ahinome mëmëtle tëkoutëme. Bu melë wafi tle na bolijahani bume gëgali mëtlelëla. ");
INSERT INTO nce_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Na Josep bolijahani kë mitigisiyabë gali eso ho Fero belë fe tuletle. Bu na bubë wege hona, tako fleflesu memëtletëma. ");
INSERT INTO nce_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Na eso ho Fero Josepme megali tlole, “Ju blijahanime megali eglomeme, ‘Sobobë wesibi donki kleli matawa gogwa eolome na Kenan lifewa ita eitome. ");
INSERT INTO nce_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Na sobobë aya na ilawa mago ho bo belë elesumome, na bo some Isip lifebë lale lifemu yo nanëglëyome, na sobo lebutako lale hi wesibi hi naegelome.’ ");
INSERT INTO nce_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Na ju blijahanime mata megali eglomeme, ‘Sobo Isip life mago kalë loha wesibi, wesibi hos kleli kë asë mëglelëmebë, glo elome na sobobë lifewa ehoujome. Na sobobë one na nëbale na blijaya kë mëta tafa melame na këna elesumome. ");
INSERT INTO nce_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Na sobo lebutako wesibi asa ehweijo. Na sobo kë hune egelobë wesibi asa lowene eletemo. Matëbemu. Bo some Isip life mago lale wesibi nëglëyome.’ ” ");
INSERT INTO nce_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Na Jekopbë bowenenino, melë mëtla eso ho Fero fene gali tlome. Na Josep kalë loha wesibi, wesibi tlëme eso ho Fero fene gali tle. Na alëgeme hi mëglabë hi wesibi mata tlëme. ");
INSERT INTO nce_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Na bu bolijahanime tiho ëho tlëwagume. Kwe Benjaminme tobali tiho ëho na silva baliti 300 tlële. ");
INSERT INTO nce_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Na Josep Isip life magobë lale wesibi, 10 iko donki kleli matawa gogwa toletëme na kë donki kleli bolijayame telëkakle. Na bu witi liji, na bletë nage, na fli lale hi wesibi, na fli 10 tamo donki kleli matawa gogwa tole, na bolijayame mata telëkakle. Bu migisiyana, alëge mëta hi namëkekëyame. ");
INSERT INTO nce_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Na Josep bolijahanime jine telëkakëmena na gali tlome, “Sobo sobolalo alëgeme momata asa ekoujo.” ");
INSERT INTO nce_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Na bu Isip life kile mototla. Na mititiya. Na bu bolijaya Jekop belë Kenan lifewa fwa mutula. ");
INSERT INTO nce_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Na bu megali motlola, “Josep gli hana tle, hanane mu, mana tafa lële. Na ëje Isip life onehome eso home tafa lëletëme.” Na Jekop klelego metle. Na boblo totome. Na gali tlome, “Sogë lalo.” ");
INSERT INTO nce_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Kwe bu iniwa wesibi Josep kë gali toglomebë bolijayame gali motlola. Na Jekop kalë loha wesibi, wesibi Josep kë jine tëglëmebë hwi tlome. Na manibona sle tle. ");
INSERT INTO nce_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Na Jekop gali tle, “Negalimu. Bobë nëba Josep mana tafa lëlefe! Bo Josep belëme hokweinawa nuwime. Na hwi nujuwelëlëme na mana gli nelëme.” ");
INSERT INTO nce_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Jekop bubë iniwa wesibi sle totome na bu nonino name nëbale name Isip life elë tlemume. Bu Berseba lifewa fwa tulelëme na Jekop bubë bolijayabë Aisakbë Gotome, sipsip kleli ahujume temu totometle, Goto sinikibo hëhë nalëgleme. ");
INSERT INTO nce_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Na kwe klabë, Goto Jekopme nimitelë mëta fata tletle. Na we tlole, “Jekop, Jekop.” Na Jekop tafu tëtatle, “Wa, bo mana ekë tafa nelë.” ");
INSERT INTO nce_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Na Goto gali tle, “Bo Goto. Bo jubë blijayabë Goto. Ju Isip lifewa egujume uli asa ele. Tokwafe bo melë nogotomëme, bo jume nëgaitëme na bo jubë bisemlenime feilawa onehome fata nogotomëme. ");
INSERT INTO nce_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Isip lifewa bona weife nëgiyume. Na jubë bisemlenime ebë lifewa bo ita sei nëgelëfamëme. Tokwafe ju gli eglena, Josep jume bu gwa lëgëtamëme matëmatë mëta.” ");
INSERT INTO nce_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Na Jekopbë iko nëbale, Jekopme kalë loha wesibi mëta gwa mototokwakla. Na bubë one na nëbale name mata gogwa motokwaka. Isip life mago eso ho Fero, bu kë kalë loha wesibi tlëme, bu këna muguja namëglame. Na kwe Jekop bu Berseba life kile totle. ");
INSERT INTO nce_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Na bu bulmakau kleli mëtleluma. Na Kenan life mago kë glo mëtlabë wesibi na iniwa mëtehouja. Na Jekop bubë nëbalena bolijafujunina, Isip lifewa iniwa mutuja. ");
INSERT INTO nce_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Bu memutuja lamëtla. Bubë bowenenino na bokonino na bolijafujunino buna iniwa mutuja. ");
INSERT INTO nce_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ebë Jekopbë nëbalebë weniji buna Isip lifewa kë mutujabë. Bubë iko nëbabë weniji, abwa nëbabë weniji, Ruben. ");
INSERT INTO nce_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Na Ruben boweneninobë weniji melë, Hanok na Palu na Hesron na Karmi. ");
INSERT INTO nce_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Na Simeon boweneninobë weniji melë, Jemuel na Jamin na Ohat na Jakin na Sohar na Saul. Saulbë bota bu Kenan life mago mëse. ");
INSERT INTO nce_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Na Livai boweneninobë weniji melë, Gerson na Kohat na Melali. ");
INSERT INTO nce_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Na Juda boweneninobë weniji melë, Er na Onan na Sela na Peres na Sera. Kwe Er na Onan bu ëtani Kenan life mëta wagigli mëtelo. Na Peres boweneninobë weniji melë, Hesron na Hamul. ");
INSERT INTO nce_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Na Isakar boweneninobë weniji melë, Tola na Puva na Iop na Simron. ");
INSERT INTO nce_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Na Sebulan boweneninobë weniji melë, Seret na Elon na Jalel. ");
INSERT INTO nce_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ruben na Simeon na Livai na Juda na Isakar na Sebulun, na bu Leabë nëbale Jekopbë mëse. Lea bu nemosa nëba mata fata tëta, bubë weniji Daina. Na Leabë nëbale na bolijawani bu këniji fata mëtla 33. ");
INSERT INTO nce_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Na Gat boweneninobë weniji melë, Sifion na Hagi na Suni na Esbon na Eri na Arodi na Areli. ");
INSERT INTO nce_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Na Aser boweneninobë weniji melë, Imna na Isva na Isvi na Beria. Na bubë mësenëbabë weniji ebë Sera. Na Beria boweneninobë weniji melë, Heber na Malkiel. ");
INSERT INTO nce_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Jekop Silpana kë nëbaneni mëtëgelobë nëbale na bolijafujuni këniji fata mëtla 16. Silpa ebë Leame wegeme egaitamëbë mëse. Bume manawa wege eletë. Ëtani Laban bu Silpa Leame tlë. Laban ebë Leabë bolijaya. ");
INSERT INTO nce_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Na Jekopbë mëse Resel, bu iko nëbale tlemalë, bubë weniji Josep na Benjamin. ");
INSERT INTO nce_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Na Josep, Isip life mëta tafa tëglena, Asenatme mana sei tle. Asenat bu Potiferabë boko. Potifera bu Heliopolis life magobë fëso hi wesibi ahujume ahujume lëglekëfebë ho. Asenat bu iko nëbale tlemalë fata totometle. Bubë weniji, Manase na Efraim. ");
INSERT INTO nce_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Na Benjamin boweneninobë weniji melë, Bela na Beker na Asbel na Gera na Naman na Ehi na Ros na Mupim na Hupim na Art. ");
INSERT INTO nce_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Jekop Reselna kë nëbaneni mëtëgelobë nëbale na bolijafujuni këniji fata mëtla 14. ");
INSERT INTO nce_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Danbë bowene jowa. Bubë weniji, Husim. ");
INSERT INTO nce_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Na Naptali boweneninobë weniji melë, Jasel na Guni na Jeser na Silem. ");
INSERT INTO nce_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Jekop Bilhana kë nëbaneni mëtëgelobë nëbale na bolijafujuni këniji fata mëtla 7. Bilha ebë Leame wegeme egaitamëbë mëse. Bume manawa wege eletë. Ëbame Laban bu Bilhame Reselme tlë. Laban ebë Reselbë bolijaya. ");
INSERT INTO nce_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Na Jekopbë nëbale na bolijafujuni buna Isip lifewa kë mutujabë, bu këniji 66. Kwe bu Jekopbë boweneninobë oneme tabëi hana mëtla. ");
INSERT INTO nce_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Na Josep no bu tlemalë iko nëbale fata totome, Isip life mëta. Na kë tlemalë nëbale na Jekopbë nëbale na bolijafujuni Isip life mëta këniji mëtabëya 70. ");
INSERT INTO nce_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","29","Jekop Judame afina jine tlële, bu Josepme no lëlëleme Isip lifate mago na buna misijome bolijayame Gosen life mëta esune nalëglëleme. Na Jekop na nëbale na bu Gosen lifewa fwa mutulana, Josep bubë wege home gali tlome, “Sobo bobë kalë loha wesibi sagli elëtëname.” Bo ayame këna hwi nanujuwelëlëme. Bu këna Gosen lifewa tuju, bolijayame hwi nalogloleme. Na Josep bolijayame yafe hwi tlole na bume hwë tlële na ye tlelële. Meye tëglelëlebëë, na tokwafemu kuju tëbe. ");
INSERT INTO nce_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Na kwe Jekop Josepme gali tlole, “Jume wafi hwi noglëme nëgeme na bo melowene nanelë, ju mana tafa ele. Bo lalowa gli nëgelëme.” ");
INSERT INTO nce_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Na kwe Josep bolijahanime na bolijayabë ilawa mago onehome gali tlome, “Bo Isip life magobë eso home, megali nugujuwelëlëme, ‘Bobë afani na ayabë ilawa mago oneho, bu Kenan life kile mutula na bu bo belë fata mëkakija. ");
INSERT INTO nce_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Kë ho bu sipsip kleli mëlëkefëma. Na bubë sipsip kleli na bulmakau kleli mata melesuma. Na bubë iniwa wesibi mata mehweija.’ ");
INSERT INTO nce_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Na tokwafe eso ho some we loglëyona na takune loglëyona, ‘Sobo fëye wege fa etokweflone.’ ");
INSERT INTO nce_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Sobo megali eglolome, ‘O eso ho, sebo sipsip kleli na bulmakau kleli nëglëmabë enëne. Sebo tokwetokwëmume nëgena, kë wege mana fa tëtagila. Sebobë afunino mata sipsip kleli memëtlëwagima.’ Sobo eso home kë galime gali eglolona kwe bu some hana hehë lëgletëyome na megali lëglëyome, ‘Sobo Gosen life mëta lalowa tafa ekekome.’ Isip life mago ho bu sipsip kleli mëglëmabë home tole hana mëletëma. Këme gali tlome, ‘Sobo Gosen life mëta fwa lalowa tafa ekekome.’ ” ");
INSERT INTO nce_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Na kwe Josep eso ho Ferome megali latujuwelële, “Aya afanime Kenan life mago wafata lëlelëkakime. Bu sipsip kleli na bulmakau kleli na iniwa mëlesuma na bubë iniwa wesibi mata mohweija. Na bu Gosen lifate mëta kë tafa mëla.” ");
INSERT INTO nce_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Na Josep tobalimalë bolijahanime gali telëkakëme. Na bu mitisiya. Na eso hobë li mëta mitlija. ");
INSERT INTO nce_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Na kwe, eso ho takune tlome, “Sobo fëye wege fa etokweflone?” Na bu gali tafu mëtëtatla, “Sebo sipsip kleli nëlëkefëma, sebobë ayanino fene mëtlëkefëma. ");
INSERT INTO nce_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Sebo metole nanëla, sebo ebë lifate mëta esokwaneme tafa nëglame. Hi jwa olë Kenan life mëta fata tëgletëname nëgeme na sebobë sipsip kleli agosaba jwa nëgeme. Na fëye wesibi hi mëglemene? Këme nëgeme, sebo metole nanëla, ju seme megali lalowa eglonamene, ‘Sobo Gosen life mëta lalowa tafa egelome.’ ” ");
INSERT INTO nce_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Na kwe eso ho, Fero, Josepme gali tlole, “Blijaya na blijahanina wamisiya, juna tafa egelobëme. ");
INSERT INTO nce_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ju Isip lifatebë iniwa afloko lowene sle eletëmeme, na jowa lale aflokomu hwi elotëmeme na yo elomeme kë mëta tafa namëglame. Na ju metole egletëmena bu Gosen life mëta tafa matla, kwe ebë lalowa. Na jubë ilawa mago ho flime eselëmeme, bu bulmakau kleli mëglëmabë alëge kë lowene sle mëgletlabë, na ju bume aniji elomeme, bobë bulmakau kleli mëglëma namëglame.” ");
INSERT INTO nce_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Na kwe Josep bolijayame eso ho Fero belë sei tlële. Na Jekop Gotome takune tlole, eso ho Ferome ululu sle nalëgëtaguleme na lëgaitawagule nalëgleme. ");
INSERT INTO nce_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Na eso ho gali tlole, “O aya, jubë tlibutu ebënujune?” ");
INSERT INTO nce_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Na Jekop tafu tëtatle, “Bo ebë life mëta kë tafa nokweibë tlibutu këniji, 130. Ebë tako olë nane tafa nokwei kwe bome lebutako hobota mitisi tenë. Bobë afunino bu ebë life mëta tako tafa motokweijamu. Na bubë tlibutu ebë lebutakomu kwe bobë tlibutu tëlewa.” ");
INSERT INTO nce_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Na kwe Jekop eso home kaiye tlole na tuju. ");
INSERT INTO nce_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Na Josep bolijayaname, bolijahaniname taitame, lale life yo naloglomeme, eso ho fene gali tlole. Na bu Rameses life yo tlome, kë life mëta tafa namëglame. Kë life afloko lalemu kwe Isip lifatebë fli life afloko bu sogë lalowaha. ");
INSERT INTO nce_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Josep bu hi wesibi bolijayaname, bolijahaniname, bolijayabë ilawa mago oneho name, lëlekefëme. ");
INSERT INTO nce_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Tako fone fata tletëme na iniwa life hi wesibi jwamu. Isip life mago oneho na Kenan life mago oneho bu foneme tako gigli lamëlekefëyamu. ");
INSERT INTO nce_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Na Isip life mago oneho na Kenan life mago oneho bu hi wesibi Josep mago balitina glo mëtlekefëya. Na bubë baliti yawe motloma. Na Josep kë glo lëglekëfebë baliti, eso hobë lo mëta gogwa tlekëfe. ");
INSERT INTO nce_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Na Isip life mago onehobë baliti na Kenan life mago onehobë baliti yawe motloma na iniwa oneho Josepme gali mutujuwelëla, na bu gali motlola, “Hi wesibi enëna. Hana enënaye kwe sebo jubë naba li mëta gigliwa nëglame. Ju seme aitana. Sebobë baliti wafi yawe mëgleme nëgeme.” ");
INSERT INTO nce_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Na kwe Josep gali tlome, “Sobobë baliti wayawe eglomona, kwe sobobë bulmakau kleli na sipsip kleli bome elesume kefëtëname. Na bo some hi wesibi kofayame nanëglëkefëyome.” ");
INSERT INTO nce_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Na bubë hos kleli na bulmakau kleli na sipsip kleli na mëmë kleli na donki kleli Josepme mëtlelumekefëtla. Na Josep hi wesibi kofayame tlëkefëme. Na bu melë kë mëtlekefëyabë jowa tlibutu. Bu melëwa motokoujabëë na kë tlibutu mana yawe motlola. ");
INSERT INTO nce_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Kë tlibutu yawe motlola na ita Josepme mutujutla na gali motlola, “O eso ho, sebobë hobota jume hana ëho nëgëtatëyome. Sebobë baliti alujawamu. Na sebobë iniwa sipsip kleli na bulmakau kleli jume watlëkefëyo. Sebo jume nëglëkefëyobë wesibi hanane mu. Kwe sebowa nëtabëya na sebobë lifewa mëbagu. ");
INSERT INTO nce_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ju seme foneme gigli nëglabëme asa elësëna na ju sebobë flëke feilawa tëbo lëglebëme asa elësëtëna. Na sebo metole nanëla, eso ho Fero, bu seme laitakefëname na seme hi wesibi lëlëkefëname. Kwe sebo bubë wege manawa fa nëgëtatlabë oneho fata nëgletlame. Na sebobë life mata bume yo nololame. Kwe ju seme hi wesibi na olo wesibi eglënana kwe sebo foneme hana gigli nëglame. Na sebo tafa sle nëlame na sebobë flëke tëbo jwa nalëgleme.” ");
INSERT INTO nce_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Na kwe ëbame kë fata tëglebë fone mana lëbe na bu tako fatamu lalële. Na Isip life mago oneho Josepme hi wesibi sëneme bubë flëke yo mëtlagula. Na Josep bu kë iniwa flëke eso ho Ferome yo tlole. Këme nëgeme Isip lifatebë iniwa flëke, eso ho Ferobë flëkemu fata tletle. ");
INSERT INTO nce_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Na Josep melë latle, Isip lifebë iniwa onehome gali tlome, “Sobo eso ho Ferobë wege manawa fa etakefëtelome.” Këme nëgeme iniwa oneho bubë wege manawa fa mëtakefëtla. ");
INSERT INTO nce_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Kwe, Josep bu fëso hi wesibi ahujume ahujume mëglekefëyabë, hobë flëke hi wesibi kofayame hana fa tëtagutëme. Melëme nëgeme eso ho Fero bu kë enëneme baliti tlëkefëmeme nëgeme. Na bu kë balitina hi wesibi glo mëtlekefëya. Këme nëgeme bubë flëke hi wesibina kofayame yo jwa këme motlola. ");
INSERT INTO nce_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Na Josep bu onehome gali tlome, “Sobo aholokwane ekoujo. Bo sobo na sobobë flëke hi wesibina wahihijika telë. Na sobo eso ho Ferobë wege manawa fa egëtatelobë oneho tafa waelo. Na eli, bo olo wesibi some nëglëyome, sobobë nuju mëta tobalo naekoujome. ");
INSERT INTO nce_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Tokwafe nuju mago hi wesibi wawa egelona kwe sobo fu 5 mëta sa gwa etlo. Jowa lokotabobë eso ho Ferome elëlome, na 4 lokotabobë some egelome. Na somagobë fli unina tobalo egelobëme gogwa elome. Na fli sobo na sobobë nëbalena hi elome.” ");
INSERT INTO nce_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Na kwe oneho Josepme gali motlola, “Eso ho, ju seme hi wesibi watlëna, na seme wataitana, na sebo iniwa tafa sle nanëla, sebo gigli hana nëglame. Na sebo tako fleflesumu nanëla, eso ho Ferobë wege manawa fa nëgëtakefëtlame.” ");
INSERT INTO nce_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Na kwe Josep Isip life onehome gali tlome, “Sobo aholokwane ekoujome na kë gali esogo elelëlome. Tokwafe nuju mago hi wesibi wawa egelona kwe sobo fu 5 mëta sa gwa etlo. Jowa lokotabobë eso ho Ferome elëlome.” Kë gali unalëme mana lëbagutëmeme na mana ekë lëbetëme. Kwe eso ho Fero bu fëso hi wesibi ahujume ahujume mëglekefëyabë hobë flëke hana fa tëtatëme. ");
INSERT INTO nce_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israel enëne bu Isip lifatebë provins Gosen mëta tafa mëtla. Na bu kë flëke bume yo tlome. Na bu lebutako nëbale fata mototoma. Na feilawa oneho fata mëtla. ");
INSERT INTO nce_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Na Jekop bu Isip life mëta 17 tlibutu tafa tle na bubë iniwa tlibutu këniji 147. ");
INSERT INTO nce_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Na bu melowene latle, “Bo gli nëgelëme teife.” Këme nëgeme bu bowene Josepme këme gali telëkakle, ligisitle nalëgleme. Na bu tisitle. Na Jekop bume gali tlole, “Ju bome tolemu laletenë, kwe ju toba bobë yelukwafe sei elulukwakëmeme na bome megali sle enonëme, ‘Bo jume Isip life mëta hana matëmatë nëgëtëme.’ ");
INSERT INTO nce_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Bo gli nëgelëna, ju bome ebë life mëta asa matëmatë etanë. Weye. Matëbe. Bo mogome ebë life mago egehunëme na bobë afuninobë titono matëmatë mëta gwa eutanëme.” Na Josep gali metafu tëtatle, “Bo jume melë nëgëtëme ju fene gali ele.” ");
INSERT INTO nce_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Kwe Jekop gali tlole, “Ju bome iniyafememu fwa gali sle eglonëmemu, ju kë wesibi melë egotleme.” Na Josep bolijayame iniyafememu gali sle tlole. Na kwe, Jekop bubë ni labuku mëta eso life tuku totle na Gotome mana fleflesu tletle, Josep bume gali sle togloleme nëgeme. ");
INSERT INTO nce_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Tokwafe bu Josepme gali motlola, “Blijaya tëbo lalëlo.” Këme nëgeme bu nëbale tlemalë, Manase na Efraimname bolijaya belëme këme tlelume. ");
INSERT INTO nce_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Na ho Jekopme gali motlola, “Jubë nëba Josep walisi, jume hwi naloglëme.” Na kwe Jekop ni mago alabujuwa huju tle na ni labuku mëta mana tafa tle. ");
INSERT INTO nce_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Na Jekop Josepme gali tlole, “Goto bu iniwa afutukuna. Na bo bume Kenan lifatebë tokwëfo lifeku Lus mëta nimitelëna hwi tlolë. Bu bome lale gali tlënë, lëgaitanë nalëgleme. ");
INSERT INTO nce_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Na bome gali tlonë, ‘Bo jume feilawa nëbale nëglëme, na lebutako blijafujuni tafa namëgletëyome. Na ebë life nëlëme, na bubë lifemu unaunalëme lëgëbetëme nalëgleme.’ ” ");
INSERT INTO nce_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Na Jekop ita gali tlole, “Bo ju belëme Isip lifatewa tigisi jwa nëgena, jubë mëse tële nëbale mana fata totome. Bubë weniji Efraim na Manase. Na kë nëbale kënegebë, bobë nëbaleha tafa namëgletenome. Bobë nëbalemuha natafa mëgelome, Rubenna Simeonna fene tafa melo. ");
INSERT INTO nce_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Kwe ju nëbale Efraimnabë, Manasenabë nagi fata egotomena, kwe jubë nëbalemu tafa mëgletëyome. Na tokwafe flëke afloko bwa bwa lëglëwagumena, kë nagifu nëbale bolijahanibë ku mëta tafa mokoujame. ");
INSERT INTO nce_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Bo kë gali jume fëyeme nane gali nolë. Bo jubë bita Reselme tako manibo nëgletëme nëgeme. Bo Mesopotemia lifate kile tulë na Kenan lifewa tigisibëë na Resel mana gli tletenë. Sebo Efrata lifate kakëha mana asë tëkekëya na bu mana gli tle. Na bo Efrata lifate alëge li mëta gwa tëtë.” Efrata ebë Betlehem lifatebë ëtanifu weniji. ");
INSERT INTO nce_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Jekop tële nëbale hwi tlome na takune tlole, “Ebë yalëbë nëbalene?” ");
INSERT INTO nce_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Na Josep gali tlole, “Aya, ebë bobë nëbalefe. Bo ebë lifate mëta bowa tafa tëgelëna, Goto bu kë tële nëbale mana tlënë.” Na kwe Jekop gali tlole, “Ju kë nëbale bo belë elesume. Bo Gotome takune nanoglolëme bume ululu sle nalëgëtagumeme na bume lëgaitawagume nalëgleme.” ");
INSERT INTO nce_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Jekop bu filemimu nëgeme na naba olobaha këme lamu mototometle. Këme nëgeme, bu hwi sle hana tlome. Na Josep bu tlemalë nëbaleme loliwa tlesumetle, hwi naloglomeme. Na bu nëbale hohwë tle na ahinome sësle totome. ");
INSERT INTO nce_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Na Jekop Josepme gali tlole, “Ëtani bo meweniji latelë, bo jume hana hwi noglëmewa, kwe melowene latletë wagli tlewa. Kwe Goto bome taitanëme nëgeme na bo jume fwa nane hwi nolë. Wëye. Bo jume na jubë nëbalename mehwi nanolometë.” ");
INSERT INTO nce_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Na Josep bubë tlemalë nëbale Jekopbë elebo li mago nono tule. Na Jekopbë yako li mëta bubusu tletle na eso life mëta tëbetle. Jekop bu letitabo homu nëgeme. ");
INSERT INTO nce_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Na Josep bubë tlemalë nëbaleme Jekop belë tlelume. Na bubë abwa nëbame, Manaseme, Jekopbë tobamu tobali elë gwa totle, na nagifu nëbame, Efraimme, yemane tobali elë gwa totle. ");
INSERT INTO nce_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Kwe Jekop toba hihijika tle na li afalëba matawa gwa towetle, na bubë tobamu tobabë nagifu nëba, Efraimbë eso mëta gwa totatle na yemane tobabë abwa nëba, Manasebë eso mëta gwa totatle. ");
INSERT INTO nce_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Na Jekop bu Gotome takune tlole, Josepbë afenëbome lëgaitawagume nalëgleme. Na bu megali tlole, “Goto, bobë afu, Abraham, na bobë aya, Aisak, bu jubë lowenewa esogo mëtlelëtëyo, na boblo hana mëtëto. Beë bome nafu tëtanëna tafa tëglaginibë, na ebë olë elë mana ekë fe nëkaki. ");
INSERT INTO nce_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Na ju bome enselha fata tletenë. Na tëbo wesibi mitisikefëtenëna, ju bome taitakefënë. Na ju kë tlemalë nëbaleme ululu sle etokwefëmeme na aitakefëmeme. Ju bume aitameme, na bubë bosemlenibë nëbale lebutako enënemu fata namokoujame. Na kë enëne, bobë weniji na Abrahambë weniji na Aisakbë weniji aholokwana ti mëgletëmalime.” ");
INSERT INTO nce_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Bolijaya tobamu toba, nagifu nëba Efraimbë eso mëta kë gwa totatlebëme Josep hwi tlole na bu këme fleflesu hana tletle. ");
INSERT INTO nce_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Na bu bolijayame gali tlole, “Wëye. Aya melë asa ele. Ebë nëba kënegebë, bolijaha. Ju tobamu toba bubë eso mëta gwa egotatleme.” ");
INSERT INTO nce_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Kwe bolijaya tole hana tle, na Josepme gali tlole, “Hëyai, bo lowene nanelë, bo lowene nanelë. Kwe abwa nëba, Manasebë bosemlenibë nëbale bu mata feilawa enëneha fata mëglame, kwe bolijamo Efraimbë bosemlenibë nëbale feilawa enënemu fata mëglame, lebutako lifate mago onehoha fata mëgletlame.” ");
INSERT INTO nce_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Na kwe ebë olëna, Jekop bu lale gali tlëme, Goto bu kë tlemalë nëbaleme ululu sle nalëgëtagumeme na lëgaitawagume nalëgleme. Na bu Josepme gali tlole, “Israel life mago oneho bu Gotome takune moglolana, fli onehome ululu sle lëgëtagumebëme, kwe bu jubë tlemalë nëbalebë weniji fëfë mogotomame, na fli enëneme gali molomame, ‘Goto bu some ululu sle malëto, Efraimna Manasename fene ululu sle tëtagime.’ ” Jekop melë kë totomebë Josepbë nagifu nëba, Efraim abwa nëbaha tëtabe, na abwa nëba, Manase, nagifu nëbaha tëtabe. Na Efraim abwa nëbaha fata tle. ");
INSERT INTO nce_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Tokwafe, Jekop Josepme gali tlole, “Ju aholokwane ele! Bo gli nëgelëme nounou ekë nelë! Kwe Goto sobona egëtabome na bu some sobobë semlenibë lifewa lëglelujome. ");
INSERT INTO nce_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ëtani bo Amorbë ilawa mago onehome kosina nemona momogli tletomë. Na bubë life, Sekem wahijika totomë. Sekem life ebë lale lifemu. Na bo kë life jume fwa nëglëme. Bo jubë blijahanime hana nëglëmëme.” ");
INSERT INTO nce_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jekop bubë nëbaleme gali telokwakeme, “Sobo esijome na bome lolime tafa eletëname. Fli wesibi some tokwafe fata mëgletëyobëme gëgali nanëglelëyome. ");
INSERT INTO nce_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","O bobë nëbale, sobo bobë li mëta loko elelëyo, bobë gali aholokwane naegloname. Bo sobobë blijaya, Israel. ");
INSERT INTO nce_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, ju bobë abwa nëba. Bo falakeme nëgena, sebo bitana jume mana fu tëto. Ju flesu ho fata tle na ju tako afutukuna homu. Jubë afutuku jubë iniwa blijamonibë afutukume boblo lalotome. ");
INSERT INTO nce_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Jubë lowene haliji tuha sësëbo lëletë. Ho lëkle hana lëgëtatëme. Kwe, ju auto mago ho tafa hana egleme. Ju bobë mëseme atome fa tëgëtamëme nëgeme. Na bo tako tiniji latletë. Ju tëbo lowenemu esogo tlelële. ");
INSERT INTO nce_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon bolijamo Livaina bu wame wesibi glo mëtlekefo na fli home wame motlokwefëmo. ");
INSERT INTO nce_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Bu wame lowene fa mogotokweflona, bu ho flime mogo nalë memëlagekefo. Na bu wame jwa tafa mëgelona, bu tuja ato bulmakau klelibë elebo salëme fwa hihli mototokwefëtemo. Këme nëgeme, bo bume ehe hana nolomë. Blalo kë sle motokweflobë galibëme, bo kë aholokwanebëme tole hana nëlekefëtemë. ");
INSERT INTO nce_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Bubë wame lowene bume fwa tëbo nalogotomeme. Bubë wame lowene takomu nëgeme, na wame lowene tëbowa tëbetëme. Bo bume hehë nanëletemë. Na bo bu tlemalë name na bubë nëbale name fufu nëbetokwakëmëme. Na bu Israel life mago onehona bwa bwa tafa namëglelëmame. Bo bume flëke hana yo noglomëme. ");
INSERT INTO nce_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Juda, jubë blijamoni na blijahani jume bibita mëgëtagujome. Jume fli oneho wame moglëyona, ju mou mëta fwa fafa egleme. Na jubë blijamoni na blijahani jume sëkefo bubusu motometëyome. ");
INSERT INTO nce_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda, bu afeku laion kleliha. Bu kleli fa fa lëlekëfe, na hihi lëlekëfe. Na bu kalëlegona këme tafa lëgleme. Bu elili elili lële na alabujuwa tafa lële, laion kleli fenene. Na ho li bume hana lëlelu logotleme. ");
INSERT INTO nce_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Bu eso home kë lëlekuju eglatlebë atobeila lehwamë. Na bu eso home unaunalëme natafa lëkoume. Bu kë atobeila mana lehwaguime na bu Silo lifewa mana fwa luleme. Na bu iniwa onehome tafa lugulelëmeme. ");
INSERT INTO nce_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Bubë wain taba feilawamu hulu lokoutle na bu lalemu. Na bubë donki kleli takuliji logotlena, bu wain taba mëta fwa takuliji lotokwefële. Bu feilawa wain taba liji tu kiki lotokwefëme. Këme nëgeme bubë ëho kë wain taba liji tuna këme swa lotokwefëme bu feilawa wain taba liji tuna nëgeme. ");
INSERT INTO nce_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Bubë naba kowa këme fata meletle, wain taba liji tu hi lëglekëfeme nëgeme. Na bubë enino tatiwamu mëbetle, bulmakau kleli maba fo hi lëglekefëme nëgeme. ");
INSERT INTO nce_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulun bu nutu li mëta tafa lëgleme. Na bubë tu ku takomu lëgëbetleme. Këme nëgeme sibu lo tëbo hana mëgleme. Na bubë flëke meluguju tleme, Saidon life li mëta tou lokoutleme. ");
INSERT INTO nce_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakar bu kalëlego donki kleliha. Bu tële wesibi ku mëta fwa manawa meniniwa lëbekëfe. ");
INSERT INTO nce_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Bubë lale life lëselëwagule na melowene fa lotle, ‘O lale lifefe, bo këme tafa nanegelë.’ Na kë mëta bubë iniwa afutukuna wege lële. Kwe tokwafe, bu fli hobë manawa wege fa lëgëtatëmeme. ");
INSERT INTO nce_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Tokwafe, Dan bubë ilawa mago onehome eso home tafa lëgletëmeme, na bu Israel life mago fli oneho fene tafa mëla. ");
INSERT INTO nce_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan bu mefata lëgleme, taiju tëbo, alëge mëglëbo mëta fene sei lëlële. Hos kleli bu alëge elë fëka lokweina, kwe taiju hokweinawa okli lëkaketlebë na sëgetuju mëta latëtouwa lëlëleme. Na ho kë hos kleli matawa tafa logoletlena, kwe lalugujuwetigowa. ");
INSERT INTO nce_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Tako Ho, bo jume ekë hwi nëletë, ju bome egaitanë naegleme na jubë lale lifewa no enënëme. ");
INSERT INTO nce_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gat, tokli ho jume wame mëglelëkakëjome. Kwe, ju kofayame yafe wame elomeme kwe bu mëglëboujame. ");
INSERT INTO nce_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser, jubë nuju mëta lale lale hi wesibi feilawa hulu mokoutëme. Eso ho kë hi hi mëglabë hi wesibi ahujume ahujume eglekëfeme. ");
INSERT INTO nce_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naptali, bu waluju mago dia kleli ha. Bubë tolenawa fëka fëka lëbelëfa. Na bu lale lale nëbalemu nëbaneni lëlekëfe. ");
INSERT INTO nce_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Josep bu lale wain taba. Bu yefi tu li mëta hulu lële na bu feilawa liji lowalë. Bubë tikefo hele heletanëno nëgeme, na lëglesi lamu mototle. ");
INSERT INTO nce_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Wame ho bume nemona wame motlola, na sëfana mëtemila na tëbo mototla. ");
INSERT INTO nce_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Josep bu nemo hana tlëkële na bubë toba elili hana mëtletle. Jekopbë kalëlegona Goto, bume tëgaitaleme nëgeme na bume afutuku tëglëleme nëgeme. Kë Goto, Israel life mago onehome tafa lëlelëmeme na bubë kalëlego wame jiboha title lëletëmeme. ");
INSERT INTO nce_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Bu blijayabë Goto na bu tako kalëlego Gotomu. Buwa jume ululu sle lëgëtakefëme na laitakefëme. Na bu jume feilawa lale wesibimu lëglëkefëme. Bu jume tako tlibutu lëglëme, na jume life lokwalëfelë mago tu mata lëglëme. Na jubë ilawa mago oneho feilawa nëbaneni mëglame. ");
INSERT INTO nce_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Bo jubë blijaya. Bo jume lale gali nëlë, Goto jume ululu sle nalëtaguime na lëgaitawagume nalëgleme. Bo metole nanelë, ju lale wesibi kë glo eglebë, tako fatini lamu namëgëtatëme. Na kë wesibi, jubë afunino kë glo mëtëglabë wesibime boblo mogotomememu. Iniwa kë wesibi Josep ju mëta fata mëgleme. Ebë ho ju kënëgebë ëtani ju blijahani na blijamonibë naba li mëta eso ho fata tletëme. ");
INSERT INTO nce_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin, bu waluju ama ha. Bu kleli mogo nalë tëtëkle lëtakefë. Na iniwa olobalë bu kë tëtëkle lëtakefëbë kleli hihi lëlekëfe. Na taboklë ye, bu kë tëtëkle lëtakefëbë hi wesibi sa lëtakefëtëme.” ");
INSERT INTO nce_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ta ebë kënegebë, Israelbë we ita tële enënebë. Na bubë bolijaya bu gli lëgleme kwene bubë nëbaleme kë lëgaitawagumeme anebo gali tlelëme. Na bume lale gali tlome, Goto bume fwa ululu sle nalëgëtagumeme na laitawagumeme. ");
INSERT INTO nce_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Na Jekop bu boweneninome lale gali wagali tlome, Goto bume ululu sle nalëgëtagumeme na lëgaitawagume nalëgleme. Na bubë nëbaleme megali latlome, “Bo gli nëgelëme nounou ekë nelë na bobë ilawa mago lebo hona tafa nanugulame, alibaho life mëta. Sobo bome bobë afuninobë aniji fuluju mëta gwa egëtaname, Efronbë life mëta kë lo eglabë. Efron Hitbë bolijafuju. ");
INSERT INTO nce_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Kë aniji fuluju bu Makpela life mëta lo elamë. Makpela life bu Kenan lifatebë tokwëfo life, Mamre life li mëta lo elamë. Ëtani Abraham bu aniji fuluju Efronna balitina hihijika mëtelo. Bubë matëmatë lëgëbetle na lëgleme. ");
INSERT INTO nce_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Bu Abrahamna bubë mëse Saraname, kë aniji fuluju mëta gogwa mëtla. Na Aisakna bubë mëse Rebekaname mata kë mëta gogwa mëtla. Na bobë mëse Leame mata kë mëta gwa tëtë. ");
INSERT INTO nce_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ëtani Abraham bu kë aniji fuluju Hitbë ilawa mago hona balitina hihijika mëtelo.” ");
INSERT INTO nce_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Jekop bu yaweme gëgali tlelëmee na ni labuku mëta ni tëbe na lagliwa tle. Na bubë ilawa mago lebo enënena tafa mëtla, alibaho life mëta. ");
INSERT INTO nce_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Na Josep mehwi tlole, aya wagli lëlefe, na bu matawa laniwa tobetle na tako ye tletle, na bubë nolo momotlë tletle. ");
INSERT INTO nce_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Na tokwafe Josep u mogo kë ululu sle mogotomabë home, gali tlome, “Sobo ayame lëkalu malasini atome gogwa eletelome, bu ato lëkalu feilawa kë jwa nalëgletleme na ato fla jwa lëletleme.” Na kwe u mogo kë ululu sle mogotomabë ho, bu melë mëtla, Josep fene gali tlome. ");
INSERT INTO nce_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Na iniwa u mogo kë ululu sle mogotomabë ho bu kë lëkalu malasini bubë ato mëta gogwa motokoutlabë olë këniji 40. Na bubë ato fla jwa tletle na kokowa tëbetle. Na Isip life mago oneho bu Jekopme 70 olë ye mëtletla. ");
INSERT INTO nce_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Manibo mëtlabë olë yawe motlola na Josep eso hobë wege enëneme gali tlome, “Masiwafe, sobo lalowa bobë gali eso home gali egujuwelëlomene. Sobo bume megali egujuwelëlome, ");
INSERT INTO nce_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","eso ho, bobë aya glime nounou tëglena, bu bome megali latlonë, ‘Ju bome gali sle enonë, ju bome mogo ehunëme, na bo Kenan life mëta bo tobana kë go tëglelëbë aniji fuluju mëta gwa eutanëme.’ Na bo bume wagali sle tlolë. Këme nëgeme, bo metole nanelë, ju bome lalewa gali eglonëmene bo aya mogome gwa nanugujuwetlëme. Na bo ita nisime.” ");
INSERT INTO nce_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Na eso ho Josepbë gali aholokwane tlole na gali metafu tëtatle, “Ju lalewa egujume, na blijaya mogome gwa eujuwetleme, ju blijayame fene gali sle tlole.” ");
INSERT INTO nce_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Na kwe, Josep bu bolijaya mogome gwame tuju. Na eso hobë wege enënena bubë letitabo ho na Isip life magobë letitabo ho bu iniwa Josepme nagi mëtlëla. ");
INSERT INTO nce_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Na Josepbë ilawa mago hona bolijahanina bolijayabë ilawa mago hona iniwa aniji fulujuwa mutuja. Kwe tokwëtokwë nëbale hana mutuja. Nëbale na bulmakau kleli, sipsip kleli, mëmë kleli, Gosen lifate mëta lulu mëtla. ");
INSERT INTO nce_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Na kalë loha wesibi na hos kleli matawa kë tafa mogolekefëyabë hona iniwa Josepna mutuja. Lebutako enënemu mutuja. ");
INSERT INTO nce_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Na bu Atat life elime fwa mutula, Jodan tu nogowelëme. Kë Atat life kënegebë bu witi lijibë jibo fokwefokwe mototokwefëma na bubë afabo glo mëtla, hi namëglame. Na bu kë life mëta tako manibomu lamëtletla na feilawa ye mëtla. Na Josep bu 7 olëna bolijayame manibomu latletle na ye tletle. ");
INSERT INTO nce_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Na Kenan life mago oneho, ye kë mëtletlabë onehome hwi motloma na bu megali mëtla, “Isip life mago oneho bu tako manibomu lamëletla, na tako ye mëletla.” Këme nëgeme, bu kë life weniji mefë mototla, “Abel Misraim.” Abel Misraim gali ebë Hibru gali na ebë kë gali fenene, “Isip life mago oneho ye mëletla.” Ebë life Jodan tubë nogowelë lëbe. ");
INSERT INTO nce_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Na Jekop bowenenino bu melë mëtla, bolijaya fene gali tlome. ");
INSERT INTO nce_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Na bume Kenan lifewa mëtehula, na bume aniji fuluju mëta gwa mototla. Kë aniji fuluju bu Makpela life mëta lo elamë, Mamre life li mëta. Ëtani Abraham bu kë aniji fuluju Efronna balitina hihijika mëtelo. Bubë matëmatëmu fata nalëgletleme. Efron Hitbë bolijafuju. ");
INSERT INTO nce_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Na Josep bu bolijayame wagwa totle. Na kwe Josepna, bolijahanina, na fli enëne buna kë mutujabë, iniwa Isip lifewa ita mitimiya. ");
INSERT INTO nce_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Bubë bolijaya wagli tletëme, na kwe Josepbë bolijahani blalo megëgali mëtla, “Josep bu seme mana wame logloname nawa. Na sebo bume kë tëbo togotlabë bu seme kofaya tëbo lëgëtaname nawa.” ");
INSERT INTO nce_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Na këme nëgeme, bu Josepme këme gali mëtelokwakla. Ebë gali melë, “Ëtani sebobë aya mana tafa tëglena bu seme megali latlona, ");
INSERT INTO nce_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","sobo bobë gali Josepme sagali elolo. Bobë gali melë, ‘Josep bo jume tokwëfo takune. Masiwafe. Jume blijahani kë tëbo mëtëtobë lowene asa ehwagule, aholokwana ti egleme.’ Na kwe sebo, sebobë ayabë Gotobë wege enëne, jume takune nolëyo, ‘Masiwafe, sebo jume kë tëbo tëgëtobë lowene asa ehole, aholokwana ti ele.’ ” Na Josep kë gali yafe aholokwane tle na bolijahanime manibo tletëme na feilawa ye tle. ");
INSERT INTO nce_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Tokwafe, Josepbë bolijahani, bume hwime mutuja. Na bubë elebo li mëta bubusu mëtletla. Na bume gali motlola, “Sebo, jubë manawa wege ho, ju belë nisiya.” ");
INSERT INTO nce_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Kwe Josep gali tlome, “Sobo tutune asa elo. Bo Goto nane, some kë tëbo nogotome. Weyewa. ");
INSERT INTO nce_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Sobo ëtani iniwa melowene latelo, bome tëbo naegëtaname. Kwe Goto bu kë tëbo lowene, bubë lale lowenena wahihijika tle, bu metole tëgleme nëgeme, bome Isip life onehobë eso ho aniji naloglonëme. Na lebutako onehome nëgaitamë nanëgelëme, bu foneme gigli jwa namëglame. Na ëje sobo kë wesibi wafi hwi elolo. ");
INSERT INTO nce_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Këme nëgeme sobo tutune asa elo. Bo some na sobobë nëbale name iniwa tafa nëglelëyome na nëgaitome.” Na Josep bolijahanime flalego gëgalina lowene sle tëtatëme. ");
INSERT INTO nce_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Na Josep bolijayabë ilawa mago ho, Isip life mëta nibowai mëtla. Na Josep bu 110 tlibutu këniji tafa tle. ");
INSERT INTO nce_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Josep mana tafa tle, Efraimbë nëbaleme hwi tlome na kë nëbale kë nëbaneni mëtëglabë nëbaleme mata hwi tlome. Na Makir mata nëbaneni tle na këbë nëbale mata Josep belë mëtleluma. Na bu sësle totome na ameijume gogwa tle. Makir ebë Manasebë bowene. ");
INSERT INTO nce_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Na tokwafe Josep bubë ilawa mago home gali tlome, “Bo gli nëgelëme nounou ekë nelë. Kwe Goto bu some tafa lëglagujome na bu some ebë life mago nëno lëleme na lale lifewa sei lujuwelëyome. Ëtani Goto bu Abrahamna Aisakna Jekopname iniyafe galime megali sle tlome, ‘Sobo ebë lale life hwi ejuwelëlome, na bo tokwafe some ebë lale life yo nolëyome. Na tokwafe Goto bu some kë lale lifewa sei lugujuwelëyome.’ ” ");
INSERT INTO nce_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Tokwafe Josep bubë ilawa mago home gali tlome, “Sobo bome iniyafeme megali sle egloname. Tokwafe Goto some lëgaitome ligisi tëyona na some li lifewa sei lugujelëyona, sobo bo mogome ebë life mago saehulo.” Na Josep bubë ilawa mago home gali tlome, “Sobo bome sogëna asa enona. Sobo Gotobë naba lime iniyafeme fwa gali sle egloname.” Na bu gali motlola, “Sebo jume iniyafememu gali nolëyo.” ");
INSERT INTO nce_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Na Josep bu 110 tlibutu këniji tafa tle, na bu Isip life mëta mana gli tle. Na bu lëkalu malasini ato mëta gogwa mëtletla, ato lëkalu kë jwa na lëgletleme na ato fla jwa nalëgletleme. Na bu mogome bokis mëta gwa mototla. ");
INSERT INTO nce_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ebë lale gali, bu Gotobë nëba Jisas Klaisme gali nene. ");
INSERT INTO nce_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ëtani anebomu ebë lale gali fata tle. Bu mefata latle, Gotobë lowene mago gali të totokweflebë ho, Aisaia, fene yahi tle, “Goto boweneme megali latletle, ‘Aholokwane elo, kwe tokwafe bo ho lime jine nëglëlëme, bobë gali të nalëtagulebëme. Na bu jume loutatëme. Na bu alëge jume fu nalëtagutëme.’ ");
INSERT INTO nce_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tokwafe, li ho, ho jwa lifeku mëta mewe lëgleme, ‘Sobo tako hobë alëge fu etatelo, alëge sle etatelo.’ ” ");
INSERT INTO nce_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jon ebë kë nëgebëye, tu mëta baptais logotomebë ho. Bu ho jwa lifekuwa tuhu tule, Aisaia fene yahi tle. Na onehome gali të tëtatëme, “Sobo tëbo lowene aholokwana ti elome na lale lowenewa esogo elelëlome na baptais elome. Na Goto tëbo lowene sle nalëgetatëyome.” ");
INSERT INTO nce_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Na feilawa oneho, Juda lifate mago na feilawa oneho mata Jerusalem lifate mago, Jon belë mutuja. Na bubë tëbo lowene këme olafa mototometla. Na Jon bume Jordan tu mëta baptais totome. ");
INSERT INTO nce_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon bu lale ëho hana gelo totle. Bu kamel kleli hobona kë susu mototlabë ëho gelo totle. Na bu bulmakau jibo alitaba mata tehwamë. Na bu mëgou na saule tu mehihi latlekefe. ");
INSERT INTO nce_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Na këme Jon bu gali metë tëtakefëtëme, “Ho li bobë nagi ligisime. Na kë ho kë ligisibë bubë afutuku takomu kwe bobë afutuku tokwëfomu. Bo lale ho nane kë ligisibë home kë nëgaitalëme, manawa wege ho fene laitale. Weye. Bo bubë jiteho hana titika nëgletelëme. Bu letitabo homu nëgeme na bo atwati homu. ");
INSERT INTO nce_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Bowe, some tu mëta fwa baptais nëlelëyo, kwe buwe Gotobë Amtëtombana baptais lëglelëyome.” ");
INSERT INTO nce_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Na kë olëna, Jisas Galili provinsbë tokwëfo lifate Nasaret mago tisi. Na Jon bume Jordan tu mëta baptais totle. ");
INSERT INTO nce_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Na Jisas tu kile tle na helefowa fe tokwake. Na bu hwi tokwake, matafa inoha latikawa tle na Gotobë Amtëtomba seuneni foleha Jisasme ji tëtëkeketle. ");
INSERT INTO nce_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na Goto matafa mago gali tle, “Ju bobë lale nëba. Bo jume tako maninibo nanëletë, na tako fleflesu nanëletë.” ");
INSERT INTO nce_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Na kë nalëwamu, Gotobë Amtëtomba, Jisasme ho jwa tabo elë tlelule. ");
INSERT INTO nce_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Na bu ho jwa tabo mëta niliafewe olë tafa tle. Na Satan bu tëbo loweneme fene mana susu totle. Bu waluju mago klelina tafa mëtla, kwe ensel bume lamëtaitale. ");
INSERT INTO nce_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bu Jonme kalabusu lowa watuku mëtla, na Jisas Galili provins elë tisi. Na bu Gotobë lale gali të tëtatëme. ");
INSERT INTO nce_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Bu megali tle, “Goto kë aniji toglolebë olë wafata lële. Na Goto iniwa onehobë eso home natafa lëletëmebë olë nounou lalëletle. Sobo tëbo lowene aholokwana ti elome na lale lowenewa esogo elelëlome. Na sobo Gotobë lale gali lowene sle eletelome.” ");
INSERT INTO nce_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Na Jisas bu Galili lake tu hele helefowa tuju. Na bu Saimon name bolijamo Andru name hwi tlome. Bu solo, tu mëta tuku mëtelo, mo fa fa namëgelome, bu kë mona baliti glo namëgelome. ");
INSERT INTO nce_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Na këme Jisas bume megali tlome, “Sobo esijomo, bona asë nanëglame. Sobo mo fa fa lowenebë walowene eletelo. Na bo some ho fa fa lowenebëme okokwe nanëglëyome, bu Gotome esogo namëglelëlame.” ");
INSERT INTO nce_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Na bubë solo lakilewa mëtelo na mana nagi mëtelëkaklo. ");
INSERT INTO nce_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Na Jisas sogë tuju watle, na bu Jems, bolijamo Jon name hwi tlome. Bu Sebedibë nëbale. Bubë solo holëye tëgletëmeme nëgeme na bu ihe mëta këme tafa mëtelo na mana tibwa mëtelo. ");
INSERT INTO nce_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Na këme Jisas tlemalëme we tlome. Na bu bolijayaname, bume kë wege mëgletëmabë ho name, ihe mëta hune mëtëkako. Na bu Jisasme nagi mëtelëkaklo. ");
INSERT INTO nce_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jisas bu fli hona Kaperneam lifewa mutuja. Na Juda enënebë tafawa olëna, bubë lotu lowa tëkaklu. Na mana onehome gali të tëtatëme. ");
INSERT INTO nce_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bubë gali yafe aholokwane motlola, bu klelego memëtla. Bubë gali gena lëbetleme nëgeme kwe Gotobë tafa sle gali lowene sle mëgletlabë hobë galiye ge jwa lëbetëmemu. ");
INSERT INTO nce_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Na kë nalë, li ho bu kë life hobë lotu lo mëta tafa tle. Na ahwane kë ho mëta tëtabe. Na kë ho meafëflei latle, ");
INSERT INTO nce_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Nasaret life mago Jisas, ju seme habelë egëtaname esine? Ju seme tëbo naegëtaname esine? Bo jume lowene nanëletë, Ju Gotobë lale homu. Ju Goto mago kë egisibë ho.” ");
INSERT INTO nce_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Kwe Jisas ahwaneme anisasana megali latlole, “Ju kuju ebe na ebë ho mago eiju.” ");
INSERT INTO nce_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Na ahwane kë home anisasana luluju totle na feilawa juju tëkake na kë home lakilewa totle. ");
INSERT INTO nce_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Na kwe iniwa oneho klelego memëtla na blalo gëgali mëtla, “Euowe! Ebë fëye wesibine? Kë ho bu tiho gali të lotle. Na bubë galiye, flesu hobë gali fenene. Bu ahwaneme gali loglomena, aholokwanewa lamolole.” ");
INSERT INTO nce_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Na hokweinawa, Jisas këtëglebë galibë, Galili provinsbë li life li life fifiji mëtlelëla. ");
INSERT INTO nce_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisas bu fli hona, lotu lo mago metëkaklija. Na bu Saimonna, Andrunabë lowa mutuja. Jems na Jon buna iniwa mutuja. ");
INSERT INTO nce_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Na Saimon bokoka ni labuku mëta ni tëbe, bu tëbo tëgleme nëgeme na bu ahojutena sago metle. Na hokweinawa Jisasme gali motlola, “Bu tëbo lale.” ");
INSERT INTO nce_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Na Jisas bu betelë tujutë na bume tobame fa tëtamë na huju tëtamë. Na tëbo latliwa tëbe. Na kë mësebë, bume hi wesibi ahojume tletëme. ");
INSERT INTO nce_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Atome hwi olëna, bu tëbo atona onehome Jisas belë mëtlesuma. Na bu mata ahwane kë tëbo mototomebë onehome sei mëtelëfamëtla. ");
INSERT INTO nce_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Na feilawa oneho kë life mago, bu Jisas këme kë tafa tëglebë lo ino mëta loko mëtlelëya. ");
INSERT INTO nce_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Na tako ato elili mëta kë tafa mëtlabë onehome Jisas sle totome. Na bu ahwane tëbome hobë ato mago hehë tletëme. Na kë ahwane bu melowene lamëtle, “Jisas bu Gotobë nëba.” Këme nëgeme Jisas bume lëkle totome, “Sobo asa gëgali elo, matëbe.” ");
INSERT INTO nce_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na Jisas fole olëmu huju tle na tëkakli. Na ho jwa tabo elë tuju. Na Gotome gëgali tlelële. ");
INSERT INTO nce_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Na tokwafe Saimon bu huju tle na Jisasme hana hwi tlole. Na këme buna, bubë yabena, Jisasme hohwi mëtëtatla. ");
INSERT INTO nce_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Na bu hwi motlola na megali motlola, “Feilawa oneho jume hohwi mëtatëyo.” ");
INSERT INTO nce_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kwe Jisas bume megali latlome, “Matëbe. Bo kë lifewa ita hana nuguwime. Sebo fli life elë lolime kë mëgebebë telë manuja. Bo Gotobë gali të nanogoutatemëme. Bo këme tisi.” ");
INSERT INTO nce_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Na bu Galili provinsbë tokwëtokwë life elë asë tëbelëfa. Na bubë jowa jowa lotu lowa tëkaklutëme na Gotobë gali mana të tëtagutëme. Na bu ahwane tëbo onehobë ato mago hehë tlagutëme. ");
INSERT INTO nce_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Na ato juba jubawa kë tëgeholebë ho Jisas belë tisitle. Na bu sëkefo miti tafa tletle na anisasana gali tlole, “Jisas, ju tole laleye, ju bobë ato lalowa sle etatenëme.” ");
INSERT INTO nce_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Na Jisas bume maninibomu metletle na tobana lu totle na gali tlole, “Bo tole nanelë, ju lalowa tafa egleme.” ");
INSERT INTO nce_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Na kë tëbo bume lakilewa tetokwakle. Na bu lalowa tafa tle. ");
INSERT INTO nce_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Na Jisas bume jine tlële na anisasana megali tlole, ");
INSERT INTO nce_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ju aholokwane ele. Jubë ato lalowa kë lëgëbetëbë, ho lime asa gali elole. Matëbe. Jubë lowene mëta fwa eholeme. Na jubë ato, lotu home lebotane eoutatleme. Na ju bume sipsip kleli afabo ejuwelëleme, Moses fene gali tle. Na bu kë afabo Gotome ahojume nalëgletleme, bu sinikibo hëhë nalogoleme. Na iniwa oneho bu melowene namëgletëyome, ‘Jubë ato lalowa lëbetëfe.’ ” ");
INSERT INTO nce_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kwe kë ho, bubë ato kësle tëgletlebë gali, iniwa onehome të tëtatëme. Na iniwa oneho Jisas kësle logotlebë gali walowene mëtletla. Këme nëgeme Jisas lifeku mëta hana tafa tle, oneho bume sosalë mogotlalime nëgeme. Na bu ho jwa tabo mëta këme tafa tle. Na iniwa oneho li life li life mago, bu betelë mutujukefëtla. ");
INSERT INTO nce_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Na tokwafe, li olëna, Jisas Kaperneam lifewa ita tuju. Na iniwa oneho Jisas ita kë tigisibë gali aholokwane mëtla. ");
INSERT INTO nce_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Na lebutako oneho Jisasme lowa loko motokweitla. Lo lakewa tle, afloko hana tëbe tle. Na ino ëfo mata afloko hana tëbe. Na Jisas Gotobë gali onehome të tëtatëme. ");
INSERT INTO nce_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Bu gali mana të tëtagulebëë, na nilimalë ho, ato mogowa këtëgebetlebë home Jisas belë ni labukuna mëtlesula. ");
INSERT INTO nce_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Bu Jisas belë loliwa yafe mëtlesula kwe lebutako oneho tafa mëtlame nëgeme na lo wake tle, na bu loliwa hana mëtlesula. Na bu lo leli elë mëtehilikola na anabali sësakëfa mëtla, na ni labuku mëta kë ni tëgëbebë ato mogowa home mana tuku mëtëmalitaya Jisasbë elebo li elë. ");
INSERT INTO nce_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Na kë ho melowene lamëtla, “Jisas ebë ato mogowa home lalowa sle logotlemefe.” Na këme tuku mëtëmalitaya. Na Jisas bubë lowene wahwi tlotëme na kë ato mogowa home gali tlole, “O nëba iko. Bo jubë tëbo aholokwana wafi ti nëletë.” ");
INSERT INTO nce_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Na Gotobë tafa sle gali lowene sle mëgletlabë ho fli, kë lo mëta tafa mëtelula, na bubë lowene nawa melowene lamëtla, ");
INSERT INTO nce_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Bu këha gali fëyeme gali lëlene? Bu tëbo homu. Bu Gotome fëyeme boblo lotlene? Bu Gotoha natafa lëglemene? Hee! Ho kwe tëbo lowene aholokwana hana ti lëgleme. Hanane mu. Goto kwe fëyemene, tëbo lowene aholokwana ti lëgleme.” ");
INSERT INTO nce_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Na Jisas bubë lowenena hokweinawa lalowenewa tletëme. Na bume takune tlome, “Sobo këha lowenena fëyeme lowene elone? ");
INSERT INTO nce_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Bo bume megali noglolëna, ‘Bo jubë tëbo aholokwana wafi ti nëletë,’ sobo habelë lowene lalone, bo bubë tëbo lowene aholokwana ti nëletelë. Sobo kë wesibi hwi hana elolo. Kwe bo bume megali noglolëna, ‘Ju huju ele, na jubë lowa ejume.’ Na bu huju lëleme, kwe sobo melowene naegelome, ‘Bo Gotobë kalëlegona ho, na bo ato tëbona home lalowa sle nogotlëme. Na bo mata hobë tëbo lowene aholokwana lalowa ti nëgletelëme.’ ");
INSERT INTO nce_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Bo metole nanelë, sobo melowene egelome, ‘Bo kë nëgebë kwe, Gotobë life mago ho, bo ebë life mëta, kalëlegona homu nëtabë. Na bo tëbo lowene aholokwana lalowa ti nëgletemëme.’ ” Na Jisas ato mogowa këtëgëbetlebë home hwi tlole na gali tlole, ");
INSERT INTO nce_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Bo jume gali nolë, ju huju ele, na jubë ni labuku glo elëme na jubë lowa ejume.” ");
INSERT INTO nce_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Na kë ho lahujuwa tle na bubë ni labuku glo tle na hokweinawa latugujuwa. Na iniwa oneho klelego memëtla na bu Gotome fleflesu mëtletla na megaliwa mëtla, “Goto lale mu.” Na bu gali mëtla, “Ëtani sebo ebëha wesibi hwi hana tlola. Hanane mu.” ");
INSERT INTO nce_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisas bu Galili lake tu helefowa ita tuju. Na feilawa oneho bu belë mitisitla na bume Gotobë gali të tëtatëme. ");
INSERT INTO nce_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Bu tugujubëë na bu Alfiusbë nëba, Livaime, hwi tlole, bu takis lo tokwëfo mëta tafa tle. Livai bu takis baliti glo tëglekëfebë ho. Na Jisas bume gali tlole, “Ju bome nagi enënë.” Na Livai fotokoke na bume nagi telëkakle. ");
INSERT INTO nce_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tokwafe Jisas Livaibë lo mëta hi tle. Na feilawa takis baliti kë glo mëglekefëyabë ho na fli tëbo enëne, bu tëbo lowene mëta kë tafa mëglabë, bu Jisasna bubë lowene esogo mëglelëtlabë hona hi mëtla. Feilawa këha tëbo lowene esogo mëglelëlabë ho bu Jisasme nagi mëtelëkakla. ");
INSERT INTO nce_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Na Gotobë tafa sle gali lowene sle mëgletlabë ho fli, bu lolime tafa mëtla. Bubë weniji melë lëgëbetëmelalële, Farisi. Na bu Jisasme mehwi motlola, takis baliti kë glo mëglekefëyabë ho name na fli tëbo lowene kë esogo mëglelëlabë ho name hihi tlelëme. Na bu Jisasbë lowene esogo mëglelëtlabë home takune motloma, “Bu takis baliti kë glo mëglekefëyabë ho name na fli tëbo lowene kë esogo mëglelëlabë enënename fëyeme hi lëlelëmene? Bu tëbo enëne mu.” ");
INSERT INTO nce_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jisas bu kë gali aholokwane tle na kë Farisi home gali tlome, “Dokta bu tëbo jwa mëglabë home hana sle logotomeme, hanane mu. Ho tëbo mëglabë kwe fëyemene, dokta bume fwa sle logotomeme. Na bo kë fenene, bo lale lowene kë esogo mëglelëlabë hobë lowene sleme nane tisi. Weye. Bo tëbo lowene kë esogo mëglelëlabë hobë lowene sleme tisi.” ");
INSERT INTO nce_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kë olëna, Jonbë lowene esogo mëglelëtlabë ho, na Gotobë tafa sle gali lowene sle mëgletlabë ho, Farisi ho, bu hi wesibi yo mëtla, bu Gotome lowene sle namëgletlame. Na fli enëne bu Jisasme takune motlola, “Jonbë lowene esogo mëglelëtlabë ho na Farisibë lowene esogo mëglelëtëmabë ho, bu hi wesibi fëyeme yo melekefëyane kwe jubë lowene esogo mëlelëtëyobë ho, bu hi wesibi yo jwa fëyeme melekefëyane? Hi wesibi yo lowene, ebë lale lowene mu.” ");
INSERT INTO nce_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Na Jisas bume gali tlome, “Ho mëse sei lëglena, bubë yabenino hi wesibi yo mëglamene? Weye. Hanane yo mëglame. Kë ho bubë yabenina mana tafa mëglana, kwe bu hi wesibi hana yo mëglame. Hanane mu. Bu fleflesuna feilawa hi wesibi hi mëglame. ");
INSERT INTO nce_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kwe tokwafe, bu kë home bu mago mëglelulana, kwe mana bubë hi wesibi hana hi mëglame. Bu iniwa yo mëglame.” ");
INSERT INTO nce_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Jisas megali latlome, “Ëtanifu lowenena, tiho lowenena iniwa hana sago mëgleme.” Na bu ebëme mewaflë gali tle, “Ho li bu hëno ëho, tiho ëho katabona hana susu logotleme. Bu melë lëglena na kë ëho swa logotlena kwe kë tiho ëho katabobë fofogo lëgleme na hëno ëhome laholëyewa lotleme na fuluju takowa lëbeme. ");
INSERT INTO nce_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Na ho li bu tiho wain taba liji tu, ëtanifu mëmë kleli jibona kë blëge blëge mototlabë botolo mëta hana wë logotleme. Bu melë lëglena, na kë tiho wain taba liji tu sëse lëglena, kwe ëtanifu mëmë kleli jibo botolome bule logotleme na wain taba liji tu na mëmë kleli jibo botolona iniwa tëbo mëgleme. Ho li bu këha melë hana logotleme. Weye. Bu tiho wain taba liji tu, tiho mëmë kleli jibo botolo mëta wë logotleme. Na bu hana bule lëgleme.” ");
INSERT INTO nce_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jisasna bubë lowene esogo mëglelëtlabë hona tafawa olëna nuju kukuwa tlelume. Na bubë lowene esogo mëglelëtlabë ho, witi liji hi wesibi alëge alëge tëtlëwa motokouja. ");
INSERT INTO nce_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Na Gotobë tafa sle gali lowene sle mëgletlabë ho, Farisi ho, bu Jisasme takune motlola, “Ëje, ebë tafawa olë. Jubë lowene esogo mëlelëtëyobë ho, bu tafawa olëna nuju mago hi wesibi fëyeme tëtlë mëlane, bu tafawa olëna fëyeme wege mëlane? Moses bu ëtani kë lowenebëme tako hehë latle.” ");
INSERT INTO nce_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Na kwe Jisas bume gali tafu tëtatëme. “Sobo, sebobë ëtanifu eso ho, Devitbë anebo gali, Gotobë bogo mago, hwi sle hana elotelone? Gotobë bogo megali lala, ëtanimu, Abiatar bu lotu lo mëta wege mëglabë enënebë eso ho tafa tle. Na Devit, buna kë tafa tëglelëmebë ho, bu hi wesibi hanane na foneme gigli memëtla. Na Devit bu Gotobë lowa tëkaklu na bu Gotobë naba li mëta kë gogwa mëtlabë bletë nage hi tle. Kë bletë nage, Gotome kë gogwa mëtletlabë, atwati oneho hana hi mëglame. Lotu lo mëta kë wege mëglabë howa hi mëglame. Kwe Devit kë bletë nage fa totle na bume kë tafa tëglelëmebë home sa tëtatëme na bu iniwa hi tlelëme. Kwe bu tëbo lowene nane mëtla. Na bobë lowene esogo mëglelëtenabë ho mata, bu tëbo lowene nane mëtla.” ");
INSERT INTO nce_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Na Jisas bu li gali megali tlome, “Goto onehome afina blëge blëge totome na tafawa olë mana blëge totle, onehome lëgaitame nalëgleme, kë olëna tafawa namëglame. ");
INSERT INTO nce_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kwe bo kë nëgebë kwe, Gotobë life mago ho, bo tafawa olëbë eso ho nëtabë.” ");
INSERT INTO nce_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jisas bu lotu lowa ita tëkaklu. Na toba tëbona ho kë mëta tafa telule. ");
INSERT INTO nce_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Na Gotobë tafa sle gali lowene sle mëgletlabë enëne, Farisi enëne, bu Jisasme mana hwiwa motlola. Bu melëme hwi motlola, Jisas bu kë toba tëbona home, tafawa olëna sle logotlemene o hanane. Bu melowene namëglame, “Jisas bu tafawa olëna kë toba tëbona home sle logotlena, kwe bu Jisasme eso hobë toba elë gwa mogotlame.” ");
INSERT INTO nce_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Na kwe Jisas bu kë toba tëbona home gali tlole, “Ju ebelë esi.” ");
INSERT INTO nce_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Na Jisas bume takune tlome, “Gotobë gali ebelë lëgëbelalëlene? Sobo habelë lowene lalone? Sebo tafawa olëna lale lowene lalowa esogo nëglelëlamene o tëbo lowene esogo nëglelëlame. Sebo tafawa olëna onehome lalowa nëgaitamamene, bu lale tafa namëglame o sebo onehome lalowa hehë nëgletëmamene, bu gigli namëglame.” Kwe bu gali tafu hana mëtëtatla, bu hilego memëtla. ");
INSERT INTO nce_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Na Jisas bume hwi tlagume na lowene nawa wame tlome. Kë enënebë lowene kalëlego lëgletëmeme nëgeme na bu kë toba tëbona home hana maninibo mëtletla. Na Jisas bu këme wabelë tletëme. Na bu kë home gali tlole, “Jubë toba elili etokwakle.” Na kwe bu toba elili tetokwakle na bu lalowa tëbetle. ");
INSERT INTO nce_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Na hokweinawa Gotobë tafa sle gali lowene sle mëgletlabë ho, Farisi ho, bu lotu lo mago totoho mëtëkaka. Na bu eso ho Herotna ilawa kë wege mëglabë enënena loko mutulelëya. Na bu blalo, Jisasme gali mana fafa mëtëtatla. Jisasme mogo nalë, tëkle namogotlame. ");
INSERT INTO nce_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Jisasna bubë lowene esogo mëglelëtlabë hona, kë life kile mëtla na Galili lake tuwa mutuja. Na feilawa oneho Jisas belë mitisitla. Fli Galili provins mago na fli Judia lifate mago na fli Idumea lifate mago memitisitla lamëtla. Na fli Jerusalem lifate mago na fli Tair na Saidon lifate mago mata memitisitla lamëtla. Na fli Jordan tu jelëfo elë kë tafa mutulabë, bu mata mitisitla. Kë feilawa oneho bu Jisas kë sle tëtagumebë gali aholokwane mëtla na bu belë mitisitla. ");
INSERT INTO nce_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Na Jisas bubë lowene esogo mëglelëtlabë home gali tlome, “Feilawa onehomu bome ekë sosalë mëtana. Te, sobo ihe loliwa ehijo. Na oneho bome feilawa sosalë mëgëtanana kwe bo kë ihe mëta fe nanëkakëme.” ");
INSERT INTO nce_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ëtani Jisas bu feilawa tëbo atona home sle tëtagume. Këme nëgeme feilawa tëbo atona oneho, bu kofekofe sigli memëtlelogwaya, Jisasme atome lu namogotlame, bubë tëbo sle nalëgëtatëmeme. ");
INSERT INTO nce_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na ahwane Jisasme hwi moglolena kwe bu kë tëbo mogotomebë enëneme buna iniwa lifeme mitigwëyame na anisasana gali motlola, “Ju Gotobë nëba.” ");
INSERT INTO nce_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kwe Jisas bu ahwaneme itaita lëkle totokwefëme na anisasana gali tlokwefëme, “Sobo onehome megali asa elokwefomo, bo Gotobë nëba, matëbe.” ");
INSERT INTO nce_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jisas fatiniwa tokwale. Bu metole latle, home aniji naloglomeme, buna tafa namëglame. Na bu kë home gali telokwakëme. Na bu belë mitisiya. ");
INSERT INTO nce_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Na bu we ita tële home aniji tlome, buna tafa namëglame. Bu metole latle, bu Gotobë gali tëme jine nalëgëbelëkwakëmeme na Gotobë afutukuna, iniwa lëlëmeme, ahwane tëbo hehë namëgletëmame. Na bume Aposel weniji fëfë totome. Aposel weniji ebë melë Gotobë gali mëgehila ho. ");
INSERT INTO nce_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Bu we ita tële home aniji tlome. Bu Saimonme aniji tlole. Na Jisas bume li tiho weniji fë totle, Pita. ");
INSERT INTO nce_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Na bu Jems, Sebedibë bowene name, na bolijamo Jon name aniji tlome. Na Jisas bu kë tlemalëme li weniji fë totome, “Boanerges.” Ebë wenijiye bu kë gali fenene, “Matafaha kale.” ");
INSERT INTO nce_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Na bu Andru, Filip, Bartolomyu, Matyu, Tomas, Jems, Alfiusbë bowene, Tadius na Saimon name aniji tlome. (Saimon bu Selot ho, na bu metole latle, “Li life mago ho bu seme eso home asa tafa malëletëna.”) ");
INSERT INTO nce_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Na bu Judas Iskariotme mata aniji tlole. Judas bu tokwafe Jisasme wame home kë yo loglomebë ho. ");
INSERT INTO nce_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jisasna bubë lowene esogo mëglelëtlabë hona lowa mutuja. Na lebutako oneho mana ita loko metlelëtëmame nëgeme, na Jisas na bubë lowene esogo mëglelëtlabë hona bu kë nalë hi hana mëtla. ");
INSERT INTO nce_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Na Jisasbë weife mago enëne bu Jisas hi jwa këtëglebë gali aholokwane mutula na bu nome mitisitla. Oneho bu gali mëtla, “Bu wafi yaya lële.” ");
INSERT INTO nce_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Na Gotobë tafa sle gali lowene sle mëgletlabë ho, Jerusalem lifate mago kë mëtetujulabë, gali mëtla, “Tëbo alibahobë eso ho, Belsebul, (bubë li weniji Satan), bu Jisasbë lowene mëta lelutabetle. Na bubë kalëlego Jisasme lëlëkefle. Na bu kë kalëlego nawa ahwane hehë lëlekefëtëme.” ");
INSERT INTO nce_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Na Jisas gali telokwakëme na bu betelë mutuja. Na bume waflë gali të tëtatëme. Bu gali tle, “Satan bubë wege enëneme habëna kë lëglëmemene? Weye. Hana kë lëglëmeme. ");
INSERT INTO nce_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Na jowa lifate mago enëne, bu bwa bwa lowene mëta tafa mëglana na momogli mëgëtayana kwe bu tafa sle hana mëglame. ");
INSERT INTO nce_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Na jowa lo mëta kë tafa mëglabë enëne, bu bwa bwa lowene mëta tafa mëglana na momogli mëgëtayana kwe bu tafa sle hana mëglame. ");
INSERT INTO nce_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Na Satanbë ilawa mago alibaho mata, bu blalo wame mëglana na bwa bwa lowene mëta tafa mëglana kwe bu tafa sle hana mëglame. Hanane mu. Bu tëbomu mëglame.” ");
INSERT INTO nce_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Na bu waflë gali mana të tëtatëme. Bu megali tle, “Tokli ho bu kalëlego hobë lowa hana felokwakeme na wesibi mana tokli loleme. Weye. Hanane. Anë bu kë kalëlego home tabana afina lalei lotleme, kwe bubë lo mago wesibi mana toklime glo lëgletleme.” ");
INSERT INTO nce_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Bo some nëgali gali nanëlëyo, Goto, bu iniwa tëbo lowene, na iniwa gali, oneho Gotome kë tëbo gali moglolabë, aholokwana ti lëgletëmeme. ");
INSERT INTO nce_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kwe oneho, bu Gotobë Amtëtombame tëbo gali moglolana, kwe Goto kë tëbo lowene aholokwana hana ti lëgletëmeme. Kë tëbo lowene bu mëta unaunalëme tei lëbetëmemu. ");
INSERT INTO nce_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jisas bu kë gali këme gali tlome. Bu megali motlolame nëgeme, “Tëbo alibaho bubë lowene mëta lelutabetle.” ");
INSERT INTO nce_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Na kë nalëwa, Jisasbë bota na bolijamonina kë lo elë fwa mëtla. Bu lo li mëta mitlija na bu Jisasme mana gali mëtelulukwakla, bu belë ligisitëme nalëgleme. ");
INSERT INTO nce_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Lebutako oneho bume iniwa tafana hwagënë mototla. Na bume gali motlola, “Aholokwane elë! Jubë bita, blijamoni, bimilunina, mana kë tafa melukokwëya na jume kë gali melulubakëyo.” ");
INSERT INTO nce_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Na Jisas bu gali metafu tëtatëme, “Bobë beë na keinëbalenino bu habëha enënene?” ");
INSERT INTO nce_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Na bume kë hwagënë mototlabë onehome hwi tlagume na gali tlome, “Sobo hwi elo! Bobë beënino na keinëbalenino ekë tafa mla. ");
INSERT INTO nce_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Oneho bu Gotobë lowene esogo mlelëkefëtlabë, bu bobë beënino na keinëbalenino na oneglëni.” ");
INSERT INTO nce_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisas Galili lake tu helefo mëta onehome gali ita të tëtatëme. Na feilawa oneho bume loko mëtlelëtla na bume goglo mëtëtagulame nëgeme. Na Jisas ihe mëta këme fe tëtëkake na tafa tle. Jisas ihena lake tu mëta temule na oneho tu helefo mëta tafa motokouja. ");
INSERT INTO nce_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Na Jisas onehome feilawa waflë gali të tëtatëme. Na bu këme megali tlome. ");
INSERT INTO nce_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Sobo aholokwane elo. Ho li nujuwa luju, aoba liji sike nalëgleme. ");
INSERT INTO nce_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Bu aoba liji sike lëkou, na fliye alëgeme mitigotle na fole misibë lahiwa mele. ");
INSERT INTO nce_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Na fli aoba lijiye anijina flëke mëta mitigo. Kë flëke feilawa hanane. Këme nëgeme bu hokweinawa këme hulu mëtle. ");
INSERT INTO nce_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kwe tokwafe kliji bu fëfalewa u tle na kë aoba olo maklëfa mëtle. Bubë tayafo su sle hana mototome, këme nëgeme lakokowa metëbe. ");
INSERT INTO nce_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Na fli aoba lijiye, ikiji taba wayo mëta mititigo. Na kë ikiji taba bubule mëtle na tatako mëtle na kë aoba olome lamu mototome. Na bu liji hana fu mëtle. ");
INSERT INTO nce_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Na fli aoba lijiye bu lale flëkememu mititigo. Na bu lale hulu sle lamëtle na liji fu mëtle. Fli 30 liji fu mëtle na fli 60 liji fu mëtle na fli we lujuafe we liji fu mëtle.” ");
INSERT INTO nce_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Na Jisas megali latlome, “Sobo ebë gali aholokwane egelona, lowene sle saeletelo.” ");
INSERT INTO nce_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Iniwa oneho wafi mutuja. Na Jisasbë lowene esogo mëglelëtlabë ho we ita tële, na kë enëne Jisasna kë tafa mëtlabë, bume takune motlola, “Ju seme kë waflë galibë të sle etatëna.” ");
INSERT INTO nce_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Na Jisas bume gali tlome, “Ëtani Goto, bu onehome kë tafa lëglelëmebë gali olafa hana tletëme. Kwe ebë olëna bu kë gali some waolafa lëtatëyo. Kwe oneho bu Goto kë tafa lëglelëmebë lifate mëta tafa hana mëglame, bu Gotobë waflë gali aholokwanewa lamla kwe lowene sle hana mëgletlame. ");
INSERT INTO nce_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Këme nëgeme, ‘Bu mana itaita hwi mëglekefëyana kwe wesibi lowene sle hana mëgletlame. Na bu gali itaita meaholokwane mëglekefëyana kwe gali wayobë lowene sle hana mëgletlame. Bu waflë gali lowene sle mëgletlana kwe tëbo lowenebë kile mëglame na Gotobë lale lowene mëta tafa mëglame, na Goto bubë tëbo lowene aholokwana ti lëletëmeme.’ ” ");
INSERT INTO nce_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Na Jisas bubë lowene esogo mëglelëtlabë home gali tlome, “Sobo ebë waflë gali mumu egëbetelona kwe sobo fli waflë gali habëna lowene egletemomene? ");
INSERT INTO nce_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Bo some aoba liji waflë gali wayobë të sle nëgetatëyome. Kë ho, bu aoba liji kë sike lëkoubëye, bu Gotobë gali të logotlebë home lëlekujuwa lële. ");
INSERT INTO nce_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Na aoba liji alëgeme kë mitigobëye, bu Gotobë gali aholokwane mëglabë enëneme lëlekujuwa mëletëme, kwe Satan ligisibë na kë gali bubë lowene mago lafawa letokwakëtëme. ");
INSERT INTO nce_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Na fli oneho, bu kë aoba liji anijina flëkeme mitigobë fenene. Bu Gotobë gali aholokwane mla na hokweinawa lowene mletla na fleflesu mletla. ");
INSERT INTO nce_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Kwe Gotobë gali bubë lowene mëta lëgëbetëme sle hana lëletëme, olo wesibi tayafoha su sle hana motometëme. Na kë gali bubë lowene mëta tako lëbetëme hana lële. Kwe bu Gotobë gali lowene mëgletlame nëgeme, fli enëne bume këme tëbo mogotomame. Na bu Gotobë gali hokweinawa lamëglëkëlawa. ");
INSERT INTO nce_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Na fli enëne, bu kë aoba liji, ikiji taba wayome kë mitigobë fenene. Kë enëne bu Gotobë gali aholokwane mla, ");
INSERT INTO nce_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kwe bu ebë life mago wesibime fwa tako lowene lamëletëma, na feilawa baliti gogwame fwa tole mla, na bu feilawa lale wesibi mëmaune lamëlëma. Na kë wesibiwa Gotobë gali lëlamu mëtatëme. Na bubë lowene eflëbowa hana lëbetëme na lale lowene lëbetëme hana lële. ");
INSERT INTO nce_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kwe fli enëne, bu kë aoba liji lale flëke mëta kë mitigobë fenene. Bu Gotobë gali aholokwane mla, na bu kë gali bubë lowenena kiki motla na bubë lowene mëta eflëbowa lëbetëme. Fli oneho bu lale lowene sogë takoha lëbetëme na fliye lale lowene takoha lëbetëme na fliye lale lowene takomu lëbetëme.” ");
INSERT INTO nce_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Na kwe, Jisas bubë lowene esogo mëglelëtlabë home gali tlome, “Oneho bu lamo fiji tabo, iseku o ni labuku lokwalëfe hana gwa mëgëtayame. Hanane mu. Bu masei mëta gogwa melekefëya. ");
INSERT INTO nce_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Iniwa wesibi ëho kë mëglebë, kwe tokwafe olafa mëgleme. Na iniwa wesibi oneho ëho kë motomabë, kë mata, tokwafe olafa mëgleme. ");
INSERT INTO nce_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Sobo ebë gali aholokwane egelona, lowene sle eletelome.” ");
INSERT INTO nce_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Na bume ita megali latlome, “Gali sobo kë aholokwane egelobë, lowene sle egletelome. Sobo ebë gali aholokwane sle egelona na tako lowene slemu eletelona, kwe Goto some tako lowene lëglëyome na mata ita fli lowene lëlëyome. ");
INSERT INTO nce_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ho bu Gotobë gali lowene sle lëletlena kwe ita Goto bume fli lowene lëglëleme. Kwe ho bu Gotobë gali lowene sle hana lëletlena kwe Goto kë hobë tokwëfo lowene kë lëgelëkakëtleme.” ");
INSERT INTO nce_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Goto kë tafa lëglelëmebë oneho, bu kë fenene, Ho bu olo wesibi nuju mëta sike lële. ");
INSERT INTO nce_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Na bu klabë nini tëbagu na klijina huju tlekëfe na asë tle, bubë wege fa nalogotleme. Na kë olo wesibi hulu mëtle na tatako mëtle. Kwe kë ho bu olo wesibi hulume lowene hana tletëme. ");
INSERT INTO nce_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ebë flëkebë wesibiwa. Flëke bu lalemu nëgeme, olo wesibi këme hulu sle mële na liji këme fufu mële. Laba afina foke mële na tokwafe tahweji fata mële na liji mana fu mële. ");
INSERT INTO nce_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Na liji nigliji mëglena, kë ho bu kosina tëtlë lotome, bu nigliji mëglebëme nëgeme. (Ebë waflë galibë wayo gali bu melë lëgëbetlelalële. Goto kë tafa lëglelëmebë oneho, bu feilawa fata mëglame kwe sebo ëje hana hwi noloma na lowene hana nëletëma.) ");
INSERT INTO nce_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Na Jisas ita gali tlome, “Sebo habelë gali nëglame Goto onehome eso home ke tafa lëgletëmebë. Fëye wesibi hane? Bo some ebë, waflë gali të nëtatëyo. ");
INSERT INTO nce_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Goto onehome eso ho kë tafa lëglelëmebë, bu mastet inilu liji fenene. Fli inilu liji bu tokwëtokwë ha, kwe mastet inilu liji bu tokwëtokwëmu. Ho bu kë tokwëtokwë mastet liji life mëta sike lëleme. ");
INSERT INTO nce_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Bu sike lëleme, na bu hulu mleme, na takowa mlememu. Fli inilubë ato bu tokwëtokwëha kwe mastet inilubë ato bu tatakomu. Na kë inilubë tikefo tatakomu so mëbelëkakëmeme. Na fole, kë tatako tikefo tlilego tabo mëta, lo lalowa megigliji mogoleme.” (Goto onehome eso ho kë tafa lëglelëmebë, bu kë mastet liji fenene. Ebë olëna Goto tëlewa onehome tafa lëlelëme, kwe tokwafe bu feilawa onehome tafa lëglelëmeme.) ");
INSERT INTO nce_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisas bu onehome feilawa waflë gali të tëtatëme, bubë lowene nijiwa. ");
INSERT INTO nce_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Bu onehome gali të sle hana tëtatëme. Bu waflë gali nawa të tëtatëme. Kwe bubë lowene esogo mëglelëtlabë home fwa tafa tlelëkefëme, bu waflë gali mana të sle tëtakefëtëme. ");
INSERT INTO nce_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Na kë olënawa, taboklë, Jisas bubë lowene esogo mëglelëtlabë home gali tlome, “Te manuja. Sebo lake jelëfo elë su manëkaka.” ");
INSERT INTO nce_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Na Jisasbë lowene esogo mëglelëtlabë ho, onehome hune mototoma, na Jisas kë tafa lëglebë ihe mëta fëfe mëtla. Na bume mëtlelula. Na fli oneho mata buna fli ihena mutuja. ");
INSERT INTO nce_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Na tako flelu tisi, na lake tu ihe elë okokli tokoke, na tu ihe mëta tëtafu lëgleme kofene. ");
INSERT INTO nce_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Na Jisas eso hwesutane mëta gwa totle na ihe elo mëta mana ni tëbe. Na bume ni mago huju mototla, na gali motlola, “Tisa, ju seme maninibo hana eletënane? Sebo tume susuglu nëglame ekëne.” ");
INSERT INTO nce_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Na Jisas huju tle na flelume kale tlole, “Teiyo, kuju ebe.” Na tume mata, kale tlole, “Teiyo.” Na kwe flelu latliwa tëbë na tu sosogli mata lakujuwa tëbe. ");
INSERT INTO nce_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Na bubë lowene esogo mëglelëtlabë home takune tlome, “Sobo fëyeme uli elone, bome lowene sle hana eletënane, hee?” ");
INSERT INTO nce_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Na bu tako uli memëtla na blalo gëgali mëtla, “Euowe! Ebë habëtabo hone? Fleluna tuna bubë gali aholokwanewa lamlolefe.” ");
INSERT INTO nce_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jisas na bubë lowene esogo mëglelëtlabë hona Galili lake tu su mëtëkaka na Gerasabë walujuwa fwa mutula. ");
INSERT INTO nce_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Na Jisas ihe mago fe tëkake na ahwane kë tetëbo mogotlebë ho matëmatë life mago bu belë tisi tle. ");
INSERT INTO nce_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kë ho matëmatë life mëta fwa nini tëbekëfe. Ho liha bume senë tabana lei hana totle. ");
INSERT INTO nce_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Olëli olëli bu toba kaba yafe gëgelo mototokwefëmetla, kwe bubluju latotokwefëme. Na senë tabana yafe lei mototokwefla, kwe eluluwa latotokwefëme. Na ho liha bume hana fa logotleme. Bu afutuku feilawa tëgleme nëgeme. ");
INSERT INTO nce_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Klijina klabëna bu matëmatë life mëta na fatini mëta measasëwa latlekëfe. Na bu afëflei tlekëfe na bubë ato anijina tëtlë tëbetëfale. ");
INSERT INTO nce_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Bu Jisasme hwi telëkakle na fëka tokweitle na sëkefo miti latafawa tletle. ");
INSERT INTO nce_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Na Jisas gali tlole, “Ahwane ju ebë ho mago eiju.” Na bu kë gali aholokwane tlole na bu Jisasme feilawa galina këme gali tlole, “Jisas ju tako kalëlegona Gotobë nëba. Ju bome habelë egëtanëmene? Bo jume Gotobë wenijina gali nolë. Ju bome asa tëbo etanë.” ");
INSERT INTO nce_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Na Jisas bume takune tlole, “Jubë weniji fë etle.” Na bu gali metafu tëtatle, “Bobë weniji feilawa ho. Sebo lebutako nëgeme.” ");
INSERT INTO nce_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Na bu Jisasme anisasana itaita gali tlokwefle, “Ju ahwane kakë life elë asa jine elëkakëme.” ");
INSERT INTO nce_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na kwe lebutako kleli bu fatini mëta lolime memonei mëtle. ");
INSERT INTO nce_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Na ahwane Jisasme gali motlole, “Ju seme kë kleli belë jine elëkakëna, nëkaklutëma nanëglame.” ");
INSERT INTO nce_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Na Jisas gali tlome, “Sobo lalewa eyeu.” Na ahwane kë home kile mototle na kleli belë mëtëkaklutëme. Kë kleli këniji mitlibe 2,000. Na bu fatini mago lake tu elë fëka mëtëmalita na tu mëta lasusugluwa mëtle. ");
INSERT INTO nce_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Na kleli mëtlëma ho bu mëtlëbouja. Na kë gali li life li life asë mëtlelëla. Na lebutako oneho mutuja kë wesibi hwi namoglomame. ");
INSERT INTO nce_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Na bu Jisas belë fwa mutula na ahwane ëbame kë tetëbo mototlebë home mana hwi motlola. Bu lale ëho wateho na këna tafa tle. Na bubë eso hanane yaya tletle. Na bu uli memëtla. ");
INSERT INTO nce_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Na ho bubë nabana kë hwi motlomabë wesibime, ho flime gali të mëtëtatëma. Ahwane kë tetëbo mototlebë hobë gali na klelibë gali mata të mëtëtatëma. ");
INSERT INTO nce_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Na oneho Jisasme hehë mëtletla. Bubë life mago luguju nalëgleme, li lifewa. ");
INSERT INTO nce_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jisas bu ihe mëta fe tle. Na ahwane ëbame kë tetëbo mototlebë ho anisasa gali tlole, “Bona manëyeuwo.” ");
INSERT INTO nce_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Na kwe Jisas këme tole hana tletle. Na bu kë home gali tlole, “Jubë lifewa ejumo na feilawa wesibi Goto jume kë sle tëgetabë gali na jume kë maninibo tëgletëbë wesibi jubë ilawa mago home të eoutatëmeme.” ");
INSERT INTO nce_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Na fe tëkake, kë ho tuju na Dekapolis magobë life elëme, Jisas bume kë sle togotlebë gali të tëtagutëme. Na iniwa oneho bu aholokwane motlola na kle memëtletla. ");
INSERT INTO nce_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Na kwe Jisas ihena lake tu jelëfowa ita su tëkake. Na tu helefo mëta lebutako oneho loko mëtlelëtla. ");
INSERT INTO nce_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Na lotu lobë eso ho tisi. Kë hobë weniji Jairus. Jisasme hwi tlole, na elebolime latitigotlewa. ");
INSERT INTO nce_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Na bume anisasana takune tlole, “Bobë tamo nëba tako tëbo lale, gli egleme ekëyo. Ju bobë lowa lalowa egisimene na toba gwa etatëme, ato titika naegleme na mana lalowa tafa naegleme.” ");
INSERT INTO nce_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Na Jisas buna ilawa mëtëyeu. Na feilawa oneho mata esogo mëtlagula. Na Jisasna gëgeniwa mutuja. ");
INSERT INTO nce_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na jowa mëse kë onehona mutuja. Kë mëse bu we ita tële tlibutu ko tle. ");
INSERT INTO nce_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Na kë mëse lili dokta belë yafe asë tëbelëfa, kwe bubë ato titika sle hana tletë. Na bubë baliti doktame yawe latlometëme. Na kwe bubë tëbo mana tëbetë. Titika hana tle. ");
INSERT INTO nce_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Na kë mëse bu Jisasbë kë ato sle gali aholokwane tletëme. Na bu onehonabë Jisasnabë nagi këme tuju. Na bu Jisasbë leluju elëme tujutle. Na bubë ëho tobana lu tëtatle. ");
INSERT INTO nce_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Na bu melowene tëgleme nëgeme, “Bo tobana ëho mëta lu nogotlëna, bobë ato titika nalëgleme.” ");
INSERT INTO nce_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Bu ëho lu tëtatle na ko latewa tle. Na bubë ato melowene tletle, “Tëbo hana nelëfe, watitika nelëfe.” ");
INSERT INTO nce_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Na Jisas bu melowene latle, “Bobë kalëlego bome wali wafi kile lëtanëfe.” Këme nëgeme, bu swaya tle, na takune tle, “Bobë ëho ya lu lëtatenëne?” ");
INSERT INTO nce_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Na bubë lowene esogo mëglelëtlabë ho bume gali motlola, “Ju hwi hana elomene, lebutako oneho juna gëgeniwa kë egiyeubëye. Na ju fëyeme gali elene, ‘Bobë ëho ya lu lëtatenëne?’ ” ");
INSERT INTO nce_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kwe Jisas hwi tëbebokwake. ");
INSERT INTO nce_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Na kë mëse lowene tle, “Bubë kalëlego bobë ato mago tëbo wasle lëtatenëfe.” Na bu uli tëglebë, lili namëtle. Na Jisasme loliwa tisi tle. Na elebolime sëkefo miti tafa tletle. Na bu Jisasme iniwa gali ble tëtatle. ");
INSERT INTO nce_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Na Jisas gali tolë, “Mola, ju bome lowene sle egletenëme nëgeme, jubë ato këme titika lëletë. Na ju eiju. Tutune asa ele, lalowa tafa eoule. Na jubë tëbo tei sle lëletë.” ");
INSERT INTO nce_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Na Jisas mana gëgali tlelëbëë, na ho, Jairusbë lo mago wofu mana fata tlelëkakile. Na Jairusme gali motlola, “Jubë nëba wagli elo. Ju tisame ita welili asa eletle. Matëbe.” ");
INSERT INTO nce_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kwe Jisas bubë gali boblo tëtatëme. Na lotu lobë eso ho, Jairusme gali tlole, “Ju tutune asa ele, bome fwa lowene sle egletenëme.” ");
INSERT INTO nce_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Na bu feilawa home hehë tletëme, bume esogo jwa namëglagulame. Pita, Jems, na bolijamo Jonname fwa tlelume. ");
INSERT INTO nce_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Na bu Jairusbë lowa fwa mutula. Na Jisas, bu se lego aholokwane tlome na ye lego mata aholokwane tlome. ");
INSERT INTO nce_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jisas lowa tëkaklu na gali tlome, “Sobo fëyeme ye elone? Sobo fëyeme se etlone? Kë nëba gli hana elo. Ni tekwe egëbe.” ");
INSERT INTO nce_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kwe bu Jisasme tako soso memotlola. Na Jisas bume lo mago hehë tletëme, “Sobo kë mago këkle ekako na eyeumo.” Na Jisas kë nëba bolijayaname botaname na bubë lowene esogo mëglelëtlabë ho aomalë, këme fwa tlelëkakume, nëba mogo këme egëbebë lowa. ");
INSERT INTO nce_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Na Jisas toba mëta fa tëta na bubë galina megali tolë, “Talita kumi.” Ebë galibë wayo melëgëbelalële, “Mësenëba tokwëfo, bo jume gali nolë, ju huju ele!” ");
INSERT INTO nce_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Na bu lahujuwa tle na kë lo mëta asë tëbelëfa. Kë nëba bu we ita tële tlibutu këniji tafa tle. Na bu këme hwi mëtla, na klelego memëtla. ");
INSERT INTO nce_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Na Jisas bume gali tlome, “Sobo ebë wesibi ho lime asa gali elolo. Na sobo bume hi wesibi elëyome.” ");
INSERT INTO nce_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisas kë lifate kile tle na bubë lifatewa Nasaretwa tuju. Na bubë lowene esogo mëglelëtlabë ho nagi mëtlëla. ");
INSERT INTO nce_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tafawa olëna bu lotu lowa tuju na bu Gotobë gali onehome mana të tëtatëme. Na lebutako oneho, bu kë gali aholokwane motlola, na bu klelego memëtletla na gali mëtla, “Kë ho bu kë gali na kë lowene hamago fa lotlene? Na bu kë tiho wesibi na kë klelegowa wesibi bu melë kë logotomebë, habelë lalotomene? ");
INSERT INTO nce_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Sebo melowene nanëletla, ‘Kë ho bu lo gliji howa. Bu Mariabë nëba. Na bu Jems, Josep, Judas, Saimon nabë bolijahafe. Na bubë bomolunino bu sebona tafa nëlafe. Bu sebobë life mago hofe na bu kë lowene hamago fa lotlene?’ ” Bu megali mëtla, na bume tëboijiwa memëtletla. ");
INSERT INTO nce_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kwe Jisas bume gali tlome, “Iniwa fli life mago oneho bu Gotobë lowene mago gali të lotokweflebë home tole mletla na gali mëtla, ‘Kë ho bu lale homu.’ Kwe bubë life mago oneho, na bubë ilawa mago oneho, na bubë weife mago oneho bume tole hana mletla na bu melowene hana mletla, ‘Bu lale ho.’ Hanane mu.” ");
INSERT INTO nce_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Na Jisas bu kë life mëta feilawa klelegowa wesibi blëge hana totometëme. Hanane. Bu jowa, jowa tëbo atona onehome fwa, toba gwa tëtagutëme na sle totome. ");
INSERT INTO nce_vpl VALUES ("MK6_6a","071_6_6a","MRK","6","6a","6a","Na bume kë lowene sle jwa mëgletlabë onehome tako tutune latletëmemu. ");
INSERT INTO nce_vpl VALUES ("MK6_6b","071_6_6b","MRK","6","6b","6b","Na kwe Jisas bu kë lifate mëta gali të tëbetokwakle. ");
INSERT INTO nce_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Na Jisas bubë lowene esogo mëglelëtlabë ho we ita tële kënijime gali telokwakëme na bu mitisitla. Na bu tlemalë tlemalë home jine tëbelëkakëme. Na bu wesibi fenene blëge lotome, këha afutuku bume gwa tëtatëme. Bu ahwane onehobë ato mago kë afutukuna hehë namëgletëmame. ");
INSERT INTO nce_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Na bu këme mana tafa mëtla, na gali tlome, “Sobo egëyeuna, sobo feilawa wesibi asa ehoujo, asë lijiwa egehoujome. Sobo hi wesibi, musu, baliti musuna asa ehoujo. Matëbe. ");
INSERT INTO nce_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Na sobo juba jibowa ehwëyome, kwe sobo hihijika ëho asa ehoujo. Ato mago ëhowa egehoujome.” ");
INSERT INTO nce_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Na bume ita gali tlome, “Sobo li lifatewa tuhu egulona na ho some no lëglëyona, sobo kë lo mëta fwa tafa elome. Sobo kë lo mëta tafa egelobëë, na ita mana eyeume. ");
INSERT INTO nce_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Na sobo li lifewa tuhu egulona na ho some nëno hana mëglana na sobobë gali aholokwaneme tole hana mëglana, kwe sobo kë life lakilewa elome. Sobo kë life kile egelona, kwe sobobë juba mago flëke bubë naba li mëta bu elome. Bu some këme hwi mëlëyome na melowene namëglame, ‘Fëyeme tëbo nilitayane? Goto seme tëbo lëgëtanamefe.’ ” ");
INSERT INTO nce_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Na kwe bubë lowene esogo mëglelëtlabë ho mana mutuja. Na bu iniwa onehome megali mëtlaguma, “Sobo tëbo lowene aholokwana ti elome na lale lowenewa esogo elelëlome.” ");
INSERT INTO nce_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Na bu feilawa ahwane, onehobë ato mago hehë mëtlagumetëma. Na bu lëkaluwa welë tu tëbo atona onehome tefo mëtëtagumetëma na bume sle mototoma na bu lalowa tafa mëtla. ");
INSERT INTO nce_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Iniwa lifatebë oneho, bu Jisas onehome kë sle togotomebë gali waaholokwane motokouja. Na eso ho Herot bu kë gali mata aholokwane tle. Fli oneho bu megali motokouja, “Jisas ebë kwe, onehome kë baptais togotomebë Jon, tekwe nëge, matëmatë mago huju tle. Këme nëgeme, kë klelegowa wesibi melë blëge këme lotome.” ");
INSERT INTO nce_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Na fli oneho megali lamëtla, “Ebë kwe, Elaija tekwe nëge, matëmatë mago huju tle.” Na fliye kwe megali lamëtla, “Ebë kwe, Gotobë lowene mago gali të lotokweflebë ho, tekwe nëge, matëmatë mago huju tle. Bu ëtanifu Gotobë lowene mago gali të motokweflabë ho fenene.” ");
INSERT INTO nce_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Na eso ho Herot bu kë gali aholokwane tle na gali tle, “Bu home kë baptais togotomebë Jonfe. Ëbame bu wame home boblo logotomebë home gali tlole, na bu tuju na Jonme mou lokwati tlë tujetle. Na bu matëmatë mago wahuju tle.” ");
INSERT INTO nce_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Ëtani eso ho Herot bu bolijamobë, Filipbë, mëseme hijika totle. Kë mësebë weniji Herodias. Jon Herotme itaita megali latlokwefle, “Blijamobë mëseme kë hijika egotlebë, kë lale lowene nane. Weye.” Këme nëgeme, Herodias bu Jonme tako enisusu latletlemu na bume mogo nalë tëkleme tole tletle. Herodias bu Jonme wame togloleme nëgeme na eso ho Herot bu home këme jine tlële, Jonme senë tabana lei lotleme na kalabusu lowa tuku lëleme, Herodias bume tëkle egotlelime. ");
INSERT INTO nce_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Eso ho Herot bu Jonme melowene latletle. “Bu lale homu na Gotobë lale lowene esogo lëglelëtlebë ho.” Na bu Jonme uli këme tletle na bume ululu sle këme totle, bubë mëse Herodias tëkle egotlelime. Bu Jonbë gali yafe aholokwane tlole, maninibona tëbo metletle na tako tutune metle. Kwe bu Jonme aholokwaneme tako tole latletlemu. ");
INSERT INTO nce_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Na kë nalëwa, eso ho Herot bu feilawa hi wesibi loko tëtamë, bota bume këna fu totlebë olëna fleflesu hi nalëglelëmeme. Na Herodias bu melowene sle latle, “Bo metole nanelë, kë fleflesu hi nalë, Jonme mana tëkle nogotlëme, mogo nalë.” Na Herotbë gavmanbë eso ho, na wame home boblo mogotomabë eso enëne na Galili provins magobë letitabo ho bu kë fleflesu wesibi hime mitisiya. ");
INSERT INTO nce_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kë enëne bu mana hi motokouja na Herodias boko mana tisi tëme, elefi naegleme. Na kë layo mëse bu elefi tle. Na eso ho Herot na buna kë hi mëtlabë ho bu kë elefi hwi motlotëya, mëmaune lamëtlëtëyamu na bubë elefime tako fleflesu memëtletëya. Na eso ho bu kë layo mëseme këme gali tolë, “Ju fëye wesibi tole eletlene? Ju wesibi tole laletlëye, bo jume kë wesibi nëglëme.” ");
INSERT INTO nce_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Na eso ho Herot bume iniyafememu gali tolë, “Bo jume nëgali galimemu gali nolë. Ju wesibi tole laletlëye, bo jume kë wesibi nëglëme. Na ju metole eglena, bobë iniwa wesibi fu notometëme na jume nëlëme, na bobë lifate mata tlë nëtatëme na jebelëfu jume yo nolëme, ebë lalowa, bo tako tolemu nanelë.” ");
INSERT INTO nce_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Na kë layo mëse bu tuju na botame takune tolë, “Bo bume fëye wesibime gali noglolëmene?” Na bota këme gali tolë, “Ju bume, home kë baptais togotomebë, Jonbë esome gali eglonëme, kë eso nalëglëme.” ");
INSERT INTO nce_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Na këme kë layo mëse bu eso ho belë ita hokweinawa tuju na gali tlole, “Bo metole nanelë, ju eli, home kë baptais togotomebë, Jonbë eso mou lokwati tlë etatle, na kë eso bletë ëhou mëta tuku elëme na kë manogwa bome enënëme, hwi nanoglolëme.” ");
INSERT INTO nce_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Eso ho bu kë gali aholokwane tolë na bu tako maninibo metle. Kwe bu kë hi tëglelëmebë oneho, bubë iniyafe gali aholokwane motlolame nëgeme na bu këme tiniji tletëme. Këme nëgeme bu kë mësebë gali hana boblo lëtatëme. ");
INSERT INTO nce_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Na këme, bu wame home boblo logotomebë home, gali tlole, “Ju ejume, na Jonbë eso mou lokwati tlë etatleme na bome ehitenëme.” Na kë wame home boblo logotomebë ho, bu kalabusu lowa tuju na Jonbë eso mou lokwati tlë tëtatle. ");
INSERT INTO nce_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Na bu Jonbë eso bletë ëhou mëta gwa tëtatle na tehile na layo mëseme tlëkakiji. Na layo mëse kë eso tehule na botame tujuwelë. ");
INSERT INTO nce_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Na Jonbë lowene esogo mëglelëtlabë ho bu Jonme kë tëke toglolebë gali aholokwane mëtla na bu mutuja na Jon mogome fa mototla na aniji fuluju matëmatë mëta gwa mutujetla. ");
INSERT INTO nce_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jisas, Gotobë gali tëme kë jine tëgelëkakëmebë ho, ita mitisiya na Jisas mëta loko mëtlelëkakëjaya. Na bu iniwa wesibi kë mëtlabë na onehome kë të mëtëtagutëmabë gali Jisasme të mëtëtatla. ");
INSERT INTO nce_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kwe feilawa oneho mitisikefëtëmame nëgeme na Jisasna bubë lowene esogo mëglelëtlabë hona bu kë nalë këme haha tafu hana mototla na hi hana mëtla. Na Jisas bubë lowene esogo mëglelëtlabë home këme gali tlome, “Te, mana manuja, hojwa tabo elë. Tafa sle nanëglame.” ");
INSERT INTO nce_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Na bu ihe mëta fëfe mëtla na buwa hojwa tabo elë mutuja. ");
INSERT INTO nce_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Na feilawa oneho bu hwi mëtlaguma na lowene mëtla, “Jisas lalëlelumefe, bubë lowene esogo mëglelëtlabë home.” Na këme nëgeme lilife lilife mago oneho bu Jisasna kë mutujabë life elë këme fëka motokouja na kë lifewa bu afina fwa mutula. Na Jisas bubë lowene esogo mëglelëtlabë home nagi fwa tulelëme. ");
INSERT INTO nce_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Këme nëgeme, Jisas bu jelëfowa fwa tule na bu kë feilawa onehome hwi tlome. Bume mehwi latlome. Bu sipsip kleli, ho lëglëme jwabë fenene. Ho bume hana taitame. Na bu bume tako maninibo këme tletëme. Na bume feilawa gali të tëtatëme. ");
INSERT INTO nce_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tokwafe, taboklë mu, Jisasbë lowene esogo mëglelëtlabë ho bu belë mitisiya na bume gali motlola, “Ebë taboklëmu na ebë hojwa life. Sebo hi wesibi hamago fa nogotlamene? Hanane mu. ");
INSERT INTO nce_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Te, ju onehome mana jine ebelëkakëme. Loli life elë fwa matliwaya, hi wesibi balitina glo namëglame.” ");
INSERT INTO nce_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kwe Jisas bubë lowene esogo mëglelëtlabë home gali tafu tëtatëme, “Hi wesibi bume sobo eglëmome.” Na bu Jisasme takune motlola, “Ëëë, ju melowene lalene, ‘Sebo bletë nage 200 balitina glo nëlamene na bume nëlëmame?’ Sebo këha baliti hananefe.” ");
INSERT INTO nce_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Na bume takune tlome, “Habenuju bletë nage mëbetëyone? Sobo hwi ejuwelëmo.” Na bu hwi mutujuwelëma na ita mitisiya na Jisasme gali motlola, “Sebo tobali bletë nage mëbe na mo tële mëbe.” ");
INSERT INTO nce_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Na Jisas bume gali tlome, “Sobo lale agosaba mëta loko elagujome na tafa ekoujome.” ");
INSERT INTO nce_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Na bu iniwa tafa motokouja. Fli tafa mëtlabë we lujuafe we oneho na fli tafa mëtlabë 50 oneho. ");
INSERT INTO nce_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Na Jisas kë tobali bletë nage na tële mo glo tle na hwi tokwake na Gotome lale gali tlole, “Ebë bletë nagena mona yaha fëyeme enënane?” Na bu klelegowa wesibi blëge totle na kë bletë nage fufu totome na bubë lowene esogo mëglelëtlabë home tlëme, onehome sa namëgëtatëmame. Na bu kë tële mo mata fufu totome na sa mëtëtagutëma. ");
INSERT INTO nce_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Na bu iniwa hi mëtla na imo sosolo mototoma. ");
INSERT INTO nce_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Na bu bletë nage lënena, mo lënena we ita tële basketë musu mëta mëtëselokwaya. Na kë basketë musu ëfowa lakalewa mëtle. ");
INSERT INTO nce_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Feilawa oneho bu kë bletë nage hi mëtla na hobë tabëi kë niji 5,000 bu onename nëbalename hana tabei mëtla. ");
INSERT INTO nce_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Na kë nalëwamu, Jisas bubë lowene esogo mëglelëtlabë home, gali tlome, “Sobo ihe elë fëfe elome na jelëfo elë Betsaida lifatewa su ekakome.” Na bu iniwa onehome jine tëbelëkakëme. Buwa lëtabe nalëgleme. ");
INSERT INTO nce_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Onehome afina jine tëbelëkakëme, na bu fatiniwa tokwale, Gotome gëgali nalogolelëleme. ");
INSERT INTO nce_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Na atome hwi olëna, bubë lowene esogo mëglelëtlabë ho lake tu ku mëta ihena kakëha mëtemula na Jisas lake tu helefo mëta tlibe. ");
INSERT INTO nce_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Na Jisas bu hwi telokwakëme, bu ihena yafe yegu motokouja, kwe flelu ihe yelu boblo tëgëtatëmeme nëgeme, na ihe alabuju këme tiwatëme. Tokwafe, fole olëna Jisas lake tu matawa wa bu belë tisi tëme. Bu sigli lëgetokwakëmeme kofene. ");
INSERT INTO nce_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kwe bubë lowene esogo mëglelëtlabë ho bume hwi motlola, tu matawa wa asë tole. Na bu meweniji lamëtla, “Alibahowa.” Na bu afëfleina memëtla. ");
INSERT INTO nce_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Na iniwa bume hwi motlola na uli memëtla. Kwe Jisas bume hokweinawa gali tlome, “Sobo uli asa elo. Bo tekwe nëge. Sobo lalowa tafa elo.” ");
INSERT INTO nce_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Na bu ihewa fe tokwake na buna mëtëtabëya. Na flelu latliwa tëkake. Na bu klelego memëtla. ");
INSERT INTO nce_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jisas tobali bletë nage feilawa onehome sa tëtatëmena, bubë kalëlego olafa tëtatëme. Kwe bubë lowene esogo mëglelëtlabë ho kë lowenebëme lowene sle hana mëtletla, aholokwana timu mëtla. Këme nëgeme tu matawa wa kë asë tëglebë na flelu kë tli tëgëbebëme klelego këme mëtletla. Bubë lowene mana yaya tletëmemu. Bu bubë kalëlego, lowene sle jwa mëgletlame nëgeme. ");
INSERT INTO nce_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jisas, bubë lowene esogo mëglelëtlabë hona, lake tu su mëtëkaka na Genesaret lifatewa fwa mëtëtëkekëya na ihe kesi mëtëtaya. ");
INSERT INTO nce_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bu ihe mago, helefo elë fëfe motokwaka, na hokweinawa oneho bu Jisasme hwi motlola na weniyane mana mëtëselëla sle mëtla. ");
INSERT INTO nce_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Na ho bu kë lifate li mëta kë lëgëbagubë lifatewa fëka fëka mëtëbelëfaya na onehome gali mëtlaguma. Na oneho, bu Jisas kë tafa tuglebë gali, aholokwane mëtla na bu tëbo atona onehome sanëneme gogwa mëtla na bu belë mëtlesuma. ");
INSERT INTO nce_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Na iniwa tatako lifate elë na tokwëtokwë lifate elë Jisas bu kë tuhu tokoubë, oneho kë mëta loko mëglelëkefëyabë lifeku elëme, tëbo atona onehome kë belëme mëtleluma. Na bu Jisasme anisasana gali motlola, “O masiwafe, kë tëbo atona oneho, jubë ëho mëta fwa lalowa lu mëtomene, sle namëglame.” Na iniwa oneho melë kë mëtlabë, bu laslewa mëtla. ");
INSERT INTO nce_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisi enëne na Gotobë tafa sle gali lowene sle mëgletlabë enëne fli, Jerusalem lifate mago kë mitisiyabë, bu Jisasme loko mëtlelëtla. ");
INSERT INTO nce_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Na bu mehwi motloma, Jisasbë lowene esogo mëglelëtlabë ho fli, bu hi wesibi hi mëtla kwe bu toba afina swa swa hana motoma, bosemlenibë tafa sle gali fene lëbetëme. ");
INSERT INTO nce_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisi enëne na fli Juda life mago enëne bu bubë bolijafujunibë lowenewa esogo mëtlelëtëma. Bu melowene mëta tafa mëtla. “Toba afina swa hana motomana, bosemlenibë tafa sle gali fene tëbetëme, kwe bu hana hi mëglame.” ");
INSERT INTO nce_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Na bu maketwa mugujana na migisiyana na tu tetefo jwa mëglana, bosemlenibë tafa sle gali fene tëbetëme, kwe bu hana hi mëglame. Na bu lili lowene mëta tafa mla, bosemleni fenene tafa mëtla. Bu mëlamelekefëya, bu blete, kabo, sospenë, na ni labuku mata swa motokwefëma. Bu bosemlenibë lowenewa esogo metlelëtëmame nëgeme. ");
INSERT INTO nce_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Na Farisi enëne na Gotobë tafa sle gali lowene sle mëgletlabë enëne, bu Jisasme takune motlola, “Jubë lowene esogo mëglelëlabë ho bu sebobë semlenibë lowene esogo jwa fëyeme mëlelëlane? Bu hi wesibi manawa fëyeme hi mëtlekefëyane? Bu toba afina swa hana motomana, bosemlenibë tafa sle gali fene lëbetëme.” ");
INSERT INTO nce_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Na Jisas bume gali tlome, “Ëtani anebo, Gotobë lowene mago gali të totokweflebë ho, Aisaia, bu some nëgali galime gali tolëyo. Sobo sosogëna hofe bu fene yahi tle. Bu Gotobë gali meyahi latle, ‘Kë oneho bu bome bubë ëfalëbo nawa mefë mëgëtanana, “Goto lale homu.” Kwe bu bome bubë lowenena iniwa tole hana mëtletëna, na lowenena, lowene sle hana mëtletënamu. ");
INSERT INTO nce_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bu melë lamëtla, bu onehobë tafa sle galiwa të mototokwefla kwe mesosogëna lamotloma, “Kë tafa sle gali ebë Gotobë gali.” Bu bome megali kë moglonabë, “Goto ju lale ho, sebo jume tako tole nanëletëyo,” kwe bome lowene sle hana mëletëna bubë lowene mëta. Këme nëgeme bu kë galina bome blawa gali molona.’ ” ");
INSERT INTO nce_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jisas ita megali tle, “Sobo Gotobë tafa sle gali aholokwana wati telo. Eholo hana elo. Na sobobë bisemlenibë lowenewa eholo. Sobo Gotobë gali, bisemlenibë lowenena lëlamu latatelo.” ");
INSERT INTO nce_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Na Jisas bume fli gali megali latlome, “Sobo Gotobë tafa sle gali kaiselo boblo etokweflo na sobobë lowene mëta fwa etabo. Sobo kë lowene tako lëbeteyo. ");
INSERT INTO nce_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ëtanifu ho Moses gali tle, ‘Sobo bitaname, blijayaname boblo asa etomo na bubë galiwa esogo elëlëtemome.’ Na bu li gali megali tle, ‘Ho botaname o bolijayaname tëbo gali loglomena kwe ho bume mogo nalë tëkle mogotlame.’ ");
INSERT INTO nce_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Moses kë gali megali latlëyo kwe sobo megali latlekefo, ‘Ho bolijayaname botaname megali loglomena kwe ebë lalowa, “Ayana beëna masiwafe, ebë wesibi some nëgaitome fene kwe bo ebë wesibi Gotome wafi aniji tlometelëfe.” ’ ");
INSERT INTO nce_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ho bu kë gali, bolijayaname, botaname gali loglomena, na bu botaname, bolijayaname, lëgaitame jwa nëgena sobo megali egelome, ‘Ebë lalowa. Bu Gotome wafi aniji tlometle.’ ");
INSERT INTO nce_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Sobo kë gali megali egelona, sobo bisemlenibë lowene mago galiwa të etatemo na Gotobë gali këna lëlamu latlo. Na sobo feilawa tëbo wesibi këha memelë latokwefëmofe.” ");
INSERT INTO nce_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Na Jisas onehome gali telokwakëme na bu mitisitla na bume ita gali të tëtatëme, “Sobo iniwa aholokwane elome na lowene sle eletelome. ");
INSERT INTO nce_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Iniwa wesibi, ho bu kë hi mëglekefëyabë, kë wesibi Gotobë naba lime home tëbo hana mogotomeme. Hanane. Kwe wesibi hobë lowene mëta kë lëgelubebë na lëkaklibë, kë wesibiwa Gotobë naba lime home bu tëbo motomeme. ");
INSERT INTO nce_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ho bu aholona, bu ebë gali sa aholokwane sle lële.” ");
INSERT INTO nce_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jisas kë onehome hune totome na bubë lowene esogo mëglelëtlabë hona lowa mëtëkakluja. Na bubë lowene esogo mëglelëtlabë ho bume kë waflë gali wayome takune motlola. ");
INSERT INTO nce_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Na bume gali tlome, “Sobo mata wayo gali yaya laletelone? Sobo kë waflë gali lowene hana elone? Sobo aholokwane elo. Iniwa wesibi, ho bu kë hi mëglekefëyabë, kë wesibi Gotobë naba lime home tëbo hana mogotomeme. ");
INSERT INTO nce_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Këha wesibi hobë lowene elë nane muju. Weye. Bu aliji elë fwa muju na gu namela. Këme nëgeme bu home tëbo hana mogotomeme.” Jisas bu kë galina seme melë lëlekuju latletëna, sebo lalowa iniwa hi wesibi hi nëglame. Hi wesibi bu seme Gotobë naba li mëta hana tëbo mëgëtaname. ");
INSERT INTO nce_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Na Jisas bu ita gali tle, “Wesibi hobë lowene mëta lëgelubebë na lëkaklibë, kë wesibi Gotobë naba lime home buwa tëbo mogotomeme. ");
INSERT INTO nce_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Bo këme gali nelë, hobë lowene mëta kë lelubebë wesibi bu melë: Tetëbo lowene, lisë lowene, tokli lowene, home mogo nalë tëkle lowene, ");
INSERT INTO nce_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","hona mëseme lisë eglelëbë lowene, mëmaune lowene, sosogëna lowene, aholabu lowene, gëglë lowene, li home gali fa lowene, home agalëklebë lowene na yayaha lowene. ");
INSERT INTO nce_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kë iniwa tëbo lowene, hobë lowene mëta melubetëme na mëkakli na Gotobë naba lime home bu tëbo motomeme.” ");
INSERT INTO nce_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jisas, bubë lowene esogo mëglelëtlabë hona, kë lifate kile mëtla na Tair lifatebë tokwëfo lifekuwa mutuja. Bu fwa mutula na Jisas bu li lowa hwelutuwa tëkaklu, oneho bume sosalë mogotlalime. Kwe bu mogweliha hana tafa lëgleme, oneho bume wahwi motlola. ");
INSERT INTO nce_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Na mëse li bu megali aholokwane tlome, “Jisas bu lo mëta kë tafa lële.” Na bu hokweinawa bu belë tuju tle. Ahwane tëbo kë mësebë nëbabë ato mëta lëtabetëme nëgeme na bota Jisas belë hokweinawa këme tisi tle na elebo lime bubusu tletle. Na bu Jisasme anisasana gali tlole, “Jisas, ju ahwane tëbo bobë nëbabë ato mago kë elëkakëtë.” Kë mëse bu li lifate mago mëse. Bu Siria lifate mago na bubë lifekumu Fonisia. Bu Juda lifate mago mëse hanane. ");
INSERT INTO nce_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Na Jisas bu melowene latle, “Juda life mago oneho bu nëbaleha na fli life mago oneho bu amale ha. Na bo Juda lifate mago onehome afina naitamëme.” Na bu kë mëseme waflë gali latolë, “Bo nëbalebë hi wesibi amaleme afina hana nëglëmëme. Weye. Bo nëbaleme afina nëlëmëme.” ");
INSERT INTO nce_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kwe kë mëse bume gali tafu tëtatle, “O tako ho, jubë gali nëgali gali. Kwe ama mata, lo malu mëta kë tafa mëlekëfebë, bu nëbalebë lëne hi wesibi, kë mitigokëfebë mehihi mëlekëfe. Na ju bome mata lëne hi wesibiha aitane.” ");
INSERT INTO nce_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Na Jisas bume gali tolë, “Ju bobë gali lale lowenena tafu etatenëfe. Këme nëgeme, kë ahwane tëbo jubë nëbabë ato mago wakile lëtamë, jubë lowa ita lalowa ejume.” ");
INSERT INTO nce_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Na kë mëse bubë lowa ita tuju. Na bubë nëba ni labuku mëta hwi tolë na bu lalowa tafa tletë. Kë ahwane bume wakile tëta. ");
INSERT INTO nce_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kë nalëwa Jisas Tair lifatebë tokwëfo lifeku kile tle na Saidon lifate sigli tëtagule na Dekapolis provins sigliwa tëtagule, na Galili lake tu elë fwa tule. ");
INSERT INTO nce_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Na bu aholo titiji tabo na gali mumu tabo home bu belë mëtlesula. Na bu Jisasme anisasana gali motlola, “O masiwafe, jubë toba kë hobë ato mëta gwa etatle, sle nalëgleme.” ");
INSERT INTO nce_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Na Jisas kë home no tlële na onehome hune mëtelo. Na Jisas toba ku bubë aholo fuluju elëme sei tlëmetle. Na tokwafe bubë toba ku mëta nagutaba tihele tle na kë hobë aleji mëta gogwa tletle. ");
INSERT INTO nce_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Na Jisas heven lifewa hwi tokwake, na tako maninibo lowenebë haha tafu totle. Na bu kë home, bubë galina, megali tlole, “Efata.” Kë galibë wayo melë lëgëbelalële, “Tika eletelo.” ");
INSERT INTO nce_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Na kë hobë aholo latikawa metletle na bume gëgali lëglebë lowene tisitle na bu lalowamu gëgali tle. ");
INSERT INTO nce_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Na Jisas onehome hehë latletëme na fli onehome gali moglomalime, “Bo kë nogotlëbë wesibime fli onehome asa gali elomo. Matëbemu.” Bume yafe hehë tletëme, kwe bu boblo lamototla, na Jisas togotlebë wesibime gëgali motokoutla. ");
INSERT INTO nce_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Na oneho kë hobë sle gali, aholokwane mëtla, na klelego memëtletla. Na bu gali mëtla, “Euowe! Iniwa wesibi bu melë kë lotomebë, lalowamufe. Bu aholo titiji tabo hobë aholo titika lotometëme na gali mumu tabo enëneme mata sle lotometëme.” ");
INSERT INTO nce_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kë olëna, feilawa oneho Jisasme ita loko mëtlelëtla. Na bu hi wesibi hanane. Na Jisas bubë lowene esogo mëglelëtlabë home gali telokwakëme. Na bu mitisitla. Na Jisas bume gali tlome, ");
INSERT INTO nce_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Bo ebë onehome maninibo nanëletëmë. Bu bona aona olë tafa nëla na bu hi wesibi jwa. ");
INSERT INTO nce_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Na bo bume fonoba jine nëgelëkakëmëna, kwe bu alëgeme foneme nabasahoba mëglame na migitigwëyame. Fli bu kakë mago mitisiyame nëgeme.” ");
INSERT INTO nce_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Na bubë lowene esogo mëglelëtlabë ho, bume takune motlola, “Sebo hi wesibi hamago fa nogotlamene, kë onehome kë nëglëmame? Ebë afloko mëta ho tafa jwa, mëglame nëgeme.” ");
INSERT INTO nce_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Na Jisas bume takune tlome, “Sobo habenuju bletë nage mëbetëyone?” Na bu megali motlola, “Sebo tobali ita tële kënijiwa nehwëyafe.” ");
INSERT INTO nce_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Na Jisas onehome gali tlome, “Sobo tafa ekoujome.” Na bu kë tobali ita tële bletë nage glo tle, na Gotome gali tlole, “Weë, ebë bletë nage, yaha fëyeme enënane.” Na bu klelegowa wesibi blëge totle na kë bletë nage fufu totome na bubë lowene esogo mëglelëtlabë home tlëme. Na bu onehome sa mëtëtagutëma. ");
INSERT INTO nce_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Na bu tëlewa mo mata mëtehwëya. Na Jisas bu kë mo glo tle na Gotome gali tlole, “Weë, ebë mo yaha fëyeme enënane.” Na bubë lowene esogo mëglelëtlabë home gali tlome, “Sobo ebë mo mata, onehome sa etatemo.” Na bu kë mo mata sa mëtëtatëma. ");
INSERT INTO nce_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Na oneho bu yafe hi mëtla, kwe bubë imo sosolo mototomame nëgeme, na lëne mana sigenë metletëme. Na kë lëne hi wesibi mëtëselokwaya na bu tobali ita tële basketë musu tëtafu mototoma. ");
INSERT INTO nce_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kë onehobë tabei këniji 4,000. Na Jisas onehome jine telëkakëme. ");
INSERT INTO nce_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Na kwe, bubë lowene esogo mëglelëtlabë home ihe mëta fe tlelëme, na Dalmanuta lifate elë mutuja. ");
INSERT INTO nce_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bu Dalmanuta lifatewa fwa mutula na Farisi enëne bu Jisas belë mitisitla na mana Jisasna kofe kofe gali mëtlelogwaya. Bu Jisasme sogëname su namogotlame fene na gali motlola, “Ju seme klelegowa wesibi li lebotane etatëna. Sebo jume melowene nanëgletëyome, ‘Goto jume kë jine tëgelëbakëbë hofe.’ ” ");
INSERT INTO nce_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Na Jisas wabelë tle na gali tlome, “Sobo, ebë olëna kë tafa egelobë oneho, bome klelegowa wesibi lebotane nogotlëbëme, fëyeme takune enonane? Bo some nëgalimu nanëlëyo, bo klelegowa wesibi lebotane hana nogotlëme, sobo melowene naegletëname, ‘Goto bome jine tlënëfe.’ Matëbe mu.” ");
INSERT INTO nce_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Na bume hune mototoma, na ihe elë fëfe mëtla, lake tu jelëfo elë su namëkakame. ");
INSERT INTO nce_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Bu lake tu mëta mana mëtemula na bubë lowene esogo mëglelëtlabë ho bletë nage mëtehouja hana mëtla, aholokwana ti memëtla. Bu jowa bletë nagewa, ihe mëta tëbe. ");
INSERT INTO nce_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Na Jisas anisasana gali tlome, “Sobo Farisi enënebë na Herotbë bletë nage sëse wesibime ululu sle saelo.” ");
INSERT INTO nce_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Na kwe bubë lowene esogo mëglelëtlabë ho bu blalo gëgali mëtla, “Bu kë gali fëyeme gali lëlene? Sebo bletë nage nëgehwëja jwa nëglame nëgeme na bu këme gali lëlenawa.” ");
INSERT INTO nce_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Kwe Jisas bubë gali walowene tletëme, na bume megali tlome, “Sobolalo megëgali fëyeme elone, ‘Sebo bletë nage alujawa.’ Sobobë lowene lëgëbetëyo hana lëlene? Hee! Sobobë lowene yaya lalëletëyone? Hee! ");
INSERT INTO nce_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Sobo nabana, kwe sobo hwi hana elomo. Na sobo aholona, kwe sobo aholokwane hana elo. Bo bletë nage kë sa tëgëtatemëbë lowenebëme, lowene hana elone, aholokwana fëyeme ti telone? ");
INSERT INTO nce_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ëbame, bo tobali bletë nage 5,000 home kë fufu totometemëbë, lili kë mëglebë bletë nagena, habenuju basketë musu tëtafu totomone?” Na bu gali motlola, “Basketë musu we ita tële këniji.” ");
INSERT INTO nce_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Na ëbame, bo tobali ita tële bletë nage 4,000 onehome kë fufu totometemëbë, lili kë mëtëglebë bletë nagena, habenuju basketë musu tëtafu totomone?” Na bu gali motlola, “Basketë musu tobali ita tële këniji.” ");
INSERT INTO nce_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Na bu gali tlome, “Sobo kë wesibi wahwi tlomofe kwe sobo aholokwana fëyeme ti elone, bo some këha wesibi melë lalowa nëgetatëyome.” ");
INSERT INTO nce_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jisas, bubë lowene esogo mëglelëtlabë hona, Betsaida lifewa tuhu mëtla. Na naba titiki tabo home bu belë mëtlesula. Na Jisasme anisasana gali motlola, “Masiwafe, ju ebë home toba gwa etatle, sle nalëgleme.” ");
INSERT INTO nce_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Na Jisas kë naba titiki tabo hobë tobame fa totle na bume lifeku mëglëbo elëme fe tlelëkakle. Na bubë naba mëta nagutaba tihele tletle. Na bu toba kë home gogwa tletle na takune tlole, “Ju wesibi hwi elome o hanane?” ");
INSERT INTO nce_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Na kë ho hwi tle na gali tlole, “Bo home asëna mehwi nanolomë kwe bume ti fene hwi nolomë.” ");
INSERT INTO nce_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Na Jisas toba bubë naba mëta ita gogwa tletle. Na kë ho ita hwi tëkake, na bubë naba lalowa mëtëbetle. Bu iniwa wesibi hwi sle tlagume. ");
INSERT INTO nce_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Na Jisas bume bubë lowa jine telëkakle. Na gali tlole, “Ju lifeku elë asa ekaklu.” ");
INSERT INTO nce_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisas bubë lowene esogo mëglelëtlabë hona, Sisaria Filipai lifate li mëta kë mëgëbagubë lifatewa asë mëtëbelëfaya. Bu alëge mëta mana asë mëtla, na mana takune tlome, “Oneho bome habelë lowene lamëletënane?” ");
INSERT INTO nce_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Na bu gali metafu mëtëtatla, “Fli howe megali lamla, ‘Onehome kë baptais togotomebë Jon, tekwe nëge, matëmatë mago huju tle.’ Na fliye megali lamla, ‘Elaija, tekwe nëge, matëmatë mago huju tle.’ Na fliye megali lamla, ‘Ëtanifu Gotobë lowene mago gali të totokweflebë ho, tekwe nëge, matëmatë mago huju tle.’ ” ");
INSERT INTO nce_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Na Jisas bume takune tlome, “Na sobo ee, sobo bome habelë lowene lalone?” Na Pita bubë gali tafu tëtatle, “Ju ebë ho kë nëgebë, Goto jume kë aniji tëglebë ho, onehome nëno naegleme.” ");
INSERT INTO nce_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Na Jisas bume meheheë latletëme, “Sobo kë galibëme onehome asa gali elomo. Matëbe.” ");
INSERT INTO nce_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jisas bubë lowene esogo mëglelëtlabë home, meokokwe sle wafi tlome, “Tokwafe bome, Gotobë life mago home, lebutako elili na hobota migisitenëme na bo kë mëta tafa nelëme. Na lotu letitabo ho na Gotobë lo mëta wege mëglabë eso enënene, na Gotobë tafa sle gali lowene sle mëgletlabë ho, bome hehë mëgletëname na mogo nalë tëkle mëtaname. Na bo tële olë nebëme kwe aona olëbëye huju nëgelëme.” ");
INSERT INTO nce_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Na bu kë gali të sle tëtatëme. Na Pita Jisasme mëglëbo elë fe tlelëkakle na bume anisasana këkale tlole, “Ju këha gali fëyeme gali elene? Kë galime asa gali ele. Matëbemu.” ");
INSERT INTO nce_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Na Jisas swaya tokoketëme na bubë lowene esogo mëglelëtlabë ho flime hwi tlome na Pitame anisasana këkale tlole, “Ju Satanha gali elë. Ju kë mago fe ekake. Ju këha wesibi lowene egletëmena, kwe ju Gotobë lowene mëta nane tafa ele, weye, ju hobë lowene mëta fwa tafa ele!” ");
INSERT INTO nce_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jisas bu onehome na bubë lowene esogo mëglelëtlabë ho name gali telokwakëme. Na bu mitisitla na bume gali tlome, “Ho bome na bobë loweneme esogome tole lëglena kwe bu ebë life magobë lale wesibi, bu kë tole lëgletëmebë, aholokwana timu sle sa lële na glime ulijwamu lëleme. Ho bume wame gali moglolana na bume mogo nalë tëkleme gali mëglana, bu uli jwa lëleme na bome mana esogo lëlenënëme. ");
INSERT INTO nce_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ho bu melowene lëglena, ‘Bo Jisasme esogo nëglelëlëna fli ho bu bome tëbo mëgëtaname.’ Na bu, bubë ato uli lëglelëlena na bome hana esogo lëglenënëna, kwe këha ho bu tëbo liglitame. Kwe ho bu bome lowene lëgletenëna na Gotobë lale anebo galiwa lowene lëgletlena na bubë ato uli hana lëglelëlena kwe kë ho bu hana tëbo liglitame. Ho bu kë home mogo nalë tëkle mogotlana, kë gli sle nane lële, weye, bu unaunalëme lale tafa lëgleme. ");
INSERT INTO nce_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ho bu ebë life mago iniwa wesibi glo lëglena, na kë ho bu hel life mëta tëbo liglitana, kwe kë wesibi bume habëna mëgaitalemene? Weyewa. Hana mëgaitalememu. Bu blawa glo lële. ");
INSERT INTO nce_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ho bu Gotona unaunalëme tafabë, wesibina hihijika lëglemene? Weye. Hanane mu. ");
INSERT INTO nce_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tokwafe, bo kë nëgebë kwe, Gotobë life mago ho, bo ita nigisime. Bo bobë ayabë klijiha, kë u lëglebë elulegona na Gotobë enselna iniwa nigisiame. Oneho bu Gotome tëboijiwa mëgletlame na tetëbo lowene mlame. Na bu mago ho li, bo kë okokwe noglëyobëme na bome tiniji lëgletenëna kwe tokwafe bo nigisina, bo mata kë home kofayame tiniji nëgletelëme.” ");
INSERT INTO nce_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Na Jisas bume ita gali tlome, “Bo some nëgali galime gali nolëyo. So mago emëta kë eglibobë bu mana neme na Goto onehome kë tafa lëgletëmebë olë mana tako kalëlegona fata lëgleme. Na bu kë olë mana hwi mololame.” ");
INSERT INTO nce_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tobali ita jowa olë yawe motlola, na kwe Jisas, bu Pita, Jems, Jon name nëno tle. Na tako fatiniwa tilekome. Na buwa tafa mëtla. Bu Jisasme hwi moglolabë na mana bubë ato li weniyanena hihijika tletle. ");
INSERT INTO nce_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Na bubë ato mago ëho, olëha mëtëbetle, na bu tatiwamu mëtëbetle. Ebë life mago oneho bu ëho itaita swa mogotomana, kwe bu Jisasbë tatiwa ëho fenene këha hana mëtëbetëme. Bubë ëho tatiwamu nëgeme. ");
INSERT INTO nce_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Na bubë lowene esogo mëglelëtlabë ho, bu ëtanifuho Elaijaname, Mosesname hwi motloma, bu Jisasna gëgali mëtla. ");
INSERT INTO nce_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita bu këme hwi tlome, na Jisasme gali tlole, “O Tisa, bo tako fleflesu nanelë, sebo ebë life mëta kë tafa nëglabë. Sebo aomalë, aona afeteni tli lo gigliji nëglame. Li jubë lo, li Elaijabë lo na li Mosesbë lo.” ");
INSERT INTO nce_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kë aomalë ho bu tako uli mëtlame nëgeme, na Pita gali lowene sle jwa tëgleme nëgeme, na bu kë galime blawa këme gali tle. ");
INSERT INTO nce_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Na oloba tetujule na bume iniwa lamu totome. Na Goto kë oloba mago gali tle, “Ebë bobë nëba, bo tako tole nanëletelë. Sobo bubë gali aholokwane elolome.” ");
INSERT INTO nce_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Na bubë lowene esogo mëglelëtlabë ho yafe hwi mëtebokwaka, kwe bu Jisasme kë gëgali mëtlelëlobë home hana hwi motloma. Bu Jisasme fwa hwi motlola. Weniyaneme aotome fene hwi motlotla, këhawa ita hwi motlola. ");
INSERT INTO nce_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bu fatini mago kle mëtëmalitaya, na Jisas bume gali tlome, “Sobo ëje kë hwi eglolobë wesibi lili onehome asa gëgali elelëmo. Awi. Kwe tokwafe bo Gotobë life mago ho, bo matëmatë mago huju nokokwëna, sobo kë hwi eglolobë wesibi li li onehome mana kwe lalowa gëgali elagumome.” ");
INSERT INTO nce_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Na bu Jisasbë gali aholona aholokwane mëtla. Na bu kë gali lowene mëta fwa gwa mototla, na bu li li onehome hana gëgali mëtlelëma. Na bu blalo gëgali mëtla, “Jisas bu matëmatë mago habëna huju lëglemene? Kë matëmatë mago huju lëglebë gali ebë fëye galine?” ");
INSERT INTO nce_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Na bu Jisasme gali motlola, “Gotobë tafa sle gali lowene sle mëgletlabë ho bu fëyeme gali mëlane, ‘Elaija bu afina ligisime na Goto kë aniji toglolebë ho bu nagi ligisime?’ ” ");
INSERT INTO nce_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Na Jisas bume gali tafu tëtatëme, “Ebë gali, nëgali mu, ‘Elaija bu afina lisime na iniwa wesibi sle lotomeme.’ Kwe bu Gotobë bogo mëta bome meyahi lamëtletëna, ‘Gotobë life mago ho, bu lebutako elili fa logotleme, na oneho bume hehë mëgletlame.’ Na bo some takune nolëyo, bu kë gali Gotobë bogo mëta fëyeme yahi mëtlane? ");
INSERT INTO nce_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kwe bo some gali nëlëyo. Elaijaha ho, bu watisife, na oneho bubë tetëbo lowenewa esogo esogo mëtlelëla na bume tetëbo mototla, ëtani Gotobë bogo mëta fene yahi mëtletla.” ");
INSERT INTO nce_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jisas bu kë aomalë lowene esogo mëglelëtlabë home tlelume na bubë lowene esogo mëglelëtlabë ho flime esune mëtlëma. Na bu lebutako oneho hwi motloma, bume hwagënë mototoma. Na Gotobë tafa sle gali lowene sle mëgletlabë ho fli, bu Jisasbë lowene esogo mëglelëtlabë ho flina kofaya kofaya gali mëtlelogwaya. ");
INSERT INTO nce_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Na kë oneho bu Jisasme hwi motlola na klelego memëtletla. Na bu belë fëka motokouja na bume gali motlola, “Lalemu. Yahala fëyeme esine.” ");
INSERT INTO nce_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Na Jisas bume takune tlome, “Sobo buna kofaya kofaya gali fëye wesibime gali elelëgone?” ");
INSERT INTO nce_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Na ho li, bu kë onehona kë mitlijabë bu Jisasme gali tafu tëtatle, “Tisa, bobë iko nëba ahwane tëbo lëtatenë. Kë ahwane bubë ëfalëbo geni lëtatle. Na bo ju belë nëlesulë, sle naegotleme. ");
INSERT INTO nce_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kë ahwane bume itaita feilawa kiki totokwefle, na bume life mëta itaita meenogli enogli latlekëfe. Na bu nënafuna, enino këkëna melatlekëfe. Na iniwa ato toulego metlekefëtle. Na bo jubë lowene esogo mëglelëtëyobë home metakune yafe tlomë, ‘Sobo bobë nëbabë ato mago ahwane këë elekakëtelo.’ Kwe bu yafe këë mëtletla kwe hanane mu.” ");
INSERT INTO nce_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisas kë gali aholokwane tle na bume gali tlome, “O masiwafe, sobo bome lowene sle jwa fëyeme eletënane? Bo sobona habenuju afe olë tafa nëglelëyomene na mana lowene sle eletëname? Bo sobobë hobota habenuju afe olë fa nëgetatëyomene? Kë nëba bo belë elesulo.” ");
INSERT INTO nce_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Na bu kë nëba bu belë mëtlesula. Na kë ahwane Jisasme hwi tlole, na kë nëba anisasana lili tle, na bu lifeme latitigowa, na lifeme obobwelë tle, na nënafu ëfalëbo elë motowelibetle. ");
INSERT INTO nce_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Na Jisas bolijayame takune tlole, “Melë kë lëglekefëbë, habenuju afe olëne?” Na bolijaya gali tlole, “Tokwëfome nëgena, kë gëgëme tëglebëë, mana ekë. ");
INSERT INTO nce_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kë ahwane tëbo bume itaita ahoju mëta na tu mëta metuku tuku latlekëfe, bume tëkle sle nalogotleme fene, mogo nalë. Ju bobë nëba lalowa sle egëtatenëna kwe ju seme maninibo eletëname na aitaname.” ");
INSERT INTO nce_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Na Jisas gali tlole, “Ju megali fëyeme elene, ‘Ju bobë nëba lalowa sle egëtatenëmene?’ Ju bome lowene sle egletenëna, kwe ju iniwa wesibi melë egotomeme.” ");
INSERT INTO nce_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Na kë nëba bolijaya anisasana lagaliwa tlole, “Bo jume tokwëfo lowene nanëletë, kwe ju bobë kë lowenebë aitatenë, bo jume lowene slemu nanëgletëme.” ");
INSERT INTO nce_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jisas bu hwi tlome, feilawa oneho bubë li elë fëkana mitisiyame nëgeme, na bu kë ahwane hokweinawa këme wame gali tlole, “Ju, ëfalëbona aholona kë titiji mëgletëbë ahwane, bo jume gali nolë, ju ebë nëbame kile etole na bubë atowa ita asa ekaklutle.” ");
INSERT INTO nce_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Na kë ahwane, tëbo afëfleiwa yëë tlële, na nëba anisasana lili tle, na bume lakilewa tetokwakle, na latugujuwa. Na këme nëba mogo fene tëbe. Na feilawa oneho bume hwi motlola na gali mëtla, “Wagli lëlefe.” ");
INSERT INTO nce_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kwe Jisas bubë tobame fa totle na huju tetëbakle, na bu lalowa tlibe. ");
INSERT INTO nce_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tokwafe, Jisas lowa tuju na bubë lowene esogo mëglelëtlabë ho këme hwelutuwa gali motlola, “Sebo kë ahwane hehë jwa fëyeme nëletlane?” ");
INSERT INTO nce_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Na bume gali tlome, “Sobo këha ahwane manawa hana hehë egletelome. Sobo Gotome fwa gëgali eglelëkeflona, kwe fëyemene, sobo këha ahwane lalowa hehë egletelome.” ");
INSERT INTO nce_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jisas, bubë lowene esogo mëglelëtlabë hona, kë lifate kile mëtla na Galili provins kukuwa mutuja. Jisas bu melëme tole tle; ho bume melowene mëgletlalime, “Bu ekë tafa lëlefe.” ");
INSERT INTO nce_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Bu bubë lowene esogo mëglelëtlabë home fwa okokwe naloglomeme nëgeme. Na bume gali tlome, “Bo, Gotobë life mago ho, bu bome wame hobë toba elë gwa mëgëtaname. Na bu bome mogo nalë tëkle mëtaname. Na bo tële olë nebëme na aona olëbëna kwe huju nëgelëme.” ");
INSERT INTO nce_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kwe bu bubë gali lowene sle hana mëtletla. Bu Jisasme uli mëtletlame nëgeme, na bu kë galime takune jwa këme motlola. ");
INSERT INTO nce_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Na kwe, Jisasna bubë lowene esogo mëglelëtlabë hona Kaperneam lifatewa fwa mutula. Na bu lowa tlelëkakume. Na Jisas bume takune tlome, “Sobo alëgeme, fëye wesibime gëgali ekweijone?” ");
INSERT INTO nce_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kwe bu gali kujuna tei tafa mëtla. Bu Jisasme tiniji mëtletlame nëgeme. Bu alëge mutujana, na blalo kofaya kofaya megali mëtlelogwayame nëgeme, “Semago, tako letitabo ho tafa, ya lëgletënamene?” ");
INSERT INTO nce_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Na Jisas tafa tle na bume gali tlome, “Ho tako letitabo home tafame tole lëglena, kwe bu iniwa onehome luglunuta asa malëletëme. Na manawa wege hoha satafa lëletëme na iniwa onehome lëgaitame nalëgleme.” ");
INSERT INTO nce_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Na Jisas bu nëba no tlële na bubë naba li mëta tlebitëme, na hwë tlële, na bubë lowene esogo mëglelëtlabë home gali tlome, ");
INSERT INTO nce_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ho bome lowene lëgletenëna, na ebëha nëbame lëgaitalena, kwe bu bome laitanë. Na ho bu bome lëgaitanëna, bu bome fwa nane laitanë. Weye, bome kë jine tëglënëbë ayame laitale.” ");
INSERT INTO nce_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon bu Jisasme gali tlole, “Tisa, sebo mehwi latlola, ho bu jubë weniji fë tëta na ahwane tëbo hobë ato mago hehë tletëme. Kwe kë ho sebona hana tuja na këme nëgeme sebo bume gali tlola, ‘Ju, Jisasbë wenijina, ahwane tëbo asa hehë eletëme.’ ” ");
INSERT INTO nce_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Na Jisas gali tlome, “Sobo këha home asa lëkle etomo. Ho bu bobë weniji fë logotlena, na bu Gotobë afutuku fenene, wesibi melë logotlena, kwe bu bome hokweinawa tëbo gali hana loglonëme. ");
INSERT INTO nce_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ho seme wame hana lolona, kë ho sebobë yabe. ");
INSERT INTO nce_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ho some melowene lëgletëyona, ‘Bo kë home nëgaitamëme, bu Goto kë aniji toglolebë home yonane mëglelëlame nëgeme.’ Na kë ho some hi tume lëgaitona kwe bo some nëgalimemu gali nolëyo, Goto kë tokwëfo wesibi hwi loglolena, na kë home aholokwana hana ti lëgleme. Bu tokwafe bume lale wesibi lëglëleme.” ");
INSERT INTO nce_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jisas ita gali tle, “Ho li bome kë lowene lëgletenëbë nëbame tëbo lowene elë tëbo logotlena na kë nëba bome kë lowene lëgletenëbë lowene kile lëglena kwe ebë tëbo wesibimu. Goto kë home habelë logotlemene? Kwe fli ho, kë home aniji mou mëta takuliji mëtatlana na bume nutu elëme tuku mëtëkakana kë kwe lalowa. Bu kë nëbame tëbo hana logotleme na Goto kë home hana tëbo logotleme. ");
INSERT INTO nce_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Jubë toba jume tëbo lowene mëta gwa lëgëtana, kwe ju kë toba tlë etokwakleme na tuku ekakeme. Ju jowa tobanawa nëgena na ju kë tëbo lowene hana egotlena kwe ju Gotobë lale lifate mëta unaunalëme tafa egleme. Kë kwe lalemu. Kwe ju tële tobana nëgena na kë tëbo lowene eglena kwe bu jume tokwafe hel lifewa tuku lëgleme. Kë kwe lale nane, kë tëbo. Kë life mago ahoju lële hana lëgleme. ");
INSERT INTO nce_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Kë life mëta, ‘Fotë bubë ato unaunalëme hi mokoukefëtëmeme na ahoju melë bubë ato mëta unaunalëme tei lëlegokefëtëme.’ ");
INSERT INTO nce_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Jubë kiju jume tëbo lowene mëta gwa lëgëtana, kwe ju kë kiju tlë etokwakleme na tuku ekakeme. Ju jowa kijunawa nëgena na ju kë tëbo lowene hana egotlena, kwe ju Gotobë lale lifate mëta unaunalëme tafa egleme. Kë kwe lalemu. Kwe ju tële kijuna nëgena na kë tëbo lowene eglena kwe bu jume tokwafe hel lifewa tuku lëgleme. Kë kwe lale nane, kë tëbo. Kë life mago ahoju lële hana lëgleme. ");
INSERT INTO nce_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Kë life mëta, ‘Fotë bubë ato unaunalëme hi mokoukefëtëmeme na ahoju melë bubë ato mëta unaunalëme tei lëlegokefëtëme.’ ");
INSERT INTO nce_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Jubë naba jume tëbo lowene mëta gwa egëtana, kwe ju kë naba lemo etamëme na tuku ekakeme. Ju jowa nabanawa nëgena na ju kë tëbo lowene hana eglena, kwe ju Goto, onehobë eso home kë tafa lëgletëmebë life mëta unaunalëme tafa egleme. Kë kwe lalemu. Kwe ju tële nabana nëgena na kë tëbo lowene eglena, kwe bu jume tokwafe hel lifewa tuku lëgleme. Kë kwe lale nane, kë tëbo. Kë life mago ahoju lële hana lëgleme. ");
INSERT INTO nce_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kë life mëta, ‘Fotë bubë ato unaunalëme hi mokoukefëtëmeme na ahoju melë bubë ato mëta unaunalëme tei lëlegokefëtëme.’ ");
INSERT INTO nce_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Këji hi wesibi fene sle motome, tokwafe ahoju mata onehome mesle logotomeme. ");
INSERT INTO nce_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Këji lale wesibi mu. Kwe këji iji hana mëglena, habelë notomamene na ita iji namëgleme. Hanane mu. Këji bu hi wesibi sle wesibi, na feilawa hi wesibi bu ijina mle. Na sobo onehome melë sle egotomome, këji fenene iji mle na sobolalo tafa sle naegelome.” ");
INSERT INTO nce_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisas na bubë lowene esogo mëglelëtlabë ho, kë lifate kile mëtla na Judia lifatebë tokwëfo lifekuwa mutuja. Na bu Jordan tu su mëtëkaka. Na lebutako enëne bume ita loko mëtlelëtla. Na bu Gotobë gali ita të tëtatëme bu ëbame fene të tëtakefëtëme. ");
INSERT INTO nce_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Na Farisi enëne Jisas belë mitisitla. Bu Jisasme su namogotlame fene. Bu bubë gali tëbo tafu lëtatëmenawa na bu mana tëbo namogotlame fene. Na këme takune motlola, “Sebobë, Juda life mago enënebë tafa sle gali, melë lëgëbetëmelalëlene o hanane? Ho noninome lalowa hehë mëgletëmamene o hanane?” ");
INSERT INTO nce_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Na Jisas gali tafu tëtatëme, “Ëtanifu ho, Moses, bu fëye tafa sle gali yahi tletëyone, bimësemeninome hehë egletemobë galibëye?” ");
INSERT INTO nce_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Na bu gali tafu mëtëtatla, “Moses megali latle, ‘Ho nome heheëme tole lëglena, bu hehë gali laba mëta yahi lëletëme na bume lëlëme. Na këna lalowa hehë lëkaketëme.’ ” ");
INSERT INTO nce_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Na kwe Jisas bume gali tlome, “Sobo aholabu enëne nëgeme, Moses kë tafa sle gali këme yahi tletëyo. ");
INSERT INTO nce_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kwe ëtanimu, Goto iniwa wesibi blëge totome. Gotobë bogo megali lalatle. ‘Goto home blëge totle na mëse blëge tëtamë. ");
INSERT INTO nce_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Këme nëgeme ho bu botaname, bolijayaname hune lële na nona weife mëtabome. ");
INSERT INTO nce_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Na bu jowaha tafa melome.’ Bu tlemalëha hana tafa mëgelome. Weye. Bu jowa atoha mëtabome. ");
INSERT INTO nce_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Goto, buwa, home mëse wayo tlole na bu weife këme mëtabo. Na ho hana hehë lëgletëme.” ");
INSERT INTO nce_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tokwafe, Jisas na bubë lowene esogo mëglelëtlabë hona, bu lowa ita mutuja. Na bubë lowene esogo mëglelëtlabë ho bume kë nonino hehë galibëme takune motlola. ");
INSERT INTO nce_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Na bume gali tlome, “Ho, nome hehë lëgletëna na li mëseme sei lëglena, kë ho bubë auto mëseme sisile lalëta na lisë lowene mëta tafa lële. ");
INSERT INTO nce_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na mëse boheme hehë egletlena na li home sei eglëlena, kë mëse bu lisë lowene mëta tafa ele.” ");
INSERT INTO nce_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Oneho bu nëbale Jisas belë metlesumëtla. Bu metole lamëtla, Jisas bubë toba gogwa naloletëmeme na Gotome takune lololeme, bume lëgaitame nalëgleme. Kwe Jisasbë lowene esogo mëglelëtlabë ho bume hwi motloma na lëkle mototoma, “Teife. Sobobë nëbale bu belë asa elesumo.” ");
INSERT INTO nce_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jisas këme hwi tlome na bu wame tlome. Na bubë lowene esogo mëglelëtlabë home megali tlome, “Sobo nëbale lëkle asa etomo. Bo belë matisiya. Oneho kë nëbaleha nëgena, kwe bu Goto onehobë eso home kë tafa lëgletëmebë lifatewa, mugujame. ");
INSERT INTO nce_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Bo nëgalimu nanolëyo, ebëha nëbale bu Gotome hokweinawa lowene sle lamëletla. Na oneho bu ebë nëbale ha, Gotome lowene sle mëgletlana kwe bu Goto onehobë eso home kë tafa lëgletëmebë lifatewa mugujame.” ");
INSERT INTO nce_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Na bu nëbaleme nëno tle na hohwë tle. Na toba gogwa toletëme na Gotome takune tlole, bume lëgaitame nalëgleme. ");
INSERT INTO nce_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisas na bubë lowene esogo mëglelëtlabë hona huju mëtla na mutuja. Na ho li bu Jisas belë fëka tokwei na bubë li mëta bubusu tëmalita na sëkefo miti tafa tletle. Na bume takune tlole, “O Tisa, ju lale ho. Bo jume takune nolë. Bo habelë nëgelëmene, bo Gotona unaunalëme lale tafa nanëgelome?” ");
INSERT INTO nce_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Na Jisas bume gali tlole, “Ju bome lale fë fëyeme etanëne? Ebë life mago ho bu lale nane. Goto buwa lalemu. ");
INSERT INTO nce_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ju Gotobë tafa sle gali walowene eletle. Bu megali lalamë, ‘Sobo onehome mogo nalë asa tëtëkle etomo. Sobo liseëliseë asa elo. Sobo tokli asa elo. Sobo li home blawa asa so etatelo. Sobo hobë wesibi sogëna galina manawa asa mëmë eletemo. Sobo bitaname blijayaname boblo asa etomo. Bubë galiwa saesogo elelëtemo.’ ” ");
INSERT INTO nce_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Na kë ho Jisasme gali tlole, “O Tisa. Bo tokwëfome nëgena bo këbë tafa sle gali iniwa melë esogo sle nëlagilë na bo ebë olëna mana esogo nëlelëlë.” ");
INSERT INTO nce_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jisas bume hwi tlole na maninibo latletle na tole latletle na bume gali tlole, “Ju li lowenewa mana afolo eletle. Ju melë egleme. Jubë iniwa wesibi balitina hihijika eleme na kë baliti glo eleme na wesibi jwa onehome elëmeme. Ju melë laleye kwe Heven lifate mëta lale wesibimu lamëbetë. Na ju bome esogo elenënëme.” ");
INSERT INTO nce_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kë ho bu kë gali aholokwane tlole na lawabelëwatle na witina latugujuwa. Bu feilawa wesibimu mëtëbetleme nëgeme na fli onehome lëglëmeme tole hana tle. ");
INSERT INTO nce_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jisas bubë lowene esogo mëglelëtlabë home hwi tlome na gali tlome, “Wesibi lebutakona enëne, Goto onehobë eso ho kë tafa lëgletëmebë lifatewa mugujabëme, ebë kalëlego lalëletëme.” ");
INSERT INTO nce_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Na bubë lowene esogo mëglelëtlabë ho, bu kë gali aholokwane mëtla na klelego memëtletla. Kwe Jisas bume fli gali megali tlome, “O nëbale, iniwa oneho, Goto onehobë eso ho kë tafa lëgletëmebë lifatewa mugujabëme, ebë kalëlego lalëletëme. Hafëna mugujamene? ");
INSERT INTO nce_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamel kleli, bu ëho susu nili fulujuwa lëkaklubëme ebë kalëlegomu lalële, kwe wesibi lebutakona enëne, Goto onehobë eso ho kë tafa lëgletëmebë lifewa mugujabëme ebë kalëlegomu lalëletëme.” ");
INSERT INTO nce_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kwe bubë lowene esogo mëglelëtlabë ho bu klelego memëtla na blalo gëgali mëtla, “Kë melë nëgena, kwe Gotobë ëhwati tafa yalë fa logotlemene?” ");
INSERT INTO nce_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Na Jisas bume hwi tlome na gali tlome, “Oneho bu kë wesibi hana mogotlame kwe Goto kë wesibi lalowa logotleme. Goto iniwa wesibi lalowa logotomeme.” ");
INSERT INTO nce_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Na Pita Jisasme li gali megali tlole, “Jisas, ju seme hwi enona. Sebo iniwa wesibi wahune tla na jume waesogo tlelëyo.” ");
INSERT INTO nce_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Na Jisas gali tlole, “Bo nëgalimu gali nolë, oneho bome tolemu mëgletënana na Gotobë lale gali të mogotlana na bubë lo o bolijamoni o blijahani o mësenëbani o bolijaya o bota o nëbale o nuju hune mëglana, kwe Goto bume lebutako wesibimu lëglëmeme. ");
INSERT INTO nce_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Bu ebë life mëta mana tafa mëglana, Goto bume lebutako wesibimu lëglëmeme. Ëtani kë hune mëtlabë wesibi bu tëlewaha kwe Goto bume kë lëglëmebë wesibi bu lebutakomu. Goto bume lebutako lo na, bolijahani, bolijamoni, mësenëbani, botani, nëbale, na nuju lëglëmeme. Kwe, masiwafe, fli enëne bume tëbo mogotomame, bu bome lowene sle mëgletëname nëgeme. Na tokwafe bu lale tafa memokoukefëyame. ");
INSERT INTO nce_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lebutako enëne bu ebë olëna letitabo hoha kë tafa mëglabë, bu tokwafe Gotobë olëna bu atwati hoha tafa mëglame. Na lebutako enëne bu ebë olëna atwati hoha kë tafa mëglabë bu tokwafe Gotobë olëna letitabo hoha tafa mëglame.” ");
INSERT INTO nce_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jisas na bubë lowene esogo mëglelëtlabë hona, Jerusalem lifate alëge elë motokwala. Jisas bu toutatëme. Na bubë lowene esogo mëglelëtlabë ho tutune motokouja. Na oneho bume kë nagi mëtlëmabë bu uli memëtla. Na bubë lowene esogo mëglelëtlabë home loko tëta na bume tëbo namogotlabë galime gali tlome. ");
INSERT INTO nce_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Bu megali tle, “Sobo aholokwane elo. Sebo Jerusalem lifatewa ekë nuja. Na bo, Gotobë life mago ho, bu bome, lotu lo mëta wege mëglabë eso enëne na Gotobë tafa sle gali lowene sle mëgletlabë honame yo molomame. Na bu tetahë melëmame na bome mogo nalë tëkle mëgëtanabë gali sle namogotlame. Na bu bome, Israelbë afenëboni mëtabëya jwa mëglabë enëneme, yo namoglomame. ");
INSERT INTO nce_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Na kë enëne, bu bome tiniji galina gali namogloname. Na bome sosonatlë namëgëtaname. Na bome nagutaba kokose mogloname. Na bome taba afona feilawa lëlafa mëtaname. Na bome mogo nalë tëkle mëtaname. Na bo mogo tële olë nebëme na aonabëna huju nëgelëme.” ");
INSERT INTO nce_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Na këme, Sebedibë nëbale, Jemsna Jonna, Jisas belë mitisijo. Na bume takune motlolo, “Tisa, sebo jume wesibime takune nëlëyo. Na ju seme kë wesibi lalowa egotometenomene?” ");
INSERT INTO nce_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Na Jisas bume takune tlome, “Bo fëye wesibi nogotometëyomene, sobo habë tole lalone?” ");
INSERT INTO nce_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Na bume gali motlolo, “Tisa, ju tokwafe tako eso home watafa eglena, sebo metole nanelo, sebo juna onehome eso ho tafa nanëgletëmame. Li jubë tobamu toba elëme tafa lëleme na li jubë yemane toba elëme tafa lëleme.” ");
INSERT INTO nce_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kwe Jisas bume gali tlome, “Sobo bome kë takune eglonabë, kë wesibime sobo lowene sle hana eletelo. Tokwafe bo tako elili fa nogotlëme, sobo këha elili lalowa fa egotlomene? Na tokwafe bo gli nëgelëme, sobo këha megli lalowa egelomene?” ");
INSERT INTO nce_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Na bu gali motlolo, “Sebo melë lalowa nëgelome.” Na Jisas bume gali tlome, “Nëgali. Bo elili mefa notlëme, sobo mata këha elili mefa egotlome, na bo megli nëgelëme, sobo mata këha megli egelome. ");
INSERT INTO nce_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kwe ho bu bona eso home kë tafa nëgletëmabë na bobë tobamu toba elë tafa lëglebë o bobë yemane toba elë tafa lëglebë, ebë bobë wesibi nane bo kë aniji noglomëme. Weye. Ebë Gotobë wesibiwa. Bu, bona eso home kë tafa nëgletëmabë home waaniji tlome.” ");
INSERT INTO nce_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Na fli we ho, bubë lowene esogo mëglelëtlabë, bu Jemsna Jonna, Jisasme kë takune motlolobë gali aholokwane mëtlana, bu wame memotloma. ");
INSERT INTO nce_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kwe Jisas bubë lowene esogo mëglelëtlabë ho iniwame gali telëkakëme. Na bu mutujutla na bume këme gali tlome, “Sobo walowene elo, Israelbë afenëboni mëtabëya jwa mëglabë enënebë eso ho, bu melamela, onehome baba të motoma, bubë wege manawa fa namëgëtatëmame. ");
INSERT INTO nce_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kwe, kë eso ho fene mëtabëya, sobo këha lowene mëta asa tafa elo. Weye. Matëbe. So mago ho, bu sobobë eso home tafame tole lëglena, bu melë lëglëme, some wege lëgletëyobë hoha lëtabeme. ");
INSERT INTO nce_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Na somago ho, bu iniwa onehobë logouta home tafame tole lëglena, bu melë lëgleme, iniwa onehobë manawa wege hoha tafa lëletëmeme. ");
INSERT INTO nce_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Na bo, Gotobë life mago ho, bo melëme nane tisi, oneho bome mëgaitana namëglame. Weye. Bo melëme tisi, onehome nëgaitamë nanëgelëme. Na bobë gli lebutako onehome laitame nalëgleme. Bubë tëbo lowene bobë glina hihijika nanogotometemëme.” ");
INSERT INTO nce_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jisasna bubë lowene esogo mëglelëtlabë hona, Jeriko lifatewa fata mëtla. Na Jeriko lifate kile mototla. Na buna bubë lowene esogo mëglelëtlabë hona, feilawa onehona mutuja. Na Bartimeus, Timeusbë bowene, alëge mëglëbo lime tafa tlekëfe. Bu naba titiki tabo ho. Na bu onehome balitime gëgëba latlokwefëme. ");
INSERT INTO nce_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Na bu kë gali aholokwane tle, “Nasaret life mago Jisas, bu lisi.” Na bu anisasana we tlole, “Jisas, Devitbë bosemle, ju bome maninibo eletenë!” ");
INSERT INTO nce_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Na feilawa oneho bume këkale motlola, “Euowe! Ju kuju ebe.” Kwe bu anisasana we tlole, “Devitbë bosemle, ju bome maninibo eletenë!” ");
INSERT INTO nce_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Na Jisas bubë we lego aholokwane tlole na këme tlibe, na gali tle, “Sobo gali elëbaklo, ligisi nalëgleme.” Na bu kë naba titiki tabobë home we mëtelëkakla na gali motlola, “Ju fleflesu ele. Ju huju ele. Bu jume ekë we lelëbakë.” ");
INSERT INTO nce_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Na kwe bubë tli lime kë gelo totokweflebë ëho hwaga totle na hokweinawa huju tëkake, na Jisas belë tuju. ");
INSERT INTO nce_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Na Jisas bume takune tlole, “Bo jume fëye nëgëtëmene?” Na kë naba titiki tabo ho bume gali tlole, “Tisa, ju bobë naba sle etometenë, bo hwi nanëgelëme.” ");
INSERT INTO nce_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Na Jisas bume gali tlole, “Ju bome lowene sle eletenëme nëgeme, jubë naba këme sle meletë. Ju lalowa eiju.” Na hokweinawa bubë naba lalowa memëtletlemu. Na bu hwi tëkake. Na bu Jisasme alëge elë nagi telëkakle. ");
INSERT INTO nce_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jisasna, bubë lowene esogo mëglelëtlabë hona, Jerusalem lifatewa lololi mëtla, na bu Betfage lifekuwa na Betani lifekuwa loliwa fwa mutula. Kë lifeku bu Oliv fatini li mëta metëbe. ");
INSERT INTO nce_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Na Jisas bu tlemalë lowene esogo mëglelëtlabë home jine tlëme na bume gali tlome, “Sobo kë hwi egelëkakëlobë lifekuwa eyeume. Sobo eyeume, na ti mëta takuliji tabo afeku donki kleli hwi eglolome. Ëbame, ho kë donki kleli matawa hana tafa tle. Sobo taba tohwa etatelome na elesutëname. ");
INSERT INTO nce_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Na ho li some metakune loglëyona, ‘Sobo ebë donki kleli fëyeme elelulone?’ Kwe sobo bume metafu saetatelo, ‘Sebobë tako ho bu tole lëletle. Bu këna asë lëleme na bu seme hokweinawa ita jine lelëbakëname, ebë donki kleli ita nëglesutëyome.’ ” ");
INSERT INTO nce_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Na kwe bu mëtëyeu, na bu afeku donki kleli, alëge li mëta kë liglibebë hwi motlolo. Fli ho bu kë donki kleli, lo ino li mëta watakuliji mototla. Na kwe kë tlemalë ho bubë taba tohwa mëtëtatelo. ");
INSERT INTO nce_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Na lolime kë mitlijabë ho takune motloma, “Sobo kë donki kleli fëyeme tohwa etlone?” ");
INSERT INTO nce_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Na tlemalë bu gali tafu mëtëtatemo, Jisas bume fene gali tlome. Na kë enëne, bume gali motloma, “Sobo lalowa elelulo.” ");
INSERT INTO nce_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Na kwe tlemalë, kë donki kleli Jisasme sei mëtlëkakitelo. Na bubë heletabo ëho donki klelibë amlebo mëta kahëba motolo. Na Jisas kë ëho matawa tafa tole. ");
INSERT INTO nce_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Na feilawa oneho bubë heletabo ëho totohwa mëtla na alëge mëta kahëba motokouja. Bu Jisasme fleflesu mëtletla, eso hoha fata tëgleme nëgeme. Na Jisas donki klelina kë matawa luguju nalëgleme, eso ho fene asë mëtla. Na fli oneho bu yagibeha laba mata glo mëtla na alëge mëta kahëba motokouja. ");
INSERT INTO nce_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Na oneho bu Jisasna kë motoutayabë na oneho fli nagi kë mitlijabë, bu këme memomolë motokouja, “Yahala fëyemene. Sebo Gotome fleflesu nëgletlame. Goto bu jine tlële. Bu Gotobë kalëlegona tisi. Goto kë home ululu sle nalogotleme. ");
INSERT INTO nce_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kë ho bu seme eso home tafa nalëgletëname tisi, Bosemle Devit, sebobë semlenime eso home fene tafa tletëme. Goto kë eso home ululu sle nalogotleme. Sebo Gotome tako fleflesu nëgletlamemu.” ");
INSERT INTO nce_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Na Jisas bu Jerusalem lifatewa fwa tule na tako lotu lowa tëkaklu. Na bu iniwa wesibi hwi tlagume. Kwe olë ki lëgëbeme nounou latle na buna bubë lowene esogo mëglelëtlabë hona Jerusalem lifate kile mëtla na Betani lifekuwa hokweinawa mutuja. ");
INSERT INTO nce_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tokwafe li olëna bu Betani lifeku kile mëtla na bu alëge mëta mana asë mëtla. Na Jisas foneme gli tle. ");
INSERT INTO nce_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Na bu atowaiha ti kakë manogwa hwi telokwakle na bu lebutako labana. Na kwe bu loliwa tuju tle, lijime hohwi nalëgëtame, kwe bu liji hwi hana tlometle labawa hwi tlome. Ebë atowaiha ti logowalë jwa lëglebë olë nëgeme hwi jwa këme tlome. ");
INSERT INTO nce_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Na Jisas kë time anisasana hana tlole, “Ju liji ita asa fu ele na oneho bu liji ju mago hi hana mëglekefëyame. Hanane mu.” Na bubë lowene esogo mëglelëtlabë ho kë gali aholokwane motlola. ");
INSERT INTO nce_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jisas na bubë lowene esogo mëglelëtlabë hona Jerusalem lifatewa fwa mutula. Na Jisas tako lotu lo kë mëta liglibebë life elëme tëkaklu. Na bu wesibi balitina kë glo mëglabë enëneme na wesibi balitina kë hihijika mëtlabë enëneme hehë teluletëme. Bu melatotome. Bu li life li life enënebë baliti këme kë hihijika mëtlabë enënebë masei obobwelë tetokwakëmetëme. Na bu seuneni fole balitina kë hihijika mëtlabë enënebë tafa labuku mata obobwelë totometëme. (Bu kë fole Gotome ahojume ahojume mëtlekefëtlabë.) ");
INSERT INTO nce_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Oneho bu wesibina, tako lotu lo li mago lëglesi tabo life elëme mëtlelëkaklukefëma. Na Jisas bu kë onehome hehë tletëme. ");
INSERT INTO nce_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Na bu gali tlome, “Gotobë bogo megali lala, ‘Li life li life mago oneho bobë lo elëme migisiyabë, bome gëgali namëlelëkefëname.’ Kwe sobo ebë lo tëbo latlo na bu tokli enënebë loha lilibetëyo.” ");
INSERT INTO nce_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Na lotu lo mëta wege mëglabë eso enëne na Gotobë tafa sle gali lowene sle mëgletlabë ho bu kë gali aholokwane motlola, na alëge hohwi mëtëtatla, Jisasme mogo nalë tëkle namogotlame. Iniwa oneho bu Jisasme tako tole lamëtletla. Melëme nëgeme bu kë tëtë togotlebë gali kle klelego lamëtlekefëtla, na lotu lo eso enëne bu Jisasme këme uli mëtletla. ");
INSERT INTO nce_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Na atome hwi olë, Jisasna bubë lowene esogo mëglelëtlabë hona Jerusalem lifate kile mëtla na mutuja. ");
INSERT INTO nce_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Na li olëna, olobalëwa, Jisasna bubë lowene esogo mëglelëtlabë hona, Jerusalem lifatebë alëge mëta mana asë mëtlabë, na bu kë atowaiha ti ita hwi mëtelëkakla, bu wakoko tëbefe. ");
INSERT INTO nce_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Na Pita bu Jisas kë time këhana toglolebë gali ita lowene tletle na gali tle, “Euowe, Tisa, yame ju kë atowaiha time anisasana mehana tlole, ‘Ju liji ita asa fu ele.’ Na ëje bu wakoko lëbe.” ");
INSERT INTO nce_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Na Jisas megali tlome, “Sobo Gotome melowene sle egletelome, bu kalëlego ho. ");
INSERT INTO nce_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Bo some nëgali gali nanëlëyo. Ho bu fatinime megali loglëna, ‘Ju huju elëme na ju nutu elëme okli ekakeme.’ Na kë ho bu tële lowene hana lëglena na Gotome lowene sle lëgletlena kwe Goto bu melë logotleme, kë ho fene gali lële. ");
INSERT INTO nce_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Sobo Gotome wesibime takune eglolona na sobo melowene sle egletelona, ‘Goto bu seme kë wesibi lëglënamefe,’ kwe Goto bu some kë wesibi lëglëyome, sobo fene takune elolo. ");
INSERT INTO nce_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Sobo Gotome gali eglolona, na sobo li ho, some kë tëbo tëgëtobë lowenebë, ita lowene egletelona, kwe sobo kë hobë tëbo lowene aholokwana ti egletelome. Sobo melë egelona, kwe sobobë aya, heven life mëta kë tafa lëglebë bu sobobë tëbo lowene mata aholokwana ti lëgletëyome.” ");
INSERT INTO nce_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jisasna, bubë lowene esogo mëglelëtlabë hona, Jerusalem lifatewa ita fwa mutula. Na Jisas bu tako lotu lo li mago lëglesi tabo mëta asë tle. Na lotu lo mëta wege mëglabë eso enëne fli, na Gotobë tafa sle gali lowene sle mëgletlabë enëne fli, na lotu letitabo enëne fli, bu belë mitisiya. ");
INSERT INTO nce_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Na bu metakune motlola, “Ju kë kalëlego hamago fa totlene?” ");
INSERT INTO nce_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Na Jisas bume gali tlome, “Bo mata, some li wesibime takune nolëyo. Sobo bobë gali tafu sle latatëna kwe bo some kalëlego kë mago kë fa nogotlëbë gali, gali noglëyome. ");
INSERT INTO nce_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Bo some metakune nëlëyo, onehome tume kë baptais totomebë Jonme ya jine tlëlene? Goto bu jine tlëlene o ho jine mëtlëla? Sobo bobë gali tafu etatëna.” ");
INSERT INTO nce_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Na bu blalo gëgali mëtla, “Sebo megali noglolana, ‘Goto bu jine tlële,’ kwe bu seme megali logloname, ‘Kë nëgali nëgebë, sobo bume lowene sle egletelo jwa fëyemene?’ ");
INSERT INTO nce_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kwe sebo megali noglolana, ‘Ho jine mëtlëla,’ kwe oneho bu seme habelë mëgëtanamene?” Bu kë gali fëyeme gali mëlane? Bu onehome uli mëtletëmame nëgeme. Iniwa oneho bu melowene lamëtletla, “Jon bu Gotobë lowene mago gali të lotokweflebë homu.” ");
INSERT INTO nce_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Na bu Jisasme gali metafu mëtëtatla, “Sebo, Jonme kë jine tëglëlebëme, lowene hana nëla.” Na Jisas bume gali tlome, “Bo mata sobobë takune tafu hana nëgetatëyome. Na bo kalëlego kë mago kë fa nogotlëbëme hana gali nëglëyome.” ");
INSERT INTO nce_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jisas, Juda life mago lotu letitabo home, waflë gali tletëme. Bu megali latle, “Ho bu wain taba, nuju mëta ola tle na lëglesi tle. Na bu life ha totle na fuluju yefi tle, wain taba liji kë mëta fëfe namëglame, bubë tu hi namëglekefëyame. Na bu akolalo, kë nuju mëta gliji tle, ho kë lo mëta sei namogowelëkeflame, ho tokli mëglalime. Na bu fli home gali tlome, ‘Sobo bobë wain taba nuju hwi elotëna. Na tokwafe liji mogwalëna, fliye sobobë na fliye bobë.’ Na kë ho hune totome na kakë lifewa tuju. ");
INSERT INTO nce_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tokwafe, wain taba liji nigliji mëtle, bubë wege home, bubë nuju kë hwi moglotlabë ho belë jine tletëme, bubë hi wesibi kë nuju mago glo nalëgleme. Na bu tuju. ");
INSERT INTO nce_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kwe nuju kë hwi motlotlabë ho, bu belë kë tigisitëmebë home anisasana tëkle mëtëtagula na kë mago hehë mëtëkaketla. Na bu kë mago manawa latëglëbouwa. ");
INSERT INTO nce_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Na ita nuju bolijaya, li home jine tletëme. Kwe kë enëne kë hobë eso labulewa mëtëtatla na bume tëbo mototla. ");
INSERT INTO nce_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Na ita li home jine tletëme. Kwe bu kë home mogo nalë tëkle mototla. Na këme, bu feilawa home kë enëne belë jowa jowa jine tlëkefëmetëme. Na bu fli home tëtëkewa mëtla na flime mogo nalë tëtëke mëtla. ");
INSERT INTO nce_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Na jowa howa tafa tle. Kë ho kë nëgebëye nuju bolijayabë bowene, na bume tako tole latletlemu. Na yawememu, boweneme, bubë nuju kë hwi motlotlabë ho belë jine tletëme. Bolijaya melowene latle, ‘Bu bobë nëbabë gali aholokwanewa moglolame.’ ");
INSERT INTO nce_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kwe bubë bowene alëge mëta mana asë tëkeke na nuju kë hwi motlotlabë ho bu blalo gëgali mëtla, ‘Ebë ho kë ligisibë ebë kë nujubë bolijayabë bowene. Tokwafe bolijaya gli lëglena, kwe bu kë nuju bolijaya tafa lëgleme. Te, mana mogo nalë tëkle manotla na kë nuju seme lëbetëname.’ ");
INSERT INTO nce_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Bu tisitëme na hohwë mëtlëla na mogo nalë tëkle mototla. Na mogo fa mototla na nuju mëglëbo elë tuku mëtëkaka.” ");
INSERT INTO nce_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Na Jisas lotu letitabo home takune tlome, “Sobo habë lowene lalone, kë nuju bolijaya bubë nuju kë hwi motlotlabë home habelë logotomemene? Sobo aholo bo eto. Bu ligisina, bu kë home mogo nalë tëbo logotomeme. Na ita kë wain taba liji nuju fli home yo loglomeme, hwi namoglotlame. ");
INSERT INTO nce_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Sobo Gotobë bogo mëta kë lëgëbebë gali hwi hana tlolone? Ëye wahwi tlolo. Ebë gali metëbe latle, ‘Lo gliji ho, bu lo, anijina gliji mëtla. Na kwe bu li anijime meweniji lamëtla, “Tëbowa.” Këme nëgeme, mëglëbo elë fo mëtetokwakëya. Kwe kë aniji mëglëbo elë kë fo mëtetokwakëyabë bu lale anijimu ebamë. Lo bulego kë aniji mëta lotle. Kë aniji jwa nëgena, kwe lo fli lëgleme. ");
INSERT INTO nce_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Goto melë tëgleme nëgeme, kë wesibi këha këme fata lële. Sebo yafe hwi nololamu, lale wesibimu tlëna.’ ” ");
INSERT INTO nce_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Lotu letitabo ho bu melowene lamëtla, “Jisas seme waflë gali lëletënafe.” Këme nëgeme, bu Jisasme ëjeha fa motlame. Kwe bu onehome uli mëtletëmame nëgeme. Na bu Jisasme këme kile mëtla na bu mitliwaya. ");
INSERT INTO nce_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Lotu letitabo ho, bu Farisi enëne fli na eso ho Herotbë wege enëne fliname, Jisas belë jine mëtlëma. Bu metole lamëtla, Jisasme sogëname takune namoglolame na bu Rom life mago eso ho, Sisarme, tëbo gali nalogloleme. Kë tëbo galime fwa bume këna so namëgëtatlame fene. ");
INSERT INTO nce_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Na këme mutuja na gali motlola, “Tisa, sebo lowene nanëla, ju nëgali gali homufe na ju hobë tëbo loweneme na tëbo galime uli hana eletëme. Ju nëgali galimu të etagule. Ju baliti musuna home na baliti musujwa home, lili gali hana gali tlagume. Weye. Ju iniwa home, jowa gali mefwa gali tlagume. Ju iniwa onehome, Gotobë lale anebo galiwa të tëtagutëme. Na ju habelë lowene lalene? Sebo takis baliti Rom life mago eso ho, Sisarme, lalowa nëglëlamene o hanane? Këha lowene lalowa nëglamene o hanane?” ");
INSERT INTO nce_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kwe Jisas bubë sosogëname wafi lowene tletëme na bu kë enëneme megali tlome, “Sobo bome fëyeme su etanane? Sobo jowa baliti bome ehitëna, hwi nanoglëme.” ");
INSERT INTO nce_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Na baliti mëtëhitla. Na Jisas takune tlome, “Ebë amtëtomba yalëbëne, na weniji yalëbëne?” Na këme gali motlola, “Ebë Sisarbëyo.” ");
INSERT INTO nce_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Na Jisas bume gali tlome, “Sisarbë wesibiye, kwe Sisarme eglëlome. Gotobë wesibiye, kwe Gotome eglëlome.” Na bu kë gali aholokwane motlola na klelego memëtla. ");
INSERT INTO nce_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Na këme Sadyusi enëne Jisas belë mitisiya. Kë enënebë lowene metëbetëmelatle, “Lebo mëgebëyabë oneho, hana huhuju mëglame.” Na këme Jisasme takune motlola, ");
INSERT INTO nce_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tisa, ëtani, Moses ebë gali meyahi latletëna, ‘Ho nëba jwa lebo lëgëbena, na bubë mëse seiju mana tafa eleme, kwe ita bolijamo sei lëlëme, na nëbaneni lëlelëme. Na kë nëbale, lebo kë tëglebë hobë wenijina mëtabetla namëglame. Na bu kë hobë nëbaleha tafa namëglame, na lebo kë lëgëbebë hobë weniji hana te lëgletleme na aholokwana hana ti mëglame.’ ");
INSERT INTO nce_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ëtani, ho li tobali ita jowa bolijamonime këniji tlebime. Bolijaha afina mëse sei tlë na kwe bolijaha nëba jwa gli tle. ");
INSERT INTO nce_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Këme nëgeme, ita kë seiju bolijamo sei tlë, na bu mata nëba jwa gli tle. Na ita kë seiju tafa tle ita li bolijamo sei tlë, na bu mata, melatle, kë fenene. ");
INSERT INTO nce_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bu iniwa bolijamoni melamëtla, kë seijume fwa fifiji mëtlelëya na iniwa nëbale jwa gigli mëtla. Na tokwafe kë mëse, bu mata, gli tle. ");
INSERT INTO nce_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Na sebo jume takune nëlëyo. Tokwafe gigli kë mëglabë oneho huhuju mëglana, kë mëse fëye home tafa egletlemene? Ju wafi lowene ele, bu këniji mitlibëya, tobali ita tële bu kë mëseme iniwa sei mëtlëya.” ");
INSERT INTO nce_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Na këme Jisas bume gali tlome, “Sobo Gotobë bogo mëta kë lëgëbebë gali na Gotobë afutuku lowene sle hana eletelo. Këme nëgeme sobo yaya lowene këme elo. ");
INSERT INTO nce_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tokwafe, gigli kë mëglabë oneho huhuju mëglana, kë lebo enëne, one hana sesei mëglame. Weye. Bu heven life mago ensel fene mëtabëya, bu one sesei jwa mëglame. ");
INSERT INTO nce_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na eli, bo lebo enëne huju mëglabë gali të nëgetatëyome. Sobo Mosesbë bogo mago yahi hwi hana tlolone? Ëye wahwi tlolo. Kë gali melë lëgëbelalële. ‘Ahuju, ti abo mëta u tle, kwe kë ti abo koko hana tëbe. Moses bu kë hwi tlole na Goto ahoju kë u tëglebë ti abo mëta tëtabe na bume gali telulubakle, “Bo blijafujunibë Goto mana ekë tafa nelë, Abraham, Aisak, na Jekopnabë.” ’ ");
INSERT INTO nce_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Gotobë lowene melë lëgëbetlelalële, ‘Kë aomalë ho wagigli mëtla, kwe amtëtomba mana mëtabëya, na bubë Goto mana ekë tafa lëletëme.’ Ebë Goto kë nëgebë lebo enënebë Goto nane. Weye. Mana kë tafa mëglabë enënebë Goto. Sobo melowene kë egelobë, ‘Lebo enëne hana huhuju mëglame.’ Kë yaya lowene lëbetëyo.” ");
INSERT INTO nce_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Gotobë tafa sle gali lowene sle lëgletlebë ho li këme tëtabe. Na bu Sadyusi enëne Jisasna kë gëgali mëtlelogwayabë gali aholokwane tlome. Na bu melowene latle, “Jisas bume lale tafu lalëtatëmefe.” Na bu Jisasme këme takune tlole, “Gotobë fëye tafa sle gali blo lotomene, iniwa tafa sle galibëme.” ");
INSERT INTO nce_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Na Jisas bume tafu tëtatëme, “Gotobë lale tafa sle gali kë lëgëbebëye melë, ‘Israel life mago ho sobo aholo bo eto! Goto buwa sebobë tako letitabo lëtabetëna. Sebobë li Goto hanane lëtabe. Jowa Gotowa lëtabetëna. ");
INSERT INTO nce_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Sobo Gotome anisasana tole egletelomemu, lowenena ini tolewa egletelomemu.’ ");
INSERT INTO nce_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na li lale tafa sle gali kë lëgëbebëye melë, ‘Ju iniwa onehome anisasana tole egletëmeme, jume fene tole ele.’ Fli tafa sle gali bu kë tële tafa sle galiha hana mëbe. Kë telë tafa sle gali bu fli tafa sle galime boblo lamotome.” ");
INSERT INTO nce_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Na këme Gotobë tafa sle gali lowene sle lëgletlebë ho Jisasme gali tlole, “Tisa, ju gali kë tafu etatenëbë lalowamu. Ebë nëgali, Goto buwa tako letitabo lëtabe. Na li Goto hana lëtabe. Jowa Gotowa tafa lële. ");
INSERT INTO nce_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Sebo Gotome anisasana tole nëgletlamemu, lowenena iniwa tole nëgletlamemu. Na sebo iniwa onehome anisasana tole nëgletëmame, seme fene tole nëla. Kë tële anebo gali nëgehwëyana na esogo nëglelëmana ebë lalemu. Kwe Gotome afabo kë ahojume ahojume nëglekefëtlabë lowene na iniwa wesibi Gotome kë nëglëlabë lowene ebë laleha.” ");
INSERT INTO nce_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jisas kë home aholokwane tlole na melowene latle, “Lale tafu lalotlefe.” Na Jisas bume gali tlole, “Ju Gotome lowene sle egletleme nounou lale, na Goto jume eso home tafa lëgletëme nounou lalëlemu.” Na bu Jisasme li takune, takune moglolabëme uli memëtletla. ");
INSERT INTO nce_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisas tako lotu lo lifeku mëta tafa tle na bu gali kë mëta të tëtatëme. Na bu megali latlome, “Gotobë tafa sle gali lowene sle mëgletlabë ho bu megali lamëtla, ‘Goto bume kë aniji toglolebë ho, onehome nëno nalëgleme, kë ho bu Devitbë bosemle.’ Sobo habelë lowene laletelone, bu kë gali fëyeme gali mletlane? ");
INSERT INTO nce_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ëtani Gotobë Amtëtomba Devitme lowene tlële na Devit bu kë lowene megali latle, ‘Goto, bu bobë tako home megali lalolole, “Ju bobë tobamu toba elë tafa egletenëme na ju bona onehome eso home tafa nëletemome. Sebo onehome mana tafa nëlelëmome na bo jume kë wame mëglëyobë home boblo nogotomëme na bu jubë gali hana boblo mëtome.” ’ ");
INSERT INTO nce_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devit kë aniji toglolebë home mefë latotle, ‘Bobë tako ho.’ Na bo some takune nëlëyo, Gotobë tafa sle gali lowene sle mëgletlabë ho, mefëwa fëyeme mototlane, ‘Kë ho Devitbë bosemle,’ kwe bu mefë jwa fëyeme mototlane, ‘Devitbë tako ho?’ Bo some gali nëlëyo, bu Devitbë bosemle kwe tako home tëtabe. Këme nëgeme, Devit bu tako ho fë këme totle.” Na kë feilawa oneho buna kë mëtëtabëyabë, Jisasbë gali fleflesuna aholokwane motlola. ");
INSERT INTO nce_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Na Jisas bume okokwe tlome na megali tle, “Sobo Gotobë tafa sle gali lowene mëgletlabë home ululu egelome. Sobo bubë lakale asa esogo elelëtemo. Bu memelë lamla, heletanëno ëho mehwëa na iniwa onehobë naba lime asë mëbebokwaka. Oneho bu melowene namëgletëmame, ‘Bu lale letitabo enënefe.’ Na bu oneho këme kë tafa mëglabë lifeku mëta asë mëglana, bu metole namëgletëmame, oneho bume megali namoglomame, ‘O letitabo ho. Lale klijimu.’ ");
INSERT INTO nce_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bu lotu lome tafa mëglana, bu metole lamla, onehobë naba li mëta, letitabo ho këme tafa mëglekefëyabë tafa labume tafa mlame. Na tako hi olëna, bu metole lamla, onehobë naba li mëta, letitabo ho këme tafa mëglekefëyabë tafa labume tafa mlame, oneho bu melowene namëgletëmame, ‘Lale letitabo enënefe.’ ");
INSERT INTO nce_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bu seiju oneme sosogëna moloma na bubë iniwa wesibi manawa mëglëma namëglame. Na bu memelë lamelekefëya, onehobë naba li mëta, Gotome feilawa gëgali mëlelëla, oneho bu melowene namëgletëmame, ‘Lale letitabo enëne fe.’ Bubë tëbo lowene këna lëlamu motla. Tokwafe, Goto fli enëneme tëbo logotomena, kwe kë enëneme tako tëbo logotomememu.” ");
INSERT INTO nce_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisas, baliti Gotome këme sisike melekefëtlabë bokis li mëta tëtabe, tako lotu lo mëta. Na bu onehome hwi tlome, bu baliti Gotome kë bokis mëta sisike mëtletla. Na feilawa oneho bu feilawa baliti sisike mëtla. ");
INSERT INTO nce_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Na kwe wesibi jwa seiju mëse tisi. Na bu baliti tokwëtokwë tële sike tle. ");
INSERT INTO nce_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Na Jisas bubë lowene esogo mëglelëtlabë home gali telokwakëme. Na bu mitisitla na gali tlome, “Sobo kë mëseme hwi elëkakëyo. Bo some nëgali nanëlëyo. Fli oneho bu kë bokis mëta feilawa baliti sisike mla, kwe Goto kë wesibi jwa seiju mëseme melowene lalëletë, ‘Bu feilawamu baliti sike ele.’ ");
INSERT INTO nce_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Fli oneho bubë feilawa baliti mëtëbetëme kwe tëlewa sike mëtla na fli mana mëtëbetëme. Kwe kë seiju mëse bu baliti iniwamu tlële, fli hana mëtëbetë. Na tokwafe hi wesibi fëye balitina glo eglemene? Hanane mu. Bubë iniwa baliti wayawe tolë.” ");
INSERT INTO nce_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisas na bubë lowene esogo mëglelëtlabë hona, tako lotu lo mago metëkaklija na mana bubë lowene esogo mëglelëtlabë ho li gali tlole, “Euowe, Tisa, ju hwi elome. Anijina kë gigliji mëtlabë lo bu lale klisomu. Bu aniji tatakomu na lale klisomu.” ");
INSERT INTO nce_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Na Jisas bubë gali tafu tëtatle, “Bo sobo, lo kë hwi eglomobë gali, të nëtatëyo. Tokwafe bu ebë iniwa lo yayei mogotomame. Fli aniji matawa hana mëgëbëme. Weyewa. Iniwa sisike mëkakame.” ");
INSERT INTO nce_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Na bu Oliv ti fatiniwa motokwala. Na Jisas kë fatini lufu mëta tafa tole na tako lotu lo hwi tëtelokwakle. Na Pita, Jems, Jon, Andruna buwa bu belë mitisitla, na takune motlola, ");
INSERT INTO nce_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ju seme gali enona. Gotobë lo yayeime, kë gali toglonabë gali, habenalë fata lëglemene? Sebo fëye wesibi afina hwi noglomamene na këme lowene nëlame, ‘Hai, kë olë nounou ekë lële.’ ” ");
INSERT INTO nce_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Na Jisas bubë gali tafu tëtatëme, “Sobo ululu slewa saelo. Ho some sogëna moglëyolime. ");
INSERT INTO nce_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Unina feilawa ho migisiyame na sogëname gali mlame, ‘Bo kë nëgebë kwe Gotobë life mago ho, onehome nëno nëgelëbë ho.’ Na bu feilawa onehome sosogëna mlagumame. ");
INSERT INTO nce_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Na tokwafe, sobo tako wame mëglabë gali aholokwane egelona, na li life elë wame gali fafa mogotlabë gali aholokwane egelona, klelego asa elo. Kë wame kwe melëmane, kwe ebë life tëbo lëglebë olë mana lebokwetle. ");
INSERT INTO nce_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Li life li life mago ho, li life hona momogli mëtayame. Na li life li life nano ekoujamëme. Na li life li life mago oneho, foneme gigli mokoujame. Kë wesibi bu tokwëtokwë eliliha, mëse nëba amlebo fene fale etamë. Kwe tokwafe tako elili fa mëtagulame. ");
INSERT INTO nce_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kë olëna, sobo ululu sle saelo. Sobo bome fwa lowene sle egletëname nëgeme na bu some bubë letitabobë toba elëme mëglelujome. Na bu some lotu lo mëta tëtëke mëgelulame. Na bu some gavman ho belë na eso ho belë sei mugujelëyome. Na kwe sobo Gotobë lale gali të eoutatemome. ");
INSERT INTO nce_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Bu Gotobë lale gali iniwa lifeku mago onehome afina të mëtatëmame na yawe olë mana fata lëleme. ");
INSERT INTO nce_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Bu some fafa mëglana, na hobë gali aholo bo lëgëtabë ho belë mëlelujona, sobo uli asa elo na melowene asa elo, ‘Sebo habë gali nëglamene?’ Weye. Iniwa gali, Goto some kë olëna kë lëglëyobë, të etlome. Sobowa të egotlome nane. Weye. Gotobë Amtëtomba lowene lëlëyome na kë lowenena të etatemome. ");
INSERT INTO nce_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Wali ho, fli home melëkei melëmame, bolijahanime mogo nalë tëbo namotomame. Na wali bolijaya mata bubë nëbaleme kë fene, melë mogotomame. Na wali nëbale bubë botaname bolijayaname wame molomame na wame home melëkei melëmame, mogo nalë tëbo namotomame. ");
INSERT INTO nce_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Sobo bome lowene sle egletëname nëgeme, iniwa oneho some këme gëglë mëgletëyome. Kwe ho bome fwa esogo lëglenënëna na bubë gli olë nëgena, bome mana esogo lëglenënëna, Goto bume no lëglëleme.” ");
INSERT INTO nce_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Na Jisas ita gali tlome, “Tokwafe sobo mehwi egelome, afefi life mëta home tëbo logotomebë wesibi fata lëgleme. Ho ebë gali hwi loglolena, lowene sle salëletle. Na kë olëna, oneho Judia lifate mëta kë tafa mëglabë, bu fatinina tabo elë matlebouja. ");
INSERT INTO nce_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Na ho lo sebati mëta lëtabena, bu lowa bubë wesibi glome asa malëkaklu. Weye. Lëglëbouwa malële. ");
INSERT INTO nce_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Na ho nuju mëta lëtabena, bubë lowa ëho glome asa maluju. Matëbe. Lëglëbouwa malële. ");
INSERT INTO nce_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","One, kë olëna, nëbale imonabë na one nëbale kolëbo nabë, bo bume tako maninibo nanëletemëmu. Masiwafe, bu habëna mëglënëboujamene? ");
INSERT INTO nce_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Sobo Gotome këme gali eglolome, haliji tu olëna kë wesibi fata jwa nalëgleme. ");
INSERT INTO nce_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kë tëbo olëna tëbo tafamu lëgëbeme. Këha hobota ëtani hana fata tletëme. Ëtanimu, Goto iniwa wesibi blëge totomebë olëna, këha tëbo wesibi hana tëbe. Na ëje mata, këha tëbo wesibi hana lëbe. Na tokwafe këha tëbo wesibi hana lëgëbeme. ");
INSERT INTO nce_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Goto bu kë tëbo olë lëkle jwa logotlebë kwe iniwa oneho tëbo miglitayame fene. Goto fli onehome melowene latletëme, ‘Bo ebë onehome waaniji tlomë, bu bobëmufe.’ Na bu kë onehome maninibo tëgletëmeme nëgeme na bu kë tëbo olë këme lëkle totle. ");
INSERT INTO nce_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Kë tëbo olëna, ho some megali lëglëyona, ‘Hwi elo, Goto onehome nënome kë aniji toglolebë ho, ekë lëtabe,’ o bu megali lëglëyona, ‘Hwi elo bu ekë tafa lule,’ sobo bubë gali asa aholokwane elolo. ");
INSERT INTO nce_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Fli ho migisiyana sogëname megali mëglame, ‘Bo ekë, Goto onehome nënome kë aniji toglonebë ho.’ Na fli ho mata sogëname megali mëglame, ‘Bo Gotobë gali nëgehilëbë ho, bo ekë.’ Na bu Gotobë afutuku fenene, klelegowa wesibi melë blëge motometëmame. Oneho bu meweniji namëglame, ‘Kë enëne Gotobë life mago enënefe.’ Na bu feilawa onehome sosogëna mlagumame na metole lamëtla, Goto bu kë aniji toglomebë onehome mata, sosogëna mlagumame fene. ");
INSERT INTO nce_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Këme nëgeme, ululu sle saelo. Bo some iniwa wesibi, unina mefata mëglebëme, wagali nëlëyo.” ");
INSERT INTO nce_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Na Jisas ita gali tle, “Kë tëbo olë yawe lëkakeme na mana kliji yemena u jwa mëgleme. ");
INSERT INTO nce_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Na sëgetoba matafa mago luklu mëleme na mitigome. Na iniwa matafa mago wesibina lili mëleme na tëbo mëleme. ");
INSERT INTO nce_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Na kwe, bo, Gotobë life mago ho, bo oloba nagi netujulëme. Na bobë tako lolokwënena, na tako kliji elulego fenene këhana iniwa nigisime. ");
INSERT INTO nce_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Na kë olëna, bobë enselme jine nëbelëkakëmëme. Na Goto kë aniji loglomebë onehome loloko mëtagujayame. Na Gotobë onehome iniwa life mago nëno mokoujame. Matafana, lifena këme tou mëglebë mago.” ");
INSERT INTO nce_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Jisas ita gali tle, “Sobo binibwe time lowene sle egletemome. Bubë laba luklu lëglena na tahweji foke lëglena sobo këme lowene elome, ‘Ebë wanagli tei fe.’ ");
INSERT INTO nce_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kë fenene. Sobo kë tëbo olë hwi eglolona, sobo melowene naegletelome, ‘Bo nigisibë olë nounoumu lalële.’ ");
INSERT INTO nce_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Bo some nëgali nanëlëyo, fli oneho bu ebë olëna kë tafa mëglabë, bu mana mëtabëyame na kë iniwa tëbo wesibi mana fata mëgleme. ");
INSERT INTO nce_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Lifena matafana tëbo mëgleme, kwe bobë anebo gali unaunalëme melë lëgëbekëfeme.” ");
INSERT INTO nce_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Jisas bu ita gali tle, “Ho liha bo këna nigisibë olë, lowene hana lëletle. Heven life mago ensel mata lowene hana mletla. Na bo, bubë bowene, mata lowene hana nëletelë. Aya buwa lowene lëletle. ");
INSERT INTO nce_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Bobë nigisibë olë, sobo lowene hana eletelome nëgeme. Këme nëgeme sobo ululu sle saelo na walena satafa elo. ");
INSERT INTO nce_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Bo nuguwibë na ita nigisibë, ebë ho bubë lo kile lëglebë fenene na li lifewa luju. Bu bubë mëta kë wege mëglekefëyabë home afina gali tlome, ‘Bobë wesibi sahwi elokwefëmetëna.’ Na bu wege bwa bwa tlëwagume. Na bubë lo mëta kë sei lëglëkeflebë home gali tlole, ‘Bo nigisibë olëme, ju walena satafa ele.’ ");
INSERT INTO nce_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Na sobo mata mehwi egletëname, kë ho fene hwi lële. Bo lo bolijayaha ho. Na sobo bobë nigisi olëme lowene hana elo. Bo fole olëna nigisimenawa o olobalë nigisimenawa o taboklë nigisimenawa o klabë kuna nigisimenawa. Sobo kë olë lowene hana eletelo. ");
INSERT INTO nce_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Bo hokweinawa nigisina, na bo some nina hwi noglokwakijona, kwe kë lale nane? Weye. Kë tëbomu. ");
INSERT INTO nce_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ebë gali, kë gali noglëyobë, bo iniwa onehome gali nolomë. Sobo sagli elolome na mana walena satafa elo.” ");
INSERT INTO nce_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tële olë mana mëtebokwe na Israelbë afenëbobë tako lotu olë mana folokoke tëmeme. Israelbë afenëbo bu kë olëna, Goto ëtani bolijafujunime këna tëgaitamebë olë na Isip lifate këna kile mëtëglabë olë, lowene mëtlekefëtla. Na li lotu olë, bu sëse wesibina afulu jwa mëglabë bletë nage hi mëtlekefëya. Na lotu eso enëne na Gotobë tafa sle gali lowene sle mëgletlabë enëne bu kë olëna blalo gëgali mëtla, “Sebo Jisasme hwelutuwa habëna fa nogotlamene na mogo nalë tëkle notlame. ");
INSERT INTO nce_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Sebo kë wesibi, Juda life onehobë tako lotu olëna asa manotla. Sebo tako lotu olëna melë nëglana kwe oneho tako wame huju mogotlame.” ");
INSERT INTO nce_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisas bu Saimonbë lo mëta tafa tle, Betani life mëta. Ëtani, Saimonbë ato juba jubawa tëgëbetlena na Jisas sle totle. Na Jisas bu masei li mëta tafa tle. Na mëse li mana tisi. Na bu lale lëkaluwa tu aniji botolona tehitle. Kë tubë baliti feilawamu. Na bu kë botolobë ëfo tika totle na lëkaluwa tu Jisasbë eso mëta wë totatle. ");
INSERT INTO nce_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kwe fli ho kë tafa mëtlabë, bu hwi motlola na witi mëtla, na blalo gëgali mëtla, “Bu kë lale lëkaluwa tu blawa fëyeme wë etatlene? ");
INSERT INTO nce_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Sebo kë lëkaluwa tu li hona balitina hihijikame nëglëlana kwe sebo 300 baliti këniji glo nëglame na kë baliti, baliti jwa home nëlëmame.” Na bu kë mëseme wame gali motlëya. ");
INSERT INTO nce_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Na kwe Jisas gali tlome, “Matëbe. Bume asa gali elëyo. Bume fëyeme wame gali elëyone? Bu bome slemu latanëyo. ");
INSERT INTO nce_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Baliti jwa enëne, sobona unaunalëme tafa eglekefome. Na sobo agaitamome tole egletemona, lalowa egaitamome. Bo kwe sobona unaunalëme hana tafa nëglame. Bo sobona tafa jwa nëglana habëna egaitanamene, ebë mëse ëje fene aitanë? ");
INSERT INTO nce_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ebë mëse wesibi melë kë egëtatenëbë këwa melë tei etle. Bu melë, bu lëkaluwa tu bobë eso mëta wë eotatenë na bobë ato kë tuna matëmatëme nëgebëbëme sagli elëtenë. Bo some nëgalimu nanëlëyo. ");
INSERT INTO nce_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Bu tokwafe iniwa life, Gotobë lale gali të mëtagulana, kwe bu mëse kë wë tëtatlebë galime të namëtakefëtëyame na bu këme lowene namëgletëyame.” ");
INSERT INTO nce_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kë nalëwa, Judas Iskariot, bu lotu eso home tujutëme na gali tujuwelëme, “Bo tokwafe Jisasme yo noglëyome.” Judas bu we ita telë Jisasbë lowene esogo mëglelëtlabë ho, bu mago li. ");
INSERT INTO nce_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Na lotu eso ho bu kë gali aholokwane mëtla na maninibona sle memëtla. Na bume gali sle motlola, “Sebo jume baliti nëglëyome.” ");
INSERT INTO nce_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na sëse wesibina afulu jwa mëglabë bletë nage kë hi mëtlekefëyabë olë wafolokoke. Kë olëna bu afeku sipsip kleli tëtëkle mëtëtakefëya na hi hi mëtla. Goto bubë bolijafujunime kë taitamebë olëbë lowene namëgletlame nëgeme, bu sipsip kleli këme tëtëkle mëtëtakefëya. Na Jisasbë lowene esogo mëglelëtlabë ho, bume gali motlola, “Sebo kë tako hi wesibi fëye lo mëta sle nogotomamene, Goto sebobë afuninome kë tëgaitamebë olë lowene nanëgletlame?” ");
INSERT INTO nce_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Na Jisas bubë lowene esogo mëglelëtlabë ho tlemalëme jine tlëme na gali tlome, “Sobo lifate takowa eyeumo. Na tu kë lëgehulebë ho some alëgeme esune lëglëyome. Sobo bume nagi elëkaklome. ");
INSERT INTO nce_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Bu lowa lëkakluna, sobo mata saekaklujo na kë lo bolijaya home megali elujololome, ‘Tisa bu megali lalële, “Hi lo hametane? Na bo na bobë lowene esogo mëtlelëtënabë hona kë hi lo mëta, sipsip kleli hi nanëglelëmëme, Goto bu sebobë afuninome kë taitamebë olë lowene nanëgletlame.” ’ ");
INSERT INTO nce_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Na kwe bu some nogowelë kë logobebë lo lebotane lëgëtatëyome. Kë lo bu maseina, tafa labuna, na bu këna iniwa wasle totome. Na sobo kë hi lo mëta sebobë hi wesibi sle etomome.” ");
INSERT INTO nce_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Na kwe kë lowene esogo mëtlelëtelobë ho mëtëyeu. Na bu lifate takowa fwa mutulo, na bu iniwa wesibi hwi motlomo, Jisas fene gali tlome. Na bu hi wesibi sle mutujetomo. Na bu Jisas belë ita mëtëyeu. ");
INSERT INTO nce_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Na taboklë, Jisas bubë we ita tële lowene esogo mëglelëtlabë home tlesume. ");
INSERT INTO nce_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Na bu masei labu li mëta tafa motokouja. Na mana hi motokouja na Jisas mana gali tlome, “Bo some nëgalimu nanëlëyo, ho li, sobona kë tafa egelobë, bome wame home yo loglomeme. Kë ho bu bona ekë hi nelo.” ");
INSERT INTO nce_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Na bubë lowene esogo mëglelëtlabë ho këbë gali yafe aholokwane motlola na kwe bubë lowene mëta sle hana tletëme na witina tafa mëtla. Na jowa jowa ho bume takune motlola, “Ju bomeha gali elene?” ");
INSERT INTO nce_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Na Jisas gali tlome, “Kë ho bu sobo we ita tële hobë ku mëta kë lëtabetëyo. Kë ho bu bona weife hi nelo. Bo buna bletë nage, hi wesibi tu mëta weife fuflu notomo. ");
INSERT INTO nce_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ëtani, bu Gotobë bogo mëta meyahi lamëtla, ‘Gotobë life mago ho, bu gli lëgleme.’ Na bo, Gotobë life mago ho, bo gli nëgelëme ekë, Gotobë bogo fene gali tla. Masiwafe, bome, Gotobë life mago home, wame home kë yo loglënëbë ho, bo bume tako maninibomu nanëletelëfe. Tokwafe bu tëbo liglitamemu. Bota kë home fata jwa egotlebë kwe ebë lalowamu.” ");
INSERT INTO nce_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Bu mana hi motokouja na Jisas bletë nage fa totle, na Gotome fleflesu gali tlole, na fufu totle na bubë lowene esogo mëglelëtlabë home satëtagutëme. Na gali tlome, “Sobo hi elo, ebë bobë ato.” ");
INSERT INTO nce_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Na bu wain taba liji tuna kabo fa tëtatëme na Gotome lale galimu tlole, na mana tlëme. Na iniwa kë kabo mago hi motokouja. ");
INSERT INTO nce_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Na Jisas gali tlome, “Ebë bobë wino. Bobë wino kë lugujubë, feilawa onehome lëgaitame nalëgleme. Bobë wino kë lugujubë këme lëlekuju tle, Gotobë gali nëgali galimufe na Goto bu melë lëgleme bu ëtani fene gali sle tle. ");
INSERT INTO nce_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Bo some nëgalimu nanëlëyo, bo wain taba liji tu eli hana hi nëgelëme. Kwe tokwafe, Goto bu onehobë eso home kë tafa lëgletëmebë life mëta fwa, bo tiho wain taba liji tu mana hi nëgelëme.” ");
INSERT INTO nce_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Na kwe bu Gotobë fleflesu sawa jowa fë mëtëtaya, na bu lifate tako kile mëtla na Oliv ti fatiniwa mutuja. ");
INSERT INTO nce_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisas bubë lowene esogo mëglelëtlabë home megali latlome, “Sobo tokwafe bome ulime kile egëtaname. Goto, bubë bogo mëta megali tëgleme nëgeme, ‘Bo sipsip kleli lëglëme home mogo nalë tëbo nogotlëme na sipsip kleli ulime mëglënëboume.’ ");
INSERT INTO nce_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kwe bo gli nelëme na huju nelëme na bo afina some Galili provinswa noutatëyome.” ");
INSERT INTO nce_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita bume gali tlole, “Kë enëne jume kile mëgëtona, kwe bo jume hana kile nëgëtëmemu. Hanane mu.” ");
INSERT INTO nce_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Na Jisas bume megali latlole, “Bo jume nëgali gali gali nolë, eli klabë, kakalo tëlafe huju jwa lëglena, ju bome kë lowene egletenëbë lowenebëme aowafe able eglomeme.” ");
INSERT INTO nce_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kwe Pita Jisasme anisasana gali tlole, “Bo juna ko nëgelona, bo jume kë lowene nëgletëbë lowenebëme hana able nëgelëme. Hanane mu.” Na bubë iniwa lowene esogo mëglelëtlabë ho mata megali motokouja, Pita fene gali tle. ");
INSERT INTO nce_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jisas bubë lowene esogo mëglelëtlabë hona nujuwa fwa mutula. Kë nujubë weniji Getsemani. Na Jisas bume gali tlome, “Sobo emëta tafa elo. Bo Gotome gëgali nanëglelëlëme.” ");
INSERT INTO nce_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Na bu Pita, Jems, Jonname tlelume. Na bubë lowene mëta tako hobota fata tletle na tutune tle. ");
INSERT INTO nce_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Na bume gali tlome, “Bo tako hobota nanëlëyo. Kë tako hobota lowenebë bome tako boblo laletanë. Sobo ni asa ebo, emëta hwina tafa elo.” ");
INSERT INTO nce_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Na sogë fewa tëkake. Na life mëta latitigowa na Gotome gëgali tlelële. Bu metole latle, ebë enisusu na tëbo wesibi bume kë migisitlebë, bume sigli namogotleme fene. ");
INSERT INTO nce_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Na bu Gotome megëgali latlelële, “O aya. Ju iniwa wesibi melë lalowa egotomeme. Na bo metole nanelë, ju ebë tëbo wesibi bome kë migisitenëbë, bo mago sike ekaketenë, na bome migisitenë jwa namëgleme. Kwe ju bobë tole asa esogo elelëtenë. Weye. Matëbo. Jubë tolewa esogo eglelëleme.” ");
INSERT INTO nce_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Na Jisas bubë lowene esogo mëglelëtlabë ho aomalë betelë tujutëme. Na bume nina hwi tlome. Na Saimon Pitame takune tlole, “Pita, ju fëyeme ni ebene? Ju tako tafa hana ele na hokweinawa fëyeme ni ebene? ");
INSERT INTO nce_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Sobo ni asa ebo. Tafawa elome na Gotome gëgali elelëlome. Satan some su lëgëtolime, sobo tëbo lowene esogo jwa naeglelëlome. Sobobë lowene lalowa lëbeteyo kwe sobobë ato mogowa lëbetëyo.” ");
INSERT INTO nce_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Na Jisas bu ita tuju na bu Gotome ita gëgali tlelële, otome fene gëgali tlelële. ");
INSERT INTO nce_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Na bubë lowene esogo mëglelëtlabë hobëtelë ita tisitëme, na bume nina hwi tlokwakime, bu tako nilafalemu memëtla. Na Jisas bume huhuju totome, na bume tiniji na hwë memëtletla na lowene mëtla, “Habë gali noglolamene?” Bu ni mëtëbeyame nëgeme. Na Jisasme hwiwa motlola. ");
INSERT INTO nce_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tokwafe Jisas aowafeme tisitëme. Na bubë lowene esogo mëglelëtlabë home gali tlome, “Sobo itaita fëyeme ni ebekefone? Tatei! Bo, Gotobë life mago ho, bu bome tëbo lowene esogo mëglelëlabë home yo loglomebë olë, ekë folokoke. ");
INSERT INTO nce_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Hwi elo. Bome yo loglomebë ho ekë fata lële. Sobo huhuju elo na bu belë nuguja nanëglame.” ");
INSERT INTO nce_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisas mana gëgali tle na Judas mana tujutëme. Judas, ebë Jisasbë lowene esogo lëglelëtlebë ho li. Jisasbë lowene esogo mëglelëtlabë ho këniji, we ita tële. Na feilawa ho Judasna mitisiya. Na bu kosina, atobeilana mëtehweija. Na lotu lo mëta wege mëglabë eso enëne na Gotobë tafa sle gali lowene sle mëgletlabë ho na lotu letitabo ho, bume jine mëtelëkakëma. ");
INSERT INTO nce_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ëbame, Jisasme yo gali kë loglomebë ho, bume megali latlome, “Bo tokwafe some melë lëlekuju nëgletëyome. Bo ahino mëta momotlë notlëme na sobo mehwi elome kë ho, ebë Jisas. Sobo kë home fa etlome na kiki sle etlome na elelulome.” ");
INSERT INTO nce_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Na ebë olë Judas tisi, na Jisas belë hokweinawa tujutle, na gali tlole, “O Tisa.” Na bume ahino momotlë tletle. ");
INSERT INTO nce_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Na bu Jisasme fa mototla na kiki mototla. ");
INSERT INTO nce_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kwe li ho, kë mëta kë tiglibebë, bu Gotobë lo mëta wege mëglabë eso hobë, wege hobë aholo kosina sika metëtatle. Na aholo life mëta latitigotlewa. ");
INSERT INTO nce_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Na Jisas bume gali tlome, “Sobo kosina atobeilana bome fame fëyeme esijone, tokli home fame fene mutujutla? ");
INSERT INTO nce_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Iniwa olë, bo tako lotu lo mëta kë tafa tëglekëfebë na onehome gali kë të tëgëtakefëtemëbë, sobo bome mana fa tëtana jwa fëyemene? Kwe matëbe. Gotobë bogo mago gali metëgëbetenë watle, kë nëgali galimu lëgëbeme.” ");
INSERT INTO nce_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Na Jisasbë lowene esogo mëglelëtlabë ho iniwa ulime lamëtlënëboujawa. ");
INSERT INTO nce_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Na falake ho, tatiwa lablab ëhowa kë sabu togotlebë, Jisasme nagi esogo tlagile. Na bume yafe fa mototla, ");
INSERT INTO nce_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","kwe bu kë tatiwa ëhowa kile tëkake na flatabowa latlëboukakuwa. ");
INSERT INTO nce_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jisasme kë fa mototlabë ho, lotu lo mëta wege mëglabë enënebë eso hobë lowa mëtlelula. Na lotu lo mëta wege mëglabë eso enëne, na letitabo enëne, na Gotobë tafa sle gali lowene sle mëgletlabë enëne, iniwa loko mëtlelëya. ");
INSERT INTO nce_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Na Pita, Jisasme nagi nagiwa esogo tlagule. Na bu lotu lo mëta wege mëglabë hobë eso hobë lo li mago lëglesi elë tëkaklu. Na bu lo mëta kë sei moglokweflabë hona tafa mëtla na ahojume satle. ");
INSERT INTO nce_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Lotu lo mëta wege mëglabë eso enënena hobë gali aholokwane mëglabë letitabo ho, fli onehome, gali tuku mëtletëma, “Sobo Jisasbë tëbo lowene hwi eglotelona, kwe sobo esijome na kë galibë të etatëname.” Bu metole lamëtla, Jisasme so mëtatlame na bume mogo nalë tëkle namogotlame. Kwe oneho bu gali të sle hana mëtëtatla. ");
INSERT INTO nce_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Feilawa ho bume sogëna gali so mëtëtatëma, kwe bubë gali bwa bwa lowene mëta tëbetëme na jowa lowene mëta hana tëbetëme. ");
INSERT INTO nce_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Na fli ho bu Jisasme gali meso mëtëtatla, ");
INSERT INTO nce_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Sebo waaholokwane tlola, bu megali latle, ‘Bo ebë tako lotu lo, ho tobana kë gliji mëtlabë, yayei nogotlëme. Na bo aona olënawa li gliji nëgelëme, kwe bo tobana hana gliji nëgelëme.’ ” ");
INSERT INTO nce_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kwe kë gali bu kë gëgali mëtlabë, bu mata bwa bwa lowene mëta gëgali mëtla na jowa lowene mëta fwa hana gali mëtla. ");
INSERT INTO nce_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Na lotu lo mëta wege mëglabë enënebë eso ho, bu hobë gali aholokwane mëglabë letitabo hobë li mëta tlibe na Jisasme takune tlole, “Kë enëne jume so namëtatëyo. Ju bume kofaya gali gali eglome jwa fëyemene?” ");
INSERT INTO nce_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kwe Jisas mogweliha latiglibewa na bume gali hana tafu tëtatëme. Na lotu lo mëta wege mëglabë enënebë eso ho bume gali tlole, “Ju ebë ho kë nëgebëne, Goto jume kë aniji toglëbë, onehome nëno naeglemene? Ju kë hone? Ju lale Gotobë nëbane?” ");
INSERT INTO nce_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Na Jisas gali tlole, “Bo ta kë hofe. Na tokwafe, sobo mehwi egloname, bo, Gotobë life mago ho, bo tako kalëlegona Gotobë tobamu toba elë tafa nëgelëme. Na bo heven life mago oloba nagi nëgetujulëme.” ");
INSERT INTO nce_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Na lotu lo mëta wege mëglabë enënebë eso ho bu Jisasbë gali aholokwane tlole, na bubë ato mago ëho kaka totle, bu Jisasbë galime hobota tëgletleme nëgeme. Na bu gali tle, “Sebo fli enëneme hana gali noglomame, seme kë hobë tëbo loweneme gëgali namëglame. Weye. Matëbemu. ");
INSERT INTO nce_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Sobo bubë gali waaholokwane tlolo, bu megali latle, ‘Bo Goto fenene.’ Kë gali tëbomu. Bu Gotome tëbo gali latlole. Na sobo habelë lowene lalone, sebo habelë nogotlamene?” Na iniwa anisasana jiyakle mëtla, “Bu tëbo lowenena ho, gli malële.” ");
INSERT INTO nce_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Na fli ho bume nagutabana kokose mëtlëla. Na bubë naba ëhona lamu mototometla na bume mana tëkle mototla na takune motlola, “Ju iniwa wesibi lowene egletëmena kwe ju seme gali elona, jume ya tëkle lëtane?” Na lo mëta kë sei mëglëkeflabë ho bume mata tëkle mototla. ");
INSERT INTO nce_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita lo li mago lëglesi tabo lifeku mëta mana tlibe. Na lotu lo mëta wege mëglabë enënebë eso hobë wege mëse tisi. ");
INSERT INTO nce_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Na bu Pitame hwi tlole, ahojume sa tle. Na kë wege mëse bume hwi sle tlole, na gali tlole, “Ju mata, Nasaret life mago Jisasna, kë tafa tëgelobë ho li.” ");
INSERT INTO nce_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kwe Pita bu able tle, “Ju kë gali eglebë gali bo lowene hana nëletelë. Hanane mu.” Na bu ino ëfo elë tuju na ino ëfo mago lëglesi mëta mana telutabe. Na hokweinawa kakalo huju tle. ");
INSERT INTO nce_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Na kë wege mëse bume ita hwi tlole na bu kë tafa mëglabë home gali tlome, “Ebë ho kë nëgebë, buna kë asë mëtëglabë ho li ekëyo.” ");
INSERT INTO nce_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kwe bu ita able tle, “Hanane mu.” Na Pita sogë tëtelëkakewatle, na buna kë mitlijabë ho Pitame gali motlola, “Nëgali mu. Ju buna kë asë tëgelobë ho li ta ekë. Ju mata Galili provins mago ho nëgeme.” ");
INSERT INTO nce_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Na Pita bu anisasanamu gali tlome na kakëne tletëme, “Iyemanemu! Bo kë home lowene hana nëletelëmu. Hanane mu. Bo nëgali gali hana nëgelëna na Goto bu bome tëbo lëgëtanëna kwe tëbo malëtanë.” ");
INSERT INTO nce_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Bu wagali tle, na kakalo mana huju tle. Na Pita, Jisas kë gali toglolebë gali ita lowene tletle, “Eli klabë, kakalo tëlafe huju jwa lëglena, ju bome kë lowene egletenëbë loweneme aowafe able eglomeme.” Na Pita kë gali ita lowene tletle na bu wabelë tle na tako yemu kletotle. ");
INSERT INTO nce_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Olobalëwamu, lotu eso enëne, na lotu letitabo ho, na Gotobë tafa sle gali lowene sle mëgletlabë ho, na hobë gali aholokwane mëglabë letitabo ho, bu iniwa loko motokweija na blalo gali sle mototla wesibi mogotlabëme, “Sebo habelë nëglamene?” Bu gali wasle mototla na Jisasme tabana lei mototla na eso ho Pailat belë mëtlelula. ");
INSERT INTO nce_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Na Pailat Jisasme takune tlole, “Ju Juda enënebë tako eso hone?” Na Jisas tafu tëtatle, “Nakwefëyemene. Ju fene gali ele.” ");
INSERT INTO nce_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Na lotu eso ho Jisasme lebutako gali so mëtëtatla. ");
INSERT INTO nce_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Na Pailat bume ita gali tlole, “Bu feilawa gali jume so mëtatëyo, na ju gali tafujwa fëyeme etatëmene?” ");
INSERT INTO nce_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kwe Jisas gali tafu hana tëtatle, bu mogweliha tëtabe. Na Pailat bu këme tutune tle. ");
INSERT INTO nce_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Jowa jowa tlibutuna, bubë tako lotu olëna, oneho kalabusu lo mago hobë weniji fëfë mototokwefëma na Pailat bu kë hobë weniji aholokwane lëletle na kë home kalabusu lo mago jine lelëkakëtëme. ");
INSERT INTO nce_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ebë olëna, li ho bu kalabusu lo mëta tafa tle. Bubë weniji Barabas. Ëbame Barabasna fli hona, bu gavman enëneme tako wame motloma na ho flime mogo nalë tëtëkle mototoma. Na gavman enëne bu kë home kalabusu lowa sike mëtla. ");
INSERT INTO nce_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Na oneho Pailatme mitisitla na gali motlola, “Ju seme jowa kalabusu lo mago home jine elëtëna, ju seme ëbame ho li kalabusu lo mago fene jine tlëtëna.” ");
INSERT INTO nce_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Na Pailat bume takune tlome, “Sobo metole lalone? Bo some, Juda life mago onehobë eso ho, Jisasme, kalabusu lo mago jine nëglëtëyomene?” ");
INSERT INTO nce_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat bu megali fëyeme lëlene? Bu melowene lëgleme nëgeme. “Lotu lo mëta wege mëglabë eso enëne bu Jisasme tëboijiwamu lamletla na bu bo mëta këme melesula.” ");
INSERT INTO nce_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kwe lotu lo mëta wege mëglabë eso enëne, bu onehome anisasana gali tlome, “Sobo Pailatme, gali elëlo, ‘Jisas matëbo. Barabasme fwa kalabusu lo mago jine elobakëtëna.’ ” ");
INSERT INTO nce_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Na Pailat bume metakune tlome, “Kë ho, sobo mefë kë egotlobë, ‘Israelbë afenëbonibë eso ho,’ bo bume habelë nogotlëmene?” ");
INSERT INTO nce_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Na bu feilawa anisasana jiyakle memëtlelëla, “Bume ti mëta nilina bu elo.” ");
INSERT INTO nce_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Kwe Pailat takune tlome, “Sobo fëyeme gali elone? Bu fëye tëbo wesibi fa totlene? Bu fëye tlene?” Kwe bu feilawa anisasana jiyakle memëtlelëla, “Bume ti mëta nilina bu elo.” ");
INSERT INTO nce_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pailat bu melëme tole tle, oneho bume fleflesu namëgletlame nëgeme, na bu Barabasme kalabusu lo mago këme jine tletëme. Na bu fli home gali tlome, “Sobo Jisasme taba afona feilawa lëlafa etlome.” Na bu Jisasme taba afona feilawa lëlafa mototla. Na tokwafe bu Jisasme wame home boblo mogotomabë enëneme tlëme, bume ti mëta nilina bu namëglame. ");
INSERT INTO nce_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Fli wame home boblo mogotomabë enëne, bu Jisasme eso hobë tako lowa mëtlelëkakula, na bu fli wame home boblo mogotomabë enëneme gali mëtelokwakëma. Na bu iniwa mitisiya. ");
INSERT INTO nce_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Na bu Jisasme winowa ëho mëtehwatla, eso hoha nafata lëgleme. Na bu analëbana taba glo mëtla, na eso hobë eso afeteniha hwatë mëtletla, na bubë eso mëta gelo mëtëtatla. ");
INSERT INTO nce_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Na bu tiniji galina gali motlola, “O Israelbë afenëbonibë eso ho, lale olobalë?” ");
INSERT INTO nce_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Na bubë eso elëme atobeilana tëke motlola na bume nagutabana kokose mëtlëla. Na bu Jisasbë elebo li mëta bubusu mëtletla, eso home fene bubusu mletla. ");
INSERT INTO nce_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bu Jisasme këbë iniwa tiniji galina wafi gali motlola. Na bu kë winowa ëho tika mëtëtatla na bubë ëhomu gelo mëtëtatla. Na bume mëtlelula, bume ti mëta nilina bu namëglame. ");
INSERT INTO nce_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Bu Jisasme mëtlelula na li ho, bubë weniji Saimon, Sairini lifate mago ho, bu li lifate mago tisi na lifate takowa tuju. Kwe wame home boblo mogotomabë enëne bume alëgeme esune mëtlëla na enisusuna gali motlola, “Se! Ju Jisasbë ti mana ehule.” Na bu mana tehule. Saimon bu Aleksandernabë, Rufusnabë bolijaya. ");
INSERT INTO nce_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Na bu Jisasme Golgota lifekuwa mitilekola. Golgota weniji bu ebëha gali fenene, “Hobë eso eleboha life.” ");
INSERT INTO nce_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Na bu Jisasme wain taba liji tu, malasini na sago, yafe fwei mëtlëla, tako elili fa jwa nalogotleme fene. Kwe bu yo latletëme na hana hi tle. ");
INSERT INTO nce_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Na kwe, wame home boblo mogotomabë enëne bu Jisasme ti mëta nilina bu mëtla. Na bubë ato mago ëho melëna sa mëtëtaya. Bu satu salë mëtla na ho mana aniji motloma jowa jowa wesibi glo namëglabëme. ");
INSERT INTO nce_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Olobalë, klijina, bu Jisasme ti mëta nilina bu mëtla. ");
INSERT INTO nce_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Na bu ti katabo, eso matawa elë fla mëtëtatla. Na bume kë so mëtëtatlabë gali, kë mëta yahi mëtla. Bu meyahi lamëtla, “Juda lifate magobë eso ho.” ");
INSERT INTO nce_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Na bu Jisasbë ti li mëta, tlemalë tokli home ti mëta bu mëtla. Lime tobamu elë lë mototla na lime yemane toba elë lë mototla. ");
INSERT INTO nce_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na lifate mago kë mitisiya, mutujabë oneho, bubë eso luluju mototoma na Jisasme sosonatlëtlë memototla, “Te, ju ëbame megali latle, ‘Bo ebë tako lotu lo yayei notlëme na aona olënawa li gliji nelëme.’ ");
INSERT INTO nce_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Te, ju këha afutukuna ho kwe ju eli jubë ato mana aitale na kë ti mago kle etëkekeme.” ");
INSERT INTO nce_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Na lotu lo mëta wege mëglabë eso enëne na Gotobë tafa sle gali lowene sle mëgletlabë ho bu mata Jisasme tëtane lamëtëbetla na blalo gëgali mëtla, “Bu fli home taitame na kwe bubë ato lëgaitale hana lëgleme. ");
INSERT INTO nce_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kë ho bu ëtani megali latle, ‘Bo kë ho kë nëgebë, Goto bome kë aniji toglonëbë ho, onehome nëno nanëgelëme.’ Na bu mata megali latle, ‘Bo Israel life mago onehobë eso ho.’ Te, sebo kë home nabana mehwi noglolana, ti mago kle loleme, kwe sebo mana bume lowene sle nanëletlame.” Na ebë tlemalë tokli ho, Jisasbë li mëta ti mëta kë bu mëtlabë, bu mata, Jisasme tiniji galina gali motlolo. ");
INSERT INTO nce_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kliji kuna, kwe klabëha ki tëbetëme. Na kë tëgemolebëë na taboklë klijina ita fetiha tëbetëme. ");
INSERT INTO nce_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Na taboklë, klijina Jisas anisasana we tlole, “Eloi, Eloi, lama sabaktani!” Kë galibë ebëha gali fenene, “Bobë Goto, bobë Goto, ju bome fëyeme kile etanëne?” ");
INSERT INTO nce_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Fli ho, lolime kë tafa mëtlabë, bu kë we lego aholokwane motlola na gali mëtla, “Aholokwane elo. Elaijame we lolole.” ");
INSERT INTO nce_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Na li ho fëka tlagutle, na bu sufa iniluha wesibi, wain taba liji tu mëta flu tëtatle na klenëba mëta lei tëtatle. Na këna Jisasme mana fwei telokwakle, wain taba liji tu slo nalëgleme. Na bu gali tle, “Awiya, sebo hwi nolola, bale Elaija bu ligisina na kle lëtlelëbakleme nawa o hanane.” ");
INSERT INTO nce_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Na Jisas feilawa aflei tle na lagliwa tle. ");
INSERT INTO nce_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Na kë tako ëho, bu tako lotu lo ino ëfo mëta këkesi tëglebë, lakawa tëmalita kufe lokwati. ");
INSERT INTO nce_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na wame home boblo mogotomabë enënebë eso ho, bu Jisasbë li mëta tlibe. Bu Jisasbë aflei lego aholokwane tle na kë gli tëglebë hwi tlole na gali tle, “Euowe, nëgali fe, bu Gotobë nëbafe.” ");
INSERT INTO nce_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Na aomalë one bu kakëha mëtelubokwëya na hwi mëtelokwakëma. Li mësebëye, buna tafa mëtla, bubë weniji Maria, Makdala lifate mago. Na li mata, bubë weniji Maria, Jems tokwëfo nabë, Josep nabë bota, na li mësebë weniji Salome. ");
INSERT INTO nce_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ëbame Jisas Galili provins mëta tafa tëglena, kë aomalë one bume nagi esogo esogo mëtlelëla na mana mëtaitakefla. Na fli lebutako one mata, kë mëta kë mitlijabë bu iniwa Jisasna Jerusalem lifatewa mitisiya. ");
INSERT INTO nce_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Na taboklë, Arimatea life mago Josep, tisi. Bu hobë gali aholokwane mëglabë letitabo ho li. Bu lale homu. Bu mata, Goto iniwa onehobë eso ho kë tafa lëgletëmebë olë hwi loglolebëme hwi lalëlekëfe. Ebë olë ebë Fraide, wesibi sle mototokwefëmabë olë. Uniji ebë bubë tafawa mëgla olë nëgeme, na bu kë olëye wesibi hana sle motomame. Na Josep bu eso ho Pailat belë tujutle. Bu bume uli hana tletle. Na takune tlole, “Bo Jisas mogome ti mago lalowa tohwa nogotlëmene o hanane?” ");
INSERT INTO nce_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Na Pailat bu klelego latle na melowene latle, “Bu waglinawa.” Na bu wame home boblo mogotomabë enënebë eso home gali tujuwelële, ligisinalëgleme. Na bu belë tisi na Pailat bume takune tlole, “Jisas wagli lëlene o mana hwi lëtane?” ");
INSERT INTO nce_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Na kë ho bume gali tlole, “Nëgalimu. Wagli lële.” Bu kë gali aholokwane tle na Josepme gali tlole, “Ju Jisas mogome lalowa tohwa etle.” ");
INSERT INTO nce_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Na kwe Josep bu lale tatiwa ëho heletabo, balitina fa tëtatle na bu Jisas mogome kë ëhona lalei totle. Na bu mogo tehule na aniji fuluju matëmatë mëta gwa telujuwetle. Ho bu kë aniji fuluju tobana go mëtlelëya. Na Josep aniji tako obobwelë tëtagiji na kë aniji fuluju ëfo tiji tletle. ");
INSERT INTO nce_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Na Makdala life mago Maria, na li Maria, Josep bota, bu lolime tafa mëtelo. Na bu Jisas mogome këme gwa togotlebë aniji fuluju hwi mëtlëyo. ");
INSERT INTO nce_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tafawa olë yawe tle, na Makdala life mago Maria, na li Maria, Jems bota, na Salome, bu lëkaluwa welë tu, balitina glo mëtla, Jisas mogome këna tefo namogotlame. ");
INSERT INTO nce_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Na Sande, olobalëmu, bu aniji fuluju matëmatëwa mutuja. ");
INSERT INTO nce_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bu mutujabë, na alëgeme blalo gëgali mëtla, “Seme ya lëgaitanamene, kë tako aniji, matëmatë fuluju ëfo mago obwelë nanëgëtayame.” ");
INSERT INTO nce_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kwe bu mitisiya na lolime mitlija na hwi mëtëkaka, “Aniji, matëmatë ëfo mëta hana ebamëfe. Kë aniji waobobwelë mëtagujayafe.” Kë aniji tako anijimu. ");
INSERT INTO nce_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Na bu kë aniji fuluju matëmatë elë mëtëkakluja. Na bu falake home, tobamu elë kë tafa tëglebë, hwi mëtelëjuwelëla. Bubë ëho heletabo na tatiwamu. Bu kë home hwi motlola na klelego memëtletla, na ulina memëtletla. ");
INSERT INTO nce_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Na bume gali tlome, “Sobo klelego asa elo. Bo walowene nelë, sobo Nasaret life mago Jisasme hohwi etatelo, ti mëta kë bu mëtlabë home hohwi etatelo. Bu eme hana tafa lële. Bu wahuju lële. Sobo hwi elo, eme kë gwa mototlabë tala alujawa ekë lëbe. ");
INSERT INTO nce_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kwe sobo Pita name, bubë lowene esogo mëglelëtlabë ho fli name sagali ejuwelëmo, ‘Jisas bu afina Galili provinswa waloutatëyo. Na sobo bume këme hwi egujuwelëlome, bu ëbame fene gali tëlëyo.’ ” ");
INSERT INTO nce_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Na kwe, one bu aniji fuluju matëmatë mago mëtëkaklija na mëtlëbouja. Bu klelego memëtla na lilina hwei memëtla. Na bu këme fli enëneme li gali meha hana gali motloma, bu uli mëtlame nëgeme. ");
INSERT INTO nce_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jisas bu Sande olobalëmu matëmatë mago huju tle. Na bu Makdala life mago Mariame afina tuhu tlelë. Jisas bu ëtani tobali ita tële ahwane, kë mësebë ato mago hehë tletëme. ");
INSERT INTO nce_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maria bu Jisasna kë asë mëtlabë onehome gali tujuwelëme. Kë enëne bu maninibo mëtletla na ye mëtlekefëtla. ");
INSERT INTO nce_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Na Maria bume gali tlome, “Jisas mana tafa lële na bo wahwi nololë! Na kë enëne bubë gali aholokwane mëtla kwe melowene lamëtla, ‘Bu sogëna lale.’ ” ");
INSERT INTO nce_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Na tokwafe bubë lowene esogo mëglelëtlabë ho tlemalë, lifate kile mëtelo na alëge alëgewa mëtëyeu. Na Jisas kë tlemalëme li weniyanena esune tlëme. ");
INSERT INTO nce_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Na bu kë gali, bubë lowene esogo mëglelëtlabë ho flime, gali mutujuwelëmo. Bu kë gali aholokwane mëtla kwe bubë lowenena hana sle mëtlamu, sogëna tokwë mëgelo. ");
INSERT INTO nce_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Na tokwafe bubë lowene esogo mëglelëtlabë ho we ita jowa këniji hi mëtla na Jisas bume mana fata tletëme. Na bume wame galina gali tlome, “Sobo lowene sle jwa fëyeme elone? Na sobo bome, matëmatë mago huju tëgelëna kë hwi motlonabë onehome fëyeme boblo totomone na bubë gali aholokwane toglomo jwa fëyemene?” ");
INSERT INTO nce_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Na bume ita gali tlome, “Sobo iniwa lifate Gotobë lale gali, asë elelëtelo. Na Gotobë lale gali iniwa onehome të etagutemome. ");
INSERT INTO nce_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Oneho bu Gotobë lale gali lowene sle mëgletlana, na wafi baptais mëglana, kwe Goto bume lëgaitameme na nëno lëgleme, buna unaunalëme tafa nalëglelëmeme. Kwe oneho bu Gotobë lale gali lowene sle hana mëgletlana, Goto bume hehë lëgletëmeme na tëbo miglitayame. ");
INSERT INTO nce_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Bome kë lowene sle mëgletënabë oneho, bu Gotobë afutuku fenene, wesibi melë mogotomame. Bu bobë weniji fë mogotlana, na ahwane hehë mëgletëmame. Na bu lili anigawa galina gëgali mëglame. ");
INSERT INTO nce_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Na bu wametabo taiju tobana atineha fa mogotlana, bume hana tëbo logotomeme. Na bu motaba foha wesibi atineha hi mëglana, bu tëbo hana miglitayame na bu gigli hana mëglame. Na bu tëbo atona home, toba gwa motatëmana, na bu ato titika mlame.” ");
INSERT INTO nce_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tako Ho Jisas, bume gali watë tëtatëme na Goto bume heven life elë tilekole. Na bu Gotobë tobamu toba elë tafa tletle, Gotona onehome eso home tafa namëgletemome. ");
INSERT INTO nce_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Na bubë lowene esogo mëglelëtlabë ho mutuja na lale gali të mëtëtagula, li life, li life memëtla. Tako Ho Jisas, bume lataitame, na bubë afutuku lafijiwa tlëme. Na bu, Gotobë afutuku fenene, wesibi melë lamototoma. Na oneho këme hwi mëtla na lowene mëtla, “Bu kë të mëtatënabë gali nëgalimufe.” ");
INSERT INTO nce_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","O letitabo ho, Tiofilus. Ëbame feilawa ho bu, Jisas wesibi sebobë li mëta, melë kë totometënabë yahi mëtla. Kwe bu iniwa gali yahi hana mëtla. ");
INSERT INTO nce_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Fli enëne, bu iniwa wesibi Jisas kë totomebë bubë nabana hwi motloma. Na bu kë gali boname na fli enënename të mëtëtatëna. Na kë enëne bu kë aholokwane motlolabë gali yahi mëtla. ");
INSERT INTO nce_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Këme nëgeme, bo metole nanelë, bo mata kë lale gali yahi nelëme na jume nelëbakëme. Bo iniwa wesibi, Jisas melë kë totomebë, onehome itaita takune latlokwefëmë. Na bo kë wesibibëme walowene sle nëletemë. Na bo ëje kë wesibi, yahi sle nelë. ");
INSERT INTO nce_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ju bobë yahi hwi sle eglomena, na melowene sle naegletëmeme, “Kë gali bu jume ëbame kë okokwe mëtëglëyobë, nëgali gali mu.” ");
INSERT INTO nce_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herot bu Judia provins mago eso home tafa tëglena, na lotu lome wege lëglebë ho li këme tëtabe. Bubë weniji Sekaraia. Bu Abiyabë ilawa mago ho. Abiyabë ilawa mago ho, bu lotu lome wege mëtlekefëya. Bu na bubë mëse mata, lotu lome wege lëglebë letitabo ho Aronbë bosemle. Bubë nobë weniji Elisabet. ");
INSERT INTO nce_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nona, bohena, Gotobë naba lime lale tafamu lamëtelo. Na bu Gotobë galiwa lowene sle mëtletelo. Na bu këme fëye wesibiha hana mëtelo. ");
INSERT INTO nce_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kwe bu nëba jwa mëtëtabo. Elisabet layame tlibeme nëgeme. Na bohe hoti tle na no mëseti tle. ");
INSERT INTO nce_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Li olëna, Sekaraiabë ilawa mago enëne, Gotobë tako lotu lo mëta, Gotobë wege fa mëtëtatla. Na Sekaraia mata, Gotobë wege fa tëtatle. ");
INSERT INTO nce_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ëtani home fene aniji motlokwefëma, kë fenene Sekaraiame aniji motlola, lale lëkaluna wesibi Gotome ahojume nalëgletleme, Goto bubë lale ahëya lëkalu hëhë nalëgleme. Bu Sekaraiame melëna aniji motlola bu satu salë mëtla na Sekaraiabë weniji fata tletle. Na bu Gotobë tako lotu lowa tëkaklu, lale lëkaluna wesibi Gotome ahojume nalëgeluletleme. ");
INSERT INTO nce_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Na Sekaraia lale lëkaluna wesibi Gotome kë ahojume tletlebë olëna, feilawa oneho Gotobë tako lotu lo li mëta loko mëtlelëya na Gotome mana gëgali motlokwefla. ");
INSERT INTO nce_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sekaraia lale lëkaluna wesibi Gotome mana ahojume lëgletlebë, na kwe Gotobë ensel bume mana olafa tletle na lale lëkaluna wesibi këme ahojumebë masei li mëta, tobamu elëme tlibetle. ");
INSERT INTO nce_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekaraia, enselme hwi tlole na klikina metletlemu na ulina metletle. ");
INSERT INTO nce_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Na këme ensel bume gali tlole, “Sekaraia, ju uli asa ele. Goto jubë mëse nëba egeholebë gali waaholokwane tolë. Këme nëgeme jubë mëse Elisabet nëba fu egotleme. Na ju bubë weniji mefë saetle, ‘Jon.’ ");
INSERT INTO nce_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kë nëba fu egotlena, jubë lowene lalowamu nalëbetëme na fleflesuna etabeme. Feilawa oneho mata fleflesuna mëtabëyame. ");
INSERT INTO nce_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tokwafe Goto bume mehwi nalogloleme nëgeme, lale homu. Bu wain taba liji tu na bia tu na hana hi lëglememu. Bu botabë imo mëta manane na Gotobë Amtëtomba bu mëta mana lelutabetleme. ");
INSERT INTO nce_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Na bu, Israelbë afenëbome lowene hihijika mëglabëme laitameme na ita bubë Gotome esogo melelëlame. ");
INSERT INTO nce_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Gotobë lowene mago gali të totokweflebë ëtanifu ho, Elaija fenene, bu këha lakalena kalëlegona tafa nalëgleme. Na Tako Home leoutatleme. Bu bolijaya name, nëbale name melë logotomeme, yonane lowene mëta fwa tafa mlame. Na bu Gotobë gali kë momata mëgëtatlabë enëneme sle lotomeme na bu metafa namëglame, lale lowenena enënebë lowene fene lëbetëme. Na bu onehome sagli lëlelëmeme na Gotobë kalëlegona ho ligisibë olëme mana hwi namëgletlame.” ");
INSERT INTO nce_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Na Sekaraia enselme gali tlole, “Bo habëna lowene nëgletelëmene, kë gali nëgali gali mu? Ju hwi ele! Bo wahoti nelë na bobë mëse mata wamëseti ebefe.” ");
INSERT INTO nce_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Na ensel Sekaraiame gali metafu tëtatle, “Bo Gebriel. Bo Gotobë li mëta kë niglibekefëbë ho. Goto bu jine lelëfakënë, jume gali nanoglëme na ebë lale gali të nanëtatëme. ");
INSERT INTO nce_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Te! Ju aholokwane ele. Ju bobë gali lowene sle jwa egletleme nëgeme, elë ju gali mumu egëbeme. Ju gali mumu tabo tafa eglebëë, na jubë mëse nëba mana fu totleme. Bobë gali olafa lëglebë olë, Goto waaniji lolole.” ");
INSERT INTO nce_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Oneho Sekaraiame yafe hwi mëtletla na metutune lamëtletla, “Bu lotu lo mëta tako tafa fëyeme lelulene, wesibi liha fata leluletlene?” ");
INSERT INTO nce_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tokwafe tekaklina, gëgali lëgleme fene kwe bu hana gëgali tle. Bu tobanawa lëlekuju tëbebokwaketëme. Bu gali wamumu tëbe. Oneho bume yafe hwi motlola na melowene lamëtletla, “Gotobë tako lotu lo mëta, Gotobë klelegowa wesibi hwi lelujelëlefe.” ");
INSERT INTO nce_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tokwafe, Sekaraia, Gotobë tako lotu lo mëta kë wege tëglebë wege yawe tlole na bubë lifatewa mana tuju. ");
INSERT INTO nce_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Na tokwafe bubë mëse Elisabet nëba imona tëtabe. Na bubë lo mëta fwa tobali yeme tafa tle. Na bu megali tle, ");
INSERT INTO nce_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Goto maninibo tletenë. Bome kë fata lëgletenëbë wesibi, ebë Gotobë wesibi. Bo onehobë naba lime, layame kë tiglibebë tiniji, Goto wasle totle.” ");
INSERT INTO nce_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet bu nëba imona tobali ita jowa yeme tafa tle na Goto, bubë ensel Gebrielme, Galili provinsbë tokwëfo lifate Nasaretwa mana jine tlële. ");
INSERT INTO nce_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Na bu layo mëse belë tujutë, bubë weniji Maria. Kë mëseme, eso ho Devitbë afenëbo mago ho, Josep sei lëglebëme wafi aniji motlëya. ");
INSERT INTO nce_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Na Gebriel gali tolë, “Bo nisiyo. Goto juna etabo na jume lataita na tako tole latletë.” ");
INSERT INTO nce_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria kë gali aholokwane tlole na klelego metletle na tutune tle na melowene tle, “Kë habëtabo galine?” ");
INSERT INTO nce_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Na ensel gali tolë, “Maria, ju uli asa ele. Goto jume fleflesumu lalëletë. ");
INSERT INTO nce_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Aholokwane ele. Ju nëba egeholeme. Na ju iko nëba fu egotleme. Na ju bubë weniji mefë egotleme, ‘Jisas.’ ");
INSERT INTO nce_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Na bu flesu hoha lëgëtabeme. Na bu mefë namogotlame, ‘Tako kalëlegona Gotobë nëba mu.’ Na Goto bume eso home aniji logloleme, bosemle Devit fene tafa tle. ");
INSERT INTO nce_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Na bu Jekopbë ilawa mago enënebë eso home unaunalëme lëtabetëme nalëgleme. Na bu eso home iniwa olë metafa lokoukëfeme.” ");
INSERT INTO nce_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Na Maria enselme gali tlole, “Euowe. Bo nëba habëna nëgeholëmene? Bo ho sei hana nëlëlëfe.” ");
INSERT INTO nce_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Na ensel bubë gali metafu tëtatë, “Gotobë Amtëtomba jume ligisi tëme na kalëlegona Gotobë afutuku jume lamu lëgëtame. Këme nëgeme, kë nëba ju tokwafe fu egotlena bu Gotobë lale homu lëgëtabeme. Na bu mefë namogotlame, ‘Gotobë nëba.’ ");
INSERT INTO nce_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ju aholo bo eta! Binabi Elisabet bu mësetimu kwe bu mata nëba ehole. Oneho megali kë mëtlekefëtëyabë, ‘Bu layame eliboo,’ kwe aona yeme neme na bu nëba mana tafa egleme. ");
INSERT INTO nce_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Goto bu Elisabetme nëba melë lëlë na jume mata nëba lëglëme. Gotome li wesibiha hana lëkle logotleme, bu lalowa iniwa wesibi melë logotomeme.” ");
INSERT INTO nce_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Na Maria bume gali tlole, “Aholokwane ele. Bo Gotome wege nëgletelëbë mëse. Bu bome melë malëtanë, ju fene gali ele.” Na kwe ensel bume kile tëta. ");
INSERT INTO nce_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kë nalëwa, Maria bu hokweinawa fatini mëta kë tëgëbebë lifatewa tokwale, Judia provins mëta, Elisabetme hwi naegwelëme. ");
INSERT INTO nce_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Na bu Sekaraiabë lowa tëkaklu na Elisabetme gali tole, “Bo nisiyo.” ");
INSERT INTO nce_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet kë gali aholokwane tolë na nëba imo mago klikinamu metletë. Na Gotobë Amtëtomba Elisabet belë tisi të na buna mëtëtabo. ");
INSERT INTO nce_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Na bu Mariame anisasana gali tolë, “Goto jume fleflesumu lalëletë na jume tako lëgaitamë lalële kwe fli oneme, melëgaitame hana lële. Na kë nëba jubë imo mëta kë nëgebë, Goto bume mata tako lëgaitale lëglememu. ");
INSERT INTO nce_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Bo lale mëse nane na bobë Tako Hobë bota, bo belë kë egisibë. ");
INSERT INTO nce_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Aholokwane ele! Bo jubë gali meaholokwane noglëna, ‘Bo nisiyo,’ kwe bobë nëba fleflesu lalelule na klikinamu meleluletenë. ");
INSERT INTO nce_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ju Gotome melowene sle tletle, ‘Goto kë wesibi jume kë gali toglëbë, melë lëgleme, këme nëgeme ju fleflesu këme egleme.’ ” ");
INSERT INTO nce_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria gali tle, “Bobë lowene mago lowenena Gotome fleflesu nëlekefëtelë, na bibita notokweflë, ‘Goto bu lale mu.’ ");
INSERT INTO nce_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Na bo Gotome fleflesu nëletelë. Bu bome lëgaitanë ho, bo tafa sle këme nelë, bu melë lëgëtanëme nëgeme. ");
INSERT INTO nce_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Bo bubë wege mëse, bo lale mëse nane. Kwe bu bome hwi tlonë na maninibo tletenë. Elina, unina mata, iniwa oneho megali mokoukefëtëname, ‘Goto bume tako fleflesu latletë.’ ");
INSERT INTO nce_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Na Tako Afutukuna Goto, bome lale wesibimume laitanë. Ebë kë nëgebë Goto, tëbo lowene hanane, lale lowene nawa lëtabe. ");
INSERT INTO nce_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Bubë gali momata jwa kë mogotlabë onehome, Goto bume maninibo lëglekefëtëmeme. Bu itaita melë lotokefëmeme, ebë olëna kë tafa mëglabë onehome na tokwafe fu onehome mata itaita melë lotokwefëmeme. ");
INSERT INTO nce_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Goto bubë afutukuna melë totome. Oneho bu melowene mëtlana, ‘Sebo kwe lale enënefe. Fli enëne bu seboha nane. Weye.’ Na bume fwa fleflesu mëtletëma na bibita mototoma, bu këha enëneme hehë tletëme, na bu mitliwaya. ");
INSERT INTO nce_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Bu kalëlegona eso home boblo totome, kwe atwati home taitame. ");
INSERT INTO nce_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Bu foneme gigli mëtlabë onehome, lale wesibi tlëme na bubë imo sosolo memëtëtaya. Kwe feilawa wesibina onehome hehë tletëme na bu alujawa mitliwaya. ");
INSERT INTO nce_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Bu bubë wege enëne, Israelbë ilawa mago enëneme taitame. Na bu Abraham name, sebobë semlenino name, gali kë sle tëtatëmebë gali aholokwana hana ti tle. Bu bume megali sle tle, bume na bubë tokwafe fu afenëbome itaita memaninibo lëkoukefëtëmeme.” ");
INSERT INTO nce_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria bu Elisabetna aona yeme mëtëtabo na bubë lifatewa tuju. ");
INSERT INTO nce_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabetbë nëba fu olë fata tletë, na bu iko nëba mana fu totle. ");
INSERT INTO nce_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bubë life mago oneho na weife mago enëne, Goto bume kë maninibo tëgletëbë gali aholokwane mëtla na buna iniwa fleflesu mëtlelëya. ");
INSERT INTO nce_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nëba tobali ita aona olë këniji tëtabe, na bu loko mëtlelëya, kë nëbabë ato jibo tlë namëtatlame. Na bu metole lamëtla, bolijaya Sekaraiabë wenijina lëtabeme. ");
INSERT INTO nce_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kwe bota gali tlome, “Matëbe. Bubë weniji Jon.” ");
INSERT INTO nce_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Na bume gali motlëya, “Ju kë weniji fëyeme fë etlene? Jubë afenëbo mago hobë weniji li këha hana lëbe.” ");
INSERT INTO nce_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Na bu kë nëbabë bolijayame tobana lëlekuju mëtletla, “Weniji habelë fë egotlemene?” ");
INSERT INTO nce_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Na bu yahi laba mëglëlabëme, tobanawa lëlekuju tletëme. Na bu mëtlëla na bu kë laba mëta meyahi latle, “Bubë weniji Jon.” Na bu kë weniji hwi motlola na klelego memëtla. ");
INSERT INTO nce_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Na Goto Sekaraiabë gali laslewa tëtatle na bu ita mana gali tle na Gotome fleflesu latletle na bibita totle. ");
INSERT INTO nce_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Na bubë life mago oneho kë wesibi hwi motlola na klelego memëtletla. Na kë gali, Judia provinsbë fatini mëta kë tëgëbagubë lifatewa fifiji mëtlagula. ");
INSERT INTO nce_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Na bu kë gali aholokwane motokouja na tako tutune memotokouja na takune mëtla, “Tokwafe kë nëba habëtabo hoha lëgëtabemene?” Bu melowene mëtlame nëgeme, “Gotobë kalëlego bu mëta lëtabetle.” ");
INSERT INTO nce_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Gotobë Amtëtomba, kë nëbabë bolijaya, Sekaraia belë tisi tle na buna mëtëtabo. Na bu Gotobë lowene mago gali metë totle, ");
INSERT INTO nce_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Sebo Israelbë Gotome fleflesu manëletla na bibita manotla. Bu seme, bubë onehome, lëgaitana nalëgleme tisi tëna, na seme nëno nalëgleme tisi tëna. ");
INSERT INTO nce_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Goto, bubë wege ho Devitbë afenëbo mago, kalëlegona ho seme jine tlëtëna, seme lëgaitana nalëgleme, na nëno nalëgleme. ");
INSERT INTO nce_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ëtani anebomu, Goto bu kë galime gali sle latlona. Na bubë lowene mago gali të mototokweflabë ho, bu kë gali sle toglomebë gali të mototla. ");
INSERT INTO nce_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Bu wagali sle tle, seme lëgaitana nalëgleme. Na seme kë wame moglonabë enëne magome na gëglë kë moglonabë enëne magome nëno lëgleme, bu seme tëbo hana mëgëtaname. ");
INSERT INTO nce_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Bu ëbaime sebobë semleninome megali sle latlome, ‘Bo some maninibo nëgletëyome na nëgaitome.’ Na bume kë gali sle toglomebë gali, mana lowene tlekefëtëme, aholokwana hana ti tle. ");
INSERT INTO nce_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Bu sebobë semle Abrahamme gali wasle tëtatle. Na ebë olë, Goto bu metole lalëletëna, kë wesibi seme mefata lëgletëname, bu ëtani fene gali sle tle. ");
INSERT INTO nce_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Bu metole lalële, bu seme kë wame moglonabë enënebë magome nëno lëgleme. Na sebo Gotome esogo sle nanëglelëlame na wame home uli jwa nanëletëmame. ");
INSERT INTO nce_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Këme nëgeme, sebo ebë life mëta mana nëtabëyame, sebo bubë li mëta lale lowene mëta natafa nëglame. Na sebobë lowene mëta bubë lale lowenewamu lëbetëname. ");
INSERT INTO nce_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Na ju, bobë nëba, tokwafe jume mefë mëgëtome, ‘Tako kalëlegona Gotobë lowene mago gali të totokweflebë ho.’ Ju Gotobë kalëlegona hobëme eoutatleme na bubë alëge fu naegetatleme. ");
INSERT INTO nce_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","78","Ju Gotobë onehome okokwe na bu melowene namëglame, ‘Goto bume tako maninibo lalëletëme, na bubë tëbo lowene sle nalëtatëmeme na bume laitameme.’ Na bu heven life mago elulego seme lëglëname. ");
INSERT INTO nce_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Na oneho bu tëbo lowene mëta kë tafa mëglabë, kë elulego bume lale lowene olafa lëtatëmeme. Bu lale tafa lowene seme olafa lëtatëname na sebobë lowene lalowa nalëbetëname.” ");
INSERT INTO nce_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tokwafe, Jon, sigli lëleme na bubë lowene lalemu lëbetleme. Bu ho jwa tabo elë lutabeme. Bu lutabebë na mana Israelbë afenëbobë naba li mëta, bubë wege mana fa lotleme. ");
INSERT INTO nce_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Elisabet bu Jonme wafu totle, na kë nalëwa, Rom lifate mago eso ho Ogastus, bu kë tafa lëglelëmebë onehome tabëi mëglabëme wasle totle. ");
INSERT INTO nce_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Gavman ëbame onehome hana tabëi tle. Ebënawa tabëi lëgleme. Na kë nalëwa, Kwirinius bu Siria provins magobë eso ho tëtabetëme. ");
INSERT INTO nce_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Këme nëgeme iniwa oneho bubë lifekuwa këme mitliwaya, Gavman bubë weniji gogwa nalëgletëmeme. ");
INSERT INTO nce_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Na Josep Mariana Galili provinsbë tokwëfo lifeku Nasaret kile mëtelo na Judia provinsbë tokwëfo lifeku Betlehemwa mitimo, bubë bosemlebë life nëgeme. Josepbë bosemlebë weniji Devit, Israelbë ëtanifu eso ho. ");
INSERT INTO nce_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Na bume sei lëglëbëme, kë aniji mototlabë Mariana mitimo, weniji bubëna iniwa sle namogotometëmame. Na kwe Maria nëba imona. ");
INSERT INTO nce_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Betlehem lifewa fwa mutulo. Na kë lifeku mago ni lobë ke mëtlame nëgeme na bulmakaubë ni lo mëta këme ni mëtebo. Na bu kë lo mëta mana mëtëtabo na Maria amlebo mana fale tëta. Na bu abwa nëba mana fu totle. Na ëhona lei totle na bulmakaubë hi wesibi iseku mëta tuku tle. ");
INSERT INTO nce_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na kwe Betlehem life li mëta, sipsip kleli mëtlëmabë ho mana tafa mëtla. Na bu klabëna bubë sipsip kleli këme mëtlëkefëma. ");
INSERT INTO nce_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mëtlëmabëë, na Gotobë ensel fata tletëme na Gotobë elulego klijiha sisigli tëtagule na bume hwagënë totome. Na bu tako ulimu memëtla. ");
INSERT INTO nce_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kwe Gotobë ensel gali tlome, “Sobo uli asa elo. Aholokwane elo! Bo some lale galimu nehitëyo. Iniwa oneho bu ebë lale gali aholokwane mëglana, kwe bu tako fleflesu mëglame. ");
INSERT INTO nce_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ebë gali melë lëgëbelalële, ebë olëna, Devitbë lifeku mëta, mëse li nëba fu etle. Kë nëba bu some lëgaito nalëgleme, tëbo lowene mago nëno nalëgleme. Bu tako ho, na Goto bume wafi aniji tlole, onehome lëgaitame nalëgleme, tëbo lowene mago nëno nalëgleme. ");
INSERT INTO nce_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Sobo mehwi eglolome. Ëhona leitabo nëba bulmakaubë hi wesibi iseku mëta ni lëbe.” ");
INSERT INTO nce_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ensel wagali tlome na feilawa ensel lafatawa mëtletëme. Na bu Gotome fleflesu mëtletla na bibita mototla, na Gotobë sawa mefë lamëtëtatla, ");
INSERT INTO nce_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Goto bu heven life mëta kë tafa lëglebë bu lale na tako mu. Oneho Goto kë fleflesu lëgletëmebë, bubë lowene lëgëbetëme sle malëletëme.” ");
INSERT INTO nce_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Na kwe ensel bume hune mototoma na heven lifewa motokwala. Na sipsip kleli kë mëtlëmabë ho mana gali mëtla, “Te, mana manuja, Betlehem lifekuwa. Goto seme kë gali toglonabë wesibi hwi nanugujelëlame.” ");
INSERT INTO nce_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Na bu hokweinawa mutuja. Na bume hohwi mëtëtagutla. Na Josep na Maria name mana hwi motloma. Na bulmakaubë hi wesibi iseku mëta kë ni tëgëbebë nëbame mata hwi motlola. ");
INSERT INTO nce_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bu hwi motlola na bu ensel kë gali toglomebë gali të mëtëtatëma. ");
INSERT INTO nce_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Na iniwa oneho, bu sipsip kleli kë mëglëmabë hobë gali aholokwane motloma, na klelego memëtla. ");
INSERT INTO nce_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Kwe Maria kë wesibi aholokwana hana ti tle na itaita lowene tlekefëtle. ");
INSERT INTO nce_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Na sipsip kleli kë mëtlëmabë ho, kë aholokwane mëtlabë gali na kë hwi motlomabë wesibime Gotome fleflesu motokoutla. Iniwa wesibi melë mëtleme nëgeme, Gotobë ensel fene gali tlome. ");
INSERT INTO nce_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tobali ita aona olë tëtabe na bubë ato jibo mana tlë mëtëtatla, na bubë weniji mana fë mototla, “Jisas.” Maria kë nëba tehole jwa nëgena kwe Gotobë ensel këbë wenijibëme mana gali tolë. ");
INSERT INTO nce_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Na kë olë fotokoke tëme, Josep Mariame Jerusalem lifatewa tleouli, toba mago sasu ko, Gotobë naba li mëta sle naegotomeme, Mosesbë gali fene tëbetle. Mëse bu nëba tafa eglena, toba sasu kowa egehona, kwe Gotobë naba li mëta tëbo lalëta. Na kwe bu nëba Jerusalem lifatewa mëtlelulo, Gotome mëglëlo namëgelome. ");
INSERT INTO nce_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tlemalë bu metole lamëtelo, Gotobë gali kë lëgëbebë, kë galiwa esogo mëtlelëtelo. Kë gali melë lëgëbelalële, “Sobo abwa mago iko nëba kë nëgebë, Gotome eglëlome.” ");
INSERT INTO nce_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Na Gotobë tafa sle gali mata melë lëgëbetlelalële, “Sobo tële seuneni o tële yolime nëbale, Gotome egehotelome, Gotobë naba li mëta, toba mago sasu ko këna sle naegotomeme.” Na bu fole këme mëtehoujo, lotu lome wege lëglebë ho, kë fole Gotome ahojume nalëgletleme. ");
INSERT INTO nce_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na kë nalë, ho li Jerusalem lifate mëta tëtabe. Bubë weniji Simeon. Kë ho kë nëgebë bu lale lowenewa esogo tlelële na bu Gotome fwa lowene slemu tletle. Na Gotobë Amtëtomba bu mëta telutabetle. Simeon bu Goto kë jine lëglelebë hobëme hwi tletle. Israelbë ilawa mago onehome lëgaitame nalëgleme. ");
INSERT INTO nce_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Gotobë Amtëtomba bume megali sle latlole, “Ju ilawa hana gli egleme. Ëtani Goto bu megali slemu latle, ‘Bo ho jine nëglëlëme, onehome tëbo lowene mago nëno lëgleme.’ Ju kë home afina hwi eloleme na ju mana gli elëme.” ");
INSERT INTO nce_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na kwe Gotobë Amtëtomba Simeonme tisi tle na bu Gotobë tako lotu lowa këme tëkaklu. Na Jisasbë botana bolijaya name, Jisasme Gotobë lowa mëtlelulo, kë nëbame melë namogotlame, Gotobë gali fene lëbetle. ");
INSERT INTO nce_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Na Simeon kë nëbame hwi tlole na fa totle. Na bu Gotome fleflesu tletle na bibita totle na megali tle, ");
INSERT INTO nce_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Tako ho, jubë gali sle gali watëbetë, na bo, jubë wege ho, bo maninibona wasle nelë, bo mana lalowa gli nelë. ");
INSERT INTO nce_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Seme nëno lëglebë home, ju kë jine tëglëlebë ho, bo nabana wahwi nololë. ");
INSERT INTO nce_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ju kë home, iniwa onehome ekë lebotane etatëme. ");
INSERT INTO nce_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Na kliji elulegoha, bu Gotobë lowene, Israelbë afenëboni mëtabëya jwa mëglabë enëneme olafa lëgëtatëmeme. Na bu Israelbë afenëbome, lëgaitame nalëgleme jubë lowene esogo mëglelëlabë. Kë oneho ebë jubë.” ");
INSERT INTO nce_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jisasbë botana, bolijayana, Simeon nëbame kë gali toglolebë gali aholokwane mëtelo na klelego memëtletelo. ");
INSERT INTO nce_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Na Simeon Gotome gëgali tlelële, bume lëgaitame nalëgleme. Na bu kë nëbabë bota, Mariame, gali tolë, “Aholokwane ele! Goto ebë nëbame meaniji latlole, Israelbë lebutako afenëbome melë logotomeme. Lebutako oneho bume kë lowene sle mëgletlabë lowene, kile mlame na lebutako oneho bume kë lowene mëgletlabë lowene esogo sle melelëlame. Ebë nëba kë nëgebëye, Gotobë lale lowene, onehome lebotane lëtatëmebë ho. Kwe feilawa oneho bume tëbo gali moglolame, ");
INSERT INTO nce_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","na bubë lowene mago tëbo lowenebë olafa lëgletëmeme. Na tokwafe ju tako hobota egleme, sëfa yo sle eglëbë fenene.” ");
INSERT INTO nce_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Na Gotobë lowene mago gali të egotlebë mëse li kë mëta tafa tle. Bubë weniji Ana. Bu Aserbë afenëbo magobë mëse, Fenuelbë nëba. Ëtani bu ho sei tlële na bu kë hona tobali ita tële tlibutu këniji tafa mëtelo ");
INSERT INTO nce_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","na bohe mana gli tletë. Na bu seiju tëtabe. Na ëje bu 84 tlibutu këniji etabe. Bu Gotobë tako lotu lo kile hana tletle. Bu hi wesibi itaita yo tlekëfe, Gotome lowene sle naegletleme. Na bu Gotome mana gëgali tlelëkefle. Klijina, klabëna Gotome fwa lowene tlekefëtle. ");
INSERT INTO nce_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na kë nalë, Ana bu nëba loliwa tisi tle na Gotome mana gali tlole, “Ebë nëba, yaha fëyeme enënane.” Na feilawa oneho bu mehwi kë mëtlekefëyabë, Goto bu Jerusalem lifate mago onehome nëno lëgleme. Na bu kë nëbabë gali kë onehome të tëtatëme. ");
INSERT INTO nce_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Bu iniwa wesibi, Gotobë gali fene tëbe, melë wamototoma. Na kwe bu Galili provinsbë tokwëfo lifeku Nasaret lifekuwa ita mutuja. Ebë bubë life. ");
INSERT INTO nce_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Na kë nëba sigli lëleme na lolokwëne lëgleme. Na lale lowene bubë lowene mëta lëbetleme na Goto bume tako tole lëletleme na bume laitaleme. ");
INSERT INTO nce_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Iniwa tlibutuna, Jisas bolijayana, botana, Jerusalem lifatewa itaita lamëtëyeoukefo, Gotobë tako lotu olë lowene mëtletelome nëgeme. Israelbë ilawa mago oneho, bu kë tako lotu olë, Goto ëtani bosemlenime kë tëgaitamebë olë na Isip lifate këna kile mëtëglabë olë, lowene mëtlekefëtla. ");
INSERT INTO nce_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisas bu we ita tële tlibutu këniji watle. Na kwe bu Jerusalem lifatewa ita mutuja bu ëbame fene mutujukefëya, Gotobë tako lotu olë lowene mëgletlame nëgeme. ");
INSERT INTO nce_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kë tako lotu olë yawe motlola, na kwe bu Jerusalem lifate kile mëtla na bubë lifekuwa mutuja. Kwe falake tokwëfo Jisas, Jerusalem lifate mëta mana tafa tle. Botana bolijayana melowene hana mëtletelo, “Jisas mana tafa lële.” ");
INSERT INTO nce_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Weye, bu meweniji lamëtelo, fli enënena mana asë melawa. Këme nëgeme olë jowa buwa mëtëyeu. Tokwafe, bubë ilawa mago onehome na bubë yabe home, tëtakune mëtlagumo. ");
INSERT INTO nce_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Bu yafe tëtakune mëtlagumo, kwe hana hwi motlolo. Këme nëgeme bu lu mëtelo na Jerusalem lifatewa ita mëtëyeu, hohwi namogutatelome. ");
INSERT INTO nce_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Bume aona olë yafe hohwi mëtëtatelo. Na tokwafe bume tako lotu lo mëta hwi motlolo. Bu Gotobë gali okokwe moglomabë hobë ku mëta tafa tletëme. Na bubë gali mana aholokwane tlagukefëme na bume tëtakune tlokefëme. ");
INSERT INTO nce_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Iniwa oneho, bubë lowene yafe hwi motlotla na bubë tafu gali yafe aholokwane motlotla, klelegomu memëtletla. ");
INSERT INTO nce_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Botana bolijayana hwi motlolo, na klelego memëtletelo. Na bota bume gali tlole, “O hëyai, ju seme melë fëyeme etanone? Sebo blijayana jume yafe hohwi nëtatëyo na maninibona tëbo menëletëyo.” ");
INSERT INTO nce_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kwe bubë gali tafu tëtatëme, “Sobo bome fëyeme hohwi etatenone? Sobo bome melowene hana eletënane, ‘Bo bobë ayabë lo mëta tafa manelë?’ ” ");
INSERT INTO nce_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kwe bubë gali lowene hana mëtletelo bu yaya lamëtletelo. ");
INSERT INTO nce_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Na kwe buna Nasaret lifewa ita mutuja. Na bubë lowenewa esogo esogo tlelëkefëtëme. Kwe Maria bowene meta kë hwi toglometlebë wesibi, bubë lowene mëta mana tehotle. ");
INSERT INTO nce_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Na Jisas sigli tle na bubë lowene lalemu lëbetleme. Na Goto bume fleflesu lëletleme na iniwa oneho mata bume tole mëgletlame. ");
INSERT INTO nce_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Eso ho Taiberius, bu we ita tobali tlibutu këniji, Rom life enënebë tako eso home tafa tletëme. Kë nalëwa, Pontius Pailat Judia provins enënebë eso home tafa tletëme. Na Herot Galili provins enënebë eso home tafa tletëme. Na bolijamo Filip bu Ituria na Trakonitis provins enënebë eso home tafa tletëme. Na Lisanias, bu Abilene provins enënebë eso home tafa tletëme. ");
INSERT INTO nce_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Na Anas na Kaiafas bu lotu lo mëta wege mëglabë enënebë eso ho mëtëtabo. Kë nalëwa, Sekaraia bowene Jon, ho jwa tabo mëta tafa tle na Gotobë gali bubë lowene mëta mana fata tletle. ");
INSERT INTO nce_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Këme nëgeme, Jon bu Jordan tu lime kë tafa mëtlabë lifekuwa tuju na gali metë tëtagutëme, “Sobo tëbo lowene aholokwana ti elome na lale lowenewa esogo elelëlome na baptais elome. Na Goto bu sobobë tëbo lowene aholokwana ti lëgletëyome na hana lëgeholeme.” ");
INSERT INTO nce_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kë wesibi mefata latle, Gotobë lowene mago gali të totokweflebë ho, Aisaia, fene yahi tle. Bu meyahi latle, “Tokwafe, li ho, ho jwa tabo mëta mewe lëgleme, ‘Sobo tako hobë alëge fu etatelo, alëge sle etometelo. ");
INSERT INTO nce_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Bu iniwa klukulego tabobë na iniwa fofo tabobë sle motomame. Na iniwa alëge, ekekë mëglebë sasle mëtaguma. Na iniwa alëge tëbo mëglebë, sasle motoma. ");
INSERT INTO nce_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na iniwa oneho, Goto onehome kë nëno lëglebë wege hwi moglotlame.’ ” ");
INSERT INTO nce_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Feilawa oneho Jon belë mitisitla, bume baptais nalogotomeme. Kwe Jon bume gali tlome, “Sobo tëbo taijuha. Sobo tëbo enëne. Goto tako wame loglëyome na tëbo lëgëtome. Sobo melowene lalone hee! Bo some baptais nëgëtona kwe Gotobë wame some hana tëbo lëgëtomene? Weyewa. ");
INSERT INTO nce_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Sobo tëbo lowene aholokwana ti egelona na Gotobë lale lowenewa esogo eglelëlona, ta kë lowene saolafa etlo, bu melowene namëgletëyome, ‘Bubë tëbo lowene aholokwana wati mëlafe na Gotobë lale lowenewa esogo melelëlafe.’ Na sobolalo megëgali asa elo, ‘Sebo Abrahambë afenëbo, këme nëgeme Goto bu seme hana tëbo lëgëtaname.’ Weye. Bo some gali nolëyo, Abrahambë afenëbo ebë tokwëfo wesibi. Goto ebë anijime, Abrahambë afenëbome lalewa fata lotomeme. ");
INSERT INTO nce_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Gotobë wame bu onehome fata lëgletëmeme nounou lalëletëmemu, yasi ti wayome wafi lëbe. Na iniwa ti, lale liji mogwalë hana mëglena, kwe Goto kë ti tëtëka lëgleme na ahojume sike lëleme.” ");
INSERT INTO nce_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Oneho bu Jonbë gali aholokwane motlola, na bume metakune motlola, “Sebo habelë nëglamene na Goto seme tëbo jwa nalëgëtaname?” ");
INSERT INTO nce_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Na bume megali tlome, “Fli enëne bu gelowa ëho tële tële nëgena, bu fli alujawa kë nëgebë enëneme sa mëlëma. Na fli enëne hi wesibina nëgena, bu hi wesibi jwa kë nëgebë enëneme sa mëlëma.” ");
INSERT INTO nce_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takis baliti glo mëglabë ho fli, bu belë mitisiya, bume mata baptais nalogotomeme. Na bu takune motlola, “Tisa, sebo habelë nëglamene?” ");
INSERT INTO nce_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Na bume megali tlome, “Sobo takis baliti meglo egletemome, gavman fene gali tlëyo. Sobo fli baliti manawa asa glo eletemo.” ");
INSERT INTO nce_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Na wame home boblo mogotomabë enëne fli, bu mata takune motlola, “Na sebowa, sebo habelë nëglamene?” Na bume gali metafu tëtatëme, “Sobo fli enëneme gëglë asa elelëmo na bubë baliti toklime glo elome. Na sobo fli onehome gavmanbë naba lime blawa asa so etatemo na bubë baliti blawa glo eletemome. Na gavman some wege baliti kë lëglëyobë, këme fwa fleflesu egelome. Fli baliti glome asa tole elo.” ");
INSERT INTO nce_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Na oneho Jonme hwi motlola, na bubë lowene fotokoke tëme na bubë lowene nawa melowene mëtla, “Jon bu kë ho nawa, seme na nëno lëglebë ho nawa. Goto kë aniji toglolebë ho nawa.” ");
INSERT INTO nce_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Këme nëgeme Jon bubë gali metafu tëtatëme, “Bo some tu mëta fwa baptais nëlelëyo. Kwe tokwafe bobë nagi ho li ligisime. Na kë ho kë ligisibë bubë afutuku takomu kwe bobë afutuku tokwëfomu. Bo lale ho nane kë ligisi home kë nëgaitalëme, manawa wege ho fene laitale. Weye. Bo bubë jiteho hana titika nëgletelëme. Bu letitabo homu nëgeme na bo atwati homu. Bu some Gotobë Amtëtombana, ahojuna baptais lëglelëyome. ");
INSERT INTO nce_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Na kë ho kë ligisibë bu tëbo lowenenabë enëneme na lale lowenenabë enëneme lëselokwame, nuju bolijaya hwetikina witi liji mago fene lëselokwa. Na bu lale lowene enëneme heven life elë sei lëlëmeme, nuju bolijaya bu witi liji, lale lo mëta fene gogwa lële. Kwe bu tëbo lowene enëne lële jwa ahoju life elëme sike lëgleme, nuju bolijaya witi liji mago hwetiki ahojume fene sike lële.” ");
INSERT INTO nce_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon bu feilawa gali të tëtatëme, onehobë lowene huju tëtatëme, lowene sle namëglame. Na kë esome fwa, Gotobë lale gali këme të tëtatëme. ");
INSERT INTO nce_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Herot, Galili provinsbë eso ho, bu bolijamobë mëseme, Herodiasme, hijika totle na sei tlë. Na Jon bume këme wame gali tlole. Na iniwa fli tëbo lowene Herot bu kë tëglebëmeha bume wame gali tlokwefle. ");
INSERT INTO nce_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Na Herot bu li tëbo lowene tle. Bu melëme, Jonme kalabusu lowa tuku tle. ");
INSERT INTO nce_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kë nalëwa, Jon kalabusu lome tafa jwa tëglena. Bu iniwa onehome wabaptais totome, na bu Jisasme mana baptais totle na Jisas Gotome mana gëgali tlole. Bu Gotome mana gëgali tlelëlebëë, na heven inoha latikawa tle. ");
INSERT INTO nce_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Na Gotobë Amtëtomba seuneni foleha ji tëtëkeketle. Na bu matafa mëta gali tle, “Ju bobë lale nëba. Bo jume tako tole nanëletë, tako fleflesu nanëletë.” ");
INSERT INTO nce_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisas bubë aowafewe tlibutu mutuju tle na bubë wege mana fa totle. Na kwe oneho bume meweniji lamëtletla, Josepbë bowenefe. ");
INSERT INTO nce_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Josep Helibë bowene. Na Heli Matatbë bowene. Na Matat Livaibë bowene. Na Livai Melkibë bowene. Na Melki Janaibë bowene. Na Janai Josepbë bowene. ");
INSERT INTO nce_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Na Josep Matatiasbë bowene. Na Matatias Amosbë bowene. Na Amos Nahumbë bowene. Na Nahum Eslibë bowene. Na Esli Nagaibë bowene. ");
INSERT INTO nce_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Na Nagai Matbë bowene. Na Mat Matatiasbë bowene. Na Matatias Semenbë bowene. Na Semen Josekbë bowene. Na Josek Jodabë bowene. ");
INSERT INTO nce_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Na Joda Joananbë bowene. Na Joanan Resabë bowene. Na Resa Serubabelbë bowene. Na Serubabel Sealtielbë bowene. Na Sealtiel Neribë bowene. ");
INSERT INTO nce_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Na Neri Melkibë bowene. Na Melki Adibë bowene. Na Adi Kosambë bowene. Na Kosam Elmadambë bowene. Na Elmadam Erbë bowene. ");
INSERT INTO nce_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Na Er Josuabë bowene. Na Josua Elieserbë bowene. Na Elieser Jorimbë bowene. Na Jorim Matatbë bowene. Na Matat Livaibë bowene. ");
INSERT INTO nce_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Na Livai Simeonbë bowene. Na Simeon Judabë bowene. Na Juda Josepbë bowene. Na Josep Jonambë bowene. Na Jonam Eliakimbë bowene. ");
INSERT INTO nce_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Na Eliakim Meleabë bowene. Na Melea Menabë bowene. Na Mena Matatabë bowene. Na Matata Natanbë bowene. Na Natan Devitbë bowene. ");
INSERT INTO nce_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Na Devit Jesibë bowene. Na Jesi Obetbë bowene. Na Obet Boasbë bowene. Na Boas Salmonbë bowene. Na Salmon Nasonbë bowene. ");
INSERT INTO nce_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Na Nason Aminadapbë bowene. Na Aminadap Atminbë bowene. Na Atmin Arnibë bowene. Na Arni Hesronbë bowene. Na Hesron Peresbë bowene. Na Peres Judabë bowene. ");
INSERT INTO nce_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Na Juda Jekopbë bowene. Na Jekop Aisakbë bowene. Na Aisak Abrahambë bowene. Na Abraham Terabë bowene. Na Tera Nahorbë bowene. ");
INSERT INTO nce_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Na Nahor Serukbë bowene. Na Seruk Reubë bowene. Na Reu Pelekbë bowene. Na Pelek Eberbë bowene. Na Eber Selabë bowene. ");
INSERT INTO nce_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Na Sela Kainanbë bowene. Na Kainan Arpaksatbë bowene. Na Arpaksat Siembë bowene. Na Siem Noabë bowene. Na Noa Lamekbë bowene. ");
INSERT INTO nce_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Na Lamek Metuselabë bowene. Na Metusela Enokbë bowene. Na Enok Jaretbë bowene. Na Jaret Mahalalelbë bowene. Na Mahalalel Kenanbë bowene. ");
INSERT INTO nce_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Na Kenan Enosbë bowene. Na Enos Setbë bowene. Na Set Adambë bowene. Na Adam Gotobë bowene. ");
INSERT INTO nce_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Gotobë Amtëtomba, Jisas mëta telutabetle na bu Jordan tu mago ita tuju. Na Gotobë Amtëtomba bume ho jwa tabo elë tlelule. ");
INSERT INTO nce_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Na Satan bume niliafewe olë tëbo loweneme fene susu totokwefle. Na kë nalë, Jisas hi hana tle na bu foneme gli tle. ");
INSERT INTO nce_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Satan bume gali tlole, “Ju Gotobë nëba nëgebë kwe, ju ebë anijime gali eolëme na bu bletë nageme fata naeglamëme. Na ju hi elëme.” ");
INSERT INTO nce_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Kwe Jisas bume gali tafu tëtatle, “Gotobë bogo megali lala, ‘Hi wesibiwa, onehome, lale tafame hana lëgaitameme.’ ” ");
INSERT INTO nce_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Na kwe Satan bume kë mago mana tilekole. Na bume iniwa tatako lifate lalebotanewa totometle. ");
INSERT INTO nce_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Na gali tlole, “Bo jume tako afutukume nëgaitëme, kë iniwa lifatebë onehome eso ho tafa naegletëmeme na ju tako eso home tafa elëme. Na bo kë lifatebë iniwa lale wesibi jume yo noglëme. Kë iniwa lifate na wesibi ebë bobë, bu bome wayo tlonë. Na bo li home yo noglolëbëme tole nëgelëna, kwe bo lalowa yo noglolëme. ");
INSERT INTO nce_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ju bome sëkefo miti tafa eletenëna na bome megali eglonëna, ‘Ju bobë lale tako eso ho tafa eletenë, bo jume tako tole nanëletë,’ kwe bo kë iniwa lifate na iniwa wesibi jume yo noglëme.” ");
INSERT INTO nce_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kwe Jisas bume gali tafu tëtatle, “Gotobë bogo megali lala, ‘Goto buwa jubë eso home tafa lëletë. Ju bume fwa satole eletle na saesogo elelële.’ ” ");
INSERT INTO nce_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Na Satan Jisasme Jerusalem lifatewa tlelule na tako lotu lo leli elë tilekole. Na bume gali tlole, “Ju Gotobë nëba nëgebë kwe, ju lalowa emagowa okli etëkake na ju tëbo hana eglitame. Hanane mu. ");
INSERT INTO nce_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Gotobë bogo megali eglamëme nëgeme, ‘Goto, bubë enselme jine lëglëmetëme, na bu jume ululu mëgëtome.’ ");
INSERT INTO nce_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Na bu mata megali lala, ‘Bu jume fa mëgëmalitome bubë tobana, na jume aniji yo hana sle eglëme.’ ” ");
INSERT INTO nce_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Na Jisas bubë gali tafu tëtatle, “Gotobë bogo megali lala, ‘Jubë tako Gotobë afutuku asa su etatle.’ ” ");
INSERT INTO nce_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satan bu Jisasme memelë wesibina wasusu tëbetëfale, na bume kile totle, li olë nalë ita su nalogotleme. ");
INSERT INTO nce_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jisas bu, Gotobë Amtëtombabë afutukuna, Galili provinswa ita tuju. Na Jisas kë tafa tëglebë gali, Galili provinsbë li life li life mago onehome fifiji mëtlagutëma. ");
INSERT INTO nce_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Na bu li life li lifebë lotu lo mëta, Gotobë gali onehome okokwe tlagukefëme. Na iniwa oneho bume fleflesu mëtletla na bibita mototla. ");
INSERT INTO nce_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jisas bu Nasaret lifewa tuju. Ëtani bu kë lifeme sigli tle. Na bubë tafawa olëna, bu lotu lowa tëkaklu, bu ëbame fene tlekëfe. Na bu hujuna tlibe, Gotobë gali hwi naloglotëmeme. ");
INSERT INTO nce_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Na bogo kë ululu sle logotokwefëmebë ho, Gotobë lowene mago gali të totokweflebë, Aisaiabë bogo, bume tlële. Na bu bogo ya tëtamë. Na këme kë galibë hwi tlome, kë gali melë lëgëbelalële, ");
INSERT INTO nce_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Gotobë Amtëtomba bo mëta tëtabe. Këme nëgeme, Goto bu bome waaniji tlonë, bubë lale gali, wesibi jwa onehome të nanëgëtatemëme. Na bu bome këme jine tlënë, kalabusu mëta kë tafa mëglabë onehome megali nanoglomëme, ‘Sobo kalabusu lo lalowa kile elo.’ Na naba titiki tabo onehome megali nanoglomëme, ‘Sobo lalowa hwi elo.’ Na bu bome këme jine tlënë, gëglë kë mëglelëmabë onehome nanëgaitamëme na bubë afowelili sle nanogotometemëme. ");
INSERT INTO nce_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Na bu bome jine tlënë, onehome megali nanoglomëme, ‘Goto, bubë onehome kë lëgaitamebë olë, ekë folokoketle.’ ” ");
INSERT INTO nce_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Na Jisas bogo geni tëta, na bogo kë ululu sle logotokefëmebë home tlële na mana tafa tle. Na iniwa oneho, lotu lo mëta kë tafa mëtelulabë, Jisasme fwa wëya mëtlelëla. ");
INSERT INTO nce_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Na kwe bume gali tlome, “Ebë gali, sobo Gotobë bogo mago kë aholokwane egelobë, bu ëje iniyafememu ekë fata lële.” ");
INSERT INTO nce_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Lale gali të totleme nëgeme na bume këme fleflesu mëtletla na bibita mototla. Na bume kë të tëtatëmebë gali mana lowene mëtletla. Kwe, bu megali mëtla, “Bu ebë galime, kë gali loglonabë, habelëme gali lëlene? Bu seme kë gali loglonabëye, kwe Josepbë nëba tekwe nëge.” ");
INSERT INTO nce_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Na Jisas bume gali tlome, “Bo walowene sle nëletëyo. Tokwafe sobo kë ëtanifu anebo gali bome të egëtatëname, ‘Dokta, jubë ato elili sle egotleme, na ilawa mago hobë ato elili mata sle etome tëmeme.’ Na sobo mata gali egloname, ‘Ju Kaperneam lifeku mëta wesibi melë kë totomebë sebo waaholokwane tletëyo. Na sebo metole nanëla, ju ebë lifekume mata, kë wesibi melë egotomeme.’ ");
INSERT INTO nce_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Bo some iniyafeme gali nolëyo, bubë life mago oneho, Gotobë lowene mago gali të mototokweflabë hobë gali aholokwaneme, tole hana mëtla. ");
INSERT INTO nce_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Bo some iniyafeme gali nolëyo, Gotobë lowene mago gali të totokweflebë ho, Elaija mana tëtabena, na seiju one feilawa, Israel provins mëta tafa mëtëkouja. Na kë nalë wanagli tako temotëme na aona tlibutu na tobali ita jowa yeme tu hana teto. Na tako fone iniwa lifateme fata tokoutëme. ");
INSERT INTO nce_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kwe Goto bu Elaijame Israelbë ilawa mago seiju mëse belë hana jine tletëme. Weye. Bu li ilawa mago seiju mëse belë fwa jine tlëtë, bume lëgaitame nalëgleme. Kë mëse bu Saidon provinsbë tokwëfo lifeku Sarefat mago mëse na bu Israelbë ilawa mago nane. ");
INSERT INTO nce_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Na kë mata, Gotobë lowene mago gali të totokweflebë ho, Elisa mana tëtabena, na feilawa ato juba jubawa kë mëtëgeholabë oneho, Israel lifate mëta mëtëtabëya. Kwe, Elisa kë mago juba jubawa onehome li hana sle totle. Weye. Bu Siria life mago ho, Namanme fwa sle totle. Naman bu Israelbë afenëbo nane, li afenëbo mago ho.” ");
INSERT INTO nce_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Na oneho, lotu lo mëta kë tafa mëtelulabë, bu kë gali aholokwane mëtla na melowene mëtla, “Bu seme, Israelbë afenëbome, gali lëlefe” na tako enisusu memëtletla. ");
INSERT INTO nce_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Na fe mëtëkaka na Jisasme fa mototla, na bume lifeku tiniju elëme so mëtlagula, fatini mleibu elëme so namëtelëkaklame fene. Bubë lifeku fatini mëta tobetëme. ");
INSERT INTO nce_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kwe bu kukuwa lateiwa tëtagwi na latugujuwa. ");
INSERT INTO nce_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Na kwe Jisas Galili provinsbë tokwëfo life, Kaperneamwa tëmatule. Na bubë tafawa olëna, onehome Gotobë gali të tëtatëme. ");
INSERT INTO nce_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Bubë gali aholokwane motlola, na klelego memëtla. Bubë gali flesu hobë galiha nëgeme, kalëlegona tlëme. ");
INSERT INTO nce_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na kë nalë, li ho lotu lo mëta tafa tle na ahwane bubë ato mëta telutabetle. Na bu feilawa aflei tle, ");
INSERT INTO nce_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Nasaret life mago Jisas, ju seme habelë egëtaname esine? Ju seme tëbo naegëtaname esine? Bo jume wafi lowene nëletë, ju kë ho kë nëgebë, Goto jume kë jine tëglëbë homu. Ju Gotobë lale homu.” ");
INSERT INTO nce_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Kwe, Jisas kë ahwaneme anisasana gali tlole, “Ju kuju ebe na ebë home kile etoleme.” Na ahwane kë home life elëme so telëkakle na masana ku mëta titigo. Na kë ahwane, bume li atoha hana tëbo tëtatle na bume kile togotlena. ");
INSERT INTO nce_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Na iniwa oneho klelego memëtla na blalo gëgali mëtla, “Euowe! Ebë fëye galine? Bubë gali flesu hobë gali fene, kalëlegona tlëme. Bu ahwaneme anisasana gali tlome na bu home lakilewa mototome.” ");
INSERT INTO nce_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Na iniwa wesibi, Jisas melë kë totomebë, kë galibë, Galili provinsbë li life li life mago onehome fifiji mëtlelëtëma. ");
INSERT INTO nce_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisas lotu lo kile tle, na Saimonbë lowa tëkaklu. Saimonbë bokokabë ato, tako ahojute latletë. Na bu Jisasme takune motlola, sle nalëgëtame. ");
INSERT INTO nce_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Na kwe, Jisas bu loliwa tujutë, na kë ahojuteme anisasana gali tlole, bume kile nalëgëtamëme. Na ahojute bume lakilewa tëta na bu lahujuwa tëkake na hi wesibi ahojume tletëme. ");
INSERT INTO nce_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Atome hwi olë, oneho bubë yabenime, ato elili kë mëtlabë, Jisas belë mëtlesuma. Na bubë toba iniwa ato elili enëneme gogwa tokoutëme na bu iniwa sle tëtagume. ");
INSERT INTO nce_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Na bu ahwane hehë tletëme. Na bu feilawa onehome hune mëtëtagume na meafëflei lamëtle, “Ju Gotobë nëbafe.” Kwe Jisas bume anisasana gali tlome, na gëgalime lëkle totome. Kë ahwane bu melowene mëtleme nëgeme, “Bu Goto kë aniji toglolebë ho, onehome nëno nalëgleme.” ");
INSERT INTO nce_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Olobalë mu, Jisas kë life kile tle na ho jwa tabo elë tuju. Na oneho bume hohwi mëtëtatla na bume mana hwi motlola. Na bume yafe lëkle mototla, bume kile jwa nalogotomeme. ");
INSERT INTO nce_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kwe bume gali tlome, “Goto onehobë eso home kë tafa lëgletëmebë lale gali, fli lifateme mata të nëtagutemëme. Goto bome këme jine tlënë.” ");
INSERT INTO nce_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Na bu Judia provinsbë, li life li life measë tëbelëfa na lotu lo mëta gali të tëtagutëme. ");
INSERT INTO nce_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Li olëna, Jisas, Genesaret lake tu helefome tlibe, na feilawa oneho mitisiya na bume lolime loko mëtlelëtla, Gotobë gali aholokwane namëglame. ");
INSERT INTO nce_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Na Jisas bu lake tu helefo mëta, tële ihe, hwi tlome. Kë ihe, mo fafa enënebë ihe. Kwe ihe bolijaya enëne bu ihe wahune mëtla na solo swa mototoma. ");
INSERT INTO nce_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Na Jisas bu Saimonbë ihe mëta fe tle. Na bu Saimonme gali tlole, “Ju iheme fe elëme na so elëkakëme, helefo tokwëfo kilewa naegotleme.” Na Jisas iheme tafa tle, na mana onehome gali të tëtatëme. ");
INSERT INTO nce_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Bu gali watë tëtatëme, na Saimonme mana gali tlole, “Te, ku tako elë yegu ekake na sobo solo sike etëkakome, mo fafa naegelome.” ");
INSERT INTO nce_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Na Saimon gali tlole, “O tako ho, ëje klabë yafe sike sike nëla na olë feti na loko menëlebla, kwe sebo mo liha hana buhe notla. Kwe lalowa, jubë gali esogo nëgletëyome na solo sike nëglame.” ");
INSERT INTO nce_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Na bu melëmëtla, na mo feilawa tëkeji bubuhe mëtla, na solo ëjeha holëye mëleme. ");
INSERT INTO nce_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Këme nëgeme bubë weife wege ho flime, li ihe mëta kë tafa mëgelobëme, we motlomo, bume mëgaitamo namëgelome. Na bu mitisi temo, na mo, kë tële ihe mëta sisike mëtla. Na ihe mo hobota manogwa, ëjeha flu mëleme. ");
INSERT INTO nce_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Na Saimon Pita këme hwi tlole. Na Jisasbë elebo lime sëkefo bubusu totometle na gali tlole, “O, tako ho, ju bome kile etanë. Bo tëbo homu.” ");
INSERT INTO nce_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Saimon na kë tafa mëtlabë ho, kë feilawa mo hwi motloma na klelegomu memëtletëma. ");
INSERT INTO nce_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Na Saimonbë yabe, Jems na Jon, Sebedibë nëbale, bu mata klelego memëtelo. Kwe Jisas Saimonme gali tlole, “Ju tutune asa ele. Ëje ju mo fafa ele, kwe tokwafe ju onehome bo belë eglesumetenëme, bome esogo namëglenëname.” ");
INSERT INTO nce_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Na kwe bu yegu motokouja na yenëba mëta fla mëtla na ihe yenëbawa kiki motokwaka na bubë iniwa wesibi këme hune mëtla na Jisasme nagi mëtlëla. ");
INSERT INTO nce_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Li olëna, Jisas li lifate mëta tafa tle. Na ato juba jubawa kë tëgeholebë ho kë mëta tafa tle. Bu Jisasme hwi tlole, na bu belë tisi tle na sëkefo miti bubusu totometle na gali tlole, “Tako ho, ju tole eglena, ju bobë ato lalowa sle etatenëmene na bo Gotobë naba lime lalowa nanëtabëme.” ");
INSERT INTO nce_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Na Jisas toba gwa totatle na gali tlole, “Bo tole nanelë, ju lalowa etabeme.” Na kë juba juba lalujuwa mëtletle. Na bu lalowamu tëtabe. ");
INSERT INTO nce_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Na Jisas bume anisasanamu gali tlole, “Jubë ato lalowa kë lëgëbetëbë, ho lime asa gëgali elelële. Matëbe. Ju ejume na jubë ato, lotu lome wege lëglebë home lebotane eoutatleme. Na ju bume wesibi ejuwelëleme, Moses fene gali tle. Na bu kë wesibi Gotome lëlëleme. Na iniwa oneho melowene namëgletëyome, ‘Jubë ato lalowa lëbetë.’ ” ");
INSERT INTO nce_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Na iniwa wesibi, Jisas melë kë totomebë, kë gali, li life li life feilawa fifiji mëtlagutla. Këme nëgeme, lebutako onehomu mitisitla, bubë gali aholokwane namoglolame na bubë tëbo sle nalogotometëmeme. ");
INSERT INTO nce_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kwe bu lebutako olë, onehome hune tlekëfe na ho jwa tabo elë, Gotome gëgalime, tuju kefë tle. Na Jisas bubë lowene wahwi tlotëme na kë ato mogowa home gali tlole, “O nëba iko. Bo jubë tëbo aholokwana wafi ti nëletë.” ");
INSERT INTO nce_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Li olëna, Jisas onehome gali mana okokwe tlome. Na Farisi ho na Gotobë galime okokwe moglomabë hona kë mëta tafa mëtla. Bu Galili provins mago, na Judia provins mago, na Jerusalem lifate mago, na li life li life mago mitisiya. Na Gotobë afutuku Jisas mëta mana tëbe, na bu onehome këbë afutukuna sle totome. ");
INSERT INTO nce_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Na fli ho, ato mogo tabo home sanënena mëtlesula. Na bume lowa mëglelukakulame yafene, Jisasbë elebo lime gwa namugujetlame fene. ");
INSERT INTO nce_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kwe lebutako oneho lo mëta tafa mëtlame nëgeme, na lo wake tle, na bu loliwa hana mëtehila. Këme nëgeme, bu lo leli elë mëtehilikola, na anabali tatë mototaya, na ni labuku mëta kë ni tëgëbebë ato mogo tabo home onehobë ku mëta alabujuwa gwa mëtëmalitala, Jisasbë li mëta. ");
INSERT INTO nce_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kë enëne melowene mëtla, “Jisas ebë ato mogowa home lalowa sle logotlemefe.” Na Jisas bubë lowene wahwi tlotëme na kë ato mogowa home gali tlole, “O yabe. Bo jubë tëbo lowene aholokwana wafi ti nëletë.” ");
INSERT INTO nce_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Na Gotobë galime okokwe moglomabë ho fli, na Farisi ho fli bubë gali aholokwane motlola na blalo gëgali mëtla, “Ëëë! Bu habëtabo hone, Gotoha kë fata lëglebëye? Bu këha gali fëyeme gali lëlene? Bu tëbo homu. Bu Gotome fëyeme boblo lotlene? Ho kwe hobë tëbo lowene aholokwana hana ti lëgletleme. Hanane mu. Goto bu kwe fëyemene, tëbo lowene aholokwana lalewa ti lëgleme.” ");
INSERT INTO nce_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Na Jisas bubë lowene walowene tletëme. Na bume takune tlome, “Sobo këha lowenena fëyeme lowene elone? ");
INSERT INTO nce_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Bo bume megali noglolëna, ‘Bo jubë tëbo aholokwana wati nëletë,’ sobo habë lowene lalone, bo bubë tëbo lowene aholokwana wati nëletelë? Sobo kë wesibi hwi hana elolo. Kwe bo bume megali noglolëna, ‘Ju huju ele, na jubë lowa ejume.’ Na bu huju lëleme, kwe sobo melowene egelome, ‘Bo Gotobë kalëlegona ho, na bo tëbo atona ho lalowa sle nogotlëme. Na bo mata hobë tëbo lowene aholokwana lalowa ti nëgletemëme.’ ");
INSERT INTO nce_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kwe bo metole nanelë, sobo melowene egelome, ‘Bo, Gotobë life mago ho, bo ebë life mëta, kalëlegona homu nëtabë. Na bo tëbo lowene aholokwana lalowa ti nëgelëme.’ ” Na Jisas ato mogo tabo home hwi tlole na gali tlole, “Bo jume gali nolë, ju huju eleme, na jubë ni labuku glo eleme na jubë lowa ejume.” ");
INSERT INTO nce_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Na kë ho, kë ni tëgëbebë, onehobë naba li mëta lahujuwa tle, na këme ni tëgëbebë ni labuku glo tle, na Gotome fleflesu tletle na bibita totle na bubë lowa tuju. ");
INSERT INTO nce_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Na iniwa oneho bu klelego memëtla, na Gotome fleflesu mëtletla na bibita mototla. Na megali mëtla, “Ëje sebo lale klelegowa wesibi fli hwi noloma.” ");
INSERT INTO nce_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tokwafe, Jisas tuju, na takis baliti kë glo lëglekefëtëmebë home hwi tlole. Bu takis lo mëta tafa telule. Bubë weniji Livai. Na Jisas bume gali tlole, “Ju bome nagi enënë.” ");
INSERT INTO nce_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Na Livai huju tle, na iniwa wesibi hune tle, na Jisasme nagi telëkakle. ");
INSERT INTO nce_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Na kwe Livai Jisasme lebutako hi wesibimu bubë lo mëta ahojume tletle. Na lebutako takis baliti kë glo mëglekefëyabë ho na fli ho mata, buna tafa mëtla na hi mëtla. ");
INSERT INTO nce_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Na Gotobë galime okokwe moglomabë ho, na fli Farisi ho, Jisasbë lowene esogo mëglelëtlabë home momata mëtlelëma na megali motloma, “Sobo, takis baliti kë glo mëglekefëyabë ho na fli tëbo lowene kë esogo mëglelëlabë enënename fëyeme hihi elelëkefëmone? Bu tëbo enëne mu.” ");
INSERT INTO nce_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Na Jisas bubë gali tafu tëtatëme, “Dokta bu tëbo jwa mëglabë home hana sle logotomeme, hanane mu. Ho tëbo mëglabë kwe fëyemene, dokta bume fwa sle logotomeme. ");
INSERT INTO nce_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Na bo kë fenene. Oneho bu meweniji lamëtla, ‘Sebo, Gotobë naba li mëta, lale enënefe,’ bo këha onehobë lowene sleme nane tisi. Weye. Kwe oneho bu melë lowenena kë tafa mëglabë, ‘Sebo Gotobë naba li mëta tëbo enënefe,’ kwe bo këha onehobë tëbo lowene sleme tisi, bubë tëbo lowene aholokwana ti namëglame na Gotobë lale lowenewa esogo namëglelëlame.” ");
INSERT INTO nce_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Na fli ho Jisasme gali motlola, “Lebutako olë, Jonbë lowene esogo mëglelëtlabë ho bu hi wesibi yo yo mëtlekefëya, Gotome lowene sle namëgletlame na Gotome gëgali mëtlelëkefla. Na Farisibë lowene esogo mëtlelëtëmabë ho, bu mata melamëtla. Kwe jubë lowene esogo mëglelëtëyobë howe, bu kë lale lowene esogo hana mëlelëla, bu hihi melekefëya.” ");
INSERT INTO nce_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Na Jisas waflë gali tlome, “Ho bu mëse sei lëglëna, na mëse sei lëglëbë hi wesibi salë fata logotlena, na kë ho buna mana tafa mëglana, kwe bu hi wesibi yo mëglamene? Weye. Hanane mu. ");
INSERT INTO nce_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kwe tokwafe, wame ho bu kë mëse sei home mëglelulana, na bu bubë yabe hona tafa jwa mëglana, kwe kë olëna bu hi wesibi mana yo mëglame.” ");
INSERT INTO nce_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jisas bume waflë galime gali tlome. Bu megali latlome, “Ho li tiho gelowa ëho hana ka logotleme, na kë tiho ëho katabo hëno gelowa ëho mëta hana susu logotleme. Weye. Bu melë lëglena, kwe bu tiho gelowa ëhome tëbo logotleme, na kë tiho ëho ka tabo na hëno gelowa ëhona weife weniyanena hana mëgebome. ");
INSERT INTO nce_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Na ho li bu tiho wain taba liji tu, ëtanifu mëmë kleli jibona kë blëge blëge mototlabë botolo mëta hana wë logotleme. Bu melë lëglena, na kë tiho wain taba liji tu sëse lëglena, kwe ëtanifu mëmë kleli jibo botolome bule logotleme na wain taba liji tu lifewa owë lëkakeme. ");
INSERT INTO nce_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Këme nëgeme, ho li bu tiho wain taba liji tu, tiho mëmë kleli jibo botolo mëta wë logotleme na bu hana bule lëgleme. ");
INSERT INTO nce_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Oneho bu hëno wain taba liji tu wahi mëglabë, kwe bu tiho wain taba liji tu tole hana mletëma. Bu megali lamla, ‘Hëno wain taba liji tu ebë lalowa mu.’ ” ");
INSERT INTO nce_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jisas tafawa olëna, witi liji nuju kukuwa bule mëtëtagujaya. Na bubë lowene esogo mëglelëtlabë ho, witi liji tëtlë mëtla, na sosa mototoma, jibo foke namëgletëmeme. Na mana afabo hi mëtla. ");
INSERT INTO nce_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Na Farisi ho fli, bume hwi motloma na këme takune mëtla, “Euowe! Ebë kwe sobo sogëna lalo. Ebë kwe tafawa olë fe. Sobo tafawa olëna, hi wesibi, fëyeme tëtlë elone? Fëyeme wege elone? Moses bu ëtani kë lowenebëme tako hehë latle.” ");
INSERT INTO nce_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Na Jisas bubë gali tafu tëtatëme, “Sobo, sebobë ëtanifu eso ho, Devitbë gali, Gotobë bogo mago, hwi sle hana elolone? Bo melëme gali nolëyo. Ëtani Devitna, kë tafa mëtëglabë ho, foneme gigli memëtla. ");
INSERT INTO nce_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Na Devit Gotobë lowa tëkaklu, na bu Gotobë naba li mëta kë gogwa mëtlabë bletë nage glo telule. Kë bletë nage, oneho hana hihi mëtla, lotu lome wege mëglabë ho, buwa hihi mëtla. Kwe Devit wali hi tle na bume kë tafa tëglelëmebë home wali sa tëtatëme na bu hi mëtla. Sobo kë gali hwi hana elolone? Ëëë?” ");
INSERT INTO nce_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Na Jisas bume ita gali tlome, “Kwe bo, Gotobë life mago ho, bo tafawa olëbë tako ho.” ");
INSERT INTO nce_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Li tafawa olëna, Jisas lotu lowa tëkaklu, na onehome gali të tëtatëme. Na tobamu toba mogo tabo ho këme tafa telule. ");
INSERT INTO nce_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Na Gotobë galime okokwe moglomabë ho, na Farisi ho, Jisasme mana hwiwa motlola. Bu melëme hwi motlola, bu tafawa olëna, onehome sle logotomemene o hanane? Bu melowene namëglame, “Jisas bu tafawa olëna onehome sle logotomena, kwe bume onehobë gali aholokwane moglomabë letitabo hobë naba li elëme mëglelula namëglame, bume tëbo namogotlame. Bu tafawa olëna wege lëgleme nëgeme.” ");
INSERT INTO nce_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kwe Jisas bubë lowene walowene tletëme. Këme nëgeme, kë toba mogo tabo home gali tlole, “Ju bo belë esime na emëta elikakime.” Na kë ho bu belë tuju tle na bubë lime tlibetle. ");
INSERT INTO nce_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Na Jisas bume takune tlome, “Sebobë semle Mosesbë gali habelë lëgëbetle lalëlene? Sebo tafawa olëna lale lowene lalowa esogo nëglelëlamene o tëbo lowene esogo nëglelëlame? Sebo onehome lalowa nëgaitamamene, bu lale tafa namëglame o tëbo nogotomame?” Kwe bubë gali tafu hana mëtëtatla. ");
INSERT INTO nce_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Na Jisas bume hwi tlagume, na kë home gali tlole, “Jubë toba elili etokwakle.” Na bu melë totle, na bubë toba lalowa tëbetle. ");
INSERT INTO nce_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kwe Gotobë galime okokwe moglomabë ho, na Farisi ho, bu tako enisusu memëtletla, na blalo gëgali mëtla, “Euowe, Sebo Jisasme habelë nogotlamene?” ");
INSERT INTO nce_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Na kë nalëwa, Jisas fatiniwa tokwale, Gotome gëgali nalëglelëleme. Na bu klabë tako, Gotome gëgali tëgëmaitalebëë na mana feti na loko metleble. ");
INSERT INTO nce_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kliji fe tole, na bubë lowene esogo mëglelëtlabë home gali telokwakëme, bu belë migisitla namëglame. Na bu belë mitisitla. Na bu we ita tële home aniji tlome, na Aposel wenijina fëfë totome. ");
INSERT INTO nce_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Bu Saimonme aniji tlole. Na Jisas bume li tiho weniji fë totle, “Pita.” Na bu Saimonbë bolijamo, Andrume mata aniji tlole. Na bu Jems, Jon, Filip, Bartolomyu, ");
INSERT INTO nce_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu, Tomas, Alfiusbë bowene Jems, Saimon name aniji tlome. Saimon bu Selot ho. ");
INSERT INTO nce_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Na bu Jemsbë bowene Judas name aniji tlome. Na Judas Iskariot name mata aniji tlome. Judas Iskariot bu Jisasme wamehome kë yo toglomebë ho. ");
INSERT INTO nce_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jisas, bu kë aniji toglomebë ho name, fatini mago kle mëtëmalitaya. Na buna fli lowene esogo mëglelëtlabë hona, lale tabo mëta tlebime. Na feilawa oneho, Judia provinsbë li life li life mago, na Jerusalem lifate mago, na Tair na Saidon nutu helefo li mago, bu mata kë mëta mëtëtabëya. ");
INSERT INTO nce_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bu këme loko mëtlelëtla, Jisasbë gali aholokwane namoglolame na bubë tëbo sle nalogotometëmeme. Na ahwane kë tëbo mototomebë onehome, sle totome. ");
INSERT INTO nce_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Na iniwa oneho bume yafe lu mototla. Tako afutuku bu mëta tëgëbetleme nëgeme, na kë afutuku bume laslewa totome. ");
INSERT INTO nce_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisas swaya tletëme na bubë lowene esogo mëglelëtlabë home hwi tlagume na këme gali tlome, “Sobo tëlewa wesibina enëne, kwe fleflesu egelome. Sobo Gotobë oneho etabetelo, na Goto bu some eso home tafa lëletëyo. ");
INSERT INTO nce_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Sobo fonoba kë tafa egelobë enëne, kwe fleflesu egelome. Tokwafe sobo hi wesibina memelë wesibina matahëna fe egelome. Sobo ye kë eglekefobë enëne, kwe fleflesu egelome. Tokwafe sobo soso egelome. ");
INSERT INTO nce_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Sobo bome, Gotobë life mago home, esogo eglenëname nëgeme, bu some tëboijiwa këme mëglëyome, na këme hehë mletëyome na këme klëi galina gali moglëyome na këme sobobë weniji sisile mogotometëyome. Oneho bu some këha melë mëgëtona, kwe sobo fleflesu egletemome. ");
INSERT INTO nce_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sobo fleflesu elome na tëtane ebome. Tokwafe, Goto some heven life mëta feilawa wesibi lëglëyome. Ëtani bubë bosemlenino, bu Gotobë lowene mago gali të mototokweflabë home mata melamototokwefëma. ");
INSERT INTO nce_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kwe sobo feilawa balitina enëne. Sobo hai! Sobo, sobobë lale wesibi wafi glo elo na sobobë lale tafa wafi fa etlo. Sobo tokwafe naba lalawa egotome. ");
INSERT INTO nce_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Sobo hi wesibi mëta kë egemulubë na imo feilawa kë tëtafu egotomobë enëne. Sobo hai! Kwe tokwafe sobo fone egelome na naba lalawa etome. Sobo sosonawa kë egëtabobë enëne. Sobo hai! Tokwafe sobo ye egelome. Na naba lalawa etome. ");
INSERT INTO nce_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Na iniwa oneho some fleflesu mëgletëyona na bibita mëgëtona. Sobo hai! Ëtani bubë bosemlenino bu Gotobë lowene mago gali të mototokwefëmabë sosogëna enëneme kë fene melë lamototoma.” ");
INSERT INTO nce_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jisas ita gali tlome, “Sobo bobë gali kë aholokwane egletënabë enëneme gali nolëyo, some kë wame moglëyobë enëneme tole sle egletemome. Na ho some gëglë mëglelëyona, sobo bume tole sle egletemome na maninibo egletemome. ");
INSERT INTO nce_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Fli ho some hana mëglëyona, sobo Gotome gali elëlome, bume lëgaitame nalëgleme na bume lale wesibi lëglëme nalëgleme. Some kë gëglë mëglelëyobë enëneme, Gotome gali elëlome, bume maninibo nalëgletëmeme. ");
INSERT INTO nce_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Na ho jume ahino elë bu lëglena, kwe bu malële, ju bume kofaya asa tëke elole. Weye. Ju jelë ahino elë obwelë etatleme, bu jubë jelë ahino elë mata bu nalëgleme. Na ho jubë gelowa ëho li fa logotlena kwe fa malotle, na kwe li gelowa ëho mata elëleme. ");
INSERT INTO nce_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ho fli jume wesibime takune mëglëyona, ju bume eglëmewa egleme. Na ho jubë wesibi fa logotlena, ita lëgleme asa takune elole. ");
INSERT INTO nce_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Iniwa wesibi sobo fenene tole eletemo, some melë lamëto, sobo kë wesibiwa bume melë egotomome. ");
INSERT INTO nce_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ho some kë tole mëgletëyobëme fwa tole egletemona, kwe ho sobobë lakaleme habëna lowene mëgletëyomene? Tëbo lakalena enëne mata bume kë tole mëgletëmabë enëneme, bu tole lamëletëma. ");
INSERT INTO nce_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ho some kë mëgaitobë, sobo bume fwa egaitamona, kwe ho sobobë lakaleme habë lowene mëgletëyomene? Tëbo lakalena enëne mata, bume kë mëgaitamabë enëneme memaitama. ");
INSERT INTO nce_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Sobo melowene egelona, ‘Bu sebobë baliti seme kofayame lalowa mëglënamefe.’ Na sobo bume fwa baliti esokwaneme eglëmona, kwe ho sobobë lakaleme habëna lowene mëgletëyomene? Tëbo lowene enëne bu fli tëbo lowene enëneme baliti esokwaneme memelë melëma. Bu melowene mëgletëmame nëgeme, ‘Kofaya seme mata mëglënamefe.’ ");
INSERT INTO nce_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kwe sobo, sobobë wame home tole eletemome na lale lowenenawa yonane elelëmome. Sobo bume baliti elëmome, na melowene asa elo, ‘Bu seme tokwafe ita mëglëname.’ Weye. Sobo melë lalowa, kwe tokwafe sobo lale wesibi fa egotlome, na sobo tako kalëlegona Gotobë nëbale egëtabome. Gotome fleflesu jwa mëglekefëtlabë enëneme, na tëbo enëneme mata, Goto bume lalowa lëgaitameme. ");
INSERT INTO nce_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Sobobë heven life mago blijaya, fli enëneme fene maninibo lëletëme, sobo mata melë maninibo egletemome.” ");
INSERT INTO nce_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Sobo fli enënebë lakale asa hwi eletemo na megali asa elomo, ‘Bu tëbo enëne.’ Sobo melë egelona, kwe kofaya Goto mata sobobë lakale hwi sle lëgletëyome, na megali lëlëyome, ‘Sobo tëbo enëne.’ Sobo fli hobë tëbo lakale aholokwana ti egletemome na lowene asa elekefëtemo. Na Goto sobobë tëbo lakale mata aholokwana ti lëgletëyome na hana lowene lëglekefëtëmeme. ");
INSERT INTO nce_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Sobo ho lime wesibi elëlome na Goto bu mata some kofayame wesibi lëlëyome. Bu some feilawa wesibimu lëglëyome. Bu wesibi ëfomemu kale lotomeme, owë mëkaketleme. Na some lëlëyome. Sobo wesibi home këniji elëmowe, kwe Goto mata some kënijiwa lëglëyome.” ");
INSERT INTO nce_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jisas bume waflë galime gali tlome, “Naba titiki tabo ho, li naba titiki tabo home alëge lalowa lebotane lëgëtagutlemene? Weye. Bu melë mëgelona kwe bu iniwa fulujuwa mitigwëyome. ");
INSERT INTO nce_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tisa kë okokwe loglolebë nëba bubë tisabë lowene hana sigli lëtatleme. Kwe tokwafe bu tisabë lowene, lowene sle lëletlena, kwe bubë tisabë lowene fene lëbetle, bu këha melë lëgleme. ");
INSERT INTO nce_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ju hwetiki tokwëfo, blijahabë naba mëta kë egëbatlebë, fëyeme hwi elotlene na kwe jubë naba mëta tako ti bule tabo tako kë lëgëbetëbë, lowene jwa fëyeme eletlene? ");
INSERT INTO nce_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ju tako ti bule tabo tako jubë naba mëta kë lëgëbetëbë hwi hana eglolena kwe ju li afame habë gali eglolemene, ‘O afa, bo jubë naba hwetiki tokwëfo, lalowa tufiji nëgëtatëmene?’ Weye. Ju sosogëna ho. Tako ti bule tabo, jubë naba mëta kë lëgëbetëbë afina tufiji etokwakleme. Na tokwafe ju hwi sle ekakeme na tokwëfo hwetiki, blijahabë naba mëta kë egëbatlebë, mana lalowa tufiji egëtatleme.” ");
INSERT INTO nce_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jisas ita waflë gali tle, “Lale ti, tëbo liji hana mogwalëme. Na kë fenene, tëbo ti mata, lale liji hana mogwalëme. ");
INSERT INTO nce_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ho bu ti liji afina hwi molola na weniji lowene mletla. Ho bu atowai liji, walëlëba ti mago hana tëtlë lëgleme na bu wain taba liji, ikiji taba mago hana tëtlë lëgleme. ");
INSERT INTO nce_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Lale ho bu feilawa lale lowene bubë lowene mëta lëbetle. Këme nëgeme bu lale lowenena këme tafa lële. Kwe tëbo ho bu feilawa tëbo lowene bubë lowene mëta lëbetle këme nëgeme bu tëbo lowenena këme tafa lële. Tëbo lowene bu mëta lëbetlena, kwe tëbo galime gali lële. Kwe lale lowene bu mëta lëbetlena, kwe lale galime gali lële.” ");
INSERT INTO nce_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Sobo bome mefë fëyeme etanane, ‘Sebobë tako ho,’ kwe bobë gali esogo jwa fëyeme elelëtënane? ");
INSERT INTO nce_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ho bu bo belë ligisina na bobë gali aholokwane lëglena na esogo lëglelëlena, bo këha hobë lowene some gali noglëyome. ");
INSERT INTO nce_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kë ho bu lale lo gliji lëglebë ho fenene. Bu life afina kakë yefi lële, na mësëbahiha ti këme lë lëtamë. Na lo kë matawa gliji lole. Na tokwafe haliji tu ligisina na kë lo yafe bëbë logotlena kwe bu hana fli logotleme, bu lale kalëlego lo gliji tëgleme nëgeme. ");
INSERT INTO nce_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kwe ho bobë gali aholokwane lëglena na esogo hana lëglelëlena, bu tëbo lo gliji lëglebë ho fenene. Bu life hana yefi lëgleme na kalëlego jwa ti lë sle hana lëgëtame. Tokwafe haliji tu ligisina na kë lo bëbë logotlena kwe bu lafliwa lotleme na tëbo lëleme.” ");
INSERT INTO nce_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas onehome gali watë tëtatëme na Kaperneam lifewa tuju. ");
INSERT INTO nce_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Na wame home boblo mogotomabë enënebë eso ho kë life mëta tëtabe na bubë wege ho jowa. Bu kë wege home tako tolemu latlekefëtle, kwe bu tako tëbomu latletle na ëjeha gli lëletleme. ");
INSERT INTO nce_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Na wame home boblo mogotomabë enënebë eso ho Jisas kë tafa tëglebë gali aholokwane tle, na kwe bu Israelbë afenëbonibë letitabo enëne fli, Jisas belë jine tlëme, bume takune namoglolame, bu ligisi nalëgleme na bubë wege home sle nalëgëtatleme. ");
INSERT INTO nce_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bu Jisas belë mutuju tla na bume anisasana gali motlola, “Kë wame home boblo mogotomabë enënebë eso ho, bu lale homu. Ju lalowa egaitalëmene? ");
INSERT INTO nce_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Bu seme, Israelbë afenëbonime, tole latletëna, na bu sebobë life mago lotu lo gliji tletëna.” ");
INSERT INTO nce_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Na kwe Jisas buna mutuja na loliwa fwa mutula na kë wame home boblo mogotomabë enënebë eso ho, bubë yabe home Jisas belë jine tlëme, bume megali namoglolame, “Tako ho, matëbe, menuju asa këkë ele. Bo lale ho nane, ju bobë lowa kë ekaklime. Weye. Bo tëbo ho. ");
INSERT INTO nce_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Na bo mata, bo lale ho nane, ju belë kë nigisime. Weye. Bo tëbo ho. Kwe, ju galiwa elëme, na bobë wege ho lalowa nalëgetabetenëme. ");
INSERT INTO nce_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Bo ebëha gali këme gali nelë. Fli eso ho bu bome tafa mlelëna na bo mata wame home boblo mogotomabë enëneme tafa nëlelëmë. Na bo ho lime megali noglolëna, ‘Ju eiju,’ kwe bu lalugujuwa. Na bo ho lime megali noglolëna, ‘Ju esi,’ kwe bu laligisiwa. Na bobë wege home megali noglolëna, ‘Te, ju wege ele,’ kwe bu lawegewa lële.” ");
INSERT INTO nce_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jisas kë hobë gali aholokwane tlotle, na klelego metletle, bume tako lowene sle lëgletleme nëgeme. Na bume kë esogo mëtlelëlabë onehome swaya tletëme na gali tlome, “Bo some gali nolëyo, bo Israelbë afenëbo ku mëta, këha lowene sle lëgletenëbë home hana hwi nololë. Kë wame home boblo mogotomabë enënebë eso ho bu bome tako lowene sle lëletënë kwe Israelbë afenëbo bu iniwa këha nane, bu bome tokwëfo lowene slewa lamletëna.” ");
INSERT INTO nce_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Na kë ho, kë jine tëglëmebë, bu kë eso hobë lowa ita mitisiya, na kë wege home yafe hwi motlola, kwe wasle tle. ");
INSERT INTO nce_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tokwafe, Jisas bu li lifekuwa tuju. Kë lifekubë weniji Nain. Na bubë lowene esogo mëglelëtlabë hona na fli feilawa onehona, bu nani iniwa mutuja. ");
INSERT INTO nce_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Na bu kë lifekubë lëglesi ino elëme loliwa fwa mëtëkakija, na bu u mogo kë mëtlelëkakilabë home esune mëtlëma. Na kë u mogobë bota, nëba jowa na bu seiju tafa ele. Na feilawa oneho kë lifeku mago, bu kë seiju mëseme nani mëtlesujaya. ");
INSERT INTO nce_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jisas kë mëseme yafe hwi tolë na tako maninibomu metletë na gali tolë, “Asa ye ele.” ");
INSERT INTO nce_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Na bu loliwa tuju tle na u mogo kë lëgëbebë sanëne lu totome. Na u mogo kë mëtehilabë ho mana këme fwa mitlija. Na Jisas gali tle, “Falake, bo jume gali nolë, ju mana huju ele.” ");
INSERT INTO nce_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Na gli këtëglebë falake, huju tle na tafa tle na mana gëgali tle. Na Jisas botame tlë. ");
INSERT INTO nce_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Na iniwa oneho klelego memotokouja na Gotome fleflesu mëtletla na bibita mototla na gali mëtla, “Goto bubë lowene mago gali kë të togotlebë ho tako kalëlegona ekë jine lëletëna. Goto bu wafi lisi tëna, bubë onehome lëgaitame nalëgleme.” ");
INSERT INTO nce_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Na Jisas kë nëba kë huju totlebë gali, Judia provinsbë li life li life fifiji mëtlagula na kakë elë mago life mata fifiji mëtlagutla. ");
INSERT INTO nce_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jonbë lowene esogo mëglelëtlabë ho, iniwa wesibi Jisas kë sle totomebë, Jonme gali motlola. ");
INSERT INTO nce_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Na Jon bubë lowene esogo mëtlelëtelobë home, gali telokwakëme, na bu mitisijo. Na bu kë tlemalë home Jisas belë jine telokwakëme, bume metakune namoglolome, “Goto jine gali kë lëglelebë ho, kë ho ju ekënene, o kwe sebo li home hwi nëgletlamene?” ");
INSERT INTO nce_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Na kë tlemalë ho, Jisas belë mitisijo. Na bume gali motlolo, “Tu mëta, kë baptais totokwefëmebë Jon, seme ju belëme jine lëlëbakëno, na bu jume metakune lalolë, ‘Goto jine gali kë lëglelebë ho, kë ho ju ekënene o kwe sebo li home hwi nëgletlamene?’ ” ");
INSERT INTO nce_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kë nalëwa, Jisas, bu lebutako onehobë memelë ato elili sle sle totometëme, na onehobë ato mago lebutako ahwane hehë tletëme. Na bu lebutako naba titiki tabo onehome sle totometëme. ");
INSERT INTO nce_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Na Jisas Jonbë lowene esogo mëtlelëtelobë hobë gali tafu tëtatëme, “Iniwa wesibi sobo kë hwi eglomobë na kë aholokwane egelobë sobo Jonme sagali ejuwelëlo. Naba titiki tabo oneho wahwi mla, na elebo tëbona oneho asë sle mla, na ato juba jubawa kë mëtëbetëmebë oneho, bu lale tafa mla, na aholo titiji tabo oneho bu waaholokwane mla, na gigli kë mëgebëyabë oneho wahuhuju mla, na bu Gotobë lale gali, wesibi jwa enëneme të mëtatëma. ");
INSERT INTO nce_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Oneho bome kë lowene sle mëgletënabë lowene kile jwa mëglana kwe bu fleflesu matla.” ");
INSERT INTO nce_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jonbë gali kë mëtehilobë ho wamëtëyeu, na Jisas Jonbë gali onehome megali tlome, “Sobo ëbame ho jwa tabo elë kë tëgëyeubë, sobo habëtabo home hwime tëyeune? Sobo li li lowenena home hwime tëyeune, flelu agosaba fene abeiabei lotome? Weyewa. ");
INSERT INTO nce_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Sobo fëye wesibi hwime tëyeune? Sobo, lale ëho kë gelo togotlebë home hwime tëyeune? Weyewa. Ho bu lale lale ëho ato mëta kë mëgëbetëmebë na lebutako lale wesibi kë mëgëbetëmebë, bu walujume nane tafa mla. Weyewa. Bu tako lifatebë eso hobë lo mëta tatafa mla. ");
INSERT INTO nce_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Sobo fëye wesibi hwime tëyeune? Gotobë lowene mago gali të totokweflebë home hwime tëyeune? Kwe nëgali fe? Na bo some gali nolëyo, kë Gotobë lowene mago gali kë të togotlebë ho bu lalowa mu, kwe fli Gotobë lowene mago gali kë të mogotlabë ho bu sogë lalowaha. ");
INSERT INTO nce_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Gotobë bogo, Jonme, megali lalatle, ‘Aholokwane elo, kwe tokwafe bo ho lime jine nëglëlëme, bobë gali të nalëtaguleme. Na bu jume loutatëme. Na bu alëge jume fu nalëgëtagutëme.’ ");
INSERT INTO nce_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Bo some gali nolëyo, Iniwa oneho bu ëtani kë tafa motokweijabë na ëje mana kë tafa mokouja, bu letitabo hoha kwe Jonye bu tako letitabo homu. Kwe, Goto eso home kë tafa lëgletëmebë oneho mago, li atwati homu kë tëtabebë, bu letitabo homu kwe Jonye bu sogë letitabo ho.” ");
INSERT INTO nce_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Na iniwa oneho na takis baliti kë glo mëglekefëyabë hona bu kë gali aholokwane mëtla na gali mëtla, “Gotobë lowene ebë lale mu.” Jon bume wafi baptais totomeme nëgeme na bu kë galime këme gali mëtla. ");
INSERT INTO nce_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kwe Farisi ho, na Gotobë galime okokwe moglomabë hona bu Jon mëta baptaisme iweniji lamëtla. Këme nëgeme bu, Goto kë lebotane tëtatëmebë lale loweneme, tëboijiwa këme molola. ");
INSERT INTO nce_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Na Jisas bu ita gali tlome, “Ebë olëna kë tafa mëglabë oneho bu fëye wesibihane? Bo some waflë galina lëlekuju nëletëyo. ");
INSERT INTO nce_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kë oneho bu fli hobë gali tole hana mletëma. Bu nëbale lifeku kume kë salë mëglabë fenene. Bu fli nëbaleme gali melëkakëma, ‘Iniwa wesibi sebo metole kë nëgletëmabë, sobo kë wesibime tole hana eletemo. Sebo some ifeife nëletëyo, sebo sobona sawa nanëglame kwe sobo sawame tëboijiwa lalo. Na sebo maninibo ye nëla kwe sobo tëboijiwa lalo na ye hana elo.’ ” ");
INSERT INTO nce_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Na Jisas ita gali tlome, “Jon, onehome kë baptais totomebë ho, bu tisi na bu bletë nage na wain tabo liji tu hana hi tle. Kwe sobo gali telo, ‘Ahwane tëbo bu mëta tafa lële.’ ");
INSERT INTO nce_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Na bo, Gotobë life mago ho, bo tigisibë na bo hi wesibi hi telë na wain taba liji tu hi telë na sobo gali tlekefo, ‘Sobo hwi elo, bu feilawa hi lëglekefëbë ho na feilawa wain taba liji tu hi lëglekefëbë ho. Na bu takis baliti kë glo mëglekefëyabë hobë yabe na tëbo lowene kë fa motokweflabë hobë yabe.’ ");
INSERT INTO nce_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Sobo këha gali gali elekefo, kwe oneho bu Gotobë lowene kë fa mogotlabë, bu seme melebotane mëtatëname, Gotobë lowene ebë nëgali mu.” ");
INSERT INTO nce_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisi ho, bubë weniji Saimon, Jisasme no tlële, buna hi namëgelome. Na Jisas kë hobë lowa tëkaklu na hi labuku mëta tafa tle. ");
INSERT INTO nce_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na lisei lisei tëglebë mëse, li kë lifeku mëta tëtabe. Kë mëse, gali meaholokwane tle Jisas Farisi hobë lo mëta kë lëtabe. Na bu lale anijina kë blëge blëge mëtëtayabë botolona lëkaluwa tu fa totle. ");
INSERT INTO nce_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Na bu Jisas kë mëta tafa lëglebë lowa tlelëkakule, na Jisasbë elebo li mëta tlibetle. Na mana ye tle. Bu ye tlebë na nabatu Jisasbë juba mëta tuha tetotë. Na bubë eslehuba heletanënona, Jisasbë juba mago nabatu sosa totometle. Na bubë juba ëfalëbona itaita momotlë tletle na lale lëkaluwa tu juba mëta wë tëtatle. ");
INSERT INTO nce_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Na kë Farisi ho Jisasme bubë lowa hime kë notëglëlebë, kë mëse, Jisasme kë fa tëgëtatlebë wesibi yafe hwi tlole na bubë lowenenawa melowene tle, “Kë ho, Gotobë life mago nëgebë, kwe bu melowene lëgletëme fene, ‘Bu tëbo lakalena mëse.’ ” ");
INSERT INTO nce_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisas bu kë hobë lowene walowene tletle na bume gali tlole, “Saimon, bo jume li galime gali nolëme.” Na Saimon bume gali tlole, “Tisa, jubë gali të etle.” ");
INSERT INTO nce_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Na Jisas gali tle, “Tlemalë ho bu baliti li hobë toba mago esokwaneme glo mëtelo. Li ho bu we lujuafe we baliti esokwaneme këniji glo tle na liye we lujuwa balitiwa esokwaneme këniji glo tle. ");
INSERT INTO nce_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kwe tokwafe kë tlemalë ho kofaya baliti mëglëlome fene kwe bu baliti hanane. Na këme nëgeme bu kë tlemalë hobë kofaya baliti glo lëglebë lowene aholokwana ti lëletëmeme na kë balitime ita hana takune loglomeme. Na ju habë lowene lalene, bu mago tlemalë ho ebë kë nëgebë feilawa tole yalë lëgletlemene o sogi tolewa yalë lëgletlemene?” ");
INSERT INTO nce_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Na Saimon bume gali tafu tëtatle, “Bo melowene nanelë, we lujuafe we baliti esokwaneme kë tëglëlebë ho, bume tako tole latletle.” Na Jisas bume gali tlole, “Jubë gali nëgali galimu.” ");
INSERT INTO nce_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Na Jisas mëseme swaya tokokwetë na Saimonme gali tlole, “Saimon, ju ebë mëse kë eglibebëme hwi hana eolëne? Bo jubë lowa nëkaklina, kwe ju bobë juba tuna swa hana etometenë. Kwe ebë mëse kë nëgebë, bubë nabatuna bobë juba swa etometenë. Na bubë esolehubana sosa etometenë. ");
INSERT INTO nce_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Na ju bome ëfalëbona sësle hana etanë, kwe ebë mëse bobë juba ëfalëbona sësle etometenë. ");
INSERT INTO nce_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Na ju bobë eso mëta welë tu hana wë etatenë, kwe ebë mëse, bobë juba mëta lëkaluwa tu wë etatenë. ");
INSERT INTO nce_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Këme nëgeme bo jume gali nolë, ebë mëse kë nëgebë, bo bubë feilawa tëbo lowene aholokwana wati nëletë. Këme nëgeme bu bome tako tole këme eletenë. Kwe ho bubë tëbo lowene tokwëfo, na Goto kë tëbo lowene aholokwana wati lëletle kwe bu Gotome tokwëfo tolewa lëletle.” ");
INSERT INTO nce_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Na Jisas kë mëseme gali tolë, “Bo jubë tëbo lowene aholokwana wati nëletë.” ");
INSERT INTO nce_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Na buna masei li mëta kë tafa mëtlabë ho, bu kë gali aholokwane mëtla na blalo mana gëgali mëtla, “Ebë habëtabo hone? Bu sogëna lalële, tëbo lowene aholokwana habëna ti eglemene?” ");
INSERT INTO nce_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Na Jisas kë mëseme gali tolë, “Ju bome lowene sle egletenëme nëgeme, na Goto jubë tëbo lowene aholokwana këme ti lëletë. Jubë lowene wasle nëtatë. Ju fleflesuna eiju.” ");
INSERT INTO nce_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tokwafe, Jisas li life li life asë tëbelëfa na onehome, Goto onehobë eso home tafa lëgletëmebë, lale gali të tëtagutëme. Na bubë lowene esogo mëglelëtlabë ho we ita tële, buna mutuja. ");
INSERT INTO nce_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Na fli one mata, ëbame ahwane tëbo bubë ato mago kë hehë tëgletëmebë na tëbo kë sle totometëmebë, buna mutuja. Liye, Makdala life mago Maria. Ëbame Jisas, tobali ita tële ahwane tëbo, bubë ato mago hehë tletëme. ");
INSERT INTO nce_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Na liye Joana na Susana na fli feilawa one mata buna mutuja. Kë one kë nëgebë, bu Jisasna bubë lowene esogo mëglelëtlabë hona, bubë balitina, hi wesibina mëtaitama. Joana ebë Kusabë no. Na Kusa, eso ho Herotbë lo tafa lëlelëkefëtlebë eso ho. ");
INSERT INTO nce_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Li life li life mago oneho Jisas belë mitisiya. Na feilawa oneho bume loko mëtlelëtla. Na bume waflë gali të tëtatëme, ");
INSERT INTO nce_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ho li nujuwa luju, aoba liji sike nalëkoume. Bu aoba liji sike lëkoubëë, na fliye alëgeme mititigo tle. Na oneho jubana fëfe melekefëya na fole jiwa mëtëkekebë lahiwa mële. ");
INSERT INTO nce_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Na fli aoba lijiye anijina flëke mëta mititigo. Na liji hulu mële kwe kë flëke tu jwa nëgeme, na lakokowa mëbe. ");
INSERT INTO nce_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Na fli aoba lijiye, ikiji taba wayo mëta mititigo. Na kë ikiji tabana aoba liji weife hulu mëtle na kë aobame lamuwa mototome. ");
INSERT INTO nce_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Na fli aoba lijiye bu lale flëke mëtamu mititigo. Na bu hulu mëtle na bubë liji feilawamu motowalë. Bubë liji këniji motowalëwagu, we lujuafe we, we lujuafe we.” Jisas kë waflë gali watë tëtatëme na onehome gali tlome, “Ebë gali aholokwane lalo, sobo salowene sle eletelo.” ");
INSERT INTO nce_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jisasbë lowene esogo mëglelëtlabë ho bume kë waflë gali wayobëme takune motlola. ");
INSERT INTO nce_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Na bu këme gali tlome, “Ëtani, Goto, onehobë eso home kë tafa lëglelëmebë gali olafa hana tletëme. Kwe ebë olëna bu kë ëho gali some waolafa tëtatëyo. Kwe bo fli onehome waflë galinawa gali tlome. Bo waflë galiwa këme gali tlome, bu mana itaita hwi mëglekefëyana kwe wesibi lowene sle hana mëgletlame. Na bu gali itaita meaholokwane mëglekefëyana kwe gali wayobë lowene hana mëgletlame.” ");
INSERT INTO nce_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Na Jisas ita gali tlome, “Kë aoba liji waflë gali wayobë melë lëgëbetlelalële. Aoba lijiye, Gotobë galime lëlekuju ne. ");
INSERT INTO nce_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Na aoba liji alëgeme kë mititigobëye, bu Gotobë gali aholokwane mëglabë enëneme lëlekuju ne, kwe Satan ligisiwa lëglebë na kë gali bubë lowene mago lafawa letokwakëtëme. Satan bu melowene lalële, ‘Gotome lowene sle mëgletlalime na Goto bume nëno lëglelime.’ ");
INSERT INTO nce_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Na aoba liji, anijina life mëta kë mititigobëye, bu ebëha enëneme lëlekuju ne. Bu Gotobë gali aholokwane mla na hokweinawa lowene mletla na fleflesu mletla. Kwe bubë gali bubë lowene mëta lëgëbetëme sle hana lëletëme, olo wesibi fenene tayafo su sle hana motometëme. Këme nëgeme, kë nalëwa këme lowene mletla. Kwe hobota olë yafe fata lëletëme, Gotome aholokwana latiwa mla. ");
INSERT INTO nce_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Na aoba liji, ikiji taba wayome kë mititigobëye bu ebëha enëneme lëlekuju ne. Bu Gotobë gali aholokwane mla na lowene mletla, kwe bu ebë life mago hobota wesibime fwa tako lowene lamletëma, na feilawa baliti glo mëglame fwa lowene mla, na bu ebë life mago lale wesibime fwa fleflesu mla. Na kë wesibiwa Gotobë gali lëlamu mëtatle, na bu Gotobë gali lowene sle jwa këme mletla. Bu tëtetabo hi wesibi fenene. ");
INSERT INTO nce_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na aoba liji lale flëke mëta kë mititigobëye bu ebëha enëneme lëlekuju ne. Bu Gotobë gali aholokwane mla, na bu kë gali bubë lowenena kiki motla. Bubë lowenena maninibona lalowa mëbetëmemu. Na bu kë gali aholokwana hana ti mla na bubë lowene li wesibi mëtaha hana soslo lëletëme na bu lale lowene mëta fwa tafa mla.” ");
INSERT INTO nce_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jisas ita gali tle, “Oneho bu lamo fiji mëtayana, na isekuna hana lamu mëgëtayame o ni labuku lokwalëfe mëta hana ëho mëgëtayame. Hanane mu. Bu masei mëta gwa mëtaya. Na oneho lowa mëkaklijana, bubë elulego hwi namoglotëyame. ");
INSERT INTO nce_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Na wesibi elulego mëta fene olafa tletëme, iniwa wesibi ëho kë mëglebë, kwe tokwafe Goto olafa lotomeme. Na iniwa wesibi oneho ëho kë motomabë, kë mata, tokwafe Goto olafa lotometëmeme na oneho bu hwi molomame. ");
INSERT INTO nce_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Sobo ululu sle saelo, gali aholokwane sle naegelome. Ho bu Gotobë gali lowene sle lalëletlee kwe ita Goto bume fli lowene lëglëleme. Kwe ho bu Gotobë gali lowene sle hana lëletlee kwe Goto kë hobë tokwëfo lowene ita hijika logotleme na bu kë lowene aholokwana ti lëleme.” ");
INSERT INTO nce_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Na kë nalëwa, Jisasbë botana bolijamonina mitisiya, bume hwi namoglolame. Kwe feilawa oneho bume loko mëtlelëtlame nëgeme na bubë li elë hana mutuju tla. ");
INSERT INTO nce_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Na bume gali motlola, “Bitana, blijamonina, jume hwime misiya. Bu lo mëglëbo elë ekë milija.” ");
INSERT INTO nce_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kwe bume gali metafu latëtatëme, “Oneho Gotobë gali aholokwane mëglabë na esogo melelëkefëtlabë, buwa bobë beënino na keinëbalenino na afanino.” ");
INSERT INTO nce_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Na kë nalëwa, Jisasna bubë lowene esogo mëglelëtlabë hona, ihe elë fëfe mëtla. Na megali tlome, “Te, sebo lake tu jelëfo elë mana su manëkaka.” Këme nëgeme bu mutuja. ");
INSERT INTO nce_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ihe tigiwabë na Jisas ni tëbe. Na tako flelu lake tu mëta fata tletëme, na lake tu ihe elë okokli tokoke, na tu tëtafu lëgleme kofene, tëbo namiglitayame kofene. ");
INSERT INTO nce_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Na bu Jisasme ni mago huju mototla na gali motlola, “Tako Ho, huju ele. Sebo tëbo niglitayame ekëyo.” Na bu huju tle na tu susugli name, flelu name kale tlome. Na kwe fleluna tu susuglina latliwa mëtëbe. Na tu mëgelimeha latëgemulewa. ");
INSERT INTO nce_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Na bubë lowene esogo mëglelëtlabë home takune tlome, “Bome lowene sle jwa fëyeme eletënane?” Kwe bu Jisasbë kalëlego hwi motlolame nëgeme na bu ulina tutunena memëtla na blalo gëgali mëtla, “Euowe! Ebë habëtabo hone? Bu galiwa lëglena, na fleluna tuna bubë gali laaholokwanewa molole.” ");
INSERT INTO nce_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jisasna bubë lowene esogo mëglelëtlabë hona Galili provins kile mototla na Galili lake tu jelëfo elë ihena su mëtëkaka na Gerasabë walujuwa fwa mutula. ");
INSERT INTO nce_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Jisas ihe kile tle na helefowa fe tokwake, na ahwane kë tetëbo mogotlebë ho bume esune tlële. Kë ho bu feilawa olë, ëhona nane tëtabekëfe na bu lome fwa nane tatafa tlekëfe. Weye! Bu matëmatë life mëta fwa tatafa tlekëfe. Olëli olëli ho bume itaita fa mototokwefla na bu senë tabana, toba kabana yafe gëgelo mototokwefëmetla, kwe bu laeluluwa totokwefëme. Na kë ahwane tëbo bume ho jwa tabo elë memëtlelukefle lamëtle. Kë ho Jisasme hwi tlole, na tako afëflei metle na bubë elebo lime latitigotlewa. Na Jisas kë ahwaneme megali tlole, “Ju ebë home kile ele.” Na bu anisasana këme afëflei tle, “Jisas ju tako kalëlegona Gotobë nëba mu. Ju bome habelë egëtanëmene? Masiwafe, ju bome asa tëbo etanë.” ");
INSERT INTO nce_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Na kwe Jisas bume takune tlole, “Jubë weniji fë etlemo.” Bume feilawa ahwane mëtëkaklu tleme nëgeme na bu metafu këme tëtatle, “Bobë weniji feilawa ho.” ");
INSERT INTO nce_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Na kë ahwane Jisasme anisasana itaita gali motlokwefla, “Ju seme ahojuna fuluju elë asa jine enëna. Matëbe.” ");
INSERT INTO nce_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Na kwe lebutako kleli bu fatini mleibu li mëta monei mëtle. Na ahwane Jisasme anisasana gali motlole, “Ju seme kë kleli belë jine elëkakëna, nëkakluja nanëglame.” Na kwe Jisas gali tlome, “Sobo lalowa eyeumo.” ");
INSERT INTO nce_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Na ahwane kë home kile mototle na kleli belë mëtëkaklutëme. Na bu fatini mago lake tu elë fëka mëtëmalita na tu mëta lasusugluwa mëtle. ");
INSERT INTO nce_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Na kleli mëglëmabë ho bu kë wesibi hwi motlola na mëtlëbouja. Na kë gali li life li life të mëtëtagula. ");
INSERT INTO nce_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Na iniwa oneho mutuja kë wesibi hwi namoglomame. Na bu Jisas belë fwa mutula na ahwane bume kë kile mototlebë home mana hwi motlola. Bu lale ëho wateho na bubë eso hana yaya tletle. Na bu Jisasbë elebo lime tafa tletle. Na bu iniwa uli memëtla. ");
INSERT INTO nce_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Oneho Jisasme ahwane kë hehë tëgletëmebëme kë hwi motlolabë, bu tokwafe kë mitisiyabë onehome kë gali të mëtëtatëma. ");
INSERT INTO nce_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Na Gerasa lifate li mago life enëne bu kë gali aholokwane mëtla na bu tako uli memëtla na Jisasme këme hehë mëtletla, bubë lifeku mago luguju nalëgleme. Na këme nëgeme Jisas ihe mëta fe tle, muguja namëglame fene. ");
INSERT INTO nce_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Kwe ahwane kë kile mototlebë ho Jisasme anisasana takune tlole, “Bona lalowa nëgëyeumene?” Na kwe Jisas bume hehë metletle na këme gali tlole, ");
INSERT INTO nce_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Jubë lifekuwa ejumo, na Goto jubë tëbo wesibi kë sle totometëbë gali të eoutatëmeme.” Na kë ho tuju, na kë lifate mago onehome, Jisas bume kë tëgaitalebë gali të tutatëme. ");
INSERT INTO nce_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Na kwe Jisas ihena lake tu jelëfowa ita su mëtëkaka. Na feilawa oneho bume hwi mëtlekefëtla na bume hwi motlola na tako fleflesumu memëtletla. ");
INSERT INTO nce_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Na lotu lo hwi loglokweflebë eso ho tisi, bubë weniji Jairus. Jisasme hwi tlole, na elebo lime latitigotlewa. Kë hobë nëba gli egleme kofene na bume anisasana këme takune tlole, bubë lowa lëglelule nalëgleme. Kë ho bu jowa nëbawa. Na kë nemosa nëbabë tlibutu tabei këniji, we ita tële. Na kwe Jisas tuju na feilawa oneho buna gëgeniwa mutuja. ");
INSERT INTO nce_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na mëse li kë oneho buna iniwa mutuja. Kë mëse bu we ita tële tlibutuna ko latëkoukëfe. Ho bubë ato yafe sle sle mëtëtatëya kwe wino te hanatle. ");
INSERT INTO nce_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kë mëse Jisasbë leluju elëme tuju tle. Na bubë heletabo ëho mëta tobana lu totle na ko kë tëglebë latewa tle. ");
INSERT INTO nce_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Na Jisas gali tle, “Bome ya lu lëtanëne?” Na iniwa oneho bume gali motlola, “Sebo kwe hanane.” Na Pita bume gali tlole, “Tako Ho, ju hwi hana elene, lebutako oneho juna gëgeniwa kë egëyeubë?” ");
INSERT INTO nce_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kwe Jisas gali tle, “Bo melowene nanelë, ho li bome tobana lu lëtanë. Bo mesu nanelë, bome fli afutuku wakile mëtanë.” ");
INSERT INTO nce_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Na kë mëse melowene tle, “Bu walowene lëlefe, bo hana ëho nëgelëmefe.” Këme nëgeme bu lilina metle na tisi tle na Jisasbë elebo lime latitigotlewa. Na iniwa onehobë naba lime gali tle, “Bubë ëho, bo lu nëtatelëfe. Melëme nëgeme, bobë ato sle nalëgletenëme. Na bobë ato elili laslewa lëletenë.” ");
INSERT INTO nce_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Na Jisas gali tolë, “Mola, ju lowene sle egletenëme nëgeme, jubë ato këme titika lëletë. Na ju eiju. Tutune asa ele, lalowa tafa eguleme.” ");
INSERT INTO nce_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisas mana gëgali tlelëbëë, na ho, lotu lo hwi loglokweflebë eso hobë lo mago nëba wofu mana fata tlelëkakile. Na Jairusme gali tlole, “Jubë nëba wagli elo. Ju tisame ita sosalë asa etle. Matëbe.” ");
INSERT INTO nce_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jisas kë gali aholokwane tle na Jairusme gali tlole, “Ju tutune asa ele, bome fwa lowene sle egletenëme na jubë nëba lalowa egëtabetëme.” ");
INSERT INTO nce_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Na Jisas Jairusbë lowa tuju. Na bu onehome buna mëkaklujame hehë latletëme. Bu Pita, Jems, Jon, kë nëba bota, bolijayaname fwa tlelëkakume. ");
INSERT INTO nce_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Na kë lo mëta kë tafa mëtlabë oneho bu kë nëbame tako maninibo memëtletëya, na ye mëtlelëkefëya. Na Jisas gali tlome, “Sobo fëyeme ye ye elelëyone? Kë nëba gli hana elo. Ni labe tekwe nëge.” ");
INSERT INTO nce_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kwe bu Jisasme tako soso memëtlëlamu. Bu melowene mëtlame nëgeme, “Kë nëba wagli sle elefe.” ");
INSERT INTO nce_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kwe Jisas kë nëbabë tobame fa tëta na anisasana gali tolë, “Nëba, ju huju ele!” ");
INSERT INTO nce_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Na bubë amtëtomba ita tisitë na lahujuwa tëkake. Na Jisas bume gali tlome, “Sobo bume hi wesibi elëyomo.” ");
INSERT INTO nce_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Na kë nëba botana bolijayana klelego memëtelo. Kwe Jisas bume anisasana gali tlome, “Sobo ebë wesibime ho flime asa gali elomo. Matëbe.” ");
INSERT INTO nce_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Na Jisas, bubë lowene esogo mëglelëtlabë ho we ita tële kënijime gali telokwakëme na bu mitisitla. Na bu tako afutuku bume tlëme, bu ahwane onehobë ato mago kë afutukuna hehë namëgletëmame na tëbo kë mëglabë onehome sle namogotomame. ");
INSERT INTO nce_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Na bu, Goto onehobë eso home tafa lëgletëmebë gali të name na onehobë tëbo ato sle name, jine tëbelëkakëme. ");
INSERT INTO nce_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Na bume gali tlome, “Sobo egëyeuna, sobo wesibi asa ehoujo. Sobo liji, musu, hi wesibi, baliti, hihijika ëhona asa ehoujo. Matëbe. ");
INSERT INTO nce_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Sobo li lifekuwa tuhu egulona na ho some nëno lëglena, sobo kë lo mëta fwa nini ebekefome. Kë lo mëta nini ebekefobëë, na mana kë magowa eyeume. ");
INSERT INTO nce_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Na sobo li lifekuwa tuhu egulona na kë lifeku mago oneho some nëno hana mëglana, kwe sobo kë lifeku lakilewa elome. Sobo kë life mago egëyeuna, kwe sobobë juba mago flëke bubë naba li mëta bu elome. Bu some këme hwi mëglëyona na melowene namëglame, ‘Fëyeme tëbo nilitayane? Goto seme tëbo lëgëtanamefe.’ ” ");
INSERT INTO nce_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Na bubë lowene esogo mëglelëtlabë ho bu mana iniwa lifeku elë mitliwaya. Na bu Gotobë lale gali të mëtëtagumetëma na iniwa onehobë ato elili sle mëtëtagumetëma. ");
INSERT INTO nce_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Galili provins enënebë eso ho Herot, bu Jisas kë totomebë wesibi aholokwane tle, na bu feilawa këme tutune tlekëfe. Fli oneho megali mëtlame nëgeme, “Ebë kwe, onehome kë baptais togotomebë, Jon, matëmatë mago wahuju tle.” ");
INSERT INTO nce_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Na fli oneho megali lamëtla, “Ebë kwe, ëtanifu ho, Elaija tekwe nëge, matëmatë mago huju tlefe.” Na fliye kwe megali lamëtla, “Ebë kwe, Gotobë lowene mago gali ëtani kë të mogotlabë ho li, tekwe nëge, matëmatë mago huju tle.” ");
INSERT INTO nce_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Këme nëgeme Herot megali latle, “Ëbame, bo wame home boblo logotomebë home gali tlolë, na bu Jonbë eso, mou lokwati iniwa tlë tëtatle. Kwe kë fëye homune? Bo ho mago meaholokwane nanolokwefëmë, bu klelegowa wesibi blëge lotokwefëme.” Na bu Jisasme hwime tole tletle. ");
INSERT INTO nce_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Gotobë gali tëme kë jine tëgelëkakëmebë ho, ita loko mëtëkakija na bu iniwa wesibi melë kë mëtlabëme, Jisasme të mëtëtatla. Na Jisas bume nëno tle, na bu fli onehome hune mëtla na bume fwa li lifekuwa tlelume. Këbë life weniji Betsaida. ");
INSERT INTO nce_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tokwafe lebutako oneho melowene mëtla, “Bu wafi mujafe.” Na kwe bu nagi esogo mëtlaguma. Bu belë mitisitla na Jisas gali tlome, “Sobo lalowa esijo.” Na bu, Goto onehobë eso home kë tafa lëgletëmebë gali, të tëtatëme. Na bu tëbo atona onehome sle totome. ");
INSERT INTO nce_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Na taboklë mu, Jisasbë lowene esogo mëglelëtlabë ho we ita tële, bu belë mitisiya na bume gali motlola, “Te, ju onehome mana jine ebelëkakëme, lolime kë mëgëbebë lifeku elë mana migliwaya, hi wesibime hohwi namëtayame na ni lo mata hohwi mëtatlame. Ebë ho jwa life nëgeme.” ");
INSERT INTO nce_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kwe Jisas bume gali tlome, “Sobowa hi wesibi elëmo.” Na bume gali motlola, “Sebo feilawa hi wesibi hanane. Sebo tobali bletë nage na mo tële, këwa ekë mëbe. Ju melowene lalene, ‘Sebo hi wesibi kë iniwa onehome balitina glo nanëgletëmamene, hee?’ ” ");
INSERT INTO nce_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ebë hobë tabei këniji 5,000. Na Jisas bubë lowene esogo mëglelëtlabë home gali tlome, “Sobo onehome gali elomo, 50, 50 mëta tafa namokouja.” ");
INSERT INTO nce_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Na bu melë mëtla na iniwa oneho tafa motokouja. ");
INSERT INTO nce_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Na Jisas kë tobali bletë nage na mo tële glo tle, na matafa elë hwi tokwake na Gotome lale gali tlole, “Ebë bletë nagena mona yaha fëyeme enënane?” Na bu klelegowa wesibi blëge totome na kë bletë nagena mona fufu totome na bubë lowene esogo mëglelëtlabë home tlëme, onehome sa namëgëtatëmame. ");
INSERT INTO nce_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Na bu iniwa hi mëtla na hahana memëtlelëma. Na bubë lowene esogo mëglelëtlabë ho, lëne hi wesibi loloko mëtëtaya na we ita tële këniji basketë musu tëtafu mototoma. ");
INSERT INTO nce_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kë nalëwa, Jisas, buwa Gotome gëgali tlelële, na bubë lowene esogo mëglelëtlabë ho bu belë mutuju tla. Na Jisas bume takune tlome, “Oneho bome habë weniji lamlane?” ");
INSERT INTO nce_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Na bume gali tafu mëtëtatla. “Fli onehowe megali lamëtla, ‘Onehome kë baptais togotomebë Jon, tekwe nëge, matëmatë mago huju tle.’ Na fliye megali lamëtla, ‘Gotobë gali, ëtani kë tëgehilebë ho, Elaija, tekwe nëge, matëmatë mago huju tle.’ Na fliye megali lamëtla, ‘Gotobë gali ëtani kë mëtehilabë ho li, tekwe nëge, matëmatë mago huju tle.’ ” ");
INSERT INTO nce_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Na Jisas bume takune tlome, “Na sobo bome habë weniji lalone?” Na Pita bubë gali tafu tëtatle, “Ju ebë ho kë nëgebë, Goto jume kë aniji toglëbë ho, onehome nëno naegleme.” ");
INSERT INTO nce_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Na Jisas bume anisasana gali tlome na meheheë latletëme, “Sobo kë galibëme fli onehome asa gali elomo. Matëbemu.” ");
INSERT INTO nce_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Na Jisas bubë lowene esogo mëglelëtlabë home gali tlome, “Tokwafe bo, Gotobë life mago ho, lebutako elili na hobota fa nogotlëme. Na letitabo enëne na lotu lome wege mëglabë eso enëne, na Gotobë galime okokwe moglomabë ho, bu bome hehë mëgletëname na bome mogo nalë tëkle mëgëtaname. Na bo matëmatë mëta tële olë nebëme kwe aona olëbëye mana huju nelëme. ");
INSERT INTO nce_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ho bome na bobë loweneme esogome tole lëglena kwe bu ebë life magobë lale wesibi, bu kë tole lëgletëmebë, aholokwana satimu sle lëletëme na glime uli jwamu lëleme. Ho bume wame gali moglolana na bume mogo nalë tëkleme gali mëglana, bu uli jwa lëgleme na bome iniwa olë mana esogo lëlenënëme. ");
INSERT INTO nce_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ho bu melowene lëglena, ‘Bo Jisasme esogo nëglelëlëna fli ho bu bome tëbo mëgëtaname.’ Na bu, bubë ato uli lëglelëlena na bome hana esogo lëglenënëna, kwe këha ho bu tëbo liglitame. Kwe ho bu bome lowene sle lëgletenëna na bubë ato uli jwa lëglelëlena kwe këha ho bu hana tëbo liglitame. Ho bu kë home mogo nalë tëkle mogotlana, kë ho gli sle nane lële. Weye. Bu unaunalëme lale tafa lëgleme. ");
INSERT INTO nce_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ho bu ebë life mago iniwa wesibi glo lëglena, na kë ho bu hel life mëta tëbo liglitana, kwe kë wesibi bume habëna mëgaitalemene? Hanane. Bu blawa glo lële. ");
INSERT INTO nce_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tokwafe, bo, Gotobë life mago ho, bo tako elulegona nigisime. Bo bobë ayabë na bubë enselbë klijiha, kë u lëglebë elulegona nigisime. Na ho li, onehobë naba li mëta bobë galibëme able loglomena na bome able lëglena kwe tokwafe bo nigisina, bo mata kë home kofaya able nëgletelëme. ");
INSERT INTO nce_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Bo some nëgali nanolëyo. So mago emëta kë tafa egelobë bu mana neme na Goto onehobë eso home kë tafa lëgletëmebë olë mana fata lëleme. Na bu kë olë mana hwi mololame.” ");
INSERT INTO nce_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jisas kë gali wagëgali tle. Na tokwafe tobali ita aona olë mëtlëbou na kwe Jisas, Pita, Jems Jonname nëno tle. Na tako fatini lufuwa tilekome, Gotome gëgali nalogolelëleme. ");
INSERT INTO nce_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Bu Gotome mana gëgali tlelëlebëë, na bubë weniyane li weniyanena mana fata tletle na bubë ëho melë tatiwamu fata tletle na feilawamu u tletle. ");
INSERT INTO nce_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Na tlemalë ho lafatawa mëtletelo na bume gëgali mëtlelëlo. Kë tlemalë hobë weniji, Elaija na Moses. ");
INSERT INTO nce_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Na bu Gotobë elulegona fata mëtletelo. Na bu Jisasme, Jerusalem lifate mëta wesibi fata mëgletlebëme na bu gli lëglebëme na ebë life kile lëglebëme kë galime gëgali mëtlelëlo. ");
INSERT INTO nce_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita bume kë tafa tëglelëmebë ho bu feilawa nilafale mëtla na ni mëtebëya. Na bu ni mago huhuju mëtla na Jisasbë elulego, na bume kë mëtlebilobë elulego, hwi motlotëma. ");
INSERT INTO nce_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Na tokwafe, kë tlemalë ho, Jisasme kile mogotlome kofene kwe Pita gali tlole, “O tisa, sebo eme tafa nëglabë, ebë lalowa. Sebo aomalë, aona afeteni tli lo gigliji nëglame. Li jubë lo, na li Elaijabë lo na li Mosesbë lo.” Pita bu yaya hoha gali tle na bu kë gali tëglebë gali lowene hana tletle. Bubë efalëbowa lëleguli tletle. ");
INSERT INTO nce_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita mana gëgali tlebëë, na oloba mana tetujule na bume iniwa lamu totome. Na bubë lowene esogo mëglelëtlabë ho uli memëtla. ");
INSERT INTO nce_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Na Goto kë oloba kweli mana gëgali tle, “Ebë bobë nëba. Bo bume wafi aniji tlole, bobë wege fa nalëtatenëme. Sobo bubë gali aholokwanewa eglolome.” ");
INSERT INTO nce_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kë gali wayawe tlole, na bu Jisaswa tlibe. Na bubë lowene esogo mëglelëtlabë ho, kë olëna, kë hwi motlomabë wesibi, ho flime hana gali motloma. ");
INSERT INTO nce_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Li olëna, Jisas na bubë lowene esogo mëglelëtlabë ho aomalëna, fatini mago kle mëtëmalitaya. Na feilawa oneho Jisasme alëgeme esune mëtlëla. ");
INSERT INTO nce_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Na ho li kë onehobë ku mago we tlole, “Tisa, bo jume anisasana gali nolë, bobë nëba hwi naegloleme. Bobë jowa nëba nëgeme! ");
INSERT INTO nce_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ahwane bume itaita lalëkaklukefëtle na bu afëfleina mëtlekëfe. Na kë ahwane bume lilina lalogotlewa na nënafu bubë ëfalëbo elë mowelëbetle. Na këbë ahwane bubë ato tëbo lëtakefëtle na bume hokweinawa hana kile logotleme. ");
INSERT INTO nce_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Na bo jubë lowene esogo mëglelëtëyobë home anisasana yafe takune tlomë, këbë ahwaneme hehë namëgletlame fene. Kwe bu hana hehë mëtletla.” ");
INSERT INTO nce_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Na Jisas metafu tëtatle, “Sobo oneho, sobo lowene sle hana elo. Sobo tëbo lowene eholo. Bo sobona li olë tafame tole hana nelë. Bo sobobë hobota ita fa nogotlëbëme tole hana nelë.” Na bolijayame gali tlole, “Te! Jubë nëba ebelë elesutëna.” ");
INSERT INTO nce_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kë nëba Jisas belë loliwa tisi tle, na ahwane bume lifewa so telëkakle na life mëta tujetigo, na bume feilawa lili totle. Na Jisas këbë ahwaneme anisasana kale tlole na kë nëbame sle totle na bolijayame tlële. ");
INSERT INTO nce_vpl VALUES ("LK9_43a","072_9_43a","LUK","9","43a","43a","Na iniwa oneho klelego memëtla, Gotobë tako afutuku hwi motlolame nëgeme. ");
INSERT INTO nce_vpl VALUES ("LK9_43b","072_9_43b","LUK","9","43b","43b","Jisas kë togotlebë wesibime, oneho mana lowene mëtlekefëya, na Jisas bubë lowene esogo mëglelëtlabë home gali tlome, ");
INSERT INTO nce_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Te, sobo aholo bo sle eto. Bo, Gotobë life mago ho, bu bome home yo moglomame.” ");
INSERT INTO nce_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kwe bubë lowene esogo mëglelëtlabë ho, këbë gali wayobë lowene hana mëtletla. Goto, kë gali wayo bume ëho tëgëtatëmeme nëgeme na bu kë gali wayo lowene sle jwa këme mëtletla. Bu Jisasme uli mëtletlame nëgeme, na bu kë gali wayobëme takune jwa këme motlola. ");
INSERT INTO nce_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Li olë na, bubë lowene esogo mëglelëtlabë ho, blalo kofaya kofaya megali mëtlelogwaya, “Semago, logouta home, ya tafa lëlene?” ");
INSERT INTO nce_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Na Jisas bubë lowene walowene tletëme. Këme nëgeme bu nëba tokwëfo no tlële na bubë lime tlibe. ");
INSERT INTO nce_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Na bubë lowene esogo mëglelëtlabë home gali tlome, “Ho bome lowene lëgletenëna, na ebëha nëbame lëgaitalena, kwe bu bome laitanë. Na ho bu bome lëgaitanëna, bu bomewa nane laitanë. Weye, bome kë jine tëglënëbë ayame laitale. Na ebë nëba fenene, ho somago atwati hoha metafa lëglena kwe kë ho logouta home tafa lëgletëyome.” ");
INSERT INTO nce_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon bu Jisasme gali tlole, “Tako Ho, sebo ho li mehwi latlola, ho jubë wenijina ahwane tëbo hobë ato mago hehë tletëme. Kwe ahwane kë hehë lëgletlebë ho bu sebona jume hana esogo nëglelëyome nëgeme, sebo bume këme fene lëkle totla.” ");
INSERT INTO nce_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Kwe Jisas gali tlole, “Sobo këha home asa lëkle etlo. Ho some wame hana loglëyona, bu sobobë yabe.” ");
INSERT INTO nce_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Goto, Jisasme heven lifekuwa kë no lëglelebë olë nounou lalële. Këme nëgeme, Jisas lowene fa sle totle, Jerusalem lifatewa nalugujume. Na bu tuju. ");
INSERT INTO nce_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Na bu fli home jine tlëme, mogoutaya namëglame. Na bu motoutaya na Samaria provinsbë, lifeku tokwëfo elë mëtëkakluja, Jisasbë wesibi sle namogotometlame. ");
INSERT INTO nce_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kwe kë life mago oneho, Jisas bu belë ligisime tole hana mëtletla, Jisas bu Jerusalem lifatewa tugujume nëgeme. Bu melowene lamëtla, “Bu sebona lotume tole hana lëletënawa na bu Jerusalem lifatebë tako lotu lowa këme luju.” ");
INSERT INTO nce_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Na bubë lowene esogo mëtlelëtelobë ho, Jems na Jon, kë lifekubë onehobë lowene hwi motlometemo na Jisasme takune motlolo, “Tako Ho, ju metole lalene, sebo Gotome takune nanoglolome, kë onehome heven life mago, ahoju tuku nalëtëkaketëmeme, temu namëgebëyame?” ");
INSERT INTO nce_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kwe Jisas swaya tëkaketëme na këkale tlome. ");
INSERT INTO nce_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Na bu li lifekuwa mutuja. ");
INSERT INTO nce_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jisasna bubë lowene esogo mëglelëtlabë hona, alëge elë mutuja na ho li Jisasme gali tlole, “Iniwa lifeku ju egujuna kwe bo jume nagi nëglagwime.” ");
INSERT INTO nce_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Kwe Jisas bume gali tlole, “Mëgali bu ni mëgebebë fuluju nane na fole mata ni tiji nane. Kwe, bo, Gotobë life mago ho kë nëgebë, bo kwe ni nëgebëbë lo hanane.” ");
INSERT INTO nce_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Na kwe Jisas li home gali tlole, “Ju bome nagi enënë.” Kwe kë ho gali tlole, “O tako ho, bo bobë ayame matëmatë mëta afina lalowa gwa nugujetlëmene na mana jume nagi nëlëme?” ");
INSERT INTO nce_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Na Jisas bume gali tlole, “Gigli mëglabë ho, buwa, gigli mëgebëya home lalowa matëmatë motoma. Kwe juwe, Goto onehobë eso home tafa lëgletëmebë gali të etagutëme.” ");
INSERT INTO nce_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Na li ho Jisasme gali tlole, “Tako ho, bo jume nagi nëglëme, kwe bobë weife mago enëneme kaiyo afina lalowa nugujelimëmene?” ");
INSERT INTO nce_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Na Jisas gali tlole, “Ho bu ihena yegu lëglena kwe bu miti nagi itaita hwi lokoukëfena kwe bu ihe yegu sle hana lëglelëme. Na kë fenene, ho bome nagi lëglënëna kwe bu wesibina honame kë hune tëglebëme lowene lëglekefëtëmena, kwe këha ho bu Goto onehobë eso home tafa lëgletëmebë wege hana fa logotleme.” ");
INSERT INTO nce_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tokwafe, Tako Ho Jisas, bu 72 home mata aniji tlome. Na bu tlemalë tlemalëme jine tëbelëkakëme, bume mogoutatla namëglame. Iniwa lifate na iniwa lifeku bu kë belëme lugujume kë tole lëglebë, bu kë enëneme kë iniwa lifate na lifeku elëme jine tëbelëkakëme. ");
INSERT INTO nce_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Na bume waflë gali tlome, “Feilawa hi wesibi bu nuju mago wanigliji mëbe, kwe lebutako wege ho hana mëtabëya, kë hi wesibi fa namogotlame. Këme nëgeme sobo nuju bolijaya, Gotome, sagali elolo, bu wege home jine nalëglëmeme, bubë nuju mago hi wesibi fa namëgëtatlame.” ");
INSERT INTO nce_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Na bume gali tlome, “Sobo eyeumo. Aholokwane elo. Bo some kë jine nëglëyobëye, sobo sipsip kleli nëbale, wame tabo amalebë ku mëta fene mëtabe. ");
INSERT INTO nce_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Sobo baliti musu o wesibi sisike musu o juba jibo asa ehoujo. Na some alëgeme kë esune mëglëyobë onehome, tafana asa gëgali elelëmo. Weye. Sobo hokweinawa saeyeu. ");
INSERT INTO nce_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Na sobo lowa ekaklujona, sobo kë lo mago onehome afina megali eglomome, ‘Sobo ebë lo mëta kë tafa egelobë lowenena sle elo.’ ");
INSERT INTO nce_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Na tu taba ka ho, kë lo mëta tafa lëglena, kwe sobobë lowene sle gali bu mëta malëbetle. Kwe këha ho, kë lo mëta tafa hana lëglena kwe sobobë lowene sle gali sobelë lukwaiji lëkeketëyome. ");
INSERT INTO nce_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Sobo kë lo mëta fwa sani ni ebekefo. Li lo li lo asa elo. Na iniwa hi wesibi some kë lo mago kë mëglëkefëyobë sahi hi elo. Bo ebë galime fëyeme gali nelëne? Ho wege lëglekëfena, kwe bubë wege wesibi lalowa glo lëgleme. Na kë fenene, ho bu Gotobë wege, wege lëgletlena, kwe bubë wesibi glo lëgleme. ");
INSERT INTO nce_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Sobo li lifatewa tuhu egelona na ho some bubë lowa no lëglëyona, kë hi wesibi some kë mëglëyobë, sahi elo. ");
INSERT INTO nce_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Sobo kë life mago ato elili onehome sasle etomo. Na sobo gali metë saetatemo, ‘Goto bu sobobë eso home natafa lëgletëyobë olë nounou lalëletëyo.’ ");
INSERT INTO nce_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Na sobo li lifatewa tuhu egelona na kë life mago oneho some nëno hana mëglana, kwe sobo kë lifatebë alëge mëta elibome na megali elëmome, ");
INSERT INTO nce_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Sobobë lifate flëke sebobë jubame kë lesili mëglebë sebo sosa nanotoma. Some melebotaneme nëgeme, ebë wesibi sobo kë egelobë wafi tëbo elito. Kwe sobo lowene sle elo, Goto bu sobobë eso home natafa lëgletëyobë olë nounou lalëletëyo, kwe sobo kë olë tole hana eletelo.’ ");
INSERT INTO nce_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Bo some gali nolëyo, Goto, iniwa onehobë gali aholokwane loglomebë olë na onehome fufu logotomebë olë fata lëglena, kwe bu ebë lifatebë onehome tako tëbo logotomeme kwe bu Sodom lifatebë onehome sogë tëbowa logotomeme.” ");
INSERT INTO nce_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Na Jisas ita gali tlome, “Sobo Korasin lifate mago oneho na sobo Betsaida lifate mago oneho, masiwafe, tokwafe tëbo wesibi somëta fata mëgletëyome. Ëbame, bo sobobë ku mëta Gotobë afutukuna, klelegowa wesibi blëge blëge tëtatëyo, kwe sobobë tëbo lowene aholokwana ti hana elo. Ëtani, bo Tair na Saidonbë onehome këha klelegowa wesibi hana blëge blëge tëtatemë. Kwe bo Tair na Saidonbë onehome, këha klelegowa wesibi blëge blëge nëgëtatemëbë, kwe bu ëtani anebo bubë tëbo lowene aholokwana wati mëglame fene na lale lowenewa esogo mëglelëlame fene. Na bu tëbo ëho wafi gëgelo motomame fene na atikafa wafi ju mëglame fene, bu melëme lëlekuju mëtla, bubë tëbo lowene wahune mëtla. ");
INSERT INTO nce_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Goto, iniwa onehobë gali kë aholokwane loglomebë olë na onehome kë fufu logotomebë olë fata lëglena, bu some tako tëbo lëgëtome kwe bu Tair na Saidon life mago onehome sogë tëbowa logotomeme. Sobo kë klelegowa wesibi hwi toglomome nëgeme kwe sobobë tëbo lowene aholokwana hana ti elo. ");
INSERT INTO nce_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Na sobo Kaperneam life mago oneho, sobo melowene lalone, ‘Sebo lale enënemu nëgeme na Goto seme heven life elë nëno lëgleme.’ Weye. Hanane mu. Goto some tëbo lëgëtome na hel lifewa sike lëtëkakeme.” ");
INSERT INTO nce_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Na Jisas bubë lowene esogo mëglelëtlabë home gali tlome, “Oneho sobobë gali aholokwane sle lameletëyo bu mata bobë gali aholokwane sle mëgletëname. Na oneho some hehë lameletëyo bu bome mata hehë mëgletëname. Na oneho bome hehë lamëletëna, bu bome kë jine tëglënëbë ho, Gotome mata hehë lamletla.” ");
INSERT INTO nce_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tokwafe, Jisas kë jine tëglëmebë 72 ho, fleflesuna loko mëtëkakija. Na bu gali mëtla, “O, tako ho, sebo jubë weniji fë tëtona, na ahwane bu sebobë gali aholokwane mëtle na lamëtlëbouwa.” ");
INSERT INTO nce_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Na Jisas gali tlome, “Sobo melë tugulona, bo kwe, mehwi latelë, Satan heven lifate mago latitigowa, wawaine fene tle. ");
INSERT INTO nce_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Aholokwane elo! Bo some afutuku wafi tlëyo. Na sobo sebobë wame ho, Satanbë afutuku boblo etatelome. Na sobo wame tabo taiju na mlawalë matawa lalowa asë egolome na iniwa wesibi bu some hana tëbo mëgëtome. ");
INSERT INTO nce_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kwe ahwane, bu sobobë gali kë aholokwane mëgletëyobëme na kë mëtlëboubëme, asa fleflesu elo. Weye. Goto sobobë weniji bubë bogo mëta kë yahi tëgletëyobëme fwa fleflesu egelome.” ");
INSERT INTO nce_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kë nalëwa, Gotobë Amtëtomba, Jisasbë lowenebë fleflesu tëtatle. Na Jisas gali tle, “Aya, ju heven lifate magobë na ebë life magobë Tako Ho. Yaha fëyemene? Bo jume fleflesu nanëletë. Oneho bume fwa melowene lamëtla, ‘Sebo iniwa wesibi lowene sle nëletëma,’ kwe ju jubë afutuku bume ëho tëtatëme. Kwe oneho bume fwa melowene lamëtla, ‘Sebo nëbale tokwetokwëha, sebobë lowene afluja lalëletëna, sebo iniwa wesibi lowene hana nëletëma,’ kwe ju jubë afutuku bume waolafa tëtatëme. O aya, ju jubë tolewa esogo elelële na ju melë eleme.” ");
INSERT INTO nce_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Na Jisas bu ita gali tle, “Bobë aya bu iniwa afutuku na lowene bome watlënë. Iniwa ho bome bubë nëbame lowene sle hana mëletëna. Bolijaya buwa lowene lëletle. Na iniwa oneho, bolijayame lowene hana mletla. Bo bubë nëba na bo ayame lebotane nëtatëmebë, kë oneho buwa lowene mletla.” ");
INSERT INTO nce_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jisasbë lowene esogo mëglelëtlabë ho, bume fwa tafa tlelëme, na bume swaya tletëme na bume fwa gali tlome, “Sobo lebutako lale wesibi wahwi tlomo, na sobo fleflesu egelome. ");
INSERT INTO nce_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Bo some gali nolëyo, ëtani, lebutako Gotobë lowene mago gali të mototokweflabë ho na lebutako life mago eso ho bu metole lamëtla, sobo kë hwi toglomobë wesibi, hwi moglomame fene, kwe bu hana hwi motloma, na bu metole lamëtla, sobo kë aholokwane tëgelobë gali, aholokwane mëglame fene, kwe bu aholokwane hana mëtla.” ");
INSERT INTO nce_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Gotobë galime okokwe toglomebë ho Jisas belë tisi tle, bume tëbo loweneme su nalogotleme fene. Na bu takune tlole, “Tisa! Bo habelë nëgelëmene, lale tafa unaunalëme fa nanogotlëme?” ");
INSERT INTO nce_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Na Jisas bume takune tlole, “Gotobë bogo mago gali habë gali lalane? Ju habë hwi laeolëne?” ");
INSERT INTO nce_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Na Gotobë galime okokwe toglomebë ho gali tafu tëtatle, “Sobo tako Gotome anisasana tole egletelomemu. Lowenena, afutukuna, ini tolewa egletelomemu. Na jubë ato fene tole eletle, ju lime mata metole egletleme.” ");
INSERT INTO nce_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Na Jisas bume gali tlole, “Ebë lalowa. Ju gali tafu sle latle. Ju melë eglena, na ju lale tafa fa egotleme.” ");
INSERT INTO nce_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kwe kë Gotobë galime okokwe toglomebë ho bu metole latletle, Jisas bume melowene nalëgletleme, “Lale lowenena hofe.” Këme nëgeme bu Jisasme këme takune tlole, “Gotobë bogo mago gali, bobë fëye yabe home gali elane?” ");
INSERT INTO nce_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Na kwe Jisas metafu tëtatle, “Ëbame, ho li, Jerusalem lifate kile tle na Jeriko lifatewa tëmatule. Bu tematulebëë na wameho alëgeme ëho mëtla, na bu alëgelëme okli mëtelëkukiya na fa mototla na tëkle mototlabëë ëjeha gli lëleme. Na bubë ëho titika mëtletla na bubë iniwa wesibi mata glo mëtletla na mana bume alëge mëglëbo mëta lakilewa mëtëkaka na bu mëtlëbouja. ");
INSERT INTO nce_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Na kë olë nawa, lotu lome kë wege lëglebë ho mata kë alëge elëme tëmatule. Kwe bu alëge mëglëbome kë lëgëbebë home hwi telokwakle na alëge mëglëbo elë sigli tëtagule na latugujuwa. ");
INSERT INTO nce_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Na tokwafe, Livaibë afenëbo, lotu lo mëta kë wege lëglekefëbë, bu mata kë alëge elëme tëmatule na kë home hwi telokwakle, na lolime hwime tuju tle na hwi tlole kwe bu mata sigli tëtagule na latugujuwa. ");
INSERT INTO nce_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kwe Samaria lifate mago ho li, bu mata nagi tëmatule. Na bu kë home hwi telokwakle, na bume tako masiwamu metletle. ");
INSERT INTO nce_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Na bu loliwa tuju tle, na bu wain taba liji tu, welë tuna, bubë juba këna swa totometle na kë juba, ëho kaka tabona lalei totometle. Na bume huju totle na bubë donki kleli amlebo matawa gwa towetle. Na bume oneho këme ni mëtëbekefëyabë lowa tlelule, na bume ululu sle latotle. ");
INSERT INTO nce_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Na li olëna, bu tële baliti kë ni lo bolijaya home tlële na gali tlole, ‘Ju ebë balitina, ebë home këna satafa elelële. Na jubë baliti, bume tafa eglelëlebëme, sike eglena, kwe tokwafe bo nigisina, bo kofaya baliti jume nëglëme.’ ” ");
INSERT INTO nce_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Na Jisas kë Gotobë galime okokwe toglomebë home takune tlole, “Ju habë lowene lalene? Wame ho kë tëkle mototlabë hobë yabe yalëmune?” ");
INSERT INTO nce_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Na bu gali tle, “Ebë ho bume kë masiwa lëgletlebë na kë lëgaitalebë, ebë bubë yabemu.” Na Jisas bume gali tlole, “Ju ejume na kë ho fene laitale ju melë egleme.” ");
INSERT INTO nce_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisasna bubë lowene esogo mëglelëtlabë hona Jerusalem lifatewa mutujabë na li lifekuwa fwa mutula. Na kë lifeku mago mëse, bubë weniji Marta, Jisasme bubë lowa no tlële. ");
INSERT INTO nce_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martabë bolijamobë weniji Maria. Maria, bu Jisasbë elebo lime tafa tletle na bubë gali mana aholokwane tlokwefle. ");
INSERT INTO nce_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kwe Marta bubë hi wesibi kësle totomebë wegeme tutune tlekëfe na Mariame tëbo lowene fa tëtatë. Na bu këme Jisas belë tuju na gali tlole, “O tako ho, bobë keinëba bome wakile etanë iniwa wege bowa no tlë. Ju këme lowene jwa fëyeme elene? Ju bume gali eolë! Bome egaitanë naegleme.” ");
INSERT INTO nce_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kwe Jisas bume gali tolë, “O, Marta, Marta. Ju feilawa wesibime fëyeme tutune elene? ");
INSERT INTO nce_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Maria bu bona kë tafa nëgelobë na kë gëgali nëgelobë wesibi, ebë lale wesibimufe. Këme nëgeme sebo ebë lale wesibime bume hana lëkle nëgetayame. Ju ebë wesibime fwa lowene egletleme.” ");
INSERT INTO nce_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Li olëna, Jisas Gotome gëgali tlelële. Bu Gotome wagëgali tlelële na bubë lowene esogo tlelëtlebë ho li, bume megali tlole, “O tako ho, ju seme Gotome gëgali nëglelëlabë lowenebëme okokwe enona, ëbame Jon bubë lowene esogo mëglelëtlabë home fene okokwe tlome.” ");
INSERT INTO nce_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Na Jisas bume megali tlome, “Sobo Gotome gëgali eglelëlona, kwe megali eglolome. ‘O, Aya, iniwa oneho bu megali samëla, “Ju lalemu.” Sebo metole nanëla, ju onehobë eso home tafa egletënabëme esitëna. ");
INSERT INTO nce_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Iniwa olë, ju seme hi wesibi kë olë nijiwa saelëkefëna. ");
INSERT INTO nce_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ju sebobë tëbo lowene aholokwana sati eletëna, fli enëne seme tëbo lowene kë mëgletënabë lowene aholokwana fene ti nëletëma. Ju seme su mëgëtanabë wesibi elë asa hwiwa enona.’ ” ");
INSERT INTO nce_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Na Jisas bume ita gali tlome, “So mago ho li bu yabena nëgena, na bu klabë kuna bubë yabebë lowa lujuna na gali loglolena, ‘Ju bome hi wesibi eglënëme. ");
INSERT INTO nce_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Bobë yabe kakë mago walisi na bo nëglëlëbë hi wesibi hanane.’ ");
INSERT INTO nce_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Na bubë yabe bume lo mago megali lëgelubaklena, ‘Ju bome asa sosalë etanë. Ino watiji nelë, na bu bobë nëbale labuku mëta wani mebëya. Bo huju hana nëgelëme na jume hi wesibi hana nëglëme.’ Na sobo fëye lowene lalone, kë ho bu habelë lëglemene? ");
INSERT INTO nce_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Bo some gali nolëyo, sobo aholokwane elo, kë ho ebë lo bolijayabë yabemu, kwe bu hana huju lële na bume hi wesibi hana lëlële. Kwe bubë yabe itaita takune lëgelulukwakleme nëgeme na hana kile lotle, na bu këme huju lëgleme na iniwa wesibi bubë yabe kë tole lëgletëmebë mana nalëglëlëme. ");
INSERT INTO nce_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Bo some gali nolëyo, sobo Gotome wesibime takune elokweflome na bu some wesibi lëglëyome. Sobo wesibi hohwi etakefëtelome kwe sobo hwi eglolome. Sobo inome këke elekefëtelome na Goto some ino tika lëgëtatëyome. ");
INSERT INTO nce_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Iniwa oneho Gotome wesibime takune moglokweflana, kwe bu wesibi glo mëglame. Na iniwa oneho wesibi hohwi mëtakefëtëmana kwe bu hwi moglomame. Na iniwa oneho inome këke mëglekefëyana kwe Goto bume ino tika lëgëtatëmeme. ");
INSERT INTO nce_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","So mogo ho li nëbana lëtabe na kë nëba bolijayame mome takune loglolena, kwe bolijaya bume waiye lëglëlemene? Weye. Hanane mu. ");
INSERT INTO nce_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Na bu bolijayame kame takune loglolena, kwe bolijaya bume mlawalë lëglëlemene? Weye. Hanane mu. ");
INSERT INTO nce_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Sobo tëbo lowene itaita esogo elelëkeflo kwe sobo lale wesibi sobobë nëbaleme itaita elëkefëmo. Këme nëgeme sobo melowene egelomemu, ‘Sobobë aya heven life mëta kë tafa lëglebë, bu metole lalële, oneho bume kë takune moglolabë, bubë Amtëtomba, bume lëglëmeme.’ ” ");
INSERT INTO nce_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jisas gali mumu tabo hobë ato mago ahwane hehë tletle. Ahwane wafi kile totle na kë ho mana gëgali tle. Na iniwa oneho hwi motlola na klelego memëtletla. ");
INSERT INTO nce_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","16","Kwe fli metole lamëtla, Jisasme su namogotlame, na bume këme takune motlola, “Jisas ju klelegowa wesibi li lebotane etatëna. Sebo jume melowene nanëgletëyome, ‘Gotobë afutuku ju mëta lëbetëfe.’ ” Na fli ho blalo megali mëtla, “Bu, tëbo alibahobë eso ho, Belsebulbë, afutukuna ahwane këna hehë lëlekefëtëme.” (Belsebulbë li weniji Satan). ");
INSERT INTO nce_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kwe Jisas bubë lowene wahwi tlotëme na bume waflë galina gali tlome, “Li lifate mago enëne, bu bwa bwa lowene mëta tafa mëglana na momogli mëgëtayana kwe bu blalo tafa sle hana mëglame. Na weife mago enëne blalo momogli mëgëtayana kwe bu iniwa tëbo miglitayame. ");
INSERT INTO nce_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Na Satanbë ilawa mago alibaho, bu bwa bwa lowene mëta tafa mëglana na momogli mëgëtayana kwe bu afutuku mëglamene? Weye. Bu tëbo miglitayame. Bo walowene nelë, sobo bome melowene laletëna, ‘Bu ahwaneme Belsebulbë afutukuna hehë lëletëme.’ ");
INSERT INTO nce_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kwe ebë nëgali nëgebë, Belsebul bome lalaitanë na bo ahwane tëbo kë hehë nëgletemëbë, kwe sobobë lowene esogo mëglelëlabë home ya laitamene, ahwane kë hehë mëgletëmabë? Belsebul bu laitamene? Sobobë weife mago enëne bu some melebotane mëtatëyome, sobobë lowene tëbo. ");
INSERT INTO nce_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kwe bo ahwane Gotobë afutukuna hehë nëgletemëna kwe sobo këme lowene elome, Goto bu sobobë eso home watafa lëletëyo. ");
INSERT INTO nce_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Afutuku tabo ho bu wame home boblo wesibi glo lëglena na bubë lo mëta këna mana sei sle lëglëlena kwe bubë iniwa wesibi mëgëbetle sle mëgleme. ");
INSERT INTO nce_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kwe li tako afutuku tabo ho, bu kë tokwëfo afutuku home wameme ligisi tlena na bume wame loglolena na bume boblo logotlena kwe bu kë hobë wame home boblo wesibi bume kë afutuku mëglelëlebë wesibi glo lëgletleme. Na bu kë hobë iniwa wesibi ho flime sa lëtagutëmeme. ");
INSERT INTO nce_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Oneho bome yabe hana mëglenënana, bu bome wame moglonabë enëne. Na ho bome onehome loloko nëgëtëbëme hana mëgaitanana kwe bu onehome lëlakwanena sisile lamotoma.” ");
INSERT INTO nce_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jisas gali tle, “Ahwane tëbo home kile logotlena, kwe kë ahwane, lagu lifewa tuju, tafa labume hohwi nalugutame, haha tafu logotlebëme. Kwe haha tafu life hwi hana loglolena kwe bu këme gali lële, ‘Bo ëbame kë tafa tëgelëbë lowa ita nuguwime.’ ");
INSERT INTO nce_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Na ita luju na lo mehwi lolole, bu wasle motlafe. ");
INSERT INTO nce_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Këme nëgeme, bu luju na tobali ita tële yaife tabo ahwane nëno lule. Na bu mëkakluja na këme tafa mla. Ëbame kwe kë ho bu sogë tëbowa tëtabe kwe tokwafe bu tëbomu lëtabe.” ");
INSERT INTO nce_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisas lebutako onehome gali të tëtatëme na mëse li, kë onehobë mago bume anisasana gali tlole, “Jume kë fu tëgetabë mëse na maba kë hi tëgletëbë mëse, bu fleflesu matle.” ");
INSERT INTO nce_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kwe Jisas gali tle, “Weye. Oneho bu Gotobë gali aholokwane mëglabë na esogo mëglelëlabë bu kwe fleflesu mëglame.” ");
INSERT INTO nce_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Lebutako oneho bu Jisasme loko motokweitlabë, na bume gali tlome, “Oneho kë nalë kë mëtëtabëyabë bu tëbo oneho mu. Bu bome takune motlona, ‘Ju Gotobë afutukuna, klelegowa wesibi li lebotane etatëna, sebo melowene nanëglame, “Ju Gotobë wege fa etatle.” ’ Kwe bu klelegowa wesibi li hana hwi moglolame. Bu jowa wesibiwa hwi moglolame. Wesibi Joname kë fata tëgletlebë wesibiwa hwi moglolame. ");
INSERT INTO nce_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ëtani, Jona bu mo imo mëta aona olë tafa tle na mana mo imo mago huju tle na Ninive lifate mago onehome gali mana të tutatëme. Na Goto, kë klelegowa wesibina, Ninive lifate mago onehome, melebotane latëtatëme, Goto Joname jine tletëme. Na Jona fenene, bo, Gotobë life mago ho, bo tokwafe, onehome ebë nalë kë mëgëtabëyabë, klelegowa wesibi lebotane nëgëtatemëme, melowene namëglame, ‘Goto bome jine tlënë.’ ");
INSERT INTO nce_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Goto, iniwa onehobë gali kë aholokwane loglomebë olë na onehome kë fufu logotomebë olëna, nëgemowe life magobë eso mëse, bu huju egleme, na ebë nalë kë mëgëtabëyabë onehobë tëbo loweneme gëgali egletëmeme. Bu bubë tëbo lowene këme gali egletëmeme. Ëtani kë eso mëse bu kakë lifatemu tafa tuglebë kwe bubë life kile totle na eso ho Solomon belë tisi. Na bubë lale lowene gali gëgali tlelë na aholo bo tëtagutle. Kwe ho li somëta kë tafa lëglebë bubë lowene takomu kwe Solomonbë lowene melëha kwe sobo kë tako lowene hobë gali aholokwane hana elolo. ");
INSERT INTO nce_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Goto, iniwa onehobë gali kë aholokwane loglomebë olë na onehome kë fufu logotomebë olëna, Ninive lifate mago oneho bu huju mëglame, na ebë nalë kë mëgëtabëyabë onehobë tëbo lowene gëgali mëgletëmame. Bu bubë tëbo lowene këme gëgali mëgletëmame. Kë Ninive lifate mago oneho, bu Jonabë gali aholokwane motlolame nëgeme na bubë tëbo lowene aholokwana këme ti mëtla. Kwe ho li somëta kë tafa lëglebë, bubë lowene takomu kwe Jonabë lowene bu melëha kwe sobo kë tako lowene hobë gali aholokwane hana elolo na esogo hana elelëtelo.” ");
INSERT INTO nce_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Na Jisas ita gali tle, “Oneho bu lamo fiji mëtaya na ëho hana mëgëtayame o isekuna hana lamu mëgëtayame. Weye. Bu masei mëta gwa mëtayame. Na oneho lowa mëkaklijana, bubë elulego hwi namoglëyame. ");
INSERT INTO nce_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Jubë naba lamo fenene. Jubë naba lalowa nëgena kwe jubë lowene mago lowene elulego lëgëbetëme na iniwa ato mëta elulego lëgëbetëmemu. Kwe jubë naba tëbo nëgena, kwe jubë lowene mago lowene kilego lëgëbetëme. ");
INSERT INTO nce_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Sobo ululu sle këme egelome. Elulego ju mëta kë lëgelubetëbë asa kilego malëletë. ");
INSERT INTO nce_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Jubë iniwa lowene elulegowa lelubetëna na kilego hana lelubetëna, kwe jubë iniwa lowenebë olëha lelubetëme, lamo elulegoha u eglatëme.” ");
INSERT INTO nce_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisas gali watë tëtatëme, na Farisi ho Jisasme gali tlole, buna hi namëgelome. Na Jisas kë hobë lowa tëkaklutle na tafa tle, hi namëgelome. ");
INSERT INTO nce_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Na kë Farisi ho bu Jisasme mehwi tlole, bu hime tafa tle kwe bu toba tu afina swa hana totome, Gotobë wegeho Moses fene gali tle. Na bu klelego metletle. ");
INSERT INTO nce_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kwe Jisas bume gali tlole, “Sobo Farisi ho, sobo kabona blete ëhou ato elë fwa swa etokefëmo jubë ato fene swa etole. Kwe waholo kë nëgelujebë bu memelë tetëbo wesibi sosolo lameluletëyo. Sobo kë wesibi hana sle etomo. ");
INSERT INTO nce_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Sobo yaya enëne. Ho bu matawa atowa nane blëge blëge totle. Weye. Bu matawa atona waholona mata iniwa blëge blëge totome. ");
INSERT INTO nce_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kwe wesibi, blete ëhou na kabo mëta kë mëgelubebë, sobo wesibi jwa enëneme elëmo, bume egaitamo naegelome. Sobo melë egelona kwe sobobë iniwa wesibi, Gotobë naba li mëta lalowamu mëgëbetëyome. ");
INSERT INTO nce_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Sobo Farisi ho, sobo hai! Sobo tëbo eglitome! Sobo memelë inilu welujuwa welujuwa lalei egotokwefomome na welujuwa mëta gwa etlome na jowa leitabo Gotome elëkeflome. Kwe sobo lale lowenebë na Gotome tole egletelobë aholokwana ti lalekefo. Sobo kë lale lowenebë esogo sle eglelëlona na fli lale lowenebë aholokwana ti jwa egelona kwe sobo lale oneho etabome. ");
INSERT INTO nce_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Sobo Farisi ho, sobo hai! Sobo tëbo eglitome! Sobo lotu lome tafa egelona, sobo metole lalo, onehobë naba li mëta, eso hobë tafa labume tafa egelome. Na sobo oneho këme kë tafa mëglabë lifeku mëta asë egelona, sobo metole lalo, oneho some megali namëglëyome, ‘O letitabo ho. Lale kliji.’ ");
INSERT INTO nce_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Sobo hai! Sobo tëbo eglitome! Sobo matëmatë fenene këha meëho lalo. Oneho lowene jwa, na meweniji lamla, ebë lale lifewa, na bu matëmatë matawa measë mogolame na bu Gotobë naba lime tëbowa mëgëtabëyame. Na sobo kë matëmatë fenene. Oneho bu sobobë tëbo lowene hwi hana moglëtëyome na meweniji namëglame, sobo lale enëne.” ");
INSERT INTO nce_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Na Gotobë galime okokwe toglomebë ho, bu Jisasbë gali aholokwane tle na bume gali tlole, “Tisa, ju kë gali Farisi home gali eglomebë kwe ju seme mata gëglë lalelëna.” ");
INSERT INTO nce_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Na Jisas gali tle, “Sobo Gotobë gali okokwe eglomobë ho. Sobo hai! Sobo tëbo eglitome! Sobo onehome lebutako tafa sle gali okokwe elokwefomo, esogo namëglelëmame, kwe sobo, kë gali esogo mëglelëmabëme, egaitamo hana elo na këbëna bume hobota gwa etatemo. ");
INSERT INTO nce_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Sobo hai! Sobo tëbo eglitome! Sobobë bisemlenino bu Gotobë lowene mago gali të mototokweflabë home wamena tëtëkle mëtëtakefëya. Na sobo kë hobë matëmatë negli etokwefëmetemo. ");
INSERT INTO nce_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Sobo matëmatë negli lakalena, onehome melebotane etatemo, sobobë bisemlenibë lakaleme helawawa laletemo. Bu Gotobë lowene mago gali të mototokweflabë home wamena tëtëkle lamëtëtakefëya. ");
INSERT INTO nce_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Goto këbë hwi tlolena na bubë lale lowenena megali tle, ‘Bo bobë lowene mago gali të motokweflabë home na bobë gali tëme jine mëglëmabë home jine nëglëmëme, na bu flime wame ijiwa moglomame na flime mogo nalë tëtëkle mëtayame.’ ");
INSERT INTO nce_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ëtanimu na mana ekë lëbe bu Gotobë lowene mago gali të mototokweflabë home mogo nalë tëtëkle mëtëtagijayame nëgeme, na Goto, bu ebë olëna kë mëtabëyabë onehome këme tëbo logotomeme. ");
INSERT INTO nce_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Bu Gotobë lowene mago gali të mototokweflabë home mogo nalë tëtëkle lamëtëtagijaya. Bu ëtani Abel mëta afina oto mutula, na flime mata mogo nalë tëtëkle lamëtëtagijaya na Sekaraia belë mana fwa tëkaki na bume mata mogo nalë tëkle mototla. Sekaraia bu, Gotome, wesibi kë mëta ahojume ahojume melekefëtlabë masei jelë, na Gotobë lo jelë, kë afloko mëta tëtabe na bume mana mogo nalë tëkle motlola. Na bo some gali nolëyo, ëtanifu oneho bu Gotobë lowene mago gali të mototokweflabë home mogo nalë tëtëkle mëtëtagijayame nëgeme, na Goto bu ebë olëna kë mëtabëyabë onehome, këme tëbo logotomeme. ");
INSERT INTO nce_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Sobo Gotobë galime okokwe eglomobë ho. Sobo hai! Sobo tëbo eglitome! Sobo, Gotome kë lowene mëgletlabë lobë inoha tei tiji elo. Na sobowa kë ino hana tika etlome na hana ekaklujome, Gotobë lowene nafa egëtatelobëme. Hanane. Na oneho bu kë lowa mëkaklujame fene, Gotobë lale lowene fa namogotlame kwe sobo lëkleha latokwefomo.” ");
INSERT INTO nce_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Na kwe Jisas kë lo mago toho tëkake. Na tokwafe Gotobë galime okokwe moglomabë ho na Farisi ho bume tëboijiwamu lamëtletla na memelë tëtakunebëme takune motlola. ");
INSERT INTO nce_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Bume melëme fene sosogëna motlola, tëbo galina tafu lëtatëme nawa na bume mana enisusu mletlame na mogo nalë mana tëkle motlame. ");
INSERT INTO nce_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Feilawa onehomu loko mëtlelëya. Na bu ke mëtlame nëgeme na fli onehome jubame fëfe fëfeha mëtlelogwaya. Na Jisas bubë lowene esogo mëglelëtlabë home afina gali të tëtatëme, “Sobo Farisi hobë bletë nage sëse wesibime ululu sle saelo. Bo kë gali nëgelëbëye, bubë sosogëna lowenebëme gali nelë. Bubë sosogëna lowenebë, sobobë lowene mëta takowa lëbetëyolime. Bo këme gali nelë, sobo ululu sle saelo. ");
INSERT INTO nce_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Iniwa wesibi oneho ëho kë motomabë, kwe Goto olafa lotometëmeme na oneho bu hwi molomame. ");
INSERT INTO nce_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Na iniwa gali sobo hwelutuwa kë gëgali egelobë, kwe tokwafe ho li kë gali lifeku mëta onehobë aholo li mëta të logotleme.” ");
INSERT INTO nce_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Na Jisas ita gali tlome, “O bobë yabenino, bo some gali nolëyo. Sobo home asa uli eletemo. Weye. Ho some mogo nalë tëke mëglëyome kwe bu some ita hana tëbo mëgëtome. ");
INSERT INTO nce_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Bo some megali sle nëlëyo. Sobo Gotome fwa uli egletelome. Goto bu lalowa, home mogo nalë tëbo logotleme na bubë afutukuna kë home hel lifewa lalowa tuku lëgleme. Ho kwe melë hana mogotlame. Bo some gali sle nëlëyo, sobo Gotome fwa uli egletelomemu. ");
INSERT INTO nce_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Fli tokwëtokwë fole, ho melowene lamla, ebë lale wesibi nane, ebë tëboha wesibi tekwe nëge. Kwe, Goto bu kë tokwëtokwë foleme aholokwana hana ti lëletëme. Bu tafa lëlelëme na ululu sle lalotome. ");
INSERT INTO nce_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Na habenuju eslehuba tabëi sobobë kë nëgebë Goto walowene sle lëletëme na iniwa wesibi mata walowene sle lëletëme. Këme nëgeme bo some gali nolëyo, iniwa wesibi some kë fata mëgletëyobë, sobo uli asa eletemo. Sobo walowene elo, tokwëtokwë fole bu tokwëfo wesibiha kwe Goto bu kë foleme mana tafa lëlelëme na ululu sle lalotome. Kwe sobowe, sobo tako wesibi na Goto bu some tako tolemu lalëletëyo na itaita metafa lëglelëkefëyome.” ");
INSERT INTO nce_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Na Jisas ita gali tle, “Bo some gali nolëyo, ho bu onehome megali loglomena, ‘Bo Jisasme lowene sle nëgletelëbë ho.’ Kwe bo, Gotobë life mago ho, bo Gotobë enselbë li mëta megali noglomëme, ‘Bu bome lowene sle lëgletenëbë ho.’ ");
INSERT INTO nce_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Na ho bu onehobë naba li mëta bome lowene lëgletenëbëme able lëglena, kwe tokwafe bo Gotobë enselbë li mëta kë home kofaya able nëgletelëme. ");
INSERT INTO nce_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ho bu bome, Gotobë life mago home tëbo gali loglonëna kwe Goto bubë kë tëbo lowene aholokwana ti lëgletleme. Kwe ho bu Gotobë Amtëtombame klëë gali loglolena, kwe Goto bubë tëbo lowene aholokwana hana ti lëgletlememu. ");
INSERT INTO nce_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Bu some lotu lowa sobobë tëbo lowene gëgalime mëglelujona. O gavman ho o tatako letitabo ho belë sobobë tëbo lowene gëgalime mëglelujona, kwe sobo këme metutune asa elo, ‘Sebo bubë gali habë tafu nëtatëmamene? Sebo habë gali nëglamene?’ Weye. ");
INSERT INTO nce_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kë olëna, Gotobë Amtëtomba, sobo bume këna tafu egëtatemobë gali lebotane lëgëtatëyome.” ");
INSERT INTO nce_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Na ho li, kë feilawa onehona mëtëtabëya na bu Jisasme gali tlole, “Tisa, bobë aya wagli lële na bo metole nanelë, ju afame gali elole, iniwa wesibi aya kë hune lëglebë, fulelë lëleme na fli bome lëlënëme.” ");
INSERT INTO nce_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Kwe Jisas bume gali tlole, “Ju bome kë galime fëyeme gali enonëne? Ho bome gali aholokwane moglomabë home hana aniji motlona, na bo kë wesibi some hana sa nëgëtatëyome. Weye. Hanane.” ");
INSERT INTO nce_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Na bu onehome megali tlome, “Sobo ululu sle saelo, feilawa wesibi mëmaune eglëmolime. Sobo feilawa wesibina nëgebë kwe kë wesibi kwe some lale tafame hana mëgaitomemu.” ");
INSERT INTO nce_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Na Jisas waflë galime gali tlome, “Baliti musuna hobë nuju mëta, feilawa hi wesibi mëbekefëtle. ");
INSERT INTO nce_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Na kwe kë ho melowene tle, ‘Bobë hi wesibi loloko lo wake melefe na bo li lo hananefe, bobë fli hi wesibi këme gogwa nanëgelëme. Bo habelë nëgelëmene?’ ");
INSERT INTO nce_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Na bu gali tle, ‘Ai, ta bo melë nëgelëme. Bobë hëno tokwëtokwë hi wesibi loloko lo yayei notomeme na fli tatako wesibi loloko lo gigliji nelëme na bobë hi wesibi na fli wesibi kë mëta loloko nanëgëtëme. ");
INSERT INTO nce_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Na bo bowa melowene nelëme, “Bo feilawa wesibina hofe. Bobë lale wesibi feilawa tlibutu niji mëbetenëfe. Ta bo tafawa manelë. Bo tafawa nëlekefëme na fleflesuna hi nëlekefëme.” ’ ");
INSERT INTO nce_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kwe Goto bume megali latlole, ‘Ju yaya homu. Ebë klabëna ju gli egleme. Na iniwa wesibi ju kë loloko egëtabë yalë glo lëgletëmene?’ ” ");
INSERT INTO nce_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Na Jisas gali tle, “Na wesibi kë home fenene fata tletle, ho li Gotome lowene hana lëgletlena na bubë feilawa lalale wesibi loloko loloko lëgëtana, na kë wesibina fli onehome lëgaitame jwa lëglena kwe këha lakale Gotobë naba lime sle hana lëletle.” ");
INSERT INTO nce_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Na kwe Jisas bubë lowene esogo mëglelëtlabë home gali tlome, “Sobo ebë galibë lowene sle eletelo. Na sobobë tafa lale lëgëbetëyobëme tutune asa elo na megali asa elo, ‘Sebo fëye wesibi hi nëglamene? Sebo ëho hamago glo nëglamene?’ ");
INSERT INTO nce_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Hi wesibi na ëho bu some lale tafame hana mëgaitome. Jubë lale tafa ebë tako wesibi, kwe hi wesibi ebë tokwëfo wesibi. Na jubë ato ebë tako wesibi, kwe ëho ebë tokwëfo wesibi. ");
INSERT INTO nce_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Sobo abagou foleme lowene eletemo. Bu hi wesibi hana tobalo mële na bu hi wesibi loloko hana mëta. Na bu hi wesibi loloko lo hanane. Kwe Goto bume hi wesibi lëlëkefëme. Kë fole kwe bu tokwëfo wesibiha kwe sobo oneho tako wesibimu na Goto bu some mata hi wesibi lëglëyome. ");
INSERT INTO nce_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Na ho bu ebë life mëta kë tafa lëglebë olëme tutune lëglena kwe bubë olë lalowa kikli lëgetokwaklemene? Weye. Hanane mu. ");
INSERT INTO nce_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Sobo ebëha tokwëfo wesibi melë hana egelona kwe sobo fli wesibime blawa fëyeme tutune elone? ");
INSERT INTO nce_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Sobo lale ti tahweji lowene eletemo. Bu habëtabo foke melene? Bu këkë hana mëgleme na bubë negli wesibi hana susu motomeme. Kwe bo some gali nolëyo, ëtani eso ho Solomon bu lale lale negli wesibi gëgelo totokwefëme. Kwe bubë negli wesibi bu kwe sogë lalowaha, kwe lale ti tahweji bu lalemu mëbe. ");
INSERT INTO nce_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Sobo lifeku mago agosaba tahwejime lowene eletemo. Lifeku mago agosaba tahweji lifekume ëje kë foke mëglebë, ho uniji wege mëglame na ahoju fiji mëtayame. Kwe Goto bu këha lifeku mago agosaba tahwejime negli sle lalotokwefëme. Këme nëgeme sobo lowene sle egletelome, Goto some mata ëhona negli lëgëtome. Sobo Gotome tokwëfo lowene slewa laletelo. ");
INSERT INTO nce_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Goto some tafa lëglelëyome. Këme nëgeme sobo hi wesibime metutune asa elo. Sebo fëye wesibi hi nëglamene o sebo fëye tu hi nëglamene? ");
INSERT INTO nce_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Gotome lowene jwa mëgletlabë oneho bu kë wesibime feilawa tutune melekefëya. Kwe iniwa wesibi sobo kë tutune egletemobë, sobobë blijaya këbëme walowene lëletëyo. ");
INSERT INTO nce_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Sobo wesibime tutune asa elo. Weye. Sobo Gotome fwa melowene eglekefëtelome, ‘Bu sebobë eso ho lëtabetënafe, na bubë tolewa esogo eglelëtelobëme lowene elome. Na kwe bu hi wesibina ëhona some mata lëglëkefëyome.’ ” ");
INSERT INTO nce_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Sobo bobë enëne tële. Bo some kë tafa nëglelëyobë, ho sipsip kleli fene lëlëme. Sobo uli asa elo. Sobobë blijaya bu wafi gali tle, bu sobobë eso home tafa lëgletëyome na sobo buna eso hoha onehome tafa elelëmome. ");
INSERT INTO nce_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Sobobë iniwa wesibi balitina hihijika elome. Na kë baliti glo elome na wesibi jwa onehome aitamome. Sobo melë egelona, kwe sobo unaunalëme tafa wesibi glo egelome, na sobo heven life mëta lale wesibi loloko egotome. Tokwafe sobo heven life mëta këha wesibi hwi eglomome. Heven life mago wesibi, flawei hana mëgleme. Na ho toklime glo hana mëglame, na lahwë hana sisile mogotomeme na gu hana mëglelëme. ");
INSERT INTO nce_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sobobë wesibi fëye mëta mëbetëyowe, sobobë lowene mata kë mëta lugubetëyome.” ");
INSERT INTO nce_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Sobo iniwa wesibi sagli elëlome na walena satafa elo. Sobo ëho gëgelo etomome na lamo fifiji etomome na këna tafa elome. ");
INSERT INTO nce_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Sobo këha metafa egelome, ho bubë eso home, bubë tako salë mago ligisibëme fene hwi mletla. Bubë eso ho bu ino mëta këke lëglena kwe bu hokweinawa tika mëtatlame. ");
INSERT INTO nce_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Na bu ligisina na mehwi lëglena, bubë wege ho bu ni hana mëgebëyana, kwe kë wege ho bu fleflesu matla. Bo some nëgali gali nanolëyo, kë eso ho bu wege ëho gëgelo lotomeme, na bubë wege home gali lolomeme, ‘Masei mëta tafa elome.’ Na buwa hi wesibi bume lëlëmeme. ");
INSERT INTO nce_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Na bu klabë kuna o fole olëna ligisina na mehwi lëglena, bubë wege ho bu ni hana mëgebëyana, kwe kë wege ho bu fleflesu matla. ");
INSERT INTO nce_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Sobo ebë wesibi lowene sle eletemome. Ho bu tokli ho ligisibë olë lowene lëgletlena, kwe bu kë tokli home lëkle logotleme na bu lowa hana lëkaklume. ");
INSERT INTO nce_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Sobo mata sagli elëlome na mana walena satafa elo. Bo këna nigisibë olë sobo lowene hana eletelo. Sobo melowene jwa elome, ‘Bu ebë olëna hana ligisime, kwe bo, Gotobë life mago ho, kë olëna mana nigisime.’ ” ");
INSERT INTO nce_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita Jisasme metakune tlole, “Tako Ho, ebë waflë gali ju seme fwa gali enonane o iniwa onehoname gali elome?” ");
INSERT INTO nce_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Na bu gali tafu tëtatle, “Bo iniwa lale wege kë fa mogotlabë na lale lowenena kë mëtabëyabë wege home gali nëlëyo. Eso ho bu këha lale wege home meaniji logloleme, bubë fli wege home tafa nalëglelëmeme na hi wesibi bume nalëglëmeme, eso ho kë gali toglolebë olë mëta. ");
INSERT INTO nce_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Eso ho ligisina na bubë wege home mehwi loglolena, bubë lale wege mana fa lotokwefëtlefe. Kwe kë wege ho bu fleflesu malële. ");
INSERT INTO nce_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Bo some nëgali nanëlëyo. Eso ho bu këha lale wege home meaniji lëglëyome, bubë iniwa wesibi tafa nalëglelëmetleme. ");
INSERT INTO nce_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kwe kë wege ho bu melowene lëglena, ‘Bobë eso ho hokweinawa hana ligisimefe,’ na bu fli wege onehome tëtëke lëglena, na bu feilawa hi wesibi na biaha wesibi hi lëglena, ");
INSERT INTO nce_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","na kwe bubë eso ho ligisibë olë lowene sle jwa lëletleme na bu lili sloslowa lëleme na bubë eso ho mana lisime. Na bu kë wege home latëbowamu logotleme, na Gotome lowene sle jwa kë mëgletlabë enëne belë jine lelëkakleme. ");
INSERT INTO nce_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Wege ho bu bubë eso hobë tole lowene lëgletlena kwe bu sagli hana lëgletlena na bubë eso hobë tole hana esogo lëglelëtlena kwe bubë eso ho bume anisasanamu feilawamu lola lëgëbetëfaleme. ");
INSERT INTO nce_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kwe wegeho bubë eso hobë kë tole lëgletlebë lowene, lowene sle hana lëgletlena na bu wege sle jwa lëleme kwe bubë eso ho bume tokwëfo tëklewa loglotleme. Goto onehome feilawa lowene lëglëmena kwe tokwafe bume takune loglomeme, ‘Bo some kë tëglëyobë lowenena, feilawa wege fa totlone?’ ” ");
INSERT INTO nce_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jisas ita gali tle, “Bo kë nigisibëye, bo Gotobë wame ahojuha ebë lifekuwa tuku nanëgelëme nisi, iniwa tëbo lowene na tëbo wesibi temu namëgleme. Na bo metole nanelë, Gotobë wame bume ahojuha hokweinawa u nalëgletleme. ");
INSERT INTO nce_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tokwafe feilawa elili na gli bome lamu lëgëtanëme, tu mëta home fene baptais melelëma na bo tako tutune këme nelë. Bo metole nanelë, kë wesibi bome kë fata lëgletenëbë bu hokweinawa tli nalëkaketenëme. ");
INSERT INTO nce_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Sobo bome melowene laletënane, ‘Bo ebë lifeku mago wame sleme tisine?’ Weye. Hanane mu. Bo kë tigisibë, onehome fu nanogotomëme tisi. Oneho bu bobë gali aholokwane mëglana na fu fu mlame. Fli bobë gali lowene sle mletlabë na fli bobë gali lowene sle hana mletlabë. ");
INSERT INTO nce_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ebë olëna na tokwafe, tobalimalë ilawa mago ho jowa lo mëta kë tafa mëglabë, bu bobë lowene esogo mëglelëlabëme momata mëlame na fu fu melelogwayame. Na aomalë bu tlemalëme wame moglomame na tlemalë bu aomalëme wame moglomome. ");
INSERT INTO nce_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bu bobë lowene esogo mëglelëlabëme momata melelogwayame na fufu melelogwayame. Na bolijayani bowenenime wame moglomame na boweneni bolijayanime wame moglomame. Na botamenino bokoninome wame moglomame na bokonino botameninome wame moglomame. Na bolujawani bu boweneninobë noninome wame moglomame na boweneninobë nonino bolujawanime wame moglomame.” ");
INSERT INTO nce_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Na Jisas bu kë feilawa onehome na gali tlome, “Sobo matafa kë tëbo lëtatlebë hwi elolome na megali lalekefo, ‘Tu lëgetomefe.’ Na tu leto. ");
INSERT INTO nce_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na sobo kliji naba mehwi egowelëkaklona, yemeha fata eola kwe megali lalekefo, ‘Eli tako kliji lëgemolemefe.’ Na kliji bu tako lëgemolelële. ");
INSERT INTO nce_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Sobo sosogëna enëne. Sobo klijina matafana hwi elomo na sobo melowene eletemome, ‘Wesibi tokwafe fata mëglemefe.’ Sobo këha wesibi kwe walowene eletemo kwe ëje kë fata mëglebë wesibibë waiyo sobo hwi sle jwa fëyeme elëmone?” ");
INSERT INTO nce_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Jisas bume ita gali tlome, “Sobo lale lowene kë egelobë loweneme lowene sle jwa fëyeme eletelone?” ");
INSERT INTO nce_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ho li, bu jume onehobë gali aholokwane loglomebë ho belë lëgloulina na sobo alëgeme mana asë elome kwe ju kë hobë lowene alëgeme yafe sle etatleme. Ju sle hana etatlena kwe bu jume onehobë gali aholokwane loglomebë ho belë lëgloulime na bu jume plismanë belë lëloulime na bu jume kalabusu lowa tuku lëleme. ");
INSERT INTO nce_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Bo jume gali sle nolë, jume këniji kë aniji moglotëyobë balitina sle hana egotlena, kwe ju kalabusu lo mëta mana tafa egleme. ");
INSERT INTO nce_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jisas gali wafi të tëtatëme na fli enëne bu belë mitisiya na megali motlola, “Galili provins mago ho bu Gotome kleli afabo ahojume mëtletla. Na eso ho Pailat bubë wame home boblo mogotomabë enëneme jine tlëme, kë enëneme mogo nalë tëtëkle namëgëtayame. Bu Gotome kleli afabo mana ahojume mëtlekefëtlabëë, na bume mogo nalë tëtëkle mëtëtaya.” ");
INSERT INTO nce_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Na Jisas bume gali tlome, “Sobo melowene lalone, ‘Kë Galili provins mago enënebë tëbo lowene bu takomu lëbetëme na kwe fli Galili provins mago enënebë tëbo lowene bu kwe tokwëfoha lëbetëme na kë tëbo wesibi bume këme fata lëletëme?’ Sobo ebë loweneme melowene lalone, hee? ");
INSERT INTO nce_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Weye. Kë melë hanane mu. Bo some gali sle nëlëyo, sobo tëbo lowene aholokwana ti hana egelona, kwe kë enëneme fene tëbo mototoma, këha wesibi some fata lëgletëyome. ");
INSERT INTO nce_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Na sobo ita lowene elo, ëtani, Siloam lifeku magobë akolalo bu mogo nalë 18 home tëtafu tle. Na sobo melowene lalone? ‘Kë enënebë tëbo lowene takomu lëbetëme na kwe fli Jerusalem lifate enënebë tëbo lowene bu kwe tokwëfoha lëbetëme na kë tëbo wesibi bume këme fata lëletëme.’ Sobo melowene lalone? ");
INSERT INTO nce_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Weye. Kë melë hanane mu. Bo some gali sle nëlëyo, sobo tëbo lowene aholokwana ti hana egelona, kwe kë enëneme fene tëbo mototoma, këha wesibi some fata lëgletëyome.” ");
INSERT INTO nce_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Na Jisas waflë gali metë tëtatëme. “Ho bu niji olo bubë wain taba liji nuju mëta lë lotle. Na kë niji bu sigli lële. Na kë ho itaita lisi, niji hwi naloglokwefleme. Kwe niji logowalë hana lële. ");
INSERT INTO nce_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Këme nëgeme bubë nuju tafa lëglelëtlebë home gali lolole, ‘Ju aholo bo eta. Aona tlibutu kë mutujubë bo ebë niji yafe hwi tlokwakikeflë, kwe bu logowalë hana lële. Te ebë niji mana tëka etokwakle. Ebë flëkebë ëflëbo yawe loglotlelime.’ ");
INSERT INTO nce_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kwe bubë nuju kë tafa lëglelëtlebë home gali lolole, ‘Eso ho. Awi. Ebë tlibutuna kwe malilibe. Bo waiyo mago flëke yefi nëletelëme na ahoju somalëfa u nëletelëme. ");
INSERT INTO nce_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Bo melë nogotlëna kwe bo melowene nanelë, Li tlibutuna kwe logowalëme. Kë tlibutuna logowalë jwa lëglena na kwe lalowa tëka nogotlëme.’ ” ");
INSERT INTO nce_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tafawa olëna, Jisas onehome bubë lotu lo mëta gali okokwe tlome. ");
INSERT INTO nce_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Na ahwane kë tëbo tëtamëbë mëse këme telutabe. Na kë ahwane bume 18 tlibutu këniji tëbo tëtakefëme nëgeme na kë mësebë amlebo nemoha busu këme tlatë na lale tiglibe hana tle. ");
INSERT INTO nce_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Na Jisas bume hwi telokwakë na gali telokwakë bu belë egisi tle naegleme. Na bu tisi tlee na gali tolë, “Bo jubë tëbo wasle nëtatë.” ");
INSERT INTO nce_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Na toba bubë ato mëta gwa totatë na bu tlibe sle tle, na Gotome fleflesu tletle na bibita totle. ");
INSERT INTO nce_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kwe lotu lo hwi loglokweflebë eso ho bu Jisasme këme wame tlole, bu tafawa olëna, kë mëseme sle tëgëtamëme nëgeme. Këme nëgeme bu onehome gali tlome, “Tobali ita jowa olë ebë wege olë lëbe. Sobo metole lalo, ho sobobë ato sle lëtatëyome kwe sobo kë wege olëna egisijome. Kwe sobo tafawa olëna home ato sleme asa takune elolo. Matëbe.” ");
INSERT INTO nce_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Na kwe Jisas bubë gali tafu tëtatle, “Sobo sosogëna enëne. Sobobë gëgali na sobobë lowene bwa bwa mëbetëyo. Sobo megali elo, ‘Tafawa olëna asa wege elo.’ Kwe sobo tafawa olëna, bulmakau kleli lowa kaiselo eyeukefo, na sobobë bulmakau kleli na donki kleli tu hime kaiselo elelukwefëmo. ");
INSERT INTO nce_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Sobo tafawa olëna, bulmakau kleli itaita kaiselo aitakefëmo kwe sobo bome fëyeme gali enonane, tafawa olëna kë mëseme asa sle eta? Sobo hwi elo, ebë mëse kë nëgebëye, Abrahambë afenëbo. Na Satan bume kë yage tëgetabë 18 tlibutu këniji yage tle. Këme nëgeme bo kë tëbo, tafawa olëna lalowa sle nëtatëme.” ");
INSERT INTO nce_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Na bume kë wame motlolabë ho, kë gali aholokwane motlola na tiniji na hwë memëtletla. Kwe iniwa oneho bu iniwa wesibi melë kë totomebëme fleflesu mëtletla. ");
INSERT INTO nce_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Na Jisas ita gali tlome, “Goto onehobë eso home kë tafa lëgletëmebë, ebë fëyeha wesibine? Bo some ebë wesibime waflë gali nolëyo. ");
INSERT INTO nce_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Goto bu onehobë eso home kë tafa lëgletëmebë, bu atowai liji fenene. Atowai liji bu tokwëtokwë mu. Kwe ho bu kë tokwëtokwë atowai liji flëke mëta sike lële. Na bu hulu mële na tatako tiwa milibe na iniwa fole bubë tikefo mëta, lo gigliji mëkaki.” ");
INSERT INTO nce_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","Na Jisas ita gali tlome, “Goto bu onehobë eso home kë tafa lëgletëmebë ebë fëyeha wesibine? Bo some ebë wesibime waflë gali nolëyo. Goto bu onehobë eso home kë tafa lëgletëmebë bu bletë nage këna sëse mëglebë wesibi fenene. Mëse, bletë nage këna sëse mëglebë wesibi tëlewa glo ele na lebutako bletë nage obo mëta u etëkake na këna afulu ele. Na bu iniwa flële lëbebokwake na kë bletë nage iniwa feilawa sëse mele.” ");
INSERT INTO nce_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisas Jerusalem lifate alëge elë tuju. Na bu li life li life onehome okokwe tlagume. ");
INSERT INTO nce_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Na ho li bume takune tlole, “Tako ho, tokwafe Goto jowa jowa onehome nëno lëglemene o feilawa onehome nëno lëgleme?” Na Jisas gali tlome, ");
INSERT INTO nce_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Sobo ino tokwëfo elëme ekaklujome saafutuku elo. Bo some gali nolëyo, feilawa oneho bu heven lifewa mëkaklujame fene, kwe hanane. ");
INSERT INTO nce_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tokwafe, lo bolijaya ho, bu huju lëleme na ino tiji lëleme. Na sobo kë ino ëfo li mëta elibome na ino mëta këke eletelome na mewe elome, ‘Tako ho, ino seme tika etatëna.’ Kwe bu some metafu lëtatëyome, ‘Bo some lowene hana nëletëyo, sobo hamagobë enënene?’ ");
INSERT INTO nce_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Na sobo bume megali eglolome, ‘Sebo juna hi tlekefëya na ju sebobë lifeku mëta seme okokwe latlona.’ ");
INSERT INTO nce_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kwe bu some megali loglëyome, ‘Bo some lowene hana nëletëyomu, sobo hamagobëne? Sobo tëbo lowene esogo eglelëlobë enëne. Sobo hai! Sobo bo mago eyeu.’ ");
INSERT INTO nce_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Bu some hehë mëgletëyome na sobo Abraham Aisak Jekopna iniwa Gotobë lowene mago gali të mototokweflabë home mehwi elokwakëmome, bu Goto onehobë eso home kë tafa lëgletëmebë lifate mëta mëtabëya. Kwe sobowa mëglëbo elë egëtabome. Na sobo tako ye eglekefome na enino këkë etokwefomome. ");
INSERT INTO nce_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Na iniwa life mago oneho, Goto onehobë eso home kë tafa lëgletëmebë lifewa migisiyame. Bu nogowelë mago na notowelë mago na nëgetujuwelë mago na nëgemowelë mago migisiyame. Na bu kë life mëta tafa mlame na hi melekefëyame. ");
INSERT INTO nce_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Sobo aholokwane elo. Fli enëne bu ebë olëna letitabo home kë tafa mëglabë, bu tokwafe kë olëna atwati ho tafa mëglame. Na fli enëne bu ebë olëna atwati home kë tafa mëglabë bu tokwafe kë olëna letitabo ho tafa mëglame.” ");
INSERT INTO nce_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Na kë nalë, Farisi ho fli mitisitla na Jisasme gali motlola, “Eso ho Herot jume mogo nalë tëkeme wahau lëletë. Ju emago li lifewa ejumo.” ");
INSERT INTO nce_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Na Jisas bume gali tlome, “Sobo kë kulekule home megali ejuwelëlome, ‘Ebë olë na uniji olë bo ahwane, hobë ato mago awi hehë nëletemë na onehobë ato elili awi sle sle notometemëme na aona olëbëna bobë wege mana yawe noglolëme.’ ");
INSERT INTO nce_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kwe eli olë uniji olë kë olë bo Jerusalem lifatewa nuguwi nuguwiwa awi nelë. Melëme nëgeme, Gotobë lowene mago gali të lotokweflebë ho, li lifate meta mogo nalë hana tëkle mogotlame. Weye. Bubë ko Jerusalem lifate mëta fwa lugujutleme. ");
INSERT INTO nce_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O Jerusalem lifate mago enëne. Masiwafe. Sobo Gotobë lowene mago gali të mototokweflabë home mogo nalë tëtëkle etakefëyo na Goto kë jine tëglëkefëmebë home anijina mogo nalë metëtëkle etakefëyo. Bo some sago nanëgëtome fene, tëbo wesibi some tëbo lëgëtolime, tamo kekelo bubë nëbale fene sago etome na hwaklona lamu etome. Kwe sobo tole hana elo. ");
INSERT INTO nce_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Sobo aholokwane elo. Goto some hune lëgleme na ita hana lëgaitome. Bo some megali sle nëlëyo. Sobo bome eli hana hwi egloname. Sobo afina gali egelona, ‘Gotobë tolëna afutukuna kë ligisibë ho, Goto bume lëgaitalëme.’ Na sobo bome mana ita hwi enoname.” ");
INSERT INTO nce_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tafawa olëna Jisas, Farisi hobë eso hobë lowa hime tuju. Bu kë lo mëta tafa tle, na buna kë hi mëtlabë enëne bume mana hwi mëtëbelëkakla, eli bu habelë lëglemene? Bu tëbo lowene fa logotlemene? ");
INSERT INTO nce_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Na ato sëse sëse tabo ho Jisas belë tisi tle. ");
INSERT INTO nce_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Na Jisas kë home hwi tlole na bu Gotobë galime okokwe moglomabë ho na Farisi honame takune tlome, “Sebobë anebo gali habelë lëgëbetëna lalëlene? Sebo tëbo atona home, tafawa olëna, lalowa sle nogotlamene o matëbe?” ");
INSERT INTO nce_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kwe bu mogweliha tafawa mëtla. Këme nëgeme bu kë tëbo atona home no tlële na sle totle na jine tlële. ");
INSERT INTO nce_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Na bume gali tlome, “Sobobë nëba o bulmakau kleli tafawa olëna yefi fulujuwa mëtetigotëyona kwe sobo tafawa egelomene? Weye, sobo glo egotolome.” ");
INSERT INTO nce_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kwe bu kë gali tafu hana mëtëtatla. ");
INSERT INTO nce_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Na Jisas hime kë mitisiyabë enënebëme hwi tlagume. Fliye eso enënebë tafa labume tafa motokouja. Këme nëgeme bu waflë gali këme të tëtatëme. Bu megali latle, ");
INSERT INTO nce_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ho bu mëse sei lëglebë olëbëme, fleflesu hi wesibi hime gali lëglena na ju kë hi wesibi hime egujutlena kwe ju eso hobë tafa labume asa tafa eoule. Ju melë eglena na bu kë tafa labu li eso home wafi aniji loglotlena, ");
INSERT INTO nce_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","kwe jume kë hi wesibi hime kë gali loglëbë ho bu jume gali loglëme, ‘Ju ebë tafa labu ebë eso home kile eletle.’ Na ju tako tiniji egleme na ju atwati hobë tafa labume tafa eoule. ");
INSERT INTO nce_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ho bu jume hi wesibi hime gali loglëna na ju kë hi wesibi hime egujuna kwe ju atwati hobë tafa labume tafa eouleme. Ju melë eglena kwe jume hi wesibi hime kë gali loglëbë ho bu jume gali loglëme, ‘Yabe, ju eso hobë tafa labu mëta tafa eoule.’ Bu jume melë lëgëtana kwe juna kë hi egelobë oneho jume melowene mëgletëyome, ‘Bu lale eso hofe.’ ");
INSERT INTO nce_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ho bu megali lëglena, ‘Bo tako afutukuna eso hofe,’ kwe Goto bume megali logloleme, ‘Hanane ju atwati homu.’ Kwe ho bu megali lëglena, ‘Bo kwe, bo atwati hofe,’ kwe Goto bume megali logloleme, ‘Ju eso ho fe.’ ” ");
INSERT INTO nce_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jisas bume hi wesibi hime kë gali loglolebë home gali tlole, “Ju tako salë hi wesibi sagli eglëlena, kwe ju yabe enëneme na blijahanime na weife mago enëneme, na weife life mago feilawa balitina kë nëgebë enëneme migisitëyome asa gali elome. Ju melë eglena kwe bu tokwafe jume kofaya hime gali mëglëyome. ");
INSERT INTO nce_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Weye. Këha melë asa ele. Matëbe. Ju tako salë hi wesibi sagli eglëlena, kwe ju wesibi jwa enëneme na yage tabo enëneme na naba titiki tabo enëneme gali elagumeme, kë salë hi wesibi hime migisiya namëglame. ");
INSERT INTO nce_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Këha enëne jume kofaya hi mëglelëyobëme hana gali moglëyome. Këme nëgeme ju safleflesu ele. Tokwafe, Goto bu lale enëneme matëmatë life mago huhuju logotomebë olëna, kwe bu wesibi jume kofayame lëglëme.” ");
INSERT INTO nce_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Na ho li, Jisas buna kë hi mëtlabë, kë gali aholokwane tle na Jisasme gali tlole, “Tokwafe, Goto, onehobë eso home kë tafa lëgletëmebë life mëta kë hi mëglabë oneho, bu fleflesu mëglame.” ");
INSERT INTO nce_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Kwe Jisas mewaflë gali tle, “Ho li tako salë hi wesibi sagli lëglëleme. Na bu feilawa onehome gali tuku tëkoutëme, tokwafe migisitla namëglame. ");
INSERT INTO nce_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Na tokwafe kë tako salë hi wesibi olë fata tle. Na bu bubë wege home jine tlële ëbame kë gali toglomebë onehome, megali nalugujelëmeme, ‘Sobo esijomo. Olë ekë fata lëleo. Salë hi wesibi iniwa wasagli lëlële.’ ");
INSERT INTO nce_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kwe iniwa bu megali mëtla, ‘Sebo hana nigisiyamo.’ Ho li gali tle, ‘Bo balitina nuju wahihijika telë na bo kë nuju hwime nuguwimo. Masiwafe, bo kë salëme hana nigisime.’ ");
INSERT INTO nce_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Na ho li gali tle, ‘Bo jowafe we bulmakau kleli balitina waglo telë na bo bubë afutuku hwime nuguwitemëmefe. Masiwafe, bo kë salëme hana nigisime.’ ");
INSERT INTO nce_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Na ho li gali tle, ‘Bo mëse tokwafe sei nëlëfe na këme nëgeme kë salëme hana nigisime.’ ");
INSERT INTO nce_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Na kwe kë wege ho, kë enënebë gali bubë eso home gali tujuwelële. Na bu kë gali aholokwane tle na tako enisusu metle na bubë wege home gali tlole, ‘Ju hokweinawa kë lifatebë tokwëtokwë alëge elë na tatako alëge elë eiju. Na ju wesibi jwa enëneme na tëbo atona enëneme na kiju tëbona enëneme na naba titiki tabo enëneme nëno eouleme na elesume tenëme na bobë lowa elelëkakime tenëme.’ ");
INSERT INTO nce_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Na kwe kë wege ho melë tle, bu fene gali tle. Na bubë eso home gali tlole, ‘Eso ho, bo melë wanelë ju fene gali ele kwe oneho lo ke hana mla.’ ");
INSERT INTO nce_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Na eso ho bume gali tlole, ‘Ju ebë lifate tako kile eleme na waluju life elëme asë ebelëfame. Na ju onehome hwi elomena ju bume anisasana sagali elome, bobë lowa migisiya namëglame. Bo metole nanelë, bobë lo ke nalëgleme. ");
INSERT INTO nce_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Bo jume megali nolë, ëbame bo kë gali toglomëbë oneho, bu bo kë sagli nëglëlëbë hi wesibi hana hi mëglame.’ ” ");
INSERT INTO nce_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Lebutako oneho bu Jisasna asë mëtla na Jisas swaya tletëme na gali tlome, ");
INSERT INTO nce_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ho bobë lowene esogo home fatame tole lëglena, bu bome tako tolewa salëletënë na bubë bolijaya, bota, no, bolijahani, bomoluni, bolijamoniname tokwëfo tolewa salëletëme na bubë atome tokwëfo tolewa salëletle. Bu melë hana lëglena kwe bu bobë lowene esogo home hana fata lëgleme. ");
INSERT INTO nce_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ho bu bobë lowene esogo home fatame tole lëglena, kwe melowene lëglena, ‘Bo Jisasme esogo nëglelëlëna kwe ho bome tëbo mëgëtaname,’ kwe bubë ato uli lëglelëlena, na fli hobë wame galime uli lëglena na glime uli lëglena kwe këha ho bu bobë lowene esogo home hana fata lëgleme. ");
INSERT INTO nce_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ho bu kabana lo glijime tole lëglena, bu kë lo gliji baliti afina melowene sle lëletëmeme, ‘Bobë baliti kaba nijine o hanane? Bo ebë balitina lo yawe noglolëmene o hanane?’ ");
INSERT INTO nce_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Bu melë hana lëglena, na bubë baliti yawe loglomena, na bu lo hana yawe loglolena kwe oneho bume sosonatlëtlë memogotlamemu. ");
INSERT INTO nce_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Na bu megali moglolame, ‘Hwi elolo. Ebë ho bu lo yafe gliji lële kwe yawe hana lolole.’ ");
INSERT INTO nce_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Li lifate mago eso ho bu li lifatewa wameme lugujume fene kwe bu afina lowene fa sle lotleme, ‘Bobë lifate mago wame home boblo mogotomabë enëne tëlewamufe kwe bubë wame home boblo mogotomabë enëne feilawamufe. Sebo bume boblo nogotomamene o hanane?’ ");
INSERT INTO nce_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Na bu melowene lëglena, ‘Sebo bume hana boblo nogotomamefe,’ kwe bu melë lëgleme, bume wame moglolabë ho kakë mana neme, kwe bu fli home afina kë lifatebë eso ho belë mana jine lelëkakëmeme, aisenë hi namëglame. ");
INSERT INTO nce_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Na kë fenene, somago ho li bubë iniwa wesibi aholokwana hana ti lëglena kwe bu bobë lowene esogo home hana tafa lëgleme.” ");
INSERT INTO nce_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Këji lale wesibi mu. Kwe këji iji tëbo mëglena, sebo habelë nogotomamene na ita iji namëgletëname? Hananefe. ");
INSERT INTO nce_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Këha iji jwa këji bu hi wesibi hana sle motomeme watëbomu mële. Sebo sike manëkaka. Sobo ebë gali aholokwane egelona, lowene sle eletelome. ");
INSERT INTO nce_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Takis baliti kë glo mëglekefëyabë ho na fli tëbo lowene kë esogo mëglelëlabë enëne bu Jisas belë loliwa mitisitla, bubë gali aholokwane namoglolame. ");
INSERT INTO nce_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Na Farisi hona, Gotobë galime okokwe moglomabë hona wame gali mëtla, “Kë ho bu tëbo lowene kë esogo mëglelëlabë enënena fëyeme yonane lëlelëmene? Na buna fëyeme hi mëlekefëyane?” ");
INSERT INTO nce_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jisas bubë gali aholokwane tlome na bu ebë waflë gali këme gali tlome, ");
INSERT INTO nce_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“So mago ho li, we lujuafe we sipsip kleli lëglëmena, na jowa flawei lëgletlena, bo melowene nanelë, bu fli 99 sipsip kleli tako ona mëta hune lëleme na flawei kë lëgletlebë sipsip kleli mana hohwi lëtagutleme. Hohwi lëtagutlebëë na hwinaloko lujelëleme. ");
INSERT INTO nce_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Bu sipsip hwi lolole na feiji mëta gwa lowetleme na mana bubë lifekuwa fleflesuna lehileme. ");
INSERT INTO nce_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Bu lifekuwa lehileme, na bubë yabe name, weife mago enënename gali lëlagumeme, migisitla namëglame. Na bu misitlame, na bume gali lolomeme, ‘Bobë sipsip kleli li flawei tëglebë bo ita wahwi nololë. Sobo bona weife iniwa fleflesu nëla.’ ” ");
INSERT INTO nce_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Na Jisas megali tle, “Bo some gali nolëyo, tëbo lowene kë esogo lëglelëlebë ho, bubë tëbo lowene aholokwana ti lëglena na Gotobë lale lowenewa esogo lëglelëtlena kwe heven life mëta kë tafa mëglabë ensel, bu tako fleflesumu mëglame, sipsip kleli kë hwi toglolebë ho fene fleflesu tle. Kwe 99 enëne bu melowene mëglana, ‘Sebobë lowene lalowa lëbetënafe, sebo sebobë tëbo loweneme ita hana gëgali nëglamefe,’ kwe heven life mëta kë tafa mëglabë ensel, bu tokwëfo fleflesuwa mëgletëmame.” ");
INSERT INTO nce_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Na Jisas ita gali tle, “Mëse libë baliti we këniji mëgëbetëna na jowa flawei eglatëna, bu habelë eglemene? Kwe bu esi fiji etole na iseku enijina lo mago obo sle etagule na kë baliti mana hohwi etatë. Bu hohwi etatëbëë na mana hwinaloko meeolë. ");
INSERT INTO nce_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Bubë baliti wahwi eolë na bubë yabe name, weife mago enënename gali elome, migisitëya namëglame. Na bu misitëya. Na bume gali elome, ‘Sobo bona iniwa fleflesu nanëglame. Bobë baliti flawei eglabë, bo ita wahwi nolë.’ ” ");
INSERT INTO nce_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Na Jisas gali tle, “Bo some gali nolëyo, tëbo lowene kë esogo lëglelëlebë ho, bubë tëbo lowene aholokwana ti lëglena na Gotobë lale lowenewa esogo sle lëglelëtlena kwe Gotobë ensel bu tako fleflesumu mëgletlame, baliti kë hwi toglëbë mëse fene fleflesu tle.” ");
INSERT INTO nce_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Na Jisas megali latle, “Ho li iko nëbale tële. ");
INSERT INTO nce_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Na nagi fu nëba bolijayame gali tlole, ‘Aya, bo walowene nelë, ju glime nounou lale, kwe jubë iniwa wesibi seme afana mana fufu egotometëname. Kwe bo metole nanelë, bobë wesibiye, eliwamu eglënëme. Tokwafe kwe matëbe.’ Na këme bolijaya bubë iniwa wesibi tlemalë nëbaleme fufu totometëme na tlëme. ");
INSERT INTO nce_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tako tafa hana tle, na nagifu nëba, bubë iniwa wesibi balitina hihijika tle. Na bu kë baliti glo tle na kakë lifatewa këna tuju na këme tafa tule. Bu tafa tugulebëë, na memelë tëbo wesibi fafa totle. Na bubë iniwa baliti kë mëta yawe tlome. ");
INSERT INTO nce_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Bu baliti wayawe tlome, na kë life mëta, tako fone mana fata tletëme. Kë fone mëta tafa mëtëglabëë na bu foneme ëjeha gli lëleme. ");
INSERT INTO nce_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Këme nëgeme, na bu wegeme hohwi tëtagwi. Na kë life mago ho li bubë luku lëglëmetlebë wege fame jine tlële. ");
INSERT INTO nce_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kë luku bu alima jibo hihi mëtlekëfe, na kë falake kë alima jibo hime tako tole latle, bubë imo këna tëtafu nalëgëtame bu foneme tako glimu latle. Kwe ho bume hi wesibi hana mëtlëla. Hanane mu. ");
INSERT INTO nce_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Na tokwafe bu lowene fa totle na gali tle, ‘Bobë ayabë wegeho bu kwe feilawa hi wesibi mu mëbetëme, kwe bo foneme kwe gli nelë. ");
INSERT INTO nce_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Bo eme hana tafa nëgelëme. Matëbemu. Ita aya belë nuguwime na bume gali nololëme, “Aya, bo Gotome tëbo lowenena watëbo totlë na jume mata watëbo tëtë. ");
INSERT INTO nce_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Bo lale ho nane ju bome mefë kë egëtanëme, bobë nëba. Matëbe. Ju bome melë egëtanëme, jubë wegeho fenene.” ’ ");
INSERT INTO nce_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Na kwe bu kë mago, fowa tokokebë na bolijaya belë tuju. Bu kakë mana asë tëkeke, na bolijaya hwi telokwakle. Na tako maninibo metletle. Na fëkawa tokoutlebë na lahwëwa tlële na këme sësle totle na ahino momotlë tletle. ");
INSERT INTO nce_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Na bowene këme gali tlole, ‘Aya, bo Gotome tëbo lowenena watëbo totlë na jume mata watëbo tëtë. Bo lale ho nane ju bome mefë kë egëtanëme, “Bobë nëba.” Matëbe.’ ");
INSERT INTO nce_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kwe bolijaya bubë wege home gali tlome, ‘Sobo hokweinawa lale heletabo ëho ehilo na bume gelo etatelome. Na toba baliti lale, toba mëta ehwatelome, na juba jibo mata ehotelome. ");
INSERT INTO nce_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Na sobo bobë lale bulmakau nëba elesulome na tëke elolome. Sebo hi nanëglame na fleflesu nëlame. ");
INSERT INTO nce_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Bobë nëba leboha tëgletenëme nëgeme kwe bu mana ekë lëtabetenë. Bu waflawei tlita kwe sebo ita ekë hwi nolola.’ Na kwe bu hi mëtla na tako fleflesu memëtla. ");
INSERT INTO nce_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Na kë nalë, abwa nëba nuju mëta mana nuje. Na bu nuju mago tisi, na lolime tlibe na mana fleflesu kë mëtletlabë sawa lego aholokwane tlome. ");
INSERT INTO nce_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Na këme li wege home we tlole na takune tlole, ‘Kë fëye legone? Fëye mëlane?’ ");
INSERT INTO nce_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Na wege ho këme gali tlole, ‘Blijamo wafi lisiyo. Na blijaya lale bulmakau kleli nëba walemitle. Bu boweneme tako fleflesu lalëletle, bu ita ligisi tleme nëgeme na lalowa tutabetle.’ ");
INSERT INTO nce_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Abwa nëba kë gali aholokwane tle na tako enisusu metletle na lowa hana tëkaklu. Na bolijaya tëkaklitle na lale lale galina yafe gali tlole, bubë lowene tli nalëgëbetleme fene. ");
INSERT INTO nce_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kwe bu bolijayame kofaya gali tlole, ‘Fëyemene? Wege hoha, jubë wege feilawa tlibutu fa tëtakefëtë. Na bo jubë gali momata hana tëtatë. Kwe ju bome mëmë kleli nëba tokwëfoha hana yo tlonë bobë yabenime këna fleflesu nanëglelëmëme. Hanane mu. ");
INSERT INTO nce_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kwe jubë nëba kë nëgebëye, jubë baliti lisei oneme fwa yawe tlometëme. Kwe ëje bu lisi na ju bume fëyeme fleflesu eletlene na lale bulmakau kleli nëba fëyeme emitlene?’ ");
INSERT INTO nce_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Na bolijaya bume gali tlole, ‘Hëyai! Ju itaita bonawa nëtabekefo. Na bobë iniwa wesibi kë nëgebëye, ebë jubëwa. ");
INSERT INTO nce_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kwe sebo eliye, blijamome fleflesu nëgletlabë olë. Jubë blijamo leboha tëgleme nëgeme kwe bu mana lëtabe. Bu waflawei tlita kwe sebo ita ekë hwi nolola.’ ” ");
INSERT INTO nce_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisas bubë lowene esogo mëglelëtlabë home gali tlome, “Ëtani, lebutako balitina ho, bubë wege ho jowa tafa tletle. Kë wege ho, kë lebutako balitina hobë wesibi ululu sle totokwefëmetle. Na fli ho kë lebutako balitina ho belë mitisitla na bubë wesibi ululu sle logotomebë hobë wegeme metëtahë lamëtlëla, ‘Jubë wesibi ululu sle logotomebë ho, jubë wesibi fli blawa sisile lotometë.’ ");
INSERT INTO nce_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Këme nëgeme kë lebutako balitina ho bubë wesibi ululu sle logotomebë home gali telokwakle, ligisi nalëgleme. Na bu loliwa tisi tle, na mana bume gali tlole, ‘Bo ebë gali kë aholokwane nëgletëbë, ju fëye tlene? Bobë iniwa wesibi, ju mëta mana mëgëbena, tabei elëme na laba mëta yahi elëme. Ju bobë wesibi ululu sle egotomebë home hana tafa egleme.’ ");
INSERT INTO nce_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Na kwe kë ululu sle logotomebë ho mana melowene tle, ‘Bo habelë nëgelëmene? Bobë wege eso ho, bome ebë ululu sle wegebë mago hehë lëgletenëmefe. Bo life yefi wegebë fa nogotlëme fene, kwe bo këha afutuku hana lëbetenë. Na bo fli onehome balitime na fli wesibime gëgëba noglomëbëme tiniji nanëletemë. ");
INSERT INTO nce_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Kwe bo wesibi wafi lowene nelë. Bo kë wesibi nëgelëna kwe tokwafe, bobë wege eso ho bu bome hehë lëgletenëna kwe fli ho bome bubë lowa no mëglëname.’ ");
INSERT INTO nce_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Këme nëgeme, bubë wege eso hobë mago, wesibi manawa kë glo mëtletlabë home gali telokwakëme, migisi tla namëglame. Jowa ho bu belë afina tisi tle na kë ululu sle logotomebë ho takune tlole, ‘Ju manawa, bobë wege eso hobë mago, habenuju wesibi glo tlenë?’ ");
INSERT INTO nce_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Na bu gali tle, ‘Bo we lujuafe we ëflëbo tu manogwa dram glo telë.’ Na kë ululu sle logotomebë ho gali tlole, ‘Jubë manawa wesibi weniji kë gogwa mëtletëyobë laba tuku ekakeme na tiho laba mëta hokweinawa meyahi elëme, 50 dram ëflëbo tu.’ ");
INSERT INTO nce_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tokwafe li ho bu belë tisi tle na bume takune tlole, ‘Ju manawa, bobë wege eso hobë mago, habenuju wesibi glo tlenë?’ Na bu gali tle, ‘Bo we lujuafe we witi liji manogwa iseku glo telë.’ Na kë ululu sle logotomebë ho gali tlole, ‘Jubë manawa wesibi weniji kë gogwa mëtletëyobë laba tuku ekakeme na tiho laba mëta hokweinawa meyahi elëme, 80 witi liji manogwa iseku.’ ");
INSERT INTO nce_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tokwafe, wege eso ho, bubë wesibi ululu sle logotomebë ho këtëglebë wesibi hwi toglometlena kwe bu kë tëbo wege hobëme fleflesu tletle na këme bibita totle. Wesibi kë wege ho melë këtëglebë, bu tako lowenena hobë loweneha nëgeme. Ebë life mago wesibime fwa, tako lowene kë mëgletëmabë oneho, bubë wege wege mëglabëme, tako lowene slemu lamëletëma. Kwe Gotobë lowene mëta kë mëtabëyabë oneho bubë wege wege mëglabëme tokwëfo lowene lamëletëma. ");
INSERT INTO nce_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Bo some gali nolëyo, sobo ebë life magobë baliti, wesibi jwa enëneme elëmo, sobobë yabe tafa namëgletëyome. Na tokwafe kë baliti glo mëglabë olë yawe lëglena, Goto na bubë ensel some unaunalëme tafa mëglabë lowa nëno mëglame. ");
INSERT INTO nce_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Bo some gali nëlëyo, ho tokwëtokwë wesibi ululu sle logotokwefëmena kwe tokwafe bu tatako wesibi mata ululu sle logotomeme. Ho li tokwëtokwë wesibi laboweli logotomena kwe tokwafe tatako wesibi mata melaboweli logotomeme. ");
INSERT INTO nce_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Sobo ebë life mago baliti ululu sle jwa egotomona, kwe Goto bu some heven life mago lale wesibi ululu slebë habëna lëglëyomene? Weye. Hanane mu. ");
INSERT INTO nce_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na sobo fli enënebë wesibi ululu sle jwa egotomona kwe sobo sobobë wesibi mata ululu sle hana egotomome. ");
INSERT INTO nce_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Wege enëne bu tële eso home hana wege mëgletëmame. Bu melë mëglana kwe bu li eso home fwa tole sle mletlame na lime kwe tëboijiwa moglolame. Bu li eso hobë galiwa aholokwane mololame kwe lime kwe tëboijiwa mletlame. Sobo tële lowene hana esogo eglelëmome. Sobo Gotome lowene egletelobë lowene na baliti fa egotobë lowene sobo këna hana sago egotomome.” ");
INSERT INTO nce_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisi ho bu baliti tako tole lamëtletëma. Këme nëgeme bu Jisas kë gali tëglebë gali aholokwane motlola, na bu Jisasme sosonatlëtlë memototla. ");
INSERT INTO nce_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Kwe Jisas bume gali tlome, “Sobo metole lalo, oneho some melowene namëgletëyome, ‘Bu lale lowenewa esogo mëglelëlabë hofe.’ Kwe Goto bu sobobë tëbo lowene wahwi lolotëyo. Iniwa wesibi oneho melowene mëgletëmame, ‘Lale wesibi mu,’ kwe Goto bu kë wesibime melowene lalële, ‘Tëbo wesibi mu.’ ” ");
INSERT INTO nce_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jisas gali tle, “Jon bu fata jwa tëglena, kwe bu Mosesbë gali na Gotobë lowene mago gali të mototokweflabë hobë galiwa të mëtëtakefëtëma na bu kë galiwa esogo mëtlelëtëma. Kwe Jon bu wafata tle na ebë olëna, Goto, onehobë eso home kë tafa lëgletëmebë lale gali të mëtagutëma. Na oneho bu Goto, onehobë eso home kë tafa lëgletëmebë lifate elë mëkaklujame këkë lamla. ");
INSERT INTO nce_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Matafana, lifena kwe tëbo mëgleme, kwe Gotobë gali kwe iniwa hana tëbo lëgletleme.” ");
INSERT INTO nce_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Na bume ita gali tlome, “Ho, nome hehë lëgletëna na li mëseme sei lëglëna, kwe kë ho bu lisei lowene mëta lëtabe. Na ho, li ho kë hehë lëgletëbë mëse sei lëglëna, kwe kë ho bu mata lisei lowene mëta lëtabe.” ");
INSERT INTO nce_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jisas megali tle, “Ëtani tako baliti musuna ho tëtabe. Na olëli olëli bu lale lale ëhomu tehokëfe. Na olëli olëli bu feilawa lale lale hi wesibiwa hi tlekëfe. ");
INSERT INTO nce_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Na wesibi jwa ho bu kë tako baliti musuna hobë lo ino ëfo li mëta ni tëbekëfe. Kë wesibi jwa hobë weniji Lasarus. Bu melëme tole tle, kë tako baliti musuna hobë masei mago kë luklu mëglekëfebë hi wesibi obobo hi nalëgleme fene. Bubë ato juba jubawa. Na amale bubë juba ololë lamototokwefëmetle. ");
INSERT INTO nce_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tokwafe kë wesibi jwa ho gli tle. Na ensel bume heven lifewa mitilekole na Abraham belë sei motowelile. Na kë tako baliti musu na ho mata gli tle. Na matëmatë mutujuwetla. ");
INSERT INTO nce_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Na bu hel life mëta tototabe na tako elili mëta tëtabe. Na bu Abrahamme hwi towelëkakle. Na Lasarus buna mëtëtabo. ");
INSERT INTO nce_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Na kwe, tako baliti musuna ho we towelëkakle, ‘O semle Abraham, ju bome maninibo eletenë. Ju Lasarusme gali elole, bubë toba ku, tu mëta flu lowetleme na lëhitenëme bobë aleji mëta gwa nalëtatenëme, tli nalëgëbetenëme. Bo ebë ahoju mëta nëgëtabëbë na bo tako elilimu mëta nëtabëfe.’ ");
INSERT INTO nce_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Kwe Abraham gali tle, ‘O hëyai. Ju wesibi lowene sle eletle. Ju atomuna mana tafa tëglena, kwe ju feilawa lale lale wesibi mëta tëtabe kwe Lasarus bu feilawa tetëbo wesibi mëta tëtabe. Kwe ebë olëna, bu fleflesu mëta lëtabe na ju elili mëta etabe. ");
INSERT INTO nce_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Na li wesibi mëtabo. Sebobë ku mëta, Goto tako luju blëge totle. Këme nëgeme, oneho sebona kë tafa nëglabë, bu kë tako luju sobelë habëna su mëkakitëyomene? Hanane mu. Na oneho juna kë tafa egelobë bu kë luju sebelë habëna su mëkakijamene? Hanane mu.’ ");
INSERT INTO nce_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Na tako baliti musuna ho gali tle, ‘Bu këha nëgebë, kwe, semle, bo jume takune nolë, ju Lasarusme bobë ayabë lowa lalowa jine egelëkakëlemene? ");
INSERT INTO nce_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Bobë keinëbalenino tobali. Na Lasarus bume anisasana sagali lolome, bubë tëbo lowene hihijika melame na aholokwana ti melame. Bu kë elili lifate tëbo elëme nagi migisiyalime.’ ");
INSERT INTO nce_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Kwe Abraham gali tle, ‘Mosesbë gali na Gotobë lowene mago gali të mototokweflabë hobë gali mana mëbetëme. Jubë blijamoni kë gali lalowa aholokwane mëglame.’ ");
INSERT INTO nce_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Na tako baliti musuna ho gali tle, ‘O semle, Abraham, bu kwe hanane. Kwe ho bu matëmatë mago huju lëglena na bume luguju tëmena, kwe bubë tëbo lowene lalowa hihijika melame na aholokwana ti melame.’ ");
INSERT INTO nce_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Kwe Abraham bume gali tlole, ‘Bu Mosesbë gali na Gotobë lowene mago gali të mototokweflabë hobë gali, aholokwane jwa mëglekefëyana, kwe matëmatë mago huju lëglebë hobë gali mëtabo hana aholokwane moglolame. Bubë tëbo lowene hana hihijika mëglame na aholokwana ti hana mëglame.’ ” ");
INSERT INTO nce_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisas bubë lowene esogo mëglelëtlabë home gali tlome, “Memelë wesibi onehome fata mëgletëmeme, bume tëbo lowene belë ki namëkakeme. Kwe ho bu li home tëbo lowene belë ki lëkakena kwe masiwafe, Goto kë home tëbo logotlememu. ");
INSERT INTO nce_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Oneho bome tokwafe lowene sle mëgletënabë, ho li bume tëbo lowene belë ki lëkakena kwe ebë tëbo wesibimu. Kwe Goto kë home tako tëbo logotlememu. Kwe fli ho, kë home afina tako aniji mou mëta kesi mëtatlabë na bume nutuwa tuku mëtëkakabë na bu tu mëta suglu lëglebë kë kwe lalowa. Bu kë onehome tëbo lowene belë kiki hana lëkakeme na Goto bume hana tëbo logotleme. Këme nëgeme sobo ululu sle saelo.” ");
INSERT INTO nce_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Sobo bome kë lowene sle egletënabë oneho, somago ho li tëbo lowene mëta litigona kwe sobo eyeutelome na bubë tëbo lowene sle etatelome. Bu kë tëbo lowene aholokwana ti lëglena kwe sobo bubë tëbo lowene aholokwana ti egletelome. ");
INSERT INTO nce_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Na bu jume jowa olëna tobali ita tëlafe tëbo lëgëtakefëna na jume tobali ita tëlafe lisikefëtëna na jume megali lolokwefëme, ‘Masiwafe. Bo tëbo ho. Bo jume tëbo nanëtakefë ebë olëna.’ Kwe ju bubë tëbo lowene aholokwana ti eletleme.” ");
INSERT INTO nce_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Na Jisas bubë gali tëme kë jine tëglëmebë ho, bume gali motlola, “Ju seme aitana, Gotome kë lowene nëgletlabë lowene takowa nalëgëbetëname.” ");
INSERT INTO nce_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Na Jisas bume gali tlome, “Sobo Gotome kë lowene egletelobë lowene bu tokwëfowa nëgena, aoba liji tokwëfo fenene, kwe sobo tako wesibi lalowa egotlome. Sobo time megali eglolona, ‘Ju fli elëme na nutu mëta ejuwelëbeme,’ kwe kë ti sobobë gali esogo lëglelëtëyome.” ");
INSERT INTO nce_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“So mago ho li, bubë wege home, nuju wegeme o sipsip kleli lëglëmeme jine lëglëlena na bu wegeme lugujuna na bubë eso ho belë ita ligisina, bubë eso ho bume megali hana logloleme, ‘Ju hokweinawa tafa elëme na hi elëme.’ ");
INSERT INTO nce_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Weye. Bubë wege home megali logloleme, ‘Ju bobë hi wesibi ahojume eletenëme na kë hi wesibi mana glo eletenëme. Bo afina hi nelëme na ju mana hi egleme.’ ");
INSERT INTO nce_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Na kë wege ho bubë eso hobë gali esogo lëglelëtlena kwe kë eso ho bubë wege home yaha gali hana logloleme. Hanane. ");
INSERT INTO nce_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Këme nëgeme sobo mata, sobo iniwa wesibi Goto some fene gali tolëyo waegelona kwe sobo megali saelo, ‘Sebo wege howa. Goto seme kë gali toglonabë wege, kë wegewa wawege tla. Këme nëgeme Goto bu seme yaha gali hana logloname.’ ” ");
INSERT INTO nce_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisas Jerusalem lifatewa tugujubëë na bu Samaria provins jelëme na Galili provins jelëme na kë ku kuwa tuju. ");
INSERT INTO nce_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Bu li lifatewa fwa tule na ato juba jubawa kë mëtehwëyabë welujuwa ho, bume alëge mëta esune mëtlëla. Bu kakëwa mëtelëkwëya, ");
INSERT INTO nce_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","na Jisasme feilawa we mëtelokwakla, “Jisas, tako ho, ju seme maninibo eletëna.” ");
INSERT INTO nce_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jisas bume hwi telokwakëme na gali tlome, “Sobo sobobë ato lotu lome wege lëglebë home lebotane ëjuwetëmetelo, bu mehwi naloglëyome sobobë ato juba juba jwa mëbetëyo.” Na kwe, bu mutujabë na bubë ato juba lalowa mëtletëme. ");
INSERT INTO nce_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Na bu mago ho li, bubë ato mehwi togloleme nëgeme lalewa lëbetenëfe na bu alëgeme lu tule na miti nagi tuju. Na bu Gotome feilawamu fleflesu tletle na bibita totle. ");
INSERT INTO nce_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Bu Jisasme esune tlële na bubë elebo li mëta latitigo tlewa na bume gali tlole, “Yaha fëyeme sle etanëne?” Na kë ho bu Samaria provins mago ho. (Samaria provins mago enëne bu Israelbë afenëbonina yonane hana mëtlelogwaya.) ");
INSERT INTO nce_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jisas kë home hwi tlole na gali tlole, “Bo melowene nanelë bo ëje welujuwa home sle notomë fene. Na fli tobali ita nilinabëye, hameta mëtabëyane? ");
INSERT INTO nce_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ebë ho bu Israelbë afenëboni nane kwe buwa fëyeme lu lulene Gotome fleflesu nalëgletleme na bibita lotleme? Kwe Israelbë afenëboni fli bu ita lulu jwa fëyeme mëlane?” ");
INSERT INTO nce_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Na Jisas kë home gali tlole, “Ju huju elëme na ejume. Ju bome lowene sle egletenëme nëgeme, jubë ato lalowa këme lëbetë.” ");
INSERT INTO nce_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisi ho bu Jisasme takune motlola, “Goto onehobë eso home habenalë tafa lëgletëmemene?” Na Jisas bubë gali tafu tëtatëme, “Goto onehobë eso home kë tafa lëgletëmebë, sobo nabana hwi eglolobë wesibi nane. ");
INSERT INTO nce_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Na bu megali hana mëglame, ‘Hwi elo, ekë lëbe’ o ‘Hwi elo, ekë lube.’ Weyewa. Sobo aholokwane elo. Goto onehobë eso home kë tafa lëgletëmebë, bu sobobë ku mëta walëtabetëyo.” ");
INSERT INTO nce_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Na Jisas bubë lowene esogo mëglelëtlabë home gali tlome, “Tokwafe bo, Gotobë life mago ho, tako afutukuna këna nigisibë olë hwime sobo tako tole egletelome. Kwe sobo kë olë hwi hana eglolome. ");
INSERT INTO nce_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Na bu some megali moglëyome, ‘Hwi elo. Gotobë life mago ho ita walisi na bu ebelë ekë lutabë’ o ‘Hwi elo. Bu eme ekë lëtabe.’ Kwe sobo bubë gali asa aholokwane elotemo. ");
INSERT INTO nce_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sobo wawaine walowene eletelo, wawaine lëglena kwe iniwa oneho mehwi mlagula. Na kë fenene, bo, Gotobë life mago ho, bo nigisina kwe iniwa oneho bome mehwi mëglaguname, wawaine fene hwi mlagula. ");
INSERT INTO nce_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kwe oneho ebë olëna kë tafa mëglabë, bu afina bome tako elili gwa mëtatëname na hehë mëletëname. ");
INSERT INTO nce_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ëtani, Noabë olëna, oneho fene mëtla, kwe bo, Gotobë life mago ho, bo nigisibë olëna, bu kë esona melë mëglame. ");
INSERT INTO nce_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ëtani Noabë olëna bu melë lamëtla, bu memelë wesibi monei monei mëtlekefëyabëë, na one sesei sesei mëtlabë na mana Noa tako sibu lowa tëkaklu. Na tako haliji tu fuflu totome na iniwa oneho këhaliji tu mëta susuglu mëtla. ");
INSERT INTO nce_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Na Lotbë olëna, oneho bu Noabë olëna fene mëtla bu këha melë lamëtla. Bu memelë wesibi monei monei mëtlekefëyabëë na bu wesibi balitina hihijika mëtlekefëyabë, na bu nuju toba tobalo mëtlekefëyabë, na lo gigliji gigliji mëtlekefëyabë, ");
INSERT INTO nce_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","na mana Lot bu Sodom lifate kile tle na kë nalëwa anusesi ahojuha to tëtëkeketëme, na Sodom life mago onehome kë ahoju iniwa latemuwa totome. ");
INSERT INTO nce_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Na kë oneho fene mëtlekefëya, kwe bo, Gotobë life mago ho, bo këna ita nigisibë olë mata, bu melë mëglekefëyame. Bubë wesibiwa lowene mëgletëmame. Na Gotome lowene mëgletlabë lowene hana lowene mëgletlame. ");
INSERT INTO nce_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kë nalë, ho li lo sebati mëta lëtabena, kwe bu lowa bubë wesibi glome asa malëkaklu. Weye. Bu kë magowa hokweinawa lalëglëboukakuwa. Na kë fenene, ho nuju mëta tafa lëglena bu lowa asa maluju. Matëbe. Bu kë magowa lalëglëboukakuwa. ");
INSERT INTO nce_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Sobo Lotbë mëseme kë fata tëgletëbë tëbo wesibi lowene eletelo. ");
INSERT INTO nce_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ho bu melowene lëglena, ‘Bo Jisasme esogo nëglelëlëna fli ho bu bome tëbo mëgëtaname.’ Na bu, bubë ato uli lëglelëlena na bome hana esogo lëglenënëna, kwe këha ho bu tëbo liglitame. Kwe ho bu bome lowene sle lëgletenëna na bubë ato uli jwa lëglelëlena kwe këha ho bu hana tëbo liglitame. Ho bu kë home mogo nalë tëke moglolana, kwe kë ho gli sle nane lële. Weye. Bu unaunalëme lale tafa lëgleme. ");
INSERT INTO nce_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Bo some gali nolëyo, bo këna nigisibë klabë, tlemalë ho hwëna ni mebome, na Goto lime fwa no lëlëleme na lime kwe kile lëleme. ");
INSERT INTO nce_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Na tlemalë one nage labume mëtabome na Goto lime fwa no lëleme na lime kwe kile lëleme.” ");
INSERT INTO nce_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Na bubë lowene esogo mëglelëtlabë ho, Jisasme takune motlola, “Kë tëbo wesibi hameta fata lëglemene?” Na Jisas bume gali tlome, “Sobo fotë bota jiji mëglena hwi eglomona kwe sobo melowene elo, ‘Wesibi mogo këme lebo.’ Na kë fenene, sobo tokwafe wesibi hwi eglomome na melowene elome, ‘Kë tëbo wesibi këme fata lëgleme.’ ” ");
INSERT INTO nce_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisas bubë lowene esogo mëglelëtlabë home, li waflë galime gali tlome, bume meokokwe naloglomeme, bu Gotome itaita gali moglokefla namëglame na tëboijiwa jwa namëglame. ");
INSERT INTO nce_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Bu megali latle, “Li lifate mëta, onehobë gali aholokwane loglomebë ho këme tëtabe. Kë ho bu Gotome uli hana tletle na bubë gali aholokwaneme momata latlokwefëtle na onehome mata tole hana tletëme. ");
INSERT INTO nce_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na seiju mëse li bu kë lifate mëta mata tëtabe. Na bu kë gali aholokwane loglomebë home itaita tisikefëtle na gali tlole, ‘Bome wame loglonëbë ho, bome tëbo lëgëtanëme ekëne. Ju bome ebë hobota sleme saaitanë.’ ");
INSERT INTO nce_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ëbame kë ho, kë mësebë galime iweniji latlekefëtë, kwe tokwafe bu melowene latle, ‘Bo Gotome momata nanotokweflë na bubë gali aholokwane hana nolokweflë na onehome mata momata nanotokwefëmë. ");
INSERT INTO nce_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Kwe bo këha seiju mëseme uli nanëletë. Bome itaita sosalë latakefënë. Bo melowene nanelë, bo bubë hobota sasle nëtatë. Bo bume nëgaitëme. Bo bume nëgaitë jwa nëgena kwe bu bo belë itaita egisikëfeme na bu bome feilawa sosalë etakefënëlime.’ ” ");
INSERT INTO nce_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Na Jisas megali tle, “Sobo kë gali aholokwane loglomebë tëbo hobë gali lowene sle eletelo. Kë seiju mëse bume itaita yena takune tlokwefle na bume mana taitamë. ");
INSERT INTO nce_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Na sobo melowene lalone? ‘Goto bubë oneho, iniwa olëna klabë yena kë gëgali moglokweflabë hana lëgaitamemene? Na totoko lëglemene?’ Weye. Hanane mu. ");
INSERT INTO nce_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Bo some gali nolëyo. Bume hokweinawamu lëgaitameme. Kwe bo, Gotobë life mago ho, ebë lifewa ita nigisina, na bo onehome hwi noglokwakimëna, bu bome mana lowene sle mëletëna o hanane?” ");
INSERT INTO nce_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Wali enëne bu melowene lamla, “Sebo kwe lale onehomu kwe fliye sebo fenene këha hanane, bu kwe tëbo oneho.” Na Jisas bu këha enëneme waflë galina megali tlome, ");
INSERT INTO nce_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Tlemalë ho bu Gotobë lowa mëtëkaklujo, Gotome nagëgali mëglelëlome. Li bu Farisi ho, na liye bu takis baliti kë glo lëglekëfebë ho. ");
INSERT INTO nce_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Na kë Farisi ho bu hujuna tlibe na bubë lowene nawa Gotome gëgali tlelële, ‘O Goto bo fli hoha hanane. Weye. Bo kwe lale ho mu. Këme nëgeme bo jume këme gali nolë, “Yaha fëyemene.” Fli ho bu tokli tokli lamelekefëya, na tëbo lowene esogo mëlelëkefla na honaoneme lisei lisei mëglelëmabë. Kwe bo kwe hanane. Na bo takis baliti kë glo lëglekëfebë hoha nane. Weye. ");
INSERT INTO nce_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Iniwa wiki, bo tële olë, hi wesibi hi jwa metafa nanëlekefë, jume fwa lowene nanëgletëme. Na bobë baliti na fli wesibi bo kë glo nëglekefëbë, bo melë nanëlekefë, bo welujuwa mëta fulelë fulelë nëlekefë, na jowa fulelë tabo jume nëlëkefë.’ ");
INSERT INTO nce_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kwe takis baliti kë glo lëglekëfebë ho kakë tujuwelibe na bu heven lifewa hana hwi tokwake. Na bu tako maninibona yako mëta bu tle na Gotome gali tlole, ‘O Goto, bo tëbo ho mu, ju bome maninibo eletenë.’ ” ");
INSERT INTO nce_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Na Jisas gali tle, “Bo some gali nëlëyo, kë takis baliti kë glo lëglekëfebë ho bubë lowa ita lugujuna kwe buwa Gotobë naba lime lale ho lëtabeme. Kwe li ho kë kwe hanane. Iniwa oneho bu megali mëglana, ‘Sebo lale oneho mu,’ kwe Goto bume megali loglomeme, ‘Hanane, sobo tëbo enënemu.’ Kwe iniwa oneho bu megali mëglana, ‘Sebo kwe lale enëne nane, sebo tëbo enënemu,’ kwe Goto bume megali loglomeme, ‘Sobo lale enëne.’ ” ");
INSERT INTO nce_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Oneho bu tatako na maba mago nëbale Jisas belë metlesumëtla. Bu metole lamëtla, Jisas bubë atome toba gogwa nalëgletëmeme na Gotome takune nalololeme, bume lëgaitame nalëgleme. Kwe Jisasbë lowene esogo mëglelëtlabë ho bume hwi motloma na wame gali motloma na lëkle mototoma, Jisasme sosalë mogotlalime. ");
INSERT INTO nce_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kwe Jisas nëbaleme gali telokwakëme, bu belë migisitla namëglame. Na bubë lowene esogo mëglelëtlabë home gali tlome, “Sobo nëbale lëkle asa etomo. Bo belë matisiyao. Oneho Gotome lowene slemu mëgletlana, ebë nëbale fene lowene slemu mletla kwe Goto bubë eso home tafa lëgletëmeme. ");
INSERT INTO nce_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Bo nëgali gali nanolëyo, ebëha nëbale bu Gotome lowene slemu lamletla. Na oneho bu Gotome lowene sle jwa mëgletlabë, ebëha nëbale fene lowene sle mletla, kwe Goto eso home kë tafa lëglebë lifatewa hana mëkaklujame. Hanane mu.” ");
INSERT INTO nce_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Na wesibi lebutakona eso ho li, Jisasme takune tlole, “O Tisa, ju lale ho. Bo jume takune nolë. Bo habelë nëgelëmene, Gotona unaunalëme lale tafa nanëgelome?” ");
INSERT INTO nce_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Na Jisas bume gali tlole, “Ju bome lale fë fëyeme etanëne? Ebë life mago ho bu lale nane, Goto buwa lalemu. ");
INSERT INTO nce_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ju Gotobë gali walowene eletle. Bubë bogo megali lalamë, ‘Honaone na onenaho sobo lisei lowene mëta asa tafa elo. Sobo onehome mogo nalë asa tëtëke elo. Sobo tokli asa elo. Sobo sosogëna galina fli onehome blawa asa soso etatemo. Sobo bita name blijaya name boblo asa etomo. Bubë galiwa esogo elelëtemome.’ ” ");
INSERT INTO nce_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Na kë ho Jisasme gali tlole, “O Tisa. Bo tokwëfome nëgena bo këbë iniwa gali melë esogo tlagimë na bo ebë olëna mana esogo nëlelëmë.” ");
INSERT INTO nce_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisas bubë gali aholokwane tlole na bume gali tlole, “Ju li loweneme mana afolo ele. Ju melë egleme. Jubë iniwa wesibi balitina hihijika eleme. Na kë baliti, wesibi jwa onehome sa etagutëmeme. Ju melë eglena kwe heven lifate mëta lale wesibimu lamëbetë. Na ju bome mana esogo elenënëme.” ");
INSERT INTO nce_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kë ho kë gali yafe aholokwane tlole na bu witi tle. Bu lebutako wesibina ho nëgeme. ");
INSERT INTO nce_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisas kë home mehwi tlole, witi lalëlefe na gali tle, “Wesibi lebutakona enëne, Goto bubë eso home kë tafa lëgletëmebëme, ebë kalëlego lalëletëme. ");
INSERT INTO nce_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamel kleli, bu ëho susu nili fulujuwa lëkaklume ebë sogë kalëlego lalële, kwe wesibi lebutakona enëne, Goto onehobë eso home kë tafa lëgletëmebë lifatewa mëkaklujabëme ebë kalëlegomu lalëletëme.” ");
INSERT INTO nce_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Oneho bu kë gali aholokwane mëtlabë, na klelego memëtla na gali mëtla, “Këha melë nëgena, kwe Gotobë lifateme unaunalëme ya tafa lugulemene?” ");
INSERT INTO nce_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Na Jisas gali tle, “Oneho wesibi mogotoma jwa kë mëglabë, Goto bu kwe lalowa logotomeme.” ");
INSERT INTO nce_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Na Pita bume gali tlole, “Aholokwane ele! Sebobë lo na iniwa wesibi wahune tula na sebo jume ekë esogo nëlelëyo.” ");
INSERT INTO nce_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Na Jisas gali tlome, “Bo nëgalimu nanelë. Oneho Goto, bubë eso home kë tafa lëgletëmebë lowenebëme, lowene mletlana bubë lo o nonino o bolijahani o bolijamoni o botamenino o bolijayani o nëbale hune mëglana, ");
INSERT INTO nce_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kwe Goto bume lebutako wesibimu lëglëmeme. Bu ebë life mëta mana tafa mëglana, kwe Goto bume lebutako wesibimu lëglëmeme. Ëtani kë hune mëtlabë wesibi bu tëlewaha kwe Goto bume kë lëglëmebë wesibi bu lebutakomu. Na tokwafe bu Gotona unaunalëme tafa mokokefëyame.” ");
INSERT INTO nce_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisas bubë we ita tële lowene esogo mëglelëtlabë home mëglëbo elëme fo tlelekakëme na gali tlome, “Sobo aholokwane elo, sebo Jerusalem lifatewa ekë nuja. Ëtani, Gotobë lowene mago gali të mototokweflabë ho, bu iniwa wesibi bu tokwafe bome, Gotobë life mago home, mefata mëgletenëbëme, Gotobë bogo mëta wayahi mëtletëna. Na eli kë wesibi bu iniyafemu bome mefata mëgletenëme. ");
INSERT INTO nce_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Na bu bome, Israelbë afenëboni mëtabëya jwa mëglabë enëneme yo moglomame. Na bu bome soso na tlë mëgëtaname na tëboijiwa mëgletëname na nagutabana kokose mogloname. ");
INSERT INTO nce_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Na bome taba afona feilawa tëkle tëkle mëgëtaname na mogo nalë gwa mëtaname. Na bo matëmatë mëta tële olë nebëme, kwe aona olëbëye këna huju nëgelëme. ");
INSERT INTO nce_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kwe bubë lowene esogo mëglelëtlabë ho bu kë gali wayo lowene sle hana mëtletla. Kë gali wayo bume ëhomu latletëme.” ");
INSERT INTO nce_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisas, Jeriko lifate lololi totle na naba titiki tabo ho bu alëge mëglëbo li mëta tafa tle. Kë ho onehome balitime gëgëba latlokwefëme. ");
INSERT INTO nce_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Na bu lebutako onehobë lëleguli lego aholokwane tlagime, na bu loli mago onehome takune tlome, “Kë fëye mëlane?” ");
INSERT INTO nce_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Na bume gali metafu mëtëtatla, “Nasaret life mago Jisas sigli lële.” ");
INSERT INTO nce_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Na kwe kë naba titiki tabo ho, bu feilawa we telokwakle, “Jisas, Devitbë afenëbo, ju bome maninibo eletenë!” ");
INSERT INTO nce_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Na motoutayabë enëne, bume wame gali motlola, “Ju kuju ebe.” Bu ita anisasanamu we telokwakle, “Devitbë afenëbo, ju bome maninibo eletenë!” ");
INSERT INTO nce_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Na Jisas këme tlikaku na gali telëkakeme, “Sobo kë home elesutëna.” Na bu loliwa tisi tle na Jisas bume takune tlole, ");
INSERT INTO nce_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Bo jume habelë nëgëtëmene?” Na kë ho bume gali tlole, “O tako ho, bo hwi nanëgelëme fene.” ");
INSERT INTO nce_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Na Jisas gali tlole, “Ju hwi egleme. Ju bome lowene sle egletenëme nëgeme, jubë naba këme tika meletë.” ");
INSERT INTO nce_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Na hokweinawa bubë naba latikawa mëtletle na bu hwi tëkake. Na bu Jisasme fleflesuna nagi tlële. Na Gotome mana fleflesu tokoutle na bibita tëtagule. Na iniwa oneho buna kë mutujabë kë wesibi hwi motlola na bu mata Gotome fleflesu mëtletla na bibita mototla. ");
INSERT INTO nce_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Na kwe Jisas Jeriko lifate elë fwa tule na lifate kukuwa kë lugujubë alëge, esogo tlagule. ");
INSERT INTO nce_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Na ho li bu kë lifate mëta tafa tle bubë weniji Sakius. Bu takis baliti glo mëglekefëyabë eso ho. Na bu feilawa balitina tafa tle. ");
INSERT INTO nce_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Bu Jisasme hwi nalogloleme fene, habëtabo hone? Kwe bu hwi hana tlole. Bu afolo ho nëgeme na lebutako oneho lilifuha memëtletla. ");
INSERT INTO nce_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Këme nëgeme bu afina fëka tokou na ti elë tokwale, kë magowa, Jisasme hwi nalogloleme. Bu melowene latle, “Jisas eli ebë alëge elë ligisime.” ");
INSERT INTO nce_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Na kwe Jisas kë ti li elë fwa tule na hwi tokwake na Sakiusme hwi telokwakle na gali tlole, “Sakius, ju hokweinawa kle ele. Eli sebo jubë lowa nëgëyeu nanëgelome.” ");
INSERT INTO nce_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Këme nëgeme hokweinawa laklewa tëtëkaketle na bu Jisasme bubë lowa fleflesuna tlelule. ");
INSERT INTO nce_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Na iniwa ho kë hwi motlolabë wame galina gëgali mëtla, “Bu tëbo lowene esogo lëglelebë hobë lo elë fëyeme lujune?” ");
INSERT INTO nce_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Bu lo mëta tafa mëtelo na Sakius hujuna tlibe na Jisasme gali tlole, “O tako ho. Eli bo bobë iniwa wesibi fu tële nogotomëme. Na jowa fulelë tabo, wesibi jwa enëneme sa nëgëtatemëme. Na bo ho lime sogëna toglolëbë na bubë wesibi tokli tëgletelëbë kwe bo bume kofayame niliafe nëglëlë nëgelëme.” ");
INSERT INTO nce_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Na Jisas bume gali tlole, “Ëje, Goto bu ebë lo mago enëneme walaitame na bubë tëbo lowene mago wanëno lële. Kë ho bu mata Abrahambë afenëbo lëtabe. ");
INSERT INTO nce_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Bo, Gotobë life mago ho, bo tëbo loweneme kë tafa mëglabë onehome hohwi nëtatemë na bume nëgaitamëme na tëbo lowene mago nëno nanëgelëme. Bo këme tisi temë.” ");
INSERT INTO nce_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Oneho bu Jisasbë gali mana aholokwane mëtlagulabëë na bu waflë gali olisina loko metotle na waflë gali metë tëtatëme. Bu Jerusalem lifate elë lololi tle na oneho bu meweniji mëtla, Goto onehobë eso home kë tafa lëgletëmebë olë, eliwa fata lëglemewa. Këme nëgeme Jisas këbë waflë galibëme gali tlome, bubë kë yaya lowene sle nalëgëtatëmeme. ");
INSERT INTO nce_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Bu megali tle, “Letitabo ho, kakë lifatewa lugujume, bume tako eso home aniji namugujelëlame. Na tokwafe bu ita lisime na bubë lifate mago onehobë eso home tafa nalëkakitëmeme. ");
INSERT INTO nce_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Bu lugujume kofene na bubë welujuwa wege home gali telokwakëme bu betelë migisitla namëglame. Na bu mitisitla na bume tëlafe we (20) baliti, tëlafe we (20) baliti këniji tlëwagume. Na bume gali tlome, ‘Sobo ebë baliti glo elome, na bobë nagi ebë balitina sawege elo. Sobo wege egelobëë na fli baliti kë wegena saboblo etomo. Sobo mana wege elekefobëë na bo mana fata nëkakime.’ ");
INSERT INTO nce_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kwe kë hobë weife lifate mago oneho bume wame lamotlola. Këme nëgeme, bu wafi tuju, na bu gali mëtehula home nagi jine mëtelëkakëma, kë lifatebë eso home megali namugujuwelëmame, ‘Sebo kë home sebobë eso home tafame tole hana nëletlamu.’ ");
INSERT INTO nce_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Kwe bume eso home aniji mutujuwelëla na bu ita tisi. Bu tisi na gali tle, ‘Ëbame baliti këtëglëmëbë wege home gali elokwakëmo, bo belë migisiya namëglame. Bo lowene nanëgelëme, bu kofaya baliti kë balitina habenuju boblo mëtëtayane?’ ");
INSERT INTO nce_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Na kwe bubë wege ho li afina tisi tle na gali tlole, ‘O eso ho, ju kë tëglënëbë tëlafe we (20) balitina bo wege fa totlë na bo jubë nagi 200 kofaya baliti këna blëge tëtë.’ ");
INSERT INTO nce_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Na eso ho gali tlole, ‘Ju bobë lale wege ho mu. Ju bobë nagi lale wege fa totle. Ju kë tokwëfo wesibi ululu sle togotleme nëgeme na bo jume meaniji këme nolë, ju jowafe we lifatebë onehobë eso home tafa egletëmeme.’ ");
INSERT INTO nce_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Na li wege ho bu mata tisi tle na gali tlole, ‘O eso ho, ju kë tëglënëbë tëlafe we (20) balitina bo jubë nagi wege këna fa totlë na bo we lujuafe we (100) kofaya baliti blëge tëtë.’ ");
INSERT INTO nce_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Na eso ho bume gali tlole, ‘Bo jume meaniji nanolë, ju tobali lifatebë eso home tafa egletëmeme.’ ");
INSERT INTO nce_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Na li wege ho bu mata tisi tle na gali tlole, ‘O eso ho. Jubë tëlafe we (20) baliti mana ekë mëbe. Bo këbë baliti afeteni sosa ëhona lei totomë na gogwa telë. ");
INSERT INTO nce_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Bo jume uli tëgletëme nëgeme. Bo melowene latletë, “Ju këha lakalena ho nëgeme ju ho libë wesibi lamomanëbawa etatle. Wesibi ho li gogwa lëglebë kwe ju lafawa etokwakle. Na hi wesibi li ho tobalo lëglebë kwe ju lamëmëwa eletle.” ’ ");
INSERT INTO nce_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Na kwe kë eso ho bu kë wege home gali tlole, ‘Ju tëbo wege homu. Bo jubë galime fwa jume tëbo nëgëtëme. Ju bome melowene laletenëne, “Bo wesibi momanëba nogotomëbë lakalena ho. Wesibi li ho gogwa lëglebë kwe bo lafawa netokwaklë. Na wesibi li ho tobalo lëglebë kwe bo lamëmëwa nëletelë.” Ju melowene laletenëne? He? ");
INSERT INTO nce_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ju kë lowenebëme walowene egletenëbë, kwe ju bobë baliti, baliti loloko lo mëta gogwa tugule jwa fëyemene? Na bo kënigisibë bo fli kofaya balitina glo nanëkakime fene.’ ");
INSERT INTO nce_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Na bu lolime kë mitlijabë home gali tlome, ‘Sobo bu mago tëlafe we (20) baliti glo elome na 200 balitina kë tafa lëglebë home elëlome.’ ");
INSERT INTO nce_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Na bume gali motlola, ‘Eso ho. Ju hwi ele. Bu 200 baliti lamëbetlefe. Ju seme fëyeme gali elonane sebo fli baliti mata nëglëlabëme.’ ");
INSERT INTO nce_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Na bu gali tlome, ‘Bo some gali nolëyo, iniwa oneho, Goto kë lëglëmebë wesibi, ululu sle motomana, kwe Goto bume fli wesibi mata lëglëmeme. Kwe iniwa oneho, Goto kë lëglëmebë wesibi, ululu sle jwa motomana kwe Goto kë wesibi bu mago ita hijika logotomeme. ");
INSERT INTO nce_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na bome bubë eso home fatame tëboijiwa kë mëtletënabë wameho, sobo eli bume bo belë elesumome na bobë naba li mëta mogo nalë tëtëkle etome.’ ” ");
INSERT INTO nce_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisas kë waflë gali wayawe tlole na bu Jerusalem lifatewa mana tokwale. Na bubë lowene esogo mëglelëtlabë ho nagi esogo mëtlagula. ");
INSERT INTO nce_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jisas bu Betfage lifekuwa na Betani lifekuwa loliwa fwa tule. Kë lifeku bu Oliv tiwa fatini li mëta mëtëbe. ");
INSERT INTO nce_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Na Jisas bubë lowene esogo mëglelëtlabë ho tlemalëme gali tlome, “Sobo ebë kë lugubebë lifeku elë eyeumo. Sobo eyeume, na kë lifekuwa tuhu egulona, kwe sobo afeku donki kleli, hwi eglolome, ti mëta watakuliji mototla. Ëtani ho li kë donki kleli matawa hana tafa tle. Sobo taba tohwa etlome na ebelë elesulome. ");
INSERT INTO nce_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Na ho li some metakune loglëyona, ‘Sobo ebë donki kleli fëyeme tohwa etlone?’ Kwe sobo bume metafu saetatelo, ‘Sebobë tako ho bu këna luguju nalëgleme.’ ” ");
INSERT INTO nce_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Na Jisas bu kë tlemalë home jine tlëme, na bu mëtëyeu. Na bu iniwa wesibi hwi motlomo, Jisas fene gali tlome. ");
INSERT INTO nce_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Na bu kë donki kleli këna këkesi mototlabë taba mago taba, mana tohwa mototokweflobëë na mana kë donki kleli bolijaya ho mana takune telëbakëme, “Sobo ebë donki kleli fëyeme tohwa etlone?” ");
INSERT INTO nce_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Na bu gali tafu mëtëtatelo, “Sebobë tako ho këna lugujume.” ");
INSERT INTO nce_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Na kwe bu kë donki kleli Jisasme sei mëtlëkakitelo. Na bubë heletabo ëho donki klelibë amlebo mëta kahëba motoletelo. Na bu Jisasme mëtaitalo, kë donki kleli matawa tafa nalogolebëme. ");
INSERT INTO nce_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Na bu këna tuju. Na oneho bubë heletabo ëho totohwa motokouja na alëge mëta gogwa motokouja. Bu Jisasme fleflesu mëtletla, eso hoha fata tëgleme nëgeme. ");
INSERT INTO nce_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Na bu Oliv tiwa fatini kle tëmaitabë nounou totle, na Jerusalem lifatewa fwa tuguleme nounou latotle. Na bubë feilawa lowene esogo mëglelëtlabë enëne fli, bu fleflesu lamëtletla. Na bu, klelegowa wesibi, Jisas kë blëge blëge totomebë, ita lowene mëtletëma na bu Gotome anisasana fleflesu këme mëtletla na bibita mototla. ");
INSERT INTO nce_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Yaha fëyeme jine tlëlene? Sebo Goto kë jine tëglëlebë eso home fleflesu nëgletlame. Bu Gotobë afutukuna lisi tëna. Goto kë eso home lëgaitaleme na ululu sle logotleme. Goto bu heven life mëta kë tafa logolebë bu lale na tako mu. Goto sebobë, ebë life mago onehobë lowene lëgëbetëme sle malëletëme.” ");
INSERT INTO nce_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Na Farisi ho, bu kë feilawa onehobë ku mëta mëtëtabëya na bu onehobë galime tole hana mëtletëma na bu këme gali motlola, “O Tisa, jubë lowene esogo mëglelëlabë home lëkle etome kuju namëgebëyame.” ");
INSERT INTO nce_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Kwe Jisas bume gali tafu tëtatëme, “Bo some gali nolëyo, ebë oneho bu kuju mëgebëyana kwe aniji buwa momolë mëgleme na Gotobë weniji bibita mëtatleme.” ");
INSERT INTO nce_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jisas Jerusalem lifate lololi totle na bu kë lifate hwi telokwakle na mana bubë onehome naba tu tletëme. ");
INSERT INTO nce_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Na gali tle, “Oë Jerusalem lifate mago enëne. Bo metole nanelë, iniwa wesibi sobobë lowene kë sle mogotometëyobë, lowene sle egletemome, lalowa tafa naegelome. Kwe kë wesibi ëho lameletëyo na sobo hwi hana elomo. ");
INSERT INTO nce_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tokwafe tëbo olë somëta fata lëgleme. Na kë olëna sobobë wame enëne bu some lukume fu sle mëgletëyome na sobobë life mago lëglesi ini sabuwa mogotlame na wameme mokwatëyome. ");
INSERT INTO nce_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Na kë wame enëne bu some na sobobë lifatena iniwa tëbo mëgëtome. Na li aniji bu li aniji matawa hana egëbamëme. Bu life silijiwa lëgëbeme. Goto some lëgaitome fene tisi tëyo kwe sobo kë olëbëme lowene sle hana tëgletelome nëgeme na kë tëbo olë some këme lisitëyome.” ");
INSERT INTO nce_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jisas tako lotu lowa tëkaklu. Na bu seuneni fole na sipsip kleli na bulmakau kleli balitina kë hihijika mëtlekefëyabë onehome kë mago hehë tletëme. ");
INSERT INTO nce_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Na bu gali tle, “Gotobë bogo megali lala, ‘Bobë lo, oneho bome këme gëgali mëglelëkefënabë lo.’ Kwe sobo ebë lo tëbo latlo na bu tokli enënebë loha lilibetëme.” ");
INSERT INTO nce_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Na iniwa olë, bu tako lotu lo mëta onehome okokwe latlokwefëme. Na lotu lome wege mëglabë eso enëne na Gotobë galime okokwe moglomabë ho na onehobë letitabo enëne, Jisasme mogo nalë tëke moglolabë gali fame oto mëtla. ");
INSERT INTO nce_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kwe bu onehome uli mëtletëmame nëgeme. Kë iniwa oneho Jisasbë gali aholokwaneme tako tole mëtletlame nëgeme na Jisasme mogo nalëme tëkle jwa këme mototla. ");
INSERT INTO nce_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Na kë nalëwa, Jisas onehome tako lotu lo mëglëbo mëta okokwe tlome na bu Gotobë lale gali të tëtatëme. Na lotu lome wege mëglabë eso enëne na Gotobë galime okokwe moglomabë ho na onehobë letitabo enëne bu belë mitisitla, ");
INSERT INTO nce_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","na takune motlola, “Ju seme gali enona, iniwa wesibi ju melë kë egotomebë, jume ya aniji tolëne? Kë afutuku ya tlënë?” ");
INSERT INTO nce_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Na Jisas bume gali tlome, “Bo mata, some li wesibime takune nëlëyome. Sobo bome gali enona, ");
INSERT INTO nce_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jonme ya aniji tlolene, onehome tu mëta kë baptais totomebëye? Goto bu aniji tlolene o ho buwa aniji motlola?” ");
INSERT INTO nce_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Bu Jisasbë gali aholokwane motlola na blalo gëgali mëtla, “Sebo megali noglolana, ‘Goto bu aniji tlole,’ kwe bu seme megali logloname, ‘Kë nëgali gali nëgebë, sobo bume lowene sle egletelo jwa fëyemene?’ ");
INSERT INTO nce_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kwe sebo megali noglolana, ‘Ho, buwa aniji motlola,’ kwe iniwa oneho bu seme anijina tëtëkle mëgëtayame. Iniwa oneho Jonme melowene sle mëgletlame nëgeme, ‘Bu Gotobë lowene mago gali të totokweflebë homu.’ ” ");
INSERT INTO nce_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Na kwe bu Jisasme gali tafu mëtëtatla, “Sebo, Jonme kë aniji toglolebëme, lowene hana nëla.” ");
INSERT INTO nce_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Na Jisas bume gali tlome, “Bo mata, iniwa wesibi bo melë kë nogotomëbë bome kë aniji toglonëbëme some hana gali sle noglëyome.” ");
INSERT INTO nce_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jisas, onehome waflë gali latlome, “Ho bu wain taba, nuju mëta tobalo tle. Na tokwafe bu fli home gali tlome, ‘Sobo bobë wain taba nuju hwi elotëna na tokwafe wali wain taba liji lalowa glo elo, baliti këna glo naegelome.’ Na kë nuju bolijaya bu kakë lifatewa tuju. ");
INSERT INTO nce_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Feilawa olë tafa tule na kë wain taba liji mana nigliji mëtle. Këme nëgeme nuju bolijaya ho, bubë wege ho lime, bubë nuju kë hwi moglotlabë ho belë jine telëkakle, bubë wain taba liji, kë nuju mago glo nalëgleme. Na bu tuju. Kwe nuju kë hwi moglotlabë ho, bu kë wege home hwi motlola na tëkle mototla na kë mago hehë mëtëkaketla. Na bu toba alujawa tehou. ");
INSERT INTO nce_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Na ita nuju bolijaya, li wege home jine telëkakëtëme. Kwe kë enëne, bume hwi motlola na bume mata tëkle mototla na unalëme sosalë sosalë sle memototla na kë mago hehë mëtëkaketla. Na bu toba alujawa tehou. ");
INSERT INTO nce_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Na ita li home jine telëkakëtëme. Kwe këbëme mata unalëme sosalë sosalë sle memototla na kë mago hehë mëtëkaketla. ");
INSERT INTO nce_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Na nuju bolijaya bu kë wesibi hwi tlome na këme lowene tle, ‘Bo habelë nëgelëmene? Bo melowene nanelë. “Bobë jowa iko nëba jine nëgelëkakëtemëme. Bo bume tako tole nanëletelë. Bu bubë gali aholokwane moglolame na bume hana tëbo mogotlame.” ’ Na bu kë nëbame jine telëkakëtëme. ");
INSERT INTO nce_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Na nuju kë hwi motlotlabë ho bu kë nëbame hwi mëtlagila na blalo gëgali mëtla, ‘Ebë ho kë ligisibë ebë kë nujubë bolijayabë bowene. Tokwafe bolijaya gli lëglena, kwe bu kë nuju bolijayame lëtabeme. Te, mana mogo nalë tëkle manotla na tokwafe bolijaya gli lëglena kwe kë nuju sebo nanëglame.’ ");
INSERT INTO nce_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Këme nëgeme bu tisi tëme na bume nuju mëglëbo elëme hehë motokoutla na mogo nalë mana tëkle motlola. Sobo habë lowene lalone, kë nuju bolijaya bubë nuju kë hwi moglotlabë home habelë logotomemene? ");
INSERT INTO nce_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Sobo aholokwane elo, bu ligisi nëgena, na bu kë home mogo nalë tëbo logotomeme. Na ita kë wain taba liji nuju fli home yo lolomeme.” Oneho kë gali aholokwane mëtla na gali mëtla, “Melë asa malële.” ");
INSERT INTO nce_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jisas bume hwi tëbelëkakëme na takune tle, “Ebë gali, Gotobë bogo mëta kë tëgëbebë, bubë wayobë habelëne? Kë gali melëgëbelalële, ‘Lo gliji ho, bu lo, anijina gliji mëtla. Na kwe bu li anijime meweniji lamëtla, “Tëbowa.” Këme nëgeme, mëglëbo elë fo mëtetokwakëya. Kwe kë aniji mëglëbo elë kë fo mëtetokwakëyabë bu lale anijimu ebamë. Lo bulego kë aniji mëta lotle. Kë aniji jwa nëgena, kwe lo fli lëgleme.’ ");
INSERT INTO nce_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Iniwa oneho bu kë aniji matawa mitigwëyana kwe bu mogo nalë tëbo miglitayame. Na kë aniji, home matawa etigwatlena kwe bume lëlafowa egotleme.” ");
INSERT INTO nce_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Gotobë galime okokwe moglomabë ho na lotu lome wege mëglabë eso enëne melowene lamëtla, “Jisas seme fwa waflë gali lolonafe. Bu melowene lalëletëna, ‘Sebo kë tëbo enëne. Sebo nuju kë hwi noglolabë tëbo enëne.’ ” Këme nëgeme, bu Jisasme ëjeha fa motlame. Kwe bu onehome uli mëtletëmame nëgeme, oneho Jisasme tako tole lamëtletla. Na bu Jisasme fa jwa këme mototla. ");
INSERT INTO nce_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Gotobë galime okokwe moglomabë ho na lotu lome wege mëglabë eso enëne bu Jisasme olëli olëli mana hwiwa mëtëbelëkakla. Na bu ho flime jine mëtlëma, Jisasme mogweliha hwi namëbelokwaklame. Kë enëne mesosogëna lamotlola, “Sebo jubë gali aholokwaneme tako tole nanëla.” Bu metole lamëtla, Jisasme sogëname takune manolola na bu Rom life mago eso ho, Sisarme, tëbo gali nalogloleme. Kë tëbo galime fwa bume këna so namëgëtatlame fene. ");
INSERT INTO nce_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Na kë mogweliha hwi ho, Jisasme këme takune motlola, “Tisa, sebo lowene nanëla, ju nëgali gali homufe. Ju nëgali galimu iniwa onehome të tëtatëme. Ju lebutako balitina home na baliti jwa home, lili gali hana gali tlome. Weye. Ju iniwa home, jowa galime fwa gali tlome. Ju iniwa onehome, Gotobë gali, iniyafeme fwa okokwe tlome. ");
INSERT INTO nce_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Na ju habë lowene lalene? Sebo takis baliti Rom life mago eso ho, Sisarme, lalowa nëglëlamene o hanane? Këha lowene lalowa nëglamene o hanane?” ");
INSERT INTO nce_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kwe Jisas bubë sosogëna lowene walowene tletëme na bume këme gali tlome, ");
INSERT INTO nce_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Sobo jowa baliti bome ehitëna, hwi nanoglëme.” Na bu baliti mëtëhitla. Na Jisas këbëme hwi tlome na takune tlome, “Ebë amtëtomba yalëbë lëbetlene, na yalëbë weniji lëbetlene?” Na këme megali motlola, “Ebë Sisarbëyo.” ");
INSERT INTO nce_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Na Jisas bume gali tlome, “Te! Sisarbë wesibiye, kwe Sisarme eglëlome. Gotobë wesibiye kwe Gotome eglëlome.” ");
INSERT INTO nce_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bu onehobë naba li mëta bume sogëna galime yafe takune motlola, bu Rom life mago eso home, tëbo gali nalogloleme fene. Kwe bu tëbo gali hana gali tle. Bu kë tafu tëtatëmebë gali yafe aholokwane motlola na klelego memëtla na tutune memëtla na këme kuju mëtebëya. ");
INSERT INTO nce_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Na Sadyusi ho fli, Jisas belë mitisiya. Sadyusi hobë lowene metëbetëmelatle, “Oneho lebo mëgebëyana, hana huhuju mëglame.” ");
INSERT INTO nce_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Na bu Jisasme takune motlola, “Tisa, ëbame, Moses bu ebë gali meyahi latletëna, ‘Ho nëba jwa lebo lëgëbena, na bubë mëse mana tafa eglena, kwe ita bolijamo sasei lëlë, nëbaneni namëgelome. Na kë nëbale, lebo kë lëgëbebë hobë wenijina namëtabëyame. Na bu kë hobë nëbaleha tafa namëglame, na lebo kë lëgëbebë hobë weniji lëgëbagutle nalëgleme.’ ");
INSERT INTO nce_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ëtani, ho li tobali ita jowa këniji bolijamonime tlebime. Bolijaha mëse bu afina sei tlë na kwe kë bolijaha nëba jwa gli tle. ");
INSERT INTO nce_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Këme nëgeme, ita këme këbë, kë mëseme sei tlë, kwe bu mata nëba jwa gli tle. ");
INSERT INTO nce_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Na ita këme këbë bu mata, melatle, kë fenene. Bu iniwa bolijamoni melamëtla, kë mëseme fwa sei mëtlekefëya na bu iniwa nëba jwa gigli mëtla. ");
INSERT INTO nce_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Na tokwafe kë mëse, bu mata, gli tle. ");
INSERT INTO nce_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Na sebo jume metakune nanëlëyo. Tokwafe gigli kë mëglabë oneho huhuju mëglana, kë mëse fëye hobë mëse tafa egletlemene? Ju wafi lowene ele, kë mëseme tobali ita tële ho këniji kë sei mëtlëya.” ");
INSERT INTO nce_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Na Jisas bume gali tlome, “Oneho, ebë olëna kë tafa mëglabë bu one sesei melekefëya. ");
INSERT INTO nce_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kwe tokwafe Goto bu fli lebo onehome megali loglomeme, ‘Sobo huhuju egelome na bona tafa nëlame.’ Kë huju mëglabë enëne bu hana sesei mëglame. ");
INSERT INTO nce_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bu heven life mago enselha mëtabëyame nëgeme, na bu ita gigli hana mëglame. Goto bume matëmatë mago wahuhuju logotomeme nëgeme, bubë nëbaleha këme tafa mletlame. ");
INSERT INTO nce_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Na bo some lebo enëne huju mëglabë gali li të nëtatëyo. Ëtani Moses bu mata seme melebotane latëtatëna. Oneho gigli mëglabë, bu matëmatë mago huhuju mëglame. Ëtani Moses bu, ahoju ti abo mëta kë u tëglebë galime meanebo gali latletle. Na bu Gotome melë galina yahi tletle, ‘Tako Ho, bu semleninobë, Abraham, Aisak, Jekopnabë Goto mana ekë tafa lële.’ ");
INSERT INTO nce_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kë gali bu seme melebotane lalëtatëna, Goto bu lebo enënebë Goto nane. Weye. Bu mana kë tafa mëglabë enënebë Goto. Gotobë naba lime, iniwa oneho, giglibë na mana kë tafa mëglabë, iniwa bu mana hwi mëtaya.” ");
INSERT INTO nce_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Na Gotobë galime okokwe moglomabë ho fli, bu Jisasbë gali yafe aholokwane mëtla na bume gali motlola, “Tisa, ju bume kë tafu ëtatëmebë gali lalemu.” ");
INSERT INTO nce_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Na Sadyusi ho bu Jisasme li loweneme takune moglolame fene, kwe bu uli memëtletlamu. ");
INSERT INTO nce_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Na Jisas onehome takune tlome, “Bu megali fëyeme mëlekefëyane, ‘Goto kë aniji toglolebë ho, onehome nëno lëglebë ho, kë ho bu Devitbë afenëbo.’ Sobo habelë lowene laletelone, bu kë galime fëyeme gali mëlekefëyane? ");
INSERT INTO nce_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ëtani Devit buwa Buk Song mëta meyahi latle, ‘Goto, bu bobë eso home megali lalolole, “Ju bobë tobamu toba elë tafa egletenëme, na ju bona onehome eso home tafa nëletemome. ");
INSERT INTO nce_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Sebo onehome mana tafa nëlelëmome, na bo jume kë wame mëglëyobë home boblo nogotomëme na bu jubë gali boblo jwa mëtome.” ’ ");
INSERT INTO nce_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Sobo hwi elo. Devit kwe kë home mefë latotle, ‘Bobë eso ho.’ Na bu Devitbë bowene tafa habelë lëglemene?” ");
INSERT INTO nce_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Iniwa oneho bubë gali mana aholokwane mëtlagulabëë, na mana bubë lowene esogo mëglelëtlabë home gali tlome, ");
INSERT INTO nce_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Sobo Gotobë galime okokwe moglomabë home ululu sle saeletemo. Bubë lowene mëta asa etabetemo. Bu metole lamla, oneho bume hwi molomame na melowene mëletëmame, ‘Bu lale enënefe.’ Këme nëgeme, bu heletabo ëho gëgelo motokwefëma na asë mla. Na bu këna bume fwa fleflesu mla na bibita motoma. Na bu oneho këme kë loloko mëglabë lifeku mëta asë mëglana, bu metole lamla, oneho bume sësle galina gali namoglomame. Bu lotu lome tafa mëglana, bu metole lamla, onehobë naba li mëta, eso hobë tafa labume tafa mlame. Na hi wesibi salë olëna, bu metole lamla, onehobë naba li mëta, eso hobë tafa labume tafa mlame, oneho bume melowene namëgletëmame, ‘Letitabo enënefe.’ Na bu këna bume fwa fleflesu mla na bibita motoma. ");
INSERT INTO nce_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Na bu seiju oneme sosogëna moloma, bubë iniwa wesibi manawa mëglëma namëglame. Na bu memelë lamla, onehobë naba li mëta, Gotome megëgali gëgali mëglelëlabëë, bubë tëbo lowene këna ëho motoma, oneho bu melowene namëgletëmame, ‘Letitabo enënefe.’ Unina, Goto onehobë tëbo lowene aholokwane loglometëmebë olëna, bu kë Gotobë galime okokwe moglomabë home tëbomu logotomeme.” ");
INSERT INTO nce_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisas tako lotu lo mëta tafa tle, na bu lebutako balitina onehome hwi tlome, bu Gotome kë sike melekefëtlabë bokis mëta baliti sisike mëtletla. ");
INSERT INTO nce_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Na bu mana mehwi tolë, wesibi jwa seiju mëse, baliti tokwëtokwë tële kë bokis mëta sike tule. ");
INSERT INTO nce_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Na Jisas gali tle, “Bo some nëgali nanolëyo. Fli oneho kwe bu kë bokis mëta, tokwëfo balitiha sisike mla, kwe Goto kë wesibi jwa seiju mëseme melowene lalëletë, ‘Bu feilawa balitimu sike ele.’ ");
INSERT INTO nce_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Fli oneho bubë feilawa baliti mëbetëme kwe tëlewa sike mla na fli mana mëbetëme. Kwe kë wesibi jwa seiju mëse bu baliti tokwëfo mu, kwe bubë hi wesibi glo baliti iniwa sike ele.” ");
INSERT INTO nce_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Jisasbë lowene esogo mëglelëtlabë ho, bu Gotobë tako lotu lo hwi motlola na gali mëtla, “Ebë lo bu lale klisomu. Bu ebë lo lale lale anijinamu gliji mëtla. Na lale lale wesibina, Gotome kë mëglëlabë, ebë lo neglina lamëtlëla.” ");
INSERT INTO nce_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Na Jisas gali tlome, “Bo ebë wesibi sobo kë hwi eglomobëme gali nolëyo. Tokwafe bu ebë lo iniwa yayei mogotlame. Fli aniji matawa hana mëgëbëme. Iniwa sisike mëkakame.” ");
INSERT INTO nce_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Na kwe bu Jisasme takune motlola, “Tisa, bu ebë lo fëye olëna yayei mogotlamene? Sebo fëye wesibi afina hwi noglolamene na këme lowene nëletlame, kë olë nounou ekë lële.” ");
INSERT INTO nce_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Na Jisas gali tlome, “Sobo ululu sle saelo. Ho some sosogëna moglëyolime. Unina feilawa ho migisiyame na sogëname megali mlame, ‘Bo onehome tëbo lowene mago nëno nëgelëbë ho.’ Na bu gali mëglame, ‘Yawe olë nounou ekë lële.’ Sobo bubë gali asa aholokwane elomo na bume asa esogo elelëmo. ");
INSERT INTO nce_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Na sobo fli lifate enëne tako momogli mëtayabë gali aholokwane egelona, sobo uli asa elo. Kë wesibi bu afina melë mëgleme, kwe yawe olë nounou hana lëkeke.” ");
INSERT INTO nce_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Na bu gali tlome, “Li life li life mago ho, bu li life hona momogli mëgëtayame. ");
INSERT INTO nce_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Na tako nano ekoujamëme. Na li life li life oneho tako foneme gigli mëkoujame na tako ato elili mëkoujame. Na sobo tokwafe fli tëbo wesibi matafa mago hwi eglomome na sobo kë wesibime tako uli egelomemu. ");
INSERT INTO nce_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Kë tëbo wesibi bu fata jwa mëleme na bu some fafa mlame na tëbo mëtome. Bu bubë lotu lo elëme mëlelëkakujome na bubë letitabo enëne belë sei mugujuwelëyome. Na sobobë gali aholokwane molëyome. Na bu some kalabusu lowa sike mlame. Na bu gavman enëne belë na eso enëne belë sei mugujuwelëyome, sobo bome lowene sle egletëname nëgeme. ");
INSERT INTO nce_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Na sobo kë nalë, Gotobë lale gali bume lalowa të egëtatemome. ");
INSERT INTO nce_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kwe sobo tutune asa elo na melowene asa elo, ‘Sebo habë gali noglomamene?’ Weye. ");
INSERT INTO nce_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Bo some kë olëna lale lowene nëglëyome. Na sobo kë lale lowenena gali të egëtatemome. Na some kë wame moglëyobë ho kë gali aholokwane mëglëyona, na sobobë gali hana momata mëgëtatëyome na megali hana mëglame, ‘Bu yaya gali lamla.’ Weyewa. Hanane mu. ");
INSERT INTO nce_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Na tokwafe, blijayanino, bitamenino, bolijahanino, ilawa magobë, yabeninona, bu mata some kë wame moglëyobë ho belë sei mugujuwelëyome. Na somago wali mogo nalë tëtëkle mëtayame. ");
INSERT INTO nce_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Na iniwa oneho some këme gëglë mëglelëyome, sobo bome lowene sle egletëname nëgeme. ");
INSERT INTO nce_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Kwe Goto bu some tafa lëglelëyome na some hana kile lëgëtome. Na ho sobobë heven lifate magobë lale tafa hana tëbo mëgëtatëyome. ");
INSERT INTO nce_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Sobo kë tëbo olëna bome kë lowene sle egletënabë lowene asa elëkëlo. Sobo melë egelona kwe sobo tokwafe unaunalëme lale tafa egelome.” ");
INSERT INTO nce_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Na Jisas ita gali tle, “Sobo tokwafe mehwi egelona, wame home boblo mogotomabë enëne, Jerusalem lifate lukume fu mëgletlana na ini sabuwa mogotlana, kwe sobo këme lowene elome, kë lifate tëbo lëglebë olë ekë fata lëlefe. ");
INSERT INTO nce_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Na kë olëna, Judia provins mëta kë tafa mëglabë oneho, bu fatiniwa matlëbouja. Na Jerusalem lifate mëta kë tafa mëgelulabë oneho, bu kë lifate kile mlame na jebelëme mëlëboujame. Na Jerusalem lifate li mëta kë tafa mëglabë oneho, bu lifatewa ita asa matëkakluja. ");
INSERT INTO nce_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kë nalë, Jerusalem lifate enëneme, memelë tëbo lowene kë mëglabë enëneme Goto tëbo logotomeme. Na iniwa gali, bu Gotobë bogo mëta kë yahi mëtëglabë, bu iniyafemu mefata mëgleme. ");
INSERT INTO nce_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kë olëna, one nëbale imo nabë na one nëbale kolëbo nabë, bo bume tako maninibo nanëletemëmu. Masiwafe, bu habëna mëglënëboujamene? Tëbo olë, kë onehome fata lëgletëmeme. Na Goto bu kë onehome wame loglomeme na tëbo logotomeme. ");
INSERT INTO nce_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Na wame home boblo mogotomabë enëne bu flime mogo nalë tëbo motomame. Na iniwa tatako lifate ebë life mëta kë mëgëbagubë lifate elë flime mëlelumame na kalabusu lowa sike mokoujame. Na li lifate mago wame enëne, na Gotome lowene jwa kë mëgletlabë enëne, bu Jerusalem lifate hijika motomame na yelukwafe tuku mlame. Bu Jerusalem lifate mana bubë yelukwafe mëta mana lëgebetëmebëë, na mana Goto bume gali lolomeme, ‘Sobo emago eyeu.’ Na bu kë lifate kile motlame na mujame.” ");
INSERT INTO nce_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jisas ita gali tle, “Kë nalëwa, tetëbo klelegowa wesibi, kliji, yeme, sëgetobana mëta fata mëgleme. Na iniwa lifate mago oneho, bu nutubë tako liglinitigo lego aholokwane mëglana, kwe bu tako tutune mëglame na tako ulimu mëglame. ");
INSERT INTO nce_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Na feilawa oneho, iniwa tëbo wesibi kë lifateme kë fata mëglebëme tako tutune mëglame. Na bu tako uli mëglame na nabasahoba mlame na mogowa mitigwëyame. Iniwa matafa mago wesibi lili mëgleme nëgeme na bu këme uli mëglame. ");
INSERT INTO nce_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Na kë nalë, iniwa oneho bu bome, Gotobë life mago home, mehwi mogloname, bo oloba nagi nigisime. Na bo tako lolokwënena, na tako kliji elulego fenene këhana nigisime. ");
INSERT INTO nce_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Sobo kë tëbo wesibi hwi eglomona, kwe sobo këme uli asa elo, walena satafa elo. Goto some nëno lëglebë olë nounou lëgleme nëgeme.” ");
INSERT INTO nce_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jisas waflë gali tlome, “Sobo binibwe time na fli time walowene eletemo. ");
INSERT INTO nce_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bubë laba luklu mëglena na tahweji foke mëglena sobo këbëme lowene eletelo, ‘Ebë wanagli tei fe.’ ");
INSERT INTO nce_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kë fenene. Sobo kë tetëbo wesibi, hwi eglomona, sobo melowene naegelome, ‘Goto iniwa onehobë eso home natafa lëgletëmebë olë nounou lalëletle.’ ");
INSERT INTO nce_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Bo some nëgali gali nanëlëyo, fli oneho bu ebë olëna kë tafa mëglabë, bu mana mëtabëyame na kë iniwa tetëbo wesibi, mana fata mëleme. ");
INSERT INTO nce_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Lifena matafana tëbo mëgleme, kwe bobë gali unaunalëme melë lëbagukëfeme.” ");
INSERT INTO nce_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Jisas ita gali tlome, “Sobo ululu sle saelo. Sobo bia na fli biaha wesibi itaita asa hihi elo na këna yaya elome. Na sobo sobobë ato lëgaitalebë wesibime feilawa tutune asa elo. Sobo këha lowene mëta tafa eglekefona kwe bo kë nigisibë olë bu some hokweinawa tafu lotokwakijome, ");
INSERT INTO nce_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","kole bu klelime fene tafu etole. Kë olë li life li life mago onehome iniwa, lafatawa lokoutëmeme. ");
INSERT INTO nce_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Sobo olëli olëli walena satafa elekefo. Na sobo Gotome olëli olëli takune elokweflome, bu some lëgaito nalëgleme na bubë afutuku some lëlëyome. Na tokwafe kë tëbo wesibi somëta, fata mëglena kwe sobo kë afutukuna lalowa boblo egotomome na bu some hana tëbo mëgëtome. Na sobo tokwafe, bome, Gotobë life mago hobë naba lime, tiniji jwa naeglibetëname.” ");
INSERT INTO nce_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Na iniwa olë, Jisas tako lotu lo mëta onehome okokwe latlokwefëme. Kwe klabëye, bu Oliv tiwa fatini mëta ni tubekëfe. ");
INSERT INTO nce_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Na iniwa oneho, bu olobalë mu, tako lotu lowa mutujukefëya, bubë gali aholokwane namoglolame. ");
INSERT INTO nce_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Israelbë ilawa magobë tako lotu olë fata lëgletëmeme nounou tletëme. Israelbë afenëbo, bu kë lotu olëna, sëse wesibi jwa bletë nage hi mëtlekefëya. Na bu kë lotu olë, Goto ëtani bosemlenime këna tëgaitamebë olë na Isip lifate këna kile mëtëglabë olë, lowene mëtlekefëtla. ");
INSERT INTO nce_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Na lotu lome wege mëglabë eso enëne na Gotobë galime okokwe moglomabë ho bu onehome uli mëtletëmame nëgeme na bu blalo gali këme fa mototla, Jisasme hwelutuwa mogo nalë tëkle namogotlame. ");
INSERT INTO nce_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Judas Iskariot na fli we ita jowa (11) hona, bu Jisasbë lowene esogo mëglelëtlabë ho. Na Satan bu Judasbë lowenewa tëkaklu tle. ");
INSERT INTO nce_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Na bu lotu lome wege mëglabë eso enëneme na lotu lo magobë plismanëme këme tuju tëme, Jisasme yo naloglomebë galime gëgali nalëglelëmeme. ");
INSERT INTO nce_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Na kë enëne bubë gali aholokwane motlolabëë na tako fleflesu memëtletlamu na bu buna gali sle mototla, bume baliti tokwafe namëglëlabëme. ");
INSERT INTO nce_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Na Judas bubë galime helawa tletëme. Na bu këme melowene tle, “Bo Jisasme habelë yo noglomëmene?” Bu melowene tle, “Lebutako oneho Jisasna mëtabëya jwa mlame na bo Jisasme mana yo nolomëme.” ");
INSERT INTO nce_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Sëse tabo wesibi jwa bletë nage kë hi mëtlekefëyabë olë wafata tletëme. Kë olëna Israelbë afenëbo, bu sipsip kleli nëbale tëtëkle mëtëtakefëya na hihi mëtla. Hihi mëtlekefëyabë, na Goto, bubë bosemlenime këna taitamebë olë lowene mëtlekefëtla. ");
INSERT INTO nce_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Këme nëgeme Jisas Pitaname, Jonname gali tlome, “Sobo eyeumo na tako lotu olëbë hi wesibi loko eoutome. Sebo hi nanëglame.” ");
INSERT INTO nce_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Na tlemalë bume gali motlolo, “Sebo kë hi wesibi hameta loko nëgëtomene?” ");
INSERT INTO nce_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Na bume gali tlome, “Sobo Jerusalem lifatewa eyeume. Na ho li, sospenëna tu lëgehilena some alëgeme esune lëglëyome. Na sobo bume nagi elëkaklome. Na bu lowa lëkakluna, sobo mata kë lowa ekaklujome. ");
INSERT INTO nce_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Na kë lo bolijaya home megali egelujuwelëlome, ‘Sebobë tisa bu megali lalële, “Hi lo hametane? Bona, bobë lowene esogo mëglelëtënabë hona, kë hi lo mëta, sipsip kleli hi nanëglelëmëme, Goto bu sebobë semleninome këna taitamebë olë, lowene nanëgletlame.” ’ ");
INSERT INTO nce_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Na kwe bu some matawa kë ke logolebë lo ke lebotane lëgëtatëyome. Kë lo bu tafa labuna, na maseina. Sobo kë hi lo mëta sebobë hi wesibi loko etome.” ");
INSERT INTO nce_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Na bu tlemalëme mana jine telëkakëme. Na bu tako lifatewa mëtëyeu. Na bu iniwa wesibi hwi motlomo, Jisas fene gali tlome. Na bu hi wesibi sagli motlolo. ");
INSERT INTO nce_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Hi olë fata tle, na Jisas matawa kë ke logolebë lo ke masei mëta tafa tle. Na bubë gali tëme kë jine tëglëmebë ho, buna iniwa tafa mëtla. ");
INSERT INTO nce_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Na bume gali tlome, “Bo ebë hi wesibi sobona hi nëglame, tako tole nanelë, Goto, sebobë semleninome këna tëgaitamebë olë lowene nanëgletlame. Bo sobona ebë hi wesibi afina hi nëlame, na tokwafe bo elili mana fa nogotlëme. ");
INSERT INTO nce_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Bo some gali nolëyo, bo sobona ebë tako lotu olëbë hi wesibi ita hana hi nëglame. Kwe tokwafe, Goto iniwa onehobë eso home tafa lëgletëmebë olë fata lëglena, ebë tako lotu olë hi nëglabë wayo mana olafa lëgleme. Na bo ebë tako lotu olëbë hi wesibi ita mana hi nëgelëme.” ");
INSERT INTO nce_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Na bu wain taba liji tuna kabo fa tëtamë na Gotome gali tlole, “Ebë wain taba liji tu, yaha fëyeme enënane?” Na bu gali tlome, “Sobo ebë tu fa etlome na sobo lalo hi ekoujome.” ");
INSERT INTO nce_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Bo some gali nolëyo, bo wain taba liji tu eliwa sobona tei hi nëla. Kwe tokwafe Goto bu onehobë eso home tafa lëgletëmebë olë fata lëglena kwe bo wain taba liji tu mana ita hi nëgelëme. ");
INSERT INTO nce_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Na bu bletë nage fa totle, na Gotome gali tlole, “Yaha fëyeme enënane?” Na fufu totle na bubë lowene esogo mëglelëtlabë home sa tëtatëme. Na gali tlome, “Ebë bobë atome lëlekuju ne. Bobë ato kë nëglëyobë some lëgaitome. Sebo ebë bletë nage fene hi nëla, sobo itaita melë sa elekefo, bome lowene eglekefëtënabëme.” ");
INSERT INTO nce_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Bu bletë nage wahi mëtla, na bu wain taba liji tu kabo fa tëta na bletë nage fene tlëme ita metlëme tle. Na bu gali tlome, “Ebë bobë winome lëlekuju lële. Bobë wino kë lugujubë, some lëgaitome. Ëtani Goto bu Mosesme megali sle latlole, Israelbë afenëbome lëgaitameme. Kwe bobë wino kë lugujubë këme lëlekuju lëgleme, Goto bu bubë onehome tiho gali sle tëtatëme, bume lëgaitame nalëglebëme. ");
INSERT INTO nce_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Sobo aholokwane elo, bome wame ho belë yo loglonëbë ho bu sebona ebë masei mëta weife tafa nëla. ");
INSERT INTO nce_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kwe bo, Gotobë life mago ho, bo gli nëgelëme, Goto ëtani fene gali tle. Kwe kë ho bome kë yo loglomebë, masiwafe, bu tëbo liglitame.” ");
INSERT INTO nce_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Na bubë lowene esogo mëglelëtlabë ho kë gali yafe aholokwane motlola, na blalo tëtakune mëtlelogwaya, “Melë yalë logotlemene?” ");
INSERT INTO nce_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Na kwe bubë lowene esogo mëglelëtlabë ho bu blalo momata mëtlelogwaya, “Semago, logouta home, ya tafa lëlene?” ");
INSERT INTO nce_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Na Jisas bume gali tlome, “Israelbë afenëboni mëtabëya jwa mëglabë enënebë eso ho, bu memelë lamla, onehome baba tei motoma. Na bu metole lamla, oneho bume megali molomame, ‘Sebobë lale lakalena letitabo ho.’ ");
INSERT INTO nce_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kwe, kë eso ho fene mëtabëya, sobo këha lowene asa fa etatemo. Weye. Matëbe. Ho li somago logouta home tafa lëglebëme tole lëglena kwe bu melë salëletëyo, atwati hoha lëtabeme. Na sobobë eso ho bu melë salëletëyo, some wegeme lëgaito hoha tafa lëletëyome. ");
INSERT INTO nce_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Sobo walowene elo. Mogoutayame kë tafa mëglabë ho, bu memelë lamla, bu masei mëta wege jwa tafawa tei lële na bubë wege ho hi wesibi tobanawa mehweitëma na masei mëta gogwa mëkakitëma na bu mana hiwa lële. Bo kwe, këha hana nëletëyo sobobë ku mëta. Bo some wegeme nëgaito hoha nëtabetëyo. ");
INSERT INTO nce_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Tëbo wesibi bome kë susu mëtëtanëbë, kwe sobo bona tafa tla na hana kile tëtana. ");
INSERT INTO nce_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Bobë aya bu bome meaniji latlonë, onehobë eso home tafa nëgletemëme. Na kë fenene bo some këme aniji nolëyo, onehobë eso home bona tafa nanëgletëmame. ");
INSERT INTO nce_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Na bo tokwafe onehobë eso home tafa nëgletemëna, sobo bona bobë masei mëta tafa nëglame na hi wesibi hi nëlame. Na sobo eso hobë tafa labu mëta tafa egelome, na sobo Israelbë we ita tële iko nëbalebë bosemlenibë eso home tafa egletemome na bubë lowene mana hwi ebelëkakëtemome.” ");
INSERT INTO nce_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Na Jisas Pitame gali tlole, “Saimon, aholokwane ele. Satan bu Gotome watakune tlole, sobobë lowene feilawa susu nalogotometëyome. Bu mehwi naloglëyome, sobo bome kë lowene egletënabë lowene mëta mana tafa egelomene o aholokwana ti egelome. ");
INSERT INTO nce_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kwe bo Gotome, jume lëgaitame, wagali nololë, ju bome kë lowene egletenëbë lowene iniwa aholokwana ti jwa naegleme. Kwe tokwafe ju bome kë lowene egletenëbë lowene ita lowene egletlena, kwe juna kë tafa egelobë afanime, egaitameme, bu bome kë lowene mëgletënabë lowene aholokwana ti jwa namëglame.” ");
INSERT INTO nce_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Na Pita bume gali tlole, “O tako ho. Bu jume kalabusu lowa mëglelujona, kwe bo juna kalabusu lo mëta weife lalowa tafa nëgelulome na sebo weife lalowa gigli nëgelome. Bo kë wesibime uli hana nëletelë.” ");
INSERT INTO nce_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Na Jisas bume gali tlole, “Pita, bo jume gali nolë, eli klabë, kekelo gali jwa lëglena, ju bome kë lowene egletenëbë loweneme aowafe able eglomeme.” ");
INSERT INTO nce_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Na Jisas bubë lowene esogo mëglelëtlabë home gali tlome, “Ëbame bo some Gotobë gali tëme jine tëglëyona sobo baliti, musu, juba jibona hana tehojo. Na sobo kë tëgëyobë nalë, sobo wesibi jwa tafa tulone?” Na bume gali motlola, “Weye.” ");
INSERT INTO nce_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Na bume gali tlome, “Kwe eli, sobo baliti musuna, musumuna meegehojoegelome. Na ju wame kosi jwa nëgena kwe jubë heletabo gelowa ëho, li home balitina hihijikame elëleme na wame kosi kë balitina fa etleme. ");
INSERT INTO nce_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ëtani bu, Gotobë bogo mëta wayahi tle, ‘Oneho bume mehwi lamotlola, tëbo ho fenene.’ Na bo some gali nolëyo, tokwafe oneho bome këha melë mëgëtaname. Ëtani bu Gotobë bogo mëta meyahi mëtla, wesibi bome fata mëgletenëme, na kë wesibi bu iniyafe fata mëgleme ekëne.” ");
INSERT INTO nce_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Na bume gali motlola, “Tako Ho, hwi ele. Sebo wame kosi tële ekëne mëbetëna.” Na bu gali tlome, “Ta tei.” ");
INSERT INTO nce_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Na Jisas lifate kile tle na bu Oliv tiwa fatiniwa tokwale, bu itaita fene tokwakefle. Na bubë lowene esogo mëglelëtlabë ho bume nagi mëtlëla. ");
INSERT INTO nce_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bu kë belë fwa mutula, na bume gali tlome, “Sobo Gotome gëgali eglelëlome, some lëgaito nalëgleme na some su mëgëto wesibi somëta fata jwa namëgletëyome.” ");
INSERT INTO nce_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Na bume hune totome. Na ho aniji tuku lëkakeme, kë aniji egujuwetigwabë fenene Jisas këniji mefë latëkake. Na bu sëkefo miti tafa tle na Gotome mana gëgali tlelële, ");
INSERT INTO nce_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“O aya. Ju metole eglena kwe ju ebë tëbo wesibi bome kë fata mëgletenëbë, bo mago sike ekaketenëme. Kwe ju bobë tole asa esogo elelëtenë. Matëbemu. Jubë tolewa saesogo elelële.” ");
INSERT INTO nce_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Na heven life mago ensel bume tisi tle na bume taitale. ");
INSERT INTO nce_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Na Jisas bu tako maninibo latle na Gotome anisasanamu gëgali tlelële. Na bubë afeteni tu, wino fene mesësëbo tletle na life mëta toto tletle. ");
INSERT INTO nce_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Bu Gotome wagëgali tlelële, na huju tle, na bubë lowene esogo mëglelëtlabë ho betelë ita tuju. Na bume nina hwi tlome, bu tako hobota mëtletlame nëgeme këme ni mëtebëya. ");
INSERT INTO nce_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Na bume gali tlome, “Sobo fëyeme ni ebone? Sobo huhuju elome na Gotome gëgali elelëlome, some lëgaito nalëgleme na su mëgëto wesibi somëta fata jwa namëgletëyome.” ");
INSERT INTO nce_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisas mana gëgali tle na feilawa ho mana mitisitla na Judas kë enëneme toutatëme. Judas, ebë Jisasbë lowene esogo mëglelëtlabë ho li. Jisasbë lowene esogo mëglelëtlabë ho këniji, we ita tële. Na bu Jisasme loliwa tisi tle, bume sësle nalogotleme. ");
INSERT INTO nce_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kwe Jisas bume takune tlole, “Judas, ju bome, Gotobë life mago home, fëyeme sësle etanëne na këna wame home yo elomeme.” ");
INSERT INTO nce_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Na bubë lowene esogo mëglelëtlabë ho, buna kë tafa mëtlabë, bu këme hwi mëtla, bu Jisasme fa mogotlame nounou ekënefe. Na Jisasme këme takune motlola, “Tako ho, sebo bume wame kosina lalowa tëtëke nëglamene?” ");
INSERT INTO nce_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Na bu mago ho li, wame kosi ki tokoke, na lotu lome wege lëglebë letitabo hobë, wege hobë tobamu elë mago aholo sika metëtatle. ");
INSERT INTO nce_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kwe Jisas kë wesibi hwi tlole na gali tlome, “Matëbe. Eme fwa tou elo!” Na bubë toba kë hobë aholome gwa tëtatle na laslewa tëkaketle. ");
INSERT INTO nce_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jisasme fame kë mitisitlabë enëne bu melë, lotu lome wege mëglabë eso enëne na lotu lo magobë plismanë, na letitabo enëne. Na Jisas bume gali tlome, “Sobo kosina atobeilana bome fame esijone? Sobo melowene laletënane, ‘Bo tokli ho,’ ëëë?” ");
INSERT INTO nce_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Itaita, bo sobona tako lotu lo mëta kë tafa tëglekefëyabë na kë nalë sobo bome mana hana fa tëtana. Kwe sobo bome këna fa egëtanabë olë ekënefe. Satan bu tako afutukuna ekë lëtabe. ");
INSERT INTO nce_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jisas wagali tlome, na bume mana fa mototla na lotu lome wege lëglebë letitabo hobë lowa mëtlelula. Na Pita bume nagi hwiwa hwiwa tlagume. ");
INSERT INTO nce_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Na bu lotu lome wege lëglebë letitabo hobë lo li mago lëglesi elë tëkaklu. Na fli enëne bu kë mëta ahoju hoho mëtelula. Na Pita buna kë ahoju mëta sa mëtla. ");
INSERT INTO nce_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Na wege mëse bu Pitame hwi tlole, ahojume sa tle. Na kë wege mëse bume tëselële, na gali tle, “Kë ho bu melë Jisasna kë tafa mëtlabë ho.” ");
INSERT INTO nce_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kwe Pita bu able tle, “Mëse mëtabone. Bo kë home lowene hana nëletelëmu. Hanane mu.” ");
INSERT INTO nce_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Na bu sogë tafawa tle na ho li tëselële na megali tlole, “Ju mata, bubë lowene esogo tëglelëtelobë ho li.” Kwe Pita bu able metle, “Hanane mu. Bo bubë lowene esogo tëglelëtelëbë ho nane.” ");
INSERT INTO nce_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Bu tako tafaha tle na ho li anisasana gali tle, “Nëgalimu. Hwi elo. Bu mata Galili provins mago holife. Kë ho buna kë tafa mëtlekefëyabë ho.” ");
INSERT INTO nce_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Kwe Pita able tle, “Ju kë gali eglebë gali bo lowene hana nëletelëmu. Hanane mu.” Bu mana gëgali tle, na kekelo mana huju tle. ");
INSERT INTO nce_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Na Jisas swaya tletle na Pitame hwi telokwakle. Na Pita, Jisas kë gali toglolebë gali ita lowene tletle. Kë gali melë, “Eli klabë, kekelo gali jwa lëglena, ju bome kë lowene egletenëbë loweneme aowafe able eglomeme.” ");
INSERT INTO nce_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Na Pita bu able kë tëglebëme lowene tle na lo li mago lëglesi mago tëkakli, na tako ye kle totle. ");
INSERT INTO nce_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jisas lotu lome wege lëglebë letitabo hobë lo mëta tafa tle na bume kë fa mototlabë ho bume sosonatlëtlë memototla na bume tëkle mototla. ");
INSERT INTO nce_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Na bubë naba ëhona lamu mototometla na bume mana tëkle mototla na takune motlola, “Ju iniwa wesibi lowene egletëmena kwe ju seme gali sle enoname, jume ya tëke lolëne?” ");
INSERT INTO nce_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Na bume feilawa tiniji galina gali motlola. ");
INSERT INTO nce_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Oloba olë, onehobë gali aholokwane moglomabë letitabo ho, Gotobë galime okokwe moglomabë ho na lotu lome wege mëglabë eso enëne bu loko mëtlelëya. Na bu Jisasme, kë loko mëtlelëyabë enëne belë mëtlelutëma. Na kë enëne Jisasme takune motlola, ");
INSERT INTO nce_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ju seme gali enona, Goto kë aniji toglëbë ho, onehome nëno naeglebëme. Ju kë ho ekëne?” Na bu gali metafu tëtatëme, “Bo some megali noglëyona, ‘Bo kë ho ekëne,’ kwe sobo bobë gali lowene sle hana egletelome. ");
INSERT INTO nce_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Na bo some fli galime takune noglëyona, kwe sobo bobë gali hana tafu egëtatëname. ");
INSERT INTO nce_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kwe elina, unina, bo, Gotobë life mago ho, bo tako kalëlegona Gotobë tobamu toba elë tafa nëgelëme.” ");
INSERT INTO nce_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Na iniwa bume takune motlola, “Ju melowene lalene, ‘Bo Gotobë nëba,’ hee?” Na bume tafu tëtatëme, “Sobo nëgali gali gali elo. Bo ta kë ho ekëne.” ");
INSERT INTO nce_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Na bu gali mëtla, “Sebo fli enëneme hana gali noglomame, seme kë hobë tëbo loweneme gëgali namëglenëname. Sebo ëje bubë tëbo gali, bubë ëfalëbo mago waaholokwane nolotlame nëgeme.” ");
INSERT INTO nce_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Na kwe, kë onehobë gali aholokwane moglomabë letitabo ho, bu Jisasme eso ho Pailat belë mëtlelula. ");
INSERT INTO nce_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Na bu Jisas kë tafa lëglebë galime Pailatme megali motlola, “Ebë ho bu sebobë life mago onehobë wame lowene tufiji latotometëme. Bu megali latlome, ‘Sobo takis baliti, Rom life magobë eso ho, Sisarme, asa elëlo.’ Na bu megali latle, ‘Bo Goto kë aniji toglënëbë ho, onehome nëno nëgelëbë ho, bo kë eso ho.’ ” ");
INSERT INTO nce_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Na Pailat Jisasme takune tlole, “Ju Israelbë afenëbobë tako eso hone?” Na Jisas tafu tëtatle, “Nëgalife. Ju fene gali ele.” ");
INSERT INTO nce_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Na Pailat lotu lome wege mëglabë eso enëneme na oneho name gali tlome, “Bo ebë hobë, li fëye wesibiha, hwi hana nolotelë na bo manawa hana tëbo nogotlëme.” ");
INSERT INTO nce_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kwe bu bubë gali anisasana tafu mëtëtatla, “Bu Judia provinsbë, li life li life asë tëbelëfa na onehome okokwe latlagukefëme. Na bu iniwa onehobë wame lowene tufiji latëtagutëme. Bu Galili provins mëta okli tle na bu li life li life asë tëbelëfa na ebelë mana ekë lisi.” ");
INSERT INTO nce_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat kë gali aholokwane tlome na takune tlome, “Ebë ho, bu Galili provins mago hone?” ");
INSERT INTO nce_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pailat melowene tle, “Jisas Galili provins mago hofe. Bo bume Galili provins mago onehobë eso ho Herot belë jine nëgelëkaklëme.” Na bu Jisasme eso ho Herot belë këme jine telëkakle. Herot bu ëbame bubë provins kile tle na kë nalë Jerusalem lifateme esokwaneme tafa tle. ");
INSERT INTO nce_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Bu Jisasme Herot belë mëtlelula. Herot bu Jisas wesibi kë togotomebë gali waaholokwane tletle na bu anebo Jisasme hwi logloleme fene kwe bu hwi hana tlole. Këme nëgeme bu Jisasme hwi tlole na tako fleflesu këme tle. Bu metole latle, Jisas bubë naba lime klelegowa wesibi blëge blëge nalogotometleme. ");
INSERT INTO nce_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Këme nëgeme Herot bu Jisasme feilawa wesibime këme tëtakune tlole. Kwe Jisas bubë iniwa gali hana tafu totometle. ");
INSERT INTO nce_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Na lotu lome wege mëglabë eso enëne na Gotobë galime okokwe moglomabë ho eso ho Herotme loliwa mutuju tla na bu Jisasme blawa kë so mëtëtatlabë galime feilawa gali motlola. ");
INSERT INTO nce_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Na kwe Herotna bubë wame home boblo mogotomabë enënena Jisasme sisile lamototla na klëë galina gali motlola. Na eso ho fene mohweya, bu këha lale ëho bume mëtehwatla na bume Pailat belë ita jine mëtelëkakla. ");
INSERT INTO nce_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ëtani Herotna Pailatna gëglë lamëtlekefo. Kë olëna kwe yonanewa lamëtelo. ");
INSERT INTO nce_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Na Pailat bu lotu lome wege mëglabë eso enëneme na Israelbë afenëbobë eso enëneme na onehome gali telokwakeme na bu belë loko namokweijame na bu mëta loko mëtëkakija. ");
INSERT INTO nce_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Na bume gali tlome, “Sobo ebë home bo belë elesulo, na sobo megali lalona, ‘Ebë ho bu sebobë life mago onehobë wame lowene tufiji latotometëme.’ Na bo sobobë li mëta bume kë galime watakune slemu nololë. Kwe sobo aholokwane elo. Bo ebë hobë, li fëye wesibiha, hwi hana nolotelë. Bo melowene nanelë, ‘Sobo bume fene so etatelobë wesibi, bu melë hana totle. ");
INSERT INTO nce_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Na Herot bu mata, bubë li fëye wesibiha, hwi hana lolotle, na bu ebë ho sebelë ita këme jine lelëbakle.’ Aholokwane elo, ebë ho bu li fëye wesibiha hana totle na bo megali hana nëgelëme, ‘Bume lalowa, mogo nalë tëke elolo.’ Hanane mu. ");
INSERT INTO nce_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Këme nëgeme, bo bobë wame home boblo mogotomabë enëneme afina gali nolomëme, bume taba afona lëlafa motlame na bo mana jine nelëkaklëme.” ");
INSERT INTO nce_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kwe oneho iniwa anisasana gali mëtla, “Ju kë home mogo nalë tëke elole na ju Barabasme kalabusu lo mago jine elëbakëtëname.” ");
INSERT INTO nce_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas, ëtani, fli onehobë wame lowene tufiji tëtatëme, na bu gavman enëneme tako wame lamotloma, Jerusalem lifate mëta. Na bu kë nalë, ho lime mogo nalë tëke tlole. Na gavman enëne bume kalabusu lowa këme tuku mëtla. ");
INSERT INTO nce_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Kwe Pailat metole latle, Jisasme jine lëgelëkakleme. Këme nëgeme ita gali tlome, Jisasme jine nalëgelëkakleme. ");
INSERT INTO nce_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kwe bubë gali aholokwane hana motlola na anisasana gali mëtla, “Bubë ato ti mëta nilina bu eletelo! Bubë ato ti mëta nilina bu eletelo!” ");
INSERT INTO nce_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Na bume ita gali tlome, “Sobo kë gali fëyeme gali elone? Bu fëye tëbo wesibi totlene? Bo ebë hobë, li fëye wesibiha, hwi hana nolotelë na bo megali hana nëgelëme, ‘Bume lalowa, mogo nalë tëke elolo.’ Hanane mu. Këme nëgeme, bo bobë wame home boblo mogotomabë enëneme afina gali nolomëme, bume tëklewa namogotlame na bo mana jine nelëkaklëme.” ");
INSERT INTO nce_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kwe bu Pailatme itaita anisasanamu gali motlola, “Bubë ato ti mëta nilina bu eletelo!” Na Pailat bubë wame gali yafe aholokwane tlokwefëme na bu kwasa metletëme na melowene tle, “Matëbe. Bu melë matotla.” ");
INSERT INTO nce_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Këme nëgeme bu bubë lowenewa esogo tlelëtëme na gali tle, “Jisas gli malële.” ");
INSERT INTO nce_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Na Pailat, Barabasme, kalabusu lo mago tuhu totle na jine telëkakëtëme, bu fene gali molola. Barabas, ëtani, fli onehobë wame lowene tufiji tëtatëme na bu gavman enëneme tako wame lamotloma. Na kë nalë bu ho lime mogo nalë tëke tlole. Na gavman enëne bume kalabusu lowa këme tuku mëtla. Na oneho fene tole mëtla, bu Jisasme bubë wame home boblo mogotomabë enënebë toba elë gwa tetokwaketëme. ");
INSERT INTO nce_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Na wame home boblo mogotomabë enëne Jisasme lifeku mago mëtlelula, na bu Sairini lifate mago Saimonme alëgeme esune mëtlëla. Saimon bu waluju mago Jerusalem lifatewa tuju fene kwe bume fa mototla na bu Jisasme këme bu mëglabë ti, bubë feiji mëta gwa mototatla na gali motlola, “Se! Mana ehule na Jisasme nagi elëkakleme.” Na bu ti fejina nagi esogo tlagule. ");
INSERT INTO nce_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Na lebutako oneho bume nagi esogo mëtlagula. Na lebutako one bu yena esogo mëtlagula. ");
INSERT INTO nce_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Kwe Jisas bume swaya tletëme na gali tlome, “Sobo, Jerusalem lifate mago one, sobo bome asa ye eletëna. Matëbe. Sobo some fwa ye elome na sobobë nëbaleme fwa ye eletemome. ");
INSERT INTO nce_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tokwafe, li tëbo olë fata lëgleme. Kë tëbo olë fata lëglena, kwe bu megali mëglame, ‘One nëbaleme yoneti mëglabë bu fleflesu mëglame.’ ");
INSERT INTO nce_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kë nalë, oneho megali mëglame, ‘Sebo metole nanëla, ebë fatini kwe seme tëtafu matla na lamu matëtana, hokweinawa gigli nanëglame na wame ho seme tëbo jwa namëgëtaname.’ ");
INSERT INTO nce_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Bo li fëye wesibiha hana telë kwe bu bome manawa tëbo mëtana. Bu bome melë mëtanana kwe bu Jerusalem lifate mago enëneme, memelë tëbo lowene mëta kë tafa mëglabë, tako tëbomu mogotomame.” ");
INSERT INTO nce_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Na wame home boblo mogotomabë enëne, bu tlemalë memelë tëbo lowenebë home mata mëtleluma. Bume, Jisasname mogo nalë tëtëke namëglame. ");
INSERT INTO nce_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Na bu li lifekuwa fwa mutula. Kë lifeku weniji melë, “Eso Elebo.” Na kë fatini lufu mëta wame home boblo mogotomabë enëne Jisasme ti mëta bu mëtla na bu Jisasme kë ti magowa lë mototla. Na bu kë tlemalë memelë tëbo lowenenabë home bubë li mëta mata ola mëtla. Li tobamu toba elë tlibetle na li yemane toba elë tlibetle. ");
INSERT INTO nce_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Na Jisas ti magowa gali tëtëkeke, “Aya, ju ebë enënebë tëbo lowene, bome mogo nalë kë tëke moglonabë lowene, aholokwana ti eletëme. Bome melë kë mëgëtanabë wesibi, lowene sle jwa mëgletlame nëgeme.” Na wame home boblo mogotomabë enëne bubë ato mago ëho blalo melëna sa mëtëtaya. Bu satu salë mëtla na ho mana aniji motloma jowa jowa wesibi glo namëglabëme. ");
INSERT INTO nce_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Oneho bu mana hwiwa motlokwefëma, na kwe Israelbë afenëbobë eso enëne, Jisasme mana sosonatlëtlë memototla na gali motlola, “Bu fli home taitame. Na bu ebë ho nëgebë kwe Goto bume kë aniji toglolebë, onehome lëgaitameme na nëno lëglebëme, kwe bubë ato lëgaitaleme fene.” ");
INSERT INTO nce_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Na wame home boblo mogotomabë enëne, bu mata, bume sosonatlëtlë memototla. Na bu loliwa mutuju tla na bume kaya tabo wain taba liji tu mëglëla namëglame fene. ");
INSERT INTO nce_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Na gali motlola, “Ju Israelbë afenëbobë esoho nëgebë kwe jubë ato mana aitale.” ");
INSERT INTO nce_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Na bu gali ti ka tabo mëta yahi mëtla na Jisasbë eso lufu elë fla mototatla. Bu kë mëta meyahi lamëtletla, “Israelbë afenëbobë tako eso ho.” ");
INSERT INTO nce_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jisasname iniwa kë bu mëtëglabë tëbo lowenenabë ho li, Jisasme tiniji galina megali tlole, “Ju melowene lalene, Goto jume kë aniji toglëbë hone, hee? Hanane mu. Kwe melëbë kwe jubë ato aitalëme na seme mata aitanome. Kwe hanane.” ");
INSERT INTO nce_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kwe li tëbo lowene ho, libë gali aholokwane tlole na bume wame gali metlole, “Tokwafe Goto jume kë tëbo lëgëtabë wesibime ju uli jwa fëyeme elene? Ju hwi ele, bu seme iniwa tëtëkle mëtana. ");
INSERT INTO nce_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kwe bu seme kë tëtëkle mëgëtanabë kë kwe lalowa, bu sebobë memelë tetëbo lowenebë niji tëtëkle mëtana. Kwe ebë ho kë nëgebë, bu li fëye wesibiha hana totle bume blawamu tëkle motla.” ");
INSERT INTO nce_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Na bu Jisasme gali tlole, “Jisas, ju unina eso home tafa eglena kwe ju bome aholokwana asa ti ele.” ");
INSERT INTO nce_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Na Jisas bume gali tlole, “Bo jume nëgalime gali nolë, eli ju bona heven lifeme weife tafa nëgelome.” ");
INSERT INTO nce_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Kliji ku mëta tlibe na kliji ki tetëfatle na tlukufiniwa tëbe. Na këha tëgemowagulebëë na taboklë klijina ita fetiha tëbe. Na kë tako ëho, bu tako lotu lo ino mëta këkesi tëgelulebë, lakawa tëmalita kufe lokwati. ");
INSERT INTO nce_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Na Jisas anisasanamu afëflei tle, “Aya, bo bobë amtëtomba jubë toba elë ekë gwa netëfaklë.” Bu megali wafi tlole na tuku tëkakë. ");
INSERT INTO nce_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Na wame home boblo mogotomabë enënebë eso ho, bu këme hwi tle na Gotome fleflesu tletle na bibita totle na gali tle, “Nëgalimufe. Ebë ho bu lale ho fe. Bu li fëye wesibiha hana tëbo totle.” ");
INSERT INTO nce_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Na oneho kë hwime kë mitisiyabë, Jisas kë gli tëglebë yafe hwi motlola na bu tako maninibo memëtla na bubë lo elë ye motokouja. ");
INSERT INTO nce_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Na Jisasbë yabe enëne na Galili provins mago Jisasna kë mitisiyabë one, bu kakëha mëtelibukëya na iniwa wesibi hwi mëtelëkakëma. ");
INSERT INTO nce_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Arimatea lifeku mago ho bu kë mëta tëtabe. Bubë weniji Josep. Arimatea bu Judia provinsbë li lifeku. Bu lale homu. Bu, Goto iniwa onehobë eso home kë tafa lëgletëmebë olëbëme, hwi lëglekëfebë. Bu onehobë gali aholokwane moglomabë letitabo ho li. Kwe bu onehobë gali aholokwane moglomabë letitabo ho flibë lowenebëme, Jisasme mogo nalë kë tëkle mototlabë lowenebëme, helawa hana tletëme. ");
INSERT INTO nce_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Na Josep eso ho Pailatme tuju tle na takune tlole, “Bo Jisas mogome ti mago lalowa tohwa nogotlëmene?” Na Pailat gali tlole, “Lalowa tohwa etle.” ");
INSERT INTO nce_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Na kwe Josep Jisas mogome ti mago tohwa tëtetëbakle na bu lale tatiwa ëho heletabona lei totle na tehule na tiho aniji fuluju matëmatë mëta gwa tujuwetle. Kë aniji fuluju, ho tabana go mëtlelëya. ");
INSERT INTO nce_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Bu Fraide taboklë mu, Jisas mogome gwa totle, na bubë tafawa mëglabë olë nounou watletëme. ");
INSERT INTO nce_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galili provins mago Jisasna kë mitisiyabë one bu Josepme esogo mëtlagula na bu kë aniji fuluju matëmatë hwi motlëya na bu mata Jisas mogome këme kë gwa tëgelujuwetlebë tala hwi motlola. ");
INSERT INTO nce_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bu wahwi motlola na mana bubë lowa mutuja. Na lëkaluwa welë tu na fli lëkaluwa wesibi sle mototoma, Jisas mogome këna tefo namogotlame. Na tafawa mëglabë olë bu tafawa mëtla, Moses bu ëtani fene gali tle. ");
INSERT INTO nce_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sande, olobalëwa mu, one bu matëmatëwa mutuja. Na lëkaluwa welë tu na fli lëkaluwa wesibi mata mëtehouja. ");
INSERT INTO nce_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bu matëmatëwa fwa mutula na mehwi mëtla. Matëmatë ëfo kë tiji mëtlabë aniji waobobwelë mëtagujayafe. ");
INSERT INTO nce_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Na bu kë aniji fuluju matëmatë elë mëtëkakluja. Kwe bu Jisas mogome hwi hana mëtelujelëla. ");
INSERT INTO nce_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Na melowene mëtla, “Jisas mogo hameta lëbene?” Bu lowene mëtlabëë, na tlemalë ho, bubë lime lamitlikakijowa. Bubë ëho kliji fene u mëtletëme. ");
INSERT INTO nce_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Na kwe one bu tako ulimu memëtla na laibibuwa mëtla. Kë ho bume gali motlomo, “Sobo tuja ato home, gigli enënebë tala mëta, fëyeme hohwi etatelone? ");
INSERT INTO nce_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Bu eme hana lëtabe. Bu wahuju lële. Bu some Galili provins mëta kë gali toglëyobë gali ita lowene egletelome. Kë gali melë, ");
INSERT INTO nce_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Bu bome, Gotobë life mago ho, Gotome lowene jwa mëgletlabë enëneme yo moglomame, bome ti mëta bu namëglame. Na bo matëmatë mëta tële olë nebëme kwe aona olëbëna huju nëgelëme.’ ” ");
INSERT INTO nce_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Bu tlemalë hobë gali aholokwane mëtla na bu ëbame, Jisas kë gali tëglebë gali ita lowene mëtletla. ");
INSERT INTO nce_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Na bu matëmatë mago mëtëkaklija na ita mutuja. Na bu kë hwi motlomabë wesibi gali, Jisasbë lowene esogo mëglelëtlabë we ita jowa home, na fli onehome, të mututatëma. ");
INSERT INTO nce_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Makdala life mago Maria, na Joana na li Maria, Jems bota, na buna kë tafa mëtlabë fli one, bu kë galime, bubë gali tëme kë jine tëglëmebë home yafe gali motloma. ");
INSERT INTO nce_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kwe bubë gali tëme kë jine tëglëmebë ho bu melowene mëtla, “Bu sogëname gali molonafe.” Na bubë gali aholokwane hana motloma. ");
INSERT INTO nce_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kwe Pita hujuwa tëglebë na matëmatëwa fëka tokou. Na bu blou tle na hwi telukwake na bume këna kë lei mototlabë ëhowa hwi tlotle. Na kwe bu ita lowa tugujuna lowene fafa tëtagule. ");
INSERT INTO nce_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kë olë nawa, tlemalë ho, Jisasme kë esogo mëtlelëlobë, Emeus lifeku elë mëtëyeu. Emeus lifeku bu Jerusalem lifate kakëha lëbe. ");
INSERT INTO nce_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tlemalë bu mëtëyeubëë na bu iniwa kë fata mëtëglebë wesibime gëgali motokoujo. ");
INSERT INTO nce_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bu gëgali motokoujobëë na mana Jisas lafatawa tletëme na buna iniwa mutuja. ");
INSERT INTO nce_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kë tlemalë bume hwi motlolo kwe bume mëtëselëlo sle hana mëtelo. Goto bubë mëtëselëlo sle lowenebë obwelë latëtatëme na mëtëselëlo sle jwa këme motlolo. ");
INSERT INTO nce_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Na Jisas kë tlemalë home takune tlome, “Sobo kë egisijobë, fëye wesibime gëgali ekweijone?” Bu megali watle, na tlemalë mana mitlibo na wabelë mëtletelo. ");
INSERT INTO nce_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Na bu mago ho li, bubë weniji Kliopas, gali tlole, “Lebutako li life li life mago oneho, Jerusalem lifatewa esokwafe nime fwa mitisiya. Kwe ju Jerusalem lifatewa tokwafe ekë esine. Na juwa kë lifate mëta kë fata mëtëglebë wesibi lowene jwa këme eletëmene?” ");
INSERT INTO nce_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Na Jisas bume takune tlome, “Fëye wesibi Jerusalem lifate mëta fata mëtlene?” Na tlemalë metafu mëtëtatelo, “Sebo, Nasaret lifate mago Jisasme kë fata tëgletlebë wesibime gëgali nokweijo. Bu Gotobë lowene mago gali të totokweflebë homu na bu Gotobë afutukuna klelegowa wesibi blëge blëge totokwefëme. Bu kalëlego gali të totokwefle ho. Gotona, iniwa oneho mata, melowene lamëtletla, ‘Bu lale homu.’ ");
INSERT INTO nce_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kwe sebobë lotu lome wege mëglabë eso enëne na sebobë fli eso enëne, bume gavmanme yo motloma, na bu gali fa mëtëtatla, bume mogo nalë tëke namoglolame na bume ti mëta bu mëtla. ");
INSERT INTO nce_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Sebo ëbame melowene latletla, ‘Jisas kë nëgebë kwe Goto kë aniji toglolebë ho, seme Israelbë afenëbobë wame hobë mago nëno nalëgleme.’ Na li gali mata lalëbe. Bu mogo nalë kë tëkle mototlabë, aona olë wamujutle. ");
INSERT INTO nce_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Na ëje olobalëwamu semago one fli matëmatëwa muja na bu Jisas mogome, hana hwi molola. Na bu misiya na seme megali lamolona, ‘Sebo, enselme fwa hwi noloma na bu megali lamla, “Jisas tuja ato mana lëtabe.” ’ One seme kë galime gali molona na sebo klelego menëletëma. ");
INSERT INTO nce_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Na semago ho fli, bu mata matëmatëwa muja, na one fene gali mla, bu mata Jisas mogome hwi hana mujuwelëla.” ");
INSERT INTO nce_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Na kwe Jisas tlemalëme gali tlome, “Sobo yaya fëyeme eletelone na Gotobë lowene mago gali të mototlabë hobë iniwa gali lowene sleme tole jwa fëyeme eletelone? ");
INSERT INTO nce_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Gotobë lowene mago gali të mototlabë ho, bu ëtani Gotobë bogo mëta meyahi lamëtla, ‘Goto kë aniji toglolebë ho, onehome nëno lëglebë ho, bu elili afina fa lotleme na mana Goto bume iniwa afutuku lëlelëme na bu Gotona onehobë eso home weife tafa meletemome.’ Sobo kë gali lowene sle jwa fëyeme eletelone?” ");
INSERT INTO nce_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Na iniwa wesibi bume, Gotobë bogo mëta kë yahi mëtletlabë, bu kë wayo galime okokwe tlome. Bu ëtanifu ho, Mosesbë gali wayome afina okokwe tlome na Gotobë lowene mago gali të mototlabë hobë gali wayome mata okokwe tlome. ");
INSERT INTO nce_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bu mutujabëë, na tlemalë këme ni mëgebobë lifeku loliwa fwa mutula. Kwe Jisas, luguju lugujuwa nalëgleme fene. ");
INSERT INTO nce_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Na kwe tlemalë bume lëkle mototlo, na gali motlolo, “Eguju egujuwa asa ele. Kliji walëtetigo na ki lëgebeme ekëne. Ju sebona eme ni nebëya.” Këme nëgeme bume lowa mëtlelulo. Na buna lowa mëtëkakluja. Na tafa mëtelula. ");
INSERT INTO nce_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Na buna hi mëglabë masei mëta tafa mëtla. Na bu bletë nage fa totle na Gotome yaha gali tlole, “Ebë bletë nage yaha fëyeme enënane.” Na bletë nage fufu totle na kë tlemalëme tlëme. ");
INSERT INTO nce_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Bu melë tëglena, na bubë lowene titika tëtatëme na mana bume mëtëselëlo sle mëtelo. Na bubë naba li mago laëhowa tëkaketëme. ");
INSERT INTO nce_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Na buwa gëgali mëtelo, “Sebo buna ëje alëgeme gëgali nokweijana, na bu Gotobë bogo mago wayo gali seme të lëtatenona kwe sebobë lowene klelego memeleteno na sebo tako fleflesu menelo.” ");
INSERT INTO nce_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bu megali mëtelo na fowa motokokobë na ita Jerusalem lifatewa lafëkawa mëtëkoujo. Na bu Jisasbë we ita jowa lowene esogo mëglelëtlabë ho na buna kë loko mëtlelëyabë onehome hwi mutujuwelëmo. ");
INSERT INTO nce_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Na kë enëne bu tlemalëme gali motloma, “Nëgalimufe. Jisas matëmatë mago, wahuju lëlefe na Pita wahwi lololefe.” ");
INSERT INTO nce_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Na tlemalë bume alëgeme kë fata lëgletëmebë wesibime gëgali mëtlelëmo. Na bu gali mëtelo, “Bu bletë nage fufu lëtatenona sebo bume mana nëselëlo sle nelo.” ");
INSERT INTO nce_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kë tlemalë ho mana gëgali mëteloo na mana Jisas bume ku mëta lafatawa tletëme. Na bu megali tlome, “Sobobë lowene lëgëbetëyo sle malëletëyo.” ");
INSERT INTO nce_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Kwe bu meweniji lamëtla, “Alibahofe,” na bu këme tako uli memëtla. ");
INSERT INTO nce_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Na Jisas bume gali tlome, “Sobo klelego fëyeme elone? Sobo tutunena fëyeme tafa elone? ");
INSERT INTO nce_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Sobo bobë toba yayahuju na juba yayahuju hwi elokwakimetëna. Ebë bo tekwe nëge. Sobo bobë ato lu etokwakilo lowene naegelome bo afabona, elebona nëtabë. Sobo lowene lalo, alibaho bu afabo jwa na elebo jwa mëtabëya bu kwe fleluwa.” ");
INSERT INTO nce_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Bu megali tle na bubë toba yayahuju na juba yayahuju bume lebotane totometëme. ");
INSERT INTO nce_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Na bu klelego memëtletla na tako fleflesu memëtla kwe bu lowene sle hana mëtla na melowene mëtla, “Ebë Jisas nawa, alibaho nawa.” Na Jisas takune tlome, “Sobo hi wesibi fli mana mëbetëyone?” ");
INSERT INTO nce_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Na bume muniji mo lëne fa mëtëtatla na mëtlëla. ");
INSERT INTO nce_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Na bu hilika totome na bubë naba li mëta hi tletëme. ");
INSERT INTO nce_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Na bume gali tlome, “Ëtani bo sobona mana tafa tëglana bo some megali latlëyo, ‘Iniwa wesibi, ëtani Moses na Gotobë lowene mago gali të mototlabë ho, bome kë yahi mëtletënabë na Buk Song mëta kë yahi mëtletënabë bu kë iniwa wesibi fata mëglememu.’ ” ");
INSERT INTO nce_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Na bubë lowene ha totometëme, Gotobë bogobë wayo gali iniwa lowene sle namëgletlame. ");
INSERT INTO nce_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Na bume gali tlome, “Gotobë bogo megali lalamë, ‘Goto kë aniji tlolebë ho, onehome nëno nalëglebë ho, bu elili fa lotleme na gli lëleme na bu matëmatë mëta tële olë lëbeme na aona olëbëna kwe huju lëgleme. ");
INSERT INTO nce_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Na bu bubë wenijina iniwa life mago onehome gali të mëgëtagutëmame, bubë tëbo lowene aholokwana ti namëglame na Gotobë lale lowenewa esogo namëglelëtlame. Bu melë mëglana, kwe Goto bubë tëbo lowene iniwa aholokwana ti nalëgletëmeme. Bu kë gali Jerusalem lifate mëta afina të mëgëtatëmame.’ ");
INSERT INTO nce_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Iniwa wesibi sobo kë hwi toglomobë iniwa lifate mëta satë etagutemo. ");
INSERT INTO nce_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Sobo aholokwane elo. Ëtani aya Goto bu megali sle tle, bubë Amtëtomba some lëglëyome na bo bume sobelëme jine nëgelëbakëtëyome. Kwe sobo ebë lifate mëta fwa mana hwi elome na Gotobë Amtëtomba somëta mana letujutëyome na bubë afutuku fa etatelome.” ");
INSERT INTO nce_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Na kwe Jisas bume Betani lifate li elë tlelume. Na bubë toba elili tetokwakëme na Gotome takune tlole, kë onehome lëgaitame nalëgleme na ululu sle lotomeme. ");
INSERT INTO nce_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Bu Gotome mana gëgali tëglagulebëë, na Goto bume mana heven lifewa alabujuwa tilekole. ");
INSERT INTO nce_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Na bu sëkefo miti tafa mëtla na Jisasme mana lotu mëtletla. Na bu Jerusalem lifatewa tako fleflesuna mutuja. ");
INSERT INTO nce_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Na bu itaita tako lotu lowa mutujukefëya na Gotome fleflesu mëtlekefëtla na bibita mototokwefla. ");
INSERT INTO nce_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","3","O yabe Tiofilus. Jisas ebë life mëta tafa tëglena bu onehome feilawa wesibi totometëme na okokwe tlome. Na Goto bume heven lifewa mana no tlële. Na iniwa wesibi, Jisas onehome kë totometëmebë na kë okokwe toglomebë bo ëbame wayahi tletë. Jisas elili fa totle na gli tle na matëmatë mago huju tle. Na ebë life mëta niliafewe olë tëtabe. Na kë niliafewe olëna, bu kë aniji toglomebë Aposel home itaita tuhu tlelëkefëme na bume feilawa wesibi lebotane totometëme. Bume melowene namëgletlame, “Bu tuja ato lëtabefe.” Goto bubë onehome, eso home, kë tafa lëgletëmebë galime okokwe tlome. Gotobë Amtëtomba, Jisasme lale lowene tlële. Na bubë Aposel home, loko tëtamë na iniwa wege bu melë namogotomabëme okokwe tlome. Na Goto bume heven lifewa mana no tlële. ");
INSERT INTO nce_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Bubë Aposelna mana mëtëtabëyana, Jisas bume anisasana megali tlome, “Sobo Jerusalem lifate mago hokweinawa asa eyeu. Sobo Aya kë gali sle toglëyobë Amtëtomba fame sahwi eletelo. Ëbame bo kë wesibime kë gali toglëyobë. ");
INSERT INTO nce_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ëtani, Jon onehome tu mëta baptais totome, kwe tokwafe, tokwëfo olëna kwe aya Goto bubë Amtëtombana some baptais logotome.” ");
INSERT INTO nce_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Na li olëna, Aposel ho bu Jisasna loko mëtlelëya na bu këme takune motlola, “O tako ho, ju ebë olëna, sebobë, Israelbë afenëbonibë eso home tafa egletënamene, ëtani sebobë semle Devit eso home fene tafa tletëna? Na ju sebobë wame home, Rom life mago home, hehë naegletëmeme.” ");
INSERT INTO nce_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Na Jisas bume gali metafu tëtatëme, “Bobë aya buwa olë wafi aniji tlole, wesibi melë nalogotomebëme. Ebë olë lowene egletelobëme sobobë wesibi nane. ");
INSERT INTO nce_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kwe tokwafe, Gotobë Amtëtomba ligisi tëyome, na somëta lëtabeme na bu some afutuku nalëglëyome. Na sobo kë afutukuna, bobë gali të naegëtagutëmome. Sobo Jerusalem lifate mëta, na Judia provinsbë li life li life mëta, na Samaria provins mëta, na iniwa lifate mëta të etagutëmome.” ");
INSERT INTO nce_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jisas kë gali watë tëtatëme. Bume mana hwi motlolabëë. Na Goto bubë naba lime tilekole. Na oloba lamo totle na bume hwi hana motlola. ");
INSERT INTO nce_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bu mana hwi motokwakekefëya na tlemalë ho lamitlikakijowa. Bubë ëho tatiwamu. ");
INSERT INTO nce_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Na kë tlemalë gali motlomo, “Galili provins mago oneho, sobo mana fëyeme elibekefone na matafa elë fëyeme hwi ekwakekefone? Kë Jisasme kwe, Goto heven lifewa wafi lilekole. Kwe tokwafe ita bu lëgetujuleme, ëje sobo matafa elë lokwalebëme fene hwi eluluglo.” ");
INSERT INTO nce_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Na Aposel ho kë fatini kile mëtla na Jerusalem lifatewa mëtëmatula. Kë fatinibë weniji ebë “Oliv tiwa fatini.” Bu kakë nane elijamë, loli mëta mu. ");
INSERT INTO nce_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Bu lifekuwa fwa mototola na ëbame kë mëta tafa mëtlekefëyabë lowa ita mutuja. Na matawa kë ke togolebë lo ke elë motokwala. Bu kë lo mëta kë tafa mëtlekefëya enënebë weniji melë, Pita, Jon, Jems, Andru, Filip, Tomas, Bartolomyu, Matyu, Alfiusbë nëba Jems, Saimon Saimon bu Selot ho, na li Jemsbë bowene Judas. ");
INSERT INTO nce_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Kë enëne bu iniwa loko mëtlelëkefëya, na Gotome itaita gëgali mëtlelëkefla. Jisas bota Maria, na fli one, na Jisas bolijamoni mata mitisiya, buna iniwa Gotome gëgali namëglelëkeflame. ");
INSERT INTO nce_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tokwafe, li olëna, bu loko mëtlelëya, Gotome gëgali namëglelëlame. Jisasme lowene sle mëtletlabë oneho këniji loko mëtlelëya 120. Na Pita ku mëta tlibetëme na gali tlome, ");
INSERT INTO nce_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“O bobë afanino na oneglëni, bo some Judasbë galime gali nolëyo. Ëtani Gotobë Amtëtomba, eso ho Devitbë lowene huju tëtatle na gali tle. Na kë galibë Gotobë bogo mëta lëbetle. Kë galibë, Jisasme wamehome kë yo toglomebë home, Judasme, gali nene. Na ebë olëna kë wesibi wafi fata tle, Devit fene gali tle. ");
INSERT INTO nce_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Sebo walowene nëla, ëbame Jisas, seme, Judasname iniwa aniji tlona, bubë wege fa nanëtatlame.” ");
INSERT INTO nce_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas, Jisasme wame home kë yo toglomebë balitina, life afloko këna fa totle. Na bu kë life mëta titigo na imo labulewa tlatle na bu aliji tei tabo tëbe. ");
INSERT INTO nce_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalem lifate mago oneho kë gali aholokwane mëtla, na bubë galina kë lifeku mefë mototla, “Akeldama.” “Akeldama” weniji ebë kë gali fenene, “Kola life.” ");
INSERT INTO nce_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita megali tle, “Devit, Buk Song mëta, Judasme gali meyahi latletle, ‘Kë hobë lo mëta ho li hana tafa lëgleme. Kë lo bwa malilibe.’ Na Devit li gali Buk Song mëta meyahi latle, ‘Ho li bubë wege afloko safa lëtatle.’ ");
INSERT INTO nce_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Këme nëgeme, sebo ho lime aniji noglolame, Judasbë afloko mëta wege fa nalogotleme. Na bu sebona Tako Ho Jisas matëmatë mago kë huju tëglebë gali weife të nanogotlame. Sebo ebëha home tole nëletla, Jon Jisasme kë baptais totlebë hwi toglolebë. Na bu sebona Jisasme mana kë esogo tëglagilabë bubë gli belë fe tëkaki. Na bu iniwa wesibi Jisas melë kë tëtagilebë bu wahwi tlagime. Na bu Jisasme hwi tlole, Goto kë no tëglëlebe heven lifewa. Sebo këha home tole nëletla.” ");
INSERT INTO nce_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita megali tle na bu tlemalë home aniji motloma. Li howe Josep, bume mefë lamototla, Barsabas. Na bubë li weniji, Jastus. Na li howe, Matias. ");
INSERT INTO nce_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Na bu Gotome megali motlola, “Tako Ho, ju iniwa onehobë lowene wahwi elagumetëna. Këme nëgeme sebo jume këme takune nëlëyo. Ju seme lebotane naegëtatëname. Kë tlemalë mago, ju fëye home aniji tlolene, ");
INSERT INTO nce_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Aposel hobë wege fa nalogotleme. Judas kë wege wakile tle, na bu wagli tle, na Goto kë le tëglëtëmebë tëbo lifewa tuju.” ");
INSERT INTO nce_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Na bu wenijina goglë sike mëtla na Matiasbë weniji fata tletle. Na bume aniji motlola, we ita jowa Aposel kë nëgebëna tafa namëglame. ");
INSERT INTO nce_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Bubë tako lotu olë fotokoke tëme. Kë lotu olëbë weniji Pentikos. Bu kë olë, nuju mago kë fafa mototokweflabë wesibime, Gotome fleflesu mëtletla. Na Jisasme lowene sle mëtletlabë oneho iniwa jowa lo mëta fwa loko mëtlelëya. ");
INSERT INTO nce_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Na mana, labasagli flelu lego fenene, heven lifate mago latigisitëmewa. Na kë tako lego bu kë mëta loko mëtlelëyabë lo iniwa lakewa tlotëme. ");
INSERT INTO nce_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Na bu anusesi ahojuha wesibi hwi motloma. Na kë anusesi ahojuha wesibi, iniwa mëta tlëwagutëme. Na bubë eso mëta ahoju naflëboha metlëwagutëme? ");
INSERT INTO nce_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Na Gotobë Amtëtomba kë iniwa enëneme tisi tëme. Na bu mëta tëtabetëme. Na bume afutuku tlëme. Na kë afutukuna lili anigawa gëgalina, gëgali mëtla. ");
INSERT INTO nce_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kë olëna, Israelbë afenëboni feilawa, Jerusalem lifate mëta mëtëtabëya. Bu Gotome kë lotu melekefëtlabë oneho. Kë oneho li life li life mago mitisiya. Na bubë galina bwa bwa gëgali mëtla. ");
INSERT INTO nce_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Oneho kë legobë lego aholokwane mëtla, hwime loko motokweija. Bu Jisasme kë lowene sle mëgletlabë enënebë gali aholokwane motloma na klelego memëtletëmamu. Bubë lili galina gëgali mëtletëmame nëgeme. ");
INSERT INTO nce_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Bu klelego memëtletëma na gali mëtla, “Ebë oneho bu sebobë lili galina kë gëgali mëglabë, bu Galili provins mago tekwe nëge. ");
INSERT INTO nce_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Sebo lowene hana nëletëmafe, bu sebobë lili galina habëna gëgali mëglamene? ");
INSERT INTO nce_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Sebo kë nëgebë, li life li life mago oneho loko nëlelëya. Sebo fliye Partia na Midia na Elam lifate mago enëne. Na sebo fliye Mesopotemia na Judia na Kapadosia na Pontus na Esia provins mago enëne. ");
INSERT INTO nce_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Na sebo fliye Frigia na Pamfilia provins mago enëne. Na sebo fliye Isip life mago enëne, na Libia provins li mago lifate Sairini mago enëne, na sebo fliye Rom life mago enëne, ");
INSERT INTO nce_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","na fliye Israelbë afenëbonimu na fliye bu Israelbë afenëboni nane kwe bu Israelbë afenëbonibë lotu tokwafe esogo mëtlelëla. Na sebo fliye Krit life mago na Arebia provins mago enëne. Sebo iniwa, li li galina nëtabëyabë enëne, kwe kë oneho, Gotobë tako afutukuna wesibi melë kë logotlebë, sebobë lili galina ekë të motla.” ");
INSERT INTO nce_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Na bu iniwa klelego memëtla na tutune mëtla. Na blalo gëgali mëtlelogwaya, “Ebë wesibi, ëje mefata kë lëglebë ebë fëye wesibine, sebo lowene hana nëletlafe?” ");
INSERT INTO nce_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kwe fliye sosonatlëtlë memototoma na bume tiniji gëgalina gali motloma, “Tiho wain taba liji tu feilawa hi mëglame nëgeme, bu këme yaya mla.” ");
INSERT INTO nce_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pita na fli we ita jowa Aposelna mitlija. Na bu onehome anisasana gali tlome, “Bobë ilawa mago enëne na sobo fli enëne, Jerusalem lifateme kë tafa egelobë, sobo aholo bo etatëna. Bo some kë wesibi wayobëme gali nëglëyome, sobo lowene naegletelome. ");
INSERT INTO nce_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Sobo seme melowene laletënane, ‘Wain taba liji tu hi mëglame nëgeme këme yaya mla?’ Weyewa. Hanane mu. Sobo hwi elo, ebë olobalë klijina, na ho bu olobalë klijina wain taba liji tu hana hi mëlekefëya. ");
INSERT INTO nce_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ebë wesibi ëje kë fata lëglebë, Gotobë lowene mago gali të totokweflebë ho, Joel, ëtani wagali tletle. Bu megali latle, ");
INSERT INTO nce_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Goto megali latle, “Yawe olë nounou lëglena, bobë Amtëtomba iniwa enëneme nëglëwagumëme. Sobobë nëbale bobë lowene mago gali të mogotlame. Sobobë falake na filemi ho, bu Gotobë toba mago nimitelë hwi mëglame. ");
INSERT INTO nce_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Kë olëna, bobë Amtëtomba, bobë wege onehome nëglëmëme. Na bu bobë lowene mago gali të mogotlame. ");
INSERT INTO nce_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Bo klelegowa wesibi matafa mëta fata nogotomëme na life mëta, mata, fata nogotomëme, bobë afutuku naolafa nogotlëme. Na bu wino, ahoju, tako ahëyana hwi moglomame. ");
INSERT INTO nce_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Na kliji ki letofatleme na klabëwa lëbeme, na yeme u mata obwelë tlamëme na winowa fata tlamëme. Kë wesibi yawe lëkakeme na mana Goto bubë tako afutuku olafa lotleme. ");
INSERT INTO nce_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Na kë nalë, iniwa oneho, Goto bume lëgaitameme, kë takune moglolabë, kwe Goto bume lëgaitameme na nëno lëleme. Na bu tafa sle mlame.” ’ Ebë gali kë nëgebë, Gotobë lowene mago gali të totokweflebë ho bu gali tle.” ");
INSERT INTO nce_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Na Pita ita gali tle, “Sobo Israelbë afenëboni, sobo aholo bo etatëna. Bo some Nasaret life mago Jisasme gali nolëyo. Goto bu kë home aniji tlole. Na tako afutuku tlële. Na bu kë afutukuna, memelë tako afutukuna wesibi na memelë klelegowa wesibi blëge blëge totome, sobobë naba li mëta. Goto melë kë tëglebë, sobo melowene naegelome, ‘Goto ebë home jine tlëlefe.’ ");
INSERT INTO nce_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Goto bu ëtani walowene sle tle. Na bu ebë home some watlëyo, sobo wame home yo naeglomome, bume ti mëta, mogo nalë bu namëglame. ");
INSERT INTO nce_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Kwe Goto bume matëmatë mago wahuju totle. Bu kë gli tëglebë elili mago wafi no tlële. Gli bume hana fa logotleme. ");
INSERT INTO nce_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ëtani eso ho Devit bu kë home wagali tletle, ‘Bo Tako Home wahwi nololë, bobë lime unaunalëmemu lëtabe. Bobë lime lëtabeme nëgeme bo li wesibimeha uli jwa këme nëletelë. ");
INSERT INTO nce_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Këme nëgeme bobë lowene lalowa këme lëbetenë, fleflesu na këme gëgali nelë. Lale wesibi, Goto bome melë kë lotometenëbë, bo kë hwi nëletemë. ");
INSERT INTO nce_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ju bome lebo enënebë life mëta kile hana egëtanëme. Jubë lowenewa esogo sle lëglelëlebë lale wege home, matëmatë mëta kibo lëglëbëme, hwiwa hana egloleme. ");
INSERT INTO nce_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ju bome lale tafa lowenebë walebotane tëtatenë, na ju bona unaunalëme tafa nëgelome na ju bome tako fleflesu enënëmu.’ Ebë gali Devit bu të totle.” ");
INSERT INTO nce_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Na Pita megali tle, “Bobë afanino na oneglënino, bo sebobë ëtanifu eso ho Devitme gali sle nëglëyome. Bu wagli tle na bume matëmatë mëta gwa mototla na bubë matëmatë semëta mana mëbe. ");
INSERT INTO nce_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Kwe Devit bu Gotobë lowene mago gali të totokweflebë ho. Na Goto bume anisasana megali sle latlole, ‘Nëgalimu, ju eso home fene tafa ele, tokwafe, jubë weife mago hobë nëba bu metafa lëgleme.’ ");
INSERT INTO nce_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Devit bu Goto tokwafe logotomebë wesibime lowenemu sle latletëme. Na bu, Goto kë aniji toglolebë home, onehome nëno lëglebë home, melowene sle tletle, ‘Bu matëmatë mago huju lëgleme.’ Këme nëgeme bu megali tle, ‘Goto bume gigli enënebë life mëta hana hwiwa logloleme na bubë ato matëmatë mëta kibo hana lëgletleme.’ ");
INSERT INTO nce_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Na kwe kë ho bu ebë Jisas. Na Goto bume matëmatë mago wafi huju totle. Na sebo bume hwi tlola na sebo kë wesibime këme gëgali nëletla. ");
INSERT INTO nce_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Goto bume fleflesu tletle na mana no tlële, Gotobë tobamu toba elë tafa nalëgleme, eso home weife tafa namëgelome. Na bolijaya Amtëtomba bume tlële, bu ëtani fene gali tle. Na Jisas ëje seme kë Amtëtomba ekë lënëna. Këme nëgeme ëje kë wesibi sobo kë hwi eglolobë na kë aholokwane egelobë, ebë kë wesibi Jisas seme kë lënëna. ");
INSERT INTO nce_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kë galibëme, Devit bu bume nane gali tle. Weye, li home gali tletle. Sobo walowene elo. Devit bu heven lifewa hana tokwale Jisas fene tokwale. Hanane. Kwe Devit bu megaliwa latle, ‘Tako Ho bobë Tako Home megali latlole, “Ju bobë tobamu toba elë tafa eleme, na eso home weife tafa nëletemome. ");
INSERT INTO nce_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Sebo onehome mana tafa nëlekefëtemobëë na jume kë wame mëglëyobë onehome, bo mana boblo nogotomëme na bu jubë gali boblo jwa mëgëtatëyome.” ’ ");
INSERT INTO nce_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Na kwe, sobo Israelbë afenëboni, sobo melowene sle egelome, ‘Ebë ho Jisas kë nëgebë, sobo time kë bu tëgelobë, Goto bume Tako Ho lëgëtabebëme wafi aniji tlole. Bubë enëneme nëno nalëglebëme wafi aniji tlole.’ ” ");
INSERT INTO nce_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Oneho Pitabë gali yafe aholokwane mëtletla na bubë gali bubë lowene sisilemu metëtatëme. Na bu Pitaname Aposel fliname këme takune motloma, “O afanino, eli sebo habelë nëglamene?” ");
INSERT INTO nce_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Na këme Pita gali tlome, “Sobo jowa jowa kë nëgebë, tëbo lowenebë aholokwana ti elome na Gotome fwa lowene sle eletelome na sobo Jisas Klaisbë wenijina baptais elome. Sobo melë egelona, kwe Goto bu sobobë tëbo lowenebë aholokwana ti lëgletëyome na bubë Amtëtomba lëlëyome. ");
INSERT INTO nce_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ëtani Goto wafi gali sle tle, bubë Amtëtomba some lëglëyobëme na sobobë afenëboni mata na kakë kë tafa mëtlabë onehome mata lëglëmëme. Sebobë Tako Ho, Goto, iniwa onehome, bu belë migisiyabëme, kë we loglomebë, bubë Amtëtomba lëglëmeme.” ");
INSERT INTO nce_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Na Pita bu fli feilawa gali të tëtatëme na këme bume anisasana gali tlome, “Sobo tetëbo wesibime ululu sle sa elo na Goto some lëgaito nalëgleme satakune elokweflo, sobona, tëbo lowene kë esogo mëglelëlabë enënena, iniwa tëbo eglitolime.” ");
INSERT INTO nce_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Na feilawa oneho Pitabë gali lowene sle mëtletla na Aposel ho bume mana baptais mototoma. Na kë olëna, Aposel ho, 3,000 onehome baptais mototoma. Na buna, Jisasme ëtani kë lowene sle mëtletlabë onehona, iniwa sago mëtla. ");
INSERT INTO nce_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Iniwa olë, Jisasme tokwafe lowene sle mëtletlabë oneho, Aposel ho kë të mototokweflabë gali aholokwane mëtlekefëya na kë galiwa esogo sle mëtlelëla. Na bu Jisasme lowene sle mëtletlabë oneho flina loko mëtlekefëya. Na bu blalo yonane lowenena hi mëtlekefëya na Jisas bu gli tëglebë olëna kë hi tëglelëmebë hi wesibi mata hi mëtlekefëya. Na Gotome gëgali mëtlelëkefla. ");
INSERT INTO nce_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Na Aposel ho bu Gotobë afutukuna, klelegowa wesibi blëge blëge mototokefëma. Na iniwa oneho hwi motloma na klelego memëtletëma na tako tutune memëtla. ");
INSERT INTO nce_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Na iniwa oneho, Jisasme kë lowene mëtletlabë, bu jowa lowene nawa tafa mëtlamu. Na bu melowene lamëtla, “Jowa jowa enënebë wesibi kë nëgebëye, ebë sebo Jisasme kë lowene sle nëgletlabë iniwa enënebë wesibi.” ");
INSERT INTO nce_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Na li li olëna bubë flëke na fli wesibina balitina hihijika mëtla. Na bu kë balitina hi wesibi jwa enëneme mëtaitama. ");
INSERT INTO nce_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Na iniwa olë bu Gotobë tako lotu lo mëta loko mëtlelëkefëya. Na bu li lo li lo mëta mana loko motokoukefëya. Na hi wesibi mana hi mëtlekefëya. Bu yonane lowenena tafa mëtla na fleflesu lowenena hi motokoukefëya. ");
INSERT INTO nce_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Na iniwa olë bu Gotome fleflesu lamëtlekefëtla na bibita mototokwefla. Na iniwa oneho bume fleflesu lamëtlekefëtema. Olë li olë li, Tako Ho bume lowene jwa mëgletlabë onehobë lowene sle tëtakefëtëme. Na bume lowene sle mëtletla. Jisas bu melë tle na bume lowene sle mëtletlabë oneho feilawamu fata mëtletla. ");
INSERT INTO nce_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Li olëna, Pitana, Jonna, taboklë klijina oneho Gotome gëgali mëtlagulabë olëna, Gotobë tako lotu lowa mëtëyeu. ");
INSERT INTO nce_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Na tlemalë, fli enëneme hwi motlomo, kiju mogotabo home mëtlesula. Bu botabë imo mago kiju mogotabo fata tle. Iniwa olë bu kë belë mëtlesukefla na Gotobë tako lotu lobë lëglesi ino ëfo li mëta gwa mototokwefla. Bu kë inobë weniji mefë lamototla, “Lale Ino.” Na kë kiju mogotabo ho, tako lotu lowa kë mitisikefëyabë onehome, balitime, gëgëba tlokwefëme. ");
INSERT INTO nce_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Na kë ho tlemalëme hwi tlome, Gotobë tako lotu lowa mëkaklujo namëgelome kofene, na bu balitime mana gëba tlome. ");
INSERT INTO nce_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pitana Jonna bume anisasana hwi motlolo na Pita gali tlole, “Ju seme hwi elëfakëna.” ");
INSERT INTO nce_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Na kë ho bume anisasana wëya tlelëme na melowene latle, “Baliti mëglënomefe.” ");
INSERT INTO nce_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kwe Pita gali tlole, “Masiwafe, bo baliti hananefe. Kwe bo jume kë nëglëbë wesibi nane. Bo Nasaret life mago Jisas Klaisbë afutukuna jume gali nolë, ju huju elëme na asë elëme.” ");
INSERT INTO nce_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Na Pita tobamu tobame fa totle na hujume taitale. Na bubë kiju laslewa metletle. ");
INSERT INTO nce_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Na bu hokweinawa huju totokwakle na asë tëbelëfa. Na buna, tlemalë hona, iniwa Gotobë tako lotu lowa mëtëkakluja. Na bu asë tëbelëfa. Na okokli okokli tëbelëfa. Na Gotome mana bibita tëtagule. ");
INSERT INTO nce_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Na iniwa oneho lotu lo mëta kë tafa mëtlabë, bume mehwi motlola, bu asë tëbelëfa na Gotome bibita tëtagule. ");
INSERT INTO nce_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Na bume lowene sle mëtletla na melowene lamëtla, “Ebë ho kë nëgebë kwe bu Gotobë tako lotu lo lëglesi mago ino ëfo li mëta kë tafa lëglekëfebë ho, balitime kë gëgëba lëglekëfebë ho.” Bume hwi motlola, kiju lalowa mëbetle na klelego memëtla. ");
INSERT INTO nce_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Iniwa oneho kë home kë fata tëgletlebë wesibi gali aholokwane mëtla na klelego memotokouja. Na bu fëka motokweija, kë home hwi namoglolame. Na bume mehwi motlola, Pitaname Jonname tobame fafa tle. Na bu lotu lo sebati mëta mana mitlija. Bu kë sebatibë weniji mefë lamotla, “Solomonbë sebati.” ");
INSERT INTO nce_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita onehome hwi tlome na gali tlome, “Sobo Israelbë afenëboni, sobo ebë wesibi kë fata lëglebëme fëyeme klelego ekoujone? Na sobo seme anisasana fëyeme wëya elelënane? Sobo melowene lalone, ‘Sebo Gotobë naba lime asë sle nanelo na kë home mana sle notlo?’ Weye. Hanane mu. Sebo kë home sebobë afutukuna hana sle notlo. Weye. Hanane mu. ");
INSERT INTO nce_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Sebobë semleninobë Goto, Abraham, Aisak, Jekopnabë Goto seme meolafa latëtatëna, bubë wege ho, Jisas, bu tako afutukuna ho, na bu Jisasme tako fleflesumu latletle. Kwe sobo bume wame ho betelë tlelulo, mogo nalë tëkle namogotlame. Eso ho Pailat bume jine lëgelëkakleme tole latle fene, kwe sobo bume jine lëgelëkaklebëme tole hana tletelo na bume hehë tletelo. ");
INSERT INTO nce_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jisas bu Gotobë iniwa gali esogo sle tëglelëtlebë ho, na bu lalemu na li fëye wesibiha hana totle. Kwe sobo bume tole hana tletelo na hehë tletelo. Na sobo eso ho Pailatme gali tlolo, ho mogo nalë kë tëke toglolebë home kalabusu lo mago jine nalëglëleme, Jisasme asa jine elëtëna. ");
INSERT INTO nce_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jisas bu seme lale tafame sle lëgëtana ho. Kwe sobobë galime fwa nëgeme bume mogo nalë këme tëkle mototla. Kwe Goto bume matëmatë mago huju totle. Na sebo tlemalë kë wesibi sebobë nabana hwi tlolome nëgeme, kë loweneme fwa këme gali nelo. ");
INSERT INTO nce_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Sebo melowene sle nëgelome nëgeme, ‘Jisas ebë home lalowa sle logotleme, na bubë afutuku ebë home këme sle lotle.’ Jisas sebobë lowene buwa huju lëtateno na këbë lowenena ebë home sle notlo. Na sobo ebë home wahwi elolo, ëtani buwe kiju mogo tabo tëtabe kwe ëje lalowa ekë asë lëbelëfa. ");
INSERT INTO nce_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","O, bobë afani, bo walowene nelë, sobona, sobobë eso hona, sobo melowene hana tletelo, ‘Goto Jisasme wafi aniji tlolefe, onehome nëno nalëgleme.’ Sobo kë wesibime lowene hana telo, na Jisasme këme tëbo totlo. Sobo meweniji latelo, Jisas bu atwati howa. ");
INSERT INTO nce_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Gotobë lowene mago gali ëtani kë të mototokweflabë home, Goto megali latlome, onehome nënome, kë gali tëgletlebë ho, bu tako elili fa logotleme na gli lëleme. Iniwa galime bu kë gali toglomebë, bu fatamu latotome. ");
INSERT INTO nce_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Këme nëgeme sobo tëbo lowene, aholokwana ti elome na Gotome fwa lowene sle eletelome. Sobo melë egelona kwe Goto bu sobobë tëbo lowenebë aholokwana ti lëgletëyome. ");
INSERT INTO nce_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Na Tako Ho some tiho lowenena tafa egelobë lowene lëglëyome. Na unina, bu Jisasme ita jine lëgelëfakleme. Bu kë home wafi aniji tlole seme nëno lëglebëme. ");
INSERT INTO nce_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kwe bu heven lifate mëta tafa lëglebë, na Goto iniwa wesibi ëtani kë blëge totomebë, ita sle logotomebë olë mana folokoke tleme. Ëtani mu, Goto kë galime, gali sle tlome. Na bu bubë lowene mago gali të mototokweflabë home aniji tlome, kë gali onehome të namëgëtakefëtëmame. ");
INSERT INTO nce_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ëtani Moses megali latle, ‘Sobobë Tako Ho, Goto, bu sobobë semle lime aniji logloleme, bubë gali të nalëgëtatëyome. Na bo Gotobë lowene mago gali të notokweflëbë ho fene tafa nelë, bu mata mefata nalëgleme. Sobo bubë gali aholokwane elolome na kë gali esogo elelëlome. ");
INSERT INTO nce_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Na iniwa oneho, kë hobë gali aholokwane jwa mëglana na esogo jwa mëglelëlana kwe Goto bume tëbo logotomeme. Na bu Gotobë onehobë ku mëta hana tafa mëgelulame.’ ");
INSERT INTO nce_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Gotobë lowene mago gali të mototokweflabë ho iniwa, bu ebë olëna kë fata lëglebë wesibime, gëgali motokweija. Samuel bu kë wesibime afina wagali tle na tokwafe Gotobë lowene mago gali të mogotlabë enëne fli, Samuelbë nagi kë fata mëtlabë, bu mata kë wesibime gëgali mëtla. ");
INSERT INTO nce_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Goto bu ëtani megali sle tle, bu ho lime jine lëglëleme, onehome nëno nalëgleme. Na Gotobë lowene mago gali të mototokweflabë ho bu kë galime onehome gali motlokwefëma. Na Goto bu kë home sobelë jine tlëtëyo, bu fene gali mëtla. Goto sobobë bisemleninome megali sle latlome, bume lale tafa nalëglelëmeme. Na kë gali sle gali bu soboname iniwame gali tle. Goto bu Abrahamme megali sle latlole, ‘Bo tokwafe iniwa lifate mago enëneme lale tafa nëglëmëme. Na kë lale tafa lëglëme ho, jubë bisemleni mëta fata lëgleme.’ ");
INSERT INTO nce_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Këme nëgeme, Goto bubë wege home aniji tlole na sobelëme afina jine tlëtëyo, some ululu sle nalogotome na some jowa jowa onehome, tëbo lowenebë aholokwana ti egelobëme laitome.” ");
INSERT INTO nce_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pitana Jonna onehome mana gëgali mëtlelëmobëë, na lotu lo mëta wege mëglabë ho fli, na Gotobë tako lotu lobë plismanëbë eso ho, na Sadyusi enëne fli, mana mitisiya. ");
INSERT INTO nce_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Bu melowene lamëtla, “Tlemalë bu onehome megali të mëtatemo, ‘Goto Jisasme gli mago wahuju totle.’ Na këme sebo melowene nanëla, ‘Goto iniwa gigli enëneme huhuju logotomeme.’ ” Këme nëgeme bu tlemalëme tako wame lamotloma. ");
INSERT INTO nce_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Na bu tlemalëme fafa mëtla na Israelbë afenëbonibë lotu eso enëne belë mëglelumame fene. Kwe taboklëmu nëgeme na bume kalabusu lo elë fwa këme sike mëtla. Li olëna namëglelumame. ");
INSERT INTO nce_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Kwe lebutako oneho bu Pitabë gali aholokwane mëtla na bu Jisasme lowene sle mëtletla. Na Jisasme lowene sle mëtletlabë onehobë tabei këniji mefata latla 5,000 elë ëjeha fwa neme. ");
INSERT INTO nce_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Jowa olë mëtla na Israelbë afenëbonibë letitabo enënena, lotu eso enënena, Gotobë galime okokwe moglomabë hona, bu Jerusalem lifate mëta loko mëtlelëya. ");
INSERT INTO nce_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Na Gotobë tako lotu lo mëta wege lëglebë tako eso ho Anas, buna iniwa loko mëtlelëya. Na Anasbë ilawa mago ho, Kaiafasna, Jonna, Aleksanderna bubë fli ilawa mago ho mata buna loko mëtlelëya. ");
INSERT INTO nce_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Na bu Pitaname Jonname mëtlesuma na bubë naba lime ola mëtëkakija. Na bu tlemalëme metakune motloma, “Some ya gali tloyone, na some kë afutuku ya tlëyone na sobo kë home sle totlo?” ");
INSERT INTO nce_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Na Gotobë Amtëtomba Pitame afutuku tlële, na bu megali latlome, “O Israelbë afenëbonibë letitabo enëne na sebobë eso enëne. ");
INSERT INTO nce_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Bale, sobo seme kiju mogo tabo home kë tëgaitalobëme takune naeglonamene? Na sobo melowene sle naegletelomene, ‘Ebë ho habelë sle lamototlone?’ ");
INSERT INTO nce_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Kwe melë nëgebë, kwe sobo iniwa melowene egletelome, na sobo Israelbë afenëboni iniwa sobo mata melowene egletelome, ‘Nasaret life mago Jisas Klaisbë afutuku ebë kiju mogotabo home sle totle na sobobë naba li mëta ekë lilibetëyo.’ Kwe sobobë so galime fwa bume mogo nalë ti mëta këme bu mëtla. Kwe Goto bume matëmatë mago huju totle. ");
INSERT INTO nce_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Gotobë bogo, bu ebë wesibime mewaflë gali lalatle, ‘Lo gliji ho, bu lo, anijina gliji mëtla. Kwe bu li anijime meweniji lamëtla, “Tëbowa.” Këme nëgeme, mëglëbo elë gwa mëtetokwakëya. Kwe kë aniji kë gwa mëtetokwakëyabë bu lale anijimu ebamë. Lo bulego kë aniji mëta lotle.’ Sobo aholokwane elo. Sobo kë lo gliji enënena Jisas bu kë aniji fenene. ");
INSERT INTO nce_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Jisas buwamu seme nëno lëgleme. Goto, Iniwa life mago onehome, limeha meaniji hana tlole, seme nëno lëglebëme. Goto Jisasme fwa aniji tlole.” ");
INSERT INTO nce_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Na iniwa Israelbë afenëbonibë lotu eso enëne melowene lamëtla, “Pitana, Jonna, skulme hana mëtëyeu. Tlemalë bu atwati ho.” Kwe bume yafe hwi motloma, tlemalë bubë naba lime gëgalime uli hana mëtelo. Na bu këme klelego memëtletëma na melowene mëtla, ëbame tlemalë bu Jisasna asë mëtla. ");
INSERT INTO nce_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Na bu kiju mogotabo kë sle tëglebë home hwi motlola, Pitana Jonna weife mitlija, këme nëgeme Pitanabë Jonnabë gali habëna tafu mëgetatëmamene? ");
INSERT INTO nce_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Na kwe Israelbë afenëbonibë lotu eso enëne, Pitaname, Jonname bu mago jine mëtelëkakëma. Tlemalëme wajine mëtelëkakëma na bu blalo mana gëgali mëtla, ");
INSERT INTO nce_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Sebo kë tlemalë home habelë nogotomamene? Tlemalë bu klelegowa wesibi blëge mototlo. Na iniwa oneho, Jerusalem lifate mago, bu këbë wesibi wafi lowene sle mletla. Sebo megali hana nëglame, ‘Ebë sogëna wesibi.’ Sebo able hana nëglame. ");
INSERT INTO nce_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kwe kë kiju mogo tabo ho, kë sle lëglebë gali, iniwa oneho betelë fifiji mëglagulalime. Këme nëgeme sebo bume anisasana lëkle nogotomame, bu fli onehome, Jisasbë galime gali jwa namoglomame.” ");
INSERT INTO nce_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Na kwe bu tlemalëme ita mëtlelëkakima na anisasana gali motloma, “Jisas kë totomebë wesibime, itaita asa gëgali elekefo na sobo fli onehome Jisasbë wesibime asa okokwe elokwefomo. Matëbemu.” ");
INSERT INTO nce_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kwe Pitana Jonna bubë gali metafu mëtëtatemo, “Sobo habë lowene lalone, Gotobë naba lime fëye lowene lale lëlene? Sebo Gotobë tole esogo nëglelëlome o sobobë tole esogo nëglelëlome. Sobo kë wesibi mana lowene sle eletemo. ");
INSERT INTO nce_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kwe sebo ëfalëbo kujuna hana tafa nëgelome. Sebo Jisasme kë hwi toglolobë wesibi, na Jisasbë ëfalëbo mago kë aholokwane toglolobë gali, onehome të nëgetatëmome.” ");
INSERT INTO nce_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Na kwe Israelbë afenëbonibë lotu eso enëne bu kë tlemalëme ita anisasana gali motloma. Bu bume tëbo mogotomabë lowene yafe sle mototla, kwe iniwa oneho, Goto kë kiju mogo tabo home kë sle togotlebëme, lowene mëtla na Gotome fleflesu mëtlekefëtla. Këme nëgeme, Israelbë afenëbonibë lotu eso enëne bu onehome uli memëtletëma na bu kë tlemalëme hana tëbo mototoma na bume jine mëtelëkakëma. ");
INSERT INTO nce_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Na kë kiju tëbona home, tlemalë Jisasbë afutukuna kë sle mototlobë, bu niliafewe tlibutu wasigli totome na botabë imo mago kiju mogo tabo fata tle. ");
INSERT INTO nce_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Israelbë afenëbonibë lotu eso enëne, Pitaname Jonname wafi jine mëtelëkakëma. Na kwe tlemalë Jisasme lowene sle mëtletlabë oneho fli betelë ita mëtëyeu. Na lotu lo mëta wege mëglabë eso hobë gali na fli Israelbë afenëbonibë letitabo enënebë gali bume gali të mëtëtatemo. ");
INSERT INTO nce_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Bubë gali aholokwane motloma, na kwe iniwa bu jowa lowenenawa Gotome gëgali mëtlelëla, “Tako Ho, ju matafa blëge totle, na life blëge totle na nutu blëge totle, na iniwa wesibi kë mëta kë mëgëbebë mata blëge totome. ");
INSERT INTO nce_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ëtanimu jubë Amtëtomba, sebobë semle, Devitme gali tlële. Bu jubë wegeho tafa tletë. Na bu megali latle, ‘Gotome lowene jwa mëtletlabë enëne, bu fëyeme enisusu mëlane? Li life li life mago oneho, bu Gotome wameme, gali yafe sle mototla, kwe hanane. ");
INSERT INTO nce_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Iniwa lifate mago eso ho bu wameme sagli metlëla, na bu loko mëtlelëya, Tako ho na, seme nëno lëgleme kë aniji toglolebë honame, momogli namëgletomame.’ ");
INSERT INTO nce_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ebë gali Devit kë yahi tëglebë, bu iniyafememu yahi tle. Herotna, Pontius Pailatna, Israelbë afenëboni mëtabëya jwa mëglabë enënena, Israelbë afenëbonina, bu kë lifate, Jerusalem mëta loko mëtlelëya, Jisasme tëbo namogotlabëme. Jisas, jubë lale wege ho. Na ju bume wafi aniji tlole, jubë onehome nëno lëleme. ");
INSERT INTO nce_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bu kë wesibi melë kë mëtlabë, kwe jubë gali na jubë tolewa esogo mëtlelëla. Jubë afutuku nawa, ju ëtani wafi gali sle tle, këbë wesibi fata lëglebëme. ");
INSERT INTO nce_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Kwe Tako Ho, ëje sebo jume gali nolëyo, bu seme kë wame moglonabë gali, lowene egletleme. Na ju seme, jubë wege enëneme, afutuku elëlëname na sebo jubë gali tëme uli jwa nanëglame. ");
INSERT INTO nce_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Goto, jubë afutuku onehome olafa etatëmeme na onehobë ato elili sle etometëmeme na klelegowa wesibi mata blëge etometëmeme. Ju kë wesibi jubë wege ho Jisasbë afutukuna melë saetometëme.” ");
INSERT INTO nce_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Bu Gotome wafi gëgali mëtlelëla, na kë mëta, kë loko mëtlelëyabë lo, asëwa tletëme. Na Gotobë Amtëtomba bume afutuku tlëme na bu Gotobë gali feilawa të mototla na bu kë gali të mogotlabëme uli hana mëtla. ");
INSERT INTO nce_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jisasme lowene sle mëtletlabë oneho bu jowa lowene nawa tafa mëtla. Ho li bu megali hana tle, “Ebë wesibi kë nëgebëye, ebë bobëwa.” Weye. Iniwa wesibi kë nëgebë ebë iniwa onehome lëgaitamebë. ");
INSERT INTO nce_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Na Aposel ho bu tako afutukuna, Tako Ho Jisas matëmatë mago kë huju tëglebë gali, onehome të mëtetakefëtëma. Na Goto bume lëgaitameme tako fleflesumu latletëme. Na bume ululu sle totome na bu tafa sle mëtla. ");
INSERT INTO nce_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Na bubë ku mago, li hoha, wesibime hana afolo tle. Hanane mu. Iniwa oneho bu flëke o lona kë mëtëtabëyabë, bu kë wesibi balitina hihijika mëtla. Na bu kë baliti glo mëtla na Aposel ho betelë mëtehweija. ");
INSERT INTO nce_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Na bubë toba mëta gogwa mëtla. Na Aposel ho kë baliti, wesibime kë afolo mëtlabë enëneme sa mëtëtagutëma. ");
INSERT INTO nce_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Na ho li buna tafa mëtla bubë weniji Josep. Na Aposel ho bume li weniji fë mototla, Barnabas. Barnabas weniji kë nëgebë kë gali fene lëbe, “Onehobë tutune lowene sle lëgëtatëmebë ho.” Barnabas kë nëgebë bu Livaibë afenëbo na bu Saiprus afayo mago ho. ");
INSERT INTO nce_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Bu bubë flëke afloko li, balitina hihijika tle. Na bu kë baliti tehwei na Aposelbë toba mëta gogwa tle. ");
INSERT INTO nce_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Na ho li buna tafa mëtla. Bubë weniji Ananaias. Na bubë nobë weniji Safaira. Ananaias bubë flëke afloko balitina hihijika tle. ");
INSERT INTO nce_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Na kë glo tëglebë baliti fli ëho totome. Na no mata kë wesibi lowene latletle. Na Ananaias bu kë baliti lëne glo tle na Aposel home tujuwelëme na sogëna tlome, “Bobë flëke baliti kënijiwa glo telëyo.” ");
INSERT INTO nce_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Na Pita bume megali tlole, “Ananaias, Ju Satanbë tole fëyeme esogo tlelëtlene? Ju bome megali kë eglonëbë, ‘Ebë baliti bobë flëke mago këniji glo telë,’ kwe ju Gotobë Amtëtombame sogëna lalole. ");
INSERT INTO nce_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ju kë flëke afloko jubë tole nawa balitina hihijika tle. Na baliti ju kë glo tëglebë ebë mata jubë wesibi. Na ju kë balitina fëye wesibi egleme tole eglebë ebë jubë tolewa. Ju këha tëbo lowene fëyeme tlene? Na mesogëna ele, ‘Baliti kënijiwa ekëne.’ Ju melowene asa ele, ‘Ju onehome sogëna elome.’ Weyewa. Ju Gotomemu sogëna elole.” ");
INSERT INTO nce_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananaias kë gali aholokwane tle na bu mogowa latitigowa. Na oneho bu Ananaiasme kë fata tëgletlebë wesibime yafe aholokwane motokouja na bu tako uli memëtla. ");
INSERT INTO nce_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Na falake nëbale bu mitisiya. Na bu mogo ëhona lalei mototla na matëmatë mutuje tla. ");
INSERT INTO nce_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tokwëfo tafawa tëtëkake, na Ananaiasbë no bu mata tëkakli. Bubë home kë fata tëgletlebë wesibime lowene hana tle. ");
INSERT INTO nce_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Na Pita, bohe kë tëgehweibë baliti bume lebotane totometë na megali tolë, “Ju bome gali enonë, sobo bihena, flëke baliti kë glo tëgelobë ebëwa glo telone?” Na Safaira bume gali tafu tëtatle, “Na kwe fëyemene? Ta kënijiwa fe.” ");
INSERT INTO nce_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Na Pita bume megali tolë, “Sobo bihena gali fëyeme sle totlone? Gotobë Amtëtombame su naegotlomene? Ju aholokwane ele. Biheme kë gwa mogujetlabë falake nëbale, ino ëfo mëta ekë melujuwelukwëya. Na ju mogome mata mëgehojome.” ");
INSERT INTO nce_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Na bu mata Pitabë elebo lime mogowa latitigowa. Na falake nëbale metëkaklija na bume mogowa hwi motlëya. Na fa mëtëtaya na mëtehujaya. Na bohebë mëglëbo lime matëmatë mëtëtaya. ");
INSERT INTO nce_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Na Jisasme lowene sle mëtletlabë oneho iniwa na fli oneho mata bu kë gali yafe aholokwane mëtla na ulimu memëtla. ");
INSERT INTO nce_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aposel ho bu feilawa klelegowa wesibi onehobë naba lime blëge blëge mototoma. Na Jisasme lowene sle mëtletlabë oneho bu tako lotu lowa itaita mutujukefëya na lotu lo sebati mëta loko mëtlagukefëya. Bu kë sebatibë weniji mefë lamototla, “Solomonbë sebati.” ");
INSERT INTO nce_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Na Jisasme lowene jwa kë mëgletlabë oneho, Jisasme lowene sle mëtletlabë onehome fleflesu lamëtlekefëtëma na bume megali lamëtlekefëtëma, “Bu lale lale oneho mu mëtabëya.” Kwe buna lokome uli lamëtletëma. ");
INSERT INTO nce_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Na feilawa onehomu bu Jisasme lowene sle mëtletla na Jisasme lowene sle mëtletlabë oneho flina iniwa sago mëtla. ");
INSERT INTO nce_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Iniwa oneho bu klelegowa wesibi Aposel ho kë blëge blëge mogotomabë wafi lowene mëtletëma. Na bu tëbo atona onehome këme mëtlesumetëma. Na Pita kë betelë asë lëglebë alëge mëglëbome ni labuku kahëba motokouja. Bu metole lamëtla, Pita bu loliwa lisime na toba gwa lëtagutëmeme, bubë ato sle mëletëmeme. O melë hana lëglena, kwe bubë amtëtombawa lamu lotomeme na bu sle mlame. ");
INSERT INTO nce_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Na feilawa oneho Jerusalem lifate lime kë tafa mokoujabë bu mata, ato tëbona enëneme na ahwane kë tëbo mogotomebë enënename, Aposel ho betelë mëtlesumetëma. Na bu kë onehome, Jisasbë afutuku sle tëtagume. ");
INSERT INTO nce_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Gotobë tako lotu lo mëta wege lëglebë tako eso ho, bu Sadyusi enënena ilawa yonane mëglabë ho. Na bu iniwa, Aposel enëne kë mëtëglabë wesibi yafe hwi motloma na bume moumou mëtlelëma, feilawa enëne Aposel enënebë loweneme tako fleflesu mëtletëmame nëgeme. ");
INSERT INTO nce_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Këme nëgeme Aposel home fafa mëtla na kalabusu lowa sike mëtla. ");
INSERT INTO nce_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kwe klabë Gotobë ensel kalabusu lo ino tika totle na Aposel home tlelëkakime na megali tlome, ");
INSERT INTO nce_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Sobo eyeume na Gotobë tako lotu lowa ekaklujome na onehome gali të eoutatemome. Na Gotobë unaunalë lale tafa lëglelëmebë gali, onehome të eoutatemome.” ");
INSERT INTO nce_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Aposel ho bu kë gali aholokwane mëtla na kwe olobalëmu Gotobë tako lotu lowa mëtëkakluja. Na bu onehome Jisasbë galime okokwe motloma. Na lotu lo mëta wege lëglebë letitabo hona bubë yabenina, Israelbë afenëbonibë lotu eso enëneme na fli Israelbë afenëbonibë eso enëneme mata gali mëtelokwakëma migisiya namëglame. Na bu mitisiya na iniwa loko mëtlelëya. Na bu lotu lobë plismanë, kalabusu lowa jine mëtelulukakëma, Aposel home nëno namëglame na bubelëme mëglesuma namëglame. ");
INSERT INTO nce_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Na plismanë kalabusu lowa mutuja kwe bu Aposel home hwi hana motloma. Na bu Israelbë afenëbonibë lotu eso enëne belë ita mutuja na lotu eso enëneme megali motloma, ");
INSERT INTO nce_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Sebo kalabusu lowa tuja na kalabusu ino hwi tlola, tiji sle wamëtla. Na kalabusu ino ëfo mëta kë miglibekefëyabë ho bu mana mitlija. Na kwe sebo ino tika totlana, sebo ho limeha kë mëta hwi hana telujuwelëla.” ");
INSERT INTO nce_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Gotobë tako lotu lobë plismanëbë eso ho na lotu lo mëta wege mëglabë eso ho kë gali aholokwane mëtla na tako tutune memëtla na gali mëtla, “Bu ebëha wesibi melë kë lëglebë, fëye wesibi fata lëglemene?” ");
INSERT INTO nce_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Na ho li tisi na gali tlome, “Aholokwane elo! Sobo kalabusu lowa kë tëglelumobë ho, bu Gotobë tako lotu lo mëta milibo na Jisasbë galime onehome okokwe molomo.” ");
INSERT INTO nce_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Këme nëgeme, lotu lobë plismanëbë eso ho na fli plismanë mutuja na Aposel home nëno mutula na mëtlesuma. Kwe bu Aposel home tëbo hana mototoma. Bu onehome uli mëtletëmame nëgeme, bume anijina mogo nalë tëtëkle mëgëtayalime. ");
INSERT INTO nce_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Na plismanë, Aposel home mëtlesuma. Na bu Israelbë afenëbonibë lotu eso enënebë naba lime mitlibo. Na Gotobë tako lotu lo mëta wege lëglebë tako eso ho bume megali tlome, ");
INSERT INTO nce_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Sebo some Jisasbë galime onehome tëme waheheë tletëyo. Kwe sobo sebobë gali boblomu latotlo na sobo kë hobë galime, Jerusalem lifate mago enëneme iniwa wafi okokwe elagumo. Na sobo seme gali blawa meso naegëtatëname fene, ‘Jisas kë gli tëglebë gli eso, somëta lëbetëyo.’ ” ");
INSERT INTO nce_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Kwe Pitana Aposel flina bubë gali metafu mototla, “Sebo Gotobë galiwa esogo nëglelëtlame. Sebo hobë gali hana esogo nëglelëtëmame. ");
INSERT INTO nce_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Sobo Jisasme mogo nalë ti mëta bu telo. Kwe sebobë semlenibë Goto, bume huju totle. ");
INSERT INTO nce_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Goto bume tako fleflesu metletle na bume tilekole na bubë tobamu toba elëme tafa lëgletlebëme gali tlole, buna iniwa, onehome eso home tafa namëgletemome. Na bu seme nëno lëglebë ho ekë tafa lële. Na bu seme Israelbë afenëbonime tëbo lowenebë aholokwana ti mëglabëme na lale lowenewa esogo mëglelëlabëme laitaname. Na Goto sebobë tëbo lowene aholokwana ti lëletëname. ");
INSERT INTO nce_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Jisasme kë fata mëtëgletlebë wesibi sebo wahwi tloma. Na sebo onehome kë gali të nëtakefëtëma. Na Gotobë Amtëtomba mata onehome lowene tlëme, ebë gali kë nëgebëye nëgalimu. Oneho, Gotobë lowene kë esogo mëglelëlabë, Goto bubë Amtëtomba bume tlëme.” ");
INSERT INTO nce_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Israelbë afenëbonibë lotu eso enëne, bu kë gali yafe aholokwane mëtla na bu feilawamu enisusu mëtla na Aposel home mogo nalë tëtëkle namëgëtayame fene. ");
INSERT INTO nce_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kwe letitabo ho li bubë ku mëta tëtabe, bubë weniji Gamaliel. Kë ho bu Farisi ho, na bu Mosesbë tafa sle galime, okokwe loglokwefëmebë ho. Iniwa oneho bume tako fleflesu lamelekefëtla. Na kwe bu huju tle na gali tlome, “Sobo Aposel home toho elelëkakëmo, haha sogë tafuwa namogujetlame.” ");
INSERT INTO nce_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Bu Aposel home toho mëtlelëkakëma. Na Gamaliel bu Israelbë afenëbonibë lotu eso enëneme gali tlome, “O Israelbë afenëboni, sobo kë enëneme wesibi li egëtatemome tole egelona kwe sobo lowene sle afina elome. ");
INSERT INTO nce_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Sobo walowene elo, ëtani nane, ho li tëtabe, bubë weniji Teudas. Bu bume melowene latle, ‘Bo tako ho, eso home lalowa tafa nëgelëmefe.’ Na onehome gali tlome, bume esogo namëglelëlame. Na 400 ho këniji, bume esogo mëtlelëla, gavman enëneme boblo namogotomame fene. Kwe wame home boblo mogotomabë enëne bume mogo nalë tëke motlola na iniwa ho bume kë esogo mëtëglelëlabë lamëtlëboujawa, na gavmanme wame moglolabë lowene aholokwana ti mëtla. ");
INSERT INTO nce_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Na tokwafe, gavman, onehome tabei tokouna, Galili provins mago Judas bu tisi na fli onehobë wame lowene tufiji tëtatëme. Na fli oneho bume esogo mëtlelëla na Gavmanme heheëme wame mla. Kwe wame home boblo mogotomabë enëne bume mogo nalë tëkle mototla. Na iniwa ho bume kë esogo mëtëglelëlabë lamëtlëboujawa. Na gavmanme wame moglolabë lowene aholokwana ti mëtla. ");
INSERT INTO nce_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Këme nëgeme, eli bo some gali nolëyo, sobo kë Aposel home asa tëbo etomo. Sobo bume hwiwa elomo, tafa matla. Kwe ebë wege bu kë fa mogotlabë, hobë afutuku magowa nëgena, kwe tëbo lëgletëmeme. ");
INSERT INTO nce_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kwe ebë wege bu kë fa mogotlabë, Gotobë afutuku mago nëgena, kwe sobo lëkle hana egotomome. Sobo melë egelona kwe Gotome wame lalolo.” Na kwe Israelbë afenëbonibë lotu eso enëne bu Gamalielbë lowenewa esogo mëtlelëtla. ");
INSERT INTO nce_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Na kwe bu ita Aposel home gali motloma, mëkakluja namëglame. Na bu mëtëkakluja. Na bu lotu lobë plismanëme gali motloma, taba afona lëlafa namogotomame. Na bume lëlafa mototoma. Na Israelbë afenëbonibë lotu eso enëne, bume anisasa galina lëkle mototoma, “Sobo Jisasbë gali onehome itaita asa të eoutatemo. Matëbe.” Na bume mana jine mëtelëkakëma. ");
INSERT INTO nce_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Aposel ho, bu Israelbë afenëbonibë lotu enëneme hune mëtla. Na fleflesu motokouja. Bu Gotome melowene mëtletlame nëgeme, “Bu seme fleflesu lalëletëna. Sebo Jisasme lowene sle nëgletlabë ho nëgeme na oneho seme këme wame molona.” ");
INSERT INTO nce_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Na iniwa olë bu Gotobë tako lotu lowa mutujukefëya na Jisasbë galime onehome okokwe motlokwefëma. Na onehobë lowa mata mutujukwefëtëma na Jisasbë galibëme onehome okokwe mëtlagukwefëma. Na bu megali sle lamëtla, “Goto Jisasme jine tlële, bubë onehome nëno lëglebëme.” ");
INSERT INTO nce_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Na kwe, kë olëna, Jisasme lowene sle mëgletlabë oneho, bu lebutakomu mëtëtabëya. Na kë mago, Grik gali lowene mëglabë oneho bu Hibru gali lowene mëglabë onehome wame motloma na megali lamotloma, “Iniwa olë sobo hi wesibime kë afolo mëglabë onehome laitakefëmo, kwe sebobë seiju oneme hana aitakefëmo.” ");
INSERT INTO nce_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Këme nëgeme, we ita tële Aposel, Jisasme lowene sle mëtletlabë onehome gali mëtelëkakëma, bu belëme migisitëma namëglame. Na bu mitisiya na bume megali motloma, “Sebo hi wesibi sa wege kë fa nogotlabë seme Gotobë gali tëme lëkleha lalëtana. Kë lale nane. Sebobë wegemuwe, Gotobë galiwa të nogotokweflabë. ");
INSERT INTO nce_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Këme nëgeme, afanino na mësenëbanino, sobo somago, tobali ita tële lale home hwi sle saelomo, kë hi wesibi sa wegebëme mogoutatla namëglame. Lale lowenena mëtabëyabë home hwi sle elomome. Na Gotobë Amtëtombabë afutukuna kë tafa mëglabë home mata hwi sle elomome. Na sebo Aposel ho bume kë hi wesibi sa wegebëme aniji nanoglomame. ");
INSERT INTO nce_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kwe sebo kwe, Gotome gëgali nëglelëkeflame na Gotobë gali onehome okokwe nolokwefëmame.” ");
INSERT INTO nce_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Iniwa oneho bu kë galime fleflesumu lamëtla. Na bu Stivenme aniji motlola. Stiven bu Gotome feilawamu lowene sle tletle. Na Gotobë Amtëtombabë afutuku bu mëta feilawa tëtabetle. Na bu Filip na Prokorus na Nikanor na Timon na Parmenas na Nikolasname aniji motloma. Nikolas bu Antiok life mago ho na bu Israelbë afenëbo nane. Kwe bu Israelbë afenëbonibë lotu tokwafe esogo tlelële. ");
INSERT INTO nce_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bu kë tobali ita tële ho, Aposel enënebë naba lime mitlija. Na Aposel ho Gotome gëgali mëtlelëla, kë home lëgaitame nalëgleme. Na bubë toba kë hobë eso mëta gogwa motoletëma, bume kë wege fame aniji motloma. ");
INSERT INTO nce_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Na Gotobë gali li life li life fifiji mëtlelëla. Na Jerusalem lifate mëta, Jisasme lowene sle mëgletlabë oneho bu feilawamu fata mëtla. Na lotu lo mëta wege mëglabë ho feilawa mata, Jisasme lowene sle mëtletla. ");
INSERT INTO nce_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Goto Stivenme tako lëgaitale lalële na tako afutukumu tlële. Këme nëgeme Stiven bu feilawa klelegowa wesibi onehobë naba lime këme blëge blëge lotokwefëme. ");
INSERT INTO nce_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kwe fli ho bu Stivenbë gali tole hana mëtletla na bume momata mëtlelëla. Kë oneho bu Israelbë afenëbonibë li lotu lo mago. Bu kë lotu lo mefë lamototla, “Frimanbë lotu lo.” Kë ho fli bu Sairini lifate na Aleksandria lifate mago na fliye bu Silisia na Esia provins mago. ");
INSERT INTO nce_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kë ho Stivenbë gali boblo mëgëtatlame fene kwe Gotobë Amtëtomba Stivenme lale lowene tlële na bubë gali boblo hana mëtëtatla. ");
INSERT INTO nce_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Këme nëgeme bu fli onehome uwabeli baliti mëtlëma, na megali motloma, “Sobo Stivenme megali saso etatelo, ‘Sebo Stivenme waaholokwane tlola, Mosesname, Gotoname tëbo gali latlome.’ ” ");
INSERT INTO nce_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Na kë galina, onehobë, na Israelbë afenëbonibë eso enënebë, na Gotobë galime okokwe moglomabë hobë wame lowene tufiji mëtëtatëma. Na bu Stivenme fame mutuja na Israelbë afenëbonibë lotu eso enëne belë mëtlesula. ");
INSERT INTO nce_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Na fli home mata mëtlesuma, Stivenme gali so namëgëtatlame. Kë enëne megali lamëtla, “Kë ho Gotobë tako lotu lome sisile lalotokwefle. Na Goto Mosesme kë gali toglolebë tafa sle galime mata itaita sisile lalotokwefle. ");
INSERT INTO nce_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Sebo bume meaholokwane latlola, ‘Nasaret life mago Jisas bu Gotobë tako lotu lo yayei lotleme, na Mosesbë anebo gali ëtani afuninome kë tëglëmebë hihijika lëleme.’ ” ");
INSERT INTO nce_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Na Israelbë afenëbonibë lotu eso enëne iniwa, Stivenme feilawa wëya mëtlelëla, na bubë weniyane, enselbë weniyane fenene mehwi motlotla. ");
INSERT INTO nce_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Na Gotobë tako lotu lo mëta wege lëglebë tako eso ho, Stivenme metakune tlole, “Ju lowene lalene? Ebë gali, ho jume kë so mëgëtatëyobë, nëgaline o sogëna lamla.” ");
INSERT INTO nce_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Na Stiven Israelbë afenëbonibë lotu eso enëneme megali latlome, “O afani na ayani, sobo aholokwane elo. Ëtani, sebobë tako afutukuna Goto, sebobë semle, Abrahamme fata tletle. Kë olëna, Abraham bu Mesopotemia provins mëta mana tafa tle. Bu Haran lifatewa tuguju jwa tle. ");
INSERT INTO nce_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Na Goto bume megali tlole, ‘Jubë home hune elëme. Na jubë life mata kile elëme. Na jume lebotane gali kë nëtatëbë life elëme ejume.’ ");
INSERT INTO nce_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Na Abraham bubë life, Kaldia, kile tle. Na bu Haran lifate mëta tafa tule. Abraham bolijaya wafi gli tle na Goto, sebo ëje kë tafa nëglabë life elëme jine telëbakle. ");
INSERT INTO nce_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Kwe Goto bume kë lifebë flëke afloko tokwëfo hana tlële. Weye. Hanane. Kwe Goto bume megali slewa latlole, ‘Kwe tokwafe, bo jume ebë life nëglëme. Na kwe kë life melëgëbeme, jubë na jubë bisemleninobë.’ ");
INSERT INTO nce_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Goto bu Abrahamme li galime megali latlole, ‘Jubë bisemlenino bu li life mëta tokwafe nibowai mugulame. Na bu kë life enënebë wege manawa fa mëtakefëtëmame. Na kë bisemlenime tëbo mogotomabë tlibutu këniji 400. ");
INSERT INTO nce_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kwe tokwafe bo kë onehome tëbo nogotomëme. Na tokwafe bisemleni kë life kile mlame na misiyame. Na ebë life kë nëgebë mëta bome lotu mëlekefëtëname.’ ");
INSERT INTO nce_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Na Goto gali tle, Abraham bubë ato jibo tlë lotleme, na bubë tokwafe fata mëglabë iko nëbalebë ato jibo mata, satëtlë mogotometëmame. Kë yayahuju melëme lëlekuju lëletëmeme, bu Gotobë onehomu mëtabëya mëglamemu. Bu kë yayahuju hwi moglomana, Goto bu Abrahamme kë gali sle toglolebë galime, ita lowene mletlame. Na tokwafe, Abraham nëbana tle. Bubë weniji Aisak. Kë nëba tobali ita aona olë këniji tëtabe na bu kë nëbabë ato jibo mana tlë tëtatle. Na Aisak bu nëbana tle. Bubë weniji Jekop. Na bume mata kë fene melë latotle. Na Jekop bubë we ita tële nëbaleme mata melë latotome. Kë we ita tële nëbale kë nëgebë bu sebobë semlenino. ");
INSERT INTO nce_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Jekopbë nëbale, bubë bolijahani Josepme, tako moumou lamëtlelëla. Na tëbo lowene memëtletla. Na bu Josepme, li life mago enëne mëta balitime hihijika mëtla, li hobë wege manawa fa nalëtatleme. Na kë enëne bume Isip lifatewa mëtlelula. Kwe Goto buna mëtëtabo. ");
INSERT INTO nce_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Goto bume taitale, na iniwa tëbo wesibi bume kë fata mëtletlebë, Goto bu sle totometle. Bu eso ho Ferobë naba lime tiglibena, Goto bume taitale na lale lowene tlële. Këme nëgeme eso ho Fero bume tako tole latletle na bume Isip lifate mago onehome tafa lëglelëmebë eso home aniji tlole. Na bubë lo mago iniwa wesibi hwi loglometlebëme mata anijii tlole. ");
INSERT INTO nce_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Tokwafe tako fone Isip lifate mëta na Kenan lifate mëta fata tle. Na iniwa oneho bu tëbo tafa memëtla. Na sebobë semlenino bu hi wesibime afolo mëtla. ");
INSERT INTO nce_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kwe Jekop ebë gali aholokwane tle, hi wesibi Isip life mëta kë mëbe. Na bubë nëbaleme Isip lifewa otome afina jine tlëme, hi wesibi glo namugulame. Na bu mutuja hi wesibi glome. Na hi wesibi glo mutula. Na ita mitisiya. ");
INSERT INTO nce_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Na kë hi wesibi wafi yawe motloma na kwe bu ita mutuja na Josep bubë bolijahanime gali tlome, ‘Bo Josep, sobobë keinëba.’ Na tokwafe, Isip life mago eso ho Fero, Josepbë ilawa mago enëneme lowene tletëme. ");
INSERT INTO nce_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Na kwe Josep, bubë bolijahaninome gali tlome, ‘Sobo eyeume. Na sebobë aya, Jekopme gali ejuwelolome. Buna, sebobë ilawa mago onehona, iniwa esijo naegelome, Isip lifateme tafa naegelome.’ Na kë enënebë tabëi bu këniji, 75 oneho. ");
INSERT INTO nce_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Na kwe Jekop, bubë nëbalena, Isip lifewa mitimiya na këme tafa mëtemola. Na tokwafe buna bubë nëbalena, kë mëta fwa gigli mëtemola. ");
INSERT INTO nce_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Na bu mogo, kë mago Sekem lifewa mëtehwotuja. Na këme matëmatë mëta gogwa mëtetula. Ëtani Abraham bu kë matëmatë life, Hamorbë bowenenino mago, balitina fa totle.” ");
INSERT INTO nce_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Na Stiven ita gali tle, “Ëtani Goto Abrahamme megali sle tlole, bubë afenëbonime lëgaitametleme na wame enënebë toba mago nëno lëleme. Na kë olë fata lëgleme lololi lalële. Na Israelbë afenëboni bu Isip life mëta lebutakomu fata mëtla. ");
INSERT INTO nce_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Na kë nalëwa, tiho eso ho Isip life mëta fata tle. Kwe kë eso ho, Josep ëtani kë fa togotlebë wege, lowene hana tletle. ");
INSERT INTO nce_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Na kë eso ho bu sebobë semleninome sogëna latlome na tëbo totome. Na bume gali tlome, ‘Sobo iko nëbale fufu egelona kwe walujume sahune elekefo, gigli namëglame.’ ");
INSERT INTO nce_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Na kë olëna, bota Mosesme mana fu totle. Na bu lale nëba klisomu fata mototlo. Botana bolijayana hwelutuwa lo mëta aona yeme mëtlëlo. ");
INSERT INTO nce_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Tokwafe bume waluju mëta gwa mutujetla. Na eso hobë boko hwi tujuwelële na fa totle. Na bubë nëbaha fata tletë. ");
INSERT INTO nce_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Na Isip life enënebë iniwa lale lowene, bume okokwe motlola. Na bu gali anisasana anebo gali lëglebë ho tëtabe. Na tatako kalëlego wege fa togotlebë afutukuna ho tëtabe. ");
INSERT INTO nce_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Moses bu nili yafewe tlibutu këniji wafi tle na bubë enëneme hwime lowene tle. Kë enëne bu Israelbë afenëboni. ");
INSERT INTO nce_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Na bu fe tëkake, na Isip life mago home hwi tlole, Israelbë afenëbo mago ho lime, tëkle totle. Na bu fewa tëkakebë na bubë ilawa mago home taitale. Na Isip life mago home mogo nalë tëke tlole. ");
INSERT INTO nce_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses bu melowene latle, ‘Bubë enëne bume melowene namëgletlame, “Goto bume wafi aniji tlole, bume lëgaitame nalëglebëme na Isip life mago nëno nalëglebëme.” ’ Kwe bu këbëme lowene hana mëtletla. ");
INSERT INTO nce_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Jowafe niwa tëbe na ita Moses tuju. Na bu tlemalë Israelbë afenëboni blalo momogli mëtëto kë labu mëta hwi tlome. Na bu belë tujutëme, bubë wame lëkle nalëgëtatëmeme na gali tlome, ‘Hai! Sobo ilawa magofe. Sobo sobolalo memomogli fëyeme etone?’ ");
INSERT INTO nce_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Kwe wame kë togotlebë ho, Mosesbë gali fleflesu hana tletle. Këme nëgeme Mosesme so telëkakle, na gali metafu tëtatle, ‘Sebobë eso home na sebobë tafa hwi eglotënabë home jume ya aniji tolëne? ");
INSERT INTO nce_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ju bome gli nalë tëke naeglonëmene, yame Isip life mago home mogo nalë fene tëke tlole? Ju bome melë naegëtanëmenë.’ ");
INSERT INTO nce_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses kë gali yafe aholokwane tle na bu Midian lifatewa ulime tlëboukaku. Bu kë mëta tako tafa tule. Na mëse sei tlë. Na iko nëbale tële fata totome. ");
INSERT INTO nce_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Moses bu kë lifate mëta niliafewe tlibutu këniji tafa tule. Na tokwafe, li olëna, Moses ho jwa tabo mëta, Sainai fatini wayo li mëta, tafa tle. Na ahojuna ti tokwëfo hwi telokwakle. Na ensel kë ahoju mëta, Mosesme mana fata tletle. ");
INSERT INTO nce_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses klelego metletle. Na bu melëme tole tle, lolime hwi sle nalogloleme na këme nëgeme bu loliwa tuju tle. Na Tako Ho bume megali latlole, ");
INSERT INTO nce_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Bo bisemlenibë, Abraham, Aisak, Jekopnabë Goto.’ Na Moses lili tle na ita kë ahoju hwi loglolebëme uli metletle. ");
INSERT INTO nce_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Na Tako Ho gali tlole, ‘Jubë juba jibo hohwaga ele. Ebë life ju kë mëta kë eglibebë, ebë bobë life nëgeme. Bo kë mëta tafa nëgelëbë life. ");
INSERT INTO nce_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Bo Isip life mago oneho, bobë onehome kë tëbo mogotomabëme, wahwi nolomë. Bo bubë elili afëflei lego waaholokwane nolotemë. Ëje bo këme netujulë, bume nëgaitamë nanëgelëme, Isip life onehobë toba mago nëno nanëgelëme. Këme nëgeme bo jume gali nolë, ju huju ele. Bo jume Isip lifatewa ita jine nëgelëkakëme.’ ");
INSERT INTO nce_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ëtani, Israelbë afenëboni bu Mosesme boblo lamototla na megali lamotlola, ‘Sebobë eso home na sebobë tafa hwi eglotënabë home, jume ya aniji tolëne?’ Kwe kë Moses fwa Goto jine tlële, Israelbë afenëbonibë eso home tafa nalëgletëmeme. Na bume Isip life mago nëno nalëgleme. Goto bume kë ti tokwëfo wayo mëta enselha fata tletle. Na bume kë wegeme mana aniji tlole. ");
INSERT INTO nce_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Na Moses bume Isip life mago tlelume. Na bu memelë klelegowa wesibi blëge blëge totome. Bu kë klelegowa wesibi Isip life mëta na Winowa Nutu mëta mata blëge blëge totome. Na bu ho jwa yenëbawa life mëta, niliafewe tlibutu kë asë tëglelëmebë olëna mata blëge blëge totome. ");
INSERT INTO nce_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Na kë Moses buwa, Israelbë afenëbonime megali latlome, ‘Goto, sobobë ilawa mago ho lime aniji logloleme, bubë gali të nalëgëtatëyome. Na bo, Gotobë lowene mago gali të notokweflëbë ho fene tafa nelë, bu mata mefata nalëgleme.’ ");
INSERT INTO nce_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Sebobë semlenino ho jwa tabo elëme mutuja. Na këme loko mutulelëya na Moses buna tafa tlelëme. Na bu Sainai fatiniwa tokwale na Gotobë ensel bume gali mana tlële. Na bu Gotobë gali fa totle. Kë lale galibë seme ëhwati tafabëme lëgaitana nalëgleme. Na Moses kë gali seme tlëna. ");
INSERT INTO nce_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Kwe sebobë semlenino Mosesbë gali boblo lamëtëtatla. Na bu Isip lifatewa, ita muguja namëglabëme, tako tole memëtla. ");
INSERT INTO nce_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Moses bu Sainai fatini mëta mana tafa tole, na Israelbë afenëboni Eronme megali motlola, ‘Moses seme Isip life mago kë tëglesunabë, bume fëye wesibi fata loletle nawa. Bu ita hana lëgetujuleme nawa. Këme nëgeme, ju seme fëso li blëge blëge etatëna, na bu Gotoha fata nalëgletëname. Na bu seme lëgaitana nalëgleme na logoutatëna nalëgleme na alëge lebotane nalëtagutëname.’ ");
INSERT INTO nce_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Na kë nalë bu bulmakau kleli nëba fëso blëge blëge totle. Na bu kë bulmakau kleli nëba fësome, wesibi ahojume mëtletla na bu kë sinikibome fleflesu nalëgletëmeme. Na bu tako hi wesibi blëge mototla. Na bu kë blëge mototlabë wesibime mana fleflesu mëtletla. ");
INSERT INTO nce_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Këme nëgeme, Goto bume yeolë latletëme. Na bu kliji name, yeme name, sëgetoba name lotu namëgletëmame. Na kë wesibi melë latle, ëtani Gotobë lowene mago gali të mototokweflabë hobë bogo mëta gali fene tëbe. Kë gali melë, ‘Sobo Israelbë afenëboni, sobo ho jwa tabo mëta niliafewe tlibutu këniji tafa tëgelobë, sobo bulmakau kleli na sipsip kleli tëtëkle tëtakefëyo na ahojume ahojume tlekefo. Kwe sobo këha wesibi bome nane totometëna. Weyewa. ");
INSERT INTO nce_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Na sobo kë asë eglelëlobë selë lotu lo, bobë lotu lo nane. Weye. Bu sogëna goto Molokbë lotu lo. Na sobo, sogëna goto Refanbë sëgetoba weniyaneha wesibi, asë elelëlo. Sobobë tobana kë blëge blëge egotomobë wesibime fwa lotu eletemo. Këme nëgeme bo sobobë life mago këme hehë nëkaketëyome. Na some Babilon lifate elëme jine nelëkakëyome na sobo Babilon lifate sigli etokwaklome na tafa ekekome.’ ");
INSERT INTO nce_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Sebobë semlenino bu ho jwa tabo mëta tafa mëtlana, bu Gotobë selë lo asë lamëtlelëkefëtla. Kë selë lo bu melëme lëlekuju tle, Goto bubë ku mëta tëtabe tëme. Bu kë selë lo kë gliji mëtëglabë, bu iniwa wesibi Goto Mosesme fene gali tlole, bu këha melë lamototla. Na Goto, Mosesme fene lebotane tëtatle, bu këha melë lamototla. ");
INSERT INTO nce_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Tokwafe, kë semleninobë nëbale, bu kë selë lo ita fa mototla, na buna Josuana mitisiya, kë life mago enënebë life wame nagi hilika mototoma. Na Goto bu kë life mago enëneme hehë tletëme. Na bu kë selë lo kë life mëta lë mototla. Na kë selë lo kë lifeme tlibekëfebë, na eso ho Devit mana fata tle. ");
INSERT INTO nce_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Na Goto Devitme fleflesu latletle. Na Devit Gotome takune tlole, ‘Bo jubë tako lotu lo lalowa gliji nëgelëmene, bobë semle Jekopbë afenëboni, këme lotu namëglekefëtëyome?’ Kwe Goto kë lotu lo glijime ehe hana tlole. ");
INSERT INTO nce_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kwe tokwafe Devitbë nëba Solomon kë lotu lo gliji tle. ");
INSERT INTO nce_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Kwe tako afutukuna Goto, bu ho tobana gliji mëglabë lo mëta hana tafa lëglekëfeme. Gotobë lowene mago gali të totokweflebë ho fene gali tle. Bu megali latle, ");
INSERT INTO nce_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Tako Ho megali lalële, Heven life ebë bobë tafa labu. Na ebë life kë nëgebëye, bo juba këme gogwa nolë. Na bo kë iniwa wesibibë eso ho tafa nëletemë. Këme nëgeme sobo fëye lo gliji egletënamene, bo këme tafa nanëgelëme? Weye. Sobo bome lo habëna gliji egletënamene? ");
INSERT INTO nce_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Iniwa wesibi heven life mago na ebë life mago bowa blëge blëge totomë.’ ” ");
INSERT INTO nce_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Na Stiven, Israelbë afenëbonibë lotu eso enëneme, gali tlome, “Sobo aholo titiji tabo enënemu. Sobobë lowene bu tëbo lowenewa lëbetëyo, Gotome lowene jwa mëgletlabë enënebë loweneha lëbetëyo. Na sobo Gotobë gali aholokwane hana elolo na esogo hana elelëlotelo. Sobo Gotobë Amtëtomba galibë itaita boblo latlo, sobobë bisemlenino fene boblo mëtëtatla. ");
INSERT INTO nce_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Sobobë semlenino bu Gotobë lowene mago gali të mototokweflabë home iniwame, wame lamotlokwefëma. Ëtani, Gotobë lowene mago gali të mototokweflabë ho fli, bu megali lamëtla, ‘Gotobë lale lowenewa kë esogo lëglelëkefetlebë home, jine lëglëleme.’ Na sobobë semlenino bu kë gali metletëmabë enëneme mogo nalë tëtëkle mëtëtaya. Na Gotobë lale lowenewa kë esogo lëglelëtlebë ho wafi tisi. Na Goto bume fleflesu latletle. Kwe sobo bume wame home yo tlomo na bume mogo nalë tëkle mototla. ");
INSERT INTO nce_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Goto bubë enselme jine tlëme na bubë gali sebobë semleninome mëtlëma. Na sobo kë gali waaholokwane tletemo kwe sobo esogo hana tlelëtemo.” ");
INSERT INTO nce_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Israelbë afenëbonibë lotu eso enëne, Stivenbë gali yafe aholokwane motlola. Na enisusumu memëtletla. Na enino këkë memototometla. ");
INSERT INTO nce_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kwe Gotobë Amtëtomba Stivenme afutuku tlële na bu heven elë hwi tokwake. Na Gotobë tako elulego hwi telokwakëtle. Na Jisasme hwi telokwakle, Gotobë tobamu toba elëme tlibetle. ");
INSERT INTO nce_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Na Stiven gali tle, “Aholokwane elo! Bo heven ino tikatabo wafi hwi nololë. Na bo Gotobë life mago home hwi nololë, Gotobë tobamu toba elëme lilibetle.” ");
INSERT INTO nce_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Bu kë gali yafe aholokwane mëtla, na Stivenme tako wame memotlola. Na bu feilawa juwafe mëtla na bubë tobana aholo titiji mototoma. Na iniwa huhuju mëtëkaka na Stivenme hohwë mëtlëla. ");
INSERT INTO nce_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Na bume Jerusalem lifate mëglëbo elëme tobana anisasana ki motokouja. Na aniji atome mana sisike mëtletla, bume mogo nalë tëkle namogotlame. Na bume gali kë so mëtëtatlabë ho, bubë matawa mago heletanëno ëho totohwa mototoma na falake hobë elebo lime gogwa mëtla. Kë falake hobë weniji Sol. ");
INSERT INTO nce_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Bu anijina mana tëkle mototla na Stiven Jisasme mana megali telokwakle, “O Tako Ho Jisas, ju bobë amtëtomba eli sa no elëtenë.” ");
INSERT INTO nce_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Na bu sëkefo miti tafa tle na feilawa we tlole, “Jisas, bome kë wame moglonabë onehome kofaya asa wame elome, aholokwana sati ele.” Bu kë galime wafi gali tlole na mana tuku tëkake. ");
INSERT INTO nce_vpl VALUES ("AC8_1a","074_8_1a","ACT","8","1a","1a","Na Sol, bu Stivenme kë tëkle mototlabë lowenebëme, helawawa latletëme. ");
INSERT INTO nce_vpl VALUES ("AC8_1b","074_8_1b","ACT","8","1b","1b","Stivenme kë tëkle mototlabë olëna, Jisasme lowene sle mëtletlabë onehome, Jerusalem lifate mëta kë tafa mëtlabë, kë oneho mëta afina oto mëtla tëbo namëtagumane. Këme nëgeme, Jisasme lowene sle mëtletlabë oneho iniwa Jerusalem lifate kile mëtla na Judia provins na Samaria provins li mago life elëme mëtlënëbouja. Kwe Aposel ho buwa, Jerusalem lifate mëta mëtëtabëya. ");
INSERT INTO nce_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Gotobë lale lowene esogo mëglelëtlabë ho fli, Stiven mogome fa mototla na matëmatë mëta gwa mutujetla na bume tako ye lamëtletlamu. ");
INSERT INTO nce_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Kwe Sol bu Jisasme lowene sle mëtletlabë onehome tëbo totokwefëme. Bu melatotokwefëme. Bu li lo li lowa fe tokoukefëtëme na onehome kë lo mago nëno tokoukëfe na kalabusu lowa tlelukefëme. ");
INSERT INTO nce_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jisasme lowene sle mëtletlabë oneho, bwa bwa lifate elë kë mëtlënëboujabë, bu Jisasbë lale gali iniwa lifate mëta të mëtëtagutla. ");
INSERT INTO nce_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip Samaria provinsbë li lifatewa tuju. Na bu kë life mago onehome ebë gali të tëtatëme, “Jisas bu Goto kë aniji toglolebë ho na nëno lëglebë ho.” ");
INSERT INTO nce_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Feilawa oneho Filipbë gali aholokwane mëtla na bu kë blëge totlebë klelegowa wesibi hwi motlotla. Na këme nëgeme, bubë gali aholo bo sle mëtëtagutla. ");
INSERT INTO nce_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Na bu Filipme mehwi motlola, bu ahwane lebutako onehobë ato mago hehë tletëme. Na kë ahwane aflei tëbowa ëë memëtlële. Na kë onehome lahunewa mototome. Na feilawa oneho, elebo mogo tanënobë na elebo tëbonabë bu lalowa mëtëtabëya. ");
INSERT INTO nce_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Këme nëgeme, ebë life mago oneho bu tako fleflesu këme mëtla. ");
INSERT INTO nce_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ho li, kë lifate mëta tafa tle, bubë weniji Saimon. Bu itaita humë tlekëfe na memelë olo tlësëme. Na lebutako oneho, Samaria provins mago, wesibi bu melë kë tëglebëme, klelego memëtletla. Kë ho bu megali latlekëfe, “Bo tako letitabo ho tafa nelë.” ");
INSERT INTO nce_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Na letitabo ho fli na manawa oneho, kë hobë gali aholokwaneme, tako tole lamëtla. Na bu megali lamëtla, “Kë ho kë nëgebë, Gotobë tako afutukuna ho!” ");
INSERT INTO nce_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bu kë tëglekëfebë wesibime, feilawa oneho klelego lamëtlekefëtla. Na këme nëgeme bubë lowene këme esogo mëtlelëkefëtla. ");
INSERT INTO nce_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kwe Filip, Goto onehobë eso home kë tafa lëgletëmebë lale gali, të tëtatëme. Na Jisas Klaisbë lale gali mata të tëtatëme. Na oneho bu kë gali lowene sle mëtletla. Na Filip bume baptais totome. ");
INSERT INTO nce_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Na Saimon bu mata kë gali lowene sle tletle. Na Filip bume mata baptais totle. Na bu Filipna asë mëtelo na iniwa klelegowa wesibi Filip kë totokwefëmebë hwi tlome na klelego metletëme. ");
INSERT INTO nce_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Aposel ho, Jerusalem lifate mëta kë tafa mëtlabë, bu meaholokwane mëtla, Samaria provins mago oneho bu Gotobë gali lowene sle lamletla. Këme nëgeme bu Pita name, Jon name këme jine mëtlëma. ");
INSERT INTO nce_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Bu Samaria provinswa fwa mutulo, na bu Gotome gali motlolo, bu kë onehome, bubë Amtëtomba lëglëme nalëgleme. ");
INSERT INTO nce_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Filip bume ëbame Tako Ho, Jisasbë weniji nawa baptais totome kwe Gotobë Amtëtomba bu belë tigisi tëme hana tle. ");
INSERT INTO nce_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Këme nëgeme, bu Gotome afina gali motlolo na mana toba gogwa motoletëmo na Gotobë Amtëtomba bu belë tisi tëme. ");
INSERT INTO nce_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saimon bume mehwi tlome, bu toba gogwa mëtletëmo na Gotobë Amtëtomba bu belë tisi tëme. Këme nëgeme baliti glo tle na Jonna Pitana belë tisi tëme na gali tlome, ");
INSERT INTO nce_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Sobo kë afutukubë bome enëna. Na bo mata ho lime toba gwa nëgëtatëlëna, Gotobë Amtëtomba bu belë ligisi tle nalëgleme.” ");
INSERT INTO nce_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Kwe Pita bume gali tlole, “Gotobë Amtëtomba, Goto manawa kë lëglënabë, ju balitina hana fa egotleme. Hanane mu. Ju këha tëbo lowene fëyeme lowene elene? Juna, jubë balitina tëbo life mëta tëbo eglitame. ");
INSERT INTO nce_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Jubë lowene Gotobë naba lime lalowa hana lëbetë. Këme nëgeme, ju sebona Gotobë wegeme hana wege nëglame. ");
INSERT INTO nce_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ju kë tëbo lowenebë aholokwana ti ele, na Tako Hobë gali eholeme, jubë aholabu lowenebë sle nalëgëtatëme na aholokwana ti lëletëme. Bu jume maninibo lëgletëme nawa na jubë tëbo lowene aholokwana ti lëletëme nawa o hanane. ");
INSERT INTO nce_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Bo jume walowene nëletë, mëmaune lowene ju mëta takomu lëbetë. Na ju tetëbo lowene mëta fwa tei tafa elekëfe.” ");
INSERT INTO nce_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Kwe Saimon, Pitaname Jonname metafu latëtatëme, “Sobo Tako Home gali elolo, bome maninibo nalëgletenëme. Na kë tëbo wesibi, sobo bome kë gali eglonabë, bo belë migisitenë jwa namëgletenëme.” ");
INSERT INTO nce_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Na kwe Pitana Jonna, Jisasbë lale gali të mëtëtatemo na Jisas bume melë kë totomebë wesibime gali motlomo. Na tokwafe Pitana Jonna Jerusalem lifatewa mëtëyeu. Bu mëtëyeubë, na Jisasbë lale gali, Samaria provinsbë fli life elëme, të mëtëtagutemo. ");
INSERT INTO nce_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Gotobë ensel bu Filipme megali tlole, “Ju sagli elëleme na nëgemowelëme eimeme. Na Jerusalem lifate mago Gasa lifate elë kë lugujubë alëge elëme ejume.” Kë alëge bu ho jwa tabo mëta lëbe. ");
INSERT INTO nce_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Na Filip fe tëkake na kë alëge elëme time. Bu alëge elëme wafwa temole, na Itiopia lifate mago home, kë alëge mëta hwi tlole. Bu Itiopia lifatebë gavmanbë letitabo ho. Na bu Itiopiabë eso mëse, Kandasibë baliti tafa tlelëkefëmetëbë ho. Bu Jerusalem lifatewa Gotome lotume tugujubë kë mago tisi, ");
INSERT INTO nce_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","na bubë lifatewa luguju nalëgleme. Bu hos kleli kë kiki mëglebë kalë loha wesibi, wesibi mëta tafa tole. Na bu Gotobë lowene mago gali të totokweflebë ho, Aisaiabë bogo, hwi tlagwi. ");
INSERT INTO nce_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Na kwe Gotobë Amtëtomba Filipme gali tlole, “Ju kë kalë loha wesibi, wesibi li elëme ejume. Na ju kalë loha wesibi, wesibina, mëglëbo lëlë eyeu elome.” ");
INSERT INTO nce_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Na kwe Filip loli elë fëka tokou. Na mana aholokwane tlole, kë ho bu Gotobë lowene mago gali të totokweflebë ho Aisaiabë bogo hwi tlagwi. Na Filip këme takune tlole, “Ju kë gali wayobë lowene laletlene?” ");
INSERT INTO nce_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Na bu tafu tëtatle, “Ho li bubë wayo galibëme bome okokwe jwa loglonëna, bo habëna lowene sle nëgletelëmene? Ju kalë loha wesibi, wesibi elë lalowa etokwalemene na bona weife tafa nelome.” Na Filip bu kalë loha wesibi, wesibi elë fe tokwake. ");
INSERT INTO nce_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Gali bu kë hwi toglolebë, megali lalële, “Bu kë home sei mutujuwelëtëma, sipsip kleli mogo nalë tëkleme fene sei mutujuwelëtëma. Na kë ho bu ëfalëbo ji hana totle, sipsip kleli nëbalebë hobo fene le mëlëmetëma na bu afëflei mëgle jwa. ");
INSERT INTO nce_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Bume tiniji galina gali motlola. Na bume onehobë gali aholokwane moglomabë ho belëme mëtlelutëma. Kwe bume blawa so mëtëtatla na blawa tëkle mototla. Bume mogo nalë tëkle mototla na bu hana tafa lële. Këme nëgeme bu nëbale tafa jwa këme mletla.” ");
INSERT INTO nce_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kë ho kë gali hwi tlole na Filipme mana takune tlole, “Bo jume takune nolë, Gotobë lowene mago gali të totokweflebë ho, bu yalëme gali tletlene? Bu bume gali tlene o bu li home gali tletlene.” ");
INSERT INTO nce_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Na kwe Filip kë home gali okokwe tlole. Bu Aisaia kë yahi tëglebë wayo gali afina okokwe sle tlole na bu Jisasbë lale galime mata okokwe tlole. ");
INSERT INTO nce_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Tlemalë bu kë alëge elëme mëtëyeubëë na tu helefo elë fwa mutulo. Na kë ho gali tlole, “Ju hwi ele, tu ekë lemule. Ju bome lalowa baptais egëtanëmene?” ");
INSERT INTO nce_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Na kwe, kë letitabo ho, bu hos kleli kë asë lëglelëlebë home gali tlole, “Ju hos kleli lëkle etle.” Na bu Filipna kë tu elë kle mëtëtëkako na Filip bume baptais tetofakle. ");
INSERT INTO nce_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Na bu tu kile mëtelo na helefowa fe motokoko. Na Gotobë Amtëtomba Filipme kë mago latëglelulewa. Na kë letitabo ho bume ita hana hwi tlole, kwe kë ho bubë lifatewa fleflesuna tuju. ");
INSERT INTO nce_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Na Filip bu Asdot lifatewa hokweinawa lafwawa tule. Na Jisasbë lale gali li life li life meta te tëtagutëme na mana Sisaria lifewa fwa tule. ");
INSERT INTO nce_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Kë nalë, Sol bu mana anisasana gali tlekëfe, “Bo, Jisasme lowene sle mëtletlabë onehome, mogo nalë tëbo nogotomëme.” Na bu Gotobë tako lotu lo mëta wege lëglebë tako eso ho elëme tujutle, ");
INSERT INTO nce_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","na bume takune tlole, “Ju Israelbë afenëbonibë lotu lo hwi moglokeflabë home, Damaskus life mëta kë tafa mëglabë, pasë lalowa yahi ekaketëmemene?” Na kwe Gotobë tako lotu lo mëta wege lëglebë tako eso ho pasë yahi tletëme na Solbë tobame tlële. Kë pasë megali lala, “Sol, Jisasme lowene sle mëtletlabë onehome hwi loglomena, kwe lalowa fafa malële na kalabusu lowa sike malële na Jerusalem lifatewa sei lëlëkakimeme.” ");
INSERT INTO nce_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Na këme, Sol Jerusalem lifate kile tle na Damaskus lifate elëme tuju. Bu Damaskus lifatewa tuhu lëgleme kofene, na heven life mago elulego mana hokweinawa lafatawa tletle na bume ini lamuwa totle. Kë elulego takomu. ");
INSERT INTO nce_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Na Sol lifeme latitigowa. Na bu li hobë we lego aholokwane tlole na bu këme gali tlole, “Sol, ju bome fëyeme tëbo etakefënëne?” ");
INSERT INTO nce_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Na Sol takune tlole, “Tako ho, ju yalëne?” Na bu tafu tëtatle, “Bo Jisas, ju bome tëbo latakefënë. ");
INSERT INTO nce_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Te! Huju ele. Na Damaskus lifate elë ejume na këme eoutabeme. Na ho li jume gali loglëme na ju kë iniwa gali saesogo sle elelëmetle.” ");
INSERT INTO nce_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Solna kë mutujabë ho klelego memëtletla, na gëgali hana mëtla, ëfasuna tafa mëtla. Bu gali lego aholokwane motlola, kwe kë home hwi hana motlola. ");
INSERT INTO nce_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Na këme, Sol huju tle na bubë naba yafe tika totome kwe bu wesibi hwi hana tlome, bubë naba kilego mëtletleme nëgeme. Këme nëgeme bume tobame fa mototla na Damaskus lifatewa nasi mëtëtagula. ");
INSERT INTO nce_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Bu naba kilego tabo tëgëtabebëë aona olë latle. Na kë aona olëbë bu hi jwa tafa tle. ");
INSERT INTO nce_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Na Jisasme lowene sle lëgletlebë ho li, Damaskus lifate mëta tafa tle. Bubë weniji Ananaias. Na bu nimitelë hwi tle, na Tako Ho Jisas bubë weniji fë tëtatle, “Ananaias.” Na Ananaias tafu tëtatle, “Tako Ho, bo mana ekë.” ");
INSERT INTO nce_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Na këme, Tako Ho, megali tlole, “Ju huju eleme, na alëge mefë lamotla, Ininiwa alëge, ju kë belëme ejume. Na ju Judasbë lowa ejume na ho li Tarsus lifate mago kë mëta tafa lële na ju takune eletleme, ‘Tarsus life mago ho hameta lëtabene bo hwi nanoglolëme.’ Kë hobë weniji Sol. Bu Gotome mana kë gëgali lëlelëkefle. ");
INSERT INTO nce_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Kë ho bu nimitelë mehwi tle. Li ho, bubë weniji Ananaias, bu tëkaklutle na bubë toba gogwa toletle, bu naba tika namëgletleme.” ");
INSERT INTO nce_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Na Ananaias bubë gali metafu tëtatle, “Tako Ho! Lebutako oneho, kë hobë lakaleme wagali motlona. Bu Jerusalem lifate mëta, jubë onehome memelë tëbo wesibina tëbo lamotokwefëma. ");
INSERT INTO nce_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Na ëje bu Damaskus lifatewa tisi, jume kë lotu mëgletëyobë onehome kalabusu nalotomeme. Na lotu lo mëta wege mëglabë eso ho bu wesibi kë ho melë nalëglebëme halawa lamëtletla.” ");
INSERT INTO nce_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Kwe, Tako Ho, bume gali tlole, “Ju Sol belë eiju. Kë ho bu bobë wege home fata lëgleme. Bo bume wafi aniji tlolë, Israelbë afenëboni mëtabëya jwa mëglabë enëneme, na bubë eso enëneme na Israelbë afenëbonime, bobë gali të nalëgëtatëmeme, na bu bome lowene sle mëletëname. ");
INSERT INTO nce_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Na bo bume meolafa nëtatelëme, ‘Bu bobë galiwa të logotlena, memelë tetëbo wesibi bume fata mëgletleme.’ ” ");
INSERT INTO nce_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Na Ananaias, Sol kë tafa lëglebë lowa tuju. Na lowa tëkaklu. Na Solme toba gogwa toletle na megali latlole, “Afa Sol, Tako Ho Jisas bu jume alëge mëta olafa tletë. Na buwa bome jine lelëfakënë, jubë naba tika namëgletëme na Gotobë Amtëtomba ju belë naligisitëme.” ");
INSERT INTO nce_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ananaias kë gali wafi yawe tlole, na hokweinawa, mo lënëboha wesibi, Solbë naba mago mititigo tle na bu ita hwi tekake. Na bu huju tle na Ananaias bume baptais totle. ");
INSERT INTO nce_vpl VALUES ("AC9_19a","074_9_19a","ACT","9","19a","19a","Na tokwafe Sol hi wesibi hi tle na afutuku bume ita tisi tle. ");
INSERT INTO nce_vpl VALUES ("AC9_19b","074_9_19b","ACT","9","19b","19b","Sol Damaskus lifate mëta, Jisasme lowene sle mëtletlabë onehona fli olëwa tafa mëtla. ");
INSERT INTO nce_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Na kwe, bu Israelbë afenëbonibë lotu lowa mana latujuwa, na gali metë latëtatëme, “Jisas bu Gotobë nëba.” ");
INSERT INTO nce_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Iniwa ho, Solbë gali kë aholokwane motlolabë, klelegomu memëtla. Na bu megali lamëtla, “Kë ho kë nëgebë, Jisasme kë lotu mëtlekefëtlabë onehome, tëbo totokwefëmebë ho. Bu Jerusalem lifate mëta melatotokwefëme. Na ëje ebelë kë ligisibë mata, kalabusu lowa nalëglelumeme, na bume lotu lo mëta wege mëglabë eso ho belë lëglelume nalëgleme, Jerusalem lifatewa.” ");
INSERT INTO nce_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Kwe Goto Solme afutuku tlële na bu kë afutukuna Israelbë afenëbonime, Damaskus life mëta kë tafa mëtlabë, kalëlego gali të tëtatëme. Sol megali slemu latlome, “Goto Jisasme kë aniji toglolebë, bubë onehome nëno nalëglebëme.” Israelbë afenëboni, Solbë gali yafe aholokwane motlola. Bubë gali habëna tafu mëgëtatlamene? Bu gali olafa slemu tëgëtatëmeme nëgeme. ");
INSERT INTO nce_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Lebutako olë wamutuju na Israelbë afenëboni loko mëtlelëya na gali sle mototla, Solme mogo nalë tëkle namogotlame. ");
INSERT INTO nce_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Kwe Sol bume kë fa mëtëtatlabë gali waaholokwane tletëme. Na Israelbë afenëboni, olëli olëli na klabë, Damaskus lifatebë lëglesibë ino ëfo li mëta, sei mëtlëkefëtla, Solme mogo nalë tëke namoglolame. ");
INSERT INTO nce_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kwe klabë kuna, Solbë yabeni, bume kë lifate mago tako lëglesi mëglëbo li elë mitilekola. Na Solme tatijiha wesibi mëta tuku mëtla na bu kë mëta tafa tokoke na tabana kesi mototla, na kë manogwa lëglesi mëglëbo elëme alabujuwa tuku mëtëmalitaya. Na bu mana tuju. ");
INSERT INTO nce_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Tokwafe, Sol Jerusalem lifatewa tuju, Jisasme kë lowene mëgletlabë enënena loko namëglame. Kwe bu iniwa uli lamëtletla na melowene lamëtletla, “Bu Jisasme lowene lëgletlebë ho nane.” ");
INSERT INTO nce_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kwe Barnabas Solme lataitale, na Aposel ho belë sei tlële. Na bume gali tlome, “Sol Tako Ho Jisasme alëge mëta wafi hwi tlole. Na Tako Ho Jisas bume wagëgali tlelële. Na Sol mata, Damaskus lifatebë onehome, Jisasbë gali të tëtatëmebëme, uli hana tle.” ");
INSERT INTO nce_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Barnabasbë gali aholokwane motlola na Aposel enëne lowene mëtla, “Nëgalife.” Këme nëgeme, Sol bu Aposelna, Jisasme kë lowene mëgletlabë onehona iniwa tafa mëtla. Na buna iniwa Jerusalem lifate mëta asë mëtla. Na bu Jisasbë gali onehome të tëtatëmebëme uli hana tle. ");
INSERT INTO nce_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Na bu Israelbë afenëboni flina, Grik gali kë lowene mëtlabë, Jisasbë galime gëgali tlelëme na bume momata lamëtlelëla. Kwe bume melowene mëtletla, “Sebo habelë nogotlamene, bume mogo nalë tëke nanogotlamefe?” ");
INSERT INTO nce_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Jisasme kë lowene mëgletlabë oneho kë wame gali aholokwane mëtla, na bu Solme Sisaria life elëme mëtlelula na Tarsus life elëme jine mëtelëkakla. ");
INSERT INTO nce_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Na kwe kë nalëwa, Jisasme kë lowene sle mëgletlabë oneho, Judia provins na Galili provins na Samaria provins mëta lalowa tafa mëtla. Ho bume hana tëbo totome. Na Gotobë Amtëtomba bume afutuku tlëme. Na iniwa bu itaita Jisasbë tolewa esogo mëtlelëkefëtla. Na lebutako oneho bu Jisasme lowene sle mëtletla. ");
INSERT INTO nce_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita li life li life elëme asë tëbelëfa. Na bu Lita lifewa tuju na kë life mëta, Gotobë onehona tafa mutula. ");
INSERT INTO nce_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Na bu kë life mago ho li hwi tlole. Bubë weniji Ainias. Bubë iniwa elebo mogowa. Bu tëgëbe tëgëbewa latle. Na bu tobali ita aona tlibutu këniji melë latle. ");
INSERT INTO nce_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Na Pita bume megali latlole, “Ainias, Jisas Klais jume elë sle lëgetame. Ju huju ele na jubë ni labuku mana hohlo etleme.” Na bu hokweinawa huju tle. ");
INSERT INTO nce_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Na iniwa oneho, Lita na Saron lifate mëta kë tafa mëtlabë, Ainias kë sle tëglebëme hwi mëtla na Jisasme lowene sle mëtletla. ");
INSERT INTO nce_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jisasme lowene sle egletlebë mëse li, Jopa lifate mëta tafa tle. Bubë weniji Tabita. Bu Grik galina bubë weniji mefë lamëtëtaya, Dorkas. Iniwa olë bu iniwa onehome taitakefëme. Na bu wesibi jwa onehome, hi wesibi na fli wesibina mata tlëkefëme. ");
INSERT INTO nce_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Na kë olëna, bu atowelili tle na gli tle. Na bu mogo tuna swa mëtëtaya. Na matawa kë ke togolebë lo ke mëta gwa mototaya. ");
INSERT INTO nce_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jopa life bu Lita life li mëta lëbe. Na Jisasme lowene sle mëtletlabë oneho gali meaholokwane mëtletla, Pita Lita life mëta tafa lële. Këme nëgeme bu tlemalë home, Pita belë këme jine mëtlëma. Bu Pita belëme fwa mutulo na bume megali motlolo, “Ju sebobë lifewa hokweinawa saesi. Ju ahuta asa ele.” ");
INSERT INTO nce_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Na Pita kë tlemalë hona mutuja. Na bu kë lo elëme fata tle. Na matawa kë ke togolebë lo kewa sei motowelëlo. Na seiju one iniwa, Pita belëme mitisitla na ye mëtlekefëya. Na Tabita, tuja ato mana tëtabena, kë susu totomebë ëho, Pitame lebotane mototometla. ");
INSERT INTO nce_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Na Pita bu iniwa onehome kë mago hehë tëkaketëme. Na sëkefo miti tafa tëtëkake. Na mana Gotome gëgali tlelëkakle. Na kë gëgali yawe tlole, na bu kë mëse mogobë li elëme swaya tokoke na gali tolë, “Tabita, ju huju ele.” Na kë mëse naba hobo tika totome na Pitame hwi tlole na huju tle na tafa tëkake. ");
INSERT INTO nce_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Na Pita bume tobame fa tëtamë na huju tetokwakë na bu hujuna tlibe. Na Pita, seiju oneme na Jisasme lowene sle mëtletlabë onehome, gali telokwakëme, migisitla namëglame. Na bu bubelë mitisitla. Na bume lebotane tëtatëme, Tabita tuja ato mana ekëne. ");
INSERT INTO nce_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Na kë gali, Jopa life mëta asë tëbelëfatle. Na lebutako oneho Jisasme lowene sle mëtletla. ");
INSERT INTO nce_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Na Pita Jopa life mëta lebutako olë tafa tle. Bu ho lina tafa mëtelo. Bubë weniji Saimon. Kë ho kë nëgebë, bulmakau kleli jibo slesle totokwefëmebë ho, kibo mëgle lime. ");
INSERT INTO nce_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ho li, Sisaria lifate mëta tafa tle. Bubë weniji Kornilius. Kë ho bu Rom life gavmanbë, wame home boblo mogotomabë enënebë eso ho. Na bu we lujuafe we wame home boblo mogotomabë enëneme tafa tlelëme. Kë enëne, bu Itali lifate mago enëne. ");
INSERT INTO nce_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kornilius bu Gotobë tolewa esogo tlelëkefëtle. Na buna, bubë nona, nëbalena, na bubë lo mëta kë tafa tëglelëmebë enënena, Gotome lotu melekefëtla. Bu Israelbë afenëboni, wesibi jwa kë tafa mëtlabëme, taitakefëme na baliti tlëkefëme. Na bu Gotome itaita gëgali tlelëkefle. ");
INSERT INTO nce_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Olë li, taboklë klijina, bu Gotobë enselme nimitelëha wesibina hwi tlole, bubë lowa tëkaklitle. Na bume megali latlole, “Kornilius!” ");
INSERT INTO nce_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kornilius enselme hwi tlokweflebë na uli metletle na gali tlole, “Tako ho, fëyemene?” Na ensel këme gali tlole, “Ju Gotome kë gëgali eglelëkeflebë, bu kë gali waaholokwane lolokwefë. Na ju wesibi jwa enëneme, wesibi kë eglëkefëmebëme, Goto wahwi lolotë na bu jume tako fleflesumu lalëletë. ");
INSERT INTO nce_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Eli ju ho flime Jopa lifewa sajine elëme, ho lime hohwi namugutatlame. Bubë weniji Saimon na bubë li weniji Pita. Na bume, gali mujelëlame, ju belë ligisitë nalëgleme. ");
INSERT INTO nce_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Na kë ho, bubë wenisa Saimonbë lo mëta lëtabe. Kë ho bu bulmakau kleli jibo sle sle lotokwefëmebë ho, kibo mëglelime. Bubë lo nutu helefo li mëta lilibetle.” ");
INSERT INTO nce_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ensel Korniliusme wafi gali tlole na kile totle. Na Kornilius bubë tlemalë wege home na jowa wame boblo logotlebë home gali telokwakëme, bu belë migisitla namëglame. Kë wame boblo logotlebë ho mata Gotobë tolewa esogo tlelëkefëtle. Na bu Korniliusme feilawamu taitakefle. ");
INSERT INTO nce_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Aomalë mitisitla na Kornilius iniwa wesibi bume nimitelë mëta kë fata mëtletlebëme gali tlome. Na kë aomalë home Jopa life elëme jine telëkakëme, Saimon Pitame hohwi namugutatlame. ");
INSERT INTO nce_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kornilius kë jine tëglëmebë ho mutuja na alëge mëta jowa klabëwa ni mëtebëya na ita kë mago huju mëtla na mutuja. Mutujabë na kliji ku mëta tlibe bu Jopa lifate lololi mototla. Na kë olëna, Pita matawa kë ke togolebë lo ke elë tokwale, Gotome gëgali nalëglelëleme. ");
INSERT INTO nce_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pita bu fone latle na hi wesibi hime tole tle. Bu hi wesibi mana sle mototokwefëma na bu nimitelëha wesibi hwi tle. ");
INSERT INTO nce_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Na matafa inoha latikawa tëkaketle na tako lablab ëhoha wesibi kë mago tuku tëmalitatle. Nilina taba kë ëho mëta jejelë wako elëme këkesi mëtletle na mana tuku tëmalitatle. ");
INSERT INTO nce_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Kë ëho mëta, memelë kleli na memelë taiju na memelë tato na memelë fole kë mëta motowelibe. (Israelbë afenëboni bu këha wesibi hana hihi mëlekefëya. Bu melowene lamëtla, “Bu kë wesibi hi mëglana kwe bu Gotobë naba lime tëbo miglitayame.”) ");
INSERT INTO nce_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Na Pita gali lego aholokwane tle na megali tlole, “Pita ju huju eleme na kë hi wesibi tëtëkle etame na hi eleme.” ");
INSERT INTO nce_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Kwe Pita gali tle, “Weye. Tako Ho, bo hanane mu hi nëgelëme. Sebo, Israelbë afenëboni, këha wesibi hihi hana nëlekefëya. Sebo melowene nanëla, ‘Ebë wesibi hi nëglana kwe sebo Gotobë naba lime tëbo nanilitaya.’ Bo ëtani kë nëgebë na ëje mana ekë bo këha wesibi hihi hana nelë.” ");
INSERT INTO nce_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Na kë ëfalëbo lego Pitame ita gali tlole, “Wesibi Goto megali kë lëglebë, ‘Ebë lale hi wesibi,’ ju megali asa ele, ‘Ebë tëbo hi wesibi.’ Weye.” ");
INSERT INTO nce_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Na kë gali lego kë galime aowafe gali tlole na mana kë ëho matafa elëme lakiwa tokwake. ");
INSERT INTO nce_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Na Pita kë nimitelë mana lowene tlekefëtlebëë na Kornilius kë jine tëglëmebë ho mana fata mëtëkakija. Bu fli home afina metakune motloma, “Saimonbë lo hametane?” Bu mitisiya, na Saimon këme tafa tëglebë lo ino ëfome mitejuwelikwëya. ");
INSERT INTO nce_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Na gali motloma, “Saimon Pita ebë lo mëta mana tafa lëlene o hanane?” ");
INSERT INTO nce_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita bu kë nimitelë gali mana lowene tlekefëtlebëë na Gotobë Amtëtomba bume mana gali tlole, “Aholokwane ele! Jume aomalë ho jume kë hohwi mëtagitëyo. ");
INSERT INTO nce_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ju huju elëme na kë home esune eglëmebëme kle etëkakeme na buna eyeume. Ju buna egëyeume tutune asa ele. Bo jine nelëbakëmetë.” ");
INSERT INTO nce_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Na kwe Pita kë ho belë kle tëtëkake na gëgali tlelëme, “Sobo kë hohwi etatelobë ho, ta bo ekë. Sobo fëyeme esijone?” ");
INSERT INTO nce_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Na bu megali mëtla, “Wame home boblo mogotomebë enënebë eso ho, Kornilius, bu jine telëbakëna. Bu lale lakalena homu na bu Gotome lotu lëlekefëtlebë ho. Na Israelbë afenëboni iniwa melowene lamletla, ‘Bu lale lakalena homu.’ Na Gotobë ensel bume wagali tlole, ‘Ju ho flime, Jopa lifewa jine elëkakëmeme, Saimon Pitame ju belë mëglesula namëglame. Na ju bubë gali aholokwane naeglotleme.’ ” ");
INSERT INTO nce_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Na Pita kë aomalë home lowa nëno tle na këme weife ni tlebëme. Na olobalë bu nani kë mago iniwa mutuja. Na Jisasme lowene sle mëtletlabë oneho fli, Jopa life mëta kë tafa mëglabë mata bume esogo mëtlelëma. ");
INSERT INTO nce_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Bu mutujabëë na alëge mëta ni mëtebëya. Na li olëna Sisaria lifatewa fwa mutula. Korniliusbë ilawa mago enënename, na bubë yabeniname, bu wafi gali tlagume. Na bu wafi loko mëtëkakija na Pitame mana hwi mëtletla. ");
INSERT INTO nce_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita Korniliusbë lowa fata tule na lowa tëkaklu. Na Kornilius, Pitabë li elë tisi tle na sëkefo miti tafa tletle na Pitame lotu tletle. ");
INSERT INTO nce_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Na këme Pita huju tetëbakle na gali tlole, “Ju huju ele. Bo melë, howa, ju fenene. Ju melë asa ele.” ");
INSERT INTO nce_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Na Pita buna gëgali mëtelobë na oneho buna iniwa kë mitisiyabë lowa mëtëkakluja. Na Pita këme hwi telujuwelëme, lebutako oneho loko mëtelujuwelëya. ");
INSERT INTO nce_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Na Pita bume gali tlome, “Sobo walowene elo. Sebo Israelbë afenëboni kwe memelë nanëla, Israelbë afenëboni mëtabëya jwa mëglabë enënena hana loko nëglelëyame na sebo buna hana tafa nëglame. Kwe Goto bome melebotane latëtatenë, bo melowene asa manelë, ‘Fli enëne bu Gotobë naba li mëta tëbowa mëtabëya.’ Weye. ");
INSERT INTO nce_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Këme nëgeme, sobo kë gali tëgelokwakënabë gali hana boblo nëtatëyo, bo hokweinawa këme tisi. Na bo some takune nëlëyo. Bome sobelë nigisibëme, fëyeme gali telokwakënane?” ");
INSERT INTO nce_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Na Kornilius bu këme gali tle, “Aona olë wamutuju, wesibi bome mana fata tletenë. Kë wesibi melë latle. Taboklë klijina, ebë fenene, bobë lo mëta tafa telë na Gotome gëgali tlelëlë. Bo Gotome gëgali tëglelëlëbëë na mana ho li bobë lime latlikakiwa. Bubë ëho kliji fene u tletle. ");
INSERT INTO nce_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Na bu gali tle, ‘Kornilius. Ju Gotome kë gëgali eglelëkeflebë, bu waaholokwane lolë. Na ju wesibi jwa enëneme, wesibi kë eglëkefëmebëme, Goto wahwi lolë. ");
INSERT INTO nce_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Na ju ho flime Jopa lifewa sajine elëkakëme, na Saimon Pitame nagali mugujelëlame, ju belë naligisi tëme. Kë ho, bowenisa Saimonbë lo mëta tafa lële. Kë Saimon bulmakau kleli jibo sle sle lotokwefëmebë ho, kibo mëglelime. Bubë lo nutu helefo li mëta lilibetle.’ ");
INSERT INTO nce_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Këme nëgeme, bo fli home ju belë hokweinawa këme jine telëkakëmë. Na ebë lakale, ju yaha esitënamu. Na ëje sebo iniwa Gotobë naba lime ekë nëtabëya nëtabëya. Na Tako Ho jume kë tëglëbë gali, sebo aholokwane nanëgletlame.” ");
INSERT INTO nce_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Na kwe Pita megali latle, “Nëgalimufe. Bo walowene nelë. Habëtabo onehobë, Goto iniwa metole lalëletëme. Bu Israelbë afenëbonime fwa nane tole lëletëme. ");
INSERT INTO nce_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Iniwa oneho, Gotome lotu mëlekefëtlana na lale lowenewa esogo mëlelëtlana, kwe Goto këha onehome tole lalëletëme na lalaitame. ");
INSERT INTO nce_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Goto seme Israelbë afenëbonime kë lëglënabë gali, sobo wafi lowene eletelo. Na kë lale gali melë lëgëbetle lalële, ‘Jisas Klais bu iniwa onehobë eso home tafa lëletëmeme. Jisas seme kaiselo laitakefëna, sebo Gotona yonane nanëglabëme.’ ");
INSERT INTO nce_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Sobo walowene elo. Ëtani, Jon bu gali të tëtatëme, baptais namëglame. Na bu lebutako onehome baptais totome. Jon bu onehome wabaptais totome na mana kë olëna Jisas Israel life mëta lebutako wesibi totometëme. Kë wesibi bu Galili provins mëta afina oto tle. Sobo kë wesibime wafi lowene eletelo. ");
INSERT INTO nce_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Sobo ebë walowene elo. Goto bu Nasaret life mago Jisasme aniji tlole na bubë Amtëtomba na tako afutuku bume tlële. Na Jisas bu kë afutukuna li life li life asë tëbelëfa na onehome taitame. Goto buna tafa mëtëgelome nëgeme, na iniwa oneho Satan kë yage totomebë, bu iniwa wasle tëtagume. ");
INSERT INTO nce_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Na iniwa wesibi, Jerusalem lifate mëta na Israelbë afenëbonibë li life li life mëta, Jisas melë kë totomebë, sebo wafi hwi tlola. Na wesibi melë kë totomebë, kë gali këme të nëtatla. Na bume mogo nalë ti mëta bu mëtla. ");
INSERT INTO nce_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Kwe tële olë mutuju na aona olëbëna Goto bume gli mago mana huju totle. Na bume olafa tëtagutëme, oneho hwi namoglolabëme. ");
INSERT INTO nce_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Kwe Israelbë afenëboni iniwa, bume nane hwi motlola. Weye. Goto ëbame sebo Aposel home waaniji tlome, bume ita hwi nanoglolame na bubë gali të nanëgëtatlame. Na bu matëmatë mago huju tëglena, sebo buna hi tla. ");
INSERT INTO nce_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Na bu seme anisasana gali tlona, bubë lale gali iniwa onehome të nanëgëtatëmame. Na sebo onehome metë sle nanëgëtatëmame, ‘Goto Jisasme waaniji tlole, gigli mëtlabë onehobë lowene na mana tafa mëglabë onehobë lowene abiabi hwi lolotëmeme na mana lëselokwame.’ ");
INSERT INTO nce_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ëtani, iniwa Gotobë lowene mago gali të mototokweflabë ho, Jisasme megali lamëtletla, ‘Iniwa oneho ebë home kë lowene sle mëgletlabë, Goto bubë tëbo lowenebë aholokwana ti lëgletëmememu.’ ” ");
INSERT INTO nce_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita gali mana të togotlebëë, na Gotobë Amtëtomba, Gotobë gali kë aholokwane mëglabë onehome mana tisi tëme. ");
INSERT INTO nce_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Këme nëgeme bu lili anigawa galina gëgali mëtla na Gotome bibita mototla. Këme nëgeme, Jisasme lowene sle mëtletlabë oneho, Pitana kë mitisiyabë, hwi motloma na klelego memëtletëma na megali mëtla, “Hwi elo, Israelbë afenëboni mëtabëya jwa mëglabë oneho, Goto bubë Amtëtomba bume walëlëme.” Na Pita bume megali latletëme, ");
INSERT INTO nce_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Gotobë Amtëtomba kë enëneme wafi lisitëme bu ëbame seme fene tisitëna. Ho seme ebë onehome tu mëta baptaisme hana lëkle mëgëtaname. Bo melowene nanelë, ‘Sebo bume lalowa baptais notomame.’ ” ");
INSERT INTO nce_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Na Pita kë onehome megali latlome, “Sobo Jisasbë wenijina baptais elomo.” Na Pita bume baptais totome. Na bu Pitame takune motlola, buna habenuju olë tafa namëglame. ");
INSERT INTO nce_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Aposel ho na, Jisasme lowene sle mëtletlabë oneho flina, Judia provins mëta kë tafa mëtlabë, bu megali aholokwane mëtla, Israelbë afenëboni mëtabëya jwa mëglabë enëne, Jisasbë gali lowene sle lamëlëtla. ");
INSERT INTO nce_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pita Jerusalem lifatewa tugujuna, na Jisasme lowene sle mëtletlabë oneho fli bume wame gali memotlola. Kë enëne bu melowene lamëtla, “Bu ato jibo tëtlë mogotomabë lakale esogo sle mëglelëlabëme feilawa afutuku mëtla.” ");
INSERT INTO nce_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Bu megali motlola, “Ju ato jibo tëtlë jwa motomabë hobë lowa fëye esome tëkaklune na buna fëyeme hi telulone?” ");
INSERT INTO nce_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Na kwe, iniwa wesibi bume kë fata mëtletlebë, Pita këme gëgali tle. Bu megali tle, ");
INSERT INTO nce_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Bo Jopa life mëta tafa telë na bo Gotome gëgali tëglelëkeflëbëë na bo nimitelëha wesibi mana hwi telë. Bo tako lablab ëhoha wesibi hwi tlolë, matafa mago tuku tëmalita. Nilina taba kë ëho mëta jejelë wako elëme këkesi mëtle na mana tuku tëmalita. ");
INSERT INTO nce_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Bo kë wesibi lowene sle nanëgletemëme na bo kë ëho elëme mana hwi sle telokwaklë. Na bo mehwi tlomë, memelë tobaluku kleli na memelë waluju mago kleli, na memelë tato na memelë taiju na memelë fole. Israelbë afenëboni bu këha wesibi hana hihi mëlekefëya. ");
INSERT INTO nce_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Na ëfalëbo lego bome megali tlonë, ‘Pita ju huju ele na wesibi tëtëkle etamë na hi elëme.’ ");
INSERT INTO nce_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Kwe bo megali telë, ‘Tako Ho, bo hanane mu hi nëgelëme. Sebo, Israelbë afenëboni, këha wesibi hihi hana nëlamu. Sebo melowene nanëla, “Kë wesibi hi nëglana kwe Gotobë naba lime tëbo nanilitaya.” Këme nëgeme këha wesibi hi hana telë, bo ëtani kë nëgebë na ëje mana ekëne.’ ");
INSERT INTO nce_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Kwe kë ëfalëbo lego heven life mago ita megali tle, ‘Wesibi Goto megali kë lëglebë, “Ebë lale hi wesibi,” ju megali asa ele, “Ebë tëbo hi wesibi.” Weye.’ ");
INSERT INTO nce_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Goto kë galime aowafe gali tle na kë ëho matafa elëme ita mana ki tokwake. ");
INSERT INTO nce_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Kë olë nawa, aomalë ho, sebo këme tafa tëglabë lowa mitisiya. Sisaria lifate mago ho li, bo belëme jine telëbakëme. ");
INSERT INTO nce_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Na Gotobë Amtëtomba bome megali tlonë, ‘Ju kë enënena egëyeubëme, tutune asa ele. Buna lalowa eyeu.’ Na ebë tobali ita jowa afanino kë mëglijabë, bu mata iniwa Sisaria lifatewa bona tuja. Na seme kë gali tëgelëbakënabë hobë lowa tëkakluja. ");
INSERT INTO nce_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Na bu seme megali latlona, ‘Ensel bobë lowa tëkaklë na këme tlibe na megali tlonë, “Ju ho flime Jopa lifewa sajine elëkakëme, ho lime hohwi namugutatlame. Bubë weniji Saimon Pita. Na bume gali mujelëlame, ju belë naligisitëme. ");
INSERT INTO nce_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Na kë ho jume na jubë lo mëta kë tafa mëglabë enëneme gali të nalëgëtatëmeme. Sobo kë gali aholokwane elëlome na Goto some nëno lëleme.” ’ ");
INSERT INTO nce_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Bu nimitelë gali kë të togotlebë wayawe tlole, na bo mana gali tëme ototelë. Bo gali tokwafe kofene të tëtagulë, na mana Gotobë Amtëtomba bume tisi tëme, seme ëbame otome fene tigisi tënabë. ");
INSERT INTO nce_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Na, Jisas ëbame seme kë gali toglonabë gali bo ita lowene tletelë. Bu megali latlona, ‘Jon onehome tu mëta baptais totome, kwe tokwafe Goto bubë Amtëtombana baptais lëgëtome.’ ");
INSERT INTO nce_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ëbame sebo Tako Ho Jisas Klaisme lowene sle tletla na Goto bubë Amtëtomba seme tlëna. Na kë fenene Goto kë enëneme bubë Amtëtomba tlëme. Bo melowene nanelë, ‘Kë wesibi ebë Gotobë wesibi. Na bo Gotome hana boblo nogotlëme na bubë tole hana lëkle nëgëtatelëme. Goto bume kë totometëmebë wesibime lëkle hana nogotomëme.’ ” ");
INSERT INTO nce_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Na kwe, bu Pitabë gali yafe aholokwane mëtla. Na bume kë wame motlolabë lowene latliwa tëbetëme. Na bu Gotome bibita mototla na megali lamëtla, “Israelbë afenëboni mëtabëya jwa mëglabë enëneme, Goto ino tika tëtatëme, bubë tëbo lowene aholokwana ti mëglabëme na unaunalëme lale tafa mëglabëme.” ");
INSERT INTO nce_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ëbame, Stivenme mogo nalë kë tëkle mototlabë olëna, Israelbë afenëboni fli bu Jisasme kë lowene sle mëtletlabë oneho flime mana tëbo mototoma. Këme nëgeme, bu mago lebutako, li life li lifewa mitliwaya. Bu Fonisia provinswa, na Saiprus afayowa na Antiok lifatewa memitliwaya lamëtla. Na bu Jisasbë lale gali mana të mëtëtagutëma. Kwe Israelbë afenëboni mëtabëya jwa mëglabë enëneme gali hana të mëtëtatëma. Weye. Bu Israelbë afenëbonime fwa të mëtëtagutëma. ");
INSERT INTO nce_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kwe bu mago ho fli, Saiprus afayo mago na Sairini lifate mago, Antiok lifatewa mutuja na Tako Ho Jisasbë lale gali Israelbë afenëboni mëtabëya jwa mëglabë enëneme të mëtëtatëma. ");
INSERT INTO nce_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Na Tako Hobë afutuku bu mëta tëbetëme na bu kë afutukuna Jisasbë lale gali të mëtëtatëma. Këme nëgeme lebutako oneho Jisasme lowene sle mëtletla na bubë tëbo lowenebë aholokwana ti motokouja. Na Jisasbë lowenewa esogo mëtlelëtla. ");
INSERT INTO nce_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Na Jisasme lowene sle mëtletlabë oneho, Jerusalem lifate mëta kë tafa mëglabë, kë gali aholokwane mëtla na bu Barnabasme Antiok lifatewa jine mëtelëkakla. ");
INSERT INTO nce_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Barnabas Antiok lifatewa tuhu tule na mehwi tlome. Goto kë onehome ululu sle totome na lataitame. Na bu këme tako fleflesu latletëme. Na bume lale galime meokokwe tlome, “Sobo Tako Ho Jisasme unaunalëme lowene sle eglekefëtelome na bubë lowenewa esogo elelëkefëtelome.” ");
INSERT INTO nce_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Na Barnabas bu lale homu nëgeme. Na Gotobë Amtëtombabë afutuku bu mëta feilawa tëtabetle. Na bu Gotome feilawamu lowene sle tletle. Na këme nëgeme feilawa oneho bu Jisasme lowene sle mëtletla. ");
INSERT INTO nce_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Na kwe, Barnabas bu Tarsus lifatewa tuju, Solme hohwi nalugutatleme. ");
INSERT INTO nce_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Bu hohwi tëtagutlebëë na Solme mana hwi tujuwelële. Na no tlële na Antiok lifatewa elebo nagi tlesule. Na tlemalë, Jisasme lowene sle mëtletlabë onehona, kë lifate mëta kë tafa mëtlabë, jowa tlibutuna loko mëtlelëkefëya na Gotobë gali okokwe motlokefëmo. Na Antiok life mëta, bu Jisasme lowene sle mëtletlabë onehome, afina mefë lamototoma, “Kristen.” ");
INSERT INTO nce_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Kë nalëwa, Gotobë lowene mago gali të mototokweflabë ho fli, Jerusalem lifate mago, Antiok lifewa mitisiya. ");
INSERT INTO nce_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Na Gotobë lowene mago gali të totokweflebë ho li, bubë weniji Agabus, bu Kristen onehobë naba li mëta hujuna tlibe na Gotobë Amtëtombabë afutukuna megali tlome, “Tako fone, iniwa life mëta fata lokoume.” Na tokwafe, Sisar Klodius eso home tafa tëglena, kë fone mana fata tokou. ");
INSERT INTO nce_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kristen oneho, Agabusbë gali aholokwane motlola. Na bu gali sle mototla. Kristen oneho flime, Judia provins mëta kë tafa mëglabë, balitina mëgaitama namëglame. Na jowa jowa ho, bubë baliti musu niji loko mëtëtaya. ");
INSERT INTO nce_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Na bu Barnabas na Solname jine mëtelëkakëma. Na bu kë baliti, Kristen onehobë letitabo home mëtehoutemo na mutujuwelëmo. ");
INSERT INTO nce_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Na kë nalëwa, eso ho Herot bubë wame home boblo mogotomabë enëneme gali tlome, Kristen oneho flime tëbo namëtagumame. ");
INSERT INTO nce_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Na bu li home gali tlole, na bu Jonbë bolijamome, Jemsme kosina mogo nalë tëke tlole. ");
INSERT INTO nce_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Herot bu mehwi latlome, Israelbë afenëboni kë wesibime fleflesu lamëtla. Këme nëgeme, bu Israelbë afenëbonibë tako lotu olëna, bubë wame home boblo mogotomabë enëneme gali tlome, Pitame kalabusu lowa tuku namëglame. Israelbë afenëboni, kë tako lotu olëna, sëse wesibi jwa bletë nage hi mëtlekefëya. ");
INSERT INTO nce_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Bubë wame home boblo mogotomabë enënene Pitame fa mototla na kalabusu lowa tuku mëtla. Na Herot bu, wame home boblo mogotomabë enëne we tobali ita jowa këniji aniji tlome, Pitame hwi namoglokweflame, bu lëglëboukakulime. Nilimalë afina hwi motlokwefla. Na fli mana hwi mëtla. Na tokwafe fli nilimalë ita hihijika mëtla. Na otobë mutuja. Na bu olëna klabëna mehihijikawa lamëtlekefëya. Herot bu melowene latle, Israelbë afenëbonibë tako lotu olë yawe lëleme na Pitame kalabusu lo mago mana lëlesuleme, na onehobë naba lime bubë tëbo loweneme takune lololeme. ");
INSERT INTO nce_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Këme nëgeme Pita kalabusu lo mëta tafa tle. Na wame home boblo mogotomabë enëne bume hwi motlokwefla. Kwe Kristen oneho, Gotome anisasana takune motlokwefla, Pitame lëgaitale nalëgleme. ");
INSERT INTO nce_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Na kwe Herot bu olë waaniji tlole, onehobë naba li mëta Pitabë tëbo loweneme takune nalogloleme. Na kë klabëwa, Pita bu wame home boblo mogotomabë enëne tlemalëbë ku mëta nitëbetëme. Na bume senë taba toba mëta këkesi mëtletla na li senë tobamu toba elë kë tafa tëglebë wame home boblo logotomebë hobë toba mëta kesi tuletle na li senë tabo yemane toba elë kë tafa tëglebë wame home boblo logotomebë hobë toba mëta kesi tuletle. Na wame home boblo mogotomabë enëne fli, kalabusu ino ëfome mana sei mëtlëkefëtla. ");
INSERT INTO nce_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Na kwe Gotobë ensel lafatawa tle. Na kë kalabusu lo, elulego telube. Na ensel Pitame mëglëbo mëta luluju totle na gali tlole, “Ju hokweinawa huju ele.” Na senë taba, bubë toba mago, lalukluwa mëtëtëkaketle. ");
INSERT INTO nce_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Na ensel gali tlole, “Pita jubë ëhona, juba jibona gëgelo etome.” Na Pita melë tle. Na ensel gali tlole, “Jubë heletabo ëho mata gelo etleme na bome nagi enënëme.” ");
INSERT INTO nce_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Na Pita kë tlë tabo lo tokwëfo kile tle na enselme nagi tlële. Kwe Pita melowene hana tle, “Bume kë fata lëgletlebë wesibi ebë nëgali wesibi o hanane.” Bu melowene tle, “Bo nimitelë hwi nelëwa.” ");
INSERT INTO nce_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Tlemalë weife nagi mëtëyeu na kalabusu lo kë hwi moglokweflabë home lasigliwa mototomo. Na ita mëtëyeu. Na kalabusu lo kë hwi moglokweflabë ho flime sigli motujetomo, kwe bume hwi hana motloma. Na tlemalë bu kalabusu lobë ainëna ino elë fwa mutulo, kë kalabusu kile namogotlome, na lifate elë mëyeume. Na kë ino blawa latikawa tëkaketëme. Na bu kalabusu lo kile mëtelo na li alëge esogo mëtlelolo. Na kwe ensel Pitame alëge mëta lakilewa tëkake. ");
INSERT INTO nce_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Na Pita bu kë wesibime lowene tle na gali tle, “Bo walowene nelë, ebë nimitelë nane. Weye. Goto bubë ensel bo belë jine lëlëtenë, bome lëgaitanë nalëgleme. Këme nëgeme Herotna, Israelbë afenëbonina, bome tëbo mëgëtanabë lowene kë nëgebë, hana tëbo mëgëtaname.” ");
INSERT INTO nce_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Na bu Jon-Makbë bota, Mariabë lowa tuju. Lebutako oneho kë lo mëta loko mëtelulelëya na Gotome gëgali mëtlelëkefla. ");
INSERT INTO nce_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita kë lo ino mëta këke telukwaketëme. Na li wege mëse, bubë weniji Roda, tisi, ino tika naegetatleme fene. ");
INSERT INTO nce_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Bu Pitabë mou lego aholokwane tlole. Na bu tako fleflesu tëgletleme nëgeme, ino tika jwa këme tëtatle. Na bu fëka tokou na fli onehome gali tlome, “Pita walisife, ino efome ekë lelëjuwelëbokwe!” ");
INSERT INTO nce_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Kwe bume gali motlëya, “Ju yaya mëse.” Kwe bu anisasana gali tlome, “Weye. Nëgalimu. Bu ino efome ekë lelëjuwelëbokwe.” Na bu gali motlëya, “Sebo melowene nanëla, ‘Ebë bume kë hwi loglokweflebë enselhane.’ ” ");
INSERT INTO nce_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Kwe Pita ino mëta itaita këke telukokekëfe. Na këme bu ino tika mëtëtatla. Na bume hwi motlola na klelegomu memëtletla. ");
INSERT INTO nce_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Na Pita bume tobanawa lëkle totome, gali kuju namëgebëyame. Na Tako Ho, bume kalabusu lo mago kë no lëglëlebë gali, të tëtatëme. Na bu megali latlome, “Sobo kë wesibime, Jems name, Jisasme lowene sle mëgletlabë oneho fliname gali elomo.” Na Pita bume hune totome na li lifatewa tuju. ");
INSERT INTO nce_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Olobalëwa, kalabusu lo mago wame home boblo mogotomabë enëne, Pitame yafe hwi mëtletla kwe bu tafa hana tle. Na bu klelego memëtla. Na blalo tëtakune mëtlelogwaya, “Pita habelë lujune?” ");
INSERT INTO nce_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Eso ho Herot, bu kë gali aholokwane tle, “Pita hana tafa lëlefe.” Na bu ho flime jine tlëme, Pitame hohwi namëtatlame. Kwe bu Pitame hwi hana motlola. Këme nëgeme, Herot, Pitame kë hwi moglokweflabë home yafe takune tlome kwe hanane. Na bu li home gali tlole, Pitame kë hwi moglokweflabë home mogo nalë tëtëkle nalëgëtame. Na tokwafe, Herot Judia provins kile totle na Sisaria lifatewa tuju na këme tafa tule. ");
INSERT INTO nce_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Eso ho Herot bu Tair lifate mago onehome na Saidon lifate mago onehome tako wame latlome. Këme nëgeme bu iniwa loko mëtlelëya na Herotme hwime mitisiya. Kwe bu Blastusme afina takune motlola, bume lëgaitame nalëgleme. Na bu këbëme helawa tletëme. Blastus bu eso ho Herotbë lo hwi toglokwefëtlebë ho. Buna iniwa, Herot belë mutuja, aisenë hi namëlelëlame na bume kë wame toglomebë wame lowene lëglëkële nalëgleme. Kë enëne, bubë hi wesibi, eso ho Herot këme tafa lëglebë lifate mago glo mëtlekefëya. Na bu melowene lamëtla, “Herotbë wame tli jwa lëgebetlena kwe bu hi wesibi bu mago ita glo hana mëglame.” ");
INSERT INTO nce_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herot bu kë enënena gëgali mëglabë olë waaniji tlole. Na kë olëna bu eso ho këna negli mogotlabë ëho gëgelo tle na eso hobë tafa labu mëta tafa tle na kë enëneme mana gëgali tlelëme. ");
INSERT INTO nce_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Na iniwa oneho Herotme feilawa we motlola, “Ebë ho nane. Ebë goto li, ekë gali lolona.” Na bume lotu mëtletla. ");
INSERT INTO nce_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Herot bume kë gali motlolabë galime aholokwane tlome, kwe bu lëkle hana totome. Na Gotome fleflesu lëgletlebëme tole hana tle. Këme nëgeme, Gotobë ensel li bume hokweinawa tako atowelili tlële. Na bisikëfa bubë alejina imona hi mëteluletle na bu gli tle. ");
INSERT INTO nce_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Na Gotobë gali li life li life fifiji mëtlagula. Na lebutako onehomu Jisasme lowene sle motokoutla. ");
INSERT INTO nce_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Jerusalem lifate mëta loko kë mëtëtayabë baliti mëtlëmobë wege yawe motlolo. Na Barnabasna Solna Jerusalem lifate mana kile mototlo na bu Jon-Makme, Antiok lifatewa weife mëtlelulo. ");
INSERT INTO nce_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Kristen oneho fli Antiok lifate mëta tafa mla. Na bu mago fli, bu Gotobë lowene mago gali të mototokwefla. Na fliye, bu Kristen oneho flime Gotobë lale galime okokwe motloma. Kë enënebë weniji melë: Barnabas na Simeon, bume mefë lamototla, “Kokolebo ho,” na Lusius bu Sairini life mago ho, na Sol, na Manain bu eso hobë Herotbë yonane ho. ");
INSERT INTO nce_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Li olëna, kë oneho, Tako Home lotu mëtletla. Na bu hi wesibi hi jwa mëtla, Gotome lowene sle namëgletlame. Na Gotobë Amtëtomba gali tlome, “Sobo Barnabasname, Solname aniji elomo, bo bume kë aniji toglotëmebë wege fa namogotlome.” ");
INSERT INTO nce_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Këme nëgeme, bu ita hi wesibi hi jwa mëtla na Gotome mana gëgali mëtlelëla, kë tlemalëme lëgaitame nalëgleme. Na bubë toba bubë eso mëta gogwa motoletëma, bume kë wege fame aniji motloma. Na tlemalëme jine mëtelëkakëma. ");
INSERT INTO nce_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Gotobë Amtëtomba tlemalëme jine tlëme. Na bu Selusia lifatewa mëtëyeu. Na këme sibu lo mëta fëfe mëtelo. Na sibu lo bume Saiprus afayowa tlelume. Na bu sibu lo mago fëfe mëtëkako na Salamis lifatewa mëtëyeu. ");
INSERT INTO nce_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Bu Salamis lifatewa fwa mutulo na Israelbë afenëbonibë lotu lo elë asë mëtëbelëfo. Na Gotobë gali të mëtëtatemo. Na Jon-Mak buna iniwa mutuja, tlemalëme nalëgaitameme. ");
INSERT INTO nce_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tlemalë Saiprus afayobë li life li life mëtëkoujo na Pafos lifatewa fwa mëtelo. Na bu Israelbë afenëbo lime mana esune mëtlëlo. Bubë weniji Barjisas. (Bubë weniji Grik galina mefë lamototla, Elimas.) Bu itaita humëi tlekëfe na memelë olo tlësëme. Kë ho bu itaita mesosogëna latlokwefëme, “Bo Gotobë lowene mago gali të nogotlëbë ho.” ");
INSERT INTO nce_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Kë ho bu eso ho Sergius Paulusbë yonane ho. Sergius Paulus bu Saiprus afayo magobë eso ho. Na bu lale lowenenabë ho. Bu Barnabasname Solname gali telokwakeme bu belë migisitelo namëgelome, bu Gotobë gali aholokwane nalëgleme. Na tlemalë bu belë mitisitelo na bume Gotobë gali të mëtëtatelo. ");
INSERT INTO nce_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Kwe humëi ho Elimas, kë tlemalëbë wege blo nalëgëtatëmeme afutuku tle. Bu metole latle, eso ho Sergius bu Jisasme lowene sle jwa na lëgletleme. ");
INSERT INTO nce_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Gotobë Amtëtomba Solme afutuku tlële. Solbë li weniji ebë Pol. Na bu kë afutukuna, Elimasme anisasana hwi tlole na megali latlole, ");
INSERT INTO nce_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Ju Satanbë nëba. Ju iniwa lale loweneme wame eglomebë ho. Tetëbo lowene na kule kule lowene, ju mëta nohwa lelutabetë. Ju Gotobë iniyafe gali, jubë sosogëna galina hihijika elekëfe. Ju kë tëbo lowenebë fëye olëna kile eglemene? ");
INSERT INTO nce_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ju aholokwane ele. Goto jume tëke loglëme ekëne na jubë naba titiki mëgletëme. Na ju klijibë elulego hwi hana eglotleme. Na ju tako naba titiki tabo metafawa ekoukëfeme.” Pol bu megali wafi tle na hokweinawa olobaha wesibi tetujutle na Elimasbë naba lamu totometle. Na naba kilego mëtletle. Na bu home hohwi tëtamë, bume toba fana mëglelula namëglame. ");
INSERT INTO nce_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Eso ho Sergius kë wesibi hwi tlole na bu Jisasme lowene sle tletle. Bu tlemalë kë okokwe motlolobë gali klelego tëgletleme nëgeme. ");
INSERT INTO nce_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Polna, buna kë asë mëtëglabë hona, Pafos lifate kile mototla. Na bu sibu lona Perga lifatewa mutuja, Pamfilia provins mëta. Kwe Jon-Mak bume hune totome na Jerusalem lifatewa ita tuju. ");
INSERT INTO nce_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Bu Perga lifate kile mëtelo na mëtëyeu na Antiok lifatewa tuhu mutulo, Pisidia provins mëta. Na bubë lotu olëna bu Israelbë afenëbonibë lotu lowa mëtëkaklujo na tafa mëtelulo. ");
INSERT INTO nce_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Na lotu lo hwi moglokweflabë eso ho, Mosesbë yahi hwi motloma na Gotobë lowene mago gali të mototokweflabë hobë yahi mata hwi motloma. Na mana bu ho lime Polname, Barnabasname gali naloglomeme jine metlëla, megali naloglomeme, “O afani, sobo onehome lëgaitamebë gali li egeholona kwe sobo lalowa gëgali egelome.” ");
INSERT INTO nce_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Na Pol huju tle, na bume tobana lëkle totome, gëgali kuju namëglame na gali tlome, “Sobo Israelbë afenëboni na sobo fli oneho, Gotome kë lotu eglëkefëtelobë, sobo iniwa aholokwane elo. ");
INSERT INTO nce_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israelbë afenëbonibë Goto, bu sebobë semleninome meaniji latlome, bubë oneho tafa namëgletlame. Bu bubë life kile mototla na fli enënebë lifate, Isip lifate mëta, tafa mëtla. Na këme Goto bume taitame. Na bu lebutako onehomu fata mëtla. Na Goto tokwafe, bubë afutukuna bume Isip lifate mago nëno tle na ho jwa tabo elë tlelume. ");
INSERT INTO nce_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Na bu kë ho jwa life mëta niliafewe tlibutu këniji asasë mëtla. Na bu kë niliafewe tlibutuna Gotome tetëbo lamototokwefla. Kwe Goto bume lataitakefëme. ");
INSERT INTO nce_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Tokwafe bu tako flëke elë fwa mutula. Kë flëke weniji Kenan. Tobali ita tële li li afenëbo mago enëne kë flëke mëta tafa mëtla. Kwe Goto, Israelbë afenëbonime afutuku tlëme na bu kë afutukuna, kë tobali ita tële li li afenëbo mago enëneme unalëme tëbo mototoma. Na Goto kë enënebë flëke Israelbë afenëbonime yo tlome, kë flëke bubë flëke fata nalëgletëmeme. ");
INSERT INTO nce_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Kë flëke fa mototlabëme 450 tlibutu lamëtla. Na tokwafe, Goto bu oneho flime aniji tlome, Israelbë afenëbonibë asë hwi namoglometëmame. Bu melë motokweija na Gotobë lowene mago gali të totokweflebë ho Samuel bume mana tafa tlelëme. ");
INSERT INTO nce_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Samuel bume tafa tëglelëmebëë, na bu Samuelme takune motlola, li home aniji naloglotëmeme eso home fata nalëgletëmeme. Na kwe Goto, bu Solme aniji tlole, bubë eso home tafa nalëgletëmeme. Na bu eso home niliafewe tlibutu këniji tafa lëgleme. Sol bu Kisbë bowene. Bu Benjaminbë afenëbo mago. ");
INSERT INTO nce_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kwe Goto Solme eso home tafame hehë tletle na Devitme aniji tlole, bubë eso home tafa nalëgletëmeme. Bu Devitme megali tletle, ‘Bo Jesibë nëbame, Devitme, wahwi nololë na bo bume tako tole nanëletelë. Bu bobë iniwa tole esogo lëglelëmetënëme.’ ");
INSERT INTO nce_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ëtani Goto megali sle latle, Devitbë afenëbonibë mago, tako letitabo home lëgëtabetëme nalëgleme, Israelbë afenëbonime tëbo lowene mago nëno nalëgleme. Na kë ho bu wa fata tle na bubë weniji Jisas. ");
INSERT INTO nce_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jisas, bubë wege fa jwa togotlena na Jon, Israelbë afenëbonime gali metë latëtatëme, ‘Sobo tëbo lowenebë aholokwana ti elome na Gotome fwa lowene sle eletelome na mana baptais elome.’ ");
INSERT INTO nce_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jon bubë wege yawe logloleme nounou tle na bu megali latle, ‘Sobo bome melowene laletë nane, “Goto kë aniji toglolebë ho, onehome nëno lëglebë ho.” Weye. Bo sobo kë hwi egletelobë ho nane. Kwe kë ho kë ligisibë, bubë afutuku takomu kwe bobë afutuku tokwëfo. Bo lale ho nane kë ligisi home kë nëgaitalëme, manawa wege ho fene laitale. Weye. Bo bubë jiteho hana titika nëgletelëme. Bu letitabo homu nëgeme na bo atwati homu. Bu lale homu kwe bo atwati homu.’ ");
INSERT INTO nce_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","O afani, Abrahambë afenëboni, na fli enëne Gotome kë lotu eglekefëtelobë, sobo aholokwane elo. Goto onehome kë nëno tëglebë gali, seme wajine tlëtëna. ");
INSERT INTO nce_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalem lifate mëta kë tafa mëtlabë oneho na bubë eso enëne melowene hana mëtletla, ‘Goto, Jisasme aniji tlole, seme tëbo lowene mago nëno lëleme.’ Bu Gotobë lowene mago gali të mototokweflabë ho kë yahi mëtlabë gali, iniwa lotu olëna hwi motlokwefla, kwe bu kë gali lowene sle hana mëtletla. Këme nëgeme megali lamëtla, ‘Jisas kwe gli malële.’ Ebëha lowene kë mëtlabë, kwe bu Gotobë lowene mago gali të mototokweflabë ho ëtani fene yahi mëtla. ");
INSERT INTO nce_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Bu Jisasbë fëye tëbo wesibiha hwi hana motlotla na bume mogo nalë tëkle mototlamu. Weye. Kwe bu eso ho Pailatme anisasana gali motlola, ‘Gli malële.’ ");
INSERT INTO nce_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Gotobë lowene mago gali të mototokweflabë ho, bume ëtani meyahi lamëtletla. ‘Oneho bume memelë tetëbo lowene gwa mëtëtatla.’ Na bu kë iniwa tetëbo lowene Jisasme fwa gogwa motoletla. Na mana bume ti mago tohwa mototla, na matëmatë mëta gwa mutujetla. ");
INSERT INTO nce_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Kwe Goto bume matëmatë mago huju totle. ");
INSERT INTO nce_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Na Jisasna ëtani kë asë mëtlekefëyabë enëne, Galili provins mëta na Jerusalem lifate mëta, bume lebutako olë hwi motlokwefla. Na kë oneho, Jisasme kë hwi motlokweflabë, Israelbë afenëbonime, kë lale gali të mëtëtakefëtëma. ");
INSERT INTO nce_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Na sebo some mata kë lale gali metë nanëtatëyo. Goto sebobë semleninome megali sle latlome, ho lime jine lëgletëname, seme tëbo lowene mago nëno nalëgleme. ");
INSERT INTO nce_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Na Goto, Jisasme matëmatë mago kë huju togotlebë, bu sebobë semleninome fene gali sle tlome. Na kë gali sle gali namba tële Buk Song mëta mefata watletëna. Ëtani Devit, Buk Song mëta meyahi latletle, ‘Ju bobë nëbamu na ëje bo onehome walebotane nëtatemë, bo jubë ayamu.’ ");
INSERT INTO nce_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Goto, Jisasme matëmatë mago huju totle, na bu ita hana gli lëgleme na matëmatë mëta kibo hana lëgleme. Goto ëtani kë wesibime megali latle, ‘Bo sobobë bisemleme, Devitme, fene gali sle tlolë, bo some nëgaitome na lale wesibi nëglëyome. Na kë gali iniyafememu gali telë bu mefata mëgleme, bo ëtani fene gali telë.’ ");
INSERT INTO nce_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Na li gali, Gotobë bogo mëta melëgëbe lalële, kë bu megali latla, ‘Ju jubë wege fame kë aniji toglolebë ho, matëmatë mëta kibo lëglebëme, hwiwa hana egloleme.’ ");
INSERT INTO nce_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Kë gali bu Devitme hana gali tle. Sebo walowene nëla, Devit ebë life mëta tafa tëglena, bu Gotobë tolewa esogo tlelële. Na bu tokwafe gli tle. Na bume matëmatë mëta gwa mototla, bubë bolijafujunime fene gogwa mëtla. Na bubë ato ini flawa tletle. ");
INSERT INTO nce_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Kwe Goto matëmatë mago kë huju togotlebë ho, bubë ato kibo hana tletle. ");
INSERT INTO nce_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Këme nëgeme sebo some, sebobë afanime, lale gali metë këme nëtatëyo. Sobo melowene sle naegelome, ‘Jisas këme tisi, sobobë tetëbo lowene sle nalotometëyome.’ ");
INSERT INTO nce_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Goto Mosesme kë tëglëlebë tafa sle gali tafa sle gali, sobobë tëbo lowene hana sle lëgëtatëyome, na some mefë hana lëgëtome, ‘Lale oneho.’ Kwe iniwa oneho, Jisasme kë lowene sle mëtletlabë, Goto bubë iniwa tëbo lowene aholokwana ti lëgletëmeme na mefë logotomeme, ‘Lale oneho.’ ");
INSERT INTO nce_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","41","Ëtani, Gotobë lowene mago gali të mototokweflabë ho, megali lamëtla, ‘Sobo bome tetëbo gali kë eglonabë enëne, sobo hwi elo. Na klelego egelome na tëbo eglitome. Bo li wesibi sobobë ku mëta fata nëgetatëyome. Bo melë kë nogotlëbë wesibime, ho li some gali lëglëyona, kwe bubë gali aholokwane hana eglolome.’ Sobo ululu sle saelo. Kë tëbo wesibi some fata lëgletëyolime.” ");
INSERT INTO nce_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pol bu gali wafi të tëtatëme. Na kwe buna, Barnabasna, totoho namëkakome kofene, kwe oneho bume megali lamotloma, “Li lotu olë fata lëglena, sobo ita sa esijo na seme gali ita të etatëname.” ");
INSERT INTO nce_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Na oneho lotu lo mago totoho mëtëkaka. Na Israelbë afenëboni lebutako na fli enëne, Israelbë afenëbonibë lotu tokwafe kë esogo mëtlelëlabë, bu Polname Barnabasname esogo mëtlelëma. Na tlemalë bume lale galime megali lamotlokwefëmo, “Sobo Gotobë tolewa esogo elelëlo na bubë maninibo mëta tafa elome.” ");
INSERT INTO nce_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Na li lotu olëna, iniwa oneho, kë lifate mago, Polna Barnabasna Gotobë gali të mogotlobë aholokwaneme loko motokweija. ");
INSERT INTO nce_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Kwe Israelbë afenëboni fli, bu Polname Barnabasname mehwi lamotloma. Lebutako oneho bubë gali aholokwaneme tako tole lamëtla. Na bu tlemalëme tako moumou memëtlelëma. Na bu Polbë gali aholokwane mëglabëme tako kokasa memëtletla. Na bume tiniji galina gali motlola. ");
INSERT INTO nce_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Këme nëgeme, Polna Barnabasna bume anisasana megali motlomo, “Goto bu seme wagali tlona, bubë gali some, Israelbë afenëbonime, afina të nëtatëyobëme. Kwe sobo kë gali aholokwane egelobëme kokasa laletelo. Na sobobë kë lowenena, seme melebotane latatëna, sobo Gotobë unaunalëme lale tafa fa hana egotlome.” Këme nëgeme sebo some hune nelome na Israelbë afenëboni mëtabëya jwa mëglabë enëne belë nëyeume, Gotobë lale gali të nanutatemome. ");
INSERT INTO nce_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Sebo bu betelëme këme negëyeume, Tako Ho seme gali toglonome nëgeme. Bu megali latlono, “Bo jume waaniji nolë. Na elulego, wesibi fene olafa lële, Israelbë afenëboni, mëtabëya jwa mëglabë enëneme, bome meolafa etagutëmeme. Na ju iniwa life mago onehome aitawagumeme, bome lowene namëgletëname. Na bo bume nëno nëkowime.” ");
INSERT INTO nce_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Israelbë afenëboni mëtabëya jwa mëglabë enëne, kë gali aholokwane motloma na tako fleflesu memëtla na gali mëtla, “Tako Hobë gali kë nëgebë, lale galimu.” Na iniwa oneho, Gotona unaunalëme tafa mëglabëme, kë aniji toglomebë, kë oneho, bume lowene sle mëtletla. ");
INSERT INTO nce_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Na Tako Ho Jisasbë gali, kë provins mëta li life li life fifiji mëtlagula. ");
INSERT INTO nce_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Kwe Israelbë afenëboni, bu kë lifate magobë letitabo one, Gotome kë lotu melekefëtlabë tëbo lowene tufiji mëtëtatëma, na kë lifate magobë eso enënebë tëbo lowene mata tufiji mëtëtatëma, Polname Barnabasname tëbo namogotomame fene. Na buna, kë lifate mago oneho flina, bu Polna, Barnabasname tëbo lowene fa mëtëtatëma na bubë distrik mago hehë mëtëkaketëma. ");
INSERT INTO nce_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Na tlemalë, bubë juba mago flëke, kë lifate mago onehobë naba lime bu mëtelo. Melëme lëlekuju mëtelo, bu kë lowene kë fa mogotlabë tëbo miglitayame. Na bu Antiok lifate kile mototlo na Aikoniam lifatewa mëtëyeu. ");
INSERT INTO nce_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Kwe Kristen oneho, Antiok lifate mëta kë tafa mëglabë, tako fleflesu memëtla na Gotobë Amtëtomba bu mëta tëtabetëme. ");
INSERT INTO nce_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Polna Barnabasna, bu Antiok lifate mëta fene mëtelo, bu Aikoniam lifate mëta këha wesibi melamototlo. Bu Israelbë afenëbonibë lotu lowa mëtëkaklujo na Jisasbë lale gali të mëtëtatemo. Bu lale galimu të sle mëtëtatemo. Na Israelbë afenëboni lebutako na Israelbë afenëboni mëtabëya jwa mëglabë enëne, Jisasme lowene sle mëtletla. ");
INSERT INTO nce_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kwe Israelbë afenëboni fli, kë gali lowene sle hana mëtletla. Na bu Israelbë afenëboni mëtabëya jwa mëglabë enënebë tëbo lowene tufiji mëtëtatëma, Kristen onehoname tëbo lowene namëgletëmame. ");
INSERT INTO nce_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Tlemalë Aikoniam lifate mëta tako tafa lamëtelo. Na bu Tako Hobë lale gali tëme uli hana mëtelo. Na Jisas bume tako afutuku tlëme. Na bu kë afutukuna memelë klelegowa wesibi blëge blëge mototomo. Na Tako Ho, bu kë klelegowa wesibina, onehome melebotane latëtatëme, kë gali bu kë të mëtëtatemobë ebë nëgali galimu. ");
INSERT INTO nce_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kwe kë lifate mago oneho telë lowene mëta tafa mëtla. Fliye bu Israelbë afenëbonina yonane mëtla, na fliye tlemalë Aposelna yonane mëtla. ");
INSERT INTO nce_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Tokwafe, Israelbë afenëboni mëtabëya jwa mëglabë enëne fli na Israelbë afenëboni fli na bubë letitabo enënena, iniwa lowene sago mototla. Polname Barnabasname tëbo namogotomame fene na bume aniji sisike namëgletëmame fene, mogo nalë tëtëkle namëgëtayame fene. ");
INSERT INTO nce_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Barnabasna Polna, bume kë tëtëkle mëgëtayabë gali aholokwane mëtelo. Na bu Listra lifatewa lamëtlëboukakujowa. Na bu kë lifate mëta na Derbe lifate mëta asë mëtelo. Këbë lifate bu Likonia provins mëta mëbë. Na bu kë lifate mëglëbo mago life mëta asë mëtelo. ");
INSERT INTO nce_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Na tlemalë bu Jisasbë lale gali kë provins mëta të mëtëtagutemo. ");
INSERT INTO nce_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Na Listra lifate mëta, kiju tëbona ho li këme tëtabe. Bota bume kiju tëbona mëtabo fu totle. Na kë ho bu mana ekë tafa lële. Bu asë hana tle. Bu metafawa latlekëfe. ");
INSERT INTO nce_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Kë ho Pol kë të togotlebë gali aholokwane sle tokoutle. Na Pol bume wëya tlelële na bume melë lowene latletle, kë ho bu Jisasme walowene sle lëgletleme nëgeme, na bubë kiju tëbo, Goto lalowa këme sle lëgëtatleme. ");
INSERT INTO nce_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Këme nëgeme, Pol bume anisasana wëya tlelële na anisasa gali tëtelokwakle, “Ju huju ekokeme na hujuna elibeme.” Na kë ho bu hokweinawa huju tokoke na këme asasë tëbelëfa. ");
INSERT INTO nce_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Lebutako oneho bu Pol kë togotlebë wesibi hwi motlola na bubë Likonia galina momolë mëtla, “Sebobë goto, hoha fata mëlefe na bu sebelë ekë metujulo.” ");
INSERT INTO nce_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Na bu Barnabasme mefë lamototla, “Bu sebobë tako goto Sus.” Na bu Polme mefë lamototla, “Bu sebobë goto, Hermes.” Bu mefë këme mototla Pol bu gëgali takowa ho nëgeme. ");
INSERT INTO nce_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Bubë goto Susbë lotu lo, bu kë lifate tiniju elë tlibetle. Na kë lotu lo mëta wege lëglebë ho, iko bulmakau kleli fli, lifate mago lëglesi ino ëfo elëme tlesume. Na bu lale ti tahweji taba meta susu tujetëme na tehwei. Buna, kë lifate mago onehona, kë bulmakau kleli tëtëkle mëgëtayame kofene, Barnabasna, Polname lotu namëgletëmame fene. ");
INSERT INTO nce_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kwe Barnabasna, Polna, bume kë fata tëgletëmebë wesibibë gali aholokwane mëtelo, na klelego memëtletemo. Na bubë ëho kaka mototomo. Bu melëbëme lëlekuju mëtelo, bume kë mototometëmabë wesibime tole hana mëtelo. Na bu kë onehobë ku mëta mitlibo na bume feilawa këkale galina gali motlomo, ");
INSERT INTO nce_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Sobo kë wesibi fëyeme etlone? Sobo melë asa elo. Sebo sobo fenene këha howa nëtabo. Sebo sobelë këme tisijo, lale ëhwati gali të nanëgëtatëyome. Kë ëhwati gali melë. Sobo blawa kë lotu egletemobë tëbo wesibi aholokwana ti elome na sobo lowene hihijika elome na tako kalëlegona Gotomume lotu eletelome. Kë Goto bu matafana, lifena, nutuna, iniwa wesibi kë mëgebebë, bu blëge blëge totome. Sobo kë lotu egletemobë wesibi some hana mëgaitome. ");
INSERT INTO nce_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ëtani kë nëgebë na ëje mana ekë, oneho bubë tolewa esogo mëtlagila na bu memelë wesibime lotu mëtëkweitëma na Goto bume hwiwa latlagime. ");
INSERT INTO nce_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Kwe Goto bu ëho nane tle. Weye. Iniwa olë Goto onehome lale wesibi olafa tëtagimetëme, bu melowene namëglame, ‘Bu tafa lalëlaginafe.’ Bu some tu tlëwagijo. Na bu lale hi wesibi mata fata tëtagimo. Na bu some feilawa hi wesibi tlëwagijo, na sobobë lowene sle tëtagimekefëtëyo, sobo fleflesuna këme tafa elo.” ");
INSERT INTO nce_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Oneho bubë gali aholokwane mëtla, kwe bulmakau kleli tëtëkle mëgëtayabëme awi lowene mëtlekefëya, tlemalëme lotu namëgletëmame. Kwe tlemalë bume anisasana lëkle lëkle mototokwefëmo. Na bu melë hana mëtla. ");
INSERT INTO nce_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Kwe tokwafe, Antiok lifate mago na Aikoniam lifate mago Israelbë afenëboni, Listra lifatewa mitisiya. Na bu kë lifate mago onehobë tëbo lowene tufiji mëtëtatëma. Na bu Polme wame motlola. Këme nëgeme bu Polme aniji ato elë sisike mëtletla, na bu mogowa latitigowa. Mogo nalë tëkle namoglotlame fene. Na oneho bu meweniji lamëtla, wagli lëlewa. Na bubë ato ki motokouja na lifate mëglëbo elë kile mutula. ");
INSERT INTO nce_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kwe, Kristen oneho Polbë ato li elë mutujutla na hwagënë mototla. Na Pol bu huju tle na lifatewa ita tuju. Jowa olëwa tëtabe na bu Barnabasna Derbe lifatewa mëtëyeu. ");
INSERT INTO nce_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Tlemalë Derbe lifateme, Jisasbë lale gali të mëtëtatemo. Na lebutako onehome mëtaitamo, Jisasme lowene sle namëgletlame. Na bu Derbe lifate kile mëtelo na Listra lifatewa ita mëtëyeu. Na Aikoniam lifatewa ita mëtëyeu na Pisidia provinsbë li mago lifate Antiokwa fwa mutulo. ");
INSERT INTO nce_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Na iniwa life mëta, bu Kristen onehome lale gali të mëtëtagutemo, bume lëgaitame nalëgleme. Tlemalë bume anisasana gali motlomo, “Sobo Jisasme kë lowene egletelobë lowene asa elëkëlo. Mana lowene sle saelekefëtelo. Sobo aholokwane elo, Jisasbë lowene esogo nëglelëtlabë lowene ebë kalëlegomu lalëletle. Sebo feilawa hobota mëta afina tafa nëlame na mana Goto bu sebobë eso home unaunalëme tafa nalëgletëname.” ");
INSERT INTO nce_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Na tlemalë bu Kristen onehobë letitabo home iniwa life mago aniji mëtlagumo, Kristen onehome tafa namëglelëmame. Bu afina hi wesibi yo mëtelo, Gotome lowene sle namëgletelome. Na Gotome gëgali mëtlelëlo, na bu Kristen onehobë letitabo home, Gotobë toba elë mana gogwa mëtelo. ");
INSERT INTO nce_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Tokwafe Barnabasna Solna bu Pisidia provins ku kuwa bule mëtëtagulo na Pamfilia provinswa fwa mutulo. ");
INSERT INTO nce_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Bu Gotobë gali Perga lifate mëta të mututatemo, na tokwafe bu Atalia lifatewa mitimo. ");
INSERT INTO nce_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Na Atalia lifate mëta, sibu lo mëta fe mëtelo. Na sibu lona Siria provins mago Antiok lifatewa metëyo. Ëtani kë lifate mago, Kristen oneho, tlemalëme aniji motloma, Gotobë lale gali të namëgëtatemome. Na bu mata Gotobë toba elëme gogwa mëtla, bume lëgaitame nalëgleme na ululu sle nalogotomeme. Na bume kë aniji motoglomabë wege yawe motlolo. Na bu Antiok lifatewa ita mitisijo. ");
INSERT INTO nce_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Tlemalë bu Antiok lifatewa tuhu mëtelo. Na Kristen onehome gali mëtelokwakëmo, bu belë migisiya namëglame. Na bu mitisiya na tlemalë gali motlomo, “Sebo kë tëgëyeubë, Goto seme taitano. Na sebo onehobë ato sle tëtatemo, na sebo Gotobë gali të tëtatemo, na sebo onehome taitamo, Jisasme lowene sle namëgletlame. Na Goto, Israelbë afenëboni mëtabëya jwa mëglabë enëneme mata, taitame, Jisasme lowene sle namëgletlabëme.” ");
INSERT INTO nce_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Na tlemalë, Antiok lifate mëta, Kristen onehona, lebutako olë tafa mëtla. ");
INSERT INTO nce_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Na këme, fli ho, Judia provins mago, Antiok lifatewa mëtetujula. Na bu Kristen onehome meokokwe lamotloma, “Sobo, Goto Mosesme ato jibo tëtlë gali kë tëglëlebë esogo jwa eglelëlona, na bu sobobë ato jibo tëtlë jwa mogotometëyona kwe Goto some hana nëno lëgleme.” ");
INSERT INTO nce_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Polna Barnabasna kë hobë gali aholokwane motlomo na bubë galime fleflesu hana mëtletëmo. Na buna kë wesibime momata mëtlelogwaya. Këme nëgeme, Kristen oneho, Polna, Barnabasna, fli honame aniji motloma, Jerusalem lifatewa namugujame. Na kë gali, Aposelna, Kristen onehobë letitabo hona sle namugujetlame. ");
INSERT INTO nce_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kristen oneho bume Jerusalem lifatewa jine mëtlëma. Na bu Fonisia provins na Samaria provins kukuwa mutuja. Na bu kë provins mago Kristen onehome, megali motloma, “Israelbë afenëboni mëtabëya jwa mëglabë enëne mata Jisasme lowene sle mëtletla.” Bu kë gali aholokwane mëtla na bu tako fleflesu memëtla. ");
INSERT INTO nce_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Bu Jerusalem lifatewa fwa mutula. Na Kristen onehona, bubë lotu letitabo enënena, Aposelna gali motloma, “Sobo sebelë egisijome nëgeme, sebo some tako fleflesu këme nëletëyo.” Na Polna Banabasna megali motlomo, “Sebo li life li lifewa kë tëgëyeubë, Goto seme feilawa taitano na sebo memelë wesibi melë këme totomo.” Na tlemalë bu kë iniwa wesibime gëgali mëtlelëmo. ");
INSERT INTO nce_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Kwe Farisi ho fli, Jisasme lowene sle mëgletlabë, bu huju mëtla na bu megali lamëtla, “Israelbë afenëboni mëtabëya jwa mëglabë enëne, Jisasme kë lowene sle mëtletlabë, Goto Mosesme kë tëglëlebë tafa sle gali saesogo sle mëlelëla na sobo bubë ato jibo satëtlë etometemo.” ");
INSERT INTO nce_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Na kwe, Aposelna, letitabo hona loko mëtlelëya, kë gali sle namogotlame. ");
INSERT INTO nce_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Bu kë galime, feilawa gëgali mëtla na mana Pita huju tle na gali tlome, “O afani, sobo walowene elo, ëtani Goto bome somago wafi aniji tlonë, Jisasbë lale gali, Israelbë afenëboni mëtabëya jwa mëglabë enëneme të nanëgëtatemëme, bu aholokwane namlame na bume lowene sle namëgletlame. ");
INSERT INTO nce_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Goto iniwa onehobë lowene wafi lowene lëletëme. Na bubë Amtëtomba kë Israelbë afenëboni mëtabëya jwa mëglabë enëneme watlëme, seme fene tlëna. Na bu këha lowene kë tëglebë, seme melëme lebotane tëtatëna, bu kë Israelbë afenëboni mëtabëya jwa mëglabë enëneme mata fleflesu latletëme. ");
INSERT INTO nce_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Goto seme fene tëtana, bu kë Israelbë afenëboni mëtabëya jwa mëglabë enëneme këha melë wafi totome. Bu Jisasme lowene sle mëtletlame nëgeme, na Goto bubë tëbo lowene aholokwana këme ti tletëme, sebobë tëbo lowene aholokwana fene ti tletëna. Na bu Gotobë naba lime lalowa këme tafa mla. ");
INSERT INTO nce_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Sobo kë onehome, Goto Mosesme kë tëglëlebë tafa sle gali esogo mëglelëmabëme asa gali elomo. Bu kë gali habëna esogo mëglelëmamene? Sobo këha hobota bume asa elëmo. Sobo hwi elo, sebobë semlenino kë tafa sle anebo gali hana esogo sle mëtlagima. Na sebo mata kë tafa sle anebo gali hana esogo sle nëlagila. Na sebobë afuninona, sebona iniwa kë tafa sle anebo gali esogosle nëglagilabëme tako hobota mëta tafa nëla. Sobo kë onehome melë egotomona kwe sobo Gotome su etlo. Sobo Gotome fëyeme su etlone? ");
INSERT INTO nce_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Kwe sebo melowene nëglame, ‘Tako Ho Jisasbë maninibo mëta fwa, Goto seme nëno tle. Na kë enëneme mata Jisasbë maninibo mëta fwa nëno tle.’ ” ");
INSERT INTO nce_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pita megali tle, na loko kë mëtlelëyabë ho, gëgali lakujuwa metëbaguja, li gali hana ki mëtla. Na bu Polna Barnabasnabë galiwa aholo bo mëtëtagutëma. Na bu megali motlomo, “Goto seme afutuku tlëno na sebo kë afutukuna memelë klelegowa wesibi, Israelbë afenëboni mëtabëya jwa mëglabë enënebë kume blëge blëge totomo.” Na bu kë wesibi galibë të mëtëtatemo. ");
INSERT INTO nce_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Tlemalë gali wafi yawe motlolo na Jems mana gëgali tle, “O afani, bobë gali aholokwane elotëna. ");
INSERT INTO nce_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimon Pita bu seme megali sle tlona, Goto, Israelbë afenëboni mëtabëya jwa mëglabë enëne belë alako kë tigisitëmebë, bubë maninibo melebotane nalëgëtatëmeme. Na bu mago fli, aniji naloglomeme bubëmu tafa, namëgletlame. ");
INSERT INTO nce_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Na Gotobë lowene mago gali të mototokweflabë ho, kë galime wafi gali mëtla. Ëtani bu kë gali meyahi lamëtla, ");
INSERT INTO nce_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Tako Ho megali tle, “Devit onehome eso home kë tafa tëgletëmebë wege, lo fene fli tletle. Kwe unina tokwafe bo nigisime kë wege nahuju nogotlëme, ho fli lëglebë lo fene huju lotle. Na Devitbë afenëboni onehobë eso home tafa mëgletëmabë wege ita fa motlame. ");
INSERT INTO nce_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Na këme Israelbë afenëboni mëtabëya jwa mëglabë enëne bome hohwi mëgëtakefëtëname. Kë enëne bu Israelbë afenëbo nane, kwe bo kë enëneme waaniji tlomë, bu mata bobëmu namëgëtabëtëname.” ");
INSERT INTO nce_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ebë Tako Hobë gali. Bu ëtanimu kë wesibime megali wafi tle, kë wesibi fata mëgleme.’ ");
INSERT INTO nce_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Këme nëgeme, bobë lowene melë lëgëbetenë lalële. Sebo Israelbë afenëboni mëtabëya jwa mëglabë enëneme, Jisasme tokwafe kë lowene sle mëtletlabë enëneme gali asa manoloma, ‘Sobo, Goto Mosesme kë tëglëlebë tafa sle gali iniwa saesogo elelëlo.’ Weye. Sebo kë hobota galina bume asa gali manoloma. Bu Gotome tokwafe lowene sle mletla. ");
INSERT INTO nce_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Kwe sebo bume pasë lalowa yahi nëletëma na bume nelëkakëmame. Na bume megali nelëkakëmame, ‘Sobo fësome kë gogwa mëglabë hi wesibi asa hi elo. Na sobo lisei lowene asa elo. Na bu ko iniwa luguju tleslejwabë kleli asa hi elo. Na komu mata asa hi elo.’ ");
INSERT INTO nce_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Bu kë lowene esogo jwa mëglelëlana kwe Israelbë afenëboni bu tiniji mëglame. Israelbë afenëboni bu iniwa tafa sle gali, Moses kë yahi tëglebë, lowene sle lamletla. Na ëtani anebomu na ebë olë mata, Goto Mosesme kë tëglëlebë tafa sle gali iniwa life mëta të mëtëtagukefëtla. Na iniwa tafawa mëglabë olëna, Israelbë afenëbonibë lotu lo mëta, bubë gali hwi mëtlagikefëtla.” ");
INSERT INTO nce_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Aposel ho na lotu letitabo enëne na Kristen oneho fli, kë mëta kë loko mëtlelëyabë, bu blalo gali sle mototla, bu mago tlemalë letitabo home aniji namoglomame, Polna Barnabasna Antiok lifatewa iniwa buna muguja namëglame. Na bu Judasna Sailasname aniji motloma. Judasbë li weniji ebë Barsabas. ");
INSERT INTO nce_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Na bu pasë li yahi mëtla. Na kë pasë bubë tobame mëtlëma, mëgehujaya namëglame. Bu meyahi lamëtla: “O Silisia provins mago, na Siria provins mago na Antiok lifate mago oneho, sebo Aposelna letitabo hona some ebë pasë ekë yahi nëkeketëyo. Sobo sebobë afanino. Sobo, Israelbë afenëboni nane, kwe sebo iniwa Jisasme lowene sle nëletla. Lale klijimu. ");
INSERT INTO nce_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Sebo gali waaholokwane tla. Semago ho fli, sobelë mitisiya na bu tutune lowenena, sobobë lowene wasisile mototometëyo. Bu some memelë galina gëgali mëtlelëyo. Na sobo kë gali klelego metletemo na tutune lowene mëta tëtabo. Kwe sebo kë iniwa gali some hana gali telëbakëyo. ");
INSERT INTO nce_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Sebo somëta kë fata mëtëglebë wesibibë gali, waaholokwane tletëyo. Këme nëgeme sebo loko tlelëya na sebo jowa lowene mëta fwa tëtabëya. Na sebo gali sle totla, tlemalë home aniji nanoglomame na sobelë jine nanëgelëfakëmame. Na bu sebobë lale yabeni, Polna, Barnabasna bubë nagi migisijome. ");
INSERT INTO nce_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Polna Barnabasna sebobë Tako Ho Jisas Klaisbë wege fa motokweflo. Na oneho bume wame lamolokwefëma na bume mogo nalë tëbo mogotomame fene. Kwe bu këbëme uli hana mëtelo. Bu Jisasbë wege mana fa motokweflo. ");
INSERT INTO nce_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Këme nëgeme sebo Judasna Sailasname sobelë këme jine nëlëma. Sebo some pasë mëta kë yahi nëgletëyobë gali të namëgëtatëyome. ");
INSERT INTO nce_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Sebo Gotobë Amtëtombana jowa lowene wasle totla. Sebo melowene nanëla, ‘Sebo some megali hana gali noglëyome, sobo Israelbë afenëbonibë iniwa lowene saesogo elelëtemo.’ Weye. Sebo some kë hobota galina hana gali noglëyome. Sobo ebë lowenewa saesogo elelëlo. ");
INSERT INTO nce_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Sobo fësome kë gogwa mëglabë hi wesibi asa hi elo. Na bu ko iniwa luguju tlejwabë kleli asa hi elo. Na sobo kleli afabo tuja salë toba asa hi elo na kolei mata asa hi elo. Na sobo lisei lisei asa elo. Sobo ebë wesibime ululu sle egelona na kë kwe lalowa. Sebobë gali eme tei tou lëletëna. Sobolalo ululu sle saelo.” ");
INSERT INTO nce_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Na kwe Kristen oneho kë nilimalë home Antiok lifatewa jine mëtlëma. Bu Antiok lifate mëta fwa mëtla. Na bu Kristen onehome loko mëtelëkakëma na kë pasë bume mëtlëma. ");
INSERT INTO nce_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Bu kë pasë hwi motlëyabë na kë pasë galime tako fleflesu memëtla. ");
INSERT INTO nce_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas na Sailas, bu Gotobë lowene mago gali të mëtëtagutemobë ho. Na bu Antiok lifate Kristen onehome lebutako lale gali të mëtëtatemo. Bu kë lale galina, onehome lamëtaitamo, Jisasbë lowene esogo sle namëglelëlame. ");
INSERT INTO nce_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Tlemalë bu Antiok lifate mëta sogë tafaha mëtelo. Na tokwafe Kristen oneho bume kaiyo motloma. Na bume kë jine mëtelëbakëmabë oneho belë, jine mëtelëkakëma. ");
INSERT INTO nce_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Na Polna Barnabasna Antiok lifate mëta mana tafa mëtelo. Na buna fli enënena, Gotobë lale gali lebutako onehome okokwe motlokwefëma na bu Jisasbë gali të mëtëtakefëtëma. ");
INSERT INTO nce_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Tokwafe, Pol Barnabasme megali tlole, “Sebo, otome Jisasbë gali kë të tëtagutemobë oneho belë ita nëgëyeume. Sebo melowene nanëgletemome, ‘Bu Jisasme kë lowene mëtletlabë lowene anisasana mana lowene melekefëtlane o hanane?’ ” ");
INSERT INTO nce_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","kwe Barnabasbë tole metëgëbetle latle, Jon-Makna iniwa mugujame. ");
INSERT INTO nce_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Kwe Pol gali tle, “Kë ho kwe ëtani Pamfilia provins mëta seme wahune tëtano. Bu sebona kë wegeme tugujame tole hana tle. Këme nëgeme sebo bume hana nëglelulome.” ");
INSERT INTO nce_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Tlemalë bu kë wesibime yonane hana mëtelo. Na blalo momata mëtelo. Na bwa bwa mëtëyeu mëtelo. Barnabas Makme no tlële na bu sibu lowa fe mëtelo na Saiprus afayowa mëtëyeu. ");
INSERT INTO nce_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Kwe Pol Sailasme aniji tlole, buna mëgëyeu namëgelome. Na Kristen oneho, Gotome takune motlola, tlemalëme ululu sle nalëgëtagumeme na bume lëgaitame nalëgleme. Na tlemalë mana mëtëyeu. ");
INSERT INTO nce_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Na këme tlemalë Siria na Silisia provinswa mëtëyeu. Na bu li life li life mago Kristen onehome, lale gali të mëtëtagutemo. Bu kë lale galina, bume lamëtaitamo, Jisasbë lowene esogo sle namëglelëlame. ");
INSERT INTO nce_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Polna Sailasna Derbe lifatewa fwa mutulo, na tokwafe Listra lifatewa mëtëyeu. Kë lifate mëta, Kristen ho li tëtabe. Bubë weniji Timoti. Timoti bota bu Israelbë afenëbonibë mago mëse na bu mata Kristen mëse. Kwe bolijaya bu Israelbë afenëboni nane, bu Grik life mago ho. ");
INSERT INTO nce_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Na Kristen oneho, Listra na Aikoniam lifate mago, Timotime melowene lamëtletla, “Bu lale homu.” ");
INSERT INTO nce_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol bu metole latle, Timotime weife lëgleluleme. Kwe bu walowene tle, Israelbë afenëboni, li life li life mëta kë tafa mokoujabë melowene wamëtletla, “Timoti bolijaya bu Israelbë afenëbo mago nane, bu Grik life mago ho. Na Timoti tokwëfome nëgena kwe bolijaya bubë ato jibo tlë hana tëtatle.” Këme nëgeme, Pol Timotibë ato jibo këme tlë tëtatle, Israelbë afenëboni bume fleflesu namëgletlame. ");
INSERT INTO nce_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Pol, Sailas, Timotina bu Listra lifate kile mëtla na li life li life elëme mutuja. Na bu kleli kolei hi jwa gali, na fli gali, Aposelna lotu letitabo enënena ëtani Jerusalem lifate mëta kë sle mototlabë, Kristen onehome okokwe mëtlaguma. Na bume megali motloma, “Sobo ebë gali saesogo sle elelëkefëlo.” ");
INSERT INTO nce_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Bu kë gali aholokwane mëtla na këme nëgeme iniwa Kristen bu Jisasme kë lowene sle mëtletlabë lowene feilawa kalëlego tletëme. Na Jisasme lowene sle mëgletlabë oneho bu feilawa fata mëtla. ");
INSERT INTO nce_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Tokwafe Polna, buna kë mutujabë ho, Esia provinswa Gotobë gali tëme mugujame tole mëtla. Kwe Gotobë Amtëtomba bume lëkle totome. Na bu kë belë muguja jwa namëglame. Këme nëgeme bu Frigia provins na Galesia provins ku kuwa mutuja. ");
INSERT INTO nce_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Na bu Misia provins li elë fwa mutula. Na bu Bitinia provinswa muguja namëglame fene kwe Gotobë Amtëtomba bume ita lëkle totome kë belë muguja jwa namëglame. ");
INSERT INTO nce_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Këme nëgeme bu Misia provins kukuwa mutuja na Troas lifatewa fata mutula. ");
INSERT INTO nce_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Na kë klabëna, Pol, Masedonia provins mago ho lime, nimitelëha wesibina hwi tlole. Kë ho tlibe na anisasana gali tlole, “Ju nutu su elëme na Masedonia provins elë esime na seme aitaname.” ");
INSERT INTO nce_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol bu nimitelëha wesibi wahwi tle. Na sebo hokweinawa wesibi sle totoma, Masedonia provinswa nuguja nanëglame. Sebo walowene tla, Goto seme walebotane lëtatëna, Jisasbë lale gali Masedonia provins mago onehome të nanugutatëmame. ");
INSERT INTO nce_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Këme nëgeme sebo Troas lifate mëta sibu lowa fëfe tla. Na Samotres afayo mago lifatewa su tëkaka. Sebo këme jowafewa nitebëya. Na li olëna sibu lo seme Neapolis lifatewa sei tujuwelëna, Masedonia provins mëta. Sebo kë sibu lo mago kë lifate mëta fëfe tla. ");
INSERT INTO nce_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Sebo Neapolis lifate kile tla. Na Filipai lifatewa life nagi tuja. Rom lifate mago enëne bu ëtani kë life bu le mëtlëkakila na këme mana tafa mëtla. Na ebë Masedonia provinsbë lale na tako lifatemu. Na sebo kë lifate mëta, habenuju afe olë tafa tla. ");
INSERT INTO nce_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Na Israelbë afenëbonibë lotu olëna, sebo kë lifatebë lëglesi ino elë totoho tëkaka. Na sebo lolime kë tëgëbebë tu helefo elë tuja. Sebo meweniji latla, Israelbë afenëboni fli bu Gotome gëgali mëglelëkeflabëme këme loko mëlelëkefëyawa. Na sebo kë tu helefo mëta, one flime hwi tloma, bu këme loko mëtlelëya. Na sebo tuja, na buna tafa tula na gëgali tla. ");
INSERT INTO nce_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Na mëse li këme tafa tle bubë weniji Lidia. Bu Taiataira lifate mago mëse. Na bu lale winowa ëho balitina hihijika tlekëfe na feilawa baliti këna glo tlekëfe. Bu Israelbë afenëboni magobë mëse nane kwe bu Gotome lowene sle latletle. Bu Polbë gali aholokwane tlole. Na Tako Ho bubë lowene sle tëtatë na bu Polbë gali lowene sle tletle. ");
INSERT INTO nce_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Na sebo buname, na bubë ilawa lo mago enënename baptais totoma. Bume wabaptais totoma na bu seme gali tlona, “Sobo bome melowene sle egletënana, ‘Bu Jisasme walowene sle eletlefe,’ kwe sobo lalewa egisijome na bobë lo mëta bona tafa nëlame.” Na bu seme itaita gali wafi tlona. Na sebo buna nugujabëme halawa tletëya na bubë lowa nagi telëkakëya. ");
INSERT INTO nce_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Olë lina, sebo Israelbë afenëbonibë, Gotome kë gëgali mëtlelëkeflabë life elë tuja. Na sebo manawa kë wege eglekëfebë layo mëseme esune tlëya. Ahwane kë mëse mëta tëtabetë. Na kë ahwane kë mëseme, wesibi tokwafe fata mëglebë gali tëme taitakefë. Na bume kë tafa mëtëglelëyabë eso ho, lebutako baliti kë mësebë gali të wegena glo mëtlekefëya. Oneho bume baliti mëtlëkefëma na kë mëse bume tokwafe kë fata mëgle wesibi gali të tëtakefëtëme. ");
INSERT INTO nce_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Na kwe kë mëse Polna seme nagi esogo tlagina na itaita mewe tokwei, “Kë enëne kë nëgebë, tako afutukuna Gotobë wege enëne. Goto some kë lëgaitobë na kë nëno lëglebë lowenebëme të mëtakefëtëyo.” ");
INSERT INTO nce_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Kë mëse bu lebutako olë memelëwa latlekëfe. Na Pol bu we toglokwefëmebëme kokwasamu latletë. Na bu swaya tëkaketë na kë ahwaneme gali telëkakle, “Bo jume Jisasbë wenijina gali nolë, ju kë mëseme kile etamë.” Na hokweinawa kë ahwane bume lakilewa tëtamë. Na këme nëgeme, bu wesibi tokwafe fata mëglebë gali ita hana të totle. ");
INSERT INTO nce_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Bume kë tafa mëtëglelëyabë eso ho, yafe hwi motlëya na melowene lamëtla, “Sebo baliti hana glo nëglamefe, fëyeme tëbo nenenë?” Na bu Polname Sailasname këme fafa mëtla na këme kë loko mëlelëkefëyabë life elëme, bubë eso enëne belë ki motokouja. ");
INSERT INTO nce_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Na bu tlemalë, onehobë gali aholokwane moglomabë ho belëme mëtleluma na bume gali motloma, “Kë tlemalë ho, bu Israelbë afenëbonibë ho. Na bu ebë life mago onehobë tëbo lowene tufiji mëtëtatemo. ");
INSERT INTO nce_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Kë tlemalë ho, bu onehome memelë lowenebëme okokwe motlomo, kë lowene esogo namëglelëmame. Sebo kwe Rom provins mago enëne. Sebobë lowene këha nane. Weye. Na sebo bu kë gëgali mëgelobë lowene hana esogo nëglelëtëmame.” ");
INSERT INTO nce_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Na kë mëta kë loko mëtlelëyabë oneho, kë tlemalë home mata tëbo gali motloma. Na kwe, onehobë gali aholokwane moglomabë ho, tlemalë hobë gelowa ëho titika mëtletëma na wame home boblo mogotomabë enëneme gali motloma, “Sobo bume atobeilana lëlafa etomo.” ");
INSERT INTO nce_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Këme nëgeme, bume unalëme atobeilana lëlafa lëlafa sle memototoma. Na onehobë gali aholokwane moglomabë ho bume kalabusu lowa mëtleluma. Na kalabusu lo mago home hwi loglokwefëmebë home anisasana gali motlola, “Ju kë tlemalë home hwi sle sa elome, mëglëboukakujolime.” ");
INSERT INTO nce_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kalabusu lo mago home hwi toglomebë ho, kë gali aholokwane tlome. Na bu tlemalë home, kalabusu lo ku mëta kë lëgelubebë tlëtabo elëme tlelëkakume. Na bubë kiju ti tële afloko elë sike telukwaketëme, mëglëboujolime. ");
INSERT INTO nce_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Klabë kunamu, Polna Sailasna bu Gotome gëgali mëtlelëkeflobëë na sawa mata fëfë mëtëtakefëyo. Na fli enëne, kë kalabusu lo mëta kë tafa mëtlabë, bu Polna Sailasname mana aholokwane motlokwefëma. ");
INSERT INTO nce_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Na hokweinawa nano tako latlamëwa. Na bu kë kalabusu lo anisasana so tëbelëkakle bu ëjeha fli etleme. Na kë kalabusu lo ino iniwa latitikawa mëtëkou. Na senë taba iniwa kalabusu enënebë mago lalokluwa mëtletëme. ");
INSERT INTO nce_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Na kalabusu lo mago home hwi toglomebë ho, huju tle na këme mehwi tle, iniwa kalabusu lo ino watitika mokoufe na melowene tle, “Kalabusu kë mëglabë ho iniwa wamelëboujafe. Bobë eso ho bome gali loglonëmefe.” Këme nëgeme bubë kosi ki tokoke na bubë ato, këna mogo nalë tlu nalogotleme fene. ");
INSERT INTO nce_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Kwe Pol bume anisasana këkale telokwakle, “Jubë ato asa tëbo etle, sebo iniwa mana ekë nëtabëya.” ");
INSERT INTO nce_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Na kalabusu lo mago, home hwi toglomebë ho, ho lime we telokwakle, “Esi hokweinawa ehwei.” Na bu esi tehwei tle na bume tlële. Na bu kalabusu lowa hokweinawa tëkaklu. Na bu Polna Sailasna belë fëka tokou. Bu ulina lilina sago metle na bubë li mëta, sëkefo miti tafa tle. ");
INSERT INTO nce_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Na kwe bu tlemalëme kalabusu lo mago toho tlelëkakëme. Na bume takune tlome, “O letitabo, bo habelë nëgelëmene na Goto bome tëbo lowene mago no nalëglënëme?” ");
INSERT INTO nce_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Na tlemalë këme gali motlolo, “Ju, Tako Ho Jisasme fwa salowene sle eletle na Goto, juna, jubë mësena, nëbalena, na jubë lo mëta kë tafa eglelëmebë enënename tëbo lowene mago nëno nalëgleme.” ");
INSERT INTO nce_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Na këme tlemalë, kë honame bubë lo mëta kë tafa tëglelëmebë enënename, Jisasbë gali të mëtëtatemo. ");
INSERT INTO nce_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Na këme klabë kuna mu, kalabusu lo mago home hwi toglomebë ho, tlemalëme nëno tle. Na bume atobeilana kë lëlafa mototomabë lunuju swa totometëme. Na tlemalë, kë ho na bubë lo mëta kë tafa lëglelëmebë enënename baptais mototomo. ");
INSERT INTO nce_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Na kalabusu lo mago home hwi toglomebë ho, tlemalëme bubë lowa tlelume na bume hi wesibi tlëme. Na buna bubë lo mëta kë tafa tëglelëmebë enënena fleflesumu memëtla, bu Gotome lowene sle mëtletlame nëgeme. ");
INSERT INTO nce_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Olobalë, onehobë gali aholokwane moglomabë ho, plismanë kalabusu lowa jine mëtlëma. Na bu kalabusu lo mago home hwi toglomebë home gali motlola, “Onehobë gali aholokwane moglomabë ho megali lamla, ‘Ju kë tlemalëme kalabusu lo mago jine elëkakëme.’ ” ");
INSERT INTO nce_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Këme nëgeme, kalabusu lo mago home hwi toglomebë ho, bu Polme gali tlole, “Onehobë gali aholokwane mëglabë ho bu megali lalëkeke, ‘Polna Sailasname kalabusu lo mago sajine elëkakëmo.’ Këme nëgeme sobo lalowa eyeu. Sobo tutune lowenena asa eyeu.” ");
INSERT INTO nce_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Kwe Pol plismanëme megali tlome, “Onehobë gali aholokwane moglomabë ho, sebobë gali aholokwane sle jwa fëyeme mëtlane? Bu sebobë li fëye wesibiha hwi hana motlotëna. Kwe bu seme hobë naba li mëta blawa lëlafa mëtëtana na kalabusu lowa blawa sike mëtla. Kë enëne melowene hana mëtlane, ‘Sebo Rom provins mago enënefe?’ Na ëje bu seme hwelutuwa nëgëyeubëme fëyeme gali molonane? Matëbefe, hanane mu. Kë onehobë gali aholokwane moglomabë letitabo ho, buwa samisiya, na seme kalabusu lo mago nëno mlame.” ");
INSERT INTO nce_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Na kwe plismanë ita mutuja, na bu Polbë gali, onehobë gali aholokwane moglomabë home gali motloma. Bu megali motloma, “Polna Sailasna bu Rom provins mago ho.” Onehobë gali aholokwane moglomabë ho, kë gali aholokwane mëtla na bu tako uli memëtla. ");
INSERT INTO nce_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Këme nëgeme, bu kalabusu lowa mutuja na Polname Sailasname gali motloma, “Masiwafe, sebo tëbo enëne, sebo some tëbo latëto. Sebo melowene hana tletëyo, ‘Sobo Rom provins mago ho. Masiwafe.’ ” Na bu tlemalëme kalabusu lo mago nëno mëtla na bume gali motloma, “Sobo ebë lifate lalowa kile egotlomene?” ");
INSERT INTO nce_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Na kwe tlemalë kalabusu lo kile mototlo na Lidiabë lowa mëtëyeu. Na bu Kristen oneho flina loko mëtlelëya. Na bume lale gali të mëtëtatemo, bume lëgaitame nalëgleme. Na tokwafe bu Filipai lifate kile mëtelo na mëtëyeu. ");
INSERT INTO nce_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pol bubë yabena, Amfipolis lifatewa mutuja. Bu kë lifate kile mëtla na Apolonia lifatewa mutuja. Na bu kë lifate mata kile mëtla na Tesalonaika lifatewa tuhu mutula. Israelbë afenëbonibë lotu lo kë lifate mëta tlibetëme. ");
INSERT INTO nce_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pol iniwa lifate mëta fene tokou, bu kë lifate mëta mata melatle. Bu Israelbë afenëbonibë lotu lowa tëkaklu na bu kë life mago onehona loko mëtlelëya. Na Gotobë bogo mago galime, buna gëgali hihijika mëtlekefëya. Bu aona wiki bubë lotu olëna melatlelëkefëme. ");
INSERT INTO nce_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Na bume megali sle latlome, “Jisas bu kë ho kë nëgebë, Goto bume ëtani anebomu kë aniji toglolebë ho, onehome tëbo lowene mago nëno nalëgleme.” Na bume gali tlome, “Aholokwane elo, ëtani Gotobë bogo mëta, gali metëgëbetle latle, ‘Goto kë jine lëglelebë home, tëbo mogotlame na bu gli lëgleme. Kwe bu matëmatë mago huju lëgleme.’ Na kwe kë gali, bu Jisasme fwamu gali tletle. Sobo walowene elo, Jisas bu wagli tle na huju tle, Goto ëtani fene gali tle.” ");
INSERT INTO nce_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Na Israelbë afenëboni fli, buna kë tafa mëtlabë, Pol kë të togotlebë gali, aholokwane motlola na bu Jisasme lowene sle mëtletla. Na bu Polna Sailasname yonane sle mëtlelëma na nagi mëtlëma. Na lebutako Grik life mago enëne Gotome kë lotu melekefëtlabë, na lebutako letitabo one mata Jisasme lowene sle mëtletla. ");
INSERT INTO nce_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Kwe Israelbë afenëboni fli, bu Polna Sailasna, ilawa kë yonane mëtlabëme, hwi motloma. Na bume moumou mëtlelëma. Këme nëgeme, bu ho loko mëglelëyabë lifeme, blawa kë asasë mëglabë tëbo enëneme, loko mëtëtagujaya. Bu lebutako tëbo enëneme waloko mëtëtaya na bubë tëbo lowene tufiji mëtëtatëma, Polna Sailasname wame namoglomame. Na bu asë mëtëbelëfaiya na anisasa flikale mëtla. Na fli, Jesonbë lo ino tëë mëtelutukwakla na mëtëkakluja. Na bu Polna Sailasname hohwi mëtelutatëma, bume kë life mago onehobë toba elë gogwa namëglame. ");
INSERT INTO nce_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Bu tlemalëme yafe hohwi mëtëtatëma kwe hwi hane motloma. Këme nëgeme bu Jesonname, Kristen oneho fliname, fafa mëtla na kë lifate mago eso ho belëme mëtleluma. Na bu anisasana meflikale mëtla, “Ebë enënena, Polna, Sailasna bu iniwa li life li life motokouja na onehobë tëbo lowene tufiji mëtagutëma. Na ëje ebelë mana kë fe mëkakija. ");
INSERT INTO nce_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Na Jeson kë hobëme bubë lowa nëno tle na këme tafa tlelëme. Kë enëne bu sebobë tako eso ho, Sisarbë gali boblo lamëtëtakefëtla. Na bu itaita megali lamelekefëya, ‘Tako eso ho li lëtabe, bubë weniji Jisas. Sobo bume fwa esogo elelëlome.’ ” ");
INSERT INTO nce_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kë life mago oneho na bubë eso enëne, kë gali aholokwane mëtla na wame mëtla na flikale mëtëkouja. ");
INSERT INTO nce_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Na kwe, kë lifate mago eso ho, bu Jesonna, buna kë tafa tëglelëmebë onehome, balitime gali tlome, bubë tëbo lowene këna sle namogotlame. Na bume jine mëtelëkakëma. ");
INSERT INTO nce_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Klabë wafi ki tëbe na Kristen oneho Polna Sailasname Beria lifatewa mana jine mëtelëkakëma. Bu Beriawa fwa mutulo na bu Israelbë afenëbonibë lotu lowa mëtëkaklujo. ");
INSERT INTO nce_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Israelbë afenëboni Beria lifate mago, bu Tesalonaika lifate mago Israelbë afenëboniha nane. Beria mago enëne Polna Sailasnabë gali aholokwane mëglabëme tole lamëtletëma. Kwe Tesalonaika mago enëne buwe, bubë gali aholokwane mëtletëmabëme tole hana mëtletëma. Na iniwa olë, Beria mago oneho, Gotobë bogo mago gali itaita hwi motlokwefëma, melowene sle namëgletlame, “Polna kë të mëgëtatemobë gali bu nëgali lamelo o hanane.” ");
INSERT INTO nce_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Na Israelbë afenëboni lebutako, Jisasme lowene sle mëtletla. Na Grik life mago ho lebutako na Grik life mago letitabo one lebutako, bu mata Jisasme lowene sle mëtletla. ");
INSERT INTO nce_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Kwe Israelbë afenëboni Tesalonaika lifate mëta kë tafa mëtlabë, kë gali waaholokwane mëtla, Pol, Beria lifate mëta, Gotobë gali kë të lëtakefëtëme. Këme nëgeme bu Beria lifatewa mutuja na onehome tetëbo galina gali mëtlaguma na këna onehobë tëbo lowene tufiji mëtëtatëma, Polme wame namoglolame. ");
INSERT INTO nce_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Na kwe, hokweinawa, Kristen oneho, bu Polme nutu yenëbawa jine mëtëtelëkakla. Kwe Sailasna Timotina, Beria lifate mëta mana tafa mëtelo. ");
INSERT INTO nce_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Na Polme kë sei mutujuwelëlabë ho buna Atens lifatewa tuhu mutula. Na bu Polme Atens lifate mëta kile mutula na bu Beria lifatewa ita mutuja. Na Pol, Sailasname Timotiname gali telokwakëme, bu bo belë hokweinawa samisijo. ");
INSERT INTO nce_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pol bu Atens lifate mëta, Sailasna Timotiname mana hwi tlekëfetëmebëë na bu Atens lifate wako wako mana asë tëbelëfa. Na bu mehwi tle, eouwe bubë lebutako fëso mana mëtabetëmefe. Na bubë lowene tëbowamu tëbetle. ");
INSERT INTO nce_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Këme nëgeme bu Israelbë afenëbonibë lotu lowa tëkaklu. Na bu Israelbë afenëbonina na Israelbë afenëboni mëtabëya jwa mëglabë enënena, Gotome kë lotu mëglekefëtlabëme, gëgali hihijika mëtlekefëya. Na iniwa olëna bu ho kë mëta loko mëglelëkefëyabë life elëme tujukëfetëme. Na kë mëta kë tafa mëtlabë onehome gëgali tlelëkefëme. ");
INSERT INTO nce_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Na lowene letitabo mëgletlabë ho fli, kë mëta tafa mëtla. Bume mefë lamototoma, Epikurian enëne na Stoik enëne. Na bu Polme momata mëtlelëla. Pol bume, Jisasbë galime gëgali tlokwefëme na bume matëmatë mago huju mëglabë galime mata gëgali tlelëkefëme. Këme nëgeme kë enëne megali mëtla, “Kë lowene jwa ho bu itaita blawa fëyeme gëgali lëlekëfene? Bu fëye wesibime gali lëlene?” Na fli megali mëtla, “Sebo bubë gali lowene hana nëletla, bu seme melëme gali lolona nawa, ‘Sobo fli enënebë gotome salotu eletemo.’ ” ");
INSERT INTO nce_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Na kwe bu Polme, bubë lifate mago eso enëne belë mëtlelula, bubë gali aholokwane namoglolame. Kë enëne bu Areopagus fatini mëta loko mëtlelëkefëya. Na kë enëne Polme gali motlola, “Ju kë tiho gali, ju onehome kë okokwe eglokwefëmebëme, seme ita gali enona. Sebo kë wesibi lowene sle nanëgletlame. ");
INSERT INTO nce_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Sebo jubë gali aholokwane tla, na sebo melowene nanëletëyo, ‘Ebë li gali meha gali ele. Na sebo ëtani këha gali aholokwane hana tla. Këme nëgeme sebo metole nanëla, ju kë okokwe toglonabë gali wayobë lowene sle nanëgletlame.’ ” ");
INSERT INTO nce_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Atens life mago enënena, Atens lifate mëta kë nibowai mëglabë enënena bu fli wesibi mëglabë lowene hana fafa mototla. Wëye. Bu tiho galime fwa aneanebo gali mëtlekefëya na tiho gali aholokwane mëglabë mefwa tako tole lamëtlekefëya. Na iniwa tiho anebo gali, bu kë aholokwane mëglekefëyabë, bu itaita iniwa olë gëgali mëtlekefëya. ");
INSERT INTO nce_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Na kwe Pol bu kë eso enënebë kume tlibe na bume megali tlome, “Sobo Atens lifate mago enëne, bo some melowene nanëletëyo, ‘Sobo lebutako fëso wesibime lotume tako tolemu laletemo.’ ");
INSERT INTO nce_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Bo kë galime këme gali nelë. Ëbame bo sobobë lifateme asë tëbelëfë na bo sobobë li li fësobë masei, sobo këme kë lotu eglekefëtemobë, mana hwi tlagumetëyo. Na bo fësobë masei li hwi tolë. Sobo kë masei mëta meyahi latelo, ‘Lowene nëgletla jwabë goto.’ Na kwe kë goto sobo lowene jwa kë egletelobë na sobo manawa kë lotu egletelobë, bo some kë gotobë anebo gali të nëtatëyo. ");
INSERT INTO nce_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Bubë anebo gali melë lëgëbetle lalële. Buwa, ebë life blëge totle na iniwa wesibi kë mëgëbebë mata blëge blëge totome. Na ebë life mago wesibi, matafa mago wesibi ebë bubëwa mëbetle na bu iniwa wesibibë eso ho. Këme nëgeme, ho gliji mëglabë lotu lo mëta hana tafa lëgleme. ");
INSERT INTO nce_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Bu li wesibimeha hana afolo lëletle, sebo bume kë nëgaitalame. Hanane mu. Sebo hëhë kënëglabë amtëtomba, Goto buwa lëlëna. Na iniwa wesibi mata buwa lëlëkefëna. ");
INSERT INTO nce_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ëtani anebo mu, bu jowa home blëge blëge totle. Na iniwa memelë ato jibona oneho, kë ho magowa fata mëtla. Na bu kë onehome iniwa life ëlëme jine tëbelëkakëme. Na iniwa afloko mëta tafa mëtëkouja. Na bu bwa bwa tafa mëglabë olë mata aniji tlotëme. ");
INSERT INTO nce_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Goto bu melë këme tle. Oneho bu belëme migisitla namëglame. Na bume lowene sle mletlame. Këme nëgeme Goto onehome këme blëge blëge totome. Na bume iniwa wesibi tlëme, bume hohwi namëgëtatlame na bume mana hwi na loko mololame. Kwe bu seme iniwa jowa jowa home kakë hana tafa lëletëna. ");
INSERT INTO nce_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Sebo hëhë kë nëglabë, na asë kë nëglabë kalëlego, buwa lëlëkefëna.’ Kë wesibi sobobë lowene letitabo enëne fli fene yahi mëtla, ‘Sebo mata bubë nëbalemu nëtabetla.’ ");
INSERT INTO nce_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Sebo Gotobë nëbale tafa nëla. Këme nëgeme sebo Gotome melowene asa manëletla, ‘Bu fëso.’ Weye. Goto, bu silva anijina, gol anijina, anijimuna kë blëge blëge motomabë fësoha nane. Weye. Goto bu sebobë lowenenawa na tobana kë blëge blëge nogotomabë wesibiha nane. ");
INSERT INTO nce_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ëtani, oneho bu fëso fëso mëtëglana kwe kë nalë Gotome lowene hana mëtletla. Kwe Goto bume hwiwa latlome na bume li wesibiha hana totle. Kwe ebë olë Goto iniwa li life li life mago onehome anisasana megali lalëlagume, ‘Sobobë iniwa tëbo lowene aholokwana ti ekoujome na bome fwa lowene ekoutëname.’ ");
INSERT INTO nce_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Bu olë li waaniji tlole, iniwa onehobë lowene hwi lolometëmeme na abiabi lëselokwame. Na Goto ho lime waaniji tlole, onehobë lowene hwi naloglometëmeme na lëselokwame. Kë ho bu wafi gli tle na Goto bume matëmatë mago wahuju totle. Na Goto bu kë huju togotlebë seme melebotane latëtatëna, bume kë lëselokwabë wege fame waaniji tlole.” ");
INSERT INTO nce_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Bu matëmatë mago huhuju mëglabë gali yafe aholokwane motlola, fliye Polme sosonatlëtlë memototla. Kwe fliye bume gali motlola, “Sebo metole nanëletëyo, ju tokwafe kë galime seme ita gali lalowa okokwe sle eglonamene.” ");
INSERT INTO nce_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Na kwe Pol kë letitabo enëneme hune totome na tuju. ");
INSERT INTO nce_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Kwe fli ho bu Jisasme lowene sle mëtletla na bu Polna ilawa mëtebëya. Na bu mago ho li tafa tle, bubë weniji Dionisius. Kë ho bu Areopagus fatini mëta, kë loko mëglelëkefëyabë ho. Na mëse li bubë weniji Damaris, na fli oneho mata Jisasme lowene sle mëtletla. ");
INSERT INTO nce_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Tokwafe, Pol Atens lifate kile tle na Korin lifatewa tuju. ");
INSERT INTO nce_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Na bu kë mëta, Israelbë afenëbo lime esune tlële. Bubë weniji Akwila. Bu Pontus provins mago ho. Buna no Prisilana, Itali lifate tokwafe kile mëtelo na Korin lifewa mitisijo. Rom provins magobë tako eso ho, Klodius, megali tëgleme nëgeme, “Iniwa Israelbë afenëboni, Rom lifate kile mlame na li lifatewa mujame.” Na bu Rom lifate këme kile mëtelo. Na Pol kë tlemalëme hwime tujutëme. ");
INSERT INTO nce_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Kë tlemalë bu lo këna gigliji mëglabë selë blëge blëge mototokwefëmo, baliti këna glo namëgelome. Na Pol bu mata kë wege melatlekefe. Këme nëgeme Pol, buna këme tafa mëtla na buna wege mëtla. ");
INSERT INTO nce_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Na iniwa lotu olëna, Pol, Israelbë afenëbonibë lotu lowa tëkaklukëfe na buna gëgali hihijika mëtlekefëya. Bu metole latle, Israelbë afenëbonibë lowene na Israelbë afenëboni mëtabëya jwa mëglabë enënebë lowene Jisasme lowene sle mëgletlabë huju tëtakefëtëme. ");
INSERT INTO nce_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sailasna, Timotina, Masedonia life kile mëtelo na Pol belë mëtëyeu. Bu fata mëtelo na këme Pol selë susu wege kile tle na Jisasbë gali iniwa olë të tëtakefëtëme. Bu Israelbë afenëbonime anisasana megali tlokwefëme, “Goto Jisasme waaniji tlole, bubë onehome tëbo lowene mago nëno lëglebëme.” ");
INSERT INTO nce_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Kwe Israelbë afenëboni këha gali aholokwaneme tole hana mëtletla. Na bume wame motlola na tetëbo galina gali motlola. Këme nëgeme, Pol bubë ato ëho mago obo, bubë naba li mëta bubu tletëme. Na bume megali tlome, “Goto some tokwafe tëbo lëgetona, ebë sobobë wesibiwa, ebë bobë wesibi nane. Na eli bo some hune nëgëtome na Israelbë afenëboni mëtabëya jwa mëglabë enëneme fwa gali të nugutatemëme.” ");
INSERT INTO nce_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Na kwe Pol bu kë lotu lo kile totle. Na bu Titius Jastusbë lowa tuju, këme tafa nalëgleme. Kë ho Israelbë afenëboni nane, kwe bu mata Gotome lotu lëlekefëtlebë ho. Na bubë lo Israelbë afenëbonibë lotu lo lime tlibetle. ");
INSERT INTO nce_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kë lotu lobë eso hobë weniji Krispus. Buna, bubë lo mëta kë tafa tëglelëmebë onehona Tako Ho Jisasme lowene sle mëtletla. Na Korin lifate mago oneho lebutako, bu mata Jisasme lowene sle mletla. Na Pol bume iniwa baptais totome. ");
INSERT INTO nce_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Li klabë na, Pol nimitelëha wesibina wesibi li hwi tlole na Tako Ho Jisas, bume megali tlole, “Ju bobë gali tëme uli asa ele. Ju itaita gali eglokwefëmeme. Ju asa kuju ebemu. ");
INSERT INTO nce_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Bo juna nëtabome na jume nëgaitëme, na ho li jume hana tëbo lëgëtamëme. Bome kë lowene mëgletënabë oneho, ebë lifate mëta feilawa tafa mëglame nëgeme.” ");
INSERT INTO nce_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pol kë gali aholokwane tle na këme nëgeme bu Korin lifate mëta jowa tlibutu na yeme tobali ita jowa këniji tafa tle. Na bu onehome Gotobë galime okokwe tlokwefëme. ");
INSERT INTO nce_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galio, Akaia provinsbë eso home tëtabetëme. Na kë nalë, Israelbë afenëboni, blalo bu loko mëtlelëya na Polme fa mototla, na eso ho Galio belë mëtlelula, Pol kë tëbo logotlebëme gëgali namëglelëlame. ");
INSERT INTO nce_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Na bubë naba lime megali mëtla, “Kë ho, Goto Mosesme kë tëglëlebë tafa sle gali boblo mogotlabëme, onehome feilawa okokwe lolokwefëme. Na Gotome li lowenena lotu namëgletlabëme okokwe lolokwefëme.” ");
INSERT INTO nce_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pol gëgali lëgleme kofene, kwe Galio efalëbona bluju metotle na Israelbë afenëbonime gali tlome, “Sobo Israelbë afenëboni, kë ho bu wesibi tako tëbo logotlebë o sebobë, Rom life mago gavmanbë gali, boblo logotlebë kwe lalowa, bo sobobë gali aholokwane noglëyome. ");
INSERT INTO nce_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Kwe sobo bo belë tisijo, na sobo sobobë semleninobë tafa sle gali mefwa gëgali tlenëna. Bo sobobë këha gali hana sle nëgëtatëyome. Ebë sobobë wesibi wa. Sobo lalo sle ejuwetlo.” ");
INSERT INTO nce_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Na bume kë mago kë telëkakëme. ");
INSERT INTO nce_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Na Korin lifate enëne, Israelbë afenëbonibë lotu lo hwi loglokweflebë eso ho, Sostenesme, fa mototla na Galiobë naba li mëta tëkle mototla. Kwe Galio bume hwiwa latlome na kë wesibime feilawa lowene hana tlekëfe. ");
INSERT INTO nce_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pol bu Korin lifate mëta tako olë tafa tle. Na tokwafe bu Kristen onehome kaiyo tlome na bume hune totome. Na bu, Prisila, Akwilana, Senkria lifatewa iniwa mutuja. Na Pol bu kë life mëta bubë eslehuba mana le tlë, bu Gotome kakëne gali gali togloleme nëgeme. Ëtani Pol Gotome wesibi lëglebë galime wagali sle tlole. Na Israelbë afenëboni fene mëtla, bubë eslehuba le jwa tlë. Bu eslehuba le jwa mana tafa tle. Na kë tëglebë wesibime, Gotome kë gali sle toglolebë, yawe tlole. Na bubë eslehuba mana le tlë. Na Polna, Prisilana, Akwilana, Siria provinswa kë tugujubë sibu lo mëta fëfe mëtla na këna mutuja. ");
INSERT INTO nce_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Na bu Efesus lifatewa fata mutula. Na Pol Akwilana, Prisilaname kë mëta hune tle. Na Pol buwa Israelbë afenëbonibë lotu lowa sigli tëkake. Na bu Israelbë afenëbonina gëgali hihijika mëtlekefëya. ");
INSERT INTO nce_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Na bume megali motlola, “Ju sebona awi tafa nëla.” Kwe Pol bume gali tlome, “Weye. Bo sobona hana tafa nëglame.” ");
INSERT INTO nce_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Na tokwafe bume kayo tlome na gali tlome, “Goto bu tole lëgletenëna kwe bo sobelë ita nigisime.” Na bu Efesus lifate mago enëneme hune tle na sibu lo mëta fe tle. Na Efesus lifate kile tle. ");
INSERT INTO nce_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Na sibu lo bu Sisaria lifatewa fwa tule. Na Pol bu Jerusalem lifatewa tuju. Na bu kë lifate mago, Jisasme lowene sle mëtletlabë tokwëfo gëgaliwa tlelëme. Na bume hune totome na Siria provins li mago Antiok lifatewa tuju. ");
INSERT INTO nce_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pol bu Antiok lifate mëta tako tafaha tle na mana tuju. Na bu Galesia provinsbë na Frigia provinsbë li life li life tekou. Na bu Kristen onehome, Gotobë lale gali të tëtaguteme, bume lëgaitame nalëgleme. ");
INSERT INTO nce_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Israelbë afenëboni mago li, Efesus lifatewa tisi na këme tafa tle. Bu Aleksandria lifate mago ho na bubë weniji Apolos. Kë ho bu lale lowenebëme gëgali tëglekëfebë ho. Na bu Gotobë bogo mago gali lowene sle tëgletlebë ho. ");
INSERT INTO nce_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ho bume Jisasbë lale gali waokokwe motlola. Bu Jisas kë togotomebë wesibi gali, onehome okokweme tako tole latle. Na bu Jisas kë togotomebë wesibibë gali abiabi toba të slemu tëtakefëtëme. Kwe bu Jon kë baptais totomebë mefwa lowene sle latletle. Kwe, bu Jisasme lowene sle mëgletlabë onehome, baptais logotomebë lowenebëme, lowene hana tle. ");
INSERT INTO nce_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolos bu Israelbë afenëbonibë lotu lowa tujukefëtëme. Na bu gali anisasana të tëtakefëtëme. Na bu uli hana tletëme. Prisilana Akwilana bubë gali yafe aholokwane motlolo na bubë lowa mëtlelulo. Na bume Gotome lowene sle lëgletlebë lakalebëme, okokwe sle motlolo, bu lowene sle nalëgletlememu. ");
INSERT INTO nce_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolos bu Akaia provinswa lugujubëme tole latle. Na Efesus mago, Kristen oneho bume jine mëglëlabëme fleflesu lamëtletla. Këme nëgeme bu Akaia provins mago, Kristen onehome, pasë meyahi mëtëkaketëma, “Apolos sobelë fata lëkakina sobo no elëlome na ululu sle saetlo.” Na Apolos bu belë tuhu tle. Goto kë life mago Kristen onehome wafi maninibo tletëme na wafi taitame na bu Jisasme lowene sle këme mletla. Na Apolos kë life mago, Kristen onehome taitame. ");
INSERT INTO nce_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apolos bume metëgaitamelatle. Bu iniwa onehobë naba li mëta, Gotobë bogo mago gali anisasana të tëtatëme. Na bu Israelbë afenëbonibë memelë yaya gali lowene këna boblo tëtatëme. Na bume Gotobë bogo mago gali metë sle latëtatëme, “Goto Jisasme kë aniji toglolebë ho, Israelbë afenëboniname na iniwa onehoname nëno nalëglebëme.” ");
INSERT INTO nce_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolos bu Korin lifate mëta mana tafa tle na Pol fatini lufu mëta kë mëtëgëbagubë lifate elë asë tëbelëfa. Na bu Efesus lifatewa mana fwa tëkaki. Na kë lifate mëta, Kristen onehome esune tlëkakime. ");
INSERT INTO nce_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Na bume metakune tlome, “Sobo Jisasme alako kë lowene sle tëgletelobë, Gotobë Amtëtomba sobelë latisitëyone o hanane?” Na bu metafu mëtëtatla, “Weye. Sebo, ëtani meaholokwane hana tla Gotobë Amtëtomba lalëtabetle.” ");
INSERT INTO nce_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Na Pol bume takune tlome, “Sobo yalëbë gali aholokwane telone na mana baptais fa totlo.” Na bu gali metafu mëtëtatla, “Sebo Jonbë gali aholokwane toglolame nëgeme na baptais këme fa totla.” ");
INSERT INTO nce_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Na Pol gali tlome, “Ëtani, tëbo lowene aholokwana kë ti mëtëglabë onehome, Jon bume baptais totome. Na bume gali tlome, ‘Bobë nagi kë ligisibë home sobo mana lowene sle naegletelome.’ Këbë home Jon kë gali tëgletlebë bu Jisas.” ");
INSERT INTO nce_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Kë gali yafe aholokwane mëtla, na Pol bume Tako Ho Jisasbë wenijina baptais totome. ");
INSERT INTO nce_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Na Pol jowa jowa hobë eso mëta toba gogwa tokoutëme na Gotobë Amtëtomba mana tisitëme. Na bu lili anigawa galina gëgali motokouja. Na Goto bume kë tëglëmebë gali të mëtëtaguma. ");
INSERT INTO nce_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Kë onehobë tabei we ita tële kënijiha. ");
INSERT INTO nce_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Na Pol bu Israelbë afenëbonibë lotu lowa tëkaklu. Na bu Jisasbë lale gali onehome anisasana të tëtatëme. Na Goto bubë onehome eso home tafa lëgletëmebë galibëme, onehome feilawa të tëtakefëtëme. Na bu onehome taitame, këbë galibë lowene sle namëgletlame. Na bu melë kë tëglebë aona yeme. ");
INSERT INTO nce_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Kwe bu mago fli, kë galibë aholokwaneme tole hana mëtla. Na bu fli onehobë naba lime megali mëtlekefëya, “Kristen oneho kë lowene mëgletlabë wesibi bu tëbo wesibi.” Këme nëgeme, Polna, Kristen onehona, bu Israelbë afenëbonibë lotu lowa hana mëtëkaklukefëya. Iniwa olë, Pol bu Tiranusbë okokwe lo mëta, Jisasbë lale gali onehome anebo gali tlelëkefëme. ");
INSERT INTO nce_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Na bu kë mëta melë kë tëglebë, tële tlibutu. Këme nëgeme, feilawa onehomu, Esia provins mëta kë tafa mëtlabë, bu Jisasbë lale gali aholokwane mëtlekefëya. Fliye Israelbë afenëboni na fliye Israelbë afenëboni mëtabëya jwa mëglabë enëne. ");
INSERT INTO nce_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Goto, afutuku, Polme tlële. Na Pol bu kë afutukuna, memelë klelegowa wesibi blëge blëge totome. ");
INSERT INTO nce_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Këme nëgeme oneho bu lablab tëtlë tabo glo mëtla na Polbë ato mëta lëlesili mototoma. Na bu kë ëho, ato tëbona enëneme mutujuwelëma. Na kë tëbo atobë laslewa mëtletëme. Na ahwane bubë ato mago lamëtlëboukakuwa. ");
INSERT INTO nce_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Israelbë afenëboni fli, bu hobë ato mago, ahwane heheëme asë metëbelëfaya. Fliye Tako Ho Jisasbë wenijina ahwane onehobë ato mago hehë namëgletëmame fene. Bu megali lamëtlekefëya, “Pol bubë gali kë të lëtakefëtlebë, Jisasbë wenijina gali nolëyo, sobo eyeu.” ");
INSERT INTO nce_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Na Skevabë tobali ita tële bowenenino bu kë galina ahwaneme gali mëtlagukefëma. Skeva bu lotu lo mëta wege lëglebë eso ho. ");
INSERT INTO nce_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Li olëna, Skevabë bowenenino, Jisasbë wenijina ahwane yafe hehë mëtëkoutëma. Na ahwane li, bubë gali metafu latëtatëme, “Bo Jisasme kwe lowene nanëletelë na Polme mata lowene nanëletelë kwe sobo fëye enënene?” ");
INSERT INTO nce_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Na ahwane kë tëbo togotlebë ho, kë home okli tëkaketëme na tëtëkle tëta na unalëmemu tëbo totome ëhona kaka kaka metotometëme. Këme nëgeme kë lo mago ëho flatabowa mëtlëbouja, winona nohwa feli mëtlelëla. ");
INSERT INTO nce_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Israelbë afenëboni iniwa na Israelbë afenëboni mëtabëya jwa mëglabë enëne iniwa, Efesus lifate mëta kë tafa mëtlabë, wesibi Skevabë bowenenime kë fata tëgletëmebë gali aholokwane mëtla. Na bu tako uli memëtla. Na iniwa bu Tako Ho Jisasme melowene mëtletla, “Bubë weniji blawa hana fë nogotlame bu tako afutukuna weniji.” ");
INSERT INTO nce_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Na lebutako tiho Kristen oneho mitisiya. Na bubë ëtanifu iniwa tëbo wesibime onehobë naba li mëta gëgali mëtëkakëja. ");
INSERT INTO nce_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Na humëi kë lowene mëtlabë enëne, na memelë olo kë mëtlësëmabë oneho, bu tetëbo sakei gali bogo loko mëtëtagijaya. Na bu iniwa onehobë naba li mëta ahoju tako agoti mëtlelëla na kë iniwa bogo ahojuwa sisike mëtla, temu namëgleme. Ho ebë bogo balitina glo lëglebëme tole lëglena kwe bubë baliti këniji 50,000 silva baliti. ");
INSERT INTO nce_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Na këha melë kë mëtlabë, feilawa oneho bubë lowene mago lowenena melowene sle mëtletla, “Jisasbë gali, iniyafe galimufe.” Na feilawa oneho bu Jisasme këme lowene sle mëtlekefëtla. ");
INSERT INTO nce_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Kë iniwa wesibi mefata wamëtle, na Gotobë Amtëtomba Polme lowene huju tëtatle na Pol bu melowene fa totle, “Bo Jerusalem lifatewa nuguwina, Masedonia provins na Akaia provins kukuwa nuguwime. Bo kë belë afina nuwime na mana Rom lifate elë mata nuwime.” ");
INSERT INTO nce_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Na Pol, bume kë mëtaitakeflobë home afina jine tlëme Masedonia provinswa. Bubë weniji Timoti na Erastus. Na bu afina motouto. Kwe Pol, buwe, Esia provins mëta mana tafa tëtëkake. ");
INSERT INTO nce_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Na kë nalë, Efesus lifate mëta, fli oneho bu Kristen onehome, wame lamotloma. Na bu anisasana wame gali huju mëtlelëla. ");
INSERT INTO nce_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Na ho li kë wame lowene tufiji totle. Bubë weniji Demitrius. Bu wesibi, silva anijina blëge blëge totokwefëme. Buna bubë wege hona, bu mëse goto lotu lobë amtëtomba wesibi, silva anijina, blëge blëge mototokwefëma. Na bu feilawa balitimu këna glo mëtlekefëya. Kë mëse gotobë weniji Artemis. ");
INSERT INTO nce_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Na kwe, Demitrius, bubë wege honame, na tokwëtokwë fëso amtëtomba wesibi, silva anijina kë blëge blëge mototokwefëmabë honame, iniwa loko tëtamë. Na bu megali tlome, “O yabenino. Sebo melowene nëglame, ebë wege kë nëgebëye, sebo tako baliti këna fa nëtakefëya na sebo lale tafa këme fa notla. ");
INSERT INTO nce_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Sobo Polme wafi lowene eletelo, na sebo bubë gali wafi aholokwane tletla. Bu Efesus lifate mago onehome fwa nane gali lolome. Weye. Bu Esia provins mago onehome mata gali latlagume. Bu onehome anisasana megali tlagukefëme, ‘Kë fëso amtëtomba, tobana kë blëge blëge mogotomabë, bu gotomu nane na bu some hana lëgaitome.’ Oneho kë gali aholokwane mëtla kë fëso amtëtomba tole hana mëletëma. ");
INSERT INTO nce_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Polbë gali kë nëgebë, bo tutune nanëletelëfe. Sebo amtëtomba kë blëge blëge nogotomabë wege, tëbo lëgetatëname. Na oneho sebobë wege sisile mëtatëname. Na li wesibime mata, bo melowene nanelë, ‘Oneho bu Polbë gali esogo mëglelëlana kwe bu sebobë tako goto, Atemisbë lotu lowa ita hana migisiyame, bume lotu namëgletëyame. Na oneho bu Artemisme aholokwana ti mëglame na bume ita hana lotu mëgletëyame.’ Sobo walowene elo, Esia provins mago oneho tëkeji na iniwa life mago oneho mata bume lotu mëlekefetëya.” ");
INSERT INTO nce_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Oneho Demitriusbë gali aholokwane mëtla na tako enisusu memëtla na anisasana këkale mëtla, “Sebobë, Efesus lifate mago goto, Atemis, bu takomu.” ");
INSERT INTO nce_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Na kë gali Efesus life oneho belë fifiji tle na iniwa anisasana këkale mëtla. Na oneho mutuja na Masedonia provins mago tlemalë home, Polna kë asë mëtlabë home, fafa mutula. Na tlemalëme, oneho këme loko mëtlelëkefëyabë lifekuwa, hokweinawa ki motokouja. Kë tlemalë hobë weniji melë, Gaius na Aristarkus. ");
INSERT INTO nce_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Na Pol, loko kë mëtlelëyabë onehome gali nalugujelëmeme fene kwe Kristen oneho bume lëkle memototla. ");
INSERT INTO nce_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Na Esia provins mago gavmanbë wege ho fli, bu Polbë yabenino nëgeme, na bume këme lëkle gali, gali mëtelëkakla, “Yabe, ju oneho këme loko mëlelëkefëyabë lifeku elë asa eiju. Matëbe.” ");
INSERT INTO nce_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Na loko kë mëtlelëyabë onehobë lowene yaya mëtletëme na bu anisasana këkale mëtëbelëfaya. Fli hobëye, li lowene mëta këkale mëtëbelëfaya na fliye li lowene mëta këkale mëtëbelëfaya. Na feilawa oneho, bu loko kë mëtlelëyabë wayo gali lowene hana mëtletla. ");
INSERT INTO nce_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Israelbë afenëbo li bubë ku mëta tëtabetëme, bubë weniji Aleksander. Na Israelbë afenëboni fli, bume kë onehobë naba li mëta so mëtelëkakla. Fli oneho bume hwi motlola na meweniji mëtla, “Ebë ho kë nëgebë ebë kë wame nëglabë eso ho ekëwa.” Kwe Aleksander toba momale totle, oneho bu kuju namëgebëyame. Bume megali naloglomeme fene, ebë wame kë nëgebë, Israelbë afenëbonibë wesibi nane. ");
INSERT INTO nce_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Kwe oneho bume hwi sle motlola na melowene mëtletla, “Israelbë afenëbonife.” Këme nëgeme, iniwa oneho bu anisasana këkale mëtlekefëya, “Sebobë, Efesus life mago goto, Atemis, bu takomu!” Na bu kë galina, tako olë, anisasana gëgali mëtlekefëya. ");
INSERT INTO nce_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Na kë life magobë gavmanbë yahi wege fa lëgëtatlebë ho onehome këkale tlome na bume megali tlome, “Sobo, Efesus life mago oneho, aholokwane elo. Iniwa life mago oneho, seme walowene mëletëna. Mëse fësobë, Artemisbë lotu lo, sebobë lifate mëta lilibe, na sebo kë lotu lo ekë tafa nëlelëla. Na Artemisbë fëso amtëtomba, matafa mago kë tëtetibakebë, semëta ebamë na sebo tafa nëlelëya. ");
INSERT INTO nce_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Iniwa oneho kë galime melowene lamëtla, ‘Ebë nëgali galimu.’ Këme nëgeme, sobo kuju ebo, blawa asa enisusu eletemo. ");
INSERT INTO nce_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Sobo aholokwane elo. Kë tlemalë home sobo sebelë kë tëglesumobë, bu sebobë lotu lo mago wesibi tokli hana mëtelo. Na bu sebobë mëse gotome tëbo galiha, hana mëtlëyo. ");
INSERT INTO nce_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Demitriusna bubë wege enënena bu ho flime wame moglomana, kwe bu onehobë gali aholokwane loglomebë ho belë samëlesuma. Onehobë gali aholokwane moglomabë ho buwa sasle mëtatëyome. ");
INSERT INTO nce_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Na sobo fli galina nëgena, kwe sobo kë gali, ebë life mago oneho kë gëgali mëglekefëyabë olëna sasle egotomome. ");
INSERT INTO nce_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ebëha gëgali tëbo, teiyo elekëlo. Sobo hwi elo. Rom life mago gavmanbë eso enëne, bu ëje sebo kë nëglabë wesibi aholokwane mëglana, kwe bu seme onehobë gali aholokwane loglomebë ho belë mëglenuname na megali moloname, ‘Kë enëne, bu tëbo lowene huju motokweflabë enëne.’ Sebo ëje kë loko nëglelëyabëye na anisasana kë gëgali nëgëbelëfayabëye, kwe hobota fata nogotlabë mefwa gëgali nëla. Na gavmanbë eso enëne bu seme ëje kë nëglabë wesibime takune moglonana, kwe sebo habë tafu nëgëtatëmamene? Hanane.” ");
INSERT INTO nce_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Gavmanbë yahi wege fa lëgëtatlebë ho wagali tlome, na bu onehome jine tëbelëkakëme. ");
INSERT INTO nce_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kë anisasana gëgali kuju mëtebëya, na Pol bu Kristen onehome mana gali telokwakeme, bu belë loko namokweitlame. Na bu loko motokweitla na bume mana lale gali të tëtatëme na bume ululu sle mëglabë gali mana të tëtatëme. Na bume kayo gali tlome na Masedonia provinswa mana tuju. ");
INSERT INTO nce_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Bu kë provins mëta asë tëbelëfa na Kristen onehome megali tlagume, “Sobo Jisasme kë lowene egletelobë lowene asa elëkëlo, mana lowene sle saelekefëtelo.” Na bu Grik provinswa fwa tule. ");
INSERT INTO nce_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Bu Grik provins mëta aona yeme tafa tle. Na bu sibu lo mëta fe nalëgleme fene, Siria provinswa luguju nalëgleme fene. Kwe bu megali aholokwane tëgleme nëgeme, Israelbë afenëboni bume kë sibu lo mëta, mogo nalë tëke moglolame. Na bu lowene këme hihijika tle. Na bu Masedonia provins elë kë tugujubë alëge elë këme tuju. ");
INSERT INTO nce_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Fli ho bu Polna mutuja. Kë enënebë weniji melë, Pirusbë bowene Sopater, bu Beria lifate mago ho. Na Aristarkus na Sekundus, bu Tesalonaika lifate mago ho. Na Gaius, bu Derbe lifate mago ho. Na Timoti na Esia provins mago ho Tikikus na Trofimus. ");
INSERT INTO nce_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Kë enëne motoutaya na bu seme Troas life mëta hwi mëtletëna. ");
INSERT INTO nce_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Sebo Filipai life mëta mana tafa tëgelobë na Israelbë afenëbonibë tako lotu olë mana yawe tletëme. Bu kë lotu olëna, sëse wesibi jwa bletë nage hi mëtlekefëya. Na sebo mana sibu lowa fëfe telo na Filipai life kile totlo. Sebo sibu lo mëta nilina olë telo na tobali olëbëna Troas lifate mëta kë hwi mëtletënabë ho belë fwa telo. Na sebo iniwa Troas lifate mëta tobali ita tële olë këniji tafa tla. ");
INSERT INTO nce_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Sande klabëna, sebona, fli Kristen onehona, Jisasme lowene nëgletlabë hi wesibi hime loko tlelëya. Na Pol bu Gotobë gali mana të tëtatëme. Na bu Gotobë gali metë tëtatëmebëë, klabë ku tëtehulu metlelële. Bu kë olëna luguju mago nëgeme. ");
INSERT INTO nce_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Kë matawa ke lo mëta feilawa lamo u mëtëkou. Na kë lo bu akolalo. ");
INSERT INTO nce_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Na falake ho li, bubë weniji Yutikus, kë lo flelu ino mëta tafa tole. Na Polbë gali mana aholokwane tlagule. Pol bu gali metë togotlebëë, na Yutikus bu nilafale tle na këme ni tobe. Na kë mago lifewa latetetigowa. Na bu kle mëtla na fa mototowetla na yafe hwi motlola kwe bu wagli tle. ");
INSERT INTO nce_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pol mata kle tle. Na kë falake hobë ato mëta matawa towetigotle na hwë tlële. Na onehome lëkle totome, “Sobo tutune asa eletelo, bu mana hwi lëta.” ");
INSERT INTO nce_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Na bu ita lowa fëfe motokwaka. Na Jisasme lowene mëgletlabë hi wesibi hi mëtla. Na Pol ita gëgali tëglelëmebëë, olë fetina loko na mana hune totome. ");
INSERT INTO nce_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Na kë falake ho bu lalowa tafa tle. Na bume mëtlelula. Na bubë lowenebë lalowa tëbetëme. ");
INSERT INTO nce_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Na kwe sebo Polme kile totla na sebo sibu lowa fëfe tla na sebo afina Asos life elë toutaya. Na sebo Polme Asos life mëta hwi tletla. Pol bu life nagi tigisime nëgeme na bu seme Asos life elëme afina këme jine tlëna. ");
INSERT INTO nce_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Na Pol bu seme Asos life mëta esune tlëkakina. Na sebo sibu lowa tlelula. Na sibu lona Mitilini lifatewa iniwa tuja. ");
INSERT INTO nce_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Na li olë Mitilini lifate kile totla na Kios afayoliwa fwa tula. Na kë mëta jowa olë tla na sebo Kios afayo kile totla na Samos lifate elë fwa tëkakija. Na kë mëta jowa olë tla na sibu lona Samos lifate kile totla na Efesus life sigliwa totla na Miletus lifate elë fwa tëkakija. ");
INSERT INTO nce_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pol ëbame melowene latle, “Esia provins mëta feilawa olë hana tafa lëgleme.” Këme nëgeme bu Efesus life sigliwa këme mototla. Bu metole latle, Israelbë afenëbonibë tako lotu olë, Pentikos olë, Jerusalem lifate mëta, hwi nalogloleme. Na bu hokwehokweinawa këme tokou. ");
INSERT INTO nce_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Sebo Miletus lifewa fwa tla na Pol, Kristen onehobë letitabo home, Efesus life mëta kë tafa mëglabë, gali tuku tëkaketëme, bu belë migisitla namëglame. ");
INSERT INTO nce_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Na bu belë mitisitla na iniwa loko mëtlelëya. Na Pol megali tlome: “Bo ëtani Esia provins elë tisi na bo sobona tafa tula. Na bo sobona kë tafa tugulabë, bo wesibi bo melë kë totomëbë, sobo wafi lowene tletëna. ");
INSERT INTO nce_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Sobo walowene tletëna. Bo ebë wege mëta kë tafa tugulëbë tako hobota mëta tafa tulë. Israelbë afenëboni bome tëbo mëtëtakefename nëgeme. Na bo anisasana ye tlekefë. Kwe bo bome nane lowene telë, bo Jisasbë wegewa fa tëtakefëtelë. ");
INSERT INTO nce_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Iniwa gali të tëgëtatëyobëme bo some kikli hana tleteyo na li gali ha ëho hana tëtatëyo. Iniwa gali bo some lëgaitobëme të totometëyo. Oneho këme loko mëlelëkefëyabë lifeku mëta, na sobobë lo mëta, bo some okokwe tlokwefëyo. Këbëme sobo walowene eletelo. ");
INSERT INTO nce_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Bo Israelbë afenëbonibëme na Israelbë afenëboni mëtabëya jwa mëglabë enëneme mata gali anisasana të tëtakefëtemë. Bo bume megali tlomë, ‘Sobobë tëbo lowenebë aholokwana ti elome na lale lowenewa esogo elelëlome, na sebobë Tako Home, Jisasme lowene sle eletelome.’ ");
INSERT INTO nce_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Na eli, bo Gotobë Amtëtombabë tolewa esogo nëglelëtelëme na bo Jerusalem lifatewa këme nuguwime. Iniwa tëbo wesibi, bome kë mëta fata mëgletenëbëme, bo lowene hana nelë. ");
INSERT INTO nce_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Bo kwe ebëwa lowene nëletelëmu. Iniwa tako lifate, bo kë asë nëgëbelëfëbë, Gotobë Amtëtomba bome megali latlonë, tako hobota na kalabusu lo mëta gwa mëgëtobë mana hwi lëkeketë. ");
INSERT INTO nce_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Bo bobë ato uli hana nëlelëlë. Lalowa, bome melë matëtana. Bo metole nanelë, Tako Ho Jisas bome kë tëglënëbë wege, bo yawe sle noglolëme. Kë wege melë lëgëbelalële; bo iniwa onehome metë sle nanëgëtatemëme. Goto iniwa onehome maninibo tletëme. Na bu metole latle, iniwa oneho Jisasme lowene sle namëgletlame. ");
INSERT INTO nce_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Ëtani bo sobona kë tafa tëglabë, Goto bubë onehome, eso home, kë tafa lëgletëmebë gali, të tëtatëyo. Ëje kwe bo walowene nelë, ita kwe sobo bome hana hwi egloname. ");
INSERT INTO nce_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","Këme nëgeme bo some ekë gali sle nolëyo. Iniwa olë bo sobona kë tafa tlekefëyabë, bo some Gotobë iniwa gali watë tëtatëyo. Bo bubë gali tëme tëboijiwa hana telë. Këme nëgeme bo some gali nolëyo. So mago ho li tëbo liglitana, ebë bubë wesibiwa. Bobë wesibi nane. ");
INSERT INTO nce_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Sobo some ululu sle saelo. Na Jisasme kë lowene mëgletlabë onehome tafa sle elelëmome. Gotobë Amtëtomba some kë wegeme wafi aniji tlëyo. Gotobë nëba Jisas, bu gli tletëme na bubë wino wafi tuju tle. Na bu këna kë onehome wataitame, bubë oneho tafa namëgletlame. ");
INSERT INTO nce_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Sobo bume tafa sle eglelëmome. Bo melowene nanelë, ‘Tokwafe bo some hune nëgelëna, sosogëna ho sobelë migisiyame. Na bu Jisasme kë lowene mëgletlabë onehobë lowene tëbo mëgëtatëmame. ");
INSERT INTO nce_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Na tokwafe somago, fli oneho kë nëgebë, bu Gotome kë lowene mëgletlabë onehome sosogëna mëglagumame. Bubë tëbo lowenewa esogo namëglelëtëmame na bume mata esogo mëglelëmame.’ ");
INSERT INTO nce_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Këme nëgeme, sobo ululu sle këme eglekefome. Bo melë kë tëgelëbë wesibime, aholokwana asa ti elo. Aona tlibutu, bo sobona kë tafa tëglabë, klijina, klabëna, some lale galime okokwe tlokwefëyo, some lëgaito nalëgleme. Bo some kë okokwe tëglëyobë, naba tuna okokwe tlëyo. ");
INSERT INTO nce_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Eli bo some Gotobë toba elë, ekë gogwa nelë, some ululu sle nalëgëtagujome. Na bo metole nanelë, Goto some kë maninibo lëgletëyobë gali lowene naeglekefëtelome. Kë maninibo gali some lëgaitome, Gotome lowene sle naegletelobëme. Na tokwafe sobo lale tafa fa egotlome, Goto bubë iniwa onehome kë aniji toglotëmebë tafa. ");
INSERT INTO nce_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Bo ëtani sobobë wesibi hana mëmaune tlëmë. Bo ho libë balitiha o ëhoha hana mëmaune tlëmetelë. ");
INSERT INTO nce_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Sobo bome wafi hwi tlona. Bo lo këna gigliji nëglabë selë susu totokwefëmë na baliti këna fa tëtakefë. Bo bobë tafa këna taitakeflë na bobë yabe, bona kë tafa tëglabë home, mata taitakefëmë. ");
INSERT INTO nce_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Iniwa wege bo melë kë togotlëbë, some melëme olafa tëtatëyo. Iniwa wege sebo kë lowene nëgletlabë, anisasana wege nëglame, ato tëbonabë enëneme na wesibi jwa enëneme mata nanëgaitamame. Sebo, Tako Ho Jisasbë gali, salowene sle nëlekefëtla. Bu megali latle, ‘Li ho, li home, wesibi lëglëlena kwe bu tako fleflesu malële. Kwe li ho, wesibi li ho mago kë fa logotlebë kwe bu tokwëfo fleflesuwa lëgleme.’ ” ");
INSERT INTO nce_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pol kë gali wayawe tlole na bu Kristen onehobë lotu letitabo enënena, sëkefo miti tafa mëtëkouja na Gotome mana gëgali mëtlelëla. ");
INSERT INTO nce_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","38","Na bu këme tako maninibo memëtletla. Pol megali toglomeme nëgeme, “Bome ita hana hwi egloname.” Na bu Polme hohwë metlëla na ye mëtlelëla na sësle sësle mototla. Na bume sibu lowa sei mutujelëla. ");
INSERT INTO nce_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Sebo, Kristen onehobë lotu letitabo enëneme hune tla. Na sibu lo mëta fëfe tla na Kos afayowa tuja. Na li olëna Kos afayo mago Rodes afayowa tuja. Na Rodes afayo mago Patara lifatewa fwa tula. ");
INSERT INTO nce_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Na sebo sibu lo mago fëfe tëkaka Patara lifate mëta. Na sebo Fonisia provinswa kë tugujubë sibu lo hwi tujuwelëla. Na sebo kë sibu lo mëta fëfe tula na këna tuja. ");
INSERT INTO nce_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Na kwe sebo Saiprus afayo, yemane toba elë hwi telokwakla na sebo sigli tokouja. Na sebo Siria provinswa fwa tula. Na kë sibu lo Tair lifatewa tuju, wesibi hune naluguleme. ");
INSERT INTO nce_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Na sebo Tair lifate mëta sibu lo mago fëfe tëkaka. Na Kristen onehome hwime tuja. Na sebo buna tafa tëglabë, tobali ita tële olë tla. Kë nalë, Gotobë Amtëtomba, kë enëneme lowene tlëme. Na bu kë lowenebëme Polme gëgali mëtlelëla, “Ju Jerusalem lifatewa asa eiju, bu jume tëbo mëgëtome.” ");
INSERT INTO nce_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Sibu lo Tair lifate kile nalëgleme kofene na Kristen oneho bubë onena, nëbalena seme nutu helefo mëta sei mëtlëna. Na sebo kë mëta sëkefo miti tafa tla na Gotome mana gëgali tlelëla. ");
INSERT INTO nce_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Na bu seme kayo motlona na sebo bume mata kayo tloma. Na sibu lowa mana fëfe tla na bu bubë lowa ita mutuja. ");
INSERT INTO nce_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Na kwe sebo sibu lona, Tair lifate kile tla, na sebo Tolemes lifatewa fwa tula. Na sebo kë life mago, Kristen onehome, sësle totoma. Na sebo buna jowa olëwa tafa tla. ");
INSERT INTO nce_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Na li olëna sibu lo mëta fëfe tla na Tolemes lifate mago tuja. Na sebo Sisaria lifewa fwa tula na sibu lo mago fëfe tokwaka na Filipbë lowa tuja. Ebë ho kë nëgebë, bu Jisasbë lale gali të tëtakefëtëmebë ho. Na buna fli tobali ita jowa hona ëbame Jerusalem lifate mëta meaniji lamotloma, Aposel enëneme mëgaitakefëma namëglame. ");
INSERT INTO nce_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Kë ho bu ononeglë nëbale këniji nilina. Na bu home yo hana tlome. Na kë nilina ononeglë Gotobë lowene mago gali të mototokwefla. ");
INSERT INTO nce_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Sebo Sisaria lifate mëta habenuju olëwa tafa tla. Na ho li Judia provins kile tle na Sisaria lifatewa tisi. Bubë weniji Agabus. Bu Gotobë lowene mago gali të totokweflebë ho. ");
INSERT INTO nce_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Bu sebelë tisi. Na Polbë alitaba fa tëtamë na bubë tobana kijuna lalei totome. Na bu megali tle, “Gotobë Amtëtomba bome lowene watlënë. Kë lowene galibë melëgebe lalële, ‘Israelbë afenëboni, Jerusalem lifate mëta kë tafa mëglabë, ebë alitababë bolijayabë toba na kijuna melalëi mogotometlame, bobë tobana kijuna fene lalei notomë. Na bume Israelbë afenëboni mëtabëya jwa mëglabë enëneme yo molomame, bume tëbo namogotlame.’ ” ");
INSERT INTO nce_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Na kwe sebo Agabusbë gali aholokwane tlola. Na sebona, kë life mago enënena, Polme anisasana lëkle totla na gali tlola, “Ju Jerusalem lifatewa asa eiju. Matëbe.” ");
INSERT INTO nce_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Kwe Pol sebobë gali metafu latëtatëna, “Sobo bome asa maninibo eletëna na bobë lowene këna asa sisile etatëna. Sobo aholokwane elo. Bo Tako Ho Jisasbë wege fa nogotlëna, na bu bome, Jerusalem lifate mëta, kalabusu mëgëtanana, na bu bome mogo nalë tëkle mëgëtanana, kwe lalowa bome melë matëtana. Bo kë wesibi uli hana nëletemë.” ");
INSERT INTO nce_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Sebo Polme yafe gali tlola kwe sebobë gali aholokwane hana tlotëna. Kë wesibime nëgeme sebo bume feilawa gëgali hana tlelëla na bume megali tlola, “Wesibi, Tako Ho bu melë logotomebëme kwe bu melë malotome.” ");
INSERT INTO nce_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Na tokwafe li olëna, sebo wesibi sle totoma, Jerusalem lifatewa nuguja nanëglame. Na sebo Jerusalem lifatewa tuja. ");
INSERT INTO nce_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Na Kristen oneho fli, Sisaria life mago, sebona tuja. Sebona tuja na sebo Jerusalem lifatewa tuhu tula, na bu seme, Saiprus afayo mago hobë lowa sei mutujenëna. Na sebo kë lo mëta tëtebëya. Lo bolijayabë weniji Nason na bu ëtani anebomu Jisasme lowene sle tletle. ");
INSERT INTO nce_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Na Jerusalem lifate mago Kristen oneho bu seme yafe hwi motlona kwe bu tako fleflesu memëtletëna. ");
INSERT INTO nce_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Li olë na sebo Polna, Jemsme hwime tuja. Na Kristen onehobë letitabo ho, sebona loko tlelëya. ");
INSERT INTO nce_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Na Pol bume hohwë tokou na sësle tëtagume. Na iniwa wesibi Israelbë afenëboni mëtabëya jwa mëglabë enënebë li mëta kë totomebë Pol kë gali të tëtatëme. ");
INSERT INTO nce_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Kristen onehobë lotu letitabo enëne, Polbë gali aholokwane motlola na bu Gotome tako fleflesu memëtletla. Na bu Polme megali motlola, “O afa, ju walowene sle ele, Israelbë afenëboni feilawamu, bu Jisasme walowene sle mletla. Na kë enëne bu, Goto Mosesme kë tëglëlebë tafa sle gali esogo mëglelëlabëme lowene anisasana mana mehola aholokwana ti hana mla. ");
INSERT INTO nce_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Kwe kë oneho bu sogëna gali meaholokwane lamëtla, ‘Pol, bu Israelbë afenëbonime, Israelbë afenëboni mëtabëya jwa mëglabë enënebë provins mëta kë tafa mokoujabë, megali latlagukefëme, “Sobo Goto Mosesme kë tëglëlebë tafa sle gali asa esogo elelëtelo.” Na bu mata megali latle, “Sobo sobobë iko nëbalebë ato jibo asa tëtlë etometemo. Na sobo Israelbë afenëbonibë lowene asa esogo elelëmetëmo.” ’ ");
INSERT INTO nce_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Sebo walowene nëla. Ju ebelë kë tigisibë gali bu aholokwane mëglana bu jume wame mëglëyome. Sebo kë wesibi habelë nogotlamene? ");
INSERT INTO nce_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ju, sebobë gali esogo eglelëtënana, kwe lalowa. Semago ho nilimalë, Gotome Gotobë wenijina wakakëne mëtla wesibi melë mogotomabëme. ");
INSERT INTO nce_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ju kë nilimalë home nëno elëme, na Gotobë tako lotu lowa elelëkakumeme. Na sobo iniwa, Gotobë naba li mëta lale tafa egelobë lowenebë, esogo elelëlome, Goto Mosesme kë tëglëlebë tafa sle gali fene lëbe. Na sipsip kleli, ju li ho mago, balitina glo eletëmeme. Na lotu lo mëta wege mëglabë home elëmeme, bu Gotome ahojume namëgletlame. Sipsip kleli ahojumebë yawe mololame na kë nilimalë ho bu bubë eslehuba mana le melëmame. Ju melë eglena, feilawa oneho melowene namëgletëyome, ‘Kë gali jume kë gali mëtletëyobë gali, ebë sogëna gali.’ Na bu jume melowene namëgletëyome, ‘Goto Mosesme kë tëglëlebë tafa sle gali esogo eglelëlebë ho.’ ");
INSERT INTO nce_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Na Israelbë afenëboni mëtabëya jwa mëglabë enëneme, Jisasme tokwafe kë lowene mëtletlabë, sebo pasëna megali tloma, ‘Sobo kë lowene esogo eglelëlona kwe lalowa. Sobo fësome kë gogwa mëglabë hi wesibi asa hi elo. Na bu ko iniwa lugujutle slejwabë kleli asa hi elo. Na kolei mata asa hi elo. Na sobo lisei lowene asa elo.’ ” ");
INSERT INTO nce_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Li olëna, Pol kë nilimalë home nëno tle. Na buna iniwa, Gotobë naba lime lalowa tafa mëglabë lowene esogo mëglelëlame, Goto Mosesme kë tëglëlebë tafa sle gali fene lëbe. Na tokwafe bu Gotobë tako lotu lowa mëtëkakluja. Na Pol bu Gotobë tako lotu lo mëta wege mëglabë home megali tlome, “Tobali ita tële olë mugujuna, na sebo iniwa Gotobë naba li mëta lalowa tafa nëglame. Na sebo sipsip kleli bwa bwa mana nehweijame, Gotome ahojume namëgletlame.” ");
INSERT INTO nce_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Kë tobali ita tële olë yawe lëgleme kofene na Israelbë afenëboni, Esia provins mago, Polme hwi motlola, Gotobë tako lotu lo mëta tafa tle. Na bu onehobë wame lowene tufiji mëtëtatëma, na Polme mana fa mototla. ");
INSERT INTO nce_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Na bu anisasana këkale mëtla, “O Israelbë afenëboni, sobo seme aitaname esijo. Ebë ho kë nëgebë, bu li life li life mago onehobë naba lime, seme, Israelbë afenëbonime sisile latëtakefëna. Na bu iniwa onehome meokokwe latlagume, ‘Sobo Goto Mosesme kë tëglëlebë tafa sle gali asa esogo elelëtelo.’ Na bu Gotobë tako lotu lo mata sisile tëtatëna. Bu kë wesibiwa nane tle. Weye. Bu Israelbë afenëboni mëtabëya jwa mëglabë enëneme, Gotobë tako lotu lowa tlelëkakume. Na këna, ebë lale lotu lo sisile totle na kë lo, Gotobë naba li mëta tëbowa tlibetle.” ");
INSERT INTO nce_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ëtani, Polna, Efesus life mago ho, Trofimusna, Jerusalem lifate mëta asë mëtelo. Na kë enëne mana hwi motloma. Na këme nëgeme bu Polme meweniji lamëtletla, “Bu kë Israelbë afenëboni lëtabejwa lëglebë home, Gotobë lotu lowa wafi tlelëkakulewa.” ");
INSERT INTO nce_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Na feilawa oneho, Jerusalem lifate mago, kë gali aholokwane motokouja na bu hokweinawa loko motokweija. Na Polme fa mototla na Gotobë tako lotu lo mëglëbo elë ki motokouja. Na bu hokweinawa ino titiji mëtla. ");
INSERT INTO nce_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Bu Polme tëkle mototokweflabë, na Rom life mago wame home boblo mogotomabë enënebë eso ho li, meaholokwane tle, “Jerusalem lifate mago ho blalo momogli mëtagujaya.” ");
INSERT INTO nce_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Na hokweinawa, bu wame home boblo mogotomabë enëneme, bubë eso enënename nëno tle na wame këme mëtlabë oneho belë tlelume. Polme kë tëkle mototlabë oneho, kë eso hona, wame home boblo mogotomabë enënename yafe hwi motloma, na Polme tëkle hana mototla. ");
INSERT INTO nce_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Na wame home boblo mogotomabë enënebë eso ho loliwa tisi na Polme fa totle. Na bu wame home boblo mogotomabë enëneme gali tlome, “Sobo kë home tële senë tabana lei etlome.” Na bu Israelbë afenëbonime takune tlome, “Ebë ho yalëne? Na bu fëye tëbo wesibi fa totlene?” ");
INSERT INTO nce_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Na feilawa oneho li li galina feilawa gëgali mëtla. Na bu feilawa se mototla na wame home boblo mogotomabë enënebë eso ho bu gali aholokwane sle hana tlome. Këme nëgeme bu wame home boblo mogotomabë enëneme gali tlome, “Sobo Polme sebobë lowa elelulome.” ");
INSERT INTO nce_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Bu Polme mëtlelula na bubë lo mago mitigo mëta kofene mëtlebila. Na wame home boblo mogotomabë enëne, onehome mehwi lamotloma, Polme mogo nalë tëkle moglotlamefe. Këme nëgeme, Polme tëkle mogotlalime, kë mago lafeijiwa mëtlëla. ");
INSERT INTO nce_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Feilawa onehomu bume nagi esogo mëtlaguma na anisasana megali mëtlaguma, “Mogo nalë tëke elolo, mogo nalë tëke elolo.” ");
INSERT INTO nce_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Wame home boblo mogotomabë enëne, Polme bubë lowa mëglelëkakulame kofene kwe Pol bu wame home boblo mogotomabë enënebë eso home, Grik galina gali tlole, “Bo jume gali lime lalowa gali noglëmene?” Na bu klelego metletle na Polme gali tlole, “Ju Grikbë gali habëna lowene elene? ");
INSERT INTO nce_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Bo jume mewenijiwa nanelë, ‘Ju Isip life mago howa. Ëtani onehobë wame lowene kë tufiji tëtatëmebë ho, gavman enëneme wame namoglomame. Na bu, 4,000 ho, kosina wame kë lowene sle mëtëglabë home, ho jwa tabo elë tlelume.’ ” ");
INSERT INTO nce_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Na Pol bubë gali tafu tëtatle, “Bo kë ho nane. Bo Israelbë afenëbo. Bo Tarsus lifate mago ho, Silisia provins mago. Bu lale na tako lifatemu lëbetenë. Bo jume tokwëfo takune noglëme fene. Bo ebë onehome lalowa gali noglomëmene?” ");
INSERT INTO nce_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Wame home boblo mogotomabë enënebë eso ho bume gali tlole, “Lalowa.” Na Pol bu mitigo mëta tlibe na toba momale tëtatëme, oneho gëgali kuju namëgebëyame. Bu iniwa kuju mëtebëya na Pol, bume, Hibru galina mana gëgali tle. ");
INSERT INTO nce_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Na Pol bume megali tlome, “O ayani na afanino, sobo aholokwane elo. Bo some ekë gëgali sle nëlelëyo. Bo li wesibiha fa hana totlë.” ");
INSERT INTO nce_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Oneho aholokwane motlolabë, Pol Hibru galina gëgali tle na bu kujunamu këme mitlibaguja. Na Pol bume megali tlome. ");
INSERT INTO nce_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Bo kë nëgebëye, Israelbë afenëbo. Beë bome Tarsus lifate mëta fu tëtanë, Silisia provins mago lifate tokwëfo. Kwe bo ebë lifate mëta sigli telë. Na bo Gamaliel okokwe loglonëbëme towë. Na bu bome sebobë semleninome, kë gwa tëtatëmebë tafa sle galibëme okokwe slemu tlonë. Na bo Gotobë tafa sle gali anisasana esogo slemu tlelëtelëmu, sobo tei elo. ");
INSERT INTO nce_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ëbame bo Jisasme kë lowene mëgletlabë onehome tëbo latotokwefëmë. Bo bume mogo nalë tëtëkle nëtagwibëme tako tole latelë. Na kë onehome senë tabana lalei totokwefëmë na kalabusu lowa tlelukwefëmë. ");
INSERT INTO nce_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Gotobë tako lotu lo mëta wege lëglebë tako eso ho na Israelbë afenëbonibë lotu eso enëne, bome lowene lamëletëna, bo ebë fene melë kë tëgelëbëme. Na bu kë wesibibëme some gali mëglëyome. Na kë enëne bu pasë yahi mëtla na bome mëtlëna. Bo sebobë ilawa mago enëneme, Damaskus lifate mëta kë tafa mëtëglabë kë pasë tehutemë. Ebë pasë bome kë mëtlënabë, bome megali sle lamotlona, Jisasme kë lowene mëtletlabë onehome kalabusu nanotomëme fene. Bo Damaskus lifewa tuguwibë, kë pasëbë gali fene gali tla melë nanugulëme fene. Na bume Jerusalem lifatewa nëlesumëme na bu mana tëbo motomame.” ");
INSERT INTO nce_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Ita, Pol bu megali tëtëkake, “Bo tuguwibë, na kliji kuna bo Damaskus life nounou totlë. Na hokweinawa tako elulego, matafa mago, bome iniwa lahwegënëwa tëtanë. ");
INSERT INTO nce_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Na bo life mëta latitigwëwa. Na bo we lego mana aholokwane telë na megali tlonë, ‘Sol, Sol, ju bome fëyeme sisile etakefënëne?’ ");
INSERT INTO nce_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Na bo metakune tlolë, ‘Tako ho, ju yalëne?’ Na kë we lego metafu tëtatenë, ‘Bo Nasaret life mago Jisas. Ju bome sisile latakefënë.’ ");
INSERT INTO nce_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Bona kë tiglijabë enëne kë elulego hwi lamotlola. Kwe bome kë gali toglonëbë we lego aholokwane hana mëtla. ");
INSERT INTO nce_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Na bo megali tlolë, ‘Tako Ho, bo habelë nëgelëmene?’ Na Tako Ho bome megali tlonë, ‘Ju huju elëme na Damaskus lifatewa ejume. Na kë lifate mëta, iniwa wesibi ju egotomebëme, Goto jume kë tole lëgletëbë, ho li jume kë lifate mëta gali lugujuwelëme.’ ");
INSERT INTO nce_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kë elulego, tako elulego nëgeme na bobë naba këme kilego mëtletenë. Këme nëgeme, ho bona kë tugujabë bome toba fana Damaskus lifatewa mëtlenuna. ");
INSERT INTO nce_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Ho li kë lifate mëta tafa tle. Bubë weniji Ananaias. Bu Gotome fwa lotu lëgletlebë ho. Na bu Goto Mosesme kë tëglëlebë tafa sle gali esogo sle lëglelëtlebë ho. Na Israelbë afenëboni iniwa, Damaskus lifate mëta kë tafa mëglabë bu melowene lamëtletla, ‘Lale ho.’ ");
INSERT INTO nce_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Kë ho bo belë tisi na bobë lime tlibetenë. Na bome megali tlonë, ‘Afa, Sol, jubë naba tika mëgletëme.’ Bu fene gali tlonë, na bobë naba tika mëtletënë na bo bume hwi tlolë. ");
INSERT INTO nce_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Na bu gali tlonë, ‘Sebobë semleninobë Goto, melëme tole lëletë, ju bubë tole lowene na egletleme. Bu jume melëme aniji tolë, ju Gotobë lale lowenewa kë esogo lëglelëtlebë home hwi naegloleme. Na ju bubë ëfalëbo mago gali aholokwane naeglometleme. ");
INSERT INTO nce_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Na iniwa wesibi ju kë hwi toglomebë na gali ju kë aholokwane toglometlebë onehome të naegëtagutëmeme. ");
INSERT INTO nce_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Na ju fëyeme hwi elene? Mana baptais fa etole. Ju Tako Home Jisasme gali eloleme, jume lëgaita nalëgleme na jubë tëbo lowene sle nalogotometëme.’ ” ");
INSERT INTO nce_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","18","Pol ita megali tlome, “Bo Jerusalem lifatewa ita tigisina, na bo mana Gotobë tako lotu lowa tekakuli. Na bo Gotome mana gëgali tlelëkeflëbë na bo Tako Ho, Jisasme, nimitelënaha mana hwi tlolë. Bu bome megali latlonë, ‘Ju Jerusalem lifate mago hokweinawa eiju. Ju bobë gali kë lifate mëta të egotlena kwe bu hana aholokwane mëgletëyome.’ ");
INSERT INTO nce_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Na bo megali telë, ‘Tako Ho, bu kwe bome walowene mëletëna. Ëtani bo iniwa lotu lowa kë asë tëgëbelëfëbë na jume kë lowene mëgletëyobë onehome iniwa tëtëkle latëtakefë na kalabusu lowa sisike tlekefë. ");
INSERT INTO nce_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Na jubë gali të logotlebë ho Stivenme mogo nalë kë tëkle mototlabë, kwe bo këme tlibë na bo kë wesibi tako fleflesu latletelëmu. Na Stivenme anijina kë tëkle mototlabë, hobë heletanëno ëho, bo hwi tlometemë.’ ");
INSERT INTO nce_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Kwe Tako Ho bome megali tlonë, ‘Ju eiju. Bo jume, Israelbë afenëboni mëtabëya jwa mëglabë enëne belëme jine nëgelëkakëme, kakë kë tafa mugulabë oneho belëme. Ju bume egaitame naegleme.’ ” ");
INSERT INTO nce_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Israelbë afenëboni, Polbë gali aholokwane motlola. Kwe Pol, Israelbë afenëboni mëtabëya jwa mëglabë enëneme lëgaitame nalëglebëme gali tlomena, kwe bume ita tako enisusumu memëtletla. Na bubë kë gali aholokwaneme tole hana mëtletlamu na bu anisasana gali mëtla, “Mogo nalë tëke elolo! Mogo nalë tëke elolo! Këha hobë, ebë life mëta asa tafa malële! Gli malële!” ");
INSERT INTO nce_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Bu anisasana gali mëtëbebokwakabë, na bubë heletanëno ëho titika mëtla na sisike mëtebokwaka na life obona mesisike motokwaka. Bu këna melëbëme lëlekuju mëtla, bu Polbë gali tole hana mëtletlamu. ");
INSERT INTO nce_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Këme nëgeme wame home boblo mogotomabë enënebë eso ho, bubë wege home gali tlome, “Sobo Polme, sebobë lowa elelëkakulome na bume taba afona lëlafa etlome. Na kë enëne wame kë moglolabë lowene wayobëme takune elolome. Bo melowene nanëgelëme, ‘Israelbë afenëboni, bume mogo nalë tëkeme fëyeme tole mëlane?’ ” ");
INSERT INTO nce_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Këme nëgeme, bu Polme kijuna tobona lei mototometla. Na bume taba afona tëkle mogotlame kofene. Kwe Pol wame home boblo mogotomabë enënebë eso ho lime hwi tlole, lolime tlibetle. Na bume takune tlole, “Rom provins mago gavmanbë gali melë lëgëbetle lalële. Sobo Rom provins mago hobë tëbo lowene afina sahwi elotelo. Sobo Rom provins mago ho blawa lalowa tëkle egotlomene o hanane? Weye, hanane. Bowe, Rom provins mago ho, na sobo bome blawa fëyeme tëkle egëtanamene?” ");
INSERT INTO nce_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Kë eso ho, kë gali aholokwane tle, na bubë tako eso home tuju tle na gali tujuwelële, “Ju habelë egotlemene? Kë ho bu Rom lifate mago ho!” ");
INSERT INTO nce_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Na kë tako eso ho Pol belë tisi tle na takune tlole, “Ju bome gali enonë. Ebë nëgali o sogëna. Ju Rom life mago hone o hanane?” Na Pol gali tlole, “Nëgali.” ");
INSERT INTO nce_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Na kë tako eso ho megali latlole, “Bo tako baliti Rom lifate magobë gavmanme watlëlë na bo mefata wanelë, Rom life mago ho.” Kwe Pol megali latle, “Bo kwe hanane. Ayana, beëna bu Rom life mago. Këme nëgeme, bo mata Rom life mago ho.” ");
INSERT INTO nce_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Wame home boblo mogotomabë enëne, bu Polme tëkle namogotlame kofene, kwe Polbë gali meaholokwane motlolana, “Bo Rom life mago ho,” kwe bu uli memëtla na fo mëtëkaka. Na kwe tako eso ho bu mata tako uli metle. Bu wame home boblo mogotomabë enëneme megali toglomeme nëgeme, “Sobo Polme senë tabana lei etlomo.” Bubë lowene metëgëbetle latle, Rom life mago home blawa asa lalei etlo. ");
INSERT INTO nce_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Wame home boblo mogotomabë enënebë eso ho, bu metole latle, melowene sle nalëgleme, “Israelbë afenëboni, Polbë fëye tëbo lowene hwi motlotlane?” Këme nëgeme, jowafe niwa tëbe na bu Polme këna lalei mototlabë senë taba titika totometle. Na bu lotu lo mëta wege mëglabë eso ho na Israelbë afenëbonibë lotu eso enëneme, gali telokwakëme, loko namokwëtlame. Na Polme kë enëne belë tlelule. Na bubë naba lime tlibetëme. ");
INSERT INTO nce_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Na kwe, Pol Israelbë afenëbonibë lotu eso enëneme wëya tlelëme na megali tlome, “O afani, bo Gotobë naba lime kë asë nëgelëbë, bo tëbo lowene mëta hana asë nelë. Bo melowene nanelë, ‘Bo wesibi liha hana totlë.’ ” ");
INSERT INTO nce_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Pol megali tle, na Gotobë tako lotu lo mëta wege lëglebë tako eso ho, Ananaias, Polbë lime kë mitlijabë enëneme gali tlome, “Sobo ëfalëbo elë bu elo.” ");
INSERT INTO nce_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Na Pol këme gali tlole, “Goto jume mata tëke loglëme. Ju waholo lebotabo ti ha. Oneho jume matawa hwi moglëyobëye, lale klisomu, kwe lokwalëfe waholo lebotabo ti ha lëlubetë. Ju melowene lalene, ‘Ju Goto Mosesme kë tëglëlebë tafa sle gali esogo eglelëlebë ho, na kë galina bobë tafa hwi sle loglotenëme.’ Na ju kë gali fëyeme boblo etlene, na bome ëfalëbo elëme bume fëyeme gali elomene?” ");
INSERT INTO nce_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Na kë enëne Polbë lime këme tlijabë, Polme megali motlola, “Ju Gotobë tako lotu lo mëta wege lëglebë tako eso home fëyeme tëbo gali elolene?” ");
INSERT INTO nce_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Na Pol këme gali tle, “O afani, masiwafe, bo melowene hana nëletelë, kë ho bu Gotobë tako lotu lo mëta wege lëglebë tako eso ho. Gotobë bogo megali eglame nëgeme, ‘Sobo, sobobë eso home, tëbo gali asa elolo.’ ” ");
INSERT INTO nce_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pol melowene latletëme, “Israelbë afenëbonibë lotu eso enëne, fliye bu Farisi enëne na fliye Sadyusi enëne.” Këme nëgeme, bu anisasana gali tlome, “Afanino, bo kë nëgebëye, Farisi ho. Na bobë afuna, ayana, bu mata Farisi ho. Bo melowene nanelë, gigli enëne bu matëmatë mago huhuju mëglame. Na kë wesibime fwa bome so namëtatëname.” ");
INSERT INTO nce_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Pol kë galime gëgali tle, na Farisi enëne na Sadyusi enëne blalo wame mëtla na li li lowene mëta mëtëtabëya. ");
INSERT INTO nce_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Ebë wame wayobë melëgëbetle lalële. Sadyusi enëne megali lamëtlekefëya, gigli enëne matëmatë mago hana huhuju mëglame. Na ensel na alibaho hanane tafa mële. Kwe Farisi enëne bu kë wesibi iniwa lowene sle mëtletëma. ");
INSERT INTO nce_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Këme nëgeme, anisasanamu gëgali mëtla. Na Farisi enëne fli, Gotobë galime kë okokwe moglomabë ho, bu hujuna mitlija na anisasana megali mëtla, “Sebo ebë hobë tëbo lowene hana hwi nolotla. Ensel li o alibaho li bume wagali mololenawa. Bu melë lëglena, na sebo bume tëkle nogotlana kwe sebo Gotobë wege sisile nogotlame.” ");
INSERT INTO nce_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Na wame home boblo mogotomabë enënebë eso ho bu mehwi tlome, anisasana wame gali feilawa huju mëtlelëla na bu uli metletëme. Bu melowene tle, “Farisi enëne na Sadyusi enëne Polbë ato memelë ki tei mletlafe, na bubë ato bule lëgletlemefe na bu gli lëleme.” Këme nëgeme bu wame home boblo mogotomabë enëneme gali tlome, “Sobo loko kë mëglelëyabë enëne belë eyeume na Polme kë enënebë mago no ejuwelolome na elesulome na sebobë lowa elelëkakulome.” ");
INSERT INTO nce_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Bu melë kë mëglabë. Na klabë kuna Tako Ho Jisas, Polbë li mëta tlibetle. Na gali tlole, “Ju uli asa ele. Ju bobë gali, Jerusalem mëta fene të etle, Rom lifate mëta, melë, të egotleme.” ");
INSERT INTO nce_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Na kwe li olobalëna, Israelbë afenëboni fli mana loko mëtlelëya. Na gali sle mototla, Polme mogo nalë tëke namoglolame. Bu Gotobë wenijina kakëne mëtla, “Sebo Polme mogo nalë satëkle notla. Sebo mogo nalë tëkle jwa nogotlana kwe sebo hi wesibina tuna hana hi nëglame.” ");
INSERT INTO nce_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Polme mogo nalë tëkle gali kë kakëne mëtëglabë hobë tabei këniji niliafewe (40) sogë sigliwa. ");
INSERT INTO nce_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Kë ho, bu lotu lo mëta wege mëglabë eso ho belë na Israelbë afenëbonibë letitabo enëne belë mutujutëma na megali motloma, “Sebo Gotobë wenijina gali mekakëne sle wanëla, ‘Sebo Polme mogo nalë satëke noglolame. Sebo tëkle jwa nogotlana kwe sebo hi wesibina tuna hana hi nëglame.’ ");
INSERT INTO nce_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Këme nëgeme, sobona, Israelbë afenëbonibë lotu eso enënena, wame home boblo mogotomabë enënebë eso home sagali elolo. Na bume mesogëna elolome, ‘Sebo metole nanëla, ju Polme sebelë sei elëfatëna, sebo bume fli wesibime takune nanoglolame. Sebo melowene sle nanëgletlame, “Bu fëye wesibi totlene?” ’ Sobo melë egelona, kwe sebo alëgeme ekë tafa nëla. Na bu Polme sobelë sei mëglëlana, kwe sebo bume alëgeme mogo nalë tëke noglolame.” ");
INSERT INTO nce_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Kwe Polbë blola, kë gali aholokwane tle. Këme nëgeme tuju na wame home boblo mogotomabë enënebë lowa tëkaklu. Na bolumama Polme gali tlole. ");
INSERT INTO nce_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Na Pol, wame home boblo mogotomabë enënebë eso ho lime, bu belë naligistleme gali telokwakle. Na bu tisi tle na Pol megali tlole, “Ebë falake home jubë tako eso ho belë sei ejuwelële. Bume li galime gali nalogloleme.” ");
INSERT INTO nce_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Këme nëgeme, kë eso ho, kë falake home, bubë tako eso ho belë tlelule na megali tle, “Kalabusu mëta kë tafa lëglebë Pol, bome megali lalolonë, ‘Ebë falake home jubë tako eso ho belë sei ejuwelële. Bume gali lime gali nalogloleme.’ ” ");
INSERT INTO nce_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Na këme, kë tako eso ho kë falake home tobame fa totle na mëglëbo elë tlelule. Na tlemalë buwa mutujuwelibo na mana takune tlole, “Ju bome fëye galibëme gali eglonëmene?” ");
INSERT INTO nce_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Na kë falake ho megali tlole, “Israelbë afenëboni bu gali wafi sle motla, uniji jume takune nameglëyome, Polme, Israelbë afenëbonibë lotu eso enëne belë mëglelutëma namëglame. Bu jume sogëna mëglëyome na megali tlole, bu Polme fli wesibime takune namoglolame na melowene sle namëgletlame, ‘Bu fëye wesibi tlene?’ ");
INSERT INTO nce_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Kwe ju bubë gali asa aholokwane elome. Bu mago fli ho, bu këniji niliafewe sogë sigliwa, bu Gotobë wenijina gali mekakëne wamla, ‘Sebo Polme mogo nalë satëkle notla. Sebo tëkle jwa nogotlana kwe sebo hi wesibina tuna hana hi nëglame.’ Bu jume mana kë hwi meletëyo, bume megali naeglomeme, Pol bu belë maluju.” ");
INSERT INTO nce_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Na kwe, kë tako eso ho, kë falake home gali tlole, “Ju bome galime kë egisitenëbë, li home kë galibëme asa gali elole.” Na bu kë falake home jine telëkakle. ");
INSERT INTO nce_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Na kwe wame home boblo mogotomabë enënebë tako eso ho bubë tokwëtokwë eso home tlemalëme gali telëkakëme. Na bu belë mitisijo na bume gali tlome, “Sobo wame home boblo mogotomabë enëneme 200 këniji, loko etome. Na hos klelina kë asë mëglabë home 70 këniji loko etome. Na sëfana kë wame mëglabë enëneme 200 këniji loko etome. Sobo Sisaria lifewa egëyeume sagli elëlome na klabëmuwa eyeume. ");
INSERT INTO nce_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Sobo Polme hos kleli fli aniji elotelome, bu këna luguju nalëgleme. Na sobo bume eso ho Feliks belë sei sle ejuwelëlome.” ");
INSERT INTO nce_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Na wame home boblo mogotomabë enënebë tako eso ho, pasë yahi tle na bu megali latle, ");
INSERT INTO nce_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Lale olobalë eso ho Feliks, ju sebobë tako eso ho mu. Bobë weniji Klodius Lisias. Na bo ebë pasë jume ekë yahi nëletë. Na ebë pasë Polme megali latlatle. ");
INSERT INTO nce_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Israelbë afenëboni, ebë home fa mototla na mogo nalë tëkle namogotlame fene. Kwe bo gali meaholokwane telë, ‘Bu Rom provins mago ho.’ Këme nëgeme, bona, bobë wame home boblo mogotomabë enënena bume kë wame motlolabë enënebë mago no tlëla. ");
INSERT INTO nce_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Bume kë so mëtatlabë gali wayobëme bo lowene sle nanëgletelëme. Këme nëgeme, bo Israelbë afenëbonibë lotu eso enëne belë këme tlelulë. ");
INSERT INTO nce_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Bo bume kë tëbo wesibime takune tlomë. Na bubë onehobë tafa sle galime fwa anebo gali mëtlelëna. Na bu kë tafa sle galime fwa so mëtëtatla. Kwe bo bubë fëye wesibiha hwi hana tlotelë. Na sebo bume mogo nalë manawa hana tëkle nogotlame o manawa hana kalabusu nogotlame. Matëbe. ");
INSERT INTO nce_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Na ëje bo ebë gali meaholokwane nanolomë, bu bume mogo nalë tëkle mogotlabë gali wa sle mëtatla. Na këme nëgeme bo ju belë hokweinawa këme jine nelëbaklë. Na bume kë so mëtatlabë enëneme gali nolomëme, bu jubë naba li mëta gëgali sle namëglame. Bobë gali tei.” ");
INSERT INTO nce_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Na kwe, wame home boblo mogotomabë enëne, bubë eso hobë gali esogo mëtlelëtla na bu kë klabëna Polme Antipatris lifatewa sei mutujuwelëla. ");
INSERT INTO nce_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Jowa klabë tle na wame home boblo mogotomabë enëne, hos klelina kë asë mëtlekefëyabë, Polme Sisaria lifatewa sei mutujuwelëla. Na wame home boblo mogotomabë enëne fliye, Jerusalem lifatewa ita mutuja na bubë lowa fëfe motokwaka. ");
INSERT INTO nce_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Bu Sisaria lifatewa fwa mutula na eso ho Feliksme pasë mëtlëla. Na Polme mata mëtlesula na bubë naba li mëta tlibetle. ");
INSERT INTO nce_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Bu kë pasë hwi tlagwi na Polme këme metakune tlole, “Ju fëye provins mago hone?” Na Pol gali metafu tëtatle, “Bo Silisia provins mago ho.” ");
INSERT INTO nce_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Na kwe eso ho këme megali tlole, “Jume tëbo loweneme so mëtatëyobë enëne migisiyana kwe bo jubë gali aholokwane nolotëme.” Na bu këme wame home boblo mogotomabë enëneme megali tlome, “Sobo Polme, ëtanifu eso ho, Herotbë lowa elelëkakulome na sobo mana hwi sle elokweflome, lëglëboukakulime.” ");
INSERT INTO nce_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Na bu tobali olë wamutuju na Gotobë tako lotu lo mëta wege lëglebë tako eso ho, Ananaias, Sisaria lifewa mana tuju. Na Israelbë afenëbonibë letitabo enëne fli, na oneho tafa sle mëglabë gali, lowene sle lëgletlebë ho li, buna mutuja. Bubë weniji Tertulus. Na bu Polme so kë mëtëtatlabë galibëme, eso home gali motlola. ");
INSERT INTO nce_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Na kwe, eso ho Polme gali telokwakle, ligisi tle nalëgleme. Na bu tisi tle na Tertulus, Pol kë tafa tëglebë galime mana gëgali tle. Na bu megali latle, “Eso ho Feliks, ju seme lale tafame laitakefëna. Ëtani kë tafa tëglaginabë na mana ekëne fe lëkaki wame hana tokweija ebelë mana ekë fe lëkaki. Ëtani feilawa wesibi kë tëbo mëtletënabë, jubë lale lowenena sle tëtagimetëna. Ju seme feilawa wesibime taitagina. ");
INSERT INTO nce_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Sebo kë wesibi hwi tlagima na sebo maninibona sle tla. Na sebo jume tako fleflesu latokweitëyo na megali tokweija, ‘Yahala fëyemene.’ ");
INSERT INTO nce_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Kwe bo jume gëgalina kiki hana nëgëtëme. Ju seme maninibo naegletëname fwa takune nolë na ju sebobë tokwëfo gali aholokwaneme aholo bo naegëtatëname.” ");
INSERT INTO nce_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Na bu Polbë galime megali tletle, “Sebo ebë home mehwi nanolola, bu memelë tëbo lowene mëta tafa lëglebë ho. Bu iniwa lifate mëta, Israelbë afenëbonibë wame lowene tufiji tëtagutëme. Na bu Nasaret lifate mago Jisasbë lowene esogo mëglelëtlabë onehobë eso ho. Kë enëne bu lale enëne nane. ");
INSERT INTO nce_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","8","Bu melëbëme fene su tle. Gotobë tako lotu lo, tetëbo lowenena tëbo nalogotleme fene na kë lo, Gotobë naba lime tëbowa lilibetleme. Kwe sebo bume mana kë fa totla. Këme nëgeme, bu kë tafa lëglebë galime, sebo kë gali nëglëyobë, ju sa takune elole. Ju bubë ëfalëbo mago gali lowene sle naegletleme.” ");
INSERT INTO nce_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Israelbë afenëboni bu këbë loweneme, Tertulusme mëtaitala na bu këme megali mëtla, “Ebë gali kë nëgebë, nëgali galimu.” ");
INSERT INTO nce_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Na kwe, eso ho Feliks, Polme esuwalëwa tlole, gëgali nalëgleme. Na Pol këme megali tle, “Bo jume walowene sle nëletë. Ju ebë life mago onehobë gali aholokwane eglomebëme, ëtani anebomu tëtabetëme na mana ekëne etabe. Këme nëgeme bo jume fleflesu këme nëletë, ju bobë gali aholokwane sle eglonëme. ");
INSERT INTO nce_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ju tëtakune ekouna, kwe ju mehwi sle egloleme, we ita tële olë wamutuju, bo Jerusalem lifatewa lotume këtuguwibë. ");
INSERT INTO nce_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Na Israelbë afenëboni bome mehwi hana motlona, bo ho lina Gotobë tako lotu lo mëta wame gali nëlelëgome. Weye. Bo Israelbë afenëbonibë iniwa lotu lo mëta o iniwa lifeku mëta, fli hobë wame lowene tufiji hana tëtatemë. Weye. ");
INSERT INTO nce_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ebë gali bu bome kë so mëtatënabë, nëgali gali nane. Weye. Bome kë so mëtatënabë gali eso olafa sle hana mëtatëyo. ");
INSERT INTO nce_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Kwe bo some megali sle nëlëyo. Bo kwe ëtani sebobë semleni kë lotu mëtletlabë Gotome fwa mana lotu nëletelë na bo Tako Ho Jisasbë lakale mata esogo nëlelëtelë. Israelbë afenëboni mefë lamototla, ‘Tako Ho, Jisasme esogo mëglelëlabë, tëbo lakale.’ Kwe bo melowene nanelë, Goto Mosesme kë tëglëlebë tafa sle gali iniwa bu nëgali gali mu. Na iniwa gali, Gotobë lowene mago gali të mototokweflabë ho kë yahi mëtëglabë, kë mata nëgali gali mu. ");
INSERT INTO nce_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Na bo Gotome melowene nanëletelë. Tokwafe li olëna iniwa gigli enëneme matëmatë mago huhuju logotomeme. Lale lowenena gigli mëtlabë enëne na tëbo lowenena gigli mëtlabë enëne bume iniwa huhuju logotomeme. Bona, ebë enëne kë tafa mëglabë, jowa lowenewa nehola. ");
INSERT INTO nce_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Këme nëgeme bo kë nëgeholëbë gali esogo sle nëglelëlëbëme feilawa afutuku këme nelë. Na bo Gotobë naba lime na onehobë naba lime tafa sle nanëgletemëme. ");
INSERT INTO nce_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Bo Jerusalem lifate kile totlë. Na bo li life mëta kë tafa tugulëbë, feilawa tlibutu tafa tulë. Na tokwafe, bo Jerusalem lifatewa ita tisi. Na baliti jwa kë tafa mëtlabë yabe enëneme, nëgaitamëbëme baliti tehweitemë. Na bo sipsip kleli Gotome ahojume nanëgletelëmeha tisi. ");
INSERT INTO nce_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Bo Gotobë tako lotu lowa nuguwime tole latelë, këme nëgeme, bo Gotobë naba lime lale tafa nëgelëbë lowene afina sle totlë na bo mana tako lotu lowa tëkakuli. Na oneho bome Gotobë tako lotu lo mëta hwi motlonabë, bo Gotobë naba lime lalowa tëtabë. Bo feilawa enënena hana tafa tla. Na sebo fëyeha hana totoma. Na fli enëneha hana flikale motlona. ");
INSERT INTO nce_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Kwe Esia provins mago Israelbë afenëboni mitisiya na bome blawa wame motlona. Bome kë so mëtëtatënabë enëne jubë naba lime bo kë tëbo togotlëbë wesibime bu gëgali mëkakijame. Kë enëne bu migisiya jwa fëyeme mëlane kë galime gëgali namëglame? ");
INSERT INTO nce_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Bo melowene nanelë, bu gëgali hanane. Kwe ebë iniwa enëne, bo Israelbë afenëbonibë lotu eso enënebë naba lime kë tiglibëbë, bu bobë tëbo wesibi o tëbo lowene wafi hwi motlotënabë kwe bo metole nanëletemë bu jume kë tëbo lowenebëme sagëgali mëglelëyome. Bu jume lalowa gëgali mëglelëyomene o hanane. ");
INSERT INTO nce_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Kwe bo melowene nanelë, bo tokwëfo wesibi kë tëgelëbë, këme fwa wame molona. Kë wesibi melë, bo bubë gali aholokwane moglomabë hobë lime kë tiglibëbë, bo megali latelë, ‘Bo Gotome melowene sle nanëletelë, lebo enëneme, matëmatë mago huhuju logotomeme.’ Kë wesibime fwamu bome sobobë naba li elëme këme mëlesuna.” ");
INSERT INTO nce_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliks, Tako Ho Jisasbë lakale kë esogo mëglelëlabë onehobë lowene walowene sle tletëme. Pol gëgali tëglebë yawe tlole na Feliks mana megali tlome, “Sobobë gali eme fwa tou lëgletëyome. Tokwafe wame home boblo mogotomabë enënebë eso ho, Lisias, ebelë ligisina, kwe bo sobobë gali sasle nëgetatëyome.” ");
INSERT INTO nce_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Na bu wame home boblo mogotomabë enënebë eso ho li, megali tlole, “Ju Polme sahwi elokwefle jubë lokwalëfe mëta fwa tafa lëleme. Kwe bume naba feilawa asa ahwatle. Weye. Bubë yabeni bume wesibina mëgaitalabëme asa lëkle etome kwe bu matisitla.” ");
INSERT INTO nce_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Fli olë wamutuju. Na Feliks, bubë no Drusilana mitisijo. Drusila kë nëgebëye, Israelbë afenëboni mago mëse. Na Feliks, Polme gali telokwakle, bu belëme ligisi tle nalëgleme. Na Pol tisi tle na buna gëgali mëtelo. Na bu Polbë gali aholokwane tlagule. Na Pol, Jisas Klaisme lowene slebë lowenebëme mana okokwe sle tlole. ");
INSERT INTO nce_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Na Pol, oneho lale lowene esogo mëglelëlabëme gëgali tle. Na oneho bubë asë ululu sle mogotlabëme gëgali tle. Na tokwafe Gotobë naba li meta onehome gali aholokwane loglomebë na onehome fu fu logotomebë olë mata gëgali tle. Feliks kë gali yafe aholokwane tlole na bu tako tutune metle na megali tle, “Ju ejumo. Tokwafe bo tole nëgelëna mana sagali nëgelëkakëme, bo belë ita egisi naegleme.” ");
INSERT INTO nce_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Feliks Polme metole fene latletle, Pol bume baliti lëlële nawa, na bu bume kalabusu lo mago jine lelëkakleme. Këme nëgeme, itaita këme gali telokwakëkefle, bu belë gëgalime ligisikefëtle nalëgleme. ");
INSERT INTO nce_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Bu melë kë tëglebë tële tlibutu latle na mana Porsius Festus, Feliksme hihijika tle na eso home tafa tle. Kwe Feliks bu metole latle, Israelbë afenëboni bume fleflesu namëgletlame. Këme nëgeme Polme kalabusu lo mëta fwa këme kile tle. ");
INSERT INTO nce_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festus, Sisaria lifatewa tisi na Judia provins mago enëneme eso home tëtabetëme. Na bu kë mëta aowafe ni tëbe. Na bu Sisaria lifate kile tle na Jerusalem lifatewa tuju. ");
INSERT INTO nce_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Na Israelbë afenëbonibë lotu lo mëta wege mëglabë eso ho na bubë letitabo enëne, Festus belë mutujutla. Na Pol tëbo lowene mëta kë tafa tëglebë gëgalibëme gëgali mëtlelëla. Na bume këme anisasana megali motlola, ");
INSERT INTO nce_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","“Ju seme lalowa aitanamene? Sebo metole nanëla. Ju Polme Jerusalem lifatewa jine elëbakleme.” Bu kë galina këme gali motlola, fli home alëgeme ëhome gali motlomame nëgeme, na Polme mogo nalë tëkle namogotlame. ");
INSERT INTO nce_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Na Festus bubë gali metafu tëtatëme, “Pol, Sisaria lifate mago kalabusu lo mëta mana tafa lëleo. Bo sogë tafawa nanelë, na bo Sisaria lifewa nuguwi nanëgelëme. ");
INSERT INTO nce_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Këme nëgeme, sobobë eso enëneme jine elëmo, bona nuguja nanëglame. Na kë ho, tëbo lowenena tafa lëglena, kwe lalowa bu bobë naba lime bubë tëbo lowene lalowa gëgali mëgletlame.” ");
INSERT INTO nce_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festus Jerusalem lifate mëta tobali ita aona olë o welujuwa olë tafa tle, na bu Sisaria lifatewa ita tuju. Jowa klabëwa ni tëbe na kë olobalëna hobë gali këme aholokwane mëglekefëtëmabë lo mëta tafa tle. Na Festus, Polme mëglesutla namëglame gali tlome. ");
INSERT INTO nce_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Bu Polme sei mëtelëfatla. Na Israelbë afenëboni, Jerusalem lifate mago kë mitisiyabë bume loko mëtlelëtla na bume gali blawa soso mëtëtatla. Na Pol bu tetëbo lowenebë mëta kë tafa tëglebëme gëgali mëtletla. Kwe Festus bubë galime melowene hana tletëme, “Bubë gali nëgali galimu.” Bu meolafa hana mëtëtatla, bubë gali nëgali gali. ");
INSERT INTO nce_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Bu gali blawa wafi soso mëtëtatla na Pol bubë gali mana metafu tëtatëme, “Bo fëye wesibiha hana totlë. Bo Israelbë afenëbonibë tafa sle gali boblo hana tëtatemë. Na bo Gotobë tako lotu lo, tëbo lowenena tëbo hana tëtatemë. Na bo Rom lifate mago gavmanbë eso home tëbo hana totlë.” ");
INSERT INTO nce_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Kwe Festus melëme tole tle, Israelbë afenëboni bume fleflesu namëgletlame. Këme nëgeme, Polme këme takune tlole, “Ju metole lalene? Jerusalem lifatewa ejume na bo kë mëta bubë gali aholokwane nolomëme.” ");
INSERT INTO nce_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Kwe Pol megali tle, “Hanane mu. Bo kë mëta kë tafa nëgelëbë lo, bu Rom lifate mago eso ho, Sisarbë lo, onehobë gali këme aholokwane mëglekefëyabë lo. Bome blawa kë so mëtatënabë gali, eme fwa aholokwane eglomeme. Ju bome walowene eletenë, bo Israelbë afenëbonime fëye wesibiha hana totometemë. ");
INSERT INTO nce_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Bo li wesibiha tëbo nogotlëbë, kwe lalowa bo gli manelë. Bu bome li fëye tëbo wesibiha hwi moglotënana, na megali moloname, ‘Ju ebë tëbo wesibi mëta gli egleme,’ kwe lalowa bo kë mëta gli manelë. Kwe bome kë so mëtëtatënabë gali, sogëna nëgebë, ho bubë toba elë hana gwa mëgëtaname. Bo metole nanelë, Rom lifate magobë tako eso ho, Sisar, bome blawa kë so mëtëtatënabë gali, buwa saaholokwane lëgleme.” ");
INSERT INTO nce_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Na kwe Festus, bume lale lowene kë mëglëkeflabë enënena blalo gëgali mëtla na Polme megali tlole, “Ju megali waele, ‘Eso ho Sisar, jume blawa kë so mëgëtatëyobë gali bu saaholokwane lëgletëme,’ kwe ju eso ho Sisar belë egujume.” ");
INSERT INTO nce_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Habenuju afe niwa tëbe. Na eso ho Agripana, bomulu Bernaisina, Sisaria lifatewa mitisijo, Festusme hwi namoglolome. ");
INSERT INTO nce_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Na kë tlemalë tako tafaha mëtelo. Na Festus eso ho Agripame Polbë galime mana megëgali tlelële, “Ëbame, Feliks li home kalabusu lowa kë tuku tëglebë, bu kalabusu lo mëta mana tafa lële. Bubë weniji Pol. ");
INSERT INTO nce_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Bo Jerusalem lifate mëta tafa tëgelëna, Israelbë afenëbonibë letitabo enëne na lotu lo mëta wege mëglabë eso ho, gali bume so mëtëtatla. Bu metole lamëtla, bo megali nanoglomëme fene, ‘Bu wafi tëbo tlitawa, na wame home boblo mogotomabë enëne, bume mogo nalë tëke namoglolame.’ ");
INSERT INTO nce_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Kwe bo bubë gali metafu latëtatemë, ‘Sebo Rom provins mago enëne, sebobë lowene melë lëgëbelalële, bume kë so mëtatlabë enënebë toba elë blawa hana gwa nëgëtatëmame. Fli ho bu li home so mëtatlana, kwe bubë gali tafu mëgëtatlabëme aholo bo sle samëtagutla. Bubë so gali afina tafu lëtatëmeme na tokwafe onehobë gali aholokwane lëgletëmebë ho, bubë gali hwi sle lolotëmeme.’ ");
INSERT INTO nce_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Këme nëgeme kë enëne ebë lifatewa, bona tisiya. Na bo haha tafu hana totlë. Bo jowa klabëwa ni tebë na bo hobë gali këme aholokwane mëglekefëyabë lowa mana tuwi. Na bo wame boblo enëneme gali tlomë, ‘Kë home elesulo.’ ");
INSERT INTO nce_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Na bobë naba lime, bume kë so mëtëtatlabë enëne, bu mitlija na mana gëgali motokouja. Bo melowene latelë, ‘Bu tëbo wesibi kë togotlebëme gëgali mëgletlamewa. Kwe bu këbëme hana gëgali mëtla. Weye.’ ");
INSERT INTO nce_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Buna, bubë lotu lowenebëme anisasana momata mëtlelogwaya. Na bu li ho kë gli tëglebëme anisasana momata mëtlelogwaya. Kë hobë weniji Jisas. Kwe Pol këme megali tle, kë ho kë gli tëglebë mana hwi lëta. ");
INSERT INTO nce_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Bo ebë gali sle nogotlëbëme lowene hohwi nanëtatelëmu. Kwe bobë lowene yaya lalëletenë. Këme nëgeme, bo Polme metakune tlolë, ‘Ju metole lalene? Jerusalem lifatewa ejume na bo kë mëta jubë gali aholokwane nolëme.’ ");
INSERT INTO nce_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Kwe Pol megali tle, ‘Bo kwe kalabusu lo mëta tafa manelë. Tokwafe, Rom lifate magobë tako eso ho, Sisar, bome blawa kë so mëgëtatënabë gali saaholokwane lëgletenëme.’ Këme nëgeme bo megali telë, ‘Bu kalabusu lo mëta tafa lëglekëfebëë, na bo mana Rom lifate mago eso ho belë jine nelëkaklëme.’ ” ");
INSERT INTO nce_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Eso ho Agripa kë gali aholokwane tle na Festusme megali tlole, “Bo ebë hobë gali aholokwaneme tole nanëletelë.” Na Festus këme gali tlole, “Uniji saaholokwane egloleme.” ");
INSERT INTO nce_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Na li olëna, Agripana Bernaisina bu lale negli wesibina negli mototlo na bu mana mitisijo. Na kë tlemalë, wame home boblo mogotomabë enënebë eso hona, Sisaria lifate mago letitabo hona, oneho këme loko mëtlelëkefëyabë lowa iniwa mëtëkakluja. Na Festus bu wame home boblo mogotomabë enëneme jine telëkakëme, Polme bu belë mëglesula namëglame. Na bu Polme bu belë mëtlesula. ");
INSERT INTO nce_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Na Festus këme megali tle, “Eso ho Agripa, na sobo iniwa oneho, sebona kë tafa nëglabë, sobo ebë home hwi elolo. Israelbë afenëboni iniwa, Jerusalem lifate mago na ebë lifate mago, ebë home gali so mëtëtatla. Bu bome anisasana megali lamotlona, ‘Mogo nalë tëkle etole mana tafa lëglelime.’ ");
INSERT INTO nce_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Kwe bo ebë hobë, li fëye wesibiha, hwi hana nolotelë. Na bo megali hana nëgelëme, ‘Gli malële.’ Bu metole lalële, eso ho Sisar bume blawa kë so mëtatlabë gali buwa saaholokwane loglomeme. Këme nëgeme bo gali wasle totlë, Polme eso ho Sisar belë jine nëgelëkaklëbëme. ");
INSERT INTO nce_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Bo eso home Sisarme ebë hobë tëbo lowenebëme pasë yahi nëkaketelëme fene. Kwe bo bubë li wesibiha hwi hana tlotelë, bo so kë mëtëtatlabë gali wayo lowene hana nëletelë. Na bo pasë mëta sebobë eso home fëye so gali wayobë yahi nëgletelëmene? Këme nëgeme, eso ho Agripa, bo ebë home jubë naba li elë këme nëlesutë, na fli enënebë naba li elë mata këme nëlesulë, bubë gali aholokwane sle naeglolome. Bo kë so galibë wayo lowene sle nëletelëme na bo pasë mana yahi nëkaketelëme. ");
INSERT INTO nce_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Bo kalabusu lo mago ho li, eso ho belë jine nëglëlëna, na bubë so galibë wayo hana yahi nëgletelëna, kwe bo melowene nanelë, ‘Këha lale lowene nane.’ ” ");
INSERT INTO nce_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Na Agripa Polme gali tlole, “Jubë gëgalime mana gëgali ele.” Na Pol tobana lëkle totome, oneho gëgali kuju namëgebëyame. Na bu megali tle, ");
INSERT INTO nce_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“O eso ho Agripa, Israelbë afenëboni, bome blawa kë so mëtëtatënabë gali jume të nëgëtatëme. Na bobë gali jubë naba li mëta gëgali nëgelëbëme tako tole nanelë. ");
INSERT INTO nce_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ju sebobë, Israelbë afenëbonibë iniwa lowenebë wafi lowene sle eletëna. Na kofe kofe gali kë gëgali nëglelogwayabë, kë wesibime mata ju wafi lowene eletëna. Këme nëgeme bo metole nanelë, ju alabujuwa tafa eleme. Na iniwa galime aholo mana bo sle etagwime. ");
INSERT INTO nce_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Israelbë afenëboni iniwa, bobë lakalebëme wafi lowene sle mëletëna. Bo tokwëfome bobë lifate mëta kë tafa tokweibë na ita Jerusalem lifate mëta kë tafa tokweibë, bu bobë lakalebëme wafi lowene mëletëna. ");
INSERT INTO nce_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Na bu tole mëglana kwe bu bobë lakalebëme jume lalowa gëgali mëglelëyome. Bu bome melowene lamëletëna, ‘Bo falakeme nëgena, bo Farisi ho li tëtabë. Na bo Farisibë lowenewa anisasana esogomu tlelëtemë.’ Farisi enëne Mosesbë tafa sle anebo gali iniwa anisasana esogo mëtlelëla. ");
INSERT INTO nce_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Bo ëje ekë nilibë. Na bu bome sobobë naba li elë mëlesuna bobë lakaleme some gëgali namëglelëyome. Na kë gëgali wayobë, melëgebe lalële; bo melowene nanelë, ëtani Goto bobë semlenime megali sle latlome, bu gigli enëneme huhuju logotomeme. Na bo kë wesibi melowene sle nëgletelëme na bo këme hwi nëkaketelë. ");
INSERT INTO nce_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Sebobë semle, Israelbë we ita tële nëbalebë afenëboni, bu klabëna olëna Gotome fwa lotu mëtlekefëtla. Na bu melowene sle këme mëtletla, ‘Goto gigli enëneme huhuju logotomeme na bu kë wesibi hwi mëtëkaketla.’ Eso ho, kë wesibime fwa Israelbë afenëboni, bome sobelë këme mëtlesuna. ");
INSERT INTO nce_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Sobo fli emëta kë eglibobë enëne, melowene fëyeme elone, ‘Goto gigli kë mëtlabë enëneme hana huhuju logotomeme.’ ");
INSERT INTO nce_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Ëtani bo melowene latelë, Nasaret lifate mago Jisasme, kë lowene sle mëgletlabë onehome sisile manotomë. ");
INSERT INTO nce_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Na bo kë wesibi Jerusalem lifate mëta melë totlë. Lotu lo mëta wege mëglabë eso ho, bome iniwa afutuku mëtlëna kë wesibi togotlëbëme. Na bo kë iniwa afutukuna Jisasme lowene sle kë mëtletlabë onehome feilawa sisile totomë na kalabusu lowa tlelukefëmë. Na eso enëne bu giglime gali mëtlana kwe bo mata helawawa latelë, gigli matla. ");
INSERT INTO nce_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Feilawa olë bo melatlekefë, Israelbë afenëbonibë lotu lowa nëkakuliwa nëgelëbë, na Jisasme kë lowene mëgletlabë onehome fafa nëkouwi na sebo mana tëtëkle nelutaya. Bo melëme tëbo fene totomë, bu Jisasme klëë gali namoglolame na bume kë lowene mëtletlabë lowenebë mëlëkëla namëglame. Bo ebëha wesibi Jerusalem lifate mëta fwa nane telë. Weye. Bo bume tako enisusumu metletemë, na bo kakë lifate enëneme mata melatëtagumë.” ");
INSERT INTO nce_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Pol megali tle, “Lotu lo mëta wege mëglabë eso ho, bome metole lamëtletëna, Kristen onehome tëtëkle nanëgëtagwime. Na bome Damaskus lifewa kë esome fwa jine mëtelëkakëna. ");
INSERT INTO nce_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","O eso ho, bo Damaskus lifewa tuguwibëë, kliji kume tlibe. Na bona kë tugujabë hona tako elulego hwi tlola, matafa mago tisitëna. Kë elulego kë nëgebë bu klijiha nane. Weye. Bu tako elulegomu. Kë elulego, bona kë tugujabë enëne name iniwa lahwegënëwa tëtana. ");
INSERT INTO nce_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Sebo iniwa latitiwagujawa. Na bo li hobë gali aholokwane tlolë, Hibru galina megali latlonë, ‘Sol, Sol, ju bome fëyeme sisile etakefënëne? Ju bome tëbo egëtakefënëna kwe, ju jume tëbo elitamë.’ ");
INSERT INTO nce_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Na bo metakune tlolë, ‘Tako ho, ju yalëne?’ Na Tako Ho bu këme tafu tëtatenë, ‘Ju kë sisile egëtakefënëbë Jisas. ");
INSERT INTO nce_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Kwe ju huju ele. Bo jume ebë olëna këme nisitë, jume aniji nanoglëme, bobë wege fa naegëtatenëme. Ju wesibi nabana ëje kë hwi eglomebë, kë galibëme onehome sagali elëwagume. Na ita fli wesibi bo jume tokwafe olafa nogotometëme, kë wesibi galime, onehome mata gali elomeme. ");
INSERT INTO nce_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Bo jume nëgaitëme. Na jubë ilawa mago enëne na Israelbë afenëboni mëtabëya jwa mëglabë enëne jume tëbo hana mëgëtome. Hanane. Bo jume Israelbë afenëboni mëtabëya jwa mëglabë enëne belë jine nëgelëkakëme, ");
INSERT INTO nce_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","bubë lowene sle naegëtagutëmeme. Na bu tlukufini kile namokoujame na elulego tabome natafa mokoujame. Na bu Satanbë tëbo lowene kile mokoujame na Gotobë lale lowenewa mehwagulame. Na bu bome lowene sle mokoutëname na Goto bubë iniwa tëbo lowenebë aholokwana ti nalëkoutëmeme. Na bu bobë oneho tafa namokoutëname.’ Tako Ho Jisas bome kë gali tlenë.” ");
INSERT INTO nce_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Pol eso ho Agripame gali tlole, “Eso ho Agripa, bo nimitelëha wesibina heven lifate mago kë hwi toglolëbe, boblo hana totlë. Hanane mu. ");
INSERT INTO nce_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Bo Damaskus lifate mago onehome afina gali të tutatemë. Na ita Jerusalem lifate mago onehome, na Judia provins mago onehome, na Israelbë afenëboni mëtabëya jwa mëglabë enëneme mata të tëtagutemë. Bo gali metë latëtagutemë, ‘Sobo sobobë tëbo lowenebë kile elome na Gotome fwa lowene eletelome. Sobobë lakale melebotane saetlo, sobobë tëbo lowene iniwa kile tëkoujo na sobo Gotome wafi lowene ekoutelo.’ ");
INSERT INTO nce_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Bo ebëha gali onehome të tëtagukefëtemëme nëgeme na Israelbë afenëboni bome kë wesibime fwa Gotobë tako lotu lo mëta këme fa mëtelutana. Na bome mogo nalë tëkle namëgëtaname fene. ");
INSERT INTO nce_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Kwe Goto bome feilawa lataitanë. Goto bome tëgaitawaginëbëë na ëje mana ekë laitakefënë. Këme nëgeme ëje bo ekë nilibë. Na bo iniwa enëneme, atwati enënena eso enënename, Jisasbë gali ekë të nëtatemë. Na bo li gali hana të nëtatemë. Mosesna, Gotobë lowene mago gali të mototokweflabë ho fene yahi mëtla, bo kë galiwa të notokweflë. ");
INSERT INTO nce_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ëtani bu meyahi lamëtla, ‘Goto kë aniji toglolebë ho, bubë onehome nëno lëleme, bu tako elili fa logotleme na gli lëleme. Na lebo enëne matëmatë mago huhuju mëglabëme bu afina logoutatëmeme. Na bu Gotobë lale gali, olë fenene, Israelbë afenëbonime na Israelbë afenëboni mëtabëya jwa mëglabë enëneme mata të lëgëtatëmeme.’ ” ");
INSERT INTO nce_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pol kë gali të tëtagulebëë, na Festus anisasana mekëkale tlole, “Pol ju yaya lale. Ju tako lowene fa egotleme nëgeme. Na kë lowenebë jume yaya këme lëta.” ");
INSERT INTO nce_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Na Pol gali tle, “Eso ho Festus, bo yaya nane nelë. Weye. Bobë iniwa gali nëgali galimu. Ebë yaya gali nane. ");
INSERT INTO nce_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Na iniwa gali bo kë të nogotlëbë, eso ho Agripa lowene lalëletëme. Këme nëgeme, bo bume kë gali të nëgëtatelëbëme uli hana nelë. Bo walowene nëletelë, Jisas iniwa wesibi kë totomebë, bu li mumu hana lëbetle. Iniwa wesibi Jisas kë totomebë bubë naba lime ëho hana lëgleme nëgeme na bu lowene sle këme lëletle.” ");
INSERT INTO nce_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Na Pol, eso ho Agripame gali tlole, “Eso ho, Agripa, ju Gotobë lowene mago gali të mototokweflabë hobë gali lowene sle laletlene o hanane? Bo walowene nelë, ju wafi lowene sle eletle.” ");
INSERT INTO nce_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Eso ho Agripa Polme këme metakune tlole, “Ebë tokwëfo olëna ju gali kë të etatenëbë, ju melowene laletenëne, ‘Bo Jisasme lowene sle nanëgletelëmene?’ ” ");
INSERT INTO nce_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Na Pol bubë gali metafu tëtatle, “Bo Jisasbë gali tokwëfo olëna të nogotlëna o tako olëna të nogotlëna, bo Gotome megëgali nanëlelëlë, ju na fli enënena kë tafa egelobë, sobo iniwa Jisasme lowene sle eletelo, bo fene lowene sle nëletelë. Kwe bome senë tabana fene lei mëtëtana some këha lei mëgëtobëme bo tole hana nëletëyo.” ");
INSERT INTO nce_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Na kwe eso ho Agripa na Bernaisi na eso ho Festus na buna kë tafa mëtlabë enëne huhuju mëtëkouja, ");
INSERT INTO nce_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","na kë lo mago totoho mëtëkaka. Na bu blalo megëgali mëtla, “Kë hobë, li fëye wesibiha, hwi hana nolotla na sebo megali hana nëglame, ‘Bume lalowa, mogo nalë tëkle etlo o kalabusu malële. Weye.’ ” ");
INSERT INTO nce_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Na Agripa, Festusme megali tlole, “Sebo bume kalabusu lo mago jine nëgelëkakëlame fene kwe bu megali tëgleme nëgeme, ‘Rom lifate magobë eso ho, Sisar, bome blawa kë so mëtatënabë gali bu saaholokwane lëgleme.’ Na sebo bume kalabusu lo mago jine jwa këme nëlëkakla. Sebo bume eso ho Sisar belë fwa sajine nëglëlame.” ");
INSERT INTO nce_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Festus gali mesle latotle, sebo sibu lome fe nëlame na Itali provinswa nujame. Na bu Polname, fli kalabusu enënename, wame home boblo mogotomabë enënebë eso ho belë sei mutujuwelëma, bu mëglëboujalime hwi sle namoglomame. Kë hobë weniji Julius. Buna bubë wame home boblo mogotomabë enënena, bu eso ho Sisarbë lo mëta sei mëglëkeflabë enëne. ");
INSERT INTO nce_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Na sebo Adramitium lifate mago kë tigisibë sibu lo mëta fëfe tla. Kë sibu lo, nutu helefo mëta, kë tafa mokoujabë lifate elëme lugujume kofenene, Esia provins mëta. Na Aristarkus bu sebona tuja. Kë ho bu Masedonia provins mago na bubë lifate weniji Tesalonaika. Na kwe sebo Sisaria lifate kile totla. ");
INSERT INTO nce_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Jowa klabë tëkaka na sibu lo Saidon lifate mëta fla tule. Na Julius, Polme lale lakale lebotane tëtatle na bume megali tlole, “Jubë yabenime hwime lalowa egujume, bu jume hi wesibiname, fli wesibiname mëgaito namëglame.” ");
INSERT INTO nce_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Na kwe tokwafe Saidon lifate kile totla. Na tako flelu, sibu lo miti nagi fo tëtagule. Këme nëgeme, sebo Saiprus afayo amlebo elë këme hwagënë tokwokwëya. Na kë afayo aflokobë tako flelu hana tle. ");
INSERT INTO nce_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Sebo tako nutu su tëkaka na Silisia provins na Pamfilia provins loli elë sigli tokouja. Na Lisia provinsbë lifate mëta, Maira mëta fla tula. ");
INSERT INTO nce_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Na sebo kë lifate mëta sibu lo mago fëfe tëkaka. Na wame home boblo mogotomabë enënebë eso ho Aleksandria lifate mago kë tigisibë sibu lo hwi tlole. Kë sibu lo, Itali provinswa luguju nalëgleme. Këme nëgeme bu seme kë sibu lowa mëtlenuna. Na sebo kë sibu meta fëfe tula. ");
INSERT INTO nce_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Na sebo Maira lifate kile totla, na sibu lo feilawa olë alabujuwa tujukëfe. Flelu bume miti nagi fo tëtagukefleme nëgeme. Sebo Nidus lifatewa nounou watla kwe flelu sibu lo mana kë tëbetokwakle na sebo tuguja hana tla. Këme nëgeme sebo sibu lo jelë tetokwakla na Krit afayo elë tuja. Na sebo Krit afayo flelu jwa tabo elë tuja, Salmone hwetu li elë tuja. ");
INSERT INTO nce_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Na sebo kë afayo mëglëbo elë alabuju tujukefëya. Na sebo li afloko elë mana fwa tla. Kë aflokobë weniji melë, “Lale Ku Tako.” Bu Lasea lifate li mëta lëbe. ");
INSERT INTO nce_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Na kwe, lebutako olë wafi mutuju na Gotome hi jwa tafa mëtletlabë olë mata wafi tuju. Na nutu feilawa sosogli lëglebë yeme wafwa tla. Këme nëgeme, Pol megali tlome, ");
INSERT INTO nce_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“O sibu lo mago enëne, sobo aholokwane elo. Bo melë lowene nanelë, sebo eli nugujana, kwe sebo alëgeme tëbo niglitayame. Na kwe kë sibu lo na lebutako wesibi tëbo mëgleme. Wesibiwa tëbo mëgleme nane. Weye. Sebo fli kë mëta gigli nëglame.” ");
INSERT INTO nce_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Kwe wame home boblo mogotomabë enënebë eso ho, Polbë gali aholokwane hana tlole. Bu sibu lo bolijayabë lowene na sibu lo kë asë tëglelëlebë hobë lowene esogo tlelëtëme. ");
INSERT INTO nce_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ebë sibu lo këkesi labu kë nëgebë, lale tabo nane. Tako flelubë olë ligisi nëgena, sibu lo flelume habëna ëho lëglemene? Flelu sibu lome bubluju logotleme. Këme nëgeme lebutako ho, sibu lo mëta kë tafa mëtlabë, gali sle mototla, kë lifate kile namëglame. Bu melowene mëtla, “Sebo ebë lifate kile nëlame na Finiks lifatewa nujame. Na kë lifate mëta, tako flelu ligisi olë tafa nëlame. Bale, fwa nugulame nawa o hanane.” Finiksbë sibu lo këkesi tala Krit afayo nëgemowe mëglëbo elë lëbetëme. Na sibu lo kë tëbo lotokwefëmebë flelu, kë belëme fe hana lulekefe. ");
INSERT INTO nce_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Negemowelë mago flelu tisi na bu tako flelu nane. Këme nëgeme, bu melowene mëtla, “Sebo Finiksbë sibu lo këkesi labuwa lalowa nugujame.” Këme nëgeme bu sibu lo kë fa logotlebë hobota tabo ainë buhe mototla na bu kë tala kile mëtla. Na Krit afayobë helefo mëglëbo mëglëbowa mana mutuja. ");
INSERT INTO nce_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Bu mutujabëë, na hokweinawa Krit afayo elë mago labasagli flelu tako mana tisi. Bu kë flelu mefë lamotla, “Nëgetuje elë mago flelu.” ");
INSERT INTO nce_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Na kë flelu sibu lome feilawa bëbë totle na ku takowa fo tëtagule. Sibu lo mëta kë wege mëglabë ho bu sibu lo yelu, flelu kë belëme tigisibë elëme yafe swaya mototla kwe hanane. Flelu bume tako boblo metotome. Këme nëgeme bu flelubë tolewa esogo mëtlelëtla. Na sibu lo ku tako elë mana fo fowa tëtagule. ");
INSERT INTO nce_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","17","Sebo Kauda afayo nëgemowe mëglëbo elë tuja. Na kë tala tako flelu hanane. Na sibu lo mëta kë wege mëtlabë enëne, sibu lona kë ki tokweijabë ihe, sibu lo elo li elë tako afutukuna ki motokweija. Na sibu lowa mana ki motokwaka na tabana tafu mëtëtagujaya. Na bu tatako taba glo mëtla. Na sibu lo lokwalëfe elë blou mototolelëma na mana kë tabana sibu lo tafu mëtëtagula, flelu kë sibu lo yayei logotlelime. Bu Afrika lifate li mago tu lokwalëfe mago yenëba mëta lesilime, uli memëtla. Këme nëgeme sibu lo kë asë mëglelëmebë selë ki mëtëtëkekëya na bu flelubë tolewa esogo mëtlagutla. ");
INSERT INTO nce_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Fleluna, nutuna sibu lome feilawa boblo mototlo. Këme nëgeme, jowa klabë tla na sibu lo mëta kë wege mëglabë enëne, fli wesibi nutuwa sisike mëtla, sibu lo fogolego nalëgleme. ");
INSERT INTO nce_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Tële olë wamutuju na aona olëbëna bu sibu lo kë asë mëglelëmebë selë fli na selë kë mëta kesi mëglebë ti flina nutuwa sisike mëtëtëkaka, sibu lo fogolego nalëgleme. ");
INSERT INTO nce_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Lebutako olë sebo klijina, sëgetobana hwi hana noloma. Na tako flelu seme sibu lona feilawa bëbë tëtaguna. Këme nëgeme, sebo melowene hana nëla, “Sebo tuja ato nëtabëyame.” Weye. Sebo melowene nanëla, “Sebo iniwa gigli nëglame.” ");
INSERT INTO nce_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Lebutako olë bu iniwa hi jwa tafa mëtla. Na tokwafe, Pol huju tle na ku mëta tlibe na bume megali tlome, “Sobo bobë gali esogo tëglelëtënabë na Krit afayo kile jwa nëlame kwe seme ebë tëbo olë esune hana lëglëname fene. ");
INSERT INTO nce_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Kwe bo some gali nëlëyo, sobo ebë tëbo olëme feilawa asa tutune eletelo. Semago ho li hana gli lëgleme. Kwe sibu lowa tëbo lëgleme. ");
INSERT INTO nce_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Bo Gotome fwa tafa nëglekefëtelëbë ho. Na Gotome fwa lotu nëglekefëtelëbë ho. Ëje klabë, Gotobë ensel bobë lime lilikakitenë, ");
INSERT INTO nce_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","na megali lolonë, ‘Pol ju ebë wesibi kë fata lëglebëme uli asa ele. Ju tokwafe Rom lifatewa tuhu eguleme na Sisarbë naba lime elibeme. Aholokwane ele. Goto some lëgaitome. Na iniwa ho juna sibu lo mëta kë tafa egelobë bu gigli hana mëglame.’ ");
INSERT INTO nce_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ensel megali loglonëme nëgeme na bo some këme gali nëlëyo, sobo uli asa elo. Bo Gotome melowene nanëletelë, ‘Iniwa wesibi bu bome fene gali lolonë, bu melë fata mëgleme.’ ");
INSERT INTO nce_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Kwe flelu ebë sibu lo lëgehuleme na li afayobë yenëba mëta bubluju luleme.” ");
INSERT INTO nce_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Na kwe sebo kë nutu mëta tëtabëyabëë, olë këniji latla we ita aona. Kë nutu mefë lamotla Mediterenian nutu. Nilifu klabë kuna, sibu lo mëta kë wege mëglabë enëne melowene mëtla, “Sibu lo li afayo belë fwa lëgleme lololi lalëlefe.” ");
INSERT INTO nce_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Këme nëgeme, hobota tabo wesibi taba heletabo mëta kesi mototla na yenëba mëgëselëlabëme nutuwa tuku mëtëtëkaka na yenëba këna mëtëselëla. Na ita buhe mëtetofakla na bubë lëlekuju tabei ebë këniji niliafewe. Na ita sibu lona kli mëtëkaka na ita yenëba këna lëlekuju mëglabë wesibi tuku mëtëtëkaka. Na ita buhe mëtetokwakla na bubë lëlekuju tabei ebë këniji aowafewe. Këme nëgeme bu melowene mëtla, “Yenëba lololi tei notlafe.” ");
INSERT INTO nce_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Na bu uli memëtla, sibu lo, aniji mëta bubluju lëglelime. Këme nëgeme bu sibu lo këna hobota lëglebë ainë nilina, sibu lo elo elëme sike mëtëtëkaka, sibu lo kë mëta fwa lëgemule nalëgleme. Na bubë gotome gali tuku mëtletëma, hokweinawa feti nalëgleme, bu hwi sle namëkakame. ");
INSERT INTO nce_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Sibu lo mëta kë wege mëglabë ho, sibu lo kile namëglame fene, alëge hohwi mëtëtatla. Këme nëgeme bu sibu lo mago ihe tabana nutu mëta tuku mëtëmalitaya. Na mesogëna mëtla, “Sebo kë ihena, ainëna taba eso, sibu yelu mëta kë kesi nanokoujame na ainë mana nutuwa sisike nëtëkakame.” ");
INSERT INTO nce_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Kwe Pol wame home boblo mogotomabë enënebë eso honame wame home boblo mogotomabë enënename megali tlome, “Kë enëne sebona sibu lo mëta tafa jwa nëglana kwe sobo gigli egelome.” ");
INSERT INTO nce_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Këme nëgeme, wame home boblo mogotomabë enëne tële taba, ihe mëta kë kë kesi mëtlabë, tëtlë mototoma. Na nutu ihe mana fo tëtagwi. ");
INSERT INTO nce_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Feti lololi tle. Na Pol iniwa home, hi wesibi hi namokoujame anisasana gali tlome. Na bu megali tlome, “Sobo we ita nilina olë tafa sle hana telo, tutune mëta fwa tafa tokweijo na hi wesibi hana hi tokweijo. ");
INSERT INTO nce_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Këme nëgeme bo some anisasana këme gali nëlëyo, sobo hi wesibi mana hi naekoujome. Some kë hi wesibi afutuku namëglelëyome. Sobo aholokwane elo. Semago ho li ato li hana tëbo logotleme, sebo iniwa lalowa nëtabëyame.” ");
INSERT INTO nce_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Na Pol kë gali yawe tlole na bletë nage fa totle na bu kë enënebë naba lime Gotome lale gali tlole, “Ebë bletë nage, yaha fëyeme enënëne.” Na bu bletë nage fufu totle na mana hi tle. ");
INSERT INTO nce_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Iniwa ho bu Polbë gali aholokwane mëtla na bubë tutune lowene, sle tletëme. Na bu mata hi wesibi glo motokouja na hi motokouja. ");
INSERT INTO nce_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Sebo sibu lo mëta kë tafa tëglabë tabei bu këniji 276 ho. ");
INSERT INTO nce_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Sebo hi tokoujabë, imo soslo mëtëtagujaya. Na sebo witi liji begë manogwa nutuwa sisike tëtëkaka, sibu lo fogolego nalëgletëname. ");
INSERT INTO nce_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Olë wafeti tëbe na sibu lo mëta kë wege mëglabë ho yenëba hwi mëtelokwakla. Kwe kë yenëba mëtëselëla hana mëtla. Na bu wakona tëglebë yenëbabë hwi mëtelokwakla. Na bu gali mëtla, “Sebo ebë sibu lo, ebë wakoha tabo elë manehula na kë mëta fla nulelëlame.” ");
INSERT INTO nce_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Këme nëgeme bu ainë mago taba tëtlë mototoma na nutu mëta hune mëtëkaka. Na bu sibu lo këna kë asë mëglelëlabë yegu mago taba totohwa mototoma. Na bu sibu lo kë asë mëglelëlebë selë kli mototokwakla, flelu hoho nalogotleme. Na sibu lo yenëba elë mana lujume. ");
INSERT INTO nce_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Kwe sibu lo yelu, nutu lokwalëfe mago yenëba mëta lalesiliwa totole. Na nutu bu sibu lo elo bubluju totle. ");
INSERT INTO nce_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Na wame home boblo mogotomabë enëne, bu kalabusu home hao mëtletëma, bume mogo nalë tëtëkle namëgëtayame fene. Bu fofolou mokoujame na mana mëlëboukakujalime. ");
INSERT INTO nce_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Kwe wame home boblo mogotomabë enënebë eso ho Polme lëgaitalëme tole lëgletleme nëgeme. Na bu wame home boblo mogotomabë enëneme melëkle totome, “Kalabusu home mogo nalë asa tëtëkle eto. Matëbe.” Na bu seme iniwa gali tlona, “Sobo foloume lowene lalo kwe sobo afina lalowa okokli ekako na yenëba elë folou ekoujome. ");
INSERT INTO nce_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Na sobo fli, sibu lo mago agwihe glo elome na këna some nutu mana yenëbawa fo lëtagujome.” Sebo melë tla na sebo iniwa yenëba elë fëfe tula. Na semago liha hana tëbo tlita. ");
INSERT INTO nce_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Sebo iniwa helefowa fëfe tla. Na kë lifate mago enëne seme megali lamotlona, “Ebë afayobë weniji Malta.” ");
INSERT INTO nce_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Këbë lifate mago enëne seme fleflesuna mëtaitana. Tu mana tetokëfe na kë lifeku tlilego metle. Këme nëgeme bu ahoju këme hoho mëtla. Na bu seme iniwa ahoju labuwa mëtlenuna, sebo ahojume sa nanugulame. ");
INSERT INTO nce_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pol ahoju hoho ti glo tle na ahoju mëta gogwa tole. Na tëbo taiju, kë ahoju hoho ti kufe ke telulamë. Na kë taijume ahoju atëte tëselëkakë. Na latohowa tëkakëyamë na Polme toba mëta tëtou tlële. Na mana kesi tokwakëyatle. ");
INSERT INTO nce_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Na kë lifeku mago oneho kë taiju Polme tobame kë tëtou tëglëlebë mehwi motlotla, tobame mana kesi tlatle, na bu blalo megëgali lamëtla, “Hwi elolo. Ebë ho kë nëgebë, mogo nalë kë tëtëkle tëtakefëbë ho. Bu nutu mëta gli hana tle. Kwe tëbo loweneme kofayame kë tëbo lotokwefëmebë goto, bu kë home mogo nalë tëke nalogloleme.” ");
INSERT INTO nce_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Kwe Pol kë taijume ahoju elëme bile tetokwakë na bume li wesibiha fata hana tletle. ");
INSERT INTO nce_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Oneho bu melowene lamëtletla, “Polbë ato sëse lëgletlemewa o bu hokweinawa mogo nalë letigomewa.” Na bu Polme mana yafe hwi motlokwefla. Kwe li wesibiha bume fata hana tletle. Këme nëgeme bu lowene hihijika mëtla na bu megali mëtla, “Kë ho ebë li goto tekwe nëge!” ");
INSERT INTO nce_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Këbë ahoju labu lime kë tëgëbebë life, ebë kë afayobë eso hobë life. Bubë weniji Publius. Kë ho seme bubë lowa nëno tle na bu seme aona olë tafa tlenëna na ululu sle memutëtana. ");
INSERT INTO nce_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Publiusbë bolijaya tako tëbo latle. Bu ato ahojutena, aliji tuna melatle. Na Pol bu belë tuju tle na Gotome takune tlole. Na bu toba gwa totatle na bubë ato sle tletle. ");
INSERT INTO nce_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Pol bu melë tle, na kë afayo mago atowelili enëne fli mata Pol belë mitisiya na Pol bubë ato mata sle totometëme. ");
INSERT INTO nce_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Iniwa oneho bu seme fleflesu mëtletëna na seme feilawa wesibi mana mëtlëna. Sebo aona yeme Malta afayo mëta tëtabëya na sebo bume hune nëglame kofene. Na bu seme hi wesibi mëtlëna. Na sebo kë afolo tëgletëmabë wesibi mata mëtlëna. Na bu sibu lo mëta gogwa mëtletëna. ");
INSERT INTO nce_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Sebo li sibu lo mëta fëfe tla. Kë sibu lo kë nëgebë bu tako flelu yemena kë afayo mëta temule. Bu Aleksandria lifate mago. Na Sus gotobë tlemalë iko nëbalebë amtëtomba tina kë blëge blëge mototomabë, sibu lo yelu mëta mëtëbetëme. Na sebo kë lifate kile tla na tuja. ");
INSERT INTO nce_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Sebo Sirakyus lifatewa fwa tula na këme aona olë tafa tla. ");
INSERT INTO nce_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Na sebo Sirakyus lifate kile tla na Regium lifatewa fwa tula. Jowa klabëwa tla na mana nëgemowelë mago flelu tisi. Këme nëgeme sebo Regium lifate kile tla na sebo tële olë tuja na Puteoli lifatewa fwa tula. ");
INSERT INTO nce_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Na kë lifate mëta, sibu lo mago fëfe tëkaka. Na Kristen oneho flime esune tlëma. Na bu seme, buna tafa nanëglame takune motlona. Na sebo buna tobali ita tële olë këniji tafa tla. Na ita sebo bume hune totoma na Rom lifatewa tuja. ");
INSERT INTO nce_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Kristen oneho, Rom lifate mëta kë tafa mëtlabë, gali aholokwane mëtla, “Polna kë misiya.” Na bu seme alëgeme esune mëglënabëme mitisiya. Fliye bu seme Apiusbë wesibibë hihijika lifeku mëta esune mëtlëna na fliye Aona Ni Lo kë mëta mëglibebë lifeku mëta esune mëtlëna. Pol bume yafe hwi tlome na bu tako fleflesu metle na maninibona sle tle na Gotome fleflesu gali telokwakle. ");
INSERT INTO nce_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Sebo Rom lifatewa fwa tula. Na Rom lifate mago gavmanbë ho megali tle, “Pol buwa li lome lalowa tafa lëgleme kwe wame home boblo logotomebë ho li bume mana sei lëlëkefëtleme.” ");
INSERT INTO nce_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Pol Rom lifate mëta aona olë tafa tle, na bu Israelbë afenëbonibë eso enëneme mana gali telokwakëme, bu belë migisitla namëglame. Na bu mitisitla na Pol bume gali tlome, “Bobë afani, bo sebobë enëneme hana tëbo totomë, na bo sebobë semleninobë gali hana boblo totlë. Kwe Israelbë afenëboni, bome Jerusalem lifate mëta wakalabusu mëtëtana. Na bu bome Rom lifate mago gavmanbë toba mëta gwa mëtëtana. ");
INSERT INTO nce_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Na kwe, Rom lifate mago gavman, Israelbë afenëboni, bome blawa kë so mëtëtatënabë gali aholokwane motlona. Kwe bobë li fëye wesibiha, hwi hana motlotëna na megali hana mëtla, ‘Bume lalowa, mogo nalë tëkle etlo.’ Weye. Këme nëgeme bome kalabusu lo mago jine namëgelëkakëname fene. ");
INSERT INTO nce_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Kwe, kë Israelbë afenëboni, bome kalabusu lo mago jine mëglënabë gali boblo mototla. Na bo gali fëye mago fa nogotlëmene? Këme nëgeme, bo megali telë, ‘Bo metole nanelë, bome blawa kë so mëtëtatënabë gali, Rom lifate magobë eso ho, Sisar, saaholokwane loglonëme.’ Kwe bo kë Israelbë afenëbonime, tëbo gali noglomëme nane tisi. ");
INSERT INTO nce_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Këme fwa nëgeme bo some këme gali nolëyo, bome kë kalabusu mëgëtanabë wesibi lowene sle naegletelome. Tako tafa watokwëija, na sebo, Israelbë afenëboni, seme lëgaitanabë home, Goto jine gali kë lëgelëbaklebë home, mana ekë hwi nëlekefëtla. Na bo melowene nanelë, ‘Goto jine gali kë lëgelëbaklebë ho wafi tisi.’ Na kë loweneme fwa nëgeme, bome këme kalabusu mëtëtana.” ");
INSERT INTO nce_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Na bume gali motlola, “Judia provins mago ho, bu jubë loweneme pasëna seme hana gali mëtelëbakëna. Na Judia provins mago ho li, sebelë, jubë li tëbo galiha, hana tehitëna. ");
INSERT INTO nce_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Kwe lebutako enëne, li life li life mago megali lamëtlekefëya, ‘Jisasme lowene sle mëglekefëtlabë enëne bu tëbo enënemu.’ Këme nëgeme, sebo jubë lowene mago lowene aholokwane sle nanëgletëyome.” ");
INSERT INTO nce_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Na kwe bu olë li aniji motlola, Polbë gali aholokwane namoglolabëme. Na kë olëna, lebutako oneho, Pol kë mëta kë tafa lëglebë lowa loko motokweija. Na Goto bubë onehome, eso home, kë tafa lëgletëmebë galime, Pol okokwe sle tlome. Na bu, Moses, Jisasbë gali kë yahi tëgletlebë, galime mata okokwe tlome. Na Gotobë lowene mago gali kë të mototokweflabë enëne, Jisasbë gali kë yahi mëtletlabë galime mata okokwe tlome. Pol metole latle, oneho melowene namëglame, “Jisasme kë gali mëgletlabë gali nëgali galimu.” Pol bu olobalëmu oto tëglebë na olë ki na loko metleblemu. ");
INSERT INTO nce_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Na kwe fli enëne Polbë gali melowene sle lamëtletla, “Bubë gali nëgali gali fe.” Kwe fliye melowene hana mëtla. ");
INSERT INTO nce_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Na bu blalo momata mëtlelogwaya. Na Pol bu li galime mana gali tlome, “Gotobë Amtëtomba, Gotobë lowene mago gali të totokweflebë home, Aisaiame, gali metëglële latle. Na kë gali kë nëgebë nëgali gali mu. Na Aisaia kë gali sebobë semleninome gali tlome. Bu megali latlole, ");
INSERT INTO nce_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Ju kë oneho belë ejume na ju megali elomeme, “Sobo gali itaita aholokwane eglekefëtelome kwe sobo kë gali wayobë lowene sle hana egletelome. Na sobo itaita hwi eglokweflome kwe sobo hwi sle hana eglolome.” ");
INSERT INTO nce_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Kë enënebë lowene wakalëlego tletëme. Na Gotobë gali aholokwaneme wafi tëboijiwa mletla. Na Goto kë totomebë wesibi bubë nabana hwi moglomabëme tëboijiwa wamla. Kwe bu Goto kë totomebë wesibi hwi sle moglomana na Gotobë gali aholokwane sle mëglana, na kë wayo gali lowene sle mëgletlana, kwe bu tëbo lowenebë kile mlame na aholokwana ti mlame. Na bu bo belë misiyame na bo naitamëme na bume sle notomëme.’ ” ");
INSERT INTO nce_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","Na Pol megali latle, “Sobo sobobë semlenino fenene, Gotobë gali aholokwaneme metëbojiwa lalo. Këme nëgeme bo some këme gali nëlëyo. Goto onehome nëno lëglebë gali, Israelbë afenëboni mëtabëya jwa mëglabë enëneme wafi telëkakëme. Kë enëne bu aholokwane mëglame.” ");
INSERT INTO nce_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pol bu, li lo mëta, Rom lifate mëta, tële tlibutu tafa tle. Na bu kë lo bolijayame baliti tlëkefle, bu kë lo mëta tafa nalëgleme. Iniwa oneho, Pol belë kë mitisikefëtlabë, Pol bubë lowa fleflesuna nëno tlekëfe. ");
INSERT INTO nce_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Na, Goto bubë onehome, eso home, kë tafa lëgletëmebë galime Pol okokwe tlokwefëme. Na bu Tako Ho, Jisas Klaisbë galime lebutako onehome okokwe tlokwefëme. Na bu kë gali tëme uli hana tle. Na ho liha bume lëkle hana totle. ");
INSERT INTO nce_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","Bo Pol na Timotina, sebo Jisas Klaisbë wege ho. Sebo some, Filipai lifate mago Kristen onehome na lotu mogoutatlabë eso enënename na lotu wegeme kë mëgaitobë enënename pasë ekë yahi nëkeketëyo. ");
INSERT INTO nce_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","Bo sebobë aya Gotome na Tako Ho Jisas Klaisname itaita takune nanolokwefëmë, some maninibo tli lowene namëglëyome. ");
INSERT INTO nce_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","Iniwa olë, bo some kë lowene nëglekefëtëyobë, bo bobë Gotome megali nanolokweflë, “Bo bobë Gotome mefleflesu gali nanolokweflë, yahala fëyemene. ");
INSERT INTO nce_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","Iniwa olë, Goto some lëgaitobëme, bo gëgali nanëlelëkeflë, bo fleflesuna gëgali nëlelëkeflë. ");
INSERT INTO nce_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","Automemu bo sobelë Jisasbë gali kë tëgehilebë, sobo bome kë gali tëme taitana, na sobo bome mana ekë aitagina. Na bo some tako fleflesu këme nëlekefëtëyo. ");
INSERT INTO nce_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","Bo melowenemu nanelë, Goto sobobë lowene mëta lale tafa lowenebë gwa tëtatëyo. Na kë lale tafa lowenebëme mana lalaitakefëyo. Na Klais Jisasbë ligisi olëna bu kë lowene mana slemu sle lëgëtatëyome. ");
INSERT INTO nce_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","Sobo bobë maninibo mago mu. Këme nëgeme, bo some këha lowene nëgletëyobë ebë lalemu. Kë wege, Goto bubë tolenawa, bome kë tëglënëbë, sobo bona kë wegeme iniwa kahwë slemu latla. Bo kalabusu lo mëta kë tafa nëgelëbë o bo kalabusu lo mëta tafa jwa tëgelëna, bo onehome, Jisasbë gali esobëme, gali sle tlomë. Na bo Jisasme kë lowene sle namëgletlabë ëhwati gali onehome okokwe tlome bu Jisasme lowene slemu namëgletlame. Na sobo bona mana kahwë sle tëglana. ");
INSERT INTO nce_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","Bo some iniwame maninibomu nanëletëyo, Klais fene maninibo tletëyo na bo some ita hwime këme tole nëletëyo. Goto lowene lalële, bo some nëgali gali gali nolëyo. ");
INSERT INTO nce_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","“Bo Gotome megali nanolokweflë, fli enëneme tole egletemobë lowene, sobobë lowene mëta, takowa nalëgebetëyome. Na kë lowenebë, Gotome kë lowene sle egletelobë lowenebë, some laitome. Na sobobë lowene lalowa nalëbetëyome. Na sobo kë lowenena wesibi melowene naegletemome, lale wesibi o tëbo wesibi. ");
INSERT INTO nce_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","10","Sobo melë egelona, na Klaisbë ita ligisibë olë fo lokoketlena kwe Goto some mehwi lëglëyome, lale onehomu. Na bu some li fëye tëbo wesibiha hana hwi loglotëyome. Na sobo iniwa lowene, lowene sle naegletemome na fëye lowenebë lale lëgebena kë lowenebëwa esogo sle elelëlome. ");
INSERT INTO nce_vpl VALUES ("PP1_11","080_1_11","PHP","1","11","11","Na iniwa lale lowene Jisas Klais mago kë migisibë, bu somëta nohwa mëgëbetëyome.” Na iniwa oneho bu kë lowene somago hwi mololame na Gotome fleflesu mletlame na megali mlame, “Goto bu tako homu. Iniwa wesibi bubë lokwalëfe mëta fwa mëbetle. Bu lale mu.” ");
INSERT INTO nce_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","O Kristen afani na oneglëni, bo metole nanelë, sobo melowene egelome; ebë wesibi bome kë fata mëtëgletenëbë, bu Jisasbë lale galime lëkle hana mototle. Weye. Kë wesibi, Jisasbë lale gali fli oneho betelë fifiji tëglebëme lataitale. ");
INSERT INTO nce_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","Iniwa wame home boblo mogotomabë enëne, eso ho Sisarbë lo mëta kë sei mëglëkeflabë, na fli enëne mata, bu melowene lamëtla; bo Jisas Klaisbë gali të nëtakefëtelëme nëgeme, bome kalabusu lowa këme tuku mëtla. ");
INSERT INTO nce_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","Na lebutako Kristen oneho bome melowene mëtletëna; bo kalabusu lo mëta tafa telë. Na këbë lowene bume Jisasme anisasana lowene sle mëgletlabëme taitame. Na bu uli mëtlëkëla na Gotobë gali anisasana të mëtëtatla. ");
INSERT INTO nce_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","15","Fli oneho, mehwi lamëtla, fli oneho bobë wenijime fleflesu lamëtletëna. Na bome tëbo mëgëtanabë lowene fa mototla na bobë weniji lëlë mogotlabë lowene mata fa mototla. Na bu metole lamëtla, oneho bubë wenijime fleflesu namëgletëmame. Na këme fwa nëgeme, Klaisbë lale gali këme të mototla. Kwe fliye bu lale lowenenamu tafa mla na Klaisbë lale gali këme të mëtatla. ");
INSERT INTO nce_vpl VALUES ("PP1_16","080_1_16","PHP","1","16","16","Kë oneho bome tole lamëletëna na melowene lamëletëna, Goto bome melëme aniji tlonë, Klaisbë lale gali esobëme, onehome okokwe sle nanoglomëme. Na bume lebotane sle nëtatemëme, kë gali nëgali galimu. Na këme nëgeme bu Klaisbë lale gali këme të mototla. ");
INSERT INTO nce_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","Kwe bobë weniji kë lëlë mogotlabë oneho metole lamëtla, fli oneho bume melowene namëgletëmame, “Bu lale enënemu.” Na bume fleflesu na mletëmame. Na bu Klaisbë lale gali këme të mëtëtagula. Kwe bu lale lowene nane fa mototla. Weye. Bu metole lamëtla, bo kalabusu lo mëta kë tafa nëgelëbë, bo hobota feilawa fa nanogotlëme. Këme nëgeme bu melë këme mëtla. ");
INSERT INTO nce_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","Kwe oneho Klaisbë gali lale lowenena të mogotlana o tëbo lowenena të mogotlana, bo këbëme welili hana nëletemëme. Bo melëme fwa fleflesu nelë, bu Klaisbë lale galiwa të mëtagutlame. Na kwe këbë bome fleflesu lëgëtanëme. ");
INSERT INTO nce_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","Na bo kwe fleflesuwa nëglekefëme. Bo melowene nëgelëme nëgeme, Iniwa olë sobo Gotome takune elokweflo, bome lëgaitanë nalëgleme. Na Gotobë Amtëtomba, Jisas kë tëglënabë, bobë lowene kalëlego lalëtakefëtenë. Na këme fwa Goto bome laitanëme na bo kalabusu lo kile nelëme na manawa ho tafa nanëgelëme. ");
INSERT INTO nce_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","Këme nëgeme bo metole nanelë, bo li tëbo wesibiha hana nëgelëme, na bo këme tiniji nëlëme. Hanane. Kwe bo metole nanelë, elë na tokwafe bo Gotobë lale gali tëme uli hana nëgelëme. Bo gli nëgelëna o tuja ato mana tafa nëgelëna, iniwa wesibi bo melë kë nëgelëbë, Klaisme fwa nëletelë. Na kë iniwa wesibi bume weniji tako melëlëme. ");
INSERT INTO nce_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","Bobë lowene melë lëgëbelalële, Bo tuja ato mana tafa nëgelëna, iniwa wesibi bo melë kë nëgelëbë, kwe Klaisme fwa nëletelë. Na bo gli nëgelëna kwe bo lale tafa fa nogujetlëme na bo ëje kë tafa nëgelëbë tafame boblo logotleme. ");
INSERT INTO nce_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","23","Kwe bo tuja ato mana tafa nëgelëna, bo melowene nanelë, bo feilawa onehome, Klaisbë lowene esogome mëglelëtlabëme okokwe noglomëme. Bo gli nëgelëna o tuja ato mana tafa nëgelëna, bo melowene hana nelë, fëye lowene esogo nëglelëlëmene? Bome kë tële lowene, tabaha kiki mële. Bo gli nëgelëbëme. Na Klaisna tafa nogulobëme, tako tole nanelë. Kë kwe lalemu. ");
INSERT INTO nce_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","Kwe bo some lowene nëgletëyome nëgeme na bo melowene këme nelë, bo tuja ato tafa manelë, some nëgaito nanëgelëme. Kë kwe lalowamu. ");
INSERT INTO nce_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","Bo melowene slemu nanelë, bo some nëgaitobë wege mana lëbe. Këme nëgeme bo melowene nanelë, bo tuja ato mana tafa nëgelëna na some feilawa nëgaitome, Jisasme esogo eglelëlobë lowene, lowene sle naegletelome na këbë loweneme fwa fleflesu naegelome. ");
INSERT INTO nce_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","Na ita bo sobelë nigisina na sobo bome hwi enonana, sobo Jisas Klaisme fleflesu eletelome, bu bome sobelë ita leglesunëme nëgeme. ");
INSERT INTO nce_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","Tako wesibi melë. Sobobë asë sle etlome na Klaisbë lale lowenewa esogo elelëlome. Sobo melë egelona, na bo some hwi noglokwakijona o bo tafa nëgelëna na galiwa aholokwane negletëyona, kwe bo melowene nëgletëyomemu, sobo Jisasme lowene sle lowene mana esogo elelëkeflo na sobo yonane mëta mana tafa elekefo na jowa lowene nawa Klaisbë iniwa wege fa etlome. ");
INSERT INTO nce_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","Bo some megali nolëyo, some kë wame mëglëyobë enëneme uli asa eletemo. Bu some mehwi mëglëyona, sobo bume uli hana eletemo, kwe bu melowene namëglame, Goto seme tëbo lëgëtanamefe. Kwe Goto some ululu sle lëgëtome na lale tafa lëlelëyome. ");
INSERT INTO nce_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","Aholokwane elo. Goto some tële lale lowene wafi tlëyo. Li lowene, Jisas Klaisme lowene sle egletelobë lowene. Na li lowene, Klaisme lowene sle egletelobë mëta hobota eglibe telobë lowene. ");
INSERT INTO nce_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","Sobo ëtani bome wafi hwi tlona, bo Jisasme kë lowene sle nëgletelëbë wame mëta tafa telë. Na sobo bobë gali waaholokwane telo, ëje bo kë wame mëta mana ekë nëtabë. Na ëje sobo elili kë fa egotlobë, sobo melowene egelome, bona iniwa Jisasme kë lowene sle nëgletlabë wame mëta nëtabëya. ");
INSERT INTO nce_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","Klais sobobë lowene kalëlego malëtatëyo. Bu some feilawamu tole lalëletëyo na këme nëgeme sobobë lowene lëgëbetëyo sle këme lële. Sobo Gotobë Amtëtombabë lowene mëta tafa egelome nëgeme, sobo flime këme maninibo eletemo na sobo flime mata këme tole eletemo. ");
INSERT INTO nce_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","Kë gali nëgali gali nëgebë kwe sobo melë saelo, sobo iniwa jowa lowenenawa yonane elome. Na sobo iniwa jowa lowenenawa, ho flime tole egletemobë lowene esogo elelëlome. Na sobo iniwa jowa lowene nawa tafa elome. Sobo melë egelona kwe sobo bobë lowene feilawa fleflesu egëtatëname. ");
INSERT INTO nce_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","Sobo some fwa asa lowene elo. Na sobo fli enëneme melowene asa eletemo, sebo bu fene këha enëne nane, sebo kwe lalemu. Sobo flime salokwalëfe eletemo, na bume melowene eletemome, bu sebo fene këha nane bu kwe lale enënemu. ");
INSERT INTO nce_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","Sobobë wesibiwa asa ululu sle etomo. Weye. Sobo fli enënebë wesibi mata ululu sle egotometemome. Na bume aitamome tafa sle namëglame. ");
INSERT INTO nce_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","Sobobë lowene Jisasbë lowene fene tëbetle, këha salëbetëyo. Bubë lowene melë: ");
INSERT INTO nce_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","Iniwa wesibi fata jwa mëtlena Jisas bu Goto fene metafa latle. Kwe bu Gotoha tafa lëglebë lowene tëgehole hana tle. Weyewa. ");
INSERT INTO nce_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","Bu Gotoha tafa tëglebë lowene kile tle na home manawa wege lëgletëmebë hobë loweneha tëbetle na life mago hoha fata tle. ");
INSERT INTO nce_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","Na oneho bume mehwi motlola, life mago ho fenene. Na bu bume fwa hana lowene tle kwe iniwa onehome lokwalëfe tletëme na Gotobë galiwa esogo tlelëtle. Bu melë tle na bu mana gli tle. Bu kë gli tëglebë, bume tëbo homeha ti mëta bu mëtla. ");
INSERT INTO nce_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","Bu mële tëgleme nëgeme na Goto bume këme fleflesu tletle. Na bume këme no tlële, buna eso home weife tafa namëgelome. Na Goto bume iniwa wesibime eso home tafa lëgletëmebë weniji tlële. Kë weniji kë nëgebë iniwa onehobë wenijime boblo lalotometëme. ");
INSERT INTO nce_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","Bu Jisasme kë weniji këme tlële bu metole tëgleme nëgeme. Iniwa hëhëna wesibi, Heven life mëta kë mëtabebë, na life mëta kë mëtabebë na life lokwalëfe mëta kë mëtabebë, bu iniwa Jisasme sëkefo miti tafa mletlame. Na Jisasbë lokwalëfe mëta fwa metabëtlame. ");
INSERT INTO nce_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","Na bu iniwa megali mlame, “Jisas Klais bu tako homu. Iniwa wesibi bubë lokwalëfe mëta fwa mëbetle.” Na kë lowenena, bu melë lowene olafa motlame, “Goto bu lalena Tako Ho mu.” ");
INSERT INTO nce_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","O yabeni. Bo sobona ëtani kë tafa tëglabë, sobo bobë gali aholokwane tlona na esogo tlelëlo. Na ëje bo sobona nane tafa nëla. Bo kakë tafa nulë. Kwe bo some megali nolëyo, ëje mata sobo bobë gali saesogo sle elelëtëna. Goto some bubë maninibo nawa tëbo lowene mago wafi nëno tle. Na sobo tutune lowenena bume fwa lokwalëfe eletelome. Na sobobë lowene sle etomome. Na bu kë gali sle tëglebë wesibi fame fwa, afutukuna wege elekefëtëmome. ");
INSERT INTO nce_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","Melëme nëgeme. Goto some, bubë lowene esogo eglelëlobëme huhuju lalëtakefëyo. Na bu some afutuku lëlelëkefëyo na lalaitakefëyo, bubë tolewa esogo naeglelëtelobëme. ");
INSERT INTO nce_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","Na sobo iniwa wesibi melë kë egotomobë, sobo flalego tafa naeglelëmome. ");
INSERT INTO nce_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","16","Sobo melë egelona kwe sobo Gotobë nëbalemu tafa egelome. Na oneho some li fëye wesibiha hwi hana moglotëyome. Na Goto mata some li fëye wesibiha hwi hana loglotëyome. Na sobo Klaisbë lale gali egeholo sle elome. Na sobo ebë life mago tetëbo lowene kë esogo mëglelëkeflabë onehobë naba li mëta kilego tabo mëta lamo fene u elamë. Këme nëgeme, sobo melë egelona, na Klais onehome hwi sle loglomebë olë fata lëglena, na bu some li tëbo wesibiha hana hwi loglotëyona, kwe bo këme tako fleflesu nëgletëyome. Na kwe bo melowene nëgelëme, iniwa wesibi, bo sobobë ku mëta melë kë togotomëbë, blawa hana këkë telë. ");
INSERT INTO nce_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","Bo lowene hana nelë, Tokwafe ho bome mogo nalë tëkle mëgëtaname nawa o hanane nawa. Fëyeme tëkle mëgëtanamene. Melëme nëgeme bo Jisasbë gali të nëgëtagukefëtelëme nëgeme na sobo na fli enëne kë gali lowene sle egletelome nëgeme. Kwe melë nëgena kwe bo fleflesu nëgelëme. ");
INSERT INTO nce_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","Na sobo mata fleflesu elo, sobo bona fleflesu nëglame. ");
INSERT INTO nce_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","Tako Ho Jisas bu tole lëglena kwe bo Timotime sobelëme hokweinawa jine nëgelëbaklëme. Na ita bu bo betelë lisime, bu bome sobo kë tafa egelobë lowenebëme gali nalëglëkwakinëme. Na bo kë gali aholokwane nololëme na bo fleflesu nelëme. ");
INSERT INTO nce_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","Bobë li mëta, Timotiha ho li tafa hana lële. Weyewa. Timoti bu bona yonane sle nanelo na bona jowa lowene mëta fwa tafa nelo. Na bu some kë maninibo lëglekefëteyobë maninibo, bobë fene lëbe. Na bu some lëgaitome feilawa lowene lëlekefëtëyo. ");
INSERT INTO nce_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","Fli oneho, bume fwa lowene melekefëya. Na bu Jisas Klaisbë wege fabëme feilawa hana tole mletla. ");
INSERT INTO nce_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","Sobo Timotime wafi lowene eletelo. Bu lale homu na bu bume fwa lowene lëglebë lowenebë mëta hana lëtabe. Sobo bume walowene eletelo, bu bome Klaisbë lale gali të nëgëtatëmëbëme lalaitakefënë, nëba bolijayame fene laitakefle. ");
INSERT INTO nce_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","Këme nëgeme bo bume sobelë jine nëglëlëme këme tole nelë. Kwe bome kalabusu lo mëta fata gali kë lëgletenëbë wesibi afina lowene nëletelëme na bo Timotime sobelë hokweinawa mana jine nelëbaklëme. ");
INSERT INTO nce_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","Bo melowene nanelë. Tako Ho bome lëgaitanëme, na ho bome kalabusu lo mago jine mëglëname nounou. Na bo mana sobelë nigisime. ");
INSERT INTO nce_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","Bo Timotime tokwafe jine nëgelëbaklëme kwe ebë olëna bo melowene nanelë, bo sebobë afame, Epafroditusme afina sobelë jine nelëbaklëme. Bu bona Klaisbë lale gali wegeme wege nelo. Na Klaisbë lale gali të wegebë hobota weife fa notokweflo. Sobo bome lëgaitanëbëme kë jine tëgelëbaklobë. ");
INSERT INTO nce_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","Bu some tako maninibomu lalëletëyo. Na some hwime tolemu lalëletëyo. Na bu melowene lalële, sobo bubë gali waaholokwane tletelo, bu tëbo latle. Na kë lowenebë, bu some maninibo lëgletëyobë lowene, bubë lowene mëta takomu lëbetle. ");
INSERT INTO nce_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","Nëgalimu. Ëbame bu tëbo latle na gli lëgleme kofene. Kwe Goto bume maninibo tletle. Na bume gli afe kë tëglebë mago sle totle. Na Goto bume fwa nane maninibo tletle. Weye. Bu bome mata maninibo latletenë, Epafroditus gli lëglebë welili bome boblo lëgëtanëlime. ");
INSERT INTO nce_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","Bo bume sobelë jine nëgelëbaklëme tole nanelë, sobo bume ita hwi naeglolome na fleflesu eletelome. Epafroditus sobona tafa egelona, sobobë maninibo lowene mana satli lëbetëyome na tafa sle elome. Melë nëgena, kwe bobë maninibo lowene mata tli lëgëbetenëme na tafa sle nelëme. ");
INSERT INTO nce_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","Sobo Epafroditusme, Jisasbë wenijina no elëlome na fleflesu eletelome. Na sobo këha home mata mefë naegotomome, “Lale homu.” ");
INSERT INTO nce_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","Bu Jisas Klaisbë wege fa togotlena, ëjeha gli lëleme. Kwe bu bume fwa nane lowene tle. Weye. Bome tegaitanëbë wegeme fwa, sobo kë jine tëgelëbaklobë wegewa lowene sle tletle. Sobo kakë tafa egulome nëgeme na sobo bome habëna egaitanamene? Këme nëgeme bume këme jine telëfaglo bo belë. ");
INSERT INTO nce_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","O Kristen afani na oneglëni. Bobë lowene mëta li gali mana lëbe. Kë galibë melë. Klais somëta walëtabetëyo, na sobo bume fwa safleflesu eletelo. Autome bo some gali li, pasë mëta wayahi tletëyo. Na bo kë gali some ita yahi nëgleteyobëme, kokasa hana nelë. Ebë gali some lëgaito sle nalëgleme. Ho some sogëna moglëyolime. Ebë gali melë. ");
INSERT INTO nce_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","Ato jibo tëtlë gali kë të motokweflabë enënebëme ululu sle saelo. Kë enëne kë nëgebë fifli tabo amale fenene. Sobo bubë gali asa aholokwane elomo, sobobë lale lowene hihijika mëgletëyolime. Kë tëbo enëne megali lamëlekefëya, “Sobo Judabë afenëbobë tafa sle gali iniwa esogo jwa eglelëlona na ato jibo tëtlë jwa egotomona kwe Goto some lale oneho fë hana logotome.” ");
INSERT INTO nce_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","Kë enëne bu Gotobë nëbalemu nane. Weye. Kwe sebo kwe, Jisasme kë lowene sle nëgletlabë enëne, sebowa, Gotobë nëbalemu tafa nëla. Gotobë Amtëtombabë afutukuna, sebo Gotome lotu nëlekefëtla na Jisasme mata fleflesu nëlekefëtla. Sebo melowene nanëla, sebo ato jibo kë tëtlë notomabë, kë wesibi, seme Gotobë naba lime lale tafa sle nëglabëme hana lëgaitaname. ");
INSERT INTO nce_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","Sobo aholokwane elo. Ato jibo tëtlë gali kë të motokweflabë enëne bu metëtane lamelekefëya. Sebo Judabë afenëbobë tafa sle gali feilawa esogo sle nelelëkefla na ato jibo tëtlë lowene mata esogo nelelëkefla. Na këbë lowene seme Gotobë naba lime sle mëtakefëna. Kwe këbë lowene onehome, Gotobë naba lime tafa sleme mëgaitamena, kwe bo feilawamu tëtane nëgebëmemu na ato jibo tëtlë gali kë të motokweflabë enëneme boblomu nogotomëme. ");
INSERT INTO nce_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","Bo ëtani kë esogo tëglelëlëbë lowene, sobo lowene laletelo. Ëtani beë bome kë fu tetanëbë, tobali ita aona olë tafa tlenënë na bu bobë ato jibo mana tlë mëtëtatëna. Bo Israelbë afenëbomu na bo Benjaminbë afenëbo mëta fata telë. Bobë ayana beëna bu Judabë afenëbo. Na bo Judabë afenëbo mago këme tafa nelë. Bo sigli telë na bo Farisi lotu eso enënebë lowene esogo tlelëtëmë. Na Mosesbë tafa sle anebo gali esogo tlelëlëmu. ");
INSERT INTO nce_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","Bo Gotobë wege fame feilawa afutukumu telë. Këme nëgeme, ëtani bo Jisasme kë lowene sle mëtletlabë enëneme, feilawamu wame tlomë. Oneho bome Mosesbë tafa sle gali esogobëme, hwi moglonana kwe bome li tëbo wesibiha hana hwi moglotëname. ");
INSERT INTO nce_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","Ëtani bo meweniji latelë, këbë lowene lalowa lëbewa. Bo meweniji latelë, kë iniwa lowene esogo neglelëmëna, bo Gotobë naba lime lale ho tafa nëgelëmefe. Kwe bo Klaisme yafe lowene sle tletelë na ëje bo ëtanifu lowene, tëbo wesibi fene mehwi nanolomë. ");
INSERT INTO nce_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","8","Bo Judabë afenëbobë tafa sle galime fwa nane gali nelë. Weye. Iniwa wesibi bo ëtani melë kë tëgelëbë, bo mewenijiwa latelë, Gotobë naba lime lalowa nëgelëmewa. Kwe bo ëje kë wesibi kleli kibo fene mehwi nanolomë. Bo Klais Jisasme melowene sle nëgletelëme nëgeme, bu bobë Tako Ho. Na bo kë loweneme fwa melowene nanelë, nëgali wesibimu. Bo kë iniwa tëbo lowene wahune telë, Jisasme fwa lowene slemu nanëkaketelëme. ");
INSERT INTO nce_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","Na bo bunamu lesili sle nanëgelome. Ëtani bo melowene latelë, bo Judabë afenëbobë tafa sle gali esogo neglelëlëna, kwe bo Gotobë naba lime lale ho fata nëgelëmewa. Kwe ëje bo kë lowene hana nelë. Weye. Ëje bo melowene nanelë. Sebo Jisasme fwa kë lowene nëgletlabë oneho, Goto seme mefë këme lëtana, “Lale oneho.” ");
INSERT INTO nce_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","Bo metole nanelë, Klaisme lowene slemu nanëgletelëme. Goto bubë tako afutukuna Klaisme matëmatë mago huju totle. Na bo metole nanelë, bo kë afutukuna tafa nanëgelëme. Bo metole nanelë, Klais seme taitanabëme elili fene fa totle, bo mata bubë wege kë fa nogotlëbë mëta, këha elili mefa nogotlëme. Na bu fene gli tle, bo megli nëgelëna, kë kwe lalowa. ");
INSERT INTO nce_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","Bo këha lowene mëta tafa nëgelëna kwe bo melowene nanelë Goto bome mata matëmatë mago huju lëgëtanëme. ");
INSERT INTO nce_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","Bo melowene hana nelë, bo Klaisbë lowene iniwa wafa totlë na bo lale homu tafa nelë. Weyewa. Kwe Klais bome buha fatabëme këaniji toglonëbë, ëje bo këha fatame feilawa afutuku nëlekefëmu. ");
INSERT INTO nce_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","O Kristen afani na oneglëni. Bo melowene hana nelë, bo Klaisha wafata nelë. Weyewa. Kwe jowa lowenewa lebetenë. Kë lowene melë, bo ëtani kë fa togotlëbë wesibi aholokwana ti sle nanëgelëme na tokwafe fa nogotlëbë wesibime fwa feilawa afutuku nanëgelëme. ");
INSERT INTO nce_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","Bo wege toula elëme fwame feilawa afutuku nelë, na kë wege toula mago wesibi fa nanogotlëme. Kë wesibi melë, Goto bome megali lolonë, “Ju bona heven life mëta ëhwati tafa nëgelome.” Klais ti mëta gli tle seme lëgaitana nalëgleme na nëno lëleme. Këme fwa nëgeme, Goto buna heaven life mëta ëhwati tafa nëgelome këme gali tle. ");
INSERT INTO nce_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","Sebo Gotome lowene nëgletlabëme. Na kë letitabo nëgletlabë ho, sebo iniwa jowa lowenewa neholame, na wege toula elëme fwame, feilawa afutuku nëlame, bo ëje fene gali nelë. Kwe somago fli, li lowenena nëgena kwe Goto some lale lowene lebotane lëtatëyome. ");
INSERT INTO nce_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","Kwe tako wesibi melë, sebo kë esogo nëglelëkeflabë lale lowene, Goto seme kë lebotane tëtatënabë, kë lowenebë nëgehola sle nëglame na aholokwana asa ti manëla. Weye! ");
INSERT INTO nce_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","O Kristen afani na oneglëni, sobo iniwa, bo kë esogo neglelëkeflëbë lowene saesogo elelëlo. Sebo sobona kë tafa tëglabë, sobo sebo këtafa tëglabë lowene wahwi tlotëna. Na sebobë lowene kë esogo mëglelëlabë onehobë lowene, hwi sle eletemome na sobo bubë lowene esogo elelëtemome. ");
INSERT INTO nce_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","Bo some itaita gali wafi tlëyo na ita bo some nabatuna ekë gali nolëyo. Lebutako enëne tetëbo lowene esogo mëtlelëla na kë lowene seme melë lebotane lalëtana, bu Klaisme wame lamolola. Na Klais ti mëta seme tegaitanabëme, këgli tëglebë wege, tëbo namëgëtatlame fene. Bo kë enënebë lowene wafi hwi nolotemë. Bu sobobë lale lowene tëbo nametateyome. ");
INSERT INTO nce_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","Kë enëne, bubë ato kë tole mëgletëmebë lowenewa esogo esogo melelëkefëma na këbë ato tole lowene bubë Goto fene mefata lamëlekefëtëme. Kë enëne ebë life mago wesibi fame fwa lowene melekefëya. Na bu ebë life mago tiniji wesibi fame fwa tako fleflesu lamelekefëya. Goto këha enëneme hel life mëta tëbo logotomememu. ");
INSERT INTO nce_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","Kwe sebo, Jisasme kë lowene sle nëgletlabë enëne, sebo këha enëne nane. Weye. Sebo kwe heven life mago enëne. Na ëje sebo Tako Home Jisas Klaisme hwi nëletla, bu heven life kile loleme na seme nënome letujuleme. ");
INSERT INTO nce_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","Klais, bubë afutukunawa, iniwa wesibi melë logotomeme, bubë lokwalëfe mëgëbetleme. Kë afutukunawa, bu sebobë tëbo ato jibo hihijika lëletëname na sebobë ato bubë lale ato fene mefata mëletëname. ");
INSERT INTO nce_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","O bobë Kristen afani na oneglëni, sobo tako hobë lowene esogo elelëtelome na kë lowene mëta fwa satafa elo, bo ebë pasë fene yahi nëletëyo. Bo some tako tolemu nanëletëyo. Bo sobobë weniyane hwi jwa noglometëyome nëgeme, na bo some këme maninibo nëlekefëtëyo. Bo sobo kë tafa egelobë gali yafe aholokwane telë na bo tako fleflesumu mëtletëyo na bo melowene latelë, Goto some metëglënëlatle, lale wesibimu fenene. ");
INSERT INTO nce_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","Yuodia na Sintike, sobo tlemalë one aholokwane elo. Sobo Tako Home wafi lowene sle eletelo na sobo bubë lowene mëta weife tafa elo. Këme nëgeme sobolalo momata asa elelëkoiyo. Sobo jowa lowenewa saeholo na sobolalo yonane sle elome. ");
INSERT INTO nce_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","Na ju bona weife kë wege nëgelobë ho, bo jume gali nolë, ju kë tlemalë oneme, lale galina sasle etome, bu yonane sle namëgelome. Tlemalë bonamu kahwë sle latla, Jisasbë lale gali asë tëglelëtlabëmë. Klemen na bobë fli weife wege enëne mata bona kahwë sle latla, Jisasbë lale gali asë tëglelëtlabëmë. Kë enënebë weniji, Gotobë ëhwati bogo mëta mëbetëme. ");
INSERT INTO nce_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","Sobo Tako Hobë oneho etabo, ta sobo këbëme safleflesu elekefo. Bo some ita ekë gali nëlëyo, sobo fleflesu elo. ");
INSERT INTO nce_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","Sobo iniwa onehome alabujuwa tafa lowenena satafa elelëmo na bu melowene namëgletëyome sobo këha enëne. Sobo aholokwana asa ti elo, Tako Ho ligisi olë nounou ekë lëletle. ");
INSERT INTO nce_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","Sobo li wesibimeha asa tutune elo. Weye. Sobobë iniwa hobotame, Gotome fwa sagali elokweflo. Sobo Gotome fwa gali elokweflome na sobo bume itaita megali elokweflome, “Yahala fëyemene” na some lëgaitobëme takune elokweflome. ");
INSERT INTO nce_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","Sobo melë egelona kwe Goto sobobë maninibo tli lëtakefëtëyome. Sobo Klaisme lowene sle egletelome nëgeme, Goto sobobë maninibo këme tli lëtakefëtëyome. Goto seme flalego lowene kë lëlëkefënabë, bu lale wesibimu. Na sebo kë wesibi esobëme habëna lowene nëgletlamene? ");
INSERT INTO nce_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","O Kristen afani na oneglëni, bo some li galime gali nolëyo. Sobobë lowene nëgali lowenename lale lowenename fwa salowene elekefëtemo. Na onehobë naba lime tafa sle egelobë lowene, na fleflesu kë egelobë lowene, na onehome yonane eglelëmobë lowene salowene elekefëtemo. ");
INSERT INTO nce_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","Iniwa wesibi bo some kë okokwe toglëyobë, sobo kë wesibiwa saesogo elelëmo. Sobo bome wahwi tlona na iniwa wesibi bo fene telë sobo mata melë saelo. Sobo melë egelona, kwe sobobë flalego tafa eso ho Goto lëtabetëyo, sobona tafa egelome. ");
INSERT INTO nce_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","Sobo bome egaitaname ita lowene telo. Këme nëgeme bo Tako Home tako fleflesumu nanëletelë. Ëtani sobo bome tegaitanabëme lowene latlekefo kwe alëge hanane. ");
INSERT INTO nce_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","Bo ebë galime kë gali nëgelëbë melëbëme nane, bo wesibime afolo nëletelëme. Weye. Bo alabujuwa tafabëme, wafi lowene nelë. Bo hobotana o hobota jwa tafa nëgelëna o wesibina o wesibi jwa tafa nëgelëna, bo këme hobota hana nëgelëme. Bo këha lowenebëme alabujuwa kaiselo tafa nëlekefë. ");
INSERT INTO nce_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","Bo wesibi jwa ho tafa nëgelëna o bo lebutako wesibina ho tafa nëgelëna bo alabujuwa kaiselo metafa nëlekefë. Bo hi wesibina nëgena o bo hi wesibi jwa nëgena bo alabujuwa kaiselo metafa nëlekefë. Bo alabujuwa tafa lowene wafi lowene sle nëletelë. Iniwa wesibi bome kë fata mëglekefëtenëbëme bo alabujuwa tafa lowene wafi lowene sle nëletelë. ");
INSERT INTO nce_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","Klais bome afutuku lalëlelëkefënë na iniwa wesibi bome kë fata mëglekefëtenëbë, bo kë afutukuna alabujuwa kaiselo metafa nëlekefë. ");
INSERT INTO nce_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","Bo hobota kë fa notokweflëbëme, sobo bome kaiselo aitakefëna. Yahala fëyemene! Bo këbëme tako fleflesumu nanëletëyo. ");
INSERT INTO nce_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","O Filipai lifate mago Kristen oneho, sobo wafi lowene elo, bo Jisasbë gali të wege somëta afina të totlë. Na sobobë Masedonia provins kile telë na li life li lifewa të tetagulëna, kwe kë mago Kristen enëne balitina hana mëtaitana. Weyewa. Sobowamu aitana. ");
INSERT INTO nce_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","Bo Tesalonaika lifate mëta tafa tëgelëna kwe sobo bome aholokwana hana ti telo, sobo bome balitina itaita lataitana. ");
INSERT INTO nce_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","Sobo bome melowene asa eletëna. Some balitime ita takune noglëyome. Weye. Kwe some melëme tole nëletëyo. Sobo onehome agaitamobë lowene, Goto hwi lolotëyome na some fleflesu lëletëyome na ululu sle lëtome. ");
INSERT INTO nce_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","Sobo melowene egelome, iniwa wesibi, sobo bome Epafroditusbë tobame kë tëgelëbakënabë, bo kë wesibi wafi glo telë. Ëje bo lebutako wesibina tafa nelë. Bo li wesibimeha hana afolo nëletelë. Sobo bome kë tëgelëbakënabë wesibi ebëha, ho kleli Gotome, fene ahojume lëletle, lale sinikibo hëhë nalëgletleme na Goto bume fleflesu lëletleme. ");
INSERT INTO nce_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","Bo kë lotu nëgletelëbë Goto, bu iniwa lale wesibina lëtabe. Sobo Jisas Klaisme lowene sle egletelobë oneho nëgeme, këme fwa Goto some iniwa wesibi sobo kë afolo egletelobë some lëglëyome. ");
INSERT INTO nce_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","Goto, bu sebobë Goto na sebobë Aya. Sebo bume iniwa olë fleflesumu nëglekefëtlame, bu Tako Homu nëgeme. Nëgali mu. ");
INSERT INTO nce_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","Sobo Jisas Klaisbë onehome bobë sësle gali gali nolëyo. Na bona kë tafa nëglabë afani mata some sësle gali gali mëlëyo. ");
INSERT INTO nce_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","Iniwa Jisasbë oneho ebë lifate mëta kë tafa mëglabë, some sësle gali gali mëlëyo. Na Jisasbë oneho, eso ho Sisarbë lo mëta kë wege mëglabë, bu mata some sësle gali gali mëlëyo. ");
INSERT INTO nce_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","Bo metole nanelë, Tako Hobë, Jisas Klaisbë maninibo somëta lëbeteyome na some laitome. Ta tei. ");
INSERT INTO nce_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","Bo Pol, Sailas na Timoti, sebo aomalë, pasë some, Tesalonaika lifate mago Kristen onehome, ekë yahi nëletëyo. Sobo aya Gotobë na Tako Ho Jisas Klaisbë oneho. Bo metole nanelë, Goto na Tako Ho Jisas Klaisna bubë maninibo lowene matlëyo na flalego tafa naegelome. ");
INSERT INTO nce_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","Sebo Gotome fleflesuna gëgali nelelëkefla sebo some lowene nëglekefëtëyome nëgeme. Sebo some lowene nanëlekefëtëyo Gotome gëgali nëglelëkeflana. Some aholokwana hana ti nëlekefëya. ");
INSERT INTO nce_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","Sebobë aya Gotome kë gëgali nëglelëkeflabë, sebo some ebë wesibibëme lowene nëlekefëtëyo. Sobo Jisasme kë lowene sle egletelobë lowene, some lale wegebëme huju lëtakefëyo. Sobo fli enëneme tole egletemome nëgeme na bume aitamobë wegeme këme afutuku elekefo. Sobo Tako Ho Jisas Klaisme melowene sle egletelome, tokwafe seme nënome ligisime. Iniwa hobota some kë fata lëglekefëtëyobë, këbë lowene bu some laitakefëyo, sobo tafa sle naegëlobëme. Na këme nëgeme, sebo Gotome këme fleflesu nëlekefëtla. ");
INSERT INTO nce_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","O Kristen afani na oneglëni, Goto some tako tolemu lalëletëyo. Na sebo some melowene nanëletëyomu, Goto some wafi aniji tolëyo, bubë enëne egëtabetelobëme. ");
INSERT INTO nce_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","Jisasbë lale gali, sebo some kë tëgehitëyobë, somëta galiwa nane tisitëyo. Weye. Bu afutukuna Gotobë Amtëtombana iniwa tisitëyo. Na sebo Jisasme kë lowene sle nëgletlabë lowene, sobo hwi sle tlometëna. Na sobo seme melowene tletëna, sebo kë të togotlabë lale gali, sebo melowene slemu nanëletla, nëgali gali mu. Sebo sobobë ku mëta kë tafa tëglabë lale tafa, wafi hwi tlotëna. Sebo melë kë tëglabë, Jisasbë lowene esogobëme, some lebotane tëtatëyo. ");
INSERT INTO nce_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","Sebobë tafa fene tëbekefëtëna, sobo këha tafa esogo tlelëkeflo. Na Jisasbë tafa fene tëbetle sobo këha tafa esogo tlelëkeflo. Sobo Gotobë lale gali yafe aholokwane telo na esogo tlelëlo. Na fli oneho some mana kë wame motlëyo na lebutako tëbo wesibi some mana fata mëtletëyo, kwe sobo këbëme welili hana telo. Weye. Gotobë Amtëtomba some lataito na sobo Gotobë lale gali fleflesuna aholokwane tletelo. ");
INSERT INTO nce_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","Këme nëgeme, Jisasme kë lowene sle mëglekefëtlabë oneho, Masedonia provins mëta na Akaia provins mëta kë tafa mëglabë, sobobë kë lale tafa hwi motloteyome nëgeme na bu melowene mëtlame, bubë lale tafa fene lëbetëme, sebo mata këha tafa manëla. ");
INSERT INTO nce_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","Tako Hobë Jisasbë gali, sobo kë të togotlobë, kakëmu metugujutëyo latle, fwamo lego fene tiwatëyo. Na kë galibë, Masedonia provins magowa na Akaia provins magowa nane aholokwane motokouja. Weye. Sobo Gotome kë lowene sle egletelobë gali, iniwa life mago oneho mata aholokwane lamotokouja. Këme nëgeme, kë galibë, ita hana gali nëglame. ");
INSERT INTO nce_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","Sebo sobelë kë tigisiyabë, na iniwa wesibi kë fata mëtlebë, oneho kë gali buwa të mëtëtagula. Bu some gali metë lametakefëtëyo, sobobë iniwa fëso fëso lowenebë aholokwana ti telo na unalëme lëgëtabebë Gotome fwa lowene eletelome na bume fwa tafa eletelo na bubë wege enëne tafa elo. ");
INSERT INTO nce_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","Bu seme mata megali motlona, Sobo Gotobë Nëbame melowene egletelome, bu heven lifate kile luguleme na ita lisime. Jisas bu seme, bubë glina Gotobë enisusu mago wafi nëno tle. Tokwafe Gotobë enisusu ligisina sebo nëgëtabëya sle nanëglame. ");
INSERT INTO nce_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","O Kristen afani na oneglëni, sobo seme walowene eletëna sebo sobelë kë tigisiyabë këbë asëbë tuwati asë nane. ");
INSERT INTO nce_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","Sobo seme wafi lowene eletëna. Sebo sobelë tigisiya jwa tëglana, Filipai lifate mëta sebo aomalë tako elili fa totlamu, na seme tako lëlafa lamëtëtanamu. Na sebo tako elili kë mëta fa totla. Na sebo sobelë kë tigisiyabë, Filipai lifate mago enëne fene wame motlona bu seme melë lamëtëtana. Kwe sebobë Goto, sebobë lowene afutukumu latlelëmetëna na sebo këbë wamebë kikli hana tëkaketlamu na sebo mana Gotobë lale gali të tëtatëyo. ");
INSERT INTO nce_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","Sebo some, Jisasme lowene sle egletelobë galime, gali tolëyona, këbë mëta yaya galiha hana gali tla. Sebo some meyaya lowenena nane tisitëyo, sebo sobobë wesibi manawa glo nanëgletëyome. Weye. Na sebo some sogëna sogëname nane tisitëyo. ");
INSERT INTO nce_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","Weye. Goto sebobë lowene wahwi sle tlotëna, na bubë tolenawa seme Jisasbë lale gali tëbë wege tlëna. Këme nëgeme sebo melëme nane wege nëla, oneho sebobë wegeme na fleflesu mëgletëname. Weye. Sebo metole nanëla, Goto sebobë lowene hwi loglomeme, na sebobë wege buwa fleflesu lëletleme. ");
INSERT INTO nce_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","Sobo wafi lowene tletëna sebo sobobë lowene lale lale galina hana sisile totometëyo. Weyewa. Na sebo lale lale galime mata gëgali hana tla na sebobë mëmaune lowene këna lëlamu notlame. Weye. Goto bu mata kë wesibime walowene lëletëna. ");
INSERT INTO nce_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","Sebo kë wege kë fa nogotlabë, sebo melëme nane fa notla, sebo fli enëneme flesu ho fata nanëgletëmame o sobo seme flesu ho fë naetaname. Weye. ");
INSERT INTO nce_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","Sebo Jisas Klaisbë ëfalëbo enëne nëtabetla na sebo flesu enëneha këme nëtabëya. Këme nëgeme, sebo metole nëglabë kwe, some megali noglëyome fene, “Sobo seme aitana.” Kwe sebo some megali hana tlolëyo. Weye. Sebo somëta kë tafa tëglabë, flalego tafana tafa tla nëbale tokwëtokwë fenene. ");
INSERT INTO nce_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","Sebo some tako tolemu latletëyo. Këme nëgeme Gotobë lale gali some fleflesuna këme tlëyo. Sebo some Gotobë lale galiwa nane tlëyo. Weye. Sebo iniwa wesibi melë nëglabëme, wafi sagli tlëla, some nëgaito nanëglabëme. Sobo sebobë yabenimu tafa tëgelome nëgeme. ");
INSERT INTO nce_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","O kristen afani na oneglëni, sobo wafi lowene elo. Sebo somëta kë tafa tëglabë na Gotobë lale gali kë të tëtatëyobë, sebo baliti glo wege mata anisasanamu fa totla. Melëme nëgeme, sebo wesibi kë balitina glo nanëglekefëyame, some sosalë nëgëtolime. Këme nëgeme, sebo olëna klabëna sebobë tobana këme wege tlekefëya, sobo seme wesibime egaitanalime. ");
INSERT INTO nce_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","Sebo somëta kë tafa tëglabë loweneme, sobo walowene eletëna na Goto mata seme lowene lalëletëna. Sobo, Jisasme kë lowene sle egletelobë onehobë ku mëta, tafa tëglana, sebo Gotobë naba lime, lale tafawa latla. Na sebo li wesibiha kë mëta hana tëbo totla. Weyewa. ");
INSERT INTO nce_vpl VALUES ("H12_11","082_2_11","1TH","2","11","11","Sobo seme lowene laletëna. Bolijaya bubë nëbaleme fene laitame, sebo some melë tegaito latla. ");
INSERT INTO nce_vpl VALUES ("H12_12","082_2_12","1TH","2","12","12","Sebo melë latla, sobobë lowene tufiji tëgëtatëyobë gali tolëyo, na sebo some tegaito gali mata gali tolëyo. Na sebo some anisasana megali tolëyo: “Sobo Goto kë tole lëgletlebë tafana satafa elo. Goto bu some wawe tolëyo, bu eso home kë tafa lëgletëmebë oneho belë naekaklijome. Na bubë onehona iniwa lale tafa naegelome.” ");
INSERT INTO nce_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","Sebo itaita kë wesibime mata Gotome fleflesu galina gali nolokwefla. Sebo some Gotobë gali alako të tëtatëyona sobo melowene hana telo, hobë gali. Weye. Sobo melowene latelo, Gotobë nëgali galimu. Nëgali, kë gali ebë Gotobë gali. Na kë galiwa, sobo Jisasme kë lowene sle egletelobë lowene, buwa sle lotokwefëmetëyo. ");
INSERT INTO nce_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","O Kristen afani na oneglëni, Jisas Klaisme kë lowene mëgletlabë oneho, Judia provins mëta kë tafa mëglabë fenene, sobo mefata lalo. Sobobë yabenino, some tëbo lamëtakefëo. Israelbë afenëboni, bu Jisasme kë lowene sle mëgletlabë onehome, Judia provins mëta kë tafa mëglabëme, fene tëbo motokwefëma. ");
INSERT INTO nce_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","Kë Israelbë afenëboni, Gotobë ëfalëbo mago gali ëtani anebo kë mëtehilabë home mogo nalë tëtëkle mëtëtakefëya. Na bu mata, Tako Home Jisasme mogo nalë tëkle mototla. Na bu seme mata hehë mëtletëna. Bu Goto kë tole lëgletlebë lowene boblo mëtakefëtla. Na bu iniwa onehome wame molokwefëma. ");
INSERT INTO nce_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","Kë Israelbë afenëboni seme yafe lëkle mëtëtakefëna, Goto onehome tafa sle logotomebë gali, Israelbë afenëboni mëtabëya jwa kë mëglabë enëneme, të jwa nanëtatëmame. Bu melëme tole jwa mëtëglame nëgeme, Israelbë afenëbo metabëya jwa kë mëglabë onehome Goto nëno lëgoukëfelime, seme këme lëkle mëtakefëna fene. Bu tëbo lowene feilawa fafa motokwefla na kë tëbo lowene bubë ëtanifu tëbo lowenena iniwa loko lokweitëmeme. Këme nëgeme, Gotobë enisusu bume wafata tletëme na tëbo logotomeme nounou lalële. ");
INSERT INTO nce_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","O Kristen afani na oneglëni, ëbame Israelbë afenëboni seme somago heheë mëtletëna. Na kë afolo olëna, sebo some maninibo latletëyo, bolijaya nëbale kakë tafa moguletlabë fenene. Sebo sobobë weniyane hwi hana nolometëyo kwe sebobë lowene somëta mana lëbetëna. Këme nëgeme sebo alëge feilawa hohwi këme nëtakefëtla, so betelë ita nigisiya nanëglame na some ita hwi nanoglëyome. Sebo some ita hwime tako tolemu nanëla. ");
INSERT INTO nce_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","Sebo sobelë nigisiyame tole nanëla. Na bo Pol, bo sobelë nigisitëyome yafe yafe nanëlekefë. Kwe Satan seme lëkle lalëtakëfëna, na sebo sobelë nigisiya jwa këme nëla. ");
INSERT INTO nce_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","Unina, sebobë Tako Ho Jisas, ita ligisina, seme fëye wesibi, afutuku lëglelënamene, na sebo këna bubë naba lime fleflesuna nilibetlame. Sebo bume fëye wesibi lebotane nëgëtatlamenë bu melowene nalëgletëname, sebo bubë wege, wege sle latëtatla. Sebo kwe some fwa fleflesu nëletëyome. Na some fwa lebotane nëtome. ");
INSERT INTO nce_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","Nakwefëyemene, sebo some fleflesu nanelekefëtëyo na lëlou nëlekefëteyo. ");
INSERT INTO nce_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","Na kwe, sebo Atens life mëta tafa tëglabë, sebo some ita tako maninibomu latletëyo na melowene tletëyo, sebo some ita hwi nëglëyobëme, tako tole latla, këme nëgeme sebo hwi hana tla. Na sebo melowene tla, sebo Sailasna, Atens life mëta tafa nelome. ");
INSERT INTO nce_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","Na Timotime sobelë jine nelëbaklome. Bu sebobë Kristen afa na bu Gotobë wege ho na sebo Gotobë wegeme ilawa wege nëla, Jisas Klaisbë lale gali ilawa të nëtagula. Sebo bume sobelë jine tlëlo, some lëgaito nalëgleme, Jisasme kë lowene sle egletelobë lowene, esogo sle naeglelëtelome. ");
INSERT INTO nce_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","Na su wesibi some kë fata lëgletëyobë, somago fli tutune egelolime na Jisasme kë lowene sle egletelobë lowene kile egelolime. Sobo lowene lalo, seme ebë su wesibi kë fata mëgletënabë Gotobë toleme fata mëletëna. ");
INSERT INTO nce_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","Sebo sobona mana tafa tëglana, sebo some megali latlëyo, “Tokwafe seme lili hobota fata mëgletëname.” Na sobo melowene wafi eletelo, sebo fene gali tolëyo, kë tëbo olë seme wafata lëletëna. ");
INSERT INTO nce_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","Bo melowene hana tletëyo, sobo Jisasme kë lowene sle egletelobë lowene mana eholo o hanane, na bo feilawa mehwi hana tëtëkakë. Këme nëgeme bo Timotime sobelë këme jine telëbaklë. Bo metutune tëgelëme nëgeme, Satan some susu lëgëtolime na sobo Jisasme kë lowene sle egletelobë lowene aholokwana ti egelolime. Na sebo somëta kë wege tëglabë wege manawa tëbo lëgletënalime. ");
INSERT INTO nce_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","Kwe Timoti sobona tafa tulo na some hune tuto na bu se mëta tokwafe fata tëkaki. Na sobo kë tafa egelobë lale gali seme të tëtatëna. Bu some megali latletëyo, “Sobo Jisasme feilawa mana lowene sle elekefëtelo. Na sobo fli onehome mata mana tole elekefëtemo. Na sobo seme mana lowene elekefëtëna, na fleflesu lalekefëtëna. Sebo some hwi nanogloyome fene maninibo nëlekefëtëyo, sobo mata seme hwi naegloname memaninibo lalekefëtëna.” ");
INSERT INTO nce_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","O Kristen afani na oneglëni, ho seme kë wame moglonabë, sebo kë wesibi mëta nëtabëya. Kwe sebo some meaholokwane latleteyo, sobo Jisasme feilawa mana lowene sle elekefëtelo, na këbëwa seme taitana na sebobë lowene sle tëtatëna. ");
INSERT INTO nce_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","Sebo ebë gali meaholokwane tla, sobo Tako Home Jisasme mana lowene sle elekefëtelo. Na sebo flalego tafana këme tafa nëla. ");
INSERT INTO nce_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","Sebo some Jisasme kë lowene sle egletelobë loweneme, lowene nëletëyo, na sebo Gotome fleflesu galina gali nanolokwefla. Sebobë Gotobë naba lime, sebo feilawamu fleflesu nëla. Na kë fleflesu galibëme Gotome habëna gali noglolamene. ");
INSERT INTO nce_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","Sebo klijina klabëna, Gotome itaita metakune nanolokwefla, bu seme lëgaitana nalëgleme, some hwibëme nigisiteyo nanëglame. Na sobo Jisasme kë lowene sle egletelobë loweneme afolo egletelona, kwe sebo some nanëgaitome, sobo Jisasme feilawa lowene sle naegletelome. ");
INSERT INTO nce_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","Sebo metole nanëla; sebobë aya Goto na sebobë Tako Ho Jisas Klais, sebobë alëge sle nalëtatëname, sebo some hwime nigisiya nanëglame. ");
INSERT INTO nce_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","Sebo metole nanëletëyo. Tako Ho Jisas, fli onehome tole egletemobë lowenebë, some feilawamu lëglëyome. Na sobolalo feilawa tole eglelëgome na iniwa onehome mata tole eletemome, sebo some fene tole nëletëyo. ");
INSERT INTO nce_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","Sebo metole nanëla, Goto këbë lowenena, sobobë lowene lëgaitatëyome. Na sebobë Tako Ho Jisas, bubë onehona iniwa ita migisiyana, kwe Jisas some ëhwati tafa hwi egletelobë oneho hwi lëglëyome na sobo lale oneho egëtabome. Na kwe sebobë aya Gotobë naba lime, tëbo wesibiha hana lëgebetëyome. ");
INSERT INTO nce_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","O Kristen afani na oneglëni, sebo some Gotobë tole esogo eglelëlobë lowene iniwa wafi okokwe tolëyo. Na sobo kë iniwa lowene esogo elelëkeflo, sebo fene gali tolëyo. Kwe sebo ëje some, Tako Ho Jisasbë wenijina megali nanolëyo, sobo kë lowene anisasana itaita saesogo elelëkeflo. ");
INSERT INTO nce_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","Iniwa gali, sebo Tako Ho Jisasbë wenijina kë gali toglëyobë, sobo walowene sle eletelo. ");
INSERT INTO nce_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","Gotobë tole, melëgëbetle lalële: Sobo iniwa tetëbo lowene aholokwana ti elome na ëhwati oneho etabome. Sobo iniwa lisë lisë loweneme hëhele, egelome na aholokwana ti elome. ");
INSERT INTO nce_vpl VALUES ("H14_4","082_4_4","1TH","4","4","5","Sobo, jowa jowa, lisei lowene, sobobë lowene mëta kë mëgebebë lëlë etokwefëmome. Sobobë lowene, one mëmaunebë lowene mëta asa gwa etokweflo. Na bume lisei lisei eglelëmobë lowene asa huju malëletëyo. Weye. Këha tole asa esogo elekeflo, Gotome lowene jwa mëgletlabë oneho fene melekefëya. Sobo Goto kë tole lëgletëmebë lale lowenewa esogo elelëkefëtelome. ");
INSERT INTO nce_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","Sobo Kristen afanime na oneglënime sosogëna asa elëmo na bubë ho o mëse liseë nabana hwi elotleme. Sobo melë egelona kwe sobo bume tëbo lowene mëta gogwa egelome. Ëtani sebo some anisasana megali latolëyo, “Iniwa ho bu këha wesibi mëglabëme, Tako Ho Goto, bume tëbo logotomememu.” ");
INSERT INTO nce_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","Goto seme lisë lowene esogo nëglelëlabëme nane aniji tlona. Hanane mu. Bu seme kë aniji toglonabëye melë: sebobë lowene bume nëglëla nanëglame na ëhwati lowenewa, esogo nanëglelëlame. ");
INSERT INTO nce_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","Këme nëgeme, ho ebë gali boblo logotlena, kwe bu hobë galiwa nane boblo lëtatëme. Weye. Bu Gotobë gali boblo lëtatle, some bubë Amtëtomba kë lëglëkefëyobë Goto. ");
INSERT INTO nce_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","Sobolalo kë yonane eglelëgobëme, hana yahi nëgletëyome. Melëme nëgeme, Goto some onehome yonane eglelëmobë loweneme wafi okokwe tolëyo. ");
INSERT INTO nce_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","Na ebë bu nëgalimu; sobo Masedonia provins mëta kë tafa mokoujabë Kristen onehome tole lalekefëtemo. Kwe Kristen afani na oneglëni, sebo some anisasana megali nolëyo, sobo këbë lowene feilawamu saesogo elelëkeflo. ");
INSERT INTO nce_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","Sobo aholabu lowene jwa na wame lowene jwabë onehoha tafa egelobëme, sa afutuku elo. Sobo fli enëne kë fa motokweflabë wesibime asa gali elokwefëmo. Sobo kë egelobë wesibiwa lowene elekefëtemome. Na sobobë tobana wesibi etomome, sobobë tafa këna egaitalo naegelome, ëtani sebo some fene gali tolëyo. ");
INSERT INTO nce_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","Sobo melë egelona, kwe sobo wesibime afolo hana egletemome na fli onehome, some mëgaitobëme takune hana eglokwefëmome. Na Jisasme lowene sle jwa mëgletlabë oneho bu sobo kë tafa egelobë tafa hwi moglotëyona bu some fleflesu mëgletëyome na some megali mlame, “Lale enënemu.” ");
INSERT INTO nce_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","O Kristen afani na oneglëni, sebo metole nanëletëyo, gigli kë mëtebëyabë Kristen onehome, wesibi fata lëgletëmebë wesibime, sobo lowene sle naegletemome. Sobo, gigli mëtebëyabë Kristen enëneme feilawa maninibo asa eletemo, Gotome lowene jwa mëgletlabë oneho fene mla. Këbë enëne, gli mago huhuju mëglabë lowene hana lëbetëme. ");
INSERT INTO nce_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","Sebo melowene nanëla, Jisas gli tle na gli mago huju tle. Këme nëgeme sebo melowene nanëla, Jisasbë afutukuna, Goto, Kristen onehome, gigli mago huhuju logotomeme na bu Jisasna iniwa misiyame. ");
INSERT INTO nce_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","Sebo ëje kë të nëgëtatëyobë gali, ebë bu Tako Hobë gali. Bu melë lëgëbetle lalële. Tokwafe, Tako Ho Jisas ita ligisina, sebo tuja ato mana kë tafa nëglabë oneho, sebo afina hana nokwalame, Jisasme oloba mëta esune nanëglëlame. Weye. Hanane mu. ");
INSERT INTO nce_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","Goto feilawa we loglomeme, na bubë eso ensel mata we lëgleme na Gotobë funiji elamëme. Na Tako Ho Jisas, Heven life kile luleme na lisime. Na Jisasme kë lowene sle mëtletlabë oneho, gigli kë mëglabë, bu afina huhuju mlame. ");
INSERT INTO nce_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","Kë olëna, sebo tuja ato mana kë tafa nëglabë oneho na gigli mago kë huhuju mëglabë oneho, sebo iniwa Tako Ho Jisasme oloba mëta esune nowelëlame. Na sebo Tako Ho Jisasna unaunalëme tafa nëlame. ");
INSERT INTO nce_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","Na kwe, sobolalo, kë gali të etokweflome, sobobë lowene këna aitakefëmome. ");
INSERT INTO nce_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","O Kristen afani na oneglëni, sebo Jisas ligisibë olëme, hana gali sle noglëyome. ");
INSERT INTO nce_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","Sobo wafi lowene eletelo. Jisas ligisibë olë, bu lafatawa lëgleme, tokli ho klabë fene lisi. ");
INSERT INTO nce_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","Oneho megali mëglame, “Ëje sebobë lale fleflesu olë lemotëna. Na seme wame moglonabë enëne hana tafa mla. Weyewa.” Kë olëna, bume tëbo logotomebë wesibi, lafatawa lëletëmeme, mëse nëba amlebo fene fale etamë. Na kwe bu kë wesibi hana elë mëglëlame. ");
INSERT INTO nce_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","O Kristen afani na oneglëni, sobo klabë mëta tafa egelobë oneho nane, klelego kë egelome. Weye. Këme nëgeme some kë olë fata lëglena klelego hana egletelome, ho tokli home hwime fene klelego lële. Weye. ");
INSERT INTO nce_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","Sobo iniwa, elulego mëta asë egelobë oneho. Sebo tlokofini mago oneho nane. Weye. ");
INSERT INTO nce_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","Këme nëgeme, sebo lili sloslowa asa manëla. Gotome lowene jwa mëgletlabë oneho fene mla. Sebo sagli nëglëlame, Jisas ligisibë olëme mana hwi nëkaketlame. ");
INSERT INTO nce_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","Sebo lowene nanela, bu nini mëgebëyabë enëne bu klabë nini lamebëya. Kye mëglabë enëne bu klabë kye kye mëla. ");
INSERT INTO nce_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","Kwe sebo kwe kliji elulego mëta tafa nëglabë oneho. Sebo këme lowene sle nëglame. Sebo Gotome lowene slemu nëletlame na fli onehome mata tolemu nëletëmame. Kë lowenebë seme, Satanbë tetëbo lowenebëme title lëtaname, yako lamu kaba soldiame fene title etole. Na Jisas seme nënome ligisibë lowene, lowene sle nëletlame. Kë lowenebë seme, Satanbë tetëbo lowenebëme title lëtaname, eso kaba soldiame fene title etole. ");
INSERT INTO nce_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","Goto seme melëme nane aniji tlona, Gotobë enisusu mëta tafa nëlame. Weye. Bu seme melëme aniji tlona, sebobë Tako Ho Jisas seme nëno nalëgleme. ");
INSERT INTO nce_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","Ëtani Jisas wafi gli tle, seme legaitanabëme. Këme nëgeme, sebo tuja ato mana tafa nëglana o sebo gigli nëglana na bu mana lisina, kwe sebo buna ëhwati atobëna tafa nëglame. ");
INSERT INTO nce_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","Këme nëgeme, sobolalo, këbë lale galina gëgali elelëgome na sobolalo, sobobë lowene aitamome, sobo fene elekefo. ");
INSERT INTO nce_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","O Kristen afani na oneglëni, sebo some megali nolëyo! Some kë moutatëyobë na kë mëgaitakefëyobë hobë gali aholokwane elomome na esogo elëletëmome. Tako Ho, some kë mougoutatëyobë home, aniji tlome, some tafa namëglelëyome. Bu some Gotobë galime okokwe lamolokwefëyo na sobobë tëbo lowene sle motokwefëmetëyo. ");
INSERT INTO nce_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","Sobobë kume, wege kë fa motokweflabë enëneme lowene eletemo na bume lale lowenenamu yonane elelëmome na bume tolemu sle eletemome. Na sobo iniwa jowa lowene mëta fwa etabome na yonanewa elome. ");
INSERT INTO nce_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","O Kristen afani na oneglëni, sebo some anisasana megali nolëyo! Sobobë ku mëta, wege jwa kë tatafa mëglabë onehobë lowene anisasa galina sasle etometemo. Na tutune na uli kë mëglabë onehobë lowene alabuju galina sle etometemome. Na afutuku jwa kë tafa mëglabë onehome aitamome. Na sobo iniwa onehome alabuju elelëmome. ");
INSERT INTO nce_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","Oneho some gëglë mëglelëyona, kwe sobo kofaya bume asa gëglë elelëmo. Weye. Iniwa olë sobo Gotobë onehome ululu etomome na iniwa onehome mata ululu sle etomome. ");
INSERT INTO nce_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","Sobo itaita fleflesu eglekefome. ");
INSERT INTO nce_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","Na sobo Gotome gëgali elelëkeflome. ");
INSERT INTO nce_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","Lale wesibi o tëbo wesibi some fata legletëyona, sobo Gotome fleflesu gali nawa sa gali elokweflo. Goto metole lalële, Jisasbë lowene mëta kë asë egelobë enëne, sobo këha lowenewa saehokweflo. ");
INSERT INTO nce_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","Gotobë Amtëtomba some li wesibi fa egotlobëme huju lëgëtona, sobo lëkle asa etlo. ");
INSERT INTO nce_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","Na Gotobë ëfalëbo mago gali some kë të mëgëtatëyobëme heheë asa elo. ");
INSERT INTO nce_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","Kwe sobo iniwa gali kë aholokwane eglomobë, sobobë lowene mëta obobwelë elujuwetomome. Na iniwa lale gali, ehwëyome na esogo elelëmome. ");
INSERT INTO nce_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","Na sobo iniwa memelë tetëbo galime na tetëbo loweneme hëhele egelome. ");
INSERT INTO nce_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","Bo metole nanelë, Gotobë maninibo tli lowene, buwa sobobë iniwa tëbo lowene sle malotometëyo, ëhwati onehomu fata naegletelome. Na bu sobobë atona lowenena iniwa ululu sle nalotometëyome, sobo lalowamu tafa naegelome. Na sebobë Tako Ho Jisas ita mana lisime, Gotobë naba li mëta tëbo wesibi liha hana lëgebetëyome. ");
INSERT INTO nce_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","Some bubë oneho fata egelome kë aniji toglëyobë Goto, bu kë wesibi some fata lëgëtatëyome. Bu melëme nëgeme, bubë iniwa gali esogo lalëlelëkefle. ");
INSERT INTO nce_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","O Kristen afani na oneglëni, sobo Gotome sagëgali elelëlo, bu seme lëgaitana nalëgleme. ");
INSERT INTO nce_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","Sebo Gotome kë lowene nëgletlabë onehobë lowene fene lëbetëna, sobo fli Kristen afanime na oneglënime sasësle etomo. ");
INSERT INTO nce_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","Bo Tako hobë wenijina some, anisasana megali nolëyo, sobo ebë pasë Jisasme kë lowene mëgletlabë iniwa onehobë aholo li mëta sahwi elëyo. ");
INSERT INTO nce_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","Sebo metole nanëla, sebobë Tako Ho Jisas Klais some ululu sle malëto. ");
INSERT INTO nce_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","Bo Jems Gotonabë, Tako Ho Jisas Klaisnabë manawa wege ho. Bo some pasë ekë yahi nëkeketëyo. Sobo we ita tële Israelbë afenëbo lilife lilife mëta kë nibowai ekoujobë oneho. Sobo lale klijimu. ");
INSERT INTO nce_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","2","O bobë, Jisasme kë lowene sle egletelobë afani na oneglëni, some tetëbo hobota wesibi fata mëgletëyona, na sobo kë wesibi hwi eglomona, kwe sobo kë wesibi mehwi eglomome, fleflesu wesibiwa. ");
INSERT INTO nce_vpl VALUES ("JM1_3","089_1_3","JAS","1","3","3","Këme nëgeme, sobo melowene egelome. Këha su kë nëgebëye some melëme olafa mëto, sobo Gotome lowene slemu laletelomu. Këha su some hobota eglibetemobëme laito na ebë life mago tetëbo lowene aholokwana ti elome. ");
INSERT INTO nce_vpl VALUES ("JM1_4","089_1_4","JAS","1","4","4","Na hobota eglibetelobë afutuku bubë wege yawe malolole. Kwe sobo melë egelona, sobo hobota eglibetelowa egelona kwe sobo ebona flo egelome, na sobo Goto kë tole lëgletlebë lowenebëme hana afolo egelomemu. ");
INSERT INTO nce_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","Kwe loweneme yalë afololëglena, kwe bu Gotome takune lololeme, na lëlëme. Melëme nëgeme Goto bu tako fleflesumu lalële iniwa onehome lowene lëglëmebëme bu wame hana loglomeme. ");
INSERT INTO nce_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","6","Kwe bu Gotome melowene sle lëletleme bu lëgëtatenëme na mana takune lololeme. Lebutako lowenena asa takune malolole. Matëbemu. Fëyemene? Ho bu lebutako lowenena wesibime takune loglolena kwe bubë lowene haliji tu fenene melë asa malëletle. ");
INSERT INTO nce_vpl VALUES ("JM1_7","089_1_7","JAS","1","7","7","Bo some tutuneme gali nolëyo, sobo melë asa elo. Fëyemene? Këha lowenena ho Gotome wesibime takune loglolena, wesibi Tako Ho mago fa hana logotleme. Hanane mu. Bu melowene asa malëletle, “Goto bome wesibi lëglënëmefe.” Wëyewa. ");
INSERT INTO nce_vpl VALUES ("JM1_8","089_1_8","JAS","1","8","8","Bu tële lowenena ho lëtabe. Këbë tële lowene bume kiki lalëbobukwake na bu këme nëgeme bu jowa lowene mëta fwa hana lëtabe. ");
INSERT INTO nce_vpl VALUES ("JM1_9","089_1_9","JAS","1","9","9","Jisasme kë lowene sle mëgletlabë afani na oneglëni, wesibi jwa nëgena kwe lalowa bu fleflesu matla. Goto bume mehwi loglomeme nëgeme, letitabo enëneha mëtabëyame. ");
INSERT INTO nce_vpl VALUES ("JM1_10","089_1_10","JAS","1","10","10","Jisasme kë lowene sle mëgletlabë oneho balitina kë nëgebë. Melëme, bu kwe fleflesu mëglame Jisas Klaisbë lokwalëfewa mëtabëa. Këme nëgeme bu iniwa wesibina bu kwe tëbo mëglitayame bu ti tahweji fene maklëfa mle na mitigo. ");
INSERT INTO nce_vpl VALUES ("JM1_11","089_1_11","JAS","1","11","11","Bo megali, kliji bubë atëtena, lokwalena na kaka lëkekeme, bubë atëtena agosaba lakokowa lëtamëme, na bubë tahweji mata lamaklëfawa lëtamë na bubë tahweji laegëtikwawa na bubë lale weniyane latëbowa lëletë. Bu baliti ho fene, bu iniwa wege motla motla, kwe bu hokweinawa gigli mëglame. Këbë wesibi bubë kwe tëbo mëgletëmeme. ");
INSERT INTO nce_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","Feilawa hobota onehome fata mëgletëmena na bu hobota mëglibetlawa mlame, kwe këha oneho bu fleflesu matla. Këme nëgemë. Tokwafe kwe Goto bume lale ëhwati tafa lëglëmeme. Goto bu megali sle wafi tle, “Bume kë tole mëgletlabë enëneme kë ëhwati tafa lëglëmeme.” ");
INSERT INTO nce_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","Hobë tëbo lowene huju lëgëtatlena, bu melowene asa malële, “Goto bome tëbo lowene elë bu ki lëkake.” Weye. Tëbo lowene Gotome hana ki lëkakeme. Na Goto home, tëbo lowene elë hana ki lëkakeme. ");
INSERT INTO nce_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","14","Kwe sebobë tëbo lowene kë nëgebëye, buwa seme tëbo lowene elë kiki lëbebokwake. Kë lowene tëbowa seme sosogëna lolona na kiki lëbebokwake, tëbo lakale nogotlabëme. ");
INSERT INTO nce_vpl VALUES ("JM1_15","089_1_15","JAS","1","15","15","Bo gali nelë ebë waflë galime. Ebë tëbo lowene loglotle wame huju lëglena bu mëse nëba fene ehole. Na ke maninibo tëbo takowa na bu tetëbo wesibi lotle, na kë tetëbo wesibi logotlebëye, naglime fata lotle. ");
INSERT INTO nce_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","O bobë afanino na oneglënino, këbë maninibo tëbo some ki asa malëbebokwake. ");
INSERT INTO nce_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","Iniwa lale lale wesibi kë glo nëglekefëyabë, kë heven life mago metujukefle. Klijina, yemena, sëgetobana, kë blëge togotomebë Aya, kë lale wesibi iniwa buwa seme lëtelëbakëkefëna. Kë Aya kë nëgebë bu lowene hihijika hana lëlekëfe. Bu kë nëgebë, kliji elulego mago amtëtomba fenene këha hana lële. Bu melëbë nane, heletabo lële na ita afluja lële, amtëtomba fenene. Weye. Goto bu melëgëtabekëfewa lalële. ");
INSERT INTO nce_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","Bu melë bëme tole lële sebo bubë nëbale fene nëtabetla nëlame. Bu sebobë aya fene mefata lëletëname. Na bu kwe bubë nëgali galina seme jine lëlëtëna. Na sebobë maninibo kwe bu mëta fwa kesi mëleme. Na kë onehome Goto meaniji latlome bubë, bu wesibi blëge blëge totomena. ");
INSERT INTO nce_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","19","O bobë afanino na oneglënino. Sobo ebë wesibi salowene sle eletemo. Sobo iniwa aholo bo sle etome, na alabuju galina mana tafu etatemome na sobo hokweinawa momatame asa ëjuwetigo. ");
INSERT INTO nce_vpl VALUES ("JM1_20","089_1_20","JAS","1","20","20","Sobo enisusu asa elo matëbe, ho li hokweinawa enisusu lëglena bu Gotobë naba li mëta lale ho nane. ");
INSERT INTO nce_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","Këme nëgeme tetëbo lowene, sobobë lowene mëta kë fata mëglekefëtëyobë, aholokwana ti elome. Na flalego tafana Gotobë gali mana fa etlome. Goto kë gali somëta wafi gwa telutatëyo. Këbë gali kë nëgebë sobo lale unaunalëme ëhwati tafa këna fa egotlome. ");
INSERT INTO nce_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","22","Sobo Gotobë tafa sle gali aholonawa asa aholokwane elo. Weye. Sobo esogo esogo eglelëmome. Aholokwanewa egelona, kwe sobo sobolalo, kule kule lalelogo. ");
INSERT INTO nce_vpl VALUES ("JM1_23","089_1_23","JAS","1","23","23","Kwe ho li Gotobë tafa sle gali aholo nawa aholokwane lëglena na esogo hana lëglelëlena. Kwe ho bu weniyane tu mëta hwi loglolebë fenene. ");
INSERT INTO nce_vpl VALUES ("JM1_24","089_1_24","JAS","1","24","24","Bubë weniyane hwi lolole, kwe ita bu hokweinawa bubë weniyane lamëmëtewa lëkaketle. Bobë weniyane habetabone? ");
INSERT INTO nce_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","Kwe kë lale tafa sle gali kënegebëye, tëbo loweneha li hana lelube. Na bu tëbo loweneme boblo logotleme na seme ëhwati tafa lëlëname. Na ho li kë lale tafa sle gali hwi sle loglomena na esogo sle lëglelëmena na aholokwana hana ti lëglena kwe Goto sle logotometleme na lalowamu fata mëletleme. ");
INSERT INTO nce_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","Kwe ho li megali lëglena, “Bo lale Jisasme kë lowene sle nëgletelëbë ho na Gotobë lowenewa esogo sle nëglelëlëbë ho,” kwe bu bubë aleji ululu sle jwa logotlena kwe bu bume fwa kule kule lële. Këme nëgeme Gotome kë lotu lëgletlebë lowene, waiyo jwa këme lëbetle. ");
INSERT INTO nce_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","Jisasme kë lowene sle mëgletlabë onehobë lakale, Aya Gotobë naba lime lalowa lëgëbetëmebë, bu melë; Sebo flinëba nëbaleme inainagi nëglame. Na seiju oneme mata naitamame. Na bu hobota fa mogotlabëme na wesibi nëglëmabëme mata naitamame. Na li wesibi mata melë lëgëbelalële, sebo sebobë lakale ululu sle nëtagulame, ebë life mago tëbo lowene sebobë lale lowene, Gotobë naba lime lëlalë lëgëtatënalime. ");
INSERT INTO nce_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","O bobë afanino na oneglënino, sebo iniwa Jisas Klaisme kë lowene sle nëgletlabë oneho. Bu kënegebëye heven lifate mago lale wesibibë eso ho lëtabe. Këme nëgeme, sobo melë asa elo, wenijiatena enëneme fwa sle etomome kwe atwati enëneme tëboijiwa elomome. ");
INSERT INTO nce_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","Ho li lale lale ëho gëgelo lëleme na golna blëgetabo toba baliti toba kume lehwamëme, na lotu lowa mana lëkaklina. Na wesibi jwa ho kaka tabo ëhona mata lëkaklime. ");
INSERT INTO nce_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","3","Na sobo melë egelona, lale ëhona negli sle kë logotlebë home fwa megali elolome, “Ebë lale labume tafa ele,” kwe wesibi jwa home megali elolome, “Eme ejuwelibe” o megali elolome, “Bobë kiju li mëta tafa ekoketenë.” ");
INSERT INTO nce_vpl VALUES ("JM2_4","089_2_4","JAS","2","4","4","Kwe sobo kë fene melë egelona, na wesibi jwa enëneme tëbojiwa eglomona kwe sobo tëbo lakale fa etlo. Melë kë egelobë, sobo onehome eselëkwëyo lowenena hwi elomo na iniwa onehome jowa lowene nawa hana hwi elomo na melowene hana elo, sebo iniwa mëtabowa tafa nëlafe. ");
INSERT INTO nce_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","Bobë afanino na oneglënino, sobo aholokwane elo. Wesibi jwa kë mëtabëyabë, oneho ebë life mago onehobë naba lime Goto bume meaniji latlome, Jisas Klaisme lowene sle mu mëgletlame. Ëtani Goto bu megali sle latle, oneho bume tako tole kë mëgletlabë, Goto esohome kë tafa lëglebë lifate mëta tafa mëglame. ");
INSERT INTO nce_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","6","Sobo kë wesibi jwa enëneme sisile latokwefëmo. Kë wesibi lowene sle ekaketelo. Some tiniji ya lëlëkefëyone na hobota ya gwa lëtakefëtëyone na plis enëne belë lëlelukefëyo. Wesibi feilawana oneho buwa melë lamëtakefëyo. ");
INSERT INTO nce_vpl VALUES ("JM2_7","089_2_7","JAS","2","7","7","Sobo Jisas Klaisbë oneho etabetelo. Na kë Jisas Klaisbë lale weniji yalë sisile lëtakefëtlene. Kë feilawa wesibina enënefe. ");
INSERT INTO nce_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","Goto bubë bogo mëta tafa sle gali tlëna. Bubë auto mago gali melëgëbe lalële, “Ju jubë yabeme metole egletleme, ju jubë ato fene tole eletle.” Sobo melë eglelona, kwe sobo lale lakale blëge egotlome. ");
INSERT INTO nce_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","Sobo balitina onehome eselëmona bu lale, kwe wesibi juwa tëbo onehome tëbo etomome, kwe sobo tëbo lakalemu fa etlomu. Gotobë tafa sle gali some meolafa lëgëtome sobo tafa sle gali boblo egotlobë enëne etabomu. ");
INSERT INTO nce_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","Ho li iniwa tafa sle gali esogo sle lëglelëmena. Na bu li tafa sle gali boblo logotlena, kwe bu tëbo lalilitamu na bu iniwa tafa sle gali boblo logotomebë ho lëtabemu. ");
INSERT INTO nce_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","Sebo walowene nëla. Goto megali kë tëglebëme, “Sobo hona one asa lisei lisei elelëmo.” Na bu ita megali latle, “Onehome mogo nalë asa tëtëkle eto.” Kwe ju lisei lisei hana eglena, na kwe ju home mogo nalë tëkle etle, kwe këha melë eglena, kwe ju iniwa tafa sle gali boblo egotomebë ho etabemu. ");
INSERT INTO nce_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","12","Lowene elo tokwafe sobo Gotobë koto mëta eglibome wesibi sobo kë egotomobëme, na kë gëgali egelobëme. Sobo fli onehome tole egletemona kwe sobo egëtabo sle egelome. ");
INSERT INTO nce_vpl VALUES ("JM2_13","089_2_13","JAS","2","13","13","Ho li, li home maninibo jwa lëgletlena, kwe Goto kë hobë lakale hwi loglotlëna kwe këha home Goto hana maninibo lëgletlememu. Kwe ho li, li home maninibo lëgletlena, Gotobë maninibo nawa bu Gotobë enisusu boblo logotleme na bu kwe tafa sle lëleme. ");
INSERT INTO nce_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","O bobë Jisasme kë lowene sle mëgletlabë afanino na oneglënino, somago ho li megali lëglena, “Bo Gotome lowene sle nanëletelë.” Kwe bu fli onehome ululu sle juwa logotomena, këha Gotome lowene slebë lowene wayo hanamu lëbetle. Na këha lowene Goto onehome bubë koto mëta hwi loglomena bume habëna lëgaitalemene? Weyewa. ");
INSERT INTO nce_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","15","Jisasme kë lowene sle mëgletlabë afa li o mësenëba li bu ëhome afolo melome o hi wesibime afolo melome, ");
INSERT INTO nce_vpl VALUES ("JM2_16","089_2_16","JAS","2","16","16","na somago, li afa megali lolomeme, “Goto some ululu sle malëto, sobo fleflesuna eyeu. Sobo lale ëho gëgelo elome na hi egelobëë, imo tëtafumu etomome.” Kwe sobo bume bubë ato lëgaitametëmebë wesibi eglëmo jwa nëgena, këha blawa gëgali. Bume habëna lëgaitamemene? Weyewa. ");
INSERT INTO nce_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","Jisasme lowene sle nëgletlabë lowene, mata, kë fenene. Këbë fli onehome nëgaitamabë lakale juwa nëgena, këbë meolafa sle lalotle Jisas Klaisme lowene slebë hanane. Këme nëgeme bume habëna lëgaitalemene? Weyewa. ");
INSERT INTO nce_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","Kwe ho li megali lëleme, “Ho li Gotome lowene sle lëgletlebë lowenena, kwe ho li onehome lëgaitameme.” Bo kwe bume metafu nëgëtatelëme, “Kwe fli onehome agaitamo juwa egelona Jisasme lowene sle egletlebë lowene hanane.” Kwe bo some bo Jisasme kë lowene sle nëgletelëbë lowene, lebotanë nëtatëyo, bo onehome kë nëgaitamëbë lowenena. ");
INSERT INTO nce_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","Sobo melowene sle lalo, “Jowa Gotowa lëtabemu.” Kë kwe nëgali lowenemu. Masiwafe, alibaho, ahwane na tijeli mata Gotome melowene sle lamletle, jowa Gotowa lëtabe. Na bu tutune lowenena tafa mle. ");
INSERT INTO nce_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","20","Sobo eso ka juwa etabone! Gotome lowene sle nëgletlabë lowene onehome nëgaitamabë lowene juwa nëgena, këbë lowene hi wesibi juwa ti fenene. Sobo kë galibë wayo lowene naegletelomene? Sobo aholokwane elo. ");
INSERT INTO nce_vpl VALUES ("JM2_21","089_2_21","JAS","2","21","21","Sebobë semle Abrahamme lowene ekaketelo. Goto bume lale ho fëye melëna totle. Bu bowene Aisakme, ahojumebë amasei mëta yafe gwa towetle Gotome lëglële nalëgleme. Abraham kë blëge togotlebë Goto yafe hwitlotle bu lale ho fë këme totle. ");
INSERT INTO nce_vpl VALUES ("JM2_22","089_2_22","JAS","2","22","22","Lowene sle elo, Abraham Gotome lowene sle tletle na bubë gali esogo sle tlelëtle. Na tële wesibi iniwa sago mëtle, Abraham Gotome lowene sle tëgletlebë lowene olafatletle. ");
INSERT INTO nce_vpl VALUES ("JM2_23","089_2_23","JAS","2","23","23","Abrahamnabë, Aisaknabë, anebo galime, Gotobë bogo megali kë eglabë, “Abraham Gotome lowene sle tletle na Goto bume lale ho fë totle.” Na bume mefë mototla, “Gotobë yabe.” ");
INSERT INTO nce_vpl VALUES ("JM2_24","089_2_24","JAS","2","24","24","Sobo melowene egelome, ho Gotobë naba lime lalowa lëgëtabebëme, sobo hwi elo bu Gotome lowene sle lëletle na onehome laitameme këme fwa Goto bume mefë lotleme lale ho. Weye. ");
INSERT INTO nce_vpl VALUES ("JM2_25","089_2_25","JAS","2","25","25","Kë fenene, Rahap bu lisei mëse. Bu melë latle, Josua kë jine tëglëmebë home lowa nono tle na ëho totome na li alëge elë jine telëkakëme. Kë lakalena Goto bume lale mëse fë këna tëtamë. ");
INSERT INTO nce_vpl VALUES ("JM2_26","089_2_26","JAS","2","26","26","Alibaho ato mëta lëgëlutabe jwa nëgena, kwe kë ato wagli lële. Kë fenene, onehome nëgaitamabë lakale jwa nëgena kwe Gotome lowene sle negletlabë lowene wagli lële. ");
INSERT INTO nce_vpl VALUES ("JM3_1","089_3_1","JAS","3","1","1","O bobë Jisasme kë lowene sle mëgletlabë afanino na oneglënino, somago feilawa, onehome okokwe moglomabë ho fata asa elo. Këhabëme gali nelë. Sobo wesibi walowene eletelo. Tokwafe sebo onehome kë okokwe noglomabë ho, Goto onehome koto loglomena seme feilawa obobwelë lëgëtaname. ");
INSERT INTO nce_vpl VALUES ("JM3_2","089_3_2","JAS","3","2","2","Sebo Jisasme kë lowene sle nëgletlabë fli olëna tetëbo lowene meblëge blëge notla. Ho li kleë gali juwa lëglena bu tafa sle lalële këha ho bu bubë iniwa tafa ululu sle lalotle. ");
INSERT INTO nce_vpl VALUES ("JM3_3","089_3_3","JAS","3","3","3","Sebo hos klelibë ëfalëbo mëta ainë afo susu nanotometëma na bu sebobë tolewa naesogo mëglelëmetëname. Sebo kë ainë afo nawa nëbebotokwakëma. ");
INSERT INTO nce_vpl VALUES ("JM3_4","089_3_4","JAS","3","4","4","Aholokwane elo, sibu lo mata bu tako wesibi. Ho sibu lo mago yegu tokwëfo nawa tei fa mëbebotokwakla, tako kalëlegona flelu yafe lehule jelime këbë yegu mëta tei fa mëbebotokwakla. ");
INSERT INTO nce_vpl VALUES ("JM3_5","089_3_5","JAS","3","5","5","Kë fenene aleji mata këha, bu tokwëfo wesibi, kwe bu tako hobota lalowa fata loglotleme. Aholokwane elo, tokwëfo ahoju naflëbo, tako ahojume fata logotlememu. Na iniwa walujume latemuwa lëtagule. ");
INSERT INTO nce_vpl VALUES ("JM3_6","089_3_6","JAS","3","6","6","Sebobë ëfalëbo bu ahoju fenene, bu helbë ahoju leslië lotle. Ëfalëbo bu tetëbo wesibi blëge lotle, sebobë amtëtomba sisile lotometëna. ");
INSERT INTO nce_vpl VALUES ("JM3_7","089_3_7","JAS","3","7","7","Oneho waluju mago wesibi olome memëlëma, fole, taiju, kleli na tu mago wesibi mata olome memëlëma, bubë tolewa esogo mëglelëmetëmebëme. ");
INSERT INTO nce_vpl VALUES ("JM3_8","089_3_8","JAS","3","8","8","Kwe ho li semago aleji lëkle logotlebë afutuku hanane mu. Aleji bu tëbo wesibimu, bu motaba fenene. Ho hana lëbebotokwaklememu. ");
INSERT INTO nce_vpl VALUES ("JM3_9","089_3_9","JAS","3","9","9","Kë alejiwa sobo mesosaia latlomu, Gotome këna fleflesu eletelo na kwe ita Goto bu fene, kë blëge blëge totomebë onehome tëbo gali elomo. ");
INSERT INTO nce_vpl VALUES ("JM3_10","089_3_10","JAS","3","10","10","Jisasme kë lowene sle mëgletlabë afanino na oneglënino, kë jowa efalëbowa melë lalële, Gotome fleflesu lëletle na ita tetëbo gali lële. Kë tële lowene ilawa asa yonane matelo. ");
INSERT INTO nce_vpl VALUES ("JM3_11","089_3_11","JAS","3","11","11","Yefi tu mago lale tu na tëbo tu na jowa tala magowa hana sisibo mëlukwokeme. ");
INSERT INTO nce_vpl VALUES ("JM3_12","089_3_12","JAS","3","12","12","Jisasme kë lowene sle mëgletlabë afanino na oneglënino, atowai mëta niji logowalëmene? Hee! Binibi mëta wei logowalëyamene? Hee! Këjina yefi tu, bu lale tume fata logotlemene? Weyewa. ");
INSERT INTO nce_vpl VALUES ("JM3_13","089_3_13","JAS","3","13","13","So mago ho li megali lëglena, “Bo ebë life mëta asë nëglabë lale lowene, lowene sle nanëletelë.” Këha ho sobobë ku mëta tafa lëglena kwe bu meolafa salotle, bu onehome laitamebë ho. Na fli enëneme lokwalëfe lëgletëmebë lakale blëge lotleme. ");
INSERT INTO nce_vpl VALUES ("JM3_14","089_3_14","JAS","3","14","14","Kwe mëmaune lowene, na gëglë lowene, wenijiate fa egotlobëme boblo lowene, sobobë lowene mëta mana mëgëbena kwe sobo mëjiaklë asa elo sebo lowenena tafa nëla. ");
INSERT INTO nce_vpl VALUES ("JM3_15","089_3_15","JAS","3","15","15","Këha yaya lowene Goto mago nane misi. Weye. Këha lowene hobë lowene magowa, ebë flëke mago wesibiwa na bu Satan mago misi. ");
INSERT INTO nce_vpl VALUES ("JM3_16","089_3_16","JAS","3","16","16","Sobobë ku mëta mëmaune lowene, na gëglë lowene, na wenijate fa egotlobë lowene, këha lowene tëbo lowene, na gëglë lowene bu fata motle sobobë ku mëta. ");
INSERT INTO nce_vpl VALUES ("JM3_17","089_3_17","JAS","3","17","17","Lale lowene Goto mago kë migisibë lakale ekë, tëbo lowene lëgëbetle juwa lëleme na Gotobë tolewa esogo lëlelëleme. Këme keibë, fli enënena mogweliha tafabë lakale. Këme keibë, onehome lënalëna loglomebë lakale. Këme keibë, fli onehome boblo jwa logotomebë lakale. Këme keibë, fli onehome maseiwa lëgletëmebë lakale, na ululu sle notomame. Këme keibë, onehome këha lakalewa blëge nëtatëmame. Këme keibë, ju sogëna na able eglebë lakale ju mëta asa ehole. ");
INSERT INTO nce_vpl VALUES ("JM3_18","089_3_18","JAS","3","18","18","Këme keibë, fli onehome yonane sle mëglelëmabë lakale. Goto kë tole lëgletlebë lale lowene nuju mëta lale hi wesibi fenene hulu mle. ");
INSERT INTO nce_vpl VALUES ("JM4_1","089_4_1","JAS","4","1","1","Sobolalo wame na momata fëyeme elelëgone? Ebë esome fwa fata lële. Kë tëbo lowene sobobë lowene mëta lelubetëyo na some kë tëtëke lëtakefëyo. Bo sogëna gali nanëlëone? Hee! ");
INSERT INTO nce_vpl VALUES ("JM4_2","089_4_2","JAS","4","2","2","Sobo wesibi fa egotlobëme tako tole lalo, kwe sobo hana fa etlo. Këme nëgeme sobo sobolalo moumou këme elelëgo, sobo fli eneneme mogo nalë tëtëklebëme këme sagli elolo bubë wesibi glo naegletemobëme. Meleme nëgeme sobo bubë wesibi mëmaune lalometemo, kwe sobo glo hana elo. Sobo gëglë këme elo kë wesibi glo naegelome. Sobo Gotome takune jwa eglolome nëgeme, sobo wesibi glo jwa këme elo. ");
INSERT INTO nce_vpl VALUES ("JM4_3","089_4_3","JAS","4","3","3","Sobo Gotome takune lalëkweflo, kwe sobo wesibi fa hana etlo. Fëyemene? Sobo tëbo lowenena takune eglëkeflome nëgeme. Sobobë ato fleflesu tëbo lowenebë tole këna yawe naeglolome. ");
INSERT INTO nce_vpl VALUES ("JM4_4","089_4_4","JAS","4","4","4","Sobo labeso totoho mëglabë oneha. Sobo melowene hana elone? Oneho ebë life mago lakale tole mëgletlana, kwe bu Gotome wame moglolabë enëne. Këme nëgeme fëye enëne ebë life mago lakalena yonane mëglabëme tole mëglana bu, bu tobana melëlekuju lamela, sebo Gotome wame noglolabë enëne nëtabëya. ");
INSERT INTO nce_vpl VALUES ("JM4_5","089_4_5","JAS","4","5","5","Sobo melowene lalone, ëtani Gotobë bogo mëta blawame yahi mëtlane? Weyewa. Bu megali lala. “Goto bubë amtëtomba ho mëta kë gwa tëgelujuwetlebë, Goto bu seme metole lalëletëna ho mëseme fene tole lëletë, kwe bu bume sisile egotlena fli home mëmaune eglëmebë lowenena.” ");
INSERT INTO nce_vpl VALUES ("JM4_6","089_4_6","JAS","4","6","6","Kwe, Goto seme lalaitakefëna, tëbo lakale boblo nogotomabëme. Gotobë bogo megali lala, “Goto tuwetuwe mëglabë onehome tëbo ijiwamu lalolokwefëme. Kwe Goto bu fli onehome kë lokwalëfe mëgletëmabë onehome bu ululu sle lalotokwefëme.” ");
INSERT INTO nce_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","7","Sobo Gotome salokwalëfe eletelo na bubë tole mëta fwa asë eletelome. Na sobo Satanme feilawa boblo egotlome kwe sobo melë egelona, kwe bu somago lëglëboukakume. ");
INSERT INTO nce_vpl VALUES ("JM4_8","089_4_8","JAS","4","8","8","Sobo Goto nawa lesili eulome, na bu somëta mata lesili lëkakime. Tële lowenebë mëta kë tafa egelobë oneho, sobo sobobë lowene sle etomome. Tëbo lowene sakile elo na Gotome fwa lowene sle eletelome. ");
INSERT INTO nce_vpl VALUES ("JM4_9","089_4_9","JAS","4","9","9","Sobo nabatuna feilawa saye elo na somalëfana temutu enitome. Sobo tëbo lowene mëta feilawa etabome nëgeme. Sobo soso lakale mëta ke tafa egelobë, ye lakale elë sahihijika ekako na ye feilawa kle etlome na sobobë fleflesu lowene hihijika ekakome na witina tafa ekoujome. ");
INSERT INTO nce_vpl VALUES ("JM4_10","089_4_10","JAS","4","10","10","Sobo Gotobë naba lime lokwalëfe lowenena satafa elo. Sobo melë egelona, kwe bu some fleflesu lëletëyome na wenijiatena oneho hwi lolëyome. ");
INSERT INTO nce_vpl VALUES ("JM4_11","089_4_11","JAS","4","11","11","O afanino na oneglënino blawa asa so etatemo na eselëmome. Ju mëglena, kwe tafa sle gali, tëbo gali lalolemu, kwe jubë wege nane tafa sle gali sle egotlebëme, weye. Jubëye, esogowa eglelëleme. ");
INSERT INTO nce_vpl VALUES ("JM4_12","089_4_12","JAS","4","12","12","Goto tafa sle gali buwa lehole sle lëlemu, na buwa onehome koto loglomebë ho lëtabe. Na gigli mëglabë onehome lëgaitamebë ho, na bu onehome Hel elëme lalowa mejine lëglëmeme. Sobo ebë life mago howa. Sobo habëtabo hone, onehome eselëmo këme elo? ");
INSERT INTO nce_vpl VALUES ("JM4_13","089_4_13","JAS","4","13","13","Sobo aholo bo eto, sobo megali kë egelobë enëne, “Eli o uniji bo tebë lifate takowa nuwime na jowa tlibutu tafa nulëme na baliti loko nëgëtëbë wege mana fa notlëme.” ");
INSERT INTO nce_vpl VALUES ("JM4_14","089_4_14","JAS","4","14","14","Sobo megali asa elo. Sobo uniji fata lëglebë wesibi lowene laletelone? Weye. Sobo ebë life mëta kë tafa egelobë tafa, tokwefo olëwa etabo, olobalë, oloba fene mekesiwa lalële, kwe kliji yafe u lëkeke kwe lagëgewa lëkake. ");
INSERT INTO nce_vpl VALUES ("JM4_15","089_4_15","JAS","4","15","15","Sobo megali egelome. Goto seme ebë life mëta tafa nëglabëme tole lëgletënana, kwe sebo kë wesibi nogotlamemu. ");
INSERT INTO nce_vpl VALUES ("JM4_16","089_4_16","JAS","4","16","16","Sobo aholabu asa elo na megali ebokwako, këha lakale bu tëbo wesibi. ");
INSERT INTO nce_vpl VALUES ("JM4_17","089_4_17","JAS","4","17","17","Ho li lale lowenebë lakale walowene lëgletlena kwe bu kë lowenebë lakale blëge jwa logotlena kwe bu tëbo lowene blëge lotle. ");
INSERT INTO nce_vpl VALUES ("JM5_1","089_5_1","JAS","5","1","1","Hai! Wesibi lebutakona enëne aholokwane elo. Sobo tako ye sakle etlomu na witina asë elome. Melëme nëgeme, tako hobota some esogo lalëlagijo na some lamu logotobëme nounou lalëkeke. ");
INSERT INTO nce_vpl VALUES ("JM5_2","089_5_2","JAS","5","2","2","Sobobë iniwa lale wesibi kë nëgebë wafla meletëyo, na lale lale ëho mata lahwë watëtlë motometëyo, na wanehou watiji meletëyo. ");
INSERT INTO nce_vpl VALUES ("JM5_3","089_5_3","JAS","5","3","3","Sobobë silva baliti na gol baliti gu wafi mëlelëtëyo. Kë balitibë gu, Gotobë naba lime gali sle mëleme, bu sobobë tëbo lakalebëme. Këbë balitibë gu sobobë ato ahojunaha bu temu lëgëtatëyome. Yawe olë lololi lalëkeke na sobo lale lale wesibi loloko eto. ");
INSERT INTO nce_vpl VALUES ("JM5_4","089_5_4","JAS","5","4","4","Aholokwane elo. Nuju mago olo wesibi kë wawa mëglekefëtëyobë wege home baliti eglëmo sle hana elo, baliti wali tokli lalekefëtemo. Tako Kalëlegona Goto, këbë tëbo lakale wahwi lolole, na wege enënebë afeflei mata waholokwane lolome. ");
INSERT INTO nce_vpl VALUES ("JM5_5","089_5_5","JAS","5","5","5","Sobo ebë life mëta lale tafa fa etlo. Sobo iniwa wesibina etabo. Na sobo li wesibi meha hana afolo eletelo. Sobo sëse tabo tobaluku luku hime sagli lëglëlebë fenene. ");
INSERT INTO nce_vpl VALUES ("JM5_6","089_5_6","JAS","5","6","6","Kwe sobo lale lakale mëta kë tafa egelobë onehobë lakale lasëlëtemo na mogo nalë tëtëkle eto. Sobobë afutuku hana boblo mëgëtatëyome kwe sobobë wame tafu mëgëtatëyomene? Weyewa. ");
INSERT INTO nce_vpl VALUES ("JM5_7","089_5_7","JAS","5","7","7","Jisasme kë lowene sle mëgletlabë afanino na oneglënino, sobo lowene tafuwa etlome Jisas ligisibë olë, mana hwi eletelome. Olo wesibi ola mëglabë home lowene eletemo. Bu memelë lamla, tlibutu awi hwi lëletlee, tlibutu ye lëkake na wanagli fata lële na nuju mago olo wesibi mana wawa lële. ");
INSERT INTO nce_vpl VALUES ("JM5_8","089_5_8","JAS","5","8","8","Sobo mata hobota fa egotlona lowene tafuwa egotlome, na eglibe telowa elome. Jisas Klais ligisibë olë lololi walëletle, këme nëgeme sobo titiwa laeglibowa. ");
INSERT INTO nce_vpl VALUES ("JM5_9","089_5_9","JAS","5","9","9","Jisasme kë lowene sle mëgletlabë afanino na oneglënino. Sobo fli Jisasme kë lowene sle mëgletlabë afanime naba asa tutuhu etometemo. Aholokwane elo. Sobobë gali aholokwane lëglëyobë ho wafi lisi. Ino ëfome ekë lilibe. ");
INSERT INTO nce_vpl VALUES ("JM5_10","089_5_10","JAS","5","10","10","Jisasme kë lowene sle mëgletlabë afanino na oneglënino, Gotobë ëtanifu profet onehome lowene ekaketemo. Bume oneho wame lamotloma kwe bu lowene tafuwa lamototla, na bume blouwa lamëtletëma. Sobo bubë lakale fene mefa saetlo. ");
INSERT INTO nce_vpl VALUES ("JM5_11","089_5_11","JAS","5","11","11","Aholokwane elo, sobo megëgali lalekefo, Gotobë profet oneho, bu hobota memëtlebila na bu kë wesibi hana uli mëtletla na lowenewa tafu mototla. Sobo megëgali këme elekefëtemo, “Goto bume fleflesu latletëme.” Sobo Jobbë anebo gali wafi lowene eletelo. Bu tatako hobota fafa totle. Kë hobota boblo latotome na kë wesibi bume lëlë hana mototle. Sobo kë wesibi, wafi lowene eletelo, kë iniwa hobota wafi ye tlelële na Goto bume mana iniwa wesibina taitale. Goto bu melë këme lële, bu tako maninibo eso ho, bu onehobë tëbo lowene aholokwane ti lëgletëmebë ho. ");
INSERT INTO nce_vpl VALUES ("JM5_12","089_5_12","JAS","5","12","12","Jisasme kë lowene sle mëgletlabë afanino na oneglënino, sobo ebë jowa wesibiwa salowene eletelo. Sobo matafa mago wesibina asa kakëne elo o life mago wesibina mata asa kakëne elo. Sobo nëgali galime gali egelona, kwe nëgali galiwa gali egelome. Sobo hanane galime gali egelona, kwe sobo hanane galiwa gali egelome. Goto some tëbo lëgëtolime. ");
INSERT INTO nce_vpl VALUES ("JM5_13","089_5_13","JAS","5","13","13","So mogo ho li hobota mëta tafa lëglena, kwe bu Gotome sagëgali lëlelële. Ho li fleflesu lëglena kwe Gotobë fleflesu sawa safë lëtamë. ");
INSERT INTO nce_vpl VALUES ("JM5_14","089_5_14","JAS","5","14","14","So mago ho li ato elili lëglena kwe bu lotu eso enëneme satakune lolomeme, bume migisitla namëglame. Na bu mujutlame, na Gotome gëgali melelëlame, na welë tu Jisas Klaisbë wenijina mana ju mletlame, ");
INSERT INTO nce_vpl VALUES ("JM5_15","089_5_15","JAS","5","15","15","ato elili mago titika nalëgleme. Ho Gotome melowenena sagëgali mëlelëla, “Sebo Gotome melowene slemu nanëletla, ato elilina home sle logotleme.” Kwe ato elili kë home kile logotleme. Na ëtani bu kë fa totlebë tëbo wesibi, Goto aholokwana ti lëgletleme. ");
INSERT INTO nce_vpl VALUES ("JM5_16","089_5_16","JAS","5","16","16","Këme nëgeme, sobo jowa jowa, sobo kë tafa egelobë lakalebëme sobolalo gëgali elelëgome. Na Gotome mana kofaya kofaya gëgali elelëlome. Na Goto sobobë kë tëbo lakale aholokwana ti lëletëyome. Gotobë naba lime asë sle lëglebë ho, Gotome gëgali lëglelëlena kwe bubë gëgali tako afutukunamu na tatako wesibi logotomeme. ");
INSERT INTO nce_vpl VALUES ("JM5_17","089_5_17","JAS","5","17","17","Elaija bu sebo fenene kwe bu Gotome itaita gëgali tlelële, na tu tëgeto juwa tle. Nëgalimu tu tëgeto hana tle, tu tëgeto juwa këniji tlibutu, aona tlibutu tle na tobali ita jowa yeme. ");
INSERT INTO nce_vpl VALUES ("JM5_18","089_5_18","JAS","5","18","18","Na Elaija bu ita Gotome gëgali tlelële na tu mana teto. Na life mëta hi wesibi ita hulu motokou. ");
INSERT INTO nce_vpl VALUES ("JM5_19","089_5_19","JAS","5","19","19","Jisasme kë lowene sle mëgletlabë afanino na oneglënino. So mago ho li Gotobë nëgali gali aholokwana ti lëglena na li yaya lëglena, na ho li bubë lowene sle lugutatlena na bu lowene hihijika lëglena, ");
INSERT INTO nce_vpl VALUES ("JM5_20","089_5_20","JAS","5","20","20","sobo melowene egelome, tëbo lowenena home yalë lëgaitalena, na ita Jisasme esogo lëlelëme bu melëbëme laitale Helwa luguju juwa nalëgleme Goto bubë iniwa tëbo lowene aholokwana wati lëletle. ");
ALTER TABLE nce_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
