﻿USE sofia;
DROP TABLE IF EXISTS sofia.nca_vpl;
CREATE TABLE nca_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nca_vpl WRITE;
INSERT INTO nca_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ŋako Yesu Kristo koro usisambayó ŋuro sowo mande qu. Yesuko Dewit koro sowe qu ko Dewitko Abraham koro sowe qu. ");
INSERT INTO nca_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ŋuko Aisak koro iwí. Aisak ŋuko Yakop koro iwí. Yakop ŋuko Juda koya topé-topémboya awaye. ");
INSERT INTO nca_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda ŋuko Peres koya Sera koro awayari. Náyari muko Tamar. Asa Peres ŋuko Hesiron koro iwí. Hesiron ŋuko Ram koro iwí. ");
INSERT INTO nca_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram ŋuko Aminatap koro iwí. Aminatap ŋuko Nason koro iwí. Nason ŋuko Salamon koro iwí. ");
INSERT INTO nca_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salamon ŋuko Boas koro iwí. Boas ŋuro nimí muko Rahap. Asa Boas ŋuko Opet koro iwí. Opet ŋuro nimí muko Rut. Asa Opet ŋuko Jesi koro iwí. ");
INSERT INTO nca_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi ŋuko wiri yerete uni Dewit ŋuro iwí. Dewit ŋuko Solomon koro iwí. Solomon nimí ŋuko komo Uria koro parí yora. ");
INSERT INTO nca_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Asa Solomon ŋuko Rehopoam koro iwí. Rehopoam ŋuko Apiya koro iwí. Apiya ŋuko Asa koro iwí. ");
INSERT INTO nca_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ŋuko Jehosapat koro iwí. Jehosapat ŋuko Joram koro iwí. Joram ŋuko Usia koro iwí. ");
INSERT INTO nca_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia ŋuko Jotam koro iwí. Jotam ŋuko Ahas koro iwí. Ahas ŋuko Hesekia koro iwí. ");
INSERT INTO nca_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia ŋuko Manase koro iwí. Manase ŋuko Amos koro iwí. Amos ŋuko Josaia koro iwí. ");
INSERT INTO nca_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia ŋuko Jehoiakin koya topé-topémboro awaye. Ŋu naru ŋunoko Bapilon unindo Israel unipare yorero Bapilon mirako kusi yereŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Asa Bapilon ŋuno kusi yiri yoroyi, yate naru ŋu kini taró. Naru ŋu kini tiníqo, Jehoiakinko Sealitiel pisiyaró. Sealitiel ŋuko Serupapel koro iwí. ");
INSERT INTO nca_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serupapel ŋuko Apiut koro iwí. Apiut ŋuko Eliakim koro iwí. Eliakim ŋuko Asoru koro iwí. ");
INSERT INTO nca_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asoru ŋuko Satok koro iwí. Satok ŋuko Akim koro iwí. Akim ŋuko Eliuti koro iwí. ");
INSERT INTO nca_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliuti ŋuko Eleasar koro iwí. Eleasar ŋuko Matan koro iwí. Matan ŋuko Yakop koro iwí. ");
INSERT INTO nca_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakop ŋuko Josep koro iwí. Ko Josep ŋuko Maria koro kamí. Asa Mariako Yesu pisiyaró, eneko, “Kristo,” ŋu yero nekoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ŋunde ŋuroko Abraham noŋgo yate-yate Dewit tunoqaró ŋuko wini 14 ŋunde taŋgurí. Ko Dewit noŋgo yate-yate Bapilon unindo Israel kusi yereŋgurí, ŋuko wini 14 ŋunde taŋgurí. Ko Bapilon kusi yereŋgurí, ŋu noŋgo yate-yate Kristo tunoqaró ŋuko wini 14 ŋunde taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Asa Yesu Kristo tunoqaró ŋuro sowo mande ŋandiro. Nimí Maria koya Josep koya, epe re-re tewari, yero piŋa mande yunori iŋaŋgurí. Quko ene kopo kama yate, Maria qahu tiní qeneŋgurí. Ŋuko Yuqa Surumí qundo kho tiní qahu taró. ");
INSERT INTO nca_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josep ŋuko uni roneneŋowí. Ŋunde ŋuroko Maria qahu tiní rotowero iŋaró. Ŋunde quko unipare toŋeyemo kowi piyo Maria inowero ŋuro piyimiŋaró. Ŋunde ŋuro mondó ta rotowero iŋaró. ");
INSERT INTO nca_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josepko pare rotowero ŋuro watí iŋoyoní, Uni Parámimboro sambo simómbo suwono quko ŋande miraró, “Josep, keko Dewit koro wini qu, ke Maria pareke reweya ŋuro ma sasaro tewero. Iŋo, simó qahímo yote ŋuko Yuqa Surumí qundo re ina. ");
INSERT INTO nca_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ŋuko simó urumuni pisiyoweya. Ko owí muko Yesu ye qembe, dokoro enendo unipareyó quhuríye moŋgo yoreweya.” ");
INSERT INTO nca_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","O soso tunoqaró ŋuko Anutu koro ye-ye unindoro mande qu ka riní hamó tunoqaró. Mande ŋuko ŋandiro, ");
INSERT INTO nca_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Pare kato kamímboya kama eteyate, ŋundo simó ka urumuni pisiyoweya. Pisiyoní owí Emanuel yewaŋgo.” (Owé ŋuro murí muko ŋandiro, “Anutuko noreya yote.”) ");
INSERT INTO nca_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Asa Josep eteyate otoqoro Uni Parámimboro sambo simómbo miraró ŋu naŋge howero Maria koya epe re-re tariyó. ");
INSERT INTO nca_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Quko ene ŋuya kama eteyari, yate-yate oro Maria simó urumuni pisiyaró. Pisiyoní owí Yesu nekaró. ");
INSERT INTO nca_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Mariako Betlehem yendémo, Judia mirako ŋuno, Yesu pisiyaró. Ŋu naruko ŋuno wiri yerete uni Herot ŋundo unipare ŋuno sopo yereró. Asa Yesu pisiyoní iŋo-iŋo uni kumimbo kosa aretesinaŋgo Yerusalem ŋuno maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Mahero osese yereŋgurí, “Simó pisiyaró ŋu, ye Juda uniparetoro wiri yerete uni, ŋu dano yote? Nore eneŋo tutuyó kosa aretesina ŋuno qenero potoruku te inowero quro ŋano maheteto.” ");
INSERT INTO nca_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ŋunde yiqo, Herotko mandeye iŋoro iŋondata parámi taró. Ko Yerusalem unipare soso ŋuya iŋondata taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herotko Israel koro o qa-qa unindoro tapá unindoya hutuŋo mande ŋuro iŋo-iŋo unindoya soso neko yereró. Nekoro ŋande osese yereró, “Ŋu Kristo ŋuko, do yendé kano tunoqeweya?” ");
INSERT INTO nca_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Yiní mande topé ŋande yaŋgurí, “Ŋuko Betlehem yendémo, Judia mirako ŋuno, tunoqeweya. Dokoro ye-ye uni ŋundo ŋande nakayáŋaró, ");
INSERT INTO nca_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“‘Ke Betlehem, Judia mira koro yendé qu, keko Judia koro wiri yerete unindoro tomó qu kini. Dokoro wiri yerete uni ka ke noŋgo maheweya. Enendo Israel, neneŋo uniparene ŋu, sopo yereweya.’” ");
INSERT INTO nca_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Asa Herotko mandeye iŋoro iŋo-iŋo uni kosa aretesinaŋgo maheŋgurí ŋu mondó neko yerero tutu ŋu qeneŋgurí naruyó hamó ŋuro osese yereró. ");
INSERT INTO nca_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Osese yero ŋande yimiraró, “Ye Betlehem uyaya simó ŋu okeyá ta seqayi. Seqa qeneroqo, mande topé re mahe nimirika nopa uyaro potoruku te inowano.” Ŋunde yero asá yiriní toŋeŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mandí iŋoro toŋeŋgurí. Toŋero tutu komo kosa aretesina ŋuno qeneŋgurí mu pitu ko qeneŋgurí. Ŋu tutu ŋundo korete toŋero simó yoraró quno ŋuno uyaro koreko yaró. ");
INSERT INTO nca_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tutu qenero niŋgu-niŋgu parámi horé taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tero ya quroko oro simó ŋuya nimí Maria ŋuya yiyaŋgurí. Yiyoro potoruku tero umu-kembaye nokono raŋgurí. Ŋunde tero newonde metémboro puŋge koŋgo o taŋoro simó inaŋgurí. O newonde metémboro ŋuko ŋandiro: gol koya te sitúmi nuŋgurí meté moré muya te sitúmi meyowo nuŋgurí meté muya. ");
INSERT INTO nca_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Asa imemoŋgo Anutuko quko ŋande yimiraró, “Ye Herotko pitu ko ma owero.” Ŋunde ŋuro khe enesówore eneŋo yendéyemo toŋeŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Iŋo-iŋo uni ŋu toŋiqo, Uni Parámimboro sambo simó kato Josepko tunoqero quko ŋande miraró, “Ke otoqoya simóŋge nimí yore soreya Isip ŋuno uyi. Isip ŋuno na yoroyika nondo kimirowano. Dokoro itaka naŋge Herotko simó ŋu uroní khumoweya, yero iŋoyote.” ");
INSERT INTO nca_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yiní Josep otoqoro simó, nimí yorero suwono naŋge Isip ŋuno uró. ");
INSERT INTO nca_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Josep Isip ŋuno yoní, yate Herot khumaró. Ŋunde tero Uni Parámimboro ye-ye unindoro mande qu ka hamó tunoqaró. Mande ŋuko ŋandiro, “Nondo naŋone nekowe Isip rotoro maheró.” ");
INSERT INTO nca_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Iŋo-iŋo uni kosa aretesinaŋgo ŋundo Herot ŋunde kanáŋaŋgurí. Asa yate-yate Herotko ŋu qene iŋoro newonde tiwi parámi horé taró. Tero uni kumi asá yiriní Betlehem yendémo ko yendé tomó-tomó Betlehem sumeyoro quno ŋuno ŋuya uyareŋgurí. Uyaro simó tomó ta-ta kumima naru irisa kama rotaŋgurí qu soso yuroyi khumomukaŋgurí. Simó ŋunde qu yuraŋgurí, dokoro komo Herotko iŋo-iŋo uni do naruko tutu qeneŋgurí ŋuro osese yereró. ");
INSERT INTO nca_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","O tunoqaró ŋuko komo Anutuko ye-ye uni ka, Jeremaia, maŋgómo mande yaró qu riní hamó tunoqaró. Ene ŋande yaró, ");
INSERT INTO nca_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Tendo parámi ko sikí yambo parámi horé Rama yendémo ŋuno tunoqete. Ŋuko Reseliko simó ŋuro sikíqero tendote. Ko mepa mande kama iŋoweya, dokoro simó ŋu kini taró.” ");
INSERT INTO nca_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Asa Herot khumoní Isip ŋuno Uni Parámimboro sambo simó kato Josepko tunoqiní qu qeniní ");
INSERT INTO nca_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ŋande miraró, “Ke otoqoya simóŋgepoya nimímboya yoreya Israel ŋuno uyari. Unindo simó urowero yaŋgurí qu khumomukaŋgurí.” ");
INSERT INTO nca_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yiní Josep otoqoro simó, nimí yorero Israel mirako ŋuno uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Quko ŋande iŋaró, Herot khumoníqota naŋuní, owí Arikelaus, ŋundo meté rero Judia mira sopoyote. Asa ko Josep ŋuwore uyarewero ŋuro sasaro taró. Anutuko Josep quko mande ka mironí Galili mirako ŋuno uyaró. ");
INSERT INTO nca_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Uyaro yendé ka owí Nasaret ŋuno kunditaró. Ŋunde tero ye-ye unindoro mandeye ŋu hamó tunoqaró. Mande ŋuko ŋandiro, “Uni ŋuko, Nasaret noŋgo uni ka, ye nekowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Asa ŋu naruko ŋuno Jon, sono re-re uni ŋundo mahero Judia koro Mira Wimbímo ŋuno unipare mande yesowoyara. ");
INSERT INTO nca_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ene ŋande yaró, “Ye quhuríyemboro newonde surumí teya quhurí ŋu se roti. Dokoro sambo simburímbo unipareyó wiri yereyote naruyó ŋu tunoqewero tete.” ");
INSERT INTO nca_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ŋunde yaró, dokoro ŋu uni ŋuko, komo ye-ye uni ka, Aisaia, maŋgómo ŋande yaró, “Enendo mira wimbímo neko yerero ŋande yimirote, ‘Uni Parámimboro khe roŋgaruwoya eneŋomboro ore roneneŋoyi qembe.’” ");
INSERT INTO nca_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jonko tuwi kamel huímbo toworo kowí punuwaró. Ko makao kowímbo utóŋo toworo weheŋo newondí kusiyaró. Ko muŋa katu koya siso sonoyómboya neyara. ");
INSERT INTO nca_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Asa ŋu naruko ŋuno Yerusalem unipare, ko Judia mira koro unipare soso, ko uni soso Jotan Sono sumeyo kunditaŋgurí qu eneno maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mahero quhuríye tunomo yi Jonko Jotan Sonono sono re yunaró. ");
INSERT INTO nca_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ŋunde tiní Farisi uni qambu, Sadyusi uni qambu qundo sono rewero quro eneno maheyaŋgurí. Mahi ŋande yimiraró, “Ye sire piyimi ŋuro simó ŋu! Anutuko newonde saŋgirí tero o piyimi unipare teyoteŋgo ŋu rambaruru yerewero tete. Ye dando yimironí sore naru piyimi ŋu takawero teteŋgo? ");
INSERT INTO nca_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ŋunde ŋuroko newonde hamó rohoréŋaŋgurí ŋuro eŋgé rika tunoqiní. ");
INSERT INTO nca_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ko kina ŋande ma iŋowero, ‘Abrahamko noreŋo usinani.’ Dokoro no ŋande ye yimiroteno, Anutuko meté yiní wondo ŋu rohoréŋoro Abraham koro usi-sí tunoqewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Itaka ka soporo te toŋowero quro te hurímo yote. Ŋunde ŋuroko te soso eŋgé meté kama teyoteŋgo ŋuko toŋoro kewáko raŋoweya. ");
INSERT INTO nca_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Nondo ye sonono kina sono re yunoyoteno ŋuko newonde rohoré teyoteŋgo ŋuro rokó ŋu. Quko uni ka no huwónemo maheweya ŋuko ŋuro wimbímboko nene wimbune ŋu takate. Hamó, nondo eneŋo khe punu-punuyó korowowero owéne moré kini. Ko enendo Yuqa Surumí ŋu kewá qembe re yunoweya. ");
INSERT INTO nca_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Usú ka re towo mahero wit eŋgémboya murutómboya rondaŋeweya. Rondaŋero wit eŋgé se yano kopoweya. Quko murutómi muko se kewá ka kama khumoyote quno ŋuno qaweya.” ");
INSERT INTO nca_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ŋu naruko ŋuno Yesuko Galili rotoro Jotan Sonono uyaro Jonko ene sono re inowero ŋuno uyaró. ");
INSERT INTO nca_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Quko Jonko soréŋoro ŋande yaró, “Dokoro nono mahete? Meté keto naŋge sono re nuno,” yaró. ");
INSERT INTO nca_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yiníqo, Yesuko mande topé yaró, “Ŋu meté, enina. Noya keya khe meté naŋge howero otete roneneŋowí soso tewaro.” Ŋunde yiní sono re inaró. ");
INSERT INTO nca_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Re inoníqo, Yesuko sono roto areyoní sambo koro mako kosoní qeniní Anutu koro Yuqa qundo nú qembe tero umburo saŋanímo yaró. ");
INSERT INTO nca_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Neko ka sambo saŋa noŋgo ŋande nekaró, “Ŋako neneŋo naŋone, eneŋo surumí iŋoyoteno. Ŋuro metéŋoyoteno.” ");
INSERT INTO nca_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Asa ŋu naruko ŋuno Yuqako Yesu riní Monimbuko towoŋowero quro mira wimbímo ŋuno oró. ");
INSERT INTO nca_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ŋuno yotoro kundiŋi tero kosa suwo 40 ŋunde rotaró. Ŋunde tero qímboro khumaró. ");
INSERT INTO nca_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Uni towoŋowero uni ŋu ŋuno mahero ŋande miraró, “Ke hamó Anutu koro Naŋuní tiníkaqo, yeka wondo ŋa rohoréŋoro bret kumi tunoqiní.” ");
INSERT INTO nca_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yiníqo, Yesuko mande topé ŋande yaró, “Sokomeko ŋuno ŋande nakayáŋaró, ‘Unipareto o qoyemboro quwore naŋge yoto-yoto kama rewaŋgo. Kini. Anutu koro maŋgó howero yoto-yoto rewaŋgo.’” ");
INSERT INTO nca_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Yiníqo, Monimbuko Yesu rero yendé parámi surumímo ŋuno Ya Surumí umómo saŋano rotaró. ");
INSERT INTO nca_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Rero ŋande miraró, “Ke hamó Anutu koro Naŋuní tiníkaqo, amuno soreka kiyowe. Dokoro, sokomeko ŋande yete, “‘Enendo sambo simóŋo yimironí sopo kerewaŋgo, ko kandeyembo kore koro kerewaŋgo, wondo kato khíndoŋgemo saŋgawoweya koro.’” ");
INSERT INTO nca_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yiníqo, ŋande miraró, “Sokomeko ŋuno kaŋuya ŋande nakayáŋaró, ‘Ke Uni Parámi, keŋo Anutuke ma towoŋowero.’” ");
INSERT INTO nca_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Yiníqo, Monimbuko Yesu rero mira purí ka koreko horé ŋuno oró. Ŋunde tero uniparetoro miraye soso ko o meté-metéye mu witúŋaró. ");
INSERT INTO nca_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Witúŋoro ŋande miraró, “Ke umu-kembake nokono raŋoro neneŋo potoruku te nunoka, o soso ŋa se kunowano.” ");
INSERT INTO nca_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yiníqo, ŋande miraró, “Monimbu, ke toŋe. Sokomeko ŋuno ŋande nakayáŋaró, ‘Ke Uni Parámi, keŋo Anutuke ŋuro potoruku te inoya eneŋo khoyó naŋge te qembe.’” ");
INSERT INTO nca_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ŋunde yiní Monimbu roto toŋeró. Toŋiní sambo simómbo mahero Yesu samakaŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Asa naru kano Yesuko ŋande iŋaró, “Unindo Jon rero kusi-kusi yano raŋgurí,” ŋu iŋoro Galili mirako ŋuno uyaró. ");
INSERT INTO nca_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Uyaro Nasaret rotoro Kaperneam yendé parámimo ŋuno kunditaró. Yendé ŋuko Galili Sono Towo tapémo yaró, ŋuko Sepulun winiyómboro noko qu ko Napitali winiyómboro noko qu. ");
INSERT INTO nca_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ŋunde taró, quko komo Anutuko ye-ye uni ŋu Aisaia riní mande ka yaró qu ŋu hamó tunoqaró. Mande ŋuko ŋandiro, ");
INSERT INTO nca_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sepulun koro noko qu, Napitali koro noko qu, sono towosina Jotan Sono andusina yote ŋu, uni wini meyowomboro mira Galili ŋu, ");
INSERT INTO nca_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ŋu unipare huririko yaŋgurí ŋundo sine parámi qeneŋgurí, ko hiyó kato arero kindo khumowero quro yoŋoyómo yaŋgurí qu hiyóqaró.” ");
INSERT INTO nca_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ŋu naruko ŋuno Yesuko kho kimani tero unipare yesowo yimitoyaró. Ŋande yaró, “Ye quhuríyemboro newonde surumí teya quhurí ŋu se roti. Dokoro sambo simburímbo unipareyó wiri yereyote naruyó ŋu tunoqewero tete.” ");
INSERT INTO nca_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Asa naru kano Yesuko Galili Sono Towo tapéwore uyaro yerepasa ka khoyari tero sono qare siyori yiyaró. Ŋuko Saimon (owí kako Pita), koneyó Andru. Ŋundo tirí-tirí rero sono towoko raŋoro wosoyariyó. ");
INSERT INTO nca_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Asa yiyoro ŋande yimiraró, “Mahe nohowiri. Nondo kho ka yunowe unipare Anutusina yowosowari.” ");
INSERT INTO nca_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Waka ta tirí-tiríyari rotoro howariyó. ");
INSERT INTO nca_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesuko ŋu noŋgo uyaro yerepasa irisa meyowo ka yiyaró. Ŋuko Jems, koneyó Jon, Sepeti koro simó. Irisa ŋuro awayari muko Sepeti ŋuya waŋgo saŋano yotoro sono qarendoro tirí-tiríye roŋgaruwaŋgurí. Asa yiyoro irisa ŋu neko yereró. ");
INSERT INTO nca_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Waka ta waŋgo rotoro awayari rotoro howariyó. ");
INSERT INTO nca_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesuko Galili mira soso ŋuno uyare mahe tero huru-huru yayemo mande rondaqe yunoro sambo simburímbo unipareyó wiri yereyote naruyó ŋuro miti mande ŋu yesowo yimitoyaró. Ko se khumo kate-kate, asa o soso ŋundo unipare koweye rambaruruwaró ŋu yoriní meté taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ŋunde tiní piŋa mande ŋu yi Siria mira soso ŋuya iŋoyaŋgurí. Iŋoro unipareto se khumo uni kate-kate ŋuya uni koweye surumí teyara ŋuya eneno yore maheŋgurí. Kumi yuqa piyimi quroyemo yaŋgurí, kumi se khumoko yoriní umbu raŋoro khe kandeye yukuwoyaŋgo, kumi wimbuye khumaró ŋu. Soso yore mahi enendo yoriní meté taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Unipare qambu Galili mira koŋgo, Dekapolis mira koŋgo, Yerusalem noŋgo, Judia mira koŋgo ko noko Jotan Sonosinaŋgo mahero Yesu howeyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesuko unipare qambu ŋu yiyoro mira purímo oro kunditiní iŋo-iŋo rewero unipareyó taŋgímo maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Mahiqo, ŋandiro mande rondaqe yunaró, ");
INSERT INTO nca_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Unipareto yuqayemo onoŋoye moré kini qembe teteŋgo qundo puriŋo ka reteŋgo, dokoro, sambo simburímbo ye wiri yereyote. ");
INSERT INTO nca_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Unipareto tendoyoteŋgo qundo puriŋo ka reteŋgo, dokoro, Anutuko yemama mande yimiroweya. ");
INSERT INTO nca_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Unipareto owéye re umbuyoteŋgo qundo puriŋo ka reteŋgo, dokoro, Anutuko noko soso se yunoweya. ");
INSERT INTO nca_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Unipareto otete roneneŋowí ŋuro o qoyemboro qembe kondé iŋoyoteŋgo qundo puriŋo ka reteŋgo, dokoro, Anutuko yoriní maŋgoreweya. ");
INSERT INTO nca_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Unipareto meyowomboro sikíye te yunoyoteŋgo qundo puriŋo ka reteŋgo, dokoro, Anutuko eneŋo sikíye te yunoweya. ");
INSERT INTO nca_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Unipareto newondeye sara qundo puriŋo ka reteŋgo, dokoro Anutu qenewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Unipareto mepa mande yeyoteŋgo qundo puriŋo ka reteŋgo, dokoro Anutu koro simó, yero neko yerewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Unipareto otete roneneŋowí teyoteŋgo ŋuro quhurí korowoyoteŋgo qundo puriŋo ka reteŋgo, dokoro, sambo simburímbo wiri yereyote. ");
INSERT INTO nca_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Unipareto ye wininemo qene iŋoro mande piyimi yero quhurí yunoro mande kota-kota piyimi yero saŋga yiriqo, ye puriŋo ka reteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ŋunde tiqo, niŋgu-niŋgu parámi ti, dokoro kimoye parámi samboko rewaŋgo. Hamó, ŋundiro naŋge komo uni ŋunde qundo ye-ye uni ŋu o piyimi te yunaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Yeko noko koro nembo ŋunde qembe. Quko nembo ŋuro nuŋgurí ŋu kini tiníqo, nore date tero nuŋgurí ŋu pitu ko rewato? Nembo ŋunde ŋuko khoyó kini taró. Unindo ŋu meté raŋi kheyembo khete rumuniŋoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Yeko noko koro hiyó ŋunde qembe. Yendé ka mira purí saŋano ŋuno sóqewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Unindo suru tupuŋoro kondómo rukukuwoyoteŋgo, peka? Kini. Ene rero koreko pikoyi unindo ya quroko hiyó yunoweya. ");
INSERT INTO nca_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ŋundiro naŋge hiyó ŋunde qembe unipare hiyó yuni qembe. Ŋunde tiqo, enendo yeŋo oteteye meté qenero awaye samboko yorote ŋu seré te inowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“No Hutuŋo Mande koya Ye-ye Unindoro mandeye ŋu se rotowero quro kama mahenowó. Kini. Ŋunde ma iŋowero. Ŋu soso rewe hamó tunoqewero quro mahenowó. ");
INSERT INTO nca_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nondo mande hamó ye yimirowe, noko sambo yoroníqo, hutuŋo mande tomó ta-ta ŋuya parámi ta-ta soso ŋuya yoroweya. ");
INSERT INTO nca_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ŋunde ŋuro uni kato Anutu koro mande kondé tomó ta ka re rotoroqo, unipare witú yiriní rotoyoteŋgo, ŋuko piyimi. Uni ŋuko sambo simburímbo unipareyó wiri yereyote naruyómo ŋuno owé tomó ta naŋge reweya. Quko uni ka hutuŋo mande howeroqo, unipare witú yiriní howeyoteŋgo, ŋundo sambo simburímbo unipareyó wiri yereyote naruyómo ŋuno owé parámi horé reweya. ");
INSERT INTO nca_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ŋunde yeteno, dokoro Farisi unindoya hutuŋo mande ŋuro iŋo-iŋo unindoya, nore otete roneneŋowí hamó howeyoteto, ŋunde ye iŋoyoteŋgo. Quko yeŋo oteteye roneneŋowí muko eneŋo oteteye kama takaweya tiníqo, yendo sambo simburímbo unipareyó wiri yereyote naruyómo ŋuno kama owaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Usisambayembo mande ka iŋaŋgurí, asa ‘ma uroyi khumowero.’ Ye ŋunde iŋomukoteŋgo, ko uni kato uroní khumoweya ŋuko mande khono kaŋeweya. ");
INSERT INTO nca_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Quko nondo ŋande ye yimiroteno, uni kato topémboya saŋgirí tiníqo, ene ŋuya mande khono kaŋeweya. Ko uni kato topémboya mande piyimi yeweya tiníqo, ene uni pará-parámboro toŋeyemo kaŋeweya. Ko uni kato ŋande miroweya, ‘Keko kape-kape uni horé,’ ene meté kewá piyimi quno ŋuno uweya. ");
INSERT INTO nca_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Ŋunde ŋuroko ke oka Anutu te inowero qu rero wondo yakutímo oroqo, ŋande ye iŋoweya, toponembo o tanowó ŋuro saŋgirí tete, ye iŋoweya tiníqo, ");
INSERT INTO nca_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","o ŋu ŋuno rotoro rohoréŋoro topokepoya mande roŋgaruworoqota mahero Anutu o ŋu te ino qembe. ");
INSERT INTO nca_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ko uni kato korero mande khono korotowero khewore uyaroqo, asa yari waka ta mande roŋgaruwori qembe. Ŋunde kini tiníqo, asa uni ŋundo ronda-ronda unindoro kandímo korotoní ronda-ronda uni ŋundo sopo-sopo unindoro kandímo korotoní sopo-sopo unindo kusi-kusi yano korotoweya. ");
INSERT INTO nca_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nondo hamó kimiroteno, ke kusi-kusi yano yate wondo yaŋgurí ŋu kanaramimo kimo teroqota. ");
INSERT INTO nca_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ye mande ŋa iŋaŋgurí, ‘Ye se simbururu ma tewero.’ ");
INSERT INTO nca_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Quko nondo ŋande ye yimiroteno, uni kato pare ka qenero qene nuŋguwote tiníqo, newondímo pare ŋuya se simbururu titiri ŋunde qembe. ");
INSERT INTO nca_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ko keŋo toŋeŋge kandeke tesina ŋundo korero kowosoro o piyimi tewero tiníqo, kumo raŋoka uní. Hamó, kowekeporo sombé ŋu piyo teweya. Quko koweke soso kewá piyimimo ŋuno kama uweya. ");
INSERT INTO nca_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ko keŋo kandeke kondésina ŋundo kowosoro o piyimi tewero tiníqo, wesaŋe raŋoka uní. Hamó kowekeporo sombé ŋu piyo teweya. Quko koweke soso kewá piyimimo ŋuno kama uweya. ");
INSERT INTO nca_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ye mande ŋa iŋaŋgurí, ‘Uni kato ene parí howeweya tiníqo, kamímbo epe re-re tariyó rotowero ŋuro sokome ka parí inoweya.’ ");
INSERT INTO nca_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Quko nondo ŋande ye yimiroteno, uni kato parímbo se simbururu kama teyoní rotaró tiníqo, kamímbo pare ŋu riní se simbururu pare ka tunoqeweya. Ko danimbo pare ŋu reweya qundo se simbururu uni tunoqeweya. ");
INSERT INTO nca_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Usisambeyembo mande kaŋuya ŋande iŋaŋgurí, ŋuko ŋandiro, ‘Ke mande ka Uni Parámi mitoro ri kondéraró ŋu ma wendaqewero.’ ");
INSERT INTO nca_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Quko nondo ŋande ye yimiroteno, mandeye ka ŋundiro ri ma kondérewero. Kini horé. Ye sambo nekoro mandeye ka ri ma kondérewero, dokoro, sambo ŋuko Anutu koro kundite-kundite yakutíŋo. ");
INSERT INTO nca_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ko ye noko nekoro mandeye ka ri ma kondérewero, dokoro, noko ŋuko Anutuko khí re ŋuro saŋano imaqeyote. Ko ye Yerusalem nekoro mandeye ka ri ma kondérewero, dokoro, Yerusalem ŋuko wiri yerete uni parámi ŋuro yendé parámi horé ŋu. ");
INSERT INTO nca_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ko yeŋo kembaye nekoro mandeye ka ri ma kondérewero, dokoro, keŋombo kembakeporo huŋge ka ri sarape ma iriyó kama teweya. ");
INSERT INTO nca_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ye meté ‘Iyo’ naŋge yi qembe, ko ‘Kini’ naŋge. Koro ŋu. Ye mande kaŋuya yewaŋgo tiníqo, mande ŋuko Monimbu koro qu naŋge. ");
INSERT INTO nca_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ye komo mande ka ŋande yi iŋaŋgurí, ‘Ko uni kato topémboro toŋí ka rambaruruwoweya ŋuko, asa yendo uni ŋu ŋuya toŋí rambaruruwoyi qembe. Ko uni kato uni ka mití utoriníqo, asa yepa naŋge ene mití utori qembe.’ ");
INSERT INTO nca_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Quko nondo ye ŋande yimirowe, uni piyimimbo yeno o piyimi tewaŋgo ŋu topé ma tewero. Kini. Ko uni kato kakíŋge kawore tamoníqo, kawore ŋuya rohoréŋoka uroweya. ");
INSERT INTO nca_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ko uni kato korero kowe punu-punuke quroyómo qu rewero yero mande khono korotoníqo, meté tuwike saŋanímo ŋu ŋuya re ino qembe. ");
INSERT INTO nca_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ko uni kato korero, neneŋo onoŋone korowoya kutaqemo u, yeweya tiníqo, asa kho ŋu sowe teya kapiyamo ŋuya korowo u qembe. ");
INSERT INTO nca_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Uni kato o karo kira kereweya tiníqo, o ŋu ino qembe, ko uni kato keya utatá tewero yiníqo, ma huwóŋowero. ");
INSERT INTO nca_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ye komo mande ka ŋande yi iŋaŋgurí, ‘Ke topokeporo hamó-hamó iŋo qembe, ko saŋgiríŋgepoya newonde piyimi te qembe.’ ");
INSERT INTO nca_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Quko nondo ye ŋande yimirowe, yeŋo saŋgiríye newonde meté yunoyi qembe, ko yeno o piyimi teyoteŋgo ŋuro hariri tika Anutuko ene samaka yiriní. ");
INSERT INTO nca_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ŋunde tero ye awaye samboko yote ŋuro simó yowaŋgo. Enendo uni piyimimboya uni metémboya saŋayemo kosa riní hiyóqeyote. Ko enendo uni roneneŋowímboya uni piyimimboya sono riní umbuní yunoyote. ");
INSERT INTO nca_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ko ye uni topoyemboro naŋge hamó iŋo yunoteŋgo tiníqo, do kimo ka rewaŋgo? Qeni, ŋu takis re-re uni ŋuya murí ŋu teyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ko ye uni topoye naŋge topo te yunoyoteŋgo tiníqo, yeŋo muríyembo uni wini meyowomboro muríye ŋu takatepe ma kini? Kini. Ŋu kape uni ŋuya ŋunde teyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ŋunde ŋuroko awaye samboko yote ŋuro kiraró howi qembe. Eneko meté horé; ye ŋuya meté horé yuri qembe. ");
INSERT INTO nca_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ye oteteye meté-meté ŋu unipare witú yerewero toŋeyemo ma tewero. Toŋeyemo ŋunde tiqo, awaye samboko yote ŋundo kimo meté kama yunoweya. ");
INSERT INTO nca_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ŋunde ŋuroko ye mone ka uni onoŋoye moré kini ŋu yunowaŋgo quno ŋuno uni maŋgoye irisa ŋu ma howewero. Uni ŋundo o meté te yunowaŋgo quno ŋuno koretero kho uni ka asáŋoyi huru-huru yanope ma yendémo ŋuno uŋgu huwoyote. Hamó ŋande ye yimiroteno, uni ŋundo owé parámi hamó reteŋgo, quko ŋu kimo ŋu naŋge rewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Quko ye uni onoŋoyó moré kini qu samakaŋowero quno mondó ta naŋge samakaŋoyi qembe. ");
INSERT INTO nca_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ŋunde tero o meté te inowaŋgo ŋuko sóqeweya. Ŋunde tiqo, awayembo kho tapuŋowí ŋu qenero kimo meté re yunoweya. ");
INSERT INTO nca_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ko ye hariri tewaŋgo quno ŋuno uni maŋgoye irisa ŋu ma howewero. Naru rokóŋoro uni ŋundo owé parámi rewero quro hamó iŋoro huru-huru yanope ma kheko ŋuno uniparetoro toŋeyemo kaŋero hariri teyoteŋgo. Hamó yimiroteno, owé parámi hamó reteŋgo, quko ŋu kimo ŋu naŋge rewaŋgo. Ye otete piyimi ŋu ma tewero. ");
INSERT INTO nca_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kini, hariri tewero quro yeŋo ya quroko oya, mako tuŋoya, awaye sóqeyote ŋuwore hariri ti qembe. Ŋunde tiqo, awayembo kho tapuŋowí ŋu qenero kimo meté re yunoweya. ");
INSERT INTO nca_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ko ye hariri tewaŋgo quno kape unindo otete qu ma howewero. Kape uni ŋundo hariri teroqo, mande qambu-qambu yeyoteŋgo. Dokoro ŋande iŋoyoteŋgo, mande wata yatoqota anutunanimbo hamó mandenani iŋoweya. Ŋunde ma tewero. ");
INSERT INTO nca_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Muríye ŋu ma howewero. Dokoro awayembo ye o karo tukuni teteŋgo ŋuro komo iŋomukaró. ");
INSERT INTO nca_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Ŋunde ŋuroko meté ŋandiro hariri ti qembe, “‘Awanani, ke samboko yote, keŋo owéŋge surumí yoní, ");
INSERT INTO nca_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","keŋombo nore wiri yereyote naruke ŋu reka mahiní, samboko ŋuno iŋo-iŋoke hamó tunoqeyote, ŋundiro naŋge meté nokono ŋuya hamó tunoqiní. ");
INSERT INTO nca_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Itaka naru ŋano o qonanimboro nuno. ");
INSERT INTO nca_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kowe noreŋo utatánani ŋu se roto nuno, dokoro, utatá noreya taŋgurí ŋu soso se roto yunoyoteto. ");
INSERT INTO nca_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ko nore norika okato kama towo nereweya, kini, o piyimi horé mu noŋgo nore qembe.’ ");
INSERT INTO nca_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Iŋoyi. Ko ye uniparetoro quhuríye roto yunowaŋgo tiníqo, yeŋo awaye samboko yote ŋundo yeŋo quhuríye ŋu se rotoweya. ");
INSERT INTO nca_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Quko ye uniparetoro quhuríye kama se rotowaŋgo tiníqo, awayembo yeŋo quhuríye ŋu kama se rotoweya. ");
INSERT INTO nca_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ko ye kundiŋi tewaŋgo quno ŋuno uni maŋgoye irisa ŋu ma howewero. Uni ŋundo kundiŋi teyoteŋgo quno ŋuno umu-kembaye piyo teyoteŋgo. Ŋunde tiqo, unipare soso, ene Anutuko iŋoro kundiŋi tero quhurí korowoteŋgo, ye iŋoro owéye hokoyoteŋgo. Hamó yimiroteno, ŋu kimo ŋu naŋge rewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Quko ye kundiŋi teroqo, huye roŋgaruwoya umu-kembaye sonowoyi qembe. ");
INSERT INTO nca_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ŋunde tiqo, unipareto kundiŋi teyoteŋgo ŋu kama iŋowaŋgo. Quko awaye sóqeyote ŋundo iŋoweya. Ko awayembo kho tapuŋowí ŋu qenero kimo meté re yunoweya. ");
INSERT INTO nca_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Asa ye situwi se nokono ŋano ma kopowero. Ŋano situwi ŋu siwí koya paráqi koya rambaruruwoweya. Ko momo unindo hoŋgo toŋo wisiyoro momo tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kini, sambo koro situwi ŋu samboko ŋuno se kopoyuri. Samboko ŋuno situwi ŋu siwí koya paráqi koya kama rambaruruwoweya. Ko momo unindo hoŋgo toŋo wisiyoro momo kama tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ŋunde ti qembe, dokoro dano situwiye yote, ŋu ŋuro iŋomukoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Toŋenani ŋuko kowenanimboro hiyó qu. Ke toŋeŋge meté tiníqo, asa hiyó ŋundo koweke soso hiyóqeyoweya. ");
INSERT INTO nca_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ko ke toŋeŋge piyimi tiníqo, asa koweke soso huriri teyote. Ŋunde ŋuro hiyó qurokemo yote ŋuko huriri naŋge tiníqo, huriri ŋuko piyimi horé. ");
INSERT INTO nca_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Uni kato sopo-sopo uni irisa quro kho qu tewero mepémo kini. Dokoro enendo karo newonde meté inoweya, ko karo newonde piyimi inoweya. Kaya womoweya, ko kako yesaráŋoweya. Ŋunde naŋge ye Anutu koya situwi koya irisa-irisa kasirayarimo yowero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ŋu murí ŋuro nondo ŋande ye yimiroteno, yeŋo yoto-yotoyemboro iŋaŋawí tero ŋande ma yewero, ‘Do o ka newato? Do sono ka newato?’ Ko koweyemboro iŋaŋawí tero ŋande ma yewero, ‘Do tuwi ka kusiyowato?’ Qeni, yoto-yotoye ŋuro murí muko o newero qu naŋge, peka? Ko koweye ŋuro murí muko tuwi naŋge, peka? Ŋunde kini. ");
INSERT INTO nca_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nú ŋundo teyoteŋgo ŋuro iŋoyi. Khono oka kama rimiteŋgo, kho noŋgo eŋgé kama siyoyoteŋgo, o newero qu se huruworo yano kama reyoteŋgo. Quko awaye samboko yote ŋundo wutu yereyote. Asa Anutu koro toŋímo yendo nú taka yereyoteŋgo, hamómbe? ");
INSERT INTO nca_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ko ye dani kato iŋaŋawí tero yoto-yotoyó meté wosoro sowe teweya? ");
INSERT INTO nca_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ko ye do karo tuwi koro iŋondataqeyoteŋgo? Nuŋo wimbo-wimbo yoteŋgo ŋu qeni. Koweyumu kama teyoteŋgo, tuwi kama towoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Quko no ŋande ye yimiroteno, Solomon ŋundo tuwi meté horé qu se reyaró, quko nuŋo ŋuro nakayámbo Solomon koro tuwi meté-meté ŋu takate. ");
INSERT INTO nca_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Itaka komó ŋunde qu yoteŋgo, ko kuyepo naŋge unindo toŋoro kewáko raŋi uweya. Anutuko oka naru tukuni yorote ŋunde qu o nakayá meté mu inoyote. Asa ye unipare iŋondutuye tomó ta naŋge, iŋoyi, enendo ye ŋuya sopo yerero tuwi yunoweya. ");
INSERT INTO nca_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ŋunde ŋuroko iŋaŋawí tero ŋande ma yewero, ‘Do o ka newato? Do sono ka newato? Do tuwi ka kusiyowato?’ ");
INSERT INTO nca_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Hamó, kape unipareto o soso ŋunde quro iŋoro seqayoteŋgo. Quko yeŋo awaye samboko yote ŋundoko ye o ŋuro tukuni teteŋgo ŋu iŋomukote. ");
INSERT INTO nca_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Koretero Anutuko unipareyó wiriyote naruyó ŋuro kondé iŋoyikata ene o soso ŋu ŋuya se yunoweya. ");
INSERT INTO nca_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ŋunde ŋuroko o kuyepo tunoqeweya quro ma iŋondataqewero. Kuyepo ŋuko eneŋombo naŋge iŋondataqeweya. Quhurí itaka tunoqete ŋuro naŋge iŋoyi qembe. ");
INSERT INTO nca_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ye unindoro muríye yiyoro ma ronda yerewero. Anutuko yeŋo muríye qene rondaŋeweya koro. ");
INSERT INTO nca_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Dokoro yendo date uni yiyoro ronda yereyoteŋgo, ŋuko ŋundiro naŋge Anutuko ye yiyo rondaŋeweya. Ko ye date uni o te yunoyoteŋgo rokóŋo ŋuwore naŋge Anutuko meté te yunoweya. ");
INSERT INTO nca_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Ke do karo topokeporo murutó ka toŋímo yote ŋu qene iŋoyote, quko ke te puŋo ka keŋo toŋeŋgemo yote ŋu kama qene iŋoyote? ");
INSERT INTO nca_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ko te puŋo ŋu toŋeŋgemo naŋge yoníqo, asa ke date tero topoke ŋande miroweya, ‘Topo, murutó toŋeŋgemo yote ŋu re rotowe?’ ");
INSERT INTO nca_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ke uni maŋgoye irisa, koreteroqo te puŋo parámi keŋo toŋeŋgemo yote ŋu re rotoroqota ke meté toŋetero murutó tomó ta topoke toŋímo yote ŋu meté se rotoweya. ");
INSERT INTO nca_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ye Anutu koro o qu rero á sawa ma yunowero. Ko yeŋo pehe meté-meté ŋu se raŋoyi poko ma uwero. Raŋoyi, yate poto kheyembo woŋomuniŋowaŋgo koro, ko isako rohoréŋoro ye yikiwaŋgo koro. ");
INSERT INTO nca_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ye kirayoyikata o se yunoweya; o seqaroqota qenewaŋgo; mako uroyikata mako koso yunoweya. ");
INSERT INTO nca_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Dokoro uni soso kirayoteŋgo ŋundo o ŋu siyoyoteŋgo; uni soso o seqayoteŋgo ŋundo o ŋu qeneyoteŋgo; uni soso mako utoyoteŋgo, ŋuro mako kosoní inoweya. ");
INSERT INTO nca_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ko ye kato simóye kato iwí kirayoro bret ka re nuno yiníqo, iwímbo wondo ka re inoweya, peka? Kini. ");
INSERT INTO nca_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ko simómbo iwí kirayoro sono qare nuno yiníqo, iwímbo sire piyimi ka re inoweya, peka? Ŋu ŋuya kini. ");
INSERT INTO nca_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yeko quhurí uni naŋge quko simóye o meté yunoyoteŋgo. Ŋunde ŋuroko awaye samboko yorote ŋu kirayoyiqo, o meté-meté mu se yunoweya, hamómbe? ");
INSERT INTO nca_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Yendo unipareto otete soso yeno te yunowaŋgo ŋuro kondé iŋoyoteŋgo ŋuko ye otete ŋu naŋge eneno te yunoyi qembe. Dokoro otete ŋuko Hutuŋo Mande koya Ye-ye Unindoro mandeye ŋuro murí. ");
INSERT INTO nca_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Mako kiŋiwí tomó ta qurowore oyi qembe. Piyo tewero mako ŋuko koŋó parámi, ko khe ŋuwore ŋuko parámi horé. Ko unipare qambu qundo khe ŋu howeyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Quko yoto-yoto rewero mako ŋuko kiŋiwí horé, ko khe ŋuno owero ŋuko tuŋiyowero qu. Asa ko unipare kanata-kanatako naŋge qenero khe ŋu howeyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ye-ye uni kota-kota ŋuro sori qembe. Enendo uni ime qembe tero, sipsip ŋunde qembe teteŋgo. Quko newondeye quroko uni saŋgirí naŋge, á sawa qembe teteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Uni ŋuro muríyembo eŋgé teyote. Ye eŋgé ŋu qenero uni muríye ŋuro iŋomukowaŋgo. Asa uni kato utó kamí moré moŋgo wain taŋgurí siyoweya, peka? Ko uni kato utó yuyumi moré moŋgo fik taŋgurí siyoweya, peka? Ŋunde kini. ");
INSERT INTO nca_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ŋundiro naŋge te meté ŋundo eŋgé meté naŋge teyoteŋgo. Ko te piyimi ŋundo eŋgé piyimi naŋge teyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Te meté kato eŋgé piyimi mu tewero mepémo kini. Ko te piyimi kato eŋgé meté mu tewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Te soso eŋgé meté mu kama teyoweya ŋuko, toŋoro kewáko raŋoyi qaweya. ");
INSERT INTO nca_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Asa ko yendo ye-ye uni kota-kota ŋuro muríyemboro eŋgé qenero muríye ŋuro iŋomukowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ye ŋande ma iŋowero, uni soso neneŋo, ‘Uni Parámi, Uni Parámi,’ ye neko nereyoteŋgo ŋundo sambo simburímbo unipareyó wiri yereyote naruyómo owaŋgo. Kini. Uni ka awane samboko yorote ŋuro iŋo-iŋoyó howeyote ŋundo naŋge ŋuno owaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Naru kano Anutuko unipare soso ronda yereweya. Ŋu naruko ŋuno unipare wata qundo ŋande nimirowaŋgo, ‘Uni Parámi, Uni Parámi, nore keŋo mande qu owéŋgemo yatowó. Keŋo owéŋgemo yuqa piyimi yohowato uni quro koŋgo toŋeŋgurí. Keŋo owéŋgemo o wimbí moré enesó-enesó rato tunoqaró.’ ");
INSERT INTO nca_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ŋunde yesowoyi ŋande yewano, ‘No kama iŋo yunoteno. Ye o piyimi teyoteŋgo ŋu, toŋi.’ ");
INSERT INTO nca_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ŋunde ŋuroko uni ka mandene ŋa iŋoro howeyote tiníqo, uni ŋuko iŋo-iŋoyó meté. Eneko uni kato mipu parámi wemboroŋoro yayómboro tatá ŋuno raŋaró ŋunde qembe. ");
INSERT INTO nca_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Sono umbuní, sono riru tunoqiní, matú wimbí mahiní, o soso ŋundo ya utaqiní kama umbu raŋaró. Dokoro, mipu parámi ŋundo tatá kondé towoyara. ");
INSERT INTO nca_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Asa uni kato mandene ŋa iŋoro kama howeyote tiníqo, uni ŋuko kape-kape uni naŋge. Eneko uni ka yayómboro tatá sotamano raŋaró ŋunde qembe. ");
INSERT INTO nca_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Sono umbuní, sono riru tunoqiní, matú wimbí mahiní, o soso ŋundo ya utaqiní umbu raŋoro hamó rambaruruwaró.” ");
INSERT INTO nca_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesuko ŋunde yiní unipare parámi ŋundo mandí iŋoro kondé yukuwaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Dokoro, mandí ŋu wimbí moré, ko hutuŋo mande ŋuro iŋo-iŋo unindoro mandeye ŋunde qembe kini. ");
INSERT INTO nca_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesuko mira purí rotoro uníqo, unipare qambu parámi howero uŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Asa kowí piyimi khumo uni kato mahero potoruku te inoro ŋande yaró, “Uni Parámi, keto ŋu iŋi mepémo tiníqo, no nori sara tewano.” ");
INSERT INTO nca_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yiníqo, Yesuko kandí saŋanímo rero miraró, “No ŋuro iŋoteno. Ke sara teweya.” Yiní waka ta se khumo ŋuno qu kini tiní sara taró. ");
INSERT INTO nca_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tiní Yesuko ŋande miraró, “O ŋa keno tunoqete ŋaro uni ka ma yimirowero. Hutuŋo mande Mosesko yimiraró ŋu howeya o qa-qa uni koweke re witú yereya keto sara tunoqete quro oka Anutu te ino qembe. Ŋunde tiqo, se khumoke kini tete, ye iŋowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Asa Yesuko Kaperneam yendémo oníqo, Rom koro kuma unindoro sopo-sopo uni kato Yesu kondé ŋande kirayaró, ");
INSERT INTO nca_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Uni Parámi, sunará simóne se khumo tero yano eteyote. Wimbí muko soso khumoní kowí surumí parámi tete.” ");
INSERT INTO nca_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yiní ŋande miraró, “Meté nondo toŋe rewe meté teweya.” ");
INSERT INTO nca_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Yiní ŋande miraró, “Uni parámi, no uni meté kini, ŋuro ke neneŋo yano date areweya? Quko keto kina mande yekata sunará simóne ŋu meté teweya. ");
INSERT INTO nca_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Dokoro no ŋuya uni owéye moré mu kasirayemo yowe sopo nereyoteŋgo. Kowe nondo uni ka mirowano, ‘Ke toŋe,’ yeweqo, toŋeyote. Ko ka mirowano, ‘Ke mahe,’ yeweqo, maheweya. Kho simóne mirowano, ‘Kho ŋu te,’ yeweqo, ŋunde teweya.” ");
INSERT INTO nca_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesuko mande ŋu iŋoro iŋondata parámi tero uni howeyaŋgurí ŋu ŋande yimiraró, “No ye hamó ŋande yimirowe, uni ŋaro iŋondutuyó parámi ŋandiro qu ka Israel unipare keweroyemo kama qeneno. ");
INSERT INTO nca_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nondo ye yimirowe, unipare qambu kosa aretesinaŋgo kosa utesinaŋgo mahero sambo simburímbo unipareyó wiri yereyote naruyómo ŋuno kunditero Abraham, Aisak, Yakop koya o newaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Quko uni ŋu, noreko wiri yereyote naruyómboro simó horé, ye iŋoyoteŋgo ŋuko, Anutuko yohowiní huriri yendémo ŋuno uwaŋgo. Ŋusina ŋunoko tendo piyimi tero metoye kindotowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ko Yesuko kuma unindoro sopo-sopo uni ŋande miraró, “Ke toŋe. O date komo iŋondutu ta ŋu keno tunoqeweya.” Ŋunde yiníqo, ŋu naruko ŋuno naŋge sunará simó meté taró. ");
INSERT INTO nca_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Asa Yesuko Pita koro yayómo oro Pita koro koŋgí qeniní se khumo tero kowí tiwi riní yakutímo eteyaró. ");
INSERT INTO nca_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Eteyoní kandímo towoní, se khumo ŋu kini tiní otoqoro Yesu koro o qímboro roŋgaruwaró. ");
INSERT INTO nca_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Suwoya tiníqo, unipareto topo-topoye yuqa piyimi quroyemo yaŋgurí ŋu yore Yesuko maheŋgurí. Mahi mande ka yiní yuqa piyimi ŋundo unipare yorotaŋgurí. Ko enendo se khumo uni ŋu yoriní pitu ko meté taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ŋunde tero mande ka komo Anutuko ye-ye uni Aisaiawore yaró ŋu riní hamó taró. Ŋande yaró, “Eneŋombo noreŋo kowenani ime ŋu raró, ko se khumo kate-kate korowaró.” ");
INSERT INTO nca_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Asa Yesuko unipare qambu horé wuririyo kaŋeyuri yiyoroqo, iŋo-iŋo rewero uniyó ŋande yimiraró, “Nore sono towo karóŋoro andusina uyato.” ");
INSERT INTO nca_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Yero toŋiqo, hutuŋo mande ŋuro iŋo-iŋo uni kato mahero ŋande miraró, “Rondaqe-rondaqe uni, ke dana uyareweya qunoko no ŋuya kohowe ŋuno uyarewano.” ");
INSERT INTO nca_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yiníqo, ŋande miraró, “Á sawa ŋuko meréye noko quroko yote, nú ŋuya yaye moré. Quko Unindoro Naŋuní ŋuko etewero mirayó moré kini.” ");
INSERT INTO nca_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ko iŋo-iŋo rewero uni meyowo ka ŋande miraró, “Uni Parámi, norotoka no toŋeya awane re tapuŋowekata.” ");
INSERT INTO nca_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Quko Yesuko ŋande miraró, “Kini, ke maheya no nohowe. Uni khumowí ŋundoko topoye khumoteŋgo ŋu se tapu yerewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ŋunde yero waŋgo saŋano oníqo, iŋo-iŋo rewero uniyómbo howe toŋeŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Toŋeyate sono towo keweroko uyariqo, matú parámi horé mahero sono towo huwoní tambi-tambi toqero waŋgo tomó ta ŋu weheŋowero taró. Quko Yesuko eteyaró. ");
INSERT INTO nca_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Eteyoní okokoworo ŋande yaŋgurí, “Uni Parámi, nore samaka nere, piyo tewe teteto.” ");
INSERT INTO nca_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yiqo, ŋande yimiraró, “Iŋondutuye muko tukuni. Do karo soreteŋgo?” Ŋunde yero otoqoro matú koya windi koya qene yiní irisa-irisa imaqariyó. ");
INSERT INTO nca_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ŋunde tiriqo, uni ŋundo iŋondata parámi tero ŋande yaŋgurí, “Do uni kato meté yiní matú koya windi koya imaqitiri?” ");
INSERT INTO nca_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Asa Yesuko sono towo andusina uyaroqo, Gatara koro mira ŋuno maheró. Mahiní uni irisa yuqa piyimiyari moré mu uni tapu noŋgo mahero kheko kopaŋgurí. Irisa ŋuko saŋgirí uni horé, ŋunde ŋuroko unipare khe ŋuwore toŋewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Asa mahero kondé ŋande kiwariyó, “Ke Anutu koro Naŋuní, ke do nereweya? Kepe Anutuko naru rokóŋaró ŋu takaro itaka naŋge o piyimi te nunowero mahete, peka?” ");
INSERT INTO nca_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Po qambu o nero soŋga kapiyamo yoraŋgo. ");
INSERT INTO nca_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Asa yuqa piyimimbo Yesu kondé ŋande kirayaŋgurí, “Ko keto nore nohoweweya tiníqo, nore norotika po qambu ŋu quroyemo uwato.” ");
INSERT INTO nca_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yiqo, ŋande yaró, “Ye toŋi,” yiníqo, yuqa piyimi ŋundo uni irisa ŋu yorotoro po quroko uŋgurí. Uyiqo, po ŋundo purí titiní moŋgo romboŋero sono quroko ŋuno khumaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ŋunde tiqo, po sopo-sopo unindo qenero sore toŋero yendé parámimo uyaro o tunoqaró ŋuro unipare yimiraŋgurí. Ko uni irisa ŋuko yuqa piyimi quroyarimo yora, do ka eneno tunoqaró ŋuro yimiraŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Asa yendé unipare ŋuno qu soso Yesuko maheŋgurí. Mahero kondé miraŋgurí, ko miraye ŋu rotoro meyowomo toŋeweya, yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Asa Yesuko waŋgo kano oroqo, sono koŋiwí karóŋo andusina uyaro eneŋo yendéyómo ŋuno uyaró. ");
INSERT INTO nca_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Uyariní unipareto se khumo uni ka khí irisa-irisa ukumi yakutímo eteyaró ŋu re koroworo eneno maheŋgurí. Mahiqo, Yesuko yiyoro, hamó iŋondutu teyoteŋgo, ye iŋoro se khumo uni ŋu ŋande miraró, “Naŋone, newondeke kondé yoní. Keŋo quhuríŋge se rotoní.” ");
INSERT INTO nca_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ŋunde yiníqo, hutuŋo mande ŋuro iŋo-iŋo uni kumimbo newondeyembo ŋande iŋaŋgurí, “Uni ŋako Anutu yesaráŋoyote.” ");
INSERT INTO nca_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesuko iŋo-iŋoye qene iŋoro ŋande yaró, “Ye date koro iŋo-iŋo piyimi ŋunde qu newondeyemo yote? ");
INSERT INTO nca_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Iŋi, nondo, ‘Quhuríŋge se rotoní,’ ye mirowano tiníqo, ŋuko wuruwara mande peka, ye eŋgé qenewero mepémo kini. Quko, ‘Ke otoqoya khete-khete uyare,’ ŋunde yewano tiníqo, ŋu quhurí, dokoro eŋgé tunomo yoní ye qene iŋowaŋgo, hamómbe? ");
INSERT INTO nca_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Quko ŋande iŋi, Unindoro Naŋuní ŋundo nokono ŋano unindoro quhuríye se rotowero quro wimbí tete.” Ŋunde yero uni khí piyimi ŋu ŋande miraró, “Ke otoqoya yakutíŋge re korowoya, yakemo u.” ");
INSERT INTO nca_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Yiníqo, otoqoro yayómo uyaró. ");
INSERT INTO nca_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Uyariní unipare qambu ŋundo qenero sasaro taŋgurí. Anutuko wimbu ŋunde qu uni ka yunaró ŋu qene iŋoro Anutu seré te inaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Asa Yesu uyaro, uni ka, owí muko Matyu qeniní takis rewero paseno kunditeyaró. Kunditiní ŋande miraró, “Ke maheya no nohowe.” Yiní otoqoro Yesu howaró. ");
INSERT INTO nca_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Imemoŋgo ta Yesu yano etero iŋo-iŋo rewero uniyómboya o naŋgurí. Nero takis re-re unindoya quhurí unindoya o naŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Niqo, Farisi unindo yiyoro iŋo-iŋo rewero uniyó ŋande osese yereŋgurí, “Dokoro yeŋo rondaqe-rondaqe uniyembo takis re-re unindoya quhurí unindoya o kopo neyoteŋgo?” ");
INSERT INTO nca_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Quko Yesuko mandeye iŋoro ŋande yaró, “Uni se khumoye moré kini quko dotako ŋuno kama uyareyoteŋgo. Kini. Se khumo unindo naŋge dotako uyareyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ye uyareya iŋo-iŋo rewero quro Anutuko mande yaró ŋu weyoyi qembe, ‘No o qa-qa te nunowero ŋuro kama iŋoteno. Kini, ye sikíye te yunowero ŋuro iŋoteno.’ Iŋo-iŋo ŋu ri qembe, dokoro uni roneneŋowí ŋu neko yerewero quro kama mahenowó. Kini. No quhurí uni ŋu neko yerewero quro mahenowó,” yaró. ");
INSERT INTO nca_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ŋu naruko ŋuno Jon koro iŋo-iŋo rewero uniyómbo Yesuko mahero ŋande oseseyaŋgurí, “Date koro noreya Farisi unindoya naru qambu quno o newero ŋuro kundiŋi teyoteto, quko keŋo iŋo-iŋo rewero unike ŋuko o newero quro kundiŋi kama teyoteŋgo?” ");
INSERT INTO nca_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yiqo, ŋande yimiraró, “Ko uni kato epe re-re tewero o ne-ne naruko ŋuno topé-topémbo newonde quhurí tewaŋgope, ma kini? Kini. Quko imemoŋgo ta uni ŋu ri toŋeweya. Ŋu naruko ŋuno naŋge topé-topémbo kundiŋi tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Uni kato tuwi sombé keta qu rero tuwi komo qu wituyó mu kama tiŋiyoweya. Kini. Imemoŋgo kowe punu-punu sonowoníqo, tuwi keta ŋu wosoníqota piyimi horé wuriweya. ");
INSERT INTO nca_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Uni kato wain keta qu meme kowí puŋge komo quno ŋuno kama kusíŋoyote. Ŋunde tiníqo, puŋge ŋu wuriní wain sonoyó windoroŋoro nokono umbuweya, ko puŋge ŋuya piyo teweya. Ŋunde ŋuroko wain keta ŋuko puŋge keta quno naŋge kusíŋoyoteŋgo. Ŋunde ti irisa-irisa meté yowari.” ");
INSERT INTO nca_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Asa Yesuko mande ŋu yeyoníqo, uni kembé ka mahero Yesu taŋgímo kutaqemo potoruku te inoro ŋande yaró, “Neneŋo nambone itaka ka kindo khumote. Ŋuko keto maheya kandeke saŋanímo reka pitu ko yoto-yoto riní.” ");
INSERT INTO nca_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ŋunde yiní Yesu otoqoro howero toŋiní iŋo-iŋo rewero uniyó ŋuya howero toŋeŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Pare ka ŋuno yora, kumima naru 12 ŋunde rotoro naru rokóŋo sitú raŋoyara. Asa uyariyate pare ŋu Yesu huwósina mahero tuwiyó piru ŋu tapémo pekáŋaró. ");
INSERT INTO nca_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Dokoro newondímbo ŋande yaró, “Tuwiyó pekáŋoroqota pitu ko meté tewano.” ");
INSERT INTO nca_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Quko Yesuko rohoréŋo qenero ŋande miraró, “Nambone, newondeke kondé yoní. Keŋo iŋondutukepo koriní meté tete.” Ŋu naruko ŋuno naŋge pare ŋu meté taró. ");
INSERT INTO nca_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Asa uyareyate Yesu uni kembé ŋuro yano maheró. Mahiní uni kumimbo kusí huwoyi unipare qambu niriye parámi teyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yiyoro ŋande yimitoyaró, “Ye otoqoya toŋi. Dokoro pare tomó ta ŋuko kama khuma. Kini, eteyote.” Yiníqo, iŋoro kundo mande yero yomaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Quko unipare yohowiní mirako uyiqo, ya quroko oro pare tomó ta ŋuro kandí towaró. Towoní ene otoqaró. ");
INSERT INTO nca_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ŋunde tiní mira soso ŋuno Yesuko o taró ŋuro piŋa mande iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Asa Yesu yendé ŋu roto toŋiní uni irisa toŋeyari kiré mu ŋuya howero ŋande nekoyariyó, “Dewit koro naŋuní, sikínari te nuno qembe.” ");
INSERT INTO nca_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yiri Yesu ya quroko oníqo, toŋeyari kiré ŋundo eneno oriyó. Ori Yesuko ŋande osese yereró, “Yarindo nondope o ŋa yarino meté tewanope, yero iŋondutu titiripe, ma kini?” Yiní mande topé yariyó, “Uni Parámi, iyo, iŋondutu tetero.” ");
INSERT INTO nca_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Arisa kandí rero toŋeyarimo rero ŋande yaró, “Yari iŋondutu titiri, ŋunde ŋuroko o ŋu yarino tunoqeweya.” ");
INSERT INTO nca_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yiníqo, toŋeyari hiyóqaró. Ko Yesuko mande kondé ŋande yunaró, “Ŋaro uni ma yimirowero.” ");
INSERT INTO nca_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Quko uni irisa ŋundo uyaro mira soso ŋuno Yesu ŋuro piŋa mande yimirariyó. ");
INSERT INTO nca_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Asa uni irisa ŋu roto toŋiriqo, unipareto uni ka maŋgó kakayiwí mu ko yuqa piyimi ŋuno yora qu, ŋu re Yesuko maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mahi Yesuko yuqa piyimi ŋu howiní maŋgó kakayiwí ŋu mande yaró. Ko unipare iŋondata parámi tero ŋande yaŋgurí, “Komo Israel koro mirako ŋano o ka ŋunde qu ŋano kama tunoqeyara.” ");
INSERT INTO nca_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Quko Farisi ŋundo ŋande yaŋgurí, “Eneko yuqa piyimi ŋuro kembéye moŋgo wimbí rero yuqa piyimi ŋu yohoweyote.” ");
INSERT INTO nca_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Asa Yesu uyaro yendé pará-paráwore ko yendé tomó-tomówore ŋuya uyaró. Uyaro Juda koro huru-huru yano oro mande rondaqe yunoyaró, ko sambo simburímbo unipareyó wiri yereyote naruyó ŋuro miti mande ŋu yesoworo yimitoyaró, ko se khumo koweyewore ŋuno qu yoriní meté taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ŋu naruko ŋuno unipare parámi mahi yiyoro sikíye taró. Dokoro, quhurí parámi korowaŋgurí, ko samaka-samakaye moré kini, asa sipsip ka sopo-sopoye moré kini ŋunde qembe yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ŋunde yiyoro iŋo-iŋo rewero uniyó ŋande yimiraró, “O newero qu khono parámi eŋgé tete, quko kho tero eŋgé siyowero ŋuro uniyó qambu kini. ");
INSERT INTO nca_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ŋunde ŋuroko kho simburí kirayoka kho uni asá yiriní uyaro o ŋu se kopowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Asa Yesuko iŋo-iŋo rewero uniyó 12 ŋu neko yiriní mahiqo, wimbu yunaró. Wimbu ŋuko yuqa pusú unipareko yoteŋgo ŋu yohowewero quro, ko se khumo kate-kate soso ŋu yori meté tewero ŋuro quya. ");
INSERT INTO nca_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Asá yerewí uni 12 ŋuro owéye muko ŋandiro. Uni korete ŋuko Saimon, owí kako Pita, koya koneyó Andru. Ko Jems, ŋuko Sepeti koro naŋuní, koya koneyó Jon. ");
INSERT INTO nca_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ko Filip koya Bartolomeyu, ko Tomas koya Matyu, ŋuko takis re-re uni. Ko Jems, ŋuko Alipeus koro naŋuní, koya Tatius. ");
INSERT INTO nca_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ko Saimon, ŋuko Selot koro wini ka, koya Jutas Isikariot, imemoŋgo ŋundo Yesu re uni piyimi kandeyemo rotaró. ");
INSERT INTO nca_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Asa Yesuko uni 12 ŋu asá yerero ŋande yimiraró, “Yeko uni wini meyowo quno ŋuno ma uyarewero. Ko Samaria koro yendéyemo ma uyarewero. Kini. ");
INSERT INTO nca_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Yeko Israel koro wini quko, sipsip ka khe rotaŋgurí qu qembe yoteŋgo, ŋuno naŋge uyari qembe. ");
INSERT INTO nca_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ye toŋeya mande ŋande yesowoyi, ko sambo simburímbo unipareyó wiri yereyote naruyó ŋu tunoqewero tete. ");
INSERT INTO nca_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ye toŋeya se khumo uni yorika meté ti, uni khumaŋgurí mu yorika otoqi, koweye piyimi khumo uni ŋu yorika sara ti, ko yuqa piyimi mu unipareko yoteŋgo ŋu yohowi. O komo kina tuwó siyaŋgo ŋu tuwó yunoyi. ");
INSERT INTO nca_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mone golpe ma silwape ma kapa ŋu ma puŋgeyowero. ");
INSERT INTO nca_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Puŋge ka ma rumo toŋewero. Ko ye kowe punu-punu irisa ŋuya ma siyowero, khe punu-punu ŋuya ma siyowero, tesaŋga towo toŋewero qu ŋuya kama siyowero. Uni kho teyote ŋuko, o newero qu meté reyote. ");
INSERT INTO nca_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ye yate yendé parámimbe ma tomó quno ŋuno uroqo, do uni kato yeŋo mandeye meté iŋoweya ŋu seqayi qembe. Asa yendé ŋuno yotoroqo, eneya naŋge kunditi qembe. ");
INSERT INTO nca_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ŋandiro, ya ka quroyómo oroqo, “Naru meté,” yimiroyi qembe. ");
INSERT INTO nca_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ko ya ŋuro simburímbo ye yorewero niŋgu-niŋgu tiqo, newonde ime yuni qembe, quko yorewero piyimiŋoyiqo, newonde ime ŋu pitu ko ri qembe. ");
INSERT INTO nca_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ko uni kato yorero yayómo kama oníqo, ko yeŋo mandeye kama iŋoníqo, asa ye meté yape ma yendé ŋu rotoroqo, noko murutómi kheyemo ŋu siyoyi umbuweya. ");
INSERT INTO nca_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nondo mande hamó ye yimirowe teteno, naru Anutuko unipare soso ronda yereweya quno Sotom unindoya Gomora unindoya topé piyimi rewaŋgo. Quko ŋu yendé yeya topo kama tewaŋgo qu ŋundo topé piyimi horé rewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Iŋoyi. Nondo ye sipsip ŋunde qembe yorewe yendo á sawa keweroyewore toŋewaŋgo. Ŋunde ŋuroko ye sire qembe do khe ka howewaŋgo ŋu kondé rondaŋi qembe, ko nú qembe murí piyimi ma howewero. ");
INSERT INTO nca_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ye unindoro iŋondataqi qembe. Enendo ye yorero uni kembémboro kandeyemo yorotiqo, Juda koro huru-huru yano haususu yerewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Yeko owéne towoyoteŋgo, ŋu murí ŋuro uni ŋundo yorero wiri yerete uni parámi toŋeyemo ko uni kembé-kembé toŋeyemo yoroti kaŋewaŋgo. Ŋunde tiqo, wiri yerete uni ko uni wini meyowo soso ŋundo ye yiyoro neneŋo muríne qenewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Asa yate ye yorero mande khono yorotiqo, sasaro tero ŋande ma iŋowero, ‘Nore mande ka date yewato? Ko nore topé date yewato?’ Kini. Ŋu naruko ŋuno naŋge mande date yewero ŋu witú yiriní yesowowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Dokoro, yeŋombo mande ŋu kama yesowowaŋgo. Kini, Awayemboro Yuqayómbo yeŋo maŋgoyembo mande yesowoweya. ");
INSERT INTO nca_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Payómbo koneyó mande piyimi ye inoníqo, uroyi khumoweya. Kowe iwímbo simómboya ŋunde naŋge teweya. Kowe simómbo iwí-nimímboya ŋunde naŋge ti khumowari. ");
INSERT INTO nca_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ko uni soso newonde piyimi horé yeya iŋowaŋgo, dokoro neneŋo owéne muko yeno yorote. Quko dani kato kondé kaŋeyate rambaruru takaweya. ");
INSERT INTO nca_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ko unipare yendé ka noŋgo qundo o piyimi te yunoyiqo, ye meté soreya yendé meyowomo toŋi qembe. Dokoro no mande hamó ye yimiroteno, yeko Israel koro yendéne-yendéne ŋuno watí uyareyoní Unindoro Naŋuní maheweya ŋu.” ");
INSERT INTO nca_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Iŋo-iŋo rewero unindo rondaqe-rondaqe uniye kama taka yereyoteŋgo, ko sunará simómbo uni parámiye kama taka yereyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Iŋo-iŋo rewero uni ŋuko rondaqe-rondaqe uniyemboro kiraróye tewero ŋuro iŋoyoteŋgo. Ko sunará simó ŋuko uni parámiyemboro kiraróye tewero ŋuro iŋoyoteŋgo. Unindo ya simburí owé, Belisipulu, ye nekoyoteŋgo tiníqo, enendo simburímboro topé-topé ŋuya owé piyimi neko yerewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ŋunde ŋuroko uni karo ma sorewero. Dokoro o pokawí soso ŋu tunomo tunoqeweya. Mande soso sóqeyote ŋu unindo ŋu iŋowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mande suwono yimiroteno ŋuko ye kosano yi qembe. Mande mondó qu itaka kusumboyembo iŋoteŋgo, ŋuko ye ya umó moŋgo yesowo yimiri qembe. ");
INSERT INTO nca_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Unindo kowenani uroyi khumoweya ŋuko yuqanani uroyi khumowero mepémo kini. Uni ŋuro ma sorewero. Kini, Anutuko yuqaye, koweye irisa-irisa raŋoní kewá piyimimo ŋuno uweya ŋuro naŋge sori qembe. ");
INSERT INTO nca_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Qeni, uni kato nú tomó ta ka wondo musiyó tomó ta qundo kimo teteŋgo, hamómbe? Ko nú ŋu nokono rokaráŋo uweya tiníqo, yeŋo awayemboko hamó iŋoweya. ");
INSERT INTO nca_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ko enendo huye datiro kembayemo yote ŋu soso iŋomukote. ");
INSERT INTO nca_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ŋunde ŋuroko ye ma sorewero. Yendo nú tomó ta-ta ŋu taka yereteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ŋunde ŋuroko uni kato unipare toŋeyemo yesoworo nono womoweya tiníqo, no awane samboko yote ŋuro toŋímo yesoworo eneya womowano. ");
INSERT INTO nca_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Uni kato unipare toŋeyemo huwó nereyote tiníqo, no ŋuya awane toŋímo ene huwóŋowano. ");
INSERT INTO nca_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Iŋi, nondo nokono ŋano newonde ime yunowero quro kama umbunowó. Kini. Kiro kuma yunowero quro umbunowó. ");
INSERT INTO nca_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Hamó, nondo mahero “‘naŋunímbo iwímboya epe usowo-sowo tewari, nambunímbo nimímboya epe usowo-sowo tewari, nepímbo nepímboya epe usowo-sowo tewari, ");
INSERT INTO nca_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","uni kato winiyómboya saŋgirí tewaŋgo.’ ");
INSERT INTO nca_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Uni kato iwí-nimímboro surumí parámi teyote, quko neneŋo surumí tomó ta teyote, ŋuko neneŋo topone kama yorote. Uni kato nambo-simómboro surumí parámi teyote, quko neneŋo surumí tomó ta teyote, ŋuko neneŋo topone kama yorote. ");
INSERT INTO nca_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Uni kato tipiririyó re koroworo no kama nohoweyote ŋuko, ene neneŋo topone kama yorote. ");
INSERT INTO nca_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Uni kato yoto-yotoyómboro iŋomukoyote ŋuko yoto-yotoyó rotoweya. Quko uni kato nohowero yoto-yotoyó rotoweya ŋuko yoto-yoto horé reweya. ");
INSERT INTO nca_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Uni kato ye yorero o meté te yunote ŋuko no norero o meté te nunote. Ŋunde tero enendoko uni asá nereró ŋuya o meté te inote. ");
INSERT INTO nca_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Uni kato, ‘No ye-ye uni samaka yerewe,’ ye iŋoro ye-ye uni ka o meté te inote, ŋuko Anutu koro ye-ye unindoro kimoye ŋu reweya. Uni kato, ‘No uni roneneŋowí samakaŋowe,’ ye iŋoro uni roneneŋowí ka o meté te inote, ŋuko uni roneneŋowímboro kimoye ŋu reweya. ");
INSERT INTO nca_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Uni kato, ‘No Yesu koro iŋo-iŋo rewero uni samakaŋowe,’ ye iŋoro iŋo-iŋo rewero uni owé moré kini qu sono kiŋo inote quko, no mande hamó yimiroteno, uni ŋuro kimoyó ŋuko kama piyo teweya.” ");
INSERT INTO nca_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesuko eneŋo iŋo-iŋo rewero uniyó 12 ŋu mande yimironí kini tiní ŋu noŋgo toŋero uniparetoro yendéyemo mande rondaqe yunoro Anutu koro mandí yesowo yimitoyaró. ");
INSERT INTO nca_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Asa Jon kusi-kusi yano yotoro Kristoko kho taró ŋuro piŋa mande iŋaró. Ŋunde iŋoro ene iŋo-iŋo rewero uniyó asá yiriní uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Eneno uyaro ŋande oseseyaŋgurí, “Kepe uni maheweya ŋuro iŋatowó ŋumbe ma nore meyowo ka sopowato?” ");
INSERT INTO nca_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ŋunde yi Yesuko mande topé ŋande yimiraró, “Ye uyareya o soso iŋoro qeneteŋgo ŋu Jon miroyi. ");
INSERT INTO nca_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Toŋeye kiré mu toŋetero o qeneyoteŋgo, kheye piyimi mu khete uyareyoteŋgo, koweye piyimi khumo qu sara teyoteŋgo, kusumboye tuwo qu mande iŋoyoteŋgo, uni khumowí mu otoqoyoteŋgo, onoŋoye moré kini qu miti mande iŋoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kowe uni ka neneŋo iŋoro iŋondutuyó kama piyo teweya ŋuko puriŋo ka rete.” ");
INSERT INTO nca_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yiní iŋoro toŋi Yesuko unipare qambu ŋu Jon ŋuro ŋande yimiraró, “Ye do ka qenewero mira wimbímo uyareŋgurí? Matúmbo tamá ka okokowoyote ŋumbe qenewero ŋuno uyareŋgurí, peka? Kini. ");
INSERT INTO nca_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Quko ye do ka qenewero ŋuno uyareŋgurí? Uni ka kowe punu-punuyó meté-meté mu teyonímbe ŋu qenewero uyareŋgurí, peka? Kini, uni kato tuwi meté-meté mu punuworo nakayá enesó-enesó tero o meté-meté mu siyoteŋgo qundo wiri yerete unindoro yayemo yoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Quko ye do ka qenewero ŋuno uyareŋgurí? Ye-ye uni ka qenewero uyareŋgurí, hamómbe? Iyo, ko no ŋande ye yimiroteno, ŋu ye-ye uni ŋundo ye-ye uni kumi taka yerete. ");
INSERT INTO nca_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ŋu uni ŋuro naŋge sokomeko ŋuno ŋande nakayáŋaró, “‘Iŋo, nondo uni ka mande yesowo yimitoyoweya qu asáŋowe koretero uro keŋo khe qu roŋgaruwoweya.’ ");
INSERT INTO nca_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Ye hamó yimirowe, sono re-re uni ŋu, Jon koro owí ŋundoko nokono uni soso owéye takate. Quko sambo simburímbo unipareyó wiri yereyote naruyómo ŋuno uni ka owí tomó ta ŋundo Jon takate. ");
INSERT INTO nca_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Sono re-re uni ŋu, Jon, ŋundo kho kimani tero mande yesowaró ŋu noŋgo yate itaka mahete ŋa, sambo simburímbo unipareyó wiri yereyote naruyó ŋu quhurí korowote, ko unindo naruko ŋuno owero quro kuma teyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Dokoro Ye-ye Unindoro mandeyemboya Hutuŋo Mande ŋuyako Anutu koro mande yeyuri naŋge yate-yate Jon maheró. ");
INSERT INTO nca_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ko yendo iŋoweroqo, asa iŋoyi. Sokomeko ŋande yaró, Elaija ŋundo kaŋuya maheweya. Asa ŋuko Jon naŋge. ");
INSERT INTO nca_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Uni ka kusumbí moré tiníqo, mande ŋa iŋoweya. ");
INSERT INTO nca_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ko nondo unipare itaka yoteŋgo ŋuro muríyemboro tapara mande date yesowowano? Eneko simó ta-ta yendé keweroko kunditero simó ta-ta meyowo neko yerero ŋande yeyoteŋgo, ");
INSERT INTO nca_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“‘Nore kusí huwoyatowó, quko ye kama quno raŋgurí, Nore sikí yambo yatowó, quko ye kama tendoyaŋgurí.’ ");
INSERT INTO nca_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Ŋunde yeteno, dokoro Jonko mahero o parámi kama neyara, wain parámi kama neyara. Kowe unindo ŋande yaŋgurí, ‘Yuqa piyimi quroyómo yote.’ ");
INSERT INTO nca_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Unindoro Naŋuní mahero o qímboro neyote. Ko yendo ŋande yeyoteŋgo, ‘Uni ŋuko o nero qahí parámi tinditete, wain parámi nero kape-kape teyote. Eneko takis re-re unindoya quhurí unindoya topo teyote.’ Ŋunde yeyoteŋgo, quko iŋo-iŋo meté horé ŋundo eŋgé meté riní tunoqeweya.” ");
INSERT INTO nca_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesuko ŋunde yero yendé pará-pará kumimboya kiro mande yimitoyaró. Dokoro yendé ŋuno o wimbí moré teyaró, quko unipareto newonde rohoré kama taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Asa ŋande yaró, “Ye Korasin, ininiyaqe, ye Betisaita, ininiyaqe. Ye quhurí piyimi korowowaŋgo. Ko o wimbí moré keweroyemo tanowó ŋuko komo yendé meyowo Tair, Saiton ŋuno tunoqaró tiníqo, unipare ŋundo qenero newonde rohoré tero newonde surumí koro tuwi qu punuworo nombo kembaye saŋano raŋaŋgurí, peka. ");
INSERT INTO nca_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Hamó, quko ŋande ye yimiroteno, Anutuko unipare ronda yereweya naruyómo ŋuno yendé uniparetoro kimoye piyimi ŋundo Tair, Saiton uniparetoro kimoye takaweya. ");
INSERT INTO nca_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ko ye Kaperneam, ye yoriní samboko ona owaŋgo, peka? Kini, uni khumowí ŋuro yendéyemo amuno uwaŋgo. Ko o wimbí moré ye keweroyemo tanowó ŋuko komo Sotom yendémo ŋuno tunoqaró tiníqo, yendé ŋuko itaka yorote. ");
INSERT INTO nca_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Hamó, quko ŋande ye yimiroteno, Anutuko unipare soso ronda yereweya quno ŋuno yeŋo kimoye piyimi ŋundo Sotom koro kimoye piyimi ŋu takaweya.” ");
INSERT INTO nca_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ŋu naruko ŋuno Yesuko ŋande yaró, “Awa, keko sambo koro, noko koro Uni Parámi. Keŋo seréŋge teteno, dokoro ke komo o ŋa se tapuŋoyi iŋo-iŋo unindo kama iŋaŋgurí. Kowe uni kumi oŋa qembe yoteŋgo qu witú yereró. ");
INSERT INTO nca_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Iyo, Awa, keŋo nuŋguríŋge howero ŋunde taró.” ");
INSERT INTO nca_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yero Yesuko ŋande yaró, “Awanembo o soso re kandenemo raró. Iwímbo naŋge Naŋuní iŋo inoyote, uni kato kama iŋote. Kowe Naŋunímbo naŋge Iwí iŋo inoyote, ko Naŋunímbo uni ka Iwí witú yereyote ŋu ŋuyako Iwí iŋo inoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ye soso koweyumu tero quhurí korowoyoteŋgo ŋu nono mahi. Nondo newonde ime yunowano. ");
INSERT INTO nca_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ye owéye re umbuya no kusuŋonemo yotoro mandene iŋoyi qembe. Dokoro no saŋgirí uni kini, ko owéne kama rewe oyote. Ŋunde tero yeŋo newondeye imaqeweya. ");
INSERT INTO nca_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Hamó, ye no kusuŋonemo yoteŋgo tiníqo, khe meté howewaŋgo, ko kho taŋo qu yunowano.” ");
INSERT INTO nca_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Naru kano, Sapat naru kanoko ŋuno, Yesuko wit koro kho ka kewerowore yateyaró. Yate-yate iŋo-iŋo rewero uniyómbo o koro khumoro wit simó kumi siyoro neyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Niqo, Farisi unindo yiyoro Yesu ŋande miraŋgurí, “Hutuŋo mande ŋundo otete ŋu soréŋoro, Sapat naruko ŋuno ŋu ma tewero, yete. Do karo keŋo iŋo-iŋo rewero unikepo ŋunde teteŋgo?” ");
INSERT INTO nca_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ko Yesuko mande topé ŋande yimiraró, “Yembe komo Dewit o komo taró ŋuro sokome ŋumbeka kama weyaŋgurí? Eneya winiyómboya o koro khumaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Khumoro Dewitko hutuŋo mande wendaqero Anutu koro yano oro bret ka Anutu koro toŋímo yote qu re umburo eneya topé-topémboya kopo naŋgurí. Bret ŋuko enendo kama rewero qu, o qa-qa unindo naŋge newaŋgo qu. ");
INSERT INTO nca_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ko yendo peka Hutuŋo Mande ŋumbeka kama weyaŋgurí, ŋundo ŋande yete, asa Sapat naruko o qa-qa unindo Anutu koro Ya Surumímo kho tewaŋgo, quko potóye moré kini. ");
INSERT INTO nca_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Asa nondo ŋande ye yimirowe, oka ŋano yote, ŋundo Anutu koro Ya Surumí ŋu takate. ");
INSERT INTO nca_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mande ka sokomeko ŋande yete, ‘No o qa-qa te nunowero ŋuro kama iŋoteno. Kini, ye sikíye te yunowero ŋuro iŋoteno.’ Ŋunde yete, ko yendo mande ŋuro murí okeyá ta iŋaŋgurí tiníqo, mande kho uni potóye moré kini kama yunoweya. ");
INSERT INTO nca_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Dokoro Unindoro Naŋuní ŋundo Sapat naruyó ŋu sopoyote.” ");
INSERT INTO nca_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ŋunde yero toŋero yendé kano uyaro huru-huru yaye quroko oró. ");
INSERT INTO nca_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Oní uni ka kandí kasina khumaró qu ŋuno yora. Asa kumimbo Yesu mande kho inowero quro iŋaŋgurí, ŋunde ŋuroko ŋande oseseyaŋgurí, “Uni kato Sapat naruko ŋuno se khumo uni roŋgaruwoweya tiníqo, hutuŋo mande ŋu wendaqeweyape ma kini?” ");
INSERT INTO nca_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yiqo, ŋande yimiraró, “Ye keweroyemo uni kato sipsipyó moré, ko Sapat naruko sipsip ka meré kano uweya. Uni ŋundo kho tero sipsip toworo wosoní areweya, hamómbe? ");
INSERT INTO nca_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Quko sipsip ŋuko o tomó ta, uni kako o parámi. Ŋunde ŋuroko norendo Sapat naruko ŋuno murí meté te inowato tiníqo, hutuŋo mande kama wendaqewato.” ");
INSERT INTO nca_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ŋunde yero uni ŋu ŋande miraró, “Kandeke raŋo.” Yiní kandí raŋoní pitu ko meté taró, kandí kawore meté ŋunde naŋge. ");
INSERT INTO nca_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Quko Farisi unindo ya rotoro huruworo mande kusiyoro Yesu uroyi khumoweya ŋuro oreyó seqaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesuko Farisi koro iŋo-iŋoye qene iŋoro yendé ŋu roto toŋeró. Toŋiní unipare qambu qundo howero toŋeŋgurí. Ŋunde howi enendo soso se khumoye moré mu yoriní meté ti ");
INSERT INTO nca_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ŋande yiyo yaró, “No dani yero uni meyowo ŋu ma yimirowero.” ");
INSERT INTO nca_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ŋunde taró ŋundo Anutu koro mande ka ye-ye uni Aisaia yaró ŋu riní hamó taró. Ŋande yaró, ");
INSERT INTO nca_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ye neneŋo sunará simóne qeni. Neneŋombo rokóŋanowó. Ŋuro surumí iŋoyoteno, ŋuro niŋgu-niŋgu hamó teyoteno. Nondo Yuqane rero eneno rewano, ko enendo hamó moŋgo uni wini soso ronda yereweya. ");
INSERT INTO nca_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kiro mande ka kama yeweya, kama kiweweya, ko unipareto yendémo ŋuno maŋgó kama iŋowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tamá toqero rokoreŋoweya, ŋu soso kama toqeweya, ko te suru pukatutu teyote ŋuko kama winzumoweya. Ŋunde teyate murí roneneŋowí mu riní o soso takaweya. ");
INSERT INTO nca_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kowe uni wini soso ŋundo owímo o meté siyowero ŋuro ene sopowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Asa ŋu naruko ŋuno naŋge uni ka yuqa piyimi mu quroyómo yora qu rero Yesuko maheŋgurí. Uni ŋuko maŋgó kakayiwí mu ko toŋí kiré mu. Ko Yesuko uni ŋu riní meté tiní mande yero toŋetaró. ");
INSERT INTO nca_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ŋunde tiní newondeye uroní unipare soso niŋgu-niŋgu tero ŋande yaŋgurí, “Asa, uni ŋako Dewit koro naŋuní ŋumbeka?” ");
INSERT INTO nca_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Quko Farisi unindo ŋuro qene iŋoro ŋande yaŋgurí, “Uni ŋundo yuqa piyimi ŋuro kembéye, Belisipulu, ŋuro wimbímo naŋge yuqa piyimi ŋu yohoweyote.” ");
INSERT INTO nca_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesuko iŋo-iŋoye ŋu iŋoro ŋande yimiraró, “Ko wiri yerete unindoro mira qu kato usoworo uni soso wini irisa tero kuma tewaŋgo tiníqo, mira ŋuko piyo teweya. Ko yendé katope ma suwisawi kato usoworo wini irisa tero kuma tewaŋgo tiníqo, irisa-irisa kondé kama kaŋewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ŋunde naŋge, ko Monimbuko eneŋo winiyó yohoweweya tiníqo, usoworo wini irisa teteŋgo. Date tero ene wimbu rero winiyó wiri yereweya? ");
INSERT INTO nca_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ko hamó Belisipulu ŋundo samaka niriní yuqa piyimi yohoweyoteno tiníqo, asa dandoko yeŋo winiye ŋu samaka yiriní yuqa piyimi yohoweyoteŋgo? Ŋundiro naŋge yeŋo winiye ŋundoko ye ronda yerewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Quko Anutu koro Yuqa qundo no samaka niriní yuqa piyimi yohoweyoteno tiníqo, Anutuko unipareyó wiri yereyote naruyó ŋuko yeno mahete. ");
INSERT INTO nca_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Date teroqo, uni kato uni kondémboro yayó quroko oro oyó siyoweya? Enendo uni kondé ŋu kusiyoroqota yano oro oyó soso siyoweya. ");
INSERT INTO nca_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Uni ka noya topo kama teweya ŋuko noya saŋgirí teyote. Uni ka noya kama kopoyote ŋuko yoriní wisikaraŋoyote. ");
INSERT INTO nca_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ŋunde ŋuro no ye yimiroteno, Anutuko yeŋo quhuríye soso ko yesará yereyoteŋgo qu soso se rotoweya. Quko uni kato Yuqa Surumí yesaráŋoweya tiníqo, Anutuko ŋu quhurí ŋu kama re rotoweya. ");
INSERT INTO nca_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ko uni kato Unindoro Naŋuní yesaráŋoweya tiníqo, Anutuko ŋu quhurí ŋu re rotoweya. Quko uni kato Yuqa Surumí yesaráŋoweya tiníqo, Anutuko ŋu quhurí ŋu itaka ŋano ko imemoŋgo ŋuya kama re rotoweya. ");
INSERT INTO nca_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ko te ka meté yoníqo, te koro eŋgé ŋuya meté. Ko te ka piyimi yoníqo, eŋgé ŋuya piyimi. Unindo te ŋuro eŋgé qeneroqota iŋowaŋgo, te ŋu metémbe ma piyimi. ");
INSERT INTO nca_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yeko sire piyimi ŋuro simó ŋu. Ye uni piyimi, asa date tero mande meté qu yewaŋgo? Dokoro okato newondeye riní maŋgore areyoní maŋgoyembo yeyote naŋge. ");
INSERT INTO nca_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Uni meté ŋundo iŋo-iŋo meté qundo newondí riní maŋgoriní murí meté teyote. Uni piyimi ŋundo iŋo-iŋo piyimi qundo newondí riní maŋgoriní murí piyimi mu teyote. ");
INSERT INTO nca_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Quko nondo ye yimiroteno, Anutuko unipare ronda yereweya naruko ŋuno unipare soso mande wimbo-wimbo yaŋgurí ŋuro mande kho rewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Dokoro Anutuko mandeyewore ronda yereweya. Hamó, mandeyewore, roneneŋowí mu, ye neko yereweya, peka, ko mandeyewore topé piyimi ka yunoweya, peka.” ");
INSERT INTO nca_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Asa hutuŋo mande ŋuro iŋo-iŋo uni kumimboya Farisi uni kumimboya Yesu ŋande miraŋgurí, “Rondaqe-rondaqe Uni, norendo keto rokó ka teka nore qene iŋato, keko Anutu koro kho qu teyote.” ");
INSERT INTO nca_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Quko enendo mande topé ŋande yimiraró, “Itaka unipare ŋano quko unipare piyimi ko newondeye hamó rero Anutu kama inoyoteŋgo. Naru rokóŋoro rokó ka qenewero nekoyoteŋgo. Quko rokó ka kama qenewaŋgo. Kini. Rokó kanata na qenewaŋgo, ŋuko ye-ye uni Jona koro rokó qu. ");
INSERT INTO nca_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonako sono qare parámi qahí quroko ŋuno kosa kapusa suwo kapusa ŋunde yora. Ŋunde naŋge Unindoro Naŋuní ŋuya kosa kapusa suwo kapusa noko quroyómo ŋunde yoweya. ");
INSERT INTO nca_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Komo suki Jonako mande yesowaró quno ŋuno Niniwe unindoko newonde rohoré taŋgurí. Ŋunde ŋuroko imemoŋgo, Anutuko unipare soso ronda yereweya quno ŋuno Niniwe unindoko unipare ŋano qu yorero mande khono yorotoyi topé piyimi rewaŋgo. Dokoro itaka uni kanata keweroyemo yote, owímbo Jona koro owí takate. ");
INSERT INTO nca_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Komo suki wiri yerete pare kato mira kapiyamo amu noŋgo arero Solomon koro iŋo-iŋo meté horé iŋowero maheró. Ŋunde ŋuroko imemoŋgo, Anutuko unipare ronda yereweya quno ŋuno pare ŋundo otoqoro unipare ŋano qu yorero mande khono yorotoweya. Dokoro itaka uni kato keweroyemo yote, ŋuro owímbo Solomon koro owí takate. ");
INSERT INTO nca_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ko yuqa pusú uni ka rotoroqo toŋero mira harimo wimbo-wimbo toŋero mira imaqewero qu ŋu seqayote, quko qenewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ko ene ŋande yeweya, ‘No pitu ko uyareya pase komo yorano quno ŋuno yorowano.’ Yero toŋero ya ŋu qeniníqo, kina yoweya, ko unindo ya ŋu murutó siyoyi toŋiní meté yote. ");
INSERT INTO nca_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ŋunde ŋuro ene toŋero yuqa piyimi kande saŋiyoro irisa yore mahewaŋgo. Yuqa kande saŋiyoro irisa ŋuro muríye piyimi ŋuko eneŋo murí takaweya. Mahero ya ŋuro quroyómo yowaŋgo. Koreteroqo, piyimi tomó ta yora, quko itakako hamó-hamó piyimi parámi horé yoweya. Ŋundiro naŋge unipare piyimi itaka nokono ŋano yoteŋgo qundo ŋunde tunoqeweya.” ");
INSERT INTO nca_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesuko unipare qambu ŋu mande yimitoyoní, nimímboya kone-topémboya mahero eneya mande yewero koro yendémo kaŋeyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ko uni kato ŋande miraró, “Iŋo, keŋo náŋge, kone-topoke kaŋero ke kiyowero yeteŋgo amu.” ");
INSERT INTO nca_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Quko Yesuko mande topé ŋande yaró, “Dani katoko neneŋo náme, one-topone?” ");
INSERT INTO nca_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Yero kandí raŋoro iŋo-iŋo rewero uniyó kande supi yerero ŋande yaró, “Qeni, ŋako neneŋo náme, one-topone. ");
INSERT INTO nca_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Dokoro danimbo awane samboko yote ŋuro iŋo-iŋoyó howeyoteŋgo, ŋuko neneŋo one-topone, kuwone, náme.” ");
INSERT INTO nca_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ŋu naruko ŋuno naŋge Yesu ya noŋgo mirako umburo Galili Sono Towo tapémo kunditaró. ");
INSERT INTO nca_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kunditiní unipare qambu parámi wuririyoyi waŋgo tomó ta quroko uro sono saŋano kunditero mande yimiraró. Yimironí unipare soso sono towo tapémo ŋuno kaŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ŋuno kaŋeyuri tapara mande yero o parámi yimiraró. Ŋande yaró, “Iŋoyi, naru kano uni kato o yuwoyó khono se kuriyaró. ");
INSERT INTO nca_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kuriyoníqo, kumi muko kheko umbuyi númbo mahero nemukaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kowe kumi muko noko wondo seqemo quno ŋuno umburo noko ŋuno waka ta toŋí raŋoro wotaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Quko hurí meté kama uró. Ŋuroko wotiqo, kosako qeniní asáqaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kumi kakari keweroko umburo wotaŋgurí, ko kakari muko noko kiruwó wosoro kosa saki riní eŋgé kama taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kowe kumi muko noko meté muno ŋuno umburo wotiqo, kumi eŋgé 100, kumi 60, ko kumi 30 ŋundiro eŋgé taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Asa uni ka kusumbí moré tiníqo, mande ŋa iŋoní.” ");
INSERT INTO nca_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tukúko iŋo-iŋo rewero unindo mahero Yesu ŋande oseseyaŋgurí, “Ke date koro tapara mande yero mande ka unipare yimitoyote?” ");
INSERT INTO nca_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yi mande topé ŋande yaró, “Dokoro sambo simburímbo unipareyó wiri yereyote naruyó ŋuro mande tapuŋowí kumi rondaqe ye yunanowó, unipare meyowo ŋu kama yunanowó. ");
INSERT INTO nca_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Uni ka o kumi towote tiníqo, Anutuko o kumi kaŋuya saŋanímo rero inoní parámi towoweya. Ko uni oyó moré kini ŋuko, Anutuko o tomó ta qu towoyote ŋu siyoní kini teweya. ");
INSERT INTO nca_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ŋa murí ŋaro naŋge nondo tapara mande ene yimitoyoteno, asa “toŋeyembo toŋeteyoteŋgo, quko oka kama qeneyoteŋgo. Kusumboyembo iŋoyoteŋgo, quko mande iŋoro iŋo-iŋo kama reyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ŋu unipare ŋuko, Aisaia koro mande ka ŋuno hamó tunoqaró. Ene ŋande yaró, “‘Yendo naru parámi mande iŋoyowaŋgo, quko mande ŋuro murí kama iŋoyi tondaŋeweya. Naru parámi qeneyowaŋgo, quko kama iŋoyowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Dokoro unipare ŋando newondeye komo kondéraró, ko kusumboyembo meté mande kama iŋoyote, ko toŋeye wisumuŋaŋgurí. Toŋeyembo oka qenewaŋgo koro, ko kusumboyembo oka iŋowaŋgo koro, ko newondeyembo mande murí iŋowaŋgo koro, ko rohoréŋoro nono mahi nondo yorewe meté tewaŋgo koro.’ ");
INSERT INTO nca_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Quko yendo puriŋo ka reteŋgo. Dokoro yeŋo toŋeyembo o qeneyote, kusumboyembo mande iŋoyote. ");
INSERT INTO nca_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mande hamó yimiroteno, komo quno ye-ye uni qambu ŋuya uni roneneŋowí qambu ŋuyako o itaka qeneyoteŋgo ŋu qenewero surumí iŋoyaŋgurí, quko kama qeneŋgurí. Ko enendo mande itaka ye iŋoyoteŋgo ŋu iŋowero surumí iŋoyaŋgurí, quko kama iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ŋunde ŋuroko tapara mande uni yuwoyó khono kuriyaró ŋuro murí iŋoyi. ");
INSERT INTO nca_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Unipare soso qundo Anutuko unipareyó wiri yereyote naruyómboro mande iŋoyoteŋgo, quko kama iŋoyi tondaŋete, ŋuko yuwoyó kheko umbuŋgurí ŋundiro. Ŋunde ti Monimbuko mahero mande newondeyemo kuriyaró qu ŋu supiyo siyoyote. ");
INSERT INTO nca_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","O yuwoyó noko wondo seqemo yote quno ŋuno umburó, ŋuko unipareto mandí ŋu iŋoro rero niŋgu-niŋgu teyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Quko hurí noko quroko kama uyote. Asa ko quhurí korowoyoteŋgope ma unindo ŋu mande ŋuro o piyimi te yunoyoteŋgo quno ŋuno waka ta rotoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ko yuwoyó kakari keweroko umbuŋgurí ŋuko ŋandiro: uni mande ŋu iŋoyote. Quko naru kano noko koro o quro iŋaŋawí teyote, ko mone parámi siyowero ŋuro murí ŋuko kanáŋoyote. O enesó ŋundo Anutu koro mande ŋu weheŋoní eŋgé moré kini. ");
INSERT INTO nca_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kowe yuwoyó noko meté muno umbuŋgurí ŋuko ŋandiro: uni ŋundo Anutu koro mande ŋu iŋoro murí hamó-hamó iŋoyi tondaŋeyote. Ŋuko eŋgé teyoteŋgo, eŋgé 100pe ma 60pe ma 30.” ");
INSERT INTO nca_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesuko tapara mande kaŋuya ŋande yimiraró, “Sambo simburímbo unipareyó wiri yereyote naruyó ŋuko uni kato o yuwoyó meté mu khono rimiró ŋunde qembe. ");
INSERT INTO nca_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Asa uni rimiro eteyaró quno ŋuno saŋgirí kato mahero komó piyimi ŋuro yuwoyó siyoro wit keweroko ŋuno rimiro toŋeró. ");
INSERT INTO nca_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Wit wotero eŋgé tiníqo, komó piyimi ŋu ŋuya ŋuno woteyaró. ");
INSERT INTO nca_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Asa kho simburímboro sunará simó kato uyaro ŋande miraŋgurí, ‘Awa, kepe o yuwoyó meté mu naŋge khokemo raŋarómbe, ma kini? Asa dokoro komó piyimi ŋuya ŋuno woteyote?’ ");
INSERT INTO nca_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Yi ŋande yimiraró, ‘Saŋgirí uni kato o ŋu taró.’ “Yiní oseseyaŋgurí, ‘Ke iŋoka nore uyareya komó piyimi ŋu kumo rato?’ ");
INSERT INTO nca_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Yi ŋande yimiraró, ‘Kini, ye komó piyimi ŋu kumoro wit ŋuya kumowaŋgo koro. ");
INSERT INTO nca_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ye rotoyika irisa-irisa ŋuno woteyori. Eŋgé siyowero naruko ŋunoqota eŋgé siyowero uni ŋu ŋande yimirowano, “Koretero komó piyimi ŋu kumoro witumoro tepo qawero. Wit ŋu siyoro o newero yanemo ŋuno ri qembe.” ’” ");
INSERT INTO nca_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tapara mande kaŋuya ŋande yimiraró, “Sambo simburímbo unipareyó wiri yereyote naruyó ŋuko mastet koro musiyó ŋunde qembe. Asa uni kato mastet koro musiyó ŋu rero khoyómo rimiyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Musiyó ŋuko o khono woteyote kumi ŋuro taŋgurí ŋunde kini. Kini, ŋuko tomó ta horé. Quko wotero, yate parámi horé teweya ko o kate-kate khono woteyote ŋu takaro te parámi tunoqeweya. Asa ko númbo mahero kambinímo ŋuno ya reyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Tapara mande kaŋuya ŋande yimiraró, “Sambo simburímbo unipareyó wiri yereyote naruyó ŋuko yis ŋunde qembe. Asa pare kato yis ŋu rero plaua parámi ŋuya huruworo rohoréŋoní koparó. Ko imemoŋgo plaua ŋu soso koŋero parámi taró.” ");
INSERT INTO nca_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Mande soso Yesuko unipare qambu yimiraró ŋuko tapara mandeko naŋge yeyaró. Enendo mande kako tapara mande kini ŋu kama yeyaró. ");
INSERT INTO nca_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ŋu muríwore naŋge ye-ye unindo mande ka komo yaró riní hamó tunoqaró. Ŋande yaró, “Tapara mande naŋge ye yimirowano, mande ka komo suki-suki o quroko yora ŋuro yewano.” ");
INSERT INTO nca_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Asa Yesuko unipare yorotoro ya quroko oró. Ko iŋo-iŋo rewero uniyó eneno mahero ŋande yaŋgurí, “Komó piyimi mu khono wotaró ŋuro tapara mande ŋuro murí ŋu ye nimito,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yi mande topé ŋande yimiraró, “Uni ŋu taŋgurí meté qu kuriyaró, ŋuko Unindoro Naŋuní. ");
INSERT INTO nca_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ko kho ŋuko noko parámi ŋa. Ko taŋgurí meté ŋu, ŋuko sambo simburímbo unipareyó wiri yereyote naruyómboro unipare meté qu. Ko komó piyimi ŋuko Monimbu koro unipareyó. ");
INSERT INTO nca_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Uni saŋgirí ŋundo o yuwoyó piyimi ŋu kuriyaró, ŋuko Monimbu. O rewero naruyó ŋuko naru weŋa qu. Kho uni o rewaŋgo ŋuko sambo simó naŋge. ");
INSERT INTO nca_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Ŋunde ŋuroko komó piyimi ŋu koporo kewá qayote quno ŋuno qaŋgurí, ŋundiro naŋge naru weŋa quno ŋunde naŋge tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Unindoro Naŋunímbo sambo simóŋo asá yiriní enendo unindo unipare yowosoyi quhurí teyoteŋgo ŋuya uni hutuŋo mande wendaqeyoteŋgo ŋu soso wiri yereyote naruyó moŋgo se rotowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Enendo yore raŋi kewá piyimi qayote quno ŋuno uwaŋgo. Kewáko ŋunoko tendo piyimi tero metoye kindotowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ŋu naruko ŋuno unipare roneneŋowí awayemboro wiri yereyote naruyómo kosa hiyóqeyote ŋundiro naŋge hiyóqewaŋgo. Uni ka kusumboye moré tiníqo, mande ŋa iŋoyi. ");
INSERT INTO nca_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Sambo simburímbo unipareyó wiri yereyote naruyó ŋuko ŋandiro. Uni kato o meté parámi ka noko kano noko quroko qenero rero kaŋuya tapuŋaró. Tapuŋoro hamó niŋgu-niŋgu tero uyaro onoŋoyó soso soweyoro uya noko ŋu kimaró. ");
INSERT INTO nca_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Asa sambo simburímbo unipareyó wiri yereyote naruyó ŋuko ŋandiro. Situwi uni kato wondo sara kimoyó parámi ka kimowero quro seqayote ŋundiro. ");
INSERT INTO nca_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Seqayate wondo sara meté horé ŋunde qu qeneró, ko uyaro onoŋoyó soso soweyoro uya wondo sara ŋu kimaró. ");
INSERT INTO nca_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Asa sambo simburímbo unipareyó wiri yereyote naruyó ŋuko ŋandiro. Unindo tirí-tirí ka re uro windiko raŋi uní sono qare murí-murí soso siyoyoteŋgo ŋundiro. ");
INSERT INTO nca_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tirí-tirí ŋu maŋgoriní wosi tapémo mahiní kunditero sono qare meté-meté mu se kondó parámimo kopoteŋgo. Ko sono qare piyimi mu se raŋi ute. ");
INSERT INTO nca_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Asa naru weŋa quno ŋuno ŋunde naŋge tunoqeweya. Imemoŋgo sambo simómbo umburo uni piyimi, uni roneneŋowí keweroyemo yoteŋgo ŋu yorewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Yorero raŋi kewá piyimimo uwaŋgo. Uro kewáko ŋuno tendo parámi tero metoye kindotowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ŋunde yero Yesuko iŋo-iŋo rewero uniyó ŋu ŋande osese yereró, “Yembe mande ŋaro murí sosope iŋoteŋgope ma kini?” Yiní mande topé yaŋgurí, “Iyo.” ");
INSERT INTO nca_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yi ŋande yimiraró, “Ŋunde ŋuro uni ka hutuŋo mande ŋuro iŋo-iŋoyó moré ŋundo sambo simburímbo unipareyó wiri yereyote naruyó ŋuro iŋo-iŋo reyote, ŋu uni ŋuko ŋandiro. Enendo situwi yayó moŋgo rero, asa o keta quya o komo quya siyoro yendémo umbuyote.” ");
INSERT INTO nca_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesuko tapara mande ŋu soso yesowoní kini temukoní yendé ŋu roto toŋeró. ");
INSERT INTO nca_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Toŋero eneŋo yendémo uyaro huru-huru yayemo ŋuno oro mande rondaqe yunaró. Yunoní iŋoro kondé yukuworo ŋande yaŋgurí, “Uni ŋuko iŋo-iŋo ŋu da noŋgo raró? Ene date teroqo, o wimbí moré ŋu teyote? ");
INSERT INTO nca_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nore iŋoteto, uni ŋuko o towo-towo uni ŋuro naŋuní ka, Maria ŋuko eneŋo nimí. Ko Jems, Josep, Saimon ko Jutas ŋuko eneŋo kone-topé. ");
INSERT INTO nca_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Simó kuwí ŋuko, soso noreya yoteŋgo. Ene date o ŋunde qu teyote?” ");
INSERT INTO nca_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ŋunde yero eneŋo piyimiŋoyaŋgurí. Quko Yesuko ŋande yimiraró, “Yendé soso quno ŋuno unipareto ye-ye uni ará te inoyoteŋgo. Quko eneŋo mirayómo, yayó horémoko ará kama te inoyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ŋunde yero o wimbí moré qambu ŋu yendémo ŋuno kama taró, dokoro, ene kama iŋondutuwoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ŋu naruko ŋuno Herot, uni kembé ŋundo Yesuko o teyaró ŋuro piŋa mande iŋaró. ");
INSERT INTO nca_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Iŋoro sunará simóŋo ŋande yimiraró, “Jon, sono re-re uni ŋundo uni tapu koŋgo pitu ko otoqaró. Ŋu murí ŋuro wimbu ka enewore kho teyote.” ");
INSERT INTO nca_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ŋunde yaró, dokoro komo Herot koya Herotias koya epe re-re tariyó. Quko Herotias ŋuko Herot koro payó Filip ŋuro parí. ");
INSERT INTO nca_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ŋunde ŋuroko Jonko Herot ŋande mito yaró, “Keto pare ŋu raró ŋundo hutuŋo mande wendaqeyote.” Ŋunde yeyoní Herotko Jon toworo kusiyoro rero kusi-kusi yano rotaró. ");
INSERT INTO nca_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Rotoro, uroweka khumoní, ye iŋaró, quko unipare qambu quro soraró, dokoro, ene ŋande iŋaŋgurí, Jon ŋuko ye-ye uni ka, yero iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Naru kano Herotko naru nimímbo pisiyaró ŋu rokóŋoní uni kumi kato mahero o qoyemboro kopo naŋgurí. Kopo niqo, Herotias nambuní keweroyemo ŋuno qunoraró. Tiní Herotko qenero niŋgu-niŋgu taró. ");
INSERT INTO nca_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ŋunde ŋuroko mande kusiyoro ŋande miraró, “Hamó horé yeteno, o karo no kira nereweya ŋuko, nondo ke kunowano.” ");
INSERT INTO nca_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Asa pare ŋundo nimímboro iŋo-iŋoyó howero Herot ŋande miraró, “Sono re-re uni, Jon, ŋuro kembé ŋuko rero kondómoro mahero no nuno qembe.” ");
INSERT INTO nca_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ŋunde yiní Herotko newondí surumí parámi taró. Quko uni o kopo naŋgurí ŋuro toŋeyemo mande kondé kusiyaró. Ŋunde ŋuroko enendo pare ŋuro mandí howaró. ");
INSERT INTO nca_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Howero uni ka asáŋoní kusi-kusi yano uyaro Jon puŋí toŋaró. ");
INSERT INTO nca_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Toŋoro kembé rero kondómoro mahero pare keta ŋu inaró. Ko pare ŋundo rero nimímo uyaró. ");
INSERT INTO nca_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Asa Jon koro iŋo-iŋo rewero uniyómbo mahero ukúŋo ŋu rero tapuŋaŋgurí. Tapuŋoyi kini tiní toŋero Yesu miraŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesuko piŋa mande ŋu iŋoro yendé ŋu rotoro waŋgo ka rero mira kano uni ŋuno kama yaŋgurí quno ŋuno toŋeró. Iŋo-iŋo rewero uniyómboya naŋge uyareŋgurí. Uyari unipare qambu qundo, Yesu toŋete, ye iŋoro yendé kumi rotoro khendo uyare howaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Asa waŋgo roto arero unipare qambu ŋuno yiyaró. Yiyoro sikíye te yunoro unipare se khumoye moré mu roŋgaru yiriní meté taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Yate suwo tiníqo, iŋo-iŋo rewero unindo Yesuko mahero ŋande yaŋgurí, “Nore mira uni kinimo yorato suwo tete. Ŋunde ŋuro unipare yoroti toŋi. Meté yendéwore ŋuno toŋero o kimo ti.” ");
INSERT INTO nca_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yi ŋande yimiraró, “Do karo toŋewaŋgo? Yendo o qoyemboro yunoyi.” ");
INSERT INTO nca_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Yiní mande topé ŋande yaŋgurí, “Nore ŋuya o parámi ŋano kama yote. Bret kandeka ko sono qare irisa ŋunde naŋge yotiri ŋa.” ");
INSERT INTO nca_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yi ŋande yaró, “Bret ŋuya sono qare ŋuya se nono mahi,” yaró. ");
INSERT INTO nca_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ŋunde yero unipare yimironí komó saŋano o newero quro kunditeyaŋgurí. Kunditi bret, sono qare ŋu siyoro samboko toŋetero Anutu yuŋgunaŋoro bret ŋu romboŋero iŋo-iŋo rewero uniyó se yunoní unipare se yunaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Se yunoyi o ni qahuye tinditaró. Ko o sombé kumi yora. O sombé kumi ŋu siyoro toŋgo kome puŋge 12 ŋunde puŋgeyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Uni o naŋgurí ŋuko uni 5,000 ŋundiro. Ko pare-simó kumi ŋuya naŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Asa Yesuko iŋo-iŋo rewero uniyó ŋande yimironí waŋgowore sono towo andusina Betisaita yendémo uyari unipare qambu ŋu “Ye toŋi,” ye yimiraró. ");
INSERT INTO nca_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ŋunde yiní uyari unipare yimironí toŋiqo, ene hariri tewero purímo oró. Oní kosa pusuŋiní enemata purímo yora. ");
INSERT INTO nca_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Asa iŋo-iŋo rewero unindo waŋgo wosoro kapiyamo toŋeŋgurí. Toŋiqo, matú parámi mahero sono towo huwoní tambi-tambi toqero mahero waŋgo uroní uyarewero rukusuwaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Saraŋowero teyoní Yesu sono towo saŋawore khete-khete maheró. ");
INSERT INTO nca_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Mahiní iŋo-iŋo rewero uni ŋundo qenero sasaro parámi horé tero kiwero ŋande yaŋgurí, “Ŋuko kapo ka.” Toŋiqo, matú parámi mahero sono towo huwoní tambi-tambi toqero mahero waŋgo uroní uyarewero rukusuwaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Quko Yesuko waka ta ŋande yimiraró, “Newondeye kondé yoní. Ŋako no. Sasaro ma tewero.” ");
INSERT INTO nca_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ŋunde yiní Pitako mande topé ŋande yaró, “Kepe Uni Parámi, ke nimitoka no sono saŋawore keno uyarewe.” ");
INSERT INTO nca_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yiní yaró, “Ke mahe.” Yiní Pita waŋgo rotoro sono saŋawore khete-khetero Yesuko uyaró. ");
INSERT INTO nca_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Uyaro matú wimbí qenero sasaro tero sono quroko soŋga ta uró. Ŋunde tero ŋande nekaró, “Uni Parámi, samaka nere.” ");
INSERT INTO nca_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Waka ta Yesuko kandí raŋoro Pita toworo ŋande yaró, “Ke iŋondutuke tukuni, ke dokoro newonde irisa towote?” ");
INSERT INTO nca_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Asa waŋgo saŋano oriyó. Ori matú kini taró. ");
INSERT INTO nca_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Quko uni waŋgo saŋano ŋundo Yesu potoruku te inoro ŋande yaŋgurí, “Hamó horé, keko Anutu koro Naŋuní.” ");
INSERT INTO nca_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Asa Galili Sono Towo karóŋoro tapémo, mira Genesaret ŋuno, waŋgo kusiyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Uni ŋusina ŋundo Yesu qene iŋaŋgurí, ŋunde tero mande ri yendé soso kutaqe quwore toŋeró. Ŋunde ti se khumo uni soso yorero eneno maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Yoroti mahiní ŋande kirayaŋgurí, “Meté tuwike toworo meté tewano,” yaŋgurí. Ko towaŋgurí muko meté taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ŋu naruko ŋuno naŋge Farisi uni kumimboya hutuŋo mande ŋuro iŋo-iŋo uni kumimboya Yerusalem rotoro Yesuko maheŋgurí. Mahero ŋande oseseyaŋgurí, ");
INSERT INTO nca_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Date koro keŋo iŋo-iŋo rewero unikepo usi-sinanimbo muríye yunaŋgurí ŋu wendaqeyoteŋgo? Qeno, o neweroqo, kandeye kama sonowoyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesuko mandeye topé ŋande yaró, “Date koro yeŋo muríye ŋu howeyoteŋgo, ko Anutu koro mande kondé ŋu wendaqeyoteŋgo? ");
INSERT INTO nca_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dokoro Anutuko ŋande yete, ‘Awa-náŋgeporo ará te yuno qembe,’ ko ‘Uni kato iwí-nimí yesará yereweya ŋu urika khumoní.’ ");
INSERT INTO nca_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Quko yendo ŋande yeyoteŋgo, ko uni kato ŋande yeweya, ‘Awa-náme, no samaka yerewano, quko komo o yunowano ŋuko Anutu inowano qu naŋge, yeŋo qu kini,’ yeweya tiníqo, enina, enendo meté ará kama te yunoweya. ");
INSERT INTO nca_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Asa uni ŋundo ŋundiro naŋge iwímboro ará kama te inoweya. Ŋu muríwore naŋge yendo Anutu koro mandí ri umbuní usi-siyemboro murí ŋu howeyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yeko uni maŋgoye irisa ŋu. Aisaiako ye ŋuro hamó ye-ye mande ka ŋande yaró, ");
INSERT INTO nca_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Wini ŋako maŋgoyembo neneŋo ará te nunoyoteŋgo, quko newondeye muko nono kini, kapiyamo horé yote. ");
INSERT INTO nca_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Enendo unindoro hutuŋo mandeye naŋge rondaqe yunoro potoruku kota qu re nunoyoteŋgo.’” ");
INSERT INTO nca_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Asa Yesuko unipare qambu ŋu neko yerero ŋande yimiraró, “Iŋika tondaŋiní. ");
INSERT INTO nca_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Oka uni ka maŋgówore quroyómo uyote, ŋundo uni ŋu riní Anutu toŋímo pusú kama teyote. Kini, oka maŋgó moŋgo areyote, ŋundo uni ŋu riní Anutu toŋímo pusú teyote.” ");
INSERT INTO nca_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yiníqo, iŋo-iŋo rewero unindo mahero ŋande miraŋgurí, “Farisi unindo keŋo mandeke iŋoro newonde piyimi teteŋgo. Ŋuro iŋotepe?” ");
INSERT INTO nca_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yi ŋande yaró, “Awane samboko yote ŋundo o soso eneŋombo khono kama rimiró ŋu soso kumoro rotoweya. ");
INSERT INTO nca_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ye uni ŋunde qu yorotoyi qembe. Enendo khe witú yereyoteŋgo, quko eneko toŋeye kiré mu naŋge. Ko toŋí kiré kato toŋí kiré meyowo ka khe witúŋoweya, ŋuko irisa-irisa rokaráŋoro meréko uwari.” ");
INSERT INTO nca_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ko Pitako Yesu ŋande miraró, “Keto tapara mande yete ŋuro murí nimitoka iŋowato.” ");
INSERT INTO nca_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yiní ŋande yaró, “Do ka? Ye ŋuya kama iŋoyi tondaŋeyote, peka? ");
INSERT INTO nca_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","O soso maŋgonani qurowore uyote, ŋuko qahímo naŋge uro, yate qosimbino uyote. Ŋuro iŋoteŋgope ma kini? ");
INSERT INTO nca_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Quko o piyimi maŋgonani moŋgo areyote, ŋuko newondenani moŋgo areyote. Ko o ŋunde qundo uni riní Anutu toŋímo pusú teyote. ");
INSERT INTO nca_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Dokoro newondenani moŋgo o piyimi ka areyote ŋuko ŋandiro: iŋo-iŋo piyimi, uni yurowero murí, se simbururu tewero murí, momo tewero murí, mande khono kota mande yewero murí, ko yesará yerewero murí. ");
INSERT INTO nca_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","O soso ŋundo uni riní Anutu toŋímo pusú teyote. Quko uni kato kandí kama sonoworo o neweya, ŋundo uni ŋu riní pusú kama teyote.” ");
INSERT INTO nca_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Asa Yesu roto toŋero yendé irisa Tair koya Saiton sumeyoro ŋuno uyaró. ");
INSERT INTO nca_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Uyareyate Kenan pare kato yendé ka rotoro mahero ŋande nekaró, “Uni Parámi, Dewit koro Naŋuní, sikíne te nuno. Yuqa piyimi kato nambone roworemoyote.” ");
INSERT INTO nca_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ŋunde yaró, quko Yesuko mande topé kama yaró. Ko iŋo-iŋo rewero uniyó taŋgímo mahero ŋande miraŋgurí, “Enendo mande parámi yero nore nohoweyote. Mitoka roto toŋiní.” ");
INSERT INTO nca_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yiqo, Yesuko ŋande yaró, “Israel koro wini ŋuko sipsip ka khe rotaŋgurí qu qembe. Eneŋo naŋge samaka yerewero kho teteno.” ");
INSERT INTO nca_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pare ŋundo mahero potoruku tero ŋande yaró, “Uni Parámi, samaka nere.” ");
INSERT INTO nca_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yiní mande topé ŋande yaró, “Simó koro o newero qu re isa yunowero ŋuko meté kini.” ");
INSERT INTO nca_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Yiní yaró, “Iyo, quko isa ŋuyako simburí o romboŋero rotoní umbuní neweya.” ");
INSERT INTO nca_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesuko ŋande yaró, “Pare, keto iŋondutu parámi tete. Keto ŋuro kira nerete ŋuko tunoqeweya.” Asa ko ŋu naruko ŋuno naŋge nambuní meté taró. ");
INSERT INTO nca_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Asa Yesuko yendé ŋu rotoro, yate-yate Galili Sono Towo sumeyoro uyaró. Uyareyate mira purímo oro kunditaró. ");
INSERT INTO nca_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ko unipare qambu parámi eneno mahero kheye piyimi mu ko toŋeye pokamowí mu ko wimbuye wakawí mu ko maŋgoye kusiyowí mu ko se khumo uni kumi parámi ŋuya yore maheŋgurí. Yore mahero Yesu khí sumeyo yoroti yoriní meté taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Maŋgoye kusiyowí mu mande yaŋgurí, ko wimbuye iri-erá mu meté tero khete-khete toŋeŋgurí, ko toŋeye kiré qu meté toŋetaŋgurí. Ŋunde tero unipare qambu qundo iŋondata parámi tero Israel koro Anutu qu seré te inaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yate-yate Yesuko iŋo-iŋo rewero uniyó neko yiriní eneno mahi ŋande yimiraró, “No unipare qambu ŋaro sikíye teteno. Enendo kosa naru kapusa noya ŋano yotoro o qoyemboro khumoyoteŋgo. Asa ko kina yorotowe toŋero kheko wimbuye kini tiní umbu raŋowaŋgo ŋu meté kini.” ");
INSERT INTO nca_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Iŋo-iŋo rewero uniyómbo ŋande miraŋgurí, “Mira ŋasina ŋako uni kini. Nore bret da noŋgo siyoro unipare qambu ŋa wutu yerewato?” ");
INSERT INTO nca_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ko Yesuko osese yereró, “Yendo bret date towoyoteŋgo?” Yiní ŋande yaŋgurí, “Bret kande saŋiyoro irisa ko sono qare tomó ta-ta kumi naŋge.” ");
INSERT INTO nca_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Asa Yesuko unipare yimironí nokono kunditaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kunditi bret kande saŋiyoro irisa ŋu siyoro ko sono qare tomó ta-ta ŋu siyaró. Siyoro Anutu yuŋgunaŋoro romboŋero iŋo-iŋo rewero uniyó se yunoní unipare se yunaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Unipare soso ni qahuye tinditaró. O sombé-sombé yoní huruworo toŋgo kome puŋge parámi kande saŋiyoro irisa ŋunde puŋgeyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Uni o naŋgurí ŋuko uni 4,000 ŋundiro. Ko pare-simó kumi ŋuya naŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesuko unipare yoriní toŋi waŋgo tomó ta quno ŋuno oro Makadansina uyaró. ");
INSERT INTO nca_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Asa Farisi unindoya Sadyusi unindoya towoŋowero Yesuko mahero ŋande miraŋgurí, “Sambo koro rokó ka teka nore qene iŋato, keko Anutu koro kho qu teyote.” ");
INSERT INTO nca_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Quko mandeye topé ŋande yaró, “Suwoya teyoní sambo mando tiní ye ŋande yeyoteŋgo, ‘Kuyepo mira meté tewero teweya,’ yeyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ko ita saraŋoní koporé iriyó mahiní sambo iriqiní ŋande yeyoteŋgo, ‘Itakako mira piyimi, matú piyimi tewero tete,’ yeyoteŋgo. Yendo sambo koro rokó ŋu qenero do ka mirako tunoqeweya ŋu iŋoyi tondaŋeyote. Asa do karo naru ŋaro rokó ŋu qeni rondaŋewero mepémo kini? ");
INSERT INTO nca_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Itaka unipare ŋano quko unipare piyimi ko newondeye hamó rero Anutu kama inoyoteŋgo. Ŋundo rokó ŋuro kira nereyoteŋgo, quko rokó ŋunde qu kama witú yerewano. Kini, Jona koro rokó ŋu naŋge qenewaŋgo.” Ŋunde yero yorotoro toŋeró. ");
INSERT INTO nca_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Uyaro Yesu koya iŋo-iŋo rewero uniyómboya sono towo andusina uyareŋgurí. Quko uniyómbo bret koro kape tero kama siyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Asa Yesuko ŋande yimiraró, “Ye Farisi, Sadyusi ŋuro yisiyemboro kawaware ti.” ");
INSERT INTO nca_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ŋunde yiníqo, ŋande keweroyemo epe mito-mito taŋgurí, “Ŋunde yete, dokoro norendo bret koro kape tero kama siyato.” ");
INSERT INTO nca_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesuko newondeye qene iŋoro ŋande yimiraró, “Ye iŋondutuye tukuni! Do karo bret koro kape taŋgo ŋuro epe mito-mito teyoteŋgo? ");
INSERT INTO nca_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Yembe watí kama iŋoyi tondaŋeyote? Komo, uni 5,000 bret kandeka naŋge niqo, yendo sombé rotaŋgurí qambu ŋu toŋgo kome puŋge datiro puŋgeyaŋgurí? Ŋuro kape teyoteŋgo, peka? ");
INSERT INTO nca_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ko imemoŋgo uni 4,000 bret kande saŋiyoro irisa naŋge niqo, yendo sombé rotaŋgurí qambu ŋu toŋgo komeko puŋgeyaŋgurí. Ŋu ŋuya kape teyoteŋgo, peka? ");
INSERT INTO nca_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nondo bret ŋuro kama yeteno. Do karo yendo kama iŋoyi tondaŋete? Ŋande yeteno, Farisi, Sadyusi ŋuro yisiyemboro kawaware ti.” ");
INSERT INTO nca_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ŋunde yiníqo, ŋande iŋaŋgurí, enendo bret koro yis ŋuro kama yaró, kini, Farisi, Sadyusi koro iŋo-iŋo rondaqe yunoyaŋgurí ŋuro yaró. ");
INSERT INTO nca_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Asa Yesuko Sisaria Filipai yendé sumeyoro ŋuno uyaró. Uyaro iŋo-iŋo rewero uniyó ŋande osese yereró, “Unipareto Unindoro Naŋuní ŋu dani ka yero yeyoteŋgo?” ");
INSERT INTO nca_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Yiní ŋande yaŋgurí, “Kumimboko ŋande yeyoteŋgo, ŋuko sono re-re uni, Jon ŋu. Kumimboko, Elaija, yeyoteŋgo. Ko kumimboko, Jeremaiape ma Anutu koro ye-ye uni meyowo ka, yeyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yiqo, ŋande osese yereró, “Yeŋomboko nenemboro dani yeyoteŋgo?” ");
INSERT INTO nca_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon-Pitako mande topé ŋande yaró, “Keko Kristo ŋu, Anutu Yoto-yotoyó Moré ŋuro Naŋuní.” ");
INSERT INTO nca_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ŋunde yiní Yesuko mande topé ŋande yaró, “Saimon Bar-Jona, ke puriŋo ka rete. Uni ka nokono ŋano qundo iŋo-iŋo ŋu kama kuna. Kini. Awane samboko yote ŋundo iŋo-iŋo ŋu ke kuna. ");
INSERT INTO nca_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Asa ko nondo ke ŋande kimiroteno. Owéŋge Pita, ko nondo uniparene huru yereyoteno ŋu wondo ŋunde qembe saŋano rewe kondé kaŋewaŋgo. Uni khumowí ŋuro yendéye ŋundo uniparene ŋu kama yoriní umbuwaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nondoko sambo simburímbo unipareyó wiri yereyote naruyómo ŋuno owé parámi ke kunowano. Keto o kumi nokono ŋano kusiyoweya tiníqo, Anutuko samboko o ŋu kusiyoweya, ko o kumi ŋano rotoweya tiníqo, Anutuko samboko o ŋu rotoweya.” ");
INSERT INTO nca_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ŋunde yero Yesuko iŋo-iŋo rewero uniyó kondé soré yerero ŋande yaró, “Noko Kristo ye ma yewero,” yaró. ");
INSERT INTO nca_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Asa ŋu naruko ŋu noŋgo Yesuko kimani tero iŋo-iŋo rewero uniyó ŋande yimiraró, ko enendo Yerusalem oní Juda koro uni kembé-kembéyemboya o qa-qa unindoro tapá unindoya hutuŋo mande ŋuro iŋo-iŋo unindoya soso ŋundo kowe surumí parámi inoro uri khumoweya. Ko naru kapusayómo ŋuno pitu ko otoqoweya. ");
INSERT INTO nca_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ŋunde yiní Pitako Yesu rero tapémo uyaro kimani tero ŋande qene yaró, “Uni Parámi, kini horé. O ŋuko keno kama tunoqeweya.” ");
INSERT INTO nca_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesuko rohoréŋoro Pita ŋande miraró, “Monimbu, ke tupunesina uyare,” yaró. “Keto khene kusiyowero yete. Keto Anutu iŋo-iŋoyó kama howete. Kini. Unindoro iŋo-iŋoye naŋge howete.” ");
INSERT INTO nca_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ko Yesuko iŋo-iŋo rewero uniyó ŋande yimiraró, “Uni kato no nohoweweroqo, ene eneŋo re umburoqota, tipiririyó koroworo no nohowiní. ");
INSERT INTO nca_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Dokoro, dani kato eneŋo yoto-yotoyó kondé towowero ye iŋote qu, yoto-yotoyó ŋu piyo teweya. Quko dani kato no iŋo nunoro yoto-yotoyó rotoweya tiníqo, ene yoto-yotoyó ŋu reweya. ");
INSERT INTO nca_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Qeni, ko uni ka noko koro o soso ŋu reweya, quko ene piyo tero kini teweya, asa o soso ŋundo date samakaŋoweya? Ko yoto-yotoyó date kimoweya? ");
INSERT INTO nca_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Unindoro Naŋuní ŋuko iwímboro sine parámimo ŋuno yoweya, ene sambo simómboya mahewaŋgo. Ŋu naruko ŋunoko unipare soso o murí teyoteŋgo ŋu kanaramimo kimoye kanata-kanata yunoweya. ");
INSERT INTO nca_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","No ye hamó yimiroteno, uni kumi ŋano kaŋeteŋgo qundo kama khumoyuri Unindoro Naŋuní ŋundo wiri yerete uni ŋunde te mahiní qenewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Asa naru kande saŋiyoro kanata ŋunde kini tiní Yesuko Pita, Jems koya koneyó Jon koya yorero mira purí ka koreko horé ŋuno enemata oŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Asa toŋeyemo ŋuno Yesu kiraró enesó ka taró. Ŋunde tero umu-kembé muko kosa hiyó qembe hiyóqaró. Ko kowe punu-punuyó ŋuya hiyóqaró. ");
INSERT INTO nca_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ko Moses koya Elaija koya ŋuno tunoqiri yiyoyi Yesu koya mande taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pitako ŋu qenero Yesu ŋande miraró, “Uni Parámi, nore ŋano yoteto, ŋu meté horé. Asa ko keto ŋuro iŋote tiníqo, asa nondo yamaru kapusa ŋano rewano. Kako keŋo, ka Moses koro, ka Elaija koro.” ");
INSERT INTO nca_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ene yeyoní naŋge koporé ka hiyó parámi tero poka yereró. Ko maŋgo ka koporé quro koŋgo ŋande yaró, “Ŋako neneŋo naŋone, eneŋo surumí iŋoyoteno. Ŋuro metéŋoyoteno. Maŋgó howeyuri qembe.” ");
INSERT INTO nca_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ŋunde yiní iŋo-iŋo rewero uni ŋu iŋoro sasaro tero umu-kembaye re nokono raŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ri Yesuko mahero yondoworo yimiraró, “Ye otoqi. Ma sorewero.” ");
INSERT INTO nca_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Yiní toŋetero uni meyowo ŋu kama yiyaŋgurí. Kini, Yesu ŋu naŋge qeneŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Asa mira purí rotoro umbuyate Yesuko kondé ŋande yimiraró, “Ye o toŋeyembo qeneteŋgo ŋaro unipare ma yimirowero. Yate-yate Unindoro Naŋuní uni tapu koŋgo otoqoníqota meté yimiroyi qembe.” ");
INSERT INTO nca_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yiníqo, iŋo-iŋo rewero unindo ŋande oseseyaŋgurí, “Ŋunde ŋuroko do murí karo hutuŋo mande ŋuro iŋo-iŋo uni ŋundo ŋande yeyoteŋgo, Elaija ŋuko korete maheweya?” ");
INSERT INTO nca_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yi mande topé ŋande yaró, “Mande ŋuko hamó. Koretero Elaija mahero o soso piyo taró mu roŋgaruwote. ");
INSERT INTO nca_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Quko nondo ye ŋande yimirowe, Elaija pitu ko mahiní unindo ŋu qene kama iŋaŋgurí. Kini. Eneŋo iŋo-iŋoye howero murí piyimi te inaŋgurí. Uni ŋundo ŋundiro naŋge Unindoro Naŋuní ŋu o piyimi te inoyowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yesuko ŋunde yiníqo, iŋo-iŋo rewero uniyómbo ŋande iŋoyi tondaŋaró, asa sono re-re uni, Jon, ŋuro yaró. ");
INSERT INTO nca_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Asa purí moŋgo umbuyiqo, uni kato Yesu taŋgímo mahero potoruku tero ");
INSERT INTO nca_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ŋande yaró, “Uni Parámi, keto naŋone sikí te ino. Ene se khumo tero khe kandí yukuwoní kowe surumí parámi teyote. Naru parámi nombono ŋuno rokaráŋo uyote, ko sonono ŋuno ŋuya uyote. ");
INSERT INTO nca_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ŋunde tiní nondo rero iŋo-iŋo rewero unikeno maheno, quko enendo ri meté tewero mepémo kini.” ");
INSERT INTO nca_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ko Yesuko mande topé ŋande yaró, “Ye unipare itaka nokono yoteŋgo qundo iŋondutu kama reyoteŋgo! Naru date yeya yowano? Naru date quhuríye korowoyowano? Simó ŋu nono re mahi.” ");
INSERT INTO nca_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Re mahi Yesuko yuqa piyimi ŋu qene yiní yuqa piyimimbo simó ŋu roto toŋeró. Ŋu naruko ŋuno naŋge se khumoyó kini taró. ");
INSERT INTO nca_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Imemoŋgo iŋo-iŋo rewero uni ŋundo tapémo mahero Yesu ŋande oseseyaŋgurí, “Date koro norendo yuqa piyimi ŋu howewero mepémo kini?” ");
INSERT INTO nca_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ko enendo ŋande yimiraró, “Dokoro iŋondutuye muko tomó ta naŋge. No mande hamó ye yimirowe, ko ye iŋondutuye muko tomó ta naŋge, asa mastet taŋgurí ŋunde qembe tiníqo, asa yendo mira purí ŋa, ‘Ke otoqoya anduno uyare,’ yiqo, uyareweya. Ko yendo kho soso naŋge temukowero wimbí moré tewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(-) ");
INSERT INTO nca_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Asa Yesu koya iŋo-iŋo rewero uniyómboya Galili mirako huruwaŋgurí. Huruwoyi Yesuko ŋande yimiraró, “Kumimbo Unindoro Naŋuní re saŋgirí uni kandeyemo rotowe teteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Enendo uroyi khumoweya, quko naru kapusayómo pitu ko otoqoweya.” Iŋo-iŋo rewero uni ŋundo mande ŋu iŋoro newonde quhurí parámi taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Asa Kaperneam yendémo mahiqo, Ya Surumímboro takis re-re unindo Pitako mahero ŋande oseseyaŋgurí, “Asa yeŋo rondaqe-rondaqe uniye ŋundope Ya Surumímboro takis ŋu inoyotepe ma kini?” ");
INSERT INTO nca_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ko Pitako ŋande yaró, “Iyo, inoyote.” Yero ya quroko oro mande ka kama yeyoní naŋge, Yesuko ŋande oseseyaró, “Saimon, ke date iŋote? Wiri yerete uni nokono ŋano yoteŋgo qundo takis kate-kate ŋuko da noŋgo reyoteŋgo? Eneŋo naŋo-simóye moŋgo reyoteŋgope ma uni meyowo moŋgo reyoteŋgo?” ");
INSERT INTO nca_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Yiní ŋande yaró, “Uni meyowo moŋgo.” Yiní Yesuko ŋande miraró, “Asa ko eneŋo naŋo-simóyembo takis kama yunoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ŋunde quko norendo tewaro, newonde piyimi tewaŋgo ŋuro. Asa ke sono towoko toŋeya utó raŋo. Sono qare korete wosoweya ŋuko, ŋu rero maŋgó koso qembe, mone ka sono qare quroyómo ŋuno yoní qene qembe. Mone ŋu rero uni ŋu yuno qembe, ŋundoko noya keya takisinari ŋu rokóŋoweya.” ");
INSERT INTO nca_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ŋu naruko ŋuno iŋo-iŋo rewero unindo Yesuko mahero ŋandiro oseseyaŋgurí, “Dani katoko sambo simburímbo unipareyó wiri yereyote naruyómo ŋuno owé parámi reweya?” ");
INSERT INTO nca_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Asa Yesuko simó ta ka nekoní mahiní re keweroyemo rotoní kaŋaró. ");
INSERT INTO nca_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Enendo ŋande yimiraró, “Nondo ye hamó yimiroteno, ko yendo simó ta ŋande qembe kama tunoqewaŋgo tiníqo, yeko sambo simburímbo unipareyó wiri yereyote naruyó ŋuro quroko kama owaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Uni eneŋomboro iŋoní umbuní simó tomó ta ŋande qembe tunoqeweya, uni ŋundo sambo simburímbo unipareyó wiri yereyote naruyómo ŋuno owé parámi horé reweya. ");
INSERT INTO nca_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Uni kato neneŋo iŋoro simó ta ka ŋande quya topo teweya ŋuko noya topo teweya. ");
INSERT INTO nca_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Quko enendo simó tomó ta qu ka iŋondutu nereyote ŋu riní o piyimi teweya tiníqo, topé piyimi horé reweya. Meté koretero unindo wondo parámi ka eneŋo puŋímo kusiyoro re windi quroko raŋi khumoroqota o piyimi ŋunde qu kama teweya. ");
INSERT INTO nca_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Ye nokono ŋano uni qu, ininiyaqe, quhurí piyimi korowowaŋgo. Yendo uni yowosoyi o piyimi teyoteŋgo. Hamó, yeŋo muríye piyimi ŋunde qu tunoqeweya. Quko ye dando o piyimi ŋu tewaŋgo, ininiyaqe, quhurí piyimi korowowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ke kandekepo, kheŋgepo kowosoní o piyimi teroqo, wesaŋe raŋi uweya. Ŋunde kini tiníqo, asa kandeke irisa-irisa ŋunde teweyape, ma kheŋge irisa-irisa ŋunde teweya, quko imemoŋgo te suki-suki qayote quno ŋuno uweya. Quko keto kandeke kanata na, kheŋge kanata na yoweya, keto meté yoto-yoto suki-suki ŋuno oweya. ");
INSERT INTO nca_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ko toŋeŋgepo kowosoní o piyimi teroqo, kumo raŋo qembe. Ŋunde kini tiníqo, asa toŋeŋge irisa-irisa ŋunde teweya, quko imemoŋgo kewá piyimimo ŋuno uweya. Quko toŋeŋge kanata na yoweya, keto meté yoto-yoto suki-suki ŋuno oweya. ");
INSERT INTO nca_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ye meté iŋoyi. Simó tomó ta-ta ŋande quro ma yesará yerewero. Dokoro no hamó yimiroteno, sambo simó kumimbo sopo yerero naru rokóŋoro awane samboko yote ŋuro toŋímo kaŋeyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(-) ");
INSERT INTO nca_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ye date iŋoteŋgo? Ko uni kato sipsip 100 ŋunde sopo yereyote, ko sipsip kanata na toŋeweya tiníqo, enendo sipsip 99 ŋu yorotoní purímo yuriqo, toŋero sipsip toŋeró ŋu seqaweya, hamómbe? ");
INSERT INTO nca_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","No ye hamó yimiroteno, ko ene sipsip ŋu qeneroqo, asa niŋgu-niŋgu parámi horé teweya. Sipsip 99 kama toŋeŋgurí ŋuro metéŋoyote, quko kanata toŋeró ŋu qeneró ŋuro niŋgu-niŋgu parámi teweya. ");
INSERT INTO nca_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ŋunde naŋge Awane samboko yote ŋundo simó na-na ŋande quro kanata ka kama piyo teweya, yero iŋoyote. ");
INSERT INTO nca_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ko ke topokepo o piyimi te kunoweya tiníqo, yarimata naŋge roŋgaruwori qembe. Ŋunde ti mandeke iŋoníqo, topoke ri meté yoweya. ");
INSERT INTO nca_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Quko enendo mandeke kama iŋoníqo, uni kanata, irisa ŋuya yorero topokepoya mande kaŋuya yi qembe. Dokoro uni irisa, kapusa qundo mande ŋu ri kondéreweya. ");
INSERT INTO nca_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ko enendo yeŋo mandeye ŋu ŋuya kama iŋoníqo, iŋondutu koro huru-huruko unipare soso yi qembe. Ko enendo eneŋo mandeye kama iŋoníqo, asa ke uni ŋu qenero, kape uni qembe, takis re-re uni qembe naŋge, ye iŋo qembe. ");
INSERT INTO nca_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“No ye hamó yimiroteno, o kumi nokono kusiyowaŋgo tiníqo, Anutuko o ŋu samboko kusiyoweya. Ko o kumi nokono rotowaŋgo tiníqo, Anutuko o ŋu samboko rotoweya. ");
INSERT INTO nca_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ko no ye hamó yimiroteno, ko keweroye moŋgo irisa qundo newonde kanata tero Anutu kirayoriqo, asa awane samboko yote ŋundo te yunoweya. ");
INSERT INTO nca_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ko uni irisa, kapusa qundo neneŋo owénemo mahe kopowaŋgo, nondo keweroyemo yowano.” ");
INSERT INTO nca_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ŋu naruko ŋuno Pitako Yesu ŋande oseseyaró, “Uni Parámi, toponembo naru kumimo nono o piyimi te nunoyote, ŋu yate-yate naru datiro quhuríŋo ŋu re rotowano? Naru kande saŋiyoro irisa ŋunde?” ");
INSERT INTO nca_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yiní Yesuko ŋande miraró, “Nondo ŋande ke kimiroteno, naru kande saŋiyoro irisa kini, naru 77 ŋunde se roto qembe. ");
INSERT INTO nca_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Iŋoyi, sambo simburímbo unipareyó wiri yereyote naruyó ŋuko ŋandiro: nokono wiri yerete uni kato sunará simóŋomboya utatáye roŋgaruwowero ye iŋaró. ");
INSERT INTO nca_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ene utatáye ŋu roŋgaruwowero kimani tiní uni ka rero eneno maheŋgurí. Uni ŋuro utatáyó muko mone 10 miliyon ŋundiro. ");
INSERT INTO nca_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Quko enendo utatáyómboro topé ŋu mepémo tewero mepémo kini. Asa ko uni parámi ŋundo mande ka yero uni ŋuya parí-simómboya onoŋoyó soso siyoní wondo uni kato kimo yiriní wondo unindoro kho simó tunoqewaŋgo. Ŋu muríwore wondo siyoro utatá topé teweya. ");
INSERT INTO nca_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ŋunde ŋuroko sunará simó ŋundo mande ŋu iŋoro potoruku tero ŋande miraró, ‘Sikíne teya rotoka. Imemoŋgo nondo utatá tanowó ŋu soso ta te kunowano.’ ");
INSERT INTO nca_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Yiní uni parámiyómbo sunará simóŋo sikí tero utatá ŋu re rotoní toŋeró. ");
INSERT INTO nca_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Asa sunará simó ŋuno qundo mirako uro kho kopo topé ka qeneró. Topémbo eneya utatáyó wondo musiyó 100 naŋge taró. Ŋunde qenero kondé horé puŋímo toworo ŋande miraró, ‘Keto utatá noya taró ŋuno qu soso ta topé te nuno qembe.’ ");
INSERT INTO nca_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ŋunde ŋuroko kho kopo topé ŋunde mande ŋu iŋoro potoruku tero ŋande miraró, ‘Sikíne teya rotoka. Imemoŋgo nondo utatá tanowó ŋu soso ta te kunowano.’ ");
INSERT INTO nca_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Quko sunará simó ŋundo ŋuro piyimiŋaró. Kini, enendo kho kopo topé ŋu rero topé tewero quro kusi-kusi yano rotaró. ");
INSERT INTO nca_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ŋunde ŋuroko kho kopo meyowombo ŋu qenero newonde quhurí parámi tero toŋero uni parámiye kho uni ŋundo o soso taró ŋuro miraŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Asa uni parámi ŋundo sunará simó ŋu nekoní mahiní ŋande miraró, ‘Keko sunará simó piyimi. Keto kondé kira niriqo, utatáŋge soso se rotano. ");
INSERT INTO nca_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nondo sikíŋge te kunano. Asa ke date koro kho kopo topoke ŋuro sikíŋo kama te ina?’ ");
INSERT INTO nca_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ŋunde yero uni parámiyómbo newonde tiwi tero utatáyó soso ŋuro topé tewero quro kusi-kusi ya koro sopo-sopo kandeyemo riní kowe surumí inaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Asa ko yendo topoyembo o piyimi te yunoyote ŋu quhuríŋo hamó kama re rotowaŋgo tiníqo, awane samboko yote ŋundo ŋunde naŋge teweya.” ");
INSERT INTO nca_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesuko mande ŋu soso yiní kini tiní Galili rotoro Jotan Sono andusina Judia mirako uyaró. ");
INSERT INTO nca_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ko unipare qambu howi ŋusina ŋuno se khumo uni yoriní meté taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Asa Farisi uni kumimbo Yesuko mahero towoŋowero ŋande oseseyaŋgurí, “Ko uni kato murí kate-kate soso koro parí howeweya tiníqo, hutuŋo mande wendaqeweyape ma kini?” ");
INSERT INTO nca_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yi mande topé ŋande yaró, “Yeko Anutu koro mande qu sokomeko yote ŋu kama weyoyoteŋgo, peka? Komo suki Anutuko o soso towaró quno enendo ‘urumuni kaya, pare kaya yondowaró.’ ");
INSERT INTO nca_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Yondoworo ŋande yaró, ‘Ŋunde ŋuroko uni iwí-nimí yorotoro parímboya womowari, ko irisa ŋundo kowe kanata tewari.’ ");
INSERT INTO nca_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Asa Anutuko mande ŋunde yiní kowe irisa kama yorari. Kini. Irisa ŋu kowe kanata tariyó. Ŋunde ŋuroko Anutuko o irisa siyoro kopo yiriníqo, ye ŋu ma usowowero.” ");
INSERT INTO nca_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Yiní ŋande yaŋgurí, “Asa ko date koro Mosesko hutuŋo mande ka yiní unindo sokome ka epe re-re toŋowero qu nakayáŋoro pare inoro howi toŋeweya?” ");
INSERT INTO nca_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yi ŋande yimiraró, “Yendo newondeye kusiyoyoteŋgo, ŋunde ŋuroko Mosesko yiyo rotoní pare yohowewaŋgo. Quko komo ŋu murí ŋu kama yora. ");
INSERT INTO nca_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nondo ŋande yimiroteno, ko uni kato parí se simbururu kama teyoní howero pare meyowo rete ŋuko se simbururu tete.” ");
INSERT INTO nca_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ŋunde yiní iŋo-iŋo rewero uniyómbo Yesu ŋande miraŋgurí, “Ko uni kato murí ŋunde ŋu howero parímboya yowari, asa meté uni ŋundo kama kame teweya, kina yoweya.” ");
INSERT INTO nca_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ŋunde yi ŋande yimiraró, “Uni soso mande ŋu rewero mepémo kini. Anutuko wimbu kondé uni kumi naŋge yunaró. ");
INSERT INTO nca_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Iŋoyi. Uni kate-kate qundo pare kaya yowero mepémo kini. Kumimboko námbo pisi yereró quno ŋuno koweye piyo taró. Ko kumimboko unindo yondoŋoyi koweye piyo taró. Ko kumimboko sambo simburímbo unipareyó wiri yereyote naruyó ŋuro iŋoro koweye rukikiŋoro pare kama rewaŋgo. Asa dani kato mande ŋa iŋoweroqo, meté iŋoyi.” ");
INSERT INTO nca_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ŋu naruko ŋuno unipareto simó ta-ta yorero, Yesuko kandí rero kembayemo rero hariri yiriní, yero iŋoro yore maheŋgurí. Quko iŋo-iŋo rewero uniyómbo unipare ŋu yiyo yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ko Yesuko ŋande yaró, “Ye simó ta-ta tomó ta-ta ŋu yorotika nono mahi, ma soré yerewero. Dokoro sambo simburímbo unipareyó wiri yereyote naruyó ŋuko simó ŋunde quro na.” ");
INSERT INTO nca_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ko kandí kembayemo riní kini tiní yoroto toŋeró. ");
INSERT INTO nca_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Asa uni kato Yesuko mahero ŋande miraró, “Rondaqe-rondaqe, no do murí meté ka tero yoto-yoto suki-suki ŋu rewano?” ");
INSERT INTO nca_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yiní ŋande miraró, “Ke do karo no murí meté ŋuro osese nerete? Uni kanata naŋgeko meté. Ko ke yoto-yoto suki-suki ŋuno oweya, ye iŋoroqo, asa Anutu koro mande kondé ŋu meté ta howe qembe.” ");
INSERT INTO nca_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yiní ŋande oseseyaró, “Keto hutuŋo mande date quro yete?” Ko Yesuko yaró, “Uni ma yuri khumowero, se simbururu ma tewero, momo ma tewero, mande khono ŋuno kota mande ma yewero, ");
INSERT INTO nca_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","awa-náŋge ará te yuno qembe. Ko keŋomboro iŋoyote ŋunde naŋge topokeporo ŋunde naŋge iŋo qembe.” ");
INSERT INTO nca_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ko uni keta ŋundo Yesu ŋande miraró, “Nondo hutuŋo mande ŋu soso howeyano. Do o meyowo ka tewano?” ");
INSERT INTO nca_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ko Yesuko ŋande miraró, “Ko ke uni meté horé teweroqo, asa keŋo situwi soso soweyoya mone ŋu rondaŋe uni oye moré kini ŋu yuno. Ke ŋunde teroqo, o meté samboko reweya. Asa ŋunde teya ke mahe nohowe.” ");
INSERT INTO nca_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Uni keta ŋundo mande ŋu iŋoro newonde quhurí tiní roto toŋeró, dokoro, ene onoŋoyó qambu taró. ");
INSERT INTO nca_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ko Yesuko iŋo-iŋo rewero uniyó ŋande yimiraró, “Nondo ye hamó yimiroteno, onoŋo unipare kato sambo simburímbo unipareyó wiri yereyote naruyómo ŋuno owero ŋuko taŋo kini, quhurí. ");
INSERT INTO nca_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ko ŋande ye yimirowe, kamelko tuwi tiŋiyowero tisi wituyó qurowore uwero rukusuwoweya. Ko ŋunde naŋge onoŋo uni ŋundo Anutuko unipareyó wiri yereyote naruyómo ŋuno owero hamó rukusuwowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Iŋo-iŋo rewero unindo mande ŋu iŋoro kondé yukuworo ŋande yaŋgurí, “Asa ko danimboko rambaruru takawaŋgo?” ");
INSERT INTO nca_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesuko kondé yiyoro ŋande yaró, “Unindoko tewero mepémo kini. Quko Anutuko o soso meté teweya.” ");
INSERT INTO nca_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Asa Pitako mande topé ŋande yaró, “Qeno, norendo onani soso rotoro ke kohowatowó. Ŋunde ŋuro nore do ka rewato?” ");
INSERT INTO nca_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ko Yesuko ŋande yimiraró, “Nondo ye hamó yimiroteno, o soso keta tunoqeweya quno ŋuno Unindoro Naŋuní ŋundo owé parámi rero eneŋo yakutíŋo meté horé quno ŋuno kunditeweya. Ŋu naruko ŋunoqota ye dani kato no nohoweyoteŋgo, ye ŋuya wiri yerete unindoro yakutíye 12 ŋuno kunditero Israel koro wini 12 ŋu ronda yerewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ko dani kato no owéne iŋoro yayó, kumuní, kuwí, iwí, nimí, simó, khoyó ŋu rotoweya, eneko 100 kaŋuya rewaŋgo, ko yoto-yoto suki-suki ŋu rewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Quko uni qambu itaka korete yoteŋgo, ŋuko tukú tewaŋgo. Ko uni qambu itaka weŋa yoteŋgo, ŋuko koretewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Qeni, sambo simburímbo unipareyó wiri yereyote naruyó ŋuko ya simburí ŋunde qembe. Ita saraŋoní ya rotoro uni kumi yoriní wain khoyómo kho tiqo, kimo yereweya. ");
INSERT INTO nca_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Simburímboya kho unindoya kimoye ŋuro newonde kanata tero kosa kanata quro kimoye ŋuko wondo musiyó kanata siyowaŋgo. Newonde kanata teroqo, asá yiriní wain khono uyaro kho taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Asa ita saraŋoní 9 kilok ŋunde quno simburímbo ya rotoro uni kumi yendémo kinaŋge kaŋeyaŋgurí ŋu ");
INSERT INTO nca_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","yiyoro ŋande yimiraró, ‘Ye ŋuya uya wain khono kho tiqo, nondo khoyemboro topé meté tewano.’ ");
INSERT INTO nca_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Yiní iŋoro toŋeŋgurí. Ŋundiro naŋge uni parámimbo kosa keweroko ko suwoya 3 kilok ŋunde quno ya rotoro o korete taró ŋu naŋge taró. ");
INSERT INTO nca_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Asa suwoya 5 kilok ŋunde quno ya rotoní uni kumi kinaŋge kaŋeyuri yiyoro ŋande osese yereró, ‘Ye date koro ŋande ita saraŋoní kinaŋge kaŋaŋgo qu kaŋeyuri suwoya tete?’ ");
INSERT INTO nca_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Yiní mande topé ŋande yaŋgurí, ‘Uni kato nore kho kama yunote.’ “Yiqo, ŋande yimiraró, ‘Ye ŋuya uyare neneŋo wain khonemo kho ti.’ ");
INSERT INTO nca_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Asa suwo tewero tiníqo, kho simburímbo eneŋo kho uniyó korete ŋu ŋande miraró, ‘Keto kho uni soso neko yereka mahika kimo yuno. Koretero uni tukú maheteŋgo quro kimoye yunoro, yate-yate korete qu yuno.’ ");
INSERT INTO nca_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Ŋunde yiní uni 5 kilok ŋuno kho kimani taŋgurí ŋu mahero kanata-kanata wondo musiyó kanata raŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Yate-yate uni ita saraŋoní kho kimani taŋgurí ŋu mahero ŋande ye iŋaŋgurí, mone parámi rewe teteto, ye iŋaŋgurí. Quko kini. Ene ŋuya kanata-kanata wondo musiyó kanata naŋge raŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ŋunde rero kho simburí ŋuya kiro mande yero ");
INSERT INTO nca_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ŋande yaŋgurí, ‘Norendo naru piru koweyumu tato kosako nore hamó nutoyote. Quko ŋa uni ŋando tukú mahero naru tukuni naŋge kho teteŋgo, quko noreŋo kimonani ŋunde naŋge siyoteŋgo. Ŋu piyimi.’ ");
INSERT INTO nca_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ŋunde yiqo, kho simburímbo kho uni ŋunde yaŋgurí qu ka ŋande miraró, ‘Topone, no keno o piyimi ka kama teteno. Koretero nore irisa keto wondo musiyó kanata reweya ŋuro newonde kanata taro, hamómbe? ");
INSERT INTO nca_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Asa, kimoke reya toŋe. Neneŋo iŋo-iŋonemo naŋge kimo ŋunde naŋge uni tukú maheteŋgo ŋuya yunoteno. ");
INSERT INTO nca_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ŋuko neneŋo na. Asa neneŋombo meté o neneŋomboro sopoyowano, hamómbe? Ko o meté te yunowero teweqo, ke date koro newonde piyimi tete?’” ");
INSERT INTO nca_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesuko ŋunde yero yaró, “Ŋunde naŋge uni weŋa yoteŋgo ŋuko koretewaŋgo. Ko uni korete yoteŋgo, ŋuko tukú tewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Asa Yesuko Yerusalem oyate iŋo-iŋo rewero uni 12 ŋu yorero enemata yotoro ŋande yimiraró, ");
INSERT INTO nca_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Iŋoyi, itaka nore Yerusalem owé teteto. Ko unindo Unindoro Naŋuní ŋu rero o qa-qa unindoro tapá uni kandeyemo ko hutuŋo mande ŋuro iŋo-iŋo uni kandeyemo rotowaŋgo. Ŋunde riqo, topé piyimi rero, uratoka khumoní, ye iŋowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ŋunde yero rero uni wini meyowomboro kandeyemo rewaŋgo. Ŋuro tero ŋu uni ŋundo huwó mande yero haususuworo tipiririko porowowaŋgo. Ko naru kapusayómo pitu ko otoqoweya.” ");
INSERT INTO nca_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Yiní Sepeti koro simó irisa koya náyarimboya Yesuko mahero potoruku tero pare ŋundo o karo kirayaró. ");
INSERT INTO nca_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yiní ŋande oseseyaró, “Ke do karo iŋoyote?” Yiní ŋande miraró, “Ŋande iŋoteno, asa keto unipareke wiri yereyote naruyómo ŋuno meté neneŋo simóne irisa ŋa ŋuya unipare wiri yerewari, kato kandeke kondéwore kunditiní kato kandeke tesina kunditeweya.” ");
INSERT INTO nca_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesuko mande topé ŋande yaró, “Yeko kira ŋuro kama iŋoyi tondaŋete. Asa yarindo peka nondo topako ŋuno sono newano ŋunope yari ŋuya meté ŋuno newari?” Ko enendo ŋande mirariyó, “Nore meté.” ");
INSERT INTO nca_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ko Yesuko ŋande yimiraró, “Hamó, yarindo neneŋo topako newari. Quko dandoko kandene kondésina ko kandene tesina kunditewari, o ŋuko nondo rokóŋowero qu kini. Kini. Kundite-kundite yakutí ŋuko awando uni ŋuro yero rokóŋaró ŋu yunoweya.” ");
INSERT INTO nca_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Asa iŋo-iŋo rewero uni kande irisa qundo yerepasa ŋu Yesu kirayariyó ŋuro iŋoro eneya saŋgirí taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Quko Yesuko neko yiriní mahiqo, ŋande yaró, “Ye iŋoteŋgo, ko wini meyowomboro uni kembéye ŋundo eneŋo winiye piyimi sopo yereyoteŋgo. Kowe uni parámiyembo eneŋombo owé parámi rewero quro iŋoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Quko ye ŋunde ma tewero. Kini, ye keweroye moŋgo uni kato uni parámi tewero ye iŋoyote tiníqo, sunará simó ŋunde teweya. ");
INSERT INTO nca_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ko uni kato owé parámi rewero ye iŋoyote tiníqo, yeŋo kho simóye ŋunde yoweya. ");
INSERT INTO nca_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ŋunde naŋge Unindoro Naŋuní ŋundo unipareto eneŋo sunará tewero quro kama maheró. Kini, enendo uniparetoro sunará tewero maheró, ko yoto-yotoyó rotoro kimo yerewero koro maheró.” ");
INSERT INTO nca_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Asa Yesu koya iŋo-iŋo rewero uniyómboya Jeriko rotoro oyi unipare qambu horé yohowaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Uni irisa toŋeyari kiré mu khe tapémo kunditeyari. Asa Yesu maheró ŋuro piŋa mande iŋoro kondé ŋande neko kiwariyó, “Uni Parámi, Dewit koro naŋuní, sikínari te nuno.” ");
INSERT INTO nca_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kondé nekoro kiwiri unipare qambu ŋundo qene yero ŋande yaŋgurí, “Ŋunde roto!” yaŋgurí. Quko watí-watí nekoro ŋande kiwariyó, “Uni Parámi, Dewit koro naŋuní, sikínari te nuno.” ");
INSERT INTO nca_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ŋunde yiriqo, Yesu kaŋero uni irisa ŋu neko yerero ŋande yaró, “Yarindo nondo yari do ka te yunowe?” ");
INSERT INTO nca_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ko enendo mande topé ŋande mirariyó, “Uni Parámi, norendo, keto toŋenari reka hiyóqiní, ye iŋotero.” ");
INSERT INTO nca_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesuko sikíyari te yunoro kandí toŋeyari saŋano raró. Riníqo, waka ta toŋeyari meté tiní pitu ko toŋetero Yesu howero toŋeriyó. ");
INSERT INTO nca_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Asa kutaqe Yerusalem owero oro Betipake yendémo mira purí Oliv saŋano maheŋgurí. Mahero Yesuko iŋo-iŋo rewero uni irisa asá yerero ");
INSERT INTO nca_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ŋande yimiraró, “Yendé andusina ŋuno uyareya dóki ka kusiyaŋgurí qu qenewari, ko dóki simó ŋu ŋuya yowari. Asa utó ŋu orosoyero siyoro nono mahiri. ");
INSERT INTO nca_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ko uni kato mande ka yariya yimitoro yiníqo, asa ŋande yiri qembe, ‘Uni Parámimbo ŋuno kho ka teweya.’ Yari ŋunde yiriqo, waka ta enendo dóki nimí, simó ŋu se rotoní nono mahewari.” ");
INSERT INTO nca_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","O ŋu tunoqaró ŋuko ye-ye unindo mande ka yaŋgurí ŋu riní hamó taró. Mande ŋuko ŋandiro, ");
INSERT INTO nca_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mande ka Saion unipareko yesowoyi, ‘Qeni. Wiri yerete uniye mahete ŋa. Newonde imemoŋgo dóki saŋano kunditero mahete, dóki simó saŋano mahete.’” ");
INSERT INTO nca_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Asa iŋo-iŋo rewero uni ŋundo Yesuko yimiraró ŋu ŋunde naŋge tariyó. ");
INSERT INTO nca_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Irisa ŋundo nimímboya simómboya siyo mahero tuwi piruyari se dóki saŋayarimo rariyó. Ko Yesuko ŋuro saŋano kunditaró. ");
INSERT INTO nca_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ko unipare qambu horé qundo tuwi piruye ŋu wendaŋero se khewore raŋgurí. Ko kumimboko te kambiní toŋoro khewore raŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ko unipare Yesu taka koretaŋgurí ko unipare tukú uyareŋgurí, soso ta ŋande kiweyaŋgurí, “Dewit koro Naŋunímboro owí hokoyi! Uni Parámimboro owímo mahete ŋundo puriŋo riní! Anutu owí koreko horé hokoyi!” ");
INSERT INTO nca_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ko Yerusalem quroyómo oníqo, yendé unipare soso ŋundo yukuworo epe osese-osese ŋande taŋgurí, “Uni ŋu dani?” ");
INSERT INTO nca_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ŋunde yiqo, unipare khewore uyaŋgurí ŋundo ŋande yaŋgurí, “Ŋuko Yesu, ŋu ye-ye uni ŋu Nasaret yendé Galili mira koŋgo mahete.” ");
INSERT INTO nca_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Asa Yesuko Ya Surumí ŋuro hoŋgo quroko oro uni soso mone rewero kho teyaŋgo ŋuno qu yohowaró. Yohowero uni moneye rohoréŋoyaŋgo ŋuro wasaye koya uni nú soweyaŋgo ŋuro yakutíye soso se windoroŋaró. ");
INSERT INTO nca_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ŋunde tero ŋande yimiraró, “Sokomeko ŋuno ŋande nakayáŋaró, ‘Neneŋo yane muko hariri koro ya qu.’ Quko yendo ri ‘kuma tero momo teyoteŋgo unindoro ya qu teyote.’” ");
INSERT INTO nca_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Asa Yesu Ya Surumí quroko yoníqo, toŋeye pokamowí mu, kheye piyimi mu eneno mahi yoriní meté taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ko Ya Surumímo simó ta-tako ŋande kiweyaŋgo, “Dewit koro naŋunímboro owí hokoyi!” O qa-qa unindoro tapá uni ŋuya hutuŋo mande ŋuro iŋo-iŋo uni ŋundo o wimbí moré teyaró ŋu qenero simó ta-ta ŋundo mande yero kiweyaŋgo ŋu iŋoro newonde piyimi taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ŋunde tero Yesu ŋande oseseyaŋgurí, “Kepe mande yeteŋgo ŋumbe iŋotepe?” Yi mande topé ŋande yimiraró, “Iyo, no iŋoteno. Quko yendo mande ka kama weyaŋgurí, peka? Mande ŋuko ŋandiro: “‘Keto ŋande ye iŋaró, simó ta-ta maŋgoyemboya oŋa maŋgoyemboya seré te kunowaŋgo.’” ");
INSERT INTO nca_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ŋunde yiní kini tiní yorotoro yendé ŋu rotoro Betani yendémo ŋuno etaró. ");
INSERT INTO nca_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ita saraŋoní yendé parámimo pitu ko uyarewero taró. Tero o qímboro khumaró. ");
INSERT INTO nca_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ko kewá fik ka khe sumeyoro yoní qenero taŋgímo uyaró. Quko taŋgurí ka ŋuno kama yora, komiri naŋge. Ŋunde qenero kewá ŋu ŋande miraró, “Keko naru kaŋuya taŋgurí kama teweya. Kini horé.” Ko waka ta kewá ŋu asáqaró. ");
INSERT INTO nca_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Asáqiní iŋo-iŋo rewero uni ŋundo ŋu qenero iŋondata parámi tero ŋande yaŋgurí, “Date tero kewá fik ŋa waka ta asáqete?” ");
INSERT INTO nca_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ko Yesuko mandeye topé ŋande yaró, “Nondo hamó ye yimiroteno, yendo iŋondutu hamó tero iŋo-iŋo irisa kama towoyoteŋgo tiníqo, asa ye ŋuya nondo kewá fik ŋuro puŋomo o teteno ŋunde naŋge tewaŋgo. Ko yendo murí kanata ŋu naŋge kama tewaŋgo. Kini, ko mira purí ŋa, ‘Otoqoya windi quroko u,’ ŋunde miroyiqota ŋundiro tunoqeweya. ");
INSERT INTO nca_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ko ye iŋondutu tero hariri tewaŋgo quno o soso siyowero hariri tewaŋgo ŋuko yendo siyowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Asa Yesuko Ya Surumímboro hoŋgo quroyómo uro unipare iŋo-iŋo yunaró. Ŋunde yunoyoní o qa-qa unindoro tapá unindoya uniparetoro uni kembé-kembéyemboya kopo mahero ŋande oseseyaŋgurí, “Do owé ka moré o soso ŋa mepémo teyote, ko danimbo owé ŋu re kunaró?” ");
INSERT INTO nca_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ŋunde yi mande topé ŋande yaró, “Asa no ŋuya o karo osese yerewe teteno. Ko neneŋo osesene ŋu topé yiqota do owé ka moré o soso ŋa mepémo teyoteno ŋuro yimirowano. ");
INSERT INTO nca_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Asa ye date iŋoteŋgo, Jonko unipare sono re yunaró ŋuro owé ŋu, da noŋgo raró? Ŋuko sambo koro qumbe ma unindoro qu?” Yiní keweroyemo epe mito-mito ŋande taŋgurí, “Ko norendo, ‘Ŋuko sambo koro qu,’ yewato tiníqo, ŋande osese nereweya, ‘Asa ye date koro mandí iŋoro iŋondutu kama taŋgurí?’ ");
INSERT INTO nca_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Quko norendo, ‘Ŋuko unindoro qu,’ yewato tiníqo, asa nore unipare qambu quro sorewato, dokoro, enendo Jonko Anutu koro ye-ye uni hamó qu ka, ŋunde yero iŋoyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Asa ko eneŋo mandí topé ŋande yaŋgurí, “Nore kama iŋoteto.” Yiqo, ŋande yimiraró, “Asa ko no ŋuya da noŋgo owé ŋa rero o soso teyoteno ŋuro ye kama yimirowano.” ");
INSERT INTO nca_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yero ŋande yaró, “Ye date iŋoteŋgo? Asa uni ka simó irisa. Enendo naŋuní korete quno ŋuno uyaro ŋande miraró, ‘Naŋone, itakako ke toŋeya wain khono kho te.’ ");
INSERT INTO nca_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Yiní simómbo yaró, ‘No ma.’ Quko imemoŋgo iŋo-iŋoyó rohoréŋoní toŋeró. ");
INSERT INTO nca_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Ko iwímbo naŋuní meyowo mande ŋu naŋge yaró. Ko naŋunímbo, ‘Iyo, awa,’ yaró, quko kama toŋeró. ");
INSERT INTO nca_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Asa ŋu simó irisa ŋu, dandoko iwímboro iŋo-iŋoyó howaró?” Yiní ŋande yaŋgurí, “Korete ŋundo.” Ko Yesuko ŋande yimiraró, “Nondo ye hamó yimiroteno, takis re-re unindoya ore paretoya ye taka yerero Anutuko unipareyó wiri yereyote naruyómo ŋuno korete oyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Dokoro Jonko khe roneneŋowíwore yeno maheró, ko ye mandí iŋoro iŋondutu kama taŋgurí. Quko takis re-re unindoya ore pare ŋuya iŋoro iŋondutu taŋgurí. Ŋunde tiqo, ye ŋu qeneŋgurí, quko ye newondeye rohoréŋoro iŋondutu kama taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Asa tapara mande kaŋuya iŋoyi. Naru kano ya simburí kato wain kho ka tero hoŋgo rero wuririyoro ŋu quroko ŋuno wain eŋgémboro sonoyó rewero quro meré parámi ka sero rotoro ya piru kho qene sopoyowero qu ka towaró. Ŋu soso toworo kho ŋu rero kho sopo-sopo uni kumi kandeyemo rotoro mira kapiyamo ŋuno toŋeró. ");
INSERT INTO nca_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Yate-yate eŋgé siyowero naru tukuni tiníqo, sunará simóŋo asá yiriní eneŋo wain eŋgé mandumi ŋu siyowero uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Uyari kho sopo-sopo uni ŋundo sunará simó ŋu yorero kako haususuwaŋgurí, kako uri khumaró ko kako wondo saŋanímo raŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Imemoŋgo simburímbo kho uni meyowo qambu asá yereró. Ko uni tukú asá yereró quro qambuye ŋundo uni korete asá yereró ŋuro qambuye taka yereró. Ko sopo-sopo uni ŋundo komo o murí piyimi taŋgurí ŋu naŋge eneno ŋuya taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Naru weŋako simburímbo eneŋo naŋuní asáŋoro ŋande yaró, ‘Enendo naŋone ŋu ará te inowaŋgo.’ ");
INSERT INTO nca_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Quko kho sopo-sopo uni ŋundo simburímboro naŋuní mahiní qenero keweroyemo ŋande yaŋgurí, ‘Simó ŋundo iwímboro o soso ŋako imemoŋgo siyoweya. Uratoka khumoníka o ŋa soso norendo siyowato.’ ");
INSERT INTO nca_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ŋunde yero re raŋoyi kho tapémo uní uroyi khumaró. ");
INSERT INTO nca_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Asa ye date iŋoteŋgo? Imemoŋgo wain kho simburímbo mahero kho sopo-sopo uni ŋuro do ka te yunoweya?” ");
INSERT INTO nca_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yesu ŋunde yiní ŋande miraŋgurí, “Enendo uni piyimi ŋu o piyimi horé te yunoro kho ŋu pitu rero uni meyowo yunoní sopowaŋgo. Ko eŋgé siyowero naruko ŋuno eneŋo eŋgé ŋu inowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ko Yesuko ŋande osese yereró, “Yeko peka sokomeko ŋuno mande ŋa kama weyoyoteŋgo? “‘Ya re-re unindo wondo ka rero piyimi, yero iŋoro re rotaŋgurí, quko itakako wondo ŋundo ya soso riní kondérewero wondo ka tunoqete. Uni Parámi eneŋombo o ŋu riní ŋunde tunoqiní qenero niŋgu-niŋgu parámi teteto.’ ");
INSERT INTO nca_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ŋunde ŋuroko nondo ye yimiroteno, Anutuko unipareyó wiri yereyote naruyómo yowero ye soré yereweya. Ye soré yerero uni wini meyowo naru ŋuro khoyó ti eŋgé teweya ŋu yoriní ŋuno owaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Uni soso wondo ŋuro saŋano raŋowaŋgo quko kosaŋewaŋgo. Quko wondo ŋundo uni ka saŋano umbuníqo, uni ŋu uso-soworo murutómi teweya.” ");
INSERT INTO nca_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","O qa-qa unindoro tapá unindoya Farisi unindoya Yesuko tapara mande yaró ŋu iŋoro ŋande iŋaŋgurí, ene nore rokó nerete, ye iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ŋunde ŋuroko Yesu towo kusiyowero yero iŋaŋgurí, quko unipare qambu quro soraŋgurí, do karo unipareto ŋande iŋaŋgurí, Yesu ŋuko Anutu koro ye-ye uni ka, ye iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesuko tapara mande kaŋuya ŋande yimiraró, ");
INSERT INTO nca_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Sambo simburímbo unipareyó wiri yereyote naruyó ŋuko ŋandiro. Naru kano wiri yerete uni kato eneŋo naŋuní epe re-re tewero ŋuro o ne-ne naruyó rokóŋaró. ");
INSERT INTO nca_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Koretero topé-topé o ne-neko ŋuno mahewaŋgo, yero neko yereró. Ko o newero naruko ŋuno sunará simóŋo asá yiriní neko yerero yore mahewero toŋeŋgurí. Quko topé-topé ŋundo mahewero piyimiŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Ko ene sunará simó kumi kaŋuya asá yerero ŋande yimiraró, ‘Yendo uni neko yerenowó quno ŋuno naŋge toŋeya ŋande yimiroyi, “Iŋoyi. Nondo o ne-ne ŋu roŋgaruwoteno. O ŋandiro qu makao urumuni qu ko númbowe koweye tinditiwí mu urowe khumoyi se o soso roŋgaruwano. Ye epe re-re koro o ne-neko ŋano mahi.”’” ");
INSERT INTO nca_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Sunará simómbo uyaro ŋunde yimiroyi iŋaŋgurí, quko huwóŋaŋgurí. Kini, kako khoyómo toŋeró, ko kako mone re-re khoyó tewero quro toŋeró. ");
INSERT INTO nca_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ko meyowo ŋundo sunará simóŋo yondoworo o piyimi te yunoro yuri khumaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ŋunde tiqo, wiri yerete uni ŋundo saŋgirí parámi tero kuma uni asá yiriní uyareŋgurí. Uyaro uni sunará simóŋo yuraŋgurí ŋu yore hamó rambaruru yerero yendéye ŋuya qayi qaró. ");
INSERT INTO nca_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Asa wiri yerete uni ŋundo sunará simóŋo ŋande yimiraró, ‘Epe re-re koro o qu komo roŋgaruwowí mu yote, quko uni neko yerenowó ŋu, eneko uni meté kini, ŋuroko o newero naruyómo mahewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ŋunde ŋuroko ye khe saŋa-saŋako uyaqo, uni ka ŋuno yiyoyaqo, neko yirika epe re-re koro o ne-neko ŋano mahi.’ ");
INSERT INTO nca_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ŋunde yiní sunará simó khewore toŋero unipare yiyoro uni piyimi muya uni meté quya yorero soso huru yereŋgurí. Unipare qambu qundo yano mahero o naŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Asa wiri yerete uni ŋundo yayómo oro unipare o neyaŋgo ŋu yiyaró. Yiyoro uni ka qeneró muko epe re-re tewero tuwi meté qu ka kama re taró. ");
INSERT INTO nca_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ko wiri yerete unindo ŋande oseseyaró, ‘Topo, ke date koro tuwi meté qu ka kama re tero ŋano arete?’ Quko uni ŋundo mande topé ka kama yaró. ");
INSERT INTO nca_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Asa wiri yerete uni ŋundo sunará simó ŋande yimiraró, ‘Yendo khí kandí kusiyoya re raŋika mirako uya huriri yendémo ŋuno yoweya. Huriri yendémo ŋunoko tendo piyimi tero metoye kindotowaŋgo.’ ");
INSERT INTO nca_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Qeni, Anutuko uni parámi neko yereyote, quko kanatape ma irisa ŋunde naŋge rokó yiriní quroyómo uyarewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Asa Farisi unindo huruworo Yesu eneŋo mandíwore kusiyowaŋgo ŋuro khe ka seqaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Enendo iŋo-iŋo rewero uniyemboya Herot koro topé kumi ŋu asá yiri Yesuko uyaro ŋande miraŋgurí, “Rondaqe-rondaqe uni, nore ŋande iŋoyoteto, ko keto Anutu koro kheyó hamó moŋgo naŋge rondaqe yunoyote. Ko keto uni karo owé morémbe ma kini ŋuro kama iŋoyote. ");
INSERT INTO nca_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Asa ko ke date iŋote? Ŋu meté norendo Sisa takis re inowato ŋuko hutuŋo mande wendaqeyotepe, ma kini?” ");
INSERT INTO nca_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Quko Yesuko komo iŋo-iŋoye piyimi ŋu qenero ŋande yaró, “Ye uni maŋgoye irisa, ye date koro towo nereteŋgo? ");
INSERT INTO nca_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Yendo takis tewero wondo musiyó ka re witú nirika qenewe.” Yiní denarius ka rero Yesuko maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ko Yesuko ŋande osese yereró, “Wondo musiyó ŋano kapo-kapo ŋaya owí ŋako daniro qu?” ");
INSERT INTO nca_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Yiníqo, “Sisa koro qu,” yaŋgurí. Ko enendo ŋande yimiraró, “O kumi Sisa koro qu, ŋu Sisa se inoyi qembe. Ko o kumi Anutu koro qu, ŋu Anutu se inoyi qembe.” ");
INSERT INTO nca_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ŋunde yiníqo, mande ŋu iŋoro iŋondata parámi tero roto toŋeŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ŋu naruko naŋge Sadyusi uni kumi Yesuko maheŋgurí. Uni ŋundo ŋande yeyaŋgurí, ko unipare khumaŋgurí qundo pitu ko kama otoqowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Asa mahero Yesu ŋande oseseyaŋgurí, “Rondaqe-rondaqe uni, komo Mosesko ŋande yaró, ‘Uni kato pare rero simó moré kini yate khumoníqo, eneŋo koneyómbo pare ŋu riní simó pisiyoníqota payómboro sowe qu tunoqiní.’ ");
INSERT INTO nca_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Asa iŋo. Naru kano uni kato naŋo-simó kande saŋiyoro irisa pisi yiriní keweronanimo yoraŋgo. Simó korete ŋundo pare rero, yate-yate simóyari moré kini tero khumaró. Ŋunde ŋuroko simó irisayó ŋundo payómboro parí ŋu raró. ");
INSERT INTO nca_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ko ene ŋuya simóyari moré kini khumaró, ko simó kapusayó ŋuya ŋunde naŋge taró. Yate-yate soso ŋunde naŋge taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Soso ta khumomukaŋgurí, ko imemoŋgo pare ŋu ŋuya khumaró. ");
INSERT INTO nca_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Asa yeka iŋowato, unipare khumaŋgurí qundo pitu ko otoqowaŋgo quro naruyómo ŋuno, pare ŋu, danimboro yoweya? Dokoro uni kande saŋiyoro irisa qundo pare kanata ŋu raŋgurí.” ");
INSERT INTO nca_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Asa Yesuko mandeye topé ŋande yaró, “Yendo mande sokomeko ŋuno nakayáŋaŋgurí ŋuya Anutu koro wimbí ŋuya kama iŋoyi tondaŋete. Ŋunde ŋuroko ye mande koroqe yeteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Unipare khumaŋgurí qundo pitu ko otoqowaŋgo quro naruyómo ŋuno ŋu unipare ŋuko epe re-re kama tewaŋgo. Kini, eneko sambo simó ŋunde qembe yowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Quko unipare khumaŋgurí qundo pitu ko otoqowaŋgo quro yeweka iŋoyi. Yendo peka Anutuko mande yeno yaró ŋumbeka kama weyo iŋaŋgurí? Ŋuko ŋandiro, ");
INSERT INTO nca_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nondo Abraham koro Anutuyó, Aisak koro Anutuyó, Yakop koro Anutuyó.’ Asa qeni, Anutu ŋuko uni kindo khumaŋgurí ŋuro Anutuye kini. Uni yoto-yotoye moré ŋuro Anutuye.” ");
INSERT INTO nca_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Unipare qambu ŋundo Yesu koro mandí ŋu iŋoroqo kondé yukuwaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Asa Farisi unindo Yesuko Sadyusi maŋgoye kusiyaró ŋu iŋoro pitu ko huruwaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Keweroyemo ŋunoko hutuŋo mande ŋuro iŋo-iŋo uni kato Yesu towoŋowero otoqoro ŋande oseseyaró, ");
INSERT INTO nca_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Rondaqe-rondaqe uni, do hutuŋo mande ŋundoko mande kondé kumi taka yerete?” ");
INSERT INTO nca_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ko Yesuko ŋande miraró, “‘Keto Uni Parámi, Anutuke ŋu, newondekepo, yuqakepo, iŋo-iŋokepo hamó surumí iŋo inoyoto qembe.’ ");
INSERT INTO nca_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mande kondé ŋundoko parámi, ko hamó korete horé yote. ");
INSERT INTO nca_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ko mande kondé irisayó ŋuko ŋunde naŋge. Ŋuko ŋandiro, ‘Keŋomboro iŋoyote ŋunde naŋge topokeporo ŋuya iŋoyoto qembe.’ ");
INSERT INTO nca_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ŋu mande kondé irisa ŋuko Hutuŋo Mande koya Ye-ye Unindoro mandeye soso koro murí.” ");
INSERT INTO nca_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Asa Farisi uni ŋundo ŋuno huruwoyuriqo, Yesuko ŋande osese yereró, ");
INSERT INTO nca_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Yendo Kristo ŋuro date iŋoteŋgo, ŋuko danimboro naŋuní?” Yiní ŋande yaŋgurí, “Dewit koro naŋuní.” ");
INSERT INTO nca_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yi ŋande osese yereró, “Asa date tero Dewit eneŋombo Yuqa Surumíwore uni ŋuro ‘Uni Parámi,’ ye nekaró? Enendo ŋande yaró, ");
INSERT INTO nca_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“‘Uni Parámi ŋundo uni parámine ŋu ŋande miraró, “Kandene kondésina kunditeka nondo saŋgiríŋge soso yorewe keŋo kusuŋokemo yowaŋgo.”’ ");
INSERT INTO nca_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dewitko uni ŋuro ‘Parámine,’ yero nekaró. Asa date tero uni ŋuko Dewit koro naŋuní?” ");
INSERT INTO nca_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ŋunde yiníqo, uni kato topé tewero mepémo kini. Ko ŋu naruko yate uni soso sasaro tero Yesu oka karo kaŋuya kama oseseyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Asa Yesuko unipare qambu ŋuya iŋo-iŋo rewero unindoya yimitoro ");
INSERT INTO nca_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","ŋande yaró, “Hutuŋo mande ŋuro iŋo-iŋo unindoya Farisi uni ŋundoko Moses koro meté raŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ŋunde ŋuroko mande soso yimiroteŋgo ŋuko yendo iŋo howeyuri qembe. Quko eneŋo muríye ma howewero. Dokoro enendo eneŋo mandeye kama howeyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Enendo oka quhurí piyimi uni saŋayemo kusiyoyi korowoyoteŋgo. Quko samaka-samaka ka kama yunoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“O soso teyoteŋgo ŋuko, unindo niyowaŋgo yero teyoteŋgo. Enendo pusi pará-pará kembayemo kusiyoyoteŋgo, ko tuwiye muko masi-masi piru moré. ");
INSERT INTO nca_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Enendo o ne-ne naruko yakutí korete quno ŋuno etewero hamó iŋoyoteŋgo, ko huru-huru yano kundite-kundite korete quno ŋuno kunditewero iŋoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Yendémo ŋuno enendo unipareto eneya naru meté yewaŋgo ŋuro hamó iŋoyoteŋgo, ko unindo, ‘Rapi,’ ye neko nerewaŋgo, yero iŋoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ŋunde ŋuroko unindo yeya, ‘Rapi,’ yero kama neko yerewaŋgo. Dokoro kanata na yeŋo rondaqe-rondaqe uniye, ko yeko soso topo ŋunde naŋge. ");
INSERT INTO nca_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ko nokono ŋano uni ka ‘Awanani’ ye ma nekowero. Kanata ŋundo naŋge yeŋo awaye, ko enendo samboko yote. ");
INSERT INTO nca_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ko yeya, ‘Uni Kembé,’ yero kama neko yerewaŋgo. Yeko uni kembéye kanata na, ŋuko Kristo ŋu. ");
INSERT INTO nca_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yeŋo uni parámiye ŋundoko yeŋo sunará simóye yoweya. ");
INSERT INTO nca_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Uni ka eneŋo owí hokoyoweya, ŋuko owí muko umbuweya. Ko uni ka owí riní umbuyoweya, ŋuko owí parámi reweya. ");
INSERT INTO nca_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ye hutuŋo mande ŋuro iŋo-iŋo unindoya ye Farisi uni ŋuya, yeko uni maŋgoye irisa. Ininiyaqe, quhurí piyimi korowowaŋgo. Yeko sambo simburímbo unipareyó wiri yereyote naruyómboro makoyó wisumuŋoyoteŋgo. Yeŋomboko quroyómo kama oyoteŋgo. Ko unipare quroyómo owero tiqo, yendo oreye kusiyoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(-) ");
INSERT INTO nca_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ye hutuŋo mande ŋuro iŋo-iŋo unindoya ye Farisi uni ŋuya, yeko uni maŋgoye irisa. Ininiyaqe, quhurí piyimi korowowaŋgo. Yeko windi soso andusina quno ŋuno uyaro mirane-mirane soso uyaro Juda koro muríye rondaqe yunoyoteŋgo. Ko uni ŋundo iŋoro howero taka yerero o piyimi horé teyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Yeko toŋeye pokamowí mundo uni khe witú yereyoteŋgo. Ininiyaqe, quhurí piyimi korowowaŋgo. Yendo ŋande yeyoteŋgo, ‘Ko uni kato, “Ya Surumímbo mandene riní kondérete,” yeweya tiníqo, mandí ŋuko kondé horé kini. Quko, “Gol ŋuko Ya Surumí ŋuno yote qundo mandene riní hamó kondérete,” yeweya tiníqo, mandí ŋuko kondé tiní ŋu rotowero mepémo kini.’ ");
INSERT INTO nca_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yeko kape toŋeye pokamowí. Qeni, Ya Surumímbo gol ŋu riní Anutu toŋímo meté horé tete, hamómbe? Asa ko Ya Surumímbo gol ŋu takayote. ");
INSERT INTO nca_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Ko yendo ŋande yeyoteŋgo, ‘Ko uni kato, “Wondo yakutí ŋundo mandene riní kondérete,” yeweya tiníqo, mandí ŋuko kondé horé kini. Quko, “O qa-qa wondo yakutí saŋano yote qundo mandene riní hamó kondérete,” yeweya tiníqo, mandí ŋuko kondé tiní ŋu rotowero mepémo kini.’ ");
INSERT INTO nca_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Yeko toŋeye pokamowí. Qeni, wondo yakutí ŋundo o qa-qa ŋu riní Anutu toŋímo meté horé tete, hamómbe? Asa ko wondo yakutí ŋundo o qa-qa ŋu takayote. ");
INSERT INTO nca_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ŋunde ŋuroko uni ka wondo yakutí ŋundo mandí riní kondéreyote ŋundo wondo yakutí ŋuya o qa-qa saŋano yote ŋundo mandí riní kondéreyote. ");
INSERT INTO nca_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ko uni ka Ya Surumímbo mandí riní kondéreyote ŋundo Ya Surumí ŋuya Anutu ŋuno yote ŋundo mandí riní kondéreyote. ");
INSERT INTO nca_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ko uni ka sambo ŋundo mandí riní kondéreyote ŋundo Anutu koro yakutí ŋuya Anutu ŋuno kunditeyote ŋundo mandí riní kondéreyote. ");
INSERT INTO nca_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ye hutuŋo mande ŋuro iŋo-iŋo unindoya ye Farisi uni ŋuya, yeko uni maŋgoye irisa. Ininiyaqe, quhurí piyimi korowowaŋgo. Yendo o tomó ta khono woteyote ŋu siyoro rondaŋi kande irisa tiní kanata rero Anutu inoyoteŋgo. Quko hutuŋo mande pará-pará kumi rotoyoteŋgo. Mande ŋuko ŋandiro, murí roneneŋowí mu te yunoyi qembe, sikíye te yunoyi qembe, mande komo kusiyaŋgurí ŋu howi qembe. Asa ye meté ŋu hutuŋo mande pará-pará ŋu teya mande tomó ŋuya ma rotowero. ");
INSERT INTO nca_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yeko toŋeye pokamowí mundo uni khe witú yereyoteŋgo. Yendo topa kano kuni tomó ta-ta qenero koweyumu tero se rotoyoteŋgo. Quko ŋu kamel parámi ŋuno yote ŋu kama qenero kinaŋge neyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ye hutuŋo mande ŋuro iŋo-iŋo unindoya ye Farisi uni ŋuya, yeko uni maŋgoye irisa. Ininiyaqe, quhurí piyimi korowowaŋgo. Yeko topa saŋanímo ko kondó saŋanímo sonowoyi kekere ta sara memeri teyote ŋundiro. Quko quroyómo ŋunoko murí piyimi, asa situwiye ta yerewero murí ko eneŋomboro iŋoyowero murí, ŋu maŋgoreyote. ");
INSERT INTO nca_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ye Farisi uni, yeko toŋeye pokamowí. Koreteroqo, topa quroyómo ŋu sonowoyi sara tiníqo, saŋanímo ŋu ŋuya sara teweya. ");
INSERT INTO nca_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ye hutuŋo mande ŋuro iŋo-iŋo unindoya ye Farisi uni ŋuya, yeko uni maŋgoye irisa. Ininiyaqe, quhurí piyimi korowowaŋgo. Yeko uni khumaŋgurí tapu yerewero ya qu saŋanímo sono sara-sara qundo sonowoyoteŋgo ŋunde qembe. Saŋanímo ŋuko qenewero meté horé, quko quroyómo ŋunoko uni khumowímboro wimbuye quya o pusú piyimi mu maŋgoreyote. ");
INSERT INTO nca_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ye ŋuya ŋunde naŋge yoteŋgo. Unindo koweye qeneyoteŋgo, enendo yembeka uni roneneŋowí, ye iŋoyoteŋgo. Quko yeŋo quroyemoko maŋgoye irisawore yewero murí ko hutuŋo mande wendaqewero quro murí ŋuno yote. ");
INSERT INTO nca_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ye hutuŋo mande ŋuro iŋo-iŋo unindoya ye Farisi uni ŋuya, yeko uni maŋgoye irisa. Ininiyaqe, quhurí piyimi korowowaŋgo. Yeko ye-ye unindoro tapu yerewero ya qu ŋu reyoteŋgo, ko uni roneneŋowí ŋuro tapu yerewero ya ŋu núsawa te roŋgaruwoyi kekere teyote. ");
INSERT INTO nca_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ŋunde tero ŋande yeyoteŋgo, ‘Nore usisambatoro naruko ŋuno yoratowó tiníqo, asa nore ye-ye uni kama yurato khumowaŋgo.’ ");
INSERT INTO nca_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ŋu mande ŋundoko yeŋo ŋande witú yerete, yeko unindo ye-ye uni yuroyi khumaŋgurí ŋuro naŋo-simóye. ");
INSERT INTO nca_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Asa ŋundiroko ye toŋeya usisambayembo murí piyimi ŋu mepémo siyomukoyi. ");
INSERT INTO nca_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Ye sire piyimi ŋuro simó. Ye date kewá piyimimo ŋuno kama uwaŋgo? ");
INSERT INTO nca_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Iŋoyi. Ŋu murí ŋuro nondo ye-ye uni ko uni iŋo-iŋoye meté qu ko hutuŋo mande rondaqe yunowero uni asá yerewe yeno uyarewaŋgo. Uyariqo, kumi yuroyi khumoyi yorero tipiririko poro yerewaŋgo. Ko kumi yeŋo huru-huru yaye quroko haususu yerero yendéye moŋgo yohowewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ŋunde teroqo, uni roneneŋowí mu soso nokono yuroyi khumaŋgurí ŋuro sitúye ye saŋayemo yoweya. Ŋu sitú ŋuko uni roneneŋowí soso koro sitúye, asa Apel koro sitú windoroŋaró ŋu noŋgo yate-yate Sekaraia rero wondo yakutí koya Wembó Surumí koya keweroyarimo uroyi sitú windoroŋaró. ");
INSERT INTO nca_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ye hamó yimiroteno, o soso ŋuro kimoyó piyimi ŋu unipare itaka ŋano yoteŋgo qu saŋayemo umbuweya. ");
INSERT INTO nca_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yerusalem, Yerusalem, yendo ye-ye uni yuri khumoteŋgo, ko uni Anutuko asá yiriní maheyoteŋgo ŋu wondo saŋayemo raŋoyoteŋgo. Naru qambu nondo kotoriko simó se wire quroko poka yereyote ŋunde qembe simóŋge se kopo yerewero iŋoyano. Quko yendo ŋuro piyimiŋoyaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Iŋoyi, itakako yaye hamó piyo tiní ye kina yowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Dokoro, nondo ŋande yimirowe, ye no kaŋuya kama niyowaŋgo, yate yendo ŋande yewaŋgo, ‘Uni Parámimboro owímo mahete ŋundo puriŋo riní!’” ");
INSERT INTO nca_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesuko Ya Surumímboro hoŋgo ŋu roto toŋiní iŋo-iŋo rewero uniyómbo mahero Ya Surumímboro pase tomó-tomó soso witúŋoyi qeneró. ");
INSERT INTO nca_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Qenero ŋande yimiraró, “Ye sosopo pase keke-kekere ŋa qeneyoteŋgope? No hamó horé ye yimiroteno, imemoŋgo wondo itaka epe saŋa-saŋa rero towaŋgurí mu soso raŋi umukoweya.” ");
INSERT INTO nca_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yero oro mira purí Oliv ŋuno kunditaró. Kunditiní iŋo-iŋo rewero uniyómbo naŋge mahero mondó ta ŋande oseseyaŋgurí, “Keto nimitoka iŋato, do naruko tunoqeweya? Ko tunoqewero tete ŋuro do rokó ka teweya?” ");
INSERT INTO nca_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Asa Yesuko mandeye topé ŋande yimiraró, “Ye kondé toŋeteyuri. Kota uni kato mahero ye kaná yereweya koro. ");
INSERT INTO nca_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Dokoro, uni qambu qundo mahero no owéne nekoro ŋande yewaŋgo, ‘Kristo ŋuko no,’ yewaŋgo. Ŋunde yero unipare qambu kaná yerewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Yeko kuma parámi teyoteŋgo ŋuro piŋa mande iŋowaŋgo, ko kuma parámi tunoqeweya ŋuro piŋa mande iŋowaŋgo. Asa ye kondé toŋeteyuri qembe. Ma yukuwowero. O soso ŋuko hamó maheweya, takawero mepémo kini. Quko naru maheweya ŋuko naru weŋa qu kini. ");
INSERT INTO nca_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Uni wini kato asa uni wini enesó-enesó kaya kuma ri otoqoweya. Asa wiri yerete unindoro kuma uni qundo otoqoro wiri yerete uni enesó-enesómboro kuma uni quya kuma tewaŋgo. Mirane-mirane korare koya kunduru parámi ŋu ŋuya tunoqeweya. ");
INSERT INTO nca_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","O soso ŋuko pare qahu soso qundo simó pisiyowero tero kowe surumí tete ŋunde qembe. ");
INSERT INTO nca_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ŋu naruko ŋunoko ye yondoworo uni piyimi kandeyemo yorotoyi o quhurí ye yunoro yuri khumowaŋgo. Ko uni wini soso ŋundo yeŋo kondé piyimiŋo yunowaŋgo, dokoro yendo neneŋo owéne nekoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ŋu naruko ŋunoko iŋondutu unipare qambu qundo iŋondutuye rotoro eneŋo topoye ŋuro kondé piyimiŋoro uni piyimi kandeyemo yorotowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kowe ye-ye uni kota-kota wata otoqoro unipare qambu kaná yerewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","O piyimi kate-kate parámi horé tunoqeweya, asa ko uni qambu qundo topotoya newonde meté yunowero murí ŋu roti toŋeweya. ");
INSERT INTO nca_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Quko dani kato kondé kaŋeyate rambaruru takaweya. ");
INSERT INTO nca_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Asa ŋundo mira enesó-enesómo unindo Anutuko unipareyó wiri yereyote naruyó ŋuro miti mande ŋa uni wini enesó-enesó yesowoyiqota naru weŋa qu tunoqeweya. ");
INSERT INTO nca_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Asa ko naru kano o piyimi horé ka komo ye-ye uni Danielko ŋuro yesowaró ŋuno qu mahero yendé meté horé muno ŋuno yoweya. (Ye sokome ŋa weyoteŋgo qu, weyo iŋika tondaŋiní.) ");
INSERT INTO nca_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Asa ŋu naruko ŋuno ye soso Judia mirako yoteŋgo quko yendéye rotoya mira purímo waka ta toŋi qembe. ");
INSERT INTO nca_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Uni ka ya umómo yoweya quko oyó siyowero quro ya quroko ma uwero. ");
INSERT INTO nca_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kowe uni ka khono yote tiníqo, tuwi ka tapémo rota ŋu ŋuya ma rewero. ");
INSERT INTO nca_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ŋu naruko ŋuno ye pare qahu tete, ko simó susu yunoyoteŋgo qu, ininiyaqe, quhurí piyimi korowowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Yeko ŋande hariri ti qembe, asa sorewero naru ŋuko seno matú mopowímo ŋuno kama tunoqeweya, ko Sapat naruko ŋuno kama tunoqeweya. ");
INSERT INTO nca_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Dokoro ŋu naruko ŋuno o quhurí parámi horé qu tunoqeweya. Hamó, Anutuko noko towaró ŋu noŋgo yate arero naru ŋanoko, o quhurí ka ŋunde qu komo kama tunoqaró. Kowe imemoŋgo o quhurí ka ŋunde qu pitu ko kama tunoqeweya. ");
INSERT INTO nca_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","“Asa Anutuko naru piyimi ŋu riní tukuni kama tiníqo, unipare soso piyo temukowaŋgo. Quko enendo unipareyó rokó yereró ŋuro iŋoro naru ŋu riní tukuni ta teweya. ");
INSERT INTO nca_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ŋu naruko ŋuno naŋge, ko uni kato yeya ŋande yeweya, ‘Qeni, Kristo ŋuno qu ŋano yote,’ ma ‘Andu yote anduqe,’ ye ŋuro iŋondutu ma tewero. ");
INSERT INTO nca_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Dokoro, Kristo kota-kota koya ye-ye uni kota-kota koya mahero Anutuko unipare rokó yereró ŋu kaná yerewero o parámi wimbí moré qu tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Asa nondo itaka o soso ŋuro yimiroweqota tunoqeweya quno ŋuno yendo iŋi tondaŋeweya. ");
INSERT INTO nca_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ŋunde ŋuroko ko uni kato ŋande yewaŋgo, ‘Kini, enendo andu mira wimbímo andu yote anduqe,’ asa ye ŋuwore ŋuno ma uyarewero. Kowe enendo ŋande yewaŋgo, ‘Kini, uni ŋuko ya quroko ŋano naŋge yote,’ asa ye iŋondutu ma tewero. ");
INSERT INTO nca_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Dokoro Unindoro Naŋuní maheweya ŋuko kusiro rowá ŋuko kosa aretewore noŋgo sineqero kosa pusuŋetewore uyote ŋunde qembe. ");
INSERT INTO nca_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ukúŋo dano yote quno ŋuno nú saŋgirí parámi ŋundo ŋuno mahero kopoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Naru piyimi ŋuko kini tiníqo, imemoŋgo ta “‘kosa ŋuko huriri tiní kombo ŋuko kama hiyóqiní tutu soso ŋuko sambo koŋgo umbuyi o soso wimbí moré mu samboko yote qu yukuwowaŋgo.’ ");
INSERT INTO nca_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Ŋu naruko ŋuno Unindoro Naŋunímboro rokóŋo samboko aweno tunoqeweya. Kowe uni wini soso mira soso quno ŋuno tendo mukuru tero toŋetero qenewaŋgo. Unindoro Naŋuní koporé kewerowore wimbí moré tero sine parámi horémo mahiní unipare soso qenewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mahero uŋgu yiní eneŋombo sambo simó asá yiriní toŋero unipare rokó yereró qu soso ta roŋgopo yerewaŋgo. Sambo simó ŋundo mira kawore-kawore noŋgo roŋgopo yereyate uro mira weŋawore qu yore mahemukowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Yeŋombo naŋge kewá fik ŋu qenero iŋondutu rero qeni qembe. Naru kano kambinímbo sono woso remukoní komiri keta qu woti qeneroqo, yeŋombo, kosa naru meté tewe tete, ye iŋowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ŋundiro naŋge o soso yeteno ŋako tunoqiníqo, ŋande iŋowaŋgo, Unindoro Naŋuní ŋuko woso kutaqemo mahete, mako rorowo ŋano kaŋete, ye iŋi qembe. ");
INSERT INTO nca_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nondo hamó horé ye yimiroteno, unipare itaka yoroteŋgo quko toŋeye watí yoníqo, o soso ŋa tunoqeweya. ");
INSERT INTO nca_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Sambo koya noko koya kini tewari, quko mande yeteno ŋako kama kini teweya. ");
INSERT INTO nca_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Uni kato o ŋu tunoqeweya naruyó ŋu kama iŋote. Hamó, sambo simó ŋuya Naŋuní ŋuya kama iŋoteŋgo. Iwímbo enesó naŋge naruyó ŋu iŋote. ");
INSERT INTO nca_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Qeni, Unindoro Naŋuní maheweya quro naru ŋuko Noa koro naruyó ŋunde qembe. ");
INSERT INTO nca_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Asa sono riru parámi kama tunoqeyoní unipareto o ne-ne parámi tero epe re-re teyuri, yate Noako waŋgo quroko uró. ");
INSERT INTO nca_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","O eneno tunoqeweya ŋu kama iŋi tondaŋiní sono riru parámi tunoqero unipare soso ta rambaruru yereró. Unindoro Naŋuní maheweya ŋuko ŋunde naŋge tunoqeweya. ");
INSERT INTO nca_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Naruko ŋuno uni irisa khono yoriqo ka rewaŋgo, ka rotowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pare irisa kandeto wit musiyó rumuniŋori ka rewaŋgo, ka rotowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Ŋunde ŋuroko ye kondé toŋeteyuri. Do naruko yeŋo uni parámiye maheweya ŋuko ye ŋu kama iŋoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Quko ŋaro iŋoyi, ya simburímbo do naru horé ŋuno momo uni ŋundo maheweya ŋu iŋote tiníqo, kawaware meté horé tiní ene yayó usowowero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ye ŋuya sopo toŋete yuri. Dokoro Unindoro Naŋuní ŋundo do naruko ŋuno maheweya, ŋu ye kama iŋoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Sunará simó kato suki-suki kho meté tero iŋo-iŋoyó muko meté naŋge. Sunará simó ŋunde qu uni parámiyómbo qenero khoyó inoní ya soso soporo naru metémo sunará simó meyowo wutu yereyote. ");
INSERT INTO nca_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Asa uni parámiyómbo mahiní sunará simó ŋundo kho meté teyote ŋundo meté horé yoweya. ");
INSERT INTO nca_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Hamó horé yimiroteno, uni parámimbo eneŋo situwiyó soso rero sunará simó ŋuro kandímo rotoní sopoweya. ");
INSERT INTO nca_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Quko sunará simó ŋundo newondí moŋgo ŋande iŋoweya, peka, uni parámine muko waka ta kama maheweya, ");
INSERT INTO nca_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","yero otoqoro kho kopo topé yutoro eneŋo o qímboro nero wain nero kape-kape tero yoweya, peka. ");
INSERT INTO nca_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Asa sunará simóŋomboro uni parámiyómbo sóqero mahiní naru ŋuro ye kama iŋoyi tondaŋeweya. ");
INSERT INTO nca_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mahero ene sunará simó ŋu sukepo puŋo-puŋo toŋoro uni maŋgoye irisa quya ŋuno rotoweya. Ŋusina ŋunoko tendo piyimi tero metoye kindotowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ŋu naruko ŋunoko sambo simburímbo unipareyó wiri yereyote naruyó ŋuko ŋande teweya. Asa uni ka epe re-re keta taró. Tiní pare keta kande irisa suruye siyoro kheko kopowero sopaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Kande kasina ŋuko pare kape-kape ko kande kasina ŋuko iŋo-iŋoye meté. ");
INSERT INTO nca_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Pare kape-kape ŋundo suruye siyoro maheŋgurí, quko suruyemboro sonoyó meyowo ŋu ka kama re maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pare iŋo-iŋoye meté ŋundoko sonoyó meyowo ŋuya kusíŋoro suruye ŋuya se maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","“Asa uni epe re-re keta taró ŋu waka kama maheró, ŋunde ŋuroko pare ŋu soso kupo tero eteyaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Eti suwo keweroko uni kato ŋande nekoní iŋaŋgurí, ‘Uni ka epe re-re ta ŋuno qu mahete ŋa. Ye maheya kheko kopoyi.’ ");
INSERT INTO nca_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Iŋoro soso otoqoro suruye se roŋgaruwaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pare kape-kape ŋundo pare iŋo-iŋoye meté ŋande yimiraŋgurí, ‘Yendo sonoye ka se nore nunoyi,’ yaŋgurí. ‘Noreŋo surunani tukuni ta winzumowero teteŋgo.’ ");
INSERT INTO nca_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ŋunde yiqo, pare iŋo-iŋoye meté ŋundo mande topé ŋande yaŋgurí, ‘Kini, sonoyó ŋako nore soso mepémo kini. Meté ye toŋeya ya o soweyoteto qu noŋgo yeŋombo kimo ti.’ ");
INSERT INTO nca_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Asa sonoyó kimo tewero roto toŋikata uni ŋu pare raró ŋu maheró. Mahiní pare kande kasina o roŋgaruwaŋgurí ŋu uni ŋuya epe re-re koro o ne-ne taŋgurí ŋu newero ya quroko oŋgurí. Ko unindoko mako tuŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Imemoŋgo pare meyowo ŋu enepa naŋge mahero ŋande yaŋgurí, ‘Uni Parámi, Uni Parámi, mako kosoka nore oto.’ ");
INSERT INTO nca_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Quko enendo mande topé ŋande yaró, ‘No hamó ye yimiroteno, ye kama iŋo yunoteno.’” ");
INSERT INTO nca_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ko Yesuko ŋande yaró, “Ŋunde ŋuroko ye kondé toŋeteyuri qembe. Do naruko no pitu ko mahewano ŋuko ye kama iŋoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Qeni, Anutuko unipareyó wiri yereyote naruyó ŋuko ŋandiro. Uni kato yendé kapiyamo toŋewero iŋoro sunará simóŋo neko yerero onoŋoyó sopoyowero kho qu yunaró. ");
INSERT INTO nca_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Enendo sunará simó kanata-kanata iŋo-iŋoye qene rondaŋero mone rondaŋero yunaró. Ko kako wondo musiyó 5,000 inaró, ko kako 2,000 inaró, ko kako 1,000 inaró. Yunoní kini tiní toŋeró. ");
INSERT INTO nca_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Toŋiní uni wondo musiyó 5,000 raró ŋundo mone kho teroqo, 5,000 kaŋuya sowe tero raró. ");
INSERT INTO nca_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ko uni 2,000 raró ŋu, ene ŋuya mone kho tero 2,000 kaŋuya sowe tero raró. ");
INSERT INTO nca_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Quko uni 1,000 raró, ŋundoko nokono meré sero uni parámiyómboro mone ŋu re tapuŋaró. ");
INSERT INTO nca_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Naru piru saŋga yateqo, sunará simó ŋuro uni parámiye pitu ko maheró. Mahero mone se yunaró ŋuya mande roŋgaruwaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ko uni wondo musiyó 5,000 raró ŋundo mahero 5,000 kaŋuya re mahero ŋande yaró, ‘Uni Parámi, keto wondo musiyó 5,000 nunaró. Asa qeno, nondo mone kho tewe 5,000 kaŋuya tunoqaró.’ ");
INSERT INTO nca_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Yiní uni parámiyómbo ŋande miraró, ‘Keko sunará simó meté, kho meté horé ta teyara. Keto o tomó ta-ta qu meté horé soparó, ŋunde ŋuroko nondo, keto o parámi sopoweya, ye iŋoteno. Ke maheya noya niŋgu-niŋgu te.’ ");
INSERT INTO nca_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ko uni wondo musiyó 2,000 raró ŋundo ŋuya mahero ŋande yaró, ‘Uni Parámi, keto wondo musiyó 2,000 nunaró. Asa qeno, nondo mone kho tero 2,000 kaŋuya ranowó.’ ");
INSERT INTO nca_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Yiní uni parámiyómbo ŋande miraró, ‘Keko sunará simó meté, kho meté horé ta teyara. Keto o tomó ta-ta qu meté ta sopoyaró, ŋunde ŋuroko nondo, keto o parámi sopoweya, ye iŋoteno. Ke maheya noya niŋgu-niŋgu te.’ ");
INSERT INTO nca_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ko uni wondo musiyó 1,000 raró ŋundo ŋuya mahero ŋande yaró, ‘Uni Parámi, no komo iŋanowó, keko tiwi uni. Keto na uni meyowombo khono o newero qu rimiyoteŋgo ŋu siyoyote. Ko uni meyowombo o yuwoyó mira kano raŋoyoteŋgo ŋu, keto na o woteyote ŋu se kopoyote. ");
INSERT INTO nca_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ŋunde ŋuroko sasaro tero keŋo moneke re uyaro noko sero tapuŋanowó. Moneke ŋuna.’ ");
INSERT INTO nca_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ŋunde yiní uni parámiyómbo mande topé ŋande miraró, ‘Keko sunará simó piyimi, keto wimbuma uni tete. Ke ŋande iŋoyote, no uni meyowombo khono o newero qu rimiyoteŋgo ŋu siyoyoteno, hamómbe? Ko uni meyowombo o yuwoyó mira kano raŋoyoteŋgo ŋu, nondo o woteyote ŋu se kopoyoteno, hamómbe? ");
INSERT INTO nca_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Asa ko ke date koro wondo ŋu rero wondo yano kama raró? Ŋunde tiqo, wondo ya simburímbo wondo kaŋuya saŋanímo riní no maheweqo, neneŋo wondo ŋuya wondo saŋanímo ŋu ŋuya nunoweya. ");
INSERT INTO nca_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“‘Ŋunde ŋuroko wondo musiyó 1,000 ŋu rero uni ŋu wondoyó 10,000 moré ŋu inoyi. ");
INSERT INTO nca_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Dokoro, uni soso oye kumi moré, ko nondo kaŋuya se yunowano. Quko uni kanata kato oyó moré kini, asa o tomó ta ka towote, ŋuko nondo ene noŋgo re rotowano. ");
INSERT INTO nca_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Asa yendo sunará simó piyimi ŋu howi mirako uro huriri yendémo ŋuno uweya. Ŋusina ŋunoko tendo piyimi tero metoye kindotowaŋgo.’ ");
INSERT INTO nca_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Unindoro Naŋuní ŋundo sine parámiyómo sambo simóŋomboya soso mahewaŋgo quno ŋuno eneŋo wiri yerete unindoro yakutí meté horé ŋuno kunditeweya. ");
INSERT INTO nca_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Kunditiní uni wini soso mahero eneŋo toŋímo huruwowaŋgo. Ko enendo ronda yerero wini irisa ŋunde yorotoweya, ŋundiro sipsip sopo-sopoko sipsip kasina meme kasina ronda yereyoteŋgo ŋunde teweya. ");
INSERT INTO nca_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ko sipsip yorero kandí kondésina yorotoro meme yorero kandí tesina yorotoweya. ");
INSERT INTO nca_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Asa kowe wiri yerete uni ŋundo unipare kandí kondésina ŋu ŋande yimiroweya, ‘Komo suki Anutuko noko sambo kama toworo ye wiri yerewero ŋuro iŋoro naru ŋunde qu roŋgaruwaró. Asa ko ye awanembo puriŋo yunaró ŋu, ye mahero ŋu naruko ŋuno oyi qembe. ");
INSERT INTO nca_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Dokoro, komo no o qonemboro khumoweqo, yendo o qonemboro taŋgurí. Sono koro khumoweqo, sono nunaŋgurí. Yendé meyowo moŋgo maheweqo, norero yayemo oŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tuwine moré kini yoweqo, tuwi nunaŋgurí. Se khumo teweqo, sopo nereŋgurí. Kusi-kusi yano yoweqo, mahe niyaŋgurí.’ ");
INSERT INTO nca_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ŋunde yiní unipare roneneŋowí ŋundo mande topé ŋande mirowaŋgo, ‘Uni Parámi, do naruko nore ke kiyato qoŋgeporo khumoyiqo, o newero qu kunatowó? Ko do naruko sonondoro khumoyiqo, sono kunatowó? ");
INSERT INTO nca_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ko do naruko yendé meyowo moŋgo mahiqo, kiyoro korero yananimo otowó? Ko do naruko tuwike moré kini yuriqo, tuwi kunatowó? ");
INSERT INTO nca_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ko do naruko kiyato se khumo taró, ma kusi-kusi yano yuriqo, nore uyare kiyatowó?’ ");
INSERT INTO nca_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ŋunde yi wiri yerete uni ŋundo mande topé ŋande yimiroweya, ‘Nondo ye hamó yimiroteno, o soso topo-topone ka owéye moré kini muno taŋgurí, o taŋgurí ŋuko nono taŋgurí.’ ");
INSERT INTO nca_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Asa wiri yerete uni ŋundo unipare kandí tesina ŋu ŋande yimiroweya, ‘Yeko unipare takuni saŋayemo yote qu, ye norotoya te suki-suki qayote quno ŋuno uyi, kewá ŋuko Monimbu koya sunará simóŋo ŋuro roŋgaruwaŋgurí mu. ");
INSERT INTO nca_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Dokoro komo no o qonemboro khumoweqo, yendo o kama nunaŋgurí. No sono koro khumoweqo, sono kama nunaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","No yendé meyowo moŋgo maheweqo, norero yayemo kama oŋgurí. No tuwine moré kini yoweqo, tuwi ka kama se nunaŋgurí. No se khumone moré quno ŋuno, ma kusi-kusi yano yorano quno ŋuno, yendo mahe kama niyaŋgurí.’ ");
INSERT INTO nca_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ŋunde yiní mandí topé ŋande yewaŋgo, ‘Uni Parámi, do naruko ke kiyato qoŋgeporo khumoro yaró, ma ke sono koro khumaró, ma ke uni yendé meyowo moŋgo qu, ma ke tuwike moré kini, ma ke se khumo teyuri, ma ke kusi-kusi yano yuri, norendo ke o meté kama te kunatowó?’ ");
INSERT INTO nca_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Yi enepa naŋge mandeye topé ŋande yeweya, ‘Nondo hamó ye yimiroteno, yendo oka ka unipare owéye moré kini quno kama te yunaŋgurí, o ŋuko nono kama te nunaŋgurí.’ ");
INSERT INTO nca_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Asa ko ŋu uni wini ŋundo toŋero topé piyimi suki-suki rewaŋgo. Quko unipare roneneŋowí ŋundoko yoto-yoto suki-suki rewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesuko mande ŋu soso yiní kini tiníqo, iŋo-iŋo rewero uniyó ŋande yimiraró, ");
INSERT INTO nca_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ye iŋoteŋgo, naru irisa naŋge yote, ko Taka yereró quro o ne-ne ŋu tunoqeweya. Tunoqiní unindo Unindoro Naŋuní rero saŋgirí kandeyemo ri rero tipiririko urowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Asa o qa-qa unindoro tapá unindoya uniparetoro uni kembé-kembéye soso ya kano huruwaŋgurí. Ya ŋuko tapá uni Kaiapas koro ya qu. ");
INSERT INTO nca_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Huruworo mande tero Yesu kanáŋoro towo pisiyoroqo, re uri khumoweya ŋuro khe qu seqaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Quko ŋande yaŋgurí, “Norendo o ne-ne koro naruyómo kama tewato. Yate unipareto qenero saŋgirí tero otoqoro kuma tewaŋgo koro.” ");
INSERT INTO nca_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Asa Yesuko Betani yendémo kowí piyimi khumo uni ka, owí muko Saimon koro yayómo ŋuno yora. ");
INSERT INTO nca_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ko pare ka mahero noko kumbe tomó ta ka rero sono risá nuŋgurí meté mu Yesu kembémo hausuwaró. Yesu yakutímo etero o neyoní pare ŋundo sono ŋu rero Yesu kembémo windoroŋaró. ");
INSERT INTO nca_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Windoroŋoní iŋo-iŋo rewero unindo ŋu qenero newonde piyimi tero ŋande yaŋgurí, “Ke date koro sono ŋu kina windoroŋote? ");
INSERT INTO nca_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nore sono ŋu soweyoro mone parámi ŋu onoŋoye moré kini qu meté se yunowato.” ");
INSERT INTO nca_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ŋunde yi Yesuko ŋuro iŋoro ŋande yimiraró, “Ye date koro pare ŋa quhurí inoteŋgo? Enendo no o meté te nunote. ");
INSERT INTO nca_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Naru rokóŋoro uni onoŋoye moré kini ŋuko yeya yowaŋgo. Quko no yeya naru piru kama yowano. ");
INSERT INTO nca_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Pareto sono ŋu no kowenemo hausuwote ŋuko uni tapu koro roŋgaru nerete. ");
INSERT INTO nca_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Hamó ye yimiroteno, unindo mira soso miti mande yesowoyowaŋgo quno ŋuno pare ŋando o tete ŋuro ŋuya yewaŋgo, ko pare ŋuro iŋowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Iŋo-iŋo rewero uni 12 qu kato, owí muko Jutas Isikariot, enendo o qa-qa unindoro tapá uniko uyaró. ");
INSERT INTO nca_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Uyaro ŋande oseseyaró, “Ko nondo Yesu yeŋo kandeyemo re rotoweqo, yendo do ka re nunowaŋgo?” Yiní wondo musiyó 30 se inaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ŋu naru ŋu noŋgo eneŋo kandeyemo re rotowero quro naru meté seqaró. ");
INSERT INTO nca_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Asa Bret Yisiyó Moré Kini quro o ne-ne koro kosa naru korete quno ŋuno iŋo-iŋo rewero unindo Yesuko mahero ŋande yaŋgurí, “Dano nore Taka yereró quro o ne-ne ŋu roŋgaruwato ke o ŋu neweya?” ");
INSERT INTO nca_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yi ŋande yimiraró, “Yendé parámimo uya uni kano uya ŋande miroyi, ‘Rondaqe-rondaqe ŋundo ŋande yete, “Narune kutaqemo tete. Noya iŋo-iŋo rewero uninemboya yakemo mahero Taka yereró quro o ne-ne ŋuro iŋoro o ŋu newato.”’” ");
INSERT INTO nca_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ŋunde yimironí uni irisa ŋundo Yesuko yaró ŋu howero yakutímo ŋuno Taka yereró quro o ne-ne ŋu roŋgaruwariyó. ");
INSERT INTO nca_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Asa suwo tiníqo, Yesu koya iŋo-iŋo rewero uniyó 12 ŋuya o newero quro yakutímo etaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Etero o nero ŋande yimiraró, “Hamó horé yimiroteno, ye keweroyemo kato no norero uni saŋgirí kandeyemo norotoweya.” ");
INSERT INTO nca_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yiní newonde quhurí parámi tero kanata-kanata ŋande oseseyaŋgurí, “Uni Parámi, uni ŋu nondope?” ");
INSERT INTO nca_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Mandeye topé ŋande yaró, “Uni ka noya kandeto kondó moŋgo o kopo neyotero ŋundoko no nore uni piyimi kandeyemo norotoweya. ");
INSERT INTO nca_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Unindoro Naŋuní ŋuko mande sokomeko nakayáŋgurí ŋu naŋge howero khumoweya. Quko uni ŋundo Unindoro Naŋuní ŋu re rotoweya quko, o iniyaqe, quhurí piyimi korowoweya. Námbo koretero uni ŋu kama pisiyaró tiníqo, meté.” ");
INSERT INTO nca_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ko Jutas, uni o ŋu teweya ŋundo ŋande yaró, “Rapi, uni ŋu nondope?” yaró. Yiní Yesuko ŋande miraró, “Keto naŋge yete ŋu.” ");
INSERT INTO nca_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Asa o neyate Yesuko bret ka rero Anutu yuŋgunaŋoro romboŋero iŋo-iŋo rewero uniyó yunaró. Yunoro ŋande yaró, “Ŋa reya ni. Ŋako neneŋo kowene.” ");
INSERT INTO nca_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ŋunde naŋge wain topa ka rero Anutu yuŋgunaŋoro iŋo-iŋo rewero uniyó yunoro ŋande yaró, “Ye soso ni. ");
INSERT INTO nca_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Dokoro ŋako neneŋo sitúne na, mande kondé ŋu reweya. Nondo unipare qambu quhuríye se rotowero quro windoroŋowe teteno. ");
INSERT INTO nca_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ŋande ye yimiroteno, wain kaŋuya kama newano, yate Awanembo unipareyó wiri yereyote naruyómo ŋunoqota no meté keta qu yeya newano.” ");
INSERT INTO nca_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ŋunde yiní yambo ka yi kini tiní mirako uro mira purí Oliv ŋuno oŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Asa Yesuko ŋande yimiraró, “Itaka suwonoko iŋondutuye muko piyo tero ye soso norotowaŋgo. Dokoro sokomeko ŋuno ŋande nakayáŋaró, “‘Nondo sipsip sopo-sopo uroweqo, sipsip ŋu soso soremukowaŋgo.’ ");
INSERT INTO nca_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Quko nondo khumoro otoqoroqota ye taka yerero Galili mirako uwano.” ");
INSERT INTO nca_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pitako mande topé yero yaró, “Uni soso iŋondutuye muko piyo tewaŋgo, peka, quko nondo ŋunde tewero mepémo kini.” ");
INSERT INTO nca_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yiní ŋande miraró, “No hamó kimiroteno, itaka suwonoko kotori kama yeyoníqota keto naru kapusa quno neneŋo wawa yeweya.” ");
INSERT INTO nca_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pitako ŋande miraró, “No keya koporo nuri khumowaro, quko no keŋo wawa kama yewano.” Ŋunde yiníqo, iŋo-iŋo rewero uni soso ŋuya ŋunde naŋge yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Asa Yesu koya iŋo-iŋo rewero uniyómboya mira ka owé Getsemani ŋuno oŋgurí. Oro ŋande yimiraró, “Ye ŋano kunditeyurika no anduno uyaro hariri tewe.” ");
INSERT INTO nca_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yero Pita koya Sepeti koro simó irisa ŋu ŋuya yorero oroqo, newondí quhurí tiní ");
INSERT INTO nca_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ŋande yimiraró, “Newondenembo quhurí horé tiní no khumowe teteno. Ye noya ŋano yotoya toŋete sopoyuri.” ");
INSERT INTO nca_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ŋunde yero soŋga ta uyaro kondéqero umu-kembé nokono rero hariri tero ŋande yaró, “Awane, ko khe ka yoníqota topa newano ŋa rika toŋiní. Quko iŋo-iŋone mu ma howewero. Kini, keŋombo na ti qembe.” ");
INSERT INTO nca_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yiní kini tiní iŋo-iŋo rewero uniyómo mahiní ene eteyuriqo, enendo Pita ŋande miraró. “Ŋu date? Yembe naru tukuni naŋge noya toŋetewero mepémo kini peka? ");
INSERT INTO nca_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ye kondé toŋeteya hariri ti qembe. Yate ye osese kano umbuwaŋgo koro. Hamó, yuqaye muko o meté tewero nuŋgurí tete, quko koweye saŋaní ŋuko kondé kini.” ");
INSERT INTO nca_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Asa naru irisayó roto toŋero ŋande hariri taró, “Awane, ko topa ŋa kama norotoní no hamó newano tiníqo, asa meté keŋo iŋo-iŋoke naŋge howe qembe.” ");
INSERT INTO nca_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pitu ko eneno mahero yiyoníqo, eteyaŋgurí, dokoro kupo tero toŋeye quhurí taró. ");
INSERT INTO nca_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ŋunde teyuri yorotoro uyaro naru kapusayómo hariri komo taró ŋunde naŋge taró. ");
INSERT INTO nca_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yiní kini tiní iŋo-iŋo rewero uniyómo mahero ŋande yimiraró, “Yembe watí ete kapeyoteŋgope? Iŋoyi, naru tete, unindo Unindoro Naŋuní quhurí uni kandeyemo rewe teteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ye otoqoyika uyato. Qeni, uni nore uni piyimi kandeyemo norotoweya ŋundo kutaqemo mahete.” ");
INSERT INTO nca_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Asa Yesu mande yeyoní naŋge, Jutas, ŋu iŋo-iŋo rewero uni 12 qu ka, ŋundo maheró. Mahero uni wini parámi horé suke parámi, usú se toworo eneya maheŋgurí. O qa-qa unindoro tapá uni ŋuya uniparetoro uni kembé-kembéyemboya uni ŋu asá yiri maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Komo Jutasko rokó karo ŋande yimiraró, “Nondo uni ka mutó inowano. Uni ŋuko Yesu, towi qembe.” ");
INSERT INTO nca_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Asa waka ta Yesuko mahero ŋande yaró, “Rapi, suwo meté.” Ŋunde yero mutó inaró. ");
INSERT INTO nca_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ko Yesuko ŋande miraró, “Topo, ke o tewero mahete ŋu te.” Ŋunde yiní uni mahero Yesu toworo kondé towaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Towoyi uni ka Yesu koya yariyó quko suke parámiyó rero tapá unindoro sunará simó qu ka utoro kusumbí takaní kusumbí nokono umburó. ");
INSERT INTO nca_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesuko ŋande miraró, “Suke ŋu rika pitu ko paseyómo uní. Dokoro uni sukepo kuma teyoteŋgo ŋuko sukewore piyo tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kepe kama iŋote, peka, nondo meté awane kirayowe sambo simó parámi horé, qambuye muko kuma uni wini parámi 12 taka yerete, ŋu asá yiriní umburo samaka nerewaŋgo? ");
INSERT INTO nca_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Quko komo suki sokomeko ŋuno ŋande nakayáŋaŋgurí, ko o soso ŋako nono tunoqeweya. Asa no ŋunde kirayowano tiníqo, mande sokomeko yote ŋuko hamó kama tunoqeweya.” ");
INSERT INTO nca_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Asa ŋu naruko ŋuno naŋge Yesuko uni qambu ŋu ŋande yimiraró, “Yendo no wiri yerete unindoya kuma teyoteno ŋundiro suke parámi, usú siyoro kondé nondowowero maheteŋgo, peka? Naru rokóŋo Ya Surumímo ŋuno nondo yeya kaŋero mande rondaqe yunoyanowó. Quko ŋu naruko ŋuno kama nondowaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Quko o soso ŋuko ye-ye unindo mande nakayáŋgurí ŋu riní hamó tete.” Ŋunde yiní iŋo-iŋo rewero uniyó soso Yesu rotoro soraŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Uni Yesu towaŋgurí ŋuko Yesu rero o qa-qa unindoro tapá uni Kaiapasko yano oŋgurí. Ŋuno hutuŋo mande ŋuro iŋo-iŋo unindoya uni kembé-kembémboya huru-huru teyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita ŋuya yohowe uyaró, quko ene soŋga sewemo yara. Uyaro tapá uni ŋuro pase quro hoŋgo quroko ŋuno sopo-sopo unindoya kunditeyaŋgurí. Kunditero do ka Yesuko tunoqiníka qenewe yero teyaró. ");
INSERT INTO nca_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","O qa-qa unindoro tapá uni ŋuya uni kembé-kembé soso ŋundo Yesu uri khumowero khe ka seqaŋgurí. Ŋunde tero mande kota-kota iŋowero ye iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ko uni qambu mahero mande kota yero saŋgawaŋgurí. Quko eneŋo potó ka taró qu qene iŋoro uroyi khumowero quro kama qeneŋgurí. Yate uni irisa mahero ");
INSERT INTO nca_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ŋande yariyó, “Uni ŋundo ŋande yaró, ‘Nondo Anutu koro Ya Surumí ŋu meté rambaruruwowano, ko naru kapusa ŋunoko pitu rewe kaŋeweya.’” ");
INSERT INTO nca_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ŋunde yiriqo, tapá uni ŋundo kaŋero ŋande oseseyaró, “Uni ŋando mandeyari saŋga kerete. Ketope mande topé ka yeweyape ma kini?” ");
INSERT INTO nca_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Quko Yesuko mande ka kama yaró. Mondó ta yoní ŋande miraró, “Nondo Anutu yoto-yotoyó moré ŋuro owímo osese kereteno, ko keto mande hamó naŋge yeka iŋato. Kepe Kristo ŋu, Anutu koro Naŋunímbe ma kini?” ");
INSERT INTO nca_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yiní Yesuko ŋande miraró, “Ke ŋunde yete ŋu. Quko nondo ye yimiroteno, ŋa naru koŋgo yendo Unindoro Naŋuní Anutu wimbí moré ŋuro kandí kondésina kunditiní qenewaŋgo, ko sambo koro koporéwore maheweya ŋu qenewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Asa o qa-qa unindoro tapá uni ŋundo newonde piyimi tero eneŋo tuwiyó romboŋero ŋande yaró, “Enendo Anutu yesaráŋoyote. Do karo uni kaŋuya neko yereto quhuríŋo ŋuro yesowowaŋgo? Qeni, yendo itaka ka Anutu yesaráŋoní iŋoteŋgo ŋu. ");
INSERT INTO nca_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ye date iŋoteŋgo, date te inowato?” Yiní mandí topé ŋande yaŋgurí, “Ene quhuríŋo moré, asa ko meté khumoweya.” ");
INSERT INTO nca_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ŋunde yero Yesu umu-kembémo tuteworo kandeto uraŋgurí. Ko kumimbo uto tamoro ");
INSERT INTO nca_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ŋande yaŋgurí, “Kristo, ke ye-ye mande ye. Uni kurote ŋu dani?” ");
INSERT INTO nca_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Asa Pita mirako ya kimbino kunditeyoní sunará pare ka taŋgímo maheroqo, yaró, “Ke ŋuya Yesu, Galili uni ŋuya yorariyó.” ");
INSERT INTO nca_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Quko Pitako unipare soso toŋeyemo wawa yero ŋande yaró, “Keto mande yete ŋu, no kama iŋoteno.” ");
INSERT INTO nca_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Yero hoŋgo koro makoyómo uní sunará pare meyowo ka enepa naŋge qenero unipare kutaqe ŋuno yoraŋgo qu ŋande yimiraró, “Uni ŋako Yesu, Nasaret koro uni ŋuya yorari.” ");
INSERT INTO nca_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ko Pitako wawa kaŋuya yero ŋande yaró, “Hamó horé, no uni ŋu kama iŋo inoteno.” ");
INSERT INTO nca_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Soŋga yateqo, uni kutaqemo kaŋeyaŋgo ŋundo mahero Pita ŋande miraŋgurí, “Hamó, keko wini ŋuro qu ka. Keŋo puŋeŋge eneŋo naŋge.” ");
INSERT INTO nca_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Asa Pitako mande kondé ŋande yaró, “Hamó horé, no uni ŋu kama iŋo inoteno. Ko no hamó kama yeweqo, asa Anutuko no rambaruru nereweya.” Yiníqo, waka ta kotori yaró. ");
INSERT INTO nca_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ko Pitako pitu ko Yesuko mande yaró ŋu iŋoní tunoqaró, “Kotori kama yeyoníqota keto naru kapusa quno neneŋo wawa yeweya.” Ŋuro iŋoro mirako uro tendo piyimi taró. ");
INSERT INTO nca_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Saraŋoníqo, o qa-qa unindoro tapá unindoya uniparetoro uni kembé-kembéyemboya, Yesu uratoka khumoní, yero ŋuro mande kusiyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kusiyoro kandí kusiyoro re uyaro Rom koro uni kembé Pailat ŋuro kandímo rotaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Asa Jutasko topé piyimi Yesu inowero iŋaŋgurí ŋu qene iŋoro newonde surumí tero iŋo-iŋoyó rohoréŋoro wondo musiyó 30 silwa ŋu siyoro o qa-qa unindoro tapá uni, uniparetoro uni kembé-kembéye pitu ko yunaró. ");
INSERT INTO nca_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Yunoro ŋande yaró, “Nondo uni o piyimi ka kama taró ŋu rero uni saŋgirí kandeyemo rotano. Ŋundiro naŋge nondo o piyimi tano.” Yiní mandí topé ŋande yaŋgurí, “Ŋuko noreŋo kini. Keŋo naŋge.” ");
INSERT INTO nca_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Asa ko Jutasko wondo musiyó se Ya Surumí quroko raŋoní uní uyaro ene puŋí kusiyoro umbu poroworo khumaró. ");
INSERT INTO nca_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ko o qa-qa unindoro tapá uni ŋundo wondo musiyó silwa ŋu siyoro ŋande yaŋgurí, “Wondo ŋako uni uroyi khumoweya ŋuro kimoyó. Norendo Ya Surumímboro wondo ŋuya se kopo rewero ŋuko hutuŋo mande wendaqeweya.” ");
INSERT INTO nca_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ko ene mande ka kusiyaŋgurí, asa ŋu wondo ŋundoko mira ka kimo taŋgurí. Mira ŋuko noko kumbe towoyoweya uni ŋuro mirayó. Ŋunde kimoyi uni wini meyowo khumaŋgurí ŋuno tapu yereyaŋgo. ");
INSERT INTO nca_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ŋunde ŋuroko ŋu mira ŋuro owí muko ŋandiro raró, “Sitú koro Noko,” ko unindo itaka owé ŋu naŋge nekoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ŋundiro naŋge komo ye-ye uni Jeremaiako mande ka yaró ŋu hamó taró. Enendo ŋande yaró, “Kumimbo wondo musiyó 30 silwa qu, Israel unipareto uni ŋuro kimoyó yaŋgurí ŋu siyoro ");
INSERT INTO nca_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","noko kumbe towoyoweya uni ŋuro mira ŋu uriyaŋgurí. Uni Parámimbo nimiraró ŋunde naŋge taŋgurí.” ");
INSERT INTO nca_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesuko Rom koro uni kembémboro toŋímo kaŋiní ŋande oseseyaró, “Kepe Juda uniparetoro wiri yerete uni ŋumbe, ma kini?” Yiní mande topé ŋande yaró, “Keŋombo ŋunde naŋge yete,” yaró. ");
INSERT INTO nca_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kowe o qa-qa unindoro tapá unindoya uni kembé-kembémboya Yesu o pi-piyimi teyara yaŋgurí quno ŋuno mande topé kama yaró. ");
INSERT INTO nca_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ko Pailatko ŋande oseseyaró, “Kepe mande yero saŋga kereteŋgo ŋambe kama iŋote?” ");
INSERT INTO nca_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Quko mande topé ka kama yaró. Ŋunde ŋuro Pailat iŋondata parámi taró. ");
INSERT INTO nca_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Taka yereró quro o ne-ne ŋuno Rom koro uni kembé ŋundo murí ka howeyara. Murí ŋuko ŋandiro, unipare qambu ŋundo uni kanata ka kusi-kusi yano yaró ŋu owí nekoyiqo, Pailatko uni ŋu rotoní eneno uyaró. ");
INSERT INTO nca_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ŋu naruko ŋuno uni piyimi parámi ka kusi-kusi yano yora, owí muko Barapas. ");
INSERT INTO nca_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Asa unipare mahe huruwoyi Pailatko ŋande osese yereró, “Nondo dani ka rotoweka yeno uyariní? Nondo Barapas ma Yesu, ŋuko, Kristo, ye nekoyoteŋgo ŋumbe?” ");
INSERT INTO nca_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailatko ŋunde yaró, dokoro ŋande iŋaró, uni pará-parámbo Yesu koya newonde tutu tero re towo kusiyoro maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailatko mande kho inowero yakutímo kunditiníqo, parímbo mande riní eneno ŋande maheró, “Keto uni roneneŋowí ŋuro o ma te inowero. Suwono no qu ka qenero uni ŋuro newonde surumí tano.” ");
INSERT INTO nca_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Asa o qa-qa unindoro tapá unindoya uni kembé-kembémboya unipare newondeye ri otoqaró. Ŋunde tiqo, unipareto neko kiwi, Barapas rotoro Yesu uroyi khumoweya, yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ŋunde yi Rom koro uni kembé ŋundo ŋande osese yereró, “Ye iŋika no irisa ŋa ka rotowe?” Yiní ŋande yaŋgurí, “Barapas naŋge.” ");
INSERT INTO nca_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Yi ŋande osese yereró, “Yesu, ŋuko, Kristo, ye nekoyoteŋgo, nondo date te inowe?” Yiní soso ŋande yaŋgurí, “Re tipiririko uroyi!” ");
INSERT INTO nca_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Yi ŋande osese yereró, “Dokoro? Do piyimi ka tiní ŋuro?” Yiní mande kondé parámi yaŋgurí, “Re tipiririko uroyi!” ");
INSERT INTO nca_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailatko, maŋgoye kama howeweqo, kuma parámi tunoqewero tete, ye iŋoro sono rero unipare toŋeyemo kandí sonowaró. Sonoworo ŋande yaró, “Uni ŋa khumoweya ŋuko neneŋo quhuríne kini, yeŋo quhuríye naŋge.” ");
INSERT INTO nca_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ŋunde yiní unipare soso mande topé yaŋgurí, “Ŋu quhurí ŋuko noreya simónanimboya yoweya.” ");
INSERT INTO nca_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ŋunde ŋuro Pailatko Barapas rotoní eneno uyaró, ko Yesu riní kuma unindo uŋguru-gurumoro tipiririko urowero re uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Asa Rom koro uni kembémboro kuma uniyómbo Yesu rero uni kembémboro yano oŋgurí. Oro kuma uni soso mahero Yesu rero keweroyemo rotaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Rotoro kowe punu-punuyó wendaŋero tuwi mandumi huririyó ka kowí punuwaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Te inoro utó kami ka rero re wakaro wiri yerete unindoro takapu qembe tero kembémo raŋgurí. Ko saté ka rero kandí kondéwore inaŋgurí. Ŋunde tero potoruku kota-kota te inoro kundo mande ŋande yaŋgurí, “Juda uniparetoro wiri yerete uni, ke mahete ŋu!” ");
INSERT INTO nca_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ŋunde yero tuteworo saté ŋu kandí moŋgo rero kembémo utoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","O soso ŋu tero huwó mande yi kini tiní tuwi mandumi ŋu re rotoro eneŋo kowe punu-punuyó re inaŋgurí. Ŋunde tero rero tipiririko urowero re uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kuma unindo uyareyate Sairin uni ka, owí muko Saimon, ŋu qeneŋgurí. Qenero rero Yesu koro tipiriri qu re inoyi re korowaró. ");
INSERT INTO nca_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Uyareyate mira ka, owí muko Golgota, ŋuno oŋgurí. (Owé ŋu “Golgota” murí muko “Kembémboro Wimbí ŋuro mira ŋu.”) ");
INSERT INTO nca_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ŋuno oro wain koya o oŋgomi quya rohoréŋaŋgurí ŋu rero Yesu soŋga ta inoyi niní oŋgoŋoní piyimiŋaró. ");
INSERT INTO nca_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Asa kuma unindo Yesu rero kowe punu-punuyó wendaŋero tipiririko uraŋgurí. Utoro kowe punu-punuyó rewero quro kundo taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ŋunde ti kini tiní mira ŋuno kunditero sopaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ko tipiriri sombémo ŋuno o piyimi taró ŋuro mande ka nakayáŋaŋgurí. Mande ŋuko ŋandiro: “Ŋako Yesu, Juda uniparetoro Wiri yerete Uni ŋu.” ");
INSERT INTO nca_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Uni irisa ŋuya yorero ka kandí kondésinawore tipiriri kano porowaŋgurí, ko ka kandí tesinawore tipiriri kano porowaŋgurí. Uni ŋundo Rom koro mandeye wendaqero kuma teyari. ");
INSERT INTO nca_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Asa unipare uyaro yesaráŋoro kembaye ituqero ");
INSERT INTO nca_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ŋande yaŋgurí, “Keto, Ya Surumí rambaruruworo kosa naru kapusa quno ŋuno keta rewano, yaró. Asa keŋo rambaruru ŋa taka. Ke Anutu koro naŋuní tiníkaqo, tipiriri roto mirako umbu!” ");
INSERT INTO nca_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","O qa-qa unindoro tapá unindoya hutuŋo mande ŋuro iŋo-iŋo unindoya uni kembé-kembémboya huwó mande ŋunde naŋge yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ŋande yaŋgurí, “Enendo uni kumi rambaruru koŋgo yoraró, quko enendo rambaruru ŋa takawero mepémo kini. Israel uniparetoro wiri yerete uni hamó tiníkaqo, tipiriri roto umbuní nore qene iŋondutuwowato. ");
INSERT INTO nca_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Anutuwore iŋondutuwoyote, asa ko Anutuko rambaruru ŋa noŋgo reweya, peka. Dokoro ŋande yaró, ‘No Anutu koro naŋuní,’ yaró.” ");
INSERT INTO nca_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ŋunde yaŋgurí, ko mande wenda-wenda uni irisa ŋuno yuraŋgurí mu ŋu ŋuya huwó mande mirariyó. ");
INSERT INTO nca_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Asa kosa keweroko mira soso huriri teyate suwoya 3 kilok ŋunde taró. ");
INSERT INTO nca_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","3 kilok ŋundiro Yesu kondé ŋande kiwaró, “Eli, Eli, lama sapaktani?” yaró. (Mande ŋuro murí muko ŋandiro, “Anutune, Anutune, do karo norotote?”) ");
INSERT INTO nca_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Uni kumi kutaqe kaŋaŋgurí ŋundo mande ŋu iŋoro ŋande yaŋgurí, “Uni ŋundo Elaija nekote.” ");
INSERT INTO nca_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ŋunde yi uni kato kheŋgeŋoro o piwo qembe ka rero wain oŋgomi quroko riní maŋgoriní satémbo kusiyoro hokoro Yesu maŋgómo re inaró. ");
INSERT INTO nca_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Quko kumimbo ŋande yaŋgurí, “Ŋunde rotoka, qeneyata. Elaijako samakaŋoweyape ma kini?” ");
INSERT INTO nca_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesuko kaŋuya ki parámi tero yuqayó rotoro khumaró. ");
INSERT INTO nca_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Khumoníqo, Ya Surumímo tuwi parámi ka ŋuno pikaŋgurí mu kore koŋgo kosaŋe kusuŋono umburó. Kowe kunduru raŋoní wondo pará-pará kosaŋaró. ");
INSERT INTO nca_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ko uni tapu tondaŋiqo, Anutu koro uni meté horé komo khumaŋgurí qundo otoqaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Imemoŋgo, Yesu otoqoníqota uni tapu koŋgo otoqaŋgurí ŋundo yendé surumímo ŋuno oyi unipare wata yiyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Asa kuma unindoro sopo-sopoyemboya kuma uni ŋuya Yesu sopo yoraŋgo ŋundo kunduru qenero o soso meyowo tunoqaró ŋu qenero sasaro parámi tero ŋande yaŋgurí, “Hamó horé, ŋuko Anutu koro naŋuní,” yaró. ");
INSERT INTO nca_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Komo pare qambu Yesu howero Galili rotoro sunará tero maheŋgurí. Asa ŋu pare ŋundo kapiyamo kaŋero toŋeteyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Keweroyemo kumi muko ŋandiro: Maria Maktala yendé moŋgo qu, ko Maria, Jems koya Josep koro náyari, ko Sepeti simó irisa ŋuro náyari. ");
INSERT INTO nca_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Asa suwo teyoní onoŋo uni kato Arimatea yendé moŋgo qu, owí muko Josep, maheró. Ene ŋuya Yesu koro iŋo-iŋo rewero uniyó ka. ");
INSERT INTO nca_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Enendo Pailatko uyaro kirayoro Yesu ukúŋo ŋumbe meté reweya, kirayaró. Asa Pailatko kuma uni yiní Yesu ukúŋo rero Josep inaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ko Josepko ukúŋo rero tuwi kekere sara-sara qundo pokamaró. ");
INSERT INTO nca_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ko enendo ukú ŋu rero uyaro eneŋo uni tapu keta quno ŋuno quroyómo raró. Uni tapu ŋuko Josep enepa naŋge wondo kandarama ŋuno wekokaró. Asa ŋuno rero wondo parámi ka re rohoréŋoro mahiní makoyó tuŋoní toŋeró. ");
INSERT INTO nca_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ko Maria Maktala noŋgo ŋuya Maria meyowo ŋuya ŋuno yorariyó. Irisa ŋuko uni tapu sumeyoro kutaqemo kunditero toŋetero yariyó. ");
INSERT INTO nca_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Asa saraŋoní, Sapat koro roŋgaruwowero naru ŋu kini tiníqota o qa-qa unindoro tapá unindoya Farisi uni ŋundo Pailat qenewero oŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Oro ŋande miraŋgurí, “Uni Parámi, norendo ŋande iŋoyoteto, ŋu kota uni ŋundo toŋí yoníqo, ŋande yaró, ‘Imemoŋgo naru kapusa rotoroqo, pitu ko otoqowano.’ ");
INSERT INTO nca_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ŋunde yaró, asa yate eneŋo iŋo-iŋo rewero uniyómbo mahero ukúŋo momo tero unipare ŋande yimirowaŋgo, peka, uni tapu koŋgo otoqote. Ŋunde yiqo, mande kota weŋa ŋuko mande kota komo qu takaweya. Ŋunde ŋuroko keto kho uni yimiroyikata, wondo makoyó ŋu meté ta wisumuŋoyuri naru kapusa ŋu kini teweya.” ");
INSERT INTO nca_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ŋunde yi Pailatko ŋande yimiraró, “Yeŋo kuma uniye yoreya uyaya o soso date tero uni tapu ŋu towoní kondéreweya ŋu tika kondé yoní.” ");
INSERT INTO nca_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Yiní uyaro wondo yayó makoyómboro soweyómo noko tamoro kuma uni yorero ŋuno yoroti uni tapu ŋu sopoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Asa Sapat naru ŋu kini tiní, sonda naru korete quno ŋuno, ita saraŋoníqo, Maria Maktala noŋgo ŋuya Maria meyowo ŋuya uni tapu ŋu qenewero toŋeriyó. ");
INSERT INTO nca_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ko waka ta kunduru parámi raŋaró. Dokoro Uni Parámimboro sambo simó sambo rotoro umburo wondo uni tapu wisumuŋaró ŋu rohoré-rohoréŋoní uyariní saŋanímo kunditeyaró. ");
INSERT INTO nca_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Sambo simó ŋuro umu-kembé muko kusiro rowá raŋoyote ŋundiro hiyóqeyaró, ko kowe punu-punuyó muko koko taŋgo qembe sara teyaró. ");
INSERT INTO nca_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Kuma unindo qenero sasaro parámi tero khe kandeye yukuwoní ukú qembe taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Quko sambo simómbo pare irisa ŋande yimiraró, “Yari ma sorewero. No iŋoteno, yariko Yesu, ŋu uni tipiririko uraŋgurí uni ŋu seqa mahetiri. ");
INSERT INTO nca_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ŋuko ŋano kama yote, dokoro komo otoqa, ene komo yaró ŋundiro naŋge. Yari maheya dano ri etaró ŋu qenori. ");
INSERT INTO nca_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Asa ko waka ta toŋeya iŋo-iŋo rewero uniyó ŋande yimiri qembe, ‘Uni tapu koŋgo otoqa. Iŋoyi, enendo koretero Galili mirako uní ŋuno qenewaŋgo.’ Asa nondo piŋa mande yari yimiroteno.” ");
INSERT INTO nca_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ŋunde yiní pare irisa ŋundo sore sasaro parámi tariyó, quko niŋgu-niŋgu parámi horé ŋuya tariyó. Uni tapu ŋu waka ta rotoro kheŋgeŋo uyaro iŋo-iŋo rewero uniyó yimirowero uyaririyó. ");
INSERT INTO nca_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Uyariri Yesuko kheko kopo yerero ŋande yaró, “Naru meté.” Yiní kutaqemo uyaro khímo toworo potoruku te inariyó. ");
INSERT INTO nca_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kowe Yesuko ŋande yimiraró, “Yari ma sorewero. Topo-topone yimirorika Galili ŋuno uyarewaŋgo. Ko ŋusina ŋuno niyowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pare irisa ŋu uyareyoriqo, kuma unindo uni tapu ŋu sopoyaŋgurí kumimbo yendémo uro o qa-qa unindoro tapá uni o soso tunoqaró ŋuro yimiraŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Yimiroyi tapá unindoya uniparetoro uni kembé-kembémboya huruworo mande ka kusiyaŋgurí. Kusiyoro wondo musiyó parámi siyoro kuma uni yunoro ");
INSERT INTO nca_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ŋande yimiraŋgurí, “Yendoko ŋande yi qembe, ‘Eneŋo iŋo-iŋo rewero uniyómboko suwono mahi nore etatoqo, enendoko ukúŋo ŋu re momo taŋgo.’ ");
INSERT INTO nca_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ŋunde yiqo, Rom koro uni kembé ŋundo mande ŋu iŋoweya tiníqo, asa meté nore eneya mande roŋgaruwowato, ko yeko mandeye moré kini.” ");
INSERT INTO nca_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Asa ko kuma unindo kimoye siyoro mandeye howaŋgurí. Ko mande ŋundo Juda unipare keweroyemo toŋero itaka ŋuya yote. ");
INSERT INTO nca_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Asa iŋo-iŋo rewero uni 11 ŋu kheyembo Galili uro Yesuko mira purímo ŋuno uyari qembe yaró muno ŋuno oŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Oro Yesu qenero potoruku te inaŋgurí. Quko kumimbo newonde irisa towaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesuko kutaqemo mahero ŋande yimiraró, “Anutuko o soso nokono, samboko sopowero owé qu nunaró. ");
INSERT INTO nca_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ŋunde ŋuro ye toŋeya uni wini soso yorika neneŋo iŋo-iŋo rewero uniparene ti. Ŋunde tiqo, Awa owímo, Naŋuní owímo ko Yuqa Surumímboro owímo sono re yunoyi qembe. ");
INSERT INTO nca_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ko nondo ye iŋo-iŋo yunanowó ŋu iŋo-iŋo ŋu naŋge unipare yimiroyika ŋu naŋge howeyuri. Iŋi, no naru rokóŋoro, asa yate-yate naru soso kini teweya quno yeya yowano.” ");
INSERT INTO nca_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yesu Kristo, Anutu koro Naŋuní, ŋuro miti mande ŋuko ŋandiro. ");
INSERT INTO nca_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Komo suki, Aisaia, ye-ye uni ŋundo, mande ka ŋande nakayáŋaró, “Iŋo, nondo uni ka mande yesowo yimitoyoweya qu asáŋowe koretero uro keŋo khe qu roŋgaruwoweya. ");
INSERT INTO nca_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Enendo mira wimbímo neko yerero ŋande yimiroweya, ‘Uni Parámimboro khe roŋgaruwoya, eneŋomboro ore roneneŋoyi qembe.’” ");
INSERT INTO nca_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Asa ŋundiro Jon, sono re-re uni ŋundo, mira wimbímo mahero unipare sono re yunoro mande ka yesowo yimitoyara. Mande ŋuko ŋandiro, “Ye quhuríyemboro newonde surumí teya quhurí ŋu se rotoya sono rika Anutuko quhuríye soso se rotoweya.” ");
INSERT INTO nca_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Unipare qambu Judia mira koŋgo qu ko Yerusalem yendé moŋgo qu ŋuno uyaro quhuríye tunomo yi Jotan Sono quroko sono re yunaró. ");
INSERT INTO nca_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jonko tuwi kamel huímbo toworo kowí punuwaró. Ko makao kowímbo utóŋo toworo weheŋo newondí kusiyaró. Muŋa katu koya siso mindiyómboya neyara. ");
INSERT INTO nca_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Unipare mira wimbímo uyari ŋande yesowo yimitoyara, “Imemoŋgo uni ka wimbímboko nene wimbune takate qundo nohowe maheweya. Nondo eneŋo khe punu-punuyómboro utó orosoyewero owé moré kini. ");
INSERT INTO nca_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nondo kina sono re yunoteno. Quko enendo Yuqa Surumí sono qembe re yunoweya.” ");
INSERT INTO nca_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ŋu naruko ŋuno Yesu Galili mira koro yendé ka, owí Nasaret, rotoro uyariní Jotan Sonono Jonko sono re inaró. ");
INSERT INTO nca_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Re inoní sono noŋgo arero koreko toŋetiní sambo kosaŋiní Yuqako nú tero saŋanímo umburó. ");
INSERT INTO nca_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Umbuní maŋgo ka sambo koŋgo ŋande yaró, “Keko neneŋo naŋone, keŋo surumí iŋoyoteno. Keŋo meté kereyoteno.” ");
INSERT INTO nca_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ŋunde yiníqo, Yuqa ŋundo Yesu re mira wimbímo asáŋaró. ");
INSERT INTO nca_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Asáŋoní naru 40 ŋunde rotoro mira ŋuno yoní Monimbuko towoŋoyaró. Mira wimbímo ŋuno Yesu númbowe koro mirako yoní sambo simómbo samakaŋoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tukú uni kumimbo Jon rero kusi-kusi yano raŋgurí. Imemoŋgo Yesuko Galili mirako ŋuno uyaro Anutu koro miti mande yesowaró. ");
INSERT INTO nca_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Yesoworo ŋande yimitoyaró, “Itaka naŋge Anutuko unipareyó wiri yereyote naruyó ŋu tunoqewero tete. Ye quhuríyemboro newonde surumí teya quhurí ŋu se rotoya miti mande ŋa iŋoya iŋondutu ti qembe,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Asa Yesuko Galili Sono Towo tapéwore uyareyate yerepasa ka khoyari tero sono qare siyoyori yiyaró. Yerepasa ŋu, owéyari Saimon, Andru, ŋundo tirí-tirí ka re sono towoko raŋoro wosoyariyó. ");
INSERT INTO nca_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Asa yiyoro ŋande yimiraró, “Mahe nohowiri. Nondo kho ka yunowe unipare Anutusina yowosowari,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Yiní waka ta tirí-tiríyari ŋu rotoro howariyó. ");
INSERT INTO nca_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Soŋga ta uyaro Sepeti simó naŋuní irisa yiyaró. Yerepasa ŋu, owéyari Jems, koneyó Jon, ŋundo waŋgo tomó ta quno ŋuno tirí-tirí se roŋgaruwoyariyó. ");
INSERT INTO nca_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yiyoro ŋande yimiraró, “Mahe nohowiri,” yiní awayari, kho uniyari waŋgo tomó ta ŋuno yorotoro howariyó. ");
INSERT INTO nca_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Asa Kaperneam yendémo uyareŋgurí. Sapat naruko ŋuno Yesuko huru-huru yano oro Anutu koro mandí rondaqe unipare yunaró. ");
INSERT INTO nca_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ŋunde yunoní unipare iŋoro kondé yukuwaŋgurí. Dokoro mande yaró ŋuko wimbí moré, hutuŋo mande ŋuro iŋo-iŋo unindoro mandeye ŋunde qembe kini. ");
INSERT INTO nca_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ŋu naruko ŋuno uni ka huru-huru yano areró muko yuqa pusú ka quroko yaró. ");
INSERT INTO nca_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Asa ŋundo kiwero ŋande yaró, “Aine, Yesu Nasaret noŋgo, do nereweya? Kepe nore rowore nerewero mahetepe? No iŋo kunoteno, keko Anutu koro uni meté horé ŋu.” ");
INSERT INTO nca_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yiní Yesuko ŋande qene yaró, “Ke maŋgoke kusiyoya uni ŋu roto toŋe!” ");
INSERT INTO nca_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ŋunde yiní yuqa pusú ŋundo uni ŋu riní khí kandí yukuwoní ki parámi tero uni ŋu roto toŋeró. ");
INSERT INTO nca_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ŋunde tiní unipare soso ŋu newondeye yukuwoní niŋgu-niŋgu tero epe mito-mito taŋgurí, “Ŋa do ka? Mande keta ka wimbí moré yete! Ko enendo yuqa pusú yimironíqo, maŋgó howero waka ta roto toŋete!” ");
INSERT INTO nca_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ŋunde yiqo, imemoŋgo unipare soso Galili mirako ŋuno waka ta Yesuko o taró ŋuro piŋa mande iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Asa Yesuko huru-huru ya noŋgo uro Saimon, Andru koro yayarimo oró. Oro Jems, Jon, Saimon, Andru ŋu soso ŋuya oŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ŋuno Saimon koro koŋgí kowí tiwi riní se khumo tero eteyaró. Asa yano arero pare ŋuro miraŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Miroyi oro kandí toworo samakaŋoní otoqaró. Otoqoní kowí tiwi kini tiní pare ŋundo o qoyemboro roŋgaruwaró. ");
INSERT INTO nca_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kosa pusuŋiní suwo tiníqo, uni se khumo piyimiye moré mu soso ŋuya uni yuqa piyimi quroyemo yaŋgurí mu, ŋu ŋuya yore Yesuko maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ŋunde ti yendé unipare soso makono kaŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kaŋi Yesuko unipare qambu se khumo piyimi kate-kate taŋgurí ŋu roŋgaru yiriní meté taŋgurí. Ko yuqa piyimi wata unipare quroko qu yohowiní toŋeŋgurí. Yuqa piyimi ŋundo Yesu qene iŋaŋgurí. Ŋunde ŋuroko mande yewero ŋuro soré yereró. ");
INSERT INTO nca_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Asa ita saraŋowero tiníqo, Yesuko otoqo toŋero mira uni kinimo hariri teyaró. ");
INSERT INTO nca_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ŋunde tiní Saimon koya topé-topémboya seqayate ");
INSERT INTO nca_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","qenero ŋande miraŋgurí, “Uni soso seqa kereteŋgo,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yiqo, ŋande yaró, “Nondo unipare qambu mande yesowo yimirowero ŋuro iŋoyoteno. Ŋunde ŋuroko yendé meyowo kutaqe quno ŋuno uyato.” ");
INSERT INTO nca_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Asa ko Galili mira soso ŋuno yendéne-yendéne huru-huru yayemo oro mande yesoworo yuqa piyimi unipare quroko qu yohowaró. ");
INSERT INTO nca_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Naru kano kowí piyimi khumo uni kato mahero Yesu nekoro potoruku te inoro ŋande kirayaró, “Keto ŋu iŋi mepémo tiníqo, no nori sara tewano,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ŋunde yiní Yesuko sikí te inoro kandí saŋanímo rero miraró, “No ŋuro iŋoteno. Ke sara teweya.” ");
INSERT INTO nca_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Yiní waka ta se khumo ŋuno qu roto toŋiní sara taró. ");
INSERT INTO nca_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ŋunde tiní Yesuko asáŋoro mande kondé yaró, ");
INSERT INTO nca_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“O ŋa keno tunoqete ŋaro uni ka ma yimirowero. Hutuŋo mande Mosesko yimiraró ŋu howeya o qa-qa uni koweke re witú yereya keto sara tunoqete quro oka Anutu te ino qembe. Ŋunde tiqo, se khumoke kini tete, ye iŋowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yiníqo, uni ŋu toŋero mondó ta kama yora. Kini, sowo mande ŋu yendé soso ŋuno yesowoyaró. Ŋunde ŋuroko ŋu naruko ŋu noŋgo Yesuko yendémo tunomo uyarewero mepémo kini, mira uni kinimo naŋge yoraró. Asa unipareto Yesu koro murí iŋowero quro ŋuno maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tukú, Yesu pitu ko Kaperneam uyaro yayómo oníqo, unipareto ŋuro iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Iŋoro mahe kopoyi ya maŋgoriní mako ŋuya wisumuŋoyi Yesuko mande yesowaró. ");
INSERT INTO nca_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ŋunde tiní uni se khumo uni ka, khí irisa-irisa ukumi, ŋundo Yesu qenewano, yero iŋaró. Asa topé-topé nimí kini pitikiwore koroworo maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mahi unipare qambu ya maŋgoriní ŋu quroko owero rukusuworo ya umómo oŋgurí. Oro witu rero yakutí ŋu utómbo kusiyoro mondó ta rotoyi yakutímo umburó. ");
INSERT INTO nca_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Uni kandeka ŋundo Yesuko roŋgaruwoweya, yero iŋaŋgurí. Ŋunde iŋoro uni ŋu rotoro umbuyi Yesuko yiyoro iŋondutuye qene iŋoro ŋande yaró, “Naŋone, quhuríŋge se rotoní,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Yano ŋuno hutuŋo mande ŋuro iŋo-iŋo uni kumimbo ŋuno kunditero o soso qenero newondeyemo ŋande yero iŋaŋgurí, ");
INSERT INTO nca_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Do ka yete? Mande ŋuko Anutu yesaráŋoyote. Anutuko naŋge quhurí se rotowero wimbí tete.” ");
INSERT INTO nca_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ŋunde yero iŋoyi Yesuko newondeyemo osese-osese taŋgurí ŋu qene iŋoro ŋande yimiraró, “Dokoro newondeyemo osese ŋunde qu ye iŋoyoteŋgo? ");
INSERT INTO nca_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nondo se khumo uni ŋa, ‘Quhuríŋge se rotoní,’ ye mirowano tiníqo, ŋuko wuruwara mande peka, ye eŋgé qenewero mepémo kini. Quko, ‘Ke otoqoya pitiki ŋu khete-khete uyare,’ yero miroweqo, mande ŋuro eŋgé qenewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Quko ŋande iŋi. Unindoro Naŋuní ŋundo nokono ŋano unindoro quhuríye se rotowero quro wimbí tete.” ");
INSERT INTO nca_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ŋunde yero uni khí piyimi ŋu ŋande miraró, “Nondo kimirowe, ke otoqoya pitiki re korowoya yakemo u,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Yiníqo, unipare soso toŋeyemo otoqoro waka ta pitiki rero toŋeró. Ŋunde tiní unipare soso qenero newondeye uroní niŋgu-niŋgu tero Anutu seré te inaŋgurí. Kowe ŋande yaŋgurí, “Oka ŋundiro kama qenetowó ŋu,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Asa imemoŋgo Yesuko pitu ko Galili Sono Towo tapémo uyariní unipare qambu ŋuya ŋuno uyari Anutu koro mandí rondaqe yunoyaró. ");
INSERT INTO nca_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Uyareyate, Alipeus naŋuní, owí Liwai, ŋu takis rewero paseno kunditiní qenero ŋande miraró, “Otoqoya nohowe,” yiní otoqo howaró. ");
INSERT INTO nca_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tukú Yesu koya iŋo-iŋo rewero uniyómboya Liwaiko yano etero o naŋgurí. Ŋu naruko ŋuno takis re-re unindoya quhurí unindoya eneya yano o naŋgurí. Dokoro uni ŋu ŋuya Yesu iŋo inoro howeyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Asa Farisi winindoro hutuŋo mande ŋuro iŋo-iŋo uni kumimbo Yesu qenero iŋo-iŋo rewero uniyó ŋu ŋande osese yereŋgurí, “Dokoro takis re-re unindoya quhurí unindoya o neyote?” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ŋunde yi Yesuko iŋoro ŋande yimiraró, “Se khumo unindo naŋge dota ŋuno uyareyoteŋgo. Uni meté qu ŋuno kama uyareyoteŋgo. Nondo uni roneneŋowímboro kama mahenowó. Quhurí unindoro naŋge mahenowó.” ");
INSERT INTO nca_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Naru kano Jon koro iŋo-iŋo rewero uniyómboya Farisi unindoya Anutu potoruku re inoro o newero ŋuro kundiŋi teyaŋgurí. Asa naru kano uni kumimbo uyaro Yesu oseseyaŋgurí, “Jon koro iŋo-iŋo rewero uniyómboya Farisi unindoro iŋo-iŋo rewero uniyemboya o newero ŋuro kundiŋi teyoteŋgo. Quko dokoro keŋo iŋo-iŋo rewero unike ŋundiro kama teyoteŋgo?” ");
INSERT INTO nca_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ŋunde yiqo, ŋande yimiraró, “Ko uni kato epe re-re tewero o ne-ne naruko ŋuno topé-topémbo kundiŋi tewero mepémo kini, hamómbe? Iyo, ŋuno yoníqo, kundiŋi kama tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Quko imemoŋgo uni kato uni ŋu ri toŋeweya. Ŋu naruko ŋuno topé-topémbo newonde surumí tero o newero ŋuro kundiŋi tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Uni kato tuwi sombé keta qu rero tuwi komo qu wituyó mu kama tiŋiyoweya. Kini. Imemoŋgo kowe punu-punu sonowoníqo, tuwi keta ŋu wosoníqota piyimi horé wuriweya. ");
INSERT INTO nca_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ko uni kato wain keta qu re meme kowí puŋge komo quno ŋuno kama puŋgeyoweya. Kini, wain keta ŋuro yuqayómbo puŋge komo ŋu umboroŋoní wain ŋu hausuworo nokono umbuní puŋge ŋuya piyo teweya. Asa ko wain keta qu puŋge keta quno naŋge puŋgeyoyi qembe.” ");
INSERT INTO nca_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Asa Sapat naru kanoko Yesu koya iŋo-iŋo rewero uniyómboya wit koro kho keweroko uyaro iŋo-iŋo rewero uniyómbo wit simó kumi siyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ŋunde tiqo, Farisi unindo Yesu ŋande miraŋgurí, “Hutuŋo mande ŋundo otete ŋu soréŋoro, Sapat naruko ŋuno ŋu ma tewero, yete. Ye do karo ŋunde teteŋgo?” ");
INSERT INTO nca_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ŋunde yiqo, mande topé yaró, “Yembe komo Dewit koya topé-topémboya o qoyemboro khumoro o taŋgurí ŋuro sowo mande ŋumbe kama weyo iŋaŋgurí, peka? ");
INSERT INTO nca_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Asa Apiatar o qa-qa unindoro tapá uniyómboro kho taró quno ŋuno Dewitko Anutu koro yano oro bret ŋu Anutu toŋímo yara ŋu re umburo nero topé-topé yunoní naŋgurí. Quko bret ŋuro, hutuŋo mandeko ŋande yete, o qa-qa uni ŋundo naŋge bret ŋu newaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","“Ŋundiro naŋge Anutuko unipare samaka yerewero quro Sapat naru rokóŋaró. Mande ŋu howewero quro unipare kama yondowaró. ");
INSERT INTO nca_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Asa ko Unindoro Naŋuní ŋundo Sapat naru ŋuya sopoyote.” ");
INSERT INTO nca_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Asa Sapat naru kano, Yesuko Juda koro huru-huru yano oró. Oní uni ka kandí piyimi mu ŋuno yoraró. ");
INSERT INTO nca_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Yoní Farisi unindo Yesuko uni ŋu roŋgaruwoní sopo qeneŋgurí. Ŋunde roŋgaruworo Sapat naru ŋuro hutuŋo mande wendaqiníqo, mande kho Yesu inowato, ye iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Asa Yesuko uni kandí piyimi ŋu ŋande miraró, “Otoqo, keweroko ŋano kaŋe,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ŋunde yero Farisi uni ŋande osese yereró, “Sapat naru ŋa do otete ka hutuŋo mande wendaqeweya? O meté tewatope ma o piyimi te inowato, asa uni ka roŋgaruwowatope ma urato khumoweya?” Ŋunde yiní mondó ta kunditaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ŋunde ti toŋete yiyoro saŋgirí taró. Farisi uni ŋundo newondeye kondé kusiyaŋgurí. Ŋunde ŋuro Yesuko newonde surumí parámi tero uni kandí piyimi ŋu ŋande miraró, “Kandeke raŋo.” Yiní kandí raŋoní meté taró. ");
INSERT INTO nca_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ŋunde tiní Farisi unindo ya rotoro Herot koro topé-topémboya epe mito-mito tero Yesu urowero kheyó seqaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Asa Yesu koya iŋo-iŋo rewero uniyómboya Galili Sono Towoko ŋuno uŋgurí. Uyi unipare qambu parámi Galili noŋgo, Judia noŋgo ŋundo howaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ŋuya unipare Yerusalem yendé moŋgo, Itumea mira koŋgo, mira Jotan Sono karóŋo andusinaŋgo, yendé irisa Tair koya Saiton noŋgo ŋu, soso Yesuko kho taró ŋuro piŋa mandeyó iŋoro Yesu qenewero uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Uyari Yesuko se khumo uni qambu ŋuno roŋgaru yiriní meté tiqo, se khumo uni qambu Yesu pekáŋowero epe pito-pito taŋgurí. Ŋunde ŋuroko Yesuko iŋo-iŋo rewero uniyó ŋande yimiraró, “Waŋgo tomó ta ka roŋgaruwoyika kondé pito nerewaŋgo tiníqo, waŋgowore toŋewano, peka,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kowe yuqa pusúmbo Yesu qeneroqo nokono umburo ŋande nekoyaŋgurí, “Keko Anutu koro Naŋuní,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Quko ŋande yiyo yaró, “Nenemboro ma yewero,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Asa Yesuko mira purímo oro iŋo-iŋo rewero uni kumi neko yiriní ŋuya oŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Oro iŋo-iŋo rewero uniyó khe saŋiyoro irisa rokó yerero owé ka “asá yerewí uni” re yunaró. Ŋunde rokó yiriní eneya taŋgímo yowaŋgo, ye iŋaró, ko miti yesowowero, Anutu wimbímo yuqa piyimi yohowewero quro asá yereró. ");
INSERT INTO nca_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Asa uni khe saŋiyoro irisa rokó yereró ŋuro owéye muko ŋandiro: Saimon (asa Yesuko owé kaŋuya Pita yaró). ");
INSERT INTO nca_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Kowe Sepeti naŋuní irisa ŋu Jems, Jon (asa Yesuko owéyari kaŋuya Boanerikes yaró. Owé ŋu murí muko ŋandiro: Kusiroko Ŋuri Tete ŋundiro.) ");
INSERT INTO nca_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Kowe Andru, Filip, Bartolomeyu, Matyu, Tomas, Jems Alipeus naŋuní, Tatius, Saimon, ŋuko Selot koro wini ka, ");
INSERT INTO nca_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Jutas Isikariot. Uni weŋa ŋundo imemoŋgo Yesu re uni piyimi kandeyemo rotoweya. ");
INSERT INTO nca_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Asa Yesuko ya kano oró. Oní unipare qambu kopoyi Yesu koya iŋo-iŋo rewero uniyómboya o newero mepémo kini taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ŋu naruko ŋuno unipareto ŋande yaŋgurí, “Yesuko kape-kape hamó teyote, peka.” Ŋunde yi eneŋo suwisawiyómbo iŋoro o soso taró ŋuro iŋoro, sopoya towato, yero iŋoro uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kowe hutuŋo mande ŋuro iŋo-iŋo unindo Yerusalem roto uro ŋande yaŋgurí, “Belisipuluko Yesu sopoyote,” yero “Yuqa piyimimboro uni kembéyemboro wimbímo yuqa piyimi uni quroko yote ŋu yohowiní toŋeyoteŋgo,” ŋunde yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Asa Yesuko unipare kopo yerero tapara mande rondaqe yunoro ŋande yaró, “Monimbuko eneŋo topé-topé yohowewero rukusuwote. ");
INSERT INTO nca_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Wiri yerete unindoro mira qu kato usoworo uni soso wini irisa tero kuma tewaŋgo tiníqo, mira ŋuko piyo teweya. ");
INSERT INTO nca_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ko sowe-sowe ka epe uto-uto teyoteŋgo tiníqo, sowe-sowe ŋu usoworo piyo teweya. ");
INSERT INTO nca_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ko Monimbu koya topé-topémboya epe uto-uto teyoteŋgo tiníqo, Monimbu ŋu kini teweya. ");
INSERT INTO nca_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Uni kato uni kondémboro situwiyó siyowero yayómo kinaŋge kama oweya. Kini. Koretero uni ŋuko uni kondé ŋu khe kandí kusiyoro imemoŋgo situwiyó soso siyoweya. ");
INSERT INTO nca_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nondo hamó yimiroteno. Unipareto quhurí parámi teyoteŋgo, ko Anutu yesaráŋoyoteŋgo. Anutuko quhurí ŋu soso meté se rotoweya. ");
INSERT INTO nca_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Quko unipare kato Anutu koro Yuqa Surumí ŋu yesaráŋoyiqo, Anutuko quhurí ŋu kama re rotoweya. Suki-suki quhurí ŋu korowoyoweya.” ");
INSERT INTO nca_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ŋunde yaró, dokoro uni kumimbo yeyaŋgurí, “Yuqa pusúmbo Yesu sopoyote,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Asa Yesu koro nimímboya kone-topémboya yano mahero mirako kaŋero mande ri Yesuko oró. ");
INSERT INTO nca_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Oní unipare qambu Yesu wuririyoro kunditaŋgurí ŋundo ŋande miraŋgurí, “Qeno, náŋge, kone-topoke, kaŋero ke kiyowero yeteŋgo amu,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Quko mande topé ŋande yaró, “Dani náme, one-topone ka?” yaró. ");
INSERT INTO nca_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Yero unipare wuririyoro kunditaŋgurí mu yiyoro ŋande yimiraró, “Qeni, ŋano unipare yoteŋgo ŋando ta neneŋo náme, one-topone. ");
INSERT INTO nca_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Dokoro unipareto Anutu koro iŋo-iŋoyó howeyoteŋgo ŋuko neneŋo náme, one-topone horé.” ");
INSERT INTO nca_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Asa pitu ko Galili Sono Towo tapémo ŋuno mande rondaqe yunaró. Ŋunde tiní unipare qambu parámi horé wuririyoyi waŋgo tomó ta quroko uro sono saŋano kunditero mande yimiraró. Yimironí unipare qambu ŋu sono towo tapémo kaŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ŋuno kaŋeyuri tapara mande qambu yimitoyoro ŋande yaró, ");
INSERT INTO nca_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Iŋoyi, naru kano uni kato o yuwoyó khono se kuriyaró. ");
INSERT INTO nca_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kuriyoní kumi kheko umbuyi númbo mahero nemukaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kumi noko wondo seqemo yote ŋuno umburó, ko waka ta toŋí raŋoro wotaŋgurí, dokoro noko parámi moré kini. ");
INSERT INTO nca_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Quko hurí meté kama uró. Ŋunde ŋuroko wotiqo, kosa kondé qeniní asáqe khumaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kumi kakari keweroko umburo wotaŋgurí, ko kakari muko noko kiruwó wosoro kosa saki riní eŋgé kama taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kumi noko meté muno umburo wotero parámi taŋgurí, ko kumi eŋgé 30 tero, kumi eŋgé 60 tero, kumi 100 ŋunde taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","“Uni ka kusumbí moré tiníqo, mande ŋa iŋoní.” ");
INSERT INTO nca_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tukúko, unipare qambu ŋu roto toŋiqo, iŋo-iŋo rewero uni khe saŋiyoro irisa ŋuya iŋo-iŋo rewero uni kumimboya tapara mande ŋuro iŋi tondaŋewero quro oseseyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Oseseyiqo, mande topé ŋande yaró, “Komoko, Anutuko unipareyó wiri yereyote naruyó ŋuro mande ŋuko mande tapuŋowí mu. Itaka yepa naŋge mande ŋu tunomo rondaqe yunoyoteno, quko uni kinaŋge koro tapara mande yimiroteno. ");
INSERT INTO nca_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ŋundiro Anutu koro mande ŋa hamó tunoqeweya: “‘Qeneyowaŋgo, quko iŋondutuye kama hiyóqiní, Iŋoyowaŋgo, quko kama iŋoyi tondaŋiní, Yate quhurí moŋgo rohoréŋo mahi quhuríye se rotowano koro.’” ");
INSERT INTO nca_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yero ŋande yaró, “Tapara mande ŋa kama iŋoyi tondaŋete tiníqo, tapara mande soso kama iŋoyi tondaŋeweya. ");
INSERT INTO nca_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tapara mande ŋuro murí muko ŋandiro: o yuwoyó kuriyaró muko Anutu koro mande ŋu naŋge. ");
INSERT INTO nca_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","O yuwoyó kheko umbuŋgurí ŋuko ŋandiro: unipareto mande iŋoyiqo, waka ta Monimbuko mahero mande ŋu newondeyemo se ta yere rotoyote. ");
INSERT INTO nca_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","O yuwoyó noko wondo seqemo yote ŋuno umbuŋgurí ŋuko ŋandiro: unipareto mande iŋoro ŋuro niŋgu-niŋgu teyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Quko hurí noko quroko uyote ŋunde kini. Asa ko quhurí korowoyoteŋgope ma unindo ŋu mande ŋuro o piyimi te yunoyoteŋgo quno ŋuno waka ta rotoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","O yuwoyó kakari keweroko umbuŋgurí ŋuko ŋandiro: unipareto mande ŋu iŋoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Quko naru kano noko koro o quro iŋaŋawí teyote, ko mone parámi siyowero ŋuro murí koya o meyowo siyowero murí ŋuko kanáŋoyote. O enesó ŋundo Anutu koro mande ŋu weheŋoní eŋgé moré kini. ");
INSERT INTO nca_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","O yuwoyó noko meté muno umbuŋgurí ŋuko ŋandiro: unipareto mande iŋoro kondé towoyoteŋgo, ko kumi eŋgé 30 tero, kumi eŋgé 60 tero, kumi eŋgé 100 ŋunde teyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ŋunde yero Yesuko iŋo-iŋo rewero uniyó ŋande osese yereró, “Unindo hiyó rero kondó kusuŋoyómo tapuŋowaŋgope ma ya kusuŋoyómo rewaŋgo, peka? Kini, ya quroko pikowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Dokoro o tapuŋowí ŋu soso tunomo reweya. Ko o pokamowí ŋu soso wisiyoweya. ");
INSERT INTO nca_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ye soso iŋo-iŋoye moré tiníqo, mande ŋa iŋi.” ");
INSERT INTO nca_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ŋunde yero ŋande yaró, “Ye kondé iŋoya howi qembe. Ye date unipare o te yunoyoteŋgo ŋuro rokóŋo ŋuwore naŋge Anutuko meté te yunoweya. Te yunoro kaŋuya saŋanímo te yunoweya. ");
INSERT INTO nca_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Uni ka o kumi towote tiníqo, Anutuko o kumi kaŋuya saŋanímo rero inoweya. Ko uni oyó moré kini ŋuko, Anutuko o tomó ta qu towoyote ŋu siyoní kini teweya.” ");
INSERT INTO nca_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kowe ŋande yaró, “Asa, Anutuko unipareyó wiri yereyote naruyó ŋuko ŋandiro naŋge. Uni kato wit musiyó nokono rimiró. ");
INSERT INTO nca_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Suwonope ma kosano uni ŋu eteyonímbe ma otoqoyoní, o yuwoyó ŋu woteyara. Quko uni ŋundo o yuwoyó woteyara ŋuro murí kama iŋaró. ");
INSERT INTO nca_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nokopo naŋge tiní toŋí raŋoroqota wotero, yate suwómo ŋuno taŋgurí raró. ");
INSERT INTO nca_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Asa naru kini tiníqo, taŋgurí mando tiní waka ta uni ŋundo eŋgé toŋo siyaró.” ");
INSERT INTO nca_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kowe ŋande yaró, “Anutuko unipareyó wiri yereyote naruyó ŋuro date yewe? Ŋuro do tapara mande ka yewe? ");
INSERT INTO nca_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Asa ŋuko mastet koro musiyó ŋunde qembe. Musiyó ŋuko tomó ta horé, musiyó kumi nokono rimiwero qu ŋu taka yereyote. ");
INSERT INTO nca_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Quko mastet rimiyiqo, kunzi qembe parámi wotero kambiní parámi reweya. Ŋundiro riní nú meté yoŋoyómo paseye rewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Asa Yesuko unipare meté iŋi tondaŋewero quro wimbuye qene rondaŋero tapara mande ŋunde qu naŋge rondaqe yunoyara. ");
INSERT INTO nca_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tapara mande naŋge yimitoyaró. Yimironí unipare toŋiqo, tapara mande ŋuro murí ŋu iŋo-iŋo rewero uniyó naŋge yunoyaró. ");
INSERT INTO nca_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Asa ŋu naruko ŋuno mande yeyate suwo tiníqo, Yesuko iŋo-iŋo rewero uniyó ŋande yimiraró, “Nore sono towo karóŋoro andusina uyato.” ");
INSERT INTO nca_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ŋunde yiní Yesu rero unipare qambu yorotoro waŋgowore uyareŋgurí. Uyariqo, uni kumimbo waŋgo kumiwore eneya uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Uyari yate-yate matú parámi horé arero sono howiní sono waŋgo quroko uro rambaruru yerewero taró. ");
INSERT INTO nca_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesuko waŋgo koro kundósina kemba tutu saŋano eteyaró. Asa okokoworo ŋande yaŋgurí, “Awa, matú ŋando rowore nerewero tete. Noreŋo date iŋote?” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ŋunde yiqo, Yesuko otoqoro matú ŋuya sono ŋuya ŋande qene yaró, “Roto, imaqiri!” yiní matú kini tiní sono towo ŋuya imaqaró. ");
INSERT INTO nca_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Imaqiní ŋande osese yereró, “Dokoro sasaro teteŋgo? Ye neneŋo wimbunemboro watí kama iŋoteŋgo ŋu!” ");
INSERT INTO nca_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Yiní sasaro parámi tero epe mito-mito taŋgurí, “Ŋu dani? Enendo yiníqo, matú koya sono towo koya mandí howero imaqetiri!” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Asa Yesu koya uniyómboya uyareyate Galili Sono Towo tapémo mira ka owí Gerasa ŋuno uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Uyaro waŋgo rotoro mahiqo, uni ka yuqa pusú quroko yaró ŋundo uni tapu yendé moŋgo eneno maheró. ");
INSERT INTO nca_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Uni ŋu uni tapu yendémo ŋuno yotoro o saŋgirí teyara. Teyoní ya yendé unindo utó kondéwore kusiyowero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Naru rokóŋo khe kandí kondé kusiyoyiqo, utó ŋu romboŋeyara. Ŋunde ŋuro yendé unindo uni ŋu ri imaqewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Naru rokóŋo, kosa suwo uni tapu yendémo ŋuno yotoro mira purí suruŋono neko kiwero eneŋombo wondo siyoro kowí uroní piyo teyara. ");
INSERT INTO nca_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Asa Yesu kapiya moŋgo qenero kheŋgeŋo mahero potoruku taró. ");
INSERT INTO nca_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Tiní Yesuko ŋande yaró, “Yuqa pusú, ke uni ŋa roto toŋe!” yaró. Ŋunde yiní mande parámi ŋande yaró, “Yesu, Anutu Koreko Horé yote ŋuro Naŋuní, ke do nereweya? Ke Anutu owímo mande ŋande kondé yeka, keto kama rambaruru nereweya!” yaró. ");
INSERT INTO nca_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yiní ŋande miraró, “Owéŋge neko.” Yiní mande topé ŋande yaró, “No owéne Lekiyon, dokoro nore qambu quroko ŋano yoteto,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Yero osese kondé taró, “Ke nore mira ŋa noŋgo ma nore raŋowero,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ŋu naruko ŋuno purí kutaqemo saŋano po qambu o neyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Asa yuqa piyimi ŋundo ŋande oseseyaŋgurí, “Asá nereka nore po quroyemo uwato,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ŋunde yiqo, Yesuko “Meté,” yiní yuqa pusú ŋu uni rotoro po quroyemo uŋgurí. Uyiqo, po 2,000 ŋunde qundo purí titiní moŋgo kheŋgeŋoro Sono Towo quroko uro khumaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Khumoyiqo, po sopo-sopo unindo qenero sore toŋero unipare yendé parámimo ŋuya mira soso ŋuno yimiroyi qenewero maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mahero Yesuko mahi uni yuqa piyimi qambu komo quroko yoraŋgo qu ŋundo tuwi kowí punuworo iŋo-iŋoyó hiyóqiní kunditeyaró. Kunditeyoní unipare qene sasaro parámi taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Pitu ko po sopo-sopoko o soso tunoqaró ŋuro yimiraŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Yimiroyi iŋoro Yesu kondé miraŋgurí, ko miraye ŋu rotoro meyowomo toŋeweya, yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ŋunde miroyi Yesuko waŋgo tomó ta quno uníqo, uni yuqa piyimi komo quroko yoraŋgo ŋundo Yesu koya toŋewero koro kondé oseseyaró. ");
INSERT INTO nca_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yiní mande topé ŋande yaró, “Kini, keto yano uya suwisawike yiyoro Uni Parámimbo o soso te kunoro sikíŋge te kunote ŋuro yimito qembe.” ");
INSERT INTO nca_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ŋunde yiníqo, uni ŋu roto toŋero Dekapolis mirako ŋuno Yesuko o soso te inaró ŋuro unipare yesoworo yimironí iŋondata parámi taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesuko mira ŋu rotoro pitu ko waŋgowore Sono Towo saŋawore uyaró. Andusina tapémo uyaro waŋgo rotoro nokono ariní unipare qambu parámi eneno kopaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kopoyi uni ka, owí muko Jairus, Juda koro huru-huru ya sopoyara qundo mahero Yesu qenero khímo rokaraŋo umburo ");
INSERT INTO nca_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","newondí surumímboro ŋande yaró, “Nambone khumowero tete. Keto ŋuno uyareya kandekepo reka meté yoní,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yiní uyaririyó. Uyariri unipare qambu mahero kutaqe-kutaqe wuriri yereŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ŋuno se khumo pare parámi ka yaró. Pare ŋu kumima naru 12 ŋunde rotoro naru rokóŋo kombo khumo tero sitú raŋoyara. ");
INSERT INTO nca_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dota qambu ŋunde osese yerero marasin qambu reyara. Quko se khumoyó ŋu kama kini tero parámi taró. Kowe marasin kimowero quro situwiyó soso kini taró. ");
INSERT INTO nca_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Asa Yesu koro iŋoro mahero ŋande ye iŋaró, “Tuwiyó pekáŋoweka pitu ko meté tewano.” Ŋunde yero iŋoro unipare qambu quwore huwósina mahero tuwiyó piru ŋu pekáŋaró. ");
INSERT INTO nca_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pekáŋoní ŋu naruko naŋge se khumo piyimi ŋu kini tiní kowí meté tiní, “Esone, meté teteno,” ye iŋaró. ");
INSERT INTO nca_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ŋu naruko naŋge Yesuko yero iŋaró, “Wimbu ka norotote,” ye iŋoro rohoréŋoro unipare ŋande osese yereró, “Danimbo tuwine pekáŋote?” yero yaró. ");
INSERT INTO nca_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ŋunde yiní iŋo-iŋo rewero uniyómbo mande topé ŋande yaŋgurí, “Do ka yete? Qeno, unipareto kutaqe-kutaqe koporo qambu horé peká kereteŋgo,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Quko “Danimbo peká nerete?” ye iŋoro toŋete yiyoro wuririyaró. ");
INSERT INTO nca_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Asa pare ŋu meté tero iŋoro sasaro tero yukuworo khímo umbu raŋoro mande hamó soso ŋu ye miraró. ");
INSERT INTO nca_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Mironí ŋande yaró, “Nambone, keŋo iŋondutukepo koriní meté tete. Imemoŋgo toŋeka se khumo ŋu kini temukoweya,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ŋunde yeyoníqo, uni kato mahero sopo-sopo uni ŋu ŋande miraró, “Namboke khuma. Rondaqe-rondaqe uni ŋu rotoka quhurí watí ma inowero.” ");
INSERT INTO nca_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ŋunde yi Yesuko iŋoro Jairus ŋande miraró, “Ma sorewero, iŋondutu hamó qu naŋge te,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yeroqo unipare soso howewero quro soré yerero Jairus, Pita, Jems, koneyó Jon yorero ");
INSERT INTO nca_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","sopo-sopo unindoro yano uyareŋgurí. Ŋuno unipare qambu tendo mukuru taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ŋunde tiqo, yano oro ŋande yimiraró, “Dokoro ŋandiro tendoyoteŋgo? Simó ŋu kama khuma. Eteyote,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ŋunde yiní iŋoro yomaŋgurí. Yomoyi Yesuko ya noŋgo yohowero pare khumaró ŋuro iwí-nimímboya uni Yesu koya uyareŋgurí ŋuya yorero yakutímo oŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ŋuno oro pare khumaró ŋu kandí toworo ŋande miraró, “Talita kum,” yaró. (Mande ŋu murí muko ŋandiro: “Pare ta otoqo, yeteno.”) ");
INSERT INTO nca_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ŋunde yiní waka ta pare ŋu otoqoro uyare mahe taró. Dokoro pare ŋu tomó ta horé kini, ene kumima naruyó khe saŋiyoro irisa ŋunde qundo taró. Asa unipare soso ŋuno iŋondutuye enesó-enesó taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Quko Yesuko mande kondé ka ŋande yimiraró, “Ŋaro ma yewero.” Ŋunde yero ŋande yaró, “O inorika niní,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Asa Yesu koya iŋo-iŋo rewero uniyómboya ŋu noŋgo toŋero eneŋo yendémo uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sapat naruko ŋuno huru-huru yano oro mande rondaqe yunaró. Ŋuno huru-huru yano oro mande rondaqe yunaró. Yunoní kondé yukuworo ŋande yaŋgurí, “Ŋu date tero iŋote? Dani kato iŋo-iŋo ŋu inaró? O wimbí moré ŋu date teyote?” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ŋunde yero ŋande yaŋgurí, “Uni ŋuko kewá koro o murí-murí ŋu towoyara naŋge. Ŋuko Maria naŋuní, ko Jems, Joses, Jutas, Saimon koro paye, ko siwo-kuwí ŋano yoteŋgo, hamómbe?” Ŋundiro yero owí ri umbuní eneŋo piyimiŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ŋunde yiqo, Yesu mande topé ŋande yaró, “Yendé soso quno ŋuno unipareto ye-ye uni ka ará te inoyoteŋgo. Quko eneŋo mirayómo, yayó horémoko ará kama te inoyoteŋgo,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ŋunde ŋuro Yesuko mira ŋuno o wimbí moré ka tewero mepémo kini. O tomó ta-ta naŋge taró. Asa, se khumo uni kumi saŋayemo kandí riní meté taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kowe uniparetoro iŋondutuye piyimi ŋuro iŋondata parámi taró. Asa imemoŋgo yate yendé kumi kutaqewore ŋuno uyaro mande rondaqe yunoyaró. ");
INSERT INTO nca_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ŋu naruko ŋuno iŋo-iŋo rewero uniyó 12 ŋu neko yerero irisa-irisa yorero asá yereró. Ŋunde tero yuqa pusú yohowewero quro wimbu kondé yunaró. ");
INSERT INTO nca_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Asá yerero mande kondé ŋande yimiraró, “Ye uyari qembe, quko yeŋo o qoyemboro, puŋgeye, wondo musiyó kumi ma siyowero. Usú ka, khe punu-punu ko kowe punu-punu kanata ŋunde naŋge siyoyi qembe. ");
INSERT INTO nca_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yendé kano oro koretero ya kano owaŋgo tiníqo, ya ŋuno naŋge eteyuri qembe. ");
INSERT INTO nca_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ko yendé kano unipareto mandeye iŋoro niŋgu-niŋgu kama tiqo, yorotoro yendé sumeyoro ŋuno noko murutómi kheyemo ŋu siyoyi umbuweya. Rokó ŋunde tiqo, unipare ŋundo ŋande qene iŋowaŋgo, ‘Anutuko noreya saŋgirí tete,’ ye iŋowaŋgo,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yiní toŋero yendé kano-kano mande ŋande yesowo yimiraŋgurí, “Ye quhuríyemboro newonde surumí teya quhurí ŋu se roti.” ");
INSERT INTO nca_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ŋunde yimitoro yuqa piyimi qambu uni quro koŋgo yohowi toŋi, kiruwó sonoyó se khumo uni qambu kembayemo hausuwoyi meté taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Asa ŋu naruko ŋuno wiri yerete uni ka, owí muko Herot, ŋundo Yesu koro piŋayó iŋaró. Uni kumimbo Yesu ŋuro ŋande miraŋgurí, “Jon, sono re-re uni ŋundo uni tapu koŋgo pitu ko otoqaró. Ŋu murí ŋuro wimbu ka enewore kho teyote,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kumimbo ŋande miraŋgurí, “Uni ŋuko Elaija naŋge,” yaŋgurí. Ko kumimbo ŋande miraŋgurí, “Uni ŋuko ye-ye uni komo yoraŋgo ŋunde qembe,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herotko mande soso ŋu iŋoro ŋande rondaŋaró, “Uni ŋuko Jon naŋge, uni urowe khumaró qu ŋundo pitu ko yote,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Ŋunde yaró, dokoro komo Herot koya Herotias koya epe re-re tariyó. Quko Herotias ŋuko Herot koro payó Filip ŋuro parí. Ŋunde ŋuroko Jonko Herot ŋande mito yaró, “Keto pare ŋu raró ŋundo hutuŋo mande wendaqeyote.” Ŋunde mironí uni parámi ŋundo Jon rero kusi-kusi yano rotaró. ");
INSERT INTO nca_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Asa pare ŋu, owí muko Herotias, Jon ŋuro saŋgirí taró, quko urowero kheyó moré kini. ");
INSERT INTO nca_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Dokoro kamímbo Jon ŋuro sasaro tero ŋande ye iŋaró, ko uni ŋuko uni roneneŋowí, uni meté horé qu ka. Ŋunde ye iŋoro Jon soporo naru rokóŋoro mandí iŋoro iŋondata teyara, quko iŋowero quro metéŋoyara. ");
INSERT INTO nca_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Yate-yate Herotiasko Jon urowero naruyó sopoyara. Sopoyoní naru kano Herotko naru nimímbo pisiyaró ŋuro o ne-ne taró. O ne-ne naruko ŋuno Herot koro kho uni pará-parámboya kuma unindoro uni kembémboya Galili koro uni pará-parámboya maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Soso mahero o niqo, Herotias nambuní ŋuno uyaro qunoraró. Qunoroní Herot koya topé-topémboya qenero niŋgu-niŋgu parámi tero ŋande miraró, “Quno ŋuro kimoyómbe tomó tape kunowanope ma parámimbe kunowano. Kimoyó date? ");
INSERT INTO nca_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mande kondé yeteno. Nondo mira parámi karo simburí. Keto kira niriqo, mira rondaŋero topé kunowano,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ŋunde yiní pare keta ŋundo roto toŋero nimí ŋande oseseyaró, “Ná, qunoroteno ŋuro kimoyó date yewano?” Yiní mande topé ŋande yaró, “Meté ŋande kirayo. Jon, sono re-re uni ŋuro puŋí toŋoya kembé re mahe kunoní qeneweya kirayo,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Yiní rohoréŋoro kheŋgeŋo uyaro wiri yerete uni ŋande miraró, “Itaka naŋge Jon, sono re-re uni ŋuro puŋí toŋoya kembé kondómo re mahe nuno,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ŋunde yiní Herotko newonde surumí parámi taró, quko uni o kopo naŋgurí ŋuro toŋeyemo mande kondé kusiyoro rotowero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ŋunde ŋuro kuma uni ka ŋande miraró, “Uya Jon puŋí toŋoya kembé re mahe,” yiní kusi-kusi yano uro puŋí toŋoro ");
INSERT INTO nca_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","kembé kondómo re mahero pare keta ŋu inoní re uyare nimí inaró. ");
INSERT INTO nca_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kowe Jon koro iŋo-iŋo rewero uniyó ŋundo o tunoqaró ŋuro iŋoro mahero ukúŋo rero tapuŋaŋgurí. Sowo mande ŋunde naŋge. ");
INSERT INTO nca_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Asa asá yerewí uni ŋundo khoye ti kini tiní maheŋgurí. Mahero Yesu koya koporo o soso taŋgurí ko mande soso rondaqe yunaŋgurí ŋuro piŋayó miraŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ŋu naruko ŋuno unipare qambu naru rokóŋo uyare mahe wuriri yereŋgurí. Ŋunde tiqo, Yesu koya uni ŋuya o newero mepémo kini taŋgurí. Ŋunde ŋuroko uniyó ŋande yimiraró, “Noremata uyareya mira uni kinimo ŋuno imaqato,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ŋunde yero mira uni kinimo uyarewero waŋgowore toŋeŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Toŋiqo, unipare yendé kutaqemo qu yiyo iŋoro koporo khewore mira ŋuno kheŋgeŋo uyaro taka yereŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tukú Yesuko waŋgo rotoro mahero unipare qambu ŋu yiyaró. Yiyoro ŋande ye iŋaró, “Unipare ŋu sipsip qembe mu sopo-sopoye moré kini teteŋgo.” Ŋunde yero iŋoro sikíye te yunoro mande qambu rondaqe yunaró. ");
INSERT INTO nca_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Yate suwo tiníqo, iŋo-iŋo rewero uniyómbo Yesu ŋande miraŋgurí, “Nore mira uni kinimo yorato suwo tete. ");
INSERT INTO nca_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Unipare ŋa asá yereka meté yendéne-yendéne o qoyemboro kimowero toŋi.” ");
INSERT INTO nca_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ŋunde yiqo, ŋande yimiraró, “Yendo o qoyemboro yunoyi.” Yiní ŋande yaŋgurí, “Unipare qambu ŋu o qoyemboro kimoyó parámi naŋge, denarius 200 peka! Nore mepémo kini,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yi mande topé ŋande yaró, “Uya bret date yote ye qeni.” Yiní uro qenero rohoréŋoro ŋande miraŋgurí, “Bret kandeka ko sono qare irisa ŋunde yotiri,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ŋunde yiqo, ŋande yimiraró, “Unipare soso yika huru-huru enesó-enesó koporo komó saŋano kunditi,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Huru-huru ŋuko unipare kumi 100 ko kumi 50 ŋunde ronda yere yoroti kunditaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kunditiqo, Yesuko bret koya sono qare ŋu siyoro samboko toŋetero o qoyemboro ŋuro Anutu yuŋgunaŋaró. Ŋunde tero bret rondaqero, sono qare rondaqero, iŋo-iŋo rewero uniyó yunoní se unipare yunaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Se yunoyi ni qahuye tinditaró. ");
INSERT INTO nca_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ni kini tiní bret sombé-sombé ŋuya sono qare sombé-sombé ŋu se toŋgo kome puŋge tomó ta-ta khe saŋiyoro irisa ŋunde siriyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Asa ŋu naruko ŋuno uni 5,000 ŋundiro o naŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Asa waka ta Yesuko iŋo-iŋo rewero uniyó yimironí waŋgowore sono towo andusina Betisaita yendémo uyari unipare qambu ŋu “Ye toŋi,” yimiraró. ");
INSERT INTO nca_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ŋunde yimitoro yorotoro enemata purímo oro hariri teyaró. ");
INSERT INTO nca_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Teyoní suwo tiníqo, iŋo-iŋo rewero uniyó ŋundo waŋgowore sono towo karóŋoro keweroko naŋge yuri Yesu enemata nokono yaró. ");
INSERT INTO nca_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yate-yate suwo keweroko horé sono towoko matú parámi mahero waŋgo ŋu kikíŋoní tesaŋgapo sono kiriyoro uyarewero rukusuwaŋgurí. Saraŋowero teyoní Yesu sono towo saŋawore khete-khete maheró. Mahero, waŋgo takawero, ye iŋaró. ");
INSERT INTO nca_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Quko sono saŋano khetiníqo, qenero ŋande ye iŋaŋgurí, “Ŋu kapo ka,” ye iŋoro kiweyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Dokoro uni soso ŋundo qenero sasaro parámi taŋgurí. Quko waka ta enendo neko yerero ŋande yaró, “Newondeye kondé yoní. Ma sorewero. Ŋako no.” ");
INSERT INTO nca_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ŋunde yero waŋgo saŋano oní, matú parámi ŋu imaqaró. Imaqiní newondeye uraró. ");
INSERT INTO nca_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Dokoro, komo enendo unipare qambu o qoyemboro yunaró ŋuro murí kama iŋoyi tondaŋiní newondeye kusiyaró. ");
INSERT INTO nca_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Asa Galili Sono Towo ŋu karóŋoro tapémo, mira Genesaret ŋuno, waŋgo kusiyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Uyaro waŋgo rotoro mahi unipareto Yesu qene iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ŋunde tero mira soso ŋuno kheŋgeŋo uyare maheŋgurí. Yesu yendé kano yote, yi iŋoroqo se khumo uni pitikiwore yore koro yerero ŋuno uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Asa Yesuko yendéne-yendéne uyaró quno ŋuno topoyembo se khumo uni ŋu yorero yendémo ŋuno yorotaŋgurí. Yoroti Yesu mahiní ŋande kirayaŋgurí, “Meté tuwike toworo meté tewano,” yaŋgurí. Ko towaŋgurí muko meté taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Naru kano Farisi unindoya hutuŋo mande ŋuro iŋo-iŋo uni kumimboya Yerusalem yendé rotoro Yesuko uŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Uro Yesu koro iŋo-iŋo rewero uniyó yiyoyi kandeye Anutu toŋímo pusú tiní o qoyemboro neyaŋgurí. (Ŋuro murí muko ŋandiro, kandeye kama sonoworo neyaŋgurí.) ");
INSERT INTO nca_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Qeni, Farisi unindoya Juda unipare soso ŋuya usisambapukoyemboro hutuŋo mandeye howero sono tomó tapo kandeyemo kama kuriyoroqo o kama neyaŋgo. ");
INSERT INTO nca_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ko o newero qu maketino kimoro kama sonoworoqo kama neyaŋgurí. Hutuŋo mande qambu ŋunde qu howero kusí, kondó ko yakutí etewero qu ŋuya soso sonowoyaŋgo. ");
INSERT INTO nca_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Asa Farisi unindoya hutuŋo mande ŋuro iŋo-iŋo unindoya Yesu ŋande oseseyaŋgurí, “Do karo keŋo iŋo-iŋo rewero unikepo kandeye Anutu toŋímo pusú tiní bret kinaŋge neyoteŋgo? Ŋunde tero usisambananimboro hutuŋo mandeye ŋu wendaqeyoteŋgo,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ŋunde yiqo, ŋande yimiraró, “Komo suki Aisaiako ye maŋgoye irisa ŋuro hamó ye-ye mande ka ŋande nakayáŋaró, “‘Unipare ŋako maŋgoyembo ará te nunoyoteŋgo, quko newondeye muko piyimi horé teyote. ");
INSERT INTO nca_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Enendo unindoro hutuŋo mandeye naŋge rondaqe yunoro potoruku kota qu re nunoyoteŋgo.’ ");
INSERT INTO nca_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ŋunde nakayáŋoní asa yendo Anutu koro mande kondé ŋu rotoro unindoro hutuŋo mande qu howeyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Ye Anutu koro mande kondé ŋu rotoro yeŋo muríye howeyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Dokoro Mosesko ŋande yaró, ‘Awa-náŋgeporo ará te yuno qembe,’ ko, ‘Uni kato iwí-nimí yesará yereweya ŋu urika khumoní,’ yaró. ");
INSERT INTO nca_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Quko yendo ŋande yeyoteŋgo, ko uni kato ŋande yeweya, ‘Awa-náme, no samaka yerewano, quko komo o yunowano quro “Koripan” yanowó. Asa ko no yunowero mepémo kini.’ (Asa “Koripan” ŋuro murí muko ŋandiro, “Anutu inowano naŋge.”) ");
INSERT INTO nca_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ŋunde yeweya tiníqo, yendo uni ŋu iwí-nimí samaka yerewero soréŋoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ye Anutu koro mande ŋu rotoro yeŋo hutuŋo mande qu howeyoteŋgo. Ko o qambu ŋunde qu ŋuya teyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesuko ŋunde yero unipare qambu ŋu neko yerero ŋande yimiraró, “Ye soso iŋika tondaŋiní. ");
INSERT INTO nca_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Oka kato uni quroko uyote qundo uni ŋu riní Anutu toŋímo pusú tewero mepémo kini. Kini. Oka newondí quro koŋgo areyote ŋundo ta Anutu toŋímo uni ŋu riní pusú teyote.” ");
INSERT INTO nca_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(-) ");
INSERT INTO nca_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ŋunde yero unipare qambu yorotoro yano oro iŋo-iŋo rewero uniyómbo mande ŋuro murímboro oseseyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yiqo, ŋande osese yereró, “Do ka? Ye ŋuya kama iŋoyi tondaŋeyote, peka? O soso uni quroko uyote ŋundo Anutu toŋímo uni kama riní pusú teyote. ");
INSERT INTO nca_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Dokoro uni ka o niníqo, newondímo kama uyote. Kini. Qahímo naŋge uro, yate qosimbino uyote.” (Yesuko mande yaró ŋuwore o soso ŋuro, “O meté newero qu,” yaró.) ");
INSERT INTO nca_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Asa ŋunde yero ŋande yaró, “O piyimi uni newondeye moŋgo areyote ŋundo ta uni ŋu yoriní Anutu toŋímo pusú teyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Dokoro o piyimi ŋande qu newondeye moŋgo areyote: iŋo-iŋo piyimi, se simbururu tewero murí, momo tewero murí, uni yurowero murí, ");
INSERT INTO nca_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","meyowomboro parímboya etewero murí, wondo situwi rewero murí, o piyimi naŋge tewero murí, uni kaná yerewero murí, otete piyimi ŋuro kowi piyo kama tewero murí, unindoro onoŋoyó ŋuro piyimiŋowero murí, yesará yerewero murí, mira windu-windu tewero murí, kape-kape tewero murí. ");
INSERT INTO nca_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ŋundo ta uni newondeye quro koŋgo areyote ŋundoko uni ŋu yoriní Anutu toŋímo pusú teyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Asa Yesuko mira ŋu roto toŋero mira kutaqe ŋu, owí Tair, ŋuno uyaró. Uyaro sóqero imaqewe yero ya kano oró. Quko sóqewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Pare kato Yesu mahete yi iŋoro waka ta ŋuno uyaró. Pare ŋuko Grik pare ka, Ponisia mira ŋu noŋgo qu. Komo, yuqa pusú kato nambuní quroko uró. Ŋunde ŋuroko pare ŋundo mahero nokono potoruku re inoro ŋande kirayaró, “Metémbe yuqa piyimi nambonemo yote ŋu howi toŋeweya?” yaró. ");
INSERT INTO nca_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yiní Yesuko ŋande miraró, “Koretero simó o qoyemboro ni qahuye tinditeweya. Uni kato o qoyemboro ŋu supiyoro opiŋo simó yunoyote, ŋuko piyimi,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Yiní mande topé ŋande yaró, “Awa, simó ŋu o nero kimboŋero roti umbuní opiŋombo newaŋgo,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yiní ŋande yaró, “Keto mande meté yete. Ŋunde ŋuroko yuqa piyimi ŋu namboke moŋgo roto toŋete.” ");
INSERT INTO nca_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ŋunde yiní yano toŋero nambuní qeniní yuqa piyimi ŋu roto toŋiní imaqero etaró. ");
INSERT INTO nca_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Asa Tair mira roto toŋero Saiton mirawore uyaro Galili Sono Towo tapéwore uro Dekapolis mirako ŋuno uyaro. ");
INSERT INTO nca_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Uyariní unipareto uni ka kusumbí tuwo ko mande meté kama yeyara qu re Yesuko maheŋgurí. Mahero, “Uni ŋambe meté ri meté teweya?” yero kirayaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ŋunde yi Yesuko uni ŋu rero soŋga woso uyaro kandí pusirí re kusumbímo saŋgaworo, tute tero, uni ŋuro mipímo raró. ");
INSERT INTO nca_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Rero samboko toŋetero newonde surumí tero yuqa raŋoro ŋande yaró, “Epata.” (Mande ŋu, “Epata,” ŋuro murí muko ŋandiro, “Koso.”) ");
INSERT INTO nca_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Waka ta kusumbí hiyóqaró. Ko maŋgó taŋo tiní mande meté yaró. ");
INSERT INTO nca_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ŋunde tiní Yesuko mande kondé unipare ŋande yimiraró, “Ŋaro ma yewero,” yaró. Ŋunde watí yeyaró, quko wendaqero yendé kano-kano o ŋuro yesowo yimitoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ŋunde yimitoyuriqo, unipareto iŋoro kondé yukuwoní epe mito-mito taŋgurí, “Yesuko o soso meté teyote. Asa ŋundiro uni kusumboye tuwo mu yoriní kusumboye hiyóqeyote. Ko uni maŋgoye kakayiwí mu yoriní mande meté yeyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ŋu naruko ŋuno unipare qambu pitu ko Yesuko mahero kopaŋgurí. Quko o qoyemboro newero qu moré kini. Ŋunde ŋuroko Yesuko iŋo-iŋo rewero uniyó neko yerero ŋande yaró, ");
INSERT INTO nca_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“No unipare qambu ŋaro sikíye teteno. Enendo kosa naru kapusa noya ŋano yotoro o qoyemboro khumoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ko, ‘Yano toŋi,’ yero asá yerewano tiníqo, kheko wimbuye kini teweya, peka. Dokoro kumimboro yaye sewemo naŋge.” ");
INSERT INTO nca_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ŋunde yiní mande topé ŋande yaŋgurí, “Uni kato unipare qambu ŋande qu mira uni kinimo ŋandiro quno ŋuno date o qoyemboro yunoweya?” ");
INSERT INTO nca_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yiqo, ŋande osese yereró, “Yendo bret date towoteŋgo?” Yiní ŋande yaŋgurí, “Bret kande saŋiyoro irisa,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Asa Yesuko unipare yimironí nokono kunditaŋgurí. Kunditi bret kande saŋiyo irisa ŋu siyoro Anutu yuŋgunaŋoro romboŋero iŋo-iŋo rewero uniyó se yunoní se unipare yunaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ŋuya sono qare tomó ta-ta kumi siyoro Anutu yuŋgunaŋoní unipare se yunaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Se yunoyi ni qahuye tinditaró. Tinditiní sombé-sombé kumi yoní toŋgo kome puŋge parámi kande saŋiyoro irisa ŋunde siriyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Uni 4,000 ŋundiro o naŋgurí. Asa ni kini tiní asá yiriní toŋeŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Asá yerero eneya, iŋo-iŋo rewero uniyómboya waŋgo tomó ta quwore mira ka owí muko Dalamanuta ŋuno uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Uyari Farisi uni kumimbo mahero Yesu koya mandeto kuma tero towoŋowero quro ŋande yaŋgurí, “Sambo koro rokó ka teka nore qene iŋato, keko Anutu koro kho qu teyote.” ");
INSERT INTO nca_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ŋunde yiqo, newonde surumí tero yuqa raŋoro ŋande yimiraró, “Do karo unipare itaka nokono yoteŋgo qundo rokó qenewero ŋuro ye iŋoyoteŋgo? Ye hamó yimiroteno, rokó ka kama tewano.” ");
INSERT INTO nca_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ŋunde yimitoro toŋero waŋgo tomó ta quwore Sono Towo karóŋoro andusina uyarewero toŋeŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Waŋgowore toŋeŋgurí, quko uniyómbo bret koro kape tero kama siyaŋgurí. Kini, bret kanata naŋge raŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Asa Yesuko mande kondé ŋande yimiraró, “Qeni, Farisi koro yis ko Herot koro yis ŋuko rambaruru yereweya,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ŋunde yiní epe mito-mito tero ŋande yaŋgurí, “Nore bret kape tato ŋuro yete,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yiqo, iŋoro ŋande yimiraró, “Do murí karo bret koro kape taŋgo ŋuro epe mito-mito teyoteŋgo? Yembe watí kama iŋoyi tondaŋete? Iŋo-iŋoye muko kama hiyóqete? ");
INSERT INTO nca_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Toŋeyembope kama qeneyoteŋgo? Ko kusumboyembope kama iŋoyoteŋgo? O soso kape teyoteŋgo, peka? ");
INSERT INTO nca_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Qeni, komo nondo bret kandeka romboŋero uni 5,000 yunowe ni bret sombé-sombé kumi yoní siriyoyi, toŋgo kome puŋge datiro maŋgoraró?” Yiní mande topé ŋande yaŋgurí, “12 ŋunde maŋgoraró.” ");
INSERT INTO nca_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yi ŋande osese yereró, “Kowe bret kande saŋiyoro irisa rondaqe uni 4,000 yunowe ni bret sombé-sombé kumi yoní siriyoyi, toŋgo kome puŋge parámi datiro maŋgoraró?” Yiní mande topé ŋande yaŋgurí, “Kande saŋiyoro irisa maŋgoraró.” ");
INSERT INTO nca_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yi ŋande osese yereró, “Iŋi tondaŋetepe ma kini?” yaró. ");
INSERT INTO nca_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Asa Yesu koya iŋo-iŋo rewero uniyómboya uyareyate Betisaita yendémo ŋuno uyareŋgurí. Ŋuno unipareto, uni ka toŋí piyimi mu Yesuko roŋgaruwoweya, yero re maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesuko uni ŋu kandímo toworo re yendé tapémo uyaro toŋímo tute tero pekáŋoro ŋande oseseyaró, “Do ka qenete?” ");
INSERT INTO nca_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ŋunde yiníqo, toŋetero ŋande yaró, “Nondo uni kumi yiyoro te qembe tero uyare mahe teyoteŋgo ŋu yiyoteno,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yiní naru kaŋuya Yesuko toŋí pekáŋoní meté toŋetero toŋí soso hiyóqaró. ");
INSERT INTO nca_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Hiyóqiní mande kondé ŋande miraró, “Yano oyo yendémo ma umbuwero,” ye soréŋaró. ");
INSERT INTO nca_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tukú Yesu koya iŋo-iŋo rewero uniyómboya Sisaria Filipai yendé sumeyoro yendé tomó-tomó ŋuno oŋgurí. Oro kheko ŋande osese yereró, “Unipareto, no dani, yero yeyoteŋgo?” ");
INSERT INTO nca_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Yiní ŋande yimiraŋgurí, “Kumimbo keko sono re-re uni ŋu, Jon, yeyoteŋgo. Kowe kumimboko, Elaija, yeyoteŋgo. Kowe kumimboko, ye-ye uni meyowo ka, yeyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ŋunde yiqo, ŋande osese yereró, “Ko yeŋomboko, nenemboro date yeyoteŋgo?” Ŋunde yiní Pitako mande topé ŋande yaró, “Keko Kristo ŋu,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yiníqo, ŋande yiyo yaró, “Uni ka neneŋo ma yimirowero,” yero soré yereró. ");
INSERT INTO nca_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Asa Yesuko hurí rero mande ka rondaqe yunoro ŋande yaró, “Unindoro Naŋuní kowe surumí parámi korowoní, uni kembé-kembémboya o qa-qa unindoro tapá unindoya hutuŋo mande ŋuro iŋo-iŋo unindo ene huwóŋoro uri khumoweya. Ko naru kapusayómo ŋuno pitu ko otoqoweya.” ");
INSERT INTO nca_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ŋunde yero Yesuko mandí tunomo yaró. Yiníqo, Pitako Yesu taŋgímo uyaro, “Ŋunde ma yewero,” ye qene yaró. ");
INSERT INTO nca_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yiní Yesuko rohoréŋoro iŋo-iŋo rewero uniyó yiyoro Pita ŋande qene yaró, “Monimbu, ke tupunesina uyare! Ketope khene kusiyowero yete. Keto Anutu iŋo-iŋoyó kama howete. Kini. Unindoro iŋo-iŋoye naŋge howete.” ");
INSERT INTO nca_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ŋunde yero unipare qambu ŋu neko yerero ŋande yimiraró, “Uni ka no nohoweweroqo, ene eneŋo re umburoqota, tipiririyó re koroworo no nohowiní. ");
INSERT INTO nca_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Dokoro dani kato eneŋo yoto-yotoyó kondé towowero ye iŋote qu, yoto-yotoyó ŋu piyo teweya. Quko dani kato no iŋo nunoro miti mande koro iŋoro yoto-yotoyó rotoweya tiníqo, ene yoto-yotoyó ŋu reweya. ");
INSERT INTO nca_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Asa qeni, ko uni ka noko koro o soso ŋu reweya, quko ene piyo tero kini teweya, asa o soso ŋundo date samakaŋoweya. ");
INSERT INTO nca_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Uni kato khumoro o ŋunde quwore yoto-yoto suki-suki meté kimo teweyape ma kini? ");
INSERT INTO nca_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Uni kato itaka ŋano, naru piyimi ŋano, nenemborope ma mandenemboro kowi piyo teweya quko, asa tukú Unindoro Naŋuní ŋundo iwímboro sine parámimo sambo simó surumí ŋuya mahewaŋgo quno ŋuno uni ŋunde qu kowi piyo teweya.” ");
INSERT INTO nca_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ŋunde yero ŋande yimiraró, “Mande hamó yeteno. Uni kumi ŋano kaŋeteŋgo qundo kama khumoyuri Anutuko unipareyó wiri yereyote naruyó ŋundo wimbu parámi tero maheweya ŋu qenewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tukú, naru kande saŋiyoro kanata ŋunde rotoro Yesuko Pita, Jems, Jon yorero enemata mira purímo oŋgurí. Toŋeyemo ŋuno Yesu kiraró enesó horé taró. ");
INSERT INTO nca_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tero tuwiyó tindeŋiwí tero sara-sara meté horé tunoqaró. Nokono ŋano uni kato tuwi riní sara ŋunde qu tunoqewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Asa Elaija koya Moses koya ŋuno tunoqiri yiyoyi Yesu koya mande taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ŋunde ti Pitako Yesu ŋande miraró, “Rapi, noya topo-toponemboya ŋano yoteto, ŋuko meté. Asa ko yamaru kapusa rewato: ka keŋo qu, ka Moses koro, ka Elaija koro.” ");
INSERT INTO nca_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ŋunde yaró, quko mandí murí ŋuro kama iŋoní tondaŋaró. Dokoro sasaro parámi taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Asa koporéko uni pará-pará ŋu poka yiriní koporé quro koŋgo mande ka ŋande yaró, “Ŋuko neneŋo naŋone, eneŋo surumí iŋoyoteno. Maŋgó howeyuri qembe.” ");
INSERT INTO nca_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ŋunde yiníqo, waka ta toŋetero uni pará-pará irisa ŋu kama yiyaŋgurí. Yesu naŋge ŋuno qeneŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Asa mira purí rotoro umbuyate Yesuko kondé ŋande yimiraró, “O qeneteŋgo ŋuro unipare ma yimirowero. Imemoŋgo Unindoro Naŋuní uni tapu koŋgo otoqoníqota meté yimiroyi qembe,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Imemoŋgo yate mandí kama wendaqaŋgurí. Quko epe mito-mito taŋgurí, “Ŋu ‘uni tapu koŋgo otoqoweya,’ ŋu do ka?” ");
INSERT INTO nca_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Asa umbuyate ŋande oseseyaŋgurí, “Do murí karo hutuŋo mande ŋuro iŋo-iŋo unindo ŋande yeyoteŋgo, ‘Koretero, Elaija ŋuko korete maheweya?’” ");
INSERT INTO nca_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yi ŋande yimiraró, “Hamó, koretero Elaija mahero o soso piyo taró mu roŋgaruwote. Quko ye date iŋoteŋgo, do murí karo Anutu koro mande ŋande yete, ko Unindoro Naŋuní o quhurí parámi riní unipare huwóŋowaŋgo? ");
INSERT INTO nca_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ŋunde quko ŋande yimiroteno, komo Elaija pitu ko maheró. Mahiní unindo eneŋo iŋo-iŋoye howero murí piyimi te inaŋgurí. O tunoqaró ŋuro uni kato Anutu koro sokome quno ŋuno nakayáŋaró.” ");
INSERT INTO nca_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Asa mira purí rotoro umbuyiqo, amuno ŋuno unipare qambu iŋo-iŋo rewero uni kumi wuriri yereŋgurí. Kowe hutuŋo mande ŋuro iŋo-iŋo unindoya iŋo-iŋo rewero uniyómboya kiro mande yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Asa unipare qambu ŋundo Yesu qeni newondeye yukuwoní kheŋgeŋoro, “Umbute ŋu,” yeyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ŋunde yi Yesuko hutuŋo mande ŋuro iŋo-iŋo uni ŋande osese yereró, “Do murí karo iŋo-iŋo rewero uninemboya mande parámi yeteŋgo?” yaró. ");
INSERT INTO nca_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yiní uni kato unipare qambu keweroye moŋgo mande topé ŋande yaró, “Rondaqe-rondaqe uni, nondo naŋone re mahero ke seqa kereteno. Yuqa piyimi ka naŋone quroko yoní mande yewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Naru rokóŋoro yuqa piyimi ŋundo naŋone kondé re uroní khe kandí yukuwoní siŋiworere ka umbuyote, mití kindotoyote, khe kandí soso tinditeyote. Nondo iŋo-iŋo rewero unike kira yerero, yuqa ŋu howi toŋeweya, yanowó. Quko enendo mepémo kini.” ");
INSERT INTO nca_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ŋunde yiní mande topé ŋande yaró, “Ye unipare itaka nokono yoteŋgo qundo iŋondutu kama reyoteŋgo! Naru date yeya yowano? Naru date quhuríye korowoyowano? Simó ŋu re nono mahi.” ");
INSERT INTO nca_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ŋunde yiní re mahiqo, yuqa piyimi ŋundo Yesu qenero waka ta simó uroní khe kandí yukuwoní nokono umburo keré-keré tero siŋiworere ka umburó. ");
INSERT INTO nca_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ŋunde tiní Yesuko iwí ŋande oseseyaró, “Naru datiro ŋunde teyote?” Yiní ŋande yaró, “Simó tomó ta quno teyate. ");
INSERT INTO nca_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Naru kumimo yuqa piyimi ŋundo rambaruruwowero quro re nombono raŋoyara ko sonono ŋuya raŋoyara. Quko ke wimbuke moré tiníqo, sikínani te nunoya nore samaka nere.” ");
INSERT INTO nca_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ŋunde yiní ŋande yaró, “Wimbune ŋuro yete. Asa uni kato iŋondutu kondé tiníqo, o meté soso tunoqeweya.” ");
INSERT INTO nca_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Asa simó ŋuro iwímbo kondé ŋande yaró, “Iŋondutu hamó teteno! Quko iŋondutune kondé kini, ime. Enina, samaka nere.” ");
INSERT INTO nca_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ŋunde yiní Yesuko unipare qambu kheŋgeŋo maheŋgurí ŋuro yiyo iŋoro yuqa pusú ŋu ŋande qene yaró, “Ke maŋgó piyimi kusumbí piyimi quro yuqa, ke ŋande kimiroteno, simó ŋa roto toŋeya naru kano ŋu quroko ŋuno ma uwero.” ");
INSERT INTO nca_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ŋunde yiníqo, simó ŋu kondé kiwero khe kandí yukuwoní yuqa piyimi ŋu roto toŋeró. Toŋiní umburo khumo inaró. Khumo inoní unipare qenero, “Khumote,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Quko Yesuko kandí toworo hokoní otoqo kaŋaró. ");
INSERT INTO nca_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tukú enemata yano oro iŋo-iŋo rewero uniyómbo Yesu ŋande oseseyaŋgurí, “Date koro norendo yuqa piyimi ŋu howewero mepémo kini?” ");
INSERT INTO nca_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yiqo, ŋande yaró, “Yendo hariripo naŋge yuqa ŋunde qu howewaŋgo,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Asa Yesuko ŋu noŋgo uro unipareto niyowaŋgo yero enemata Galili Sono Towo tapémo uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Dokoro mande ka iŋo-iŋo rewero uniyó rondaqe yunoro ŋande yeyaró, “Kumimbo Unindoro Naŋuní re saŋgirí uni kandeyemo rotowe teteŋgo. Enendo uroyi khumoweya, quko naru kapusa kini tiníqo, otoqoweya.” ");
INSERT INTO nca_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ŋunde yiníqo, mande ŋuro murí kama iŋoyi tondaŋaró. Ko murí ŋuro oseseyowero quro soraŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Uyareyate iŋo-iŋo rewero unindo dani keweroyemo kato imemoŋgo topé-topé taka yereweya ŋuro mandeto epe uto-uto taŋgurí. Asa Kaperneam yendémo ya kano oro Yesuko ŋande osese yereró, “Do murí karo kheko ŋuno mande kondé yero epe mito-mito taŋgo?” yaró. Quko mande topé kama yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Asa ko kunditero iŋo-iŋo rewero uni khe saŋiyoro irisa ŋu neko yerero ŋande yimiraró, “Uni kato owé parámi rewero quro iŋote tiníqo, koretero uni soso koro sunará simó teweya.” ");
INSERT INTO nca_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ŋunde yeroqo simó ta ka rero keweroyemo rero towo pisiyoro ŋande yimiraró, ");
INSERT INTO nca_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Uni kato neneŋo iŋoro simó ta ka ŋande quya topo teweya ŋuko noya topo teweya. Uni noya topo teweya ŋuko Awanembo asá nereró ŋuya topo teweya. Dokoro Anutuko no asá nereró.” ");
INSERT INTO nca_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Asa Jonko ŋande yaró, “Rondaqe-rondaqe uni, norendo uni ka owéŋgemo yuqa piyimi yohowiní toŋeŋgurí ŋu qenetowó. Uni ŋu noreŋo sowe-sowe qu kini. Ŋuroko yuqa piyimi ma yohowewero, yero soréŋatowó.” ");
INSERT INTO nca_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ŋunde yiníqo, Yesuko ŋande yaró, “Ma soréŋowero. Uni kato no owénemo o wimbí moré ŋundiro teroqo waka ta owéne kama re umbuweya. ");
INSERT INTO nca_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Dokoro uni noreya saŋgirí kama te nunoteŋgo ŋuko noreŋo toponani. ");
INSERT INTO nca_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Uni kato kiyoro, keko Kristo ŋuro uni ka, yero iŋoro sono kiŋo kunoweya quko, imemoŋgo Anutuko puriŋo ka uni ŋu inoweya. Ŋu hamó. ");
INSERT INTO nca_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Uni kato tomó ta qu ka no iŋondutu nereyote qu wosoní o piyimi teweya tiníqo, unindo simó wosote ŋu topé piyimi horé reweya. Meté koretero unindo wondo parámi ka eneŋo puŋímo kusiyoro re windi quroko raŋi khumoroqota o kama teweya. ");
INSERT INTO nca_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ko kandekepo kowosoní o piyimi teroqo kandeke toŋo raŋo qembe. Ke soŋga ta ŋundiro piyo tero samboko oweya, ŋuko meté. Koweke soso meté yotoro kandeke irisa-irisa yote quko kewá piyimimo ŋuno raŋoní uweya, ŋuko piyimi horé. ");
INSERT INTO nca_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(-) ");
INSERT INTO nca_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ko kheŋgepo kowosoní o piyimi teroqo kheŋge toŋo raŋo qembe. Ke soŋga ta ŋundiro piyo tero samboko oweya, ŋuko meté. Koweke soso meté yotoro kheŋge irisa-irisa yote quko kewá piyimimo ŋuno raŋoní uweya, ŋuko piyimi horé. ");
INSERT INTO nca_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(-) ");
INSERT INTO nca_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ko toŋeŋgepo kowosoní o piyimi teroqo toŋeŋge tumo raŋo qembe. Ke soŋga ta ŋundiro piyo tero Anutuko unipareyó wiri yereyote naruyómo oweya, ŋuko meté. Koweke soso meté yotoro toŋeŋge irisa-irisa yote quko kewá piyimimo ŋuno raŋoní uweya, ŋuko piyimi horé. ");
INSERT INTO nca_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ŋuno “‘naru suki-suki punipo unindoro koweye neyoteŋgo. Ko kewá ŋuno naru suki-suki qaro kama khumoyote.’ ");
INSERT INTO nca_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Pare kato nembo re o newero qu saŋano reyote. Ŋundiro naŋge Anutuko kewá re unipare soso saŋayemo reweya. ");
INSERT INTO nca_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Nembo ŋuko o meté mu. Quko nembo ŋuro nuŋgurí ŋu kini tiníqo, khoyó kini teweya. Ye soso nembo ŋundiro naŋge ti qembe. Newonde ime epe ino-ino ti qembe.” ");
INSERT INTO nca_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Asa Yesuko mira ŋu rotoro Jotan Sono andusina Judia mirako uyaró. Ŋunde tiní unipare qambu soso pitu ko eneno kopoyaŋgurí. Kopoyi eneŋo murí howero mande rondaqe yunoyaró. ");
INSERT INTO nca_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ŋu naruko ŋuno Farisi uni kumimbo mahero Yesu towoŋowero ŋande oseseyaŋgurí, “Uni kato parí meté rotoweya ŋuko hutuŋo mande wendaqeweyape ma kini?” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ŋunde yi ŋande osese yereró, “Mosesko sokomeko ŋuno osese ŋuro date nakayáŋaró?” yaró. ");
INSERT INTO nca_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yiní ŋande yaŋgurí, “Mosesko ŋande nakayáŋaró, ko unindo sokome ka epe re-re toŋowero qu nakayáŋoro pare inoro howi toŋeweya,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yiqo, Yesuko ŋande yimiraró, “Yendo newondeye kusiyoyoteŋgo. Ŋunde ŋuroko mande kondé ŋunde qu nakayáŋaró. ");
INSERT INTO nca_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Komo suki Anutuko o soso towaró quno enendo ‘urumuni kaya, pare kaya yondowaró.’ ");
INSERT INTO nca_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Ŋunde ŋuroko uni iwí-nimí yorotoro parímboya womowari, ");
INSERT INTO nca_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ko irisa ŋundo kowe kanata tewari.’ Asa Anutuko mande ŋunde yiní kowe irisa kama yorari. Kini. Irisa ŋu kowe kanata tariyó. ");
INSERT INTO nca_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ŋunde ŋuroko Anutuko o irisa siyoro kopo yiriníqo, ye ŋu ma usowowero.” ");
INSERT INTO nca_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tukú yano oro iŋo-iŋo rewero uni ŋundo mandímboro murí ŋuro oseseyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ŋunde yi ŋande yimiraró, “Uni kato eneŋo parí rotoro pare meyowo rete, ŋuko se simbururu tete. ");
INSERT INTO nca_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ko pare kato kamí rotoro uni meyowo reweya, ŋuko se simbururu teyoweya.” ");
INSERT INTO nca_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Asa unipareto simó ta-ta yorero Yesuko kandí kembayemo rewero quro eneno maheŋgurí. Quko iŋo-iŋo rewero uniyómbo yiyo yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ŋunde tiqo, Yesuko yiyoro saŋgirí tero ŋande yaró, “Ye simó ta-ta tomó ta-ta ŋu yorotika nono mahe, ma soré yerewero. Dokoro Anutuko unipareyó wiri yereyote naruyó ŋuko simó ŋunde quro na. ");
INSERT INTO nca_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nondo ye hamó yimiroteno, uni kato simó qembe tero Anutuko unipareyó wiri yereyote naruyó ŋuro kama metéŋoweya tiníqo, ŋundo naru ŋuro quroko ŋuno kama oweya.” ");
INSERT INTO nca_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ŋunde yeroqo simó ta-ta ŋu yondowo pisi yerero kandí kembayemo rero puriŋo re yunaró. ");
INSERT INTO nca_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Asa Yesu toŋewero tiníqo, uni kato waka ta kheŋgeŋo mahe potoruku re inoro ŋande oseseyaró, “Rondaqe-rondaqe uni meté, no date tero yoto-yoto suki-suki ŋu rewano?” ");
INSERT INTO nca_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yiní ŋande yaró, “Ke do karo, no meté, yero neko nerete? Anutu kanata ŋu naŋgeko meté. ");
INSERT INTO nca_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mande kondé enesó-enesó ŋu qene iŋomukote: uni ma yuri khumowero, se simbururu ma tewero, momo ma tewero, mande khono ŋuno kota mande ma yewero, uni ka kanáŋoro situwiyó ma rewero, awa-náŋge ará te yuno qembe.” ");
INSERT INTO nca_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Yiní ŋande yaró, “Rondaqe-rondaqe uni, nondo simó tomó ta quno hutuŋo mande soso ŋu howeyate itaka uni parámi teteno,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yiní kondé qenero newonde meté inoro ŋande yaró, “O kanata ka yote. Keŋo situwi soso soweyoya mone ŋu rondaŋe uni oye moré kini ŋu yuno. Ke ŋunde teroqo, o meté samboko reweya. Asa ŋunde teya ke mahe nohowe.” ");
INSERT INTO nca_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yiníqo, newonde surumí tero umu-kembé piyo tiní roto toŋeró, dokoro, ene onoŋoyó qambu taró. ");
INSERT INTO nca_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Asa toŋiní Yesuko iŋo-iŋo rewero uniyó yiyoro ŋande yimiraró, “Onoŋo unipare kato Anutuko unipareyó wiri yereyote naruyómo ŋuno owero ŋuko taŋo kini, quhurí.” ");
INSERT INTO nca_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ŋunde yiníqo, newondeye yukuwaró. Quko Yesuko pitu ko ŋande yimiraró, “Simóne iŋi, naruyómo ŋuno owero ŋuko taŋo kini, quhurí. ");
INSERT INTO nca_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamel kato tisi wituyówore uyarewero rukusuwoyote. Ŋu hamó. Quko onoŋo uni kato Anutuko unipareyó wiri yereyote naruyómo ŋuno owero quro parámi horé rukusuwoyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ŋunde yiníqo, kondé yukuworo epe mito-mito taŋgurí, “Ŋu hamó tiníqo, ŋu danimboko rambaruru takaweya?” ");
INSERT INTO nca_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yiqo, kondé toŋetero ŋande yaró, “Unindoko tewero mepémo kini. Quko Anutuko kama rukusuwoyote. Enendo o soso meté teweya.” ");
INSERT INTO nca_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ŋunde yiní Pitako ŋande yaró, “Qeno, norendo onani soso rotoro ke kohowatowó.” ");
INSERT INTO nca_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yiní ŋande yaró, “Nondo mande hamó yeteno. Uni kato no owéne iŋoro miti mande iŋoro yayó, kumuní, kuwí, iwí, nimí, simó, khoyó ŋu rotoweya quko ");
INSERT INTO nca_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","itaka naŋge o qambu ŋu siyoweya: ya, kumuní, kuwí, nimí, simó, khoyó siyoweya. Ŋuya unindo saŋgirí te inowaŋgo. Quko naru maheweya qunoko yoto-yoto suki-suki reweya. ");
INSERT INTO nca_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Quko uni qambu itaka korete yoteŋgo, ŋuko tukú tewaŋgo. Ko uni qambu itaka weŋa yoteŋgo, ŋuko koretewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Asa khewore Yerusalem yendémo oŋgurí. Oro Yesuko koretero oní iŋo-iŋo rewero uni newondeye yukuwaró, ko unipare yohowaŋgurí qu sasaro taŋgurí. Asa Yesuko iŋo-iŋo rewero uni 12 ŋu yorero o soso Yerusalem ŋuno tunoqeweya ŋuro naru kaŋuya yimiraró. ");
INSERT INTO nca_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Yimitoro ŋande yaró, “Iŋoyi, itaka nore Yerusalem owé teteto. Ko unindo Unindoro Naŋuní ŋu rero o qa-qa unindoro tapá uni kandeyemo ko hutuŋo mande ŋuro iŋo-iŋo uni kandeyemo rotowaŋgo. Ŋunde riqo, topé piyimi rero, uratoka khumoní, ye iŋoro uni wini meyowomboro kandeyemo re rotowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Re rotoyi uni ŋundo rero huwó mande yero tuteworo utómbo haususuworo uri khumoweya. Uroyi khumoníqo, naru kapusa kini tiníqo, pitu ko otoqoweya.” ");
INSERT INTO nca_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Asa yerepasa ŋu, Jems koya Jon koya, Sepeti simó irisa ŋundo, mahero Yesu ŋande kirayariyó, “Rondaqe-rondaqe uni, o karo ke kira kerewe tetero, quko keto nore o meté te nuno qembe.” ");
INSERT INTO nca_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ŋunde yiri ŋande yaró, “Do ka te yunowero tewe kira neretiri?” ");
INSERT INTO nca_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Yiní mande topé ŋande yariyó, “Ŋako. Keto owé parámi rero uni parámi horé tunoqeweya quno metémbe nore irisa ŋuya uni parámi tunoqewaro. Asa keko korete qu, nore kato owé irisayó qu reweya ko kato owé kapusayó qu reweya.” ");
INSERT INTO nca_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yiri ŋande yaró, “Yariko kira ŋuro kama iŋori tondaŋete. Nondo o quhurí ka rewano ŋuko sono piyimi newano ŋunde qembe. O quhurí ŋu weyo nereweya. Yarimbeka o piyimi ŋu newaripe, quhurí kusuŋoyómo yowaripe?” ");
INSERT INTO nca_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Yiní mande topé ŋande yariyó, “Kini, nore irisa meté ŋundiro tewaro.” Yiri ŋande yaró, “Hamó, sono ŋu newari. Ko quhurí ŋundo weyo yereweya. ");
INSERT INTO nca_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Quko uni parámi tewari ŋuko nondo yunowero mepémo kini. Anutuko naŋge owé parámi irisa ŋu uni kumi yunoweya.” ");
INSERT INTO nca_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Asa iŋo-iŋo rewero uni kande irisa qundo yerepasa ŋu Yesu kirayariyó ŋuro iŋoro eneya saŋgirí taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ŋunde tiqo, Yesuko neko yiriní mahiqo, ŋande yaró, “Ye iŋoteŋgo, ko uni wini meyowomboro sopo-sopoyembo piyimi sopo yereyoteŋgo. Kowe uni parámiyembo eneŋombo owé parámi rewero quro iŋoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Quko ye ŋunde ma tewero. Kini, ye keweroye moŋgo uni kato uni parámi tewero ye iŋoyote tiníqo, sunará simó ŋunde teweya. ");
INSERT INTO nca_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ko uni kato owé parámi rewero ye iŋoyote tiníqo, uni soso koro kho simóye ŋunde yoweya. ");
INSERT INTO nca_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Dokoro Unindoro Naŋuní ŋundo unipareto eneŋo sunará tewero quro kama maheró. Kini, enendo uniparetoro sunará tewero maheró, ko yoto-yotoyó rotoro kimo yerewero quro maheró.” ");
INSERT INTO nca_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Asa Yesu koya iŋo-iŋo rewero unindoya uyareyate Jeriko yendémo ŋuno uyareŋgurí. Asa Jeriko rotoro Yerusalem oro unipare qambu ŋuya oyi uni ka toŋí kiré mu, owí Bar-Timeus, khe tapémo ŋuno kunditero wondo koro unipare kira yereyara. (Owé ŋu Bar-Timeus murí muko “Timeus naŋuní.”) ");
INSERT INTO nca_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kunditeyoní unipareto ŋande yaŋgurí, “Yesu, Nasaret noŋgo uni ŋu, mahete,” yi iŋoro kiwero ŋande watí-watí nekoyaró, “Yesu, Dewit koro naŋuní, sikíne te nuno,” yeyaró. ");
INSERT INTO nca_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Unipare kutaqe ŋundo qene yero ŋande yaŋgurí, “Ŋunde roto!” yaŋgurí. Quko kondé watí-watí nekoro ŋande yaró, “Dewit koro naŋuní, sikíne te nuno.” ");
INSERT INTO nca_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ŋunde watí-watí yeyoní Yesuko iŋoro kaŋero ŋande yimiraró, “Nekoyika mahiní.” Yiníqo, unipareto uni toŋí kiré ŋu ŋande miraŋgurí, “Newondeke kondé yoní, otoqo. Yesuko neko kerete.” ");
INSERT INTO nca_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ŋunde miroyi kowe punu-punu piru qu rotoro otoqoro waka ta maheró. ");
INSERT INTO nca_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Mahiní Yesuko ŋande oseseyaró, “Nondo do ka te kunowano?” Yiní mande topé ŋande yaró, “Raponi, toŋetero o qenewero ye iŋoteno,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesuko ŋande miraró, “Meté u. Keŋo iŋondutukepo koriní meté tete.” Yiníqo, waka ta toŋí hiyóqiní pitu ko toŋetero Yesu khewore howaró. ");
INSERT INTO nca_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Asa yate-yate Yesuko Yerusalem owero oró. Oro mira purí Oliv ŋuno, asa Betipake yendé ko Betani yendé kutaqemo ŋuno, iŋo-iŋo rewero uni irisa neko yerero ");
INSERT INTO nca_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ŋande yimiraró, “Yendé andusina ŋuno uyareya dóki simó ka kusiyaŋgurí qu qenewari. Komo uni kato dókiko ŋuno kama kunditaró. Asa utó orosoyero re mahiri. ");
INSERT INTO nca_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ŋunde tiri uni kato ŋuro osese yiriníqo, ŋande mirori qembe, ‘Uni Parámimbo ŋuya kho ka teweya. Ko imemoŋgo pitu ko re mahewaro.’” ");
INSERT INTO nca_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Yesuko ŋunde yiníqo, yendémo uyaro dóki simó ŋu ya kimbino mako sumeyoro kusiyaró mu qenero orosoyariyó. ");
INSERT INTO nca_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ŋunde tiriqo, uni ŋuno kaŋaŋgurí qundo ŋande osese yereŋgurí, “Do murí karo dóki simó ŋu orosoyitiri?” ");
INSERT INTO nca_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yiqo, iŋo-iŋo rewero uni irisa ŋundo Yesuko mande yimiraró ŋu yimirori kama soré yereŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Asa dóki simó ŋu Yesuko re mahero tuwi piruyari se dóki saŋano rero Yesu re ŋuno rotori kunditaró. ");
INSERT INTO nca_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Unipare kumi tuwi piruye ŋu wendaŋero se khewore ri, kumi te kambiní kome soso qu rondaqero khewore raŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ŋunde tero kumi koretero uyari, kumi tukú uyaro soso mande parámi ŋande yaŋgurí, “Anutu owí hokoyi!” “Uni Parámimboro owímo mahete ŋundo puriŋo riní!” ");
INSERT INTO nca_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Usinani Dewit ŋuro sowe qundo nore wiri nereweya. Anutuko naru ŋu puriŋo te inoyote!” “Anutu owí koreko horé hokoyi!” ");
INSERT INTO nca_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ŋundiro Yesuko Yerusalem oro Anutu koro Ya Surumímboro yendémo ŋuno oro o soso ŋuno toŋetero qeneró. Qeniní suwo tiníqo, roto toŋero iŋo-iŋo rewero uni khe saŋiyoro irisa ŋuya Betani uŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Asa ita saraŋoní, Betani rotoro arero o qímboro khumaró. ");
INSERT INTO nca_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Khumoro kewá fik ka komiri taró qu sewemo qenero, taŋgurí moré peka, yero uyaró. Quko kutaqe uyare qeniní taŋgurí ka ŋuno kama yora, komiri naŋge. Dokoro naru ŋuko taŋgurí rewero naruyó kini. ");
INSERT INTO nca_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Asa qenero kewá ŋu ŋande miraró, “Imemoŋgo uni kato ke taŋguríŋge kama neweya,” yiní iŋo-iŋo rewero uniyómbo iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Asa Yerusalem ŋuno oro Ya Surumímboro ŋuro hoŋgo quroko oro uni soso mone rewero kho teyaŋgo ŋuno qu yohowaró. Yohowero uni moneye rohoréŋoyaŋgo ŋuro wasa-wasaye koya uni nú soweyaŋgo ŋuro yakutíye soso se windoroŋaró. ");
INSERT INTO nca_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ŋuya uni kumimbo oka kina re koroworo Anutu koro Ya Surumímboro yendémo ŋuno uyarewero quro soré yereró. ");
INSERT INTO nca_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ŋunde tero unipare soso ŋande yimiraró, “Sokomeko ŋuno ŋande nakayáŋaró, ‘Neneŋo yane muko hariri koro ya qu.’ Quko yendo ri ‘kuma tero momo teyoteŋgo unindoro ya qu teyote.’” ");
INSERT INTO nca_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Unipare qambu ŋundo mandí iŋoro kondé yukuwaŋgurí. Ŋunde ŋuroko o qa-qa unindoro tapá unindoya hutuŋo mande ŋuro iŋo-iŋo unindoya sasaro tero uri khumowero khe qu seqayaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Asa suwo tiníqo, Yesu yendé roto toŋeró. ");
INSERT INTO nca_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ita saraŋoní Yerusalem khewore uyareyate kewá fik ŋu qeneŋgurí. Ko kewá ŋuko piyo tero asáqemukaró. ");
INSERT INTO nca_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Qenero Pitako ŋande miraró, “Rapi, keto kewá fik takuni saŋanímo suwono ya, ŋuko asáqete.” ");
INSERT INTO nca_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yiní mande topé ŋande yaró, “Ŋuro Anutu iŋondutuwoyi qembe. ");
INSERT INTO nca_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nondo hamó ye yimiroteno, uni kato mira purí ŋa, ‘Otoqo windi quroko u,’ ŋunde yeweya, quko newonde irisa kama tero iŋoní hamó tiníqo, ŋundiro tunoqeweya. ");
INSERT INTO nca_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ŋunde ŋuroko yendo, hariri tero oka rewato, yero iŋoro o ŋu rewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ko kaŋero hariri tewaŋgo quno ŋuno uni karo newonde saŋgirí ŋu rotoya eneŋo quhuríye roto yunoyi qembe. Ŋunde tiqo, awaye samboko yote ŋundo, yeŋo quhuríye ŋu se rotoweya.” ");
INSERT INTO nca_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(-) ");
INSERT INTO nca_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Asa Yesu Yerusalem oro Ya Surumímboro hoŋgo quroyómo kinaŋge uyaró. Uyariní o qa-qa unindoro tapá unindoya hutuŋo mande ŋuro iŋo-iŋo unindoya uni kembé-kembéyemboya kopo mahero ");
INSERT INTO nca_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ŋande oseseyaŋgurí, “Do owé ka moré o soso ŋa mepémo teyote? Danimbo owé ŋu re kunaró?” ");
INSERT INTO nca_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ŋunde yi ŋande yaró, “Nondo o karo osese yerewe teteno. Osese ŋuro mande topé yiqota do owé ka moré o soso ŋa mepémo teyoteno ŋuro yimirowano. ");
INSERT INTO nca_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jonko unipare sono re yunaró. Asa eneŋo kho qu tewero ŋuro owé ŋu, sambo koŋgo rarómbe ma uni noŋgo raró? Ye do ka yeteŋgo?” ");
INSERT INTO nca_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ŋunde yiní keweroyemo epe mito-mito ŋande taŋgurí, “Ko norendo, ‘Ŋuko sambo koro qu,’ yewato tiníqo, ŋande osese nereweya, ‘Asa ye date koro mandí iŋoro iŋondutu kama taŋgurí?’ yeweya. ");
INSERT INTO nca_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Quko, ‘Owí ŋu uni kato inaró,’ yewero mepémo kini,” yaŋgurí. (Unipare qambu ŋundo Jon ŋuro ŋande yaŋgo, “Uni ŋuko ye-ye uni hamó qu ka.” Ŋunde ŋuroko uni pará-parámbo Jon yesaráŋowero sasaro taŋgurí.) ");
INSERT INTO nca_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Asa ko mande topé ŋande yaŋgurí, “Nore kama iŋoteto.” Yiqo, ŋande yimiraró, “Asa ko no ŋuya da noŋgo owé ŋa rero o soso teyoteno ŋuro ye kama yimirowano.” ");
INSERT INTO nca_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Asa Yesuko tapara mande ka ŋande yimiraró, “Naru kano uni kato wain kho ka tero hoŋgo rero wuririyoro ŋu quroko ŋuno wain eŋgémboro sonoyó rewero quro meré parámi ka sero rotoro ya piru kho qene sopoyowero qu ka towaró. Ŋu soso toworo kho ŋu rero kho sopo-sopo uni kumi kandeyemo rotoro mira kapiyamo ŋuno toŋeró. ");
INSERT INTO nca_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Yate-yate kho simburí ŋundo eŋgé kumi siyowero quro sunará simó ka ŋuno asáŋoní uyareró. ");
INSERT INTO nca_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ŋuno uyariní sopo-sopo uni ŋundo haususuwo howi kina toŋeró. ");
INSERT INTO nca_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Imemoŋgo simburímbo sunará simó kaŋuya asáŋoní uyariní utoro kembé usoworo o piyimi horé te inaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ŋunde tero meyowo ŋuya asáŋoní uyariní kho sopo-sopo ŋundo simó ŋu haususuwoyi khumaró. Qambu asá yiriní uyariqota kumi uraŋgurí, kumi woŋga yuroyi khumaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Asa simburímboro naŋuní surumí iŋoyara qu yora. Iwímbo ŋande yaró, ‘Kho sopo-sopo ŋundo naŋone ŋu ará te inowaŋgo.’ Ŋunde yero naru weŋa quno naŋuní asáŋoní ŋuno uyareró. ");
INSERT INTO nca_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Quko kho sopo-sopo ŋundo simó ŋu qenero keweroyemo ŋande yaŋgurí, ‘Simó ŋundo iwímboro o soso ŋako imemoŋgo siyoweya. Uratoka khumoníka o ŋa soso norendo siyowato.’ ");
INSERT INTO nca_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ŋunde yero simó ŋu rero uroyi khumoní re hoŋgo sumeyoro raŋaŋgurí.” ");
INSERT INTO nca_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesuko ŋande osese yereró, “Iŋi, kho simburí ŋundo do ka teweya? Ŋandiro naŋge, ene uyaro sopo-sopo uni ŋu rambaruru yerero wain koro kho ŋu uni meyowo yunoweya. ");
INSERT INTO nca_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Yendo mande sokomeko ŋuno nakayáŋaró ŋu qeneŋgurímbe ma kini? Mande ŋuko ŋandiro: “‘Ya re-re unindo wondo ka rero piyimi, yero iŋoro re rotaŋgurí, quko itakako wondo ŋundo ya soso riní kondérewero wondo ka tunoqete. ");
INSERT INTO nca_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Uni Parámi eneŋombo o ŋu riní ŋunde tunoqiní qenero niŋgu-niŋgu parámi teteto.’” ");
INSERT INTO nca_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesuko ŋunde yiníqo, uni pará-parámbo iŋoro, enendo nore yesará nereyote, yero iŋomukaŋgurí. Ŋunde ŋuroko saŋgirí tero urowero khe ka seqaŋgurí. Quko unipare qambu ŋuro sasaro taŋgurí. Asa ko ene roto toŋeŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Asa uni pará-parámbo, Yesu mande piyimi yiní towowato, ye iŋoro Farisi kumimboya Herot koro topé kumimboya asá yiri maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Mahero ŋande oseseyaŋgurí, “Rondaqe-rondaqe uni, nore ŋande iŋoyoteto, ko keto uni karo owé morémbe ma kini ŋuro kama iŋoyote. Kini, Anutu koro kheyó hamó moŋgo naŋge rondaqe yunoyote. Ŋunde ŋuroko yeka iŋowato. Norendo Sisa takis re inowato ŋuko hutuŋo mande wendaqeyotepe ma kini?” ");
INSERT INTO nca_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ŋunde yiqo, Yesuko eneŋo maŋgoye irisawore yewero murí ŋu qene iŋoro mande topé ŋande yaró, “Ye date towo nereteŋgo? Denarius ka re mahika qenewe.” ");
INSERT INTO nca_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ŋunde yiníqo, ŋu re mahi ŋande osese yereró, “Wondo musiyó ŋano kapo-kapo ŋaya owí ŋako daniro qu?” Yiníqo, “Sisa koro qu,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ko Yesuko ŋande yimiraró, “O kumi Sisa koro qu, ŋu Sisa se inoyi qembe. Ko o kumi Anutu koro qu, ŋu Anutu se inoyi qembe.” Ŋunde yiníqo, iŋoro ene newondeye yukuwaró. ");
INSERT INTO nca_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Asa Sadyusi uni kumi maheŋgurí. Uni ŋundo ŋande yeyaŋgurí, ko unipare khumaŋgurí qundo pitu ko kama otoqowaŋgo. Asa mahero Yesu ŋande oseseyaŋgurí, ");
INSERT INTO nca_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Rondaqe-rondaqe uni, komo Mosesko noreŋo mande ŋande nakayáŋaró, ‘Uni kato pare rero simó moré kini yate khumoníqo, eneŋo koneyómbo pare ŋu riní simó pisiyoníqota payómboro sowe qu tunoqiní.’ ");
INSERT INTO nca_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Asa iŋo. Naru kano uni kato naŋo-simó kande saŋiyoro irisa pisi yereró. Simó korete ŋundo pare rero, yate-yate simóyari moré kini tero khumaró. ");
INSERT INTO nca_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Khumoní simó irisayó ŋundo payómboro parí qu raró. Quko ene ŋuya simó moré kini khumaró. Khumoní simó kapusayó ŋuya ŋunde naŋge taró. ");
INSERT INTO nca_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ŋundiro naŋge simó kande saŋiyoro irisa ŋu soso pare ŋu rero simóye moré kini tero khumoyiqo, imemoŋgo pare ŋuya khumaró. ");
INSERT INTO nca_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Asa yeka iŋowato, unipare khumaŋgurí qundo pitu ko otoqowaŋgo quro naruyómo ŋuno, pare ŋu, danimboro yoweya? Dokoro uni kande saŋiyoro irisa qundo pare kanata ŋu raŋgurí.” ");
INSERT INTO nca_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ŋunde yiqo, Yesuko ŋande yimiraró, “Yendo mande sokomeko ŋuno nakayáŋaŋgurí ŋuya Anutu koro wimbí ŋuya kama iŋoyi tondaŋete. Ŋunde ŋuroko ye mande koroqe yeteŋgo. ");
INSERT INTO nca_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Unipare khumaŋgurí qundo uni tapu koŋgo pitu ko otoqowaŋgo quno ŋuno epe re-re kama tewaŋgo. Kini, eneko sambo simó ŋunde qembe yowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Quko unipare khumaŋgurí qundo pitu ko otoqowaŋgo quro yeweka iŋoyi. Moses koro sokomeko ŋuno ŋande yaró, ko enepa naŋge te kunzi qayara quno ŋuno kaŋiní Anutuko te suru qayara ŋu noŋgo ŋande miraró, ‘Nondo Abraham koro Anutuyó, Aisak koro Anutuyó, Yakop koro Anutuyó.’ ");
INSERT INTO nca_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Asa qeni, Anutu ŋuko uni kindo khumaŋgurí ŋuro Anutuye kini. Uni yoto-yotoye moré ŋuro Anutuye.” Yendo mande koroqe qu yeteŋgo. ");
INSERT INTO nca_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Asa Yesu koya Sadyusi unindoya epe mito-mito teyoyiqo, hutuŋo mande ŋuro iŋo-iŋo uni kato iŋaró. Iŋoro Yesu koro mande topé ŋuro niŋgu-niŋgu tero ŋande oseseyaró, “Mande kondé enesó-enesó ŋuro osese kereteno. Mande kondé kato mande kondé enesó-enesó ŋu taka yereyotepe ma kini?” ");
INSERT INTO nca_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yiní Yesuko mande topé ŋande yaró, “Iyo, ŋako. ‘Ye Israel iŋi, Uni Parámi, Anutunani ŋuko kanata na, enesó kama yote. ");
INSERT INTO nca_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Keto Uni Parámi ŋu, Anutuke, newondekepo, yuqakepo, iŋo-iŋokepo, wimbukepo hamó surumí iŋo inoyoto qembe.’ ");
INSERT INTO nca_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Asa mande kondé irisayó ŋuko ŋandiro: ‘Keŋomboro iŋoyote ŋunde naŋge topokeporo ŋunde na iŋoyoto.’ Mande kondé irisa ŋundo mande kondé enesó-enesó taka yerete.” ");
INSERT INTO nca_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yiní ŋande yaró, “Rondaqe-rondaqe uni, hamó yete. Anutu ŋuko kanata na, enesó kama yote. ");
INSERT INTO nca_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kowe uni kato newondí, iŋo-iŋoyó, wimbí soso Anutu inoyote tiníqo, ŋu meté horé. Kowe eneŋomboro iŋoyote ŋunde naŋge topémboro iŋoyote ŋu meté horé. Hutuŋo mande irisa ŋundo o meté horé mu, ŋuko o qa-qa qamukaŋgurí quya oka te inaŋgurí ŋuya soso taka yerete.” ");
INSERT INTO nca_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ŋunde yiní Yesuko uni ŋuro iŋoní tondaŋiní mande topé meté mu yiní ŋande miraró, “Keto Anutuko unipareyó wiri yereyote naruyómo waka ta owero tete.” Ŋunde yiníqo, uni meyowo wimbuye umbuní osese ka kama taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Asa Yesuko Ya Surumímboro hoŋgo quroyómo ŋuno mande rondaqe unipare yunoro ŋande yaró, “Do murí karo hutuŋo mande ŋuro iŋo-iŋo uni ŋundo ŋande yeyoteŋgo, ‘Kristo ŋuko Dewit koro naŋuní,’ ŋunde yeyoteŋgo? ");
INSERT INTO nca_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dewit eneŋombo Yuqa Surumíwore ŋande yete, “‘Uni Parámi ŋundo uni parámine ŋu ŋande miraró, “Kandene kondésina kunditeka nondo saŋgiríŋge soso yorewe keŋo kusuŋokemo yowaŋgo.”’ ");
INSERT INTO nca_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dewitko uni ŋuro ‘Uni parámine,’ ŋunde yaró. Asa date tero uni ŋuko Dewit koro naŋuní?” Yesu ŋunde yiníqo, unipare qambu kutaqe yaŋgurí qundo iŋoro niŋgu-niŋgu taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Asa Yesuko mande rondaqe yunoro ŋande yaró, “Hutuŋo mande ŋuro iŋo-iŋo unindoro murí piyimiye ma howewero. Uni ŋundo owéye hokowero iŋoyoteŋgo. Asa ko tuwiye sara-sara piru saŋga qu punuworo maketino uyare mahe teyoteŋgo, ko enendo unipareto eneya naru meté yewaŋgo ŋuro hamó iŋoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ko huru-huru yano kundite-kundite korete quno ŋuno kunditeyoteŋgo. Ko o ne-ne tero yakutí metémo kunditeyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ko wapu koro ya qu siyoteŋgo. Ko owé rewero quro hariri piru saŋga teyoteŋgo. Imemoŋgo o soso ŋuro topé piyimi rewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Asa Anutu koro Ya Surumímo ŋuno sosoko toŋomboroŋowí ka yaró. Unipare qambu qundo Anutu te inowero quro mone se mahero ŋuno raŋgurí. Asa Yesuko kutaqe ŋuno kunditero unipare qambu ŋundo mone ŋu raŋoyi uní yiyoyaró. Yiyoní onoŋo uni qambu wondo parámi reyaŋgo. ");
INSERT INTO nca_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ko wapu onoŋoyó moré kini qu kato mahero wondo musiyó tomó ta irisa ŋuno se raró. ");
INSERT INTO nca_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesuko ŋu qenero iŋo-iŋo rewero uniyó neko yerero ŋande yimiraró, “No hamó horé yimiroteno, oka wapu onoŋoyó moré kini ŋundo te inote ŋundo uni meyowo ŋu taka yerete. ");
INSERT INTO nca_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Dokoro meyowo ŋundo oye parámi moŋgo mone raŋoteŋgo. Quko wapu ŋuko oyó parámi kini qundo oyó soso ŋuno raŋote.” ");
INSERT INTO nca_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Asa Yesu Ya Surumímboro hoŋgo ŋu roto toŋiní eneŋo iŋo-iŋo rewero uni kato rohoréŋoro Ya Surumí qenero ŋande yaró, “Rondaqe-rondaqe uni, qeno, wondo pará-parámbo Ya Surumí towaŋgurí muko parámi horé, ko Ya Surumímboro pase tomó-tomó ŋu kekere horé.” ");
INSERT INTO nca_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yiní Yesuko ŋande yaró, “Ya pará-pará soso ŋumbe yiyote? Imemoŋgo wondo itaka epe saŋa-saŋa rero towaŋgurí mu soso raŋi umukoweya.” ");
INSERT INTO nca_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ŋunde yero andusina toŋero mira purí Oliv ŋuno kunditero Ya Surumí ŋu qeneŋgurí. Qenero Pita, Jems, Jon, Andru mahero mondó ta mande ŋuro murí iŋowero oseseyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ŋande yaŋgurí, “Do naruko tunoqeweya? Ko tunoqewe tete ŋuro do rokó ka teweya?” ");
INSERT INTO nca_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ŋunde yi Yesuko ŋande yimiraró, “Ye kondé toŋeteyuri. Kota uni kato mahero ye kaná yereweya koro. ");
INSERT INTO nca_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Imemoŋgo uni qambu mahero owéne nekoro ŋande yewaŋgo, ‘Uni maheweya ŋuko no naŋge!’ yero unipare qambu kaná yerewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Yeko kuma parámi teyoteŋgo ŋuro piŋa mande iŋowaŋgo, ko kuma parámi tunoqeweya ŋuro piŋa mande iŋowaŋgo. Asa ye kondé toŋeteyuri qembe. Ma yukuwowero. O soso ŋuko hamó maheweya, takawero mepémo kini. Quko naru maheweya ŋuko naru weŋa qu kini. ");
INSERT INTO nca_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Uni wini kato asa uni wini enesó-enesó kaya kuma ri otoqoweya. Asa wiri yerete unindoro kuma uni qundo otoqoro wiri yerete uni enesó-enesómboro kuma uni quya kuma tewaŋgo. Mirane-mirane kunduru raŋoníqo, korare parámi tunoqeweya. Quko o soso tunoqeweya ŋuko pareto simó pisiyowero tete ŋuro kowe surumí ŋunde qembe. ");
INSERT INTO nca_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ye qene iŋoyi qembe. Unindo yorero mande kho yunoro huru-huru yano haususu yerewaŋgo. Yeko owéne towoyoteŋgo, ŋu murí ŋuro uni ŋundo yorero wiri yerete uni parámi toŋeyemo ko uni kembé-kembé toŋeyemo yoroti kaŋero mande meté yimirowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Quko yendo koretero miti mande uni wini soso keweroyemo yesowoyi iŋowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Asa uni kumimbo ye yorero ronda yiriqo, ye do ka yewato ŋuro iŋaŋawí ma tewero. Dokoro ŋu naruko ŋuno Yuqa Surumímbo mande yewero qu ye yunoweya. ");
INSERT INTO nca_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ŋu naruko ŋuno payómbo koneyó mande piyimi ye inoníqo, uroyi khumoweya. Kowe iwímbo simómboya ŋunde naŋge teweya. Kowe simómbo iwí-nimímboya ŋunde naŋge ti khumowari. ");
INSERT INTO nca_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ko uni wini soso ŋundo yeŋo kondé piyimiŋo yunowaŋgo, dokoro yendo neneŋo owéne nekoyoteŋgo. Quko dani kato kondé kaŋeyate rambaruru takaweya. ");
INSERT INTO nca_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Imemoŋgo ‘o piyimi horé ka’ tunoqiní qenewaŋgo. O piyimi horé ŋu yendé meté horé muno ŋuno yoweya. (Ye sokome ŋa weyoteŋgo qu, weyo iŋika tondaŋiní.) Ŋu naruko ŋuno ye soso Judia mirako ŋuno yoteŋgo tiníqo, roto sorero mira purímo oyi qembe. ");
INSERT INTO nca_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Uni ka ya umómo yoweya quko oyó siyowero quro ya quroko ma uwero. ");
INSERT INTO nca_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ko uni ka khono yote tiníqo, tuwi ka tapémo rota ŋu ŋuya ma rewero. ");
INSERT INTO nca_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ŋu naruko ŋuno ye pare qahu tete, ko simó susu yunoyoteŋgo qu, ininiyaqe, quhurí piyimi korowowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","“Yeko ŋande hariri ti qembe, asa naru piyimi ŋuko seno kutiti naruyómo ŋuno kama tunoqeweya. ");
INSERT INTO nca_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Dokoro ŋu naruko ŋuno o quhurí parámi horé qu tunoqeweya. Hamó, Anutuko noko towaró ŋu noŋgo yate arero naru ŋanoko, o quhurí ka ŋunde qu komo kama tunoqaró. Kowe imemoŋgo o quhurí ka ŋunde qu pitu ko kama tunoqeweya. ");
INSERT INTO nca_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Quko Anutuko unipareyó rokó yereró ŋuro iŋoro naru ŋu riní tukuni teweya. Ŋunde kama teweya tiníqo, unipare soso khumowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ŋu naruko ŋuno naŋge, ko uni kato yeya ŋande yeweya, ‘Qeni, Kristo ŋuko ŋana!’ yeweyape ‘Qeni, andu yote anduqe,’ yewaŋgo ŋuro iŋondutu ma tewero. ");
INSERT INTO nca_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Dokoro, Kristo kota-kota koya ye-ye uni kota-kota koya mahero Anutuko unipare rokó yereró ŋu kaná yerewero o parámi wimbí moré qu tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Quko ye toŋete sopoyuri qembe. Itaka naŋge o soso ŋuro rondaqe yunoteno. ");
INSERT INTO nca_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Quko ŋu naruko ŋuno, asa naru piyimi ŋu kini tiníqo, “‘kosa ŋuko huriri tiní kombo ŋuko kama hiyóqiní ");
INSERT INTO nca_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","tutu soso ŋuko sambo koŋgo umbuyi o soso wimbí moré mu samboko yote qu yukuwowaŋgo.’ ");
INSERT INTO nca_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Ŋu naruko ŋuno Unindoro Naŋuní koporé kewerowore wimbí parámi horé tero sine parámimo mahiní unipare soso qenewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Mahero sambo simó asá yiriní toŋero unipare rokó yereró qu soso ta roŋgopo yerewaŋgo. Sambo simó ŋundo mira kawore-kawore noŋgo roŋgopo yereyate uro mira weŋawore qu yore mahemukowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Yeŋombo naŋge kewá fik ŋu qenero iŋondutu rero qeni qembe. Naru kano kambinímbo sono woso remukoní komiri keta qu woti qeneroqo, yeŋombo, kosa naru meté tewe tete, ye iŋowaŋgo. ");
INSERT INTO nca_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ŋundiro naŋge o soso yeteno ŋako tunoqiníqo, ŋande iŋowaŋgo, Unindoro Naŋuní ŋuko woso kutaqemo mahete, mako rorowo ŋano kaŋete, ye iŋi qembe. ");
INSERT INTO nca_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nondo hamó horé ye yimiroteno, unipare itaka yoroteŋgo quko toŋeye watí yoníqo, o soso ŋa tunoqeweya. ");
INSERT INTO nca_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Sambo koya noko koya kini tewari, quko mande yeteno ŋako kama kini teweya. ");
INSERT INTO nca_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Uni kato o ŋu tunoqeweya naruyó ŋu kama iŋote. Hamó, sambo simó ŋuya Naŋuní ŋuya kama iŋoteŋgo. Iwímbo enesó naŋge naruyó ŋu iŋote. ");
INSERT INTO nca_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Ye toŋete sopoyuri qembe. Ye naru ŋuro kama iŋoteŋgo. ");
INSERT INTO nca_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Qeni, uni parámi kato, yendé roto toŋewano, ye iŋoro sunará simóŋo kho yunoní ya sopoyoteŋgo. Toŋiní sunará simó kato makono kaŋero uni parámi rohoréŋo maheweya ŋuro toŋetero sopoyote. ");
INSERT INTO nca_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Ye ŋuya toŋete sopoyuri qembe. Uni Parámi rohoréŋo maheweya naruyó ŋu ye kama iŋoteŋgo. Ita suwo tinímbe ma suwo kewerokope ma kotori yeyonímbe ma ita saraŋoní maheweya. ");
INSERT INTO nca_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ene maheweya quno ye eteyoteŋgo tiníqo, ye piyo tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mande ŋa ye yimitoro unipare soso yimiroteno, ‘Toŋete sopoyuri qembe.’” ");
INSERT INTO nca_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ŋu naruko ŋuno o ne-ne naru irisa-irisa, owéyari muko Taka yereró, Bret Yisiyó Moré Kini, ŋuko wambaka tunoqariyó. Naru ŋu yaŋini naŋge tero o qa-qa unindoro tapá unindoya hutuŋo mande ŋuro iŋo-iŋo unindoya Yesu towo uroyi khumowero quro kota-kota kheyó ŋu seqaŋgurí. Quko tunomo urowero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ene ŋande epe mito-mito taŋgurí, “Norendo o ne-ne naruko ŋuno unipare toŋeyemo towowato tiníqo, saŋgirí tero kuma tewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Asa Yesuko Betani yendémo kowí piyimi khumo uni ka, owí muko Saimon koro yayómo ŋuno o naró. O niní pare ka mahero noko kumbe tomó ta ka rero rondaŋe sono risá nuŋgurí meté mu Yesu kembémo hausuwaró. Sono ŋu owí “nart,” ŋuro kimoyó parámi horé. ");
INSERT INTO nca_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Asa ŋunde tiní uni kumimbo ŋuno kunditero saŋgirí tero ŋande yaŋgurí, “Dokoro ŋunde tiní sono risá nuŋgurí meté ŋu kinaŋge kini tete? ");
INSERT INTO nca_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Sono ŋu soweyoroqo denarius 300 siyoro uni onoŋoye moré kini qu meté se yunowato.” Ŋunde yero mande saŋgirí pare ŋu miraŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ŋunde yiqo, Yesuko ŋande yaró, “Ŋunde roti. Date koro pare ŋa quhurí inoteŋgo? Enendo o meté nunote. ");
INSERT INTO nca_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Naru rokóŋoro uni onoŋoye moré kini ŋuko yeya yowaŋgo. Ko naru rokóŋo meté samaka yerewaŋgo. Quko no yeya naru piru kama yowano. ");
INSERT INTO nca_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Pare ŋando oka meté horé mu nunote. Imemoŋgo tapu nerewaŋgo. Asa ko enendo koretero kowene roŋgaruwote. ");
INSERT INTO nca_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Hamó ye yimiroteno, unindo mira soso ŋuno miti mande ŋu yesowoyowaŋgo quno ŋuno pare ŋando o tete ŋuro ŋuya yewaŋgo, ko pare ŋuro iŋowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ŋu naruko ŋuno Jutas Isikariot, iŋo-iŋo rewero uni 12 qu kato, Yesu kandeyemo re rotowero quro o qa-qa unindoro tapá unino uyaró. ");
INSERT INTO nca_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Uyaro yimironí niŋgu-niŋgu tero eneŋo khoyó kimowero quro miraŋgurí. Ŋunde miroyi eneŋo kandeyemo re rotowero quro naru meté seqaró. ");
INSERT INTO nca_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Asa Bret Yisiyó Moré Kini quro o ne-ne koro kosa naru korete quno Juda unipareto sipsip simó ka, owí, “Taka yereró,” yero nekoyaŋgurí ŋu uroyi khumoní qaro naŋgurí. Asa ŋu naruko ŋuno iŋo-iŋo rewero unindo Yesu ŋande oseseyaŋgurí, “Dano nore Taka yereró quro o ne-ne ŋu roŋgaruwato ke o ŋu neweya?” ");
INSERT INTO nca_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ŋunde yi Yesuko iŋo-iŋo rewero uni irisa neko yerero ŋande yimiraró, “Yendé parámimo ŋuno uyaririqo, uni kato sono kumbe ka re kheko ŋuno mahe wisumu yereweya ŋu. Yari ŋu howiri ");
INSERT INTO nca_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ya kano oníqo, ya simburí ŋande mirori qembe, ‘Rondaqe-rondaqe uni ŋundo ŋande osese kerete: No iŋo-iŋo rewero uninemboya Taka yereró quro o ne-ne ŋu newato. Ŋuro yakutí ŋu dana?’ ");
INSERT INTO nca_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ŋunde yiriqo, ya simburímbo yakutí parámi roŋgaruwaró mu witú yereweya. Asa yakutí ŋuno o newero ŋu roŋgaruwori qembe.” ");
INSERT INTO nca_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ŋunde yimironí uni irisa ŋu yendé parámimo ŋuno oro o soso Yesuko yaró ŋuko ŋunde naŋge tunoqaró. Asa ko yakutímo ŋuno Taka yereró quro o ne-ne ŋu roŋgaruwariyó. ");
INSERT INTO nca_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Asa suwo tiníqo, Yesu koya iŋo-iŋo rewero uni khe saŋiyoro irisa ŋuya Yerusalem oŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ya quroko oro o nero Yesuko ŋande yaró, “No hamó yeteno. Ye keweroyemo kato itaka noya o neyotero ŋuko no norero uni saŋgirí kandeyemo norotoweya.” ");
INSERT INTO nca_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ŋunde yiníqo, iŋo-iŋo rewero uni soso newonde surumí tero kato-kato oseseyaŋgurí, “Uni ŋu nondope?” ");
INSERT INTO nca_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yiqo, ŋande yaró, “Uni ŋuko iŋo-iŋo rewero uni khe saŋiyoro irisa qu ka. Ene noya kondó ŋano kopo neyotero. ");
INSERT INTO nca_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Unindoro Naŋuní ŋuko mande sokomeko nakayáŋgurí ŋu naŋge howero khumoweya. Quko uni ŋundo Unindoro Naŋuní ŋu re rotoweya quko, o iniyaqe, quhurí piyimi korowoweya. Námbo koretero uni ŋu kama pisiyaró tiníqo, meté.” ");
INSERT INTO nca_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Asa o neyate Yesuko bret ka rero Anutu yuŋgunaŋoro romboŋero iŋo-iŋo rewero uniyó yunoro ŋande yimiraró, “Ri. Ŋako neneŋo kowene na,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Niqo, kusí ka rero Anutu yuŋgunaŋoro yunoní kanata-kanata naŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ni ŋande yimiraró, “Ŋako neneŋo sitúne na, mande kondé ŋu reweya. Sitúne ŋu unipare qambu koro windoroŋowe teteno. ");
INSERT INTO nca_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","No hamó yeteno. Wain kaŋuya kama newano, yate Anutuko unipareyó wiri yereyote naruyómo ŋunoqota, wain keta newano.” ");
INSERT INTO nca_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ŋunde yiní yambo ka yi kini tiní mirako uro mira purí Oliv ŋuno oŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesuko ŋande yimiraró, “Imemoŋgo, iŋondutuye muko piyo tero ye soso norotowaŋgo. Dokoro sokomeko ŋuno ŋande nakayáŋaró, “‘Nondo sipsip sopo-sopo uroweqo sipsip soso wisikaraŋowaŋgo.’ ");
INSERT INTO nca_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Quko nondo khumoro otoqoroqota ye taka yerero Galili mirako uwano.” ");
INSERT INTO nca_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ŋunde yiní Pitako ŋande miraró, “Uni soso iŋondutuye muko piyo tewaŋgo, peka, quko nondo ŋunde kama tewano.” ");
INSERT INTO nca_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yiní ŋande yaró, “No hamó kimiroteno, itaka suwonoko kotori naru irisayómo kama yeyoníqota keto naru kapusako neneŋo wawa yeweya.” ");
INSERT INTO nca_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Quko Pitako kondé ŋande yaró, “No keya koporo nuri khumowaro, quko no keŋo wawa kama yewano,” yiní iŋo-iŋo rewero uni soso ŋuyako ŋundiro yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Asa yendé ŋu rotoro mira ka owé Getsemani ŋuno oro Yesuko iŋo-iŋo rewero uniyó ŋande yimiraró, “Ŋano kunditeyurika no hariri tewe.” ");
INSERT INTO nca_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ŋunde yero Pita, Jems, Jon yorero oroqo newondeye yukuwoní ");
INSERT INTO nca_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ŋande yimiraró, “Newondenembo quhurí horé tiní no khumowe teteno. Ye ŋano yotoya toŋete sopoyuri.” ");
INSERT INTO nca_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Ŋunde yero soŋga ta kapiyamo oro nokono umbu etero hariri tero Anutu ŋande miraró, “O awane horé, keto o soso koro wimbí teyote. Ke iŋo nunoyaqo, topa newano ŋa rika toŋiní. Quko iŋo-iŋone mu ma howewero. Kini, keŋombo na ti qembe.” ");
INSERT INTO nca_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Hariri tiní kini tiní mahiní uni kapusa ŋu eteyuri Yesuko Pita ŋande miraró, “Saimon, kepe eteyote? Naru piru kini, tukuni ta toŋetewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ye kondé toŋeteya hariri ti qembe. Yate ye osese kano umbuwaŋgo koro. Hamó, yuqaye muko o meté tewero nuŋgurí tete, quko koweye saŋaní ŋuko kondé kini.” ");
INSERT INTO nca_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ŋunde yero roto toŋero hariri ŋu pitu ko taró. ");
INSERT INTO nca_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tiní kini tiní pitu ko eneno mahero yiyoníqo, eteyaŋgurí, dokoro kupo tero toŋeye quhurí taró. Eteyuri okoko yiriní mande topé tewero mepémo kini taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Naru kapusayómo quno mahero ŋande yimiraró, “Yembe watí ete kapeyoteŋgope? Koro ŋu! Qeni, naru tete, unindo Unindoro Naŋuní ŋu re quhurí uni kandeyemo rota. ");
INSERT INTO nca_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ye otoqoyika uyato. Qeni, uni nore uni piyimi kandeyemo norotoweya ŋundo kutaqemo mahete.” ");
INSERT INTO nca_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Asa waka ta Yesu mande yeyoní naŋge, Jutas, iŋo-iŋo rewero uni 12 qu ka, ŋundo maheró. Mahero uni wini parámi horé suke parámimboya usú ŋuya se towo eneya maheŋgurí. O qa-qa unindoro tapá uni ŋuya hutuŋo mande ŋuro iŋo-iŋo unindoya uniparetoro uni kembé-kembéyemboya uni ŋu asá yiri maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Komo Jutasko rokó karo ŋande yimiraró, “Nondo uni ka mutó inowano. Uni ŋuko Yesu, towoya toŋi qembe.” ");
INSERT INTO nca_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Asa Jutasko mahero Yesu taŋgímo mahero ŋande yaró, “Rapi,” yero mutó naró. ");
INSERT INTO nca_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mutó riní uni mahero Yesu toworo kondé towaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Towoyi uni sume yerero kaŋaŋgurí qu kato suke parámiyó rero tapá unindoro sunará simó qu ka utoro kusumbí takaní kusumbí nokono umburó. ");
INSERT INTO nca_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ŋunde tiní Yesuko ŋande yimiraró, “Yendo no wiri yerete unindoya kuma teyoteno ŋundiro suke parámi, usú siyoro kondé nondowowero maheteŋgo, peka? ");
INSERT INTO nca_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Naru rokóŋo Ya Surumímo ŋuno nondo yeya kaŋero mande rondaqe yunoyanowó. Quko ŋu naruko ŋuno kama nondowaŋgurí. Asa meté, ŋandiro mande sokomeko ŋuno nakayáŋaŋgurí ŋu hamó tunoqeweya.” ");
INSERT INTO nca_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ŋunde yiníqo, iŋo-iŋo rewero uniyó soso Yesu rotoro soraŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Asa simó keta kato Yesu howeyaró qu tuwi meté mu kinaŋge punuworo ŋuno kaŋaró. Kaŋiní kuma unindo towoyiqo, ");
INSERT INTO nca_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","simó keta ŋu soriní tuwi ŋu wendaŋiní umbuní birimbiri soraró. ");
INSERT INTO nca_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Asa uni ŋundo Yesu toworo o qa-qa unindoro tapá unindoro yano oŋgurí. Ŋuno uni tapá ŋuya uni kembé-kembémboya hutuŋo mande ŋuro iŋo-iŋo unindoya ŋuno kopaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita ŋuya yohowe uyaró. Uyariní tapá uni ŋuro pase quro hoŋgo quroko ŋuno sopo-sopo unindo kunditero kewá qaro rokoyaŋgurí. Rokoyuri Pita ŋuya ŋuno oro kaŋe rokaró. ");
INSERT INTO nca_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Asa ya quroko O qa-qa unindoro tapá uni ŋuya uni kembé-kembé soso ŋundo Yesu uri khumowero khe ka seqaŋgurí. Ŋunde ŋuro o piyimi ka taró ŋuro mande ka seqayate kama iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Uni kumi mande kota-kota yaŋgurí, quko mande enesó-enesó yaŋgurí. Ŋunde ŋuroko mande ŋuro uroyi khumowero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kumi kaŋero mande kota ŋandiro yaŋgurí, ");
INSERT INTO nca_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Uni ŋundo ŋande yaró, ‘Ya Surumí ŋu rambaruruwano. Ko naru kapusa ŋunde rotoro keta qu towowano. Quko keta ŋuko kandeto kama towowano.’ Ŋunde yiní iŋatowó,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Quko uni meyowo-meyowombo mande enesó-enesó yaŋgurí. Ŋunde ŋuroko mande ŋuro uroyi khumowero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ŋunde yiriqo, tapá uni ŋundo keweroyemo kaŋero Yesu ŋande oseseyaró, “Uni ŋando mandeyari saŋga kerete. Ketope mande topé ka yeweyape ma kini?” ");
INSERT INTO nca_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Quko Yesuko mondó ta kunditero mande topé ka kama yaró. Pitu ko ŋande oseseyaró, “Kepe Kristo ŋu, Anutu koro Naŋunímbe, ma kini?” ");
INSERT INTO nca_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ŋunde yiní Yesuko ŋande yaró, “Iyo. Ko yendo Unindoro Naŋuní qeniqo, Anutu wimbí moré ŋuro kandí kondésina kunditiní qenewaŋgo, ko sambo koro koporéwore maheweya ŋu qenewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ŋunde yiníqo, o qa-qa unindoro tapá uni ŋundo newonde piyimi tero eneŋo tuwiyó romboŋero ŋande yaró, “Do karo uni kaŋuya neko yereto quhuríŋo ŋuro yesowowaŋgo! ");
INSERT INTO nca_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ye soso mande piyimi ŋa iŋoyoteŋgo. Date tewato?” Ŋunde yiní uni kembé-kembé soso ŋande yaŋgurí, “Meté urato khumoweya,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ŋunde yiqo, uni kumimbo tuteworo toŋí pokamoro kandeto utoro ŋande oseseyaŋgurí, “Dani kato kurote?” yaŋgurí. Ŋunde ti sopo-sopo unindo kandeto uraŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Asa Pita ya kimbino kaŋero te rokoyoní o qa-qa unindoro tapá unindoro sunará pare ka mahero kondé-kondé qenero ŋande yaró, “Keya Nasaret noŋgo uni Yesu ŋuya yotiri,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Quko Pitako wawa yero ŋande yaró, “Kini, keŋo mandeke ŋu kama iŋowe tondaŋete,” yero roto toŋero hoŋgo makono uyareró. Ŋuno uyariní kotori kato yaró. ");
INSERT INTO nca_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ko pare ŋundo uni kaŋeyaŋgo qu ŋande yimiraró, “Uni ŋuya uni ŋuro wini qu ka.” ");
INSERT INTO nca_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ŋunde yiníqo, pitu ko Pitako wawa yero ŋande yaró, “Kini,” yaró. Imemoŋgo, naru tukuni naŋge, uni kaŋeyaŋgo ŋundo ŋande yaŋgurí, “Iyo, keko Galili uni ka. Asa keko iŋo-iŋo rewero uniyó ka,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ŋunde yiqo, mande kondé ŋande yaró, “Uni yeteŋgo ŋu no kama iŋo inoteno! Ko no hamó kama yeweqo, asa Anutuko no rambaruru nereweya,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Yiníqo, waka ta kotori kato pitu ko yaró. Komo Yesuko mande ka ŋande miraró, “Itaka suwonoko kotori naru irisayómo kama yeyoníqota keto naru kapusako neneŋo wawa yeweya,” yaró. Asa ŋuro iŋoro newonde surumí tero tendaró. ");
INSERT INTO nca_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ita saraŋoníqo, o qa-qa unindoro tapá unindoya Juda koro uni kembé-kembémboya hutuŋo mande ŋuro iŋo-iŋo unindoya ronda-ronda uni soso koya kopaŋgurí. Koporo mande ka yero Yesu kusiyoro re uyaro Pailat ŋuro kandímo rotaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Re uyari Pailatko ŋande oseseyaró, “Kepe Juda uniparetoro wiri yerete uni ŋumbe, ma kini?” Yiní mande topé ŋande yaró, “Keŋombo ŋunde naŋge yete,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Yiníqo, o qa-qa unindoro tapá uni ŋundo Yesu ŋuro mande piyimi qambu Pailat miraŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ŋunde miroyi pitu ko oseseyaró, “Do mande topé ka yewero? Mande piyimi qambu yeyoteŋgo,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Quko mande topé ka kama yaró. Ŋunde ŋuro Pailat iŋondata parámi taró. ");
INSERT INTO nca_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kumima naru kanata-kanata Taka yereró quro o ne-ne naruyómo ŋuno, murí ka howeyara. Murí ŋuko ŋandiro, unipare qambu ŋundo uni kanata ka kusi-kusi yano yaró ŋu owí nekoyiqo, Pailatko uni ŋu rotoní eneno uyaró. ");
INSERT INTO nca_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Juda uni ka, owí muko Barapas, ŋuya topé-topémboya kusi-kusi yano yaŋgurí. Uni ŋundo Rom koro wiri yerete unindoro mande qu wendaqero, kuma tero, unipare kumi yuroyi khumaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Asa unipare qambu ŋundo Barapas rotowero quro oseseyowero areŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ari Pailatko ŋande osese yereró, “Metémbe Juda uniparetoro wiri yerete uni ŋa re rotowanope ma kini?” yaró. ");
INSERT INTO nca_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailatko ŋande iŋomukaró, ko o qa-qa unindoro tapá uni ŋundo Yesu koya newonde tutu tero re towo kusiyoro maheŋgurí. Ŋunde ŋuroko unipare ŋundiro osese yereró. ");
INSERT INTO nca_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ŋunde quko uni tapá ŋundo unipare mande yimiroyi unipareto Pailat ŋande miraŋgurí, “Barapas naŋge re roto,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pitu ko ŋande osese yereró, “Juda uniparetoro wiri yerete uni ŋu, no date te inowe?” ");
INSERT INTO nca_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Yiní mande kondé yaŋgurí, “Re tipiririko uroyi!” ");
INSERT INTO nca_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ŋande osese yereró, “Do piyimi ka tiní ŋuro?” Yiní mande kondé parámi yaŋgurí, “Re tipiririko uroyi!” ");
INSERT INTO nca_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ŋunde ŋuroko Pailatko unipare qambu ŋu meté yerewero Barapas rotoní eneno uyaró, ko Yesu riní kuma unindo uŋguru-gurumoro tipiririko urowero re uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Asa kuma uni ŋundo Yesu rero Rom koro uni kembémboro yano oro topo-topoye soso neko yereŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ŋundo mahero wiri yerete unindoro tuwi mandumi huririyó re kowí punuworo utó kami moré ka re wakaro wiri yerete unindoro takapu ŋunde qembe kembémo raŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ŋunde tero ŋande yaŋgurí, “Juda uniparetoro wiri yerete uni ŋu, ke mahete ŋu,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ŋunde yero satémbo kembémo utoro tuteworo potoruku kota-kota re inaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ŋunde tero huwó mande yi kini tiní tuwi mandumi ŋu re rotoro eneŋo kowe punu-punuyó re inaŋgurí. Ŋunde tero rero tipiririko urowero re uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Asa kuma unindo Yesu re uyaroqo, uni ka ŋuya towaŋgurí. Uni ŋu Sairin yendé moŋgo, owí muko Saimon, eneko Aleksanda, Rupus koro awayari. Enendo siku noŋgo mahero yendémo owero taró. Asa uni ŋu toworo tipiriri re inoyi korowaró. ");
INSERT INTO nca_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Uyareyate mira ka, owí muko Golgota, ŋuno oŋgurí. (Owé ŋu “Golgota” murí muko “Kembémboro Wimbí ŋuro mira ŋu.”) ");
INSERT INTO nca_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ŋuno sono kondé ne kape tiní, yero re inaŋgurí. Quko kama naró. ");
INSERT INTO nca_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Re mahero kowe punu-punu wendaŋero tipiririko utoro kowe punu-punuyó rewero kundo ka taŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ita saraŋoní 9 kilok ŋuno tipiririko uraŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ko tipiriri sombémo ŋuno o piyimi taró muro mande ka ŋande nakayáŋaŋgurí, “Juda Uniparetoro Wiri Yerete Uni ŋa.” ");
INSERT INTO nca_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Uni irisa ŋuya yorero ka kandí kondésinawore tipiriri kano porowaŋgurí, ko ka kandí tesinawore tipiriri kano porowaŋgurí. Uni ŋundo Rom koro mandeye wendaqero kuma teyari. ");
INSERT INTO nca_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(-) ");
INSERT INTO nca_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Asa unipare uyaro yesaráŋoro kembaye ituqero ŋande yaŋgurí, “Keto, Ya Surumí rambaruruworo kosa naru kapusa quno ŋuno keta rewano, yaró! ");
INSERT INTO nca_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Asa keŋombo naŋge rambaruru ŋa takaya tipiriri roto umbu,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ŋundiro naŋge o qa-qa unindoro tapá unindoya hutuŋo mande ŋuro iŋo-iŋo unindoya huwó mande yero epe mito-mito taŋgurí, “Uni ŋundo uni kumi rambaruru koŋgo yorewero taró. Quko rambaruru ŋa takawero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kristo ŋundo, Israel uniparetoro wiri yerete uni ŋundo, tipiriri roto umbuníqo, nore qenero iŋondutuwowato.” Ŋunde yi uni irisa kawore-kawore poro yereŋgurí ŋundo mande piyimi ye mirariyó. ");
INSERT INTO nca_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Asa kosa keweroko mira soso huriri teyate suwoya 3 kilok ŋunde taró. ");
INSERT INTO nca_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","3 kilok ŋundiro Yesu kondé ŋande kiwaró, “Eloi, Eloi, lama sapaktani?” yaró. (Mande ŋuro murí muko, “Anutune, Anutune, do karo norotote?”) ");
INSERT INTO nca_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Uni kumi kutaqe kaŋaŋgurí ŋundo mande ŋu iŋoro ŋande yaŋgurí, “Iŋoyi, enendo Elaija nekote.” ");
INSERT INTO nca_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ŋunde yi uni kato kheŋgeŋoro o piwo qembe ka rero wain oŋgomi quroko riní maŋgoriní satémbo kusiyoro hokoro Yesu maŋgómo re inoro ŋande yaró, “Elaijako mahe tipiriri koŋgo re rotoníka qeneto,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Quko Yesuko ki parámi tero yuqayó rotoro khumaró. ");
INSERT INTO nca_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Khumoníqo, Ya Surumímo tuwi parámi ka ŋuno pikaŋgurí mu kore koŋgo kosaŋe kusuŋono umburó. ");
INSERT INTO nca_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Asa kuma unindoro sopo-sopo kato tipiriri taŋgímo kaŋero Yesu khumaró ŋuro murí qenero ŋande yaró, “Hamó horé, ŋuko Anutu koro naŋuní,” yaró. ");
INSERT INTO nca_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Asa pare kumi kapiyamo kaŋero qeneŋgurí. Keweroyemo ŋuno kumi muko ŋandiro: Maria, Maktala yendé moŋgo quya Maria kako, Jems, Joses koro náyari, koya Salome. ");
INSERT INTO nca_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Komo pare soso ŋundo Galili mirako Yesu howero samakaŋoyaŋgurí. Asa pare kumi qambu Yesu koya Yerusalem oŋgurí mu ŋuno kaŋero Yesu qeneŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Yesu khumaró naru ŋuko Sapat koro roŋgaruwowero naru. Ŋunde ŋuroko kosa pusuŋewero tiníqo, ");
INSERT INTO nca_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","uni pará-parámboro huru-huru koro uni ka Arimatea yendé moŋgo, owí Josep, ŋu maheró. Enepa naŋge Anutuko unipareyó wiri yereyote naruyó ŋuro sopoyara. Asa sasaro kama tero Pailat Yesu koro ukúŋo rewero kirayaró. ");
INSERT INTO nca_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ŋunde yiní Pailatko Yesu khumaró ŋuro iŋondata parámi tero kuma unindoro sopo-sopo ŋu nekoro, komo khumape ma kini, ye oseseyaró. ");
INSERT INTO nca_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Oseseyoní, “Khuma,” yiníqo, Josepko ukúŋo meté rewero ŋunde yaró. ");
INSERT INTO nca_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Asa ko Josepko uyare tipiriri koŋgo ukú re rotoro tuwi kekere sara-sara qundo pokamoro uni tapu wondo yayó quroko rero wondo parámi ka rero mako tuŋaró. ");
INSERT INTO nca_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ko Maria Maktala noŋgo quya Maria, Joses koro nimí ŋuyako dano tapuŋaró ŋu qeneriyó. ");
INSERT INTO nca_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Asa Sapat naru ŋu kini tiníqo, pare kapusa ŋu, Maria Maktala noŋgo quya Maria, Jems koro nimí ŋuya Salome koya Yesu ukúŋo saŋano rewero quro o nuŋgurí mu kimaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kimoro sonda naru korete quno, ita saraŋoní uni tapuko ŋuno uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Uyareyate wondo parámi uni tapu wisumuŋaró ŋuro yero iŋoro epe mito-mito taŋgurí, “Dani kato samaka nerero wondo parámi ŋu rohoré-rohoréŋoweya?” yaŋgurí. Yero kutaqe mahero toŋetiqo, wondo parámi ŋuno qu kikíŋoní tapémo uró. ");
INSERT INTO nca_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Asa wondo yayómo oro simó keta ka qeneŋgurí. Simó keta ŋu tuwi piru sara-sara ka punuworo kande kondésina kunditeyaró. Kunditiní qenero newondeye yukuwaró. ");
INSERT INTO nca_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Quko ene ŋande yimiraró, “Ma yukuwowero. Yembe Yesu Nasaret noŋgo qu re tipiririko uraŋgurí mu ŋumbe seqateŋgo? Ŋuko komo otoqoro toŋe, ŋano kama yote. Dano ri etaró ŋu qeni. ");
INSERT INTO nca_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Asa ko ye uyika iŋo-iŋo rewero uniyómboya Pita ŋuya piŋa mande ŋa yimiri, ‘Yesu koretero Galili mirako uní ŋuno qenewaŋgo. Ŋundiro naŋge komo yimiraró.’” ");
INSERT INTO nca_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ŋunde yiníqo, pare ŋu iŋondutuye enesó-enesó tiní soraŋgurí. Sorero sasaro parámi tero uni ka kama miraŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Asa sonda naru korete quno, ita saraŋoní, Yesu otoqoro tunoqiní koretero Maria Maktala noŋgo ŋundo qeneró. Komo, Yesuko Maria newondímo yuqa piyimi kande saŋiyoro irisa yohowaró. ");
INSERT INTO nca_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Yesu otoqaró quno iŋo-iŋo rewero uniyó ŋundo ya kano Yesu khumaró ŋuro newonde surumí tero tendoyaŋgurí. Asa pare ŋundo ŋuno uyaro Yesu otoqaró ŋuro yimiraró. ");
INSERT INTO nca_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Quko piŋa mande ŋu iŋoro, hamó kini, yero iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Imemoŋgo iŋo-iŋo rewero uni irisa Yerusalem yendé rotoro khewore uyareyori Yesu ŋuno tunoqiní qeneriyó. Quko koretero kama qene iŋariyó. ");
INSERT INTO nca_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Yate iŋomukoro iŋo-iŋo rewero uniyó meyowo ŋu Yesu ŋuro yimirariyó. Quko mande ŋu hamó kini yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tukú iŋo-iŋo rewero uni khe saŋiyoro kanata ŋundo o qoyemboro neyuri Yesu keweroyemo tunoqiní qeneŋgurí. Qeni Yesuko kiro mande yimiraró. Dokoro Yesu otoqaró ŋuro piŋa mande qambu iŋoro, hamó kini, ye iŋoro kama iŋondutuwoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yero ŋande yimiraró, “Mira soso ŋuno uya miti mande ŋa yesowoyi qembe. ");
INSERT INTO nca_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ŋunde yimiri unipare kato iŋi hamó tiní sono riqo, rambaruru koŋgo yoreweya. Quko kato iŋi hamó kini tiníqo, ŋuko quhuríyemboro topé rewaŋgo. ");
INSERT INTO nca_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Unipare soso iŋondutuworo o wimbí moré ŋande tewaŋgo: owénemo uni quro koŋgo yuqa piyimi mu yohowewaŋgo, mande enesó-enesó yewaŋgo, ");
INSERT INTO nca_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","kandeto sire yondowowaŋgo, sono saŋgirí nero kama khumowaŋgo, kandeye se khumo uni saŋano ri meté tewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Asa Yesu, Uni Parámi ŋundo, yiní kini tiníqo, riní samboko oro Anutu koro kandí kondésina kunditaró. ");
INSERT INTO nca_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Iŋo-iŋo rewero uniyó ŋuno rotoro mira soso uyare miti mande yimiraŋgurí. Ŋunde ti Uni Parámimbo samaka yerero mandeye wimbu inowero koro o wimbí moré qambu taró. ");
INSERT INTO nca_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Komo uni qambu qundo Anutuko o soso riní nore keweronanimo tunoqaró ŋuro sowo mande meté ŋu nakayáŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Sowo mande ŋu uni toŋeyembo o soso ŋu qenero Anutu koro mandímboro sopo-sopo uni tunoqaŋgurí ŋu, eneŋombo mande ŋu nore soso yimiraŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ŋunde ŋuro, uni parámine Teopilus, no ŋuya sowo mande ŋu hurí taró qu noŋgo okeyá ta nakayáŋoro rewe keno maheweya, ye iŋanowó. ");
INSERT INTO nca_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ŋunde tewe, keto o soso iŋaró ŋuko hamó naŋge, ye iŋoweya. ");
INSERT INTO nca_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Asa Herot, Judia mira koro wiri yerete uni ŋu, yoníqo, o qa-qa uni ka owí muko Sekaraia yora. Eneŋo o qa-qa unindoro kho winiyó ŋuko Apiya koro wini ŋu. Parí muko Aron koro sowe qu, owí muko Elisapet. ");
INSERT INTO nca_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Yereka irisa ŋuko Anutu toŋímo roneneŋowí yariyó, Uni Parámimboro mande kondé ŋuya ore mande ŋu soso okeyá ta howeyari. ");
INSERT INTO nca_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Quko simóyari moré kini, dokoro Elisapet ŋu kusimi yora. Ko yereka ŋu koŋgomu tariyó. ");
INSERT INTO nca_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Naru kano eneŋo o qa-qa unindoro kho winiyómboro naruye tunoqaró quno Sekaraiako Anutu toŋímo kho taró. ");
INSERT INTO nca_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ŋu naruko ŋuno topé-topémbo muríye howero ene rokóŋoyi o nuŋgurí meté mu qawero quro Uni Parámimboro Ya Surumímo oró. ");
INSERT INTO nca_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","O qa-qa ŋu tewero naruyómo ŋuno oníqo, unipare qambu ŋundo Ya kimbino koporo hariri teyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Asa Uni Parámimboro sambo simó kato Sekaraiako tunoqero o qa-qa nuŋgurímboro wondo yakutí kandí kondéwore ŋuno kaŋaró. ");
INSERT INTO nca_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kaŋiní qenero yukuwo sasaro parámi taró. ");
INSERT INTO nca_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ŋunde tiní sambo simó ŋundo ŋande miraró, “Sekaraia, ke ma sorewero, Anutuko haririke iŋote. Ko pareke Elisapet simó urumuni ka pisiyoweya. Ke owí Jon ye qembe. ");
INSERT INTO nca_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ke niŋgu-niŋgu teweya, ko newondeke meté horé yoweya. Ko unipare qambu qundo simó tunoqeweya ŋuro niŋgu-niŋgu tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Dokoro ŋu simó ŋuko Anutu toŋímo owé parámi reweya. Wain koya sono kondé soso ŋu kama neweya. Nimí qahímo yoroweya quno ŋuno Yuqa Surumí ŋundo eneno maŋgoreyoweya. ");
INSERT INTO nca_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ko enendo Israel unipare qambu rohoré yiriní Uni Parámi, Anutuyemo uyarewaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Enendo Uni Parámi toŋímo khe howero Elaija taró ŋunde qembe Yuqa koro wimbí tero awa-awaye naŋo-simóye yoriní newonde kanata na tewaŋgo. Ko uni mande wenda-wenda teteŋgo qu roŋgaru yiriní iŋo-iŋo roneneŋowí mu tewaŋgo. Ŋunde tero unipare yoriní Uni Parámi maheweya ŋuro sopowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sekaraiako sambo simó ŋande miraró, “Ŋunde quko no date tero mandeke ŋu hamó, ye iŋowano? No koŋgomu tanowó, ko parene ŋuya koŋgomu taró.” ");
INSERT INTO nca_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ŋunde yiní mande topé ŋande yaró, “No Gebriel, no Anutu toŋímo kaŋeyoteno. Anutu eneŋombo nimironí piŋa mande meté ŋa kimirowero re umbuteno. ");
INSERT INTO nca_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Asa qeno, ke mandene kama iŋondutuwoyote. Ŋunde ŋuro itaka ŋano yate Anutuko o ŋu rokóŋoní tunoqeweya ŋuro naruyómo ŋuno maŋgoke kusiyoní mande yewero mepémo kini teweya.” ");
INSERT INTO nca_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Asa unipare Sekaraia soporo naru piru Ya Surumímo yoraró ŋuro iŋondata parámi taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Yate yendémo umburo mande yimirowero mepémo kama taró. Ŋunde ŋuro, enendo kapo ka Yano ŋuno qenete, yero iŋaŋgurí. Maŋgó kusiyowí qembe tero kandímbo naŋge rokó-rokó teyaró. ");
INSERT INTO nca_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tukú eneŋo khoyó kini tiníqo, yendéyómo toŋeró. ");
INSERT INTO nca_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Imemoŋgo parí Elisapet ŋu qahu tero sóqeyoní kombo kandeka kini taró. Ŋunde tiní ŋande yaró, ");
INSERT INTO nca_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ŋundiro naŋge Uni Parámimbo o meté te nunaró. Te nunoro neneŋo kowi piyone riní unipare toŋeyemo kini teweya.” ");
INSERT INTO nca_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kombo saŋiyo kanata ŋunde quno Elisapet qahu teyoní Anutuko sambo simó Gebriel ŋu asáŋoní ");
INSERT INTO nca_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","pare keta kamí moré kini qu ka Galili mirako Nasaret yendémo ŋuno uyaró. Pare keta ŋuya uni ka, owí muko Josep, ŋuya epe re-re tewari, yero piŋa ye yunaŋgurí. Josep ŋuko Dewit koro sowe qu. Pare keta ŋu owí muko Maria. ");
INSERT INTO nca_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Asa ŋuno uyaro pare ŋande miraró, “Ke pare puriŋo raró ŋu, naru meté. Uni Parámimbo keya yote.” ");
INSERT INTO nca_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Yiníqo, iŋondata parámi tero, ŋa do karo ŋunde yete, yero iŋaró. ");
INSERT INTO nca_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Asa sambo simómbo ŋande miraró, “Maria, ke ma sorewero. Dokoro Anutuko iŋo kunoyote. ");
INSERT INTO nca_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Qeno, ke qahu tero simó urumuni ka pisiyoweya. Owí Yesu ye qembe. ");
INSERT INTO nca_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Enendo owé parámi reweya, kowe unipareto, Anutu Koreko Horé yote ŋuro Naŋuní, ye nekoyowaŋgo. Anutu, Uni Parámi ŋundo riní eneŋo usí Dewit koro yakutímo kunditero ");
INSERT INTO nca_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","naru suki-suki Yakop koro wini ŋu wiri yereyoweya, wiri yereweya ŋuko kama kini teweya.” ");
INSERT INTO nca_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ŋunde yiní Mariako ŋande oseseyaró, “Ŋu date te tunoqeweya? No uni ka kama ranowó.” ");
INSERT INTO nca_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Yiní mande topé ŋande yaró, “Yuqa Surumí ŋundo poka kiriní Anutu Koreko Horé yote ŋuro wimbímbo yoŋo kereweya. Ŋuroko oŋa ŋuko meté horé yoní, Anutu koro Naŋuní, ye nekowaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Iŋo, nuweŋge Elisapet ŋu koŋgomu tero kusimi taró, quko itaka ka qahu tero simó urumuni ka pisiyoweya. Itaka qahu tero kombo saŋiyo kanata ŋunde kini tete. ");
INSERT INTO nca_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Anutuko oka tewero kama rukusuwoweya!” ");
INSERT INTO nca_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ŋunde yiní Mariako ŋande yaró, “Qeno, no eneŋo sunará pare. Ke yete ŋundiro nono tunoqiní.” Ŋunde yiní sambo simó ŋu roto toŋeró. ");
INSERT INTO nca_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ŋu naruko ŋuno Maria otoqoro Judia koro mira purí-purímo yendé kano waka ta oró. ");
INSERT INTO nca_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Oro enendo Sekaraiako ya ŋuro quroko oro Elisapet qenero, “Naru meté,” yaró. ");
INSERT INTO nca_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Yiní Elisapetko mandí iŋoní simó qahímo yaró ŋu sore-sore taró. Ŋunde tiní Yuqa Surumí ŋundo Elisapet newondímo maŋgoraró. ");
INSERT INTO nca_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Maŋgoriní ki parámi tero ŋande yaró, “Anutuko puriŋo te kunoní pare soso taka yereyote. Ŋuya Anutuko simó qahuŋgemo puriŋo te inoyote. ");
INSERT INTO nca_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Date koro Uni Paráminemboro nimí ŋundo nono mahete? ");
INSERT INTO nca_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Qeno, keŋo mandeke ŋu iŋoweqo, simó qahunemo ŋundo niŋgu-niŋgu tero sore-sore tete. ");
INSERT INTO nca_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Keto ŋande iŋondutuwoyaró, do ka Anutuko no nimiraró ŋu hamó tunoqeweya. Ŋunde ŋuro ke puriŋo ka rete.” ");
INSERT INTO nca_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ko Mariako ŋande yaró, “Newondenembo Uni Parámimboro owí hokoyoteno, ");
INSERT INTO nca_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ko yuqanembo Anutu, no Rambaruru Koŋgo Norewero Uni ŋuro niŋgu-niŋgu teyoteno, ");
INSERT INTO nca_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","dokoro, eneŋo sunará pare ŋuko owí moré kini ŋuro iŋo nunaró. Hamó, imemoŋgo Anutuko puriŋo ka nunaró ŋuro unipare soso qene iŋowaŋgo, ");
INSERT INTO nca_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","dokoro Uni Wimbí Moré ŋundo kondé samaka nereró. Ŋunde tero owí meté horé tete. ");
INSERT INTO nca_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Naru suki-suki enendo unipare soso eneŋo sasaro teteŋgo qu sikíye te yunoyote. ");
INSERT INTO nca_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kandeto o wimbí moré qambu teyote. Enendo uni kumimbo eneŋo owéye hokoyoteŋgo ŋu yoriní umbu wisikaraŋoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Enendo wiri yerete uni owéye riní umbuyote, quko eneŋo owéye ri umbuyote qu ŋu owéye hokoyote. ");
INSERT INTO nca_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Unipare o qoyemboro khumoyoteŋgo ŋu o yunoní nero qahuye tinditeyote, quko onoŋo unipare oka kama yunoro kina yohoweyote. ");
INSERT INTO nca_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Enendo Israel, eneŋo sunará simó ŋu, samaka yerero sikíye te yunoyote. ");
INSERT INTO nca_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Dokoro naru suki-suki ŋunde enendo teyoweya ŋuro usisambanani Abraham koya eneŋo sowe qu ŋunde yimiraró.” ");
INSERT INTO nca_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ŋunde yero Mariako Elisapet koya kombo kapusa ŋuno yate rotoro yendéyómo toŋeró. ");
INSERT INTO nca_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Asa naru kini tiníqo, Elisapet simó urumuni ka pisiyaró. ");
INSERT INTO nca_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Pisiyoní yendé uniparetoya suwisawiyómboya Uni Parámimbo Elisapet sikí parámi te inaró ŋuro iŋoro eneya niŋgu-niŋgu taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Asa kosa naru kande saŋiyoro kapusa ŋuno simó kowí toŋowero kopaŋgurí. Koporo, iwí Sekaraia koro owé qu inowato, ye iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Quko nimímbo ŋande yaró, “Kini. Owí muko Jon,” yaró. ");
INSERT INTO nca_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Yiní ŋande miraŋgurí, “Keŋo suwisawike ka, owéye ka ŋunde kini qu,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ŋunde yero kandeyembo naŋge rokó-rokó tero iwí ŋande osese taŋgurí, simó ŋu do owé ka inowato. ");
INSERT INTO nca_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ŋunde tiqo, kandímbo rokó-rokó tiní sokome inoyi ŋande nakayáŋaró, “Owí muko Jon.” Nakayáŋoní qenero iŋondata parámi taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ŋu naruko naŋge Sekaraia maŋgó meté tiní mande yero Anutu owí hokaró. ");
INSERT INTO nca_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Yendé unipare soso qenero sasaro taŋgurí. Ko o soso tunoqaró ŋuro mande piŋa Judia koro mira purí-purímo yendé soso ŋuno uró. ");
INSERT INTO nca_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Uni soso piŋa mande iŋoro iŋondata tero ŋande osese taŋgurí, “Simó ŋuko, date uni ka tunoqeweya?” yaŋgurí. Hamó, Uni Parámimboro kandí simó ŋu saŋano yora. ");
INSERT INTO nca_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Asa Yuqa Surumí ŋundo iwí Sekaraiako maŋgoriní ye-ye mande ka ŋande yaró, ");
INSERT INTO nca_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Nore Uni Parámi, Israel koro Anutu ŋuro owí hokato. Dokoro enendo mahero eneŋo unipareyó kimo yerero ");
INSERT INTO nca_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","unipare rambaruru koŋgo yorewero quro eneŋo sunará simóŋo Dewit koro sowe qu ka riní otoqaró. ");
INSERT INTO nca_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Komo suki Anutuko o ŋuro eneŋo ye-ye uni meté horé maŋgoyemo yaró. ");
INSERT INTO nca_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ŋande yaró, ko saŋgirínani moŋgo nore norero uni newonde piyimi te yunoyoteŋgo qu kandeye moŋgo yoreweya. ");
INSERT INTO nca_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ŋunde tero usisambananimboro sikíye te yunoro mande kondé surumí komo kusiyaró ŋu iŋoyote. ");
INSERT INTO nca_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Mande kondé ŋunde yero usinani Abraham ŋande miraró, ");
INSERT INTO nca_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ko uni saŋgirí kandeye moŋgo nore noriní khoyó meté tewero quro kama sorewero ");
INSERT INTO nca_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","naru rokóŋoro eneŋo toŋímo otete roneneŋowí howero meté horé tero kho ŋu tewato. ");
INSERT INTO nca_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Naŋone, ke Anutu Koreko Horé yote ŋuro ye-ye uni ka, ye neko kerewaŋgo. Dokoro keto koretero uyaro Uni Parámimboro kheyó roŋgaruwoweya. ");
INSERT INTO nca_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ŋunde tero keto eneŋo unipareyó ŋande yimitoyoweya, ko enendo quhuríye se rotoro rambaruru koŋgo yoreweya. ");
INSERT INTO nca_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Dokoro enendo newonde surumí tero nore sikínani te nunoyote. Ŋu muríwore kosa areró ŋundo kore koŋgo noreno mahero ");
INSERT INTO nca_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","uni huririko yoteŋgo quya kindo khumowero kusuŋoyómo yoteŋgo quya hiyó yunoro khe newonde ime qu nore witú yereweya.” ");
INSERT INTO nca_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Asa simó ŋu wotero parámi tiní yuqayó wimbí kondériní uyaro mira wimbímo kunditero, yate-yate Israel ŋunoko tunomo yoweya quro soparó. ");
INSERT INTO nca_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ŋu naruko ŋuno Rom koro wiri yerete uni parámi horé ŋu, owí Sisa Okastus, ŋundo hutuŋo mande ka raró. Hutuŋo mande ŋuko ŋandiro: unipare soso enendo wiri yereyara ŋundo owéye nakayáŋowaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Uni kembé ka, owí muko Kwirinius, ŋundo Siria mira parámi ŋu sopoyaró naruyómo ŋunoko, unipare naru korete qunoko ŋunde owéye nakayáŋoyaŋgo.) ");
INSERT INTO nca_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Wiri yerete uni ŋundo hutuŋo mande ŋunde yiníqo, unipare soso eneŋo yendéyemo owéye nakayáŋowero toŋeŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Asa uni ka, owí Josep, Galili mira koro yendé ka owé Nasaret ŋuno yora. Quko eneko Dewit koro sowe qu ka. Ŋunde ŋuroko Nasaret rotoro Judia mirako oro Dewit koro yendé ŋu, Betlehem ŋuno oró. ");
INSERT INTO nca_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josep koya Maria koya epe re-re tewero ye iŋoyariyó. Ŋunde ŋuroko owéyari nakayáŋowero oriyó. Ŋu naruko ŋuno Maria qahu taró. ");
INSERT INTO nca_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Betlehem ŋuno yate Maria simó pisiyowero naruyó tunoqiní ");
INSERT INTO nca_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","simó urumuni ka, simó korete qu pisiyaró. Pisiyo rotoro tuwipo pokamoro makao koro kondó quroko rotaró, dokoro ya etewero ŋuko maŋgoraró. ");
INSERT INTO nca_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ŋu suwono ŋuno sipsip sopo-sopo uni yendé sumeyoro ŋuno sipsip sopo yereyaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Sopo yiri Uni Parámimboro sambo simó ka eneno umbuní, Uni Parámimboro sine parámi tunoqiní qenero sasaro parámi taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Sambo simó ŋundo ŋande yimiraró, “Ye sasaro ma tewero. Iŋoyi. Nondo miti mande ka re yeno umbuteno. Mande ŋako unipare soso iŋoro niŋgu-niŋgu parámi tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Itakako Dewit koro yendémo ŋuno pare kato Rambaruru Koŋgo Yorewero Uni ka pisiyote. Ŋuko Kristo, Uni Parámi ŋu. ");
INSERT INTO nca_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ko ye rokó ŋande naŋge qene iŋowaŋgo, asa simó pisiyoro tuwipo pokamoro makao koro kondó quroko raŋgo qu qenewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ŋunde yiní waka ta sambo simó qambu taŋgímo tunoqero Anutu seré te inoro ŋande yaŋgurí, ");
INSERT INTO nca_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Koreko horé ŋuno Anutuko owé parámi rete ko nokono ŋano newonde meté unipare yunoní newonde ime yoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ŋunde yi kini tiní yorotoro samboko oŋgurí. Oyi, sipsip sopo-sopo unindo epe mito-mito ŋande taŋgurí, “Nore Betlehem yendémo uyaya Uni Parámimbo o tiní tunoqete ŋuro nimiroteŋgo ŋu qeneto.” ");
INSERT INTO nca_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ŋunde yero kheŋgeŋo uro seqa yerero Maria, Josep, simóyari makao koro kondó quroko eteyaró ŋu yiyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Yiyoro sambo simómbo mande soso simó ŋuro yaró ŋuro yimiraŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kowe unipare soso ŋu iŋoro iŋondata parámi taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Quko Mariako mande ŋu re newondímo rero ŋu iŋo yora. ");
INSERT INTO nca_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sipsip sopo-sopo uni ŋundo roto toŋero o soso qenero iŋaŋgurí ŋuro Anutu owí hokoro seré te inoyaŋgurí. Dokoro sambo simómbo yimiraró ŋu naŋge tunoqaró. ");
INSERT INTO nca_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Asa nimímbo pisiyoní, yate naru kande saŋiyoro kapusa rotoní kowí toŋowero naruyó tunoqaró. Ŋunde tero owí Yesu yariyó. Komo, nimí qahu kama teyoní, sambo simó ŋundo owé ŋu nekaró. ");
INSERT INTO nca_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moses koro hutuŋo mande ŋundo ŋande yaró, pareto simó pisiyoro Anutu toŋímo pusú tero, yate kosa naru 40 ŋunde kini taró. Asa naru ŋu kini tiníqo, yereka irisa ŋundo simóyari rero Uni Parámi inowero quro Yerusalem oriyó. ");
INSERT INTO nca_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Oro Uni Parámimboro hutuŋo mande ŋu howariyó. Hutuŋo mande ŋundo ŋande yete, “Simó urumuni korete ŋuko soso Uni Parámimboro qu naŋge.” ");
INSERT INTO nca_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Oro nú irisa siyoro, nimímboro o qa-qa te inowaro, ye iŋariyó. Dokoro Uni Parámimboro hutuŋo mande ŋundo ŋande yete, “Nú irisa parámi mu ma nú simó irisa meté se inoyi qembe.” ");
INSERT INTO nca_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ŋu naruko ŋuno uni ka, owí Simeon, ŋundo Yerusalem ŋuno yora. Eneko uni roneneŋowí, ko Anutu koro murí ŋu okeyá ta howero Anutuko Israel unipare newondeye rukiso yereweya ŋuro sopoyara. Kowe Yuqa Surumí ŋundo eneno maŋgoraró. ");
INSERT INTO nca_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Komo qu ete-eteko Yuqa Surumí ŋundo ŋande miraró, ko koretero enendo Uni Parámimboro Kristo ŋu qeneroqota meté khumoweya. ");
INSERT INTO nca_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Asa uni ŋu, Yuqapo maŋgoriní, Ya Surumímo oró. Ŋunde tero oní Yesu koro iwí-nimí ŋuya hutuŋo mande howewero Yano oriqo, ");
INSERT INTO nca_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon simó ŋu rero kandímbo toworo Anutu owí hokoro ŋande yaró, ");
INSERT INTO nca_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Uni kembéŋe, itaka keŋo mandeke howero sunará simóŋge no norotoka newonde ime tero khumowano. ");
INSERT INTO nca_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Dokoro toŋenembo keto dani asáŋoyi nore rambaruru koŋgo noreweya ŋu qeneteno. ");
INSERT INTO nca_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Keto o teweya ŋu unipare soso toŋeyemo roŋgaruwaró. ");
INSERT INTO nca_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ŋundo uni wini meyowo ŋu yoriní hiyóqewaŋgo, ko enendo unipareke Israel ŋu owé parámi yunoweya.” ");
INSERT INTO nca_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ŋunde yiní iwí-nimímbo eneŋo simóyari ŋuro mandí iŋoro iŋondata parámi tariyó. ");
INSERT INTO nca_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Asa Simeonko puriŋo yunoro nimí Maria ŋande miraró, “Qeno, Anutuko simó ŋa riní enewore Israel unipare kumi umbu raŋowaŋgo, ko kumi otoqowaŋgo. Ko enendo rokó ŋunde qembe tunoqiní unipareto qenero yesaráŋoyi ");
INSERT INTO nca_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","iŋo-iŋoyemboro kiraróye tunomo yoweya. Ko o tunoqeweya ŋuko suke qembe keŋo newondeke ŋuya saŋgawoweya.” ");
INSERT INTO nca_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ŋu naruko ŋuno ye-ye pare ka, owí Ana, ŋundo ŋuno yora. Ŋuko Panuel nambuní, Aseri koro sowe qu ka. Enendo koŋgomu piyimi taró. Komo epe re-re tero kumima naru kande saŋiyoro irisa kamímboya yorariyó. ");
INSERT INTO nca_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Imemoŋgo wapu tero kumima naru 84 ŋunde rotaró. Naru rokóŋoro Ya Surumí kama rotoro kosa suwo kundiŋi tero hariri tero Anutu potoruku te inoyara. ");
INSERT INTO nca_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Asa ŋu naru ŋunoko taŋgeyemo mahero Anutu yuŋgunaŋoro unipare soso Anutuko Yerusalem pitu ko kimoweya ŋuro sopoyaŋgo qu simó ŋuro yesoworo yimitoyaró. ");
INSERT INTO nca_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Asa irisako Uni Parámimboro hutuŋo mande okeyá ta howiri kini tiní rohoréŋoro eneŋo yendéyari Nasaret, Galili mirako ŋuno uriyó. ");
INSERT INTO nca_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ŋuno yororiyate simó ŋu wote parámi tero wimbí tero iŋo-iŋo meté horé taró. Ko Anutu koro samaka-samaka tuwó ŋu eneno yora. ");
INSERT INTO nca_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kumima naru rokóŋoro iwí-nimímbo Yerusalem oro o ne-ne ka, owí Taka yereró, ŋu nariyó. ");
INSERT INTO nca_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Asa Yesu kumima naru 12 ŋunde rotoroqo muríye howero eneya o ne-neko ŋuno oró. ");
INSERT INTO nca_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Oyi naru ŋu kini tiníqo, iwí-nimímbo yendé parámi ŋu roto toŋeriyó. Quko Yesu enemata Yerusalem ŋuno yoní iwí-nimímbo ŋuro kama iŋariyó. ");
INSERT INTO nca_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","“Eneko unipare keweroyemo uyarete,” ye iŋoro kosa naru kanata ŋunde khewore uyaririyó. Suwo tiníqo, suwisawiyariwore topo-topoyariwore seqayate ");
INSERT INTO nca_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","kama qenero rohoréŋoro Yerusalem ŋuno seqawero pitu ko oriyó. ");
INSERT INTO nca_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Oro seqayori naru kapusa ŋunde rotoro Ya Surumí ŋuro yendémo ŋuno oro qeneriyó. Qeniri rondaqe-rondaqe uni keweroyemo ŋuno kunditeyoní mande yi iŋoro osese yereyaró. ");
INSERT INTO nca_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Uni soso eneŋo mandí iŋoro newondeye uroní niŋgu-niŋgu taŋgurí. Dokoro, eneko simó tomó ta ka, quko iŋo-iŋoyó meté horé, ko mande topé meté yaró. ");
INSERT INTO nca_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Iwí-nimí qenero iŋoro kondé yukuwariyó. Ko nimímbo ŋande miraró, “Naŋone, ke do karo otete ŋa noreno tete? Noya awaŋgepoya newondenari quhurí tiní nore ke seqa kereyotero.” ");
INSERT INTO nca_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yiní mande topé ŋande yaró, “Do karo yari no seqa nereyotiri? Yarimbe kama iŋoyotiri, nondo awanemboro o qu naŋge teyowano?” ");
INSERT INTO nca_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ŋunde yaró, quko iwí-nimí mande ŋuro murí kama iŋori tondaŋaró. ");
INSERT INTO nca_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Asa enendo iwí-nimímboya toŋero Nasaret ŋuno uŋgurí. Ko naru rokóŋoro iwí-nimí mandeyari howeyara. Kowe nimímbo o tunoqaró ŋu soso se newondímo rero iŋondaŋeyara. ");
INSERT INTO nca_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu wote parámi tero, iŋo-iŋoyó meté horé tiní Anutu koya unipare ŋuya ŋuro hamó-hamó iŋoyaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Naru kano Rom koro wiri yerete uni parámi horé ŋu, owí Sisa Taiperius, unipare wiri yereró ŋuro naruyó muko kumima naru 15 ŋunde rotaró. Ŋu naruko ŋuno Pontius Pailatko Judia mira ŋu sopo yereró, ko Herotko Galili mira ŋu sopo yereró, ko Herot koro koneyó Filip ŋundo Ituria mira ŋuya Tirakonitis mira ŋu sopo yereró, ko Lisaniasko Apilene mira ŋu soparó. ");
INSERT INTO nca_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ŋuya o qa-qa unindoro tapá uni irisa ŋu yorariyó. Owéyari muko Anas koya Kaiapas koya. Asa ŋu naruko ŋuno Jon, Sekaraia naŋuní, ŋundo mira wimbímo yoníqo, Anutu koro mande ka eneno mahiní iŋaró. ");
INSERT INTO nca_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Iŋoro mira soso Jotan Sono sumeyoro ŋuno uyare mahe tero unipareno mande yesowoyara. Mande ŋuko ŋandiro, “Ye quhuríyemboro newonde surumí teya quhurí ŋu se rotoya, sono rika Anutuko quhuríye soso se rotoweya.” ");
INSERT INTO nca_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","O teyara ŋuko, komo quno ye-ye uni Aisaiako sokomeko ŋande nakayáŋaró, “Enendo mira wimbímo mahero neko yerero ŋande yimiroweya, ‘Uni Parámimboro khe roŋgaruwoya eneŋomboro ore roneneŋoyi qembe.’ ");
INSERT INTO nca_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Sono koŋó ŋu soso noko toŋo riní maŋgoreweya, ko mira purí-purí ŋu soso wendaqi umbuweya, o iri-erá ŋu soso riní roneneŋoweya, ko khe pitipotó ŋu soso roŋgaruwoyi kararaŋiwí teweya. ");
INSERT INTO nca_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ko unipare sosopo Anutuko rambaruru koŋgo yoreweya ŋu qene iŋowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ŋunde ŋuroko Jonko unipare qambu sono rewero quro eneno maheŋgurí ŋu ŋande yimitoyaró, “Ye sire piyimi ŋuro simó ŋu! Anutuko newonde saŋgirí tero unipare o piyimi teyoteŋgo ŋu rambaruru yerewero tete. Ye dando yimironí sore naru piyimi ŋu takawero sono reteŋgo? ");
INSERT INTO nca_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ŋunde ŋuroko newonde hamó rohoréŋaŋgurí ŋuro eŋgé rika tunoqiní. Ko kina ŋande ma iŋowero, ‘Abrahamko noreŋo usinani.’ Dokoro no ŋande ye yimiroteno, Anutuko meté yiní wondo ŋu rohoréŋoro Abraham koro usi-sí tunoqewaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Itaka ka soporo te toŋowero quro te hurímo yote. Ŋunde ŋuroko te soso eŋgé meté mu kama teyoteŋgo ŋuko toŋoro kewáko raŋoweya.” ");
INSERT INTO nca_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ŋunde yiní unipare qambu ŋundo ŋande oseseyaŋgurí, “Asa ko nore date tewato?” ");
INSERT INTO nca_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yi mande topé yaró, “Uni ka kowe punu-punuyó irisa moré ŋundo kanata re kowe punu-punuyó moré kini ŋu inoweya. Ko uni ka o newero qu parámi ŋundo o kumi siyoro uni o newero qu moré kini ŋu inoweya.” ");
INSERT INTO nca_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takis re-re uni kumimbo ŋuya sono rewero mahero ŋande oseseyaŋgurí, “Rondaqe-rondaqe uni, nore date tewato?” ");
INSERT INTO nca_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ŋunde yiqo, ŋande yimiraró, “Ye takis ŋuro rokóŋo hamó qu naŋge siyoyi. Oka ka ŋuya ma rewero.” ");
INSERT INTO nca_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kuma uni kumimbo ŋuya oseseyaŋgurí, “Ko nore date tewato?” Ŋunde yi ŋande yimiraró, “Ye wimbí tero uniparetoro mone qu ma woso rewero, ko kota yero mande kho ma yunowero. Yeŋo kimoye ŋuro naŋge metéŋoyi.” ");
INSERT INTO nca_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Asa unipareto Kristo maheweya ŋuro sopoyaŋgo, ko ene soso newondeyembo ŋande yero iŋaŋgurí, ko Jon ŋumbeka Kristo ŋuno qu, yero iŋaŋgurí ");
INSERT INTO nca_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Asa ko Jonko ŋande yimiraró, “Nondo ye sonono kina sono re yunoteno. Quko uni ka tukú maheweya ŋuro wimbímboko nene wimbune ŋu takate. Nondo eneŋo khe punu-punuyómboro utó orosoyewero owé moré kini. Ko enendo Yuqa Surumí ŋuya kewá ŋuya toworo sono qembe re yunoweya. ");
INSERT INTO nca_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Usú ka re towo mahero wit eŋgémboya murutómboya rondaŋeweya. Rondaŋero wit eŋgé se yano kopoweya. Quko murutómi muko se kewá ka kama khumoyote quno ŋuno qaweya.” ");
INSERT INTO nca_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jonko mande qambu ŋunde yero newondeye rukisoyoro miti mande ŋu yesowoyara. ");
INSERT INTO nca_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Quko enendo uni kembé Herot ŋu roŋgaruwaró, dokoro Herotko payómboro parí qu, owí muko Herotias, ŋu rero o kumi meyowo piyimi mu te inoyaró. ");
INSERT INTO nca_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ŋunde ŋuroko Herotko oteteyó piyimi mu sowe tero Jon toworo kusi-kusi yano rotaró. ");
INSERT INTO nca_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Asa Jonko unipare sono re yunoro, yate Yesu ŋuya sono re inaró. Ŋunde tiní Yesuko hariri teyoní sambo mako kosoní ");
INSERT INTO nca_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Yuqa Surumí nú parámi ŋunde qembe tero ene saŋano umburó. Ko sambo koŋgo neka ŋande umburó, “Keko neneŋo naŋone, keŋo surumí iŋoyoteno. Keŋo meté kereyoteno.” ");
INSERT INTO nca_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Asa Yesuko hurí tero eneŋo kho taró quno kumima naru 30 ŋunde rotaró. Unipare soso ŋandiro ye iŋaŋgurí, ene Josep koro naŋuní. Josep ŋuko Heli koro naŋuní. ");
INSERT INTO nca_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli ŋuko Matat koro naŋuní. Matat ŋuko Liwai koro naŋuní. Liwai ŋuko Meliki koro naŋuní. Meliki ŋuko Janai koro naŋuní. Janai ŋuko Josep koro naŋuní. ");
INSERT INTO nca_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep ŋuko Matatias koro naŋuní. Matatias ŋuko Amos koro naŋuní. Amos ŋuko Nahum koro naŋuní. Nahum ŋuko Esili koro naŋuní. Esili ŋuko Nakai koro naŋuní. ");
INSERT INTO nca_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakai ŋuko Mat koro naŋuní. Mat ŋuko Matatias koro naŋuní. Matatias ŋuko Semen koro naŋuní. Semen ŋuko Josek koro naŋuní. Josek ŋuko Jota koro naŋuní. ");
INSERT INTO nca_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jota ŋuko Joanan koro naŋuní. Joanan ŋuko Resa koro naŋuní. Resa ŋuko Serupapel koro naŋuní. Serupapel ŋuko Sealitiel koro naŋuní. Sealitiel ŋuko Neri koro naŋuní. ");
INSERT INTO nca_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ŋuko Meliki koro naŋuní. Meliki ŋuko Ati koro naŋuní. Ati ŋuko Kosam koro naŋuní. Kosam ŋuko Elamatam koro naŋuní. Elamatam ŋuko Er koro naŋuní. ");
INSERT INTO nca_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ŋuko Josua koro naŋuní. Josua ŋuko Eliesa koro naŋuní. Eliesa ŋuko Jorim koro naŋuní. Jorim ŋuko Matat koro naŋuní. Matat ŋuko Liwai koro naŋuní. ");
INSERT INTO nca_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Liwai ŋuko Simeon koro naŋuní. Simeon ŋuko Juda koro naŋuní. Juda ŋuko Josep koro naŋuní. Josep ŋuko Jonam koro naŋuní. Jonam ŋuko Eliakim koro naŋuní. ");
INSERT INTO nca_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim ŋuko Melea koro naŋuní. Melea ŋuko Mena koro naŋuní. Mena ŋuko Matata koro naŋuní. Matata ŋuko Natan koro naŋuní. Natan ŋuko Dewit koro naŋuní. ");
INSERT INTO nca_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dewit ŋuko Jesi koro naŋuní. Jesi ŋuko Opet koro naŋuní. Opet ŋuko Boas koro naŋuní. Boas ŋuko Salamon koro naŋuní. Salamon ŋuko Nason koro naŋuní. ");
INSERT INTO nca_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason ŋuko Aminatap koro naŋuní. Aminatap ŋuko Atimin koro naŋuní. Atimin ŋuko Areni koro naŋuní. Areni ŋuko Hesiron koro naŋuní. Hesiron ŋuko Peres koro naŋuní. Peres ŋuko Juda koro naŋuní. ");
INSERT INTO nca_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda ŋuko Yakop koro naŋuní. Yakop ŋuko Aisak koro naŋuní. Aisak ŋuko Abraham koro naŋuní. Abraham ŋuko Tera koro naŋuní. Tera ŋuko Nahor koro naŋuní. ");
INSERT INTO nca_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor ŋuko Seruk koro naŋuní. Seruk ŋuko Reu koro naŋuní. Reu ŋuko Pelek koro naŋuní. Pelek ŋuko Eper koro naŋuní. Eper ŋuko Sela koro naŋuní. ");
INSERT INTO nca_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela ŋuko Kainan koro naŋuní. Kainan ŋuko Aripakasat koro naŋuní. Aripakasat ŋuko Siem koro naŋuní. Siem ŋuko Noa koro naŋuní. Noa ŋuko Lamek koro naŋuní. ");
INSERT INTO nca_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek ŋuko Metusela koro naŋuní. Metusela ŋuko Enok koro naŋuní. Enok ŋuko Jaret koro naŋuní. Jaret ŋuko Mahalalel koro naŋuní. Mahalalel ŋuko Kenan koro naŋuní. ");
INSERT INTO nca_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan ŋuko Enos koro naŋuní. Enos ŋuko Set koro naŋuní. Set ŋuko Atam koro naŋuní. Atam ŋuko Anutu koro naŋuní. ");
INSERT INTO nca_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Asa Yesuko Yuqa Surumímbo newondímo maŋgoriní rohoréŋoro Jotan Sono rotoro oro mira wimbímo ŋuno oro yateyoní Yuqapo khe witúŋaró. ");
INSERT INTO nca_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Mira ŋuno yoní naru 40 ŋunoko Monimbuko Yesu towoŋaró. Ŋu naruko ŋuno Yesu o kama nero, yate qímboro khumaró. ");
INSERT INTO nca_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Khumoyoní Monimbuko ŋande miraró, “Ke hamó Anutu koro Naŋuní tiníkaqo, yeka wondo ŋa rohoréŋoro bret ka tunoqiní,” yaró. ");
INSERT INTO nca_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yiní Yesuko mande topé ŋande yaró, “Sokomeko ŋuno ŋande nakayáŋaró, ‘Unipareto o qoyemboro quwore naŋge yoto-yoto kama rewaŋgo.’” ");
INSERT INTO nca_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ŋunde yiní Monimbuko re wosoro mira purímo oro naru tukuni quno naŋge Yesu mira purí moŋgo uniparetoro miraye soso ŋu witúŋaró. ");
INSERT INTO nca_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Witúŋoro ŋande miraró, “Nondo wimbu kondé re kunowe mira soso ŋuya o meté-metéye mu ŋuya sopoweya. Wimbu ŋuko neneŋo naŋge. Neneŋombo uni ka inowano. ");
INSERT INTO nca_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Asa ke no potoruku te nunoka o soso ŋa se kunowano.” ");
INSERT INTO nca_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yiní Yesuko mande topé ŋande yaró, “Sokomeko ŋuno ŋande nakayáŋaró, ‘Ke Uni Parámi, keŋo Anutuke ŋuro potoruku te inoya eneŋo khoyó naŋge te qembe.’” ");
INSERT INTO nca_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ŋunde yiní re wosoro Yerusalem uyaro rero Ya Surumímboro umó saŋano rotoro ŋande yaró, “Ke hamó Anutu koro Naŋuní tiníkaqo, ŋa noŋgo amuno soreka kiyowe. ");
INSERT INTO nca_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Dokoro, sokomeko ŋande yete, “‘Enendo sambo simóŋo yimironí sopo kere meté roŋgaru kereyowaŋgo, ");
INSERT INTO nca_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ko kandeyembo hokoro koro kiri wondo kato khíndoŋgemo kama saŋga kereweya.’” ");
INSERT INTO nca_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yiní Yesuko mande topé ŋande yaró, “Sokomeko ŋuno ŋande nakayáŋaró, ‘Ke Uni Parámi, keŋo Anutuke, ma towoŋowero.’” ");
INSERT INTO nca_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Monimbuko Yesu towoŋoní kini tiní rotoro naru kano quro soparó. ");
INSERT INTO nca_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Asa Yesuko rohoréŋoro Yuqa koro wimbímo Galili mirako ŋuno pitu ko uyaró. Uyariní unipare mira soso ŋu noŋgo qundo eneŋo mande piŋa ŋu iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Huru-huru yayemo ŋuno oro Anutu koro mandí rondaqe yunoyaró. Ko unipare soso eneŋo owí hokoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yate-yate Sapat naru kanoko Nasaret yendémo ŋuno uyaró. Yendé ŋuno ene simó tomó ta yate ŋuno parámi taró. Asa ŋu naruko ŋuno eneŋo murí howero huru-huru yano oró. Oro Anutu koro sokome qu weyowero otoqo kaŋaró. ");
INSERT INTO nca_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kaŋiní sopo-sopo uni ŋundo Aisaiako mande nakayáŋaró ŋuro sokome qu ŋu re inoní rosaraqero mande ŋu weyoro ŋande yaró, ");
INSERT INTO nca_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“‘Uni Parámimboro Yuqayómbo no saŋanemo yote. Ŋunde ŋuro enendo no rokó niriní uni owéye moré kini ŋu piŋa mande meté yero yimirowano. Enendo asá niriní uni kusi-kusi yano yoteŋgo ŋu kinaŋge toŋewaŋgo ŋuro yesowowano, uni toŋeye piyimi mu pitu ko toŋetewaŋgo ŋuro yesowowano, uni quhurí koro kusuŋoyómo yoteŋgo ŋu yorewe kina toŋewaŋgo, ");
INSERT INTO nca_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Uni Parámimboro naruyó meté ŋuro yesowowano.’” ");
INSERT INTO nca_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ŋunde weyoro sokome ŋu wakaro sopo-sopo uni ŋu inoro kunditaró. Ko unipare huru-huru yano yaŋgo ŋu soso Yesuko toŋetaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Asa hurí tero ŋande yimiraró, “Mande ŋano qu komo suki sokomeko nakayáŋaró ŋako itakako hamó tunoqete.” ");
INSERT INTO nca_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ŋunde yiní owí hokoro eneŋo maŋgómbo mande meté ŋunde qu yaró ŋuro iŋondata parámi tero ŋande epe mito-mito taŋgurí, “Uni ŋuko Josep koro naŋuní naŋge, ŋuko hamómbe?” ");
INSERT INTO nca_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ŋunde yiqo, ŋande yimiraró, “Ye tapara mande ŋambe ye nimirowaŋgo, ‘Dota, keŋo o piyimi ŋu reka meté tiní,’ yewaŋgo, ko, ‘O soso Kaperneam yendémo ŋuno taró ŋu naŋge ŋa mirako ŋano te,’ ye nimirowaŋgo, peka. ");
INSERT INTO nca_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","No mande hamó ye yimiroteno, Anutu koro ye-ye unindoro mirako ŋuno simburí muko ye-ye uni ŋuro mandí ŋu kama iŋoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Hamó yeteno, Elaija koro naruko ŋuno Israel mirako ŋuno wapu qambu yoraŋgurí. Ŋu naruko ŋuno kumima naru kapusa ko kombo kande saŋiyoro kanata ŋunde rotoro Israel mirako ŋuno sono kama umbuyaró. Ŋunde tiní korare parámi tunoqaró. ");
INSERT INTO nca_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Quko Anutuko Elaija wapu ŋunde qu kano kama asáŋaró. Kini, mira meyowomo wapu ka, Sarepat yendé ŋu Saiton mira ŋuno wapu kano, ŋuno asáŋoní toŋeró. ");
INSERT INTO nca_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ŋuya ye-ye uni Elisa koro naruko ŋuno Israel mirako ŋuno koweye piyimi khumo uni qambu yoraŋgurí. Quko enendo se khumo uni ŋunde qu kama yoriní sara taró. Kini, Siria uni ka owí muko Naman, ŋu naŋge riní sara taró.” ");
INSERT INTO nca_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ŋunde yiní unipare huru-huru yano yoraŋgo ŋu mande ŋu iŋoro saŋgirí parámi taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ŋunde tero otoqoro Yesu toworo yendé tapémo oŋgurí. Yendéye ŋuko mira purí titinímo yaró. Asa Yesu rero, purí sombé moŋgo raŋato, yero oŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Quko keweroyewore kinaŋge yorotoro toŋeró. ");
INSERT INTO nca_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Asa Yesuko Galili koro yendéyó qu ka, Kaperneam yendé ŋuno oro Sapat naruko ŋuno Anutu koro mandí rondaqe unipare yunaró. ");
INSERT INTO nca_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yunoyoní eneŋo mandí iŋoro kondé yukuwaŋgurí. Dokoro mande yaró ŋuko wimbí moré. ");
INSERT INTO nca_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Naru kano uni ka yuqa pusú eneno yaró ŋu huru-huru yano ŋuno yora. Ŋuno yotoro parámi ŋande ye kiwaró, ");
INSERT INTO nca_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Aine, Yesu Nasaret noŋgo, do nereweya? Kepe nore rowore nerewero mahetepe? No iŋo kunoteno, keko Anutu koro uni meté horé ŋu.” ");
INSERT INTO nca_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ŋunde yiní Yesuko ŋande qene yaró, “Ke maŋgoke kusiyoya uni ŋu roto toŋe!” Yiní yuqa piyimimbo uni ŋu re raŋoní nokono unipare keweroyemo umbuní roto toŋero kaŋuya kama roworemaró. ");
INSERT INTO nca_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Unipare soso ŋu newondeye yukuwoní epe mito-mito ŋande taŋgurí, “Enendo mande wimbí moré date qu yero yuqa pusú ŋu mepémo sopo yiriní roto toŋewaŋgo?” ");
INSERT INTO nca_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ŋunde yiqo, imemoŋgo Yesu ŋuro mande piŋa ka wimbo-wimbo uyaró. ");
INSERT INTO nca_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Asa Yesu huru-huru ya rotoro Saimon koro yayómo oró. Saimon koro koŋgí ŋuko kowí tiwi riní Yesuko samakaŋoní yero nekaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nekoyi uyaro taŋgímo kaŋero se khumo ŋu qene yiní kini tiní pare ŋu waka ta otoqoro o qoyemboro roŋgaruwaró. ");
INSERT INTO nca_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kosa pusuŋiní uni kumimbo topo-topoye se khumo enesó-enesó teyaŋgo ŋu yore eneno maheŋgurí. Ŋuno mahiqo, Yesuko kandí kanata-kanata saŋayemo riní meté taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ko yuqa piyimi kumi yohowiní uni qambu ŋu roto toŋeŋgurí. Toŋero yuqa piyimi ŋundo ki kondé tero, “Keko Anutu koro Naŋuní,” yaŋgurí. Quko, ŋunde ma yewero, ye soré yereró, dokoro ŋande iŋomukaŋgurí, ko eneko Kristo ŋu, yero iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ita saraŋoní Yesuko mira uni kinimo toŋiní unipare qambu ŋundo seqayate qenero, ma noroto toŋewero, ye soréŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Quko ŋande yimiraró, “Yendé meyowo ŋuno ŋuya Anutuko unipareyó wiri yereyote naruyó ŋuro miti mande ŋu yimitoyowano. Dokoro ŋu murí ŋuro asá niriní mahenowó.” ");
INSERT INTO nca_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ko huru-huru yayemo Judia mirako ŋuno mande yesowoyara. ");
INSERT INTO nca_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Naru kano Yesu Genesaret Sono Towo tapémo kaŋeyoní unipare qambu mahero Anutu koro mande iŋowero wuririyoro epe pito-pito taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ŋunde ti waŋgo tomó ta irisa sono towo tapémo ŋuno yorori yiyaró. Uni sono qare siyoyaŋgo kumimbo waŋgo ŋu rotoro tirí-tiríye ŋu se sonowoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Asa Yesuko Saimon koro waŋgoko ŋuno oro Saimon yiní waŋgo wosoní sono saŋano soŋga ta na uyaró. Uyariní Yesu waŋgo saŋano ŋuno kunditero unipare qambu ŋu mande rondaqe yunaró. ");
INSERT INTO nca_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mande yimironí kini tiníqo, Yesuko Saimon miraró, “Ye waŋgo ŋa reya tirí-tiríye sono towo meré piyimimo rotoyika ŋuno uweya,” yaró. ");
INSERT INTO nca_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Yiní mande topé yaró, “Awa, suwono kho parámi teyato saraŋote, quko nore sono qare ka kama siyato. Quko no keŋo maŋgoke howero tirí-tirí rotowe uweya,” yaró. ");
INSERT INTO nca_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Yero ene ŋunde tero sono qare parámi siyoyi tirí-tirí ŋu wamba wuriró. ");
INSERT INTO nca_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ko kho kopo topé waŋgo meyowomo ŋuno yoroyi neko yiri mahe samaka yereŋgurí. Ŋundiro tiqo, waŋgo irisa ŋu sono qareko maŋgoriní irisa ŋu sono quroko wamba uriyó. ");
INSERT INTO nca_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon-Pitako ŋu qenero Yesu khí rorowo kaŋero potoruku te inoro yaró, “Uni Parámi, no norotoya toŋe, dokoro no uni quhurí uni.” ");
INSERT INTO nca_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ŋunde yaró, dokoro eneya topé-topémboya sono qare parámi siyo qenero newondeye yukuwaró. ");
INSERT INTO nca_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saimon koro kho kopo topé irisa ŋu, Jems koya Jon, Sepeti koro naŋo-simó, ŋu ŋuya sono qare ŋu qenero iŋondataqariyó. Quko Yesuko Saimon ŋande miraró, “Ma sasaro tewero. Ŋa naruko ŋano unipare yowosoní Anutusina uyarewaŋgo,” yaró. ");
INSERT INTO nca_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ko waŋgo irisa ŋu sono towo tapémo yowosoro oye soso rotoro Yesu howaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Naru kano Yesu yendé kano yoníqo, uni ka ŋuno yora, kowí piyimi khumo ŋuko eneŋo kowí soso pokamaró. Asa Yesu qenero, potoruku rero umu-kembé nokono rero Yesu kirayaró, “Uni Parámi, keto ŋu iŋi mepémo tiníqo, no nori sara tewano.” ");
INSERT INTO nca_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesuko kandí saŋanímo rero miraró, “No ŋuro iŋoteno. Ke sara teweya.” Yiní waka ta se khumo ŋuno qu roto toŋeró. ");
INSERT INTO nca_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Rotoní Yesuko kondé ŋande miraró, “O ŋa keno tunoqete ŋaro uni ka ma yimirowero. Hutuŋo mande Mosesko yimiraró ŋu howeya o qa-qa uni koweke re witú yereya keto sara tunoqete quro oka Anutu te ino qembe. Ŋunde tiqo, se khumoke kini tete, ye iŋowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Quko Yesuko o taró ŋuro piŋa mandeyó ŋu mira soso uro toŋeró. Ŋunde ŋuro unipare qambu qundo, nore mandí iŋato se khumonani riní meté teweya, ye iŋoro eneno uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Quko enendo toŋero sikuno uyaro hariri teyara. ");
INSERT INTO nca_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Naru kano Yesuko mande rondaqero unipare yunoyaró. Yunoní Farisi unindoya hutuŋo mande ŋuro rondaqe-rondaqe unindoya kopo mahe kunditeyaŋgurí. Uni ŋundo Galili koro yendé soso ŋu noŋgo, ko Judia koro yendé soso ŋu noŋgo ko Yerusalem noŋgo ŋuya maheŋgurí. Asa Uni Parámimboro wimbí Yesu koya yoní ŋundo se khumo uni ŋu yoriní meté taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kowe uni kumimbo uni ka re koroworo maheŋgurí. Uni ŋu khí irisa-irisa ukumi riní yakutímo ŋuno eteyaró. Eteyoní re koroworo ya ka Yesu yaró quno ŋuno owero iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Quko unipare qambu horé ŋundo ya maŋgorero mako ŋuya wisumuŋaŋgurí. Ŋunde ŋuro ya umómo oro witú rero yakutí ŋu utómbo kusiyo ri ŋuwore ŋundo unipare keweroyemo umburo Yesu toŋímo yaró. ");
INSERT INTO nca_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesuko uni ŋuro iŋondutuye hamó qenero iŋoro ŋande yaró, “Topo, keŋo quhuríŋge se rotoní.” ");
INSERT INTO nca_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Hutuŋo mande ŋuro iŋo-iŋo unindoya Farisi unindoya newondeyemo ŋande yero iŋaŋgurí, “Ŋu danimbo Anutu yesaráŋoyote? Anutuko naŋge quhurí se rotowero wimbí tete.” ");
INSERT INTO nca_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Asa Yesuko iŋo-iŋoyemo osese-osese taŋgurí ŋu qene iŋoro mande topé yaró, “Dokoro ye newondeyemo osese ŋunde qu ye iŋoteŋgo? ");
INSERT INTO nca_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ye date iŋoteŋgo? Nondo, ‘Quhuríŋge se rotoní,’ ye mirowano tiníqo, ŋuko wuruwara mande peka, ye eŋgé qenewero mepémo kini. Quko, ‘Ke otoqoya khete-khete uyare,’ ye mirowano tiníqo, ŋuko mande quhurí horé, ŋuro eŋgé qene iŋomukowaŋgo, hamómbe? ");
INSERT INTO nca_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Quko ŋande iŋi, Unindoro Naŋuní ŋundo nokono ŋano unindoro quhuríye se rotowero quro wimbí tete.” Ŋunde yero uni khí piyimi ŋu ŋande miraró, “Nondo kimirowe, ke otoqoya yakutíŋge re korowoya yakemo u,” yaró. ");
INSERT INTO nca_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Waka ta uni ŋu otoqoro unipare toŋeyemo yakutíŋo re koroworo Anutu seré te inoro uyaro paseyómo oró. ");
INSERT INTO nca_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Oní unipare soso qenero iŋondutuye enesó-enesó taró. Qenero sasaro tero Anutu seré te inoro ŋande yaŋgurí, “Itaka o amana horé qeneteto.” ");
INSERT INTO nca_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Imemoŋgo Yesuko uyaro takis re-re uni ka, owí muko Liwai, ŋu qeneró quko takis rewero paseno ŋuno kunditeyaró. Kunditeyoní ŋande miraró, “Ke mahe no nohowe.” ");
INSERT INTO nca_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Yiní otoqoro oyó soso ŋuno rotoro uyaro Yesu howaró. ");
INSERT INTO nca_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ko Liwaiko Yesu koro o ne-ne parámi ka eneŋo yano ŋuno taró. Uni takis re-re uni qambu quya uni meyowo ŋuya o newero quro ŋuno eneya etaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farisi unindoya hutuŋo mande ŋuro iŋo-iŋo unindoya eneŋo iŋo-iŋo rewero uniyómboya kisikasa mande ŋande yaŋgurí, “Dokoro enendo takis re-re unindoya quhurí unindoya o kopo neyoteŋgo?” ");
INSERT INTO nca_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ŋunde yi Yesuko mande topé ŋande yaró, “Uni se khumoye moré kini muko dotako kama uwaŋgo. Kini. Se khumo uni ŋundo naŋge dotako uyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ŋunde naŋge no uni roneneŋowí neko yerewero kama umbunowó. Kini. Nondo quhurí uni ŋu neko yereweka newonde rohoré ti yero umbunowó.” ");
INSERT INTO nca_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Asa uni kumimbo Yesu koya ŋande yaŋgurí, “Naru kumimo Jon koro iŋo-iŋo rewero uniyómbo o newero ŋuro kundiŋi tero hariri teyoteŋgo. Farisi koro iŋo-iŋo rewero uni ŋuya ŋunde teyoteŋgo. Quko keŋo unike muko kinaŋge o qoyemboro neyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Kowe Yesuko ŋande yimiraró, “Ko uni kato epe re-re tewero o ne-ne naruko ŋuno topé-topémbo kundiŋi tewero mepémo kini, hamómbe? ");
INSERT INTO nca_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Quko imemoŋgo ta uni ŋu ri toŋeweya. Ŋu naruko ŋuno naŋge topé-topémbo kundiŋi tewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Asa Yesuko tapara mande ka ŋande yimiraró, “Ko uni kato tuwi keta qu romboŋero tuwi sumi ŋu rero tuwi komo quro wituyómo ŋuno kama tiŋiyoweya. Kini, ŋunde teweya quko tuwi keta ŋu rambaruruwoweya, ko tuwi komo ŋu kiraró enesó, tuwi sumi keta ŋuko enesó. ");
INSERT INTO nca_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ko uni kato wain keta qu re meme kowí puŋge komo quno ŋuno kama puŋgeyoweya. Kini, wain keta ŋuro yuqayómbo puŋge komo ŋu umboroŋoní wain ŋu hausuworo nokono umbuní puŋge ŋuya piyo teweya. ");
INSERT INTO nca_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Asa ko wain keta qu puŋge keta quno naŋge puŋgeyoyi qembe. ");
INSERT INTO nca_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ko uni kato wain komo qu ka neroqo keta quro kama iŋoyote, dokoro, ‘Komo ŋuko meté,’ ye iŋoyote.” ");
INSERT INTO nca_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Asa Sapat naru kano Yesu wit kho keweroko uyaro iŋo-iŋo rewero uniyómbo wit simó siyoro kandeyembo wit kowí rumuniŋoro siyi toŋiní se neyaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Quko Farisi uni kumimbo yiyoro ŋande yaŋgurí, “Hutuŋo mande ŋundo otete ŋu soréŋoro, Sapat naruko ŋuno ŋu ma tewero, yete. Ye do karo ŋunde teteŋgo?” ");
INSERT INTO nca_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yi Yesuko mande topé yaró, “Yembe komo Dewit koya topé-topémboya o taŋgurí ŋuro sowo mande ŋumbe kama weyo iŋaŋgurí, peka? Asa ŋu naruko ŋuno o qoyemboro khumoro ");
INSERT INTO nca_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dewitko Anutu koro yano oro bret ŋu Anutu toŋímo yara ŋu re umburo nero topé-topé yunoní naŋgurí. Quko bret ŋuro, hutuŋo mandeko ŋande yete, o qa-qa uni ŋundo naŋge bret ŋu newaŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ŋunde yero ŋande yimiraró, “Unindoro Naŋunímbo Sapat naru ŋu sopoyote.” ");
INSERT INTO nca_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Asa Sapat naru kano Yesu uyaro huru-huru ya quroko oro unipare mande rondaqe yunaró. Yunoní uni ka kandí kondésina ukumi rero khumaró qu ŋuno yora. ");
INSERT INTO nca_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Hutuŋo mande ŋuro iŋo-iŋo unindoya Farisi unindoya, Yesuko uni ŋu riní meté tiníqo, Sapat naruko kho ka tete ŋuro mande kho inowato, yero iŋoro toŋetaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Quko Yesuko iŋo-iŋoye qene iŋoro uni kandí piyimi ŋu mitoro ŋande yaró, “Ke otoqoya keweroyemo ŋano kaŋe,” yiní ŋunde taró. ");
INSERT INTO nca_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Asa Yesuko ŋande yimiraró, “Ye date iŋoteŋgo, Sapat naru ŋa do otete ka hutuŋo mande wendaqeweya? O meté tewatope ma o piyimi te inowato, asa uni ka roŋgaruwowatope ma urato khumoweya?” ");
INSERT INTO nca_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ŋunde yero uni soso ŋuno yiyoro uni ŋu ŋande miraró, “Kandeke raŋo,” yiní ŋunde tiní kandí pitu ko meté taró. ");
INSERT INTO nca_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Quko uni soso ŋundo saŋgirí parámi horé tero, Yesu do ka te inowato, yero epe mito-mito taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Asa naru kano Yesu hariri tewero uyaro mira purí kano oro Anutuwore hariri tero suwo doŋe-doŋe taró. ");
INSERT INTO nca_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ita saraŋoníqo, iŋo-iŋo rewero uniyó neko yerero uni keweroyemo 12 rokó yerero owé “asá yerewí uni” yunaró. ");
INSERT INTO nca_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Uni ŋuro owéye muko ŋandiro: Saimon, uni ŋu owé Yesuko, “Pita,” ye nekaró ŋu; Andru, Saimon koro koneyó ŋu; Jems; Jon; Filip; Bartolomeyu; ");
INSERT INTO nca_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu; Tomas; Jems, Alipeus koro naŋuní ŋu; Saimon, Selot koro wini qu ka; ");
INSERT INTO nca_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jutas, Jems koro naŋuní ŋu; ko Jutas Isikariot, uni ŋu imemoŋgo Yesu re uni piyimi kandeyemo rotaró. ");
INSERT INTO nca_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Asa Yesu mira purí moŋgo uro mira kuhú kano kaŋaró. Ŋuno eneŋo iŋo-iŋo rewero unipare qambu yoraŋgurí. Unipare meyowo qambu ŋuya yoraŋgurí. Unipare ŋu Judia mira koŋgo qu, Yerusalem noŋgo qu, ko windi tapéwore yendé irisa Tair koya Saiton koya ŋu noŋgo qu ŋuya yoraŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ene mandí iŋowero maheŋgurí. Ko ene se khumoye roŋgaruwoní meté tewaŋgo ŋuro maheŋgurí. Asa ko kumi yuqa pusú qundo rambaruru yereyaŋgo ŋu Yesuko roŋgaru yiriní meté taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Eneŋo wimbí kondé ŋundo se khumo unipare soso roŋgaru yiriní meté taŋgurí. Ŋunde ŋuro unipare qambu ŋu, Yesu kina pekáŋato, yero kandeye raŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ko Yesuko eneŋo iŋo-iŋo rewero unipareyó yiyoro ŋande yaró, “Ye owéye moré kini qundo, ye puriŋo ka reteŋgo, dokoro Anutuko ye wiri yereyote. ");
INSERT INTO nca_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ye itaka ka o qoyemboro khumoyoteŋgo qundo, ye puriŋo ka reteŋgo, dokoro Anutuko yoriní maŋgoreweya. Ye itaka ka tendoyoteŋgo qundo, ye puriŋo ka reteŋgo, dokoro imemoŋgo yomowaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Unindo ye Unindoro Naŋuní ŋu howeyoteŋgo ŋu iŋoro newonde saŋgirí te yunoro yohowero mande piyimi ye yunoro huwó mande yeyoteŋgo quno ŋuno yendo puriŋo ka reteŋgo. ");
INSERT INTO nca_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ŋu naruko ŋuno niŋgu-niŋgu parámi ti qembe, dokoro samboko ŋuno kimo parámi rewaŋgo. Hamó, komo eneŋo usisambayembo ye-ye uni ŋunde naŋge o piyimi te yunaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Quko ye onoŋoye moré mu, o ininiyaqe, dokoro oka newonde ime yunoweya qu ŋu komo remukaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ye itaka o ni qahuye tinditiní qu, o ininiyaqe, dokoro imemoŋgo o qoyemboro khumowaŋgo. Ye itaka yomoyoteŋgo qu, o ininiyaqe, dokoro imemoŋgo tendowaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Unindo yeŋo owéye hokiqo, o ininiyaqe. Komo, eneŋo usisambayembo ye-ye uni kota-kota ŋu ŋunde naŋge owéye hokaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Quko nondo ye mandene iŋoyoteŋgo ŋu ŋande yimiroteno, yeŋo saŋgiríye newonde meté yunoro murí meté uni yeya newonde piyimi teyoteŋgo quya te yunoyuri qembe. ");
INSERT INTO nca_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Danimbo takuni saŋayemo reweya, ŋu ye puriŋo yiri qembe. Ko danimbo yesará yereweya ŋuro hariri tika Anutuko ene samaka yiriní. ");
INSERT INTO nca_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ko uni kato kakíŋge kawore tamoníqo, rohoréŋoro kawore ŋuya ino qembe. Uni kato keŋo kowe punu-punu saŋanímo qu re wosoníqo, keŋo kowe punu-punu quroyómo qu ŋuya re ma soréŋowero. ");
INSERT INTO nca_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Uni kato o karo kira kereweya tiníqo, o ŋu ino qembe. Ko uni kato keŋo oke siyoweya tiníqo, ŋande ma mirowero, topé nuno qembe. ");
INSERT INTO nca_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Yendo unipareto otete soso yeno te yunowaŋgo ŋuro kondé iŋoyoteŋgo ŋuko, ye otete ŋu naŋge eneno te yunoyi qembe. ");
INSERT INTO nca_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ko yendo topoyemboro naŋge hamó iŋo yunoteŋgo tiníqo, owé meté ka rewaŋgo, peka? Kini, uni quhurí uni ŋuyako newonde meté eneŋo topo-topoye yunoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ko yendo uni yeya o murí meté te yunoyoteŋgo quya o murí meté te yunowaŋgo tiníqo, owé meté ka rewaŋgo, peka? Kini, uni quhurí uni ŋuyako murí ŋunde naŋge teyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ko yendo uni utatáyemboro topé ye yunowaŋgo ŋu naŋge utatáye yunoyoteŋgo tiníqo, owé meté ka rewaŋgo, peka? Kini, uni quhurí uni ŋuyako uni quhurí imemoŋgo topé tewaŋgo ŋu utatáye yunoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Quko ye saŋgiríyemboro iŋo inoro utatáye yunoyi qembe. Ko enendo utatáyemboro topé ye yunowaŋgo ŋuro ma iŋowero. Ye ŋunde tero imemoŋgo kimo parámi rero Anutu Koreko Horé yote ŋuro simó yowaŋgo. Dokoro enendo uni kama ene yuŋgunaŋoyoteŋgo quya o piyimi teyoteŋgo quya o meté te yunoyote. ");
INSERT INTO nca_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ye awayembo teyote ŋundiro naŋge uniro sikíye ti qembe. ");
INSERT INTO nca_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Uni karo muríye kama ronda yerewaŋgo tiníqo, Anutuko yeŋo muríye ŋuya kama ronda yereweya. Ye uni ka mande kho kama yunowaŋgo tiníqo, Anutuko mande kho ye ŋuya kama yunoweya. Uniro quhuríye se rotowaŋgo tiníqo, Anutuko yeŋo quhuríye ŋuya se rotoweya. ");
INSERT INTO nca_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","O se uni meyowo yunoyikata Anutuko o se ye ŋuya yunoweya. Enendo o meté kusíŋoní hamó maŋgorero umbuyote ŋu yunoweya. Dokoro yendo uni meyowo o yunoyoteŋgo ŋuro rokóŋo ŋuwore naŋge Anutuko meté te yunoweya.” ");
INSERT INTO nca_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Asa Yesuko tapara mande ka ŋande yaró, “Uni toŋí kiré kato toŋí kiré meyowo ka metémbe khe witúŋoweyape, ma kini? Kini, ene irisa-irisa rokaráŋoro meréko uwari. ");
INSERT INTO nca_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Iŋo-iŋo rewero simó ŋundo rondaqe-rondaqe uniyó kama takate. Quko iŋo-iŋo meté tiní asa ene otoqoro rondaqe-rondaqe uniyó qembe teweya. ");
INSERT INTO nca_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ke do karo topokeporo murutó ka toŋímo yote ŋu qene iŋoyote, quko ke te puŋo ka keŋo toŋeŋgemo yote ŋu kama qene iŋoyote? ");
INSERT INTO nca_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ko te puŋo ka keŋo toŋeŋgemo yote ŋu kama qene iŋoyoníqo, ke date tero topoke ŋande miroweya, ‘Topo, murutó toŋeŋgemo ŋu re rotowe?’ Ke uni maŋgoye irisa, koretero te puŋo parámi keŋo toŋeŋgemo yote ŋu re rotoroqota ke meté toŋetero murutó tomó ta topoke toŋímo yote ŋu meté se rotoweya. ");
INSERT INTO nca_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Qeni, te meté kato eŋgé piyimi mu kama eŋgé teyote. Ŋunde naŋge te piyimi kato eŋgé meté mu kama teyote. ");
INSERT INTO nca_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Dokoro, unindo eŋgé qenero te ŋuro kiraró qene iŋowaŋgo. Hamó, fik eŋgé ŋu te kunzi noŋgo kama siyoyoteŋgo, ko wain eŋgé ŋu kakari kewero koŋgo kama siyoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Uni meté ŋundo iŋo-iŋo meté qundo newondí riní maŋgoriní murí meté teyote. Uni piyimi ŋundo iŋo-iŋo piyimi qundo newondí riní maŋgoriní murí piyimi mu teyote. Ŋunde ŋuroko o piyimi naŋge teyote. Dokoro iŋondutu newondímo maŋgoreyoní ŋu maŋgómbo naŋge yeyote. ");
INSERT INTO nca_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ye dokoro no neko nerero, ‘Uni Parámi, Uni Parámi,’ yeteŋgo, quko ye mandene kama howeyoteŋgo? ");
INSERT INTO nca_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Uni kumimbo nono maheroqo mandene iŋoro howeyoteŋgo. Asa ko uni ŋunde quro tapara mande yewe teteno. ");
INSERT INTO nca_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Uni ŋunde qundo yayó reweya quno ŋuno koretero meré sero kandarama saŋano tatá raŋaró. Sono rirupo ya ŋu kikiŋoní ya ŋu kama huqeweya. Dokoro uni ŋuko paseyó kondé horé raró. ");
INSERT INTO nca_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Quko uni kato mandene iŋoro kama howeyote ŋuko ŋandiro, uni ka yayó kina nokono kaŋeweya, ko tatá noko quroko kama raŋaró. Sono rirupo ya ŋu kikiŋoní waka ta huqero soso piyo teweya. ");
INSERT INTO nca_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Asa Yesuko mande soso ŋu yiní unipareto iŋoyi kini tiní Kaperneam yendémo ŋuno oró. ");
INSERT INTO nca_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Yendémo ŋuno kuma unindoro sopo-sopo uni ka ŋuno yora, eneŋo kho simóŋo qu ka se khumo teyate wamba khumaró. Ko enendo kho simóŋo ŋuro parámi iŋoyara. ");
INSERT INTO nca_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Asa ene Yesu koro iŋaró quno ŋuno Juda koro uni kembé-kembéye yorero, Yesu miroyika mahe kho simóne riníka otoqoní, yero asá yiriní toŋeŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Toŋero Yesuko uyaro kondé kirayoro ŋande yaŋgurí, “Uni ŋuko uni meté, asa ko meté keto samakaŋoweya. ");
INSERT INTO nca_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Dokoro enendo noreŋo wininani iŋo yunoro huru-huru yanani ŋu raró.” ");
INSERT INTO nca_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ŋunde yiqo, eneya kopo uyareŋgurí. Uyaro yano kutaqemo uyari kuma unindoro sopo-sopo uni ŋundo topé-topé kumi asá yiriní eneŋo maŋgó rero Yesu ŋande miraŋgurí, “Uni parámi, enina, koweyumu ma tewero. No uni meté kini ŋuro ke neneŋo yano date areweya. ");
INSERT INTO nca_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ŋu murí ŋuro tero neneŋombo kiyowero ŋuno kama uyareno. Quko keto kina mande yekata sunará simóne ŋu meté teweya. ");
INSERT INTO nca_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Dokoro no ŋuya uni owéye moré mu kasirayemo yowe sopo nereyoteŋgo. Kowe nondo uni ka mirowano, ‘Ke toŋe,’ yeweqo, toŋeyote. Ko ka mirowano, ‘Ke mahe,’ yeweqo, maheweya. Kho simóne mirowano, ‘Kho ŋu te,’ yeweqo, ŋunde teweya.” ");
INSERT INTO nca_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Asa Yesuko mande ŋu iŋoro iŋondata parámi tero rohoréŋoro unipare qambu ene howeyaŋgurí ŋu ŋande yimiraró, “Nondo ŋande yimiroteno, uni ŋaro iŋondutuyó parámi ŋandiro qu ka Israel unipare keweroyemo kama qeneno.” ");
INSERT INTO nca_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ŋunde yiníqo, kuma unindoro uni kembémbo asá yiriní maheŋgurí ŋu roto toŋero pitu ko yano maheroqo kho simó komo meté taró ŋu qene iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Asa tukú Yesu yendé ka, owí muko Nain, ŋuno oró. Oní iŋo-iŋo rewero uniyómboya unipare qambu ŋuya eneya uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Uyaro yendé ŋuro hoŋgo makono kutaqemo mahero uni kumi yiyoní uni ka khumaró mu re koroworo yendé ŋu roto toŋeyaŋgurí. Uni ŋuro nimí muko, simó kanata na ŋu naŋge tero wapu taró. Unipare qambu pare ŋuya maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Asa Uni Parámimbo pare ŋu qenero ŋuro sikí parámi tero ŋande miraró, “Ke ma tendoyoto.” ");
INSERT INTO nca_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ŋunde yero kutaqemo uyaro mindu ŋu towaró. Towoní uni mindu korowaŋgurí ŋu kaŋaŋgurí. Kaŋi Yesuko ŋande yaró, “Simó keta, nondo kimiroteno, otoqo,” yaró. ");
INSERT INTO nca_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yiní uni khumaró ŋu otoqoro kunditero mande hurí rero yaró. Yiní Yesuko re nimí inaró. ");
INSERT INTO nca_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Asa unipareto sasaro parámi tero Anutu owí hokoro ŋande yaŋgurí, “Ye-ye uni ka parámi mu keweronanimo tunoqete.” Yero ŋande yaŋgurí, “Anutuko unipareyó yiyowero mahete.” ");
INSERT INTO nca_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ko Judia mira soso quno ŋuno unipare Yesuko o taró ŋuro epe mito-mito taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Asa Jon koro iŋo-iŋo rewero uniyómbo o soso Yesuko taró ŋuro Jon miraŋgurí. Miroyiqo, Jonko iŋo-iŋo rewero uniyó irisa neko yerero ");
INSERT INTO nca_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","mande ka Uni Parámi oseseyowero qu yimitoro asá yereró. Osese ŋuko ŋandiro, “Kepe uni maheweya ŋuro iŋatowó ŋumbe, ma nore meyowo ka sopowato?” ");
INSERT INTO nca_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Asá yiriní Yesuko uyaro ŋande yariyó, “Sono re-re uni ŋu, Jon, ŋundo mande ka ŋande yete, ‘Ko kepe uni maheweya yi iŋatowó ŋuno qumbe, ma meyowo kape sopowato?’ Ŋunde yiní ŋuro osese kerewero mahetero.” ");
INSERT INTO nca_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ŋu naruko naŋge Yesuko unipare se khumo enesó-enesó quya yuqa piyimi ene quroyemo yoraŋgo qu qambu horé ŋu yoriní meté taŋgurí. Ko toŋeye kiré qu ŋuya parámi samaka-samaka tuwó rero toŋetaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Asa Yesuko uni irisa ŋu mande topé ŋande yero yimiraró, “Yari uyareya Jon mitoya o soso qenero iŋotiri ŋu ye mirori qembe. Toŋeye kiré mu toŋetero o qeneyoteŋgo, kheye piyimi mu khete uyareyoteŋgo, koweye piyimi khumo qu sara teyoteŋgo, kusumboye tuwo qu mande iŋoyoteŋgo, uni khumowí mu otoqoyoteŋgo, onoŋoye moré kini qu miti mande iŋoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kowe uni ka neneŋo iŋoro iŋondutuyó kama piyo teweya ŋuko puriŋo ka rete.” ");
INSERT INTO nca_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ŋunde yiní Jon koro asá yerewí uni irisa ŋu toŋiriqo, Yesuko Jon ŋuro unipare qambu ŋu ŋande yimiraró, “Ye do ka qenewero mira wimbímo uyareŋgurí? Matúmbo tamá ka okokowoyote ŋumbe qenewero ŋuno uyareŋgurí, peka? Kini. ");
INSERT INTO nca_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Quko ye do ka qenewero ŋuno uyareŋgurí? Uni ka kowe punu-punuyó meté-meté mu teyonímbe ŋu qenewero uyareŋgurí, peka? Kini, uni kato tuwi meté-meté mu punuworo nakayá enesó-enesó tero o meté-meté mu siyoteŋgo qundo wiri yerete unindoro yayemo yoteŋgo. ");
INSERT INTO nca_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Quko ye do ka qenewero ŋuno uyareŋgurí? Ye-ye uni ka qenewero uyareŋgurí, hamómbe? Iyo, ko no ŋande ye yimiroteno, ŋu ye-ye uni ŋundo ye-ye uni kumi taka yerete. ");
INSERT INTO nca_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Uni ŋuro mande ka sokomeko ŋuno ŋande nakayáŋaró, “‘Iŋo, nondo uni ka mande yesowo yimitoyoweya qu asáŋowe koretero uro keŋo khe qu roŋgaruwoweya.’ ");
INSERT INTO nca_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“No ŋande yimiroteno, Jon koro owí ŋundo uni soso nokono yoteŋgo ŋuro owéye takate. Quko uni ka Anutuko unipareyó wiri yereyote naruyómo owí tomó ta horé tete ŋuro owí ŋundoko Jon takate.” ");
INSERT INTO nca_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ŋunde yiníqo, uniparetoya takis re-re unindoya mande ŋu iŋoro ŋande yaŋgurí, “Anutu koro murí ŋuko roneneŋowí mu naŋge.” Ŋunde yaŋgurí dokoro Jon kandí moŋgo sono re-re taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Quko Farisi unindoya hutuŋo mande ŋuro iŋo-iŋo unindoya Anutuko khe meté witú yereró mu huwóŋoro Jon kandímo sono re-re kama taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Asa Yesuko ŋande yaró, “Ŋunde ŋuroko nondo uni itaka nokono yoteŋgo ŋuro date yewano? No do tapara mande ka yewano? ");
INSERT INTO nca_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ŋuko simó yendémo kunditeyoteŋgo qembe, ko simó topoye neko yerero ŋande yeyoteŋgo, “‘Nore kusí huwoyatowó, quko ye quno kama raŋgurí. Nore sikí yambo yatowó, quko ye kama tendoyaŋgurí.’ ");
INSERT INTO nca_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Qeni, sono re-re uni ŋu, Jon, ŋundo mahero bret kama nero wain sonoyó kama neyara. Ko yendo ŋande yeyaŋgo, ‘Yuqa piyimi kato eneno yote,’ yeyaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Itaka Unindoro Naŋuní mahero o qímboro neyote. Ko yendo ŋande yeyoteŋgo, ‘Uni ŋuko o nero qahí parámi tinditete, wain parámi nero kape-kape teyote. Eneko takis re-re unindoya quhurí unindoya topo teyote.’ ");
INSERT INTO nca_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ye ŋunde yeyoteŋgo, quko qeni, iŋo-iŋo meté horé ŋundo simó meté yoriní tunoqeweya.” ");
INSERT INTO nca_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Asa Farisi koro wini koŋgo uni kato Yesu nekoní yayómo mahero o newero quro yakutímo etariyó. ");
INSERT INTO nca_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ŋu naruko ŋuno quhurí pare ka yendémo ŋuno yora qundo, Yesuko Farisi unindoro yano ŋuno o neyote, yi iŋaró. Iŋoro sono risá nuŋgurí meté mu noko kumbe tomó ta kano re maheró. ");
INSERT INTO nca_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mahero Yesu khímo kaŋero tendoyoní tendo sonoyómbo Yesu khímo umburó. Tendo sonoyó ŋuko huímbo soworo khí mutó inoro sono nuŋgurí meté mu rero khímo windoroŋaró. ");
INSERT INTO nca_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ŋunde teyoní Farisi uni ŋundo Yesu nekoní maheró ŋu qenero newondímbo ŋande ye iŋaró, “Eneko ye-ye uni ka hamó tiníqo, danimbo kandí re kowímo rete ŋu iŋoweya, asa quhurí pare kato naŋge pekáŋote.” ");
INSERT INTO nca_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ŋunde ye iŋoní Yesuko iŋo-iŋoyó qenero ŋande miraró, “Saimon, no mande ka kimirowe teteno.” Yiní yaró, “Rondaqe-rondaqe unine, yeka iŋowe.” ");
INSERT INTO nca_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yiní ŋande yaró, “Uni kato uni irisa ŋuro utatáyari taró, karo utatáyó wondo musiyó 500 ŋunde, ko karo quko wondo musiyó 50 ŋunde naŋge. ");
INSERT INTO nca_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Asa irisa-irisa ŋundo utatá topé tewero mepémo kini, ko uni ŋundo utatáyari ŋu re roto yunaró. Asa ko ke date iŋote, dani katoko uni ŋu newonde meté hamó inoweya?” ");
INSERT INTO nca_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Yiníqo, mande topé yaró, “No ŋande iŋoteno, uni ŋu utatá parámi ŋu re roto inaró ŋundo newonde meté hamó inoweya.” Yiní yaró, “Keto ŋuro okeyá ta qene rondaŋete.” ");
INSERT INTO nca_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yero Yesuko rohoréŋoro pare ŋu qenero Saimon miraró, “Pare ŋa qenetepe? Asa no keŋo ya quroko areteno quno keto khene sonowowero sono kama nunote. Quko pare ŋando tendo sonoyómbo khene sonoworo huí ŋundo supu sowote. ");
INSERT INTO nca_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Asa no keŋo ya quroko areteno quno keto kama mutó nerete. Quko itaka yano areteno quno naŋge pare ŋando khene mutó inoyote. ");
INSERT INTO nca_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Asa no keŋo ya quroko areteno quno ke topo tewero kiruwó kumi rero kembanemo kama windoroŋote. Quko pare ŋando sono nuŋgurí meté mu re mahero khenemo windoroŋote. ");
INSERT INTO nca_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Pare ŋando neneŋo newonde meté hamó nunoyote. Ŋunde ŋuroko Anutuko eneŋo quhuríŋo parámi se rotote. Uni kato Anutuko quhuríŋo tomó ta ŋu re rotaró qundo newonde meté tomó ta naŋge inoweya.” ");
INSERT INTO nca_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Asa enendo pare ŋu ŋande miraró, “Quhuríŋge se rotoní.” ");
INSERT INTO nca_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Uni meyowo ŋuno qundo mande ŋu iŋoro epe mito-mito taŋgurí, “Ŋa danimbo quhurí ŋu se rotoyote?” ");
INSERT INTO nca_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Asa Yesuko pare ŋande miraró, “Iŋondutukepo koriní meté tete. Ke toŋe, newondeke ime yoní.” ");
INSERT INTO nca_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Asa imemoŋgo ta Yesu yate-yate yendé pará-paráwore ko yendé tomó-tomówore ŋuno uro Anutuko unipareyó wiri yereyote naruyó ŋuro miti mande ŋu yesowo yimitoyaró. Ko eneŋo iŋo-iŋo rewero uniyómboya ene ŋuya uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ko pare kumi ŋuya eneya uyareyaŋgurí. Ŋu pare kumi ŋuko yuqa piyimi ene quroko yoraŋgo qu yohowaró, ko kumi ŋuko se khumo ti yoriní meté taŋgurí. Kako owí Maria, Maktala yendé moŋgo qu, ŋu Yesuko yuqa piyimi kande saŋiyoro irisa ŋunde yoraŋgo qu yohowaró. ");
INSERT INTO nca_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ko kako owí Joana, ŋuko Kusa koro parí (Kusa ŋuko Herot koro yayómboro sopo-sopo), ko kako owí Susana, ko pare kumi ŋuya eneya uyareyaŋgurí. Ŋu pare ŋuko Yesu koya eneŋo iŋo-iŋo rewero uniyó samaka yerero onoŋoye kumi yunaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Asa unipare qambu horé yendé enesó-enesó rotoro mahe huruwoyi tapara mande ka ŋande yimiraró: ");
INSERT INTO nca_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Uni kato o yuwoyó khono se kuriyoní kumi kheko umburó. Ŋuno umbuní unindo kheteyaŋgo, ko númbo mahero neyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ko kumi noko wondo seqemo yote quno ŋuno umburó. Ŋuno umburo wotero asáqero khumaró. Dokoro sonoyó moré kini. ");
INSERT INTO nca_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kumi kakari keweroko umburo wotaŋgurí, ko kakari ŋuko noko kiruwó wosoro kosa saki riní eŋgé kama taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ko kumi noko metémo umburó. Ŋuno umburo wotero eŋgé parámi horé 100 ŋunde taró. Asa uni ka kusumbí moré tiníqo, mande ŋa iŋoní.” ");
INSERT INTO nca_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Asa iŋo-iŋo rewero uniyómbo tapara mande ŋuro murí iŋowero oseseyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Oseseyi ŋande yimiraró, “Anutuko unipareyó wiri yereyote naruyó ŋuro mande tapuŋowí mu. Itaka yepa naŋge mande ŋu tunomo rondaqe yunoyoteno. Unipare meyowo ŋundo tapara mande naŋge iŋoyoteŋgo. Ŋunde tero “‘qeneyowaŋgo, quko iŋondutuye kama hiyóqeweya, iŋoyowaŋgo, quko kama iŋoyi tondaŋeweya.’ ");
INSERT INTO nca_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Tapara mande ŋuro murí muko ŋandiro. O yuwoyó ŋuko Anutu koro mande quro rokó tete. ");
INSERT INTO nca_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","O yuwoyó kheko umburó, ŋuko unipareto Anutu koro mande qu iŋoyiqo, waka ta Monimbuko mahero mande ŋu newondeyemo se ta yere rotoyote. Ŋande yero iŋote, enendo kama iŋondutu tewaŋgo tiníqo, Anutuko rambaruru koŋgo kama yoreweya. ");
INSERT INTO nca_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","O yuwoyó noko wondo seqemo yote quno ŋuno umbuŋgurí ŋuko ŋandiro: unipareto mandí ŋu iŋoro rero niŋgu-niŋgu teyoteŋgo, quko hurí noko quroko kama uyote. Naru tukuni ta iŋondutu teyoteŋgo, quko quhurímbo towo yereyote quno ŋuno sorero Anutu rotoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","O yuwoyó kakari keweroko umbuŋgurí ŋuko ŋandiro: unipareto mandí ŋu iŋoteŋgo. Quko o noko koro quro iŋaŋawí tero onoŋoye parámi siyoro o niŋgu-niŋgu tewero qu seqayoteŋgo. O soso ŋundo iŋondutuye wiriyoní kama woteyote. ");
INSERT INTO nca_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","O yuwo musiyó noko meté muno umbuŋgurí ŋuko ŋandiro: unipareto mande iŋoro toworo kondé kaŋeyuriqo, eŋgé parámi tunoqeyote. ");
INSERT INTO nca_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Uni kato suru tupuŋoro kumbe quroko kama rukukuwoyoweya, ko yakutí etewero quro kusuŋoyómo kama reweya. Kini, rero koreko pikoyi unindo ya quroko arero hiyó ŋu qenewaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Hamó, o soso sóqeyote ŋuko imemoŋgo tunomo tunoqeweya. Ko o soso unindo weyoŋoyoteŋgo ŋuko imemoŋgo tunomo tunoqiní unipareto ŋu qene iŋowaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ŋunde ŋuroko mande ŋa hamó iŋoyi. Uni ka o kumi towoyote tiníqo, Anutuko o kumi kaŋuya saŋanímo rero inoweya. Uni ka oyó moré kini quko, oka siyoteno, yero iŋoyote ŋuko Anutuko siyoní kini teweya.” ");
INSERT INTO nca_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ŋu naruko ŋuno Yesu koro nimímboya kone-topémboya, Yesu qeneto, yero maheŋgurí. Quko unipare qambu horé ya ŋu maŋgori ene Yesu taŋgímo owero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kowe uni kumimbo Yesu ŋande miraŋgurí, “Náŋge, kone-topoke mirako kaŋero ke kiyowero yeteŋgo amu,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Quko yi mande topé ŋande yimiraró, “Unipare Anutu koro mande qu iŋoro howeyoteŋgo ŋundo ta neneŋo náme one-topone,” yaró. ");
INSERT INTO nca_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Asa naru kano Yesu koya iŋo-iŋo rewero uniyómboya waŋgo kano oro ŋande yimiraró, “Nore sono towo karóŋoro andusina uyato.” Yero uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Asa uyareyate Yesu waŋgo quroko eteyoní matú parámi mahero waŋgo kikíŋoní sono waŋgo quroko uní windoroŋowero taró. ");
INSERT INTO nca_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ŋunde tiní uyaro Yesu okokoworo miraŋgurí, “Awa, awa, nore piyo tewe teteto ŋa!” Ŋunde yi otoqoro matú koya sono koya qene yiní imaqero pitu ko kama okoko tariyó. ");
INSERT INTO nca_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Asa enendo ŋande osese yereró, “Date koro? Yeŋo iŋondutuye ŋu dano yote?” Yiníqo, iŋondata parámi tero sasaro tero ŋande epe mito-mito taŋgurí, “Uni ŋako dani horé? Enendo matú koya sono koya yiní iŋoro ene maŋgó howetiri!” ");
INSERT INTO nca_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yate-yate Galili mira andusina quno Gerasa mirako ŋuno sono towo tapémo uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Uyariqo, yendé uni kato kheko kopo yereró. Uni ŋu yuqa piyimi ene quroko yoraŋgo, ko naru rokóŋoro kowe punu-punuyó kama punuwaró, yano kama eteyaró. Kini, uni tapu yendémo ŋuno naŋge yora. ");
INSERT INTO nca_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Asa Yesuko qenero yuqa pusú ŋu ŋande yimiraró, “Ye toŋi,” yaró. Ŋunde yiní Yesu qenero kiwero Yesu khímo nokono umbu raŋoro ki parámi ŋande taró, “Yesu, Anutu Koreko Horé yote ŋuro Naŋuní, ke do nereweya?” (Komo naru piru yuqa ŋundo uni ŋu kondé sopoyaŋgo. Uni kumimbo utó kondémbo khí kandí kusiyoro sopoyaŋgo, quko yuqa ŋundo wimbu inoyi utó kondé ŋu soso romboŋero yuqa piyimi ŋundo ene ri mira wimbímo toŋeró.) ");
INSERT INTO nca_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Asa Yesuko ŋande oseseyaró, “Owéŋge neko.” Ŋunde yiní ŋande nekaró, “No owéne Lekiyon.” Ŋunde yaró, dokoro yuqa piyimi qambu ŋu ene quroko uro maŋgoreyaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Yuqa piyimi ŋundo Yesu kondé ŋande oseseyaŋgurí, “Keto nore nohowiqo, meré piyimi horé mu ŋuno kama uwato.” ");
INSERT INTO nca_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Po wata mira purímo kutaqemo ŋuno yoraŋgo. Asa kondé oseseyaŋgurí, “Norotoka po quroko uto.” Yi Yesuko, “Meté,” yaró. ");
INSERT INTO nca_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Yiní yuqa piyimi ŋu uni ŋu rotoro po quroko uŋgurí. Uyi po ŋu kheŋgeŋo purí titiní moŋgo rokaráŋoro sono towo quroko uro sono nero khumomukaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Asa po sopo-sopo unindo qenero sore toŋero yendé parámimo ŋuya mira soso ŋuno mande piŋa ŋu yimiraŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Yimiroyi unipareto o tunoqaró ŋu qenewero maheŋgurí. Mahero Yesuko mahi uni yuqa piyimi ŋu quro koŋgo yohowaró muko tuwi kowí punuworo iŋo-iŋoyó hiyóqiní Yesu khí rorowo kunditeyaró. Ŋu qenero sasaro parámi horé taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Uni o tunoqaró ŋu qeneŋgurí ŋundo uni ŋundo date tero meté taró ŋuro unipareno yesowo yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ko uni soso Gerasa mira koŋgo qundo sasaro parámi horé tero kondé miraŋgurí, nore noroto toŋe, yaŋgurí. Ŋunde yi Yesu waŋgo saŋano oro toŋeró. ");
INSERT INTO nca_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Quko koretero uni yuqa piyimi ene koŋgo toŋeŋgurí ŋundo Yesu koya toŋewero koro kondé oseseyaró. Quko Yesuko soréŋoro ŋande miraró, ");
INSERT INTO nca_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ke yendéŋgemo uyareya o soso Anutuko o te samaka kere ŋuro yimito.” Ŋunde yiní toŋero yendéyómo ŋuno Yesuko o tero samakaŋaró ŋuro unipare yesoworo yimiraró. ");
INSERT INTO nca_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Asa Yesu pitu ko sono towo tapé andusina uyareyoní unipare qambu soporo, mahete, yero niŋgu-niŋgu taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Uni ka Juda koro huru-huru ya sopoyara qu, owí muko Jairus, ŋundo Yesu khímo umbu raŋoro enendo yayómo owero quro kondé oseseyaró. ");
INSERT INTO nca_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Dokoro nambuní kanata na, kumima naruyó 12 ŋunde qu, wambaka khumaró. Asa Yesu uyareyoní unipare qambu ŋuya uyaro eneya epe ki-ki taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ŋunde tiqo, pare ka ŋuya yora, pare ŋu kombo khumo naru rokóŋo teyara. Kumima naru 12 ŋunde rotaró, quko dotako se khumoyó ŋu riní meté tewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Asa pare ŋu Yesu huwósina mahero tuwiyó piru ŋu tapémo pekáŋaró. Ŋunde pekáŋoní sitú ŋu waka ta kini taró. ");
INSERT INTO nca_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ko Yesuko osese ŋande taró, “Danimbo peka nerete?” Yiní uni soso, norendo kini, yiqo, Pitako yaró, “Awa, unipare qambu ke wuriri kerero kaŋero keya epe womo-womo teteŋgo ŋu.” ");
INSERT INTO nca_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Quko Yesuko yaró, “Wimbune kumi norotoní iŋoteno, ŋunde ŋuro no ŋande iŋoteno, kato peka nerete.” ");
INSERT INTO nca_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Asa pare ŋu iŋaró, ene sóqewero mepémo kini. Ŋunde ŋuro yukuworo khímo umbu raŋaró. Ko enendo unipare toŋeyemo do murí karo Yesu towaró, ko se khumo ŋu waka ta kini taró, ŋuro yaró. ");
INSERT INTO nca_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yiní Yesuko miraró, “Nambone, keŋo iŋondutukepo koriní meté tete. Ke toŋe, newondeke ime yoní.” ");
INSERT INTO nca_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu mande yeyoní naŋge huru-huru ya ŋuro sopo-sopo unindoro kho uni ka maheró. Mahero sopo-sopo uni ŋu ŋande miraró, “Namboke khuma. Rondaqe-rondaqe uni roto quhurí watí ma inowero.” ");
INSERT INTO nca_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesuko mande ŋu iŋoro sopo-sopo uni ŋu ŋande miraró, “Ma sorewero. Ke iŋondutu hamó qu naŋge teka simóŋge meté teweya.” ");
INSERT INTO nca_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Asa yano mahero Yesuko unipare qambu yano owero yero soré yereró, ko Pita, Jon, Jems, ko simó ŋuro iwí-nimí ŋu naŋge yorero ya quroko oŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Unipare soso yendémo yoraŋgo qundo simó ta ŋuro sikíqero tendo parámi teyaŋgo. Quko Yesuko ŋande yimiraró, “Ye ma tendowero, dokoro simó ŋu kama khuma. Kinaŋge eteyote.” ");
INSERT INTO nca_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Unipareto, komo khuma, yero iŋaŋgurí, asa ko ene qene yomaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Quko Yesuko pare ta ŋu kandímo toworo ŋande yaró, “Pare ta, otoqo,” yaró. ");
INSERT INTO nca_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Yiní eneŋo yuqayó pitu ko quroyómo uní waka ta otoqaró. Ŋunde tiní Yesuko, o qímboro roŋgaruwo, yimiraró. ");
INSERT INTO nca_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Pare ta ŋu otoqoní iwí-nimí qenero newondeyari uroní niŋgu-niŋgu tariyó. Quko Yesuko ŋande yimiraró, “Yari o tunoqete ŋaro unipare ma yimirowero.” ");
INSERT INTO nca_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Asa Yesuko iŋo-iŋo rewero uni 12 ŋu neko yiriní maheŋgurí. Mahi wimbu koya owé parámimboya yunaró ŋuko enendo yuqa piyimi soso yohowewero unipare se khumo taŋgurí ŋu yoriní meté tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ŋunde yunoro, Anutuko unipareyó wiri yereyote naruyó ŋuro yesoworo se khumo uni ŋu yori meté tewaŋgo, yero asá yereró. ");
INSERT INTO nca_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Asá yerero ŋande yimiraró, “Ye kheko uyarewaŋgo quno ŋuno oye ŋuya se kama uyarewaŋgo. Asa usú, puŋge, o newero qu, wondo musiyó, kowe punu-punu irisa, o ŋunde qu ma siyowero. ");
INSERT INTO nca_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ye ya kano oroqo ŋuno naŋge eteyate yendé meyowomo uyarewero toŋewaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Yendé unipare kato yorero yayemo kama owaŋgo tiníqo, ye toŋewaŋgo quno noko murutómi kheyemo ŋu siyoyi umbuweya. Ŋunde tiqo, o koroqe teyoteŋgo ŋuro muríye ŋu qene iŋowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ŋunde yero yimironí kini tiníqo, uro yendé tomó, parámimo ŋuno toŋero miti mande yesoworo yimitoro se khumo uni yori meté taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Asa Herot, uni kembé ŋundo, o soso tunoqaró ŋuro piŋa mande iŋaró. Ŋunde iŋoro iŋondata parámi taró, dokoro uni kumimbo yeyaŋgo, Jon ŋuko uni tapu koŋgo pitu ko otoqaró, ");
INSERT INTO nca_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ko kumimboko, Elaijako peka tunoqaró, yeyaŋgo, ko kumimboko, ye-ye uni ka komo khumaró ŋundo otoqaró, yeyaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Quko Herotko ŋande yaró, “No komo Jon puŋí toŋowe kini taró. Ko o ŋunde qu teyote ŋuro kusumbo re iŋoyoteno, ŋuko dani?” Ŋunde yero Yesu qenewero khe ka seqaró. ");
INSERT INTO nca_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tukú asá yerewí uni ŋundo pitu ko mahero o soso taŋgurí ŋuro Yesu miraŋgurí. Miroyi yorero enemata yendé parámi ka, owí Betisaita, ŋuno toŋeŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Quko unipare qambu qundo, Yesu uro toŋete, yi iŋoro enepa howe toŋeŋgurí. Ŋunde yero howiqo, yuŋguna yerero Anutuko unipareyó wiri yereyote naruyó ŋuro yimitoro se khumoye moré qu yoriní meté taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Yate suwo tiníqo, iŋo-iŋo rewero uni 12 ŋu eneno mahero ŋande miraŋgurí, “Ke waka unipare qambu ŋa yoreka ene yendéne-yendéne toŋero o qoyemboro siyoya yendé etewero quro meté seqayi. Dokoro nore mira uni kinimo yoroteto.” ");
INSERT INTO nca_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Quko Yesuko ŋande yimiraró, “Yendo o qoyemboro yunoyi.” Yiní yaŋgurí, “Nore o qambu kini, bret kandeka ko sono qare irisa naŋge yote. Norendope toŋero unipare ŋaro o qoyemboro kimowatope?” ");
INSERT INTO nca_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Yero ŋunde yaŋgurí, do karo uni 5,000 ŋunde ŋuno yoraŋgurí. Asa Yesuko iŋo-iŋo rewero uniyó ŋande yimiraró, “Ye yimiroyika unipare 50, 50 ŋunde kopoya kunditi.” ");
INSERT INTO nca_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ŋunde yiqo, unipare soso kunditaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Asa Yesuko bret kandeka ko sono qare irisa ŋu siyoro samboko toŋetero puriŋo yero bret koya sono qare ŋu romboŋero iŋo-iŋo rewero uniyó se yunoní unipare se yunaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Se yunoyi o ni qahuye tinditiní o kumi yoní toŋgo kome puŋge 12 ŋunde siriyoyi maŋgoraró. ");
INSERT INTO nca_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Naru kano Yesu enemata hariri teyoníqo, iŋo-iŋo rewero uniyó ŋu ŋuya ŋuno yaŋgurí. Kowe enendo ŋande osese yereró, “Unipare qambu ŋundo, no dani, yero yeyoteŋgo?” ");
INSERT INTO nca_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yiní mande topé ŋande yaŋgurí, “Kumimboko keko sono re-re uni ŋu, Jon, yeyoteŋgo. Quko kumimboko, Elaija, yeyoteŋgo, ko kumimboko, ye-ye uni komo qu ka otoqaró qu, yero yeyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kowe enendo ŋande osese yereró, “Yendoko nenemboro dani yeyoteŋgo?” Yiní Pitako mande topé ŋande yaró, “Keko Anutu koro Kristo ŋu,” yaró. ");
INSERT INTO nca_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Asa Yesuko soré yerero, no dani ka ye ma yimirowero, yaró. ");
INSERT INTO nca_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ŋande yaró, “Unindoro Naŋuní ŋu kowe surumí parámi korowoní, uni kembé-kembémboya o qa-qa unindoro tapá unindoya hutuŋo mande ŋuro iŋo-iŋo unindoya ene huwóŋoro uri khumoweya. Ko naru kapusayómo ŋuno pitu ko otoqoweya.” ");
INSERT INTO nca_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ŋunde yero unipare soso ŋande yimiraró, “Uni ka no nohoweweroqo, ene eneŋo re umburoqota, tipiririyó re koroworo no nohoweyoweya. ");
INSERT INTO nca_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Dokoro, dani kato eneŋo yoto-yotoyó kondé towowero ye iŋote qu, yoto-yotoyó ŋu piyo teweya. Quko dani kato no iŋo nunoro yoto-yotoyó rotoweya tiníqo, ene yoto-yotoyó ŋu reweya. ");
INSERT INTO nca_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","“Qeni, ko uni ka noko koro o soso ŋu reweya, quko ene piyo tero kini teweya, asa o soso ŋundo date samakaŋoweya? ");
INSERT INTO nca_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Hamó, uni kato nenemborope ma mandenemboro kowi piyo teweya quko, asa tukú Unindoro Naŋuní ŋundo eneŋo sine parámimo mahero uni ŋuro kowi piyo teweya. Ko sine parámi ŋuko iwímboro, sambo simó surumí ŋuro sine parámiye ŋuya. ");
INSERT INTO nca_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","No hamó yimiroteno, uni kumi ŋano kaŋeteŋgo qundo kama khumoyuri Anutuko unipareyó wiri yereyote naruyó ŋu mahiní qenewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Asa Yesuko mande ŋu yeroqo naru kande saŋiyoro kapusa ŋunde rotoro Pita, Jon, Jems yorero hariri tewero mira purímo oŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Oro hariri teyoní umu-kembé ŋu rohoréŋo enesó taró, ko eneŋo tuwiyó muko sara horé tero sine parámi taró. ");
INSERT INTO nca_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ko uni irisa, Moses koya Elaija koya tunoqero eneya yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Uni irisa ŋundo sine parámimo ŋuno tunoqero Yesu Yerusalem ŋuno khumoweya ŋuro yero epe mito-mito teyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita koya topé irisa ŋuya kupo taŋgurí ŋu rotoro otoqoro Yesu koro sine parámi ŋuya uni irisa ŋuya yiyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Asa uni irisa ŋu Yesu roto toŋewero tiriqo, Pitako Yesu ŋande miraró, “Awa, nore keya yoteto quko ŋu meté. Nore yamaru kapusa towowato, kanata keŋo, kanata Moses koro, kanata Elaija koro.” (Ŋunde yaró, quko eneŋo mandí ŋuro murí kama iŋoní tondaŋaró.) ");
INSERT INTO nca_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ŋunde yeyoní naŋge koporé ka mahe weyo yiriní sasaro taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Koporé quroko ŋuno neka ŋande yaró, “Ŋuko neneŋo naŋone. Nondo ene rokóŋanowó. Maŋgó howeyuri qembe.” ");
INSERT INTO nca_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ŋunde yiní kini tiní toŋetiqo, Yesu enesó ŋuno kaŋeyaró. Imemoŋgo iŋo-iŋo rewero uni ŋu o qeneŋgurí ŋuro uni kama yimiraŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Asa tukú mira purí rotoro uyiqo, unipare qambu mahero Yesu koya kheko kopaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Koporo uni ka keweroye moŋgo nekero yaró, “Rondaqe-rondaqe uni, no kondé kira kerewe teteno, ke meté naŋone qeneweya. Dokoro ŋuko naŋone kanata naŋge. ");
INSERT INTO nca_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Naru qambu yuqa piyimi kato towoní waka-waka kiweyote. Ŋunde towoní kowí piyimi yukuwoyote ko harasasa maŋgómo areyote. Naru parámi ŋunde towoní kowí rambaruruwowero teyote. ");
INSERT INTO nca_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nondo komo iŋo-iŋo rewero unike kondé kira yerero, yuqa ŋu howi toŋeweya, yanowó. Quko enendo mepémo kini.” ");
INSERT INTO nca_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Asa Yesuko mande topé ŋande ye yimiraró, “Ye unipare itaka nokono yoteŋgo qundo iŋondutu kama reyoteŋgo! Naru date yeya yowano? Naru date quhuríye korowoyowano? Simó ŋu nono re mahe,” yaró. ");
INSERT INTO nca_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Yiní simó ŋu rero mahiní yuqa pusú ŋundo re raŋoní kowí soso yukuwaró. Quko Yesuko yuqa ŋu qene yero simó ŋu riní meté tiní re iwí inaró. ");
INSERT INTO nca_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Unipare soso Anutu koro wimbí parámi ŋu qenero kondé yukuwaŋgurí. Asa o soso taró ŋu qene iŋondata teyuriqo, Yesuko iŋo-iŋo rewero uniyó yimitoro ŋande yaró, ");
INSERT INTO nca_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ye kusumbo re mande ŋa iŋoyi. Ko kumimbo Unindoro Naŋuní re saŋgirí uni kandeyemo rotowe teteŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ŋunde yaró, quko murí ŋuro kama iŋoyi tondaŋaró. Mande ŋuro murí ŋuko sóqeyoní kama iŋaŋgurí. Ko murí ŋuro oseseyowero quro soraŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Asa iŋo-iŋo rewero unindo dani keweroyemo kato imemoŋgo topé-topé taka yereweya ŋuro mandeto epe uto-uto taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesuko iŋo-iŋoye ŋu soso qene iŋomukoro simó ta ka rero taŋgímo rotoní kaŋiní ");
INSERT INTO nca_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","iŋo-iŋo rewero uni ŋu ŋande yimiraró, “Uni kato neneŋo iŋoro simó ta ka ŋande quya topo teweya ŋuko noya topo teweya. Uni noya topo teweya ŋuko Awanembo asá nereró ŋuya topo teweya. Qeni, ye kato topé soso kusuŋoyemo yote ŋundo ene soso taka yerete.” ");
INSERT INTO nca_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ŋunde yiní Jonko mande topé yaró, “Awa, uni kato keŋo owéŋgepo yuqa piyimi yohowiní toŋeŋgurí ŋu qenetowó. Uni ŋu noreŋo sowe-sowe qu kini. Ŋuroko yuqa piyimi, ma yohowewero, yero soréŋatowó.” ");
INSERT INTO nca_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Quko Yesuko ŋande miraró, “Ma soréŋowero. Dokoro uni yeya saŋgirí kama te yunoteŋgo ŋuko yeŋo topoye.” ");
INSERT INTO nca_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Asa yate-yate Anutuko Yesu re samboko owero naru tukuni tiníqo, Yesuko, Yerusalem owano, yero kondé iŋoro oró. ");
INSERT INTO nca_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Oroyate uni kumi asá yiriní koretero o roŋgaruwowero toŋeŋgurí. Toŋero Samaria mira koro yendé kano oŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Quko unipare ŋuno qundo qenero, Yesu Yerusalem ote, ye iŋoro eneya topo kama taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ŋunde tiqo, iŋo-iŋo rewero uni irisa Jems koya Jon, irisa ŋundo muríye ŋu qenero Yesu ŋande oseseyariyó, “Uni Parámi, ke metémbe iŋi nore irisa ŋando yaro kewá sambo koŋgo umburo unipare ŋu rambaruru yereweyape?” ŋunde yariyó. ");
INSERT INTO nca_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Quko Yesuko rohoréŋoro irisa ŋu yiyo yero ");
INSERT INTO nca_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","yendé ŋu takaro meyowomo ŋuno toŋeŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Oyate uni kato Yesu ŋande miraró, “Ke dana uyareweya qunoko no ŋuya kohowe ŋuno uyarewano.” ");
INSERT INTO nca_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yiní mande topé ŋande yaró, “Á sawa ŋuko meréye noko quroko yote, nú ŋuya yaye moré. Quko Unindoro Naŋuní ŋuko etewero mirayó moré kini.” ");
INSERT INTO nca_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ŋunde yero uni meyowo ka ŋande miraró, “Ke maheya no nohowe.” Quko enendo ŋande yaró, “Uni Parámi, norotoka no toŋeya awane re tapuŋowekata.” ");
INSERT INTO nca_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yiní ŋande miraró, “Enina, uni khumowí ŋundoko topoye khumoteŋgo ŋu se tapu yiri. Quko keko uyareya Anutuko unipareyó wiri yereyote naruyó ŋuro yesowo qembe.” ");
INSERT INTO nca_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Uni meyowo kato Yesu ŋande miraró, “Uni Parámi, noko ke kohowewero iŋoteno, quko koretero norotoka no uyareya suwisawine, ime yuri, ye yimirowekata.” ");
INSERT INTO nca_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Quko eneko ŋande miraró, “Ke kho roŋgaruwowero iŋote, quko o soso komo quro huwóŋgemo toŋetete tiníqo, ke Anutuko unipareyó wiri yereyote naruyómo ke kho tewero mepémo kini.” ");
INSERT INTO nca_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Imemoŋgo Uni Parámimbo uni 72 meyowo rokó yerero irisa-irisa asá yiriní eneŋo korete-koreteyó toŋeŋgurí. Enendo yendé pará-parámi muno, yendé tomó ta-ta quno ŋuno toŋeweya ŋuro iŋoro asá yiriní ŋuno toŋeŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ene ŋande yimiraró, “O newero qu khono parámi eŋgé tete, quko kho tero eŋgé siyowero ŋuro uniyó qambu kini. Ŋunde ŋuroko kho simburí kirayoka kho uni asá yiriní uyaro o ŋu se kopowaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ye toŋi. Iŋoyi, ye asá yerewe sipsip simó qembe á sawa keweroyewore uyarewaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ye mone koro puŋge koneyó, puŋge parámi, khe punu-punu ŋu ŋuya ma se toŋewero. Kowe unipare ka kheko kopo yereroqo naru meté ma yewero. ");
INSERT INTO nca_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Asa ya kano oroqo, koretero ŋande yi qembe, ‘Ya ŋaro simburí, ye newonde ime yuri.’ ");
INSERT INTO nca_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ŋunde yiqo, newonde imemboro uni ka ya ŋuno yoweya tiníqo, puriŋo ŋu newondímo ŋuno uweya. Quko uni ŋunde qu ka ŋuno kama yoweya tiníqo, puriŋo ŋu yeno pitu ko maheweya. ");
INSERT INTO nca_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ya ŋuno naŋge yotoya o qoyemboro ni qembe. Dokoro uni kato kho teyote ŋuko kimoyó meté reyote. Ye unindo yawore wimbo-wimbo ma uwero. ");
INSERT INTO nca_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Asa ye yendé kano uyi yorero yano oyiqo, o yunowaŋgo ŋu ni qembe. ");
INSERT INTO nca_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Unipare yendé ŋuno se khumo teyoteŋgo ŋu yorika meté ti. Mande ŋande yesowo yimiri qembe, ‘Anutuko unipareyó wiri yereyote naruyó ŋu mahewe tete.’ ");
INSERT INTO nca_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Quko yendé parámi kano uyi yorero yayemo kama oyiqo, ya rotoro yendémo kaŋero ŋande yi qembe, ");
INSERT INTO nca_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Yeŋo miraye ŋaro kuku khenanimo womote. Norendo ŋu se rotoro ye witú yerewato, yendo otete ŋu teteŋgo ŋuko piyimi. Quko ye hamó iŋoyi, Anutuko unipareyó wiri yereyote naruyó ŋu mahewe tete.’ ");
INSERT INTO nca_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Asa ŋunde yiqo, no ye yimiroteno, imemoŋgo Anutuko unipare ronda yereweya naruyómo ŋuno yendé uniparetoro kimoye piyimi ŋundo Sotom uniparetoro kimoye ŋu takaweya. ");
INSERT INTO nca_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ye Korasin, ininiyaqe, ye Betisaita, ininiyaqe. Ye quhurí piyimi korowowaŋgo. Ko o wimbí moré keweroyemo tanowó ŋuko komo yendé meyowo Tair, Saiton ŋuno tunoqaró tiníqo, unipare ŋundo komo quno newonde rohoré tero newonde surumí koro tuwi qu punuworo nombo kembayemo sonowaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Imemoŋgo Anutuko unipare ronda yereweya naruyómo ŋuno yendé uniparetoro kimoye piyimi ŋundo Tair, Saiton uniparetoro kimoye takaweya. ");
INSERT INTO nca_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ko ye Kaperneam, ye yoriní samboko ona owaŋgo, peka? Kini, uni khumowí ŋuro yendéyemo amuna uwaŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesuko uni asá yereró ŋu ŋande yimiraró, “Uni kato ye mandeye iŋote, ŋuko no mandene iŋote. Kowe uni kato ye huwó yereyote qundo ŋunde no huwó nereyote, ko enendo uni asá nereró ŋu ŋuya huwóŋoyote.” ");
INSERT INTO nca_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yiní toŋeŋgurí. Imemoŋgo yate-yate pitu ko mahero niŋgu-niŋgu parámi taŋgurí. Tero ŋande yaŋgurí, “Uni Parámi, nore keŋo owéŋgemo yato yuqa piyimi ŋu maŋgonani howeyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yiqo, mande topé ŋande yaró, “Nondo Monimbu qenewe rowá ŋunde qembe tero sambo koŋgo mirako waka ta uró. ");
INSERT INTO nca_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Iŋi, nondo ye wimbu yunano, meté kheyembo sire, potómbe khete yerero yeŋo saŋgiríyemboro wimbí takawaŋgo. Ko oka kato ye kama rowore yereweya. ");
INSERT INTO nca_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ŋunde ŋuro naŋge yuqa piyimi ŋundo maŋgoye howeyoteŋgo, quko ŋuro niŋgu-niŋgu ma tewero. Kini. Anutuko owéye samboko nakayáŋaró ŋuro niŋgu-niŋgu ti.” ");
INSERT INTO nca_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ŋu naruko ŋuno Yuqa Surumí ŋundo Yesu riní niŋgu-niŋgu parámi tero ŋande yaró, “Awa, keko sambo koro, noko koro Uni Parámi. Keŋo seréŋge teteno, dokoro ke komo o ŋa se tapuŋoyi iŋo-iŋo unindo kama iŋaŋgurí. Kowe uni kumi oŋa qembe yoteŋgo qu witú yereró. Iyo, Awa, keŋo nuŋguríŋge howero ŋunde taró.” ");
INSERT INTO nca_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ŋunde yero ŋande yimiraró, “Awanembo o soso re kandenemo raró. Iwímbo naŋge Naŋuní iŋo inoyote, uni kato kama iŋote. Kowe Naŋunímbo naŋge Iwí iŋo inoyote, ko Naŋunímbo uni ka Iwí witú yereyote ŋu ŋuya Iwí iŋo inoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ŋunde yero rohoréŋoro iŋo-iŋo rewero uniyó mondó ta ŋande yimiraró, “Danimbo yendo o qeneyoteŋgo ŋu qeneyowaŋgo ŋuko puriŋo ka rewaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Dokoro ŋande yimiroteno, komo quno ye-ye uni qambu ŋuya wiri yerete uni qambu ŋuyako ye o itaka qeneyoteŋgo ŋu qenewero surumí iŋoyaŋgurí, quko kama qeneŋgurí. Ko enendo mande itaka ye iŋoyoteŋgo ŋu iŋowero surumí iŋoyaŋgurí, quko kama iŋaŋgurí.” ");
INSERT INTO nca_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Asa naru kano hutuŋo mande ŋuro iŋo-iŋo uni kato Yesu towoŋowero otoqoro ŋande oseseyaró, “Rondaqe-rondaqe uni, no date tero yoto-yoto suki-suki rewano?” ");
INSERT INTO nca_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yiní ene ŋande oseseyaró, “Do mande kato hutuŋo mandeko ŋuno yote? Keto ŋu date weyoyote?” ");
INSERT INTO nca_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yiní mande topé ŋande yaró, “Hutuŋo mande ŋundo ŋande yete, ‘Keto Uni Parámi ŋu, Anutuke, newondekepo, yuqakepo, iŋo-iŋokepo, wimbukepo hamó surumí iŋo inoyoto qembe.’ Ko ‘keŋomboro iŋoyote ŋunde naŋge topokeporo ŋuya ŋunde naŋge iŋoyoto qembe.’” ");
INSERT INTO nca_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ŋunde yiní ŋande miraró, “Ke okeyá ta yete. Ŋunde teroqo yoto-yoto reweya.” ");
INSERT INTO nca_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Asa hutuŋo mande ŋuro iŋo-iŋo uni ŋundo eneŋo murí roneneŋowí mu witúŋowero ŋande oseseyaró, “Asa hutuŋo mandeko topone ŋuro ŋunde yete. Asa neneŋo topone ŋuko dani?” ");
INSERT INTO nca_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesuko sowo mande topé kumi yaró, “Uni ka Yerusalem rotoro Jeriko uwero uní wiri yerete unindoro hutuŋo mande wendaqero kuma tero momo teyaŋgo uni kumimbo kheko sóqeyate uto roworemoro kowe punu-punuyó utaŋo toŋi kheko eteyate wambaka khumaró. ");
INSERT INTO nca_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Imemoŋgo o qa-qa uni ka khe ŋu howe uró. Uro uni ŋu qenero khe tapéwore takaro toŋeró. ");
INSERT INTO nca_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ŋunde naŋge Liwai koro sowe qu kato mahero qenero khe tapéwore takaro toŋeró. ");
INSERT INTO nca_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Quko Samaria mirako uni kato mahero qenero sikí tero ");
INSERT INTO nca_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","taŋgímo uyaro, kiruwómboya wain ŋuya hausuworo mama sonoworo kusiyaró. Kusiyoro hoko re eneŋo dókiyó saŋano rotoní kunditiní rero etewero quro yano oro ŋuno roŋgaruwaró. ");
INSERT INTO nca_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ita saraŋoní denarius irisa siyoro etewero quro ya simburí ŋu inaró. Inoro ŋande miraró, ‘Ke uni ŋa sopoyoto qembe. Asa sopoyowero kimoyó wondo musiyó ŋa takaníqota, no pitu mahewano quno ŋuno topé te kunowano.’” ");
INSERT INTO nca_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ŋunde yero Yesuko hutuŋo mande ŋuro iŋo-iŋo uni ŋande oseseyaró, “Uni kapusa ŋuro ke date iŋote, dani kato uni ŋu kuma unindo roworemaŋgurí ŋuro eneŋo topé horé yora?” ");
INSERT INTO nca_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yiní ŋande yaró, “Uni ŋundo qenero sikí te inaró.” Yesuko ŋande miraró, “Ke uya otete ŋunde naŋge teyoto qembe.” ");
INSERT INTO nca_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Asa Yesu koya iŋo-iŋo rewero uniyómboya khewore uyaro yendé kano oŋgurí. Pare ka yendé ŋu noŋgo qu, owí Mata, ŋundo Yesu re yayó quroko oró. ");
INSERT INTO nca_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Oní asa Maria, Mata koro koneyómbo mahero Yesu khí sumeyoro kunditero Yesu koro mandí iŋaró. ");
INSERT INTO nca_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Quko Matako Yesu koro o qímboro roŋgaruwaró ŋuro iŋondata taró. Ŋunde ŋuro uyaro ŋande miraró, “Uni Parámi, oneŋe no noroto toŋe quno no nenesó o newero ŋa roŋgaruwoyoteno. Kepe ŋu kama iŋoyote? Keto mitoka mahe no samaka niriní.” ");
INSERT INTO nca_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Uni Parámimbo mande topé ŋande miraró, “Mata, Mata, keko o qambu ŋaro iŋondataqeyote. ");
INSERT INTO nca_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ke o kanata na ŋuro naŋge iŋoyoto. O ŋuko Mariako rete, ŋuko o meté horé, ŋunde ŋuro o meté ŋu kama kusiyowano.” ");
INSERT INTO nca_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Naru kano Yesuko mira kano hariri taró. Hariri tiní kini tiní, iŋo-iŋo rewero uni kato ŋande miraró, “Uni Parámi, keto nore hariri tewero ŋuro murí witú nere, ŋunde naŋge Jonko eneŋo iŋo-iŋo rewero uniyó witú yereró ŋunde naŋge te.” ");
INSERT INTO nca_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yiní Yesuko ŋande yimiraró, “Ye hariri teweroqo, meté ŋande yi qembe, “‘Awa, keŋo owéŋge surumí yoní, keŋombo nore wiri yereyote naruke ŋu reka mahiní. ");
INSERT INTO nca_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Naru rokóŋoro o qonanimboro nuno. ");
INSERT INTO nca_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kowe noreŋo quhurínani ŋu se roto nuno, dokoro, utatá noreya taŋgurí ŋu soso se roto yunoyoteto. Kowe nore norika okato kama towo niriní.’” ");
INSERT INTO nca_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ŋunde yero ŋande yimiraró, “Asa ko yeŋo keweroyemo uni ka topé moré tiníqo, ko suwo keweroko uro topé ŋande miroweya, ‘Topo, bret kapusa se nuno. ");
INSERT INTO nca_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Uni topone ka khewore yate neneŋo yanemo mahete, quko oka re inowe newero qu ŋana kini.’ ");
INSERT INTO nca_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Ko uni ya quroko yoweya ŋundo mande topé ŋande miroweya, ‘Ke no koweyumu ma nunowero. Mako komo tuŋano, no simónemboya nore komo etato. No otoqo o se kunowero mepémo kini.’ ");
INSERT INTO nca_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ŋunde yeweya, quko nondo ye yimiroteno, ya simburímbo topé ŋuro iŋoro otoqoro o ŋu kama se inoweya. Kini. Quko topémbo kowi piyo kama tero nekoyoníqota, ene otoqoro o soso ŋuro kirayoyote ŋu se inoweya. ");
INSERT INTO nca_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Kowe no ŋande yimiroteno, kirayoyikata o se yunoweya; seqaroqota qenewaŋgo; mako uroyikata mako koso yunoweya. ");
INSERT INTO nca_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Dokoro uni soso kirayoteŋgo ŋundo o ŋu siyoyoteŋgo; uni soso o seqayoteŋgo ŋundo o ŋu qeneyoteŋgo; uni soso mako utoyoteŋgo, ŋuro mako kosoní inoweya. ");
INSERT INTO nca_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ye awa okite, ko simóye kato sono qare koro ŋande kira kiriníqo sire piyimi ka re inoweyape, ma kini? Kini. ");
INSERT INTO nca_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ko simó ŋundo kotori mindi koro kira kiriníqo potómbe ka re inoweyape, ma kini? Ŋu ŋuya kini. ");
INSERT INTO nca_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Yeko quhurí uni naŋge quko simóye o meté yunoyoteŋgo. Ŋunde ŋuroko awaye samboko yorote ŋu kirayoyiqo, Yuqa Surumí yunoweya, hamómbe?” ");
INSERT INTO nca_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesuko yuqa piyimi ka uni quroko qu howero uni ŋuro maŋgó kakayiwí mu riní meté tero mande yiní unipare qambu ŋu qenero iŋondata parámi taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Quko uni kumimbo ŋande yaŋgurí, enendo yuqa piyimi ŋuro kembéye, owí Belisipulu, wimbímo yuqa piyimi ŋu yohoweyote. ");
INSERT INTO nca_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Uni meyowo Yesu towoŋoro ŋande yeyaŋgo, “Sambo koro rokó ka teka nore qene iŋato, keko Anutu koro kho qu teyote.” ");
INSERT INTO nca_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Quko Yesuko iŋondutuye ŋu qene iŋoro ŋande yimiraró, “Wiri yerete unindoro mira qu kato usoworo uni soso wini irisa tero kuma tewaŋgo tiníqo, mira ŋuko piyo teweya. Ko suwisawi kato usoworo keweroyemo kuma tewaŋgo tiníqo, suwisawi ŋu kini teweya. ");
INSERT INTO nca_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kowe Monimbu koro winiyó usoworo keweroyemo kuma tewaŋgo tiníqo, ene date tero wimbu rero kondé kaŋewaŋgo? Ŋunde yeteno, dokoro ye nondo Belisipulu koro wimbí rero yuqa piyimi yohoweyoteno ŋunde yeyoteŋgo ŋu. ");
INSERT INTO nca_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Qeni, yeŋo suwisawiyembo yuqa piyimi yohoweyoteŋgo. Asa ye ŋande yeteŋgo, nondo Belisipulu koro wimbí ŋunde teyoteno. Asa danimbo yeŋo naŋo-simóye samaka yereyote? Hamó, suwisawiye ŋundoko ye ronda yerewaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ko Anutuko wimbu nunoní yuqa piyimi yohoweyoteno tiníqo, ye ŋande iŋowaŋgo, Anutuko unipareyó wiri yereyote naruyó ŋu itaka yeno mahete ŋu. ");
INSERT INTO nca_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Asa uni kondé kato suke, saŋga toworo paseyó sopo yoweya tiníqo, eneŋo oyó soso meté yoweya. ");
INSERT INTO nca_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Quko uni kondé piyimi ka maheroqota uni ŋuya kuma tero takaro eneŋo suke, saŋga se rotoro eneŋo oyó ŋu se uni topé yunoweya. ");
INSERT INTO nca_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Uni ka neneŋo topone kini ŋuko neneŋo saŋgiríne. Uni ka no kama samaka nerero unipare huru yereyote ŋuko unipare yohowiní wisikaraŋo uro toŋeyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Yuqa pusú uni ka rotoroqo toŋero mira harimo wimbo-wimbo toŋero mira imaqewero ŋu seqayote, quko qenewero mepémo kini. Asa ko ŋande yeweya, ‘No pitu ko uyareya pase komo yorano quno ŋuno yorowano.’ ");
INSERT INTO nca_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Yero toŋero ya ŋu qeniníqo, kina yoweya, ko unindo ya ŋu murutó siyoyi toŋiní meté yote. ");
INSERT INTO nca_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ŋunde ŋuro ene toŋero yuqa piyimi kande saŋiyoro irisa yore mahewaŋgo. Yuqa kande saŋiyoro irisa ŋuro muríye piyimi ŋuko eneŋo murí takaweya. Mahero ya ŋuro quroyómo yowaŋgo. Koreteroqo, piyimi tomó ta yora, quko itakako hamó-hamó piyimi parámi horé yoweya.” ");
INSERT INTO nca_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesuko mande ŋu yeyoní pare kato unipare qambu keweroyemo otoqoro ŋande yaró, “Ŋu pare ŋundo ke pisi kerero susu kunaró ŋu ene puriŋo ka rete.” ");
INSERT INTO nca_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yiní ŋande yaró, “Iyo, peka. Quko uni kato Anutu koro mande iŋoro howeyoteŋgo ŋundoko puriŋo ka reteŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Asa unipare qambu Yesuko maheyuri ŋande yimitoyaró, “Unipare itaka yoteŋgo ŋako unipare piyimi. Enendo rokó tewe qenewero ŋuro kondé ye iŋoyoteŋgo. Quko rokó ka kama qenewaŋgo. Kini, rokó kanata naŋge ene qenewaŋgo, ŋuko Jona koro rokó qu naŋge qenewaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Hamó, Jonako ŋuno rokó ka tunoqiní Niniwe unipareto qeneŋgurí. Ŋundiro naŋge Anutuko Unindoro Naŋuní ŋano rokó ka tunoqiní unipare itaka yoteŋgo ŋando qenewaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Komo suki wiri yerete pare kato mira kapiyamo amu noŋgo arero Solomon koro iŋo-iŋo meté horé iŋowero maheró. Ŋunde ŋuroko imemoŋgo Anutuko unipare ronda yereweya quno ŋuno pare ŋundo otoqoro unipare ŋano qu yorero mande khono yorotoweya. Dokoro itaka uni kato keweroyemo yote, ŋuro owímbo Solomon koro owí takate. ");
INSERT INTO nca_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Komo suki Niniwe unipareto Jona koro mandí iŋoro newondeye rohoréŋaró. Ŋunde ŋuroko imemoŋgo Niniwe unipare ŋundo otoqo kaŋero unipare itaka yoroteŋgo ŋu yorero mande khono yorotowaŋgo. Dokoro itaka uni kato keweroyemo yote, owímbo Jona koro owí takate. ");
INSERT INTO nca_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Unindo suru tupuŋoro ya kusuŋo quroko kama reyoteŋgo, ko kondó quroko kama rukukuwoyoteŋgo. Kini, rero koreko pikoyi hiyóqiní unindo ya quroko arero hiyó ŋu qenewaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Toŋeŋge ŋuko koweke ŋaro hiyóŋo. Ko toŋeŋge ŋu meté horé tiníqo, asa hiyó ŋundo koweke soso hiyóqeweya. Ko toŋeŋge ŋu piyimi tiníqo, koweke ŋu riní huriri teweya. ");
INSERT INTO nca_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ŋunde ŋuroko ke kondé iŋo qembe, hiyó ke quroko yorote ŋu ri huriri teweya koro. ");
INSERT INTO nca_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ko koweke sombé-sombé ŋu soso hiyó naŋge teweya tiníqo, hiyómbo hiyó kunoyote ŋunde qembe yuri huriripo koweke sombé-sombé ŋu kama pokamoweya.” ");
INSERT INTO nca_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesuko ŋunde yiní kini tiní Farisi uni kato eneya o newero oseseyaró. Oseseyoní ya quroko oro yakutímo o newero quro etaró. ");
INSERT INTO nca_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Enendo kandí kama sonoworo kina etiní Farisi uni ŋundo iŋondata parámi taró. ");
INSERT INTO nca_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Quko Uni Parámimbo ŋande miraró, “Ye Farisi uni, yeko topa saŋanímo ko kondó saŋanímo sonowoyi kekere ta sara memeri teyote ŋundiro. Quko quroyómo ŋunoko murí piyimi ŋu maŋgoreyote. ");
INSERT INTO nca_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yeko uni kape-kape. Anutuko uni kowe saŋaní ŋuya quroyómo ŋuya irisa-irisa towaró, hamómbe? ");
INSERT INTO nca_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Asa unipare samaka yerewero oye yunoyiqota oye soso sara meté horé ta yoweya. ");
INSERT INTO nca_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ye Farisi uni, ininiyaqe, ye quhurí piyimi korowowaŋgo. Yendo o tomó ta khono woteyote ŋu siyoro rondaŋi kande irisa tiní kanata rero Anutu inoyoteŋgo. Quko yendo unipare roneneŋo kama ronda yereyoteŋgo, ko newondeye Anutu kama inoyoteŋgo. Meté otete tukú ŋu teya korete ŋuya ti qembe. ");
INSERT INTO nca_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ye Farisi uni, ininiyaqe, ye quhurí piyimi korowowaŋgo. Ye huru-huru yano kundite-kundite korete quno ŋuno kunditewato, ye iŋoyoteŋgo, ko yendémo ŋuno yendo, unipareto ye yuŋguna yerewaŋgo, ŋuro hamó iŋoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“O ininiyaqe, ye quhurí piyimi korowowaŋgo. Yeko uni tapu noko quroko yorote ŋunde qembe. Ko unindo kape tero ŋu saŋawore uyare mahe teyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yesuko ŋunde yiní hutuŋo mande ŋuro iŋo-iŋo uni kato iŋoro ene ŋande miraró, “Rondaqe-rondaqe uni, ke mande ŋunde yete ŋuko nore ŋuya yesará nerete.” ");
INSERT INTO nca_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yiní ŋande yaró, “Ye hutuŋo mande ŋuro iŋo-iŋo uni, ininiyaqe, quhurí piyimi korowowaŋgo. Ye hutuŋo mande kate-kate unipare saŋayemo ri enendo quhurí parámi ŋu korowowero mepémo kini. Quko yendo samaka-samaka ka kama yunoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“O ininiyaqe, ye quhurí piyimi korowowaŋgo. Yendo ye-ye unindoro tapu yerewero ya qu towoyoteŋgo, quko yeŋo usi-siyembo uni ŋu yuroyi khumaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ŋunde ŋuroko ye tunomo ŋande yesowoyoteŋgo, ko usisambayemboro oteteye piyimi ŋuro metéŋoyoteŋgo. Dokoro usi-siyembo ye-ye uni yuroyi khumaŋgurí, ko yendo ye-ye uni ŋuro uni tapu koro yaye towoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ŋu murí ŋuroko Anutu koro iŋo-iŋo meté qundo ŋande yete, ‘Nondo ye-ye unindoya asá yerewí uni ŋuya yorewe unipareko ŋuno uyarewaŋgo. Uyari kumi yuroyi khumowaŋgo, kumi o piyimi te yunowaŋgo.’ ");
INSERT INTO nca_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ŋunde tero ye-ye unindoro sitúye soso Anutuko noko sambo towaró qu noŋgo areyate itaka ŋano windoroŋaró ŋuko unipare itaka yoteŋgo saŋayemo yoweya. ");
INSERT INTO nca_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Hamó, sitúye ŋuko Apel koro sitú windoroŋaró ŋu noŋgo yate-yate Sekaraia rero wondo yakutí koya Wembó Surumí koya keweroyarimo uroyi sitú windoroŋaró. No hamó yimiroteno, otete piyimi ŋuro kimoyó muko unipare itaka ŋano yoroteŋgo quno ŋuno ŋuya yoroweya. ");
INSERT INTO nca_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ye hutuŋo mande ŋuro iŋo-iŋo uni, ininiyaqe, quhurí piyimi korowowaŋgo. Yendo iŋo-iŋo metémboro mako koro ki ŋu towoyoteŋgo. Quko yeŋombo ya quroko kama oyoteŋgo, ko meyowombo ŋuno owero ŋuro soréŋoyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Asa Yesu ya ŋu rotoní hutuŋo mande ŋuro iŋo-iŋo unindoya Farisi unindoya newonde saŋgirí te inoro osese enesó-enesó teyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ŋunde tero, eneŋo mandíwore kusiyowato, ye iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ŋu naru ŋunoko unipare qambu horé qundo mahe kopoyi yendé maŋgore rotoyi, kumi topoye khe saŋayemo khete yereyaŋgurí. Asa Yesuko iŋo-iŋo rewero uniyó koretero yimitoro ŋande yaró, “Yendo Farisi koro yis ŋuro kawaware ti. Yis ŋuko maŋgoye irisawore yewero murí ŋu. ");
INSERT INTO nca_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","O pokawí soso ŋu tunomo tunoqeweya. Mande soso sóqeyote ŋu unindo ŋu iŋowaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Asa ko mande soso ye suwono yaŋgurí ŋu unipare kosano iŋowaŋgo. Mande soso ye komo mondó ta ya quroko yaŋgurí ŋu uni kato ya umó moŋgo yesowoweya. ");
INSERT INTO nca_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Uni topone, no ŋande yimiroteno, unindo meté yeŋo koweye uroyi khumoweya, quko imemoŋgo enendo o kaŋuya tewero mepémo kini. Ŋuro ma sorewero. ");
INSERT INTO nca_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kini, ye danimboro sorewaŋgo ŋuro yimitoyoteno. Uni kanata ŋundo mepémo koweye saŋaní uroyi khumoníqota ye yoriní kewá piyimimo uwaŋgo. Ŋuro sori qembe. ");
INSERT INTO nca_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Qeni, uni kato nú kandeka tomó ta-ta ŋu 2 toea ŋunde qundo kimoyoteŋgo, hamómbe? Quko Anutuko nú tomó ta-ta ŋunde qu ka kama kape yereyote. ");
INSERT INTO nca_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hamó horé, yeŋo huye soso kembayemo Anutuko weyo iŋote. Ŋunde ŋuro ye ma sorewero. Yeŋo kimoye ŋuko nú tomó ta-ta ŋuro kimoye takate. ");
INSERT INTO nca_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“No ye ŋande yimiroteno, ko uni kato unipare toŋeyemo yesoworo nono womoweya tiníqo, Unindoro Naŋunímbo Anutu koro sambo simó toŋeyemo yesoworo eneya womoweya. ");
INSERT INTO nca_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Quko uni kato unipare toŋeyemo huwó nereweya tiníqo, nondo Anutu koro sambo simó toŋeyemo huwóŋowano. ");
INSERT INTO nca_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Kowe uni kato Unindoro Naŋunímboya mande piyimi ka yeweya quko, Anutuko quhuríŋo ŋu re rotoweya. Quko uni kato Yuqa Surumímboya mande piyimi yeweya quko, Anutuko ŋu quhurí ŋu kama roto inoweya. ");
INSERT INTO nca_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Asa unindo ye yowosoyi huru-huru ya koro sopo-sopo toŋeyemo ko wiri yerete uni toŋeyemo ko uni owéye parámi toŋeyemo kaŋewaŋgo quno, do mande topé ka yewatope ma date yewato ŋuro ma sorewero. ");
INSERT INTO nca_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ŋu naruko naŋge Yuqa Surumímbo mande yewaŋgo ŋu witú yiriní wisiyo yimirowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Unipare qambu keweroyemo kato Yesu ŋande miraró, “Rondaqe-rondaqe uni, no awane khuma, ŋunde ŋuro nondo ye iŋoteno quko keto pane mitoka awando o rotote ŋu rondaŋeya kumi ka se nunoweya, ye iŋoteno.” ");
INSERT INTO nca_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yiní ŋande oseseyaró, “Date koro? Dando yarindo o qu rondaŋewero quro rokó nereró?” ");
INSERT INTO nca_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yero unipare ŋande yimiraró, “Ye iŋoya toŋeteya yuri. Ye situwi parámi siyowero ŋuro qene nuŋgu tewaŋgo koro. Uni kato situwi parámi reweya ŋuko eneŋo yoto-yotoyó meté ŋu riní kama tunoqeweya.” ");
INSERT INTO nca_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ŋunde yero tapara mande ka ŋande yimiraró, “Onoŋo uni kato kho gima parámi taró. ");
INSERT INTO nca_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Uni ŋundo ŋande ye iŋaró, ‘No date tewe teteno? Yane o se rewero qu ŋu maŋgorete. Ŋuro o ŋa se dano rewe teteno?’ ");
INSERT INTO nca_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Uni ŋundo ŋunde yero yaró, ‘Ŋunde ŋuroko no ŋandiro tewano. Ya o se rewero qu ŋu usoworo ya parámi horé ka rewano. Ŋunde tero kho koro eŋgé ŋu se huruwo ŋuno rewano. ");
INSERT INTO nca_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Rero neneŋomboro ŋande yewano, “No one meté qu kumima naru parámi yoweya. Itakako no imaqero o qonemboro nero niŋgu-niŋgu tero yorowano.”’ ");
INSERT INTO nca_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Ŋunde yaró, quko Anutuko miraró, ‘Ke kape uni. Itaka suwono ke khumowero tete ŋu! O soso keto sopo roŋgaruwoyi yorote ŋuko dando siyoweya?’” ");
INSERT INTO nca_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Asa Yesuko ŋande yimiraró, “Uni kato eneŋo o parámi huruwoyote, quko Anutu koro o qu kama iŋoyote, asa ŋundiro naŋge eneno tunoqeweya.” ");
INSERT INTO nca_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Asa Yesuko iŋo-iŋo rewero uniyó yimito ŋande yaró, “Ŋu murí ŋuro nondo ŋande ye yimiroteno, yeŋo yoto-yotoyemboro iŋaŋawí tero ŋande ma yewero, ‘Do o ka newato?’ Ko koweyemboro iŋaŋawí tero ŋande ma yewero, ‘Do tuwi ka kusiyowato?’ ");
INSERT INTO nca_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Yoto-yotoye ŋuro murí muko o newero qu naŋge kini. Koweye ŋuro murí muko tuwi naŋge kini. ");
INSERT INTO nca_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ye nú parámi iriyó ŋu qeneya iŋoyi. Khono oka kama rimiteŋgo, kho noŋgo eŋgé kama siyoyoteŋgo, o newero qu se huruworo yano kama reyoteŋgo. Quko Anutuko wutu yereyote. Yendo Anutu koro toŋímo nú ŋu taka yereyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ko ye dani kato iŋaŋawí tero yoto-yotoyó meté wosoro sowe teweya? ");
INSERT INTO nca_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Yendo o tomó ŋunde qu tewero mepémo kini. Asa ko dokoro o kumi meyowo quro iŋaŋawí teyoteŋgo? ");
INSERT INTO nca_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Yendo komó ŋuro nuŋo reyoteŋgo ŋu qeni. Koweyumu kama teyoteŋgo, tuwi kama towoyoteŋgo. Quko no ŋande yimiroteno, Solomon ŋundo tuwi meté horé qu se reyaró, quko nuŋo ŋuro nakayámbo Solomon koro tuwi meté-meté ŋu takate. ");
INSERT INTO nca_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Itaka komó ŋunde qu yoteŋgo, ko kuyepo naŋge unindo toŋoro kewáko raŋi uweya. Anutuko oka naru tukuni yorote ŋunde qu o nakayá meté mu inoyote. Asa ye unipare iŋondutuye tomó ta naŋge, iŋoyi, enendo ye ŋuya sopo yerero tuwi yunoweya. ");
INSERT INTO nca_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ko ye, nore do ka newato, yero iŋaŋawí ma tewero. ");
INSERT INTO nca_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Dokoro kape unipareto soso o ŋunde quro iŋoro seqayoteŋgo. Quko yeŋo awayembo ye o ŋuro tukuni teteŋgo ŋu iŋomukote. ");
INSERT INTO nca_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kini, Anutuko unipareyó wiri yereyote naruyó ŋuro kondé iŋoyiqota ene o soso ŋu ŋuya se yunoweya. ");
INSERT INTO nca_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ye sipsip tomó ta-ta, ye sasaro ma tewero. Awayembo ye yoriní unipareyó wiri yereyote naruyómo owero ŋuro iŋote. ");
INSERT INTO nca_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Oye soso soweyoya mone ŋu se uni onoŋoye moré kini ŋu yunoyi qembe. Mone puŋgeyó kama piyo teweya ŋunde qu, asa sambo koro situwi kama kini teweya ŋunde qu, ŋu siyoyi qembe. Samboko ŋunoko momo unindo o ŋu kama siyoteŋgo, siwí ŋundo o soso ŋu kama rambaruruwote. ");
INSERT INTO nca_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ŋunde ti qembe, dokoro dano situwiye yote, ŋu ŋuro iŋomukoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Ye kho simó kumimbo uni parámiye ŋuro sopoyoteŋgo ŋunde qembe tunoqi. Kho simó ŋu khoye tewero sunará tero, suru tupuŋoro kusumbo reyoteŋgo. Asa uni parámi ŋu epe re-re koro o ne-ne roto mahero mako uroníqo, mako waka ta kosoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Uni parámi ŋu mahero sunará simóŋo yiyoní kama etewaŋgo tiníqo, kho simóŋo ŋu meté horé yowaŋgo. No ye hamó yimiroteno, uni parámi eneŋombo kho tewero sunará tero yoriní o newero quro eti o qoyemboro yunoweya. ");
INSERT INTO nca_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Hamó, uni parámi ŋundo suwo kewerokope ma kotori korete yeyote quno ŋuno maheweya tiníqo, sunará simóŋo ŋundo kama eteyowaŋgo qundo meté horé yowaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Quko ŋaro iŋoyi, ya simburímbo do naru horé ŋuno momo uni ŋundo maheweya ŋu iŋote tiníqo, kawaware meté horé tiní ene yayó usowowero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ye ŋuya sopo toŋeteyuri. Dokoro Unindoro Naŋuní ŋundo do naruko ŋuno maheweya, ŋu ye kama iŋoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pitako ŋande oseseyaró, “Uni Parámi, kepe tapara mande ŋumbe nore naŋge nunoyotepe ma uni soso ŋuya?” ");
INSERT INTO nca_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yiní Uni Parámimbo ŋande yaró, “Sunará simó kato suki-suki kho meté tero iŋo-iŋoyó muko meté naŋge. Sunará simó ŋunde qu uni parámiyómbo qenero khoyó inoní ya soso soporo naru metémo sunará simó meyowo wutu yereyote. ");
INSERT INTO nca_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Asa uni parámiyómbo mahiní sunará simó kho meté teyote ŋundo meté horé yoweya. ");
INSERT INTO nca_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Hamó horé yimiroteno, uni parámimbo eneŋo situwiyó soso rero sunará simó ŋuro kandímo rotoní sopoweya. ");
INSERT INTO nca_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Quko sunará simó ŋundo newondí moŋgo ŋande iŋoweya, peka, uni parámine muko waka ta kama maheweya. Ko ene hurí rero sunará simó, sunará pare meyowo ŋu yutoro eneŋo o qímboro nero wain nero kape-kape tero yoweya, peka. ");
INSERT INTO nca_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Asa naru sunará simó ŋuro kama iŋoweya quno, uni parámiyómbo mondó maheweya. Mahero ene sunará simó ŋu sukepo puŋo-puŋo toŋoro riní unindo iŋondutu kama teyoteŋgo quya naŋge yoweya. ");
INSERT INTO nca_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Sunará simó kato uni parámiyómboro iŋo-iŋoyó iŋoyote, quko o roŋgaruworo iŋo-iŋo ŋu kama howeyote ŋuko, uni parámiyómbo uni ŋu parámi haususuwoweya. ");
INSERT INTO nca_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Quko sunará simó kato uni parámiyómboro iŋo-iŋo ŋu kama iŋoro o piyimi teweya ŋuko, uni parámiyómbo uni ŋu tomó ta naŋge haususuwoweya. Asa uni parámimbo uni ka parámi se inaró qu noŋgo o parámi siyoweya. Ko uni kato owé parámi raró ŋuko, uni parámiyómbo kho parámi tewero ŋuro kirayoweya. ");
INSERT INTO nca_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“No mahenowó ŋuko kewá re nokono raŋowero mahenowó, ko nondo kewá ŋu waka ta qawe, yero iŋoyoteno. ");
INSERT INTO nca_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","No sono ka rewe teteno, quko ŋu sopowero quro newondene muko quhurí parámi teyote. ");
INSERT INTO nca_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ko yembeka ŋande iŋoyoteŋgo, nondo nokono ŋano newonde ime yunowero umbunowó, peka? Kini. Nondo ye ŋande yimiroteno, no mahenowó ŋuko unipare usowo yerewero quro mahenowó. ");
INSERT INTO nca_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Dokoro naru ŋa noŋgo yate-yate ya kano ŋuno unipare kandeka usoworo wini irisa ŋunde tunoqewaŋgo. Kapusa ŋundo irisa ŋaro saŋgirí tewaŋgo, ko irisa ŋundo kapusa ŋaro saŋgirí tewari. ");
INSERT INTO nca_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","“Ŋunde usowowaŋgo, ko iwímbo naŋunímboya saŋgirí tiní naŋunímbo iwímboya saŋgirí teweya. Ko nimímbo nambunímboya saŋgirí tiní nambunímbo nimímboya saŋgirí teweya. Ko nepímbo nepímboya saŋgirí teweya.” ");
INSERT INTO nca_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesuko unipare qambu ŋande yimiraró, “Koporé kosa uyotesina tunoqiníqo, ye waka ta ŋande yeyoteŋgo, sono umbuwe tete, yeyoteŋgo. Ko ŋunde na hamó tunoqeyote. ");
INSERT INTO nca_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ko matú amu noŋgo tunoqiníqo, ŋande yeyoteŋgo, kosa kondé raŋowero tete, yeyoteŋgo. Ŋu ŋunde hamó tunoqeyote. ");
INSERT INTO nca_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ye uni maŋgoye irisa qu, ye meté o ŋunde qu samboko nokono tunoqeyote ŋuro iŋomukoteŋgo, quko yendoko itaka naru tunoqeyote ŋuro qene rondaŋewero quro murí iŋowero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Do karo yeŋombo okeyá o roneneŋowí mu ŋa kama qene rondaŋeyoteŋgo? ");
INSERT INTO nca_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Qeni, keya uni kaya mande ka keweroyarimo yoníqo, ronda-ronda uni toŋímo yewero uyarewari quno ŋuno, asa kheko uyare yotoro eneya newonde kanata tewero quro kho kondé te qembe. Ŋunde kama teweya tiníqo, yate ke kowoso mande khono korotoní ronda-ronda unindo kore kumba tukuni kandeyemo korotoníqo, enendo kore kusi-kusi yano korotowaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nondo hamó kimiroteno, ke kusi-kusi yano yate wondo yaŋgurí ŋu kanaramimo kimo teroqota.” ");
INSERT INTO nca_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ŋu naruko ŋuno uni kumimbo Yesu sowo mande ka Galili uni ŋuro miraŋgurí. Komo Galili uni ŋundo Anutu koro o qa-qa te inoyaŋgo quno Pailat koro kuma uniyómbo yuroyi khumaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Asa ŋunde miroyi mande topé ŋande yaró, “Ye date iŋoteŋgo, uni ŋundo quhuríyembo Galili uniparetoro quhuríye ŋu soso taka yerete, peka? Asa ŋu murí ŋuro o piyimi ŋundo eneno tunoqaró, peka? ");
INSERT INTO nca_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ŋu kini horé. No hamó horé yimiroteno, ye newonde rohoré kama tewaŋgo quko, o ŋunde qundo yeno ŋuya tunoqeweya. ");
INSERT INTO nca_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ko uni 18 ŋu, komo Siloam yendémo ya piru ka toqero yuroní khumaŋgurí, ye ŋuro date iŋoteŋgo? Eneŋo quhuríyembo Yerusalem unipare ŋu taka yerete, peka? ");
INSERT INTO nca_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kini horé. Nondo ye hamó horé yimiroteno, ye newonde rohoré kama tewaŋgo quko, o ŋunde qundo yeno ŋuya tunoqeweya ŋu.” ");
INSERT INTO nca_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Asa Yesuko tapara mande ka ŋande yimiraró, “Naru kano uni kato te ka wain khono rimiró. Yate-yate eŋgé siyowero uyaró, quko te ŋu eŋgé moré kini. ");
INSERT INTO nca_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ŋunde tero ene sunará simóŋo ŋande miraró, ‘Kumima naru kapusa quno nondo eŋgé siyowe, ye iŋoro ŋano maheyoteno. Quko te ŋa eŋgé moré kini. Asa keto toŋoka toqiní. Te ŋundo noko kiruwó kina reyote.’ ");
INSERT INTO nca_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Yiní sunará simóŋo ŋundo yaró, ‘Awa, kini. Kumima naru kaŋuya yoweya. Nondo noko kutaqemo te murímo sewano, ko makao qí wendaqe ŋuno rewano. ");
INSERT INTO nca_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kumima naru awena ŋuro peka eŋgé teweya. Quko ŋunde kini tiníqo, nimiroyi toŋowano.’” ");
INSERT INTO nca_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Asa Sapat naru kano Yesuko huru-huru yano kaŋero mande rondaqe yunoyaró. ");
INSERT INTO nca_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Yunoní pare ka ŋuno yora. Enendo kumima naru 18 quroko ŋuno yuqa piyimi kato ene uroní tupurí kondéqiní roneneŋo kaŋewero mepémo kini teyara. ");
INSERT INTO nca_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Asa Yesuko ŋu qenero nekoro ŋande miraró, “Pare, keŋo se khumoke ŋu kini tete,” yaró. ");
INSERT INTO nca_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ŋunde yero kandí rero kowímo riní waka ta roneneŋo kaŋero Anutu owí neko hoko towoyaró. ");
INSERT INTO nca_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yesuko Sapat naruko ŋuno naŋge pare ŋu riní meté taró. Ŋunde ŋuroko huru-huru ya koro sopo-sopo uni ŋundo newonde saŋgirí tero unipare qambu ŋande yimiraró, “Hutuŋo mande ŋande yete, naru kande saŋiyoro kanata quroko naŋge kho ti qembe. Asa ko ŋu naruko naŋge mahiqo, yoriní se khumoye meté teweya, Sapat naruko ŋuno kini.” ");
INSERT INTO nca_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yiní Uni Parámimbo mande topé ŋande miraró, “Ye uni maŋgoye irisa. Yendo Sapat naruko ŋuno makaoye ŋuya dókiye yayó moŋgo orosoyero sono newero quro re uyareyoteŋgo, hamómbe? ");
INSERT INTO nca_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Asa qeni, ŋa pare ŋako Abraham koro sowe qu, ko kumima naru 18 quroko ŋuno Monimbuko kusiyoyara. Ŋu date koro? Nondo Sapat naruko ŋuno orosoyano tiníqo, hutuŋo mande howeyoteno, ŋunde hamómbe?” ");
INSERT INTO nca_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ŋunde yaró, quko eneŋo saŋgiríŋo ŋu soso kowi piyo taŋgurí. Ko unipare qambu ŋundo o wimbí moré soso teyara ŋuro niŋgu-niŋgu parámi taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ŋunde ŋuroko Yesuko ŋande yaró, “Anutuko unipareyó wiri yereyote naruyó ŋuko date, no ŋuro date yewano? ");
INSERT INTO nca_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Asa ŋuko mastet koro musiyó ŋunde qembe. Asa uni kato musiyó ŋu rero khono riminí wotero te parámi ka tiní nú mahero kambinímo kunditeyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesuko mande kaŋuya ŋande yaró, “Nondo Anutuko unipareyó wiri yereyote naruyó ŋuro date yewano? ");
INSERT INTO nca_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Asa ŋuko yis ŋunde qembe. Asa pare kato yis ŋu plaua parámimo rohoréŋoyoníqo, imemoŋgo plaua ŋu soso koŋe parámi teweya.” ");
INSERT INTO nca_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Asa Yesuko Yerusalem khewore uyareyate yendé pará-paráwore ko yendé tomó-tomówore ŋuya unipare mande rondaqe yunoyaró. ");
INSERT INTO nca_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ko uni kato ŋande oseseyaró, “Uni Parámi, uni kumi naŋge peka rambaruru takawaŋgope?” Yiní unipare ŋande yimiraró, ");
INSERT INTO nca_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ye mako kiŋiwí tomó ta ŋu qurowore owero quro koweyumu ti qembe. Hamó, nondo ye yimiroteno, uni qambu qundo ŋuwore owero ye iŋoyoteŋgo, quko ene mepémo kini. ");
INSERT INTO nca_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Asa ya simburímbo mako tuŋoníqo, yeko yendémo kaŋero mako utoro ŋande yeyowaŋgo, ‘Uni Parámi, mako kosoka nore oto.’ “Yi mande topé ŋande ye yimiroweya, ‘No ye kama iŋo yunoteno, ye da noŋgo qu.’ ");
INSERT INTO nca_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Yiní ŋande yewaŋgo, ‘Nore keya o kopo neyato ŋuno qu, keto noreŋo yendénanimo kaŋero iŋo-iŋo nunoyara ŋuno qu.’ ");
INSERT INTO nca_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Yi mande topé ŋande ye yimiroweya, ‘No ye kama iŋo yunoteno, ye da noŋgo qu. Yeko unipare o piyimi teyoteŋgo qu, ye soso toŋi.’ ");
INSERT INTO nca_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Yendo Abraham, Aisak, Yakop ko ye-ye uni ŋu soso yiyoyi Anutuko unipareyó wiri yereyote naruyómo ŋuno yowaŋgo, quko Anutuko yeŋombo naŋge ye yohowiní toŋewaŋgo. Ŋunde tiní ye tendoro metoye kindotowaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ko unipare soso miraye rotoro kosa aretesinaŋgo ko kosa utesinaŋgo ko mira taŋgí kawore-kawore ŋu noŋgo mahero naruyómo ŋuno kunditero o newaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Qeni, uni kumi weŋa yoteŋgo qu, ŋundo otoqoro koretewaŋgo. Ko uni kumi koreteyoteŋgo qu, ŋu enepa naŋge tukú tewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ŋu naruko ŋuno Farisi uni kumi mahero Yesu ŋande miraŋgurí, “Ke yendé ŋa roto soreya mira meyowo kano u. Dokoro, Herotko kuroweka khumi, yero iŋoyote.” ");
INSERT INTO nca_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Asa Yesuko ŋande yimiraró, “Ye uya, á sawa ŋu ŋande miri, ‘Iŋo, itaka ŋuya ko kuyepo ŋuya nondo yuqa piyimi unipare quroko yoteŋgo ŋu yohowewano, ko se khumo uni roŋgaru yerewano. Ko naru kapusa quno ŋunoko khone kini teweya.’ ");
INSERT INTO nca_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Quko itaka ko kuyepo, yaŋini no uyareyowano. Dokoro ye-ye uni kato yendé meyowomo khumowero mepémo kini. Kini, ŋuko Yerusalem ŋuno naŋge khumoteŋgo! ");
INSERT INTO nca_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yerusalem, Yerusalem, yendo ye-ye uni yuri khumoteŋgo, ko uni Anutuko asá yiriní maheyoteŋgo ŋu wondo saŋayemo raŋoyoteŋgo. Naru qambu nondo kotoriko simó se wire quroko poka yereyote ŋunde qembe simóŋge se kopo yerewero iŋoyano. Quko yendo ŋuro piyimiŋoyaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Iŋoyi, itakako yaye hamó piyo tiní ye kina yowaŋgo. No hamó yeya yeteno, ye no kaŋuya kama niyowaŋgo, yate yendo ŋande yewaŋgo, ‘Uni Parámimboro owímo mahete ŋundo puriŋo riní.’” ");
INSERT INTO nca_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sapat naru kano Yesuko Farisi koro uni kembémboro yano oro o naró. O niní unindo kondé sopo qeneŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Asa kowe koŋe-koŋe khumo uni ka Yesu toŋímo yoní ");
INSERT INTO nca_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","qenero hutuŋo mande ŋuro iŋo-iŋo unindoya Farisi uni ŋuya ŋande osese yereró, “Hutuŋo mande ŋundo date yete, noreko Sapat naruko ŋuno se khumo uni yorato meté tewaŋgope ma kini?” ");
INSERT INTO nca_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ŋunde osese yereró, quko mande topé ka kama taŋgurí. Ko uni ŋu riní meté tero toŋeró. ");
INSERT INTO nca_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ko ŋande osese yereró, “Asa ye soso naŋoye kape ma makao ka Sapat naruko ŋuno meréko rokaráŋo uweya tiníqo, waka ta wosoyi areweya, hamómbe?” ");
INSERT INTO nca_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ko enendo mande ka kama yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","O ne-neko ŋuno uni maheŋgurí ŋundo yakutí korete quno kunditewero yero iŋaŋgurí. Yesuko yiyoro tapara mande ka ŋande yimiraró. ");
INSERT INTO nca_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ko ke uni kato pare keta rero neko kiriní o newero uroqo, ke yakutí korete quno ma kunditewero. Dokoro uni ka owí ŋundo ke owéŋge takate ŋuya maheweya, peka. ");
INSERT INTO nca_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ŋundo mahiníqo, uni neko kereró ŋundo ŋande yeweya, ‘Yakutí ŋu rotoya uni ŋa ino,’ yiní ke kowi piyo tero sore uro makono kunditeweya. ");
INSERT INTO nca_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kini, uni kato o newero quro neko kiriníqo, ke uro yakutí makono quno ŋuno naŋge kundite qembe. Ke ŋunde tiqo, uni neko kereró ŋundo mahero ŋande yeweya, ‘Topo, ke mahe yakutí korete quno ŋano kundite.’ Ŋunde yiníqo, uni soso o neyoteŋgo ŋundo owéŋge hokowaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Dokoro uni kato eneŋo owí riní hokoyote quko Anutuko riní umbuweya. Ko uni kato eneŋo owí riní umbuyote quko Anutuko owí hokoní oweya.” ");
INSERT INTO nca_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesuko unindo ene nekaró ŋu ŋande miraró, “Ke o ne-ne ka teweya quno, keŋo topo-topoke, kone-topoke, suwisawike, uni wondoye moré qu ma neko yerewero. Ŋunde ti enepa naŋge imemoŋgo topé meté tero neko kerewaŋgo koro. ");
INSERT INTO nca_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kini, ke o ne-ne parámi ka teweya quno, asa uni owéye moré kini mu, koweye piyo taró mu, kheye piyimi mu, toŋeye kiré mu, ŋu neko yere qembe. ");
INSERT INTO nca_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Uni ŋunde qundo o newero ŋuro topé tewero mepémo kini. Ŋunde ŋuro ke puriŋo ka reweya, dokoro, imemoŋgo Anutuko uni roneneŋowí ŋu uni tapu koŋgo yoriní otoqowaŋgo quno, topé meté kunoweya.” ");
INSERT INTO nca_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Asa eneya o naŋgurí qu kato Yesu ŋande miraró, “Ŋu unipare Anutuko unipareyó wiri yereyote naruyómo ŋuno o newaŋgo qundo meté horé yowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ko Yesuko ŋande yaró, “Naru kano uni kato o ne-ne parámi tero unipare qambu mahewero quro neko yereró. ");
INSERT INTO nca_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","O ne-ne ŋu tunoqewero tiní sunará simóŋo asáŋoní unipare komo neko yereró ŋuno naŋge yimiraró, ‘Ye mahi, o ne-ne ŋu roŋgaruwoteŋgo.’ ");
INSERT INTO nca_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Quko uni soso ŋundo owero ŋuro piyimiŋaŋgurí. Kato ŋande yaró, ‘Noko mira ka kimano, ŋu qenewero uyarewano, ye iŋoteno. Iniyaqe, o ne-neko ŋuno uyarewero mepémo kini.’ ");
INSERT INTO nca_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Ko kako ŋande yaró, ‘Noko makao kho tewero kande irisa ŋu kimo yereno, ŋu khoye date tewaŋgo ŋu qenewero uyarewano, ye iŋoteno. Iniyaqe, o ne-neko ŋuno uyarewero mepémo kini.’ ");
INSERT INTO nca_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Ko kako ŋande yaró, ‘Itaka naŋge epe re-re taro. Ŋu murí ŋuro no uyarewero mepémo kini.’ ");
INSERT INTO nca_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ŋunde yi sunará simó ŋu rohoréŋo mahero uni parámiyó mande yaŋgurí ŋuro miraró. Mironí saŋgirí tero ŋande miraró, ‘Ke waka ta yendé keweroko ŋuno uyareya, ya kimbino soso toŋeya uni owéye moré kini qu, uni koweye piyo tete qu, uni toŋeye kiré mu, uni kheye piyimi mu ŋu soso yore mahi,’ yaró. ");
INSERT INTO nca_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Yiní uyaro yaró ŋu tiní kini tiní mahero ŋande yaró, ‘Uni Parámi, no ŋunde teteno, quko yake kama maŋgoreyote.’ ");
INSERT INTO nca_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Yiní ŋande miraró, ‘Meté khewore qu ŋuya sikuwore qu ŋuya yore mahe. Ŋunde ti yane maŋgoreweya. ");
INSERT INTO nca_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Hamó, no ŋande yimiroteno, unipare soso komo neko yerenowó ŋundo o ne-ne ŋaro sombé ka kama newaŋgo,’ yaró.” ");
INSERT INTO nca_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Asa ŋu naruko ŋuno unipare qambu horé Yesu koya khe yateyaŋgo, ko ene rohoréŋoro ŋande yimiraró, ");
INSERT INTO nca_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Uni ka nono mahewero ye iŋoyote quko, ene iwí, nimí, parí, simó, topé-topé, simó-kuwí eneŋo yoto-yotoyó ŋuya kama huwó yereyote tiníqo, ŋuko neneŋo iŋo-iŋo rewero unine tewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Uni ka tipiririyó re koroworo no kama nohoweweya quko, ene neneŋo iŋo-iŋo rewero unine tewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Qeni, ye kanata kato, ya parámi ka rewano, ye iŋoyote quno, koretero ya ŋuro kimoyó ŋu qene iŋoroqota, moneyó ŋundo ya ŋu meté remukoweyape ma kini, ye iŋo rondaŋeweya, hamómbe? ");
INSERT INTO nca_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Yate ene tatá naŋge raŋoní moneyó kini tiní uni soso qenero huwó mande ye inowaŋgo koro. ");
INSERT INTO nca_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Hamó, ŋande yewaŋgo, ‘Uni ŋando hurí tero ya ŋa raró muko kini tewero mepémo kini.’ ");
INSERT INTO nca_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Kowe wiri yerete uni kato wiri yerete uni meyowomboya kuma teweya quno ŋuno, koretero eneŋo wimbí qene iŋo rondaŋeweya. Eneŋomboko kuma uni 10,000, ko meyowomboko kuma uni 20,000 maheteŋgo. Ŋunde tero kuma meté takawaŋgope ma kini ye qene iŋo rondaŋeweya. ");
INSERT INTO nca_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Qene iŋo rondaŋero mepémo kini tiníqo, saŋgirí uni ŋu kapiyamo yuri keweroko uni ka asá yiriní kiro mande ŋu ri umbuwero quro uyarewaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ŋundiro naŋge, ye kanata kato oyó soso ŋu kama huwóŋoweya tiníqo, ene neneŋo iŋo-iŋo rewero unine tewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ŋunde ŋuroko, iŋi. Nembo ŋuko o meté mu. Quko nuŋgurí ŋu kini tiníqo, date tatoqo meté teweya? ");
INSERT INTO nca_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kini, nuŋgurí ŋunde kini tiníqo, khoyó kini teweya. Norendo khono kama raŋoyoteto, ko makao koro qo quno ŋuno kama reyoteto. Kina raŋoyoteto. “Asa uni ka kusumbí moré tiníqo, mande ŋa iŋoweya.” ");
INSERT INTO nca_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Asa takis re-re unindoya quhurí unindoya soso kutaqe Yesuko mahero mandí ŋu iŋoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ŋunde ti Farisi unindoya hutuŋo mande ŋuro iŋo-iŋo uni ŋuyako kisikasa yero ŋande yaŋgurí, “Ŋa uni ŋako quhurí uniparetoya topo tero o kopo neyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kowe Yesuko tapara mande ka ŋande yimiraró, ");
INSERT INTO nca_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ko ye kanata kato sipsip 100 ŋunde sopo yereyote qu, ko kanata na sore toŋiníqo, sipsip 99 kasina yoteŋgo ŋu yorotoro sipsip kanata ŋu seqa qeneweya, hamómbe? ");
INSERT INTO nca_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ko seqayate qenero niŋgu-niŋgu tero hokoro wapémo koroworo re yendémo maheweya. ");
INSERT INTO nca_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Re mahero topé-topé neko yiriní mahi ŋande yimiroweya, ‘Ye noya niŋgu-niŋgu ti. Dokoro sipsipne sore toŋeró ŋu pitu ko reteno,’ yeweya. ");
INSERT INTO nca_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“No ŋande yimiroteno, ŋundiro naŋge quhurí uni kanata kato newondí rohoréŋoníqo, niŋgu-niŋgu parámi samboko tunoqeweya. Quko uni roneneŋowí 99 newondeye meté yote qu ŋuro niŋgu-niŋgu tomó ta naŋge tunoqeweya. ");
INSERT INTO nca_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ko ye date iŋoteŋgo, pare kato wondo musiyó kande irisa towoyote, ko kanata ka rotoní umbuníqo, suru tupuŋoro yakutí kiriyoro meté ta seqayate qeneweya, hamómbe? ");
INSERT INTO nca_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ko seqayate qenero topé-topé neko yiriní mahi ŋande yeweya, ‘Ye noya niŋgu-niŋgu ti. Dokoro wondo musiyó ka rotowe umburó mu seqayate reteno,’ yeweya. ");
INSERT INTO nca_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“No ŋande yimiroteno, ŋundiro naŋge sambo simómbo quhurí uni kanata kato newondí rohoréŋote qu qenero Anutu toŋímo niŋgu-niŋgu teyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesuko ŋande yaró, “Uni ka simó irisa. ");
INSERT INTO nca_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Naŋuní tukú ŋundo iwí ŋandiro miraró, ‘Awa, imemoŋgo oke soso rondaŋe nore irisa se nunoweya. Meté, itaka naŋge rondaŋe neneŋo qu se nuno,’ yaró. Yiní iwímbo o ŋu rondaŋero irisa-irisa se yunaró. ");
INSERT INTO nca_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Se yunoní waka ta naŋge naŋuní tukú ŋundo o ŋuno qu se riní uni topémbo kimo taŋgurí. Ŋunde ti mone rero mira kapiyamo ŋuno toŋeró. Ŋuno yotoro o wimbo-wimbo teyoní moneyó kini taró. ");
INSERT INTO nca_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","“Asa mone ŋu kini tiníqo, korare parámi mira ŋuno tunoqaró. Tunoqiní o qímboro khumaró. ");
INSERT INTO nca_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ŋunde tero uyaro mira simburí kano kho taró. Mira simburí ŋundo asáŋoní po hoŋgo quroko uyaro poyó sopo yereró. ");
INSERT INTO nca_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Po sopo yiriní poto qohe soŋo naŋgurí. Ŋu ene ŋuya qohe soŋo ŋu se newero iŋaró. Quko uni kato o qímboro ka kama inaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Asa yate iŋondutuyó hiyóqiní ŋandiro ye iŋaró, ‘Ko awanemboro kho uni ŋuko o parámi neyoteŋgo. Quko no ŋano yotoro qonemboro parámi khumoyoteno. ");
INSERT INTO nca_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","No awane qenewero toŋero ŋande mirowano, “Awa, no Anutu toŋímo quhurí tanowó, ko ke toŋeŋgemo ŋuya o piyimi tanowó. ");
INSERT INTO nca_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Noko uni piyimi, keŋo naŋoŋge kaŋuya kini yowano. No norotoka keŋo kho uni naŋge yowe,” ŋunde yewano,’ ye iŋaró. ");
INSERT INTO nca_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Ŋunde ye iŋoro otoqoro iwímo uyaro kapiyamo yoníqo, iwímbo qenero sikí tero, kheŋgeŋoro uyaro towo pisiyoro mutó inoyaró. ");
INSERT INTO nca_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Ko naŋunímbo ŋande yaró, ‘Awa, no Anutu toŋímo quhurí tanowó, ko ke toŋeŋgemo ŋuya o piyimi tanowó. Noko uni piyimi, keŋo naŋoŋge kaŋuya kini yowano.’ ");
INSERT INTO nca_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Ŋunde yiní iwímbo sunará simó neko yiriní mahi ŋande yimiraró, ‘Neneŋo tuwi meté piru ŋu waka ta re maheya kusiyo ini. Kande pusirí tombo ka ŋu ŋuya re mahe kandímo reya khe punu-punu khímo ri. ");
INSERT INTO nca_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ko uyareya makao simó kowí tinditiwí ŋu uto re mahika qa neya niŋgu-niŋgu tato. ");
INSERT INTO nca_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Dokoro naŋone ŋa komo khumaró muko itakako otoqote; simó kini taró qu pitu qeneteno.’ Ŋunde tero hurí tero hoho teyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Asa simó korete ŋundo khono ŋuno yoraró. Kho rotoro yano kutaqemo ŋuno mahero iŋoníqo, uni sumbí huworo yambo quno teyaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Teyuri iŋoro simó ka nekoro oseseyaró, ‘Ŋu do ka teyoteŋgo?’ yaró. ");
INSERT INTO nca_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Yiní ŋande yaró, ‘Koneke pitu ko mahiní, awaŋgepo makao kowí tinditiwí mu ka urote. Dokoro, awando simó ŋu meté yate mahiní qenero rete.’ ");
INSERT INTO nca_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ŋunde yiní iŋoro saŋgirí tero ya quroko owero piyimiŋaró. Tiní iwí mirako umburo kondé oseseyoní ");
INSERT INTO nca_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","iwímboro mandí topé ŋande yaró, ‘Qeno, no kumima naru parámi keŋo koweyumu teyano. Ko keŋo mande kondéke kama wendaqeyano. Ko keto naru kanata quno meme simó kanata ka re nuni topo-toponemboya nero niŋgu-niŋgu kama teyato. Kini horé. ");
INSERT INTO nca_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Quko naŋoŋge ŋuko keŋo oke rero sesawa pareko raŋoní kini tiní mahete ŋu. Mahiní keto eneŋo makao simó kowí tinditiwí mu urote,’ yaró. ");
INSERT INTO nca_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Yiní iwímbo ŋande miraró, ‘Naŋone, keko naru rokóŋoro noya yote. Nondo one soso ŋa keŋo naŋge. ");
INSERT INTO nca_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Quko itaka naruko ŋano nore niŋgu-niŋgu tero newondenani meté tete, dokoro, koneke ŋako khumaró, quko itaka yoto-yoto rete. Ene piyo taró, quko itaka pitu ko qeneteto.’” ");
INSERT INTO nca_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesuko iŋo-iŋo rewero uniyó ŋande yimiraró, “Kho uni kato onoŋo unindoro oyó sopoyara. Kowe kumi kato mahero uni onoŋoyó moré ŋu ŋande miraŋgurí, ‘Kho unikepo keŋo o qu kumi kina rotoyote.’ ");
INSERT INTO nca_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","“Ŋunde yi enendo kho uni ŋu nekoro miraró, ‘Mande ŋa iŋoteno ŋako do mande ka? Ke uya neneŋo o qu ke kandekemo yote ŋuro piŋa mandeyó nakayáŋo nuno. Dokoro keto neneŋo onoŋone kaŋuya sopoyowero mepémo kini.’ ");
INSERT INTO nca_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Asa kho uni ŋu newondí moŋgo ŋande ye iŋaró, ‘No date tewano? Uni paráminembo sopo-sopo koro khone moŋgo nohowete. No noko sewero kho ŋuro no wimbune moré kini. Unino qonemboro kira yerewero kowi piyo teteno. ");
INSERT INTO nca_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Asa ko nondo oka ka tewekata uni paráminembo sopo-sopo khone moŋgo nohowiníqo, unindo noya topo tero nori yayemo owano.’ ");
INSERT INTO nca_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ŋunde ye iŋoro uni kumi uni parámiyemboro utatá taŋgurí ŋu kanata-kanata neko yiriní maheŋgurí. Koretero maheró mu ŋande oseseyaró, ‘Ke uni paráminemboro utatáŋge date yote?’ ");
INSERT INTO nca_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Yiníqo, ŋande yaró, ‘Kiruwó parámi, asa sono kusí parámi 100 ŋundiro.’ “Yiní ŋande yaró, ‘Ke sokome ŋu reya waka ta kunditeya 100 ŋu rotoya 50 naŋge nakayáŋo.’ ");
INSERT INTO nca_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ko tukú ka mahiní oseseyaró, ‘Keŋo utatáŋge date yote?’ “Yiníqo, ŋande yaró, ‘Wit parámi, asa toŋgo kome puŋge parámi 100 ŋundiro.’ “Yiní ŋande yaró, ‘Ke sokome ŋu reya 80 naŋge nakayáŋo.’ ");
INSERT INTO nca_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ŋunde tiní imemoŋgo uni parámiyómbo kho uniyó piyimi ŋu owí hokaró. Dokoro enendo iŋo-iŋo meté rero kho taró. Hamó, noko unipareto topoyemboya kho tewero quro murí iŋomukoteŋgo. Iŋo-iŋoye ŋundo ŋundiro naŋge hiyó koro uniparetoro iŋo-iŋoye takayote. ");
INSERT INTO nca_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ko no ŋande yimiroteno, ye noko ŋaro mone ŋu reya kho tiqo, unipare yeya topo meté tewaŋgo. Imemoŋgo mone ŋu kini tiníqo, yendo ya suki-suki quno ŋuno meté owaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Kowe uni kato o tomó ta ka meté ta sopoweya quko o parámi ŋu ŋuya meté ta sopoweya. Kowe uni ka o tomó ta naŋge piyimi sopoweya quko o parámi quno ŋuya piyimi sopoweya. ");
INSERT INTO nca_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Asa ko ye noko ŋaro mone ŋu meté kama sopowaŋgo tiníqo, dando ye o hamó ŋu se yunoní sopowaŋgo? ");
INSERT INTO nca_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kowe ye meyowomboro o qu meté kama sopowaŋgo tiníqo, dando yeŋo o qu se yunoweya? ");
INSERT INTO nca_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kho uni kato sopo-sopo uni irisa quro kho qu tewero mepémo kini. Dokoro enendo karo newonde meté inoweya, ko karo newonde piyimi inoweya. Kaya womoweya, ko kako yesaráŋoweya. Ŋunde naŋge ye Anutu koya situwi koya irisa-irisa kasirayarimo yowero mepémo kini.” ");
INSERT INTO nca_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Asa Farisi unindo mandí ŋu iŋoro huwóŋaŋgurí, dokoro enendo mone ŋuro metéŋoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Enendo ŋande yimiraró, “Yeko unindoro toŋeyemo uni roneneŋowí yoteŋgo, peka. Quko Anutuko newondeye qene iŋomukote ŋu. Dokoro oka unindoro toŋeyemo o meté horé ka yote ŋuko Anutu toŋímo o piyimi horé mu naŋge teyote.” ");
INSERT INTO nca_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Komo Hutuŋo Mande koya Ye-ye Unindoro mandeye ŋuya yora, yate-yate Jon tunoqaró. Tunoqiní, yate-yate Anutuko unipareyó wiri yereyote naruyó ŋuro miti mande ŋu yesowo yeyoteŋgo, ko uni qambu ŋu naruko ŋuno owero ŋuro kondé iŋoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Sambo ŋuya noko ŋuya meté waka ta kini tewari, quko hutuŋo mande tomó ta-ta ŋuya parámi ta-ta ŋuya waka ta kini tewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ko uni kato eneŋo parí rotoro pare meyowo rete ŋuko se simbururu tete. Ko uni kato pare ka komo meyowombo rotaró ŋu reweya ŋuko se simbururu tete. ");
INSERT INTO nca_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Onoŋo uni ka yora, naru rokóŋo kowe punu-punu meté-meté qu teyara. Naru rokóŋo hoho tero o parámi neyara. ");
INSERT INTO nca_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Uni onoŋoyó moré kini ka, owí Lasarus, mama piyimi kowí wisumuŋoní, topémbo ri onoŋo unindoro hoŋgo makoyó sumeyoro eteyara. ");
INSERT INTO nca_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","O qímboro khumoro o kumi onoŋo unindoro yakutíŋo kusuŋo quroko umbuyaró ŋu se newero ŋuro kondé iŋoyara. Quko isako mahero mamamboro kumbuyó kowíwore umbuyara ŋu mipiyembo neyapoyaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Asa imemoŋgo uni onoŋoyó moré kini ŋu khumoní sambo simómbo re koroworo samboko Abraham taŋgímo rotaŋgurí. Onoŋo uni ŋu ŋuya khumoní re tapuŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Khumoro uni khumowí ŋuro yendéyemo ŋuno yotoro kowe surumí parámi horé teyara. Ŋunde tero toŋetero Abraham kapiyamo qeniní Lasarus taŋgímo yora. ");
INSERT INTO nca_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Yoní qenero ŋande kiwaró, ‘Awa Abraham, sikíne te nuno. Lasarus mitoka sono ka soŋga ta re umbuya mipinemo riníka soŋga ta imaqiní. No kewáko ŋano yotoro kowe surumí parámi horé teyoteno.’ ");
INSERT INTO nca_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Quko Abrahamko ŋande yaró, ‘Naŋone, iŋo. Keto toŋe keta yotoro o soso meté ŋu siyoyaró. Lasarusko o soso piyimi ŋu siyoyaró. Quko itaka ŋa ene yendémo ŋano newondí meté horé yoroní ke kowe surumí parámi reyote. ");
INSERT INTO nca_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","O kaŋuya yote. Noreya, keya keweronanimo Anutuko koŋó parámi ka raró. Ŋunde ŋuro unindo koŋó ŋu karóŋoro yeno uyarewero mepémo kini. Ko uni andusinaŋgo koŋó ŋu karóŋoro noreno ŋano mahewero mepémo kini.’ ");
INSERT INTO nca_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Yiníqo, ŋande yaró, ‘Asa ko, awa, no kira kereteno, metémbe ke Lasarus asáŋi awanembo yano uyareweya. ");
INSERT INTO nca_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","No one-topone kandeka yoteŋgo. Asa Lasarusko mande kondé yiníka eneŋo oteteye roŋgaruwowaŋgo. Ŋa yendémo ŋano mahero kowe surumí parámi horé tewaŋgo koro.’ ");
INSERT INTO nca_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Quko Abrahamko ŋande yaró, ‘Moses koro mande koya Ye-ye Unindoro mandeye koya yorote. Meté ene ŋuro kusumbo re iŋowaŋgo.’ ");
INSERT INTO nca_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Yiníqo, ŋande yaró, ‘Awa Abraham, kini. Ŋunde kini. Quko uni ka komo khumoro uni tapu koŋgo otoqaró qundo eneno uyareweya tiníqo, ene meté newondeye rohoréŋowaŋgo.’ ");
INSERT INTO nca_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Yiníqo, ŋande miraró, ‘Ko enendo Moses koro mande quya Ye-ye Unindoro mande quya kama iŋowaŋgo tiníqo, enina, uni tapu koŋgo otoqaró ŋu ŋuya kama iŋowaŋgo.’” ");
INSERT INTO nca_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Asa Yesuko iŋo-iŋo rewero uniyó ŋande yimiraró, “O enesó-enesó ŋundo unipare yoriní o piyimi tewaŋgo, ŋu hamó tunoqeweya. Quko uni o enesó-enesó ŋu teyote, iniyaqe, quhurí piyimi korowoweya. ");
INSERT INTO nca_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ko uni kato tomó ta qu ka riní o piyimi teweya ŋuko piyimi horé. Meté koretero unindo wondo parámi ka eneŋo puŋímo kusiyoro re windi quroko raŋi khumoroqota o piyimi ŋunde qu kama teweya. ");
INSERT INTO nca_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ye yeŋomboro kawaware ti. “Ko topoke kato o piyimi tiníqo, keto mitoka oteteyó ŋu roŋgaruwoweya. Ko newonde rohoré tiníqo, asa quhuríŋo re roto qembe. ");
INSERT INTO nca_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Asa ko enendo o piyimi te kunoro naru kande saŋiyoro irisa ŋunde tiníqo, ko naru kande saŋiyoro irisa quno ŋunoko keno mahero ŋande kimiroweya, ‘No newonde surumí teteno,’ yiníqo, quhuríŋo re roto qembe.” ");
INSERT INTO nca_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Asa asá yerewí uni ŋundo Uni Parámi ŋande miraŋgurí, “Keto iŋondutunani ŋu reka parámi horé tiní.” ");
INSERT INTO nca_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yi ŋande yimiraró, “Enina, iŋondutuye tomó ta horé, asa mastet taŋgurí ŋunde qembe, ŋunde tero te parámi ŋu ŋande mirowaŋgo, ‘Ke huríŋge tumoya rotoya ke uya windi quroko amuno kaŋeyoto,’ yiqo, asa te ŋu maŋgoye howeweya. ");
INSERT INTO nca_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Asa ye keweroyemo kato sunará simóŋo mironí uro kho roŋgaruwotepe ma sipsip sopo yerete. Asa kho simó ŋundo yano mahiníqo, uni parámiyómbo ŋande miroweya, ‘Ke waka ta mahe kunditeya o ne,’ yeweya, peka? ");
INSERT INTO nca_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kini, uni parámi ŋundo kho simó ŋu ŋande miroweya, ‘Ke neneŋo o newero qu roŋgaruwo nunoya o soso sunará teya samaka nereka newe. Imemoŋgoko kepa naŋge ne qembe.’ Ŋundiro naŋge yeweya, hamómbe? ");
INSERT INTO nca_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kowe sunará simó ŋundo mande ŋu iŋo howiníqota uni parámiyómbo eneya, eso, yeweya, peka? Kini. ");
INSERT INTO nca_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Asa ye ŋuya, Anutuko o komo yaró ŋu howeroqota ŋande yi qembe, ‘Nore sunará simó meté kini. Noreŋo khonani naŋge teyoteto.’” ");
INSERT INTO nca_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Asa Yesu khe howeyate Yerusalem oro Samaria mira koya Galili mira keweroyariwore uyaró. ");
INSERT INTO nca_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Uyaro yendé kano mahiní kowí piyimi khumo uni kande irisa ŋunde mahero kheko qeneŋgurí. Qenero tíko kaŋero ");
INSERT INTO nca_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","kondé ŋande neke kiwaŋgurí, “Yesu, awa, ke noreŋo sikínani te yuno.” ");
INSERT INTO nca_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ŋunde yiqo, yiyoro ŋande yimiraró, “Ye uyareya koweye se o qa-qa uni witú yiri.” Ŋunde yiní iŋoro uyareŋgurí muno ŋuno naŋge koweye muko sara tunoqaró. ");
INSERT INTO nca_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Asa keweroyemo kanata kato kowí qeniní meté tiní, rohoréŋo uyaro ki parámi tero Anutu owí hokaró. ");
INSERT INTO nca_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Mahero Yesu khímo umbu raŋoro yuŋgunaŋaró. Uni ŋuko Samaria koro wini qu ka. ");
INSERT INTO nca_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesuko uni ŋu qenero yaró, “No iŋoteno, uni kande irisa ŋunde sara teteŋgo. Quko uni kande saŋiyoro nimí kini qu, ŋu dano yoteŋgo? ");
INSERT INTO nca_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Yuto uni ŋando naŋge meté mahero Anutu koro owí hokoweya, peka?” ");
INSERT INTO nca_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yero ŋande miraró, “Ke otoqo uyare. Keŋo iŋondutukepo koriní meté tete ŋu.” ");
INSERT INTO nca_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Asa naru kano Farisi unindo do naruko Anutuko unipareyó wiri yereyote naruyó ŋu maheweya ŋuro Yesu oseseyaŋgurí. Ŋunde yi mande topé yaró, “Ko yendo kondé toŋetero Anutuko unipareyó wiri yereyote naruyó ŋu qenewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Unipareto ŋande kama yewaŋgo, ‘Ŋano yote,’ ma, ‘Anduno na.’ Dokoro Anutuko unipareyó wiri yereyote naruyó ŋuko ye quroko yote.” ");
INSERT INTO nca_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ŋunde yero iŋo-iŋo rewero uniyó ŋande yimiraró, “Imemoŋgo ye Unindoro Naŋuní ŋuro naru kanata qu qenewero kondé ye iŋowaŋgo, quko qenewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ko uni kato yimirowaŋgo, ‘Ŋuno yote,’ ma ŋande yimirowaŋgo, ‘Ŋano na.’ Quko kheŋgeŋo ŋuno ma uyarewero. ");
INSERT INTO nca_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Dokoro Unindoro Naŋuní ŋuro naruyó ŋuko rowá ŋunde qembe tunoqeweya. Rowá ŋundoko kasina-kasina mahero koporé soso hiyóqeyote. ");
INSERT INTO nca_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Quko koretero enendo kowe surumí qambu korowoní unipare itaka yoroteŋgo ŋundo huwóŋowaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Unindoro Naŋuní ŋuro naruyó ŋuko Noa koro naruyó ŋunde qembe. ");
INSERT INTO nca_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Asa Noa koro naruko ŋuno unipareto o ne-ne parámi tero epe re-re teyuri, yate Noako waŋgo quroko oní sono riru parámimbo unipare soso ŋu rambaruru yereró. ");
INSERT INTO nca_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Ko Lot koro naruyó ŋuya ŋunde naŋge. Unipareto o qoyemboro nero, situwi kimoro soweyoro, o yuwoyó rimiro, ya reyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ŋunde teyuri, yate Lotko Sotom yendé ŋu rotoní kewá koya wondo tiwi salfa ŋu sambo koŋgo umburo unipare soso ŋu rambaruru yereró. ");
INSERT INTO nca_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Ko Unindoro Naŋuní tunomo tunoqeweya naru ŋu ŋuya ŋunde naŋge. ");
INSERT INTO nca_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ŋu naruko ŋuno ke ya umómo yuri oke soso ya quroko yoweya tiníqo, o ŋu siyowero ŋuro quroko ma uwero. Ŋundiro naŋge, ke khono yote tiníqo, yendémo kaŋuya ma uwero. ");
INSERT INTO nca_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","O ŋu Lot parí saŋano tunoqaró ŋuro ma kape tewero. ");
INSERT INTO nca_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Dani kato eneŋo yoto-yotoyó ŋuro kawaware teyote ŋuko yoto-yotoyó rotoro kini teweya. Ko dani kato yoto-yotoyó rotote ŋuko meté yoweya. ");
INSERT INTO nca_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","No ŋande yimiroteno, suwono ŋuno yereka irisa kato yakutí kanata quno eteyoriqo ka rewaŋgo, ka rotowaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Pare irisa wit musiyó rumuniŋoyoriqo ka rewaŋgo, ka rotowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(-) ");
INSERT INTO nca_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ŋunde yiní ŋande oseseyaŋgurí, “Uni Parámi, ŋu dano tunoqeweya?” Yi ŋande yimiraró, “Ukúŋo dano yote quno ŋuno nú saŋgirí parámi ŋundo ŋuno mahero kopoyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Asa Yesuko iŋo-iŋo rewero uniyó tapara mande ka yimiraró. Mande ŋuro murí muko ŋandiro: meté naru rokóŋo hariri tero ma piyimiŋowero. ");
INSERT INTO nca_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ene ŋande yaró, “Yendé kanata kano ronda-ronda uni ka yaró. Ŋu ronda-ronda uni ŋu Anutu koro kama sasaro tero unindoro owéye ŋuya kama iŋaró. ");
INSERT INTO nca_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Wapu ka ŋuya yendé ŋuno yaró. Naru rokóŋo ene ronda-ronda unino ŋuno mahe ŋande mito yaró, ‘Saŋgiríne ŋundo no rambaruru nerewero teyote. Asa samaka nereya saŋgirí ŋu kusiyo,’ yaró. ");
INSERT INTO nca_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Naru piru ŋunde teyaró, quko ronda-ronda uni ŋundo samakaŋowero ŋuro piyimiŋaró. “Yate ene ŋande iŋaró, ‘Hamó, no Anutu koro kama sorero unindoro kama iŋoteno. ");
INSERT INTO nca_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Quko wapu ŋundo naru suki-suki no quhurí nunoyate imemoŋgo newondene piyo teweya. Ŋunde ŋuro no samakaŋoro saŋgiríŋo kusiyowe,’ yaró.” ");
INSERT INTO nca_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Asa Uni Parámimbo ŋande yaró, “Ye ŋu ronda-ronda uni piyimi ŋuro mandí ŋu iŋoyi. ");
INSERT INTO nca_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Asa Anutuko unipare rokó yereró ŋu naru rokóŋo eneŋo neko kiweyoteŋgo ŋu samaka yereweya, hamómbe? Enendo, ‘Imemoŋgo ta,’ naŋge yeweya, peka? Kini horé. ");
INSERT INTO nca_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nondo ye yimiroteno, waka ta horé samaka yereweya. Quko Unindoro Naŋuní ŋundo maheweya quno ŋuno, unipareto iŋondutu teyoteŋgo ŋunde qu noko ŋano seqa yiyoweyape ma kini?” ");
INSERT INTO nca_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Asa Yesuko uni kumi tapara mande ka yimiraró. Uni ŋundo, “Noreko uni roneneŋowí hamó,” yero uni soso meyowo huwó yereŋgurí. Tapara mande ŋuko ŋandiro. ");
INSERT INTO nca_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Uni irisako hariri tewero Ya Surumímo oriyó. Kako Farisi uni ka, ko kako takis re-re uni ka. ");
INSERT INTO nca_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Asa Farisi uni ŋu kaŋero newondímo ŋande hariri taró, ‘O Anutu, nondo uni soso meyowo ŋunde kini, ŋunde ŋuro no keya eso yeteno. Enendo momo teyoteŋgo, otete piyimi mu teyoteŋgo, ko se simbururu teyoteŋgo. Quko noko kini. Ko noko takis re-re uni andu qembe ŋunde kini. ");
INSERT INTO nca_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Sonda keweroko kosa naru irisa quno ŋuno no kundiŋi teyoteno. Ko nondo o soso siyoyoteno, ŋuko nondo rondaŋewe kande irisa tiní kanata re kunoyoteno.’ ");
INSERT INTO nca_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ŋunde yaró, quko takis re-re uni ŋu sewemo kaŋero, ene korewore toŋete sambo qenewero piyimiŋaró. Ene newonde surumí tiní nomoní utoro ŋande yaró, ‘O Anutu, noko quhurí uni. Keto sikíne te nuno,’ yaró.” ");
INSERT INTO nca_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Nondo ye yimiroteno, ŋu naruko ŋuno takis re-re uni ŋu pitu yayómo uníqo, ŋundo naŋge uni roneneŋowí Anutu toŋímo tunoqaró, meyowo kini. Dokoro, uni soso eneŋo owéye hokoyoteŋgo ŋuko, Anutuko uni ŋu yoriní umbuwaŋgo. Ko uni soso owéye ri umbuyote ŋuko, Anutuko eneŋo owéye hokoweya.” ");
INSERT INTO nca_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Unipareto simó ta-ta oŋa qu yorero Yesuko kandí kembayemo rewero quro eneno maheŋgurí. Quko iŋo-iŋo rewero uni ŋundo yiyo yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Asa Yesuko neko yerero ŋande yaró, “Ye simó ta-ta tomó ta-ta ŋu yorotika nono mahe, ma soré yerewero. Dokoro Anutuko unipareyó wiri yereyote naruyó ŋuko simó ŋunde quro na. ");
INSERT INTO nca_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nondo ye hamó yimiroteno, uni kato simó qembe tero Anutuko unipareyó wiri yereyote naruyó ŋuro kama metéŋoweya tiníqo, ŋundo naru ŋuro quroko ŋuno kama oweya. Kini horé.” ");
INSERT INTO nca_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Sopo-sopo uni kato ŋande oseseyaró, “Rondaqe-rondaqe uni meté, no date tero yoto-yoto suki-suki ŋu rewano?” ");
INSERT INTO nca_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yiní Yesuko miraró, “Ke do karo no, meté, yero neko nerete? Anutu kanata ŋu naŋgeko meté. ");
INSERT INTO nca_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Asa mande kondé enesó-enesó ŋu ke iŋomukote: se simbururu ma tewero, uni ma yuri khumowero, momo ma tewero, mande khono ŋuno kota mande ma yewero, awa-náŋge ará te yuno qembe.” ");
INSERT INTO nca_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Yiní ŋande yaró, “Nondo simó tomó ta quno hutuŋo mande soso ŋu howeyate itaka uni parámi teteno.” ");
INSERT INTO nca_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Asa Yesu mande ŋu iŋoro miraró, “O kanata ka yote. Keŋo situwi soso soweyoya mone ŋu rondaŋe uni oye moré kini ŋu yuno. Ke ŋunde teroqo, o meté samboko reweya. Asa ŋunde teya ke mahe nohowe.” ");
INSERT INTO nca_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yiní mande ŋu iŋoro newondí quhurí taró, dokoro ene onoŋoyó qambu ŋuro. ");
INSERT INTO nca_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Asa Yesuko qeniní newondí quhurí tiní ŋande yaró, “Onoŋo unipare kato Anutuko unipareyó wiri yereyote naruyómo ŋuno owero ŋuko taŋo kini, quhurí. ");
INSERT INTO nca_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamel ŋundo tisi o tiŋiyowero quwore owero rukusuwoyote. Quko uni onoŋoyó parámi ŋundo Anutuko unipareyó wiri yereyote naruyómo owero hamó horé rukusuwoyote.” ");
INSERT INTO nca_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ŋunde yiní unindo mandí iŋoro ŋande yaŋgurí, “Ŋu hamó tiníqo, ŋu danimboko rambaruru takawaŋgo?” ");
INSERT INTO nca_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yiqo, ŋande yaró, “Unindo oka tewero mepémo kini, ŋuko Anutuko naŋge meté teweya.” ");
INSERT INTO nca_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Asa Pitako ŋande yaró, “Qeno, norendo onani soso rotoro ke kohowatowó.” ");
INSERT INTO nca_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yiní ŋande yimiraró, “No hamó horé yimiroteno. Uni kato Anutuko unipareyó wiri yereyote naruyó ŋu iŋoro topé-topé, iwí-nimí, pare-simó yorotaró quko ");
INSERT INTO nca_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Anutuko itaka naruko ŋano topé meté parámi horé teyoweya. Ko naru maheweya quno ŋunoko, yoto-yoto suki-suki qu reweya.” ");
INSERT INTO nca_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Asa Yesuko iŋo-iŋo rewero uni 12 ŋu yorero ŋande yimiraró, “Iŋi, itakako Yerusalem owé teteto. Kowe mande soso ye-ye unindo Unindoro Naŋuní ŋuro nakayáŋaŋgurí ŋuko hamó teweya. ");
INSERT INTO nca_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Dokoro unindo ene rero uni wini meyowo kandeyemo rotowaŋgo. Ŋunde rotoyi huwó mande yero o pi-piyimi te inoro tuteworo ");
INSERT INTO nca_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","haususuworo uri khumoweya. Ko naru kapusayómo pitu ko otoqoweya.” ");
INSERT INTO nca_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ŋunde yiníqo, iŋo-iŋo rewero uni ŋundo kama iŋi tondaŋeyara. Mande murí ŋuko tapuŋaró, ko mande yaró ŋu iŋowero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Asa yate Jeriko kutaqemo ŋuno mahiqo, uni ka toŋí kiré mu khe sumeyoro kunditero mone koro unipare kira yereyaró. ");
INSERT INTO nca_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ŋuno kunditeyoní unipare qambu mahe takayi osese yerero ŋande yaró, “Do ka teteŋgo?” ");
INSERT INTO nca_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Yiní kumimbo ŋande miraŋgurí, “Yesu, Nasaret noŋgo uni ŋu, mahete,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ŋunde yiqo, nekoro ŋande yeyaró, “Yesu, Dewit koro naŋuní, sikíne te nuno!” ");
INSERT INTO nca_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ŋunde yeyoníqo, unipare koretero oŋgurí ŋundo qene yero ŋande yaŋgurí, “Ŋunde roto!” yaŋgurí. Quko watí-watí nekoro ŋande yaró, “Dewit koro naŋuní, sikíne te nuno!” ");
INSERT INTO nca_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Asa Yesuko mahe kaŋero yimiraró, “Re nono mahi,” yiní re woso kutaqemo ŋuno mahi Yesuko ŋande oseseyaró, ");
INSERT INTO nca_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nondo do ka te kunowe?” Yiní ŋande yaró, “Uni Parámi, noko toŋetero o qenewero ye iŋoteno,” yaró. ");
INSERT INTO nca_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ko Yesuko ŋande miraró, “Toŋeŋge meté hiyóqiní. Keŋo iŋondutukepo koriní meté tete.” ");
INSERT INTO nca_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ŋunde yiníqo, toŋí waka ta hiyóqiní pitu ko toŋetero Yesu howe uyaro Anutu owí hokoyaró. Kowe unipareto ŋu qenero Anutu seré te inaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Asa Yesuko Jeriko ŋuno oro kewerowore uyaró. ");
INSERT INTO nca_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Uni ka ŋu yendémo ŋuno yaró, owí Sakius. Ŋuko takis re-re uni ŋuro uni kembéye, ko eneko onoŋo uni ka. ");
INSERT INTO nca_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Asa ene Yesu qenewero ye iŋaró, quko ene uni tukuni ta, ko unipare qambu ŋundo wisumuŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Asa ko korete kheŋgeŋo Yesuko khe maheweya quno ŋuno uyaro qenewero te fik ka saŋano oró. ");
INSERT INTO nca_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Oníqo, Yesuko ŋuno mahero te saŋano toŋetero ŋande miraró, “Sakius, waka ta umbu. Itakako keto yano yowano.” ");
INSERT INTO nca_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Yiní waka ta umburo niŋgu-niŋgu tero Yesu re yayómo oró. ");
INSERT INTO nca_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ŋunde tiní uni soso qenero kisikasa yero ŋande yaŋgurí, “Yesuko oro quhurí unindoya yano yorote,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Asa yano ŋuno Sakius otoqo kaŋero Yesu ŋande miraró, “Uni Parámi, ke iŋo. Itakako no onoŋone rondaŋewe irisa tiní kanata ka uni onoŋoye moré kini qu yunowano. Ko no dani ka kanáŋoro oyó ka momo tanowó mu, asa itakako topé te inoro o nimí kini inowano.” ");
INSERT INTO nca_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ko Yesuko yaró, “Itakako Anutuko uni ŋaya soweyómboya rambaruru koŋgo yoreweya tete. Dokoro uni ŋako ŋuya Abraham koro sowe qu. ");
INSERT INTO nca_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Hamó, Unindoro Naŋuní ŋuko uni soso piyo taŋgurí qu seqa yere rambaruru koŋgo yorewero quro maheró.” ");
INSERT INTO nca_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Asa unipareto mande ŋu iŋoyiqo, Yesuko sowe tero tapara mande ka yimiraró. Dokoro Yerusalem kutaqemo ŋuno mahiní unipareto ŋande ye iŋaŋgurí, ko Anutuko unipareyó wiri yereyote naruyó ŋu waka ta tunomo tunoqeweya. ");
INSERT INTO nca_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ŋunde ŋuroko ŋande yaró, “Uni parámi kato, no mira sewemo uyaro unipare wiri yerewero koro owé ka rero pitu ko mahewano, ye iŋaró. ");
INSERT INTO nca_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ŋunde ye iŋoro sunará simóŋo kande irisa neko yerero mone mina kanata-kanata rondaŋe yunoro ŋande yimiraró, ‘Mone ŋaya kho tiqo pitu ko mahewano,’ yaró. ");
INSERT INTO nca_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Yendé unipareto uni parámi ŋuro saŋgirí tero hamó piyimiŋaŋgurí. Piyimiŋoro uni pará-pará asá yiri mira sewemo ŋuno wiri yerete uni kembé ŋu ŋande miraŋgurí, ‘Norendo uni ŋa nore wiri nerewero ŋuro piyimiŋoyoteto. Owé parámi ŋu ma inowero,’ yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ŋunde yaŋgurí, quko uni ŋundo owé parámi ŋu rero ene mirako pitu ko maheró. Mahero sunará simó mone yunaró ŋu neko yerero mone koya do kho ka taŋgurí ŋuro osese yereró. ");
INSERT INTO nca_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Asa kho simó korete ŋundo mahero ŋande yaró, ‘Uni parámi, nondo keŋo mina koya kho tewe sowe tero kande irisa itaka yote.’ ");
INSERT INTO nca_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Yiní ŋande miraró, ‘Meté ŋu! Keko sunará simó meté! Asa koretero kho tomó ta naŋge meté sopoyaró. Ŋunde ŋuroko itaka owé parámi ka kunowe yendé parámi kande irisa sopoyoweya.’ ");
INSERT INTO nca_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Asa sunará simó irisayó ŋundo mahero ŋande yaró, ‘Uni parámi, nondo keŋo mina koya kho tewe sowe tero kandeka itaka yote.’ ");
INSERT INTO nca_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Yiní ŋande miraró, ‘Ko itaka owé parámi ta kunowe yendé parámi kandeka sopoyoweya.’ ");
INSERT INTO nca_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Asa sunará simó meyowo ka mahero ŋande yaró, ‘Uni parámi, nondo keŋo mina ŋu tuwi ka quroko kusiyoro tapuŋanowó. Mina ŋu ŋana. ");
INSERT INTO nca_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Qeno, keŋo soranowó, dokoro ke tiwi uni tete. Keto o kumi kama raró ŋu kina siyoyote, ko o kumi kama rimiró ŋuro eŋgé siyoyote.’ ");
INSERT INTO nca_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Yiní ŋande yaró, ‘Keko sunará simó piyimi. Keŋo mandekepo naŋge topé piyimi ka kunoyote. Kepe ŋande iŋaró, ko nondo tiwi uni teteno, ko o kumi kama ranowó ŋu kina siyoyoteno, ko o kumi kama riminowó ŋuro eŋgé siyoyoteno, peka? ");
INSERT INTO nca_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ko dokoro keto wondo ŋu wondo yano kama raró? Asa no pitu ko maheteno quno ŋuno wondo ya simburímbo wondo kaŋuya saŋanímo nunoweya.’ ");
INSERT INTO nca_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ŋunde yero uni wuririyaŋgurí ŋu ŋande yimiraró, ‘Mina towote ŋu reka uni mina kande irisa towoyote ŋu inoyi.’ ");
INSERT INTO nca_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Yiní ŋande yaŋgurí, ‘Uni parámi, ene kande irisa itaka towote!’ ");
INSERT INTO nca_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Yi ŋande yimiraró, ‘Nondo ye ŋande yimiroteno, ko uni ka o kumi towote tiníqo, Anutuko o kumi kaŋuya saŋanímo rero inoweya. Ko uni oyó moré kini ŋuko, Anutuko o tomó ta qu towoyote ŋu siyoní kini teweya. ");
INSERT INTO nca_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Quko neneŋo saŋgirínembo nondo wiri yerewero ŋuro piyimiŋaŋgurí, ŋu yore mahi toŋenemo yuri khumowaŋgo.’” ");
INSERT INTO nca_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Asa Yesuko mande ŋu yiní kini tiní, khe Yerusalem owero ŋu howe oró. ");
INSERT INTO nca_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Oro mira purí Oliv ŋuno, asa Betipake yendé ko Betani yendé kutaqemo ŋuno, iŋo-iŋo rewero uni irisa kho ka yunoro asá yereró. ");
INSERT INTO nca_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ŋande yimiraró, “Yendé andusina ŋuno uyareya dóki simó ka kusiyaŋgurí qu qenewari. Komo uni kato dókiko ŋuno kama kunditaró. Asa utó orosoyero ŋano re mahiri. ");
INSERT INTO nca_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ko uni kato osese yiriníqo, ‘Do karo dóki ŋu orosoyitiri?’ yiníqo, mande topé ŋande mirori qembe, ‘Uni Parámimbo ŋuya kho ka teweya.’” ");
INSERT INTO nca_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ŋunde yiní uni asá yereró ŋundo uyaro o soso Yesuko yaró ŋu tunoqiní qeneriyó. ");
INSERT INTO nca_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Utó dóki kusiyaŋgurí ŋu orosoyiriqo, dóki ŋuro simburímbo ŋande osese yereŋgurí, “Yari date koro dóki simó ŋu orosoyitiri?” ");
INSERT INTO nca_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Yiqo, yariyó, “Uni Parámimbo ŋuno kho ka teweya.” ");
INSERT INTO nca_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ŋunde yero rero Yesuko mahiriyó. Re mahero tuwi piruyari se dóki saŋano rero Yesu re ŋuno rotori kunditaró. ");
INSERT INTO nca_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kunditero uyariní unipare tuwi piruye ŋu wendaŋero se khewore raŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Asa uyareyate khe ŋu mira purí Oliv itaqewero quno ŋuno iŋo-iŋo rewero unipare soso ŋu hurí rero o wimbí moré tiní qeneyaŋgurí ŋu iŋoro kondé nekoro Anutu owí hokoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ŋande nekoyaŋgurí, “Wiri yerete uni Uni Parámimboro owímo mahete, ŋundo puriŋo riní! Newonde ime samboko yoní, ko Anutu owí koreko horé hokoyi.” ");
INSERT INTO nca_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ŋunde yeyuriqo, Farisi uni kumimbo unipare qambu keweroye moŋgo Yesu miraŋgurí, “Rondaqe-rondaqe uni, ke iŋo-iŋo rewero unike yiyo yeka.” ");
INSERT INTO nca_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ko mande topé ŋande yaró, “Ye yimiroteno, uni maŋgoye kusiyowaŋgo quko mipu ŋundo naŋge nekoyowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kowe Yesu yendé parámi ŋu kutaqemo ŋuno mahero qenero ŋuro tendo parámi tero ");
INSERT INTO nca_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ŋande yaró, “Ye itaka date newonde ime tewero ŋuro iŋoyi tondaŋete tiníqo, meté yowaŋgo. Quko o ŋu sóqiní ye qenewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Imemoŋgo ta saŋgiríyembo wuriri yiriqo, hoŋgo parámi yendéye wuririyoro hamó wisumuŋoweya. ");
INSERT INTO nca_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Enendo yeya simóye yendémo yoteŋgo ŋuya yorero nokono raŋoro rambaruru yerewaŋgo. Ya soso rambaruruworo wondoye soso se wisikaraŋowaŋgo, dokoro yendo Anutuko mahe yiyowero naru ŋu ye kama qene iŋaŋgurí.” ");
INSERT INTO nca_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Asa Yesuko Ya Surumímboro hoŋgo quroko oro hurí rero uni mone koro kho teyaŋgo ŋuno qu yohowero ");
INSERT INTO nca_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ŋande yimiraró, “Sokomeko ŋuno ŋande nakayáŋaró, ‘Neneŋo yane muko hariri koro ya qu.’ Quko yendo ri ‘kuma tero momo teyoteŋgo unindoro ya qu teyote.’” ");
INSERT INTO nca_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Naru rokóŋoro Ya Surumímo oro mande rondaqe unipare yunoyaró. O qa-qa unindoro tapá unindoya hutuŋo mande ŋuro iŋo-iŋo unindoya uniparetoro uni kembé-kembémboya uri khumowero khe qu seqayaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Quko khe ŋu kama qeneŋgurí, dokoro unipare soso ŋundo eneŋo mandí iŋowero ŋuro maheyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Naru kano Yesuko Ya Surumímo hoŋgo quroyómo ŋuno unipare iŋo-iŋo yunoro miti mande ŋuro yimitoyaró. Ŋunde tiníqo, o qa-qa unindoro tapá unindoya hutuŋo mande ŋuro iŋo-iŋo unindoya uni kembé-kembémboya kopo mahero ");
INSERT INTO nca_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ŋande oseseyaŋgurí, “Do owé kano o soso ŋa mepémo teyote? Danimbo owé ŋu re kunaró?” ");
INSERT INTO nca_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yi mande topé yimiraró, “Ko no ŋuya ye osese yereweka nimiroyi. ");
INSERT INTO nca_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jonko unipare sono re yunaró. Asa ye date iŋoteŋgo, eneŋo kho qu tewero ŋuro owé ŋu, sambo koŋgo rarómbe ma uni noŋgo raró?” ");
INSERT INTO nca_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ŋunde yiníqo, keweroyemo epe mito-mito ŋande taŋgurí, “Ko norendo, ‘Ŋuko sambo koro qu,’ yewato tiníqo, ŋande osese nereweya, ‘Asa ye date koro mandí iŋoro iŋondutu kama taŋgurí,’ yeweya. ");
INSERT INTO nca_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Quko, owé ŋuko unindoro qu, yewato tiníqo, unipare soso ŋundo wondo raŋoro nurowaŋgo, dokoro enendo ŋande iŋondutu teyoteŋgo, asa Jon ŋuko ye-ye uni hamó ka.” ");
INSERT INTO nca_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Asa ko Yesu ŋande miraŋgurí, “Jonko o taró ŋuro owé ŋu da noŋgo raró ŋuko nore kama iŋoteto.” ");
INSERT INTO nca_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yiqo, ŋande yimiraró, “Asa ko no ŋuya da noŋgo owé ŋa rero o soso teyoteno ŋuro ye kama yimirowano,” yaró. ");
INSERT INTO nca_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Asa Yesuko tapara mande ka unipare ŋande yimiraró, “Naru kano uni kato wain koro kho ka toworo sopo-sopo uni kumi kandeyemo rotoro mira kapiyamo ŋuno uyaro naru piru yoraró. ");
INSERT INTO nca_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Yate-yate kho simburímbo sopo-sopo unindo eneŋo wain eŋgé inowero ŋuro ye iŋoro sunará simó ka asáŋoní uni khoyó sopoyoteŋgo quno uyaró. Uyariní sopo-sopo unindo rero haususuworo howi kina toŋeró. ");
INSERT INTO nca_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Imemoŋgo kho simburímbo sunará simó kaŋuya asáŋaró, quko ŋu ŋuya o pi-piyimi te inoro howi kina toŋeró. ");
INSERT INTO nca_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ko kapusayó ŋuya asáŋoní uroyi mama parámi tiní re raŋoyi kho tapémo uró. ");
INSERT INTO nca_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Asa kho simburímbo ŋande yaró, ‘No date tewe? Neneŋo naŋone, ŋuro surumí iŋoyoteno qu, ŋu asáŋowe teteno. Kho sopo-sopo uni ŋundo naŋone ŋu ará te inowaŋgo, peka.’ ");
INSERT INTO nca_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Quko kho sopo-sopo uni ŋundo, simó ŋu mahiní qenero, keweroyemo ŋande yaŋgurí, ‘Simó ŋundo iwímboro o soso ŋako imemoŋgo siyoweya. Uratoka khumoníka o ŋa soso norendo siyowato.’ ");
INSERT INTO nca_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ŋunde yero re raŋoyi kho tapémo uní uroyi khumaró. Asa, ye date iŋoteŋgo, kho simburí ŋundo, do te yunoweya? ");
INSERT INTO nca_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ŋandiro na, ene uyaro sopo-sopo uni ŋu rambaruru yerero wain koro kho ŋu uni meyowo yunoweya.” Ŋunde yiníqo, uni mandí iŋaŋgurí ŋundo yaŋgurí, “Kini horé!” ");
INSERT INTO nca_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Quko Yesuko kondé yiyoro ŋande yaró, “Asa, mande ka sokomeko ŋuno nakayáŋaró ŋu, do murí ka? “‘Ya re-re unindo wondo ka rero, piyimi, yero iŋoro re rotaŋgurí, quko itakako wondo ŋundo ya soso riní kondérewero wondo ka tunoqete.’ ");
INSERT INTO nca_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Uni soso wondo ŋuro saŋano raŋowaŋgo quko kosaŋewaŋgo. Quko wondo ŋundo uni ka saŋano umbuníqo, uni ŋu uso-soworo murutómi teweya.” ");
INSERT INTO nca_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ŋunde yiní hutuŋo mande ŋuro iŋo-iŋo unindoya o qa-qa unindoro tapá unindoya ŋande iŋaŋgurí, tapara mande yaró ŋu ene mande kho yunaró. Ŋunde ŋuroko ŋu naruko ŋuno Yesu towowero khe ka seqaŋgurí, quko unipare ŋuro soraŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Asa uni pará-pará ŋundo Yesu towowero khe ka seqaŋgurí. Ŋunde ŋuroko kaná-kaná uni asá yiri eneŋo kiraróye tapuŋoro Yesuko uyareŋgurí. Uyaro kusiyowero ŋuro mandí soso ta iŋoyaŋgurí. Mande ka piyimi yeweya tiníqo, toworo Rom koro uni kembé kandímo meté rotowaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ŋunde tero ŋande oseseyaŋgurí, “Rondaqe-rondaqe uni, nore ŋande iŋoyoteto, ko keto Anutu koro kheyó hamó moŋgo naŋge rondaqe yunoyote. Ko keto uni karo owé morémbe ma kini ŋuro kama iŋoyote. ");
INSERT INTO nca_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Asa ko ŋande yeka iŋato, norendo Sisa takis re inowato ŋuko hutuŋo mande wendaqeyotepe ma kini?” ");
INSERT INTO nca_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Asa Yesuko kaná-kaná muríye ŋu qene iŋoro ŋande yimiraró, ");
INSERT INTO nca_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Denarius ka re mahika qenewe. Asa wondo musiyó ŋano kapo-kapo ŋaya owí ŋako daniro qu?” Yiníqo, “Sisa koro qu,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ŋunde yiqo, yaró, “O kumi Sisa koro qu, ŋu Sisa se inoyi qembe. Ko o kumi Anutu koro qu, ŋu Anutu se inoyi qembe.” ");
INSERT INTO nca_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ŋunde yiníqo, kaná-kaná uni ŋundo mande unipare toŋeyemo ŋunde yaró quwore towowero mepémo kini. Mande topé ŋu iŋoro iŋondata parámi tero mande kaŋuya kama yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Asa Sadyusi uni kumi Yesuko maheŋgurí. Uni ŋundo ŋande yeyaŋgurí, ko unipare khumaŋgurí qundo pitu ko kama otoqowaŋgo. Asa mahero ŋande oseseyaŋgurí, ");
INSERT INTO nca_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Rondaqe-rondaqe uni, komo Mosesko noreŋo mande ŋande nakayáŋaró, ‘Uni kato pare rero simó moré kini yate khumoníqo, eneŋo koneyómbo pare ŋu riní simó pisiyoníqota payómboro sowe qu tunoqiní.’ ");
INSERT INTO nca_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Asa iŋo. Naru kano uni kato naŋo-simó kande saŋiyoro irisa pisi yereró. Simó korete ŋundo pare rero, yate-yate simóyari moré kini tero khumaró. ");
INSERT INTO nca_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Simó irisayó quya ");
INSERT INTO nca_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","simó kapusayó qundo pare ŋu rero yate-yate simóyari moré kini tero khumariyó. Ŋundiro naŋge simó kande saŋiyoro irisa soso ŋundo pare ŋu rero simóye moré kini tero khumaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ŋu soso khumiqo, pare ŋuya khumaró. ");
INSERT INTO nca_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Asa yeka iŋowato, unipare khumaŋgurí qundo pitu ko otoqowaŋgo quro naruyómo ŋuno, pare ŋu, danimboro yoweya? Dokoro uni kande saŋiyoro irisa qundo pare kanata ŋu raŋgurí.” ");
INSERT INTO nca_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ŋunde yiqo, Yesuko ŋande yimiraró, “Unipareto itaka ŋa naruko yoteŋgo qundo epe re-re teyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Quko naru imemoŋgo tunoqeweya quno ŋuno unipare muríye meté qu, ŋundo naŋge uni tapu koŋgo otoqowaŋgo. Ko unipare ŋundo epe re-re kama tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Dokoro enendo pitu ko khumowero mepémo kini. Hamó, sambo simó ŋunde qembe yowaŋgo. Enendo Anutu koro simó tewaŋgo, dokoro uni tapu koŋgo pitu ko otoqowaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Quko unipare khumaŋgurí qundo pitu ko otoqowaŋgo quro yeweka iŋoyi. Komo suki Moses enepa naŋge te kunzi qayara quno ŋuno kaŋero Uni Parámi koro ŋande yaró, ‘Abraham koro Anutuyó, ko Aisak koro Anutuyó, ko Yakop koro Anutuyó,’ yaró. ");
INSERT INTO nca_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Anutuko uni kindo khumaŋgurí ŋuro Anutuye kini. Uni yoto-yotoye moré ŋuro naŋge Anutuye yote. Dokoro uni kumi khumowaŋgope ma yowaŋgo, Anutu toŋímo yoto-yotoye moré teyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Asa hutuŋo mande ŋuro iŋo-iŋo uni kumimbo iŋoro ŋande yaŋgurí, “Rondaqe-rondaqe uni, keto mande topé meté yete,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Hamó uni kato osese kaŋuya tewero ŋuro rukusuwaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Asa Yesuko ŋande osese yereró, “Do murí karo iŋo-iŋo uni kumimbo, Kristo ŋuko Dewit koro naŋuní, ŋunde yeyoteŋgo? ");
INSERT INTO nca_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Qeni, Dewit enepa naŋge Hariri Yambo koro sokomeko ŋande yete, “‘Uni Parámi ŋundo uni parámine ŋu ŋande miraró, “Kandene kondésina kunditeka ");
INSERT INTO nca_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","nondo saŋgiríŋge soso rewe keŋo kusuŋokemo yowaŋgo.”’ ");
INSERT INTO nca_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dewitko uni ŋuro, ‘Uni parámine,’ yaró. Asa date tero uni ŋuko Dewit koro naŋuní?” ");
INSERT INTO nca_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ŋunde yiní unipare soso iŋoyuriqo, iŋo-iŋo rewero uniyó ŋande yimiraró, ");
INSERT INTO nca_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Hutuŋo mande ŋuro iŋo-iŋo uni ŋuro kawaware ti qembe. Enendo kowe punu-punu piru saŋga meté mu punuworo yendéwore unipare toŋeyemo uyareyoteŋgo, ko yendémo ŋuno enendo unipareto eneya naru meté yewaŋgo ŋuro hamó iŋoyoteŋgo, ko huru-huru yano yakutí meté horé muno ŋuno naŋge kunditeyoteŋgo, ko o ne-neko ŋuno yakutí meté horémo eteyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Uni ŋundo wapu koro ya qu momo teyoteŋgo, ko hariri piru saŋga teyoteŋgo. Uni ŋunde qundo topé piyimi horé rewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Asa Yesu toŋeteyoníqo, onoŋo unipareto Anutu te inowero quro mone se mahero sosoko toŋomboroŋowímo ŋuno raŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ŋunde tiqo, wapu onoŋoyó moré kini kato wondo musiyó tomó ta horé irisa qu re mahero ŋuno raŋoní qeneró. ");
INSERT INTO nca_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Qenero yaró, “No hamó horé yimiroteno, oka wapu onoŋoyó moré kini ŋundo te inote ŋundo meyowombo te inoyoteŋgo ŋu takate. ");
INSERT INTO nca_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Dokoro meyowo ŋundo oye parámi moŋgo mone raŋoteŋgo. Quko wapu ŋuko oyó parámi kini qundo oyó soso ŋuno raŋote.” ");
INSERT INTO nca_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Asa uni kumimbo Ya Surumí ŋu qenero ŋande yaŋgurí, “Unindo wondo meté-meté mundo ya ŋu towaŋgurí, ko o meté-meté mu ŋuno Anutu se inoyoteŋgo,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ko Yesuko yaró, “Ŋu soso qeneyoteŋgo ŋu, imemoŋgo naru ka tunoqiníqo, wondo itaka epe saŋa-saŋa rero towaŋgurí mu soso raŋi umukoweya. Kini, saŋgirí uni kumimbo soso se raŋoyi uweya.” ");
INSERT INTO nca_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ŋunde yiní oseseyaŋgurí, “Rondaqe-rondaqe uni, do naruko tunoqeweya? Ko tunoqewero tete ŋuro do rokó ka teweya?” ");
INSERT INTO nca_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yi ŋande yaró, “Ye kondé toŋeteyuri. Kota uni kato mahero ye kaná yereweya koro. Dokoro, imemoŋgo uni qambu mahero no owéne nekoro ŋande yewaŋgo, ‘Uni maheweya ŋuko no naŋge!’ yewaŋgo. Ŋuya ŋande yewaŋgo, ‘Naru ŋu tukuni tete ŋa!’ yewaŋgo. Quko ye uyare ma yohowewero. ");
INSERT INTO nca_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Yeko kuma parámi enesó-enesó ŋuro piŋa mande iŋowaŋgo, quko sasaro ma tewero. O soso ŋuko hamó maheweya, takawero mepémo kini. Quko naru maheweya ŋuko naru weŋa qu kini.” ");
INSERT INTO nca_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ŋunde yero ŋande yimiraró, “Uni wini kato asa uni wini enesó-enesó kaya kuma ri otoqoweya. Asa wiri yerete unindoro kuma uni qundo otoqoro wiri yerete uni enesó-enesómboro kuma uni quya kuma tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kunduru pará-parámi nokono ŋano tunoqeweya. Ko mira kumiworeko korare koya khumo yuwo koya tunoqeweya. Ko sambo saŋanoko rokó pará-pará kate-kate qenero ye yukuwo sasaro parámi tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“O soso ŋu kama tunoqeyoní unindo ye kondé yondowo pisi yerero o piyimi te yunowaŋgo. Ko ye yorero huru-huru yano mande khono yorotowaŋgo ŋuya yorero kusi-kusi yano yorotowaŋgo. Yeko owéne towoyoteŋgo, ŋu murí ŋuro uni ŋundo yorero uyare wiri yerete uni parámi toŋeyemo ko uni kembé-kembé toŋeyemo ŋuya yoroti kaŋewaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ŋundoko yeŋo khe ŋunde qembe tiní ye mande yimirowaŋgo ŋu. ");
INSERT INTO nca_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ŋunde ŋuro ye do mande topé ka tewero ŋuro ma iŋondataqewero. ");
INSERT INTO nca_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Dokoro neneŋomboko mande rero maŋgoyemo rewano, ko iŋondutu meté ŋu yunowano. Unindo ye yore mande kho yunowaŋgo quko yeŋo mandeye ri umbuweya ŋuro mepémo kini tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Asa yeŋo awa-náye, kone-topoye, sitú topoye ko maraweye, soso yorero saŋgirí uni kandeyemo yorotoyi yuroyi ye kumi khumowaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Uni wini soso ŋundo yeŋo kondé piyimiŋo yunowaŋgo, dokoro yendo neneŋo owéne nekoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Quko ye rambaruru hamó kama tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ye kondé kaŋewaŋgo ŋundo yoto-yoto suki-suki rero yorowaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Asa kuma uni mahero Yerusalem wuririyoyi qenewaŋgo quno ŋuno ye ŋande iŋowaŋgo, ko yendé ŋu itaka piyo tewero tete, ye iŋowaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ŋu naruko ŋuno ye soso Judia mirako yoteŋgo qundo sore mira purímo oyi qembe. Ko ye Yerusalem ŋuno yoteŋgo qundo yendé ŋu roto toŋi qembe. Ko ye sikuno yoteŋgo qundo yendé parámi ŋu quroko ma owero. ");
INSERT INTO nca_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Dokoro ŋu naruko ŋuno Anutuko mande soso sokomeko nakayáŋaŋgurí ŋu riní hamó tiní kimoye piyimi yunoweya. ");
INSERT INTO nca_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ŋu naruko ŋuno ye pare qahu teteŋgo, ko ye simó susu yunoyoteŋgo qu, ininiyaqe, quhurí piyimi korowowaŋgo. Dokoro quhurí parámi nokono tunoqiní, Anutu koro newonde saŋgiríŋo ŋu unipare ŋu saŋayemo ŋuno umbuweya. ");
INSERT INTO nca_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Uni saŋgirímbo mahero sukepo kumi yuroyi khumowaŋgo. Ko ene kumi yorero kusi yerero uyarewaŋgo. Uni wini meyowomboro kheye ŋundoko Yerusalem khete rumuniŋowaŋgo, yate-yate Anutuko uni wini meyowomboro naruye riní hamó temukoweya. ");
INSERT INTO nca_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ŋu naruko ŋunoko rokó kate-kate kosako, komboko, tutuko tunoqeweya. Ko nokono ŋano windi kosaŋero niri parámi horé tiní unipare iŋondata parámi horé tero sasaro parámi horé tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Unipare parámi o soso nokono tunoqeweya ŋu qenero iŋondata tero sasaro tero toŋeye wawiŋoweya. Dokoro o soso wimbí moré mu samboko yote qu yukuwowaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ŋu naruko ŋuno Unindoro Naŋuní koporé kewerowore wimbí moré tero sine parámi horémo mahiní unipare soso qenewaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Asa o ŋu hurí rero tunoqeweya quno ŋuno ye kaŋero kembaye hokoyi qembe, dokoro Anutuko ye kimo yerewero ŋuro naruyó ŋu kutaqemo mahete ŋu.” ");
INSERT INTO nca_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Asa Yesuko tapara mande ka yimiraró, “Yeŋombo naŋge kewá fik ŋuya te soso qenero iŋondutu rero qeni qembe. ");
INSERT INTO nca_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Naru kano kambinímbo sono woso remukoní komiri keta qu woti qeneroqo, yeŋombo, kosa naru meté tewe tete, ye iŋowaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ŋundiro naŋge o soso yeteno ŋako tunoqiníqo, ŋande iŋowaŋgo, ko Anutuko unipareyó wiri yereyote naruyó tunoqewe tete. ");
INSERT INTO nca_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nondo hamó horé ye yimiroteno, unipare itaka yoroteŋgo quko toŋeye watí yoníqo, o soso ŋa tunoqeweya. ");
INSERT INTO nca_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Sambo koya noko koya kini tewari, quko mande yeteno ŋako kama kini teweya. ");
INSERT INTO nca_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ye kondé iŋoyi qembe. Naru rokóŋo wimbo-wimbo sono kondé nero kape tewaŋgo koro. Ko o kowe saŋaní quro iŋaŋawí tewaŋgo koro. Otete ŋunde qundo ye yoriní newondeye umbuní naru parámi ŋundo mondó mahero nokoparako qembe yondowoweya. ");
INSERT INTO nca_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Hamó, ŋu naru ŋuko unipare mirane-mirane soso yoteŋgo quno ŋuno tunoqeweya. ");
INSERT INTO nca_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ye naru rokóŋo kondé toŋeteya o piyimi tunoqeweya ŋu takaro Unindoro Naŋuní toŋímo kaŋewero quro Anutuko hariri teyuri qembe.” ");
INSERT INTO nca_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Asa naru rokóŋoro Yesuko unipare Ya Surumí ŋuro hoŋgo quroko ŋuno iŋo-iŋo rondaqe yunoyaró. Ko suwonoko ene toŋero mira purí Oliv oro ya kano ŋuno eteyaró. ");
INSERT INTO nca_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ko unipare ita saraŋoní suwo-suwo otoqoro Ya Surumímo ŋuno uyaro mandí iŋoyaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Asa Bret Yisiyó Moré Kini naru parámi keweroko ŋuno o ne-ne ka, owé Taka yereró, ŋu tunoqewero taró. ");
INSERT INTO nca_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ko o qa-qa unindoro tapá unindoya hutuŋo mande ŋuro iŋo-iŋo unindoya uniparetoro sorero Yesu urowero ore sóqewí qu seqaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ŋunde ti Monimbuko Jutas, owé kako Isikariot, ŋu newondí quroko uró. Ŋuko iŋo-iŋo rewero uni 12 qu ka. ");
INSERT INTO nca_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Asa ŋuro quroko uní uyaro o qa-qa unindoro tapá unindoya Ya Surumímboro ŋuro sopo-sopo unindoya eneno, Yesu eneŋo kandeyemo re rotowero ore seqaweya, yero yimiraró. ");
INSERT INTO nca_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yimironí niŋgu-niŋgu tero, mone ka se kunowato, yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ŋunde yiqo, meté, yero eneŋo kandeyemo re rotowero quro naru meté seqaró. Unipare qambu qenero iŋowaŋgo koro. ");
INSERT INTO nca_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Asa Bret Yisiyó Moré Kini naru keweroko ŋuno o ne-ne ŋu tunoqaró. Ŋu naruko ŋuno sipsip simó ka utoro qaro neyaŋgo. Sipsip simó ŋuko, “Taka yereró koro sipsip simó,” ye nekaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Asa Yesuko Pita, Jon ŋande yimiraró, “Yarindo uyareya Taka yereró quro o ne-ne koro o qonanimboro roŋgaruwori.” ");
INSERT INTO nca_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Yiní oseseyariyó, “Keto, norendo re uyare dano roŋgaruwaro, ye iŋote?” ");
INSERT INTO nca_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yiri yimiraró, “Iŋori. Yendé parámimo ŋuno uyaririqo, uni kato sono kumbe ka re kheko ŋuno mahe wisumu yereweya ŋu. Yari ŋu howero ya ŋuro quroko ori qembe. ");
INSERT INTO nca_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Oro ya simburí ŋande mirori qembe, ‘Rondaqe-rondaqe uni ŋundo ŋande osese kerete: No iŋo-iŋo rewero uninemboya Taka yereró quro o ne-ne ŋu newato. O newero ŋuro yakutí ŋu dana yote?’ ");
INSERT INTO nca_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ŋunde yiriqo, ya simburímbo yakutí parámi roŋgaruwaró mu witú yereweya. Asa yakutí ŋuno o newero ŋu roŋgaruwori qembe.” ");
INSERT INTO nca_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ŋunde yimironí uni irisa ŋu oro o soso Yesuko yaró ŋuko ŋunde naŋge tunoqaró. Asa ko Taka yereró quro o ne-ne ŋu roŋgaruwariyó. ");
INSERT INTO nca_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Asa o newero naru hamó ŋu tunoqiníqo, Yesu koya asá yerewí uniyómboya yakutí ŋuno o newero quro etaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Etero ŋande yimiraró, “No kowe surumí korowowe teteno. Quko koretero no yeya Taka yereró quro o ne-ne ŋa newato ŋuro kondé iŋanowó. ");
INSERT INTO nca_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Dokoro no ye yimiroteno, no kaŋuya kama newano, yate-yate Anutuko unipareyó wiri yereyote naruyómo ŋuno o ne-ne ŋaro muríyó hamó tunoqeweya quno, ŋuno naŋge kaŋuya newano.” ");
INSERT INTO nca_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ko topa ka rero, Anutu yuŋgunaŋoro ŋande yimiraró, “Ye soso enemo-enemo wain ŋa ni. ");
INSERT INTO nca_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Dokoro no ye yimiroteno, wain kaŋuya kama newano, yate Anutuko unipareyó wiri yereyote naruyó ŋu tunoqeweya quno, ŋuno naŋge kaŋuya newano.” ");
INSERT INTO nca_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ko bret ka rero, Anutu yuŋgunaŋoro romboŋero yunoro ŋande yaró, “Ŋako neneŋo kowene. Nondo re yeŋo rototeno. Ye ŋu neyowaŋgo quno ŋuno neneŋo iŋoyi qembe.” ");
INSERT INTO nca_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Asa o ne-ne ŋu kini tiníqo, topa ka rero ŋunde naŋge yaró, “Wain ŋako sitúnembo mande kondé keta ŋu reweya qu. Nondo yeŋo windoroŋowe teteno. ");
INSERT INTO nca_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Quko qeni, uni kato nore uni kandeyemo norotoweya, ko eneŋo kandí muko neneŋo kandenemboya yakutímo ŋano yote. ");
INSERT INTO nca_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Hamó, Unindoro Naŋuní ŋu Anutuko ore rokóŋaró ŋu howeweya. Quko uni rero kandeyemo rotoweya ŋu, iniyaqe, quhurí piyimi korowoweya.” ");
INSERT INTO nca_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ŋunde yiní iŋo-iŋo rewero uni ŋundo epe mito-mito ŋande taŋgurí, “Dando o ŋu teweya?” ");
INSERT INTO nca_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Asa iŋo-iŋo rewero unindo maŋgoto kuma tero danimboko koretero yoweya. ");
INSERT INTO nca_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Quko Yesuko ŋande yimiraró, “Uni wini meyowomboro wiri yerete uni ŋundo eneŋo owéye parámi ŋuro iŋoro unipare sopo yereyoteŋgo. Ko uni parámiyembo eneŋo owéye hokoro ŋande yeyoteŋgo, ‘Nore o meté tero unipare samaka yereyoteto.’ ");
INSERT INTO nca_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Quko ye ŋunde ma tewero. Kini, ye keweroyemo ŋuno uni parámi soso simó ta-ta ŋunde qembe ti. Ko uni ka owé parámi moré ŋundo kho uni ŋunde qembe ti. ");
INSERT INTO nca_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Qeni, uni ka etero o qímboro nete, ko uni ka sunará tero inote. Asa ye date iŋoteŋgo, danimboko meyowo takayote? Uni saŋáqero o nete ŋundo sunará simó takate, hamómbe? Quko qeni, no ye keweroyemo sunará simó ŋunde qembe yoteno. ");
INSERT INTO nca_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Yendo noya kaŋeyate quhurí korowoyatowó. ");
INSERT INTO nca_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Asa Awanembo no rokó nerero owé parámi nunaró, ko nondo ŋunde naŋge ye rokó yerero owé parámi yunoteno. ");
INSERT INTO nca_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ŋunde tero yeya noya uniparene wiri yereyoteno naruyómo ŋuno kunditero o qoyemboro newaŋgo. Ŋunde tero ye yakutí meté muno ŋuno kunditero Israel koro wini 12 ŋu ronda yerewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Asa Yesuko ŋande yaró, “Saimon, Saimon, iŋo. Monimbuko Anutu ŋande oseseyaró, meté enendo ye yorero wit koro eŋgé ŋuya wit koro kowí ŋuya ŋunde qembe ronda yereweya. ");
INSERT INTO nca_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Quko no keŋo hariri tewe ke iŋondutuke ŋu kama rotoyi umbuweya. Ko ke rohoréŋo maheweya quno ŋuno, topo-topoke ŋu samaka yere qembe.” ");
INSERT INTO nca_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Yiní ŋande yaró, “Uni Parámi, no meté keya kusi-kusi yano uyarewero ye iŋoteno. Ko no keya khumowero yero iŋoyoteno ŋa.” ");
INSERT INTO nca_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yiní ŋande yaró, “Pita, no ke kimirowe teteno, itaka suwonoko kotori kama yeyoní ke naru kapusa neneŋo wawa yeweya.” ");
INSERT INTO nca_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Asa Yesuko iŋo-iŋo rewero uniyó ŋande yimiraró, “Komo, naru ŋuno ye kho tewero asá yerewe toŋeŋgurí quno ŋuno mone koro puŋge koneyó ka ko puŋge parámi ka ko khe punu-punu ŋu soso kama se towo toŋeŋgurí. Ŋu naruko ŋuno ye okarope tukuni taŋgurímbe ma kini?” Ko ŋande yaŋgurí, “Kini.” ");
INSERT INTO nca_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Asa ŋande yimiraró, “Quko itaka ŋano uni ka mone moré, ma puŋgeyó moré tiníqo, ene meté ŋu reweya. Ko uni ka suke parámi moré kini tiníqo, ene meté kowe punu-punuyó soweyoro suke parámi ka kimo teweya. ");
INSERT INTO nca_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Dokoro sokomeko ŋuno ŋande nakayáŋaró, ‘Uni ŋundo hutuŋo mande wendaqeyote yero qeneyoteŋgo.’ Ko nondo ye yimirowe, unipareto otete ŋu nono tewaŋgo, dokoro o soso Anutu koro sokomeko teweya yaró ŋuko hamó tunoqeweya.” ");
INSERT INTO nca_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yiní ŋande yaŋgurí, “Uni Parámi, qeno. Nore suke parámi irisa ŋano yorote.” Yi ŋande yimiraró, “Ŋu koro ŋu,” yaró. ");
INSERT INTO nca_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Asa Yesuko ya rotoro eneŋo murí howero mira purí Oliv ŋuno oní iŋo-iŋo rewero uniyó ŋuya howero oŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Oro ŋusinaŋgo mahero ŋande yimiraró, “Ye kondé toŋeteya hariri ti qembe. Yate ye osese kano umbuwaŋgo koro.” ");
INSERT INTO nca_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Yero yorotoro soŋga ta mira kapiyamo toŋero potoruku tero hariri ŋande taró, ");
INSERT INTO nca_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Awa, ke iŋo nunoyaqo, topa newano ŋa reka toŋiní. Quko iŋo-iŋone ma howewero. Kini, keŋombo na te qembe.” ");
INSERT INTO nca_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ŋunde yiní sambo simó kato umburo wimbu inoro samakaŋaró. ");
INSERT INTO nca_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Quko Yesu sorero newonde quhurí horé tero hariri parámi taró. Ŋunde tero soŋo-soŋo uroní sitú qembe nokono tinda-tinda soraró. ");
INSERT INTO nca_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Asa hariri tiní kini tiní kaŋero uyare iŋo-iŋo rewero uniyó yiyoní eteyaŋgo, dokoro newonde quhurí towaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yiyoro ŋande yimiraró, “Ye date koro eteyoteŋgo? Otoqo hariri ti. Osese kano ŋuno umbuwaŋgo koro.” ");
INSERT INTO nca_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Asa Yesu mande yeyoní naŋge uni qambu maheŋgurí. Mahero Jutas, iŋo-iŋo rewero uni 12 qu kato koretero mahero Yesu taŋgímo mahero towo mutó inaró. ");
INSERT INTO nca_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Quko Yesuko ŋande oseseyaró, “Jutas, kepe Unindoro Naŋuní mutó inoro kandeyemo rototepe?” ");
INSERT INTO nca_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Iŋo-iŋo rewero uniyó Yesu koya yateqo o ŋu tunoqiní qenero yaŋgurí, “Uni Parámi, ke iŋoka nore sukepo kumi ka yurato?” ");
INSERT INTO nca_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ŋunde yero iŋo-iŋo rewero uniyó kato otoqoro o qa-qa unindoro tapá unindoro sunará simó qu ka sukepo utoro kusumbí kandí kondéwore qu takaní umburó. ");
INSERT INTO nca_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Quko Yesuko ŋande yaró, “Ŋu ma tewero! Roto!” yero kandí rero kusumbímo riní meté taró. ");
INSERT INTO nca_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","O qa-qa unindoro tapá unindoya Ya Surumímboro sopo-sopo unindoya uni kembé-kembémboya Yesu towowero maheŋgurí. Mahi ŋande yimiraró, “Yendo no wiri yerete unindoya kuma teyoteno ŋundiro suke parámi, usú siyoro nono maheteŋgo, peka? ");
INSERT INTO nca_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Naru rokóŋo Ya Surumímboro hoŋgo quroko ŋuno nondo yeya kaŋero mande rondaqe yunoyanowó. Quko ŋu naruko ŋuno kama nondowaŋgurí. Enina, itaka ŋanoko yeŋo naruye. Itaka huririko wimbí tete.” ");
INSERT INTO nca_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Asa uni ŋundo Yesu re toworo uyaro o qa-qa unindoro tapá unindo yano oŋgurí. Oyi Pita ŋuya yohowe oró, quko ene soŋga ta kapiyamo yora. ");
INSERT INTO nca_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Uni kumi ya ŋuro hoŋgo quroko kewá qaro kunditeyaŋgurí. Ko Pita ŋuya keweroyemo ŋuno ŋuya kunditeyaró. ");
INSERT INTO nca_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kunditiní sunará pare kato qenini ŋuno te roko ŋuno kunditeyoní kondé qenero ŋande yaró, “Ŋa uni ŋako Yesu koya yorari qu ka,” yaró. ");
INSERT INTO nca_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Yiní wawa yero ŋande yaró, “Pare, no ŋu kama iŋo inoteno,” yaró. ");
INSERT INTO nca_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ko yate uni kato qenero ŋande yaró, “Ke ŋuya uni ŋuro wini qu ka.” Yiní Pitako ŋande yaró, “Topo, no kini.” ");
INSERT INTO nca_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Naru soŋga piru ta ŋunde rotoro meyowo ka mande wimbí kondé ŋande yaró, “Hamó horé, uni ŋa eneya yora. Ŋuko Galili uni naŋge ŋu.” ");
INSERT INTO nca_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Quko Pitako ŋande yaró, “Topo, ke mande yete ŋuko no kama iŋoteno.” Ŋu mande yeyoní naŋge kotori yaró. ");
INSERT INTO nca_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yiní Uni Parámi rohoréŋoro Pitawore toŋetaró. Ko Pitako Uni Parámimbo, “Itaka suwono ŋano kotori kama yeyoní keto naru kapusa neneŋo wawa yeweya,” komo yaró ŋu iŋaró. ");
INSERT INTO nca_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ŋuro iŋoro mirako uro tendo piyimi taró. ");
INSERT INTO nca_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Asa unindo Yesu toworo huwó mande ye inoro uraŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Utoro tuwipo toŋí wisumuŋoro ŋande oseseyaŋgurí, “Ke itaka ye-ye mande ye. Uni ŋundo kurote ŋuko dani ka?” ");
INSERT INTO nca_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ko mande enesó-enesó piyimi horé yero yesaráŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Asa kosa toŋí raŋoní uniparetoro uni kembé-kembéye, asa o qa-qa unindoro tapá unindoya hutuŋo mande ŋuro iŋo-iŋo unindoya mahero kopaŋgurí. Yesu re Sanedrin huru-huru ŋuno uyaro ŋande yaŋgurí, ");
INSERT INTO nca_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Nimitoka iŋato. Kepe Kristo ŋumbe ma kini?” Quko enepa naŋge ŋande yimiraró, “Ŋunde yimiroweqo, yendo iŋondutu kama tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ko no mande karo osese yereweqo, mandene ŋu topé kama tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Itaka naru ŋa noŋgo yate-yate Unindoro Naŋuní ŋu Anutu wimbí moré ŋuro kandí kondésina kunditiní qenewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Yiní uni soso ŋande oseseyaŋgurí, “Keŋomboko peka Anutu koro naŋuní peka?” Yi ŋande yimiraró, “Yeŋombo yeteŋgo ŋu naŋge.” ");
INSERT INTO nca_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Yiníqo, ŋande yaŋgurí, “Do karo uni kaŋuya neko yereto quhuríŋo ŋuro yesowowaŋgo? Eneŋo mandímbo ŋunde yesowoyote ŋu.” ");
INSERT INTO nca_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Asa uni soso otoqoro Yesu re Pailatko ŋuno uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Uyaro ŋuno mande piyimi ŋande yaŋgurí, “Uni ŋa noreŋo wininanimboro iŋo-iŋoye roworemoyote. Ŋundo uni ka Sisa takis inowero soré yereyote. Ko, ‘Kristo ŋuko no, wiri yerete uni ka,’ yeyote.” ");
INSERT INTO nca_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ŋunde yi Pailatko oseseyaró, “Kepe Juda uniparetoro wiri yerete uni ŋumbe, ma kini?” Yiní mande topé ŋande yaró, “Keŋombo ŋunde naŋge yete.” ");
INSERT INTO nca_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Asa Pailatko o qa-qa unindoro tapá uni ŋuya unipare qambu ŋande yimiraró, “No uni ŋaro potó ka kama qeneteno,” yaró. ");
INSERT INTO nca_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Quko mande kondé ŋande yaŋgurí, “Ŋundo mande rondaqe unipare soso Judia mirako yoteŋgo qu yunoní newondeye otoqoyote ŋu. Galili noŋgo hurí tero, yate-yate ŋano mahete.” ");
INSERT INTO nca_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Asa Pailat mande ŋu iŋoro osese yereró, “Ŋuko Galili noŋgo qu, hamómbe?” ");
INSERT INTO nca_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Herotko Yesu ŋuro mirayó soparó. Asa ko Pailatko asáŋoní Herotko ŋuno uyaró. Ŋu naruko ŋuno Herot Yerusalem ŋuno yora. ");
INSERT INTO nca_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Asa Herotko Yesu qenero niŋgu-niŋgu parámi taró. Dokoro ene ŋuro piŋa mande iŋoro, naru parámi qenewero ye iŋaró. O wimbí moré ka towoníka qenewe, ye iŋaró. ");
INSERT INTO nca_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Asa mande parámi yero oseseyaró, quko Yesuko mande topé ka kama taró. ");
INSERT INTO nca_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","O qa-qa unindoro tapá unindoya hutuŋo mande ŋuro iŋo-iŋo unindoya mahe kutaqe kaŋero mande piyimi kondé ye inaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Asa Herot koya kuma uniyómboya huwó mande ye inoro kundo tero tuwi meté horé piru ka re mahero kusiyo inoro, pitu ko asáŋoní Pailatko ŋuno uyaró. ");
INSERT INTO nca_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Komoko Herot koya Pailat koya saŋgirí teyariyó. Quko ŋu naruko ŋunoko topo tariyó. ");
INSERT INTO nca_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Asa Pailatko o qa-qa unindoro tapá unindoya uniparetoro uni pará-parámboya unipare qambu ŋu neko yiriní mahiqo, ");
INSERT INTO nca_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ŋande yimiraró, “Yendo uni ŋu re mahero ŋande yeteŋgo, ko ene unipare soso yowosoní Sisa koro mandí wendaqeyoteŋgo. Iŋoyi, nondo toŋeyemo oseseyoteno, potóŋo moré kini qeneteno. ");
INSERT INTO nca_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot ŋuya ŋundiro naŋge, dokoro riní pitu ko noreno mahete ŋa. Iŋoyi, uni ŋu oka kama ta qu re urato khumoweya. ");
INSERT INTO nca_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ŋunde ŋuroko nondo kina haususuworo rotowe toŋeweya.” ");
INSERT INTO nca_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(-) ");
INSERT INTO nca_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ŋunde yiní unipare soso neko kiwero ŋande yaŋgurí, “Uni ŋu rika Barapas rotoyika noreno mahiní,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Komo Barapas ŋuko yendé parámimo ŋuno Sisa koro mandí wendaqero kuma riní otoqaró. Uni yuroní khumoyi rero kusi-kusi yano rotaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Asa Pailatko Yesu rotowero ye iŋoro pitu ko ŋande yimiraró, “Rotoweka toŋiní,” yaró. ");
INSERT INTO nca_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Quko ki parámi tero yeyaŋgurí, “Re tipiririko uroyi! Re tipiririko uroyi!” ");
INSERT INTO nca_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Yeyuri, naru kapusayómo ŋande yimiraró, “Do karo? Do o piyimi ka ta quro? No o piyimi ka kama ta qu qenero ŋuro date urato khumoweya. Ŋunde ŋuroko nondo kina haususuworo rotowe toŋeweya.” ");
INSERT INTO nca_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ŋunde yaró, quko enendo wimbí tero, ki parámi tero, tipiririko uroyika khumoní, yaŋgurí. Neko kiweyaŋgo ŋundo Pailat koro mande qu ri umburó. ");
INSERT INTO nca_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ŋunde ŋuroko Pailatko mandeye ŋu howaró. ");
INSERT INTO nca_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Uni ŋundo, kuma tero uni yuroní khumaŋgurí mu kusi-kusi yano yora, komo unipareto ŋu rewero kiwaŋgurí, ŋu Pailatko rotoní toŋeró. Ko Yesu rero uniparetoro iŋo-iŋoye howero kuma uni kandeyemo rotaró. ");
INSERT INTO nca_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Asa kuma unindo Yesu re uyaroqo, uni ka ŋuya towaŋgurí. Uni ŋu Sairin yendé moŋgo, owí muko Saimon. Enendo siku noŋgo mahero yendémo owero taró. Asa uni ŋu toworo tipiriri re inoyi koroworo tukú Yesu howaró. ");
INSERT INTO nca_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Unipare parámi howero pare qambu tendo mukuru taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ŋunde tiqo, Yesu rohoréŋoro yimiraró, “Ye Yerusalem pare, ye neneŋo ma tendowero. Yeŋomboro ko simóyemboro tendi. ");
INSERT INTO nca_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Iŋoyi, imemo naru piyimi ka tunoqeweya. Ŋu naruko ŋuno ye ŋande yewaŋgo, ‘Pare kusimi ŋu, pare simó kama pisiyaŋgo qu, pare simó susu kama yunoyaŋgo qu, ye meté horé yoteŋgo.’ ");
INSERT INTO nca_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ŋu naruko ŋuno “‘unindo mira purí ŋande kirayowaŋgo, “Ye nore saŋano umbu raŋoyi!” ko mira purí tomó ta-ta ŋuya kirayowaŋgo, “Ye nore weyo yiri!”’ ");
INSERT INTO nca_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","“Dokoro itaka, te ŋuko sitúŋo moré tete qunoko ŋandiro teteŋgo. Imemoŋgo, te ŋuko sitúŋo moré kini, hari teweya qunoko date tewaŋgo?” ");
INSERT INTO nca_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Asa uni irisa komo o piyimi teyari ŋuya yorero, Yesu koya yuratoka khumori, yero maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Mahero mira ka owí muko Kembémboro Wimbí ŋuno mahero Yesu re tipiririko porowaŋgurí. Utoro uni piyimi irisa ŋuya tipiriri irisa ŋuno poro yereŋgurí, ka kandí kondésina, ka kandí tesina porowaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ko Yesuko ŋande yaró, “Awa, quhuríye se roto. Dokoro oka teteŋgo ŋaro murí kama iŋoyi tondaŋete.” Kuma unindo kowe punu-punuyó ŋu rondaŋe siyowero quro kundo ka taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Unipare kaŋero toŋetiqo, uni pará-parámbo huwó mande Yesu koya ŋande yeyaŋgo, “Ŋundo uni kumi rambaruru koŋgo yoraró. Asa ene hamó Anutu koro Kristo ŋu, uni Anutuko rokóŋaró ŋu tiníkaqo, asa rambaruru ŋa takaní.” ");
INSERT INTO nca_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Kuma unindo ŋuya Yesu koro huwó mande ye inaŋgurí. Ene kutaqemo ŋuno mahero, wain oŋgomi re inoro ");
INSERT INTO nca_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ŋande yaŋgurí, “Asa ke Juda koro wiri yerete uni tiníkaqo, asa keŋo rambaruru ŋa taka.” ");
INSERT INTO nca_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ko mande ka nakayáŋoro tipiriri suwómo raŋgurí. Mande ŋuko ŋandiro, “Uni ŋako Juda Uniparetoro Wiri yerete Uni ŋu.” ");
INSERT INTO nca_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Asa uni irisa se poro yereŋgurí qu kato Yesu ŋande yesaráŋaró, “Kepe hamó Kristo ŋumbe? Asa keŋombo keŋo koweke samakaŋoyaqo, nore ŋuya samaka nere.” ");
INSERT INTO nca_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Quko meyowo ŋundo qene yero ŋande miraró, “Ke ŋuya topé piyimi ŋunde qu rete. Asa dokoro Anutu koro kama sorete? ");
INSERT INTO nca_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Noreko quhurí uni koro kimoyó meté retero. Quko uni ŋako quhurí ka kama taró.” ");
INSERT INTO nca_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Yero ŋande yaró, “Yesu, ke unipareke wiri yereyote narukemo oweya qunoko, ke neneŋo iŋo qembe.” ");
INSERT INTO nca_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yiní Yesuko ŋande miraró, “No hamó ke kimiroteno, itakako ke noya paradais ŋuno yowaro.” ");
INSERT INTO nca_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Asa kosa keweroko mira soso huriri teyate suwoya 3 kilok ŋunde taró. ");
INSERT INTO nca_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ko tuwi parámi Ya Surumí quroko qu porowoyaró, ŋu kosaŋero tuwi irisa tunoqaró. ");
INSERT INTO nca_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ko Yesu kondé kiwero ŋande yaró, “Awa, no yuqane kandekemo reteno.” Ŋunde yeroqo yuqayó rotoro khumaró. ");
INSERT INTO nca_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Asa kuma unindoro sopo-sopo uni ŋundo ŋu qenero Anutu owí hokoro ŋande yaró, “Hamó horé, uni ŋuko roneneŋowí mu naŋge,” yaró. ");
INSERT INTO nca_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ko unipare qambu qenewero maheŋgurí ŋundo o ŋu qenero newondeye surumí tiní nomoye utoro roto toŋeŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Quko Yesu koro topé-topé ŋuya pare Galili noŋgo ŋu howe maheŋgurí ŋuyako kapiyamo kaŋero o ŋu soso qenemukaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Uni pará-parámboro huru-huru koro uni ka owí Josep ŋu yora. Ŋuko uni meté, uni roneneŋowí qu ka. ");
INSERT INTO nca_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Enendo Juda uni kembé-kembémboro iŋo-iŋoye ŋuro kama metéŋaró. Eneko Arimatea noŋgo qu, asa Juda koro yendé qu ka, ko Anutuko unipareyó wiri yereyote naruyó ŋuro sopoyaró. ");
INSERT INTO nca_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Asa uni ŋu uyaro Yesu ukúŋo rewero Pailat kirayoní Pailatko meté yaró. ");
INSERT INTO nca_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ŋunde yiní Yesu ukúŋo re umburo tuwi kekere sara-sara qundo pokamoro re uni tapu kano ŋuno raró. Komo uni tapu ŋu wondo wekokoro towaró, ko uni ka re ŋuno kama tapuŋoyaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Naru ŋuko Roŋgaruwowero Naru, ko naru tapuŋaró quno ŋuno Sapat naru ŋu tunoqewero taró ŋu. ");
INSERT INTO nca_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Asa pare komo Galili rotoro Yesu koya maheŋgurí ŋundo Josep howero uyaro uni tapu ŋu qeneŋgurí. Ko ukúŋo re dano rotaró ŋu ŋuya qeneŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Qenero yayemo toŋero kiruwó meté-meté nuŋgurí mu se roŋgaruwaŋgurí. Roŋgaruworo, yate Sapat naruko koro mande kondé ŋu howero imaqaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Asa sonda naru korete quno ŋuno ita saraŋoní suwo-suwo, pare ŋundo o enesó-enesó nuŋgurí meté mu roŋgaruwaŋgurí ŋu se uni tapuko maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Se mahiqo, wondo parámi ŋu uni tapu ŋuro makoyó wisumuŋaŋgurí, ŋuko tapémo yaró. ");
INSERT INTO nca_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ŋu qenero wondo ya quroyómo oro Yesu Uni Parámimboro ukúŋo kama qeneŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ŋuro iŋondata teyuriqo, uni irisa tuwiyari sine parámi tiní taŋgeyemo ŋuno kaŋariyó. ");
INSERT INTO nca_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Asa pare ŋu sorero nokono umbu eti ŋande yimirariyó, “Ye dokoro uni yoto-yotoyó moré mu uni khumaŋgurí ŋuro yendémo ŋano mahe seqateŋgo? ");
INSERT INTO nca_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ŋano kama yote; otoqa! Komo ene yeya Galili yaró quno ŋuno mande ka yimiraró. Ŋu iŋi. ");
INSERT INTO nca_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ŋande yimiraró, ‘Ŋambe hamó tunoqeweya, ko uni kato Unindoro Naŋuní ŋu rero quhurí uni kandeyemo riqota tipiririko urowaŋgo. Ko naru kapusa quno pitu ko otoqoweya.’” ");
INSERT INTO nca_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ŋunde yiriqo, mande komo iŋaŋgurí ŋu pitu ko iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Asa uni tapu yendé ŋu rotoro pitu ko yano mahero iŋo-iŋo rewero uni 11 ŋuya unipare soso ŋuya o tunoqaró ŋuro yimiraŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Pare ŋuko Maria Maktala yendé moŋgo qu, Joana, Maria ŋuko Jems koro nimí, pare kumi ŋuyako mande ŋu asá yerewí uni ŋu yimiraŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Yimiroyiqo, mande kape-kape naŋge, ye iŋoro kama iŋondutuwoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Quko Pitako otoqoro kheŋgeŋoro uni tapuko uyaro kondéqero tuwi ukúŋo pokamaró ŋu kina yoní qeneró. Qenero roto toŋero o soso ŋuro iŋondata parámi teyaró. ");
INSERT INTO nca_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Asa kosa naru ŋuno naŋge, iŋo-iŋo rewero uni irisa khendo yendé tomó ta ka, owé Emeus, ŋuno uyaririyó. Ore ŋuko Yerusalem rotoro Emeus ŋuno uyarewero, ore ŋuro piruyó muko kilomita 11 ŋundiro. ");
INSERT INTO nca_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Asa khendo uyareyate o soso tunoqaró ŋuro epe mito-mito tariyó. ");
INSERT INTO nca_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ŋunde tiri Yesu enepa naŋge kutaqe ŋuno mahero uni irisa ŋuya kopo uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Quko toŋeyari wisumuŋoní kama iŋo inariyó. ");
INSERT INTO nca_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Asa enendo ŋande osese yereró, “Yari do karo epe mito-mito tero uyareyotiri?” Ŋunde yiní ŋuno kaŋero newonde surumí tero umu-kembayari piyo taró. ");
INSERT INTO nca_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kako, owí Kiliopasi, ŋundo mande topé yaró, “Kepe itaka Yerusalem mahero o soso tunoqa ŋumbe kama iŋote?” ");
INSERT INTO nca_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yiní ŋande osese yereró, “Ŋu do ka?” Yiní mande topé yariyó, “O soso Yesu Nasaret yendé moŋgo uni ŋuro tunoqaró ŋu. Eneko ye-ye uni ka, Anutu toŋímo ko unipare toŋeyemo kho wimbí, mande kondé teyara. ");
INSERT INTO nca_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","O qa-qa unindoro tapá unindoya noreŋo uni pará-parámboya re Rom uni kandeyemo ri topé piyimi inoro tipiririko uroyi khumaró. ");
INSERT INTO nca_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Komo ŋande yero iŋatowó, ŋuko uni maheweya ŋundo Israel unipare kimo yereweya, ye iŋatowó. Ko o soso ŋu yaŋe naŋge tunoqaró. ");
INSERT INTO nca_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ŋuya noreŋo pare kumimbo yi newondenani uraró. Ita saraŋoní suwo-suwo eneŋo uni tapuyómo ŋuno uyaro ");
INSERT INTO nca_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ukúŋo ŋuno kama qeneŋgo. Pitu noreno mahero ŋande yaŋgo, ‘Nore kapoko sambo simó yiyato ŋande yetiri, “Enendo yoto-yoto yote.”’ ");
INSERT INTO nca_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ŋunde nimiroyi uni kumi keweronani moŋgo uni tapuko uyaro pareto yaŋgo ŋunde naŋge qeneŋgo. Quko eneŋo muko kama qeneŋgo.” ");
INSERT INTO nca_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ŋunde yiri ŋande yimiraró, “Yari iŋo-iŋoyari moré kini tero newondeye kusiyote. Anutu koro ye-ye unindo mande yaŋgurí ŋu kama iŋondutuwoyotiri, peka. ");
INSERT INTO nca_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Date koro? Kristo ŋuko koretero quhurí korowoníqota, imemoŋgo Anutuko owé parámi inoweya. Ŋumbe iŋariyómbe ma kini?” ");
INSERT INTO nca_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ŋunde yero enendo sokome Mosesko nakayáŋaró quya sokome Ye-ye Unindo nakayáŋaŋgurí quya eneŋomboro mande murí sokomeko yote ŋu soso ŋuro yesowaró. ");
INSERT INTO nca_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Asa yate yendémo uyarewero uyaririyó muno ŋuno tapémo yotoro enendo yorotowero taró. ");
INSERT INTO nca_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Quko irisa ŋundo kusiyoro ŋande yariyó, “Suwo tewero kosa pusuŋete. Ŋunde ŋuro noreya yoto.” Ŋunde yiri uni irisa ŋuya yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Asa o qoyemboro newero kunditero enendo bret siyoro puriŋo yero romboŋero yunaró. ");
INSERT INTO nca_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ŋunde tiní, toŋeyari hiyóqiní, Yesu iŋo inariyó. Ŋunde tiní waka ta toŋiní qenewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tiní epe mito-mito tariyó, “Hamó, nore khewore maheyaro sokome koro mande rondaqe nimironíqo, newondenari ura!” ");
INSERT INTO nca_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ŋunde yero waka ta otoqoro Yerusalem uyaro iŋo-iŋo rewero uni 11 ŋuya topoyemboya kopaŋgurí quno ŋuno uyaririyó. ");
INSERT INTO nca_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Unipare ŋundo ŋande yimiraŋgurí, “Hamó horé, Uni Parámi ŋuko pitu otoqoro Saimonko tunoqa!” ");
INSERT INTO nca_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ko enepa naŋge o kheko tunoqa ŋuro yimirariyó. Ko ŋande yariyó, “Bret ŋu romboŋe nunoníqota nore qene iŋaro,” yariyó. ");
INSERT INTO nca_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Asa irisa ŋuya yeyuriqo, Yesu keweroyemo ŋuno kaŋero ŋande yaró, “Newonde ime yuri.” ");
INSERT INTO nca_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Yiní qenero yukuworo, kapo ka, ye iŋoro sasaro parámi taŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ko ŋande yimiraró, “Do karo yukuwoteŋgo? Do karo newondeye wimbo-wimbo yote? ");
INSERT INTO nca_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Khe kandene qenoyi. Kapoko suŋgí, wimbí moré kini.” ");
INSERT INTO nca_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ŋunde yero khí kandí se witú yereró. ");
INSERT INTO nca_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Witú yiriní qenero niŋgu-niŋgu tero iŋondata parámi taŋgurí, quko iŋondutu hamó kama taŋgurí. Ŋunde ŋuroko ŋande yimiraró, “O newero qu kape ŋana?” yaró. ");
INSERT INTO nca_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Yiní sono qare ka sombé qaŋgurí mu inaŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ŋu re toŋeyemo naró. ");
INSERT INTO nca_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Asa ŋande yimiraró, “No yeya yoranowó quno ŋuno ŋande yimiranowó: mande kumi Moses koro Hutuŋo Mande ŋuya Ye-ye Unindoro mandeye ŋuya Hariri Yambo ŋuya ŋuno neneŋo nakayáŋaŋgurí, ko mande soso ŋu mepémo tunoqeweya.” ");
INSERT INTO nca_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ŋunde yeroqo samaka yiriní mande murí mande sokomeko ŋuno nakayáŋaŋgurí ŋu iŋoyi tondaŋaró. ");
INSERT INTO nca_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ko ŋande yimiraró, “Komo suki sokomeko ŋuno ŋande nakayáŋaŋgurí, ko Kristo ŋundo kowe surumí koroworo naru kapusayómo ŋuno uni tapu koŋgo otoqoweya. ");
INSERT INTO nca_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Otoqoníqo, kumimbo eneŋo owímo uni wini soso keweroyemo ŋande yesowowaŋgo, ko uni kato oteteye piyimi ŋuro newonde surumí tero newonde rohoréŋo tiníqo, Anutuko quhuríye se rotoweya. Asa yendo Yerusalem ŋano kho kimani tero ");
INSERT INTO nca_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","o soso ŋaro yesowowaŋgo. ");
INSERT INTO nca_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Iŋoyi. Komo Awando mande kusiyoro o meté ka re yunowero yaró. No o meté ŋu rewe yeno maheweya ŋu. Quko yendé parámimo ŋano yurika wimbu kore koŋgo saŋayemo umbuweya.” ");
INSERT INTO nca_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Asa Yesuko yorero Betani yendé sumeyoro ŋuno uyaró. Uyaro kandí hokoro puriŋo re yunaró. ");
INSERT INTO nca_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ŋunde re yunoyoní Anutuko riní samboko oró. ");
INSERT INTO nca_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Uni ŋu potoruku te inoyi kini tiní niŋgu-niŋgu tero pitu ko Yerusalem uŋgurí. ");
INSERT INTO nca_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ko naru rokóŋo Ya Surumímo ŋuno yotoro Anutu owí hokoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Komo suki-suki, o soso kama tunoqeyoní, Mande kako yora. Mande ŋu Anutu koya yora, ŋuko Anutu naŋge. ");
INSERT INTO nca_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Komo suki-suki Mande ŋu Anutu koya yora. ");
INSERT INTO nca_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Mande ŋundo kho taró quwore naŋge o soso tunoqaró. Oka tunoqaró ŋuko khe enesówore kama tunoqaró. ");
INSERT INTO nca_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mande ŋuko yoto-yoto unipare yunoyote. Ko yoto-yoto ŋundo hiyó tiní unipare hiyóqeyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Hiyó ŋu huririko hiyóqeyote. Ko huririko hiyó kama riní umbuyote. ");
INSERT INTO nca_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Asa Anutuko uni ka asáŋoní maheró. Uni ŋu owí muko Jon. ");
INSERT INTO nca_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ene hiyó ŋuro mande wisiyo yewero maheró. Yiní unipare mandí iŋoro iŋondutuwowaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Eneŋomboko hiyó ŋu kini. Hiyó ŋuro mande wisiyo yewero naŋge maheró. ");
INSERT INTO nca_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Hiyó ŋuko hiyó hamó qu ko unipare hiyóqewero quro nokono umburó. ");
INSERT INTO nca_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Komo enendo noko ŋu riní tunoqaró. Quko nokono unipare ŋundo ene kama iŋo inaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Eneŋo mirayómo maheró, quko uni topé kumimbo topo kama te inaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ŋunde quko kumimbo topo te inoro owí iŋondutuwoyoteŋgo, enendo unipare ŋu yoriní meté Anutu koro simó tunoqewaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Simó ŋunde qu uniparetoro sowe qu kini. Ŋuya unindoro nuŋguríyembo kama yori tunoqaŋgurí, ma awa-awayemboro nuŋguríyembo kama yori tunoqaŋgurí. Kini, Anutu eneŋombo yoriní eneŋo simó tunoqeyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mande ŋundo kowí saŋaní rero keweronanimo tuwi yamaru raŋaró. Ŋunde tiní norendo eneŋo sine parámiyó ŋu qenetowó, ko sine parámiyó ŋuko Naŋuní Kanata Naŋge Iwí moŋgo maheró quro sine parámiyó qu. Ŋuko samaka-samaka tuwó koya o soso hamó-hamó quya maŋgoraró. ");
INSERT INTO nca_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jonko uni ŋuro yesowaró. Ŋande nekaró, “Komo, nondo uni ŋaro ŋande ye yimiranowó, ‘Uni ka no huwónemo maheweya ŋuko komo suki yora, ŋunde ŋuroko no taka nerete.’” ");
INSERT INTO nca_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Asa eneŋo samaka-samaka tuwó parámi ŋu noŋgo nore puriŋo kate-kate reyato. ");
INSERT INTO nca_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Qeni, Anutuko Moseswore hutuŋo mande nore nunaró. Ko enendo Yesu Kristowore samaka-samaka tuwó ŋuya mande hamó muya riní tunoqaró. ");
INSERT INTO nca_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Uni kato naru kano Anutu kama qeneró. Kini. Naŋuní Kanata Naŋgeko Iwí taŋgímo yorote ŋundo ene witú niriní iŋoyato. ");
INSERT INTO nca_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Asa naru kano Juda koro uni pará-parámbo o qa-qa unindoya Liwai koro sowe quya asá yiri Yerusalem rotoro ene dani ka oseseyowero Jonko maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ŋunde oseseyi Jonko kama tapuŋoro tunomo yero ŋande yesowaró, “Noko Kristo ŋu kini.” ");
INSERT INTO nca_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Yiní ŋande oseseyaŋgurí, “Asa ko ke dani ka? Keko Elaija peka?” Yiqo, ŋande yaró, “Kini.” Yiní ŋande yaŋgurí, “Keko Ye-ye uni ŋu peka?” Yiqo, mande topé ŋande yaró, “Kini.” ");
INSERT INTO nca_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ŋunde ŋuroko ŋande yaŋgurí, “Ke dani ka? Nore unindo asá nereŋgurí quro mande topé ka yewato. Keto keŋomboro date yete?” ");
INSERT INTO nca_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ŋunde yi Jonko ye-ye uni Aisaia koro maŋgó rero ŋande yaró, “No uni ka mira wimbímo nekoro ŋande yeteno, ‘Uni Parámimboro khe roŋgaruwoyi qembe.’” ");
INSERT INTO nca_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Juda unindo Farisi uni kumi ŋuya asá yiri maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Asa uni ŋundo Jon ŋande oseseyaŋgurí, “Keko Kristo ŋu kini, ko Elaija kini, ko Ye-ye uni ŋu kini. Asa ke do murí karo unipare sono re yunoyote?” ");
INSERT INTO nca_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jonko mande topé ŋande yaró, “Nondo ye sonono kina sono re yunoyoteno. Quko uni ka ye keweroyemo yote, ye uni ŋu kama iŋo inoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ŋuko huwónemo mahete ŋu. Nondo eneŋo khe punu-punuyómboro utó orosoyewero owéne moré kini,” yaró. ");
INSERT INTO nca_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ŋu soso Betani yendémo Jotan sono karóŋo andusina ŋuno tunoqaró. Ŋuno Jonko unipare sono re yunoyara. ");
INSERT INTO nca_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Saraŋoní, Yesu mahiní Jonko qenero ŋande yaró, “Qeni, ŋuko Anutu koro sipsip simó ŋu. Enendo unipare soso nokono yoteŋgo ŋu quhuríye se rotoweya. ");
INSERT INTO nca_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Komo nondo uni ŋuro ŋande yanowó, ‘Uni ka no huwónemo maheweya ŋuko komo suki yora. Ŋunde ŋuroko enendo taka nerete.’ ");
INSERT INTO nca_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nondo uni ŋu dani yero kama iŋanowó. Quko nondo Israel unipareto uni ŋu qene iŋowero quro mahero unipare sono re yunoyoteno.” ");
INSERT INTO nca_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jonko ŋande yesowaró, “Nondo Yuqako sambo rotoro nú qembe tero umburo Yesu saŋanímo ŋuno yora, ŋu qenenowó. ");
INSERT INTO nca_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nondo uni ŋu dani ka yero kama iŋanowó. Quko Anutuko no unipare sono re yunowero asá nerero ŋande nimiraró, ‘Yuqako umburo uni ka saŋanímo yoweya ŋu, asa ke sono re yunoyote ŋunde qembe uni ŋundo unipare Yuqa Surumí re yunoweya.’ ");
INSERT INTO nca_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ŋundiro naŋge nondo uni ŋu qenero mande ŋande yesowoteno, uni ŋuko Anutu koro Naŋuní.” ");
INSERT INTO nca_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Saraŋoní, Jon pitu ko ŋuno kaŋeyoníqo, eneŋo iŋo-iŋo rewero uniyó irisa ŋuya ŋuno kaŋeyariyó. ");
INSERT INTO nca_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yesu uyariní Jonko qenero ŋande yaró, “Qeniri, Anutu koro Sipsip Simó ŋu.” ");
INSERT INTO nca_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ŋunde yiníqo, iŋo-iŋo rewero uni ŋu iŋoro Yesu howariyó. ");
INSERT INTO nca_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Howiri Yesu rohoréŋoro toŋetero yiyoro ŋande osese yereró, “Yari do ka seqatiri?” yaró. Enepa oseseyariyó, “Rapi, ke dano yorote?” (“Rapi” ŋuro murí muko ŋandiro, “Rondaqe-rondaqe Uni.”) ");
INSERT INTO nca_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yiriqo, ŋande yimiraró, “Mahe qeniri.” Yiní ya ŋuno yaró ŋuno uyare qeneriyó. Qeniri suwoya tiní eneya yorariyó. ");
INSERT INTO nca_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Uni ka Jonko mande yiní iŋoro Yesu howaró ŋuko Andru, Saimon-Pita koro koneyó. ");
INSERT INTO nca_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Asa enendo imemoŋgo Yesu rotoro koretero uyaro payó Saimon qeneró. Qenero ŋande miraró, “Nore Mesaiya qeneteto,” yaró. (“Mesaiya” ŋuro murí muko “Kristo.”) ");
INSERT INTO nca_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ko Andruko payó rero Yesuko uyaró. Re uyariní Yesuko qenero ŋande yaró, “Keko Saimon, Jon koro naŋuní. Imemoŋgoko owéŋge, ‘Sipas,’ ye neko kerewaŋgo.” (Owé “Sipas” ŋuko “Pita” ŋundiro naŋge.) ");
INSERT INTO nca_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Saraŋoní, Galili mirako uyare Filip qenewero ye iŋaró. Ko Yesuko ŋande miraró, “Ke maheya nohowe.” ");
INSERT INTO nca_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip ŋuko yendé kembé Betisaita noŋgo qu, yendé ŋuko Andru koya Pita koya yendéyari. ");
INSERT INTO nca_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Asa ko Filip uyaro Nataniel qenero ŋande miraró, “Komo Mosesko hutuŋo mandeko ŋuno uni karo ŋande nakayáŋaró, ko ye-ye unindo ŋuya ŋuro nakayáŋaŋgurí. Asa norendo uni ŋu qeneto. Ŋuko Yesu Nasaret yendé moŋgo, Josep koro naŋuní.” ");
INSERT INTO nca_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ko Natanieliko ŋande oseseyaró, “Do o meté ka Nasaret noŋgo meté tunoqeweya?” Yiní ŋande miraró, “Ke maheya qeno.” ");
INSERT INTO nca_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Mahiri Yesuko Nataniel qenero ŋuro ŋande yaró, “Qeni. Hamó Israel uni ka kota murí qu eneno kama yote qu mahete.” ");
INSERT INTO nca_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ko Natanieliko ŋande yaró, “Ke date tero no iŋo nunote?” Yiní Yesu mande topé ŋande yaró, “Filipko ke kama neko kereyoníqota no ke kewá fik murímo ŋuno yuri kiyanowó.” ");
INSERT INTO nca_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Yiní Natanieliko ŋande yaró, “Rapi, keko Anutu koro Naŋuní, Israel koro wiri yerete uni ŋu.” ");
INSERT INTO nca_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ko Yesuko mande topé ŋande yaró, “No ŋande kimiroteno, no ke kewá fik murímo yori kiyanowó mu kimiroteno, ko ŋunde ŋuro naŋge no iŋondutu nereyote. Imemoŋgo keto o parámi horé ka o ŋu takaweya qu qeneweya.” ");
INSERT INTO nca_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yero ŋande yaró, “No hamó horé ye yimiroteno, imemoŋgo ye sambo kosoní qenewaŋgo, ko Anutu koro sambo simó otoqoro Unindoro Naŋuní saŋanímo umbuyoteŋgo ŋu yiyowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yaŋini Galili mirako Kana yendémo ŋuno epe re-re tewero naru ka tunoqaró. Yesu koro nimímbo epe re-re ŋu qenewero ŋuno uyaró. ");
INSERT INTO nca_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Komo, pare reweya ŋundo Yesu koya eneŋo iŋo-iŋo rewero uniyómboya neko yiriní ŋuno maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Asa o ne-ne naru keweroko ŋuno wain ŋu kini taró, ko nimímbo Yesu ŋande miraró, “Wain ŋu kini tete,” yaró. ");
INSERT INTO nca_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yiní mande topé ŋande yaró, “Ná, do karo ŋundiro nimirote? Neneŋo narune muko itaka kini.” ");
INSERT INTO nca_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ŋunde yiní nimímbo sunará simó ŋandiro yimiraró, “Enendo o ka yimironíqo, ŋu ti qembe,” yaró. ");
INSERT INTO nca_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yano quroko ŋuno noko kumbe parámi kande saŋiyoro kanata ŋuno yaŋgurí. Kumbe kanata-kanata sono lita 45 ŋundiro mondo towaŋgurí. Juda unipareto hutuŋo mandeye howero sono ŋu rero kandeye sonowoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Asa Yesuko sunará simó ŋande yimiraró, “Noko kumbe soso ŋuno sono hausuwoyi,” yiní sono hausuwoyi hamó-hamó maŋgoraŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Maŋgoriní ŋande yimiraró, “Asa topa kano mondoya o ne-ne ŋuro sopo-sopo ŋu inoyi,” yiní ŋunde taŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ŋunde ti sopo-sopo unindo sono rohoréŋoro wain tunoqaró ŋu naró. Nero da noŋgo siyaŋgurí ŋu kama iŋaró, quko sunará simómbo sono mondaŋgurí ŋu iŋomukaŋgurí. Asa sopo-sopo unindo uni epe re-re tewero ŋu nekoní maheró. ");
INSERT INTO nca_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Mahiní ŋande miraró, “Uni ka o ne-ne teyote ŋuko koretero wain meté mu eneŋo topé-topé yunoyote. Ko imemoŋgo, topé-topémbo parámi nero kape-kape tiqo, wain soŋga piyimi mu yunoyote. Quko keto wain meté mu tapuŋoro itaka ka re mahete,” yaró. ");
INSERT INTO nca_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Asa Yesuko rokó korete ŋu Galili mirako Kana yendémo ŋuno taró. Ŋundiro naŋge Yesu eneŋo sine parámiyó wisiyoní eneŋo iŋo-iŋo rewero uniyó qenero Yesu iŋondutuwoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Imemoŋgo Yesu, nimí, kone-topé, iŋo-iŋo rewero uniyó, ŋu soso Kana yendé rotoro yendé kembé Kaperneam ŋuno uŋgurí. Naru qambu ka yendémo ŋuno yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Naru kano Juda uniparetoro o ne-ne parámi, owí muko Taka yereró, ŋu tunoqewero taró, ko Yesuko Yerusalem oró. ");
INSERT INTO nca_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Oro Anutu koro Ya Surumímboro hoŋgo quroko ŋuno Yesuko yiyoní uni kumimbo makao, sipsip, nú se ŋuno soweyoyaŋgo. Ko kumi yakutímo kunditero mone enesó-enesó rohoréŋoro Juda koro mone qu yero reyaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Asa Yesuko utó kumi toworo sipsip, makao ŋu yuto yohowiní Ya Surumímboro hoŋgo sumeyo uŋgurí. Moneye se windoroŋoro yakutíye ŋu soso uroní umbuŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ŋunde tero nú soweyoyaŋgo ŋu ŋande yimiraró, “Nú ŋa se toŋi! Ye Awanemboro Ya qu ri maketi ka tunoqaró! Ŋu roti!” ");
INSERT INTO nca_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ŋunde tiníqo, eneŋo iŋo-iŋo rewero uni qenero mande ka sokomeko ŋuno nakayáŋaró ŋuro iŋaŋgurí. Mande ŋuko ŋandiro, “No keŋo ya ŋuro hamó horé iŋoyoteno. Ko muríne ŋundo rambaruru nereweya.” ");
INSERT INTO nca_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Asa Juda koro uni pará-parámbo Yesuko o taró ŋu qenero ŋande oseseyaŋgurí, “Keto do rokó ka teweya ŋuko keŋo otete ŋu tewero quro owéŋge ŋu nore witú nereweya?” ");
INSERT INTO nca_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ŋunde yi mande topé ŋande yimiraró, “Yendo Ya Surumí ŋa rambaruruwoyiqota naru kapusa quno ŋuno rewe otoqoro meté teweya.” ");
INSERT INTO nca_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ŋunde ŋuro ŋande yaŋgurí, “Aine, kumima naru 46 ŋunde rotoro Ya Surumí ŋa towoyaŋgurí, quko naru kapusa qunope keto ri otoqoweyape?” ");
INSERT INTO nca_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ŋunde yaŋgurí, quko Yesuko ya surumí ŋuro yaró ŋuko eneŋo kowí naŋge. ");
INSERT INTO nca_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ŋunde ŋuro imemoŋgo, Anutuko Yesu okokowoní uni tapu koŋgo otoqoníqo, eneŋo iŋo-iŋo rewero uniyó komo mande yaró ŋu ko iŋaŋgurí. Iŋoro mande sokomeko ŋuno nakayáŋgurí ŋuya mande Yesuko yimitoyaró ŋuya iŋondutuwoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Asa Yesu Yerusalem ŋuno yoníqo, Taka yereró quro o ne-ne ŋu tunoqaró. Ŋu naruko ŋuno rokó-rokó teyara. Ŋunde tiní unipare qambu qenero owí iŋondutuwoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Quko Yesuko eneŋo kandeyemo kama raró. Dokoro enendo unipare soso koro newondeye iŋoní tondaŋemukaró. ");
INSERT INTO nca_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Enendo uni ka kama oseseyoní uniparetoro muríye yesowo miraró. Dokoro ene uniparetoro newondeye iŋoní tondaŋemukaró. ");
INSERT INTO nca_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Asa uni ka yaró mu, owí muko Nikodemus. Ŋuko Farisi uni ka, Juda koro uni kembé ka. ");
INSERT INTO nca_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Uni ŋu suwono Yesuko mahero ŋande yaró, “Rapi, nore ŋande iŋomukoteto, keko rondaqe-rondaqe uni Anutu koŋgo mahete qu. Dokoro Anutuko uni kaya kama yote tiníqo, rokó-rokó keto teyote ŋunde qu tewero mepémo kini.” ");
INSERT INTO nca_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesuko mandí topé ŋande yaró, “Hamó horé ŋande kimiroteno, uni ka pitu ko kama pisiyoweya quko, enendo Anutuko unipareyó wiri yereyote naruyó ŋu kama qeneweya.” ");
INSERT INTO nca_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Yiní ŋande oseseyaró, “Date tero uni koŋgomu kato pitu ko nimímbo pisiyoweya? Ŋumbeka nimí qahí quroko pitu ko uweya?” ");
INSERT INTO nca_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesuko mande topé ŋande yaró, “Hamó horé, ŋande kimiroteno, uni ka sonowore, Yuqawore kama pisiyoweya quko, enendo Anutuko unipareyó wiri yereyote naruyómo ŋuno kama oweya. ");
INSERT INTO nca_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kowe saŋanímbo pisiyote ŋuko kowe saŋaní naŋge, ko Yuqako pisiyote ŋuko yuqa naŋge. ");
INSERT INTO nca_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nondo kimiroteno, ‘Ye pisiyoweya qu pitu ko tunoqi,’ yeteno, quko ŋuro iŋondata parámi ma tewero. ");
INSERT INTO nca_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Qeno, matú ŋuko eneŋo iŋo-iŋoyó howero mira kawore-kawore ŋana uyote. Ke niriyó ŋu iŋoyote, quko dawore mahete ko dawore ute ŋu kama iŋoyote. Asa Yuqako date unipare pisi yerete ŋuro murí ŋuya kama iŋoyoteto.” ");
INSERT INTO nca_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemusko ŋande oseseyaró, “Ŋu date tunoqeweya?” ");
INSERT INTO nca_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yiní mande topé ŋande yaró, “Date koro? Ke Israel uniparetoro rondaqe-rondaqe uni tete, quko o ŋuro kama iŋote ŋu? ");
INSERT INTO nca_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Hamó horé kimiroteno, noreko o iŋoyoteto ŋuro yeyoteto. Ko o komo qeneto ŋuro yesowo yeyoteto. Quko ye mande norendo yesowo yeyoteto ŋuro huwóŋoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nondo o nokono quro yimiranowó, quko ye kama iŋondutuwoyaŋgurí. Ŋunde ŋuroko no o samboko quro ye yimirowano tiníqo, ye date iŋondutuwowaŋgo? ");
INSERT INTO nca_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ko uni kato samboko kama oró. Kini. Unindoro Naŋuní ŋundo naŋge sambo ŋu roto umburó. ");
INSERT INTO nca_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Komo Mosesko mira wimbímo sire ka hokaró, ŋunde naŋge uni kumimbo Unindoro Naŋuní hokowaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ŋunde tero uni soso iŋondutu tewaŋgo ŋuko ene quroyómo ŋuno yoto-yoto suki-suki rewaŋgo,” yaró. ");
INSERT INTO nca_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Dokoro Anutuko hamó newonde meté unipare soso yunoyote. Ŋunde tero Naŋuní Kanata Naŋge ŋu roto yunaró. Roto yunoní unipare soso Naŋuní ŋu iŋondutuwoyoteŋgo ŋuko kama piyo tewaŋgo. Kini, yoto-yoto suki-suki rewaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dokoro Anutuko Naŋunímbo oteteyemboro topé piyimi unipare yunowero quro kama asáŋoní nokono umburó. Kini, Naŋuníwore unipare rambaruru koŋgo yorewero quro asáŋoní umburó. ");
INSERT INTO nca_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Uni kato iŋondutuwoyote ŋuko topé piyimi kama reweya. Quko uni kato kama iŋondutuwoyote ŋuko, Anutuko komo ŋande yaró, topé piyimi reweya. Dokoro, enendo Anutu koro Naŋuní Kanata Naŋge koro owí ŋu kama iŋondutuwoyaró. ");
INSERT INTO nca_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ko topé piyimi reweya ŋuro murí muko ŋandiro: hiyó nokono tunoqaró. Quko unipareto otete piyimi teyaŋgo. Ŋuroko huriri koro watí metéŋoro hiyó huwóŋoyaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Unipare soso o piyimi teyoteŋgo ŋuko, hiyó koro saŋgiríŋo tero hiyómo ŋuno kama maheyoteŋgo. Dokoro ŋunde mahiqo, oteteye tunomo tunoqeweya. ");
INSERT INTO nca_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Quko uni ka otete hamó mu teyote ŋuko hiyómo maheyote. Ŋunde tero unipare soso ŋundo ene Anutu howero o taró ŋu qene iŋowaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Imemoŋgo Yesu koya iŋo-iŋo rewero uniyómboya Judia mirako ŋuno uyareŋgurí. Uyaro ŋuno yotoro unipare sono re yunoyara. ");
INSERT INTO nca_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ŋu naruko ŋuno Jonko Salim yendé sumeyoro Ainon yendé ŋuno sono re yunoyara. Dokoro sono qambu ŋuno yora. Unipare ŋuno mahiqo, sono re yunoyara. ");
INSERT INTO nca_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Ŋu naruko ŋuno Jon kusi-kusi yano kama re rotaŋgurí.) ");
INSERT INTO nca_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Asa Jon koro iŋo-iŋo rewero uniyómboya Juda uni kanata kaya kiro puso tero ŋande yaŋgurí, “Nore date sonoworo Anutu toŋímo sara tewato,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ŋunde tero iŋo-iŋo rewero uniyó Jonko uyaro ŋande miraŋgurí, “Rapi, uni komo keya Jotan Sono karóŋo andusina yotoro keto ŋuro yesowoyaró ŋuno qu, itaka enendo unipare sono re yunoní soso ŋuno uyaremukoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ŋunde yi Jonko mande topé ŋande yaró, “Asa Anutu samboko yote ŋundo oka re uni ka kama inoníqo, o ŋu kama reweya. ");
INSERT INTO nca_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Yeŋombo komo nondo mande yanowó ŋu iŋaŋgurí, ‘Kristo ŋuko no kini. Kini, koretero Anutuko asá niriní maheweqota tukú maheweya.’ ");
INSERT INTO nca_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Uni kaya pare kaya epe re-re tewari quno ŋuno uni ŋundo naŋge pare ŋu reweya. Eneŋo topémbo soporo kusumbo rero maŋgó iŋoro niŋgu-niŋgu parámi tete. Ŋunde ŋuroko itaka naŋge niŋgu-niŋgu teteno, ko niŋgu-niŋgu ŋu parámi tete. ");
INSERT INTO nca_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Eneŋo owí muko hamó oní neneŋo owéne muko umbuweya. ");
INSERT INTO nca_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Uni kore koŋgo umburó ŋuko o soso taka yereyote. Uni noko noŋgo maheró ŋuko noko koro qu naŋge, ko ene noko ŋaro o quro yeyote qu. Uni sambo koŋgo umburó ŋuko o soso taka yereyote. ");
INSERT INTO nca_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Eneko o komo qenero iŋaró ŋuro yesowo yeyote. Quko unindo mande yesowoyote ŋu kama reyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Uni ka eneŋo mandí reyote ŋuko, ‘Anutuko mande hamó yeyote,’ ŋundiro witú nereyote. ");
INSERT INTO nca_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Hamó, Anutuko uni asáŋoní maheró ŋuko Anutu koro mandí yeyote, dokoro, Anutuko Yuqa Surumí ŋu parámi inaró. ");
INSERT INTO nca_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Iwímbo newonde meté Naŋuní hamó inoro komo o soso se kandímo rotaró. ");
INSERT INTO nca_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Uni ka Naŋuní ŋu iŋondutuwoyote ŋuko yoto-yoto suki-suki moré. Quko uni ka Naŋuní ŋu huwóŋoyote ŋuko yoto-yoto kama reweya. Kini. Anutu koro newonde saŋgirí watí eneno yote.” ");
INSERT INTO nca_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Jonko iŋo-iŋo rewero unipare yorero sono re yunoyaró, ko Yesu ŋuya ŋunde taró, quko enendo parámi tero Jon ŋunde takaró. (Hamó, Yesu enepa naŋge uni ka kama sono re inaró. Kini. Eneŋo iŋo-iŋo rewero uniyómbo naŋge sono re yunoyaŋgurí.) Ko Farisi unindo o taró ŋuro mande piŋayó iŋoyiqo, Yesuko ŋuro iŋoro Judia mira ŋu rotoro Galili mirako ŋuno uró. ");
INSERT INTO nca_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Asa Galili urowero Samaria mira keweroko ŋuno uyaró. ");
INSERT INTO nca_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ŋunde uyareyate yendé parámi Sika ŋuno uyaró. Yendé sumeyoro ŋuno mira ka komo Yakopko naŋuní Josep inaró mu ŋuno yaró. ");
INSERT INTO nca_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Mira ŋuno meré sono ka Yakopko saró mu yaró. Asa Yesu khewore uyareyate kowí surumíŋoní kosa keweroko mahero meré sono sumeyoro ŋuno kunditaró. ");
INSERT INTO nca_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Kunditiní Samaria pare ka sono mondowero maheró. Mahiní Yesuko ŋande miraró, “Sono re nunoka newe.” ");
INSERT INTO nca_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Ŋunde yaró, dokoro iŋo-iŋo rewero uniyó o qoyemboro kimowero yendémo omukaŋgurí quno.) ");
INSERT INTO nca_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Asa Samaria pare ŋundo ŋande miraró, “Keko Juda uni ka, noko Samaria pare ka. Ke date koro ŋunde yete, ‘Sono re nunoka, newe?’” (Ŋunde yaró, dokoro Samaria unipareto topako neyaŋgo tiníqo, Juda unipareto ŋu noŋgo kama newaŋgo.) ");
INSERT INTO nca_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Asa Yesuko ŋande miraró, “Keto Anutu koro puriŋo koya uni, sono re ŋuno yero kimira ŋuya iŋote tiníqo, ene kirayoyiqo, sono yoto-yotoyó moré mu re kunoweya.” ");
INSERT INTO nca_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Yiní ŋande yaró, “Awa, ke kumbeke moré kini ŋa! Meré sono ŋako meré piyimi. Ŋunde ŋuro sono yoto-yotoyó moré ŋu, ke da noŋgo reweya? ");
INSERT INTO nca_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Usinani Yakopko meré sono ŋa nore nunaró. Eneŋombo ŋano neyara, ko naŋo-simó, makao, sipsipyó ŋu soso meré sonono ŋano neyaŋgurí. Keŋo owéŋgepo Yakop koro owí takate, peka?” ");
INSERT INTO nca_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesuko mande topé ŋande yaró, “Uni kato meré sonono ŋano neyoteŋgo, quko imemoŋgo pitu ko sono koro khumoweya. ");
INSERT INTO nca_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Quko uni ka nondo sono re inoteno ŋu neweya ŋuko naru suki-suki sono koro kama khumoweya. Kini, sono re inoteno ŋuko quroyómo ŋuno sono umó ŋunde qembe tunoqero yoto-yoto suki-suki inoweya.” ");
INSERT INTO nca_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Pareto ŋande miraró, “Awa, sono ŋunde qu re nunokata imemoŋgo sono koro khumoro mahero ŋa noŋgo sono kama mondoyowano.” ");
INSERT INTO nca_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yiní ŋande miraró, “Ke toŋeya kameŋge neko re mahiri.” ");
INSERT INTO nca_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Yiní mande topé ŋande yaró, “No kamene moré kini.” Yiní ŋande miraró, “Hamó yete, ke kameŋge moré kini, ");
INSERT INTO nca_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","dokoro komo ke kameŋge kandeka qu yorotaró ŋu. Ko uni ŋu keya yotiri ŋuko, keŋo kameŋge kini. Mande yete ŋuko hamó naŋge.” ");
INSERT INTO nca_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ko pareto ŋande miraró, “Awa, itakako no iŋoteno, keko ye-ye uni ka. ");
INSERT INTO nca_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nore usi-sinani muko mira purímo ŋano koporo potoruku teyaŋgo. Asa ye Juda unindo ŋande yeyoteŋgo, uni soso Yerusalem ŋuno naŋge potoruku ti.” ");
INSERT INTO nca_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesuko ŋande miraró, “Pare, ke mande ŋa kondé iŋo. Imemoŋgo naru kano yendo mira purí ŋano Anutu Awa potoruku kama te inowaŋgo. Ŋuya norendo Yerusalem ŋuno potoruku kama te inowato. ");
INSERT INTO nca_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ye Samaria, yeko o kama iŋoteŋgo ŋuro potoruku te inoyoteŋgo. Nore Juda, noreko o hamó iŋoyoteto ŋuro potoruku te inoyoteto. Dokoro nore soso rambaruru takawero murí ŋu Juda uniwore maheró. ");
INSERT INTO nca_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Quko naru ka tunoqewe tete, hamó itaka tete. Naru ŋunoko uni potoruku hamó te inoyoteŋgo qundo yuqayewore Anutu potoruku hamó te inowaŋgo. Ko Awando uni ŋunde qu seqa yereyote. ");
INSERT INTO nca_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Asa Anutu ŋuko yuqa naŋge. Ŋunde ŋuroko dani ka potoruku te inoyoteŋgo ŋuko yuqayewore potoruku hamó te inowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yiní ŋande miraró, “No iŋoteno. Mesaiya ŋu, ‘Kristo,’ ye nekoyoteŋgo, ŋundo mahero o soso wisiyoro nore nunoweya.” ");
INSERT INTO nca_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yiní ŋande miraró, “Ŋuko no naŋge, itaka keya mande teyotero ŋa!” ");
INSERT INTO nca_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yesuko yiní kini tiní iŋo-iŋo rewero uniyó pitu ko maheŋgurí. Mahero, Yesuko pare kaya mande tariyó ŋu yiyoro iŋondata parámi taŋgurí. Quko uni kato pare ŋu ŋande kama oseseyaró, “Ke do ka rewero mahete?” ko kato Yesu ŋande kama oseseyaró, “Ke do karo pare ŋuya mande teyotiri?” ");
INSERT INTO nca_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Asa pare ŋu kumbeyó rotoro yendémo uyaró. Uyaro unipare ŋande yimiraró, ");
INSERT INTO nca_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ye maheya uni ka ŋana qeni. Enendo nondo o komo teyano qu soso nimitomukote. Uni ŋumbeka Kristo ŋuno qu?” ");
INSERT INTO nca_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Yiní unipare yendé rotoro Yesu qenewero maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Asa pare yendémo uyarewero toŋeró quno iŋo-iŋo rewero uniyómbo Yesu ŋande miraŋgurí, “Rapi, ke qoŋgeporo ne.” ");
INSERT INTO nca_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Quko ene ŋande yimiraró, “Nondo o qonemboro moré quko ye ŋuro kama iŋoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ŋunde yiní epe mito-mito ŋande yaŋgurí, “Ŋambeka uni kato o qímboro ka se mahero inoyote?” ");
INSERT INTO nca_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yiqo, ŋande yimiraró, “Neneŋo o qonemboro ŋu, nondo no asá nereró ŋuro iŋo-iŋoyó howero eneŋomboro khoyó rewe kini teweya, ŋuko neneŋo o qonemboro ŋu. ");
INSERT INTO nca_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Yembe, ‘Kombo nimí kini ŋunde rotoroqota kho noŋgo siyowero naru ŋu tunoqeweya,’ ŋunde yeyoteŋgo, hamómbe? Quko nondo ye ŋande yimiroteno, ‘Toŋeteya kho gima meté qeni. Komo eŋgé ŋu tunoqa.’ Itaka ka ");
INSERT INTO nca_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","eŋgé siyowero uni ŋundo kimoyó rero o eŋgé koponí yoto-yoto suki-suki reyote. Ŋunde ŋuro uni o yuwoyó rimite quya eŋgé siyowero uni ŋuya irisa-irisa niŋgu-niŋgu tewari. ");
INSERT INTO nca_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Dokoro mande ŋako hamó, ‘Uni kato o yuwoyó riminíqota meyowomboko eŋgé siyoweya.’ ");
INSERT INTO nca_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yendo kho ŋu kama taŋgurí, quko ŋuro eŋgé siyowero quro asá yereteno. Yendo uni meyowombo koweyumu taŋgurí ŋuro eŋgé siyowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Asa pare ŋundo piŋa mande Samaria unipare yimironí iŋoro qambu qundo Yesu iŋondutuwoyaŋgurí. Dokoro, ŋande yaró, “Enendo nondo komo o teyano qu soso nimitomukote.” ");
INSERT INTO nca_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ŋunde ŋuroko Samaria unipare ŋuno mahero Yesu kirayoro eneya yowero yaŋgurí. Ko yendémo ŋuno kosa naru irisa ŋuno yoraró. ");
INSERT INTO nca_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ŋuno yotoro mande yeyoní, yate unipare qambu iŋondutuwoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Iŋondutuworo pare ŋu ŋande miraŋgurí, “Komo keŋo mandeke iŋoro iŋondutuwoyatowó. Ŋu hamó quko itaka noreŋombo eneŋo mandí iŋoro hamó ŋande iŋoteto, ko uni ŋundo naŋge noko unipare soso yoriní rambaruru takawaŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Asa kosa naru irisa ŋunde rotoro Yesuko Samaria rotoro Galili uyaró. ");
INSERT INTO nca_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Dokoro eneŋombo ŋande yesowaró, “Ye-ye uni ka, eneŋo mirayómo ŋuno unipareto ará kama te inoyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ŋunde ŋuroko Galili ŋuno maheró quno ŋuno Galili unipareto qenero niŋgu-niŋgu taŋgurí, dokoro enendo o ne-ne naruko ŋuno Yerusalem ŋuno Yesuko o taró ŋu qeneŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ŋundiro Yesuko pitu ko Galili mirako Kana yendémo ŋuno maheró. Komo yendé ŋuno sono riní rohoréŋoro wain taró. Mahiní wiri yerete unindoro kho uni qu kato yendé kembé Kaperneam ŋuno yora, ko eneŋo naŋuní se khumo taró. ");
INSERT INTO nca_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Asa khumowero tiníqota kho uni ŋundo ŋande iŋaró, ko Yesuko Judia rotoro Galili mahete, iŋaró. Ŋunde ŋuroko ene Yesuko uyarero ŋande kirayaró, ko Kaperneam yendémo umburo naŋuní roŋgaruwoníkata meté tiní, yaró. ");
INSERT INTO nca_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Asa ko Yesuko ŋande miraró, “Yendo rokó enesó-enesó ŋu kama qeneyoteŋgo tiníqo, yendo kama iŋondutuwowaŋgo, peka.” ");
INSERT INTO nca_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Wiri yerete unindoro kho uni ŋundo ŋande miraró, “Uni Parámi, ke waka ta umbu, naŋone khumoweya koro.” ");
INSERT INTO nca_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yiní ŋande miraró, “Ke uya, simóŋge muko kama khumoweya, meté tete.” Yiní kho uni ŋu Yesu koro mandí ŋu iŋoní hamó tiní iŋondutuworo roto toŋeró. ");
INSERT INTO nca_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Asa Kaperneam ŋuno uyate eneŋo sunará simóŋombo kheko wisumuŋoro ŋande miraŋgurí, “Simóŋge muko meté tete.” ");
INSERT INTO nca_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ko enendo, do naruko naŋuní ŋu soŋga meté tete, yero osese yereró. Mandí topé ŋande yaŋgurí, “Suwo suwoya kosa rohoréŋoní kowí tiwi ŋu rota.” ");
INSERT INTO nca_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ŋunde yiqo, iwímbo ŋande iŋaró, ŋu naruko ŋuno naŋge Yesuko, “Simóŋge muko meté tete,” yiní iŋaró. Ŋunde tero iŋondutuwoní suwisawiyó ŋuya iŋondutuwoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ŋuko rokó irisayó mu Yesuko Judia rotoro Galili maheró quno ŋuno taró. ");
INSERT INTO nca_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Imemoŋgo Juda uniparetoro o ne-ne ka tunoqaró, ko Yesuko Yerusalem oró. ");
INSERT INTO nca_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yerusalem ŋuno, sono towo tomó ta ka ŋuno yora. Sono towo ŋuko yendémboro hoŋgo mako taŋgímo yora. Hoŋgo mako ŋuro owí muko Sipsip koro Mako, ko sono towo ŋuro owí Aram mandeko ŋuko Betisaita. Sono towo sumeyoro ŋuno yokoneyó kandeka ŋuno yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Yokonemo ŋuno se khumo uni qambu, asa toŋeye pokawí mu, kheye piyimi mu, ko uni wimbuye moré kini khumowí mu, ŋuno eteyaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","(-) ");
INSERT INTO nca_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Uni ka yokonemo ŋuno yora, ene wimbí moré kini se khumo teyate kumima naru 38 ŋunde rotaró. ");
INSERT INTO nca_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Asa Yesuko uni ŋu eteyoní qenero, uni ŋu se khumo piru teyote, ŋunde iŋoro ŋande oseseyaró, “Kepe, koweke meté tiní, ye iŋotepe, ma kini?” ");
INSERT INTO nca_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Se khumo uni ŋundo mande topé ŋande yaró, “Awa, sono okoko teyote quno no uni kato norero sono towo quroko ŋuno norotowero moré kini. Neneŋombo uyoteno quno uni kumimbo waka ta uro no taka nereyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ko Yesuko ŋande miraró, “Ke otoqoya yakutíŋge re korowoya khete-khete u.” ");
INSERT INTO nca_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Yiní waka ta se khumo kini tiní uni ŋuko meté taró. Meté tiní ene otoqoro yakutíŋo re koroworo khete-khete uyaró. Ŋu naru ŋuko Sapat naruko. ");
INSERT INTO nca_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ŋunde ŋuroko Juda koro uni pará-parámbo uni ŋu qenero ŋande mito yaŋgo, “Itaka ŋako Sapat naru. Hutuŋo mande ŋande yete, ke yakutíŋge ma re korowowero.” ");
INSERT INTO nca_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Quko enendo mandeye topé ŋande ye yimiraró, “Uni no noriní meté tanowó ŋundo ŋande nimiraró, ‘Yakutíŋge re korowo uya,’ yaró.” ");
INSERT INTO nca_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Yiní ŋande oseseyaŋgurí, “Dani kato kimira, ‘Re korowo uya,’ yaró?” ");
INSERT INTO nca_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Quko se khumo uni meté tunoqaró ŋundoko uni dando ŋunde miraró ŋu kama iŋaró, dokoro komo Yesuko unipare qambu yendé ŋuno yaŋgurí quro keweroyemo toŋeró ŋuro tero. ");
INSERT INTO nca_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tukúko Yesu Anutu koro Ya Surumí ŋuro hoŋgo quroko oro uni ŋu seqaro ŋande miraró, “Iŋo. Ke itakako meté tete. Ke kaŋuya o piyimi ma tewero, yate quhurí parámi kaŋuya keno maheweya koro.” ");
INSERT INTO nca_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Yiní uni ŋu uyaro Juda koro uni pará-pará ŋande yimiraró, “Uni no noriní meté tanowó ŋu, ŋuko Yesu naŋge.” ");
INSERT INTO nca_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ŋu murí ŋuro Juda koro uni pará-parámbo Yesu o piyimi te inoyaŋgurí, dokoro ene Sapat naruko ŋuno o ŋunde qu teyara. ");
INSERT INTO nca_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Quko Yesuko mandeye topé ŋande yaró, “Awanembo kho suki teyoní, yate itaka ŋa arete ŋa. Ko no ŋuya kho teyoteno.” ");
INSERT INTO nca_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ŋunde ŋuro murí irisa ŋuro Juda koro uni pará-parámbo hamó horé, uratoka khumoní, ye iŋaŋgurí. Dokoro Sapat naru koro hutuŋo mande ŋu wendaqaró, ko ŋande yaró, “Anutuko neneŋo awane.” Ŋunde yeroqo eneya Anutu koya ŋunde naŋge, yaró. ");
INSERT INTO nca_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Asa Yesuko mandeye topé ŋande yaró, “No hamó horé ye yimiroteno, Naŋuní eneŋombo oka tewero mepémo kini. Kini, enendo Iwí oka teyote qu qenero ŋu naŋge teyote. Dokoro Awando oka teyote ŋu naŋge Naŋunímbo teyote. ");
INSERT INTO nca_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Hamó, Awando Naŋunímboro hamó iŋoro o eneŋombo teyote ŋu soso witúŋoyote. Itaka Awando o tomó ta ka tete, quko imemoŋgo o parámi witúŋoníqota ye iŋondata parámi tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Qeni, Awako uni khumaŋgurí ŋu yoriní otoqo yoto-yoto reyoteŋgo. Ŋundiro naŋge Naŋuní ŋuya ene iŋo-iŋoyó howero uni kumi yoriní yoto-yoto reyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ŋuya Awako uni ka kama ronda yereyote. Kini, enendo unipare soso ronda yerewero quro owé ŋu Naŋuní re inaró. ");
INSERT INTO nca_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ŋuro tero uni soso Awa ará te inoyoteŋgo ŋundiro naŋge Naŋuní ŋuya ará te inoyowaŋgo. Quko uni ka Naŋuní yesaráŋoyoteŋgo ŋundo Awando ene asáŋoní maheró ŋuya yesaráŋoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“No hamó horé ye yimiroteno, uni ka no maŋgone iŋoyote ko no asá nereró mu iŋondutuwoyote ŋuko yoto-yotoyó suki-suki moré. Ŋuko topé piyimi kama reweya. Kini. Enendo kindo khumo rotoro yoto-yoto quroko oró. ");
INSERT INTO nca_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","No hamó horé yimiroteno, naru kanoko, iyo, itaka tunoqete ŋa, unipare khumowí mu Anutu koro Naŋunímboro maŋgó iŋowaŋgo. Iŋoro yoto-yoto rewaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Qeni, Awako eneŋomo yoto-yoto ŋu towote. Ŋundiro naŋge enendo wimbu Naŋuní inoní ene ŋuya eneŋomo yoto-yoto ŋu towote. ");
INSERT INTO nca_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ko unipare soso ronda yerewero quro owé ka Naŋuní re inaró, dokoro eneko Unindoro Naŋuní. ");
INSERT INTO nca_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Ye mandene ŋaro iŋondata parámi ma tewero. Imemoŋgo naru kanoko unipare uni tapuko yoteŋgo qu maŋgó iŋoro ");
INSERT INTO nca_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","uni tapu rotoro yendémo mahewaŋgo. Mahero unipare o meté teyaŋgo ŋuko pitu ko otoqoro yoto-yoto rewaŋgo. Ko unipare o piyimi teyaŋgo ŋuko pitu ko otoqoro mande khono kaŋero topé piyimi rewaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","No neneŋombo naŋge oka ka kama teyoteno. Awanemboro maŋgó iŋoro unipare oteteye moŋgo ronda yereyoteno. Ko ronda yereyoteno ŋuko roneneŋowí mu, dokoro neneŋo iŋo-iŋo qu kama howeyoteno. Kini. Nondo eneŋombo no asá nereró ŋuro iŋo-iŋoyó howeyoteno. ");
INSERT INTO nca_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Asa nondo naŋge neneŋo yesowoyoteno tiníqo, mande ŋuko hamó kini. ");
INSERT INTO nca_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Uni kaŋuya neneŋo yesowoyote, ko no ŋande iŋoyoteno, mande yeyote ŋuko mande hamó. ");
INSERT INTO nca_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Yendo Jon oseseyuriqo, enendo mande hamó yesowaró. ");
INSERT INTO nca_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Uni kato mande ka neneŋo yete ŋu no kama iŋo inoyoteno. Quko Jon koro mandí ŋuro yeteno, dokoro, ye iŋondutuwoyiqo, Anutuko rambaruru koŋgo yoreweya. ");
INSERT INTO nca_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jonko te suru qembe qaro unipare hiyó yunoyara. Ko yendo naru tukuni hiyó ŋu qenero niŋgu-niŋgu taŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Quko no mande yesowoyoteno ŋuko Jon koro mandí ŋu takate. Qeni, Awanembo kho ka temukowero quro nunaró. Ko o teyoteno ŋuko neneŋo yesowoyote, dokoro Awanembo no asá nereró. ");
INSERT INTO nca_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ko Awando asá nereró ŋu, eneŋombo neneŋo yesowaró, quko yendo maŋgó kama iŋoro umu-kembé kama qeneŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ko mandí ŋuya yeno kama yote, dokoro, ye Awando uni asáŋaró ŋuro mandí kama iŋondutuwoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yeko ŋande ye iŋoyoteŋgo, ko mande sokomeko ŋuno nakayáŋaŋgurí ŋuwore yoto-yoto suki-suki rewaŋgo. Ŋunde ŋuroko ye sokome ŋu kondé weyo rondaŋeyoteŋgo. Ko sokome ŋundo neneŋo yesowo yeyote, ");
INSERT INTO nca_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","quko yendo yoto-yoto rewero quro nono kama maheteŋgo. ");
INSERT INTO nca_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Unindo seré te nunote ŋuro no kama iŋo inoyoteno. ");
INSERT INTO nca_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Quko no yeŋo newondeye iŋomukoteno, asa ye newonde meté Anutu kama inoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Noko Awanemboro owímo mahenowó, quko ye mandene kama iŋoyoteŋgo. Uni meyowo kato eneŋo owímo naŋge mahiníqota ye mandí iŋowaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ye date iŋondutu tewaŋgo? Yendo seré epe ino-ino teyoteŋgo, quko Anutu kanata koŋgo owé parámi ŋu kama seqayoteŋgo. ");
INSERT INTO nca_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Ŋande ma iŋowero, ko nondo Awa toŋímo ye yore mande khono kama yorotowano. Kini, samaka-samakaye, Moses ŋundo mande kho yunoweya. ");
INSERT INTO nca_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Dokoro ye Moses koro mandí ŋu iŋondutuworoqota neneŋo mandene ŋuya iŋondutuwowaŋgo, dokoro, mande nakayáŋaró ŋuko neneŋo yesowo yeyote. ");
INSERT INTO nca_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Quko ye mande nakayáŋaró ŋu kama iŋondutuwoyaŋgurí. Asa ko ye date neneŋo mande qu iŋondutuwowaŋgo?” ");
INSERT INTO nca_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tukúko Galili Sono Towo (owí kako Taiperius Sono Towo) karóŋoro andusina uyaró. ");
INSERT INTO nca_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Uyariní unipare qambu howaŋgurí, dokoro rokó qambu tero se khumo uni yoriní meté ti qeneyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Uyaro mira purímo oro iŋo-iŋo rewero uniyómboya kunditaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ŋu naruko ŋuno Juda koro o ne-ne parámi ka, owí muko Taka yereró, ŋuko tunoqewero taró. ");
INSERT INTO nca_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ŋunde ŋuroko Yesuko toŋeteroqo unipare qambu horé maheŋgurí ŋu yiyoro Filip ŋande oseseyaró, “Nore da noŋgo bret kimo tato unipare ŋundo newaŋgo?” ");
INSERT INTO nca_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Mande yaró ŋuko Filip towoŋaró naŋge. Eneŋomboko o teweya ŋu iŋomukaró.) ");
INSERT INTO nca_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ŋunde oseseyoní Filipko mande topé ŋande yaró, “Nore meté denarius 200 rotoro bret kimowato, quko unipare kanata-kanatako tomó ta naŋge rewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yiní iŋo-iŋo rewero uniyó kako, Andru, Saimon-Pita koro koneyó, ŋundo Yesu ŋande miraró, ");
INSERT INTO nca_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Simó ta ka ŋana yote, enendo bret bali mu kandeka quya sono qare irisa ŋana. Quko unipare parámi horé yoteŋgo. Bret ŋaya sono qare ŋaya date wutu yereweya?” ");
INSERT INTO nca_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesuko ŋande yaró, “Unipare yika kunditi.” Ŋuno komó parámi woteyara. Asa komó saŋano unipare kunditaŋgurí, ko urumuni naŋge qambuye muko 5,000 ŋundiro. ");
INSERT INTO nca_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kunditiqo, Yesuko bret ŋu rero Anutu yuŋgunaŋoro romboŋero unipare se yunaró. Sono qare irisa ŋu ŋuya ŋunde naŋge tero yunaró. Yunoní ni qahuye tinditaró. ");
INSERT INTO nca_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Mepémo ni kini tiníqo, iŋo-iŋo rewero uniyó ŋande yimiraró, “Ye sumi-sumi yote ŋu se huruwoyi. Sumi-sumi ŋu piyo teweya koro.” ");
INSERT INTO nca_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ŋunde yiní bret bali koro sumi-sumi ta-ta kama naŋgurí ŋu se koporo se toŋgo kome puŋge 12 ŋunde puŋgeyi maŋgoraró. ");
INSERT INTO nca_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ŋunde ŋuroko unipareto rokó taró ŋu qenero ŋande yaŋgurí, “Hamó horé, ŋuko ye-ye uni nokono maheweya ŋuno qu.” ");
INSERT INTO nca_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesuko ŋande iŋoní tondaŋaró, ko unipareto towo ri enendo wiri yerete uniye tunoqeweya, ye iŋaŋgurí. Ŋunde ŋuro enendo roto toŋero enemata purímo ŋuno pitu ko oró. ");
INSERT INTO nca_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Asa suwo tiní iŋo-iŋo rewero uniyó ŋu sono towoko uŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Uro waŋgo karo saŋano oro sono towo karóŋoro Kaperneam uyarewero uyareŋgurí. Uyareyate huriri tiníqo, Yesu eneno kama maheyoní ");
INSERT INTO nca_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","matú wimbí horé maheró, ko matú ŋundo windi parámi riní otoqaró. ");
INSERT INTO nca_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Sono towo karóŋoro uyare yate-yate kilomita kandekape ma kande saŋiyoro kanata ŋunde rotaŋgurí. Ŋunde rotoro toŋetiqo, Yesuko sono towo saŋawore khete-khetero waŋgo taŋgímo maheró. Mahiní qenero sasaro taŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Quko Yesuko ŋande yimiraró, “Ŋako no naŋge. Ye ma sorewero.” ");
INSERT INTO nca_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ŋunde yiní ri waŋgo saŋano oró. Oro waŋgo ŋu waka ta yendémo uyarewero ŋuno uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Saraŋoní unipare qambu sono towo karóŋo andusina yaŋgurí ŋundo ŋande qene iŋaŋgurí, ko waŋgo kanata naŋge komo ŋuno maheró. Ko Yesuko iŋo-iŋo rewero uniyómboya ŋuwore kama toŋeró. Kini. Komo iŋo-iŋo rewero uniyó enemata waŋgo ŋuwore uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Asa waŋgo kumi Taiperius yendé parámi rotoro mira ŋu Uni Parámimbo bret se Anutu yuŋgunaŋoro yunoní naŋgurí ŋuno maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ŋuno mahiqo, unipare qambu ŋundo ŋande qene iŋaŋgurí, Yesu koya iŋo-iŋo rewero uniyómboya ŋuno kama yaŋgurí. Asa ko ene waŋgo kumi ŋuro saŋano oro Yesu seqawero Kaperneam yendémo ŋuno uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Asa sono towo ŋunde karóŋoro andusina Yesu qenero ŋande miraŋgurí, “Rapi, ke do naruko ŋano mahe?” ");
INSERT INTO nca_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesuko mande topé ŋande yaró, “No hamó horé ye yimiroteno, yeko rokó-rokó qeneŋgurí, quko ŋu murí ŋuro kama mahe seqa nereteŋgo. Kini, yendo bret ŋu ni qahuye tinditaró naŋge. ");
INSERT INTO nca_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ye o newero qu puqeweya ŋu siyowero quro khoyó ma tewero. Kini. O newero qu suki-suki yoweya ŋu siyowero quro naŋge khoyó teyuri qembe. O newero ŋunde qu, Unindoro Naŋunímbota se yunoweya. Dokoro Awa Anutuko eneŋo owí re Naŋuní inaró.” ");
INSERT INTO nca_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Yiní ŋande miraŋgurí, “Nore do kho ka teroqota Anutu koro kho qu tewato?” ");
INSERT INTO nca_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ŋunde yi mande topé ŋande yimiraró, “Anutu koro kho qu ŋandiro. Ye uni Anutuko asáŋoní maheró ŋu naŋge iŋondutuwoyi qembe.” ");
INSERT INTO nca_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Yiníqo, ŋande oseseyaŋgurí, “Ke do rokó ka towiqota nore mandeke muko hamó qene iŋowato? ");
INSERT INTO nca_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Usi-sinanimbo mira wimbímo mana neyaŋgo. Qeno sokomeko ŋuno ŋande nakayáŋaró, ‘Ene sambo koŋgo bret qu se unipare yunoní naŋgurí.’” ");
INSERT INTO nca_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ŋunde yiqo, Yesuko ŋande yimiraró, “No hamó horé ye yimiroteno, Mosesko sambo koŋgo bret qu kama yunaró. Kini. Awanembo sambo koŋgo bret hamó qu se ye yunoyote. ");
INSERT INTO nca_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Hamó, Anutu koro bret ŋuko uni sambo roto umburo yoto-yotoye noko unipare yunoyote ŋu.” ");
INSERT INTO nca_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ŋunde yiníqo, ŋande miraŋgurí, “Uni Parámi, bret ŋunde qu re nore suki-suki nunoyoto qembe.” ");
INSERT INTO nca_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ko Yesuko ŋande yimiraró, “Yoto-yoto koro bret ŋuko no naŋge. Uni ka nono maheweya ŋuko pitu ko o qímboro kama khumoweya. Ko uni ka no iŋondutu nereweya ŋuko pitu ko sono koro kama khumoweya. ");
INSERT INTO nca_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Quko komo no ŋande ye yimiranowó, ko no niyoroqo iŋondutu kama taŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Awando unipare soso yorero nunaró ŋuko nono mahewaŋgo. Ko uni kato nono maheweya tiníqo, no hamó ene kama howewano. ");
INSERT INTO nca_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Dokoro neneŋo iŋo-iŋone howewero quro sambo koŋgo kama umbunowó. Kini. Ene no asá nereró ŋuro iŋo-iŋoyó howewero quro umbunowó ŋu. ");
INSERT INTO nca_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ko ene asá nereró ŋuro iŋo-iŋoyó ŋuko ŋandiro. Komo uni se nunaró ŋuro kanata ka kama rotowano. Kini, naru weŋako ŋuno okoko yerewe otoqowaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Dokoro Awanemboro iŋo-iŋoyó ŋuko ŋandiro, ko uni soso Naŋuní qenero iŋondutuwowaŋgo ŋuko yoto-yoto suki-suki rewaŋgo. Ŋunde ri nondo naru weŋako ŋuno okoko yerewe otoqowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Asa Yesuko, “Bret sambo roto umburó ŋuko no naŋge,” ŋunde yiníqo, Juda koro uni pará-parámbo iŋoro kisikasa yero ");
INSERT INTO nca_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ŋande yaŋgurí, “Uni ŋuko Yesu, Josep koro simó, hamómbe? Nore iwí-nimí iŋomukoteto. Asa date koro ŋunde yete, ‘No sambo roto umbunowó,’ yete?” ");
INSERT INTO nca_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ŋunde yi Yesuko mandeye topé ŋande ye yimiraró, “Ye keweroyemo kisikasa ma yewero. ");
INSERT INTO nca_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Uni kato kina nono mahewero mepémo kini. Kini, koretero Awando no asá nereró ŋundo uni ŋuro iŋo-iŋoye okoko yiriní nono mahewaŋgo. Ko nondo naru weŋako ŋuno okoko yerewe otoqowaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ye-ye unindoro sokomeko ŋuno ŋande nakayáŋaró, ‘Anutuko unipare soso iŋo-iŋo rondaqe yunoyoweya.’ Unipare soso Awandoro mandí ŋu iŋoro iŋo-iŋo meté reyoteŋgo ŋuko nono mahewaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Uni kato Awa ŋu kama qeneró. Kini. Uni ka komo Anutu koya yorariyó, ŋundo naŋge Awa qeneró. ");
INSERT INTO nca_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Hamó horé yimiroteno, uni ka iŋondutu teweya ŋuko yoto-yotoyó suki-suki moré. ");
INSERT INTO nca_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yoto-yoto koro bret ŋuko no naŋge. ");
INSERT INTO nca_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yeŋo usi-siyembo mira wimbímo mana neyateqo khumaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Bret sambo roto umburó ŋuko ŋandiro, unipareto ŋu newaŋgo ŋuko kama khumowaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Bret yoto-yotoyó moré ŋu sambo roto umburó ŋuko no naŋge. Ko uni kato bret ŋu neweya tiníqo, suki-suki yoweya. Ko bret nondo re yunowano ŋuko kowene saŋaní ŋu. Nondo re yunowekata noko unipare yoto-yotoye rewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ŋunde yiníqo, Juda koro uni pará-parámbo keweroyemo kiro mande tero ŋande yaŋgurí, “Uni kato date tero eneŋo kowí saŋaní ŋu re nunoní newero?” ");
INSERT INTO nca_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ŋunde yiqo, Yesuko ŋande yimiraró, “No hamó horé ye yimiroteno, ye Unindoro Naŋunímboro kowí saŋaní kama newaŋgo, ko sitúŋo kama newaŋgo tiníqo, yoto-yotoye ŋu yeno kama yoweya. ");
INSERT INTO nca_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Dani ka neneŋo kowene saŋaní nero sitúne neyote ŋuko yoto-yotoyó suki-suki moré, ko nondo naru weŋako ŋuno okokowowe otoqoweya. ");
INSERT INTO nca_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Dokoro, kowene saŋaní ŋuko o qoyemboro hamó qu, ko sitúne ŋuko o newero hamó qu. ");
INSERT INTO nca_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Uni kato no kowene saŋaní nero sitúne neweya ŋuko quronemo yoní, ko no quroyómo yowano. ");
INSERT INTO nca_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Awa yoto-yotoyó moré ŋundo no asá niriní mahenowó, ŋuroko no Awawore yoto-yoto reteno. Ŋunde naŋge uni ka no noneweya ŋuko nenewore yoto-yoto reweya. ");
INSERT INTO nca_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Bret sambo roto umburó ŋuko ŋundiro naŋge, quko bret komo usisambato neyateqo khumaŋgurí ŋuro kiraró kini. Kini, uni kato bret ŋa neweya ŋuko yoto-yoto rero suki-suki yoweya.” ");
INSERT INTO nca_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesuko mande ŋu yaró quno Kaperneam ŋuno huru-huru ya quroko yotoro unipare iŋo-iŋo rondaqe yunoyaró. ");
INSERT INTO nca_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ŋunde ŋuroko iŋo-iŋo rewero unipare qambu qundo mandí ŋu iŋoro ŋande yaŋgurí, “Mande ŋuko quhurí horé. Danimbo meté iŋoweya?” ");
INSERT INTO nca_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Asa Yesuko newondímo ŋande ye iŋaró, ko iŋo-iŋo rewero unipareyómbo mande ŋuro kisikasa yeyaŋgurí. Ŋunde ŋuro ŋande osese yereró, “Mande ŋandope newondeye riní piyo tete, hamómbe? ");
INSERT INTO nca_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Asa ko Unindoro Naŋuní ŋundo koreko oro komo ŋuno yara quno ŋuno oní qeneroqo ye date iŋowaŋgo? ");
INSERT INTO nca_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yuqa Surumí eneŋombo naŋge unipare yoto-yoto yunoyote. Koweye saŋaníwore o meté kama reyoteŋgo. Nondo mande yimiroteno ŋuko Yuqa qu, yoto-yoto qu. ");
INSERT INTO nca_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Quko uni kumi ye keweroyemo qundo iŋondutu kama teyoteŋgo.” Yesuko ŋunde yaró, dokoro komo suki eneŋombo uni dani kato iŋondutu kama taŋgurí ŋu iŋaró. Ko uni dando ene re uni piyimi kandeyemo rotoweya ŋu ŋuya iŋaró. ");
INSERT INTO nca_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Asa ŋande yaró, “Ŋu murí ŋuro ŋande yeteno, ‘Ko Awando uni ka kama rotoníqo, nono kama maheweya.’” ");
INSERT INTO nca_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yesuko mande ŋu yiní kini tiníqo, iŋo-iŋo rewero unipareyó qambu qundo roto toŋero eneya kaŋuya kama yateyaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ŋunde tiqo, Yesuko iŋo-iŋo rewero uni 12 ŋu ŋande osese yereró, “Yembeka ŋuya noroto toŋewero ŋuro iŋoteŋgope, ma kini?” ");
INSERT INTO nca_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Yiní Saimon-Pitako mande topé ŋande yaró, “Uni Parámi, nore danimo uyarewato? Ke mandekepo naŋge yoto-yoto suki-suki nore nunoyote. ");
INSERT INTO nca_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nore iŋondutuworo ŋande iŋoyoteto, ke Anutu koro Uni Meté Horé ŋu.” ");
INSERT INTO nca_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yiní mande topé ŋande yaró, “Neneŋombo iŋo-iŋo rewero uni 12 ye rokó yerenowó, hamómbe? Quko ye keweroyemo kako Monimbu ŋu!” ");
INSERT INTO nca_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ŋu uni ŋu, Jutas, Saimon Isikariot koro naŋuní, ŋuko iŋo-iŋo rewero uni 12 qu ka, quko imemoŋgo Yesu re uni piyimi kandeyemo rotaró. ");
INSERT INTO nca_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Asa tukú, Yesuko Galili mirako ŋuno uya maheyaró. Hamó, Judia mirako ŋuno owero piyimiŋaró, dokoro Juda koro uni pará-parámbo, uratoka khumoní, ye iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Juda koro o ne-ne naru owí muko Yamaru koro o ne-ne ŋu tunoqewero taró. ");
INSERT INTO nca_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ŋunde ŋuroko kone-topémbo ŋande miraŋgurí, “Yendé ŋa rotoya Judia mirako oya. Ŋunde tika iŋo-iŋo rewero unikepo o enesó-enesó teyote ŋu qenewaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Qeno, uni kato owé ka rewero iŋote ŋuko khoyó mondó ta kama teyote. Keto o enesó-enesó ŋu teyote, asa ko noko unipare soso keŋo witú yere qembe.” ");
INSERT INTO nca_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ŋunde yaŋgurí, dokoro kone-topémbo ŋuya ene kama iŋondutuwoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Asa Yesuko ŋande yimiraró, “Neneŋo naru meté qu ka kama mahete. Quko yeŋomboro naru soso ŋuko meté naŋge. ");
INSERT INTO nca_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Noko koro unipare qundo yeŋo kondé piyimi yerewero mepémo kini. Eneko neneŋo naŋge kondé piyimi nereyoteŋgo, dokoro nondo oteteye muko piyimi horé yesowoyoteno. ");
INSERT INTO nca_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ye o ne-neko ŋuno oyika. Neneŋo naru meté qu ka kama mahete, ŋunde ŋuro no o ne-ne ŋunoko kama owano.” ");
INSERT INTO nca_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ŋunde yero Galili ŋuno yoraró. ");
INSERT INTO nca_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kone-topémbo oyiqo, Yesu enepa tukú oró. Quko tunomo kama oró. Kini mondó ta naŋge oró. ");
INSERT INTO nca_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Asa o ne-neko ŋuno, Juda koro uni pará-parámbo ene seqaro ŋande yaŋgurí, “Uni ŋu dana yote?” ");
INSERT INTO nca_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ko unipare qambu ŋundo Yesu koro keweroyemo mande qambu mondó ta yaŋgurí. Kumimbo ŋande yaŋgurí, “Ŋuko uni meté.” Quko kumimbo ŋande yaŋgurí, “Kini, enendo unipare qambu kaná yereyote.” ");
INSERT INTO nca_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ŋunde yero tunomo kama yaŋgurí, dokoro Juda koro uni pará-parámboro ŋuro sasaro taŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Asa Yesu o ne-ne koro naru kewero quno Anutu koro Ya Surumí ŋuro hoŋgo quroko oro unipare iŋo-iŋo rondaqe yunaró. ");
INSERT INTO nca_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Juda koro uni pará-parámbo mandí ŋu iŋoro iŋondata parámi tero ŋande yaŋgurí, “Uni ŋundo papiya yano iŋo-iŋo ŋunde qu kama raró. Asa ko date tero iŋo-iŋoyó ŋundiro?” ");
INSERT INTO nca_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ŋunde yiqo, Yesuko mande topé ŋande yaró, “Mande ŋa rondaqe yunoteno ŋako neneŋo mu kini. Kini, ŋuko asá nereró ŋuro qu. ");
INSERT INTO nca_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ko uni ka Anutu hamó horé howewero ye iŋoyote ŋuko hamó qene iŋoro ŋande iŋoweya, ko mande yesowoteno ŋuko Anutu koro mande qupe ma neneŋombo naŋge yeyoteno. ");
INSERT INTO nca_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Uni kato eneŋo iŋo-iŋoyó moŋgo mande yeyote qu, ŋuko eneŋo owí hokowero ye iŋoyote. Quko uni kato uni asáŋaró ŋuro owí hokowero ye iŋote ŋuko mande hamó ŋuro uni, kota-kota uni kini. ");
INSERT INTO nca_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosesko hutuŋo mande ye yunaró, hamómbe? Ko ye keweroyemo qu kato hutuŋo mande ŋu kama howeyote. Asa do murí karo, nuroyi khumowano, ye iŋoteŋgo?” ");
INSERT INTO nca_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ŋunde yiní unipare qambu ŋundo mande topé ŋande yaŋgurí, “Yuqa piyimi ka peka keno yote. Ŋu dando ke kurowero, ye iŋote?” ");
INSERT INTO nca_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ŋunde yi ŋande yaró, “Komo no o kanata ka tanowó, ko ye soso qenero iŋondata parámi taŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Quko iŋi. Mosesko koweye toŋowero murí ŋu ye rondaqe yunaró, ko ye Sapat naruko ŋuno simóye koweye toŋoyoteŋgo. (Hamó, Moses eneŋombo murí ŋu kama riní tunoqaró. Ŋuko usisambato ri tunoqaró.) ");
INSERT INTO nca_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Yeko Moses koro hutuŋo mande ŋu howero Sapat naruko ŋuno unindoro kowí toŋoyoteŋgo. Asa ko nondo Sapat naruko ŋuno uni karo kowí soso rewe meté teyote tiníqo, ye do murí karo noya newonde saŋgirí teyoteŋgo? ");
INSERT INTO nca_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Toŋeyembo naŋge o ma qene rondaŋewero. O soso murí roneneŋowímo naŋge qene rondaŋeyuri qembe.” ");
INSERT INTO nca_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ŋunde yiníqo, unipare kumi Yerusalem noŋgo qundo ŋande yaŋgurí, “Uni ŋuko uni pará-parámbo, uratoka khumoní, ye iŋoyoteŋgo ŋuno qu, hamómbe? ");
INSERT INTO nca_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Qeni. Ene mande tunomo yeyote, quko oka kama te inoyoteŋgo. Uni pará-parámbo ŋande yero, uni ŋu Kristo ŋu naŋge, ye iŋoyoteŋgo, peka. ");
INSERT INTO nca_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Quko nore uni ŋaro yendé qu iŋoteto. Kristo ŋundo maheweya quno ŋuno do yendé ka noŋgo maheweya ŋuro uni kato kama iŋowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Asa Yesu Ya Surumímo kondé kiwero mande yesowo ŋande yimiraró, “Yendo no iŋoteŋgo, ko neneŋo yendé qu iŋoteŋgo. Nondo neneŋo iŋo-iŋone howero kama mahenowó. Quko no asá nereró ŋuro murí muko hamó, ko ye ene kama iŋo inoteŋgo. ");
INSERT INTO nca_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","No eneya yate, ko enendo asá niriní mahenowó. Ŋunde ŋuroko ene iŋo inoteno.” ");
INSERT INTO nca_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ŋunde yiní iŋoro kondé towo kusiyowero taŋgurí. Quko uni kato kandí eneno kama raró, dokoro eneŋo naruyó kama maheró. ");
INSERT INTO nca_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Unipare qambu qundo ene iŋondutuworo ŋande yaŋgurí, “Uni ŋando Kristo ŋunde qembe rokó-rokó parámi mu teyote.” ");
INSERT INTO nca_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Unipare qambu qundo Yesu ŋuro mande mondó ta ŋundiro yiqo, Farisi unindo iŋaŋgurí. Asa ko o qa-qa unindoro tapá unindoya Farisi unindoya sopo-sopo uniye kumi asá yiri Yesu towowero maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ŋunde ŋuroko Yesuko ŋande yaró, “Naru tukuni naŋge yeya yowano, yate no asá nereró ŋunoko owano. ");
INSERT INTO nca_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ŋu naruko ŋunoko ye no seqa nerewaŋgo, quko kama niyowaŋgo. Ko ye nondo mira yowano ŋuno owero mepémo kini.” ");
INSERT INTO nca_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ŋunde yiníqo, Juda koro uni pará-parámbo keweroyemo epe osese-osese ŋande taŋgurí, “Ene dano oní nore kama qenewato? Enembeka nore norotoro Grik koro mirayewore uyare noreŋo suwisawinanimboya Grik uniparetoya ŋuno yoteŋgo ŋu iŋo-iŋo rondaqe yunoweya, peka? ");
INSERT INTO nca_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ene ŋande yete, ‘Yeko no seqa nerewaŋgo, quko ye kama niyowaŋgo.’ Yero ko ŋande yete, ‘Yeko mira no ŋuno yowano ŋuno owero mepémo kini.’ Mande ŋu murí datiro?” ");
INSERT INTO nca_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Asa o ne-ne ŋuro naru weŋa parámi quno ŋuno Yesu kaŋero kondé kiwero ŋande yaró, “Ko uni ka sono koro khumoyote tiníqo, nono maheka sono niní. ");
INSERT INTO nca_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Sokomeko ŋuno ŋande yete, ko uni ka iŋondutu nereweya ŋuko, sono yoto-yotoyó moré mu eneŋo newondí moŋgo areweya.” ");
INSERT INTO nca_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesuko ŋunde yero Yuqa Surumí ŋuro yaró, asa Yuqa Surumí ŋuko unipare Yesu iŋondutuwoyaŋgurí qundo tukú rewaŋgo. Ŋu naruko ŋunoko Yesu owé parámi kama reyoní, ŋunde ŋuroko Yuqa Surumí kama umbuyoní. ");
INSERT INTO nca_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Asa kumimbo Yesu koro mande ŋu iŋoro ŋande yeyaŋgurí, “Hamó horé ŋuko ye-ye uni ŋuno qu.” ");
INSERT INTO nca_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ko kumimboko ŋande yeyaŋgurí, “Ŋuko Kristo ŋuno qu.” Quko kumimboko ŋande yeyaŋgurí, “Kini, Kristo ŋuko Galili mira koŋgo kama maheweya. ");
INSERT INTO nca_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Sokome ŋundo ŋande yete, Kristo ŋuko Dewit koro sowe qu ka, ko Dewit koro yendé ŋu, Betlehem, ŋuno tunoqeweya.” ");
INSERT INTO nca_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ŋunde ŋuro unipare qambu ŋundo Yesu koro iŋo-iŋoye enesó-enesó toworo usoworo wini irisa taŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Kumimbo Yesu kondé towo kusiyowero ye iŋaŋgurí, quko uni kato kandí re eneno kama raró. ");
INSERT INTO nca_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Asa ko sopo-sopo uni ŋundo rohoréŋo uyari o qa-qa unindoro tapá unindoya Farisi unindoya ŋande osese yereŋgurí, “Ye do karo uni ŋu kama re maheteŋgo?” ");
INSERT INTO nca_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ŋunde yi ŋande yaŋgurí, “Mande enendo yeyote ŋu, uni kato komo ŋunde kama yaró.” ");
INSERT INTO nca_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ŋunde yiqo, Farisi unindo mande topé ŋande yaŋgurí, “Ŋumbe ye ŋuya kaná yeretepe? ");
INSERT INTO nca_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Qeni, ko uni kembé kape ma Farisi uni qu kato uni ŋu qenero iŋondutuwoyoteŋgope ma kini? Kini horé. ");
INSERT INTO nca_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Unipare qambu qu hutuŋo mande kama iŋoyi tondaŋeyote ŋundo naŋge iŋondutuwoyoteŋgo. Ko Anutuko unipare ŋunde qu saŋayemo takuni raró.” ");
INSERT INTO nca_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Asa Nikodemus, uni kembé ŋu komo Yesuko uyaró ŋundo topé-topé ŋande yimiraró, ");
INSERT INTO nca_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Norendo uni o teyote ŋuro mandí iŋoroqota hutuŋo mandewore topé piyimi kama inoyoteto, hamómbe?” ");
INSERT INTO nca_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ŋunde yiní mandí topé ŋande miraŋgurí, “Ke ŋuya Galili noŋgo peka? Okeyá ta seqaroqota ŋande qene iŋoweya, ye-ye uni ka Galili noŋgo kama maheweya.” ");
INSERT INTO nca_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ko uni soso eneŋo yano oŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Quko Yesu mira purí Oliv ŋuno oró. ");
INSERT INTO nca_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Saraŋoní pitu ko Ya Surumí ŋuro hoŋgo quroko oró. Oní unipare soso eneno maheyaŋgurí. Ŋunde ti kunditero unipare mande rondaqe yunoyaró. ");
INSERT INTO nca_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Asa hutuŋo mande ŋuro iŋo-iŋo unindoya Farisi uni kumimboya se simbururu pare ka qenero re mahero tunomo roti kaŋaró. ");
INSERT INTO nca_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kaŋiní Yesu ŋande oseseyaŋgurí, “Rondaqe-rondaqe uni, pare ŋako se simbururu teyoní unipareto qeneŋgo. ");
INSERT INTO nca_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Hutuŋo mandeko Mosesko mande kondé ŋande yaró, ko nore wondo rero pare ŋunde quro saŋano raŋo urato khumoweya, yaró. Quko ketoko date yeweya?” ");
INSERT INTO nca_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Enendo Yesu towoŋowero ŋunde oseseyaŋgurí. Yesuko topé tero mande koroqe yiníkata re mande khono rotowato, yero iŋaŋgurí. Quko Yesu kondéqero kandímbo noko puŋomo nakayáŋaró. ");
INSERT INTO nca_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ŋunde tiní watí-watí oseseyiqo, kaŋero ŋande osese yereró, “Dani uni ka ye keweroye moŋgo quhurí ka kama taró, ŋundo meté wondo korete qu re pare ŋuro saŋano raŋoní.” ");
INSERT INTO nca_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yero pitu ko kondéqero noko puŋomo nakayáŋaró. ");
INSERT INTO nca_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ŋunde yiní iŋoro uni kanata-kanatako, asa koretero uni koŋgomu yate uni tukú ŋu soso roto toŋeŋgurí. Yate pare ŋu enemata yotoro ŋuno kaŋaró. ");
INSERT INTO nca_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kaŋiní Yesu otoqo kaŋero pare ŋande miraró, “Pare, uni ŋano qu dana uteŋgo? Uni kape ke topé piyimi ka kunoweyape ma kini?” ");
INSERT INTO nca_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Yiní pareto ŋande yaró, “Awa, kini,” yaró. Yiní ŋande yaró, “No ŋuya topé piyimi kama kunoteno. Ke meté toŋeya imemo kaŋuya quhurí ma tewero.” ");
INSERT INTO nca_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Asa Yesuko unipare pitu ko ŋande yimiraró, “Noko uniparetoro hiyó ŋuko no naŋge. Uni ka no nohoweweya ŋuko huriri qurowore khe kama uyoweya. Kini. Ŋuko yoto-yoto koro hiyóŋo moré.” ");
INSERT INTO nca_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Yiní Farisi unindo iŋoro ŋande miraŋgurí, “Keto keŋo yesowo yeyote. Ŋunde ŋuro mande yeyote ŋu hamó kini.” ");
INSERT INTO nca_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yi mande topé ŋande yimiraró, “Kini, nondo neneŋo yesowoyoteno quno ŋunoko mandene ŋu mande hamó naŋge. Dokoro no da noŋgo mahenowó quya dawore owano quya iŋoyoteno. Quko ye da noŋgo no mahenowó quya dawore owano quya kama iŋoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yeko koweye saŋaníwore uni yiyo ronda yereyoteŋgo. Nondo uni ka kama qene rondaŋeyoteno. ");
INSERT INTO nca_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Quko no uni ka qene rondaŋewano tiníqo, ronda-ronda mande yeteno ŋuko hamó naŋge. Dokoro, nondo naŋge kama rondaŋeyoteno. Kini. Awa asá nereró ŋuya noya ronda-ronda ŋunde teyotero. ");
INSERT INTO nca_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Yeŋo hutuŋo mandeko mande ŋande yote, asa uni irisako mande kanata yesowowari tiníqo, mandeyari ŋuko hamó. ");
INSERT INTO nca_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nondo neneŋo yesowo yeyoteno, ko Awando asá nereró ŋu ŋuya neneŋo yesowo yeyote.” ");
INSERT INTO nca_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ŋunde yiníqo, Farisi unindo ŋande oseseyaŋgurí, “Awaŋge da?” Yiní Yesuko mande topé ŋande yaró, “Ye no kama iŋo nunoyoteŋgo, ko Awane ŋuya kama iŋo inoyoteŋgo. Ko ye no iŋo nunoyaŋgo tiníqo, Awane ŋuya iŋo inoyaŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesuko Ya Surumímboro yendémo ŋuno mone kopowero quro wembómo ŋuno kaŋero unipare iŋo-iŋo rondaqe yunaró. Ŋu naruko ŋuno mande yaró, quko uni kato kama kondé towo kusiyaró, dokoro, eneŋo naruyó kama maheró. ");
INSERT INTO nca_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Asa Yesuko unipare kaŋuya ŋande yimiraró, “No roto toŋeweqo, ye seqa nerewaŋgo. Ko quhuríye muko yoní ye khumowaŋgo. No dano toŋewe teteno ye ŋuno toŋewero mepémo kini.” ");
INSERT INTO nca_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yiní Juda koro uni pará-parámbo iŋoro ŋande epe mito-mito taŋgurí, “Do karo ŋande yete, ‘No dano toŋewe teteno ye ŋuno toŋewero mepémo kini,’ yete? Ŋumbeka eneŋombo eneŋo kowí uto khumowero yete?” ");
INSERT INTO nca_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yi Yesuko ŋande yimiraró, “Yeko ame noŋgo qu; no kore koŋgo qu. Yeko noko ŋaro qu; noko noko ŋaro qu kini. ");
INSERT INTO nca_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ŋunde ŋuro no ŋunde yimiroteno, quhuríye muko yoní ye khumowaŋgo. Dokoro yendo, ŋuko no naŋge, ŋuro iŋondutu kama tewaŋgo tiníqo, quhuríye kate-kate muko yoní ye khumowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ko ŋande oseseyaŋgurí, “Ke dani ka?” Yi Yesuko ŋande yimiraró, “Hurímo ŋuno no dani ye yimiranowó. ");
INSERT INTO nca_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","No yeŋo muríyemboro yero ye ronda yerewano quro mande qambu ŋana. Quko no asá nereró ŋuro murí muko hamó naŋge. Ko mande soso no iŋanowó ŋuko, nondo yesoworo nokono unipare yimiroteno.” ");
INSERT INTO nca_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yiní iŋaŋgurí, quko Yesuko Awandoro yimiraró ŋu kama iŋoyi tondaŋaró. ");
INSERT INTO nca_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ŋunde ŋuro Yesuko ŋande yimiraró, “Yendo Unindoro Naŋuní ŋu hokowaŋgo quno ŋunoko ŋande iŋoyi tondaŋeweya, asa ŋuko no naŋge, ko neneŋombo neneŋo oka kama teyoteno. Kini, Awando mande rondaqe nunaró ŋu naŋge yesowo yeyoteno. ");
INSERT INTO nca_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","No asá nereró ŋuko noya yote. Enendo norotoní nenemata kama yoteno. Kini. Ko naru rokóŋoro eneŋo iŋo-iŋoyó ŋu teyoteno.” ");
INSERT INTO nca_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ŋunde yiníqo, unipare qambu qundo iŋoro iŋondutuwoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Asa Yesuko Juda unindo eneŋo iŋondutuwoyaŋgurí mu ŋande yimiraró, “Ye mandene towowaŋgo tiníqo, ye neneŋo iŋo-iŋo rewero unine hamó yotoro ");
INSERT INTO nca_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","mande hamó ŋu iŋoyowaŋgo. Ko mande hamó ŋundo yeŋo kusi-kusiye ŋu orosoyiní kina yowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Yiní mande topé ŋande yaŋgurí, “Noreko Abraham koro sowe qu. Naru kano uni kato nore kusi niriní eneŋo kho simóŋo kama tatowó. Ke date koro, yeŋo kusi-kusiye orosoyiní kina yowaŋgo, yete?” ");
INSERT INTO nca_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesuko mande topé ŋande yimiraró, “No hamó horé ye yimiroteno, uni quhurí teyoteŋgo ŋuko quhuríyómboro kho simó yoteŋgo. ");
INSERT INTO nca_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kho simó kako eneŋo sopo-sopoyómboro suwisawi qu kini, eneya suki-suki kama yoweya. Quko naŋo-simó kako iwímboro suwisawi horé qu ka, eneya suki-suki yoweya. ");
INSERT INTO nca_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ŋunde ŋuroko Naŋuní ŋundo kusi-kusiye orosoyiní kina yowaŋgo tiníqo, kusi-kusiye hamó kini taró. ");
INSERT INTO nca_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","No iŋoteno, yeko Abraham koro sowe qu. Quko neneŋo mandene muko ye quroyemo ŋuna kama yote. Ŋuroko ye no uratoka khumoní yeyoteŋgo ŋu. ");
INSERT INTO nca_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Noko Awanembo o witú nereró ŋuro mande yesowo yeyoteno. Ko ye ŋuya awayemboro murí iŋoro howeyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ŋunde yiníqo, mande topé ŋande yaŋgurí, “Noreŋo awanani muko Abraham.” Ko Yesuko ŋande yimiraró, “Yeko Abraham koro simó hamó tiníqo, ye Abrahamko murí teyaró ŋunde naŋge teyowaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nondo komo Anutu koro mande hamó mu iŋanowó ŋu soso yeno yesowanowó. Ko yendo no nuri khumowano yeteŋgo. Abrahamko o ŋunde qu kama taró. ");
INSERT INTO nca_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kini, yendo awaye hamómboro murí qu naŋge teyoteŋgo.” Yiní ŋande miraŋgurí, “Ná-námani muko khe pare tero o piyimi teyate kama pisi nereŋgurí. Kini. Noreko Awanani kanata naŋge, ŋuko Anutu.” ");
INSERT INTO nca_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ko Yesuko ŋande yimiraró, “Asa Anutuko yeŋo Awaye hamó tiníqo, newonde meté no nunowaŋgo, dokoro, no Anutu rotoro ŋano mahenowó. No neneŋombo ŋano kama mahenowó. Kini. Asá nereró quro iŋo-iŋoyómboro ŋano mahenowó. ");
INSERT INTO nca_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Quko ye do murí karo mandene ŋa kama iŋi tondaŋeyote? Murí muko ŋandiro, ye kusumboye rero neneŋo mandene iŋowero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Yeko awa karo naŋo-simó, ŋuko Monimbu. Ko ye awayemboro iŋo-iŋoyó howewero quro niŋgu-niŋgu teyoteŋgo. Komo suki ŋuya itaka ŋuya ene uni yuroní khumowero uni yara qu. Ko murí hamó mu kama howeyara, dokoro, murí hamó ŋuko eneno kama yora. Mande kota ŋu yeyara, ŋuko eneŋo mandí horé. Eneko kota mande yewero uni qu ka ko mande kota ŋuro simburí. ");
INSERT INTO nca_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Quko nondo mande hamó mu yeyoteno, ŋunde ŋuro ye kama iŋondutu nereyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ye dani kato no quhurí ka tanowó ŋuro tunomo meté yeweya? Ko no mande hamó ŋu yesowo yeyoteno tiníqo, ye do murí karo kama iŋondutu nereyoteŋgo? ");
INSERT INTO nca_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Anutu koro simó ŋuko Anutu koro mandí iŋoyoteŋgo. Ŋunde ŋuroko ye ene mandí kama iŋoyoteŋgo, dokoro yeko Anutu koro simó kini.” ");
INSERT INTO nca_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Asa Juda koro uni pará-parámbo mande topé ŋande yaŋgurí, “Nore ŋande yeteto, ko keko Samaria uni qu ka, ko yuqa piyimi ka ke quroko yote. Mande ŋuko hamómbe ma kini?” ");
INSERT INTO nca_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ŋunde yi ŋande yaró, “Yuqa piyimi kato no quroko kama yote. Quko no Awane ará te inoyoteno, ko yendo owéne ri umbute. ");
INSERT INTO nca_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Noko neneŋo owéne hokowero quro khe kama seqateno. Khe ŋu seqaro qene rondaŋeyote qu ka yote. ");
INSERT INTO nca_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Hamó horé no ye yimiroteno, ko uni kato neneŋo mandene howeweya tiníqo, ene naru suki-suki kama khumoweya.” ");
INSERT INTO nca_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yiní Juda unindo ŋande miraŋgurí, “Itakako nore hamó iŋoteto, yuqa piyimi qu ke quroko yote. Abrahamko komo khumaró, ko ye-ye uni ŋuya komo khumaŋgurí. Quko ke ŋande yete, ‘Uni ka no mandene howeweya tiníqo, ene naru suki-suki kama khumoweya.’ ");
INSERT INTO nca_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Date koro? Ke peka nore usinani Abraham takate? Ŋuko komo khumaró. Ko ye-ye uni ŋuya komo khumaŋgurí. Ke dani ka yero iŋote?” ");
INSERT INTO nca_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesuko mande topé ŋande yaró, “Ko no neneŋo owéne hokoyowano tiníqo, seréne muko hamó kini. Quko neneŋo Awanemboko owéne hokoyote. Ko ye ŋande yeyoteŋgo, Awane ŋuko yeŋo Anutuye, yeyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Hamó, ye kama iŋo inoyoteŋgo, quko nondo ene iŋo inoyoteno. Qeni, ‘No ene kama iŋo inoyoteno,’ ŋunde yewano tiníqo, nondo ye qembe kota-kota uni tunoqewano. Quko no ene komo iŋoro eneŋo mandí meté howeyoteno. ");
INSERT INTO nca_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Komo Abraham, pukoye ŋundo neneŋo narune qenewero ŋuro niŋgu-niŋgu taró. Ko ene qeneró quno, asa newonde meté hamó taró.” ");
INSERT INTO nca_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ŋunde yiní ŋande miraŋgurí, “Keko kumima naruke 50 ŋunde kama rotaró, ko kepe Abraham qenerómbe, hamómbe?” ");
INSERT INTO nca_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ko Yesuko ene ŋande yimiraró, “No hamó horé ye yimiroteno, komo Abraham kama tunoqeyoní, no neneŋombo yorano.” ");
INSERT INTO nca_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ŋunde yiníqo, urowero wondo siyaŋgurí. Quko Yesu mondó ta sóqero Ya Surumímboro hoŋgo ŋu rotoro yendésina uró. ");
INSERT INTO nca_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu khe uyate, uni ka qeneró. Uni ŋu nimímbo pisiyoníqo, toŋí pokaró. ");
INSERT INTO nca_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Asa iŋo-iŋo rewero uniyómbo Yesu ŋande oseseyaŋgurí, “Rapi, danimbo o piyimi tiníkata uni ŋu nimímbo pisiyoní toŋí pokaró? Uni ŋu eneŋombope o piyimi tarómbe ma iwí-nimímbo quhurí tariyó?” ");
INSERT INTO nca_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yi mande topé ŋande yaró, “Uni ŋu eneŋombo o piyimi kama taró, ko iwí-nimímbo ŋuya quhurí kama tariyó. Kini, Anutu koro kho qu tunomo tunoqewero quro o ŋu eneŋo kowímo ŋunde tunoqaró. ");
INSERT INTO nca_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Hiyómbo hiyóqeyoníqo, norendo no asá nereró quro kho qu tato. Imemo huriri tunoqiní uni kho tewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","No nokono ŋano yoroteno qunoko, nondo noko ŋaro hiyó ŋano qu.” ");
INSERT INTO nca_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ŋunde yero nokono tute taró. Tero tute ŋu noko koya rohoréŋoro nukuru se uni ŋuro toŋímo raró. ");
INSERT INTO nca_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ŋunde tero ŋande miraró, “Ke uya Siloam Sono Towo ŋuno sono kimu.” (Owé ŋu “Siloam” murí muko ŋandiro, “Asáŋowí.”) Asa uni toŋí pokawí ŋu uyaro ŋuno sono kimuró. Kimuro pitu mahero meté toŋetaró. ");
INSERT INTO nca_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Asa ko topémboya unindo ene mone koro kira yiriní qeneyaŋgo quyako ŋande yaŋgurí, “Ŋu date koro? Ŋambeka uni ka komo kunditero mone koro uni kira yereyara ŋuno qu naŋge, hamómbe?” ");
INSERT INTO nca_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ŋunde yi kumimbo ŋande yeyaŋgurí, “Iyo, ŋuko uni ŋu,” yaŋgurí. Ko kumimboko ŋande yeyaŋgurí, “Kini, ŋuko kira yereyara uni ŋu qembe naŋge.” Ko uni ŋu eneŋomboko ŋande yimitoyaró, “Ŋuko no naŋge,” yaró. ");
INSERT INTO nca_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ŋunde yiní ŋande oseseyaŋgurí, “Ko ke date tero toŋeŋge meté tete?” ");
INSERT INTO nca_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yiqo, mande topé ŋande yaró, “Uni ka owí muko Yesu, ŋundo nukuru toŋenemo rero ko ŋande nimiraró, ‘Ke uyareya Siloam ŋuno sono kimu,’ yaró. Yiní no uyaro sono kimuwe toŋene meté tiní meté toŋeteteno.” ");
INSERT INTO nca_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Yiní ŋande oseseyaŋgurí, “Uni ŋu dana yote?” Ko ŋande yaró, “No kama iŋoteno,” yaró. ");
INSERT INTO nca_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Asa unipareto uni toŋí pokawí meté taró ŋu re Farisi uniko uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Sapat naruko ŋuno naŋge Yesuko nukuru toworo unindoro toŋí riní meté taró. ");
INSERT INTO nca_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Asa ko Farisi unindoko uni ŋu ŋande oseseyaŋgurí, “Toŋeŋge ŋuko date tero meté ta?” Yi ŋande yimiraró, “Enendo nukuru re toŋenemo riní no uyare sono kimuro meté toŋeteteno.” ");
INSERT INTO nca_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Yiní Farisi kumimboko ŋande yaŋgurí, “Nore iŋoteto, uni ŋu Anutu koro kho qu kama teyote, dokoro, eneko Sapat naru koro hutuŋo mande ŋu kama howeyote.” Quko kumimbo ŋande yaŋgurí, “Ŋu date tero quhurí uni kato meté rokó ŋunde qu teweya?” Ŋunde yero usoworo huru-huru irisa taŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Asa uni toŋí pokawí ŋuno qu pitu ko ŋande oseseyaŋgurí, “Uni ŋundo keŋo toŋeŋge riní meté tete. Asa keto ene datiro, ye iŋote?” Yiqo, mande topé ŋande yaró, “Ŋuko ye-ye uni ka,” yaró. ");
INSERT INTO nca_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Asa Juda koro uni pará-parámbo, eneŋo toŋí kama hiyóqaró, do karo komo hamó kama pokaró, ŋunde ye iŋoyate iwí-nimí neko yereŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Neko yiri mahiri ŋande osese yereŋgurí, “Ŋambeka yariŋo naŋoyari? Yari pisiyiri toŋí pokawí tarómbe ma kini? Ko ŋunde taró tiníqo, date tero itaka toŋetete?” ");
INSERT INTO nca_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ŋunde yiqo, iwí-nimímbo mandeye topé ŋande yariyó, “Nore iŋotero, ŋako nore naŋonari. Pisiyoweqo, toŋí pokawí taró, ŋu ŋuya nore iŋotero. ");
INSERT INTO nca_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Quko date teroqo itaka toŋetete, ko dando toŋí riní meté ta, ŋuko nore kama iŋotero. Ye oseseyikata. Ene komo parámi taró, eneŋombo eneŋo yeweya.” ");
INSERT INTO nca_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Komo Juda koro uni pará-parámbo, nore dani kato Yesu ŋuko Kristo ŋu yeweya qu huru-huru ya noŋgo yohowewato, yaŋgurí. Ŋunde ŋuroko eneŋo iwí-nimí muko ŋuro sorariyó. ");
INSERT INTO nca_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Sorero iwí-nimímbo mande ŋande yariyó, ye oseseyikata. Ene komo parámi taró, yariyó. ");
INSERT INTO nca_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Asa ko uni komo toŋí pokaró ŋu pitu ko nekoro ŋande miraŋgurí, “Ke Anutu seré te ino. Nore iŋoteto, ŋu uni ŋuko quhurí uni.” ");
INSERT INTO nca_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yi mande topé ŋande yaró, “Ŋumbe quhuríŋo morémbe ma kini, indika, kama iŋoteno. O kanata naŋge no iŋoteno, no komo toŋene pokawí yano qu, ko itaka ŋanoko toŋeteyoteno.” ");
INSERT INTO nca_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Yiní ŋande oseseyaŋgurí, “Date te kunote? Dando te kunoníqo toŋeŋge hiyóqete?” ");
INSERT INTO nca_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Yi mandeye topé ŋande yaró, “No komo yimirano, quko ye kusumboye kama reteŋgo. Do murí karo pitu ko iŋowero ye osese nereteŋgo? Yembeka eneŋo iŋo-iŋo rewero uniyó tato, yero iŋoteŋgo, peka?” ");
INSERT INTO nca_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ŋunde yiní huwó mande qambu mitoro ŋande yaŋgurí, “Keto naŋge eneŋo iŋo-iŋo rewero uniyó. Quko noreko Moses koro iŋo-iŋo rewero uniyó qu. ");
INSERT INTO nca_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nore iŋoteto, komo Anutuko Moses koya mande yaró. Quko uni ŋuno qu, nore da noŋgo maheró ŋu kama iŋoteto.” ");
INSERT INTO nca_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Yiqo, uni ŋundo mandeye topé ŋande yimiraró, “Asa mandeye muko newondene uroní iŋondataqeyoteno! Uni ŋundo no toŋene riní hiyóqete, quko ye uni ŋu da noŋgo maheró ŋu kama iŋoteŋgo. ");
INSERT INTO nca_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nore iŋoteto, Anutuko quhurí uni karo mandí kama iŋote. Kini, uni ka Anutu koro mandí howero iŋo-iŋoyó iŋoyote ŋuko, asa Anutuko ŋunde quro mandí iŋoyote. ");
INSERT INTO nca_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Naru kanoko sowo mande ŋande qu kama iŋatowó, asa uni kato uni ka nimímbo pisiyoníqo, toŋí pokaró qu ka riní toŋí hiyóqaró. ");
INSERT INTO nca_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ko Anutuko uni ŋu riní kama maheró tiníqo, asa eneko o ka tewero mepémo kini.” ");
INSERT INTO nca_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ŋunde yiní mande topé ŋande yaŋgurí, “Ŋu date tero? Naru náŋgepo pisi kereró ŋu noŋgo yate itaka arete ke quhurí ŋuro murí naŋge iŋote. Quko ketope nore iŋo-iŋo rondaqe nunowero?” Ŋunde yero howi toŋeró. ");
INSERT INTO nca_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Asa Yesuko uni ŋu howaŋgurí ŋuro iŋoro seqaró. Seqa qenero ŋande miraró, “Ke Unindoro Naŋuní ŋu iŋondutuwoyotepe ma kini?” ");
INSERT INTO nca_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Yiní mande topé ŋande yaró, “Awa, Unindoro Naŋuní ŋu dani? Ke no nimitoka no ŋuya iŋondutuwowe.” ");
INSERT INTO nca_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ko Yesuko ŋande miraró, “Keto ene qenete. Ŋuko uni itakako keya mande yetiri ŋu naŋge.” ");
INSERT INTO nca_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Yiní ŋande yaró, “Uni Parámi, no iŋondutu teteno.” Ŋunde yero Yesu potoruku te inaró. ");
INSERT INTO nca_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ko Yesuko ŋande yaró, “No nokono ŋano umbunowó ŋuko uniparetoro muríye rondaŋewero umbunowó. Ŋunde tero uni toŋeye pokawí qundo toŋetewaŋgo, ko uni toŋeteyoteŋgo ŋuko toŋeye pokawí tunoqeweya.” ");
INSERT INTO nca_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Asa Farisi kumi Yesu taŋgímo yaŋgo qundo mande ŋu iŋaŋgurí. Ŋunde ŋuro ŋande oseseyaŋgurí, “Kepe noreko toŋenani pokawí, ŋundirope yetepe ma kini?” ");
INSERT INTO nca_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yi ŋande yimiraró, “Ko ye toŋeye pokawí tiníqo, asa ye quhuríye moré kini. Quko itaka ye ŋande yeteŋgo, ‘Toŋenani muko toŋeteyote,’ yeteŋgo. Ŋunde ŋuroko quhuríye yote ŋu. ");
INSERT INTO nca_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“No hamó horé ye yimiroteno, uni ka sipsip koro hoŋgo makowore kama oro hoŋgo karóŋoro quroko oyote, ŋuko momo uni ko kuma tewero uni. ");
INSERT INTO nca_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Quko uni makowore oyote ŋuko sipsip koro sopo-sopo ŋu. ");
INSERT INTO nca_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kho uni ŋundo sopo-sopo ŋuro mako kosoní sipsipyó enemo-enemo owéye nekoní maŋgó iŋoyi yore mirako uyote. ");
INSERT INTO nca_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yorero korete uro mirako uyote. Ko sipsip ŋuko maŋgó iŋoro howero uyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Sipsip ŋundo uni meyowo ka kama howeyoteŋgo. Kini. Uni meyowo kato neko yiriníqo, sorewaŋgo, dokoro, uni meyowomboro maŋgó kama iŋo inoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesuko tapara mande ŋu re yunaró, quko mandí ŋuro murí kama iŋi tondaŋaró. ");
INSERT INTO nca_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ŋunde ŋuroko Yesuko mande kaŋuya ŋande yaró, “No hamó horé ye yimiroteno, sipsip koro mako ŋuko no naŋge. ");
INSERT INTO nca_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Uni soso qundo no taka nerero komo maheŋgurí ŋuko momo uni ko kuma tewero uni. Quko sipsip ŋundo maŋgoye kama iŋoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mako ŋuko no naŋge. Ko uni ka nowore mahero hoŋgo quroko oweya ŋu, asa Anutuko rambaruru koŋgo riní ene kina umbu oro o qímboro seqaro qeneweya. ");
INSERT INTO nca_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Momo unindo momo tewero quya sipsip yurowero quya o soso rambaruruwowero quro naŋge maheyote. Quko nondo yoto-yoto meté yunowero mahenowó. Ŋunde yunowe meté horé yowaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Sipsip koro sopo-sopo meté ŋuko no naŋge. Sipsip koro sopo-sopo meté ŋuko sipsip kawaware yerewero quro eneŋombo yoto-yotoyó rotoweya. ");
INSERT INTO nca_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Uni kumimbo kimoye rero sipsip sopo yereyoteŋgo. Ŋundo sipsip koro simburí ŋunde kini. Á sawako mahiníqota qenero sipsip yorotoro sorero toŋi á sawa ŋundo mahero sipsip ŋu yiki yohowiní wisikaraŋowaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Uni ŋunde qundo kimoye naŋge reyoteŋgo ko sipsip ŋuro hamó kama iŋo yunoyoteŋgo. Ŋunde ŋuroko sorero toŋewaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Sipsip koro sopo-sopo meté ŋuko no naŋge. Nondo neneŋo sipsipne iŋo yunoteno, ko sipsipnembo no iŋo nunoteŋgo, ");
INSERT INTO nca_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","asa Awando no iŋo nunote ko nondo Awa iŋo inoteno ŋunde naŋge. Ko nondo imemo sipsip kawaware yerewero quro neneŋo yoto-yotone rotowano. ");
INSERT INTO nca_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Noko sipsipne meyowo ŋuya ŋuna, ko ŋuko hoŋgo ŋaro qu kini. Ŋuroko no sipsip ŋu ŋuya yore mahewano. Ŋunde tewe maŋgone iŋoro sipsip koro huru-huru kanata naŋge tewaŋgo, ko sipsip koro sopo-sopo kanata naŋge yoweya. ");
INSERT INTO nca_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Awando newonde meté nunoyote, dokoro, nondo imemo yoto-yotone rotowano. Ŋunde rotoro yoto-yotone pitu ko rewano. ");
INSERT INTO nca_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Uni kato eneŋombo neneŋo yoto-yotone riní kama kini teweya. Kini. Neneŋombo naŋge yoto-yotone ŋu rotowano. Awando mande kondé ka nimitoro owé ka nunaró. Asa ko neneŋombo rotowano, ko pitu ko rewano.” ");
INSERT INTO nca_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Asa Juda koro uni pará-parámbo mande ŋu iŋoro usoworo huru-huru irisa taŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Uni qambu qundo ŋande yeyaŋgurí, “Yuqa piyimi mu eneno yoní kape-kape mande yeyote. Do karo kusumboye reyoteŋgo?” ");
INSERT INTO nca_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ko kumimbo ŋande yeyaŋgurí, “Mande yete ŋuko uni ka yuqa piyimi quroyómo yote quro mandí kini. Yuqa piyimi kato uni toŋeye pokawí mu yoriní hiyóqewero mepémo kini.” ");
INSERT INTO nca_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Imemoŋgo Yerusalem ŋuno Ya Surumí Sara Tunoqaró ŋuro o ne-ne ŋu tunoqaró. Naru ŋuko naru kiŋo naŋge, ");
INSERT INTO nca_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ko Yesu Ya Surumímboro yendémo, yokone ka owí muko Solomon koro Yokonemo ŋuno uya mahe teyaró. ");
INSERT INTO nca_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Juda koro uni pará-parámbo mahe wuririyoro ŋande oseseyaŋgurí, “Do naruko horé ke muríŋge nore nimiroweya? Ke Kristo ŋu tiníqo, tunomo nimito qembe.” ");
INSERT INTO nca_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesuko mande topé ŋande yaró, “No komo ye yimiranowó, quko iŋondutu kama taŋgurí. Nondo Awane owímo kho teyoteno ŋuko neneŋo muríne witú yereyote ŋu. ");
INSERT INTO nca_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Quko yeko neneŋo sipsip qu kini. Ŋunde ŋuroko ye no iŋondutu kama teyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Neneŋo sipsip qu no maŋgone iŋoyoteŋgo. No iŋo yunowe nohoweyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yoto-yoto suki-suki yunoweqo kama piyo tewaŋgo. Kini horé. Uni kato kandene moŋgo ta nerewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Awanembo yorero no nunaró ŋundo o soso taka yerero koreko tete. Ŋunde ŋuroko uni kato Awanemboro kandí moŋgo taŋowero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","No Awandoya kanata naŋge yotero.” ");
INSERT INTO nca_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ŋunde yiníqo, Juda unindo pitu ko Yesu urowero wondo siyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ko Yesuko ŋande yimiraró, “Nondo Awandoro kho qambu meté mu witú yereyoteno. Ye kho ŋa date koro ŋuro tero wondopo nurowero teteŋgo?” ");
INSERT INTO nca_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yiní ŋande yaŋgurí, “Noreko kho ka meté quro wondopo kurowero kama teteto. Kini, keto Anutu yesaráŋoyote ŋuro norendo wondopo kurowero teteto. Keko uni kina qu, quko ke ŋande yete, keŋombo naŋge Anutu, yete.” ");
INSERT INTO nca_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yi ŋande yimiraró, “Qeni, hutuŋo mandeko ŋuno Anutuko ŋande yaró, ‘No ŋande yeteno, “Ye soso anutu-anutu yoteŋgo,”’ ŋunde yaró, hamómbe? ");
INSERT INTO nca_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Komo Anutuko uni eneŋo mandí iŋaŋgurí ŋu ŋunde yimiraró, ko mande sokomeko yote ŋuko hamó naŋge. ");
INSERT INTO nca_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ko Awa eneŋombo no rokó nerero asá niriní nokono ŋano umbunowó. Quko no ŋande yeteno, ‘No Anutu koro Naŋuní,’ yeteno qunoko, yendo ŋande yeteŋgo, ‘Ke Anutu yesaráŋoyote,’ yeyoteŋgo. Asa ŋu date tero? ");
INSERT INTO nca_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Qeni, no Awanemboro kho qu kama teyoteno tiníqo, mandene ma iŋondutuwowero. ");
INSERT INTO nca_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Quko ye ŋunde kama iŋondutu nerewaŋgo tiníqo, kho teyoteno ŋu qeneroqota iŋondutu ti qembe. Ŋunde tero ye meté qenero ŋande iŋoyi tondaŋeweya, ko Awando neneŋo quronemo yoní, ko no Awa quroyómo yoteno ŋu.” ");
INSERT INTO nca_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ŋunde yiníqo, naru kaŋuya kondé towo kusiyato, ye iŋaŋgurí, quko taka yere toŋeró. ");
INSERT INTO nca_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Toŋero Jotan Sono karóŋoro mira Jonko komo uni sono re yunoyara quno ŋuno uyaró. Uyaro mirako ŋuno yora. ");
INSERT INTO nca_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Yoní unipare qambu eneno maheyaŋgo. Mahe ŋande yeyaŋgo, “Hamó, Jonko rokó ka kama taró. Quko Jonko mande soso Yesu koro yeyaró ŋuko hamó naŋge.” ");
INSERT INTO nca_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Asa ŋu mirako ŋuno uni qambu Yesu iŋondutuwoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ŋu naru kano uni ka, owí muko Lasarus, se khumo taró. Lasarus ŋuko Betani yendé moŋgo qu, ko Betani ŋuko yerekuwosa Maria, Mata koro yendé ŋu. ");
INSERT INTO nca_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Lasarusko pare irisa ŋuro kumoyari, ko Maria ŋundo komo sono kiruwó ka Uni Parámi khímo hausuworo huímbo sonowoní hararó ŋu. ");
INSERT INTO nca_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Asa yerekuwosa ŋundo mande ka riri Yesuko uyaró, “Uni Parámi, keŋo topoke ŋano qu se khumo tete.” ");
INSERT INTO nca_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesuko mande ŋu iŋoro ŋande yaró, “Se khumo tete ŋuko riní khumowero qu kini. Kini, ŋuko unipareto Anutu koro sine parámi qenewero se khumo qu. Ŋuro tero khe ŋuwore Anutu koro Naŋuní ŋuya owé parámi reweya.” ");
INSERT INTO nca_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesuko Mata, Maria, Lasarus newonde meté yunaró. ");
INSERT INTO nca_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ŋunde ŋuro Lasarus se khumo tete ŋu yi mira kano ŋuno iŋoro naru irisa ŋuya rotoro mira ŋuno yora. ");
INSERT INTO nca_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ko imemoŋgo iŋo-iŋo rewero uniyó ŋande yimiraró, “Judia mirako ŋuno oyato,” yaró. ");
INSERT INTO nca_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Yiní ŋande miraŋgurí, “Rapi, naru kano Juda koro uni pará-parámbo wondopo kuri khumowero taŋgurí. Ŋumbe kama iŋoro kepe ko Judia mirako uyarewero yete?” ");
INSERT INTO nca_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yi mandeye topé ŋande yimiraró, “Qeni, kosa kanata qunoko naru koro wembó 12 yote, hamómbe? Uni kato kosano khe uyote ŋuko kama rokaráŋoyote, dokoro, noko koro hiyó qeneyote. ");
INSERT INTO nca_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Quko uni ka suwono khe uyote ŋuko rokaráŋoyote, dokoro, eneko toŋete mira qenewero ŋuro suruyó moré kini.” ");
INSERT INTO nca_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesuko ŋunde yeroqo ŋande yimiraró, “Toponani Lasarus ŋuko etete, quko nondo uyare okokowano.” ");
INSERT INTO nca_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yiníqo, iŋo-iŋo rewero uniyómbo ŋande yaŋgurí, “Uni Parámi, ko ene etete tiníqo, se khumoyó kini tiní meté teweya.” ");
INSERT INTO nca_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesuko Lasarus khumaró ŋuro yaró, quko iŋo-iŋo rewero uniyó ŋande ye iŋaŋgurí, ko enendo Lasarus kina eteyote ŋuro yaró. ");
INSERT INTO nca_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Asa ko Yesuko tunomo ŋande ye yimiraró, “Lasarus khumaró. ");
INSERT INTO nca_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ko no taŋgímo kama yanowó ŋuro niŋgu-niŋgu teteno. Dokoro, ŋundoko ye yoriní iŋondutu tewaŋgo. Asa uyare qeneto.” ");
INSERT INTO nca_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ŋunde yiníqo, Tomas owí ka Ditimus ŋundo otoqo iŋo-iŋo rewero uni kumi ŋande yimiraró, “Uyareka nore ŋuya eneya khumato,” yaró. ");
INSERT INTO nca_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Asa Yesuko Betani yendémo ŋuno uyariní ŋande miraŋgurí, ko Lasarus khumaró ŋu noŋgo yate kosa naru nimí kini ŋunde rotoro uni tapuyómo yora. ");
INSERT INTO nca_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani ŋuko Yerusalem sumeyoro ŋuno yora, asa khe piruyó muko kilomita kapusa ŋundiro naŋge. ");
INSERT INTO nca_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ŋunde ŋuroko Juda unipare qambu mahero Mata koya Maria koya yiyoro kumoyari khumaró ŋuro yemama mande yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Asa Matako Yesu mahete yi iŋoro uro Yesu kheko wisumuŋo qeneró, quko Maria yano kunditaró. ");
INSERT INTO nca_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Uro Matako Yesu ŋande miraró, “Uni Parámi, ke ŋano yara tiníqo, kumone kama khumowero qu. ");
INSERT INTO nca_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Quko itakako no ŋande iŋoteno, ko ke oka karo Anutu kirayoweya tiníqo, o ŋu te kunoweya.” ");
INSERT INTO nca_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ŋunde yiní ŋande miraró, “Kumoŋge muko pitu ko otoqoweya.” ");
INSERT INTO nca_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ko Matako ŋande miraró, “No iŋoteno, naru weŋako ŋuno unipare khumaŋgurí qundo pitu ko otoqowaŋgo quno ŋuno enendo pitu ko otoqoweya.” ");
INSERT INTO nca_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ŋunde yiní Yesuko ŋande miraró, “Pitu ko otoqowaŋgo ŋuro wimbu ŋuya yoto-yoto ŋuya ŋuko no naŋge. Asa ko uni ka no iŋondutu nereyote ŋuko khumoweya quko yoto-yotoyó keta reweya. ");
INSERT INTO nca_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ko uni soso toŋe keta yotoro no iŋondutu nereyoteŋgo ŋuko kama khumowaŋgo. Kepe ŋumbe iŋondutuwoyotepe ma kini?” ");
INSERT INTO nca_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Yiní ŋande yaró, “Iyo, Uni Parámi. No iŋondutu ŋandiro teteno, ko keko Kristo ŋu, Anutu koro Naŋuní ŋundo nokono umbuweya ŋu.” ");
INSERT INTO nca_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ŋunde yero roto uyaro kuwí Maria mondó ta ŋande miraró, “Rondaqe-rondaqe Uni ŋundo mahero neko kerete.” ");
INSERT INTO nca_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ŋunde yiní waka ta otoqoro, Yesu qenewe, yero uró. ");
INSERT INTO nca_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu yendémo kama oró. Ene komo Matako kheko wisumuŋaró ŋuno naŋge yora. ");
INSERT INTO nca_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Maria otoqoro ya rotoní Juda uni eneya yano yotoro sikí ka yaŋgurí qundo qenero howe uŋgurí, dokoro, eneko uyare uni tapuko tendowero uyate, peka, ye iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Asa Mariako Yesuko ŋuno uyaro qenero khímo rokaraŋo umburo ŋande miraró, “Uni Parámi, ke ŋano yara tiníqo, kumone kama khumowero qu.” ");
INSERT INTO nca_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesuko Maria koya Juda unindoya mahero tendo mukuru tiqo, yiyoro newonde saŋgirí tero ");
INSERT INTO nca_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ŋande yaró, “Yendo uni ŋu re dana raŋgurí?” Yiní ŋande miraŋgurí, “Uni Parámi, ke mahe qeno.” ");
INSERT INTO nca_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesuko tendaró. ");
INSERT INTO nca_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Tendoní Juda unindo qenero ŋande yaŋgurí, “Qeni. Enendo uni ŋu newonde meté hamó ina.” ");
INSERT INTO nca_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Quko kumimbo ŋande yaŋgurí, “Eneko toŋí pokawí ŋu riní pitu ko meté toŋeteyote. Asa ko do murí karo uni ŋu riní kama khumaró?” ");
INSERT INTO nca_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ŋunde yi naru kaŋuya Yesu newondímo saŋgirí tero uni tapuko uyaró. Uni tapu ŋuko wondo yayó ka, ko wondo ka parámi mundo maŋgó wisumuŋaró. ");
INSERT INTO nca_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Asa Yesuko ŋande yaró, “Ye wondo ŋu re rotika umbuní.” Yiní Mata, uni khumaró ŋuro kuwí ŋuko ŋande miraró, “Uni Parámi, itaka ŋano naru nimí kini ŋunde rotoro uni tapuko yorote ŋa. Risá piyimi mu areweya.” ");
INSERT INTO nca_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yiní ŋande miraró, “No korete ke kimiranowó, ke iŋondutu teweya tiníqo, Anutu koro sine parámi ŋu qeneweya.” ");
INSERT INTO nca_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Asa wondo re roti umburó. Re rotiqo, Yesu koreko toŋetero ŋande yaró, “Awa, no yuŋguna kereteno, dokoro, ke haririne iŋote. ");
INSERT INTO nca_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","No iŋoteno, naru rokóŋo keto no iŋoyote. Quko unipare qambu ŋano kaŋeyoteŋgo ŋuro iŋoro mande ŋa yeteno. Ŋunde yeweka keto no asá niri mahenowó ŋuro iŋowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ŋunde yero kondé ŋande nekaró, “Lasarus, ke yendémo umbu.” ");
INSERT INTO nca_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Yiní Lasarus uni tapu rotoro yendémo umburó. Komo tapuŋowero koro khí kandí umu-kembé tuwipo pokamaŋgurí. Asa ko Yesuko ŋande yimiraró, “Tuwi se rotoyika uyariní.” ");
INSERT INTO nca_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ŋunde ŋuroko Juda uni kumi mahero Maria koya sikí ka yoraŋgurí qundo Yesuko o taró qenero iŋondutuwoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Quko kumimbo uyaro Farisi uni Yesuko o taró ŋuro yimiraŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ŋunde yimiroyi o qa-qa unindoro tapá unindoya Farisi unindoya uni kembé-kembémboya neko yiri mahero kopaŋgurí. Kopoyi ŋande yimiraŋgurí, “Nore date tewato? Uni ŋundo rokó qambu teyote. ");
INSERT INTO nca_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ko nore qene rotowato tiníqo, unipare soso ene iŋondutuwowaŋgo. Ŋunde ti Rom unindo mahero noreŋo Ya Surumínanimboya, wininanimboya yori kini teweya.” ");
INSERT INTO nca_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Asa keweroye moŋgo uni ka, owí Kaiapas, kumima naru quroko ŋuno o qa-qa unindoro tapá uni yaró, ŋundo ŋande yimiraró, “Yeko iŋo-iŋoye moré kini. ");
INSERT INTO nca_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Yendo oka kama qene iŋoyoteŋgo, peka. Qeni, ko uni kanata kato uniparetoro mepéye rero khumoníqota Rom unindo noreŋo wininani soso kama rambaruru yerewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiapas ŋundo mande ŋu iŋondutuyó moŋgo kama yaró. Kini. Kumima naru quroko ŋuno o qa-qa unindoro tapá uni yora. Ŋunde yotoro ye-ye mande ŋundiro yaró, ko Yesu Juda wini soso koro khumoweya. ");
INSERT INTO nca_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ko Yesuko Juda wini koro naŋge kama khumoweya. Kini. Eneko, Anutu koro simó wimbo-wimbo yoraŋgo qu soso kopo yereweka mahe wini kanata naŋge ti, yero khumoweya. ");
INSERT INTO nca_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Asa ko ŋu naruko ŋuno naŋge uni kembé-kembémbo, Yesu uratoka khumoní, yero khe seqaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ŋunde ŋuro Yesu Juda uni keweroyewore tunomo kaŋuya kama yateyara. Kini, mira ka mira wimbí sumeyoro ŋuno uyaró. Uyaro iŋo-iŋo rewero uniyómboya Eparaim yendémo ŋuno yoraŋgo. ");
INSERT INTO nca_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tukú Juda koro o ne-ne ŋu, owí muko Taka yereró ŋu mahewero tiní unipare yendé wimbo-wimbo qu noŋgo soso ta, nore sonowatoka Anutu toŋímo sara tiní, yero Yerusalem oŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ŋunde oro Yesu seqaro Ya Surumímo kaŋero epe osese-osese ŋande taŋgurí, “Ye date iŋoteŋgo? Enembe o ne-ne ŋano maheweyape ma kini?” ");
INSERT INTO nca_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Komo o qa-qa unindoro tapá unindoya Farisi unindoya unipare ŋande yimiraŋgurí, ko uni kato Yesu dana yote ŋu iŋoroqo, asa ene meté yimirika Yesu re kusi-kusi yano rotowaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Naru kano, kosa naru kande saŋiyoro kanata ŋunde rotoro Taka yereró quro o ne-ne ŋu tunoqeweya. Asa ŋu naruko naŋge Yesuko Betani yendémo ŋuno maheró. Yendémo ŋuno Lasarus, Yesuko uni tapu koŋgo riní otoqaró ŋu ŋuno yora. ");
INSERT INTO nca_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yesu koro o ne-ne ka tiqo, Matako sunará tiní Lasarus koya Yesu koya uni meyowomboya etero neyaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Asa Mariako sono kiruwó risá nuŋgurí qu, kimoyó parámi ŋu re Yesu khímo windoroŋaró. Ŋunde tero huímbo sowoní hararó. Ko sono kiruwó risá nuŋgurí ŋuro nuŋgurímbo ya soso howaró. ");
INSERT INTO nca_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ŋunde tiní Jutas Isikariot, eneŋo iŋo-iŋo rewero uni qu ka tukú Yesu re uni piyimi kandeyemo rotaró, ŋundo ŋande yaró, ");
INSERT INTO nca_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Date koro? Norendo sono kiruwó ŋu soweyowato tiníqo, denarius 300 siyoro uni onoŋoye moré kini qu meté se yunowato, hamómbe?” ");
INSERT INTO nca_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ŋunde yaró, quko uni oye moré kini ŋuro kama iŋaró. Kini. Ŋuko momo uni. Eneko Yesu koro iŋo-iŋo rewero uniyómboro wondo puŋgeye soporo eneŋo kumi rero momo teyara. ");
INSERT INTO nca_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Asa Yesuko mande ŋu iŋoro ŋande yaró, “Ŋunde roti. Pare ŋundo naru khumoweka tapu nerewaŋgo quro sono kiruwó ŋu towoyaró. ");
INSERT INTO nca_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Naru rokóŋoro uni onoŋoye moré kini ŋuko yeya yowaŋgo. Quko no yeya naru piru kama yowano.” ");
INSERT INTO nca_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Asa Juda unipare qambu ŋundo, Yesu Betani yendémo ŋuno yote, ye iŋoro ŋuno maheŋgurí. Ko Yesu qenewero na kama maheŋgurí. Kini, ŋande iŋaŋgurí, ko Lasarus, Yesuko uni tapu koŋgo riní otoqaró, ŋuya qenewero uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ŋunde ŋuroko o qa-qa unindoro tapá unindo Lasarus ŋuya uri khumowero quro mande kusiyaŋgurí, ");
INSERT INTO nca_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","dokoro, Juda uni qambu qundo Yesuko Lasarus koro kho taró ŋuro iŋoro Yesu iŋondutuwoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Saraŋoní unipare qambu o ne-ne parámi quro Yerusalem maheŋgurí ŋundo piŋa mande ŋande iŋaŋgurí, ko Yesuko Yerusalem mahete, iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ŋunde ŋuro ene domba koro kambiní se toworo kheko wisumuŋowero uyare ŋande kiweyaŋgurí, “Anutu koro seré ti. Uni Parámimboro owímo mahete ŋundo puriŋo riní. Uni ŋuko Israel koro wiri yerete uni ŋu.” ");
INSERT INTO nca_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Asa Yesuko dóki ka rero ŋuro saŋano kunditaró. Ŋuro komo suki sokomeko ŋuno ŋande nakayáŋaró, ");
INSERT INTO nca_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ye Saion koro Nambuní, ye ma sorewero. Qeni. Yeŋo wiri yerete uni ŋuno qu itaka mahete ŋa. Ene dóki simó kano kundite mahete.” ");
INSERT INTO nca_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Koretero iŋo-iŋo rewero uniyómboko unipareto o taŋgurí ŋuro murí kama iŋoyi tondaŋaró. Quko tukúko Anutuko owé parámi re Yesu inoníqota mande sokomeko ŋuno nakayáŋaró ŋu iŋoro mande ŋuko Yesu ŋuro naŋge yaró ŋuro iŋoyi tondaŋaró, ko unipareto Yesu koro o taŋgurí ŋuro iŋoyi tondaŋaró. ");
INSERT INTO nca_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Komo Yesuko Lasarus uni tapuko nekoní khumowí rotoro otoqaró quno ŋuno unipare qambu eneya yoraŋgurí. Asa unipare ŋundo Yesu ŋuro mande yesowo yeyaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ŋu murí ŋuro unipare qambu Yesuko rokó ŋu taró ŋuro iŋoro kheko wisumuŋowero uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Asa ko Farisi unindo epe mito-mito ŋande taŋgurí, “Qeni, nore oka tewero mepémo kini. Unipare soso nokono yoteŋgo qundo uyare howeyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ŋu naruko ŋuno Grik uni kumi ŋuya o ne-ne parámi muno Anutu potoruku te inowero quro Yerusalem ŋuno oŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Grik uni ŋuko Filipko maheŋgurí. Filip ŋuko Galili mirako Betisaita yendé moŋgo qu ka. Asa Grik unindo mahero ŋande miraŋgurí, “Awa, noreko Yesu qeneto yero.” ");
INSERT INTO nca_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ŋunde yi uyaro Andru miraró, ko Andru koya Filip koya uyaro Yesu mirariyó. ");
INSERT INTO nca_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Mirori Yesuko mandeyari topé ŋande yaró, “Asa Unindoro Naŋunímbo owé parámi rewero ŋuro naruyó itaka ŋa. ");
INSERT INTO nca_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Hamó horé no ye yimiroteno, ko wit taŋgurí nokono umburo kama khumoweya tiníqo, o kanata naŋge yoweya. Quko khumoro yateqo wotero eŋgé qambu teweya. ");
INSERT INTO nca_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ko uni kato ene yoto-yotoyó ŋuro hamó nuŋgurí iŋoyoweya tiníqo, yoto-yotoyó ŋu kina rotoweya. Quko uni kato eneŋo yoto-yotoyó ŋu nokono ŋano huwóŋoyote quko, asa yoto-yotoyó ŋu kondé towoní suki-suki yoweya. ");
INSERT INTO nca_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ko uni ka neneŋo sunará teweya ŋuko no nohoweyoweya. Ko mira no yowano ŋuko, neneŋo sunará simóne ŋuno yoweya. Ko uni ka neneŋo kho qu teweya quko, asa Awando owé parámi inoweya. ");
INSERT INTO nca_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Itaka newondene quhurí tete. Ko no date yewano? No ŋande peka yewano, ‘Awa, ke meté itaka rambaruru ŋa noŋgo ta nere?’ Kini, quhurí ŋa korowowero quro mahenowó. ");
INSERT INTO nca_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Awa, ke meté owéŋge ri parámi teweya.” Yesuko ŋunde yiníqo, maŋgó ka sambo koŋgo ŋande yaró, “Komo no owéne rewe parámi ta, ko imemo kaŋuya ŋunde tewano.” ");
INSERT INTO nca_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Unipare qambu kutaqemo kaŋaŋgurí qu mande ŋu iŋoro ŋande yaŋgurí, “Kusiro yete,” yaŋgurí. Ko kumimboko ŋande yaŋgurí, “Sambo simó kato Yesu koya mande yete,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ŋunde yi Yesuko mande topé ŋande yaró, “Ye mande itaka iŋoteŋgo ŋuko, neneŋo quro kini. Kini. Ŋuko yeŋo qu naŋge. ");
INSERT INTO nca_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Naru ŋako noko unipare ronda yerewero naruyó. Itakako Anutuko noko koro uni kembé ŋu howiní toŋeweya. ");
INSERT INTO nca_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Quko uni norero hoko nerewaŋgo quno ŋuno nondo unipare soso woso yereweka nono mahewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesuko ŋunde yero ene date tero khumoweya ŋuro yaró. ");
INSERT INTO nca_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Asa ko unipare qambu qundo mande topé ŋande yaŋgurí, “Hutuŋo mande weyoyi ŋande iŋoyato, ko Kristo ŋu maheroqo suki-suki yoweya. Ke date koro ŋande yete, ‘Unindo Unindoro Naŋuní ŋu hokowaŋgo,’ yete? Unindoro Naŋuní ŋu dani horé?” ");
INSERT INTO nca_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ko Yesuko ŋande yimiraró, “Naru tukuni ta naŋge hiyó ŋu yeya yoweya. Hiyómbo hiyóqeyoní ŋuno yateyuri. Yate huririko weyo yereweya koro. Uni ka huririko khe uyareyote ŋuko dana uyareyote ŋu kama iŋoyote. ");
INSERT INTO nca_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Itakaka hiyó yeya yoníqo, hiyó ŋu iŋondutuwoyi. Ŋunde iŋondutuworoqo ye hiyó koro simó tewaŋgo.” Yesuko uniparetoya mande yiní kini tiní yorotoro uyare sóqaró. ");
INSERT INTO nca_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Unipareto Yesuko rokó qambu taró ŋu qeneŋgurí, quko kama iŋondutuwoyaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ŋunde tero ye-ye uni Aisaia koro mandí ka ri hamó taró. Aisaiako ŋande yaró, “Uni Parámi, danimbo mandenani iŋondutuwoyoteŋgo? Ko dani ka Uni Parámimbo wimbí tunomo witú yiriní qeneŋgurí?” ");
INSERT INTO nca_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ŋunde ŋuroko unipare ŋunde qundo Yesu iŋondutuwowero mepémo kini. Do karo Aisaiako mande enesó ŋande nakayáŋaró, ");
INSERT INTO nca_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Anutuko toŋeye riní toŋetewero mepémo kini, ko iŋondutuye riní wisumuŋaró. Toŋeyembo oka qenewaŋgo koro, ko newondeyembo mande murí iŋowaŋgo koro, ko newonde rohoré ti nondo yorewe meté tewaŋgo koro.” ");
INSERT INTO nca_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaiako komo quno Yesu koro sine parámi ŋu qenero mande ŋu Yesu koro na yaró. ");
INSERT INTO nca_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ŋunde ŋuro uni kembé kumimboko Yesu iŋondutuwoyaŋgurí. Quko iŋondutuye re tapuŋaŋgurí, dokoro Farisi uni ŋuro soraŋgurí, Farisi unindo huru-huru ya noŋgo yohowewero koro. ");
INSERT INTO nca_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Hamó, uni kembé ŋu unindo seré te yunowero ŋuro hamó iŋaŋgurí, ko Anutuko owéye hokowero ŋuro tomó ta naŋge iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Asa Yesuko kondé ŋande kiwaró, “Uni ka no iŋondutu nereyote ŋuko no naŋge kama iŋondutu nereyote. Kini, enendo no asá nereró ŋuro iŋondutuwoyote. ");
INSERT INTO nca_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ko uni ka no niyote ŋuko no asá nereró ŋu qeneyote. ");
INSERT INTO nca_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nondo hiyó qembe nokono ŋano umbunowó. Ŋunde tero uni soso no iŋondutu nereyoteŋgo ŋuko huririko kama kunditeyowaŋgo yero. ");
INSERT INTO nca_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Ko uni kato no mandene iŋoro kama howeyoweya qu, asa no uni ŋunde qu kama rondaŋewano. Dokoro nondo nokono unipare ronda yerewero kama mahenowó. Kini. Nondo rambaruru koŋgo yorewero mahenowó. ");
INSERT INTO nca_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ko uni kato no huwó nerero mandene kama reyote ŋu, ronda-ronda uni ŋundo ronda yereweya. Hamó, mande yeyano ŋundo naŋge, naru weŋako ŋuno uni ŋunde qu ronda yereweya. ");
INSERT INTO nca_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Neneŋo iŋo-iŋone moŋgo mande ŋu kama yeyano. Kini. No asá nereró eneŋombo murí ka kondé nimironí mande ŋu yeyano. ");
INSERT INTO nca_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ko no ŋande iŋoteno, eneŋo mande kondé ŋundoko uni riní suki-suki yoweya. Ŋunde ŋuro mande soso nondo yeyoteno, ŋuko Awando nimironí yeyoteno naŋge.” ");
INSERT INTO nca_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ŋu naruko ŋuno Taka yereró quro o ne-ne ŋu tunoqewero taró. Ko Yesuko ŋande iŋaró, ko ene noko ŋa rotoro Iwímo owero quro naruyó ŋu tunoqaró. Enendo newonde meté unipareyó noko ŋano yoraŋgurí qu hamó yunoyaró. Ŋunde tero toŋí yoníqo, watí hamó ŋunde yunoyara. ");
INSERT INTO nca_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Asa suwo tiní etero o neyaŋgo. Komo Monimbuko Jutas Isikariot, Saimon koro naŋuní ŋu riní Yesu re uni piyimi kandeyemo rotowero ŋuro ye iŋaró. ");
INSERT INTO nca_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Asa Yesuko ŋande iŋaró, ko Iwímbo o soso se eneŋo kandímo raró, ko enendo Anutu roto umburoqota pitu ko Anutuko oweya. ");
INSERT INTO nca_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ŋunde ŋuro otoqoro o newero ŋu rotoro kowe punu-punuyó piru qu re rotoro tuwi ka re kosopémo kusiyaró. ");
INSERT INTO nca_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kusiyoro sono kondómoro iŋo-iŋo rewero uniyómboro kheye sonoworo tuwi re kosopímo kusiyaró ŋu re supu sowo yunaró. ");
INSERT INTO nca_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yate-yate Saimon-Pitako maheró. Mahiní Pitako ŋande oseseyaró, “Uni Parámi, kepe no khene sonowowero tete?” ");
INSERT INTO nca_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ko Yesuko mandí topé ŋande yaró, “O teteno ŋako, ke itakako murí kama iŋoyi tondaŋete. Quko imemoŋgo iŋoyi tondaŋeweya.” ");
INSERT INTO nca_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Yiní ŋande miraró, “Hamó horé, khene kama sonowoweya!” Yiní mande topé ŋande yaró, “Ko no kheŋge kama sonowowano tiníqo, ke noya kama yowaro.” ");
INSERT INTO nca_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ŋunde yiní ŋande miraró, “Uni Parámi, ko ŋunde tiníqo, khene naŋge kini, kandene, kembane ŋuya sonowo.” ");
INSERT INTO nca_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ŋunde yiní ŋande miraró, “Uni ka komo sono kimuró tiníqo, ene kaŋuya kama sono kimuweya. Kini, khí naŋge sonowoweya, kowí soso sara taró. Ko ye sara teteŋgo. Quko ye soso quro kama yeteno.” ");
INSERT INTO nca_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesuko uni ŋundo ene re uni piyimi kandeyemo rotaró ŋuro ŋande yaró, “Ye soso sara kama taŋgo,” yaró. ");
INSERT INTO nca_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ŋunde yero Yesuko kheye sonowoní kini tiníqo, kowe punu-punuyó piru ŋu pitu ko punuworo etaró. Etero ŋande osese yereró, “Yembeka o yeŋo teteno ŋaro murí iŋoyi tondaŋetepe ma kini? ");
INSERT INTO nca_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yendo no, ‘Rondaqe-rondaqe Uni,’ yero neko nereyoteŋgo, ko, ‘Uni Parámi,’ yero neko nereyoteŋgo. Ŋu meté, dokoro no ŋundiro na. ");
INSERT INTO nca_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Qeni, no Uni Parámiye yoteno, ko no Rondaqe-rondaqe Uniye yoteno, quko no ye kheye sonowoteno. Asa yendo kheye epe sono-sono ti qembe. ");
INSERT INTO nca_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Dokoro nondo otete ka witú yereteno. Ŋunde tero ye ŋuya o teteno ŋu teyuri qembe. ");
INSERT INTO nca_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","No hamó horé yero ye yimiroteno, sunará simó kato eneŋo uni parámiyó kama takate. Ko asáŋowí uni ka unindo ene asáŋoní maheró ŋu kama takate. ");
INSERT INTO nca_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Itaka ye otete ŋaro iŋomukoteŋgo, asa ŋu howewaŋgo tiníqo, puriŋo ka rewaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ye soso quro ŋundiro kama yeteno. No uni rokó yerenowó ŋuro iŋomukoteno. Quko komo suki mande sokomeko ŋuno nakayáŋaró qu ka hamó tunoqeweya. Mande ŋuko ŋandiro, ‘Uni ka noya bret neyote qundo saŋgirí te nunoro khí hokote.’ ");
INSERT INTO nca_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Oka tunoqewero tete, quko no koretero ŋuro ye yimiroteno. Ŋunde ŋuroko imemoŋgo tunoqeweya quno ŋuno ŋande iŋondutuwowaŋgo, ko ŋuko no naŋge. ");
INSERT INTO nca_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","No hamó horé ye yimiroteno, uni kato nondo uni ka asáŋowe uyote ŋuya topo teyote quno ŋuno ene noya topo teyote qembe. Ko uni ka noya topo teyote ŋuko no asá nereró ŋuya topo teyote.” ");
INSERT INTO nca_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesuko ŋunde yeroqo newondí quhurí piyimi tero ŋande yesowo yaró, “No hamó horé ye yimiroteno, ye keweroyemo kato no norero uni saŋgirí kandeyemo norotoweya.” ");
INSERT INTO nca_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ŋunde yiní epe qene-qene tero mandímboro murí ŋuro iŋondata parámi taŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Iŋo-iŋo rewero uni Yesuko hamó iŋoyara ŋuko Yesu taŋgímo ete saŋáqaró. ");
INSERT INTO nca_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Asa Saimon-Pitako uni ŋu Yesuko danimboro yaró ŋuro oseseyowero kembémbo rokó taró. ");
INSERT INTO nca_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ŋunde tiní enendo kembé Yesu nomonímo re rotoro ŋande oseseyaró, “Uni Parámi, ke danimboro yete?” ");
INSERT INTO nca_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesuko mande topé ŋande yaró, “Nondo bret sombé ka sonono rero re uni ka inowano. Uni ŋuro yeteno ŋu.” Ŋunde yero bret sombé ŋu sonono rero re Jutas Isikariot, Saimon koro naŋuní, ŋu inaró. ");
INSERT INTO nca_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Jutasko re niní kini tiníqo, Monimbu umburo newondímo uró. Ko Yesuko ŋande miraró, “Ke o tewero iŋote ŋu waka ta te.” ");
INSERT INTO nca_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ŋunde miraró, quko uni meyowo o neyaŋgurí ŋundo mandímboro murí kama iŋoyi tondaŋaró. ");
INSERT INTO nca_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Jutas ŋuko eneŋo wondoye ŋu sopoyara. Ŋundiro naŋge kumi muko ŋande yero iŋaŋgurí, ko Yesu peka o ne-ne ŋuro uyare oka kimo mahewero mirarómbe, ma uyare uni oye moré kini mu ŋu o se yunowero miraró, peka. ");
INSERT INTO nca_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Asa Jutas bret sombé ŋu re niní kini tiní asa waka ta mirako uró. Ko suwo taró. ");
INSERT INTO nca_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Asa Jutas mirako uníqo, Yesuko ŋande yaró, “Itakako Unindoro Naŋuní ŋu owé parámi rewero tete. Ko owé parámi riníqo, Anutuko ŋuya owé parámi reweya. ");
INSERT INTO nca_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ko Anutuko owé parámi ŋunde reroqo quroyómo ŋuno enendo Naŋuní owé parámi inoweya. Itaka ka ŋunde teweya. ");
INSERT INTO nca_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Naŋo-simóne, naru tomó ta naŋge yeya yorowano. Imemoŋgo ye no seqa nerewaŋgo. Quko mande Juda koro uni pará-pará yimiranowó ŋu, itaka ŋunde naŋge ye yimiroteno, ko ye mirako owano ŋuno owero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Nondo mande kondé keta qu ŋande yunoteno, ko ye newonde meté epe ino-ino teyuri qembe. Nondo newonde meté ye yunano ŋunde naŋge, ye ŋuya newonde meté epe ino-ino teyuri qembe. ");
INSERT INTO nca_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ŋunde tiqo, unipare soso ŋande ye iŋowaŋgo, ko ye neneŋo iŋo-iŋo rewero unine.” ");
INSERT INTO nca_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Yiníqo, Saimon-Pitako ŋande oseseyaró, “Uni Parámi, ke dano oweya?” Yesuko mande topé ŋande yaró, “Mira no ŋuno owano ŋuko, ke itaka no nohowe ŋuno kama oweya. Quko imemoŋgoko nohowe ŋuno oweya.” ");
INSERT INTO nca_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Yiní Pitako ŋande oseseyaró, “Uni Parámi, date koro no itaka ke kama kohowewano? Nondo samaka kerewero quro yoto-yotone rotowano.” ");
INSERT INTO nca_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yiní Yesuko mande topé ŋande yaró, “Kepe keto samaka nerewero quro yoto-yotoke rotoweya, ye iŋote, hamómbe? No hamó horé kimiroteno, kotori kama yeyoníqota ke naru kapusako neneŋo wawa yeweya. ");
INSERT INTO nca_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Ye newonde quhurí ma tewero. Ye Anutu iŋondutuwoyi; no ŋuya iŋondutu niri. ");
INSERT INTO nca_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Awanemboro yanoko yakutí qambu yote. Ŋu hamó kini tiníkaqo, no mande ŋunde wisi yerewero, dokoro no oro yeŋo yakutíye roŋgaruwowero oteno. ");
INSERT INTO nca_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ko no oro ye yakutíye roŋgaruwoteno tiníqo, no pitu ko umburo ye yorewe dano yoteno ŋuno mahewaŋgo. Ŋunde tero ye ŋuya ŋuno noya ŋuno yowato. ");
INSERT INTO nca_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ko dano owano quro khe ŋu iŋomukoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Yiní Tomasko ŋande miraró, “Uni Parámi, ke dano oweya ŋu nore kama iŋoteto. Asa ko nore khe ŋu date iŋowato?” ");
INSERT INTO nca_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yiní ŋande miraró, “Khe ŋuya, mande hamó ŋuro murí ŋuya, yoto-yoto koro simburí ŋuya ŋuko no naŋge. Uni kato khe enesówore Awako kama maheweya. ");
INSERT INTO nca_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ko ye komo no iŋo nunaŋgurí tiníqo, awane ŋuya iŋo inowaŋgo. Ŋa naru ŋa noŋgo yendo hamó iŋo inoyoteŋgo, ko ene qeneteŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipko ŋande miraró, “Uni Parámi, ke Awa nore witú nirikata ŋu mepémo teweya.” ");
INSERT INTO nca_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yiní ŋande miraró, “Filip, naru piru horé no yeya yorano, quko keto no kama iŋo nunoyote, peka? Uni ka no niyote ŋuko Awa qeneyote. Ke date ŋunde yete, ‘Ke Awa witú nirikata,’ yete? ");
INSERT INTO nca_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Keto no Awa quroko yoteno ko Awando quronemo yote ŋuro kama iŋondutu teyote, peka? Nondo mande ye yunoyoteno ŋuko, neneŋo iŋo-iŋone moŋgo kama yeyoteno. Kini. Awando neneŋo quronemo yote, ŋuroko khoyó soso ŋu teyote. ");
INSERT INTO nca_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","No Awa quroko yoteno, ko Awando quronemo yote. Mande ŋu iŋondutuwi. Ko kini tiníkaqo, asa nondo kho soso teyoteno ŋu naŋge iŋondutuwi qembe. ");
INSERT INTO nca_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","No hamó horé ye yimiroteno, uni ka no iŋondutu nereyote ŋundo kho soso teyano ŋu tero neneŋo kho qu takaweya, dokoro, no Awako oteno. ");
INSERT INTO nca_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ko ye o soso ŋuro owéne moŋgo kira nerewaŋgo ŋu tewano. Ŋunde tero Naŋuníwore Awando owé parámi reweya. ");
INSERT INTO nca_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ko o soso ŋuro owéne moŋgo kira nerewaŋgo ŋu tewano. ");
INSERT INTO nca_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ye newonde meté no nunowaŋgo tiníqo, neneŋo mande kondé soso meté ta howeyowaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ŋunde tiqo, nondo Awane kirayowano, ko enendo ye wimbu yunowero quro samaka-samaka kaŋuya re yunoweya. Yunoní enendo yeya suki-suki yoweya. ");
INSERT INTO nca_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Samaka-samaka ŋuko mande hamó ŋuro Yuqayó mu. Nokono unipareto ŋu kama rewaŋgo, dokoro ŋu kama qeneyoteŋgo, ko kama iŋo inoyoteŋgo. Quko yendo iŋo inoyoteŋgo, dokoro enendo yeya yote ko ye quroko yoweya. ");
INSERT INTO nca_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“No ye yiyoro yorotowe qoqewo qembe kina kama yowaŋgo. Kini. No yeno mahewano. ");
INSERT INTO nca_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Naru tukuni ta naŋge nokono unipareto no kama niyowero teteŋgo. Quko yeko no niyowaŋgo. No keta yoweqo, ye ŋuya keta yowaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ŋu naruko ŋunoko ye ŋande iŋowaŋgo, no Awane quroyómo yoteno, ko ye neneŋo quronemo yoteŋgo, ko no ye quroyemo yoteno. ");
INSERT INTO nca_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Uni ka neneŋo mande kondé ŋu re howeyote ŋundo newonde meté nunoyote. Ko uni ŋu newonde nunoyote ŋu, Awanembo ŋuro newonde inoweya. Ko no ŋuya uni ŋu newonde inowano, ko no neneŋo rero witúŋoyowano.” ");
INSERT INTO nca_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ŋunde yiníqo, Jutas, ŋuko Isikariot kini, ŋundo ŋande oseseyaró, “Uni Parámi, ŋu date teroqo ke keŋo rero nore witú nereweya, quko nokono unipare keŋo rero kama witú yereweya?” ");
INSERT INTO nca_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ko Yesuko mande topé ŋande yaró, “Uni ka newonde meté no nunoyote ŋuko neneŋo mandene howeyoweya. Ko Awanembo uni ŋu newonde meté inoweya. Ko nore irisa eneno mahero ŋuya yowato. ");
INSERT INTO nca_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Uni ka newonde meté no kama nunoyote ŋuko mandene kama howeyoweya. Mande ye iŋoyoteŋgo ŋako neneŋo mande qu kini. Ŋuko Awando no asá niriní mahenowó ŋuro mande qu. ");
INSERT INTO nca_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“No yeya yorano qunoko nondo o ŋuro yimitoyano. ");
INSERT INTO nca_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Quko imemoŋgo Awando neneŋo mepéne, Yuqa Surumí, yeŋo samaka-samakaye, ŋu owénemo riní umbuweya. Ko enendoko o soso ŋuro mande rondaqe yunoweya. Ko enendo iŋo-iŋoye riní otoqoní nondo komo yimiranowó ŋu pitu ko iŋowaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","No newonde ime yeno rototeno. Neneŋo newonde ime qu re yunoteno. Newonde ime ŋuko, unipare nokono quro qembe kini. Ye newondeye quhurí parámi ma tewero, ko ma sorewero. ");
INSERT INTO nca_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Komo nondo mande yewe ŋande iŋaŋgurí, ‘No yorotoro toŋewano, ko pitu ko yeno mahewano.’ Asa newonde meté nunoyoteŋgo tiníqo, mande ŋuro niŋgu-niŋgu tewaŋgo. Dokoro, no Awako owé teteno. Ko Awando taka nerete. ");
INSERT INTO nca_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","O ŋu kama tunoqeyoní no itaka ŋuro yimiroteno. Asa ko imemoŋgo o ŋu tunoqeweya quno ŋuno ye iŋondutu tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Naru piru yeya kama yewano, dokoro noko ŋaro uni kembé ŋundo itaka mahete. Eneŋo wimbímbo no kama taka nerete, ");
INSERT INTO nca_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","quko nokono unipareto ŋande iŋoyi, no newonde meté Awa hamó inoyoteno. Ko no Awando o soso ŋuro nimiraró ŋu teyoteno. Asa ye otoqika toŋeto. ");
INSERT INTO nca_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Wain koro utó hamó ŋuko no naŋge. Ko Awane muko wain koro kho quro simburí. ");
INSERT INTO nca_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Awanembo kambiní nono yote ŋu soso kama eŋgé teyote ŋu se rotoyote. Ko kambiní kumi eŋgé teyote ŋuko, Awando sonowoní sara teyote, ŋuro tero eŋgé qambu teweya. ");
INSERT INTO nca_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ye komo sara taŋgurí, dokoro mande re yunanowó ŋundo ye yoriní sara taŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yeko nono womoyuri qembe. Ŋunde tiqo, no yeno womoyowano. Ko wain utó ŋuro kambiní utóŋo kumi puŋomo kama womoyoweya quko, asa ŋuko eŋgé kama teyoweya. Ŋunde naŋge, ko ye nono kama womoyowaŋgo tiníqo, eŋgé kama teyowaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Wain koro utó ŋuko no naŋge, ko yeko wain koro utóŋomboro kambi-kambiní. Uni ka nono womoní no eneno womoyoteno ŋundo eŋgé qambu horé teyote. Ko ye no norotowaŋgo tiníqo, oka tewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Uni ka nono kama womoyote ŋuko utóŋomboro kambiní se rotoyi asáqaró ŋunde qembe teweya. Kambiní ŋunde qu koporo kewáko qayi qayote. ");
INSERT INTO nca_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ko ye nono womoyiqota mandene yeno yote tiníqo, ye nuŋguríye moŋgo no kira niriqo, o ŋu tunoqeweya. ");
INSERT INTO nca_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ye eŋgé qambu tero neneŋo iŋo-iŋo rewero unine yoteŋgo tiníqo, Awanembo owé parámi reweya. ");
INSERT INTO nca_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Awando newonde meté no hamó nunoyote, asa ŋundiro naŋge nondo newonde meté ye yunoyoteno. Ye neneŋo muríne ŋunde qu howeyuri qembe. ");
INSERT INTO nca_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nondo Awanemboro mande kondé howeyano, ko eneŋo newonde meté yunowero murí ŋu howeyoteno. Asa ŋundiro naŋge ko ye neneŋo mande kondé ŋu meté howeyowaŋgo tiníqo, neneŋo muríne ŋunde qu howeyowaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“No niŋgu-niŋgu teyoteno ŋuko yeno yotoro newondeyemo maŋgoreyoní, yero iŋoteno. Ŋunde ŋuro no mande ŋa re yunoteno. ");
INSERT INTO nca_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Neneŋo mande kondé ŋuko ŋandiro, nondo newonde meté ye yunoyoteno, ŋunde naŋge ye newonde meté epe ino-ino teyuri qembe. ");
INSERT INTO nca_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ko uni ka nembe topé-topé samaka yerewero quro yoto-yotoyó rotoro khumoweya tiníqo, newonde meté yunowero murí ŋundoko murí ŋunde qu meyowo ka taka yerete. ");
INSERT INTO nca_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","“Ko ye nondo mande kondé yunoyoteno ŋu tewaŋgo tiníqo, neneŋo nembe topo-topone yowaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Sunará simó ŋuko parámiyómbo o teyote ŋu kama iŋote. Ŋunde ŋuro no kaŋuya ye, ‘kho simóne,’ watí yero kama neko yereyoteno, kini. Mande soso Awane moŋgo iŋanowó ŋuko no komo se ye yimiranowó. Ŋunde ŋuro no ye, ‘nembe topo-topone,’ yero neko yereyoteno. ");
INSERT INTO nca_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Yendo no kama rokó nerero noraŋgurí. Kini, nondo ye rokó yerero yorero kho ka yunanowó. Ŋunde tero ye uyaya eŋgé suki-suki yoweya qu ti qembe yero. Ŋunde tero asa ko ye no owéne moŋgo hariri tero Awa kirayatoka oka re nunoní yero yewaŋgo tiníqo, o ŋu re yunoweya. ");
INSERT INTO nca_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nondo ye mande kondé ŋande yunoteno, ye newonde meté epe ino-ino ti qembe. ");
INSERT INTO nca_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Yate nokono unipareto yeŋo piyimi yiriqo, ŋande iŋoyi qembe, ko koretero neneŋo piyimi nereŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ko yeko noko koro uni qu yoraŋgo tiníqo, noko unipareto yeya topo teyowero. Quko yeko noko koro uni kini. Nondo ye rokó yerero noko noŋgo yoranowó. Ŋunde ŋuro noko unipareto yeŋo piyimi yereyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ye nondo mande yeteno, asa sunará simóko parámiyó kama takate, ŋu iŋoyi qembe. No o piyimi te nunaŋgurí tiníqo, ye ŋuya o piyimi te yunowaŋgo. Ko neneŋo mandene howaŋgurí tiníqo, yeŋo mandeye ŋuya howewaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Quko enendo no asá nereró ŋu kama iŋoteŋgo. Ŋunde ŋuroko o piyimi ŋunde qu te yunoyowaŋgo, dokoro yeko owéne moré qu. ");
INSERT INTO nca_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ko nondo mahero mande kama yunanowó tiníqo, eneko quhuríyemboro potó moré kini. Quko itaka ŋako quhuríye tapuŋowero khe ka ŋuna kini. ");
INSERT INTO nca_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Uni ka neneŋo piyimi nereyote ŋuko Awane ŋuro piyimiŋoyote. ");
INSERT INTO nca_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","No keweroyemo kho kumi teyano ŋu, komo uni kato kho ŋunde qu kama teyaró. Ko ŋunde kama teyano tiníqo, eneko quhuríyemboro potó moré kini. Quko kho teyano ŋu qenero neneŋo piyimi nerero Awane ŋuya piyimiŋoyaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Enendo murí piyimi teyoteŋgo ŋundo mande hutuŋo mandeyemo yote qu ka riní hamó tunoqete. Mande ŋuko ŋandiro, ‘Unindo murí moré kinimboro no piyimi nereyoteŋgo.’ ");
INSERT INTO nca_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Nondo yeŋo samaka-samaka ŋu rewe Awa koŋgo yeno umbuweya. Samaka-samaka ŋu, Yuqa Surumí, ŋundo Awandoro mande hamó yeyote. Ŋundo mahero neneŋo yesowoweya. ");
INSERT INTO nca_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ye ŋuya neneŋo yesowoyi qembe. Dokoro, no kho kimani tanowó qu noŋgo itaka arete ŋano yeya noya yorato. ");
INSERT INTO nca_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Yendo iŋondutuye kama rotowero quro mande ŋa ye yimiroteno. ");
INSERT INTO nca_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Imemoŋgo uni kembémbo huru-huru yaye moŋgo yohowewaŋgo. Hamó, naru ka maheweya qunoko unindo, Anutu koro sunará teyoteto, yero iŋoro ye yuri khumowaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Uni ŋundo Awa kama iŋo inoteŋgo, ko no ŋuya kama iŋo nunoteŋgo. Ŋunde ŋuroko murí piyimi ŋunde qu teyowaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nondo mande ŋa yimiroweqota naru ŋu maheweya qunoko mandene ŋaro iŋowaŋgo. “Komo no yeya yorano, ŋuroko nondo o ŋaro ye kama yimiranowó. ");
INSERT INTO nca_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Quko itakako no uni asá nereró ŋunoko oteno. Ko ye kato no kama osese nereyoteŋgo, ‘Ke dano owero?’ ");
INSERT INTO nca_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mande yimiroteno ŋuko yoriní newonde surumí hamó teteŋgo. ");
INSERT INTO nca_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Quko mande hamó yimiroteno, no ye samaka yerewero naŋge yorotoro toŋewe teteno. No kama owano tiníqo, yeŋo samaka-samakaye ŋu yeno kama umbuweya. Ko no owano tiníqo, rewe yeno umbuweya. ");
INSERT INTO nca_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Umburo noko uniparetoro otete piyimiye ŋuro kowi piyo yunoweya, oteteye roneneŋowí mu ŋuro kowi piyo yunoweya, ko rondaŋewero muríye ŋuro kowi piyo yunoweya. ");
INSERT INTO nca_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Unipareto kama iŋondutu nereyoteŋgo. Ŋunde ŋuroko enendo otete piyimiye ŋuro kowi piyo yunoweya. ");
INSERT INTO nca_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","No Awako oteno, imemoŋgo kama niyowaŋgo. Ŋunde ŋuroko samaka-samakaye ŋundo uniparetoro oteteye roneneŋowí mu ŋuro kowi piyo yunoweya. ");
INSERT INTO nca_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Noko koro uni kembémboro oteteyó piyimi ŋuro mande khono yorotaró. Ŋunde ŋuroko rondaŋewero muríye ŋuro kowi piyo yunoweya. ");
INSERT INTO nca_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nondo mande qambu ye yimirowero yero iŋoteno. Quko ye iŋoyi tondaŋewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Quko imemoŋgo Yuqa mande hamó yeyote ŋu maheweya. Enendo ye iŋondutuye riní mande hamó soso iŋoyi tondaŋeweya. Mande ŋuko eneŋo newondí moŋgo qu kini. Koretero mande ŋu iŋoroqota yeweya. Ko o kumi-kumi tunoqeweya ŋuro yimiroweya. ");
INSERT INTO nca_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Enendo o neneŋo qu rero yunoweya. Ŋunde tero owéne hokoweya. ");
INSERT INTO nca_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Awando o soso towote ŋuko neneŋo naŋge. Ŋuro tero ŋande yeteno, Yuqa ŋuko o neneŋo qu rero yunoweya. ");
INSERT INTO nca_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Naru tukuni ta ŋunde rotoroqo ye kaŋuya kama niyowaŋgo. Ko yate naru tukuni ta rotoroqo niyowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ŋunde yiní iŋo-iŋo rewero uniyó kumimbo epe mito-mito ŋande taŋgurí, “Mande yero nimirote ŋu murí datiro? Ŋande yete, ‘Naru tukuni ta ŋunde rotoroqo ye kaŋuya kama niyowaŋgo. Ko yate naru tukuni ta rotoroqo niyowaŋgo.’ Yero ŋande yete, ‘Dokoro no Awako owano.’” ");
INSERT INTO nca_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Yero ŋande yeyaŋgo, “Enendo naru tukuni ŋuro yete, ŋu do ka? Nore mande yete ŋuro murí kama iŋoteto.” ");
INSERT INTO nca_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Asa Yesuko ene oseseyato, yero iŋoyaŋgurí ŋu iŋoro ŋande yimiraró, “Yembeka nondo mande yeteno ŋaro murímboro epe mito-mito yeyoteŋgope? Noko ŋande yeteno, ‘Naru tukuni ta ŋunde rotoroqo ye kaŋuya kama niyowaŋgo. Ko yate naru tukuni ta rotoroqo niyowaŋgo,’ yeteno. ");
INSERT INTO nca_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Hamó horé yero yimiroteno, yeko tendo parámi tero sikíqero tendoyuriqo, nokono unipareto niŋgu-niŋgu tewaŋgo. Quko yeŋo newondeye quhurí teweya, quko rohoréŋoní ye niŋgu-niŋgu tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ko pare kato simó pisiyowero naru ŋu mahete quno ŋuno kowe surumí teyote. Quko simóqeyote naruko ŋunoko, kowe surumí ŋuro kama iŋoyote. Kini. Simó nokono tunoqete ŋuro niŋgu-niŋgu teyote. ");
INSERT INTO nca_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ŋunde naŋge, itaka ye newondeye quhurí tete. Quko pitu ko ye yiyoweqo, newondeye niŋgu-niŋgu teweya. Ko uni kato niŋgu-niŋguye ŋu kama se rotoweya. ");
INSERT INTO nca_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ko naru ŋunoko ye o karo no kama kira nerewaŋgo. No hamó horé yero ye yimiroteno, ko ye o karo neneŋo owéne moŋgo Awa kirayowaŋgo quko, asa o ŋu re yunoweya. ");
INSERT INTO nca_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ye komo oka rewero neneŋo owéne moŋgo kama kirayaŋgurí. Yeko kira teroqota, o ŋu rewaŋgo. Ko niŋgu-niŋgu ŋundo ye newondeyemo hamó maŋgoreweya. ");
INSERT INTO nca_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Nondo tapara mandeko yero ye yimitoyoteno. Quko imemoŋgo no tapara mande kaŋuya yero ye kama yimirowano. Kini. Noko mande yero Awanemboro murí ŋuro wisiyo yimirowano. ");
INSERT INTO nca_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ŋu naruko ŋunoko ye neneŋo owénemo hariri tewaŋgo. Quko nondo yeŋo Awako hariri kama tewano. Ŋuro kama yeteno. ");
INSERT INTO nca_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Kini. Yendo newonde meté no nunoyoteŋgo, ko iŋondutu ŋande teyoteŋgo, ko no Awa noŋgo mahenowó. Ŋunde ŋuroko Awa eneŋombo newonde meté ye yunoyote. ");
INSERT INTO nca_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","No Awa rotoro nokono umbunowó. Quko itaka noko ŋa rotoro pitu ko Awako owé teteno.” ");
INSERT INTO nca_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Asa ŋunde yiní iŋo-iŋo rewero uniyómbo ŋande yaŋgurí, “Iyo, itaka ke mande wisiyoyote. Itaka ke tapara mande kama yete. ");
INSERT INTO nca_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Itaka ŋande iŋoteto, uni kato tukuni tero o karo meté kira kereweya, quko komo keto ene tukuni teyote ŋuro iŋomukaró. Dokoro ke o soso iŋomukote. Ŋunde ŋuro ŋande iŋondutu kereteto, ke Anutu koŋgo maheró.” ");
INSERT INTO nca_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesuko mandeye topé ŋande yaró, “Yembe itaka iŋondutu teteŋgope? ");
INSERT INTO nca_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Iŋoyi, naru ka mahewero tete, hamó itaka mahete, ko unindo ye yohowi yeŋo yendéne-yendéne toŋewaŋgo. Ŋunde tero ye no noroti no nenemata yowano. Quko noko nenemata horé kama yowano, dokoro, Awa noya yote. ");
INSERT INTO nca_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Nondo, ye nono womika newondeye ime yoní, yero iŋoteno. Ŋunde ŋuro no mande ŋa yimiroteno. Ye nokono ŋano yowaŋgo qunoko, quhurí yeno maheyoweya, quko ye newondeye kondé yoní. Dokoro nondo komo noko ŋaro wimbí taka khetewe uró.” ");
INSERT INTO nca_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesuko iŋo-iŋo rewero uniyó mande yimitoro samboko toŋetero, ŋande yaró, “Awa, naru ŋuko itaka naŋge tunoqete. Itaka naŋoŋgeporo owé parámi ino. Ŋunde ti naŋoŋgepo owé parámi kunoweya. ");
INSERT INTO nca_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Dokoro, keto no wimbu nunoyi unipare soso koro uni kembéye tunoqano. Ŋunde tero nondo uni keto nunaró ŋu yorewe yoto-yoto suki-suki rewaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ko yoto-yoto suki-suki rewaŋgo ŋuko ŋandiro, enendo ke, Anutu hamó kanata naŋge ŋu, iŋo kunoyoteŋgo, ko keto uni asáŋaró ŋu, Yesu Kristo, iŋo inoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Keto kho nunaró ŋu tewe kini tete. Ŋunde tero owéŋge rewe nokono ŋano parámi tete. ");
INSERT INTO nca_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Awa, noko ŋa kama tunoqeyoní, no keya yotoro owéne muko parámi taró. Itaka owé ŋu pitu ko nunoka no keya yorowaro. ");
INSERT INTO nca_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nondo noko unipare keto nunaró ŋu keŋo owéŋge ŋuro mande wisiyanowó. Eneko keŋo qu, ko keto se nuni mandeke ŋu meté howeyaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Itaka ŋande iŋoteŋgo, keto o soso se nunaró ŋu ke noŋgo maheró. ");
INSERT INTO nca_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mande soso se nunaró ŋu yunanowó. Yunoweqo, rero hamó horé ŋande yero iŋoyaŋgo, no ke noŋgo mahenowó. Ko iŋondutu ŋande teyoteŋgo, keto no asá niri mahenowó. ");
INSERT INTO nca_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Nondo samaka yerewero quro kira kereteno. Unipare soso nokono yoteŋgo quro kama kira kereteno. Kini. Keto uni se nunaró ŋuro naŋge kira kereteno. Dokoro, eneko keŋo ŋu. ");
INSERT INTO nca_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","O soso neneŋo muko keŋo qu naŋge. Ko o soso keŋo muko neneŋo naŋge. Uni se nunaró ŋuwore owé parámi ranowó. ");
INSERT INTO nca_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Itaka nokono watí kama yorowano. Quko no keno owano quno ŋuno uni ŋako ŋano yorowaŋgo. Awa Surumí, keto owéŋge re nunaró ŋuro wimbímo samaka yere qembe. Ŋunde tero nore irisa kanata naŋge yorotero ŋunde naŋge enendo kanata naŋge yorowaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","“No eneya yorano quno, owéŋge re nunaró ŋuro wimbímo ene kawaware yerenowó. Ŋunde tewe ene kama rambaruru taŋgurí. Uni kanata naŋge hamó piyo taró. Ŋunde tero komo suki mande sokomeko ŋuno nakayáŋaró ŋu hamó taró. ");
INSERT INTO nca_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Itaka no keno owé teteno. Quko nokono watí yoteno quno mande ŋa yeteno. Ŋunde tero neneŋo niŋgu-niŋgune ŋu meté eneŋo newondeyemo maŋgore yoweya. ");
INSERT INTO nca_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mandeke muko, komo se yunanowó. Ko noko unipareto eneya saŋgirí teteŋgo. Dokoro no noko ŋaro qu kini, ŋunde naŋge unine mu ŋuya noko ŋaro qu kini. ");
INSERT INTO nca_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nondo ŋande kama kira kereyoteno, ko keto ene noko noŋgo yorotoweya. Kini, ŋaro kira kereyoteno, ko keto kawaware tiqota uni piyimi ŋundo kama rambaruru yereweya. ");
INSERT INTO nca_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","No noko ŋaro qu kini, ŋunde naŋge ene ŋuya noko ŋaro qu kini. ");
INSERT INTO nca_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mandeke muko hamó naŋge, asa ko mande hamó ŋuwore yoreka keŋo unike naŋge tunoqewaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Komo keto no asá niri mahero noko unipare keweroyemo yano. Ŋunde naŋge nondo uni ŋa asá yerewe noko unipare keweroyemo yowaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ko samaka yerewero quro neneŋombo norero keŋo qu teteno. Ŋunde tero ene ŋuya keŋo na tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Quko nondo uni ŋu samaka yerewero quro naŋge kama hariri teteno. Kini. Ŋuya unipareto eneŋo mandeye ŋu iŋoro iŋondutuwoyowaŋgo ŋuro hariri teteno. ");
INSERT INTO nca_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Awa, ke quronemo yote, ko no qurokemo yoteno. Nore irisa teyotero ŋunde naŋge iŋondutu unipare soso ŋundo newonde kanata tewaŋgo quro hariri teteno. Ŋuya ene quronarimo yowaŋgo. Ŋunde yuriqo, noko unipare ŋundo ŋande iŋowaŋgo, keto no asá niri mahenowó, yero iŋowaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nondo owé parámi re nunaró ŋu ene yunanowó. Ŋunde teweqo, ene newonde kanata ti yero, asa nore newondenari kanata yotero ŋunde naŋge. ");
INSERT INTO nca_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nondo quroyemo yoteno, ko keto quronemo yote. Ŋundiro ene soso newonde kanata tewaŋgo, ko noko unipareto yiyoro ŋande iŋowaŋgo, keto asá niri mahenowó, ko keto newonde meté no nunoyote ŋunde naŋge newonde meté uni ŋu yunoyote. ");
INSERT INTO nca_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Awa, nondo ŋande ye iŋoyoteno, ko unipare se nunaró ŋu yendémo yoteno quno ŋuno noya yowaŋgo. Ŋuno yotoro neneŋo owé parámi ŋu qene iŋowaŋgo. Noko sambo kama tunoqeyoní keto newonde meté nunoro owé ŋu nunaró. ");
INSERT INTO nca_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Awa Roneneŋowí Mu, noko unipare ŋuko ke kama iŋo kunoteŋgo. Quko nondo ke iŋo kunoteno. Ko neneŋo unipare ŋuko ŋande iŋoteŋgo, ko keto no asá niri mahenowó. ");
INSERT INTO nca_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Keŋo owéŋge wisiyo yimiranowó. Ko watí ŋunde yimirowano. Ŋunde tewe meté keto newonde meté nunoyote murí ŋu quroyemo yoweya, ko no ŋuya quroyemo yowano.” ");
INSERT INTO nca_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesuko mande ŋu yiní kini tiníqo, iŋo-iŋo rewero uniyómboya uyaro Kitiron Rawa andusina uyaŋgurí. Sono karóŋo andusina ŋunoko oliv kho ka ŋuno yora, ko Yesu koya iŋo-iŋo rewero uniyómboya kho ŋuro quroko oŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jutas ŋuya kho ŋuro iŋaró, dokoro, naru qambu Yesuko iŋo-iŋo rewero uniyómboya ŋuno kopoyaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ŋunde ŋuro Jutas koya kuma unindoya maheŋgurí. Ŋuya o qa-qa unindoro tapá unindoya Farisi unindoya sopo-sopo uni kumi asá yiri suru toworo kuma tewero o qu ŋuya toworo maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Asa Yesuko o soso eneno tunoqeweya ŋu iŋomukaró. Ŋunde ŋuro uni ŋu mahi yiyoro taŋgeyemo uyaro ŋande osese yereró, “Ye dani ka seqateŋgo?” yaró. ");
INSERT INTO nca_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Yiní mande topé ŋande yaŋgurí, “Noreko Yesu, Nasaret yendé moŋgo uni ŋu seqateto.” Yi ŋande yimiraró, “Ŋuko no,” yaró. (Jutasko uni ŋuya kaŋaró.) ");
INSERT INTO nca_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Asa Yesuko ŋunde yaró, ŋuko no, yiní uni ŋu iŋoro woso uyaro rokaráŋo umbuŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ŋunde tiqo, Yesuko pitu ko ŋande osese yereró, “Ye dani ka seqateŋgo?” yaró. Yiní ko ŋande yaŋgurí, “Yesu, Nasaret yendé moŋgo uni ŋu seqateto,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ko Yesuko mandeye topé ŋande yaró, “Nondo ye yimiroteno ŋu, ŋuko no. Ko ye no seqa nere niyoteŋgo tiníqo, wini ŋa yorotika toŋi.” ");
INSERT INTO nca_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Mande yaró ŋundoko mande ka komo yaró qu ŋu rokóŋaró, “Uni se nunaró ŋuro kanata ka kama rotowano.” ");
INSERT INTO nca_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Asa Saimon-Pitako suke parámi re maheró ŋu rero o qa-qa unindoro tapá unindoro sunará simó quro kusumbí kandí kondéwore takaní umburó. (Sunará simó ŋuro owí muko Malikus.) ");
INSERT INTO nca_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ŋunde tiní Yesuko Pita ŋande miraró, “Suke ŋu reka paseyómo uní. Date koro? Kepe nombe Awando topa re nunaró ŋuno sono kama neweya, yero iŋote?” ");
INSERT INTO nca_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ŋunde yiníqo, kuma unindoya eneŋo uni kembémboya Juda koro sopo-sopo unindoya mahero Yesu toworo re utómbo kusiyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ŋunde tero korete rero Anasko uyareŋgurí. Anas ŋuko Kaiapas ŋuro teŋari. Kumima naru ŋunoko Kaiapas ŋuko o qa-qa unindoro tapá uni yora. ");
INSERT INTO nca_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Komo enendo Juda koro uni pará-paráye ŋande yimiraró, “Uni kayata kato unipare soso ŋuro mepéye rero khumoweya ŋuko meté,” yaró. ");
INSERT INTO nca_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Asa Saimon-Pita koya iŋo-iŋo rewero uni kaya Yesu howero uyaririyó. O qa-qa unindoro tapá uni ŋundo iŋo-iŋo rewero uni meyowo ŋu iŋo inaró. Ŋunde ŋuroko uni ŋu Yesu howero tapá unindoro hoŋgo quroko oró. ");
INSERT INTO nca_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Oní Pitako yendémo mako sumeyo kutaqe kunditeyaró. Kunditiní iŋo-iŋo rewero uni meyowo ŋu sunará pare mako sopoyara ŋu mitoro Pita re hoŋgo quroko oró. ");
INSERT INTO nca_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Oní pare mako sopoyara ŋundo Pita ŋande oseseyaró, “Kepe ŋuya uni ŋuro iŋo-iŋo rewero uniyómbe, ma kini?” Yiní Pitako ŋande yaró, “Kini,” yaró. ");
INSERT INTO nca_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Sunará simómboya sopo-sopo unindoya seno tero te qaro roko kaŋeyaŋgurí. Quno ŋuno Pita ŋuya ŋuno rokoyara. ");
INSERT INTO nca_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Asa o qa-qa unindoro tapá uni ŋundo Yesu eneŋo iŋo-iŋo rewero uniyó ŋuro oseseyoro mande rondaqe uni yunoyara ŋuro oseseyaró. ");
INSERT INTO nca_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ŋunde oseseyoníqo, Yesuko mande topé ŋande yaró, “No tunomo mande rondaqe yunoyano. Naru rokóŋo huru-huru ya kumimo ko Ya Surumímo mande rondaqe yunoyano, asa Juda uni soso kopoyaŋgo quno ŋuno rondaqe yunoyano. Mande yeyano ŋuko sóqero kama yeyano. ");
INSERT INTO nca_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Asa ko do murí karo ŋandiro osese nereyote? Uni mande iŋaŋgurí ŋu osese yere. Ŋundo ta mande yeyano ŋu iŋoyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ŋunde yiníqo, sopo-sopo uni ŋuno qu kato Yesu kakí tamoro ŋande yaró, “Ŋu date tero tapá uni ŋuro mande topé ŋunde yete?” ");
INSERT INTO nca_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yiní Yesuko mande topé ŋande yaró, “Ko no mande piyimi mu yeteno tiníkaqo, o koroqe ŋuro yesowoyi. Quko mande meté mu yeteno tiníqo, do murí karo no nurote?” ");
INSERT INTO nca_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ŋunde yiní Anasko Yesu riní o qa-qa unindoro tapá uni Kaiapasko uyaró. Quko utó re kusiyaŋgurí ŋuko kama orosoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Asa Saimon-Pita kewáko kaŋero rokoyoní uni kumimbo ŋande oseseyaŋgurí, “Kepe ŋuya uni ŋuro iŋo-iŋo rewero uniyómbe, ma kini?” yaŋgurí. Yiqo, wawa mande ŋande yaró, “Ŋuko no kini.” ");
INSERT INTO nca_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Quko tapá unindoro sunará simó ka, ŋuko Pitako uni kusumbí takaró ŋuro suwisawi qu, ŋundo ŋande yaró, “Ke khono yuriqo, kiyanowó, hamómbe?” ");
INSERT INTO nca_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Yiníqo, Pitako pitu ko wawa mande ka yaró. Ŋunde yiníqo, kotori ka yaró. ");
INSERT INTO nca_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Asa Juda koro uni kembé-kembémbo Yesu rero Kaiapasko ya qu rotoro rero Rom unindo mira ŋu wiri yereyaró ŋuro yano uyareŋgurí. Ŋuko ita saraŋoní horé ko ŋande iŋaŋgurí, “Yate nore Anutu toŋímo pusú teroqo nore Taka yereró naru koro o ne-ne ŋu newero mepémo kini,” ye iŋaŋgurí. Ŋunde ŋuroko yano kama oŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Asa ko Pailatko umburo ŋande osese yereró, “Ye do murí karo uni ŋa re mande khono rotowero teteŋgo?” ");
INSERT INTO nca_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Yiní mande topé ŋande yaŋgurí, “Qeno, enendo o piyimi horé taró. Ŋunde ŋuroko nore re keno maheteto ŋu.” ");
INSERT INTO nca_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ko Pailatko ŋande yimiraró, “Yeŋombo naŋge re uyareya yeŋo hutuŋo mandeye moŋgo rondaŋi.” Yiní mande topé ŋande yaŋgurí, “Nore uni ka rondaŋero rero urato khumoweya ŋuro mepémo kini.” ");
INSERT INTO nca_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ŋundiro naŋge Yesuko khumoweya ŋuro murí komo mande yaró ŋu riní hamó taró. ");
INSERT INTO nca_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Asa Pailatko rohoréŋoro yano oro Yesu nekoní mahiní ŋande oseseyaró, “Kepe Juda uniparetoro wiri yerete uni ŋumbe, ma kini?” ");
INSERT INTO nca_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesuko mande topé yaró, “Keŋombo naŋge osese ŋu tetepe, ma uni kumimbo nenemboro kimiraŋgurí?” ");
INSERT INTO nca_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Yiní ŋande yaró, “Date koro? Nombe Juda uni ka peka? Keŋo sitú topokepoya o qa-qa unindoro tapá unindoya ke korero nono maheteŋgo. Ke do taró?” ");
INSERT INTO nca_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yiníqo, mande topé ŋande yaró, “Nondo unipare wiri yereyote narune muko noko ŋaro qu kini. Ŋuko noko ŋaro qu tiníqo, uninembo kuma ti Juda koro uni pará-parámbo kama nondowowaŋgo. Quko nondo wiri yerete unindoro owé parámi ranowó ŋuko noko koro qu kini.” ");
INSERT INTO nca_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Yiní Pailatko oseseyaró, “Asa ko kepe hamó wiri yerete uni qu ka?” Yiní ŋande yaró, “Keŋombo yete ŋu, no wiri yerete uni qu ka. Námembo pisi niriní nokono mahenowó ŋuro murí muko ŋandiro: mande hamó mu yeyowero mahenowó. Unipareto o hamó quro niŋgu-niŋgu teyoteŋgo ŋuko maŋgone howeyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Yiní Pailatko ŋande oseseyaró, “Mande hamó mu, ŋu do ka?” Asa Pailatko ŋunde yero rotoro pitu ko Juda koro uni pará-pará ŋuno uro ŋande yimiraró, “Nondo o koroqe eneno kama qeneteno. ");
INSERT INTO nca_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Quko yeŋo muríye ŋandiro: Taka yereró quro o ne-ne koro naruko ŋuno, ye uni kanata ka kusi-kusi yano yaró ŋu owí nekoyiqo, nondo uni ŋu rotowe yeno uyareweya. Asa ko ye date iŋoteŋgo, no Juda uniparetoro wiri yerete uni ŋa rotowanope, ma kini?” ");
INSERT INTO nca_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ko ŋande kiwe miraŋgurí, “Ŋunde kini! Ke Barapas naŋge rotoka toŋiní!” Komo Barapas wiri yerete unindoro hutuŋo mande wendaqero kuma taró. ");
INSERT INTO nca_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Asa Pailatko mande yiní kuma unindo Yesu re haususuworo uraŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kuma unindo utó kamí moré qu ka wakaro wiri yerete unindoro takapu qembe toworo kembémo raŋgurí. Ko tuwi mandumi huririyó re kowí punuwaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Punuworo taŋgímo maheyoro ŋande yeyaŋgurí, “Juda koro wiri yerete uni, ke mahete ŋu!” yero kakí tamaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Asa Pailat pitu ko yendémo uro Juda uni ŋande yimiraró, “Qeni, uni ŋu re yendémo yeno umbuwe teteno. Umbuníqo, ŋande iŋoyi, nondo o koroqe ka eneno kama qeneteno.” ");
INSERT INTO nca_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ŋunde yero oro Yesu riní yendémo umburó. Ko takapu utó kamí moré qu kembémo ŋuno yora. Ko kowe punu-punuyó mandumi ŋu ŋuya punuwaró. Asa ko Pailatko ŋande yimiraró, “Qeni. Ŋako uni ŋuno qu,” yaró. ");
INSERT INTO nca_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Yiní o qa-qa unindoro tapá unindoya eneŋo sopo-sopo unindoya qenero kondé ŋande kiwero yaŋgurí, “Re tipiririko uroyi! Re tipiririko uroyi!” yaŋgurí. Ŋunde yiqo, Pailatko ŋande yimiraró, “Yeŋombo na reya tipiririko uroyi. No neneŋombo o koroqe ka eneno kama qeneteno,” yaró. ");
INSERT INTO nca_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Quko Juda koro uni pará-parámbo mande topé ŋande yaŋgurí, “Noreŋo hutuŋo mandenani howeyoteto, ko hutuŋo mande ŋuko ŋande nimirote, uni ŋu urika khumoní, yete. Dokoro, enendo ŋande yaró, ‘Noko Anutu koro Naŋuní,’ yaró.” ");
INSERT INTO nca_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ŋunde yi Pailatko ŋu iŋoro hamó sasaro parámi taró. ");
INSERT INTO nca_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ŋunde tero pitu ko yano oro Yesu ŋande oseseyaró, “Ke yendé da noŋgo qu?” Quko Yesuko mande topé ka kama yaró. ");
INSERT INTO nca_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Asa ko Pailatko ŋande miraró, “Date koro? Kepe mandene topé kama yewero ŋuro, hamómbe? Noko ke kina korotowero quro wimbune moré, ko kore tipiririko kurowero quro wimbune moré. Kepe ŋumbe iŋotepe ma kini?” ");
INSERT INTO nca_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ko Yesuko mande topé ŋande yaró, “Anutu koreko yote ŋundo ke wimbu kama kunoníqo, asa keto no taka nerewero mepémo kini. Ŋunde ŋuro unindo no keŋo kandekemo norota ŋuro quhuríŋo ŋuko keŋo quhuríŋge ŋu takate.” ");
INSERT INTO nca_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ŋunde yiníqo, Pailatko yendémo uro Yesu kina rotowero quro khe ka seqaró. Quko Juda unindo kondé ŋande yaŋgurí, “Ke uni ŋu kina roti toŋeweya tiníqo, keko Sisa koro topé kini. Uni kato, no wiri yerete uni yoteno, yeyote ŋuko Sisa koro saŋgiríŋo.” ");
INSERT INTO nca_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Yiqo, Pailatko iŋoro Yesu re yendémo umburó. Ŋunde tero mira ka owí muko, “Wondo Kuhú,” yero nekoyaŋgo ŋuno mande kho inowero yakutímo ŋuno kunditaró. (Mira ŋu Aram mandewore owí ŋuko “Gapata” yeyaŋgurí.) ");
INSERT INTO nca_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ŋu naru ŋuko Taka yereró quro o ne-ne ŋuro Roŋgaruwowero kosa naru qu, kosa keweroko ŋundiro. Asa Pailatko kunditero Juda koro uni pará-pará ŋande yimiraró, “Yeŋo wiri yerete uniye qeni.” ");
INSERT INTO nca_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Yiní kiwero kondé ŋande yaŋgurí, “Ŋu rika toŋiní! Ŋu rika toŋiní! Re tipiririko uroyi!” Ko Pailatko ŋande osese yereró, “Yembe, nondo yeŋo wiri yerete uniye rero tipiririko urowano, yero iŋoteŋgo?” Yiní o qa-qa unindoro tapá uni ŋundo mande topé ŋande yaŋgurí, “Noreko wiri nerete uninani kanata ŋuna. Ŋuko Sisa naŋge!” ");
INSERT INTO nca_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ŋunde yi Pailatko iŋo-iŋoye howero Yesu tipiririko urowero re rotoní kuma unindo sopoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Asa Yesu eneŋombo tipiriri re koroworo yendé rotoro mira ka owí Kembémboro Wimbí ŋuro mira yeyaŋgurí quno ŋuno toŋeró. (Mira ŋu Aram mandewore owí ŋuko “Golgota” yeyaŋgurí.) ");
INSERT INTO nca_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Asa ŋunoko Yesu re tipiririko uraŋgurí. Utoro uni irisa ŋuya se tipiriri irisa kawore-kawore quno ŋuno poro yerero Yesu re keweroko porowaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Asa ko Pailatko yiní mande piŋa nakayáŋoro tipiriri sombémo raŋgurí. Mande ŋuko ŋandiro: Yesu, Nasaret yendé moŋgo qu, Juda Uniparetoro Wiri Yerete Uni ŋu. ");
INSERT INTO nca_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Pailatko yiní Aram mandewore, Rom mandewore, Grik mandewore mande ŋu nakayáŋaŋgurí. Mira ŋuno qu Yerusalem kutaqemo yora. Ŋunde ŋuro Juda uni qambu mahe mande ŋu weyoro qeneŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","O qa-qa unindoro tapá uni ŋundo qenero Pailat ŋande miraŋgurí, “Ke, ‘Juda Uniparetoro Wiri Yerete Uniye,’ ŋunde ma nakayáŋowero. Kini, ŋande nakayáŋo, ‘Uni ŋando ŋande yeyara, “Noko Juda Uniparetoro Wiri Yerete Uniye.”’” ");
INSERT INTO nca_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Quko Pailatko mande topé ŋande yaró, “Ma. Mande ŋu komo nakayáŋano ŋunde yoní.” ");
INSERT INTO nca_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kuma unindo Yesu re tipiririko uraŋgurí quno eneŋo kowe punu-punuyó soso rondaŋi nimí kini tiní siyaŋgurí. Ŋunde tiqo, kumba newondímo ŋu naŋge yaró. Kumba newondímo ŋu uni kato sirowoyómbo kanata naŋge towaró. ");
INSERT INTO nca_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ŋunde ŋuroko kuma unindo ŋande epe mito-mito taŋgurí, “Nore kumba newondí ŋu re kama romboŋewato. Kini, kundo ka tero uni dando reweya ye qeneto.” Ŋunde tiqo, komo suki mande sokomeko ŋuno nakayáŋaró qu ka mepémo taŋgurí. Mande ŋuko ŋandiro: “Neneŋo kowe punu-punune rondaŋe siyaŋgurí. Ko siyowero quro kundo ka taŋgurí.” ");
INSERT INTO nca_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Asa Yesu koro nimímboya Kilopasi parí, owí muko Maria, koya Maria Maktala yendé moŋgo, soso ŋu Yesu koro tipiririyó roroworo kaŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ŋuno kaŋi Yesuko nimímboya iŋo-iŋo rewero uni kaya yiyaró. Yesuko iŋo-iŋo rewero uni ŋu hamó iŋoyara. Irisa ŋu kutaqemo kaŋariyó. Asa Yesuko nimí ŋande miraró, “Pare, itaka uni ŋuko keŋo naŋoŋge.” ");
INSERT INTO nca_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Yero iŋo-iŋo rewero uni ŋu ŋande miraró, “Itaka pare ŋuko keŋo náŋge.” Ko ŋu naru koŋgo iŋo-iŋo rewero uni ŋundo pare ŋu re yayómo oro sopoyaró. ");
INSERT INTO nca_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Tukú Yesu ŋande iŋaró, khoyó ŋu soso kini taró. Ko komo suki mande sokomeko ŋuno nakayáŋaró qu ka mepémo tewero quro ŋande yaró, “Puŋene harete.” ");
INSERT INTO nca_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kumbe wain oŋgomi maŋgoraró qu ka kutaqemo yora. Asa ŋunde yiní uni kato o piwo qembe ka rero wain oŋgomi ŋuno quroko riní maŋgoriní hisop kambinímo kusiyoro Yesu koro maŋgómo hokaró. ");
INSERT INTO nca_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu niní kini tiní ŋande yaró, “Kini tete.” Ŋunde yero kondéqero yuqayó roto khumaró. ");
INSERT INTO nca_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Naru ŋuko Sapat koro roŋgaruwowero naru, ko suwo tiníqo, Sapat naru parámi ka teweya. Juda unipareto ŋande ye iŋaŋgurí, Sapat naru ŋunde quno uni tipiririko yuraŋgurí ŋu ŋuno yoweya ŋu meté kini. Asa ko Pailat mitoro ŋande yaŋgurí, “Uni tipiririko ŋuno yoteŋgo ŋu kheye utaqikata waka ta khumika yore umbu yoroti,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Asa kuma uni ŋundo uyaro uni korete qu Yesu koya tipiririko uraŋgurí ŋu khí utaqaŋgurí. Utaqero meyowo ŋuya khí utaqaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Quko Yesuko komo khumaró. Khumoní qenero khí kama utaqaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kini, kuma uni kato taŋgí kasina saŋgapo saŋgawaró. Saŋgawoní waka ta sitú koya sono koya umburó. ");
INSERT INTO nca_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Uni kato ŋu qeneró, enendo ŋuro yesowo yaró. Ko mande yaró ŋuko hamó. Enendo ŋande iŋote, mandí ŋuko hamó naŋge. Ŋunde ŋuro ye ŋuya meté iŋondutu tewaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","O tunoqaró ŋundoko komo suki mande sokomeko ŋuno nakayáŋaró qu ka riní hamó taró. Mande ŋuko ŋandiro, “Eneŋo wimbí ka kama utaqewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ko mande meyowo, ŋuko ŋandiro, “Uni ene saŋgawaŋgurí ŋu qenewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tukú Josep, Arimatea yendé moŋgo uni kato Pailatko uyaro Yesu koro ukúŋo rewero quro kirayaró. Josep ŋuko Yesu koro iŋo-iŋo rewero uniyó ka, quko ene Juda koro uni pará-parámboro sorero iŋondutuyó tapuŋaró. Asa Pailatko, “Iyo,” yiní Josep uyaro Yesu koro ukúŋo re umburó. ");
INSERT INTO nca_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemusko eneya ukúŋo re umbuwero uyaririyó. Komo Nikodemus suwono Yesu koya kunditero mande yariyó. Enendo oka nuŋgurí qambu se uyaró. O nuŋgurí ŋuko te sitúmi enesó-enesó rohoréŋaŋgurí qu, ko quhurí muko kilo 30 ŋundiro. ");
INSERT INTO nca_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Asa Josep koya Nikodemus koya Yesu koro ukúŋo re umburiyó. Rero Juda uniparetoro ukúyemboro muríye howero o nuŋgurí ŋu tuwi kekere sara-sara ka rero tuwipo Yesu ukúŋo wiwiyariyó. ");
INSERT INTO nca_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesu tipiririko uraŋgurí quno ŋunoko kho ka kutaqemo yora. Ko khono ŋunoko uni tapu ka yora, ŋuko uni ukú ka re ŋuno kama reyaŋgo qu. ");
INSERT INTO nca_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ŋu naru ŋuko Juda uniparetoro Roŋgaruwowero Naru qu, ko uni tapu ŋu kutaqemo yora. Ŋunde ŋuro uni irisa ŋu Yesu koro ukúŋo re uya uni tapuko ŋuno rariyó. ");
INSERT INTO nca_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Asa sonda koro naru korete quno, suwo-suwono ŋuno Maria Maktala yendé moŋgo ŋu uni tapuko ŋuno maheró. Mahero wondo uni tapu makoyó wisumuŋaró ŋu re rotowí qene iŋaró. ");
INSERT INTO nca_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ŋunde qenero waka ta kheŋgeŋo Saimon-Pita koya iŋo-iŋo rewero uni Yesuko ŋuro hamó iŋoyara quya ŋuno uyaró. Uyaro ŋande yimiraró, “Uni kato Uni Parámi uni tapu koŋgo raŋgurí, quko ene ŋu re dana rotaŋgurí ŋu kama iŋoteto.” ");
INSERT INTO nca_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ŋunde yiníqo, Pita koya iŋo-iŋo rewero uni meyowo ŋuya yendé rotoro uni tapuko uriyó. ");
INSERT INTO nca_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Irisa-irisa kheŋgeŋo uriyó, quko iŋo-iŋo rewero uni meyowo ŋundo Pita takaro waka ta uni tapuko uró. ");
INSERT INTO nca_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Uro kondéqero uni tapu quroko ŋuna toŋetiní tuwi meté mu kinaŋge ŋuno yoní qeneró. Quko enendo ŋuro quroko kama oró. ");
INSERT INTO nca_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saimon-Pita enepa tukú mahero uni tapu quroko oró. Oro tuwi meté mu ŋuno yoní qenero ");
INSERT INTO nca_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","tuwi eneŋo umu-kembé ŋu pokamaró ŋuya qeneró. Umu-kembémboro tuwi ŋu andusina roneneŋo wakawí yora. ");
INSERT INTO nca_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Asa iŋo-iŋo rewero uni meyowo koretero uni tapuko maheró ŋuya quroko oró. Oro qenero iŋondutuwoyaró. ");
INSERT INTO nca_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Ŋu naruko ŋuno naŋge iŋondutuwoyaró, dokoro komo, sokomeko ŋuno nakayáŋaŋgurí ŋu kama iŋori tondaŋaró, ko Yesu uni tapu koŋgo otoqoweya ŋu kama iŋori tondaŋaró.) ");
INSERT INTO nca_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Asa qene rotoro rohoréŋoro yayarimo toŋiriyó. ");
INSERT INTO nca_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Toŋiri Maria kutaqemo uni tapuko ŋuno kaŋero tendoyaró. Tendo yate kondéqero uni tapu quroko ŋuna toŋetaró. ");
INSERT INTO nca_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Toŋetero sambo simó irisa tuwiyari sara piyimi qu ŋuro quroko ŋuno yiyaró. Sambo simó irisa ŋu Yesu ukúŋo komo yora quno ŋuno kunditeyariyó, kato kembé mepémo kunditiní, kato khí mepésina kunditaró. ");
INSERT INTO nca_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Kunditero Maria ŋande oseseyariyó, “Pare, ke do karo tendoyote?” Yiri ŋande yimiraró, “Uni kato neneŋo Uni Parámine re dano rotaŋgo ŋu kama iŋoteno.” ");
INSERT INTO nca_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ŋunde yero rohoréŋoní Yesu ŋuno kaŋeyoní qeneró. Quko enendo Yesu kama qene iŋaró. ");
INSERT INTO nca_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Asa Yesuko ŋande oseseyaró, “Pare, ke do karo tendoyote? Ke dani seqayote?” yaró. Mariako, ŋuko mira ŋaro sopo-sopo uni ka, yero iŋoro ŋande miraró, “Awa, keto ene re toŋete tiníqo, meté dano rete ŋu witú nereka no uro rewano.” ");
INSERT INTO nca_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesuko ŋande yaró, “Maria.” Yiní rohoréŋo Aram mandewore, “Raponi,” yaró. (Mande “Raponi” ŋuko ŋandiro, “Rondaqe-rondaqe Uni.”) ");
INSERT INTO nca_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ko Yesuko ŋande miraró, “Ma nondowowero, dokoro nondo Awanemo kama ono. Neneŋo topo-toponemo uya ŋande yimito, no Awane, yeŋo Awayemo ŋuno oteno, asa neneŋo Anutune, yeŋo Anutuyemo ŋuno oteno.” ");
INSERT INTO nca_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ŋunde yiní Maria Maktala yendé moŋgo ŋundo uyaro iŋo-iŋo rewero uni ŋu ŋande yimiraró, “Nondo Uni Parámi qeneteno!” Ŋunde yero mande soso ene miraró ŋu yimiraró. ");
INSERT INTO nca_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Asa sonda naru korete quno suwono ŋuno, iŋo-iŋo rewero uni ŋundo ya kano kopaŋgurí. Koporo mako tuŋoro kusiyaŋgurí, dokoro Juda koro uni pará-parámboro soraŋgurí. Ŋuno yuriqo, Yesu tunoqero keweroyemo ŋuno kaŋero ŋande yaró, “Newondeye ime yuri.” ");
INSERT INTO nca_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ŋunde yero, kandí, taŋgí se witú yereró. Witú yiriní qenero niŋgu-niŋgu taŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesuko pitu ko ŋande yimiraró, “Newondeye ime yuri. Awando no asá niriní mahenowó. Asa ŋundiro nopa naŋge ye asá yerewe toŋewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ŋunde yero maŋgó moŋgo yuqa raŋoro ŋande yimiraró, “Ye Yuqa Surumí qu ri. ");
INSERT INTO nca_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Asa ye uni karo quhuríŋo re rotowaŋgo quko quhuríŋo kini teweya. Ko ye quhuríŋo kama re rotiqo, quhuríŋo ŋuko watí yoweya.” ");
INSERT INTO nca_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ŋu naruko ŋuno uni topoye ka, owí muko Tomas (owí kako Ditimus), ŋuko eneya kama yora. ");
INSERT INTO nca_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Imemoŋgo uni topémbo ŋande miraŋgurí, “Nore Uni Parámi komo qeneto.” Quko Tomasko ŋande yimiraró, “No koretero kandímo tisi ŋuro mepé qenero, kandene pusirí raŋowe kandí tisi ŋuro mepé qurowore uní, kandene raŋowe taŋgímo saŋga ŋuro mepé qurowore uníqota, iŋondutuwowano. Quko ŋundiro kama teroqo no kama iŋondutuwowano.” ");
INSERT INTO nca_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tukú, sonda awena, Yesu koro iŋo-iŋo rewero uni pitu ko ŋuno yaŋgurí, ko Tomas ene ŋuya ŋuno yaró. Mako soso tuŋomukaŋgurí, quko Yesu tunoqe keweroyemo kaŋaró. Kaŋero ŋande yaró, “Newondeye ime yuri.” ");
INSERT INTO nca_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ŋunde yero enendo Tomas ŋande miraró, “Ke maheya kandeke pusirí ŋano reya kandene qeno. Ko kandeke re taŋgenemo ŋano re. Iŋondata ma tewero, iŋondutu te.” ");
INSERT INTO nca_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ko Tomasko mande topé ŋande yaró, “Keko neneŋo Uni Parámine, keko neneŋo Anutune.” ");
INSERT INTO nca_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yiní ŋande miraró, “Keto niyote, ŋunde ŋuro iŋondutu tete. Uni ka no kama niyote quko iŋondutu tewaŋgo ŋuko puriŋo ka rewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesuko wimbímboro rokó parámi meyowo iŋo-iŋo rewero uniyómboro toŋeyemo taró ŋuro sokomeko ŋano kama nakayáŋanowó. ");
INSERT INTO nca_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Quko mande ŋa nakayáŋanowó ŋuko, yendo weyo ŋande iŋondutu tewaŋgo, ko Yesu ŋuko Kristo ŋu, Anutu koro Naŋuní. Asa ko iŋondutu ŋunde teroqo eneŋo owímo yoto-yoto rewaŋgo. ");
INSERT INTO nca_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Asa imemoŋgo Yesu Taiperius Sono Towoko ŋuno tunoqiní eneŋo iŋo-iŋo rewero uniyómbo qeneŋgurí. Sowo mande ŋuko ŋandiro. ");
INSERT INTO nca_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ŋu naruko ŋuno Saimon-Pita koya Tomas (owí kako Ditimus) koya Nataniel, uni Galili mira Kana yendé moŋgo quya Sepeti koro naŋuní irisa koya iŋo-iŋo rewero uni irisa meyowo ŋuya kopo yoraŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Asa Saimon-Pitako ŋande yimiraró, “No sono qare seqawero toŋeteno.” Yiní ŋande yaŋgurí, “Nore soso keya uwato.” Ŋunde yero soso waŋgoko oŋgurí. Oro sono qare seqa yaŋgurí, quko suwo saŋga ŋa sono qare ka kama siyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Yate kosa ariní Yesu sono towo tapémo andusina kaŋeyaró, quko enendo Yesu kama qene iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Asa ŋande kiwe osese yereró, “Topo-topone, yembe sono qare ka kama siyaŋgo, peka?” Mande topé ŋande yaŋgurí, “Iyo.” ");
INSERT INTO nca_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yiqo, ŋande yimiraró, “Ye kandeye kondésina tirí-tirí rotika uníkata kumi siyowaŋgo.” Ŋunde ŋuro tirí-tirí ŋuno raŋoyi uró. Uníqo, sono qare parámi horé siyaŋgurí. Ŋunde tero tirí-tirí wosoro waŋgo quroko mahewero quro rukusuwaŋgurí. ");
INSERT INTO nca_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Asa iŋo-iŋo rewero uni Yesuko ŋuro hamó iŋoyara ŋundo Pita ŋande miraró, “Ŋuko Uni Parámi ŋu naŋge.” Saimon-Pita mande ŋu iŋoro kowe punu-punuyó komo re rota ŋu rero punuworo sono towo tapémo uyarewero sonono sorero uró. ");
INSERT INTO nca_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ko uni kumi muko waŋgo saŋawore tirí-tirí maŋgoriní woso maheŋgurí, dokoro kapiyamo kama yoraŋgo, mita 100 ŋunde naŋge yoraŋgo. ");
INSERT INTO nca_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tapémo mahi kewá ka qaní qeneŋgurí. Sono qare kumi kewá saŋano ŋuno yora, ko bret ŋuya ŋuno yora. ");
INSERT INTO nca_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Asa Yesuko ŋande yimiraró, “Sono qare itaka siyoteŋgo ŋuno qu kumi ka se mahi.” ");
INSERT INTO nca_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saimon-Pita waŋgoko uro tirí-tirí wosoní tapémo oró. Sono qare pará-pará qu tirí-tirímo maŋgoreyaró. Sono qare 153 ŋundiro ŋuno yaŋgurí. Sono qare qambu horé ŋuno yaró, quko tirí-tirí ŋu kama wuriró. ");
INSERT INTO nca_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Asa Yesuko ŋande yimiraró, “Ye mahe o ni.” Ko uni keweroyemo kato ŋande kama oseseyaró, “Ke dani?” Dokoro komo qene iŋaŋgurí, ŋuko Uni Parámi ŋu naŋge. ");
INSERT INTO nca_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Asa Yesuko te taŋgímo mahero bret rero yunaró. Sono qare ŋuya se yunaró. ");
INSERT INTO nca_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesu uni tapu koŋgo areró quro naruyó moŋgo iŋo-iŋo rewero uniyómbo naru kapusako qeneŋgurí. Sono towo tapémo ŋuno naru kapusayó naŋge. ");
INSERT INTO nca_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Asa o ni kini tiní, Yesuko Saimon-Pita ŋande oseseyaró, “Saimon, Jon koro naŋuní, uni ŋando newonde meté nunoyoteŋgo, quko kepe taka yerero newonde meté parámi nunoyotepe ma kini?” Yiní Pitako ŋande yaró, “Iyo, Uni Parámi, ke iŋote, no newonde meté kunoyoteno.” Ŋunde yiní ŋande miraró, “Neneŋo sipsip simóne wutu yere qembe.” ");
INSERT INTO nca_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Naru irisayómo ŋuno Yesuko kaŋuya ŋande oseseyaró, “Saimon, Jon koro naŋuní, kepe newonde meté nunoyotepe ma kini?” Yiní ŋande yaró, “Iyo, Uni Parámi, ke iŋote, no newonde meté kunoyoteno.” Yiní ŋande miraró, “Neneŋo sipsipne sopo yere qembe.” ");
INSERT INTO nca_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Asa ko naru kapusayómo ŋuno Yesuko ŋande oseseyaró, “Saimon, Jon koro naŋuní, kepe newonde meté nunoyotepe ma kini?” Naru kapusayómo ŋuno, “Kepe newonde meté nunoyotepe ma kini?” ŋunde yiníqo, Pitako newonde quhurí taró. Ŋunde tero ŋande miraró, “Uni Parámi, keko o soso iŋomukote. Asa ko ke iŋote, no newonde meté kunoyoteno,” yaró. Yiníqo, Yesuko ŋande miraró, “Neneŋo sipsipne wutu yere qembe. ");
INSERT INTO nca_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","No hamó horé ke kimiroteno, komo, simó yaró ŋunoko, ke keŋombo kowe punu-punuke re punuworo dano uyarewero iŋoyara ŋuno uyareyara. Quko ke koŋgomu teweya quno ŋuno kandeke raŋi uni meyowo katoko kowe punu-punu re punuworo korero mira kano uweya. Quko ene nuŋguríŋge kama howiní ŋuno uweya.” ");
INSERT INTO nca_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesuko mande yaró ŋuko imemo Pitako date khumoro owé parámi Anutu inoweya ŋuro yaró. Ŋunde yero ŋande miraró, “Ke no nohowe,” yaró. ");
INSERT INTO nca_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ŋu naruko ŋuno ŋu iŋo-iŋo rewero uni Yesuko hamó iŋoyara ŋundo yohowe maheró. (Komoko uni ŋuko o ne-ne ŋuno saŋáqero kembé re mahero Yesu nomonímo kutaqe rero ŋande oseseyaró, “Uni Parámi, danimboko ke kore uni piyimi kandeyemo korotoweya?”) Asa uni ŋu mahiní Pitako rohoréŋo qenero ");
INSERT INTO nca_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Yesu ŋande oseseyaró, “Uni Parámi, uni ŋuro date?” ");
INSERT INTO nca_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yiní Yesuko mande topé ŋande yaró, “Ko nondo ene meté yoní, yate pitu ko mahewano, yero iŋoteno tiníqo, ŋu keŋo o qu kini. Ke no nohowe.” ");
INSERT INTO nca_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ŋunde ŋuro uni topoko mande wimbo-wimbo ŋande yeyaŋgurí, ko iŋo-iŋo rewero uni ŋuko kama khumoweya. Quko Yesuko, ŋuko kama khumoweya, yero kama yaró. Kini. Ŋande yaró, “Ko nondo ene meté yoní, yate no pitu ko mahewano, yero iŋoteno tiníqo, ŋu keŋo o qu kini.” ");
INSERT INTO nca_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ŋu iŋo-iŋo rewero uni ŋundo itakako o soso ŋuro mande yesowo yeyote ŋu, ko enendo mande ŋa nakayáŋaró. Ŋako nore iŋoteto, mande yeyote ŋuko hamó naŋge. ");
INSERT INTO nca_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesuko o qambu kaŋuya taró. Quko uni kato o soso ŋuro sokome kumimo nakayáŋoweya tiníqo, sokome ŋundo noko soso ŋa riní maŋgoreweya. ");
INSERT INTO nca_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teopilus, komo nondo sokomeko sowo mande ka nakayáŋanowó. Sowo mande ŋuko ŋandiro: Yesuko hurí tero o qambu tero mande rondaqe unipare yunoro, ");
INSERT INTO nca_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","yate-yate Yuqa Surumíwore asá yerewí uni rokó yereró ŋu khoye ŋuro yimironí kini tiní Anutuko riní samboko oró. ");
INSERT INTO nca_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Koretero ene kowe surumí tero khumaró. Tukú pitu ko yoraró ŋu witú yerewero quro o qambu tero asá yerewí uni ŋuno tunoqe yunaró. Kosa naru 40 qurowore ŋuno Anutuko unipareyó wiri yereyote naruyó ŋuro yimiraró. ");
INSERT INTO nca_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Asa naru kano ene ŋuya o kopo naŋgurí quno ŋuno ŋande yimiraró, “Nondo komo Awando o meté yunowero mande kusiyaró ŋuro yimiranowó. Asa Yerusalem ma rotowero, o meté ŋu sopoyi qembe. ");
INSERT INTO nca_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Mande kusiyowí ŋuko ŋandiro, komo Jonko unipare yorero sono re yunaró. Quko naru tukuni naŋge Anutuko Yuqa Surumí ye re yunoweya,” yaró. ");
INSERT INTO nca_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ŋunde ŋuroko naru kano huruworo ŋande oseseyaŋgurí, “Uni Parámi, itaka naru ŋanope keto Israel yori eneŋo wiri yerete uniyembo naŋge pitu ko Israel unipare wiri yereweyape, ma kini?” ");
INSERT INTO nca_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ŋunde yi ŋande yimiraró, “Awa eneŋombo naŋge do naru o enesó-enesó qu tunoqeweya ŋu rokóŋaró. Ye naru ŋuro okeyá ta iŋowero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Quko imemoŋgo Yuqa Surumímbo mahero ye saŋayemo yotoro wimbu yunoweya. Ŋunde yunoní neneŋo muríne yesowowaŋgo. Yerusalem ŋuno, ko Judia, Samaria mira soso ŋuno, ko noko soso ŋuno yesowowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Asa Yesuko mande ŋu yiní kini tiní toŋetero qeni riní koreko oní koporéko wisumuŋaró. ");
INSERT INTO nca_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Oní wisumuŋoní samboko watí toŋeteyuriqo, waka ta naŋge uni irisa kutaqe ŋuno kaŋariyó. Uni irisa ŋu tuwiyari sara qu. ");
INSERT INTO nca_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Asa ŋuno kaŋero ŋande osese yiririyó, “Ye Galili uni, do karo kina kaŋero koreko toŋeteyoteŋgo? Yesu Anutuko riní yorotoro samboko ote ŋundo imemoŋgo ŋundiro naŋge pitu ko maheweya.” ");
INSERT INTO nca_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ŋunde yiníqo, mira purí Oliv ŋu rotoro pitu ko Yerusalem ŋuno uŋgurí. Mira purí ŋu Yerusalem taŋgímo ŋuno, asa kheyómboro piruyó ŋuko Sapat naruko khete uyarewero quro piruyó ŋundiro. ");
INSERT INTO nca_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Asa ya quroko oro wasa koreko quno ŋuno oro kundite sopoyaŋgo. Owéye muko ŋandiro: Pita, Jon, Jems ko Andru; Filip ko Tomas; Bartolomeyu ko Matyu; Jems, ŋuko Alipeus koro naŋuní; ko Saimon, ŋuko Selot koro wini qu ka; ko Jutas, ŋuko Jems koro naŋuní. ");
INSERT INTO nca_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ŋu uni ŋuya pare kumi ŋuya soso kondé kaŋero newonde kanata na tero hariri teyaŋgo. Ko Yesu koro nimí Maria, ko Yesu koro kone-topé, ŋu ŋuya mahero eneya hariri teyaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ŋu naruko ŋuno Pitako iŋondutu unipare keweroyemo kaŋero mande ka yaró. Qambuye ŋuko unipare 120 ŋundiro. ");
INSERT INTO nca_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","Asa ŋande yaró, “Uni topo, Jutas ŋuko noreya topo tero khonani ŋuya taró. Quko enendo khe witú yiriní unindo Yesu towaŋgurí. Ŋundiro naŋge mande ka sokomeko yote ŋu Yuqa Surumímbo komo Dewit maŋgó moŋgo yaró ŋu hamó tunoqaró,” yaró. ");
INSERT INTO nca_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Komo Jutasko o piyimi taró ŋuro kimoyó ŋu rero mira ka kimoro ŋuno rokaráŋoro nokono umbuní kowí kosaŋiní qahí soso huŋero nokono umburó. ");
INSERT INTO nca_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Uni soso Yerusalem yaŋgurí qundo ŋuro iŋaŋgurí. Ko mira ŋu eneŋo mandeko ŋande ye nekaŋgurí, “Akelitama,” yaŋgurí. Owé ŋuro murí muko ŋandiro, “Sitú Mira.”) ");
INSERT INTO nca_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Asa, Pitako ŋande yaró, “Hamó, komo suki mande ŋu Hariri Yambo koro sokomeko ŋande nakayáŋaŋgurí, “‘Yayó ŋu kina yoní, uni kato ŋuno ma kunditewero.’ “Ko mande kaŋuya ŋandiro, “‘Uni meyowo kato khoyó ŋu riní.’ ");
INSERT INTO nca_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Ŋunde ŋuro uni keweronanimo ka rokóŋatoka yoní. Rokóŋowato uni ŋuko Uni Parámi Yesu noreya uya mahe teyara naruko ŋuno yora, ");
INSERT INTO nca_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","asa Jonko sono re inaró qu noŋgo yate-yate Anutuko riní koreko oró, ŋu naru soso ŋuno norendo uni rokóŋowato ŋuko noreya yora. Eneya noreya Yesu uni tapu koŋgo pitu ko otoqaró ŋuro mande yesowoyowato.” ");
INSERT INTO nca_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Asa uni irisa rokó yereŋgurí. Kako Josep, ŋuko Barisapas ma Jastus nekoyaŋgurí. Ko uni kako Matias. ");
INSERT INTO nca_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ŋande hariri taŋgurí, “Uni Parámi, keto uni soso newondeye qene iŋoyote. Keto uni irisa ŋa dani ka rokóŋaró ŋu nore witú nereka ");
INSERT INTO nca_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Jutas koro mepé tero asáŋowí unindoro kho ŋa teweya. Jutasko kho ŋu huwóŋoro eneŋo yendémo toŋeró.” ");
INSERT INTO nca_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ŋunde yero mipu kumi raŋiqo, Matias koro mipu ŋu tunoqaró. Ŋunde ŋuro enendo asá yerewí uni 11 ŋuya kaŋaró. ");
INSERT INTO nca_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Asa Pentikos o ne-ne naruko ŋuno unipare soso ŋundo ya kano huruwaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Waka ta niri ka matú parámi ŋunde qembe tero sambo koŋgo mahero ya kunditeyaŋgo ŋu maŋgoraró. ");
INSERT INTO nca_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Maŋgoriní te suru qembe ka usoworo mipi ŋunde tero enemo-enemo saŋayemo kunditaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ŋunde ti Yuqa Surumí ŋundo unipare soso quroyemo uro wimbu yunoní kimani tero mipiyembo mande enesó-enesó yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ŋu naruko ŋuno Juda unipare mira enesó-enesó ŋu noŋgo mahero Yerusalem ŋuno yaŋgo. Juda unipare ŋu Anutu hamó potoruku te inoyaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Asa niri ŋu tunoqiní iŋoro mahe koporo mande enesó-enesówore yeyaŋgurí qu ŋu iŋaŋgurí. Yi iŋoro yukuwaŋgurí, dokoro eneŋo mandeye enesó-enesówore naŋge iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Iŋoro parámi newondeye uroní ŋande yaŋgurí, “Unipare ŋuko Galili noŋgo qu naŋge, hamómbe? ");
INSERT INTO nca_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Date koro nore mandenani enesó-enesówore ŋande ye iŋoteto? ");
INSERT INTO nca_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nore mira enesó-enesó rotoro ŋano mahetowó. Nore kumi Partia mira koŋgo qu, Mitia mira koŋgo qu, ko Elam mira koŋgo qu, ko kumi Mesopotemia mirako yoteŋgo qu; kumi Judia mira koŋgo qu ko Kapatosia mira koŋgo qu; kumi Pontus mira koŋgo qu ko Esia mira koŋgo qu; ");
INSERT INTO nca_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","kumi Pirikia mira koŋgo qu ko Pambilia mira koŋgo qu; kumi Isip mira koŋgo qu ko Lipia mirako Sairin yendé kutaqemo ŋu noŋgo qu; kumi Rom yendé ŋu noŋgo ");
INSERT INTO nca_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ŋuko Juda uniparetoya unipare meyowombo Juda koro muríye howeyoteŋgo qu; kumi Kiriti noko mosowí moŋgo qu ko Arepia mira koŋgo qu. Asa nore soso uni ŋu Anutuko kho wimbí ŋuro mandenaniwore yi iŋoteto.” ");
INSERT INTO nca_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ŋunde yero soso yukuwaŋgurí, ko newondeye uroní epe mito-mito taŋgurí, “O itaka tunoqete ŋuko, do murí ka?” ");
INSERT INTO nca_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Quko kumimbo huwó mande ŋande yaŋgurí, “Uni ŋu wain parámi nero kape-kape teteŋgo.” ");
INSERT INTO nca_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Asa Pita otoqoro asá yerewí uni 11 ŋuya kaŋero kondé nekoro unipare ŋande yimiraró, “Ye Juda uni, ko ye soso Yerusalem yoteŋgo qu, o tunoqiní qeneteŋgo ŋuro murí rondaqe yunowe teteno. Kusumbo re mandene iŋi. ");
INSERT INTO nca_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Yembe uni ŋambe wain koro kape-kape teteŋgo yero, hamómbe? Ŋu kini. Itaka ita saraŋoní 9 kilok naŋge. ");
INSERT INTO nca_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kini, o itaka tunoqete ŋaro, komo ye-ye uni ŋu Joel ŋundo ŋuro ŋande yaró, ");
INSERT INTO nca_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“‘Anutuko ŋande yete, “Naru weŋa qunoko neneŋo Yuqane windoroŋowe unipare soso saŋayemo uweya. Ŋunde tewe yeŋo nambo-simóyembo Anutu koro mandí yesowowaŋgo, yeŋo simó keta-keta ŋundoko o enesó-enesó qenewaŋgo, yeŋo uni pará-pará ŋundoko o quko qenewaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ŋu naruko ŋunoko no Yuqane windoroŋowe sunará simónemo, sunará parenemo ŋuro saŋayemo uweya. Ŋunde tewe Anutu koro mandí yesowowaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nondo o amana-mana siyowe koporéko tunoqewaŋgo. Nokono amu noŋgo rokó kate-kate siyowe tunoqewaŋgo. Sitú koya te qayote quya pukatutu parámi horé ŋuya tunoqewaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Uni Parámimboro naru parámi horé mu tukuni tiníqo kosako huriri qembe tunoqeweya, ko komboko mandumi sitú qembe tunoqeweya. ");
INSERT INTO nca_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ko Uni Parámimbo unipare soso owí nekoteŋgo ŋu rambaruru koŋgo yoreweya.”’ ");
INSERT INTO nca_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Ye Israel uni, mande ŋa iŋoyi. No Yesu, Nasaret noŋgo uni ŋuro yimiroteno. Ye ŋande iŋoteŋgo, ko Anutuko uni ŋuwore o wimbí moré enesó-enesó ye keweroyemo tero uni ŋuro owí hokaró. ");
INSERT INTO nca_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Komo suki Anutuko iŋoro mande kusiyaró, ko itaka uni ŋu re yeŋo kandeyemo rotoní uni hutuŋo mandenani kama howeyoteŋgo quro kandeyembo tipiririko uri khumaró. ");
INSERT INTO nca_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ŋunde quko Anutuko khumo koro wimbí ŋu re rotoro okokowoní pitu ko otoqaró. Dokoro uni tapu ŋundo ŋu towowero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Hamó, Dewitko ŋuya ŋuro ŋande yaró, “‘Nondo Uni Parámi qenewe taŋgenemo suki yote. Asa ko kandene kondésina yoníqo oka kato yuku nerewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ŋu murí ŋuro newondenembo meté yoweya, maŋgonembo niŋgu-niŋgu mande yeweya. Hamó, neneŋombo o meté horé ŋuro sopowano. ");
INSERT INTO nca_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Dokoro keto noroti uni khumowí ŋuro yendéyemo ŋuno kama yowano, keŋo uni meté horé ŋu roti uni tapuko ŋuno kama puqeweya. ");
INSERT INTO nca_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Yoto-yoto koro khe qu witú nereró, nori toŋeŋgemo niŋgu-niŋgu parámi tewano.’ ");
INSERT INTO nca_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Uni topo, no hamó iŋoro meté yimirowe teteno, ko usinani Dewit ŋundo mande ŋu nakayáŋaró, quko komo khumoní re tapuŋaŋgurí. Ko eneŋo tapuyó nore keweronanimo itaka yote. ");
INSERT INTO nca_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Dewit ŋuko ye-ye uni ka tunoqaró. Ŋunde ŋuroko komo Anutuko mande hamó ka ŋande miraró, ko imemoŋgo Dewit koro sowe qu kato eneŋo yakutímo kunditero unipare wiri yereweya. Asa mande ŋu iŋoro ");
INSERT INTO nca_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Kristo ŋundo pitu ko otoqoweya ŋuro ŋande yaró, ko Anutuko rotoní uni khumowí ŋuro yendéyemo ŋuno kama yoweya, kowí ŋu kama puqeweya. ");
INSERT INTO nca_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesu ŋuko, Anutuko okokowoní otoqaró ŋu. Nore ŋano qundo soso qenero ŋuro yesowoyoteto. ");
INSERT INTO nca_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Komo Anutuko Yuqa Surumí nore nunoweya ŋuro mande kusiyaró. Asa pitu ko otoqoníqo, Anutuko riní koreko horé oro Anutu koro kandí kondésina kunditero Awa kandí moŋgo Yuqa ŋu rero windoroŋoní ye o enesó ŋa qenero iŋoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Qeni, Dewit eneŋombo samboko kama oró. Quko ŋande yaró, “‘Uni Parámimbo uni parámine ŋande miraró, “Kandene kondésina ŋano kunditekata, ");
INSERT INTO nca_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","yate-yate saŋgiríŋge yorewe kheŋge kusuŋoyómo yowaŋgo.”’ ");
INSERT INTO nca_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Ŋunde ŋuro ye Israel koro sowe qu, ye meté iŋoyi. Yendo Yesu rero tipiririko uraŋgurí ŋuko, Anutuko riní Uni Parámi yote; ko Kristo ŋunde yote.” ");
INSERT INTO nca_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pitako ŋunde yiní mande ŋundo uniparetoro newondeye hamó saŋgawoní unipareto Pita koya uni asá yerewí unindoya ŋande osese yereŋgurí, “Uni topo, nore do ka tewato?” ");
INSERT INTO nca_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pitako ŋande yimiraró, “Ye kanata-kanata quhuríyemboro newonde surumí teya quhurí ŋu se rotoya Yesu Kristo owímo sono ri. Ŋunde tiqota Anutuko quhuríye se rotoro Yuqa Surumí rero yunoweya. ");
INSERT INTO nca_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Mande kusiyaró ŋu, Anutuko yeya, simóyemboya, unipare soso sewemo yotoro Uni Parámi ŋu, Anutunani nekoyoteŋgo ŋuya mande ŋu kusiyaró.” ");
INSERT INTO nca_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ŋunde yero Pitako oresaka mande kate-kate yero newondeye rukisoyoro ŋande yaró, “Anutuko unipare itaka nokono ŋano yotoro o pi-piyimi teyoteŋgo qu, ŋu rambaruru yereweya. Ye rambaruru ŋu takayi!” ");
INSERT INTO nca_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Asa ko danimbo eneŋo mandí ŋu hamó raŋgurí qu, sono re yunaŋgurí. Ko ŋu naruko ŋuno Anutuko iŋondutu uni sowe tiní unipare 3,000 kaŋuya iŋondutuwoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Naru rokóŋoro uni soso ŋundo asá yerewí uni mandeye iŋoyaŋgo, ko epe samaka-samaka teyaŋgo, bret romboŋero o kopo neyaŋgo ko hariri teyaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Asa Anutuko asá yerewí uni kandeyemo o wimbí moré qambu tiní unipare soso ŋundo qenero ará parámi te inaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Iŋondutu unipare soso ŋundo newonde kanata tero oye soso se kopoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Onoŋoye soso soweyoro wondo ŋu uni o karo tukuni taŋgurí ŋu yunaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Naru rokóŋoro newonde kanata tero Ya Surumímo ŋuno huruwoyaŋgo, ko ya kano-kano bret romboŋero newondeye meté tero niŋgu-niŋgu tero o kopo neyaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Naru rokóŋoro Anutu owí hokoyi unipare soso meyowo ŋundo eneŋo metéŋoyaŋgurí. Kowe naru rokóŋoro Anutuko unipare kumi yoriní iŋondutu tero ŋuno kopoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Asa naru kano Pita koya Jon koya hariri tewero naruko ŋuno, suwoya 3 kilok Ya Surumímo oriyó. ");
INSERT INTO nca_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ori kumimbo uni ka khí piyimi qu re koroworo ŋuno uyareŋgurí. Uni ŋuko, nimímbo khí piyimi ŋunde pisiyaró. Naru rokóŋoro topé-topémbo Ya Surumí makoyómo owí muko Kekere Qu ŋuno rotoyi kunditiní unipare Ya Surumímo oyiqo, wondo koro nekeyara. ");
INSERT INTO nca_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Asa uni ŋundo Pita koya Jon koya yiyoní Anutu koro Ya Surumímo ŋuno owero tiri, o koro kira taró. ");
INSERT INTO nca_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pita koya Jon koya kondé qenero Pitako ŋande miraró, “Ke toŋete nore niyo.” ");
INSERT INTO nca_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Yiní o siyowero quro yero iŋoro ene toŋetaró. ");
INSERT INTO nca_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Asa Pitako ŋande yaró, “No wondo silwape ma gol moré kini. Quko oka moré, ŋu re kunowe teteno. Yesu Kristo, Nasaret yendé moŋgo uni ŋuro owímo ke kimiroteno, otoqo kaŋe uyare.” ");
INSERT INTO nca_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Yero kandí kondésina towo hoko wosaró. Wosoní waka ta potó soso kondériní otoqaró. ");
INSERT INTO nca_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Otoqoro sore-sore tero irisa ŋuya Ya Surumímo khete-khete oro sore-sore tero Anutu owí hokoyaró. ");
INSERT INTO nca_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Unipare soso qeni otoqo kaŋero khete-khetero Anutu owí hokoyoní qenero ");
INSERT INTO nca_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ŋande iŋaŋgurí, uni ŋundo Ya Surumí makoyómo owí muko Kekere Qu ŋuno kunditero wondo koro nekeyara ŋuno qu. Ŋunde qene iŋoro o tunoqaró ŋuro iŋo-iŋoye enesó-enesó taró. ");
INSERT INTO nca_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Asa uni ŋundo Pita koya Jon koya yondoworo pisi yiriní unipare soso newondeye yukuwoní kheŋgeŋoro mahero Ya Surumímboro yokone ŋu owí muko Solomon koro Yokoneyómo ŋuno mahe kopaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Kopoyi Pitako yiyoro ŋande osese yereró, “Ye Israel uni, ye do karo iŋondata parámi teyoteŋgo? Do karo toŋetero nore niyoteŋgo? Yembeka ŋande iŋoyoteŋgo, nore irisa wimbunarimbope ma otetenari meté ŋundo uni ŋa riní meté tete, peka? Kini horé! ");
INSERT INTO nca_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham, Aisak, Yakop koro Anutuye, usisambananimboro Anutuye, ŋundo kho uniyó Yesu owí hokaró. Yendo kho uni ŋu rero uni saŋgirí kandeyemo rotaŋgurí. Pailatko rotowero ŋuro ye iŋaró, quko yendo sunará simó ŋu huwóŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yendo uni roneneŋowí ŋu, uni meté horé ŋu huwóŋoro yuroní khumowero uni ka rewero quro Pailat kirayaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Yendo uni ka nore soso yoto-yoto yunaró ŋu uri khumaró, quko Anutuko uni tapu koŋgo okokowoní otoqaró. Nore irisako ene otoqaró ŋuro iŋoro mande yesowoyotero. ");
INSERT INTO nca_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Uni ŋa ye qene iŋoyoteŋgo, ŋundo Yesu owímo iŋondutu tiní owé ŋundo wimbu inaró. Ko Yesuko iŋondutu inaró ŋundo uni ŋa riní yeŋo toŋeyemo meté tete. ");
INSERT INTO nca_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Asa, uni topo, no iŋoteno, yeya uni kembé-kembéye ŋuya kape-kape tero otete piyimi ŋu taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Komo Anutuko ye-ye uni soso maŋgoyemo ŋande yesowaró, ko eneŋo Kristoyó quhurí korowoweya. Asa ko yendo otete taŋgurí, ŋuko mande ŋu riní hamó tunoqaró. ");
INSERT INTO nca_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ŋunde ŋuro ye quhuríyemboro newonde surumí teya quhurí ŋu se rotika Anutuko quhuríye sowoní. ");
INSERT INTO nca_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ŋunde tiqo, Uni Parámimbo wimbu keta yunoro Kristo komo rokóŋaró ŋu, Yesu naŋge, asáŋoní yeno mahiní. ");
INSERT INTO nca_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Itakako samboko yotoro Anutuko o soso keta towoweya naruyó ŋu sopoyote. Anutuko komo suki ye-ye uni meté horé ŋuro maŋgoyemo ŋunde yaró. ");
INSERT INTO nca_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mosesko ŋuro ŋande yaró, ‘Uni Parámi ŋu, Anutuyembo ye-ye uni ka neneŋo qembe ye keweroye moŋgo riní otoqoweya. Mande soso yeyoweya ŋu iŋo howeyuri qembe. ");
INSERT INTO nca_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ko dani kato eneŋo mandí kama iŋo howeyoweya qu, Anutuko eneŋo unipareyó keweroye moŋgo howiní piyo teweya.’ ");
INSERT INTO nca_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Ko ye-ye uni soso, asa Samuel koŋgo yate-yate, ŋundo naru ŋaro mande yesowaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Anutuko usisambayemboya mande kondé rero Abraham ŋande miraró, ‘Keŋo soweke moŋgo unipare soso nokono ŋano qu puriŋo rewaŋgo.’ Asa yeko ye-ye unindoya uni mande kondé raŋgurí ŋuya ŋuro sowe qu. ");
INSERT INTO nca_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Anutuko sunará simóŋo rokóŋoro yeno koretero asáŋoní ye puriŋo yunowero maheró. Ŋunde yunoro yoriní newondeye rohoréŋoní oteteye piyimi horé ŋu rotowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Asa Pita, Jon irisa ŋundo mande yeyori o qa-qa unindoya Ya Surumímboro sopo-sopo uni ŋuya Sadyusi unindoya ŋuno uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Uni ŋundo irisa ŋuro piyimiŋaŋgurí, dokoro enendo unipare mande rondaqe yunoro, Yesu uni tapu koŋgo pitu ko otoqaró ŋuro yariyó. ");
INSERT INTO nca_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Asa suwo tiní ŋuno uyaro irisa ŋu yondoworo kusi-kusi yano yorotaŋgurí. Ŋuno yorika ita saraŋoníqota, ye iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Quko unipare qambu mandeyari iŋoro iŋondutu taŋgurí. Ŋundiro iŋondutu unipare qambuye ŋu sowe tero 5,000 kaŋuya taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ita saraŋoníqo, o qa-qa unindoro tapá unindoya uni kembé-kembémboya hutuŋo mande ŋuro iŋo-iŋo unindoya Yerusalem ŋuno kopaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","O qa-qa unindoro tapá uni Anas koya Kaiapas, Jon, Aleksanda ko tapá unindoro suwisawiyó kumi ŋuya ŋuno kopaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Asa Pita, Jon yorero keweroyemo yoroti kaŋiri ŋande osese yereŋgurí, “Yari wimbu da noŋgo rero ko danimboro owé ŋu rero o ŋu tari?” ");
INSERT INTO nca_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ŋunde yiqo, Yuqa Surumímbo Pita quroko maŋgoriní ŋande yimiraró, “Ye uniparetoro uni kembé-kembéye qu, ko ye uni pará-pará, ");
INSERT INTO nca_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","yembeka nore irisako uni khí piyimi ka o meté te inaro meté tete ŋuro osese nerewero nore ŋano noroti kaŋetero, hamómbe? ");
INSERT INTO nca_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Asa yeya Israel unipare soso ŋuya ŋande iŋoyi, Yesu Kristo, Nasaret yendé moŋgo uni ŋuro owímo uni ŋa meté tero itaka ye toŋeyemo kaŋete. Yendo Yesu rero tipiririko uraŋgurí, quko Anutuko uni tapu koŋgo okokowoní otoqaró. ");
INSERT INTO nca_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Eneko “‘wondo ŋuko ya re-re unindo ŋuro yaŋgurí, “Ŋu piyimi.” Quko ŋundo ya koro wondo korete-korete qu tunoqete.’ ");
INSERT INTO nca_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Uni meyowo kawore nore rambaruru kama takawato. Dokoro uni soso nokono yoteŋgo quro owí kato nore rambaruru koŋgo kama noreweya. Yesu koro owímo naŋge.” ");
INSERT INTO nca_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ŋunde yiní uni pará-parámbo ŋande iŋaŋgurí, ko Yesu koya yariyó naŋge, sokome yano oro iŋo-iŋo ŋundiro kama rariyó. Quko irisa ŋundo mande kondé yero sasaro kama tariyó. Ŋunde ŋuroko iŋondata parámi taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ko uni khí piyimi ŋu meté tero irisa ŋuya kaŋaŋgurí. Ŋunde ŋuro uni pará-parámbo mandeyari topé tewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Asa irisa ŋu yori huru-huru rotoro mirako uriqo, epe mito-mito tero ŋande yaŋgurí, ");
INSERT INTO nca_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Norendo uni ŋu do yerewato? Kho wimbí moré ka tari, ko unipare soso Yerusalem yoteŋgo qu iŋaŋgo. Re tapuŋowero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Quko mande ŋando unipareko wimbo uweya koro. Ŋunde ŋuro mande kondé eneya yatoqo, uni meyowo ka owé ŋuro ka kama yimirowari,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Asa neko yerero mande kondé ŋande yimiraŋgurí, “Yesu owímo mande kanata ka watí-watí ma yeyowero, ko owímo unipare kumi mande rondaqe ma yunowero.” ");
INSERT INTO nca_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Yi Pita koya Jon koya mandeye topé ŋande yariyó, “Nore irisa Anutu koro mande qu rotoro yeŋo mande qu howewaro tiníqo, ŋumbeka Anutu toŋímo roneneŋowímbe ma kini? Yeŋombo qene rondaŋi qembe. ");
INSERT INTO nca_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Dokoro norendo o qenerowó ko iŋarowó ŋuro mondó ta yowero mepémo kini.” ");
INSERT INTO nca_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ŋunde yiriqo, oresaka mande naŋge yunoro yoroti yendémo uriyó. Uni pará-parámbo irisa ŋu quhurí yunowero kheyó seqaŋgurí, quko mepémo kini, dokoro uniparetoro soraŋgurí. Hamó, unipare soso o tariyó ŋuro iŋoro Anutu owí hokoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Dokoro uni ŋu o wimbí moré ka towori meté taró ŋuko kumima naru 40 ŋunde rotaró. ");
INSERT INTO nca_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Asa yendémo uro topo-topoyarimboya koporo mande o qa-qa unindoro tapá unindoya uni kembé-kembémboya yimiraŋgurí ŋu soso yariyó. ");
INSERT INTO nca_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Topo-topoyarimbo maŋgoye koporo Anutu koya ŋande hariri taŋgurí, “Uni Parámi, keto sambo, noko, windi, o soso ŋuro quroko yote qu, ŋu yondowaró. ");
INSERT INTO nca_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Komo Yuqa Surumímbo usinani Dewit, keŋo sunará simóŋge maŋgó moŋgo mande ka riní tunoqiní ŋande yaró, “‘Do karo uni wini meyowombo newonde saŋgirí parámi teyaŋgurí? Do karo unipareto iŋondutu piyimi kina towoyaŋgurí? ");
INSERT INTO nca_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Noko soso koro wiri yerete unindo kaŋero, ko uni kembé-kembéye koporo, Uni Parámimboya eneŋo Kristoyómboya owéyari rato umbuweya, ye iŋoyaŋgurí.’ ");
INSERT INTO nca_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Hamó horé, Herot, Pontius Pailat, uni wini meyowo, Israel unipare, soso ŋundo Yesu, keŋo sunará simóŋge rokóŋaró, ŋuro owí re umbuwero quro yendé ŋano kopaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Koporo o soso taŋgurí ŋuko komo keto wimbukepoya iŋo-iŋokepoya o ŋu tunoqeweya, yero rokóŋaró. ");
INSERT INTO nca_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Asa itaka, Uni Parámi, mandeye piyimi ŋu iŋoya nore sunará simóŋge samaka nereka sasaro kama tero mandeke yesowoyowato. ");
INSERT INTO nca_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Kandeke rero keŋo sunará simóŋge meté horé ŋu, Yesu, ŋuro owímo se khumo uni yori pitu ko meté tewaŋgo, ko o wimbí moré enesó-enesó tunoqewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Hariri ŋu ti kini tiníqo, ya ŋuno kopaŋgurí quno ŋuno kunduru raŋoní yukuwaró. Ko Yuqa Surumímbo eneno maŋgoriní sasaro kama tero Anutu koro mande qu yesowaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Iŋondutu unipare soso newonde kanata na, iŋo-iŋo kanata na taŋgurí. Uni kato ene oka qu qenero ŋande kama yaró, “O ŋuko neneŋo qu naŋge.” Kini, oye soso ŋuko uni soso koro qu ŋuya. ");
INSERT INTO nca_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ko asá yerewí uni ŋundo Uni Parámi Yesu uni tapu koŋgo pitu ko otoqaró ŋuro mande yesowoyaŋgo, ko mandeye muko wimbí parámi horé. Ko samaka-samaka tuwó ŋu parámi saŋayemo ŋuno yora. ");
INSERT INTO nca_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Uni ka keweroyemo ŋuno otoro kama tukuni teyara. Dokoro uni soso yaye, miraye soweyoro wondo ŋu re mahero ");
INSERT INTO nca_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","asá yerewí uni kandeyemo ŋuno roto yunaŋgurí. Yunoyi rondaŋero uni otoro tukuni teyaŋgurí qu yunoyaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Uni kako, owí Josep, ŋuno yora. Asá yerewí unindo, “Barnabas,” ŋunde ye nekaŋgurí. Owé ŋuro murí muko ŋandiro, “Uni newondeye rukisoyote.” Ŋuko Liwai koro sowe qu ka, ko nimímbo Saipras noko mosowímo ŋuno pisiyaró. ");
INSERT INTO nca_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Asa enendo mirayó kawore soweyoro wondo ŋu rero mahero asá yerewí uni kandeyemo roto yunaró. ");
INSERT INTO nca_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Asa uni kako, owí Ananaias, koya parí muko, owí Sapaira, ŋuno yariyó. Ananaiasko mirayó kawore soweyoro ");
INSERT INTO nca_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","parímboya newonde kanata tero wondo kumi eneŋombo tapuŋoro kumi naŋge re mahero asá yerewí uni kandeyemo roto yunaró. ");
INSERT INTO nca_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ŋunde roto yunoní Pitako ŋande yaró, “Ananaias, ke date koro Monimbuko newondekemo maŋgoriní Yuqa Surumí kanáŋoro mira koro wondo qu kumi tapuŋote? ");
INSERT INTO nca_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Komo, kama soweyaró quno, mira ŋuko keŋo qu naŋge, ko imemoŋgo soweyoro keŋombo naŋge wondo ŋu sopa, hamómbe? Date koro otete ŋu newondekemo iŋote? Keko uni ka kama kanáŋote. Kini, Anutu kanáŋote.” ");
INSERT INTO nca_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Yiníqo, Ananaias mande ŋu iŋoro rokaráŋoro umburo kindo khumaró. Uni soso ene khumaró ŋuro piŋa mande iŋaŋgurí qundo sasaro parámi taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ko uni keta qundo mahero ukúŋo rero tuwipo pokamoro re tapuŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Imemoŋgo naru tukuni naŋge eneŋo parímbo kamí khumaró ŋu kama iŋoro maheró. ");
INSERT INTO nca_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Mahiní Pitako ŋande oseseyaró, “Ke yeka iŋowe. Wondo ŋu re mahiri, ŋuko mirayari soweyariyó ŋuro kimoyó sosope, ma kini?” Yiní ŋande yaró, “Iyo, ŋuro kimoyó soso.” ");
INSERT INTO nca_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Yiní Pitako ŋande miraró, “Date koro yarindo Uni Parámimboro Yuqa qu towoŋowero mande kusiyariyó ŋu? Iŋo, uni kameŋge re tapuŋoteŋgo ŋuno qu mahero makono kaŋeyoteŋgo. Ke ŋuya kore uyarewaŋgo ŋu.” ");
INSERT INTO nca_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Yiní waka ta rokaráŋoro Pita khímo umburo kindo khumaró. Khumoní simó keta qundo ya quroko oro pare ŋu qeniqo, ŋu ŋuya khumaró. Rero koroworo oro kamí roroworo tapuŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ko Anutu koro huru-huru soso ŋuya unipare soso o tunoqaró ŋuro iŋaŋgurí ŋuya sasaro parámi taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Asa asá yerewí uni ŋundo o wimbí moré enesó-enesó unipare keweroyemo taŋgurí. Ko iŋondutu unipare soso ŋundo newonde kanata tero Ya Surumí ŋuno Solomon koro Ya Yokoneyómo ŋuno kopoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Uni kumi eneya kopowero ŋuro sasaro taŋgurí, quko unipareto uni ŋuno kopoyaŋgo ŋuro metéŋoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ŋunde ŋuroko uni qambu, pare qambu ŋuya Uni Parámi iŋondutuwoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ŋunde tiqo, kumimbo se khumo uni yorero kheko yakutíyemo yorotoyi Pitako mahiníkata eneŋo yoŋoyómbo poka yereweya. ");
INSERT INTO nca_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Topoyembo se khumo unindoya uni yuqa pusú soso qundo rambaruru yereyaŋgo ŋu yorero yendé Yerusalem kutaqemo ŋu noŋgo mahiqo, yori meté taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Asa o qa-qa unindoro tapá unindoya eneŋo topé-topé ŋuya, asa Sadyusi koro huru-huru kumi, ŋundo soso otoqoro newonde tutu tero ");
INSERT INTO nca_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","asá yerewí uni ŋu yondoworo yorero kusi-kusi yano yorotaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Quko suwonoko Uni Parámimboro sambo simó kato kusi-kusi ya ŋuro makoyó kosoro yoriní mirako umbuŋgurí. Umburo ŋande yimiraró, ");
INSERT INTO nca_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ye uya Ya Surumí ŋuro yendémo ŋuno kaŋeya unipare yoto-yoto keta ŋaro yimiri,” yaró. ");
INSERT INTO nca_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ita saraŋoní Ya Surumí ŋuro yendémo ŋuno oro mande rondaqe unipare yunaŋgurí. Ŋu naruko ŋuno naŋge o qa-qa unindoro tapá unindoya topé-topémboya mahero huru-huru parámi ŋu owí Sanedrin, Israel koro sopo-sopo uni soso ŋu, neko yereŋgurí. Neko yiri huruworo kumba tukuni kumi asá yerewí uni ŋu kusi-kusi ya noŋgo yore mahi, yero yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Quko uni ŋu kusi-kusi ya quroko ŋuno kama yiyaŋgurí. Asa ko rohoréŋo mahero ŋande yimiraŋgurí, ");
INSERT INTO nca_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Nore kusi-kusi ya ŋuro makoyó qeneteto ŋu, mako ŋu towi kondériní unindo mako ŋu ene-ene sopo wuririyoyoteŋgo. Quko mako kosoro uni ŋu quroko ŋuno kama yiyato.” ");
INSERT INTO nca_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ŋunde yiqo, Ya Surumímboro sopo-sopo unindoya o qa-qa unindoro tapá uni ŋuya iŋondataqero, “Do ka tunoqeweya?” ye iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Asa uni kato mahero ŋande yimiraró, “Iŋoyi, uni yore kusi-kusi yano yorotaŋgo ŋuko itakako Ya Surumí ŋuro yendémo ŋuno kaŋero mande rondaqe unipare yunoyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ŋunde ŋuro Ya Surumímboro sopo-sopo uni ŋuya kumba tukuni ŋuya uyaro asá yerewí uni ŋu yore maheŋgurí. Quko mondó ta yondowaŋgurí, dokoro unipareto wondo raŋo nurowaŋgo, ye soraŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Asa yore mahero Sanedrin huru-huru uni toŋeyemo yorotaŋgurí. Ko o qa-qa unindoro tapá uni ŋundo ŋande yimiraró, ");
INSERT INTO nca_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Norendo komo ŋande yero kusi yeretowó, ye uni ŋaro owímo mande rondaqe unipare ma yunowero. Quko watí-watí yeyuri mandeye ŋundo Yerusalem maŋgorete. Ko uni ŋu khumaró ŋuro potó ŋu nore nunowero ŋuro kondé ye iŋoyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ko Pita koya asá yerewí uni kumimboya mande topé ŋande yaŋgurí, “Norendo Anutu koro mandí howeyoteto, unindoro mandeye kini. ");
INSERT INTO nca_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yendo Yesu rero te kano poroworo uri khumaró ŋu. Ko usisambananimboro Anutu ŋundo okokowoní pitu ko otoqaró. ");
INSERT INTO nca_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Anutuko re oro kandí kondéwore rotoro owé parámi inoní noreŋo kembénani tunoqaró. Ŋunde tunoqero nore rambaruru koŋgo noreweya. Ŋunde tunoqiní Israel unindo newonde rohoré tiqo, quhuríye se rotoweya. ");
INSERT INTO nca_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ko nore o soso ŋu qenetowó ŋuro mande yesowoyoteto. Ko Yuqa Surumí ŋuya ŋuro yesowoyote. Anutuko Yuqa ŋu re unipare mandí howeyoteŋgo ŋu yunoyote.” ");
INSERT INTO nca_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ŋunde yi Sanedrin huru-huru uni ŋundo saŋgirí tero yurato khumowaŋgo yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Quko Sanedrin koro uni ka, Farisi uni ka, owí Gamaliel, ŋundo otoqo kaŋaró. Ŋuko hutuŋo mande ŋuro rondaqe-rondaqe uni, ko unipareto ará te inaŋgurí. Asa yimironí asá yerewí uni soŋga wosoro mirako uŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Uyiqo, enendo huru-huru ŋu ŋande yimiraró, “Ye Israel uni, ye oka unino teweroqo meté iŋoroqota. ");
INSERT INTO nca_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Qeni, soŋga komo quno ŋuno uni ŋu owí Teutasko otoqoro yaró, ‘No owéne moré,’ yiní uni 400 ŋunde uyare howeyaŋgo. Quko wiri yerete uni ŋundo uroní khumoní topé-topé sore wisikaraŋoro o taŋgurí ŋu roti kina umburó. ");
INSERT INTO nca_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Tukú wiri yerete unindo unipare owéye nakayáŋowero mande kondé yaró quno, ŋuno uni ka owí Jutas, Galili noŋgo uni ŋundo otoqoro unipare kumi iŋo-iŋoye wosoní otoqoro kuma taŋgurí. Wiri yerete uni ŋundo uni ŋuya uroní khumaró, ko eneŋo uniyó soso wisikaraŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Asa itaka nondo ye yimiroteno, uni yondowoteŋgo ŋu yorotika kina yowaŋgo. Dokoro o teyoteŋgo ŋuko unindoro iŋo-iŋo ŋu naŋge howeyote tiníqo, kina umbuweya. ");
INSERT INTO nca_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Quko o teyoteŋgo ŋuko Anutu koro iŋo-iŋo howeyote tiníqo, yendo kusi yerewero mepémo kini. Ye yate Anutu koya kuma tewaŋgo koro.” Ŋunde yiníqo, eneŋo mandí howewero mande kusiyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Asa asá yerewí uni ŋu neko yerero yore haususu yerero Yesu owímo mande ma yeyowero yero yoroti toŋeŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ŋunde ŋuro Sanedrin huru-huru ŋu yorotoro mirako uro niŋgu-niŋgu taŋgurí. Dokoro Anutuko iŋo yunoro rokó yiriní Yesu owí riqo, unindo eneŋo owéyari ri umburó. ");
INSERT INTO nca_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kowe naru rokóŋoro yayemo ŋuno ko Anutu koro Ya Surumímo ŋuno ene unipare mande rondaqe yunoro miti mande ŋande yesowoyaŋgo, ko Kristo ŋuko Yesu naŋge. ");
INSERT INTO nca_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ŋu naruko ŋuno iŋo-iŋo rewero unipare qambu tunoqaŋgurí. Ŋunde ti kumi Grik mande yeyaŋgo qundo kumi Hibru mande yeyaŋgo quya kisikasa mande ka yaŋgurí. Ŋande yaŋgurí, “Ko yendo o qoyemboro unipare yunoyoteŋgo quno ŋuno noreŋo wapu ŋundo o kama siyoyoteŋgo,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Asa ko asá yerewí uni 12 ŋundo iŋo-iŋo rewero unipare soso neko yiri mahi ŋande yimiraŋgurí, “Asa nore Anutu koro mande yesowowero kho qu rotoro o qoyemboro rondaŋe yunowero kho tewato tiníqo, ŋu meté kini. ");
INSERT INTO nca_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ŋunde ŋuro, uni topo, uni kande saŋiyoro irisa keweroyemo ŋano qu seqa yiri, ŋu owéye unipare toŋeyemo meté yote qu, ko iŋo-iŋoye meté qu, ko Yuqako ŋu quroko yote qu. Norendo kho ŋu yunato sopowaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Noreŋombo kho tero hariri tero Anutu koro mande qu yesowoyowato.” ");
INSERT INTO nca_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ŋunde yiqo, ŋuro metéŋaŋgurí. Asa Stiven rokóŋaŋgurí, ŋuko iŋondutuyó kondé, ko Yuqa Surumímbo ŋuno maŋgoreyara. Uni meyowo rokó yereŋgurí ŋuko ŋandiro: Filip, Prokorus, Nikanor, Timon, Paremenas ko Nikolas. Nikolas ŋuko uni wini meyowo Antiok yendé moŋgo qu, enendo Juda koro muríye howeyara. ");
INSERT INTO nca_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Asa enendo uni ŋu rokó yerero yoroti kaŋi asá yerewí uni ŋundo hariri tero kandeye saŋayemo raŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ko Anutu koro mande qu usaye toŋeró. Toŋiní unipare qambu Yerusalem ŋuno iŋo-iŋo rewero unipare tunoqaŋgurí. Ko o qa-qa uni kumi ŋuya iŋondutuwoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Asa Anutuko samaka-samaka tuwó koya wimbu koya Stiven inoní o wimbí moré enesó-enesó unipare keweroyemo teyaró. ");
INSERT INTO nca_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ŋunde tiní uni kumimbo otoqoro Stiven koya mande saŋgirí teyaŋgo. Ŋu uni ŋuko Juda koro huru-huru ya kanata noŋgo qu, huru-huru ya ŋu ŋande ye nekoyaŋgurí, “Uni Oroso yereŋgurí qu,” yaŋgurí. Uni ŋuko Sairin yendé, Aleksandria yendé, Silisia mira ko Esia mira koŋgo qu. ");
INSERT INTO nca_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Mande saŋgirí eneya yaŋgurí, quko mandeyembo eneŋo iŋo-iŋoyó ŋuya Yuqapo mandí yaró ŋuya takawero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Asa saŋgirí ŋundo kota-kota uni siyoro iŋo-iŋo ka yunoyi Stiven ŋuro ŋande yaŋgurí, “Enendo Moses koya Anutu koya yesará yiriní nore iŋatowó.” ");
INSERT INTO nca_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ŋundiro naŋge enendo uniparetoya uni kembé-kembéyemboya hutuŋo mande ŋuro iŋo-iŋo unindoya newondeye ri otoqoní Stiven kondé toworo Sanedrin huru-huruko ŋuno re maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Re mahero kota-kota uni ŋu ŋuya yore yoroti kaŋero ŋande yaŋgurí, “Uni ŋando Ya Surumímboya hutuŋo mande ŋuya huwó mande suki-suki yeyote. ");
INSERT INTO nca_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Yiní ŋande iŋatowó, ‘Yesu, Nasaret noŋgo uni ŋundo ya ŋu rambaruruworo Mosesko otete nunaró ŋu rohoréŋoweya.’” ");
INSERT INTO nca_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Uni soso huru-huruko ŋuno kunditaŋgurí ŋundo Stiven kondé toŋete qeneŋgurí, ko umu-kembé qeneŋgurí muko sambo simó umu-kembé qembe taró. ");
INSERT INTO nca_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Asa o qa-qa unindoro tapá uni ŋundo ŋande yaró, “Mande yeteŋgo ŋumbe hamómbe ma kini?” ");
INSERT INTO nca_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Yiní Stivenko ŋande yaró, “Uni topo, awa okite, iŋoyi. Komo Anutu meté horé ŋundo Abrahamko tunoqaró. Ŋu naruko ŋuno Abraham Mesopotemia mirako ŋuno watí yora, Haran yendémo kama oró. ");
INSERT INTO nca_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Asa tunoqero ŋande miraró, ‘Ke mirake, topoke yorotoro mira ka witú kerewano quno ŋuno toŋe qembe,’ yaró. ");
INSERT INTO nca_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Asa ko Abraham Kalitia mira ŋu rotoro Haran oró. Imemoŋgo iwí khumoní Anutuko riní ŋa mira ye itaka ŋano yoteŋgo ŋano maheró. ");
INSERT INTO nca_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Riní mahero mira tomó karo simburí kama taró, ko simó moré kini taró. Quko Anutuko mande kusiyoro ŋande miraró, ‘Keya sowekepoya mira parámi ŋaro simburí tunoqewaŋgo.’ ");
INSERT INTO nca_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Yero ŋande yaró, ‘Keŋo soweke uni meyowomboro mirako yotoro kasirayemo yuriqo, kumima naru 400 quroko o piyimi te yunowaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Imemoŋgo nondo unipareto o piyimi te yunowaŋgo ŋuro yore ronda yerewe sowekepo mira ŋu roto toŋero mahero ŋa mirako ŋano potoruku te nunowaŋgo.’ ");
INSERT INTO nca_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ko Anutuko Abraham koya mande kondé ka kusiyoro koweye toŋowero murí ŋu inaró. Ŋundiro naŋge Abrahamko Aisak pisiyoro naru kande saŋiyoro kapusa ŋunde kini tiní kowí toŋaró. Ko Aisakiko Yakop pisiyoro ŋunde naŋge te inaró, ko Yakopko usi-sinani 12 ŋu pisi yerero ŋunde naŋge te yunaró. ");
INSERT INTO nca_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Asa usi-sí ŋundo koneye Josep koro newonde tutu tero towo roti uni kato kimoro Isip ŋuno uŋgurí. Quko Anutuko ŋuno eneya yotoro ");
INSERT INTO nca_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","quhurí soso korowaró ŋu noŋgo rero samakaŋaró. Samakaŋoro iŋo-iŋo meté horé inoní Isip koro wiri yerete uni, “Pero,” ye nekaŋgurí, ŋundo Josep ŋuro metéŋoro riní Isip mira koya wiri yerete unindoro suwisawiyó soso koro uni kembéye yora. ");
INSERT INTO nca_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Imemoŋgo korare Isip koya Kenan mirako ŋuno tunoqiní unipareto quhurí parámi korowaŋgurí, ko usi-sinani o newero qu seqaro qenewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Asa Yakopko o newero qu Isip ŋuno yote ŋu iŋoro naru koretero noreŋo usi-sinani asá yiriní uŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ko naru irisayómo ŋuno uŋgurí quno ŋuno Josepko tunomo topé-topé yimiraró, ‘No Josep.’ Ŋunde ŋuro Peroko Josep koro wini quro iŋaró. ");
INSERT INTO nca_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Asa Josepko iwí Yakop koya suwisawiyómboya soso ŋu mahewaŋgo, yero neko yereró. Ŋuko unipare 75 ŋundiro. ");
INSERT INTO nca_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nekoní Yakop Isip ŋuno uró. Yate-yate eneya usi-sinani soso ŋuya khumiqo, ");
INSERT INTO nca_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ukúye yorero pitu Sekem yendémo oŋgurí. Komo Abrahamko wondo silwa kumi Hamor soweyó yunoro uni tapu ka Sekem ŋuno kimaró. Asa uni tapu ŋuno soso tapu yereŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Komo Anutuko Isip rotowero naru karo mande kusiyoro Abraham miraró. Asa naru ŋu kutaqe mahiní usi-sinani qambu tero Isip mira ŋu maŋgoraŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ko yate-yate wiri yerete uni ka Isip ŋuno tunoqaró, ŋuko Josep ŋuro kama iŋaró. ");
INSERT INTO nca_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Uni ŋundo usi-sinani kaná yerero o piyimi te yunoro kondé yimiraró, oŋa pisiyoteŋgo ŋu se sikuno yorotika khumoyi, yaró. ");
INSERT INTO nca_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Ŋu naruko ŋuno Moses nimímbo pisiyaró, ko ŋuko simó meté horé. Iwí-nimímbo yano sopoyori kombo kapusa kini tiní ");
INSERT INTO nca_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","rero sikuno rotariyó. Ŋunde rotori Pero koro nambunímbo simó ŋu rero ene naŋuní qembe sopoyaró. ");
INSERT INTO nca_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Sopoyoní Mosesko Isip koro iŋo-iŋo ŋu soso reyara. Ko ŋuko mande yewero wimbí rero kho kondé teyara. ");
INSERT INTO nca_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Asa Mosesko kumima naruyó 40 ŋunde kini tiní eneŋo topé-topé Israel yiyowero iŋaró. ");
INSERT INTO nca_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Uyariní Isip uni kato Israel uni ka roworemoyaró. Mosesko ŋu qenero Israel uni ŋu samakaŋoro Isip uni o piyimi te inoyaró ŋu uroní khumaró. ");
INSERT INTO nca_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ŋunde tero ŋande iŋaró, uni topémbo ŋande iŋoyi tondaŋeweya, ‘Anutuko Moses kandímbo nore rambaruru koŋgo yoreweya.’ Ŋunde iŋaró, quko topé-topémbo kama iŋoyi tondaŋaró. ");
INSERT INTO nca_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Asa ita saraŋoníqo, uni topé irisa kuma tariyó ŋu yiyoro mepa mande ŋande yaró, ‘Yarikaŋge ŋunde ma tewero. Do karo yariŋombo naŋge roworemoyotiri?’ ");
INSERT INTO nca_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Uni ŋu topé roworemoyaró ŋundo Moses pitoro ŋande yaró, ‘Ke dando koriní nore wiri nerero ronda nerewero tete? ");
INSERT INTO nca_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Keto suwo Isip uni ŋu uri khuma ŋunde naŋge nombe nurowero tete?’ ");
INSERT INTO nca_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ŋunde yiní Moses sore toŋero mira meyowo, Mitian mirako, ŋuno kunditero, yate naŋo-simó irisa pisi yereró. ");
INSERT INTO nca_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Asa imemoŋgo kumima naru 40 ŋunde kini tiní, sambo simó kato mira wimbímo Sainai purí kutaqemo ŋuno te kunzi qayara quno ŋuno eneno tunoqaró. ");
INSERT INTO nca_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Tunoqiní Mosesko iŋondata parámi tero qenewero woso uyaro Uni Parámimboro maŋgó iŋoní ŋande yaró, ");
INSERT INTO nca_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘No keŋo usiŋgeporo Anutuye, asa Abraham, Aisak, Yakop koro Anutuye,’ yaró. Ŋunde yiní Moses iŋoro yukuworo qenewero sasaro taró. ");
INSERT INTO nca_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Asa Uni Parámimbo ŋande miraró, ‘Khe punu-punu kheŋgemo ŋu se roto. Ke mira ŋano kaŋeyote ŋako surumí. ");
INSERT INTO nca_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","No uniparene Isip yoteŋgo ŋu quhurí korowoyoteŋgo ŋu hamó yiyoyoteno. No tendoye iŋoyoteno, ko itaka oroso yerewero koro umbuteno. Asa otoqoka koreweka Isip u.’ ");
INSERT INTO nca_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ŋu Moses ŋuko, komo unindo huwóŋoro ŋande yaŋgurí, ‘Ke dando koriní nore wiri nerero ronda nerewero tete?’ Asa uni ŋu naŋge, sambo simó te kunziko tunoqaró quno ŋuno Anutuko asáŋoní wiri yerete uni tero unipare kimo yerewero uni tunoqaró. ");
INSERT INTO nca_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Enendo unipare yore oro o wimbí moré enesó-enesó Isip ŋuno taró, ko windi mandumimo taró, ko mira wimbímo kumima naru 40 quroko ŋunde taró. ");
INSERT INTO nca_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Ŋu Moses ŋundo Israel unipare ŋande yimiraró, ‘Anutuko ye keweroye moŋgo ka riní ye-ye uni ka no qembe tunoqeweya.’ ");
INSERT INTO nca_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Enendo uniparetoro huru-huru keweroko mira wimbímo yora, ko sambo simó Sainai mira purímo miraró koya noreŋo usi-sinanimboya kewero uni tunoqaró. Enendo yoto-yoto koro mande qu ŋu rero nore nunaró. ");
INSERT INTO nca_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Quko usi-sinani muko mandí iŋowero piyimiŋaŋgurí. Kini, ŋunde pitoro newondeye rohoréŋoro Isip koro qene nuŋgu tero ");
INSERT INTO nca_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Aron ŋande miraŋgurí, ‘Keto noreŋo anutunani kumi yondowoka korete uyari yohowewato. Dokoro Moses ŋando nore Isip noŋgo nore ŋano maheró, ŋu dana u, nore kama iŋoteto,’ yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ŋu naruko ŋuno makao simó kapí-kapí ka toworo anutu kota-kota koro o qa-qa tero oka towaŋgurí ŋuro niŋgu-niŋgu tero hoho teyaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ŋunde tiqo, Anutuko huwó yiriní o kondé kumi samboko yote ŋuro potoruku te yunaŋgurí. Kako komo suki ye-ye unindoro sokomeko o ŋuro mande ka ŋande nakayáŋaŋgurí, “‘Ye Israel koro wini qu, komo ye kumima naru 40 ŋunde mira wimbímo ŋuno yotoro o qa-qa enesó-enesó no kama te nunaŋgurí, hamómbe? ");
INSERT INTO nca_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kini, ye Molok koro tuwi yamaru ŋu re hokoro yeŋo anutuye Repan koro tutu ŋuya re hokaŋgurí. Ŋu kapo-kapo towaŋgurí ŋu ye potoruku te inoyaŋgurí. Asa ko nondo ye yohowewe Bapilon amuno uwaŋgo.’ ");
INSERT INTO nca_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Asa usi-sinanimbo Anutuko hutuŋo mande yunaró ŋuro tuwi yamaru ka raŋgurí. Anutuko ya ŋuro kapo-kapo Moses witúŋoro, ‘Ŋandiro naŋge re qembe,’ ye mironí ŋunde taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ko yate-yate Anutuko mira ŋaro simburí enesó-enesó ŋu yohowiní usisambananimboya Josua koya tuwi yamaru ŋu re maheŋgurí. Ŋano yuri, yate-yate Dewit tunoqaró. ");
INSERT INTO nca_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Tunoqiní Anutuko ŋuro metéŋoní Dewitko Yakop koro Anutu quro ya hamó ka rewero hariri taró. ");
INSERT INTO nca_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Quko Solomonko ya ŋu raró. ");
INSERT INTO nca_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ŋunde raró, quko Anutu Koreko Horé yote ŋundo uni ya reyoteŋgo quno ŋuno kama yote. Hamó, ye-ye uni kato ŋande yaró, ");
INSERT INTO nca_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Uni Parámimbo ŋande yete, ‘Sambo ŋuko neneŋo yakutí kunditewero qu ko noko ŋuko khene re ŋuno kheteyoteno. Do ya kiraró ka neneŋo rewaŋgo, ko dano kunditero imaqewano? ");
INSERT INTO nca_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Neneŋo kandenembo o soso towanowó, hamómbe?’” ");
INSERT INTO nca_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Asa ŋunde yero Stivenko ŋande yaró, “Yeko mande wenda-wenda uni. Yeŋo newondeye, kusumboye muko kape uni ŋunde qembe. Ye naru rokóŋoro usisambaye ŋunde qembe tero Yuqa Surumímboya kuma teyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Do ye-ye uni ka yora, asa usisambayembo o piyimi kama te yunaŋgurí? Ko ye-ye uni kato uni roneneŋowí maheweya ŋuro yesowaŋgurí, ŋu ŋuya usisambato yuri khumaŋgurí. Ko itaka yendo uni roneneŋowí ŋu turiri re inoyi uri khumaró. ");
INSERT INTO nca_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Yeko Anutu koro hutuŋo mandeyó sambo simó kandeye moŋgo raŋgurí, quko ye ŋu kama howeyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Asa uni pará-parámbo mande soso ŋu iŋoro saŋgirí parámi tero Stiven qenero metoye kindotaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Quko Yuqa Surumímbo Stiven quroko maŋgoriní, sambo saŋano kondé toŋetero Anutu koro sine parámi qenero, Yesu ŋuya Anutu koro kandí kondésina kaŋeyoní qenero ");
INSERT INTO nca_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ŋande yaró, “Qeni! Sambo kosoní Unindoro Naŋuní Anutu koro kandí kondésina kaŋiní qeneteno.” ");
INSERT INTO nca_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ŋunde yiníqo, kondé piyimi nekoro kusumboye wisumuŋoro otoqoro Stivenko kopo kheŋgeŋoro ");
INSERT INTO nca_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","toworo yendé hoŋgo andusina roti umbuní wondo raŋo utoyaŋgo. Ko uni ene o piyimi taró ŋuro yesowaŋgurí ŋundo kowe punu-punu piruye se rotoro se simó keta, owí Sol, ŋuro khímo raŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Wondopo utoyuriqo, Stiven ŋande hariri taró, “Uni Parámi Yesu, yuqane re!” ");
INSERT INTO nca_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ko potoruku rero kondé ŋande nekaró, “Uni Parámi, keto quhurí ŋaro topé ma te yunowero.” Ŋunde yero ete khumaró. ");
INSERT INTO nca_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ko Stiven uri khumaró quno ŋuno Solko qenero ŋuro metéŋoyaró. Ŋu naruko ŋuno Yerusalem ŋuno unindo saŋgirí tero hurí rero iŋondutu koro huru-huru ŋu o pi-piyimi te yunoyaŋgo. Asa ko soso sorero Judia mirako, Samaria mirako ŋuno wisikaraŋaŋgurí. Asá yerewí uni ŋundo naŋge Yerusalem ŋuno yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Uni kumi Anutu koro murí howeyaŋgo ŋu Stiven re tapuŋoro tendo parámi taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Quko Solko iŋondutu koro huru-huru ŋu rambaruru yereyara. Enendo yayemo oro uni ŋuya pare ŋuya yowosoro uro kusi-kusi yano yorotaró. ");
INSERT INTO nca_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Asa unipare ŋu sorero wisikaraŋo uyaro yendé enemo-enemo toŋero miti mande yesowaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipko Samaria mirako ŋuno yendé kano uro ŋu Kristo ŋuro yesoworo yimiraró. ");
INSERT INTO nca_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Yimitoro o wimbí moré tiní unipare qambu qundo kondé toŋetero mandí yaró ŋuro kusumbo raŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Dokoro enendo yuqa pusú qambu uni quroyemo yaŋgurí ŋu yohowiní kondé kiwero yorotoro toŋeŋgurí. Ko uni qambu wimbuye khumaró, ko kheye piyimi mu, ŋu yoriní meté taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ŋunde ŋuro yendémo ŋuno niŋgu-niŋgu parámi taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Uni ka ŋu yendémo ŋuno yaró, owí Saimon. Enendo o wimbí moré piyimi kumi teyoní Samaria unipareto qenero newondeye uroní niŋgu-niŋgu teyaŋgurí. Ko eneŋo owí hokoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Unipare owéye moré mu ko owéye moré kini qu ŋu soso mandí iŋoro ŋande yaŋgurí, “Uni ŋako Anutu koro wimbí parámi qu reyote.” ");
INSERT INTO nca_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ŋunde yaŋgurí, dokoro naru piru ŋundiro o wimbí moré ŋu teyoní newondeye uraró. ");
INSERT INTO nca_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Quko Filipko Anutuko unipareyó wiri yereyote naruyó ko Yesu Kristo owí ŋuro miti mande qu yesowaró quno ŋuno uni ŋuya pare ŋuya iŋondutu tero sono raŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ko Saimon ŋuya iŋondutu tero sono raró. Enendo Filip koya uyaro Filipko o wimbí moré parámi teyaró qu qenero newondí uroní niŋgu-niŋgu taró. ");
INSERT INTO nca_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Asá yerewí uni Yerusalem ŋuno yotoro mande piŋa ŋande iŋaŋgurí, asa Samaria uni Anutu koro mande qu raŋgurí. Asa ŋunde iŋoro Pita koya Jon koya asá yiri eneno uriyó. ");
INSERT INTO nca_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Uro Yuqa Surumí saŋayemo umbuweya ŋuro hariri tariyó. ");
INSERT INTO nca_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Dokoro Uni Parámi Yesu owímo sono raŋgurí naŋge, Yuqa ŋundo keweroyemo ka saŋano kama umburó. ");
INSERT INTO nca_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Asa kandeyari saŋayemo riri, Yuqa raŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Asa Saimonko asá yerewí uni irisa ŋu yiyoní kandeyari unipare saŋayemo riri Yuqa raŋgurí. Ŋunde ŋuro wondo yunowero tero ŋande yaró, ");
INSERT INTO nca_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Yarindo wimbu ŋu ka re no ŋuya nunorika no kandene rero uni ka saŋano rewano ŋuko Yuqa reweya.” ");
INSERT INTO nca_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Yiní Pitako ŋande miraró, “Ke Anutu koro puriŋo kimowero quro iŋote! Ŋunde ŋuro wondoke muko keŋomboya piyo tewari! ");
INSERT INTO nca_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Keto mande yesowowero kho qu tewero mepémo kini, dokoro Anutu toŋímo newondeke muko roneneŋowí kini. ");
INSERT INTO nca_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ŋunde ŋuroko oteteke piyimi ŋuro surumí tero newonde rohoré teya Uni Parámiwore hariri teka newondekemo o piyimi iŋoyote ŋuro quhurí ŋu re rotoní. ");
INSERT INTO nca_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Dokoro no ke kiyo iŋoteno, ko keŋo newondeke piyo tiní quhurímbo kondé kusi kereyote.” ");
INSERT INTO nca_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ŋunde yiníqo, Saimonko mande topé ŋande yaró, “Yari Uni Parámiwore hariri tirika no samaka niriní o piyimi ŋuro yitiri ŋuko nono kama tunoqiní,” yaró. ");
INSERT INTO nca_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Asa Yesu ŋuro yero Uni Parámimboro mande qu yesowori kini tiní pitu ko Yerusalem oro yendéne-yendéne Samaria khewore miti mande yesoworo oriyó. ");
INSERT INTO nca_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Asa Uni Parámimboro sambo simómbo Filip ŋande miraró, “Otoqoya khe Yerusalem rotoro Gasa yendémo ŋuno uyote ŋuwore u.” Khe ŋuko mira wimbíwore uyote. ");
INSERT INTO nca_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Asa yiní Filip otoqoro toŋeró. Kheko ŋuno Itiopia mira koro uni ka qeneró. Ŋuko Itiopia koro wiri yerete pare, Kandake, ŋuro kho uniyó ka. Enendo onoŋoyó soso sopoyaró. Komo potoruku te inowero quro Yerusalem oní ");
INSERT INTO nca_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","kini tiní rohoréŋoro uyaró. Uyaro karis saŋano kunditero ye-ye uni Aisaia koro sokome qu weyaró. ");
INSERT INTO nca_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Asa Yuqako Filip miraró, “Uyareya karis ŋuro taŋgímo u.” ");
INSERT INTO nca_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ŋunde yiní kheŋgeŋoro uyariní uni ŋundo ye-ye unindoro sokome qu weyoní iŋaró. Filipko yaró, “Kepe mande ŋuro murí ŋumbe iŋotepe ma kini?” ");
INSERT INTO nca_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Yiní ŋande yaró, “Uni kato no kama witú nereweya tiníqo, ŋu date iŋowano?” yero ŋande miraró, “Are noya kundite.” ");
INSERT INTO nca_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Mande sokome quroko qu weyaró ŋuko ŋandiro, “Sipsip urowero ŋunde qembe, sipsip simó huí toŋowero qembe, enendo mondó ta naŋge yora. ");
INSERT INTO nca_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Unindo ri umbuní murí piyimiwore rondaŋaŋgurí. Danimbo eneŋo soweyómboro yeweya? Dokoro noko noŋgo yoto-yotoyó re rotaŋgurí.” ");
INSERT INTO nca_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Sopo-sopo uni ŋundo Filip ŋande miraró, “Meté, yeka iŋowe. Ye-ye uni ŋundo dani karo mande ŋa yaró? Ŋumbe eneŋomboro yarómbe ma uni meyowomboro yaró?” ");
INSERT INTO nca_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Yiníqo, Filipko hurí rero ŋu mande ŋuro murí yero Yesu koro miti mande ŋu yesowaró. ");
INSERT INTO nca_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Asa khe ŋuno uyareyate sopo-sopo uni ŋundo sono ka qenero ŋande yaró, “Qeno, sono ŋa. Do kato kusi niriní no sono kama rewano?” ");
INSERT INTO nca_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","(-) ");
INSERT INTO nca_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Asa, yiní karis kaŋiní Filip koya sopo-sopo uni ŋuya sonono uro Filipko uni ŋu sono re inaró. ");
INSERT INTO nca_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Sono roto ariní waka ta Uni Parámimboro Yuqa qundo Filip riní toŋeró. Toŋiní sopo-sopo uni ŋu pitu ko kama qeneró. Ko niŋgu-niŋgu tero khe ŋu howe uró. ");
INSERT INTO nca_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Quko Filip Asotus yendémo ŋuno tunoqaró. Ko yendé enemo-enemo uro miti mande yesowoyara, yate Sisaria yendémo ŋuno uró. ");
INSERT INTO nca_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Asa Solko Uni Parámimboro iŋo-iŋo rewero uni yuroweka khumoyi yeyara. Ŋunde tero enendo o qa-qa unindoro tapá unino uyaro ");
INSERT INTO nca_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","sokome karo kirayaró. Juda unindo Damaskus yendé parámimo ŋuno sokome ŋu qenero wimbu Sol inoyi unindoya paretoya Khe ŋu howeyaŋgo ŋu kondé yondoworo se Yerusalem owaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Asa sokome ŋu rero uyariní Damaskus kutaqemo ŋuno hiyó kondé ka sambo koŋgo eneno ŋuno umburó. ");
INSERT INTO nca_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Umbuní Sol kina nokono umbu raŋoro maŋgo ka iŋoní ŋande yaró, “Sol, Sol, do karo ke no rowore nereyote?” ");
INSERT INTO nca_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ko Solko yaró, “Uni parámi, ke dani?” Yiní ŋande yaró, “No Yesu. Ke no rowore nereyote. ");
INSERT INTO nca_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Quko otoqoya yendé quroko oyo. Imemoŋgoko uni kato ke o teweya ŋuro kimiroweya.” ");
INSERT INTO nca_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Uni Sol koya uyareŋgurí ŋuno qu yukuworo mande yewero rukusuwaŋgurí. Mande ŋu iŋaŋgurí, quko uni ka kama qeneŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Asa Sol otoqo toŋetaró, quko toŋí huriri taró. Ŋunde tiní kandímo toworo Damaskus yendémo oŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kosa naru kapusa ŋunde toŋí huriri tiní o, sono kama neyara. ");
INSERT INTO nca_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Iŋo-iŋo rewero uni ka Damaskus ŋuno yora, owí muko Ananaias. Asa Uni Parámimbo quko owí nekoro ŋande yaró, “Ananaias.” Yiní ŋande yaró, “Uni Parámi, no yoteno,” yaró. ");
INSERT INTO nca_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Uni Parámimbo ŋande miraró, “Uni kako owí Jutas, yendémboro khe ŋu, ‘Roneneŋowí,’ ye nekoyoteŋgo qu, ŋuno yote. Asa otoqoya ya ŋu seqa uyareya uni ka Tarsus yendé moŋgo owí Sol ŋuro osese te qeno qembe. Itaka hariri tero yorote. ");
INSERT INTO nca_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Toŋí muko huriri tete. Quko ŋuno uni ka qene, owí muko Ananaias, ŋu arero kandí toŋímo ra. Ŋunde tiní toŋí meté tero toŋeta.” ");
INSERT INTO nca_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananaiasko mande topé ŋande yaró, “Uni Parámi, no iŋoteno, quko uni ŋuro mande parámi yeteŋgo, otete piyimi enesó-enesó keŋo unipareke meté horémboya Yerusalem ŋuno te yunoyara. ");
INSERT INTO nca_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ko o qa-qa unindoro tapá uni ŋundo wimbu inoyi, unipareke keŋo mande iŋoro hariri teyoteŋgo ŋano qu kusi yereweya.” ");
INSERT INTO nca_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Uni Parámimbo ŋande miraró, “Ke u. Neneŋombo ene rokóŋoro kho ka inano, ko enendo uni wini meyowomboya, wiri yerete unindoya, Israel uniparetoya toŋeyemo neneŋo owéne ŋuro yesowo yimiroweya. ");
INSERT INTO nca_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Hamó, do o quhurí ka neneŋomboro korowoweya ŋu ene witúŋowano.” ");
INSERT INTO nca_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Asa Ananaias uyaro ya ŋu quroko oro kandí re Sol saŋano rero ŋande miraró, “Topo Sol, ke kheko maheyuri Yesu keno tunoqaró, ŋuko Uni Parámi, ko enendo no asá niriní keno areteno ŋa. No arewe toŋeŋge meté tiní Yuqa Surumí qundo keno uya maŋgoriní.” ");
INSERT INTO nca_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ŋunde yiní, waka ta oka soró qembe ka Sol toŋí moŋgo tondaŋe umbuní meté toŋetero otoqoní sono re inaró. ");
INSERT INTO nca_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ko o qímboro nero wimbu raró. Asa Sol kosa naru kumimo iŋo-iŋo rewero unindoya Damaskus yendémo ŋuno yoraŋgo. ");
INSERT INTO nca_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ŋu naruko ŋuno Juda uniparetoro huru-huru yayemo mande ŋande yeyara, Yesu ŋuko Anutu koro Naŋuní, ye yesowoyara. ");
INSERT INTO nca_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Uni soso mandí iŋoro yukuworo ŋande yaŋgurí, “Komo uni ŋundo unipare owé ŋuwore hariri teyoteŋgo ŋu Yerusalem ŋuno rambaruru yereyaró, ko itakako unipare ŋunde qu kusi yerero o qa-qa unindoro tapá unino ŋuno se owero ŋano maheró, hamómbe?” ");
INSERT INTO nca_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Quko Solko wimbu parámi tero Juda uni Damaskus yaŋgurí ŋu yorero iŋo-iŋoye takaro ŋande witú yereró, ko Yesu ŋuko Kristo ŋu. Ŋunde yiní mande topé tewero rukusuwaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Asa naru piru ta rotoníqo, Juda unindo koporo Sol uri khumowero quro mande kusiyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Quko Sol mande ŋuro iŋaró. Ko Juda unindo uri khumowero quro yendé ŋuro mako qu soso kosa suwo sopoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Quko Sol koro iŋo-iŋo rewero unindo suwono ri toŋgo puŋge parámi quroko kunditiní hoŋgo wituwore re rotoyi uró. ");
INSERT INTO nca_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Asa Sol Yerusalem oro Yesu koro iŋo-iŋo rewero unindoya kopowero yero iŋaró. Quko uni ŋundo sasaro tero eneko iŋo-iŋo rewero uni ka tunoqaró ŋuro kama iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Quko Barnabasko Sol rero asá yerewí unino oro ŋande yimiraró, ko Solko kheko Uni Parámi qeniní mande ka miraró, ko Damaskus ŋuno wimbu rero Yesu owímo mande yesowoyaró. ");
INSERT INTO nca_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ŋunde ŋuro Sol eneya Yerusalem ŋuno yotoro uyare mahe tero wimbu rero Uni Parámimboro owímo mande yesowoyaró. ");
INSERT INTO nca_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Enendo Juda uni Grik mande yeyaŋgo ŋuya mandeto kuma teyara. Ko uri khumowero ŋuro kheyó seqaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Quko topé-topémbo ŋuro iŋoro Sol rero Sisaria yendémo uro asáŋi eneŋo yendéyó, Tarsus, ŋuno oró. ");
INSERT INTO nca_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ŋunde ŋuroko mira soso Judia, Galili ko Samaria ŋuno iŋondutu koro huru-huru ŋu meté kunditeyaŋgurí. Ŋunde yuriqo, iŋondutuye kondériní Uni Parámi ŋuro sasaro ti Yuqa Surumímbo newondeye rukisoyoní unipare qambu eneya kopoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Naru kano Pitako mira soso ŋuwore toŋeyate Lita yendémo ŋuno uro unipare meté horé quya ŋuno yoraŋgo. ");
INSERT INTO nca_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ŋu yendémo ŋuno uni ka qeneró, owí muko Ainias. Wimbu khe kandí soso khumoní yakutímo naŋge eteyoní kumima naru kande saŋiyoro kapusa ŋunde rotaró. ");
INSERT INTO nca_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pitako qenero ŋande miraró, “Ainias, itaka Yesu Kristo ŋundo koriní meté tete. Otoqoya yakutíŋge roŋgaruwo.” Yiní waka ta otoqaró. ");
INSERT INTO nca_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ko Lita uni soso koya Saron mira koro uni ŋuyako soso qenero Uni Parámiwore newonde rohoré taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Asa Jopa yendémo ŋuno iŋo-iŋo rewero pare ka owí Tapita ŋuno yaró. Owí ŋu Grik mandewore ŋande nekoyaŋgo, Dokas, yeyaŋgo. Naru rokóŋoro enendo o meté unipare te yunoro uni otoro tukuni teyaŋgurí ŋu samaka yereyara. ");
INSERT INTO nca_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Asa ŋu naruko ŋuno se khumo teyate khumaró. Khumoní ukúŋo sonoworo rero ya quroko ŋuno wasa koreko quno raŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lita yendé ŋuko Jopa yendé taŋgímo yora. Ŋunde ŋuro iŋo-iŋo rewero unindo, Pita Lita yendémo ŋuno yote, yero iŋaŋgurí. Ko uni irisa asá yiri eneno oro ŋande kirayariyó, “Waka ta noreno mahe,” yariyó. ");
INSERT INTO nca_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Asa Pitako otoqoro irisa ŋuya toŋeŋgurí. Ko ŋuno uyaro wasa koreko quno ŋuno oró. Oní wapu kumimbo Pita taŋgímo mahe kaŋero tenduruworo Dokasko eneya yara quno kowe punu-punu kumi tiŋiyaró ŋu se witúŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Asa Pitako unipare soso yohowiní yendémo uyiqo, potoruku rero hariri tiní kini tiní ukúŋo ŋande miraró, “Tapita, otoqo,” yaró. Ŋunde yiní pare ŋu toŋetero Pita qenero otoqoro kunditaró. ");
INSERT INTO nca_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Kunditiní kandímo towoní otoqoro kaŋiní unipare meté horémboya wapu ŋuya neko yerero pare pitu ko otoqaró ŋu witú yereró. ");
INSERT INTO nca_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ŋunde tiní mande piŋa ŋu Jopa yendéwore toŋiní unipare soso piŋa mande iŋaŋgurí, ko uni qambu Uni Parámi iŋondutuwoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pitako naru piru ta Jopa ŋuno makao kowí roŋgaruwoyara uni kaya yari. ");
INSERT INTO nca_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Asa uni ka Sisaria yendémo ŋuno yaró, owí muko Kornilius. Ŋuko kuma unindoro sopo-sopo uni qu ka, ko enendo Rom koro kuma unindoro huru-huru parámi ka, owí “Itali koro huru-huru,” yeyaŋgurí, ŋuro quroko uni kumi sopo yereyara. ");
INSERT INTO nca_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ŋu uni ŋuya suwisawiyómboya Anutu koro murí howero Anutu koro soreyaŋgo. Enendo Juda uni otoro tukuni teyaŋgurí ŋu wondo yunoro samaka yereyara. Ko naru rokóŋoro Anutuwore hariri teyara. ");
INSERT INTO nca_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Naru kano, suwoya 3 kilok ŋunde tiníqo, kapo ka qeneró muko sambo simó ka qeneró. Sambo simó ŋundo eneno mahero ŋande yaró, “Kornilius.” ");
INSERT INTO nca_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Yiní Kornilius kondé toŋetero sasaro tero ŋande yaró, “Uni parámi, do ka?” Yiníqo, ŋande yaró, “Anutuko keŋo haririke ŋuya oteteke meté ŋuya o qa-qa meté mu qembe ŋuro iŋote. ");
INSERT INTO nca_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Asa itakako uni ka asá yereka Jopa uyaro Saimon, owí kako Pita, ŋu seqayi. Qene nekoyika mahiní. ");
INSERT INTO nca_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Uni ŋundo makao kowí roŋgaruwoyara uni owí Saimon ŋundo yano yote. Saimon koro ya qu windi sumeyoro yote.” ");
INSERT INTO nca_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Sambo simómbo mito roto toŋiníqo, sunará simóŋo irisa koya kuma uni kanata ŋuya neko yereró. Kuma uni ŋuya Anutu koro murí howeyara, ko Kornilius koro sunará teyara. ");
INSERT INTO nca_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Neko yerero o soso ŋuro yimitoro asá yiriní Jopa uyareŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Asa uyareyate saraŋoní kosa keweroko ŋuno Jopa yendé kutaqemo uyareŋgurí. Ŋu naruko ŋuno Pita hariri tewero ya saŋano oró. ");
INSERT INTO nca_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Oro qímboro khumoro o newero quro iŋaró. Asa topémbo o roŋgaruwoyuriqo, iŋo-iŋoyó rohoréŋoní ");
INSERT INTO nca_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","sambo qeniní kosoní oka tuwi parámi qembe qeniní kato nuŋginí nimí kini ŋu toworo rondaŋiní nokono umburó. ");
INSERT INTO nca_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Tuwiko ŋuno po murí-murí, sire ko nú yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ko maŋgo kato ŋande miraró, “Pita, otoqoya nú-qare ka yuto ne.” ");
INSERT INTO nca_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Quko Pitako yaró, “Uni Parámi, noko no ma! No oka ka pusú ŋunde qu kama nanowó.” ");
INSERT INTO nca_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ko maŋgo ŋundo pitu ko ŋande yaró, “Anutuko o sara naŋge towaró ŋu keto pusú yero ma yewero.” ");
INSERT INTO nca_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ŋu soso naru kapusa ŋunde tunoqiní tuwi ŋu waka ta samboko koreko oró. ");
INSERT INTO nca_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Asa Pitako iŋo-iŋoyó kape tiní newondímo ŋande yaró, “O enesó qeneteno ŋuro murí muko, ŋu datiro?” Ene watí ŋunde naŋge iŋoyoní uni Korniliusko asa yereró ŋundo mahero Saimon koro ya ŋuro osese tero, yate mahero ya makono kaŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Kaŋero ŋande nekoyaŋgurí, “Saimon, owí kako Pita, ŋumbe ŋano yotepe ma kini?” ");
INSERT INTO nca_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita kapo qeneró ŋuro watí iŋondataqeyoní Yuqako ŋande miraró, “Qeno, uni kapusako ke seqa kereyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Asa ko otoqo uya eneya toŋi. Neneŋombo uni ŋu yorewe maheteŋgo. Ŋuro ma iŋondataqewero.” ");
INSERT INTO nca_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Yiní Pitako uro ŋande yimiraró, “No uni ŋu seqayoteŋgo. Ye do karo maheteŋgo?” ");
INSERT INTO nca_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Yiní ŋande yaŋgurí, “Kuma unindoro sopo-sopo uniye Kornilius, ŋundo nore asá niriní maheteto. Ŋuko uni roneneŋowí ko Anutu koro soreyote. Juda wini soso ŋande yeyoteŋgo, ‘Ŋuko uni meté,’ yeyoteŋgo. Asa sambo simó surumí kato ŋande miraró, ko enendo ke neko kiriníka keto yayómo mahero mande ka yeka iŋoweya.” ");
INSERT INTO nca_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ŋunde yiqo, yorero yano oro kunditaŋgurí. Asa saraŋoníqo, Pita otoqoro eneya toŋeŋgurí. Ko iŋondutu uni kumi Jopa noŋgo qu ŋuya toŋeŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Toŋeyate saraŋoní Sisaria yendémo ŋuno oŋgurí. Kornilius suwisawiyómboya nembe topémboya neko yiriní mahe koporo sopoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Asa Pita ya quroko oníqo, Kornilius eneno mahero khímo rokaráŋo umburo potoruku te inaró. ");
INSERT INTO nca_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Quko Pitako okokoworo ŋande yaró, “Otoqo. No ŋuya uni naŋge.” ");
INSERT INTO nca_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ŋunde yero irisa ŋundo mande yero ya quroko oriyó. Oro unipare qambu kopoyuri yiyaró. ");
INSERT INTO nca_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Asa Pitako ŋande yimiraró, “Yeŋombo iŋoteŋgo, Juda koro hutuŋo mande qundo ŋande yete, ko norendo uni wini meyowo quya kunditewero mepémo kini. Quko Anutuko ŋande no witú nereró, ko nondo uni ka qene rondaŋero pusú yewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ŋunde ŋuro no neko nereŋgurí quno kina maheteno. Asa ko ŋande osese yereteno, ye do murí karo no neko nereŋgurí?” ");
INSERT INTO nca_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ko Kornilius ŋande yaró, “Kosa naru nimí kini komoko, suwoya 3 kilok ŋandiro naŋge, no yanemo hariri teyanowó. Ŋunde teyowe uni ka kowe punu-punuyó muko hiyóqeyaró ŋundo mahero toŋenemo kaŋaró. ");
INSERT INTO nca_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ko ŋande yaró, ‘Kornilius, Anutuko haririke iŋote, ko uni otoro tukuni teyoteŋgo qu samaka yerero o yunoyote ŋuro iŋote. ");
INSERT INTO nca_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Asa ko uni ka asá yereka Jopa uyaya Saimon owí kako Pita nekoyika mahiní. Uni ŋu makao kowí roŋgaruwoyara uni owí Saimon koya kunditero yayó windi sumeyoro ŋuno yote,’ yaró. ");
INSERT INTO nca_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ŋunde ŋuro nondo waka ta mande ka rewe keno uyaró ŋu. Ko keto o meté te nunoro mahete. Asa nore soso koporo Anutu toŋímo ŋano kaŋato Uni Parámimbo mande kunaró ŋu yeka iŋowato.” ");
INSERT INTO nca_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Asa Pitako hurí tero ŋande yaró, “Hamó horé, itaka ŋande iŋoteno, ko Anutuko unipare soso ŋuro otete kanata naŋge howeyote. ");
INSERT INTO nca_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Enendo uni wini soso eneŋo soreyoteŋgo, ko o roneneŋowí mu teyoteŋgo, ŋu soso quro metéŋoyote. ");
INSERT INTO nca_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Anutuko miti mande ŋu rero nore Israel nunaró. Mande ŋuko ŋandiro: Yesu Kristo, uni soso koro Uni Paráminanimbo nore noriní Anutu koya newonde kanata teyoteto. ");
INSERT INTO nca_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yendo Judia mirako o soso tunoqaró ŋuro iŋoyoteŋgo, quko Galili mirako ŋuno hurí taró. Ŋuno Jonko unipare mande yesoworo sono re yunaró. ");
INSERT INTO nca_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Yate Anutuko Nasaret yendé uni ŋu, Yesu, rokóŋoro Yuqa Surumí inoro wimbu parámi inaró. Anutuko eneya yoní wimbo-wimbo uyaro o meté unipare te yunoyara, ko enendo Monimbuko uni rowore yereró ŋuno qu yoriní meté taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Asa norendo o soso Judia mirako, Yerusalem yendémo ŋuno taró ŋu qenero ŋuro yesowoyoteto. Ko unindo utoro te kano porowoyi khumaró. ");
INSERT INTO nca_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Quko naru kapusayómo ŋuno Anutuko okokowoní otoqoro tunomo tunoqaró. ");
INSERT INTO nca_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Quko uni soso ŋundo kama qeneŋgurí. Kini, uni Anutuko komo rokó yereró ŋundo naŋge qenetowó. Uni tapu koŋgo otoqoníqo, norendo eneya o kopo natowó. ");
INSERT INTO nca_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ko norendo unipareko mande ka yesowowato ŋuro nimiraró. Mande ŋuko ŋandiro, ko Anutuko Yesu rokóŋaró, ko enendo unipare yoteŋgo quya unipare komo khumaŋgurí quya ronda yereweya. ");
INSERT INTO nca_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ye-ye uni soso ŋande yeyaŋgo, ko unipare soso Yesu iŋondutuwoyoteŋgo ŋu, Anutuko Yesu owíwore quhuríye se rotoweya.” ");
INSERT INTO nca_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Asa Pitako mande ŋu watí yeyoníqo, Yuqa Surumí ŋundo umburo unipare soso mande ŋu iŋoyaŋgo quno ŋuno umburó. ");
INSERT INTO nca_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Iŋondutu uni koweye toŋaŋgurí qu Pita koya maheŋgurí ŋundo newondeye uraró, dokoro Yuqa Surumí ŋu uni wini meyowo saŋayemo ŋuya umburó. ");
INSERT INTO nca_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Hamó, umbuní mande enesó-enesówore yero Anutu owí hokoyaŋgurí. Asa Pitako ŋande yaró, ");
INSERT INTO nca_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Unipare ŋako Yuqa reteŋgo ŋunde naŋge norendo komo ratowó ŋundiro. Ŋunde ŋuro danimbo meté sono re yunoteto ŋu kusiyoweya?” ");
INSERT INTO nca_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Yero topé-topé ŋu ŋande yimiraró, “Yesu Kristo owímo sono re yunoyika.” Yiní sono re yunoyi kini tiní ŋande miraŋgurí, “Ke roto noreya soŋga ta yate ta,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Asá yerewí unindoya iŋondutu unipare Judia mirawore yoraŋgurí ŋu ŋuya mande piŋa ŋande iŋaŋgurí, ko unipare uni wini meyowo mu ŋuya Anutu koro mande qu raŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Asa ko Pitako Yerusalem oró quno ŋuno iŋondutu uni koweye toŋaŋgurí qundo qenero ");
INSERT INTO nca_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ŋande yaŋgurí, “Keto yano oro uni koweye kama toŋaŋgurí quya o kopo naŋgurí!” ");
INSERT INTO nca_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Asa Pitako hurí rero o soso tunoqaró okeyá ta ŋande yaró, ");
INSERT INTO nca_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“No Jopa yendémo yotoro hariri teyano, iŋo-iŋone rohoréŋoní o enesó-enesó ka qenenowó. Oka tuwi parámi qembe qenewe kato nuŋginí nimí kini ŋu toworo rondaŋiní nokono umburó. ");
INSERT INTO nca_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","No okeyá ta toŋetanowó, ko tuwiko ŋuno po murí-murí, nú-qare, sire ko nú yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ko maŋgo kato no nimiraró, ‘Pita, otoqoya yuto ne.’ ");
INSERT INTO nca_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Quko nondo ŋande yanowó, ‘Uni Parámi, noko no ma! No oka ka pusú ŋunde qu kama nanowó.’ ");
INSERT INTO nca_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ko maŋgo ŋundo pitu ko ŋande yaró, ‘Anutuko o sara naŋge towaró ŋu keto pusú yero ma yewero.’ ");
INSERT INTO nca_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ŋu soso naru kapusa ŋunde tunoqiní tuwi ŋu waka ta samboko koreko oró. ");
INSERT INTO nca_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Ŋu naruko naŋge uni kapusa qundo mahero nore yato quno ŋuno kaŋaŋgurí. Sisaria yendé uni kato uni ŋu asá yiri nono maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Mahiqo, Yuqako ŋande nimiraró, ‘Ma iŋondataqewero, eneya toŋe,’ yaró. Asa ko noya uni topo kande saŋiyoro kanata ŋuya uro uni ŋuro ya quroko otowó. ");
INSERT INTO nca_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ko enendo nore nimitoro ŋande yaró, ‘Sambo simó ka ya ŋano kaŋero ŋande nimiraró, “Keto uni ka asáŋoka Jopa oya Saimon owí kako Pita ŋu yeka mahiní. ");
INSERT INTO nca_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Enendo Anutuko keya suwisawikepoya rambaruru koŋgo yoreweya ŋuro mande ka kimiroweya.”’ ");
INSERT INTO nca_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Ŋunde yiníqo, no hurí rero mande yeyoweqo Yuqa Surumímbo komo noreno umburó ŋundiro naŋge eneno umburó. ");
INSERT INTO nca_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ko Uni Parámimbo mande komo yaró ŋuro iŋanowó. Ŋande yaró, ‘Jonko unipare sono re yunaró, quko yendo Yuqa Surumí rewaŋgo.’ ");
INSERT INTO nca_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ŋunde ŋuroko Anutuko puriŋo nore Uni Parámi Yesu Kristo iŋondutuwoyatowó qu re nunaró ŋu uni ŋu yunowero ye iŋaró tiníqo, no date tero eneŋo kheyó wisumuŋowano?” ");
INSERT INTO nca_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ŋunde yiní mande topé kama yero Anutu owí hokoro ŋande yaŋgurí, “Asa ko Anutuko uni wini meyowo ŋuya yoriní newondeye rohoréŋoro yoto-yotoye moré tewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Komo Stiven uroyi khumoní quhurí parámi tunoqiní iŋondutu unipare quhurí korowaŋgurí. Asa ko kumi wisikaraŋoro sorero Ponisia mirako, Saipras noko mosowímo, Antiok yendémo ŋuno uŋgurí. Ŋuno uro Juda uni naŋge mande yesowo yimiraŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Quko uni kumi keweroyemoko, Saipras uni koya Sairin yendé uni, ene Antiok oŋgurí quno ŋuno Uni Parámi Yesu ŋuro miti mande Grik uni ŋuya yesowo yimiraŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ŋunde yimitoro Uni Parámimboro wimbí eneno yoní unipare qambu newondeye rohoréŋoro Uni Parámi iŋondutuwoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Asa iŋondutu koro huru-huru ŋu Yerusalem ŋuno yoraŋgo ŋundo piŋa mande ŋu iŋoro Barnabas asáŋoyi Antiok uró. ");
INSERT INTO nca_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Uro Anutuko samaka-samaka tuwó unipare yunaró ŋu qene iŋoro niŋgu-niŋgu tero Uni Parámi suki howewero ŋuro yimitoro newondeye rukisoyaró. ");
INSERT INTO nca_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas ŋuko uni meté, ko Yuqa Surumí eneno maŋgoreyaró, iŋondutu kondé teyara. Ko unipare qambu horé Uni Parámimboro wini quroko maheyaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Asa Barnabas Tarsus yendémo oro Sol seqaró. ");
INSERT INTO nca_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Seqa qenero re Antiok mahero kumima naru kayata na soso Antiok ŋuno yariyó. Irisa ŋundo iŋondutu uniparetoya huruworo mande rondaqe unipare qambu yunoyariyó. Ko Antiok ŋuno naŋge unindo koretero Yesu koro iŋo-iŋo rewero unipareyó ŋu “Kristen” neko yereŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ŋu naruko ŋuno ye-ye uni kumi Yerusalem rotoro Antiok uŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ko keweroyemo kato, owí Akapas, kaŋero Yuqa koro wimbímo korare noko soso ŋuno tunoqeweya ŋuro yaró. (Korare ŋu, Kolotiasko unipare soso wiri yereró naruyómo ŋuno tunoqaró.) ");
INSERT INTO nca_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Asa iŋo-iŋo rewero uni ŋundo topoye Judia mirako yaŋgurí ŋu samaka yerewero mande kusiyaŋgurí. Uni kanata-kanata eneŋo wondoyó rondaŋero kumi se kopaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ŋunde koporo Barnabas koya Sol koya rokó yiri wondo ŋu rero huru-huru koro tapá unino oriyó. ");
INSERT INTO nca_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Asa ŋu naruko ŋuno wiri yerete uni Herot ŋundo o piyimi iŋondutu unipare kumi te yunowero yondowaró. ");
INSERT INTO nca_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ŋundiro enendo yiní Jems, Jon koro payó, ŋu suke parámimbo toŋoyi khumaró. ");
INSERT INTO nca_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Khumoní Juda unindo ŋuro niŋgu-niŋgu taŋgurí. Ŋunde ŋuroko Bret Yis Moré Kini ŋuro o ne-neko ŋuno Herotko Pita ŋuya rero kusi-kusi yano rotaró. ");
INSERT INTO nca_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ŋunde rotoní kuma unindoro kopo-kopo nimí kini qundo narune-narune sopoyaŋgo. Kopo-kopo kanata-kanata ŋuko kuma uni nimí kini naŋge. Herotko ŋande ye iŋaró, imemoŋgo Taka yereró quro o ne-ne ŋu kini tiníqo, Pita re umburo unipare toŋeyemo mande khono rotoweya. ");
INSERT INTO nca_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ŋunde ŋuro Pita kusi-kusi yano yora, quko iŋondutu koro huru-huru ŋundo suki-suki eneŋo Anutuwore hariri teyaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Yate Herotko ŋande ye iŋaró, kuyepo Pita rero mande khono rotowano. Quko kosa kama areyoníqo, suwonoko Pita kuma uni keweroyarimo etaró. Utó kondé irisa qundo kusiyaŋgurí, ko kuma uni irisa kusi-kusi ya mako soporo kaŋariyó. ");
INSERT INTO nca_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ko waka ta Uni Parámimboro sambo simó ka tunoqero kusi-kusi ya quroko hiyóqaró. Tunoqero Pita taŋgímo utoro okokoworo yaró, “Waka ta otoqo,” yiní utó irisa ŋu wisiyoro nokono umburiyó. ");
INSERT INTO nca_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Kowe sambo simómbo ŋande miraró, “Utómbo kowe punu-punuke kosopeŋgemo kusiyoya khe punu-punuke se kheŋgemo re.” Yiní ŋunde tiní ŋande miraró, “Kowe punu-punu piruke reya no nohowe.” ");
INSERT INTO nca_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Yiní kina howaró, quko sambo simómbo o taró ŋuko hamómbe ma kini, ŋuro kama iŋaró. Kini, kapo qeneteno naŋge ye iŋaró. ");
INSERT INTO nca_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Asa irisa ŋundo ya ŋuno oro sopo-sopo uni korete qu takaro, yate irisayó takaro mako aini ŋu ya wembó weŋa quno ŋuno uriyó. Ŋuno uriqo, mako ŋu eneŋombo koso yunoní yendémo uro khe ka howero oriyó. Ŋunde tiriqo, waka ta sambo simó ŋu Pita roto toŋeró. ");
INSERT INTO nca_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Toŋiní Pita iŋo-iŋoyó hiyóqiní ŋande yaró, “Asa hamó iŋoteno, Uni Parámimbo sambo simóŋo asáŋoní mahete, ko Herot kandí moŋgo noriní Juda unindoro iŋo-iŋoye piyimi ŋu takateno.” ");
INSERT INTO nca_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Asa ŋunde qene iŋoro enendo Jon, owí kako Mak, ŋuro nimí Mariako yano uyaró. Ya ŋuno unipare qambu koporo hariri teyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Asa Pitako hoŋgo pawa piru koro mako uroní sunará pare ka, owí Rota, ŋundo mako kosowero umburó. ");
INSERT INTO nca_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Quko Pita koro maŋgó iŋoro niŋgu-niŋgu parámi tero mako kama kosaró. Kina kheŋgeŋoro ya quroko oro yimiraró, “Pita makono kaŋeyote!” ");
INSERT INTO nca_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Yiní miraŋgurí, “Ke kape pare!” Quko kondé yaró, “Kini, hamó horé amena yote!” Enepa yaŋgurí, “Ŋuko eneŋo kapí na.” ");
INSERT INTO nca_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Asa Pita mako watí utoyoní uyaro mako kosoro qenero newondeye uraró. ");
INSERT INTO nca_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Quko kandímbo rokó-rokó tiní maŋgoye kusiyi Uni Parámimbo date kusi-kusi ya noŋgo re maheró ŋuro yimiraró. Ŋande yaró, “Ye Jems koya topo-toponanimboya ŋaro yimiri qembe,” yero yendémo uro mira meyowomo toŋeró. ");
INSERT INTO nca_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ita saraŋoníqo, kuma uni otoqoro parámi yukuworo epe osese-osese taŋgurí, “Pita dano ute?” ");
INSERT INTO nca_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herotko Pita seqayate kama qeneró. Ŋunde ŋuro enendo, kuma uni ŋu yore mande khono yorotoro yuroweka khumi, yero mande kusiyaró. Asa Herotko Judia mira ŋu rotoro Sisaria yendémo uro ŋuno yaró. ");
INSERT INTO nca_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Komo enendo kiro saŋgirí parámi Tair koya Saiton uniparetoya taró. Unipare ŋundo o qoyemboro Herot noŋgo naŋge siyoyaŋgurí. Ŋunde ŋuro, kiro mande ŋu roŋgaruwowato, yero uni ka owí Bilasitas koya koporo Herot qenewero maheŋgurí. Bilasitas ŋuko wiri yerete unindoro kho tero yakutí etewero qu sopoyaró. ");
INSERT INTO nca_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Asa naruyómo ŋuno Herotko wiri yerete unindoro kowe punu-punu meté horé qu re taró, ko mande kho inowero yakutímo kunditero mande ka unipareko yesowaró. ");
INSERT INTO nca_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Yesowoní iŋoro ŋande kiwe nekaŋgurí, “Ŋuko unindoro maŋgó kini, anutu kanata karo naŋge!” ");
INSERT INTO nca_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ŋunde yiqo, Herotko Anutu owí kama hokaró, ŋunde ŋuro waka ta Uni Parámimboro sambo simó kato uroní punipo newondí ni khumaró. ");
INSERT INTO nca_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Quko Anutu koro mandímbo parámi tero yendé soso toŋeró. ");
INSERT INTO nca_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Kowe Barnabas koya Sol koya khoyari Yerusalem ŋuno tiri kini tiníqo, pitu ko uriyó. Uro Jon, owí kako Mak, ŋu rero toŋeŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Asa iŋondutu koro huru-huru ŋu Antiok yendémo ŋunoko ye-ye uni kumimboya rondaqe-rondaqe uni kumi ŋuno yaŋgurí. Owéye muko ŋandiro: Barnabas, Simeon owí kako Niker, Lusius, Sairin yendé qu ka, Manain, wiri yerete uni Herot koya ya kanata quno parámi tariyó, ko Sol. ");
INSERT INTO nca_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Unipareto Uni Parámimboro potoruku tero kundiŋi teyuriqo, Yuqa Surumímbo ŋande yaró, “Ye Barnabas koya Sol koya rokó yirika nondo neko yerero kho yunanowó ŋu tewari.” ");
INSERT INTO nca_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Yiní kundiŋi tero hariri ti kini tiníqo, kandeye saŋayarimo rero asá yereŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Asa Yuqa Surumímbo yoriní toŋero Selusia yendémo ŋuno uriyó. Ŋu noŋgo waŋgowore Saipras noko mosowímo uyariyó. ");
INSERT INTO nca_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Uyaro Salamis yendémo ŋuno waŋgo rotoro oro Juda koro huru-huru yawore Anutu koro mande qu yeyariyó. Ko Jonko eneya yotoro samaka yereró. ");
INSERT INTO nca_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Asa Saipras noko mosowí soso ŋuwore khete uyareyate Papos yendé andusina ŋuno uyareŋgurí. Ŋuno Juda uni owí Bar-Yesu qeneŋgurí, enendo rukusí tero ye-ye uni kota taró. ");
INSERT INTO nca_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Eneko Rom koro uni parámi, owí Sergius Paulus, ŋuro topé ka. Uni kembé ŋundo Anutu koro mande qu iŋowero iŋoro Barnabas koya Sol koya neko yereró. ");
INSERT INTO nca_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Quko rukusí teyara uni ŋu, owí Grik mandewore Elimas nekoyaŋgo, enendo, uni kembé ŋundo iŋondutu ma tewero, ye iŋoro uni kembémboro iŋo-iŋoyó wosowero taró. ");
INSERT INTO nca_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Quko Sol, owí kako Pol, Yuqa Surumímboro wimbí parámi eneno maŋgoriní enendo Elimas kondé toŋetero ŋande yaró, ");
INSERT INTO nca_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Otete kota quya otete kaná-kaná quya keno maŋgoreyote! Keko Monimbu koro naŋuní, keto otete roneneŋowí ŋuro saŋgiríŋo tete! Kepe Uni Parámimboro khe roneneŋowí mu roworemowero kho ŋu rotoweyape ma kini? ");
INSERT INTO nca_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Asa iŋo! Itakako Uni Parámimboro kandímbo kurote, ko toŋeŋge pokaweya. Itaka yate kosa kama qeneweya.” Yiníqo, waka ta toŋí huriri tiní wimbo-wimbo uro uni kandí toworo khe witúŋowero qu ka seqayaró. ");
INSERT INTO nca_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kowe uni kembé ŋundo o ŋu qenero, Uni Parámi ŋuro mande rondaqe inariyó ŋuro kondé yukuworo iŋondutu taró. ");
INSERT INTO nca_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Asa Pol koya topé-topémboya waŋgowore Papos yendé rotoro Pambilia mirako Perika yendémo ŋuno uyareŋgurí. Ŋu noŋgo Jon yorotoro Yerusalem pitu ko uyarewero toŋeró. ");
INSERT INTO nca_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Toŋiní irisa ŋundo Perika rotoro khendo yate Pisitia mirako Antiok yendémo ŋuno oriyó. Ŋuno oro Sapat naruko ŋuno Juda koro huru-huru ya quroko oro kunditariyó. ");
INSERT INTO nca_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Asa uni kato Hutuŋo Mande koro mande kaya Ye-ye Unindoro mande kaya weyoní kini tiní huru-huru sopo-sopo uni ŋundo Pol, Barnabas neko yerero ŋande yaró, “Topo irisa, mande ka unipare newondeye rukisoyowero mande ka yimirowero iŋoyaqo meté yiri.” ");
INSERT INTO nca_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Asa Polko kaŋero kandímbo rokó-rokó tero ŋande yaró, “Ye Israel uni, ko ye Anutu kasiramo yoteŋgo qu, iŋoyi. ");
INSERT INTO nca_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel uniparetoro Anutuyembo usi-sinani rokó yereŋgurí. Ŋunde rokó yerero Isip mirako ŋuno yoriní qambu taŋgurí. Yate wimbí tero yoriní Isip rotoro maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Mahiqo, kumima naru 40 ŋunde rotoro mira wimbímo oteteye piyimi ŋuro topé kama tero ");
INSERT INTO nca_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kenan ŋunoko uni wini meyowo kande saŋiyoro irisa rambaruru yerero miraye ŋu rero Israel uni yunaró. ");
INSERT INTO nca_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Naru soso ŋuko kumima naru 450 ŋundiro taró. “Ŋu naruko ŋuno uni tapá enesó-enesó yoriní sopo yereŋgurí, yate ye-ye uni Samuel tunoqaró. ");
INSERT INTO nca_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ŋu naru ŋunoko unipareto wiri yerete uni karo kirayaŋgurí, asa ko Anutuko Sol, Kis naŋuní ŋu, Benjamin koro wini qu ka, ŋu re yunaró. Ko kumima naru 40 ŋunde rotoro Solko unipare wiri yereró. ");
INSERT INTO nca_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Quko Anutuko Sol re howero Dewit rokóŋoní wiri yerete uni tunoqaró. Rokóŋoro ŋuro ŋande yaró, ‘Dewit, Jesi naŋuní ŋu, no qene iŋoro ŋande iŋoyoteno, ko neneŋo nuŋguríne ŋuko ene nuŋgurí ŋunde naŋge. Enendo iŋo-iŋone soso ŋu howeyoweya.’ ");
INSERT INTO nca_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Anutuko komo mande kusiyaró ŋu howero Yesu, Rambaruru Koŋgo Yorewero Uni ŋu, Dewit koro sowe qu, ŋu riní Israel maheró. ");
INSERT INTO nca_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesu kama tunoqeyoní Jonko Israel uni soso newonde rohoréŋoro sono rewero mande qu yesowo yimiraró. ");
INSERT INTO nca_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jon khoyó kini tewero tiní ŋande yaró, ‘Ye no dani, yero iŋoteŋgo? Noko uni ŋu maheweya ŋu kini. Quko uni ka imemoŋgo no huwónemo maheweya ŋuro iŋoyi, nondo eneŋo khe punu-punuyómboro utó orosoyewero owéne moré kini.’ ");
INSERT INTO nca_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Topo okite, ye Abraham koro soweyómboya ye Anutu koro kasiramo yoteŋgo quya, iŋoyi. Anutuko nore rambaruru koŋgo yoreweya ŋuro mande ŋako riní noreno maheró. ");
INSERT INTO nca_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Dokoro unipare Yerusalem yoteŋgo qu, ko uni kembé-kembéye ŋuko Yesu okeyá kama iŋo inaŋgurí. Sapat naru rokóŋomo ye-ye unindoro mandeye weyoro kama iŋoyi tondaŋeyote. Ŋunde ŋuroko Yesu topé piyimi inaŋgurí quno ŋuno ye-ye unindoro mandeye ŋu ri hamó taró. ");
INSERT INTO nca_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ŋundiro naŋge ene quhuríyó moré kini qeneŋgurí, quko Pailat kandímo rato uroní khumoweya, ye iŋoro re inaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Inoyi uroyi khumoníqota ye-ye unindoro mandeye mepémo tunoqaró. Ŋunde tiní tipiriri koŋgo ri umbuní rero uni tapu kano ŋuno tapuŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Quko Anutuko okokowoní pitu ko uni tapu koŋgo otoqaró. ");
INSERT INTO nca_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Otoqoro naru parámi ŋuno unipare komo eneya Galili rotoro Yerusalem oŋgurí qundo ene qeneŋgurí. Ko itakako unipare ŋundo unipare eneŋo yesowoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Nore miti mande meté ŋa yesoworo ye yimiroteto. Anutuko komo mande usi-sinanimboya kusiyaró ŋu ");
INSERT INTO nca_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","itaka soweyemboya, nore naŋge, mande ŋu mepémo tunoqewero Yesu okokowoní uni tapu koŋgo otoqaró. Hariri Yambo irisayó quno ŋuno o ŋuro ŋande yete, “‘Ke neneŋo naŋone; Itaka no pisi kereteno.’ ");
INSERT INTO nca_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Enendo uni tapu koŋgo riní otoqaró. Otoqoro kowí kaŋuya kama puqeweya. Sokomeko mande ŋuro ŋande yete, “‘Nondo komo o meté horé qu se Dewit inowero yanowó mu, ŋu hamó se ye yunowano.’ ");
INSERT INTO nca_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ŋunde ŋuro mande meyowo ŋande yete, “‘Keŋo uni meté horé qu, ŋu roti uni tapuko kama puqeweya.’ ");
INSERT INTO nca_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Qeni, Dewitko nokono yaró quno ŋuno Anutu koro iŋo-iŋo qu howeroqota khumoní rero usi-símboya tapuŋi puqaró. ");
INSERT INTO nca_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Quko Anutuko uni okokowoní otoqaró, ŋuko kama puqaró. ");
INSERT INTO nca_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Ŋunde ŋuro, uni topo, mande ŋande yesowatokata, ye iŋoyi, Anutuko uni ŋuwore yeŋo quhuríye se rotoweya. Moses koro hutuŋo mandeko quhuríye se rotoro ye yoriní roneneŋowí tunoqewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Quko unipare soso iŋondutuwoyoteŋgo ŋundo uni ŋuwore roneneŋowí tunoqeteŋgo. ");
INSERT INTO nca_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ŋunde ŋuro meté toŋete sopoyi, komo mande ye-ye unindo ŋuro yaŋgurí ŋu yeno tunoqeweya koro. Ŋande yaŋgurí, ");
INSERT INTO nca_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“‘Yeko yesaráŋoyoteŋgo, ye toŋeti, ko iŋondata parámi teroqota rambaruru ti! Nondo yeŋo naruyemo kho ka tewano, ko uni kato kho ŋuro ye yimironíqo, yeko kama iŋondutuwowaŋgo.’” ");
INSERT INTO nca_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Asa ŋunde yiri kini tiní yendémo umburiqo, unipareto ŋande yaŋgurí, “Sapat naru aweno mande ŋako pitu ko nore nimirori qembe.” ");
INSERT INTO nca_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Yiqo, sopo-sopo unindo yorotoní yendémo umbuŋgurí. Umburo Juda uni qambu koya uni wini meyowo qu Juda koro muríye hamó howeyaŋgo ŋundo Pol koya Barnabas koya yohowaŋgurí. Irisa ŋundo mande yunoro Anutuko samaka-samaka tuwó yunaró ŋu saŋano kaŋewero ŋuro rukiso yiririyó. ");
INSERT INTO nca_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Asa imemoŋgo Sapat naruko ŋuno unipare soso ta yendé parámimo yaŋgurí qundo mahero Uni Parámimboro mande qu iŋowero quro huruwaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Quko Juda unindo unipare qambu ŋu yiyoro newonde tutu taŋgurí. Ŋunde tero Polko mande yaró ŋuro yesaráŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Quko Pol koya Barnabas koya wimbu rero mande ŋande yariyó, “Hamó, koretero nore Anutu koro mande qu rero ye Juda uni yunarowó. Quko mande ŋu huwóŋoro ŋande ye iŋoteŋgo, ko naru maheweya quro yoto-yotoyó ŋu rewero owénani moré kini, ye iŋoteŋgo. Ŋunde ŋuroko norendo rohoréŋoro uni wini meyowo yunowaro. ");
INSERT INTO nca_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Dokoro, Uni Parámimbo nore ŋande nimiraró, “‘Nondo ke korewe uni wini meyowomboro hiyóye tunoqeweya. Ŋunde tero unipare noko soso ŋu yimitoka rambaruru koŋgo yorewe.’” ");
INSERT INTO nca_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ŋunde yiriqo, uni wini meyowo ŋundo niŋgu-niŋgu tero Uni Parámimboro mande quro seré taŋgurí. Ko Anutuko unipare rokó yiriní naru maheweya quro yoto-yotoyó ŋu rewaŋgo, soso ŋundo iŋondutu taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Asa Uni Parámimboro mande qu mira soso ŋuno usayero toŋeró. ");
INSERT INTO nca_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Quko Juda unindo pare kumi owéye moré qu Anutu potoruku te inoyaŋgo quya yendé ŋuro uni pará-parámboya yori newonde piyimi tero Pol koya Barnabas koya o piyimi te yunoro yendé moŋgo yohowaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ŋunde ŋuro irisa ŋundo newondeyari saŋgirí rihimowero ŋuro kheyarimo murutó siyori nokono umburó. Ŋunde tero Antiok rotoro Aikoniam yendémo ŋuno uyaririyó. ");
INSERT INTO nca_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ko Antiok ŋuno Yesu koro iŋo-iŋo rewero unipareyó ŋundo niŋgu-niŋgu parámi tiqo, Yuqa Surumímbo newondeyemo maŋgoraró. ");
INSERT INTO nca_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Asa komo tariyó ŋunde naŋge Aikoniam yendémo ŋuno Juda koro huru-huru yano oro mande yariyó. Ŋunde yiriqo, Juda uni, Grik uni qambu parámi horé iŋondutuwoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Quko Juda uni kumi iŋondutu kama taŋgurí ŋundo uni wini meyowo mu iŋo-iŋoye ri uni topo ŋuro newonde piyimi taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Naru piru saŋga Aikoniam ŋuno yotoro wimbu rero Uni Parámimboro yesowori enendo eneŋo samaka-samaka tuwó qu unipare witú yerewero quro o wimbí moré enesó-enesó kandeyarimo taró. ");
INSERT INTO nca_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Quko yendé unipare soso ŋu usoworo irisa taŋgurí. Kumimbo Juda unindoya newonde kanata taŋgurí, ko kumimbo asá yerewí uni irisa ŋuya newonde kanata taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Yate uni wini meyowo ŋuya Juda unindoya uni kembéyemboya ŋundo Pol koya Barnabas koya o piyimi te yunoro wondopo yurowero mande ka kusiyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Kusiyoyiqo, iŋoro sorero Listira, Deripe yendé irisa Likonia mira kutaqe quno ŋuno toŋiriyó. ");
INSERT INTO nca_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ŋuno uyaro miti mande ŋu yesowoyariyó. ");
INSERT INTO nca_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listira yendémo ŋuno uni khí wimbí moré kini ka kina kunditeyaró, ŋuko nimímbo ene khí piyimi ŋunde pisiyaró, ko eneŋombo khete uyarewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Asa uni ŋundo Pol koro mandí iŋoní Polko kondé toŋetero ŋande ye iŋaró, ko uni ŋu Anutuko riní meté teweya ŋu iŋondutuwoyote, ye iŋaró. ");
INSERT INTO nca_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ŋunde ye iŋoro mande kondé ŋande miraró, “Ke otoqo kaŋe.” Yiní otoqo kaŋero khímbo uyaró. ");
INSERT INTO nca_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ŋunde tiní unipare qambu qundo Polko o taró ŋu qenero Likonia mandewore ŋande kiwe yaŋgurí, “Anutu kumimbo uni qembe tunoqero noreno umbutiri!” ");
INSERT INTO nca_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ŋunde yero Barnabas ŋuko anutu ka owí muko, “Sus,” ye nekaŋgurí. Ko Pol ŋuko mande yeyote uni, ŋuro anutu ka owí muko, “Heremes,” ye nekaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Sus koro ya surumí ka yendé sumeyoro yaró. Asa Sus koro o qa-qa uni ŋuya unipare qambu Pol koya Barnabas koro o qa-qa te yunowero ye iŋaŋgurí. Ŋunde ŋuro o qa-qa uni ŋundo makao urumuni kumi siyoro o nakayá kumi ŋuya siyoro yendé koro makoyómo maheró. ");
INSERT INTO nca_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Quko asá yerewí uni irisa ŋu o tewero ŋuro iŋori newondeyari piyo tiní kowe punu-punuyari se romboŋero kheŋgeŋoro unipare qambu keweroyemo uyare nekero ŋande yariyó, ");
INSERT INTO nca_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Otike, ye date koro ŋande teteŋgo? Noreko uni, ye qembe naŋge. Norendo miti mande ŋa yeno ŋande yeyotero, o kina-kina qu se potoruku re inoyoteŋgo ŋu rotoya rohoréŋoya Anutu yoto-yotoyó moré ŋuro iŋoyi. Anutu ŋuko noko sambo windi towaró. Ŋuya o soso ŋuno yote ŋu yondowaró. ");
INSERT INTO nca_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Hamó, usisamba naruko ŋuno enendo uni wini soso yorotoní ene oteteye naŋge howeyaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Quko Anutuko kina kama yorotoyara. Kini, suki-suki o meté te yunoyara. Enendo sono riní sambo rotoro yeno umbuní khono o meté-meté ŋu siyoní woteyote. Ko o qoyemboro se yunoní newondeye niŋgu-niŋgu teyote.” ");
INSERT INTO nca_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Asa ŋunde yariyó, quko unipare qambu ŋundo wimbu o qa-qa te yunowero tiqo, kusi yerewero quhurí tariyó. ");
INSERT INTO nca_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Quko Juda uni kumi Antiok noŋgo, Aikoniam noŋgo qu mahero unipare qambu quro iŋo-iŋoye ri otoqaró. Otoqoní wondo raŋoro Pol utoro, ene khuma, yero iŋoro ukúŋo re wosoro yendé sumeyoro rotaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Quko Yesu koro iŋo-iŋo rewero unipareto mahero wuririyoyuri Polko pitu ko otoqoro yendémo oŋgurí. Ko saraŋoníqo, eneya Barnabas koya Deripe yendémo ŋuno oriyó. ");
INSERT INTO nca_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Asa Deripe yendémo ŋuno miti mande yeyuriqo, unipare qambu qundo iŋo-iŋo rewero unipare tunoqaŋgurí. Yate irisa ŋundo rohoréŋoro pitu ko Listira, Aikoniam, Antiok uriyó. ");
INSERT INTO nca_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Uro yendéne-yendéne ŋuno iŋo-iŋo rewero unipare ŋu wikundi yerero ŋande yariyó, “Ye iŋondutu watí teyuri qembe. Nore Anutuko unipareyó wiri yereyote naruyómo oweroqo koretero quhurí qambu korowowato,” yariyó. ");
INSERT INTO nca_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Huru-huru kanata-kanata quno ŋuno uni kumi Uni Parámi iŋondutuwoyaŋgurí qu yorero huru-huru koro tapá uni rokó yiririyó. Rokó yerero kundiŋi tero hariri tero Uni Parámimboro kandímo yorotariyó. ");
INSERT INTO nca_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ŋu noŋgo uyaro Pisitia mirawore uyaro, yate Pambilia mirako ŋuno uriyó. ");
INSERT INTO nca_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ŋuno uro Perika yendémo oro mande yesoworo rotoro Atalia yendémo ŋuno uriyó. ");
INSERT INTO nca_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Atalia ŋu noŋgo waŋgowore toŋero Antiok uyaririyó. Komo Antiok unipareto kho tewero quro rokó yiriqo, Anutu koro samaka-samaka tuwó quwore toŋiriyó. Asa kho ŋu kini tiní pitu ko mahiriyó. ");
INSERT INTO nca_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Mahero huru-huru unipare ŋuno quya koporo Anutuko o soso enewore taró ŋuro piŋa mande ŋande yariyó, ko Anutuko uni wini meyowo mako koso yunoní iŋondutu taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ŋunde yero irisa naru piru saŋga iŋo-iŋo rewero unipare ŋuya yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Asa uni kumimbo Judia mira rotoro Antiok yendémo ŋuno umburo iŋondutu uni mande rondaqe yunoro ŋande yaŋgurí, “Ye Mosesko murí rondaqe yunaró ŋu howero koweye kama toŋowaŋgo tiníqo, Anutuko rambaruru koŋgo ye kama yoreweya.” ");
INSERT INTO nca_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ŋunde yiqo, Pol koya Barnabas koya saŋgirí parámi tero eneya mandeto kuma taŋgurí. Ŋunde ŋuro uni topo ŋundo Pol, Barnabas ko uni kumi meyowo ŋuya Yerusalem oro asá yerewí uni ŋuya huru-huru koro tapá unindoya mande roŋgaruwowero quro rokó yereŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Rokó yerero huru-huru unipareto asá yiri uyaro Ponisia mira, Samaria mira kewerowore oŋgurí. Oyate uni topo ŋuno piŋa mande ŋande yimiraŋgurí, ko uni wini meyowo kumimbo Anutusina newonde rohoré taŋgurí, yimiri niŋgu-niŋgu parámi taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Oyate Yerusalem mahiqo, huru-huru uniparetoya asá yerewí unindoya huru-huru koro tapá unindoya yorero oŋgurí. Ko Pol koya Barnabas koya Anutuko o soso enewore taró ŋuro yariyó. ");
INSERT INTO nca_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Quko iŋondutu uni kumi Farisi wini koŋgo qundo otoqoro ŋande yaŋgurí, “Ye ŋande yi qembe, ko uni wini meyowo qundo eneŋo koweye toŋoya Moses koro hutuŋo mande ŋu howewaŋgo.” ");
INSERT INTO nca_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Yiqo, asá yerewí unindoya tapá unindoya mande ŋu roŋgaruwowero kopaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Koporo mande qambu yiqo, Pitako kaŋero ŋande yimiraró, “Uni topo, ye iŋoteŋgo, Anutuko komo ye keweroyemo no rokó niriní miti mande rero uni wini meyowo yunoyowe iŋoro iŋondutu taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Anutuko unipare soso newondeye qene iŋoyote, ko enendo uni ŋuro newondeye qene iŋoro nore nunaró ŋunde qembe Yuqa Surumí re yunaró. ");
INSERT INTO nca_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ŋunde tiníqo, kato noreya eneya ronda yerewero mepémo kini. Anutuko eneŋo iŋondutuyewore newondeye riní sara taró. ");
INSERT INTO nca_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ŋunde ŋuroko ye date koro, Anutu towoŋato, yero iŋoyoteŋgo? Ye o quhurí piyimi ŋa rero Yesu koro iŋo-iŋo rewero unipareyó saŋayemo ma kusiyowero. Komo usi-sinanimboya nore ŋuya quhurí ŋu korowowero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Quko uni wini meyowo ŋundo nore iŋondutu tatowó ŋundiro naŋge Uni Parámi Yesu koro samaka-samaka tuwó ŋuwore iŋondutu tiqo, rambaruru koŋgo yoreweya.” ");
INSERT INTO nca_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ŋunde yiní kini tiní mondó yuri Pol koya Barnabas koya Anutuko o wimbí moré enesó-enesó kandeyarimo uni wini meyowo keweroyemo taró ŋuro yariyó. ");
INSERT INTO nca_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ŋunde yiriqo, Jemsko ŋande yaró, “Uni topo, mandene ŋa iŋoyi. ");
INSERT INTO nca_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Koretero Saimon ŋande yete, ko Anutuko mahero uni wini meyowo kumi yoriní eneŋo unipareyó tunoqaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ko ye-ye unindoro mandeye ŋuko ŋundiro naŋge. Komo suki ŋande nakayáŋaŋgurí, ");
INSERT INTO nca_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Imemoŋgo pitu ko mahero Dewitko ya qu komo toqaró ŋuko nondo pitu ko rewano. Ya ŋuro oyó kumi piyo taró, ŋuko nondo keta rewe pitu ko kaŋeweya. ");
INSERT INTO nca_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ŋunde tero uni watí yoteŋgo ŋuya uni wini meyowo soso neneŋo owéne towoyoteŋgo ŋuya Uni Parámi seqawaŋgo, peka. Uni Parámi o soso ŋu riní tunoqete ŋundo ŋundiro yete. ");
INSERT INTO nca_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Komo suki o soso ŋuro iŋatowó. ");
INSERT INTO nca_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Ŋunde ŋuro no iŋo-iŋone muko ŋandiro: uni wini meyowo qundo Anutusina newonde rohoré teyoteŋgo, nore koweyumu kama yunowato. ");
INSERT INTO nca_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Kini, nore sokome ka eneno nakayáŋoro ŋande yimirowato, ko oka unindo rero anutu kota-kota te inaŋgurí ŋu ma newero, ko se simbururu ma tewero, ko númbowe unindo puŋeye kusiyoyi khumi ŋu ma newero, ko sitú ŋuya ma newero. ");
INSERT INTO nca_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Dokoro komo suki yate-yate itaka ŋuya Sapat naruko unindo Moses koro hutuŋo mande ŋu Juda koro huru-huru yayemo weyo yesowoyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ŋunde ŋuro asá yerewí unindoya tapá unindoya huru-huru unipare soso ŋuya mande kusiyoro keweroye moŋgo uni irisa rokó yerero Pol koya Barnabas koya Antiok uwero rokó yereŋgurí. Jutas, owí kako Barisapas, koya Sailas rokó yereŋgurí. Huru-huru koro tapá uni irisa ŋu asá yerero ");
INSERT INTO nca_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","sokomeko mande ka nakayáŋoro kandeyarimo ri toŋeŋgurí. Mande ŋuko ŋandiro, Asá yerewí unindoya tapá unindoya, yeŋo topo-topoye, sokome ŋa nakayáŋato ye uni wini meyowo iŋondutu tero Antiok yendé, Siria mira, Silisia mirako yoteŋgo qu, yeno uyarete. Kosa meté. ");
INSERT INTO nca_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nore koŋgo ŋande iŋatowó, ko uni kumi nore koŋgo uro mande kondé ka yimiriqo, iŋondata tero yeŋo iŋo-iŋoye quhurí teyara. Quko norendo mande ŋu yewero kama asá yeretowó. ");
INSERT INTO nca_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Asa ko nore newonde kanata na tero mande kusiyoro uni topo irisa rokó yerero asá yereto noreŋo toponani horé Barnabas, Pol ŋuya yeno uteŋgo. ");
INSERT INTO nca_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Irisa ŋuko eneŋo yoto-yotoyari rotoro Uni Paráminani Yesu Kristo koro owímo khoyó teyotiri. ");
INSERT INTO nca_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ŋunde ŋuro norendo Jutas koya Sailas koya asá yeretowó. Eneŋo maŋgoyarimbo mande ŋa re ye yunowari. ");
INSERT INTO nca_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Dokoro Yuqa Surumímboya noreya ŋande ye iŋatowó, ye meté otete kumi naŋge howewaŋgo, o quhurí meyowo ye saŋayemo kama rewato. ");
INSERT INTO nca_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Otete ŋuko ŋandiro, ye oka unindo rero anutu kota-kota o te yunaŋgurí ŋu ma newero, sitú ŋuya ma newero, númbowe unindo puŋeye kusiyoyi khumi ŋu ma newero, se simbururu ma tewero. Ko ye o ŋu takawaŋgo tiníqo, meté yowaŋgo. Ime yuri. ");
INSERT INTO nca_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Asa asá yiri Antiok uro unipare kopo yerero sokome ŋu re yunaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Unipare sokome ŋu weyoyi newondeye wikundiyoní niŋgu-niŋgu taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Jutas koya Sailas koyako ye-ye uni. Ŋunde ŋuro mande meté qambu uni topo yimitoro wikundi yiririyó. ");
INSERT INTO nca_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Yate naru piru ŋunde rotoní uni topo ŋundo uni irisa ŋu yorero imemo asá yiri oro unindo asá yiri mahiriyó quno ŋuno pitu ko oriyó. ");
INSERT INTO nca_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(-) ");
INSERT INTO nca_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Quko Pol koya Barnabas koya Antiok ŋuno yariyó. Irisa ŋuya meyowo ŋuya mande rondaqe unipare yunoro miti mande yesowoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Imemoŋgo ta Polko Barnabas ŋande miraró, “Nore irisa oya uni topo yendémo Uni Parámimboro mande qu yesowarowó quno yoteŋgo ŋundo date yoteŋgo, ŋu qene iŋowaro.” ");
INSERT INTO nca_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabasko Jon, owí kako Mak, ŋu re ŋuya owero ye iŋaró. ");
INSERT INTO nca_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Quko Polko ŋande yaró, “Uni ŋako komo Pambilia yendémo ŋuno norotaró ŋuno qu, enendo noreya kho kama taró, ŋunde ŋuro noreya kama uwato.” ");
INSERT INTO nca_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ŋunde yero kiro puso tero usowo-sowo tariyó. Barnabasko Mak rero waŋgowore Saipras noko mosowímo ŋuno oriyó. ");
INSERT INTO nca_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Polko Sailas riní uni topo ŋuno qundo ŋande yaŋgurí, “Uni Parámimboro samaka-samaka tuwó yariya yoweya,” yi toŋiriyó. ");
INSERT INTO nca_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Toŋero Siria mirawore ko Silisia mirawore uyaro Anutu koro huru-huru ŋu rukiso yereyariyó. ");
INSERT INTO nca_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Asa Polko uyareyate Deripe yendémo ŋuno uroqo Listira yendémo ŋuno ŋuya uró. Ŋunoko Yesu koro iŋo-iŋo rewero uni ka ŋuno yora, owí Timoti. Juda pare ka iŋondutu taró, ŋuro naŋuní, quko iwí muko Grik uni ka. ");
INSERT INTO nca_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Topo unipare Listira noŋgo ko Aikoniam yendé moŋgo qundo oteteyó ŋuro ŋande yaŋgurí, “Timoti ŋuko uni meté.” ");
INSERT INTO nca_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Polko Timoti koya toŋewero ye iŋaró. Ŋunde ŋuro Juda uni ŋuno yaŋgo ŋuro iŋoro Timoti re kowí toŋaró. Dokoro uni soso iŋaŋgurí, Timoti iwí muko Grik uni ka. ");
INSERT INTO nca_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Asa toŋero uyareyate yendéne-yendéne oro, komo asá yerewí unindoya tapá unindoya Yerusalem ŋuno mande kusiyoro sokome ŋu nakayáŋaŋgurí qu, ŋu rero unipare yunaŋgurí. Yunoro ŋande yimiraŋgurí, “Ye ŋu naŋge howeyuri.” ");
INSERT INTO nca_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ŋunde ŋuro unipare iŋondutuye kondé horé tiní naru rokóŋoro huru-huru ŋundo sowe tiní qambu tunoqeyara. ");
INSERT INTO nca_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Asa Yuqa Surumímbo Pol koya topémboya soré yerero Esia mira parámi quno ŋuno mande ma yesowowero ŋunde yero soré yereró. Asa ko Pirikia mira ko Galesia mira kewerowore yateyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Yate-yate Misia mira koro wembóŋgo ŋuno mahero Bitinia mirako uyarewero ye iŋaŋgurí. Quko Yesu koro Yuqa ŋundo soré yereró. ");
INSERT INTO nca_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Asa ko Misia mira ŋu takaro windi tapémo Tiroas yendémo ŋuno uŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Suwono Polko Masedonia mira koŋgo uni qu ka quko qeniní kaŋero Pol nekoro ŋande miraró, “Ke windi karóŋoya Masedonia ŋano mahe nore samaka yere,” yaró. ");
INSERT INTO nca_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ŋunde qenero nore ŋande iŋatowó, ko Anutuko miti mande ŋuno yesowo yimirowero neko nereró. Ŋunde ŋuro Masedonia uyarewero sunará tatowó. ");
INSERT INTO nca_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Asa Tiroas noŋgo waŋgowore roneneŋo karóŋoro Samotires noko mosowímo ŋuno uyatowó. Ko saraŋoníqo, Neapolis yendé windi tapémo ŋuno otowó. ");
INSERT INTO nca_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ŋu noŋgo Filipai yendémo khewore otowó. Komo Rom unindo yendé ŋu rero ŋuno kunditeyaŋgo. Ŋuko Masedonia mira koro yendé korete qu. Nore naru piru ta yendémo ŋuno yatowó. ");
INSERT INTO nca_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Asa Sapat naruko ŋuno yendé rotoro hariri tewero mira tomó ka seqaro sono kano utowó. Uro kunditero pare kumi ŋuno kopoyaŋgurí ŋu yiyoro eneya mande yatowó. ");
INSERT INTO nca_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Taiataira mira koŋgo pare ka, owí muko Litia, ŋundo mande ŋu iŋaró. Enendo tuwi mandumi huririyó soweyoyara, ko Anutu potoruku te inoyara. Asa iŋoní Uni Parámimbo newondí riní Polko mande yaró ŋu iŋondutuwoyaró. ");
INSERT INTO nca_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Iŋondutuworo eneya suwisawiyómboya sono raŋgurí. Ri kini tiní nore nimiraró, “Ye nondo Uni Parámimboro hamó iŋondutu teyoteno, yero iŋoteŋgo tiníqo, asa meté mahero yanemo yuri qembe.” Ŋunde yiníqo, eneya uyatowó. ");
INSERT INTO nca_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Naru kano nore hariri tewero mira tomómo ŋuno utoqo kho pare kato kheko wisumu nerero niyaró. Yuqa kato pare newondímo yoní eneŋo maŋgómo do ka imemo tunoqeweya ŋuro yeyara, ko unipareto mandí iŋowero wondo parámi eneŋo sopo-sopoyó yunoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Asa enendo nore nohowero kondé ŋande kiweyaró, “Uni ŋako Anutu Koreko Horé yote ŋuro sunará simóŋo. Enendo rambaruru takawero kheyó ye yimitoyoteŋgo,” yaró. ");
INSERT INTO nca_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Kosa naru qambu ŋuno pare ŋu ŋunde te yate-yate Pol ŋuro piyimiŋoro rohoréŋoro yuqa ŋu ŋande miraró, “No Yesu Kristo ŋuro owímo kimiroteno, pare ŋa roto toŋe!” Ŋunde yiníqota roto toŋeró. ");
INSERT INTO nca_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Asa yuqa ŋu roto toŋiní pare ŋuro sopo-sopoyómbo ŋande ye iŋaŋgurí, ko wondo kaŋuya kama rewaŋgo. Ŋunde ŋuro Pol koya Sailas koya yondoworo yowosoro tapá uni kopoyaŋgo quno oŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Yorero mande ronda-ronda uni toŋeyemo oro ŋande yimiraŋgurí, “Juda uni irisa ŋando noreŋo yendé unipare qu okoko yiriri newondeye piyo tete. ");
INSERT INTO nca_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Enendo murí ka rondaqe yunoyotiri, quko nore Rom unipareto muríye ŋu howewero mepémo kini.” ");
INSERT INTO nca_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Unipare qambu qundo uni irisa ŋuya kiro puso yero yesará yereŋgurí. Ko mande ronda-ronda unindo kumba tukuni yaŋgurí, kowe punu-punuyari se rotoya kumukopo yuto haususu yiri. ");
INSERT INTO nca_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ŋunde yiqo, kumukopo qambu yutoro yorero kusi-kusi yano yorotaŋgurí. Yorotoro mande kondé ka kusi-kusi ya koro sopo-sopo ŋu miraŋgurí, ke ŋa meté sopo yere qembe. ");
INSERT INTO nca_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Mande kondé ŋu iŋoro sopo-sopo uni ŋundo yorero kusi-kusi ya quroko yorotoro kheyari kewá irisa-irisa keweroko quno ŋuno kusi yereró. ");
INSERT INTO nca_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Suwo keweroko Pol koya Sailas koya Anutuwore hariri tero yambo yeyori kusi-kusi uni kumi iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Asa waka ta kunduru parámi ka raŋoro kusi-kusi ya tatáŋo soso toŋo wisiyoní ya mako soso kosoní utó kondé qu kusi-kusi uni kandeyemo ŋu soso tondaŋaró. ");
INSERT INTO nca_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ŋunde tiní sopo-sopo uni ŋu otoqoro kusi-kusi ya mako qeneró muko soso kosoro koŋgó taró. Qenero kusi-kusi uni soso soreteŋgo, peka, ye iŋoro suke parámi ka wosoro eneŋo kowí uto khumowero taró. ");
INSERT INTO nca_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Quko Polko kondé nekaró, “Koweke ma rambaruruwowero! Noreko soso ŋana yoteto!” ");
INSERT INTO nca_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Sopo-sopo uni ŋu suru koro nekoní re mahe inoyi toworo kheŋgeŋoro ya quroko oro khe kandí yukuwoní Pol, Sailas taŋgeyarimo umbu raŋaró. ");
INSERT INTO nca_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Asa yore yondoworo mirako umburo ŋande yaró, “Awa-awane, no date tero rambaruru takawano?” ");
INSERT INTO nca_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Yiní ŋande yariyó, “Ke Uni Parámi Yesu koro iŋondutu tekata, Anutuko keya suwisawikepoya yoriní rambaruru takawaŋgo.” ");
INSERT INTO nca_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ŋunde yero eneya suwisawiyómboya Uni Parámimboro mande qu re yunariyó. ");
INSERT INTO nca_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ko suwo keweroko naŋge sopo-sopo uni ŋundo yorero mamayari sonowaró. Sonowoní eneya suwisawiyómboya yorero sono re yunariyó. ");
INSERT INTO nca_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ŋunde tiriqo, yorero yayómo oro o qoyarimboro yunaró. Ko yano kopoyaŋgurí ŋundo niŋgu-niŋgu parámi taŋgurí, dokoro enendo Anutu iŋondutuwoyaró. ");
INSERT INTO nca_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Asa saraŋoníqo, mande ronda-ronda unindo kumba tukuni asá yiri mahero yaŋgurí, “Keto uni irisa ŋu yorotoka toŋiri.” ");
INSERT INTO nca_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Yiri kusi-kusi ya sopo-sopo ŋundo Pol miraró, “Mande ronda-ronda unindo yari yorotika toŋiri yeteŋgo. Ŋunde ŋuro kusi-kusi ya roto toŋiri newondeyari ime yoní.” ");
INSERT INTO nca_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Quko Polko kumba tukuni yimiraró, “Nore irisa ŋako Rom uni, ko o piyimi ka kama taro. Quko ronda-ronda uni ŋundo nore nondoworo unipare toŋeyemo haususu nerero kusi-kusi yano ŋano norotaŋgo. Ko itaka mondó ta noroti toŋewaro, peka? Kini horé! Eneŋombo mahero norero eneya mirako amuno uwato.” ");
INSERT INTO nca_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Asa kumba tukunimbo ronda-ronda uni mande ŋu yimiraŋgurí. Yimitoro, irisa ŋuko Rom koro uni qu, yi iŋoro sasaro taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Uyaro o piyimi taŋgurí ŋuro yuŋguna yerero yorero yendémo umburo kira yereŋgurí, ko mira ŋa rotoya mira meyowomo toŋiri. ");
INSERT INTO nca_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ŋunde yiqo, kusi-kusi ya rotoro Litiako yano oriyó. Oro uni topo ŋuno yiyoro newondeye rukisoyoro toŋiriyó. ");
INSERT INTO nca_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Asa Pol koya Sailas koya kheyarimbo yate Ambipolis yendé ko Apolonia yendéwore uyareyate Tesalonaika yendémo oriyó. Yendémo ŋuno Juda koro huru-huru ya qu ka ŋuno yora. ");
INSERT INTO nca_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Asa Sapat naru kapusa ŋunoko Polko eneŋo murí howero huru-huru yano oro Anutu koro sokome ŋu rondaqe yunoro ");
INSERT INTO nca_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ŋande witú yereró, ko mande ŋuko ŋande yete, Kristo ŋuko hamó kowe surumí rero khumoro pitu ko otoqoweya. Ko ŋande yaró, “Kristo ŋuko Yesu na, nondo eneŋo yesowoyoteno ŋa.” ");
INSERT INTO nca_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ŋunde yiní Juda unipare kumimboya Grik unipare Anutu potoruku te inoyaŋgo qambu ŋuya yendé ŋuro pare pará-pará kumimboya iŋondutu tero Pol koya Sailas koya kopaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Quko Juda uni kumimbo ŋuro newonde tutu tero uni piyimi kina yendémo wimbo-wimbo kunditeyaŋgo ŋuya unipare qambu ŋuya yorero kuma tunoqewero newondeye kasiyaŋgurí. Asa enendo Pol, Sailas yowosoro mande khono yorotowero quro Jesonko ya qu wisumuŋoro seqa yereŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Irisa ŋu kama yiyoro Jeson koya uni topo kumimboya yowosoro yendé ŋuro tapá uni toŋeyemo yorotoro kondé ŋande yaŋgurí, “Uni ŋu mira soso ŋuno unipare newondeye roworemoyotiri ŋundo yendé ŋano mahetiri ŋa. ");
INSERT INTO nca_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ko Jesonko uni ŋu yore ene yano oró. Uni ŋako Sisa koro hutuŋo mande soso ŋu wendaqero ŋande yeyoteŋgo, wiri yerete uni parámi kaŋuya yote, owí muko Yesu.” ");
INSERT INTO nca_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ŋunde yiqo, unipare qambu ŋuya tapá unindoya iŋondata parámi taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ŋunde ŋuro tapá unindo yimiri Jeson koya uni meyowo ŋuya mone yuni towi roto toŋeŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Asa suwo tiníqo, uni topo ŋundo Pol koya Sailas koya asá yiri Beria yendémo ŋuno uyaririyó. Ŋuno Juda koro huru-huru ya quroko oriyó. ");
INSERT INTO nca_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beria unindoro muríye muko meté horé, ko ŋundo Tesalonaika yendé unindoro muríye takaró. Irisa ŋundo mande yariyó ŋu iŋoro metéŋoyaŋgurí. Kowe naru rokóŋoro mandeyari ŋu hamómbe ma kini iŋowero quro murí Anutu koro sokome qu weyo seqayaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ŋunde ŋuro Juda uni qambu iŋondutu taŋgurí. Grik pare kumi owéye moré ko Grik uni qambu ŋuya iŋondutu taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Asa Juda unindo Tesalonaika ŋuno ŋande iŋaŋgurí, ko Polko Beria ŋuno Anutu koro mande yesowoyaró. Ŋunde ŋuro ŋuno mahero unipare qambu wimbo-wimbo yoraŋgo ŋu newondeye kasiyoyi saŋgirí taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Waka ta uni topo ŋundo Pol asáŋoyi windi tapémo uró, quko Sailas koya Timoti koyako Beria ŋuno yariyó. ");
INSERT INTO nca_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Asa unindo Pol re kheko umbuŋgurí, reyate Atens yendé parámimo rotaŋgurí. Rotoro pitu ko oro Polko Sailas, Timoti koro mande kondé ka yaró ŋu re oŋgurí. Mande ŋuko ŋandiro, “Yari waka ta nono mahiri qembe,” yaró. ");
INSERT INTO nca_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Asa Pol Atens yendé parámimo ŋuno sopo yereyate yendémo ŋuno anutu kota-kota koro kapí-kapí qambu towoyuri qeneró. Ŋuro newondí piyo taró. ");
INSERT INTO nca_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ŋunde tero ene huru-huru yano oro Juda unindoya uni wini meyowo Anutu potoruku te inoyaŋgo quya mande taró. Ko naru rokóŋoro kopo-kopo yendémo oro unipare ŋuno kopoyaŋgo ŋuya mande taró. ");
INSERT INTO nca_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Kopo-kopo yendémo ŋuno iŋo-iŋo uni kumimbo mahero eneya mande taŋgurí. Uni kumi ŋuko, “Epikurian,” ye nekoyaŋgurí, ko kumi, “Stoik,” ye nekoyaŋgurí. Kumi ŋande yaŋgurí, “Uni ŋako wuruwara mande yeyote. Do ka yewero yete?” Quko kumi, “Mira meyowomboro anutuye ŋuro yesowoyote, peka,” yaŋgurí. Ŋunde yaŋgurí, dokoro Polko Yesu uni tapu koŋgo pitu ko otoqaró ŋuro miti mande yesowaró. ");
INSERT INTO nca_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Asa ko Pol rero tapá unindoro huru-huru ŋu, owé muko Areopakus, ŋuno oŋgurí. Oro ŋande yaŋgurí, “Ketope meté mande keta rondaqe yunoyote ŋu nore nimiri iŋowato? ");
INSERT INTO nca_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Hamó, mande amana yi iŋoteto, ko murí ŋuro iŋowero ye iŋoteto.” ");
INSERT INTO nca_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Atens yendémo ŋuno naru rokóŋoro uni soso, asa mira simburí ŋuya mira meyowo quya, kina kaŋero mande amana ŋu iŋoro mande ŋuro epe mito-mito teyaŋgo.) ");
INSERT INTO nca_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Asa Polko Areopakus huru-huru keweroyemo kaŋero ŋande yimiraró, “Ye Atens uni, nondo yeŋo muríye qeneyoteno, yendo naru rokóŋo anutu enesó-enesó potoruku te yunoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Hamó, nondo yendéyewore uyareyate o ŋuro potoruku te yunoyoteŋgo qu qeneyoteno. Qenero wondo yakutí ka qeneteno, ko ŋuno ŋande nakayáŋgurí, ‘Ŋako anutu ka nore kama iŋo inoteto quro wondo yakutí.’ Asa itaka nondo Anutu ye kama iŋo inoyoteŋo, quko potoruku te inoyoteŋgo ŋuro yesowowe teteno. ");
INSERT INTO nca_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Anutu ŋuko noko koya o soso ŋuno yorote ŋuya yondowaró, Anutu ŋuko noko sambo koro uni parámi ŋu. Ŋunde ŋuro eneko unindo ya kandeyembo towaŋgurí quno ŋuno kama kunditeyote. ");
INSERT INTO nca_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Kowe o karo tukuni tiní unindo kandeyembo kama samakaŋoyoteŋgo. Kini, eneŋombo uni soso yoto-yotoye ŋuya yuqaye ŋuya soso yunoyote. ");
INSERT INTO nca_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Enendo puko kanata naŋge qu noŋgo uni wini soso yondowoní tunoqi mirane-mirane yorotaró. Ŋunde tero eneŋombo naruye yunoro miraye rokóŋaró. ");
INSERT INTO nca_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ŋunde tero, unindo no seqa nerewero wimbo-wimbo toŋeteroqo niyowaŋgo, peka, ye iŋaró. Ko enendo nore soso taŋgenanimo yote. ");
INSERT INTO nca_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Hamó, yeŋo iŋo-iŋo uniye kato ŋande yaró, ‘Ene quroyómo naŋge norendo kunditero otoqo uya mahe tero yoteto,’ yaró, ko kako ŋande yaró, ‘Noreko eneŋo simó,’ yaró. ");
INSERT INTO nca_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Asa, nore Anutu koro simó yoteto, ŋunde ŋuro oka unindo yero iŋoro towaró qu, asa gol kape ma silwape ma wondo ŋuko Anutu qembe yero ma iŋowero. ");
INSERT INTO nca_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ŋunde ŋuroko komoko Anutuko yeŋo oteteye kape-kape ŋuro kama iŋaró, quko itakako ŋande yete, ye uni noko soso ŋuno yoteŋgo qu, ye newonde rohoré ti. ");
INSERT INTO nca_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Dokoro enendo otete roneneŋowí howero uni soso ronda yerewero quro naru ka rokóŋaró. Ko ronda-ronda uni ka rokóŋaró. Nore meté uni ŋu iŋondutuwowato, dokoro uni ŋu khumoní Anutuko uni tapu koŋgo riní otoqaró.” ");
INSERT INTO nca_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ŋunde yiní uni ka uni khumaró qundo pitu ko otoqaró ŋuro mandí iŋaŋgurí quno ŋuno kumimbo huwó mande yaŋgurí. Ko kumimbo ŋande yaŋgurí, “Norendo pitu ko o ŋaro iŋowato.” ");
INSERT INTO nca_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Yiqo, Pol yorotoro toŋeró. ");
INSERT INTO nca_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Toŋiní uni kumi iŋondutu tero eneya womaŋgurí. Ŋuko Daionisias, Areopakus huru-huru ŋu noŋgo qu ka, ko pare ka, owí Damarisi, ko kumi meyowo ŋuya. ");
INSERT INTO nca_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Imemoŋgo Pol Atens yendé rotoro Korin yendémo oró. ");
INSERT INTO nca_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Komo Rom koro wiri yerete uni parámi horé Kolotias ŋundo hutuŋo mande ka yero Juda uni soso Rom yendé moŋgo yohowiní toŋeŋgurí. Ŋunde yohowiní yereka irisa, owéyari Akwila, ko Prisila, ŋundo Itali mira rotoro Korin mahiriyó. Akwila ŋuko Pontus mira koro uni qu ka. Asa Polko Korin yendémo mahero yereka ŋuya kopaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Yereka irisa ŋundo eneya kho kopo tero tuwi yamaru tiŋiyoyaŋgo. Ŋunde ŋuro ene irisa ŋuya yotoro kho teyaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ko Sapat naru soso ŋuno Polko Juda koro huru-huru yano oro mande teyara. Ene, Juda unindoya Grik unindoya iŋo-iŋoye reweka otoqoníka Yesu koro iŋondutu ti, yero ŋunde teyara. ");
INSERT INTO nca_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Asa Sailas koya Timoti koya Masedonia mira rotoro Korin ŋuno uriqo, Polko koweyumu tero Anutu koro mande qu yero Juda unino mande yesowo ŋande yaró, “Yesu ŋuko Kristo ŋu.” ");
INSERT INTO nca_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Quko uni ŋundo eneya kiro puso tero yesará yereyaŋgo quno ŋuno eneŋo saŋgiríŋo witú yerero kowe punu-punuyó towo kuriyoro ŋande yimiraró, “Yeŋombo naŋge yeŋo rowore yereyowaŋgo. Ŋu quhurí ŋuko neneŋo kini. Ŋa naruko ŋanoko yate uni wini meyowo ŋu mande yesowo yimirowe teteno.” ");
INSERT INTO nca_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ŋunde yero huru-huru ya ŋu rotoro, uni kako, owí muko Titius Jastus, ŋundo yano oró. Uni ŋu Anutu potoruku te inoyara. Ko yayó muko Juda koro huru-huru ya sumeyoro. ");
INSERT INTO nca_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ko Juda koro huru-huru ya koro sopo-sopo uni, owí Kirisipus, ŋuya eneŋo suwisawiyó soso, Uni Parámimboro iŋondutu taŋgurí. Ko Korin uni qambu Pol koro mande ŋu iŋoro iŋondutu tero sono raŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Asa suwo kano Uni Parámimbo quko Pol ŋande miraró, “Ke ma sorewero. Kini, mande yesowo; maŋgoke ma kusiyowero. ");
INSERT INTO nca_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Nondo keya yowano, uni ka otoqoro ke kama rambaruru kerewaŋgo. Neneŋo unipare qambu ŋu yendémo ŋano yoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pol Korin ŋuno yoní kumima naru kanata ko kombo kande saŋiyoro kanata ŋunde kini tiní Anutu koro mande rondaqe yunoyaró. ");
INSERT INTO nca_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Naru kano Galio ŋundo Akaia mira ŋuro uni kembéye yora. Asa Juda unindo mande kusiyoro Pol koya saŋgirí taŋgurí. Ŋunde tero rero mande khono rotoro ŋande yaŋgurí, ");
INSERT INTO nca_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“Uni ŋando unipare iŋo-iŋoye riní otoqoro noreŋo hutuŋo mandenani wendaqero murí enesówore Anutu potoruku te inoyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Asa Polko mande topé yewero taró quno ŋuno Galioko Juda uni ŋande yimiraró, “Ye Juda uni, uni ŋando hutuŋo mande ka karóŋoro otete piyimi parámimbe ma tomó tiníqo, asa nondo mande ye iŋowano. ");
INSERT INTO nca_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Quko oseseye ŋako kina mande ka, yendo owé karo koya yeŋo hutuŋo mandeye ŋuro yeteŋgo. Enina, yeŋombo naŋge ŋa roŋgaruwi. Noko osese ŋa iŋowero piyimiŋoteno.” ");
INSERT INTO nca_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ŋunde yero mande kho noŋgo yohowaró. ");
INSERT INTO nca_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Yohowiní Juda uni soso ŋundo eneŋo huru-huru ya koro sopo-sopo uni, owí Sositenes koya saŋgirí tero toworo ya kimbino ŋuno uraŋgurí. Quko Galioko o taŋgurí ŋu qenero ŋuro kama iŋaró. ");
INSERT INTO nca_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Asa Polko naru piru Korin yendémo yora. Yate Siria mirako pitu ko uyarewero ye iŋoro uni topo, ime yuri, yero yorotoro eneya Prisila koya Akwila koya Senkiria yendé moŋgo waŋgowore uyareŋgurí. Quko koretero Anutu yuŋgunaŋoro huí toŋaró, dokoro komo enendo Anutu koya mande kondé yaró. ");
INSERT INTO nca_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Asa waŋgowore uyareyate Efesus yendémo ŋuno mahero Polko yereka ŋu ŋuno yorotoro Juda koro huru-huru ya quroko oro eneya mande teyate ");
INSERT INTO nca_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ŋande miraŋgurí, “Ke noreya soŋga piru yate ta.” Quko, “Mepémo kini,” yero ");
INSERT INTO nca_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","yorotoro toŋewero tero yaró, “Asa Anutuko ŋuro iŋote tiníqo, pitu ko yeno ŋano mahewano.” Yero waŋgowore Efesus rotoro ");
INSERT INTO nca_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Sisaria yendémo ŋuno mahero waŋgo rotoro Yerusalem oro iŋondutu huru-huru ŋunoko naru meté yero yorotoro Antiok ŋuno uró. ");
INSERT INTO nca_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Antiok ŋuno yate-yate toŋero Galesia mirawore ko Pirikia mirawore yendéne-yendéne ŋuno uyaro Yesu koro iŋo-iŋo rewero unipareyó soso ŋu rukiso yereyaró. ");
INSERT INTO nca_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ko Juda uni Aleksandria yendé moŋgo qu ka, owí muko Apolos, ŋundo Efesus yendémo ŋuno maheró. Eneŋo mande yewero murí ŋuko kekere qu naŋge, ko Anutu koro sokome ŋu iŋomukaró. ");
INSERT INTO nca_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Komo kumimbo Uni Parámimboro khe quro iŋo-iŋo inaŋgurí, ko newondímbo wimbí tero Yesu koro mande okeyá ta unipare rondaqe yunoyara. Quko Jonko sono re yunoyara murí ŋu naŋge iŋaró. ");
INSERT INTO nca_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Asa hurí rero Juda koro huru-huru yano oro kondé yiníqo, Prisila koya Akwila koya iŋoro rero Anutu koro khe ŋu okeyá ta roneneŋoro witúŋariyó. ");
INSERT INTO nca_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Naru kano Apolosko Akaia mirawore uyarewero ye iŋoní uni topo ŋundo iŋo-iŋoyó wikundiyoro sokome ka nakayáŋoro iŋo-iŋo rewero unipare ŋuno yaŋgurí ŋu yunaŋgurí. Uni ŋa ri qembe, ye nakayáŋaŋgurí. Asa ŋuno uyaro enendo unipare samaka-samaka tuwówore iŋondutu taŋgurí qambu ŋu samaka yereró. ");
INSERT INTO nca_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Dokoro kondé kaŋero Juda unindo iŋo-iŋoye koroqe qu roneneŋoro Anutu koro sokome ŋu rondaqero, Yesu ŋuko Kristo ŋu, yero witú yereró. ");
INSERT INTO nca_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Asa Apolos Korin yendémo ŋuno yoníqo, Pol mira purí itaqero uyare yate-yate Efesus yendémo ŋuno uró. Uro Yesu koro iŋo-iŋo rewero uni kumi yiyoro ");
INSERT INTO nca_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ŋande osese yereró, “Ye iŋondutu taŋgurí quno ŋuno yembeka Yuqa Surumí ŋu raŋgurímbe ma kini?” Yiní yaŋgurí, “Kini. Noreko Yuqa Surumí ŋuro mandí kama iŋato.” ");
INSERT INTO nca_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Yi ŋande yimiraró, “Ŋunde ŋuro ye date tero sono raŋgurí?” Yiní ŋande yaŋgurí, “Noreko Jon koro sono qu ratowó.” ");
INSERT INTO nca_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Yi Polko yaró, “Komo Jonko unipare sono re yunoro ŋande yaró, ‘Ye quhuríyemboro newonde surumí teya quhurí ŋu se rotoya sono ri. Ko ye uni no huwónemo maheweya ŋuro iŋondutu ti,’ yaró. Asa uni ŋuko Yesu.” ");
INSERT INTO nca_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ŋunde yiníqo, uni ŋu iŋoro Uni Parámi Yesu ŋuro owímo sono ri ");
INSERT INTO nca_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Polko kandí rero saŋayemo riní Yuqa Surumímbo eneno umburó. Umbuní mande enesó-enesó yero Anutu koro mande qu yeyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Uni soso ŋuko 12 ŋundiro. ");
INSERT INTO nca_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Asa Polko kombo kapusa quroko ŋuno Juda koro huru-huru yano oro Anutuko unipareyó wiri yereyote naruyó ŋuro kondé yero iŋo-iŋoye okokowaró. ");
INSERT INTO nca_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Quko uni kumi eneŋombo eneŋo newondeye kondé kusiyaŋgurí. Ŋunde kusiyoro iŋondutu kama tero unipare toŋeyemo Uni Parámimboro khe ŋuro yesaráŋoyaŋgo. Ŋunde ŋuro Polko yorotoro iŋo-iŋo rewero unipare yorero toŋeŋgurí. Ko naru rokóŋoro Tiranas koro iŋo-iŋo rewero yayómo ŋuno mande ŋuro epe mito-mito taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ŋunde teyoní, yate-yate kumima naru irisa ŋunde kini taró. Asa ko Esia mira unipare soso, Juda ŋuya Grik ŋuya, Uni Parámimboro mande qu iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Anutuko Pol kandímo o wimbí moré enesó-enesó parámi teyara. ");
INSERT INTO nca_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Unindo eneŋo kho tewero koro kowe punu-punuyó ŋu ri se khumo uniko saŋayemo raŋgurí quno ŋuno se khumoye ŋu kini taró, ko yuqa piyimi mu yorotoro toŋeyaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Juda uni kumimbo wimbo toŋero yuqa piyimi mu yohoweyaŋgo. Kumi muko Uni Parámi Yesu owí nekoro yuqa piyimi ŋu yohowaŋgo. Ene ŋande yaŋgurí, “Nondo Polko ŋu Yesu ŋuro yesowoyote ŋuro owímo yeya mande kondé yeteno.” ");
INSERT INTO nca_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Juda o qa-qa unindoro tapá uni ka, owí muko Siva, ŋundo simó kande saŋiyoro irisa pisi yereró. Simó ŋundo kho ŋunde qu taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Asa naru kano ŋunde tiqo, yuqa piyimi ŋundo ŋande yaró, “Nondo Yesu iŋo inoteno, ko Pol iŋo inoteno. Quko ye dani?” ");
INSERT INTO nca_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ŋunde yiní uni ŋu, yuqa piyimi ŋuro quroko yaró, ŋu yutoro taka yereró. Kowe punu-punuye uto romboŋero yuto wisikara yiriní ya ŋu rotoyi sitú umbuní birimbiri soraŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Asa Juda unindoya Grik unindoya Efesus yaŋgurí ŋundo o ŋu iŋoro sasaro tero Uni Parámi Yesu owí hokoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Unipare qambu iŋondutu tero mahero oteteye piyimi ŋu soso komo teyaŋgo ŋu tunomo yesowaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Kumimbo o piyimi wimbí moré teyaŋgo, ŋundo o ŋunde tewero quro iŋo-iŋo sokomeye ŋu se koporo unipare toŋeyemo se qayi qaró. Sokome ŋuro kimoyó soweyaŋgurí muko ŋandiro, wondo musiyó silwa 50,000 ŋundiro. ");
INSERT INTO nca_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ŋundiro naŋge Uni Parámimboro mande qu usaye parámi taró. ");
INSERT INTO nca_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Asa o soso ŋu kini tiníqo, Polko ŋande ye iŋaró, “Nondo Masedonia mira koya Akaia mirawore uyaro rotoro Yerusalem pitu ko oroqota rohoréŋoro Rom ŋuno uyarero qenewano.” ");
INSERT INTO nca_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Quko koretero eneŋo samaka-samaka uni irisa, Timoti koya Erasitus koya, yorero asá yiriní Masedonia uyaririyó. Ko Pol eneŋo muko Esia ŋuno soŋga ta yora. ");
INSERT INTO nca_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ŋu naruko ŋuno uni kumimbo Uni Parámimboro Khe ŋuro saŋgirí tero kuma parámi ri otoqaró. ");
INSERT INTO nca_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Uni ka, owí muko Demitrius, enendo anutu pare ka, owí Aritemis, koro ya surumí ŋuro kapo-kapo ka silwapo towoní uni qambu qundo kimoyi o towoyara uni ŋundo mone parámi reyaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Asa enendo o towoyara uni ŋu neko yerero uni kho ŋunde qu teyaŋgo ŋuya neko yiriní kopoyi ŋande yaró, “Topo okite, ye iŋoteŋgo, kho teyoteto ŋano quwore mone parámi rero meté kunditeyoteto. ");
INSERT INTO nca_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ko ye ŋande qenero iŋoyoteŋgo, uni ŋu, Polko Efesus yendémo ŋano ŋuya Esia mira parámimo soso ŋuno ŋuya unipare qambu yowosoní iŋo-iŋoye rohoréŋoyoteŋgo. Ŋande yimitoyote, ‘Anutu kandeto towoyoteŋgo ŋuko anutu hamó kini.’ ");
INSERT INTO nca_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Hamó, mandímbo mone khonani ŋa rambaruruwoweya. Ŋuya, mandímbo Aritemis koro ya surumí ŋu riní unipare iŋo-iŋoyemo oka kina qembe teweya. Komo Esia unipare soso anutu pare ŋuro iŋondutu teyaŋgo. Quko Polko mande ŋando owí parámi ŋu rambaruruwowero tete.” ");
INSERT INTO nca_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Yiní iŋoro saŋgirí parámi tero kondé ye nekaŋgurí, “Aritemis, Efesus koro anutu ŋuro owí ŋuko parámi!” ");
INSERT INTO nca_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ŋunde yiqo, yendé unipare soso kiwe uyaro soso koporo kheŋgeŋoro Pol koro topé irisa Masedonia koro qu, owéyari Gaius koya Arisitakus koya yorero o qenewero yendé quno ŋuno oŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Polko yendé ŋuno unipare keweroyewore owero iŋaró, quko Yesu koro iŋo-iŋo rewero unipareto kusiyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Hamó, Esia mira koro uni pará-pará kumimbo Pol koya topo taŋgurí ŋundo mande ka ri mahiní kondé ŋande soréŋaŋgurí, “O qenewero yendé quno ŋuno ma owero,” yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Asa yendé ŋuno unipare qambu ŋu, iŋo-iŋoye kape taró. Ŋunde ŋuroko kumimbo mande ka yaŋgurí, ko kumimbo mande meyowo yaŋgurí. Ko unipare qambu kape tero ŋande iŋaŋgurí, nore do murí karo kopoteto, yero iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Juda uni ŋundo eneŋo topoye Aleksanda wosoyi otoqo unipare qambu toŋeyemo kaŋiní kumimbo kiwero roŋgaruwoyaŋgurí. Ko Aleksandako kandí hokoro mande topé huru-huru unipare yimirowero taró. ");
INSERT INTO nca_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Tiníqo, qenero ŋande iŋaŋgurí, ŋuko Juda uni ka. Ŋunde ŋuro ene maŋgoye koporo watí-watí ye nekoyaŋgurí, “Aritemis, Efesus koro anutu ŋuro owí ŋuko parámi!” Ene watí-watí ŋunde nekeyuri naru piru ta ŋunde kini taró. ");
INSERT INTO nca_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Asa Efesus yendémboro sopo-sopo uni ŋundo unipare qambu yiyoro mepa mande yero ŋande yaró, “Ye Efesus uni, uni soso ŋande iŋoyoteŋgo, ko nore Efesus uni, norendo Aritemis koro ya surumí ŋu sopoyoteto, ko eneŋo kapo-kapoyó sambo koŋgo umburó ŋu sopoyoteto. ");
INSERT INTO nca_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Uni kato mande ŋu rohoréŋowero mepémo kini. Ŋunde ŋuro ye mondó yuri. Ye, oka tato, yero waka ta ma tewero. ");
INSERT INTO nca_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Dokoro uni irisa ŋa yore maheteŋgo, quko ya surumí moŋgo oka kama momo tariyó, ko noreŋo anutunani pare ŋaro kama yesaráŋoyariyó. ");
INSERT INTO nca_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Asa ko Demitrius koya kho kopo topémboya mande ka yewero iŋoyoteŋgo tiníqo, asa mande kho tewero naruyó yote, ko uni kembé korete qu yote. Ene mandeye mande khono yewero ŋa roŋgaruwi. ");
INSERT INTO nca_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ŋunde tiqo, mande ka yorote tiníqo, asa ŋuko huru-huru naru horé ŋuno huruworo ŋu roneneŋowaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Qeni, noreŋombo itaka o tunoqete ŋuro mande khono kaŋewato, peka. Dokoro huru-huru ŋako murí moré kini. Ŋunde ŋuro uni kembémbo ŋande yewaŋgo, norendo kina kuma teyoteto.” ");
INSERT INTO nca_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Sopo-sopo uni ŋundo yiní kini tiní, unipare asá yiriní toŋeŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Asa kuma ŋu kini tiníqo, Polko Yesu koro iŋo-iŋo rewero unipareyó neko yiriní maheŋgurí. Mahi newondeye rukisoyoro, ime yuri yero, Masedonia mirako owero yoroto toŋeró. ");
INSERT INTO nca_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Toŋero Masedonia ŋuwore ŋuno khímbo yate mande parámi yero newondeye rukisoyaró. Ko imemoŋgo yate Grik mirako uró. ");
INSERT INTO nca_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Uro yoní kombo kapusa ŋunde kini taró. Yate-yate waŋgowore Siria mirako uyarewero taró, ko Juda uni kumimbo mande kusiyoro, uratoka khumoní, yero taŋgurí. Ŋunde ŋuro Pol rohoréŋoro Masedonia pitu ko oró. ");
INSERT INTO nca_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Uni Pol koya toŋeŋgurí ŋuko ŋandiro: Sopater, Pirus naŋuní, ŋuko Beria yendé moŋgo qu; Arisitakus koya Sekundus koya, irisa ŋuko Tesalonaika yendé moŋgo qu; Gaius, Deripe yendé moŋgo qu, ŋuya Timoti; Tikikus koya Tiropimus koya, irisa ŋuko Esia mira parámi moŋgo qu. ");
INSERT INTO nca_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Asa uni ŋundo koretero oro Tiroas yendémo ŋuno nore sopo nereŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Quko norendo Bret Yisiyó Moré Kini ŋuro o ne-ne ŋu kini tiníqota Filipai yendé rotoro windi tapé moŋgo toŋetowó. Ko waŋgowore karóŋoro naru kandeka ŋunde kini tiní windi tapémo mahero Tiroas ŋuno otowó. Noreko naru kande saŋiyoro irisa Tiroas ŋuno yatowó. ");
INSERT INTO nca_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Asa sonda naru korete quno nore uniparetoya bret romboŋero o kopo natowó. Polko, kuyepo toŋewano, yero mande yeyuri, yate suwo kewero taró. ");
INSERT INTO nca_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ya kopoyatowó quno ŋuno wasa koreko ŋuno suru qambu yora. ");
INSERT INTO nca_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ko simó keta ka, owí muko Yutikas, enendo wituko kunditeyaró. Asa Pol mande watí yeyoní Yutikas kupo tero etewero taró. Yate ete khumaró, ko wituwore kore koŋgo hamó rokaráŋo nokono uró. Uníqo, unindo, kindo khumote, ye iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ko Pol uro simó keta ŋuro saŋano etero pisiyoro yimiraró, “Ye ma yukuwowero. Ŋako toŋí yote.” ");
INSERT INTO nca_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ŋunde yero rotoro pitu ko oro bret romboŋero re naró. Ko mande piru saŋga sowe tero yeyoní, oro saraŋaró. Saraŋoní Pol roto toŋeró. ");
INSERT INTO nca_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ko simó keta ŋu toŋí yoní re towo toŋero newondeyemo niŋgu-niŋgu parámi taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Asa nore koretero uro waŋgowore uyarero Asos yendémo oro Pol sopatowó. Dokoro koretero Pol eneŋombo ŋande yaró, “Nondo khendo Asos owero iŋoteno.” ");
INSERT INTO nca_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Asa yate Polko Asos ŋuno mahiníqo, rero waŋgowore Mitilini yendémo ŋuno uyaretowó. ");
INSERT INTO nca_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Uyaro etato saraŋoní uyareyate Kios noko mosowí andusina ŋuno windi tapémo roto etatowó. Saraŋoníqo, Samos noko mosowímo uyaro etato saraŋoní, yate windi tapémo Miletus yendémo uyaretowó. ");
INSERT INTO nca_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pol komo iŋo-iŋoyómo Efesus yendé takawano, yero iŋo kusiyaró. Ene naru parámi Esia mira parámimo ŋuno yowero piyimiŋoro waka ta toŋewero iŋaró. Ŋu mepémo tiníqo, Pentikos o ne-ne naruko ŋuno Yerusalem yowano, peka, ye iŋaró. ");
INSERT INTO nca_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Asa Miletus ŋuno Polko mande riní Efesus yendémo oní huru-huru koro tapá uni neko yiriní maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Uni ŋu eneno mahiqo, ŋande yimiraró, “Ye no naru rokóŋoro Esia mirako no yeya date yoranowó ŋuro iŋomukoteŋgo. ");
INSERT INTO nca_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nondo owéne rewe umbuní tendoro Uni Parámimboro kho qu teyanowó. Quko naru qambuko Juda unindo nori umbuwero mande kusiyoyi quhurí parámi korowanowó. ");
INSERT INTO nca_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ko nondo ye samaka yerewero quro mande ka yero kama soreyanowó. Kini, yendé kewero ŋuya ya enemo-enemo ŋuya mande rondaqe yunoyanowó. ");
INSERT INTO nca_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Naru rokóŋoro nondo Juda unino, Grik unino mande yesoworo ŋande yimiranowó, norendo Anutusina mahero newonde rohoré teya Uni Paráminani Yesu koro iŋondutu tato. ");
INSERT INTO nca_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Asa iŋoyi, itakako Yuqapo kusi niriní no Yerusalem owé teteno. Ŋuno do ka nono tunoqeweya qu, no kama iŋoteno. ");
INSERT INTO nca_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ŋandiro naŋge iŋoteno, ko yendé soso toŋeyano quno ŋunoko Yuqa Surumímbo ŋande nimitoyara, ko kusi-kusiko nondowoyi quhurí parámi korowowano. ");
INSERT INTO nca_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Quko nondo yoto-yotone kondé toworo ŋu parámi yero kama iŋoteno. Kini, khe howewe kini teweya, yero iŋoteno, ko Yesu Uni Parámimbo kho nunaró ŋu tewe kini teweya, yero iŋoteno. Kho ŋuko mande yero Anutu koro samaka-samaka tuwó ŋuro miti mandeyó yewero kho qu. ");
INSERT INTO nca_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Asa iŋoyi, komo no ye keweroyewore Anutuko unipareyó wiri yereyote naruyó ŋuro yesowo yimitoyanowó. Quko no itakako iŋoteno, imemoŋgo yendo umu-kembane pitu ko kama qenewaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ŋunde ŋuro itaka ŋande yimiroteno, ye ka khumowaŋgo quro potó ŋuko neneŋo kini. ");
INSERT INTO nca_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Dokoro nondo Anutu koro iŋondutuyó soso ŋu yesoworo yimiranowó. ");
INSERT INTO nca_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ye koweye meté sopoyuri. Ko Yuqa Surumímbo Anutu koro huru-huru soso yore yeŋo kandeyemo rotaró ŋu ŋuya meté sopo yereyuri. Dokoro eneŋo naŋunímboro sitúŋombo kimo yereró. ");
INSERT INTO nca_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","No iŋoteno, yoroto toŋewano qunoko, isa saŋgirí qundo ye keweroyemo mahero unipare rambaruru yerewaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ko uni topoye kumi yeŋo keweroye moŋgo otoqoro mande kota yero unipare kaná yerero yowosowaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ŋunde ŋuro ye kondé sopo yereyuri qembe. Ŋande iŋoyuri qembe, kumima naru kapusa qunoko kosa suwo nondo tendo-tendoro oresaka mande ye yimitoyanowó. ");
INSERT INTO nca_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Kowe itakako ye yorero Uni Parámi kandímo yorotoro eneŋo samaka-samaka tuwó ŋuro mande kusuŋoyómo yorototeno. Samaka-samaka tuwó ŋundo meté wimbu re yunoweya, ko o meté qu Anutuko unipare soso rokó yereró ŋu siyowaŋgo qu siyoro yunoweya. ");
INSERT INTO nca_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nondo uni karo silwayó, golyó, tuwiyó quro qene nuŋgu ka kama tanowó. ");
INSERT INTO nca_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Yeŋombo iŋoteŋgo, neneŋombo kho towanowó ŋuro tero otoro tukuni teroqo neneŋombo o siyoyanowó, ko nondo uni noya yoteto ŋu ŋuya samaka yereyanowó. ");
INSERT INTO nca_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","O soso tanowó ŋundoko ŋande witú yereró, asa yendo kho kondé tero uni wimbuye moré kini ŋu samaka yerewaŋgo. Yesu Uni Parámi eneŋombo yaró ŋuro iŋato. Ŋande yaró, ‘Ko uni ka oka topé moŋgo siyoweya quko puriŋo ka reweya, peka. Quko uni ka oka topé inoweya ŋuko puriŋo parámi ka hamó reweya.’” ");
INSERT INTO nca_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Polko mande ŋu yiní kini tiní potoruku tero tapá uni ŋuya hariri taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ŋu kini tiní soso tendoro Pol towo pisiyoro mutó inaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Komo Polko yaró, “Yeko no umu-kembane kama qenewaŋgo,” ŋunde ŋuro newonde surumí parámi taŋgurí. Ko rero waŋgo saŋano rotaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Asa norendo uni ŋu yorotoro waŋgowore toŋero roneneŋo uyarero Kos noko mosowímo ŋuno uyaretowó. Ko saraŋoníqo Rotes noko mosowímo ŋuno uyaro rotoro windi tapémo Patara yendémo ŋuno uyaretowó. ");
INSERT INTO nca_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Yendémo ŋuno waŋgo ka Ponisia mirako uyareweya qu seqaro qenero ŋuwore toŋetowó. ");
INSERT INTO nca_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Uyareyate Saipras noko mosowí ŋu kandenani tesina yoní qenero takaro, yate-yate Siria mira takaro Tair yendémo ŋuno uyaretowó. Waŋgo simburí ŋundo situwi se rotowero tiní ŋuno oŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Yendémo ŋuno Yesu koro iŋo-iŋo rewero unipareyó kumi yiyato ŋundo Yuqapo Pol ŋande miraŋgurí, “Ke Yerusalem ma owero.” Ŋunde ŋuroko naru kande saŋiyoro irisa ŋunde ŋuno yoratowó. ");
INSERT INTO nca_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Asa ko naru ŋu kini tiníqo, nore yendé ŋu rotowero tatoqo, Anutu koro uni ŋuya pare-simóyemboya, nore norero yendé rotoro windi sumeyoro potoruku rero hariri tatowó. ");
INSERT INTO nca_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Hariri tato kini tiní, imemoŋgo toŋi, yero nimiraŋgurí, ko, ime yuri, yero waŋgo saŋano otowó, ko pitu ko ene norotoro yayemo toŋeŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Asa ko nore waŋgowore Tair yendé rotoro, yate Tolemes yendémo ŋuno uyaretowó. Ŋuno uni topotoya kosa meté yatowó, ko nore kosa kanata na ŋuya yatowó. ");
INSERT INTO nca_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ko saraŋoníqo, Tolemes ŋu rotoro nore Sisaria yendémo ŋuno uyaro miti mande yesowowero uni ŋu, Filipko yano oro eneya yatowó. Ŋuko uni kande saŋiyoro irisako asá yerewí uni samaka yereyaŋgo ŋuro qu ka. ");
INSERT INTO nca_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Eneŋo nambo-simó keta nimí kini qundo ye-ye mande yeyaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Asa Sisaria ŋuno naru kumi ŋuno yato, ye-ye uni ka, owí Akapas, ene Judia mira rotoro Sisaria umburó. ");
INSERT INTO nca_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Umburo noreno mahero Polko utó newondímo kusiyoyara ŋu rero eneŋombo eneŋo khe kandí kusiyaró. Kusiyoro ŋande yaró, “Yuqa Surumímbo ŋande yete, ‘Juda uni Yerusalem yoteŋgo ŋundo utó ŋaro simburí rero ŋande kusiyowaŋgo, ko rero uni wini meyowo kumi kandeyemo rotowaŋgo.’” ");
INSERT INTO nca_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Yiní iŋoro noreya yendé unipare ŋuya Pol kondé, “Yerusalem ma owero,” yatowó. ");
INSERT INTO nca_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Quko Polko mande topé yaró, “Ye do karo tendoro no newondene rambaruruwoyoteŋgo? No Yerusalem ŋuno kusi nerewaŋgope ma nuroyi khumowano, peka. Enina, Uni Parámi Yesu koro owí hokowero khe ŋu howewano.” ");
INSERT INTO nca_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ŋunde yiníqo, nore iŋo-iŋoyó rohoréŋowero mepémo kini tero mande ŋu rotato. Ŋande yatowó, “Uni Parámimboro nuŋgurí tunoqiní.” ");
INSERT INTO nca_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Naru ŋu kini tiníqo, situwinani roŋgaruworo Yerusalem ŋuno otowó. ");
INSERT INTO nca_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Oro Sisaria yendémboro iŋo-iŋo rewero unipare kumi noreya oro Nasonko yano norotaŋgurí. Nason ŋuko Saipras noko mosowí moŋgo qu, Yesu koro iŋo-iŋo uni korete qu ka. ");
INSERT INTO nca_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Asa Yerusalem otowó quno uni topo ŋuno qundo noreŋo niŋgu-niŋgu taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Saraŋoníqo, Pol noreya Jems qenewero otowó. Oto huru-huru koro tapá uni soso Jems koya yaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ŋuno oro Polko kosa meté yero yimiraró, ko eneŋombo meté roneneŋoro o soso Anutuko khoyómo uni wini meyowo qu keweroyemo taró ŋuro yaró. ");
INSERT INTO nca_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ŋunde yiníqo, iŋoro Anutu owí hokaŋgurí. Ko ŋande miraŋgurí, “Topo, qeno. Juda uni qambu horé qundo iŋondutu taŋgurí, ko uni soso ŋundo hutuŋo mande howewero ŋuro kondé iŋoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Quko uni kumimbo keŋo ŋande yimiroyi iŋaŋgurí, “Ko Polko Juda uni kumi uni wini meyowo keweroyemo yoteŋgo qu rowore yerero Mosesko hutuŋo mande qu howewero soré yereyote. Ene ŋande yeyote, ‘Ye simóyemboro koweye ma toŋowero. Ko otete komo qu ma howewero.’ ");
INSERT INTO nca_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Nore date tewato? Juda iŋondutu uni ŋundo keto mahe ŋuro hamó iŋowaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","“Asa otete ka kimiratoka ŋunde te qembe. Uni nimí kini ŋano yoteŋgo qundo komo oka tewero quro Anutu koya mande kusiyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ke uni ŋu yorero ye soso Anutu toŋímo sara tunoqewero otete ŋu ti qembe. Ŋunde teya keto eneŋo o qa-qa te inowero qu kimoyikata huye toŋowaŋgo. Ke ŋunde tiqota unipare soso iŋowaŋgo, uni kumimbo kota mande keya yaŋgurí na. Ŋande iŋowaŋgo, keko hutuŋo mande howeyote, yero iŋowaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Asa uni wini meyowomboro iŋondutu unipare quro norendo komo mande kusiyoro sokome ka ratowó. Ŋande yimiratowó, ko unindo nú-qare ka uroyi khumoní rero anutu kota-kota o te yunaŋgurí ŋu ma newero, ko sitú ma newero, ko unindo númbowe puŋeye kusiyi khumoní ŋu ŋuya ma newero, ko se simbururu ma tewero.” ");
INSERT INTO nca_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Asa ko saraŋoníqo, Polko uni ŋu yorero eneya Anutu toŋímo sara tunoqewero otete ŋu taŋgurí. Ŋunde teroqo Ya Surumímo oro piŋa mande ka o qa-qa uni yimitoro ŋande yaró, do naru kano murí tewero naruyó ŋu kini teweya, ko do naru kano uni soso ŋundo o qa-qa Anutu te inowaŋgo ŋuro yimiraró. ");
INSERT INTO nca_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Asa murí tewero naru kande saŋiyoro irisa kini tewero taró quno ŋuno Juda uni Esia noŋgo qu kumimbo Pol Ya Surumímo qeneŋgurí. Qenero unipare qambu ŋu iŋo-iŋoye kape tiní Pol toworo ");
INSERT INTO nca_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ŋande neke kiwaŋgurí, “Ye Israel uni, nore samaka niri! Uni ŋando mira soso ŋuno mande rondaqe unipare yunoyote, ko mandí muko noreŋo wininani, hutuŋo mandenani, ko Ya Surumínani ŋaro yesaráŋoyote. Ŋu naŋge kini. Kini, enendo Grik uni ŋuya yorero Ya Surumímo ŋano arero Ya meté horé ŋa riní Anutu toŋímo pusú teyote.” ");
INSERT INTO nca_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ŋunde yaŋgurí, dokoro komo Grik uni ka Efesus noŋgo qu, owí Tiropimus, Pol koya yendémo yiyaŋgurí, ko ŋande ye iŋaŋgurí, ko Polko uni ŋu re Ya Surumímo ariri, yero iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Asa ŋunde yero kiwi Yerusalem uni soso iŋoro yukuworo kheŋgeŋoro mahe kopaŋgurí. Koporo Pol toworo rero Ya Surumímo rotoro yendémo uŋgurí. Ko waka ta Ya Surumí ŋuro mako qu tuŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Pol toworo uroyiqo, Rom koro kuma unindoro uni kembé ŋundo Yerusalem soso iŋo-iŋoye kape taró ŋuro piŋa mande iŋaró. ");
INSERT INTO nca_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ŋunde ŋuro waka ta uni kembémbo kuma unindoro sopo-sopo kumimboya uniyemboya yorero kheŋgeŋo uyaŋgurí. Uyari unipareto yiyoro Pol utoyaŋgo ŋu rotaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Uni kembé ŋundo kutaqemo mahero Pol toworo kuma uniyó yimira, kato utó kondémbo irisa kusiyi, ye yimiraró. Yero unipare ŋande osese yereró, “Ŋa dani ka? Do ka taró?” ");
INSERT INTO nca_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Yiní unipare qambu keweroyemo uni kumimbo mande ka yero nekaŋgurí, ko uni kumimbo mande meyowo yaŋgurí. Niri-niri qambu tiqo, kuma uni ŋundo o hamó qene iŋowero mepémo kini taró. Ŋunde ŋuro kuma uni yimironí Pol re toworo kuma unindo ya quroko owero taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Pol oro ya piri saŋano owero tiní unipare qambu ŋundo, uratoka khumoní, yero kuma kondé ti owero rukusuwoní kuma unindo re korowo oŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Kowe unipare parámi ŋu yohowero oro ene mande kondé ŋande yaŋgurí, “Urika khumoní!” ");
INSERT INTO nca_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Asa Pol kuma unindo yayemo owero teroqota kuma unindoro uni kembé ŋu ŋande kirayaró, “Meté mande ka keya yewe teteno?” Yiní yaró, “Date koro? Keto Grik mandewore yete. ");
INSERT INTO nca_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Noko, ke peka Isip uni ŋu, yero iŋoyoteno, soŋga komo kuma riní otoqoní uni saŋgirí 4,000 uni sukepo yutoyoteŋgo qu yorero mira wimbímo uyareŋgurí.” ");
INSERT INTO nca_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ko Polko yaró, “Noko Juda uni ka, Tarsus yendé Silisia mirako qu ka. Yendéne muko owí parámi moré. Ai, no unipare mande yunowero iŋoteno.” ");
INSERT INTO nca_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Uni kembé ŋundo meté yiníqo, Pol mako piŋo saŋano ŋuno kaŋero kandímbo naŋge rokó-rokó taró. Ŋunde ŋuro soso maŋgoye kusiyoyi Polko Hibru mandewore mande yaró. Ŋande yaró, ");
INSERT INTO nca_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Uni topo ko awa okite, ye iŋoyi. No mande topé yeya yewe teteno.” ");
INSERT INTO nca_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ŋunde Hibru mandewore yiníqo, iŋoro mondó ta yotoro niri-niri ka kama taŋgurí. Polko ŋande yaró, ");
INSERT INTO nca_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Noko Juda uni ka. Námembo Silisia mirako Tarsus yendémo ŋuno pisi nereró, quko no Judia mirako ŋano parámi tanowó. Gamalielko iŋo-iŋo no nunaró, ko usi-sinanimboro hutuŋo mandeye ŋuro iŋo-iŋo nunaró. Ŋunde ŋuro ye itaka teyoteŋgo ŋunde naŋge nondo Anutu koro kondé iŋoyanowó. ");
INSERT INTO nca_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ŋunde ŋuro no unipare Khe ŋu howeyaŋgurí qu yutoyano, ko uni ŋuya pare ŋuya yorero kusi-kusi yano yorotoyano. ");
INSERT INTO nca_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","O qa-qa unindoro tapá unindoya uniparetoro uni kembé-kembémboya, sowo mande ŋu meté ye yimirowaŋgo. Dokoro enendo Damaskus topo-topoyemboro sokome ka nunoyi unipare ŋunde qu yondoworo oteteye piyimi ŋuro topé rewero quro yore Yerusalem mahewero khendo Damaskus yendémo ŋuno unowó. ");
INSERT INTO nca_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Asa no khendo yate kosa keweroko Damaskus yendémo ŋuno owero naŋge tanowó. Ko waka ta hiyó parámi ka sambo saŋa noŋgo umburo no hiyó nunaró. ");
INSERT INTO nca_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Hiyó nunoní rokaráŋoro nokono umbuweqo, maŋgo kato nimiraró, ‘Sol, Sol, ke do karo no rambaruru nereyote?’ ");
INSERT INTO nca_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Yiní mande topé ŋande yanowó, ‘Uni parámi, ke dani?’ “Yewe nimiraró, ‘Noko Yesu, Nasaret noŋgo qu, keto no rambaruru nereyote,’ yaró. ");
INSERT INTO nca_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Uni noya yatowó ŋuko hiyó ŋu qeneŋgurí, quko maŋgó iŋanowó ŋu ene kama iŋaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Asa ŋande yanowó, ‘Uni Parámi, no itaka do ka tewe teteno?’ “Yeweqo, Uni Parámimbo nimiraró, ‘Ke otoqoya Damaskus oyo. Ko ŋu yendémo ŋunoko uni kato do kho ka kunoteno qu kimiroweya,’ yaró. ");
INSERT INTO nca_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Hiyó ŋuko parámi horé, asa ko kini tiníqota nondo o qenewero mepémo kini. Uni noya yatowó ŋundo kandenemo nondoworo norero Damaskus otowó. ");
INSERT INTO nca_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Ko uni ka ŋuno yaró, owí muko Ananaias. Uni ŋuko hutuŋo mande hamó howeyara. Juda uni soso Damaskus yoteŋgo ŋundo ŋande yeyoteŋgo, ŋuko uni meté. ");
INSERT INTO nca_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Asa ene mahero no taŋgenemo kaŋero ŋande nimiraró, ‘Topo Sol, ke pitu ko toŋete.’ Yiníqo, ŋu naruko ŋuno naŋge toŋene muko pitu ko meté tiní toŋete ene qenenowó. ");
INSERT INTO nca_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Asa ŋande yaró, ‘Usi-sinanimboro Anutuyembo ke rokó kerero ŋande ye iŋaró, ko keto eneŋo iŋo-iŋo qu iŋoyi tondaŋeweya, ko keto Uni Roneneŋowí ŋu qenero maŋgómbo mande yete ŋu iŋoweya. ");
INSERT INTO nca_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ŋunde ye iŋaró, dokoro keto maŋgó rero toŋeŋgepo qeneró ŋuya kusumbokepo iŋaró ŋuro unipare soso yesowoweya. ");
INSERT INTO nca_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Asa ke do ka sopoyote? Otoqoya owí nekoya sono rika enendo quhuríŋge soworo se rotoweya.’ ");
INSERT INTO nca_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Imemoŋgo no Yerusalem mahero Ya Surumímo ŋuno hariri teroqo, iŋo-iŋone enesó-enesó tiní ");
INSERT INTO nca_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Uni Parámi qenenowó. Qenewe ŋande nimitoyaró, ‘Waka ta Yerusalem roto toŋe. Dokoro ke mandene re ŋano yeweya, quko uni kumimbo iŋowero piyimiŋowaŋgo.’ ");
INSERT INTO nca_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Ko nondo yanowó, ‘Uni Parámi, uni ŋano qundo ŋande iŋoteŋgo, komo nondo huru-huru ya soso quwore uro iŋondutu unipare kusi yereyano, ko haususu yereyano. ");
INSERT INTO nca_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ko komo enendo keŋo yesowowero uni Stiven ŋu uri khumoníqo, neneŋombo kutaqemo kaŋero niŋgu-niŋgu tero urowero uni ŋuro kowe punu-punuye sopoyanowó.’ ");
INSERT INTO nca_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Yeweqo, nimiraró, ‘Ke oyo. No asá kerewe sewemo toŋero uni wini meyowo keweroyemo yoweya.’” ");
INSERT INTO nca_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Asa Juda unindo Pol koro mande qu soso iŋoro kondé nekaŋgurí, “Urika khumoní! Uni ŋunde qundo nokono ŋano kama yoweya!” ");
INSERT INTO nca_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ŋunde yero hurí tero wimbo-wimbo nekero kowe punu-punuye piru qu se wendaŋe raŋoro kuku somoyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Asa ko kuma unindoro uni kembé ŋundo kuma uni yimitoro ŋande yaró, “Pol yano re oya haususuwoya ŋande oseseyuri, do murí karo unipareto niri-niri parámi ŋunde teyoteŋgo,” yaró. ");
INSERT INTO nca_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Asa kusiyoro haususuwowero taŋgurí quno Polko kuma unindoro sopo-sopo ka ŋande oseseyaró, “Yembe meté Rom uni mande khono kama kaŋaró qu ka haususuwowaŋgo?” ");
INSERT INTO nca_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Yiníqo, sopo-sopo uni ŋu kuma unindoro uni kembé ŋuno uyaro oseseyaró, “Ke do tewero? Uni ŋuko Rom uni ka.” ");
INSERT INTO nca_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ko uni kembé ŋundo Pol ŋande miraró, “Ke no nimito. Kepe Rom uni kape ma kini?” Yiní, “Iyo,” yaró. ");
INSERT INTO nca_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Yiní ŋande yaró, “Nondo kimo parámi raŋoro Rom uni tanowó.” Ko Polko yaró, “Quko námbo pisi niriníqo, nondo Rom uni tanowó.” ");
INSERT INTO nca_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ŋunde ŋuro kuma unindo oseseyowero qundo waka ta toŋeŋgurí. Kowe kuma unindoro uni kembé ŋundo sasaro taró. Dokoro enendo Pol, Rom uni ka, kusiyaró. ");
INSERT INTO nca_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Kuma unindoro uni kembé ŋundo do murí horé karo Juda unindo Pol mande kho inoyaŋgo ŋuro iŋowero taró. Ŋunde ŋuro saraŋoní re rotoro o qa-qa unindoro tapá unindoya uni pará-parámboya neko yiriní mahe huruwaŋgurí. Ko Pol rero rotoní. ");
INSERT INTO nca_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Polko kaŋero Sanedrin kondé toŋetero yaró, “Uni topo, no iŋo-iŋonemo ŋande iŋoteno, ko naru rokóŋoro Anutu koro o qu howeyoteno arero itaka ŋa.” ");
INSERT INTO nca_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Yiníqo, o qa-qa unindoro tapá uni Ananias ŋundo uni Pol koro taŋgímo kaŋaŋgurí ŋu yimironí maŋgó tamaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ŋunde ti Polko miraró, “Ke hoŋgo ka sono sara-sarapo sonowaŋgurí qu! Anutuko ke kuroweya! Qeno, ke mande khono norotoro hutuŋo mandewore ronda nerete, quko keŋombo naŋge mande ŋu karóŋoro no nuri yero yimirote!” ");
INSERT INTO nca_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Yiní uni kutaqemo kaŋaŋgurí ŋundo yaŋgurí, “Ke peka Anutu koro o qa-qa unindoro tapá uni ŋu ŋunde huwóŋote, peka?” ");
INSERT INTO nca_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ko Polko yaró, “Uni topo, ŋuko o qa-qa unindoro tapá uni qu ŋu kama iŋoro yeteno. Dokoro sokomeko ŋuno ŋande nakayáŋaró, ‘Ke uniparetoro wiri yerete uni ŋuya mande piyimi ma yimitoyowero.’” ");
INSERT INTO nca_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Asa Polko ŋande iŋaró, ko sopo-sopo uni ŋuno huruwaŋgurí kumi muko Sadyusi ko kumi Farisi. Ŋunde ŋuro Sanedrin ŋunoko nekero ŋande yaró, “Uni topo, noko Farisi koro wini qu ka, ko awane ŋuya Farisi koro wini qu ka. Nondo unipare khumaŋgurí qundo pitu ko otoqowaŋgo, yero iŋondutu teteno. Ŋu murí ŋuro no norero mande khono norotoyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ŋunde yiníqo, Farisi unindoya Sadyusi unindoya kiro puso tiqo, huru-huru ŋuko usowaró. ");
INSERT INTO nca_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Dokoro Sadyusi unindo ŋande yeyaŋgo, unipare khumaŋgurí qundo pitu ko kama otoqowaŋgo, ko sambo simó kama yoteŋgo, ko yuqa piyimi ŋuya kama yoteŋgo. Quko Farisi unindo o kapusa ŋuro iŋondutu teyaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Asa ko niri-niri parámi tero Farisi koro hutuŋo mande ŋuro iŋo-iŋo uni kumimboko kondé ŋande yaŋgurí, “Nore uni ŋaro quhurí ka kama qeneteto. Yuqa kato eneya mande tarómbe, ma sambo simó kato eneya mande taró, peka.” ");
INSERT INTO nca_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Yiqo, kiro saŋgirí ŋu parámi horé taró, ko kuma unindoro uni kembé ŋundo, Pol kawore-kawore towo wosoyi wuriwe tete, peka, ye iŋaró. Ŋunde ŋuro kuma uni yimironí uni keweroyemo uro rero kuma unindo ya quroko oŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Asa saraŋoní suwono Uni Parámimbo Pol taŋgímo kaŋero miraró, “Newondeke kondé yoní. Keto neneŋo mandene ŋa Yerusalem ŋuno ya, ŋunde naŋge oro Rom ŋuno ŋuya yesowoweya.” ");
INSERT INTO nca_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Saraŋoníqo, Juda uni kumimbo koporo mande kusiyoro ŋande yaŋgurí, “Hamó yeteto, ko noreko oka kama neyate oro Pol urato khumoníqota.” ");
INSERT INTO nca_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Uni mande hamó yero mande kusiyaŋgurí ŋuko 40 ŋundiro. ");
INSERT INTO nca_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Asa ŋunde yero o qa-qa unindoro tapá unindoya uni kembé-kembémboya ŋuno oro ŋande yimiraŋgurí, “Nore mande kusiyoro mande hamó moŋgo yero ŋande yatowó, ko nore oka kama neyate oro Pol urato khumoníqota. ");
INSERT INTO nca_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ŋunde ŋuro yeya Sanedrin ŋuya kota mande rika kuma unindoro uni kembémo oní Pol rero yeno umbuweya. Ye kota mande yewaŋgo ŋuko ŋandiro, ko yendo Pol koro murí ŋu okeyá ta iŋowero ye iŋoteŋgo. Asa ko yeno mahe yoroní urato khumoweya.” ");
INSERT INTO nca_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Quko Pol okímbo mondó sóqero uri khumoweya mande kusiyaŋgurí ŋu iŋoro toŋero kuma unindo ya quroko oro Pol ŋuro miraró. ");
INSERT INTO nca_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ŋunde ŋuro Polko kuma unindoro sopo-sopo uniye nekoro miraró, “Simó keta ŋa reya kuma unindoro uni kembémo oyika mande ka miroweya.” ");
INSERT INTO nca_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ŋunde yiníqo, re toworo uni kembémo oro ŋande yaró, “Kusi-kusi uni Pol ŋundo no neko nerero nimironí uni keta ŋa rero mande ka re kunowero keno maheteno.” ");
INSERT INTO nca_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Yiní uni kembé ŋundo simó keta ŋu kandímo toworo rero tapémo uro ŋande oseseyaró, “Keto do mande ka noya yewero?” ");
INSERT INTO nca_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Yiní yaró, “Juda uni kumimbo mande ka ŋande kusiyaŋgurí, ko kuyepo osese kiri keto Pol rero Sanedrin ŋuno re uweya. Kota mande ŋande yewaŋgo, enendo Pol koro murí ŋu okeyá ta iŋowero ye iŋoteŋgo. ");
INSERT INTO nca_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Quko ke mandeye ŋu ma howewero. Uni kumi muko 40 ŋundiro, ŋundo mande hamó ŋande yero, o koro kundiŋi teyate Pol urato khumoníqota, yaŋgurí. Ko itakako o roŋgaruworo keto meté yekata yero ke sopo kereyoteŋgo.” ");
INSERT INTO nca_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ŋunde yiníqo, uni kembé ŋundo simó keta ŋu mande kondé ŋande miraró, “Keto mande no nimirote ŋa yero uni ka ma yimirowero” yiní toŋeró. ");
INSERT INTO nca_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Asa, kuma unindoro uni kembé ŋundo kuma unindoro sopo-sopo uni irisa neko yerero yimiraró, “Yari kuma uni 200 ŋundiro, ko uni hosi saŋano kunditeyoteŋgo 70 ŋundiro, ko uni saŋgaye se towoyoteŋgo 200 ŋundiro ŋu yoriri suwono 9 kilok ŋunoko Sisaria yendémo ŋuno uwaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ko Pol ri hosi saŋano kunditero wiri yerete uni Feliksiko ŋuno khewore uní.” ");
INSERT INTO nca_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ŋunde yero sokome ka ŋande nakayáŋaró. ");
INSERT INTO nca_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","No Kolotias Lisias, nondo Wiri Yerete Uni Feliks, keya kosa meté yeteno. ");
INSERT INTO nca_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Uni ŋako, Juda unindo toworo, uratoka khumoní, yero taŋgurí. Quko komo uni kato, ŋuko Rom uni ka, yi iŋanowó, ŋunde ŋuro noya kuma unindoya oro kandeye moŋgo re toŋetowó. ");
INSERT INTO nca_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ko nondo do murí karo mande khono rotaŋgurí ŋuro iŋowero quro rero huru-huruyemo utowó. ");
INSERT INTO nca_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Uro ŋande iŋanowó, ko o taró ŋuko hutuŋo mandeye naŋge karóŋaró, norendo urato khumowero qu kini, ko kusi-kusi yano rotowero qu kini. ");
INSERT INTO nca_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Asa uni kumimbo, uni ŋu urato khumoní, yero mande kusiyoyi mande ŋu nono tunoqaró. Ŋunde ŋuro nondo asáŋowe keno uró ŋu. Kowe no unindo uni ŋa mande khono rotowero ye iŋoteŋgo ŋu yimirowe ene ŋuya keno uro iŋo-iŋoye toŋeŋgemo yewaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Sokome ŋunde nakayáŋoro riní kuma unindo mandí howero Pol rero Antipatiris yendémo ŋuno suwono uŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Saraŋoní kuma uni khímo uyareyaŋgo ŋu rohoréŋoro yano pitu ko oŋgurí. Ko kuma uni hosi saŋano kunditaŋgurí ŋundo naŋge Pol rero Sisaria uyaŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Uyate Sisaria oro sokome ŋu rero wiri yerete uni ŋu inaŋgurí, ko Pol ŋuya re mahi toŋímo kaŋaró. ");
INSERT INTO nca_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Wiri yerete uni ŋundo sokome ŋu weyoro Pol oseseyaró, “Ke do mira ka noŋgo qu?” Yiní yaró, “Noko Silisia noŋgo qu.” ");
INSERT INTO nca_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Yiní yaró, “Uni mande khono korotowero ye iŋoteŋgo ŋundo mahikata mande kho ŋu tewano.” Yero ŋande yimiraró, “Reya uya wiri yerete uni Herotko yano ŋuno sopoyoyi.” ");
INSERT INTO nca_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Asa kosa naru kandeka ŋunde rotoro o qa-qa unindoro tapá uni Ananias ŋuya uni kembé kumimboya maŋgó uni owí Teritulus ŋuya ŋuno uŋgurí. Uro wiri yerete uni mitoro do murí karo Pol rero mande khono rotaŋgurí ŋuro miraŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Miroyi Pol nekoní mahiní Teritulusko ŋu murí ŋuro ŋande yaró, “Uni parámi Feliks, naru piruko ŋuno keto nore wiri niri meté kunditeyoteto. Iŋondutuke meté ŋundo nore samaka nerero keto o piyimi qundo noreŋo wini qu rambaruru nereyaró ŋu roŋgaruwaró. ");
INSERT INTO nca_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ŋunde ŋuroko Feliks, keko uni meté horé, ko nore naru rokóŋoro ŋuro yuŋguna kereyoteto. ");
INSERT INTO nca_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Quko yate nondo naru piru kusi kerewano koro. Meté keŋo newonde metémboro naŋge mande tukuni ka iŋo. ");
INSERT INTO nca_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Nore ŋande iŋoteto, ko uni ŋano qundo otete piyimi horé teyote. Enendo kiro kuma riní Juda uni soso keweroyemo ko mira yendé soso ŋuno tunoqeyote. Eneko Nasaret yendé uni karo usowo-sowo quro uni korete-koreteye. ");
INSERT INTO nca_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","Ko Ya Surumí ŋu ŋuya riní pusú tewero taró, quko toworo kusiyatowó. ");
INSERT INTO nca_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ŋunde ŋuro keŋombo uni ŋu oseseyoya eneŋo maŋgó moŋgo o soso norendo ŋuro rero mande khono rotatowó ŋu iŋoweya.” ");
INSERT INTO nca_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ŋunde yiní Juda unindo ŋuya samakaŋoro ŋande yesowaŋgurí, “Mande ŋu soso hamó.” ");
INSERT INTO nca_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Asa wiri yerete uni ŋu kandímbo rokóŋoníqo, Polko mande topé ŋande yaró, “No iŋoteno, kumima naru qambu ke unipare ŋaro ronda-ronda uniye yora. Ŋunde ŋuro niŋgu-niŋgu tero mandeye topé yewe teteno. ");
INSERT INTO nca_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Keto uni osese yereweya tiníqo, ke ŋande iŋoweya, ko nondo komo kosa naru 12 amena Anutuko potoruku te inowero Yerusalem ŋuno onowó. ");
INSERT INTO nca_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Uni mande kho nunoyoteŋgo ŋundo no niyi eneya mande saŋgirí Ya Surumímo ŋuno kama yanowó, ko huru-huru yaye kumimo ŋunope ma yendémo unipare qambu kama okoko yerenowó. Kini. ");
INSERT INTO nca_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ko mande ŋa yero no norero mande khono norotaŋgo ŋako, enendo mande kho ŋuro murí hamó ŋu ri tunoqewero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Quko nondo mande ka keno yewe teteno. Khe ŋaro eneŋombo ŋande ye nekoteŋgo, ‘Usowo-sowo,’ ŋuko no hamó howeyoteno. Nondo Khe ŋu howero usi-sinanimboro Anutuye ŋuro potoruku te inoyoteno. Nondo Hutuŋo Mande soso koya Ye-ye Unindo mande nakayáŋaŋgurí ŋuya soso iŋondutuwoyoteno. ");
INSERT INTO nca_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Uni mande kho nunoyoteŋgo ŋaya noya o kanata quro kondé iŋoyoteto, ko Anutuko uni soso khumaŋgurí mu, asa uni roneneŋowímboya uni piyimimboya soso yoriní pitu ko otoqowaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ŋunde ŋuro no naru rokóŋoro Anutu toŋímo ko unipare toŋeyemo ŋuya no kondé tero otete sopowero quro iŋo-iŋone ŋu rewe roneneŋoní o piyimi ka kama teyoteno. ");
INSERT INTO nca_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“No kumima naru kumimo mira meyowomo yate pitu ko ŋano mahenowó. Nondo mone siyoro sitú topo-topone otoro tukuni teyaŋgo ŋu samaka yerenowó, ko o qa-qa Anutu te inowero qu se mahenowó. ");
INSERT INTO nca_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ŋunde tanowó, ko Anutu toŋímo sara tunoqewero otete ka tero Ya Surumímo ŋuro quroko oweqo, no niyaŋgurí. Unipare soŋga ta naŋge noya yatowó. Ko norendo niri parámi ka kama tatowó. ");
INSERT INTO nca_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Quko Juda uni kumimbo Esia mira parámi moŋgo qu Ya Surumímo ŋuno yaŋgurí. Uni ŋundo meté mahero toŋeŋgemo kaŋero mande kho nunowaŋgo, peka. ");
INSERT INTO nca_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ŋunde kini tiníqo, asa uni ŋano qundo no Sanedrin toŋeyemo kaŋanowó quno do quhurí ka nono qeneŋgurí ŋu meté yewaŋgo. ");
INSERT INTO nca_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Mande kanata karo mande kho nunoyoteŋgo naŋge, peka. Ŋu naruko ŋuno nondo keweroyemo kaŋero kondé ŋande kiwanowó, ‘No unipare khumaŋgurí qundo pitu ko otoqowaŋgo ŋuro iŋondutuwoyoteno. Ŋunde ŋuroko no norero mande khono norotoyoteŋgo ŋa.’” ");
INSERT INTO nca_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliksiko Khe ŋuro komo iŋaró, ŋunde ŋuro ŋande yaró, “Imemoŋgo kuma unindoro uni kembé, Lisias ŋu, mahe umbuníqota nondo mande ŋa roŋgaruwowano,” yero Juda uni asá yiriní toŋeŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ko enendo kuma unindoro sopo-sopo uniye ŋu mironí Pol sopoyuri, quko kondé ma kusiyowero, eneŋo topé-topémbo o qímboro se mahewaŋgo, yaró. ");
INSERT INTO nca_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Imemoŋgo ta Feliks koya parí Durusila koya mahiriyó. Durusila ŋuko Juda pare ka. Ko Feliksiko Pol nekoní mahero unipareto Yesu ŋuko Kristo ŋu iŋondutu teyoteŋgo ŋuro yiní iŋaró. ");
INSERT INTO nca_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Polko otete roneneŋowí ŋuro yaró, ko uni kato eneŋo meté sopoyote ŋuro yaró, ko imemoŋgo Anutuko unipare ronda yereweya ŋuro yaró. Ŋunde yiníqo, Feliks sasaro tero yaró, “Koro ŋu! Toŋe. Imemoŋgo naru ka yoníqo, neko kerewe maheweya.” ");
INSERT INTO nca_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ŋunde yaró, quko oka karo ŋuya ŋande ye iŋaró, ko Polko peka kina rotowero ŋuro mone ka inoweya, peka. Ŋunde ŋuro naru qambu nekoní mahiní ŋuya mande yeyari. ");
INSERT INTO nca_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Yate-yate kumima naru irisa ŋunde rotoro Posias Festus ŋundo Feliks mepé raró. Ko Feliksiko, Juda uni eneŋo metéŋowaŋgo, ye iŋoro Pol rotoní kusi-kusi yano yaró. ");
INSERT INTO nca_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Asa Festus ŋu Judia mirako mahiníqota kosa naru kapusa kini tiní Sisaria yendé rotoro Yerusalem oró. ");
INSERT INTO nca_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Oní o qa-qa unindoro tapá uni kumimboya Juda koro uni pará-parámboya eneno uyaro Pol mande kho inoyaŋgurí. Ene kondé eneya ŋandiro yaŋgurí, ");
INSERT INTO nca_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","“Keto noreŋo metéŋoya uni ŋu ri Yerusalem areweya.” Ŋunde yaŋgurí, dokoro kheko sóqero, Pol uratoka khumoní, yero taŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Asa Festusko mande topé yaró, “Pol Sisaria ŋuno kusi-kusi yano yote, ko naru tukuni ta neneŋombo Sisaria uwano. ");
INSERT INTO nca_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ŋunde ŋuro tapá uniye muko noya uwato. Ko uni ŋuro quhuríŋo ka yote tiníqo, asa enendo rero mande khono rotowaŋgo.” ");
INSERT INTO nca_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festus eneya yotoro naru kande saŋiyoro kapusape ma kande irisa ŋunde rotoro Sisaria uró. Uní saraŋoníqo, mande kho inowero yakutímo kunditero yimiraró, Pol re mahi qembe, yaró. ");
INSERT INTO nca_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ri mahiní Juda uni Yerusalem rotoro umbuŋgurí qundo wuririyoro mande quhurí yero saŋgawaŋgurí. Quko mandeyemboro murí hamó wisiyowero mepémo kini. ");
INSERT INTO nca_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Asa Polko mandeye topé ŋande yaró, “Nondo o piyimi ka kama tanowó. Nondo Juda unindoro hutuŋo mande qu kama karóŋanowó, ko Ya Surumínani kama roworemanowó, ko Sisa mandí kama wendaqanowó.” ");
INSERT INTO nca_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Yiní Festus ŋundo Juda uni meté yerewero Pol ŋande oseseyaró, “Ke date iŋote, meté oyika nondo o quhurí ŋaro Yerusalem ŋuno iŋowanope ma kini?” ");
INSERT INTO nca_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Polko ŋande yaró, “No itaka Sisa koro ya ŋano naŋge kaŋewe mande kho ŋu iŋoweya ŋuro yeteno. Ya meyowo ŋuno kaŋewero mepémo kini. Ke ŋande iŋote, noko Juda uniko ŋuno o piyimi ka kama tanowó. ");
INSERT INTO nca_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Quko no oka khumowero quro tanowó tiníqo, meté nuri khumowano. Quko kota mande yero no norero mande khono norototeŋgo tiníqo, asa uni kato norero kandeyemo rotowero wimbí moré kini. Nondo Sisa nekowe roŋgaru nereweya.” ");
INSERT INTO nca_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ŋunde yiní Festus koya eneŋo iŋo-iŋo uniyómboya epe mito-mito tero ŋande yaró, “Ke Sisa nekote. Ŋunde ŋuro eneno oweya.” ");
INSERT INTO nca_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Imemoŋgo ta wiri yerete uni ka, owí muko Agripa, koya kuwí Berinais koya Sisaria mahero Festus koya naru meté yariyó. ");
INSERT INTO nca_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Irisa ŋu Sisaria yendémo ŋuno naru piru yariyó, ŋunde ŋuro Festus koya wiri yerete uni ŋuya Pol koro sowo mande ŋuro epe mito-mito tariyó. Festusko ŋande yaró, “Komo Feliksiko uni ka rotoní kusi-kusi yano yora. Itaka yote. ");
INSERT INTO nca_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Komo no Yerusalem ŋuno owé o qa-qa unindoro tapá unindoya Juda koro uni kembé-kembéyembo mande kho inoro ŋande kira nereŋgurí, ko meté Pol urato khumoweya. ");
INSERT INTO nca_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Mandeye topé yanowó, ‘Noreko Rom, noreŋo murínani ŋandiro, uni ka kina kama urato khumoweya. Kini, koretero uni ŋundo danimbo mande kho inoyoteŋgo quro toŋeyemo kaŋero mandeye topé yeweya.’ ");
INSERT INTO nca_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Asa ko uni pará-pará ŋundo nono mahiqo, mondó kama yoranowó. Kini, saraŋoníqo mande kho inowero yakutímo kunditero uni ŋu re mahi qembe yanowó. ");
INSERT INTO nca_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ri mahiní eneŋo saŋgiríŋo ŋundo kaŋero mande kho inoyaŋgurí, quko o piyimi taró ŋuko o enesó naŋge. Komo o ŋunde quro kama iŋoyanowó. ");
INSERT INTO nca_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Kini, eneŋo yambo haririyemboro murí yero uni ka khumaró qu, owí muko Yesu, ŋuro kiro kuma yeyaŋgurí. Polko uni khumaró ŋuro, toŋí yote, yaró. ");
INSERT INTO nca_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","No mande murí ŋu seqanowó, quko no ŋu wisiyowero mepémo kini. Asa ko nondo oseseyanowó, ‘Kepe meté Yerusalem oyika nondo o quhurí ŋuro ŋuno iŋowano?’ yanowó. ");
INSERT INTO nca_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Quko Polko yaró, ene kusi-kusi yano yowero iŋote, ko imemoŋgo wiri yerete uni parámi horé eneŋombo mande ŋu roŋgaruwoweya. Ŋunde ŋuro nondo kusi-kusi yano yoní yanowó, imemoŋgo nondo asáŋowe Sisa ŋuno oweya.” ");
INSERT INTO nca_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ŋunde yiní Agripako Festus miraró, “No neneŋo naŋge uni ŋu iŋowero iŋoteno.” Yiní yaró, “Kuyepo keto meté iŋoweya.” ");
INSERT INTO nca_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Asa saraŋoníqo, Agripa koya Berinais koya o nakayá qambu tero kuma unindoro uni kembémboya yendé uni pará-parámboya huru-huru yano maheŋgurí. Mahi Festusko yiní unindo Pol re maheŋgurí. ");
INSERT INTO nca_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Mahi ŋande yaró, “Wiri yerete Uni Agripa, ko ye uni soso noreya yoteto qu, ye uni ŋa qeni. Juda unipare soso, Yerusalem yoteŋgo quya ŋano quyako uni ŋaro osese nerero kondé nekoyaŋgurí, ‘Uni piyimi ŋunde qundo yowero mepémo kini.’ ");
INSERT INTO nca_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Quko nondo qeneteno quko ene oka kama taró ŋuro tero kama khumoweya. Quko eneŋombo wiri yerete uni parámi horé ŋu nekoní roŋgaruwoweya. Ŋunde ŋuro tero nondo mande kusiyoro asáŋowe toŋeweya. ");
INSERT INTO nca_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Quko nondo eneŋo mande date nakayáŋowe uni paráminemo owero quro kama iŋoteno. Ŋunde ŋuro, nondo uni ŋa yeno re maheteno, ko Wiri yerete Uni Agripa, keno ŋuya re maheteno. Nore soso eneŋo murí seqatoqota nondo mande hamó ka meté nakayáŋowano. ");
INSERT INTO nca_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Dokoro mande ka kama yero kina kusiyoro asáŋowano tiníqo, ore piyimi howeyowano.” ");
INSERT INTO nca_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Asa Agripako Pol miraró, “Ke keŋo mande qu ye.” Ŋunde ŋuro Pol kandí hokoro mande ŋande yaró, ");
INSERT INTO nca_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Wiri yerete Uni Agripa, iŋo. Itaka no toŋeŋgemo kaŋero Juda unindoro mandeye soso topé yewano. Ŋundiro puriŋo ka reteno. ");
INSERT INTO nca_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Hamó, keko Juda uniparetoro muríye iŋomukote, ko o kumi ŋuro kiro kuma yeyoteŋgo ŋuro iŋomukote. Ŋunde ŋuro ŋande osese kereyoteno, mandene ŋa iŋoya waka ta ma piyimiŋowero. ");
INSERT INTO nca_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Juda uni soso ŋundo khe u-une, asa no miranemo simó yorano qu noŋgo yate Yerusalem ŋuno yoranowó quro iŋomukoteŋgo. ");
INSERT INTO nca_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Naru piru no iŋo nunoyaŋgurí, ko enendo nuŋgurí tiníqo, nene muríne meté yewaŋgo. Ŋande iŋoyoteŋgo, ko noko Farisi unindo otete qu howeyano. Wini ŋundo noreŋo hutuŋo mande okeyá ta hamó horé howeyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ko itaka komo Anutuko usi-sinanimboya mande ka kusiyaró quro no mande khono kaŋeyoteno. ");
INSERT INTO nca_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Norendo wini qu 12 ŋundo kosano suwono Anutuko mande kusiyowí riní o meté mu tunoqeweya ŋuro iŋoro soporo eneŋo khoyó teyoteto. Asa, Wiri yerete Uni, iŋo. O meté mu tunoqeweya ŋuro naŋge Juda unindo mande kho nunoyoteŋgo. ");
INSERT INTO nca_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Do karo ye kato Anutuko uni khumaró mu riní otoqaró ŋuro iŋondataqeyoteŋgo? ");
INSERT INTO nca_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Komo no neneŋombo o qambu tero, Yesu Nasaret noŋgo ŋu owí rewe umbuweya, kondé ye iŋanowó. ");
INSERT INTO nca_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ko no Yerusalem ŋuno ŋunde tanowó. No o qa-qa unindoro tapá uni noŋgo wimbu rero unipare meté horé ŋu yorero kusi-kusiko yorotanowó. Ko mande khono kaŋiqo, uni pará-parámbo, yurato khumowaŋgo, yaŋgurí quno no ŋuya ŋunde yanowó. ");
INSERT INTO nca_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ko naru parámi nondo huru-huru ya enemo-enemo seqa yerero yondoworo enendo Anutu yesaráŋowero kondé yimitoyanowó. Hamó, nondo eneya newonde saŋgirí naŋge tero yendé sewemo ŋuno ŋuya yohowero o piyimi te yunoyanowó. ");
INSERT INTO nca_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Naru kano o ŋunde tewero quro khendo unowó. Komo o qa-qa unindoro tapá uni noŋgo wimbu rewe Damaskus yendémo ŋuno asá niri unowó. ");
INSERT INTO nca_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Asa Wiri yerete Uni Meté, iŋo. Kosa keweroko khewore uroqo no sambo saŋano hiyó kako kosa koro hiyó takaró qu qenenowó. Hiyó ŋuko noya uni noya mahetowó ŋuya noreno parámi hiyóqaró. ");
INSERT INTO nca_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Nore soso rokaráŋoro nokono umbutowó, ko no maŋgo ka Hibru mandeko iŋanowó. Ŋande yaró, ‘Sol, Sol, ke do karo no rambaruru nereyote? Keto tisi ka pitoro keŋo ŋuya rambaruru teyote.’ ");
INSERT INTO nca_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Ko nondo yanowó, ‘Uni Parámi, ke dani?’ “Ko Uni Parámimbo yaró, ‘Noko Yesu, keto no rambaruru nereyote. ");
INSERT INTO nca_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Quko ke otoqoya kaŋe. Nondo ke neneŋo kho qu kunowero keno tunoqeteno. Ko neneŋo o qu itaka qenete ko imemoŋgo witú kerewano ŋuro yesowoweya, ŋuro rokó kereteno. ");
INSERT INTO nca_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nondo keŋo wini qu kandeye moŋgo ko uni wini meyowo kandeye moŋgo ŋuya ta kerewano. Nondo asá kerewe toŋero ");
INSERT INTO nca_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","eneŋo toŋeye ri hiyóqiní huriri rotoro hiyómo owaŋgo, ko Monimbu koro wimbí rotoro Anutuko owaŋgo. Ŋunde ŋuro tero nondo quhuríye se rotoweqo, enendo unipareto iŋondutu nerero meté horé yoteŋgo ŋuya yuri.’ ");
INSERT INTO nca_vpl VALUES ("AC26_19","074_26_1